
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  149 ( 1185),  selected  149 , name 2g0f_A
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2g0f_A.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    36_A      E       1           -
LGA    E    37_A      N       2           -
LGA    S    38_A      L       3           -
LGA    A    39_A      Y       4           -
LGA    L    40_A      F       5           -
LGA    I    41_A      Q       6           -
LGA    G    42_A      S       7           -
LGA    -       -      M       8           -
LGA    K    43_A      I       9           #
LGA    P    44_A      N      10          3.815
LGA    -       -      S      11           -
LGA    V    45_A      F      12          2.259
LGA    P    46_A      Y      13           -
LGA    K    47_A      A      14          5.364
LGA    F    48_A      F      15          3.682
LGA    R    49_A      E      16          2.775
LGA    L    50_A      V      17          1.886
LGA    E    51_A      K      18          1.066
LGA    S    52_A      D      19          0.561
LGA    L    53_A      A      20          1.089
LGA    D    54_A      -       -           -
LGA    N    55_A      K      21          3.471
LGA    P    56_A      G      22          3.422
LGA    G    57_A      -       -           -
LGA    Q    58_A      R      23          2.068
LGA    F    59_A      T      24          1.136
LGA    Y    60_A      V      25          2.010
LGA    Q    61_A      S      26          3.195
LGA    A    62_A      -       -           -
LGA    D    63_A      L      27          3.555
LGA    V    64_A      E      28          3.235
LGA    L    65_A      K      29           #
LGA    T    66_A      Y      30          4.021
LGA    Q    67_A      K      31          2.808
LGA    G    68_A      G      32          0.930
LGA    K    69_A      K      33          2.234
LGA    P    70_A      V      34          1.106
LGA    V    71_A      S      35          1.629
LGA    L    72_A      L      36          1.158
LGA    L    73_A      V      37          1.183
LGA    N    74_A      V      38          1.830
LGA    V    75_A      N      39          1.367
LGA    W    76_A      V      40          0.385
LGA    A    77_A      A      41          1.149
LGA    T    78_A      S      42          1.580
LGA    W    79_A      D      43          2.955
LGA    C    80_A      C      44          2.759
LGA    P    81_A      Q      45          2.048
LGA    T    82_A      L      46          1.067
LGA    C    83_A      T      47          2.531
LGA    R    84_A      D      48          2.452
LGA    A    85_A      R      49          2.296
LGA    E    86_A      N      50          1.842
LGA    H    87_A      Y      51          1.240
LGA    Q    88_A      L      52          1.413
LGA    Y    89_A      G      53          1.965
LGA    L    90_A      L      54          1.868
LGA    N    91_A      K      55          1.841
LGA    Q    92_A      E      56          1.916
LGA    L    93_A      L      57          2.042
LGA    S    94_A      H      58          2.038
LGA    A    95_A      K      59          1.985
LGA    Q    96_A      E      60          1.492
LGA    G    97_A      F      61          2.813
LGA    I    98_A      G      62          3.619
LGA    -       -      P      63           -
LGA    -       -      S      64           -
LGA    -       -      H      65           -
LGA    -       -      F      66           -
LGA    R    99_A      S      67          2.249
LGA    V   100_A      V      68          1.232
LGA    V   101_A      L      69          1.370
LGA    G   102_A      A      70          1.130
LGA    M   103_A      F      71          1.159
LGA    N   104_A      P      72          1.335
LGA    Y   105_A      C      73          1.650
LGA    K   106_A      N      74          3.148
LGA    -       -      Q      75           -
LGA    -       -      F      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      S      79           -
LGA    D   107_A      E      80          3.478
LGA    -       -      P      81           -
LGA    -       -      R      82           -
LGA    D   108_A      P      83          3.002
LGA    R   109_A      S      84          1.481
LGA    Q   110_A      K      85          4.407
LGA    K   111_A      E      86          4.027
LGA    A   112_A      V      87          0.965
LGA    I   113_A      E      88          2.546
LGA    S   114_A      S      89          3.579
LGA    W   115_A      F      90          1.672
LGA    L   116_A      A      91          1.221
LGA    K   117_A      R      92          3.111
LGA    E   118_A      K      93          2.701
LGA    L   119_A      N      94          1.789
LGA    G   120_A      Y      95          2.069
LGA    N   121_A      G      96          3.987
LGA    P   122_A      V      97          2.609
LGA    Y   123_A      T      98          4.409
LGA    A   124_A      F      99          2.784
LGA    L   125_A      P     100          1.833
LGA    S   126_A      I     101          2.007
LGA    L   127_A      F     102          1.621
LGA    F   128_A      H     103          1.388
LGA    D   129_A      K     104          3.530
LGA    G   130_A      I     105          2.797
LGA    D   131_A      K     106          3.045
LGA    G   132_A      I     107          3.144
LGA    -       -      L     108           -
LGA    -       -      G     109           -
LGA    -       -      S     110           -
LGA    -       -      E     111           -
LGA    M   133_A      G     112          2.133
LGA    L   134_A      E     113          2.651
LGA    -       -      P     114           -
LGA    G   135_A      A     115           #
LGA    L   136_A      F     116          5.819
LGA    D   137_A      R     117          0.883
LGA    -       -      F     118           -
LGA    L   138_A      L     119          3.164
LGA    G   139_A      V     120          2.982
LGA    -       -      D     121           -
LGA    -       -      S     122           -
LGA    -       -      S     123           -
LGA    -       -      K     124           -
LGA    -       -      K     125           -
LGA    V   140_A      E     126          3.020
LGA    Y   141_A      P     127          1.922
LGA    -       -      R     128           -
LGA    G   142_A      W     129          2.972
LGA    A   143_A      N     130          1.627
LGA    A   144_A      F     131          1.001
LGA    E   145_A      W     132          1.073
LGA    T   146_A      K     133          1.164
LGA    F   147_A      Y     134          1.075
LGA    L   148_A      L     135          0.966
LGA    I   149_A      V     136          0.970
LGA    D   150_A      N     137          0.983
LGA    G   151_A      P     138          0.995
LGA    N   152_A      E     139          1.090
LGA    G   153_A      G     140          0.805
LGA    I   154_A      Q     141          1.011
LGA    I   155_A      V     142          0.813
LGA    R   156_A      V     143          1.072
LGA    Y   157_A      K     144          0.843
LGA    R   158_A      F     145          0.655
LGA    H   159_A      W     146          0.658
LGA    A   160_A      R     147          1.454
LGA    G   161_A      P     148          0.645
LGA    D   162_A      E     149          4.587
LGA    L   163_A      E     150          5.509
LGA    N   164_A      P     151          2.828
LGA    P   165_A      I     152          3.401
LGA    R   166_A      E     153          2.976
LGA    V   167_A      V     154          2.481
LGA    W   168_A      I     155          2.704
LGA    E   169_A      -       -           -
LGA    E   170_A      -       -           -
LGA    E   171_A      -       -           -
LGA    I   172_A      -       -           -
LGA    K   173_A      R     156          2.710
LGA    P   174_A      P     157          2.863
LGA    L   175_A      D     158          2.216
LGA    W   176_A      I     159          1.903
LGA    E   177_A      A     160          2.731
LGA    K   178_A      A     161          2.782
LGA    Y   179_A      L     162          2.047
LGA    S   180_A      V     163          1.756
LGA    K   181_A      R     164          2.644
LGA    E   182_A      Q     165          2.385
LGA    A   183_A      V     166          2.072
LGA    A   184_A      I     167          2.135
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  149  174    5.0    131    2.45    11.45     49.498     5.135

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.463537 * X  +   0.882219 * Y  +   0.082603 * Z  +  35.178253
  Y_new =  -0.528652 * X  +  -0.200537 * Y  +  -0.824810 * Z  + 162.043167
  Z_new =  -0.711098 * X  +  -0.425998 * Y  +   0.559343 * Z  +  -5.120654 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.650887    2.490706  [ DEG:   -37.2931    142.7069 ]
  Theta =   0.791059    2.350534  [ DEG:    45.3243    134.6757 ]
  Phi   =  -2.290661    0.850932  [ DEG:  -131.2452     48.7548 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2g0f_A                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2g0f_A.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  149  174   5.0  131   2.45   11.45  49.498
REMARK  ---------------------------------------------------------- 
MOLECULE 2g0f_A
HEADER    OXIDOREDUCTASE                          12-FEB-06   2G0F              
TITLE     CRYSTAL STRUCTURE OF P144A MUTANT OF E.COLI CCMG PROTEIN              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOL:DISULFIDE INTERCHANGE PROTEIN DSBE;                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 36-184;                                           
COMPND   5 SYNONYM: CCMG PROTEIN, CYTOCHROME C BIOGENESIS PROTEIN               
COMPND   6 CCMG;                                                                
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: CCMG;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-3A                                    
KEYWDS    E.COLI CCMG, P144A MUTANT, CIS-TO-TRANS CONFIGURATION CHANGE          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.OUYANG,Y.G.GAO,H.Y.HU,Z.X.XIA                                       
REVDAT   1   05-DEC-06 2G0F    0                                                
JRNL        AUTH   N.OUYANG,Y.G.GAO,H.Y.HU,Z.X.XIA                              
JRNL        TITL   CRYSTAL STRUCTURES OF E. COLI CCMG AND ITS MUTANTS           
JRNL        TITL 2 REVEAL KEY ROLES OF THE N-TERMINAL BETA-SHEET AND            
JRNL        TITL 3 THE FINGERPRINT REGION                                       
JRNL        REF    PROTEINS                      V.  65  1021 2006              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2G0F A   19   185  UNP    P0AA86   DSBE_ECOLI      19    185             
SEQRES   1 A  168  MET ALA LEU LEU TRP GLN LEU ALA ARG ASN ALA GLU GLY          
SEQRES   2 A  168  ASP ASP PRO THR ASN LEU GLU SER ALA LEU ILE GLY LYS          
SEQRES   3 A  168  PRO VAL PRO LYS PHE ARG LEU GLU SER LEU ASP ASN PRO          
SEQRES   4 A  168  GLY GLN PHE TYR GLN ALA ASP VAL LEU THR GLN GLY LYS          
SEQRES   5 A  168  PRO VAL LEU LEU ASN VAL TRP ALA THR TRP CYS PRO THR          
SEQRES   6 A  168  CYS ARG ALA GLU HIS GLN TYR LEU ASN GLN LEU SER ALA          
SEQRES   7 A  168  GLN GLY ILE ARG VAL VAL GLY MET ASN TYR LYS ASP ASP          
SEQRES   8 A  168  ARG GLN LYS ALA ILE SER TRP LEU LYS GLU LEU GLY ASN          
SEQRES   9 A  168  PRO TYR ALA LEU SER LEU PHE ASP GLY ASP GLY MET LEU          
SEQRES  10 A  168  GLY LEU ASP LEU GLY VAL TYR GLY ALA ALA GLU THR PHE          
SEQRES  11 A  168  LEU ILE ASP GLY ASN GLY ILE ILE ARG TYR ARG HIS ALA          
SEQRES  12 A  168  GLY ASP LEU ASN PRO ARG VAL TRP GLU GLU GLU ILE LYS          
SEQRES  13 A  168  PRO LEU TRP GLU LYS TYR SER LYS GLU ALA ALA GLN              
FORMUL   2  HOH   *58(H2 O)                                                     
CRYST1   35.416   47.783   85.432  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   LEU A  36      29.810  92.494  13.294  1.00 73.40           N  
ATOM      2  CA  LEU A  36      30.953  91.557  13.102  1.00 72.69           C  
ATOM      3  C   LEU A  36      32.157  92.250  12.461  1.00 71.58           C  
ATOM      4  O   LEU A  36      32.195  93.480  12.340  1.00 71.29           O  
ATOM      5  CB  LEU A  36      30.525  90.365  12.235  1.00 73.95           C  
ATOM      6  CG  LEU A  36      29.518  89.359  12.806  1.00 74.90           C  
ATOM      7  CD1 LEU A  36      30.130  88.672  14.021  1.00 75.13           C  
ATOM      8  CD2 LEU A  36      28.213  90.057  13.177  1.00 74.82           C  
ATOM      9  N   GLU A  37      33.137  91.449  12.050  1.00 69.28           N  
ATOM     10  CA  GLU A  37      34.350  91.971  11.431  1.00 66.44           C  
ATOM     11  C   GLU A  37      34.090  92.715  10.123  1.00 62.33           C  
ATOM     12  O   GLU A  37      33.071  92.505   9.459  1.00 61.42           O  
ATOM     13  CB  GLU A  37      35.346  90.831  11.183  1.00 68.55           C  
ATOM     14  CG  GLU A  37      36.576  91.253  10.387  1.00 71.58           C  
ATOM     15  CD  GLU A  37      37.377  92.349  11.073  1.00 73.75           C  
ATOM     16  OE1 GLU A  37      38.171  93.024  10.382  1.00 73.84           O  
ATOM     17  OE2 GLU A  37      37.221  92.530  12.301  1.00 75.00           O  
ATOM     18  N   SER A  38      35.023  93.593   9.765  1.00 56.64           N  
ATOM     19  CA  SER A  38      34.922  94.364   8.535  1.00 51.28           C  
ATOM     20  C   SER A  38      36.220  94.298   7.742  1.00 47.78           C  
ATOM     21  O   SER A  38      37.313  94.417   8.294  1.00 46.85           O  
ATOM     22  CB  SER A  38      34.587  95.828   8.840  1.00 50.13           C  
ATOM     23  OG  SER A  38      34.563  96.604   7.654  1.00 43.29           O  
ATOM     24  N   ALA A  39      36.087  94.099   6.438  1.00 44.57           N  
ATOM     25  CA  ALA A  39      37.236  94.029   5.557  1.00 41.95           C  
ATOM     26  C   ALA A  39      37.575  95.436   5.080  1.00 39.35           C  
ATOM     27  O   ALA A  39      38.499  95.630   4.292  1.00 39.09           O  
ATOM     28  CB  ALA A  39      36.923  93.132   4.369  1.00 43.20           C  
ATOM     29  N   LEU A  40      36.821  96.416   5.570  1.00 35.48           N  
ATOM     30  CA  LEU A  40      37.038  97.804   5.185  1.00 32.99           C  
ATOM     31  C   LEU A  40      37.996  98.553   6.102  1.00 29.83           C  
ATOM     32  O   LEU A  40      38.361  99.691   5.819  1.00 28.17           O  
ATOM     33  CB  LEU A  40      35.701  98.544   5.125  1.00 34.33           C  
ATOM     34  CG  LEU A  40      34.815  98.214   3.921  1.00 35.89           C  
ATOM     35  CD1 LEU A  40      33.457  98.874   4.085  1.00 35.01           C  
ATOM     36  CD2 LEU A  40      35.493  98.696   2.643  1.00 36.19           C  
ATOM     37  N   ILE A  41      38.411  97.918   7.192  1.00 26.98           N  
ATOM     38  CA  ILE A  41      39.326  98.570   8.118  1.00 27.22           C  
ATOM     39  C   ILE A  41      40.670  98.822   7.447  1.00 25.33           C  
ATOM     40  O   ILE A  41      41.320  97.893   6.974  1.00 24.65           O  
ATOM     41  CB  ILE A  41      39.551  97.728   9.393  1.00 27.26           C  
ATOM     42  CG1 ILE A  41      38.204  97.354  10.022  1.00 30.03           C  
ATOM     43  CG2 ILE A  41      40.401  98.508  10.379  1.00 27.58           C  
ATOM     44  CD1 ILE A  41      37.249  98.522  10.222  1.00 30.77           C  
ATOM     45  N   GLY A  42      41.072 100.087   7.408  1.00 24.58           N  
ATOM     46  CA  GLY A  42      42.332 100.448   6.786  1.00 24.52           C  
ATOM     47  C   GLY A  42      42.155 100.854   5.337  1.00 26.40           C  
ATOM     48  O   GLY A  42      43.110 101.281   4.684  1.00 27.66           O  
ATOM     49  N   LYS A  43      40.934 100.720   4.827  1.00 25.80           N  
ATOM     50  CA  LYS A  43      40.634 101.084   3.448  1.00 27.11           C  
ATOM     51  C   LYS A  43      39.789 102.356   3.394  1.00 26.65           C  
ATOM     52  O   LYS A  43      39.086 102.682   4.345  1.00 25.59           O  
ATOM     53  CB  LYS A  43      39.889  99.941   2.746  1.00 29.11           C  
ATOM     54  CG  LYS A  43      40.676  98.633   2.678  1.00 33.40           C  
ATOM     55  CD  LYS A  43      39.852  97.524   2.039  1.00 38.08           C  
ATOM     56  CE  LYS A  43      40.573  96.176   2.082  1.00 41.53           C  
ATOM     57  NZ  LYS A  43      41.856  96.185   1.317  1.00 44.06           N  
ATOM     58  N   PRO A  44      39.862 103.100   2.277  1.00 28.11           N  
ATOM     59  CA  PRO A  44      39.094 104.337   2.115  1.00 27.60           C  
ATOM     60  C   PRO A  44      37.595 104.098   1.954  1.00 26.82           C  
ATOM     61  O   PRO A  44      37.156 103.019   1.563  1.00 26.42           O  
ATOM     62  CB  PRO A  44      39.721 104.969   0.874  1.00 27.73           C  
ATOM     63  CG  PRO A  44      40.156 103.770   0.074  1.00 29.05           C  
ATOM     64  CD  PRO A  44      40.770 102.894   1.132  1.00 28.18           C  
ATOM     65  N   VAL A  45      36.803 105.109   2.271  1.00 26.77           N  
ATOM     66  CA  VAL A  45      35.362 104.980   2.145  1.00 28.09           C  
ATOM     67  C   VAL A  45      35.008 104.754   0.680  1.00 27.06           C  
ATOM     68  O   VAL A  45      35.611 105.352  -0.209  1.00 27.14           O  
ATOM     69  CB  VAL A  45      34.646 106.248   2.672  1.00 27.77           C  
ATOM     70  CG1 VAL A  45      33.161 106.201   2.342  1.00 30.14           C  
ATOM     71  CG2 VAL A  45      34.839 106.351   4.172  1.00 28.12           C  
ATOM     72  N   PRO A  46      34.036 103.871   0.411  1.00 27.29           N  
ATOM     73  CA  PRO A  46      33.612 103.579  -0.963  1.00 28.49           C  
ATOM     74  C   PRO A  46      33.066 104.828  -1.664  1.00 29.06           C  
ATOM     75  O   PRO A  46      32.438 105.687  -1.034  1.00 27.51           O  
ATOM     76  CB  PRO A  46      32.531 102.512  -0.771  1.00 28.61           C  
ATOM     77  CG  PRO A  46      32.974 101.811   0.487  1.00 29.71           C  
ATOM     78  CD  PRO A  46      33.365 102.972   1.367  1.00 28.58           C  
ATOM     79  N   LYS A  47      33.312 104.930  -2.966  1.00 28.43           N  
ATOM     80  CA  LYS A  47      32.826 106.067  -3.731  1.00 29.24           C  
ATOM     81  C   LYS A  47      31.306 105.998  -3.780  1.00 27.79           C  
ATOM     82  O   LYS A  47      30.721 104.912  -3.787  1.00 28.50           O  
ATOM     83  CB  LYS A  47      33.385 106.037  -5.153  1.00 33.57           C  
ATOM     84  CG  LYS A  47      34.897 106.017  -5.230  1.00 38.37           C  
ATOM     85  CD  LYS A  47      35.349 105.766  -6.655  1.00 44.18           C  
ATOM     86  CE  LYS A  47      36.837 105.465  -6.727  1.00 46.86           C  
ATOM     87  NZ  LYS A  47      37.223 105.011  -8.095  1.00 49.40           N  
ATOM     88  N   PHE A  48      30.665 107.158  -3.813  1.00 26.29           N  
ATOM     89  CA  PHE A  48      29.212 107.199  -3.859  1.00 24.80           C  
ATOM     90  C   PHE A  48      28.719 108.579  -4.219  1.00 24.40           C  
ATOM     91  O   PHE A  48      29.484 109.546  -4.234  1.00 25.19           O  
ATOM     92  CB  PHE A  48      28.625 106.784  -2.501  1.00 23.84           C  
ATOM     93  CG  PHE A  48      28.914 107.761  -1.377  1.00 22.40           C  
ATOM     94  CD1 PHE A  48      28.154 108.923  -1.231  1.00 19.65           C  
ATOM     95  CD2 PHE A  48      29.935 107.506  -0.458  1.00 18.75           C  
ATOM     96  CE1 PHE A  48      28.403 109.813  -0.189  1.00 20.92           C  
ATOM     97  CE2 PHE A  48      30.198 108.390   0.593  1.00 18.65           C  
ATOM     98  CZ  PHE A  48      29.432 109.546   0.732  1.00 20.79           C  
ATOM     99  N   ARG A  49      27.431 108.659  -4.511  1.00 24.92           N  
ATOM    100  CA  ARG A  49      26.786 109.920  -4.846  1.00 26.60           C  
ATOM    101  C   ARG A  49      25.374 109.771  -4.316  1.00 25.70           C  
ATOM    102  O   ARG A  49      24.529 109.150  -4.947  1.00 26.80           O  
ATOM    103  CB  ARG A  49      26.772 110.144  -6.363  1.00 29.56           C  
ATOM    104  CG  ARG A  49      26.265 111.518  -6.772  1.00 34.09           C  
ATOM    105  CD  ARG A  49      26.769 111.909  -8.155  1.00 37.47           C  
ATOM    106  NE  ARG A  49      26.444 113.293  -8.500  1.00 38.67           N  
ATOM    107  CZ  ARG A  49      25.215 113.736  -8.753  1.00 39.00           C  
ATOM    108  NH1 ARG A  49      24.180 112.905  -8.702  1.00 36.47           N  
ATOM    109  NH2 ARG A  49      25.020 115.013  -9.062  1.00 37.96           N  
ATOM    110  N   LEU A  50      25.132 110.315  -3.132  1.00 24.86           N  
ATOM    111  CA  LEU A  50      23.820 110.209  -2.513  1.00 25.31           C  
ATOM    112  C   LEU A  50      23.191 111.571  -2.306  1.00 23.16           C  
ATOM    113  O   LEU A  50      23.883 112.574  -2.156  1.00 24.37           O  
ATOM    114  CB  LEU A  50      23.930 109.500  -1.157  1.00 22.95           C  
ATOM    115  CG  LEU A  50      24.345 108.027  -1.149  1.00 24.88           C  
ATOM    116  CD1 LEU A  50      24.467 107.530   0.296  1.00 20.96           C  
ATOM    117  CD2 LEU A  50      23.312 107.209  -1.908  1.00 21.67           C  
ATOM    118  N   GLU A  51      21.870 111.599  -2.295  1.00 22.35           N  
ATOM    119  CA  GLU A  51      21.147 112.841  -2.077  1.00 22.71           C  
ATOM    120  C   GLU A  51      21.006 113.134  -0.576  1.00 23.24           C  
ATOM    121  O   GLU A  51      20.919 112.215   0.251  1.00 20.84           O  
ATOM    122  CB  GLU A  51      19.763 112.751  -2.735  1.00 22.74           C  
ATOM    123  CG  GLU A  51      18.791 113.851  -2.331  1.00 24.45           C  
ATOM    124  CD  GLU A  51      17.473 113.777  -3.087  1.00 23.22           C  
ATOM    125  OE1 GLU A  51      16.993 112.657  -3.352  1.00 24.75           O  
ATOM    126  OE2 GLU A  51      16.911 114.841  -3.408  1.00 25.40           O  
ATOM    127  N   SER A  52      21.010 114.421  -0.235  1.00 22.81           N  
ATOM    128  CA  SER A  52      20.840 114.874   1.141  1.00 23.04           C  
ATOM    129  C   SER A  52      19.423 114.509   1.574  1.00 24.15           C  
ATOM    130  O   SER A  52      18.496 114.591   0.777  1.00 26.21           O  
ATOM    131  CB  SER A  52      21.015 116.388   1.217  1.00 23.29           C  
ATOM    132  OG  SER A  52      20.585 116.900   2.470  1.00 24.20           O  
ATOM    133  N   LEU A  53      19.252 114.113   2.832  1.00 25.00           N  
ATOM    134  CA  LEU A  53      17.932 113.737   3.327  1.00 26.87           C  
ATOM    135  C   LEU A  53      16.996 114.932   3.449  1.00 28.90           C  
ATOM    136  O   LEU A  53      15.850 114.872   3.007  1.00 30.83           O  
ATOM    137  CB  LEU A  53      18.044 113.045   4.693  1.00 25.21           C  
ATOM    138  CG  LEU A  53      16.727 112.663   5.379  1.00 24.29           C  
ATOM    139  CD1 LEU A  53      16.027 111.565   4.598  1.00 24.78           C  
ATOM    140  CD2 LEU A  53      17.010 112.202   6.796  1.00 25.22           C  
ATOM    141  N   ASP A  54      17.480 116.016   4.049  1.00 29.46           N  
ATOM    142  CA  ASP A  54      16.651 117.198   4.226  1.00 31.59           C  
ATOM    143  C   ASP A  54      16.892 118.320   3.222  1.00 30.97           C  
ATOM    144  O   ASP A  54      16.328 119.404   3.350  1.00 31.74           O  
ATOM    145  CB  ASP A  54      16.769 117.723   5.670  1.00 36.03           C  
ATOM    146  CG  ASP A  54      18.178 117.588   6.247  1.00 39.12           C  
ATOM    147  OD1 ASP A  54      18.331 117.776   7.474  1.00 40.56           O  
ATOM    148  OD2 ASP A  54      19.129 117.300   5.491  1.00 40.16           O  
ATOM    149  N   ASN A  55      17.721 118.062   2.217  1.00 28.85           N  
ATOM    150  CA  ASN A  55      17.979 119.060   1.185  1.00 28.09           C  
ATOM    151  C   ASN A  55      17.845 118.419  -0.191  1.00 24.75           C  
ATOM    152  O   ASN A  55      18.837 118.161  -0.875  1.00 23.62           O  
ATOM    153  CB  ASN A  55      19.365 119.673   1.369  1.00 31.95           C  
ATOM    154  CG  ASN A  55      19.439 120.550   2.600  1.00 35.78           C  
ATOM    155  OD1 ASN A  55      18.742 121.560   2.695  1.00 37.87           O  
ATOM    156  ND2 ASN A  55      20.274 120.160   3.559  1.00 38.70           N  
ATOM    157  N   PRO A  56      16.596 118.166  -0.616  1.00 22.92           N  
ATOM    158  CA  PRO A  56      16.269 117.549  -1.905  1.00 22.41           C  
ATOM    159  C   PRO A  56      17.046 118.171  -3.050  1.00 22.44           C  
ATOM    160  O   PRO A  56      17.151 119.391  -3.139  1.00 21.68           O  
ATOM    161  CB  PRO A  56      14.769 117.801  -2.042  1.00 22.35           C  
ATOM    162  CG  PRO A  56      14.306 117.855  -0.623  1.00 21.84           C  
ATOM    163  CD  PRO A  56      15.375 118.667   0.041  1.00 20.91           C  
ATOM    164  N   GLY A  57      17.597 117.332  -3.919  1.00 22.40           N  
ATOM    165  CA  GLY A  57      18.333 117.854  -5.053  1.00 25.05           C  
ATOM    166  C   GLY A  57      19.802 118.129  -4.812  1.00 26.85           C  
ATOM    167  O   GLY A  57      20.540 118.383  -5.760  1.00 28.54           O  
ATOM    168  N   GLN A  58      20.231 118.107  -3.555  1.00 28.65           N  
ATOM    169  CA  GLN A  58      21.640 118.321  -3.238  1.00 29.98           C  
ATOM    170  C   GLN A  58      22.287 116.952  -3.096  1.00 27.19           C  
ATOM    171  O   GLN A  58      21.833 116.138  -2.303  1.00 25.92           O  
ATOM    172  CB  GLN A  58      21.792 119.105  -1.933  1.00 34.64           C  
ATOM    173  CG  GLN A  58      21.439 120.573  -2.054  1.00 43.61           C  
ATOM    174  CD  GLN A  58      21.510 121.298  -0.723  1.00 49.29           C  
ATOM    175  OE1 GLN A  58      22.512 121.216  -0.006  1.00 51.40           O  
ATOM    176  NE2 GLN A  58      20.442 122.017  -0.385  1.00 53.83           N  
ATOM    177  N   PHE A  59      23.340 116.700  -3.869  1.00 26.84           N  
ATOM    178  CA  PHE A  59      24.032 115.413  -3.824  1.00 25.65           C  
ATOM    179  C   PHE A  59      25.450 115.483  -3.256  1.00 26.52           C  
ATOM    180  O   PHE A  59      26.193 116.437  -3.495  1.00 24.18           O  
ATOM    181  CB  PHE A  59      24.047 114.778  -5.219  1.00 22.29           C  
ATOM    182  CG  PHE A  59      22.670 114.433  -5.735  1.00 22.66           C  
ATOM    183  CD1 PHE A  59      21.820 115.428  -6.222  1.00 22.63           C  
ATOM    184  CD2 PHE A  59      22.202 113.126  -5.680  1.00 20.00           C  
ATOM    185  CE1 PHE A  59      20.519 115.123  -6.646  1.00 23.39           C  
ATOM    186  CE2 PHE A  59      20.901 112.809  -6.101  1.00 22.30           C  
ATOM    187  CZ  PHE A  59      20.059 113.810  -6.586  1.00 21.63           C  
ATOM    188  N   TYR A  60      25.811 114.457  -2.492  1.00 27.64           N  
ATOM    189  CA  TYR A  60      27.122 114.382  -1.867  1.00 29.44           C  
ATOM    190  C   TYR A  60      27.915 113.174  -2.333  1.00 28.17           C  
ATOM    191  O   TYR A  60      27.349 112.182  -2.774  1.00 27.90           O  
ATOM    192  CB  TYR A  60      26.972 114.312  -0.352  1.00 32.78           C  
ATOM    193  CG  TYR A  60      26.450 115.577   0.261  1.00 36.40           C  
ATOM    194  CD1 TYR A  60      27.314 116.620   0.585  1.00 38.06           C  
ATOM    195  CD2 TYR A  60      25.089 115.741   0.509  1.00 38.86           C  
ATOM    196  CE1 TYR A  60      26.835 117.801   1.147  1.00 41.00           C  
ATOM    197  CE2 TYR A  60      24.597 116.918   1.068  1.00 41.98           C  
ATOM    198  CZ  TYR A  60      25.477 117.943   1.386  1.00 42.46           C  
ATOM    199  OH  TYR A  60      25.001 119.104   1.952  1.00 44.94           O  
ATOM    200  N   GLN A  61      29.235 113.269  -2.216  1.00 28.49           N  
ATOM    201  CA  GLN A  61      30.119 112.185  -2.606  1.00 29.39           C  
ATOM    202  C   GLN A  61      31.083 111.883  -1.465  1.00 27.23           C  
ATOM    203  O   GLN A  61      31.093 112.580  -0.454  1.00 25.22           O  
ATOM    204  CB  GLN A  61      30.878 112.559  -3.879  1.00 32.51           C  
ATOM    205  CG  GLN A  61      29.958 112.846  -5.056  1.00 40.17           C  
ATOM    206  CD  GLN A  61      30.711 113.094  -6.351  1.00 45.57           C  
ATOM    207  OE1 GLN A  61      31.402 112.209  -6.862  1.00 49.09           O  
ATOM    208  NE2 GLN A  61      30.577 114.301  -6.890  1.00 48.81           N  
ATOM    209  N   ALA A  62      31.889 110.842  -1.635  1.00 27.90           N  
ATOM    210  CA  ALA A  62      32.839 110.414  -0.612  1.00 28.05           C  
ATOM    211  C   ALA A  62      33.765 111.505  -0.079  1.00 29.14           C  
ATOM    212  O   ALA A  62      34.284 111.385   1.035  1.00 30.80           O  
ATOM    213  CB  ALA A  62      33.656 109.246  -1.135  1.00 26.85           C  
ATOM    214  N   ASP A  63      33.972 112.569  -0.849  1.00 30.09           N  
ATOM    215  CA  ASP A  63      34.850 113.643  -0.393  1.00 31.92           C  
ATOM    216  C   ASP A  63      34.311 114.320   0.857  1.00 31.68           C  
ATOM    217  O   ASP A  63      35.072 114.866   1.654  1.00 31.69           O  
ATOM    218  CB  ASP A  63      35.071 114.696  -1.493  1.00 34.60           C  
ATOM    219  CG  ASP A  63      33.777 115.318  -1.997  1.00 36.31           C  
ATOM    220  OD1 ASP A  63      33.115 114.715  -2.872  1.00 37.44           O  
ATOM    221  OD2 ASP A  63      33.422 116.414  -1.516  1.00 36.60           O  
ATOM    222  N   VAL A  64      32.999 114.276   1.037  1.00 32.37           N  
ATOM    223  CA  VAL A  64      32.388 114.899   2.201  1.00 32.93           C  
ATOM    224  C   VAL A  64      32.794 114.173   3.487  1.00 33.10           C  
ATOM    225  O   VAL A  64      32.601 114.692   4.586  1.00 32.18           O  
ATOM    226  CB  VAL A  64      30.841 114.903   2.084  1.00 33.95           C  
ATOM    227  CG1 VAL A  64      30.285 113.501   2.320  1.00 31.11           C  
ATOM    228  CG2 VAL A  64      30.250 115.895   3.074  1.00 34.69           C  
ATOM    229  N   LEU A  65      33.354 112.973   3.347  1.00 33.30           N  
ATOM    230  CA  LEU A  65      33.775 112.195   4.510  1.00 34.64           C  
ATOM    231  C   LEU A  65      35.272 112.302   4.783  1.00 36.67           C  
ATOM    232  O   LEU A  65      35.833 111.540   5.575  1.00 36.25           O  
ATOM    233  CB  LEU A  65      33.374 110.731   4.343  1.00 32.63           C  
ATOM    234  CG  LEU A  65      31.865 110.488   4.416  1.00 31.50           C  
ATOM    235  CD1 LEU A  65      31.569 109.021   4.158  1.00 30.35           C  
ATOM    236  CD2 LEU A  65      31.347 110.909   5.788  1.00 31.04           C  
ATOM    237  N   THR A  66      35.913 113.253   4.110  1.00 37.13           N  
ATOM    238  CA  THR A  66      37.332 113.514   4.294  1.00 38.73           C  
ATOM    239  C   THR A  66      37.396 114.950   4.793  1.00 38.99           C  
ATOM    240  O   THR A  66      37.802 115.856   4.068  1.00 39.80           O  
ATOM    241  CB  THR A  66      38.109 113.399   2.976  1.00 38.31           C  
ATOM    242  OG1 THR A  66      37.982 112.068   2.464  1.00 39.20           O  
ATOM    243  CG2 THR A  66      39.585 113.709   3.199  1.00 38.95           C  
ATOM    244  N   GLN A  67      36.973 115.143   6.038  1.00 39.52           N  
ATOM    245  CA  GLN A  67      36.934 116.463   6.657  1.00 40.40           C  
ATOM    246  C   GLN A  67      38.235 116.907   7.326  1.00 38.73           C  
ATOM    247  O   GLN A  67      38.327 118.035   7.812  1.00 39.18           O  
ATOM    248  CB  GLN A  67      35.797 116.504   7.685  1.00 42.36           C  
ATOM    249  CG  GLN A  67      34.417 116.276   7.083  1.00 46.10           C  
ATOM    250  CD  GLN A  67      33.301 116.303   8.116  1.00 48.32           C  
ATOM    251  OE1 GLN A  67      32.119 116.297   7.766  1.00 49.23           O  
ATOM    252  NE2 GLN A  67      33.671 116.322   9.394  1.00 47.97           N  
ATOM    253  N   GLY A  68      39.235 116.032   7.349  1.00 35.89           N  
ATOM    254  CA  GLY A  68      40.493 116.384   7.982  1.00 33.33           C  
ATOM    255  C   GLY A  68      40.406 116.170   9.481  1.00 32.97           C  
ATOM    256  O   GLY A  68      41.367 116.391  10.211  1.00 32.97           O  
ATOM    257  N   LYS A  69      39.229 115.751   9.931  1.00 30.89           N  
ATOM    258  CA  LYS A  69      38.967 115.461  11.335  1.00 30.91           C  
ATOM    259  C   LYS A  69      38.182 114.157  11.361  1.00 28.48           C  
ATOM    260  O   LYS A  69      37.402 113.880  10.448  1.00 28.54           O  
ATOM    261  CB  LYS A  69      38.105 116.545  11.984  1.00 32.57           C  
ATOM    262  CG  LYS A  69      38.812 117.840  12.301  1.00 40.43           C  
ATOM    263  CD  LYS A  69      37.884 118.752  13.094  1.00 44.55           C  
ATOM    264  CE  LYS A  69      38.571 120.048  13.507  1.00 47.88           C  
ATOM    265  NZ  LYS A  69      37.648 120.912  14.306  1.00 48.62           N  
ATOM    266  N   PRO A  70      38.373 113.339  12.405  1.00 25.09           N  
ATOM    267  CA  PRO A  70      37.631 112.081  12.463  1.00 23.74           C  
ATOM    268  C   PRO A  70      36.125 112.331  12.480  1.00 23.22           C  
ATOM    269  O   PRO A  70      35.661 113.378  12.934  1.00 22.18           O  
ATOM    270  CB  PRO A  70      38.142 111.440  13.753  1.00 22.60           C  
ATOM    271  CG  PRO A  70      38.543 112.610  14.582  1.00 23.10           C  
ATOM    272  CD  PRO A  70      39.227 113.501  13.592  1.00 22.58           C  
ATOM    273  N   VAL A  71      35.364 111.370  11.971  1.00 22.06           N  
ATOM    274  CA  VAL A  71      33.919 111.509  11.936  1.00 21.27           C  
ATOM    275  C   VAL A  71      33.254 110.157  12.111  1.00 19.54           C  
ATOM    276  O   VAL A  71      33.798 109.125  11.714  1.00 19.13           O  
ATOM    277  CB  VAL A  71      33.432 112.143  10.594  1.00 21.65           C  
ATOM    278  CG1 VAL A  71      33.844 111.272   9.420  1.00 23.73           C  
ATOM    279  CG2 VAL A  71      31.921 112.300  10.604  1.00 23.29           C  
ATOM    280  N   LEU A  72      32.084 110.169  12.738  1.00 18.41           N  
ATOM    281  CA  LEU A  72      31.333 108.948  12.931  1.00 19.13           C  
ATOM    282  C   LEU A  72      30.261 108.884  11.856  1.00 17.78           C  
ATOM    283  O   LEU A  72      29.548 109.862  11.622  1.00 19.49           O  
ATOM    284  CB  LEU A  72      30.666 108.918  14.307  1.00 18.64           C  
ATOM    285  CG  LEU A  72      31.528 108.917  15.573  1.00 20.55           C  
ATOM    286  CD1 LEU A  72      30.605 108.765  16.780  1.00 17.90           C  
ATOM    287  CD2 LEU A  72      32.553 107.786  15.532  1.00 19.70           C  
ATOM    288  N   LEU A  73      30.174 107.744  11.182  1.00 15.98           N  
ATOM    289  CA  LEU A  73      29.158 107.535  10.165  1.00 14.30           C  
ATOM    290  C   LEU A  73      28.149 106.574  10.791  1.00 16.49           C  
ATOM    291  O   LEU A  73      28.436 105.389  10.966  1.00 17.74           O  
ATOM    292  CB  LEU A  73      29.766 106.904   8.913  1.00 14.31           C  
ATOM    293  CG  LEU A  73      28.761 106.512   7.825  1.00 14.10           C  
ATOM    294  CD1 LEU A  73      28.000 107.747   7.377  1.00 12.81           C  
ATOM    295  CD2 LEU A  73      29.487 105.869   6.644  1.00 17.04           C  
ATOM    296  N   ASN A  74      26.968 107.079  11.123  1.00 15.28           N  
ATOM    297  CA  ASN A  74      25.944 106.255  11.753  1.00 15.93           C  
ATOM    298  C   ASN A  74      24.829 105.841  10.784  1.00 16.66           C  
ATOM    299  O   ASN A  74      24.161 106.679  10.174  1.00 14.68           O  
ATOM    300  CB  ASN A  74      25.371 107.012  12.955  1.00 16.59           C  
ATOM    301  CG  ASN A  74      24.395 106.180  13.765  1.00 19.02           C  
ATOM    302  OD1 ASN A  74      23.215 106.527  13.882  1.00 18.85           O  
ATOM    303  ND2 ASN A  74      24.881 105.083  14.336  1.00 16.31           N  
ATOM    304  N   VAL A  75      24.645 104.531  10.644  1.00 16.88           N  
ATOM    305  CA  VAL A  75      23.623 103.980   9.768  1.00 17.86           C  
ATOM    306  C   VAL A  75      22.358 103.777  10.600  1.00 20.89           C  
ATOM    307  O   VAL A  75      22.397 103.148  11.654  1.00 23.25           O  
ATOM    308  CB  VAL A  75      24.061 102.630   9.190  1.00 18.26           C  
ATOM    309  CG1 VAL A  75      22.998 102.114   8.238  1.00 17.11           C  
ATOM    310  CG2 VAL A  75      25.403 102.774   8.480  1.00 15.11           C  
ATOM    311  N   TRP A  76      21.235 104.304  10.129  1.00 21.35           N  
ATOM    312  CA  TRP A  76      20.001 104.189  10.884  1.00 22.92           C  
ATOM    313  C   TRP A  76      18.754 104.170  10.012  1.00 24.05           C  
ATOM    314  O   TRP A  76      18.806 104.477   8.825  1.00 23.70           O  
ATOM    315  CB  TRP A  76      19.895 105.352  11.864  1.00 22.63           C  
ATOM    316  CG  TRP A  76      19.759 106.673  11.185  1.00 20.71           C  
ATOM    317  CD1 TRP A  76      20.748 107.389  10.565  1.00 22.53           C  
ATOM    318  CD2 TRP A  76      18.555 107.431  11.030  1.00 22.43           C  
ATOM    319  NE1 TRP A  76      20.232 108.549  10.033  1.00 22.24           N  
ATOM    320  CE2 TRP A  76      18.888 108.600  10.302  1.00 22.10           C  
ATOM    321  CE3 TRP A  76      17.225 107.238  11.431  1.00 21.14           C  
ATOM    322  CZ2 TRP A  76      17.937 109.575   9.969  1.00 23.62           C  
ATOM    323  CZ3 TRP A  76      16.278 108.205  11.100  1.00 23.21           C  
ATOM    324  CH2 TRP A  76      16.641 109.363  10.374  1.00 24.99           C  
ATOM    325  N   ALA A  77      17.630 103.817  10.632  1.00 24.97           N  
ATOM    326  CA  ALA A  77      16.338 103.758   9.958  1.00 25.70           C  
ATOM    327  C   ALA A  77      15.232 103.886  11.005  1.00 26.82           C  
ATOM    328  O   ALA A  77      15.425 103.535  12.172  1.00 26.20           O  
ATOM    329  CB  ALA A  77      16.200 102.443   9.195  1.00 23.07           C  
ATOM    330  N   THR A  78      14.076 104.397  10.592  1.00 28.36           N  
ATOM    331  CA  THR A  78      12.961 104.569  11.517  1.00 29.38           C  
ATOM    332  C   THR A  78      12.371 103.230  11.920  1.00 29.82           C  
ATOM    333  O   THR A  78      11.716 103.125  12.953  1.00 32.69           O  
ATOM    334  CB  THR A  78      11.837 105.420  10.905  1.00 27.96           C  
ATOM    335  OG1 THR A  78      11.295 104.752   9.760  1.00 29.28           O  
ATOM    336  CG2 THR A  78      12.371 106.769  10.491  1.00 28.16           C  
ATOM    337  N   TRP A  79      12.603 102.206  11.105  1.00 29.42           N  
ATOM    338  CA  TRP A  79      12.080 100.874  11.396  1.00 27.98           C  
ATOM    339  C   TRP A  79      13.028 100.042  12.243  1.00 28.56           C  
ATOM    340  O   TRP A  79      12.767  98.875  12.512  1.00 30.20           O  
ATOM    341  CB  TRP A  79      11.769 100.124  10.096  1.00 25.70           C  
ATOM    342  CG  TRP A  79      12.837 100.208   9.034  1.00 25.56           C  
ATOM    343  CD1 TRP A  79      12.809 100.978   7.899  1.00 23.73           C  
ATOM    344  CD2 TRP A  79      14.047  99.441   8.964  1.00 25.25           C  
ATOM    345  NE1 TRP A  79      13.919 100.725   7.127  1.00 24.71           N  
ATOM    346  CE2 TRP A  79      14.695  99.788   7.755  1.00 25.69           C  
ATOM    347  CE3 TRP A  79      14.646  98.490   9.804  1.00 25.38           C  
ATOM    348  CZ2 TRP A  79      15.911  99.217   7.365  1.00 27.68           C  
ATOM    349  CZ3 TRP A  79      15.855  97.922   9.415  1.00 26.61           C  
ATOM    350  CH2 TRP A  79      16.473  98.288   8.205  1.00 27.24           C  
ATOM    351  N   CYS A  80      14.129 100.647  12.664  1.00 28.86           N  
ATOM    352  CA  CYS A  80      15.129  99.960  13.470  1.00 30.27           C  
ATOM    353  C   CYS A  80      14.990 100.336  14.953  1.00 30.93           C  
ATOM    354  O   CYS A  80      15.302 101.452  15.353  1.00 32.63           O  
ATOM    355  CB  CYS A  80      16.519 100.309  12.918  1.00 30.13           C  
ATOM    356  SG  CYS A  80      17.888 100.295  14.103  1.00 27.82           S  
ATOM    357  N   PRO A  81      14.525  99.389  15.788  1.00 32.24           N  
ATOM    358  CA  PRO A  81      14.327  99.605  17.226  1.00 29.85           C  
ATOM    359  C   PRO A  81      15.544 100.076  18.016  1.00 29.71           C  
ATOM    360  O   PRO A  81      15.436 100.967  18.857  1.00 29.42           O  
ATOM    361  CB  PRO A  81      13.796  98.254  17.706  1.00 32.27           C  
ATOM    362  CG  PRO A  81      14.448  97.285  16.773  1.00 32.37           C  
ATOM    363  CD  PRO A  81      14.306  97.972  15.437  1.00 31.80           C  
ATOM    364  N   THR A  82      16.702  99.485  17.757  1.00 28.14           N  
ATOM    365  CA  THR A  82      17.902  99.889  18.475  1.00 28.72           C  
ATOM    366  C   THR A  82      18.300 101.317  18.097  1.00 27.58           C  
ATOM    367  O   THR A  82      18.897 102.034  18.896  1.00 25.96           O  
ATOM    368  CB  THR A  82      19.084  98.918  18.196  1.00 29.39           C  
ATOM    369  OG1 THR A  82      19.235  98.729  16.786  1.00 30.75           O  
ATOM    370  CG2 THR A  82      18.828  97.565  18.849  1.00 29.51           C  
ATOM    371  N   CYS A  83      17.938 101.731  16.885  1.00 27.68           N  
ATOM    372  CA  CYS A  83      18.265 103.071  16.400  1.00 28.28           C  
ATOM    373  C   CYS A  83      17.630 104.198  17.215  1.00 28.10           C  
ATOM    374  O   CYS A  83      18.281 105.206  17.506  1.00 28.46           O  
ATOM    375  CB  CYS A  83      17.846 103.212  14.939  1.00 26.99           C  
ATOM    376  SG  CYS A  83      18.751 102.109  13.811  1.00 30.48           S  
ATOM    377  N   ARG A  84      16.362 104.037  17.574  1.00 26.75           N  
ATOM    378  CA  ARG A  84      15.673 105.055  18.353  1.00 26.68           C  
ATOM    379  C   ARG A  84      16.285 105.095  19.747  1.00 24.44           C  
ATOM    380  O   ARG A  84      16.528 106.159  20.304  1.00 25.15           O  
ATOM    381  CB  ARG A  84      14.180 104.731  18.458  1.00 28.76           C  
ATOM    382  CG  ARG A  84      13.330 105.887  18.964  1.00 30.75           C  
ATOM    383  CD  ARG A  84      11.967 105.403  19.439  1.00 33.52           C  
ATOM    384  NE  ARG A  84      11.105 106.498  19.883  1.00 34.76           N  
ATOM    385  CZ  ARG A  84      10.261 107.154  19.091  1.00 37.06           C  
ATOM    386  NH1 ARG A  84      10.162 106.829  17.808  1.00 36.81           N  
ATOM    387  NH2 ARG A  84       9.508 108.129  19.586  1.00 39.01           N  
ATOM    388  N   ALA A  85      16.542 103.918  20.298  1.00 24.68           N  
ATOM    389  CA  ALA A  85      17.127 103.806  21.628  1.00 24.35           C  
ATOM    390  C   ALA A  85      18.410 104.626  21.750  1.00 22.24           C  
ATOM    391  O   ALA A  85      18.552 105.426  22.668  1.00 23.54           O  
ATOM    392  CB  ALA A  85      17.407 102.338  21.950  1.00 23.87           C  
ATOM    393  N   GLU A  86      19.332 104.432  20.812  1.00 21.91           N  
ATOM    394  CA  GLU A  86      20.617 105.130  20.824  1.00 21.61           C  
ATOM    395  C   GLU A  86      20.582 106.600  20.410  1.00 21.32           C  
ATOM    396  O   GLU A  86      21.541 107.329  20.651  1.00 22.31           O  
ATOM    397  CB  GLU A  86      21.609 104.417  19.904  1.00 21.52           C  
ATOM    398  CG  GLU A  86      21.171 104.403  18.453  1.00 22.14           C  
ATOM    399  CD  GLU A  86      22.310 104.163  17.477  1.00 24.34           C  
ATOM    400  OE1 GLU A  86      23.211 103.353  17.776  1.00 24.93           O  
ATOM    401  OE2 GLU A  86      22.290 104.774  16.387  1.00 25.43           O  
ATOM    402  N   HIS A  87      19.492 107.035  19.786  1.00 21.54           N  
ATOM    403  CA  HIS A  87      19.398 108.413  19.314  1.00 22.51           C  
ATOM    404  C   HIS A  87      19.691 109.475  20.371  1.00 23.24           C  
ATOM    405  O   HIS A  87      20.420 110.432  20.103  1.00 24.70           O  
ATOM    406  CB  HIS A  87      18.025 108.674  18.703  1.00 22.50           C  
ATOM    407  CG  HIS A  87      17.970 109.907  17.858  1.00 23.19           C  
ATOM    408  ND1 HIS A  87      18.439 109.941  16.561  1.00 23.91           N  
ATOM    409  CD2 HIS A  87      17.493 111.146  18.118  1.00 20.92           C  
ATOM    410  CE1 HIS A  87      18.245 111.148  16.058  1.00 21.32           C  
ATOM    411  NE2 HIS A  87      17.672 111.897  16.982  1.00 20.63           N  
ATOM    412  N   GLN A  88      19.135 109.313  21.567  1.00 23.36           N  
ATOM    413  CA  GLN A  88      19.360 110.289  22.628  1.00 23.89           C  
ATOM    414  C   GLN A  88      20.842 110.395  22.967  1.00 22.41           C  
ATOM    415  O   GLN A  88      21.351 111.485  23.244  1.00 19.83           O  
ATOM    416  CB  GLN A  88      18.578 109.917  23.892  1.00 27.06           C  
ATOM    417  CG  GLN A  88      18.915 110.815  25.080  1.00 36.01           C  
ATOM    418  CD  GLN A  88      18.282 110.367  26.388  1.00 40.46           C  
ATOM    419  OE1 GLN A  88      18.391 111.058  27.406  1.00 43.82           O  
ATOM    420  NE2 GLN A  88      17.623 109.211  26.371  1.00 42.16           N  
ATOM    421  N   TYR A  89      21.532 109.260  22.947  1.00 21.34           N  
ATOM    422  CA  TYR A  89      22.951 109.245  23.256  1.00 20.66           C  
ATOM    423  C   TYR A  89      23.742 109.963  22.158  1.00 20.66           C  
ATOM    424  O   TYR A  89      24.739 110.634  22.436  1.00 20.61           O  
ATOM    425  CB  TYR A  89      23.452 107.803  23.421  1.00 20.76           C  
ATOM    426  CG  TYR A  89      24.879 107.747  23.910  1.00 19.24           C  
ATOM    427  CD1 TYR A  89      25.283 108.520  25.003  1.00 19.32           C  
ATOM    428  CD2 TYR A  89      25.833 106.964  23.264  1.00 19.46           C  
ATOM    429  CE1 TYR A  89      26.600 108.524  25.435  1.00 19.24           C  
ATOM    430  CE2 TYR A  89      27.163 106.956  23.694  1.00 19.34           C  
ATOM    431  CZ  TYR A  89      27.536 107.744  24.774  1.00 19.55           C  
ATOM    432  OH  TYR A  89      28.848 107.795  25.168  1.00 19.51           O  
ATOM    433  N   LEU A  90      23.300 109.821  20.911  1.00 19.90           N  
ATOM    434  CA  LEU A  90      23.970 110.500  19.807  1.00 20.31           C  
ATOM    435  C   LEU A  90      23.822 112.008  19.970  1.00 19.41           C  
ATOM    436  O   LEU A  90      24.753 112.756  19.679  1.00 17.82           O  
ATOM    437  CB  LEU A  90      23.383 110.079  18.457  1.00 22.07           C  
ATOM    438  CG  LEU A  90      23.919 108.771  17.874  1.00 26.14           C  
ATOM    439  CD1 LEU A  90      23.203 108.464  16.574  1.00 25.58           C  
ATOM    440  CD2 LEU A  90      25.421 108.895  17.636  1.00 26.15           C  
ATOM    441  N   ASN A  91      22.653 112.454  20.426  1.00 17.41           N  
ATOM    442  CA  ASN A  91      22.434 113.884  20.624  1.00 19.30           C  
ATOM    443  C   ASN A  91      23.466 114.426  21.614  1.00 18.74           C  
ATOM    444  O   ASN A  91      24.005 115.519  21.443  1.00 18.30           O  
ATOM    445  CB  ASN A  91      21.020 114.165  21.166  1.00 18.05           C  
ATOM    446  CG  ASN A  91      19.934 114.038  20.101  1.00 20.31           C  
ATOM    447  OD1 ASN A  91      20.178 114.238  18.911  1.00 20.26           O  
ATOM    448  ND2 ASN A  91      18.720 113.727  20.535  1.00 18.78           N  
ATOM    449  N   GLN A  92      23.723 113.643  22.652  1.00 20.89           N  
ATOM    450  CA  GLN A  92      24.668 114.002  23.698  1.00 24.03           C  
ATOM    451  C   GLN A  92      26.105 114.102  23.196  1.00 23.46           C  
ATOM    452  O   GLN A  92      26.817 115.043  23.533  1.00 23.88           O  
ATOM    453  CB  GLN A  92      24.571 112.981  24.831  1.00 26.50           C  
ATOM    454  CG  GLN A  92      25.646 113.097  25.892  1.00 33.81           C  
ATOM    455  CD  GLN A  92      25.448 112.098  27.017  1.00 37.33           C  
ATOM    456  OE1 GLN A  92      26.344 111.883  27.840  1.00 39.49           O  
ATOM    457  NE2 GLN A  92      24.264 111.484  27.065  1.00 36.93           N  
ATOM    458  N   LEU A  93      26.535 113.130  22.398  1.00 23.13           N  
ATOM    459  CA  LEU A  93      27.891 113.151  21.865  1.00 22.92           C  
ATOM    460  C   LEU A  93      28.059 114.316  20.903  1.00 22.25           C  
ATOM    461  O   LEU A  93      29.086 114.994  20.901  1.00 22.91           O  
ATOM    462  CB  LEU A  93      28.208 111.842  21.136  1.00 22.32           C  
ATOM    463  CG  LEU A  93      28.281 110.575  21.994  1.00 22.65           C  
ATOM    464  CD1 LEU A  93      28.755 109.430  21.126  1.00 23.28           C  
ATOM    465  CD2 LEU A  93      29.239 110.773  23.174  1.00 19.16           C  
ATOM    466  N   SER A  94      27.040 114.536  20.084  1.00 20.98           N  
ATOM    467  CA  SER A  94      27.055 115.603  19.103  1.00 19.50           C  
ATOM    468  C   SER A  94      27.215 116.938  19.816  1.00 19.98           C  
ATOM    469  O   SER A  94      28.005 117.779  19.398  1.00 17.57           O  
ATOM    470  CB  SER A  94      25.752 115.576  18.304  1.00 20.28           C  
ATOM    471  OG  SER A  94      25.738 116.587  17.319  1.00 21.60           O  
ATOM    472  N   ALA A  95      26.471 117.123  20.902  1.00 21.56           N  
ATOM    473  CA  ALA A  95      26.549 118.361  21.674  1.00 24.83           C  
ATOM    474  C   ALA A  95      27.947 118.550  22.261  1.00 25.54           C  
ATOM    475  O   ALA A  95      28.310 119.654  22.655  1.00 24.86           O  
ATOM    476  CB  ALA A  95      25.509 118.358  22.793  1.00 22.36           C  
ATOM    477  N   GLN A  96      28.727 117.474  22.313  1.00 26.09           N  
ATOM    478  CA  GLN A  96      30.088 117.530  22.849  1.00 26.65           C  
ATOM    479  C   GLN A  96      31.149 117.761  21.777  1.00 25.48           C  
ATOM    480  O   GLN A  96      32.343 117.729  22.053  1.00 25.81           O  
ATOM    481  CB  GLN A  96      30.414 116.241  23.605  1.00 28.87           C  
ATOM    482  CG  GLN A  96      29.622 116.068  24.883  1.00 35.31           C  
ATOM    483  CD  GLN A  96      29.823 114.705  25.500  1.00 39.10           C  
ATOM    484  OE1 GLN A  96      30.952 114.294  25.766  1.00 42.97           O  
ATOM    485  NE2 GLN A  96      28.727 113.992  25.735  1.00 41.73           N  
ATOM    486  N   GLY A  97      30.721 117.983  20.545  1.00 24.49           N  
ATOM    487  CA  GLY A  97      31.695 118.231  19.506  1.00 24.21           C  
ATOM    488  C   GLY A  97      32.018 117.047  18.626  1.00 23.85           C  
ATOM    489  O   GLY A  97      32.774 117.188  17.671  1.00 25.71           O  
ATOM    490  N   ILE A  98      31.468 115.879  18.937  1.00 24.47           N  
ATOM    491  CA  ILE A  98      31.724 114.699  18.107  1.00 22.03           C  
ATOM    492  C   ILE A  98      30.966 114.898  16.800  1.00 20.19           C  
ATOM    493  O   ILE A  98      29.749 115.058  16.808  1.00 16.89           O  
ATOM    494  CB  ILE A  98      31.207 113.411  18.769  1.00 23.73           C  
ATOM    495  CG1 ILE A  98      31.842 113.229  20.155  1.00 21.74           C  
ATOM    496  CG2 ILE A  98      31.476 112.219  17.852  1.00 24.20           C  
ATOM    497  CD1 ILE A  98      33.330 113.026  20.143  1.00 25.41           C  
ATOM    498  N   ARG A  99      31.687 114.894  15.682  1.00 20.45           N  
ATOM    499  CA  ARG A  99      31.072 115.085  14.375  1.00 22.02           C  
ATOM    500  C   ARG A  99      30.458 113.781  13.863  1.00 21.24           C  
ATOM    501  O   ARG A  99      31.154 112.778  13.672  1.00 19.72           O  
ATOM    502  CB  ARG A  99      32.110 115.612  13.388  1.00 26.50           C  
ATOM    503  CG  ARG A  99      31.527 116.072  12.066  1.00 37.30           C  
ATOM    504  CD  ARG A  99      32.064 117.452  11.701  1.00 45.95           C  
ATOM    505  NE  ARG A  99      31.574 117.926  10.408  1.00 52.89           N  
ATOM    506  CZ  ARG A  99      31.813 119.141   9.918  1.00 55.17           C  
ATOM    507  NH1 ARG A  99      32.537 120.012  10.613  1.00 56.39           N  
ATOM    508  NH2 ARG A  99      31.329 119.488   8.733  1.00 57.04           N  
ATOM    509  N   VAL A 100      29.145 113.804  13.641  1.00 19.62           N  
ATOM    510  CA  VAL A 100      28.426 112.619  13.185  1.00 18.73           C  
ATOM    511  C   VAL A 100      27.699 112.820  11.864  1.00 19.81           C  
ATOM    512  O   VAL A 100      26.975 113.802  11.683  1.00 20.03           O  
ATOM    513  CB  VAL A 100      27.354 112.172  14.207  1.00 17.43           C  
ATOM    514  CG1 VAL A 100      26.841 110.791  13.835  1.00 18.70           C  
ATOM    515  CG2 VAL A 100      27.913 112.196  15.623  1.00 16.70           C  
ATOM    516  N   VAL A 101      27.887 111.877  10.948  1.00 18.63           N  
ATOM    517  CA  VAL A 101      27.213 111.922   9.663  1.00 17.56           C  
ATOM    518  C   VAL A 101      26.196 110.797   9.699  1.00 17.98           C  
ATOM    519  O   VAL A 101      26.523 109.667  10.063  1.00 17.79           O  
ATOM    520  CB  VAL A 101      28.187 111.698   8.496  1.00 17.14           C  
ATOM    521  CG1 VAL A 101      27.410 111.588   7.175  1.00 18.23           C  
ATOM    522  CG2 VAL A 101      29.174 112.847   8.434  1.00 16.72           C  
ATOM    523  N   GLY A 102      24.955 111.116   9.348  1.00 16.74           N  
ATOM    524  CA  GLY A 102      23.917 110.105   9.363  1.00 16.10           C  
ATOM    525  C   GLY A 102      23.620 109.524   7.994  1.00 17.98           C  
ATOM    526  O   GLY A 102      23.546 110.252   6.997  1.00 14.13           O  
ATOM    527  N   MET A 103      23.472 108.203   7.944  1.00 17.82           N  
ATOM    528  CA  MET A 103      23.140 107.520   6.700  1.00 18.20           C  
ATOM    529  C   MET A 103      21.801 106.815   6.883  1.00 17.60           C  
ATOM    530  O   MET A 103      21.721 105.757   7.517  1.00 14.09           O  
ATOM    531  CB  MET A 103      24.209 106.496   6.319  1.00 20.94           C  
ATOM    532  CG  MET A 103      23.990 105.914   4.923  1.00 24.76           C  
ATOM    533  SD  MET A 103      25.160 104.631   4.439  1.00 28.92           S  
ATOM    534  CE  MET A 103      24.195 103.155   4.800  1.00 25.95           C  
ATOM    535  N   ASN A 104      20.745 107.432   6.356  1.00 17.31           N  
ATOM    536  CA  ASN A 104      19.400 106.878   6.439  1.00 18.62           C  
ATOM    537  C   ASN A 104      19.380 105.678   5.475  1.00 20.51           C  
ATOM    538  O   ASN A 104      19.535 105.833   4.261  1.00 18.88           O  
ATOM    539  CB  ASN A 104      18.392 107.945   6.028  1.00 20.92           C  
ATOM    540  CG  ASN A 104      16.966 107.522   6.268  1.00 20.48           C  
ATOM    541  OD1 ASN A 104      16.140 107.567   5.359  1.00 25.66           O  
ATOM    542  ND2 ASN A 104      16.663 107.115   7.496  1.00 21.22           N  
ATOM    543  N   TYR A 105      19.195 104.487   6.036  1.00 20.48           N  
ATOM    544  CA  TYR A 105      19.234 103.231   5.283  1.00 21.86           C  
ATOM    545  C   TYR A 105      17.877 102.622   4.904  1.00 22.02           C  
ATOM    546  O   TYR A 105      17.065 102.322   5.771  1.00 21.34           O  
ATOM    547  CB  TYR A 105      20.052 102.236   6.108  1.00 20.79           C  
ATOM    548  CG  TYR A 105      20.312 100.894   5.472  1.00 22.90           C  
ATOM    549  CD1 TYR A 105      21.023 100.787   4.277  1.00 22.28           C  
ATOM    550  CD2 TYR A 105      19.892  99.726   6.099  1.00 22.57           C  
ATOM    551  CE1 TYR A 105      21.313  99.544   3.724  1.00 24.68           C  
ATOM    552  CE2 TYR A 105      20.175  98.480   5.558  1.00 25.98           C  
ATOM    553  CZ  TYR A 105      20.885  98.391   4.375  1.00 26.82           C  
ATOM    554  OH  TYR A 105      21.163  97.144   3.855  1.00 29.05           O  
ATOM    555  N   LYS A 106      17.659 102.431   3.601  1.00 24.44           N  
ATOM    556  CA  LYS A 106      16.413 101.862   3.063  1.00 25.97           C  
ATOM    557  C   LYS A 106      15.206 102.311   3.870  1.00 26.98           C  
ATOM    558  O   LYS A 106      14.428 101.489   4.347  1.00 27.68           O  
ATOM    559  CB  LYS A 106      16.482 100.332   3.071  1.00 26.62           C  
ATOM    560  CG  LYS A 106      17.643  99.758   2.287  1.00 26.54           C  
ATOM    561  CD  LYS A 106      17.601  98.246   2.296  1.00 30.39           C  
ATOM    562  CE  LYS A 106      18.713  97.659   1.452  1.00 33.55           C  
ATOM    563  NZ  LYS A 106      18.674  96.165   1.448  1.00 36.94           N  
ATOM    564  N   ASP A 107      15.042 103.622   3.997  1.00 28.19           N  
ATOM    565  CA  ASP A 107      13.963 104.184   4.796  1.00 29.84           C  
ATOM    566  C   ASP A 107      13.057 105.091   3.968  1.00 30.48           C  
ATOM    567  O   ASP A 107      13.213 105.213   2.756  1.00 31.29           O  
ATOM    568  CB  ASP A 107      14.592 104.979   5.947  1.00 30.32           C  
ATOM    569  CG  ASP A 107      13.729 105.012   7.189  1.00 31.34           C  
ATOM    570  OD1 ASP A 107      12.615 104.452   7.165  1.00 32.19           O  
ATOM    571  OD2 ASP A 107      14.176 105.604   8.195  1.00 29.78           O  
ATOM    572  N   ASP A 108      12.112 105.736   4.640  1.00 34.13           N  
ATOM    573  CA  ASP A 108      11.182 106.656   3.991  1.00 36.27           C  
ATOM    574  C   ASP A 108      11.527 108.085   4.417  1.00 35.95           C  
ATOM    575  O   ASP A 108      11.404 108.434   5.588  1.00 36.24           O  
ATOM    576  CB  ASP A 108       9.747 106.316   4.404  1.00 39.01           C  
ATOM    577  CG  ASP A 108       8.749 107.347   3.929  1.00 41.88           C  
ATOM    578  OD1 ASP A 108       8.589 107.506   2.699  1.00 43.99           O  
ATOM    579  OD2 ASP A 108       8.131 108.006   4.792  1.00 43.90           O  
ATOM    580  N   ARG A 109      11.949 108.911   3.464  1.00 36.73           N  
ATOM    581  CA  ARG A 109      12.342 110.289   3.750  1.00 38.12           C  
ATOM    582  C   ARG A 109      11.443 111.066   4.703  1.00 38.92           C  
ATOM    583  O   ARG A 109      11.936 111.760   5.596  1.00 40.27           O  
ATOM    584  CB  ARG A 109      12.477 111.083   2.454  1.00 39.36           C  
ATOM    585  CG  ARG A 109      13.374 110.425   1.448  1.00 42.26           C  
ATOM    586  CD  ARG A 109      13.579 111.284   0.226  1.00 42.51           C  
ATOM    587  NE  ARG A 109      14.500 112.386   0.472  1.00 43.53           N  
ATOM    588  CZ  ARG A 109      15.074 113.090  -0.497  1.00 43.62           C  
ATOM    589  NH1 ARG A 109      14.812 112.793  -1.763  1.00 43.98           N  
ATOM    590  NH2 ARG A 109      15.900 114.087  -0.204  1.00 42.27           N  
ATOM    591  N   GLN A 110      10.131 110.977   4.509  1.00 38.46           N  
ATOM    592  CA  GLN A 110       9.214 111.703   5.375  1.00 37.80           C  
ATOM    593  C   GLN A 110       9.264 111.205   6.805  1.00 35.45           C  
ATOM    594  O   GLN A 110       9.345 111.998   7.741  1.00 35.64           O  
ATOM    595  CB  GLN A 110       7.791 111.636   4.830  1.00 39.52           C  
ATOM    596  CG  GLN A 110       7.521 112.743   3.849  1.00 42.23           C  
ATOM    597  CD  GLN A 110       7.927 114.101   4.401  1.00 45.40           C  
ATOM    598  OE1 GLN A 110       7.455 114.519   5.464  1.00 46.57           O  
ATOM    599  NE2 GLN A 110       8.808 114.797   3.683  1.00 44.78           N  
ATOM    600  N   LYS A 111       9.214 109.891   6.977  1.00 34.60           N  
ATOM    601  CA  LYS A 111       9.294 109.324   8.311  1.00 33.70           C  
ATOM    602  C   LYS A 111      10.647 109.689   8.912  1.00 30.91           C  
ATOM    603  O   LYS A 111      10.738 110.031  10.087  1.00 30.25           O  
ATOM    604  CB  LYS A 111       9.145 107.803   8.265  1.00 36.25           C  
ATOM    605  CG  LYS A 111       7.724 107.321   8.065  1.00 40.84           C  
ATOM    606  CD  LYS A 111       7.637 105.819   8.272  1.00 44.23           C  
ATOM    607  CE  LYS A 111       6.199 105.322   8.190  1.00 46.89           C  
ATOM    608  NZ  LYS A 111       6.097 103.857   8.476  1.00 48.88           N  
ATOM    609  N   ALA A 112      11.695 109.618   8.093  1.00 28.80           N  
ATOM    610  CA  ALA A 112      13.049 109.938   8.544  1.00 27.85           C  
ATOM    611  C   ALA A 112      13.157 111.401   9.004  1.00 26.53           C  
ATOM    612  O   ALA A 112      13.678 111.688  10.082  1.00 26.66           O  
ATOM    613  CB  ALA A 112      14.055 109.656   7.419  1.00 25.16           C  
ATOM    614  N   ILE A 113      12.659 112.320   8.185  1.00 26.66           N  
ATOM    615  CA  ILE A 113      12.695 113.737   8.523  1.00 28.17           C  
ATOM    616  C   ILE A 113      11.846 114.038   9.757  1.00 28.71           C  
ATOM    617  O   ILE A 113      12.246 114.806  10.631  1.00 28.71           O  
ATOM    618  CB  ILE A 113      12.191 114.589   7.349  1.00 28.96           C  
ATOM    619  CG1 ILE A 113      13.177 114.479   6.183  1.00 29.70           C  
ATOM    620  CG2 ILE A 113      12.003 116.043   7.795  1.00 28.85           C  
ATOM    621  CD1 ILE A 113      12.784 115.272   4.965  1.00 31.05           C  
ATOM    622  N   SER A 114      10.672 113.426   9.817  1.00 28.99           N  
ATOM    623  CA  SER A 114       9.765 113.615  10.938  1.00 29.68           C  
ATOM    624  C   SER A 114      10.440 113.110  12.210  1.00 28.05           C  
ATOM    625  O   SER A 114      10.312 113.701  13.286  1.00 25.26           O  
ATOM    626  CB  SER A 114       8.464 112.846  10.675  1.00 31.34           C  
ATOM    627  OG  SER A 114       7.696 112.706  11.855  1.00 35.67           O  
ATOM    628  N   TRP A 115      11.166 112.009  12.063  1.00 27.03           N  
ATOM    629  CA  TRP A 115      11.888 111.397  13.166  1.00 26.65           C  
ATOM    630  C   TRP A 115      12.930 112.365  13.723  1.00 25.26           C  
ATOM    631  O   TRP A 115      13.061 112.508  14.930  1.00 23.94           O  
ATOM    632  CB  TRP A 115      12.544 110.114  12.668  1.00 29.76           C  
ATOM    633  CG  TRP A 115      13.540 109.473  13.589  1.00 33.65           C  
ATOM    634  CD1 TRP A 115      14.782 109.947  13.927  1.00 34.91           C  
ATOM    635  CD2 TRP A 115      13.429 108.179  14.192  1.00 33.66           C  
ATOM    636  NE1 TRP A 115      15.453 109.017  14.691  1.00 36.51           N  
ATOM    637  CE2 TRP A 115      14.644 107.923  14.866  1.00 35.06           C  
ATOM    638  CE3 TRP A 115      12.421 107.207  14.219  1.00 33.88           C  
ATOM    639  CZ2 TRP A 115      14.878 106.735  15.558  1.00 35.83           C  
ATOM    640  CZ3 TRP A 115      12.654 106.026  14.906  1.00 35.05           C  
ATOM    641  CH2 TRP A 115      13.874 105.799  15.566  1.00 36.37           C  
ATOM    642  N   LEU A 116      13.666 113.027  12.836  1.00 25.37           N  
ATOM    643  CA  LEU A 116      14.689 113.986  13.251  1.00 26.22           C  
ATOM    644  C   LEU A 116      14.062 115.220  13.887  1.00 26.44           C  
ATOM    645  O   LEU A 116      14.603 115.779  14.836  1.00 24.92           O  
ATOM    646  CB  LEU A 116      15.542 114.423  12.052  1.00 25.37           C  
ATOM    647  CG  LEU A 116      16.497 113.394  11.447  1.00 26.32           C  
ATOM    648  CD1 LEU A 116      17.065 113.926  10.134  1.00 27.91           C  
ATOM    649  CD2 LEU A 116      17.611 113.088  12.444  1.00 25.38           C  
ATOM    650  N   LYS A 117      12.922 115.650  13.360  1.00 27.98           N  
ATOM    651  CA  LYS A 117      12.259 116.822  13.905  1.00 30.76           C  
ATOM    652  C   LYS A 117      11.690 116.554  15.292  1.00 29.71           C  
ATOM    653  O   LYS A 117      11.558 117.464  16.102  1.00 29.87           O  
ATOM    654  CB  LYS A 117      11.155 117.305  12.958  1.00 32.21           C  
ATOM    655  CG  LYS A 117      11.702 117.872  11.655  1.00 36.53           C  
ATOM    656  CD  LYS A 117      10.672 118.709  10.907  1.00 39.19           C  
ATOM    657  CE  LYS A 117      11.317 119.445   9.734  1.00 40.07           C  
ATOM    658  NZ  LYS A 117      10.342 120.259   8.945  1.00 41.33           N  
ATOM    659  N   GLU A 118      11.380 115.297  15.574  1.00 30.85           N  
ATOM    660  CA  GLU A 118      10.818 114.940  16.870  1.00 31.46           C  
ATOM    661  C   GLU A 118      11.857 114.623  17.946  1.00 29.56           C  
ATOM    662  O   GLU A 118      11.773 115.118  19.068  1.00 28.75           O  
ATOM    663  CB  GLU A 118       9.889 113.739  16.720  1.00 34.46           C  
ATOM    664  CG  GLU A 118       9.260 113.293  18.027  1.00 41.19           C  
ATOM    665  CD  GLU A 118       8.480 112.006  17.877  1.00 46.05           C  
ATOM    666  OE1 GLU A 118       7.678 111.919  16.919  1.00 48.92           O  
ATOM    667  OE2 GLU A 118       8.663 111.089  18.711  1.00 47.49           O  
ATOM    668  N   LEU A 119      12.834 113.794  17.594  1.00 27.48           N  
ATOM    669  CA  LEU A 119      13.861 113.372  18.533  1.00 24.41           C  
ATOM    670  C   LEU A 119      15.104 114.262  18.572  1.00 23.80           C  
ATOM    671  O   LEU A 119      15.922 114.157  19.488  1.00 23.75           O  
ATOM    672  CB  LEU A 119      14.271 111.937  18.217  1.00 23.67           C  
ATOM    673  CG  LEU A 119      13.168 110.876  18.169  1.00 26.35           C  
ATOM    674  CD1 LEU A 119      13.795 109.524  17.857  1.00 25.86           C  
ATOM    675  CD2 LEU A 119      12.422 110.823  19.492  1.00 25.69           C  
ATOM    676  N   GLY A 120      15.250 115.138  17.588  1.00 22.28           N  
ATOM    677  CA  GLY A 120      16.414 116.000  17.561  1.00 19.73           C  
ATOM    678  C   GLY A 120      17.351 115.546  16.465  1.00 19.95           C  
ATOM    679  O   GLY A 120      17.408 114.361  16.136  1.00 19.85           O  
ATOM    680  N   ASN A 121      18.089 116.485  15.896  1.00 18.32           N  
ATOM    681  CA  ASN A 121      19.006 116.165  14.815  1.00 19.08           C  
ATOM    682  C   ASN A 121      20.455 116.314  15.286  1.00 17.90           C  
ATOM    683  O   ASN A 121      20.926 117.424  15.500  1.00 19.26           O  
ATOM    684  CB  ASN A 121      18.727 117.108  13.642  1.00 20.72           C  
ATOM    685  CG  ASN A 121      19.456 116.711  12.382  1.00 21.27           C  
ATOM    686  OD1 ASN A 121      20.346 115.866  12.398  1.00 21.97           O  
ATOM    687  ND2 ASN A 121      19.083 117.333  11.273  1.00 24.15           N  
ATOM    688  N   PRO A 122      21.173 115.195  15.465  1.00 16.94           N  
ATOM    689  CA  PRO A 122      22.568 115.263  15.910  1.00 17.74           C  
ATOM    690  C   PRO A 122      23.566 115.253  14.749  1.00 17.90           C  
ATOM    691  O   PRO A 122      24.755 115.497  14.941  1.00 18.96           O  
ATOM    692  CB  PRO A 122      22.699 114.011  16.769  1.00 17.64           C  
ATOM    693  CG  PRO A 122      21.909 113.002  15.952  1.00 17.06           C  
ATOM    694  CD  PRO A 122      20.666 113.807  15.533  1.00 17.80           C  
ATOM    695  N   TYR A 123      23.076 114.978  13.545  1.00 17.76           N  
ATOM    696  CA  TYR A 123      23.934 114.881  12.367  1.00 17.35           C  
ATOM    697  C   TYR A 123      24.384 116.177  11.712  1.00 19.10           C  
ATOM    698  O   TYR A 123      23.593 117.101  11.499  1.00 20.10           O  
ATOM    699  CB  TYR A 123      23.256 114.013  11.307  1.00 17.38           C  
ATOM    700  CG  TYR A 123      22.831 112.666  11.829  1.00 17.11           C  
ATOM    701  CD1 TYR A 123      21.483 112.329  11.930  1.00 16.37           C  
ATOM    702  CD2 TYR A 123      23.777 111.737  12.255  1.00 17.76           C  
ATOM    703  CE1 TYR A 123      21.090 111.095  12.444  1.00 18.36           C  
ATOM    704  CE2 TYR A 123      23.395 110.503  12.768  1.00 16.36           C  
ATOM    705  CZ  TYR A 123      22.055 110.189  12.858  1.00 15.38           C  
ATOM    706  OH  TYR A 123      21.684 108.964  13.352  1.00 18.47           O  
ATOM    707  N   ALA A 124      25.668 116.229  11.390  1.00 18.55           N  
ATOM    708  CA  ALA A 124      26.241 117.381  10.719  1.00 20.97           C  
ATOM    709  C   ALA A 124      25.704 117.364   9.293  1.00 22.31           C  
ATOM    710  O   ALA A 124      25.608 118.397   8.645  1.00 22.73           O  
ATOM    711  CB  ALA A 124      27.761 117.276  10.702  1.00 21.39           C  
ATOM    712  N   LEU A 125      25.336 116.171   8.829  1.00 23.80           N  
ATOM    713  CA  LEU A 125      24.817 115.958   7.476  1.00 24.02           C  
ATOM    714  C   LEU A 125      24.060 114.627   7.438  1.00 22.54           C  
ATOM    715  O   LEU A 125      24.422 113.698   8.150  1.00 21.10           O  
ATOM    716  CB  LEU A 125      25.989 115.904   6.482  1.00 26.22           C  
ATOM    717  CG  LEU A 125      25.658 115.488   5.048  1.00 29.46           C  
ATOM    718  CD1 LEU A 125      24.735 116.527   4.435  1.00 34.36           C  
ATOM    719  CD2 LEU A 125      26.926 115.358   4.225  1.00 31.52           C  
ATOM    720  N   SER A 126      23.020 114.537   6.612  1.00 21.79           N  
ATOM    721  CA  SER A 126      22.242 113.297   6.491  1.00 23.97           C  
ATOM    722  C   SER A 126      22.139 112.835   5.041  1.00 23.22           C  
ATOM    723  O   SER A 126      21.675 113.575   4.177  1.00 22.80           O  
ATOM    724  CB  SER A 126      20.828 113.471   7.063  1.00 25.23           C  
ATOM    725  OG  SER A 126      20.844 113.515   8.480  1.00 26.12           O  
ATOM    726  N   LEU A 127      22.572 111.606   4.781  1.00 21.32           N  
ATOM    727  CA  LEU A 127      22.540 111.049   3.435  1.00 21.92           C  
ATOM    728  C   LEU A 127      21.398 110.057   3.317  1.00 21.38           C  
ATOM    729  O   LEU A 127      21.143 109.288   4.232  1.00 21.83           O  
ATOM    730  CB  LEU A 127      23.857 110.335   3.125  1.00 22.04           C  
ATOM    731  CG  LEU A 127      25.147 111.126   3.357  1.00 23.48           C  
ATOM    732  CD1 LEU A 127      26.351 110.193   3.218  1.00 20.56           C  
ATOM    733  CD2 LEU A 127      25.221 112.283   2.368  1.00 24.05           C  
ATOM    734  N   PHE A 128      20.721 110.069   2.179  1.00 21.55           N  
ATOM    735  CA  PHE A 128      19.602 109.169   1.959  1.00 19.46           C  
ATOM    736  C   PHE A 128      20.032 107.973   1.112  1.00 19.50           C  
ATOM    737  O   PHE A 128      20.172 108.080  -0.107  1.00 17.94           O  
ATOM    738  CB  PHE A 128      18.461 109.934   1.273  1.00 20.04           C  
ATOM    739  CG  PHE A 128      17.194 109.135   1.115  1.00 21.60           C  
ATOM    740  CD1 PHE A 128      16.527 108.635   2.231  1.00 21.29           C  
ATOM    741  CD2 PHE A 128      16.668 108.884  -0.148  1.00 21.36           C  
ATOM    742  CE1 PHE A 128      15.349 107.898   2.090  1.00 23.51           C  
ATOM    743  CE2 PHE A 128      15.491 108.145  -0.304  1.00 22.18           C  
ATOM    744  CZ  PHE A 128      14.830 107.652   0.816  1.00 21.52           C  
ATOM    745  N   ASP A 129      20.269 106.840   1.769  1.00 18.95           N  
ATOM    746  CA  ASP A 129      20.663 105.623   1.069  1.00 19.88           C  
ATOM    747  C   ASP A 129      19.384 104.794   0.884  1.00 21.29           C  
ATOM    748  O   ASP A 129      19.240 103.702   1.433  1.00 19.46           O  
ATOM    749  CB  ASP A 129      21.715 104.865   1.887  1.00 18.17           C  
ATOM    750  CG  ASP A 129      22.352 103.714   1.111  1.00 21.31           C  
ATOM    751  OD1 ASP A 129      22.548 103.839  -0.121  1.00 17.69           O  
ATOM    752  OD2 ASP A 129      22.676 102.686   1.742  1.00 19.29           O  
ATOM    753  N   GLY A 130      18.452 105.355   0.112  1.00 22.13           N  
ATOM    754  CA  GLY A 130      17.171 104.718  -0.148  1.00 21.81           C  
ATOM    755  C   GLY A 130      17.197 103.316  -0.730  1.00 23.57           C  
ATOM    756  O   GLY A 130      16.346 102.496  -0.385  1.00 23.25           O  
ATOM    757  N   ASP A 131      18.155 103.037  -1.610  1.00 25.00           N  
ATOM    758  CA  ASP A 131      18.270 101.723  -2.238  1.00 27.31           C  
ATOM    759  C   ASP A 131      19.267 100.847  -1.494  1.00 27.53           C  
ATOM    760  O   ASP A 131      19.459  99.677  -1.836  1.00 27.85           O  
ATOM    761  CB  ASP A 131      18.706 101.869  -3.700  1.00 30.56           C  
ATOM    762  CG  ASP A 131      17.680 102.610  -4.542  1.00 34.36           C  
ATOM    763  OD1 ASP A 131      18.064 103.224  -5.564  1.00 36.57           O  
ATOM    764  OD2 ASP A 131      16.484 102.573  -4.186  1.00 36.36           O  
ATOM    765  N   GLY A 132      19.902 101.417  -0.475  1.00 26.24           N  
ATOM    766  CA  GLY A 132      20.869 100.663   0.302  1.00 24.18           C  
ATOM    767  C   GLY A 132      22.127 100.336  -0.478  1.00 22.50           C  
ATOM    768  O   GLY A 132      22.825  99.381  -0.161  1.00 21.38           O  
ATOM    769  N   MET A 133      22.426 101.128  -1.501  1.00 23.38           N  
ATOM    770  CA  MET A 133      23.617 100.884  -2.301  1.00 25.71           C  
ATOM    771  C   MET A 133      24.925 101.190  -1.577  1.00 23.27           C  
ATOM    772  O   MET A 133      25.906 100.464  -1.753  1.00 22.98           O  
ATOM    773  CB  MET A 133      23.553 101.661  -3.619  1.00 28.74           C  
ATOM    774  CG  MET A 133      22.580 101.055  -4.620  1.00 37.77           C  
ATOM    775  SD  MET A 133      22.814  99.257  -4.815  1.00 45.63           S  
ATOM    776  CE  MET A 133      21.549  98.622  -3.719  1.00 42.21           C  
ATOM    777  N   LEU A 134      24.961 102.256  -0.780  1.00 21.26           N  
ATOM    778  CA  LEU A 134      26.192 102.565  -0.056  1.00 20.39           C  
ATOM    779  C   LEU A 134      26.328 101.513   1.034  1.00 19.83           C  
ATOM    780  O   LEU A 134      27.421 101.007   1.291  1.00 18.89           O  
ATOM    781  CB  LEU A 134      26.156 103.972   0.562  1.00 17.90           C  
ATOM    782  CG  LEU A 134      27.324 104.337   1.492  1.00 18.06           C  
ATOM    783  CD1 LEU A 134      28.666 104.135   0.787  1.00 17.11           C  
ATOM    784  CD2 LEU A 134      27.181 105.785   1.939  1.00 19.10           C  
ATOM    785  N   GLY A 135      25.198 101.171   1.650  1.00 19.84           N  
ATOM    786  CA  GLY A 135      25.205 100.164   2.692  1.00 19.86           C  
ATOM    787  C   GLY A 135      25.797  98.875   2.158  1.00 20.87           C  
ATOM    788  O   GLY A 135      26.530  98.171   2.860  1.00 19.08           O  
ATOM    789  N   LEU A 136      25.485  98.569   0.900  1.00 21.20           N  
ATOM    790  CA  LEU A 136      25.989  97.358   0.262  1.00 22.53           C  
ATOM    791  C   LEU A 136      27.513  97.403   0.149  1.00 22.90           C  
ATOM    792  O   LEU A 136      28.182  96.446   0.517  1.00 20.88           O  
ATOM    793  CB  LEU A 136      25.360  97.183  -1.125  1.00 25.23           C  
ATOM    794  CG  LEU A 136      25.794  95.944  -1.917  1.00 26.18           C  
ATOM    795  CD1 LEU A 136      25.464  94.686  -1.139  1.00 22.64           C  
ATOM    796  CD2 LEU A 136      25.097  95.939  -3.269  1.00 25.77           C  
ATOM    797  N   ASP A 137      28.060  98.513  -0.352  1.00 23.89           N  
ATOM    798  CA  ASP A 137      29.512  98.651  -0.473  1.00 24.33           C  
ATOM    799  C   ASP A 137      30.180  98.702   0.899  1.00 25.52           C  
ATOM    800  O   ASP A 137      31.361  98.389   1.028  1.00 26.33           O  
ATOM    801  CB  ASP A 137      29.900  99.917  -1.243  1.00 25.04           C  
ATOM    802  CG  ASP A 137      29.521  99.853  -2.704  1.00 25.52           C  
ATOM    803  OD1 ASP A 137      29.464  98.740  -3.263  1.00 31.13           O  
ATOM    804  OD2 ASP A 137      29.295 100.922  -3.302  1.00 26.97           O  
ATOM    805  N   LEU A 138      29.434  99.118   1.917  1.00 26.93           N  
ATOM    806  CA  LEU A 138      29.982  99.187   3.269  1.00 27.88           C  
ATOM    807  C   LEU A 138      29.882  97.824   3.936  1.00 28.27           C  
ATOM    808  O   LEU A 138      30.548  97.569   4.934  1.00 29.16           O  
ATOM    809  CB  LEU A 138      29.237 100.226   4.118  1.00 25.74           C  
ATOM    810  CG  LEU A 138      29.441 101.711   3.784  1.00 24.94           C  
ATOM    811  CD1 LEU A 138      28.635 102.564   4.765  1.00 20.17           C  
ATOM    812  CD2 LEU A 138      30.924 102.066   3.861  1.00 22.71           C  
ATOM    813  N   GLY A 139      29.040  96.958   3.380  1.00 29.12           N  
ATOM    814  CA  GLY A 139      28.870  95.624   3.929  1.00 28.68           C  
ATOM    815  C   GLY A 139      28.108  95.538   5.241  1.00 29.49           C  
ATOM    816  O   GLY A 139      28.359  94.645   6.048  1.00 29.36           O  
ATOM    817  N   VAL A 140      27.165  96.447   5.460  1.00 30.60           N  
ATOM    818  CA  VAL A 140      26.394  96.445   6.701  1.00 33.46           C  
ATOM    819  C   VAL A 140      25.459  95.238   6.796  1.00 36.17           C  
ATOM    820  O   VAL A 140      25.042  94.698   5.776  1.00 36.54           O  
ATOM    821  CB  VAL A 140      25.550  97.739   6.837  1.00 31.19           C  
ATOM    822  CG1 VAL A 140      26.452  98.957   6.754  1.00 29.31           C  
ATOM    823  CG2 VAL A 140      24.483  97.785   5.755  1.00 30.19           C  
ATOM    824  N   TYR A 141      25.136  94.821   8.020  1.00 39.39           N  
ATOM    825  CA  TYR A 141      24.232  93.688   8.236  1.00 41.94           C  
ATOM    826  C   TYR A 141      22.811  94.204   8.425  1.00 42.88           C  
ATOM    827  O   TYR A 141      21.874  93.426   8.610  1.00 44.43           O  
ATOM    828  CB  TYR A 141      24.630  92.888   9.483  1.00 44.15           C  
ATOM    829  CG  TYR A 141      26.047  92.366   9.471  1.00 46.99           C  
ATOM    830  CD1 TYR A 141      26.529  91.624   8.392  1.00 48.17           C  
ATOM    831  CD2 TYR A 141      26.912  92.615  10.542  1.00 48.64           C  
ATOM    832  CE1 TYR A 141      27.844  91.143   8.376  1.00 50.12           C  
ATOM    833  CE2 TYR A 141      28.226  92.139  10.538  1.00 49.41           C  
ATOM    834  CZ  TYR A 141      28.687  91.405   9.452  1.00 50.40           C  
ATOM    835  OH  TYR A 141      29.987  90.942   9.433  1.00 49.24           O  
ATOM    836  N   GLY A 142      22.665  95.524   8.384  1.00 41.87           N  
ATOM    837  CA  GLY A 142      21.363  96.143   8.553  1.00 40.25           C  
ATOM    838  C   GLY A 142      21.552  97.517   9.160  1.00 39.70           C  
ATOM    839  O   GLY A 142      22.625  98.109   9.038  1.00 39.15           O  
ATOM    840  N   ALA A 143      20.517  98.039   9.809  1.00 39.34           N  
ATOM    841  CA  ALA A 143      20.625  99.344  10.446  1.00 38.70           C  
ATOM    842  C   ALA A 143      21.434  99.142  11.724  1.00 37.90           C  
ATOM    843  O   ALA A 143      21.986  98.068  11.948  1.00 37.97           O  
ATOM    844  CB  ALA A 143      19.244  99.888  10.774  1.00 38.86           C  
ATOM    845  N   ALA A 144      21.502 100.164  12.563  1.00 37.26           N  
ATOM    846  CA  ALA A 144      22.255 100.061  13.811  1.00 35.56           C  
ATOM    847  C   ALA A 144      23.703  99.630  13.558  1.00 32.93           C  
ATOM    848  O   ALA A 144      24.097  98.501  13.853  1.00 33.20           O  
ATOM    849  CB  ALA A 144      21.572  99.084  14.755  1.00 35.02           C  
ATOM    850  N   GLU A 145      24.479 100.548  12.995  1.00 30.02           N  
ATOM    851  CA  GLU A 145      25.889 100.327  12.703  1.00 26.82           C  
ATOM    852  C   GLU A 145      26.611 101.673  12.691  1.00 23.32           C  
ATOM    853  O   GLU A 145      26.088 102.666  12.196  1.00 21.23           O  
ATOM    854  CB  GLU A 145      26.059  99.632  11.352  1.00 29.00           C  
ATOM    855  CG  GLU A 145      25.542  98.205  11.337  1.00 32.86           C  
ATOM    856  CD  GLU A 145      26.385  97.300  10.466  1.00 34.57           C  
ATOM    857  OE1 GLU A 145      27.583  97.615  10.285  1.00 33.58           O  
ATOM    858  OE2 GLU A 145      25.858  96.272   9.982  1.00 35.20           O  
ATOM    859  N   THR A 146      27.808 101.708  13.256  1.00 21.16           N  
ATOM    860  CA  THR A 146      28.573 102.944  13.290  1.00 19.57           C  
ATOM    861  C   THR A 146      29.991 102.691  12.818  1.00 18.41           C  
ATOM    862  O   THR A 146      30.620 101.712  13.215  1.00 18.06           O  
ATOM    863  CB  THR A 146      28.625 103.539  14.714  1.00 20.65           C  
ATOM    864  OG1 THR A 146      27.291 103.729  15.199  1.00 21.91           O  
ATOM    865  CG2 THR A 146      29.347 104.889  14.705  1.00 20.29           C  
ATOM    866  N   PHE A 147      30.477 103.568  11.950  1.00 17.02           N  
ATOM    867  CA  PHE A 147      31.835 103.469  11.435  1.00 16.35           C  
ATOM    868  C   PHE A 147      32.630 104.667  11.918  1.00 16.78           C  
ATOM    869  O   PHE A 147      32.109 105.784  11.987  1.00 18.76           O  
ATOM    870  CB  PHE A 147      31.862 103.478   9.904  1.00 15.53           C  
ATOM    871  CG  PHE A 147      31.248 102.267   9.274  1.00 19.44           C  
ATOM    872  CD1 PHE A 147      29.861 102.120   9.212  1.00 19.88           C  
ATOM    873  CD2 PHE A 147      32.055 101.260   8.750  1.00 17.95           C  
ATOM    874  CE1 PHE A 147      29.294 100.984   8.640  1.00 20.29           C  
ATOM    875  CE2 PHE A 147      31.499 100.126   8.177  1.00 19.03           C  
ATOM    876  CZ  PHE A 147      30.115  99.986   8.121  1.00 19.88           C  
ATOM    877  N   LEU A 148      33.886 104.436  12.264  1.00 14.76           N  
ATOM    878  CA  LEU A 148      34.754 105.516  12.674  1.00 15.20           C  
ATOM    879  C   LEU A 148      35.636 105.780  11.463  1.00 14.95           C  
ATOM    880  O   LEU A 148      36.291 104.865  10.959  1.00 17.68           O  
ATOM    881  CB  LEU A 148      35.630 105.110  13.858  1.00 14.93           C  
ATOM    882  CG  LEU A 148      36.736 106.134  14.160  1.00 18.07           C  
ATOM    883  CD1 LEU A 148      36.107 107.439  14.588  1.00 18.74           C  
ATOM    884  CD2 LEU A 148      37.659 105.613  15.260  1.00 20.14           C  
ATOM    885  N   ILE A 149      35.647 107.017  10.988  1.00 15.96           N  
ATOM    886  CA  ILE A 149      36.463 107.378   9.835  1.00 19.02           C  
ATOM    887  C   ILE A 149      37.447 108.460  10.229  1.00 19.36           C  
ATOM    888  O   ILE A 149      37.056 109.448  10.844  1.00 19.81           O  
ATOM    889  CB  ILE A 149      35.590 107.893   8.686  1.00 19.92           C  
ATOM    890  CG1 ILE A 149      34.581 106.806   8.284  1.00 22.76           C  
ATOM    891  CG2 ILE A 149      36.466 108.298   7.511  1.00 19.22           C  
ATOM    892  CD1 ILE A 149      33.517 107.277   7.316  1.00 24.96           C  
ATOM    893  N   ASP A 150      38.722 108.285   9.879  1.00 20.87           N  
ATOM    894  CA  ASP A 150      39.719 109.284  10.241  1.00 22.01           C  
ATOM    895  C   ASP A 150      39.720 110.493   9.303  1.00 22.00           C  
ATOM    896  O   ASP A 150      39.017 110.510   8.292  1.00 19.38           O  
ATOM    897  CB  ASP A 150      41.126 108.659  10.334  1.00 23.23           C  
ATOM    898  CG  ASP A 150      41.683 108.230   8.990  1.00 24.59           C  
ATOM    899  OD1 ASP A 150      41.370 108.865   7.963  1.00 24.71           O  
ATOM    900  OD2 ASP A 150      42.467 107.257   8.969  1.00 29.12           O  
ATOM    901  N   GLY A 151      40.508 111.507   9.660  1.00 21.98           N  
ATOM    902  CA  GLY A 151      40.580 112.723   8.872  1.00 22.70           C  
ATOM    903  C   GLY A 151      40.859 112.539   7.396  1.00 25.43           C  
ATOM    904  O   GLY A 151      40.517 113.407   6.589  1.00 24.90           O  
ATOM    905  N   ASN A 152      41.464 111.411   7.030  1.00 25.23           N  
ATOM    906  CA  ASN A 152      41.787 111.148   5.634  1.00 26.22           C  
ATOM    907  C   ASN A 152      40.796 110.246   4.900  1.00 25.96           C  
ATOM    908  O   ASN A 152      41.089 109.769   3.802  1.00 25.37           O  
ATOM    909  CB  ASN A 152      43.195 110.560   5.529  1.00 28.13           C  
ATOM    910  CG  ASN A 152      44.256 111.521   6.023  1.00 30.41           C  
ATOM    911  OD1 ASN A 152      44.329 112.666   5.572  1.00 34.77           O  
ATOM    912  ND2 ASN A 152      45.086 111.065   6.951  1.00 29.82           N  
ATOM    913  N   GLY A 153      39.632 110.010   5.499  1.00 23.40           N  
ATOM    914  CA  GLY A 153      38.632 109.181   4.849  1.00 21.68           C  
ATOM    915  C   GLY A 153      38.909 107.691   4.924  1.00 22.14           C  
ATOM    916  O   GLY A 153      38.411 106.914   4.107  1.00 21.42           O  
ATOM    917  N   ILE A 154      39.705 107.280   5.902  1.00 21.48           N  
ATOM    918  CA  ILE A 154      40.013 105.868   6.051  1.00 21.40           C  
ATOM    919  C   ILE A 154      39.162 105.277   7.167  1.00 20.47           C  
ATOM    920  O   ILE A 154      39.097 105.820   8.268  1.00 21.84           O  
ATOM    921  CB  ILE A 154      41.506 105.636   6.385  1.00 22.47           C  
ATOM    922  CG1 ILE A 154      42.392 106.388   5.386  1.00 24.04           C  
ATOM    923  CG2 ILE A 154      41.822 104.140   6.345  1.00 22.11           C  
ATOM    924  CD1 ILE A 154      42.107 106.045   3.931  1.00 25.78           C  
ATOM    925  N   ILE A 155      38.499 104.171   6.866  1.00 18.32           N  
ATOM    926  CA  ILE A 155      37.667 103.495   7.845  1.00 18.82           C  
ATOM    927  C   ILE A 155      38.594 102.861   8.883  1.00 18.50           C  
ATOM    928  O   ILE A 155      39.457 102.051   8.539  1.00 19.83           O  
ATOM    929  CB  ILE A 155      36.820 102.414   7.157  1.00 17.56           C  
ATOM    930  CG1 ILE A 155      35.859 103.088   6.168  1.00 17.18           C  
ATOM    931  CG2 ILE A 155      36.099 101.566   8.204  1.00 16.90           C  
ATOM    932  CD1 ILE A 155      35.315 102.156   5.091  1.00 16.71           C  
ATOM    933  N   ARG A 156      38.411 103.231  10.147  1.00 19.20           N  
ATOM    934  CA  ARG A 156      39.253 102.714  11.227  1.00 18.91           C  
ATOM    935  C   ARG A 156      38.545 101.763  12.180  1.00 19.44           C  
ATOM    936  O   ARG A 156      39.197 101.009  12.914  1.00 21.34           O  
ATOM    937  CB  ARG A 156      39.847 103.878  12.036  1.00 18.31           C  
ATOM    938  CG  ARG A 156      40.796 104.768  11.250  1.00 15.83           C  
ATOM    939  CD  ARG A 156      41.971 103.966  10.742  1.00 16.48           C  
ATOM    940  NE  ARG A 156      42.894 104.777   9.961  1.00 19.56           N  
ATOM    941  CZ  ARG A 156      43.941 104.286   9.306  1.00 22.80           C  
ATOM    942  NH1 ARG A 156      44.203 102.983   9.338  1.00 21.78           N  
ATOM    943  NH2 ARG A 156      44.721 105.095   8.608  1.00 23.57           N  
ATOM    944  N   TYR A 157      37.220 101.802  12.202  1.00 18.31           N  
ATOM    945  CA  TYR A 157      36.484 100.925  13.094  1.00 18.39           C  
ATOM    946  C   TYR A 157      35.038 100.772  12.657  1.00 19.60           C  
ATOM    947  O   TYR A 157      34.456 101.683  12.072  1.00 19.02           O  
ATOM    948  CB  TYR A 157      36.517 101.470  14.524  1.00 18.75           C  
ATOM    949  CG  TYR A 157      36.209 100.437  15.588  1.00 20.14           C  
ATOM    950  CD1 TYR A 157      37.163  99.478  15.950  1.00 21.08           C  
ATOM    951  CD2 TYR A 157      34.967 100.400  16.221  1.00 20.55           C  
ATOM    952  CE1 TYR A 157      36.893  98.508  16.913  1.00 21.55           C  
ATOM    953  CE2 TYR A 157      34.677  99.426  17.194  1.00 22.19           C  
ATOM    954  CZ  TYR A 157      35.651  98.481  17.532  1.00 25.15           C  
ATOM    955  OH  TYR A 157      35.388  97.503  18.470  1.00 25.10           O  
ATOM    956  N   ARG A 158      34.461  99.611  12.943  1.00 20.01           N  
ATOM    957  CA  ARG A 158      33.074  99.363  12.605  1.00 21.22           C  
ATOM    958  C   ARG A 158      32.391  98.696  13.783  1.00 21.67           C  
ATOM    959  O   ARG A 158      32.833  97.646  14.242  1.00 22.62           O  
ATOM    960  CB  ARG A 158      32.964  98.451  11.382  1.00 22.87           C  
ATOM    961  CG  ARG A 158      31.517  98.068  11.052  1.00 29.83           C  
ATOM    962  CD  ARG A 158      31.446  96.945  10.031  1.00 35.20           C  
ATOM    963  NE  ARG A 158      30.079  96.451   9.869  1.00 43.60           N  
ATOM    964  CZ  ARG A 158      29.763  95.315   9.252  1.00 45.73           C  
ATOM    965  NH1 ARG A 158      28.495  94.941   9.150  1.00 46.76           N  
ATOM    966  NH2 ARG A 158      30.717  94.547   8.741  1.00 48.33           N  
ATOM    967  N   HIS A 159      31.337  99.314  14.298  1.00 21.52           N  
ATOM    968  CA  HIS A 159      30.598  98.708  15.399  1.00 24.14           C  
ATOM    969  C   HIS A 159      29.209  98.285  14.930  1.00 24.28           C  
ATOM    970  O   HIS A 159      28.381  99.125  14.579  1.00 23.23           O  
ATOM    971  CB  HIS A 159      30.439  99.668  16.579  1.00 24.69           C  
ATOM    972  CG  HIS A 159      29.574  99.119  17.677  1.00 26.78           C  
ATOM    973  ND1 HIS A 159      29.965  98.064  18.474  1.00 26.71           N  
ATOM    974  CD2 HIS A 159      28.316  99.437  18.065  1.00 26.09           C  
ATOM    975  CE1 HIS A 159      28.984  97.753  19.303  1.00 26.17           C  
ATOM    976  NE2 HIS A 159      27.972  98.571  19.076  1.00 27.54           N  
ATOM    977  N   ALA A 160      28.962  96.981  14.917  1.00 25.06           N  
ATOM    978  CA  ALA A 160      27.667  96.454  14.513  1.00 26.51           C  
ATOM    979  C   ALA A 160      26.815  96.385  15.772  1.00 27.28           C  
ATOM    980  O   ALA A 160      26.981  95.490  16.597  1.00 30.30           O  
ATOM    981  CB  ALA A 160      27.829  95.061  13.904  1.00 25.37           C  
ATOM    982  N   GLY A 161      25.911  97.341  15.928  1.00 28.43           N  
ATOM    983  CA  GLY A 161      25.066  97.364  17.105  1.00 27.23           C  
ATOM    984  C   GLY A 161      24.806  98.789  17.532  1.00 27.57           C  
ATOM    985  O   GLY A 161      25.377  99.723  16.966  1.00 28.84           O  
ATOM    986  N   ASP A 162      23.943  98.961  18.529  1.00 28.47           N  
ATOM    987  CA  ASP A 162      23.610 100.290  19.018  1.00 27.56           C  
ATOM    988  C   ASP A 162      24.785 100.931  19.744  1.00 26.95           C  
ATOM    989  O   ASP A 162      25.607 100.253  20.364  1.00 25.45           O  
ATOM    990  CB  ASP A 162      22.391 100.219  19.942  1.00 30.25           C  
ATOM    991  CG  ASP A 162      22.624  99.337  21.149  1.00 33.75           C  
ATOM    992  OD1 ASP A 162      23.322  99.766  22.093  1.00 34.46           O  
ATOM    993  OD2 ASP A 162      22.113  98.200  21.149  1.00 38.17           O  
ATOM    994  N   LEU A 163      24.864 102.250  19.649  1.00 25.74           N  
ATOM    995  CA  LEU A 163      25.927 102.995  20.294  1.00 26.67           C  
ATOM    996  C   LEU A 163      25.463 103.392  21.689  1.00 25.84           C  
ATOM    997  O   LEU A 163      24.460 104.085  21.839  1.00 27.74           O  
ATOM    998  CB  LEU A 163      26.251 104.247  19.471  1.00 26.82           C  
ATOM    999  CG  LEU A 163      27.564 104.978  19.761  1.00 29.66           C  
ATOM   1000  CD1 LEU A 163      28.730 104.023  19.533  1.00 26.12           C  
ATOM   1001  CD2 LEU A 163      27.693 106.195  18.847  1.00 27.09           C  
ATOM   1002  N   ASN A 164      26.171 102.930  22.710  1.00 24.19           N  
ATOM   1003  CA  ASN A 164      25.828 103.282  24.086  1.00 22.67           C  
ATOM   1004  C   ASN A 164      27.117 103.714  24.766  1.00 21.17           C  
ATOM   1005  O   ASN A 164      28.194 103.576  24.190  1.00 19.95           O  
ATOM   1006  CB  ASN A 164      25.185 102.094  24.825  1.00 23.42           C  
ATOM   1007  CG  ASN A 164      26.057 100.857  24.821  1.00 24.47           C  
ATOM   1008  OD1 ASN A 164      27.226 100.904  25.199  1.00 22.48           O  
ATOM   1009  ND2 ASN A 164      25.485  99.735  24.397  1.00 26.55           N  
ATOM   1010  N   PRO A 165      27.028 104.260  25.991  1.00 21.05           N  
ATOM   1011  CA  PRO A 165      28.212 104.713  26.724  1.00 21.60           C  
ATOM   1012  C   PRO A 165      29.325 103.669  26.882  1.00 22.10           C  
ATOM   1013  O   PRO A 165      30.506 103.997  26.793  1.00 24.38           O  
ATOM   1014  CB  PRO A 165      27.630 105.157  28.063  1.00 21.84           C  
ATOM   1015  CG  PRO A 165      26.280 105.661  27.679  1.00 21.97           C  
ATOM   1016  CD  PRO A 165      25.799 104.593  26.735  1.00 21.06           C  
ATOM   1017  N   ARG A 166      28.947 102.418  27.121  1.00 21.86           N  
ATOM   1018  CA  ARG A 166      29.918 101.341  27.292  1.00 23.12           C  
ATOM   1019  C   ARG A 166      30.767 101.180  26.027  1.00 22.71           C  
ATOM   1020  O   ARG A 166      31.994 101.184  26.087  1.00 23.19           O  
ATOM   1021  CB  ARG A 166      29.186 100.035  27.598  1.00 25.07           C  
ATOM   1022  CG  ARG A 166      30.040  98.934  28.220  1.00 28.35           C  
ATOM   1023  CD  ARG A 166      29.963  97.672  27.393  1.00 29.41           C  
ATOM   1024  NE  ARG A 166      30.950  97.706  26.325  1.00 35.31           N  
ATOM   1025  CZ  ARG A 166      30.864  97.017  25.195  1.00 36.34           C  
ATOM   1026  NH1 ARG A 166      29.818  96.228  24.971  1.00 37.33           N  
ATOM   1027  NH2 ARG A 166      31.831  97.112  24.291  1.00 33.81           N  
ATOM   1028  N   VAL A 167      30.100 101.052  24.885  1.00 21.41           N  
ATOM   1029  CA  VAL A 167      30.773 100.893  23.606  1.00 22.20           C  
ATOM   1030  C   VAL A 167      31.658 102.091  23.288  1.00 23.08           C  
ATOM   1031  O   VAL A 167      32.785 101.935  22.822  1.00 22.84           O  
ATOM   1032  CB  VAL A 167      29.751 100.718  22.464  1.00 22.98           C  
ATOM   1033  CG1 VAL A 167      30.463 100.736  21.119  1.00 20.15           C  
ATOM   1034  CG2 VAL A 167      28.995  99.409  22.646  1.00 22.93           C  
ATOM   1035  N   TRP A 168      31.140 103.285  23.543  1.00 23.42           N  
ATOM   1036  CA  TRP A 168      31.886 104.508  23.289  1.00 24.05           C  
ATOM   1037  C   TRP A 168      33.141 104.543  24.152  1.00 25.30           C  
ATOM   1038  O   TRP A 168      34.254 104.641  23.638  1.00 24.46           O  
ATOM   1039  CB  TRP A 168      31.008 105.728  23.583  1.00 20.83           C  
ATOM   1040  CG  TRP A 168      31.720 107.035  23.422  1.00 20.99           C  
ATOM   1041  CD1 TRP A 168      32.008 107.936  24.402  1.00 20.20           C  
ATOM   1042  CD2 TRP A 168      32.261 107.577  22.209  1.00 20.29           C  
ATOM   1043  NE1 TRP A 168      32.698 109.001  23.882  1.00 18.12           N  
ATOM   1044  CE2 TRP A 168      32.867 108.808  22.537  1.00 19.54           C  
ATOM   1045  CE3 TRP A 168      32.292 107.140  20.877  1.00 22.33           C  
ATOM   1046  CZ2 TRP A 168      33.500 109.615  21.580  1.00 22.17           C  
ATOM   1047  CZ3 TRP A 168      32.925 107.944  19.922  1.00 22.88           C  
ATOM   1048  CH2 TRP A 168      33.520 109.168  20.284  1.00 22.05           C  
ATOM   1049  N   GLU A 169      32.951 104.453  25.464  1.00 27.85           N  
ATOM   1050  CA  GLU A 169      34.059 104.482  26.415  1.00 32.82           C  
ATOM   1051  C   GLU A 169      35.176 103.473  26.125  1.00 32.64           C  
ATOM   1052  O   GLU A 169      36.336 103.841  25.947  1.00 33.59           O  
ATOM   1053  CB  GLU A 169      33.540 104.214  27.832  1.00 36.65           C  
ATOM   1054  CG  GLU A 169      32.672 105.301  28.436  1.00 44.72           C  
ATOM   1055  CD  GLU A 169      32.064 104.879  29.774  1.00 50.18           C  
ATOM   1056  OE1 GLU A 169      32.809 104.342  30.629  1.00 51.98           O  
ATOM   1057  OE2 GLU A 169      30.844 105.090  29.972  1.00 51.00           O  
ATOM   1058  N   GLU A 170      34.802 102.201  26.079  1.00 31.85           N  
ATOM   1059  CA  GLU A 170      35.738 101.104  25.884  1.00 30.87           C  
ATOM   1060  C   GLU A 170      36.239 100.800  24.483  1.00 29.55           C  
ATOM   1061  O   GLU A 170      37.373 100.355  24.324  1.00 29.41           O  
ATOM   1062  CB  GLU A 170      35.129  99.824  26.454  1.00 31.81           C  
ATOM   1063  CG  GLU A 170      34.760  99.908  27.918  1.00 35.71           C  
ATOM   1064  CD  GLU A 170      34.139  98.619  28.438  1.00 37.15           C  
ATOM   1065  OE1 GLU A 170      33.969  98.501  29.668  1.00 38.13           O  
ATOM   1066  OE2 GLU A 170      33.817  97.729  27.617  1.00 37.11           O  
ATOM   1067  N   GLU A 171      35.412 101.018  23.466  1.00 27.44           N  
ATOM   1068  CA  GLU A 171      35.838 100.692  22.111  1.00 26.64           C  
ATOM   1069  C   GLU A 171      36.103 101.789  21.099  1.00 23.81           C  
ATOM   1070  O   GLU A 171      37.063 101.702  20.337  1.00 25.05           O  
ATOM   1071  CB  GLU A 171      34.861  99.695  21.492  1.00 28.18           C  
ATOM   1072  CG  GLU A 171      35.244  98.267  21.764  1.00 36.20           C  
ATOM   1073  CD  GLU A 171      34.176  97.511  22.503  1.00 40.42           C  
ATOM   1074  OE1 GLU A 171      33.055  97.396  21.960  1.00 44.02           O  
ATOM   1075  OE2 GLU A 171      34.459  97.031  23.624  1.00 43.07           O  
ATOM   1076  N   ILE A 172      35.280 102.823  21.073  1.00 19.53           N  
ATOM   1077  CA  ILE A 172      35.480 103.848  20.067  1.00 19.34           C  
ATOM   1078  C   ILE A 172      36.202 105.104  20.536  1.00 18.25           C  
ATOM   1079  O   ILE A 172      37.067 105.624  19.825  1.00 16.33           O  
ATOM   1080  CB  ILE A 172      34.139 104.226  19.418  1.00 17.55           C  
ATOM   1081  CG1 ILE A 172      33.474 102.969  18.854  1.00 16.14           C  
ATOM   1082  CG2 ILE A 172      34.368 105.217  18.293  1.00 17.73           C  
ATOM   1083  CD1 ILE A 172      32.030 103.169  18.455  1.00 19.36           C  
ATOM   1084  N   LYS A 173      35.853 105.587  21.724  1.00 19.14           N  
ATOM   1085  CA  LYS A 173      36.476 106.787  22.279  1.00 19.79           C  
ATOM   1086  C   LYS A 173      38.013 106.764  22.170  1.00 19.98           C  
ATOM   1087  O   LYS A 173      38.625 107.716  21.686  1.00 19.32           O  
ATOM   1088  CB  LYS A 173      36.058 106.959  23.742  1.00 19.89           C  
ATOM   1089  CG  LYS A 173      36.512 108.274  24.357  1.00 26.00           C  
ATOM   1090  CD  LYS A 173      36.059 108.415  25.800  1.00 26.49           C  
ATOM   1091  CE  LYS A 173      36.619 109.690  26.410  1.00 32.28           C  
ATOM   1092  NZ  LYS A 173      36.302 109.815  27.862  1.00 35.22           N  
ATOM   1093  N   PRO A 174      38.655 105.667  22.600  1.00 19.99           N  
ATOM   1094  CA  PRO A 174      40.118 105.602  22.518  1.00 19.96           C  
ATOM   1095  C   PRO A 174      40.667 105.844  21.115  1.00 19.52           C  
ATOM   1096  O   PRO A 174      41.712 106.468  20.951  1.00 16.16           O  
ATOM   1097  CB  PRO A 174      40.424 104.197  23.033  1.00 21.23           C  
ATOM   1098  CG  PRO A 174      39.309 103.960  24.022  1.00 17.34           C  
ATOM   1099  CD  PRO A 174      38.116 104.459  23.253  1.00 19.71           C  
ATOM   1100  N   LEU A 175      39.961 105.337  20.106  1.00 21.38           N  
ATOM   1101  CA  LEU A 175      40.379 105.513  18.717  1.00 21.41           C  
ATOM   1102  C   LEU A 175      40.068 106.935  18.242  1.00 22.19           C  
ATOM   1103  O   LEU A 175      40.873 107.565  17.546  1.00 20.71           O  
ATOM   1104  CB  LEU A 175      39.677 104.492  17.825  1.00 20.87           C  
ATOM   1105  CG  LEU A 175      40.089 103.035  18.058  1.00 23.91           C  
ATOM   1106  CD1 LEU A 175      39.328 102.121  17.098  1.00 23.56           C  
ATOM   1107  CD2 LEU A 175      41.592 102.888  17.845  1.00 23.40           C  
ATOM   1108  N   TRP A 176      38.897 107.436  18.620  0.30 21.09           N  
ATOM   1110  CA  TRP A 176      38.497 108.785  18.244  0.30 20.61           C  
ATOM   1112  C   TRP A 176      39.557 109.767  18.729  0.30 20.03           C  
ATOM   1114  O   TRP A 176      39.978 110.654  17.990  0.30 20.10           O  
ATOM   1116  CB  TRP A 176      37.157 109.151  18.883  0.30 20.34           C  
ATOM   1118  CG  TRP A 176      36.712 110.539  18.538  0.30 20.55           C  
ATOM   1120  CD1 TRP A 176      36.095 110.940  17.389  0.30 19.82           C  
ATOM   1122  CD2 TRP A 176      36.898 111.723  19.328  0.30 20.46           C  
ATOM   1124  NE1 TRP A 176      35.885 112.299  17.412  0.30 20.93           N  
ATOM   1126  CE2 TRP A 176      36.368 112.805  18.590  0.30 20.66           C  
ATOM   1128  CE3 TRP A 176      37.462 111.973  20.586  0.30 20.34           C  
ATOM   1130  CZ2 TRP A 176      36.384 114.120  19.068  0.30 20.61           C  
ATOM   1132  CZ3 TRP A 176      37.480 113.284  21.063  0.30 20.52           C  
ATOM   1134  CH2 TRP A 176      36.944 114.339  20.302  0.30 20.73           C  
ATOM   1136  N   GLU A 177      39.984 109.598  19.976  1.00 19.59           N  
ATOM   1137  CA  GLU A 177      40.989 110.474  20.562  1.00 21.61           C  
ATOM   1138  C   GLU A 177      42.314 110.379  19.813  1.00 21.37           C  
ATOM   1139  O   GLU A 177      42.947 111.390  19.541  1.00 21.72           O  
ATOM   1140  CB  GLU A 177      41.205 110.125  22.035  1.00 22.44           C  
ATOM   1141  CG  GLU A 177      39.928 110.161  22.846  1.00 27.82           C  
ATOM   1142  CD  GLU A 177      40.183 110.104  24.331  1.00 29.48           C  
ATOM   1143  OE1 GLU A 177      41.034 109.293  24.752  1.00 32.38           O  
ATOM   1144  OE2 GLU A 177      39.527 110.864  25.075  1.00 31.50           O  
ATOM   1145  N   LYS A 178      42.735 109.163  19.485  1.00 21.55           N  
ATOM   1146  CA  LYS A 178      43.991 108.979  18.764  1.00 23.33           C  
ATOM   1147  C   LYS A 178      43.995 109.723  17.430  1.00 23.79           C  
ATOM   1148  O   LYS A 178      44.908 110.497  17.154  1.00 23.90           O  
ATOM   1149  CB  LYS A 178      44.251 107.488  18.528  1.00 24.54           C  
ATOM   1150  CG  LYS A 178      45.351 107.187  17.518  1.00 23.25           C  
ATOM   1151  CD  LYS A 178      45.456 105.685  17.289  1.00 24.31           C  
ATOM   1152  CE  LYS A 178      46.185 105.349  15.997  1.00 23.64           C  
ATOM   1153  NZ  LYS A 178      47.602 105.787  16.033  1.00 26.24           N  
ATOM   1154  N   TYR A 179      42.972 109.500  16.610  1.00 23.72           N  
ATOM   1155  CA  TYR A 179      42.899 110.159  15.311  1.00 24.69           C  
ATOM   1156  C   TYR A 179      42.562 111.641  15.384  1.00 25.20           C  
ATOM   1157  O   TYR A 179      42.853 112.382  14.451  1.00 26.27           O  
ATOM   1158  CB  TYR A 179      41.916 109.421  14.389  1.00 25.78           C  
ATOM   1159  CG  TYR A 179      42.400 108.032  14.044  1.00 25.85           C  
ATOM   1160  CD1 TYR A 179      41.820 106.905  14.621  1.00 27.16           C  
ATOM   1161  CD2 TYR A 179      43.509 107.852  13.217  1.00 27.84           C  
ATOM   1162  CE1 TYR A 179      42.338 105.631  14.392  1.00 29.48           C  
ATOM   1163  CE2 TYR A 179      44.038 106.583  12.980  1.00 29.10           C  
ATOM   1164  CZ  TYR A 179      43.450 105.479  13.572  1.00 30.82           C  
ATOM   1165  OH  TYR A 179      43.981 104.228  13.359  1.00 34.13           O  
ATOM   1166  N   SER A 180      41.951 112.077  16.481  1.00 26.54           N  
ATOM   1167  CA  SER A 180      41.629 113.489  16.650  1.00 28.88           C  
ATOM   1168  C   SER A 180      42.941 114.218  16.901  1.00 31.60           C  
ATOM   1169  O   SER A 180      43.158 115.318  16.405  1.00 31.42           O  
ATOM   1170  CB  SER A 180      40.691 113.711  17.845  1.00 27.14           C  
ATOM   1171  OG  SER A 180      39.356 113.341  17.536  1.00 27.83           O  
ATOM   1172  N   LYS A 181      43.818 113.591  17.679  1.00 34.99           N  
ATOM   1173  CA  LYS A 181      45.115 114.183  17.984  1.00 39.40           C  
ATOM   1174  C   LYS A 181      46.042 114.110  16.780  1.00 41.74           C  
ATOM   1175  O   LYS A 181      46.758 115.065  16.484  1.00 41.51           O  
ATOM   1176  CB  LYS A 181      45.760 113.484  19.187  1.00 38.54           C  
ATOM   1177  CG  LYS A 181      45.201 113.952  20.515  1.00 41.73           C  
ATOM   1178  CD  LYS A 181      45.955 113.378  21.706  1.00 43.36           C  
ATOM   1179  CE  LYS A 181      45.612 111.922  21.937  1.00 45.99           C  
ATOM   1180  NZ  LYS A 181      46.247 111.414  23.187  1.00 47.42           N  
ATOM   1181  N   GLU A 182      46.018 112.979  16.081  1.00 45.65           N  
ATOM   1182  CA  GLU A 182      46.864 112.796  14.909  1.00 48.89           C  
ATOM   1183  C   GLU A 182      46.237 113.483  13.710  1.00 51.47           C  
ATOM   1184  O   GLU A 182      46.225 112.943  12.603  1.00 52.06           O  
ATOM   1185  CB  GLU A 182      47.059 111.306  14.621  1.00 49.23           C  
ATOM   1186  CG  GLU A 182      47.761 110.559  15.747  1.00 51.25           C  
ATOM   1187  CD  GLU A 182      47.979 109.094  15.431  1.00 51.73           C  
ATOM   1188  OE1 GLU A 182      48.456 108.359  16.322  1.00 51.56           O  
ATOM   1189  OE2 GLU A 182      47.677 108.681  14.291  1.00 52.86           O  
ATOM   1190  N   ALA A 183      45.710 114.679  13.949  1.00 53.65           N  
ATOM   1191  CA  ALA A 183      45.072 115.485  12.916  1.00 56.37           C  
ATOM   1192  C   ALA A 183      45.109 116.943  13.356  1.00 58.81           C  
ATOM   1193  O   ALA A 183      45.070 117.859  12.532  1.00 59.75           O  
ATOM   1194  CB  ALA A 183      43.632 115.037  12.712  1.00 54.69           C  
ATOM   1195  N   ALA A 184      45.185 117.147  14.668  1.00 61.42           N  
ATOM   1196  CA  ALA A 184      45.224 118.486  15.244  1.00 63.47           C  
ATOM   1197  C   ALA A 184      46.409 119.280  14.701  1.00 64.60           C  
ATOM   1198  O   ALA A 184      46.173 120.370  14.131  1.00 65.22           O  
ATOM   1199  CB  ALA A 184      45.304 118.393  16.765  1.00 62.68           C  
TER    1200      ALA A 184                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
