
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  134 ( 2002),  selected  134 , name 1vee_A
# Molecule2: number of CA atoms  134 ( 1020),  selected  134 , name T0389.pdb
# PARAMETERS: 1vee_A.T0389.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      M       1           -
LGA    S     2_A      -       -           -
LGA    S     3_A      I       2          3.031
LGA    G     4_A      G       3          0.928
LGA    S     5_A      T       4          1.480
LGA    S     6_A      Q       5          0.286
LGA    G     7_A      I       6          3.226
LGA    S     8_A      V       7          1.431
LGA    A     9_A      T       8          1.751
LGA    K    10_A      E       9          1.839
LGA    N    11_A      R      10          1.330
LGA    A    12_A      L      11          1.422
LGA    Y    13_A      V      12          1.875
LGA    T    14_A      A      13          1.405
LGA    K    15_A      L      14          1.469
LGA    L    16_A      L      15          2.365
LGA    G    17_A      E      16          2.363
LGA    T    18_A      S      17          2.441
LGA    -       -      G      18           -
LGA    D    19_A      T      19          3.887
LGA    D    20_A      E      20          2.928
LGA    N    21_A      K      21          1.665
LGA    A    22_A      V      22          1.091
LGA    Q    23_A      L      23          2.057
LGA    L    24_A      L      24          0.881
LGA    L    25_A      I      25          1.127
LGA    D    26_A      D      26          1.256
LGA    I    27_A      S      27          1.283
LGA    R    28_A      R      28          1.264
LGA    A    29_A      P      29          0.561
LGA    T    30_A      F      30          0.744
LGA    A    31_A      V      31          1.722
LGA    D    32_A      E      32          0.808
LGA    F    33_A      Y      33          2.479
LGA    R    34_A      N      34          3.930
LGA    Q    35_A      T      35          3.496
LGA    V    36_A      S      36          3.521
LGA    G    37_A      -       -           -
LGA    S    38_A      H      37          2.335
LGA    P    39_A      I      38          1.839
LGA    N    40_A      L      39          2.330
LGA    I    41_A      -       -           -
LGA    K    42_A      -       -           -
LGA    G    43_A      -       -           -
LGA    L    44_A      -       -           -
LGA    G    45_A      -       -           -
LGA    K    46_A      -       -           -
LGA    K    47_A      E      40          3.248
LGA    A    48_A      A      41          2.526
LGA    V    49_A      I      42          1.493
LGA    S    50_A      N      43          1.459
LGA    T    51_A      I      44          1.608
LGA    V    52_A      N      45          0.932
LGA    Y    53_A      C      46          3.300
LGA    N    54_A      S      47          3.659
LGA    -       -      K      48           -
LGA    -       -      L      49           -
LGA    -       -      M      50           -
LGA    G    55_A      K      51          2.060
LGA    E    56_A      R      52          1.894
LGA    D    57_A      R      53          3.725
LGA    K    58_A      L      54          1.976
LGA    -       -      Q      55           -
LGA    -       -      Q      56           -
LGA    -       -      D      57           -
LGA    P    59_A      K      58          4.717
LGA    G    60_A      V      59          3.050
LGA    F    61_A      L      60           #
LGA    L    62_A      I      61          1.182
LGA    K    63_A      T      62          3.945
LGA    K    64_A      E      63          3.198
LGA    L    65_A      L      64          4.690
LGA    S    66_A      I      65           #
LGA    L    67_A      Q      66          3.918
LGA    K    68_A      H      67           #
LGA    -       -      S      68           -
LGA    -       -      A      69           -
LGA    -       -      K      70           -
LGA    -       -      H      71           -
LGA    -       -      K      72           -
LGA    F    69_A      V      73          4.366
LGA    K    70_A      D      74          3.944
LGA    D    71_A      I      75          4.145
LGA    P    72_A      D      76          2.645
LGA    E    73_A      C      77          1.294
LGA    N    74_A      S      78          1.293
LGA    T    75_A      Q      79          1.480
LGA    T    76_A      K      80          1.728
LGA    L    77_A      V      81          1.637
LGA    Y    78_A      V      82          0.872
LGA    I    79_A      V      83          0.575
LGA    L    80_A      Y      84          1.956
LGA    D    81_A      D      85          1.299
LGA    K    82_A      Q      86          1.555
LGA    F    83_A      S      87          2.238
LGA    D    84_A      S      88          2.157
LGA    -       -      Q      89           -
LGA    -       -      D      90           -
LGA    -       -      V      91           -
LGA    -       -      A      92           -
LGA    -       -      S      93           -
LGA    -       -      L      94           -
LGA    -       -      S      95           -
LGA    -       -      S      96           -
LGA    -       -      D      97           -
LGA    -       -      C      98           -
LGA    G    85_A      F      99           #
LGA    N    86_A      L     100          1.885
LGA    S    87_A      -       -           -
LGA    E    88_A      T     101          5.448
LGA    L    89_A      V     102          4.782
LGA    V    90_A      L     103          2.693
LGA    A    91_A      L     104          3.041
LGA    E    92_A      G     105          3.359
LGA    L    93_A      K     106          2.186
LGA    V    94_A      L     107          0.827
LGA    A    95_A      E     108          1.477
LGA    L    96_A      K     109          1.600
LGA    N    97_A      -       -           -
LGA    G    98_A      S     110          2.030
LGA    F    99_A      F     111          1.550
LGA    K   100_A      N     112          2.385
LGA    S   101_A      S     113          1.469
LGA    A   102_A      V     114          1.615
LGA    Y   103_A      H     115          1.432
LGA    A   104_A      L     116          0.318
LGA    I   105_A      L     117          0.510
LGA    K   106_A      A     118          1.887
LGA    D   107_A      G     119          1.693
LGA    G   108_A      G     120          1.361
LGA    A   109_A      F     121          0.583
LGA    E   110_A      A     122          1.902
LGA    G   111_A      -       -           -
LGA    P   112_A      -       -           -
LGA    R   113_A      -       -           -
LGA    G   114_A      E     123          1.479
LGA    W   115_A      F     124          0.940
LGA    L   116_A      S     125          1.106
LGA    N   117_A      R     126          1.790
LGA    S   118_A      C     127          2.265
LGA    S   119_A      F     128          2.768
LGA    L   120_A      P     129          4.874
LGA    P   121_A      G     130          2.590
LGA    -       -      L     131           -
LGA    W   122_A      C     132          1.026
LGA    I   123_A      E     133          1.536
LGA    E   124_A      G     134          2.726
LGA    P   125_A      -       -           -
LGA    K   126_A      -       -           -
LGA    K   127_A      -       -           -
LGA    T   128_A      -       -           -
LGA    S   129_A      -       -           -
LGA    G   130_A      -       -           -
LGA    P   131_A      -       -           -
LGA    S   132_A      -       -           -
LGA    S   133_A      -       -           -
LGA    G   134_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  134  134    5.0    106    2.40    10.38     52.543     4.241

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.167388 * X  +  -0.955137 * Y  +  -0.244324 * Z  +  -4.004256
  Y_new =   0.471395 * X  +   0.295195 * Y  +  -0.831052 * Z  +  13.701641
  Z_new =   0.865892 * X  +   0.023935 * Y  +   0.499659 * Z  +   1.038875 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.047866   -3.093727  [ DEG:     2.7425   -177.2575 ]
  Theta =  -1.046930   -2.094663  [ DEG:   -59.9847   -120.0153 ]
  Phi   =   1.229594   -1.911999  [ DEG:    70.4505   -109.5495 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1vee_A                                        
REMARK     2: T0389.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1vee_A.T0389.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  134  134   5.0  106   2.40   10.38  52.543
REMARK  ---------------------------------------------------------- 
MOLECULE 1vee_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   30-MAR-04   1VEE              
TITLE     NMR STRUCTURE OF THE HYPOTHETICAL RHODANESE DOMAIN                    
TITLE    2 AT4G01050 FROM ARABIDOPSIS THALIANA                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROLINE-RICH PROTEIN FAMILY;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RHODANESE HYPOTHETICAL DOMAIN;                             
COMPND   5 SYNONYM: HYPOTHETICAL PROTEIN RAFL06-68-J04;                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ARABIDOPSIS THALIANA;                           
SOURCE   3 ORGANISM_COMMON: THALE CRESS;                                        
SOURCE   4 GENE: RIKEN CDNA RAFL06-68-J04;                                      
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P030120-27;                               
SOURCE   7 OTHER_DETAILS: E.COLI CELL-FREE PROTEIN SYNTHESIS                    
KEYWDS    HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS, RHODANESE DOMAIN,          
KEYWDS   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    D.PANTOJA-UCEDA,B.LOPEZ-MENDEZ,S.KOSHIBA,M.INOUE,T.KIGAWA,            
AUTHOR   2 T.TERADA,M.SHIROUZU,A.TANAKA,M.SEKI,K.SHINOZAKI,S.YOKOYAMA,          
AUTHOR   3 P.GUNTERT,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE            
AUTHOR   4 (RSGI)                                                               
REVDAT   2   15-FEB-05 1VEE    1       AUTHOR                                   
REVDAT   1   25-JAN-05 1VEE    0                                                
JRNL        AUTH   D.PANTOJA-UCEDA,B.LOPEZ-MENDEZ,S.KOSHIBA,M.INOUE,            
JRNL        AUTH 2 T.KIGAWA,T.TERADA,M.SHIROUZU,A.TANAKA,M.SEKI,                
JRNL        AUTH 3 K.SHINOZAKI,S.YOKOYAMA,P.GUNTERT                             
JRNL        TITL   SOLUTION STRUCTURE OF THE RHODANESE HOMOLOGY                 
JRNL        TITL 2 DOMAIN AT4G01050(175-295) FROM ARABIDOPSIS THALIANA          
JRNL        REF    PROTEIN SCI.                  V.  14   224 2005              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1VEE A    8   128  UNP    Q9M158   Y4105_ARATH    134    254             
SEQRES   1 A  134  GLY SER SER GLY SER SER GLY SER ALA LYS ASN ALA TYR          
SEQRES   2 A  134  THR LYS LEU GLY THR ASP ASP ASN ALA GLN LEU LEU ASP          
SEQRES   3 A  134  ILE ARG ALA THR ALA ASP PHE ARG GLN VAL GLY SER PRO          
SEQRES   4 A  134  ASN ILE LYS GLY LEU GLY LYS LYS ALA VAL SER THR VAL          
SEQRES   5 A  134  TYR ASN GLY GLU ASP LYS PRO GLY PHE LEU LYS LYS LEU          
SEQRES   6 A  134  SER LEU LYS PHE LYS ASP PRO GLU ASN THR THR LEU TYR          
SEQRES   7 A  134  ILE LEU ASP LYS PHE ASP GLY ASN SER GLU LEU VAL ALA          
SEQRES   8 A  134  GLU LEU VAL ALA LEU ASN GLY PHE LYS SER ALA TYR ALA          
SEQRES   9 A  134  ILE LYS ASP GLY ALA GLU GLY PRO ARG GLY TRP LEU ASN          
SEQRES  10 A  134  SER SER LEU PRO TRP ILE GLU PRO LYS LYS THR SER GLY          
SEQRES  11 A  134  PRO SER SER GLY                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      -8.667  -9.472   2.803  1.00  0.00           N  
ATOM      2  CA  GLY A   1      -7.327  -9.068   3.247  1.00  0.00           C  
ATOM      3  C   GLY A   1      -7.069  -7.609   2.912  1.00  0.00           C  
ATOM      4  O   GLY A   1      -8.014  -6.840   2.731  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      -7.230  -9.227   4.321  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      -6.600  -9.681   2.721  1.00  0.00           H  
ATOM      7  H1  GLY A   1      -8.891  -9.228   1.859  1.00  0.00           H  
ATOM      8  N   SER A   2      -5.802  -7.200   2.838  1.00  0.00           N  
ATOM      9  CA  SER A   2      -5.447  -5.822   2.508  1.00  0.00           C  
ATOM     10  C   SER A   2      -5.984  -5.496   1.113  1.00  0.00           C  
ATOM     11  O   SER A   2      -5.895  -6.330   0.208  1.00  0.00           O  
ATOM     12  CB  SER A   2      -3.932  -5.662   2.595  1.00  0.00           C  
ATOM     13  OG  SER A   2      -3.560  -5.883   3.942  1.00  0.00           O  
ATOM     14  H   SER A   2      -5.043  -7.848   2.997  1.00  0.00           H  
ATOM     15  HA  SER A   2      -5.919  -5.154   3.229  1.00  0.00           H  
ATOM     16  HB2 SER A   2      -3.446  -6.398   1.954  1.00  0.00           H  
ATOM     17  HB3 SER A   2      -3.645  -4.654   2.290  1.00  0.00           H  
ATOM     18  HG  SER A   2      -2.633  -6.174   3.986  1.00  0.00           H  
ATOM     19  N   SER A   3      -6.552  -4.304   0.950  1.00  0.00           N  
ATOM     20  CA  SER A   3      -7.134  -3.830  -0.290  1.00  0.00           C  
ATOM     21  C   SER A   3      -6.572  -2.453  -0.637  1.00  0.00           C  
ATOM     22  O   SER A   3      -5.794  -2.339  -1.585  1.00  0.00           O  
ATOM     23  CB  SER A   3      -8.666  -3.871  -0.189  1.00  0.00           C  
ATOM     24  OG  SER A   3      -9.133  -3.267   1.009  1.00  0.00           O  
ATOM     25  H   SER A   3      -6.589  -3.660   1.736  1.00  0.00           H  
ATOM     26  HA  SER A   3      -6.850  -4.506  -1.092  1.00  0.00           H  
ATOM     27  HB2 SER A   3      -9.091  -3.359  -1.053  1.00  0.00           H  
ATOM     28  HB3 SER A   3      -8.997  -4.910  -0.205  1.00  0.00           H  
ATOM     29  HG  SER A   3      -8.957  -3.871   1.740  1.00  0.00           H  
ATOM     30  N   GLY A   4      -6.948  -1.424   0.124  1.00  0.00           N  
ATOM     31  CA  GLY A   4      -6.515  -0.048  -0.053  1.00  0.00           C  
ATOM     32  C   GLY A   4      -5.029   0.080   0.261  1.00  0.00           C  
ATOM     33  O   GLY A   4      -4.611  -0.197   1.389  1.00  0.00           O  
ATOM     34  H   GLY A   4      -7.591  -1.610   0.884  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      -6.719   0.270  -1.076  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      -7.079   0.589   0.626  1.00  0.00           H  
ATOM     37  N   SER A   5      -4.229   0.459  -0.738  1.00  0.00           N  
ATOM     38  CA  SER A   5      -2.791   0.636  -0.593  1.00  0.00           C  
ATOM     39  C   SER A   5      -2.563   1.667   0.513  1.00  0.00           C  
ATOM     40  O   SER A   5      -2.931   2.834   0.369  1.00  0.00           O  
ATOM     41  CB  SER A   5      -2.200   1.108  -1.920  1.00  0.00           C  
ATOM     42  OG  SER A   5      -2.470   0.200  -2.981  1.00  0.00           O  
ATOM     43  H   SER A   5      -4.635   0.679  -1.640  1.00  0.00           H  
ATOM     44  HA  SER A   5      -2.338  -0.315  -0.308  1.00  0.00           H  
ATOM     45  HB2 SER A   5      -2.645   2.068  -2.167  1.00  0.00           H  
ATOM     46  HB3 SER A   5      -1.122   1.237  -1.812  1.00  0.00           H  
ATOM     47  HG  SER A   5      -2.659   0.750  -3.763  1.00  0.00           H  
ATOM     48  N   SER A   6      -1.952   1.259   1.620  1.00  0.00           N  
ATOM     49  CA  SER A   6      -1.711   2.136   2.749  1.00  0.00           C  
ATOM     50  C   SER A   6      -0.415   1.781   3.465  1.00  0.00           C  
ATOM     51  O   SER A   6       0.291   0.840   3.086  1.00  0.00           O  
ATOM     52  CB  SER A   6      -2.949   2.020   3.651  1.00  0.00           C  
ATOM     53  OG  SER A   6      -3.295   0.673   3.923  1.00  0.00           O  
ATOM     54  H   SER A   6      -1.669   0.287   1.713  1.00  0.00           H  
ATOM     55  HA  SER A   6      -1.603   3.171   2.420  1.00  0.00           H  
ATOM     56  HB2 SER A   6      -2.779   2.562   4.580  1.00  0.00           H  
ATOM     57  HB3 SER A   6      -3.792   2.466   3.139  1.00  0.00           H  
ATOM     58  HG  SER A   6      -3.885   0.370   3.197  1.00  0.00           H  
ATOM     59  N   GLY A   7      -0.085   2.550   4.501  1.00  0.00           N  
ATOM     60  CA  GLY A   7       1.118   2.303   5.275  1.00  0.00           C  
ATOM     61  C   GLY A   7       1.340   3.351   6.345  1.00  0.00           C  
ATOM     62  O   GLY A   7       0.508   3.518   7.235  1.00  0.00           O  
ATOM     63  H   GLY A   7      -0.705   3.309   4.757  1.00  0.00           H  
ATOM     64  HA2 GLY A   7       1.028   1.337   5.769  1.00  0.00           H  
ATOM     65  HA3 GLY A   7       1.972   2.268   4.601  1.00  0.00           H  
ATOM     66  N   SER A   8       2.445   4.079   6.235  1.00  0.00           N  
ATOM     67  CA  SER A   8       2.867   5.130   7.165  1.00  0.00           C  
ATOM     68  C   SER A   8       3.044   6.468   6.437  1.00  0.00           C  
ATOM     69  O   SER A   8       3.489   6.488   5.285  1.00  0.00           O  
ATOM     70  CB  SER A   8       4.159   4.712   7.873  1.00  0.00           C  
ATOM     71  OG  SER A   8       4.075   3.388   8.378  1.00  0.00           O  
ATOM     72  H   SER A   8       3.027   3.835   5.454  1.00  0.00           H  
ATOM     73  HA  SER A   8       2.116   5.254   7.943  1.00  0.00           H  
ATOM     74  HB2 SER A   8       4.993   4.776   7.172  1.00  0.00           H  
ATOM     75  HB3 SER A   8       4.338   5.402   8.697  1.00  0.00           H  
ATOM     76  HG  SER A   8       3.280   3.340   8.948  1.00  0.00           H  
ATOM     77  N   ALA A   9       2.788   7.587   7.123  1.00  0.00           N  
ATOM     78  CA  ALA A   9       2.910   8.938   6.573  1.00  0.00           C  
ATOM     79  C   ALA A   9       4.318   9.175   6.008  1.00  0.00           C  
ATOM     80  O   ALA A   9       4.471   9.682   4.898  1.00  0.00           O  
ATOM     81  CB  ALA A   9       2.542   9.963   7.655  1.00  0.00           C  
ATOM     82  H   ALA A   9       2.408   7.490   8.062  1.00  0.00           H  
ATOM     83  HA  ALA A   9       2.200   9.039   5.751  1.00  0.00           H  
ATOM     84  HB1 ALA A   9       3.276   9.935   8.454  1.00  0.00           H  
ATOM     85  HB2 ALA A   9       2.513  10.968   7.229  1.00  0.00           H  
ATOM     86  HB3 ALA A   9       1.562   9.739   8.081  1.00  0.00           H  
ATOM     87  N   LYS A  10       5.354   8.732   6.730  1.00  0.00           N  
ATOM     88  CA  LYS A  10       6.754   8.874   6.317  1.00  0.00           C  
ATOM     89  C   LYS A  10       7.003   8.226   4.956  1.00  0.00           C  
ATOM     90  O   LYS A  10       7.714   8.794   4.125  1.00  0.00           O  
ATOM     91  CB  LYS A  10       7.687   8.271   7.374  1.00  0.00           C  
ATOM     92  CG  LYS A  10       7.581   9.037   8.702  1.00  0.00           C  
ATOM     93  CD  LYS A  10       8.452   8.470   9.828  1.00  0.00           C  
ATOM     94  CE  LYS A  10       8.096   9.232  11.112  1.00  0.00           C  
ATOM     95  NZ  LYS A  10       8.585   8.574  12.337  1.00  0.00           N  
ATOM     96  H   LYS A  10       5.156   8.330   7.635  1.00  0.00           H  
ATOM     97  HA  LYS A  10       6.983   9.936   6.214  1.00  0.00           H  
ATOM     98  HB2 LYS A  10       7.433   7.223   7.534  1.00  0.00           H  
ATOM     99  HB3 LYS A  10       8.702   8.325   6.986  1.00  0.00           H  
ATOM    100  HG2 LYS A  10       7.846  10.082   8.535  1.00  0.00           H  
ATOM    101  HG3 LYS A  10       6.546   8.988   9.039  1.00  0.00           H  
ATOM    102  HD2 LYS A  10       8.237   7.409   9.950  1.00  0.00           H  
ATOM    103  HD3 LYS A  10       9.509   8.603   9.588  1.00  0.00           H  
ATOM    104  HE2 LYS A  10       8.513  10.240  11.053  1.00  0.00           H  
ATOM    105  HE3 LYS A  10       7.010   9.310  11.186  1.00  0.00           H  
ATOM    106  HZ1 LYS A  10       8.353   9.150  13.148  1.00  0.00           H  
ATOM    107  HZ2 LYS A  10       9.594   8.487  12.331  1.00  0.00           H  
ATOM    108  HZ3 LYS A  10       8.148   7.668  12.472  1.00  0.00           H  
ATOM    109  N   ASN A  11       6.418   7.045   4.719  1.00  0.00           N  
ATOM    110  CA  ASN A  11       6.570   6.351   3.444  1.00  0.00           C  
ATOM    111  C   ASN A  11       5.996   7.226   2.340  1.00  0.00           C  
ATOM    112  O   ASN A  11       6.605   7.327   1.285  1.00  0.00           O  
ATOM    113  CB  ASN A  11       5.884   4.970   3.447  1.00  0.00           C  
ATOM    114  CG  ASN A  11       5.795   4.360   2.044  1.00  0.00           C  
ATOM    115  OD1 ASN A  11       6.660   3.590   1.638  1.00  0.00           O  
ATOM    116  ND2 ASN A  11       4.747   4.646   1.288  1.00  0.00           N  
ATOM    117  H   ASN A  11       5.844   6.632   5.435  1.00  0.00           H  
ATOM    118  HA  ASN A  11       7.631   6.222   3.236  1.00  0.00           H  
ATOM    119  HB2 ASN A  11       6.450   4.294   4.090  1.00  0.00           H  
ATOM    120  HB3 ASN A  11       4.879   5.045   3.848  1.00  0.00           H  
ATOM    121 HD21 ASN A  11       3.977   5.202   1.650  1.00  0.00           H  
ATOM    122 HD22 ASN A  11       4.675   4.253   0.364  1.00  0.00           H  
ATOM    123  N   ALA A  12       4.837   7.848   2.569  1.00  0.00           N  
ATOM    124  CA  ALA A  12       4.211   8.696   1.562  1.00  0.00           C  
ATOM    125  C   ALA A  12       5.100   9.902   1.256  1.00  0.00           C  
ATOM    126  O   ALA A  12       5.330  10.161   0.081  1.00  0.00           O  
ATOM    127  CB  ALA A  12       2.774   9.074   1.941  1.00  0.00           C  
ATOM    128  H   ALA A  12       4.407   7.723   3.476  1.00  0.00           H  
ATOM    129  HA  ALA A  12       4.154   8.117   0.641  1.00  0.00           H  
ATOM    130  HB1 ALA A  12       2.422   9.862   1.273  1.00  0.00           H  
ATOM    131  HB2 ALA A  12       2.113   8.210   1.802  1.00  0.00           H  
ATOM    132  HB3 ALA A  12       2.723   9.438   2.964  1.00  0.00           H  
ATOM    133  N   TYR A  13       5.634  10.614   2.259  1.00  0.00           N  
ATOM    134  CA  TYR A  13       6.509  11.765   1.999  1.00  0.00           C  
ATOM    135  C   TYR A  13       7.750  11.323   1.214  1.00  0.00           C  
ATOM    136  O   TYR A  13       8.179  12.006   0.285  1.00  0.00           O  
ATOM    137  CB  TYR A  13       6.889  12.477   3.298  1.00  0.00           C  
ATOM    138  CG  TYR A  13       7.510  13.850   3.077  1.00  0.00           C  
ATOM    139  CD1 TYR A  13       6.705  14.925   2.661  1.00  0.00           C  
ATOM    140  CD2 TYR A  13       8.884  14.059   3.286  1.00  0.00           C  
ATOM    141  CE1 TYR A  13       7.258  16.210   2.500  1.00  0.00           C  
ATOM    142  CE2 TYR A  13       9.458  15.332   3.090  1.00  0.00           C  
ATOM    143  CZ  TYR A  13       8.642  16.417   2.691  1.00  0.00           C  
ATOM    144  OH  TYR A  13       9.158  17.665   2.498  1.00  0.00           O  
ATOM    145  H   TYR A  13       5.411  10.362   3.215  1.00  0.00           H  
ATOM    146  HA  TYR A  13       5.964  12.477   1.380  1.00  0.00           H  
ATOM    147  HB2 TYR A  13       5.985  12.605   3.890  1.00  0.00           H  
ATOM    148  HB3 TYR A  13       7.574  11.848   3.870  1.00  0.00           H  
ATOM    149  HD1 TYR A  13       5.664  14.753   2.450  1.00  0.00           H  
ATOM    150  HD2 TYR A  13       9.503  13.221   3.574  1.00  0.00           H  
ATOM    151  HE1 TYR A  13       6.634  17.041   2.212  1.00  0.00           H  
ATOM    152  HE2 TYR A  13      10.523  15.459   3.228  1.00  0.00           H  
ATOM    153  HH  TYR A  13      10.123  17.708   2.362  1.00  0.00           H  
ATOM    154  N   THR A  14       8.305  10.161   1.563  1.00  0.00           N  
ATOM    155  CA  THR A  14       9.463   9.607   0.880  1.00  0.00           C  
ATOM    156  C   THR A  14       9.079   9.323  -0.577  1.00  0.00           C  
ATOM    157  O   THR A  14       9.742   9.816  -1.486  1.00  0.00           O  
ATOM    158  CB  THR A  14       9.971   8.357   1.612  1.00  0.00           C  
ATOM    159  OG1 THR A  14      10.249   8.680   2.965  1.00  0.00           O  
ATOM    160  CG2 THR A  14      11.251   7.830   0.955  1.00  0.00           C  
ATOM    161  H   THR A  14       7.907   9.654   2.341  1.00  0.00           H  
ATOM    162  HA  THR A  14      10.261  10.349   0.881  1.00  0.00           H  
ATOM    163  HB  THR A  14       9.211   7.577   1.589  1.00  0.00           H  
ATOM    164  HG1 THR A  14       9.402   8.719   3.443  1.00  0.00           H  
ATOM    165 HG21 THR A  14      12.016   8.605   0.934  1.00  0.00           H  
ATOM    166 HG22 THR A  14      11.051   7.526  -0.073  1.00  0.00           H  
ATOM    167 HG23 THR A  14      11.621   6.968   1.508  1.00  0.00           H  
ATOM    168  N   LYS A  15       8.004   8.561  -0.821  1.00  0.00           N  
ATOM    169  CA  LYS A  15       7.554   8.235  -2.170  1.00  0.00           C  
ATOM    170  C   LYS A  15       7.280   9.504  -2.965  1.00  0.00           C  
ATOM    171  O   LYS A  15       7.728   9.591  -4.095  1.00  0.00           O  
ATOM    172  CB  LYS A  15       6.374   7.255  -2.178  1.00  0.00           C  
ATOM    173  CG  LYS A  15       6.719   5.829  -1.699  1.00  0.00           C  
ATOM    174  CD  LYS A  15       7.928   5.226  -2.432  1.00  0.00           C  
ATOM    175  CE  LYS A  15       8.057   3.720  -2.198  1.00  0.00           C  
ATOM    176  NZ  LYS A  15       7.231   2.938  -3.138  1.00  0.00           N  
ATOM    177  H   LYS A  15       7.484   8.178  -0.042  1.00  0.00           H  
ATOM    178  HA  LYS A  15       8.377   7.751  -2.680  1.00  0.00           H  
ATOM    179  HB2 LYS A  15       5.559   7.656  -1.573  1.00  0.00           H  
ATOM    180  HB3 LYS A  15       6.031   7.176  -3.209  1.00  0.00           H  
ATOM    181  HG2 LYS A  15       6.940   5.833  -0.635  1.00  0.00           H  
ATOM    182  HG3 LYS A  15       5.843   5.199  -1.851  1.00  0.00           H  
ATOM    183  HD2 LYS A  15       7.862   5.430  -3.501  1.00  0.00           H  
ATOM    184  HD3 LYS A  15       8.829   5.697  -2.040  1.00  0.00           H  
ATOM    185  HE2 LYS A  15       9.100   3.424  -2.327  1.00  0.00           H  
ATOM    186  HE3 LYS A  15       7.768   3.489  -1.170  1.00  0.00           H  
ATOM    187  HZ1 LYS A  15       7.135   1.986  -2.789  1.00  0.00           H  
ATOM    188  HZ2 LYS A  15       7.643   2.898  -4.066  1.00  0.00           H  
ATOM    189  HZ3 LYS A  15       6.299   3.330  -3.244  1.00  0.00           H  
ATOM    190  N   LEU A  16       6.635  10.518  -2.396  1.00  0.00           N  
ATOM    191  CA  LEU A  16       6.350  11.797  -3.056  1.00  0.00           C  
ATOM    192  C   LEU A  16       7.644  12.506  -3.489  1.00  0.00           C  
ATOM    193  O   LEU A  16       7.573  13.402  -4.333  1.00  0.00           O  
ATOM    194  CB  LEU A  16       5.658  12.710  -2.046  1.00  0.00           C  
ATOM    195  CG  LEU A  16       4.141  12.499  -1.867  1.00  0.00           C  
ATOM    196  CD1 LEU A  16       3.646  13.097  -0.545  1.00  0.00           C  
ATOM    197  CD2 LEU A  16       3.336  13.154  -3.001  1.00  0.00           C  
ATOM    198  H   LEU A  16       6.289  10.380  -1.451  1.00  0.00           H  
ATOM    199  HA  LEU A  16       5.705  11.653  -3.923  1.00  0.00           H  
ATOM    200  HB2 LEU A  16       6.193  12.513  -1.131  1.00  0.00           H  
ATOM    201  HB3 LEU A  16       5.842  13.748  -2.299  1.00  0.00           H  
ATOM    202  HG  LEU A  16       3.937  11.432  -1.849  1.00  0.00           H  
ATOM    203 HD11 LEU A  16       3.909  14.153  -0.483  1.00  0.00           H  
ATOM    204 HD12 LEU A  16       4.093  12.560   0.288  1.00  0.00           H  
ATOM    205 HD13 LEU A  16       2.565  12.979  -0.479  1.00  0.00           H  
ATOM    206 HD21 LEU A  16       2.377  12.642  -3.100  1.00  0.00           H  
ATOM    207 HD22 LEU A  16       3.873  13.088  -3.946  1.00  0.00           H  
ATOM    208 HD23 LEU A  16       3.135  14.200  -2.783  1.00  0.00           H  
ATOM    209  N   GLY A  17       8.794  12.163  -2.896  1.00  0.00           N  
ATOM    210  CA  GLY A  17      10.111  12.722  -3.180  1.00  0.00           C  
ATOM    211  C   GLY A  17      10.874  11.923  -4.238  1.00  0.00           C  
ATOM    212  O   GLY A  17      11.897  12.397  -4.729  1.00  0.00           O  
ATOM    213  H   GLY A  17       8.785  11.420  -2.206  1.00  0.00           H  
ATOM    214  HA2 GLY A  17      10.007  13.751  -3.524  1.00  0.00           H  
ATOM    215  HA3 GLY A  17      10.698  12.725  -2.262  1.00  0.00           H  
ATOM    216  N   THR A  18      10.387  10.751  -4.640  1.00  0.00           N  
ATOM    217  CA  THR A  18      11.025   9.916  -5.657  1.00  0.00           C  
ATOM    218  C   THR A  18      10.064   9.632  -6.812  1.00  0.00           C  
ATOM    219  O   THR A  18      10.495   9.280  -7.906  1.00  0.00           O  
ATOM    220  CB  THR A  18      11.628   8.681  -4.977  1.00  0.00           C  
ATOM    221  OG1 THR A  18      12.384   7.889  -5.861  1.00  0.00           O  
ATOM    222  CG2 THR A  18      10.631   7.757  -4.284  1.00  0.00           C  
ATOM    223  H   THR A  18       9.546  10.391  -4.204  1.00  0.00           H  
ATOM    224  HA  THR A  18      11.854  10.472  -6.096  1.00  0.00           H  
ATOM    225  HB  THR A  18      12.282   9.069  -4.207  1.00  0.00           H  
ATOM    226  HG1 THR A  18      12.900   8.496  -6.434  1.00  0.00           H  
ATOM    227 HG21 THR A  18      10.178   8.311  -3.472  1.00  0.00           H  
ATOM    228 HG22 THR A  18      11.159   6.905  -3.856  1.00  0.00           H  
ATOM    229 HG23 THR A  18       9.869   7.412  -4.983  1.00  0.00           H  
ATOM    230  N   ASP A  19       8.763   9.823  -6.586  1.00  0.00           N  
ATOM    231  CA  ASP A  19       7.759   9.609  -7.618  1.00  0.00           C  
ATOM    232  C   ASP A  19       7.473  10.983  -8.208  1.00  0.00           C  
ATOM    233  O   ASP A  19       6.857  11.848  -7.573  1.00  0.00           O  
ATOM    234  CB  ASP A  19       6.506   8.896  -7.097  1.00  0.00           C  
ATOM    235  CG  ASP A  19       5.437   8.698  -8.191  1.00  0.00           C  
ATOM    236  OD1 ASP A  19       5.743   8.923  -9.385  1.00  0.00           O  
ATOM    237  OD2 ASP A  19       4.299   8.287  -7.841  1.00  0.00           O  
ATOM    238  H   ASP A  19       8.470  10.114  -5.647  1.00  0.00           H  
ATOM    239  HA  ASP A  19       8.172   8.968  -8.399  1.00  0.00           H  
ATOM    240  HB2 ASP A  19       6.797   7.916  -6.715  1.00  0.00           H  
ATOM    241  HB3 ASP A  19       6.098   9.466  -6.266  1.00  0.00           H  
ATOM    242  N   ASP A  20       8.013  11.236  -9.396  1.00  0.00           N  
ATOM    243  CA  ASP A  20       7.840  12.490 -10.117  1.00  0.00           C  
ATOM    244  C   ASP A  20       6.365  12.697 -10.454  1.00  0.00           C  
ATOM    245  O   ASP A  20       5.949  13.844 -10.605  1.00  0.00           O  
ATOM    246  CB  ASP A  20       8.678  12.536 -11.401  1.00  0.00           C  
ATOM    247  CG  ASP A  20      10.152  12.794 -11.113  1.00  0.00           C  
ATOM    248  OD1 ASP A  20      10.560  13.973 -11.003  1.00  0.00           O  
ATOM    249  OD2 ASP A  20      10.916  11.806 -11.029  1.00  0.00           O  
ATOM    250  H   ASP A  20       8.501  10.473  -9.856  1.00  0.00           H  
ATOM    251  HA  ASP A  20       8.172  13.311  -9.480  1.00  0.00           H  
ATOM    252  HB2 ASP A  20       8.558  11.606 -11.958  1.00  0.00           H  
ATOM    253  HB3 ASP A  20       8.318  13.349 -12.030  1.00  0.00           H  
ATOM    254  N   ASN A  21       5.559  11.634 -10.545  1.00  0.00           N  
ATOM    255  CA  ASN A  21       4.131  11.659 -10.849  1.00  0.00           C  
ATOM    256  C   ASN A  21       3.253  11.669  -9.593  1.00  0.00           C  
ATOM    257  O   ASN A  21       2.025  11.700  -9.714  1.00  0.00           O  
ATOM    258  CB  ASN A  21       3.763  10.449 -11.710  1.00  0.00           C  
ATOM    259  CG  ASN A  21       4.467  10.456 -13.052  1.00  0.00           C  
ATOM    260  OD1 ASN A  21       5.395   9.692 -13.286  1.00  0.00           O  
ATOM    261  ND2 ASN A  21       4.080  11.347 -13.946  1.00  0.00           N  
ATOM    262  H   ASN A  21       5.955  10.705 -10.415  1.00  0.00           H  
ATOM    263  HA  ASN A  21       3.902  12.558 -11.420  1.00  0.00           H  
ATOM    264  HB2 ASN A  21       4.004   9.529 -11.177  1.00  0.00           H  
ATOM    265  HB3 ASN A  21       2.692  10.469 -11.884  1.00  0.00           H  
ATOM    266 HD21 ASN A  21       3.275  11.920 -13.773  1.00  0.00           H  
ATOM    267 HD22 ASN A  21       4.466  11.277 -14.888  1.00  0.00           H  
ATOM    268  N   ALA A  22       3.835  11.651  -8.389  1.00  0.00           N  
ATOM    269  CA  ALA A  22       3.052  11.667  -7.162  1.00  0.00           C  
ATOM    270  C   ALA A  22       2.597  13.073  -6.806  1.00  0.00           C  
ATOM    271  O   ALA A  22       3.320  14.047  -7.038  1.00  0.00           O  
ATOM    272  CB  ALA A  22       3.872  11.119  -6.001  1.00  0.00           C  
ATOM    273  H   ALA A  22       4.846  11.622  -8.328  1.00  0.00           H  
ATOM    274  HA  ALA A  22       2.169  11.052  -7.303  1.00  0.00           H  
ATOM    275  HB1 ALA A  22       3.326  11.254  -5.073  1.00  0.00           H  
ATOM    276  HB2 ALA A  22       4.031  10.056  -6.138  1.00  0.00           H  
ATOM    277  HB3 ALA A  22       4.827  11.639  -5.940  1.00  0.00           H  
ATOM    278  N   GLN A  23       1.429  13.167  -6.173  1.00  0.00           N  
ATOM    279  CA  GLN A  23       0.803  14.393  -5.717  1.00  0.00           C  
ATOM    280  C   GLN A  23      -0.001  14.081  -4.439  1.00  0.00           C  
ATOM    281  O   GLN A  23      -0.415  12.938  -4.227  1.00  0.00           O  
ATOM    282  CB  GLN A  23      -0.126  14.943  -6.825  1.00  0.00           C  
ATOM    283  CG  GLN A  23       0.551  15.365  -8.151  1.00  0.00           C  
ATOM    284  CD  GLN A  23       1.309  16.698  -8.088  1.00  0.00           C  
ATOM    285  OE1 GLN A  23       0.990  17.580  -7.295  1.00  0.00           O  
ATOM    286  NE2 GLN A  23       2.297  16.923  -8.930  1.00  0.00           N  
ATOM    287  H   GLN A  23       0.873  12.330  -6.016  1.00  0.00           H  
ATOM    288  HA  GLN A  23       1.602  15.095  -5.471  1.00  0.00           H  
ATOM    289  HB2 GLN A  23      -0.855  14.164  -7.061  1.00  0.00           H  
ATOM    290  HB3 GLN A  23      -0.690  15.789  -6.432  1.00  0.00           H  
ATOM    291  HG2 GLN A  23       1.203  14.572  -8.507  1.00  0.00           H  
ATOM    292  HG3 GLN A  23      -0.221  15.466  -8.910  1.00  0.00           H  
ATOM    293 HE21 GLN A  23       2.599  16.163  -9.546  1.00  0.00           H  
ATOM    294 HE22 GLN A  23       2.758  17.812  -9.000  1.00  0.00           H  
ATOM    295  N   LEU A  24      -0.220  15.081  -3.580  1.00  0.00           N  
ATOM    296  CA  LEU A  24      -0.962  14.990  -2.320  1.00  0.00           C  
ATOM    297  C   LEU A  24      -2.324  15.646  -2.526  1.00  0.00           C  
ATOM    298  O   LEU A  24      -2.401  16.772  -3.027  1.00  0.00           O  
ATOM    299  CB  LEU A  24      -0.164  15.697  -1.209  1.00  0.00           C  
ATOM    300  CG  LEU A  24      -0.576  15.464   0.262  1.00  0.00           C  
ATOM    301  CD1 LEU A  24      -1.953  16.018   0.645  1.00  0.00           C  
ATOM    302  CD2 LEU A  24      -0.478  13.992   0.677  1.00  0.00           C  
ATOM    303  H   LEU A  24       0.150  15.991  -3.832  1.00  0.00           H  
ATOM    304  HA  LEU A  24      -1.096  13.941  -2.056  1.00  0.00           H  
ATOM    305  HB2 LEU A  24       0.881  15.396  -1.300  1.00  0.00           H  
ATOM    306  HB3 LEU A  24      -0.213  16.767  -1.402  1.00  0.00           H  
ATOM    307  HG  LEU A  24       0.153  16.012   0.861  1.00  0.00           H  
ATOM    308 HD11 LEU A  24      -2.012  16.136   1.726  1.00  0.00           H  
ATOM    309 HD12 LEU A  24      -2.747  15.337   0.347  1.00  0.00           H  
ATOM    310 HD13 LEU A  24      -2.115  16.993   0.184  1.00  0.00           H  
ATOM    311 HD21 LEU A  24       0.492  13.589   0.387  1.00  0.00           H  
ATOM    312 HD22 LEU A  24      -1.267  13.408   0.204  1.00  0.00           H  
ATOM    313 HD23 LEU A  24      -0.576  13.915   1.757  1.00  0.00           H  
ATOM    314  N   LEU A  25      -3.385  14.952  -2.122  1.00  0.00           N  
ATOM    315  CA  LEU A  25      -4.769  15.376  -2.230  1.00  0.00           C  
ATOM    316  C   LEU A  25      -5.408  15.380  -0.836  1.00  0.00           C  
ATOM    317  O   LEU A  25      -5.529  14.343  -0.190  1.00  0.00           O  
ATOM    318  CB  LEU A  25      -5.465  14.426  -3.209  1.00  0.00           C  
ATOM    319  CG  LEU A  25      -6.999  14.589  -3.211  1.00  0.00           C  
ATOM    320  CD1 LEU A  25      -7.457  15.938  -3.780  1.00  0.00           C  
ATOM    321  CD2 LEU A  25      -7.615  13.480  -4.050  1.00  0.00           C  
ATOM    322  H   LEU A  25      -3.248  14.030  -1.711  1.00  0.00           H  
ATOM    323  HA  LEU A  25      -4.812  16.383  -2.644  1.00  0.00           H  
ATOM    324  HB2 LEU A  25      -5.078  14.601  -4.216  1.00  0.00           H  
ATOM    325  HB3 LEU A  25      -5.176  13.406  -2.934  1.00  0.00           H  
ATOM    326  HG  LEU A  25      -7.396  14.489  -2.202  1.00  0.00           H  
ATOM    327 HD11 LEU A  25      -7.111  16.745  -3.139  1.00  0.00           H  
ATOM    328 HD12 LEU A  25      -8.546  15.961  -3.809  1.00  0.00           H  
ATOM    329 HD13 LEU A  25      -7.068  16.069  -4.790  1.00  0.00           H  
ATOM    330 HD21 LEU A  25      -8.695  13.614  -4.111  1.00  0.00           H  
ATOM    331 HD22 LEU A  25      -7.400  12.532  -3.561  1.00  0.00           H  
ATOM    332 HD23 LEU A  25      -7.184  13.478  -5.049  1.00  0.00           H  
ATOM    333  N   ASP A  26      -5.782  16.570  -0.368  1.00  0.00           N  
ATOM    334  CA  ASP A  26      -6.409  16.830   0.917  1.00  0.00           C  
ATOM    335  C   ASP A  26      -7.917  16.617   0.801  1.00  0.00           C  
ATOM    336  O   ASP A  26      -8.626  17.462   0.230  1.00  0.00           O  
ATOM    337  CB  ASP A  26      -6.229  18.294   1.348  1.00  0.00           C  
ATOM    338  CG  ASP A  26      -4.908  18.697   1.975  1.00  0.00           C  
ATOM    339  OD1 ASP A  26      -4.580  18.150   3.047  1.00  0.00           O  
ATOM    340  OD2 ASP A  26      -4.360  19.745   1.560  1.00  0.00           O  
ATOM    341  H   ASP A  26      -5.659  17.381  -0.962  1.00  0.00           H  
ATOM    342  HA  ASP A  26      -5.993  16.176   1.685  1.00  0.00           H  
ATOM    343  HB2 ASP A  26      -6.431  18.950   0.502  1.00  0.00           H  
ATOM    344  HB3 ASP A  26      -6.976  18.492   2.117  1.00  0.00           H  
ATOM    345  N   ILE A  27      -8.423  15.499   1.321  1.00  0.00           N  
ATOM    346  CA  ILE A  27      -9.858  15.209   1.313  1.00  0.00           C  
ATOM    347  C   ILE A  27     -10.528  15.742   2.589  1.00  0.00           C  
ATOM    348  O   ILE A  27     -11.738  15.563   2.783  1.00  0.00           O  
ATOM    349  CB  ILE A  27     -10.179  13.733   1.028  1.00  0.00           C  
ATOM    350  CG1 ILE A  27      -9.676  12.760   2.111  1.00  0.00           C  
ATOM    351  CG2 ILE A  27      -9.677  13.365  -0.376  1.00  0.00           C  
ATOM    352  CD1 ILE A  27     -10.359  11.386   2.030  1.00  0.00           C  
ATOM    353  H   ILE A  27      -7.798  14.842   1.783  1.00  0.00           H  
ATOM    354  HA  ILE A  27     -10.298  15.770   0.500  1.00  0.00           H  
ATOM    355  HB  ILE A  27     -11.264  13.675   1.009  1.00  0.00           H  
ATOM    356 HG12 ILE A  27      -8.597  12.637   2.024  1.00  0.00           H  
ATOM    357 HG13 ILE A  27      -9.893  13.182   3.092  1.00  0.00           H  
ATOM    358 HG21 ILE A  27      -8.586  13.339  -0.397  1.00  0.00           H  
ATOM    359 HG22 ILE A  27     -10.070  12.396  -0.671  1.00  0.00           H  
ATOM    360 HG23 ILE A  27     -10.032  14.112  -1.086  1.00  0.00           H  
ATOM    361 HD11 ILE A  27     -11.435  11.499   2.165  1.00  0.00           H  
ATOM    362 HD12 ILE A  27     -10.165  10.916   1.067  1.00  0.00           H  
ATOM    363 HD13 ILE A  27      -9.971  10.737   2.815  1.00  0.00           H  
ATOM    364  N   ARG A  28      -9.740  16.414   3.440  1.00  0.00           N  
ATOM    365  CA  ARG A  28     -10.169  17.009   4.696  1.00  0.00           C  
ATOM    366  C   ARG A  28     -11.298  17.993   4.472  1.00  0.00           C  
ATOM    367  O   ARG A  28     -11.574  18.420   3.345  1.00  0.00           O  
ATOM    368  CB  ARG A  28      -9.038  17.790   5.378  1.00  0.00           C  
ATOM    369  CG  ARG A  28      -7.790  16.943   5.658  1.00  0.00           C  
ATOM    370  CD  ARG A  28      -6.710  17.737   6.392  1.00  0.00           C  
ATOM    371  NE  ARG A  28      -5.946  18.572   5.453  1.00  0.00           N  
ATOM    372  CZ  ARG A  28      -5.769  19.892   5.498  1.00  0.00           C  
ATOM    373  NH1 ARG A  28      -6.193  20.619   6.526  1.00  0.00           N  
ATOM    374  NH2 ARG A  28      -5.152  20.484   4.490  1.00  0.00           N  
ATOM    375  H   ARG A  28      -8.767  16.494   3.184  1.00  0.00           H  
ATOM    376  HA  ARG A  28     -10.496  16.204   5.350  1.00  0.00           H  
ATOM    377  HB2 ARG A  28      -8.835  18.683   4.780  1.00  0.00           H  
ATOM    378  HB3 ARG A  28      -9.397  18.146   6.340  1.00  0.00           H  
ATOM    379  HG2 ARG A  28      -8.083  16.110   6.292  1.00  0.00           H  
ATOM    380  HG3 ARG A  28      -7.382  16.550   4.728  1.00  0.00           H  
ATOM    381  HD2 ARG A  28      -7.176  18.336   7.174  1.00  0.00           H  
ATOM    382  HD3 ARG A  28      -6.027  17.041   6.879  1.00  0.00           H  
ATOM    383  HE  ARG A  28      -5.492  18.081   4.674  1.00  0.00           H  
ATOM    384 HH11 ARG A  28      -6.584  20.159   7.339  1.00  0.00           H  
ATOM    385 HH12 ARG A  28      -5.895  21.587   6.614  1.00  0.00           H  
ATOM    386 HH21 ARG A  28      -4.765  19.888   3.745  1.00  0.00           H  
ATOM    387 HH22 ARG A  28      -5.128  21.483   4.379  1.00  0.00           H  
ATOM    388  N   ALA A  29     -11.956  18.347   5.563  1.00  0.00           N  
ATOM    389  CA  ALA A  29     -13.035  19.289   5.554  1.00  0.00           C  
ATOM    390  C   ALA A  29     -12.391  20.663   5.581  1.00  0.00           C  
ATOM    391  O   ALA A  29     -11.418  20.876   6.299  1.00  0.00           O  
ATOM    392  CB  ALA A  29     -13.875  19.072   6.810  1.00  0.00           C  
ATOM    393  H   ALA A  29     -11.678  17.984   6.468  1.00  0.00           H  
ATOM    394  HA  ALA A  29     -13.652  19.162   4.665  1.00  0.00           H  
ATOM    395  HB1 ALA A  29     -14.704  19.771   6.822  1.00  0.00           H  
ATOM    396  HB2 ALA A  29     -14.262  18.057   6.818  1.00  0.00           H  
ATOM    397  HB3 ALA A  29     -13.266  19.233   7.700  1.00  0.00           H  
ATOM    398  N   THR A  30     -12.958  21.611   4.853  1.00  0.00           N  
ATOM    399  CA  THR A  30     -12.512  23.000   4.777  1.00  0.00           C  
ATOM    400  C   THR A  30     -12.292  23.592   6.184  1.00  0.00           C  
ATOM    401  O   THR A  30     -11.374  24.388   6.364  1.00  0.00           O  
ATOM    402  CB  THR A  30     -13.532  23.783   3.945  1.00  0.00           C  
ATOM    403  OG1 THR A  30     -13.594  23.190   2.657  1.00  0.00           O  
ATOM    404  CG2 THR A  30     -13.173  25.262   3.825  1.00  0.00           C  
ATOM    405  H   THR A  30     -13.735  21.330   4.289  1.00  0.00           H  
ATOM    406  HA  THR A  30     -11.559  23.031   4.250  1.00  0.00           H  
ATOM    407  HB  THR A  30     -14.513  23.706   4.410  1.00  0.00           H  
ATOM    408  HG1 THR A  30     -14.204  23.727   2.111  1.00  0.00           H  
ATOM    409 HG21 THR A  30     -12.136  25.374   3.509  1.00  0.00           H  
ATOM    410 HG22 THR A  30     -13.298  25.759   4.788  1.00  0.00           H  
ATOM    411 HG23 THR A  30     -13.830  25.739   3.103  1.00  0.00           H  
ATOM    412  N   ALA A  31     -13.081  23.195   7.191  1.00  0.00           N  
ATOM    413  CA  ALA A  31     -12.913  23.687   8.553  1.00  0.00           C  
ATOM    414  C   ALA A  31     -11.531  23.293   9.094  1.00  0.00           C  
ATOM    415  O   ALA A  31     -10.933  24.058   9.848  1.00  0.00           O  
ATOM    416  CB  ALA A  31     -14.030  23.134   9.443  1.00  0.00           C  
ATOM    417  H   ALA A  31     -13.829  22.541   6.991  1.00  0.00           H  
ATOM    418  HA  ALA A  31     -12.969  24.777   8.542  1.00  0.00           H  
ATOM    419  HB1 ALA A  31     -14.997  23.438   9.045  1.00  0.00           H  
ATOM    420  HB2 ALA A  31     -13.978  22.043   9.477  1.00  0.00           H  
ATOM    421  HB3 ALA A  31     -13.914  23.526  10.454  1.00  0.00           H  
ATOM    422  N   ASP A  32     -11.015  22.113   8.734  1.00  0.00           N  
ATOM    423  CA  ASP A  32      -9.703  21.637   9.166  1.00  0.00           C  
ATOM    424  C   ASP A  32      -8.649  22.593   8.589  1.00  0.00           C  
ATOM    425  O   ASP A  32      -7.705  22.975   9.277  1.00  0.00           O  
ATOM    426  CB  ASP A  32      -9.391  20.181   8.717  1.00  0.00           C  
ATOM    427  CG  ASP A  32     -10.368  19.090   9.189  1.00  0.00           C  
ATOM    428  OD1 ASP A  32     -10.671  19.069  10.408  1.00  0.00           O  
ATOM    429  OD2 ASP A  32     -10.825  18.247   8.375  1.00  0.00           O  
ATOM    430  H   ASP A  32     -11.539  21.516   8.104  1.00  0.00           H  
ATOM    431  HA  ASP A  32      -9.662  21.675  10.255  1.00  0.00           H  
ATOM    432  HB2 ASP A  32      -9.269  20.151   7.642  1.00  0.00           H  
ATOM    433  HB3 ASP A  32      -8.419  19.912   9.118  1.00  0.00           H  
ATOM    434  N   PHE A  33      -8.812  23.064   7.346  1.00  0.00           N  
ATOM    435  CA  PHE A  33      -7.855  23.970   6.704  1.00  0.00           C  
ATOM    436  C   PHE A  33      -7.629  25.280   7.445  1.00  0.00           C  
ATOM    437  O   PHE A  33      -6.616  25.946   7.212  1.00  0.00           O  
ATOM    438  CB  PHE A  33      -8.236  24.312   5.260  1.00  0.00           C  
ATOM    439  CG  PHE A  33      -8.085  23.176   4.284  1.00  0.00           C  
ATOM    440  CD1 PHE A  33      -8.991  22.108   4.306  1.00  0.00           C  
ATOM    441  CD2 PHE A  33      -7.060  23.206   3.324  1.00  0.00           C  
ATOM    442  CE1 PHE A  33      -8.911  21.094   3.346  1.00  0.00           C  
ATOM    443  CE2 PHE A  33      -6.958  22.175   2.380  1.00  0.00           C  
ATOM    444  CZ  PHE A  33      -7.906  21.138   2.371  1.00  0.00           C  
ATOM    445  H   PHE A  33      -9.609  22.730   6.820  1.00  0.00           H  
ATOM    446  HA  PHE A  33      -6.915  23.448   6.678  1.00  0.00           H  
ATOM    447  HB2 PHE A  33      -9.251  24.697   5.215  1.00  0.00           H  
ATOM    448  HB3 PHE A  33      -7.596  25.127   4.916  1.00  0.00           H  
ATOM    449  HD1 PHE A  33      -9.776  22.080   5.039  1.00  0.00           H  
ATOM    450  HD2 PHE A  33      -6.381  24.043   3.278  1.00  0.00           H  
ATOM    451  HE1 PHE A  33      -9.641  20.300   3.344  1.00  0.00           H  
ATOM    452  HE2 PHE A  33      -6.174  22.203   1.644  1.00  0.00           H  
ATOM    453  HZ  PHE A  33      -7.893  20.386   1.603  1.00  0.00           H  
ATOM    454  N   ARG A  34      -8.557  25.678   8.306  1.00  0.00           N  
ATOM    455  CA  ARG A  34      -8.461  26.924   9.057  1.00  0.00           C  
ATOM    456  C   ARG A  34      -7.885  26.698  10.442  1.00  0.00           C  
ATOM    457  O   ARG A  34      -7.312  27.620  11.018  1.00  0.00           O  
ATOM    458  CB  ARG A  34      -9.849  27.557   9.102  1.00  0.00           C  
ATOM    459  CG  ARG A  34     -10.384  27.674   7.665  1.00  0.00           C  
ATOM    460  CD  ARG A  34     -11.472  28.718   7.567  1.00  0.00           C  
ATOM    461  NE  ARG A  34     -12.700  28.314   8.253  1.00  0.00           N  
ATOM    462  CZ  ARG A  34     -13.450  29.075   9.049  1.00  0.00           C  
ATOM    463  NH1 ARG A  34     -13.016  30.227   9.548  1.00  0.00           N  
ATOM    464  NH2 ARG A  34     -14.669  28.660   9.335  1.00  0.00           N  
ATOM    465  H   ARG A  34      -9.360  25.075   8.448  1.00  0.00           H  
ATOM    466  HA  ARG A  34      -7.791  27.611   8.539  1.00  0.00           H  
ATOM    467  HB2 ARG A  34     -10.528  26.950   9.703  1.00  0.00           H  
ATOM    468  HB3 ARG A  34      -9.761  28.542   9.557  1.00  0.00           H  
ATOM    469  HG2 ARG A  34      -9.577  27.970   6.993  1.00  0.00           H  
ATOM    470  HG3 ARG A  34     -10.781  26.717   7.328  1.00  0.00           H  
ATOM    471  HD2 ARG A  34     -11.081  29.637   7.982  1.00  0.00           H  
ATOM    472  HD3 ARG A  34     -11.698  28.860   6.514  1.00  0.00           H  
ATOM    473  HE  ARG A  34     -13.103  27.431   7.939  1.00  0.00           H  
ATOM    474 HH11 ARG A  34     -12.040  30.502   9.432  1.00  0.00           H  
ATOM    475 HH12 ARG A  34     -13.596  30.802  10.141  1.00  0.00           H  
ATOM    476 HH21 ARG A  34     -15.008  27.805   8.903  1.00  0.00           H  
ATOM    477 HH22 ARG A  34     -15.330  29.246   9.852  1.00  0.00           H  
ATOM    478  N   GLN A  35      -8.018  25.470  10.928  1.00  0.00           N  
ATOM    479  CA  GLN A  35      -7.534  25.007  12.217  1.00  0.00           C  
ATOM    480  C   GLN A  35      -6.114  24.454  12.101  1.00  0.00           C  
ATOM    481  O   GLN A  35      -5.173  25.054  12.611  1.00  0.00           O  
ATOM    482  CB  GLN A  35      -8.447  23.907  12.774  1.00  0.00           C  
ATOM    483  CG  GLN A  35      -9.852  24.407  13.079  1.00  0.00           C  
ATOM    484  CD  GLN A  35     -10.670  23.300  13.721  1.00  0.00           C  
ATOM    485  OE1 GLN A  35     -10.498  22.990  14.900  1.00  0.00           O  
ATOM    486  NE2 GLN A  35     -11.552  22.666  12.968  1.00  0.00           N  
ATOM    487  H   GLN A  35      -8.525  24.839  10.323  1.00  0.00           H  
ATOM    488  HA  GLN A  35      -7.523  25.844  12.919  1.00  0.00           H  
ATOM    489  HB2 GLN A  35      -8.521  23.082  12.062  1.00  0.00           H  
ATOM    490  HB3 GLN A  35      -8.002  23.532  13.694  1.00  0.00           H  
ATOM    491  HG2 GLN A  35      -9.793  25.249  13.763  1.00  0.00           H  
ATOM    492  HG3 GLN A  35     -10.317  24.728  12.152  1.00  0.00           H  
ATOM    493 HE21 GLN A  35     -11.645  22.895  11.991  1.00  0.00           H  
ATOM    494 HE22 GLN A  35     -12.029  21.870  13.379  1.00  0.00           H  
ATOM    495  N   VAL A  36      -5.954  23.299  11.454  1.00  0.00           N  
ATOM    496  CA  VAL A  36      -4.679  22.619  11.286  1.00  0.00           C  
ATOM    497  C   VAL A  36      -3.830  23.273  10.198  1.00  0.00           C  
ATOM    498  O   VAL A  36      -2.611  23.311  10.328  1.00  0.00           O  
ATOM    499  CB  VAL A  36      -4.924  21.105  11.073  1.00  0.00           C  
ATOM    500  CG1 VAL A  36      -5.604  20.746   9.754  1.00  0.00           C  
ATOM    501  CG2 VAL A  36      -3.634  20.293  11.235  1.00  0.00           C  
ATOM    502  H   VAL A  36      -6.770  22.862  11.044  1.00  0.00           H  
ATOM    503  HA  VAL A  36      -4.133  22.726  12.225  1.00  0.00           H  
ATOM    504  HB  VAL A  36      -5.630  20.769  11.831  1.00  0.00           H  
ATOM    505 HG11 VAL A  36      -5.191  21.314   8.927  1.00  0.00           H  
ATOM    506 HG12 VAL A  36      -5.488  19.684   9.554  1.00  0.00           H  
ATOM    507 HG13 VAL A  36      -6.663  20.948   9.875  1.00  0.00           H  
ATOM    508 HG21 VAL A  36      -3.866  19.227  11.255  1.00  0.00           H  
ATOM    509 HG22 VAL A  36      -2.948  20.495  10.414  1.00  0.00           H  
ATOM    510 HG23 VAL A  36      -3.151  20.558  12.175  1.00  0.00           H  
ATOM    511  N   GLY A  37      -4.438  23.845   9.156  1.00  0.00           N  
ATOM    512  CA  GLY A  37      -3.706  24.483   8.065  1.00  0.00           C  
ATOM    513  C   GLY A  37      -3.692  23.578   6.842  1.00  0.00           C  
ATOM    514  O   GLY A  37      -4.726  23.028   6.465  1.00  0.00           O  
ATOM    515  H   GLY A  37      -5.447  23.773   9.105  1.00  0.00           H  
ATOM    516  HA2 GLY A  37      -4.180  25.429   7.811  1.00  0.00           H  
ATOM    517  HA3 GLY A  37      -2.682  24.694   8.364  1.00  0.00           H  
ATOM    518  N   SER A  38      -2.572  23.465   6.141  1.00  0.00           N  
ATOM    519  CA  SER A  38      -2.461  22.620   4.956  1.00  0.00           C  
ATOM    520  C   SER A  38      -1.051  22.061   4.856  1.00  0.00           C  
ATOM    521  O   SER A  38      -0.145  22.623   5.476  1.00  0.00           O  
ATOM    522  CB  SER A  38      -2.783  23.445   3.706  1.00  0.00           C  
ATOM    523  OG  SER A  38      -3.909  24.293   3.883  1.00  0.00           O  
ATOM    524  H   SER A  38      -1.711  23.912   6.450  1.00  0.00           H  
ATOM    525  HA  SER A  38      -3.138  21.776   5.044  1.00  0.00           H  
ATOM    526  HB2 SER A  38      -1.916  24.062   3.467  1.00  0.00           H  
ATOM    527  HB3 SER A  38      -2.984  22.778   2.871  1.00  0.00           H  
ATOM    528  HG  SER A  38      -4.354  24.017   4.698  1.00  0.00           H  
ATOM    529  N   PRO A  39      -0.820  21.003   4.065  1.00  0.00           N  
ATOM    530  CA  PRO A  39       0.511  20.475   3.960  1.00  0.00           C  
ATOM    531  C   PRO A  39       1.406  21.459   3.237  1.00  0.00           C  
ATOM    532  O   PRO A  39       1.001  22.388   2.530  1.00  0.00           O  
ATOM    533  CB  PRO A  39       0.431  19.176   3.186  1.00  0.00           C  
ATOM    534  CG  PRO A  39      -0.828  19.377   2.343  1.00  0.00           C  
ATOM    535  CD  PRO A  39      -1.731  20.212   3.257  1.00  0.00           C  
ATOM    536  HA  PRO A  39       0.922  20.263   4.954  1.00  0.00           H  
ATOM    537  HB2 PRO A  39       1.377  19.056   2.618  1.00  0.00           H  
ATOM    538  HB3 PRO A  39       0.253  18.373   3.904  1.00  0.00           H  
ATOM    539  HG2 PRO A  39      -0.581  19.953   1.452  1.00  0.00           H  
ATOM    540  HG3 PRO A  39      -1.299  18.432   2.082  1.00  0.00           H  
ATOM    541  HD2 PRO A  39      -2.384  20.834   2.653  1.00  0.00           H  
ATOM    542  HD3 PRO A  39      -2.319  19.556   3.900  1.00  0.00           H  
ATOM    543  N   ASN A  40       2.665  21.162   3.445  1.00  0.00           N  
ATOM    544  CA  ASN A  40       3.873  21.767   3.013  1.00  0.00           C  
ATOM    545  C   ASN A  40       4.668  20.649   2.349  1.00  0.00           C  
ATOM    546  O   ASN A  40       5.415  19.942   3.019  1.00  0.00           O  
ATOM    547  CB  ASN A  40       4.546  22.238   4.305  1.00  0.00           C  
ATOM    548  CG  ASN A  40       5.833  22.967   4.156  1.00  0.00           C  
ATOM    549  OD1 ASN A  40       6.122  23.917   4.863  1.00  0.00           O  
ATOM    550  ND2 ASN A  40       6.666  22.429   3.318  1.00  0.00           N  
ATOM    551  H   ASN A  40       2.816  20.354   4.039  1.00  0.00           H  
ATOM    552  HA  ASN A  40       3.692  22.590   2.330  1.00  0.00           H  
ATOM    553  HB2 ASN A  40       3.901  22.787   4.951  1.00  0.00           H  
ATOM    554  HB3 ASN A  40       4.770  21.374   4.869  1.00  0.00           H  
ATOM    555 HD21 ASN A  40       6.413  21.492   2.972  1.00  0.00           H  
ATOM    556 HD22 ASN A  40       7.592  22.773   3.415  1.00  0.00           H  
ATOM    557  N   ILE A  41       4.539  20.472   1.046  1.00  0.00           N  
ATOM    558  CA  ILE A  41       5.279  19.437   0.329  1.00  0.00           C  
ATOM    559  C   ILE A  41       6.250  20.047  -0.669  1.00  0.00           C  
ATOM    560  O   ILE A  41       7.198  19.362  -1.048  1.00  0.00           O  
ATOM    561  CB  ILE A  41       4.325  18.447  -0.365  1.00  0.00           C  
ATOM    562  CG1 ILE A  41       3.337  19.185  -1.301  1.00  0.00           C  
ATOM    563  CG2 ILE A  41       3.626  17.568   0.685  1.00  0.00           C  
ATOM    564  CD1 ILE A  41       2.338  18.268  -1.993  1.00  0.00           C  
ATOM    565  H   ILE A  41       3.910  21.086   0.537  1.00  0.00           H  
ATOM    566  HA  ILE A  41       5.894  18.864   1.024  1.00  0.00           H  
ATOM    567  HB  ILE A  41       4.946  17.786  -0.970  1.00  0.00           H  
ATOM    568 HG12 ILE A  41       2.760  19.918  -0.738  1.00  0.00           H  
ATOM    569 HG13 ILE A  41       3.897  19.714  -2.073  1.00  0.00           H  
ATOM    570 HG21 ILE A  41       3.090  16.752   0.201  1.00  0.00           H  
ATOM    571 HG22 ILE A  41       4.372  17.125   1.342  1.00  0.00           H  
ATOM    572 HG23 ILE A  41       2.938  18.165   1.277  1.00  0.00           H  
ATOM    573 HD11 ILE A  41       1.751  18.859  -2.692  1.00  0.00           H  
ATOM    574 HD12 ILE A  41       2.849  17.470  -2.531  1.00  0.00           H  
ATOM    575 HD13 ILE A  41       1.668  17.845  -1.252  1.00  0.00           H  
ATOM    576  N   LYS A  42       6.048  21.309  -1.066  1.00  0.00           N  
ATOM    577  CA  LYS A  42       6.861  22.040  -2.047  1.00  0.00           C  
ATOM    578  C   LYS A  42       8.369  21.868  -1.907  1.00  0.00           C  
ATOM    579  O   LYS A  42       9.037  22.001  -2.934  1.00  0.00           O  
ATOM    580  CB  LYS A  42       6.517  23.529  -2.033  1.00  0.00           C  
ATOM    581  CG  LYS A  42       5.159  23.853  -2.667  1.00  0.00           C  
ATOM    582  CD  LYS A  42       4.686  25.257  -2.259  1.00  0.00           C  
ATOM    583  CE  LYS A  42       5.446  26.385  -2.961  1.00  0.00           C  
ATOM    584  NZ  LYS A  42       5.133  26.453  -4.406  1.00  0.00           N  
ATOM    585  H   LYS A  42       5.231  21.764  -0.678  1.00  0.00           H  
ATOM    586  HA  LYS A  42       6.596  21.641  -3.028  1.00  0.00           H  
ATOM    587  HB2 LYS A  42       6.529  23.838  -0.995  1.00  0.00           H  
ATOM    588  HB3 LYS A  42       7.287  24.089  -2.569  1.00  0.00           H  
ATOM    589  HG2 LYS A  42       5.231  23.778  -3.752  1.00  0.00           H  
ATOM    590  HG3 LYS A  42       4.419  23.127  -2.337  1.00  0.00           H  
ATOM    591  HD2 LYS A  42       3.630  25.357  -2.491  1.00  0.00           H  
ATOM    592  HD3 LYS A  42       4.795  25.378  -1.180  1.00  0.00           H  
ATOM    593  HE2 LYS A  42       5.165  27.331  -2.493  1.00  0.00           H  
ATOM    594  HE3 LYS A  42       6.520  26.252  -2.817  1.00  0.00           H  
ATOM    595  HZ1 LYS A  42       5.469  25.640  -4.911  1.00  0.00           H  
ATOM    596  HZ2 LYS A  42       5.603  27.253  -4.817  1.00  0.00           H  
ATOM    597  HZ3 LYS A  42       4.139  26.571  -4.577  1.00  0.00           H  
ATOM    598  N   GLY A  43       8.902  21.574  -0.713  1.00  0.00           N  
ATOM    599  CA  GLY A  43      10.328  21.358  -0.507  1.00  0.00           C  
ATOM    600  C   GLY A  43      10.849  20.297  -1.473  1.00  0.00           C  
ATOM    601  O   GLY A  43      12.029  20.328  -1.808  1.00  0.00           O  
ATOM    602  H   GLY A  43       8.320  21.465   0.108  1.00  0.00           H  
ATOM    603  HA2 GLY A  43      10.866  22.287  -0.684  1.00  0.00           H  
ATOM    604  HA3 GLY A  43      10.507  21.034   0.518  1.00  0.00           H  
ATOM    605  N   LEU A  44       9.993  19.356  -1.894  1.00  0.00           N  
ATOM    606  CA  LEU A  44      10.325  18.312  -2.851  1.00  0.00           C  
ATOM    607  C   LEU A  44      10.144  18.988  -4.220  1.00  0.00           C  
ATOM    608  O   LEU A  44      11.132  19.341  -4.865  1.00  0.00           O  
ATOM    609  CB  LEU A  44       9.449  17.051  -2.674  1.00  0.00           C  
ATOM    610  CG  LEU A  44       9.296  16.528  -1.231  1.00  0.00           C  
ATOM    611  CD1 LEU A  44       8.149  15.514  -1.185  1.00  0.00           C  
ATOM    612  CD2 LEU A  44      10.590  15.906  -0.705  1.00  0.00           C  
ATOM    613  H   LEU A  44       9.037  19.407  -1.562  1.00  0.00           H  
ATOM    614  HA  LEU A  44      11.373  18.030  -2.727  1.00  0.00           H  
ATOM    615  HB2 LEU A  44       8.456  17.251  -3.055  1.00  0.00           H  
ATOM    616  HB3 LEU A  44       9.866  16.259  -3.299  1.00  0.00           H  
ATOM    617  HG  LEU A  44       9.020  17.347  -0.568  1.00  0.00           H  
ATOM    618 HD11 LEU A  44       7.214  16.010  -1.445  1.00  0.00           H  
ATOM    619 HD12 LEU A  44       8.058  15.095  -0.182  1.00  0.00           H  
ATOM    620 HD13 LEU A  44       8.335  14.711  -1.892  1.00  0.00           H  
ATOM    621 HD21 LEU A  44      11.370  16.667  -0.664  1.00  0.00           H  
ATOM    622 HD22 LEU A  44      10.920  15.098  -1.358  1.00  0.00           H  
ATOM    623 HD23 LEU A  44      10.440  15.513   0.299  1.00  0.00           H  
ATOM    624  N   GLY A  45       8.896  19.265  -4.639  1.00  0.00           N  
ATOM    625  CA  GLY A  45       8.614  19.921  -5.919  1.00  0.00           C  
ATOM    626  C   GLY A  45       7.204  19.698  -6.469  1.00  0.00           C  
ATOM    627  O   GLY A  45       7.042  19.659  -7.688  1.00  0.00           O  
ATOM    628  H   GLY A  45       8.115  18.952  -4.078  1.00  0.00           H  
ATOM    629  HA2 GLY A  45       8.766  20.990  -5.803  1.00  0.00           H  
ATOM    630  HA3 GLY A  45       9.326  19.562  -6.664  1.00  0.00           H  
ATOM    631  N   LYS A  46       6.173  19.550  -5.629  1.00  0.00           N  
ATOM    632  CA  LYS A  46       4.778  19.301  -6.022  1.00  0.00           C  
ATOM    633  C   LYS A  46       3.843  20.337  -5.371  1.00  0.00           C  
ATOM    634  O   LYS A  46       4.315  21.190  -4.614  1.00  0.00           O  
ATOM    635  CB  LYS A  46       4.387  17.862  -5.613  1.00  0.00           C  
ATOM    636  CG  LYS A  46       5.374  16.698  -5.885  1.00  0.00           C  
ATOM    637  CD  LYS A  46       5.811  16.496  -7.341  1.00  0.00           C  
ATOM    638  CE  LYS A  46       6.277  15.059  -7.635  1.00  0.00           C  
ATOM    639  NZ  LYS A  46       7.435  14.594  -6.836  1.00  0.00           N  
ATOM    640  H   LYS A  46       6.334  19.597  -4.621  1.00  0.00           H  
ATOM    641  HA  LYS A  46       4.686  19.396  -7.102  1.00  0.00           H  
ATOM    642  HB2 LYS A  46       4.180  17.887  -4.541  1.00  0.00           H  
ATOM    643  HB3 LYS A  46       3.453  17.602  -6.096  1.00  0.00           H  
ATOM    644  HG2 LYS A  46       6.272  16.816  -5.281  1.00  0.00           H  
ATOM    645  HG3 LYS A  46       4.877  15.785  -5.555  1.00  0.00           H  
ATOM    646  HD2 LYS A  46       4.969  16.720  -7.996  1.00  0.00           H  
ATOM    647  HD3 LYS A  46       6.621  17.182  -7.584  1.00  0.00           H  
ATOM    648  HE2 LYS A  46       5.446  14.375  -7.467  1.00  0.00           H  
ATOM    649  HE3 LYS A  46       6.539  15.008  -8.691  1.00  0.00           H  
ATOM    650  HZ1 LYS A  46       7.219  14.502  -5.850  1.00  0.00           H  
ATOM    651  HZ2 LYS A  46       8.230  15.229  -6.904  1.00  0.00           H  
ATOM    652  HZ3 LYS A  46       7.707  13.658  -7.123  1.00  0.00           H  
ATOM    653  N   LYS A  47       2.530  20.294  -5.654  1.00  0.00           N  
ATOM    654  CA  LYS A  47       1.527  21.219  -5.096  1.00  0.00           C  
ATOM    655  C   LYS A  47       0.320  20.439  -4.592  1.00  0.00           C  
ATOM    656  O   LYS A  47      -0.152  19.528  -5.277  1.00  0.00           O  
ATOM    657  CB  LYS A  47       1.103  22.290  -6.122  1.00  0.00           C  
ATOM    658  CG  LYS A  47       0.351  21.767  -7.363  1.00  0.00           C  
ATOM    659  CD  LYS A  47      -0.227  22.835  -8.305  1.00  0.00           C  
ATOM    660  CE  LYS A  47       0.763  23.467  -9.290  1.00  0.00           C  
ATOM    661  NZ  LYS A  47       1.822  24.254  -8.636  1.00  0.00           N  
ATOM    662  H   LYS A  47       2.180  19.576  -6.276  1.00  0.00           H  
ATOM    663  HA  LYS A  47       1.979  21.740  -4.250  1.00  0.00           H  
ATOM    664  HB2 LYS A  47       0.454  22.998  -5.606  1.00  0.00           H  
ATOM    665  HB3 LYS A  47       1.996  22.821  -6.436  1.00  0.00           H  
ATOM    666  HG2 LYS A  47       0.999  21.095  -7.922  1.00  0.00           H  
ATOM    667  HG3 LYS A  47      -0.513  21.209  -7.019  1.00  0.00           H  
ATOM    668  HD2 LYS A  47      -0.994  22.348  -8.909  1.00  0.00           H  
ATOM    669  HD3 LYS A  47      -0.730  23.609  -7.726  1.00  0.00           H  
ATOM    670  HE2 LYS A  47       1.224  22.680  -9.887  1.00  0.00           H  
ATOM    671  HE3 LYS A  47       0.210  24.122  -9.960  1.00  0.00           H  
ATOM    672  HZ1 LYS A  47       2.298  24.838  -9.315  1.00  0.00           H  
ATOM    673  HZ2 LYS A  47       2.530  23.621  -8.261  1.00  0.00           H  
ATOM    674  HZ3 LYS A  47       1.453  24.840  -7.895  1.00  0.00           H  
ATOM    675  N   ALA A  48      -0.178  20.734  -3.393  1.00  0.00           N  
ATOM    676  CA  ALA A  48      -1.339  20.015  -2.879  1.00  0.00           C  
ATOM    677  C   ALA A  48      -2.598  20.406  -3.662  1.00  0.00           C  
ATOM    678  O   ALA A  48      -2.619  21.396  -4.397  1.00  0.00           O  
ATOM    679  CB  ALA A  48      -1.534  20.323  -1.394  1.00  0.00           C  
ATOM    680  H   ALA A  48       0.207  21.483  -2.835  1.00  0.00           H  
ATOM    681  HA  ALA A  48      -1.168  18.944  -2.989  1.00  0.00           H  
ATOM    682  HB1 ALA A  48      -2.376  19.747  -1.005  1.00  0.00           H  
ATOM    683  HB2 ALA A  48      -0.632  20.063  -0.842  1.00  0.00           H  
ATOM    684  HB3 ALA A  48      -1.752  21.383  -1.269  1.00  0.00           H  
ATOM    685  N   VAL A  49      -3.665  19.639  -3.470  1.00  0.00           N  
ATOM    686  CA  VAL A  49      -4.976  19.822  -4.077  1.00  0.00           C  
ATOM    687  C   VAL A  49      -5.944  19.643  -2.917  1.00  0.00           C  
ATOM    688  O   VAL A  49      -5.786  18.705  -2.144  1.00  0.00           O  
ATOM    689  CB  VAL A  49      -5.210  18.793  -5.201  1.00  0.00           C  
ATOM    690  CG1 VAL A  49      -6.601  18.946  -5.845  1.00  0.00           C  
ATOM    691  CG2 VAL A  49      -4.143  18.930  -6.295  1.00  0.00           C  
ATOM    692  H   VAL A  49      -3.589  18.833  -2.857  1.00  0.00           H  
ATOM    693  HA  VAL A  49      -5.066  20.832  -4.476  1.00  0.00           H  
ATOM    694  HB  VAL A  49      -5.134  17.787  -4.786  1.00  0.00           H  
ATOM    695 HG11 VAL A  49      -7.384  18.778  -5.105  1.00  0.00           H  
ATOM    696 HG12 VAL A  49      -6.731  19.943  -6.260  1.00  0.00           H  
ATOM    697 HG13 VAL A  49      -6.737  18.209  -6.637  1.00  0.00           H  
ATOM    698 HG21 VAL A  49      -4.132  19.945  -6.692  1.00  0.00           H  
ATOM    699 HG22 VAL A  49      -3.160  18.684  -5.892  1.00  0.00           H  
ATOM    700 HG23 VAL A  49      -4.356  18.225  -7.091  1.00  0.00           H  
ATOM    701  N   SER A  50      -6.935  20.513  -2.784  1.00  0.00           N  
ATOM    702  CA  SER A  50      -7.931  20.474  -1.725  1.00  0.00           C  
ATOM    703  C   SER A  50      -9.300  20.208  -2.331  1.00  0.00           C  
ATOM    704  O   SER A  50      -9.750  21.004  -3.155  1.00  0.00           O  
ATOM    705  CB  SER A  50      -7.864  21.794  -0.950  1.00  0.00           C  
ATOM    706  OG  SER A  50      -7.601  22.916  -1.785  1.00  0.00           O  
ATOM    707  H   SER A  50      -7.036  21.280  -3.429  1.00  0.00           H  
ATOM    708  HA  SER A  50      -7.716  19.666  -1.029  1.00  0.00           H  
ATOM    709  HB2 SER A  50      -8.784  21.949  -0.384  1.00  0.00           H  
ATOM    710  HB3 SER A  50      -7.033  21.711  -0.255  1.00  0.00           H  
ATOM    711  HG  SER A  50      -6.887  23.424  -1.346  1.00  0.00           H  
ATOM    712  N   THR A  51      -9.915  19.071  -2.001  1.00  0.00           N  
ATOM    713  CA  THR A  51     -11.237  18.706  -2.501  1.00  0.00           C  
ATOM    714  C   THR A  51     -11.950  17.940  -1.381  1.00  0.00           C  
ATOM    715  O   THR A  51     -11.552  16.818  -1.089  1.00  0.00           O  
ATOM    716  CB  THR A  51     -11.123  17.881  -3.804  1.00  0.00           C  
ATOM    717  OG1 THR A  51     -10.002  18.250  -4.592  1.00  0.00           O  
ATOM    718  CG2 THR A  51     -12.364  18.063  -4.676  1.00  0.00           C  
ATOM    719  H   THR A  51      -9.496  18.446  -1.315  1.00  0.00           H  
ATOM    720  HA  THR A  51     -11.792  19.621  -2.707  1.00  0.00           H  
ATOM    721  HB  THR A  51     -11.010  16.827  -3.558  1.00  0.00           H  
ATOM    722  HG1 THR A  51      -9.226  17.995  -4.082  1.00  0.00           H  
ATOM    723 HG21 THR A  51     -13.262  17.854  -4.094  1.00  0.00           H  
ATOM    724 HG22 THR A  51     -12.318  17.374  -5.522  1.00  0.00           H  
ATOM    725 HG23 THR A  51     -12.405  19.090  -5.040  1.00  0.00           H  
ATOM    726  N   VAL A  52     -12.952  18.518  -0.716  1.00  0.00           N  
ATOM    727  CA  VAL A  52     -13.664  17.848   0.372  1.00  0.00           C  
ATOM    728  C   VAL A  52     -14.434  16.638  -0.167  1.00  0.00           C  
ATOM    729  O   VAL A  52     -15.392  16.791  -0.934  1.00  0.00           O  
ATOM    730  CB  VAL A  52     -14.612  18.817   1.117  1.00  0.00           C  
ATOM    731  CG1 VAL A  52     -15.178  18.147   2.374  1.00  0.00           C  
ATOM    732  CG2 VAL A  52     -13.965  20.150   1.512  1.00  0.00           C  
ATOM    733  H   VAL A  52     -13.258  19.448  -0.982  1.00  0.00           H  
ATOM    734  HA  VAL A  52     -12.915  17.487   1.081  1.00  0.00           H  
ATOM    735  HB  VAL A  52     -15.451  19.057   0.474  1.00  0.00           H  
ATOM    736 HG11 VAL A  52     -14.369  17.805   3.016  1.00  0.00           H  
ATOM    737 HG12 VAL A  52     -15.811  18.848   2.918  1.00  0.00           H  
ATOM    738 HG13 VAL A  52     -15.795  17.293   2.089  1.00  0.00           H  
ATOM    739 HG21 VAL A  52     -13.096  19.982   2.140  1.00  0.00           H  
ATOM    740 HG22 VAL A  52     -13.670  20.702   0.621  1.00  0.00           H  
ATOM    741 HG23 VAL A  52     -14.691  20.757   2.055  1.00  0.00           H  
ATOM    742  N   TYR A  53     -14.003  15.430   0.201  1.00  0.00           N  
ATOM    743  CA  TYR A  53     -14.677  14.210  -0.219  1.00  0.00           C  
ATOM    744  C   TYR A  53     -15.987  14.054   0.572  1.00  0.00           C  
ATOM    745  O   TYR A  53     -16.140  14.577   1.682  1.00  0.00           O  
ATOM    746  CB  TYR A  53     -13.765  12.997   0.033  1.00  0.00           C  
ATOM    747  CG  TYR A  53     -14.447  11.677  -0.267  1.00  0.00           C  
ATOM    748  CD1 TYR A  53     -14.671  11.303  -1.603  1.00  0.00           C  
ATOM    749  CD2 TYR A  53     -14.966  10.891   0.780  1.00  0.00           C  
ATOM    750  CE1 TYR A  53     -15.422  10.152  -1.898  1.00  0.00           C  
ATOM    751  CE2 TYR A  53     -15.717   9.738   0.491  1.00  0.00           C  
ATOM    752  CZ  TYR A  53     -15.950   9.363  -0.852  1.00  0.00           C  
ATOM    753  OH  TYR A  53     -16.695   8.264  -1.146  1.00  0.00           O  
ATOM    754  H   TYR A  53     -13.209  15.352   0.825  1.00  0.00           H  
ATOM    755  HA  TYR A  53     -14.901  14.267  -1.285  1.00  0.00           H  
ATOM    756  HB2 TYR A  53     -12.877  13.080  -0.593  1.00  0.00           H  
ATOM    757  HB3 TYR A  53     -13.452  13.000   1.080  1.00  0.00           H  
ATOM    758  HD1 TYR A  53     -14.275  11.902  -2.409  1.00  0.00           H  
ATOM    759  HD2 TYR A  53     -14.817  11.183   1.811  1.00  0.00           H  
ATOM    760  HE1 TYR A  53     -15.586   9.871  -2.924  1.00  0.00           H  
ATOM    761  HE2 TYR A  53     -16.127   9.147   1.295  1.00  0.00           H  
ATOM    762  HH  TYR A  53     -16.931   7.739  -0.373  1.00  0.00           H  
ATOM    763  N   ASN A  54     -16.953  13.336   0.005  1.00  0.00           N  
ATOM    764  CA  ASN A  54     -18.256  13.016   0.577  1.00  0.00           C  
ATOM    765  C   ASN A  54     -18.804  11.894  -0.295  1.00  0.00           C  
ATOM    766  O   ASN A  54     -18.691  11.989  -1.518  1.00  0.00           O  
ATOM    767  CB  ASN A  54     -19.228  14.214   0.553  1.00  0.00           C  
ATOM    768  CG  ASN A  54     -20.571  13.896   1.217  1.00  0.00           C  
ATOM    769  OD1 ASN A  54     -20.850  12.772   1.614  1.00  0.00           O  
ATOM    770  ND2 ASN A  54     -21.448  14.870   1.341  1.00  0.00           N  
ATOM    771  H   ASN A  54     -16.788  12.920  -0.906  1.00  0.00           H  
ATOM    772  HA  ASN A  54     -18.132  12.669   1.604  1.00  0.00           H  
ATOM    773  HB2 ASN A  54     -18.774  15.053   1.076  1.00  0.00           H  
ATOM    774  HB3 ASN A  54     -19.410  14.511  -0.479  1.00  0.00           H  
ATOM    775 HD21 ASN A  54     -21.310  15.789   0.945  1.00  0.00           H  
ATOM    776 HD22 ASN A  54     -22.323  14.664   1.809  1.00  0.00           H  
ATOM    777  N   GLY A  55     -19.361  10.837   0.297  1.00  0.00           N  
ATOM    778  CA  GLY A  55     -19.931   9.734  -0.455  1.00  0.00           C  
ATOM    779  C   GLY A  55     -21.046  10.244  -1.371  1.00  0.00           C  
ATOM    780  O   GLY A  55     -21.202   9.751  -2.488  1.00  0.00           O  
ATOM    781  H   GLY A  55     -19.433  10.821   1.308  1.00  0.00           H  
ATOM    782  HA2 GLY A  55     -19.154   9.266  -1.058  1.00  0.00           H  
ATOM    783  HA3 GLY A  55     -20.327   8.997   0.239  1.00  0.00           H  
ATOM    784  N   GLU A  56     -21.812  11.254  -0.940  1.00  0.00           N  
ATOM    785  CA  GLU A  56     -22.890  11.818  -1.752  1.00  0.00           C  
ATOM    786  C   GLU A  56     -22.334  12.532  -2.990  1.00  0.00           C  
ATOM    787  O   GLU A  56     -23.011  12.608  -4.016  1.00  0.00           O  
ATOM    788  CB  GLU A  56     -23.710  12.846  -0.948  1.00  0.00           C  
ATOM    789  CG  GLU A  56     -24.480  12.263   0.242  1.00  0.00           C  
ATOM    790  CD  GLU A  56     -25.356  11.096  -0.192  1.00  0.00           C  
ATOM    791  OE1 GLU A  56     -26.444  11.343  -0.759  1.00  0.00           O  
ATOM    792  OE2 GLU A  56     -24.892   9.943  -0.044  1.00  0.00           O  
ATOM    793  H   GLU A  56     -21.656  11.641  -0.013  1.00  0.00           H  
ATOM    794  HA  GLU A  56     -23.547  11.013  -2.088  1.00  0.00           H  
ATOM    795  HB2 GLU A  56     -23.048  13.633  -0.587  1.00  0.00           H  
ATOM    796  HB3 GLU A  56     -24.435  13.306  -1.620  1.00  0.00           H  
ATOM    797  HG2 GLU A  56     -23.774  11.932   1.005  1.00  0.00           H  
ATOM    798  HG3 GLU A  56     -25.115  13.039   0.669  1.00  0.00           H  
ATOM    799  N   ASP A  57     -21.086  12.995  -2.932  1.00  0.00           N  
ATOM    800  CA  ASP A  57     -20.406  13.734  -3.989  1.00  0.00           C  
ATOM    801  C   ASP A  57     -19.359  12.918  -4.750  1.00  0.00           C  
ATOM    802  O   ASP A  57     -18.559  13.526  -5.444  1.00  0.00           O  
ATOM    803  CB  ASP A  57     -19.776  14.991  -3.353  1.00  0.00           C  
ATOM    804  CG  ASP A  57     -19.329  16.059  -4.360  1.00  0.00           C  
ATOM    805  OD1 ASP A  57     -20.053  16.334  -5.342  1.00  0.00           O  
ATOM    806  OD2 ASP A  57     -18.310  16.741  -4.104  1.00  0.00           O  
ATOM    807  H   ASP A  57     -20.576  12.893  -2.065  1.00  0.00           H  
ATOM    808  HA  ASP A  57     -21.146  14.071  -4.715  1.00  0.00           H  
ATOM    809  HB2 ASP A  57     -20.505  15.450  -2.682  1.00  0.00           H  
ATOM    810  HB3 ASP A  57     -18.916  14.686  -2.754  1.00  0.00           H  
ATOM    811  N   LYS A  58     -19.317  11.577  -4.665  1.00  0.00           N  
ATOM    812  CA  LYS A  58     -18.316  10.742  -5.371  1.00  0.00           C  
ATOM    813  C   LYS A  58     -18.024  11.256  -6.793  1.00  0.00           C  
ATOM    814  O   LYS A  58     -16.890  11.658  -7.062  1.00  0.00           O  
ATOM    815  CB  LYS A  58     -18.687   9.237  -5.369  1.00  0.00           C  
ATOM    816  CG  LYS A  58     -18.292   8.521  -4.073  1.00  0.00           C  
ATOM    817  CD  LYS A  58     -18.378   6.985  -4.120  1.00  0.00           C  
ATOM    818  CE  LYS A  58     -19.783   6.364  -4.138  1.00  0.00           C  
ATOM    819  NZ  LYS A  58     -20.365   6.235  -5.493  1.00  0.00           N  
ATOM    820  H   LYS A  58     -20.008  11.124  -4.088  1.00  0.00           H  
ATOM    821  HA  LYS A  58     -17.379  10.851  -4.824  1.00  0.00           H  
ATOM    822  HB2 LYS A  58     -19.755   9.113  -5.529  1.00  0.00           H  
ATOM    823  HB3 LYS A  58     -18.157   8.751  -6.190  1.00  0.00           H  
ATOM    824  HG2 LYS A  58     -17.252   8.768  -3.867  1.00  0.00           H  
ATOM    825  HG3 LYS A  58     -18.897   8.894  -3.251  1.00  0.00           H  
ATOM    826  HD2 LYS A  58     -17.804   6.607  -4.964  1.00  0.00           H  
ATOM    827  HD3 LYS A  58     -17.890   6.615  -3.216  1.00  0.00           H  
ATOM    828  HE2 LYS A  58     -19.685   5.357  -3.731  1.00  0.00           H  
ATOM    829  HE3 LYS A  58     -20.453   6.924  -3.483  1.00  0.00           H  
ATOM    830  HZ1 LYS A  58     -21.182   5.635  -5.482  1.00  0.00           H  
ATOM    831  HZ2 LYS A  58     -19.696   5.823  -6.137  1.00  0.00           H  
ATOM    832  HZ3 LYS A  58     -20.689   7.120  -5.867  1.00  0.00           H  
ATOM    833  N   PRO A  59     -19.021  11.330  -7.690  1.00  0.00           N  
ATOM    834  CA  PRO A  59     -18.841  11.808  -9.057  1.00  0.00           C  
ATOM    835  C   PRO A  59     -18.416  13.282  -9.117  1.00  0.00           C  
ATOM    836  O   PRO A  59     -17.488  13.633  -9.853  1.00  0.00           O  
ATOM    837  CB  PRO A  59     -20.206  11.591  -9.730  1.00  0.00           C  
ATOM    838  CG  PRO A  59     -21.192  11.601  -8.562  1.00  0.00           C  
ATOM    839  CD  PRO A  59     -20.391  10.890  -7.499  1.00  0.00           C  
ATOM    840  HA  PRO A  59     -18.088  11.203  -9.564  1.00  0.00           H  
ATOM    841  HB2 PRO A  59     -20.441  12.380 -10.439  1.00  0.00           H  
ATOM    842  HB3 PRO A  59     -20.223  10.615 -10.220  1.00  0.00           H  
ATOM    843  HG2 PRO A  59     -21.410  12.625  -8.252  1.00  0.00           H  
ATOM    844  HG3 PRO A  59     -22.105  11.048  -8.742  1.00  0.00           H  
ATOM    845  HD2 PRO A  59     -20.805  11.130  -6.524  1.00  0.00           H  
ATOM    846  HD3 PRO A  59     -20.434   9.817  -7.679  1.00  0.00           H  
ATOM    847  N   GLY A  60     -19.097  14.158  -8.371  1.00  0.00           N  
ATOM    848  CA  GLY A  60     -18.820  15.589  -8.344  1.00  0.00           C  
ATOM    849  C   GLY A  60     -17.447  15.927  -7.775  1.00  0.00           C  
ATOM    850  O   GLY A  60     -16.891  16.979  -8.085  1.00  0.00           O  
ATOM    851  H   GLY A  60     -19.843  13.824  -7.779  1.00  0.00           H  
ATOM    852  HA2 GLY A  60     -18.857  15.957  -9.368  1.00  0.00           H  
ATOM    853  HA3 GLY A  60     -19.591  16.086  -7.760  1.00  0.00           H  
ATOM    854  N   PHE A  61     -16.872  15.042  -6.975  1.00  0.00           N  
ATOM    855  CA  PHE A  61     -15.567  15.166  -6.366  1.00  0.00           C  
ATOM    856  C   PHE A  61     -14.533  14.717  -7.400  1.00  0.00           C  
ATOM    857  O   PHE A  61     -13.591  15.454  -7.688  1.00  0.00           O  
ATOM    858  CB  PHE A  61     -15.546  14.287  -5.107  1.00  0.00           C  
ATOM    859  CG  PHE A  61     -14.180  13.889  -4.608  1.00  0.00           C  
ATOM    860  CD1 PHE A  61     -13.463  14.743  -3.754  1.00  0.00           C  
ATOM    861  CD2 PHE A  61     -13.646  12.639  -4.971  1.00  0.00           C  
ATOM    862  CE1 PHE A  61     -12.227  14.319  -3.235  1.00  0.00           C  
ATOM    863  CE2 PHE A  61     -12.402  12.231  -4.468  1.00  0.00           C  
ATOM    864  CZ  PHE A  61     -11.699  13.068  -3.586  1.00  0.00           C  
ATOM    865  H   PHE A  61     -17.394  14.201  -6.752  1.00  0.00           H  
ATOM    866  HA  PHE A  61     -15.372  16.199  -6.084  1.00  0.00           H  
ATOM    867  HB2 PHE A  61     -16.087  14.802  -4.311  1.00  0.00           H  
ATOM    868  HB3 PHE A  61     -16.081  13.362  -5.306  1.00  0.00           H  
ATOM    869  HD1 PHE A  61     -13.878  15.708  -3.496  1.00  0.00           H  
ATOM    870  HD2 PHE A  61     -14.198  11.984  -5.628  1.00  0.00           H  
ATOM    871  HE1 PHE A  61     -11.677  14.944  -2.554  1.00  0.00           H  
ATOM    872  HE2 PHE A  61     -11.985  11.273  -4.745  1.00  0.00           H  
ATOM    873  HZ  PHE A  61     -10.752  12.743  -3.181  1.00  0.00           H  
ATOM    874  N   LEU A  62     -14.748  13.539  -7.999  1.00  0.00           N  
ATOM    875  CA  LEU A  62     -13.873  12.921  -8.992  1.00  0.00           C  
ATOM    876  C   LEU A  62     -13.544  13.850 -10.153  1.00  0.00           C  
ATOM    877  O   LEU A  62     -12.369  14.012 -10.496  1.00  0.00           O  
ATOM    878  CB  LEU A  62     -14.497  11.614  -9.509  1.00  0.00           C  
ATOM    879  CG  LEU A  62     -14.249  10.413  -8.577  1.00  0.00           C  
ATOM    880  CD1 LEU A  62     -15.274   9.318  -8.865  1.00  0.00           C  
ATOM    881  CD2 LEU A  62     -12.830   9.857  -8.759  1.00  0.00           C  
ATOM    882  H   LEU A  62     -15.559  13.005  -7.701  1.00  0.00           H  
ATOM    883  HA  LEU A  62     -12.936  12.687  -8.494  1.00  0.00           H  
ATOM    884  HB2 LEU A  62     -15.567  11.766  -9.647  1.00  0.00           H  
ATOM    885  HB3 LEU A  62     -14.079  11.381 -10.490  1.00  0.00           H  
ATOM    886  HG  LEU A  62     -14.370  10.721  -7.540  1.00  0.00           H  
ATOM    887 HD11 LEU A  62     -15.230   9.046  -9.916  1.00  0.00           H  
ATOM    888 HD12 LEU A  62     -16.279   9.675  -8.650  1.00  0.00           H  
ATOM    889 HD13 LEU A  62     -15.076   8.445  -8.247  1.00  0.00           H  
ATOM    890 HD21 LEU A  62     -12.664   9.583  -9.801  1.00  0.00           H  
ATOM    891 HD22 LEU A  62     -12.694   8.974  -8.137  1.00  0.00           H  
ATOM    892 HD23 LEU A  62     -12.094  10.598  -8.459  1.00  0.00           H  
ATOM    893  N   LYS A  63     -14.559  14.507 -10.726  1.00  0.00           N  
ATOM    894  CA  LYS A  63     -14.359  15.416 -11.855  1.00  0.00           C  
ATOM    895  C   LYS A  63     -13.284  16.461 -11.568  1.00  0.00           C  
ATOM    896  O   LYS A  63     -12.424  16.687 -12.416  1.00  0.00           O  
ATOM    897  CB  LYS A  63     -15.695  16.042 -12.296  1.00  0.00           C  
ATOM    898  CG  LYS A  63     -16.213  17.158 -11.373  1.00  0.00           C  
ATOM    899  CD  LYS A  63     -17.695  17.451 -11.620  1.00  0.00           C  
ATOM    900  CE  LYS A  63     -18.237  18.519 -10.663  1.00  0.00           C  
ATOM    901  NZ  LYS A  63     -19.689  18.735 -10.846  1.00  0.00           N  
ATOM    902  H   LYS A  63     -15.499  14.317 -10.395  1.00  0.00           H  
ATOM    903  HA  LYS A  63     -14.006  14.803 -12.686  1.00  0.00           H  
ATOM    904  HB2 LYS A  63     -15.572  16.449 -13.300  1.00  0.00           H  
ATOM    905  HB3 LYS A  63     -16.443  15.249 -12.344  1.00  0.00           H  
ATOM    906  HG2 LYS A  63     -16.088  16.833 -10.347  1.00  0.00           H  
ATOM    907  HG3 LYS A  63     -15.631  18.067 -11.530  1.00  0.00           H  
ATOM    908  HD2 LYS A  63     -17.830  17.778 -12.650  1.00  0.00           H  
ATOM    909  HD3 LYS A  63     -18.245  16.528 -11.457  1.00  0.00           H  
ATOM    910  HE2 LYS A  63     -18.057  18.198  -9.637  1.00  0.00           H  
ATOM    911  HE3 LYS A  63     -17.707  19.459 -10.830  1.00  0.00           H  
ATOM    912  HZ1 LYS A  63     -20.194  17.854 -10.834  1.00  0.00           H  
ATOM    913  HZ2 LYS A  63     -19.875  19.215 -11.721  1.00  0.00           H  
ATOM    914  HZ3 LYS A  63     -20.054  19.296 -10.080  1.00  0.00           H  
ATOM    915  N   LYS A  64     -13.287  17.054 -10.367  1.00  0.00           N  
ATOM    916  CA  LYS A  64     -12.340  18.090  -9.944  1.00  0.00           C  
ATOM    917  C   LYS A  64     -10.883  17.652 -10.007  1.00  0.00           C  
ATOM    918  O   LYS A  64      -9.984  18.483 -10.117  1.00  0.00           O  
ATOM    919  CB  LYS A  64     -12.736  18.672  -8.583  1.00  0.00           C  
ATOM    920  CG  LYS A  64     -14.138  19.293  -8.698  1.00  0.00           C  
ATOM    921  CD  LYS A  64     -14.440  20.341  -7.627  1.00  0.00           C  
ATOM    922  CE  LYS A  64     -14.952  19.684  -6.351  1.00  0.00           C  
ATOM    923  NZ  LYS A  64     -16.339  19.182  -6.501  1.00  0.00           N  
ATOM    924  H   LYS A  64     -14.027  16.800  -9.728  1.00  0.00           H  
ATOM    925  HA  LYS A  64     -12.422  18.909 -10.643  1.00  0.00           H  
ATOM    926  HB2 LYS A  64     -12.717  17.902  -7.813  1.00  0.00           H  
ATOM    927  HB3 LYS A  64     -12.015  19.444  -8.320  1.00  0.00           H  
ATOM    928  HG2 LYS A  64     -14.232  19.788  -9.664  1.00  0.00           H  
ATOM    929  HG3 LYS A  64     -14.874  18.489  -8.648  1.00  0.00           H  
ATOM    930  HD2 LYS A  64     -13.539  20.915  -7.406  1.00  0.00           H  
ATOM    931  HD3 LYS A  64     -15.194  21.035  -8.004  1.00  0.00           H  
ATOM    932  HE2 LYS A  64     -14.280  18.866  -6.084  1.00  0.00           H  
ATOM    933  HE3 LYS A  64     -14.925  20.425  -5.553  1.00  0.00           H  
ATOM    934  HZ1 LYS A  64     -16.399  18.387  -7.127  1.00  0.00           H  
ATOM    935  HZ2 LYS A  64     -16.956  19.897  -6.883  1.00  0.00           H  
ATOM    936  HZ3 LYS A  64     -16.734  18.911  -5.608  1.00  0.00           H  
ATOM    937  N   LEU A  65     -10.630  16.352  -9.978  1.00  0.00           N  
ATOM    938  CA  LEU A  65      -9.294  15.796 -10.047  1.00  0.00           C  
ATOM    939  C   LEU A  65      -8.927  15.650 -11.515  1.00  0.00           C  
ATOM    940  O   LEU A  65      -7.877  16.129 -11.937  1.00  0.00           O  
ATOM    941  CB  LEU A  65      -9.265  14.420  -9.393  1.00  0.00           C  
ATOM    942  CG  LEU A  65     -10.020  14.301  -8.065  1.00  0.00           C  
ATOM    943  CD1 LEU A  65     -10.239  12.812  -7.892  1.00  0.00           C  
ATOM    944  CD2 LEU A  65      -9.252  14.971  -6.927  1.00  0.00           C  
ATOM    945  H   LEU A  65     -11.408  15.708  -9.891  1.00  0.00           H  
ATOM    946  HA  LEU A  65      -8.586  16.458  -9.544  1.00  0.00           H  
ATOM    947  HB2 LEU A  65      -9.709  13.719 -10.098  1.00  0.00           H  
ATOM    948  HB3 LEU A  65      -8.229  14.119  -9.243  1.00  0.00           H  
ATOM    949  HG  LEU A  65     -11.008  14.753  -8.126  1.00  0.00           H  
ATOM    950 HD11 LEU A  65      -9.281  12.297  -7.852  1.00  0.00           H  
ATOM    951 HD12 LEU A  65     -10.789  12.481  -8.778  1.00  0.00           H  
ATOM    952 HD13 LEU A  65     -10.825  12.627  -6.995  1.00  0.00           H  
ATOM    953 HD21 LEU A  65      -9.807  14.844  -5.998  1.00  0.00           H  
ATOM    954 HD22 LEU A  65      -9.160  16.037  -7.141  1.00  0.00           H  
ATOM    955 HD23 LEU A  65      -8.263  14.527  -6.833  1.00  0.00           H  
ATOM    956  N   SER A  66      -9.787  14.983 -12.294  1.00  0.00           N  
ATOM    957  CA  SER A  66      -9.587  14.758 -13.721  1.00  0.00           C  
ATOM    958  C   SER A  66      -9.382  16.093 -14.440  1.00  0.00           C  
ATOM    959  O   SER A  66      -8.677  16.158 -15.445  1.00  0.00           O  
ATOM    960  CB  SER A  66     -10.824  14.024 -14.262  1.00  0.00           C  
ATOM    961  OG  SER A  66     -10.762  13.815 -15.658  1.00  0.00           O  
ATOM    962  H   SER A  66     -10.639  14.617 -11.884  1.00  0.00           H  
ATOM    963  HA  SER A  66      -8.703  14.136 -13.873  1.00  0.00           H  
ATOM    964  HB2 SER A  66     -10.904  13.057 -13.767  1.00  0.00           H  
ATOM    965  HB3 SER A  66     -11.721  14.605 -14.038  1.00  0.00           H  
ATOM    966  HG  SER A  66     -10.926  14.676 -16.104  1.00  0.00           H  
ATOM    967  N   LEU A  67      -9.989  17.157 -13.913  1.00  0.00           N  
ATOM    968  CA  LEU A  67      -9.861  18.475 -14.553  1.00  0.00           C  
ATOM    969  C   LEU A  67      -8.606  19.236 -14.143  1.00  0.00           C  
ATOM    970  O   LEU A  67      -8.347  20.312 -14.692  1.00  0.00           O  
ATOM    971  CB  LEU A  67     -11.137  19.318 -14.440  1.00  0.00           C  
ATOM    972  CG  LEU A  67     -11.550  19.716 -13.021  1.00  0.00           C  
ATOM    973  CD1 LEU A  67     -10.937  21.018 -12.499  1.00  0.00           C  
ATOM    974  CD2 LEU A  67     -13.075  19.865 -12.993  1.00  0.00           C  
ATOM    975  H   LEU A  67     -10.535  16.946 -13.063  1.00  0.00           H  
ATOM    976  HA  LEU A  67      -9.750  18.296 -15.624  1.00  0.00           H  
ATOM    977  HB2 LEU A  67     -11.007  20.226 -15.025  1.00  0.00           H  
ATOM    978  HB3 LEU A  67     -11.935  18.736 -14.905  1.00  0.00           H  
ATOM    979  HG  LEU A  67     -11.242  18.921 -12.358  1.00  0.00           H  
ATOM    980 HD11 LEU A  67     -11.288  21.198 -11.482  1.00  0.00           H  
ATOM    981 HD12 LEU A  67     -11.232  21.848 -13.137  1.00  0.00           H  
ATOM    982 HD13 LEU A  67      -9.852  20.942 -12.468  1.00  0.00           H  
ATOM    983 HD21 LEU A  67     -13.414  20.148 -12.002  1.00  0.00           H  
ATOM    984 HD22 LEU A  67     -13.549  18.923 -13.272  1.00  0.00           H  
ATOM    985 HD23 LEU A  67     -13.375  20.633 -13.698  1.00  0.00           H  
ATOM    986  N   LYS A  68      -7.802  18.724 -13.209  1.00  0.00           N  
ATOM    987  CA  LYS A  68      -6.580  19.386 -12.770  1.00  0.00           C  
ATOM    988  C   LYS A  68      -5.345  18.573 -13.143  1.00  0.00           C  
ATOM    989  O   LYS A  68      -4.302  19.156 -13.427  1.00  0.00           O  
ATOM    990  CB  LYS A  68      -6.734  19.771 -11.293  1.00  0.00           C  
ATOM    991  CG  LYS A  68      -6.168  18.795 -10.264  1.00  0.00           C  
ATOM    992  CD  LYS A  68      -4.636  18.827 -10.105  1.00  0.00           C  
ATOM    993  CE  LYS A  68      -3.982  20.190  -9.853  1.00  0.00           C  
ATOM    994  NZ  LYS A  68      -3.623  20.912 -11.096  1.00  0.00           N  
ATOM    995  H   LYS A  68      -8.029  17.842 -12.762  1.00  0.00           H  
ATOM    996  HA  LYS A  68      -6.467  20.320 -13.302  1.00  0.00           H  
ATOM    997  HB2 LYS A  68      -6.274  20.739 -11.150  1.00  0.00           H  
ATOM    998  HB3 LYS A  68      -7.793  19.907 -11.071  1.00  0.00           H  
ATOM    999  HG2 LYS A  68      -6.631  19.035  -9.312  1.00  0.00           H  
ATOM   1000  HG3 LYS A  68      -6.487  17.784 -10.511  1.00  0.00           H  
ATOM   1001  HD2 LYS A  68      -4.402  18.201  -9.254  1.00  0.00           H  
ATOM   1002  HD3 LYS A  68      -4.165  18.374 -10.968  1.00  0.00           H  
ATOM   1003  HE2 LYS A  68      -4.653  20.809  -9.257  1.00  0.00           H  
ATOM   1004  HE3 LYS A  68      -3.066  20.029  -9.279  1.00  0.00           H  
ATOM   1005  HZ1 LYS A  68      -4.405  21.035 -11.736  1.00  0.00           H  
ATOM   1006  HZ2 LYS A  68      -2.869  20.459 -11.605  1.00  0.00           H  
ATOM   1007  HZ3 LYS A  68      -3.322  21.854 -10.862  1.00  0.00           H  
ATOM   1008  N   PHE A  69      -5.438  17.249 -13.073  1.00  0.00           N  
ATOM   1009  CA  PHE A  69      -4.371  16.316 -13.397  1.00  0.00           C  
ATOM   1010  C   PHE A  69      -4.466  16.010 -14.887  1.00  0.00           C  
ATOM   1011  O   PHE A  69      -5.503  15.520 -15.328  1.00  0.00           O  
ATOM   1012  CB  PHE A  69      -4.526  15.041 -12.549  1.00  0.00           C  
ATOM   1013  CG  PHE A  69      -4.395  15.266 -11.048  1.00  0.00           C  
ATOM   1014  CD1 PHE A  69      -3.199  15.757 -10.491  1.00  0.00           C  
ATOM   1015  CD2 PHE A  69      -5.489  15.012 -10.200  1.00  0.00           C  
ATOM   1016  CE1 PHE A  69      -3.098  15.962  -9.101  1.00  0.00           C  
ATOM   1017  CE2 PHE A  69      -5.398  15.252  -8.818  1.00  0.00           C  
ATOM   1018  CZ  PHE A  69      -4.191  15.703  -8.259  1.00  0.00           C  
ATOM   1019  H   PHE A  69      -6.340  16.867 -12.827  1.00  0.00           H  
ATOM   1020  HA  PHE A  69      -3.403  16.769 -13.189  1.00  0.00           H  
ATOM   1021  HB2 PHE A  69      -5.500  14.596 -12.761  1.00  0.00           H  
ATOM   1022  HB3 PHE A  69      -3.778  14.312 -12.865  1.00  0.00           H  
ATOM   1023  HD1 PHE A  69      -2.352  15.980 -11.126  1.00  0.00           H  
ATOM   1024  HD2 PHE A  69      -6.404  14.629 -10.617  1.00  0.00           H  
ATOM   1025  HE1 PHE A  69      -2.193  16.366  -8.680  1.00  0.00           H  
ATOM   1026  HE2 PHE A  69      -6.250  15.076  -8.180  1.00  0.00           H  
ATOM   1027  HZ  PHE A  69      -4.108  15.866  -7.192  1.00  0.00           H  
ATOM   1028  N   LYS A  70      -3.416  16.302 -15.662  1.00  0.00           N  
ATOM   1029  CA  LYS A  70      -3.426  16.032 -17.105  1.00  0.00           C  
ATOM   1030  C   LYS A  70      -3.653  14.548 -17.386  1.00  0.00           C  
ATOM   1031  O   LYS A  70      -4.616  14.201 -18.069  1.00  0.00           O  
ATOM   1032  CB  LYS A  70      -2.159  16.545 -17.826  1.00  0.00           C  
ATOM   1033  CG  LYS A  70      -0.812  16.252 -17.138  1.00  0.00           C  
ATOM   1034  CD  LYS A  70       0.394  16.397 -18.071  1.00  0.00           C  
ATOM   1035  CE  LYS A  70       0.537  17.773 -18.732  1.00  0.00           C  
ATOM   1036  NZ  LYS A  70       0.830  18.872 -17.788  1.00  0.00           N  
ATOM   1037  H   LYS A  70      -2.593  16.709 -15.237  1.00  0.00           H  
ATOM   1038  HA  LYS A  70      -4.279  16.558 -17.539  1.00  0.00           H  
ATOM   1039  HB2 LYS A  70      -2.144  16.106 -18.827  1.00  0.00           H  
ATOM   1040  HB3 LYS A  70      -2.244  17.624 -17.947  1.00  0.00           H  
ATOM   1041  HG2 LYS A  70      -0.690  16.933 -16.304  1.00  0.00           H  
ATOM   1042  HG3 LYS A  70      -0.797  15.239 -16.746  1.00  0.00           H  
ATOM   1043  HD2 LYS A  70       1.301  16.160 -17.514  1.00  0.00           H  
ATOM   1044  HD3 LYS A  70       0.306  15.658 -18.867  1.00  0.00           H  
ATOM   1045  HE2 LYS A  70       1.353  17.708 -19.456  1.00  0.00           H  
ATOM   1046  HE3 LYS A  70      -0.375  17.995 -19.290  1.00  0.00           H  
ATOM   1047  HZ1 LYS A  70       1.674  18.656 -17.267  1.00  0.00           H  
ATOM   1048  HZ2 LYS A  70       0.072  19.022 -17.131  1.00  0.00           H  
ATOM   1049  HZ3 LYS A  70       0.998  19.728 -18.306  1.00  0.00           H  
ATOM   1050  N   ASP A  71      -2.828  13.685 -16.792  1.00  0.00           N  
ATOM   1051  CA  ASP A  71      -2.875  12.239 -16.971  1.00  0.00           C  
ATOM   1052  C   ASP A  71      -3.201  11.559 -15.645  1.00  0.00           C  
ATOM   1053  O   ASP A  71      -2.288  11.124 -14.932  1.00  0.00           O  
ATOM   1054  CB  ASP A  71      -1.546  11.719 -17.534  1.00  0.00           C  
ATOM   1055  CG  ASP A  71      -1.277  12.247 -18.932  1.00  0.00           C  
ATOM   1056  OD1 ASP A  71      -1.817  11.690 -19.910  1.00  0.00           O  
ATOM   1057  OD2 ASP A  71      -0.488  13.205 -19.052  1.00  0.00           O  
ATOM   1058  H   ASP A  71      -2.069  14.059 -16.247  1.00  0.00           H  
ATOM   1059  HA  ASP A  71      -3.634  11.982 -17.711  1.00  0.00           H  
ATOM   1060  HB2 ASP A  71      -0.725  12.010 -16.874  1.00  0.00           H  
ATOM   1061  HB3 ASP A  71      -1.585  10.629 -17.581  1.00  0.00           H  
ATOM   1062  N   PRO A  72      -4.484  11.450 -15.266  1.00  0.00           N  
ATOM   1063  CA  PRO A  72      -4.871  10.799 -14.023  1.00  0.00           C  
ATOM   1064  C   PRO A  72      -4.334   9.372 -13.983  1.00  0.00           C  
ATOM   1065  O   PRO A  72      -3.802   8.942 -12.959  1.00  0.00           O  
ATOM   1066  CB  PRO A  72      -6.400  10.830 -13.984  1.00  0.00           C  
ATOM   1067  CG  PRO A  72      -6.843  11.193 -15.398  1.00  0.00           C  
ATOM   1068  CD  PRO A  72      -5.647  11.921 -15.994  1.00  0.00           C  
ATOM   1069  HA  PRO A  72      -4.471  11.355 -13.174  1.00  0.00           H  
ATOM   1070  HB2 PRO A  72      -6.810   9.878 -13.646  1.00  0.00           H  
ATOM   1071  HB3 PRO A  72      -6.731  11.616 -13.320  1.00  0.00           H  
ATOM   1072  HG2 PRO A  72      -7.031  10.292 -15.977  1.00  0.00           H  
ATOM   1073  HG3 PRO A  72      -7.719  11.838 -15.374  1.00  0.00           H  
ATOM   1074  HD2 PRO A  72      -5.584  11.712 -17.061  1.00  0.00           H  
ATOM   1075  HD3 PRO A  72      -5.751  12.990 -15.823  1.00  0.00           H  
ATOM   1076  N   GLU A  73      -4.396   8.662 -15.112  1.00  0.00           N  
ATOM   1077  CA  GLU A  73      -3.935   7.288 -15.254  1.00  0.00           C  
ATOM   1078  C   GLU A  73      -2.428   7.095 -15.062  1.00  0.00           C  
ATOM   1079  O   GLU A  73      -1.933   5.975 -15.161  1.00  0.00           O  
ATOM   1080  CB  GLU A  73      -4.448   6.701 -16.569  1.00  0.00           C  
ATOM   1081  CG  GLU A  73      -3.762   7.228 -17.834  1.00  0.00           C  
ATOM   1082  CD  GLU A  73      -4.181   6.361 -19.020  1.00  0.00           C  
ATOM   1083  OE1 GLU A  73      -3.576   5.282 -19.209  1.00  0.00           O  
ATOM   1084  OE2 GLU A  73      -5.177   6.708 -19.695  1.00  0.00           O  
ATOM   1085  H   GLU A  73      -4.845   9.071 -15.920  1.00  0.00           H  
ATOM   1086  HA  GLU A  73      -4.399   6.718 -14.455  1.00  0.00           H  
ATOM   1087  HB2 GLU A  73      -4.305   5.626 -16.513  1.00  0.00           H  
ATOM   1088  HB3 GLU A  73      -5.521   6.889 -16.647  1.00  0.00           H  
ATOM   1089  HG2 GLU A  73      -4.047   8.268 -17.998  1.00  0.00           H  
ATOM   1090  HG3 GLU A  73      -2.679   7.175 -17.725  1.00  0.00           H  
ATOM   1091  N   ASN A  74      -1.672   8.160 -14.803  1.00  0.00           N  
ATOM   1092  CA  ASN A  74      -0.230   8.129 -14.560  1.00  0.00           C  
ATOM   1093  C   ASN A  74       0.102   8.877 -13.265  1.00  0.00           C  
ATOM   1094  O   ASN A  74       1.230   8.772 -12.792  1.00  0.00           O  
ATOM   1095  CB  ASN A  74       0.539   8.758 -15.735  1.00  0.00           C  
ATOM   1096  CG  ASN A  74       0.822   7.831 -16.913  1.00  0.00           C  
ATOM   1097  OD1 ASN A  74       1.723   8.125 -17.691  1.00  0.00           O  
ATOM   1098  ND2 ASN A  74       0.091   6.745 -17.097  1.00  0.00           N  
ATOM   1099  H   ASN A  74      -2.143   9.055 -14.740  1.00  0.00           H  
ATOM   1100  HA  ASN A  74       0.111   7.100 -14.433  1.00  0.00           H  
ATOM   1101  HB2 ASN A  74       0.013   9.644 -16.088  1.00  0.00           H  
ATOM   1102  HB3 ASN A  74       1.513   9.088 -15.366  1.00  0.00           H  
ATOM   1103 HD21 ASN A  74      -0.666   6.494 -16.467  1.00  0.00           H  
ATOM   1104 HD22 ASN A  74       0.231   6.166 -17.926  1.00  0.00           H  
ATOM   1105  N   THR A  75      -0.838   9.628 -12.690  1.00  0.00           N  
ATOM   1106  CA  THR A  75      -0.649  10.406 -11.476  1.00  0.00           C  
ATOM   1107  C   THR A  75      -1.001   9.580 -10.236  1.00  0.00           C  
ATOM   1108  O   THR A  75      -2.016   8.876 -10.218  1.00  0.00           O  
ATOM   1109  CB  THR A  75      -1.538  11.660 -11.567  1.00  0.00           C  
ATOM   1110  OG1 THR A  75      -1.333  12.356 -12.786  1.00  0.00           O  
ATOM   1111  CG2 THR A  75      -1.215  12.669 -10.463  1.00  0.00           C  
ATOM   1112  H   THR A  75      -1.755   9.673 -13.110  1.00  0.00           H  
ATOM   1113  HA  THR A  75       0.394  10.720 -11.417  1.00  0.00           H  
ATOM   1114  HB  THR A  75      -2.592  11.366 -11.504  1.00  0.00           H  
ATOM   1115  HG1 THR A  75      -1.610  11.778 -13.527  1.00  0.00           H  
ATOM   1116 HG21 THR A  75      -1.274  12.199  -9.484  1.00  0.00           H  
ATOM   1117 HG22 THR A  75      -1.936  13.479 -10.499  1.00  0.00           H  
ATOM   1118 HG23 THR A  75      -0.209  13.067 -10.595  1.00  0.00           H  
ATOM   1119  N   THR A  76      -0.189   9.693  -9.186  1.00  0.00           N  
ATOM   1120  CA  THR A  76      -0.395   9.000  -7.922  1.00  0.00           C  
ATOM   1121  C   THR A  76      -1.010  10.028  -6.957  1.00  0.00           C  
ATOM   1122  O   THR A  76      -0.402  11.078  -6.741  1.00  0.00           O  
ATOM   1123  CB  THR A  76       0.930   8.418  -7.406  1.00  0.00           C  
ATOM   1124  OG1 THR A  76       1.710   7.843  -8.451  1.00  0.00           O  
ATOM   1125  CG2 THR A  76       0.610   7.391  -6.316  1.00  0.00           C  
ATOM   1126  H   THR A  76       0.628  10.287  -9.259  1.00  0.00           H  
ATOM   1127  HA  THR A  76      -1.088   8.179  -8.086  1.00  0.00           H  
ATOM   1128  HB  THR A  76       1.511   9.215  -6.958  1.00  0.00           H  
ATOM   1129  HG1 THR A  76       2.662   7.991  -8.240  1.00  0.00           H  
ATOM   1130 HG21 THR A  76       1.531   7.018  -5.876  1.00  0.00           H  
ATOM   1131 HG22 THR A  76       0.056   6.556  -6.742  1.00  0.00           H  
ATOM   1132 HG23 THR A  76       0.014   7.858  -5.527  1.00  0.00           H  
ATOM   1133  N   LEU A  77      -2.183   9.756  -6.372  1.00  0.00           N  
ATOM   1134  CA  LEU A  77      -2.897  10.656  -5.464  1.00  0.00           C  
ATOM   1135  C   LEU A  77      -2.866  10.126  -4.034  1.00  0.00           C  
ATOM   1136  O   LEU A  77      -3.646   9.257  -3.647  1.00  0.00           O  
ATOM   1137  CB  LEU A  77      -4.359  10.857  -5.925  1.00  0.00           C  
ATOM   1138  CG  LEU A  77      -4.658  12.010  -6.898  1.00  0.00           C  
ATOM   1139  CD1 LEU A  77      -3.678  12.124  -8.065  1.00  0.00           C  
ATOM   1140  CD2 LEU A  77      -6.091  11.844  -7.422  1.00  0.00           C  
ATOM   1141  H   LEU A  77      -2.648   8.879  -6.572  1.00  0.00           H  
ATOM   1142  HA  LEU A  77      -2.418  11.635  -5.465  1.00  0.00           H  
ATOM   1143  HB2 LEU A  77      -4.752   9.919  -6.307  1.00  0.00           H  
ATOM   1144  HB3 LEU A  77      -4.959  11.086  -5.055  1.00  0.00           H  
ATOM   1145  HG  LEU A  77      -4.609  12.947  -6.342  1.00  0.00           H  
ATOM   1146 HD11 LEU A  77      -4.000  12.901  -8.752  1.00  0.00           H  
ATOM   1147 HD12 LEU A  77      -3.624  11.178  -8.600  1.00  0.00           H  
ATOM   1148 HD13 LEU A  77      -2.696  12.388  -7.678  1.00  0.00           H  
ATOM   1149 HD21 LEU A  77      -6.792  11.803  -6.590  1.00  0.00           H  
ATOM   1150 HD22 LEU A  77      -6.172  10.909  -7.978  1.00  0.00           H  
ATOM   1151 HD23 LEU A  77      -6.358  12.669  -8.077  1.00  0.00           H  
ATOM   1152  N   TYR A  78      -1.936  10.631  -3.244  1.00  0.00           N  
ATOM   1153  CA  TYR A  78      -1.763  10.291  -1.841  1.00  0.00           C  
ATOM   1154  C   TYR A  78      -2.922  10.979  -1.097  1.00  0.00           C  
ATOM   1155  O   TYR A  78      -3.088  12.190  -1.243  1.00  0.00           O  
ATOM   1156  CB  TYR A  78      -0.381  10.800  -1.424  1.00  0.00           C  
ATOM   1157  CG  TYR A  78       0.758   9.956  -1.999  1.00  0.00           C  
ATOM   1158  CD1 TYR A  78       1.131  10.025  -3.357  1.00  0.00           C  
ATOM   1159  CD2 TYR A  78       1.381   8.996  -1.184  1.00  0.00           C  
ATOM   1160  CE1 TYR A  78       2.071   9.121  -3.887  1.00  0.00           C  
ATOM   1161  CE2 TYR A  78       2.330   8.098  -1.699  1.00  0.00           C  
ATOM   1162  CZ  TYR A  78       2.666   8.143  -3.064  1.00  0.00           C  
ATOM   1163  OH  TYR A  78       3.516   7.208  -3.570  1.00  0.00           O  
ATOM   1164  H   TYR A  78      -1.327  11.344  -3.633  1.00  0.00           H  
ATOM   1165  HA  TYR A  78      -1.818   9.212  -1.699  1.00  0.00           H  
ATOM   1166  HB2 TYR A  78      -0.303  11.841  -1.749  1.00  0.00           H  
ATOM   1167  HB3 TYR A  78      -0.320  10.791  -0.336  1.00  0.00           H  
ATOM   1168  HD1 TYR A  78       0.669  10.739  -4.021  1.00  0.00           H  
ATOM   1169  HD2 TYR A  78       1.073   8.887  -0.165  1.00  0.00           H  
ATOM   1170  HE1 TYR A  78       2.319   9.154  -4.932  1.00  0.00           H  
ATOM   1171  HE2 TYR A  78       2.758   7.328  -1.074  1.00  0.00           H  
ATOM   1172  HH  TYR A  78       3.574   7.144  -4.541  1.00  0.00           H  
ATOM   1173  N   ILE A  79      -3.789  10.232  -0.404  1.00  0.00           N  
ATOM   1174  CA  ILE A  79      -4.941  10.742   0.327  1.00  0.00           C  
ATOM   1175  C   ILE A  79      -4.486  11.384   1.640  1.00  0.00           C  
ATOM   1176  O   ILE A  79      -3.421  11.053   2.172  1.00  0.00           O  
ATOM   1177  CB  ILE A  79      -5.933   9.588   0.630  1.00  0.00           C  
ATOM   1178  CG1 ILE A  79      -6.071   8.484  -0.454  1.00  0.00           C  
ATOM   1179  CG2 ILE A  79      -7.310  10.174   1.004  1.00  0.00           C  
ATOM   1180  CD1 ILE A  79      -7.164   8.646  -1.512  1.00  0.00           C  
ATOM   1181  H   ILE A  79      -3.677   9.234  -0.266  1.00  0.00           H  
ATOM   1182  HA  ILE A  79      -5.452  11.475  -0.288  1.00  0.00           H  
ATOM   1183  HB  ILE A  79      -5.551   9.074   1.515  1.00  0.00           H  
ATOM   1184 HG12 ILE A  79      -5.133   8.285  -0.965  1.00  0.00           H  
ATOM   1185 HG13 ILE A  79      -6.297   7.572   0.082  1.00  0.00           H  
ATOM   1186 HG21 ILE A  79      -7.318  10.459   2.058  1.00  0.00           H  
ATOM   1187 HG22 ILE A  79      -7.541  11.040   0.384  1.00  0.00           H  
ATOM   1188 HG23 ILE A  79      -8.099   9.449   0.841  1.00  0.00           H  
ATOM   1189 HD11 ILE A  79      -8.054   8.135  -1.160  1.00  0.00           H  
ATOM   1190 HD12 ILE A  79      -7.409   9.691  -1.676  1.00  0.00           H  
ATOM   1191 HD13 ILE A  79      -6.847   8.192  -2.450  1.00  0.00           H  
ATOM   1192  N   LEU A  80      -5.299  12.287   2.182  1.00  0.00           N  
ATOM   1193  CA  LEU A  80      -5.029  12.947   3.439  1.00  0.00           C  
ATOM   1194  C   LEU A  80      -6.348  13.424   4.031  1.00  0.00           C  
ATOM   1195  O   LEU A  80      -6.991  14.312   3.468  1.00  0.00           O  
ATOM   1196  CB  LEU A  80      -4.019  14.103   3.285  1.00  0.00           C  
ATOM   1197  CG  LEU A  80      -3.459  14.505   4.667  1.00  0.00           C  
ATOM   1198  CD1 LEU A  80      -2.164  15.316   4.570  1.00  0.00           C  
ATOM   1199  CD2 LEU A  80      -4.466  15.248   5.544  1.00  0.00           C  
ATOM   1200  H   LEU A  80      -6.157  12.537   1.714  1.00  0.00           H  
ATOM   1201  HA  LEU A  80      -4.592  12.203   4.111  1.00  0.00           H  
ATOM   1202  HB2 LEU A  80      -3.196  13.762   2.657  1.00  0.00           H  
ATOM   1203  HB3 LEU A  80      -4.479  14.960   2.794  1.00  0.00           H  
ATOM   1204  HG  LEU A  80      -3.210  13.593   5.199  1.00  0.00           H  
ATOM   1205 HD11 LEU A  80      -1.692  15.327   5.558  1.00  0.00           H  
ATOM   1206 HD12 LEU A  80      -2.384  16.328   4.228  1.00  0.00           H  
ATOM   1207 HD13 LEU A  80      -1.466  14.848   3.881  1.00  0.00           H  
ATOM   1208 HD21 LEU A  80      -4.908  14.526   6.238  1.00  0.00           H  
ATOM   1209 HD22 LEU A  80      -5.226  15.714   4.925  1.00  0.00           H  
ATOM   1210 HD23 LEU A  80      -3.981  16.034   6.116  1.00  0.00           H  
ATOM   1211  N   ASP A  81      -6.775  12.801   5.124  1.00  0.00           N  
ATOM   1212  CA  ASP A  81      -7.981  13.160   5.872  1.00  0.00           C  
ATOM   1213  C   ASP A  81      -7.533  13.424   7.316  1.00  0.00           C  
ATOM   1214  O   ASP A  81      -6.387  13.144   7.672  1.00  0.00           O  
ATOM   1215  CB  ASP A  81      -9.091  12.093   5.821  1.00  0.00           C  
ATOM   1216  CG  ASP A  81     -10.379  12.605   6.487  1.00  0.00           C  
ATOM   1217  OD1 ASP A  81     -10.634  13.832   6.461  1.00  0.00           O  
ATOM   1218  OD2 ASP A  81     -11.136  11.823   7.105  1.00  0.00           O  
ATOM   1219  H   ASP A  81      -6.188  12.077   5.531  1.00  0.00           H  
ATOM   1220  HA  ASP A  81      -8.388  14.081   5.458  1.00  0.00           H  
ATOM   1221  HB2 ASP A  81      -9.304  11.837   4.787  1.00  0.00           H  
ATOM   1222  HB3 ASP A  81      -8.753  11.189   6.326  1.00  0.00           H  
ATOM   1223  N   LYS A  82      -8.395  13.981   8.169  1.00  0.00           N  
ATOM   1224  CA  LYS A  82      -8.053  14.244   9.568  1.00  0.00           C  
ATOM   1225  C   LYS A  82      -7.572  12.951  10.234  1.00  0.00           C  
ATOM   1226  O   LYS A  82      -6.607  12.987  10.998  1.00  0.00           O  
ATOM   1227  CB  LYS A  82      -9.228  14.914  10.307  1.00  0.00           C  
ATOM   1228  CG  LYS A  82     -10.531  14.088  10.304  1.00  0.00           C  
ATOM   1229  CD  LYS A  82     -11.731  14.806  10.934  1.00  0.00           C  
ATOM   1230  CE  LYS A  82     -12.083  16.079  10.155  1.00  0.00           C  
ATOM   1231  NZ  LYS A  82     -13.415  16.617  10.488  1.00  0.00           N  
ATOM   1232  H   LYS A  82      -9.326  14.195   7.824  1.00  0.00           H  
ATOM   1233  HA  LYS A  82      -7.214  14.939   9.581  1.00  0.00           H  
ATOM   1234  HB2 LYS A  82      -8.929  15.101  11.340  1.00  0.00           H  
ATOM   1235  HB3 LYS A  82      -9.406  15.882   9.837  1.00  0.00           H  
ATOM   1236  HG2 LYS A  82     -10.798  13.827   9.280  1.00  0.00           H  
ATOM   1237  HG3 LYS A  82     -10.371  13.164  10.857  1.00  0.00           H  
ATOM   1238  HD2 LYS A  82     -12.579  14.122  10.912  1.00  0.00           H  
ATOM   1239  HD3 LYS A  82     -11.507  15.053  11.973  1.00  0.00           H  
ATOM   1240  HE2 LYS A  82     -11.326  16.838  10.357  1.00  0.00           H  
ATOM   1241  HE3 LYS A  82     -12.057  15.860   9.093  1.00  0.00           H  
ATOM   1242  HZ1 LYS A  82     -13.532  16.665  11.496  1.00  0.00           H  
ATOM   1243  HZ2 LYS A  82     -14.148  16.047  10.080  1.00  0.00           H  
ATOM   1244  HZ3 LYS A  82     -13.497  17.569  10.135  1.00  0.00           H  
ATOM   1245  N   PHE A  83      -8.216  11.826   9.903  1.00  0.00           N  
ATOM   1246  CA  PHE A  83      -7.939  10.491  10.399  1.00  0.00           C  
ATOM   1247  C   PHE A  83      -8.113   9.482   9.249  1.00  0.00           C  
ATOM   1248  O   PHE A  83      -7.667   9.726   8.130  1.00  0.00           O  
ATOM   1249  CB  PHE A  83      -8.859  10.203  11.583  1.00  0.00           C  
ATOM   1250  CG  PHE A  83      -8.756  11.128  12.774  1.00  0.00           C  
ATOM   1251  CD1 PHE A  83      -7.517  11.361  13.404  1.00  0.00           C  
ATOM   1252  CD2 PHE A  83      -9.930  11.684  13.315  1.00  0.00           C  
ATOM   1253  CE1 PHE A  83      -7.459  12.110  14.589  1.00  0.00           C  
ATOM   1254  CE2 PHE A  83      -9.870  12.438  14.494  1.00  0.00           C  
ATOM   1255  CZ  PHE A  83      -8.639  12.631  15.139  1.00  0.00           C  
ATOM   1256  H   PHE A  83      -8.989  11.903   9.261  1.00  0.00           H  
ATOM   1257  HA  PHE A  83      -6.914  10.440  10.754  1.00  0.00           H  
ATOM   1258  HB2 PHE A  83      -9.887  10.212  11.221  1.00  0.00           H  
ATOM   1259  HB3 PHE A  83      -8.617   9.206  11.938  1.00  0.00           H  
ATOM   1260  HD1 PHE A  83      -6.600  10.973  12.985  1.00  0.00           H  
ATOM   1261  HD2 PHE A  83     -10.888  11.517  12.844  1.00  0.00           H  
ATOM   1262  HE1 PHE A  83      -6.512  12.285  15.081  1.00  0.00           H  
ATOM   1263  HE2 PHE A  83     -10.781  12.853  14.907  1.00  0.00           H  
ATOM   1264  HZ  PHE A  83      -8.591  13.184  16.062  1.00  0.00           H  
ATOM   1265  N   ASP A  84      -8.680   8.304   9.520  1.00  0.00           N  
ATOM   1266  CA  ASP A  84      -8.948   7.244   8.551  1.00  0.00           C  
ATOM   1267  C   ASP A  84      -9.976   7.760   7.553  1.00  0.00           C  
ATOM   1268  O   ASP A  84      -9.682   7.921   6.367  1.00  0.00           O  
ATOM   1269  CB  ASP A  84      -9.450   5.968   9.240  1.00  0.00           C  
ATOM   1270  CG  ASP A  84      -9.530   4.818   8.240  1.00  0.00           C  
ATOM   1271  OD1 ASP A  84      -8.484   4.144   8.069  1.00  0.00           O  
ATOM   1272  OD2 ASP A  84     -10.631   4.552   7.711  1.00  0.00           O  
ATOM   1273  H   ASP A  84      -9.023   8.164  10.453  1.00  0.00           H  
ATOM   1274  HA  ASP A  84      -8.030   6.999   8.032  1.00  0.00           H  
ATOM   1275  HB2 ASP A  84      -8.760   5.701  10.039  1.00  0.00           H  
ATOM   1276  HB3 ASP A  84     -10.430   6.120   9.691  1.00  0.00           H  
ATOM   1277  N   GLY A  85     -11.162   8.072   8.081  1.00  0.00           N  
ATOM   1278  CA  GLY A  85     -12.327   8.594   7.397  1.00  0.00           C  
ATOM   1279  C   GLY A  85     -12.752   7.767   6.200  1.00  0.00           C  
ATOM   1280  O   GLY A  85     -13.656   6.941   6.297  1.00  0.00           O  
ATOM   1281  H   GLY A  85     -11.258   7.888   9.073  1.00  0.00           H  
ATOM   1282  HA2 GLY A  85     -13.155   8.632   8.100  1.00  0.00           H  
ATOM   1283  HA3 GLY A  85     -12.115   9.608   7.068  1.00  0.00           H  
ATOM   1284  N   ASN A  86     -12.167   8.052   5.039  1.00  0.00           N  
ATOM   1285  CA  ASN A  86     -12.467   7.367   3.783  1.00  0.00           C  
ATOM   1286  C   ASN A  86     -11.199   7.128   2.960  1.00  0.00           C  
ATOM   1287  O   ASN A  86     -11.310   6.736   1.806  1.00  0.00           O  
ATOM   1288  CB  ASN A  86     -13.492   8.185   2.960  1.00  0.00           C  
ATOM   1289  CG  ASN A  86     -14.806   8.417   3.687  1.00  0.00           C  
ATOM   1290  OD1 ASN A  86     -15.753   7.650   3.561  1.00  0.00           O  
ATOM   1291  ND2 ASN A  86     -14.910   9.494   4.449  1.00  0.00           N  
ATOM   1292  H   ASN A  86     -11.429   8.741   5.075  1.00  0.00           H  
ATOM   1293  HA  ASN A  86     -12.906   6.392   4.003  1.00  0.00           H  
ATOM   1294  HB2 ASN A  86     -13.051   9.136   2.659  1.00  0.00           H  
ATOM   1295  HB3 ASN A  86     -13.737   7.630   2.059  1.00  0.00           H  
ATOM   1296 HD21 ASN A  86     -14.121  10.115   4.544  1.00  0.00           H  
ATOM   1297 HD22 ASN A  86     -15.535   9.369   5.243  1.00  0.00           H  
ATOM   1298  N   SER A  87     -10.004   7.363   3.509  1.00  0.00           N  
ATOM   1299  CA  SER A  87      -8.711   7.210   2.845  1.00  0.00           C  
ATOM   1300  C   SER A  87      -8.589   5.940   1.991  1.00  0.00           C  
ATOM   1301  O   SER A  87      -8.263   6.058   0.814  1.00  0.00           O  
ATOM   1302  CB  SER A  87      -7.596   7.402   3.877  1.00  0.00           C  
ATOM   1303  OG  SER A  87      -7.777   8.639   4.552  1.00  0.00           O  
ATOM   1304  H   SER A  87      -9.966   7.678   4.472  1.00  0.00           H  
ATOM   1305  HA  SER A  87      -8.576   8.030   2.142  1.00  0.00           H  
ATOM   1306  HB2 SER A  87      -7.606   6.585   4.600  1.00  0.00           H  
ATOM   1307  HB3 SER A  87      -6.635   7.424   3.365  1.00  0.00           H  
ATOM   1308  HG  SER A  87      -8.320   8.468   5.347  1.00  0.00           H  
ATOM   1309  N   GLU A  88      -8.852   4.742   2.524  1.00  0.00           N  
ATOM   1310  CA  GLU A  88      -8.731   3.515   1.724  1.00  0.00           C  
ATOM   1311  C   GLU A  88      -9.812   3.418   0.644  1.00  0.00           C  
ATOM   1312  O   GLU A  88      -9.530   2.975  -0.469  1.00  0.00           O  
ATOM   1313  CB  GLU A  88      -8.745   2.270   2.621  1.00  0.00           C  
ATOM   1314  CG  GLU A  88      -7.423   2.152   3.386  1.00  0.00           C  
ATOM   1315  CD  GLU A  88      -7.287   0.828   4.142  1.00  0.00           C  
ATOM   1316  OE1 GLU A  88      -8.077   0.581   5.083  1.00  0.00           O  
ATOM   1317  OE2 GLU A  88      -6.348   0.050   3.868  1.00  0.00           O  
ATOM   1318  H   GLU A  88      -9.121   4.690   3.495  1.00  0.00           H  
ATOM   1319  HA  GLU A  88      -7.774   3.542   1.200  1.00  0.00           H  
ATOM   1320  HB2 GLU A  88      -9.583   2.326   3.315  1.00  0.00           H  
ATOM   1321  HB3 GLU A  88      -8.861   1.383   2.000  1.00  0.00           H  
ATOM   1322  HG2 GLU A  88      -6.603   2.242   2.674  1.00  0.00           H  
ATOM   1323  HG3 GLU A  88      -7.353   2.980   4.093  1.00  0.00           H  
ATOM   1324  N   LEU A  89     -11.044   3.824   0.961  1.00  0.00           N  
ATOM   1325  CA  LEU A  89     -12.160   3.792   0.014  1.00  0.00           C  
ATOM   1326  C   LEU A  89     -11.826   4.684  -1.179  1.00  0.00           C  
ATOM   1327  O   LEU A  89     -11.918   4.253  -2.327  1.00  0.00           O  
ATOM   1328  CB  LEU A  89     -13.465   4.207   0.727  1.00  0.00           C  
ATOM   1329  CG  LEU A  89     -14.773   4.156  -0.094  1.00  0.00           C  
ATOM   1330  CD1 LEU A  89     -14.939   5.304  -1.098  1.00  0.00           C  
ATOM   1331  CD2 LEU A  89     -14.975   2.807  -0.791  1.00  0.00           C  
ATOM   1332  H   LEU A  89     -11.190   4.181   1.893  1.00  0.00           H  
ATOM   1333  HA  LEU A  89     -12.266   2.770  -0.350  1.00  0.00           H  
ATOM   1334  HB2 LEU A  89     -13.597   3.541   1.582  1.00  0.00           H  
ATOM   1335  HB3 LEU A  89     -13.352   5.215   1.124  1.00  0.00           H  
ATOM   1336  HG  LEU A  89     -15.585   4.267   0.626  1.00  0.00           H  
ATOM   1337 HD11 LEU A  89     -15.978   5.345  -1.426  1.00  0.00           H  
ATOM   1338 HD12 LEU A  89     -14.319   5.150  -1.978  1.00  0.00           H  
ATOM   1339 HD13 LEU A  89     -14.685   6.254  -0.629  1.00  0.00           H  
ATOM   1340 HD21 LEU A  89     -14.242   2.667  -1.586  1.00  0.00           H  
ATOM   1341 HD22 LEU A  89     -15.974   2.768  -1.229  1.00  0.00           H  
ATOM   1342 HD23 LEU A  89     -14.880   2.001  -0.064  1.00  0.00           H  
ATOM   1343  N   VAL A  90     -11.413   5.921  -0.909  1.00  0.00           N  
ATOM   1344  CA  VAL A  90     -11.048   6.907  -1.915  1.00  0.00           C  
ATOM   1345  C   VAL A  90      -9.804   6.435  -2.683  1.00  0.00           C  
ATOM   1346  O   VAL A  90      -9.673   6.746  -3.870  1.00  0.00           O  
ATOM   1347  CB  VAL A  90     -10.907   8.287  -1.243  1.00  0.00           C  
ATOM   1348  CG1 VAL A  90     -10.532   9.388  -2.242  1.00  0.00           C  
ATOM   1349  CG2 VAL A  90     -12.239   8.713  -0.613  1.00  0.00           C  
ATOM   1350  H   VAL A  90     -11.361   6.195   0.066  1.00  0.00           H  
ATOM   1351  HA  VAL A  90     -11.869   6.966  -2.626  1.00  0.00           H  
ATOM   1352  HB  VAL A  90     -10.151   8.238  -0.459  1.00  0.00           H  
ATOM   1353 HG11 VAL A  90     -11.297   9.472  -3.014  1.00  0.00           H  
ATOM   1354 HG12 VAL A  90     -10.435  10.341  -1.727  1.00  0.00           H  
ATOM   1355 HG13 VAL A  90      -9.582   9.152  -2.713  1.00  0.00           H  
ATOM   1356 HG21 VAL A  90     -12.997   8.818  -1.387  1.00  0.00           H  
ATOM   1357 HG22 VAL A  90     -12.577   7.966   0.096  1.00  0.00           H  
ATOM   1358 HG23 VAL A  90     -12.114   9.659  -0.087  1.00  0.00           H  
ATOM   1359  N   ALA A  91      -8.906   5.670  -2.051  1.00  0.00           N  
ATOM   1360  CA  ALA A  91      -7.717   5.162  -2.730  1.00  0.00           C  
ATOM   1361  C   ALA A  91      -8.158   4.185  -3.830  1.00  0.00           C  
ATOM   1362  O   ALA A  91      -7.568   4.165  -4.910  1.00  0.00           O  
ATOM   1363  CB  ALA A  91      -6.727   4.521  -1.746  1.00  0.00           C  
ATOM   1364  H   ALA A  91      -9.070   5.457  -1.073  1.00  0.00           H  
ATOM   1365  HA  ALA A  91      -7.221   6.003  -3.213  1.00  0.00           H  
ATOM   1366  HB1 ALA A  91      -7.181   3.663  -1.254  1.00  0.00           H  
ATOM   1367  HB2 ALA A  91      -5.842   4.184  -2.286  1.00  0.00           H  
ATOM   1368  HB3 ALA A  91      -6.417   5.253  -1.001  1.00  0.00           H  
ATOM   1369  N   GLU A  92      -9.191   3.376  -3.573  1.00  0.00           N  
ATOM   1370  CA  GLU A  92      -9.718   2.432  -4.553  1.00  0.00           C  
ATOM   1371  C   GLU A  92     -10.605   3.179  -5.555  1.00  0.00           C  
ATOM   1372  O   GLU A  92     -10.590   2.874  -6.739  1.00  0.00           O  
ATOM   1373  CB  GLU A  92     -10.514   1.305  -3.876  1.00  0.00           C  
ATOM   1374  CG  GLU A  92      -9.605   0.310  -3.141  1.00  0.00           C  
ATOM   1375  CD  GLU A  92     -10.306  -1.035  -2.968  1.00  0.00           C  
ATOM   1376  OE1 GLU A  92     -10.213  -1.863  -3.904  1.00  0.00           O  
ATOM   1377  OE2 GLU A  92     -10.955  -1.274  -1.919  1.00  0.00           O  
ATOM   1378  H   GLU A  92      -9.639   3.440  -2.665  1.00  0.00           H  
ATOM   1379  HA  GLU A  92      -8.892   1.989  -5.110  1.00  0.00           H  
ATOM   1380  HB2 GLU A  92     -11.248   1.718  -3.182  1.00  0.00           H  
ATOM   1381  HB3 GLU A  92     -11.054   0.764  -4.654  1.00  0.00           H  
ATOM   1382  HG2 GLU A  92      -8.699   0.145  -3.729  1.00  0.00           H  
ATOM   1383  HG3 GLU A  92      -9.318   0.714  -2.169  1.00  0.00           H  
ATOM   1384  N   LEU A  93     -11.348   4.196  -5.122  1.00  0.00           N  
ATOM   1385  CA  LEU A  93     -12.244   5.000  -5.951  1.00  0.00           C  
ATOM   1386  C   LEU A  93     -11.553   5.526  -7.202  1.00  0.00           C  
ATOM   1387  O   LEU A  93     -12.015   5.311  -8.325  1.00  0.00           O  
ATOM   1388  CB  LEU A  93     -12.715   6.181  -5.106  1.00  0.00           C  
ATOM   1389  CG  LEU A  93     -13.750   7.110  -5.767  1.00  0.00           C  
ATOM   1390  CD1 LEU A  93     -15.137   6.476  -5.809  1.00  0.00           C  
ATOM   1391  CD2 LEU A  93     -13.827   8.429  -4.990  1.00  0.00           C  
ATOM   1392  H   LEU A  93     -11.313   4.385  -4.125  1.00  0.00           H  
ATOM   1393  HA  LEU A  93     -13.095   4.394  -6.243  1.00  0.00           H  
ATOM   1394  HB2 LEU A  93     -13.100   5.797  -4.168  1.00  0.00           H  
ATOM   1395  HB3 LEU A  93     -11.825   6.760  -4.892  1.00  0.00           H  
ATOM   1396  HG  LEU A  93     -13.441   7.336  -6.785  1.00  0.00           H  
ATOM   1397 HD11 LEU A  93     -15.463   6.218  -4.801  1.00  0.00           H  
ATOM   1398 HD12 LEU A  93     -15.111   5.568  -6.408  1.00  0.00           H  
ATOM   1399 HD13 LEU A  93     -15.852   7.161  -6.264  1.00  0.00           H  
ATOM   1400 HD21 LEU A  93     -14.107   8.234  -3.954  1.00  0.00           H  
ATOM   1401 HD22 LEU A  93     -14.567   9.087  -5.447  1.00  0.00           H  
ATOM   1402 HD23 LEU A  93     -12.857   8.926  -5.014  1.00  0.00           H  
ATOM   1403  N   VAL A  94     -10.460   6.260  -7.004  1.00  0.00           N  
ATOM   1404  CA  VAL A  94      -9.701   6.844  -8.095  1.00  0.00           C  
ATOM   1405  C   VAL A  94      -9.120   5.750  -8.984  1.00  0.00           C  
ATOM   1406  O   VAL A  94      -9.148   5.888 -10.208  1.00  0.00           O  
ATOM   1407  CB  VAL A  94      -8.620   7.791  -7.540  1.00  0.00           C  
ATOM   1408  CG1 VAL A  94      -9.274   8.922  -6.745  1.00  0.00           C  
ATOM   1409  CG2 VAL A  94      -7.557   7.110  -6.668  1.00  0.00           C  
ATOM   1410  H   VAL A  94     -10.128   6.398  -6.054  1.00  0.00           H  
ATOM   1411  HA  VAL A  94     -10.385   7.434  -8.704  1.00  0.00           H  
ATOM   1412  HB  VAL A  94      -8.113   8.257  -8.377  1.00  0.00           H  
ATOM   1413 HG11 VAL A  94      -9.683   8.543  -5.806  1.00  0.00           H  
ATOM   1414 HG12 VAL A  94      -8.515   9.674  -6.539  1.00  0.00           H  
ATOM   1415 HG13 VAL A  94     -10.070   9.384  -7.327  1.00  0.00           H  
ATOM   1416 HG21 VAL A  94      -6.878   7.860  -6.261  1.00  0.00           H  
ATOM   1417 HG22 VAL A  94      -8.021   6.562  -5.851  1.00  0.00           H  
ATOM   1418 HG23 VAL A  94      -6.971   6.411  -7.265  1.00  0.00           H  
ATOM   1419  N   ALA A  95      -8.619   4.679  -8.368  1.00  0.00           N  
ATOM   1420  CA  ALA A  95      -8.012   3.553  -9.058  1.00  0.00           C  
ATOM   1421  C   ALA A  95      -9.023   2.919 -10.019  1.00  0.00           C  
ATOM   1422  O   ALA A  95      -8.752   2.727 -11.206  1.00  0.00           O  
ATOM   1423  CB  ALA A  95      -7.507   2.569  -8.001  1.00  0.00           C  
ATOM   1424  H   ALA A  95      -8.658   4.660  -7.352  1.00  0.00           H  
ATOM   1425  HA  ALA A  95      -7.155   3.918  -9.625  1.00  0.00           H  
ATOM   1426  HB1 ALA A  95      -8.337   2.205  -7.401  1.00  0.00           H  
ATOM   1427  HB2 ALA A  95      -7.013   1.728  -8.485  1.00  0.00           H  
ATOM   1428  HB3 ALA A  95      -6.803   3.076  -7.338  1.00  0.00           H  
ATOM   1429  N   LEU A  96     -10.222   2.640  -9.505  1.00  0.00           N  
ATOM   1430  CA  LEU A  96     -11.320   2.045 -10.260  1.00  0.00           C  
ATOM   1431  C   LEU A  96     -11.738   2.993 -11.384  1.00  0.00           C  
ATOM   1432  O   LEU A  96     -12.005   2.534 -12.497  1.00  0.00           O  
ATOM   1433  CB  LEU A  96     -12.503   1.695  -9.342  1.00  0.00           C  
ATOM   1434  CG  LEU A  96     -12.475   0.238  -8.828  1.00  0.00           C  
ATOM   1435  CD1 LEU A  96     -11.271  -0.081  -7.940  1.00  0.00           C  
ATOM   1436  CD2 LEU A  96     -13.742  -0.050  -8.018  1.00  0.00           C  
ATOM   1437  H   LEU A  96     -10.338   2.840  -8.514  1.00  0.00           H  
ATOM   1438  HA  LEU A  96     -10.956   1.125 -10.715  1.00  0.00           H  
ATOM   1439  HB2 LEU A  96     -12.537   2.393  -8.506  1.00  0.00           H  
ATOM   1440  HB3 LEU A  96     -13.423   1.818  -9.917  1.00  0.00           H  
ATOM   1441  HG  LEU A  96     -12.457  -0.433  -9.688  1.00  0.00           H  
ATOM   1442 HD11 LEU A  96     -10.336   0.086  -8.475  1.00  0.00           H  
ATOM   1443 HD12 LEU A  96     -11.310  -1.127  -7.638  1.00  0.00           H  
ATOM   1444 HD13 LEU A  96     -11.287   0.526  -7.038  1.00  0.00           H  
ATOM   1445 HD21 LEU A  96     -13.810   0.600  -7.149  1.00  0.00           H  
ATOM   1446 HD22 LEU A  96     -13.724  -1.078  -7.663  1.00  0.00           H  
ATOM   1447 HD23 LEU A  96     -14.620   0.064  -8.651  1.00  0.00           H  
ATOM   1448  N   ASN A  97     -11.746   4.308 -11.129  1.00  0.00           N  
ATOM   1449  CA  ASN A  97     -12.107   5.305 -12.137  1.00  0.00           C  
ATOM   1450  C   ASN A  97     -11.123   5.238 -13.296  1.00  0.00           C  
ATOM   1451  O   ASN A  97     -11.549   5.168 -14.451  1.00  0.00           O  
ATOM   1452  CB  ASN A  97     -12.149   6.731 -11.569  1.00  0.00           C  
ATOM   1453  CG  ASN A  97     -13.558   7.053 -11.126  1.00  0.00           C  
ATOM   1454  OD1 ASN A  97     -14.307   7.707 -11.846  1.00  0.00           O  
ATOM   1455  ND2 ASN A  97     -13.951   6.571  -9.963  1.00  0.00           N  
ATOM   1456  H   ASN A  97     -11.514   4.602 -10.188  1.00  0.00           H  
ATOM   1457  HA  ASN A  97     -13.097   5.060 -12.525  1.00  0.00           H  
ATOM   1458  HB2 ASN A  97     -11.451   6.855 -10.744  1.00  0.00           H  
ATOM   1459  HB3 ASN A  97     -11.877   7.443 -12.352  1.00  0.00           H  
ATOM   1460 HD21 ASN A  97     -13.310   6.004  -9.414  1.00  0.00           H  
ATOM   1461 HD22 ASN A  97     -14.930   6.573  -9.697  1.00  0.00           H  
ATOM   1462  N   GLY A  98      -9.825   5.245 -13.006  1.00  0.00           N  
ATOM   1463  CA  GLY A  98      -8.786   5.176 -14.019  1.00  0.00           C  
ATOM   1464  C   GLY A  98      -7.455   5.746 -13.554  1.00  0.00           C  
ATOM   1465  O   GLY A  98      -6.491   5.661 -14.313  1.00  0.00           O  
ATOM   1466  H   GLY A  98      -9.541   5.302 -12.034  1.00  0.00           H  
ATOM   1467  HA2 GLY A  98      -8.630   4.139 -14.310  1.00  0.00           H  
ATOM   1468  HA3 GLY A  98      -9.107   5.722 -14.906  1.00  0.00           H  
ATOM   1469  N   PHE A  99      -7.371   6.388 -12.383  1.00  0.00           N  
ATOM   1470  CA  PHE A  99      -6.114   6.929 -11.890  1.00  0.00           C  
ATOM   1471  C   PHE A  99      -5.098   5.799 -11.702  1.00  0.00           C  
ATOM   1472  O   PHE A  99      -5.486   4.653 -11.472  1.00  0.00           O  
ATOM   1473  CB  PHE A  99      -6.317   7.660 -10.569  1.00  0.00           C  
ATOM   1474  CG  PHE A  99      -6.798   9.092 -10.685  1.00  0.00           C  
ATOM   1475  CD1 PHE A  99      -8.170   9.397 -10.787  1.00  0.00           C  
ATOM   1476  CD2 PHE A  99      -5.848  10.129 -10.674  1.00  0.00           C  
ATOM   1477  CE1 PHE A  99      -8.581  10.737 -10.910  1.00  0.00           C  
ATOM   1478  CE2 PHE A  99      -6.257  11.466 -10.778  1.00  0.00           C  
ATOM   1479  CZ  PHE A  99      -7.623  11.767 -10.918  1.00  0.00           C  
ATOM   1480  H   PHE A  99      -8.169   6.454 -11.770  1.00  0.00           H  
ATOM   1481  HA  PHE A  99      -5.737   7.622 -12.632  1.00  0.00           H  
ATOM   1482  HB2 PHE A  99      -6.967   7.084  -9.922  1.00  0.00           H  
ATOM   1483  HB3 PHE A  99      -5.356   7.677 -10.074  1.00  0.00           H  
ATOM   1484  HD1 PHE A  99      -8.911   8.609 -10.772  1.00  0.00           H  
ATOM   1485  HD2 PHE A  99      -4.794   9.898 -10.592  1.00  0.00           H  
ATOM   1486  HE1 PHE A  99      -9.632  10.969 -11.012  1.00  0.00           H  
ATOM   1487  HE2 PHE A  99      -5.509  12.247 -10.785  1.00  0.00           H  
ATOM   1488  HZ  PHE A  99      -7.922  12.787 -11.074  1.00  0.00           H  
ATOM   1489  N   LYS A 100      -3.801   6.120 -11.731  1.00  0.00           N  
ATOM   1490  CA  LYS A 100      -2.758   5.121 -11.586  1.00  0.00           C  
ATOM   1491  C   LYS A 100      -2.846   4.362 -10.270  1.00  0.00           C  
ATOM   1492  O   LYS A 100      -3.052   3.152 -10.263  1.00  0.00           O  
ATOM   1493  CB  LYS A 100      -1.370   5.764 -11.741  1.00  0.00           C  
ATOM   1494  CG  LYS A 100      -0.225   4.747 -11.628  1.00  0.00           C  
ATOM   1495  CD  LYS A 100      -0.164   3.731 -12.781  1.00  0.00           C  
ATOM   1496  CE  LYS A 100      -0.981   2.458 -12.496  1.00  0.00           C  
ATOM   1497  NZ  LYS A 100      -1.051   1.570 -13.669  1.00  0.00           N  
ATOM   1498  H   LYS A 100      -3.512   7.074 -11.916  1.00  0.00           H  
ATOM   1499  HA  LYS A 100      -2.910   4.408 -12.396  1.00  0.00           H  
ATOM   1500  HB2 LYS A 100      -1.305   6.266 -12.699  1.00  0.00           H  
ATOM   1501  HB3 LYS A 100      -1.230   6.518 -10.967  1.00  0.00           H  
ATOM   1502  HG2 LYS A 100       0.711   5.297 -11.588  1.00  0.00           H  
ATOM   1503  HG3 LYS A 100      -0.303   4.232 -10.679  1.00  0.00           H  
ATOM   1504  HD2 LYS A 100      -0.514   4.208 -13.695  1.00  0.00           H  
ATOM   1505  HD3 LYS A 100       0.878   3.442 -12.930  1.00  0.00           H  
ATOM   1506  HE2 LYS A 100      -0.525   1.923 -11.661  1.00  0.00           H  
ATOM   1507  HE3 LYS A 100      -2.000   2.719 -12.219  1.00  0.00           H  
ATOM   1508  HZ1 LYS A 100      -0.122   1.345 -14.009  1.00  0.00           H  
ATOM   1509  HZ2 LYS A 100      -1.578   2.013 -14.423  1.00  0.00           H  
ATOM   1510  HZ3 LYS A 100      -1.522   0.702 -13.423  1.00  0.00           H  
ATOM   1511  N   SER A 101      -2.579   5.038  -9.158  1.00  0.00           N  
ATOM   1512  CA  SER A 101      -2.574   4.451  -7.828  1.00  0.00           C  
ATOM   1513  C   SER A 101      -2.756   5.558  -6.795  1.00  0.00           C  
ATOM   1514  O   SER A 101      -2.708   6.739  -7.143  1.00  0.00           O  
ATOM   1515  CB  SER A 101      -1.217   3.755  -7.659  1.00  0.00           C  
ATOM   1516  OG  SER A 101      -1.142   2.615  -8.494  1.00  0.00           O  
ATOM   1517  H   SER A 101      -2.419   6.034  -9.208  1.00  0.00           H  
ATOM   1518  HA  SER A 101      -3.387   3.730  -7.727  1.00  0.00           H  
ATOM   1519  HB2 SER A 101      -0.425   4.452  -7.928  1.00  0.00           H  
ATOM   1520  HB3 SER A 101      -1.066   3.456  -6.632  1.00  0.00           H  
ATOM   1521  HG  SER A 101      -1.946   2.619  -9.057  1.00  0.00           H  
ATOM   1522  N   ALA A 102      -2.955   5.214  -5.528  1.00  0.00           N  
ATOM   1523  CA  ALA A 102      -3.150   6.140  -4.442  1.00  0.00           C  
ATOM   1524  C   ALA A 102      -2.619   5.466  -3.184  1.00  0.00           C  
ATOM   1525  O   ALA A 102      -2.405   4.256  -3.154  1.00  0.00           O  
ATOM   1526  CB  ALA A 102      -4.658   6.403  -4.334  1.00  0.00           C  
ATOM   1527  H   ALA A 102      -2.996   4.259  -5.193  1.00  0.00           H  
ATOM   1528  HA  ALA A 102      -2.611   7.071  -4.625  1.00  0.00           H  
ATOM   1529  HB1 ALA A 102      -5.203   5.458  -4.313  1.00  0.00           H  
ATOM   1530  HB2 ALA A 102      -4.883   6.968  -3.431  1.00  0.00           H  
ATOM   1531  HB3 ALA A 102      -4.988   6.973  -5.202  1.00  0.00           H  
ATOM   1532  N   TYR A 103      -2.405   6.248  -2.139  1.00  0.00           N  
ATOM   1533  CA  TYR A 103      -1.928   5.766  -0.853  1.00  0.00           C  
ATOM   1534  C   TYR A 103      -2.752   6.412   0.238  1.00  0.00           C  
ATOM   1535  O   TYR A 103      -2.863   7.637   0.265  1.00  0.00           O  
ATOM   1536  CB  TYR A 103      -0.453   6.090  -0.649  1.00  0.00           C  
ATOM   1537  CG  TYR A 103       0.462   5.088  -1.308  1.00  0.00           C  
ATOM   1538  CD1 TYR A 103       0.799   5.236  -2.664  1.00  0.00           C  
ATOM   1539  CD2 TYR A 103       0.921   3.973  -0.581  1.00  0.00           C  
ATOM   1540  CE1 TYR A 103       1.575   4.260  -3.303  1.00  0.00           C  
ATOM   1541  CE2 TYR A 103       1.707   2.997  -1.213  1.00  0.00           C  
ATOM   1542  CZ  TYR A 103       2.022   3.131  -2.583  1.00  0.00           C  
ATOM   1543  OH  TYR A 103       2.756   2.170  -3.201  1.00  0.00           O  
ATOM   1544  H   TYR A 103      -2.598   7.228  -2.249  1.00  0.00           H  
ATOM   1545  HA  TYR A 103      -2.042   4.688  -0.795  1.00  0.00           H  
ATOM   1546  HB2 TYR A 103      -0.269   7.085  -1.039  1.00  0.00           H  
ATOM   1547  HB3 TYR A 103      -0.243   6.101   0.421  1.00  0.00           H  
ATOM   1548  HD1 TYR A 103       0.444   6.091  -3.221  1.00  0.00           H  
ATOM   1549  HD2 TYR A 103       0.656   3.842   0.458  1.00  0.00           H  
ATOM   1550  HE1 TYR A 103       1.800   4.380  -4.350  1.00  0.00           H  
ATOM   1551  HE2 TYR A 103       2.037   2.135  -0.653  1.00  0.00           H  
ATOM   1552  HH  TYR A 103       2.815   2.344  -4.156  1.00  0.00           H  
ATOM   1553  N   ALA A 104      -3.344   5.599   1.106  1.00  0.00           N  
ATOM   1554  CA  ALA A 104      -4.142   6.061   2.220  1.00  0.00           C  
ATOM   1555  C   ALA A 104      -3.163   6.196   3.378  1.00  0.00           C  
ATOM   1556  O   ALA A 104      -2.604   5.192   3.844  1.00  0.00           O  
ATOM   1557  CB  ALA A 104      -5.267   5.064   2.501  1.00  0.00           C  
ATOM   1558  H   ALA A 104      -3.201   4.596   1.021  1.00  0.00           H  
ATOM   1559  HA  ALA A 104      -4.582   7.034   1.995  1.00  0.00           H  
ATOM   1560  HB1 ALA A 104      -5.773   5.321   3.429  1.00  0.00           H  
ATOM   1561  HB2 ALA A 104      -5.972   5.082   1.671  1.00  0.00           H  
ATOM   1562  HB3 ALA A 104      -4.870   4.062   2.583  1.00  0.00           H  
ATOM   1563  N   ILE A 105      -2.870   7.433   3.777  1.00  0.00           N  
ATOM   1564  CA  ILE A 105      -1.959   7.693   4.873  1.00  0.00           C  
ATOM   1565  C   ILE A 105      -2.707   7.400   6.168  1.00  0.00           C  
ATOM   1566  O   ILE A 105      -3.413   8.248   6.711  1.00  0.00           O  
ATOM   1567  CB  ILE A 105      -1.325   9.101   4.793  1.00  0.00           C  
ATOM   1568  CG1 ILE A 105      -0.260   9.145   3.670  1.00  0.00           C  
ATOM   1569  CG2 ILE A 105      -0.605   9.474   6.102  1.00  0.00           C  
ATOM   1570  CD1 ILE A 105      -0.800   9.484   2.282  1.00  0.00           C  
ATOM   1571  H   ILE A 105      -3.345   8.230   3.373  1.00  0.00           H  
ATOM   1572  HA  ILE A 105      -1.140   6.978   4.807  1.00  0.00           H  
ATOM   1573  HB  ILE A 105      -2.113   9.829   4.608  1.00  0.00           H  
ATOM   1574 HG12 ILE A 105       0.497   9.897   3.897  1.00  0.00           H  
ATOM   1575 HG13 ILE A 105       0.252   8.184   3.624  1.00  0.00           H  
ATOM   1576 HG21 ILE A 105      -0.055  10.407   5.976  1.00  0.00           H  
ATOM   1577 HG22 ILE A 105      -1.322   9.625   6.908  1.00  0.00           H  
ATOM   1578 HG23 ILE A 105       0.085   8.686   6.388  1.00  0.00           H  
ATOM   1579 HD11 ILE A 105      -0.821  10.568   2.157  1.00  0.00           H  
ATOM   1580 HD12 ILE A 105      -0.146   9.061   1.532  1.00  0.00           H  
ATOM   1581 HD13 ILE A 105      -1.796   9.083   2.139  1.00  0.00           H  
ATOM   1582  N   LYS A 106      -2.555   6.152   6.614  1.00  0.00           N  
ATOM   1583  CA  LYS A 106      -3.103   5.588   7.828  1.00  0.00           C  
ATOM   1584  C   LYS A 106      -2.802   6.570   8.950  1.00  0.00           C  
ATOM   1585  O   LYS A 106      -1.662   7.046   9.048  1.00  0.00           O  
ATOM   1586  CB  LYS A 106      -2.405   4.245   8.127  1.00  0.00           C  
ATOM   1587  CG  LYS A 106      -3.060   3.388   9.224  1.00  0.00           C  
ATOM   1588  CD  LYS A 106      -4.379   2.710   8.832  1.00  0.00           C  
ATOM   1589  CE  LYS A 106      -4.237   1.298   8.242  1.00  0.00           C  
ATOM   1590  NZ  LYS A 106      -3.606   1.250   6.914  1.00  0.00           N  
ATOM   1591  H   LYS A 106      -1.936   5.584   6.054  1.00  0.00           H  
ATOM   1592  HA  LYS A 106      -4.179   5.477   7.689  1.00  0.00           H  
ATOM   1593  HB2 LYS A 106      -2.270   3.673   7.210  1.00  0.00           H  
ATOM   1594  HB3 LYS A 106      -1.407   4.478   8.493  1.00  0.00           H  
ATOM   1595  HG2 LYS A 106      -2.354   2.622   9.545  1.00  0.00           H  
ATOM   1596  HG3 LYS A 106      -3.254   4.026  10.086  1.00  0.00           H  
ATOM   1597  HD2 LYS A 106      -4.980   2.613   9.737  1.00  0.00           H  
ATOM   1598  HD3 LYS A 106      -4.939   3.349   8.156  1.00  0.00           H  
ATOM   1599  HE2 LYS A 106      -3.680   0.665   8.934  1.00  0.00           H  
ATOM   1600  HE3 LYS A 106      -5.239   0.887   8.134  1.00  0.00           H  
ATOM   1601  HZ1 LYS A 106      -3.971   1.996   6.324  1.00  0.00           H  
ATOM   1602  HZ2 LYS A 106      -3.862   0.377   6.453  1.00  0.00           H  
ATOM   1603  HZ3 LYS A 106      -2.600   1.290   6.995  1.00  0.00           H  
ATOM   1604  N   ASP A 107      -3.840   6.825   9.740  1.00  0.00           N  
ATOM   1605  CA  ASP A 107      -3.929   7.697  10.911  1.00  0.00           C  
ATOM   1606  C   ASP A 107      -4.330   9.127  10.542  1.00  0.00           C  
ATOM   1607  O   ASP A 107      -4.610   9.910  11.454  1.00  0.00           O  
ATOM   1608  CB  ASP A 107      -2.655   7.724  11.785  1.00  0.00           C  
ATOM   1609  CG  ASP A 107      -2.381   6.394  12.471  1.00  0.00           C  
ATOM   1610  OD1 ASP A 107      -1.853   5.462  11.826  1.00  0.00           O  
ATOM   1611  OD2 ASP A 107      -2.658   6.295  13.686  1.00  0.00           O  
ATOM   1612  H   ASP A 107      -4.683   6.324   9.483  1.00  0.00           H  
ATOM   1613  HA  ASP A 107      -4.719   7.284  11.533  1.00  0.00           H  
ATOM   1614  HB2 ASP A 107      -1.782   8.060  11.231  1.00  0.00           H  
ATOM   1615  HB3 ASP A 107      -2.787   8.459  12.574  1.00  0.00           H  
ATOM   1616  N   GLY A 108      -4.452   9.468   9.253  1.00  0.00           N  
ATOM   1617  CA  GLY A 108      -4.787  10.823   8.815  1.00  0.00           C  
ATOM   1618  C   GLY A 108      -3.660  11.785   9.187  1.00  0.00           C  
ATOM   1619  O   GLY A 108      -2.545  11.354   9.492  1.00  0.00           O  
ATOM   1620  H   GLY A 108      -4.227   8.800   8.528  1.00  0.00           H  
ATOM   1621  HA2 GLY A 108      -4.959  10.851   7.737  1.00  0.00           H  
ATOM   1622  HA3 GLY A 108      -5.690  11.161   9.300  1.00  0.00           H  
ATOM   1623  N   ALA A 109      -3.916  13.091   9.153  1.00  0.00           N  
ATOM   1624  CA  ALA A 109      -2.911  14.093   9.498  1.00  0.00           C  
ATOM   1625  C   ALA A 109      -2.875  14.454  10.983  1.00  0.00           C  
ATOM   1626  O   ALA A 109      -1.881  15.041  11.403  1.00  0.00           O  
ATOM   1627  CB  ALA A 109      -3.107  15.358   8.668  1.00  0.00           C  
ATOM   1628  H   ALA A 109      -4.853  13.379   8.887  1.00  0.00           H  
ATOM   1629  HA  ALA A 109      -1.931  13.705   9.235  1.00  0.00           H  
ATOM   1630  HB1 ALA A 109      -2.790  15.138   7.654  1.00  0.00           H  
ATOM   1631  HB2 ALA A 109      -4.149  15.678   8.692  1.00  0.00           H  
ATOM   1632  HB3 ALA A 109      -2.473  16.160   9.050  1.00  0.00           H  
ATOM   1633  N   GLU A 110      -3.891  14.085  11.773  1.00  0.00           N  
ATOM   1634  CA  GLU A 110      -3.953  14.418  13.199  1.00  0.00           C  
ATOM   1635  C   GLU A 110      -3.846  13.198  14.120  1.00  0.00           C  
ATOM   1636  O   GLU A 110      -3.823  13.356  15.344  1.00  0.00           O  
ATOM   1637  CB  GLU A 110      -5.243  15.212  13.486  1.00  0.00           C  
ATOM   1638  CG  GLU A 110      -5.316  16.518  12.675  1.00  0.00           C  
ATOM   1639  CD  GLU A 110      -6.517  17.391  13.051  1.00  0.00           C  
ATOM   1640  OE1 GLU A 110      -6.867  17.494  14.255  1.00  0.00           O  
ATOM   1641  OE2 GLU A 110      -7.121  17.980  12.124  1.00  0.00           O  
ATOM   1642  H   GLU A 110      -4.691  13.605  11.372  1.00  0.00           H  
ATOM   1643  HA  GLU A 110      -3.115  15.070  13.450  1.00  0.00           H  
ATOM   1644  HB2 GLU A 110      -6.114  14.596  13.252  1.00  0.00           H  
ATOM   1645  HB3 GLU A 110      -5.270  15.456  14.548  1.00  0.00           H  
ATOM   1646  HG2 GLU A 110      -4.403  17.092  12.827  1.00  0.00           H  
ATOM   1647  HG3 GLU A 110      -5.382  16.277  11.614  1.00  0.00           H  
ATOM   1648  N   GLY A 111      -3.763  11.977  13.579  1.00  0.00           N  
ATOM   1649  CA  GLY A 111      -3.667  10.772  14.395  1.00  0.00           C  
ATOM   1650  C   GLY A 111      -2.357  10.678  15.188  1.00  0.00           C  
ATOM   1651  O   GLY A 111      -1.446  11.493  14.997  1.00  0.00           O  
ATOM   1652  H   GLY A 111      -3.788  11.875  12.573  1.00  0.00           H  
ATOM   1653  HA2 GLY A 111      -4.497  10.775  15.102  1.00  0.00           H  
ATOM   1654  HA3 GLY A 111      -3.767   9.899  13.760  1.00  0.00           H  
ATOM   1655  N   PRO A 112      -2.199   9.641  16.033  1.00  0.00           N  
ATOM   1656  CA  PRO A 112      -1.019   9.436  16.876  1.00  0.00           C  
ATOM   1657  C   PRO A 112       0.310   9.378  16.132  1.00  0.00           C  
ATOM   1658  O   PRO A 112       1.349   9.713  16.706  1.00  0.00           O  
ATOM   1659  CB  PRO A 112      -1.290   8.164  17.679  1.00  0.00           C  
ATOM   1660  CG  PRO A 112      -2.417   7.464  16.932  1.00  0.00           C  
ATOM   1661  CD  PRO A 112      -3.192   8.618  16.311  1.00  0.00           C  
ATOM   1662  HA  PRO A 112      -0.960  10.276  17.566  1.00  0.00           H  
ATOM   1663  HB2 PRO A 112      -0.408   7.527  17.771  1.00  0.00           H  
ATOM   1664  HB3 PRO A 112      -1.651   8.462  18.654  1.00  0.00           H  
ATOM   1665  HG2 PRO A 112      -1.996   6.834  16.150  1.00  0.00           H  
ATOM   1666  HG3 PRO A 112      -3.048   6.885  17.604  1.00  0.00           H  
ATOM   1667  HD2 PRO A 112      -3.691   8.278  15.403  1.00  0.00           H  
ATOM   1668  HD3 PRO A 112      -3.918   9.003  17.027  1.00  0.00           H  
ATOM   1669  N   ARG A 113       0.261   8.997  14.859  1.00  0.00           N  
ATOM   1670  CA  ARG A 113       1.387   8.896  13.932  1.00  0.00           C  
ATOM   1671  C   ARG A 113       1.020   9.518  12.578  1.00  0.00           C  
ATOM   1672  O   ARG A 113       1.465   9.039  11.531  1.00  0.00           O  
ATOM   1673  CB  ARG A 113       1.855   7.442  13.816  1.00  0.00           C  
ATOM   1674  CG  ARG A 113       0.795   6.511  13.205  1.00  0.00           C  
ATOM   1675  CD  ARG A 113       1.435   5.252  12.636  1.00  0.00           C  
ATOM   1676  NE  ARG A 113       2.062   4.487  13.716  1.00  0.00           N  
ATOM   1677  CZ  ARG A 113       2.762   3.362  13.628  1.00  0.00           C  
ATOM   1678  NH1 ARG A 113       3.005   2.794  12.448  1.00  0.00           N  
ATOM   1679  NH2 ARG A 113       3.196   2.826  14.758  1.00  0.00           N  
ATOM   1680  H   ARG A 113      -0.661   8.743  14.539  1.00  0.00           H  
ATOM   1681  HA  ARG A 113       2.224   9.476  14.330  1.00  0.00           H  
ATOM   1682  HB2 ARG A 113       2.752   7.429  13.196  1.00  0.00           H  
ATOM   1683  HB3 ARG A 113       2.119   7.079  14.809  1.00  0.00           H  
ATOM   1684  HG2 ARG A 113       0.062   6.243  13.966  1.00  0.00           H  
ATOM   1685  HG3 ARG A 113       0.277   7.005  12.388  1.00  0.00           H  
ATOM   1686  HD2 ARG A 113       0.658   4.648  12.166  1.00  0.00           H  
ATOM   1687  HD3 ARG A 113       2.173   5.539  11.882  1.00  0.00           H  
ATOM   1688  HE  ARG A 113       1.852   4.825  14.656  1.00  0.00           H  
ATOM   1689 HH11 ARG A 113       2.608   3.212  11.606  1.00  0.00           H  
ATOM   1690 HH12 ARG A 113       3.535   1.939  12.324  1.00  0.00           H  
ATOM   1691 HH21 ARG A 113       2.935   3.283  15.628  1.00  0.00           H  
ATOM   1692 HH22 ARG A 113       3.564   1.880  14.810  1.00  0.00           H  
ATOM   1693  N   GLY A 114       0.119  10.499  12.581  1.00  0.00           N  
ATOM   1694  CA  GLY A 114      -0.312  11.186  11.376  1.00  0.00           C  
ATOM   1695  C   GLY A 114       0.824  12.012  10.776  1.00  0.00           C  
ATOM   1696  O   GLY A 114       1.973  11.911  11.220  1.00  0.00           O  
ATOM   1697  H   GLY A 114      -0.219  10.866  13.458  1.00  0.00           H  
ATOM   1698  HA2 GLY A 114      -0.625  10.438  10.646  1.00  0.00           H  
ATOM   1699  HA3 GLY A 114      -1.149  11.841  11.618  1.00  0.00           H  
ATOM   1700  N   TRP A 115       0.515  12.827   9.761  1.00  0.00           N  
ATOM   1701  CA  TRP A 115       1.486  13.674   9.081  1.00  0.00           C  
ATOM   1702  C   TRP A 115       2.376  14.451  10.059  1.00  0.00           C  
ATOM   1703  O   TRP A 115       3.606  14.371   9.989  1.00  0.00           O  
ATOM   1704  CB  TRP A 115       0.751  14.631   8.131  1.00  0.00           C  
ATOM   1705  CG  TRP A 115       1.652  15.329   7.169  1.00  0.00           C  
ATOM   1706  CD1 TRP A 115       2.308  16.483   7.414  1.00  0.00           C  
ATOM   1707  CD2 TRP A 115       1.998  14.942   5.806  1.00  0.00           C  
ATOM   1708  NE1 TRP A 115       3.104  16.801   6.341  1.00  0.00           N  
ATOM   1709  CE2 TRP A 115       2.971  15.867   5.323  1.00  0.00           C  
ATOM   1710  CE3 TRP A 115       1.585  13.913   4.925  1.00  0.00           C  
ATOM   1711  CZ2 TRP A 115       3.529  15.754   4.037  1.00  0.00           C  
ATOM   1712  CZ3 TRP A 115       2.105  13.824   3.620  1.00  0.00           C  
ATOM   1713  CH2 TRP A 115       3.071  14.741   3.176  1.00  0.00           C  
ATOM   1714  H   TRP A 115      -0.442  12.879   9.419  1.00  0.00           H  
ATOM   1715  HA  TRP A 115       2.127  13.022   8.490  1.00  0.00           H  
ATOM   1716  HB2 TRP A 115       0.030  14.071   7.546  1.00  0.00           H  
ATOM   1717  HB3 TRP A 115       0.194  15.373   8.707  1.00  0.00           H  
ATOM   1718  HD1 TRP A 115       2.215  17.098   8.301  1.00  0.00           H  
ATOM   1719  HE1 TRP A 115       3.618  17.696   6.349  1.00  0.00           H  
ATOM   1720  HE3 TRP A 115       0.829  13.200   5.241  1.00  0.00           H  
ATOM   1721  HZ2 TRP A 115       4.280  16.452   3.696  1.00  0.00           H  
ATOM   1722  HZ3 TRP A 115       1.747  13.057   2.949  1.00  0.00           H  
ATOM   1723  HH2 TRP A 115       3.443  14.670   2.166  1.00  0.00           H  
ATOM   1724  N   LEU A 116       1.746  15.205  10.962  1.00  0.00           N  
ATOM   1725  CA  LEU A 116       2.426  16.024  11.962  1.00  0.00           C  
ATOM   1726  C   LEU A 116       3.274  15.143  12.880  1.00  0.00           C  
ATOM   1727  O   LEU A 116       4.474  15.390  13.038  1.00  0.00           O  
ATOM   1728  CB  LEU A 116       1.397  16.835  12.769  1.00  0.00           C  
ATOM   1729  CG  LEU A 116       0.704  17.957  11.968  1.00  0.00           C  
ATOM   1730  CD1 LEU A 116      -0.529  18.460  12.729  1.00  0.00           C  
ATOM   1731  CD2 LEU A 116       1.650  19.135  11.707  1.00  0.00           C  
ATOM   1732  H   LEU A 116       0.735  15.190  10.934  1.00  0.00           H  
ATOM   1733  HA  LEU A 116       3.101  16.710  11.450  1.00  0.00           H  
ATOM   1734  HB2 LEU A 116       0.640  16.145  13.134  1.00  0.00           H  
ATOM   1735  HB3 LEU A 116       1.890  17.277  13.638  1.00  0.00           H  
ATOM   1736  HG  LEU A 116       0.367  17.561  11.010  1.00  0.00           H  
ATOM   1737 HD11 LEU A 116      -0.246  18.828  13.716  1.00  0.00           H  
ATOM   1738 HD12 LEU A 116      -1.248  17.645  12.829  1.00  0.00           H  
ATOM   1739 HD13 LEU A 116      -0.999  19.267  12.168  1.00  0.00           H  
ATOM   1740 HD21 LEU A 116       1.116  19.922  11.173  1.00  0.00           H  
ATOM   1741 HD22 LEU A 116       2.492  18.817  11.092  1.00  0.00           H  
ATOM   1742 HD23 LEU A 116       2.024  19.535  12.649  1.00  0.00           H  
ATOM   1743  N   ASN A 117       2.681  14.082  13.436  1.00  0.00           N  
ATOM   1744  CA  ASN A 117       3.338  13.136  14.345  1.00  0.00           C  
ATOM   1745  C   ASN A 117       4.292  12.163  13.631  1.00  0.00           C  
ATOM   1746  O   ASN A 117       4.545  11.048  14.104  1.00  0.00           O  
ATOM   1747  CB  ASN A 117       2.299  12.401  15.207  1.00  0.00           C  
ATOM   1748  CG  ASN A 117       1.600  13.321  16.204  1.00  0.00           C  
ATOM   1749  OD1 ASN A 117       2.166  14.303  16.673  1.00  0.00           O  
ATOM   1750  ND2 ASN A 117       0.358  13.035  16.555  1.00  0.00           N  
ATOM   1751  H   ASN A 117       1.691  13.947  13.255  1.00  0.00           H  
ATOM   1752  HA  ASN A 117       3.957  13.723  15.022  1.00  0.00           H  
ATOM   1753  HB2 ASN A 117       1.575  11.911  14.560  1.00  0.00           H  
ATOM   1754  HB3 ASN A 117       2.815  11.642  15.791  1.00  0.00           H  
ATOM   1755 HD21 ASN A 117      -0.158  12.290  16.110  1.00  0.00           H  
ATOM   1756 HD22 ASN A 117      -0.145  13.660  17.171  1.00  0.00           H  
ATOM   1757  N   SER A 118       4.811  12.559  12.472  1.00  0.00           N  
ATOM   1758  CA  SER A 118       5.747  11.816  11.643  1.00  0.00           C  
ATOM   1759  C   SER A 118       6.954  12.685  11.270  1.00  0.00           C  
ATOM   1760  O   SER A 118       7.734  12.304  10.399  1.00  0.00           O  
ATOM   1761  CB  SER A 118       5.025  11.276  10.408  1.00  0.00           C  
ATOM   1762  OG  SER A 118       4.133  10.251  10.784  1.00  0.00           O  
ATOM   1763  H   SER A 118       4.552  13.482  12.149  1.00  0.00           H  
ATOM   1764  HA  SER A 118       6.130  10.972  12.214  1.00  0.00           H  
ATOM   1765  HB2 SER A 118       4.477  12.074   9.912  1.00  0.00           H  
ATOM   1766  HB3 SER A 118       5.752  10.874   9.709  1.00  0.00           H  
ATOM   1767  HG  SER A 118       3.325  10.694  11.104  1.00  0.00           H  
ATOM   1768  N   SER A 119       7.121  13.842  11.919  1.00  0.00           N  
ATOM   1769  CA  SER A 119       8.203  14.790  11.690  1.00  0.00           C  
ATOM   1770  C   SER A 119       8.169  15.411  10.286  1.00  0.00           C  
ATOM   1771  O   SER A 119       9.184  15.913   9.791  1.00  0.00           O  
ATOM   1772  CB  SER A 119       9.552  14.173  12.080  1.00  0.00           C  
ATOM   1773  OG  SER A 119      10.372  15.175  12.647  1.00  0.00           O  
ATOM   1774  H   SER A 119       6.450  14.106  12.631  1.00  0.00           H  
ATOM   1775  HA  SER A 119       8.022  15.595  12.388  1.00  0.00           H  
ATOM   1776  HB2 SER A 119       9.400  13.398  12.832  1.00  0.00           H  
ATOM   1777  HB3 SER A 119      10.035  13.731  11.207  1.00  0.00           H  
ATOM   1778  HG  SER A 119      11.020  15.454  11.964  1.00  0.00           H  
ATOM   1779  N   LEU A 120       7.025  15.334   9.605  1.00  0.00           N  
ATOM   1780  CA  LEU A 120       6.878  15.891   8.274  1.00  0.00           C  
ATOM   1781  C   LEU A 120       6.587  17.389   8.402  1.00  0.00           C  
ATOM   1782  O   LEU A 120       5.973  17.819   9.382  1.00  0.00           O  
ATOM   1783  CB  LEU A 120       5.762  15.167   7.510  1.00  0.00           C  
ATOM   1784  CG  LEU A 120       5.946  13.642   7.411  1.00  0.00           C  
ATOM   1785  CD1 LEU A 120       4.787  13.053   6.608  1.00  0.00           C  
ATOM   1786  CD2 LEU A 120       7.283  13.257   6.766  1.00  0.00           C  
ATOM   1787  H   LEU A 120       6.213  14.926  10.045  1.00  0.00           H  
ATOM   1788  HA  LEU A 120       7.817  15.746   7.739  1.00  0.00           H  
ATOM   1789  HB2 LEU A 120       4.817  15.377   8.007  1.00  0.00           H  
ATOM   1790  HB3 LEU A 120       5.707  15.581   6.501  1.00  0.00           H  
ATOM   1791  HG  LEU A 120       5.911  13.206   8.408  1.00  0.00           H  
ATOM   1792 HD11 LEU A 120       3.855  13.285   7.120  1.00  0.00           H  
ATOM   1793 HD12 LEU A 120       4.894  11.973   6.526  1.00  0.00           H  
ATOM   1794 HD13 LEU A 120       4.749  13.500   5.616  1.00  0.00           H  
ATOM   1795 HD21 LEU A 120       7.426  13.807   5.837  1.00  0.00           H  
ATOM   1796 HD22 LEU A 120       7.317  12.188   6.568  1.00  0.00           H  
ATOM   1797 HD23 LEU A 120       8.102  13.490   7.448  1.00  0.00           H  
ATOM   1798  N   PRO A 121       7.001  18.201   7.422  1.00  0.00           N  
ATOM   1799  CA  PRO A 121       6.768  19.637   7.448  1.00  0.00           C  
ATOM   1800  C   PRO A 121       5.300  19.928   7.157  1.00  0.00           C  
ATOM   1801  O   PRO A 121       4.656  19.154   6.439  1.00  0.00           O  
ATOM   1802  CB  PRO A 121       7.630  20.199   6.325  1.00  0.00           C  
ATOM   1803  CG  PRO A 121       7.770  19.036   5.344  1.00  0.00           C  
ATOM   1804  CD  PRO A 121       7.724  17.803   6.227  1.00  0.00           C  
ATOM   1805  HA  PRO A 121       7.059  20.063   8.410  1.00  0.00           H  
ATOM   1806  HB2 PRO A 121       7.127  21.036   5.847  1.00  0.00           H  
ATOM   1807  HB3 PRO A 121       8.608  20.483   6.717  1.00  0.00           H  
ATOM   1808  HG2 PRO A 121       6.913  19.009   4.678  1.00  0.00           H  
ATOM   1809  HG3 PRO A 121       8.690  19.087   4.770  1.00  0.00           H  
ATOM   1810  HD2 PRO A 121       7.224  16.991   5.700  1.00  0.00           H  
ATOM   1811  HD3 PRO A 121       8.729  17.503   6.501  1.00  0.00           H  
ATOM   1812  N   TRP A 122       4.777  21.064   7.621  1.00  0.00           N  
ATOM   1813  CA  TRP A 122       3.389  21.433   7.382  1.00  0.00           C  
ATOM   1814  C   TRP A 122       3.220  22.956   7.457  1.00  0.00           C  
ATOM   1815  O   TRP A 122       4.058  23.635   8.057  1.00  0.00           O  
ATOM   1816  CB  TRP A 122       2.538  20.678   8.412  1.00  0.00           C  
ATOM   1817  CG  TRP A 122       1.065  20.886   8.348  1.00  0.00           C  
ATOM   1818  CD1 TRP A 122       0.390  21.867   8.979  1.00  0.00           C  
ATOM   1819  CD2 TRP A 122       0.056  20.077   7.683  1.00  0.00           C  
ATOM   1820  NE1 TRP A 122      -0.957  21.729   8.739  1.00  0.00           N  
ATOM   1821  CE2 TRP A 122      -1.223  20.645   7.933  1.00  0.00           C  
ATOM   1822  CE3 TRP A 122       0.095  18.920   6.888  1.00  0.00           C  
ATOM   1823  CZ2 TRP A 122      -2.395  20.094   7.396  1.00  0.00           C  
ATOM   1824  CZ3 TRP A 122      -1.074  18.341   6.373  1.00  0.00           C  
ATOM   1825  CH2 TRP A 122      -2.324  18.926   6.621  1.00  0.00           C  
ATOM   1826  H   TRP A 122       5.311  21.693   8.207  1.00  0.00           H  
ATOM   1827  HA  TRP A 122       3.142  21.121   6.366  1.00  0.00           H  
ATOM   1828  HB2 TRP A 122       2.721  19.606   8.303  1.00  0.00           H  
ATOM   1829  HB3 TRP A 122       2.872  20.959   9.409  1.00  0.00           H  
ATOM   1830  HD1 TRP A 122       0.839  22.626   9.600  1.00  0.00           H  
ATOM   1831  HE1 TRP A 122      -1.633  22.315   9.223  1.00  0.00           H  
ATOM   1832  HE3 TRP A 122       1.049  18.489   6.653  1.00  0.00           H  
ATOM   1833  HZ2 TRP A 122      -3.339  20.563   7.575  1.00  0.00           H  
ATOM   1834  HZ3 TRP A 122      -0.997  17.448   5.773  1.00  0.00           H  
ATOM   1835  HH2 TRP A 122      -3.215  18.477   6.208  1.00  0.00           H  
ATOM   1836  N   ILE A 123       2.170  23.496   6.828  1.00  0.00           N  
ATOM   1837  CA  ILE A 123       1.855  24.931   6.784  1.00  0.00           C  
ATOM   1838  C   ILE A 123       0.640  25.238   7.659  1.00  0.00           C  
ATOM   1839  O   ILE A 123      -0.510  25.211   7.207  1.00  0.00           O  
ATOM   1840  CB  ILE A 123       1.677  25.494   5.349  1.00  0.00           C  
ATOM   1841  CG1 ILE A 123       2.648  24.840   4.368  1.00  0.00           C  
ATOM   1842  CG2 ILE A 123       1.930  27.003   5.388  1.00  0.00           C  
ATOM   1843  CD1 ILE A 123       2.672  25.287   2.925  1.00  0.00           C  
ATOM   1844  H   ILE A 123       1.522  22.875   6.345  1.00  0.00           H  
ATOM   1845  HA  ILE A 123       2.705  25.458   7.213  1.00  0.00           H  
ATOM   1846  HB  ILE A 123       0.662  25.307   4.995  1.00  0.00           H  
ATOM   1847 HG12 ILE A 123       3.671  24.905   4.749  1.00  0.00           H  
ATOM   1848 HG13 ILE A 123       2.315  23.813   4.303  1.00  0.00           H  
ATOM   1849 HG21 ILE A 123       1.733  27.436   4.409  1.00  0.00           H  
ATOM   1850 HG22 ILE A 123       1.269  27.463   6.120  1.00  0.00           H  
ATOM   1851 HG23 ILE A 123       2.970  27.176   5.669  1.00  0.00           H  
ATOM   1852 HD11 ILE A 123       1.679  25.147   2.508  1.00  0.00           H  
ATOM   1853 HD12 ILE A 123       3.002  26.319   2.843  1.00  0.00           H  
ATOM   1854 HD13 ILE A 123       3.388  24.628   2.431  1.00  0.00           H  
ATOM   1855  N   GLU A 124       0.886  25.502   8.935  1.00  0.00           N  
ATOM   1856  CA  GLU A 124      -0.137  25.843   9.904  1.00  0.00           C  
ATOM   1857  C   GLU A 124      -0.665  27.256   9.612  1.00  0.00           C  
ATOM   1858  O   GLU A 124       0.009  28.063   8.954  1.00  0.00           O  
ATOM   1859  CB  GLU A 124       0.453  25.758  11.320  1.00  0.00           C  
ATOM   1860  CG  GLU A 124       0.660  24.298  11.747  1.00  0.00           C  
ATOM   1861  CD  GLU A 124       0.695  24.190  13.267  1.00  0.00           C  
ATOM   1862  OE1 GLU A 124       1.663  24.679  13.885  1.00  0.00           O  
ATOM   1863  OE2 GLU A 124      -0.291  23.692  13.857  1.00  0.00           O  
ATOM   1864  H   GLU A 124       1.852  25.523   9.250  1.00  0.00           H  
ATOM   1865  HA  GLU A 124      -0.965  25.143   9.824  1.00  0.00           H  
ATOM   1866  HB2 GLU A 124       1.402  26.297  11.368  1.00  0.00           H  
ATOM   1867  HB3 GLU A 124      -0.233  26.233  12.021  1.00  0.00           H  
ATOM   1868  HG2 GLU A 124      -0.164  23.684  11.373  1.00  0.00           H  
ATOM   1869  HG3 GLU A 124       1.592  23.919  11.324  1.00  0.00           H  
ATOM   1870  N   PRO A 125      -1.895  27.560  10.050  1.00  0.00           N  
ATOM   1871  CA  PRO A 125      -2.522  28.857   9.881  1.00  0.00           C  
ATOM   1872  C   PRO A 125      -1.998  29.814  10.965  1.00  0.00           C  
ATOM   1873  O   PRO A 125      -1.057  29.500  11.705  1.00  0.00           O  
ATOM   1874  CB  PRO A 125      -4.023  28.573  10.006  1.00  0.00           C  
ATOM   1875  CG  PRO A 125      -4.095  27.387  10.964  1.00  0.00           C  
ATOM   1876  CD  PRO A 125      -2.763  26.676  10.807  1.00  0.00           C  
ATOM   1877  HA  PRO A 125      -2.297  29.271   8.899  1.00  0.00           H  
ATOM   1878  HB2 PRO A 125      -4.598  29.424  10.375  1.00  0.00           H  
ATOM   1879  HB3 PRO A 125      -4.405  28.259   9.034  1.00  0.00           H  
ATOM   1880  HG2 PRO A 125      -4.192  27.707  11.995  1.00  0.00           H  
ATOM   1881  HG3 PRO A 125      -4.915  26.728  10.684  1.00  0.00           H  
ATOM   1882  HD2 PRO A 125      -2.335  26.445  11.781  1.00  0.00           H  
ATOM   1883  HD3 PRO A 125      -2.927  25.764  10.253  1.00  0.00           H  
ATOM   1884  N   LYS A 126      -2.572  31.017  11.037  1.00  0.00           N  
ATOM   1885  CA  LYS A 126      -2.180  32.007  12.031  1.00  0.00           C  
ATOM   1886  C   LYS A 126      -2.610  31.525  13.411  1.00  0.00           C  
ATOM   1887  O   LYS A 126      -3.792  31.527  13.759  1.00  0.00           O  
ATOM   1888  CB  LYS A 126      -2.777  33.380  11.722  1.00  0.00           C  
ATOM   1889  CG  LYS A 126      -2.046  34.026  10.537  1.00  0.00           C  
ATOM   1890  CD  LYS A 126      -2.488  35.476  10.348  1.00  0.00           C  
ATOM   1891  CE  LYS A 126      -3.894  35.524   9.748  1.00  0.00           C  
ATOM   1892  NZ  LYS A 126      -4.552  36.808  10.028  1.00  0.00           N  
ATOM   1893  H   LYS A 126      -3.342  31.233  10.413  1.00  0.00           H  
ATOM   1894  HA  LYS A 126      -1.093  32.096  12.021  1.00  0.00           H  
ATOM   1895  HB2 LYS A 126      -3.842  33.281  11.514  1.00  0.00           H  
ATOM   1896  HB3 LYS A 126      -2.652  34.015  12.600  1.00  0.00           H  
ATOM   1897  HG2 LYS A 126      -0.976  34.015  10.732  1.00  0.00           H  
ATOM   1898  HG3 LYS A 126      -2.234  33.458   9.626  1.00  0.00           H  
ATOM   1899  HD2 LYS A 126      -2.461  35.985  11.313  1.00  0.00           H  
ATOM   1900  HD3 LYS A 126      -1.796  35.981   9.674  1.00  0.00           H  
ATOM   1901  HE2 LYS A 126      -3.838  35.359   8.672  1.00  0.00           H  
ATOM   1902  HE3 LYS A 126      -4.504  34.735  10.193  1.00  0.00           H  
ATOM   1903  HZ1 LYS A 126      -3.972  37.597   9.760  1.00  0.00           H  
ATOM   1904  HZ2 LYS A 126      -4.712  36.875  11.029  1.00  0.00           H  
ATOM   1905  HZ3 LYS A 126      -5.449  36.855   9.567  1.00  0.00           H  
ATOM   1906  N   LYS A 127      -1.646  31.037  14.181  1.00  0.00           N  
ATOM   1907  CA  LYS A 127      -1.896  30.564  15.532  1.00  0.00           C  
ATOM   1908  C   LYS A 127      -2.009  31.779  16.442  1.00  0.00           C  
ATOM   1909  O   LYS A 127      -1.532  32.864  16.097  1.00  0.00           O  
ATOM   1910  CB  LYS A 127      -0.754  29.645  15.973  1.00  0.00           C  
ATOM   1911  CG  LYS A 127      -0.875  28.282  15.284  1.00  0.00           C  
ATOM   1912  CD  LYS A 127       0.445  27.516  15.210  1.00  0.00           C  
ATOM   1913  CE  LYS A 127       1.015  27.000  16.541  1.00  0.00           C  
ATOM   1914  NZ  LYS A 127       1.763  28.032  17.298  1.00  0.00           N  
ATOM   1915  H   LYS A 127      -0.701  31.062  13.834  1.00  0.00           H  
ATOM   1916  HA  LYS A 127      -2.835  30.016  15.558  1.00  0.00           H  
ATOM   1917  HB2 LYS A 127       0.202  30.117  15.736  1.00  0.00           H  
ATOM   1918  HB3 LYS A 127      -0.816  29.485  17.047  1.00  0.00           H  
ATOM   1919  HG2 LYS A 127      -1.618  27.689  15.813  1.00  0.00           H  
ATOM   1920  HG3 LYS A 127      -1.224  28.415  14.260  1.00  0.00           H  
ATOM   1921  HD2 LYS A 127       0.266  26.653  14.574  1.00  0.00           H  
ATOM   1922  HD3 LYS A 127       1.175  28.131  14.696  1.00  0.00           H  
ATOM   1923  HE2 LYS A 127       0.207  26.588  17.149  1.00  0.00           H  
ATOM   1924  HE3 LYS A 127       1.700  26.181  16.305  1.00  0.00           H  
ATOM   1925  HZ1 LYS A 127       2.446  28.481  16.697  1.00  0.00           H  
ATOM   1926  HZ2 LYS A 127       2.276  27.622  18.067  1.00  0.00           H  
ATOM   1927  HZ3 LYS A 127       1.145  28.717  17.726  1.00  0.00           H  
ATOM   1928  N   THR A 128      -2.582  31.576  17.617  1.00  0.00           N  
ATOM   1929  CA  THR A 128      -2.755  32.611  18.617  1.00  0.00           C  
ATOM   1930  C   THR A 128      -2.225  32.016  19.922  1.00  0.00           C  
ATOM   1931  O   THR A 128      -2.225  30.794  20.108  1.00  0.00           O  
ATOM   1932  CB  THR A 128      -4.238  33.037  18.680  1.00  0.00           C  
ATOM   1933  OG1 THR A 128      -4.776  33.197  17.377  1.00  0.00           O  
ATOM   1934  CG2 THR A 128      -4.441  34.363  19.419  1.00  0.00           C  
ATOM   1935  H   THR A 128      -2.957  30.673  17.866  1.00  0.00           H  
ATOM   1936  HA  THR A 128      -2.150  33.478  18.349  1.00  0.00           H  
ATOM   1937  HB  THR A 128      -4.801  32.266  19.201  1.00  0.00           H  
ATOM   1938  HG1 THR A 128      -5.757  33.163  17.470  1.00  0.00           H  
ATOM   1939 HG21 THR A 128      -5.504  34.607  19.445  1.00  0.00           H  
ATOM   1940 HG22 THR A 128      -3.907  35.163  18.905  1.00  0.00           H  
ATOM   1941 HG23 THR A 128      -4.083  34.282  20.445  1.00  0.00           H  
ATOM   1942  N   SER A 129      -1.700  32.862  20.805  1.00  0.00           N  
ATOM   1943  CA  SER A 129      -1.175  32.443  22.092  1.00  0.00           C  
ATOM   1944  C   SER A 129      -2.400  32.091  22.934  1.00  0.00           C  
ATOM   1945  O   SER A 129      -3.195  32.978  23.254  1.00  0.00           O  
ATOM   1946  CB  SER A 129      -0.329  33.572  22.685  1.00  0.00           C  
ATOM   1947  OG  SER A 129       0.733  33.891  21.789  1.00  0.00           O  
ATOM   1948  H   SER A 129      -1.719  33.856  20.606  1.00  0.00           H  
ATOM   1949  HA  SER A 129      -0.552  31.556  21.965  1.00  0.00           H  
ATOM   1950  HB2 SER A 129      -0.953  34.453  22.838  1.00  0.00           H  
ATOM   1951  HB3 SER A 129       0.081  33.255  23.645  1.00  0.00           H  
ATOM   1952  HG  SER A 129       0.744  34.873  21.706  1.00  0.00           H  
ATOM   1953  N   GLY A 130      -2.592  30.809  23.223  1.00  0.00           N  
ATOM   1954  CA  GLY A 130      -3.707  30.288  23.986  1.00  0.00           C  
ATOM   1955  C   GLY A 130      -3.389  28.860  24.418  1.00  0.00           C  
ATOM   1956  O   GLY A 130      -3.380  27.976  23.554  1.00  0.00           O  
ATOM   1957  H   GLY A 130      -1.903  30.118  22.941  1.00  0.00           H  
ATOM   1958  HA2 GLY A 130      -3.919  30.935  24.835  1.00  0.00           H  
ATOM   1959  HA3 GLY A 130      -4.582  30.261  23.339  1.00  0.00           H  
ATOM   1960  N   PRO A 131      -3.061  28.620  25.699  1.00  0.00           N  
ATOM   1961  CA  PRO A 131      -2.760  27.285  26.197  1.00  0.00           C  
ATOM   1962  C   PRO A 131      -4.065  26.488  26.355  1.00  0.00           C  
ATOM   1963  O   PRO A 131      -5.157  27.064  26.400  1.00  0.00           O  
ATOM   1964  CB  PRO A 131      -2.079  27.529  27.546  1.00  0.00           C  
ATOM   1965  CG  PRO A 131      -2.781  28.781  28.066  1.00  0.00           C  
ATOM   1966  CD  PRO A 131      -3.029  29.587  26.791  1.00  0.00           C  
ATOM   1967  HA  PRO A 131      -2.082  26.764  25.521  1.00  0.00           H  
ATOM   1968  HB2 PRO A 131      -2.184  26.685  28.231  1.00  0.00           H  
ATOM   1969  HB3 PRO A 131      -1.027  27.759  27.383  1.00  0.00           H  
ATOM   1970  HG2 PRO A 131      -3.734  28.507  28.522  1.00  0.00           H  
ATOM   1971  HG3 PRO A 131      -2.159  29.328  28.777  1.00  0.00           H  
ATOM   1972  HD2 PRO A 131      -3.975  30.123  26.870  1.00  0.00           H  
ATOM   1973  HD3 PRO A 131      -2.209  30.287  26.627  1.00  0.00           H  
ATOM   1974  N   SER A 132      -3.951  25.168  26.506  1.00  0.00           N  
ATOM   1975  CA  SER A 132      -5.104  24.287  26.668  1.00  0.00           C  
ATOM   1976  C   SER A 132      -4.832  23.070  27.564  1.00  0.00           C  
ATOM   1977  O   SER A 132      -5.737  22.257  27.769  1.00  0.00           O  
ATOM   1978  CB  SER A 132      -5.646  23.908  25.282  1.00  0.00           C  
ATOM   1979  OG  SER A 132      -4.634  23.458  24.395  1.00  0.00           O  
ATOM   1980  H   SER A 132      -3.037  24.740  26.457  1.00  0.00           H  
ATOM   1981  HA  SER A 132      -5.894  24.845  27.173  1.00  0.00           H  
ATOM   1982  HB2 SER A 132      -6.413  23.141  25.386  1.00  0.00           H  
ATOM   1983  HB3 SER A 132      -6.102  24.796  24.844  1.00  0.00           H  
ATOM   1984  HG  SER A 132      -5.081  23.225  23.553  1.00  0.00           H  
ATOM   1985  N   SER A 133      -3.610  22.897  28.079  1.00  0.00           N  
ATOM   1986  CA  SER A 133      -3.288  21.778  28.956  1.00  0.00           C  
ATOM   1987  C   SER A 133      -3.775  22.082  30.387  1.00  0.00           C  
ATOM   1988  O   SER A 133      -4.461  23.067  30.669  1.00  0.00           O  
ATOM   1989  CB  SER A 133      -1.774  21.489  28.891  1.00  0.00           C  
ATOM   1990  OG  SER A 133      -1.469  20.167  29.324  1.00  0.00           O  
ATOM   1991  H   SER A 133      -2.881  23.571  27.898  1.00  0.00           H  
ATOM   1992  HA  SER A 133      -3.816  20.895  28.592  1.00  0.00           H  
ATOM   1993  HB2 SER A 133      -1.441  21.583  27.857  1.00  0.00           H  
ATOM   1994  HB3 SER A 133      -1.226  22.215  29.494  1.00  0.00           H  
ATOM   1995  HG  SER A 133      -1.155  20.192  30.245  1.00  0.00           H  
ATOM   1996  N   GLY A 134      -3.405  21.181  31.283  1.00  0.00           N  
ATOM   1997  CA  GLY A 134      -3.622  21.089  32.710  1.00  0.00           C  
ATOM   1998  C   GLY A 134      -2.826  19.863  33.140  1.00  0.00           C  
ATOM   1999  O   GLY A 134      -3.130  19.278  34.190  1.00  0.00           O  
ATOM   2000  H   GLY A 134      -2.843  20.399  30.970  1.00  0.00           H  
ATOM   2001  HA2 GLY A 134      -3.242  21.977  33.216  1.00  0.00           H  
ATOM   2002  HA3 GLY A 134      -4.680  20.954  32.931  1.00  0.00           H  
TER    2003      GLY A 134                                                      
END
MOLECULE T0389.pdb
ATOM      1  N   MET     1     -12.667  -2.302  -4.836  1.00 55.55           N
ATOM      2  CA  MET     1     -11.589  -1.542  -4.213  1.00 48.91           C
ATOM      3  C   MET     1     -10.667  -2.462  -3.418  1.00 39.03           C
ATOM      4  CB  MET     1     -12.164  -0.437  -3.316  1.00 53.74           C
ATOM      5  CG  MET     1     -11.124   0.477  -2.677  1.00 52.32           C
ATOM      6  SD  MET     1     -10.775   0.077  -0.956  1.00 54.50           S
ATOM      7  CE  MET     1     -12.164   0.851  -0.138  1.00 28.92           C
ATOM      8  O   MET     1     -11.122  -3.259  -2.597  1.00 39.35           O
ATOM      9  N   ILE     2      -9.368  -2.352  -3.675  1.00 32.95           N
ATOM     10  CA  ILE     2      -8.372  -3.158  -2.974  1.00 30.36           C
ATOM     11  C   ILE     2      -8.041  -2.529  -1.625  1.00 33.96           C
ATOM     12  CB  ILE     2      -7.083  -3.290  -3.800  1.00 28.62           C
ATOM     13  CG1 ILE     2      -7.403  -3.853  -5.190  1.00 40.56           C
ATOM     14  CG2 ILE     2      -6.082  -4.163  -3.075  1.00 22.68           C
ATOM     15  CD1 ILE     2      -6.203  -4.036  -6.084  1.00 40.80           C
ATOM     16  O   ILE     2      -8.323  -3.100  -0.574  1.00 30.04           O
ATOM     17  N   GLY     3      -7.450  -1.339  -1.667  1.00 32.32           N
ATOM     18  CA  GLY     3      -7.142  -0.596  -0.462  1.00 22.40           C
ATOM     19  C   GLY     3      -5.764  -0.925   0.066  1.00 28.54           C
ATOM     20  O   GLY     3      -5.538  -1.999   0.621  1.00 31.36           O
ATOM     21  N   THR     4      -4.831  -0.001  -0.113  1.00 29.91           N
ATOM     22  CA  THR     4      -3.493  -0.186   0.417  1.00 28.43           C
ATOM     23  C   THR     4      -3.037   1.082   1.112  1.00 25.62           C
ATOM     24  CB  THR     4      -2.492  -0.584  -0.678  1.00 33.32           C
ATOM     25  OG1 THR     4      -2.581   0.340  -1.765  1.00 41.72           O
ATOM     26  CG2 THR     4      -2.814  -1.976  -1.192  1.00 25.85           C
ATOM     27  O   THR     4      -3.677   2.128   0.997  1.00 20.81           O
ATOM     28  N   GLN     5      -1.937   0.984   1.848  1.00 25.25           N
ATOM     29  CA  GLN     5      -1.455   2.118   2.622  1.00 27.71           C
ATOM     30  C   GLN     5      -0.006   2.443   2.303  1.00 24.41           C
ATOM     31  CB  GLN     5      -1.603   1.867   4.131  1.00 30.89           C
ATOM     32  CG  GLN     5      -3.040   1.710   4.619  1.00 40.66           C
ATOM     33  CD  GLN     5      -3.456   0.258   4.771  1.00 44.87           C
ATOM     34  OE1 GLN     5      -2.697  -0.562   5.287  1.00 59.13           O
ATOM     35  NE2 GLN     5      -4.668  -0.063   4.335  1.00 32.63           N
ATOM     36  O   GLN     5       0.718   1.629   1.722  1.00 26.24           O
ATOM     37  N   ILE     6       0.391   3.651   2.686  1.00 21.74           N
ATOM     38  CA  ILE     6       1.781   4.080   2.665  1.00 26.93           C
ATOM     39  C   ILE     6       2.039   4.804   3.988  1.00 27.71           C
ATOM     40  CB  ILE     6       2.045   5.007   1.464  1.00 23.63           C
ATOM     41  CG1 ILE     6       3.531   5.361   1.368  1.00 23.13           C
ATOM     42  CG2 ILE     6       1.150   6.249   1.533  1.00 14.06           C
ATOM     43  CD1 ILE     6       3.920   6.017   0.047  1.00 15.88           C
ATOM     44  O   ILE     6       1.178   5.546   4.462  1.00 26.43           O
ATOM     45  N   VAL     7       3.190   4.569   4.615  1.00 28.81           N
ATOM     46  CA  VAL     7       3.473   5.258   5.874  1.00 27.28           C
ATOM     47  C   VAL     7       4.177   6.586   5.632  1.00 27.58           C
ATOM     48  CB  VAL     7       4.276   4.396   6.883  1.00 24.61           C
ATOM     49  CG1 VAL     7       3.589   3.057   7.105  1.00 23.84           C
ATOM     50  CG2 VAL     7       5.722   4.211   6.424  1.00 17.37           C
ATOM     51  O   VAL     7       4.771   6.805   4.574  1.00 31.93           O
ATOM     52  N   THR     8       4.095   7.468   6.622  1.00 25.79           N
ATOM     53  CA  THR     8       4.656   8.812   6.540  1.00 18.76           C
ATOM     54  C   THR     8       6.079   8.829   5.980  1.00 24.70           C
ATOM     55  CB  THR     8       4.626   9.492   7.924  1.00 32.05           C
ATOM     56  OG1 THR     8       3.268   9.629   8.357  1.00 35.84           O
ATOM     57  CG2 THR     8       5.259  10.861   7.865  1.00 41.25           C
ATOM     58  O   THR     8       6.363   9.530   5.010  1.00 27.45           O
ATOM     59  N   GLU     9       6.971   8.058   6.593  1.00 26.50           N
ATOM     60  CA  GLU     9       8.360   7.994   6.152  1.00 28.73           C
ATOM     61  C   GLU     9       8.492   7.664   4.671  1.00 31.92           C
ATOM     62  CB  GLU     9       9.141   6.960   6.967  1.00 36.59           C
ATOM     63  CG  GLU     9       9.497   7.401   8.372  1.00 49.60           C
ATOM     64  CD  GLU     9      10.430   6.420   9.050  1.00 64.99           C
ATOM     65  OE1 GLU     9      10.333   6.254  10.285  1.00 70.43           O
ATOM     66  OE2 GLU     9      11.257   5.807   8.340  1.00 71.66           O
ATOM     67  O   GLU     9       9.344   8.222   3.975  1.00 37.29           O
ATOM     68  N   ARG    10       7.666   6.740   4.194  1.00 27.84           N
ATOM     69  CA  ARG    10       7.731   6.326   2.796  1.00 30.93           C
ATOM     70  C   ARG    10       7.116   7.362   1.843  1.00 36.13           C
ATOM     71  CB  ARG    10       7.096   4.948   2.608  1.00 31.11           C
ATOM     72  CG  ARG    10       7.797   3.848   3.390  1.00 32.70           C
ATOM     73  CD  ARG    10       9.312   3.937   3.233  1.00 28.58           C
ATOM     74  NE  ARG    10       9.748   3.693   1.861  1.00 28.21           N
ATOM     75  CZ  ARG    10      10.905   4.115   1.357  1.00 34.98           C
ATOM     76  NH1 ARG    10      11.219   3.853   0.095  1.00 39.15           N
ATOM     77  NH2 ARG    10      11.749   4.810   2.110  1.00 32.83           N
ATOM     78  O   ARG    10       7.559   7.499   0.700  1.00 30.64           O
ATOM     79  N   LEU    11       6.104   8.093   2.310  1.00 29.78           N
ATOM     80  CA  LEU    11       5.545   9.187   1.518  1.00 23.47           C
ATOM     81  C   LEU    11       6.600  10.268   1.311  1.00 31.97           C
ATOM     82  CB  LEU    11       4.315   9.789   2.202  1.00 20.62           C
ATOM     83  CG  LEU    11       3.738  11.063   1.572  1.00 19.29           C
ATOM     84  CD1 LEU    11       3.365  10.846   0.103  1.00 20.17           C
ATOM     85  CD2 LEU    11       2.535  11.556   2.363  1.00 20.79           C
ATOM     86  O   LEU    11       6.774  10.788   0.209  1.00 33.78           O
ATOM     87  N   VAL    12       7.304  10.605   2.384  1.00 36.47           N
ATOM     88  CA  VAL    12       8.350  11.617   2.319  1.00 35.64           C
ATOM     89  C   VAL    12       9.499  11.145   1.431  1.00 31.72           C
ATOM     90  CB  VAL    12       8.861  11.981   3.725  1.00 34.77           C
ATOM     91  CG1 VAL    12      10.043  12.914   3.631  1.00 27.99           C
ATOM     92  CG2 VAL    12       7.740  12.616   4.539  1.00 33.81           C
ATOM     93  O   VAL    12      10.086  11.932   0.685  1.00 34.55           O
ATOM     94  N   ALA    13       9.812   9.855   1.507  1.00 32.57           N
ATOM     95  CA  ALA    13      10.798   9.258   0.611  1.00 33.94           C
ATOM     96  CB  ALA    13      10.978   7.789   0.927  1.00 28.20           C
ATOM     97  C   ALA    13      10.341   9.432  -0.829  1.00 35.69           C
ATOM     98  O   ALA    13      11.142   9.699  -1.722  1.00 39.08           O
ATOM     99  N   LEU    14       9.038   9.281  -1.035  1.00 38.07           N
ATOM    100  CA  LEU    14       8.427   9.402  -2.353  1.00 41.39           C
ATOM    101  C   LEU    14       8.460  10.838  -2.853  1.00 46.48           C
ATOM    102  CB  LEU    14       6.978   8.914  -2.305  1.00 34.61           C
ATOM    103  CG  LEU    14       6.193   8.940  -3.612  1.00 29.09           C
ATOM    104  CD1 LEU    14       6.848   8.053  -4.660  1.00 30.96           C
ATOM    105  CD2 LEU    14       4.778   8.493  -3.351  1.00 29.73           C
ATOM    106  O   LEU    14       8.775  11.095  -4.015  1.00 52.43           O
ATOM    107  N   LEU    15       8.119  11.771  -1.972  1.00 41.37           N
ATOM    108  CA  LEU    15       8.124  13.181  -2.326  1.00 36.74           C
ATOM    109  C   LEU    15       9.536  13.666  -2.628  1.00 36.74           C
ATOM    110  CB  LEU    15       7.486  14.022  -1.217  1.00 31.50           C
ATOM    111  CG  LEU    15       5.963  13.936  -1.119  1.00 32.92           C
ATOM    112  CD1 LEU    15       5.468  14.531   0.188  1.00 34.02           C
ATOM    113  CD2 LEU    15       5.310  14.624  -2.312  1.00 35.86           C
ATOM    114  O   LEU    15       9.742  14.407  -3.583  1.00 44.67           O
ATOM    115  N   GLU    16      10.506  13.235  -1.824  1.00 43.81           N
ATOM    116  CA  GLU    16      11.891  13.695  -1.968  1.00 47.85           C
ATOM    117  C   GLU    16      12.610  13.199  -3.221  1.00 58.37           C
ATOM    118  CB  GLU    16      12.712  13.346  -0.728  1.00 41.05           C
ATOM    119  CG  GLU    16      12.933  14.525   0.190  1.00 50.25           C
ATOM    120  CD  GLU    16      13.825  14.185   1.356  1.00 65.46           C
ATOM    121  OE1 GLU    16      13.853  12.997   1.744  1.00 69.66           O
ATOM    122  OE2 GLU    16      14.492  15.101   1.886  1.00 71.48           O
ATOM    123  O   GLU    16      13.700  13.671  -3.545  1.00 66.22           O
ATOM    124  N   SER    17      12.005  12.249  -3.922  1.00 63.43           N
ATOM    125  CA  SER    17      12.617  11.687  -5.118  1.00 63.80           C
ATOM    126  C   SER    17      11.997  12.278  -6.373  1.00 72.15           C
ATOM    127  CB  SER    17      12.462  10.164  -5.144  1.00 58.09           C
ATOM    128  OG  SER    17      11.170   9.787  -5.598  1.00 50.16           O
ATOM    129  O   SER    17      10.788  12.521  -6.434  1.00 66.74           O
ATOM    130  N   GLY    18      12.835  12.512  -7.374  1.00 83.22           N
ATOM    131  CA  GLY    18      12.354  12.915  -8.678  1.00 89.19           C
ATOM    132  C   GLY    18      11.966  11.670  -9.443  1.00 93.43           C
ATOM    133  O   GLY    18      11.991  11.647 -10.671  1.00100.51           O
ATOM    134  N   THR    19      11.610  10.627  -8.699  1.00 90.42           N
ATOM    135  CA  THR    19      11.266   9.331  -9.272  1.00 86.37           C
ATOM    136  C   THR    19       9.834   9.297  -9.796  1.00 83.10           C
ATOM    137  CB  THR    19      11.425   8.214  -8.229  1.00 84.81           C
ATOM    138  OG1 THR    19      12.783   8.176  -7.773  1.00 87.60           O
ATOM    139  CG2 THR    19      11.048   6.864  -8.823  1.00 83.70           C
ATOM    140  O   THR    19       9.580   8.869 -10.926  1.00 75.59           O
ATOM    141  N   GLU    20       8.901   9.749  -8.964  1.00 81.85           N
ATOM    142  CA  GLU    20       7.489   9.698  -9.307  1.00 75.24           C
ATOM    143  C   GLU    20       6.802  11.037  -9.056  1.00 68.06           C
ATOM    144  CB  GLU    20       6.794   8.590  -8.506  1.00 77.31           C
ATOM    145  CG  GLU    20       7.364   7.191  -8.732  1.00 78.54           C
ATOM    146  CD  GLU    20       6.812   6.520  -9.979  1.00 82.72           C
ATOM    147  OE1 GLU    20       5.853   7.055 -10.579  1.00 84.74           O
ATOM    148  OE2 GLU    20       7.331   5.448 -10.353  1.00 84.11           O
ATOM    149  O   GLU    20       7.222  11.808  -8.189  1.00 73.59           O
ATOM    150  N   LYS    21       5.753  11.306  -9.830  1.00 58.21           N
ATOM    151  CA  LYS    21       4.899  12.470  -9.614  1.00 51.59           C
ATOM    152  C   LYS    21       3.724  12.082  -8.718  1.00 41.64           C
ATOM    153  CB  LYS    21       4.406  13.042 -10.949  1.00 59.84           C
ATOM    154  CG  LYS    21       3.188  13.961 -10.842  1.00 73.25           C
ATOM    155  CD  LYS    21       3.407  15.113  -9.862  1.00 80.49           C
ATOM    156  CE  LYS    21       2.083  15.785  -9.492  1.00 77.21           C
ATOM    157  NZ  LYS    21       2.217  16.767  -8.373  1.00 73.38           N
ATOM    158  O   LYS    21       3.002  11.126  -8.995  1.00 40.62           O
ATOM    159  N   VAL    22       3.547  12.827  -7.634  1.00 34.84           N
ATOM    160  CA  VAL    22       2.559  12.483  -6.630  1.00 32.92           C
ATOM    161  CB  VAL    22       3.178  12.499  -5.223  1.00 33.83           C
ATOM    162  CG1 VAL    22       2.158  12.050  -4.189  1.00 32.39           C
ATOM    163  CG2 VAL    22       4.408  11.616  -5.181  1.00 29.83           C
ATOM    164  C   VAL    22       1.376  13.436  -6.637  1.00 35.42           C
ATOM    165  O   VAL    22       1.540  14.654  -6.733  1.00 32.38           O
ATOM    166  N   LEU    23       0.180  12.868  -6.539  1.00 29.16           N
ATOM    167  CA  LEU    23      -1.019  13.649  -6.315  1.00 22.29           C
ATOM    168  CB  LEU    23      -2.137  13.202  -7.248  1.00 24.35           C
ATOM    169  CG  LEU    23      -3.434  13.983  -7.039  1.00 28.17           C
ATOM    170  CD1 LEU    23      -3.195  15.456  -7.311  1.00 33.44           C
ATOM    171  CD2 LEU    23      -4.536  13.448  -7.925  1.00 26.20           C
ATOM    172  C   LEU    23      -1.438  13.457  -4.861  1.00 34.22           C
ATOM    173  O   LEU    23      -1.862  12.369  -4.474  1.00 38.14           O
ATOM    174  N   LEU    24      -1.299  14.514  -4.062  1.00 32.70           N
ATOM    175  CA  LEU    24      -1.611  14.484  -2.634  1.00 26.80           C
ATOM    176  CB  LEU    24      -0.582  15.331  -1.886  1.00 35.00           C
ATOM    177  CG  LEU    24      -0.148  15.018  -0.457  1.00 32.33           C
ATOM    178  CD1 LEU    24       0.273  13.578  -0.346  1.00 30.91           C
ATOM    179  CD2 LEU    24       1.003  15.943  -0.066  1.00 27.96           C
ATOM    180  C   LEU    24      -3.016  15.044  -2.403  1.00 31.48           C
ATOM    181  O   LEU    24      -3.297  16.178  -2.790  1.00 34.33           O
ATOM    182  N   ILE    25      -3.891  14.253  -1.777  1.00 32.49           N
ATOM    183  CA  ILE    25      -5.294  14.631  -1.567  1.00 26.03           C
ATOM    184  CB  ILE    25      -6.252  13.685  -2.331  1.00 24.67           C
ATOM    185  CG1 ILE    25      -6.097  13.880  -3.839  1.00 24.12           C
ATOM    186  CD1 ILE    25      -6.742  12.797  -4.655  1.00 30.90           C
ATOM    187  CG2 ILE    25      -7.705  13.907  -1.899  1.00 24.27           C
ATOM    188  C   ILE    25      -5.692  14.630  -0.094  1.00 29.64           C
ATOM    189  O   ILE    25      -5.531  13.627   0.597  1.00 37.44           O
ATOM    190  N   ASP    26      -6.215  15.760   0.371  1.00 29.68           N
ATOM    191  CA  ASP    26      -6.656  15.925   1.753  1.00 24.45           C
ATOM    192  CB  ASP    26      -6.211  17.295   2.279  1.00 30.07           C
ATOM    193  CG  ASP    26      -6.509  17.493   3.762  1.00 35.56           C
ATOM    194  OD1 ASP    26      -7.443  16.853   4.288  1.00 36.46           O
ATOM    195  OD2 ASP    26      -5.804  18.303   4.404  1.00 36.73           O
ATOM    196  C   ASP    26      -8.172  15.818   1.770  1.00 28.11           C
ATOM    197  O   ASP    26      -8.863  16.668   1.213  1.00 39.19           O
ATOM    198  N   SER    27      -8.691  14.773   2.404  1.00 26.21           N
ATOM    199  CA  SER    27     -10.122  14.491   2.344  1.00 30.84           C
ATOM    200  CB  SER    27     -10.362  12.995   2.144  1.00 29.15           C
ATOM    201  OG  SER    27      -9.935  12.266   3.282  1.00 32.12           O
ATOM    202  C   SER    27     -10.868  14.958   3.584  1.00 38.49           C
ATOM    203  O   SER    27     -11.964  14.477   3.869  1.00 51.88           O
ATOM    204  N   ARG    28     -10.277  15.888   4.323  1.00 33.93           N
ATOM    205  CA  ARG    28     -10.906  16.408   5.529  1.00 28.78           C
ATOM    206  CB  ARG    28      -9.846  16.751   6.568  1.00 24.59           C
ATOM    207  CG  ARG    28      -8.951  15.601   6.952  1.00 22.07           C
ATOM    208  CD  ARG    28      -7.786  16.128   7.764  1.00 31.07           C
ATOM    209  NE  ARG    28      -7.133  17.248   7.092  1.00 34.53           N
ATOM    210  CZ  ARG    28      -6.299  18.092   7.689  1.00 30.99           C
ATOM    211  NH1 ARG    28      -5.748  19.083   7.000  1.00 26.34           N
ATOM    212  NH2 ARG    28      -6.024  17.949   8.978  1.00 26.99           N
ATOM    213  C   ARG    28     -11.716  17.653   5.208  1.00 37.19           C
ATOM    214  O   ARG    28     -11.609  18.197   4.110  1.00 39.32           O
ATOM    215  N   PRO    29     -12.541  18.105   6.168  1.00 42.94           N
ATOM    216  CA  PRO    29     -13.241  19.391   6.066  1.00 45.51           C
ATOM    217  CB  PRO    29     -13.932  19.512   7.424  1.00 43.05           C
ATOM    218  CG  PRO    29     -14.140  18.106   7.856  1.00 37.04           C
ATOM    219  CD  PRO    29     -12.935  17.360   7.377  1.00 37.00           C
ATOM    220  C   PRO    29     -12.264  20.554   5.862  1.00 52.51           C
ATOM    221  O   PRO    29     -11.130  20.520   6.368  1.00 40.37           O
ATOM    222  N   PHE    30     -12.716  21.574   5.134  1.00 59.85           N
ATOM    223  CA  PHE    30     -11.850  22.671   4.693  1.00 63.12           C
ATOM    224  CB  PHE    30     -12.592  23.583   3.710  1.00 70.28           C
ATOM    225  CG  PHE    30     -13.681  24.401   4.344  1.00 83.28           C
ATOM    226  CD1 PHE    30     -13.490  25.750   4.603  1.00 87.85           C
ATOM    227  CE1 PHE    30     -14.490  26.509   5.189  1.00 90.43           C
ATOM    228  CZ  PHE    30     -15.696  25.921   5.524  1.00 93.98           C
ATOM    229  CE2 PHE    30     -15.899  24.576   5.272  1.00 94.92           C
ATOM    230  CD2 PHE    30     -14.895  23.823   4.686  1.00 89.84           C
ATOM    231  C   PHE    30     -11.235  23.499   5.826  1.00 54.89           C
ATOM    232  O   PHE    30     -10.140  24.036   5.678  1.00 53.57           O
ATOM    233  N   VAL    31     -11.935  23.614   6.949  1.00 49.26           N
ATOM    234  CA  VAL    31     -11.399  24.359   8.080  1.00 45.90           C
ATOM    235  CB  VAL    31     -12.383  24.412   9.250  1.00 44.22           C
ATOM    236  CG1 VAL    31     -11.872  25.376  10.309  1.00 49.72           C
ATOM    237  CG2 VAL    31     -13.758  24.824   8.767  1.00 46.00           C
ATOM    238  C   VAL    31     -10.111  23.706   8.553  1.00 47.30           C
ATOM    239  O   VAL    31      -9.142  24.387   8.882  1.00 49.53           O
ATOM    240  N   GLU    32     -10.113  22.377   8.585  1.00 48.26           N
ATOM    241  CA  GLU    32      -8.927  21.615   8.941  1.00 46.25           C
ATOM    242  CB  GLU    32      -9.251  20.127   9.001  1.00 45.40           C
ATOM    243  CG  GLU    32     -10.257  19.756  10.068  1.00 53.40           C
ATOM    244  CD  GLU    32     -10.411  18.258  10.211  1.00 67.62           C
ATOM    245  OE1 GLU    32      -9.380  17.564  10.336  1.00 74.98           O
ATOM    246  OE2 GLU    32     -11.561  17.773  10.199  1.00 72.48           O
ATOM    247  C   GLU    32      -7.837  21.856   7.913  1.00 45.03           C
ATOM    248  O   GLU    32      -6.712  22.221   8.257  1.00 43.27           O
ATOM    249  N   TYR    33      -8.181  21.644   6.647  1.00 41.98           N
ATOM    250  CA  TYR    33      -7.246  21.862   5.551  1.00 42.07           C
ATOM    251  CB  TYR    33      -7.939  21.628   4.206  1.00 41.75           C
ATOM    252  CG  TYR    33      -7.124  22.051   3.001  1.00 46.31           C
ATOM    253  CD1 TYR    33      -6.028  21.311   2.587  1.00 46.83           C
ATOM    254  CE1 TYR    33      -5.284  21.692   1.487  1.00 47.88           C
ATOM    255  CZ  TYR    33      -5.634  22.821   0.780  1.00 45.75           C
ATOM    256  OH  TYR    33      -4.886  23.194  -0.314  1.00 49.06           O
ATOM    257  CE2 TYR    33      -6.722  23.571   1.165  1.00 43.19           C
ATOM    258  CD2 TYR    33      -7.461  23.185   2.269  1.00 45.94           C
ATOM    259  C   TYR    33      -6.643  23.264   5.616  1.00 39.90           C
ATOM    260  O   TYR    33      -5.429  23.416   5.724  1.00 35.50           O
ATOM    261  N   ASN    34      -7.498  24.283   5.567  1.00 41.06           N
ATOM    262  CA  ASN    34      -7.050  25.671   5.610  1.00 44.50           C
ATOM    263  CB  ASN    34      -8.239  26.629   5.529  1.00 48.47           C
ATOM    264  CG  ASN    34      -8.921  26.596   4.175  1.00 65.44           C
ATOM    265  OD1 ASN    34      -8.309  26.239   3.166  1.00 71.56           O
ATOM    266  ND2 ASN    34     -10.195  26.970   4.144  1.00 71.13           N
ATOM    267  C   ASN    34      -6.226  25.965   6.853  1.00 51.02           C
ATOM    268  O   ASN    34      -5.295  26.771   6.815  1.00 53.72           O
ATOM    269  N   THR    35      -6.572  25.303   7.952  1.00 52.53           N
ATOM    270  CA  THR    35      -5.828  25.448   9.198  1.00 55.06           C
ATOM    271  CB  THR    35      -6.522  24.708  10.352  1.00 48.81           C
ATOM    272  OG1 THR    35      -7.653  25.470  10.792  1.00 50.83           O
ATOM    273  CG2 THR    35      -5.569  24.519  11.513  1.00 46.15           C
ATOM    274  C   THR    35      -4.397  24.935   9.047  1.00 58.99           C
ATOM    275  O   THR    35      -3.436  25.617   9.409  1.00 59.86           O
ATOM    276  N   SER    36      -4.266  23.728   8.508  1.00 57.80           N
ATOM    277  CA  SER    36      -2.962  23.130   8.255  1.00 44.32           C
ATOM    278  CB  SER    36      -2.239  22.839   9.569  1.00 41.58           C
ATOM    279  OG  SER    36      -0.905  22.417   9.343  1.00 42.17           O
ATOM    280  C   SER    36      -3.125  21.849   7.450  1.00 41.50           C
ATOM    281  O   SER    36      -4.073  21.089   7.648  1.00 41.29           O
ATOM    282  N   HIS    37      -2.199  21.617   6.533  1.00 39.31           N
ATOM    283  CA  HIS    37      -2.235  20.422   5.711  1.00 36.95           C
ATOM    284  CB  HIS    37      -3.221  20.597   4.557  1.00 37.03           C
ATOM    285  CG  HIS    37      -2.976  21.820   3.727  1.00 40.92           C
ATOM    286  ND1 HIS    37      -3.591  23.028   3.980  1.00 42.94           N
ATOM    287  CE1 HIS    37      -3.196  23.918   3.089  1.00 42.20           C
ATOM    288  NE2 HIS    37      -2.347  23.333   2.262  1.00 39.83           N
ATOM    289  CD2 HIS    37      -2.193  22.020   2.640  1.00 40.89           C
ATOM    290  C   HIS    37      -0.843  20.141   5.180  1.00 37.63           C
ATOM    291  O   HIS    37       0.064  20.947   5.354  1.00 36.89           O
ATOM    292  N   ILE    38      -0.671  18.994   4.539  1.00 41.55           N
ATOM    293  CA  ILE    38       0.616  18.639   3.958  1.00 37.60           C
ATOM    294  CB  ILE    38       0.675  17.134   3.639  1.00 30.71           C
ATOM    295  CG1 ILE    38       0.259  16.325   4.874  1.00 27.77           C
ATOM    296  CD1 ILE    38       0.168  14.832   4.637  1.00 22.41           C
ATOM    297  CG2 ILE    38       2.068  16.735   3.159  1.00 25.86           C
ATOM    298  C   ILE    38       0.872  19.480   2.705  1.00 35.63           C
ATOM    299  O   ILE    38      -0.035  19.695   1.901  1.00 32.64           O
ATOM    300  N   LEU    39       2.099  19.967   2.546  1.00 40.56           N
ATOM    301  CA  LEU    39       2.412  20.870   1.436  1.00 48.63           C
ATOM    302  CB  LEU    39       3.922  21.157   1.332  1.00 49.42           C
ATOM    303  CG  LEU    39       4.947  20.017   1.273  1.00 56.26           C
ATOM    304  CD1 LEU    39       4.808  19.181   0.011  1.00 57.74           C
ATOM    305  CD2 LEU    39       6.363  20.577   1.378  1.00 64.17           C
ATOM    306  C   LEU    39       1.857  20.374   0.104  1.00 47.80           C
ATOM    307  O   LEU    39       1.971  19.196  -0.236  1.00 55.06           O
ATOM    308  N   GLU    40       1.241  21.283  -0.639  1.00 45.55           N
ATOM    309  CA  GLU    40       0.723  20.961  -1.960  1.00 52.91           C
ATOM    310  CB  GLU    40       1.867  20.613  -2.918  1.00 61.40           C
ATOM    311  CG  GLU    40       2.642  21.827  -3.418  1.00 81.82           C
ATOM    312  CD  GLU    40       3.678  21.467  -4.467  1.00 94.83           C
ATOM    313  OE1 GLU    40       4.364  20.435  -4.296  1.00 97.63           O
ATOM    314  OE2 GLU    40       3.809  22.218  -5.460  1.00 98.12           O
ATOM    315  C   GLU    40      -0.298  19.832  -1.933  1.00 51.57           C
ATOM    316  O   GLU    40      -0.360  19.028  -2.862  1.00 61.01           O
ATOM    317  N   ALA    41      -1.093  19.763  -0.871  1.00 41.75           N
ATOM    318  CA  ALA    41      -2.187  18.803  -0.832  1.00 33.55           C
ATOM    319  CB  ALA    41      -2.421  18.295   0.577  1.00 30.22           C
ATOM    320  C   ALA    41      -3.436  19.466  -1.379  1.00 35.11           C
ATOM    321  O   ALA    41      -3.708  20.629  -1.081  1.00 33.51           O
ATOM    322  N   ILE    42      -4.180  18.722  -2.193  1.00 34.36           N
ATOM    323  CA  ILE    42      -5.415  19.206  -2.790  1.00 28.06           C
ATOM    324  CB  ILE    42      -5.636  18.595  -4.194  1.00 36.87           C
ATOM    325  CG1 ILE    42      -4.595  19.131  -5.181  1.00 40.30           C
ATOM    326  CD1 ILE    42      -4.813  18.677  -6.612  1.00 45.01           C
ATOM    327  CG2 ILE    42      -7.047  18.878  -4.701  1.00 36.92           C
ATOM    328  C   ILE    42      -6.594  18.864  -1.890  1.00 32.24           C
ATOM    329  O   ILE    42      -6.788  17.710  -1.512  1.00 33.40           O
ATOM    330  N   ASN    43      -7.380  19.872  -1.542  1.00 29.34           N
ATOM    331  CA  ASN    43      -8.510  19.653  -0.667  1.00 25.86           C
ATOM    332  CB  ASN    43      -8.889  20.947   0.044  1.00 33.60           C
ATOM    333  CG  ASN    43      -9.821  20.715   1.216  1.00 34.17           C
ATOM    334  OD1 ASN    43     -10.557  21.611   1.625  1.00 36.36           O
ATOM    335  ND2 ASN    43      -9.795  19.506   1.761  1.00 36.56           N
ATOM    336  C   ASN    43      -9.697  19.109  -1.438  1.00 34.70           C
ATOM    337  O   ASN    43     -10.195  19.753  -2.359  1.00 33.23           O
ATOM    338  N   ILE    44     -10.137  17.911  -1.072  1.00 41.22           N
ATOM    339  CA  ILE    44     -11.353  17.349  -1.648  1.00 51.00           C
ATOM    340  CB  ILE    44     -11.096  15.995  -2.361  1.00 33.87           C
ATOM    341  CG1 ILE    44     -10.543  16.248  -3.760  1.00 35.46           C
ATOM    342  CD1 ILE    44     -10.673  15.065  -4.684  1.00 40.96           C
ATOM    343  CG2 ILE    44     -12.368  15.184  -2.489  1.00 35.59           C
ATOM    344  C   ILE    44     -12.437  17.256  -0.575  1.00 57.35           C
ATOM    345  O   ILE    44     -12.371  16.422   0.326  1.00 55.31           O
ATOM    346  N   ASN    45     -13.419  18.146  -0.683  1.00 69.12           N
ATOM    347  CA  ASN    45     -14.475  18.302   0.313  1.00 80.69           C
ATOM    348  C   ASN    45     -15.091  16.983   0.775  1.00 77.66           C
ATOM    349  CB  ASN    45     -15.573  19.217  -0.236  1.00 92.37           C
ATOM    350  CG  ASN    45     -16.517  19.705   0.841  1.00 97.46           C
ATOM    351  OD1 ASN    45     -16.111  19.922   1.985  1.00 98.67           O
ATOM    352  ND2 ASN    45     -17.785  19.885   0.481  1.00 96.06           N
ATOM    353  O   ASN    45     -15.590  16.207  -0.040  1.00 82.94           O
ATOM    354  N   CYS    46     -15.073  16.750   2.085  1.00 67.08           N
ATOM    355  CA  CYS    46     -15.598  15.515   2.669  1.00 62.47           C
ATOM    356  C   CYS    46     -17.125  15.529   2.814  1.00 62.17           C
ATOM    357  CB  CYS    46     -14.951  15.277   4.040  1.00 59.73           C
ATOM    358  SG  CYS    46     -15.230  13.636   4.766  1.00106.57           S
ATOM    359  O   CYS    46     -17.658  15.093   3.832  1.00 71.02           O
ATOM    360  N   SER    47     -17.825  16.011   1.791  1.00 53.92           N
ATOM    361  CA  SER    47     -19.259  16.273   1.909  1.00 51.97           C
ATOM    362  C   SER    47     -20.132  15.032   1.738  1.00 45.27           C
ATOM    363  CB  SER    47     -19.687  17.360   0.918  1.00 54.06           C
ATOM    364  OG  SER    47     -21.041  17.724   1.118  1.00 54.99           O
ATOM    365  O   SER    47     -19.829  14.150   0.937  1.00 51.10           O
ATOM    366  N   LYS    48     -21.223  14.977   2.495  1.00 41.59           N
ATOM    367  CA  LYS    48     -22.188  13.888   2.374  1.00 41.93           C
ATOM    368  C   LYS    48     -22.929  13.983   1.048  1.00 35.27           C
ATOM    369  CB  LYS    48     -23.191  13.925   3.526  1.00 42.50           C
ATOM    370  CG  LYS    48     -24.331  12.935   3.373  1.00 48.77           C
ATOM    371  O   LYS    48     -23.354  12.976   0.480  1.00 26.58           O
ATOM    372  N   LEU    49     -23.087  15.211   0.566  1.00 38.61           N
ATOM    373  CA  LEU    49     -23.676  15.449  -0.741  1.00 38.50           C
ATOM    374  C   LEU    49     -22.740  14.992  -1.847  1.00 38.28           C
ATOM    375  CB  LEU    49     -24.007  16.929  -0.922  1.00 39.79           C
ATOM    376  CG  LEU    49     -25.456  17.296  -0.618  1.00 42.29           C
ATOM    377  CD1 LEU    49     -25.764  17.087   0.855  1.00 47.32           C
ATOM    378  CD2 LEU    49     -25.728  18.726  -1.038  1.00 42.96           C
ATOM    379  O   LEU    49     -23.153  14.307  -2.783  1.00 37.28           O
ATOM    380  N   MET    50     -21.475  15.376  -1.737  1.00 42.28           N
ATOM    381  CA  MET    50     -20.492  15.014  -2.745  1.00 37.99           C
ATOM    382  CB  MET    50     -19.161  15.716  -2.492  1.00 38.85           C
ATOM    383  CG  MET    50     -18.174  15.571  -3.644  1.00 43.10           C
ATOM    384  SD  MET    50     -18.756  16.316  -5.183  1.00 49.92           S
ATOM    385  CE  MET    50     -18.899  18.036  -4.706  1.00 35.64           C
ATOM    386  C   MET    50     -20.293  13.505  -2.805  1.00 34.27           C
ATOM    387  O   MET    50     -20.042  12.954  -3.872  1.00 43.24           O
ATOM    388  N   LYS    51     -20.409  12.838  -1.661  1.00 32.27           N
ATOM    389  CA  LYS    51     -20.316  11.383  -1.629  1.00 32.79           C
ATOM    390  C   LYS    51     -21.427  10.757  -2.471  1.00 30.43           C
ATOM    391  CB  LYS    51     -20.397  10.861  -0.194  1.00 36.87           C
ATOM    392  CG  LYS    51     -20.241   9.350  -0.097  1.00 39.71           C
ATOM    393  CD  LYS    51     -20.381   8.859   1.329  1.00 41.39           C
ATOM    394  CE  LYS    51     -21.813   8.935   1.803  1.00 42.82           C
ATOM    395  NZ  LYS    51     -21.967   8.281   3.129  1.00 51.50           N
ATOM    396  O   LYS    51     -21.196   9.813  -3.222  1.00 31.73           O
ATOM    397  N   ARG    52     -22.632  11.296  -2.335  1.00 24.42           N
ATOM    398  CA  ARG    52     -23.786  10.810  -3.082  1.00 34.25           C
ATOM    399  C   ARG    52     -23.603  10.993  -4.589  1.00 38.67           C
ATOM    400  CB  ARG    52     -25.062  11.518  -2.602  1.00 36.38           C
ATOM    401  CG  ARG    52     -26.269  11.362  -3.516  1.00 40.51           C
ATOM    402  CD  ARG    52     -26.730   9.923  -3.584  1.00 47.64           C
ATOM    403  NE  ARG    52     -27.173   9.434  -2.283  1.00 60.47           N
ATOM    404  CZ  ARG    52     -28.441   9.428  -1.878  1.00 68.99           C
ATOM    405  NH1 ARG    52     -28.748   8.961  -0.673  1.00 70.98           N
ATOM    406  NH2 ARG    52     -29.402   9.885  -2.677  1.00 59.63           N
ATOM    407  O   ARG    52     -23.931  10.106  -5.375  1.00 38.99           O
ATOM    408  N   ARG    53     -23.076  12.143  -4.991  1.00 37.78           N
ATOM    409  CA  ARG    53     -22.926  12.441  -6.408  1.00 27.97           C
ATOM    410  CB  ARG    53     -22.643  13.925  -6.619  1.00 30.07           C
ATOM    411  CG  ARG    53     -23.701  14.835  -6.027  1.00 32.32           C
ATOM    412  CD  ARG    53     -23.223  16.270  -6.028  1.00 34.30           C
ATOM    413  NE  ARG    53     -23.065  16.769  -7.386  1.00 37.14           N
ATOM    414  CZ  ARG    53     -22.296  17.799  -7.718  1.00 41.11           C
ATOM    415  NH1 ARG    53     -21.601  18.441  -6.787  1.00 41.03           N
ATOM    416  NH2 ARG    53     -22.215  18.181  -8.984  1.00 50.49           N
ATOM    417  C   ARG    53     -21.828  11.598  -7.034  1.00 26.58           C
ATOM    418  O   ARG    53     -21.929  11.219  -8.198  1.00 33.31           O
ATOM    419  N   LEU    54     -20.783  11.302  -6.263  1.00 23.11           N
ATOM    420  CA  LEU    54     -19.707  10.430  -6.739  1.00 26.22           C
ATOM    421  CB  LEU    54     -18.529  10.417  -5.767  1.00 26.60           C
ATOM    422  CG  LEU    54     -17.546  11.584  -5.815  1.00 28.36           C
ATOM    423  CD1 LEU    54     -16.705  11.573  -4.562  1.00 31.64           C
ATOM    424  CD2 LEU    54     -16.668  11.506  -7.047  1.00 25.92           C
ATOM    425  C   LEU    54     -20.201   9.007  -6.942  1.00 32.23           C
ATOM    426  O   LEU    54     -19.881   8.372  -7.947  1.00 39.27           O
ATOM    427  N   GLN    55     -20.975   8.501  -5.987  1.00 32.69           N
ATOM    428  CA  GLN    55     -21.512   7.149  -6.117  1.00 39.72           C
ATOM    429  CB  GLN    55     -21.870   6.542  -4.756  1.00 36.87           C
ATOM    430  CG  GLN    55     -22.697   7.409  -3.846  1.00 39.89           C
ATOM    431  CD  GLN    55     -22.716   6.873  -2.427  1.00 50.23           C
ATOM    432  OE1 GLN    55     -23.337   7.454  -1.535  1.00 61.14           O
ATOM    433  NE2 GLN    55     -22.026   5.759  -2.211  1.00 47.60           N
ATOM    434  C   GLN    55     -22.677   7.065  -7.106  1.00 42.85           C
ATOM    435  O   GLN    55     -22.957   6.000  -7.650  1.00 44.76           O
ATOM    436  N   GLN    56     -23.347   8.190  -7.344  1.00 46.82           N
ATOM    437  CA  GLN    56     -24.323   8.276  -8.426  1.00 45.42           C
ATOM    438  CB  GLN    56     -25.273   9.453  -8.211  1.00 50.60           C
ATOM    439  CG  GLN    56     -26.336   9.183  -7.174  1.00 59.55           C
ATOM    440  CD  GLN    56     -27.059   7.880  -7.431  1.00 68.75           C
ATOM    441  OE1 GLN    56     -27.391   7.554  -8.573  1.00 69.19           O
ATOM    442  NE2 GLN    56     -27.305   7.122  -6.369  1.00 73.71           N
ATOM    443  C   GLN    56     -23.606   8.424  -9.762  1.00 49.15           C
ATOM    444  O   GLN    56     -24.227   8.383 -10.825  1.00 50.61           O
ATOM    445  N   ASP    57     -22.290   8.595  -9.691  1.00 50.01           N
ATOM    446  CA  ASP    57     -21.457   8.794 -10.870  1.00 50.90           C
ATOM    447  C   ASP    57     -21.863  10.036 -11.669  1.00 48.47           C
ATOM    448  CB  ASP    57     -21.457   7.541 -11.753  1.00 63.04           C
ATOM    449  CG  ASP    57     -20.622   6.411 -11.164  1.00 74.02           C
ATOM    450  OD1 ASP    57     -19.612   6.702 -10.484  1.00 69.32           O
ATOM    451  OD2 ASP    57     -20.971   5.231 -11.387  1.00 83.00           O
ATOM    452  O   ASP    57     -21.687  10.082 -12.890  1.00 49.58           O
ATOM    453  N   LYS    58     -22.395  11.041 -10.973  1.00 43.80           N
ATOM    454  CA  LYS    58     -22.780  12.306 -11.604  1.00 39.90           C
ATOM    455  CB  LYS    58     -24.050  12.877 -10.971  1.00 36.58           C
ATOM    456  CG  LYS    58     -25.286  12.043 -11.247  1.00 39.76           C
ATOM    457  CD  LYS    58     -25.431  11.760 -12.733  1.00 49.52           C
ATOM    458  CE  LYS    58     -26.482  10.694 -12.996  1.00 56.22           C
ATOM    459  NZ  LYS    58     -26.491  10.267 -14.423  1.00 61.47           N
ATOM    460  C   LYS    58     -21.647  13.319 -11.523  1.00 42.27           C
ATOM    461  O   LYS    58     -21.711  14.387 -12.131  1.00 51.90           O
ATOM    462  N   VAL    59     -20.623  12.971 -10.751  1.00 33.26           N
ATOM    463  CA  VAL    59     -19.376  13.719 -10.688  1.00 29.60           C
ATOM    464  CB  VAL    59     -19.187  14.431  -9.324  1.00 28.62           C
ATOM    465  CG1 VAL    59     -17.858  15.162  -9.289  1.00 29.32           C
ATOM    466  CG2 VAL    59     -20.323  15.396  -9.049  1.00 29.12           C
ATOM    467  C   VAL    59     -18.260  12.698 -10.855  1.00 34.05           C
ATOM    468  O   VAL    59     -18.344  11.597 -10.305  1.00 35.30           O
ATOM    469  N   LEU    60     -17.229  13.042 -11.625  1.00 37.50           N
ATOM    470  CA  LEU    60     -16.067  12.166 -11.772  1.00 42.21           C
ATOM    471  CB  LEU    60     -15.575  12.135 -13.221  1.00 45.41           C
ATOM    472  CG  LEU    60     -16.498  11.491 -14.257  1.00 47.20           C
ATOM    473  CD1 LEU    60     -15.752  11.303 -15.561  1.00 52.01           C
ATOM    474  CD2 LEU    60     -17.049  10.161 -13.759  1.00 43.24           C
ATOM    475  C   LEU    60     -14.946  12.619 -10.847  1.00 41.66           C
ATOM    476  O   LEU    60     -14.722  13.816 -10.683  1.00 40.31           O
ATOM    477  N   ILE    61     -14.246  11.666 -10.239  1.00 38.19           N
ATOM    478  CA  ILE    61     -13.184  12.014  -9.309  1.00 32.87           C
ATOM    479  CB  ILE    61     -12.527  10.765  -8.670  1.00 29.11           C
ATOM    480  CG1 ILE    61     -11.690  11.173  -7.459  1.00 25.84           C
ATOM    481  CD1 ILE    61     -12.436  12.039  -6.466  1.00 29.15           C
ATOM    482  CG2 ILE    61     -11.687  10.010  -9.676  1.00 20.82           C
ATOM    483  C   ILE    61     -12.143  12.914  -9.978  1.00 30.86           C
ATOM    484  O   ILE    61     -11.636  13.849  -9.355  1.00 30.96           O
ATOM    485  N   THR    62     -11.843  12.647 -11.248  1.00 34.08           N
ATOM    486  CA  THR    62     -10.919  13.491 -12.012  1.00 35.89           C
ATOM    487  CB  THR    62     -10.602  12.902 -13.407  1.00 39.01           C
ATOM    488  OG1 THR    62     -11.811  12.457 -14.037  1.00 44.98           O
ATOM    489  CG2 THR    62      -9.630  11.731 -13.291  1.00 29.67           C
ATOM    490  C   THR    62     -11.467  14.907 -12.178  1.00 40.36           C
ATOM    491  O   THR    62     -10.713  15.877 -12.242  1.00 44.86           O
ATOM    492  N   GLU    63     -12.788  15.013 -12.247  1.00 40.84           N
ATOM    493  CA  GLU    63     -13.456  16.299 -12.348  1.00 38.96           C
ATOM    494  CB  GLU    63     -14.904  16.078 -12.780  1.00 48.16           C
ATOM    495  CG  GLU    63     -15.704  17.342 -13.020  1.00 66.32           C
ATOM    496  CD  GLU    63     -17.144  17.044 -13.401  1.00 78.42           C
ATOM    497  OE1 GLU    63     -17.461  15.858 -13.645  1.00 72.66           O
ATOM    498  OE2 GLU    63     -17.957  17.995 -13.457  1.00 87.86           O
ATOM    499  C   GLU    63     -13.399  17.044 -11.010  1.00 40.37           C
ATOM    500  O   GLU    63     -13.166  18.248 -10.961  1.00 45.37           O
ATOM    501  N   LEU    64     -13.607  16.315  -9.922  1.00 37.95           N
ATOM    502  CA  LEU    64     -13.612  16.904  -8.590  1.00 35.93           C
ATOM    503  CB  LEU    64     -14.094  15.865  -7.577  1.00 40.45           C
ATOM    504  CG  LEU    64     -14.491  16.330  -6.179  1.00 44.49           C
ATOM    505  CD1 LEU    64     -15.480  17.482  -6.245  1.00 40.87           C
ATOM    506  CD2 LEU    64     -15.073  15.151  -5.417  1.00 47.40           C
ATOM    507  C   LEU    64     -12.219  17.409  -8.215  1.00 38.16           C
ATOM    508  O   LEU    64     -12.072  18.501  -7.672  1.00 39.82           O
ATOM    509  N   ILE    65     -11.204  16.603  -8.514  1.00 37.64           N
ATOM    510  CA  ILE    65      -9.811  16.944  -8.235  1.00 39.92           C
ATOM    511  CB  ILE    65      -8.864  15.860  -8.779  1.00 35.24           C
ATOM    512  CG1 ILE    65      -8.873  14.636  -7.861  1.00 29.71           C
ATOM    513  CD1 ILE    65      -8.242  13.402  -8.481  1.00 28.25           C
ATOM    514  CG2 ILE    65      -7.453  16.416  -8.947  1.00 30.91           C
ATOM    515  C   ILE    65      -9.393  18.280  -8.838  1.00 46.48           C
ATOM    516  O   ILE    65      -8.794  19.118  -8.162  1.00 45.83           O
ATOM    517  N   GLN    66      -9.709  18.463 -10.118  1.00 56.22           N
ATOM    518  CA  GLN    66      -9.350  19.670 -10.857  1.00 54.55           C
ATOM    519  CB  GLN    66      -9.550  19.444 -12.353  1.00 60.28           C
ATOM    520  CG  GLN    66      -9.064  20.585 -13.211  1.00 72.01           C
ATOM    521  CD  GLN    66      -7.578  20.511 -13.468  1.00 85.30           C
ATOM    522  OE1 GLN    66      -6.823  21.403 -13.077  1.00 92.06           O
ATOM    523  NE2 GLN    66      -7.146  19.439 -14.124  1.00 86.93           N
ATOM    524  C   GLN    66     -10.155  20.893 -10.417  1.00 50.28           C
ATOM    525  O   GLN    66      -9.648  22.016 -10.437  1.00 55.72           O
ATOM    526  N   HIS    67     -11.411  20.675 -10.033  1.00 43.67           N
ATOM    527  CA  HIS    67     -12.275  21.762  -9.582  1.00 44.40           C
ATOM    528  CB  HIS    67     -13.738  21.313  -9.541  1.00 40.90           C
ATOM    529  C   HIS    67     -11.839  22.212  -8.200  1.00 49.95           C
ATOM    530  O   HIS    67     -12.064  23.357  -7.807  1.00 53.24           O
ATOM    531  N   SER    68     -11.210  21.291  -7.475  1.00 47.00           N
ATOM    532  CA  SER    68     -10.787  21.524  -6.102  1.00 45.77           C
ATOM    533  C   SER    68      -9.403  22.158  -6.042  1.00 53.15           C
ATOM    534  CB  SER    68     -10.788  20.205  -5.325  1.00 42.58           C
ATOM    535  OG  SER    68     -12.075  19.607  -5.330  1.00 48.44           O
ATOM    536  O   SER    68      -8.946  22.576  -4.981  1.00 61.48           O
ATOM    537  O   ALA    69      -7.891  24.743  -8.426  1.00 78.32           O
ATOM    538  N   ALA    69      -8.737  22.232  -7.184  1.00 59.34           N
ATOM    539  CA  ALA    69      -7.374  22.733  -7.216  1.00 73.24           C
ATOM    540  C   ALA    69      -7.323  24.234  -7.457  1.00 80.42           C
ATOM    541  CB  ALA    69      -6.559  21.992  -8.271  1.00 80.03           C
ATOM    542  N   LYS    70      -6.648  24.938  -6.555  1.00 88.75           N
ATOM    543  CA  LYS    70      -6.339  26.342  -6.763  1.00 91.54           C
ATOM    544  C   LYS    70      -5.386  26.422  -7.948  1.00 93.60           C
ATOM    545  CB  LYS    70      -5.701  26.941  -5.509  1.00 87.53           C
ATOM    546  CG  LYS    70      -6.579  26.853  -4.267  1.00 82.32           C
ATOM    547  O   LYS    70      -5.556  27.247  -8.846  1.00 95.71           O
ATOM    548  N   HIS    71      -4.388  25.543  -7.944  1.00 91.55           N
ATOM    549  CA  HIS    71      -3.513  25.361  -9.093  1.00 89.14           C
ATOM    550  C   HIS    71      -4.298  24.694 -10.219  1.00 90.61           C
ATOM    551  CB  HIS    71      -2.315  24.487  -8.708  1.00 81.33           C
ATOM    552  O   HIS    71      -5.423  24.235 -10.013  1.00 92.67           O
ATOM    553  N   LYS    72      -3.720  24.650 -11.414  1.00 87.36           N
ATOM    554  CA  LYS    72      -4.278  23.819 -12.472  1.00 83.80           C
ATOM    555  C   LYS    72      -3.679  22.426 -12.311  1.00 83.67           C
ATOM    556  CB  LYS    72      -3.963  24.393 -13.854  1.00 80.30           C
ATOM    557  O   LYS    72      -2.520  22.198 -12.662  1.00 86.83           O
ATOM    558  N   VAL    73      -4.462  21.504 -11.756  1.00 76.29           N
ATOM    559  CA  VAL    73      -3.961  20.177 -11.401  1.00 62.44           C
ATOM    560  C   VAL    73      -3.731  19.279 -12.615  1.00 55.24           C
ATOM    561  CB  VAL    73      -4.903  19.460 -10.407  1.00 53.77           C
ATOM    562  O   VAL    73      -4.500  19.301 -13.577  1.00 50.98           O
ATOM    563  N   ASP    74      -2.660  18.494 -12.564  1.00 56.44           N
ATOM    564  CA  ASP    74      -2.386  17.505 -13.597  1.00 58.76           C
ATOM    565  C   ASP    74      -3.122  16.221 -13.275  1.00 50.96           C
ATOM    566  CB  ASP    74      -0.886  17.215 -13.700  1.00 70.12           C
ATOM    567  CG  ASP    74      -0.582  15.975 -14.535  1.00 78.77           C
ATOM    568  OD1 ASP    74      -1.282  15.747 -15.546  1.00 84.78           O
ATOM    569  OD2 ASP    74       0.363  15.234 -14.181  1.00 76.70           O
ATOM    570  O   ASP    74      -2.873  15.590 -12.250  1.00 48.16           O
ATOM    571  N   ILE    75      -4.046  15.840 -14.144  1.00 51.11           N
ATOM    572  CA  ILE    75      -4.667  14.536 -14.022  1.00 50.32           C
ATOM    573  C   ILE    75      -3.983  13.601 -15.007  1.00 53.98           C
ATOM    574  CB  ILE    75      -6.189  14.585 -14.241  1.00 48.96           C
ATOM    575  CG1 ILE    75      -6.521  14.994 -15.681  1.00 54.90           C
ATOM    576  CG2 ILE    75      -6.833  15.531 -13.230  1.00 40.78           C
ATOM    577  CD1 ILE    75      -7.903  14.562 -16.139  1.00 53.82           C
ATOM    578  O   ILE    75      -3.904  13.873 -16.208  1.00 58.19           O
ATOM    579  N   ASP    76      -3.458  12.510 -14.472  1.00 46.59           N
ATOM    580  CA  ASP    76      -2.659  11.582 -15.243  1.00 39.95           C
ATOM    581  C   ASP    76      -2.639  10.291 -14.449  1.00 39.99           C
ATOM    582  CB  ASP    76      -1.253  12.145 -15.415  1.00 46.24           C
ATOM    583  CG  ASP    76      -0.300  11.160 -16.044  1.00 62.54           C
ATOM    584  OD1 ASP    76      -0.767  10.150 -16.611  1.00 58.76           O
ATOM    585  OD2 ASP    76       0.924  11.403 -15.971  1.00 78.13           O
ATOM    586  O   ASP    76      -2.167  10.268 -13.313  1.00 43.30           O
ATOM    587  N   CYS    77      -3.170   9.224 -15.038  1.00 32.09           N
ATOM    588  CA  CYS    77      -3.415   7.989 -14.299  1.00 29.25           C
ATOM    589  C   CYS    77      -2.139   7.293 -13.817  1.00 30.94           C
ATOM    590  CB  CYS    77      -4.292   7.029 -15.115  1.00 24.46           C
ATOM    591  SG  CYS    77      -3.488   6.287 -16.538  1.00 32.77           S
ATOM    592  O   CYS    77      -2.204   6.267 -13.143  1.00 34.92           O
ATOM    593  N   SER    78      -0.983   7.861 -14.148  1.00 32.37           N
ATOM    594  CA  SER    78       0.297   7.305 -13.715  1.00 33.84           C
ATOM    595  C   SER    78       0.796   7.964 -12.427  1.00 39.45           C
ATOM    596  CB  SER    78       1.338   7.474 -14.814  1.00 39.39           C
ATOM    597  OG  SER    78       1.506   8.846 -15.119  1.00 45.95           O
ATOM    598  O   SER    78       1.759   7.500 -11.814  1.00 39.60           O
ATOM    599  N   GLN    79       0.142   9.051 -12.025  1.00 38.96           N
ATOM    600  CA  GLN    79       0.479   9.743 -10.784  1.00 33.59           C
ATOM    601  C   GLN    79       0.225   8.863  -9.578  1.00 33.66           C
ATOM    602  CB  GLN    79      -0.364  11.005 -10.632  1.00 35.24           C
ATOM    603  CG  GLN    79       0.194  12.221 -11.328  1.00 45.10           C
ATOM    604  CD  GLN    79      -0.737  13.395 -11.211  1.00 52.62           C
ATOM    605  OE1 GLN    79      -0.378  14.437 -10.664  1.00 61.12           O
ATOM    606  NE2 GLN    79      -1.958  13.225 -11.700  1.00 49.63           N
ATOM    607  O   GLN    79      -0.851   8.277  -9.452  1.00 42.02           O
ATOM    608  N   LYS    80       1.206   8.776  -8.686  1.00 25.19           N
ATOM    609  CA  LYS    80       0.990   8.094  -7.424  1.00 23.95           C
ATOM    610  C   LYS    80       0.098   8.990  -6.581  1.00 26.27           C
ATOM    611  CB  LYS    80       2.309   7.823  -6.709  1.00 27.50           C
ATOM    612  CG  LYS    80       3.383   7.190  -7.587  1.00 35.39           C
ATOM    613  CD  LYS    80       2.995   5.798  -8.046  1.00 42.35           C
ATOM    614  CE  LYS    80       4.053   5.225  -8.976  1.00 58.22           C
ATOM    615  NZ  LYS    80       3.737   3.844  -9.433  1.00 69.00           N
ATOM    616  O   LYS    80       0.456  10.131  -6.291  1.00 30.53           O
ATOM    617  N   VAL    81      -1.074   8.480  -6.213  1.00 22.03           N
ATOM    618  CA  VAL    81      -2.047   9.257  -5.448  1.00 29.89           C
ATOM    619  CB  VAL    81      -3.468   9.155  -6.065  1.00 29.34           C
ATOM    620  CG1 VAL    81      -4.430  10.081  -5.349  1.00 27.61           C
ATOM    621  CG2 VAL    81      -3.430   9.479  -7.554  1.00 26.33           C
ATOM    622  C   VAL    81      -2.084   8.812  -3.983  1.00 32.41           C
ATOM    623  O   VAL    81      -2.341   7.647  -3.690  1.00 34.11           O
ATOM    624  N   VAL    82      -1.806   9.737  -3.071  1.00 30.28           N
ATOM    625  CA  VAL    82      -1.886   9.450  -1.647  1.00 24.58           C
ATOM    626  CB  VAL    82      -0.584   9.814  -0.917  1.00 27.13           C
ATOM    627  CG1 VAL    82      -0.712   9.520   0.570  1.00 27.30           C
ATOM    628  CG2 VAL    82       0.596   9.060  -1.518  1.00 18.42           C
ATOM    629  C   VAL    82      -3.029  10.247  -1.037  1.00 27.75           C
ATOM    630  O   VAL    82      -3.064  11.468  -1.140  1.00 27.86           O
ATOM    631  N   VAL    83      -3.970   9.548  -0.414  1.00 25.86           N
ATOM    632  CA  VAL    83      -5.099  10.198   0.224  1.00 26.95           C
ATOM    633  CB  VAL    83      -6.426   9.521  -0.152  1.00 33.42           C
ATOM    634  CG1 VAL    83      -7.609  10.406   0.243  1.00 31.46           C
ATOM    635  CG2 VAL    83      -6.454   9.226  -1.636  1.00 37.17           C
ATOM    636  C   VAL    83      -4.929  10.118   1.727  1.00 29.97           C
ATOM    637  O   VAL    83      -4.300   9.192   2.236  1.00 33.29           O
ATOM    638  N   TYR    84      -5.489  11.090   2.437  1.00 28.76           N
ATOM    639  CA  TYR    84      -5.437  11.088   3.892  1.00 22.70           C
ATOM    640  CB  TYR    84      -4.109  11.673   4.394  1.00 23.70           C
ATOM    641  CG  TYR    84      -3.922  13.174   4.208  1.00 22.59           C
ATOM    642  CD1 TYR    84      -4.302  14.067   5.204  1.00 25.05           C
ATOM    643  CE1 TYR    84      -4.120  15.433   5.057  1.00 24.38           C
ATOM    644  CZ  TYR    84      -3.543  15.924   3.908  1.00 29.29           C
ATOM    645  OH  TYR    84      -3.365  17.283   3.771  1.00 28.86           O
ATOM    646  CE2 TYR    84      -3.144  15.060   2.901  1.00 29.54           C
ATOM    647  CD2 TYR    84      -3.328  13.691   3.059  1.00 27.85           C
ATOM    648  C   TYR    84      -6.625  11.808   4.524  1.00 25.65           C
ATOM    649  O   TYR    84      -7.168  12.754   3.955  1.00 28.74           O
ATOM    650  N   ASP    85      -7.043  11.321   5.687  1.00 28.55           N
ATOM    651  CA  ASP    85      -7.975  12.047   6.542  1.00 29.47           C
ATOM    652  CB  ASP    85      -9.270  11.258   6.788  1.00 31.81           C
ATOM    653  CG  ASP    85      -9.031   9.917   7.460  1.00 41.96           C
ATOM    654  OD1 ASP    85      -7.857   9.555   7.677  1.00 44.75           O
ATOM    655  OD2 ASP    85     -10.029   9.224   7.767  1.00 44.78           O
ATOM    656  C   ASP    85      -7.261  12.385   7.847  1.00 32.18           C
ATOM    657  O   ASP    85      -6.040  12.518   7.871  1.00 29.69           O
ATOM    658  N   GLN    86      -8.004  12.518   8.936  1.00 37.70           N
ATOM    659  CA  GLN    86      -7.394  12.974  10.178  1.00 36.77           C
ATOM    660  CB  GLN    86      -8.448  13.568  11.124  1.00 38.36           C
ATOM    661  CG  GLN    86      -7.866  14.223  12.381  1.00 39.57           C
ATOM    662  CD  GLN    86      -6.771  15.242  12.079  1.00 48.25           C
ATOM    663  OE1 GLN    86      -6.795  15.917  11.048  1.00 56.78           O
ATOM    664  NE2 GLN    86      -5.805  15.359  12.989  1.00 44.21           N
ATOM    665  C   GLN    86      -6.548  11.906  10.883  1.00 33.44           C
ATOM    666  O   GLN    86      -5.439  12.195  11.344  1.00 33.95           O
ATOM    667  N   SER    87      -7.048  10.675  10.960  1.00 29.04           N
ATOM    668  CA  SER    87      -6.357   9.666  11.751  1.00 30.16           C
ATOM    669  C   SER    87      -6.733   8.222  11.443  1.00 31.65           C
ATOM    670  CB  SER    87      -6.600   9.929  13.235  1.00 42.21           C
ATOM    671  OG  SER    87      -7.980   9.814  13.535  1.00 47.86           O
ATOM    672  O   SER    87      -6.716   7.383  12.339  1.00 41.52           O
ATOM    673  N   SER    88      -7.066   7.918  10.194  1.00 25.57           N
ATOM    674  CA  SER    88      -7.368   6.535   9.838  1.00 29.73           C
ATOM    675  CB  SER    88      -8.165   6.458   8.536  1.00 32.47           C
ATOM    676  OG  SER    88      -9.444   7.050   8.689  1.00 28.42           O
ATOM    677  C   SER    88      -6.079   5.725   9.738  1.00 36.38           C
ATOM    678  O   SER    88      -5.134   6.126   9.059  1.00 36.76           O
ATOM    679  N   GLN    89      -6.040   4.590  10.429  1.00 40.94           N
ATOM    680  CA  GLN    89      -4.831   3.769  10.487  1.00 45.01           C
ATOM    681  CB  GLN    89      -4.840   2.883  11.737  1.00 46.68           C
ATOM    682  CG  GLN    89      -4.791   3.658  13.040  1.00 54.54           C
ATOM    683  CD  GLN    89      -3.625   4.627  13.098  1.00 61.94           C
ATOM    684  OE1 GLN    89      -2.534   4.332  12.606  1.00 68.37           O
ATOM    685  NE2 GLN    89      -3.848   5.792  13.702  1.00 61.72           N
ATOM    686  C   GLN    89      -4.640   2.913   9.233  1.00 45.74           C
ATOM    687  O   GLN    89      -3.521   2.760   8.741  1.00 45.36           O
ATOM    688  N   ASP    90      -5.735   2.349   8.732  1.00 44.80           N
ATOM    689  CA  ASP    90      -5.703   1.572   7.497  1.00 43.06           C
ATOM    690  CB  ASP    90      -5.192   0.149   7.745  1.00 46.67           C
ATOM    691  CG  ASP    90      -5.937  -0.558   8.859  1.00 46.76           C
ATOM    692  OD1 ASP    90      -7.177  -0.668   8.781  1.00 49.99           O
ATOM    693  OD2 ASP    90      -5.272  -1.019   9.811  1.00 53.06           O
ATOM    694  C   ASP    90      -7.075   1.539   6.849  1.00 32.85           C
ATOM    695  O   ASP    90      -8.063   1.953   7.447  1.00 28.16           O
ATOM    696  N   VAL    91      -7.128   1.050   5.618  1.00 31.60           N
ATOM    697  CA  VAL    91      -8.381   0.989   4.883  1.00 37.21           C
ATOM    698  CB  VAL    91      -8.144   0.520   3.436  1.00 30.78           C
ATOM    699  CG1 VAL    91      -9.463   0.413   2.677  1.00 30.65           C
ATOM    700  CG2 VAL    91      -7.200   1.476   2.735  1.00 27.13           C
ATOM    701  C   VAL    91      -9.409   0.084   5.568  1.00 38.53           C
ATOM    702  O   VAL    91     -10.610   0.355   5.526  1.00 41.48           O
ATOM    703  N   ALA    92      -8.934  -0.980   6.210  1.00 35.68           N
ATOM    704  CA  ALA    92      -9.822  -1.979   6.798  1.00 37.95           C
ATOM    705  CB  ALA    92      -9.032  -3.210   7.230  1.00 33.32           C
ATOM    706  C   ALA    92     -10.618  -1.417   7.967  1.00 49.30           C
ATOM    707  O   ALA    92     -11.691  -1.923   8.294  1.00 62.43           O
ATOM    708  N   SER    93     -10.094  -0.367   8.590  1.00 48.60           N
ATOM    709  CA  SER    93     -10.744   0.231   9.751  1.00 49.77           C
ATOM    710  CB  SER    93      -9.705   0.868  10.683  1.00 54.51           C
ATOM    711  OG  SER    93      -9.043   1.956  10.059  1.00 51.65           O
ATOM    712  C   SER    93     -11.811   1.251   9.351  1.00 53.89           C
ATOM    713  O   SER    93     -12.320   1.995  10.189  1.00 54.84           O
ATOM    714  N   LEU    94     -12.148   1.276   8.066  1.00 55.73           N
ATOM    715  CA  LEU    94     -13.170   2.180   7.551  1.00 48.66           C
ATOM    716  CB  LEU    94     -12.729   2.765   6.210  1.00 42.08           C
ATOM    717  CG  LEU    94     -11.468   3.615   6.262  1.00 35.36           C
ATOM    718  CD1 LEU    94     -11.105   4.100   4.870  1.00 27.43           C
ATOM    719  CD2 LEU    94     -11.684   4.780   7.217  1.00 36.03           C
ATOM    720  C   LEU    94     -14.495   1.451   7.372  1.00 48.47           C
ATOM    721  O   LEU    94     -14.514   0.230   7.178  1.00 40.01           O
ATOM    722  N   SER    95     -15.596   2.201   7.442  1.00 52.46           N
ATOM    723  CA  SER    95     -16.925   1.651   7.190  1.00 50.63           C
ATOM    724  C   SER    95     -17.159   1.596   5.690  1.00 56.42           C
ATOM    725  CB  SER    95     -18.010   2.498   7.851  1.00 50.78           C
ATOM    726  OG  SER    95     -18.616   3.374   6.917  1.00 50.30           O
ATOM    727  O   SER    95     -16.715   2.476   4.953  1.00 61.75           O
ATOM    728  N   SER    96     -17.871   0.568   5.244  1.00 56.64           N
ATOM    729  CA  SER    96     -18.013   0.286   3.819  1.00 55.58           C
ATOM    730  C   SER    96     -18.658   1.406   2.998  1.00 53.11           C
ATOM    731  CB  SER    96     -18.778  -1.023   3.621  1.00 62.80           C
ATOM    732  OG  SER    96     -19.796  -1.164   4.596  1.00 71.52           O
ATOM    733  O   SER    96     -18.521   1.436   1.772  1.00 47.25           O
ATOM    734  N   ASP    97     -19.340   2.330   3.669  1.00 55.96           N
ATOM    735  CA  ASP    97     -20.147   3.327   2.969  1.00 61.79           C
ATOM    736  C   ASP    97     -19.734   4.777   3.230  1.00 59.32           C
ATOM    737  CB  ASP    97     -21.625   3.146   3.328  1.00 72.30           C
ATOM    738  CG  ASP    97     -22.550   3.818   2.334  1.00 80.18           C
ATOM    739  OD1 ASP    97     -22.475   3.476   1.134  1.00 79.71           O
ATOM    740  OD2 ASP    97     -23.353   4.681   2.753  1.00 83.47           O
ATOM    741  O   ASP    97     -20.390   5.706   2.756  1.00 58.99           O
ATOM    742  N   CYS    98     -18.658   4.981   3.982  1.00 56.40           N
ATOM    743  CA  CYS    98     -18.234   6.340   4.303  1.00 47.18           C
ATOM    744  C   CYS    98     -17.609   7.024   3.093  1.00 41.73           C
ATOM    745  CB  CYS    98     -17.273   6.357   5.491  1.00 46.59           C
ATOM    746  SG  CYS    98     -15.637   5.727   5.117  1.00 45.29           S
ATOM    747  O   CYS    98     -17.382   6.397   2.057  1.00 37.79           O
ATOM    748  N   PHE    99     -17.336   8.315   3.233  1.00 41.90           N
ATOM    749  CA  PHE    99     -16.868   9.119   2.113  1.00 41.40           C
ATOM    750  CB  PHE    99     -16.879  10.598   2.481  1.00 36.21           C
ATOM    751  CG  PHE    99     -16.312  11.488   1.417  1.00 34.62           C
ATOM    752  CD1 PHE    99     -17.057  11.801   0.294  1.00 32.58           C
ATOM    753  CE1 PHE    99     -16.541  12.625  -0.685  1.00 37.40           C
ATOM    754  CZ  PHE    99     -15.265  13.148  -0.549  1.00 40.15           C
ATOM    755  CE2 PHE    99     -14.509  12.846   0.571  1.00 31.64           C
ATOM    756  CD2 PHE    99     -15.034  12.018   1.546  1.00 30.29           C
ATOM    757  C   PHE    99     -15.480   8.705   1.636  1.00 42.36           C
ATOM    758  O   PHE    99     -15.273   8.459   0.448  1.00 44.78           O
ATOM    759  N   LEU   100     -14.535   8.637   2.566  1.00 34.66           N
ATOM    760  CA  LEU   100     -13.169   8.226   2.259  1.00 35.24           C
ATOM    761  CB  LEU   100     -12.367   8.110   3.552  1.00 38.29           C
ATOM    762  CG  LEU   100     -10.927   7.639   3.387  1.00 36.62           C
ATOM    763  CD1 LEU   100     -10.255   8.408   2.258  1.00 34.17           C
ATOM    764  CD2 LEU   100     -10.178   7.813   4.692  1.00 36.62           C
ATOM    765  C   LEU   100     -13.117   6.900   1.493  1.00 34.33           C
ATOM    766  O   LEU   100     -12.376   6.755   0.520  1.00 34.59           O
ATOM    767  N   THR   101     -13.912   5.940   1.952  1.00 38.35           N
ATOM    768  CA  THR   101     -14.047   4.633   1.313  1.00 37.66           C
ATOM    769  CB  THR   101     -15.000   3.735   2.123  1.00 41.40           C
ATOM    770  OG1 THR   101     -14.321   3.245   3.286  1.00 40.00           O
ATOM    771  CG2 THR   101     -15.471   2.559   1.281  1.00 44.07           C
ATOM    772  C   THR   101     -14.579   4.752  -0.112  1.00 36.46           C
ATOM    773  O   THR   101     -14.073   4.110  -1.034  1.00 35.84           O
ATOM    774  N   VAL   102     -15.620   5.563  -0.278  1.00 35.16           N
ATOM    775  CA  VAL   102     -16.142   5.894  -1.597  1.00 33.01           C
ATOM    776  CB  VAL   102     -17.358   6.826  -1.492  1.00 29.72           C
ATOM    777  CG1 VAL   102     -17.696   7.412  -2.863  1.00 24.15           C
ATOM    778  CG2 VAL   102     -18.539   6.075  -0.910  1.00 26.78           C
ATOM    779  C   VAL   102     -15.080   6.582  -2.449  1.00 38.67           C
ATOM    780  O   VAL   102     -14.932   6.287  -3.633  1.00 44.93           O
ATOM    781  N   LEU   103     -14.346   7.504  -1.836  1.00 32.39           N
ATOM    782  CA  LEU   103     -13.302   8.248  -2.524  1.00 21.76           C
ATOM    783  CB  LEU   103     -12.702   9.295  -1.585  1.00 18.67           C
ATOM    784  CG  LEU   103     -11.684  10.243  -2.219  1.00 29.54           C
ATOM    785  CD1 LEU   103     -12.369  11.155  -3.225  1.00 33.17           C
ATOM    786  CD2 LEU   103     -10.969  11.053  -1.147  1.00 33.15           C
ATOM    787  C   LEU   103     -12.209   7.318  -3.059  1.00 29.60           C
ATOM    788  O   LEU   103     -11.760   7.469  -4.194  1.00 30.18           O
ATOM    789  N   LEU   104     -11.792   6.355  -2.239  1.00 34.80           N
ATOM    790  CA  LEU   104     -10.746   5.408  -2.631  1.00 37.26           C
ATOM    791  CB  LEU   104     -10.338   4.519  -1.447  1.00 31.68           C
ATOM    792  CG  LEU   104      -9.508   5.198  -0.353  1.00 31.71           C
ATOM    793  CD1 LEU   104      -9.511   4.384   0.941  1.00 25.38           C
ATOM    794  CD2 LEU   104      -8.082   5.450  -0.835  1.00 16.05           C
ATOM    795  C   LEU   104     -11.158   4.546  -3.825  1.00 32.47           C
ATOM    796  O   LEU   104     -10.351   4.270  -4.714  1.00 28.79           O
ATOM    797  N   GLY   105     -12.416   4.121  -3.840  1.00 33.19           N
ATOM    798  CA  GLY   105     -12.933   3.326  -4.937  1.00 32.37           C
ATOM    799  C   GLY   105     -12.839   4.080  -6.251  1.00 33.24           C
ATOM    800  O   GLY   105     -12.283   3.581  -7.227  1.00 35.42           O
ATOM    801  N   LYS   106     -13.382   5.292  -6.270  1.00 25.29           N
ATOM    802  CA  LYS   106     -13.349   6.124  -7.466  1.00 26.60           C
ATOM    803  C   LYS   106     -11.919   6.386  -7.925  1.00 23.49           C
ATOM    804  CB  LYS   106     -14.073   7.449  -7.212  1.00 28.36           C
ATOM    805  CG  LYS   106     -15.549   7.285  -6.949  1.00 23.75           C
ATOM    806  CD  LYS   106     -16.165   6.468  -8.058  1.00 36.12           C
ATOM    807  CE  LYS   106     -17.453   5.799  -7.621  1.00 44.68           C
ATOM    808  NZ  LYS   106     -18.068   5.065  -8.758  1.00 52.89           N
ATOM    809  O   LYS   106     -11.634   6.390  -9.121  1.00 29.67           O
ATOM    810  N   LEU   107     -11.024   6.607  -6.965  1.00 27.45           N
ATOM    811  CA  LEU   107      -9.634   6.912  -7.273  1.00 27.78           C
ATOM    812  CB  LEU   107      -8.902   7.415  -6.032  1.00 26.49           C
ATOM    813  CG  LEU   107      -9.120   8.866  -5.625  1.00 21.02           C
ATOM    814  CD1 LEU   107      -8.520   9.101  -4.249  1.00 20.09           C
ATOM    815  CD2 LEU   107      -8.500   9.805  -6.647  1.00 18.87           C
ATOM    816  C   LEU   107      -8.906   5.696  -7.827  1.00 27.48           C
ATOM    817  O   LEU   107      -8.111   5.816  -8.761  1.00 29.63           O
ATOM    818  N   GLU   108      -9.170   4.528  -7.247  1.00 24.78           N
ATOM    819  CA  GLU   108      -8.494   3.311  -7.684  1.00 33.49           C
ATOM    820  CB  GLU   108      -8.763   2.137  -6.741  1.00 30.59           C
ATOM    821  CG  GLU   108      -7.745   2.007  -5.626  1.00 34.19           C
ATOM    822  CD  GLU   108      -7.806   0.656  -4.941  1.00 42.70           C
ATOM    823  OE1 GLU   108      -8.359  -0.295  -5.543  1.00 43.25           O
ATOM    824  OE2 GLU   108      -7.297   0.549  -3.804  1.00 37.85           O
ATOM    825  C   GLU   108      -8.888   2.950  -9.106  1.00 37.32           C
ATOM    826  O   GLU   108      -8.174   2.203  -9.777  1.00 40.34           O
ATOM    827  N   LYS   109     -10.020   3.488  -9.558  1.00 27.96           N
ATOM    828  CA  LYS   109     -10.499   3.251 -10.917  1.00 26.39           C
ATOM    829  C   LYS   109      -9.851   4.188 -11.940  1.00 18.13           C
ATOM    830  CB  LYS   109     -12.026   3.373 -10.987  1.00 27.54           C
ATOM    831  CG  LYS   109     -12.787   2.140 -10.518  1.00 39.68           C
ATOM    832  CD  LYS   109     -14.001   1.886 -11.408  1.00 58.02           C
ATOM    833  CE  LYS   109     -14.878   0.764 -10.872  1.00 71.99           C
ATOM    834  NZ  LYS   109     -15.717   1.215  -9.719  1.00 82.27           N
ATOM    835  O   LYS   109      -9.703   3.835 -13.100  1.00 25.33           O
ATOM    836  N   SER   110      -9.469   5.382 -11.501  1.00 22.12           N
ATOM    837  CA  SER   110      -8.904   6.387 -12.394  1.00 22.40           C
ATOM    838  CB  SER   110      -9.524   7.765 -12.118  1.00 23.58           C
ATOM    839  OG  SER   110     -10.836   7.851 -12.651  1.00 27.93           O
ATOM    840  C   SER   110      -7.383   6.469 -12.297  1.00 28.42           C
ATOM    841  O   SER   110      -6.734   7.035 -13.183  1.00 22.84           O
ATOM    842  N   PHE   111      -6.824   5.911 -11.222  1.00 33.62           N
ATOM    843  CA  PHE   111      -5.373   5.888 -11.012  1.00 29.22           C
ATOM    844  CB  PHE   111      -4.973   6.876  -9.915  1.00 31.53           C
ATOM    845  CG  PHE   111      -5.332   8.299 -10.221  1.00 32.74           C
ATOM    846  CD1 PHE   111      -6.556   8.822  -9.817  1.00 28.97           C
ATOM    847  CE1 PHE   111      -6.892  10.137 -10.096  1.00 21.53           C
ATOM    848  CZ  PHE   111      -6.001  10.942 -10.787  1.00 22.95           C
ATOM    849  CE2 PHE   111      -4.774  10.429 -11.199  1.00 24.35           C
ATOM    850  CD2 PHE   111      -4.447   9.116 -10.912  1.00 27.86           C
ATOM    851  C   PHE   111      -4.851   4.494 -10.657  1.00 25.54           C
ATOM    852  O   PHE   111      -5.482   3.755  -9.902  1.00 27.19           O
ATOM    853  N   ASN   112      -3.682   4.154 -11.190  1.00 23.97           N
ATOM    854  CA  ASN   112      -3.085   2.834 -10.995  1.00 31.83           C
ATOM    855  CB  ASN   112      -1.892   2.642 -11.935  1.00 39.41           C
ATOM    856  CG  ASN   112      -2.288   2.637 -13.395  1.00 32.74           C
ATOM    857  OD1 ASN   112      -3.321   2.074 -13.774  1.00 29.58           O
ATOM    858  ND2 ASN   112      -1.456   3.257 -14.229  1.00 25.56           N
ATOM    859  C   ASN   112      -2.621   2.569  -9.570  1.00 27.70           C
ATOM    860  O   ASN   112      -2.783   1.465  -9.052  1.00 36.92           O
ATOM    861  N   SER   113      -2.017   3.581  -8.955  1.00 27.06           N
ATOM    862  CA  SER   113      -1.507   3.470  -7.592  1.00 28.53           C
ATOM    863  CB  SER   113       0.005   3.727  -7.555  1.00 36.90           C
ATOM    864  OG  SER   113       0.738   2.519  -7.673  1.00 53.38           O
ATOM    865  C   SER   113      -2.212   4.441  -6.666  1.00 24.37           C
ATOM    866  O   SER   113      -1.966   5.644  -6.718  1.00 29.81           O
ATOM    867  N   VAL   114      -3.088   3.911  -5.819  1.00 30.18           N
ATOM    868  CA  VAL   114      -3.810   4.722  -4.847  1.00 29.32           C
ATOM    869  CB  VAL   114      -5.326   4.729  -5.129  1.00 30.16           C
ATOM    870  CG1 VAL   114      -6.069   5.530  -4.054  1.00 29.59           C
ATOM    871  CG2 VAL   114      -5.604   5.285  -6.515  1.00 29.04           C
ATOM    872  C   VAL   114      -3.564   4.186  -3.441  1.00 22.61           C
ATOM    873  O   VAL   114      -3.823   3.018  -3.170  1.00 27.56           O
ATOM    874  N   HIS   115      -3.074   5.047  -2.552  1.00 24.69           N
ATOM    875  CA  HIS   115      -2.744   4.638  -1.187  1.00 28.03           C
ATOM    876  CB  HIS   115      -1.233   4.452  -1.051  1.00 24.44           C
ATOM    877  CG  HIS   115      -0.667   3.516  -2.067  1.00 24.97           C
ATOM    878  ND1 HIS   115      -0.853   2.151  -2.004  1.00 36.98           N
ATOM    879  CE1 HIS   115      -0.262   1.577  -3.036  1.00 37.25           C
ATOM    880  NE2 HIS   115       0.295   2.523  -3.773  1.00 28.51           N
ATOM    881  CD2 HIS   115       0.052   3.744  -3.192  1.00 21.83           C
ATOM    882  C   HIS   115      -3.261   5.580  -0.110  1.00 24.77           C
ATOM    883  O   HIS   115      -3.231   6.800  -0.261  1.00 24.97           O
ATOM    884  N   LEU   116      -3.739   4.992   0.981  1.00 22.93           N
ATOM    885  CA  LEU   116      -4.151   5.751   2.148  1.00 23.17           C
ATOM    886  CB  LEU   116      -5.210   4.967   2.928  1.00 22.44           C
ATOM    887  CG  LEU   116      -5.790   5.538   4.227  1.00 33.60           C
ATOM    888  CD1 LEU   116      -6.558   6.831   3.978  1.00 35.46           C
ATOM    889  CD2 LEU   116      -6.696   4.509   4.891  1.00 34.38           C
ATOM    890  C   LEU   116      -2.926   5.991   3.024  1.00 27.32           C
ATOM    891  O   LEU   116      -2.084   5.110   3.176  1.00 28.52           O
ATOM    892  N   LEU   117      -2.821   7.180   3.601  1.00 20.78           N
ATOM    893  CA  LEU   117      -1.708   7.467   4.490  1.00 22.95           C
ATOM    894  CB  LEU   117      -1.441   8.971   4.573  1.00 31.00           C
ATOM    895  CG  LEU   117      -0.196   9.387   5.365  1.00 28.22           C
ATOM    896  CD1 LEU   117       1.073   8.961   4.650  1.00 25.66           C
ATOM    897  CD2 LEU   117      -0.200  10.885   5.593  1.00 31.88           C
ATOM    898  C   LEU   117      -1.988   6.892   5.875  1.00 24.73           C
ATOM    899  O   LEU   117      -3.001   7.206   6.495  1.00 18.25           O
ATOM    900  N   ALA   118      -1.086   6.039   6.347  1.00 30.02           N
ATOM    901  CA  ALA   118      -1.235   5.397   7.643  1.00 28.97           C
ATOM    902  CB  ALA   118      -0.176   4.317   7.809  1.00 28.11           C
ATOM    903  C   ALA   118      -1.142   6.426   8.772  1.00 29.45           C
ATOM    904  O   ALA   118      -0.091   7.029   8.988  1.00 36.88           O
ATOM    905  N   GLY   119      -2.247   6.632   9.479  1.00 26.95           N
ATOM    906  CA  GLY   119      -2.270   7.547  10.608  1.00 22.59           C
ATOM    907  C   GLY   119      -2.792   8.930  10.267  1.00 21.17           C
ATOM    908  O   GLY   119      -3.057   9.739  11.151  1.00 30.70           O
ATOM    909  N   GLY   120      -2.931   9.208   8.977  1.00 19.11           N
ATOM    910  CA  GLY   120      -3.505  10.463   8.534  1.00 19.09           C
ATOM    911  C   GLY   120      -2.672  11.682   8.872  1.00 25.59           C
ATOM    912  O   GLY   120      -1.493  11.575   9.217  1.00 27.42           O
ATOM    913  N   PHE   121      -3.297  12.851   8.767  1.00 31.24           N
ATOM    914  CA  PHE   121      -2.609  14.112   8.999  1.00 33.12           C
ATOM    915  CB  PHE   121      -3.539  15.304   8.727  1.00 34.46           C
ATOM    916  CG  PHE   121      -2.867  16.635   8.891  1.00 34.02           C
ATOM    917  CD1 PHE   121      -1.989  17.104   7.925  1.00 26.81           C
ATOM    918  CE1 PHE   121      -1.356  18.318   8.078  1.00 21.42           C
ATOM    919  CZ  PHE   121      -1.586  19.078   9.208  1.00 24.76           C
ATOM    920  CE2 PHE   121      -2.454  18.622  10.181  1.00 26.53           C
ATOM    921  CD2 PHE   121      -3.089  17.404  10.021  1.00 32.65           C
ATOM    922  C   PHE   121      -2.058  14.178  10.419  1.00 32.13           C
ATOM    923  O   PHE   121      -1.028  14.804  10.663  1.00 26.92           O
ATOM    924  N   ALA   122      -2.757  13.521  11.344  1.00 36.55           N
ATOM    925  CA  ALA   122      -2.364  13.475  12.751  1.00 39.32           C
ATOM    926  CB  ALA   122      -3.326  12.594  13.546  1.00 42.38           C
ATOM    927  C   ALA   122      -0.936  12.980  12.925  1.00 40.07           C
ATOM    928  O   ALA   122      -0.118  13.634  13.573  1.00 47.62           O
ATOM    929  N   GLU   123      -0.637  11.819  12.356  1.00 39.23           N
ATOM    930  CA  GLU   123       0.718  11.301  12.432  1.00 34.22           C
ATOM    931  CB  GLU   123       0.788   9.824  12.062  1.00 38.22           C
ATOM    932  CG  GLU   123       2.210   9.299  12.072  1.00 58.96           C
ATOM    933  CD  GLU   123       2.283   7.791  12.133  1.00 79.25           C
ATOM    934  OE1 GLU   123       1.242   7.160  12.412  1.00 85.83           O
ATOM    935  OE2 GLU   123       3.383   7.239  11.907  1.00 86.33           O
ATOM    936  C   GLU   123       1.673  12.098  11.560  1.00 38.00           C
ATOM    937  O   GLU   123       2.773  12.424  11.993  1.00 48.50           O
ATOM    938  N   PHE   124       1.266  12.422  10.336  1.00 35.64           N
ATOM    939  CA  PHE   124       2.173  13.151   9.454  1.00 33.86           C
ATOM    940  CB  PHE   124       1.583  13.379   8.066  1.00 27.80           C
ATOM    941  CG  PHE   124       2.552  14.028   7.116  1.00 30.57           C
ATOM    942  CD1 PHE   124       3.429  13.258   6.365  1.00 27.33           C
ATOM    943  CE1 PHE   124       4.335  13.852   5.498  1.00 27.90           C
ATOM    944  CZ  PHE   124       4.382  15.231   5.384  1.00 28.09           C
ATOM    945  CE2 PHE   124       3.519  16.009   6.135  1.00 34.46           C
ATOM    946  CD2 PHE   124       2.615  15.406   7.002  1.00 31.74           C
ATOM    947  C   PHE   124       2.614  14.491  10.040  1.00 35.06           C
ATOM    948  O   PHE   124       3.802  14.819  10.037  1.00 32.65           O
ATOM    949  N   SER   125       1.652  15.268  10.523  1.00 32.61           N
ATOM    950  CA  SER   125       1.959  16.560  11.115  1.00 37.08           C
ATOM    951  C   SER   125       2.790  16.394  12.394  1.00 45.32           C
ATOM    952  CB  SER   125       0.674  17.339  11.396  1.00 32.14           C
ATOM    953  OG  SER   125      -0.150  16.649  12.316  1.00 39.87           O
ATOM    954  O   SER   125       3.545  17.290  12.779  1.00 40.44           O
ATOM    955  N   ARG   126       2.653  15.235  13.034  1.00 49.39           N
ATOM    956  CA  ARG   126       3.380  14.923  14.261  1.00 47.74           C
ATOM    957  C   ARG   126       4.867  14.679  13.992  1.00 46.97           C
ATOM    958  CB  ARG   126       2.751  13.702  14.945  1.00 54.45           C
ATOM    959  CG  ARG   126       3.395  13.301  16.268  1.00 69.39           C
ATOM    960  CD  ARG   126       2.634  12.166  16.952  1.00 76.01           C
ATOM    961  NE  ARG   126       2.514  10.989  16.093  1.00 84.08           N
ATOM    962  CZ  ARG   126       3.371   9.972  16.086  1.00 87.77           C
ATOM    963  NH1 ARG   126       4.420   9.976  16.898  1.00 87.98           N
ATOM    964  NH2 ARG   126       3.178   8.948  15.266  1.00 87.62           N
ATOM    965  O   ARG   126       5.716  14.975  14.835  1.00 46.55           O
ATOM    966  N   CYS   127       5.173  14.152  12.808  1.00 46.74           N
ATOM    967  CA  CYS   127       6.541  13.785  12.432  1.00 43.63           C
ATOM    968  CB  CYS   127       6.548  12.464  11.651  1.00 49.03           C
ATOM    969  SG  CYS   127       5.830  11.039  12.508  1.00 50.28           S
ATOM    970  C   CYS   127       7.248  14.860  11.600  1.00 40.55           C
ATOM    971  O   CYS   127       8.428  15.146  11.811  1.00 47.00           O
ATOM    972  N   PHE   128       6.530  15.438  10.644  1.00 33.20           N
ATOM    973  CA  PHE   128       7.105  16.447   9.764  1.00 27.30           C
ATOM    974  CB  PHE   128       7.208  15.914   8.341  1.00 24.79           C
ATOM    975  CG  PHE   128       8.040  14.673   8.228  1.00 34.58           C
ATOM    976  CD1 PHE   128       7.446  13.423   8.233  1.00 39.61           C
ATOM    977  CE1 PHE   128       8.218  12.272   8.133  1.00 43.30           C
ATOM    978  CZ  PHE   128       9.593  12.367   8.032  1.00 37.85           C
ATOM    979  CE2 PHE   128      10.196  13.610   8.032  1.00 32.24           C
ATOM    980  CD2 PHE   128       9.422  14.754   8.131  1.00 33.74           C
ATOM    981  C   PHE   128       6.281  17.715   9.782  1.00 34.76           C
ATOM    982  O   PHE   128       5.480  17.954   8.884  1.00 37.57           O
ATOM    983  N   PRO   129       6.476  18.534  10.819  1.00 44.79           N
ATOM    984  CA  PRO   129       5.737  19.788  10.969  1.00 41.52           C
ATOM    985  CB  PRO   129       6.122  20.254  12.380  1.00 37.72           C
ATOM    986  CG  PRO   129       6.759  19.052  13.043  1.00 40.79           C
ATOM    987  CD  PRO   129       7.405  18.305  11.936  1.00 45.11           C
ATOM    988  C   PRO   129       6.190  20.807   9.927  1.00 45.62           C
ATOM    989  O   PRO   129       5.386  21.643   9.495  1.00 42.72           O
ATOM    990  N   GLY   130       7.462  20.729   9.532  1.00 40.66           N
ATOM    991  CA  GLY   130       8.015  21.630   8.536  1.00 40.82           C
ATOM    992  C   GLY   130       7.479  21.374   7.138  1.00 42.73           C
ATOM    993  O   GLY   130       7.751  22.134   6.208  1.00 40.06           O
ATOM    994  N   LEU   131       6.702  20.304   6.992  1.00 46.45           N
ATOM    995  CA  LEU   131       6.125  19.943   5.702  1.00 38.75           C
ATOM    996  CB  LEU   131       6.449  18.487   5.372  1.00 40.26           C
ATOM    997  CG  LEU   131       7.953  18.241   5.246  1.00 41.66           C
ATOM    998  CD1 LEU   131       8.237  16.782   4.943  1.00 38.33           C
ATOM    999  CD2 LEU   131       8.553  19.156   4.181  1.00 41.19           C
ATOM   1000  C   LEU   131       4.618  20.195   5.640  1.00 31.58           C
ATOM   1001  O   LEU   131       3.929  19.700   4.746  1.00 26.81           O
ATOM   1002  N   CYS   132       4.116  20.975   6.591  1.00 38.06           N
ATOM   1003  CA  CYS   132       2.708  21.348   6.619  1.00 46.30           C
ATOM   1004  CB  CYS   132       2.057  20.898   7.932  1.00 50.21           C
ATOM   1005  SG  CYS   132       2.349  19.160   8.367  1.00 37.07           S
ATOM   1006  C   CYS   132       2.535  22.857   6.418  1.00 47.00           C
ATOM   1007  O   CYS   132       3.378  23.651   6.836  1.00 53.23           O
ATOM   1008  N   GLU   133       1.439  23.238   5.771  1.00 44.36           N
ATOM   1009  CA  GLU   133       1.173  24.631   5.441  1.00 48.73           C
ATOM   1010  C   GLU   133      -0.093  25.086   6.145  1.00 52.20           C
ATOM   1011  CB  GLU   133       1.006  24.796   3.929  1.00 53.88           C
ATOM   1012  CG  GLU   133       2.196  24.327   3.105  1.00 68.87           C
ATOM   1013  CD  GLU   133       1.926  24.361   1.606  1.00 85.09           C
ATOM   1014  OE1 GLU   133       0.743  24.482   1.208  1.00 87.01           O
ATOM   1015  OE2 GLU   133       2.899  24.263   0.824  1.00 92.18           O
ATOM   1016  O   GLU   133      -1.108  24.398   6.105  1.00 51.09           O
ATOM   1017  N   GLY   134      -0.034  26.251   6.781  1.00 65.46           N
ATOM   1018  CA  GLY   134      -1.159  26.755   7.548  1.00 68.23           C
ATOM   1019  C   GLY   134      -1.799  27.989   6.946  1.00 65.42           C
ATOM   1020  O   GLY   134      -2.452  28.761   7.650  1.00 62.45           O
END
