
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  123 (  934),  selected  123 , name 1adw_A
# Molecule2: number of CA atoms  130 ( 1084),  selected  130 , name T0390.pdb
# PARAMETERS: 1adw_A.T0390.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A      29           -
LGA    A     1_A      D      30          1.538
LGA    T     2_A      R      31          0.917
LGA    H     3_A      H      32          0.895
LGA    E     4_A      T      33          0.804
LGA    V     5_A      V      34          0.575
LGA    H     6_A      F      35          0.529
LGA    M     7_A      W      36          1.008
LGA    L     8_A      N      37          1.502
LGA    N     9_A      S      38          2.165
LGA    K    10_A      S      39          1.248
LGA    G    11_A      N      40          2.111
LGA    E    12_A      P      41          2.499
LGA    S    13_A      K      42          4.281
LGA    -       -      F      43           -
LGA    G    14_A      R      44          3.305
LGA    A    15_A      N      45           -
LGA    M    16_A      -       -           -
LGA    V    17_A      -       -           -
LGA    F    18_A      E      46           #
LGA    E    19_A      -       -           -
LGA    P    20_A      -       -           -
LGA    A    21_A      D      47           #
LGA    F    22_A      Y      48          3.878
LGA    -       -      T      49           -
LGA    V    23_A      I      50          1.172
LGA    R    24_A      H      51          0.469
LGA    A    25_A      V      52          0.430
LGA    E    26_A      Q      53          0.589
LGA    P    27_A      L      54          0.750
LGA    G    28_A      N      55          0.839
LGA    D    29_A      D      56          1.144
LGA    V    30_A      Y      57          1.014
LGA    I    31_A      V      58          0.794
LGA    N    32_A      D      59          0.833
LGA    F    33_A      I      60          0.638
LGA    V    34_A      I      61          0.298
LGA    P    35_A      C      62          1.094
LGA    T    36_A      P      63          3.052
LGA    D    37_A      H      64          4.674
LGA    -       -      Y      65           -
LGA    -       -      E      66           -
LGA    -       -      S      69           -
LGA    -       -      V      70           -
LGA    -       -      A      71           -
LGA    -       -      D      72           -
LGA    -       -      A      73           -
LGA    -       -      A      74           -
LGA    K    38_A      M      75          4.110
LGA    S    39_A      E      76          2.862
LGA    -       -      Q      77           -
LGA    H    40_A      Y      78          2.433
LGA    N    41_A      I      79          3.393
LGA    V    42_A      L      80          1.807
LGA    E    43_A      Y      81          0.963
LGA    A    44_A      L      82          0.890
LGA    I    45_A      V      83          1.800
LGA    K    46_A      E      84          3.118
LGA    E    47_A      -       -           -
LGA    I    48_A      H      85          2.968
LGA    L    49_A      E      86           -
LGA    P    50_A      E      87           -
LGA    E    51_A      Y      88           -
LGA    G    52_A      Q      89           -
LGA    V    53_A      L      90           -
LGA    E    54_A      C      91           -
LGA    -       -      Q      92           -
LGA    -       -      P      93           -
LGA    -       -      Q      94           -
LGA    -       -      S      95           -
LGA    -       -      K      96           -
LGA    S    55_A      D      97          5.880
LGA    F    56_A      Q      98          4.646
LGA    K    57_A      V      99          2.361
LGA    -       -      R     100           -
LGA    S    58_A      W     101          0.609
LGA    K    59_A      Q     102          1.398
LGA    I    60_A      C     103          2.450
LGA    N    61_A      N     104          3.275
LGA    -       -      R     105           -
LGA    -       -      P     106           -
LGA    -       -      S     107           -
LGA    -       -      A     108           -
LGA    -       -      K     109           -
LGA    -       -      H     110           -
LGA    -       -      G     111           -
LGA    -       -      P     112           -
LGA    E    62_A      E     113          3.489
LGA    S    63_A      K     114          1.577
LGA    Y    64_A      L     115          0.892
LGA    T    65_A      S     116          1.227
LGA    L    66_A      E     117          0.899
LGA    T    67_A      K     118          1.113
LGA    V    68_A      F     119          1.127
LGA    T    69_A      Q     120          2.101
LGA    -       -      R     121           -
LGA    -       -      F     122           -
LGA    -       -      T     123           -
LGA    -       -      P     124           -
LGA    -       -      F     125           -
LGA    -       -      T     126           -
LGA    -       -      L     127           -
LGA    -       -      G     128           -
LGA    -       -      K     129           -
LGA    -       -      E     130           -
LGA    E    70_A      F     131          1.809
LGA    P    71_A      K     132          2.162
LGA    -       -      E     133           -
LGA    -       -      G     134           -
LGA    G    72_A      H     135          1.153
LGA    L    73_A      S     136          0.589
LGA    Y    74_A      Y     137          0.680
LGA    G    75_A      Y     138          0.646
LGA    V    76_A      Y     139          0.416
LGA    K    77_A      I     140          0.441
LGA    C    78_A      S     141          0.762
LGA    T    79_A      K     142          2.190
LGA    P    80_A      P     143          2.745
LGA    -       -      I     144           -
LGA    -       -      H     145           -
LGA    -       -      Q     146           -
LGA    -       -      H     147           -
LGA    H    81_A      E     148          4.046
LGA    F    82_A      D     149           -
LGA    G    83_A      -       -           -
LGA    M    84_A      R     150          2.687
LGA    G    85_A      C     151          1.165
LGA    M    86_A      L     152          0.670
LGA    V    87_A      R     153          0.679
LGA    G    88_A      L     154          0.731
LGA    L    89_A      K     155          0.638
LGA    V    90_A      V     156          0.366
LGA    Q    91_A      T     157          0.397
LGA    V    92_A      V     158          0.957
LGA    G    93_A      S     159          1.696
LGA    D    94_A      G     160          4.173
LGA    A    95_A      -       -           -
LGA    P    96_A      -       -           -
LGA    E    97_A      -       -           -
LGA    N    98_A      -       -           -
LGA    L    99_A      -       -           -
LGA    D   100_A      -       -           -
LGA    A   101_A      -       -           -
LGA    A   102_A      -       -           -
LGA    K   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    A   105_A      -       -           -
LGA    K   106_A      -       -           -
LGA    M   107_A      -       -           -
LGA    P   108_A      -       -           -
LGA    K   109_A      -       -           -
LGA    K   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    R   112_A      -       -           -
LGA    E   113_A      -       -           -
LGA    R   114_A      -       -           -
LGA    M   115_A      -       -           -
LGA    D   116_A      -       -           -
LGA    A   117_A      -       -           -
LGA    E   118_A      -       -           -
LGA    L   119_A      -       -           -
LGA    A   120_A      -       -           -
LGA    Q   121_A      -       -           -
LGA    V   122_A      -       -           -
LGA    N   123_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  123  130    5.0     78    2.14    11.54     43.703     3.485

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.120488 * X  +  -0.355402 * Y  +   0.926915 * Z  + -52.880604
  Y_new =  -0.221069 * X  +  -0.919877 * Y  +  -0.323967 * Z  + -14.909104
  Z_new =   0.967787 * X  +  -0.165878 * Y  +  -0.189402 * Z  +  21.028606 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.422312    0.719281  [ DEG:  -138.7883     41.2117 ]
  Theta =  -1.316286   -1.825306  [ DEG:   -75.4177   -104.5823 ]
  Phi   =  -1.071780    2.069812  [ DEG:   -61.4085    118.5915 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1adw_A                                        
REMARK     2: T0390.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1adw_A.T0390.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  123  130   5.0   78   2.14   11.54  43.703
REMARK  ---------------------------------------------------------- 
MOLECULE 1adw_A
HEADER    ELECTRON TRANSPORT                      18-FEB-97   1ADW              
TITLE     PSEUDOAZURIN                                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PSEUDOAZURIN;                                              
COMPND   3 CHAIN: A, B                                                          
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PARACOCCUS PANTOTROPHUS;                        
SOURCE   3 STRAIN: GB17;                                                        
SOURCE   4 ATCC: 35512;                                                         
SOURCE   5 CELLULAR_LOCATION: PERIPLASM                                         
KEYWDS    COPPER, ELECTRON TRANSPORT, CUPROPROTEIN                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.A.WILLIAMS                                                          
REVDAT   2   30-SEP-03 1ADW    1       DBREF                                    
REVDAT   1   15-MAY-97 1ADW    0                                                
JRNL        AUTH   P.A.WILLIAMS,V.FULOP,Y.C.LEUNG,C.CHAN,J.W.MOIR,              
JRNL        AUTH 2 G.HOWLETT,S.J.FERGUSON,S.E.RADFORD,J.HAJDU                   
JRNL        TITL   PSEUDOSPECIFIC DOCKING SURFACES ON ELECTRON                  
JRNL        TITL 2 TRANSFER PROTEINS AS ILLUSTRATED BY PSEUDOAZURIN,            
JRNL        TITL 3 CYTOCHROME C550 AND CYTOCHROME CD1 NITRITE                   
JRNL        TITL 4 REDUCTASE.                                                   
JRNL        REF    NAT.STRUCT.BIOL.              V.   2   975 1995              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1ADW A    1   123  UNP    P80401   AZUP_PARPN      23    145             
DBREF  1ADW B    1   123  UNP    P80401   AZUP_PARPN      23    145             
SEQRES   1 A  123  ALA THR HIS GLU VAL HIS MET LEU ASN LYS GLY GLU SER          
SEQRES   2 A  123  GLY ALA MET VAL PHE GLU PRO ALA PHE VAL ARG ALA GLU          
SEQRES   3 A  123  PRO GLY ASP VAL ILE ASN PHE VAL PRO THR ASP LYS SER          
SEQRES   4 A  123  HIS ASN VAL GLU ALA ILE LYS GLU ILE LEU PRO GLU GLY          
SEQRES   5 A  123  VAL GLU SER PHE LYS SER LYS ILE ASN GLU SER TYR THR          
SEQRES   6 A  123  LEU THR VAL THR GLU PRO GLY LEU TYR GLY VAL LYS CYS          
SEQRES   7 A  123  THR PRO HIS PHE GLY MET GLY MET VAL GLY LEU VAL GLN          
SEQRES   8 A  123  VAL GLY ASP ALA PRO GLU ASN LEU ASP ALA ALA LYS THR          
SEQRES   9 A  123  ALA LYS MET PRO LYS LYS ALA ARG GLU ARG MET ASP ALA          
SEQRES  10 A  123  GLU LEU ALA GLN VAL ASN                                      
SEQRES   1 B  123  ALA THR HIS GLU VAL HIS MET LEU ASN LYS GLY GLU SER          
SEQRES   2 B  123  GLY ALA MET VAL PHE GLU PRO ALA PHE VAL ARG ALA GLU          
SEQRES   3 B  123  PRO GLY ASP VAL ILE ASN PHE VAL PRO THR ASP LYS SER          
SEQRES   4 B  123  HIS ASN VAL GLU ALA ILE LYS GLU ILE LEU PRO GLU GLY          
SEQRES   5 B  123  VAL GLU SER PHE LYS SER LYS ILE ASN GLU SER TYR THR          
SEQRES   6 B  123  LEU THR VAL THR GLU PRO GLY LEU TYR GLY VAL LYS CYS          
SEQRES   7 B  123  THR PRO HIS PHE GLY MET GLY MET VAL GLY LEU VAL GLN          
SEQRES   8 B  123  VAL GLY ASP ALA PRO GLU ASN LEU ASP ALA ALA LYS THR          
SEQRES   9 B  123  ALA LYS MET PRO LYS LYS ALA ARG GLU ARG MET ASP ALA          
SEQRES  10 B  123  GLU LEU ALA GLN VAL ASN                                      
HET     CU  A 130       1                                                       
HET     CU  B 130       1                                                       
HETNAM      CU COPPER (II) ION                                                  
FORMUL   3   CU    2(CU 2+)                                                     
FORMUL   5  HOH   *56(H2 O)                                                     
CRYST1  110.000   58.400   69.200  90.00 127.00  90.00 C 1 2 1       8          
ATOM      1  N   ALA A   1     -26.896  -5.958   8.357  1.00 24.31           N  
ATOM      2  CA  ALA A   1     -26.793  -6.846   7.164  1.00 26.16           C  
ATOM      3  C   ALA A   1     -27.664  -8.077   7.363  1.00 28.89           C  
ATOM      4  O   ALA A   1     -27.973  -8.461   8.499  1.00 31.83           O  
ATOM      5  CB  ALA A   1     -25.346  -7.264   6.923  1.00 21.87           C  
ATOM      6  N   THR A   2     -28.019  -8.704   6.252  1.00 29.84           N  
ATOM      7  CA  THR A   2     -28.857  -9.889   6.249  1.00 30.63           C  
ATOM      8  C   THR A   2     -28.061 -11.101   5.788  1.00 26.74           C  
ATOM      9  O   THR A   2     -27.179 -10.999   4.931  1.00 26.69           O  
ATOM     10  CB  THR A   2     -30.052  -9.692   5.300  1.00 35.60           C  
ATOM     11  OG1 THR A   2     -30.842  -8.587   5.757  1.00 41.05           O  
ATOM     12  CG2 THR A   2     -30.908 -10.937   5.248  1.00 41.94           C  
ATOM     13  N   HIS A   3     -28.371 -12.249   6.370  1.00 27.58           N  
ATOM     14  CA  HIS A   3     -27.704 -13.502   6.027  1.00 21.81           C  
ATOM     15  C   HIS A   3     -28.792 -14.522   5.805  1.00 20.10           C  
ATOM     16  O   HIS A   3     -29.766 -14.564   6.551  1.00 24.95           O  
ATOM     17  CB  HIS A   3     -26.803 -13.978   7.171  1.00 23.07           C  
ATOM     18  CG  HIS A   3     -25.807 -12.954   7.632  1.00 22.53           C  
ATOM     19  ND1 HIS A   3     -24.514 -12.912   7.166  1.00 16.54           N  
ATOM     20  CD2 HIS A   3     -25.913 -11.957   8.543  1.00 19.81           C  
ATOM     21  CE1 HIS A   3     -23.861 -11.937   7.770  1.00 23.84           C  
ATOM     22  NE2 HIS A   3     -24.688 -11.342   8.609  1.00 24.85           N  
ATOM     23  N   GLU A   4     -28.639 -15.335   4.773  1.00 22.65           N  
ATOM     24  CA  GLU A   4     -29.621 -16.360   4.477  1.00 24.21           C  
ATOM     25  C   GLU A   4     -29.043 -17.764   4.693  1.00 23.33           C  
ATOM     26  O   GLU A   4     -27.929 -18.059   4.246  1.00 19.30           O  
ATOM     27  CB  GLU A   4     -30.113 -16.216   3.045  1.00 25.08           C  
ATOM     28  CG  GLU A   4     -31.345 -17.040   2.760  1.00 34.64           C  
ATOM     29  CD  GLU A   4     -31.702 -17.085   1.303  1.00 47.42           C  
ATOM     30  OE1 GLU A   4     -31.009 -16.442   0.478  1.00 62.57           O  
ATOM     31  OE2 GLU A   4     -32.674 -17.793   0.978  1.00 54.32           O  
ATOM     32  N   VAL A   5     -29.798 -18.605   5.400  1.00 18.31           N  
ATOM     33  CA  VAL A   5     -29.398 -19.979   5.670  1.00 16.72           C  
ATOM     34  C   VAL A   5     -30.515 -20.891   5.180  1.00 19.13           C  
ATOM     35  O   VAL A   5     -31.683 -20.691   5.514  1.00 18.44           O  
ATOM     36  CB  VAL A   5     -29.189 -20.238   7.170  1.00 13.54           C  
ATOM     37  CG1 VAL A   5     -28.842 -21.681   7.385  1.00  7.51           C  
ATOM     38  CG2 VAL A   5     -28.088 -19.356   7.715  1.00  8.27           C  
ATOM     39  N   HIS A   6     -30.164 -21.868   4.356  1.00 22.82           N  
ATOM     40  CA  HIS A   6     -31.141 -22.811   3.826  1.00 20.40           C  
ATOM     41  C   HIS A   6     -31.192 -24.096   4.619  1.00 22.40           C  
ATOM     42  O   HIS A   6     -30.169 -24.553   5.141  1.00 25.21           O  
ATOM     43  CB  HIS A   6     -30.804 -23.193   2.399  1.00 19.33           C  
ATOM     44  CG  HIS A   6     -30.906 -22.065   1.431  1.00 28.13           C  
ATOM     45  ND1 HIS A   6     -32.041 -21.293   1.304  1.00 25.79           N  
ATOM     46  CD2 HIS A   6     -30.031 -21.608   0.504  1.00 37.23           C  
ATOM     47  CE1 HIS A   6     -31.863 -20.416   0.337  1.00 33.31           C  
ATOM     48  NE2 HIS A   6     -30.653 -20.583  -0.165  1.00 44.90           N  
ATOM     49  N   MET A   7     -32.397 -24.653   4.738  1.00 26.11           N  
ATOM     50  CA  MET A   7     -32.599 -25.940   5.400  1.00 19.93           C  
ATOM     51  C   MET A   7     -32.773 -26.888   4.224  1.00 20.16           C  
ATOM     52  O   MET A   7     -33.722 -26.753   3.442  1.00 21.22           O  
ATOM     53  CB  MET A   7     -33.854 -25.938   6.256  1.00 22.04           C  
ATOM     54  CG  MET A   7     -33.619 -25.450   7.637  1.00 23.15           C  
ATOM     55  SD  MET A   7     -34.304 -23.863   7.784  1.00 26.96           S  
ATOM     56  CE  MET A   7     -35.887 -24.255   8.469  1.00 18.88           C  
ATOM     57  N   LEU A   8     -31.851 -27.833   4.097  1.00 16.95           N  
ATOM     58  CA  LEU A   8     -31.851 -28.772   2.981  1.00 18.60           C  
ATOM     59  C   LEU A   8     -31.766 -30.249   3.363  1.00 17.26           C  
ATOM     60  O   LEU A   8     -31.099 -30.627   4.322  1.00 17.65           O  
ATOM     61  CB  LEU A   8     -30.642 -28.480   2.087  1.00 14.07           C  
ATOM     62  CG  LEU A   8     -30.473 -27.094   1.497  1.00 16.63           C  
ATOM     63  CD1 LEU A   8     -29.034 -26.852   1.191  1.00 14.21           C  
ATOM     64  CD2 LEU A   8     -31.310 -26.973   0.263  1.00 12.23           C  
ATOM     65  N   ASN A   9     -32.346 -31.082   2.509  1.00 19.05           N  
ATOM     66  CA  ASN A   9     -32.322 -32.532   2.673  1.00 22.76           C  
ATOM     67  C   ASN A   9     -30.948 -33.007   2.241  1.00 21.56           C  
ATOM     68  O   ASN A   9     -30.367 -33.903   2.846  1.00 24.01           O  
ATOM     69  CB  ASN A   9     -33.365 -33.199   1.779  1.00 19.29           C  
ATOM     70  CG  ASN A   9     -34.775 -33.009   2.282  1.00 22.88           C  
ATOM     71  OD1 ASN A   9     -35.006 -32.768   3.472  1.00 32.84           O  
ATOM     72  ND2 ASN A   9     -35.733 -33.116   1.376  1.00 21.95           N  
ATOM     73  N   LYS A  10     -30.436 -32.393   1.183  1.00 19.90           N  
ATOM     74  CA  LYS A  10     -29.121 -32.720   0.656  1.00 23.27           C  
ATOM     75  C   LYS A  10     -28.406 -31.441   0.201  1.00 23.25           C  
ATOM     76  O   LYS A  10     -28.849 -30.759  -0.727  1.00 20.48           O  
ATOM     77  CB  LYS A  10     -29.266 -33.687  -0.520  1.00 31.97           C  
ATOM     78  CG  LYS A  10     -27.983 -33.931  -1.312  1.00 40.81           C  
ATOM     79  CD  LYS A  10     -26.933 -34.677  -0.509  1.00 46.62           C  
ATOM     80  CE  LYS A  10     -25.707 -34.926  -1.362  1.00 58.78           C  
ATOM     81  NZ  LYS A  10     -26.036 -35.684  -2.611  1.00 62.11           N  
ATOM     82  N   GLY A  11     -27.314 -31.097   0.865  1.00 20.68           N  
ATOM     83  CA  GLY A  11     -26.599 -29.902   0.469  1.00 23.23           C  
ATOM     84  C   GLY A  11     -25.254 -30.269  -0.099  1.00 22.00           C  
ATOM     85  O   GLY A  11     -24.987 -31.436  -0.379  1.00 27.57           O  
ATOM     86  N   GLU A  12     -24.384 -29.275  -0.218  1.00 23.41           N  
ATOM     87  CA  GLU A  12     -23.038 -29.478  -0.742  1.00 22.85           C  
ATOM     88  C   GLU A  12     -22.088 -30.205   0.210  1.00 23.80           C  
ATOM     89  O   GLU A  12     -21.068 -30.730  -0.227  1.00 22.21           O  
ATOM     90  CB  GLU A  12     -22.439 -28.140  -1.123  1.00 14.42           C  
ATOM     91  CG  GLU A  12     -23.275 -27.367  -2.106  1.00 26.53           C  
ATOM     92  CD  GLU A  12     -23.318 -28.022  -3.464  1.00 27.39           C  
ATOM     93  OE1 GLU A  12     -22.303 -28.622  -3.849  1.00 31.71           O  
ATOM     94  OE2 GLU A  12     -24.351 -27.932  -4.154  1.00 33.14           O  
ATOM     95  N   SER A  13     -22.423 -30.246   1.498  1.00 28.25           N  
ATOM     96  CA  SER A  13     -21.577 -30.898   2.498  1.00 27.10           C  
ATOM     97  C   SER A  13     -22.113 -32.208   3.048  1.00 27.09           C  
ATOM     98  O   SER A  13     -21.377 -32.953   3.685  1.00 34.16           O  
ATOM     99  CB  SER A  13     -21.339 -29.943   3.657  1.00 28.86           C  
ATOM    100  OG  SER A  13     -22.584 -29.528   4.190  1.00 34.05           O  
ATOM    101  N   GLY A  14     -23.397 -32.478   2.842  1.00 27.98           N  
ATOM    102  CA  GLY A  14     -23.965 -33.715   3.346  1.00 23.51           C  
ATOM    103  C   GLY A  14     -25.471 -33.721   3.310  1.00 22.79           C  
ATOM    104  O   GLY A  14     -26.080 -32.902   2.615  1.00 28.31           O  
ATOM    105  N   ALA A  15     -26.071 -34.623   4.074  1.00 21.26           N  
ATOM    106  CA  ALA A  15     -27.522 -34.741   4.131  1.00 19.92           C  
ATOM    107  C   ALA A  15     -28.050 -34.134   5.419  1.00 19.58           C  
ATOM    108  O   ALA A  15     -27.387 -34.188   6.444  1.00 22.19           O  
ATOM    109  CB  ALA A  15     -27.923 -36.195   4.036  1.00 20.93           C  
ATOM    110  N   MET A  16     -29.279 -33.629   5.371  1.00 24.61           N  
ATOM    111  CA  MET A  16     -29.919 -32.987   6.513  1.00 26.35           C  
ATOM    112  C   MET A  16     -28.964 -31.893   7.013  1.00 26.97           C  
ATOM    113  O   MET A  16     -28.306 -32.048   8.058  1.00 24.80           O  
ATOM    114  CB  MET A  16     -30.231 -33.997   7.640  1.00 29.73           C  
ATOM    115  CG  MET A  16     -31.193 -35.140   7.294  1.00 27.35           C  
ATOM    116  SD  MET A  16     -32.663 -34.678   6.350  1.00 27.45           S  
ATOM    117  CE  MET A  16     -32.332 -35.546   4.873  1.00 26.78           C  
ATOM    118  N   VAL A  17     -28.901 -30.785   6.272  1.00 20.87           N  
ATOM    119  CA  VAL A  17     -28.000 -29.694   6.631  1.00 16.95           C  
ATOM    120  C   VAL A  17     -28.557 -28.270   6.586  1.00 18.92           C  
ATOM    121  O   VAL A  17     -29.538 -27.981   5.887  1.00 16.88           O  
ATOM    122  CB  VAL A  17     -26.742 -29.689   5.710  1.00 16.66           C  
ATOM    123  CG1 VAL A  17     -25.963 -30.971   5.831  1.00 16.90           C  
ATOM    124  CG2 VAL A  17     -27.131 -29.453   4.267  1.00  8.63           C  
ATOM    125  N   PHE A  18     -27.949 -27.399   7.390  1.00 20.27           N  
ATOM    126  CA  PHE A  18     -28.259 -25.966   7.373  1.00 14.88           C  
ATOM    127  C   PHE A  18     -27.163 -25.537   6.408  1.00 14.35           C  
ATOM    128  O   PHE A  18     -26.028 -26.033   6.500  1.00 16.75           O  
ATOM    129  CB  PHE A  18     -28.027 -25.325   8.745  1.00 13.83           C  
ATOM    130  CG  PHE A  18     -29.224 -25.403   9.655  1.00 18.60           C  
ATOM    131  CD1 PHE A  18     -30.333 -24.588   9.434  1.00 17.78           C  
ATOM    132  CD2 PHE A  18     -29.262 -26.314  10.695  1.00  8.58           C  
ATOM    133  CE1 PHE A  18     -31.460 -24.685  10.233  1.00 16.58           C  
ATOM    134  CE2 PHE A  18     -30.383 -26.415  11.498  1.00 14.94           C  
ATOM    135  CZ  PHE A  18     -31.486 -25.599  11.267  1.00 19.91           C  
ATOM    136  N   GLU A  19     -27.484 -24.708   5.429  1.00 12.32           N  
ATOM    137  CA  GLU A  19     -26.456 -24.301   4.491  1.00 12.73           C  
ATOM    138  C   GLU A  19     -26.533 -22.827   4.145  1.00 15.46           C  
ATOM    139  O   GLU A  19     -27.506 -22.367   3.549  1.00 22.97           O  
ATOM    140  CB  GLU A  19     -26.529 -25.163   3.234  1.00 13.85           C  
ATOM    141  CG  GLU A  19     -25.440 -24.905   2.211  1.00 22.15           C  
ATOM    142  CD  GLU A  19     -25.403 -25.971   1.126  1.00 30.17           C  
ATOM    143  OE1 GLU A  19     -24.794 -27.046   1.362  1.00 35.95           O  
ATOM    144  OE2 GLU A  19     -25.988 -25.732   0.048  1.00 22.20           O  
ATOM    145  N   PRO A  20     -25.495 -22.057   4.497  1.00 15.55           N  
ATOM    146  CA  PRO A  20     -24.260 -22.438   5.193  1.00 14.36           C  
ATOM    147  C   PRO A  20     -24.522 -22.843   6.632  1.00 12.50           C  
ATOM    148  O   PRO A  20     -25.479 -22.379   7.236  1.00 18.04           O  
ATOM    149  CB  PRO A  20     -23.437 -21.153   5.136  1.00 17.36           C  
ATOM    150  CG  PRO A  20     -24.476 -20.087   5.171  1.00 17.06           C  
ATOM    151  CD  PRO A  20     -25.483 -20.620   4.178  1.00 12.97           C  
ATOM    152  N   ALA A  21     -23.694 -23.729   7.171  1.00 14.41           N  
ATOM    153  CA  ALA A  21     -23.873 -24.188   8.549  1.00 13.58           C  
ATOM    154  C   ALA A  21     -23.173 -23.283   9.548  1.00 17.03           C  
ATOM    155  O   ALA A  21     -23.344 -23.427  10.756  1.00 18.75           O  
ATOM    156  CB  ALA A  21     -23.385 -25.603   8.699  1.00 13.20           C  
ATOM    157  N   PHE A  22     -22.337 -22.390   9.032  1.00 16.12           N  
ATOM    158  CA  PHE A  22     -21.607 -21.438   9.847  1.00 16.30           C  
ATOM    159  C   PHE A  22     -21.795 -20.053   9.213  1.00 18.54           C  
ATOM    160  O   PHE A  22     -21.607 -19.890   8.001  1.00 14.40           O  
ATOM    161  CB  PHE A  22     -20.119 -21.809   9.908  1.00 15.91           C  
ATOM    162  CG  PHE A  22     -19.289 -20.823  10.666  1.00 17.52           C  
ATOM    163  CD1 PHE A  22     -19.368 -20.753  12.057  1.00 17.52           C  
ATOM    164  CD2 PHE A  22     -18.495 -19.900   9.987  1.00 14.79           C  
ATOM    165  CE1 PHE A  22     -18.675 -19.771  12.767  1.00 17.46           C  
ATOM    166  CE2 PHE A  22     -17.804 -18.920  10.682  1.00 16.36           C  
ATOM    167  CZ  PHE A  22     -17.896 -18.855  12.078  1.00 18.30           C  
ATOM    168  N   VAL A  23     -22.235 -19.092  10.025  1.00 13.82           N  
ATOM    169  CA  VAL A  23     -22.460 -17.718   9.589  1.00 16.31           C  
ATOM    170  C   VAL A  23     -21.748 -16.780  10.557  1.00 13.77           C  
ATOM    171  O   VAL A  23     -21.861 -16.925  11.777  1.00  9.76           O  
ATOM    172  CB  VAL A  23     -23.985 -17.370   9.556  1.00 23.78           C  
ATOM    173  CG1 VAL A  23     -24.207 -15.883   9.334  1.00 20.90           C  
ATOM    174  CG2 VAL A  23     -24.672 -18.140   8.454  1.00 21.09           C  
ATOM    175  N   ARG A  24     -20.969 -15.856  10.004  1.00 16.07           N  
ATOM    176  CA  ARG A  24     -20.242 -14.875  10.806  1.00 18.31           C  
ATOM    177  C   ARG A  24     -20.993 -13.546  10.709  1.00 14.32           C  
ATOM    178  O   ARG A  24     -20.988 -12.902   9.660  1.00 16.36           O  
ATOM    179  CB  ARG A  24     -18.806 -14.751  10.285  1.00 23.06           C  
ATOM    180  CG  ARG A  24     -17.938 -13.738  11.009  1.00 22.77           C  
ATOM    181  CD  ARG A  24     -17.913 -13.963  12.503  1.00 36.95           C  
ATOM    182  NE  ARG A  24     -17.251 -12.860  13.193  1.00 44.00           N  
ATOM    183  CZ  ARG A  24     -15.933 -12.759  13.340  1.00 49.65           C  
ATOM    184  NH1 ARG A  24     -15.112 -13.693  12.851  1.00 45.76           N  
ATOM    185  NH2 ARG A  24     -15.433 -11.708  13.969  1.00 52.21           N  
ATOM    186  N   ALA A  25     -21.670 -13.163  11.789  1.00 15.55           N  
ATOM    187  CA  ALA A  25     -22.463 -11.940  11.810  1.00 15.78           C  
ATOM    188  C   ALA A  25     -21.945 -10.891  12.795  1.00 19.69           C  
ATOM    189  O   ALA A  25     -21.026 -11.133  13.589  1.00 18.89           O  
ATOM    190  CB  ALA A  25     -23.913 -12.268  12.103  1.00 10.84           C  
ATOM    191  N   GLU A  26     -22.568  -9.725  12.744  1.00 22.43           N  
ATOM    192  CA  GLU A  26     -22.213  -8.602  13.590  1.00 24.99           C  
ATOM    193  C   GLU A  26     -23.485  -8.277  14.358  1.00 26.89           C  
ATOM    194  O   GLU A  26     -24.586  -8.632  13.922  1.00 27.71           O  
ATOM    195  CB  GLU A  26     -21.805  -7.423  12.698  1.00 30.59           C  
ATOM    196  CG  GLU A  26     -20.477  -6.762  13.058  1.00 40.12           C  
ATOM    197  CD  GLU A  26     -19.308  -7.732  13.113  1.00 45.56           C  
ATOM    198  OE1 GLU A  26     -18.883  -8.228  12.042  1.00 46.56           O  
ATOM    199  OE2 GLU A  26     -18.810  -7.982  14.236  1.00 47.49           O  
ATOM    200  N   PRO A  27     -23.361  -7.650  15.534  1.00 27.71           N  
ATOM    201  CA  PRO A  27     -24.579  -7.329  16.287  1.00 26.32           C  
ATOM    202  C   PRO A  27     -25.513  -6.466  15.427  1.00 26.54           C  
ATOM    203  O   PRO A  27     -25.050  -5.586  14.700  1.00 31.80           O  
ATOM    204  CB  PRO A  27     -24.027  -6.580  17.498  1.00 26.68           C  
ATOM    205  CG  PRO A  27     -22.647  -7.195  17.687  1.00 18.89           C  
ATOM    206  CD  PRO A  27     -22.150  -7.251  16.276  1.00 23.18           C  
ATOM    207  N   GLY A  28     -26.814  -6.738  15.487  1.00 25.39           N  
ATOM    208  CA  GLY A  28     -27.777  -5.994  14.682  1.00 28.54           C  
ATOM    209  C   GLY A  28     -28.092  -6.637  13.330  1.00 31.84           C  
ATOM    210  O   GLY A  28     -28.900  -6.107  12.546  1.00 33.31           O  
ATOM    211  N   ASP A  29     -27.428  -7.757  13.035  1.00 30.01           N  
ATOM    212  CA  ASP A  29     -27.633  -8.477  11.783  1.00 26.93           C  
ATOM    213  C   ASP A  29     -28.872  -9.353  11.849  1.00 23.51           C  
ATOM    214  O   ASP A  29     -29.299  -9.768  12.937  1.00 25.12           O  
ATOM    215  CB  ASP A  29     -26.411  -9.339  11.436  1.00 22.39           C  
ATOM    216  CG  ASP A  29     -25.303  -8.548  10.765  1.00 23.40           C  
ATOM    217  OD1 ASP A  29     -25.515  -7.368  10.421  1.00 25.29           O  
ATOM    218  OD2 ASP A  29     -24.212  -9.111  10.561  1.00 22.68           O  
ATOM    219  N   VAL A  30     -29.440  -9.619  10.682  1.00 15.99           N  
ATOM    220  CA  VAL A  30     -30.617 -10.456  10.572  1.00 19.15           C  
ATOM    221  C   VAL A  30     -30.228 -11.771   9.889  1.00 17.29           C  
ATOM    222  O   VAL A  30     -29.463 -11.778   8.924  1.00 15.37           O  
ATOM    223  CB  VAL A  30     -31.718  -9.741   9.769  1.00 20.09           C  
ATOM    224  CG1 VAL A  30     -32.968 -10.572   9.762  1.00 20.70           C  
ATOM    225  CG2 VAL A  30     -32.019  -8.392  10.392  1.00 18.86           C  
ATOM    226  N   ILE A  31     -30.684 -12.883  10.447  1.00 15.83           N  
ATOM    227  CA  ILE A  31     -30.401 -14.193   9.894  1.00 13.90           C  
ATOM    228  C   ILE A  31     -31.735 -14.789   9.496  1.00 12.94           C  
ATOM    229  O   ILE A  31     -32.606 -14.995  10.341  1.00  9.74           O  
ATOM    230  CB  ILE A  31     -29.790 -15.150  10.929  1.00 15.00           C  
ATOM    231  CG1 ILE A  31     -28.638 -14.493  11.690  1.00 11.43           C  
ATOM    232  CG2 ILE A  31     -29.315 -16.396  10.222  1.00 11.68           C  
ATOM    233  CD1 ILE A  31     -27.461 -14.200  10.845  1.00  8.46           C  
ATOM    234  N   ASN A  32     -31.909 -15.042   8.213  1.00 14.14           N  
ATOM    235  CA  ASN A  32     -33.141 -15.626   7.731  1.00 16.17           C  
ATOM    236  C   ASN A  32     -32.962 -17.123   7.480  1.00 18.90           C  
ATOM    237  O   ASN A  32     -32.095 -17.518   6.683  1.00 18.06           O  
ATOM    238  CB  ASN A  32     -33.575 -14.947   6.438  1.00 12.05           C  
ATOM    239  CG  ASN A  32     -34.079 -13.540   6.656  1.00 13.66           C  
ATOM    240  OD1 ASN A  32     -33.755 -12.641   5.888  1.00 15.49           O  
ATOM    241  ND2 ASN A  32     -34.909 -13.345   7.667  1.00 16.10           N  
ATOM    242  N   PHE A  33     -33.732 -17.949   8.197  1.00 14.87           N  
ATOM    243  CA  PHE A  33     -33.692 -19.402   8.003  1.00 14.31           C  
ATOM    244  C   PHE A  33     -34.813 -19.778   7.041  1.00 17.25           C  
ATOM    245  O   PHE A  33     -35.999 -19.637   7.352  1.00 17.00           O  
ATOM    246  CB  PHE A  33     -33.820 -20.129   9.328  1.00 13.92           C  
ATOM    247  CG  PHE A  33     -32.619 -19.954  10.217  1.00 12.00           C  
ATOM    248  CD1 PHE A  33     -31.482 -20.731  10.031  1.00 11.80           C  
ATOM    249  CD2 PHE A  33     -32.617 -18.998  11.221  1.00 12.70           C  
ATOM    250  CE1 PHE A  33     -30.352 -20.558  10.834  1.00 15.85           C  
ATOM    251  CE2 PHE A  33     -31.490 -18.815  12.030  1.00 15.35           C  
ATOM    252  CZ  PHE A  33     -30.356 -19.597  11.835  1.00 13.29           C  
ATOM    253  N   VAL A  34     -34.414 -20.187   5.844  1.00 18.12           N  
ATOM    254  CA  VAL A  34     -35.335 -20.529   4.782  1.00 20.07           C  
ATOM    255  C   VAL A  34     -35.408 -22.018   4.492  1.00 21.99           C  
ATOM    256  O   VAL A  34     -34.408 -22.630   4.119  1.00 20.08           O  
ATOM    257  CB  VAL A  34     -34.921 -19.811   3.495  1.00 22.75           C  
ATOM    258  CG1 VAL A  34     -35.919 -20.081   2.390  1.00 20.38           C  
ATOM    259  CG2 VAL A  34     -34.761 -18.330   3.771  1.00 14.49           C  
ATOM    260  N   PRO A  35     -36.605 -22.614   4.632  1.00 26.33           N  
ATOM    261  CA  PRO A  35     -36.785 -24.043   4.367  1.00 23.18           C  
ATOM    262  C   PRO A  35     -36.897 -24.266   2.865  1.00 22.50           C  
ATOM    263  O   PRO A  35     -37.951 -24.081   2.278  1.00 31.32           O  
ATOM    264  CB  PRO A  35     -38.093 -24.355   5.084  1.00 22.07           C  
ATOM    265  CG  PRO A  35     -38.884 -23.102   4.880  1.00 29.39           C  
ATOM    266  CD  PRO A  35     -37.865 -21.992   5.083  1.00 25.66           C  
ATOM    267  N   THR A  36     -35.776 -24.571   2.232  1.00 24.84           N  
ATOM    268  CA  THR A  36     -35.751 -24.838   0.800  1.00 23.27           C  
ATOM    269  C   THR A  36     -36.440 -26.191   0.545  1.00 24.23           C  
ATOM    270  O   THR A  36     -37.034 -26.420  -0.507  1.00 22.66           O  
ATOM    271  CB  THR A  36     -34.298 -24.835   0.285  1.00 21.22           C  
ATOM    272  OG1 THR A  36     -33.821 -23.483   0.250  1.00 31.19           O  
ATOM    273  CG2 THR A  36     -34.204 -25.421  -1.097  1.00 27.45           C  
ATOM    274  N   ASP A  37     -36.333 -27.092   1.512  1.00 22.69           N  
ATOM    275  CA  ASP A  37     -36.977 -28.392   1.425  1.00 26.57           C  
ATOM    276  C   ASP A  37     -37.916 -28.453   2.616  1.00 25.88           C  
ATOM    277  O   ASP A  37     -37.709 -27.758   3.612  1.00 29.83           O  
ATOM    278  CB  ASP A  37     -35.956 -29.532   1.521  1.00 31.03           C  
ATOM    279  CG  ASP A  37     -35.192 -29.751   0.230  1.00 33.11           C  
ATOM    280  OD1 ASP A  37     -35.807 -29.676  -0.851  1.00 41.22           O  
ATOM    281  OD2 ASP A  37     -33.976 -30.021   0.291  1.00 37.86           O  
ATOM    282  N   LYS A  38     -38.942 -29.283   2.520  1.00 25.47           N  
ATOM    283  CA  LYS A  38     -39.911 -29.414   3.599  1.00 31.33           C  
ATOM    284  C   LYS A  38     -39.457 -30.392   4.681  1.00 27.56           C  
ATOM    285  O   LYS A  38     -38.564 -31.197   4.442  1.00 24.44           O  
ATOM    286  CB  LYS A  38     -41.261 -29.852   3.026  1.00 32.89           C  
ATOM    287  CG  LYS A  38     -41.830 -28.856   2.034  1.00 43.78           C  
ATOM    288  CD  LYS A  38     -43.236 -29.214   1.571  1.00 51.90           C  
ATOM    289  CE  LYS A  38     -44.276 -29.001   2.658  1.00 51.15           C  
ATOM    290  NZ  LYS A  38     -45.650 -29.225   2.131  1.00 58.63           N  
ATOM    291  N   SER A  39     -40.078 -30.278   5.859  1.00 26.16           N  
ATOM    292  CA  SER A  39     -39.859 -31.103   7.052  1.00 22.89           C  
ATOM    293  C   SER A  39     -38.862 -30.554   8.046  1.00 22.64           C  
ATOM    294  O   SER A  39     -38.561 -31.225   9.049  1.00 14.80           O  
ATOM    295  CB  SER A  39     -39.448 -32.527   6.697  1.00 24.69           C  
ATOM    296  OG  SER A  39     -38.065 -32.582   6.399  1.00 37.65           O  
ATOM    297  N   HIS A  40     -38.361 -29.343   7.787  1.00 21.03           N  
ATOM    298  CA  HIS A  40     -37.368 -28.726   8.657  1.00 15.73           C  
ATOM    299  C   HIS A  40     -37.870 -27.510   9.413  1.00 18.58           C  
ATOM    300  O   HIS A  40     -38.784 -26.821   8.970  1.00 18.48           O  
ATOM    301  CB  HIS A  40     -36.153 -28.289   7.835  1.00 17.88           C  
ATOM    302  CG  HIS A  40     -35.601 -29.356   6.943  1.00 13.26           C  
ATOM    303  ND1 HIS A  40     -34.954 -30.457   7.445  1.00  9.60           N  
ATOM    304  CD2 HIS A  40     -35.677 -29.460   5.595  1.00  9.53           C  
ATOM    305  CE1 HIS A  40     -34.660 -31.205   6.405  1.00  9.62           C  
ATOM    306  NE2 HIS A  40     -35.078 -30.646   5.264  1.00 10.33           N  
ATOM    307  N   ASN A  41     -37.204 -27.228  10.525  1.00 16.84           N  
ATOM    308  CA  ASN A  41     -37.488 -26.075  11.365  1.00 20.05           C  
ATOM    309  C   ASN A  41     -36.138 -25.674  11.959  1.00 16.55           C  
ATOM    310  O   ASN A  41     -35.124 -26.288  11.643  1.00 22.63           O  
ATOM    311  CB  ASN A  41     -38.468 -26.434  12.484  1.00 17.50           C  
ATOM    312  CG  ASN A  41     -37.799 -27.135  13.649  1.00 20.10           C  
ATOM    313  OD1 ASN A  41     -36.923 -27.983  13.466  1.00 23.94           O  
ATOM    314  ND2 ASN A  41     -38.226 -26.799  14.861  1.00 14.61           N  
ATOM    315  N   VAL A  42     -36.112 -24.623  12.763  1.00 14.01           N  
ATOM    316  CA  VAL A  42     -34.877 -24.186  13.394  1.00 13.68           C  
ATOM    317  C   VAL A  42     -35.249 -23.881  14.827  1.00 15.38           C  
ATOM    318  O   VAL A  42     -36.283 -23.267  15.091  1.00 21.76           O  
ATOM    319  CB  VAL A  42     -34.244 -22.941  12.683  1.00 10.69           C  
ATOM    320  CG1 VAL A  42     -35.185 -21.766  12.705  1.00 14.28           C  
ATOM    321  CG2 VAL A  42     -32.926 -22.565  13.326  1.00 16.93           C  
ATOM    322  N   GLU A  43     -34.465 -24.412  15.753  1.00 13.56           N  
ATOM    323  CA  GLU A  43     -34.691 -24.205  17.163  1.00 12.13           C  
ATOM    324  C   GLU A  43     -33.326 -23.971  17.810  1.00 16.98           C  
ATOM    325  O   GLU A  43     -32.327 -24.576  17.423  1.00 16.52           O  
ATOM    326  CB  GLU A  43     -35.359 -25.432  17.756  1.00  9.44           C  
ATOM    327  CG  GLU A  43     -35.715 -25.291  19.222  1.00 17.55           C  
ATOM    328  CD  GLU A  43     -36.152 -26.604  19.864  1.00 26.69           C  
ATOM    329  OE1 GLU A  43     -36.449 -27.568  19.129  1.00 30.47           O  
ATOM    330  OE2 GLU A  43     -36.192 -26.677  21.111  1.00 32.47           O  
ATOM    331  N   ALA A  44     -33.276 -23.076  18.785  1.00 18.09           N  
ATOM    332  CA  ALA A  44     -32.026 -22.778  19.455  1.00 17.15           C  
ATOM    333  C   ALA A  44     -31.572 -23.934  20.322  1.00 17.49           C  
ATOM    334  O   ALA A  44     -32.392 -24.639  20.906  1.00 22.87           O  
ATOM    335  CB  ALA A  44     -32.186 -21.536  20.313  1.00 14.57           C  
ATOM    336  N   ILE A  45     -30.266 -24.154  20.378  1.00 17.02           N  
ATOM    337  CA  ILE A  45     -29.716 -25.180  21.250  1.00 14.95           C  
ATOM    338  C   ILE A  45     -29.455 -24.359  22.507  1.00 15.14           C  
ATOM    339  O   ILE A  45     -28.501 -23.613  22.551  1.00 22.20           O  
ATOM    340  CB  ILE A  45     -28.378 -25.709  20.725  1.00 12.56           C  
ATOM    341  CG1 ILE A  45     -28.562 -26.313  19.335  1.00 17.34           C  
ATOM    342  CG2 ILE A  45     -27.802 -26.742  21.690  1.00 10.88           C  
ATOM    343  CD1 ILE A  45     -27.325 -26.939  18.786  1.00 14.78           C  
ATOM    344  N   LYS A  46     -30.305 -24.475  23.517  1.00 22.63           N  
ATOM    345  CA  LYS A  46     -30.163 -23.684  24.746  1.00 27.86           C  
ATOM    346  C   LYS A  46     -28.790 -23.570  25.403  1.00 26.18           C  
ATOM    347  O   LYS A  46     -28.491 -22.546  26.007  1.00 30.99           O  
ATOM    348  CB  LYS A  46     -31.212 -24.103  25.780  1.00 35.18           C  
ATOM    349  CG  LYS A  46     -32.643 -23.791  25.353  1.00 50.28           C  
ATOM    350  CD  LYS A  46     -33.664 -24.530  26.225  1.00 64.54           C  
ATOM    351  CE  LYS A  46     -35.084 -24.452  25.639  1.00 71.34           C  
ATOM    352  NZ  LYS A  46     -36.080 -25.344  26.332  1.00 73.00           N  
ATOM    353  N   GLU A  47     -27.960 -24.605  25.302  1.00 27.78           N  
ATOM    354  CA  GLU A  47     -26.619 -24.558  25.901  1.00 29.13           C  
ATOM    355  C   GLU A  47     -25.692 -23.600  25.149  1.00 26.60           C  
ATOM    356  O   GLU A  47     -24.742 -23.068  25.720  1.00 30.36           O  
ATOM    357  CB  GLU A  47     -25.966 -25.952  25.933  1.00 32.22           C  
ATOM    358  CG  GLU A  47     -26.710 -27.015  26.747  1.00 46.94           C  
ATOM    359  CD  GLU A  47     -27.843 -27.681  25.974  1.00 52.21           C  
ATOM    360  OE1 GLU A  47     -27.603 -28.136  24.831  1.00 60.74           O  
ATOM    361  OE2 GLU A  47     -28.967 -27.767  26.515  1.00 53.86           O  
ATOM    362  N   ILE A  48     -25.970 -23.383  23.866  1.00 22.79           N  
ATOM    363  CA  ILE A  48     -25.154 -22.514  23.034  1.00 15.13           C  
ATOM    364  C   ILE A  48     -25.889 -21.239  22.666  1.00 15.74           C  
ATOM    365  O   ILE A  48     -26.314 -21.059  21.533  1.00 21.75           O  
ATOM    366  CB  ILE A  48     -24.700 -23.239  21.749  1.00 16.61           C  
ATOM    367  CG1 ILE A  48     -24.139 -24.616  22.108  1.00 11.10           C  
ATOM    368  CG2 ILE A  48     -23.646 -22.409  21.021  1.00 16.45           C  
ATOM    369  CD1 ILE A  48     -23.721 -25.432  20.936  1.00 20.06           C  
ATOM    370  N   LEU A  49     -26.053 -20.362  23.647  1.00 19.43           N  
ATOM    371  CA  LEU A  49     -26.702 -19.078  23.450  1.00 18.40           C  
ATOM    372  C   LEU A  49     -26.046 -18.026  24.325  1.00 22.87           C  
ATOM    373  O   LEU A  49     -25.582 -18.328  25.427  1.00 22.88           O  
ATOM    374  CB  LEU A  49     -28.175 -19.144  23.812  1.00 15.96           C  
ATOM    375  CG  LEU A  49     -29.167 -19.644  22.779  1.00 19.44           C  
ATOM    376  CD1 LEU A  49     -30.559 -19.380  23.313  1.00 21.83           C  
ATOM    377  CD2 LEU A  49     -28.972 -18.910  21.470  1.00 20.74           C  
ATOM    378  N   PRO A  50     -25.893 -16.796  23.798  1.00 25.66           N  
ATOM    379  CA  PRO A  50     -25.281 -15.736  24.596  1.00 25.02           C  
ATOM    380  C   PRO A  50     -26.187 -15.451  25.801  1.00 22.64           C  
ATOM    381  O   PRO A  50     -27.362 -15.806  25.817  1.00 23.19           O  
ATOM    382  CB  PRO A  50     -25.255 -14.549  23.618  1.00 17.54           C  
ATOM    383  CG  PRO A  50     -25.097 -15.205  22.306  1.00 20.07           C  
ATOM    384  CD  PRO A  50     -26.075 -16.351  22.405  1.00 24.24           C  
ATOM    385  N   GLU A  51     -25.609 -14.849  26.824  1.00 24.39           N  
ATOM    386  CA  GLU A  51     -26.329 -14.484  28.028  1.00 23.40           C  
ATOM    387  C   GLU A  51     -27.418 -13.494  27.639  1.00 24.44           C  
ATOM    388  O   GLU A  51     -27.172 -12.576  26.865  1.00 35.05           O  
ATOM    389  CB  GLU A  51     -25.348 -13.802  28.978  1.00 25.34           C  
ATOM    390  CG  GLU A  51     -25.747 -13.812  30.417  1.00 31.59           C  
ATOM    391  CD  GLU A  51     -25.621 -15.174  31.030  1.00 33.85           C  
ATOM    392  OE1 GLU A  51     -24.658 -15.891  30.681  1.00 33.97           O  
ATOM    393  OE2 GLU A  51     -26.489 -15.526  31.856  1.00 39.66           O  
ATOM    394  N   GLY A  52     -28.641 -13.713  28.106  1.00 33.81           N  
ATOM    395  CA  GLY A  52     -29.712 -12.781  27.803  1.00 35.30           C  
ATOM    396  C   GLY A  52     -30.538 -12.980  26.541  1.00 41.22           C  
ATOM    397  O   GLY A  52     -31.406 -12.143  26.253  1.00 44.71           O  
ATOM    398  N   VAL A  53     -30.257 -14.005  25.739  1.00 37.22           N  
ATOM    399  CA  VAL A  53     -31.092 -14.208  24.568  1.00 31.24           C  
ATOM    400  C   VAL A  53     -32.082 -15.334  24.840  1.00 32.04           C  
ATOM    401  O   VAL A  53     -31.730 -16.356  25.444  1.00 25.08           O  
ATOM    402  CB  VAL A  53     -30.297 -14.396  23.230  1.00 29.36           C  
ATOM    403  CG1 VAL A  53     -28.816 -14.289  23.450  1.00 22.18           C  
ATOM    404  CG2 VAL A  53     -30.695 -15.683  22.510  1.00 23.48           C  
ATOM    405  N   GLU A  54     -33.344 -15.065  24.508  1.00 33.15           N  
ATOM    406  CA  GLU A  54     -34.437 -16.021  24.679  1.00 38.05           C  
ATOM    407  C   GLU A  54     -34.332 -17.165  23.674  1.00 33.75           C  
ATOM    408  O   GLU A  54     -33.897 -16.961  22.532  1.00 30.05           O  
ATOM    409  CB  GLU A  54     -35.792 -15.325  24.473  1.00 47.56           C  
ATOM    410  CG  GLU A  54     -36.307 -14.507  25.652  1.00 61.07           C  
ATOM    411  CD  GLU A  54     -36.874 -15.357  26.789  1.00 68.37           C  
ATOM    412  OE1 GLU A  54     -37.001 -16.595  26.636  1.00 69.70           O  
ATOM    413  OE2 GLU A  54     -37.209 -14.774  27.845  1.00 76.89           O  
ATOM    414  N   SER A  55     -34.721 -18.360  24.112  1.00 27.33           N  
ATOM    415  CA  SER A  55     -34.727 -19.534  23.259  1.00 24.63           C  
ATOM    416  C   SER A  55     -35.812 -19.325  22.208  1.00 27.94           C  
ATOM    417  O   SER A  55     -36.788 -18.616  22.453  1.00 30.18           O  
ATOM    418  CB  SER A  55     -35.064 -20.773  24.070  1.00 28.50           C  
ATOM    419  OG  SER A  55     -35.356 -21.861  23.209  1.00 36.92           O  
ATOM    420  N   PHE A  56     -35.656 -19.950  21.048  1.00 28.25           N  
ATOM    421  CA  PHE A  56     -36.627 -19.809  19.970  1.00 25.65           C  
ATOM    422  C   PHE A  56     -36.873 -21.131  19.269  1.00 26.92           C  
ATOM    423  O   PHE A  56     -35.995 -22.001  19.261  1.00 28.01           O  
ATOM    424  CB  PHE A  56     -36.167 -18.753  18.960  1.00 24.43           C  
ATOM    425  CG  PHE A  56     -34.771 -18.970  18.420  1.00 26.70           C  
ATOM    426  CD1 PHE A  56     -33.659 -18.483  19.108  1.00 20.42           C  
ATOM    427  CD2 PHE A  56     -34.574 -19.630  17.209  1.00 20.83           C  
ATOM    428  CE1 PHE A  56     -32.374 -18.649  18.603  1.00 23.76           C  
ATOM    429  CE2 PHE A  56     -33.300 -19.801  16.695  1.00 23.23           C  
ATOM    430  CZ  PHE A  56     -32.188 -19.310  17.394  1.00 25.44           C  
ATOM    431  N   LYS A  57     -38.070 -21.279  18.700  1.00 24.04           N  
ATOM    432  CA  LYS A  57     -38.460 -22.492  17.979  1.00 23.56           C  
ATOM    433  C   LYS A  57     -39.478 -22.142  16.908  1.00 25.88           C  
ATOM    434  O   LYS A  57     -40.556 -21.637  17.231  1.00 33.88           O  
ATOM    435  CB  LYS A  57     -39.074 -23.507  18.942  1.00 20.59           C  
ATOM    436  CG  LYS A  57     -39.504 -24.798  18.280  1.00 25.40           C  
ATOM    437  CD  LYS A  57     -39.895 -25.839  19.299  1.00 29.45           C  
ATOM    438  CE  LYS A  57     -40.149 -27.195  18.632  1.00 43.24           C  
ATOM    439  NZ  LYS A  57     -40.167 -28.328  19.626  1.00 49.25           N  
ATOM    440  N   SER A  58     -39.143 -22.387  15.643  1.00 21.40           N  
ATOM    441  CA  SER A  58     -40.062 -22.082  14.550  1.00 23.59           C  
ATOM    442  C   SER A  58     -40.877 -23.309  14.192  1.00 26.75           C  
ATOM    443  O   SER A  58     -40.525 -24.430  14.582  1.00 25.59           O  
ATOM    444  CB  SER A  58     -39.301 -21.630  13.312  1.00 22.58           C  
ATOM    445  OG  SER A  58     -38.532 -22.700  12.797  1.00 24.62           O  
ATOM    446  N   LYS A  59     -41.958 -23.099  13.442  1.00 27.75           N  
ATOM    447  CA  LYS A  59     -42.818 -24.197  13.021  1.00 28.52           C  
ATOM    448  C   LYS A  59     -42.210 -24.843  11.775  1.00 29.02           C  
ATOM    449  O   LYS A  59     -41.506 -24.179  11.005  1.00 32.33           O  
ATOM    450  CB  LYS A  59     -44.232 -23.698  12.690  1.00 32.68           C  
ATOM    451  CG  LYS A  59     -45.025 -23.115  13.845  1.00 42.62           C  
ATOM    452  CD  LYS A  59     -46.387 -22.615  13.358  1.00 49.09           C  
ATOM    453  CE  LYS A  59     -47.134 -21.853  14.444  1.00 58.73           C  
ATOM    454  NZ  LYS A  59     -48.476 -21.388  13.978  1.00 65.71           N  
ATOM    455  N   ILE A  60     -42.494 -26.126  11.574  1.00 25.29           N  
ATOM    456  CA  ILE A  60     -41.989 -26.862  10.427  1.00 22.47           C  
ATOM    457  C   ILE A  60     -42.461 -26.241   9.123  1.00 21.63           C  
ATOM    458  O   ILE A  60     -43.576 -25.749   9.033  1.00 20.35           O  
ATOM    459  CB  ILE A  60     -42.380 -28.363  10.511  1.00 23.91           C  
ATOM    460  CG1 ILE A  60     -41.506 -29.051  11.558  1.00 18.56           C  
ATOM    461  CG2 ILE A  60     -42.207 -29.043   9.169  1.00 26.57           C  
ATOM    462  CD1 ILE A  60     -41.539 -30.546  11.487  1.00 30.48           C  
ATOM    463  N   ASN A  61     -41.573 -26.230   8.135  1.00 26.34           N  
ATOM    464  CA  ASN A  61     -41.823 -25.660   6.810  1.00 28.61           C  
ATOM    465  C   ASN A  61     -41.935 -24.137   6.789  1.00 28.22           C  
ATOM    466  O   ASN A  61     -42.234 -23.553   5.751  1.00 30.74           O  
ATOM    467  CB  ASN A  61     -43.060 -26.280   6.161  1.00 32.75           C  
ATOM    468  CG  ASN A  61     -42.953 -27.769   6.046  1.00 31.87           C  
ATOM    469  OD1 ASN A  61     -41.870 -28.294   5.841  1.00 34.12           O  
ATOM    470  ND2 ASN A  61     -44.068 -28.466   6.222  1.00 36.84           N  
ATOM    471  N   GLU A  62     -41.657 -23.487   7.911  1.00 25.01           N  
ATOM    472  CA  GLU A  62     -41.747 -22.030   7.967  1.00 27.34           C  
ATOM    473  C   GLU A  62     -40.412 -21.309   7.979  1.00 25.48           C  
ATOM    474  O   GLU A  62     -39.415 -21.847   8.463  1.00 25.43           O  
ATOM    475  CB  GLU A  62     -42.498 -21.588   9.211  1.00 30.19           C  
ATOM    476  CG  GLU A  62     -43.989 -21.548   9.079  1.00 40.69           C  
ATOM    477  CD  GLU A  62     -44.643 -20.866  10.256  1.00 46.53           C  
ATOM    478  OE1 GLU A  62     -43.918 -20.361  11.150  1.00 46.07           O  
ATOM    479  OE2 GLU A  62     -45.889 -20.834  10.282  1.00 53.55           O  
ATOM    480  N   SER A  63     -40.411 -20.079   7.462  1.00 24.36           N  
ATOM    481  CA  SER A  63     -39.223 -19.231   7.467  1.00 21.30           C  
ATOM    482  C   SER A  63     -39.132 -18.669   8.875  1.00 23.70           C  
ATOM    483  O   SER A  63     -40.153 -18.527   9.569  1.00 23.39           O  
ATOM    484  CB  SER A  63     -39.380 -18.040   6.518  1.00 18.74           C  
ATOM    485  OG  SER A  63     -39.153 -18.399   5.181  1.00 32.00           O  
ATOM    486  N   TYR A  64     -37.922 -18.343   9.302  1.00 20.90           N  
ATOM    487  CA  TYR A  64     -37.729 -17.765  10.620  1.00 21.15           C  
ATOM    488  C   TYR A  64     -36.684 -16.678  10.498  1.00 19.92           C  
ATOM    489  O   TYR A  64     -35.664 -16.871   9.827  1.00 22.52           O  
ATOM    490  CB  TYR A  64     -37.280 -18.820  11.623  1.00 24.31           C  
ATOM    491  CG  TYR A  64     -37.244 -18.283  13.028  1.00 31.95           C  
ATOM    492  CD1 TYR A  64     -38.424 -18.001  13.707  1.00 30.82           C  
ATOM    493  CD2 TYR A  64     -36.028 -17.998  13.661  1.00 32.49           C  
ATOM    494  CE1 TYR A  64     -38.396 -17.445  14.968  1.00 28.60           C  
ATOM    495  CE2 TYR A  64     -35.996 -17.442  14.926  1.00 26.45           C  
ATOM    496  CZ  TYR A  64     -37.185 -17.164  15.566  1.00 31.45           C  
ATOM    497  OH  TYR A  64     -37.172 -16.561  16.795  1.00 40.19           O  
ATOM    498  N   THR A  65     -36.972 -15.515  11.076  1.00 20.45           N  
ATOM    499  CA  THR A  65     -36.049 -14.375  11.040  1.00 18.47           C  
ATOM    500  C   THR A  65     -35.449 -14.109  12.420  1.00 16.72           C  
ATOM    501  O   THR A  65     -36.154 -13.735  13.356  1.00 15.93           O  
ATOM    502  CB  THR A  65     -36.738 -13.087  10.508  1.00 18.39           C  
ATOM    503  OG1 THR A  65     -37.194 -13.301   9.164  1.00 17.28           O  
ATOM    504  CG2 THR A  65     -35.764 -11.947  10.480  1.00 15.23           C  
ATOM    505  N   LEU A  66     -34.150 -14.350  12.538  1.00 17.02           N  
ATOM    506  CA  LEU A  66     -33.442 -14.156  13.790  1.00 20.74           C  
ATOM    507  C   LEU A  66     -32.594 -12.891  13.731  1.00 24.65           C  
ATOM    508  O   LEU A  66     -31.749 -12.735  12.852  1.00 27.53           O  
ATOM    509  CB  LEU A  66     -32.549 -15.367  14.075  1.00 18.19           C  
ATOM    510  CG  LEU A  66     -31.683 -15.338  15.330  1.00 15.92           C  
ATOM    511  CD1 LEU A  66     -32.574 -15.393  16.549  1.00 15.50           C  
ATOM    512  CD2 LEU A  66     -30.726 -16.510  15.319  1.00 14.39           C  
ATOM    513  N   THR A  67     -32.867 -11.961  14.635  1.00 26.61           N  
ATOM    514  CA  THR A  67     -32.107 -10.718  14.723  1.00 24.49           C  
ATOM    515  C   THR A  67     -31.125 -10.934  15.875  1.00 24.15           C  
ATOM    516  O   THR A  67     -31.526 -11.164  17.016  1.00 23.64           O  
ATOM    517  CB  THR A  67     -33.028  -9.524  15.029  1.00 25.09           C  
ATOM    518  OG1 THR A  67     -34.087  -9.478  14.061  1.00 32.31           O  
ATOM    519  CG2 THR A  67     -32.246  -8.229  14.967  1.00 25.80           C  
ATOM    520  N   VAL A  68     -29.841 -10.961  15.560  1.00 25.03           N  
ATOM    521  CA  VAL A  68     -28.835 -11.191  16.581  1.00 25.89           C  
ATOM    522  C   VAL A  68     -28.329  -9.883  17.136  1.00 29.12           C  
ATOM    523  O   VAL A  68     -27.749  -9.082  16.418  1.00 34.33           O  
ATOM    524  CB  VAL A  68     -27.639 -12.010  16.040  1.00 27.81           C  
ATOM    525  CG1 VAL A  68     -28.051 -13.450  15.819  1.00 27.14           C  
ATOM    526  CG2 VAL A  68     -27.111 -11.413  14.740  1.00 26.23           C  
ATOM    527  N   THR A  69     -28.562  -9.656  18.418  1.00 34.13           N  
ATOM    528  CA  THR A  69     -28.109  -8.428  19.048  1.00 34.47           C  
ATOM    529  C   THR A  69     -26.880  -8.682  19.910  1.00 27.36           C  
ATOM    530  O   THR A  69     -25.864  -8.011  19.759  1.00 27.74           O  
ATOM    531  CB  THR A  69     -29.228  -7.792  19.902  1.00 36.44           C  
ATOM    532  OG1 THR A  69     -30.381  -7.579  19.078  1.00 39.70           O  
ATOM    533  CG2 THR A  69     -28.771  -6.447  20.466  1.00 41.58           C  
ATOM    534  N   GLU A  70     -26.967  -9.691  20.771  1.00 22.97           N  
ATOM    535  CA  GLU A  70     -25.886 -10.036  21.682  1.00 23.65           C  
ATOM    536  C   GLU A  70     -24.741 -10.767  21.021  1.00 22.89           C  
ATOM    537  O   GLU A  70     -24.958 -11.592  20.138  1.00 27.93           O  
ATOM    538  CB  GLU A  70     -26.435 -10.884  22.824  1.00 19.43           C  
ATOM    539  CG  GLU A  70     -27.564 -10.206  23.548  1.00 16.88           C  
ATOM    540  CD  GLU A  70     -27.121  -8.913  24.192  1.00 28.82           C  
ATOM    541  OE1 GLU A  70     -26.196  -8.965  25.028  1.00 37.63           O  
ATOM    542  OE2 GLU A  70     -27.693  -7.856  23.868  1.00 29.91           O  
ATOM    543  N   PRO A  71     -23.495 -10.408  21.374  1.00 23.62           N  
ATOM    544  CA  PRO A  71     -22.344 -11.090  20.773  1.00 21.60           C  
ATOM    545  C   PRO A  71     -22.214 -12.469  21.436  1.00 19.15           C  
ATOM    546  O   PRO A  71     -22.759 -12.685  22.527  1.00 18.90           O  
ATOM    547  CB  PRO A  71     -21.177 -10.149  21.099  1.00 16.81           C  
ATOM    548  CG  PRO A  71     -21.593  -9.532  22.390  1.00 21.37           C  
ATOM    549  CD  PRO A  71     -23.069  -9.255  22.186  1.00 16.97           C  
ATOM    550  N   GLY A  72     -21.548 -13.399  20.753  1.00 17.87           N  
ATOM    551  CA  GLY A  72     -21.377 -14.750  21.264  1.00 13.72           C  
ATOM    552  C   GLY A  72     -21.777 -15.756  20.201  1.00 16.15           C  
ATOM    553  O   GLY A  72     -22.117 -15.368  19.082  1.00 18.14           O  
ATOM    554  N   LEU A  73     -21.767 -17.042  20.550  1.00 16.04           N  
ATOM    555  CA  LEU A  73     -22.128 -18.109  19.612  1.00 13.59           C  
ATOM    556  C   LEU A  73     -23.576 -18.504  19.785  1.00 17.67           C  
ATOM    557  O   LEU A  73     -24.054 -18.603  20.916  1.00 21.07           O  
ATOM    558  CB  LEU A  73     -21.254 -19.361  19.839  1.00 11.75           C  
ATOM    559  CG  LEU A  73     -19.744 -19.282  19.562  1.00  5.16           C  
ATOM    560  CD1 LEU A  73     -19.062 -20.562  19.999  1.00 13.55           C  
ATOM    561  CD2 LEU A  73     -19.482 -19.003  18.092  1.00  2.57           C  
ATOM    562  N   TYR A  74     -24.274 -18.715  18.672  1.00 17.96           N  
ATOM    563  CA  TYR A  74     -25.671 -19.139  18.702  1.00 15.31           C  
ATOM    564  C   TYR A  74     -25.710 -20.473  17.995  1.00 16.84           C  
ATOM    565  O   TYR A  74     -25.343 -20.556  16.820  1.00 15.58           O  
ATOM    566  CB  TYR A  74     -26.585 -18.191  17.920  1.00 19.17           C  
ATOM    567  CG  TYR A  74     -26.775 -16.798  18.486  1.00 16.05           C  
ATOM    568  CD1 TYR A  74     -25.717 -15.889  18.540  1.00 16.70           C  
ATOM    569  CD2 TYR A  74     -28.038 -16.357  18.870  1.00 14.61           C  
ATOM    570  CE1 TYR A  74     -25.915 -14.568  18.953  1.00 11.44           C  
ATOM    571  CE2 TYR A  74     -28.250 -15.037  19.284  1.00 19.43           C  
ATOM    572  CZ  TYR A  74     -27.180 -14.150  19.316  1.00 18.34           C  
ATOM    573  OH  TYR A  74     -27.391 -12.840  19.677  1.00 23.27           O  
ATOM    574  N   GLY A  75     -26.109 -21.518  18.711  1.00 16.50           N  
ATOM    575  CA  GLY A  75     -26.203 -22.832  18.107  1.00 17.74           C  
ATOM    576  C   GLY A  75     -27.657 -23.093  17.737  1.00 17.72           C  
ATOM    577  O   GLY A  75     -28.561 -22.775  18.505  1.00 19.98           O  
ATOM    578  N   VAL A  76     -27.904 -23.617  16.549  1.00 11.33           N  
ATOM    579  CA  VAL A  76     -29.270 -23.905  16.143  1.00 14.73           C  
ATOM    580  C   VAL A  76     -29.347 -25.339  15.665  1.00 15.14           C  
ATOM    581  O   VAL A  76     -28.356 -25.930  15.246  1.00 14.25           O  
ATOM    582  CB  VAL A  76     -29.813 -22.946  15.027  1.00 10.50           C  
ATOM    583  CG1 VAL A  76     -29.793 -21.514  15.517  1.00  9.76           C  
ATOM    584  CG2 VAL A  76     -29.009 -23.098  13.737  1.00  7.34           C  
ATOM    585  N   LYS A  77     -30.539 -25.905  15.749  1.00 17.71           N  
ATOM    586  CA  LYS A  77     -30.761 -27.276  15.329  1.00 20.05           C  
ATOM    587  C   LYS A  77     -32.123 -27.390  14.672  1.00 21.43           C  
ATOM    588  O   LYS A  77     -32.952 -26.471  14.744  1.00 22.65           O  
ATOM    589  CB  LYS A  77     -30.750 -28.189  16.552  1.00 20.26           C  
ATOM    590  CG  LYS A  77     -31.971 -28.010  17.461  1.00 16.64           C  
ATOM    591  CD  LYS A  77     -31.787 -28.753  18.761  1.00 16.21           C  
ATOM    592  CE  LYS A  77     -33.066 -28.797  19.575  1.00 22.49           C  
ATOM    593  NZ  LYS A  77     -32.849 -29.502  20.882  1.00 27.65           N  
ATOM    594  N   CYS A  78     -32.325 -28.502  13.984  1.00 20.57           N  
ATOM    595  CA  CYS A  78     -33.611 -28.800  13.377  1.00 20.08           C  
ATOM    596  C   CYS A  78     -34.179 -29.898  14.272  1.00 21.94           C  
ATOM    597  O   CYS A  78     -33.685 -31.027  14.273  1.00 22.36           O  
ATOM    598  CB  CYS A  78     -33.454 -29.319  11.964  1.00 18.51           C  
ATOM    599  SG  CYS A  78     -35.021 -29.998  11.376  1.00 20.31           S  
ATOM    600  N   THR A  79     -35.212 -29.560  15.032  1.00 25.67           N  
ATOM    601  CA  THR A  79     -35.845 -30.473  15.985  1.00 25.64           C  
ATOM    602  C   THR A  79     -35.981 -31.946  15.570  1.00 24.91           C  
ATOM    603  O   THR A  79     -35.502 -32.831  16.271  1.00 27.89           O  
ATOM    604  CB  THR A  79     -37.213 -29.918  16.446  1.00 30.84           C  
ATOM    605  OG1 THR A  79     -37.090 -28.514  16.736  1.00 31.78           O  
ATOM    606  CG2 THR A  79     -37.684 -30.639  17.697  1.00 32.37           C  
ATOM    607  N   PRO A  80     -36.646 -32.233  14.437  1.00 24.68           N  
ATOM    608  CA  PRO A  80     -36.762 -33.642  14.064  1.00 18.02           C  
ATOM    609  C   PRO A  80     -35.490 -34.312  13.554  1.00 22.08           C  
ATOM    610  O   PRO A  80     -35.378 -35.533  13.574  1.00 29.13           O  
ATOM    611  CB  PRO A  80     -37.848 -33.624  12.992  1.00 15.30           C  
ATOM    612  CG  PRO A  80     -37.734 -32.272  12.377  1.00 20.88           C  
ATOM    613  CD  PRO A  80     -37.488 -31.382  13.569  1.00 28.16           C  
ATOM    614  N   HIS A  81     -34.501 -33.530  13.151  1.00 24.98           N  
ATOM    615  CA  HIS A  81     -33.290 -34.126  12.612  1.00 17.48           C  
ATOM    616  C   HIS A  81     -32.020 -33.866  13.391  1.00 15.25           C  
ATOM    617  O   HIS A  81     -30.934 -34.031  12.863  1.00 23.24           O  
ATOM    618  CB  HIS A  81     -33.131 -33.700  11.166  1.00 18.52           C  
ATOM    619  CG  HIS A  81     -34.358 -33.937  10.345  1.00 27.77           C  
ATOM    620  ND1 HIS A  81     -34.873 -32.970   9.526  1.00 33.35           N  
ATOM    621  CD2 HIS A  81     -35.153 -35.032  10.295  1.00 32.21           C  
ATOM    622  CE1 HIS A  81     -35.963 -33.486   8.996  1.00 29.27           C  
ATOM    623  NE2 HIS A  81     -36.175 -34.733   9.431  1.00 33.51           N  
ATOM    624  N   PHE A  82     -32.154 -33.455  14.644  1.00 14.82           N  
ATOM    625  CA  PHE A  82     -31.008 -33.191  15.512  1.00 15.74           C  
ATOM    626  C   PHE A  82     -30.132 -34.445  15.533  1.00 17.19           C  
ATOM    627  O   PHE A  82     -28.931 -34.370  15.290  1.00 24.62           O  
ATOM    628  CB  PHE A  82     -31.511 -32.892  16.929  1.00 11.49           C  
ATOM    629  CG  PHE A  82     -30.467 -32.354  17.866  1.00 15.53           C  
ATOM    630  CD1 PHE A  82     -29.381 -31.619  17.401  1.00 15.94           C  
ATOM    631  CD2 PHE A  82     -30.609 -32.529  19.234  1.00 12.04           C  
ATOM    632  CE1 PHE A  82     -28.450 -31.058  18.296  1.00 14.82           C  
ATOM    633  CE2 PHE A  82     -29.682 -31.969  20.135  1.00 15.53           C  
ATOM    634  CZ  PHE A  82     -28.605 -31.234  19.663  1.00 11.62           C  
ATOM    635  N   GLY A  83     -30.770 -35.597  15.727  1.00 18.14           N  
ATOM    636  CA  GLY A  83     -30.070 -36.876  15.796  1.00 17.15           C  
ATOM    637  C   GLY A  83     -29.312 -37.239  14.545  1.00 16.56           C  
ATOM    638  O   GLY A  83     -28.310 -37.943  14.606  1.00 17.47           O  
ATOM    639  N   MET A  84     -29.801 -36.764  13.407  1.00 20.05           N  
ATOM    640  CA  MET A  84     -29.144 -37.015  12.129  1.00 23.04           C  
ATOM    641  C   MET A  84     -28.092 -35.935  11.838  1.00 24.51           C  
ATOM    642  O   MET A  84     -27.515 -35.915  10.749  1.00 24.53           O  
ATOM    643  CB  MET A  84     -30.168 -37.095  10.996  1.00 25.44           C  
ATOM    644  CG  MET A  84     -31.063 -38.322  11.058  1.00 26.46           C  
ATOM    645  SD  MET A  84     -32.413 -38.146   9.897  1.00 38.92           S  
ATOM    646  CE  MET A  84     -31.629 -38.725   8.414  1.00 35.50           C  
ATOM    647  N   GLY A  85     -27.867 -35.046  12.816  1.00 23.50           N  
ATOM    648  CA  GLY A  85     -26.870 -33.987  12.706  1.00 21.29           C  
ATOM    649  C   GLY A  85     -27.205 -32.652  12.047  1.00 22.08           C  
ATOM    650  O   GLY A  85     -26.295 -31.885  11.726  1.00 17.07           O  
ATOM    651  N   MET A  86     -28.483 -32.329  11.883  1.00 19.92           N  
ATOM    652  CA  MET A  86     -28.840 -31.066  11.248  1.00 20.64           C  
ATOM    653  C   MET A  86     -28.713 -29.875  12.210  1.00 26.10           C  
ATOM    654  O   MET A  86     -29.716 -29.403  12.756  1.00 27.55           O  
ATOM    655  CB  MET A  86     -30.243 -31.165  10.659  1.00 15.79           C  
ATOM    656  CG  MET A  86     -30.658 -29.984   9.841  1.00 17.90           C  
ATOM    657  SD  MET A  86     -31.968 -30.424   8.682  1.00 21.09           S  
ATOM    658  CE  MET A  86     -32.262 -28.822   7.919  1.00 20.88           C  
ATOM    659  N   VAL A  87     -27.470 -29.427  12.443  1.00 29.02           N  
ATOM    660  CA  VAL A  87     -27.170 -28.288  13.329  1.00 22.43           C  
ATOM    661  C   VAL A  87     -26.436 -27.172  12.596  1.00 20.33           C  
ATOM    662  O   VAL A  87     -25.780 -27.407  11.571  1.00 21.88           O  
ATOM    663  CB  VAL A  87     -26.312 -28.684  14.563  1.00 16.55           C  
ATOM    664  CG1 VAL A  87     -27.070 -29.631  15.441  1.00 13.69           C  
ATOM    665  CG2 VAL A  87     -25.001 -29.299  14.137  1.00 14.16           C  
ATOM    666  N   GLY A  88     -26.532 -25.967  13.147  1.00 21.95           N  
ATOM    667  CA  GLY A  88     -25.888 -24.803  12.570  1.00 15.95           C  
ATOM    668  C   GLY A  88     -25.306 -23.940  13.674  1.00 16.48           C  
ATOM    669  O   GLY A  88     -25.758 -24.020  14.820  1.00 16.77           O  
ATOM    670  N   LEU A  89     -24.327 -23.104  13.326  1.00 14.70           N  
ATOM    671  CA  LEU A  89     -23.667 -22.221  14.279  1.00 14.29           C  
ATOM    672  C   LEU A  89     -23.541 -20.803  13.729  1.00 19.32           C  
ATOM    673  O   LEU A  89     -23.148 -20.611  12.572  1.00 19.45           O  
ATOM    674  CB  LEU A  89     -22.258 -22.746  14.595  1.00 14.22           C  
ATOM    675  CG  LEU A  89     -21.467 -22.041  15.699  1.00 14.22           C  
ATOM    676  CD1 LEU A  89     -22.220 -22.142  17.018  1.00 16.42           C  
ATOM    677  CD2 LEU A  89     -20.100 -22.659  15.851  1.00 14.26           C  
ATOM    678  N   VAL A  90     -23.889 -19.820  14.555  1.00 19.20           N  
ATOM    679  CA  VAL A  90     -23.766 -18.407  14.191  1.00 19.82           C  
ATOM    680  C   VAL A  90     -22.823 -17.724  15.194  1.00 16.85           C  
ATOM    681  O   VAL A  90     -22.984 -17.864  16.411  1.00 17.80           O  
ATOM    682  CB  VAL A  90     -25.120 -17.672  14.244  1.00 16.15           C  
ATOM    683  CG1 VAL A  90     -24.968 -16.295  13.662  1.00  4.90           C  
ATOM    684  CG2 VAL A  90     -26.176 -18.461  13.507  1.00  9.07           C  
ATOM    685  N   GLN A  91     -21.813 -17.033  14.688  1.00 17.52           N  
ATOM    686  CA  GLN A  91     -20.875 -16.326  15.558  1.00 17.89           C  
ATOM    687  C   GLN A  91     -21.077 -14.842  15.416  1.00 13.22           C  
ATOM    688  O   GLN A  91     -20.828 -14.286  14.344  1.00 14.95           O  
ATOM    689  CB  GLN A  91     -19.424 -16.634  15.188  1.00 24.89           C  
ATOM    690  CG  GLN A  91     -18.418 -15.951  16.104  1.00 24.61           C  
ATOM    691  CD  GLN A  91     -17.001 -15.983  15.567  1.00 24.68           C  
ATOM    692  OE1 GLN A  91     -16.625 -16.875  14.812  1.00 22.11           O  
ATOM    693  NE2 GLN A  91     -16.200 -15.011  15.969  1.00 26.40           N  
ATOM    694  N   VAL A  92     -21.543 -14.199  16.479  1.00 16.65           N  
ATOM    695  CA  VAL A  92     -21.756 -12.759  16.448  1.00 17.82           C  
ATOM    696  C   VAL A  92     -20.597 -12.038  17.159  1.00 19.22           C  
ATOM    697  O   VAL A  92     -20.398 -12.187  18.371  1.00 18.88           O  
ATOM    698  CB  VAL A  92     -23.120 -12.390  17.079  1.00 18.24           C  
ATOM    699  CG1 VAL A  92     -23.396 -10.906  16.919  1.00 14.02           C  
ATOM    700  CG2 VAL A  92     -24.227 -13.199  16.418  1.00 13.40           C  
ATOM    701  N   GLY A  93     -19.804 -11.297  16.389  1.00 21.36           N  
ATOM    702  CA  GLY A  93     -18.685 -10.565  16.957  1.00 17.19           C  
ATOM    703  C   GLY A  93     -17.468 -11.433  17.175  1.00 27.47           C  
ATOM    704  O   GLY A  93     -17.485 -12.634  16.899  1.00 33.01           O  
ATOM    705  N   ASP A  94     -16.396 -10.824  17.661  1.00 33.69           N  
ATOM    706  CA  ASP A  94     -15.149 -11.542  17.910  1.00 38.37           C  
ATOM    707  C   ASP A  94     -15.096 -12.196  19.278  1.00 36.75           C  
ATOM    708  O   ASP A  94     -15.886 -11.883  20.160  1.00 39.30           O  
ATOM    709  CB  ASP A  94     -13.955 -10.595  17.775  1.00 49.85           C  
ATOM    710  CG  ASP A  94     -13.318 -10.652  16.406  1.00 60.78           C  
ATOM    711  OD1 ASP A  94     -12.668 -11.675  16.095  1.00 70.11           O  
ATOM    712  OD2 ASP A  94     -13.458  -9.668  15.646  1.00 68.87           O  
ATOM    713  N   ALA A  95     -14.129 -13.092  19.439  1.00 37.85           N  
ATOM    714  CA  ALA A  95     -13.905 -13.808  20.683  1.00 36.17           C  
ATOM    715  C   ALA A  95     -15.195 -14.147  21.415  1.00 34.96           C  
ATOM    716  O   ALA A  95     -15.565 -13.482  22.387  1.00 39.77           O  
ATOM    717  CB  ALA A  95     -12.972 -13.004  21.578  1.00 33.97           C  
ATOM    718  N   PRO A  96     -15.912 -15.172  20.937  1.00 32.73           N  
ATOM    719  CA  PRO A  96     -17.170 -15.602  21.549  1.00 29.19           C  
ATOM    720  C   PRO A  96     -16.920 -15.957  23.005  1.00 27.85           C  
ATOM    721  O   PRO A  96     -16.057 -16.776  23.320  1.00 30.81           O  
ATOM    722  CB  PRO A  96     -17.528 -16.843  20.742  1.00 31.19           C  
ATOM    723  CG  PRO A  96     -16.915 -16.573  19.415  1.00 32.34           C  
ATOM    724  CD  PRO A  96     -15.574 -16.030  19.792  1.00 31.32           C  
ATOM    725  N   GLU A  97     -17.679 -15.333  23.888  1.00 25.51           N  
ATOM    726  CA  GLU A  97     -17.559 -15.563  25.312  1.00 25.86           C  
ATOM    727  C   GLU A  97     -17.974 -16.976  25.715  1.00 28.94           C  
ATOM    728  O   GLU A  97     -17.434 -17.531  26.673  1.00 36.10           O  
ATOM    729  CB  GLU A  97     -18.409 -14.535  26.054  1.00 25.60           C  
ATOM    730  CG  GLU A  97     -18.259 -14.544  27.567  1.00 38.65           C  
ATOM    731  CD  GLU A  97     -19.008 -13.394  28.245  1.00 44.15           C  
ATOM    732  OE1 GLU A  97     -18.780 -12.228  27.835  1.00 39.47           O  
ATOM    733  OE2 GLU A  97     -19.810 -13.664  29.182  1.00 43.01           O  
ATOM    734  N   ASN A  98     -18.925 -17.558  24.984  1.00 30.26           N  
ATOM    735  CA  ASN A  98     -19.429 -18.910  25.282  1.00 25.31           C  
ATOM    736  C   ASN A  98     -18.838 -20.032  24.441  1.00 22.45           C  
ATOM    737  O   ASN A  98     -19.438 -21.099  24.326  1.00 22.47           O  
ATOM    738  CB  ASN A  98     -20.961 -18.953  25.196  1.00 22.88           C  
ATOM    739  CG  ASN A  98     -21.498 -18.557  23.827  1.00 21.39           C  
ATOM    740  OD1 ASN A  98     -20.779 -18.017  22.990  1.00 32.58           O  
ATOM    741  ND2 ASN A  98     -22.781 -18.790  23.613  1.00 21.11           N  
ATOM    742  N   LEU A  99     -17.631 -19.816  23.929  1.00 22.53           N  
ATOM    743  CA  LEU A  99     -16.959 -20.803  23.095  1.00 28.67           C  
ATOM    744  C   LEU A  99     -16.847 -22.154  23.775  1.00 32.25           C  
ATOM    745  O   LEU A  99     -17.012 -23.188  23.131  1.00 37.58           O  
ATOM    746  CB  LEU A  99     -15.564 -20.320  22.717  1.00 24.54           C  
ATOM    747  CG  LEU A  99     -14.740 -21.322  21.915  1.00 23.92           C  
ATOM    748  CD1 LEU A  99     -15.316 -21.469  20.512  1.00 19.99           C  
ATOM    749  CD2 LEU A  99     -13.315 -20.850  21.851  1.00 20.99           C  
ATOM    750  N   ASP A 100     -16.575 -22.159  25.075  1.00 37.52           N  
ATOM    751  CA  ASP A 100     -16.439 -23.424  25.788  1.00 40.28           C  
ATOM    752  C   ASP A 100     -17.720 -24.191  26.019  1.00 37.12           C  
ATOM    753  O   ASP A 100     -17.688 -25.406  26.187  1.00 38.17           O  
ATOM    754  CB  ASP A 100     -15.639 -23.264  27.074  1.00 50.13           C  
ATOM    755  CG  ASP A 100     -14.157 -23.535  26.855  1.00 62.91           C  
ATOM    756  OD1 ASP A 100     -13.532 -22.827  26.028  1.00 65.66           O  
ATOM    757  OD2 ASP A 100     -13.624 -24.487  27.467  1.00 70.24           O  
ATOM    758  N   ALA A 101     -18.848 -23.491  25.992  1.00 37.72           N  
ATOM    759  CA  ALA A 101     -20.151 -24.135  26.167  1.00 33.79           C  
ATOM    760  C   ALA A 101     -20.439 -24.880  24.866  1.00 32.09           C  
ATOM    761  O   ALA A 101     -20.877 -26.034  24.876  1.00 30.69           O  
ATOM    762  CB  ALA A 101     -21.235 -23.083  26.429  1.00 30.84           C  
ATOM    763  N   ALA A 102     -20.115 -24.224  23.753  1.00 28.76           N  
ATOM    764  CA  ALA A 102     -20.327 -24.787  22.430  1.00 29.00           C  
ATOM    765  C   ALA A 102     -19.454 -26.010  22.246  1.00 28.42           C  
ATOM    766  O   ALA A 102     -19.883 -26.996  21.651  1.00 29.45           O  
ATOM    767  CB  ALA A 102     -20.016 -23.752  21.365  1.00 20.23           C  
ATOM    768  N   LYS A 103     -18.233 -25.938  22.768  1.00 27.14           N  
ATOM    769  CA  LYS A 103     -17.272 -27.032  22.658  1.00 27.12           C  
ATOM    770  C   LYS A 103     -17.599 -28.245  23.507  1.00 30.54           C  
ATOM    771  O   LYS A 103     -17.199 -29.361  23.169  1.00 36.95           O  
ATOM    772  CB  LYS A 103     -15.866 -26.550  23.027  1.00 24.39           C  
ATOM    773  CG  LYS A 103     -15.259 -25.582  22.045  1.00 35.72           C  
ATOM    774  CD  LYS A 103     -13.894 -25.079  22.512  1.00 44.55           C  
ATOM    775  CE  LYS A 103     -12.828 -26.163  22.487  1.00 50.02           C  
ATOM    776  NZ  LYS A 103     -11.476 -25.592  22.751  1.00 60.99           N  
ATOM    777  N   THR A 104     -18.322 -28.041  24.604  1.00 29.82           N  
ATOM    778  CA  THR A 104     -18.634 -29.143  25.497  1.00 26.66           C  
ATOM    779  C   THR A 104     -20.103 -29.522  25.612  1.00 28.04           C  
ATOM    780  O   THR A 104     -20.429 -30.492  26.289  1.00 32.84           O  
ATOM    781  CB  THR A 104     -18.100 -28.855  26.896  1.00 28.28           C  
ATOM    782  OG1 THR A 104     -18.685 -27.642  27.372  1.00 33.68           O  
ATOM    783  CG2 THR A 104     -16.605 -28.671  26.864  1.00 28.62           C  
ATOM    784  N   ALA A 105     -20.995 -28.769  24.981  1.00 32.15           N  
ATOM    785  CA  ALA A 105     -22.426 -29.081  25.049  1.00 33.21           C  
ATOM    786  C   ALA A 105     -22.700 -30.540  24.654  1.00 34.34           C  
ATOM    787  O   ALA A 105     -22.252 -31.013  23.600  1.00 32.86           O  
ATOM    788  CB  ALA A 105     -23.229 -28.126  24.161  1.00 28.55           C  
ATOM    789  N   LYS A 106     -23.410 -31.253  25.529  1.00 33.32           N  
ATOM    790  CA  LYS A 106     -23.740 -32.655  25.304  1.00 31.85           C  
ATOM    791  C   LYS A 106     -24.818 -32.745  24.230  1.00 29.30           C  
ATOM    792  O   LYS A 106     -25.854 -32.081  24.312  1.00 30.78           O  
ATOM    793  CB  LYS A 106     -24.226 -33.279  26.610  1.00 38.55           C  
ATOM    794  CG  LYS A 106     -23.967 -34.783  26.750  1.00 59.94           C  
ATOM    795  CD  LYS A 106     -24.847 -35.650  25.826  1.00 69.41           C  
ATOM    796  CE  LYS A 106     -26.345 -35.525  26.148  1.00 72.38           C  
ATOM    797  NZ  LYS A 106     -27.215 -36.304  25.210  1.00 70.32           N  
ATOM    798  N   MET A 107     -24.570 -33.556  23.212  1.00 26.75           N  
ATOM    799  CA  MET A 107     -25.541 -33.704  22.140  1.00 26.45           C  
ATOM    800  C   MET A 107     -25.339 -35.011  21.364  1.00 25.38           C  
ATOM    801  O   MET A 107     -24.327 -35.694  21.550  1.00 28.92           O  
ATOM    802  CB  MET A 107     -25.481 -32.477  21.219  1.00 23.94           C  
ATOM    803  CG  MET A 107     -24.097 -32.083  20.762  1.00 29.61           C  
ATOM    804  SD  MET A 107     -24.142 -30.647  19.656  1.00 27.38           S  
ATOM    805  CE  MET A 107     -24.404 -29.372  20.795  1.00 23.92           C  
ATOM    806  N   PRO A 108     -26.331 -35.409  20.538  1.00 22.03           N  
ATOM    807  CA  PRO A 108     -26.280 -36.636  19.722  1.00 20.68           C  
ATOM    808  C   PRO A 108     -24.975 -36.682  18.926  1.00 23.62           C  
ATOM    809  O   PRO A 108     -24.593 -35.675  18.326  1.00 26.97           O  
ATOM    810  CB  PRO A 108     -27.487 -36.482  18.793  1.00 17.51           C  
ATOM    811  CG  PRO A 108     -28.456 -35.718  19.619  1.00 19.65           C  
ATOM    812  CD  PRO A 108     -27.601 -34.687  20.324  1.00 19.77           C  
ATOM    813  N   LYS A 109     -24.325 -37.843  18.859  1.00 23.49           N  
ATOM    814  CA  LYS A 109     -23.041 -37.929  18.175  1.00 28.29           C  
ATOM    815  C   LYS A 109     -22.865 -37.245  16.821  1.00 27.04           C  
ATOM    816  O   LYS A 109     -21.881 -36.521  16.635  1.00 29.23           O  
ATOM    817  CB  LYS A 109     -22.501 -39.365  18.139  1.00 38.13           C  
ATOM    818  CG  LYS A 109     -23.260 -40.347  17.273  1.00 49.84           C  
ATOM    819  CD  LYS A 109     -22.537 -41.691  17.244  1.00 55.83           C  
ATOM    820  CE  LYS A 109     -21.145 -41.564  16.655  1.00 59.07           C  
ATOM    821  NZ  LYS A 109     -21.190 -41.156  15.223  1.00 66.23           N  
ATOM    822  N   LYS A 110     -23.799 -37.437  15.892  1.00 22.76           N  
ATOM    823  CA  LYS A 110     -23.667 -36.812  14.574  1.00 30.80           C  
ATOM    824  C   LYS A 110     -23.706 -35.289  14.676  1.00 32.41           C  
ATOM    825  O   LYS A 110     -22.929 -34.597  14.004  1.00 33.81           O  
ATOM    826  CB  LYS A 110     -24.735 -37.310  13.591  1.00 31.98           C  
ATOM    827  CG  LYS A 110     -24.603 -38.776  13.226  1.00 41.59           C  
ATOM    828  CD  LYS A 110     -25.636 -39.192  12.182  1.00 54.31           C  
ATOM    829  CE  LYS A 110     -25.580 -40.693  11.887  1.00 55.03           C  
ATOM    830  NZ  LYS A 110     -26.602 -41.099  10.877  1.00 59.23           N  
ATOM    831  N   ALA A 111     -24.571 -34.782  15.555  1.00 30.54           N  
ATOM    832  CA  ALA A 111     -24.716 -33.343  15.770  1.00 24.69           C  
ATOM    833  C   ALA A 111     -23.434 -32.787  16.382  1.00 24.37           C  
ATOM    834  O   ALA A 111     -22.973 -31.702  16.009  1.00 24.96           O  
ATOM    835  CB  ALA A 111     -25.904 -33.067  16.667  1.00 13.48           C  
ATOM    836  N   ARG A 112     -22.855 -33.555  17.301  1.00 19.82           N  
ATOM    837  CA  ARG A 112     -21.619 -33.186  17.962  1.00 20.23           C  
ATOM    838  C   ARG A 112     -20.466 -33.185  16.942  1.00 21.22           C  
ATOM    839  O   ARG A 112     -19.625 -32.293  16.951  1.00 25.92           O  
ATOM    840  CB  ARG A 112     -21.369 -34.136  19.147  1.00 19.40           C  
ATOM    841  CG  ARG A 112     -20.080 -33.919  19.914  1.00 16.31           C  
ATOM    842  CD  ARG A 112     -19.614 -32.465  19.892  1.00 23.66           C  
ATOM    843  NE  ARG A 112     -20.320 -31.607  20.828  1.00 23.36           N  
ATOM    844  CZ  ARG A 112     -20.138 -30.292  20.911  1.00 27.73           C  
ATOM    845  NH1 ARG A 112     -19.281 -29.677  20.100  1.00 24.53           N  
ATOM    846  NH2 ARG A 112     -20.790 -29.598  21.841  1.00 22.17           N  
ATOM    847  N   GLU A 113     -20.457 -34.141  16.025  1.00 23.96           N  
ATOM    848  CA  GLU A 113     -19.415 -34.184  15.004  1.00 24.45           C  
ATOM    849  C   GLU A 113     -19.510 -32.972  14.069  1.00 23.43           C  
ATOM    850  O   GLU A 113     -18.501 -32.400  13.660  1.00 29.13           O  
ATOM    851  CB  GLU A 113     -19.535 -35.471  14.196  1.00 33.80           C  
ATOM    852  CG  GLU A 113     -19.214 -36.725  15.004  1.00 43.60           C  
ATOM    853  CD  GLU A 113     -19.489 -38.023  14.254  1.00 49.73           C  
ATOM    854  OE1 GLU A 113     -19.844 -37.986  13.047  1.00 55.88           O  
ATOM    855  OE2 GLU A 113     -19.350 -39.089  14.889  1.00 52.95           O  
ATOM    856  N   ARG A 114     -20.728 -32.585  13.725  1.00 21.29           N  
ATOM    857  CA  ARG A 114     -20.926 -31.442  12.859  1.00 19.84           C  
ATOM    858  C   ARG A 114     -20.688 -30.121  13.558  1.00 18.13           C  
ATOM    859  O   ARG A 114     -20.144 -29.205  12.963  1.00 22.95           O  
ATOM    860  CB  ARG A 114     -22.303 -31.489  12.204  1.00 20.84           C  
ATOM    861  CG  ARG A 114     -22.341 -32.491  11.054  1.00 22.96           C  
ATOM    862  CD  ARG A 114     -23.509 -32.265  10.135  1.00 21.74           C  
ATOM    863  NE  ARG A 114     -23.533 -33.248   9.055  1.00 25.95           N  
ATOM    864  CZ  ARG A 114     -24.629 -33.617   8.399  1.00 24.28           C  
ATOM    865  NH1 ARG A 114     -25.807 -33.095   8.724  1.00 19.91           N  
ATOM    866  NH2 ARG A 114     -24.536 -34.460   7.373  1.00 26.74           N  
ATOM    867  N   MET A 115     -21.046 -30.036  14.833  1.00 20.29           N  
ATOM    868  CA  MET A 115     -20.838 -28.819  15.607  1.00 16.61           C  
ATOM    869  C   MET A 115     -19.332 -28.550  15.695  1.00 20.12           C  
ATOM    870  O   MET A 115     -18.888 -27.418  15.495  1.00 22.26           O  
ATOM    871  CB  MET A 115     -21.449 -28.965  17.005  1.00 13.92           C  
ATOM    872  CG  MET A 115     -21.441 -27.697  17.849  1.00 14.24           C  
ATOM    873  SD  MET A 115     -22.065 -26.269  16.925  1.00 20.02           S  
ATOM    874  CE  MET A 115     -23.754 -26.259  17.294  1.00 19.11           C  
ATOM    875  N   ASP A 116     -18.551 -29.604  15.922  1.00 19.34           N  
ATOM    876  CA  ASP A 116     -17.092 -29.496  16.032  1.00 16.11           C  
ATOM    877  C   ASP A 116     -16.483 -29.005  14.748  1.00 15.65           C  
ATOM    878  O   ASP A 116     -15.484 -28.305  14.773  1.00 22.74           O  
ATOM    879  CB  ASP A 116     -16.458 -30.854  16.358  1.00 14.55           C  
ATOM    880  CG  ASP A 116     -16.589 -31.240  17.813  1.00 15.57           C  
ATOM    881  OD1 ASP A 116     -16.853 -30.371  18.673  1.00 26.29           O  
ATOM    882  OD2 ASP A 116     -16.413 -32.435  18.104  1.00 32.17           O  
ATOM    883  N   ALA A 117     -17.035 -29.457  13.626  1.00 18.50           N  
ATOM    884  CA  ALA A 117     -16.558 -29.066  12.302  1.00 16.33           C  
ATOM    885  C   ALA A 117     -16.819 -27.577  12.111  1.00 19.80           C  
ATOM    886  O   ALA A 117     -15.988 -26.842  11.560  1.00 23.73           O  
ATOM    887  CB  ALA A 117     -17.284 -29.864  11.234  1.00  9.12           C  
ATOM    888  N   GLU A 118     -17.981 -27.135  12.581  1.00 22.56           N  
ATOM    889  CA  GLU A 118     -18.378 -25.736  12.490  1.00 19.87           C  
ATOM    890  C   GLU A 118     -17.557 -24.874  13.456  1.00 20.93           C  
ATOM    891  O   GLU A 118     -17.181 -23.753  13.118  1.00 24.40           O  
ATOM    892  CB  GLU A 118     -19.869 -25.605  12.775  1.00 20.02           C  
ATOM    893  CG  GLU A 118     -20.741 -26.223  11.684  1.00 26.34           C  
ATOM    894  CD  GLU A 118     -22.180 -26.498  12.137  1.00 32.54           C  
ATOM    895  OE1 GLU A 118     -22.613 -25.942  13.171  1.00 38.83           O  
ATOM    896  OE2 GLU A 118     -22.886 -27.280  11.462  1.00 30.21           O  
ATOM    897  N   LEU A 119     -17.239 -25.410  14.636  1.00 20.82           N  
ATOM    898  CA  LEU A 119     -16.437 -24.678  15.618  1.00 17.47           C  
ATOM    899  C   LEU A 119     -15.056 -24.379  15.089  1.00 17.14           C  
ATOM    900  O   LEU A 119     -14.446 -23.393  15.490  1.00 21.34           O  
ATOM    901  CB  LEU A 119     -16.323 -25.438  16.940  1.00 18.41           C  
ATOM    902  CG  LEU A 119     -17.598 -25.357  17.785  1.00 19.79           C  
ATOM    903  CD1 LEU A 119     -17.459 -26.215  19.009  1.00 18.83           C  
ATOM    904  CD2 LEU A 119     -17.871 -23.914  18.178  1.00 18.58           C  
ATOM    905  N   ALA A 120     -14.581 -25.206  14.160  1.00 19.12           N  
ATOM    906  CA  ALA A 120     -13.260 -25.020  13.570  1.00 20.61           C  
ATOM    907  C   ALA A 120     -13.188 -23.801  12.673  1.00 21.77           C  
ATOM    908  O   ALA A 120     -12.107 -23.434  12.235  1.00 30.21           O  
ATOM    909  CB  ALA A 120     -12.833 -26.244  12.806  1.00 14.99           C  
ATOM    910  N   GLN A 121     -14.331 -23.208  12.350  1.00 21.03           N  
ATOM    911  CA  GLN A 121     -14.332 -22.021  11.505  1.00 23.87           C  
ATOM    912  C   GLN A 121     -14.368 -20.760  12.361  1.00 28.48           C  
ATOM    913  O   GLN A 121     -14.351 -19.646  11.833  1.00 27.19           O  
ATOM    914  CB  GLN A 121     -15.543 -22.017  10.567  1.00 25.11           C  
ATOM    915  CG  GLN A 121     -15.451 -22.964   9.387  1.00 34.76           C  
ATOM    916  CD  GLN A 121     -16.527 -22.693   8.349  1.00 44.20           C  
ATOM    917  OE1 GLN A 121     -17.619 -23.276   8.389  1.00 52.47           O  
ATOM    918  NE2 GLN A 121     -16.236 -21.786   7.421  1.00 49.25           N  
ATOM    919  N   VAL A 122     -14.425 -20.945  13.676  1.00 28.73           N  
ATOM    920  CA  VAL A 122     -14.507 -19.836  14.604  1.00 32.29           C  
ATOM    921  C   VAL A 122     -13.276 -18.957  14.737  1.00 42.66           C  
ATOM    922  O   VAL A 122     -12.164 -19.453  14.911  1.00 44.41           O  
ATOM    923  CB  VAL A 122     -14.969 -20.316  15.985  1.00 24.91           C  
ATOM    924  CG1 VAL A 122     -14.783 -19.230  17.026  1.00 26.26           C  
ATOM    925  CG2 VAL A 122     -16.430 -20.696  15.914  1.00 18.52           C  
ATOM    926  N   ASN A 123     -13.540 -17.647  14.710  1.00 56.73           N  
ATOM    927  CA  ASN A 123     -12.565 -16.553  14.836  1.00 65.94           C  
ATOM    928  C   ASN A 123     -11.727 -16.291  13.599  1.00 70.76           C  
ATOM    929  O   ASN A 123     -11.883 -15.181  13.048  1.00 75.44           O  
ATOM    930  CB  ASN A 123     -11.672 -16.706  16.082  1.00 69.22           C  
ATOM    931  CG  ASN A 123     -12.145 -15.850  17.267  1.00 70.48           C  
ATOM    932  OD1 ASN A 123     -12.271 -16.390  18.392  1.00 66.62           O  
ATOM    933  ND2 ASN A 123     -12.372 -14.633  17.077  1.00 70.08           N  
ATOM    934  OXT ASN A 123     -10.936 -17.173  13.196  1.00 75.97           O  
TER     935      ASN A 123                                                      
END
MOLECULE T0390.pdb
ATOM   1417  N   ALA    29     -25.126  -7.662   1.817  1.00100.22           N  
ATOM   1418  CA  ALA    29     -24.203  -6.752   2.561  1.00102.70           C  
ATOM   1419  CB  ALA    29     -24.370  -5.286   2.082  1.00105.39           C  
ATOM   1420  C   ALA    29     -24.440  -6.859   4.069  1.00100.61           C  
ATOM   1421  O   ALA    29     -23.542  -6.584   4.874  1.00103.55           O  
ATOM   1422  N   ASP    30     -25.642  -7.297   4.438  1.00 95.26           N  
ATOM   1423  CA  ASP    30     -26.174  -7.076   5.775  1.00 90.56           C  
ATOM   1424  CB  ASP    30     -27.168  -5.921   5.687  1.00 92.74           C  
ATOM   1425  CG  ASP    30     -27.589  -5.421   7.032  1.00 94.90           C  
ATOM   1426  OD1 ASP    30     -26.753  -5.488   7.957  1.00 97.71           O  
ATOM   1427  OD2 ASP    30     -28.748  -4.962   7.166  1.00 95.01           O  
ATOM   1428  C   ASP    30     -26.877  -8.312   6.349  1.00 85.08           C  
ATOM   1429  O   ASP    30     -26.918  -8.504   7.567  1.00 84.01           O  
ATOM   1430  N   ARG    31     -27.450  -9.130   5.464  1.00 79.52           N  
ATOM   1431  CA  ARG    31     -28.160 -10.341   5.860  1.00 73.24           C  
ATOM   1432  CB  ARG    31     -29.676 -10.248   5.558  1.00 73.02           C  
ATOM   1433  CG  ARG    31     -30.128  -9.281   4.458  1.00 71.63           C  
ATOM   1434  CD  ARG    31     -31.576  -8.824   4.658  1.00 70.77           C  
ATOM   1435  NE  ARG    31     -32.323  -9.800   5.444  1.00 70.30           N  
ATOM   1436  CZ  ARG    31     -33.224  -9.495   6.379  1.00 69.91           C  
ATOM   1437  NH1 ARG    31     -33.825 -10.465   7.068  1.00 64.29           N  
ATOM   1438  NH2 ARG    31     -33.513  -8.226   6.639  1.00 66.83           N  
ATOM   1439  C   ARG    31     -27.541 -11.632   5.309  1.00 70.84           C  
ATOM   1440  O   ARG    31     -27.034 -11.668   4.203  1.00 72.53           O  
ATOM   1441  N   HIS    32     -27.579 -12.687   6.107  1.00 67.66           N  
ATOM   1442  CA  HIS    32     -26.995 -13.968   5.743  1.00 65.70           C  
ATOM   1443  CB  HIS    32     -26.038 -14.432   6.839  1.00 64.57           C  
ATOM   1444  CG  HIS    32     -25.079 -13.377   7.294  1.00 65.98           C  
ATOM   1445  ND1 HIS    32     -23.753 -13.361   6.918  1.00 68.45           N  
ATOM   1446  CE1 HIS    32     -23.147 -12.327   7.473  1.00 68.52           C  
ATOM   1447  NE2 HIS    32     -24.034 -11.668   8.197  1.00 70.63           N  
ATOM   1448  CD2 HIS    32     -25.247 -12.309   8.110  1.00 68.60           C  
ATOM   1449  C   HIS    32     -28.097 -15.016   5.529  1.00 64.32           C  
ATOM   1450  O   HIS    32     -29.034 -15.140   6.326  1.00 64.73           O  
ATOM   1451  N   THR    33     -27.991 -15.763   4.443  1.00 64.18           N  
ATOM   1452  CA  THR    33     -29.026 -16.716   4.069  1.00 61.66           C  
ATOM   1453  CB  THR    33     -29.371 -16.572   2.588  1.00 60.48           C  
ATOM   1454  OG1 THR    33     -29.757 -15.222   2.336  1.00 64.06           O  
ATOM   1455  CG2 THR    33     -30.515 -17.473   2.204  1.00 60.36           C  
ATOM   1456  C   THR    33     -28.563 -18.133   4.345  1.00 60.90           C  
ATOM   1457  O   THR    33     -27.470 -18.523   3.937  1.00 61.38           O  
ATOM   1458  N   VAL    34     -29.394 -18.893   5.050  1.00 59.79           N  
ATOM   1459  CA  VAL    34     -29.129 -20.304   5.279  1.00 58.71           C  
ATOM   1460  CB  VAL    34     -28.924 -20.615   6.781  1.00 58.54           C  
ATOM   1461  CG1 VAL    34     -28.753 -22.122   7.003  1.00 54.88           C  
ATOM   1462  CG2 VAL    34     -27.724 -19.842   7.322  1.00 58.10           C  
ATOM   1463  C   VAL    34     -30.292 -21.119   4.737  1.00 58.02           C  
ATOM   1464  O   VAL    34     -31.439 -20.929   5.132  1.00 57.92           O  
ATOM   1465  N   PHE    35     -29.997 -22.021   3.816  1.00 58.93           N  
ATOM   1466  CA  PHE    35     -31.014 -22.945   3.330  1.00 57.38           C  
ATOM   1467  CB  PHE    35     -30.754 -23.313   1.873  1.00 56.05           C  
ATOM   1468  CG  PHE    35     -30.974 -22.168   0.935  1.00 57.38           C  
ATOM   1469  CD1 PHE    35     -29.944 -21.264   0.661  1.00 58.82           C  
ATOM   1470  CE1 PHE    35     -30.149 -20.180  -0.191  1.00 57.97           C  
ATOM   1471  CZ  PHE    35     -31.402 -19.989  -0.771  1.00 58.81           C  
ATOM   1472  CE2 PHE    35     -32.447 -20.877  -0.492  1.00 56.51           C  
ATOM   1473  CD2 PHE    35     -32.230 -21.953   0.363  1.00 58.39           C  
ATOM   1474  C   PHE    35     -31.087 -24.155   4.248  1.00 58.31           C  
ATOM   1475  O   PHE    35     -30.221 -25.039   4.194  1.00 59.87           O  
ATOM   1476  N   TRP    36     -32.103 -24.175   5.118  1.00 56.23           N  
ATOM   1477  CA  TRP    36     -32.240 -25.269   6.062  1.00 54.10           C  
ATOM   1478  CB  TRP    36     -33.030 -24.851   7.307  1.00 52.43           C  
ATOM   1479  CG  TRP    36     -32.664 -25.690   8.480  1.00 50.06           C  
ATOM   1480  CD1 TRP    36     -33.078 -26.955   8.722  1.00 50.33           C  
ATOM   1481  NE1 TRP    36     -32.518 -27.428   9.883  1.00 54.82           N  
ATOM   1482  CE2 TRP    36     -31.709 -26.461  10.418  1.00 54.47           C  
ATOM   1483  CD2 TRP    36     -31.769 -25.344   9.551  1.00 52.76           C  
ATOM   1484  CE3 TRP    36     -31.039 -24.192   9.881  1.00 53.93           C  
ATOM   1485  CZ3 TRP    36     -30.269 -24.199  11.060  1.00 53.49           C  
ATOM   1486  CH2 TRP    36     -30.216 -25.339  11.891  1.00 51.75           C  
ATOM   1487  CZ2 TRP    36     -30.924 -26.476  11.588  1.00 51.62           C  
ATOM   1488  C   TRP    36     -32.884 -26.471   5.415  1.00 54.79           C  
ATOM   1489  O   TRP    36     -34.088 -26.652   5.506  1.00 55.66           O  
ATOM   1490  N   ASN    37     -32.095 -27.299   4.748  1.00 57.05           N  
ATOM   1491  CA  ASN    37     -32.637 -28.573   4.245  1.00 59.69           C  
ATOM   1492  CB  ASN    37     -33.492 -28.399   2.962  1.00 59.25           C  
ATOM   1493  CG  ASN    37     -32.663 -28.102   1.708  1.00 63.24           C  
ATOM   1494  OD1 ASN    37     -31.855 -28.934   1.251  1.00 65.74           O  
ATOM   1495  ND2 ASN    37     -32.895 -26.924   1.119  1.00 67.21           N  
ATOM   1496  C   ASN    37     -31.539 -29.627   4.114  1.00 60.96           C  
ATOM   1497  O   ASN    37     -30.354 -29.274   4.027  1.00 62.64           O  
ATOM   1498  N   SER    38     -31.916 -30.903   4.110  1.00 60.38           N  
ATOM   1499  CA  SER    38     -30.911 -31.965   4.214  1.00 63.35           C  
ATOM   1500  CB  SER    38     -31.532 -33.268   4.692  1.00 64.11           C  
ATOM   1501  OG  SER    38     -32.155 -33.900   3.602  1.00 70.02           O  
ATOM   1502  C   SER    38     -30.080 -32.216   2.954  1.00 63.69           C  
ATOM   1503  O   SER    38     -29.178 -33.033   2.998  1.00 63.92           O  
ATOM   1504  N   SER    39     -30.385 -31.519   1.856  1.00 63.86           N  
ATOM   1505  CA  SER    39     -29.558 -31.551   0.639  1.00 64.78           C  
ATOM   1506  CB  SER    39     -30.398 -31.342  -0.618  1.00 63.72           C  
ATOM   1507  OG  SER    39     -31.246 -32.437  -0.826  1.00 67.02           O  
ATOM   1508  C   SER    39     -28.510 -30.464   0.641  1.00 64.68           C  
ATOM   1509  O   SER    39     -27.688 -30.405  -0.267  1.00 68.02           O  
ATOM   1510  N   ASN    40     -28.573 -29.562   1.611  1.00 62.24           N  
ATOM   1511  CA  ASN    40     -27.614 -28.481   1.656  1.00 61.94           C  
ATOM   1512  CB  ASN    40     -28.096 -27.368   2.590  1.00 59.83           C  
ATOM   1513  CG  ASN    40     -27.194 -26.152   2.559  1.00 59.19           C  
ATOM   1514  OD1 ASN    40     -26.036 -26.220   2.101  1.00 59.05           O  
ATOM   1515  ND2 ASN    40     -27.716 -25.020   3.038  1.00 52.18           N  
ATOM   1516  C   ASN    40     -26.279 -29.030   2.130  1.00 62.98           C  
ATOM   1517  O   ASN    40     -26.143 -29.337   3.314  1.00 65.11           O  
ATOM   1518  N   PRO    41     -25.284 -29.124   1.226  1.00 63.55           N  
ATOM   1519  CA  PRO    41     -24.003 -29.741   1.548  1.00 64.85           C  
ATOM   1520  CB  PRO    41     -23.161 -29.492   0.286  1.00 66.12           C  
ATOM   1521  CG  PRO    41     -24.138 -29.321  -0.799  1.00 65.91           C  
ATOM   1522  CD  PRO    41     -25.298 -28.614  -0.158  1.00 64.70           C  
ATOM   1523  C   PRO    41     -23.309 -29.122   2.757  1.00 65.52           C  
ATOM   1524  O   PRO    41     -22.517 -29.791   3.419  1.00 66.69           O  
ATOM   1525  N   LYS    42     -23.600 -27.861   3.053  1.00 62.16           N  
ATOM   1526  CA  LYS    42     -22.900 -27.169   4.135  1.00 64.34           C  
ATOM   1527  CB  LYS    42     -23.244 -25.682   4.133  1.00 63.63           C  
ATOM   1528  CG  LYS    42     -22.820 -25.020   2.851  1.00 62.79           C  
ATOM   1529  CD  LYS    42     -22.705 -23.542   3.001  1.00 64.18           C  
ATOM   1530  CE  LYS    42     -22.140 -22.977   1.727  1.00 68.95           C  
ATOM   1531  NZ  LYS    42     -22.825 -21.712   1.400  1.00 74.60           N  
ATOM   1532  C   LYS    42     -23.112 -27.783   5.511  1.00 65.92           C  
ATOM   1533  O   LYS    42     -22.289 -27.611   6.401  1.00 68.21           O  
ATOM   1534  N   PHE    43     -24.204 -28.528   5.656  1.00 67.42           N  
ATOM   1535  CA  PHE    43     -24.552 -29.227   6.882  1.00 69.26           C  
ATOM   1536  CB  PHE    43     -26.053 -29.547   6.881  1.00 68.78           C  
ATOM   1537  CG  PHE    43     -26.924 -28.367   7.194  1.00 70.15           C  
ATOM   1538  CD1 PHE    43     -26.880 -27.767   8.448  1.00 70.44           C  
ATOM   1539  CE1 PHE    43     -27.676 -26.680   8.742  1.00 72.10           C  
ATOM   1540  CZ  PHE    43     -28.537 -26.175   7.786  1.00 70.06           C  
ATOM   1541  CE2 PHE    43     -28.591 -26.758   6.534  1.00 70.66           C  
ATOM   1542  CD2 PHE    43     -27.787 -27.853   6.240  1.00 69.34           C  
ATOM   1543  C   PHE    43     -23.773 -30.525   7.054  1.00 72.65           C  
ATOM   1544  O   PHE    43     -23.779 -31.128   8.144  1.00 74.80           O  
ATOM   1545  N   ARG    44     -23.136 -30.972   5.972  1.00 73.67           N  
ATOM   1546  CA  ARG    44     -22.502 -32.284   5.941  1.00 77.35           C  
ATOM   1547  CB  ARG    44     -22.077 -32.683   4.518  1.00 77.02           C  
ATOM   1548  CG  ARG    44     -21.282 -33.978   4.439  1.00 80.74           C  
ATOM   1549  CD  ARG    44     -21.486 -34.745   3.146  1.00 81.73           C  
ATOM   1550  NE  ARG    44     -21.030 -33.978   1.996  1.00 76.92           N  
ATOM   1551  CZ  ARG    44     -21.830 -33.528   1.042  1.00 71.12           C  
ATOM   1552  NH1 ARG    44     -23.122 -33.781   1.075  1.00 65.89           N  
ATOM   1553  NH2 ARG    44     -21.329 -32.832   0.046  1.00 73.50           N  
ATOM   1554  C   ARG    44     -21.350 -32.397   6.936  1.00 81.28           C  
ATOM   1555  O   ARG    44     -21.137 -33.462   7.494  1.00 84.45           O  
ATOM   1556  N   ASN    45     -20.623 -31.320   7.196  1.00 83.31           N  
ATOM   1557  CA  ASN    45     -19.516 -31.458   8.129  1.00 89.14           C  
ATOM   1558  CB  ASN    45     -18.325 -30.589   7.706  1.00 90.67           C  
ATOM   1562  C   ASN    45     -19.916 -31.277   9.611  1.00 91.62           C  
ATOM   1563  O   ASN    45     -19.147 -31.615  10.520  1.00 93.86           O  
ATOM   1564  N   GLU    46     -21.134 -30.775   9.842  1.00 91.09           N  
ATOM   1565  CA  GLU    46     -21.671 -30.506  11.198  1.00 92.01           C  
ATOM   1566  CB  GLU    46     -21.888 -31.807  11.993  1.00 94.29           C  
ATOM   1567  CG  GLU    46     -22.673 -32.872  11.210  1.00 95.61           C  
ATOM   1568  CD  GLU    46     -23.036 -34.121  12.024  1.00 99.79           C  
ATOM   1569  OE1 GLU    46     -22.526 -34.300  13.160  1.00103.61           O  
ATOM   1570  OE2 GLU    46     -23.840 -34.935  11.507  1.00101.22           O  
ATOM   1571  C   GLU    46     -20.797 -29.487  11.942  1.00 91.41           C  
ATOM   1572  O   GLU    46     -20.872 -29.328  13.166  1.00 92.29           O  
ATOM   1573  N   ASP    47     -19.977 -28.798  11.151  1.00 89.12           N  
ATOM   1574  CA  ASP    47     -19.143 -27.686  11.586  1.00 87.14           C  
ATOM   1575  CB  ASP    47     -17.695 -27.903  11.124  1.00 89.68           C  
ATOM   1576  CG  ASP    47     -17.562 -28.039   9.587  1.00 90.74           C  
ATOM   1577  OD1 ASP    47     -18.585 -28.119   8.855  1.00 86.38           O  
ATOM   1578  OD2 ASP    47     -16.405 -28.084   9.107  1.00 97.26           O  
ATOM   1579  C   ASP    47     -19.679 -26.375  10.998  1.00 82.03           C  
ATOM   1580  O   ASP    47     -19.103 -25.319  11.209  1.00 81.44           O  
ATOM   1581  N   TYR    48     -20.770 -26.462  10.242  1.00 77.20           N  
ATOM   1582  CA  TYR    48     -21.382 -25.302   9.609  1.00 74.21           C  
ATOM   1583  CB  TYR    48     -22.776 -25.676   9.067  1.00 73.30           C  
ATOM   1584  CG  TYR    48     -23.420 -24.667   8.120  1.00 71.47           C  
ATOM   1585  CD1 TYR    48     -24.744 -24.834   7.695  1.00 70.66           C  
ATOM   1586  CE1 TYR    48     -25.343 -23.923   6.819  1.00 68.10           C  
ATOM   1587  CZ  TYR    48     -24.620 -22.830   6.373  1.00 68.15           C  
ATOM   1588  OH  TYR    48     -25.197 -21.932   5.519  1.00 67.00           O  
ATOM   1589  CE2 TYR    48     -23.306 -22.637   6.772  1.00 68.50           C  
ATOM   1590  CD2 TYR    48     -22.712 -23.550   7.644  1.00 70.49           C  
ATOM   1591  C   TYR    48     -21.477 -24.102  10.558  1.00 73.61           C  
ATOM   1592  O   TYR    48     -22.263 -24.101  11.524  1.00 75.01           O  
ATOM   1593  N   THR    49     -20.664 -23.088  10.297  1.00 70.93           N  
ATOM   1594  CA  THR    49     -20.736 -21.870  11.090  1.00 69.64           C  
ATOM   1595  CB  THR    49     -19.715 -21.855  12.277  1.00 71.04           C  
ATOM   1596  OG1 THR    49     -19.033 -20.605  12.302  1.00 71.14           O  
ATOM   1597  CG2 THR    49     -18.697 -22.930  12.166  1.00 68.82           C  
ATOM   1598  C   THR    49     -20.658 -20.593  10.240  1.00 67.14           C  
ATOM   1599  O   THR    49     -19.863 -20.517   9.341  1.00 65.65           O  
ATOM   1600  N   ILE    50     -21.514 -19.613  10.523  1.00 66.24           N  
ATOM   1601  CA  ILE    50     -21.489 -18.336   9.811  1.00 64.98           C  
ATOM   1602  CB  ILE    50     -22.823 -18.008   9.090  1.00 65.33           C  
ATOM   1603  CG1 ILE    50     -23.910 -17.657  10.099  1.00 65.90           C  
ATOM   1604  CD1 ILE    50     -25.306 -17.700   9.521  1.00 73.93           C  
ATOM   1605  CG2 ILE    50     -23.256 -19.148   8.131  1.00 61.42           C  
ATOM   1606  C   ILE    50     -21.133 -17.213  10.787  1.00 65.67           C  
ATOM   1607  O   ILE    50     -21.490 -17.266  11.967  1.00 67.03           O  
ATOM   1608  N   HIS    51     -20.416 -16.212  10.284  1.00 64.25           N  
ATOM   1609  CA  HIS    51     -19.943 -15.105  11.084  1.00 63.60           C  
ATOM   1610  CB  HIS    51     -18.461 -14.901  10.835  1.00 65.49           C  
ATOM   1611  CG  HIS    51     -17.630 -16.088  11.195  1.00 70.79           C  
ATOM   1612  ND1 HIS    51     -16.951 -16.185  12.391  1.00 72.94           N  
ATOM   1613  CE1 HIS    51     -16.306 -17.337  12.435  1.00 74.97           C  
ATOM   1614  NE2 HIS    51     -16.554 -17.996  11.315  1.00 76.53           N  
ATOM   1615  CD2 HIS    51     -17.379 -17.236  10.521  1.00 73.32           C  
ATOM   1616  C   HIS    51     -20.703 -13.827  10.766  1.00 62.09           C  
ATOM   1617  O   HIS    51     -20.801 -13.415   9.603  1.00 61.03           O  
ATOM   1618  N   VAL    52     -21.230 -13.201  11.812  1.00 69.61           N  
ATOM   1619  CA  VAL    52     -22.065 -12.016  11.665  1.00 70.27           C  
ATOM   1620  CB  VAL    52     -23.525 -12.331  12.044  1.00 67.94           C  
ATOM   1621  CG1 VAL    52     -24.048 -13.516  11.256  1.00 63.91           C  
ATOM   1622  CG2 VAL    52     -23.629 -12.617  13.529  1.00 68.74           C  
ATOM   1623  C   VAL    52     -21.559 -10.871  12.551  1.00 73.22           C  
ATOM   1624  O   VAL    52     -20.790 -11.094  13.483  1.00 76.04           O  
ATOM   1625  N   GLN    53     -21.982  -9.646  12.255  1.00 74.46           N  
ATOM   1626  CA  GLN    53     -21.798  -8.534  13.178  1.00 75.33           C  
ATOM   1627  CB  GLN    53     -21.370  -7.303  12.422  1.00 77.79           C  
ATOM   1628  CG  GLN    53     -19.888  -7.222  12.255  1.00 84.78           C  
ATOM   1629  CD  GLN    53     -19.520  -6.296  11.150  1.00 89.93           C  
ATOM   1630  OE1 GLN    53     -18.901  -5.262  11.383  1.00 95.34           O  
ATOM   1631  NE2 GLN    53     -19.918  -6.641   9.926  1.00 90.84           N  
ATOM   1632  C   GLN    53     -23.100  -8.246  13.889  1.00 73.89           C  
ATOM   1633  O   GLN    53     -24.169  -8.667  13.432  1.00 71.87           O  
ATOM   1634  N   LEU    54     -23.025  -7.517  15.000  1.00 73.96           N  
ATOM   1635  CA  LEU    54     -24.246  -7.075  15.664  1.00 71.54           C  
ATOM   1636  CB  LEU    54     -23.954  -6.115  16.806  1.00 71.37           C  
ATOM   1637  CG  LEU    54     -23.720  -6.645  18.210  1.00 72.19           C  
ATOM   1638  CD1 LEU    54     -23.657  -5.431  19.127  1.00 73.28           C  
ATOM   1639  CD2 LEU    54     -24.804  -7.628  18.678  1.00 67.76           C  
ATOM   1640  C   LEU    54     -25.153  -6.381  14.666  1.00 70.96           C  
ATOM   1641  O   LEU    54     -24.707  -5.548  13.849  1.00 71.38           O  
ATOM   1642  N   ASN    55     -26.428  -6.742  14.736  1.00 69.55           N  
ATOM   1643  CA  ASN    55     -27.474  -6.128  13.911  1.00 69.72           C  
ATOM   1644  CB  ASN    55     -27.358  -4.594  13.915  1.00 68.97           C  
ATOM   1645  CG  ASN    55     -27.478  -3.990  15.318  1.00 68.73           C  
ATOM   1646  OD1 ASN    55     -28.078  -4.564  16.239  1.00 67.86           O  
ATOM   1647  ND2 ASN    55     -26.916  -2.809  15.474  1.00 63.22           N  
ATOM   1648  C   ASN    55     -27.554  -6.673  12.476  1.00 68.55           C  
ATOM   1649  O   ASN    55     -28.342  -6.181  11.669  1.00 70.93           O  
ATOM   1650  N   ASP    56     -26.726  -7.665  12.166  1.00 66.57           N  
ATOM   1651  CA  ASP    56     -26.859  -8.418  10.942  1.00 65.55           C  
ATOM   1652  CB  ASP    56     -25.652  -9.322  10.761  1.00 65.62           C  
ATOM   1653  CG  ASP    56     -24.514  -8.651  10.026  1.00 68.09           C  
ATOM   1654  OD1 ASP    56     -24.612  -7.445   9.702  1.00 66.77           O  
ATOM   1655  OD2 ASP    56     -23.516  -9.357   9.761  1.00 67.96           O  
ATOM   1656  C   ASP    56     -28.089  -9.293  11.110  1.00 65.11           C  
ATOM   1657  O   ASP    56     -28.506  -9.552  12.236  1.00 66.56           O  
ATOM   1658  N   TYR    57     -28.674  -9.730  10.000  1.00 63.82           N  
ATOM   1659  CA  TYR    57     -29.793 -10.661  10.019  1.00 60.75           C  
ATOM   1660  CB  TYR    57     -30.909 -10.165   9.111  1.00 60.51           C  
ATOM   1661  CG  TYR    57     -31.478  -8.826   9.488  1.00 60.28           C  
ATOM   1662  CD1 TYR    57     -30.823  -7.665   9.124  1.00 59.46           C  
ATOM   1663  CE1 TYR    57     -31.331  -6.431   9.445  1.00 61.40           C  
ATOM   1664  CZ  TYR    57     -32.522  -6.335  10.141  1.00 63.64           C  
ATOM   1665  OH  TYR    57     -32.970  -5.069  10.441  1.00 64.74           O  
ATOM   1666  CE2 TYR    57     -33.214  -7.481  10.538  1.00 56.59           C  
ATOM   1667  CD2 TYR    57     -32.685  -8.721  10.207  1.00 56.20           C  
ATOM   1668  C   TYR    57     -29.340 -12.004   9.493  1.00 61.12           C  
ATOM   1669  O   TYR    57     -28.496 -12.082   8.592  1.00 62.46           O  
ATOM   1670  N   VAL    58     -29.890 -13.064  10.059  1.00 60.56           N  
ATOM   1671  CA  VAL    58     -29.754 -14.388   9.476  1.00 61.46           C  
ATOM   1672  CB  VAL    58     -29.112 -15.394  10.452  1.00 62.00           C  
ATOM   1673  CG1 VAL    58     -29.223 -16.821   9.915  1.00 62.86           C  
ATOM   1674  CG2 VAL    58     -27.636 -15.015  10.717  1.00 63.40           C  
ATOM   1675  C   VAL    58     -31.146 -14.830   9.040  1.00 61.87           C  
ATOM   1676  O   VAL    58     -32.103 -14.802   9.834  1.00 61.13           O  
ATOM   1677  N   ASP    59     -31.259 -15.175   7.759  1.00 61.42           N  
ATOM   1678  CA  ASP    59     -32.509 -15.634   7.188  1.00 60.73           C  
ATOM   1679  CB  ASP    59     -32.779 -14.965   5.841  1.00 59.72           C  
ATOM   1680  CG  ASP    59     -33.157 -13.529   5.976  1.00 62.55           C  
ATOM   1681  OD1 ASP    59     -33.782 -13.172   6.996  1.00 64.16           O  
ATOM   1682  OD2 ASP    59     -32.827 -12.745   5.059  1.00 62.03           O  
ATOM   1683  C   ASP    59     -32.407 -17.135   7.001  1.00 61.61           C  
ATOM   1684  O   ASP    59     -31.683 -17.625   6.098  1.00 62.81           O  
ATOM   1685  N   ILE    60     -33.113 -17.875   7.851  1.00 60.05           N  
ATOM   1686  CA  ILE    60     -33.134 -19.316   7.706  1.00 58.69           C  
ATOM   1687  CB  ILE    60     -33.207 -20.005   9.061  1.00 58.77           C  
ATOM   1688  CG1 ILE    60     -31.917 -19.708   9.836  1.00 57.57           C  
ATOM   1689  CD1 ILE    60     -31.964 -20.141  11.282  1.00 62.49           C  
ATOM   1690  CG2 ILE    60     -33.386 -21.487   8.896  1.00 51.16           C  
ATOM   1691  C   ILE    60     -34.311 -19.610   6.811  1.00 59.83           C  
ATOM   1692  O   ILE    60     -35.418 -19.114   7.034  1.00 62.33           O  
ATOM   1693  N   ILE    61     -34.053 -20.361   5.753  1.00 59.42           N  
ATOM   1694  CA  ILE    61     -35.051 -20.588   4.715  1.00 57.99           C  
ATOM   1695  CB  ILE    61     -34.537 -20.065   3.359  1.00 58.11           C  
ATOM   1696  CG1 ILE    61     -34.261 -18.561   3.510  1.00 59.93           C  
ATOM   1697  CD1 ILE    61     -34.251 -17.783   2.223  1.00 68.98           C  
ATOM   1698  CG2 ILE    61     -35.531 -20.369   2.238  1.00 54.24           C  
ATOM   1699  C   ILE    61     -35.520 -22.048   4.711  1.00 57.94           C  
ATOM   1700  O   ILE    61     -34.737 -22.976   4.495  1.00 57.11           O  
ATOM   1701  N   CYS    62     -36.799 -22.234   5.020  1.00 57.55           N  
ATOM   1702  CA  CYS    62     -37.363 -23.561   5.162  1.00 57.79           C  
ATOM   1703  CB  CYS    62     -38.765 -23.461   5.742  1.00 58.68           C  
ATOM   1704  SG  CYS    62     -38.799 -22.883   7.422  1.00 66.56           S  
ATOM   1705  C   CYS    62     -37.433 -24.289   3.819  1.00 57.44           C  
ATOM   1706  O   CYS    62     -37.503 -23.648   2.745  1.00 55.57           O  
ATOM   1707  N   PRO    63     -37.446 -25.630   3.867  1.00 56.37           N  
ATOM   1708  CA  PRO    63     -37.635 -26.391   2.631  1.00 56.48           C  
ATOM   1709  CB  PRO    63     -37.788 -27.822   3.122  1.00 55.81           C  
ATOM   1710  CG  PRO    63     -37.139 -27.837   4.468  1.00 55.54           C  
ATOM   1711  CD  PRO    63     -37.321 -26.490   5.058  1.00 54.90           C  
ATOM   1712  C   PRO    63     -38.929 -25.913   1.958  1.00 57.83           C  
ATOM   1713  O   PRO    63     -39.911 -25.648   2.654  1.00 59.36           O  
ATOM   1714  N   HIS    64     -38.914 -25.745   0.638  1.00 58.32           N  
ATOM   1715  CA  HIS    64     -40.073 -25.230  -0.081  1.00 61.05           C  
ATOM   1716  CB  HIS    64     -40.011 -23.704  -0.172  1.00 61.33           C  
ATOM   1717  CG  HIS    64     -41.251 -23.101  -0.744  1.00 66.07           C  
ATOM   1718  ND1 HIS    64     -41.315 -22.614  -2.034  1.00 66.04           N  
ATOM   1719  CE1 HIS    64     -42.541 -22.187  -2.279  1.00 64.89           C  
ATOM   1720  NE2 HIS    64     -43.281 -22.399  -1.205  1.00 65.72           N  
ATOM   1721  CD2 HIS    64     -42.499 -22.973  -0.231  1.00 66.30           C  
ATOM   1722  C   HIS    64     -40.197 -25.864  -1.480  1.00 64.10           C  
ATOM   1723  O   HIS    64     -39.187 -26.138  -2.125  1.00 67.04           O  
ATOM   1724  N   TYR    65     -41.428 -26.104  -1.937  1.00 72.57           N  
ATOM   1725  CA  TYR    65     -41.699 -26.882  -3.156  1.00 76.38           C  
ATOM   1726  CB  TYR    65     -42.080 -28.311  -2.754  1.00 72.47           C  
ATOM   1727  CG  TYR    65     -41.120 -29.016  -1.817  1.00 70.31           C  
ATOM   1728  CD1 TYR    65     -40.185 -29.943  -2.306  1.00 67.92           C  
ATOM   1729  CE1 TYR    65     -39.299 -30.600  -1.441  1.00 63.29           C  
ATOM   1730  CZ  TYR    65     -39.348 -30.339  -0.074  1.00 63.03           C  
ATOM   1731  OH  TYR    65     -38.483 -30.981   0.779  1.00 63.79           O  
ATOM   1732  CE2 TYR    65     -40.263 -29.430   0.441  1.00 59.33           C  
ATOM   1733  CD2 TYR    65     -41.156 -28.783  -0.429  1.00 64.70           C  
ATOM   1734  C   TYR    65     -42.867 -26.320  -3.985  1.00 83.17           C  
ATOM   1735  O   TYR    65     -43.901 -25.969  -3.419  1.00 84.72           O  
ATOM   1736  N   GLU    66     -42.738 -26.257  -5.312  1.00 90.45           N  
ATOM   1737  CA  GLU    66     -43.927 -26.059  -6.179  1.00 98.45           C  
ATOM   1738  CB  GLU    66     -44.130 -24.595  -6.612  1.00102.82           C  
ATOM   1739  CG  GLU    66     -43.040 -23.979  -7.503  1.00111.20           C  
ATOM   1740  CD  GLU    66     -42.169 -22.963  -6.758  1.00114.90           C  
ATOM   1741  OE1 GLU    66     -40.926 -23.075  -6.824  1.00115.44           O  
ATOM   1742  OE2 GLU    66     -42.724 -22.050  -6.102  1.00117.13           O  
ATOM   1743  C   GLU    66     -43.980 -27.002  -7.387  1.00102.18           C  
ATOM   1744  O   GLU    66     -44.502 -28.115  -7.289  1.00104.08           O  
ATOM   1745  N   SER    69     -43.697 -30.660  -8.211  1.00101.20           N  
ATOM   1746  CA  SER    69     -44.454 -31.494  -7.282  1.00 99.05           C  
ATOM   1747  CB  SER    69     -45.901 -31.685  -7.755  1.00102.51           C  
ATOM   1748  OG  SER    69     -46.792 -30.960  -6.923  1.00102.15           O  
ATOM   1749  C   SER    69     -43.814 -32.847  -6.967  1.00 97.17           C  
ATOM   1750  O   SER    69     -43.726 -33.722  -7.819  1.00 97.34           O  
ATOM   1751  N   VAL    70     -43.349 -32.973  -5.724  1.00 93.77           N  
ATOM   1752  CA  VAL    70     -43.077 -34.264  -5.088  1.00 91.09           C  
ATOM   1753  CB  VAL    70     -41.686 -34.279  -4.362  1.00 88.12           C  
ATOM   1754  CG1 VAL    70     -41.781 -33.761  -2.949  1.00 81.91           C  
ATOM   1755  CG2 VAL    70     -40.646 -33.473  -5.150  1.00 88.49           C  
ATOM   1756  C   VAL    70     -44.264 -34.534  -4.133  1.00 89.28           C  
ATOM   1757  O   VAL    70     -45.079 -33.638  -3.896  1.00 88.69           O  
ATOM   1758  N   ALA    71     -44.386 -35.759  -3.618  1.00 88.48           N  
ATOM   1759  CA  ALA    71     -45.512 -36.123  -2.738  1.00 87.33           C  
ATOM   1760  CB  ALA    71     -45.593 -37.634  -2.538  1.00 87.21           C  
ATOM   1761  C   ALA    71     -45.417 -35.405  -1.391  1.00 83.85           C  
ATOM   1762  O   ALA    71     -44.327 -35.003  -0.963  1.00 80.71           O  
ATOM   1763  N   ASP    72     -46.558 -35.250  -0.725  1.00 83.63           N  
ATOM   1764  CA  ASP    72     -46.614 -34.429   0.474  1.00 80.95           C  
ATOM   1765  CB  ASP    72     -48.051 -34.287   0.985  1.00 82.60           C  
ATOM   1766  CG  ASP    72     -48.947 -33.501   0.017  1.00 87.82           C  
ATOM   1767  OD1 ASP    72     -48.434 -32.765  -0.860  1.00 87.73           O  
ATOM   1768  OD2 ASP    72     -50.184 -33.624   0.121  1.00 95.01           O  
ATOM   1769  C   ASP    72     -45.661 -34.957   1.530  1.00 77.55           C  
ATOM   1770  O   ASP    72     -44.869 -34.195   2.083  1.00 76.39           O  
ATOM   1771  N   ALA    73     -45.705 -36.274   1.729  1.00 77.84           N  
ATOM   1772  CA  ALA    73     -44.862 -37.023   2.666  1.00 75.61           C  
ATOM   1773  CB  ALA    73     -45.247 -38.531   2.639  1.00 76.99           C  
ATOM   1774  C   ALA    73     -43.356 -36.865   2.430  1.00 73.95           C  
ATOM   1775  O   ALA    73     -42.561 -37.082   3.347  1.00 73.95           O  
ATOM   1776  N   ALA    74     -42.968 -36.506   1.211  1.00 74.52           N  
ATOM   1777  CA  ALA    74     -41.553 -36.360   0.861  1.00 73.72           C  
ATOM   1778  CB  ALA    74     -41.306 -36.775  -0.591  1.00 75.34           C  
ATOM   1779  C   ALA    74     -41.030 -34.949   1.105  1.00 71.93           C  
ATOM   1780  O   ALA    74     -39.824 -34.717   1.057  1.00 72.75           O  
ATOM   1781  N   MET    75     -41.934 -34.009   1.355  1.00 70.52           N  
ATOM   1782  CA  MET    75     -41.547 -32.625   1.621  1.00 68.82           C  
ATOM   1783  CB  MET    75     -42.743 -31.690   1.429  1.00 68.84           C  
ATOM   1784  CG  MET    75     -43.196 -31.636  -0.008  1.00 72.32           C  
ATOM   1785  SD  MET    75     -44.675 -30.673  -0.173  1.00 75.06           S  
ATOM   1786  CE  MET    75     -45.027 -30.899  -1.910  1.00 77.34           C  
ATOM   1787  C   MET    75     -40.969 -32.503   3.022  1.00 66.12           C  
ATOM   1788  O   MET    75     -41.580 -32.964   3.987  1.00 67.76           O  
ATOM   1789  N   GLU    76     -39.783 -31.904   3.125  1.00 64.15           N  
ATOM   1790  CA  GLU    76     -39.064 -31.797   4.391  1.00 59.73           C  
ATOM   1791  CB  GLU    76     -37.593 -31.439   4.153  1.00 57.36           C  
ATOM   1792  CG  GLU    76     -36.784 -32.590   3.629  1.00 59.39           C  
ATOM   1793  CD  GLU    76     -35.304 -32.277   3.423  1.00 62.61           C  
ATOM   1794  OE1 GLU    76     -34.775 -31.364   4.072  1.00 67.17           O  
ATOM   1795  OE2 GLU    76     -34.657 -32.958   2.596  1.00 68.04           O  
ATOM   1796  C   GLU    76     -39.736 -30.778   5.293  1.00 59.34           C  
ATOM   1797  O   GLU    76     -40.135 -29.705   4.828  1.00 59.93           O  
ATOM   1798  N   GLN    77     -39.882 -31.144   6.572  1.00 59.36           N  
ATOM   1799  CA  GLN    77     -40.472 -30.296   7.619  1.00 57.88           C  
ATOM   1800  CB  GLN    77     -41.919 -30.704   7.882  1.00 57.46           C  
ATOM   1801  CG  GLN    77     -42.835 -30.354   6.717  1.00 58.86           C  
ATOM   1802  CD  GLN    77     -44.317 -30.511   7.033  1.00 59.59           C  
ATOM   1803  OE1 GLN    77     -44.847 -29.870   7.936  1.00 63.94           O  
ATOM   1804  NE2 GLN    77     -44.992 -31.342   6.266  1.00 55.64           N  
ATOM   1805  C   GLN    77     -39.649 -30.348   8.910  1.00 57.23           C  
ATOM   1806  O   GLN    77     -39.163 -31.411   9.298  1.00 60.33           O  
ATOM   1807  N   TYR    78     -39.485 -29.206   9.573  1.00 55.69           N  
ATOM   1808  CA  TYR    78     -38.585 -29.122  10.726  1.00 54.25           C  
ATOM   1809  CB  TYR    78     -37.189 -28.585  10.334  1.00 53.16           C  
ATOM   1810  CG  TYR    78     -36.440 -29.474   9.362  1.00 53.66           C  
ATOM   1811  CD1 TYR    78     -36.418 -29.181   7.994  1.00 54.30           C  
ATOM   1812  CE1 TYR    78     -35.739 -30.006   7.087  1.00 54.63           C  
ATOM   1813  CZ  TYR    78     -35.081 -31.136   7.552  1.00 53.74           C  
ATOM   1814  OH  TYR    78     -34.428 -31.941   6.658  1.00 57.55           O  
ATOM   1815  CE2 TYR    78     -35.082 -31.453   8.907  1.00 50.12           C  
ATOM   1816  CD2 TYR    78     -35.762 -30.617   9.804  1.00 52.20           C  
ATOM   1817  C   TYR    78     -39.156 -28.230  11.797  1.00 54.51           C  
ATOM   1818  O   TYR    78     -39.933 -27.312  11.507  1.00 56.08           O  
ATOM   1819  N   ILE    79     -38.766 -28.514  13.035  1.00 51.82           N  
ATOM   1820  CA  ILE    79     -38.847 -27.546  14.104  1.00 51.12           C  
ATOM   1821  CB  ILE    79     -39.334 -28.221  15.370  1.00 51.00           C  
ATOM   1822  CG1 ILE    79     -40.703 -28.835  15.118  1.00 49.34           C  
ATOM   1823  CD1 ILE    79     -41.115 -29.806  16.168  1.00 50.72           C  
ATOM   1824  CG2 ILE    79     -39.395 -27.223  16.509  1.00 50.32           C  
ATOM   1825  C   ILE    79     -37.424 -27.002  14.286  1.00 51.25           C  
ATOM   1826  O   ILE    79     -36.473 -27.789  14.393  1.00 51.15           O  
ATOM   1827  N   LEU    80     -37.264 -25.678  14.247  1.00 51.43           N  
ATOM   1828  CA  LEU    80     -35.970 -25.052  14.544  1.00 51.30           C  
ATOM   1829  CB  LEU    80     -35.733 -23.773  13.747  1.00 50.95           C  
ATOM   1830  CG  LEU    80     -35.744 -23.937  12.244  1.00 60.64           C  
ATOM   1831  CD1 LEU    80     -35.792 -22.573  11.544  1.00 61.99           C  
ATOM   1832  CD2 LEU    80     -34.546 -24.797  11.786  1.00 63.14           C  
ATOM   1833  C   LEU    80     -35.969 -24.674  16.006  1.00 50.47           C  
ATOM   1834  O   LEU    80     -36.946 -24.102  16.507  1.00 48.99           O  
ATOM   1835  N   TYR    81     -34.853 -24.968  16.666  1.00 49.53           N  
ATOM   1836  CA  TYR    81     -34.639 -24.601  18.040  1.00 49.40           C  
ATOM   1837  CB  TYR    81     -34.361 -25.849  18.868  1.00 49.48           C  
ATOM   1838  CG  TYR    81     -35.456 -26.905  18.856  1.00 47.03           C  
ATOM   1839  CD1 TYR    81     -35.465 -27.922  17.897  1.00 45.23           C  
ATOM   1840  CE1 TYR    81     -36.455 -28.906  17.906  1.00 46.90           C  
ATOM   1841  CZ  TYR    81     -37.454 -28.867  18.884  1.00 47.72           C  
ATOM   1842  OH  TYR    81     -38.450 -29.810  18.909  1.00 46.06           O  
ATOM   1843  CE2 TYR    81     -37.466 -27.866  19.832  1.00 44.80           C  
ATOM   1844  CD2 TYR    81     -36.468 -26.892  19.813  1.00 44.50           C  
ATOM   1845  C   TYR    81     -33.436 -23.681  18.136  1.00 50.84           C  
ATOM   1846  O   TYR    81     -32.490 -23.797  17.359  1.00 50.00           O  
ATOM   1847  N   LEU    82     -33.482 -22.759  19.091  1.00 51.39           N  
ATOM   1848  CA  LEU    82     -32.329 -21.943  19.401  1.00 50.54           C  
ATOM   1849  CB  LEU    82     -32.675 -20.462  19.332  1.00 51.46           C  
ATOM   1850  CG  LEU    82     -31.645 -19.457  19.872  1.00 51.59           C  
ATOM   1851  CD1 LEU    82     -30.399 -19.422  19.001  1.00 47.87           C  
ATOM   1852  CD2 LEU    82     -32.281 -18.073  19.963  1.00 49.07           C  
ATOM   1853  C   LEU    82     -31.879 -22.343  20.803  1.00 53.80           C  
ATOM   1854  O   LEU    82     -32.631 -22.182  21.768  1.00 54.04           O  
ATOM   1855  N   VAL    83     -30.652 -22.864  20.892  1.00 54.38           N  
ATOM   1856  CA  VAL    83     -30.192 -23.633  22.038  1.00 55.15           C  
ATOM   1857  CB  VAL    83     -30.160 -25.178  21.716  1.00 56.46           C  
ATOM   1858  CG1 VAL    83     -31.544 -25.722  21.351  1.00 55.39           C  
ATOM   1859  CG2 VAL    83     -29.123 -25.511  20.636  1.00 51.14           C  
ATOM   1860  C   VAL    83     -28.786 -23.248  22.465  1.00 57.18           C  
ATOM   1861  O   VAL    83     -28.015 -22.688  21.679  1.00 59.96           O  
ATOM   1862  N   GLU    84     -28.447 -23.609  23.698  1.00 58.16           N  
ATOM   1863  CA  GLU    84     -27.095 -23.449  24.241  1.00 59.82           C  
ATOM   1864  CB  GLU    84     -27.160 -23.477  25.766  1.00 61.80           C  
ATOM   1865  CG  GLU    84     -26.808 -22.172  26.402  1.00 70.34           C  
ATOM   1866  CD  GLU    84     -28.000 -21.311  26.688  1.00 76.51           C  
ATOM   1867  OE1 GLU    84     -28.225 -21.041  27.881  1.00 86.83           O  
ATOM   1868  OE2 GLU    84     -28.711 -20.886  25.749  1.00 78.44           O  
ATOM   1869  C   GLU    84     -26.093 -24.502  23.704  1.00 59.28           C  
ATOM   1870  O   GLU    84     -26.508 -25.525  23.141  1.00 56.78           O  
ATOM   1871  N   HIS    85     -24.791 -24.253  23.887  1.00 60.18           N  
ATOM   1872  CA  HIS    85     -23.742 -25.108  23.332  1.00 62.00           C  
ATOM   1873  CB  HIS    85     -22.362 -24.689  23.847  1.00 65.71           C  
ATOM   1874  CG  HIS    85     -21.220 -25.432  23.214  1.00 71.02           C  
ATOM   1875  ND1 HIS    85     -20.571 -24.981  22.082  1.00 75.54           N  
ATOM   1876  CE1 HIS    85     -19.606 -25.827  21.758  1.00 78.42           C  
ATOM   1877  NE2 HIS    85     -19.607 -26.812  22.640  1.00 78.22           N  
ATOM   1878  CD2 HIS    85     -20.598 -26.584  23.567  1.00 74.86           C  
ATOM   1879  C   HIS    85     -23.976 -26.598  23.597  1.00 63.27           C  
ATOM   1880  O   HIS    85     -23.889 -27.416  22.680  1.00 63.02           O  
ATOM   1881  N   GLU    86     -24.288 -26.955  24.838  1.00 65.23           N  
ATOM   1882  CA  GLU    86     -24.501 -28.359  25.162  1.00 67.93           C  
ATOM   1883  CB  GLU    86     -24.722 -28.557  26.653  1.00 71.08           C  
ATOM   1884  CG  GLU    86     -23.952 -29.758  27.155  1.00 83.00           C  
ATOM   1885  CD  GLU    86     -24.657 -30.510  28.268  1.00 92.71           C  
ATOM   1886  OE1 GLU    86     -25.911 -30.519  28.292  1.00 94.13           O  
ATOM   1887  OE2 GLU    86     -23.948 -31.111  29.113  1.00100.40           O  
ATOM   1888  C   GLU    86     -25.607 -29.063  24.346  1.00 66.02           C  
ATOM   1889  O   GLU    86     -25.435 -30.228  23.956  1.00 66.88           O  
ATOM   1890  N   GLU    87     -26.722 -28.377  24.081  1.00 62.99           N  
ATOM   1891  CA  GLU    87     -27.796 -29.011  23.323  1.00 63.50           C  
ATOM   1892  CB  GLU    87     -29.175 -28.323  23.429  1.00 63.04           C  
ATOM   1893  CG  GLU    87     -29.412 -27.243  24.487  1.00 68.38           C  
ATOM   1894  CD  GLU    87     -29.167 -27.664  25.892  1.00 74.69           C  
ATOM   1895  OE1 GLU    87     -29.010 -28.876  26.187  1.00 81.64           O  
ATOM   1896  OE2 GLU    87     -29.126 -26.745  26.719  1.00 79.95           O  
ATOM   1897  C   GLU    87     -27.386 -29.126  21.867  1.00 62.34           C  
ATOM   1898  O   GLU    87     -27.805 -30.059  21.181  1.00 64.45           O  
ATOM   1899  N   TYR    88     -26.550 -28.187  21.423  1.00 63.12           N  
ATOM   1900  CA  TYR    88     -25.912 -28.205  20.104  1.00 61.10           C  
ATOM   1901  CB  TYR    88     -25.154 -26.896  19.903  1.00 59.37           C  
ATOM   1902  CG  TYR    88     -24.260 -26.797  18.695  1.00 57.11           C  
ATOM   1903  CD1 TYR    88     -24.757 -26.339  17.475  1.00 55.05           C  
ATOM   1904  CE1 TYR    88     -23.923 -26.200  16.363  1.00 56.54           C  
ATOM   1905  CZ  TYR    88     -22.569 -26.521  16.470  1.00 59.03           C  
ATOM   1906  OH  TYR    88     -21.755 -26.397  15.374  1.00 59.09           O  
ATOM   1907  CE2 TYR    88     -22.047 -26.968  17.672  1.00 57.27           C  
ATOM   1908  CD2 TYR    88     -22.899 -27.091  18.785  1.00 58.95           C  
ATOM   1909  C   TYR    88     -24.962 -29.388  19.956  1.00 63.46           C  
ATOM   1910  O   TYR    88     -24.987 -30.068  18.935  1.00 63.63           O  
ATOM   1911  N   GLN    89     -24.129 -29.631  20.965  1.00 65.05           N  
ATOM   1912  CA  GLN    89     -23.289 -30.835  20.982  1.00 68.40           C  
ATOM   1913  CB  GLN    89     -22.433 -30.922  22.254  1.00 70.53           C  
ATOM   1914  CG  GLN    89     -21.312 -29.896  22.351  1.00 75.85           C  
ATOM   1915  CD  GLN    89     -20.242 -30.052  21.266  1.00 82.46           C  
ATOM   1916  OE1 GLN    89     -20.487 -29.788  20.078  1.00 81.02           O  
ATOM   1917  NE2 GLN    89     -19.039 -30.461  21.680  1.00 84.77           N  
ATOM   1918  C   GLN    89     -24.117 -32.109  20.830  1.00 68.19           C  
ATOM   1919  O   GLN    89     -23.823 -32.942  19.982  1.00 68.29           O  
ATOM   1920  N   LEU    90     -25.164 -32.247  21.639  1.00 67.73           N  
ATOM   1921  CA  LEU    90     -25.990 -33.437  21.594  1.00 68.47           C  
ATOM   1922  CB  LEU    90     -26.854 -33.542  22.841  1.00 67.62           C  
ATOM   1923  CG  LEU    90     -26.189 -33.669  24.196  1.00 71.02           C  
ATOM   1924  CD1 LEU    90     -27.305 -33.768  25.225  1.00 72.66           C  
ATOM   1925  CD2 LEU    90     -25.252 -34.868  24.238  1.00 67.89           C  
ATOM   1926  C   LEU    90     -26.901 -33.449  20.382  1.00 68.71           C  
ATOM   1927  O   LEU    90     -27.480 -34.485  20.045  1.00 70.32           O  
ATOM   1928  N   CYS    91     -27.041 -32.298  19.736  1.00 68.07           N  
ATOM   1929  CA  CYS    91     -28.023 -32.114  18.667  1.00 67.06           C  
ATOM   1930  CB  CYS    91     -27.667 -32.918  17.423  1.00 67.58           C  
ATOM   1931  SG  CYS    91     -28.387 -32.185  15.936  1.00 69.63           S  
ATOM   1932  C   CYS    91     -29.428 -32.469  19.133  1.00 66.19           C  
ATOM   1933  O   CYS    91     -30.171 -33.173  18.432  1.00 66.09           O  
ATOM   1934  N   GLN    92     -29.782 -31.987  20.325  1.00 64.97           N  
ATOM   1935  CA  GLN    92     -31.077 -32.297  20.923  1.00 63.97           C  
ATOM   1936  CB  GLN    92     -30.985 -33.573  21.748  1.00 64.98           C  
ATOM   1937  CG  GLN    92     -30.941 -34.800  20.877  1.00 69.42           C  
ATOM   1938  CD  GLN    92     -30.910 -36.068  21.655  1.00 74.34           C  
ATOM   1939  OE1 GLN    92     -31.110 -36.082  22.871  1.00 77.65           O  
ATOM   1940  NE2 GLN    92     -30.660 -37.159  20.962  1.00 73.77           N  
ATOM   1941  C   GLN    92     -31.580 -31.154  21.767  1.00 60.67           C  
ATOM   1942  O   GLN    92     -30.831 -30.623  22.558  1.00 63.52           O  
ATOM   1943  N   PRO    93     -32.863 -30.786  21.616  1.00 57.68           N  
ATOM   1944  CA  PRO    93     -33.422 -29.677  22.366  1.00 54.76           C  
ATOM   1945  CB  PRO    93     -34.789 -29.477  21.711  1.00 54.66           C  
ATOM   1946  CG  PRO    93     -35.181 -30.858  21.276  1.00 55.28           C  
ATOM   1947  CD  PRO    93     -33.881 -31.441  20.772  1.00 57.25           C  
ATOM   1948  C   PRO    93     -33.605 -30.090  23.812  1.00 55.78           C  
ATOM   1949  O   PRO    93     -33.749 -31.275  24.103  1.00 55.61           O  
ATOM   1950  N   GLN    94     -33.587 -29.116  24.712  1.00 57.59           N  
ATOM   1951  CA  GLN    94     -33.746 -29.379  26.135  1.00 59.55           C  
ATOM   1952  CB  GLN    94     -32.842 -28.453  26.950  1.00 59.04           C  
ATOM   1953  CG  GLN    94     -32.957 -28.628  28.458  1.00 66.00           C  
ATOM   1954  CD  GLN    94     -32.433 -27.414  29.230  1.00 73.20           C  
ATOM   1955  OE1 GLN    94     -31.541 -27.545  30.064  1.00 75.62           O  
ATOM   1956  NE2 GLN    94     -32.990 -26.227  28.953  1.00 73.53           N  
ATOM   1957  C   GLN    94     -35.229 -29.195  26.512  1.00 60.25           C  
ATOM   1958  O   GLN    94     -35.777 -29.989  27.294  1.00 61.46           O  
ATOM   1959  N   SER    95     -35.879 -28.180  25.933  1.00 56.75           N  
ATOM   1960  CA  SER    95     -37.274 -27.932  26.237  1.00 59.42           C  
ATOM   1961  CB  SER    95     -37.426 -27.257  27.612  1.00 59.78           C  
ATOM   1962  OG  SER    95     -37.322 -25.853  27.508  1.00 58.11           O  
ATOM   1963  C   SER    95     -38.037 -27.125  25.190  1.00 59.95           C  
ATOM   1964  O   SER    95     -37.461 -26.438  24.342  1.00 60.33           O  
ATOM   1965  N   LYS    96     -39.355 -27.206  25.304  1.00 60.01           N  
ATOM   1966  CA  LYS    96     -40.290 -26.413  24.539  1.00 58.91           C  
ATOM   1967  CB  LYS    96     -41.626 -26.516  25.233  1.00 60.61           C  
ATOM   1968  CG  LYS    96     -42.782 -26.032  24.442  1.00 68.37           C  
ATOM   1969  CD  LYS    96     -43.784 -25.347  25.378  1.00 75.00           C  
ATOM   1970  CE  LYS    96     -43.730 -25.909  26.778  1.00 74.45           C  
ATOM   1971  NZ  LYS    96     -44.618 -25.093  27.628  1.00 79.21           N  
ATOM   1972  C   LYS    96     -39.896 -24.940  24.421  1.00 56.09           C  
ATOM   1973  O   LYS    96     -40.043 -24.355  23.365  1.00 56.18           O  
ATOM   1974  N   ASP    97     -39.395 -24.345  25.497  1.00 55.95           N  
ATOM   1975  CA  ASP    97     -38.973 -22.935  25.490  1.00 55.13           C  
ATOM   1976  CB  ASP    97     -38.387 -22.528  26.830  1.00 55.07           C  
ATOM   1977  CG  ASP    97     -39.370 -22.695  27.965  1.00 61.58           C  
ATOM   1978  OD1 ASP    97     -40.576 -22.939  27.713  1.00 63.49           O  
ATOM   1979  OD2 ASP    97     -38.937 -22.581  29.125  1.00 69.18           O  
ATOM   1980  C   ASP    97     -37.964 -22.609  24.416  1.00 53.95           C  
ATOM   1981  O   ASP    97     -37.852 -21.479  24.022  1.00 56.06           O  
ATOM   1982  N   GLN    98     -37.239 -23.598  23.934  1.00 53.79           N  
ATOM   1983  CA  GLN    98     -36.216 -23.355  22.944  1.00 54.00           C  
ATOM   1984  CB  GLN    98     -35.071 -24.352  23.148  1.00 55.66           C  
ATOM   1985  CG  GLN    98     -34.318 -24.166  24.470  1.00 54.03           C  
ATOM   1986  CD  GLN    98     -33.256 -25.216  24.661  1.00 59.65           C  
ATOM   1987  OE1 GLN    98     -33.483 -26.405  24.401  1.00 60.28           O  
ATOM   1988  NE2 GLN    98     -32.075 -24.791  25.105  1.00 61.36           N  
ATOM   1989  C   GLN    98     -36.723 -23.401  21.496  1.00 54.76           C  
ATOM   1990  O   GLN    98     -35.970 -23.060  20.568  1.00 56.93           O  
ATOM   1991  N   VAL    99     -37.969 -23.844  21.286  1.00 52.58           N  
ATOM   1992  CA  VAL    99     -38.594 -23.762  19.965  1.00 50.25           C  
ATOM   1993  CB  VAL    99     -40.076 -24.225  19.984  1.00 50.43           C  
ATOM   1994  CG1 VAL    99     -40.706 -24.043  18.610  1.00 47.21           C  
ATOM   1995  CG2 VAL    99     -40.194 -25.701  20.411  1.00 49.23           C  
ATOM   1996  C   VAL    99     -38.484 -22.330  19.388  1.00 50.18           C  
ATOM   1997  O   VAL    99     -38.962 -21.373  19.984  1.00 52.07           O  
ATOM   1998  N   ARG   100     -37.853 -22.196  18.228  1.00 51.16           N  
ATOM   1999  CA  ARG   100     -37.633 -20.899  17.587  1.00 50.11           C  
ATOM   2000  CB  ARG   100     -36.235 -20.867  16.976  1.00 48.55           C  
ATOM   2001  CG  ARG   100     -35.839 -19.509  16.445  1.00 49.91           C  
ATOM   2002  CD  ARG   100     -35.920 -18.464  17.561  1.00 46.32           C  
ATOM   2003  NE  ARG   100     -35.676 -17.115  17.061  1.00 45.11           N  
ATOM   2004  CZ  ARG   100     -36.629 -16.253  16.719  1.00 45.48           C  
ATOM   2005  NH1 ARG   100     -37.913 -16.587  16.825  1.00 43.32           N  
ATOM   2006  NH2 ARG   100     -36.291 -15.047  16.267  1.00 44.04           N  
ATOM   2007  C   ARG   100     -38.638 -20.601  16.482  1.00 50.90           C  
ATOM   2008  O   ARG   100     -39.062 -19.444  16.295  1.00 51.44           O  
ATOM   2009  N   TRP   101     -38.968 -21.638  15.720  1.00 50.41           N  
ATOM   2010  CA  TRP   101     -39.852 -21.510  14.569  1.00 50.37           C  
ATOM   2011  CB  TRP   101     -39.224 -20.627  13.482  1.00 47.28           C  
ATOM   2012  CG  TRP   101     -40.273 -20.006  12.575  1.00 46.27           C  
ATOM   2013  CD1 TRP   101     -40.521 -20.311  11.254  1.00 43.91           C  
ATOM   2014  NE1 TRP   101     -41.561 -19.550  10.783  1.00 42.25           N  
ATOM   2015  CE2 TRP   101     -42.007 -18.734  11.793  1.00 43.80           C  
ATOM   2016  CD2 TRP   101     -41.222 -19.001  12.938  1.00 41.79           C  
ATOM   2017  CE3 TRP   101     -41.482 -18.290  14.123  1.00 42.59           C  
ATOM   2018  CZ3 TRP   101     -42.506 -17.349  14.130  1.00 43.83           C  
ATOM   2019  CH2 TRP   101     -43.271 -17.105  12.971  1.00 45.72           C  
ATOM   2020  CZ2 TRP   101     -43.040 -17.787  11.798  1.00 45.42           C  
ATOM   2021  C   TRP   101     -40.176 -22.889  14.007  1.00 51.33           C  
ATOM   2022  O   TRP   101     -39.530 -23.867  14.362  1.00 53.74           O  
ATOM   2023  N   GLN   102     -41.186 -22.977  13.155  1.00 53.13           N  
ATOM   2024  CA  GLN   102     -41.510 -24.248  12.529  1.00 56.47           C  
ATOM   2025  CB  GLN   102     -42.823 -24.769  13.050  1.00 58.58           C  
ATOM   2026  CG  GLN   102     -42.719 -25.076  14.531  1.00 66.85           C  
ATOM   2027  CD  GLN   102     -43.742 -26.074  14.997  1.00 73.38           C  
ATOM   2028  OE1 GLN   102     -43.587 -27.286  14.820  1.00 80.09           O  
ATOM   2029  NE2 GLN   102     -44.795 -25.571  15.609  1.00 75.87           N  
ATOM   2030  C   GLN   102     -41.514 -24.181  11.022  1.00 57.45           C  
ATOM   2031  O   GLN   102     -42.105 -23.277  10.454  1.00 57.22           O  
ATOM   2032  N   CYS   103     -40.808 -25.115  10.383  1.00 56.18           N  
ATOM   2033  CA  CYS   103     -40.872 -25.268   8.940  1.00 56.68           C  
ATOM   2034  CB  CYS   103     -39.542 -25.711   8.356  1.00 57.17           C  
ATOM   2035  SG  CYS   103     -38.285 -24.514   8.632  1.00 64.06           S  
ATOM   2036  C   CYS   103     -41.930 -26.288   8.660  1.00 55.99           C  
ATOM   2037  O   CYS   103     -41.637 -27.431   8.275  1.00 56.24           O  
ATOM   2038  N   ASN   104     -43.172 -25.869   8.856  1.00 56.52           N  
ATOM   2039  CA  ASN   104     -44.287 -26.761   8.665  1.00 57.46           C  
ATOM   2040  CB  ASN   104     -45.009 -27.003   9.992  1.00 55.61           C  
ATOM   2041  CG  ASN   104     -45.675 -25.762  10.538  1.00 56.96           C  
ATOM   2042  OD1 ASN   104     -45.472 -24.663  10.051  1.00 59.86           O  
ATOM   2043  ND2 ASN   104     -46.487 -25.941  11.555  1.00 57.18           N  
ATOM   2044  C   ASN   104     -45.217 -26.255   7.573  1.00 60.54           C  
ATOM   2045  O   ASN   104     -46.400 -26.543   7.575  1.00 63.29           O  
ATOM   2046  N   ARG   105     -44.664 -25.509   6.628  1.00 62.17           N  
ATOM   2047  CA  ARG   105     -45.421 -25.062   5.465  1.00 65.71           C  
ATOM   2048  CB  ARG   105     -45.931 -23.631   5.670  1.00 67.60           C  
ATOM   2049  CG  ARG   105     -47.074 -23.602   6.680  1.00 75.21           C  
ATOM   2050  CD  ARG   105     -47.412 -22.219   7.107  1.00 83.04           C  
ATOM   2051  NE  ARG   105     -47.651 -21.397   5.932  1.00 91.36           N  
ATOM   2052  CZ  ARG   105     -47.781 -20.073   5.948  1.00 97.78           C  
ATOM   2053  NH1 ARG   105     -47.985 -19.436   4.800  1.00 98.04           N  
ATOM   2054  NH2 ARG   105     -47.712 -19.387   7.097  1.00 94.61           N  
ATOM   2055  C   ARG   105     -44.589 -25.241   4.194  1.00 65.66           C  
ATOM   2056  O   ARG   105     -44.198 -24.270   3.544  1.00 67.33           O  
ATOM   2057  N   PRO   106     -44.314 -26.506   3.838  1.00 64.89           N  
ATOM   2058  CA  PRO   106     -43.414 -26.796   2.748  1.00 64.10           C  
ATOM   2059  CB  PRO   106     -43.311 -28.313   2.795  1.00 61.91           C  
ATOM   2060  CG  PRO   106     -44.583 -28.753   3.411  1.00 61.26           C  
ATOM   2061  CD  PRO   106     -44.843 -27.744   4.441  1.00 63.43           C  
ATOM   2062  C   PRO   106     -43.945 -26.360   1.392  1.00 66.96           C  
ATOM   2063  O   PRO   106     -43.167 -26.291   0.437  1.00 68.20           O  
ATOM   2064  N   SER   107     -45.241 -26.073   1.271  1.00 68.77           N  
ATOM   2065  CA  SER   107     -45.742 -25.726  -0.077  1.00 70.58           C  
ATOM   2066  CB  SER   107     -46.329 -26.944  -0.815  1.00 70.55           C  
ATOM   2067  OG  SER   107     -47.527 -27.384  -0.225  1.00 69.80           O  
ATOM   2068  C   SER   107     -46.645 -24.493  -0.140  1.00 71.96           C  
ATOM   2069  O   SER   107     -47.411 -24.291  -1.091  1.00 73.54           O  
ATOM   2070  N   ALA   108     -46.505 -23.665   0.884  1.00 72.27           N  
ATOM   2071  CA  ALA   108     -47.066 -22.335   0.930  1.00 73.55           C  
ATOM   2072  CB  ALA   108     -46.320 -21.559   1.979  1.00 73.53           C  
ATOM   2073  C   ALA   108     -46.967 -21.624  -0.432  1.00 76.63           C  
ATOM   2074  O   ALA   108     -45.893 -21.532  -1.033  1.00 75.59           O  
ATOM   2075  N   LYS   109     -48.094 -21.112  -0.917  1.00 81.01           N  
ATOM   2076  CA  LYS   109     -48.118 -20.389  -2.188  1.00 82.67           C  
ATOM   2077  CB  LYS   109     -49.563 -20.159  -2.664  1.00 85.17           C  
ATOM   2082  C   LYS   109     -47.324 -19.076  -2.137  1.00 83.71           C  
ATOM   2083  O   LYS   109     -46.754 -18.673  -3.149  1.00 85.36           O  
ATOM   2084  N   HIS   110     -47.275 -18.434  -0.971  0.50 83.61           N  
ATOM   2086  CA  HIS   110     -46.653 -17.106  -0.834  0.50 85.44           C  
ATOM   2088  CB  HIS   110     -47.170 -16.396   0.429  0.50 86.22           C  
ATOM   2090  CG  HIS   110     -48.625 -16.046   0.382  0.50 86.31           C  
ATOM   2092  ND1 HIS   110     -49.095 -14.788   0.685  0.50 88.73           N  
ATOM   2094  CE1 HIS   110     -50.410 -14.770   0.564  0.50 90.79           C  
ATOM   2096  NE2 HIS   110     -50.812 -15.971   0.190  0.50 87.13           N  
ATOM   2098  CD2 HIS   110     -49.715 -16.788   0.072  0.50 85.88           C  
ATOM   2100  C   HIS   110     -45.108 -17.095  -0.858  0.50 84.28           C  
ATOM   2102  O   HIS   110     -44.493 -16.028  -0.768  0.50 86.17           O  
ATOM   2104  N   GLY   111     -44.491 -18.270  -0.980  1.00 82.38           N  
ATOM   2105  CA  GLY   111     -43.020 -18.387  -1.011  1.00 79.93           C  
ATOM   2106  C   GLY   111     -42.566 -19.306   0.116  1.00 76.67           C  
ATOM   2107  O   GLY   111     -43.411 -19.872   0.818  1.00 77.64           O  
ATOM   2108  N   PRO   112     -41.242 -19.462   0.316  1.00 73.97           N  
ATOM   2109  CA  PRO   112     -40.800 -20.374   1.380  1.00 69.94           C  
ATOM   2110  CB  PRO   112     -39.284 -20.484   1.155  1.00 70.11           C  
ATOM   2111  CG  PRO   112     -39.017 -19.835  -0.179  1.00 71.17           C  
ATOM   2112  CD  PRO   112     -40.100 -18.823  -0.355  1.00 74.32           C  
ATOM   2113  C   PRO   112     -41.055 -19.734   2.728  1.00 68.32           C  
ATOM   2114  O   PRO   112     -41.049 -18.514   2.833  1.00 68.74           O  
ATOM   2115  N   GLU   113     -41.296 -20.554   3.738  1.00 68.03           N  
ATOM   2116  CA  GLU   113     -41.397 -20.072   5.101  1.00 65.88           C  
ATOM   2117  CB  GLU   113     -42.000 -21.158   5.995  1.00 65.23           C  
ATOM   2118  CG  GLU   113     -42.259 -20.757   7.436  1.00 64.92           C  
ATOM   2119  CD  GLU   113     -43.418 -19.811   7.581  1.00 68.45           C  
ATOM   2120  OE1 GLU   113     -43.386 -18.985   8.518  1.00 72.82           O  
ATOM   2121  OE2 GLU   113     -44.362 -19.880   6.763  1.00 72.64           O  
ATOM   2122  C   GLU   113     -39.990 -19.701   5.555  1.00 64.54           C  
ATOM   2123  O   GLU   113     -39.019 -20.358   5.188  1.00 66.12           O  
ATOM   2124  N   LYS   114     -39.881 -18.665   6.371  1.00 64.40           N  
ATOM   2125  CA  LYS   114     -38.593 -18.041   6.646  1.00 64.05           C  
ATOM   2126  CB  LYS   114     -38.414 -16.911   5.629  1.00 65.16           C  
ATOM   2127  CG  LYS   114     -37.179 -16.062   5.742  1.00 70.29           C  
ATOM   2128  CD  LYS   114     -37.256 -14.909   4.722  1.00 73.48           C  
ATOM   2129  CE  LYS   114     -38.129 -13.755   5.235  1.00 79.32           C  
ATOM   2130  NZ  LYS   114     -38.024 -12.564   4.346  1.00 86.89           N  
ATOM   2131  C   LYS   114     -38.510 -17.525   8.099  1.00 61.34           C  
ATOM   2132  O   LYS   114     -39.401 -16.795   8.570  1.00 61.87           O  
ATOM   2133  N   LEU   115     -37.466 -17.942   8.816  1.00 58.06           N  
ATOM   2134  CA  LEU   115     -37.124 -17.352  10.112  1.00 56.46           C  
ATOM   2135  CB  LEU   115     -36.612 -18.423  11.087  1.00 55.24           C  
ATOM   2136  CG  LEU   115     -36.414 -18.079  12.571  1.00 55.58           C  
ATOM   2137  CD1 LEU   115     -35.114 -17.372  12.765  1.00 56.14           C  
ATOM   2138  CD2 LEU   115     -37.571 -17.227  13.152  1.00 51.27           C  
ATOM   2139  C   LEU   115     -36.067 -16.255   9.915  1.00 56.26           C  
ATOM   2140  O   LEU   115     -34.931 -16.558   9.563  1.00 57.13           O  
ATOM   2141  N   SER   116     -36.447 -14.991  10.119  1.00 55.73           N  
ATOM   2142  CA  SER   116     -35.484 -13.866  10.078  1.00 54.72           C  
ATOM   2143  CB  SER   116     -36.058 -12.675   9.318  1.00 53.24           C  
ATOM   2144  OG  SER   116     -36.231 -13.009   7.962  1.00 59.50           O  
ATOM   2145  C   SER   116     -35.078 -13.419  11.482  1.00 53.76           C  
ATOM   2146  O   SER   116     -35.840 -12.760  12.162  1.00 54.96           O  
ATOM   2147  N   GLU   117     -33.873 -13.783  11.888  1.00 53.29           N  
ATOM   2148  CA  GLU   117     -33.348 -13.483  13.202  1.00 55.01           C  
ATOM   2149  CB  GLU   117     -32.501 -14.679  13.692  1.00 54.38           C  
ATOM   2150  CG  GLU   117     -31.960 -14.505  15.075  1.00 53.87           C  
ATOM   2151  CD  GLU   117     -32.976 -14.909  16.118  1.00 59.77           C  
ATOM   2152  OE1 GLU   117     -33.040 -16.118  16.398  1.00 54.27           O  
ATOM   2153  OE2 GLU   117     -33.714 -14.022  16.654  1.00 63.09           O  
ATOM   2154  C   GLU   117     -32.451 -12.254  13.113  1.00 57.04           C  
ATOM   2155  O   GLU   117     -31.441 -12.286  12.407  1.00 61.60           O  
ATOM   2156  N   LYS   118     -32.777 -11.175  13.815  1.00 57.57           N  
ATOM   2157  CA  LYS   118     -31.843 -10.047  13.876  1.00 56.25           C  
ATOM   2158  CB  LYS   118     -32.563  -8.713  13.901  1.00 56.23           C  
ATOM   2159  CG  LYS   118     -31.618  -7.534  13.868  1.00 55.68           C  
ATOM   2160  CD  LYS   118     -32.364  -6.236  14.014  1.00 60.62           C  
ATOM   2161  CE  LYS   118     -31.459  -5.063  13.761  1.00 63.49           C  
ATOM   2162  NZ  LYS   118     -32.307  -3.873  13.602  1.00 66.60           N  
ATOM   2163  C   LYS   118     -30.969 -10.176  15.103  1.00 58.01           C  
ATOM   2164  O   LYS   118     -31.471 -10.341  16.217  1.00 61.22           O  
ATOM   2165  N   PHE   119     -29.660 -10.088  14.909  1.00 57.70           N  
ATOM   2166  CA  PHE   119     -28.732 -10.224  16.011  1.00 57.85           C  
ATOM   2167  CB  PHE   119     -27.428 -10.844  15.494  1.00 58.57           C  
ATOM   2168  CG  PHE   119     -27.559 -12.328  15.221  1.00 58.68           C  
ATOM   2169  CD1 PHE   119     -28.338 -12.791  14.166  1.00 59.09           C  
ATOM   2170  CE1 PHE   119     -28.502 -14.151  13.939  1.00 58.27           C  
ATOM   2171  CZ  PHE   119     -27.888 -15.067  14.769  1.00 58.62           C  
ATOM   2172  CE2 PHE   119     -27.106 -14.622  15.825  1.00 59.67           C  
ATOM   2173  CD2 PHE   119     -26.953 -13.260  16.048  1.00 60.42           C  
ATOM   2174  C   PHE   119     -28.573  -8.927  16.824  1.00 60.49           C  
ATOM   2175  O   PHE   119     -27.512  -8.304  16.846  1.00 62.69           O  
ATOM   2176  N   GLN   120     -29.670  -8.525  17.466  1.00 60.88           N  
ATOM   2177  CA  GLN   120     -29.747  -7.338  18.311  1.00 64.08           C  
ATOM   2178  CB  GLN   120     -31.186  -7.147  18.736  1.00 65.47           C  
ATOM   2179  CG  GLN   120     -32.132  -6.431  17.828  1.00 71.77           C  
ATOM   2180  CD  GLN   120     -33.544  -6.479  18.418  1.00 77.29           C  
ATOM   2181  OE1 GLN   120     -33.995  -7.532  18.888  1.00 75.97           O  
ATOM   2182  NE2 GLN   120     -34.234  -5.334  18.427  1.00 82.70           N  
ATOM   2183  C   GLN   120     -29.014  -7.592  19.618  1.00 66.37           C  
ATOM   2184  O   GLN   120     -28.935  -8.734  20.066  1.00 68.81           O  
ATOM   2185  N   ARG   121     -28.550  -6.534  20.280  1.00 68.12           N  
ATOM   2186  CA  ARG   121     -28.049  -6.671  21.642  1.00 69.56           C  
ATOM   2187  CB  ARG   121     -27.005  -5.591  21.982  1.00 73.03           C  
ATOM   2188  CG  ARG   121     -25.964  -6.019  23.055  1.00 76.86           C  
ATOM   2189  CD  ARG   121     -26.436  -5.615  24.406  1.00 84.36           C  
ATOM   2190  NE  ARG   121     -25.839  -6.289  25.563  1.00 92.25           N  
ATOM   2191  CZ  ARG   121     -26.404  -7.293  26.240  1.00 95.25           C  
ATOM   2192  NH1 ARG   121     -27.569  -7.810  25.850  1.00 91.64           N  
ATOM   2193  NH2 ARG   121     -25.791  -7.798  27.306  1.00 98.78           N  
ATOM   2194  C   ARG   121     -29.187  -6.655  22.657  1.00 70.48           C  
ATOM   2195  O   ARG   121     -29.072  -7.272  23.710  1.00 71.66           O  
ATOM   2196  N   PHE   122     -30.276  -5.954  22.347  1.00 61.20           N  
ATOM   2197  CA  PHE   122     -31.381  -5.819  23.293  1.00 60.75           C  
ATOM   2198  CB  PHE   122     -31.403  -4.418  23.897  1.00 58.60           C  
ATOM   2199  CG  PHE   122     -30.183  -4.059  24.692  1.00 55.90           C  
ATOM   2200  CD1 PHE   122     -29.306  -3.083  24.228  1.00 54.44           C  
ATOM   2201  CE1 PHE   122     -28.172  -2.721  24.978  1.00 54.40           C  
ATOM   2202  CZ  PHE   122     -27.923  -3.334  26.216  1.00 52.99           C  
ATOM   2203  CE2 PHE   122     -28.811  -4.305  26.694  1.00 54.00           C  
ATOM   2204  CD2 PHE   122     -29.937  -4.653  25.933  1.00 54.71           C  
ATOM   2205  C   PHE   122     -32.737  -6.058  22.642  1.00 62.50           C  
ATOM   2206  O   PHE   122     -32.961  -5.561  21.536  1.00 62.87           O  
ATOM   2207  N   THR   123     -33.623  -6.804  23.325  1.00 62.78           N  
ATOM   2208  CA  THR   123     -35.036  -6.962  22.919  1.00 64.29           C  
ATOM   2209  CB  THR   123     -35.596  -8.415  23.030  1.00 64.98           C  
ATOM   2210  OG1 THR   123     -34.571  -9.339  23.418  1.00 68.38           O  
ATOM   2211  CG2 THR   123     -36.347  -8.842  21.760  1.00 66.72           C  
ATOM   2212  C   THR   123     -35.935  -6.295  23.926  1.00 63.38           C  
ATOM   2213  O   THR   123     -35.648  -6.333  25.122  1.00 62.17           O  
ATOM   2214  N   PRO   124     -37.071  -5.759  23.455  1.00 63.85           N  
ATOM   2215  CA  PRO   124     -38.192  -5.496  24.349  1.00 64.11           C  
ATOM   2216  CB  PRO   124     -39.047  -4.519  23.544  1.00 63.16           C  
ATOM   2217  CG  PRO   124     -38.774  -4.886  22.115  1.00 62.79           C  
ATOM   2218  CD  PRO   124     -37.369  -5.378  22.058  1.00 63.83           C  
ATOM   2219  C   PRO   124     -38.989  -6.783  24.635  1.00 65.71           C  
ATOM   2220  O   PRO   124     -39.777  -6.811  25.575  1.00 65.67           O  
ATOM   2221  N   PHE   125     -38.799  -7.834  23.830  1.00 67.48           N  
ATOM   2222  CA  PHE   125     -39.646  -9.025  23.963  1.00 68.12           C  
ATOM   2223  CB  PHE   125     -40.131  -9.572  22.622  1.00 65.98           C  
ATOM   2224  CG  PHE   125     -41.287 -10.510  22.754  1.00 67.79           C  
ATOM   2225  CD1 PHE   125     -41.169 -11.841  22.369  1.00 66.48           C  
ATOM   2226  CE1 PHE   125     -42.241 -12.720  22.495  1.00 65.01           C  
ATOM   2227  CZ  PHE   125     -43.453 -12.281  23.039  1.00 65.56           C  
ATOM   2228  CE2 PHE   125     -43.581 -10.955  23.447  1.00 66.67           C  
ATOM   2229  CD2 PHE   125     -42.500 -10.072  23.297  1.00 68.36           C  
ATOM   2230  C   PHE   125     -39.028 -10.121  24.816  1.00 69.36           C  
ATOM   2231  O   PHE   125     -37.988 -10.675  24.505  1.00 73.04           O  
ATOM   2232  N   THR   126     -39.722 -10.441  25.889  1.00 69.96           N  
ATOM   2233  CA  THR   126     -39.165 -11.208  26.981  1.00 68.85           C  
ATOM   2234  CB  THR   126     -40.046 -10.959  28.226  1.00 68.67           C  
ATOM   2235  OG1 THR   126     -39.214 -10.762  29.367  1.00 75.15           O  
ATOM   2236  CG2 THR   126     -41.043 -12.049  28.459  1.00 65.36           C  
ATOM   2237  C   THR   126     -38.905 -12.693  26.639  1.00 68.68           C  
ATOM   2238  O   THR   126     -38.144 -13.374  27.319  1.00 68.27           O  
ATOM   2239  N   LEU   127     -39.507 -13.159  25.548  1.00 69.14           N  
ATOM   2240  CA  LEU   127     -39.357 -14.539  25.061  1.00 69.56           C  
ATOM   2241  CB  LEU   127     -40.690 -15.040  24.498  1.00 68.06           C  
ATOM   2242  CG  LEU   127     -41.745 -15.722  25.381  1.00 67.52           C  
ATOM   2243  CD1 LEU   127     -41.707 -15.252  26.804  1.00 64.96           C  
ATOM   2244  CD2 LEU   127     -43.142 -15.547  24.789  1.00 67.52           C  
ATOM   2245  C   LEU   127     -38.284 -14.664  23.971  1.00 71.45           C  
ATOM   2246  O   LEU   127     -37.988 -15.766  23.523  1.00 72.49           O  
ATOM   2247  N   GLY   128     -37.725 -13.534  23.536  1.00 70.94           N  
ATOM   2248  CA  GLY   128     -36.696 -13.526  22.509  1.00 71.72           C  
ATOM   2249  C   GLY   128     -35.307 -13.517  23.113  1.00 71.86           C  
ATOM   2250  O   GLY   128     -35.160 -13.397  24.327  1.00 72.73           O  
ATOM   2251  N   LYS   129     -34.288 -13.655  22.265  1.00 71.49           N  
ATOM   2252  CA  LYS   129     -32.902 -13.778  22.712  1.00 70.95           C  
ATOM   2253  CB  LYS   129     -32.228 -14.955  22.001  1.00 71.86           C  
ATOM   2254  CG  LYS   129     -31.407 -15.887  22.907  1.00 76.61           C  
ATOM   2255  CD  LYS   129     -29.935 -15.452  23.062  1.00 77.08           C  
ATOM   2256  CE  LYS   129     -29.113 -16.483  23.848  1.00 74.75           C  
ATOM   2258  C   LYS   129     -32.115 -12.486  22.445  1.00 69.43           C  
ATOM   2259  O   LYS   129     -32.398 -11.740  21.490  1.00 69.19           O  
ATOM   2260  N   GLU   130     -31.133 -12.219  23.295  1.00 66.53           N  
ATOM   2261  CA  GLU   130     -30.216 -11.111  23.069  1.00 63.18           C  
ATOM   2262  CB  GLU   130     -30.119 -10.259  24.310  1.00 60.46           C  
ATOM   2263  CG  GLU   130     -31.446  -9.677  24.676  1.00 58.67           C  
ATOM   2264  CD  GLU   130     -31.343  -8.581  25.707  1.00 64.53           C  
ATOM   2265  OE1 GLU   130     -30.511  -8.684  26.652  1.00 63.02           O  
ATOM   2266  OE2 GLU   130     -32.116  -7.611  25.571  1.00 66.51           O  
ATOM   2267  C   GLU   130     -28.860 -11.652  22.646  1.00 63.11           C  
ATOM   2268  O   GLU   130     -28.440 -12.728  23.084  1.00 65.06           O  
ATOM   2269  N   PHE   131     -28.190 -10.916  21.774  1.00 63.03           N  
ATOM   2270  CA  PHE   131     -26.963 -11.396  21.171  1.00 61.16           C  
ATOM   2271  CB  PHE   131     -27.161 -11.547  19.656  1.00 58.51           C  
ATOM   2272  CG  PHE   131     -28.257 -12.503  19.284  1.00 55.20           C  
ATOM   2273  CD1 PHE   131     -28.003 -13.873  19.198  1.00 51.84           C  
ATOM   2274  CE1 PHE   131     -29.026 -14.768  18.870  1.00 53.42           C  
ATOM   2275  CZ  PHE   131     -30.332 -14.290  18.634  1.00 51.71           C  
ATOM   2276  CE2 PHE   131     -30.592 -12.923  18.741  1.00 53.28           C  
ATOM   2277  CD2 PHE   131     -29.559 -12.040  19.058  1.00 53.90           C  
ATOM   2278  C   PHE   131     -25.827 -10.437  21.480  1.00 63.92           C  
ATOM   2279  O   PHE   131     -25.998  -9.235  21.371  1.00 65.92           O  
ATOM   2280  N   LYS   132     -24.670 -10.970  21.860  1.00 65.44           N  
ATOM   2281  CA  LYS   132     -23.542 -10.152  22.310  1.00 68.20           C  
ATOM   2282  CB  LYS   132     -23.222 -10.464  23.772  1.00 68.50           C  
ATOM   2283  CG  LYS   132     -24.290 -10.012  24.726  1.00 73.51           C  
ATOM   2284  CD  LYS   132     -24.607 -11.080  25.752  1.00 80.61           C  
ATOM   2285  CE  LYS   132     -23.876 -10.832  27.070  1.00 86.59           C  
ATOM   2286  NZ  LYS   132     -24.433 -11.694  28.161  1.00 88.30           N  
ATOM   2287  C   LYS   132     -22.309 -10.378  21.457  1.00 68.97           C  
ATOM   2288  O   LYS   132     -22.055 -11.497  21.017  1.00 68.20           O  
ATOM   2289  N   GLU   133     -21.544  -9.311  21.234  1.00 72.55           N  
ATOM   2290  CA  GLU   133     -20.260  -9.392  20.521  1.00 74.52           C  
ATOM   2291  CB  GLU   133     -19.611  -8.009  20.415  1.00 76.37           C  
ATOM   2292  CG  GLU   133     -20.269  -7.123  19.363  1.00 81.52           C  
ATOM   2293  CD  GLU   133     -19.519  -5.821  19.099  1.00 86.20           C  
ATOM   2294  OE1 GLU   133     -18.317  -5.875  18.747  1.00 96.41           O  
ATOM   2295  OE2 GLU   133     -20.134  -4.734  19.224  1.00 92.30           O  
ATOM   2296  C   GLU   133     -19.304 -10.367  21.191  1.00 72.05           C  
ATOM   2297  O   GLU   133     -19.186 -10.376  22.407  1.00 72.26           O  
ATOM   2298  N   GLY   134     -18.645 -11.199  20.390  1.00 70.84           N  
ATOM   2299  CA  GLY   134     -17.705 -12.198  20.893  1.00 69.51           C  
ATOM   2300  C   GLY   134     -18.303 -13.537  21.292  1.00 68.24           C  
ATOM   2301  O   GLY   134     -17.573 -14.451  21.639  1.00 68.55           O  
ATOM   2302  N   HIS   135     -19.626 -13.659  21.257  1.00 66.41           N  
ATOM   2303  CA  HIS   135     -20.292 -14.907  21.621  1.00 65.15           C  
ATOM   2304  CB  HIS   135     -21.487 -14.628  22.535  1.00 65.77           C  
ATOM   2305  CG  HIS   135     -21.103 -14.116  23.884  1.00 71.66           C  
ATOM   2306  ND1 HIS   135     -20.438 -12.919  24.066  1.00 75.73           N  
ATOM   2307  CE1 HIS   135     -20.231 -12.724  25.357  1.00 76.62           C  
ATOM   2308  NE2 HIS   135     -20.746 -13.745  26.018  1.00 77.98           N  
ATOM   2309  CD2 HIS   135     -21.296 -14.632  25.120  1.00 73.15           C  
ATOM   2310  C   HIS   135     -20.757 -15.690  20.396  1.00 62.81           C  
ATOM   2311  O   HIS   135     -20.812 -15.161  19.280  1.00 63.13           O  
ATOM   2312  N   SER   136     -21.099 -16.953  20.621  1.00 60.44           N  
ATOM   2313  CA  SER   136     -21.619 -17.814  19.576  1.00 58.65           C  
ATOM   2314  CB  SER   136     -20.678 -18.997  19.352  1.00 59.69           C  
ATOM   2315  OG  SER   136     -19.527 -18.622  18.596  1.00 61.55           O  
ATOM   2316  C   SER   136     -23.020 -18.292  19.955  1.00 57.92           C  
ATOM   2317  O   SER   136     -23.352 -18.401  21.137  1.00 56.83           O  
ATOM   2318  N   TYR   137     -23.854 -18.552  18.954  1.00 57.02           N  
ATOM   2319  CA  TYR   137     -25.235 -18.979  19.198  1.00 56.00           C  
ATOM   2320  CB  TYR   137     -26.194 -17.809  18.951  1.00 56.33           C  
ATOM   2321  CG  TYR   137     -25.840 -16.674  19.876  1.00 58.56           C  
ATOM   2322  CD1 TYR   137     -24.865 -15.726  19.518  1.00 58.33           C  
ATOM   2323  CE1 TYR   137     -24.493 -14.719  20.391  1.00 61.81           C  
ATOM   2324  CZ  TYR   137     -25.087 -14.654  21.654  1.00 63.16           C  
ATOM   2325  OH  TYR   137     -24.739 -13.657  22.546  1.00 63.56           O  
ATOM   2326  CE2 TYR   137     -26.041 -15.596  22.032  1.00 60.91           C  
ATOM   2327  CD2 TYR   137     -26.401 -16.602  21.151  1.00 57.19           C  
ATOM   2328  C   TYR   137     -25.497 -20.190  18.337  1.00 54.88           C  
ATOM   2329  O   TYR   137     -24.769 -20.423  17.387  1.00 57.89           O  
ATOM   2330  N   TYR   138     -26.479 -21.000  18.693  1.00 54.02           N  
ATOM   2331  CA  TYR   138     -26.600 -22.323  18.077  1.00 53.58           C  
ATOM   2332  CB  TYR   138     -26.047 -23.415  18.997  1.00 53.48           C  
ATOM   2333  CG  TYR   138     -24.676 -23.098  19.544  1.00 56.27           C  
ATOM   2334  CD1 TYR   138     -24.530 -22.469  20.779  1.00 56.27           C  
ATOM   2335  CE1 TYR   138     -23.286 -22.160  21.278  1.00 54.11           C  
ATOM   2336  CZ  TYR   138     -22.169 -22.470  20.546  1.00 56.08           C  
ATOM   2337  OH  TYR   138     -20.928 -22.166  21.051  1.00 61.04           O  
ATOM   2338  CE2 TYR   138     -22.279 -23.090  19.317  1.00 56.79           C  
ATOM   2339  CD2 TYR   138     -23.529 -23.396  18.819  1.00 55.12           C  
ATOM   2340  C   TYR   138     -28.026 -22.648  17.764  1.00 53.46           C  
ATOM   2341  O   TYR   138     -28.903 -22.512  18.643  1.00 52.33           O  
ATOM   2342  N   TYR   139     -28.246 -23.076  16.516  1.00 52.60           N  
ATOM   2343  CA  TYR   139     -29.530 -23.587  16.079  1.00 51.05           C  
ATOM   2344  CB  TYR   139     -29.997 -22.871  14.817  1.00 50.69           C  
ATOM   2345  CG  TYR   139     -30.236 -21.390  14.980  1.00 53.13           C  
ATOM   2346  CD1 TYR   139     -29.183 -20.481  14.864  1.00 54.96           C  
ATOM   2347  CE1 TYR   139     -29.386 -19.107  14.988  1.00 53.90           C  
ATOM   2348  CZ  TYR   139     -30.658 -18.625  15.251  1.00 56.28           C  
ATOM   2349  OH  TYR   139     -30.846 -17.257  15.382  1.00 53.37           O  
ATOM   2350  CE2 TYR   139     -31.732 -19.519  15.384  1.00 54.77           C  
ATOM   2351  CD2 TYR   139     -31.515 -20.890  15.239  1.00 52.78           C  
ATOM   2352  C   TYR   139     -29.422 -25.074  15.798  1.00 52.04           C  
ATOM   2353  O   TYR   139     -28.415 -25.551  15.236  1.00 52.43           O  
ATOM   2354  N   ILE   140     -30.473 -25.802  16.170  1.00 51.19           N  
ATOM   2355  CA  ILE   140     -30.638 -27.207  15.747  1.00 52.22           C  
ATOM   2356  CB  ILE   140     -30.321 -28.223  16.894  1.00 52.57           C  
ATOM   2357  CG1 ILE   140     -31.370 -28.115  18.016  1.00 50.46           C  
ATOM   2358  CD1 ILE   140     -31.233 -29.136  19.121  1.00 50.31           C  
ATOM   2359  CG2 ILE   140     -28.886 -28.042  17.403  1.00 49.16           C  
ATOM   2360  C   ILE   140     -32.072 -27.438  15.228  1.00 53.15           C  
ATOM   2361  O   ILE   140     -32.980 -26.626  15.473  1.00 54.39           O  
ATOM   2362  N   SER   141     -32.288 -28.544  14.521  1.00 51.34           N  
ATOM   2363  CA  SER   141     -33.649 -28.880  14.134  1.00 49.78           C  
ATOM   2364  CB  SER   141     -33.873 -28.602  12.657  1.00 47.58           C  
ATOM   2365  OG  SER   141     -33.020 -29.391  11.875  1.00 52.50           O  
ATOM   2366  C   SER   141     -34.015 -30.322  14.472  1.00 49.85           C  
ATOM   2367  O   SER   141     -33.152 -31.160  14.743  1.00 51.45           O  
ATOM   2368  N   LYS   142     -35.304 -30.609  14.475  1.00 48.16           N  
ATOM   2369  CA  LYS   142     -35.737 -31.993  14.412  1.00 47.37           C  
ATOM   2370  CB  LYS   142     -36.346 -32.422  15.743  1.00 47.41           C  
ATOM   2371  CG  LYS   142     -35.316 -32.537  16.860  1.00 47.19           C  
ATOM   2372  CD  LYS   142     -34.342 -33.648  16.548  1.00 43.53           C  
ATOM   2373  CE  LYS   142     -33.274 -33.717  17.562  1.00 47.73           C  
ATOM   2374  NZ  LYS   142     -32.273 -34.713  17.167  1.00 48.82           N  
ATOM   2375  C   LYS   142     -36.728 -32.125  13.276  1.00 47.80           C  
ATOM   2376  O   LYS   142     -37.497 -31.202  13.034  1.00 48.97           O  
ATOM   2377  N   PRO   143     -36.738 -33.274  12.577  1.00 48.61           N  
ATOM   2378  CA  PRO   143     -37.716 -33.399  11.502  1.00 47.89           C  
ATOM   2379  CB  PRO   143     -37.321 -34.714  10.821  1.00 49.14           C  
ATOM   2380  CG  PRO   143     -36.032 -35.122  11.405  1.00 50.27           C  
ATOM   2381  CD  PRO   143     -35.966 -34.513  12.758  1.00 48.34           C  
ATOM   2382  C   PRO   143     -39.127 -33.556  12.100  1.00 48.96           C  
ATOM   2383  O   PRO   143     -39.270 -34.143  13.179  1.00 47.48           O  
ATOM   2384  N   ILE   144     -40.156 -33.040  11.423  1.00 48.74           N  
ATOM   2385  CA  ILE   144     -41.517 -33.289  11.867  1.00 46.74           C  
ATOM   2386  CB  ILE   144     -42.472 -32.127  11.522  1.00 45.78           C  
ATOM   2387  CG1 ILE   144     -41.951 -30.828  12.131  1.00 44.71           C  
ATOM   2388  CD1 ILE   144     -42.820 -29.613  11.765  1.00 46.74           C  
ATOM   2389  CG2 ILE   144     -43.862 -32.381  12.092  1.00 37.44           C  
ATOM   2390  C   ILE   144     -42.018 -34.634  11.319  1.00 49.22           C  
ATOM   2391  O   ILE   144     -42.501 -34.723  10.175  1.00 49.54           O  
ATOM   2392  N   HIS   145     -41.901 -35.668  12.157  1.00 48.28           N  
ATOM   2393  CA  HIS   145     -42.348 -37.042  11.841  1.00 50.71           C  
ATOM   2394  CB  HIS   145     -43.857 -37.150  11.576  1.00 48.39           C  
ATOM   2395  CG  HIS   145     -44.717 -36.301  12.464  1.00 51.57           C  
ATOM   2396  ND1 HIS   145     -44.745 -36.432  13.836  1.00 50.86           N  
ATOM   2397  CE1 HIS   145     -45.610 -35.574  14.341  1.00 43.42           C  
ATOM   2398  NE2 HIS   145     -46.159 -34.904  13.345  1.00 46.64           N  
ATOM   2399  CD2 HIS   145     -45.631 -35.349  12.162  1.00 50.88           C  
ATOM   2400  C   HIS   145     -41.646 -37.628  10.636  1.00 52.43           C  
ATOM   2401  O   HIS   145     -42.296 -38.244   9.797  1.00 54.54           O  
ATOM   2402  N   GLN   146     -40.336 -37.442  10.536  1.00 52.92           N  
ATOM   2403  CA  GLN   146     -39.592 -37.881   9.349  1.00 55.41           C  
ATOM   2404  CB  GLN   146     -39.410 -36.722   8.359  1.00 53.53           C  
ATOM   2405  CG  GLN   146     -40.630 -36.348   7.574  1.00 55.08           C  
ATOM   2406  CD  GLN   146     -40.487 -35.032   6.825  1.00 56.54           C  
ATOM   2407  OE1 GLN   146     -39.637 -34.174   7.132  1.00 58.07           O  
ATOM   2408  NE2 GLN   146     -41.331 -34.862   5.839  1.00 57.67           N  
ATOM   2409  C   GLN   146     -38.220 -38.398   9.751  1.00 55.25           C  
ATOM   2410  O   GLN   146     -37.792 -38.164  10.873  1.00 55.18           O  
ATOM   2411  N   HIS   147     -37.550 -39.080   8.823  1.00 56.32           N  
ATOM   2412  CA  HIS   147     -36.165 -39.498   8.982  1.00 59.99           C  
ATOM   2413  CB  HIS   147     -35.621 -40.136   7.690  1.00 60.94           C  
ATOM   2414  CG  HIS   147     -36.204 -41.471   7.365  1.00 65.97           C  
ATOM   2415  ND1 HIS   147     -36.970 -42.195   8.253  1.00 72.70           N  
ATOM   2416  CE1 HIS   147     -37.334 -43.338   7.694  1.00 75.02           C  
ATOM   2417  NE2 HIS   147     -36.824 -43.385   6.475  1.00 74.43           N  
ATOM   2418  CD2 HIS   147     -36.103 -42.235   6.249  1.00 74.39           C  
ATOM   2419  C   HIS   147     -35.246 -38.334   9.381  1.00 59.32           C  
ATOM   2420  O   HIS   147     -35.282 -37.252   8.774  1.00 58.68           O  
ATOM   2421  N   GLU   148     -34.464 -38.563  10.436  1.00 60.00           N  
ATOM   2422  CA  GLU   148     -33.312 -37.729  10.771  1.00 60.66           C  
ATOM   2423  CB  GLU   148     -33.266 -37.478  12.272  1.00 57.72           C  
ATOM   2424  CG  GLU   148     -32.379 -36.290  12.637  1.00 60.69           C  
ATOM   2425  CD  GLU   148     -32.251 -36.078  14.125  1.00 60.94           C  
ATOM   2426  OE1 GLU   148     -32.855 -36.869  14.889  1.00 66.02           O  
ATOM   2427  OE2 GLU   148     -31.542 -35.131  14.528  1.00 56.46           O  
ATOM   2428  C   GLU   148     -32.038 -38.457  10.308  1.00 63.17           C  
ATOM   2429  O   GLU   148     -31.486 -39.293  11.023  1.00 65.37           O  
ATOM   2430  N   ASP   149     -31.601 -38.179   9.093  1.00 64.91           N  
ATOM   2431  CA  ASP   149     -30.511 -38.938   8.483  1.00 69.10           C  
ATOM   2432  CB  ASP   149     -30.521 -38.711   6.977  1.00 71.16           C  
ATOM   2433  CG  ASP   149     -31.526 -39.594   6.254  1.00 77.97           C  
ATOM   2434  OD1 ASP   149     -32.290 -40.349   6.911  1.00 81.56           O  
ATOM   2435  OD2 ASP   149     -31.535 -39.541   5.005  1.00 83.32           O  
ATOM   2436  C   ASP   149     -29.162 -38.512   9.026  1.00 69.28           C  
ATOM   2437  O   ASP   149     -28.202 -39.270   9.020  1.00 72.00           O  
ATOM   2438  N   ARG   150     -29.136 -37.285   9.519  1.00 68.22           N  
ATOM   2439  CA  ARG   150     -27.950 -36.510   9.775  1.00 68.79           C  
ATOM   2440  CB  ARG   150     -27.475 -35.918   8.451  1.00 69.51           C  
ATOM   2441  CG  ARG   150     -26.577 -34.704   8.486  1.00 70.21           C  
ATOM   2442  CD  ARG   150     -26.370 -34.182   7.042  1.00 72.26           C  
ATOM   2443  NE  ARG   150     -25.942 -35.232   6.111  1.00 73.68           N  
ATOM   2447  C   ARG   150     -28.481 -35.431  10.690  1.00 66.74           C  
ATOM   2448  O   ARG   150     -29.646 -35.030  10.583  1.00 65.37           O  
ATOM   2449  N   CYS   151     -27.648 -34.988  11.617  1.00 67.67           N  
ATOM   2450  CA  CYS   151     -28.016 -33.908  12.512  1.00 64.82           C  
ATOM   2451  CB  CYS   151     -27.158 -33.980  13.774  1.00 65.20           C  
ATOM   2452  SG  CYS   151     -26.876 -32.371  14.535  1.00 71.95           S  
ATOM   2453  C   CYS   151     -27.840 -32.566  11.782  1.00 62.66           C  
ATOM   2454  O   CYS   151     -26.786 -32.310  11.183  1.00 63.69           O  
ATOM   2455  N   LEU   152     -28.863 -31.719  11.819  1.00 57.45           N  
ATOM   2456  CA  LEU   152     -28.754 -30.404  11.198  1.00 55.46           C  
ATOM   2457  CB  LEU   152     -29.965 -30.112  10.314  1.00 53.30           C  
ATOM   2458  CG  LEU   152     -30.230 -31.058   9.136  1.00 57.13           C  
ATOM   2459  CD1 LEU   152     -31.555 -30.734   8.480  1.00 54.70           C  
ATOM   2460  CD2 LEU   152     -29.124 -31.036   8.088  1.00 55.89           C  
ATOM   2461  C   LEU   152     -28.583 -29.329  12.283  1.00 54.42           C  
ATOM   2462  O   LEU   152     -29.484 -29.115  13.102  1.00 55.22           O  
ATOM   2463  N   ARG   153     -27.428 -28.663  12.295  1.00 52.31           N  
ATOM   2464  CA  ARG   153     -27.144 -27.612  13.278  1.00 51.68           C  
ATOM   2465  CB  ARG   153     -26.373 -28.172  14.477  1.00 52.51           C  
ATOM   2466  CG  ARG   153     -25.083 -28.892  14.125  1.00 50.80           C  
ATOM   2467  CD  ARG   153     -24.542 -29.622  15.333  1.00 53.69           C  
ATOM   2468  NE  ARG   153     -23.105 -29.850  15.200  1.00 63.01           N  
ATOM   2469  CZ  ARG   153     -22.323 -30.400  16.126  1.00 64.47           C  
ATOM   2470  NH1 ARG   153     -21.023 -30.546  15.886  1.00 68.07           N  
ATOM   2471  NH2 ARG   153     -22.829 -30.798  17.284  1.00 63.45           N  
ATOM   2472  C   ARG   153     -26.386 -26.451  12.648  1.00 52.21           C  
ATOM   2473  O   ARG   153     -25.879 -26.578  11.547  1.00 53.85           O  
ATOM   2474  N   LEU   154     -26.319 -25.315  13.336  1.00 51.57           N  
ATOM   2475  CA  LEU   154     -25.680 -24.130  12.766  1.00 52.35           C  
ATOM   2476  CB  LEU   154     -26.721 -23.231  12.090  1.00 52.38           C  
ATOM   2477  CG  LEU   154     -26.467 -22.286  10.901  1.00 52.33           C  
ATOM   2478  CD1 LEU   154     -27.189 -20.956  11.106  1.00 47.55           C  
ATOM   2479  CD2 LEU   154     -25.026 -22.063  10.579  1.00 48.79           C  
ATOM   2480  C   LEU   154     -25.072 -23.360  13.896  1.00 52.80           C  
ATOM   2481  O   LEU   154     -25.697 -23.188  14.942  1.00 53.27           O  
ATOM   2482  N   LYS   155     -23.857 -22.884  13.695  1.00 54.03           N  
ATOM   2483  CA  LYS   155     -23.210 -22.072  14.698  1.00 53.75           C  
ATOM   2484  CB  LYS   155     -21.808 -22.611  14.979  1.00 55.85           C  
ATOM   2485  CG  LYS   155     -20.962 -21.753  15.901  1.00 57.65           C  
ATOM   2486  CD  LYS   155     -19.797 -22.552  16.432  1.00 58.41           C  
ATOM   2487  CE  LYS   155     -19.025 -21.762  17.482  1.00 61.53           C  
ATOM   2488  NZ  LYS   155     -17.729 -22.434  17.833  1.00 61.73           N  
ATOM   2489  C   LYS   155     -23.165 -20.676  14.117  1.00 53.84           C  
ATOM   2490  O   LYS   155     -22.699 -20.499  12.988  1.00 55.18           O  
ATOM   2491  N   VAL   156     -23.674 -19.700  14.862  1.00 52.45           N  
ATOM   2492  CA  VAL   156     -23.556 -18.300  14.472  1.00 54.93           C  
ATOM   2493  CB  VAL   156     -24.930 -17.581  14.360  1.00 54.69           C  
ATOM   2494  CG1 VAL   156     -24.741 -16.232  13.689  1.00 56.14           C  
ATOM   2495  CG2 VAL   156     -25.951 -18.416  13.576  1.00 49.56           C  
ATOM   2496  C   VAL   156     -22.632 -17.561  15.461  1.00 58.78           C  
ATOM   2497  O   VAL   156     -22.924 -17.498  16.665  1.00 60.84           O  
ATOM   2498  N   THR   157     -21.513 -17.033  14.962  1.00 58.75           N  
ATOM   2499  CA  THR   157     -20.559 -16.320  15.798  1.00 60.81           C  
ATOM   2500  CB  THR   157     -19.108 -16.854  15.583  1.00 62.18           C  
ATOM   2501  OG1 THR   157     -19.027 -18.220  16.000  1.00 58.31           O  
ATOM   2502  CG2 THR   157     -18.095 -16.036  16.379  1.00 62.08           C  
ATOM   2503  C   THR   157     -20.625 -14.811  15.527  1.00 63.37           C  
ATOM   2504  O   THR   157     -20.504 -14.370  14.388  1.00 63.80           O  
ATOM   2505  N   VAL   158     -20.828 -14.022  16.576  1.00 66.77           N  
ATOM   2506  CA  VAL   158     -20.822 -12.551  16.450  1.00 70.21           C  
ATOM   2507  CB  VAL   158     -21.831 -11.874  17.422  1.00 69.55           C  
ATOM   2508  CG1 VAL   158     -21.914 -10.371  17.168  1.00 69.21           C  
ATOM   2509  CG2 VAL   158     -23.219 -12.517  17.312  1.00 67.10           C  
ATOM   2510  C   VAL   158     -19.409 -11.981  16.672  1.00 73.89           C  
ATOM   2511  O   VAL   158     -18.845 -12.102  17.757  1.00 75.32           O  
ATOM   2512  N   SER   159     -18.835 -11.372  15.644  1.00 77.42           N  
ATOM   2513  CA  SER   159     -17.496 -10.820  15.775  1.00 83.01           C  
ATOM   2514  CB  SER   159     -16.788 -10.776  14.420  1.00 85.68           C  
ATOM   2515  OG  SER   159     -17.666 -10.308  13.413  1.00 90.57           O  
ATOM   2516  C   SER   159     -17.541  -9.437  16.394  1.00 84.74           C  
ATOM   2517  O   SER   159     -18.626  -8.866  16.577  1.00 83.29           O  
ATOM   2518  N   GLY   160     -16.354  -8.920  16.723  1.00 87.89           N  
ATOM   2519  CA  GLY   160     -16.183  -7.557  17.229  1.00 90.83           C  
ATOM   2520  C   GLY   160     -15.287  -7.479  18.454  1.00 93.62           C  
ATOM   2521  O   GLY   160     -15.753  -7.589  19.593  1.00 92.80           O  
END
