
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  109 (  837),  selected  109 , name 1fqt_A
# Molecule2: number of CA atoms  136 ( 1099),  selected  136 , name T0391.pdb
# PARAMETERS: 1fqt_A.T0391.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      K      14           -
LGA    M     1_A      Y      15          5.170
LGA    K     2_A      T      16          0.752
LGA    F     3_A      S      17          0.588
LGA    T     4_A      V      18          0.574
LGA    R     5_A      C      19          0.344
LGA    V     6_A      V      20          0.419
LGA    C     7_A      G      21          1.131
LGA    D     8_A      R      22          0.918
LGA    R     9_A      E      23          1.511
LGA    R    10_A      E      24          2.111
LGA    D    11_A      D      25          2.273
LGA    V    12_A      I      26          2.107
LGA    P    13_A      R      27          2.595
LGA    E    14_A      K      28           #
LGA    G    15_A      S      29           -
LGA    E    16_A      E      30          2.867
LGA    A    17_A      R      31          2.201
LGA    L    18_A      M      32          1.646
LGA    K    19_A      T      33          1.439
LGA    V    20_A      A      34          1.239
LGA    E    21_A      V      35          1.181
LGA    S    22_A      V      36          2.636
LGA    G    23_A      H      37          3.220
LGA    G    24_A      D      38          2.476
LGA    T    25_A      R      39          0.504
LGA    S    26_A      E      40          1.282
LGA    V    27_A      V      41          1.247
LGA    A    28_A      V      42          1.383
LGA    I    29_A      I      43          0.909
LGA    F    30_A      F      44          1.115
LGA    N    31_A      Y      45          1.136
LGA    V    32_A      H      46          1.735
LGA    D    33_A      K      47          0.895
LGA    G    34_A      G      48          1.147
LGA    E    35_A      E      49          1.321
LGA    L    36_A      Y      50          0.567
LGA    F    37_A      H      51          1.135
LGA    A    38_A      A      52          1.109
LGA    T    39_A      M      53          1.347
LGA    Q    40_A      D      54          1.413
LGA    D    41_A      I      55          1.307
LGA    R    42_A      R      56          1.521
LGA    C    43_A      C      57          1.079
LGA    T    44_A      Y      58          0.926
LGA    H    45_A      H      59          0.427
LGA    G    46_A      S      60          1.425
LGA    D    47_A      G      61          1.454
LGA    W    48_A      G      62          1.326
LGA    S    49_A      P      63          1.672
LGA    L    50_A      L      64          0.636
LGA    S    51_A      H      65          0.977
LGA    D    52_A      L      66          2.561
LGA    G    53_A      G      67          3.011
LGA    G    54_A      -       -           -
LGA    Y    55_A      E      68          0.634
LGA    L    56_A      I      69          0.870
LGA    E    57_A      E      70          1.822
LGA    G    58_A      D      71          4.568
LGA    -       -      F      72           -
LGA    -       -      N      73           -
LGA    -       -      G      74           -
LGA    -       -      Q      75           -
LGA    D    59_A      S      76          1.691
LGA    V    60_A      C      77          1.024
LGA    V    61_A      I      78          0.704
LGA    E    62_A      V      79          0.163
LGA    C    63_A      C      80          0.478
LGA    S    64_A      P      81          0.710
LGA    L    65_A      W      82          0.518
LGA    H    66_A      H      83          0.529
LGA    M    67_A      K      84          0.715
LGA    G    68_A      Y      85          0.367
LGA    K    69_A      K      86          0.243
LGA    F    70_A      I      87          0.841
LGA    C    71_A      T      88          0.800
LGA    V    72_A      L      89          0.332
LGA    R    73_A      A      90          0.903
LGA    T    74_A      T      91          1.180
LGA    G    75_A      G      92          1.112
LGA    K    76_A      E      93          1.155
LGA    V    77_A      G      94          1.370
LGA    K    78_A      L      95          1.485
LGA    S    79_A      Y      96          2.915
LGA    P    80_A      Q      97           -
LGA    P    81_A      S      98           -
LGA    P    82_A      I      99           -
LGA    -       -      N     100           -
LGA    -       -      P     101           -
LGA    -       -      K     107           -
LGA    -       -      P     108           -
LGA    -       -      K     109           -
LGA    -       -      W     110           -
LGA    -       -      C     111           -
LGA    -       -      S     112           -
LGA    C    83_A      K     113          4.975
LGA    E    84_A      G     114          5.930
LGA    A    85_A      V     115          2.415
LGA    -       -      K     116           -
LGA    L    86_A      Q     117          1.048
LGA    K    87_A      R     118          1.081
LGA    I    88_A      I     119          0.920
LGA    F    89_A      H     120          0.723
LGA    P    90_A      T     121          1.344
LGA    I    91_A      V     122          1.098
LGA    R    92_A      K     123          0.785
LGA    I    93_A      V     124          0.431
LGA    E    94_A      D     125          0.448
LGA    D    95_A      N     126          1.099
LGA    N    96_A      G     127          0.896
LGA    D    97_A      N     128          0.390
LGA    V    98_A      I     129          0.470
LGA    L    99_A      Y     130          0.497
LGA    V   100_A      V     131          0.589
LGA    D   101_A      T     132          1.221
LGA    F   102_A      L     133          2.816
LGA    E   103_A      -       -           -
LGA    A   104_A      S     134          2.523
LGA    G   105_A      K     135          4.305
LGA    Y   106_A      E     136          2.674
LGA    L   107_A      P     137          3.410
LGA    A   108_A      F     138           -
LGA    P   109_A      K     139           -
LGA    -       -      C     140           -
LGA    -       -      D     141           -
LGA    -       -      S     142           -
LGA    -       -      D     143           -
LGA    -       -      Y     144           -
LGA    -       -      Y     145           -
LGA    -       -      A     146           -
LGA    -       -      T     147           -
LGA    -       -      G     148           -
LGA    -       -      E     149           -
LGA    -       -      F     150           -
LGA    -       -      K     151           -
LGA    -       -      V     152           -
LGA    -       -      I     153           -
LGA    -       -      Q     154           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  109  136    5.0    100    1.82    22.00     67.860     5.203

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.561381 * X  +  -0.523299 * Y  +  -0.641101 * Z  +  48.200165
  Y_new =  -0.424621 * X  +  -0.482795 * Y  +   0.765902 * Z  + -32.170361
  Z_new =  -0.710316 * X  +   0.702188 * Y  +   0.048828 * Z  +  29.623484 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.501371   -1.640221  [ DEG:    86.0222    -93.9778 ]
  Theta =   0.789947    2.351646  [ DEG:    45.2606    134.7394 ]
  Phi   =  -2.494016    0.647577  [ DEG:  -142.8966     37.1034 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1fqt_A                                        
REMARK     2: T0391.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1fqt_A.T0391.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  109  136   5.0  100   1.82   22.00  67.860
REMARK  ---------------------------------------------------------- 
MOLECULE 1fqt_A
HEADER    OXIDOREDUCTASE                          06-SEP-00   1FQT              
TITLE     CRYSTAL STRUCTURE OF THE RIESKE-TYPE FERREDOXIN ASSOCIATED            
TITLE    2 WITH BIPHENYL DIOXYGENASE                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RIESKE-TYPE FERREDOXIN OF BIPHENYL DIOXYGENASE;            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: BIPHENYL DIOXYGENASE, BIPHENYL DIOXYGENASE SYSTEM           
COMPND   5 FERREDOXIN COMPONENT, BIPHENYL DIOXYGENASE;                          
COMPND   6 EC: 1.14.12.-;                                                       
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BURKHOLDERIA CEPACIA;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: LB400;                                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PEBRE12                                   
KEYWDS    RIESKE-TYPE FERREDOXIN, 2FE-2S CLUSTER, BETA SANDWICH                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.L.COLBERT,M.M.-J.COUTURE,L.D.ELTIS,J.T.BOLIN                        
REVDAT   3   01-APR-03 1FQT    1       JRNL                                     
REVDAT   2   27-APR-01 1FQT    2       LINK   CONECT REMARK                     
REVDAT   1   03-JAN-01 1FQT    0                                                
JRNL        AUTH   C.L.COLBERT,M.M.COUTURE,L.D.ELTIS,J.T.BOLIN                  
JRNL        TITL   A CLUSTER EXPOSED: STRUCTURE OF THE RIESKE                   
JRNL        TITL 2 FERREDOXIN FROM BIPHENYL DIOXYGENASE AND THE REDOX           
JRNL        TITL 3 PROPERTIES OF RIESKE FE-S PROTEINS.                          
JRNL        REF    STRUCTURE FOLD.DES.           V.   8  1267 2000              
JRNL        REFN   ASTM FODEFH  UK ISSN 1359-0278                               
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  1FQT A    1   109  UNP    P37332   BPHF_BURCE       1    109             
DBREF  1FQT B    1   109  UNP    P37332   BPHF_BURCE       1    109             
SEQRES   1 A  112  GLY SER HIS MET LYS PHE THR ARG VAL CYS ASP ARG ARG          
SEQRES   2 A  112  ASP VAL PRO GLU GLY GLU ALA LEU LYS VAL GLU SER GLY          
SEQRES   3 A  112  GLY THR SER VAL ALA ILE PHE ASN VAL ASP GLY GLU LEU          
SEQRES   4 A  112  PHE ALA THR GLN ASP ARG CYS THR HIS GLY ASP TRP SER          
SEQRES   5 A  112  LEU SER ASP GLY GLY TYR LEU GLU GLY ASP VAL VAL GLU          
SEQRES   6 A  112  CYS SER LEU HIS MET GLY LYS PHE CYS VAL ARG THR GLY          
SEQRES   7 A  112  LYS VAL LYS SER PRO PRO PRO CYS GLU ALA LEU LYS ILE          
SEQRES   8 A  112  PHE PRO ILE ARG ILE GLU ASP ASN ASP VAL LEU VAL ASP          
SEQRES   9 A  112  PHE GLU ALA GLY TYR LEU ALA PRO                              
SEQRES   1 B  112  GLY SER HIS MET LYS PHE THR ARG VAL CYS ASP ARG ARG          
SEQRES   2 B  112  ASP VAL PRO GLU GLY GLU ALA LEU LYS VAL GLU SER GLY          
SEQRES   3 B  112  GLY THR SER VAL ALA ILE PHE ASN VAL ASP GLY GLU LEU          
SEQRES   4 B  112  PHE ALA THR GLN ASP ARG CYS THR HIS GLY ASP TRP SER          
SEQRES   5 B  112  LEU SER ASP GLY GLY TYR LEU GLU GLY ASP VAL VAL GLU          
SEQRES   6 B  112  CYS SER LEU HIS MET GLY LYS PHE CYS VAL ARG THR GLY          
SEQRES   7 B  112  LYS VAL LYS SER PRO PRO PRO CYS GLU ALA LEU LYS ILE          
SEQRES   8 B  112  PHE PRO ILE ARG ILE GLU ASP ASN ASP VAL LEU VAL ASP          
SEQRES   9 B  112  PHE GLU ALA GLY TYR LEU ALA PRO                              
HET    FES   1001       4                                                       
HET    FES   2002       4                                                       
HET    GOL    901       6                                                       
HET    GOL    902       6                                                       
HET    GOL    903       6                                                       
HETNAM     FES FE2/S2 (INORGANIC) CLUSTER                                       
HETNAM     GOL GLYCEROL                                                         
FORMUL   3  FES    2(FE2 S2)                                                    
FORMUL   5  GOL    3(C3 H8 O3)                                                  
FORMUL   8  HOH   *314(H2 O)                                                    
CRYST1   76.400   53.100   64.700  90.00  90.00  90.00 P 21 21 2     8          
ATOM      1  N   MET A   1      23.364 -19.318  -6.954  1.00 45.47           N  
ATOM      2  CA  MET A   1      23.126 -20.326  -8.022  1.00 45.14           C  
ATOM      3  C   MET A   1      21.651 -20.679  -8.240  1.00 43.09           C  
ATOM      4  O   MET A   1      21.262 -20.976  -9.369  1.00 44.37           O  
ATOM      5  CB  MET A   1      23.934 -21.607  -7.747  1.00 47.10           C  
ATOM      6  CG  MET A   1      25.308 -21.634  -8.420  1.00 50.24           C  
ATOM      7  SD  MET A   1      26.209 -23.183  -8.218  0.00 51.52           S  
ATOM      8  CE  MET A   1      27.790 -22.587  -7.637  0.00 53.07           C  
ATOM      9  N   LYS A   2      20.821 -20.639  -7.195  1.00 38.50           N  
ATOM     10  CA  LYS A   2      19.398 -20.982  -7.365  1.00 34.44           C  
ATOM     11  C   LYS A   2      18.362 -20.102  -6.650  1.00 30.53           C  
ATOM     12  O   LYS A   2      17.901 -20.438  -5.558  1.00 27.78           O  
ATOM     13  CB  LYS A   2      19.166 -22.442  -6.964  1.00 35.61           C  
ATOM     14  CG  LYS A   2      19.744 -23.442  -7.949  0.00 35.10           C  
ATOM     15  CD  LYS A   2      19.365 -24.867  -7.586  0.00 35.16           C  
ATOM     16  CE  LYS A   2      19.938 -25.852  -8.592  0.00 35.07           C  
ATOM     17  NZ  LYS A   2      19.589 -27.257  -8.248  0.00 35.04           N  
ATOM     18  N   PHE A   3      17.958 -19.007  -7.291  1.00 26.89           N  
ATOM     19  CA  PHE A   3      16.985 -18.097  -6.687  1.00 23.92           C  
ATOM     20  C   PHE A   3      15.522 -18.425  -6.941  1.00 23.27           C  
ATOM     21  O   PHE A   3      15.119 -18.740  -8.066  1.00 24.70           O  
ATOM     22  CB  PHE A   3      17.266 -16.651  -7.104  1.00 21.79           C  
ATOM     23  CG  PHE A   3      18.484 -16.064  -6.444  1.00 21.57           C  
ATOM     24  CD1 PHE A   3      19.756 -16.344  -6.925  1.00 23.71           C  
ATOM     25  CD2 PHE A   3      18.361 -15.273  -5.303  1.00 20.50           C  
ATOM     26  CE1 PHE A   3      20.894 -15.856  -6.279  1.00 23.90           C  
ATOM     27  CE2 PHE A   3      19.492 -14.778  -4.647  1.00 20.48           C  
ATOM     28  CZ  PHE A   3      20.756 -15.069  -5.133  1.00 21.17           C  
ATOM     29  N   THR A   4      14.737 -18.326  -5.873  1.00 19.32           N  
ATOM     30  CA  THR A   4      13.307 -18.600  -5.886  1.00 19.88           C  
ATOM     31  C   THR A   4      12.540 -17.302  -5.637  1.00 20.32           C  
ATOM     32  O   THR A   4      12.840 -16.561  -4.699  1.00 18.06           O  
ATOM     33  CB  THR A   4      12.953 -19.621  -4.773  1.00 20.36           C  
ATOM     34  OG1 THR A   4      13.633 -20.857  -5.024  1.00 23.34           O  
ATOM     35  CG2 THR A   4      11.458 -19.871  -4.722  1.00 20.81           C  
ATOM     36  N   ARG A   5      11.550 -17.009  -6.474  1.00 17.91           N  
ATOM     37  CA  ARG A   5      10.773 -15.795  -6.302  1.00 18.79           C  
ATOM     38  C   ARG A   5       9.844 -16.037  -5.110  1.00 19.29           C  
ATOM     39  O   ARG A   5       9.045 -16.975  -5.125  1.00 21.05           O  
ATOM     40  CB  ARG A   5       9.985 -15.514  -7.586  1.00 20.58           C  
ATOM     41  CG  ARG A   5       9.388 -14.135  -7.680  1.00 23.47           C  
ATOM     42  CD  ARG A   5       8.031 -14.077  -7.017  1.00 27.94           C  
ATOM     43  NE  ARG A   5       7.387 -12.778  -7.194  1.00 26.93           N  
ATOM     44  CZ  ARG A   5       6.247 -12.432  -6.601  1.00 26.94           C  
ATOM     45  NH1 ARG A   5       5.634 -13.291  -5.800  1.00 29.50           N  
ATOM     46  NH2 ARG A   5       5.733 -11.228  -6.792  1.00 25.66           N  
ATOM     47  N   VAL A   6       9.944 -15.192  -4.081  1.00 18.08           N  
ATOM     48  CA  VAL A   6       9.145 -15.380  -2.877  1.00 17.34           C  
ATOM     49  C   VAL A   6       8.021 -14.399  -2.537  1.00 16.83           C  
ATOM     50  O   VAL A   6       7.096 -14.764  -1.797  1.00 16.68           O  
ATOM     51  CB  VAL A   6      10.057 -15.469  -1.617  1.00 16.28           C  
ATOM     52  CG1 VAL A   6      11.038 -16.625  -1.758  1.00 14.24           C  
ATOM     53  CG2 VAL A   6      10.824 -14.156  -1.423  1.00 17.13           C  
ATOM     54  N   CYS A   7       8.100 -13.165  -3.032  1.00 15.44           N  
ATOM     55  CA  CYS A   7       7.087 -12.154  -2.742  1.00 14.55           C  
ATOM     56  C   CYS A   7       7.360 -10.907  -3.559  1.00 14.72           C  
ATOM     57  O   CYS A   7       8.304 -10.858  -4.345  1.00 15.54           O  
ATOM     58  CB  CYS A   7       7.092 -11.774  -1.249  1.00 16.32           C  
ATOM     59  SG  CYS A   7       8.640 -10.961  -0.688  1.00 15.64           S  
ATOM     60  N   ASP A   8       6.511  -9.909  -3.385  1.00 13.84           N  
ATOM     61  CA  ASP A   8       6.688  -8.636  -4.058  1.00 16.76           C  
ATOM     62  C   ASP A   8       7.406  -7.799  -3.006  1.00 17.34           C  
ATOM     63  O   ASP A   8       7.141  -7.956  -1.812  1.00 16.50           O  
ATOM     64  CB  ASP A   8       5.325  -8.022  -4.388  1.00 18.43           C  
ATOM     65  CG  ASP A   8       5.444  -6.717  -5.153  1.00 18.53           C  
ATOM     66  OD1 ASP A   8       5.218  -6.734  -6.381  1.00 19.41           O  
ATOM     67  OD2 ASP A   8       5.763  -5.683  -4.536  1.00 20.11           O  
ATOM     68  N   ARG A   9       8.317  -6.931  -3.430  1.00 18.17           N  
ATOM     69  CA  ARG A   9       9.054  -6.088  -2.487  1.00 20.33           C  
ATOM     70  C   ARG A   9       8.102  -5.244  -1.625  1.00 20.39           C  
ATOM     71  O   ARG A   9       8.399  -4.924  -0.477  1.00 19.61           O  
ATOM     72  CB  ARG A   9      10.028  -5.180  -3.250  1.00 22.69           C  
ATOM     73  CG  ARG A   9       9.412  -3.887  -3.738  0.50 26.27           C  
ATOM     75  CD  ARG A   9      10.441  -2.957  -4.369  0.50 28.13           C  
ATOM     77  NE  ARG A   9       9.879  -1.617  -4.516  0.50 32.22           N  
ATOM     79  CZ  ARG A   9       8.798  -1.341  -5.240  0.50 32.55           C  
ATOM     81  NH1 ARG A   9       8.170  -2.312  -5.889  0.50 33.38           N  
ATOM     83  NH2 ARG A   9       8.328  -0.102  -5.293  0.50 33.56           N  
ATOM     85  N   ARG A  10       6.938  -4.895  -2.166  1.00 16.99           N  
ATOM     86  CA  ARG A  10       5.983  -4.093  -1.419  1.00 16.01           C  
ATOM     87  C   ARG A  10       5.248  -4.874  -0.324  1.00 16.23           C  
ATOM     88  O   ARG A  10       4.518  -4.282   0.477  1.00 18.84           O  
ATOM     89  CB  ARG A  10       4.989  -3.450  -2.402  1.00 15.68           C  
ATOM     90  CG  ARG A  10       5.676  -2.431  -3.308  1.00 15.93           C  
ATOM     91  CD  ARG A  10       4.880  -2.097  -4.576  1.00 14.69           C  
ATOM     92  NE  ARG A  10       4.798  -3.235  -5.480  1.00 16.68           N  
ATOM     93  CZ  ARG A  10       4.327  -3.153  -6.721  1.00 17.98           C  
ATOM     94  NH1 ARG A  10       3.909  -1.978  -7.181  1.00 19.50           N  
ATOM     95  NH2 ARG A  10       4.265  -4.239  -7.485  1.00 16.90           N  
ATOM     96  N   ASP A  11       5.469  -6.186  -0.282  1.00 15.71           N  
ATOM     97  CA  ASP A  11       4.864  -7.067   0.719  1.00 17.34           C  
ATOM     98  C   ASP A  11       5.591  -6.981   2.068  1.00 18.99           C  
ATOM     99  O   ASP A  11       5.118  -7.524   3.062  1.00 20.66           O  
ATOM    100  CB  ASP A  11       4.899  -8.524   0.252  1.00 17.57           C  
ATOM    101  CG  ASP A  11       3.993  -8.779  -0.936  1.00 18.98           C  
ATOM    102  OD1 ASP A  11       3.054  -7.983  -1.143  1.00 19.20           O  
ATOM    103  OD2 ASP A  11       4.215  -9.782  -1.626  1.00 17.43           O  
ATOM    104  N   VAL A  12       6.740  -6.311   2.082  1.00 18.13           N  
ATOM    105  CA  VAL A  12       7.531  -6.146   3.299  1.00 20.03           C  
ATOM    106  C   VAL A  12       7.771  -4.651   3.486  1.00 21.25           C  
ATOM    107  O   VAL A  12       8.775  -4.113   3.022  1.00 23.98           O  
ATOM    108  CB  VAL A  12       8.900  -6.856   3.190  1.00 18.08           C  
ATOM    109  CG1 VAL A  12       9.527  -6.983   4.594  1.00 19.62           C  
ATOM    110  CG2 VAL A  12       8.744  -8.220   2.543  1.00 22.21           C  
ATOM    111  N   PRO A  13       6.846  -3.962   4.167  1.00 24.09           N  
ATOM    112  CA  PRO A  13       6.944  -2.522   4.419  1.00 26.28           C  
ATOM    113  C   PRO A  13       8.102  -2.207   5.357  1.00 24.95           C  
ATOM    114  O   PRO A  13       8.540  -3.066   6.129  1.00 23.16           O  
ATOM    115  CB  PRO A  13       5.599  -2.181   5.056  1.00 27.73           C  
ATOM    116  CG  PRO A  13       4.701  -3.329   4.655  1.00 27.89           C  
ATOM    117  CD  PRO A  13       5.619  -4.504   4.765  1.00 27.29           C  
ATOM    118  N   GLU A  14       8.580  -0.972   5.293  1.00 24.76           N  
ATOM    119  CA  GLU A  14       9.687  -0.533   6.128  1.00 25.01           C  
ATOM    120  C   GLU A  14       9.384  -0.817   7.592  1.00 23.43           C  
ATOM    121  O   GLU A  14       8.298  -0.489   8.086  1.00 21.92           O  
ATOM    122  CB  GLU A  14       9.908   0.963   5.925  1.00 28.33           C  
ATOM    123  CG  GLU A  14      11.264   1.466   6.359  1.00 34.79           C  
ATOM    124  CD  GLU A  14      11.403   2.964   6.185  1.00 39.12           C  
ATOM    125  OE1 GLU A  14      11.090   3.710   7.140  1.00 41.63           O  
ATOM    126  OE2 GLU A  14      11.811   3.397   5.085  1.00 41.68           O  
ATOM    127  N   GLY A  15      10.346  -1.425   8.288  1.00 19.46           N  
ATOM    128  CA  GLY A  15      10.167  -1.735   9.692  1.00 18.49           C  
ATOM    129  C   GLY A  15       9.412  -3.017   9.989  1.00 18.34           C  
ATOM    130  O   GLY A  15       9.181  -3.346  11.152  1.00 17.90           O  
ATOM    131  N   GLU A  16       9.038  -3.749   8.945  1.00 16.56           N  
ATOM    132  CA  GLU A  16       8.294  -4.990   9.114  1.00 20.19           C  
ATOM    133  C   GLU A  16       9.082  -6.204   8.639  1.00 16.90           C  
ATOM    134  O   GLU A  16      10.134  -6.078   8.013  1.00 16.21           O  
ATOM    135  CB  GLU A  16       6.987  -4.939   8.315  1.00 23.06           C  
ATOM    136  CG  GLU A  16       6.126  -3.698   8.551  1.00 32.53           C  
ATOM    137  CD  GLU A  16       5.200  -3.836   9.741  1.00 37.79           C  
ATOM    138  OE1 GLU A  16       4.365  -2.926   9.948  1.00 40.36           O  
ATOM    139  OE2 GLU A  16       5.299  -4.849  10.468  1.00 39.86           O  
ATOM    140  N   ALA A  17       8.535  -7.381   8.925  1.00 16.16           N  
ATOM    141  CA  ALA A  17       9.144  -8.642   8.517  1.00 16.20           C  
ATOM    142  C   ALA A  17       8.109  -9.530   7.849  1.00 16.28           C  
ATOM    143  O   ALA A  17       6.902  -9.367   8.061  1.00 17.07           O  
ATOM    144  CB  ALA A  17       9.730  -9.363   9.728  1.00 15.90           C  
ATOM    145  N   LEU A  18       8.587 -10.464   7.036  1.00 13.57           N  
ATOM    146  CA  LEU A  18       7.713 -11.402   6.344  1.00 15.26           C  
ATOM    147  C   LEU A  18       8.377 -12.763   6.301  1.00 15.35           C  
ATOM    148  O   LEU A  18       9.555 -12.866   5.959  1.00 14.65           O  
ATOM    149  CB  LEU A  18       7.440 -10.925   4.911  1.00 15.34           C  
ATOM    150  CG  LEU A  18       6.602 -11.898   4.071  1.00 18.67           C  
ATOM    151  CD1 LEU A  18       5.192 -11.956   4.646  1.00 20.41           C  
ATOM    152  CD2 LEU A  18       6.562 -11.441   2.617  1.00 18.36           C  
ATOM    153  N   LYS A  19       7.641 -13.810   6.659  1.00 13.62           N  
ATOM    154  CA  LYS A  19       8.192 -15.158   6.606  1.00 13.30           C  
ATOM    155  C   LYS A  19       7.927 -15.762   5.227  1.00 14.97           C  
ATOM    156  O   LYS A  19       6.808 -15.670   4.713  1.00 16.70           O  
ATOM    157  CB  LYS A  19       7.529 -16.059   7.655  1.00 14.26           C  
ATOM    158  CG  LYS A  19       8.032 -17.495   7.649  0.50 15.22           C  
ATOM    160  CD  LYS A  19       7.259 -18.329   8.657  0.50 19.73           C  
ATOM    162  CE  LYS A  19       7.605 -19.800   8.565  0.50 21.70           C  
ATOM    164  NZ  LYS A  19       6.683 -20.592   9.425  0.50 23.32           N  
ATOM    166  N   VAL A  20       8.947 -16.353   4.616  1.00 11.37           N  
ATOM    167  CA  VAL A  20       8.757 -17.029   3.325  1.00 13.63           C  
ATOM    168  C   VAL A  20       9.361 -18.411   3.449  1.00 15.47           C  
ATOM    169  O   VAL A  20      10.338 -18.603   4.171  1.00 14.02           O  
ATOM    170  CB  VAL A  20       9.412 -16.275   2.125  1.00 12.87           C  
ATOM    171  CG1 VAL A  20       8.748 -14.916   1.947  1.00 14.47           C  
ATOM    172  CG2 VAL A  20      10.936 -16.124   2.334  1.00 14.06           C  
ATOM    173  N   GLU A  21       8.784 -19.403   2.778  1.00 16.67           N  
ATOM    174  CA  GLU A  21       9.354 -20.732   2.901  1.00 16.82           C  
ATOM    175  C   GLU A  21       9.346 -21.530   1.611  1.00 16.88           C  
ATOM    176  O   GLU A  21       8.515 -21.305   0.718  1.00 18.45           O  
ATOM    177  CB  GLU A  21       8.663 -21.529   4.018  1.00 21.62           C  
ATOM    178  CG  GLU A  21       7.339 -22.148   3.739  0.50 21.63           C  
ATOM    180  CD  GLU A  21       6.894 -22.977   4.932  0.50 21.56           C  
ATOM    182  OE1 GLU A  21       6.136 -22.460   5.779  0.50 19.26           O  
ATOM    184  OE2 GLU A  21       7.333 -24.144   5.038  0.50 25.03           O  
ATOM    186  N   SER A  22      10.306 -22.440   1.514  1.00 16.68           N  
ATOM    187  CA  SER A  22      10.446 -23.309   0.354  1.00 16.76           C  
ATOM    188  C   SER A  22      11.262 -24.549   0.698  1.00 19.07           C  
ATOM    189  O   SER A  22      12.319 -24.456   1.320  1.00 18.39           O  
ATOM    190  CB  SER A  22      11.118 -22.556  -0.796  1.00 19.35           C  
ATOM    191  OG  SER A  22      11.205 -23.379  -1.956  1.00 23.58           O  
ATOM    192  N   GLY A  23      10.772 -25.717   0.283  1.00 19.68           N  
ATOM    193  CA  GLY A  23      11.485 -26.957   0.541  1.00 20.76           C  
ATOM    194  C   GLY A  23      11.721 -27.266   2.002  1.00 19.05           C  
ATOM    195  O   GLY A  23      12.657 -27.990   2.346  1.00 23.30           O  
ATOM    196  N   GLY A  24      10.883 -26.711   2.865  1.00 19.94           N  
ATOM    197  CA  GLY A  24      11.032 -26.942   4.292  1.00 19.40           C  
ATOM    198  C   GLY A  24      12.003 -25.972   4.958  1.00 20.09           C  
ATOM    199  O   GLY A  24      12.336 -26.125   6.131  1.00 22.22           O  
ATOM    200  N   THR A  25      12.469 -24.982   4.206  1.00 18.39           N  
ATOM    201  CA  THR A  25      13.390 -23.987   4.760  1.00 16.67           C  
ATOM    202  C   THR A  25      12.616 -22.691   4.951  1.00 16.08           C  
ATOM    203  O   THR A  25      11.987 -22.202   4.021  1.00 17.49           O  
ATOM    204  CB  THR A  25      14.574 -23.757   3.808  1.00 16.74           C  
ATOM    205  OG1 THR A  25      15.301 -24.983   3.667  1.00 17.51           O  
ATOM    206  CG2 THR A  25      15.508 -22.676   4.352  1.00 15.15           C  
ATOM    207  N   SER A  26      12.652 -22.149   6.170  1.00 13.15           N  
ATOM    208  CA  SER A  26      11.935 -20.912   6.484  1.00 11.72           C  
ATOM    209  C   SER A  26      12.907 -19.738   6.600  1.00 10.84           C  
ATOM    210  O   SER A  26      13.910 -19.829   7.289  1.00 13.17           O  
ATOM    211  CB  SER A  26      11.167 -21.065   7.794  1.00 14.73           C  
ATOM    212  OG  SER A  26      10.167 -22.077   7.670  1.00 18.33           O  
ATOM    213  N   VAL A  27      12.579 -18.650   5.912  1.00  9.75           N  
ATOM    214  CA  VAL A  27      13.423 -17.452   5.899  1.00  9.15           C  
ATOM    215  C   VAL A  27      12.616 -16.222   6.299  1.00 11.12           C  
ATOM    216  O   VAL A  27      11.471 -16.062   5.890  1.00 11.80           O  
ATOM    217  CB  VAL A  27      14.001 -17.250   4.479  1.00  8.35           C  
ATOM    218  CG1 VAL A  27      14.662 -15.876   4.356  1.00  9.87           C  
ATOM    219  CG2 VAL A  27      15.002 -18.367   4.167  1.00 11.48           C  
ATOM    220  N   ALA A  28      13.202 -15.363   7.133  1.00  9.83           N  
ATOM    221  CA  ALA A  28      12.554 -14.125   7.526  1.00  9.76           C  
ATOM    222  C   ALA A  28      13.172 -13.016   6.671  1.00 10.95           C  
ATOM    223  O   ALA A  28      14.396 -12.960   6.507  1.00 10.79           O  
ATOM    224  CB  ALA A  28      12.802 -13.832   9.015  1.00 10.01           C  
ATOM    225  N   ILE A  29      12.323 -12.178   6.087  1.00  9.92           N  
ATOM    226  CA  ILE A  29      12.792 -11.045   5.285  1.00  9.14           C  
ATOM    227  C   ILE A  29      12.392  -9.799   6.079  1.00  9.86           C  
ATOM    228  O   ILE A  29      11.224  -9.652   6.469  1.00 10.93           O  
ATOM    229  CB  ILE A  29      12.101 -11.015   3.900  1.00  9.82           C  
ATOM    230  CG1 ILE A  29      12.437 -12.298   3.133  1.00 12.56           C  
ATOM    231  CG2 ILE A  29      12.552  -9.802   3.121  1.00 11.10           C  
ATOM    232  CD1 ILE A  29      11.747 -12.395   1.776  1.00 17.55           C  
ATOM    233  N   PHE A  30      13.364  -8.925   6.331  1.00  8.93           N  
ATOM    234  CA  PHE A  30      13.159  -7.684   7.083  1.00 10.57           C  
ATOM    235  C   PHE A  30      13.429  -6.494   6.195  1.00 11.14           C  
ATOM    236  O   PHE A  30      14.386  -6.509   5.424  1.00 11.50           O  
ATOM    237  CB  PHE A  30      14.148  -7.585   8.256  1.00  9.16           C  
ATOM    238  CG  PHE A  30      14.067  -8.736   9.218  1.00  9.10           C  
ATOM    239  CD1 PHE A  30      14.865  -9.869   9.032  1.00 11.58           C  
ATOM    240  CD2 PHE A  30      13.189  -8.701  10.289  1.00  9.26           C  
ATOM    241  CE1 PHE A  30      14.792 -10.955   9.904  1.00  9.14           C  
ATOM    242  CE2 PHE A  30      13.099  -9.783  11.171  1.00 10.06           C  
ATOM    243  CZ  PHE A  30      13.905 -10.919  10.974  1.00 10.21           C  
ATOM    244  N   ASN A  31      12.604  -5.460   6.308  1.00 13.11           N  
ATOM    245  CA  ASN A  31      12.828  -4.245   5.536  1.00 12.95           C  
ATOM    246  C   ASN A  31      13.416  -3.200   6.496  1.00 13.49           C  
ATOM    247  O   ASN A  31      12.743  -2.748   7.417  1.00 12.99           O  
ATOM    248  CB  ASN A  31      11.504  -3.726   4.945  1.00 14.80           C  
ATOM    249  CG  ASN A  31      11.675  -2.424   4.165  1.00 16.90           C  
ATOM    250  OD1 ASN A  31      12.585  -1.649   4.425  1.00 16.87           O  
ATOM    251  ND2 ASN A  31      10.776  -2.176   3.217  1.00 17.31           N  
ATOM    252  N   VAL A  32      14.695  -2.875   6.318  1.00 12.85           N  
ATOM    253  CA  VAL A  32      15.349  -1.864   7.139  1.00 13.84           C  
ATOM    254  C   VAL A  32      15.598  -0.646   6.244  1.00 16.32           C  
ATOM    255  O   VAL A  32      16.421  -0.687   5.339  1.00 14.47           O  
ATOM    256  CB  VAL A  32      16.717  -2.345   7.693  1.00 14.92           C  
ATOM    257  CG1 VAL A  32      17.317  -1.252   8.600  1.00 15.04           C  
ATOM    258  CG2 VAL A  32      16.540  -3.637   8.488  1.00 13.88           C  
ATOM    259  N   ASP A  33      14.852   0.425   6.489  1.00 18.06           N  
ATOM    260  CA  ASP A  33      15.007   1.668   5.729  1.00 20.91           C  
ATOM    261  C   ASP A  33      14.971   1.518   4.205  1.00 20.47           C  
ATOM    262  O   ASP A  33      15.730   2.171   3.493  1.00 21.74           O  
ATOM    263  CB  ASP A  33      16.307   2.364   6.156  1.00 22.82           C  
ATOM    264  CG  ASP A  33      16.178   3.076   7.491  0.60 25.80           C  
ATOM    266  OD1 ASP A  33      15.603   2.494   8.433  0.60 29.39           O  
ATOM    268  OD2 ASP A  33      16.661   4.222   7.600  0.60 31.49           O  
ATOM    270  N   GLY A  34      14.099   0.652   3.706  1.00 19.92           N  
ATOM    271  CA  GLY A  34      13.975   0.485   2.266  1.00 18.29           C  
ATOM    272  C   GLY A  34      14.775  -0.622   1.614  1.00 17.81           C  
ATOM    273  O   GLY A  34      14.626  -0.872   0.417  1.00 19.01           O  
ATOM    274  N   GLU A  35      15.646  -1.278   2.377  1.00 16.37           N  
ATOM    275  CA  GLU A  35      16.433  -2.373   1.842  1.00 13.32           C  
ATOM    276  C   GLU A  35      16.027  -3.652   2.558  1.00 13.22           C  
ATOM    277  O   GLU A  35      15.692  -3.629   3.734  1.00 12.37           O  
ATOM    278  CB  GLU A  35      17.929  -2.114   2.030  1.00 17.49           C  
ATOM    279  CG  GLU A  35      18.451  -1.079   1.029  1.00 18.03           C  
ATOM    280  CD  GLU A  35      19.899  -0.724   1.248  1.00 18.76           C  
ATOM    281  OE1 GLU A  35      20.244  -0.317   2.377  1.00 22.37           O  
ATOM    282  OE2 GLU A  35      20.681  -0.846   0.284  1.00 21.60           O  
ATOM    283  N   LEU A  36      16.044  -4.761   1.833  1.00 10.86           N  
ATOM    284  CA  LEU A  36      15.632  -6.043   2.403  1.00 10.48           C  
ATOM    285  C   LEU A  36      16.810  -6.914   2.820  1.00 10.41           C  
ATOM    286  O   LEU A  36      17.844  -6.975   2.135  1.00 10.20           O  
ATOM    287  CB  LEU A  36      14.763  -6.804   1.389  1.00 12.94           C  
ATOM    288  CG  LEU A  36      13.539  -6.051   0.855  1.00 14.05           C  
ATOM    289  CD1 LEU A  36      12.743  -7.019  -0.032  1.00 14.06           C  
ATOM    290  CD2 LEU A  36      12.676  -5.536   1.984  1.00 15.09           C  
ATOM    291  N   PHE A  37      16.626  -7.618   3.938  1.00 10.88           N  
ATOM    292  CA  PHE A  37      17.641  -8.507   4.490  1.00 10.04           C  
ATOM    293  C   PHE A  37      16.984  -9.832   4.853  1.00  9.90           C  
ATOM    294  O   PHE A  37      15.875  -9.855   5.392  1.00 12.02           O  
ATOM    295  CB  PHE A  37      18.280  -7.865   5.721  1.00  8.66           C  
ATOM    296  CG  PHE A  37      18.992  -6.587   5.407  1.00  8.65           C  
ATOM    297  CD1 PHE A  37      18.317  -5.374   5.441  1.00 11.86           C  
ATOM    298  CD2 PHE A  37      20.306  -6.612   4.945  1.00 12.33           C  
ATOM    299  CE1 PHE A  37      18.940  -4.198   5.009  1.00 11.55           C  
ATOM    300  CE2 PHE A  37      20.940  -5.431   4.505  1.00 12.47           C  
ATOM    301  CZ  PHE A  37      20.247  -4.232   4.540  1.00 12.03           C  
ATOM    302  N   ALA A  38      17.668 -10.930   4.553  1.00  9.80           N  
ATOM    303  CA  ALA A  38      17.108 -12.246   4.824  1.00 10.41           C  
ATOM    304  C   ALA A  38      17.928 -13.048   5.821  1.00  9.15           C  
ATOM    305  O   ALA A  38      19.152 -13.058   5.757  1.00  8.76           O  
ATOM    306  CB  ALA A  38      16.988 -13.027   3.510  1.00 10.76           C  
ATOM    307  N   THR A  39      17.243 -13.691   6.759  1.00  9.36           N  
ATOM    308  CA  THR A  39      17.905 -14.539   7.751  1.00  8.37           C  
ATOM    309  C   THR A  39      17.071 -15.789   7.935  1.00  9.87           C  
ATOM    310  O   THR A  39      15.938 -15.867   7.442  1.00  9.32           O  
ATOM    311  CB  THR A  39      17.973 -13.893   9.148  1.00  6.88           C  
ATOM    312  OG1 THR A  39      16.651 -13.838   9.717  1.00  8.71           O  
ATOM    313  CG2 THR A  39      18.536 -12.480   9.059  1.00  9.08           C  
ATOM    314  N   GLN A  40      17.633 -16.779   8.618  1.00  9.35           N  
ATOM    315  CA  GLN A  40      16.839 -17.960   8.939  1.00  9.47           C  
ATOM    316  C   GLN A  40      15.675 -17.414   9.780  1.00  9.29           C  
ATOM    317  O   GLN A  40      15.836 -16.449  10.515  1.00  8.70           O  
ATOM    318  CB  GLN A  40      17.656 -18.952   9.756  1.00  8.20           C  
ATOM    319  CG  GLN A  40      18.096 -18.459  11.144  1.00 10.73           C  
ATOM    320  CD  GLN A  40      18.932 -19.507  11.862  1.00  9.43           C  
ATOM    321  OE1 GLN A  40      20.040 -19.835  11.419  1.00  9.60           O  
ATOM    322  NE2 GLN A  40      18.397 -20.059  12.958  1.00 11.03           N  
ATOM    323  N   ASP A  41      14.492 -18.009   9.666  1.00  8.73           N  
ATOM    324  CA  ASP A  41      13.359 -17.490  10.418  1.00 11.03           C  
ATOM    325  C   ASP A  41      13.383 -17.808  11.899  1.00  9.66           C  
ATOM    326  O   ASP A  41      12.897 -17.026  12.717  1.00 11.51           O  
ATOM    327  CB  ASP A  41      12.035 -18.008   9.840  1.00 10.87           C  
ATOM    328  CG  ASP A  41      10.824 -17.293  10.435  1.00 11.74           C  
ATOM    329  OD1 ASP A  41      10.721 -16.062  10.273  1.00 14.51           O  
ATOM    330  OD2 ASP A  41       9.968 -17.961  11.055  1.00 12.03           O  
ATOM    331  N   ARG A  42      13.935 -18.955  12.261  1.00  9.11           N  
ATOM    332  CA  ARG A  42      13.936 -19.315  13.668  1.00  9.16           C  
ATOM    333  C   ARG A  42      15.066 -18.731  14.487  1.00  9.57           C  
ATOM    334  O   ARG A  42      16.205 -18.640  14.034  1.00 10.76           O  
ATOM    335  CB  ARG A  42      14.002 -20.828  13.828  1.00 14.02           C  
ATOM    336  CG  ARG A  42      12.776 -21.571  13.342  1.00 15.69           C  
ATOM    337  CD  ARG A  42      13.041 -23.057  13.416  1.00 18.78           C  
ATOM    338  NE  ARG A  42      11.928 -23.850  12.902  1.00 19.87           N  
ATOM    339  CZ  ARG A  42      11.664 -24.045  11.612  1.00 24.73           C  
ATOM    340  NH1 ARG A  42      12.431 -23.500  10.671  1.00 21.12           N  
ATOM    341  NH2 ARG A  42      10.639 -24.815  11.266  1.00 24.27           N  
ATOM    342  N   CYS A  43      14.720 -18.346  15.702  1.00  9.30           N  
ATOM    343  CA  CYS A  43      15.728 -17.881  16.646  1.00  7.34           C  
ATOM    344  C   CYS A  43      16.725 -19.054  16.801  1.00  9.08           C  
ATOM    345  O   CYS A  43      16.340 -20.229  16.732  1.00 11.39           O  
ATOM    346  CB  CYS A  43      15.050 -17.606  17.984  1.00  8.59           C  
ATOM    347  SG  CYS A  43      16.167 -16.994  19.277  1.00  8.44           S  
ATOM    348  N   THR A  44      18.003 -18.768  17.032  1.00  8.34           N  
ATOM    349  CA  THR A  44      18.943 -19.880  17.178  1.00  7.61           C  
ATOM    350  C   THR A  44      18.826 -20.539  18.548  1.00  8.49           C  
ATOM    351  O   THR A  44      19.415 -21.593  18.779  1.00 11.89           O  
ATOM    352  CB  THR A  44      20.409 -19.428  16.980  1.00  8.11           C  
ATOM    353  OG1 THR A  44      20.732 -18.418  17.942  1.00  8.49           O  
ATOM    354  CG2 THR A  44      20.609 -18.859  15.572  1.00  7.75           C  
ATOM    355  N   HIS A  45      18.057 -19.929  19.453  1.00  8.62           N  
ATOM    356  CA  HIS A  45      17.891 -20.446  20.820  1.00 10.15           C  
ATOM    357  C   HIS A  45      16.604 -21.269  20.996  1.00 11.13           C  
ATOM    358  O   HIS A  45      16.335 -21.788  22.082  1.00 11.23           O  
ATOM    359  CB  HIS A  45      17.949 -19.245  21.807  1.00  8.48           C  
ATOM    360  CG  HIS A  45      17.831 -19.611  23.258  1.00  9.10           C  
ATOM    361  ND1 HIS A  45      16.725 -19.282  24.020  1.00  9.37           N  
ATOM    362  CD2 HIS A  45      18.701 -20.212  24.104  1.00 10.46           C  
ATOM    363  CE1 HIS A  45      16.928 -19.661  25.274  1.00 12.17           C  
ATOM    364  NE2 HIS A  45      18.122 -20.227  25.349  1.00 10.65           N  
ATOM    365  N   GLY A  46      15.823 -21.429  19.925  1.00  9.87           N  
ATOM    366  CA  GLY A  46      14.599 -22.208  20.053  1.00  9.83           C  
ATOM    367  C   GLY A  46      13.769 -22.219  18.787  1.00  9.09           C  
ATOM    368  O   GLY A  46      13.990 -21.397  17.898  1.00 10.07           O  
ATOM    369  N   ASP A  47      12.811 -23.149  18.703  1.00 11.33           N  
ATOM    370  CA  ASP A  47      11.936 -23.223  17.525  1.00 12.01           C  
ATOM    371  C   ASP A  47      10.889 -22.139  17.711  1.00 11.38           C  
ATOM    372  O   ASP A  47       9.755 -22.391  18.137  1.00 12.25           O  
ATOM    373  CB  ASP A  47      11.269 -24.601  17.431  1.00 13.84           C  
ATOM    374  CG  ASP A  47      10.484 -24.774  16.140  1.00 16.08           C  
ATOM    375  OD1 ASP A  47      10.449 -23.824  15.329  1.00 17.30           O  
ATOM    376  OD2 ASP A  47       9.898 -25.866  15.931  1.00 19.90           O  
ATOM    377  N   TRP A  48      11.286 -20.920  17.391  1.00 10.23           N  
ATOM    378  CA  TRP A  48      10.427 -19.766  17.580  1.00 10.41           C  
ATOM    379  C   TRP A  48      10.669 -18.797  16.434  1.00 10.51           C  
ATOM    380  O   TRP A  48      11.810 -18.406  16.173  1.00 10.92           O  
ATOM    381  CB  TRP A  48      10.780 -19.110  18.931  1.00 10.91           C  
ATOM    382  CG  TRP A  48       9.800 -18.067  19.378  1.00  9.70           C  
ATOM    383  CD1 TRP A  48       9.861 -16.722  19.156  1.00 11.95           C  
ATOM    384  CD2 TRP A  48       8.589 -18.298  20.119  1.00 10.02           C  
ATOM    385  NE1 TRP A  48       8.773 -16.102  19.719  1.00 10.53           N  
ATOM    386  CE2 TRP A  48       7.977 -17.042  20.313  1.00 10.27           C  
ATOM    387  CE3 TRP A  48       7.972 -19.442  20.640  1.00 10.23           C  
ATOM    388  CZ2 TRP A  48       6.765 -16.890  21.010  1.00 10.30           C  
ATOM    389  CZ3 TRP A  48       6.763 -19.298  21.337  1.00 11.58           C  
ATOM    390  CH2 TRP A  48       6.175 -18.026  21.515  1.00 10.19           C  
ATOM    391  N   SER A  49       9.597 -18.389  15.759  1.00 10.40           N  
ATOM    392  CA  SER A  49       9.735 -17.493  14.612  1.00 10.43           C  
ATOM    393  C   SER A  49      10.085 -16.041  14.913  1.00 11.41           C  
ATOM    394  O   SER A  49       9.401 -15.380  15.695  1.00 12.36           O  
ATOM    395  CB  SER A  49       8.445 -17.517  13.792  1.00 10.52           C  
ATOM    396  OG  SER A  49       8.532 -16.601  12.711  1.00 12.20           O  
ATOM    397  N   LEU A  50      11.144 -15.542  14.275  1.00 10.45           N  
ATOM    398  CA  LEU A  50      11.545 -14.146  14.466  1.00  9.61           C  
ATOM    399  C   LEU A  50      10.637 -13.202  13.670  1.00 13.29           C  
ATOM    400  O   LEU A  50      10.476 -12.032  14.021  1.00 15.66           O  
ATOM    401  CB  LEU A  50      12.996 -13.938  14.022  1.00  9.15           C  
ATOM    402  CG  LEU A  50      14.034 -14.652  14.892  1.00  9.75           C  
ATOM    403  CD1 LEU A  50      15.419 -14.474  14.282  1.00 11.15           C  
ATOM    404  CD2 LEU A  50      13.988 -14.114  16.318  1.00 11.24           C  
ATOM    405  N   SER A  51      10.046 -13.698  12.587  1.00 13.14           N  
ATOM    406  CA  SER A  51       9.184 -12.831  11.795  1.00 15.58           C  
ATOM    407  C   SER A  51       7.785 -12.741  12.426  1.00 17.85           C  
ATOM    408  O   SER A  51       7.217 -11.655  12.513  1.00 19.39           O  
ATOM    409  CB  SER A  51       9.109 -13.340  10.354  1.00 15.01           C  
ATOM    410  OG  SER A  51       8.518 -14.621  10.301  1.00 17.49           O  
ATOM    411  N   ASP A  52       7.234 -13.876  12.857  0.50 17.39           N  
ATOM    413  CA  ASP A  52       5.893 -13.936  13.475  0.50 19.10           C  
ATOM    415  C   ASP A  52       5.777 -13.265  14.854  0.50 19.92           C  
ATOM    417  O   ASP A  52       4.675 -13.161  15.411  0.50 15.69           O  
ATOM    419  CB  ASP A  52       5.440 -15.392  13.635  0.50 21.34           C  
ATOM    421  CG  ASP A  52       5.038 -16.048  12.325  0.50 24.56           C  
ATOM    423  OD1 ASP A  52       4.730 -17.257  12.366  0.50 27.60           O  
ATOM    425  OD2 ASP A  52       5.021 -15.382  11.265  0.50 24.78           O  
ATOM    427  N   GLY A  53       6.906 -12.830  15.408  0.50 19.62           N  
ATOM    429  CA  GLY A  53       6.905 -12.190  16.714  0.50 21.46           C  
ATOM    431  C   GLY A  53       6.562 -10.711  16.668  0.50 22.76           C  
ATOM    433  O   GLY A  53       5.995 -10.167  17.618  0.50 23.61           O  
ATOM    435  N   GLY A  54       6.927 -10.055  15.571  0.50 23.54           N  
ATOM    437  CA  GLY A  54       6.626  -8.643  15.405  0.50 23.43           C  
ATOM    439  C   GLY A  54       7.474  -7.616  16.136  0.50 23.02           C  
ATOM    441  O   GLY A  54       7.008  -6.495  16.358  0.50 26.05           O  
ATOM    443  N   TYR A  55       8.704  -7.970  16.507  0.50 21.60           N  
ATOM    445  CA  TYR A  55       9.588  -7.037  17.205  0.50 19.41           C  
ATOM    447  C   TYR A  55      10.877  -6.707  16.434  0.50 19.14           C  
ATOM    449  O   TYR A  55      11.879  -7.409  16.560  0.50 20.03           O  
ATOM    451  CB  TYR A  55       9.975  -7.583  18.589  0.50 19.57           C  
ATOM    453  CG  TYR A  55       8.882  -7.562  19.639  0.50 21.08           C  
ATOM    455  CD1 TYR A  55       7.923  -8.575  19.707  0.50 22.85           C  
ATOM    457  CD2 TYR A  55       8.822  -6.533  20.585  0.50 23.94           C  
ATOM    459  CE1 TYR A  55       6.933  -8.566  20.696  0.50 22.85           C  
ATOM    461  CE2 TYR A  55       7.836  -6.511  21.575  0.50 22.67           C  
ATOM    463  CZ  TYR A  55       6.897  -7.528  21.623  0.50 24.37           C  
ATOM    465  OH  TYR A  55       5.923  -7.495  22.599  0.50 23.60           O  
ATOM    467  N   LEU A  56      10.850  -5.640  15.640  0.50 19.09           N  
ATOM    469  CA  LEU A  56      12.021  -5.200  14.871  1.00 17.29           C  
ATOM    470  C   LEU A  56      12.186  -3.727  15.203  1.00 18.26           C  
ATOM    471  O   LEU A  56      11.224  -2.956  15.116  1.00 19.84           O  
ATOM    472  CB  LEU A  56      11.776  -5.348  13.358  1.00 15.80           C  
ATOM    473  CG  LEU A  56      12.878  -4.803  12.421  1.00 13.87           C  
ATOM    474  CD1 LEU A  56      14.177  -5.593  12.595  1.00 13.48           C  
ATOM    475  CD2 LEU A  56      12.416  -4.896  10.959  1.00 16.91           C  
ATOM    476  N   GLU A  57      13.393  -3.344  15.611  1.00 15.50           N  
ATOM    477  CA  GLU A  57      13.704  -1.949  15.936  1.00 16.89           C  
ATOM    478  C   GLU A  57      14.957  -1.598  15.140  1.00 15.83           C  
ATOM    479  O   GLU A  57      16.066  -2.027  15.475  1.00 14.94           O  
ATOM    480  CB  GLU A  57      13.982  -1.788  17.432  1.00 20.01           C  
ATOM    481  CG  GLU A  57      13.725  -0.391  17.950  0.40 25.25           C  
ATOM    482  CD  GLU A  57      12.250  -0.045  17.914  0.40 26.78           C  
ATOM    483  OE1 GLU A  57      11.460  -0.746  18.584  0.40 30.00           O  
ATOM    484  OE2 GLU A  57      11.878   0.921  17.217  0.40 30.44           O  
ATOM    485  N   GLY A  58      14.779  -0.809  14.083  1.00 16.87           N  
ATOM    486  CA  GLY A  58      15.918  -0.469  13.261  1.00 15.69           C  
ATOM    487  C   GLY A  58      16.353  -1.767  12.602  1.00 12.96           C  
ATOM    488  O   GLY A  58      15.539  -2.439  11.949  1.00 16.31           O  
ATOM    489  N   ASP A  59      17.620  -2.140  12.784  1.00 11.65           N  
ATOM    490  CA  ASP A  59      18.084  -3.374  12.185  1.00 12.14           C  
ATOM    491  C   ASP A  59      18.280  -4.495  13.191  1.00 11.72           C  
ATOM    492  O   ASP A  59      18.942  -5.486  12.890  1.00 11.31           O  
ATOM    493  CB  ASP A  59      19.368  -3.160  11.373  1.00 13.20           C  
ATOM    494  CG  ASP A  59      20.528  -2.636  12.197  1.00 20.87           C  
ATOM    495  OD1 ASP A  59      20.440  -2.585  13.442  1.00 19.20           O  
ATOM    496  OD2 ASP A  59      21.550  -2.267  11.580  1.00 25.19           O  
ATOM    497  N   VAL A  60      17.668  -4.363  14.365  1.00 11.08           N  
ATOM    498  CA  VAL A  60      17.787  -5.391  15.392  1.00 10.03           C  
ATOM    499  C   VAL A  60      16.439  -6.067  15.638  1.00 11.90           C  
ATOM    500  O   VAL A  60      15.446  -5.401  15.935  1.00 12.09           O  
ATOM    501  CB  VAL A  60      18.296  -4.781  16.720  1.00 12.29           C  
ATOM    502  CG1 VAL A  60      18.332  -5.853  17.806  1.00 10.85           C  
ATOM    503  CG2 VAL A  60      19.719  -4.227  16.527  1.00 11.78           C  
ATOM    504  N   VAL A  61      16.390  -7.388  15.481  1.00  8.97           N  
ATOM    505  CA  VAL A  61      15.149  -8.107  15.733  1.00  8.91           C  
ATOM    506  C   VAL A  61      15.224  -8.756  17.106  1.00  9.26           C  
ATOM    507  O   VAL A  61      16.270  -9.266  17.504  1.00 10.02           O  
ATOM    508  CB  VAL A  61      14.876  -9.190  14.629  1.00  8.21           C  
ATOM    509  CG1 VAL A  61      16.004 -10.229  14.599  1.00  9.08           C  
ATOM    510  CG2 VAL A  61      13.501  -9.861  14.886  1.00 10.72           C  
ATOM    511  N   GLU A  62      14.114  -8.705  17.835  1.00  8.80           N  
ATOM    512  CA  GLU A  62      14.056  -9.301  19.167  1.00 10.26           C  
ATOM    513  C   GLU A  62      13.149 -10.522  19.162  1.00 10.05           C  
ATOM    514  O   GLU A  62      12.021 -10.465  18.683  1.00 13.06           O  
ATOM    515  CB  GLU A  62      13.521  -8.274  20.188  1.00 10.86           C  
ATOM    516  CG  GLU A  62      13.403  -8.833  21.613  1.00 12.47           C  
ATOM    517  CD  GLU A  62      12.803  -7.837  22.580  1.00 20.68           C  
ATOM    518  OE1 GLU A  62      12.514  -8.224  23.730  1.00 24.95           O  
ATOM    519  OE2 GLU A  62      12.621  -6.669  22.201  1.00 24.39           O  
ATOM    520  N   CYS A  63      13.664 -11.638  19.674  1.00  9.45           N  
ATOM    521  CA  CYS A  63      12.890 -12.879  19.788  1.00  7.26           C  
ATOM    522  C   CYS A  63      11.887 -12.655  20.934  1.00  8.37           C  
ATOM    523  O   CYS A  63      12.289 -12.322  22.052  1.00  9.55           O  
ATOM    524  CB  CYS A  63      13.830 -14.014  20.162  1.00  7.46           C  
ATOM    525  SG  CYS A  63      12.930 -15.553  20.476  1.00  8.91           S  
ATOM    526  N   SER A  64      10.598 -12.855  20.676  1.00  8.08           N  
ATOM    527  CA  SER A  64       9.606 -12.612  21.710  1.00  9.76           C  
ATOM    528  C   SER A  64       9.479 -13.710  22.767  1.00  9.26           C  
ATOM    529  O   SER A  64       8.724 -13.560  23.725  1.00 11.25           O  
ATOM    530  CB  SER A  64       8.236 -12.330  21.067  1.00  9.45           C  
ATOM    531  OG  SER A  64       7.679 -13.478  20.453  1.00 10.63           O  
ATOM    532  N   LEU A  65      10.217 -14.808  22.606  1.00  8.47           N  
ATOM    533  CA  LEU A  65      10.149 -15.878  23.599  1.00  7.21           C  
ATOM    534  C   LEU A  65      11.057 -15.561  24.793  1.00  9.23           C  
ATOM    535  O   LEU A  65      10.564 -15.538  25.942  1.00  9.93           O  
ATOM    536  CB  LEU A  65      10.522 -17.233  22.983  1.00  8.84           C  
ATOM    537  CG  LEU A  65      10.458 -18.396  23.995  1.00  7.47           C  
ATOM    538  CD1 LEU A  65       9.080 -18.457  24.646  1.00  8.27           C  
ATOM    539  CD2 LEU A  65      10.738 -19.709  23.287  1.00  8.38           C  
ATOM    540  N   HIS A  66      12.360 -15.335  24.565  1.00  8.04           N  
ATOM    541  CA  HIS A  66      13.240 -14.983  25.693  1.00  7.03           C  
ATOM    542  C   HIS A  66      14.007 -13.680  25.522  1.00  8.99           C  
ATOM    543  O   HIS A  66      14.989 -13.451  26.226  1.00 10.47           O  
ATOM    544  CB  HIS A  66      14.258 -16.076  26.060  1.00  8.16           C  
ATOM    545  CG  HIS A  66      13.688 -17.465  26.089  1.00  8.42           C  
ATOM    546  ND1 HIS A  66      13.957 -18.384  25.088  1.00  8.50           N  
ATOM    547  CD2 HIS A  66      12.916 -18.095  26.988  1.00  9.22           C  
ATOM    548  CE1 HIS A  66      13.362 -19.530  25.391  1.00  8.49           C  
ATOM    549  NE2 HIS A  66      12.722 -19.381  26.536  1.00  7.83           N  
ATOM    550  N   MET A  67      13.575 -12.847  24.582  1.00  8.07           N  
ATOM    551  CA  MET A  67      14.178 -11.529  24.386  1.00 10.04           C  
ATOM    552  C   MET A  67      15.588 -11.456  23.827  1.00  9.91           C  
ATOM    553  O   MET A  67      16.260 -10.418  23.955  1.00 10.62           O  
ATOM    554  CB  MET A  67      14.098 -10.734  25.694  1.00 12.39           C  
ATOM    555  CG  MET A  67      12.697 -10.442  26.195  0.66 12.61           C  
ATOM    557  SD  MET A  67      11.834 -11.802  26.997  0.66 12.97           S  
ATOM    559  CE  MET A  67      10.449 -11.985  25.933  0.66 16.47           C  
ATOM    561  N   GLY A  68      16.048 -12.548  23.216  1.00  8.29           N  
ATOM    562  CA  GLY A  68      17.350 -12.494  22.572  1.00  8.88           C  
ATOM    563  C   GLY A  68      17.235 -11.529  21.398  1.00  9.64           C  
ATOM    564  O   GLY A  68      16.136 -11.251  20.904  1.00  9.38           O  
ATOM    565  N   LYS A  69      18.366 -10.995  20.947  1.00  9.16           N  
ATOM    566  CA  LYS A  69      18.340 -10.049  19.840  1.00  8.54           C  
ATOM    567  C   LYS A  69      19.423 -10.350  18.827  1.00  9.18           C  
ATOM    568  O   LYS A  69      20.493 -10.854  19.172  1.00  9.70           O  
ATOM    569  CB  LYS A  69      18.509  -8.623  20.371  1.00  9.31           C  
ATOM    570  CG  LYS A  69      17.306  -8.129  21.204  1.00 10.06           C  
ATOM    571  CD  LYS A  69      17.568  -6.720  21.702  1.00 12.51           C  
ATOM    572  CE  LYS A  69      16.419  -6.235  22.553  1.00 15.31           C  
ATOM    573  NZ  LYS A  69      16.751  -4.901  23.153  1.00 18.12           N  
ATOM    574  N   PHE A  70      19.129 -10.061  17.564  1.00  8.32           N  
ATOM    575  CA  PHE A  70      20.083 -10.291  16.489  1.00  8.65           C  
ATOM    576  C   PHE A  70      20.083  -9.126  15.520  1.00  8.88           C  
ATOM    577  O   PHE A  70      19.042  -8.492  15.309  1.00  8.96           O  
ATOM    578  CB  PHE A  70      19.674 -11.504  15.640  1.00  7.27           C  
ATOM    579  CG  PHE A  70      19.520 -12.774  16.410  1.00  6.55           C  
ATOM    580  CD1 PHE A  70      18.293 -13.115  16.966  1.00  6.05           C  
ATOM    581  CD2 PHE A  70      20.594 -13.644  16.545  1.00  7.73           C  
ATOM    582  CE1 PHE A  70      18.128 -14.314  17.650  1.00  6.71           C  
ATOM    583  CE2 PHE A  70      20.445 -14.856  17.227  1.00  6.67           C  
ATOM    584  CZ  PHE A  70      19.208 -15.194  17.780  1.00  6.83           C  
ATOM    585  N   CYS A  71      21.237  -8.866  14.902  1.00  7.11           N  
ATOM    586  CA  CYS A  71      21.306  -7.854  13.839  1.00  7.53           C  
ATOM    587  C   CYS A  71      20.793  -8.566  12.562  1.00  9.13           C  
ATOM    588  O   CYS A  71      21.322  -9.619  12.180  1.00  8.10           O  
ATOM    589  CB  CYS A  71      22.747  -7.412  13.637  1.00  8.51           C  
ATOM    590  SG  CYS A  71      22.978  -6.353  12.181  1.00 12.93           S  
ATOM    591  N   VAL A  72      19.772  -8.015  11.904  1.00  6.90           N  
ATOM    592  CA  VAL A  72      19.252  -8.680  10.709  1.00  7.43           C  
ATOM    593  C   VAL A  72      20.144  -8.530   9.471  1.00  7.03           C  
ATOM    594  O   VAL A  72      20.004  -9.288   8.519  1.00  9.54           O  
ATOM    595  CB  VAL A  72      17.811  -8.210  10.381  1.00  7.47           C  
ATOM    596  CG1 VAL A  72      16.918  -8.411  11.595  1.00 10.58           C  
ATOM    597  CG2 VAL A  72      17.809  -6.753   9.936  1.00  9.24           C  
ATOM    598  N   ARG A  73      21.062  -7.564   9.491  1.00  9.40           N  
ATOM    599  CA  ARG A  73      21.957  -7.389   8.358  1.00  7.93           C  
ATOM    600  C   ARG A  73      23.053  -8.438   8.339  1.00  8.18           C  
ATOM    601  O   ARG A  73      23.500  -8.854   7.270  1.00 10.39           O  
ATOM    602  CB  ARG A  73      22.614  -6.002   8.389  1.00  8.74           C  
ATOM    603  CG  ARG A  73      21.672  -4.821   8.418  0.60  9.90           C  
ATOM    605  CD  ARG A  73      22.484  -3.580   8.772  0.60  8.58           C  
ATOM    607  NE  ARG A  73      21.713  -2.342   8.697  0.60 10.04           N  
ATOM    609  CZ  ARG A  73      21.434  -1.697   7.565  0.60 11.89           C  
ATOM    611  NH1 ARG A  73      21.862  -2.178   6.406  0.60 14.16           N  
ATOM    613  NH2 ARG A  73      20.745  -0.563   7.596  0.60 14.45           N  
ATOM    615  N   THR A  74      23.485  -8.878   9.521  1.00  9.06           N  
ATOM    616  CA  THR A  74      24.589  -9.823   9.615  1.00  8.13           C  
ATOM    617  C   THR A  74      24.230 -11.144  10.263  1.00  8.94           C  
ATOM    618  O   THR A  74      25.015 -12.106  10.184  1.00  9.88           O  
ATOM    619  CB  THR A  74      25.712  -9.252  10.483  1.00  7.23           C  
ATOM    620  OG1 THR A  74      25.198  -9.039  11.802  1.00  9.13           O  
ATOM    621  CG2 THR A  74      26.189  -7.902   9.931  1.00  9.12           C  
ATOM    622  N   GLY A  75      23.069 -11.166  10.910  1.00  8.26           N  
ATOM    623  CA  GLY A  75      22.619 -12.340  11.637  1.00  8.92           C  
ATOM    624  C   GLY A  75      23.292 -12.453  13.005  1.00  8.63           C  
ATOM    625  O   GLY A  75      22.964 -13.349  13.777  1.00  9.40           O  
ATOM    626  N   LYS A  76      24.194 -11.530  13.340  1.00  7.87           N  
ATOM    627  CA  LYS A  76      24.936 -11.646  14.600  1.00  8.76           C  
ATOM    628  C   LYS A  76      24.148 -11.368  15.868  1.00  7.43           C  
ATOM    629  O   LYS A  76      23.215 -10.576  15.870  1.00  9.48           O  
ATOM    630  CB  LYS A  76      26.187 -10.757  14.527  1.00  8.47           C  
ATOM    631  CG  LYS A  76      27.120 -11.240  13.421  1.00 11.33           C  
ATOM    632  CD  LYS A  76      28.296 -10.317  13.207  1.00 15.08           C  
ATOM    633  CE  LYS A  76      29.230 -10.868  12.117  1.00 17.38           C  
ATOM    634  NZ  LYS A  76      29.864 -12.177  12.469  1.00 16.83           N  
ATOM    635  N   VAL A  77      24.527 -12.042  16.951  1.00  7.64           N  
ATOM    636  CA  VAL A  77      23.831 -11.866  18.220  1.00  8.05           C  
ATOM    637  C   VAL A  77      24.090 -10.490  18.832  1.00  9.76           C  
ATOM    638  O   VAL A  77      25.247 -10.062  18.916  1.00 11.93           O  
ATOM    639  CB  VAL A  77      24.297 -12.936  19.230  1.00 10.05           C  
ATOM    640  CG1 VAL A  77      23.630 -12.685  20.591  1.00 11.21           C  
ATOM    641  CG2 VAL A  77      23.942 -14.351  18.710  1.00  9.84           C  
ATOM    642  N   LYS A  78      23.018  -9.809  19.235  1.00  9.59           N  
ATOM    643  CA  LYS A  78      23.155  -8.522  19.911  1.00 12.33           C  
ATOM    644  C   LYS A  78      22.816  -8.650  21.402  1.00 13.09           C  
ATOM    645  O   LYS A  78      23.216  -7.800  22.195  1.00 16.13           O  
ATOM    646  CB  LYS A  78      22.261  -7.464  19.253  1.00 12.39           C  
ATOM    647  CG  LYS A  78      22.754  -7.042  17.873  1.00 15.39           C  
ATOM    648  CD  LYS A  78      24.132  -6.372  17.983  1.00 18.81           C  
ATOM    649  CE  LYS A  78      24.526  -5.645  16.718  0.40 21.35           C  
ATOM    650  NZ  LYS A  78      25.766  -4.848  16.951  0.40 20.83           N  
ATOM    651  N   SER A  79      22.075  -9.688  21.783  1.00 10.00           N  
ATOM    652  CA  SER A  79      21.745  -9.899  23.196  1.00 11.06           C  
ATOM    653  C   SER A  79      21.439 -11.360  23.439  1.00 11.98           C  
ATOM    654  O   SER A  79      20.824 -12.016  22.599  1.00 11.38           O  
ATOM    655  CB  SER A  79      20.497  -9.101  23.611  1.00 12.99           C  
ATOM    656  OG  SER A  79      20.687  -7.707  23.563  0.56 14.16           O  
ATOM    658  N   PRO A  80      21.868 -11.898  24.589  1.00  9.98           N  
ATOM    659  CA  PRO A  80      21.598 -13.291  24.928  1.00 11.13           C  
ATOM    660  C   PRO A  80      20.110 -13.310  25.283  1.00 11.41           C  
ATOM    661  O   PRO A  80      19.468 -12.253  25.361  1.00 11.31           O  
ATOM    662  CB  PRO A  80      22.472 -13.536  26.171  1.00 12.57           C  
ATOM    663  CG  PRO A  80      23.503 -12.455  26.104  1.00 17.64           C  
ATOM    664  CD  PRO A  80      22.736 -11.270  25.599  1.00 13.58           C  
ATOM    665  N   PRO A  81      19.543 -14.492  25.545  1.00 11.10           N  
ATOM    666  CA  PRO A  81      20.083 -15.856  25.608  1.00 10.99           C  
ATOM    667  C   PRO A  81      20.844 -16.457  24.443  1.00 10.71           C  
ATOM    668  O   PRO A  81      21.725 -17.273  24.675  1.00 12.42           O  
ATOM    669  CB  PRO A  81      18.855 -16.710  25.928  1.00 14.20           C  
ATOM    670  CG  PRO A  81      17.966 -15.778  26.639  1.00 14.09           C  
ATOM    671  CD  PRO A  81      18.107 -14.500  25.862  1.00 11.38           C  
ATOM    672  N   PRO A  82      20.493 -16.117  23.187  1.00  9.02           N  
ATOM    673  CA  PRO A  82      21.252 -16.727  22.091  1.00  9.87           C  
ATOM    674  C   PRO A  82      22.747 -16.488  22.184  1.00  9.63           C  
ATOM    675  O   PRO A  82      23.202 -15.428  22.653  1.00 11.23           O  
ATOM    676  CB  PRO A  82      20.695 -16.054  20.839  1.00  9.76           C  
ATOM    677  CG  PRO A  82      19.296 -15.613  21.253  1.00  8.19           C  
ATOM    678  CD  PRO A  82      19.497 -15.152  22.686  1.00  7.67           C  
ATOM    679  N   CYS A  83      23.499 -17.482  21.726  1.00 10.63           N  
ATOM    680  CA  CYS A  83      24.949 -17.377  21.653  1.00 11.51           C  
ATOM    681  C   CYS A  83      25.413 -17.691  20.226  1.00 10.75           C  
ATOM    682  O   CYS A  83      26.597 -17.550  19.921  1.00 13.30           O  
ATOM    683  CB  CYS A  83      25.630 -18.314  22.649  1.00 12.21           C  
ATOM    684  SG  CYS A  83      25.445 -20.044  22.289  1.00 15.20           S  
ATOM    685  N   GLU A  84      24.489 -18.083  19.341  1.00  9.72           N  
ATOM    686  CA  GLU A  84      24.843 -18.409  17.946  1.00 10.51           C  
ATOM    687  C   GLU A  84      24.203 -17.459  16.946  1.00 10.42           C  
ATOM    688  O   GLU A  84      23.011 -17.150  17.053  1.00  9.15           O  
ATOM    689  CB  GLU A  84      24.421 -19.847  17.590  1.00 11.77           C  
ATOM    690  CG  GLU A  84      25.251 -20.882  18.345  1.00 13.49           C  
ATOM    691  CD  GLU A  84      25.010 -22.304  17.891  1.00 16.44           C  
ATOM    692  OE1 GLU A  84      24.025 -22.567  17.176  1.00 14.26           O  
ATOM    693  OE2 GLU A  84      25.818 -23.176  18.286  1.00 19.97           O  
ATOM    694  N   ALA A  85      24.989 -17.000  15.969  1.00  8.11           N  
ATOM    695  CA  ALA A  85      24.454 -16.113  14.935  1.00  8.91           C  
ATOM    696  C   ALA A  85      23.484 -16.847  14.000  1.00  9.22           C  
ATOM    697  O   ALA A  85      23.577 -18.063  13.778  1.00  9.57           O  
ATOM    698  CB  ALA A  85      25.609 -15.542  14.082  1.00  7.25           C  
ATOM    699  N   LEU A  86      22.541 -16.084  13.463  1.00  7.38           N  
ATOM    700  CA  LEU A  86      21.611 -16.601  12.475  1.00  7.99           C  
ATOM    701  C   LEU A  86      22.308 -16.762  11.130  1.00  6.85           C  
ATOM    702  O   LEU A  86      23.219 -15.989  10.783  1.00  9.00           O  
ATOM    703  CB  LEU A  86      20.499 -15.583  12.229  1.00  8.91           C  
ATOM    704  CG  LEU A  86      19.620 -15.101  13.381  1.00 10.45           C  
ATOM    705  CD1 LEU A  86      18.853 -13.855  12.970  1.00  9.65           C  
ATOM    706  CD2 LEU A  86      18.654 -16.225  13.761  1.00 11.53           C  
ATOM    707  N   LYS A  87      21.872 -17.754  10.363  1.00  9.22           N  
ATOM    708  CA  LYS A  87      22.358 -17.867   8.994  1.00  9.35           C  
ATOM    709  C   LYS A  87      21.639 -16.745   8.224  1.00  9.65           C  
ATOM    710  O   LYS A  87      20.494 -16.369   8.551  1.00  9.36           O  
ATOM    711  CB  LYS A  87      21.952 -19.200   8.371  1.00 10.22           C  
ATOM    712  CG  LYS A  87      22.813 -20.382   8.767  1.00 12.04           C  
ATOM    713  CD  LYS A  87      22.442 -21.580   7.907  1.00 19.01           C  
ATOM    714  CE  LYS A  87      23.305 -22.781   8.221  1.00 25.33           C  
ATOM    715  NZ  LYS A  87      22.849 -23.970   7.454  1.00 28.60           N  
ATOM    716  N   ILE A  88      22.322 -16.184   7.238  1.00 10.48           N  
ATOM    717  CA  ILE A  88      21.718 -15.163   6.396  1.00  9.66           C  
ATOM    718  C   ILE A  88      21.602 -15.788   5.005  1.00  9.79           C  
ATOM    719  O   ILE A  88      22.299 -16.761   4.687  1.00 10.43           O  
ATOM    720  CB  ILE A  88      22.516 -13.834   6.389  1.00 11.24           C  
ATOM    721  CG1 ILE A  88      23.960 -14.050   5.978  1.00 11.37           C  
ATOM    722  CG2 ILE A  88      22.450 -13.198   7.786  1.00 12.51           C  
ATOM    723  CD1 ILE A  88      24.784 -12.738   6.022  1.00 11.36           C  
ATOM    724  N   PHE A  89      20.692 -15.269   4.198  1.00 10.01           N  
ATOM    725  CA  PHE A  89      20.427 -15.844   2.883  1.00 10.20           C  
ATOM    726  C   PHE A  89      20.542 -14.844   1.768  1.00 10.08           C  
ATOM    727  O   PHE A  89      20.172 -13.681   1.927  1.00 10.74           O  
ATOM    728  CB  PHE A  89      18.991 -16.421   2.817  1.00  8.62           C  
ATOM    729  CG  PHE A  89      18.791 -17.671   3.631  1.00 10.56           C  
ATOM    730  CD1 PHE A  89      18.722 -17.619   5.021  1.00  9.30           C  
ATOM    731  CD2 PHE A  89      18.717 -18.910   3.006  1.00 11.89           C  
ATOM    732  CE1 PHE A  89      18.585 -18.778   5.771  1.00 10.66           C  
ATOM    733  CE2 PHE A  89      18.580 -20.086   3.750  1.00 11.56           C  
ATOM    734  CZ  PHE A  89      18.515 -20.025   5.135  1.00 11.57           C  
ATOM    735  N   PRO A  90      21.037 -15.289   0.602  1.00 10.04           N  
ATOM    736  CA  PRO A  90      21.157 -14.369  -0.525  1.00 11.04           C  
ATOM    737  C   PRO A  90      19.756 -13.883  -0.905  1.00 12.41           C  
ATOM    738  O   PRO A  90      18.813 -14.683  -1.031  1.00 12.61           O  
ATOM    739  CB  PRO A  90      21.791 -15.235  -1.614  1.00 13.08           C  
ATOM    740  CG  PRO A  90      22.630 -16.215  -0.818  1.00 12.49           C  
ATOM    741  CD  PRO A  90      21.717 -16.571   0.335  1.00 11.53           C  
ATOM    742  N   ILE A  91      19.608 -12.578  -1.062  1.00 12.15           N  
ATOM    743  CA  ILE A  91      18.314 -12.025  -1.434  1.00 14.67           C  
ATOM    744  C   ILE A  91      18.540 -10.950  -2.485  1.00 17.90           C  
ATOM    745  O   ILE A  91      19.449 -10.124  -2.346  1.00 17.93           O  
ATOM    746  CB  ILE A  91      17.577 -11.464  -0.176  1.00 13.64           C  
ATOM    747  CG1 ILE A  91      16.235 -10.854  -0.584  1.00 16.20           C  
ATOM    748  CG2 ILE A  91      18.437 -10.419   0.552  1.00 17.74           C  
ATOM    749  CD1 ILE A  91      15.312 -10.597   0.606  1.00 16.10           C  
ATOM    750  N   ARG A  92      17.750 -10.988  -3.557  1.00 18.36           N  
ATOM    751  CA  ARG A  92      17.875 -10.006  -4.623  1.00 19.78           C  
ATOM    752  C   ARG A  92      16.522  -9.431  -4.989  1.00 19.94           C  
ATOM    753  O   ARG A  92      15.494 -10.074  -4.779  1.00 18.68           O  
ATOM    754  CB  ARG A  92      18.407 -10.678  -5.865  1.00 19.71           C  
ATOM    755  CG  ARG A  92      19.704 -11.479  -5.650  1.00 26.22           C  
ATOM    756  CD  ARG A  92      20.741 -10.666  -6.183  1.00 32.83           C  
ATOM    757  NE  ARG A  92      22.012 -10.377  -5.494  1.00 34.57           N  
ATOM    758  CZ  ARG A  92      22.396 -10.816  -4.331  1.00 37.03           C  
ATOM    759  NH1 ARG A  92      21.945 -11.492  -3.405  1.00 35.85           N  
ATOM    760  NH2 ARG A  92      23.648 -10.970  -4.357  1.00 40.16           N  
ATOM    761  N   ILE A  93      16.534  -8.215  -5.522  1.00 20.35           N  
ATOM    762  CA  ILE A  93      15.313  -7.564  -5.952  1.00 22.77           C  
ATOM    763  C   ILE A  93      15.447  -7.335  -7.451  1.00 24.25           C  
ATOM    764  O   ILE A  93      16.455  -6.801  -7.914  1.00 24.71           O  
ATOM    765  CB  ILE A  93      15.104  -6.213  -5.235  1.00 24.43           C  
ATOM    766  CG1 ILE A  93      14.829  -6.464  -3.743  1.00 25.34           C  
ATOM    767  CG2 ILE A  93      13.948  -5.450  -5.875  1.00 23.94           C  
ATOM    768  CD1 ILE A  93      14.344  -5.238  -2.977  1.00 28.48           C  
ATOM    769  N   GLU A  94      14.451  -7.782  -8.207  1.00 24.60           N  
ATOM    770  CA  GLU A  94      14.445  -7.613  -9.658  1.00 27.25           C  
ATOM    771  C   GLU A  94      13.063  -7.104 -10.010  1.00 26.75           C  
ATOM    772  O   GLU A  94      12.081  -7.855  -9.983  1.00 25.50           O  
ATOM    773  CB  GLU A  94      14.746  -8.939 -10.347  1.00 28.57           C  
ATOM    774  CG  GLU A  94      16.180  -9.397 -10.095  1.00 33.46           C  
ATOM    775  CD  GLU A  94      16.513 -10.725 -10.740  1.00 36.10           C  
ATOM    776  OE1 GLU A  94      17.678 -11.169 -10.611  1.00 39.14           O  
ATOM    777  OE2 GLU A  94      15.617 -11.325 -11.369  1.00 38.96           O  
ATOM    778  N   ASP A  95      13.004  -5.816 -10.325  1.00 28.37           N  
ATOM    779  CA  ASP A  95      11.746  -5.152 -10.636  1.00 28.90           C  
ATOM    780  C   ASP A  95      11.028  -5.107  -9.289  1.00 29.12           C  
ATOM    781  O   ASP A  95      11.561  -4.554  -8.317  1.00 27.35           O  
ATOM    782  CB  ASP A  95      10.951  -5.961 -11.671  1.00 32.58           C  
ATOM    783  CG  ASP A  95      11.631  -5.993 -13.042  1.00 35.97           C  
ATOM    784  OD1 ASP A  95      11.329  -6.910 -13.838  1.00 40.42           O  
ATOM    785  OD2 ASP A  95      12.457  -5.098 -13.328  1.00 38.57           O  
ATOM    786  N   ASN A  96       9.841  -5.698  -9.214  1.00 24.97           N  
ATOM    787  CA  ASN A  96       9.092  -5.704  -7.961  1.00 26.91           C  
ATOM    788  C   ASN A  96       9.210  -7.058  -7.270  1.00 23.02           C  
ATOM    789  O   ASN A  96       8.650  -7.257  -6.191  1.00 22.99           O  
ATOM    790  CB  ASN A  96       7.611  -5.405  -8.229  1.00 27.83           C  
ATOM    791  CG  ASN A  96       7.391  -4.032  -8.839  1.00 32.36           C  
ATOM    792  OD1 ASN A  96       6.561  -3.863  -9.750  1.00 34.21           O  
ATOM    793  ND2 ASN A  96       8.116  -3.039  -8.333  1.00 30.44           N  
ATOM    794  N   ASP A  97       9.949  -7.973  -7.890  1.00 21.45           N  
ATOM    795  CA  ASP A  97      10.116  -9.321  -7.367  1.00 19.21           C  
ATOM    796  C   ASP A  97      11.280  -9.482  -6.398  1.00 17.40           C  
ATOM    797  O   ASP A  97      12.375  -8.984  -6.640  1.00 18.59           O  
ATOM    798  CB  ASP A  97      10.339 -10.310  -8.513  1.00 22.08           C  
ATOM    799  CG  ASP A  97       9.191 -10.334  -9.496  1.00 25.63           C  
ATOM    800  OD1 ASP A  97       8.065 -10.623  -9.062  1.00 25.77           O  
ATOM    801  OD2 ASP A  97       9.425 -10.067 -10.696  1.00 30.99           O  
ATOM    802  N   VAL A  98      11.025 -10.189  -5.305  1.00 14.81           N  
ATOM    803  CA  VAL A  98      12.066 -10.491  -4.320  1.00 14.72           C  
ATOM    804  C   VAL A  98      12.401 -11.969  -4.508  1.00 14.05           C  
ATOM    805  O   VAL A  98      11.501 -12.819  -4.565  1.00 15.20           O  
ATOM    806  CB  VAL A  98      11.560 -10.284  -2.881  1.00 12.89           C  
ATOM    807  CG1 VAL A  98      12.675 -10.640  -1.888  1.00 11.84           C  
ATOM    808  CG2 VAL A  98      11.095  -8.845  -2.687  1.00 13.30           C  
ATOM    809  N   LEU A  99      13.685 -12.288  -4.639  1.00 15.01           N  
ATOM    810  CA  LEU A  99      14.093 -13.682  -4.809  1.00 14.90           C  
ATOM    811  C   LEU A  99      15.089 -14.079  -3.719  1.00 14.92           C  
ATOM    812  O   LEU A  99      15.920 -13.270  -3.303  1.00 16.12           O  
ATOM    813  CB  LEU A  99      14.710 -13.894  -6.196  1.00 19.04           C  
ATOM    814  CG  LEU A  99      13.726 -13.494  -7.309  1.00 22.35           C  
ATOM    815  CD1 LEU A  99      14.166 -12.180  -7.918  1.00 23.80           C  
ATOM    816  CD2 LEU A  99      13.667 -14.582  -8.368  1.00 25.49           C  
ATOM    817  N   VAL A 100      14.988 -15.321  -3.257  1.00 14.96           N  
ATOM    818  CA  VAL A 100      15.867 -15.835  -2.203  1.00 12.67           C  
ATOM    819  C   VAL A 100      16.451 -17.178  -2.638  1.00 15.13           C  
ATOM    820  O   VAL A 100      15.751 -17.998  -3.251  1.00 16.26           O  
ATOM    821  CB  VAL A 100      15.054 -16.052  -0.888  1.00 13.13           C  
ATOM    822  CG1 VAL A 100      15.872 -16.849   0.131  1.00 15.86           C  
ATOM    823  CG2 VAL A 100      14.672 -14.710  -0.292  1.00 14.48           C  
ATOM    824  N   ASP A 101      17.733 -17.409  -2.357  1.00 13.01           N  
ATOM    825  CA  ASP A 101      18.323 -18.708  -2.658  1.00 12.49           C  
ATOM    826  C   ASP A 101      18.259 -19.470  -1.334  1.00 13.89           C  
ATOM    827  O   ASP A 101      19.116 -19.290  -0.444  1.00 13.87           O  
ATOM    828  CB  ASP A 101      19.781 -18.583  -3.110  1.00 14.71           C  
ATOM    829  CG  ASP A 101      20.380 -19.920  -3.507  1.00 15.73           C  
ATOM    830  OD1 ASP A 101      19.884 -20.957  -3.029  1.00 17.39           O  
ATOM    831  OD2 ASP A 101      21.363 -19.937  -4.290  1.00 18.76           O  
ATOM    832  N   PHE A 102      17.219 -20.299  -1.196  1.00 14.29           N  
ATOM    833  CA  PHE A 102      16.994 -21.096   0.006  1.00 12.80           C  
ATOM    834  C   PHE A 102      18.060 -22.152   0.272  1.00 13.28           C  
ATOM    835  O   PHE A 102      18.127 -22.684   1.369  1.00 14.19           O  
ATOM    836  CB  PHE A 102      15.629 -21.797  -0.062  1.00 14.51           C  
ATOM    837  CG  PHE A 102      14.449 -20.869   0.079  1.00 10.11           C  
ATOM    838  CD1 PHE A 102      13.882 -20.251  -1.044  1.00 11.54           C  
ATOM    839  CD2 PHE A 102      13.893 -20.617   1.334  1.00 11.20           C  
ATOM    840  CE1 PHE A 102      12.777 -19.396  -0.914  1.00 12.86           C  
ATOM    841  CE2 PHE A 102      12.797 -19.769   1.475  1.00 11.83           C  
ATOM    842  CZ  PHE A 102      12.234 -19.154   0.353  1.00 12.48           C  
ATOM    843  N   GLU A 103      18.889 -22.465  -0.723  1.00 13.11           N  
ATOM    844  CA  GLU A 103      19.919 -23.474  -0.532  1.00 16.99           C  
ATOM    845  C   GLU A 103      21.285 -22.890  -0.207  1.00 16.11           C  
ATOM    846  O   GLU A 103      22.254 -23.634  -0.034  1.00 18.27           O  
ATOM    847  CB  GLU A 103      20.036 -24.336  -1.796  1.00 21.23           C  
ATOM    848  CG  GLU A 103      18.759 -25.097  -2.125  0.50 24.28           C  
ATOM    850  CD  GLU A 103      18.855 -25.858  -3.429  0.50 26.73           C  
ATOM    852  OE1 GLU A 103      19.786 -26.677  -3.570  0.50 28.81           O  
ATOM    854  OE2 GLU A 103      17.999 -25.636  -4.311  0.50 27.85           O  
ATOM    856  N   ALA A 104      21.354 -21.563  -0.086  1.00 13.52           N  
ATOM    857  CA  ALA A 104      22.631 -20.906   0.155  1.00 13.41           C  
ATOM    858  C   ALA A 104      22.789 -20.188   1.493  1.00 13.37           C  
ATOM    859  O   ALA A 104      23.617 -19.281   1.603  1.00 15.62           O  
ATOM    860  CB  ALA A 104      22.908 -19.941  -0.978  1.00 15.65           C  
ATOM    861  N   GLY A 105      22.030 -20.589   2.504  1.00 13.89           N  
ATOM    862  CA  GLY A 105      22.181 -19.936   3.805  1.00 12.54           C  
ATOM    863  C   GLY A 105      23.615 -20.075   4.300  1.00 13.21           C  
ATOM    864  O   GLY A 105      24.250 -21.128   4.133  1.00 13.65           O  
ATOM    865  N   TYR A 106      24.139 -19.021   4.916  1.00 10.62           N  
ATOM    866  CA  TYR A 106      25.516 -19.057   5.428  1.00 10.64           C  
ATOM    867  C   TYR A 106      25.692 -18.123   6.606  1.00 10.01           C  
ATOM    868  O   TYR A 106      24.871 -17.235   6.836  1.00 10.83           O  
ATOM    869  CB  TYR A 106      26.509 -18.637   4.332  1.00 11.47           C  
ATOM    870  CG  TYR A 106      26.319 -17.214   3.853  1.00 12.31           C  
ATOM    871  CD1 TYR A 106      27.157 -16.178   4.290  1.00 10.04           C  
ATOM    872  CD2 TYR A 106      25.273 -16.899   2.980  1.00 11.88           C  
ATOM    873  CE1 TYR A 106      26.925 -14.830   3.882  1.00  9.49           C  
ATOM    874  CE2 TYR A 106      25.030 -15.575   2.573  1.00 11.27           C  
ATOM    875  CZ  TYR A 106      25.865 -14.557   3.016  1.00 11.47           C  
ATOM    876  OH  TYR A 106      25.597 -13.253   2.638  1.00 11.19           O  
ATOM    877  N   LEU A 107      26.769 -18.317   7.355  1.00 10.82           N  
ATOM    878  CA  LEU A 107      27.025 -17.408   8.465  1.00  9.86           C  
ATOM    879  C   LEU A 107      27.950 -16.302   7.961  1.00 10.54           C  
ATOM    880  O   LEU A 107      28.897 -16.557   7.206  1.00 11.09           O  
ATOM    881  CB  LEU A 107      27.732 -18.111   9.632  1.00  9.53           C  
ATOM    882  CG  LEU A 107      26.954 -19.193  10.354  1.00 11.65           C  
ATOM    883  CD1 LEU A 107      27.876 -19.879  11.366  1.00 11.77           C  
ATOM    884  CD2 LEU A 107      25.755 -18.588  11.066  1.00 11.27           C  
ATOM    885  N   ALA A 108      27.669 -15.070   8.374  1.00  9.84           N  
ATOM    886  CA  ALA A 108      28.509 -13.926   8.027  1.00  9.15           C  
ATOM    887  C   ALA A 108      29.888 -14.149   8.649  1.00 10.66           C  
ATOM    888  O   ALA A 108      30.007 -14.790   9.703  1.00 11.03           O  
ATOM    889  CB  ALA A 108      27.901 -12.646   8.602  1.00 11.46           C  
ATOM    890  N   PRO A 109      30.946 -13.621   8.016  1.00  9.01           N  
ATOM    891  CA  PRO A 109      32.303 -13.783   8.551  1.00  8.51           C  
ATOM    892  C   PRO A 109      32.373 -13.330  10.008  1.00 10.85           C  
ATOM    893  O   PRO A 109      31.673 -12.345  10.336  1.00 11.57           O  
ATOM    894  CB  PRO A 109      33.134 -12.856   7.659  1.00  7.55           C  
ATOM    895  CG  PRO A 109      32.452 -12.922   6.370  1.00  8.89           C  
ATOM    896  CD  PRO A 109      30.968 -12.875   6.745  1.00  9.18           C  
ATOM    897  OXT PRO A 109      33.150 -13.906  10.807  1.00 10.90           O  
TER     898      PRO A 109                                                      
END
MOLECULE T0391.pdb
ATOM      1  N   LYS    14      20.058 -27.031  -4.627  1.00 60.80           N  
ATOM      2  CA  LYS    14      18.878 -26.160  -4.323  1.00 60.75           C  
ATOM      3  C   LYS    14      19.298 -24.755  -3.828  1.00 60.82           C  
ATOM      4  O   LYS    14      18.794 -24.243  -2.809  1.00 60.89           O  
ATOM      5  CB  LYS    14      17.912 -26.875  -3.349  1.00 60.75           C  
ATOM      6  CG  LYS    14      18.148 -26.678  -1.832  1.00 60.46           C  
ATOM      7  CD  LYS    14      19.239 -27.549  -1.251  1.00 60.49           C  
ATOM      8  CE  LYS    14      19.374 -27.296   0.246  1.00 60.57           C  
ATOM      9  NZ  LYS    14      20.401 -28.172   0.889  1.00 60.29           N  
ATOM     10  N   TYR    15      20.208 -24.127  -4.570  1.00 60.44           N  
ATOM     11  CA  TYR    15      20.748 -22.827  -4.172  1.00 60.31           C  
ATOM     12  C   TYR    15      20.596 -21.697  -5.214  1.00 60.11           C  
ATOM     13  O   TYR    15      21.466 -20.821  -5.310  1.00 60.31           O  
ATOM     14  CB  TYR    15      22.220 -22.960  -3.731  1.00 60.66           C  
ATOM     15  CG  TYR    15      22.442 -23.716  -2.429  1.00 60.97           C  
ATOM     16  CD1 TYR    15      22.806 -25.063  -2.440  1.00 60.98           C  
ATOM     17  CD2 TYR    15      22.302 -23.081  -1.190  1.00 60.95           C  
ATOM     18  CE1 TYR    15      23.019 -25.762  -1.253  1.00 61.49           C  
ATOM     19  CE2 TYR    15      22.510 -23.773   0.005  1.00 60.54           C  
ATOM     20  CZ  TYR    15      22.870 -25.113  -0.036  1.00 61.22           C  
ATOM     21  OH  TYR    15      23.090 -25.813   1.132  1.00 61.20           O  
ATOM     22  N   THR    16      19.512 -21.700  -5.992  1.00 59.68           N  
ATOM     23  CA  THR    16      19.188 -20.514  -6.815  1.00 59.63           C  
ATOM     24  C   THR    16      17.836 -19.878  -6.426  1.00 58.97           C  
ATOM     25  O   THR    16      17.024 -20.493  -5.734  1.00 58.66           O  
ATOM     26  CB  THR    16      19.340 -20.760  -8.367  1.00 59.50           C  
ATOM     27  OG1 THR    16      20.712 -21.057  -8.684  1.00 60.71           O  
ATOM     28  CG2 THR    16      18.927 -19.524  -9.191  1.00 59.37           C  
ATOM     29  N   SER    17      17.657 -18.629  -6.856  1.00 59.10           N  
ATOM     30  CA  SER    17      16.500 -17.778  -6.591  1.00 59.12           C  
ATOM     31  C   SER    17      15.164 -18.496  -6.522  1.00 59.74           C  
ATOM     32  O   SER    17      14.808 -19.277  -7.416  1.00 58.25           O  
ATOM     33  CB  SER    17      16.366 -16.691  -7.673  1.00 59.23           C  
ATOM     34  OG  SER    17      17.578 -15.976  -7.871  1.00 60.17           O  
ATOM     35  N   VAL    18      14.428 -18.199  -5.452  1.00 59.57           N  
ATOM     36  CA  VAL    18      13.002 -18.454  -5.422  1.00 59.94           C  
ATOM     37  C   VAL    18      12.366 -17.085  -5.284  1.00 60.39           C  
ATOM     38  O   VAL    18      12.744 -16.309  -4.419  1.00 59.98           O  
ATOM     39  CB  VAL    18      12.613 -19.377  -4.253  1.00 59.90           C  
ATOM     40  CG1 VAL    18      11.086 -19.572  -4.178  1.00 59.62           C  
ATOM     41  CG2 VAL    18      13.318 -20.729  -4.393  1.00 59.73           C  
ATOM     42  N   CYS    19      11.436 -16.772  -6.177  1.00 62.03           N  
ATOM     43  CA  CYS    19      10.675 -15.546  -6.087  1.00 62.30           C  
ATOM     44  C   CYS    19       9.657 -15.686  -4.943  1.00 62.67           C  
ATOM     45  O   CYS    19       8.778 -16.538  -4.994  1.00 63.44           O  
ATOM     46  CB  CYS    19       9.969 -15.293  -7.396  1.00 62.62           C  
ATOM     47  SG  CYS    19       9.161 -13.703  -7.475  1.00 64.96           S  
ATOM     48  N   VAL    20       9.769 -14.851  -3.922  1.00 61.58           N  
ATOM     49  CA  VAL    20       8.958 -15.045  -2.708  1.00 61.49           C  
ATOM     50  C   VAL    20       7.766 -14.103  -2.702  1.00 62.35           C  
ATOM     51  O   VAL    20       6.872 -14.191  -1.856  1.00 63.15           O  
ATOM     52  CB  VAL    20       9.817 -14.911  -1.438  1.00 61.03           C  
ATOM     53  CG1 VAL    20      10.940 -15.911  -1.487  1.00 60.15           C  
ATOM     54  CG2 VAL    20      10.377 -13.514  -1.277  1.00 59.18           C  
ATOM     55  N   GLY    21       7.748 -13.211  -3.677  1.00 62.13           N  
ATOM     56  CA  GLY    21       6.681 -12.283  -3.790  1.00 62.19           C  
ATOM     57  C   GLY    21       7.038 -10.922  -4.329  1.00 62.64           C  
ATOM     58  O   GLY    21       8.104 -10.689  -4.947  1.00 62.35           O  
ATOM     59  N   ARG    22       6.090 -10.026  -4.089  1.00 62.17           N  
ATOM     60  CA  ARG    22       6.044  -8.731  -4.705  1.00 62.01           C  
ATOM     61  C   ARG    22       6.671  -7.685  -3.777  1.00 61.91           C  
ATOM     62  O   ARG    22       6.357  -7.629  -2.585  1.00 60.50           O  
ATOM     63  CB  ARG    22       4.576  -8.423  -4.962  1.00 62.52           C  
ATOM     64  CG  ARG    22       4.336  -7.596  -6.112  1.00 62.38           C  
ATOM     65  CD  ARG    22       2.862  -7.377  -6.307  1.00 63.37           C  
ATOM     66  NE  ARG    22       2.766  -6.247  -7.197  1.00 63.29           N  
ATOM     67  CZ  ARG    22       1.689  -5.863  -7.852  1.00 63.14           C  
ATOM     68  NH1 ARG    22       0.531  -6.515  -7.735  1.00 64.35           N  
ATOM     69  NH2 ARG    22       1.798  -4.807  -8.631  1.00 63.71           N  
ATOM     70  N   GLU    23       7.582  -6.874  -4.323  1.00 62.10           N  
ATOM     71  CA  GLU    23       8.103  -5.723  -3.602  1.00 62.33           C  
ATOM     72  C   GLU    23       6.970  -4.911  -2.955  1.00 62.52           C  
ATOM     73  O   GLU    23       7.045  -4.564  -1.781  1.00 63.44           O  
ATOM     74  CB  GLU    23       8.955  -4.850  -4.518  1.00 62.11           C  
ATOM     75  CG  GLU    23       9.910  -3.962  -3.752  1.00 63.73           C  
ATOM     76  CD  GLU    23      11.098  -3.492  -4.568  1.00 66.02           C  
ATOM     77  OE1 GLU    23      10.913  -3.119  -5.754  1.00 65.65           O  
ATOM     78  OE2 GLU    23      12.214  -3.482  -4.000  1.00 68.05           O  
ATOM     79  N   GLU    24       5.899  -4.665  -3.694  1.00 62.66           N  
ATOM     80  CA  GLU    24       4.773  -3.927  -3.141  1.00 63.27           C  
ATOM     81  C   GLU    24       4.077  -4.577  -1.938  1.00 63.16           C  
ATOM     82  O   GLU    24       3.586  -3.872  -1.053  1.00 63.14           O  
ATOM     83  CB  GLU    24       3.737  -3.650  -4.220  1.00 63.14           C  
ATOM     84  CG  GLU    24       4.183  -2.647  -5.259  1.00 65.00           C  
ATOM     85  CD  GLU    24       3.009  -2.112  -6.065  1.00 65.66           C  
ATOM     86  OE1 GLU    24       1.919  -2.735  -5.998  1.00 65.11           O  
ATOM     87  OE2 GLU    24       3.167  -1.071  -6.749  1.00 66.96           O  
ATOM     88  N   ASP    25       4.034  -5.902  -1.911  0.70 63.36           N  
ATOM     90  CA  ASP    25       3.305  -6.600  -0.868  0.70 63.79           C  
ATOM     92  C   ASP    25       4.028  -6.560   0.493  0.70 64.46           C  
ATOM     94  O   ASP    25       3.372  -6.638   1.542  0.70 64.77           O  
ATOM     96  CB  ASP    25       2.955  -8.031  -1.327  0.70 63.62           C  
ATOM     98  CG  ASP    25       1.892  -8.063  -2.468  0.70 63.86           C  
ATOM    100  OD1 ASP    25       1.400  -6.997  -2.932  0.70 61.48           O  
ATOM    102  OD2 ASP    25       1.538  -9.184  -2.900  0.70 64.42           O  
ATOM    104  N   ILE    26       5.358  -6.389   0.475  1.00 64.67           N  
ATOM    105  CA  ILE    26       6.187  -6.428   1.701  1.00 65.33           C  
ATOM    106  C   ILE    26       6.448  -5.038   2.254  1.00 66.28           C  
ATOM    107  O   ILE    26       6.715  -4.879   3.435  1.00 65.81           O  
ATOM    108  CB  ILE    26       7.568  -7.115   1.511  1.00 65.79           C  
ATOM    109  CG1 ILE    26       8.114  -7.590   2.873  1.00 65.49           C  
ATOM    110  CG2 ILE    26       8.578  -6.164   0.865  1.00 65.24           C  
ATOM    111  CD1 ILE    26       9.526  -8.114   2.841  1.00 64.46           C  
ATOM    112  N   ARG    27       6.376  -4.026   1.393  1.00 67.72           N  
ATOM    113  CA  ARG    27       6.661  -2.672   1.844  1.00 68.35           C  
ATOM    114  C   ARG    27       5.635  -2.232   2.887  1.00 68.20           C  
ATOM    115  O   ARG    27       6.004  -1.667   3.921  1.00 68.03           O  
ATOM    116  CB  ARG    27       6.823  -1.716   0.661  1.00 68.79           C  
ATOM    117  CG  ARG    27       8.136  -2.014  -0.065  1.00 70.71           C  
ATOM    118  CD  ARG    27       8.676  -0.888  -0.957  1.00 74.28           C  
ATOM    119  NE  ARG    27      10.113  -1.118  -1.136  1.00 76.73           N  
ATOM    120  CZ  ARG    27      10.900  -0.543  -2.046  1.00 77.51           C  
ATOM    121  NH1 ARG    27      10.418   0.335  -2.925  1.00 77.15           N  
ATOM    122  NH2 ARG    27      12.190  -0.862  -2.073  1.00 77.51           N  
ATOM    123  N   LYS    28       4.372  -2.577   2.641  1.00 68.05           N  
ATOM    124  CA  LYS    28       3.278  -2.331   3.573  1.00 67.84           C  
ATOM    125  C   LYS    28       3.515  -2.907   4.993  1.00 67.37           C  
ATOM    126  O   LYS    28       3.664  -2.148   5.957  1.00 67.14           O  
ATOM    127  CB  LYS    28       1.968  -2.845   2.957  1.00 68.52           C  
ATOM    128  CG  LYS    28       0.709  -2.558   3.781  1.00 69.95           C  
ATOM    129  CD  LYS    28      -0.479  -2.274   2.855  1.00 72.90           C  
ATOM    130  CE  LYS    28      -1.783  -2.048   3.625  1.00 74.32           C  
ATOM    131  NZ  LYS    28      -2.286  -3.344   4.158  1.00 76.24           N  
ATOM    132  N   SER    29       3.569  -4.235   5.119  1.00 66.72           N  
ATOM    133  CA  SER    29       3.748  -4.885   6.425  1.00 66.15           C  
ATOM    134  C   SER    29       5.187  -4.873   6.935  1.00 64.97           C  
ATOM    135  O   SER    29       5.459  -5.154   8.118  1.00 65.03           O  
ATOM    136  CB  SER    29       3.311  -6.336   6.336  1.00 66.89           C  
ATOM    137  OG  SER    29       4.355  -7.108   5.765  1.00 69.45           O  
ATOM    138  N   GLU    30       6.122  -4.606   6.034  1.00 62.79           N  
ATOM    139  CA  GLU    30       7.546  -4.652   6.367  1.00 60.91           C  
ATOM    140  C   GLU    30       8.128  -6.009   6.779  1.00 58.63           C  
ATOM    141  O   GLU    30       9.300  -6.064   7.176  1.00 57.90           O  
ATOM    142  CB  GLU    30       7.939  -3.541   7.349  1.00 61.73           C  
ATOM    143  CG  GLU    30       8.166  -2.226   6.596  1.00 64.11           C  
ATOM    144  CD  GLU    30       8.775  -1.124   7.442  1.00 68.01           C  
ATOM    145  OE1 GLU    30       8.252  -0.881   8.554  1.00 68.86           O  
ATOM    146  OE2 GLU    30       9.756  -0.484   6.970  1.00 69.07           O  
ATOM    147  N   ARG    31       7.333  -7.073   6.654  1.00 55.43           N  
ATOM    148  CA  ARG    31       7.814  -8.461   6.773  1.00 54.94           C  
ATOM    149  C   ARG    31       6.873  -9.468   6.122  1.00 55.34           C  
ATOM    150  O   ARG    31       5.669  -9.251   6.054  1.00 53.56           O  
ATOM    151  CB  ARG    31       8.017  -8.868   8.213  1.00 53.83           C  
ATOM    152  CG  ARG    31       6.689  -9.135   8.913  1.00 56.18           C  
ATOM    153  CD  ARG    31       6.870  -9.241  10.351  1.00 54.41           C  
ATOM    154  NE  ARG    31       7.484  -8.051  10.931  1.00 47.57           N  
ATOM    155  CZ  ARG    31       7.953  -8.038  12.168  1.00 43.51           C  
ATOM    156  NH1 ARG    31       7.864  -9.153  12.893  1.00 42.00           N  
ATOM    157  NH2 ARG    31       8.477  -6.939  12.679  1.00 40.05           N  
ATOM    158  N   MET    32       7.432 -10.587   5.679  1.00 57.33           N  
ATOM    159  CA  MET    32       6.647 -11.708   5.128  1.00 60.41           C  
ATOM    160  C   MET    32       7.435 -12.995   5.296  1.00 59.05           C  
ATOM    161  O   MET    32       8.664 -12.974   5.342  1.00 60.30           O  
ATOM    162  CB  MET    32       6.358 -11.492   3.619  1.00 59.37           C  
ATOM    163  CG  MET    32       7.571 -11.596   2.693  1.00 63.82           C  
ATOM    164  SD  MET    32       7.112 -11.204   0.978  1.00 69.27           S  
ATOM    165  CE  MET    32       5.647 -10.216   1.194  1.00 68.77           C  
ATOM    166  N   THR    33       6.752 -14.125   5.326  1.00 57.39           N  
ATOM    167  CA  THR    33       7.468 -15.385   5.383  1.00 55.82           C  
ATOM    168  C   THR    33       7.420 -16.058   3.993  1.00 56.31           C  
ATOM    169  O   THR    33       6.532 -15.751   3.131  1.00 54.99           O  
ATOM    170  CB  THR    33       6.882 -16.321   6.457  1.00 56.65           C  
ATOM    171  OG1 THR    33       5.603 -16.815   5.987  1.00 56.10           O  
ATOM    172  CG2 THR    33       6.697 -15.553   7.836  1.00 55.74           C  
ATOM    173  N   ALA    34       8.335 -16.989   3.761  1.00 54.34           N  
ATOM    174  CA  ALA    34       8.184 -17.826   2.570  1.00 54.83           C  
ATOM    175  C   ALA    34       8.807 -19.181   2.790  1.00 53.98           C  
ATOM    176  O   ALA    34       9.635 -19.352   3.681  1.00 53.23           O  
ATOM    177  CB  ALA    34       8.816 -17.148   1.365  1.00 55.64           C  
ATOM    178  N   VAL    35       8.422 -20.150   1.969  1.00 52.71           N  
ATOM    179  CA  VAL    35       9.146 -21.419   1.963  1.00 51.53           C  
ATOM    180  C   VAL    35      10.059 -21.440   0.736  1.00 50.48           C  
ATOM    181  O   VAL    35       9.597 -21.267  -0.405  1.00 50.86           O  
ATOM    182  CB  VAL    35       8.199 -22.656   2.139  1.00 51.55           C  
ATOM    183  CG1 VAL    35       8.927 -23.938   1.867  1.00 51.62           C  
ATOM    184  CG2 VAL    35       7.649 -22.678   3.595  1.00 51.89           C  
ATOM    185  N   VAL    36      11.358 -21.607   0.993  1.00 47.93           N  
ATOM    186  CA  VAL    36      12.369 -21.552  -0.052  1.00 46.54           C  
ATOM    187  C   VAL    36      13.108 -22.885  -0.044  1.00 46.09           C  
ATOM    188  O   VAL    36      13.795 -23.191   0.917  1.00 45.92           O  
ATOM    189  CB  VAL    36      13.329 -20.352   0.148  1.00 46.45           C  
ATOM    190  CG1 VAL    36      14.517 -20.414  -0.842  1.00 45.45           C  
ATOM    191  CG2 VAL    36      12.561 -19.045  -0.018  1.00 43.17           C  
ATOM    192  N   HIS    37      12.900 -23.698  -1.086  1.00 45.65           N  
ATOM    193  CA  HIS    37      13.449 -25.056  -1.162  1.00 45.17           C  
ATOM    194  C   HIS    37      13.275 -25.825   0.164  1.00 45.04           C  
ATOM    195  O   HIS    37      14.256 -26.313   0.741  1.00 45.28           O  
ATOM    196  CB  HIS    37      14.941 -25.015  -1.540  1.00 45.31           C  
ATOM    197  CG  HIS    37      15.243 -24.292  -2.824  1.00 45.88           C  
ATOM    198  ND1 HIS    37      14.568 -24.534  -4.004  1.00 46.39           N  
ATOM    199  CD2 HIS    37      16.190 -23.367  -3.117  1.00 46.19           C  
ATOM    200  CE1 HIS    37      15.074 -23.775  -4.962  1.00 46.61           C  
ATOM    201  NE2 HIS    37      16.058 -23.055  -4.449  1.00 45.87           N  
ATOM    202  N   ASP    38      12.041 -25.892   0.661  1.00 44.85           N  
ATOM    203  CA  ASP    38      11.706 -26.553   1.941  1.00 45.31           C  
ATOM    204  C   ASP    38      12.339 -25.925   3.206  1.00 45.08           C  
ATOM    205  O   ASP    38      12.315 -26.535   4.284  1.00 45.02           O  
ATOM    206  CB  ASP    38      12.026 -28.055   1.910  1.00 45.77           C  
ATOM    207  CG  ASP    38      11.383 -28.776   0.726  1.00 49.13           C  
ATOM    208  OD1 ASP    38      10.128 -28.791   0.650  1.00 51.40           O  
ATOM    209  OD2 ASP    38      12.135 -29.334  -0.124  1.00 51.32           O  
ATOM    210  N   ARG    39      12.917 -24.729   3.081  1.00 43.95           N  
ATOM    211  CA  ARG    39      13.413 -24.021   4.257  1.00 43.30           C  
ATOM    212  C   ARG    39      12.521 -22.812   4.452  1.00 42.56           C  
ATOM    213  O   ARG    39      12.335 -22.011   3.534  1.00 42.90           O  
ATOM    214  CB  ARG    39      14.865 -23.605   4.108  1.00 43.37           C  
ATOM    215  CG  ARG    39      15.608 -23.594   5.429  1.00 43.77           C  
ATOM    216  CD  ARG    39      17.029 -23.142   5.261  1.00 45.03           C  
ATOM    217  NE  ARG    39      17.674 -23.029   6.560  1.00 45.90           N  
ATOM    218  CZ  ARG    39      18.700 -23.769   6.945  1.00 43.80           C  
ATOM    219  NH1 ARG    39      19.211 -24.648   6.103  1.00 43.43           N  
ATOM    220  NH2 ARG    39      19.216 -23.604   8.157  1.00 40.35           N  
ATOM    221  N   GLU    40      11.915 -22.727   5.625  1.00 41.87           N  
ATOM    222  CA  GLU    40      11.019 -21.619   5.932  1.00 40.70           C  
ATOM    223  C   GLU    40      11.814 -20.418   6.451  1.00 40.21           C  
ATOM    224  O   GLU    40      12.671 -20.553   7.321  1.00 39.91           O  
ATOM    225  CB  GLU    40       9.926 -22.041   6.911  1.00 41.02           C  
ATOM    226  CG  GLU    40       8.775 -21.074   6.870  1.00 41.02           C  
ATOM    227  CD  GLU    40       7.670 -21.402   7.819  1.00 45.48           C  
ATOM    228  OE1 GLU    40       7.862 -22.213   8.771  1.00 46.20           O  
ATOM    229  OE2 GLU    40       6.581 -20.845   7.575  1.00 44.48           O  
ATOM    230  N   VAL    41      11.578 -19.259   5.838  1.00 39.09           N  
ATOM    231  CA  VAL    41      12.354 -18.057   6.115  1.00 37.88           C  
ATOM    232  C   VAL    41      11.436 -16.887   6.414  1.00 37.27           C  
ATOM    233  O   VAL    41      10.267 -16.869   6.008  1.00 36.57           O  
ATOM    234  CB  VAL    41      13.326 -17.655   4.896  1.00 37.87           C  
ATOM    235  CG1 VAL    41      14.182 -18.804   4.466  1.00 36.47           C  
ATOM    236  CG2 VAL    41      12.531 -17.210   3.656  1.00 38.60           C  
ATOM    237  N   VAL    42      11.998 -15.867   7.049  1.00 36.63           N  
ATOM    238  CA  VAL    42      11.308 -14.631   7.203  1.00 35.76           C  
ATOM    239  C   VAL    42      12.103 -13.576   6.456  1.00 36.42           C  
ATOM    240  O   VAL    42      13.302 -13.561   6.538  1.00 34.56           O  
ATOM    241  CB  VAL    42      11.050 -14.279   8.729  1.00 36.00           C  
ATOM    242  CG1 VAL    42      12.356 -14.284   9.550  1.00 31.47           C  
ATOM    243  CG2 VAL    42      10.244 -12.935   8.858  1.00 36.12           C  
ATOM    244  N   ILE    43      11.423 -12.711   5.705  1.00 36.07           N  
ATOM    245  CA  ILE    43      12.088 -11.573   5.057  1.00 35.72           C  
ATOM    246  C   ILE    43      11.611 -10.312   5.753  1.00 35.08           C  
ATOM    247  O   ILE    43      10.425 -10.130   5.901  1.00 34.92           O  
ATOM    248  CB  ILE    43      11.748 -11.420   3.540  1.00 36.04           C  
ATOM    249  CG1 ILE    43      12.131 -12.678   2.760  1.00 38.38           C  
ATOM    250  CG2 ILE    43      12.503 -10.221   2.900  1.00 35.84           C  
ATOM    251  CD1 ILE    43      10.953 -13.665   2.645  1.00 41.98           C  
ATOM    252  N   PHE    44      12.540  -9.455   6.170  1.00 35.27           N  
ATOM    253  CA  PHE    44      12.207  -8.159   6.750  1.00 35.90           C  
ATOM    254  C   PHE    44      12.611  -7.070   5.764  1.00 36.03           C  
ATOM    255  O   PHE    44      13.695  -7.104   5.206  1.00 36.06           O  
ATOM    256  CB  PHE    44      12.996  -7.939   8.051  1.00 35.55           C  
ATOM    257  CG  PHE    44      12.675  -8.944   9.149  1.00 35.15           C  
ATOM    258  CD1 PHE    44      11.461  -8.863   9.856  1.00 33.52           C  
ATOM    259  CD2 PHE    44      13.555  -9.953   9.456  1.00 35.10           C  
ATOM    260  CE1 PHE    44      11.145  -9.775  10.840  1.00 31.22           C  
ATOM    261  CE2 PHE    44      13.260 -10.834  10.490  1.00 33.69           C  
ATOM    262  CZ  PHE    44      12.043 -10.747  11.155  1.00 34.12           C  
ATOM    263  N   TYR    45      11.744  -6.094   5.576  1.00 36.13           N  
ATOM    264  CA  TYR    45      12.120  -4.861   4.896  1.00 37.49           C  
ATOM    265  C   TYR    45      12.253  -3.757   5.917  1.00 37.07           C  
ATOM    266  O   TYR    45      11.271  -3.380   6.534  1.00 38.99           O  
ATOM    267  CB  TYR    45      11.055  -4.484   3.898  1.00 36.98           C  
ATOM    268  CG  TYR    45      11.334  -3.182   3.158  1.00 39.78           C  
ATOM    269  CD1 TYR    45      12.338  -3.109   2.209  1.00 40.79           C  
ATOM    270  CD2 TYR    45      10.595  -2.037   3.421  1.00 38.05           C  
ATOM    271  CE1 TYR    45      12.605  -1.935   1.531  1.00 41.88           C  
ATOM    272  CE2 TYR    45      10.858  -0.857   2.763  1.00 41.50           C  
ATOM    273  CZ  TYR    45      11.862  -0.805   1.807  1.00 40.93           C  
ATOM    274  OH  TYR    45      12.120   0.387   1.114  1.00 40.29           O  
ATOM    275  N   HIS    46      13.443  -3.229   6.111  1.00 36.34           N  
ATOM    276  CA  HIS    46      13.652  -2.224   7.156  1.00 36.95           C  
ATOM    277  C   HIS    46      14.640  -1.131   6.693  1.00 37.04           C  
ATOM    278  O   HIS    46      15.718  -1.438   6.160  1.00 36.11           O  
ATOM    279  CB  HIS    46      14.162  -2.927   8.432  1.00 37.03           C  
ATOM    280  CG  HIS    46      14.389  -2.016   9.605  1.00 38.48           C  
ATOM    281  ND1 HIS    46      13.356  -1.460  10.337  1.00 40.30           N  
ATOM    282  CD2 HIS    46      15.530  -1.603  10.200  1.00 36.98           C  
ATOM    283  CE1 HIS    46      13.855  -0.725  11.315  1.00 38.56           C  
ATOM    284  NE2 HIS    46      15.171  -0.791  11.249  1.00 38.82           N  
ATOM    285  N   LYS    47      14.275   0.138   6.920  1.00 36.95           N  
ATOM    286  CA  LYS    47      15.099   1.269   6.525  1.00 37.47           C  
ATOM    287  C   LYS    47      15.604   1.065   5.095  1.00 37.40           C  
ATOM    288  O   LYS    47      16.817   1.170   4.821  1.00 36.64           O  
ATOM    289  CB  LYS    47      16.293   1.452   7.465  1.00 38.17           C  
ATOM    290  CG  LYS    47      15.974   1.813   8.904  1.00 40.46           C  
ATOM    291  CD  LYS    47      17.211   2.484   9.503  1.00 45.27           C  
ATOM    292  CE  LYS    47      17.181   2.580  11.022  1.00 47.38           C  
ATOM    293  NZ  LYS    47      17.861   1.421  11.685  1.00 50.94           N  
ATOM    294  N   GLY    48      14.674   0.731   4.194  1.00 37.40           N  
ATOM    295  CA  GLY    48      15.000   0.560   2.776  1.00 37.40           C  
ATOM    296  C   GLY    48      15.856  -0.636   2.402  1.00 37.80           C  
ATOM    297  O   GLY    48      16.304  -0.738   1.278  1.00 38.04           O  
ATOM    298  N   GLU    49      16.085  -1.556   3.336  1.00 38.38           N  
ATOM    299  CA  GLU    49      16.829  -2.797   3.029  1.00 38.96           C  
ATOM    300  C   GLU    49      16.071  -4.079   3.366  1.00 37.40           C  
ATOM    301  O   GLU    49      15.276  -4.102   4.272  1.00 37.65           O  
ATOM    302  CB  GLU    49      18.154  -2.817   3.788  1.00 38.83           C  
ATOM    303  CG  GLU    49      18.937  -1.583   3.524  1.00 43.50           C  
ATOM    304  CD  GLU    49      20.402  -1.850   3.556  1.00 48.39           C  
ATOM    305  OE1 GLU    49      20.835  -2.546   4.503  1.00 49.17           O  
ATOM    306  OE2 GLU    49      21.094  -1.373   2.622  1.00 51.30           O  
ATOM    307  N   TYR    50      16.403  -5.145   2.652  1.00 37.51           N  
ATOM    308  CA  TYR    50      15.783  -6.447   2.770  1.00 37.42           C  
ATOM    309  C   TYR    50      16.698  -7.402   3.513  1.00 37.93           C  
ATOM    310  O   TYR    50      17.897  -7.407   3.283  1.00 36.23           O  
ATOM    311  CB  TYR    50      15.475  -6.971   1.367  1.00 38.36           C  
ATOM    312  CG  TYR    50      14.401  -6.171   0.692  1.00 38.71           C  
ATOM    313  CD1 TYR    50      13.052  -6.451   0.947  1.00 41.30           C  
ATOM    314  CD2 TYR    50      14.714  -5.109  -0.176  1.00 39.45           C  
ATOM    315  CE1 TYR    50      12.043  -5.728   0.367  1.00 39.50           C  
ATOM    316  CE2 TYR    50      13.689  -4.361  -0.778  1.00 41.37           C  
ATOM    317  CZ  TYR    50      12.347  -4.688  -0.495  1.00 41.85           C  
ATOM    318  OH  TYR    50      11.300  -3.995  -1.058  1.00 39.83           O  
ATOM    319  N   HIS    51      16.156  -8.162   4.451  1.00 37.00           N  
ATOM    320  CA  HIS    51      16.962  -9.128   5.154  1.00 37.66           C  
ATOM    321  C   HIS    51      16.187 -10.409   5.256  1.00 38.22           C  
ATOM    322  O   HIS    51      15.034 -10.396   5.749  1.00 40.63           O  
ATOM    323  CB  HIS    51      17.362  -8.635   6.576  1.00 38.17           C  
ATOM    324  CG  HIS    51      17.992  -7.280   6.598  1.00 36.35           C  
ATOM    325  ND1 HIS    51      19.324  -7.072   6.311  1.00 36.15           N  
ATOM    326  CD2 HIS    51      17.462  -6.060   6.834  1.00 36.39           C  
ATOM    327  CE1 HIS    51      19.587  -5.780   6.377  1.00 36.16           C  
ATOM    328  NE2 HIS    51      18.475  -5.144   6.699  1.00 36.78           N  
ATOM    329  N   ALA    52      16.783 -11.510   4.813  1.00 36.23           N  
ATOM    330  CA  ALA    52      16.191 -12.852   4.974  1.00 35.83           C  
ATOM    331  C   ALA    52      16.956 -13.725   5.994  1.00 35.84           C  
ATOM    332  O   ALA    52      18.162 -13.772   5.971  1.00 35.96           O  
ATOM    333  CB  ALA    52      16.112 -13.564   3.635  1.00 34.44           C  
ATOM    334  N   MET    53      16.230 -14.425   6.860  1.00 35.98           N  
ATOM    335  CA  MET    53      16.856 -15.383   7.786  1.00 35.97           C  
ATOM    336  C   MET    53      15.895 -16.513   8.097  1.00 34.34           C  
ATOM    337  O   MET    53      14.698 -16.423   7.816  1.00 34.06           O  
ATOM    338  CB  MET    53      17.275 -14.682   9.102  1.00 34.38           C  
ATOM    339  CG  MET    53      16.059 -14.042   9.793  1.00 36.38           C  
ATOM    340  SD  MET    53      16.365 -13.290  11.396  1.00 37.83           S  
ATOM    341  CE  MET    53      17.224 -11.779  10.901  1.00 31.98           C  
ATOM    342  N   ASP    54      16.437 -17.570   8.692  1.00 35.49           N  
ATOM    343  CA  ASP    54      15.663 -18.709   9.166  1.00 35.03           C  
ATOM    344  C   ASP    54      14.594 -18.178  10.077  1.00 35.41           C  
ATOM    345  O   ASP    54      14.838 -17.266  10.883  1.00 36.46           O  
ATOM    346  CB  ASP    54      16.555 -19.680   9.974  1.00 36.35           C  
ATOM    347  CG  ASP    54      17.394 -20.595   9.089  1.00 37.52           C  
ATOM    348  OD1 ASP    54      17.092 -20.730   7.865  1.00 42.19           O  
ATOM    349  OD2 ASP    54      18.379 -21.187   9.608  1.00 36.00           O  
ATOM    350  N   ILE    55      13.400 -18.736   9.977  1.00 33.76           N  
ATOM    351  CA  ILE    55      12.271 -18.163  10.687  1.00 33.72           C  
ATOM    352  C   ILE    55      12.256 -18.488  12.189  1.00 34.09           C  
ATOM    353  O   ILE    55      11.846 -17.651  12.987  1.00 35.22           O  
ATOM    354  CB  ILE    55      10.909 -18.575  10.023  1.00 32.75           C  
ATOM    355  CG1 ILE    55       9.729 -17.838  10.671  1.00 34.08           C  
ATOM    356  CG2 ILE    55      10.649 -20.098  10.162  1.00 32.55           C  
ATOM    357  CD1 ILE    55       8.426 -17.928   9.803  1.00 33.04           C  
ATOM    358  N   ARG    56      12.676 -19.701  12.554  1.00 34.32           N  
ATOM    359  CA  ARG    56      12.678 -20.122  13.949  0.50 34.27           C  
ATOM    361  C   ARG    56      13.979 -19.728  14.679  1.00 35.02           C  
ATOM    362  O   ARG    56      15.105 -19.999  14.216  1.00 34.05           O  
ATOM    363  CB  ARG    56      12.392 -21.611  14.064  0.50 33.71           C  
ATOM    365  CG  ARG    56      11.174 -22.056  13.253  0.50 33.20           C  
ATOM    367  CD  ARG    56       9.863 -21.458  13.767  0.50 34.41           C  
ATOM    369  NE  ARG    56       8.811 -21.580  12.749  0.50 33.94           N  
ATOM    371  CZ  ARG    56       7.540 -21.219  12.904  0.50 33.39           C  
ATOM    373  NH1 ARG    56       7.124 -20.701  14.053  0.50 33.15           N  
ATOM    375  NH2 ARG    56       6.684 -21.388  11.901  0.50 30.53           N  
ATOM    377  N   CYS    57      13.782 -19.059  15.804  1.00 34.89           N  
ATOM    378  CA  CYS    57      14.857 -18.517  16.622  1.00 34.84           C  
ATOM    379  C   CYS    57      15.820 -19.605  17.046  1.00 35.33           C  
ATOM    380  O   CYS    57      15.405 -20.619  17.585  1.00 34.76           O  
ATOM    381  CB  CYS    57      14.258 -17.828  17.853  1.00 35.43           C  
ATOM    382  SG  CYS    57      15.469 -17.137  18.937  1.00 35.67           S  
ATOM    383  N   TYR    58      17.109 -19.375  16.835  1.00 33.56           N  
ATOM    384  CA  TYR    58      18.141 -20.335  17.256  1.00 34.44           C  
ATOM    385  C   TYR    58      18.123 -20.742  18.712  1.00 34.87           C  
ATOM    386  O   TYR    58      18.677 -21.797  19.032  1.00 35.22           O  
ATOM    387  CB  TYR    58      19.564 -19.805  16.955  1.00 32.35           C  
ATOM    388  CG  TYR    58      20.078 -18.730  17.956  1.00 32.86           C  
ATOM    389  CD1 TYR    58      19.791 -17.386  17.764  1.00 32.31           C  
ATOM    390  CD2 TYR    58      20.892 -19.078  19.025  1.00 26.69           C  
ATOM    391  CE1 TYR    58      20.280 -16.385  18.653  1.00 36.22           C  
ATOM    392  CE2 TYR    58      21.337 -18.112  19.962  1.00 32.60           C  
ATOM    393  CZ  TYR    58      21.100 -16.767  19.710  1.00 32.41           C  
ATOM    394  OH  TYR    58      21.552 -15.812  20.596  1.00 35.59           O  
ATOM    395  N   HIS    59      17.583 -19.901  19.596  1.00 34.43           N  
ATOM    396  CA  HIS    59      17.668 -20.152  21.034  1.00 33.97           C  
ATOM    397  C   HIS    59      16.815 -21.395  21.360  1.00 34.28           C  
ATOM    398  O   HIS    59      17.331 -22.404  21.833  1.00 33.47           O  
ATOM    399  CB  HIS    59      17.194 -18.912  21.838  1.00 34.01           C  
ATOM    400  CG  HIS    59      17.046 -19.170  23.316  1.00 31.90           C  
ATOM    401  ND1 HIS    59      15.913 -18.854  24.030  1.00 32.75           N  
ATOM    402  CD2 HIS    59      17.922 -19.688  24.212  1.00 31.88           C  
ATOM    403  CE1 HIS    59      16.070 -19.221  25.292  1.00 36.93           C  
ATOM    404  NE2 HIS    59      17.286 -19.723  25.432  1.00 36.41           N  
ATOM    405  N   SER    60      15.504 -21.309  21.140  1.00 34.09           N  
ATOM    406  CA  SER    60      14.580 -22.404  21.464  1.00 35.56           C  
ATOM    407  C   SER    60      13.520 -22.620  20.402  1.00 35.00           C  
ATOM    408  O   SER    60      12.473 -23.273  20.676  1.00 34.15           O  
ATOM    409  CB  SER    60      13.793 -22.101  22.766  1.00 35.66           C  
ATOM    410  OG  SER    60      14.529 -22.465  23.868  1.00 40.94           O  
ATOM    411  N   GLY    61      13.725 -22.050  19.227  1.00 33.78           N  
ATOM    412  CA  GLY    61      12.734 -22.180  18.151  1.00 33.83           C  
ATOM    413  C   GLY    61      11.537 -21.216  18.082  1.00 33.58           C  
ATOM    414  O   GLY    61      10.581 -21.489  17.382  1.00 33.89           O  
ATOM    415  N   GLY    62      11.592 -20.060  18.752  1.00 34.29           N  
ATOM    416  CA  GLY    62      10.503 -19.064  18.703  1.00 33.30           C  
ATOM    417  C   GLY    62      10.292 -18.403  17.339  1.00 34.18           C  
ATOM    418  O   GLY    62      11.131 -18.485  16.449  1.00 34.46           O  
ATOM    419  N   PRO    63       9.131 -17.779  17.156  1.00 34.28           N  
ATOM    420  CA  PRO    63       8.647 -17.233  15.855  1.00 34.13           C  
ATOM    421  C   PRO    63       9.249 -15.820  15.609  1.00 35.32           C  
ATOM    422  O   PRO    63       8.683 -14.844  16.083  1.00 35.94           O  
ATOM    423  CB  PRO    63       7.098 -17.165  16.070  1.00 34.92           C  
ATOM    424  CG  PRO    63       6.909 -17.071  17.597  1.00 34.02           C  
ATOM    425  CD  PRO    63       8.162 -17.613  18.267  1.00 32.77           C  
ATOM    426  N   LEU    64      10.409 -15.724  14.939  1.00 33.85           N  
ATOM    427  CA  LEU    64      11.035 -14.426  14.722  1.00 35.10           C  
ATOM    428  C   LEU    64      10.190 -13.455  13.888  1.00 35.51           C  
ATOM    429  O   LEU    64      10.282 -12.231  14.090  1.00 35.60           O  
ATOM    430  CB  LEU    64      12.420 -14.584  14.076  1.00 33.19           C  
ATOM    431  CG  LEU    64      13.471 -15.228  14.956  1.00 33.67           C  
ATOM    432  CD1 LEU    64      14.780 -15.303  14.169  1.00 31.32           C  
ATOM    433  CD2 LEU    64      13.683 -14.567  16.368  1.00 32.77           C  
ATOM    434  N   HIS    65       9.310 -14.009  13.014  1.00 36.13           N  
ATOM    435  CA  HIS    65       8.382 -13.207  12.206  1.00 35.49           C  
ATOM    436  C   HIS    65       7.333 -12.496  13.062  1.00 36.08           C  
ATOM    437  O   HIS    65       6.658 -11.607  12.549  1.00 36.02           O  
ATOM    438  CB  HIS    65       7.719 -14.047  11.080  1.00 34.87           C  
ATOM    439  CG  HIS    65       6.740 -15.075  11.579  1.00 34.80           C  
ATOM    440  ND1 HIS    65       7.104 -16.108  12.425  1.00 32.82           N  
ATOM    441  CD2 HIS    65       5.425 -15.270  11.294  1.00 35.42           C  
ATOM    442  CE1 HIS    65       6.030 -16.818  12.735  1.00 35.35           C  
ATOM    443  NE2 HIS    65       5.003 -16.349  12.044  1.00 34.51           N  
ATOM    444  N   LEU    66       7.226 -12.856  14.351  1.00 35.16           N  
ATOM    445  CA  LEU    66       6.321 -12.166  15.276  1.00 34.56           C  
ATOM    446  C   LEU    66       7.126 -11.259  16.209  1.00 34.99           C  
ATOM    447  O   LEU    66       6.571 -10.695  17.130  1.00 34.13           O  
ATOM    448  CB  LEU    66       5.499 -13.148  16.118  1.00 35.06           C  
ATOM    449  CG  LEU    66       4.672 -14.209  15.366  1.00 36.17           C  
ATOM    450  CD1 LEU    66       3.790 -14.925  16.316  1.00 36.21           C  
ATOM    451  CD2 LEU    66       3.919 -13.613  14.176  1.00 33.70           C  
ATOM    452  N   GLY    67       8.431 -11.107  15.993  1.00 32.27           N  
ATOM    453  CA  GLY    67       9.167 -10.210  16.887  1.00 33.66           C  
ATOM    454  C   GLY    67       9.179  -8.750  16.492  1.00 34.02           C  
ATOM    455  O   GLY    67       8.704  -8.397  15.403  1.00 34.86           O  
ATOM    456  N   GLU    68       9.706  -7.884  17.364  1.00 34.92           N  
ATOM    457  CA  GLU    68       9.815  -6.470  17.032  0.50 34.77           C  
ATOM    459  C   GLU    68      11.234  -6.174  16.546  1.00 36.04           C  
ATOM    460  O   GLU    68      12.222  -6.826  16.990  1.00 34.69           O  
ATOM    461  CB  GLU    68       9.482  -5.582  18.246  0.50 34.98           C  
ATOM    463  CG  GLU    68       8.148  -5.870  18.980  0.50 33.52           C  
ATOM    465  CD  GLU    68       6.963  -5.201  18.371  0.50 31.29           C  
ATOM    467  OE1 GLU    68       6.995  -4.840  17.191  0.50 32.99           O  
ATOM    469  OE2 GLU    68       5.968  -5.014  19.089  0.50 35.61           O  
ATOM    471  N   ILE    69      11.358  -5.184  15.662  1.00 36.24           N  
ATOM    472  CA  ILE    69      12.690  -4.749  15.196  1.00 39.01           C  
ATOM    473  C   ILE    69      13.122  -3.516  16.002  1.00 40.20           C  
ATOM    474  O   ILE    69      12.326  -2.588  16.158  1.00 38.19           O  
ATOM    475  CB  ILE    69      12.670  -4.427  13.673  1.00 39.84           C  
ATOM    476  CG1 ILE    69      12.411  -5.733  12.873  1.00 41.79           C  
ATOM    477  CG2 ILE    69      14.002  -3.705  13.233  1.00 39.07           C  
ATOM    478  CD1 ILE    69      12.138  -5.498  11.381  1.00 39.19           C  
ATOM    479  N   GLU    70      14.336  -3.532  16.564  1.00 40.88           N  
ATOM    480  CA  GLU    70      14.914  -2.358  17.235  1.00 44.15           C  
ATOM    481  C   GLU    70      16.417  -2.296  17.027  1.00 42.63           C  
ATOM    482  O   GLU    70      17.083  -3.326  16.854  1.00 40.70           O  
ATOM    483  CB  GLU    70      14.727  -2.352  18.758  1.00 44.02           C  
ATOM    484  CG  GLU    70      13.479  -2.956  19.319  1.00 49.17           C  
ATOM    485  CD  GLU    70      13.403  -2.778  20.857  1.00 50.66           C  
ATOM    486  OE1 GLU    70      13.816  -1.656  21.361  1.00 57.14           O  
ATOM    487  OE2 GLU    70      12.923  -3.748  21.533  1.00 53.10           O  
ATOM    488  N   ASP    71      16.941  -1.081  17.146  1.00 42.60           N  
ATOM    489  CA  ASP    71      18.382  -0.850  17.089  1.00 43.31           C  
ATOM    490  C   ASP    71      19.025  -1.001  18.446  1.00 43.56           C  
ATOM    491  O   ASP    71      18.527  -0.452  19.446  1.00 44.12           O  
ATOM    492  CB  ASP    71      18.695   0.530  16.502  1.00 43.80           C  
ATOM    493  CG  ASP    71      18.390   0.615  15.022  1.00 45.66           C  
ATOM    494  OD1 ASP    71      17.523  -0.130  14.518  1.00 46.85           O  
ATOM    495  OD2 ASP    71      19.031   1.442  14.340  1.00 50.54           O  
ATOM    496  N   PHE    72      20.119  -1.763  18.480  1.00 42.87           N  
ATOM    497  CA  PHE    72      20.968  -1.887  19.651  1.00 42.59           C  
ATOM    498  C   PHE    72      22.398  -1.763  19.142  1.00 42.61           C  
ATOM    499  O   PHE    72      22.744  -2.358  18.120  1.00 41.94           O  
ATOM    500  CB  PHE    72      20.781  -3.235  20.371  1.00 43.24           C  
ATOM    501  CG  PHE    72      19.348  -3.523  20.793  1.00 45.32           C  
ATOM    502  CD1 PHE    72      18.843  -3.025  21.994  1.00 47.35           C  
ATOM    503  CD2 PHE    72      18.501  -4.280  19.983  1.00 44.73           C  
ATOM    504  CE1 PHE    72      17.503  -3.279  22.376  1.00 48.24           C  
ATOM    505  CE2 PHE    72      17.168  -4.525  20.359  1.00 39.75           C  
ATOM    506  CZ  PHE    72      16.683  -4.035  21.549  1.00 45.38           C  
ATOM    507  N   ASN    73      23.206  -0.973  19.850  1.00 43.10           N  
ATOM    508  CA  ASN    73      24.606  -0.660  19.467  1.00 43.65           C  
ATOM    509  C   ASN    73      24.686  -0.152  18.023  1.00 43.70           C  
ATOM    510  O   ASN    73      25.601  -0.496  17.283  1.00 43.14           O  
ATOM    511  CB  ASN    73      25.513  -1.889  19.657  1.00 43.42           C  
ATOM    512  CG  ASN    73      27.003  -1.519  19.856  1.00 46.43           C  
ATOM    513  OD1 ASN    73      27.353  -0.367  20.187  1.00 43.42           O  
ATOM    514  ND2 ASN    73      27.889  -2.518  19.667  1.00 48.36           N  
ATOM    515  N   GLY    74      23.677   0.609  17.606  1.00 44.40           N  
ATOM    516  CA  GLY    74      23.611   1.082  16.214  1.00 44.51           C  
ATOM    517  C   GLY    74      23.381   0.008  15.147  1.00 44.46           C  
ATOM    518  O   GLY    74      23.531   0.291  13.971  1.00 44.76           O  
ATOM    519  N   GLN    75      23.016  -1.212  15.556  1.00 43.78           N  
ATOM    520  CA  GLN    75      22.635  -2.297  14.632  1.00 42.82           C  
ATOM    521  C   GLN    75      21.157  -2.669  14.762  1.00 40.89           C  
ATOM    522  O   GLN    75      20.649  -2.890  15.865  1.00 40.71           O  
ATOM    523  CB  GLN    75      23.479  -3.545  14.896  1.00 42.81           C  
ATOM    524  CG  GLN    75      24.968  -3.400  14.622  1.00 46.95           C  
ATOM    525  CD  GLN    75      25.797  -4.451  15.386  1.00 50.89           C  
ATOM    526  OE1 GLN    75      26.011  -4.339  16.595  1.00 52.08           O  
ATOM    527  NE2 GLN    75      26.257  -5.474  14.673  1.00 51.59           N  
ATOM    528  N   SER    76      20.470  -2.740  13.621  1.00 39.88           N  
ATOM    529  CA  SER    76      19.081  -3.185  13.538  1.00 38.27           C  
ATOM    530  C   SER    76      18.980  -4.683  13.879  1.00 36.85           C  
ATOM    531  O   SER    76      19.722  -5.479  13.320  1.00 36.22           O  
ATOM    532  CB  SER    76      18.554  -2.935  12.130  1.00 38.31           C  
ATOM    533  OG  SER    76      18.478  -1.527  11.875  1.00 43.22           O  
ATOM    534  N   CYS    77      18.072  -5.043  14.789  1.00 35.33           N  
ATOM    535  CA  CYS    77      17.930  -6.402  15.313  1.00 34.59           C  
ATOM    536  C   CYS    77      16.462  -6.789  15.272  1.00 35.71           C  
ATOM    537  O   CYS    77      15.620  -5.957  15.526  1.00 35.64           O  
ATOM    538  CB  CYS    77      18.356  -6.451  16.776  1.00 33.34           C  
ATOM    539  SG  CYS    77      20.163  -6.333  16.976  1.00 35.65           S  
ATOM    540  N   ILE    78      16.190  -8.059  15.007  1.00 34.76           N  
ATOM    541  CA  ILE    78      14.973  -8.688  15.377  1.00 34.18           C  
ATOM    542  C   ILE    78      15.061  -9.169  16.864  1.00 34.62           C  
ATOM    543  O   ILE    78      16.054  -9.721  17.287  1.00 34.47           O  
ATOM    544  CB  ILE    78      14.535  -9.826  14.318  1.00 33.81           C  
ATOM    545  CG1 ILE    78      13.138 -10.355  14.634  1.00 32.87           C  
ATOM    546  CG2 ILE    78      15.569 -10.982  14.211  1.00 31.11           C  
ATOM    547  CD1 ILE    78      12.031  -9.303  14.448  1.00 29.85           C  
ATOM    548  N   VAL    79      14.017  -8.921  17.655  1.00 32.69           N  
ATOM    549  CA  VAL    79      13.972  -9.370  19.046  1.00 33.62           C  
ATOM    550  C   VAL    79      12.967 -10.495  19.058  1.00 33.60           C  
ATOM    551  O   VAL    79      11.792 -10.239  18.739  1.00 33.36           O  
ATOM    552  CB  VAL    79      13.518  -8.218  19.996  1.00 34.49           C  
ATOM    553  CG1 VAL    79      13.462  -8.703  21.467  1.00 35.62           C  
ATOM    554  CG2 VAL    79      14.427  -6.975  19.840  1.00 30.87           C  
ATOM    555  N   CYS    80      13.411 -11.721  19.355  1.00 34.05           N  
ATOM    556  CA  CYS    80      12.533 -12.854  19.471  1.00 34.02           C  
ATOM    557  C   CYS    80      11.430 -12.582  20.492  1.00 33.64           C  
ATOM    558  O   CYS    80      11.698 -12.131  21.600  1.00 32.90           O  
ATOM    559  CB  CYS    80      13.294 -14.109  19.911  1.00 34.77           C  
ATOM    560  SG  CYS    80      12.168 -15.548  19.926  1.00 35.45           S  
ATOM    561  N   PRO    81      10.148 -12.867  20.137  1.00 34.47           N  
ATOM    562  CA  PRO    81       9.161 -12.521  21.164  1.00 33.40           C  
ATOM    563  C   PRO    81       9.158 -13.389  22.422  1.00 32.58           C  
ATOM    564  O   PRO    81       8.508 -12.988  23.398  1.00 32.43           O  
ATOM    565  CB  PRO    81       7.805 -12.649  20.450  1.00 33.95           C  
ATOM    566  CG  PRO    81       8.086 -13.625  19.318  1.00 33.95           C  
ATOM    567  CD  PRO    81       9.559 -13.452  18.920  1.00 33.50           C  
ATOM    568  N   TRP    82       9.802 -14.554  22.398  1.00 32.23           N  
ATOM    569  CA  TRP    82       9.754 -15.550  23.533  1.00 31.38           C  
ATOM    570  C   TRP    82      10.749 -15.130  24.528  1.00 30.48           C  
ATOM    571  O   TRP    82      10.362 -14.756  25.596  1.00 29.33           O  
ATOM    572  CB  TRP    82       9.982 -16.993  23.023  1.00 32.45           C  
ATOM    573  CG  TRP    82       8.799 -17.617  22.294  1.00 34.89           C  
ATOM    574  CD1 TRP    82       7.596 -17.007  21.998  1.00 36.46           C  
ATOM    575  CD2 TRP    82       8.669 -18.981  21.835  1.00 35.91           C  
ATOM    576  NE1 TRP    82       6.751 -17.904  21.374  1.00 34.16           N  
ATOM    577  CE2 TRP    82       7.387 -19.107  21.242  1.00 35.08           C  
ATOM    578  CE3 TRP    82       9.521 -20.105  21.855  1.00 36.77           C  
ATOM    579  CZ2 TRP    82       6.925 -20.325  20.657  1.00 37.12           C  
ATOM    580  CZ3 TRP    82       9.077 -21.308  21.279  1.00 35.69           C  
ATOM    581  CH2 TRP    82       7.782 -21.405  20.693  1.00 37.21           C  
ATOM    582  N   HIS    83      12.068 -15.103  24.216  1.00 30.38           N  
ATOM    583  CA  HIS    83      12.919 -14.743  25.348  1.00 29.88           C  
ATOM    584  C   HIS    83      13.741 -13.485  25.057  1.00 31.78           C  
ATOM    585  O   HIS    83      14.746 -13.232  25.722  1.00 31.83           O  
ATOM    586  CB  HIS    83      13.781 -15.895  25.841  1.00 31.04           C  
ATOM    587  CG  HIS    83      13.026 -17.192  25.969  1.00 31.61           C  
ATOM    588  ND1 HIS    83      12.949 -18.098  24.940  1.00 32.84           N  
ATOM    589  CD2 HIS    83      12.222 -17.671  26.946  1.00 34.43           C  
ATOM    590  CE1 HIS    83      12.170 -19.111  25.295  1.00 32.77           C  
ATOM    591  NE2 HIS    83      11.701 -18.859  26.499  1.00 34.54           N  
ATOM    592  N   LYS    84      13.272 -12.695  24.087  1.00 31.89           N  
ATOM    593  CA  LYS    84      13.801 -11.347  23.806  1.00 31.70           C  
ATOM    594  C   LYS    84      15.293 -11.389  23.412  1.00 33.14           C  
ATOM    595  O   LYS    84      15.999 -10.409  23.572  1.00 32.10           O  
ATOM    596  CB  LYS    84      13.572 -10.417  24.989  1.00 31.06           C  
ATOM    597  CG  LYS    84      12.064 -10.399  25.517  1.00 30.64           C  
ATOM    598  CD  LYS    84      11.050 -10.263  24.434  1.00 32.36           C  
ATOM    599  CE  LYS    84       9.644  -9.933  25.085  1.00 38.66           C  
ATOM    600  NZ  LYS    84       8.482 -10.388  24.213  1.00 42.06           N  
ATOM    601  N   TYR    85      15.749 -12.497  22.829  1.00 33.63           N  
ATOM    602  CA  TYR    85      17.115 -12.501  22.289  1.00 34.59           C  
ATOM    603  C   TYR    85      17.175 -11.542  21.081  1.00 35.22           C  
ATOM    604  O   TYR    85      16.204 -11.416  20.329  1.00 34.27           O  
ATOM    605  CB  TYR    85      17.601 -13.871  21.873  1.00 34.05           C  
ATOM    606  CG  TYR    85      18.069 -14.735  23.013  1.00 33.39           C  
ATOM    607  CD1 TYR    85      17.518 -14.603  24.318  1.00 33.28           C  
ATOM    608  CD2 TYR    85      19.020 -15.705  22.782  1.00 33.67           C  
ATOM    609  CE1 TYR    85      17.960 -15.396  25.370  1.00 32.12           C  
ATOM    610  CE2 TYR    85      19.448 -16.533  23.802  1.00 36.57           C  
ATOM    611  CZ  TYR    85      18.910 -16.370  25.089  1.00 35.84           C  
ATOM    612  OH  TYR    85      19.383 -17.144  26.067  1.00 31.52           O  
ATOM    613  N   LYS    86      18.305 -10.876  20.931  1.00 34.93           N  
ATOM    614  CA  LYS    86      18.469  -9.853  19.904  1.00 36.39           C  
ATOM    615  C   LYS    86      19.354 -10.424  18.841  1.00 36.21           C  
ATOM    616  O   LYS    86      20.454 -10.888  19.121  1.00 35.92           O  
ATOM    617  CB  LYS    86      19.109  -8.620  20.483  1.00 36.57           C  
ATOM    618  CG  LYS    86      18.377  -8.041  21.744  1.00 38.21           C  
ATOM    619  CD  LYS    86      19.382  -6.992  22.306  1.00 41.31           C  
ATOM    620  CE  LYS    86      18.733  -6.100  23.324  1.00 46.04           C  
ATOM    621  NZ  LYS    86      18.598  -6.744  24.662  1.00 46.41           N  
ATOM    622  N   ILE    87      18.849 -10.420  17.612  1.00 35.80           N  
ATOM    623  CA  ILE    87      19.600 -10.980  16.491  1.00 34.37           C  
ATOM    624  C   ILE    87      19.777  -9.927  15.419  1.00 35.24           C  
ATOM    625  O   ILE    87      18.772  -9.368  14.953  1.00 33.39           O  
ATOM    626  CB  ILE    87      18.816 -12.178  15.906  1.00 35.19           C  
ATOM    627  CG1 ILE    87      18.756 -13.254  17.013  1.00 32.85           C  
ATOM    628  CG2 ILE    87      19.485 -12.672  14.587  1.00 32.28           C  
ATOM    629  CD1 ILE    87      17.647 -14.305  16.840  1.00 33.74           C  
ATOM    630  N   THR    88      21.023  -9.680  15.000  1.00 32.82           N  
ATOM    631  CA  THR    88      21.230  -8.635  13.996  1.00 34.57           C  
ATOM    632  C   THR    88      20.607  -9.068  12.656  1.00 34.38           C  
ATOM    633  O   THR    88      20.650 -10.224  12.304  1.00 34.53           O  
ATOM    634  CB  THR    88      22.724  -8.301  13.763  1.00 34.35           C  
ATOM    635  OG1 THR    88      23.409  -9.475  13.340  1.00 35.21           O  
ATOM    636  CG2 THR    88      23.392  -7.774  15.039  1.00 33.63           C  
ATOM    637  N   LEU    89      19.976  -8.125  11.981  1.00 34.00           N  
ATOM    638  CA  LEU    89      19.322  -8.356  10.695  1.00 35.35           C  
ATOM    639  C   LEU    89      20.380  -8.672   9.650  1.00 35.40           C  
ATOM    640  O   LEU    89      20.181  -9.579   8.837  1.00 36.23           O  
ATOM    641  CB  LEU    89      18.529  -7.081  10.287  1.00 33.99           C  
ATOM    642  CG  LEU    89      17.230  -6.790  11.094  1.00 32.97           C  
ATOM    643  CD1 LEU    89      16.426  -5.700  10.357  1.00 31.94           C  
ATOM    644  CD2 LEU    89      16.393  -8.003  11.336  1.00 30.27           C  
ATOM    645  N   ALA    90      21.509  -7.975   9.727  1.00 34.20           N  
ATOM    646  CA  ALA    90      22.519  -8.019   8.678  1.00 36.25           C  
ATOM    647  C   ALA    90      23.387  -9.263   8.793  1.00 36.66           C  
ATOM    648  O   ALA    90      23.758  -9.810   7.776  1.00 36.43           O  
ATOM    649  CB  ALA    90      23.415  -6.759   8.683  1.00 35.66           C  
ATOM    650  N   THR    91      23.685  -9.717  10.027  1.00 34.82           N  
ATOM    651  CA  THR    91      24.589 -10.858  10.183  1.00 35.01           C  
ATOM    652  C   THR    91      24.116 -12.087  10.991  1.00 35.56           C  
ATOM    653  O   THR    91      24.853 -13.077  11.052  1.00 36.37           O  
ATOM    654  CB  THR    91      25.960 -10.390  10.761  1.00 34.11           C  
ATOM    655  OG1 THR    91      25.737  -9.613  11.957  1.00 35.18           O  
ATOM    656  CG2 THR    91      26.699  -9.568   9.732  1.00 33.96           C  
ATOM    657  N   GLY    92      22.938 -12.026  11.618  1.00 33.49           N  
ATOM    658  CA  GLY    92      22.460 -13.150  12.383  1.00 34.48           C  
ATOM    659  C   GLY    92      23.227 -13.354  13.680  1.00 35.00           C  
ATOM    660  O   GLY    92      23.222 -14.444  14.230  1.00 34.54           O  
ATOM    661  N   GLU    93      23.805 -12.274  14.204  1.00 35.53           N  
ATOM    662  CA  GLU    93      24.569 -12.353  15.436  1.00 36.08           C  
ATOM    663  C   GLU    93      23.607 -12.161  16.603  1.00 37.33           C  
ATOM    664  O   GLU    93      22.883 -11.187  16.639  1.00 34.20           O  
ATOM    665  CB  GLU    93      25.642 -11.255  15.497  1.00 35.02           C  
ATOM    666  CG  GLU    93      26.854 -11.393  14.533  1.00 31.69           C  
ATOM    667  CD  GLU    93      27.731 -10.176  14.562  1.00 34.65           C  
ATOM    668  OE1 GLU    93      28.431  -9.935  15.578  1.00 37.63           O  
ATOM    669  OE2 GLU    93      27.761  -9.438  13.567  1.00 33.35           O  
ATOM    670  N   GLY    94      23.689 -13.064  17.584  1.00 39.26           N  
ATOM    671  CA  GLY    94      23.199 -12.833  18.957  1.00 39.94           C  
ATOM    672  C   GLY    94      23.965 -11.705  19.616  1.00 40.96           C  
ATOM    673  O   GLY    94      25.195 -11.754  19.743  1.00 41.85           O  
ATOM    674  N   LEU    95      23.262 -10.662  20.036  1.00 41.80           N  
ATOM    675  CA  LEU    95      23.912  -9.522  20.705  1.00 43.32           C  
ATOM    676  C   LEU    95      23.481  -9.430  22.157  1.00 44.62           C  
ATOM    677  O   LEU    95      22.305  -9.712  22.518  1.00 44.46           O  
ATOM    678  CB  LEU    95      23.514  -8.202  20.035  1.00 43.50           C  
ATOM    679  CG  LEU    95      23.999  -7.851  18.663  1.00 43.89           C  
ATOM    680  CD1 LEU    95      23.548  -6.420  18.448  1.00 42.62           C  
ATOM    681  CD2 LEU    95      25.548  -7.911  18.639  1.00 46.24           C  
ATOM    682  N   TYR    96      24.422  -9.008  22.993  1.00 45.03           N  
ATOM    683  CA  TYR    96      24.140  -8.751  24.398  1.00 45.51           C  
ATOM    684  C   TYR    96      25.061  -7.662  24.986  1.00 45.91           C  
ATOM    685  O   TYR    96      26.169  -7.340  24.467  1.00 45.16           O  
ATOM    686  CB  TYR    96      24.236 -10.057  25.240  1.00 45.83           C  
ATOM    687  CG  TYR    96      25.604 -10.654  25.208  1.00 44.27           C  
ATOM    688  CD1 TYR    96      26.031 -11.370  24.071  1.00 50.00           C  
ATOM    689  CD2 TYR    96      26.502 -10.491  26.263  1.00 46.02           C  
ATOM    690  CE1 TYR    96      27.349 -11.916  23.981  1.00 47.47           C  
ATOM    691  CE2 TYR    96      27.839 -11.074  26.200  1.00 46.29           C  
ATOM    692  CZ  TYR    96      28.231 -11.777  25.050  1.00 44.35           C  
ATOM    693  OH  TYR    96      29.492 -12.321  24.908  1.00 45.24           O  
ATOM    694  N   GLN    97      24.585  -7.086  26.087  1.00 46.30           N  
ATOM    695  CA  GLN    97      25.427  -6.235  26.908  1.00 46.58           C  
ATOM    696  C   GLN    97      26.028  -7.040  28.046  1.00 45.88           C  
ATOM    697  O   GLN    97      25.322  -7.760  28.753  1.00 44.56           O  
ATOM    698  CB  GLN    97      24.642  -5.078  27.499  1.00 47.22           C  
ATOM    699  CG  GLN    97      24.144  -4.011  26.589  1.00 48.64           C  
ATOM    700  CD  GLN    97      23.318  -3.005  27.411  1.00 52.59           C  
ATOM    701  OE1 GLN    97      23.868  -2.091  28.035  1.00 53.02           O  
ATOM    702  NE2 GLN    97      22.001  -3.214  27.457  1.00 51.22           N  
ATOM    703  N   SER    98      27.332  -6.892  28.210  1.00 45.90           N  
ATOM    704  CA  SER    98      28.032  -7.433  29.337  1.00 47.24           C  
ATOM    705  C   SER    98      28.166  -6.335  30.376  1.00 49.34           C  
ATOM    706  O   SER    98      28.757  -5.280  30.106  1.00 49.89           O  
ATOM    707  CB  SER    98      29.421  -7.930  28.921  1.00 47.10           C  
ATOM    708  OG  SER    98      30.102  -8.443  30.055  1.00 45.34           O  
ATOM    709  N   ILE    99      27.643  -6.611  31.572  1.00 51.39           N  
ATOM    710  CA  ILE    99      27.521  -5.639  32.677  1.00 52.93           C  
ATOM    711  C   ILE    99      28.393  -6.106  33.858  1.00 54.29           C  
ATOM    712  O   ILE    99      28.399  -7.298  34.199  1.00 54.71           O  
ATOM    713  CB  ILE    99      26.001  -5.470  33.104  1.00 52.30           C  
ATOM    714  CG1 ILE    99      25.131  -5.046  31.911  1.00 51.54           C  
ATOM    715  CG2 ILE    99      25.821  -4.493  34.288  1.00 53.70           C  
ATOM    716  CD1 ILE    99      23.807  -5.799  31.805  1.00 46.37           C  
ATOM    717  N   ASN   100      29.145  -5.184  34.459  1.00 55.52           N  
ATOM    718  CA  ASN   100      29.915  -5.522  35.654  1.00 56.83           C  
ATOM    719  C   ASN   100      29.368  -4.911  36.948  1.00 57.31           C  
ATOM    720  O   ASN   100      29.767  -3.798  37.320  1.00 57.84           O  
ATOM    721  CB  ASN   100      31.395  -5.180  35.492  1.00 57.18           C  
ATOM    722  CG  ASN   100      32.279  -5.978  36.445  1.00 58.52           C  
ATOM    723  OD1 ASN   100      32.301  -5.729  37.666  1.00 55.73           O  
ATOM    724  ND2 ASN   100      32.999  -6.966  35.887  1.00 59.65           N  
ATOM    725  N   PRO   101      28.505  -5.669  37.671  1.00 57.70           N  
ATOM    726  CA  PRO   101      27.715  -5.252  38.861  1.00 57.67           C  
ATOM    727  C   PRO   101      28.494  -4.456  39.916  1.00 57.26           C  
ATOM    728  O   PRO   101      29.706  -4.632  40.048  1.00 57.24           O  
ATOM    729  CB  PRO   101      27.268  -6.589  39.470  1.00 57.78           C  
ATOM    730  CG  PRO   101      28.071  -7.663  38.736  1.00 57.63           C  
ATOM    731  CD  PRO   101      28.294  -7.099  37.376  1.00 57.45           C  
ATOM    732  N   LYS   107      29.692   1.272  32.920  1.00 52.92           N  
ATOM    733  CA  LYS   107      29.148   1.413  31.570  1.00 53.38           C  
ATOM    734  C   LYS   107      29.016   0.059  30.807  1.00 53.00           C  
ATOM    735  O   LYS   107      30.028  -0.555  30.445  1.00 53.19           O  
ATOM    736  CB  LYS   107      30.007   2.402  30.785  1.00 53.22           C  
ATOM    737  CG  LYS   107      29.300   3.062  29.608  1.00 54.17           C  
ATOM    738  CD  LYS   107      30.302   3.782  28.676  1.00 54.72           C  
ATOM    739  CE  LYS   107      30.830   2.874  27.551  1.00 56.01           C  
ATOM    740  NZ  LYS   107      29.758   2.104  26.827  1.00 56.35           N  
ATOM    741  N   PRO   108      27.766  -0.424  30.589  1.00 52.64           N  
ATOM    742  CA  PRO   108      27.527  -1.639  29.776  1.00 52.07           C  
ATOM    743  C   PRO   108      28.149  -1.649  28.357  1.00 51.06           C  
ATOM    744  O   PRO   108      28.077  -0.662  27.610  1.00 51.00           O  
ATOM    745  CB  PRO   108      25.986  -1.740  29.709  1.00 52.11           C  
ATOM    746  CG  PRO   108      25.470  -0.398  30.166  1.00 52.53           C  
ATOM    747  CD  PRO   108      26.501   0.106  31.141  1.00 52.95           C  
ATOM    748  N   LYS   109      28.747  -2.780  28.007  1.00 49.63           N  
ATOM    749  CA  LYS   109      29.417  -2.927  26.728  1.00 48.39           C  
ATOM    750  C   LYS   109      28.752  -4.014  25.903  1.00 47.32           C  
ATOM    751  O   LYS   109      28.409  -5.079  26.408  1.00 46.47           O  
ATOM    752  CB  LYS   109      30.908  -3.231  26.929  1.00 48.48           C  
ATOM    753  CG  LYS   109      31.675  -2.169  27.706  1.00 48.27           C  
ATOM    754  CD  LYS   109      32.101  -0.976  26.816  1.00 48.40           C  
ATOM    755  CE  LYS   109      32.829   0.130  27.608  1.00 48.03           C  
ATOM    756  NZ  LYS   109      34.057  -0.306  28.331  1.00 48.01           N  
ATOM    757  N   TRP   110      28.577  -3.715  24.624  1.00 46.18           N  
ATOM    758  CA  TRP   110      27.922  -4.607  23.689  1.00 45.75           C  
ATOM    759  C   TRP   110      28.888  -5.683  23.197  1.00 44.56           C  
ATOM    760  O   TRP   110      30.046  -5.391  22.911  1.00 42.89           O  
ATOM    761  CB  TRP   110      27.375  -3.803  22.515  1.00 45.61           C  
ATOM    762  CG  TRP   110      26.203  -3.031  22.904  1.00 46.40           C  
ATOM    763  CD1 TRP   110      26.153  -1.699  23.258  1.00 45.90           C  
ATOM    764  CD2 TRP   110      24.869  -3.540  23.026  1.00 45.33           C  
ATOM    765  NE1 TRP   110      24.843  -1.349  23.573  1.00 45.91           N  
ATOM    766  CE2 TRP   110      24.038  -2.454  23.441  1.00 46.03           C  
ATOM    767  CE3 TRP   110      24.291  -4.803  22.822  1.00 45.31           C  
ATOM    768  CZ2 TRP   110      22.634  -2.600  23.654  1.00 46.18           C  
ATOM    769  CZ3 TRP   110      22.872  -4.949  23.031  1.00 46.50           C  
ATOM    770  CH2 TRP   110      22.082  -3.853  23.464  1.00 44.84           C  
ATOM    771  N   CYS   111      28.361  -6.904  23.104  1.00 43.73           N  
ATOM    772  CA  CYS   111      29.114  -8.133  22.804  1.00 43.51           C  
ATOM    773  C   CYS   111      28.372  -9.074  21.871  1.00 42.24           C  
ATOM    774  O   CYS   111      27.149  -9.058  21.816  1.00 41.79           O  
ATOM    775  CB  CYS   111      29.376  -8.905  24.099  1.00 43.86           C  
ATOM    776  SG  CYS   111      30.478  -8.046  25.204  1.00 46.60           S  
ATOM    777  N   SER   112      29.104  -9.937  21.181  1.00 40.36           N  
ATOM    778  CA  SER   112      28.489 -10.890  20.233  1.00 38.78           C  
ATOM    779  C   SER   112      29.045 -12.287  20.444  1.00 38.54           C  
ATOM    780  O   SER   112      30.236 -12.465  20.784  1.00 37.11           O  
ATOM    781  CB  SER   112      28.784 -10.442  18.777  1.00 38.60           C  
ATOM    782  OG  SER   112      28.526 -11.474  17.829  1.00 36.33           O  
ATOM    783  N   LYS   113      28.240 -13.294  20.134  1.00 39.27           N  
ATOM    784  CA  LYS   113      28.809 -14.664  20.073  1.00 39.20           C  
ATOM    785  C   LYS   113      28.966 -15.206  18.665  1.00 37.38           C  
ATOM    786  O   LYS   113      29.110 -16.411  18.469  1.00 37.70           O  
ATOM    787  CB  LYS   113      27.989 -15.639  20.921  1.00 42.14           C  
ATOM    788  CG  LYS   113      28.737 -16.266  22.147  1.00 43.01           C  
ATOM    789  CD  LYS   113      27.629 -16.659  23.119  1.00 49.68           C  
ATOM    790  CE  LYS   113      28.098 -16.891  24.541  1.00 52.37           C  
ATOM    791  NZ  LYS   113      26.895 -17.361  25.347  1.00 52.14           N  
ATOM    792  N   GLY   114      29.001 -14.319  17.685  1.00 35.65           N  
ATOM    793  CA  GLY   114      29.233 -14.768  16.320  1.00 33.82           C  
ATOM    794  C   GLY   114      27.873 -15.014  15.692  1.00 33.37           C  
ATOM    795  O   GLY   114      26.853 -14.701  16.302  1.00 33.36           O  
ATOM    796  N   VAL   115      27.846 -15.649  14.525  1.00 32.79           N  
ATOM    797  CA  VAL   115      26.561 -15.900  13.774  1.00 33.84           C  
ATOM    798  C   VAL   115      25.799 -17.031  14.496  1.00 34.57           C  
ATOM    799  O   VAL   115      26.361 -18.137  14.767  1.00 34.43           O  
ATOM    800  CB  VAL   115      26.845 -16.293  12.300  1.00 33.90           C  
ATOM    801  CG1 VAL   115      25.555 -16.622  11.522  1.00 31.20           C  
ATOM    802  CG2 VAL   115      27.703 -15.199  11.551  1.00 33.60           C  
ATOM    803  N   LYS   116      24.574 -16.720  14.899  1.00 33.94           N  
ATOM    804  CA  LYS   116      23.689 -17.683  15.526  1.00 34.60           C  
ATOM    805  C   LYS   116      22.534 -18.002  14.584  1.00 36.35           C  
ATOM    806  O   LYS   116      22.037 -19.147  14.525  1.00 36.12           O  
ATOM    807  CB  LYS   116      23.137 -17.076  16.830  1.00 34.93           C  
ATOM    808  CG  LYS   116      24.158 -16.962  17.967  1.00 36.71           C  
ATOM    809  CD  LYS   116      24.828 -18.295  18.150  1.00 37.08           C  
ATOM    810  CE  LYS   116      25.508 -18.443  19.482  1.00 39.69           C  
ATOM    811  NZ  LYS   116      25.820 -19.872  19.666  1.00 39.79           N  
ATOM    812  N   GLN   117      22.067 -16.972  13.876  1.00 36.23           N  
ATOM    813  CA  GLN   117      20.877 -17.109  13.025  1.00 37.34           C  
ATOM    814  C   GLN   117      21.271 -17.048  11.555  1.00 37.69           C  
ATOM    815  O   GLN   117      21.845 -16.036  11.090  1.00 37.71           O  
ATOM    816  CB  GLN   117      19.869 -15.988  13.312  1.00 36.96           C  
ATOM    817  CG  GLN   117      18.463 -16.279  12.769  1.00 36.32           C  
ATOM    818  CD  GLN   117      17.735 -17.310  13.592  1.00 35.64           C  
ATOM    819  OE1 GLN   117      18.100 -17.589  14.764  1.00 33.21           O  
ATOM    820  NE2 GLN   117      16.695 -17.910  12.990  1.00 32.46           N  
ATOM    821  N   ARG   118      20.991 -18.126  10.825  1.00 37.71           N  
ATOM    822  CA  ARG   118      21.418 -18.190   9.418  1.00 37.98           C  
ATOM    823  C   ARG   118      20.741 -17.092   8.573  1.00 37.27           C  
ATOM    824  O   ARG   118      19.476 -17.000   8.499  1.00 37.04           O  
ATOM    825  CB  ARG   118      21.179 -19.576   8.789  1.00 38.02           C  
ATOM    826  CG  ARG   118      21.819 -19.735   7.378  1.00 39.40           C  
ATOM    827  CD  ARG   118      21.777 -21.175   6.875  1.00 38.52           C  
ATOM    828  NE  ARG   118      22.687 -22.033   7.665  1.00 38.06           N  
ATOM    829  CZ  ARG   118      24.022 -22.129   7.515  1.00 37.93           C  
ATOM    830  NH1 ARG   118      24.691 -21.440   6.593  1.00 34.56           N  
ATOM    831  NH2 ARG   118      24.703 -22.923   8.333  1.00 38.47           N  
ATOM    832  N   ILE   119      21.582 -16.256   7.956  1.00 36.09           N  
ATOM    833  CA  ILE   119      21.119 -15.156   7.094  1.00 36.00           C  
ATOM    834  C   ILE   119      21.166 -15.659   5.666  1.00 36.74           C  
ATOM    835  O   ILE   119      22.181 -16.133   5.235  1.00 36.50           O  
ATOM    836  CB  ILE   119      22.024 -13.877   7.212  1.00 35.96           C  
ATOM    837  CG1 ILE   119      22.022 -13.307   8.650  1.00 34.90           C  
ATOM    838  CG2 ILE   119      21.682 -12.825   6.125  1.00 35.15           C  
ATOM    839  CD1 ILE   119      20.602 -12.885   9.187  1.00 30.88           C  
ATOM    840  N   HIS   120      20.053 -15.565   4.942  1.00 36.85           N  
ATOM    841  CA  HIS   120      20.040 -15.841   3.493  1.00 38.96           C  
ATOM    842  C   HIS   120      20.138 -14.559   2.630  1.00 39.25           C  
ATOM    843  O   HIS   120      20.005 -13.427   3.128  1.00 40.02           O  
ATOM    844  CB  HIS   120      18.777 -16.660   3.144  1.00 38.05           C  
ATOM    845  CG  HIS   120      18.561 -17.800   4.089  1.00 38.96           C  
ATOM    846  ND1 HIS   120      19.418 -18.878   4.150  1.00 36.58           N  
ATOM    847  CD2 HIS   120      17.627 -18.000   5.053  1.00 35.27           C  
ATOM    848  CE1 HIS   120      19.003 -19.709   5.090  1.00 38.50           C  
ATOM    849  NE2 HIS   120      17.934 -19.192   5.668  1.00 35.36           N  
ATOM    850  N   THR   121      20.333 -14.756   1.338  1.00 39.59           N  
ATOM    851  CA  THR   121      20.491 -13.659   0.402  1.00 40.27           C  
ATOM    852  C   THR   121      19.199 -13.159  -0.273  1.00 40.15           C  
ATOM    853  O   THR   121      18.438 -13.936  -0.858  1.00 39.80           O  
ATOM    854  CB  THR   121      21.500 -14.066  -0.671  1.00 40.22           C  
ATOM    855  OG1 THR   121      22.749 -14.397  -0.034  1.00 41.98           O  
ATOM    856  CG2 THR   121      21.706 -12.937  -1.682  1.00 41.72           C  
ATOM    857  N   VAL   122      19.007 -11.839  -0.253  1.00 41.00           N  
ATOM    858  CA  VAL   122      17.854 -11.203  -0.869  1.00 41.58           C  
ATOM    859  C   VAL   122      18.258 -10.178  -1.930  1.00 43.48           C  
ATOM    860  O   VAL   122      19.146  -9.338  -1.698  1.00 43.53           O  
ATOM    861  CB  VAL   122      16.981 -10.464   0.162  1.00 41.71           C  
ATOM    862  CG1 VAL   122      15.644 -10.073  -0.474  1.00 38.28           C  
ATOM    863  CG2 VAL   122      16.765 -11.303   1.363  1.00 40.94           C  
ATOM    864  N   LYS   123      17.587 -10.270  -3.081  1.00 44.58           N  
ATOM    865  CA  LYS   123      17.739  -9.350  -4.214  1.00 46.35           C  
ATOM    866  C   LYS   123      16.342  -8.962  -4.683  1.00 46.16           C  
ATOM    867  O   LYS   123      15.405  -9.785  -4.628  1.00 46.09           O  
ATOM    868  CB  LYS   123      18.475 -10.028  -5.365  1.00 45.73           C  
ATOM    869  CG  LYS   123      19.758 -10.697  -4.915  1.00 49.43           C  
ATOM    870  CD  LYS   123      20.670 -11.185  -6.033  1.00 49.00           C  
ATOM    871  CE  LYS   123      21.765 -12.074  -5.411  1.00 53.31           C  
ATOM    872  NZ  LYS   123      23.006 -11.341  -5.004  1.00 54.10           N  
ATOM    873  N   VAL   124      16.198  -7.705  -5.112  1.00 46.40           N  
ATOM    874  CA  VAL   124      15.000  -7.293  -5.832  1.00 46.88           C  
ATOM    875  C   VAL   124      15.379  -7.052  -7.277  1.00 46.74           C  
ATOM    876  O   VAL   124      16.504  -6.635  -7.570  1.00 46.43           O  
ATOM    877  CB  VAL   124      14.232  -6.080  -5.185  1.00 47.39           C  
ATOM    878  CG1 VAL   124      13.900  -6.365  -3.711  1.00 46.38           C  
ATOM    879  CG2 VAL   124      15.003  -4.779  -5.323  1.00 48.38           C  
ATOM    880  N   ASP   125      14.456  -7.392  -8.164  1.00 46.24           N  
ATOM    881  CA  ASP   125      14.604  -7.198  -9.603  1.00 46.97           C  
ATOM    882  C   ASP   125      13.200  -7.131 -10.144  1.00 46.60           C  
ATOM    883  O   ASP   125      12.381  -8.010  -9.868  1.00 46.64           O  
ATOM    884  CB  ASP   125      15.365  -8.366 -10.243  1.00 47.02           C  
ATOM    885  CG  ASP   125      15.581  -8.179 -11.735  1.00 48.06           C  
ATOM    886  OD1 ASP   125      16.409  -7.324 -12.127  1.00 47.94           O  
ATOM    887  OD2 ASP   125      14.925  -8.901 -12.522  1.00 49.86           O  
ATOM    888  N   ASN   126      12.915  -6.066 -10.880  1.00 46.65           N  
ATOM    889  CA  ASN   126      11.595  -5.865 -11.459  1.00 46.94           C  
ATOM    890  C   ASN   126      10.482  -5.772 -10.414  1.00 46.29           C  
ATOM    891  O   ASN   126       9.341  -6.151 -10.691  1.00 46.38           O  
ATOM    892  CB  ASN   126      11.265  -6.996 -12.440  1.00 47.56           C  
ATOM    893  CG  ASN   126      11.881  -6.790 -13.785  1.00 48.66           C  
ATOM    894  OD1 ASN   126      13.106  -6.718 -13.920  1.00 51.64           O  
ATOM    895  ND2 ASN   126      11.040  -6.693 -14.802  1.00 48.83           N  
ATOM    896  N   GLY   127      10.816  -5.281  -9.221  1.00 45.49           N  
ATOM    897  CA  GLY   127       9.850  -5.254  -8.121  1.00 44.79           C  
ATOM    898  C   GLY   127       9.414  -6.632  -7.616  1.00 43.72           C  
ATOM    899  O   GLY   127       8.267  -6.769  -7.095  1.00 44.18           O  
ATOM    900  N   ASN   128      10.302  -7.652  -7.804  1.00 41.82           N  
ATOM    901  CA  ASN   128      10.065  -8.957  -7.237  1.00 40.23           C  
ATOM    902  C   ASN   128      11.127  -9.241  -6.198  1.00 40.41           C  
ATOM    903  O   ASN   128      12.298  -8.871  -6.378  1.00 39.02           O  
ATOM    904  CB  ASN   128      10.104 -10.042  -8.298  1.00 40.14           C  
ATOM    905  CG  ASN   128       8.857 -10.065  -9.183  1.00 40.64           C  
ATOM    906  OD1 ASN   128       7.774  -9.582  -8.797  1.00 42.50           O  
ATOM    907  ND2 ASN   128       9.001 -10.667 -10.368  1.00 35.86           N  
ATOM    908  N   ILE   129      10.736  -9.889  -5.104  1.00 39.25           N  
ATOM    909  CA  ILE   129      11.724 -10.264  -4.089  1.00 39.89           C  
ATOM    910  C   ILE   129      12.189 -11.689  -4.363  1.00 39.72           C  
ATOM    911  O   ILE   129      11.367 -12.580  -4.538  1.00 40.66           O  
ATOM    912  CB  ILE   129      11.177 -10.050  -2.666  1.00 40.15           C  
ATOM    913  CG1 ILE   129      10.646  -8.609  -2.563  1.00 39.73           C  
ATOM    914  CG2 ILE   129      12.289 -10.383  -1.574  1.00 38.54           C  
ATOM    915  CD1 ILE   129       9.946  -8.267  -1.304  1.00 41.42           C  
ATOM    916  N   TYR   130      13.505 -11.885  -4.456  1.00 39.44           N  
ATOM    917  CA  TYR   130      14.075 -13.199  -4.695  1.00 39.04           C  
ATOM    918  C   TYR   130      14.927 -13.622  -3.518  1.00 39.32           C  
ATOM    919  O   TYR   130      15.779 -12.858  -3.059  1.00 40.79           O  
ATOM    920  CB  TYR   130      14.921 -13.200  -5.984  1.00 38.38           C  
ATOM    921  CG  TYR   130      14.096 -13.000  -7.267  1.00 37.81           C  
ATOM    922  CD1 TYR   130      13.542 -14.087  -7.933  1.00 36.33           C  
ATOM    923  CD2 TYR   130      13.858 -11.725  -7.789  1.00 36.31           C  
ATOM    924  CE1 TYR   130      12.789 -13.923  -9.121  1.00 38.63           C  
ATOM    925  CE2 TYR   130      13.089 -11.540  -8.988  1.00 38.25           C  
ATOM    926  CZ  TYR   130      12.559 -12.647  -9.645  1.00 38.04           C  
ATOM    927  OH  TYR   130      11.771 -12.507 -10.806  1.00 40.74           O  
ATOM    928  N   VAL   131      14.753 -14.852  -3.063  1.00 38.99           N  
ATOM    929  CA  VAL   131      15.594 -15.364  -1.979  1.00 39.24           C  
ATOM    930  C   VAL   131      16.495 -16.532  -2.447  1.00 39.70           C  
ATOM    931  O   VAL   131      16.069 -17.417  -3.165  1.00 38.44           O  
ATOM    932  CB  VAL   131      14.755 -15.722  -0.681  1.00 40.15           C  
ATOM    933  CG1 VAL   131      15.672 -16.298   0.427  1.00 38.58           C  
ATOM    934  CG2 VAL   131      14.018 -14.500  -0.156  1.00 38.05           C  
ATOM    935  N   THR   132      17.747 -16.518  -2.008  1.00 40.04           N  
ATOM    936  CA  THR   132      18.662 -17.596  -2.286  1.00 40.59           C  
ATOM    937  C   THR   132      19.160 -18.076  -0.934  1.00 41.95           C  
ATOM    938  O   THR   132      19.635 -17.260  -0.131  1.00 42.01           O  
ATOM    939  CB  THR   132      19.816 -17.068  -3.200  1.00 40.85           C  
ATOM    940  OG1 THR   132      19.228 -16.494  -4.379  1.00 36.46           O  
ATOM    941  CG2 THR   132      20.793 -18.173  -3.591  1.00 40.09           C  
ATOM    942  N   LEU   133      19.006 -19.376  -0.646  1.00 43.00           N  
ATOM    943  CA  LEU   133      19.478 -19.932   0.642  1.00 43.84           C  
ATOM    944  C   LEU   133      21.003 -19.800   0.731  1.00 45.22           C  
ATOM    945  O   LEU   133      21.701 -19.944  -0.277  1.00 45.17           O  
ATOM    946  CB  LEU   133      19.037 -21.390   0.842  1.00 42.75           C  
ATOM    947  CG  LEU   133      17.561 -21.744   1.009  1.00 43.41           C  
ATOM    948  CD1 LEU   133      17.355 -23.248   1.217  1.00 40.34           C  
ATOM    949  CD2 LEU   133      16.914 -20.945   2.158  1.00 38.38           C  
ATOM    950  N   SER   134      21.518 -19.499   1.921  1.00 46.77           N  
ATOM    951  CA  SER   134      22.947 -19.315   2.087  1.00 48.93           C  
ATOM    952  C   SER   134      23.636 -20.617   2.454  1.00 50.30           C  
ATOM    953  O   SER   134      23.052 -21.430   3.178  1.00 50.76           O  
ATOM    954  CB  SER   134      23.217 -18.359   3.212  1.00 48.46           C  
ATOM    955  OG  SER   134      23.246 -19.084   4.431  1.00 51.29           O  
ATOM    956  N   LYS   135      24.888 -20.776   1.999  1.00 51.51           N  
ATOM    957  CA  LYS   135      25.747 -21.898   2.405  1.00 52.31           C  
ATOM    958  C   LYS   135      26.749 -21.454   3.469  1.00 53.22           C  
ATOM    959  O   LYS   135      27.278 -22.269   4.220  1.00 53.31           O  
ATOM    960  CB  LYS   135      26.517 -22.448   1.204  1.00 52.38           C  
ATOM    961  CG  LYS   135      25.832 -22.306  -0.127  1.00 52.11           C  
ATOM    962  CD  LYS   135      26.629 -23.075  -1.207  1.00 52.26           C  
ATOM    963  CE  LYS   135      26.349 -22.568  -2.623  1.00 51.66           C  
ATOM    964  NZ  LYS   135      27.234 -23.237  -3.657  1.00 51.02           N  
ATOM    965  N   GLU   136      27.006 -20.152   3.518  1.00 54.27           N  
ATOM    966  CA  GLU   136      27.956 -19.560   4.457  1.00 55.33           C  
ATOM    967  C   GLU   136      27.206 -19.019   5.694  1.00 55.09           C  
ATOM    968  O   GLU   136      26.128 -18.427   5.545  1.00 56.28           O  
ATOM    969  CB  GLU   136      28.719 -18.437   3.723  1.00 55.83           C  
ATOM    970  CG  GLU   136      29.997 -17.945   4.391  1.00 57.12           C  
ATOM    971  CD  GLU   136      31.278 -18.520   3.788  1.00 61.09           C  
ATOM    972  OE1 GLU   136      32.107 -19.071   4.568  1.00 61.63           O  
ATOM    973  OE2 GLU   136      31.476 -18.395   2.549  1.00 61.99           O  
ATOM    974  N   PRO   137      27.715 -19.267   6.936  1.00 55.06           N  
ATOM    975  CA  PRO   137      28.830 -20.105   7.419  1.00 54.23           C  
ATOM    976  C   PRO   137      28.458 -21.596   7.460  1.00 53.34           C  
ATOM    977  O   PRO   137      27.266 -21.937   7.390  1.00 53.31           O  
ATOM    978  CB  PRO   137      29.047 -19.593   8.848  1.00 53.86           C  
ATOM    979  CG  PRO   137      27.741 -19.181   9.281  1.00 54.97           C  
ATOM    980  CD  PRO   137      27.050 -18.585   8.071  1.00 54.57           C  
ATOM    981  N   PHE   138      29.459 -22.466   7.614  1.00 51.43           N  
ATOM    982  CA  PHE   138      29.223 -23.905   7.498  1.00 50.12           C  
ATOM    983  C   PHE   138      28.121 -24.426   8.435  1.00 48.87           C  
ATOM    984  O   PHE   138      27.243 -25.166   7.987  1.00 48.71           O  
ATOM    985  CB  PHE   138      30.543 -24.770   7.566  1.00 50.26           C  
ATOM    986  CG  PHE   138      30.222 -26.220   7.875  1.00 49.81           C  
ATOM    987  CD1 PHE   138      29.654 -27.076   6.745  1.00 51.49           C  
ATOM    988  CD2 PHE   138      30.384 -26.741   9.264  1.00 51.50           C  
ATOM    989  CE1 PHE   138      29.370 -28.414   7.051  1.00 51.29           C  
ATOM    990  CE2 PHE   138      30.105 -28.080   9.579  1.00 50.91           C  
ATOM    991  CZ  PHE   138      29.521 -28.922   8.458  1.00 51.61           C  
ATOM    992  N   LYS   139      28.144 -24.002   9.701  1.00 48.30           N  
ATOM    993  CA  LYS   139      27.051 -24.305  10.665  1.00 47.27           C  
ATOM    994  C   LYS   139      26.547 -23.108  11.510  1.00 45.92           C  
ATOM    995  O   LYS   139      27.349 -22.313  11.982  1.00 44.08           O  
ATOM    996  CB  LYS   139      27.496 -25.468  11.566  1.00 47.34           C  
ATOM    997  CG  LYS   139      26.480 -25.899  12.624  1.00 48.98           C  
ATOM    998  CD  LYS   139      27.075 -27.027  13.507  1.00 49.64           C  
ATOM    999  CE  LYS   139      26.266 -27.148  14.818  1.00 54.05           C  
ATOM   1000  NZ  LYS   139      26.806 -28.256  15.668  1.00 56.44           N  
ATOM   1001  N   CYS   140      25.210 -22.982  11.655  1.00 45.92           N  
ATOM   1002  CA  CYS   140      24.511 -22.004  12.540  1.00 46.22           C  
ATOM   1003  C   CYS   140      23.654 -22.698  13.584  1.00 45.35           C  
ATOM   1004  O   CYS   140      23.116 -23.767  13.310  1.00 46.60           O  
ATOM   1005  CB  CYS   140      23.596 -21.043  11.775  1.00 45.85           C  
ATOM   1006  SG  CYS   140      24.500 -20.055  10.567  1.00 48.91           S  
ATOM   1007  N   ASP   141      23.543 -22.117  14.776  1.00 44.08           N  
ATOM   1008  CA  ASP   141      22.661 -22.691  15.792  1.00 44.62           C  
ATOM   1009  C   ASP   141      21.209 -22.781  15.266  1.00 44.81           C  
ATOM   1010  O   ASP   141      20.514 -23.715  15.642  1.00 45.32           O  
ATOM   1011  CB  ASP   141      22.668 -21.877  17.082  1.00 44.12           C  
ATOM   1012  CG  ASP   141      23.859 -22.159  17.927  1.00 46.44           C  
ATOM   1013  OD1 ASP   141      24.743 -22.891  17.458  1.00 44.54           O  
ATOM   1014  OD2 ASP   141      23.923 -21.655  19.069  1.00 46.27           O  
ATOM   1015  N   SER   142      20.778 -21.871  14.383  1.00 43.14           N  
ATOM   1016  CA  SER   142      19.386 -21.945  13.855  1.00 44.31           C  
ATOM   1017  C   SER   142      19.056 -23.136  12.964  1.00 44.24           C  
ATOM   1018  O   SER   142      17.855 -23.430  12.753  1.00 44.10           O  
ATOM   1019  CB  SER   142      18.968 -20.672  13.109  1.00 42.51           C  
ATOM   1020  OG  SER   142      19.724 -20.520  11.920  1.00 44.57           O  
ATOM   1021  N   ASP   143      20.096 -23.789  12.422  1.00 45.06           N  
ATOM   1022  CA  ASP   143      19.920 -24.950  11.547  1.00 45.46           C  
ATOM   1023  C   ASP   143      19.147 -26.078  12.227  1.00 46.54           C  
ATOM   1024  O   ASP   143      18.376 -26.748  11.569  1.00 46.75           O  
ATOM   1025  CB  ASP   143      21.271 -25.513  11.043  1.00 45.66           C  
ATOM   1026  CG  ASP   143      22.036 -24.532  10.155  1.00 44.83           C  
ATOM   1027  OD1 ASP   143      21.419 -23.599   9.598  1.00 42.43           O  
ATOM   1028  OD2 ASP   143      23.265 -24.707  10.002  1.00 42.61           O  
ATOM   1029  N   TYR   144      19.381 -26.312  13.524  1.00 47.69           N  
ATOM   1030  CA  TYR   144      18.623 -27.347  14.256  1.00 48.61           C  
ATOM   1031  C   TYR   144      17.099 -27.159  14.128  1.00 48.69           C  
ATOM   1032  O   TYR   144      16.365 -28.135  13.991  1.00 47.78           O  
ATOM   1033  CB  TYR   144      18.997 -27.374  15.736  1.00 49.29           C  
ATOM   1034  CG  TYR   144      18.236 -28.431  16.549  1.00 50.70           C  
ATOM   1035  CD1 TYR   144      18.607 -29.785  16.506  1.00 52.62           C  
ATOM   1036  CD2 TYR   144      17.137 -28.072  17.355  1.00 50.86           C  
ATOM   1037  CE1 TYR   144      17.910 -30.757  17.256  1.00 53.14           C  
ATOM   1038  CE2 TYR   144      16.437 -29.036  18.096  1.00 50.65           C  
ATOM   1039  CZ  TYR   144      16.825 -30.359  18.054  1.00 51.92           C  
ATOM   1040  OH  TYR   144      16.129 -31.298  18.797  1.00 51.39           O  
ATOM   1041  N   TYR   145      16.644 -25.905  14.171  1.00 48.97           N  
ATOM   1042  CA  TYR   145      15.207 -25.585  14.134  1.00 49.21           C  
ATOM   1043  C   TYR   145      14.692 -25.435  12.713  1.00 49.99           C  
ATOM   1044  O   TYR   145      13.494 -25.243  12.506  1.00 50.05           O  
ATOM   1045  CB  TYR   145      14.899 -24.356  15.003  1.00 50.10           C  
ATOM   1046  CG  TYR   145      15.084 -24.675  16.463  1.00 49.20           C  
ATOM   1047  CD1 TYR   145      14.246 -25.591  17.080  1.00 50.84           C  
ATOM   1048  CD2 TYR   145      16.103 -24.109  17.212  1.00 45.52           C  
ATOM   1049  CE1 TYR   145      14.402 -25.937  18.406  1.00 51.72           C  
ATOM   1050  CE2 TYR   145      16.267 -24.456  18.567  1.00 47.36           C  
ATOM   1051  CZ  TYR   145      15.403 -25.363  19.144  1.00 50.04           C  
ATOM   1052  OH  TYR   145      15.524 -25.798  20.451  1.00 53.65           O  
ATOM   1053  N   ALA   146      15.602 -25.555  11.741  1.00 49.88           N  
ATOM   1054  CA  ALA   146      15.292 -25.302  10.345  1.00 50.90           C  
ATOM   1055  C   ALA   146      14.972 -26.581   9.602  1.00 52.22           C  
ATOM   1056  O   ALA   146      14.408 -26.522   8.507  1.00 52.25           O  
ATOM   1057  CB  ALA   146      16.440 -24.593   9.653  1.00 50.05           C  
ATOM   1058  N   THR   147      15.340 -27.724  10.190  1.00 53.87           N  
ATOM   1059  CA  THR   147      15.284 -29.020   9.494  1.00 54.91           C  
ATOM   1060  C   THR   147      14.885 -30.235  10.356  1.00 55.97           C  
ATOM   1061  O   THR   147      15.363 -30.403  11.483  1.00 55.90           O  
ATOM   1062  CB  THR   147      16.649 -29.340   8.805  1.00 55.15           C  
ATOM   1063  OG1 THR   147      17.733 -29.043   9.703  1.00 54.95           O  
ATOM   1064  CG2 THR   147      16.822 -28.514   7.524  1.00 55.67           C  
ATOM   1065  N   GLY   148      14.020 -31.085   9.788  1.00 57.03           N  
ATOM   1066  CA  GLY   148      13.682 -32.405  10.340  1.00 58.17           C  
ATOM   1067  C   GLY   148      12.993 -32.442  11.697  1.00 59.08           C  
ATOM   1068  O   GLY   148      12.159 -31.584  12.016  1.00 59.21           O  
ATOM   1069  N   GLU   149      13.354 -33.452  12.490  1.00 59.79           N  
ATOM   1070  CA  GLU   149      12.780 -33.700  13.825  1.00 60.24           C  
ATOM   1071  C   GLU   149      13.243 -32.700  14.895  1.00 60.72           C  
ATOM   1072  O   GLU   149      14.424 -32.708  15.283  1.00 61.14           O  
ATOM   1073  CB  GLU   149      13.135 -35.121  14.287  1.00 60.50           C  
ATOM   1074  CG  GLU   149      12.122 -36.220  13.932  1.00 60.05           C  
ATOM   1075  CD  GLU   149      11.038 -36.365  14.988  1.00 59.99           C  
ATOM   1076  OE1 GLU   149      10.594 -37.506  15.238  1.00 58.25           O  
ATOM   1077  OE2 GLU   149      10.638 -35.330  15.575  1.00 60.64           O  
ATOM   1078  N   PHE   150      12.312 -31.853  15.361  1.00 60.39           N  
ATOM   1079  CA  PHE   150      12.536 -30.943  16.513  1.00 60.35           C  
ATOM   1080  C   PHE   150      11.287 -30.683  17.391  1.00 59.56           C  
ATOM   1081  O   PHE   150      10.146 -30.940  16.985  1.00 59.84           O  
ATOM   1082  CB  PHE   150      13.215 -29.610  16.101  1.00 60.16           C  
ATOM   1083  CG  PHE   150      12.466 -28.833  15.057  1.00 61.05           C  
ATOM   1084  CD1 PHE   150      11.587 -27.820  15.425  1.00 62.70           C  
ATOM   1085  CD2 PHE   150      12.659 -29.093  13.697  1.00 62.07           C  
ATOM   1086  CE1 PHE   150      10.890 -27.086  14.451  1.00 62.87           C  
ATOM   1087  CE2 PHE   150      11.957 -28.387  12.708  1.00 63.06           C  
ATOM   1088  CZ  PHE   150      11.069 -27.377  13.087  1.00 63.13           C  
ATOM   1089  N   LYS   151      11.531 -30.222  18.613  1.00 58.08           N  
ATOM   1090  CA  LYS   151      10.482 -29.702  19.473  1.00 56.42           C  
ATOM   1091  C   LYS   151      10.831 -28.252  19.769  1.00 55.24           C  
ATOM   1092  O   LYS   151      12.015 -27.902  19.798  1.00 54.83           O  
ATOM   1093  CB  LYS   151      10.362 -30.540  20.750  1.00 57.09           C  
ATOM   1094  CG  LYS   151       9.370 -31.678  20.611  1.00 56.58           C  
ATOM   1095  CD  LYS   151       8.705 -31.985  21.949  1.00 59.54           C  
ATOM   1096  CE  LYS   151       7.414 -32.786  21.781  1.00 59.45           C  
ATOM   1097  NZ  LYS   151       6.864 -33.245  23.089  1.00 61.73           N  
ATOM   1098  N   VAL   152       9.824 -27.397  19.929  1.00 53.60           N  
ATOM   1099  CA  VAL   152      10.101 -25.999  20.303  1.00 53.08           C  
ATOM   1100  C   VAL   152       9.768 -25.697  21.790  1.00 52.22           C  
ATOM   1101  O   VAL   152       8.860 -26.281  22.367  1.00 51.30           O  
ATOM   1102  CB  VAL   152       9.599 -24.922  19.235  1.00 52.74           C  
ATOM   1103  CG1 VAL   152      10.068 -25.286  17.829  1.00 52.40           C  
ATOM   1104  CG2 VAL   152       8.128 -24.765  19.228  1.00 52.79           C  
ATOM   1105  N   ILE   153      10.568 -24.835  22.417  1.00 52.29           N  
ATOM   1106  CA  ILE   153      10.422 -24.558  23.848  1.00 52.31           C  
ATOM   1107  C   ILE   153      10.173 -23.064  24.121  1.00 51.77           C  
ATOM   1108  O   ILE   153      10.922 -22.204  23.637  1.00 51.74           O  
ATOM   1109  CB  ILE   153      11.666 -24.997  24.592  1.00 52.99           C  
ATOM   1110  CG1 ILE   153      11.771 -26.531  24.594  1.00 52.49           C  
ATOM   1111  CG2 ILE   153      11.651 -24.415  26.010  1.00 55.15           C  
ATOM   1112  CD1 ILE   153      13.034 -27.088  25.334  1.00 53.41           C  
ATOM   1113  N   GLN   154       9.086 -22.744  24.829  1.00 50.54           N  
ATOM   1114  CA  GLN   154       8.852 -21.355  25.219  1.00 49.09           C  
ATOM   1115  C   GLN   154       9.033 -21.316  26.726  1.00 48.53           C  
ATOM   1116  O   GLN   154       8.355 -22.092  27.425  1.00 47.25           O  
ATOM   1117  CB  GLN   154       7.471 -20.847  24.760  1.00 48.43           C  
ATOM   1118  CG  GLN   154       7.220 -19.364  25.065  1.00 49.16           C  
ATOM   1119  CD  GLN   154       5.802 -18.889  24.709  1.00 50.58           C  
ATOM   1120  OE1 GLN   154       4.958 -19.678  24.258  1.00 53.72           O  
ATOM   1121  NE2 GLN   154       5.535 -17.587  24.925  1.00 50.75           N  
END
