
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  100 ( 1482),  selected  100 , name 1whd_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 1whd_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      M       1           -
LGA    S     2_A      H       2           -
LGA    S     3_A      H       3           -
LGA    G     4_A      H       4           -
LGA    S     5_A      H       5           -
LGA    S     6_A      H       6           -
LGA    G     7_A      H       7           -
LGA    E     8_A      S       8           -
LGA    G     9_A      S       9           #
LGA    -       -      G      10           -
LGA    D    10_A      V      11          7.094
LGA    P    11_A      D      12          5.388
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    E    12_A      T      15          3.798
LGA    N    13_A      E      16          3.372
LGA    -       -      N      17           -
LGA    -       -      L      18           -
LGA    G    14_A      Y      19          3.480
LGA    -       -      F      20           -
LGA    -       -      Q      21           -
LGA    -       -      S      22           -
LGA    E    15_A      M      23          3.411
LGA    K    16_A      P      24          2.512
LGA    L    17_A      R      25          1.528
LGA    Q    18_A      S      26          0.866
LGA    I    19_A      I      27          0.430
LGA    T    20_A      R      28          1.919
LGA    I    21_A      F      29          2.287
LGA    R    22_A      T      30          0.671
LGA    R    23_A      A      31          1.245
LGA    G    24_A      E      32          0.659
LGA    K    25_A      E      33          4.095
LGA    D    26_A      G      34          5.619
LGA    G    27_A      D      35          1.319
LGA    F    28_A      L      36          1.419
LGA    G    29_A      G      37          1.370
LGA    F    30_A      F      38          1.857
LGA    T    31_A      T      39          1.683
LGA    I    32_A      L      40          1.456
LGA    C    33_A      R      41          2.543
LGA    C    34_A      G      42          1.510
LGA    D    35_A      N      43          1.270
LGA    S    36_A      A      44          1.171
LGA    P    37_A      P      45          2.096
LGA    V    38_A      V      46          1.374
LGA    R    39_A      Q      47          1.047
LGA    V    40_A      V      48          1.123
LGA    Q    41_A      H      49          0.894
LGA    A    42_A      F      50          1.661
LGA    V    43_A      L      51          0.842
LGA    D    44_A      D      52          0.685
LGA    S    45_A      P      53          2.416
LGA    G    46_A      Y      54          1.166
LGA    G    47_A      C      55          1.477
LGA    P    48_A      S      56          1.671
LGA    A    49_A      A      57          1.507
LGA    E    50_A      S      58          1.343
LGA    R    51_A      V      59          1.881
LGA    A    52_A      A      60          2.283
LGA    G    53_A      G      61          2.076
LGA    L    54_A      A      62          1.677
LGA    Q    55_A      R      63          1.246
LGA    Q    56_A      E      64          1.399
LGA    L    57_A      G      65          1.107
LGA    D    58_A      D      66          0.931
LGA    T    59_A      Y      67          1.210
LGA    V    60_A      I      68          1.334
LGA    L    61_A      V      69          1.396
LGA    Q    62_A      S      70          1.404
LGA    L    63_A      I      71          1.517
LGA    N    64_A      Q      72          1.434
LGA    E    65_A      L      73          1.833
LGA    R    66_A      V      74          1.676
LGA    P    67_A      D      75          1.195
LGA    V    68_A      C      76          1.060
LGA    E    69_A      K      77          0.888
LGA    H    70_A      W      78          0.758
LGA    W    71_A      L      79          0.555
LGA    K    72_A      T      80          0.671
LGA    C    73_A      L      81          0.703
LGA    V    74_A      S      82          0.846
LGA    E    75_A      E      83          1.230
LGA    L    76_A      V      84          1.110
LGA    A    77_A      M      85          1.114
LGA    H    78_A      K      86          1.403
LGA    E    79_A      L      87          1.220
LGA    I    80_A      L      88          1.051
LGA    R    81_A      K      89          1.142
LGA    S    82_A      S      90          1.404
LGA    C    83_A      F      91          0.911
LGA    P    84_A      G      92          0.667
LGA    S    85_A      E      93          2.090
LGA    E    86_A      D      94          3.413
LGA    -       -      E      95           -
LGA    I    87_A      I      96          1.209
LGA    I    88_A      E      97          1.151
LGA    L    89_A      M      98          1.131
LGA    L    90_A      K      99          0.554
LGA    V    91_A      V     100          0.776
LGA    W    92_A      V     101          1.172
LGA    R    93_A      S     102          2.822
LGA    V    94_A      L     103           #
LGA    S    95_A      L     104           -
LGA    G    96_A      -       -           -
LGA    P    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    S    99_A      -       -           -
LGA    G   100_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  100  104    5.0     84    2.02    19.05     73.214     3.966

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.009413 * X  +   0.987569 * Y  +  -0.156906 * Z  +  19.131975
  Y_new =  -0.523706 * X  +   0.138540 * Y  +   0.840558 * Z  +  26.851353
  Z_new =   0.851847 * X  +   0.074261 * Y  +   0.518500 * Z  +   9.243328 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.142255   -2.999338  [ DEG:     8.1506   -171.8494 ]
  Theta =  -1.019501   -2.122091  [ DEG:   -58.4131   -121.5869 ]
  Phi   =  -1.552825    1.588768  [ DEG:   -88.9703     91.0297 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1whd_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1whd_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  100  104   5.0   84   2.02   19.05  73.214
REMARK  ---------------------------------------------------------- 
MOLECULE 1whd_A
HEADER    SIGNALING PROTEIN                       28-MAY-04   1WHD              
TITLE     SOLUTION STRUCTURE OF THE PDZ DOMAIN OF RGS3                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: REGULATOR OF G-PROTEIN SIGNALING 3;                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ DOMAIN;                                                
COMPND   5 SYNONYM: RGS3;                                                       
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: RIKEN CDNA 4930506N09;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P030714-81;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    REGULATOR OF G-PROTEIN SIGNALING, PDZ DOMAIN, STRUCTURAL              
KEYWDS   2 GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   3 RSGI                                                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    T.NAKANISHI,N.NEMOTO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,           
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   28-NOV-04 1WHD    0                                                
JRNL        AUTH   T.NAKANISHI,N.NEMOTO,S.KOSHIBA,M.INOUE,T.KIGAWA,             
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE PDZ DOMAIN OF RGS3                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WHD A    8    94  UNP    Q9DC04   RGS3_MOUSE     185    271             
SEQRES   1 A  100  GLY SER SER GLY SER SER GLY GLU GLY ASP PRO GLU ASN          
SEQRES   2 A  100  GLY GLU LYS LEU GLN ILE THR ILE ARG ARG GLY LYS ASP          
SEQRES   3 A  100  GLY PHE GLY PHE THR ILE CYS CYS ASP SER PRO VAL ARG          
SEQRES   4 A  100  VAL GLN ALA VAL ASP SER GLY GLY PRO ALA GLU ARG ALA          
SEQRES   5 A  100  GLY LEU GLN GLN LEU ASP THR VAL LEU GLN LEU ASN GLU          
SEQRES   6 A  100  ARG PRO VAL GLU HIS TRP LYS CYS VAL GLU LEU ALA HIS          
SEQRES   7 A  100  GLU ILE ARG SER CYS PRO SER GLU ILE ILE LEU LEU VAL          
SEQRES   8 A  100  TRP ARG VAL SER GLY PRO SER SER GLY                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      14.126  48.010  43.574  1.00  0.00           N  
ATOM      2  CA  GLY A   1      14.330  46.574  43.559  1.00  0.00           C  
ATOM      3  C   GLY A   1      15.623  46.164  44.233  1.00  0.00           C  
ATOM      4  O   GLY A   1      16.648  45.991  43.573  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      13.504  46.098  44.068  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      14.349  46.234  42.533  1.00  0.00           H  
ATOM      7  H1  GLY A   1      13.996  48.476  44.426  1.00  0.00           H  
ATOM      8  N   SER A   2      15.579  46.010  45.553  1.00  0.00           N  
ATOM      9  CA  SER A   2      16.758  45.625  46.318  1.00  0.00           C  
ATOM     10  C   SER A   2      17.107  44.159  46.077  1.00  0.00           C  
ATOM     11  O   SER A   2      18.266  43.816  45.842  1.00  0.00           O  
ATOM     12  CB  SER A   2      16.525  45.866  47.811  1.00  0.00           C  
ATOM     13  OG  SER A   2      17.734  45.747  48.541  1.00  0.00           O  
ATOM     14  H   SER A   2      14.732  46.162  46.023  1.00  0.00           H  
ATOM     15  HA  SER A   2      17.583  46.238  45.987  1.00  0.00           H  
ATOM     16  HB2 SER A   2      16.128  46.858  47.955  1.00  0.00           H  
ATOM     17  HB3 SER A   2      15.820  45.137  48.184  1.00  0.00           H  
ATOM     18  HG  SER A   2      18.472  46.000  47.983  1.00  0.00           H  
ATOM     19  N   SER A   3      16.096  43.298  46.136  1.00  0.00           N  
ATOM     20  CA  SER A   3      16.295  41.869  45.928  1.00  0.00           C  
ATOM     21  C   SER A   3      15.366  41.345  44.837  1.00  0.00           C  
ATOM     22  O   SER A   3      14.307  40.789  45.121  1.00  0.00           O  
ATOM     23  CB  SER A   3      16.052  41.104  47.231  1.00  0.00           C  
ATOM     24  OG  SER A   3      16.831  39.921  47.280  1.00  0.00           O  
ATOM     25  H   SER A   3      15.194  43.633  46.327  1.00  0.00           H  
ATOM     26  HA  SER A   3      17.318  41.718  45.617  1.00  0.00           H  
ATOM     27  HB2 SER A   3      16.317  41.730  48.068  1.00  0.00           H  
ATOM     28  HB3 SER A   3      15.007  40.836  47.298  1.00  0.00           H  
ATOM     29  HG  SER A   3      16.424  39.294  47.882  1.00  0.00           H  
ATOM     30  N   GLY A   4      15.774  41.527  43.584  1.00  0.00           N  
ATOM     31  CA  GLY A   4      14.967  41.068  42.468  1.00  0.00           C  
ATOM     32  C   GLY A   4      14.442  42.211  41.622  1.00  0.00           C  
ATOM     33  O   GLY A   4      14.765  43.372  41.868  1.00  0.00           O  
ATOM     34  H   GLY A   4      16.628  41.977  43.416  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      15.569  40.420  41.846  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      14.130  40.504  42.852  1.00  0.00           H  
ATOM     37  N   SER A   5      13.631  41.881  40.622  1.00  0.00           N  
ATOM     38  CA  SER A   5      13.064  42.889  39.734  1.00  0.00           C  
ATOM     39  C   SER A   5      12.064  42.262  38.768  1.00  0.00           C  
ATOM     40  O   SER A   5      12.254  41.138  38.303  1.00  0.00           O  
ATOM     41  CB  SER A   5      14.175  43.591  38.950  1.00  0.00           C  
ATOM     42  OG  SER A   5      14.847  42.683  38.094  1.00  0.00           O  
ATOM     43  H   SER A   5      13.411  40.937  40.477  1.00  0.00           H  
ATOM     44  HA  SER A   5      12.551  43.617  40.344  1.00  0.00           H  
ATOM     45  HB2 SER A   5      13.746  44.380  38.352  1.00  0.00           H  
ATOM     46  HB3 SER A   5      14.890  44.011  39.642  1.00  0.00           H  
ATOM     47  HG  SER A   5      15.780  42.661  38.320  1.00  0.00           H  
ATOM     48  N   SER A   6      10.995  42.996  38.473  1.00  0.00           N  
ATOM     49  CA  SER A   6       9.962  42.511  37.567  1.00  0.00           C  
ATOM     50  C   SER A   6      10.511  42.351  36.152  1.00  0.00           C  
ATOM     51  O   SER A   6      11.514  42.963  35.790  1.00  0.00           O  
ATOM     52  CB  SER A   6       8.771  43.471  37.557  1.00  0.00           C  
ATOM     53  OG  SER A   6       7.587  42.812  37.142  1.00  0.00           O  
ATOM     54  H   SER A   6      10.900  43.884  38.876  1.00  0.00           H  
ATOM     55  HA  SER A   6       9.633  41.547  37.924  1.00  0.00           H  
ATOM     56  HB2 SER A   6       8.620  43.863  38.552  1.00  0.00           H  
ATOM     57  HB3 SER A   6       8.973  44.285  36.876  1.00  0.00           H  
ATOM     58  HG  SER A   6       7.215  43.268  36.384  1.00  0.00           H  
ATOM     59  N   GLY A   7       9.844  41.519  35.356  1.00  0.00           N  
ATOM     60  CA  GLY A   7      10.280  41.291  33.991  1.00  0.00           C  
ATOM     61  C   GLY A   7      11.311  40.184  33.887  1.00  0.00           C  
ATOM     62  O   GLY A   7      11.240  39.344  32.992  1.00  0.00           O  
ATOM     63  H   GLY A   7       9.051  41.056  35.699  1.00  0.00           H  
ATOM     64  HA2 GLY A   7       9.422  41.028  33.391  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      10.710  42.204  33.605  1.00  0.00           H  
ATOM     66  N   GLU A   8      12.271  40.184  34.807  1.00  0.00           N  
ATOM     67  CA  GLU A   8      13.322  39.174  34.813  1.00  0.00           C  
ATOM     68  C   GLU A   8      12.773  37.816  34.381  1.00  0.00           C  
ATOM     69  O   GLU A   8      13.392  37.109  33.587  1.00  0.00           O  
ATOM     70  CB  GLU A   8      13.947  39.064  36.204  1.00  0.00           C  
ATOM     71  CG  GLU A   8      14.953  37.933  36.332  1.00  0.00           C  
ATOM     72  CD  GLU A   8      14.293  36.569  36.396  1.00  0.00           C  
ATOM     73  OE1 GLU A   8      13.187  36.472  36.969  1.00  0.00           O  
ATOM     74  OE2 GLU A   8      14.881  35.600  35.873  1.00  0.00           O  
ATOM     75  H   GLU A   8      12.273  40.881  35.496  1.00  0.00           H  
ATOM     76  HA  GLU A   8      14.082  39.480  34.110  1.00  0.00           H  
ATOM     77  HB2 GLU A   8      14.449  39.992  36.435  1.00  0.00           H  
ATOM     78  HB3 GLU A   8      13.160  38.902  36.927  1.00  0.00           H  
ATOM     79  HG2 GLU A   8      15.614  37.956  35.479  1.00  0.00           H  
ATOM     80  HG3 GLU A   8      15.529  38.080  37.235  1.00  0.00           H  
ATOM     81  N   GLY A   9      11.608  37.460  34.912  1.00  0.00           N  
ATOM     82  CA  GLY A   9      10.995  36.189  34.571  1.00  0.00           C  
ATOM     83  C   GLY A   9      10.743  36.047  33.083  1.00  0.00           C  
ATOM     84  O   GLY A   9      11.058  36.947  32.304  1.00  0.00           O  
ATOM     85  H   GLY A   9      11.160  38.065  35.540  1.00  0.00           H  
ATOM     86  HA2 GLY A   9      11.646  35.390  34.894  1.00  0.00           H  
ATOM     87  HA3 GLY A   9      10.052  36.105  35.093  1.00  0.00           H  
ATOM     88  N   ASP A  10      10.177  34.912  32.686  1.00  0.00           N  
ATOM     89  CA  ASP A  10       9.884  34.655  31.281  1.00  0.00           C  
ATOM     90  C   ASP A  10      11.069  35.039  30.400  1.00  0.00           C  
ATOM     91  O   ASP A  10      10.942  35.808  29.448  1.00  0.00           O  
ATOM     92  CB  ASP A  10       8.639  35.429  30.847  1.00  0.00           C  
ATOM     93  CG  ASP A  10       7.932  34.779  29.674  1.00  0.00           C  
ATOM     94  OD1 ASP A  10       7.621  33.572  29.763  1.00  0.00           O  
ATOM     95  OD2 ASP A  10       7.690  35.476  28.667  1.00  0.00           O  
ATOM     96  H   ASP A  10       9.950  34.233  33.355  1.00  0.00           H  
ATOM     97  HA  ASP A  10       9.698  33.598  31.170  1.00  0.00           H  
ATOM     98  HB2 ASP A  10       7.948  35.479  31.677  1.00  0.00           H  
ATOM     99  HB3 ASP A  10       8.926  36.429  30.562  1.00  0.00           H  
ATOM    100  N   PRO A  11      12.251  34.492  30.724  1.00  0.00           N  
ATOM    101  CA  PRO A  11      13.481  34.764  29.975  1.00  0.00           C  
ATOM    102  C   PRO A  11      13.463  34.138  28.584  1.00  0.00           C  
ATOM    103  O   PRO A  11      12.513  33.446  28.217  1.00  0.00           O  
ATOM    104  CB  PRO A  11      14.570  34.119  30.837  1.00  0.00           C  
ATOM    105  CG  PRO A  11      13.866  33.052  31.600  1.00  0.00           C  
ATOM    106  CD  PRO A  11      12.475  33.567  31.847  1.00  0.00           C  
ATOM    107  HA  PRO A  11      13.668  35.824  29.889  1.00  0.00           H  
ATOM    108  HB2 PRO A  11      15.341  33.708  30.199  1.00  0.00           H  
ATOM    109  HB3 PRO A  11      14.998  34.859  31.496  1.00  0.00           H  
ATOM    110  HG2 PRO A  11      13.832  32.144  31.017  1.00  0.00           H  
ATOM    111  HG3 PRO A  11      14.373  32.877  32.538  1.00  0.00           H  
ATOM    112  HD2 PRO A  11      11.763  32.755  31.826  1.00  0.00           H  
ATOM    113  HD3 PRO A  11      12.428  34.089  32.791  1.00  0.00           H  
ATOM    114  N   GLU A  12      14.518  34.387  27.814  1.00  0.00           N  
ATOM    115  CA  GLU A  12      14.621  33.848  26.464  1.00  0.00           C  
ATOM    116  C   GLU A  12      15.750  32.826  26.371  1.00  0.00           C  
ATOM    117  O   GLU A  12      16.915  33.152  26.596  1.00  0.00           O  
ATOM    118  CB  GLU A  12      14.854  34.976  25.457  1.00  0.00           C  
ATOM    119  CG  GLU A  12      13.571  35.602  24.935  1.00  0.00           C  
ATOM    120  CD  GLU A  12      12.985  36.618  25.896  1.00  0.00           C  
ATOM    121  OE1 GLU A  12      12.784  36.270  27.078  1.00  0.00           O  
ATOM    122  OE2 GLU A  12      12.728  37.761  25.465  1.00  0.00           O  
ATOM    123  H   GLU A  12      15.243  34.946  28.163  1.00  0.00           H  
ATOM    124  HA  GLU A  12      13.689  33.357  26.230  1.00  0.00           H  
ATOM    125  HB2 GLU A  12      15.441  35.750  25.930  1.00  0.00           H  
ATOM    126  HB3 GLU A  12      15.406  34.583  24.616  1.00  0.00           H  
ATOM    127  HG2 GLU A  12      13.782  36.095  23.999  1.00  0.00           H  
ATOM    128  HG3 GLU A  12      12.845  34.820  24.774  1.00  0.00           H  
ATOM    129  N   ASN A  13      15.396  31.590  26.037  1.00  0.00           N  
ATOM    130  CA  ASN A  13      16.380  30.519  25.915  1.00  0.00           C  
ATOM    131  C   ASN A  13      16.988  30.497  24.517  1.00  0.00           C  
ATOM    132  O   ASN A  13      18.134  30.899  24.320  1.00  0.00           O  
ATOM    133  CB  ASN A  13      15.733  29.167  26.224  1.00  0.00           C  
ATOM    134  CG  ASN A  13      14.303  29.083  25.725  1.00  0.00           C  
ATOM    135  OD1 ASN A  13      14.032  28.490  24.681  1.00  0.00           O  
ATOM    136  ND2 ASN A  13      13.381  29.677  26.473  1.00  0.00           N  
ATOM    137  H   ASN A  13      14.451  31.391  25.869  1.00  0.00           H  
ATOM    138  HA  ASN A  13      17.163  30.706  26.634  1.00  0.00           H  
ATOM    139  HB2 ASN A  13      16.306  28.385  25.748  1.00  0.00           H  
ATOM    140  HB3 ASN A  13      15.733  29.010  27.292  1.00  0.00           H  
ATOM    141 HD21 ASN A  13      13.669  30.131  27.292  1.00  0.00           H  
ATOM    142 HD22 ASN A  13      12.448  29.637  26.174  1.00  0.00           H  
ATOM    143  N   GLY A  14      16.212  30.024  23.545  1.00  0.00           N  
ATOM    144  CA  GLY A  14      16.692  29.959  22.178  1.00  0.00           C  
ATOM    145  C   GLY A  14      16.832  31.330  21.546  1.00  0.00           C  
ATOM    146  O   GLY A  14      16.161  32.278  21.952  1.00  0.00           O  
ATOM    147  H   GLY A  14      15.306  29.718  23.761  1.00  0.00           H  
ATOM    148  HA2 GLY A  14      17.653  29.469  22.168  1.00  0.00           H  
ATOM    149  HA3 GLY A  14      15.995  29.376  21.592  1.00  0.00           H  
ATOM    150  N   GLU A  15      17.708  31.434  20.551  1.00  0.00           N  
ATOM    151  CA  GLU A  15      17.936  32.701  19.866  1.00  0.00           C  
ATOM    152  C   GLU A  15      18.155  32.478  18.372  1.00  0.00           C  
ATOM    153  O   GLU A  15      18.571  31.401  17.948  1.00  0.00           O  
ATOM    154  CB  GLU A  15      19.143  33.423  20.468  1.00  0.00           C  
ATOM    155  CG  GLU A  15      19.706  34.516  19.576  1.00  0.00           C  
ATOM    156  CD  GLU A  15      18.822  35.746  19.532  1.00  0.00           C  
ATOM    157  OE1 GLU A  15      18.330  36.162  20.602  1.00  0.00           O  
ATOM    158  OE2 GLU A  15      18.622  36.294  18.427  1.00  0.00           O  
ATOM    159  H   GLU A  15      18.212  30.642  20.274  1.00  0.00           H  
ATOM    160  HA  GLU A  15      17.057  33.313  20.001  1.00  0.00           H  
ATOM    161  HB2 GLU A  15      18.849  33.868  21.407  1.00  0.00           H  
ATOM    162  HB3 GLU A  15      19.923  32.700  20.652  1.00  0.00           H  
ATOM    163  HG2 GLU A  15      20.678  34.803  19.949  1.00  0.00           H  
ATOM    164  HG3 GLU A  15      19.808  34.127  18.573  1.00  0.00           H  
ATOM    165  N   LYS A  16      17.872  33.506  17.580  1.00  0.00           N  
ATOM    166  CA  LYS A  16      18.038  33.426  16.132  1.00  0.00           C  
ATOM    167  C   LYS A  16      19.513  33.507  15.749  1.00  0.00           C  
ATOM    168  O   LYS A  16      20.148  34.550  15.903  1.00  0.00           O  
ATOM    169  CB  LYS A  16      17.260  34.550  15.446  1.00  0.00           C  
ATOM    170  CG  LYS A  16      15.759  34.320  15.415  1.00  0.00           C  
ATOM    171  CD  LYS A  16      15.099  35.092  14.285  1.00  0.00           C  
ATOM    172  CE  LYS A  16      14.681  36.484  14.731  1.00  0.00           C  
ATOM    173  NZ  LYS A  16      15.855  37.375  14.943  1.00  0.00           N  
ATOM    174  H   LYS A  16      17.543  34.340  17.977  1.00  0.00           H  
ATOM    175  HA  LYS A  16      17.645  32.475  15.806  1.00  0.00           H  
ATOM    176  HB2 LYS A  16      17.451  35.475  15.969  1.00  0.00           H  
ATOM    177  HB3 LYS A  16      17.609  34.644  14.428  1.00  0.00           H  
ATOM    178  HG2 LYS A  16      15.568  33.266  15.276  1.00  0.00           H  
ATOM    179  HG3 LYS A  16      15.335  34.643  16.355  1.00  0.00           H  
ATOM    180  HD2 LYS A  16      15.798  35.184  13.467  1.00  0.00           H  
ATOM    181  HD3 LYS A  16      14.223  34.551  13.954  1.00  0.00           H  
ATOM    182  HE2 LYS A  16      14.045  36.916  13.973  1.00  0.00           H  
ATOM    183  HE3 LYS A  16      14.130  36.402  15.657  1.00  0.00           H  
ATOM    184  HZ1 LYS A  16      15.777  38.219  14.339  1.00  0.00           H  
ATOM    185  HZ2 LYS A  16      16.733  36.872  14.704  1.00  0.00           H  
ATOM    186  HZ3 LYS A  16      15.901  37.676  15.938  1.00  0.00           H  
ATOM    187  N   LEU A  17      20.050  32.400  15.248  1.00  0.00           N  
ATOM    188  CA  LEU A  17      21.450  32.346  14.841  1.00  0.00           C  
ATOM    189  C   LEU A  17      21.570  32.111  13.339  1.00  0.00           C  
ATOM    190  O   LEU A  17      20.887  31.256  12.777  1.00  0.00           O  
ATOM    191  CB  LEU A  17      22.180  31.237  15.602  1.00  0.00           C  
ATOM    192  CG  LEU A  17      22.082  31.293  17.127  1.00  0.00           C  
ATOM    193  CD1 LEU A  17      22.204  29.899  17.720  1.00  0.00           C  
ATOM    194  CD2 LEU A  17      23.151  32.214  17.696  1.00  0.00           C  
ATOM    195  H   LEU A  17      19.493  31.600  15.149  1.00  0.00           H  
ATOM    196  HA  LEU A  17      21.902  33.296  15.082  1.00  0.00           H  
ATOM    197  HB2 LEU A  17      21.774  30.291  15.278  1.00  0.00           H  
ATOM    198  HB3 LEU A  17      23.226  31.288  15.335  1.00  0.00           H  
ATOM    199  HG  LEU A  17      21.115  31.690  17.405  1.00  0.00           H  
ATOM    200 HD11 LEU A  17      21.867  29.914  18.746  1.00  0.00           H  
ATOM    201 HD12 LEU A  17      23.236  29.582  17.686  1.00  0.00           H  
ATOM    202 HD13 LEU A  17      21.598  29.210  17.151  1.00  0.00           H  
ATOM    203 HD21 LEU A  17      24.103  31.705  17.692  1.00  0.00           H  
ATOM    204 HD22 LEU A  17      22.892  32.482  18.711  1.00  0.00           H  
ATOM    205 HD23 LEU A  17      23.216  33.107  17.093  1.00  0.00           H  
ATOM    206  N   GLN A  18      22.446  32.876  12.694  1.00  0.00           N  
ATOM    207  CA  GLN A  18      22.658  32.750  11.258  1.00  0.00           C  
ATOM    208  C   GLN A  18      23.913  31.936  10.961  1.00  0.00           C  
ATOM    209  O   GLN A  18      24.935  32.085  11.633  1.00  0.00           O  
ATOM    210  CB  GLN A  18      22.770  34.133  10.613  1.00  0.00           C  
ATOM    211  CG  GLN A  18      23.048  34.088   9.120  1.00  0.00           C  
ATOM    212  CD  GLN A  18      22.928  35.450   8.463  1.00  0.00           C  
ATOM    213  OE1 GLN A  18      21.899  36.116   8.573  1.00  0.00           O  
ATOM    214  NE2 GLN A  18      23.982  35.869   7.774  1.00  0.00           N  
ATOM    215  H   GLN A  18      22.962  33.540  13.197  1.00  0.00           H  
ATOM    216  HA  GLN A  18      21.805  32.236  10.840  1.00  0.00           H  
ATOM    217  HB2 GLN A  18      21.843  34.665  10.769  1.00  0.00           H  
ATOM    218  HB3 GLN A  18      23.572  34.676  11.091  1.00  0.00           H  
ATOM    219  HG2 GLN A  18      24.051  33.719   8.964  1.00  0.00           H  
ATOM    220  HG3 GLN A  18      22.342  33.416   8.655  1.00  0.00           H  
ATOM    221 HE21 GLN A  18      24.767  35.284   7.727  1.00  0.00           H  
ATOM    222 HE22 GLN A  18      23.931  36.745   7.338  1.00  0.00           H  
ATOM    223  N   ILE A  19      23.830  31.074   9.953  1.00  0.00           N  
ATOM    224  CA  ILE A  19      24.959  30.237   9.568  1.00  0.00           C  
ATOM    225  C   ILE A  19      25.008  30.041   8.057  1.00  0.00           C  
ATOM    226  O   ILE A  19      23.980  29.828   7.412  1.00  0.00           O  
ATOM    227  CB  ILE A  19      24.897  28.859  10.252  1.00  0.00           C  
ATOM    228  CG1 ILE A  19      24.890  29.020  11.773  1.00  0.00           C  
ATOM    229  CG2 ILE A  19      26.070  27.995   9.810  1.00  0.00           C  
ATOM    230  CD1 ILE A  19      26.215  29.482  12.338  1.00  0.00           C  
ATOM    231  H   ILE A  19      22.988  31.001   9.456  1.00  0.00           H  
ATOM    232  HA  ILE A  19      25.865  30.734   9.885  1.00  0.00           H  
ATOM    233  HB  ILE A  19      23.985  28.370   9.944  1.00  0.00           H  
ATOM    234 HG12 ILE A  19      24.141  29.745  12.048  1.00  0.00           H  
ATOM    235 HG13 ILE A  19      24.648  28.069  12.226  1.00  0.00           H  
ATOM    236 HG21 ILE A  19      25.798  26.953   9.888  1.00  0.00           H  
ATOM    237 HG22 ILE A  19      26.319  28.225   8.785  1.00  0.00           H  
ATOM    238 HG23 ILE A  19      26.922  28.194  10.442  1.00  0.00           H  
ATOM    239 HD11 ILE A  19      26.647  30.223  11.682  1.00  0.00           H  
ATOM    240 HD12 ILE A  19      26.060  29.912  13.316  1.00  0.00           H  
ATOM    241 HD13 ILE A  19      26.886  28.639  12.418  1.00  0.00           H  
ATOM    242  N   THR A  20      26.211  30.113   7.495  1.00  0.00           N  
ATOM    243  CA  THR A  20      26.395  29.942   6.059  1.00  0.00           C  
ATOM    244  C   THR A  20      27.065  28.610   5.744  1.00  0.00           C  
ATOM    245  O   THR A  20      27.846  28.093   6.545  1.00  0.00           O  
ATOM    246  CB  THR A  20      27.240  31.082   5.461  1.00  0.00           C  
ATOM    247  OG1 THR A  20      26.937  31.241   4.070  1.00  0.00           O  
ATOM    248  CG2 THR A  20      28.726  30.801   5.632  1.00  0.00           C  
ATOM    249  H   THR A  20      26.992  30.285   8.059  1.00  0.00           H  
ATOM    250  HA  THR A  20      25.420  29.963   5.593  1.00  0.00           H  
ATOM    251  HB  THR A  20      27.001  31.999   5.981  1.00  0.00           H  
ATOM    252  HG1 THR A  20      26.583  30.419   3.725  1.00  0.00           H  
ATOM    253 HG21 THR A  20      28.863  30.028   6.373  1.00  0.00           H  
ATOM    254 HG22 THR A  20      29.228  31.701   5.954  1.00  0.00           H  
ATOM    255 HG23 THR A  20      29.141  30.474   4.691  1.00  0.00           H  
ATOM    256  N   ILE A  21      26.755  28.058   4.576  1.00  0.00           N  
ATOM    257  CA  ILE A  21      27.330  26.786   4.156  1.00  0.00           C  
ATOM    258  C   ILE A  21      28.146  26.946   2.878  1.00  0.00           C  
ATOM    259  O   ILE A  21      27.638  27.420   1.862  1.00  0.00           O  
ATOM    260  CB  ILE A  21      26.238  25.724   3.926  1.00  0.00           C  
ATOM    261  CG1 ILE A  21      25.418  25.519   5.201  1.00  0.00           C  
ATOM    262  CG2 ILE A  21      26.862  24.412   3.476  1.00  0.00           C  
ATOM    263  CD1 ILE A  21      24.284  24.531   5.037  1.00  0.00           C  
ATOM    264  H   ILE A  21      26.127  28.518   3.982  1.00  0.00           H  
ATOM    265  HA  ILE A  21      27.981  26.439   4.945  1.00  0.00           H  
ATOM    266  HB  ILE A  21      25.587  26.074   3.139  1.00  0.00           H  
ATOM    267 HG12 ILE A  21      26.064  25.156   5.983  1.00  0.00           H  
ATOM    268 HG13 ILE A  21      24.992  26.466   5.502  1.00  0.00           H  
ATOM    269 HG21 ILE A  21      26.837  24.353   2.397  1.00  0.00           H  
ATOM    270 HG22 ILE A  21      27.886  24.366   3.813  1.00  0.00           H  
ATOM    271 HG23 ILE A  21      26.308  23.586   3.894  1.00  0.00           H  
ATOM    272 HD11 ILE A  21      23.915  24.569   4.024  1.00  0.00           H  
ATOM    273 HD12 ILE A  21      24.640  23.535   5.255  1.00  0.00           H  
ATOM    274 HD13 ILE A  21      23.485  24.783   5.720  1.00  0.00           H  
ATOM    275  N   ARG A  22      29.411  26.545   2.937  1.00  0.00           N  
ATOM    276  CA  ARG A  22      30.298  26.643   1.783  1.00  0.00           C  
ATOM    277  C   ARG A  22      30.235  25.373   0.940  1.00  0.00           C  
ATOM    278  O   ARG A  22      30.759  24.331   1.330  1.00  0.00           O  
ATOM    279  CB  ARG A  22      31.737  26.896   2.239  1.00  0.00           C  
ATOM    280  CG  ARG A  22      32.083  28.369   2.376  1.00  0.00           C  
ATOM    281  CD  ARG A  22      31.789  28.882   3.778  1.00  0.00           C  
ATOM    282  NE  ARG A  22      32.052  30.313   3.904  1.00  0.00           N  
ATOM    283  CZ  ARG A  22      32.329  30.911   5.057  1.00  0.00           C  
ATOM    284  NH1 ARG A  22      32.380  30.204   6.177  1.00  0.00           N  
ATOM    285  NH2 ARG A  22      32.557  32.218   5.090  1.00  0.00           N  
ATOM    286  H   ARG A  22      29.758  26.175   3.775  1.00  0.00           H  
ATOM    287  HA  ARG A  22      29.969  27.477   1.182  1.00  0.00           H  
ATOM    288  HB2 ARG A  22      31.886  26.423   3.198  1.00  0.00           H  
ATOM    289  HB3 ARG A  22      32.410  26.455   1.520  1.00  0.00           H  
ATOM    290  HG2 ARG A  22      33.133  28.504   2.169  1.00  0.00           H  
ATOM    291  HG3 ARG A  22      31.498  28.934   1.666  1.00  0.00           H  
ATOM    292  HD2 ARG A  22      30.749  28.695   4.005  1.00  0.00           H  
ATOM    293  HD3 ARG A  22      32.412  28.348   4.479  1.00  0.00           H  
ATOM    294  HE  ARG A  22      32.019  30.854   3.087  1.00  0.00           H  
ATOM    295 HH11 ARG A  22      32.210  29.220   6.155  1.00  0.00           H  
ATOM    296 HH12 ARG A  22      32.590  30.657   7.045  1.00  0.00           H  
ATOM    297 HH21 ARG A  22      32.520  32.754   4.247  1.00  0.00           H  
ATOM    298 HH22 ARG A  22      32.765  32.666   5.958  1.00  0.00           H  
ATOM    299  N   ARG A  23      29.591  25.470  -0.218  1.00  0.00           N  
ATOM    300  CA  ARG A  23      29.458  24.329  -1.117  1.00  0.00           C  
ATOM    301  C   ARG A  23      30.797  23.988  -1.764  1.00  0.00           C  
ATOM    302  O   ARG A  23      31.196  24.604  -2.750  1.00  0.00           O  
ATOM    303  CB  ARG A  23      28.417  24.622  -2.199  1.00  0.00           C  
ATOM    304  CG  ARG A  23      28.252  23.496  -3.206  1.00  0.00           C  
ATOM    305  CD  ARG A  23      27.587  23.986  -4.484  1.00  0.00           C  
ATOM    306  NE  ARG A  23      26.799  22.938  -5.126  1.00  0.00           N  
ATOM    307  CZ  ARG A  23      26.505  22.929  -6.421  1.00  0.00           C  
ATOM    308  NH1 ARG A  23      26.933  23.907  -7.208  1.00  0.00           N  
ATOM    309  NH2 ARG A  23      25.782  21.940  -6.933  1.00  0.00           N  
ATOM    310  H   ARG A  23      29.194  26.329  -0.475  1.00  0.00           H  
ATOM    311  HA  ARG A  23      29.128  23.483  -0.532  1.00  0.00           H  
ATOM    312  HB2 ARG A  23      27.461  24.795  -1.725  1.00  0.00           H  
ATOM    313  HB3 ARG A  23      28.712  25.514  -2.731  1.00  0.00           H  
ATOM    314  HG2 ARG A  23      29.226  23.099  -3.451  1.00  0.00           H  
ATOM    315  HG3 ARG A  23      27.643  22.720  -2.768  1.00  0.00           H  
ATOM    316  HD2 ARG A  23      26.939  24.814  -4.242  1.00  0.00           H  
ATOM    317  HD3 ARG A  23      28.354  24.317  -5.168  1.00  0.00           H  
ATOM    318  HE  ARG A  23      26.473  22.205  -4.563  1.00  0.00           H  
ATOM    319 HH11 ARG A  23      27.478  24.653  -6.827  1.00  0.00           H  
ATOM    320 HH12 ARG A  23      26.711  23.898  -8.184  1.00  0.00           H  
ATOM    321 HH21 ARG A  23      25.459  21.201  -6.342  1.00  0.00           H  
ATOM    322 HH22 ARG A  23      25.562  21.935  -7.907  1.00  0.00           H  
ATOM    323  N   GLY A  24      31.487  23.001  -1.200  1.00  0.00           N  
ATOM    324  CA  GLY A  24      32.773  22.595  -1.734  1.00  0.00           C  
ATOM    325  C   GLY A  24      33.085  21.139  -1.453  1.00  0.00           C  
ATOM    326  O   GLY A  24      34.247  20.763  -1.297  1.00  0.00           O  
ATOM    327  H   GLY A  24      31.119  22.545  -0.414  1.00  0.00           H  
ATOM    328  HA2 GLY A  24      32.774  22.754  -2.802  1.00  0.00           H  
ATOM    329  HA3 GLY A  24      33.544  23.208  -1.289  1.00  0.00           H  
ATOM    330  N   LYS A  25      32.044  20.315  -1.386  1.00  0.00           N  
ATOM    331  CA  LYS A  25      32.210  18.891  -1.122  1.00  0.00           C  
ATOM    332  C   LYS A  25      30.931  18.125  -1.442  1.00  0.00           C  
ATOM    333  O   LYS A  25      29.918  18.279  -0.761  1.00  0.00           O  
ATOM    334  CB  LYS A  25      32.601  18.665   0.340  1.00  0.00           C  
ATOM    335  CG  LYS A  25      34.101  18.672   0.578  1.00  0.00           C  
ATOM    336  CD  LYS A  25      34.464  17.951   1.866  1.00  0.00           C  
ATOM    337  CE  LYS A  25      34.485  16.443   1.673  1.00  0.00           C  
ATOM    338  NZ  LYS A  25      34.896  15.731   2.915  1.00  0.00           N  
ATOM    339  H   LYS A  25      31.141  20.674  -1.519  1.00  0.00           H  
ATOM    340  HA  LYS A  25      33.003  18.526  -1.757  1.00  0.00           H  
ATOM    341  HB2 LYS A  25      32.158  19.443   0.944  1.00  0.00           H  
ATOM    342  HB3 LYS A  25      32.211  17.709   0.661  1.00  0.00           H  
ATOM    343  HG2 LYS A  25      34.590  18.178  -0.248  1.00  0.00           H  
ATOM    344  HG3 LYS A  25      34.440  19.696   0.640  1.00  0.00           H  
ATOM    345  HD2 LYS A  25      35.444  18.276   2.185  1.00  0.00           H  
ATOM    346  HD3 LYS A  25      33.736  18.199   2.625  1.00  0.00           H  
ATOM    347  HE2 LYS A  25      33.497  16.116   1.392  1.00  0.00           H  
ATOM    348  HE3 LYS A  25      35.182  16.203   0.884  1.00  0.00           H  
ATOM    349  HZ1 LYS A  25      34.309  16.042   3.716  1.00  0.00           H  
ATOM    350  HZ2 LYS A  25      35.892  15.936   3.132  1.00  0.00           H  
ATOM    351  HZ3 LYS A  25      34.782  14.705   2.793  1.00  0.00           H  
ATOM    352  N   ASP A  26      30.985  17.300  -2.482  1.00  0.00           N  
ATOM    353  CA  ASP A  26      29.831  16.508  -2.891  1.00  0.00           C  
ATOM    354  C   ASP A  26      28.535  17.279  -2.662  1.00  0.00           C  
ATOM    355  O   ASP A  26      27.525  16.708  -2.252  1.00  0.00           O  
ATOM    356  CB  ASP A  26      29.795  15.186  -2.122  1.00  0.00           C  
ATOM    357  CG  ASP A  26      29.725  15.390  -0.622  1.00  0.00           C  
ATOM    358  OD1 ASP A  26      28.722  15.963  -0.147  1.00  0.00           O  
ATOM    359  OD2 ASP A  26      30.672  14.975   0.077  1.00  0.00           O  
ATOM    360  H   ASP A  26      31.822  17.221  -2.986  1.00  0.00           H  
ATOM    361  HA  ASP A  26      29.930  16.298  -3.945  1.00  0.00           H  
ATOM    362  HB2 ASP A  26      28.927  14.622  -2.431  1.00  0.00           H  
ATOM    363  HB3 ASP A  26      30.687  14.621  -2.350  1.00  0.00           H  
ATOM    364  N   GLY A  27      28.571  18.581  -2.932  1.00  0.00           N  
ATOM    365  CA  GLY A  27      27.393  19.408  -2.748  1.00  0.00           C  
ATOM    366  C   GLY A  27      27.595  20.478  -1.692  1.00  0.00           C  
ATOM    367  O   GLY A  27      28.673  21.064  -1.590  1.00  0.00           O  
ATOM    368  H   GLY A  27      29.404  18.982  -3.257  1.00  0.00           H  
ATOM    369  HA2 GLY A  27      27.152  19.885  -3.686  1.00  0.00           H  
ATOM    370  HA3 GLY A  27      26.567  18.779  -2.453  1.00  0.00           H  
ATOM    371  N   PHE A  28      26.555  20.734  -0.905  1.00  0.00           N  
ATOM    372  CA  PHE A  28      26.622  21.742   0.146  1.00  0.00           C  
ATOM    373  C   PHE A  28      27.144  21.137   1.446  1.00  0.00           C  
ATOM    374  O   PHE A  28      27.858  21.791   2.205  1.00  0.00           O  
ATOM    375  CB  PHE A  28      25.241  22.361   0.377  1.00  0.00           C  
ATOM    376  CG  PHE A  28      24.963  23.547  -0.502  1.00  0.00           C  
ATOM    377  CD1 PHE A  28      25.605  24.755  -0.281  1.00  0.00           C  
ATOM    378  CD2 PHE A  28      24.059  23.454  -1.548  1.00  0.00           C  
ATOM    379  CE1 PHE A  28      25.349  25.848  -1.087  1.00  0.00           C  
ATOM    380  CE2 PHE A  28      23.800  24.544  -2.358  1.00  0.00           C  
ATOM    381  CZ  PHE A  28      24.447  25.742  -2.127  1.00  0.00           C  
ATOM    382  H   PHE A  28      25.722  20.233  -1.036  1.00  0.00           H  
ATOM    383  HA  PHE A  28      27.303  22.512  -0.178  1.00  0.00           H  
ATOM    384  HB2 PHE A  28      24.484  21.618   0.180  1.00  0.00           H  
ATOM    385  HB3 PHE A  28      25.167  22.682   1.405  1.00  0.00           H  
ATOM    386  HD1 PHE A  28      26.312  24.839   0.531  1.00  0.00           H  
ATOM    387  HD2 PHE A  28      23.553  22.517  -1.729  1.00  0.00           H  
ATOM    388  HE1 PHE A  28      25.857  26.784  -0.906  1.00  0.00           H  
ATOM    389  HE2 PHE A  28      23.094  24.457  -3.170  1.00  0.00           H  
ATOM    390  HZ  PHE A  28      24.245  26.595  -2.758  1.00  0.00           H  
ATOM    391  N   GLY A  29      26.781  19.882   1.697  1.00  0.00           N  
ATOM    392  CA  GLY A  29      27.221  19.210   2.906  1.00  0.00           C  
ATOM    393  C   GLY A  29      26.064  18.803   3.796  1.00  0.00           C  
ATOM    394  O   GLY A  29      25.939  17.637   4.170  1.00  0.00           O  
ATOM    395  H   GLY A  29      26.211  19.410   1.056  1.00  0.00           H  
ATOM    396  HA2 GLY A  29      27.779  18.326   2.631  1.00  0.00           H  
ATOM    397  HA3 GLY A  29      27.869  19.875   3.457  1.00  0.00           H  
ATOM    398  N   PHE A  30      25.216  19.767   4.139  1.00  0.00           N  
ATOM    399  CA  PHE A  30      24.065  19.504   4.994  1.00  0.00           C  
ATOM    400  C   PHE A  30      22.838  19.144   4.159  1.00  0.00           C  
ATOM    401  O   PHE A  30      22.681  19.612   3.031  1.00  0.00           O  
ATOM    402  CB  PHE A  30      23.761  20.724   5.866  1.00  0.00           C  
ATOM    403  CG  PHE A  30      22.852  21.721   5.208  1.00  0.00           C  
ATOM    404  CD1 PHE A  30      22.984  22.015   3.861  1.00  0.00           C  
ATOM    405  CD2 PHE A  30      21.864  22.365   5.936  1.00  0.00           C  
ATOM    406  CE1 PHE A  30      22.148  22.932   3.252  1.00  0.00           C  
ATOM    407  CE2 PHE A  30      21.026  23.284   5.333  1.00  0.00           C  
ATOM    408  CZ  PHE A  30      21.167  23.568   3.989  1.00  0.00           C  
ATOM    409  H   PHE A  30      25.368  20.679   3.809  1.00  0.00           H  
ATOM    410  HA  PHE A  30      24.309  18.668   5.631  1.00  0.00           H  
ATOM    411  HB2 PHE A  30      23.287  20.396   6.779  1.00  0.00           H  
ATOM    412  HB3 PHE A  30      24.686  21.225   6.107  1.00  0.00           H  
ATOM    413  HD1 PHE A  30      23.750  21.519   3.282  1.00  0.00           H  
ATOM    414  HD2 PHE A  30      21.752  22.144   6.988  1.00  0.00           H  
ATOM    415  HE1 PHE A  30      22.261  23.152   2.200  1.00  0.00           H  
ATOM    416  HE2 PHE A  30      20.260  23.778   5.913  1.00  0.00           H  
ATOM    417  HZ  PHE A  30      20.514  24.285   3.516  1.00  0.00           H  
ATOM    418  N   THR A  31      21.970  18.308   4.723  1.00  0.00           N  
ATOM    419  CA  THR A  31      20.760  17.884   4.032  1.00  0.00           C  
ATOM    420  C   THR A  31      19.513  18.407   4.736  1.00  0.00           C  
ATOM    421  O   THR A  31      19.395  18.315   5.958  1.00  0.00           O  
ATOM    422  CB  THR A  31      20.676  16.349   3.938  1.00  0.00           C  
ATOM    423  OG1 THR A  31      21.969  15.805   3.649  1.00  0.00           O  
ATOM    424  CG2 THR A  31      19.691  15.927   2.859  1.00  0.00           C  
ATOM    425  H   THR A  31      22.152  17.970   5.625  1.00  0.00           H  
ATOM    426  HA  THR A  31      20.790  18.285   3.029  1.00  0.00           H  
ATOM    427  HB  THR A  31      20.336  15.963   4.887  1.00  0.00           H  
ATOM    428  HG1 THR A  31      21.907  14.849   3.587  1.00  0.00           H  
ATOM    429 HG21 THR A  31      19.615  16.706   2.114  1.00  0.00           H  
ATOM    430 HG22 THR A  31      18.721  15.757   3.304  1.00  0.00           H  
ATOM    431 HG23 THR A  31      20.037  15.017   2.392  1.00  0.00           H  
ATOM    432  N   ILE A  32      18.586  18.955   3.958  1.00  0.00           N  
ATOM    433  CA  ILE A  32      17.347  19.491   4.509  1.00  0.00           C  
ATOM    434  C   ILE A  32      16.174  19.242   3.566  1.00  0.00           C  
ATOM    435  O   ILE A  32      16.204  19.643   2.402  1.00  0.00           O  
ATOM    436  CB  ILE A  32      17.459  21.002   4.781  1.00  0.00           C  
ATOM    437  CG1 ILE A  32      17.522  21.777   3.464  1.00  0.00           C  
ATOM    438  CG2 ILE A  32      18.684  21.296   5.635  1.00  0.00           C  
ATOM    439  CD1 ILE A  32      16.167  22.214   2.955  1.00  0.00           C  
ATOM    440  H   ILE A  32      18.738  18.999   2.992  1.00  0.00           H  
ATOM    441  HA  ILE A  32      17.155  18.989   5.446  1.00  0.00           H  
ATOM    442  HB  ILE A  32      16.584  21.312   5.333  1.00  0.00           H  
ATOM    443 HG12 ILE A  32      18.124  22.662   3.603  1.00  0.00           H  
ATOM    444 HG13 ILE A  32      17.975  21.153   2.709  1.00  0.00           H  
ATOM    445 HG21 ILE A  32      18.884  22.358   5.623  1.00  0.00           H  
ATOM    446 HG22 ILE A  32      18.501  20.977   6.649  1.00  0.00           H  
ATOM    447 HG23 ILE A  32      19.536  20.765   5.238  1.00  0.00           H  
ATOM    448 HD11 ILE A  32      16.187  22.269   1.877  1.00  0.00           H  
ATOM    449 HD12 ILE A  32      15.418  21.501   3.266  1.00  0.00           H  
ATOM    450 HD13 ILE A  32      15.926  23.187   3.360  1.00  0.00           H  
ATOM    451  N   CYS A  33      15.142  18.579   4.077  1.00  0.00           N  
ATOM    452  CA  CYS A  33      13.957  18.278   3.282  1.00  0.00           C  
ATOM    453  C   CYS A  33      12.721  18.171   4.166  1.00  0.00           C  
ATOM    454  O   CYS A  33      12.680  17.366   5.098  1.00  0.00           O  
ATOM    455  CB  CYS A  33      14.158  16.975   2.505  1.00  0.00           C  
ATOM    456  SG  CYS A  33      14.944  17.192   0.891  1.00  0.00           S  
ATOM    457  H   CYS A  33      15.177  18.285   5.011  1.00  0.00           H  
ATOM    458  HA  CYS A  33      13.815  19.087   2.581  1.00  0.00           H  
ATOM    459  HB2 CYS A  33      14.779  16.310   3.086  1.00  0.00           H  
ATOM    460  HB3 CYS A  33      13.196  16.510   2.343  1.00  0.00           H  
ATOM    461  HG  CYS A  33      16.203  16.796   0.994  1.00  0.00           H  
ATOM    462  N   CYS A  34      11.715  18.987   3.871  1.00  0.00           N  
ATOM    463  CA  CYS A  34      10.478  18.987   4.643  1.00  0.00           C  
ATOM    464  C   CYS A  34       9.434  19.893   3.996  1.00  0.00           C  
ATOM    465  O   CYS A  34       9.681  20.495   2.951  1.00  0.00           O  
ATOM    466  CB  CYS A  34      10.747  19.441   6.077  1.00  0.00           C  
ATOM    467  SG  CYS A  34      11.041  18.085   7.237  1.00  0.00           S  
ATOM    468  H   CYS A  34      11.808  19.607   3.117  1.00  0.00           H  
ATOM    469  HA  CYS A  34      10.099  17.976   4.658  1.00  0.00           H  
ATOM    470  HB2 CYS A  34      11.618  20.077   6.089  1.00  0.00           H  
ATOM    471  HB3 CYS A  34       9.896  20.002   6.435  1.00  0.00           H  
ATOM    472  HG  CYS A  34      12.080  17.393   6.800  1.00  0.00           H  
ATOM    473  N   ASP A  35       8.267  19.982   4.624  1.00  0.00           N  
ATOM    474  CA  ASP A  35       7.185  20.815   4.110  1.00  0.00           C  
ATOM    475  C   ASP A  35       6.939  22.012   5.022  1.00  0.00           C  
ATOM    476  O   ASP A  35       6.813  21.864   6.238  1.00  0.00           O  
ATOM    477  CB  ASP A  35       5.902  19.992   3.972  1.00  0.00           C  
ATOM    478  CG  ASP A  35       5.783  18.923   5.039  1.00  0.00           C  
ATOM    479  OD1 ASP A  35       5.499  19.275   6.204  1.00  0.00           O  
ATOM    480  OD2 ASP A  35       5.971  17.733   4.710  1.00  0.00           O  
ATOM    481  H   ASP A  35       8.130  19.479   5.453  1.00  0.00           H  
ATOM    482  HA  ASP A  35       7.477  21.175   3.135  1.00  0.00           H  
ATOM    483  HB2 ASP A  35       5.049  20.652   4.051  1.00  0.00           H  
ATOM    484  HB3 ASP A  35       5.893  19.513   3.004  1.00  0.00           H  
ATOM    485  N   SER A  36       6.875  23.200   4.428  1.00  0.00           N  
ATOM    486  CA  SER A  36       6.649  24.423   5.188  1.00  0.00           C  
ATOM    487  C   SER A  36       5.762  24.155   6.400  1.00  0.00           C  
ATOM    488  O   SER A  36       4.633  23.679   6.280  1.00  0.00           O  
ATOM    489  CB  SER A  36       6.009  25.491   4.299  1.00  0.00           C  
ATOM    490  OG  SER A  36       5.152  24.904   3.335  1.00  0.00           O  
ATOM    491  H   SER A  36       6.983  23.253   3.456  1.00  0.00           H  
ATOM    492  HA  SER A  36       7.609  24.782   5.532  1.00  0.00           H  
ATOM    493  HB2 SER A  36       5.433  26.168   4.910  1.00  0.00           H  
ATOM    494  HB3 SER A  36       6.785  26.041   3.785  1.00  0.00           H  
ATOM    495  HG  SER A  36       4.249  25.191   3.492  1.00  0.00           H  
ATOM    496  N   PRO A  37       6.284  24.468   7.595  1.00  0.00           N  
ATOM    497  CA  PRO A  37       7.627  25.035   7.749  1.00  0.00           C  
ATOM    498  C   PRO A  37       8.723  24.026   7.425  1.00  0.00           C  
ATOM    499  O   PRO A  37       8.548  22.823   7.617  1.00  0.00           O  
ATOM    500  CB  PRO A  37       7.679  25.426   9.227  1.00  0.00           C  
ATOM    501  CG  PRO A  37       6.697  24.525   9.894  1.00  0.00           C  
ATOM    502  CD  PRO A  37       5.603  24.292   8.889  1.00  0.00           C  
ATOM    503  HA  PRO A  37       7.758  25.915   7.137  1.00  0.00           H  
ATOM    504  HB2 PRO A  37       8.679  25.272   9.609  1.00  0.00           H  
ATOM    505  HB3 PRO A  37       7.402  26.464   9.340  1.00  0.00           H  
ATOM    506  HG2 PRO A  37       7.172  23.593  10.153  1.00  0.00           H  
ATOM    507  HG3 PRO A  37       6.299  25.005  10.776  1.00  0.00           H  
ATOM    508  HD2 PRO A  37       5.209  23.291   8.985  1.00  0.00           H  
ATOM    509  HD3 PRO A  37       4.816  25.022   9.012  1.00  0.00           H  
ATOM    510  N   VAL A  38       9.853  24.523   6.934  1.00  0.00           N  
ATOM    511  CA  VAL A  38      10.978  23.665   6.586  1.00  0.00           C  
ATOM    512  C   VAL A  38      11.850  23.380   7.804  1.00  0.00           C  
ATOM    513  O   VAL A  38      11.963  24.209   8.707  1.00  0.00           O  
ATOM    514  CB  VAL A  38      11.847  24.298   5.483  1.00  0.00           C  
ATOM    515  CG1 VAL A  38      13.087  23.453   5.229  1.00  0.00           C  
ATOM    516  CG2 VAL A  38      11.041  24.473   4.205  1.00  0.00           C  
ATOM    517  H   VAL A  38       9.932  25.492   6.804  1.00  0.00           H  
ATOM    518  HA  VAL A  38      10.584  22.731   6.212  1.00  0.00           H  
ATOM    519  HB  VAL A  38      12.166  25.273   5.819  1.00  0.00           H  
ATOM    520 HG11 VAL A  38      13.811  23.634   6.009  1.00  0.00           H  
ATOM    521 HG12 VAL A  38      12.816  22.408   5.222  1.00  0.00           H  
ATOM    522 HG13 VAL A  38      13.515  23.721   4.273  1.00  0.00           H  
ATOM    523 HG21 VAL A  38      11.551  23.986   3.388  1.00  0.00           H  
ATOM    524 HG22 VAL A  38      10.063  24.032   4.333  1.00  0.00           H  
ATOM    525 HG23 VAL A  38      10.935  25.525   3.987  1.00  0.00           H  
ATOM    526  N   ARG A  39      12.467  22.203   7.821  1.00  0.00           N  
ATOM    527  CA  ARG A  39      13.329  21.809   8.929  1.00  0.00           C  
ATOM    528  C   ARG A  39      14.592  21.123   8.417  1.00  0.00           C  
ATOM    529  O   ARG A  39      14.706  20.812   7.231  1.00  0.00           O  
ATOM    530  CB  ARG A  39      12.578  20.874   9.880  1.00  0.00           C  
ATOM    531  CG  ARG A  39      11.688  21.603  10.874  1.00  0.00           C  
ATOM    532  CD  ARG A  39      11.361  20.729  12.074  1.00  0.00           C  
ATOM    533  NE  ARG A  39      10.214  21.235  12.823  1.00  0.00           N  
ATOM    534  CZ  ARG A  39       9.479  20.485  13.636  1.00  0.00           C  
ATOM    535  NH1 ARG A  39       9.770  19.202  13.804  1.00  0.00           N  
ATOM    536  NH2 ARG A  39       8.450  21.018  14.284  1.00  0.00           N  
ATOM    537  H   ARG A  39      12.338  21.584   7.072  1.00  0.00           H  
ATOM    538  HA  ARG A  39      13.611  22.703   9.465  1.00  0.00           H  
ATOM    539  HB2 ARG A  39      11.959  20.208   9.297  1.00  0.00           H  
ATOM    540  HB3 ARG A  39      13.298  20.292  10.434  1.00  0.00           H  
ATOM    541  HG2 ARG A  39      12.200  22.490  11.217  1.00  0.00           H  
ATOM    542  HG3 ARG A  39      10.770  21.883  10.381  1.00  0.00           H  
ATOM    543  HD2 ARG A  39      11.140  19.731  11.725  1.00  0.00           H  
ATOM    544  HD3 ARG A  39      12.222  20.700  12.726  1.00  0.00           H  
ATOM    545  HE  ARG A  39       9.982  22.180  12.713  1.00  0.00           H  
ATOM    546 HH11 ARG A  39      10.544  18.798  13.318  1.00  0.00           H  
ATOM    547 HH12 ARG A  39       9.215  18.640  14.418  1.00  0.00           H  
ATOM    548 HH21 ARG A  39       8.228  21.985  14.159  1.00  0.00           H  
ATOM    549 HH22 ARG A  39       7.897  20.452  14.894  1.00  0.00           H  
ATOM    550  N   VAL A  40      15.541  20.890   9.319  1.00  0.00           N  
ATOM    551  CA  VAL A  40      16.795  20.241   8.959  1.00  0.00           C  
ATOM    552  C   VAL A  40      16.684  18.725   9.078  1.00  0.00           C  
ATOM    553  O   VAL A  40      16.083  18.209  10.020  1.00  0.00           O  
ATOM    554  CB  VAL A  40      17.954  20.730   9.847  1.00  0.00           C  
ATOM    555  CG1 VAL A  40      19.262  20.075   9.427  1.00  0.00           C  
ATOM    556  CG2 VAL A  40      18.066  22.247   9.790  1.00  0.00           C  
ATOM    557  H   VAL A  40      15.392  21.161  10.249  1.00  0.00           H  
ATOM    558  HA  VAL A  40      17.021  20.497   7.934  1.00  0.00           H  
ATOM    559  HB  VAL A  40      17.746  20.444  10.868  1.00  0.00           H  
ATOM    560 HG11 VAL A  40      20.052  20.811   9.435  1.00  0.00           H  
ATOM    561 HG12 VAL A  40      19.504  19.280  10.117  1.00  0.00           H  
ATOM    562 HG13 VAL A  40      19.158  19.670   8.432  1.00  0.00           H  
ATOM    563 HG21 VAL A  40      17.186  22.653   9.314  1.00  0.00           H  
ATOM    564 HG22 VAL A  40      18.148  22.640  10.793  1.00  0.00           H  
ATOM    565 HG23 VAL A  40      18.943  22.522   9.223  1.00  0.00           H  
ATOM    566  N   GLN A  41      17.267  18.017   8.117  1.00  0.00           N  
ATOM    567  CA  GLN A  41      17.233  16.559   8.114  1.00  0.00           C  
ATOM    568  C   GLN A  41      18.425  15.985   8.871  1.00  0.00           C  
ATOM    569  O   GLN A  41      18.263  15.157   9.768  1.00  0.00           O  
ATOM    570  CB  GLN A  41      17.224  16.031   6.679  1.00  0.00           C  
ATOM    571  CG  GLN A  41      17.268  14.515   6.588  1.00  0.00           C  
ATOM    572  CD  GLN A  41      15.898  13.881   6.725  1.00  0.00           C  
ATOM    573  OE1 GLN A  41      14.929  14.331   6.113  1.00  0.00           O  
ATOM    574  NE2 GLN A  41      15.811  12.828   7.530  1.00  0.00           N  
ATOM    575  H   GLN A  41      17.731  18.485   7.393  1.00  0.00           H  
ATOM    576  HA  GLN A  41      16.325  16.249   8.608  1.00  0.00           H  
ATOM    577  HB2 GLN A  41      16.325  16.374   6.188  1.00  0.00           H  
ATOM    578  HB3 GLN A  41      18.082  16.427   6.157  1.00  0.00           H  
ATOM    579  HG2 GLN A  41      17.682  14.236   5.630  1.00  0.00           H  
ATOM    580  HG3 GLN A  41      17.904  14.139   7.377  1.00  0.00           H  
ATOM    581 HE21 GLN A  41      16.624  12.525   7.985  1.00  0.00           H  
ATOM    582 HE22 GLN A  41      14.936  12.399   7.637  1.00  0.00           H  
ATOM    583  N   ALA A  42      19.623  16.430   8.506  1.00  0.00           N  
ATOM    584  CA  ALA A  42      20.843  15.962   9.152  1.00  0.00           C  
ATOM    585  C   ALA A  42      22.052  16.770   8.694  1.00  0.00           C  
ATOM    586  O   ALA A  42      22.029  17.392   7.632  1.00  0.00           O  
ATOM    587  CB  ALA A  42      21.055  14.483   8.868  1.00  0.00           C  
ATOM    588  H   ALA A  42      19.687  17.091   7.784  1.00  0.00           H  
ATOM    589  HA  ALA A  42      20.723  16.085  10.218  1.00  0.00           H  
ATOM    590  HB1 ALA A  42      20.837  13.910   9.758  1.00  0.00           H  
ATOM    591  HB2 ALA A  42      20.399  14.171   8.069  1.00  0.00           H  
ATOM    592  HB3 ALA A  42      22.082  14.317   8.576  1.00  0.00           H  
ATOM    593  N   VAL A  43      23.107  16.757   9.502  1.00  0.00           N  
ATOM    594  CA  VAL A  43      24.326  17.489   9.180  1.00  0.00           C  
ATOM    595  C   VAL A  43      25.489  16.536   8.926  1.00  0.00           C  
ATOM    596  O   VAL A  43      25.636  15.523   9.612  1.00  0.00           O  
ATOM    597  CB  VAL A  43      24.712  18.462  10.308  1.00  0.00           C  
ATOM    598  CG1 VAL A  43      25.903  19.315   9.895  1.00  0.00           C  
ATOM    599  CG2 VAL A  43      23.526  19.336  10.686  1.00  0.00           C  
ATOM    600  H   VAL A  43      23.064  16.243  10.335  1.00  0.00           H  
ATOM    601  HA  VAL A  43      24.143  18.064   8.283  1.00  0.00           H  
ATOM    602  HB  VAL A  43      24.996  17.883  11.175  1.00  0.00           H  
ATOM    603 HG11 VAL A  43      26.461  19.602  10.774  1.00  0.00           H  
ATOM    604 HG12 VAL A  43      26.539  18.747   9.232  1.00  0.00           H  
ATOM    605 HG13 VAL A  43      25.551  20.201   9.387  1.00  0.00           H  
ATOM    606 HG21 VAL A  43      22.713  19.154   9.999  1.00  0.00           H  
ATOM    607 HG22 VAL A  43      23.209  19.099  11.691  1.00  0.00           H  
ATOM    608 HG23 VAL A  43      23.814  20.376  10.637  1.00  0.00           H  
ATOM    609  N   ASP A  44      26.312  16.864   7.937  1.00  0.00           N  
ATOM    610  CA  ASP A  44      27.463  16.038   7.593  1.00  0.00           C  
ATOM    611  C   ASP A  44      28.624  16.300   8.547  1.00  0.00           C  
ATOM    612  O   ASP A  44      28.923  17.449   8.877  1.00  0.00           O  
ATOM    613  CB  ASP A  44      27.899  16.308   6.152  1.00  0.00           C  
ATOM    614  CG  ASP A  44      28.909  15.292   5.654  1.00  0.00           C  
ATOM    615  OD1 ASP A  44      28.488  14.188   5.246  1.00  0.00           O  
ATOM    616  OD2 ASP A  44      30.118  15.600   5.669  1.00  0.00           O  
ATOM    617  H   ASP A  44      26.141  17.683   7.425  1.00  0.00           H  
ATOM    618  HA  ASP A  44      27.167  15.003   7.683  1.00  0.00           H  
ATOM    619  HB2 ASP A  44      27.033  16.273   5.509  1.00  0.00           H  
ATOM    620  HB3 ASP A  44      28.346  17.290   6.096  1.00  0.00           H  
ATOM    621  N   SER A  45      29.276  15.229   8.987  1.00  0.00           N  
ATOM    622  CA  SER A  45      30.401  15.343   9.908  1.00  0.00           C  
ATOM    623  C   SER A  45      31.670  15.754   9.166  1.00  0.00           C  
ATOM    624  O   SER A  45      32.072  15.111   8.197  1.00  0.00           O  
ATOM    625  CB  SER A  45      30.630  14.017  10.635  1.00  0.00           C  
ATOM    626  OG  SER A  45      31.352  14.212  11.838  1.00  0.00           O  
ATOM    627  H   SER A  45      28.991  14.340   8.688  1.00  0.00           H  
ATOM    628  HA  SER A  45      30.161  16.105  10.634  1.00  0.00           H  
ATOM    629  HB2 SER A  45      29.676  13.570  10.870  1.00  0.00           H  
ATOM    630  HB3 SER A  45      31.191  13.351   9.995  1.00  0.00           H  
ATOM    631  HG  SER A  45      32.292  14.116  11.667  1.00  0.00           H  
ATOM    632  N   GLY A  46      32.296  16.832   9.630  1.00  0.00           N  
ATOM    633  CA  GLY A  46      33.512  17.311   8.999  1.00  0.00           C  
ATOM    634  C   GLY A  46      33.246  18.001   7.675  1.00  0.00           C  
ATOM    635  O   GLY A  46      33.983  17.809   6.709  1.00  0.00           O  
ATOM    636  H   GLY A  46      31.929  17.305  10.405  1.00  0.00           H  
ATOM    637  HA2 GLY A  46      33.999  18.009   9.665  1.00  0.00           H  
ATOM    638  HA3 GLY A  46      34.171  16.472   8.829  1.00  0.00           H  
ATOM    639  N   GLY A  47      32.188  18.805   7.631  1.00  0.00           N  
ATOM    640  CA  GLY A  47      31.844  19.511   6.410  1.00  0.00           C  
ATOM    641  C   GLY A  47      31.778  21.012   6.608  1.00  0.00           C  
ATOM    642  O   GLY A  47      32.037  21.528   7.695  1.00  0.00           O  
ATOM    643  H   GLY A  47      31.637  18.919   8.432  1.00  0.00           H  
ATOM    644  HA2 GLY A  47      32.586  19.290   5.658  1.00  0.00           H  
ATOM    645  HA3 GLY A  47      30.881  19.163   6.065  1.00  0.00           H  
ATOM    646  N   PRO A  48      31.426  21.739   5.536  1.00  0.00           N  
ATOM    647  CA  PRO A  48      31.321  23.201   5.572  1.00  0.00           C  
ATOM    648  C   PRO A  48      30.135  23.676   6.407  1.00  0.00           C  
ATOM    649  O   PRO A  48      30.179  24.748   7.008  1.00  0.00           O  
ATOM    650  CB  PRO A  48      31.124  23.578   4.101  1.00  0.00           C  
ATOM    651  CG  PRO A  48      30.522  22.368   3.477  1.00  0.00           C  
ATOM    652  CD  PRO A  48      31.104  21.190   4.209  1.00  0.00           C  
ATOM    653  HA  PRO A  48      32.226  23.656   5.945  1.00  0.00           H  
ATOM    654  HB2 PRO A  48      30.464  24.431   4.031  1.00  0.00           H  
ATOM    655  HB3 PRO A  48      32.079  23.817   3.658  1.00  0.00           H  
ATOM    656  HG2 PRO A  48      29.449  22.389   3.596  1.00  0.00           H  
ATOM    657  HG3 PRO A  48      30.785  22.326   2.430  1.00  0.00           H  
ATOM    658  HD2 PRO A  48      30.376  20.396   4.286  1.00  0.00           H  
ATOM    659  HD3 PRO A  48      31.997  20.840   3.710  1.00  0.00           H  
ATOM    660  N   ALA A  49      29.078  22.871   6.438  1.00  0.00           N  
ATOM    661  CA  ALA A  49      27.883  23.208   7.200  1.00  0.00           C  
ATOM    662  C   ALA A  49      28.121  23.037   8.697  1.00  0.00           C  
ATOM    663  O   ALA A  49      27.814  23.927   9.489  1.00  0.00           O  
ATOM    664  CB  ALA A  49      26.710  22.352   6.748  1.00  0.00           C  
ATOM    665  H   ALA A  49      29.105  22.029   5.937  1.00  0.00           H  
ATOM    666  HA  ALA A  49      27.641  24.242   7.001  1.00  0.00           H  
ATOM    667  HB1 ALA A  49      26.413  22.646   5.752  1.00  0.00           H  
ATOM    668  HB2 ALA A  49      27.004  21.313   6.745  1.00  0.00           H  
ATOM    669  HB3 ALA A  49      25.881  22.490   7.427  1.00  0.00           H  
ATOM    670  N   GLU A  50      28.668  21.886   9.077  1.00  0.00           N  
ATOM    671  CA  GLU A  50      28.943  21.599  10.480  1.00  0.00           C  
ATOM    672  C   GLU A  50      30.045  22.510  11.015  1.00  0.00           C  
ATOM    673  O   GLU A  50      29.838  23.255  11.972  1.00  0.00           O  
ATOM    674  CB  GLU A  50      29.348  20.133  10.653  1.00  0.00           C  
ATOM    675  CG  GLU A  50      29.266  19.646  12.090  1.00  0.00           C  
ATOM    676  CD  GLU A  50      29.661  18.189  12.234  1.00  0.00           C  
ATOM    677  OE1 GLU A  50      30.791  17.837  11.836  1.00  0.00           O  
ATOM    678  OE2 GLU A  50      28.839  17.399  12.746  1.00  0.00           O  
ATOM    679  H   GLU A  50      28.890  21.215   8.398  1.00  0.00           H  
ATOM    680  HA  GLU A  50      28.039  21.781  11.039  1.00  0.00           H  
ATOM    681  HB2 GLU A  50      28.699  19.519  10.048  1.00  0.00           H  
ATOM    682  HB3 GLU A  50      30.366  20.011  10.312  1.00  0.00           H  
ATOM    683  HG2 GLU A  50      29.927  20.243  12.698  1.00  0.00           H  
ATOM    684  HG3 GLU A  50      28.251  19.764  12.439  1.00  0.00           H  
ATOM    685  N   ARG A  51      31.216  22.442  10.390  1.00  0.00           N  
ATOM    686  CA  ARG A  51      32.351  23.259  10.804  1.00  0.00           C  
ATOM    687  C   ARG A  51      31.918  24.697  11.068  1.00  0.00           C  
ATOM    688  O   ARG A  51      32.269  25.282  12.092  1.00  0.00           O  
ATOM    689  CB  ARG A  51      33.443  23.231   9.732  1.00  0.00           C  
ATOM    690  CG  ARG A  51      34.248  21.943   9.715  1.00  0.00           C  
ATOM    691  CD  ARG A  51      35.557  22.114   8.961  1.00  0.00           C  
ATOM    692  NE  ARG A  51      36.619  22.635   9.816  1.00  0.00           N  
ATOM    693  CZ  ARG A  51      37.791  23.061   9.357  1.00  0.00           C  
ATOM    694  NH1 ARG A  51      38.049  23.028   8.057  1.00  0.00           N  
ATOM    695  NH2 ARG A  51      38.707  23.521  10.200  1.00  0.00           N  
ATOM    696  H   ARG A  51      31.320  21.828   9.632  1.00  0.00           H  
ATOM    697  HA  ARG A  51      32.745  22.839  11.717  1.00  0.00           H  
ATOM    698  HB2 ARG A  51      32.983  23.355   8.763  1.00  0.00           H  
ATOM    699  HB3 ARG A  51      34.122  24.052   9.908  1.00  0.00           H  
ATOM    700  HG2 ARG A  51      34.468  21.653  10.733  1.00  0.00           H  
ATOM    701  HG3 ARG A  51      33.664  21.171   9.238  1.00  0.00           H  
ATOM    702  HD2 ARG A  51      35.860  21.153   8.571  1.00  0.00           H  
ATOM    703  HD3 ARG A  51      35.397  22.799   8.142  1.00  0.00           H  
ATOM    704  HE  ARG A  51      36.450  22.668  10.781  1.00  0.00           H  
ATOM    705 HH11 ARG A  51      37.360  22.682   7.420  1.00  0.00           H  
ATOM    706 HH12 ARG A  51      38.931  23.351   7.714  1.00  0.00           H  
ATOM    707 HH21 ARG A  51      38.516  23.548  11.181  1.00  0.00           H  
ATOM    708 HH22 ARG A  51      39.588  23.842   9.853  1.00  0.00           H  
ATOM    709  N   ALA A  52      31.153  25.260  10.138  1.00  0.00           N  
ATOM    710  CA  ALA A  52      30.672  26.629  10.272  1.00  0.00           C  
ATOM    711  C   ALA A  52      29.860  26.803  11.551  1.00  0.00           C  
ATOM    712  O   ALA A  52      29.903  27.855  12.187  1.00  0.00           O  
ATOM    713  CB  ALA A  52      29.840  27.017   9.059  1.00  0.00           C  
ATOM    714  H   ALA A  52      30.907  24.742   9.345  1.00  0.00           H  
ATOM    715  HA  ALA A  52      31.531  27.283  10.312  1.00  0.00           H  
ATOM    716  HB1 ALA A  52      29.461  28.020   9.188  1.00  0.00           H  
ATOM    717  HB2 ALA A  52      30.455  26.976   8.172  1.00  0.00           H  
ATOM    718  HB3 ALA A  52      29.012  26.330   8.956  1.00  0.00           H  
ATOM    719  N   GLY A  53      29.117  25.764  11.921  1.00  0.00           N  
ATOM    720  CA  GLY A  53      28.305  25.823  13.122  1.00  0.00           C  
ATOM    721  C   GLY A  53      26.837  25.568  12.842  1.00  0.00           C  
ATOM    722  O   GLY A  53      25.965  26.225  13.413  1.00  0.00           O  
ATOM    723  H   GLY A  53      29.122  24.951  11.375  1.00  0.00           H  
ATOM    724  HA2 GLY A  53      28.662  25.082  13.821  1.00  0.00           H  
ATOM    725  HA3 GLY A  53      28.409  26.802  13.566  1.00  0.00           H  
ATOM    726  N   LEU A  54      26.562  24.612  11.960  1.00  0.00           N  
ATOM    727  CA  LEU A  54      25.189  24.273  11.604  1.00  0.00           C  
ATOM    728  C   LEU A  54      24.736  23.008  12.325  1.00  0.00           C  
ATOM    729  O   LEU A  54      25.330  21.943  12.162  1.00  0.00           O  
ATOM    730  CB  LEU A  54      25.066  24.083  10.091  1.00  0.00           C  
ATOM    731  CG  LEU A  54      23.644  23.959   9.542  1.00  0.00           C  
ATOM    732  CD1 LEU A  54      23.597  24.376   8.082  1.00  0.00           C  
ATOM    733  CD2 LEU A  54      23.129  22.537   9.712  1.00  0.00           C  
ATOM    734  H   LEU A  54      27.299  24.124  11.539  1.00  0.00           H  
ATOM    735  HA  LEU A  54      24.555  25.093  11.907  1.00  0.00           H  
ATOM    736  HB2 LEU A  54      25.532  24.930   9.612  1.00  0.00           H  
ATOM    737  HB3 LEU A  54      25.602  23.182   9.827  1.00  0.00           H  
ATOM    738  HG  LEU A  54      22.993  24.620  10.099  1.00  0.00           H  
ATOM    739 HD11 LEU A  54      22.993  23.674   7.526  1.00  0.00           H  
ATOM    740 HD12 LEU A  54      24.599  24.386   7.678  1.00  0.00           H  
ATOM    741 HD13 LEU A  54      23.167  25.363   8.002  1.00  0.00           H  
ATOM    742 HD21 LEU A  54      23.158  22.266  10.756  1.00  0.00           H  
ATOM    743 HD22 LEU A  54      23.752  21.859   9.146  1.00  0.00           H  
ATOM    744 HD23 LEU A  54      22.113  22.478   9.352  1.00  0.00           H  
ATOM    745  N   GLN A  55      23.679  23.134  13.122  1.00  0.00           N  
ATOM    746  CA  GLN A  55      23.147  21.999  13.867  1.00  0.00           C  
ATOM    747  C   GLN A  55      21.797  21.564  13.305  1.00  0.00           C  
ATOM    748  O   GLN A  55      20.947  22.398  12.993  1.00  0.00           O  
ATOM    749  CB  GLN A  55      23.004  22.356  15.348  1.00  0.00           C  
ATOM    750  CG  GLN A  55      22.720  21.158  16.238  1.00  0.00           C  
ATOM    751  CD  GLN A  55      23.297  21.315  17.631  1.00  0.00           C  
ATOM    752  OE1 GLN A  55      24.232  20.611  18.012  1.00  0.00           O  
ATOM    753  NE2 GLN A  55      22.741  22.244  18.401  1.00  0.00           N  
ATOM    754  H   GLN A  55      23.249  24.009  13.211  1.00  0.00           H  
ATOM    755  HA  GLN A  55      23.844  21.181  13.769  1.00  0.00           H  
ATOM    756  HB2 GLN A  55      23.920  22.819  15.685  1.00  0.00           H  
ATOM    757  HB3 GLN A  55      22.193  23.060  15.459  1.00  0.00           H  
ATOM    758  HG2 GLN A  55      21.650  21.032  16.321  1.00  0.00           H  
ATOM    759  HG3 GLN A  55      23.150  20.277  15.784  1.00  0.00           H  
ATOM    760 HE21 GLN A  55      21.998  22.767  18.031  1.00  0.00           H  
ATOM    761 HE22 GLN A  55      23.093  22.366  19.306  1.00  0.00           H  
ATOM    762  N   GLN A  56      21.610  20.254  13.178  1.00  0.00           N  
ATOM    763  CA  GLN A  56      20.364  19.710  12.652  1.00  0.00           C  
ATOM    764  C   GLN A  56      19.225  19.888  13.652  1.00  0.00           C  
ATOM    765  O   GLN A  56      19.414  20.461  14.726  1.00  0.00           O  
ATOM    766  CB  GLN A  56      20.533  18.227  12.314  1.00  0.00           C  
ATOM    767  CG  GLN A  56      20.764  17.348  13.531  1.00  0.00           C  
ATOM    768  CD  GLN A  56      21.248  15.958  13.165  1.00  0.00           C  
ATOM    769  OE1 GLN A  56      22.451  15.717  13.057  1.00  0.00           O  
ATOM    770  NE2 GLN A  56      20.313  15.037  12.971  1.00  0.00           N  
ATOM    771  H   GLN A  56      22.325  19.641  13.443  1.00  0.00           H  
ATOM    772  HA  GLN A  56      20.121  20.250  11.749  1.00  0.00           H  
ATOM    773  HB2 GLN A  56      19.644  17.881  11.809  1.00  0.00           H  
ATOM    774  HB3 GLN A  56      21.379  18.116  11.650  1.00  0.00           H  
ATOM    775  HG2 GLN A  56      21.505  17.816  14.162  1.00  0.00           H  
ATOM    776  HG3 GLN A  56      19.835  17.258  14.075  1.00  0.00           H  
ATOM    777 HE21 GLN A  56      19.374  15.303  13.072  1.00  0.00           H  
ATOM    778 HE22 GLN A  56      20.597  14.131  12.732  1.00  0.00           H  
ATOM    779  N   LEU A  57      18.046  19.394  13.292  1.00  0.00           N  
ATOM    780  CA  LEU A  57      16.877  19.499  14.158  1.00  0.00           C  
ATOM    781  C   LEU A  57      16.503  20.959  14.394  1.00  0.00           C  
ATOM    782  O   LEU A  57      16.134  21.344  15.504  1.00  0.00           O  
ATOM    783  CB  LEU A  57      17.144  18.807  15.496  1.00  0.00           C  
ATOM    784  CG  LEU A  57      17.333  17.291  15.440  1.00  0.00           C  
ATOM    785  CD1 LEU A  57      18.101  16.803  16.659  1.00  0.00           C  
ATOM    786  CD2 LEU A  57      15.986  16.589  15.341  1.00  0.00           C  
ATOM    787  H   LEU A  57      17.958  18.949  12.424  1.00  0.00           H  
ATOM    788  HA  LEU A  57      16.053  19.005  13.664  1.00  0.00           H  
ATOM    789  HB2 LEU A  57      18.041  19.236  15.916  1.00  0.00           H  
ATOM    790  HB3 LEU A  57      16.308  19.014  16.147  1.00  0.00           H  
ATOM    791  HG  LEU A  57      17.909  17.038  14.561  1.00  0.00           H  
ATOM    792 HD11 LEU A  57      18.162  15.725  16.639  1.00  0.00           H  
ATOM    793 HD12 LEU A  57      17.588  17.118  17.557  1.00  0.00           H  
ATOM    794 HD13 LEU A  57      19.097  17.222  16.649  1.00  0.00           H  
ATOM    795 HD21 LEU A  57      16.137  15.565  15.031  1.00  0.00           H  
ATOM    796 HD22 LEU A  57      15.369  17.098  14.614  1.00  0.00           H  
ATOM    797 HD23 LEU A  57      15.499  16.607  16.304  1.00  0.00           H  
ATOM    798  N   ASP A  58      16.600  21.766  13.344  1.00  0.00           N  
ATOM    799  CA  ASP A  58      16.269  23.184  13.436  1.00  0.00           C  
ATOM    800  C   ASP A  58      15.216  23.564  12.398  1.00  0.00           C  
ATOM    801  O   ASP A  58      14.978  22.828  11.441  1.00  0.00           O  
ATOM    802  CB  ASP A  58      17.524  24.036  13.242  1.00  0.00           C  
ATOM    803  CG  ASP A  58      18.234  24.326  14.550  1.00  0.00           C  
ATOM    804  OD1 ASP A  58      18.097  23.518  15.492  1.00  0.00           O  
ATOM    805  OD2 ASP A  58      18.927  25.361  14.632  1.00  0.00           O  
ATOM    806  H   ASP A  58      16.901  21.400  12.486  1.00  0.00           H  
ATOM    807  HA  ASP A  58      15.869  23.367  14.421  1.00  0.00           H  
ATOM    808  HB2 ASP A  58      18.210  23.513  12.591  1.00  0.00           H  
ATOM    809  HB3 ASP A  58      17.247  24.975  12.787  1.00  0.00           H  
ATOM    810  N   THR A  59      14.590  24.720  12.595  1.00  0.00           N  
ATOM    811  CA  THR A  59      13.561  25.197  11.679  1.00  0.00           C  
ATOM    812  C   THR A  59      14.065  26.375  10.853  1.00  0.00           C  
ATOM    813  O   THR A  59      14.543  27.370  11.398  1.00  0.00           O  
ATOM    814  CB  THR A  59      12.289  25.622  12.436  1.00  0.00           C  
ATOM    815  OG1 THR A  59      11.682  24.481  13.053  1.00  0.00           O  
ATOM    816  CG2 THR A  59      11.295  26.285  11.494  1.00  0.00           C  
ATOM    817  H   THR A  59      14.825  25.262  13.376  1.00  0.00           H  
ATOM    818  HA  THR A  59      13.305  24.385  11.013  1.00  0.00           H  
ATOM    819  HB  THR A  59      12.564  26.333  13.202  1.00  0.00           H  
ATOM    820  HG1 THR A  59      11.412  24.706  13.946  1.00  0.00           H  
ATOM    821 HG21 THR A  59      10.332  25.804  11.589  1.00  0.00           H  
ATOM    822 HG22 THR A  59      11.645  26.190  10.476  1.00  0.00           H  
ATOM    823 HG23 THR A  59      11.202  27.330  11.746  1.00  0.00           H  
ATOM    824  N   VAL A  60      13.955  26.256   9.533  1.00  0.00           N  
ATOM    825  CA  VAL A  60      14.398  27.312   8.632  1.00  0.00           C  
ATOM    826  C   VAL A  60      13.419  28.481   8.631  1.00  0.00           C  
ATOM    827  O   VAL A  60      12.286  28.357   8.164  1.00  0.00           O  
ATOM    828  CB  VAL A  60      14.557  26.790   7.191  1.00  0.00           C  
ATOM    829  CG1 VAL A  60      15.233  27.835   6.316  1.00  0.00           C  
ATOM    830  CG2 VAL A  60      15.340  25.486   7.181  1.00  0.00           C  
ATOM    831  H   VAL A  60      13.566  25.439   9.158  1.00  0.00           H  
ATOM    832  HA  VAL A  60      15.361  27.662   8.973  1.00  0.00           H  
ATOM    833  HB  VAL A  60      13.573  26.597   6.789  1.00  0.00           H  
ATOM    834 HG11 VAL A  60      14.723  27.890   5.364  1.00  0.00           H  
ATOM    835 HG12 VAL A  60      15.189  28.797   6.805  1.00  0.00           H  
ATOM    836 HG13 VAL A  60      16.264  27.558   6.156  1.00  0.00           H  
ATOM    837 HG21 VAL A  60      14.862  24.775   7.837  1.00  0.00           H  
ATOM    838 HG22 VAL A  60      15.366  25.089   6.176  1.00  0.00           H  
ATOM    839 HG23 VAL A  60      16.348  25.669   7.521  1.00  0.00           H  
ATOM    840  N   LEU A  61      13.864  29.618   9.157  1.00  0.00           N  
ATOM    841  CA  LEU A  61      13.026  30.811   9.218  1.00  0.00           C  
ATOM    842  C   LEU A  61      13.111  31.602   7.916  1.00  0.00           C  
ATOM    843  O   LEU A  61      12.110  31.793   7.229  1.00  0.00           O  
ATOM    844  CB  LEU A  61      13.449  31.694  10.394  1.00  0.00           C  
ATOM    845  CG  LEU A  61      13.164  31.136  11.788  1.00  0.00           C  
ATOM    846  CD1 LEU A  61      13.635  32.108  12.859  1.00  0.00           C  
ATOM    847  CD2 LEU A  61      11.681  30.836  11.951  1.00  0.00           C  
ATOM    848  H   LEU A  61      14.775  29.656   9.513  1.00  0.00           H  
ATOM    849  HA  LEU A  61      12.006  30.492   9.365  1.00  0.00           H  
ATOM    850  HB2 LEU A  61      14.512  31.863  10.315  1.00  0.00           H  
ATOM    851  HB3 LEU A  61      12.928  32.637  10.301  1.00  0.00           H  
ATOM    852  HG  LEU A  61      13.710  30.210  11.916  1.00  0.00           H  
ATOM    853 HD11 LEU A  61      14.415  32.736  12.457  1.00  0.00           H  
ATOM    854 HD12 LEU A  61      14.016  31.555  13.705  1.00  0.00           H  
ATOM    855 HD13 LEU A  61      12.805  32.723  13.175  1.00  0.00           H  
ATOM    856 HD21 LEU A  61      11.489  30.513  12.964  1.00  0.00           H  
ATOM    857 HD22 LEU A  61      11.395  30.054  11.263  1.00  0.00           H  
ATOM    858 HD23 LEU A  61      11.109  31.727  11.743  1.00  0.00           H  
ATOM    859  N   GLN A  62      14.316  32.059   7.585  1.00  0.00           N  
ATOM    860  CA  GLN A  62      14.531  32.828   6.365  1.00  0.00           C  
ATOM    861  C   GLN A  62      15.880  32.490   5.740  1.00  0.00           C  
ATOM    862  O   GLN A  62      16.872  32.298   6.444  1.00  0.00           O  
ATOM    863  CB  GLN A  62      14.454  34.327   6.662  1.00  0.00           C  
ATOM    864  CG  GLN A  62      15.549  34.819   7.596  1.00  0.00           C  
ATOM    865  CD  GLN A  62      15.348  36.260   8.020  1.00  0.00           C  
ATOM    866  OE1 GLN A  62      15.575  36.615   9.177  1.00  0.00           O  
ATOM    867  NE2 GLN A  62      14.922  37.100   7.085  1.00  0.00           N  
ATOM    868  H   GLN A  62      15.075  31.875   8.175  1.00  0.00           H  
ATOM    869  HA  GLN A  62      13.750  32.569   5.667  1.00  0.00           H  
ATOM    870  HB2 GLN A  62      14.532  34.870   5.733  1.00  0.00           H  
ATOM    871  HB3 GLN A  62      13.499  34.543   7.118  1.00  0.00           H  
ATOM    872  HG2 GLN A  62      15.558  34.197   8.479  1.00  0.00           H  
ATOM    873  HG3 GLN A  62      16.499  34.736   7.089  1.00  0.00           H  
ATOM    874 HE21 GLN A  62      14.762  36.746   6.184  1.00  0.00           H  
ATOM    875 HE22 GLN A  62      14.784  38.037   7.332  1.00  0.00           H  
ATOM    876  N   LEU A  63      15.909  32.418   4.413  1.00  0.00           N  
ATOM    877  CA  LEU A  63      17.138  32.102   3.692  1.00  0.00           C  
ATOM    878  C   LEU A  63      17.616  33.302   2.880  1.00  0.00           C  
ATOM    879  O   LEU A  63      16.812  34.030   2.299  1.00  0.00           O  
ATOM    880  CB  LEU A  63      16.916  30.903   2.769  1.00  0.00           C  
ATOM    881  CG  LEU A  63      18.150  30.391   2.025  1.00  0.00           C  
ATOM    882  CD1 LEU A  63      18.865  29.328   2.844  1.00  0.00           C  
ATOM    883  CD2 LEU A  63      17.761  29.844   0.660  1.00  0.00           C  
ATOM    884  H   LEU A  63      15.087  32.580   3.907  1.00  0.00           H  
ATOM    885  HA  LEU A  63      17.894  31.851   4.420  1.00  0.00           H  
ATOM    886  HB2 LEU A  63      16.532  30.092   3.367  1.00  0.00           H  
ATOM    887  HB3 LEU A  63      16.177  31.186   2.032  1.00  0.00           H  
ATOM    888  HG  LEU A  63      18.837  31.213   1.873  1.00  0.00           H  
ATOM    889 HD11 LEU A  63      18.215  28.986   3.635  1.00  0.00           H  
ATOM    890 HD12 LEU A  63      19.764  29.747   3.272  1.00  0.00           H  
ATOM    891 HD13 LEU A  63      19.126  28.497   2.205  1.00  0.00           H  
ATOM    892 HD21 LEU A  63      18.112  30.514  -0.111  1.00  0.00           H  
ATOM    893 HD22 LEU A  63      16.686  29.759   0.599  1.00  0.00           H  
ATOM    894 HD23 LEU A  63      18.207  28.870   0.522  1.00  0.00           H  
ATOM    895  N   ASN A  64      18.930  33.499   2.843  1.00  0.00           N  
ATOM    896  CA  ASN A  64      19.515  34.609   2.102  1.00  0.00           C  
ATOM    897  C   ASN A  64      18.704  35.885   2.301  1.00  0.00           C  
ATOM    898  O   ASN A  64      18.447  36.624   1.351  1.00  0.00           O  
ATOM    899  CB  ASN A  64      19.594  34.269   0.612  1.00  0.00           C  
ATOM    900  CG  ASN A  64      20.904  33.601   0.240  1.00  0.00           C  
ATOM    901  OD1 ASN A  64      21.932  34.263   0.093  1.00  0.00           O  
ATOM    902  ND2 ASN A  64      20.871  32.282   0.084  1.00  0.00           N  
ATOM    903  H   ASN A  64      19.519  32.884   3.328  1.00  0.00           H  
ATOM    904  HA  ASN A  64      20.515  34.770   2.478  1.00  0.00           H  
ATOM    905  HB2 ASN A  64      18.786  33.598   0.359  1.00  0.00           H  
ATOM    906  HB3 ASN A  64      19.497  35.177   0.035  1.00  0.00           H  
ATOM    907 HD21 ASN A  64      20.017  31.821   0.216  1.00  0.00           H  
ATOM    908 HD22 ASN A  64      21.704  31.825  -0.155  1.00  0.00           H  
ATOM    909  N   GLU A  65      18.302  36.138   3.543  1.00  0.00           N  
ATOM    910  CA  GLU A  65      17.519  37.324   3.866  1.00  0.00           C  
ATOM    911  C   GLU A  65      16.158  37.282   3.179  1.00  0.00           C  
ATOM    912  O   GLU A  65      15.615  38.316   2.789  1.00  0.00           O  
ATOM    913  CB  GLU A  65      18.274  38.589   3.452  1.00  0.00           C  
ATOM    914  CG  GLU A  65      19.623  38.745   4.132  1.00  0.00           C  
ATOM    915  CD  GLU A  65      20.570  39.638   3.355  1.00  0.00           C  
ATOM    916  OE1 GLU A  65      21.227  39.135   2.419  1.00  0.00           O  
ATOM    917  OE2 GLU A  65      20.654  40.840   3.682  1.00  0.00           O  
ATOM    918  H   GLU A  65      18.538  35.511   4.258  1.00  0.00           H  
ATOM    919  HA  GLU A  65      17.369  37.341   4.935  1.00  0.00           H  
ATOM    920  HB2 GLU A  65      18.433  38.564   2.383  1.00  0.00           H  
ATOM    921  HB3 GLU A  65      17.670  39.450   3.695  1.00  0.00           H  
ATOM    922  HG2 GLU A  65      19.471  39.174   5.111  1.00  0.00           H  
ATOM    923  HG3 GLU A  65      20.075  37.769   4.235  1.00  0.00           H  
ATOM    924  N   ARG A  66      15.613  36.079   3.032  1.00  0.00           N  
ATOM    925  CA  ARG A  66      14.316  35.901   2.391  1.00  0.00           C  
ATOM    926  C   ARG A  66      13.424  34.976   3.213  1.00  0.00           C  
ATOM    927  O   ARG A  66      13.877  33.985   3.788  1.00  0.00           O  
ATOM    928  CB  ARG A  66      14.495  35.333   0.981  1.00  0.00           C  
ATOM    929  CG  ARG A  66      15.238  36.266   0.038  1.00  0.00           C  
ATOM    930  CD  ARG A  66      14.994  35.897  -1.417  1.00  0.00           C  
ATOM    931  NE  ARG A  66      13.645  36.246  -1.852  1.00  0.00           N  
ATOM    932  CZ  ARG A  66      13.129  35.873  -3.018  1.00  0.00           C  
ATOM    933  NH1 ARG A  66      13.846  35.143  -3.861  1.00  0.00           N  
ATOM    934  NH2 ARG A  66      11.893  36.231  -3.343  1.00  0.00           N  
ATOM    935  H   ARG A  66      16.094  35.292   3.363  1.00  0.00           H  
ATOM    936  HA  ARG A  66      13.844  36.869   2.321  1.00  0.00           H  
ATOM    937  HB2 ARG A  66      15.048  34.408   1.046  1.00  0.00           H  
ATOM    938  HB3 ARG A  66      13.521  35.132   0.561  1.00  0.00           H  
ATOM    939  HG2 ARG A  66      14.895  37.277   0.203  1.00  0.00           H  
ATOM    940  HG3 ARG A  66      16.295  36.203   0.244  1.00  0.00           H  
ATOM    941  HD2 ARG A  66      15.709  36.424  -2.032  1.00  0.00           H  
ATOM    942  HD3 ARG A  66      15.136  34.832  -1.533  1.00  0.00           H  
ATOM    943  HE  ARG A  66      13.098  36.786  -1.245  1.00  0.00           H  
ATOM    944 HH11 ARG A  66      14.777  34.872  -3.619  1.00  0.00           H  
ATOM    945 HH12 ARG A  66      13.455  34.863  -4.738  1.00  0.00           H  
ATOM    946 HH21 ARG A  66      11.349  36.781  -2.710  1.00  0.00           H  
ATOM    947 HH22 ARG A  66      11.505  35.950  -4.220  1.00  0.00           H  
ATOM    948  N   PRO A  67      12.126  35.305   3.273  1.00  0.00           N  
ATOM    949  CA  PRO A  67      11.143  34.517   4.024  1.00  0.00           C  
ATOM    950  C   PRO A  67      10.870  33.164   3.377  1.00  0.00           C  
ATOM    951  O   PRO A  67      10.493  33.088   2.208  1.00  0.00           O  
ATOM    952  CB  PRO A  67       9.886  35.390   3.988  1.00  0.00           C  
ATOM    953  CG  PRO A  67      10.040  36.226   2.764  1.00  0.00           C  
ATOM    954  CD  PRO A  67      11.516  36.473   2.614  1.00  0.00           C  
ATOM    955  HA  PRO A  67      11.451  34.370   5.049  1.00  0.00           H  
ATOM    956  HB2 PRO A  67       9.009  34.761   3.928  1.00  0.00           H  
ATOM    957  HB3 PRO A  67       9.840  35.999   4.878  1.00  0.00           H  
ATOM    958  HG2 PRO A  67       9.660  35.694   1.905  1.00  0.00           H  
ATOM    959  HG3 PRO A  67       9.516  37.162   2.890  1.00  0.00           H  
ATOM    960  HD2 PRO A  67      11.788  36.510   1.569  1.00  0.00           H  
ATOM    961  HD3 PRO A  67      11.798  37.387   3.113  1.00  0.00           H  
ATOM    962  N   VAL A  68      11.064  32.097   4.146  1.00  0.00           N  
ATOM    963  CA  VAL A  68      10.837  30.745   3.648  1.00  0.00           C  
ATOM    964  C   VAL A  68       9.988  29.936   4.622  1.00  0.00           C  
ATOM    965  O   VAL A  68      10.011  28.706   4.607  1.00  0.00           O  
ATOM    966  CB  VAL A  68      12.166  30.006   3.406  1.00  0.00           C  
ATOM    967  CG1 VAL A  68      13.071  30.818   2.491  1.00  0.00           C  
ATOM    968  CG2 VAL A  68      12.858  29.709   4.728  1.00  0.00           C  
ATOM    969  H   VAL A  68      11.365  32.221   5.069  1.00  0.00           H  
ATOM    970  HA  VAL A  68      10.313  30.819   2.706  1.00  0.00           H  
ATOM    971  HB  VAL A  68      11.948  29.067   2.919  1.00  0.00           H  
ATOM    972 HG11 VAL A  68      13.425  31.691   3.019  1.00  0.00           H  
ATOM    973 HG12 VAL A  68      13.911  30.213   2.187  1.00  0.00           H  
ATOM    974 HG13 VAL A  68      12.515  31.127   1.618  1.00  0.00           H  
ATOM    975 HG21 VAL A  68      13.927  29.675   4.573  1.00  0.00           H  
ATOM    976 HG22 VAL A  68      12.622  30.485   5.440  1.00  0.00           H  
ATOM    977 HG23 VAL A  68      12.519  28.756   5.106  1.00  0.00           H  
ATOM    978  N   GLU A  69       9.239  30.635   5.469  1.00  0.00           N  
ATOM    979  CA  GLU A  69       8.383  29.982   6.451  1.00  0.00           C  
ATOM    980  C   GLU A  69       7.298  29.157   5.764  1.00  0.00           C  
ATOM    981  O   GLU A  69       6.828  28.156   6.304  1.00  0.00           O  
ATOM    982  CB  GLU A  69       7.742  31.020   7.375  1.00  0.00           C  
ATOM    983  CG  GLU A  69       8.636  31.445   8.526  1.00  0.00           C  
ATOM    984  CD  GLU A  69       7.940  32.385   9.490  1.00  0.00           C  
ATOM    985  OE1 GLU A  69       7.357  33.385   9.024  1.00  0.00           O  
ATOM    986  OE2 GLU A  69       7.977  32.121  10.710  1.00  0.00           O  
ATOM    987  H   GLU A  69       9.263  31.615   5.432  1.00  0.00           H  
ATOM    988  HA  GLU A  69       8.999  29.321   7.042  1.00  0.00           H  
ATOM    989  HB2 GLU A  69       7.496  31.897   6.794  1.00  0.00           H  
ATOM    990  HB3 GLU A  69       6.833  30.605   7.786  1.00  0.00           H  
ATOM    991  HG2 GLU A  69       8.946  30.563   9.069  1.00  0.00           H  
ATOM    992  HG3 GLU A  69       9.507  31.942   8.126  1.00  0.00           H  
ATOM    993  N   HIS A  70       6.905  29.587   4.568  1.00  0.00           N  
ATOM    994  CA  HIS A  70       5.876  28.890   3.806  1.00  0.00           C  
ATOM    995  C   HIS A  70       6.465  28.255   2.550  1.00  0.00           C  
ATOM    996  O   HIS A  70       5.772  28.080   1.548  1.00  0.00           O  
ATOM    997  CB  HIS A  70       4.751  29.853   3.425  1.00  0.00           C  
ATOM    998  CG  HIS A  70       3.504  29.167   2.961  1.00  0.00           C  
ATOM    999  ND1 HIS A  70       2.616  29.738   2.075  1.00  0.00           N  
ATOM   1000  CD2 HIS A  70       3.001  27.948   3.263  1.00  0.00           C  
ATOM   1001  CE1 HIS A  70       1.618  28.901   1.854  1.00  0.00           C  
ATOM   1002  NE2 HIS A  70       1.828  27.806   2.563  1.00  0.00           N  
ATOM   1003  H   HIS A  70       7.317  30.391   4.191  1.00  0.00           H  
ATOM   1004  HA  HIS A  70       5.471  28.108   4.432  1.00  0.00           H  
ATOM   1005  HB2 HIS A  70       4.498  30.456   4.284  1.00  0.00           H  
ATOM   1006  HB3 HIS A  70       5.094  30.497   2.628  1.00  0.00           H  
ATOM   1007  HD1 HIS A  70       2.702  30.626   1.670  1.00  0.00           H  
ATOM   1008  HD2 HIS A  70       3.438  27.220   3.932  1.00  0.00           H  
ATOM   1009  HE1 HIS A  70       0.775  29.080   1.204  1.00  0.00           H  
ATOM   1010  HE2 HIS A  70       1.198  27.061   2.649  1.00  0.00           H  
ATOM   1011  N   TRP A  71       7.748  27.914   2.612  1.00  0.00           N  
ATOM   1012  CA  TRP A  71       8.430  27.300   1.478  1.00  0.00           C  
ATOM   1013  C   TRP A  71       8.593  25.799   1.689  1.00  0.00           C  
ATOM   1014  O   TRP A  71       8.625  25.321   2.822  1.00  0.00           O  
ATOM   1015  CB  TRP A  71       9.799  27.950   1.269  1.00  0.00           C  
ATOM   1016  CG  TRP A  71       9.718  29.346   0.730  1.00  0.00           C  
ATOM   1017  CD1 TRP A  71       8.654  30.197   0.818  1.00  0.00           C  
ATOM   1018  CD2 TRP A  71      10.741  30.052   0.020  1.00  0.00           C  
ATOM   1019  NE1 TRP A  71       8.954  31.390   0.205  1.00  0.00           N  
ATOM   1020  CE2 TRP A  71      10.228  31.327  -0.292  1.00  0.00           C  
ATOM   1021  CE3 TRP A  71      12.041  29.732  -0.381  1.00  0.00           C  
ATOM   1022  CZ2 TRP A  71      10.972  32.277  -0.987  1.00  0.00           C  
ATOM   1023  CZ3 TRP A  71      12.777  30.677  -1.070  1.00  0.00           C  
ATOM   1024  CH2 TRP A  71      12.241  31.938  -1.367  1.00  0.00           C  
ATOM   1025  H   TRP A  71       8.247  28.079   3.439  1.00  0.00           H  
ATOM   1026  HA  TRP A  71       7.825  27.465   0.599  1.00  0.00           H  
ATOM   1027  HB2 TRP A  71      10.321  27.987   2.212  1.00  0.00           H  
ATOM   1028  HB3 TRP A  71      10.368  27.355   0.570  1.00  0.00           H  
ATOM   1029  HD1 TRP A  71       7.718  29.955   1.299  1.00  0.00           H  
ATOM   1030  HE1 TRP A  71       8.353  32.162   0.136  1.00  0.00           H  
ATOM   1031  HE3 TRP A  71      12.471  28.766  -0.162  1.00  0.00           H  
ATOM   1032  HZ2 TRP A  71      10.573  33.253  -1.222  1.00  0.00           H  
ATOM   1033  HZ3 TRP A  71      13.783  30.447  -1.389  1.00  0.00           H  
ATOM   1034  HH2 TRP A  71      12.851  32.644  -1.908  1.00  0.00           H  
ATOM   1035  N   LYS A  72       8.695  25.060   0.590  1.00  0.00           N  
ATOM   1036  CA  LYS A  72       8.857  23.612   0.653  1.00  0.00           C  
ATOM   1037  C   LYS A  72      10.238  23.196   0.156  1.00  0.00           C  
ATOM   1038  O   LYS A  72      10.896  23.941  -0.569  1.00  0.00           O  
ATOM   1039  CB  LYS A  72       7.774  22.921  -0.178  1.00  0.00           C  
ATOM   1040  CG  LYS A  72       6.361  23.322   0.210  1.00  0.00           C  
ATOM   1041  CD  LYS A  72       5.324  22.570  -0.608  1.00  0.00           C  
ATOM   1042  CE  LYS A  72       5.114  21.159  -0.083  1.00  0.00           C  
ATOM   1043  NZ  LYS A  72       4.243  21.140   1.125  1.00  0.00           N  
ATOM   1044  H   LYS A  72       8.663  25.499  -0.286  1.00  0.00           H  
ATOM   1045  HA  LYS A  72       8.754  23.311   1.685  1.00  0.00           H  
ATOM   1046  HB2 LYS A  72       7.923  23.168  -1.218  1.00  0.00           H  
ATOM   1047  HB3 LYS A  72       7.869  21.851  -0.054  1.00  0.00           H  
ATOM   1048  HG2 LYS A  72       6.207  23.100   1.256  1.00  0.00           H  
ATOM   1049  HG3 LYS A  72       6.239  24.382   0.043  1.00  0.00           H  
ATOM   1050  HD2 LYS A  72       4.386  23.104  -0.561  1.00  0.00           H  
ATOM   1051  HD3 LYS A  72       5.658  22.518  -1.635  1.00  0.00           H  
ATOM   1052  HE2 LYS A  72       4.653  20.565  -0.857  1.00  0.00           H  
ATOM   1053  HE3 LYS A  72       6.076  20.737   0.170  1.00  0.00           H  
ATOM   1054  HZ1 LYS A  72       3.667  20.275   1.137  1.00  0.00           H  
ATOM   1055  HZ2 LYS A  72       3.610  21.965   1.121  1.00  0.00           H  
ATOM   1056  HZ3 LYS A  72       4.825  21.168   1.987  1.00  0.00           H  
ATOM   1057  N   CYS A  73      10.667  22.002   0.548  1.00  0.00           N  
ATOM   1058  CA  CYS A  73      11.970  21.487   0.141  1.00  0.00           C  
ATOM   1059  C   CYS A  73      12.323  21.953  -1.267  1.00  0.00           C  
ATOM   1060  O   CYS A  73      13.431  22.426  -1.517  1.00  0.00           O  
ATOM   1061  CB  CYS A  73      11.979  19.958   0.203  1.00  0.00           C  
ATOM   1062  SG  CYS A  73      10.743  19.170  -0.854  1.00  0.00           S  
ATOM   1063  H   CYS A  73      10.096  21.454   1.126  1.00  0.00           H  
ATOM   1064  HA  CYS A  73      12.707  21.870   0.830  1.00  0.00           H  
ATOM   1065  HB2 CYS A  73      12.950  19.598  -0.104  1.00  0.00           H  
ATOM   1066  HB3 CYS A  73      11.792  19.646   1.219  1.00  0.00           H  
ATOM   1067  HG  CYS A  73      10.074  18.295  -0.118  1.00  0.00           H  
ATOM   1068  N   VAL A  74      11.372  21.814  -2.187  1.00  0.00           N  
ATOM   1069  CA  VAL A  74      11.583  22.220  -3.572  1.00  0.00           C  
ATOM   1070  C   VAL A  74      11.780  23.728  -3.677  1.00  0.00           C  
ATOM   1071  O   VAL A  74      12.803  24.196  -4.177  1.00  0.00           O  
ATOM   1072  CB  VAL A  74      10.400  21.804  -4.465  1.00  0.00           C  
ATOM   1073  CG1 VAL A  74      10.647  22.219  -5.907  1.00  0.00           C  
ATOM   1074  CG2 VAL A  74      10.159  20.304  -4.365  1.00  0.00           C  
ATOM   1075  H   VAL A  74      10.509  21.430  -1.928  1.00  0.00           H  
ATOM   1076  HA  VAL A  74      12.472  21.724  -3.933  1.00  0.00           H  
ATOM   1077  HB  VAL A  74       9.514  22.313  -4.114  1.00  0.00           H  
ATOM   1078 HG11 VAL A  74      11.686  22.056  -6.154  1.00  0.00           H  
ATOM   1079 HG12 VAL A  74      10.023  21.629  -6.564  1.00  0.00           H  
ATOM   1080 HG13 VAL A  74      10.408  23.265  -6.026  1.00  0.00           H  
ATOM   1081 HG21 VAL A  74      10.968  19.847  -3.816  1.00  0.00           H  
ATOM   1082 HG22 VAL A  74       9.227  20.122  -3.852  1.00  0.00           H  
ATOM   1083 HG23 VAL A  74      10.112  19.881  -5.357  1.00  0.00           H  
ATOM   1084  N   GLU A  75      10.793  24.483  -3.205  1.00  0.00           N  
ATOM   1085  CA  GLU A  75      10.859  25.939  -3.247  1.00  0.00           C  
ATOM   1086  C   GLU A  75      12.191  26.440  -2.698  1.00  0.00           C  
ATOM   1087  O   GLU A  75      12.873  27.248  -3.330  1.00  0.00           O  
ATOM   1088  CB  GLU A  75       9.704  26.547  -2.449  1.00  0.00           C  
ATOM   1089  CG  GLU A  75       9.493  28.028  -2.715  1.00  0.00           C  
ATOM   1090  CD  GLU A  75       8.222  28.560  -2.083  1.00  0.00           C  
ATOM   1091  OE1 GLU A  75       7.250  27.785  -1.960  1.00  0.00           O  
ATOM   1092  OE2 GLU A  75       8.199  29.752  -1.711  1.00  0.00           O  
ATOM   1093  H   GLU A  75      10.003  24.051  -2.819  1.00  0.00           H  
ATOM   1094  HA  GLU A  75      10.771  26.245  -4.279  1.00  0.00           H  
ATOM   1095  HB2 GLU A  75       8.793  26.024  -2.700  1.00  0.00           H  
ATOM   1096  HB3 GLU A  75       9.903  26.417  -1.395  1.00  0.00           H  
ATOM   1097  HG2 GLU A  75      10.332  28.576  -2.315  1.00  0.00           H  
ATOM   1098  HG3 GLU A  75       9.439  28.185  -3.783  1.00  0.00           H  
ATOM   1099  N   LEU A  76      12.555  25.956  -1.516  1.00  0.00           N  
ATOM   1100  CA  LEU A  76      13.806  26.355  -0.878  1.00  0.00           C  
ATOM   1101  C   LEU A  76      15.006  25.848  -1.670  1.00  0.00           C  
ATOM   1102  O   LEU A  76      15.845  26.631  -2.116  1.00  0.00           O  
ATOM   1103  CB  LEU A  76      13.865  25.821   0.554  1.00  0.00           C  
ATOM   1104  CG  LEU A  76      15.063  26.271   1.390  1.00  0.00           C  
ATOM   1105  CD1 LEU A  76      15.258  27.775   1.277  1.00  0.00           C  
ATOM   1106  CD2 LEU A  76      14.882  25.862   2.845  1.00  0.00           C  
ATOM   1107  H   LEU A  76      11.971  25.316  -1.059  1.00  0.00           H  
ATOM   1108  HA  LEU A  76      13.836  27.434  -0.852  1.00  0.00           H  
ATOM   1109  HB2 LEU A  76      12.968  26.141   1.064  1.00  0.00           H  
ATOM   1110  HB3 LEU A  76      13.881  24.741   0.504  1.00  0.00           H  
ATOM   1111  HG  LEU A  76      15.956  25.790   1.015  1.00  0.00           H  
ATOM   1112 HD11 LEU A  76      16.122  28.070   1.854  1.00  0.00           H  
ATOM   1113 HD12 LEU A  76      14.382  28.281   1.657  1.00  0.00           H  
ATOM   1114 HD13 LEU A  76      15.406  28.042   0.241  1.00  0.00           H  
ATOM   1115 HD21 LEU A  76      14.170  25.052   2.905  1.00  0.00           H  
ATOM   1116 HD22 LEU A  76      14.518  26.705   3.413  1.00  0.00           H  
ATOM   1117 HD23 LEU A  76      15.830  25.539   3.248  1.00  0.00           H  
ATOM   1118  N   ALA A  77      15.081  24.532  -1.845  1.00  0.00           N  
ATOM   1119  CA  ALA A  77      16.177  23.921  -2.587  1.00  0.00           C  
ATOM   1120  C   ALA A  77      16.557  24.765  -3.799  1.00  0.00           C  
ATOM   1121  O   ALA A  77      17.734  24.885  -4.140  1.00  0.00           O  
ATOM   1122  CB  ALA A  77      15.799  22.512  -3.021  1.00  0.00           C  
ATOM   1123  H   ALA A  77      14.383  23.960  -1.466  1.00  0.00           H  
ATOM   1124  HA  ALA A  77      17.030  23.852  -1.928  1.00  0.00           H  
ATOM   1125  HB1 ALA A  77      16.391  22.231  -3.880  1.00  0.00           H  
ATOM   1126  HB2 ALA A  77      15.988  21.824  -2.211  1.00  0.00           H  
ATOM   1127  HB3 ALA A  77      14.752  22.485  -3.281  1.00  0.00           H  
ATOM   1128  N   HIS A  78      15.553  25.349  -4.446  1.00  0.00           N  
ATOM   1129  CA  HIS A  78      15.783  26.182  -5.621  1.00  0.00           C  
ATOM   1130  C   HIS A  78      16.609  27.414  -5.260  1.00  0.00           C  
ATOM   1131  O   HIS A  78      17.542  27.778  -5.974  1.00  0.00           O  
ATOM   1132  CB  HIS A  78      14.451  26.609  -6.238  1.00  0.00           C  
ATOM   1133  CG  HIS A  78      13.915  25.634  -7.239  1.00  0.00           C  
ATOM   1134  ND1 HIS A  78      12.588  25.262  -7.292  1.00  0.00           N  
ATOM   1135  CD2 HIS A  78      14.535  24.954  -8.232  1.00  0.00           C  
ATOM   1136  CE1 HIS A  78      12.415  24.394  -8.273  1.00  0.00           C  
ATOM   1137  NE2 HIS A  78      13.580  24.190  -8.859  1.00  0.00           N  
ATOM   1138  H   HIS A  78      14.637  25.216  -4.127  1.00  0.00           H  
ATOM   1139  HA  HIS A  78      16.332  25.596  -6.342  1.00  0.00           H  
ATOM   1140  HB2 HIS A  78      13.717  26.717  -5.454  1.00  0.00           H  
ATOM   1141  HB3 HIS A  78      14.580  27.560  -6.736  1.00  0.00           H  
ATOM   1142  HD1 HIS A  78      11.879  25.585  -6.697  1.00  0.00           H  
ATOM   1143  HD2 HIS A  78      15.584  25.002  -8.485  1.00  0.00           H  
ATOM   1144  HE1 HIS A  78      11.480  23.929  -8.548  1.00  0.00           H  
ATOM   1145  HE2 HIS A  78      13.751  23.527  -9.561  1.00  0.00           H  
ATOM   1146  N   GLU A  79      16.255  28.052  -4.148  1.00  0.00           N  
ATOM   1147  CA  GLU A  79      16.963  29.244  -3.694  1.00  0.00           C  
ATOM   1148  C   GLU A  79      18.396  28.905  -3.292  1.00  0.00           C  
ATOM   1149  O   GLU A  79      19.335  29.622  -3.642  1.00  0.00           O  
ATOM   1150  CB  GLU A  79      16.228  29.882  -2.514  1.00  0.00           C  
ATOM   1151  CG  GLU A  79      16.399  31.390  -2.434  1.00  0.00           C  
ATOM   1152  CD  GLU A  79      16.256  31.919  -1.020  1.00  0.00           C  
ATOM   1153  OE1 GLU A  79      15.434  31.366  -0.259  1.00  0.00           O  
ATOM   1154  OE2 GLU A  79      16.966  32.886  -0.674  1.00  0.00           O  
ATOM   1155  H   GLU A  79      15.502  27.713  -3.621  1.00  0.00           H  
ATOM   1156  HA  GLU A  79      16.988  29.946  -4.514  1.00  0.00           H  
ATOM   1157  HB2 GLU A  79      15.174  29.665  -2.602  1.00  0.00           H  
ATOM   1158  HB3 GLU A  79      16.601  29.449  -1.597  1.00  0.00           H  
ATOM   1159  HG2 GLU A  79      17.381  31.647  -2.801  1.00  0.00           H  
ATOM   1160  HG3 GLU A  79      15.650  31.858  -3.056  1.00  0.00           H  
ATOM   1161  N   ILE A  80      18.555  27.811  -2.556  1.00  0.00           N  
ATOM   1162  CA  ILE A  80      19.872  27.378  -2.108  1.00  0.00           C  
ATOM   1163  C   ILE A  80      20.812  27.163  -3.288  1.00  0.00           C  
ATOM   1164  O   ILE A  80      21.824  27.851  -3.422  1.00  0.00           O  
ATOM   1165  CB  ILE A  80      19.788  26.076  -1.289  1.00  0.00           C  
ATOM   1166  CG1 ILE A  80      19.186  26.351   0.090  1.00  0.00           C  
ATOM   1167  CG2 ILE A  80      21.165  25.445  -1.155  1.00  0.00           C  
ATOM   1168  CD1 ILE A  80      19.091  25.121   0.965  1.00  0.00           C  
ATOM   1169  H   ILE A  80      17.767  27.282  -2.310  1.00  0.00           H  
ATOM   1170  HA  ILE A  80      20.279  28.152  -1.473  1.00  0.00           H  
ATOM   1171  HB  ILE A  80      19.152  25.384  -1.820  1.00  0.00           H  
ATOM   1172 HG12 ILE A  80      19.796  27.077   0.603  1.00  0.00           H  
ATOM   1173 HG13 ILE A  80      18.188  26.750  -0.035  1.00  0.00           H  
ATOM   1174 HG21 ILE A  80      21.816  26.113  -0.610  1.00  0.00           H  
ATOM   1175 HG22 ILE A  80      21.082  24.510  -0.620  1.00  0.00           H  
ATOM   1176 HG23 ILE A  80      21.576  25.262  -2.137  1.00  0.00           H  
ATOM   1177 HD11 ILE A  80      20.024  24.979   1.490  1.00  0.00           H  
ATOM   1178 HD12 ILE A  80      18.290  25.248   1.679  1.00  0.00           H  
ATOM   1179 HD13 ILE A  80      18.890  24.256   0.349  1.00  0.00           H  
ATOM   1180  N   ARG A  81      20.470  26.206  -4.144  1.00  0.00           N  
ATOM   1181  CA  ARG A  81      21.284  25.901  -5.315  1.00  0.00           C  
ATOM   1182  C   ARG A  81      21.681  27.179  -6.048  1.00  0.00           C  
ATOM   1183  O   ARG A  81      22.700  27.219  -6.737  1.00  0.00           O  
ATOM   1184  CB  ARG A  81      20.523  24.972  -6.262  1.00  0.00           C  
ATOM   1185  CG  ARG A  81      19.698  25.709  -7.306  1.00  0.00           C  
ATOM   1186  CD  ARG A  81      18.806  24.755  -8.086  1.00  0.00           C  
ATOM   1187  NE  ARG A  81      19.548  24.027  -9.111  1.00  0.00           N  
ATOM   1188  CZ  ARG A  81      18.975  23.442 -10.157  1.00  0.00           C  
ATOM   1189  NH1 ARG A  81      17.660  23.500 -10.315  1.00  0.00           N  
ATOM   1190  NH2 ARG A  81      19.718  22.797 -11.048  1.00  0.00           N  
ATOM   1191  H   ARG A  81      19.651  25.691  -3.984  1.00  0.00           H  
ATOM   1192  HA  ARG A  81      22.179  25.401  -4.976  1.00  0.00           H  
ATOM   1193  HB2 ARG A  81      21.233  24.342  -6.777  1.00  0.00           H  
ATOM   1194  HB3 ARG A  81      19.858  24.351  -5.682  1.00  0.00           H  
ATOM   1195  HG2 ARG A  81      19.077  26.440  -6.810  1.00  0.00           H  
ATOM   1196  HG3 ARG A  81      20.367  26.206  -7.993  1.00  0.00           H  
ATOM   1197  HD2 ARG A  81      18.372  24.046  -7.397  1.00  0.00           H  
ATOM   1198  HD3 ARG A  81      18.021  25.325  -8.559  1.00  0.00           H  
ATOM   1199  HE  ARG A  81      20.521  23.971  -9.014  1.00  0.00           H  
ATOM   1200 HH11 ARG A  81      17.098  23.986  -9.645  1.00  0.00           H  
ATOM   1201 HH12 ARG A  81      17.232  23.060 -11.104  1.00  0.00           H  
ATOM   1202 HH21 ARG A  81      20.710  22.751 -10.932  1.00  0.00           H  
ATOM   1203 HH22 ARG A  81      19.286  22.358 -11.834  1.00  0.00           H  
ATOM   1204  N   SER A  82      20.870  28.220  -5.894  1.00  0.00           N  
ATOM   1205  CA  SER A  82      21.135  29.498  -6.546  1.00  0.00           C  
ATOM   1206  C   SER A  82      22.626  29.815  -6.533  1.00  0.00           C  
ATOM   1207  O   SER A  82      23.240  30.012  -7.582  1.00  0.00           O  
ATOM   1208  CB  SER A  82      20.357  30.618  -5.852  1.00  0.00           C  
ATOM   1209  OG  SER A  82      20.419  31.821  -6.598  1.00  0.00           O  
ATOM   1210  H   SER A  82      20.073  28.125  -5.332  1.00  0.00           H  
ATOM   1211  HA  SER A  82      20.803  29.422  -7.570  1.00  0.00           H  
ATOM   1212  HB2 SER A  82      19.323  30.326  -5.749  1.00  0.00           H  
ATOM   1213  HB3 SER A  82      20.781  30.794  -4.873  1.00  0.00           H  
ATOM   1214  HG  SER A  82      19.529  32.126  -6.788  1.00  0.00           H  
ATOM   1215  N   CYS A  83      23.204  29.863  -5.337  1.00  0.00           N  
ATOM   1216  CA  CYS A  83      24.625  30.158  -5.185  1.00  0.00           C  
ATOM   1217  C   CYS A  83      25.427  28.877  -4.980  1.00  0.00           C  
ATOM   1218  O   CYS A  83      25.404  28.265  -3.912  1.00  0.00           O  
ATOM   1219  CB  CYS A  83      24.847  31.107  -4.008  1.00  0.00           C  
ATOM   1220  SG  CYS A  83      24.789  32.860  -4.450  1.00  0.00           S  
ATOM   1221  H   CYS A  83      22.663  29.698  -4.537  1.00  0.00           H  
ATOM   1222  HA  CYS A  83      24.962  30.637  -6.092  1.00  0.00           H  
ATOM   1223  HB2 CYS A  83      24.084  30.932  -3.263  1.00  0.00           H  
ATOM   1224  HB3 CYS A  83      25.816  30.909  -3.574  1.00  0.00           H  
ATOM   1225  HG  CYS A  83      25.990  33.214  -4.878  1.00  0.00           H  
ATOM   1226  N   PRO A  84      26.152  28.459  -6.029  1.00  0.00           N  
ATOM   1227  CA  PRO A  84      26.974  27.245  -5.989  1.00  0.00           C  
ATOM   1228  C   PRO A  84      28.191  27.399  -5.083  1.00  0.00           C  
ATOM   1229  O   PRO A  84      28.843  26.416  -4.732  1.00  0.00           O  
ATOM   1230  CB  PRO A  84      27.410  27.064  -7.445  1.00  0.00           C  
ATOM   1231  CG  PRO A  84      27.358  28.434  -8.028  1.00  0.00           C  
ATOM   1232  CD  PRO A  84      26.225  29.138  -7.333  1.00  0.00           C  
ATOM   1233  HA  PRO A  84      26.398  26.387  -5.673  1.00  0.00           H  
ATOM   1234  HB2 PRO A  84      28.412  26.658  -7.475  1.00  0.00           H  
ATOM   1235  HB3 PRO A  84      26.729  26.394  -7.948  1.00  0.00           H  
ATOM   1236  HG2 PRO A  84      28.288  28.947  -7.845  1.00  0.00           H  
ATOM   1237  HG3 PRO A  84      27.165  28.372  -9.090  1.00  0.00           H  
ATOM   1238  HD2 PRO A  84      26.453  30.186  -7.210  1.00  0.00           H  
ATOM   1239  HD3 PRO A  84      25.307  29.011  -7.886  1.00  0.00           H  
ATOM   1240  N   SER A  85      28.491  28.638  -4.708  1.00  0.00           N  
ATOM   1241  CA  SER A  85      29.632  28.921  -3.846  1.00  0.00           C  
ATOM   1242  C   SER A  85      29.242  28.810  -2.375  1.00  0.00           C  
ATOM   1243  O   SER A  85      29.627  27.864  -1.690  1.00  0.00           O  
ATOM   1244  CB  SER A  85      30.183  30.319  -4.135  1.00  0.00           C  
ATOM   1245  OG  SER A  85      30.531  30.457  -5.501  1.00  0.00           O  
ATOM   1246  H   SER A  85      27.932  29.381  -5.021  1.00  0.00           H  
ATOM   1247  HA  SER A  85      30.397  28.191  -4.059  1.00  0.00           H  
ATOM   1248  HB2 SER A  85      29.434  31.056  -3.890  1.00  0.00           H  
ATOM   1249  HB3 SER A  85      31.064  30.488  -3.532  1.00  0.00           H  
ATOM   1250  HG  SER A  85      29.821  30.903  -5.969  1.00  0.00           H  
ATOM   1251  N   GLU A  86      28.476  29.786  -1.897  1.00  0.00           N  
ATOM   1252  CA  GLU A  86      28.034  29.799  -0.507  1.00  0.00           C  
ATOM   1253  C   GLU A  86      26.632  30.389  -0.388  1.00  0.00           C  
ATOM   1254  O   GLU A  86      26.214  31.196  -1.218  1.00  0.00           O  
ATOM   1255  CB  GLU A  86      29.013  30.599   0.354  1.00  0.00           C  
ATOM   1256  CG  GLU A  86      28.480  30.921   1.741  1.00  0.00           C  
ATOM   1257  CD  GLU A  86      27.678  32.207   1.774  1.00  0.00           C  
ATOM   1258  OE1 GLU A  86      28.295  33.287   1.880  1.00  0.00           O  
ATOM   1259  OE2 GLU A  86      26.434  32.133   1.695  1.00  0.00           O  
ATOM   1260  H   GLU A  86      28.201  30.513  -2.493  1.00  0.00           H  
ATOM   1261  HA  GLU A  86      28.013  28.778  -0.157  1.00  0.00           H  
ATOM   1262  HB2 GLU A  86      29.924  30.032   0.464  1.00  0.00           H  
ATOM   1263  HB3 GLU A  86      29.236  31.530  -0.146  1.00  0.00           H  
ATOM   1264  HG2 GLU A  86      27.845  30.110   2.065  1.00  0.00           H  
ATOM   1265  HG3 GLU A  86      29.314  31.016   2.420  1.00  0.00           H  
ATOM   1266  N   ILE A  87      25.912  29.980   0.651  1.00  0.00           N  
ATOM   1267  CA  ILE A  87      24.557  30.468   0.881  1.00  0.00           C  
ATOM   1268  C   ILE A  87      24.304  30.709   2.365  1.00  0.00           C  
ATOM   1269  O   ILE A  87      24.864  30.023   3.220  1.00  0.00           O  
ATOM   1270  CB  ILE A  87      23.504  29.480   0.345  1.00  0.00           C  
ATOM   1271  CG1 ILE A  87      23.672  28.113   1.010  1.00  0.00           C  
ATOM   1272  CG2 ILE A  87      23.613  29.358  -1.167  1.00  0.00           C  
ATOM   1273  CD1 ILE A  87      22.836  27.940   2.258  1.00  0.00           C  
ATOM   1274  H   ILE A  87      26.299  29.336   1.279  1.00  0.00           H  
ATOM   1275  HA  ILE A  87      24.447  31.404   0.351  1.00  0.00           H  
ATOM   1276  HB  ILE A  87      22.525  29.870   0.581  1.00  0.00           H  
ATOM   1277 HG12 ILE A  87      23.386  27.342   0.311  1.00  0.00           H  
ATOM   1278 HG13 ILE A  87      24.709  27.979   1.283  1.00  0.00           H  
ATOM   1279 HG21 ILE A  87      23.119  28.455  -1.492  1.00  0.00           H  
ATOM   1280 HG22 ILE A  87      23.144  30.211  -1.632  1.00  0.00           H  
ATOM   1281 HG23 ILE A  87      24.655  29.320  -1.451  1.00  0.00           H  
ATOM   1282 HD11 ILE A  87      22.816  26.898   2.537  1.00  0.00           H  
ATOM   1283 HD12 ILE A  87      23.263  28.521   3.061  1.00  0.00           H  
ATOM   1284 HD13 ILE A  87      21.828  28.280   2.066  1.00  0.00           H  
ATOM   1285  N   ILE A  88      23.454  31.687   2.663  1.00  0.00           N  
ATOM   1286  CA  ILE A  88      23.124  32.016   4.044  1.00  0.00           C  
ATOM   1287  C   ILE A  88      21.759  31.460   4.430  1.00  0.00           C  
ATOM   1288  O   ILE A  88      20.772  31.658   3.720  1.00  0.00           O  
ATOM   1289  CB  ILE A  88      23.131  33.539   4.277  1.00  0.00           C  
ATOM   1290  CG1 ILE A  88      24.534  34.106   4.051  1.00  0.00           C  
ATOM   1291  CG2 ILE A  88      22.643  33.862   5.681  1.00  0.00           C  
ATOM   1292  CD1 ILE A  88      25.535  33.675   5.100  1.00  0.00           C  
ATOM   1293  H   ILE A  88      23.040  32.198   1.937  1.00  0.00           H  
ATOM   1294  HA  ILE A  88      23.876  31.572   4.681  1.00  0.00           H  
ATOM   1295  HB  ILE A  88      22.449  33.991   3.572  1.00  0.00           H  
ATOM   1296 HG12 ILE A  88      24.898  33.777   3.090  1.00  0.00           H  
ATOM   1297 HG13 ILE A  88      24.484  35.185   4.062  1.00  0.00           H  
ATOM   1298 HG21 ILE A  88      23.414  33.615   6.395  1.00  0.00           H  
ATOM   1299 HG22 ILE A  88      22.414  34.915   5.749  1.00  0.00           H  
ATOM   1300 HG23 ILE A  88      21.756  33.286   5.895  1.00  0.00           H  
ATOM   1301 HD11 ILE A  88      25.128  32.854   5.671  1.00  0.00           H  
ATOM   1302 HD12 ILE A  88      26.449  33.362   4.618  1.00  0.00           H  
ATOM   1303 HD13 ILE A  88      25.743  34.505   5.760  1.00  0.00           H  
ATOM   1304  N   LEU A  89      21.707  30.765   5.561  1.00  0.00           N  
ATOM   1305  CA  LEU A  89      20.461  30.180   6.044  1.00  0.00           C  
ATOM   1306  C   LEU A  89      20.278  30.443   7.536  1.00  0.00           C  
ATOM   1307  O   LEU A  89      21.138  30.096   8.348  1.00  0.00           O  
ATOM   1308  CB  LEU A  89      20.442  28.675   5.774  1.00  0.00           C  
ATOM   1309  CG  LEU A  89      21.597  27.870   6.374  1.00  0.00           C  
ATOM   1310  CD1 LEU A  89      21.189  26.419   6.573  1.00  0.00           C  
ATOM   1311  CD2 LEU A  89      22.830  27.965   5.487  1.00  0.00           C  
ATOM   1312  H   LEU A  89      22.527  30.641   6.084  1.00  0.00           H  
ATOM   1313  HA  LEU A  89      19.647  30.644   5.507  1.00  0.00           H  
ATOM   1314  HB2 LEU A  89      19.521  28.279   6.173  1.00  0.00           H  
ATOM   1315  HB3 LEU A  89      20.460  28.532   4.703  1.00  0.00           H  
ATOM   1316  HG  LEU A  89      21.848  28.281   7.342  1.00  0.00           H  
ATOM   1317 HD11 LEU A  89      21.771  25.789   5.916  1.00  0.00           H  
ATOM   1318 HD12 LEU A  89      20.140  26.305   6.344  1.00  0.00           H  
ATOM   1319 HD13 LEU A  89      21.367  26.132   7.599  1.00  0.00           H  
ATOM   1320 HD21 LEU A  89      22.830  28.914   4.973  1.00  0.00           H  
ATOM   1321 HD22 LEU A  89      22.813  27.163   4.763  1.00  0.00           H  
ATOM   1322 HD23 LEU A  89      23.718  27.883   6.096  1.00  0.00           H  
ATOM   1323  N   LEU A  90      19.155  31.056   7.890  1.00  0.00           N  
ATOM   1324  CA  LEU A  90      18.858  31.363   9.285  1.00  0.00           C  
ATOM   1325  C   LEU A  90      17.937  30.308   9.891  1.00  0.00           C  
ATOM   1326  O   LEU A  90      17.022  29.816   9.232  1.00  0.00           O  
ATOM   1327  CB  LEU A  90      18.212  32.745   9.396  1.00  0.00           C  
ATOM   1328  CG  LEU A  90      17.698  33.136  10.782  1.00  0.00           C  
ATOM   1329  CD1 LEU A  90      18.858  33.478  11.705  1.00  0.00           C  
ATOM   1330  CD2 LEU A  90      16.730  34.307  10.683  1.00  0.00           C  
ATOM   1331  H   LEU A  90      18.509  31.308   7.198  1.00  0.00           H  
ATOM   1332  HA  LEU A  90      19.790  31.366   9.829  1.00  0.00           H  
ATOM   1333  HB2 LEU A  90      18.945  33.479   9.097  1.00  0.00           H  
ATOM   1334  HB3 LEU A  90      17.376  32.775   8.712  1.00  0.00           H  
ATOM   1335  HG  LEU A  90      17.167  32.298  11.212  1.00  0.00           H  
ATOM   1336 HD11 LEU A  90      18.633  34.385  12.244  1.00  0.00           H  
ATOM   1337 HD12 LEU A  90      19.754  33.618  11.119  1.00  0.00           H  
ATOM   1338 HD13 LEU A  90      19.009  32.671  12.407  1.00  0.00           H  
ATOM   1339 HD21 LEU A  90      15.736  33.936  10.482  1.00  0.00           H  
ATOM   1340 HD22 LEU A  90      17.039  34.961   9.880  1.00  0.00           H  
ATOM   1341 HD23 LEU A  90      16.730  34.853  11.614  1.00  0.00           H  
ATOM   1342  N   VAL A  91      18.186  29.969  11.151  1.00  0.00           N  
ATOM   1343  CA  VAL A  91      17.378  28.975  11.849  1.00  0.00           C  
ATOM   1344  C   VAL A  91      17.299  29.280  13.340  1.00  0.00           C  
ATOM   1345  O   VAL A  91      18.085  30.066  13.866  1.00  0.00           O  
ATOM   1346  CB  VAL A  91      17.942  27.556  11.655  1.00  0.00           C  
ATOM   1347  CG1 VAL A  91      18.075  27.231  10.174  1.00  0.00           C  
ATOM   1348  CG2 VAL A  91      19.281  27.414  12.361  1.00  0.00           C  
ATOM   1349  H   VAL A  91      18.929  30.397  11.625  1.00  0.00           H  
ATOM   1350  HA  VAL A  91      16.381  29.004  11.432  1.00  0.00           H  
ATOM   1351  HB  VAL A  91      17.251  26.851  12.093  1.00  0.00           H  
ATOM   1352 HG11 VAL A  91      19.001  27.641   9.797  1.00  0.00           H  
ATOM   1353 HG12 VAL A  91      18.073  26.160  10.038  1.00  0.00           H  
ATOM   1354 HG13 VAL A  91      17.245  27.665   9.635  1.00  0.00           H  
ATOM   1355 HG21 VAL A  91      19.313  28.083  13.208  1.00  0.00           H  
ATOM   1356 HG22 VAL A  91      19.403  26.397  12.703  1.00  0.00           H  
ATOM   1357 HG23 VAL A  91      20.079  27.661  11.677  1.00  0.00           H  
ATOM   1358  N   TRP A  92      16.344  28.651  14.017  1.00  0.00           N  
ATOM   1359  CA  TRP A  92      16.162  28.854  15.449  1.00  0.00           C  
ATOM   1360  C   TRP A  92      16.699  27.666  16.240  1.00  0.00           C  
ATOM   1361  O   TRP A  92      16.350  26.517  15.965  1.00  0.00           O  
ATOM   1362  CB  TRP A  92      14.683  29.069  15.772  1.00  0.00           C  
ATOM   1363  CG  TRP A  92      14.375  28.990  17.236  1.00  0.00           C  
ATOM   1364  CD1 TRP A  92      14.146  27.857  17.965  1.00  0.00           C  
ATOM   1365  CD2 TRP A  92      14.263  30.087  18.149  1.00  0.00           C  
ATOM   1366  NE1 TRP A  92      13.897  28.185  19.277  1.00  0.00           N  
ATOM   1367  CE2 TRP A  92      13.964  29.546  19.415  1.00  0.00           C  
ATOM   1368  CE3 TRP A  92      14.388  31.473  18.021  1.00  0.00           C  
ATOM   1369  CZ2 TRP A  92      13.788  30.344  20.542  1.00  0.00           C  
ATOM   1370  CZ3 TRP A  92      14.212  32.264  19.140  1.00  0.00           C  
ATOM   1371  CH2 TRP A  92      13.915  31.698  20.388  1.00  0.00           C  
ATOM   1372  H   TRP A  92      15.747  28.035  13.542  1.00  0.00           H  
ATOM   1373  HA  TRP A  92      16.715  29.738  15.731  1.00  0.00           H  
ATOM   1374  HB2 TRP A  92      14.383  30.045  15.421  1.00  0.00           H  
ATOM   1375  HB3 TRP A  92      14.099  28.314  15.266  1.00  0.00           H  
ATOM   1376  HD1 TRP A  92      14.159  26.858  17.558  1.00  0.00           H  
ATOM   1377  HE1 TRP A  92      13.705  27.547  19.996  1.00  0.00           H  
ATOM   1378  HE3 TRP A  92      14.616  31.927  17.068  1.00  0.00           H  
ATOM   1379  HZ2 TRP A  92      13.559  29.924  21.511  1.00  0.00           H  
ATOM   1380  HZ3 TRP A  92      14.304  33.337  19.060  1.00  0.00           H  
ATOM   1381  HH2 TRP A  92      13.786  32.355  21.234  1.00  0.00           H  
ATOM   1382  N   ARG A  93      17.549  27.949  17.222  1.00  0.00           N  
ATOM   1383  CA  ARG A  93      18.134  26.902  18.051  1.00  0.00           C  
ATOM   1384  C   ARG A  93      18.015  27.251  19.532  1.00  0.00           C  
ATOM   1385  O   ARG A  93      18.097  28.419  19.914  1.00  0.00           O  
ATOM   1386  CB  ARG A  93      19.604  26.692  17.683  1.00  0.00           C  
ATOM   1387  CG  ARG A  93      20.353  25.793  18.652  1.00  0.00           C  
ATOM   1388  CD  ARG A  93      21.459  25.018  17.953  1.00  0.00           C  
ATOM   1389  NE  ARG A  93      22.261  25.876  17.083  1.00  0.00           N  
ATOM   1390  CZ  ARG A  93      23.520  25.613  16.751  1.00  0.00           C  
ATOM   1391  NH1 ARG A  93      24.118  24.524  17.213  1.00  0.00           N  
ATOM   1392  NH2 ARG A  93      24.183  26.441  15.953  1.00  0.00           N  
ATOM   1393  H   ARG A  93      17.789  28.883  17.392  1.00  0.00           H  
ATOM   1394  HA  ARG A  93      17.591  25.988  17.865  1.00  0.00           H  
ATOM   1395  HB2 ARG A  93      19.656  26.247  16.700  1.00  0.00           H  
ATOM   1396  HB3 ARG A  93      20.098  27.652  17.662  1.00  0.00           H  
ATOM   1397  HG2 ARG A  93      20.791  26.401  19.429  1.00  0.00           H  
ATOM   1398  HG3 ARG A  93      19.657  25.093  19.090  1.00  0.00           H  
ATOM   1399  HD2 ARG A  93      22.102  24.580  18.701  1.00  0.00           H  
ATOM   1400  HD3 ARG A  93      21.012  24.235  17.359  1.00  0.00           H  
ATOM   1401  HE  ARG A  93      21.838  26.686  16.729  1.00  0.00           H  
ATOM   1402 HH11 ARG A  93      23.620  23.898  17.813  1.00  0.00           H  
ATOM   1403 HH12 ARG A  93      25.065  24.329  16.961  1.00  0.00           H  
ATOM   1404 HH21 ARG A  93      23.735  27.263  15.603  1.00  0.00           H  
ATOM   1405 HH22 ARG A  93      25.130  26.244  15.704  1.00  0.00           H  
ATOM   1406  N   VAL A  94      17.820  26.232  20.361  1.00  0.00           N  
ATOM   1407  CA  VAL A  94      17.690  26.430  21.801  1.00  0.00           C  
ATOM   1408  C   VAL A  94      18.948  25.977  22.533  1.00  0.00           C  
ATOM   1409  O   VAL A  94      19.257  24.787  22.580  1.00  0.00           O  
ATOM   1410  CB  VAL A  94      16.478  25.666  22.365  1.00  0.00           C  
ATOM   1411  CG1 VAL A  94      16.366  25.878  23.867  1.00  0.00           C  
ATOM   1412  CG2 VAL A  94      15.201  26.100  21.661  1.00  0.00           C  
ATOM   1413  H   VAL A  94      17.763  25.323  19.997  1.00  0.00           H  
ATOM   1414  HA  VAL A  94      17.541  27.485  21.979  1.00  0.00           H  
ATOM   1415  HB  VAL A  94      16.624  24.612  22.182  1.00  0.00           H  
ATOM   1416 HG11 VAL A  94      15.691  26.698  24.065  1.00  0.00           H  
ATOM   1417 HG12 VAL A  94      15.988  24.978  24.330  1.00  0.00           H  
ATOM   1418 HG13 VAL A  94      17.341  26.109  24.271  1.00  0.00           H  
ATOM   1419 HG21 VAL A  94      14.987  27.129  21.907  1.00  0.00           H  
ATOM   1420 HG22 VAL A  94      15.328  26.006  20.591  1.00  0.00           H  
ATOM   1421 HG23 VAL A  94      14.382  25.474  21.982  1.00  0.00           H  
ATOM   1422  N   SER A  95      19.670  26.935  23.106  1.00  0.00           N  
ATOM   1423  CA  SER A  95      20.896  26.636  23.835  1.00  0.00           C  
ATOM   1424  C   SER A  95      20.583  26.035  25.201  1.00  0.00           C  
ATOM   1425  O   SER A  95      20.195  26.742  26.130  1.00  0.00           O  
ATOM   1426  CB  SER A  95      21.736  27.904  24.004  1.00  0.00           C  
ATOM   1427  OG  SER A  95      22.810  27.689  24.904  1.00  0.00           O  
ATOM   1428  H   SER A  95      19.370  27.866  23.034  1.00  0.00           H  
ATOM   1429  HA  SER A  95      21.458  25.917  23.257  1.00  0.00           H  
ATOM   1430  HB2 SER A  95      22.139  28.196  23.046  1.00  0.00           H  
ATOM   1431  HB3 SER A  95      21.112  28.697  24.389  1.00  0.00           H  
ATOM   1432  HG  SER A  95      22.462  27.525  25.784  1.00  0.00           H  
ATOM   1433  N   GLY A  96      20.755  24.720  25.316  1.00  0.00           N  
ATOM   1434  CA  GLY A  96      20.487  24.044  26.571  1.00  0.00           C  
ATOM   1435  C   GLY A  96      20.753  22.553  26.495  1.00  0.00           C  
ATOM   1436  O   GLY A  96      21.492  22.077  25.634  1.00  0.00           O  
ATOM   1437  H   GLY A  96      21.066  24.207  24.542  1.00  0.00           H  
ATOM   1438  HA2 GLY A  96      21.112  24.473  27.340  1.00  0.00           H  
ATOM   1439  HA3 GLY A  96      19.451  24.200  26.836  1.00  0.00           H  
ATOM   1440  N   PRO A  97      20.143  21.792  27.415  1.00  0.00           N  
ATOM   1441  CA  PRO A  97      20.305  20.337  27.471  1.00  0.00           C  
ATOM   1442  C   PRO A  97      19.628  19.633  26.299  1.00  0.00           C  
ATOM   1443  O   PRO A  97      19.625  18.405  26.218  1.00  0.00           O  
ATOM   1444  CB  PRO A  97      19.624  19.954  28.788  1.00  0.00           C  
ATOM   1445  CG  PRO A  97      18.635  21.040  29.033  1.00  0.00           C  
ATOM   1446  CD  PRO A  97      19.249  22.293  28.473  1.00  0.00           C  
ATOM   1447  HA  PRO A  97      21.346  20.054  27.506  1.00  0.00           H  
ATOM   1448  HB2 PRO A  97      19.140  18.993  28.681  1.00  0.00           H  
ATOM   1449  HB3 PRO A  97      20.361  19.905  29.576  1.00  0.00           H  
ATOM   1450  HG2 PRO A  97      17.710  20.817  28.525  1.00  0.00           H  
ATOM   1451  HG3 PRO A  97      18.465  21.149  30.095  1.00  0.00           H  
ATOM   1452  HD2 PRO A  97      18.486  22.936  28.059  1.00  0.00           H  
ATOM   1453  HD3 PRO A  97      19.809  22.813  29.236  1.00  0.00           H  
ATOM   1454  N   SER A  98      19.057  20.420  25.392  1.00  0.00           N  
ATOM   1455  CA  SER A  98      18.374  19.872  24.226  1.00  0.00           C  
ATOM   1456  C   SER A  98      19.063  18.602  23.740  1.00  0.00           C  
ATOM   1457  O   SER A  98      20.099  18.659  23.076  1.00  0.00           O  
ATOM   1458  CB  SER A  98      18.334  20.906  23.100  1.00  0.00           C  
ATOM   1459  OG  SER A  98      17.578  20.433  22.000  1.00  0.00           O  
ATOM   1460  H   SER A  98      19.093  21.392  25.513  1.00  0.00           H  
ATOM   1461  HA  SER A  98      17.363  19.630  24.518  1.00  0.00           H  
ATOM   1462  HB2 SER A  98      17.883  21.816  23.466  1.00  0.00           H  
ATOM   1463  HB3 SER A  98      19.341  21.112  22.769  1.00  0.00           H  
ATOM   1464  HG  SER A  98      16.682  20.238  22.286  1.00  0.00           H  
ATOM   1465  N   SER A  99      18.482  17.454  24.077  1.00  0.00           N  
ATOM   1466  CA  SER A  99      19.042  16.168  23.679  1.00  0.00           C  
ATOM   1467  C   SER A  99      18.642  15.821  22.248  1.00  0.00           C  
ATOM   1468  O   SER A  99      17.886  16.551  21.607  1.00  0.00           O  
ATOM   1469  CB  SER A  99      18.574  15.067  24.632  1.00  0.00           C  
ATOM   1470  OG  SER A  99      17.163  14.934  24.604  1.00  0.00           O  
ATOM   1471  H   SER A  99      17.659  17.474  24.607  1.00  0.00           H  
ATOM   1472  HA  SER A  99      20.118  16.244  23.731  1.00  0.00           H  
ATOM   1473  HB2 SER A  99      19.017  14.127  24.339  1.00  0.00           H  
ATOM   1474  HB3 SER A  99      18.881  15.312  25.639  1.00  0.00           H  
ATOM   1475  HG  SER A  99      16.898  14.503  23.789  1.00  0.00           H  
ATOM   1476  N   GLY A 100      19.157  14.699  21.751  1.00  0.00           N  
ATOM   1477  CA  GLY A 100      18.843  14.274  20.400  1.00  0.00           C  
ATOM   1478  C   GLY A 100      19.764  14.895  19.369  1.00  0.00           C  
ATOM   1479  O   GLY A 100      19.968  16.109  19.358  1.00  0.00           O  
ATOM   1480  H   GLY A 100      19.754  14.157  22.308  1.00  0.00           H  
ATOM   1481  HA2 GLY A 100      18.929  13.200  20.343  1.00  0.00           H  
ATOM   1482  HA3 GLY A 100      17.826  14.557  20.173  1.00  0.00           H  
TER    1483      GLY A 100                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
