
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   90 (  685),  selected   90 , name 2he4_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 2he4_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S   145_A      M       1           -
LGA    -       -      H       2           -
LGA    -       -      H       3           -
LGA    -       -      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    -       -      V      11           -
LGA    -       -      D      12           -
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    -       -      T      15           -
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    -       -      L      18           -
LGA    M   146_A      Y      19          3.715
LGA    L   147_A      F      20          3.098
LGA    -       -      Q      21           -
LGA    -       -      S      22           -
LGA    R   148_A      M      23          2.346
LGA    P   149_A      P      24          1.084
LGA    R   150_A      R      25          0.731
LGA    L   151_A      S      26          0.486
LGA    C   152_A      I      27          0.395
LGA    H   153_A      R      28          0.575
LGA    L   154_A      F      29          1.007
LGA    R   155_A      T      30          1.582
LGA    K   156_A      A      31          1.977
LGA    G   157_A      E      32          0.790
LGA    P   158_A      E      33          2.237
LGA    Q   159_A      G      34          5.271
LGA    G   160_A      D      35          1.118
LGA    Y   161_A      L      36          1.760
LGA    G   162_A      G      37          0.231
LGA    F   163_A      F      38          0.484
LGA    N   164_A      T      39          0.642
LGA    L   165_A      L      40          0.928
LGA    H   166_A      R      41          0.761
LGA    S   167_A      G      42          0.752
LGA    D   168_A      N      43          5.659
LGA    K   169_A      -       -           -
LGA    S   170_A      -       -           -
LGA    R   171_A      -       -           -
LGA    P   172_A      A      44          3.896
LGA    G   173_A      P      45          1.699
LGA    Q   174_A      V      46          0.307
LGA    Y   175_A      Q      47          0.274
LGA    I   176_A      V      48          0.517
LGA    R   177_A      H      49          0.751
LGA    S   178_A      F      50          1.890
LGA    V   179_A      L      51          0.875
LGA    D   180_A      D      52          0.600
LGA    P   181_A      P      53          1.861
LGA    G   182_A      Y      54          0.615
LGA    S   183_A      C      55          0.958
LGA    P   184_A      S      56          1.799
LGA    A   185_A      A      57          1.741
LGA    A   186_A      S      58          0.924
LGA    R   187_A      V      59          1.436
LGA    S   188_A      A      60          1.871
LGA    G   189_A      G      61          1.318
LGA    L   190_A      A      62          0.677
LGA    R   191_A      R      63          0.373
LGA    A   192_A      E      64          0.344
LGA    Q   193_A      G      65          0.637
LGA    D   194_A      D      66          0.329
LGA    R   195_A      Y      67          0.432
LGA    L   196_A      I      68          0.650
LGA    I   197_A      V      69          0.379
LGA    E   198_A      S      70          0.295
LGA    V   199_A      I      71          0.982
LGA    N   200_A      Q      72          2.162
LGA    G   201_A      L      73          1.740
LGA    Q   202_A      V      74          0.745
LGA    N   203_A      D      75          0.422
LGA    V   204_A      C      76          1.250
LGA    E   205_A      K      77          1.501
LGA    G   206_A      W      78          1.947
LGA    L   207_A      L      79          1.863
LGA    R   208_A      T      80          2.140
LGA    H   209_A      L      81          1.796
LGA    A   210_A      S      82          1.329
LGA    E   211_A      E      83          1.338
LGA    V   212_A      V      84          1.143
LGA    V   213_A      M      85          0.822
LGA    A   214_A      K      86          0.919
LGA    S   215_A      L      87          0.880
LGA    I   216_A      L      88          1.048
LGA    K   217_A      K      89          1.437
LGA    A   218_A      S      90          1.528
LGA    R   219_A      F      91          1.658
LGA    E   220_A      G      92          2.302
LGA    D   221_A      E      93          2.571
LGA    E   222_A      D      94          3.409
LGA    -       -      E      95           -
LGA    A   223_A      I      96          1.496
LGA    R   224_A      E      97          1.021
LGA    L   225_A      M      98          1.036
LGA    L   226_A      K      99          0.422
LGA    V   227_A      V     100          0.420
LGA    V   228_A      V     101          0.339
LGA    G   229_A      S     102          0.384
LGA    P   230_A      L     103          2.515
LGA    S   231_A      L     104          4.002
LGA    T   232_A      -       -           -
LGA    R   233_A      -       -           -
LGA    L   234_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   90  104    5.0     83    1.74    20.48     73.469     4.515

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.838852 * X  +   0.186450 * Y  +   0.511434 * Z  +  17.709179
  Y_new =   0.522967 * X  +   0.536825 * Y  +   0.662061 * Z  +   0.335216
  Z_new =  -0.151109 * X  +   0.822834 * Y  +  -0.547824 * Z  +  -8.244466 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.158183   -0.983410  [ DEG:   123.6548    -56.3452 ]
  Theta =   0.151690    2.989903  [ DEG:     8.6912    171.3088 ]
  Phi   =   2.584122   -0.557471  [ DEG:   148.0593    -31.9407 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2he4_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2he4_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   90  104   5.0   83   1.74   20.48  73.469
REMARK  ---------------------------------------------------------- 
MOLECULE 2he4_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   21-JUN-06   2HE4              
TITLE     THE CRYSTAL STRUCTURE OF THE SECOND PDZ DOMAIN OF HUMAN               
TITLE    2 NHERF-2 (SLC9A3R2) INTERACTING WITH A MODE 1 PDZ BINDING             
TITLE    3 MOTIF                                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NA(+)/H(+) EXCHANGE REGULATORY COFACTOR NHE-RF2;           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ 2 DOMAIN (RESIDUES 147-230);                           
COMPND   5 SYNONYM: NHERF-2, TYROSINE KINASE ACTIVATOR PROTEIN 1, TKA-          
COMPND   6 1, SRY-INTERACTING PROTEIN 1, SIP- 1, SOLUTE CARRIER                 
COMPND   7 FAMILY 9 ISOFORM A3 REGULATORY FACTOR 2, NHE3 KINASE A               
COMPND   8 REGULATORY PROTEIN E3KARP, SODIUM-HYDROGEN EXCHANGER                 
COMPND   9 REGULATORY FACTOR 2;                                                 
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SLC9A3R2;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)-R3 ROSETTA;                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    PHOSPHORYLATION, STRUCTURAL GENOMICS, STRUCTURAL GENOMICS             
KEYWDS   2 CONSORTIUM, SGC                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.PAPAGRIGORIOU,J.ELKINS,G.BERRIDGE,O.GILEADY,S.COLEBROOK,            
AUTHOR   2 C.GILEADI,E.SALAH,P.SAVITSKY,N.PANTIC,F.GORREC,G.BUNKOCZI,           
AUTHOR   3 J.WEIGELT,C.ARROWSMITH,M.SUNDSTROM,A.EDWARDS,D.DOYLE,                
AUTHOR   4 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   18-JUL-06 2HE4    0                                                
JRNL        AUTH   E.PAPAGRIGORIOU,J.ELKINS,G.BERRIDGE,O.GILEADY,               
JRNL        AUTH 2 S.COLEBROOK,C.GILEADI,E.SALAH,P.SAVITSKY,N.PANTIC,           
JRNL        AUTH 3 F.GORREC,G.BUNKOCZI,J.WEIGELT,C.ARROWSMITH,                  
JRNL        AUTH 4 M.SUNDSTROM,A.EDWARDS,D.DOYLE                                
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE SECOND PDZ DOMAIN OF            
JRNL        TITL 2 HUMAN NHERF-2 (SLC9A3R2) INTERACTING WITH A MODE 1           
JRNL        TITL 3 PDZ BINDING MOTIF                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.45 ANGSTROMS.                                          
DBREF  2HE4 A  147   230  UNP    Q15599   NHRF2_HUMAN    147    232             
SEQRES   1 A   90  SER MET LEU ARG PRO ARG LEU CYS HIS LEU ARG LYS GLY          
SEQRES   2 A   90  PRO GLN GLY TYR GLY PHE ASN LEU HIS SER ASP LYS SER          
SEQRES   3 A   90  ARG PRO GLY GLN TYR ILE ARG SER VAL ASP PRO GLY SER          
SEQRES   4 A   90  PRO ALA ALA ARG SER GLY LEU ARG ALA GLN ASP ARG LEU          
SEQRES   5 A   90  ILE GLU VAL ASN GLY GLN ASN VAL GLU GLY LEU ARG HIS          
SEQRES   6 A   90  ALA GLU VAL VAL ALA SER ILE LYS ALA ARG GLU ASP GLU          
SEQRES   7 A   90  ALA ARG LEU LEU VAL VAL GLY PRO SER THR ARG LEU              
HET    EDO    200       4                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   2  EDO    C2 H6 O2                                                     
FORMUL   3  HOH   *113(H2 O)                                                    
CRYST1   49.803   37.677   40.340  90.00  97.70  90.00 C 1 2 1       4          
ATOM      1  N   SER A 145      21.626  37.930  21.206  1.00 34.87           N  
ATOM      2  CA  SER A 145      20.876  37.732  22.483  1.00 31.69           C  
ATOM      3  C   SER A 145      20.019  36.475  22.397  1.00 30.77           C  
ATOM      4  O   SER A 145      19.982  35.806  21.365  1.00 32.05           O  
ATOM      5  CB  SER A 145      20.022  38.959  22.835  1.00 30.56           C  
ATOM      6  OG  SER A 145      19.007  39.217  21.879  1.00 33.05           O  
ATOM      7  N   MET A 146      19.342  36.150  23.489  1.00 30.68           N  
ATOM      8  CA  MET A 146      18.572  34.916  23.571  1.00 30.08           C  
ATOM      9  C   MET A 146      17.466  34.841  22.540  1.00 26.80           C  
ATOM     10  O   MET A 146      16.799  35.842  22.241  1.00 26.14           O  
ATOM     11  CB  MET A 146      17.968  34.752  24.975  1.00 35.46           C  
ATOM     12  N   LEU A 147      17.285  33.625  22.033  1.00 22.25           N  
ATOM     13  CA  LEU A 147      16.158  33.196  21.229  1.00 21.72           C  
ATOM     14  C   LEU A 147      16.049  33.999  19.952  1.00 19.38           C  
ATOM     15  O   LEU A 147      14.973  34.175  19.438  1.00 26.21           O  
ATOM     16  CB  LEU A 147      14.841  33.218  22.042  1.00 25.35           C  
ATOM     17  CG  LEU A 147      14.663  32.173  23.148  1.00 28.24           C  
ATOM     18  CD1 LEU A 147      13.199  32.162  23.631  1.00 27.63           C  
ATOM     19  CD2 LEU A 147      15.029  30.794  22.627  1.00 32.62           C  
ATOM     20  N   ARG A 148      17.197  34.451  19.454  1.00 17.03           N  
ATOM     21  CA  ARG A 148      17.292  35.103  18.120  1.00 17.16           C  
ATOM     22  C   ARG A 148      17.605  34.034  17.060  1.00 15.95           C  
ATOM     23  O   ARG A 148      18.428  33.135  17.284  1.00 17.12           O  
ATOM     24  CB  ARG A 148      18.391  36.187  18.083  1.00 18.27           C  
ATOM     25  CG  ARG A 148      18.230  37.308  19.056  1.00 20.45           C  
ATOM     26  CD  ARG A 148      16.974  38.082  18.798  1.00 18.54           C  
ATOM     27  NE  ARG A 148      16.936  38.728  17.469  1.00 20.39           N  
ATOM     28  CZ  ARG A 148      15.834  39.181  16.879  1.00 18.94           C  
ATOM     29  NH1 ARG A 148      14.641  39.080  17.460  1.00 20.27           N  
ATOM     30  NH2 ARG A 148      15.926  39.725  15.696  1.00 21.26           N  
ATOM     31  N   PRO A 149      16.978  34.116  15.895  1.00 14.22           N  
ATOM     32  CA  PRO A 149      17.447  33.269  14.798  1.00 12.07           C  
ATOM     33  C   PRO A 149      18.938  33.479  14.501  1.00 12.03           C  
ATOM     34  O   PRO A 149      19.472  34.564  14.672  1.00 14.86           O  
ATOM     35  CB  PRO A 149      16.603  33.728  13.628  1.00 14.18           C  
ATOM     36  CG  PRO A 149      15.410  34.374  14.202  1.00 14.87           C  
ATOM     37  CD  PRO A 149      15.865  34.973  15.483  1.00 16.36           C  
ATOM     38  N   ARG A 150      19.602  32.425  14.030  1.00 11.48           N  
ATOM     39  CA  ARG A 150      21.027  32.425  13.798  1.00 10.68           C  
ATOM     40  C   ARG A 150      21.306  32.331  12.311  1.00  9.50           C  
ATOM     41  O   ARG A 150      20.729  31.495  11.618  1.00  9.68           O  
ATOM     42  CB  ARG A 150      21.659  31.209  14.435  1.00 13.30           C  
ATOM     43  CG  ARG A 150      23.156  31.206  14.294  1.00 22.75           C  
ATOM     44  CD  ARG A 150      23.792  30.360  15.332  1.00 28.62           C  
ATOM     45  NE  ARG A 150      25.197  30.182  15.039  1.00 26.07           N  
ATOM     46  CZ  ARG A 150      25.999  29.372  15.737  1.00 29.22           C  
ATOM     47  NH1 ARG A 150      25.542  28.674  16.778  1.00 36.46           N  
ATOM     48  NH2 ARG A 150      27.266  29.253  15.394  1.00 31.15           N  
ATOM     49  N   LEU A 151      22.235  33.168  11.860  1.00  9.97           N  
ATOM     50  CA  LEU A 151      22.650  33.192  10.462  1.00  8.71           C  
ATOM     51  C   LEU A 151      23.816  32.199  10.339  1.00 10.10           C  
ATOM     52  O   LEU A 151      24.838  32.374  10.989  1.00 11.81           O  
ATOM     53  CB  LEU A 151      23.074  34.589  10.059  1.00 10.32           C  
ATOM     54  CG  LEU A 151      23.335  34.842   8.580  1.00  9.74           C  
ATOM     55  CD1 LEU A 151      22.167  34.421   7.694  1.00 12.89           C  
ATOM     56  CD2 LEU A 151      23.690  36.247   8.348  1.00 15.34           C  
ATOM     57  N   CYS A 152      23.664  31.238   9.444  1.00  9.66           N  
ATOM     58  CA  CYS A 152      24.671  30.229   9.211  1.00  8.91           C  
ATOM     59  C   CYS A 152      25.196  30.485   7.782  1.00  9.81           C  
ATOM     60  O   CYS A 152      24.438  30.403   6.788  1.00 10.30           O  
ATOM     61  CB  CYS A 152      24.034  28.846   9.311  1.00 12.95           C  
ATOM     62  SG  CYS A 152      23.424  28.476  10.978  1.00 13.92           S  
ATOM     63  N   HIS A 153      26.492  30.779   7.679  1.00  9.37           N  
ATOM     64  CA  HIS A 153      27.103  31.081   6.402  1.00  9.37           C  
ATOM     65  C   HIS A 153      27.859  29.829   5.983  1.00 10.41           C  
ATOM     66  O   HIS A 153      28.902  29.484   6.576  1.00 14.44           O  
ATOM     67  CB  HIS A 153      28.055  32.262   6.534  1.00 10.21           C  
ATOM     68  CG  HIS A 153      28.734  32.632   5.255  1.00 14.40           C  
ATOM     69  ND1 HIS A 153      29.944  33.287   5.225  1.00 21.99           N  
ATOM     70  CD2 HIS A 153      28.380  32.439   3.967  1.00 16.54           C  
ATOM     71  CE1 HIS A 153      30.312  33.473   3.966  1.00 20.87           C  
ATOM     72  NE2 HIS A 153      29.374  32.977   3.181  1.00 18.55           N  
ATOM     73  N   LEU A 154      27.335  29.118   4.980  1.00  9.47           N  
ATOM     74  CA  LEU A 154      27.972  27.888   4.505  1.00  8.32           C  
ATOM     75  C   LEU A 154      28.810  28.181   3.254  1.00  7.97           C  
ATOM     76  O   LEU A 154      28.339  28.839   2.322  1.00  9.20           O  
ATOM     77  CB  LEU A 154      26.912  26.869   4.155  1.00  9.68           C  
ATOM     78  CG  LEU A 154      26.019  26.280   5.268  1.00 12.07           C  
ATOM     79  CD1 LEU A 154      24.931  27.195   5.796  1.00 12.77           C  
ATOM     80  CD2 LEU A 154      25.386  25.000   4.770  1.00 12.00           C  
ATOM     81  N   ARG A 155      30.035  27.694   3.274  1.00  8.66           N  
ATOM     82  CA  ARG A 155      30.926  27.760   2.161  1.00  9.74           C  
ATOM     83  C   ARG A 155      30.934  26.395   1.473  1.00  8.40           C  
ATOM     84  O   ARG A 155      31.327  25.398   2.070  1.00 10.28           O  
ATOM     85  CB  ARG A 155      32.327  28.188   2.610  0.50 10.38           C  
ATOM     87  CG  ARG A 155      32.310  29.521   3.364  0.50 16.39           C  
ATOM     89  CD  ARG A 155      33.692  30.058   3.581  0.50 21.49           C  
ATOM     91  NE  ARG A 155      33.695  31.450   4.021  0.50 28.96           N  
ATOM     93  CZ  ARG A 155      33.507  31.864   5.273  0.50 30.99           C  
ATOM     95  NH1 ARG A 155      33.258  31.002   6.258  0.50 36.33           N  
ATOM     97  NH2 ARG A 155      33.554  33.162   5.532  0.50 26.74           N  
ATOM     99  N   LYS A 156      30.487  26.332   0.228  1.00  8.56           N  
ATOM    100  CA  LYS A 156      30.278  25.070  -0.444  1.00  9.16           C  
ATOM    101  C   LYS A 156      31.591  24.313  -0.621  1.00  9.40           C  
ATOM    102  O   LYS A 156      32.638  24.889  -0.934  1.00  8.42           O  
ATOM    103  CB  LYS A 156      29.606  25.277  -1.797  1.00 12.63           C  
ATOM    104  CG  LYS A 156      28.927  23.994  -2.294  1.00 16.89           C  
ATOM    105  CD  LYS A 156      28.378  24.062  -3.640  1.00 19.55           C  
ATOM    106  CE  LYS A 156      27.192  24.922  -3.641  1.00 20.28           C  
ATOM    107  NZ  LYS A 156      26.761  25.110  -5.028  1.00 27.58           N  
ATOM    108  N   GLY A 157      31.504  23.015  -0.440  1.00  9.78           N  
ATOM    109  CA  GLY A 157      32.596  22.103  -0.656  1.00  9.01           C  
ATOM    110  C   GLY A 157      32.418  21.277  -1.905  1.00  9.56           C  
ATOM    111  O   GLY A 157      31.478  21.453  -2.670  1.00 11.83           O  
ATOM    112  N   PRO A 158      33.373  20.383  -2.163  1.00  9.99           N  
ATOM    113  CA  PRO A 158      33.310  19.590  -3.384  1.00 11.14           C  
ATOM    114  C   PRO A 158      32.142  18.589  -3.450  1.00 10.73           C  
ATOM    115  O   PRO A 158      31.784  18.120  -4.544  1.00 14.19           O  
ATOM    116  CB  PRO A 158      34.672  18.857  -3.401  1.00 14.11           C  
ATOM    117  CG  PRO A 158      35.200  18.941  -2.095  1.00 17.07           C  
ATOM    118  CD  PRO A 158      34.573  20.107  -1.371  1.00 11.39           C  
ATOM    119  N   GLN A 159      31.576  18.221  -2.302  1.00 11.07           N  
ATOM    120  CA  GLN A 159      30.364  17.368  -2.275  1.00 12.21           C  
ATOM    121  C   GLN A 159      29.154  18.141  -1.804  1.00 13.51           C  
ATOM    122  O   GLN A 159      28.185  17.590  -1.300  1.00 18.89           O  
ATOM    123  CB  GLN A 159      30.581  16.208  -1.315  1.00 13.41           C  
ATOM    124  CG  GLN A 159      31.467  15.124  -1.844  1.00 13.23           C  
ATOM    125  CD  GLN A 159      32.931  15.547  -1.884  1.00 13.63           C  
ATOM    126  OE1 GLN A 159      33.515  15.945  -0.859  1.00 16.23           O  
ATOM    127  NE2 GLN A 159      33.521  15.478  -3.070  1.00 12.96           N  
ATOM    128  N   GLY A 160      29.189  19.438  -1.971  1.00 10.08           N  
ATOM    129  CA  GLY A 160      28.086  20.273  -1.545  1.00 10.45           C  
ATOM    130  C   GLY A 160      28.253  20.800  -0.138  1.00  9.15           C  
ATOM    131  O   GLY A 160      29.346  21.128   0.298  1.00 10.66           O  
ATOM    132  N   TYR A 161      27.144  20.879   0.578  1.00  9.31           N  
ATOM    133  CA  TYR A 161      27.120  21.452   1.910  1.00  9.93           C  
ATOM    134  C   TYR A 161      27.124  20.422   3.033  1.00 11.29           C  
ATOM    135  O   TYR A 161      27.590  20.725   4.113  1.00 12.56           O  
ATOM    136  CB  TYR A 161      25.895  22.338   2.048  1.00 10.19           C  
ATOM    137  CG  TYR A 161      25.954  23.575   1.190  1.00  9.03           C  
ATOM    138  CD1 TYR A 161      26.934  24.527   1.394  1.00  9.99           C  
ATOM    139  CD2 TYR A 161      25.056  23.788   0.163  1.00 11.23           C  
ATOM    140  CE1 TYR A 161      26.996  25.662   0.639  1.00  8.92           C  
ATOM    141  CE2 TYR A 161      25.139  24.923  -0.622  1.00  9.54           C  
ATOM    142  CZ  TYR A 161      26.108  25.848  -0.380  1.00  9.41           C  
ATOM    143  OH  TYR A 161      26.264  26.997  -1.135  1.00 10.18           O  
ATOM    144  N   GLY A 162      26.608  19.227   2.771  1.00 10.36           N  
ATOM    145  CA  GLY A 162      26.592  18.154   3.773  1.00 10.61           C  
ATOM    146  C   GLY A 162      25.467  18.243   4.791  1.00 11.96           C  
ATOM    147  O   GLY A 162      25.678  17.991   5.975  1.00 13.29           O  
ATOM    148  N   PHE A 163      24.268  18.546   4.323  1.00 11.15           N  
ATOM    149  CA  PHE A 163      23.081  18.430   5.165  1.00 10.60           C  
ATOM    150  C   PHE A 163      21.918  17.932   4.377  1.00 10.13           C  
ATOM    151  O   PHE A 163      21.942  18.000   3.146  1.00 12.03           O  
ATOM    152  CB  PHE A 163      22.751  19.744   5.904  1.00 11.26           C  
ATOM    153  CG  PHE A 163      22.223  20.862   5.040  1.00 10.14           C  
ATOM    154  CD1 PHE A 163      20.876  21.100   4.936  1.00 11.08           C  
ATOM    155  CD2 PHE A 163      23.095  21.674   4.336  1.00 10.88           C  
ATOM    156  CE1 PHE A 163      20.404  22.145   4.179  1.00 11.42           C  
ATOM    157  CE2 PHE A 163      22.616  22.717   3.573  1.00  9.26           C  
ATOM    158  CZ  PHE A 163      21.278  22.945   3.506  1.00 11.90           C  
ATOM    159  N   ASN A 164      20.891  17.454   5.105  1.00 11.66           N  
ATOM    160  CA  ASN A 164      19.643  16.952   4.488  1.00 12.59           C  
ATOM    161  C   ASN A 164      18.518  17.893   4.889  1.00 13.69           C  
ATOM    162  O   ASN A 164      18.345  18.151   6.067  1.00 14.95           O  
ATOM    163  CB  ASN A 164      19.404  15.526   4.984  1.00 14.86           C  
ATOM    164  CG  ASN A 164      18.397  14.745   4.175  1.00 22.87           C  
ATOM    165  OD1 ASN A 164      18.086  15.062   3.016  1.00 25.33           O  
ATOM    166  ND2 ASN A 164      17.888  13.673   4.785  1.00 30.20           N  
ATOM    167  N   LEU A 165      17.833  18.435   3.877  1.00 11.88           N  
ATOM    168  CA  LEU A 165      16.710  19.323   4.061  1.00 11.94           C  
ATOM    169  C   LEU A 165      15.425  18.514   3.945  1.00 12.39           C  
ATOM    170  O   LEU A 165      15.264  17.810   2.958  1.00 11.78           O  
ATOM    171  CB  LEU A 165      16.707  20.403   2.996  1.00 12.56           C  
ATOM    172  CG  LEU A 165      15.660  21.501   3.206  1.00 13.94           C  
ATOM    173  CD1 LEU A 165      16.038  22.434   4.376  1.00 16.31           C  
ATOM    174  CD2 LEU A 165      15.388  22.277   1.928  1.00 16.90           C  
ATOM    175  N   HIS A 166      14.509  18.677   4.908  1.00 12.06           N  
ATOM    176  CA  HIS A 166      13.322  17.833   4.996  1.00 13.70           C  
ATOM    177  C   HIS A 166      12.042  18.644   5.216  1.00 15.19           C  
ATOM    178  O   HIS A 166      12.028  19.543   6.045  1.00 15.02           O  
ATOM    179  CB  HIS A 166      13.512  16.821   6.159  1.00 19.38           C  
ATOM    180  CG  HIS A 166      12.937  15.461   5.875  1.00 33.46           C  
ATOM    181  ND1 HIS A 166      11.583  15.240   5.702  1.00 39.56           N  
ATOM    182  CD2 HIS A 166      13.533  14.248   5.735  1.00 35.87           C  
ATOM    183  CE1 HIS A 166      11.373  13.954   5.464  1.00 38.19           C  
ATOM    184  NE2 HIS A 166      12.536  13.328   5.485  1.00 42.20           N  
ATOM    185  N   SER A 167      10.974  18.280   4.499  1.00 14.94           N  
ATOM    186  CA  SER A 167       9.601  18.714   4.864  1.00 17.96           C  
ATOM    187  C   SER A 167       9.078  17.858   6.032  1.00 20.75           C  
ATOM    188  O   SER A 167       9.556  16.705   6.251  1.00 21.94           O  
ATOM    189  CB  SER A 167       8.628  18.565   3.715  1.00 24.34           C  
ATOM    190  OG  SER A 167       8.969  19.447   2.647  1.00 28.59           O  
ATOM    191  N   ASP A 168       8.158  18.400   6.818  1.00 19.31           N  
ATOM    192  CA  ASP A 168       7.524  17.669   7.902  1.00 20.74           C  
ATOM    193  C   ASP A 168       6.067  17.276   7.563  1.00 18.68           C  
ATOM    194  O   ASP A 168       5.402  17.989   6.854  1.00 21.70           O  
ATOM    195  CB  ASP A 168       7.628  18.461   9.208  1.00 19.35           C  
ATOM    196  CG  ASP A 168       7.071  17.704  10.378  1.00 27.51           C  
ATOM    197  OD1 ASP A 168       6.004  18.077  10.862  1.00 31.30           O  
ATOM    198  OD2 ASP A 168       7.679  16.702  10.795  1.00 36.09           O  
ATOM    199  N   LYS A 169       5.595  16.133   8.064  1.00 20.88           N  
ATOM    200  CA  LYS A 169       4.235  15.659   7.742  1.00 22.60           C  
ATOM    201  C   LYS A 169       3.172  16.272   8.645  1.00 27.15           C  
ATOM    202  O   LYS A 169       1.976  16.001   8.448  1.00 29.73           O  
ATOM    203  CB  LYS A 169       4.154  14.121   7.852  1.00 25.05           C  
ATOM    204  CG  LYS A 169       4.714  13.316   6.671  1.00 24.25           C  
ATOM    205  CD  LYS A 169       4.009  13.540   5.358  1.00 17.63           C  
ATOM    206  CE  LYS A 169       2.507  13.335   5.474  1.00 16.00           C  
ATOM    207  NZ  LYS A 169       1.779  13.687   4.226  1.00 26.98           N  
ATOM    208  N   SER A 170       3.581  17.108   9.608  1.00 27.57           N  
ATOM    209  CA  SER A 170       2.681  17.637  10.654  1.00 29.24           C  
ATOM    210  C   SER A 170       2.761  19.143  10.874  1.00 27.64           C  
ATOM    211  O   SER A 170       1.830  19.730  11.417  1.00 31.35           O  
ATOM    212  CB  SER A 170       2.992  16.963  11.975  1.00 33.81           C  
ATOM    213  OG  SER A 170       4.375  17.083  12.298  1.00 42.09           O  
ATOM    214  N   ARG A 171       3.877  19.748  10.495  1.00 25.24           N  
ATOM    215  CA  ARG A 171       4.150  21.163  10.666  1.00 29.34           C  
ATOM    216  C   ARG A 171       4.565  21.709   9.303  1.00 29.28           C  
ATOM    217  O   ARG A 171       5.231  21.005   8.551  1.00 29.68           O  
ATOM    218  CB  ARG A 171       5.314  21.328  11.644  1.00 31.09           C  
ATOM    219  CG  ARG A 171       5.066  20.681  13.002  1.00 33.41           C  
ATOM    220  N   PRO A 172       4.154  22.940   8.969  1.00 28.44           N  
ATOM    221  CA  PRO A 172       4.719  23.547   7.776  1.00 25.75           C  
ATOM    222  C   PRO A 172       6.180  23.905   8.030  1.00 24.63           C  
ATOM    223  O   PRO A 172       6.590  24.066   9.188  1.00 25.55           O  
ATOM    224  CB  PRO A 172       3.876  24.821   7.570  1.00 27.20           C  
ATOM    225  CG  PRO A 172       3.223  25.088   8.887  1.00 30.31           C  
ATOM    226  CD  PRO A 172       3.177  23.805   9.659  1.00 29.15           C  
ATOM    227  N   GLY A 173       6.949  23.960   6.950  1.00 21.87           N  
ATOM    228  CA  GLY A 173       8.316  24.441   6.977  1.00 20.71           C  
ATOM    229  C   GLY A 173       9.310  23.419   6.444  1.00 18.60           C  
ATOM    230  O   GLY A 173       8.998  22.234   6.241  1.00 17.68           O  
ATOM    231  N   GLN A 174      10.539  23.893   6.256  1.00 14.89           N  
ATOM    232  CA  GLN A 174      11.642  23.055   5.877  1.00 14.00           C  
ATOM    233  C   GLN A 174      12.591  22.999   7.071  1.00 11.63           C  
ATOM    234  O   GLN A 174      12.894  24.024   7.694  1.00 15.31           O  
ATOM    235  CB  GLN A 174      12.334  23.616   4.638  1.00 15.65           C  
ATOM    236  CG  GLN A 174      11.388  23.714   3.434  1.00 16.58           C  
ATOM    237  CD  GLN A 174      10.818  22.401   3.021  1.00 20.02           C  
ATOM    238  OE1 GLN A 174      11.540  21.381   2.972  1.00 20.50           O  
ATOM    239  NE2 GLN A 174       9.503  22.391   2.725  1.00 20.89           N  
ATOM    240  N   TYR A 175      13.130  21.821   7.321  1.00 12.27           N  
ATOM    241  CA  TYR A 175      13.952  21.560   8.491  1.00 12.19           C  
ATOM    242  C   TYR A 175      15.229  20.847   8.121  1.00 13.69           C  
ATOM    243  O   TYR A 175      15.301  20.157   7.112  1.00 14.93           O  
ATOM    244  CB  TYR A 175      13.181  20.653   9.486  1.00 14.66           C  
ATOM    245  CG  TYR A 175      11.881  21.310   9.968  1.00 14.77           C  
ATOM    246  CD1 TYR A 175      11.828  21.977  11.173  1.00 15.88           C  
ATOM    247  CD2 TYR A 175      10.733  21.312   9.177  1.00 14.09           C  
ATOM    248  CE1 TYR A 175      10.660  22.606  11.594  1.00 18.66           C  
ATOM    249  CE2 TYR A 175       9.552  21.919   9.598  1.00 16.60           C  
ATOM    250  CZ  TYR A 175       9.540  22.564  10.802  1.00 16.30           C  
ATOM    251  OH  TYR A 175       8.387  23.189  11.220  1.00 22.52           O  
ATOM    252  N   ILE A 176      16.236  21.036   8.959  1.00 12.82           N  
ATOM    253  CA  ILE A 176      17.488  20.314   8.831  1.00 14.12           C  
ATOM    254  C   ILE A 176      17.334  18.936   9.492  1.00 15.88           C  
ATOM    255  O   ILE A 176      17.215  18.832  10.713  1.00 17.21           O  
ATOM    256  CB  ILE A 176      18.672  21.087   9.455  1.00 15.15           C  
ATOM    257  CG1 ILE A 176      18.727  22.530   8.985  1.00 16.78           C  
ATOM    258  CG2 ILE A 176      20.025  20.410   9.183  1.00 18.34           C  
ATOM    259  CD1 ILE A 176      18.703  22.735   7.455  1.00 19.24           C  
ATOM    260  N   ARG A 177      17.257  17.886   8.693  1.00 16.20           N  
ATOM    261  CA  ARG A 177      17.133  16.532   9.306  1.00 20.24           C  
ATOM    262  C   ARG A 177      18.441  16.020   9.883  1.00 19.11           C  
ATOM    263  O   ARG A 177      18.436  15.329  10.923  1.00 20.50           O  
ATOM    264  CB  ARG A 177      16.581  15.496   8.334  1.00 22.82           C  
ATOM    265  CG  ARG A 177      16.331  14.165   9.078  1.00 27.73           C  
ATOM    266  CD  ARG A 177      15.501  13.187   8.328  1.00 39.21           C  
ATOM    267  NE  ARG A 177      15.459  11.946   9.101  1.00 42.82           N  
ATOM    268  CZ  ARG A 177      15.443  10.724   8.583  1.00 48.22           C  
ATOM    269  NH1 ARG A 177      15.425   9.680   9.400  1.00 44.25           N  
ATOM    270  NH2 ARG A 177      15.446  10.531   7.262  1.00 54.15           N  
ATOM    271  N   SER A 178      19.554  16.281   9.180  1.00 15.89           N  
ATOM    272  CA  SER A 178      20.854  15.861   9.629  1.00 16.44           C  
ATOM    273  C   SER A 178      21.932  16.742   9.036  1.00 14.72           C  
ATOM    274  O   SER A 178      21.692  17.382   8.030  1.00 15.94           O  
ATOM    275  CB  SER A 178      21.128  14.405   9.231  1.00 18.80           C  
ATOM    276  OG  SER A 178      21.182  14.237   7.812  1.00 23.28           O  
ATOM    277  N   VAL A 179      23.102  16.705   9.668  1.00 14.32           N  
ATOM    278  CA  VAL A 179      24.263  17.486   9.321  1.00 13.96           C  
ATOM    279  C   VAL A 179      25.406  16.535   9.330  1.00 13.65           C  
ATOM    280  O   VAL A 179      25.676  15.909  10.349  1.00 17.18           O  
ATOM    281  CB  VAL A 179      24.503  18.654  10.333  1.00 13.37           C  
ATOM    282  CG1 VAL A 179      25.803  19.397  10.036  1.00 19.11           C  
ATOM    283  CG2 VAL A 179      23.325  19.642  10.217  1.00 13.87           C  
ATOM    284  N   ASP A 180      26.086  16.382   8.212  1.00 14.24           N  
ATOM    285  CA  ASP A 180      27.214  15.449   8.155  1.00 15.17           C  
ATOM    286  C   ASP A 180      28.349  15.970   9.040  1.00 16.32           C  
ATOM    287  O   ASP A 180      28.698  17.168   9.012  1.00 16.91           O  
ATOM    288  CB  ASP A 180      27.735  15.268   6.719  1.00 15.05           C  
ATOM    289  CG  ASP A 180      26.701  14.685   5.762  1.00 22.05           C  
ATOM    290  OD1 ASP A 180      25.670  14.175   6.219  1.00 26.56           O  
ATOM    291  OD2 ASP A 180      26.923  14.751   4.529  1.00 25.15           O  
ATOM    292  N   PRO A 181      29.005  15.051   9.801  1.00 17.81           N  
ATOM    293  CA  PRO A 181      30.111  15.504  10.571  1.00 15.93           C  
ATOM    294  C   PRO A 181      31.203  16.106   9.719  1.00 14.87           C  
ATOM    295  O   PRO A 181      31.489  15.588   8.619  1.00 17.54           O  
ATOM    296  CB  PRO A 181      30.650  14.194  11.173  1.00 18.82           C  
ATOM    297  CG  PRO A 181      29.448  13.339  11.241  1.00 23.86           C  
ATOM    298  CD  PRO A 181      28.665  13.634  10.031  1.00 21.36           C  
ATOM    299  N   GLY A 182      31.781  17.197  10.201  1.00 15.58           N  
ATOM    300  CA  GLY A 182      32.913  17.811   9.553  1.00 17.26           C  
ATOM    301  C   GLY A 182      32.610  18.446   8.206  1.00 16.16           C  
ATOM    302  O   GLY A 182      33.499  18.646   7.414  1.00 17.26           O  
ATOM    303  N   SER A 183      31.343  18.731   7.945  1.00 15.66           N  
ATOM    304  CA  SER A 183      30.889  19.328   6.672  1.00 14.03           C  
ATOM    305  C   SER A 183      30.916  20.852   6.724  1.00 13.27           C  
ATOM    306  O   SER A 183      31.006  21.433   7.780  1.00 13.72           O  
ATOM    307  CB  SER A 183      29.469  18.870   6.442  1.00 13.56           C  
ATOM    308  OG  SER A 183      28.650  19.291   7.511  1.00 13.92           O  
ATOM    309  N   PRO A 184      30.776  21.508   5.566  1.00 13.48           N  
ATOM    310  CA  PRO A 184      30.543  22.931   5.549  1.00 11.92           C  
ATOM    311  C   PRO A 184      29.322  23.308   6.393  1.00 11.63           C  
ATOM    312  O   PRO A 184      29.348  24.313   7.123  1.00 12.60           O  
ATOM    313  CB  PRO A 184      30.314  23.211   4.053  1.00 12.18           C  
ATOM    314  CG  PRO A 184      31.170  22.225   3.359  1.00 12.24           C  
ATOM    315  CD  PRO A 184      30.941  20.972   4.197  1.00 12.57           C  
ATOM    316  N   ALA A 185      28.277  22.490   6.323  1.00  9.69           N  
ATOM    317  CA  ALA A 185      27.083  22.751   7.165  1.00 10.52           C  
ATOM    318  C   ALA A 185      27.428  22.793   8.656  1.00 11.89           C  
ATOM    319  O   ALA A 185      27.002  23.664   9.393  1.00 13.75           O  
ATOM    320  CB  ALA A 185      26.012  21.742   6.893  1.00 11.64           C  
ATOM    321  N   ALA A 186      28.155  21.784   9.113  1.00 14.05           N  
ATOM    322  CA  ALA A 186      28.526  21.739  10.524  1.00 14.22           C  
ATOM    323  C   ALA A 186      29.308  22.978  10.931  1.00 14.34           C  
ATOM    324  O   ALA A 186      29.052  23.547  12.013  1.00 17.81           O  
ATOM    325  CB  ALA A 186      29.336  20.459  10.858  1.00 15.39           C  
ATOM    326  N   ARG A 187      30.277  23.384  10.104  1.00 13.42           N  
ATOM    327  CA  ARG A 187      31.130  24.514  10.448  1.00 13.36           C  
ATOM    328  C   ARG A 187      30.351  25.843  10.519  1.00 12.82           C  
ATOM    329  O   ARG A 187      30.765  26.794  11.182  1.00 19.17           O  
ATOM    330  CB  ARG A 187      32.291  24.630   9.469  1.00 15.07           C  
ATOM    331  CG  ARG A 187      33.350  23.621   9.723  1.00 20.19           C  
ATOM    332  CD  ARG A 187      34.617  23.942   8.936  1.00 19.77           C  
ATOM    333  NE  ARG A 187      34.388  23.806   7.514  1.00 21.68           N  
ATOM    334  CZ  ARG A 187      34.307  22.647   6.889  1.00 18.09           C  
ATOM    335  NH1 ARG A 187      34.501  21.497   7.564  1.00 21.96           N  
ATOM    336  NH2 ARG A 187      34.102  22.608   5.606  1.00 21.58           N  
ATOM    337  N   SER A 188      29.245  25.910   9.789  1.00 12.87           N  
ATOM    338  CA  SER A 188      28.442  27.116   9.745  1.00 12.56           C  
ATOM    339  C   SER A 188      27.598  27.341  10.973  1.00 15.00           C  
ATOM    340  O   SER A 188      27.068  28.450  11.150  1.00 16.37           O  
ATOM    341  CB  SER A 188      27.519  27.085   8.533  1.00 14.67           C  
ATOM    342  OG  SER A 188      26.424  26.220   8.721  1.00 14.27           O  
ATOM    343  N   GLY A 189      27.436  26.306  11.798  1.00 15.42           N  
ATOM    344  CA  GLY A 189      26.543  26.388  12.960  1.00 16.48           C  
ATOM    345  C   GLY A 189      25.173  25.732  12.812  1.00 15.72           C  
ATOM    346  O   GLY A 189      24.376  25.723  13.754  1.00 16.19           O  
ATOM    347  N   LEU A 190      24.907  25.124  11.660  1.00 15.19           N  
ATOM    348  CA  LEU A 190      23.656  24.405  11.446  1.00 13.96           C  
ATOM    349  C   LEU A 190      23.599  23.147  12.304  1.00 16.09           C  
ATOM    350  O   LEU A 190      24.624  22.494  12.510  1.00 18.31           O  
ATOM    351  CB  LEU A 190      23.493  23.903  10.023  0.50 15.17           C  
ATOM    353  CG  LEU A 190      23.030  24.814   8.925  0.50 11.89           C  
ATOM    355  CD1 LEU A 190      23.045  24.029   7.626  0.50 12.63           C  
ATOM    357  CD2 LEU A 190      21.659  25.391   9.216  0.50 13.87           C  
ATOM    359  N   ARG A 191      22.394  22.799  12.750  1.00 16.23           N  
ATOM    360  CA  ARG A 191      22.129  21.639  13.587  1.00 18.68           C  
ATOM    361  C   ARG A 191      20.872  20.923  13.151  1.00 16.23           C  
ATOM    362  O   ARG A 191      19.939  21.543  12.685  1.00 16.35           O  
ATOM    363  CB  ARG A 191      21.978  22.051  15.045  1.00 21.28           C  
ATOM    364  CG  ARG A 191      23.196  22.742  15.627  1.00 25.99           C  
ATOM    365  CD  ARG A 191      24.399  21.787  15.717  1.00 33.41           C  
ATOM    366  N   ALA A 192      20.842  19.612  13.340  1.00 15.42           N  
ATOM    367  CA  ALA A 192      19.665  18.808  13.113  1.00 16.06           C  
ATOM    368  C   ALA A 192      18.499  19.427  13.899  1.00 15.62           C  
ATOM    369  O   ALA A 192      18.700  19.873  15.037  1.00 18.16           O  
ATOM    370  CB  ALA A 192      19.921  17.323  13.533  1.00 20.12           C  
ATOM    371  N   GLN A 193      17.323  19.441  13.264  1.00 16.11           N  
ATOM    372  CA  GLN A 193      16.077  19.954  13.810  1.00 15.54           C  
ATOM    373  C   GLN A 193      15.925  21.464  13.731  1.00 14.58           C  
ATOM    374  O   GLN A 193      14.850  21.981  14.053  1.00 16.61           O  
ATOM    375  CB  GLN A 193      15.864  19.502  15.232  1.00 20.00           C  
ATOM    376  CG  GLN A 193      15.681  18.042  15.334  1.00 26.75           C  
ATOM    377  CD  GLN A 193      14.707  17.772  16.417  1.00 36.40           C  
ATOM    378  OE1 GLN A 193      13.512  17.610  16.170  1.00 42.44           O  
ATOM    379  NE2 GLN A 193      15.178  17.866  17.638  1.00 36.18           N  
ATOM    380  N   ASP A 194      16.934  22.167  13.208  1.00 13.81           N  
ATOM    381  CA  ASP A 194      16.765  23.579  12.867  1.00 13.02           C  
ATOM    382  C   ASP A 194      15.671  23.769  11.802  1.00 14.13           C  
ATOM    383  O   ASP A 194      15.524  22.941  10.895  1.00 13.93           O  
ATOM    384  CB  ASP A 194      18.085  24.153  12.337  1.00 13.82           C  
ATOM    385  CG  ASP A 194      19.084  24.474  13.409  1.00 16.79           C  
ATOM    386  OD1 ASP A 194      18.735  24.475  14.604  1.00 21.07           O  
ATOM    387  OD2 ASP A 194      20.235  24.787  13.026  1.00 17.03           O  
ATOM    388  N   ARG A 195      14.929  24.879  11.921  1.00 11.98           N  
ATOM    389  CA  ARG A 195      13.937  25.271  10.932  1.00 12.83           C  
ATOM    390  C   ARG A 195      14.433  26.483  10.139  1.00 12.07           C  
ATOM    391  O   ARG A 195      14.974  27.430  10.703  1.00 12.42           O  
ATOM    392  CB  ARG A 195      12.628  25.637  11.613  1.00 16.27           C  
ATOM    393  CG  ARG A 195      11.526  26.031  10.622  1.00 16.13           C  
ATOM    394  CD  ARG A 195      10.174  26.171  11.289  1.00 21.61           C  
ATOM    395  NE  ARG A 195      10.184  27.256  12.245  1.00 22.55           N  
ATOM    396  CZ  ARG A 195       9.946  28.520  11.926  1.00 29.16           C  
ATOM    397  NH1 ARG A 195       9.673  28.849  10.672  1.00 30.04           N  
ATOM    398  NH2 ARG A 195       9.971  29.455  12.870  1.00 30.20           N  
ATOM    399  N   LEU A 196      14.281  26.402   8.821  1.00 10.88           N  
ATOM    400  CA  LEU A 196      14.789  27.390   7.910  1.00 11.46           C  
ATOM    401  C   LEU A 196      13.797  28.506   7.737  1.00 12.62           C  
ATOM    402  O   LEU A 196      12.657  28.276   7.390  1.00 14.84           O  
ATOM    403  CB  LEU A 196      15.075  26.729   6.574  1.00 14.44           C  
ATOM    404  CG  LEU A 196      15.870  27.420   5.505  1.00 16.93           C  
ATOM    405  CD1 LEU A 196      17.136  28.071   6.031  1.00 14.95           C  
ATOM    406  CD2 LEU A 196      16.175  26.405   4.354  1.00 15.65           C  
ATOM    407  N   ILE A 197      14.265  29.726   7.968  1.00 10.36           N  
ATOM    408  CA  ILE A 197      13.443  30.903   7.801  1.00 11.34           C  
ATOM    409  C   ILE A 197      13.797  31.700   6.530  1.00 10.89           C  
ATOM    410  O   ILE A 197      12.896  32.125   5.803  1.00 12.40           O  
ATOM    411  CB  ILE A 197      13.646  31.876   9.033  1.00 11.86           C  
ATOM    412  CG1 ILE A 197      13.305  31.187  10.356  0.50 15.11           C  
ATOM    414  CG2 ILE A 197      12.791  33.134   8.866  1.00 14.42           C  
ATOM    415  CD1 ILE A 197      13.770  31.946  11.540  0.50 14.22           C  
ATOM    417  N   GLU A 198      15.101  31.975   6.314  1.00 10.02           N  
ATOM    418  CA  GLU A 198      15.543  32.700   5.138  1.00 10.15           C  
ATOM    419  C   GLU A 198      16.698  31.972   4.475  1.00  8.55           C  
ATOM    420  O   GLU A 198      17.530  31.330   5.145  1.00  9.94           O  
ATOM    421  CB  GLU A 198      16.019  34.125   5.463  1.00 10.04           C  
ATOM    422  CG  GLU A 198      14.955  35.023   6.106  1.00 11.80           C  
ATOM    423  CD  GLU A 198      15.362  36.491   6.212  1.00 13.23           C  
ATOM    424  OE1 GLU A 198      16.533  36.804   5.859  1.00 15.40           O  
ATOM    425  OE2 GLU A 198      14.479  37.343   6.589  1.00 16.91           O  
ATOM    426  N   VAL A 199      16.776  32.143   3.158  1.00 10.06           N  
ATOM    427  CA  VAL A 199      17.905  31.723   2.322  1.00  9.48           C  
ATOM    428  C   VAL A 199      18.397  32.942   1.559  1.00  9.03           C  
ATOM    429  O   VAL A 199      17.665  33.588   0.823  1.00 10.37           O  
ATOM    430  CB  VAL A 199      17.539  30.587   1.353  1.00  9.72           C  
ATOM    431  CG1 VAL A 199      18.711  30.256   0.397  1.00 10.30           C  
ATOM    432  CG2 VAL A 199      17.064  29.352   2.092  1.00 12.31           C  
ATOM    433  N   ASN A 200      19.664  33.275   1.744  1.00 10.41           N  
ATOM    434  CA  ASN A 200      20.257  34.422   1.090  1.00 10.30           C  
ATOM    435  C   ASN A 200      19.421  35.701   1.227  1.00 11.80           C  
ATOM    436  O   ASN A 200      19.239  36.433   0.273  1.00 15.23           O  
ATOM    437  CB  ASN A 200      20.578  34.081  -0.362  1.00 10.05           C  
ATOM    438  CG  ASN A 200      21.576  32.960  -0.503  1.00  9.18           C  
ATOM    439  OD1 ASN A 200      22.408  32.756   0.357  1.00 11.96           O  
ATOM    440  ND2 ASN A 200      21.483  32.224  -1.610  1.00 11.73           N  
ATOM    441  N   GLY A 201      18.901  35.917   2.431  1.00 11.29           N  
ATOM    442  CA  GLY A 201      18.187  37.137   2.748  1.00 13.47           C  
ATOM    443  C   GLY A 201      16.743  37.147   2.422  1.00 13.08           C  
ATOM    444  O   GLY A 201      16.064  38.189   2.601  1.00 15.87           O  
ATOM    445  N   GLN A 202      16.245  36.070   1.825  1.00 12.86           N  
ATOM    446  CA  GLN A 202      14.862  35.953   1.366  1.00 14.45           C  
ATOM    447  C   GLN A 202      14.084  34.923   2.200  1.00 14.23           C  
ATOM    448  O   GLN A 202      14.504  33.782   2.384  1.00 13.77           O  
ATOM    449  CB  GLN A 202      14.834  35.556  -0.118  0.50 16.46           C  
ATOM    451  CG  GLN A 202      15.603  36.512  -1.027  0.50 20.24           C  
ATOM    453  CD  GLN A 202      15.475  36.182  -2.511  0.50 21.20           C  
ATOM    455  OE1 GLN A 202      15.574  35.023  -2.925  0.50 25.03           O  
ATOM    457  NE2 GLN A 202      15.283  37.211  -3.321  0.50 29.74           N  
ATOM    459  N   ASN A 203      12.945  35.343   2.742  1.00 13.32           N  
ATOM    460  CA  ASN A 203      12.108  34.474   3.504  1.00 14.25           C  
ATOM    461  C   ASN A 203      11.561  33.359   2.600  1.00 15.15           C  
ATOM    462  O   ASN A 203      11.118  33.631   1.483  1.00 17.26           O  
ATOM    463  CB  ASN A 203      10.977  35.262   4.143  1.00 14.84           C  
ATOM    464  CG  ASN A 203      10.159  34.407   5.056  1.00 13.55           C  
ATOM    465  OD1 ASN A 203       9.408  33.558   4.585  1.00 17.85           O  
ATOM    466  ND2 ASN A 203      10.328  34.592   6.363  1.00 16.90           N  
ATOM    467  N   VAL A 204      11.705  32.108   3.060  1.00 14.46           N  
ATOM    468  CA  VAL A 204      11.355  30.939   2.286  1.00 14.25           C  
ATOM    469  C   VAL A 204      10.195  30.183   2.893  1.00 17.52           C  
ATOM    470  O   VAL A 204       9.841  29.099   2.421  1.00 20.49           O  
ATOM    471  CB  VAL A 204      12.582  29.995   2.037  1.00 13.66           C  
ATOM    472  CG1 VAL A 204      13.601  30.743   1.180  1.00 14.89           C  
ATOM    473  CG2 VAL A 204      13.216  29.516   3.333  1.00 15.86           C  
ATOM    474  N   GLU A 205       9.561  30.767   3.907  1.00 19.84           N  
ATOM    475  CA  GLU A 205       8.542  30.069   4.645  1.00 22.96           C  
ATOM    476  C   GLU A 205       7.294  29.767   3.814  1.00 23.10           C  
ATOM    477  O   GLU A 205       6.614  28.796   4.096  1.00 27.70           O  
ATOM    478  CB  GLU A 205       8.202  30.819   5.941  1.00 22.13           C  
ATOM    479  CG  GLU A 205       9.375  30.875   6.934  1.00 22.17           C  
ATOM    480  CD  GLU A 205       9.047  31.647   8.197  1.00 24.39           C  
ATOM    481  OE1 GLU A 205       8.882  32.868   8.111  1.00 25.55           O  
ATOM    482  OE2 GLU A 205       8.946  31.036   9.277  1.00 36.45           O  
ATOM    483  N   GLY A 206       7.035  30.537   2.772  1.00 23.95           N  
ATOM    484  CA  GLY A 206       5.912  30.243   1.873  1.00 28.65           C  
ATOM    485  C   GLY A 206       6.116  29.242   0.741  1.00 28.84           C  
ATOM    486  O   GLY A 206       5.159  28.927   0.019  1.00 32.31           O  
ATOM    487  N   LEU A 207       7.346  28.731   0.580  1.00 25.07           N  
ATOM    488  CA  LEU A 207       7.718  27.964  -0.615  1.00 21.39           C  
ATOM    489  C   LEU A 207       7.565  26.446  -0.486  1.00 17.73           C  
ATOM    490  O   LEU A 207       7.686  25.889   0.591  1.00 22.55           O  
ATOM    491  CB  LEU A 207       9.174  28.259  -0.965  1.00 19.81           C  
ATOM    492  CG  LEU A 207       9.508  29.709  -1.310  1.00 21.50           C  
ATOM    493  CD1 LEU A 207      11.010  29.910  -1.677  1.00 22.48           C  
ATOM    494  CD2 LEU A 207       8.621  30.206  -2.448  1.00 23.99           C  
ATOM    495  N   ARG A 208       7.393  25.779  -1.634  1.00 17.33           N  
ATOM    496  CA  ARG A 208       7.487  24.327  -1.684  1.00 15.91           C  
ATOM    497  C   ARG A 208       8.937  23.841  -1.542  1.00 13.20           C  
ATOM    498  O   ARG A 208       9.862  24.574  -1.826  1.00 15.50           O  
ATOM    499  CB  ARG A 208       6.983  23.819  -3.022  1.00 18.07           C  
ATOM    500  CG  ARG A 208       5.534  24.157  -3.326  1.00 22.99           C  
ATOM    501  CD  ARG A 208       5.245  23.604  -4.701  1.00 32.14           C  
ATOM    502  NE  ARG A 208       3.838  23.686  -5.106  1.00 35.06           N  
ATOM    503  CZ  ARG A 208       2.956  22.705  -4.959  1.00 32.45           C  
ATOM    504  NH1 ARG A 208       3.314  21.548  -4.410  1.00 32.77           N  
ATOM    505  NH2 ARG A 208       1.702  22.884  -5.378  1.00 32.64           N  
ATOM    506  N   HIS A 209       9.106  22.608  -1.080  1.00 13.54           N  
ATOM    507  CA  HIS A 209      10.424  22.012  -0.914  1.00 13.17           C  
ATOM    508  C   HIS A 209      11.356  22.278  -2.111  1.00 11.93           C  
ATOM    509  O   HIS A 209      12.485  22.731  -1.931  1.00 12.56           O  
ATOM    510  CB  HIS A 209      10.270  20.495  -0.686  1.00 14.43           C  
ATOM    511  CG  HIS A 209      11.562  19.771  -0.468  1.00 13.20           C  
ATOM    512  ND1 HIS A 209      12.244  19.831   0.726  1.00 13.75           N  
ATOM    513  CD2 HIS A 209      12.302  18.990  -1.292  1.00 14.49           C  
ATOM    514  CE1 HIS A 209      13.345  19.086   0.638  1.00 14.69           C  
ATOM    515  NE2 HIS A 209      13.422  18.598  -0.590  1.00 13.92           N  
ATOM    516  N   ALA A 210      10.893  21.995  -3.329  1.00 14.42           N  
ATOM    517  CA  ALA A 210      11.781  22.114  -4.488  1.00 14.93           C  
ATOM    518  C   ALA A 210      12.295  23.539  -4.669  1.00 12.93           C  
ATOM    519  O   ALA A 210      13.410  23.764  -5.131  1.00 14.06           O  
ATOM    520  CB  ALA A 210      11.082  21.646  -5.748  1.00 18.13           C  
ATOM    521  N   GLU A 211      11.439  24.506  -4.371  1.00 14.04           N  
ATOM    522  CA  GLU A 211      11.793  25.926  -4.517  1.00 15.40           C  
ATOM    523  C   GLU A 211      12.810  26.308  -3.437  1.00 13.39           C  
ATOM    524  O   GLU A 211      13.708  27.092  -3.683  1.00 12.61           O  
ATOM    525  CB  GLU A 211      10.548  26.840  -4.438  1.00 17.09           C  
ATOM    526  CG  GLU A 211       9.416  26.625  -5.491  1.00 20.66           C  
ATOM    527  CD  GLU A 211       8.141  27.522  -5.182  1.00 27.41           C  
ATOM    528  OE1 GLU A 211       7.345  27.178  -4.261  1.00 28.16           O  
ATOM    529  OE2 GLU A 211       7.938  28.592  -5.854  1.00 39.18           O  
ATOM    530  N   VAL A 212      12.667  25.772  -2.231  1.00 12.23           N  
ATOM    531  CA  VAL A 212      13.641  26.085  -1.182  1.00 10.52           C  
ATOM    532  C   VAL A 212      14.990  25.480  -1.557  1.00 10.85           C  
ATOM    533  O   VAL A 212      16.026  26.127  -1.441  1.00 10.94           O  
ATOM    534  CB  VAL A 212      13.164  25.574   0.206  1.00 11.13           C  
ATOM    535  CG1 VAL A 212      14.235  25.870   1.279  1.00 12.22           C  
ATOM    536  CG2 VAL A 212      11.820  26.227   0.594  1.00 13.72           C  
ATOM    537  N   VAL A 213      14.972  24.262  -2.076  1.00  9.69           N  
ATOM    538  CA  VAL A 213      16.212  23.610  -2.582  1.00 12.03           C  
ATOM    539  C   VAL A 213      16.872  24.491  -3.660  1.00 10.77           C  
ATOM    540  O   VAL A 213      18.058  24.768  -3.617  1.00 11.64           O  
ATOM    541  CB  VAL A 213      15.912  22.205  -3.141  1.00 10.53           C  
ATOM    542  CG1 VAL A 213      17.103  21.657  -3.957  1.00 13.68           C  
ATOM    543  CG2 VAL A 213      15.543  21.265  -1.958  1.00 13.95           C  
ATOM    544  N   ALA A 214      16.072  24.979  -4.611  1.00 11.75           N  
ATOM    545  CA  ALA A 214      16.610  25.829  -5.669  1.00 11.54           C  
ATOM    546  C   ALA A 214      17.237  27.094  -5.083  1.00 11.11           C  
ATOM    547  O   ALA A 214      18.316  27.548  -5.502  1.00 12.05           O  
ATOM    548  CB  ALA A 214      15.530  26.164  -6.683  1.00 13.73           C  
ATOM    549  N   SER A 215      16.568  27.672  -4.108  1.00 10.55           N  
ATOM    550  CA  SER A 215      17.090  28.884  -3.490  1.00 10.62           C  
ATOM    551  C   SER A 215      18.452  28.622  -2.831  1.00 10.32           C  
ATOM    552  O   SER A 215      19.371  29.445  -2.947  1.00 10.05           O  
ATOM    553  CB  SER A 215      16.117  29.427  -2.448  0.50 11.22           C  
ATOM    555  OG  SER A 215      14.884  29.805  -3.025  0.50 15.54           O  
ATOM    557  N   ILE A 216      18.599  27.482  -2.142  1.00 10.16           N  
ATOM    558  CA  ILE A 216      19.887  27.140  -1.499  1.00  9.36           C  
ATOM    559  C   ILE A 216      20.975  26.934  -2.550  1.00  9.21           C  
ATOM    560  O   ILE A 216      22.127  27.338  -2.359  1.00 10.34           O  
ATOM    561  CB  ILE A 216      19.715  25.911  -0.602  1.00  8.91           C  
ATOM    562  CG1 ILE A 216      18.767  26.228   0.557  1.00  9.38           C  
ATOM    563  CG2 ILE A 216      21.045  25.399  -0.087  1.00 10.83           C  
ATOM    564  CD1 ILE A 216      18.271  25.014   1.279  1.00 11.82           C  
ATOM    565  N   LYS A 217      20.606  26.347  -3.690  1.00  9.65           N  
ATOM    566  CA  LYS A 217      21.568  26.065  -4.730  1.00 10.12           C  
ATOM    567  C   LYS A 217      21.853  27.273  -5.657  1.00 11.78           C  
ATOM    568  O   LYS A 217      22.623  27.144  -6.609  1.00 13.85           O  
ATOM    569  CB  LYS A 217      21.070  24.899  -5.588  1.00 11.44           C  
ATOM    570  CG  LYS A 217      21.001  23.526  -4.885  1.00 13.71           C  
ATOM    571  CD  LYS A 217      20.543  22.427  -5.909  1.00 18.17           C  
ATOM    572  CE  LYS A 217      20.443  21.054  -5.307  1.00 22.61           C  
ATOM    573  NZ  LYS A 217      20.075  20.045  -6.328  1.00 31.44           N  
ATOM    574  N   ALA A 218      21.318  28.456  -5.342  1.00 10.93           N  
ATOM    575  CA  ALA A 218      21.385  29.575  -6.293  1.00 11.33           C  
ATOM    576  C   ALA A 218      22.792  30.113  -6.551  1.00 10.71           C  
ATOM    577  O   ALA A 218      23.107  30.503  -7.674  1.00 13.75           O  
ATOM    578  CB  ALA A 218      20.486  30.703  -5.854  1.00 12.75           C  
ATOM    579  N   ARG A 219      23.609  30.207  -5.508  1.00 11.56           N  
ATOM    580  CA  ARG A 219      24.951  30.724  -5.638  1.00 10.97           C  
ATOM    581  C   ARG A 219      25.961  29.572  -5.725  1.00  9.65           C  
ATOM    582  O   ARG A 219      25.818  28.548  -5.074  1.00 14.25           O  
ATOM    583  CB  ARG A 219      25.313  31.638  -4.466  1.00 12.77           C  
ATOM    584  CG  ARG A 219      24.353  32.806  -4.320  1.00 13.95           C  
ATOM    585  CD  ARG A 219      24.728  33.727  -3.167  1.00 20.90           C  
ATOM    586  NE  ARG A 219      23.682  34.734  -2.961  1.00 28.04           N  
ATOM    587  CZ  ARG A 219      23.801  35.796  -2.183  1.00 33.25           C  
ATOM    588  NH1 ARG A 219      24.932  36.043  -1.534  1.00 42.79           N  
ATOM    589  NH2 ARG A 219      22.779  36.631  -2.079  1.00 31.98           N  
ATOM    590  N   GLU A 220      27.001  29.748  -6.516  1.00 10.68           N  
ATOM    591  CA  GLU A 220      27.952  28.655  -6.631  1.00 11.17           C  
ATOM    592  C   GLU A 220      28.683  28.378  -5.339  1.00 13.94           C  
ATOM    593  O   GLU A 220      28.905  27.201  -5.042  1.00 17.06           O  
ATOM    594  CB  GLU A 220      28.957  28.927  -7.753  1.00 14.14           C  
ATOM    595  CG  GLU A 220      29.994  27.808  -7.927  1.00 14.97           C  
ATOM    596  CD  GLU A 220      29.379  26.461  -8.343  1.00 18.54           C  
ATOM    597  OE1 GLU A 220      28.317  26.489  -8.999  1.00 20.49           O  
ATOM    598  OE2 GLU A 220      29.982  25.372  -8.066  1.00 19.48           O  
ATOM    599  N   ASP A 221      29.092  29.433  -4.646  1.00 12.60           N  
ATOM    600  CA  ASP A 221      30.120  29.405  -3.586  1.00 13.45           C  
ATOM    601  C   ASP A 221      29.602  29.164  -2.181  1.00  9.62           C  
ATOM    602  O   ASP A 221      30.336  28.764  -1.294  1.00 10.14           O  
ATOM    603  CB  ASP A 221      30.920  30.768  -3.466  1.00 15.15           C  
ATOM    604  CG  ASP A 221      31.715  31.178  -4.705  1.00 18.41           C  
ATOM    605  OD1 ASP A 221      32.038  30.338  -5.548  1.00 30.64           O  
ATOM    606  OD2 ASP A 221      32.016  32.415  -4.788  1.00 27.90           O  
ATOM    607  N   GLU A 222      28.360  29.559  -1.950  1.00  9.01           N  
ATOM    608  CA  GLU A 222      27.892  29.762  -0.600  1.00  8.42           C  
ATOM    609  C   GLU A 222      26.377  29.807  -0.511  1.00  8.82           C  
ATOM    610  O   GLU A 222      25.701  30.049  -1.504  1.00  9.58           O  
ATOM    611  CB  GLU A 222      28.446  31.089  -0.074  1.00 12.65           C  
ATOM    612  CG  GLU A 222      28.068  32.281  -0.878  1.00 15.10           C  
ATOM    613  CD  GLU A 222      28.581  33.600  -0.366  1.00 23.59           C  
ATOM    614  OE1 GLU A 222      29.547  33.667   0.445  1.00 24.50           O  
ATOM    615  OE2 GLU A 222      27.947  34.587  -0.835  1.00 34.39           O  
ATOM    616  N   ALA A 223      25.890  29.664   0.714  1.00  9.20           N  
ATOM    617  CA  ALA A 223      24.501  29.896   1.064  1.00 10.01           C  
ATOM    618  C   ALA A 223      24.461  30.461   2.471  1.00 10.14           C  
ATOM    619  O   ALA A 223      25.189  30.032   3.340  1.00 13.53           O  
ATOM    620  CB  ALA A 223      23.705  28.634   0.957  1.00 11.52           C  
ATOM    621  N   ARG A 224      23.594  31.426   2.691  1.00  9.81           N  
ATOM    622  CA  ARG A 224      23.368  32.007   4.006  1.00  9.24           C  
ATOM    623  C   ARG A 224      21.987  31.593   4.436  1.00  9.71           C  
ATOM    624  O   ARG A 224      20.985  32.012   3.824  1.00 10.43           O  
ATOM    625  CB  ARG A 224      23.491  33.527   3.909  0.50 12.73           C  
ATOM    627  CG  ARG A 224      24.841  33.938   3.334  0.50 14.81           C  
ATOM    629  CD  ARG A 224      24.939  35.456   3.200  0.50 18.56           C  
ATOM    631  NE  ARG A 224      25.364  36.021   4.468  0.50 24.82           N  
ATOM    633  CZ  ARG A 224      26.628  36.274   4.801  0.50 24.12           C  
ATOM    635  NH1 ARG A 224      26.884  36.750   5.996  0.50 28.77           N  
ATOM    637  NH2 ARG A 224      27.629  36.083   3.949  0.50 28.76           N  
ATOM    639  N   LEU A 225      21.935  30.782   5.494  1.00  9.15           N  
ATOM    640  CA  LEU A 225      20.679  30.226   5.997  1.00  8.03           C  
ATOM    641  C   LEU A 225      20.393  30.822   7.368  1.00  9.55           C  
ATOM    642  O   LEU A 225      21.182  30.731   8.286  1.00 10.00           O  
ATOM    643  CB  LEU A 225      20.793  28.716   6.137  1.00  9.06           C  
ATOM    644  CG  LEU A 225      21.265  27.921   4.913  1.00 16.24           C  
ATOM    645  CD1 LEU A 225      21.234  26.414   5.118  1.00 16.51           C  
ATOM    646  CD2 LEU A 225      20.525  28.258   3.717  1.00 15.58           C  
ATOM    647  N   LEU A 226      19.239  31.448   7.490  1.00  7.78           N  
ATOM    648  CA  LEU A 226      18.758  31.955   8.784  1.00  8.00           C  
ATOM    649  C   LEU A 226      17.848  30.910   9.346  1.00  8.49           C  
ATOM    650  O   LEU A 226      16.867  30.534   8.710  1.00  9.28           O  
ATOM    651  CB  LEU A 226      17.977  33.267   8.605  1.00  8.21           C  
ATOM    652  CG  LEU A 226      17.642  33.995   9.929  1.00  8.45           C  
ATOM    653  CD1 LEU A 226      18.927  34.541  10.580  1.00 11.36           C  
ATOM    654  CD2 LEU A 226      16.639  35.096   9.693  1.00 11.45           C  
ATOM    655  N   VAL A 227      18.210  30.422  10.530  1.00  9.20           N  
ATOM    656  CA  VAL A 227      17.546  29.278  11.134  1.00  8.61           C  
ATOM    657  C   VAL A 227      17.177  29.543  12.591  1.00  8.89           C  
ATOM    658  O   VAL A 227      17.760  30.406  13.265  1.00 10.74           O  
ATOM    659  CB  VAL A 227      18.402  28.009  11.045  1.00  9.45           C  
ATOM    660  CG1 VAL A 227      18.737  27.651   9.622  1.00 10.33           C  
ATOM    661  CG2 VAL A 227      19.673  28.100  11.897  1.00 13.13           C  
ATOM    662  N   VAL A 228      16.210  28.779  13.071  1.00 10.19           N  
ATOM    663  CA  VAL A 228      15.884  28.769  14.495  1.00 11.68           C  
ATOM    664  C   VAL A 228      15.873  27.334  14.982  1.00 12.44           C  
ATOM    665  O   VAL A 228      15.620  26.436  14.207  1.00 13.87           O  
ATOM    666  CB  VAL A 228      14.517  29.441  14.779  1.00 14.08           C  
ATOM    667  CG1 VAL A 228      14.578  30.917  14.500  1.00 18.22           C  
ATOM    668  CG2 VAL A 228      13.385  28.771  14.013  1.00 15.67           C  
ATOM    669  N   GLY A 229      16.079  27.129  16.275  1.00 12.78           N  
ATOM    670  CA  GLY A 229      16.011  25.775  16.826  1.00 12.26           C  
ATOM    671  C   GLY A 229      14.576  25.321  16.986  1.00 12.99           C  
ATOM    672  O   GLY A 229      13.630  26.068  16.706  1.00 14.03           O  
ATOM    673  N   PRO A 230      14.393  24.071  17.397  1.00 13.69           N  
ATOM    674  CA  PRO A 230      13.042  23.532  17.497  1.00 14.39           C  
ATOM    675  C   PRO A 230      12.170  24.262  18.514  1.00 14.00           C  
ATOM    676  O   PRO A 230      12.658  24.776  19.518  1.00 15.55           O  
ATOM    677  CB  PRO A 230      13.244  22.082  17.888  1.00 18.78           C  
ATOM    678  CG  PRO A 230      14.629  21.897  18.201  1.00 19.25           C  
ATOM    679  CD  PRO A 230      15.429  23.070  17.696  1.00 14.54           C  
ATOM    680  N   SER A 231      10.878  24.286  18.230  1.00 14.85           N  
ATOM    681  CA  SER A 231       9.915  24.822  19.146  1.00 14.79           C  
ATOM    682  C   SER A 231       8.627  24.045  19.064  1.00 12.89           C  
ATOM    683  O   SER A 231       8.283  23.476  18.022  1.00 17.13           O  
ATOM    684  CB  SER A 231       9.674  26.290  18.862  1.00 21.37           C  
ATOM    685  OG  SER A 231       9.144  26.461  17.585  1.00 24.16           O  
ATOM    686  N   THR A 232       7.903  24.054  20.170  1.00 11.72           N  
ATOM    687  CA  THR A 232       6.624  23.366  20.272  1.00 12.89           C  
ATOM    688  C   THR A 232       5.676  24.213  21.102  1.00 12.64           C  
ATOM    689  O   THR A 232       6.021  24.684  22.165  1.00 12.74           O  
ATOM    690  CB  THR A 232       6.823  21.948  20.941  1.00 14.35           C  
ATOM    691  OG1 THR A 232       7.754  21.185  20.180  1.00 16.84           O  
ATOM    692  CG2 THR A 232       5.531  21.105  21.030  1.00 15.58           C  
ATOM    693  N   ARG A 233       4.445  24.346  20.632  1.00 13.29           N  
ATOM    694  CA  ARG A 233       3.348  24.944  21.394  1.00 14.85           C  
ATOM    695  C   ARG A 233       2.748  23.913  22.317  1.00 14.34           C  
ATOM    696  O   ARG A 233       2.392  22.824  21.884  1.00 17.47           O  
ATOM    697  CB  ARG A 233       2.262  25.499  20.462  0.60 17.93           C  
ATOM    699  CG  ARG A 233       2.739  26.689  19.674  0.60 23.32           C  
ATOM    701  CD  ARG A 233       1.682  27.198  18.686  0.60 29.83           C  
ATOM    703  NE  ARG A 233       1.257  26.166  17.732  0.60 41.22           N  
ATOM    705  CZ  ARG A 233       0.358  26.357  16.764  0.60 46.73           C  
ATOM    707  NH1 ARG A 233      -0.219  27.545  16.589  0.60 51.71           N  
ATOM    709  NH2 ARG A 233       0.039  25.356  15.959  0.60 45.06           N  
ATOM    711  N   LEU A 234       2.664  24.262  23.600  1.00 13.47           N  
ATOM    712  CA  LEU A 234       2.150  23.406  24.651  1.00 14.93           C  
ATOM    713  C   LEU A 234       0.909  23.927  25.309  1.00 15.98           C  
ATOM    714  O   LEU A 234       0.610  25.135  25.173  1.00 17.29           O  
ATOM    715  CB  LEU A 234       3.234  23.243  25.711  1.00 15.62           C  
ATOM    716  CG  LEU A 234       4.362  22.372  25.160  1.00 23.89           C  
ATOM    717  CD1 LEU A 234       5.684  22.710  25.693  1.00 27.57           C  
ATOM    718  CD2 LEU A 234       4.016  20.961  25.539  1.00 27.45           C  
ATOM    719  OXT LEU A 234       0.167  23.155  25.981  1.00 16.98           O  
TER     720      LEU A 234                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
