
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  105 ( 1456),  selected  105 , name 1wha_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 1wha_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      H       2           -
LGA    -       -      H       3           -
LGA    -       -      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    G     1_A      V      11          2.784
LGA    S     2_A      D      12          5.496
LGA    -       -      L      13           -
LGA    S     3_A      G      14          4.496
LGA    G     4_A      T      15          2.610
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    -       -      L      18           -
LGA    S     5_A      Y      19          2.038
LGA    S     6_A      F      20          3.734
LGA    -       -      Q      21           -
LGA    G     7_A      S      22          4.559
LGA    R     8_A      M      23          3.313
LGA    -       -      P      24           -
LGA    H     9_A      R      25          1.098
LGA    V    10_A      S      26          0.588
LGA    A    11_A      I      27          0.596
LGA    C    12_A      R      28          0.934
LGA    L    13_A      F      29          0.931
LGA    A    14_A      T      30          1.397
LGA    R    15_A      A      31          1.949
LGA    S    16_A      E      32          3.253
LGA    E    17_A      E      33          3.588
LGA    R    18_A      G      34          4.272
LGA    G    19_A      D      35          0.888
LGA    L    20_A      L      36          1.728
LGA    G    21_A      G      37          0.761
LGA    F    22_A      F      38          1.587
LGA    S    23_A      T      39          1.919
LGA    I    24_A      L      40          1.396
LGA    A    25_A      R      41          1.041
LGA    G    26_A      G      42          0.753
LGA    G    27_A      N      43          2.476
LGA    K    28_A      -       -           -
LGA    G    29_A      -       -           -
LGA    S    30_A      -       -           -
LGA    T    31_A      -       -           -
LGA    P    32_A      -       -           -
LGA    Y    33_A      -       -           -
LGA    R    34_A      -       -           -
LGA    A    35_A      -       -           -
LGA    G    36_A      -       -           -
LGA    D    37_A      -       -           -
LGA    A    38_A      A      44          4.026
LGA    G    39_A      P      45          1.881
LGA    I    40_A      V      46          0.904
LGA    F    41_A      Q      47          0.920
LGA    V    42_A      V      48          0.542
LGA    S    43_A      H      49          0.513
LGA    R    44_A      F      50          1.274
LGA    I    45_A      L      51          1.057
LGA    A    46_A      D      52          1.603
LGA    E    47_A      P      53          1.751
LGA    G    48_A      Y      54          1.923
LGA    G    49_A      C      55          2.452
LGA    A    50_A      S      56          1.297
LGA    A    51_A      A      57          1.846
LGA    H    52_A      S      58          2.020
LGA    R    53_A      V      59          2.210
LGA    A    54_A      A      60          2.241
LGA    G    55_A      G      61          2.589
LGA    T    56_A      -       -           -
LGA    L    57_A      A      62          0.789
LGA    Q    58_A      R      63          0.493
LGA    V    59_A      E      64          0.162
LGA    G    60_A      G      65          0.814
LGA    D    61_A      D      66          0.975
LGA    R    62_A      Y      67          0.706
LGA    V    63_A      I      68          0.722
LGA    L    64_A      V      69          0.720
LGA    S    65_A      S      70          0.838
LGA    I    66_A      I      71          1.269
LGA    N    67_A      Q      72          2.509
LGA    G    68_A      L      73          1.567
LGA    V    69_A      V      74          0.730
LGA    D    70_A      D      75          0.683
LGA    V    71_A      C      76          0.868
LGA    T    72_A      K      77          0.707
LGA    E    73_A      W      78          1.692
LGA    A    74_A      L      79          0.664
LGA    R    75_A      T      80          1.431
LGA    H    76_A      L      81          1.531
LGA    D    77_A      S      82          1.401
LGA    H    78_A      E      83          1.342
LGA    A    79_A      V      84          1.336
LGA    V    80_A      M      85          1.558
LGA    S    81_A      K      86          1.895
LGA    L    82_A      L      87          1.088
LGA    L    83_A      L      88          0.491
LGA    T    84_A      K      89          0.744
LGA    A    85_A      S      90          0.840
LGA    A    86_A      F      91          3.330
LGA    S    87_A      G      92          3.837
LGA    -       -      E      93           -
LGA    P    88_A      D      94          0.726
LGA    T    89_A      E      95          1.048
LGA    I    90_A      I      96          0.955
LGA    A    91_A      E      97          0.957
LGA    L    92_A      M      98          0.951
LGA    L    93_A      K      99          0.605
LGA    L    94_A      V     100          0.734
LGA    E    95_A      V     101          1.360
LGA    R    96_A      S     102          3.343
LGA    E    97_A      L     103          3.257
LGA    A    98_A      L     104           -
LGA    G    99_A      -       -           -
LGA    S   100_A      -       -           -
LGA    G   101_A      -       -           -
LGA    P   102_A      -       -           -
LGA    S   103_A      -       -           -
LGA    S   104_A      -       -           -
LGA    G   105_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  105  104    5.0     86    2.01    22.09     73.144     4.084

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.507819 * X  +  -0.768450 * Y  +   0.389364 * Z  +  22.391638
  Y_new =  -0.267208 * X  +  -0.570195 * Y  +  -0.776838 * Z  +  29.985723
  Z_new =   0.818975 * X  +   0.290452 * Y  +  -0.494892 * Z  +   4.286070 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.610861   -0.530732  [ DEG:   149.5913    -30.4087 ]
  Theta =  -0.959622   -2.181971  [ DEG:   -54.9823   -125.0177 ]
  Phi   =  -0.484377    2.657216  [ DEG:   -27.7528    152.2472 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wha_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wha_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  105  104   5.0   86   2.01   22.09  73.144
REMARK  ---------------------------------------------------------- 
MOLECULE 1wha_A
HEADER    SIGNALING PROTEIN                       28-MAY-04   1WHA              
TITLE     SOLUTION STRUCTURE OF THE SECOND PDZ DOMAIN OF HUMAN                  
TITLE    2 SCRIBBLE (KIAA0147 PROTEIN).                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: KIAA0147 PROTEIN;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ DOMAIN;                                                
COMPND   5 SYNONYM: SCRIBBLE;                                                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KAZUSA CDNA HA01022S1;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P021030-56;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    PDZ DOMAIN, CELLULAR SIGNALING, STRUCTURAL GENOMICS, RIKEN            
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    N.TOCHIO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN                  
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   28-NOV-04 1WHA    0                                                
JRNL        AUTH   N.TOCHIO,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA               
JRNL        TITL   SOLUTION STRUCTURE OF THE SECOND PDZ DOMAIN OF               
JRNL        TITL 2 HUMAN SCRIBBLE (KIAA0147 PROTEIN).                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WHA A    8    99  UNP    Q14160   LAP4_HUMAN     860    951             
SEQRES   1 A  105  GLY SER SER GLY SER SER GLY ARG HIS VAL ALA CYS LEU          
SEQRES   2 A  105  ALA ARG SER GLU ARG GLY LEU GLY PHE SER ILE ALA GLY          
SEQRES   3 A  105  GLY LYS GLY SER THR PRO TYR ARG ALA GLY ASP ALA GLY          
SEQRES   4 A  105  ILE PHE VAL SER ARG ILE ALA GLU GLY GLY ALA ALA HIS          
SEQRES   5 A  105  ARG ALA GLY THR LEU GLN VAL GLY ASP ARG VAL LEU SER          
SEQRES   6 A  105  ILE ASN GLY VAL ASP VAL THR GLU ALA ARG HIS ASP HIS          
SEQRES   7 A  105  ALA VAL SER LEU LEU THR ALA ALA SER PRO THR ILE ALA          
SEQRES   8 A  105  LEU LEU LEU GLU ARG GLU ALA GLY SER GLY PRO SER SER          
SEQRES   9 A  105  GLY                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      14.322  32.087  38.263  1.00  0.00           N  
ATOM      2  CA  GLY A   1      13.194  31.273  37.848  1.00  0.00           C  
ATOM      3  C   GLY A   1      13.350  30.742  36.437  1.00  0.00           C  
ATOM      4  O   GLY A   1      14.467  30.520  35.970  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      13.096  30.440  38.528  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      12.296  31.872  37.897  1.00  0.00           H  
ATOM      7  H1  GLY A   1      14.336  32.481  39.160  1.00  0.00           H  
ATOM      8  N   SER A   2      12.227  30.536  35.757  1.00  0.00           N  
ATOM      9  CA  SER A   2      12.243  30.022  34.393  1.00  0.00           C  
ATOM     10  C   SER A   2      12.284  31.163  33.382  1.00  0.00           C  
ATOM     11  O   SER A   2      11.766  32.251  33.636  1.00  0.00           O  
ATOM     12  CB  SER A   2      11.015  29.146  34.141  1.00  0.00           C  
ATOM     13  OG  SER A   2      11.140  27.891  34.788  1.00  0.00           O  
ATOM     14  H   SER A   2      11.366  30.732  36.184  1.00  0.00           H  
ATOM     15  HA  SER A   2      13.133  29.421  34.276  1.00  0.00           H  
ATOM     16  HB2 SER A   2      10.135  29.646  34.518  1.00  0.00           H  
ATOM     17  HB3 SER A   2      10.905  28.980  33.078  1.00  0.00           H  
ATOM     18  HG  SER A   2      10.378  27.346  34.580  1.00  0.00           H  
ATOM     19  N   SER A   3      12.903  30.908  32.234  1.00  0.00           N  
ATOM     20  CA  SER A   3      13.017  31.915  31.186  1.00  0.00           C  
ATOM     21  C   SER A   3      13.378  31.270  29.850  1.00  0.00           C  
ATOM     22  O   SER A   3      14.474  30.737  29.683  1.00  0.00           O  
ATOM     23  CB  SER A   3      14.069  32.959  31.563  1.00  0.00           C  
ATOM     24  OG  SER A   3      15.326  32.351  31.806  1.00  0.00           O  
ATOM     25  H   SER A   3      13.297  30.022  32.090  1.00  0.00           H  
ATOM     26  HA  SER A   3      12.057  32.402  31.089  1.00  0.00           H  
ATOM     27  HB2 SER A   3      14.176  33.667  30.755  1.00  0.00           H  
ATOM     28  HB3 SER A   3      13.754  33.477  32.457  1.00  0.00           H  
ATOM     29  HG  SER A   3      15.722  32.089  30.972  1.00  0.00           H  
ATOM     30  N   GLY A   4      12.447  31.327  28.902  1.00  0.00           N  
ATOM     31  CA  GLY A   4      12.685  30.745  27.594  1.00  0.00           C  
ATOM     32  C   GLY A   4      12.703  31.785  26.491  1.00  0.00           C  
ATOM     33  O   GLY A   4      11.658  32.307  26.105  1.00  0.00           O  
ATOM     34  H   GLY A   4      11.591  31.765  29.093  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      13.636  30.233  27.607  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      11.905  30.028  27.384  1.00  0.00           H  
ATOM     37  N   SER A   5      13.894  32.088  25.986  1.00  0.00           N  
ATOM     38  CA  SER A   5      14.045  33.077  24.925  1.00  0.00           C  
ATOM     39  C   SER A   5      14.913  32.534  23.794  1.00  0.00           C  
ATOM     40  O   SER A   5      16.129  32.398  23.940  1.00  0.00           O  
ATOM     41  CB  SER A   5      14.658  34.363  25.482  1.00  0.00           C  
ATOM     42  OG  SER A   5      15.846  34.091  26.203  1.00  0.00           O  
ATOM     43  H   SER A   5      14.692  31.637  26.336  1.00  0.00           H  
ATOM     44  HA  SER A   5      13.063  33.297  24.535  1.00  0.00           H  
ATOM     45  HB2 SER A   5      14.892  35.030  24.665  1.00  0.00           H  
ATOM     46  HB3 SER A   5      13.950  34.840  26.144  1.00  0.00           H  
ATOM     47  HG  SER A   5      16.291  33.335  25.814  1.00  0.00           H  
ATOM     48  N   SER A   6      14.281  32.225  22.667  1.00  0.00           N  
ATOM     49  CA  SER A   6      14.994  31.692  21.512  1.00  0.00           C  
ATOM     50  C   SER A   6      15.880  32.761  20.880  1.00  0.00           C  
ATOM     51  O   SER A   6      15.830  33.930  21.261  1.00  0.00           O  
ATOM     52  CB  SER A   6      14.002  31.157  20.476  1.00  0.00           C  
ATOM     53  OG  SER A   6      13.140  32.184  20.019  1.00  0.00           O  
ATOM     54  H   SER A   6      13.311  32.355  22.612  1.00  0.00           H  
ATOM     55  HA  SER A   6      15.618  30.880  21.853  1.00  0.00           H  
ATOM     56  HB2 SER A   6      14.546  30.760  19.633  1.00  0.00           H  
ATOM     57  HB3 SER A   6      13.407  30.374  20.923  1.00  0.00           H  
ATOM     58  HG  SER A   6      12.436  32.319  20.658  1.00  0.00           H  
ATOM     59  N   GLY A   7      16.692  32.351  19.910  1.00  0.00           N  
ATOM     60  CA  GLY A   7      17.579  33.285  19.241  1.00  0.00           C  
ATOM     61  C   GLY A   7      17.948  32.832  17.841  1.00  0.00           C  
ATOM     62  O   GLY A   7      18.436  31.719  17.652  1.00  0.00           O  
ATOM     63  H   GLY A   7      16.689  31.407  19.648  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      17.090  34.247  19.180  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      18.482  33.387  19.824  1.00  0.00           H  
ATOM     66  N   ARG A   8      17.713  33.697  16.861  1.00  0.00           N  
ATOM     67  CA  ARG A   8      18.022  33.379  15.472  1.00  0.00           C  
ATOM     68  C   ARG A   8      19.454  33.778  15.128  1.00  0.00           C  
ATOM     69  O   ARG A   8      19.908  34.867  15.478  1.00  0.00           O  
ATOM     70  CB  ARG A   8      17.044  34.089  14.533  1.00  0.00           C  
ATOM     71  CG  ARG A   8      15.584  33.834  14.869  1.00  0.00           C  
ATOM     72  CD  ARG A   8      14.683  34.912  14.289  1.00  0.00           C  
ATOM     73  NE  ARG A   8      14.549  36.057  15.186  1.00  0.00           N  
ATOM     74  CZ  ARG A   8      13.848  37.145  14.890  1.00  0.00           C  
ATOM     75  NH1 ARG A   8      13.220  37.237  13.726  1.00  0.00           N  
ATOM     76  NH2 ARG A   8      13.774  38.145  15.759  1.00  0.00           N  
ATOM     77  H   ARG A   8      17.323  34.570  17.075  1.00  0.00           H  
ATOM     78  HA  ARG A   8      17.917  32.312  15.345  1.00  0.00           H  
ATOM     79  HB2 ARG A   8      17.221  35.154  14.586  1.00  0.00           H  
ATOM     80  HB3 ARG A   8      17.223  33.752  13.525  1.00  0.00           H  
ATOM     81  HG2 ARG A   8      15.292  32.878  14.461  1.00  0.00           H  
ATOM     82  HG3 ARG A   8      15.468  33.820  15.943  1.00  0.00           H  
ATOM     83  HD2 ARG A   8      15.102  35.249  13.353  1.00  0.00           H  
ATOM     84  HD3 ARG A   8      13.705  34.489  14.113  1.00  0.00           H  
ATOM     85  HE  ARG A   8      15.005  36.010  16.052  1.00  0.00           H  
ATOM     86 HH11 ARG A   8      13.273  36.485  13.069  1.00  0.00           H  
ATOM     87 HH12 ARG A   8      12.692  38.057  13.506  1.00  0.00           H  
ATOM     88 HH21 ARG A   8      14.246  38.079  16.638  1.00  0.00           H  
ATOM     89 HH22 ARG A   8      13.246  38.964  15.536  1.00  0.00           H  
ATOM     90  N   HIS A   9      20.162  32.887  14.440  1.00  0.00           N  
ATOM     91  CA  HIS A   9      21.543  33.146  14.049  1.00  0.00           C  
ATOM     92  C   HIS A   9      21.715  33.007  12.539  1.00  0.00           C  
ATOM     93  O   HIS A   9      20.764  32.693  11.822  1.00  0.00           O  
ATOM     94  CB  HIS A   9      22.489  32.186  14.772  1.00  0.00           C  
ATOM     95  CG  HIS A   9      22.022  31.806  16.144  1.00  0.00           C  
ATOM     96  ND1 HIS A   9      22.754  32.061  17.285  1.00  0.00           N  
ATOM     97  CD2 HIS A   9      20.890  31.188  16.554  1.00  0.00           C  
ATOM     98  CE1 HIS A   9      22.092  31.615  18.337  1.00  0.00           C  
ATOM     99  NE2 HIS A   9      20.958  31.081  17.921  1.00  0.00           N  
ATOM    100  H   HIS A   9      19.745  32.036  14.189  1.00  0.00           H  
ATOM    101  HA  HIS A   9      21.784  34.159  14.334  1.00  0.00           H  
ATOM    102  HB2 HIS A   9      22.584  31.280  14.192  1.00  0.00           H  
ATOM    103  HB3 HIS A   9      23.459  32.652  14.868  1.00  0.00           H  
ATOM    104  HD1 HIS A   9      23.628  32.502  17.317  1.00  0.00           H  
ATOM    105  HD2 HIS A   9      20.082  30.843  15.923  1.00  0.00           H  
ATOM    106  HE1 HIS A   9      22.422  31.676  19.364  1.00  0.00           H  
ATOM    107  HE2 HIS A   9      20.320  30.600  18.488  1.00  0.00           H  
ATOM    108  N   VAL A  10      22.933  33.244  12.063  1.00  0.00           N  
ATOM    109  CA  VAL A  10      23.230  33.144  10.638  1.00  0.00           C  
ATOM    110  C   VAL A  10      24.304  32.096  10.373  1.00  0.00           C  
ATOM    111  O   VAL A  10      25.341  32.073  11.035  1.00  0.00           O  
ATOM    112  CB  VAL A  10      23.695  34.497  10.067  1.00  0.00           C  
ATOM    113  CG1 VAL A  10      25.058  34.873  10.627  1.00  0.00           C  
ATOM    114  CG2 VAL A  10      23.728  34.449   8.546  1.00  0.00           C  
ATOM    115  H   VAL A  10      23.650  33.491  12.684  1.00  0.00           H  
ATOM    116  HA  VAL A  10      22.323  32.854  10.128  1.00  0.00           H  
ATOM    117  HB  VAL A  10      22.986  35.255  10.367  1.00  0.00           H  
ATOM    118 HG11 VAL A  10      25.828  34.339  10.087  1.00  0.00           H  
ATOM    119 HG12 VAL A  10      25.212  35.937  10.517  1.00  0.00           H  
ATOM    120 HG13 VAL A  10      25.103  34.608  11.672  1.00  0.00           H  
ATOM    121 HG21 VAL A  10      24.652  34.882   8.194  1.00  0.00           H  
ATOM    122 HG22 VAL A  10      23.662  33.422   8.217  1.00  0.00           H  
ATOM    123 HG23 VAL A  10      22.894  35.008   8.150  1.00  0.00           H  
ATOM    124  N   ALA A  11      24.049  31.230   9.398  1.00  0.00           N  
ATOM    125  CA  ALA A  11      24.995  30.178   9.043  1.00  0.00           C  
ATOM    126  C   ALA A  11      25.515  30.367   7.622  1.00  0.00           C  
ATOM    127  O   ALA A  11      24.742  30.366   6.662  1.00  0.00           O  
ATOM    128  CB  ALA A  11      24.347  28.810   9.193  1.00  0.00           C  
ATOM    129  H   ALA A  11      23.205  31.298   8.906  1.00  0.00           H  
ATOM    130  HA  ALA A  11      25.828  30.233   9.730  1.00  0.00           H  
ATOM    131  HB1 ALA A  11      23.428  28.908   9.753  1.00  0.00           H  
ATOM    132  HB2 ALA A  11      24.131  28.405   8.216  1.00  0.00           H  
ATOM    133  HB3 ALA A  11      25.020  28.149   9.718  1.00  0.00           H  
ATOM    134  N   CYS A  12      26.828  30.529   7.493  1.00  0.00           N  
ATOM    135  CA  CYS A  12      27.450  30.720   6.188  1.00  0.00           C  
ATOM    136  C   CYS A  12      28.435  29.594   5.886  1.00  0.00           C  
ATOM    137  O   CYS A  12      29.328  29.307   6.683  1.00  0.00           O  
ATOM    138  CB  CYS A  12      28.167  32.069   6.135  1.00  0.00           C  
ATOM    139  SG  CYS A  12      29.400  32.303   7.436  1.00  0.00           S  
ATOM    140  H   CYS A  12      27.391  30.521   8.295  1.00  0.00           H  
ATOM    141  HA  CYS A  12      26.668  30.707   5.444  1.00  0.00           H  
ATOM    142  HB2 CYS A  12      28.672  32.163   5.184  1.00  0.00           H  
ATOM    143  HB3 CYS A  12      27.437  32.860   6.225  1.00  0.00           H  
ATOM    144  HG  CYS A  12      30.595  32.077   6.911  1.00  0.00           H  
ATOM    145  N   LEU A  13      28.265  28.960   4.731  1.00  0.00           N  
ATOM    146  CA  LEU A  13      29.137  27.866   4.324  1.00  0.00           C  
ATOM    147  C   LEU A  13      29.477  27.963   2.840  1.00  0.00           C  
ATOM    148  O   LEU A  13      28.806  28.665   2.084  1.00  0.00           O  
ATOM    149  CB  LEU A  13      28.473  26.520   4.619  1.00  0.00           C  
ATOM    150  CG  LEU A  13      27.744  26.412   5.960  1.00  0.00           C  
ATOM    151  CD1 LEU A  13      26.693  25.314   5.910  1.00  0.00           C  
ATOM    152  CD2 LEU A  13      28.734  26.152   7.086  1.00  0.00           C  
ATOM    153  H   LEU A  13      27.535  29.236   4.138  1.00  0.00           H  
ATOM    154  HA  LEU A  13      30.050  27.939   4.894  1.00  0.00           H  
ATOM    155  HB2 LEU A  13      27.755  26.326   3.838  1.00  0.00           H  
ATOM    156  HB3 LEU A  13      29.241  25.761   4.597  1.00  0.00           H  
ATOM    157  HG  LEU A  13      27.241  27.347   6.166  1.00  0.00           H  
ATOM    158 HD11 LEU A  13      27.127  24.383   6.240  1.00  0.00           H  
ATOM    159 HD12 LEU A  13      26.336  25.205   4.896  1.00  0.00           H  
ATOM    160 HD13 LEU A  13      25.867  25.576   6.554  1.00  0.00           H  
ATOM    161 HD21 LEU A  13      28.950  25.096   7.138  1.00  0.00           H  
ATOM    162 HD22 LEU A  13      28.309  26.480   8.023  1.00  0.00           H  
ATOM    163 HD23 LEU A  13      29.648  26.697   6.895  1.00  0.00           H  
ATOM    164  N   ALA A  14      30.519  27.249   2.428  1.00  0.00           N  
ATOM    165  CA  ALA A  14      30.945  27.251   1.034  1.00  0.00           C  
ATOM    166  C   ALA A  14      30.347  26.071   0.275  1.00  0.00           C  
ATOM    167  O   ALA A  14      30.791  24.934   0.429  1.00  0.00           O  
ATOM    168  CB  ALA A  14      32.464  27.223   0.945  1.00  0.00           C  
ATOM    169  H   ALA A  14      31.014  26.708   3.078  1.00  0.00           H  
ATOM    170  HA  ALA A  14      30.599  28.170   0.581  1.00  0.00           H  
ATOM    171  HB1 ALA A  14      32.807  28.078   0.380  1.00  0.00           H  
ATOM    172  HB2 ALA A  14      32.882  27.257   1.940  1.00  0.00           H  
ATOM    173  HB3 ALA A  14      32.778  26.316   0.451  1.00  0.00           H  
ATOM    174  N   ARG A  15      29.335  26.350  -0.541  1.00  0.00           N  
ATOM    175  CA  ARG A  15      28.675  25.311  -1.321  1.00  0.00           C  
ATOM    176  C   ARG A  15      29.607  24.767  -2.401  1.00  0.00           C  
ATOM    177  O   ARG A  15      30.412  25.504  -2.969  1.00  0.00           O  
ATOM    178  CB  ARG A  15      27.398  25.858  -1.962  1.00  0.00           C  
ATOM    179  CG  ARG A  15      26.887  25.014  -3.119  1.00  0.00           C  
ATOM    180  CD  ARG A  15      25.714  25.680  -3.819  1.00  0.00           C  
ATOM    181  NE  ARG A  15      25.190  24.862  -4.908  1.00  0.00           N  
ATOM    182  CZ  ARG A  15      25.846  24.640  -6.042  1.00  0.00           C  
ATOM    183  NH1 ARG A  15      27.045  25.173  -6.233  1.00  0.00           N  
ATOM    184  NH2 ARG A  15      25.303  23.884  -6.988  1.00  0.00           N  
ATOM    185  H   ARG A  15      29.025  27.277  -0.620  1.00  0.00           H  
ATOM    186  HA  ARG A  15      28.413  24.507  -0.649  1.00  0.00           H  
ATOM    187  HB2 ARG A  15      26.624  25.907  -1.211  1.00  0.00           H  
ATOM    188  HB3 ARG A  15      27.594  26.853  -2.332  1.00  0.00           H  
ATOM    189  HG2 ARG A  15      27.686  24.875  -3.832  1.00  0.00           H  
ATOM    190  HG3 ARG A  15      26.570  24.054  -2.738  1.00  0.00           H  
ATOM    191  HD2 ARG A  15      24.928  25.848  -3.097  1.00  0.00           H  
ATOM    192  HD3 ARG A  15      26.042  26.629  -4.218  1.00  0.00           H  
ATOM    193  HE  ARG A  15      24.306  24.458  -4.789  1.00  0.00           H  
ATOM    194 HH11 ARG A  15      27.457  25.742  -5.523  1.00  0.00           H  
ATOM    195 HH12 ARG A  15      27.538  25.003  -7.087  1.00  0.00           H  
ATOM    196 HH21 ARG A  15      24.399  23.480  -6.847  1.00  0.00           H  
ATOM    197 HH22 ARG A  15      25.797  23.717  -7.841  1.00  0.00           H  
ATOM    198  N   SER A  16      29.490  23.473  -2.679  1.00  0.00           N  
ATOM    199  CA  SER A  16      30.324  22.829  -3.687  1.00  0.00           C  
ATOM    200  C   SER A  16      29.505  21.856  -4.529  1.00  0.00           C  
ATOM    201  O   SER A  16      28.564  21.233  -4.037  1.00  0.00           O  
ATOM    202  CB  SER A  16      31.487  22.091  -3.021  1.00  0.00           C  
ATOM    203  OG  SER A  16      32.610  22.025  -3.883  1.00  0.00           O  
ATOM    204  H   SER A  16      28.829  22.937  -2.192  1.00  0.00           H  
ATOM    205  HA  SER A  16      30.719  23.600  -4.331  1.00  0.00           H  
ATOM    206  HB2 SER A  16      31.772  22.611  -2.119  1.00  0.00           H  
ATOM    207  HB3 SER A  16      31.178  21.086  -2.774  1.00  0.00           H  
ATOM    208  HG  SER A  16      33.024  22.889  -3.937  1.00  0.00           H  
ATOM    209  N   GLU A  17      29.871  21.730  -5.801  1.00  0.00           N  
ATOM    210  CA  GLU A  17      29.169  20.834  -6.712  1.00  0.00           C  
ATOM    211  C   GLU A  17      29.104  19.420  -6.141  1.00  0.00           C  
ATOM    212  O   GLU A  17      28.214  18.641  -6.484  1.00  0.00           O  
ATOM    213  CB  GLU A  17      29.862  20.813  -8.076  1.00  0.00           C  
ATOM    214  CG  GLU A  17      31.364  20.603  -7.993  1.00  0.00           C  
ATOM    215  CD  GLU A  17      31.752  19.139  -8.062  1.00  0.00           C  
ATOM    216  OE1 GLU A  17      30.853  18.281  -7.942  1.00  0.00           O  
ATOM    217  OE2 GLU A  17      32.956  18.851  -8.236  1.00  0.00           O  
ATOM    218  H   GLU A  17      30.630  22.253  -6.134  1.00  0.00           H  
ATOM    219  HA  GLU A  17      28.163  21.206  -6.834  1.00  0.00           H  
ATOM    220  HB2 GLU A  17      29.439  20.015  -8.669  1.00  0.00           H  
ATOM    221  HB3 GLU A  17      29.678  21.755  -8.573  1.00  0.00           H  
ATOM    222  HG2 GLU A  17      31.834  21.123  -8.815  1.00  0.00           H  
ATOM    223  HG3 GLU A  17      31.721  21.011  -7.059  1.00  0.00           H  
ATOM    224  N   ARG A  18      30.054  19.096  -5.270  1.00  0.00           N  
ATOM    225  CA  ARG A  18      30.106  17.775  -4.652  1.00  0.00           C  
ATOM    226  C   ARG A  18      28.988  17.610  -3.627  1.00  0.00           C  
ATOM    227  O   ARG A  18      28.550  16.495  -3.347  1.00  0.00           O  
ATOM    228  CB  ARG A  18      31.464  17.556  -3.982  1.00  0.00           C  
ATOM    229  CG  ARG A  18      32.571  17.188  -4.956  1.00  0.00           C  
ATOM    230  CD  ARG A  18      33.689  16.422  -4.265  1.00  0.00           C  
ATOM    231  NE  ARG A  18      34.788  16.116  -5.177  1.00  0.00           N  
ATOM    232  CZ  ARG A  18      35.678  17.015  -5.582  1.00  0.00           C  
ATOM    233  NH1 ARG A  18      35.598  18.269  -5.158  1.00  0.00           N  
ATOM    234  NH2 ARG A  18      36.650  16.660  -6.413  1.00  0.00           N  
ATOM    235  H   ARG A  18      30.736  19.759  -5.037  1.00  0.00           H  
ATOM    236  HA  ARG A  18      29.976  17.040  -5.432  1.00  0.00           H  
ATOM    237  HB2 ARG A  18      31.751  18.463  -3.471  1.00  0.00           H  
ATOM    238  HB3 ARG A  18      31.370  16.759  -3.259  1.00  0.00           H  
ATOM    239  HG2 ARG A  18      32.158  16.571  -5.740  1.00  0.00           H  
ATOM    240  HG3 ARG A  18      32.977  18.092  -5.384  1.00  0.00           H  
ATOM    241  HD2 ARG A  18      34.066  17.020  -3.449  1.00  0.00           H  
ATOM    242  HD3 ARG A  18      33.286  15.498  -3.878  1.00  0.00           H  
ATOM    243  HE  ARG A  18      34.865  15.196  -5.502  1.00  0.00           H  
ATOM    244 HH11 ARG A  18      34.868  18.539  -4.532  1.00  0.00           H  
ATOM    245 HH12 ARG A  18      36.272  18.944  -5.464  1.00  0.00           H  
ATOM    246 HH21 ARG A  18      36.712  15.716  -6.734  1.00  0.00           H  
ATOM    247 HH22 ARG A  18      37.319  17.338  -6.718  1.00  0.00           H  
ATOM    248  N   GLY A  19      28.531  18.728  -3.072  1.00  0.00           N  
ATOM    249  CA  GLY A  19      27.469  18.685  -2.083  1.00  0.00           C  
ATOM    250  C   GLY A  19      27.833  19.418  -0.808  1.00  0.00           C  
ATOM    251  O   GLY A  19      28.705  18.978  -0.058  1.00  0.00           O  
ATOM    252  H   GLY A  19      28.919  19.589  -3.334  1.00  0.00           H  
ATOM    253  HA2 GLY A  19      26.582  19.136  -2.504  1.00  0.00           H  
ATOM    254  HA3 GLY A  19      27.257  17.654  -1.844  1.00  0.00           H  
ATOM    255  N   LEU A  20      27.167  20.541  -0.562  1.00  0.00           N  
ATOM    256  CA  LEU A  20      27.426  21.339   0.631  1.00  0.00           C  
ATOM    257  C   LEU A  20      27.785  20.447   1.816  1.00  0.00           C  
ATOM    258  O   LEU A  20      28.928  20.428   2.269  1.00  0.00           O  
ATOM    259  CB  LEU A  20      26.205  22.194   0.974  1.00  0.00           C  
ATOM    260  CG  LEU A  20      26.160  23.585   0.341  1.00  0.00           C  
ATOM    261  CD1 LEU A  20      24.722  24.020   0.108  1.00  0.00           C  
ATOM    262  CD2 LEU A  20      26.890  24.593   1.218  1.00  0.00           C  
ATOM    263  H   LEU A  20      26.484  20.841  -1.196  1.00  0.00           H  
ATOM    264  HA  LEU A  20      28.263  21.989   0.420  1.00  0.00           H  
ATOM    265  HB2 LEU A  20      25.325  21.657   0.652  1.00  0.00           H  
ATOM    266  HB3 LEU A  20      26.177  22.316   2.047  1.00  0.00           H  
ATOM    267  HG  LEU A  20      26.659  23.553  -0.619  1.00  0.00           H  
ATOM    268 HD11 LEU A  20      24.379  24.595   0.955  1.00  0.00           H  
ATOM    269 HD12 LEU A  20      24.097  23.148  -0.012  1.00  0.00           H  
ATOM    270 HD13 LEU A  20      24.670  24.625  -0.785  1.00  0.00           H  
ATOM    271 HD21 LEU A  20      26.453  24.592   2.206  1.00  0.00           H  
ATOM    272 HD22 LEU A  20      26.798  25.579   0.785  1.00  0.00           H  
ATOM    273 HD23 LEU A  20      27.933  24.324   1.284  1.00  0.00           H  
ATOM    274  N   GLY A  21      26.798  19.705   2.312  1.00  0.00           N  
ATOM    275  CA  GLY A  21      27.030  18.820   3.437  1.00  0.00           C  
ATOM    276  C   GLY A  21      25.758  18.505   4.199  1.00  0.00           C  
ATOM    277  O   GLY A  21      25.481  17.347   4.509  1.00  0.00           O  
ATOM    278  H   GLY A  21      25.906  19.761   1.910  1.00  0.00           H  
ATOM    279  HA2 GLY A  21      27.456  17.897   3.074  1.00  0.00           H  
ATOM    280  HA3 GLY A  21      27.732  19.288   4.111  1.00  0.00           H  
ATOM    281  N   PHE A  22      24.982  19.540   4.504  1.00  0.00           N  
ATOM    282  CA  PHE A  22      23.733  19.369   5.237  1.00  0.00           C  
ATOM    283  C   PHE A  22      22.547  19.282   4.280  1.00  0.00           C  
ATOM    284  O   PHE A  22      22.606  19.780   3.156  1.00  0.00           O  
ATOM    285  CB  PHE A  22      23.529  20.528   6.215  1.00  0.00           C  
ATOM    286  CG  PHE A  22      22.813  21.703   5.612  1.00  0.00           C  
ATOM    287  CD1 PHE A  22      23.517  22.686   4.934  1.00  0.00           C  
ATOM    288  CD2 PHE A  22      21.437  21.824   5.722  1.00  0.00           C  
ATOM    289  CE1 PHE A  22      22.861  23.768   4.378  1.00  0.00           C  
ATOM    290  CE2 PHE A  22      20.777  22.904   5.166  1.00  0.00           C  
ATOM    291  CZ  PHE A  22      21.490  23.878   4.495  1.00  0.00           C  
ATOM    292  H   PHE A  22      25.256  20.441   4.230  1.00  0.00           H  
ATOM    293  HA  PHE A  22      23.800  18.448   5.794  1.00  0.00           H  
ATOM    294  HB2 PHE A  22      22.945  20.182   7.056  1.00  0.00           H  
ATOM    295  HB3 PHE A  22      24.491  20.869   6.565  1.00  0.00           H  
ATOM    296  HD1 PHE A  22      24.591  22.602   4.843  1.00  0.00           H  
ATOM    297  HD2 PHE A  22      20.879  21.065   6.248  1.00  0.00           H  
ATOM    298  HE1 PHE A  22      23.423  24.528   3.853  1.00  0.00           H  
ATOM    299  HE2 PHE A  22      19.705  22.988   5.260  1.00  0.00           H  
ATOM    300  HZ  PHE A  22      20.976  24.722   4.059  1.00  0.00           H  
ATOM    301  N   SER A  23      21.473  18.644   4.734  1.00  0.00           N  
ATOM    302  CA  SER A  23      20.276  18.487   3.918  1.00  0.00           C  
ATOM    303  C   SER A  23      19.083  19.185   4.563  1.00  0.00           C  
ATOM    304  O   SER A  23      19.177  19.694   5.681  1.00  0.00           O  
ATOM    305  CB  SER A  23      19.964  17.004   3.714  1.00  0.00           C  
ATOM    306  OG  SER A  23      20.621  16.498   2.563  1.00  0.00           O  
ATOM    307  H   SER A  23      21.489  18.269   5.640  1.00  0.00           H  
ATOM    308  HA  SER A  23      20.468  18.941   2.957  1.00  0.00           H  
ATOM    309  HB2 SER A  23      20.295  16.446   4.577  1.00  0.00           H  
ATOM    310  HB3 SER A  23      18.898  16.877   3.589  1.00  0.00           H  
ATOM    311  HG  SER A  23      20.020  16.520   1.815  1.00  0.00           H  
ATOM    312  N   ILE A  24      17.960  19.204   3.852  1.00  0.00           N  
ATOM    313  CA  ILE A  24      16.748  19.839   4.355  1.00  0.00           C  
ATOM    314  C   ILE A  24      15.561  18.884   4.289  1.00  0.00           C  
ATOM    315  O   ILE A  24      15.528  17.974   3.462  1.00  0.00           O  
ATOM    316  CB  ILE A  24      16.411  21.116   3.564  1.00  0.00           C  
ATOM    317  CG1 ILE A  24      15.967  20.760   2.143  1.00  0.00           C  
ATOM    318  CG2 ILE A  24      17.611  22.051   3.531  1.00  0.00           C  
ATOM    319  CD1 ILE A  24      15.237  21.882   1.440  1.00  0.00           C  
ATOM    320  H   ILE A  24      17.947  18.782   2.969  1.00  0.00           H  
ATOM    321  HA  ILE A  24      16.919  20.112   5.387  1.00  0.00           H  
ATOM    322  HB  ILE A  24      15.603  21.623   4.069  1.00  0.00           H  
ATOM    323 HG12 ILE A  24      16.835  20.508   1.555  1.00  0.00           H  
ATOM    324 HG13 ILE A  24      15.305  19.907   2.185  1.00  0.00           H  
ATOM    325 HG21 ILE A  24      17.704  22.482   2.545  1.00  0.00           H  
ATOM    326 HG22 ILE A  24      17.471  22.839   4.256  1.00  0.00           H  
ATOM    327 HG23 ILE A  24      18.506  21.496   3.769  1.00  0.00           H  
ATOM    328 HD11 ILE A  24      14.729  21.492   0.570  1.00  0.00           H  
ATOM    329 HD12 ILE A  24      14.516  22.321   2.113  1.00  0.00           H  
ATOM    330 HD13 ILE A  24      15.948  22.636   1.133  1.00  0.00           H  
ATOM    331  N   ALA A  25      14.586  19.100   5.165  1.00  0.00           N  
ATOM    332  CA  ALA A  25      13.394  18.262   5.204  1.00  0.00           C  
ATOM    333  C   ALA A  25      12.187  19.046   5.709  1.00  0.00           C  
ATOM    334  O   ALA A  25      12.329  19.999   6.473  1.00  0.00           O  
ATOM    335  CB  ALA A  25      13.635  17.041   6.079  1.00  0.00           C  
ATOM    336  H   ALA A  25      14.669  19.841   5.800  1.00  0.00           H  
ATOM    337  HA  ALA A  25      13.193  17.920   4.198  1.00  0.00           H  
ATOM    338  HB1 ALA A  25      12.688  16.580   6.321  1.00  0.00           H  
ATOM    339  HB2 ALA A  25      14.254  16.334   5.547  1.00  0.00           H  
ATOM    340  HB3 ALA A  25      14.132  17.343   6.988  1.00  0.00           H  
ATOM    341  N   GLY A  26      10.998  18.639   5.274  1.00  0.00           N  
ATOM    342  CA  GLY A  26       9.784  19.315   5.692  1.00  0.00           C  
ATOM    343  C   GLY A  26       9.051  19.959   4.532  1.00  0.00           C  
ATOM    344  O   GLY A  26       7.821  19.984   4.502  1.00  0.00           O  
ATOM    345  H   GLY A  26      10.945  17.873   4.665  1.00  0.00           H  
ATOM    346  HA2 GLY A  26       9.129  18.598   6.164  1.00  0.00           H  
ATOM    347  HA3 GLY A  26      10.041  20.080   6.410  1.00  0.00           H  
ATOM    348  N   GLY A  27       9.808  20.485   3.573  1.00  0.00           N  
ATOM    349  CA  GLY A  27       9.206  21.127   2.420  1.00  0.00           C  
ATOM    350  C   GLY A  27       7.911  20.462   1.996  1.00  0.00           C  
ATOM    351  O   GLY A  27       7.722  19.264   2.206  1.00  0.00           O  
ATOM    352  H   GLY A  27      10.785  20.436   3.650  1.00  0.00           H  
ATOM    353  HA2 GLY A  27       9.006  22.161   2.661  1.00  0.00           H  
ATOM    354  HA3 GLY A  27       9.902  21.089   1.596  1.00  0.00           H  
ATOM    355  N   LYS A  28       7.015  21.242   1.401  1.00  0.00           N  
ATOM    356  CA  LYS A  28       5.730  20.722   0.948  1.00  0.00           C  
ATOM    357  C   LYS A  28       5.922  19.515   0.036  1.00  0.00           C  
ATOM    358  O   LYS A  28       5.148  18.560   0.084  1.00  0.00           O  
ATOM    359  CB  LYS A  28       4.948  21.812   0.210  1.00  0.00           C  
ATOM    360  CG  LYS A  28       4.282  22.815   1.135  1.00  0.00           C  
ATOM    361  CD  LYS A  28       3.129  23.528   0.449  1.00  0.00           C  
ATOM    362  CE  LYS A  28       2.541  24.617   1.333  1.00  0.00           C  
ATOM    363  NZ  LYS A  28       1.800  25.636   0.538  1.00  0.00           N  
ATOM    364  H   LYS A  28       7.223  22.190   1.263  1.00  0.00           H  
ATOM    365  HA  LYS A  28       5.170  20.416   1.818  1.00  0.00           H  
ATOM    366  HB2 LYS A  28       5.626  22.347  -0.440  1.00  0.00           H  
ATOM    367  HB3 LYS A  28       4.181  21.343  -0.391  1.00  0.00           H  
ATOM    368  HG2 LYS A  28       3.904  22.295   2.003  1.00  0.00           H  
ATOM    369  HG3 LYS A  28       5.013  23.549   1.443  1.00  0.00           H  
ATOM    370  HD2 LYS A  28       3.487  23.977  -0.466  1.00  0.00           H  
ATOM    371  HD3 LYS A  28       2.357  22.806   0.219  1.00  0.00           H  
ATOM    372  HE2 LYS A  28       1.863  24.162   2.039  1.00  0.00           H  
ATOM    373  HE3 LYS A  28       3.345  25.103   1.866  1.00  0.00           H  
ATOM    374  HZ1 LYS A  28       0.860  25.274   0.281  1.00  0.00           H  
ATOM    375  HZ2 LYS A  28       2.324  25.860  -0.332  1.00  0.00           H  
ATOM    376  HZ3 LYS A  28       1.685  26.508   1.094  1.00  0.00           H  
ATOM    377  N   GLY A  29       6.961  19.564  -0.793  1.00  0.00           N  
ATOM    378  CA  GLY A  29       7.236  18.467  -1.703  1.00  0.00           C  
ATOM    379  C   GLY A  29       8.130  17.411  -1.083  1.00  0.00           C  
ATOM    380  O   GLY A  29       8.849  16.705  -1.789  1.00  0.00           O  
ATOM    381  H   GLY A  29       7.544  20.352  -0.788  1.00  0.00           H  
ATOM    382  HA2 GLY A  29       6.303  18.008  -1.990  1.00  0.00           H  
ATOM    383  HA3 GLY A  29       7.721  18.858  -2.585  1.00  0.00           H  
ATOM    384  N   SER A  30       8.088  17.304   0.241  1.00  0.00           N  
ATOM    385  CA  SER A  30       8.905  16.331   0.957  1.00  0.00           C  
ATOM    386  C   SER A  30       8.188  15.837   2.210  1.00  0.00           C  
ATOM    387  O   SER A  30       7.039  16.198   2.467  1.00  0.00           O  
ATOM    388  CB  SER A  30      10.253  16.945   1.334  1.00  0.00           C  
ATOM    389  OG  SER A  30      11.201  15.940   1.648  1.00  0.00           O  
ATOM    390  H   SER A  30       7.493  17.896   0.749  1.00  0.00           H  
ATOM    391  HA  SER A  30       9.072  15.491   0.298  1.00  0.00           H  
ATOM    392  HB2 SER A  30      10.626  17.527   0.506  1.00  0.00           H  
ATOM    393  HB3 SER A  30      10.126  17.584   2.196  1.00  0.00           H  
ATOM    394  HG  SER A  30      11.093  15.199   1.047  1.00  0.00           H  
ATOM    395  N   THR A  31       8.876  15.008   2.989  1.00  0.00           N  
ATOM    396  CA  THR A  31       8.307  14.462   4.216  1.00  0.00           C  
ATOM    397  C   THR A  31       8.311  15.501   5.332  1.00  0.00           C  
ATOM    398  O   THR A  31       9.268  16.255   5.509  1.00  0.00           O  
ATOM    399  CB  THR A  31       9.078  13.216   4.686  1.00  0.00           C  
ATOM    400  OG1 THR A  31       8.983  12.180   3.702  1.00  0.00           O  
ATOM    401  CG2 THR A  31       8.534  12.711   6.015  1.00  0.00           C  
ATOM    402  H   THR A  31       9.787  14.757   2.731  1.00  0.00           H  
ATOM    403  HA  THR A  31       7.287  14.173   4.010  1.00  0.00           H  
ATOM    404  HB  THR A  31      10.118  13.482   4.819  1.00  0.00           H  
ATOM    405  HG1 THR A  31       9.152  11.329   4.115  1.00  0.00           H  
ATOM    406 HG21 THR A  31       7.654  12.111   5.838  1.00  0.00           H  
ATOM    407 HG22 THR A  31       8.275  13.553   6.640  1.00  0.00           H  
ATOM    408 HG23 THR A  31       9.285  12.114   6.507  1.00  0.00           H  
ATOM    409  N   PRO A  32       7.218  15.542   6.107  1.00  0.00           N  
ATOM    410  CA  PRO A  32       7.072  16.483   7.221  1.00  0.00           C  
ATOM    411  C   PRO A  32       8.001  16.154   8.384  1.00  0.00           C  
ATOM    412  O   PRO A  32       7.630  15.418   9.299  1.00  0.00           O  
ATOM    413  CB  PRO A  32       5.610  16.312   7.641  1.00  0.00           C  
ATOM    414  CG  PRO A  32       5.250  14.932   7.209  1.00  0.00           C  
ATOM    415  CD  PRO A  32       6.038  14.673   5.954  1.00  0.00           C  
ATOM    416  HA  PRO A  32       7.240  17.502   6.905  1.00  0.00           H  
ATOM    417  HB2 PRO A  32       5.525  16.426   8.712  1.00  0.00           H  
ATOM    418  HB3 PRO A  32       5.000  17.052   7.145  1.00  0.00           H  
ATOM    419  HG2 PRO A  32       5.523  14.224   7.976  1.00  0.00           H  
ATOM    420  HG3 PRO A  32       4.191  14.876   7.003  1.00  0.00           H  
ATOM    421  HD2 PRO A  32       6.330  13.634   5.899  1.00  0.00           H  
ATOM    422  HD3 PRO A  32       5.465  14.953   5.083  1.00  0.00           H  
ATOM    423  N   TYR A  33       9.210  16.701   8.341  1.00  0.00           N  
ATOM    424  CA  TYR A  33      10.195  16.463   9.390  1.00  0.00           C  
ATOM    425  C   TYR A  33       9.526  16.401  10.760  1.00  0.00           C  
ATOM    426  O   TYR A  33       9.985  15.691  11.656  1.00  0.00           O  
ATOM    427  CB  TYR A  33      11.258  17.562   9.380  1.00  0.00           C  
ATOM    428  CG  TYR A  33      12.493  17.219  10.183  1.00  0.00           C  
ATOM    429  CD1 TYR A  33      13.428  16.312   9.700  1.00  0.00           C  
ATOM    430  CD2 TYR A  33      12.722  17.800  11.424  1.00  0.00           C  
ATOM    431  CE1 TYR A  33      14.558  15.994  10.431  1.00  0.00           C  
ATOM    432  CE2 TYR A  33      13.849  17.489  12.160  1.00  0.00           C  
ATOM    433  CZ  TYR A  33      14.764  16.585  11.660  1.00  0.00           C  
ATOM    434  OH  TYR A  33      15.886  16.272  12.391  1.00  0.00           O  
ATOM    435  H   TYR A  33       9.449  17.279   7.586  1.00  0.00           H  
ATOM    436  HA  TYR A  33      10.670  15.514   9.191  1.00  0.00           H  
ATOM    437  HB2 TYR A  33      11.566  17.746   8.362  1.00  0.00           H  
ATOM    438  HB3 TYR A  33      10.835  18.466   9.792  1.00  0.00           H  
ATOM    439  HD1 TYR A  33      13.264  15.850   8.738  1.00  0.00           H  
ATOM    440  HD2 TYR A  33      12.004  18.506  11.813  1.00  0.00           H  
ATOM    441  HE1 TYR A  33      15.274  15.287  10.039  1.00  0.00           H  
ATOM    442  HE2 TYR A  33      14.011  17.951  13.123  1.00  0.00           H  
ATOM    443  HH  TYR A  33      15.812  15.374  12.722  1.00  0.00           H  
ATOM    444  N   ARG A  34       8.437  17.147  10.915  1.00  0.00           N  
ATOM    445  CA  ARG A  34       7.704  17.177  12.175  1.00  0.00           C  
ATOM    446  C   ARG A  34       6.200  17.134  11.929  1.00  0.00           C  
ATOM    447  O   ARG A  34       5.632  18.042  11.323  1.00  0.00           O  
ATOM    448  CB  ARG A  34       8.066  18.433  12.969  1.00  0.00           C  
ATOM    449  CG  ARG A  34       9.545  18.540  13.301  1.00  0.00           C  
ATOM    450  CD  ARG A  34       9.780  19.409  14.527  1.00  0.00           C  
ATOM    451  NE  ARG A  34      11.069  19.133  15.156  1.00  0.00           N  
ATOM    452  CZ  ARG A  34      11.274  18.128  16.000  1.00  0.00           C  
ATOM    453  NH1 ARG A  34      10.281  17.308  16.314  1.00  0.00           N  
ATOM    454  NH2 ARG A  34      12.476  17.941  16.531  1.00  0.00           N  
ATOM    455  H   ARG A  34       8.120  17.691  10.164  1.00  0.00           H  
ATOM    456  HA  ARG A  34       7.990  16.307  12.746  1.00  0.00           H  
ATOM    457  HB2 ARG A  34       7.786  19.303  12.393  1.00  0.00           H  
ATOM    458  HB3 ARG A  34       7.510  18.431  13.895  1.00  0.00           H  
ATOM    459  HG2 ARG A  34       9.933  17.550  13.497  1.00  0.00           H  
ATOM    460  HG3 ARG A  34      10.064  18.972  12.459  1.00  0.00           H  
ATOM    461  HD2 ARG A  34       9.752  20.446  14.227  1.00  0.00           H  
ATOM    462  HD3 ARG A  34       8.993  19.219  15.241  1.00  0.00           H  
ATOM    463  HE  ARG A  34      11.817  19.726  14.937  1.00  0.00           H  
ATOM    464 HH11 ARG A  34       9.374  17.447  15.915  1.00  0.00           H  
ATOM    465 HH12 ARG A  34      10.438  16.551  16.950  1.00  0.00           H  
ATOM    466 HH21 ARG A  34      13.228  18.557  16.296  1.00  0.00           H  
ATOM    467 HH22 ARG A  34      12.629  17.185  17.166  1.00  0.00           H  
ATOM    468  N   ALA A  35       5.558  16.071  12.404  1.00  0.00           N  
ATOM    469  CA  ALA A  35       4.119  15.908  12.237  1.00  0.00           C  
ATOM    470  C   ALA A  35       3.375  17.184  12.619  1.00  0.00           C  
ATOM    471  O   ALA A  35       3.348  17.573  13.785  1.00  0.00           O  
ATOM    472  CB  ALA A  35       3.620  14.736  13.069  1.00  0.00           C  
ATOM    473  H   ALA A  35       6.065  15.380  12.879  1.00  0.00           H  
ATOM    474  HA  ALA A  35       3.926  15.688  11.197  1.00  0.00           H  
ATOM    475  HB1 ALA A  35       2.540  14.754  13.104  1.00  0.00           H  
ATOM    476  HB2 ALA A  35       3.950  13.811  12.621  1.00  0.00           H  
ATOM    477  HB3 ALA A  35       4.015  14.812  14.071  1.00  0.00           H  
ATOM    478  N   GLY A  36       2.774  17.832  11.625  1.00  0.00           N  
ATOM    479  CA  GLY A  36       2.039  19.058  11.878  1.00  0.00           C  
ATOM    480  C   GLY A  36       2.840  20.297  11.530  1.00  0.00           C  
ATOM    481  O   GLY A  36       2.400  21.419  11.778  1.00  0.00           O  
ATOM    482  H   GLY A  36       2.830  17.475  10.715  1.00  0.00           H  
ATOM    483  HA2 GLY A  36       1.135  19.050  11.288  1.00  0.00           H  
ATOM    484  HA3 GLY A  36       1.774  19.097  12.924  1.00  0.00           H  
ATOM    485  N   ASP A  37       4.021  20.093  10.957  1.00  0.00           N  
ATOM    486  CA  ASP A  37       4.887  21.203  10.575  1.00  0.00           C  
ATOM    487  C   ASP A  37       5.064  21.259   9.061  1.00  0.00           C  
ATOM    488  O   ASP A  37       5.491  20.286   8.440  1.00  0.00           O  
ATOM    489  CB  ASP A  37       6.251  21.071  11.255  1.00  0.00           C  
ATOM    490  CG  ASP A  37       6.141  21.013  12.766  1.00  0.00           C  
ATOM    491  OD1 ASP A  37       5.387  20.156  13.274  1.00  0.00           O  
ATOM    492  OD2 ASP A  37       6.808  21.825  13.442  1.00  0.00           O  
ATOM    493  H   ASP A  37       4.318  19.174  10.785  1.00  0.00           H  
ATOM    494  HA  ASP A  37       4.418  22.118  10.904  1.00  0.00           H  
ATOM    495  HB2 ASP A  37       6.730  20.166  10.913  1.00  0.00           H  
ATOM    496  HB3 ASP A  37       6.862  21.920  10.988  1.00  0.00           H  
ATOM    497  N   ALA A  38       4.730  22.404   8.473  1.00  0.00           N  
ATOM    498  CA  ALA A  38       4.852  22.587   7.033  1.00  0.00           C  
ATOM    499  C   ALA A  38       6.004  23.528   6.695  1.00  0.00           C  
ATOM    500  O   ALA A  38       5.911  24.329   5.766  1.00  0.00           O  
ATOM    501  CB  ALA A  38       3.548  23.116   6.455  1.00  0.00           C  
ATOM    502  H   ALA A  38       4.395  23.143   9.022  1.00  0.00           H  
ATOM    503  HA  ALA A  38       5.048  21.621   6.589  1.00  0.00           H  
ATOM    504  HB1 ALA A  38       3.296  22.558   5.566  1.00  0.00           H  
ATOM    505  HB2 ALA A  38       2.760  23.006   7.185  1.00  0.00           H  
ATOM    506  HB3 ALA A  38       3.663  24.160   6.204  1.00  0.00           H  
ATOM    507  N   GLY A  39       7.089  23.426   7.456  1.00  0.00           N  
ATOM    508  CA  GLY A  39       8.242  24.275   7.221  1.00  0.00           C  
ATOM    509  C   GLY A  39       9.430  23.504   6.680  1.00  0.00           C  
ATOM    510  O   GLY A  39       9.269  22.601   5.859  1.00  0.00           O  
ATOM    511  H   GLY A  39       7.106  22.769   8.183  1.00  0.00           H  
ATOM    512  HA2 GLY A  39       7.971  25.044   6.513  1.00  0.00           H  
ATOM    513  HA3 GLY A  39       8.526  24.742   8.153  1.00  0.00           H  
ATOM    514  N   ILE A  40      10.624  23.862   7.138  1.00  0.00           N  
ATOM    515  CA  ILE A  40      11.842  23.197   6.694  1.00  0.00           C  
ATOM    516  C   ILE A  40      12.886  23.160   7.805  1.00  0.00           C  
ATOM    517  O   ILE A  40      13.253  24.195   8.361  1.00  0.00           O  
ATOM    518  CB  ILE A  40      12.447  23.895   5.460  1.00  0.00           C  
ATOM    519  CG1 ILE A  40      11.456  23.868   4.295  1.00  0.00           C  
ATOM    520  CG2 ILE A  40      13.757  23.230   5.065  1.00  0.00           C  
ATOM    521  CD1 ILE A  40      11.861  24.752   3.137  1.00  0.00           C  
ATOM    522  H   ILE A  40      10.687  24.590   7.791  1.00  0.00           H  
ATOM    523  HA  ILE A  40      11.588  22.183   6.420  1.00  0.00           H  
ATOM    524  HB  ILE A  40      12.657  24.920   5.722  1.00  0.00           H  
ATOM    525 HG12 ILE A  40      11.370  22.858   3.926  1.00  0.00           H  
ATOM    526 HG13 ILE A  40      10.490  24.201   4.647  1.00  0.00           H  
ATOM    527 HG21 ILE A  40      14.059  22.540   5.839  1.00  0.00           H  
ATOM    528 HG22 ILE A  40      13.621  22.693   4.138  1.00  0.00           H  
ATOM    529 HG23 ILE A  40      14.519  23.984   4.937  1.00  0.00           H  
ATOM    530 HD11 ILE A  40      12.846  24.471   2.796  1.00  0.00           H  
ATOM    531 HD12 ILE A  40      11.153  24.637   2.330  1.00  0.00           H  
ATOM    532 HD13 ILE A  40      11.874  25.784   3.460  1.00  0.00           H  
ATOM    533  N   PHE A  41      13.362  21.961   8.123  1.00  0.00           N  
ATOM    534  CA  PHE A  41      14.364  21.789   9.168  1.00  0.00           C  
ATOM    535  C   PHE A  41      15.503  20.895   8.687  1.00  0.00           C  
ATOM    536  O   PHE A  41      15.327  20.077   7.783  1.00  0.00           O  
ATOM    537  CB  PHE A  41      13.726  21.188  10.423  1.00  0.00           C  
ATOM    538  CG  PHE A  41      12.350  21.721  10.709  1.00  0.00           C  
ATOM    539  CD1 PHE A  41      11.297  21.454   9.849  1.00  0.00           C  
ATOM    540  CD2 PHE A  41      12.112  22.489  11.837  1.00  0.00           C  
ATOM    541  CE1 PHE A  41      10.031  21.943  10.109  1.00  0.00           C  
ATOM    542  CE2 PHE A  41      10.847  22.980  12.102  1.00  0.00           C  
ATOM    543  CZ  PHE A  41       9.806  22.708  11.238  1.00  0.00           C  
ATOM    544  H   PHE A  41      13.031  21.172   7.644  1.00  0.00           H  
ATOM    545  HA  PHE A  41      14.763  22.762   9.407  1.00  0.00           H  
ATOM    546  HB2 PHE A  41      13.648  20.119  10.302  1.00  0.00           H  
ATOM    547  HB3 PHE A  41      14.351  21.407  11.275  1.00  0.00           H  
ATOM    548  HD1 PHE A  41      11.472  20.856   8.966  1.00  0.00           H  
ATOM    549  HD2 PHE A  41      12.925  22.704  12.514  1.00  0.00           H  
ATOM    550  HE1 PHE A  41       9.219  21.727   9.431  1.00  0.00           H  
ATOM    551  HE2 PHE A  41      10.674  23.579  12.985  1.00  0.00           H  
ATOM    552  HZ  PHE A  41       8.818  23.089  11.443  1.00  0.00           H  
ATOM    553  N   VAL A  42      16.674  21.057   9.296  1.00  0.00           N  
ATOM    554  CA  VAL A  42      17.843  20.266   8.932  1.00  0.00           C  
ATOM    555  C   VAL A  42      17.621  18.788   9.233  1.00  0.00           C  
ATOM    556  O   VAL A  42      17.326  18.413  10.367  1.00  0.00           O  
ATOM    557  CB  VAL A  42      19.101  20.748   9.677  1.00  0.00           C  
ATOM    558  CG1 VAL A  42      20.332  20.005   9.181  1.00  0.00           C  
ATOM    559  CG2 VAL A  42      19.273  22.251   9.514  1.00  0.00           C  
ATOM    560  H   VAL A  42      16.752  21.725  10.010  1.00  0.00           H  
ATOM    561  HA  VAL A  42      18.009  20.386   7.871  1.00  0.00           H  
ATOM    562  HB  VAL A  42      18.977  20.533  10.728  1.00  0.00           H  
ATOM    563 HG11 VAL A  42      20.809  20.580   8.400  1.00  0.00           H  
ATOM    564 HG12 VAL A  42      21.023  19.866   9.999  1.00  0.00           H  
ATOM    565 HG13 VAL A  42      20.038  19.043   8.789  1.00  0.00           H  
ATOM    566 HG21 VAL A  42      18.596  22.610   8.753  1.00  0.00           H  
ATOM    567 HG22 VAL A  42      19.054  22.742  10.452  1.00  0.00           H  
ATOM    568 HG23 VAL A  42      20.290  22.468   9.224  1.00  0.00           H  
ATOM    569  N   SER A  43      17.766  17.953   8.210  1.00  0.00           N  
ATOM    570  CA  SER A  43      17.580  16.515   8.364  1.00  0.00           C  
ATOM    571  C   SER A  43      18.920  15.811   8.558  1.00  0.00           C  
ATOM    572  O   SER A  43      19.003  14.787   9.237  1.00  0.00           O  
ATOM    573  CB  SER A  43      16.860  15.939   7.143  1.00  0.00           C  
ATOM    574  OG  SER A  43      17.537  16.277   5.946  1.00  0.00           O  
ATOM    575  H   SER A  43      18.003  18.313   7.329  1.00  0.00           H  
ATOM    576  HA  SER A  43      16.971  16.352   9.240  1.00  0.00           H  
ATOM    577  HB2 SER A  43      16.818  14.863   7.227  1.00  0.00           H  
ATOM    578  HB3 SER A  43      15.856  16.336   7.100  1.00  0.00           H  
ATOM    579  HG  SER A  43      18.192  15.604   5.746  1.00  0.00           H  
ATOM    580  N   ARG A  44      19.965  16.366   7.955  1.00  0.00           N  
ATOM    581  CA  ARG A  44      21.301  15.792   8.059  1.00  0.00           C  
ATOM    582  C   ARG A  44      22.369  16.881   7.987  1.00  0.00           C  
ATOM    583  O   ARG A  44      22.158  17.930   7.379  1.00  0.00           O  
ATOM    584  CB  ARG A  44      21.528  14.767   6.946  1.00  0.00           C  
ATOM    585  CG  ARG A  44      22.622  13.759   7.258  1.00  0.00           C  
ATOM    586  CD  ARG A  44      22.177  12.765   8.320  1.00  0.00           C  
ATOM    587  NE  ARG A  44      21.435  11.646   7.744  1.00  0.00           N  
ATOM    588  CZ  ARG A  44      21.219  10.501   8.383  1.00  0.00           C  
ATOM    589  NH1 ARG A  44      21.686  10.326   9.611  1.00  0.00           N  
ATOM    590  NH2 ARG A  44      20.535   9.530   7.792  1.00  0.00           N  
ATOM    591  H   ARG A  44      19.836  17.182   7.427  1.00  0.00           H  
ATOM    592  HA  ARG A  44      21.376  15.295   9.014  1.00  0.00           H  
ATOM    593  HB2 ARG A  44      20.608  14.226   6.778  1.00  0.00           H  
ATOM    594  HB3 ARG A  44      21.798  15.291   6.042  1.00  0.00           H  
ATOM    595  HG2 ARG A  44      22.870  13.219   6.357  1.00  0.00           H  
ATOM    596  HG3 ARG A  44      23.493  14.287   7.616  1.00  0.00           H  
ATOM    597  HD2 ARG A  44      23.051  12.383   8.825  1.00  0.00           H  
ATOM    598  HD3 ARG A  44      21.545  13.276   9.030  1.00  0.00           H  
ATOM    599  HE  ARG A  44      21.082  11.754   6.838  1.00  0.00           H  
ATOM    600 HH11 ARG A  44      22.200  11.057  10.059  1.00  0.00           H  
ATOM    601 HH12 ARG A  44      21.521   9.463  10.090  1.00  0.00           H  
ATOM    602 HH21 ARG A  44      20.182   9.659   6.867  1.00  0.00           H  
ATOM    603 HH22 ARG A  44      20.373   8.669   8.274  1.00  0.00           H  
ATOM    604  N   ILE A  45      23.512  16.623   8.613  1.00  0.00           N  
ATOM    605  CA  ILE A  45      24.612  17.580   8.619  1.00  0.00           C  
ATOM    606  C   ILE A  45      25.942  16.891   8.334  1.00  0.00           C  
ATOM    607  O   ILE A  45      26.205  15.797   8.832  1.00  0.00           O  
ATOM    608  CB  ILE A  45      24.708  18.318   9.967  1.00  0.00           C  
ATOM    609  CG1 ILE A  45      23.462  19.179  10.190  1.00  0.00           C  
ATOM    610  CG2 ILE A  45      25.964  19.174  10.013  1.00  0.00           C  
ATOM    611  CD1 ILE A  45      23.353  19.731  11.594  1.00  0.00           C  
ATOM    612  H   ILE A  45      23.620  15.769   9.080  1.00  0.00           H  
ATOM    613  HA  ILE A  45      24.422  18.309   7.844  1.00  0.00           H  
ATOM    614  HB  ILE A  45      24.773  17.582  10.752  1.00  0.00           H  
ATOM    615 HG12 ILE A  45      23.481  20.014   9.507  1.00  0.00           H  
ATOM    616 HG13 ILE A  45      22.582  18.583   9.999  1.00  0.00           H  
ATOM    617 HG21 ILE A  45      26.252  19.446   9.010  1.00  0.00           H  
ATOM    618 HG22 ILE A  45      25.770  20.068  10.586  1.00  0.00           H  
ATOM    619 HG23 ILE A  45      26.763  18.615  10.478  1.00  0.00           H  
ATOM    620 HD11 ILE A  45      24.207  20.361  11.802  1.00  0.00           H  
ATOM    621 HD12 ILE A  45      22.447  20.310  11.686  1.00  0.00           H  
ATOM    622 HD13 ILE A  45      23.331  18.914  12.301  1.00  0.00           H  
ATOM    623  N   ALA A  46      26.778  17.541   7.531  1.00  0.00           N  
ATOM    624  CA  ALA A  46      28.084  16.992   7.182  1.00  0.00           C  
ATOM    625  C   ALA A  46      29.056  17.109   8.350  1.00  0.00           C  
ATOM    626  O   ALA A  46      29.574  18.189   8.631  1.00  0.00           O  
ATOM    627  CB  ALA A  46      28.641  17.698   5.954  1.00  0.00           C  
ATOM    628  H   ALA A  46      26.511  18.409   7.164  1.00  0.00           H  
ATOM    629  HA  ALA A  46      27.952  15.947   6.938  1.00  0.00           H  
ATOM    630  HB1 ALA A  46      29.720  17.667   5.983  1.00  0.00           H  
ATOM    631  HB2 ALA A  46      28.289  17.200   5.063  1.00  0.00           H  
ATOM    632  HB3 ALA A  46      28.309  18.725   5.948  1.00  0.00           H  
ATOM    633  N   GLU A  47      29.300  15.991   9.025  1.00  0.00           N  
ATOM    634  CA  GLU A  47      30.211  15.969  10.164  1.00  0.00           C  
ATOM    635  C   GLU A  47      31.626  16.348   9.735  1.00  0.00           C  
ATOM    636  O   GLU A  47      31.999  16.187   8.574  1.00  0.00           O  
ATOM    637  CB  GLU A  47      30.216  14.585  10.815  1.00  0.00           C  
ATOM    638  CG  GLU A  47      30.764  14.581  12.233  1.00  0.00           C  
ATOM    639  CD  GLU A  47      30.446  13.299  12.978  1.00  0.00           C  
ATOM    640  OE1 GLU A  47      29.251  13.047  13.240  1.00  0.00           O  
ATOM    641  OE2 GLU A  47      31.391  12.550  13.298  1.00  0.00           O  
ATOM    642  H   GLU A  47      28.856  15.161   8.753  1.00  0.00           H  
ATOM    643  HA  GLU A  47      29.859  16.693  10.883  1.00  0.00           H  
ATOM    644  HB2 GLU A  47      29.205  14.208  10.841  1.00  0.00           H  
ATOM    645  HB3 GLU A  47      30.823  13.922  10.217  1.00  0.00           H  
ATOM    646  HG2 GLU A  47      31.836  14.698  12.191  1.00  0.00           H  
ATOM    647  HG3 GLU A  47      30.333  15.411  12.773  1.00  0.00           H  
ATOM    648  N   GLY A  48      32.409  16.854  10.683  1.00  0.00           N  
ATOM    649  CA  GLY A  48      33.774  17.248  10.386  1.00  0.00           C  
ATOM    650  C   GLY A  48      33.887  17.998   9.073  1.00  0.00           C  
ATOM    651  O   GLY A  48      34.941  17.996   8.438  1.00  0.00           O  
ATOM    652  H   GLY A  48      32.058  16.960  11.592  1.00  0.00           H  
ATOM    653  HA2 GLY A  48      34.136  17.881  11.182  1.00  0.00           H  
ATOM    654  HA3 GLY A  48      34.390  16.363  10.335  1.00  0.00           H  
ATOM    655  N   GLY A  49      32.796  18.639   8.663  1.00  0.00           N  
ATOM    656  CA  GLY A  49      32.799  19.384   7.417  1.00  0.00           C  
ATOM    657  C   GLY A  49      32.537  20.863   7.627  1.00  0.00           C  
ATOM    658  O   GLY A  49      33.109  21.480   8.525  1.00  0.00           O  
ATOM    659  H   GLY A  49      31.985  18.604   9.210  1.00  0.00           H  
ATOM    660  HA2 GLY A  49      33.759  19.264   6.940  1.00  0.00           H  
ATOM    661  HA3 GLY A  49      32.033  18.984   6.770  1.00  0.00           H  
ATOM    662  N   ALA A  50      31.672  21.433   6.795  1.00  0.00           N  
ATOM    663  CA  ALA A  50      31.337  22.849   6.893  1.00  0.00           C  
ATOM    664  C   ALA A  50      30.144  23.067   7.819  1.00  0.00           C  
ATOM    665  O   ALA A  50      30.264  23.712   8.860  1.00  0.00           O  
ATOM    666  CB  ALA A  50      31.047  23.419   5.513  1.00  0.00           C  
ATOM    667  H   ALA A  50      31.249  20.889   6.099  1.00  0.00           H  
ATOM    668  HA  ALA A  50      32.194  23.367   7.299  1.00  0.00           H  
ATOM    669  HB1 ALA A  50      31.954  23.417   4.927  1.00  0.00           H  
ATOM    670  HB2 ALA A  50      30.300  22.815   5.023  1.00  0.00           H  
ATOM    671  HB3 ALA A  50      30.685  24.432   5.612  1.00  0.00           H  
ATOM    672  N   ALA A  51      28.994  22.524   7.433  1.00  0.00           N  
ATOM    673  CA  ALA A  51      27.780  22.659   8.228  1.00  0.00           C  
ATOM    674  C   ALA A  51      28.023  22.240   9.675  1.00  0.00           C  
ATOM    675  O   ALA A  51      27.479  22.837  10.604  1.00  0.00           O  
ATOM    676  CB  ALA A  51      26.656  21.833   7.620  1.00  0.00           C  
ATOM    677  H   ALA A  51      28.963  22.020   6.593  1.00  0.00           H  
ATOM    678  HA  ALA A  51      27.483  23.696   8.211  1.00  0.00           H  
ATOM    679  HB1 ALA A  51      27.041  20.872   7.314  1.00  0.00           H  
ATOM    680  HB2 ALA A  51      25.876  21.692   8.353  1.00  0.00           H  
ATOM    681  HB3 ALA A  51      26.254  22.351   6.761  1.00  0.00           H  
ATOM    682  N   HIS A  52      28.843  21.209   9.858  1.00  0.00           N  
ATOM    683  CA  HIS A  52      29.158  20.711  11.192  1.00  0.00           C  
ATOM    684  C   HIS A  52      30.158  21.626  11.892  1.00  0.00           C  
ATOM    685  O   HIS A  52      29.810  22.335  12.838  1.00  0.00           O  
ATOM    686  CB  HIS A  52      29.718  19.291  11.110  1.00  0.00           C  
ATOM    687  CG  HIS A  52      30.165  18.746  12.432  1.00  0.00           C  
ATOM    688  ND1 HIS A  52      31.484  18.735  12.835  1.00  0.00           N  
ATOM    689  CD2 HIS A  52      29.458  18.191  13.445  1.00  0.00           C  
ATOM    690  CE1 HIS A  52      31.569  18.197  14.039  1.00  0.00           C  
ATOM    691  NE2 HIS A  52      30.354  17.858  14.431  1.00  0.00           N  
ATOM    692  H   HIS A  52      29.246  20.774   9.078  1.00  0.00           H  
ATOM    693  HA  HIS A  52      28.242  20.694  11.764  1.00  0.00           H  
ATOM    694  HB2 HIS A  52      28.956  18.632  10.720  1.00  0.00           H  
ATOM    695  HB3 HIS A  52      30.569  19.285  10.443  1.00  0.00           H  
ATOM    696  HD1 HIS A  52      32.243  19.072  12.317  1.00  0.00           H  
ATOM    697  HD2 HIS A  52      28.389  18.038  13.473  1.00  0.00           H  
ATOM    698  HE1 HIS A  52      32.477  18.057  14.605  1.00  0.00           H  
ATOM    699  HE2 HIS A  52      30.144  17.362  15.249  1.00  0.00           H  
ATOM    700  N   ARG A  53      31.401  21.605  11.424  1.00  0.00           N  
ATOM    701  CA  ARG A  53      32.451  22.431  12.007  1.00  0.00           C  
ATOM    702  C   ARG A  53      31.913  23.807  12.388  1.00  0.00           C  
ATOM    703  O   ARG A  53      32.325  24.389  13.390  1.00  0.00           O  
ATOM    704  CB  ARG A  53      33.615  22.582  11.024  1.00  0.00           C  
ATOM    705  CG  ARG A  53      34.878  23.140  11.657  1.00  0.00           C  
ATOM    706  CD  ARG A  53      36.081  22.971  10.743  1.00  0.00           C  
ATOM    707  NE  ARG A  53      37.278  23.605  11.289  1.00  0.00           N  
ATOM    708  CZ  ARG A  53      38.360  23.879  10.569  1.00  0.00           C  
ATOM    709  NH1 ARG A  53      38.394  23.575   9.278  1.00  0.00           N  
ATOM    710  NH2 ARG A  53      39.410  24.457  11.138  1.00  0.00           N  
ATOM    711  H   ARG A  53      31.618  21.018  10.668  1.00  0.00           H  
ATOM    712  HA  ARG A  53      32.806  21.936  12.897  1.00  0.00           H  
ATOM    713  HB2 ARG A  53      33.846  21.612  10.606  1.00  0.00           H  
ATOM    714  HB3 ARG A  53      33.313  23.246  10.227  1.00  0.00           H  
ATOM    715  HG2 ARG A  53      34.736  24.192  11.856  1.00  0.00           H  
ATOM    716  HG3 ARG A  53      35.065  22.619  12.584  1.00  0.00           H  
ATOM    717  HD2 ARG A  53      36.273  21.916  10.613  1.00  0.00           H  
ATOM    718  HD3 ARG A  53      35.854  23.416   9.785  1.00  0.00           H  
ATOM    719  HE  ARG A  53      37.274  23.837  12.242  1.00  0.00           H  
ATOM    720 HH11 ARG A  53      37.605  23.141   8.846  1.00  0.00           H  
ATOM    721 HH12 ARG A  53      39.210  23.784   8.737  1.00  0.00           H  
ATOM    722 HH21 ARG A  53      39.387  24.687  12.110  1.00  0.00           H  
ATOM    723 HH22 ARG A  53      40.223  24.663  10.595  1.00  0.00           H  
ATOM    724  N   ALA A  54      30.989  24.319  11.582  1.00  0.00           N  
ATOM    725  CA  ALA A  54      30.393  25.625  11.835  1.00  0.00           C  
ATOM    726  C   ALA A  54      30.104  25.816  13.320  1.00  0.00           C  
ATOM    727  O   ALA A  54      30.756  26.614  13.992  1.00  0.00           O  
ATOM    728  CB  ALA A  54      29.119  25.791  11.021  1.00  0.00           C  
ATOM    729  H   ALA A  54      30.701  23.807  10.798  1.00  0.00           H  
ATOM    730  HA  ALA A  54      31.096  26.381  11.515  1.00  0.00           H  
ATOM    731  HB1 ALA A  54      29.333  26.366  10.132  1.00  0.00           H  
ATOM    732  HB2 ALA A  54      28.743  24.818  10.739  1.00  0.00           H  
ATOM    733  HB3 ALA A  54      28.378  26.305  11.614  1.00  0.00           H  
ATOM    734  N   GLY A  55      29.119  25.080  13.826  1.00  0.00           N  
ATOM    735  CA  GLY A  55      28.759  25.186  15.229  1.00  0.00           C  
ATOM    736  C   GLY A  55      27.350  25.706  15.428  1.00  0.00           C  
ATOM    737  O   GLY A  55      26.694  25.382  16.419  1.00  0.00           O  
ATOM    738  H   GLY A  55      28.632  24.461  13.243  1.00  0.00           H  
ATOM    739  HA2 GLY A  55      28.839  24.208  15.683  1.00  0.00           H  
ATOM    740  HA3 GLY A  55      29.451  25.856  15.717  1.00  0.00           H  
ATOM    741  N   THR A  56      26.882  26.519  14.486  1.00  0.00           N  
ATOM    742  CA  THR A  56      25.543  27.088  14.564  1.00  0.00           C  
ATOM    743  C   THR A  56      24.555  26.290  13.721  1.00  0.00           C  
ATOM    744  O   THR A  56      23.555  26.828  13.243  1.00  0.00           O  
ATOM    745  CB  THR A  56      25.528  28.556  14.100  1.00  0.00           C  
ATOM    746  OG1 THR A  56      24.192  29.068  14.134  1.00  0.00           O  
ATOM    747  CG2 THR A  56      26.090  28.683  12.692  1.00  0.00           C  
ATOM    748  H   THR A  56      27.452  26.739  13.721  1.00  0.00           H  
ATOM    749  HA  THR A  56      25.227  27.056  15.597  1.00  0.00           H  
ATOM    750  HB  THR A  56      26.145  29.137  14.771  1.00  0.00           H  
ATOM    751  HG1 THR A  56      23.701  28.731  13.380  1.00  0.00           H  
ATOM    752 HG21 THR A  56      27.098  28.298  12.670  1.00  0.00           H  
ATOM    753 HG22 THR A  56      26.096  29.722  12.398  1.00  0.00           H  
ATOM    754 HG23 THR A  56      25.474  28.119  12.007  1.00  0.00           H  
ATOM    755  N   LEU A  57      24.841  25.005  13.541  1.00  0.00           N  
ATOM    756  CA  LEU A  57      23.977  24.132  12.755  1.00  0.00           C  
ATOM    757  C   LEU A  57      23.745  22.806  13.472  1.00  0.00           C  
ATOM    758  O   LEU A  57      24.694  22.127  13.864  1.00  0.00           O  
ATOM    759  CB  LEU A  57      24.592  23.878  11.377  1.00  0.00           C  
ATOM    760  CG  LEU A  57      24.480  25.023  10.370  1.00  0.00           C  
ATOM    761  CD1 LEU A  57      25.621  24.967   9.367  1.00  0.00           C  
ATOM    762  CD2 LEU A  57      23.136  24.975   9.656  1.00  0.00           C  
ATOM    763  H   LEU A  57      25.652  24.634  13.946  1.00  0.00           H  
ATOM    764  HA  LEU A  57      23.027  24.631  12.630  1.00  0.00           H  
ATOM    765  HB2 LEU A  57      25.641  23.665  11.518  1.00  0.00           H  
ATOM    766  HB3 LEU A  57      24.105  23.012  10.953  1.00  0.00           H  
ATOM    767  HG  LEU A  57      24.546  25.966  10.897  1.00  0.00           H  
ATOM    768 HD11 LEU A  57      25.437  24.174   8.657  1.00  0.00           H  
ATOM    769 HD12 LEU A  57      26.549  24.776   9.887  1.00  0.00           H  
ATOM    770 HD13 LEU A  57      25.689  25.911   8.845  1.00  0.00           H  
ATOM    771 HD21 LEU A  57      22.424  24.441  10.268  1.00  0.00           H  
ATOM    772 HD22 LEU A  57      23.250  24.467   8.709  1.00  0.00           H  
ATOM    773 HD23 LEU A  57      22.783  25.981   9.486  1.00  0.00           H  
ATOM    774  N   GLN A  58      22.476  22.444  13.639  1.00  0.00           N  
ATOM    775  CA  GLN A  58      22.120  21.198  14.308  1.00  0.00           C  
ATOM    776  C   GLN A  58      20.846  20.606  13.714  1.00  0.00           C  
ATOM    777  O   GLN A  58      19.894  21.328  13.417  1.00  0.00           O  
ATOM    778  CB  GLN A  58      21.936  21.435  15.807  1.00  0.00           C  
ATOM    779  CG  GLN A  58      23.200  21.905  16.510  1.00  0.00           C  
ATOM    780  CD  GLN A  58      22.922  22.502  17.875  1.00  0.00           C  
ATOM    781  OE1 GLN A  58      23.368  21.980  18.897  1.00  0.00           O  
ATOM    782  NE2 GLN A  58      22.181  23.603  17.900  1.00  0.00           N  
ATOM    783  H   GLN A  58      21.765  23.027  13.305  1.00  0.00           H  
ATOM    784  HA  GLN A  58      22.929  20.499  14.161  1.00  0.00           H  
ATOM    785  HB2 GLN A  58      21.171  22.183  15.951  1.00  0.00           H  
ATOM    786  HB3 GLN A  58      21.616  20.513  16.269  1.00  0.00           H  
ATOM    787  HG2 GLN A  58      23.864  21.062  16.632  1.00  0.00           H  
ATOM    788  HG3 GLN A  58      23.679  22.653  15.897  1.00  0.00           H  
ATOM    789 HE21 GLN A  58      21.859  23.963  17.046  1.00  0.00           H  
ATOM    790 HE22 GLN A  58      21.984  24.010  18.769  1.00  0.00           H  
ATOM    791  N   VAL A  59      20.836  19.288  13.544  1.00  0.00           N  
ATOM    792  CA  VAL A  59      19.678  18.599  12.985  1.00  0.00           C  
ATOM    793  C   VAL A  59      18.416  18.908  13.784  1.00  0.00           C  
ATOM    794  O   VAL A  59      18.228  18.400  14.889  1.00  0.00           O  
ATOM    795  CB  VAL A  59      19.894  17.074  12.956  1.00  0.00           C  
ATOM    796  CG1 VAL A  59      18.591  16.357  12.631  1.00  0.00           C  
ATOM    797  CG2 VAL A  59      20.978  16.709  11.954  1.00  0.00           C  
ATOM    798  H   VAL A  59      21.625  18.766  13.800  1.00  0.00           H  
ATOM    799  HA  VAL A  59      19.543  18.942  11.970  1.00  0.00           H  
ATOM    800  HB  VAL A  59      20.217  16.758  13.937  1.00  0.00           H  
ATOM    801 HG11 VAL A  59      17.875  16.538  13.419  1.00  0.00           H  
ATOM    802 HG12 VAL A  59      18.201  16.728  11.695  1.00  0.00           H  
ATOM    803 HG13 VAL A  59      18.776  15.296  12.550  1.00  0.00           H  
ATOM    804 HG21 VAL A  59      21.820  17.373  12.078  1.00  0.00           H  
ATOM    805 HG22 VAL A  59      21.296  15.689  12.123  1.00  0.00           H  
ATOM    806 HG23 VAL A  59      20.589  16.802  10.952  1.00  0.00           H  
ATOM    807  N   GLY A  60      17.554  19.746  13.217  1.00  0.00           N  
ATOM    808  CA  GLY A  60      16.320  20.109  13.890  1.00  0.00           C  
ATOM    809  C   GLY A  60      15.968  21.571  13.706  1.00  0.00           C  
ATOM    810  O   GLY A  60      14.795  21.921  13.575  1.00  0.00           O  
ATOM    811  H   GLY A  60      17.757  20.121  12.334  1.00  0.00           H  
ATOM    812  HA2 GLY A  60      15.518  19.502  13.497  1.00  0.00           H  
ATOM    813  HA3 GLY A  60      16.427  19.907  14.946  1.00  0.00           H  
ATOM    814  N   ASP A  61      16.984  22.427  13.697  1.00  0.00           N  
ATOM    815  CA  ASP A  61      16.775  23.860  13.528  1.00  0.00           C  
ATOM    816  C   ASP A  61      15.942  24.144  12.283  1.00  0.00           C  
ATOM    817  O   ASP A  61      16.174  23.564  11.222  1.00  0.00           O  
ATOM    818  CB  ASP A  61      18.119  24.584  13.434  1.00  0.00           C  
ATOM    819  CG  ASP A  61      18.944  24.442  14.699  1.00  0.00           C  
ATOM    820  OD1 ASP A  61      18.579  25.063  15.718  1.00  0.00           O  
ATOM    821  OD2 ASP A  61      19.952  23.706  14.669  1.00  0.00           O  
ATOM    822  H   ASP A  61      17.896  22.086  13.806  1.00  0.00           H  
ATOM    823  HA  ASP A  61      16.241  24.221  14.394  1.00  0.00           H  
ATOM    824  HB2 ASP A  61      18.685  24.176  12.610  1.00  0.00           H  
ATOM    825  HB3 ASP A  61      17.942  25.635  13.258  1.00  0.00           H  
ATOM    826  N   ARG A  62      14.969  25.041  12.420  1.00  0.00           N  
ATOM    827  CA  ARG A  62      14.100  25.401  11.306  1.00  0.00           C  
ATOM    828  C   ARG A  62      14.686  26.563  10.513  1.00  0.00           C  
ATOM    829  O   ARG A  62      15.274  27.484  11.081  1.00  0.00           O  
ATOM    830  CB  ARG A  62      12.707  25.770  11.818  1.00  0.00           C  
ATOM    831  CG  ARG A  62      11.799  26.355  10.749  1.00  0.00           C  
ATOM    832  CD  ARG A  62      10.638  27.122  11.361  1.00  0.00           C  
ATOM    833  NE  ARG A  62       9.509  26.249  11.672  1.00  0.00           N  
ATOM    834  CZ  ARG A  62       8.335  26.693  12.108  1.00  0.00           C  
ATOM    835  NH1 ARG A  62       8.139  27.992  12.285  1.00  0.00           N  
ATOM    836  NH2 ARG A  62       7.356  25.836  12.369  1.00  0.00           N  
ATOM    837  H   ARG A  62      14.833  25.469  13.291  1.00  0.00           H  
ATOM    838  HA  ARG A  62      14.019  24.541  10.658  1.00  0.00           H  
ATOM    839  HB2 ARG A  62      12.234  24.883  12.214  1.00  0.00           H  
ATOM    840  HB3 ARG A  62      12.809  26.497  12.610  1.00  0.00           H  
ATOM    841  HG2 ARG A  62      12.375  27.028  10.130  1.00  0.00           H  
ATOM    842  HG3 ARG A  62      11.409  25.551  10.142  1.00  0.00           H  
ATOM    843  HD2 ARG A  62      10.976  27.594  12.272  1.00  0.00           H  
ATOM    844  HD3 ARG A  62      10.315  27.878  10.662  1.00  0.00           H  
ATOM    845  HE  ARG A  62       9.633  25.285  11.548  1.00  0.00           H  
ATOM    846 HH11 ARG A  62       8.874  28.639  12.089  1.00  0.00           H  
ATOM    847 HH12 ARG A  62       7.253  28.323  12.614  1.00  0.00           H  
ATOM    848 HH21 ARG A  62       7.502  24.855  12.237  1.00  0.00           H  
ATOM    849 HH22 ARG A  62       6.473  26.170  12.698  1.00  0.00           H  
ATOM    850  N   VAL A  63      14.524  26.515   9.193  1.00  0.00           N  
ATOM    851  CA  VAL A  63      15.037  27.565   8.321  1.00  0.00           C  
ATOM    852  C   VAL A  63      13.949  28.579   7.985  1.00  0.00           C  
ATOM    853  O   VAL A  63      13.069  28.313   7.166  1.00  0.00           O  
ATOM    854  CB  VAL A  63      15.602  26.981   7.013  1.00  0.00           C  
ATOM    855  CG1 VAL A  63      16.062  28.095   6.086  1.00  0.00           C  
ATOM    856  CG2 VAL A  63      16.740  26.017   7.309  1.00  0.00           C  
ATOM    857  H   VAL A  63      14.047  25.755   8.799  1.00  0.00           H  
ATOM    858  HA  VAL A  63      15.838  28.069   8.841  1.00  0.00           H  
ATOM    859  HB  VAL A  63      14.814  26.433   6.517  1.00  0.00           H  
ATOM    860 HG11 VAL A  63      15.333  28.233   5.300  1.00  0.00           H  
ATOM    861 HG12 VAL A  63      16.167  29.011   6.647  1.00  0.00           H  
ATOM    862 HG13 VAL A  63      17.014  27.829   5.648  1.00  0.00           H  
ATOM    863 HG21 VAL A  63      16.375  25.205   7.920  1.00  0.00           H  
ATOM    864 HG22 VAL A  63      17.128  25.621   6.380  1.00  0.00           H  
ATOM    865 HG23 VAL A  63      17.527  26.537   7.833  1.00  0.00           H  
ATOM    866  N   LEU A  64      14.017  29.743   8.621  1.00  0.00           N  
ATOM    867  CA  LEU A  64      13.038  30.800   8.389  1.00  0.00           C  
ATOM    868  C   LEU A  64      13.215  31.411   7.002  1.00  0.00           C  
ATOM    869  O   LEU A  64      12.260  31.515   6.233  1.00  0.00           O  
ATOM    870  CB  LEU A  64      13.169  31.887   9.458  1.00  0.00           C  
ATOM    871  CG  LEU A  64      12.972  31.433  10.904  1.00  0.00           C  
ATOM    872  CD1 LEU A  64      13.447  32.507  11.870  1.00  0.00           C  
ATOM    873  CD2 LEU A  64      11.512  31.089  11.161  1.00  0.00           C  
ATOM    874  H   LEU A  64      14.742  29.897   9.262  1.00  0.00           H  
ATOM    875  HA  LEU A  64      12.055  30.360   8.453  1.00  0.00           H  
ATOM    876  HB2 LEU A  64      14.158  32.313   9.377  1.00  0.00           H  
ATOM    877  HB3 LEU A  64      12.432  32.649   9.245  1.00  0.00           H  
ATOM    878  HG  LEU A  64      13.562  30.543  11.080  1.00  0.00           H  
ATOM    879 HD11 LEU A  64      12.619  32.831  12.483  1.00  0.00           H  
ATOM    880 HD12 LEU A  64      13.833  33.347  11.312  1.00  0.00           H  
ATOM    881 HD13 LEU A  64      14.227  32.105  12.501  1.00  0.00           H  
ATOM    882 HD21 LEU A  64      11.251  31.362  12.173  1.00  0.00           H  
ATOM    883 HD22 LEU A  64      11.363  30.028  11.025  1.00  0.00           H  
ATOM    884 HD23 LEU A  64      10.887  31.633  10.469  1.00  0.00           H  
ATOM    885  N   SER A  65      14.443  31.810   6.689  1.00  0.00           N  
ATOM    886  CA  SER A  65      14.745  32.412   5.395  1.00  0.00           C  
ATOM    887  C   SER A  65      15.991  31.781   4.781  1.00  0.00           C  
ATOM    888  O   SER A  65      16.699  31.014   5.433  1.00  0.00           O  
ATOM    889  CB  SER A  65      14.944  33.921   5.546  1.00  0.00           C  
ATOM    890  OG  SER A  65      13.838  34.519   6.197  1.00  0.00           O  
ATOM    891  H   SER A  65      15.163  31.700   7.346  1.00  0.00           H  
ATOM    892  HA  SER A  65      13.904  32.232   4.742  1.00  0.00           H  
ATOM    893  HB2 SER A  65      15.833  34.108   6.127  1.00  0.00           H  
ATOM    894  HB3 SER A  65      15.055  34.366   4.566  1.00  0.00           H  
ATOM    895  HG  SER A  65      13.981  35.466   6.268  1.00  0.00           H  
ATOM    896  N   ILE A  66      16.252  32.110   3.520  1.00  0.00           N  
ATOM    897  CA  ILE A  66      17.412  31.578   2.816  1.00  0.00           C  
ATOM    898  C   ILE A  66      17.927  32.568   1.777  1.00  0.00           C  
ATOM    899  O   ILE A  66      17.218  32.919   0.836  1.00  0.00           O  
ATOM    900  CB  ILE A  66      17.084  30.244   2.120  1.00  0.00           C  
ATOM    901  CG1 ILE A  66      16.880  29.139   3.159  1.00  0.00           C  
ATOM    902  CG2 ILE A  66      18.194  29.867   1.149  1.00  0.00           C  
ATOM    903  CD1 ILE A  66      16.322  27.859   2.576  1.00  0.00           C  
ATOM    904  H   ILE A  66      15.651  32.726   3.052  1.00  0.00           H  
ATOM    905  HA  ILE A  66      18.190  31.400   3.544  1.00  0.00           H  
ATOM    906  HB  ILE A  66      16.174  30.372   1.557  1.00  0.00           H  
ATOM    907 HG12 ILE A  66      17.827  28.907   3.620  1.00  0.00           H  
ATOM    908 HG13 ILE A  66      16.192  29.488   3.914  1.00  0.00           H  
ATOM    909 HG21 ILE A  66      17.912  30.161   0.149  1.00  0.00           H  
ATOM    910 HG22 ILE A  66      19.105  30.375   1.429  1.00  0.00           H  
ATOM    911 HG23 ILE A  66      18.352  28.800   1.179  1.00  0.00           H  
ATOM    912 HD11 ILE A  66      16.463  27.859   1.506  1.00  0.00           H  
ATOM    913 HD12 ILE A  66      16.834  27.012   3.009  1.00  0.00           H  
ATOM    914 HD13 ILE A  66      15.266  27.793   2.799  1.00  0.00           H  
ATOM    915  N   ASN A  67      19.167  33.013   1.954  1.00  0.00           N  
ATOM    916  CA  ASN A  67      19.778  33.961   1.030  1.00  0.00           C  
ATOM    917  C   ASN A  67      18.923  35.218   0.897  1.00  0.00           C  
ATOM    918  O   ASN A  67      18.776  35.768  -0.194  1.00  0.00           O  
ATOM    919  CB  ASN A  67      19.973  33.314  -0.342  1.00  0.00           C  
ATOM    920  CG  ASN A  67      20.796  34.181  -1.277  1.00  0.00           C  
ATOM    921  OD1 ASN A  67      20.252  34.916  -2.101  1.00  0.00           O  
ATOM    922  ND2 ASN A  67      22.116  34.097  -1.153  1.00  0.00           N  
ATOM    923  H   ASN A  67      19.683  32.695   2.725  1.00  0.00           H  
ATOM    924  HA  ASN A  67      20.743  34.237   1.429  1.00  0.00           H  
ATOM    925  HB2 ASN A  67      20.481  32.369  -0.219  1.00  0.00           H  
ATOM    926  HB3 ASN A  67      19.008  33.145  -0.794  1.00  0.00           H  
ATOM    927 HD21 ASN A  67      22.479  33.489  -0.475  1.00  0.00           H  
ATOM    928 HD22 ASN A  67      22.672  34.646  -1.744  1.00  0.00           H  
ATOM    929  N   GLY A  68      18.360  35.667   2.015  1.00  0.00           N  
ATOM    930  CA  GLY A  68      17.527  36.854   2.001  1.00  0.00           C  
ATOM    931  C   GLY A  68      16.164  36.600   1.388  1.00  0.00           C  
ATOM    932  O   GLY A  68      15.646  37.430   0.641  1.00  0.00           O  
ATOM    933  H   GLY A  68      18.512  35.187   2.856  1.00  0.00           H  
ATOM    934  HA2 GLY A  68      17.396  37.201   3.015  1.00  0.00           H  
ATOM    935  HA3 GLY A  68      18.027  37.624   1.431  1.00  0.00           H  
ATOM    936  N   VAL A  69      15.581  35.447   1.703  1.00  0.00           N  
ATOM    937  CA  VAL A  69      14.271  35.085   1.178  1.00  0.00           C  
ATOM    938  C   VAL A  69      13.485  34.255   2.187  1.00  0.00           C  
ATOM    939  O   VAL A  69      13.915  33.172   2.584  1.00  0.00           O  
ATOM    940  CB  VAL A  69      14.392  34.294  -0.137  1.00  0.00           C  
ATOM    941  CG1 VAL A  69      13.018  33.883  -0.644  1.00  0.00           C  
ATOM    942  CG2 VAL A  69      15.132  35.113  -1.185  1.00  0.00           C  
ATOM    943  H   VAL A  69      16.044  34.826   2.304  1.00  0.00           H  
ATOM    944  HA  VAL A  69      13.728  35.997   0.977  1.00  0.00           H  
ATOM    945  HB  VAL A  69      14.962  33.397   0.057  1.00  0.00           H  
ATOM    946 HG11 VAL A  69      12.940  34.110  -1.696  1.00  0.00           H  
ATOM    947 HG12 VAL A  69      12.879  32.823  -0.491  1.00  0.00           H  
ATOM    948 HG13 VAL A  69      12.258  34.428  -0.101  1.00  0.00           H  
ATOM    949 HG21 VAL A  69      16.197  34.993  -1.048  1.00  0.00           H  
ATOM    950 HG22 VAL A  69      14.856  34.770  -2.172  1.00  0.00           H  
ATOM    951 HG23 VAL A  69      14.870  36.154  -1.079  1.00  0.00           H  
ATOM    952  N   ASP A  70      12.332  34.770   2.598  1.00  0.00           N  
ATOM    953  CA  ASP A  70      11.484  34.076   3.561  1.00  0.00           C  
ATOM    954  C   ASP A  70      10.993  32.748   2.993  1.00  0.00           C  
ATOM    955  O   ASP A  70      10.227  32.718   2.029  1.00  0.00           O  
ATOM    956  CB  ASP A  70      10.291  34.951   3.947  1.00  0.00           C  
ATOM    957  CG  ASP A  70       9.173  34.155   4.591  1.00  0.00           C  
ATOM    958  OD1 ASP A  70       9.459  33.076   5.151  1.00  0.00           O  
ATOM    959  OD2 ASP A  70       8.013  34.613   4.537  1.00  0.00           O  
ATOM    960  H   ASP A  70      12.043  35.638   2.245  1.00  0.00           H  
ATOM    961  HA  ASP A  70      12.076  33.879   4.442  1.00  0.00           H  
ATOM    962  HB2 ASP A  70      10.619  35.707   4.646  1.00  0.00           H  
ATOM    963  HB3 ASP A  70       9.904  35.432   3.061  1.00  0.00           H  
ATOM    964  N   VAL A  71      11.439  31.650   3.596  1.00  0.00           N  
ATOM    965  CA  VAL A  71      11.045  30.319   3.151  1.00  0.00           C  
ATOM    966  C   VAL A  71      10.408  29.526   4.287  1.00  0.00           C  
ATOM    967  O   VAL A  71      10.472  28.296   4.313  1.00  0.00           O  
ATOM    968  CB  VAL A  71      12.250  29.531   2.602  1.00  0.00           C  
ATOM    969  CG1 VAL A  71      12.789  30.191   1.341  1.00  0.00           C  
ATOM    970  CG2 VAL A  71      13.337  29.416   3.660  1.00  0.00           C  
ATOM    971  H   VAL A  71      12.048  31.738   4.359  1.00  0.00           H  
ATOM    972  HA  VAL A  71      10.323  30.433   2.356  1.00  0.00           H  
ATOM    973  HB  VAL A  71      11.918  28.536   2.346  1.00  0.00           H  
ATOM    974 HG11 VAL A  71      13.019  31.225   1.547  1.00  0.00           H  
ATOM    975 HG12 VAL A  71      13.684  29.678   1.022  1.00  0.00           H  
ATOM    976 HG13 VAL A  71      12.045  30.136   0.560  1.00  0.00           H  
ATOM    977 HG21 VAL A  71      13.119  30.091   4.474  1.00  0.00           H  
ATOM    978 HG22 VAL A  71      13.370  28.402   4.033  1.00  0.00           H  
ATOM    979 HG23 VAL A  71      14.292  29.670   3.225  1.00  0.00           H  
ATOM    980  N   THR A  72       9.793  30.237   5.225  1.00  0.00           N  
ATOM    981  CA  THR A  72       9.144  29.601   6.365  1.00  0.00           C  
ATOM    982  C   THR A  72       8.157  28.533   5.909  1.00  0.00           C  
ATOM    983  O   THR A  72       8.249  27.376   6.318  1.00  0.00           O  
ATOM    984  CB  THR A  72       8.402  30.632   7.237  1.00  0.00           C  
ATOM    985  OG1 THR A  72       7.682  31.549   6.406  1.00  0.00           O  
ATOM    986  CG2 THR A  72       9.378  31.397   8.119  1.00  0.00           C  
ATOM    987  H   THR A  72       9.776  31.215   5.149  1.00  0.00           H  
ATOM    988  HA  THR A  72       9.911  29.137   6.968  1.00  0.00           H  
ATOM    989  HB  THR A  72       7.703  30.106   7.871  1.00  0.00           H  
ATOM    990  HG1 THR A  72       7.226  32.189   6.957  1.00  0.00           H  
ATOM    991 HG21 THR A  72       9.928  30.701   8.735  1.00  0.00           H  
ATOM    992 HG22 THR A  72       8.831  32.082   8.749  1.00  0.00           H  
ATOM    993 HG23 THR A  72      10.066  31.949   7.497  1.00  0.00           H  
ATOM    994  N   GLU A  73       7.214  28.929   5.061  1.00  0.00           N  
ATOM    995  CA  GLU A  73       6.208  28.003   4.550  1.00  0.00           C  
ATOM    996  C   GLU A  73       6.428  27.728   3.066  1.00  0.00           C  
ATOM    997  O   GLU A  73       5.498  27.358   2.349  1.00  0.00           O  
ATOM    998  CB  GLU A  73       4.804  28.566   4.774  1.00  0.00           C  
ATOM    999  CG  GLU A  73       4.476  28.822   6.236  1.00  0.00           C  
ATOM   1000  CD  GLU A  73       3.092  29.411   6.429  1.00  0.00           C  
ATOM   1001  OE1 GLU A  73       2.696  30.273   5.618  1.00  0.00           O  
ATOM   1002  OE2 GLU A  73       2.406  29.009   7.392  1.00  0.00           O  
ATOM   1003  H   GLU A  73       7.192  29.865   4.772  1.00  0.00           H  
ATOM   1004  HA  GLU A  73       6.306  27.076   5.095  1.00  0.00           H  
ATOM   1005  HB2 GLU A  73       4.713  29.500   4.238  1.00  0.00           H  
ATOM   1006  HB3 GLU A  73       4.082  27.866   4.383  1.00  0.00           H  
ATOM   1007  HG2 GLU A  73       4.530  27.886   6.772  1.00  0.00           H  
ATOM   1008  HG3 GLU A  73       5.204  29.509   6.640  1.00  0.00           H  
ATOM   1009  N   ALA A  74       7.662  27.912   2.611  1.00  0.00           N  
ATOM   1010  CA  ALA A  74       8.005  27.682   1.213  1.00  0.00           C  
ATOM   1011  C   ALA A  74       8.004  26.192   0.885  1.00  0.00           C  
ATOM   1012  O   ALA A  74       8.268  25.356   1.750  1.00  0.00           O  
ATOM   1013  CB  ALA A  74       9.361  28.293   0.894  1.00  0.00           C  
ATOM   1014  H   ALA A  74       8.361  28.206   3.232  1.00  0.00           H  
ATOM   1015  HA  ALA A  74       7.262  28.175   0.602  1.00  0.00           H  
ATOM   1016  HB1 ALA A  74      10.082  27.973   1.632  1.00  0.00           H  
ATOM   1017  HB2 ALA A  74       9.680  27.970  -0.086  1.00  0.00           H  
ATOM   1018  HB3 ALA A  74       9.283  29.370   0.910  1.00  0.00           H  
ATOM   1019  N   ARG A  75       7.706  25.867  -0.368  1.00  0.00           N  
ATOM   1020  CA  ARG A  75       7.668  24.478  -0.809  1.00  0.00           C  
ATOM   1021  C   ARG A  75       9.076  23.893  -0.883  1.00  0.00           C  
ATOM   1022  O   ARG A  75      10.039  24.602  -1.180  1.00  0.00           O  
ATOM   1023  CB  ARG A  75       6.989  24.373  -2.176  1.00  0.00           C  
ATOM   1024  CG  ARG A  75       5.646  25.082  -2.245  1.00  0.00           C  
ATOM   1025  CD  ARG A  75       5.350  25.578  -3.652  1.00  0.00           C  
ATOM   1026  NE  ARG A  75       3.943  25.927  -3.824  1.00  0.00           N  
ATOM   1027  CZ  ARG A  75       3.504  26.777  -4.744  1.00  0.00           C  
ATOM   1028  NH1 ARG A  75       4.357  27.362  -5.572  1.00  0.00           N  
ATOM   1029  NH2 ARG A  75       2.207  27.042  -4.839  1.00  0.00           N  
ATOM   1030  H   ARG A  75       7.505  26.579  -1.011  1.00  0.00           H  
ATOM   1031  HA  ARG A  75       7.095  23.916  -0.088  1.00  0.00           H  
ATOM   1032  HB2 ARG A  75       7.638  24.804  -2.922  1.00  0.00           H  
ATOM   1033  HB3 ARG A  75       6.832  23.329  -2.407  1.00  0.00           H  
ATOM   1034  HG2 ARG A  75       4.870  24.393  -1.947  1.00  0.00           H  
ATOM   1035  HG3 ARG A  75       5.660  25.925  -1.570  1.00  0.00           H  
ATOM   1036  HD2 ARG A  75       5.954  26.452  -3.844  1.00  0.00           H  
ATOM   1037  HD3 ARG A  75       5.607  24.800  -4.354  1.00  0.00           H  
ATOM   1038  HE  ARG A  75       3.293  25.505  -3.222  1.00  0.00           H  
ATOM   1039 HH11 ARG A  75       5.335  27.163  -5.504  1.00  0.00           H  
ATOM   1040 HH12 ARG A  75       4.024  28.001  -6.266  1.00  0.00           H  
ATOM   1041 HH21 ARG A  75       1.560  26.603  -4.217  1.00  0.00           H  
ATOM   1042 HH22 ARG A  75       1.877  27.684  -5.533  1.00  0.00           H  
ATOM   1043  N   HIS A  76       9.187  22.597  -0.609  1.00  0.00           N  
ATOM   1044  CA  HIS A  76      10.478  21.917  -0.644  1.00  0.00           C  
ATOM   1045  C   HIS A  76      11.325  22.420  -1.809  1.00  0.00           C  
ATOM   1046  O   HIS A  76      12.340  23.087  -1.608  1.00  0.00           O  
ATOM   1047  CB  HIS A  76      10.278  20.406  -0.758  1.00  0.00           C  
ATOM   1048  CG  HIS A  76      11.498  19.611  -0.406  1.00  0.00           C  
ATOM   1049  ND1 HIS A  76      11.910  19.403   0.892  1.00  0.00           N  
ATOM   1050  CD2 HIS A  76      12.396  18.972  -1.192  1.00  0.00           C  
ATOM   1051  CE1 HIS A  76      13.011  18.671   0.890  1.00  0.00           C  
ATOM   1052  NE2 HIS A  76      13.326  18.396  -0.362  1.00  0.00           N  
ATOM   1053  H   HIS A  76       8.384  22.086  -0.379  1.00  0.00           H  
ATOM   1054  HA  HIS A  76      10.992  22.134   0.279  1.00  0.00           H  
ATOM   1055  HB2 HIS A  76       9.482  20.103  -0.094  1.00  0.00           H  
ATOM   1056  HB3 HIS A  76      10.004  20.161  -1.774  1.00  0.00           H  
ATOM   1057  HD1 HIS A  76      11.465  19.741   1.696  1.00  0.00           H  
ATOM   1058  HD2 HIS A  76      12.384  18.925  -2.273  1.00  0.00           H  
ATOM   1059  HE1 HIS A  76      13.559  18.351   1.763  1.00  0.00           H  
ATOM   1060  HE2 HIS A  76      14.143  17.941  -0.652  1.00  0.00           H  
ATOM   1061  N   ASP A  77      10.903  22.094  -3.025  1.00  0.00           N  
ATOM   1062  CA  ASP A  77      11.623  22.513  -4.222  1.00  0.00           C  
ATOM   1063  C   ASP A  77      11.899  24.013  -4.193  1.00  0.00           C  
ATOM   1064  O   ASP A  77      12.995  24.459  -4.536  1.00  0.00           O  
ATOM   1065  CB  ASP A  77      10.824  22.154  -5.475  1.00  0.00           C  
ATOM   1066  CG  ASP A  77      10.633  20.657  -5.632  1.00  0.00           C  
ATOM   1067  OD1 ASP A  77      10.215  20.008  -4.651  1.00  0.00           O  
ATOM   1068  OD2 ASP A  77      10.903  20.137  -6.735  1.00  0.00           O  
ATOM   1069  H   ASP A  77      10.087  21.560  -3.120  1.00  0.00           H  
ATOM   1070  HA  ASP A  77      12.565  21.986  -4.245  1.00  0.00           H  
ATOM   1071  HB2 ASP A  77       9.850  22.617  -5.420  1.00  0.00           H  
ATOM   1072  HB3 ASP A  77      11.345  22.525  -6.345  1.00  0.00           H  
ATOM   1073  N   HIS A  78      10.900  24.786  -3.782  1.00  0.00           N  
ATOM   1074  CA  HIS A  78      11.035  26.237  -3.709  1.00  0.00           C  
ATOM   1075  C   HIS A  78      12.277  26.626  -2.912  1.00  0.00           C  
ATOM   1076  O   HIS A  78      13.133  27.364  -3.400  1.00  0.00           O  
ATOM   1077  CB  HIS A  78       9.792  26.855  -3.071  1.00  0.00           C  
ATOM   1078  CG  HIS A  78       9.687  28.334  -3.273  1.00  0.00           C  
ATOM   1079  ND1 HIS A  78       8.708  28.921  -4.049  1.00  0.00           N  
ATOM   1080  CD2 HIS A  78      10.445  29.349  -2.795  1.00  0.00           C  
ATOM   1081  CE1 HIS A  78       8.870  30.232  -4.040  1.00  0.00           C  
ATOM   1082  NE2 HIS A  78       9.916  30.518  -3.285  1.00  0.00           N  
ATOM   1083  H   HIS A  78      10.052  24.371  -3.522  1.00  0.00           H  
ATOM   1084  HA  HIS A  78      11.137  26.612  -4.716  1.00  0.00           H  
ATOM   1085  HB2 HIS A  78       8.911  26.399  -3.499  1.00  0.00           H  
ATOM   1086  HB3 HIS A  78       9.808  26.664  -2.007  1.00  0.00           H  
ATOM   1087  HD1 HIS A  78       8.003  28.447  -4.534  1.00  0.00           H  
ATOM   1088  HD2 HIS A  78      11.305  29.258  -2.147  1.00  0.00           H  
ATOM   1089  HE1 HIS A  78       8.252  30.949  -4.560  1.00  0.00           H  
ATOM   1090  HE2 HIS A  78      10.307  31.410  -3.178  1.00  0.00           H  
ATOM   1091  N   ALA A  79      12.368  26.127  -1.684  1.00  0.00           N  
ATOM   1092  CA  ALA A  79      13.505  26.422  -0.821  1.00  0.00           C  
ATOM   1093  C   ALA A  79      14.816  26.004  -1.478  1.00  0.00           C  
ATOM   1094  O   ALA A  79      15.803  26.737  -1.437  1.00  0.00           O  
ATOM   1095  CB  ALA A  79      13.341  25.728   0.523  1.00  0.00           C  
ATOM   1096  H   ALA A  79      11.653  25.545  -1.351  1.00  0.00           H  
ATOM   1097  HA  ALA A  79      13.524  27.489  -0.648  1.00  0.00           H  
ATOM   1098  HB1 ALA A  79      13.433  24.660   0.390  1.00  0.00           H  
ATOM   1099  HB2 ALA A  79      14.106  26.074   1.202  1.00  0.00           H  
ATOM   1100  HB3 ALA A  79      12.367  25.958   0.930  1.00  0.00           H  
ATOM   1101  N   VAL A  80      14.818  24.820  -2.083  1.00  0.00           N  
ATOM   1102  CA  VAL A  80      16.007  24.304  -2.750  1.00  0.00           C  
ATOM   1103  C   VAL A  80      16.495  25.268  -3.826  1.00  0.00           C  
ATOM   1104  O   VAL A  80      17.696  25.510  -3.959  1.00  0.00           O  
ATOM   1105  CB  VAL A  80      15.740  22.929  -3.390  1.00  0.00           C  
ATOM   1106  CG1 VAL A  80      16.975  22.436  -4.130  1.00  0.00           C  
ATOM   1107  CG2 VAL A  80      15.305  21.926  -2.333  1.00  0.00           C  
ATOM   1108  H   VAL A  80      13.999  24.282  -2.082  1.00  0.00           H  
ATOM   1109  HA  VAL A  80      16.782  24.188  -2.006  1.00  0.00           H  
ATOM   1110  HB  VAL A  80      14.939  23.038  -4.106  1.00  0.00           H  
ATOM   1111 HG11 VAL A  80      17.629  23.270  -4.335  1.00  0.00           H  
ATOM   1112 HG12 VAL A  80      17.494  21.710  -3.520  1.00  0.00           H  
ATOM   1113 HG13 VAL A  80      16.676  21.977  -5.061  1.00  0.00           H  
ATOM   1114 HG21 VAL A  80      15.099  20.975  -2.804  1.00  0.00           H  
ATOM   1115 HG22 VAL A  80      16.094  21.803  -1.606  1.00  0.00           H  
ATOM   1116 HG23 VAL A  80      14.414  22.284  -1.842  1.00  0.00           H  
ATOM   1117  N   SER A  81      15.557  25.816  -4.592  1.00  0.00           N  
ATOM   1118  CA  SER A  81      15.892  26.751  -5.659  1.00  0.00           C  
ATOM   1119  C   SER A  81      16.983  27.719  -5.211  1.00  0.00           C  
ATOM   1120  O   SER A  81      17.737  28.248  -6.030  1.00  0.00           O  
ATOM   1121  CB  SER A  81      14.649  27.531  -6.092  1.00  0.00           C  
ATOM   1122  OG  SER A  81      14.799  28.041  -7.405  1.00  0.00           O  
ATOM   1123  H   SER A  81      14.619  25.583  -4.436  1.00  0.00           H  
ATOM   1124  HA  SER A  81      16.258  26.179  -6.499  1.00  0.00           H  
ATOM   1125  HB2 SER A  81      13.791  26.876  -6.068  1.00  0.00           H  
ATOM   1126  HB3 SER A  81      14.491  28.357  -5.412  1.00  0.00           H  
ATOM   1127  HG  SER A  81      14.636  27.341  -8.041  1.00  0.00           H  
ATOM   1128  N   LEU A  82      17.061  27.948  -3.904  1.00  0.00           N  
ATOM   1129  CA  LEU A  82      18.060  28.853  -3.345  1.00  0.00           C  
ATOM   1130  C   LEU A  82      19.312  28.090  -2.925  1.00  0.00           C  
ATOM   1131  O   LEU A  82      20.434  28.540  -3.159  1.00  0.00           O  
ATOM   1132  CB  LEU A  82      17.481  29.605  -2.145  1.00  0.00           C  
ATOM   1133  CG  LEU A  82      16.168  30.351  -2.390  1.00  0.00           C  
ATOM   1134  CD1 LEU A  82      15.503  30.708  -1.071  1.00  0.00           C  
ATOM   1135  CD2 LEU A  82      16.414  31.602  -3.221  1.00  0.00           C  
ATOM   1136  H   LEU A  82      16.434  27.499  -3.302  1.00  0.00           H  
ATOM   1137  HA  LEU A  82      18.327  29.566  -4.111  1.00  0.00           H  
ATOM   1138  HB2 LEU A  82      17.310  28.888  -1.357  1.00  0.00           H  
ATOM   1139  HB3 LEU A  82      18.217  30.326  -1.820  1.00  0.00           H  
ATOM   1140  HG  LEU A  82      15.495  29.710  -2.942  1.00  0.00           H  
ATOM   1141 HD11 LEU A  82      15.275  29.804  -0.527  1.00  0.00           H  
ATOM   1142 HD12 LEU A  82      14.589  31.251  -1.264  1.00  0.00           H  
ATOM   1143 HD13 LEU A  82      16.170  31.324  -0.486  1.00  0.00           H  
ATOM   1144 HD21 LEU A  82      15.877  31.524  -4.156  1.00  0.00           H  
ATOM   1145 HD22 LEU A  82      17.471  31.700  -3.422  1.00  0.00           H  
ATOM   1146 HD23 LEU A  82      16.069  32.469  -2.678  1.00  0.00           H  
ATOM   1147  N   LEU A  83      19.112  26.932  -2.305  1.00  0.00           N  
ATOM   1148  CA  LEU A  83      20.225  26.103  -1.854  1.00  0.00           C  
ATOM   1149  C   LEU A  83      21.005  25.546  -3.040  1.00  0.00           C  
ATOM   1150  O   LEU A  83      22.220  25.720  -3.136  1.00  0.00           O  
ATOM   1151  CB  LEU A  83      19.712  24.957  -0.982  1.00  0.00           C  
ATOM   1152  CG  LEU A  83      19.449  25.296   0.486  1.00  0.00           C  
ATOM   1153  CD1 LEU A  83      18.627  24.200   1.148  1.00  0.00           C  
ATOM   1154  CD2 LEU A  83      20.761  25.503   1.229  1.00  0.00           C  
ATOM   1155  H   LEU A  83      18.196  26.626  -2.146  1.00  0.00           H  
ATOM   1156  HA  LEU A  83      20.884  26.726  -1.266  1.00  0.00           H  
ATOM   1157  HB2 LEU A  83      18.788  24.603  -1.410  1.00  0.00           H  
ATOM   1158  HB3 LEU A  83      20.447  24.165  -1.013  1.00  0.00           H  
ATOM   1159  HG  LEU A  83      18.883  26.216   0.541  1.00  0.00           H  
ATOM   1160 HD11 LEU A  83      19.271  23.591   1.765  1.00  0.00           H  
ATOM   1161 HD12 LEU A  83      18.170  23.585   0.388  1.00  0.00           H  
ATOM   1162 HD13 LEU A  83      17.858  24.647   1.760  1.00  0.00           H  
ATOM   1163 HD21 LEU A  83      21.003  24.612   1.788  1.00  0.00           H  
ATOM   1164 HD22 LEU A  83      20.662  26.338   1.908  1.00  0.00           H  
ATOM   1165 HD23 LEU A  83      21.548  25.708   0.518  1.00  0.00           H  
ATOM   1166  N   THR A  84      20.297  24.875  -3.945  1.00  0.00           N  
ATOM   1167  CA  THR A  84      20.922  24.293  -5.126  1.00  0.00           C  
ATOM   1168  C   THR A  84      21.621  25.360  -5.960  1.00  0.00           C  
ATOM   1169  O   THR A  84      22.444  25.048  -6.821  1.00  0.00           O  
ATOM   1170  CB  THR A  84      19.890  23.564  -6.006  1.00  0.00           C  
ATOM   1171  OG1 THR A  84      18.666  24.306  -6.043  1.00  0.00           O  
ATOM   1172  CG2 THR A  84      19.622  22.163  -5.477  1.00  0.00           C  
ATOM   1173  H   THR A  84      19.332  24.770  -3.812  1.00  0.00           H  
ATOM   1174  HA  THR A  84      21.655  23.572  -4.793  1.00  0.00           H  
ATOM   1175  HB  THR A  84      20.285  23.485  -7.008  1.00  0.00           H  
ATOM   1176  HG1 THR A  84      18.107  23.969  -6.747  1.00  0.00           H  
ATOM   1177 HG21 THR A  84      18.629  21.851  -5.768  1.00  0.00           H  
ATOM   1178 HG22 THR A  84      19.697  22.164  -4.400  1.00  0.00           H  
ATOM   1179 HG23 THR A  84      20.349  21.478  -5.889  1.00  0.00           H  
ATOM   1180  N   ALA A  85      21.288  26.621  -5.701  1.00  0.00           N  
ATOM   1181  CA  ALA A  85      21.887  27.733  -6.427  1.00  0.00           C  
ATOM   1182  C   ALA A  85      23.403  27.589  -6.501  1.00  0.00           C  
ATOM   1183  O   ALA A  85      24.035  27.093  -5.568  1.00  0.00           O  
ATOM   1184  CB  ALA A  85      21.512  29.054  -5.771  1.00  0.00           C  
ATOM   1185  H   ALA A  85      20.626  26.806  -5.003  1.00  0.00           H  
ATOM   1186  HA  ALA A  85      21.485  27.732  -7.430  1.00  0.00           H  
ATOM   1187  HB1 ALA A  85      22.241  29.298  -5.011  1.00  0.00           H  
ATOM   1188  HB2 ALA A  85      21.495  29.835  -6.516  1.00  0.00           H  
ATOM   1189  HB3 ALA A  85      20.536  28.966  -5.317  1.00  0.00           H  
ATOM   1190  N   ALA A  86      23.981  28.025  -7.615  1.00  0.00           N  
ATOM   1191  CA  ALA A  86      25.422  27.946  -7.810  1.00  0.00           C  
ATOM   1192  C   ALA A  86      26.126  29.154  -7.203  1.00  0.00           C  
ATOM   1193  O   ALA A  86      26.655  30.003  -7.923  1.00  0.00           O  
ATOM   1194  CB  ALA A  86      25.750  27.830  -9.291  1.00  0.00           C  
ATOM   1195  H   ALA A  86      23.423  28.411  -8.323  1.00  0.00           H  
ATOM   1196  HA  ALA A  86      25.777  27.052  -7.318  1.00  0.00           H  
ATOM   1197  HB1 ALA A  86      26.581  28.480  -9.527  1.00  0.00           H  
ATOM   1198  HB2 ALA A  86      26.013  26.809  -9.524  1.00  0.00           H  
ATOM   1199  HB3 ALA A  86      24.889  28.122  -9.874  1.00  0.00           H  
ATOM   1200  N   SER A  87      26.128  29.228  -5.875  1.00  0.00           N  
ATOM   1201  CA  SER A  87      26.764  30.336  -5.173  1.00  0.00           C  
ATOM   1202  C   SER A  87      27.771  29.825  -4.147  1.00  0.00           C  
ATOM   1203  O   SER A  87      27.546  28.824  -3.466  1.00  0.00           O  
ATOM   1204  CB  SER A  87      25.708  31.200  -4.480  1.00  0.00           C  
ATOM   1205  OG  SER A  87      24.848  30.410  -3.678  1.00  0.00           O  
ATOM   1206  H   SER A  87      25.690  28.521  -5.358  1.00  0.00           H  
ATOM   1207  HA  SER A  87      27.285  30.937  -5.903  1.00  0.00           H  
ATOM   1208  HB2 SER A  87      26.198  31.929  -3.853  1.00  0.00           H  
ATOM   1209  HB3 SER A  87      25.115  31.709  -5.228  1.00  0.00           H  
ATOM   1210  HG  SER A  87      25.336  29.660  -3.328  1.00  0.00           H  
ATOM   1211  N   PRO A  88      28.907  30.526  -4.035  1.00  0.00           N  
ATOM   1212  CA  PRO A  88      29.973  30.162  -3.094  1.00  0.00           C  
ATOM   1213  C   PRO A  88      29.568  30.396  -1.643  1.00  0.00           C  
ATOM   1214  O   PRO A  88      30.217  29.901  -0.720  1.00  0.00           O  
ATOM   1215  CB  PRO A  88      31.124  31.091  -3.486  1.00  0.00           C  
ATOM   1216  CG  PRO A  88      30.464  32.266  -4.122  1.00  0.00           C  
ATOM   1217  CD  PRO A  88      29.242  31.729  -4.815  1.00  0.00           C  
ATOM   1218  HA  PRO A  88      30.278  29.133  -3.221  1.00  0.00           H  
ATOM   1219  HB2 PRO A  88      31.675  31.378  -2.602  1.00  0.00           H  
ATOM   1220  HB3 PRO A  88      31.780  30.585  -4.179  1.00  0.00           H  
ATOM   1221  HG2 PRO A  88      30.181  32.982  -3.366  1.00  0.00           H  
ATOM   1222  HG3 PRO A  88      31.132  32.719  -4.839  1.00  0.00           H  
ATOM   1223  HD2 PRO A  88      28.438  32.450  -4.777  1.00  0.00           H  
ATOM   1224  HD3 PRO A  88      29.472  31.472  -5.839  1.00  0.00           H  
ATOM   1225  N   THR A  89      28.494  31.153  -1.447  1.00  0.00           N  
ATOM   1226  CA  THR A  89      28.005  31.453  -0.108  1.00  0.00           C  
ATOM   1227  C   THR A  89      26.503  31.211  -0.003  1.00  0.00           C  
ATOM   1228  O   THR A  89      25.768  31.392  -0.974  1.00  0.00           O  
ATOM   1229  CB  THR A  89      28.306  32.912   0.287  1.00  0.00           C  
ATOM   1230  OG1 THR A  89      27.991  33.788  -0.799  1.00  0.00           O  
ATOM   1231  CG2 THR A  89      29.770  33.076   0.671  1.00  0.00           C  
ATOM   1232  H   THR A  89      28.020  31.519  -2.223  1.00  0.00           H  
ATOM   1233  HA  THR A  89      28.514  30.802   0.588  1.00  0.00           H  
ATOM   1234  HB  THR A  89      27.695  33.172   1.140  1.00  0.00           H  
ATOM   1235  HG1 THR A  89      28.515  34.589  -0.727  1.00  0.00           H  
ATOM   1236 HG21 THR A  89      30.392  32.602  -0.073  1.00  0.00           H  
ATOM   1237 HG22 THR A  89      29.943  32.617   1.633  1.00  0.00           H  
ATOM   1238 HG23 THR A  89      30.011  34.127   0.725  1.00  0.00           H  
ATOM   1239  N   ILE A  90      26.055  30.802   1.179  1.00  0.00           N  
ATOM   1240  CA  ILE A  90      24.641  30.537   1.410  1.00  0.00           C  
ATOM   1241  C   ILE A  90      24.236  30.910   2.831  1.00  0.00           C  
ATOM   1242  O   ILE A  90      24.603  30.232   3.790  1.00  0.00           O  
ATOM   1243  CB  ILE A  90      24.298  29.056   1.162  1.00  0.00           C  
ATOM   1244  CG1 ILE A  90      24.576  28.682  -0.296  1.00  0.00           C  
ATOM   1245  CG2 ILE A  90      22.843  28.783   1.516  1.00  0.00           C  
ATOM   1246  CD1 ILE A  90      24.272  27.236  -0.617  1.00  0.00           C  
ATOM   1247  H   ILE A  90      26.691  30.676   1.914  1.00  0.00           H  
ATOM   1248  HA  ILE A  90      24.072  31.139   0.714  1.00  0.00           H  
ATOM   1249  HB  ILE A  90      24.919  28.453   1.806  1.00  0.00           H  
ATOM   1250 HG12 ILE A  90      23.971  29.299  -0.941  1.00  0.00           H  
ATOM   1251 HG13 ILE A  90      25.619  28.858  -0.512  1.00  0.00           H  
ATOM   1252 HG21 ILE A  90      22.305  28.491   0.627  1.00  0.00           H  
ATOM   1253 HG22 ILE A  90      22.795  27.986   2.242  1.00  0.00           H  
ATOM   1254 HG23 ILE A  90      22.400  29.676   1.930  1.00  0.00           H  
ATOM   1255 HD11 ILE A  90      24.259  27.099  -1.688  1.00  0.00           H  
ATOM   1256 HD12 ILE A  90      25.030  26.602  -0.182  1.00  0.00           H  
ATOM   1257 HD13 ILE A  90      23.306  26.971  -0.210  1.00  0.00           H  
ATOM   1258  N   ALA A  91      23.475  31.992   2.959  1.00  0.00           N  
ATOM   1259  CA  ALA A  91      23.016  32.454   4.263  1.00  0.00           C  
ATOM   1260  C   ALA A  91      21.706  31.778   4.655  1.00  0.00           C  
ATOM   1261  O   ALA A  91      20.721  31.837   3.919  1.00  0.00           O  
ATOM   1262  CB  ALA A  91      22.852  33.966   4.260  1.00  0.00           C  
ATOM   1263  H   ALA A  91      23.214  32.491   2.157  1.00  0.00           H  
ATOM   1264  HA  ALA A  91      23.773  32.200   4.992  1.00  0.00           H  
ATOM   1265  HB1 ALA A  91      22.638  34.306   5.263  1.00  0.00           H  
ATOM   1266  HB2 ALA A  91      23.764  34.427   3.910  1.00  0.00           H  
ATOM   1267  HB3 ALA A  91      22.037  34.238   3.606  1.00  0.00           H  
ATOM   1268  N   LEU A  92      21.702  31.137   5.818  1.00  0.00           N  
ATOM   1269  CA  LEU A  92      20.513  30.449   6.309  1.00  0.00           C  
ATOM   1270  C   LEU A  92      20.117  30.961   7.690  1.00  0.00           C  
ATOM   1271  O   LEU A  92      20.893  30.874   8.642  1.00  0.00           O  
ATOM   1272  CB  LEU A  92      20.758  28.939   6.363  1.00  0.00           C  
ATOM   1273  CG  LEU A  92      21.318  28.305   5.090  1.00  0.00           C  
ATOM   1274  CD1 LEU A  92      21.673  26.845   5.332  1.00  0.00           C  
ATOM   1275  CD2 LEU A  92      20.321  28.431   3.948  1.00  0.00           C  
ATOM   1276  H   LEU A  92      22.517  31.125   6.361  1.00  0.00           H  
ATOM   1277  HA  LEU A  92      19.707  30.649   5.619  1.00  0.00           H  
ATOM   1278  HB2 LEU A  92      21.457  28.747   7.162  1.00  0.00           H  
ATOM   1279  HB3 LEU A  92      19.816  28.460   6.587  1.00  0.00           H  
ATOM   1280  HG  LEU A  92      22.222  28.824   4.803  1.00  0.00           H  
ATOM   1281 HD11 LEU A  92      22.398  26.779   6.128  1.00  0.00           H  
ATOM   1282 HD12 LEU A  92      22.088  26.421   4.430  1.00  0.00           H  
ATOM   1283 HD13 LEU A  92      20.782  26.300   5.610  1.00  0.00           H  
ATOM   1284 HD21 LEU A  92      19.569  27.660   4.041  1.00  0.00           H  
ATOM   1285 HD22 LEU A  92      20.837  28.318   3.005  1.00  0.00           H  
ATOM   1286 HD23 LEU A  92      19.848  29.401   3.987  1.00  0.00           H  
ATOM   1287  N   LEU A  93      18.905  31.493   7.792  1.00  0.00           N  
ATOM   1288  CA  LEU A  93      18.404  32.018   9.058  1.00  0.00           C  
ATOM   1289  C   LEU A  93      17.823  30.901   9.919  1.00  0.00           C  
ATOM   1290  O   LEU A  93      16.669  30.507   9.745  1.00  0.00           O  
ATOM   1291  CB  LEU A  93      17.342  33.089   8.804  1.00  0.00           C  
ATOM   1292  CG  LEU A  93      16.892  33.891  10.027  1.00  0.00           C  
ATOM   1293  CD1 LEU A  93      18.017  34.785  10.523  1.00  0.00           C  
ATOM   1294  CD2 LEU A  93      15.658  34.718   9.697  1.00  0.00           C  
ATOM   1295  H   LEU A  93      18.332  31.536   6.999  1.00  0.00           H  
ATOM   1296  HA  LEU A  93      19.235  32.466   9.583  1.00  0.00           H  
ATOM   1297  HB2 LEU A  93      17.739  33.785   8.081  1.00  0.00           H  
ATOM   1298  HB3 LEU A  93      16.472  32.599   8.390  1.00  0.00           H  
ATOM   1299  HG  LEU A  93      16.634  33.206  10.823  1.00  0.00           H  
ATOM   1300 HD11 LEU A  93      18.968  34.347  10.257  1.00  0.00           H  
ATOM   1301 HD12 LEU A  93      17.953  34.881  11.597  1.00  0.00           H  
ATOM   1302 HD13 LEU A  93      17.929  35.760  10.068  1.00  0.00           H  
ATOM   1303 HD21 LEU A  93      14.993  34.139   9.072  1.00  0.00           H  
ATOM   1304 HD22 LEU A  93      15.955  35.614   9.171  1.00  0.00           H  
ATOM   1305 HD23 LEU A  93      15.150  34.987  10.611  1.00  0.00           H  
ATOM   1306  N   LEU A  94      18.627  30.397  10.848  1.00  0.00           N  
ATOM   1307  CA  LEU A  94      18.191  29.327  11.738  1.00  0.00           C  
ATOM   1308  C   LEU A  94      17.675  29.893  13.057  1.00  0.00           C  
ATOM   1309  O   LEU A  94      18.215  30.867  13.579  1.00  0.00           O  
ATOM   1310  CB  LEU A  94      19.343  28.357  12.002  1.00  0.00           C  
ATOM   1311  CG  LEU A  94      19.921  27.651  10.774  1.00  0.00           C  
ATOM   1312  CD1 LEU A  94      21.190  26.897  11.141  1.00  0.00           C  
ATOM   1313  CD2 LEU A  94      18.893  26.706  10.168  1.00  0.00           C  
ATOM   1314  H   LEU A  94      19.535  30.753  10.938  1.00  0.00           H  
ATOM   1315  HA  LEU A  94      17.388  28.796  11.249  1.00  0.00           H  
ATOM   1316  HB2 LEU A  94      20.141  28.910  12.471  1.00  0.00           H  
ATOM   1317  HB3 LEU A  94      18.985  27.597  12.683  1.00  0.00           H  
ATOM   1318  HG  LEU A  94      20.177  28.391  10.029  1.00  0.00           H  
ATOM   1319 HD11 LEU A  94      22.042  27.391  10.699  1.00  0.00           H  
ATOM   1320 HD12 LEU A  94      21.127  25.885  10.768  1.00  0.00           H  
ATOM   1321 HD13 LEU A  94      21.301  26.879  12.215  1.00  0.00           H  
ATOM   1322 HD21 LEU A  94      18.860  25.795  10.745  1.00  0.00           H  
ATOM   1323 HD22 LEU A  94      19.171  26.478   9.150  1.00  0.00           H  
ATOM   1324 HD23 LEU A  94      17.921  27.177  10.181  1.00  0.00           H  
ATOM   1325  N   GLU A  95      16.628  29.272  13.593  1.00  0.00           N  
ATOM   1326  CA  GLU A  95      16.041  29.713  14.852  1.00  0.00           C  
ATOM   1327  C   GLU A  95      16.292  28.691  15.957  1.00  0.00           C  
ATOM   1328  O   GLU A  95      15.812  27.560  15.892  1.00  0.00           O  
ATOM   1329  CB  GLU A  95      14.537  29.941  14.687  1.00  0.00           C  
ATOM   1330  CG  GLU A  95      13.833  30.320  15.980  1.00  0.00           C  
ATOM   1331  CD  GLU A  95      14.172  31.724  16.439  1.00  0.00           C  
ATOM   1332  OE1 GLU A  95      15.222  31.896  17.093  1.00  0.00           O  
ATOM   1333  OE2 GLU A  95      13.389  32.651  16.145  1.00  0.00           O  
ATOM   1334  H   GLU A  95      16.242  28.499  13.129  1.00  0.00           H  
ATOM   1335  HA  GLU A  95      16.509  30.646  15.128  1.00  0.00           H  
ATOM   1336  HB2 GLU A  95      14.382  30.736  13.971  1.00  0.00           H  
ATOM   1337  HB3 GLU A  95      14.088  29.035  14.308  1.00  0.00           H  
ATOM   1338  HG2 GLU A  95      12.766  30.256  15.825  1.00  0.00           H  
ATOM   1339  HG3 GLU A  95      14.127  29.623  16.751  1.00  0.00           H  
ATOM   1340  N   ARG A  96      17.050  29.098  16.971  1.00  0.00           N  
ATOM   1341  CA  ARG A  96      17.368  28.219  18.089  1.00  0.00           C  
ATOM   1342  C   ARG A  96      16.329  28.354  19.198  1.00  0.00           C  
ATOM   1343  O   ARG A  96      16.292  29.359  19.907  1.00  0.00           O  
ATOM   1344  CB  ARG A  96      18.760  28.539  18.637  1.00  0.00           C  
ATOM   1345  CG  ARG A  96      19.192  27.624  19.771  1.00  0.00           C  
ATOM   1346  CD  ARG A  96      19.695  26.287  19.249  1.00  0.00           C  
ATOM   1347  NE  ARG A  96      20.883  26.439  18.413  1.00  0.00           N  
ATOM   1348  CZ  ARG A  96      22.081  26.753  18.890  1.00  0.00           C  
ATOM   1349  NH1 ARG A  96      22.251  26.949  20.190  1.00  0.00           N  
ATOM   1350  NH2 ARG A  96      23.115  26.872  18.065  1.00  0.00           N  
ATOM   1351  H   ARG A  96      17.404  30.013  16.965  1.00  0.00           H  
ATOM   1352  HA  ARG A  96      17.358  27.203  17.725  1.00  0.00           H  
ATOM   1353  HB2 ARG A  96      19.479  28.448  17.836  1.00  0.00           H  
ATOM   1354  HB3 ARG A  96      18.766  29.555  19.001  1.00  0.00           H  
ATOM   1355  HG2 ARG A  96      19.986  28.103  20.325  1.00  0.00           H  
ATOM   1356  HG3 ARG A  96      18.348  27.452  20.423  1.00  0.00           H  
ATOM   1357  HD2 ARG A  96      19.936  25.655  20.090  1.00  0.00           H  
ATOM   1358  HD3 ARG A  96      18.912  25.827  18.666  1.00  0.00           H  
ATOM   1359  HE  ARG A  96      20.780  26.298  17.449  1.00  0.00           H  
ATOM   1360 HH11 ARG A  96      21.475  26.858  20.814  1.00  0.00           H  
ATOM   1361 HH12 ARG A  96      23.155  27.185  20.546  1.00  0.00           H  
ATOM   1362 HH21 ARG A  96      22.991  26.726  17.085  1.00  0.00           H  
ATOM   1363 HH22 ARG A  96      24.017  27.109  18.425  1.00  0.00           H  
ATOM   1364  N   GLU A  97      15.487  27.335  19.341  1.00  0.00           N  
ATOM   1365  CA  GLU A  97      14.448  27.342  20.364  1.00  0.00           C  
ATOM   1366  C   GLU A  97      14.980  26.794  21.686  1.00  0.00           C  
ATOM   1367  O   GLU A  97      15.600  25.731  21.724  1.00  0.00           O  
ATOM   1368  CB  GLU A  97      13.245  26.516  19.904  1.00  0.00           C  
ATOM   1369  CG  GLU A  97      12.448  27.170  18.788  1.00  0.00           C  
ATOM   1370  CD  GLU A  97      11.503  26.202  18.103  1.00  0.00           C  
ATOM   1371  OE1 GLU A  97      11.924  25.560  17.117  1.00  0.00           O  
ATOM   1372  OE2 GLU A  97      10.343  26.087  18.550  1.00  0.00           O  
ATOM   1373  H   GLU A  97      15.567  26.562  18.745  1.00  0.00           H  
ATOM   1374  HA  GLU A  97      14.135  28.365  20.512  1.00  0.00           H  
ATOM   1375  HB2 GLU A  97      13.595  25.556  19.555  1.00  0.00           H  
ATOM   1376  HB3 GLU A  97      12.586  26.363  20.746  1.00  0.00           H  
ATOM   1377  HG2 GLU A  97      11.868  27.980  19.204  1.00  0.00           H  
ATOM   1378  HG3 GLU A  97      13.136  27.560  18.053  1.00  0.00           H  
ATOM   1379  N   ALA A  98      14.734  27.528  22.765  1.00  0.00           N  
ATOM   1380  CA  ALA A  98      15.187  27.116  24.089  1.00  0.00           C  
ATOM   1381  C   ALA A  98      14.334  25.974  24.629  1.00  0.00           C  
ATOM   1382  O   ALA A  98      13.317  26.201  25.284  1.00  0.00           O  
ATOM   1383  CB  ALA A  98      15.160  28.297  25.046  1.00  0.00           C  
ATOM   1384  H   ALA A  98      14.235  28.366  22.670  1.00  0.00           H  
ATOM   1385  HA  ALA A  98      16.210  26.778  24.001  1.00  0.00           H  
ATOM   1386  HB1 ALA A  98      14.393  28.139  25.790  1.00  0.00           H  
ATOM   1387  HB2 ALA A  98      16.120  28.387  25.533  1.00  0.00           H  
ATOM   1388  HB3 ALA A  98      14.949  29.202  24.497  1.00  0.00           H  
ATOM   1389  N   GLY A  99      14.754  24.743  24.351  1.00  0.00           N  
ATOM   1390  CA  GLY A  99      14.017  23.584  24.817  1.00  0.00           C  
ATOM   1391  C   GLY A  99      13.795  23.601  26.316  1.00  0.00           C  
ATOM   1392  O   GLY A  99      12.856  24.231  26.803  1.00  0.00           O  
ATOM   1393  H   GLY A  99      15.573  24.622  23.825  1.00  0.00           H  
ATOM   1394  HA2 GLY A  99      13.058  23.558  24.321  1.00  0.00           H  
ATOM   1395  HA3 GLY A  99      14.568  22.692  24.556  1.00  0.00           H  
ATOM   1396  N   SER A 100      14.659  22.908  27.049  1.00  0.00           N  
ATOM   1397  CA  SER A 100      14.549  22.842  28.501  1.00  0.00           C  
ATOM   1398  C   SER A 100      13.092  22.708  28.931  1.00  0.00           C  
ATOM   1399  O   SER A 100      12.655  23.341  29.892  1.00  0.00           O  
ATOM   1400  CB  SER A 100      15.168  24.088  29.137  1.00  0.00           C  
ATOM   1401  OG  SER A 100      14.291  25.198  29.044  1.00  0.00           O  
ATOM   1402  H   SER A 100      15.386  22.427  26.601  1.00  0.00           H  
ATOM   1403  HA  SER A 100      15.093  21.971  28.836  1.00  0.00           H  
ATOM   1404  HB2 SER A 100      15.373  23.894  30.180  1.00  0.00           H  
ATOM   1405  HB3 SER A 100      16.090  24.329  28.628  1.00  0.00           H  
ATOM   1406  HG  SER A 100      13.837  25.176  28.199  1.00  0.00           H  
ATOM   1407  N   GLY A 101      12.343  21.879  28.211  1.00  0.00           N  
ATOM   1408  CA  GLY A 101      10.942  21.676  28.531  1.00  0.00           C  
ATOM   1409  C   GLY A 101      10.669  20.290  29.082  1.00  0.00           C  
ATOM   1410  O   GLY A 101      10.249  19.384  28.362  1.00  0.00           O  
ATOM   1411  H   GLY A 101      12.745  21.400  27.455  1.00  0.00           H  
ATOM   1412  HA2 GLY A 101      10.642  22.410  29.264  1.00  0.00           H  
ATOM   1413  HA3 GLY A 101      10.356  21.816  27.635  1.00  0.00           H  
ATOM   1414  N   PRO A 102      10.909  20.111  30.390  1.00  0.00           N  
ATOM   1415  CA  PRO A 102      10.694  18.828  31.064  1.00  0.00           C  
ATOM   1416  C   PRO A 102       9.215  18.479  31.189  1.00  0.00           C  
ATOM   1417  O   PRO A 102       8.508  19.026  32.036  1.00  0.00           O  
ATOM   1418  CB  PRO A 102      11.311  19.048  32.449  1.00  0.00           C  
ATOM   1419  CG  PRO A 102      11.241  20.520  32.665  1.00  0.00           C  
ATOM   1420  CD  PRO A 102      11.411  21.147  31.308  1.00  0.00           C  
ATOM   1421  HA  PRO A 102      11.211  18.023  30.562  1.00  0.00           H  
ATOM   1422  HB2 PRO A 102      10.736  18.511  33.190  1.00  0.00           H  
ATOM   1423  HB3 PRO A 102      12.331  18.696  32.452  1.00  0.00           H  
ATOM   1424  HG2 PRO A 102      10.281  20.785  33.083  1.00  0.00           H  
ATOM   1425  HG3 PRO A 102      12.037  20.833  33.324  1.00  0.00           H  
ATOM   1426  HD2 PRO A 102      10.821  22.048  31.232  1.00  0.00           H  
ATOM   1427  HD3 PRO A 102      12.452  21.358  31.119  1.00  0.00           H  
ATOM   1428  N   SER A 103       8.753  17.566  30.341  1.00  0.00           N  
ATOM   1429  CA  SER A 103       7.355  17.148  30.355  1.00  0.00           C  
ATOM   1430  C   SER A 103       7.038  16.359  31.620  1.00  0.00           C  
ATOM   1431  O   SER A 103       6.147  16.726  32.386  1.00  0.00           O  
ATOM   1432  CB  SER A 103       7.043  16.301  29.119  1.00  0.00           C  
ATOM   1433  OG  SER A 103       6.942  17.109  27.959  1.00  0.00           O  
ATOM   1434  H   SER A 103       9.365  17.168  29.689  1.00  0.00           H  
ATOM   1435  HA  SER A 103       6.744  18.037  30.335  1.00  0.00           H  
ATOM   1436  HB2 SER A 103       7.832  15.579  28.972  1.00  0.00           H  
ATOM   1437  HB3 SER A 103       6.106  15.785  29.268  1.00  0.00           H  
ATOM   1438  HG  SER A 103       6.017  17.211  27.720  1.00  0.00           H  
ATOM   1439  N   SER A 104       7.774  15.272  31.834  1.00  0.00           N  
ATOM   1440  CA  SER A 104       7.569  14.428  33.004  1.00  0.00           C  
ATOM   1441  C   SER A 104       7.368  15.275  34.257  1.00  0.00           C  
ATOM   1442  O   SER A 104       6.313  15.231  34.887  1.00  0.00           O  
ATOM   1443  CB  SER A 104       8.759  13.487  33.195  1.00  0.00           C  
ATOM   1444  OG  SER A 104       8.640  12.750  34.401  1.00  0.00           O  
ATOM   1445  H   SER A 104       8.469  15.032  31.186  1.00  0.00           H  
ATOM   1446  HA  SER A 104       6.679  13.838  32.836  1.00  0.00           H  
ATOM   1447  HB2 SER A 104       8.806  12.795  32.368  1.00  0.00           H  
ATOM   1448  HB3 SER A 104       9.671  14.067  33.231  1.00  0.00           H  
ATOM   1449  HG  SER A 104       8.020  12.029  34.275  1.00  0.00           H  
ATOM   1450  N   GLY A 105       8.392  16.046  34.612  1.00  0.00           N  
ATOM   1451  CA  GLY A 105       8.310  16.893  35.788  1.00  0.00           C  
ATOM   1452  C   GLY A 105       7.531  18.167  35.532  1.00  0.00           C  
ATOM   1453  O   GLY A 105       6.494  18.146  34.870  1.00  0.00           O  
ATOM   1454  H   GLY A 105       9.210  16.039  34.071  1.00  0.00           H  
ATOM   1455  HA2 GLY A 105       7.828  16.341  36.581  1.00  0.00           H  
ATOM   1456  HA3 GLY A 105       9.310  17.152  36.101  1.00  0.00           H  
TER    1457      GLY A 105                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
