
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 (  706),  selected   95 , name 2v90_F
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 2v90_F.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      H       2           -
LGA    -       -      H       3           -
LGA    -       -      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    -       -      V      11           -
LGA    -       -      D      12           -
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    -       -      T      15           -
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    -       -      F      20           -
LGA    -       -      Q      21           -
LGA    M   245_F      S      22          1.017
LGA    K   246_F      M      23          0.913
LGA    P   247_F      P      24          0.533
LGA    R   248_F      R      25          0.664
LGA    C   249_F      S      26          1.145
LGA    L   250_F      I      27          1.304
LGA    H   251_F      R      28          1.090
LGA    L   252_F      F      29          0.916
LGA    E   253_F      T      30          1.615
LGA    K   254_F      A      31          1.834
LGA    G   255_F      E      32          0.979
LGA    P   256_F      E      33          2.708
LGA    Q   257_F      G      34          6.413
LGA    G   258_F      D      35          1.535
LGA    F   259_F      L      36          2.258
LGA    G   260_F      G      37          1.271
LGA    F   261_F      F      38          0.961
LGA    L   262_F      T      39          0.814
LGA    L   263_F      L      40          0.626
LGA    R   264_F      R      41          0.892
LGA    E   265_F      G      42          1.302
LGA    E   266_F      -       -           -
LGA    K   267_F      -       -           -
LGA    G   268_F      -       -           -
LGA    L   269_F      -       -           -
LGA    D   270_F      -       -           -
LGA    G   271_F      -       -           -
LGA    R   272_F      N      43           #
LGA    P   273_F      A      44          2.914
LGA    G   274_F      P      45          2.181
LGA    Q   275_F      V      46          0.383
LGA    F   276_F      Q      47          0.352
LGA    L   277_F      V      48          0.487
LGA    W   278_F      H      49          1.129
LGA    E   279_F      F      50          2.022
LGA    V   280_F      L      51          1.283
LGA    D   281_F      D      52          0.819
LGA    P   282_F      P      53          0.987
LGA    G   283_F      Y      54          0.646
LGA    L   284_F      C      55          0.691
LGA    P   285_F      S      56          1.185
LGA    A   286_F      A      57          0.909
LGA    K   287_F      S      58          0.523
LGA    K   288_F      V      59          0.631
LGA    A   289_F      A      60          0.541
LGA    G   290_F      G      61          0.452
LGA    M   291_F      A      62          0.376
LGA    Q   292_F      R      63          0.353
LGA    A   293_F      E      64          0.276
LGA    G   294_F      G      65          0.840
LGA    D   295_F      D      66          0.220
LGA    R   296_F      Y      67          0.120
LGA    L   297_F      I      68          0.631
LGA    V   298_F      V      69          0.612
LGA    A   299_F      S      70          0.620
LGA    V   300_F      I      71          1.147
LGA    A   301_F      Q      72          2.317
LGA    G   302_F      L      73          2.045
LGA    E   303_F      V      74          1.176
LGA    S   304_F      D      75          0.849
LGA    V   305_F      C      76          0.452
LGA    E   306_F      K      77          0.111
LGA    G   307_F      W      78          1.552
LGA    L   308_F      L      79          0.838
LGA    G   309_F      T      80          1.190
LGA    H   310_F      L      81          1.592
LGA    E   311_F      S      82          1.327
LGA    E   312_F      E      83          1.360
LGA    T   313_F      V      84          1.233
LGA    V   314_F      M      85          1.096
LGA    S   315_F      K      86          1.037
LGA    R   316_F      L      87          1.082
LGA    I   317_F      L      88          1.068
LGA    Q   318_F      K      89          1.283
LGA    G   319_F      S      90          1.536
LGA    Q   320_F      F      91          1.980
LGA    G   321_F      G      92          2.008
LGA    S   322_F      E      93          1.406
LGA    C   323_F      D      94          2.341
LGA    -       -      E      95           -
LGA    V   324_F      I      96          1.001
LGA    S   325_F      E      97          0.976
LGA    L   326_F      M      98          0.940
LGA    T   327_F      K      99          0.769
LGA    V   328_F      V     100          0.450
LGA    V   329_F      V     101          0.425
LGA    D   330_F      S     102          1.340
LGA    P   331_F      L     103          3.544
LGA    E   332_F      L     104           -
LGA    A   333_F      -       -           -
LGA    D   334_F      -       -           -
LGA    R   335_F      -       -           -
LGA    E   336_F      -       -           -
LGA    T   337_F      -       -           -
LGA    S   338_F      -       -           -
LGA    V   339_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95  104    5.0     80    1.47    23.75     73.271     5.093

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.350589 * X  +   0.014828 * Y  +  -0.936412 * Z  +  49.926075
  Y_new =  -0.450840 * X  +   0.873722 * Y  +   0.182627 * Z  +  -1.189997
  Z_new =   0.820872 * X  +   0.486199 * Y  +  -0.299632 * Z  + -22.851276 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.123097   -1.018496  [ DEG:   121.6445    -58.3555 ]
  Theta =  -0.962937   -2.178656  [ DEG:   -55.1722   -124.8278 ]
  Phi   =  -2.231750    0.909842  [ DEG:  -127.8699     52.1301 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2v90_F                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2v90_F.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95  104   5.0   80   1.47   23.75  73.271
REMARK  ---------------------------------------------------------- 
MOLECULE 2v90_F
HEADER    PROTEIN-BINDING                         16-AUG-07   2V90              
TITLE     CRYSTAL STRUCTURE OF THE 3RD PDZ DOMAIN OF INTESTINE- AND             
TITLE    2 KIDNEY-ENRICHED PDZ DOMAIN IKEPP (PDZD3)                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PDZ DOMAIN-CONTAINING PROTEIN 3;                           
COMPND   3 SYNONYM: PDZ DOMAIN-CONTAINING PROTEIN 2, INTESTINAL                 
COMPND   4  AND KIDNEY-ENRICHED PDZ PROTEIN, INTESTINE- AND                     
COMPND   5  KIDNEY-ENRICHED PDZ DOMAIN IKEPP;                                   
COMPND   6 CHAIN: A, B, C, D, E, F;                                             
COMPND   7 FRAGMENT: PDZ DOMAIN, RESIDUES 246-335;                              
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   4 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   5 EXPRESSION_SYSTEM_PLASMID: PNIC-BSA4;                                
SOURCE   6 EXPRESSION_SYSTEM_CELL_LINE: DE3-R3;                                 
SOURCE   7 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   8 ORGANISM_COMMON: HUMAN                                               
KEYWDS    ALTERNATIVE SPLICING,                                                 
KEYWDS   2 PDZD3, MEMBRANE, CYTOPLASM, PDZ DOMAIN, PROTEIN-BINDING              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.UPPENBERG,C.GILEADI,C.PHILLIPS,J.ELKINS,G.BUNKOCZI,                 
AUTHOR   2 C.COOPER,A.C.W.PIKE,E.SALAH,E.UGOCHUKWU,C.H.ARROWSMITH,              
AUTHOR   3 A.EDWARDS,M.SUNDSTROM,J.WEIGELT,D.A.DOYLE                            
REVDAT   1   28-AUG-07 2V90    0                                                
JRNL        AUTH   J.UPPENBERG,C.GILEADI,C.PHILLIPS,J.ELKINS,                   
JRNL        AUTH 2 G.BUNKOCZI,C.COOPER,A.C.W.PIKE,E.SALAH,E.UGOCHUKWU,          
JRNL        AUTH 3 C.H.ARROWSMITH,A.EDWARDS,M.SUNDSTROM,J.WEIGELT,              
JRNL        AUTH 4 D.A.DOYLE                                                    
JRNL        TITL   CRYSTAL STRUCTURE OF THE 3RD PDZ DOMAIN OF                   
JRNL        TITL 2 INTESTINE- AND KIDNEY-ENRICHED PDZ DOMAIN IKEPP (            
JRNL        TITL 3 PDZD3)                                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.0  ANGSTROMS.                                          
DBREF  2V90 A  244   245  PDB    2V90     2V90           244    245             
DBREF  2V90 A  246   335  UNP    Q86UT5   PDZD3_HUMAN    246    335             
DBREF  2V90 A  336   339  PDB    2V90     2V90           336    339             
DBREF  2V90 B  244   245  PDB    2V90     2V90           244    245             
DBREF  2V90 B  246   335  UNP    Q86UT5   PDZD3_HUMAN    246    335             
DBREF  2V90 B  336   339  PDB    2V90     2V90           336    339             
DBREF  2V90 C  244   245  PDB    2V90     2V90           244    245             
DBREF  2V90 C  246   335  UNP    Q86UT5   PDZD3_HUMAN    246    335             
DBREF  2V90 C  336   339  PDB    2V90     2V90           336    339             
DBREF  2V90 D  244   245  PDB    2V90     2V90           244    245             
DBREF  2V90 D  246   335  UNP    Q86UT5   PDZD3_HUMAN    246    335             
DBREF  2V90 D  336   339  PDB    2V90     2V90           336    339             
DBREF  2V90 E  244   245  PDB    2V90     2V90           244    245             
DBREF  2V90 E  246   335  UNP    Q86UT5   PDZD3_HUMAN    246    335             
DBREF  2V90 E  336   339  PDB    2V90     2V90           336    339             
DBREF  2V90 F  244   245  PDB    2V90     2V90           244    245             
DBREF  2V90 F  246   335  UNP    Q86UT5   PDZD3_HUMAN    246    335             
DBREF  2V90 F  336   339  PDB    2V90     2V90           336    339             
SEQRES   1 A   96  SER MET LYS PRO ARG CYS LEU HIS LEU GLU LYS GLY PRO          
SEQRES   2 A   96  GLN GLY PHE GLY PHE LEU LEU ARG GLU GLU LYS GLY LEU          
SEQRES   3 A   96  ASP GLY ARG PRO GLY GLN PHE LEU TRP GLU VAL ASP PRO          
SEQRES   4 A   96  GLY LEU PRO ALA LYS LYS ALA GLY MET GLN ALA GLY ASP          
SEQRES   5 A   96  ARG LEU VAL ALA VAL ALA GLY GLU SER VAL GLU GLY LEU          
SEQRES   6 A   96  GLY HIS GLU GLU THR VAL SER ARG ILE GLN GLY GLN GLY          
SEQRES   7 A   96  SER CYS VAL SER LEU THR VAL VAL ASP PRO GLU ALA ASP          
SEQRES   8 A   96  ARG GLU THR SER VAL                                          
SEQRES   1 B   96  SER MET LYS PRO ARG CYS LEU HIS LEU GLU LYS GLY PRO          
SEQRES   2 B   96  GLN GLY PHE GLY PHE LEU LEU ARG GLU GLU LYS GLY LEU          
SEQRES   3 B   96  ASP GLY ARG PRO GLY GLN PHE LEU TRP GLU VAL ASP PRO          
SEQRES   4 B   96  GLY LEU PRO ALA LYS LYS ALA GLY MET GLN ALA GLY ASP          
SEQRES   5 B   96  ARG LEU VAL ALA VAL ALA GLY GLU SER VAL GLU GLY LEU          
SEQRES   6 B   96  GLY HIS GLU GLU THR VAL SER ARG ILE GLN GLY GLN GLY          
SEQRES   7 B   96  SER CYS VAL SER LEU THR VAL VAL ASP PRO GLU ALA ASP          
SEQRES   8 B   96  ARG GLU THR SER VAL                                          
SEQRES   1 C   96  SER MET LYS PRO ARG CYS LEU HIS LEU GLU LYS GLY PRO          
SEQRES   2 C   96  GLN GLY PHE GLY PHE LEU LEU ARG GLU GLU LYS GLY LEU          
SEQRES   3 C   96  ASP GLY ARG PRO GLY GLN PHE LEU TRP GLU VAL ASP PRO          
SEQRES   4 C   96  GLY LEU PRO ALA LYS LYS ALA GLY MET GLN ALA GLY ASP          
SEQRES   5 C   96  ARG LEU VAL ALA VAL ALA GLY GLU SER VAL GLU GLY LEU          
SEQRES   6 C   96  GLY HIS GLU GLU THR VAL SER ARG ILE GLN GLY GLN GLY          
SEQRES   7 C   96  SER CYS VAL SER LEU THR VAL VAL ASP PRO GLU ALA ASP          
SEQRES   8 C   96  ARG GLU THR SER VAL                                          
SEQRES   1 D   96  SER MET LYS PRO ARG CYS LEU HIS LEU GLU LYS GLY PRO          
SEQRES   2 D   96  GLN GLY PHE GLY PHE LEU LEU ARG GLU GLU LYS GLY LEU          
SEQRES   3 D   96  ASP GLY ARG PRO GLY GLN PHE LEU TRP GLU VAL ASP PRO          
SEQRES   4 D   96  GLY LEU PRO ALA LYS LYS ALA GLY MET GLN ALA GLY ASP          
SEQRES   5 D   96  ARG LEU VAL ALA VAL ALA GLY GLU SER VAL GLU GLY LEU          
SEQRES   6 D   96  GLY HIS GLU GLU THR VAL SER ARG ILE GLN GLY GLN GLY          
SEQRES   7 D   96  SER CYS VAL SER LEU THR VAL VAL ASP PRO GLU ALA ASP          
SEQRES   8 D   96  ARG GLU THR SER VAL                                          
SEQRES   1 E   96  SER MET LYS PRO ARG CYS LEU HIS LEU GLU LYS GLY PRO          
SEQRES   2 E   96  GLN GLY PHE GLY PHE LEU LEU ARG GLU GLU LYS GLY LEU          
SEQRES   3 E   96  ASP GLY ARG PRO GLY GLN PHE LEU TRP GLU VAL ASP PRO          
SEQRES   4 E   96  GLY LEU PRO ALA LYS LYS ALA GLY MET GLN ALA GLY ASP          
SEQRES   5 E   96  ARG LEU VAL ALA VAL ALA GLY GLU SER VAL GLU GLY LEU          
SEQRES   6 E   96  GLY HIS GLU GLU THR VAL SER ARG ILE GLN GLY GLN GLY          
SEQRES   7 E   96  SER CYS VAL SER LEU THR VAL VAL ASP PRO GLU ALA ASP          
SEQRES   8 E   96  ARG GLU THR SER VAL                                          
SEQRES   1 F   96  SER MET LYS PRO ARG CYS LEU HIS LEU GLU LYS GLY PRO          
SEQRES   2 F   96  GLN GLY PHE GLY PHE LEU LEU ARG GLU GLU LYS GLY LEU          
SEQRES   3 F   96  ASP GLY ARG PRO GLY GLN PHE LEU TRP GLU VAL ASP PRO          
SEQRES   4 F   96  GLY LEU PRO ALA LYS LYS ALA GLY MET GLN ALA GLY ASP          
SEQRES   5 F   96  ARG LEU VAL ALA VAL ALA GLY GLU SER VAL GLU GLY LEU          
SEQRES   6 F   96  GLY HIS GLU GLU THR VAL SER ARG ILE GLN GLY GLN GLY          
SEQRES   7 F   96  SER CYS VAL SER LEU THR VAL VAL ASP PRO GLU ALA ASP          
SEQRES   8 F   96  ARG GLU THR SER VAL                                          
HET    SO4  A1340       5                                                       
HET    SO4  B1340       5                                                       
HET    SO4  B1341       5                                                       
HETNAM     SO4 SULFATE ION                                                      
FORMUL   7  SO4    3(O4 S 2-)                                                   
FORMUL   8  HOH   *388(H2 O1)                                                   
CRYST1   48.150   97.950   59.500  90.00  99.59  90.00 P 1 21 1     12          
ATOM   3535  N   MET F 245      13.455  30.113  19.684  1.00 56.89           N  
ATOM   3536  CA  MET F 245      14.869  30.597  19.606  1.00 54.92           C  
ATOM   3537  C   MET F 245      15.027  31.758  18.613  1.00 54.10           C  
ATOM   3538  O   MET F 245      14.212  31.929  17.697  1.00 54.95           O  
ATOM   3539  CB  MET F 245      15.800  29.442  19.221  1.00 53.95           C  
ATOM   3540  N   LYS F 246      16.070  32.564  18.816  1.00 52.42           N  
ATOM   3541  CA  LYS F 246      16.401  33.660  17.904  1.00 47.36           C  
ATOM   3542  C   LYS F 246      16.978  33.069  16.623  1.00 40.84           C  
ATOM   3543  O   LYS F 246      17.798  32.154  16.697  1.00 43.63           O  
ATOM   3544  CB  LYS F 246      17.440  34.595  18.527  1.00 47.00           C  
ATOM   3545  CG  LYS F 246      16.976  35.299  19.786  1.00 53.74           C  
ATOM   3546  N   PRO F 247      16.554  33.577  15.446  1.00 31.63           N  
ATOM   3547  CA  PRO F 247      17.187  33.147  14.181  1.00 27.62           C  
ATOM   3548  C   PRO F 247      18.703  33.384  14.177  1.00 25.92           C  
ATOM   3549  O   PRO F 247      19.178  34.357  14.767  1.00 25.32           O  
ATOM   3550  CB  PRO F 247      16.522  34.036  13.118  1.00 26.53           C  
ATOM   3551  CG  PRO F 247      15.258  34.557  13.735  1.00 25.61           C  
ATOM   3552  CD  PRO F 247      15.464  34.548  15.231  1.00 31.09           C  
ATOM   3553  N   ARG F 248      19.444  32.492  13.527  1.00 23.16           N  
ATOM   3554  CA  ARG F 248      20.884  32.645  13.340  1.00 24.85           C  
ATOM   3555  C   ARG F 248      21.172  32.577  11.847  1.00 21.26           C  
ATOM   3556  O   ARG F 248      20.874  31.559  11.228  1.00 16.26           O  
ATOM   3557  CB  ARG F 248      21.653  31.523  14.055  1.00 24.15           C  
ATOM   3558  CG  ARG F 248      21.406  31.442  15.552  1.00 32.72           C  
ATOM   3559  CD  ARG F 248      21.871  30.107  16.126  1.00 37.17           C  
ATOM   3560  NE  ARG F 248      23.209  29.748  15.653  1.00 40.18           N  
ATOM   3561  CZ  ARG F 248      23.554  28.588  15.078  1.00 36.83           C  
ATOM   3562  NH1 ARG F 248      22.673  27.598  14.920  1.00 31.83           N  
ATOM   3563  NH2 ARG F 248      24.816  28.408  14.670  1.00 35.50           N  
ATOM   3564  N   CYS F 249      21.737  33.658  11.297  1.00 20.67           N  
ATOM   3565  CA  CYS F 249      22.171  33.734   9.890  1.00 22.92           C  
ATOM   3566  C   CYS F 249      23.640  33.323   9.774  1.00 23.13           C  
ATOM   3567  O   CYS F 249      24.521  33.970  10.323  1.00 26.10           O  
ATOM   3568  CB  CYS F 249      22.007  35.144   9.314  1.00 21.65           C  
ATOM   3569  SG  CYS F 249      22.515  35.261   7.553  1.00 27.53           S  
ATOM   3570  N   LEU F 250      23.880  32.244   9.046  1.00 21.40           N  
ATOM   3571  CA  LEU F 250      25.202  31.673   8.911  1.00 22.53           C  
ATOM   3572  C   LEU F 250      25.604  31.724   7.427  1.00 21.80           C  
ATOM   3573  O   LEU F 250      24.754  31.708   6.535  1.00 22.49           O  
ATOM   3574  CB  LEU F 250      25.165  30.240   9.454  1.00 25.21           C  
ATOM   3575  CG  LEU F 250      24.793  30.142  10.952  1.00 29.98           C  
ATOM   3576  CD1 LEU F 250      24.250  28.773  11.337  1.00 28.61           C  
ATOM   3577  CD2 LEU F 250      25.955  30.513  11.857  1.00 27.86           C  
ATOM   3578  N   HIS F 251      26.899  31.830   7.163  1.00 23.19           N  
ATOM   3579  CA  HIS F 251      27.392  31.903   5.783  1.00 21.96           C  
ATOM   3580  C   HIS F 251      28.207  30.665   5.435  1.00 22.11           C  
ATOM   3581  O   HIS F 251      29.206  30.365   6.108  1.00 19.34           O  
ATOM   3582  CB  HIS F 251      28.201  33.184   5.606  1.00 25.67           C  
ATOM   3583  CG  HIS F 251      27.404  34.418   5.897  1.00 33.80           C  
ATOM   3584  ND1 HIS F 251      27.194  34.884   7.178  1.00 36.26           N  
ATOM   3585  CD2 HIS F 251      26.712  35.247   5.076  1.00 50.18           C  
ATOM   3586  CE1 HIS F 251      26.435  35.966   7.131  1.00 41.38           C  
ATOM   3587  NE2 HIS F 251      26.132  36.208   5.869  1.00 43.17           N  
ATOM   3588  N   LEU F 252      27.776  29.935   4.406  1.00 17.52           N  
ATOM   3589  CA  LEU F 252      28.442  28.687   4.050  1.00 18.24           C  
ATOM   3590  C   LEU F 252      29.166  28.812   2.735  1.00 17.19           C  
ATOM   3591  O   LEU F 252      28.690  29.483   1.814  1.00 18.21           O  
ATOM   3592  CB  LEU F 252      27.441  27.531   3.963  1.00 14.34           C  
ATOM   3593  CG  LEU F 252      26.572  27.293   5.213  1.00 20.53           C  
ATOM   3594  CD1 LEU F 252      25.693  26.065   4.992  1.00 20.99           C  
ATOM   3595  CD2 LEU F 252      27.403  27.145   6.481  1.00 18.13           C  
ATOM   3596  N   GLU F 253      30.314  28.151   2.659  1.00 16.61           N  
ATOM   3597  CA  GLU F 253      30.985  27.888   1.395  1.00 19.81           C  
ATOM   3598  C   GLU F 253      30.988  26.401   1.217  1.00 21.20           C  
ATOM   3599  O   GLU F 253      31.438  25.671   2.102  1.00 20.54           O  
ATOM   3600  CB  GLU F 253      32.422  28.387   1.428  1.00 20.07           C  
ATOM   3601  CG  GLU F 253      32.558  29.900   1.465  1.00 33.08           C  
ATOM   3602  CD  GLU F 253      33.107  30.418   2.787  1.00 51.36           C  
ATOM   3603  OE1 GLU F 253      32.393  30.334   3.820  1.00 47.02           O  
ATOM   3604  OE2 GLU F 253      34.259  30.911   2.786  1.00 49.28           O  
ATOM   3605  N   LYS F 254      30.500  25.920   0.084  1.00 21.73           N  
ATOM   3606  CA  LYS F 254      30.513  24.494  -0.117  1.00 21.21           C  
ATOM   3607  C   LYS F 254      31.801  24.086  -0.782  1.00 23.27           C  
ATOM   3608  O   LYS F 254      32.434  24.866  -1.494  1.00 21.99           O  
ATOM   3609  CB  LYS F 254      29.280  24.003  -0.865  1.00 22.48           C  
ATOM   3610  CG  LYS F 254      29.246  24.118  -2.340  1.00 20.41           C  
ATOM   3611  CD  LYS F 254      27.821  23.865  -2.856  1.00 28.66           C  
ATOM   3612  CE  LYS F 254      27.766  23.683  -4.371  1.00 28.15           C  
ATOM   3613  NZ  LYS F 254      26.621  24.412  -4.977  1.00 27.98           N  
ATOM   3614  N   GLY F 255      32.208  22.872  -0.466  1.00 22.36           N  
ATOM   3615  CA  GLY F 255      33.259  22.176  -1.178  1.00 22.89           C  
ATOM   3616  C   GLY F 255      32.664  21.003  -1.939  1.00 23.49           C  
ATOM   3617  O   GLY F 255      31.458  20.974  -2.193  1.00 23.18           O  
ATOM   3618  N   PRO F 256      33.499  20.000  -2.273  1.00 30.20           N  
ATOM   3619  CA  PRO F 256      33.071  18.922  -3.184  1.00 30.83           C  
ATOM   3620  C   PRO F 256      31.984  18.026  -2.599  1.00 31.41           C  
ATOM   3621  O   PRO F 256      31.350  17.269  -3.328  1.00 38.49           O  
ATOM   3622  CB  PRO F 256      34.358  18.127  -3.423  1.00 34.44           C  
ATOM   3623  CG  PRO F 256      35.265  18.467  -2.277  1.00 33.88           C  
ATOM   3624  CD  PRO F 256      34.875  19.819  -1.777  1.00 30.25           C  
ATOM   3625  N   GLN F 257      31.760  18.135  -1.295  1.00 27.46           N  
ATOM   3626  CA  GLN F 257      30.819  17.288  -0.583  1.00 27.74           C  
ATOM   3627  C   GLN F 257      29.501  18.038  -0.270  1.00 26.23           C  
ATOM   3628  O   GLN F 257      28.561  17.448   0.249  1.00 22.77           O  
ATOM   3629  CB  GLN F 257      31.513  16.753   0.685  1.00 29.69           C  
ATOM   3630  CG  GLN F 257      32.977  16.318   0.406  1.00 25.13           C  
ATOM   3631  CD  GLN F 257      33.905  16.284   1.619  1.00 40.10           C  
ATOM   3632  OE1 GLN F 257      33.758  15.436   2.518  1.00 40.20           O  
ATOM   3633  NE2 GLN F 257      34.921  17.165   1.609  1.00 28.77           N  
ATOM   3634  N   GLY F 258      29.442  19.325  -0.635  1.00 23.26           N  
ATOM   3635  CA  GLY F 258      28.241  20.150  -0.489  1.00 21.55           C  
ATOM   3636  C   GLY F 258      28.211  20.880   0.832  1.00 20.79           C  
ATOM   3637  O   GLY F 258      29.214  20.974   1.519  1.00 23.74           O  
ATOM   3638  N   PHE F 259      27.044  21.379   1.202  1.00 17.55           N  
ATOM   3639  CA  PHE F 259      26.879  22.143   2.438  1.00 16.87           C  
ATOM   3640  C   PHE F 259      26.811  21.268   3.699  1.00 17.00           C  
ATOM   3641  O   PHE F 259      27.159  21.748   4.775  1.00 16.67           O  
ATOM   3642  CB  PHE F 259      25.663  23.076   2.342  1.00 19.16           C  
ATOM   3643  CG  PHE F 259      25.802  24.122   1.268  1.00 16.79           C  
ATOM   3644  CD1 PHE F 259      26.814  25.074   1.346  1.00 18.02           C  
ATOM   3645  CD2 PHE F 259      24.965  24.127   0.162  1.00 20.62           C  
ATOM   3646  CE1 PHE F 259      26.978  26.019   0.346  1.00 16.33           C  
ATOM   3647  CE2 PHE F 259      25.113  25.092  -0.832  1.00 19.75           C  
ATOM   3648  CZ  PHE F 259      26.127  26.029  -0.746  1.00 19.01           C  
ATOM   3649  N   GLY F 260      26.369  20.012   3.561  1.00 12.99           N  
ATOM   3650  CA  GLY F 260      26.332  19.076   4.678  1.00 17.68           C  
ATOM   3651  C   GLY F 260      25.061  18.965   5.489  1.00 15.89           C  
ATOM   3652  O   GLY F 260      25.093  18.873   6.729  1.00 19.82           O  
ATOM   3653  N   PHE F 261      23.923  18.947   4.820  1.00 14.90           N  
ATOM   3654  CA  PHE F 261      22.675  18.737   5.537  1.00 17.44           C  
ATOM   3655  C   PHE F 261      21.624  18.087   4.662  1.00 15.93           C  
ATOM   3656  O   PHE F 261      21.638  18.228   3.452  1.00 14.32           O  
ATOM   3657  CB  PHE F 261      22.156  20.032   6.226  1.00 16.92           C  
ATOM   3658  CG  PHE F 261      21.776  21.154   5.284  1.00 17.14           C  
ATOM   3659  CD1 PHE F 261      20.480  21.254   4.762  1.00 16.36           C  
ATOM   3660  CD2 PHE F 261      22.704  22.154   4.969  1.00 17.01           C  
ATOM   3661  CE1 PHE F 261      20.125  22.304   3.917  1.00 20.89           C  
ATOM   3662  CE2 PHE F 261      22.367  23.198   4.120  1.00 22.76           C  
ATOM   3663  CZ  PHE F 261      21.063  23.277   3.590  1.00 19.71           C  
ATOM   3664  N   LEU F 262      20.753  17.330   5.312  1.00 14.52           N  
ATOM   3665  CA  LEU F 262      19.552  16.801   4.709  1.00 17.36           C  
ATOM   3666  C   LEU F 262      18.384  17.719   5.072  1.00 13.61           C  
ATOM   3667  O   LEU F 262      18.099  17.918   6.248  1.00 15.39           O  
ATOM   3668  CB  LEU F 262      19.309  15.387   5.239  1.00 18.04           C  
ATOM   3669  CG  LEU F 262      18.051  14.653   4.763  1.00 13.36           C  
ATOM   3670  CD1 LEU F 262      18.154  14.280   3.331  1.00 12.61           C  
ATOM   3671  CD2 LEU F 262      17.887  13.436   5.612  1.00 14.49           C  
ATOM   3672  N   LEU F 263      17.735  18.268   4.044  1.00 11.14           N  
ATOM   3673  CA  LEU F 263      16.536  19.089   4.170  1.00 14.64           C  
ATOM   3674  C   LEU F 263      15.322  18.237   3.829  1.00 11.25           C  
ATOM   3675  O   LEU F 263      15.276  17.623   2.788  1.00 13.13           O  
ATOM   3676  CB  LEU F 263      16.579  20.267   3.188  1.00 12.92           C  
ATOM   3677  CG  LEU F 263      15.544  21.374   3.372  1.00 11.46           C  
ATOM   3678  CD1 LEU F 263      15.860  22.157   4.661  1.00 12.17           C  
ATOM   3679  CD2 LEU F 263      15.530  22.265   2.151  1.00 14.35           C  
ATOM   3680  N   ARG F 264      14.358  18.211   4.735  1.00 10.46           N  
ATOM   3681  CA  ARG F 264      13.158  17.454   4.561  1.00 12.78           C  
ATOM   3682  C   ARG F 264      11.932  18.289   4.917  1.00 11.37           C  
ATOM   3683  O   ARG F 264      11.910  18.963   5.940  1.00 14.71           O  
ATOM   3684  CB  ARG F 264      13.208  16.217   5.453  1.00 11.27           C  
ATOM   3685  CG  ARG F 264      11.920  15.421   5.368  1.00 21.60           C  
ATOM   3686  CD  ARG F 264      11.718  14.519   6.507  1.00 26.02           C  
ATOM   3687  NE  ARG F 264      12.480  13.302   6.350  1.00 35.61           N  
ATOM   3688  CZ  ARG F 264      12.085  12.249   5.641  1.00 49.61           C  
ATOM   3689  NH1 ARG F 264      10.924  12.259   4.988  1.00 55.91           N  
ATOM   3690  NH2 ARG F 264      12.864  11.179   5.584  1.00 45.39           N  
ATOM   3691  N   GLU F 265      10.897  18.214   4.090  1.00 11.36           N  
ATOM   3692  CA  GLU F 265       9.692  19.016   4.332  1.00 14.86           C  
ATOM   3693  C   GLU F 265       8.789  18.292   5.297  1.00 13.90           C  
ATOM   3694  O   GLU F 265       8.637  17.043   5.225  1.00 15.23           O  
ATOM   3695  CB  GLU F 265       8.949  19.250   3.030  1.00 10.64           C  
ATOM   3696  CG  GLU F 265       7.627  19.978   3.182  1.00 10.22           C  
ATOM   3697  CD  GLU F 265       6.997  20.243   1.856  1.00 18.37           C  
ATOM   3698  OE1 GLU F 265       7.589  21.027   1.098  1.00 19.63           O  
ATOM   3699  OE2 GLU F 265       5.904  19.675   1.569  1.00 22.62           O  
ATOM   3700  N   GLU F 266       8.224  19.044   6.223  1.00 12.82           N  
ATOM   3701  CA  GLU F 266       7.099  18.544   7.028  1.00 16.30           C  
ATOM   3702  C   GLU F 266       6.044  19.610   7.091  1.00 13.67           C  
ATOM   3703  O   GLU F 266       6.327  20.750   7.490  1.00 18.05           O  
ATOM   3704  CB  GLU F 266       7.525  18.155   8.447  1.00 15.45           C  
ATOM   3705  CG  GLU F 266       8.355  16.863   8.585  1.00 18.00           C  
ATOM   3706  CD  GLU F 266       7.587  15.580   8.257  1.00 19.93           C  
ATOM   3707  OE1 GLU F 266       6.350  15.618   8.118  1.00 17.07           O  
ATOM   3708  OE2 GLU F 266       8.238  14.531   8.097  1.00 25.41           O  
ATOM   3709  N   LYS F 267       4.815  19.245   6.735  1.00 15.96           N  
ATOM   3710  CA  LYS F 267       3.683  20.152   6.859  1.00 19.00           C  
ATOM   3711  C   LYS F 267       3.271  20.279   8.302  1.00 19.70           C  
ATOM   3712  O   LYS F 267       3.277  19.291   9.049  1.00 16.92           O  
ATOM   3713  CB  LYS F 267       2.498  19.664   6.043  1.00 17.53           C  
ATOM   3714  CG  LYS F 267       2.678  19.848   4.554  1.00 21.85           C  
ATOM   3715  CD  LYS F 267       1.613  19.081   3.778  1.00 30.11           C  
ATOM   3716  CE  LYS F 267       1.617  19.425   2.293  1.00 35.25           C  
ATOM   3717  NZ  LYS F 267       0.396  20.196   1.903  1.00 40.07           N  
ATOM   3718  N   GLY F 268       2.894  21.502   8.690  1.00 15.77           N  
ATOM   3719  CA  GLY F 268       2.488  21.745  10.052  1.00 19.11           C  
ATOM   3720  C   GLY F 268       1.043  21.356  10.190  1.00 18.70           C  
ATOM   3721  O   GLY F 268       0.414  20.903   9.222  1.00 15.57           O  
ATOM   3722  N   LEU F 269       0.512  21.557  11.398  1.00 21.08           N  
ATOM   3723  CA  LEU F 269      -0.883  21.233  11.683  1.00 23.80           C  
ATOM   3724  C   LEU F 269      -1.798  22.109  10.829  1.00 18.89           C  
ATOM   3725  O   LEU F 269      -2.849  21.663  10.409  1.00 16.00           O  
ATOM   3726  CB  LEU F 269      -1.218  21.391  13.165  1.00 19.49           C  
ATOM   3727  CG  LEU F 269      -1.035  20.176  14.077  1.00 40.09           C  
ATOM   3728  CD1 LEU F 269      -1.001  20.620  15.536  1.00 50.86           C  
ATOM   3729  CD2 LEU F 269      -2.167  19.185  13.837  1.00 46.39           C  
ATOM   3730  N   ASP F 270      -1.369  23.340  10.563  1.00 14.22           N  
ATOM   3731  CA  ASP F 270      -2.149  24.268   9.727  1.00 13.31           C  
ATOM   3732  C   ASP F 270      -2.028  23.994   8.230  1.00  4.88           C  
ATOM   3733  O   ASP F 270      -2.654  24.664   7.417  1.00 12.72           O  
ATOM   3734  CB  ASP F 270      -1.774  25.725  10.038  1.00 14.28           C  
ATOM   3735  CG  ASP F 270      -0.369  26.115   9.605  1.00 17.73           C  
ATOM   3736  OD1 ASP F 270       0.420  25.304   9.032  1.00 19.86           O  
ATOM   3737  OD2 ASP F 270      -0.054  27.294   9.863  1.00 23.35           O  
ATOM   3738  N   GLY F 271      -1.205  23.021   7.867  1.00 13.26           N  
ATOM   3739  CA  GLY F 271      -1.034  22.653   6.476  1.00 11.71           C  
ATOM   3740  C   GLY F 271       0.145  23.347   5.786  1.00 12.69           C  
ATOM   3741  O   GLY F 271       0.447  23.042   4.656  1.00 12.22           O  
ATOM   3742  N   ARG F 272       0.809  24.297   6.435  1.00 16.23           N  
ATOM   3743  CA  ARG F 272       1.917  24.976   5.766  1.00 14.28           C  
ATOM   3744  C   ARG F 272       3.233  24.171   5.927  1.00 12.25           C  
ATOM   3745  O   ARG F 272       3.526  23.647   7.004  1.00 12.27           O  
ATOM   3746  CB  ARG F 272       2.049  26.417   6.284  1.00 15.45           C  
ATOM   3747  CG  ARG F 272       0.880  27.261   5.939  1.00  6.36           C  
ATOM   3748  CD  ARG F 272       1.053  28.717   6.354  1.00 16.43           C  
ATOM   3749  NE  ARG F 272       0.747  28.888   7.768  1.00 14.49           N  
ATOM   3750  CZ  ARG F 272       0.945  30.012   8.453  1.00 18.13           C  
ATOM   3751  NH1 ARG F 272       1.478  31.071   7.875  1.00 25.61           N  
ATOM   3752  NH2 ARG F 272       0.601  30.077   9.731  1.00 16.21           N  
ATOM   3753  N   PRO F 273       4.005  24.024   4.846  1.00 15.76           N  
ATOM   3754  CA  PRO F 273       5.243  23.271   5.006  1.00 17.67           C  
ATOM   3755  C   PRO F 273       6.366  24.062   5.690  1.00 21.62           C  
ATOM   3756  O   PRO F 273       6.444  25.311   5.605  1.00 18.17           O  
ATOM   3757  CB  PRO F 273       5.599  22.882   3.587  1.00 17.06           C  
ATOM   3758  CG  PRO F 273       5.073  24.017   2.770  1.00 23.56           C  
ATOM   3759  CD  PRO F 273       3.818  24.493   3.462  1.00 21.77           C  
ATOM   3760  N   GLY F 274       7.140  23.325   6.471  1.00 16.42           N  
ATOM   3761  CA  GLY F 274       8.412  23.773   6.974  1.00 17.08           C  
ATOM   3762  C   GLY F 274       9.455  22.894   6.319  1.00 14.60           C  
ATOM   3763  O   GLY F 274       9.167  21.748   5.960  1.00 13.39           O  
ATOM   3764  N   GLN F 275      10.638  23.454   6.136  1.00 15.19           N  
ATOM   3765  CA  GLN F 275      11.802  22.749   5.650  1.00 15.13           C  
ATOM   3766  C   GLN F 275      12.726  22.643   6.855  1.00 14.85           C  
ATOM   3767  O   GLN F 275      13.138  23.656   7.446  1.00 15.42           O  
ATOM   3768  CB  GLN F 275      12.477  23.542   4.517  1.00 15.57           C  
ATOM   3769  CG  GLN F 275      11.567  23.867   3.340  1.00 12.99           C  
ATOM   3770  CD  GLN F 275      10.899  22.661   2.739  1.00 12.39           C  
ATOM   3771  OE1 GLN F 275      11.506  21.611   2.600  1.00 10.35           O  
ATOM   3772  NE2 GLN F 275       9.621  22.809   2.360  1.00 17.36           N  
ATOM   3773  N   PHE F 276      13.057  21.417   7.213  1.00 11.28           N  
ATOM   3774  CA  PHE F 276      13.805  21.179   8.412  1.00 10.97           C  
ATOM   3775  C   PHE F 276      15.114  20.565   8.055  1.00 15.28           C  
ATOM   3776  O   PHE F 276      15.187  19.769   7.121  1.00 14.52           O  
ATOM   3777  CB  PHE F 276      12.995  20.291   9.341  1.00 10.96           C  
ATOM   3778  CG  PHE F 276      11.729  20.927   9.774  1.00 14.20           C  
ATOM   3779  CD1 PHE F 276      11.742  21.849  10.811  1.00 13.67           C  
ATOM   3780  CD2 PHE F 276      10.557  20.690   9.112  1.00 11.12           C  
ATOM   3781  CE1 PHE F 276      10.632  22.483  11.207  1.00 13.37           C  
ATOM   3782  CE2 PHE F 276       9.390  21.355   9.515  1.00 19.40           C  
ATOM   3783  CZ  PHE F 276       9.443  22.256  10.552  1.00 16.38           C  
ATOM   3784  N   LEU F 277      16.148  20.941   8.796  1.00 17.11           N  
ATOM   3785  CA  LEU F 277      17.419  20.228   8.734  1.00 17.00           C  
ATOM   3786  C   LEU F 277      17.287  18.942   9.545  1.00 18.26           C  
ATOM   3787  O   LEU F 277      17.415  18.930  10.775  1.00 21.31           O  
ATOM   3788  CB  LEU F 277      18.579  21.073   9.245  1.00 19.85           C  
ATOM   3789  CG  LEU F 277      18.863  22.436   8.596  1.00 19.02           C  
ATOM   3790  CD1 LEU F 277      20.331  22.802   8.814  1.00 19.92           C  
ATOM   3791  CD2 LEU F 277      18.528  22.491   7.152  1.00 22.02           C  
ATOM   3792  N   TRP F 278      17.024  17.864   8.830  1.00 16.30           N  
ATOM   3793  CA  TRP F 278      16.760  16.562   9.426  1.00 14.67           C  
ATOM   3794  C   TRP F 278      18.010  15.968  10.027  1.00 19.40           C  
ATOM   3795  O   TRP F 278      17.948  15.214  10.992  1.00 18.12           O  
ATOM   3796  CB  TRP F 278      16.221  15.590   8.365  1.00 15.52           C  
ATOM   3797  CG  TRP F 278      15.124  14.667   8.922  1.00 17.25           C  
ATOM   3798  CD1 TRP F 278      15.236  13.348   9.260  1.00 20.45           C  
ATOM   3799  CD2 TRP F 278      13.771  15.043   9.228  1.00 17.61           C  
ATOM   3800  NE1 TRP F 278      14.033  12.875   9.750  1.00 16.45           N  
ATOM   3801  CE2 TRP F 278      13.115  13.893   9.725  1.00 21.64           C  
ATOM   3802  CE3 TRP F 278      13.050  16.240   9.130  1.00 21.63           C  
ATOM   3803  CZ2 TRP F 278      11.777  13.911  10.122  1.00 17.74           C  
ATOM   3804  CZ3 TRP F 278      11.727  16.248   9.515  1.00 20.36           C  
ATOM   3805  CH2 TRP F 278      11.103  15.089  10.003  1.00 18.77           C  
ATOM   3806  N   GLU F 279      19.139  16.281   9.405  1.00 17.68           N  
ATOM   3807  CA  GLU F 279      20.417  15.764   9.785  1.00 16.43           C  
ATOM   3808  C   GLU F 279      21.448  16.753   9.281  1.00 19.52           C  
ATOM   3809  O   GLU F 279      21.235  17.391   8.247  1.00 19.36           O  
ATOM   3810  CB  GLU F 279      20.622  14.395   9.124  1.00 24.74           C  
ATOM   3811  CG  GLU F 279      21.478  13.412   9.900  1.00 32.26           C  
ATOM   3812  CD  GLU F 279      22.940  13.410   9.457  1.00 46.40           C  
ATOM   3813  OE1 GLU F 279      23.825  12.966  10.232  1.00 51.49           O  
ATOM   3814  OE2 GLU F 279      23.209  13.841   8.313  1.00 57.57           O  
ATOM   3815  N   VAL F 280      22.537  16.899  10.039  1.00 20.15           N  
ATOM   3816  CA  VAL F 280      23.679  17.744   9.669  1.00 20.87           C  
ATOM   3817  C   VAL F 280      24.969  16.934   9.813  1.00 21.44           C  
ATOM   3818  O   VAL F 280      25.250  16.366  10.876  1.00 21.73           O  
ATOM   3819  CB  VAL F 280      23.751  19.012  10.517  1.00 24.86           C  
ATOM   3820  CG1 VAL F 280      24.793  19.949   9.943  1.00 20.95           C  
ATOM   3821  CG2 VAL F 280      22.375  19.729  10.563  1.00 18.05           C  
ATOM   3822  N   ASP F 281      25.729  16.870   8.723  1.00 15.87           N  
ATOM   3823  CA  ASP F 281      26.889  16.003   8.603  1.00 19.41           C  
ATOM   3824  C   ASP F 281      28.053  16.569   9.413  1.00 14.90           C  
ATOM   3825  O   ASP F 281      28.368  17.752   9.279  1.00 17.84           O  
ATOM   3826  CB  ASP F 281      27.304  15.864   7.133  1.00 14.36           C  
ATOM   3827  CG  ASP F 281      26.229  15.257   6.279  1.00 31.28           C  
ATOM   3828  OD1 ASP F 281      25.596  14.270   6.713  1.00 42.12           O  
ATOM   3829  OD2 ASP F 281      26.013  15.765   5.167  1.00 36.77           O  
ATOM   3830  N   PRO F 282      28.664  15.746  10.284  1.00 17.17           N  
ATOM   3831  CA  PRO F 282      29.837  16.230  10.986  1.00 17.42           C  
ATOM   3832  C   PRO F 282      30.921  16.664  10.029  1.00 13.63           C  
ATOM   3833  O   PRO F 282      31.236  15.938   9.082  1.00 10.65           O  
ATOM   3834  CB  PRO F 282      30.322  14.999  11.771  1.00 17.60           C  
ATOM   3835  CG  PRO F 282      29.189  14.110  11.841  1.00 23.44           C  
ATOM   3836  CD  PRO F 282      28.313  14.377  10.681  1.00 17.25           C  
ATOM   3837  N   GLY F 283      31.503  17.833  10.285  1.00 12.60           N  
ATOM   3838  CA  GLY F 283      32.747  18.216   9.620  1.00  9.20           C  
ATOM   3839  C   GLY F 283      32.543  18.796   8.239  1.00  7.09           C  
ATOM   3840  O   GLY F 283      33.512  19.090   7.549  1.00  6.72           O  
ATOM   3841  N   LEU F 284      31.287  18.914   7.824  1.00 11.04           N  
ATOM   3842  CA  LEU F 284      30.913  19.636   6.612  1.00 13.68           C  
ATOM   3843  C   LEU F 284      30.461  21.068   6.973  1.00 10.83           C  
ATOM   3844  O   LEU F 284      30.326  21.380   8.157  1.00 12.08           O  
ATOM   3845  CB  LEU F 284      29.857  18.847   5.840  1.00 10.53           C  
ATOM   3846  CG  LEU F 284      30.429  17.642   5.107  1.00 18.36           C  
ATOM   3847  CD1 LEU F 284      29.383  16.957   4.258  1.00 18.92           C  
ATOM   3848  CD2 LEU F 284      31.637  18.044   4.249  1.00 23.04           C  
ATOM   3849  N   PRO F 285      30.346  21.976   5.969  1.00 17.56           N  
ATOM   3850  CA  PRO F 285      30.106  23.430   6.227  1.00 18.26           C  
ATOM   3851  C   PRO F 285      29.013  23.819   7.215  1.00 19.59           C  
ATOM   3852  O   PRO F 285      29.302  24.549   8.164  1.00 18.59           O  
ATOM   3853  CB  PRO F 285      29.835  23.995   4.824  1.00 18.74           C  
ATOM   3854  CG  PRO F 285      30.728  23.145   3.972  1.00 18.84           C  
ATOM   3855  CD  PRO F 285      30.534  21.738   4.524  1.00 16.04           C  
ATOM   3856  N   ALA F 286      27.789  23.311   7.023  1.00 17.86           N  
ATOM   3857  CA  ALA F 286      26.685  23.571   7.938  1.00 15.36           C  
ATOM   3858  C   ALA F 286      27.006  23.241   9.418  1.00 16.31           C  
ATOM   3859  O   ALA F 286      26.821  24.068  10.310  1.00 15.22           O  
ATOM   3860  CB  ALA F 286      25.416  22.801   7.461  1.00 15.48           C  
ATOM   3861  N   LYS F 287      27.491  22.035   9.694  1.00 19.36           N  
ATOM   3862  CA  LYS F 287      27.861  21.693  11.072  1.00 22.44           C  
ATOM   3863  C   LYS F 287      28.929  22.619  11.632  1.00 25.18           C  
ATOM   3864  O   LYS F 287      28.839  23.032  12.788  1.00 26.37           O  
ATOM   3865  CB  LYS F 287      28.338  20.242  11.179  1.00 22.19           C  
ATOM   3866  CG  LYS F 287      28.430  19.732  12.606  1.00 30.60           C  
ATOM   3867  CD  LYS F 287      27.059  19.513  13.193  1.00 34.10           C  
ATOM   3868  CE  LYS F 287      27.099  18.487  14.323  1.00 42.30           C  
ATOM   3869  NZ  LYS F 287      25.775  17.823  14.478  1.00 52.29           N  
ATOM   3870  N   LYS F 288      29.930  22.937  10.812  1.00 25.92           N  
ATOM   3871  CA  LYS F 288      31.031  23.792  11.230  1.00 26.55           C  
ATOM   3872  C   LYS F 288      30.583  25.223  11.532  1.00 28.23           C  
ATOM   3873  O   LYS F 288      31.222  25.912  12.331  1.00 30.84           O  
ATOM   3874  CB  LYS F 288      32.166  23.771  10.199  1.00 24.94           C  
ATOM   3875  CG  LYS F 288      32.887  22.433  10.139  1.00 23.48           C  
ATOM   3876  CD  LYS F 288      34.135  22.478   9.284  1.00 22.51           C  
ATOM   3877  CE  LYS F 288      35.274  23.202  10.006  1.00 12.39           C  
ATOM   3878  NZ  LYS F 288      36.556  22.807   9.510  1.00 15.78           N  
ATOM   3879  N   ALA F 289      29.486  25.639  10.896  1.00 28.68           N  
ATOM   3880  CA  ALA F 289      28.809  26.905  11.161  1.00 26.00           C  
ATOM   3881  C   ALA F 289      27.754  26.815  12.274  1.00 29.45           C  
ATOM   3882  O   ALA F 289      26.969  27.751  12.454  1.00 35.89           O  
ATOM   3883  CB  ALA F 289      28.144  27.399   9.893  1.00 23.18           C  
ATOM   3884  N   GLY F 290      27.710  25.692  12.994  1.00 28.58           N  
ATOM   3885  CA  GLY F 290      26.876  25.560  14.191  1.00 29.35           C  
ATOM   3886  C   GLY F 290      25.429  25.105  13.975  1.00 29.20           C  
ATOM   3887  O   GLY F 290      24.650  25.019  14.941  1.00 29.96           O  
ATOM   3888  N   MET F 291      25.069  24.800  12.729  1.00 26.68           N  
ATOM   3889  CA  MET F 291      23.750  24.242  12.420  1.00 22.89           C  
ATOM   3890  C   MET F 291      23.563  22.882  13.049  1.00 23.03           C  
ATOM   3891  O   MET F 291      24.537  22.132  13.245  1.00 19.16           O  
ATOM   3892  CB  MET F 291      23.528  24.160  10.916  1.00 25.44           C  
ATOM   3893  CG  MET F 291      23.154  25.497  10.337  1.00 36.08           C  
ATOM   3894  SD  MET F 291      23.337  25.611   8.558  1.00 32.52           S  
ATOM   3895  CE  MET F 291      23.557  27.375   8.371  1.00 41.34           C  
ATOM   3896  N   GLN F 292      22.293  22.575  13.337  1.00 23.46           N  
ATOM   3897  CA  GLN F 292      21.897  21.455  14.175  1.00 23.99           C  
ATOM   3898  C   GLN F 292      20.743  20.704  13.564  1.00 19.49           C  
ATOM   3899  O   GLN F 292      19.790  21.324  13.076  1.00 16.68           O  
ATOM   3900  CB  GLN F 292      21.387  21.973  15.520  1.00 25.42           C  
ATOM   3901  CG  GLN F 292      22.350  22.829  16.305  1.00 33.27           C  
ATOM   3902  CD  GLN F 292      21.724  23.301  17.600  1.00 34.05           C  
ATOM   3903  OE1 GLN F 292      20.672  22.800  18.006  1.00 36.71           O  
ATOM   3904  NE2 GLN F 292      22.355  24.277  18.249  1.00 47.41           N  
ATOM   3905  N   ALA F 293      20.788  19.374  13.633  1.00 19.93           N  
ATOM   3906  CA  ALA F 293      19.637  18.575  13.257  1.00 20.39           C  
ATOM   3907  C   ALA F 293      18.439  19.059  14.117  1.00 19.23           C  
ATOM   3908  O   ALA F 293      18.540  19.230  15.362  1.00 16.38           O  
ATOM   3909  CB  ALA F 293      19.913  17.112  13.434  1.00 22.31           C  
ATOM   3910  N   GLY F 294      17.339  19.357  13.437  1.00 16.76           N  
ATOM   3911  CA  GLY F 294      16.155  19.921  14.079  1.00 19.32           C  
ATOM   3912  C   GLY F 294      15.982  21.393  13.794  1.00 21.33           C  
ATOM   3913  O   GLY F 294      14.876  21.952  13.969  1.00 19.33           O  
ATOM   3914  N   ASP F 295      17.055  22.036  13.331  1.00 15.90           N  
ATOM   3915  CA  ASP F 295      16.945  23.446  12.885  1.00 14.59           C  
ATOM   3916  C   ASP F 295      15.825  23.595  11.883  1.00 13.24           C  
ATOM   3917  O   ASP F 295      15.650  22.726  11.050  1.00 11.48           O  
ATOM   3918  CB  ASP F 295      18.242  23.897  12.195  1.00 14.45           C  
ATOM   3919  CG  ASP F 295      19.315  24.275  13.161  1.00 16.74           C  
ATOM   3920  OD1 ASP F 295      18.992  24.367  14.364  1.00 19.28           O  
ATOM   3921  OD2 ASP F 295      20.466  24.513  12.718  1.00 16.73           O  
ATOM   3922  N   ARG F 296      15.084  24.692  11.922  1.00 16.05           N  
ATOM   3923  CA  ARG F 296      14.212  25.029  10.782  1.00 14.53           C  
ATOM   3924  C   ARG F 296      14.935  26.003   9.859  1.00 14.27           C  
ATOM   3925  O   ARG F 296      15.519  26.983  10.329  1.00 14.65           O  
ATOM   3926  CB  ARG F 296      12.878  25.623  11.256  1.00 15.87           C  
ATOM   3927  CG  ARG F 296      11.827  25.721  10.191  1.00 12.41           C  
ATOM   3928  CD  ARG F 296      10.498  26.257  10.727  1.00 19.14           C  
ATOM   3929  NE  ARG F 296      10.559  27.636  11.210  1.00 15.22           N  
ATOM   3930  CZ  ARG F 296      10.643  28.028  12.487  1.00 18.20           C  
ATOM   3931  NH1 ARG F 296      10.742  27.170  13.482  1.00 24.26           N  
ATOM   3932  NH2 ARG F 296      10.670  29.327  12.765  1.00 23.84           N  
ATOM   3933  N   LEU F 297      14.891  25.751   8.545  1.00 15.94           N  
ATOM   3934  CA  LEU F 297      15.448  26.700   7.554  1.00 13.84           C  
ATOM   3935  C   LEU F 297      14.429  27.799   7.319  1.00 14.34           C  
ATOM   3936  O   LEU F 297      13.343  27.511   6.819  1.00 15.72           O  
ATOM   3937  CB  LEU F 297      15.805  26.044   6.204  1.00 15.09           C  
ATOM   3938  CG  LEU F 297      16.550  26.926   5.191  1.00 14.82           C  
ATOM   3939  CD1 LEU F 297      17.905  27.416   5.786  1.00 10.08           C  
ATOM   3940  CD2 LEU F 297      16.761  26.193   3.826  1.00 13.89           C  
ATOM   3941  N   VAL F 298      14.803  29.041   7.656  1.00 12.22           N  
ATOM   3942  CA  VAL F 298      13.881  30.170   7.621  1.00 14.01           C  
ATOM   3943  C   VAL F 298      14.232  31.247   6.567  1.00 15.30           C  
ATOM   3944  O   VAL F 298      13.363  32.015   6.132  1.00 16.51           O  
ATOM   3945  CB  VAL F 298      13.695  30.802   9.048  1.00 13.79           C  
ATOM   3946  CG1 VAL F 298      13.261  29.731  10.038  1.00  9.06           C  
ATOM   3947  CG2 VAL F 298      14.951  31.496   9.545  1.00 15.84           C  
ATOM   3948  N   ALA F 299      15.484  31.315   6.156  1.00 14.92           N  
ATOM   3949  CA  ALA F 299      15.843  32.219   5.061  1.00 16.66           C  
ATOM   3950  C   ALA F 299      16.985  31.640   4.253  1.00 15.36           C  
ATOM   3951  O   ALA F 299      17.863  30.936   4.801  1.00 16.96           O  
ATOM   3952  CB  ALA F 299      16.206  33.652   5.595  1.00 12.13           C  
ATOM   3953  N   VAL F 300      16.925  31.916   2.946  1.00 17.56           N  
ATOM   3954  CA  VAL F 300      18.034  31.694   2.016  1.00 15.26           C  
ATOM   3955  C   VAL F 300      18.388  33.014   1.307  1.00 13.76           C  
ATOM   3956  O   VAL F 300      17.511  33.660   0.722  1.00 12.32           O  
ATOM   3957  CB  VAL F 300      17.667  30.653   0.951  1.00 10.39           C  
ATOM   3958  CG1 VAL F 300      18.870  30.389  -0.014  1.00 13.54           C  
ATOM   3959  CG2 VAL F 300      17.189  29.334   1.632  1.00  7.68           C  
ATOM   3960  N   ALA F 301      19.665  33.396   1.385  1.00 15.15           N  
ATOM   3961  CA  ALA F 301      20.181  34.597   0.733  1.00 16.90           C  
ATOM   3962  C   ALA F 301      19.410  35.841   1.194  1.00 18.90           C  
ATOM   3963  O   ALA F 301      19.102  36.725   0.400  1.00 16.86           O  
ATOM   3964  CB  ALA F 301      20.104  34.449  -0.789  1.00 17.95           C  
ATOM   3965  N   GLY F 302      19.094  35.894   2.487  1.00 20.05           N  
ATOM   3966  CA  GLY F 302      18.406  37.041   3.060  1.00 16.19           C  
ATOM   3967  C   GLY F 302      16.904  37.070   2.823  1.00 18.87           C  
ATOM   3968  O   GLY F 302      16.260  37.950   3.341  1.00 15.47           O  
ATOM   3969  N   GLU F 303      16.342  36.129   2.047  1.00 14.72           N  
ATOM   3970  CA  GLU F 303      14.896  36.123   1.774  1.00 15.10           C  
ATOM   3971  C   GLU F 303      14.266  34.973   2.519  1.00 14.54           C  
ATOM   3972  O   GLU F 303      14.840  33.895   2.613  1.00 14.65           O  
ATOM   3973  CB  GLU F 303      14.586  35.989   0.290  1.00 18.46           C  
ATOM   3974  CG  GLU F 303      14.689  37.277  -0.446  1.00 15.38           C  
ATOM   3975  CD  GLU F 303      14.635  37.099  -1.937  1.00 22.32           C  
ATOM   3976  OE1 GLU F 303      13.526  37.029  -2.506  1.00 32.06           O  
ATOM   3977  OE2 GLU F 303      15.710  37.030  -2.554  1.00 33.78           O  
ATOM   3978  N   SER F 304      13.083  35.227   3.058  1.00 16.77           N  
ATOM   3979  CA  SER F 304      12.377  34.238   3.844  1.00 17.99           C  
ATOM   3980  C   SER F 304      11.889  33.046   3.010  1.00 19.05           C  
ATOM   3981  O   SER F 304      11.249  33.245   1.970  1.00 16.32           O  
ATOM   3982  CB  SER F 304      11.191  34.889   4.548  1.00 18.18           C  
ATOM   3983  OG  SER F 304      10.642  33.993   5.496  1.00 15.50           O  
ATOM   3984  N   VAL F 305      12.219  31.825   3.480  1.00 19.07           N  
ATOM   3985  CA  VAL F 305      11.606  30.580   2.990  1.00 17.86           C  
ATOM   3986  C   VAL F 305      10.670  29.931   4.019  1.00 15.24           C  
ATOM   3987  O   VAL F 305      10.379  28.722   3.951  1.00 16.01           O  
ATOM   3988  CB  VAL F 305      12.676  29.560   2.477  1.00 17.14           C  
ATOM   3989  CG1 VAL F 305      13.474  30.215   1.340  1.00 11.39           C  
ATOM   3990  CG2 VAL F 305      13.606  29.018   3.638  1.00 13.10           C  
ATOM   3991  N   GLU F 306      10.166  30.735   4.950  1.00 16.05           N  
ATOM   3992  CA  GLU F 306       9.196  30.246   5.941  1.00 18.37           C  
ATOM   3993  C   GLU F 306       7.947  29.924   5.158  1.00 15.33           C  
ATOM   3994  O   GLU F 306       7.547  30.711   4.322  1.00 12.62           O  
ATOM   3995  CB  GLU F 306       8.857  31.307   6.986  1.00 16.88           C  
ATOM   3996  CG  GLU F 306       9.960  31.612   7.944  1.00 22.82           C  
ATOM   3997  CD  GLU F 306      10.011  30.661   9.116  1.00 21.10           C  
ATOM   3998  OE1 GLU F 306       9.832  29.435   8.925  1.00 20.93           O  
ATOM   3999  OE2 GLU F 306      10.263  31.133  10.236  1.00 19.55           O  
ATOM   4000  N   GLY F 307       7.371  28.749   5.389  1.00 18.36           N  
ATOM   4001  CA  GLY F 307       6.162  28.344   4.686  1.00 17.03           C  
ATOM   4002  C   GLY F 307       6.319  28.043   3.205  1.00 15.40           C  
ATOM   4003  O   GLY F 307       5.327  27.958   2.507  1.00 14.37           O  
ATOM   4004  N   LEU F 308       7.544  27.884   2.731  1.00 13.77           N  
ATOM   4005  CA  LEU F 308       7.837  27.654   1.307  1.00 15.78           C  
ATOM   4006  C   LEU F 308       8.062  26.154   1.031  1.00 15.39           C  
ATOM   4007  O   LEU F 308       8.528  25.419   1.915  1.00 15.29           O  
ATOM   4008  CB  LEU F 308       9.088  28.453   0.885  1.00 16.87           C  
ATOM   4009  CG  LEU F 308       9.387  28.638  -0.602  1.00 19.30           C  
ATOM   4010  CD1 LEU F 308       8.300  29.498  -1.261  1.00 18.49           C  
ATOM   4011  CD2 LEU F 308      10.764  29.264  -0.845  1.00 16.61           C  
ATOM   4012  N   GLY F 309       7.736  25.738  -0.201  1.00 14.17           N  
ATOM   4013  CA  GLY F 309       7.716  24.330  -0.593  1.00 16.84           C  
ATOM   4014  C   GLY F 309       9.117  23.766  -0.783  1.00 13.95           C  
ATOM   4015  O   GLY F 309      10.084  24.521  -0.889  1.00 16.70           O  
ATOM   4016  N   HIS F 310       9.222  22.438  -0.848  1.00 11.73           N  
ATOM   4017  CA  HIS F 310      10.547  21.797  -0.833  1.00 15.76           C  
ATOM   4018  C   HIS F 310      11.376  22.134  -2.086  1.00 13.94           C  
ATOM   4019  O   HIS F 310      12.543  22.524  -1.999  1.00 11.49           O  
ATOM   4020  CB  HIS F 310      10.423  20.283  -0.694  1.00 13.75           C  
ATOM   4021  CG  HIS F 310      11.738  19.599  -0.525  1.00 13.25           C  
ATOM   4022  ND1 HIS F 310      12.475  19.717   0.628  1.00 16.57           N  
ATOM   4023  CD2 HIS F 310      12.454  18.806  -1.356  1.00 11.57           C  
ATOM   4024  CE1 HIS F 310      13.587  19.021   0.505  1.00 15.05           C  
ATOM   4025  NE2 HIS F 310      13.608  18.472  -0.696  1.00 12.80           N  
ATOM   4026  N   GLU F 311      10.781  21.975  -3.254  1.00 17.79           N  
ATOM   4027  CA  GLU F 311      11.567  22.127  -4.469  1.00 19.77           C  
ATOM   4028  C   GLU F 311      11.946  23.596  -4.662  1.00 15.33           C  
ATOM   4029  O   GLU F 311      13.056  23.874  -5.086  1.00 13.06           O  
ATOM   4030  CB  GLU F 311      10.861  21.548  -5.702  1.00 23.21           C  
ATOM   4031  CG  GLU F 311      10.664  20.016  -5.677  1.00 35.28           C  
ATOM   4032  CD  GLU F 311      11.954  19.200  -5.503  1.00 46.75           C  
ATOM   4033  OE1 GLU F 311      11.881  18.105  -4.899  1.00 58.53           O  
ATOM   4034  OE2 GLU F 311      13.036  19.628  -5.965  1.00 51.59           O  
ATOM   4035  N   GLU F 312      11.040  24.524  -4.347  1.00 14.75           N  
ATOM   4036  CA  GLU F 312      11.368  25.939  -4.430  1.00 15.25           C  
ATOM   4037  C   GLU F 312      12.492  26.355  -3.471  1.00 15.56           C  
ATOM   4038  O   GLU F 312      13.332  27.200  -3.813  1.00 14.29           O  
ATOM   4039  CB  GLU F 312      10.146  26.805  -4.174  1.00 15.34           C  
ATOM   4040  CG  GLU F 312      10.449  28.290  -3.962  1.00 28.22           C  
ATOM   4041  CD  GLU F 312      11.017  29.019  -5.180  1.00 35.81           C  
ATOM   4042  OE1 GLU F 312      11.960  28.518  -5.845  1.00 30.83           O  
ATOM   4043  OE2 GLU F 312      10.524  30.139  -5.449  1.00 27.19           O  
ATOM   4044  N   THR F 313      12.487  25.790  -2.265  1.00 16.46           N  
ATOM   4045  CA  THR F 313      13.569  26.039  -1.302  1.00 13.54           C  
ATOM   4046  C   THR F 313      14.889  25.468  -1.814  1.00 15.02           C  
ATOM   4047  O   THR F 313      15.975  26.094  -1.668  1.00 14.45           O  
ATOM   4048  CB  THR F 313      13.196  25.469   0.080  1.00 13.33           C  
ATOM   4049  OG1 THR F 313      11.896  25.976   0.448  1.00 14.45           O  
ATOM   4050  CG2 THR F 313      14.214  25.881   1.121  1.00  9.66           C  
ATOM   4051  N   VAL F 314      14.810  24.295  -2.436  1.00 14.83           N  
ATOM   4052  CA  VAL F 314      16.026  23.643  -2.964  1.00 11.67           C  
ATOM   4053  C   VAL F 314      16.573  24.465  -4.116  1.00 13.00           C  
ATOM   4054  O   VAL F 314      17.797  24.662  -4.205  1.00 16.09           O  
ATOM   4055  CB  VAL F 314      15.775  22.162  -3.395  1.00 13.09           C  
ATOM   4056  CG1 VAL F 314      17.032  21.544  -4.101  1.00 12.49           C  
ATOM   4057  CG2 VAL F 314      15.415  21.289  -2.172  1.00 11.99           C  
ATOM   4058  N   SER F 315      15.689  24.979  -4.988  1.00 11.96           N  
ATOM   4059  CA  SER F 315      16.163  25.787  -6.131  1.00 11.11           C  
ATOM   4060  C   SER F 315      16.827  27.094  -5.656  1.00 15.28           C  
ATOM   4061  O   SER F 315      17.929  27.473  -6.106  1.00 11.71           O  
ATOM   4062  CB  SER F 315      15.068  26.034  -7.190  1.00 13.47           C  
ATOM   4063  OG  SER F 315      13.856  26.476  -6.619  1.00 30.98           O  
ATOM   4064  N   ARG F 316      16.202  27.752  -4.696  1.00 17.64           N  
ATOM   4065  CA  ARG F 316      16.800  28.947  -4.092  1.00 15.43           C  
ATOM   4066  C   ARG F 316      18.197  28.747  -3.519  1.00 18.58           C  
ATOM   4067  O   ARG F 316      19.077  29.605  -3.706  1.00 14.59           O  
ATOM   4068  CB  ARG F 316      15.890  29.482  -3.012  1.00 12.97           C  
ATOM   4069  CG  ARG F 316      14.779  30.296  -3.589  1.00 19.12           C  
ATOM   4070  CD  ARG F 316      13.673  30.473  -2.614  1.00 21.39           C  
ATOM   4071  NE  ARG F 316      12.731  31.449  -3.148  1.00 21.23           N  
ATOM   4072  CZ  ARG F 316      12.475  32.657  -2.634  1.00 26.91           C  
ATOM   4073  NH1 ARG F 316      13.048  33.083  -1.512  1.00 27.79           N  
ATOM   4074  NH2 ARG F 316      11.603  33.453  -3.244  1.00 36.40           N  
ATOM   4075  N   ILE F 317      18.397  27.627  -2.814  1.00 14.86           N  
ATOM   4076  CA  ILE F 317      19.722  27.262  -2.331  1.00 16.66           C  
ATOM   4077  C   ILE F 317      20.639  27.037  -3.531  1.00 17.49           C  
ATOM   4078  O   ILE F 317      21.744  27.610  -3.615  1.00 16.79           O  
ATOM   4079  CB  ILE F 317      19.671  25.966  -1.450  1.00 17.69           C  
ATOM   4080  CG1 ILE F 317      18.893  26.246  -0.164  1.00 16.84           C  
ATOM   4081  CG2 ILE F 317      21.082  25.469  -1.098  1.00 13.73           C  
ATOM   4082  CD1 ILE F 317      18.436  24.938   0.590  1.00 12.49           C  
ATOM   4083  N   GLN F 318      20.172  26.225  -4.479  1.00 17.62           N  
ATOM   4084  CA  GLN F 318      20.977  25.917  -5.675  1.00 17.64           C  
ATOM   4085  C   GLN F 318      21.276  27.125  -6.551  1.00 17.09           C  
ATOM   4086  O   GLN F 318      22.375  27.220  -7.109  1.00 14.20           O  
ATOM   4087  CB  GLN F 318      20.294  24.855  -6.524  1.00 18.38           C  
ATOM   4088  CG  GLN F 318      20.282  23.473  -5.880  1.00 19.51           C  
ATOM   4089  CD  GLN F 318      19.461  22.464  -6.705  1.00 23.93           C  
ATOM   4090  OE1 GLN F 318      18.726  22.845  -7.621  1.00 19.81           O  
ATOM   4091  NE2 GLN F 318      19.604  21.181  -6.382  1.00 28.07           N  
ATOM   4092  N   GLY F 319      20.305  28.037  -6.681  1.00 14.12           N  
ATOM   4093  CA  GLY F 319      20.488  29.271  -7.449  1.00 15.13           C  
ATOM   4094  C   GLY F 319      21.623  30.171  -6.966  1.00 17.71           C  
ATOM   4095  O   GLY F 319      22.031  31.107  -7.691  1.00 15.87           O  
ATOM   4096  N   GLN F 320      22.153  29.877  -5.769  1.00 13.89           N  
ATOM   4097  CA  GLN F 320      23.166  30.699  -5.110  1.00 12.11           C  
ATOM   4098  C   GLN F 320      24.576  30.238  -5.396  1.00 18.58           C  
ATOM   4099  O   GLN F 320      25.516  30.981  -5.156  1.00 20.51           O  
ATOM   4100  CB  GLN F 320      22.946  30.711  -3.597  1.00 16.92           C  
ATOM   4101  CG  GLN F 320      21.782  31.599  -3.103  1.00 13.81           C  
ATOM   4102  CD  GLN F 320      21.896  33.003  -3.578  1.00 19.28           C  
ATOM   4103  OE1 GLN F 320      22.872  33.673  -3.275  1.00 23.09           O  
ATOM   4104  NE2 GLN F 320      20.913  33.459  -4.372  1.00 15.46           N  
ATOM   4105  N   GLY F 321      24.732  29.015  -5.905  1.00 18.59           N  
ATOM   4106  CA  GLY F 321      26.034  28.505  -6.266  1.00 19.49           C  
ATOM   4107  C   GLY F 321      26.865  28.068  -5.057  1.00 22.09           C  
ATOM   4108  O   GLY F 321      26.348  27.430  -4.133  1.00 19.40           O  
ATOM   4109  N   SER F 322      28.139  28.470  -5.062  1.00 21.01           N  
ATOM   4110  CA  SER F 322      29.170  27.966  -4.133  1.00 26.42           C  
ATOM   4111  C   SER F 322      29.106  28.553  -2.735  1.00 25.85           C  
ATOM   4112  O   SER F 322      29.518  27.885  -1.778  1.00 27.27           O  
ATOM   4113  CB  SER F 322      30.580  28.228  -4.703  1.00 23.91           C  
ATOM   4114  OG  SER F 322      30.725  29.561  -5.177  1.00 30.71           O  
ATOM   4115  N   CYS F 323      28.616  29.794  -2.627  1.00 20.77           N  
ATOM   4116  CA  CYS F 323      28.532  30.510  -1.351  1.00 22.09           C  
ATOM   4117  C   CYS F 323      27.099  30.912  -1.017  1.00 27.03           C  
ATOM   4118  O   CYS F 323      26.459  31.617  -1.807  1.00 25.46           O  
ATOM   4119  CB  CYS F 323      29.397  31.771  -1.417  1.00 23.86           C  
ATOM   4120  SG  CYS F 323      31.201  31.427  -1.421  1.00 45.98           S  
ATOM   4121  N   VAL F 324      26.596  30.514   0.152  1.00 23.58           N  
ATOM   4122  CA  VAL F 324      25.220  30.852   0.511  1.00 19.56           C  
ATOM   4123  C   VAL F 324      25.050  31.318   1.957  1.00 22.57           C  
ATOM   4124  O   VAL F 324      25.727  30.840   2.888  1.00 19.55           O  
ATOM   4125  CB  VAL F 324      24.271  29.675   0.226  1.00 23.33           C  
ATOM   4126  CG1 VAL F 324      24.448  28.562   1.257  1.00 17.72           C  
ATOM   4127  CG2 VAL F 324      22.822  30.164   0.185  1.00 19.10           C  
ATOM   4128  N   SER F 325      24.130  32.269   2.131  1.00 17.43           N  
ATOM   4129  CA  SER F 325      23.651  32.653   3.434  1.00 19.16           C  
ATOM   4130  C   SER F 325      22.377  31.858   3.713  1.00 18.47           C  
ATOM   4131  O   SER F 325      21.473  31.770   2.852  1.00 20.44           O  
ATOM   4132  CB  SER F 325      23.362  34.155   3.451  1.00 24.93           C  
ATOM   4133  OG  SER F 325      22.941  34.601   4.727  1.00 31.48           O  
ATOM   4134  N   LEU F 326      22.299  31.298   4.920  1.00 17.20           N  
ATOM   4135  CA  LEU F 326      21.128  30.526   5.385  1.00 18.80           C  
ATOM   4136  C   LEU F 326      20.795  30.996   6.810  1.00 20.08           C  
ATOM   4137  O   LEU F 326      21.682  31.100   7.656  1.00 21.41           O  
ATOM   4138  CB  LEU F 326      21.427  29.011   5.406  1.00 18.44           C  
ATOM   4139  CG  LEU F 326      21.871  28.320   4.108  1.00 20.66           C  
ATOM   4140  CD1 LEU F 326      22.432  26.903   4.353  1.00 12.80           C  
ATOM   4141  CD2 LEU F 326      20.726  28.255   3.117  1.00 15.27           C  
ATOM   4142  N   THR F 327      19.530  31.290   7.070  1.00 19.11           N  
ATOM   4143  CA  THR F 327      19.094  31.592   8.423  1.00 16.91           C  
ATOM   4144  C   THR F 327      18.316  30.372   8.978  1.00 13.96           C  
ATOM   4145  O   THR F 327      17.482  29.795   8.304  1.00 15.18           O  
ATOM   4146  CB  THR F 327      18.317  32.931   8.468  1.00 16.05           C  
ATOM   4147  OG1 THR F 327      19.085  33.929   7.794  1.00 19.01           O  
ATOM   4148  CG2 THR F 327      18.068  33.402   9.886  1.00 13.31           C  
ATOM   4149  N   VAL F 328      18.678  29.952  10.187  1.00 10.88           N  
ATOM   4150  CA  VAL F 328      18.041  28.828  10.847  1.00 13.36           C  
ATOM   4151  C   VAL F 328      17.498  29.219  12.216  1.00 15.14           C  
ATOM   4152  O   VAL F 328      17.971  30.166  12.853  1.00 17.56           O  
ATOM   4153  CB  VAL F 328      19.024  27.650  11.071  1.00 17.99           C  
ATOM   4154  CG1 VAL F 328      19.650  27.208   9.732  1.00 12.03           C  
ATOM   4155  CG2 VAL F 328      20.098  28.059  12.116  1.00 18.18           C  
ATOM   4156  N   VAL F 329      16.503  28.470  12.663  1.00 16.77           N  
ATOM   4157  CA  VAL F 329      16.005  28.596  14.021  1.00 18.48           C  
ATOM   4158  C   VAL F 329      16.207  27.255  14.710  1.00 15.51           C  
ATOM   4159  O   VAL F 329      15.722  26.212  14.265  1.00 15.18           O  
ATOM   4160  CB  VAL F 329      14.523  29.028  14.080  1.00 16.60           C  
ATOM   4161  CG1 VAL F 329      13.997  28.933  15.508  1.00 19.49           C  
ATOM   4162  CG2 VAL F 329      14.381  30.455  13.568  1.00 20.51           C  
ATOM   4163  N   ASP F 330      16.938  27.307  15.808  1.00 19.88           N  
ATOM   4164  CA  ASP F 330      17.292  26.121  16.538  1.00 22.99           C  
ATOM   4165  C   ASP F 330      16.115  25.542  17.299  1.00 23.27           C  
ATOM   4166  O   ASP F 330      15.206  26.290  17.718  1.00 20.09           O  
ATOM   4167  CB  ASP F 330      18.429  26.424  17.511  1.00 23.21           C  
ATOM   4168  CG  ASP F 330      19.680  26.828  16.809  1.00 22.93           C  
ATOM   4169  OD1 ASP F 330      20.129  26.089  15.910  1.00 23.81           O  
ATOM   4170  OD2 ASP F 330      20.206  27.901  17.150  1.00 29.21           O  
ATOM   4171  N   PRO F 331      16.140  24.201  17.481  1.00 22.49           N  
ATOM   4172  CA  PRO F 331      15.161  23.492  18.272  1.00 24.74           C  
ATOM   4173  C   PRO F 331      15.534  23.510  19.772  1.00 25.66           C  
ATOM   4174  O   PRO F 331      16.669  23.880  20.145  1.00 22.53           O  
ATOM   4175  CB  PRO F 331      15.236  22.059  17.691  1.00 24.36           C  
ATOM   4176  CG  PRO F 331      16.685  21.907  17.355  1.00 24.54           C  
ATOM   4177  CD  PRO F 331      17.160  23.273  16.941  1.00 22.64           C  
ATOM   4178  N   GLU F 332      14.574  23.123  20.617  1.00 30.82           N  
ATOM   4179  CA  GLU F 332      14.859  22.836  22.023  1.00 31.64           C  
ATOM   4180  C   GLU F 332      15.611  21.506  22.153  1.00 33.70           C  
ATOM   4181  O   GLU F 332      15.186  20.478  21.619  1.00 34.97           O  
ATOM   4182  CB  GLU F 332      13.575  22.809  22.849  1.00 37.54           C  
ATOM   4183  CG  GLU F 332      13.149  24.149  23.389  1.00 42.05           C  
ATOM   4184  CD  GLU F 332      13.084  25.235  22.331  1.00 52.68           C  
ATOM   4185  OE1 GLU F 332      12.841  24.923  21.148  1.00 52.99           O  
ATOM   4186  OE2 GLU F 332      13.287  26.416  22.688  1.00 55.30           O  
ATOM   4187  N   ALA F 333      16.731  21.550  22.876  1.00 37.43           N  
ATOM   4188  CA  ALA F 333      17.593  20.389  23.125  1.00 36.39           C  
ATOM   4189  C   ALA F 333      16.829  19.178  23.652  1.00 35.13           C  
ATOM   4190  O   ALA F 333      17.173  18.033  23.330  1.00 34.11           O  
ATOM   4191  CB  ALA F 333      18.713  20.764  24.119  1.00 34.13           C  
ATOM   4192  N   ASP F 334      15.791  19.450  24.445  1.00 30.46           N  
ATOM   4193  CA  ASP F 334      15.111  18.431  25.236  1.00 29.95           C  
ATOM   4194  C   ASP F 334      13.707  18.055  24.745  1.00 19.71           C  
ATOM   4195  O   ASP F 334      12.967  17.391  25.471  1.00 22.96           O  
ATOM   4196  CB  ASP F 334      15.035  18.903  26.687  1.00 33.27           C  
ATOM   4197  CG  ASP F 334      14.315  20.245  26.833  1.00 51.32           C  
ATOM   4198  OD1 ASP F 334      14.083  20.668  27.988  1.00 65.70           O  
ATOM   4199  OD2 ASP F 334      13.989  20.875  25.796  1.00 52.96           O  
ATOM   4200  N   ARG F 335      13.337  18.489  23.535  1.00 20.04           N  
ATOM   4201  CA  ARG F 335      12.093  18.030  22.885  1.00 13.90           C  
ATOM   4202  C   ARG F 335      12.372  17.037  21.782  1.00  9.08           C  
ATOM   4203  O   ARG F 335      11.812  17.106  20.690  1.00  8.78           O  
ATOM   4204  CB  ARG F 335      11.240  19.206  22.388  1.00 11.62           C  
ATOM   4205  CG  ARG F 335      11.080  20.234  23.474  1.00  4.93           C  
ATOM   4206  CD  ARG F 335       9.969  21.164  23.285  1.00 15.09           C  
ATOM   4207  NE  ARG F 335       9.875  22.093  24.408  1.00 21.24           N  
ATOM   4208  CZ  ARG F 335       9.023  23.112  24.472  1.00 23.60           C  
ATOM   4209  NH1 ARG F 335       8.207  23.365  23.465  1.00 19.28           N  
ATOM   4210  NH2 ARG F 335       8.993  23.894  25.540  1.00 30.99           N  
ATOM   4211  N   GLU F 336      13.238  16.087  22.095  1.00  8.89           N  
ATOM   4212  CA  GLU F 336      13.422  14.908  21.254  1.00 12.01           C  
ATOM   4213  C   GLU F 336      13.496  13.750  22.272  1.00  8.27           C  
ATOM   4214  O   GLU F 336      14.063  13.926  23.331  1.00 14.57           O  
ATOM   4215  CB  GLU F 336      14.699  15.056  20.402  1.00  9.94           C  
ATOM   4216  CG  GLU F 336      15.971  15.042  21.197  1.00 27.40           C  
ATOM   4217  CD  GLU F 336      17.193  15.222  20.342  1.00 25.24           C  
ATOM   4218  OE1 GLU F 336      17.475  16.376  19.977  1.00 43.86           O  
ATOM   4219  OE2 GLU F 336      17.867  14.213  20.044  1.00 33.28           O  
ATOM   4220  N   THR F 337      12.830  12.626  22.010  1.00 10.22           N  
ATOM   4221  CA  THR F 337      12.899  11.478  22.911  1.00 12.14           C  
ATOM   4222  C   THR F 337      12.916  10.190  22.103  1.00  8.83           C  
ATOM   4223  O   THR F 337      12.108   9.975  21.204  1.00 10.51           O  
ATOM   4224  CB  THR F 337      11.724  11.427  23.951  1.00 12.09           C  
ATOM   4225  OG1 THR F 337      11.546  12.704  24.579  1.00  4.73           O  
ATOM   4226  CG2 THR F 337      11.997  10.354  25.045  1.00  2.00           C  
ATOM   4227  N   SER F 338      13.851   9.327  22.442  1.00  7.90           N  
ATOM   4228  CA  SER F 338      13.912   8.010  21.861  1.00  9.58           C  
ATOM   4229  C   SER F 338      13.047   7.071  22.741  1.00 13.31           C  
ATOM   4230  O   SER F 338      13.272   6.952  23.964  1.00 12.61           O  
ATOM   4231  CB  SER F 338      15.385   7.589  21.738  1.00 11.39           C  
ATOM   4232  OG  SER F 338      15.548   6.211  21.489  1.00  8.75           O  
ATOM   4233  N   VAL F 339      12.025   6.461  22.133  1.00  8.81           N  
ATOM   4234  CA  VAL F 339      11.124   5.530  22.843  1.00 15.50           C  
ATOM   4235  C   VAL F 339      11.211   4.114  22.234  1.00 20.58           C  
ATOM   4236  O   VAL F 339      11.806   3.905  21.182  1.00 12.30           O  
ATOM   4237  CB  VAL F 339       9.655   6.007  22.795  1.00 23.12           C  
ATOM   4238  CG1 VAL F 339       9.517   7.433  23.354  1.00 27.20           C  
ATOM   4239  CG2 VAL F 339       9.120   5.961  21.373  1.00 12.31           C  
ATOM   4240  OXT VAL F 339      10.678   3.131  22.753  1.00 15.58           O  
TER    4241      VAL F 339                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
