
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  123 ( 1785),  selected  123 , name 1ueq_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 1ueq_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      M       1           -
LGA    S     2_A      H       2           -
LGA    S     3_A      H       3           -
LGA    G     4_A      H       4           -
LGA    S     5_A      H       5           -
LGA    S     6_A      H       6           -
LGA    G     7_A      H       7           -
LGA    L     8_A      S       8           -
LGA    F     9_A      S       9           -
LGA    T    10_A      G      10           -
LGA    R    11_A      V      11           -
LGA    D    12_A      D      12           -
LGA    A    13_A      L      13           -
LGA    S    14_A      G      14           -
LGA    Q    15_A      T      15           -
LGA    L    16_A      E      16           -
LGA    K    17_A      N      17           -
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    -       -      F      20           -
LGA    G    18_A      Q      21          4.411
LGA    T    19_A      S      22          2.510
LGA    F    20_A      M      23          2.232
LGA    -       -      P      24           -
LGA    L    21_A      R      25          0.964
LGA    S    22_A      S      26          1.166
LGA    T    23_A      I      27          1.073
LGA    T    24_A      R      28          0.643
LGA    L    25_A      F      29          0.286
LGA    K    26_A      T      30          2.028
LGA    K    27_A      A      31          2.326
LGA    S    28_A      E      32          1.280
LGA    N    29_A      E      33          1.329
LGA    M    30_A      G      34          3.089
LGA    G    31_A      D      35          1.966
LGA    F    32_A      L      36          1.828
LGA    G    33_A      G      37          2.194
LGA    F    34_A      F      38          1.871
LGA    T    35_A      T      39          1.877
LGA    I    36_A      L      40          1.271
LGA    I    37_A      R      41          1.168
LGA    G    38_A      G      42          2.140
LGA    G    39_A      N      43          3.319
LGA    D    40_A      -       -           -
LGA    E    41_A      -       -           -
LGA    P    42_A      -       -           -
LGA    D    43_A      -       -           -
LGA    E    44_A      A      44          2.944
LGA    F    45_A      P      45          2.014
LGA    L    46_A      V      46          1.042
LGA    Q    47_A      Q      47          0.668
LGA    V    48_A      V      48          0.552
LGA    K    49_A      H      49          1.209
LGA    S    50_A      F      50          1.835
LGA    V    51_A      L      51          1.266
LGA    I    52_A      D      52          1.211
LGA    P    53_A      P      53          2.393
LGA    D    54_A      Y      54          1.553
LGA    G    55_A      C      55          1.454
LGA    P    56_A      S      56          1.506
LGA    A    57_A      A      57          1.656
LGA    A    58_A      S      58          1.945
LGA    Q    59_A      V      59          2.179
LGA    D    60_A      A      60          2.325
LGA    G    61_A      -       -           -
LGA    K    62_A      G      61          0.764
LGA    M    63_A      A      62          0.557
LGA    E    64_A      R      63          0.280
LGA    T    65_A      E      64          0.527
LGA    G    66_A      G      65          0.446
LGA    D    67_A      D      66          0.542
LGA    V    68_A      Y      67          0.797
LGA    I    69_A      I      68          0.780
LGA    V    70_A      V      69          0.475
LGA    Y    71_A      S      70          0.366
LGA    I    72_A      I      71          0.897
LGA    N    73_A      Q      72          2.049
LGA    E    74_A      L      73          1.699
LGA    V    75_A      V      74          0.166
LGA    C    76_A      D      75          0.346
LGA    V    77_A      C      76          1.027
LGA    L    78_A      K      77          0.750
LGA    G    79_A      W      78          0.989
LGA    H    80_A      L      79          0.900
LGA    T    81_A      T      80          1.660
LGA    H    82_A      L      81          1.430
LGA    A    83_A      S      82          1.557
LGA    D    84_A      E      83          1.299
LGA    V    85_A      V      84          0.919
LGA    V    86_A      M      85          0.782
LGA    K    87_A      K      86          0.584
LGA    L    88_A      L      87          0.452
LGA    F    89_A      L      88          0.968
LGA    Q    90_A      K      89          0.924
LGA    S    91_A      S      90          0.734
LGA    V    92_A      F      91          1.019
LGA    P    93_A      G      92          1.396
LGA    I    94_A      E      93          1.918
LGA    G    95_A      -       -           -
LGA    Q    96_A      D      94          0.506
LGA    S    97_A      E      95          0.867
LGA    V    98_A      I      96          1.364
LGA    N    99_A      E      97          0.801
LGA    L   100_A      M      98          0.563
LGA    V   101_A      K      99          0.601
LGA    L   102_A      V     100          0.755
LGA    C   103_A      V     101          1.198
LGA    R   104_A      S     102          1.987
LGA    G   105_A      L     103          2.530
LGA    Y   106_A      L     104          4.742
LGA    P   107_A      -       -           -
LGA    L   108_A      -       -           -
LGA    P   109_A      -       -           -
LGA    F   110_A      -       -           -
LGA    D   111_A      -       -           -
LGA    P   112_A      -       -           -
LGA    E   113_A      -       -           -
LGA    D   114_A      -       -           -
LGA    P   115_A      -       -           -
LGA    A   116_A      -       -           -
LGA    N   117_A      -       -           -
LGA    S   118_A      -       -           -
LGA    G   119_A      -       -           -
LGA    P   120_A      -       -           -
LGA    S   121_A      -       -           -
LGA    S   122_A      -       -           -
LGA    G   123_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  123  104    5.0     83    1.63    24.10     73.187     4.802

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.660873 * X  +   0.574338 * Y  +   0.483097 * Z  +  15.993649
  Y_new =  -0.574455 * X  +  -0.801350 * Y  +   0.166849 * Z  +  23.789873
  Z_new =   0.482958 * X  +  -0.167252 * Y  +   0.859522 * Z  +   7.413976 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.192185    2.949407  [ DEG:   -11.0114    168.9886 ]
  Theta =  -0.504029   -2.637563  [ DEG:   -28.8787   -151.1213 ]
  Phi   =  -2.426036    0.715557  [ DEG:  -139.0016     40.9984 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ueq_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ueq_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  123  104   5.0   83   1.63   24.10  73.187
REMARK  ---------------------------------------------------------- 
MOLECULE 1ueq_A
HEADER    SIGNALING PROTEIN                       20-MAY-03   1UEQ              
TITLE     SOLUTION STRUCTURE OF THE FIRST PDZ DOMAIN OF HUMAN                   
TITLE    2 ATROPHIN-1 INTERACTING PROTEIN 1 (KIAA0705 PROTEIN)                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MEMBRANE ASSOCIATED GUANYLATE KINASE INVERTED-2            
COMPND   3 (MAGI-2);                                                            
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: PDZ DOMAIN;                                                
COMPND   6 SYNONYM: KIAA0705 PROTEIN;                                           
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KAZUSA CDNA HG03359;                                           
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P021030-27;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    ATROPHIN-1 INTERACTING PROTEIN 1, PDZ DOMAIN, STRUCTURAL              
KEYWDS   2 GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   3 RSGI                                                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    C.ZHAO,T.KIGAWA,N.TOCHIO,S.KOSHIBA,M.INOUE,S.YOKOYAMA,RIKEN           
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   20-NOV-03 1UEQ    0                                                
JRNL        AUTH   C.ZHAO,T.KIGAWA,N.TOCHIO,S.KOSHIBA,M.INOUE,                  
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE FIRST PDZ DOMAIN OF                
JRNL        TITL 2 HUMAN ATROPHIN-1 INTERACTING PROTEIN 1 (KIAA0705             
JRNL        TITL 3 PROTEIN)                                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1UEQ A    8   118  UNP    Q86UL8   AIP1_HUMAN     454    564             
SEQRES   1 A  123  GLY SER SER GLY SER SER GLY LEU PHE THR ARG ASP ALA          
SEQRES   2 A  123  SER GLN LEU LYS GLY THR PHE LEU SER THR THR LEU LYS          
SEQRES   3 A  123  LYS SER ASN MET GLY PHE GLY PHE THR ILE ILE GLY GLY          
SEQRES   4 A  123  ASP GLU PRO ASP GLU PHE LEU GLN VAL LYS SER VAL ILE          
SEQRES   5 A  123  PRO ASP GLY PRO ALA ALA GLN ASP GLY LYS MET GLU THR          
SEQRES   6 A  123  GLY ASP VAL ILE VAL TYR ILE ASN GLU VAL CYS VAL LEU          
SEQRES   7 A  123  GLY HIS THR HIS ALA ASP VAL VAL LYS LEU PHE GLN SER          
SEQRES   8 A  123  VAL PRO ILE GLY GLN SER VAL ASN LEU VAL LEU CYS ARG          
SEQRES   9 A  123  GLY TYR PRO LEU PRO PHE ASP PRO GLU ASP PRO ALA ASN          
SEQRES  10 A  123  SER GLY PRO SER SER GLY                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1       3.281  25.662  34.024  1.00  0.00           N  
ATOM      2  CA  GLY A   1       3.286  24.202  33.856  1.00  0.00           C  
ATOM      3  C   GLY A   1       2.979  23.860  32.413  1.00  0.00           C  
ATOM      4  O   GLY A   1       3.714  24.263  31.510  1.00  0.00           O  
ATOM      5  HA2 GLY A   1       4.265  23.803  34.121  1.00  0.00           H  
ATOM      6  HA3 GLY A   1       2.525  23.764  34.502  1.00  0.00           H  
ATOM      7  H1  GLY A   1       4.005  26.146  33.533  1.00  0.00           H  
ATOM      8  N   SER A   2       1.900  23.122  32.168  1.00  0.00           N  
ATOM      9  CA  SER A   2       1.312  22.954  30.847  1.00  0.00           C  
ATOM     10  C   SER A   2       0.741  24.295  30.352  1.00  0.00           C  
ATOM     11  O   SER A   2       0.462  25.179  31.165  1.00  0.00           O  
ATOM     12  CB  SER A   2       0.223  21.879  30.973  1.00  0.00           C  
ATOM     13  OG  SER A   2      -0.624  22.145  32.085  1.00  0.00           O  
ATOM     14  H   SER A   2       1.319  22.770  32.916  1.00  0.00           H  
ATOM     15  HA  SER A   2       2.078  22.613  30.151  1.00  0.00           H  
ATOM     16  HB2 SER A   2      -0.365  21.853  30.056  1.00  0.00           H  
ATOM     17  HB3 SER A   2       0.695  20.906  31.113  1.00  0.00           H  
ATOM     18  HG  SER A   2      -1.335  22.737  31.743  1.00  0.00           H  
ATOM     19  N   SER A   3       0.509  24.444  29.048  1.00  0.00           N  
ATOM     20  CA  SER A   3      -0.212  25.584  28.493  1.00  0.00           C  
ATOM     21  C   SER A   3      -0.869  25.162  27.179  1.00  0.00           C  
ATOM     22  O   SER A   3      -0.582  24.085  26.635  1.00  0.00           O  
ATOM     23  CB  SER A   3       0.756  26.767  28.319  1.00  0.00           C  
ATOM     24  OG  SER A   3       0.101  27.992  28.020  1.00  0.00           O  
ATOM     25  H   SER A   3       0.731  23.700  28.401  1.00  0.00           H  
ATOM     26  HA  SER A   3      -0.997  25.872  29.195  1.00  0.00           H  
ATOM     27  HB2 SER A   3       1.294  26.910  29.255  1.00  0.00           H  
ATOM     28  HB3 SER A   3       1.471  26.538  27.526  1.00  0.00           H  
ATOM     29  HG  SER A   3       0.804  28.613  27.781  1.00  0.00           H  
ATOM     30  N   GLY A   4      -1.764  26.013  26.684  1.00  0.00           N  
ATOM     31  CA  GLY A   4      -2.624  25.750  25.546  1.00  0.00           C  
ATOM     32  C   GLY A   4      -1.880  25.790  24.218  1.00  0.00           C  
ATOM     33  O   GLY A   4      -0.658  25.969  24.166  1.00  0.00           O  
ATOM     34  H   GLY A   4      -1.873  26.897  27.157  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      -3.082  24.769  25.674  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      -3.409  26.505  25.525  1.00  0.00           H  
ATOM     37  N   SER A   5      -2.646  25.619  23.144  1.00  0.00           N  
ATOM     38  CA  SER A   5      -2.202  25.717  21.765  1.00  0.00           C  
ATOM     39  C   SER A   5      -3.401  26.108  20.899  1.00  0.00           C  
ATOM     40  O   SER A   5      -4.533  25.717  21.195  1.00  0.00           O  
ATOM     41  CB  SER A   5      -1.605  24.371  21.330  1.00  0.00           C  
ATOM     42  OG  SER A   5      -2.433  23.283  21.726  1.00  0.00           O  
ATOM     43  H   SER A   5      -3.643  25.476  23.265  1.00  0.00           H  
ATOM     44  HA  SER A   5      -1.435  26.488  21.685  1.00  0.00           H  
ATOM     45  HB2 SER A   5      -1.471  24.362  20.247  1.00  0.00           H  
ATOM     46  HB3 SER A   5      -0.629  24.261  21.805  1.00  0.00           H  
ATOM     47  HG  SER A   5      -2.892  22.953  20.921  1.00  0.00           H  
ATOM     48  N   SER A   6      -3.151  26.865  19.834  1.00  0.00           N  
ATOM     49  CA  SER A   6      -4.010  27.155  18.687  1.00  0.00           C  
ATOM     50  C   SER A   6      -3.196  28.075  17.763  1.00  0.00           C  
ATOM     51  O   SER A   6      -1.991  28.245  17.989  1.00  0.00           O  
ATOM     52  CB  SER A   6      -5.398  27.704  19.086  1.00  0.00           C  
ATOM     53  OG  SER A   6      -5.379  28.583  20.201  1.00  0.00           O  
ATOM     54  H   SER A   6      -2.213  27.224  19.689  1.00  0.00           H  
ATOM     55  HA  SER A   6      -4.171  26.221  18.147  1.00  0.00           H  
ATOM     56  HB2 SER A   6      -5.856  28.209  18.237  1.00  0.00           H  
ATOM     57  HB3 SER A   6      -6.042  26.858  19.332  1.00  0.00           H  
ATOM     58  HG  SER A   6      -5.856  28.102  20.915  1.00  0.00           H  
ATOM     59  N   GLY A   7      -3.794  28.623  16.705  1.00  0.00           N  
ATOM     60  CA  GLY A   7      -3.123  29.525  15.775  1.00  0.00           C  
ATOM     61  C   GLY A   7      -3.386  29.098  14.338  1.00  0.00           C  
ATOM     62  O   GLY A   7      -4.127  28.140  14.083  1.00  0.00           O  
ATOM     63  H   GLY A   7      -4.762  28.406  16.507  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      -3.496  30.539  15.928  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      -2.046  29.529  15.947  1.00  0.00           H  
ATOM     66  N   LEU A   8      -2.825  29.847  13.390  1.00  0.00           N  
ATOM     67  CA  LEU A   8      -2.973  29.634  11.956  1.00  0.00           C  
ATOM     68  C   LEU A   8      -1.660  30.025  11.286  1.00  0.00           C  
ATOM     69  O   LEU A   8      -1.507  31.182  10.887  1.00  0.00           O  
ATOM     70  CB  LEU A   8      -4.153  30.437  11.368  1.00  0.00           C  
ATOM     71  CG  LEU A   8      -5.535  29.834  11.676  1.00  0.00           C  
ATOM     72  CD1 LEU A   8      -6.190  30.510  12.885  1.00  0.00           C  
ATOM     73  CD2 LEU A   8      -6.475  29.995  10.481  1.00  0.00           C  
ATOM     74  H   LEU A   8      -2.174  30.576  13.677  1.00  0.00           H  
ATOM     75  HA  LEU A   8      -3.154  28.579  11.766  1.00  0.00           H  
ATOM     76  HB2 LEU A   8      -4.112  31.472  11.706  1.00  0.00           H  
ATOM     77  HB3 LEU A   8      -4.020  30.458  10.286  1.00  0.00           H  
ATOM     78  HG  LEU A   8      -5.433  28.768  11.871  1.00  0.00           H  
ATOM     79 HD11 LEU A   8      -7.161  30.062  13.089  1.00  0.00           H  
ATOM     80 HD12 LEU A   8      -5.571  30.415  13.771  1.00  0.00           H  
ATOM     81 HD13 LEU A   8      -6.322  31.568  12.677  1.00  0.00           H  
ATOM     82 HD21 LEU A   8      -6.588  31.050  10.236  1.00  0.00           H  
ATOM     83 HD22 LEU A   8      -6.063  29.472   9.618  1.00  0.00           H  
ATOM     84 HD23 LEU A   8      -7.447  29.564  10.713  1.00  0.00           H  
ATOM     85  N   PHE A   9      -0.724  29.073  11.179  1.00  0.00           N  
ATOM     86  CA  PHE A   9       0.603  29.240  10.582  1.00  0.00           C  
ATOM     87  C   PHE A   9       1.383  30.420  11.212  1.00  0.00           C  
ATOM     88  O   PHE A   9       0.955  31.032  12.192  1.00  0.00           O  
ATOM     89  CB  PHE A   9       0.414  29.264   9.047  1.00  0.00           C  
ATOM     90  CG  PHE A   9       1.578  29.709   8.181  1.00  0.00           C  
ATOM     91  CD1 PHE A   9       1.788  31.085   7.976  1.00  0.00           C  
ATOM     92  CD2 PHE A   9       2.426  28.778   7.549  1.00  0.00           C  
ATOM     93  CE1 PHE A   9       2.829  31.513   7.146  1.00  0.00           C  
ATOM     94  CE2 PHE A   9       3.498  29.221   6.747  1.00  0.00           C  
ATOM     95  CZ  PHE A   9       3.687  30.598   6.554  1.00  0.00           C  
ATOM     96  H   PHE A   9      -0.969  28.145  11.492  1.00  0.00           H  
ATOM     97  HA  PHE A   9       1.175  28.340  10.811  1.00  0.00           H  
ATOM     98  HB2 PHE A   9       0.126  28.259   8.743  1.00  0.00           H  
ATOM     99  HB3 PHE A   9      -0.432  29.910   8.809  1.00  0.00           H  
ATOM    100  HD1 PHE A   9       1.176  31.814   8.491  1.00  0.00           H  
ATOM    101  HD2 PHE A   9       2.258  27.718   7.670  1.00  0.00           H  
ATOM    102  HE1 PHE A   9       3.002  32.541   6.905  1.00  0.00           H  
ATOM    103  HE2 PHE A   9       4.150  28.516   6.245  1.00  0.00           H  
ATOM    104  HZ  PHE A   9       4.451  31.028   5.937  1.00  0.00           H  
ATOM    105  N   THR A  10       2.597  30.690  10.732  1.00  0.00           N  
ATOM    106  CA  THR A  10       3.402  31.824  11.149  1.00  0.00           C  
ATOM    107  C   THR A  10       3.055  33.037  10.269  1.00  0.00           C  
ATOM    108  O   THR A  10       1.891  33.433  10.241  1.00  0.00           O  
ATOM    109  CB  THR A  10       4.881  31.393  11.157  1.00  0.00           C  
ATOM    110  OG1 THR A  10       5.036  30.125  11.761  1.00  0.00           O  
ATOM    111  CG2 THR A  10       5.770  32.338  11.964  1.00  0.00           C  
ATOM    112  H   THR A  10       2.923  30.183   9.924  1.00  0.00           H  
ATOM    113  HA  THR A  10       3.097  32.087  12.152  1.00  0.00           H  
ATOM    114  HB  THR A  10       5.243  31.335  10.132  1.00  0.00           H  
ATOM    115  HG1 THR A  10       5.222  29.462  11.078  1.00  0.00           H  
ATOM    116 HG21 THR A  10       6.805  32.022  11.854  1.00  0.00           H  
ATOM    117 HG22 THR A  10       5.666  33.363  11.617  1.00  0.00           H  
ATOM    118 HG23 THR A  10       5.496  32.285  13.016  1.00  0.00           H  
ATOM    119  N   ARG A  11       4.039  33.606   9.561  1.00  0.00           N  
ATOM    120  CA  ARG A  11       4.051  34.660   8.550  1.00  0.00           C  
ATOM    121  C   ARG A  11       5.381  35.360   8.658  1.00  0.00           C  
ATOM    122  O   ARG A  11       6.340  34.961   8.007  1.00  0.00           O  
ATOM    123  CB  ARG A  11       2.835  35.612   8.541  1.00  0.00           C  
ATOM    124  CG  ARG A  11       1.819  35.089   7.517  1.00  0.00           C  
ATOM    125  CD  ARG A  11       0.410  35.640   7.716  1.00  0.00           C  
ATOM    126  NE  ARG A  11      -0.468  35.066   6.691  1.00  0.00           N  
ATOM    127  CZ  ARG A  11      -1.793  35.164   6.603  1.00  0.00           C  
ATOM    128  NH1 ARG A  11      -2.475  35.927   7.451  1.00  0.00           N  
ATOM    129  NH2 ARG A  11      -2.416  34.488   5.650  1.00  0.00           N  
ATOM    130  H   ARG A  11       4.970  33.265   9.725  1.00  0.00           H  
ATOM    131  HA  ARG A  11       4.082  34.162   7.587  1.00  0.00           H  
ATOM    132  HB2 ARG A  11       2.407  35.703   9.535  1.00  0.00           H  
ATOM    133  HB3 ARG A  11       3.135  36.613   8.230  1.00  0.00           H  
ATOM    134  HG2 ARG A  11       2.152  35.383   6.524  1.00  0.00           H  
ATOM    135  HG3 ARG A  11       1.789  33.996   7.543  1.00  0.00           H  
ATOM    136  HD2 ARG A  11       0.049  35.364   8.709  1.00  0.00           H  
ATOM    137  HD3 ARG A  11       0.430  36.727   7.615  1.00  0.00           H  
ATOM    138  HE  ARG A  11      -0.015  34.475   5.994  1.00  0.00           H  
ATOM    139 HH11 ARG A  11      -2.005  36.367   8.227  1.00  0.00           H  
ATOM    140 HH12 ARG A  11      -3.492  35.973   7.447  1.00  0.00           H  
ATOM    141 HH21 ARG A  11      -1.863  33.899   5.030  1.00  0.00           H  
ATOM    142 HH22 ARG A  11      -3.432  34.412   5.620  1.00  0.00           H  
ATOM    143  N   ASP A  12       5.510  36.308   9.575  1.00  0.00           N  
ATOM    144  CA  ASP A  12       6.666  37.204   9.592  1.00  0.00           C  
ATOM    145  C   ASP A  12       7.868  36.618  10.351  1.00  0.00           C  
ATOM    146  O   ASP A  12       8.732  37.350  10.838  1.00  0.00           O  
ATOM    147  CB  ASP A  12       6.229  38.560  10.148  1.00  0.00           C  
ATOM    148  CG  ASP A  12       7.245  39.665   9.843  1.00  0.00           C  
ATOM    149  OD1 ASP A  12       8.006  39.571   8.855  1.00  0.00           O  
ATOM    150  OD2 ASP A  12       7.269  40.669  10.591  1.00  0.00           O  
ATOM    151  H   ASP A  12       4.712  36.506  10.162  1.00  0.00           H  
ATOM    152  HA  ASP A  12       6.964  37.362   8.556  1.00  0.00           H  
ATOM    153  HB2 ASP A  12       5.275  38.828   9.696  1.00  0.00           H  
ATOM    154  HB3 ASP A  12       6.078  38.474  11.224  1.00  0.00           H  
ATOM    155  N   ALA A  13       7.878  35.295  10.559  1.00  0.00           N  
ATOM    156  CA  ALA A  13       8.719  34.509  11.460  1.00  0.00           C  
ATOM    157  C   ALA A  13       8.605  34.897  12.939  1.00  0.00           C  
ATOM    158  O   ALA A  13       8.951  34.098  13.806  1.00  0.00           O  
ATOM    159  CB  ALA A  13      10.173  34.546  10.998  1.00  0.00           C  
ATOM    160  H   ALA A  13       7.175  34.781  10.053  1.00  0.00           H  
ATOM    161  HA  ALA A  13       8.394  33.473  11.376  1.00  0.00           H  
ATOM    162  HB1 ALA A  13      10.733  33.777  11.531  1.00  0.00           H  
ATOM    163  HB2 ALA A  13      10.217  34.364   9.924  1.00  0.00           H  
ATOM    164  HB3 ALA A  13      10.609  35.521  11.215  1.00  0.00           H  
ATOM    165  N   SER A  14       8.079  36.078  13.252  1.00  0.00           N  
ATOM    166  CA  SER A  14       8.115  36.657  14.577  1.00  0.00           C  
ATOM    167  C   SER A  14       7.290  35.831  15.564  1.00  0.00           C  
ATOM    168  O   SER A  14       7.559  35.856  16.765  1.00  0.00           O  
ATOM    169  CB  SER A  14       7.577  38.086  14.471  1.00  0.00           C  
ATOM    170  OG  SER A  14       8.278  38.951  15.337  1.00  0.00           O  
ATOM    171  H   SER A  14       7.846  36.713  12.504  1.00  0.00           H  
ATOM    172  HA  SER A  14       9.158  36.674  14.894  1.00  0.00           H  
ATOM    173  HB2 SER A  14       7.681  38.451  13.451  1.00  0.00           H  
ATOM    174  HB3 SER A  14       6.518  38.095  14.723  1.00  0.00           H  
ATOM    175  HG  SER A  14       8.825  39.538  14.787  1.00  0.00           H  
ATOM    176  N   GLN A  15       6.284  35.107  15.068  1.00  0.00           N  
ATOM    177  CA  GLN A  15       5.380  34.307  15.877  1.00  0.00           C  
ATOM    178  C   GLN A  15       5.972  32.936  16.229  1.00  0.00           C  
ATOM    179  O   GLN A  15       5.328  32.206  16.982  1.00  0.00           O  
ATOM    180  CB  GLN A  15       4.012  34.179  15.178  1.00  0.00           C  
ATOM    181  CG  GLN A  15       3.376  35.538  14.825  1.00  0.00           C  
ATOM    182  CD  GLN A  15       3.827  36.117  13.480  1.00  0.00           C  
ATOM    183  OE1 GLN A  15       3.852  35.438  12.456  1.00  0.00           O  
ATOM    184  NE2 GLN A  15       4.193  37.385  13.441  1.00  0.00           N  
ATOM    185  H   GLN A  15       6.149  35.110  14.071  1.00  0.00           H  
ATOM    186  HA  GLN A  15       5.212  34.828  16.821  1.00  0.00           H  
ATOM    187  HB2 GLN A  15       4.097  33.564  14.282  1.00  0.00           H  
ATOM    188  HB3 GLN A  15       3.335  33.669  15.867  1.00  0.00           H  
ATOM    189  HG2 GLN A  15       2.291  35.417  14.791  1.00  0.00           H  
ATOM    190  HG3 GLN A  15       3.619  36.255  15.610  1.00  0.00           H  
ATOM    191 HE21 GLN A  15       4.110  37.948  14.292  1.00  0.00           H  
ATOM    192 HE22 GLN A  15       4.401  37.842  12.569  1.00  0.00           H  
ATOM    193  N   LEU A  16       7.163  32.569  15.721  1.00  0.00           N  
ATOM    194  CA  LEU A  16       7.856  31.380  16.220  1.00  0.00           C  
ATOM    195  C   LEU A  16       8.284  31.634  17.669  1.00  0.00           C  
ATOM    196  O   LEU A  16       8.387  32.779  18.122  1.00  0.00           O  
ATOM    197  CB  LEU A  16       9.080  30.979  15.363  1.00  0.00           C  
ATOM    198  CG  LEU A  16       8.825  30.739  13.860  1.00  0.00           C  
ATOM    199  CD1 LEU A  16      10.099  30.268  13.151  1.00  0.00           C  
ATOM    200  CD2 LEU A  16       7.725  29.709  13.598  1.00  0.00           C  
ATOM    201  H   LEU A  16       7.700  33.225  15.166  1.00  0.00           H  
ATOM    202  HA  LEU A  16       7.151  30.550  16.219  1.00  0.00           H  
ATOM    203  HB2 LEU A  16       9.849  31.742  15.465  1.00  0.00           H  
ATOM    204  HB3 LEU A  16       9.493  30.062  15.784  1.00  0.00           H  
ATOM    205  HG  LEU A  16       8.533  31.677  13.400  1.00  0.00           H  
ATOM    206 HD11 LEU A  16       9.918  30.193  12.078  1.00  0.00           H  
ATOM    207 HD12 LEU A  16      10.905  30.979  13.315  1.00  0.00           H  
ATOM    208 HD13 LEU A  16      10.404  29.291  13.529  1.00  0.00           H  
ATOM    209 HD21 LEU A  16       7.982  28.755  14.050  1.00  0.00           H  
ATOM    210 HD22 LEU A  16       6.778  30.057  14.007  1.00  0.00           H  
ATOM    211 HD23 LEU A  16       7.601  29.557  12.525  1.00  0.00           H  
ATOM    212  N   LYS A  17       8.583  30.560  18.396  1.00  0.00           N  
ATOM    213  CA  LYS A  17       9.048  30.579  19.767  1.00  0.00           C  
ATOM    214  C   LYS A  17      10.357  29.826  19.786  1.00  0.00           C  
ATOM    215  O   LYS A  17      10.371  28.644  19.426  1.00  0.00           O  
ATOM    216  CB  LYS A  17       8.005  29.896  20.649  1.00  0.00           C  
ATOM    217  CG  LYS A  17       6.818  30.806  20.967  1.00  0.00           C  
ATOM    218  CD  LYS A  17       7.156  31.910  21.966  1.00  0.00           C  
ATOM    219  CE  LYS A  17       5.854  32.665  22.237  1.00  0.00           C  
ATOM    220  NZ  LYS A  17       5.805  33.196  23.608  1.00  0.00           N  
ATOM    221  H   LYS A  17       8.491  29.628  18.025  1.00  0.00           H  
ATOM    222  HA  LYS A  17       9.219  31.599  20.104  1.00  0.00           H  
ATOM    223  HB2 LYS A  17       7.643  29.000  20.144  1.00  0.00           H  
ATOM    224  HB3 LYS A  17       8.479  29.572  21.567  1.00  0.00           H  
ATOM    225  HG2 LYS A  17       6.435  31.255  20.049  1.00  0.00           H  
ATOM    226  HG3 LYS A  17       6.035  30.189  21.406  1.00  0.00           H  
ATOM    227  HD2 LYS A  17       7.541  31.455  22.879  1.00  0.00           H  
ATOM    228  HD3 LYS A  17       7.901  32.594  21.561  1.00  0.00           H  
ATOM    229  HE2 LYS A  17       5.758  33.475  21.511  1.00  0.00           H  
ATOM    230  HE3 LYS A  17       5.017  31.977  22.102  1.00  0.00           H  
ATOM    231  HZ1 LYS A  17       6.581  33.834  23.761  1.00  0.00           H  
ATOM    232  HZ2 LYS A  17       4.928  33.689  23.744  1.00  0.00           H  
ATOM    233  HZ3 LYS A  17       5.838  32.423  24.270  1.00  0.00           H  
ATOM    234  N   GLY A  18      11.435  30.521  20.119  1.00  0.00           N  
ATOM    235  CA  GLY A  18      12.782  29.994  20.082  1.00  0.00           C  
ATOM    236  C   GLY A  18      13.803  31.121  20.128  1.00  0.00           C  
ATOM    237  O   GLY A  18      13.446  32.293  20.322  1.00  0.00           O  
ATOM    238  H   GLY A  18      11.332  31.475  20.434  1.00  0.00           H  
ATOM    239  HA2 GLY A  18      12.938  29.328  20.931  1.00  0.00           H  
ATOM    240  HA3 GLY A  18      12.914  29.442  19.151  1.00  0.00           H  
ATOM    241  N   THR A  19      15.073  30.776  19.930  1.00  0.00           N  
ATOM    242  CA  THR A  19      16.110  31.741  19.581  1.00  0.00           C  
ATOM    243  C   THR A  19      16.117  31.871  18.051  1.00  0.00           C  
ATOM    244  O   THR A  19      15.538  31.035  17.352  1.00  0.00           O  
ATOM    245  CB  THR A  19      17.472  31.267  20.130  1.00  0.00           C  
ATOM    246  OG1 THR A  19      17.315  30.653  21.396  1.00  0.00           O  
ATOM    247  CG2 THR A  19      18.480  32.414  20.277  1.00  0.00           C  
ATOM    248  H   THR A  19      15.289  29.795  19.767  1.00  0.00           H  
ATOM    249  HA  THR A  19      15.858  32.704  20.027  1.00  0.00           H  
ATOM    250  HB  THR A  19      17.882  30.524  19.447  1.00  0.00           H  
ATOM    251  HG1 THR A  19      17.721  31.222  22.082  1.00  0.00           H  
ATOM    252 HG21 THR A  19      18.051  33.222  20.871  1.00  0.00           H  
ATOM    253 HG22 THR A  19      19.376  32.051  20.776  1.00  0.00           H  
ATOM    254 HG23 THR A  19      18.768  32.800  19.301  1.00  0.00           H  
ATOM    255  N   PHE A  20      16.791  32.891  17.521  1.00  0.00           N  
ATOM    256  CA  PHE A  20      17.049  33.078  16.101  1.00  0.00           C  
ATOM    257  C   PHE A  20      18.550  33.262  15.934  1.00  0.00           C  
ATOM    258  O   PHE A  20      19.190  33.938  16.744  1.00  0.00           O  
ATOM    259  CB  PHE A  20      16.281  34.298  15.585  1.00  0.00           C  
ATOM    260  CG  PHE A  20      14.884  33.972  15.108  1.00  0.00           C  
ATOM    261  CD1 PHE A  20      13.849  33.691  16.024  1.00  0.00           C  
ATOM    262  CD2 PHE A  20      14.614  33.990  13.728  1.00  0.00           C  
ATOM    263  CE1 PHE A  20      12.555  33.396  15.554  1.00  0.00           C  
ATOM    264  CE2 PHE A  20      13.316  33.728  13.269  1.00  0.00           C  
ATOM    265  CZ  PHE A  20      12.294  33.396  14.171  1.00  0.00           C  
ATOM    266  H   PHE A  20      17.276  33.549  18.117  1.00  0.00           H  
ATOM    267  HA  PHE A  20      16.742  32.198  15.532  1.00  0.00           H  
ATOM    268  HB2 PHE A  20      16.236  35.068  16.355  1.00  0.00           H  
ATOM    269  HB3 PHE A  20      16.836  34.723  14.749  1.00  0.00           H  
ATOM    270  HD1 PHE A  20      14.035  33.701  17.090  1.00  0.00           H  
ATOM    271  HD2 PHE A  20      15.392  34.234  13.016  1.00  0.00           H  
ATOM    272  HE1 PHE A  20      11.765  33.175  16.262  1.00  0.00           H  
ATOM    273  HE2 PHE A  20      13.110  33.796  12.214  1.00  0.00           H  
ATOM    274  HZ  PHE A  20      11.314  33.147  13.786  1.00  0.00           H  
ATOM    275  N   LEU A  21      19.132  32.605  14.937  1.00  0.00           N  
ATOM    276  CA  LEU A  21      20.563  32.576  14.694  1.00  0.00           C  
ATOM    277  C   LEU A  21      20.828  32.338  13.214  1.00  0.00           C  
ATOM    278  O   LEU A  21      19.941  31.904  12.472  1.00  0.00           O  
ATOM    279  CB  LEU A  21      21.257  31.504  15.559  1.00  0.00           C  
ATOM    280  CG  LEU A  21      20.501  30.195  15.884  1.00  0.00           C  
ATOM    281  CD1 LEU A  21      19.476  30.343  17.017  1.00  0.00           C  
ATOM    282  CD2 LEU A  21      19.905  29.481  14.669  1.00  0.00           C  
ATOM    283  H   LEU A  21      18.602  31.995  14.322  1.00  0.00           H  
ATOM    284  HA  LEU A  21      20.984  33.548  14.951  1.00  0.00           H  
ATOM    285  HB2 LEU A  21      22.194  31.227  15.077  1.00  0.00           H  
ATOM    286  HB3 LEU A  21      21.557  31.980  16.491  1.00  0.00           H  
ATOM    287  HG  LEU A  21      21.238  29.518  16.273  1.00  0.00           H  
ATOM    288 HD11 LEU A  21      18.476  30.514  16.620  1.00  0.00           H  
ATOM    289 HD12 LEU A  21      19.478  29.428  17.598  1.00  0.00           H  
ATOM    290 HD13 LEU A  21      19.762  31.159  17.679  1.00  0.00           H  
ATOM    291 HD21 LEU A  21      19.644  28.459  14.942  1.00  0.00           H  
ATOM    292 HD22 LEU A  21      19.013  29.988  14.320  1.00  0.00           H  
ATOM    293 HD23 LEU A  21      20.627  29.448  13.856  1.00  0.00           H  
ATOM    294  N   SER A  22      22.063  32.605  12.794  1.00  0.00           N  
ATOM    295  CA  SER A  22      22.463  32.527  11.399  1.00  0.00           C  
ATOM    296  C   SER A  22      23.896  32.026  11.229  1.00  0.00           C  
ATOM    297  O   SER A  22      24.713  32.070  12.151  1.00  0.00           O  
ATOM    298  CB  SER A  22      22.307  33.917  10.761  1.00  0.00           C  
ATOM    299  OG  SER A  22      20.954  34.310  10.694  1.00  0.00           O  
ATOM    300  H   SER A  22      22.759  32.911  13.472  1.00  0.00           H  
ATOM    301  HA  SER A  22      21.811  31.821  10.892  1.00  0.00           H  
ATOM    302  HB2 SER A  22      22.866  34.649  11.337  1.00  0.00           H  
ATOM    303  HB3 SER A  22      22.700  33.896   9.747  1.00  0.00           H  
ATOM    304  HG  SER A  22      20.538  33.653  10.120  1.00  0.00           H  
ATOM    305  N   THR A  23      24.216  31.604  10.006  1.00  0.00           N  
ATOM    306  CA  THR A  23      25.556  31.228   9.580  1.00  0.00           C  
ATOM    307  C   THR A  23      25.689  31.568   8.087  1.00  0.00           C  
ATOM    308  O   THR A  23      24.689  31.636   7.359  1.00  0.00           O  
ATOM    309  CB  THR A  23      25.833  29.740   9.916  1.00  0.00           C  
ATOM    310  OG1 THR A  23      27.034  29.322   9.311  1.00  0.00           O  
ATOM    311  CG2 THR A  23      24.754  28.751   9.464  1.00  0.00           C  
ATOM    312  H   THR A  23      23.515  31.601   9.270  1.00  0.00           H  
ATOM    313  HA  THR A  23      26.277  31.833  10.129  1.00  0.00           H  
ATOM    314  HB  THR A  23      25.943  29.626  10.996  1.00  0.00           H  
ATOM    315  HG1 THR A  23      27.715  29.170  10.014  1.00  0.00           H  
ATOM    316 HG21 THR A  23      25.071  27.744   9.747  1.00  0.00           H  
ATOM    317 HG22 THR A  23      23.812  28.973   9.967  1.00  0.00           H  
ATOM    318 HG23 THR A  23      24.613  28.817   8.383  1.00  0.00           H  
ATOM    319  N   THR A  24      26.926  31.744   7.624  1.00  0.00           N  
ATOM    320  CA  THR A  24      27.293  31.770   6.219  1.00  0.00           C  
ATOM    321  C   THR A  24      28.183  30.557   5.956  1.00  0.00           C  
ATOM    322  O   THR A  24      29.300  30.501   6.473  1.00  0.00           O  
ATOM    323  CB  THR A  24      27.980  33.092   5.845  1.00  0.00           C  
ATOM    324  OG1 THR A  24      27.092  34.172   6.042  1.00  0.00           O  
ATOM    325  CG2 THR A  24      28.383  33.097   4.365  1.00  0.00           C  
ATOM    326  H   THR A  24      27.694  31.569   8.259  1.00  0.00           H  
ATOM    327  HA  THR A  24      26.397  31.689   5.619  1.00  0.00           H  
ATOM    328  HB  THR A  24      28.870  33.238   6.456  1.00  0.00           H  
ATOM    329  HG1 THR A  24      27.331  34.602   6.890  1.00  0.00           H  
ATOM    330 HG21 THR A  24      27.515  32.888   3.742  1.00  0.00           H  
ATOM    331 HG22 THR A  24      28.787  34.066   4.082  1.00  0.00           H  
ATOM    332 HG23 THR A  24      29.151  32.344   4.188  1.00  0.00           H  
ATOM    333  N   LEU A  25      27.713  29.603   5.145  1.00  0.00           N  
ATOM    334  CA  LEU A  25      28.525  28.491   4.676  1.00  0.00           C  
ATOM    335  C   LEU A  25      29.008  28.841   3.281  1.00  0.00           C  
ATOM    336  O   LEU A  25      28.201  29.226   2.427  1.00  0.00           O  
ATOM    337  CB  LEU A  25      27.731  27.177   4.578  1.00  0.00           C  
ATOM    338  CG  LEU A  25      27.088  26.611   5.859  1.00  0.00           C  
ATOM    339  CD1 LEU A  25      26.958  25.099   5.693  1.00  0.00           C  
ATOM    340  CD2 LEU A  25      27.886  26.869   7.141  1.00  0.00           C  
ATOM    341  H   LEU A  25      26.760  29.661   4.797  1.00  0.00           H  
ATOM    342  HA  LEU A  25      29.377  28.342   5.337  1.00  0.00           H  
ATOM    343  HB2 LEU A  25      26.935  27.309   3.845  1.00  0.00           H  
ATOM    344  HB3 LEU A  25      28.424  26.433   4.181  1.00  0.00           H  
ATOM    345  HG  LEU A  25      26.069  26.999   5.956  1.00  0.00           H  
ATOM    346 HD11 LEU A  25      26.483  24.893   4.744  1.00  0.00           H  
ATOM    347 HD12 LEU A  25      27.940  24.626   5.717  1.00  0.00           H  
ATOM    348 HD13 LEU A  25      26.332  24.718   6.494  1.00  0.00           H  
ATOM    349 HD21 LEU A  25      28.887  26.442   7.069  1.00  0.00           H  
ATOM    350 HD22 LEU A  25      27.985  27.938   7.310  1.00  0.00           H  
ATOM    351 HD23 LEU A  25      27.367  26.451   8.003  1.00  0.00           H  
ATOM    352  N   LYS A  26      30.300  28.657   3.004  1.00  0.00           N  
ATOM    353  CA  LYS A  26      30.794  28.631   1.629  1.00  0.00           C  
ATOM    354  C   LYS A  26      30.625  27.202   1.107  1.00  0.00           C  
ATOM    355  O   LYS A  26      30.936  26.244   1.820  1.00  0.00           O  
ATOM    356  CB  LYS A  26      32.248  29.138   1.600  1.00  0.00           C  
ATOM    357  CG  LYS A  26      32.740  29.482   0.181  1.00  0.00           C  
ATOM    358  CD  LYS A  26      34.156  30.090   0.183  1.00  0.00           C  
ATOM    359  CE  LYS A  26      34.178  31.473   0.856  1.00  0.00           C  
ATOM    360  NZ  LYS A  26      35.494  32.143   0.789  1.00  0.00           N  
ATOM    361  H   LYS A  26      30.918  28.342   3.750  1.00  0.00           H  
ATOM    362  HA  LYS A  26      30.162  29.296   1.038  1.00  0.00           H  
ATOM    363  HB2 LYS A  26      32.295  30.039   2.212  1.00  0.00           H  
ATOM    364  HB3 LYS A  26      32.909  28.389   2.040  1.00  0.00           H  
ATOM    365  HG2 LYS A  26      32.751  28.572  -0.422  1.00  0.00           H  
ATOM    366  HG3 LYS A  26      32.049  30.195  -0.278  1.00  0.00           H  
ATOM    367  HD2 LYS A  26      34.843  29.417   0.698  1.00  0.00           H  
ATOM    368  HD3 LYS A  26      34.481  30.194  -0.854  1.00  0.00           H  
ATOM    369  HE2 LYS A  26      33.441  32.110   0.364  1.00  0.00           H  
ATOM    370  HE3 LYS A  26      33.889  31.373   1.902  1.00  0.00           H  
ATOM    371  HZ1 LYS A  26      36.198  31.627   1.313  1.00  0.00           H  
ATOM    372  HZ2 LYS A  26      35.777  32.268  -0.180  1.00  0.00           H  
ATOM    373  HZ3 LYS A  26      35.428  33.067   1.209  1.00  0.00           H  
ATOM    374  N   LYS A  27      30.074  27.046  -0.093  1.00  0.00           N  
ATOM    375  CA  LYS A  27      29.777  25.782  -0.758  1.00  0.00           C  
ATOM    376  C   LYS A  27      31.090  25.164  -1.233  1.00  0.00           C  
ATOM    377  O   LYS A  27      31.565  25.514  -2.310  1.00  0.00           O  
ATOM    378  CB  LYS A  27      28.792  26.076  -1.907  1.00  0.00           C  
ATOM    379  CG  LYS A  27      28.278  24.809  -2.608  1.00  0.00           C  
ATOM    380  CD  LYS A  27      26.880  25.043  -3.190  1.00  0.00           C  
ATOM    381  CE  LYS A  27      26.432  23.906  -4.117  1.00  0.00           C  
ATOM    382  NZ  LYS A  27      24.986  23.985  -4.412  1.00  0.00           N  
ATOM    383  H   LYS A  27      29.865  27.890  -0.613  1.00  0.00           H  
ATOM    384  HA  LYS A  27      29.300  25.115  -0.039  1.00  0.00           H  
ATOM    385  HB2 LYS A  27      27.945  26.617  -1.487  1.00  0.00           H  
ATOM    386  HB3 LYS A  27      29.254  26.735  -2.644  1.00  0.00           H  
ATOM    387  HG2 LYS A  27      28.970  24.522  -3.398  1.00  0.00           H  
ATOM    388  HG3 LYS A  27      28.230  24.002  -1.885  1.00  0.00           H  
ATOM    389  HD2 LYS A  27      26.178  25.136  -2.362  1.00  0.00           H  
ATOM    390  HD3 LYS A  27      26.885  25.977  -3.754  1.00  0.00           H  
ATOM    391  HE2 LYS A  27      26.991  23.977  -5.052  1.00  0.00           H  
ATOM    392  HE3 LYS A  27      26.649  22.940  -3.663  1.00  0.00           H  
ATOM    393  HZ1 LYS A  27      24.736  23.327  -5.145  1.00  0.00           H  
ATOM    394  HZ2 LYS A  27      24.419  23.762  -3.597  1.00  0.00           H  
ATOM    395  HZ3 LYS A  27      24.754  24.905  -4.772  1.00  0.00           H  
ATOM    396  N   SER A  28      31.696  24.291  -0.438  1.00  0.00           N  
ATOM    397  CA  SER A  28      32.988  23.692  -0.731  1.00  0.00           C  
ATOM    398  C   SER A  28      32.775  22.353  -1.405  1.00  0.00           C  
ATOM    399  O   SER A  28      32.221  21.428  -0.790  1.00  0.00           O  
ATOM    400  CB  SER A  28      33.785  23.512   0.551  1.00  0.00           C  
ATOM    401  OG  SER A  28      34.377  24.758   0.874  1.00  0.00           O  
ATOM    402  H   SER A  28      31.200  23.912   0.362  1.00  0.00           H  
ATOM    403  HA  SER A  28      33.553  24.345  -1.402  1.00  0.00           H  
ATOM    404  HB2 SER A  28      33.128  23.153   1.357  1.00  0.00           H  
ATOM    405  HB3 SER A  28      34.584  22.789   0.375  1.00  0.00           H  
ATOM    406  HG  SER A  28      35.337  24.586   1.021  1.00  0.00           H  
ATOM    407  N   ASN A  29      33.208  22.279  -2.667  1.00  0.00           N  
ATOM    408  CA  ASN A  29      32.907  21.208  -3.612  1.00  0.00           C  
ATOM    409  C   ASN A  29      31.400  20.908  -3.562  1.00  0.00           C  
ATOM    410  O   ASN A  29      30.618  21.776  -3.167  1.00  0.00           O  
ATOM    411  CB  ASN A  29      33.878  20.023  -3.384  1.00  0.00           C  
ATOM    412  CG  ASN A  29      35.143  20.173  -4.225  1.00  0.00           C  
ATOM    413  OD1 ASN A  29      35.836  21.189  -4.164  1.00  0.00           O  
ATOM    414  ND2 ASN A  29      35.458  19.202  -5.060  1.00  0.00           N  
ATOM    415  H   ASN A  29      33.670  23.099  -3.037  1.00  0.00           H  
ATOM    416  HA  ASN A  29      33.105  21.583  -4.616  1.00  0.00           H  
ATOM    417  HB2 ASN A  29      34.159  19.963  -2.332  1.00  0.00           H  
ATOM    418  HB3 ASN A  29      33.407  19.078  -3.640  1.00  0.00           H  
ATOM    419 HD21 ASN A  29      34.914  18.356  -5.147  1.00  0.00           H  
ATOM    420 HD22 ASN A  29      36.284  19.280  -5.644  1.00  0.00           H  
ATOM    421  N   MET A  30      31.002  19.717  -4.006  1.00  0.00           N  
ATOM    422  CA  MET A  30      29.735  19.022  -3.778  1.00  0.00           C  
ATOM    423  C   MET A  30      28.530  19.900  -3.410  1.00  0.00           C  
ATOM    424  O   MET A  30      27.633  20.073  -4.233  1.00  0.00           O  
ATOM    425  CB  MET A  30      29.945  17.911  -2.732  1.00  0.00           C  
ATOM    426  CG  MET A  30      31.060  16.937  -3.129  1.00  0.00           C  
ATOM    427  SD  MET A  30      31.022  15.364  -2.242  1.00  0.00           S  
ATOM    428  CE  MET A  30      32.417  14.496  -3.001  1.00  0.00           C  
ATOM    429  H   MET A  30      31.707  19.144  -4.444  1.00  0.00           H  
ATOM    430  HA  MET A  30      29.472  18.530  -4.717  1.00  0.00           H  
ATOM    431  HB2 MET A  30      30.190  18.345  -1.763  1.00  0.00           H  
ATOM    432  HB3 MET A  30      29.013  17.355  -2.629  1.00  0.00           H  
ATOM    433  HG2 MET A  30      30.968  16.724  -4.188  1.00  0.00           H  
ATOM    434  HG3 MET A  30      32.026  17.409  -2.954  1.00  0.00           H  
ATOM    435  HE1 MET A  30      32.558  13.541  -2.499  1.00  0.00           H  
ATOM    436  HE2 MET A  30      32.210  14.314  -4.056  1.00  0.00           H  
ATOM    437  HE3 MET A  30      33.322  15.094  -2.899  1.00  0.00           H  
ATOM    438  N   GLY A  31      28.432  20.390  -2.172  1.00  0.00           N  
ATOM    439  CA  GLY A  31      27.196  20.914  -1.625  1.00  0.00           C  
ATOM    440  C   GLY A  31      27.356  21.151  -0.135  1.00  0.00           C  
ATOM    441  O   GLY A  31      28.363  20.735   0.452  1.00  0.00           O  
ATOM    442  H   GLY A  31      29.248  20.436  -1.566  1.00  0.00           H  
ATOM    443  HA2 GLY A  31      26.938  21.847  -2.118  1.00  0.00           H  
ATOM    444  HA3 GLY A  31      26.401  20.191  -1.792  1.00  0.00           H  
ATOM    445  N   PHE A  32      26.403  21.852   0.477  1.00  0.00           N  
ATOM    446  CA  PHE A  32      26.541  22.253   1.870  1.00  0.00           C  
ATOM    447  C   PHE A  32      26.556  21.023   2.771  1.00  0.00           C  
ATOM    448  O   PHE A  32      25.949  19.998   2.447  1.00  0.00           O  
ATOM    449  CB  PHE A  32      25.442  23.234   2.289  1.00  0.00           C  
ATOM    450  CG  PHE A  32      25.281  24.425   1.369  1.00  0.00           C  
ATOM    451  CD1 PHE A  32      26.131  25.538   1.507  1.00  0.00           C  
ATOM    452  CD2 PHE A  32      24.283  24.424   0.376  1.00  0.00           C  
ATOM    453  CE1 PHE A  32      25.963  26.660   0.680  1.00  0.00           C  
ATOM    454  CE2 PHE A  32      24.133  25.535  -0.471  1.00  0.00           C  
ATOM    455  CZ  PHE A  32      24.956  26.661  -0.300  1.00  0.00           C  
ATOM    456  H   PHE A  32      25.565  22.118  -0.019  1.00  0.00           H  
ATOM    457  HA  PHE A  32      27.498  22.757   1.966  1.00  0.00           H  
ATOM    458  HB2 PHE A  32      24.488  22.728   2.402  1.00  0.00           H  
ATOM    459  HB3 PHE A  32      25.696  23.596   3.278  1.00  0.00           H  
ATOM    460  HD1 PHE A  32      26.904  25.545   2.261  1.00  0.00           H  
ATOM    461  HD2 PHE A  32      23.621  23.576   0.268  1.00  0.00           H  
ATOM    462  HE1 PHE A  32      26.601  27.524   0.813  1.00  0.00           H  
ATOM    463  HE2 PHE A  32      23.376  25.534  -1.242  1.00  0.00           H  
ATOM    464  HZ  PHE A  32      24.805  27.532  -0.915  1.00  0.00           H  
ATOM    465  N   GLY A  33      27.213  21.114   3.926  1.00  0.00           N  
ATOM    466  CA  GLY A  33      27.312  19.988   4.842  1.00  0.00           C  
ATOM    467  C   GLY A  33      26.055  19.819   5.687  1.00  0.00           C  
ATOM    468  O   GLY A  33      26.172  19.588   6.882  1.00  0.00           O  
ATOM    469  H   GLY A  33      27.676  21.980   4.162  1.00  0.00           H  
ATOM    470  HA2 GLY A  33      27.470  19.081   4.261  1.00  0.00           H  
ATOM    471  HA3 GLY A  33      28.166  20.088   5.503  1.00  0.00           H  
ATOM    472  N   PHE A  34      24.859  19.920   5.111  1.00  0.00           N  
ATOM    473  CA  PHE A  34      23.600  19.573   5.757  1.00  0.00           C  
ATOM    474  C   PHE A  34      22.581  19.263   4.664  1.00  0.00           C  
ATOM    475  O   PHE A  34      22.795  19.636   3.506  1.00  0.00           O  
ATOM    476  CB  PHE A  34      23.139  20.731   6.652  1.00  0.00           C  
ATOM    477  CG  PHE A  34      22.767  22.003   5.913  1.00  0.00           C  
ATOM    478  CD1 PHE A  34      23.767  22.925   5.551  1.00  0.00           C  
ATOM    479  CD2 PHE A  34      21.418  22.286   5.624  1.00  0.00           C  
ATOM    480  CE1 PHE A  34      23.428  24.145   4.941  1.00  0.00           C  
ATOM    481  CE2 PHE A  34      21.080  23.497   4.994  1.00  0.00           C  
ATOM    482  CZ  PHE A  34      22.077  24.433   4.666  1.00  0.00           C  
ATOM    483  H   PHE A  34      24.798  20.044   4.103  1.00  0.00           H  
ATOM    484  HA  PHE A  34      23.746  18.683   6.372  1.00  0.00           H  
ATOM    485  HB2 PHE A  34      22.288  20.403   7.249  1.00  0.00           H  
ATOM    486  HB3 PHE A  34      23.934  20.960   7.362  1.00  0.00           H  
ATOM    487  HD1 PHE A  34      24.799  22.722   5.792  1.00  0.00           H  
ATOM    488  HD2 PHE A  34      20.639  21.597   5.920  1.00  0.00           H  
ATOM    489  HE1 PHE A  34      24.211  24.873   4.746  1.00  0.00           H  
ATOM    490  HE2 PHE A  34      20.042  23.743   4.815  1.00  0.00           H  
ATOM    491  HZ  PHE A  34      21.779  25.392   4.252  1.00  0.00           H  
ATOM    492  N   THR A  35      21.463  18.629   5.009  1.00  0.00           N  
ATOM    493  CA  THR A  35      20.355  18.396   4.090  1.00  0.00           C  
ATOM    494  C   THR A  35      19.053  18.819   4.766  1.00  0.00           C  
ATOM    495  O   THR A  35      19.003  18.927   5.993  1.00  0.00           O  
ATOM    496  CB  THR A  35      20.337  16.940   3.592  1.00  0.00           C  
ATOM    497  OG1 THR A  35      20.073  15.996   4.619  1.00  0.00           O  
ATOM    498  CG2 THR A  35      21.635  16.546   2.882  1.00  0.00           C  
ATOM    499  H   THR A  35      21.291  18.427   5.992  1.00  0.00           H  
ATOM    500  HA  THR A  35      20.490  19.033   3.218  1.00  0.00           H  
ATOM    501  HB  THR A  35      19.531  16.861   2.859  1.00  0.00           H  
ATOM    502  HG1 THR A  35      20.684  16.102   5.366  1.00  0.00           H  
ATOM    503 HG21 THR A  35      22.471  16.509   3.580  1.00  0.00           H  
ATOM    504 HG22 THR A  35      21.506  15.568   2.425  1.00  0.00           H  
ATOM    505 HG23 THR A  35      21.861  17.266   2.092  1.00  0.00           H  
ATOM    506  N   ILE A  36      18.003  19.072   3.986  1.00  0.00           N  
ATOM    507  CA  ILE A  36      16.767  19.687   4.443  1.00  0.00           C  
ATOM    508  C   ILE A  36      15.608  18.700   4.215  1.00  0.00           C  
ATOM    509  O   ILE A  36      15.758  17.722   3.469  1.00  0.00           O  
ATOM    510  CB  ILE A  36      16.619  21.065   3.739  1.00  0.00           C  
ATOM    511  CG1 ILE A  36      17.910  21.921   3.836  1.00  0.00           C  
ATOM    512  CG2 ILE A  36      15.495  21.909   4.356  1.00  0.00           C  
ATOM    513  CD1 ILE A  36      18.841  21.801   2.623  1.00  0.00           C  
ATOM    514  H   ILE A  36      18.077  19.037   2.982  1.00  0.00           H  
ATOM    515  HA  ILE A  36      16.832  19.874   5.511  1.00  0.00           H  
ATOM    516  HB  ILE A  36      16.388  20.905   2.688  1.00  0.00           H  
ATOM    517 HG12 ILE A  36      17.641  22.968   3.889  1.00  0.00           H  
ATOM    518 HG13 ILE A  36      18.455  21.687   4.753  1.00  0.00           H  
ATOM    519 HG21 ILE A  36      14.530  21.424   4.226  1.00  0.00           H  
ATOM    520 HG22 ILE A  36      15.709  22.042   5.416  1.00  0.00           H  
ATOM    521 HG23 ILE A  36      15.433  22.884   3.871  1.00  0.00           H  
ATOM    522 HD11 ILE A  36      19.354  20.845   2.605  1.00  0.00           H  
ATOM    523 HD12 ILE A  36      18.272  21.918   1.702  1.00  0.00           H  
ATOM    524 HD13 ILE A  36      19.579  22.600   2.676  1.00  0.00           H  
ATOM    525  N   ILE A  37      14.488  18.935   4.898  1.00  0.00           N  
ATOM    526  CA  ILE A  37      13.180  18.316   4.738  1.00  0.00           C  
ATOM    527  C   ILE A  37      12.161  19.457   4.719  1.00  0.00           C  
ATOM    528  O   ILE A  37      12.350  20.490   5.369  1.00  0.00           O  
ATOM    529  CB  ILE A  37      12.924  17.278   5.860  1.00  0.00           C  
ATOM    530  CG1 ILE A  37      11.550  16.583   5.738  1.00  0.00           C  
ATOM    531  CG2 ILE A  37      13.131  17.836   7.281  1.00  0.00           C  
ATOM    532  CD1 ILE A  37      11.365  15.402   6.707  1.00  0.00           C  
ATOM    533  H   ILE A  37      14.466  19.732   5.531  1.00  0.00           H  
ATOM    534  HA  ILE A  37      13.149  17.803   3.774  1.00  0.00           H  
ATOM    535  HB  ILE A  37      13.666  16.513   5.700  1.00  0.00           H  
ATOM    536 HG12 ILE A  37      10.753  17.304   5.918  1.00  0.00           H  
ATOM    537 HG13 ILE A  37      11.445  16.200   4.722  1.00  0.00           H  
ATOM    538 HG21 ILE A  37      13.032  17.052   8.032  1.00  0.00           H  
ATOM    539 HG22 ILE A  37      14.133  18.235   7.395  1.00  0.00           H  
ATOM    540 HG23 ILE A  37      12.399  18.620   7.479  1.00  0.00           H  
ATOM    541 HD11 ILE A  37      12.216  14.722   6.648  1.00  0.00           H  
ATOM    542 HD12 ILE A  37      11.258  15.753   7.734  1.00  0.00           H  
ATOM    543 HD13 ILE A  37      10.459  14.859   6.446  1.00  0.00           H  
ATOM    544  N   GLY A  38      11.094  19.286   3.952  1.00  0.00           N  
ATOM    545  CA  GLY A  38       9.907  20.125   4.008  1.00  0.00           C  
ATOM    546  C   GLY A  38       8.669  19.264   3.831  1.00  0.00           C  
ATOM    547  O   GLY A  38       8.738  18.248   3.133  1.00  0.00           O  
ATOM    548  H   GLY A  38      10.975  18.377   3.525  1.00  0.00           H  
ATOM    549  HA2 GLY A  38       9.858  20.633   4.973  1.00  0.00           H  
ATOM    550  HA3 GLY A  38       9.937  20.868   3.219  1.00  0.00           H  
ATOM    551  N   GLY A  39       7.557  19.708   4.411  1.00  0.00           N  
ATOM    552  CA  GLY A  39       6.312  18.981   4.600  1.00  0.00           C  
ATOM    553  C   GLY A  39       5.642  18.387   3.373  1.00  0.00           C  
ATOM    554  O   GLY A  39       4.686  17.644   3.557  1.00  0.00           O  
ATOM    555  H   GLY A  39       7.648  20.512   5.017  1.00  0.00           H  
ATOM    556  HA2 GLY A  39       6.446  18.206   5.334  1.00  0.00           H  
ATOM    557  HA3 GLY A  39       5.604  19.660   5.044  1.00  0.00           H  
ATOM    558  N   ASP A  40       6.086  18.758   2.169  1.00  0.00           N  
ATOM    559  CA  ASP A  40       5.616  18.389   0.821  1.00  0.00           C  
ATOM    560  C   ASP A  40       4.659  19.470   0.344  1.00  0.00           C  
ATOM    561  O   ASP A  40       4.730  19.928  -0.798  1.00  0.00           O  
ATOM    562  CB  ASP A  40       4.904  17.021   0.753  1.00  0.00           C  
ATOM    563  CG  ASP A  40       4.788  16.444  -0.659  1.00  0.00           C  
ATOM    564  OD1 ASP A  40       5.634  16.759  -1.523  1.00  0.00           O  
ATOM    565  OD2 ASP A  40       3.924  15.562  -0.875  1.00  0.00           O  
ATOM    566  H   ASP A  40       6.818  19.450   2.206  1.00  0.00           H  
ATOM    567  HA  ASP A  40       6.480  18.366   0.161  1.00  0.00           H  
ATOM    568  HB2 ASP A  40       5.454  16.307   1.358  1.00  0.00           H  
ATOM    569  HB3 ASP A  40       3.900  17.110   1.173  1.00  0.00           H  
ATOM    570  N   GLU A  41       3.797  19.893   1.264  1.00  0.00           N  
ATOM    571  CA  GLU A  41       2.762  20.900   1.114  1.00  0.00           C  
ATOM    572  C   GLU A  41       3.357  22.318   0.986  1.00  0.00           C  
ATOM    573  O   GLU A  41       4.474  22.559   1.455  1.00  0.00           O  
ATOM    574  CB  GLU A  41       1.853  20.784   2.347  1.00  0.00           C  
ATOM    575  CG  GLU A  41       0.839  19.642   2.196  1.00  0.00           C  
ATOM    576  CD  GLU A  41      -0.418  20.124   1.470  1.00  0.00           C  
ATOM    577  OE1 GLU A  41      -1.322  20.643   2.165  1.00  0.00           O  
ATOM    578  OE2 GLU A  41      -0.476  20.020   0.221  1.00  0.00           O  
ATOM    579  H   GLU A  41       3.889  19.448   2.171  1.00  0.00           H  
ATOM    580  HA  GLU A  41       2.192  20.671   0.215  1.00  0.00           H  
ATOM    581  HB2 GLU A  41       2.467  20.613   3.235  1.00  0.00           H  
ATOM    582  HB3 GLU A  41       1.316  21.715   2.498  1.00  0.00           H  
ATOM    583  HG2 GLU A  41       1.285  18.805   1.657  1.00  0.00           H  
ATOM    584  HG3 GLU A  41       0.570  19.281   3.189  1.00  0.00           H  
ATOM    585  N   PRO A  42       2.613  23.278   0.403  1.00  0.00           N  
ATOM    586  CA  PRO A  42       3.107  24.606   0.040  1.00  0.00           C  
ATOM    587  C   PRO A  42       2.942  25.635   1.180  1.00  0.00           C  
ATOM    588  O   PRO A  42       2.700  26.816   0.919  1.00  0.00           O  
ATOM    589  CB  PRO A  42       2.288  24.953  -1.212  1.00  0.00           C  
ATOM    590  CG  PRO A  42       0.908  24.413  -0.849  1.00  0.00           C  
ATOM    591  CD  PRO A  42       1.257  23.115  -0.122  1.00  0.00           C  
ATOM    592  HA  PRO A  42       4.163  24.556  -0.220  1.00  0.00           H  
ATOM    593  HB2 PRO A  42       2.263  26.015  -1.437  1.00  0.00           H  
ATOM    594  HB3 PRO A  42       2.679  24.406  -2.070  1.00  0.00           H  
ATOM    595  HG2 PRO A  42       0.407  25.102  -0.168  1.00  0.00           H  
ATOM    596  HG3 PRO A  42       0.299  24.229  -1.736  1.00  0.00           H  
ATOM    597  HD2 PRO A  42       0.534  22.922   0.672  1.00  0.00           H  
ATOM    598  HD3 PRO A  42       1.248  22.304  -0.841  1.00  0.00           H  
ATOM    599  N   ASP A  43       2.990  25.173   2.431  1.00  0.00           N  
ATOM    600  CA  ASP A  43       2.959  25.944   3.674  1.00  0.00           C  
ATOM    601  C   ASP A  43       3.158  24.894   4.775  1.00  0.00           C  
ATOM    602  O   ASP A  43       2.201  24.423   5.405  1.00  0.00           O  
ATOM    603  CB  ASP A  43       1.646  26.744   3.875  1.00  0.00           C  
ATOM    604  CG  ASP A  43       1.718  28.233   3.514  1.00  0.00           C  
ATOM    605  OD1 ASP A  43       2.777  28.882   3.638  1.00  0.00           O  
ATOM    606  OD2 ASP A  43       0.645  28.816   3.214  1.00  0.00           O  
ATOM    607  H   ASP A  43       3.303  24.220   2.530  1.00  0.00           H  
ATOM    608  HA  ASP A  43       3.803  26.638   3.684  1.00  0.00           H  
ATOM    609  HB2 ASP A  43       0.840  26.274   3.307  1.00  0.00           H  
ATOM    610  HB3 ASP A  43       1.366  26.717   4.930  1.00  0.00           H  
ATOM    611  N   GLU A  44       4.399  24.441   4.934  1.00  0.00           N  
ATOM    612  CA  GLU A  44       4.917  23.615   6.016  1.00  0.00           C  
ATOM    613  C   GLU A  44       6.311  24.158   6.328  1.00  0.00           C  
ATOM    614  O   GLU A  44       7.015  24.578   5.408  1.00  0.00           O  
ATOM    615  CB  GLU A  44       5.010  22.138   5.587  1.00  0.00           C  
ATOM    616  CG  GLU A  44       3.866  21.314   6.180  1.00  0.00           C  
ATOM    617  CD  GLU A  44       4.180  20.881   7.618  1.00  0.00           C  
ATOM    618  OE1 GLU A  44       5.276  20.330   7.866  1.00  0.00           O  
ATOM    619  OE2 GLU A  44       3.359  21.126   8.531  1.00  0.00           O  
ATOM    620  H   GLU A  44       5.150  24.791   4.356  1.00  0.00           H  
ATOM    621  HA  GLU A  44       4.285  23.720   6.901  1.00  0.00           H  
ATOM    622  HB2 GLU A  44       5.012  22.007   4.505  1.00  0.00           H  
ATOM    623  HB3 GLU A  44       5.960  21.729   5.924  1.00  0.00           H  
ATOM    624  HG2 GLU A  44       2.952  21.907   6.139  1.00  0.00           H  
ATOM    625  HG3 GLU A  44       3.713  20.432   5.563  1.00  0.00           H  
ATOM    626  N   PHE A  45       6.709  24.168   7.601  1.00  0.00           N  
ATOM    627  CA  PHE A  45       7.980  24.759   7.998  1.00  0.00           C  
ATOM    628  C   PHE A  45       9.091  23.792   7.614  1.00  0.00           C  
ATOM    629  O   PHE A  45       9.041  22.614   7.972  1.00  0.00           O  
ATOM    630  CB  PHE A  45       8.034  25.063   9.502  1.00  0.00           C  
ATOM    631  CG  PHE A  45       6.928  25.919  10.108  1.00  0.00           C  
ATOM    632  CD1 PHE A  45       5.977  26.603   9.319  1.00  0.00           C  
ATOM    633  CD2 PHE A  45       6.830  25.980  11.510  1.00  0.00           C  
ATOM    634  CE1 PHE A  45       4.889  27.248   9.930  1.00  0.00           C  
ATOM    635  CE2 PHE A  45       5.754  26.644  12.118  1.00  0.00           C  
ATOM    636  CZ  PHE A  45       4.761  27.243  11.327  1.00  0.00           C  
ATOM    637  H   PHE A  45       6.127  23.764   8.330  1.00  0.00           H  
ATOM    638  HA  PHE A  45       8.114  25.693   7.453  1.00  0.00           H  
ATOM    639  HB2 PHE A  45       8.040  24.112  10.032  1.00  0.00           H  
ATOM    640  HB3 PHE A  45       8.987  25.545   9.710  1.00  0.00           H  
ATOM    641  HD1 PHE A  45       6.036  26.608   8.240  1.00  0.00           H  
ATOM    642  HD2 PHE A  45       7.560  25.478  12.129  1.00  0.00           H  
ATOM    643  HE1 PHE A  45       4.127  27.696   9.312  1.00  0.00           H  
ATOM    644  HE2 PHE A  45       5.670  26.652  13.194  1.00  0.00           H  
ATOM    645  HZ  PHE A  45       3.895  27.688  11.793  1.00  0.00           H  
ATOM    646  N   LEU A  46      10.104  24.285   6.911  1.00  0.00           N  
ATOM    647  CA  LEU A  46      11.213  23.465   6.439  1.00  0.00           C  
ATOM    648  C   LEU A  46      12.198  23.286   7.592  1.00  0.00           C  
ATOM    649  O   LEU A  46      12.390  24.213   8.384  1.00  0.00           O  
ATOM    650  CB  LEU A  46      11.917  24.196   5.293  1.00  0.00           C  
ATOM    651  CG  LEU A  46      11.017  24.445   4.064  1.00  0.00           C  
ATOM    652  CD1 LEU A  46      11.165  25.900   3.631  1.00  0.00           C  
ATOM    653  CD2 LEU A  46      11.402  23.541   2.896  1.00  0.00           C  
ATOM    654  H   LEU A  46      10.084  25.264   6.670  1.00  0.00           H  
ATOM    655  HA  LEU A  46      10.844  22.499   6.095  1.00  0.00           H  
ATOM    656  HB2 LEU A  46      12.252  25.151   5.689  1.00  0.00           H  
ATOM    657  HB3 LEU A  46      12.804  23.633   4.999  1.00  0.00           H  
ATOM    658  HG  LEU A  46       9.970  24.263   4.304  1.00  0.00           H  
ATOM    659 HD11 LEU A  46      12.214  26.144   3.479  1.00  0.00           H  
ATOM    660 HD12 LEU A  46      10.599  26.079   2.715  1.00  0.00           H  
ATOM    661 HD13 LEU A  46      10.762  26.546   4.411  1.00  0.00           H  
ATOM    662 HD21 LEU A  46      10.677  23.679   2.092  1.00  0.00           H  
ATOM    663 HD22 LEU A  46      12.394  23.807   2.542  1.00  0.00           H  
ATOM    664 HD23 LEU A  46      11.397  22.504   3.222  1.00  0.00           H  
ATOM    665  N   GLN A  47      12.871  22.135   7.670  1.00  0.00           N  
ATOM    666  CA  GLN A  47      13.803  21.832   8.751  1.00  0.00           C  
ATOM    667  C   GLN A  47      15.083  21.213   8.205  1.00  0.00           C  
ATOM    668  O   GLN A  47      15.056  20.513   7.195  1.00  0.00           O  
ATOM    669  CB  GLN A  47      13.182  20.873   9.774  1.00  0.00           C  
ATOM    670  CG  GLN A  47      11.845  21.363  10.346  1.00  0.00           C  
ATOM    671  CD  GLN A  47      11.270  20.406  11.382  1.00  0.00           C  
ATOM    672  OE1 GLN A  47      10.252  19.761  11.149  1.00  0.00           O  
ATOM    673  NE2 GLN A  47      11.922  20.278  12.528  1.00  0.00           N  
ATOM    674  H   GLN A  47      12.741  21.431   6.947  1.00  0.00           H  
ATOM    675  HA  GLN A  47      14.050  22.759   9.253  1.00  0.00           H  
ATOM    676  HB2 GLN A  47      13.042  19.907   9.302  1.00  0.00           H  
ATOM    677  HB3 GLN A  47      13.889  20.742  10.593  1.00  0.00           H  
ATOM    678  HG2 GLN A  47      12.017  22.328  10.810  1.00  0.00           H  
ATOM    679  HG3 GLN A  47      11.114  21.486   9.545  1.00  0.00           H  
ATOM    680 HE21 GLN A  47      12.777  20.794  12.730  1.00  0.00           H  
ATOM    681 HE22 GLN A  47      11.482  19.824  13.319  1.00  0.00           H  
ATOM    682  N   VAL A  48      16.212  21.405   8.889  1.00  0.00           N  
ATOM    683  CA  VAL A  48      17.428  20.655   8.621  1.00  0.00           C  
ATOM    684  C   VAL A  48      17.151  19.181   8.969  1.00  0.00           C  
ATOM    685  O   VAL A  48      16.928  18.846  10.136  1.00  0.00           O  
ATOM    686  CB  VAL A  48      18.574  21.273   9.447  1.00  0.00           C  
ATOM    687  CG1 VAL A  48      19.842  20.419   9.384  1.00  0.00           C  
ATOM    688  CG2 VAL A  48      18.907  22.688   8.945  1.00  0.00           C  
ATOM    689  H   VAL A  48      16.232  22.052   9.683  1.00  0.00           H  
ATOM    690  HA  VAL A  48      17.651  20.750   7.552  1.00  0.00           H  
ATOM    691  HB  VAL A  48      18.263  21.341  10.491  1.00  0.00           H  
ATOM    692 HG11 VAL A  48      20.643  20.922   9.923  1.00  0.00           H  
ATOM    693 HG12 VAL A  48      19.664  19.463   9.876  1.00  0.00           H  
ATOM    694 HG13 VAL A  48      20.136  20.261   8.348  1.00  0.00           H  
ATOM    695 HG21 VAL A  48      19.225  22.660   7.903  1.00  0.00           H  
ATOM    696 HG22 VAL A  48      18.038  23.342   9.028  1.00  0.00           H  
ATOM    697 HG23 VAL A  48      19.707  23.106   9.555  1.00  0.00           H  
ATOM    698  N   LYS A  49      17.119  18.306   7.958  1.00  0.00           N  
ATOM    699  CA  LYS A  49      16.880  16.863   8.076  1.00  0.00           C  
ATOM    700  C   LYS A  49      18.078  16.178   8.731  1.00  0.00           C  
ATOM    701  O   LYS A  49      17.900  15.347   9.615  1.00  0.00           O  
ATOM    702  CB  LYS A  49      16.613  16.282   6.679  1.00  0.00           C  
ATOM    703  CG  LYS A  49      15.862  14.939   6.668  1.00  0.00           C  
ATOM    704  CD  LYS A  49      15.774  14.403   5.222  1.00  0.00           C  
ATOM    705  CE  LYS A  49      14.404  13.893   4.743  1.00  0.00           C  
ATOM    706  NZ  LYS A  49      14.021  12.597   5.328  1.00  0.00           N  
ATOM    707  H   LYS A  49      17.414  18.648   7.052  1.00  0.00           H  
ATOM    708  HA  LYS A  49      15.998  16.693   8.696  1.00  0.00           H  
ATOM    709  HB2 LYS A  49      16.003  16.990   6.131  1.00  0.00           H  
ATOM    710  HB3 LYS A  49      17.561  16.175   6.149  1.00  0.00           H  
ATOM    711  HG2 LYS A  49      16.398  14.221   7.286  1.00  0.00           H  
ATOM    712  HG3 LYS A  49      14.864  15.081   7.084  1.00  0.00           H  
ATOM    713  HD2 LYS A  49      16.036  15.212   4.545  1.00  0.00           H  
ATOM    714  HD3 LYS A  49      16.517  13.613   5.094  1.00  0.00           H  
ATOM    715  HE2 LYS A  49      13.628  14.627   4.955  1.00  0.00           H  
ATOM    716  HE3 LYS A  49      14.456  13.770   3.658  1.00  0.00           H  
ATOM    717  HZ1 LYS A  49      13.675  12.672   6.282  1.00  0.00           H  
ATOM    718  HZ2 LYS A  49      13.262  12.166   4.806  1.00  0.00           H  
ATOM    719  HZ3 LYS A  49      14.803  11.960   5.371  1.00  0.00           H  
ATOM    720  N   SER A  50      19.295  16.555   8.335  1.00  0.00           N  
ATOM    721  CA  SER A  50      20.522  16.179   9.009  1.00  0.00           C  
ATOM    722  C   SER A  50      21.574  17.249   8.784  1.00  0.00           C  
ATOM    723  O   SER A  50      21.553  17.958   7.772  1.00  0.00           O  
ATOM    724  CB  SER A  50      21.034  14.832   8.498  1.00  0.00           C  
ATOM    725  OG  SER A  50      21.073  14.741   7.082  1.00  0.00           O  
ATOM    726  H   SER A  50      19.418  17.244   7.607  1.00  0.00           H  
ATOM    727  HA  SER A  50      20.343  16.086  10.081  1.00  0.00           H  
ATOM    728  HB2 SER A  50      22.037  14.676   8.886  1.00  0.00           H  
ATOM    729  HB3 SER A  50      20.402  14.050   8.908  1.00  0.00           H  
ATOM    730  HG  SER A  50      21.482  13.874   6.890  1.00  0.00           H  
ATOM    731  N   VAL A  51      22.547  17.285   9.683  1.00  0.00           N  
ATOM    732  CA  VAL A  51      23.840  17.902   9.442  1.00  0.00           C  
ATOM    733  C   VAL A  51      24.748  16.775   8.929  1.00  0.00           C  
ATOM    734  O   VAL A  51      24.632  15.629   9.376  1.00  0.00           O  
ATOM    735  CB  VAL A  51      24.359  18.576  10.731  1.00  0.00           C  
ATOM    736  CG1 VAL A  51      25.640  19.369  10.446  1.00  0.00           C  
ATOM    737  CG2 VAL A  51      23.345  19.574  11.315  1.00  0.00           C  
ATOM    738  H   VAL A  51      22.498  16.598  10.425  1.00  0.00           H  
ATOM    739  HA  VAL A  51      23.737  18.662   8.670  1.00  0.00           H  
ATOM    740  HB  VAL A  51      24.552  17.806  11.479  1.00  0.00           H  
ATOM    741 HG11 VAL A  51      25.445  20.110   9.669  1.00  0.00           H  
ATOM    742 HG12 VAL A  51      25.973  19.874  11.355  1.00  0.00           H  
ATOM    743 HG13 VAL A  51      26.433  18.697  10.121  1.00  0.00           H  
ATOM    744 HG21 VAL A  51      23.752  20.000  12.234  1.00  0.00           H  
ATOM    745 HG22 VAL A  51      23.142  20.369  10.600  1.00  0.00           H  
ATOM    746 HG23 VAL A  51      22.407  19.083  11.560  1.00  0.00           H  
ATOM    747  N   ILE A  52      25.617  17.066   7.963  1.00  0.00           N  
ATOM    748  CA  ILE A  52      26.665  16.154   7.544  1.00  0.00           C  
ATOM    749  C   ILE A  52      27.753  16.214   8.625  1.00  0.00           C  
ATOM    750  O   ILE A  52      28.300  17.300   8.852  1.00  0.00           O  
ATOM    751  CB  ILE A  52      27.251  16.560   6.176  1.00  0.00           C  
ATOM    752  CG1 ILE A  52      26.264  16.585   5.009  1.00  0.00           C  
ATOM    753  CG2 ILE A  52      28.333  15.629   5.708  1.00  0.00           C  
ATOM    754  CD1 ILE A  52      25.540  15.295   4.643  1.00  0.00           C  
ATOM    755  H   ILE A  52      25.750  18.034   7.697  1.00  0.00           H  
ATOM    756  HA  ILE A  52      26.233  15.159   7.460  1.00  0.00           H  
ATOM    757  HB  ILE A  52      27.696  17.549   6.264  1.00  0.00           H  
ATOM    758 HG12 ILE A  52      25.543  17.283   5.298  1.00  0.00           H  
ATOM    759 HG13 ILE A  52      26.739  16.986   4.115  1.00  0.00           H  
ATOM    760 HG21 ILE A  52      28.521  15.865   4.667  1.00  0.00           H  
ATOM    761 HG22 ILE A  52      29.223  15.779   6.306  1.00  0.00           H  
ATOM    762 HG23 ILE A  52      27.970  14.614   5.804  1.00  0.00           H  
ATOM    763 HD11 ILE A  52      25.028  14.903   5.521  1.00  0.00           H  
ATOM    764 HD12 ILE A  52      24.811  15.526   3.867  1.00  0.00           H  
ATOM    765 HD13 ILE A  52      26.247  14.564   4.255  1.00  0.00           H  
ATOM    766  N   PRO A  53      28.107  15.084   9.260  1.00  0.00           N  
ATOM    767  CA  PRO A  53      29.272  15.035  10.127  1.00  0.00           C  
ATOM    768  C   PRO A  53      30.512  15.357   9.301  1.00  0.00           C  
ATOM    769  O   PRO A  53      30.562  14.976   8.132  1.00  0.00           O  
ATOM    770  CB  PRO A  53      29.324  13.606  10.657  1.00  0.00           C  
ATOM    771  CG  PRO A  53      28.562  12.766   9.635  1.00  0.00           C  
ATOM    772  CD  PRO A  53      27.590  13.749   8.996  1.00  0.00           C  
ATOM    773  HA  PRO A  53      29.176  15.748  10.947  1.00  0.00           H  
ATOM    774  HB2 PRO A  53      30.352  13.267  10.736  1.00  0.00           H  
ATOM    775  HB3 PRO A  53      28.822  13.555  11.618  1.00  0.00           H  
ATOM    776  HG2 PRO A  53      29.257  12.407   8.875  1.00  0.00           H  
ATOM    777  HG3 PRO A  53      28.038  11.939  10.114  1.00  0.00           H  
ATOM    778  HD2 PRO A  53      27.557  13.554   7.927  1.00  0.00           H  
ATOM    779  HD3 PRO A  53      26.598  13.648   9.433  1.00  0.00           H  
ATOM    780  N   ASP A  54      31.516  16.021   9.882  1.00  0.00           N  
ATOM    781  CA  ASP A  54      32.787  16.398   9.230  1.00  0.00           C  
ATOM    782  C   ASP A  54      32.614  17.460   8.127  1.00  0.00           C  
ATOM    783  O   ASP A  54      33.595  17.941   7.552  1.00  0.00           O  
ATOM    784  CB  ASP A  54      33.485  15.127   8.702  1.00  0.00           C  
ATOM    785  CG  ASP A  54      34.975  15.260   8.413  1.00  0.00           C  
ATOM    786  OD1 ASP A  54      35.692  15.960   9.156  1.00  0.00           O  
ATOM    787  OD2 ASP A  54      35.481  14.521   7.532  1.00  0.00           O  
ATOM    788  H   ASP A  54      31.430  16.283  10.857  1.00  0.00           H  
ATOM    789  HA  ASP A  54      33.428  16.836  10.000  1.00  0.00           H  
ATOM    790  HB2 ASP A  54      33.368  14.342   9.443  1.00  0.00           H  
ATOM    791  HB3 ASP A  54      32.989  14.796   7.793  1.00  0.00           H  
ATOM    792  N   GLY A  55      31.372  17.875   7.845  1.00  0.00           N  
ATOM    793  CA  GLY A  55      31.044  18.857   6.827  1.00  0.00           C  
ATOM    794  C   GLY A  55      31.179  20.286   7.361  1.00  0.00           C  
ATOM    795  O   GLY A  55      31.176  20.503   8.570  1.00  0.00           O  
ATOM    796  H   GLY A  55      30.612  17.496   8.397  1.00  0.00           H  
ATOM    797  HA2 GLY A  55      31.703  18.713   5.971  1.00  0.00           H  
ATOM    798  HA3 GLY A  55      30.017  18.687   6.510  1.00  0.00           H  
ATOM    799  N   PRO A  56      31.239  21.303   6.486  1.00  0.00           N  
ATOM    800  CA  PRO A  56      31.487  22.687   6.885  1.00  0.00           C  
ATOM    801  C   PRO A  56      30.394  23.251   7.792  1.00  0.00           C  
ATOM    802  O   PRO A  56      30.674  24.133   8.598  1.00  0.00           O  
ATOM    803  CB  PRO A  56      31.592  23.486   5.582  1.00  0.00           C  
ATOM    804  CG  PRO A  56      30.901  22.612   4.542  1.00  0.00           C  
ATOM    805  CD  PRO A  56      31.134  21.194   5.046  1.00  0.00           C  
ATOM    806  HA  PRO A  56      32.437  22.746   7.414  1.00  0.00           H  
ATOM    807  HB2 PRO A  56      31.121  24.468   5.656  1.00  0.00           H  
ATOM    808  HB3 PRO A  56      32.639  23.593   5.308  1.00  0.00           H  
ATOM    809  HG2 PRO A  56      29.830  22.818   4.549  1.00  0.00           H  
ATOM    810  HG3 PRO A  56      31.337  22.763   3.553  1.00  0.00           H  
ATOM    811  HD2 PRO A  56      30.312  20.542   4.743  1.00  0.00           H  
ATOM    812  HD3 PRO A  56      32.083  20.820   4.670  1.00  0.00           H  
ATOM    813  N   ALA A  57      29.164  22.748   7.674  1.00  0.00           N  
ATOM    814  CA  ALA A  57      28.059  23.149   8.528  1.00  0.00           C  
ATOM    815  C   ALA A  57      28.346  22.755   9.979  1.00  0.00           C  
ATOM    816  O   ALA A  57      28.129  23.557  10.885  1.00  0.00           O  
ATOM    817  CB  ALA A  57      26.785  22.473   8.017  1.00  0.00           C  
ATOM    818  H   ALA A  57      29.028  21.990   7.031  1.00  0.00           H  
ATOM    819  HA  ALA A  57      27.942  24.233   8.475  1.00  0.00           H  
ATOM    820  HB1 ALA A  57      26.773  21.433   8.332  1.00  0.00           H  
ATOM    821  HB2 ALA A  57      25.918  22.968   8.438  1.00  0.00           H  
ATOM    822  HB3 ALA A  57      26.722  22.528   6.932  1.00  0.00           H  
ATOM    823  N   ALA A  58      28.837  21.525  10.175  1.00  0.00           N  
ATOM    824  CA  ALA A  58      29.266  21.030  11.470  1.00  0.00           C  
ATOM    825  C   ALA A  58      30.502  21.802  11.932  1.00  0.00           C  
ATOM    826  O   ALA A  58      30.572  22.147  13.112  1.00  0.00           O  
ATOM    827  CB  ALA A  58      29.550  19.524  11.390  1.00  0.00           C  
ATOM    828  H   ALA A  58      29.015  20.924   9.383  1.00  0.00           H  
ATOM    829  HA  ALA A  58      28.461  21.192  12.193  1.00  0.00           H  
ATOM    830  HB1 ALA A  58      28.652  18.988  11.083  1.00  0.00           H  
ATOM    831  HB2 ALA A  58      30.350  19.315  10.682  1.00  0.00           H  
ATOM    832  HB3 ALA A  58      29.855  19.160  12.371  1.00  0.00           H  
ATOM    833  N   GLN A  59      31.462  22.092  11.041  1.00  0.00           N  
ATOM    834  CA  GLN A  59      32.699  22.794  11.398  1.00  0.00           C  
ATOM    835  C   GLN A  59      32.465  24.275  11.738  1.00  0.00           C  
ATOM    836  O   GLN A  59      33.323  24.872  12.385  1.00  0.00           O  
ATOM    837  CB  GLN A  59      33.763  22.681  10.285  1.00  0.00           C  
ATOM    838  CG  GLN A  59      34.169  21.232   9.958  1.00  0.00           C  
ATOM    839  CD  GLN A  59      35.683  21.041   9.859  1.00  0.00           C  
ATOM    840  OE1 GLN A  59      36.390  21.104  10.862  1.00  0.00           O  
ATOM    841  NE2 GLN A  59      36.210  20.773   8.676  1.00  0.00           N  
ATOM    842  H   GLN A  59      31.374  21.692  10.114  1.00  0.00           H  
ATOM    843  HA  GLN A  59      33.109  22.325  12.298  1.00  0.00           H  
ATOM    844  HB2 GLN A  59      33.404  23.172   9.379  1.00  0.00           H  
ATOM    845  HB3 GLN A  59      34.650  23.220  10.621  1.00  0.00           H  
ATOM    846  HG2 GLN A  59      33.806  20.569  10.736  1.00  0.00           H  
ATOM    847  HG3 GLN A  59      33.695  20.926   9.029  1.00  0.00           H  
ATOM    848 HE21 GLN A  59      35.628  20.604   7.865  1.00  0.00           H  
ATOM    849 HE22 GLN A  59      37.200  20.551   8.605  1.00  0.00           H  
ATOM    850  N   ASP A  60      31.345  24.889  11.335  1.00  0.00           N  
ATOM    851  CA  ASP A  60      30.963  26.235  11.797  1.00  0.00           C  
ATOM    852  C   ASP A  60      30.222  26.178  13.141  1.00  0.00           C  
ATOM    853  O   ASP A  60      29.849  27.206  13.705  1.00  0.00           O  
ATOM    854  CB  ASP A  60      30.100  26.955  10.746  1.00  0.00           C  
ATOM    855  CG  ASP A  60      30.008  28.457  11.044  1.00  0.00           C  
ATOM    856  OD1 ASP A  60      31.057  29.110  11.242  1.00  0.00           O  
ATOM    857  OD2 ASP A  60      28.896  29.032  11.022  1.00  0.00           O  
ATOM    858  H   ASP A  60      30.700  24.391  10.736  1.00  0.00           H  
ATOM    859  HA  ASP A  60      31.868  26.825  11.945  1.00  0.00           H  
ATOM    860  HB2 ASP A  60      30.550  26.836   9.760  1.00  0.00           H  
ATOM    861  HB3 ASP A  60      29.100  26.516  10.730  1.00  0.00           H  
ATOM    862  N   GLY A  61      29.946  24.965  13.631  1.00  0.00           N  
ATOM    863  CA  GLY A  61      29.313  24.653  14.904  1.00  0.00           C  
ATOM    864  C   GLY A  61      27.804  24.870  14.894  1.00  0.00           C  
ATOM    865  O   GLY A  61      27.098  24.258  15.693  1.00  0.00           O  
ATOM    866  H   GLY A  61      30.189  24.168  13.063  1.00  0.00           H  
ATOM    867  HA2 GLY A  61      29.521  23.617  15.163  1.00  0.00           H  
ATOM    868  HA3 GLY A  61      29.745  25.291  15.674  1.00  0.00           H  
ATOM    869  N   LYS A  62      27.311  25.734  14.007  1.00  0.00           N  
ATOM    870  CA  LYS A  62      26.024  26.397  14.155  1.00  0.00           C  
ATOM    871  C   LYS A  62      24.864  25.598  13.606  1.00  0.00           C  
ATOM    872  O   LYS A  62      23.760  25.720  14.139  1.00  0.00           O  
ATOM    873  CB  LYS A  62      26.125  27.775  13.484  1.00  0.00           C  
ATOM    874  CG  LYS A  62      26.693  28.770  14.502  1.00  0.00           C  
ATOM    875  CD  LYS A  62      27.446  29.902  13.824  1.00  0.00           C  
ATOM    876  CE  LYS A  62      27.905  30.923  14.859  1.00  0.00           C  
ATOM    877  NZ  LYS A  62      28.836  31.881  14.245  1.00  0.00           N  
ATOM    878  H   LYS A  62      27.986  26.152  13.378  1.00  0.00           H  
ATOM    879  HA  LYS A  62      25.833  26.526  15.223  1.00  0.00           H  
ATOM    880  HB2 LYS A  62      26.772  27.714  12.606  1.00  0.00           H  
ATOM    881  HB3 LYS A  62      25.143  28.123  13.161  1.00  0.00           H  
ATOM    882  HG2 LYS A  62      25.870  29.173  15.086  1.00  0.00           H  
ATOM    883  HG3 LYS A  62      27.394  28.271  15.173  1.00  0.00           H  
ATOM    884  HD2 LYS A  62      28.322  29.472  13.345  1.00  0.00           H  
ATOM    885  HD3 LYS A  62      26.809  30.385  13.082  1.00  0.00           H  
ATOM    886  HE2 LYS A  62      27.030  31.452  15.241  1.00  0.00           H  
ATOM    887  HE3 LYS A  62      28.394  30.405  15.690  1.00  0.00           H  
ATOM    888  HZ1 LYS A  62      29.074  32.623  14.886  1.00  0.00           H  
ATOM    889  HZ2 LYS A  62      29.690  31.405  13.964  1.00  0.00           H  
ATOM    890  HZ3 LYS A  62      28.423  32.250  13.396  1.00  0.00           H  
ATOM    891  N   MET A  63      25.052  24.861  12.516  1.00  0.00           N  
ATOM    892  CA  MET A  63      23.985  24.041  11.964  1.00  0.00           C  
ATOM    893  C   MET A  63      23.730  22.885  12.922  1.00  0.00           C  
ATOM    894  O   MET A  63      24.675  22.174  13.267  1.00  0.00           O  
ATOM    895  CB  MET A  63      24.401  23.508  10.598  1.00  0.00           C  
ATOM    896  CG  MET A  63      23.204  23.063   9.750  1.00  0.00           C  
ATOM    897  SD  MET A  63      22.338  24.377   8.862  1.00  0.00           S  
ATOM    898  CE  MET A  63      23.734  25.172   8.028  1.00  0.00           C  
ATOM    899  H   MET A  63      25.988  24.781  12.148  1.00  0.00           H  
ATOM    900  HA  MET A  63      23.086  24.649  11.851  1.00  0.00           H  
ATOM    901  HB2 MET A  63      24.986  24.263  10.079  1.00  0.00           H  
ATOM    902  HB3 MET A  63      25.049  22.652  10.730  1.00  0.00           H  
ATOM    903  HG2 MET A  63      23.571  22.356   9.009  1.00  0.00           H  
ATOM    904  HG3 MET A  63      22.481  22.545  10.382  1.00  0.00           H  
ATOM    905  HE1 MET A  63      24.266  25.810   8.732  1.00  0.00           H  
ATOM    906  HE2 MET A  63      24.412  24.402   7.668  1.00  0.00           H  
ATOM    907  HE3 MET A  63      23.378  25.772   7.194  1.00  0.00           H  
ATOM    908  N   GLU A  64      22.475  22.675  13.310  1.00  0.00           N  
ATOM    909  CA  GLU A  64      22.056  21.530  14.111  1.00  0.00           C  
ATOM    910  C   GLU A  64      20.853  20.880  13.435  1.00  0.00           C  
ATOM    911  O   GLU A  64      20.276  21.422  12.487  1.00  0.00           O  
ATOM    912  CB  GLU A  64      21.783  21.943  15.565  1.00  0.00           C  
ATOM    913  CG  GLU A  64      23.106  22.322  16.254  1.00  0.00           C  
ATOM    914  CD  GLU A  64      22.956  22.889  17.666  1.00  0.00           C  
ATOM    915  OE1 GLU A  64      21.873  22.773  18.285  1.00  0.00           O  
ATOM    916  OE2 GLU A  64      23.942  23.490  18.152  1.00  0.00           O  
ATOM    917  H   GLU A  64      21.705  23.255  12.981  1.00  0.00           H  
ATOM    918  HA  GLU A  64      22.857  20.791  14.131  1.00  0.00           H  
ATOM    919  HB2 GLU A  64      21.096  22.786  15.582  1.00  0.00           H  
ATOM    920  HB3 GLU A  64      21.331  21.103  16.100  1.00  0.00           H  
ATOM    921  HG2 GLU A  64      23.749  21.440  16.277  1.00  0.00           H  
ATOM    922  HG3 GLU A  64      23.619  23.079  15.661  1.00  0.00           H  
ATOM    923  N   THR A  65      20.503  19.670  13.862  1.00  0.00           N  
ATOM    924  CA  THR A  65      19.478  18.896  13.185  1.00  0.00           C  
ATOM    925  C   THR A  65      18.124  19.213  13.824  1.00  0.00           C  
ATOM    926  O   THR A  65      18.031  19.380  15.037  1.00  0.00           O  
ATOM    927  CB  THR A  65      19.848  17.408  13.245  1.00  0.00           C  
ATOM    928  OG1 THR A  65      21.167  17.187  12.773  1.00  0.00           O  
ATOM    929  CG2 THR A  65      18.919  16.609  12.344  1.00  0.00           C  
ATOM    930  H   THR A  65      20.866  19.298  14.727  1.00  0.00           H  
ATOM    931  HA  THR A  65      19.447  19.191  12.135  1.00  0.00           H  
ATOM    932  HB  THR A  65      19.768  17.052  14.269  1.00  0.00           H  
ATOM    933  HG1 THR A  65      21.767  17.464  13.472  1.00  0.00           H  
ATOM    934 HG21 THR A  65      17.907  16.648  12.733  1.00  0.00           H  
ATOM    935 HG22 THR A  65      18.916  17.051  11.351  1.00  0.00           H  
ATOM    936 HG23 THR A  65      19.249  15.571  12.288  1.00  0.00           H  
ATOM    937  N   GLY A  66      17.072  19.292  13.006  1.00  0.00           N  
ATOM    938  CA  GLY A  66      15.734  19.680  13.432  1.00  0.00           C  
ATOM    939  C   GLY A  66      15.497  21.181  13.306  1.00  0.00           C  
ATOM    940  O   GLY A  66      14.340  21.595  13.273  1.00  0.00           O  
ATOM    941  H   GLY A  66      17.205  19.153  12.010  1.00  0.00           H  
ATOM    942  HA2 GLY A  66      15.002  19.163  12.817  1.00  0.00           H  
ATOM    943  HA3 GLY A  66      15.572  19.385  14.471  1.00  0.00           H  
ATOM    944  N   ASP A  67      16.560  21.980  13.171  1.00  0.00           N  
ATOM    945  CA  ASP A  67      16.497  23.436  13.101  1.00  0.00           C  
ATOM    946  C   ASP A  67      15.555  23.863  11.966  1.00  0.00           C  
ATOM    947  O   ASP A  67      15.589  23.272  10.887  1.00  0.00           O  
ATOM    948  CB  ASP A  67      17.880  24.010  12.775  1.00  0.00           C  
ATOM    949  CG  ASP A  67      18.927  24.089  13.878  1.00  0.00           C  
ATOM    950  OD1 ASP A  67      18.539  24.032  15.063  1.00  0.00           O  
ATOM    951  OD2 ASP A  67      20.088  24.455  13.582  1.00  0.00           O  
ATOM    952  H   ASP A  67      17.479  21.562  13.187  1.00  0.00           H  
ATOM    953  HA  ASP A  67      16.142  23.840  14.054  1.00  0.00           H  
ATOM    954  HB2 ASP A  67      18.308  23.484  11.921  1.00  0.00           H  
ATOM    955  HB3 ASP A  67      17.682  25.045  12.511  1.00  0.00           H  
ATOM    956  N   VAL A  68      14.741  24.899  12.176  1.00  0.00           N  
ATOM    957  CA  VAL A  68      13.721  25.359  11.225  1.00  0.00           C  
ATOM    958  C   VAL A  68      14.322  26.459  10.353  1.00  0.00           C  
ATOM    959  O   VAL A  68      14.789  27.457  10.898  1.00  0.00           O  
ATOM    960  CB  VAL A  68      12.471  25.840  11.998  1.00  0.00           C  
ATOM    961  CG1 VAL A  68      11.511  26.705  11.160  1.00  0.00           C  
ATOM    962  CG2 VAL A  68      11.676  24.629  12.505  1.00  0.00           C  
ATOM    963  H   VAL A  68      14.859  25.424  13.029  1.00  0.00           H  
ATOM    964  HA  VAL A  68      13.433  24.524  10.589  1.00  0.00           H  
ATOM    965  HB  VAL A  68      12.790  26.429  12.860  1.00  0.00           H  
ATOM    966 HG11 VAL A  68      11.250  26.187  10.235  1.00  0.00           H  
ATOM    967 HG12 VAL A  68      10.601  26.912  11.726  1.00  0.00           H  
ATOM    968 HG13 VAL A  68      11.981  27.658  10.914  1.00  0.00           H  
ATOM    969 HG21 VAL A  68      10.881  24.962  13.167  1.00  0.00           H  
ATOM    970 HG22 VAL A  68      11.219  24.116  11.661  1.00  0.00           H  
ATOM    971 HG23 VAL A  68      12.328  23.940  13.045  1.00  0.00           H  
ATOM    972  N   ILE A  69      14.309  26.292   9.027  1.00  0.00           N  
ATOM    973  CA  ILE A  69      14.686  27.295   8.044  1.00  0.00           C  
ATOM    974  C   ILE A  69      13.624  28.381   8.041  1.00  0.00           C  
ATOM    975  O   ILE A  69      12.458  28.126   7.744  1.00  0.00           O  
ATOM    976  CB  ILE A  69      14.928  26.689   6.646  1.00  0.00           C  
ATOM    977  CG1 ILE A  69      16.074  25.653   6.619  1.00  0.00           C  
ATOM    978  CG2 ILE A  69      15.313  27.800   5.652  1.00  0.00           C  
ATOM    979  CD1 ILE A  69      15.708  24.248   7.085  1.00  0.00           C  
ATOM    980  H   ILE A  69      13.819  25.493   8.652  1.00  0.00           H  
ATOM    981  HA  ILE A  69      15.611  27.759   8.338  1.00  0.00           H  
ATOM    982  HB  ILE A  69      14.009  26.229   6.293  1.00  0.00           H  
ATOM    983 HG12 ILE A  69      16.436  25.562   5.599  1.00  0.00           H  
ATOM    984 HG13 ILE A  69      16.900  25.997   7.229  1.00  0.00           H  
ATOM    985 HG21 ILE A  69      15.412  27.377   4.655  1.00  0.00           H  
ATOM    986 HG22 ILE A  69      14.536  28.563   5.607  1.00  0.00           H  
ATOM    987 HG23 ILE A  69      16.255  28.266   5.944  1.00  0.00           H  
ATOM    988 HD11 ILE A  69      14.827  23.895   6.553  1.00  0.00           H  
ATOM    989 HD12 ILE A  69      16.546  23.585   6.879  1.00  0.00           H  
ATOM    990 HD13 ILE A  69      15.530  24.234   8.156  1.00  0.00           H  
ATOM    991  N   VAL A  70      14.060  29.601   8.346  1.00  0.00           N  
ATOM    992  CA  VAL A  70      13.241  30.792   8.224  1.00  0.00           C  
ATOM    993  C   VAL A  70      13.532  31.492   6.894  1.00  0.00           C  
ATOM    994  O   VAL A  70      12.610  31.748   6.123  1.00  0.00           O  
ATOM    995  CB  VAL A  70      13.486  31.756   9.398  1.00  0.00           C  
ATOM    996  CG1 VAL A  70      12.334  32.753   9.439  1.00  0.00           C  
ATOM    997  CG2 VAL A  70      13.680  31.115  10.778  1.00  0.00           C  
ATOM    998  H   VAL A  70      15.029  29.704   8.629  1.00  0.00           H  
ATOM    999  HA  VAL A  70      12.190  30.495   8.236  1.00  0.00           H  
ATOM   1000  HB  VAL A  70      14.397  32.314   9.206  1.00  0.00           H  
ATOM   1001 HG11 VAL A  70      12.591  33.551  10.128  1.00  0.00           H  
ATOM   1002 HG12 VAL A  70      12.184  33.203   8.456  1.00  0.00           H  
ATOM   1003 HG13 VAL A  70      11.420  32.248   9.749  1.00  0.00           H  
ATOM   1004 HG21 VAL A  70      14.758  31.100  10.964  1.00  0.00           H  
ATOM   1005 HG22 VAL A  70      13.185  31.703  11.556  1.00  0.00           H  
ATOM   1006 HG23 VAL A  70      13.273  30.105  10.804  1.00  0.00           H  
ATOM   1007  N   TYR A  71      14.790  31.861   6.644  1.00  0.00           N  
ATOM   1008  CA  TYR A  71      15.194  32.651   5.488  1.00  0.00           C  
ATOM   1009  C   TYR A  71      16.435  31.998   4.886  1.00  0.00           C  
ATOM   1010  O   TYR A  71      17.214  31.366   5.610  1.00  0.00           O  
ATOM   1011  CB  TYR A  71      15.502  34.114   5.867  1.00  0.00           C  
ATOM   1012  CG  TYR A  71      14.432  34.921   6.596  1.00  0.00           C  
ATOM   1013  CD1 TYR A  71      14.386  34.921   8.002  1.00  0.00           C  
ATOM   1014  CD2 TYR A  71      13.561  35.775   5.895  1.00  0.00           C  
ATOM   1015  CE1 TYR A  71      13.492  35.737   8.707  1.00  0.00           C  
ATOM   1016  CE2 TYR A  71      12.627  36.573   6.587  1.00  0.00           C  
ATOM   1017  CZ  TYR A  71      12.589  36.558   8.001  1.00  0.00           C  
ATOM   1018  OH  TYR A  71      11.708  37.331   8.695  1.00  0.00           O  
ATOM   1019  H   TYR A  71      15.537  31.554   7.256  1.00  0.00           H  
ATOM   1020  HA  TYR A  71      14.394  32.642   4.751  1.00  0.00           H  
ATOM   1021  HB2 TYR A  71      16.396  34.114   6.483  1.00  0.00           H  
ATOM   1022  HB3 TYR A  71      15.766  34.650   4.953  1.00  0.00           H  
ATOM   1023  HD1 TYR A  71      15.037  34.297   8.575  1.00  0.00           H  
ATOM   1024  HD2 TYR A  71      13.634  35.845   4.819  1.00  0.00           H  
ATOM   1025  HE1 TYR A  71      13.510  35.711   9.788  1.00  0.00           H  
ATOM   1026  HE2 TYR A  71      11.973  37.230   6.030  1.00  0.00           H  
ATOM   1027  HH  TYR A  71      11.876  37.278   9.645  1.00  0.00           H  
ATOM   1028  N   ILE A  72      16.637  32.188   3.583  1.00  0.00           N  
ATOM   1029  CA  ILE A  72      17.811  31.721   2.852  1.00  0.00           C  
ATOM   1030  C   ILE A  72      18.338  32.902   2.060  1.00  0.00           C  
ATOM   1031  O   ILE A  72      17.606  33.498   1.274  1.00  0.00           O  
ATOM   1032  CB  ILE A  72      17.491  30.523   1.926  1.00  0.00           C  
ATOM   1033  CG1 ILE A  72      17.032  29.322   2.777  1.00  0.00           C  
ATOM   1034  CG2 ILE A  72      18.703  30.157   1.034  1.00  0.00           C  
ATOM   1035  CD1 ILE A  72      16.758  28.056   1.963  1.00  0.00           C  
ATOM   1036  H   ILE A  72      15.980  32.788   3.086  1.00  0.00           H  
ATOM   1037  HA  ILE A  72      18.577  31.411   3.563  1.00  0.00           H  
ATOM   1038  HB  ILE A  72      16.673  30.808   1.264  1.00  0.00           H  
ATOM   1039 HG12 ILE A  72      17.766  29.093   3.540  1.00  0.00           H  
ATOM   1040 HG13 ILE A  72      16.128  29.598   3.305  1.00  0.00           H  
ATOM   1041 HG21 ILE A  72      19.007  31.009   0.423  1.00  0.00           H  
ATOM   1042 HG22 ILE A  72      19.546  29.845   1.646  1.00  0.00           H  
ATOM   1043 HG23 ILE A  72      18.442  29.358   0.341  1.00  0.00           H  
ATOM   1044 HD11 ILE A  72      16.075  28.282   1.143  1.00  0.00           H  
ATOM   1045 HD12 ILE A  72      17.698  27.665   1.578  1.00  0.00           H  
ATOM   1046 HD13 ILE A  72      16.318  27.300   2.609  1.00  0.00           H  
ATOM   1047  N   ASN A  73      19.630  33.161   2.216  1.00  0.00           N  
ATOM   1048  CA  ASN A  73      20.436  34.204   1.607  1.00  0.00           C  
ATOM   1049  C   ASN A  73      19.919  35.592   1.943  1.00  0.00           C  
ATOM   1050  O   ASN A  73      20.522  36.261   2.775  1.00  0.00           O  
ATOM   1051  CB  ASN A  73      20.648  33.955   0.105  1.00  0.00           C  
ATOM   1052  CG  ASN A  73      22.018  34.415  -0.374  1.00  0.00           C  
ATOM   1053  OD1 ASN A  73      22.955  34.602   0.401  1.00  0.00           O  
ATOM   1054  ND2 ASN A  73      22.208  34.498  -1.676  1.00  0.00           N  
ATOM   1055  H   ASN A  73      20.127  32.604   2.903  1.00  0.00           H  
ATOM   1056  HA  ASN A  73      21.402  34.122   2.097  1.00  0.00           H  
ATOM   1057  HB2 ASN A  73      20.564  32.890  -0.092  1.00  0.00           H  
ATOM   1058  HB3 ASN A  73      19.867  34.450  -0.473  1.00  0.00           H  
ATOM   1059 HD21 ASN A  73      21.419  34.379  -2.304  1.00  0.00           H  
ATOM   1060 HD22 ASN A  73      23.099  34.773  -2.066  1.00  0.00           H  
ATOM   1061  N   GLU A  74      18.800  35.990   1.341  1.00  0.00           N  
ATOM   1062  CA  GLU A  74      18.016  37.136   1.774  1.00  0.00           C  
ATOM   1063  C   GLU A  74      16.558  37.021   1.281  1.00  0.00           C  
ATOM   1064  O   GLU A  74      15.982  38.008   0.819  1.00  0.00           O  
ATOM   1065  CB  GLU A  74      18.720  38.441   1.347  1.00  0.00           C  
ATOM   1066  CG  GLU A  74      18.548  39.502   2.439  1.00  0.00           C  
ATOM   1067  CD  GLU A  74      19.146  40.837   2.008  1.00  0.00           C  
ATOM   1068  OE1 GLU A  74      18.459  41.569   1.260  1.00  0.00           O  
ATOM   1069  OE2 GLU A  74      20.294  41.141   2.405  1.00  0.00           O  
ATOM   1070  H   GLU A  74      18.356  35.312   0.731  1.00  0.00           H  
ATOM   1071  HA  GLU A  74      17.994  37.106   2.865  1.00  0.00           H  
ATOM   1072  HB2 GLU A  74      19.789  38.276   1.212  1.00  0.00           H  
ATOM   1073  HB3 GLU A  74      18.333  38.797   0.393  1.00  0.00           H  
ATOM   1074  HG2 GLU A  74      17.487  39.639   2.649  1.00  0.00           H  
ATOM   1075  HG3 GLU A  74      19.039  39.165   3.357  1.00  0.00           H  
ATOM   1076  N   VAL A  75      15.982  35.812   1.336  1.00  0.00           N  
ATOM   1077  CA  VAL A  75      14.640  35.461   0.865  1.00  0.00           C  
ATOM   1078  C   VAL A  75      13.868  34.806   2.018  1.00  0.00           C  
ATOM   1079  O   VAL A  75      14.397  33.899   2.670  1.00  0.00           O  
ATOM   1080  CB  VAL A  75      14.730  34.501  -0.347  1.00  0.00           C  
ATOM   1081  CG1 VAL A  75      13.340  34.197  -0.927  1.00  0.00           C  
ATOM   1082  CG2 VAL A  75      15.603  35.049  -1.488  1.00  0.00           C  
ATOM   1083  H   VAL A  75      16.518  35.030   1.688  1.00  0.00           H  
ATOM   1084  HA  VAL A  75      14.122  36.367   0.554  1.00  0.00           H  
ATOM   1085  HB  VAL A  75      15.170  33.559  -0.016  1.00  0.00           H  
ATOM   1086 HG11 VAL A  75      12.721  33.683  -0.192  1.00  0.00           H  
ATOM   1087 HG12 VAL A  75      12.845  35.128  -1.207  1.00  0.00           H  
ATOM   1088 HG13 VAL A  75      13.426  33.554  -1.804  1.00  0.00           H  
ATOM   1089 HG21 VAL A  75      15.183  35.986  -1.854  1.00  0.00           H  
ATOM   1090 HG22 VAL A  75      16.624  35.215  -1.145  1.00  0.00           H  
ATOM   1091 HG23 VAL A  75      15.631  34.328  -2.303  1.00  0.00           H  
ATOM   1092  N   CYS A  76      12.626  35.232   2.264  1.00  0.00           N  
ATOM   1093  CA  CYS A  76      11.674  34.603   3.176  1.00  0.00           C  
ATOM   1094  C   CYS A  76      11.126  33.285   2.607  1.00  0.00           C  
ATOM   1095  O   CYS A  76      10.362  33.295   1.640  1.00  0.00           O  
ATOM   1096  CB  CYS A  76      10.542  35.597   3.487  1.00  0.00           C  
ATOM   1097  SG  CYS A  76       9.800  36.311   1.984  1.00  0.00           S  
ATOM   1098  H   CYS A  76      12.295  36.050   1.758  1.00  0.00           H  
ATOM   1099  HA  CYS A  76      12.186  34.368   4.108  1.00  0.00           H  
ATOM   1100  HB2 CYS A  76       9.769  35.079   4.057  1.00  0.00           H  
ATOM   1101  HB3 CYS A  76      10.941  36.403   4.102  1.00  0.00           H  
ATOM   1102  HG  CYS A  76       9.719  35.151   1.310  1.00  0.00           H  
ATOM   1103  N   VAL A  77      11.476  32.144   3.209  1.00  0.00           N  
ATOM   1104  CA  VAL A  77      11.125  30.824   2.689  1.00  0.00           C  
ATOM   1105  C   VAL A  77      10.346  29.952   3.683  1.00  0.00           C  
ATOM   1106  O   VAL A  77      10.124  28.789   3.370  1.00  0.00           O  
ATOM   1107  CB  VAL A  77      12.382  30.098   2.163  1.00  0.00           C  
ATOM   1108  CG1 VAL A  77      13.096  30.872   1.046  1.00  0.00           C  
ATOM   1109  CG2 VAL A  77      13.395  29.760   3.265  1.00  0.00           C  
ATOM   1110  H   VAL A  77      12.038  32.163   4.048  1.00  0.00           H  
ATOM   1111  HA  VAL A  77      10.463  30.944   1.832  1.00  0.00           H  
ATOM   1112  HB  VAL A  77      12.055  29.157   1.725  1.00  0.00           H  
ATOM   1113 HG11 VAL A  77      13.908  30.264   0.650  1.00  0.00           H  
ATOM   1114 HG12 VAL A  77      12.390  31.089   0.243  1.00  0.00           H  
ATOM   1115 HG13 VAL A  77      13.506  31.806   1.424  1.00  0.00           H  
ATOM   1116 HG21 VAL A  77      14.116  29.047   2.867  1.00  0.00           H  
ATOM   1117 HG22 VAL A  77      13.912  30.654   3.609  1.00  0.00           H  
ATOM   1118 HG23 VAL A  77      12.890  29.283   4.106  1.00  0.00           H  
ATOM   1119  N   LEU A  78       9.939  30.435   4.865  1.00  0.00           N  
ATOM   1120  CA  LEU A  78       9.442  29.546   5.927  1.00  0.00           C  
ATOM   1121  C   LEU A  78       8.163  28.772   5.555  1.00  0.00           C  
ATOM   1122  O   LEU A  78       7.880  27.771   6.206  1.00  0.00           O  
ATOM   1123  CB  LEU A  78       9.359  30.304   7.266  1.00  0.00           C  
ATOM   1124  CG  LEU A  78       7.978  30.866   7.663  1.00  0.00           C  
ATOM   1125  CD1 LEU A  78       7.236  29.903   8.598  1.00  0.00           C  
ATOM   1126  CD2 LEU A  78       8.114  32.199   8.410  1.00  0.00           C  
ATOM   1127  H   LEU A  78      10.055  31.422   5.065  1.00  0.00           H  
ATOM   1128  HA  LEU A  78      10.203  28.781   6.072  1.00  0.00           H  
ATOM   1129  HB2 LEU A  78       9.707  29.636   8.056  1.00  0.00           H  
ATOM   1130  HB3 LEU A  78      10.078  31.114   7.213  1.00  0.00           H  
ATOM   1131  HG  LEU A  78       7.378  31.042   6.772  1.00  0.00           H  
ATOM   1132 HD11 LEU A  78       6.172  30.124   8.583  1.00  0.00           H  
ATOM   1133 HD12 LEU A  78       7.369  28.882   8.253  1.00  0.00           H  
ATOM   1134 HD13 LEU A  78       7.636  29.959   9.610  1.00  0.00           H  
ATOM   1135 HD21 LEU A  78       7.131  32.542   8.724  1.00  0.00           H  
ATOM   1136 HD22 LEU A  78       8.770  32.084   9.271  1.00  0.00           H  
ATOM   1137 HD23 LEU A  78       8.535  32.943   7.732  1.00  0.00           H  
ATOM   1138  N   GLY A  79       7.413  29.203   4.536  1.00  0.00           N  
ATOM   1139  CA  GLY A  79       6.293  28.453   3.967  1.00  0.00           C  
ATOM   1140  C   GLY A  79       6.525  28.050   2.508  1.00  0.00           C  
ATOM   1141  O   GLY A  79       5.588  27.566   1.876  1.00  0.00           O  
ATOM   1142  H   GLY A  79       7.696  30.044   4.049  1.00  0.00           H  
ATOM   1143  HA2 GLY A  79       6.089  27.545   4.539  1.00  0.00           H  
ATOM   1144  HA3 GLY A  79       5.399  29.079   4.007  1.00  0.00           H  
ATOM   1145  N   HIS A  80       7.704  28.311   1.926  1.00  0.00           N  
ATOM   1146  CA  HIS A  80       7.972  27.959   0.528  1.00  0.00           C  
ATOM   1147  C   HIS A  80       8.013  26.434   0.371  1.00  0.00           C  
ATOM   1148  O   HIS A  80       8.195  25.679   1.331  1.00  0.00           O  
ATOM   1149  CB  HIS A  80       9.279  28.606   0.015  1.00  0.00           C  
ATOM   1150  CG  HIS A  80       9.131  29.801  -0.908  1.00  0.00           C  
ATOM   1151  ND1 HIS A  80      10.083  30.226  -1.808  1.00  0.00           N  
ATOM   1152  CD2 HIS A  80       8.054  30.639  -1.042  1.00  0.00           C  
ATOM   1153  CE1 HIS A  80       9.604  31.304  -2.447  1.00  0.00           C  
ATOM   1154  NE2 HIS A  80       8.351  31.578  -2.042  1.00  0.00           N  
ATOM   1155  H   HIS A  80       8.486  28.540   2.532  1.00  0.00           H  
ATOM   1156  HA  HIS A  80       7.141  28.314  -0.082  1.00  0.00           H  
ATOM   1157  HB2 HIS A  80       9.902  28.891   0.855  1.00  0.00           H  
ATOM   1158  HB3 HIS A  80       9.854  27.859  -0.532  1.00  0.00           H  
ATOM   1159  HD1 HIS A  80      10.958  29.754  -2.058  1.00  0.00           H  
ATOM   1160  HD2 HIS A  80       7.125  30.566  -0.499  1.00  0.00           H  
ATOM   1161  HE1 HIS A  80      10.137  31.835  -3.226  1.00  0.00           H  
ATOM   1162  N   THR A  81       7.894  25.983  -0.876  1.00  0.00           N  
ATOM   1163  CA  THR A  81       7.941  24.577  -1.203  1.00  0.00           C  
ATOM   1164  C   THR A  81       9.378  24.091  -1.003  1.00  0.00           C  
ATOM   1165  O   THR A  81      10.339  24.794  -1.341  1.00  0.00           O  
ATOM   1166  CB  THR A  81       7.414  24.380  -2.640  1.00  0.00           C  
ATOM   1167  OG1 THR A  81       8.109  25.195  -3.567  1.00  0.00           O  
ATOM   1168  CG2 THR A  81       5.926  24.741  -2.732  1.00  0.00           C  
ATOM   1169  H   THR A  81       7.858  26.596  -1.675  1.00  0.00           H  
ATOM   1170  HA  THR A  81       7.286  24.040  -0.521  1.00  0.00           H  
ATOM   1171  HB  THR A  81       7.543  23.336  -2.923  1.00  0.00           H  
ATOM   1172  HG1 THR A  81       7.722  25.059  -4.452  1.00  0.00           H  
ATOM   1173 HG21 THR A  81       5.354  24.085  -2.078  1.00  0.00           H  
ATOM   1174 HG22 THR A  81       5.745  25.778  -2.447  1.00  0.00           H  
ATOM   1175 HG23 THR A  81       5.568  24.595  -3.751  1.00  0.00           H  
ATOM   1176  N   HIS A  82       9.555  22.865  -0.505  1.00  0.00           N  
ATOM   1177  CA  HIS A  82      10.858  22.200  -0.548  1.00  0.00           C  
ATOM   1178  C   HIS A  82      11.327  22.040  -1.996  1.00  0.00           C  
ATOM   1179  O   HIS A  82      12.525  21.978  -2.241  1.00  0.00           O  
ATOM   1180  CB  HIS A  82      10.788  20.870   0.214  1.00  0.00           C  
ATOM   1181  CG  HIS A  82      12.127  20.341   0.681  1.00  0.00           C  
ATOM   1182  ND1 HIS A  82      12.512  19.020   0.695  1.00  0.00           N  
ATOM   1183  CD2 HIS A  82      13.159  21.064   1.215  1.00  0.00           C  
ATOM   1184  CE1 HIS A  82      13.757  18.953   1.190  1.00  0.00           C  
ATOM   1185  NE2 HIS A  82      14.190  20.176   1.531  1.00  0.00           N  
ATOM   1186  H   HIS A  82       8.749  22.367  -0.133  1.00  0.00           H  
ATOM   1187  HA  HIS A  82      11.613  22.824  -0.070  1.00  0.00           H  
ATOM   1188  HB2 HIS A  82      10.169  21.010   1.097  1.00  0.00           H  
ATOM   1189  HB3 HIS A  82      10.296  20.129  -0.412  1.00  0.00           H  
ATOM   1190  HD1 HIS A  82      11.953  18.215   0.432  1.00  0.00           H  
ATOM   1191  HD2 HIS A  82      13.190  22.133   1.350  1.00  0.00           H  
ATOM   1192  HE1 HIS A  82      14.319  18.037   1.316  1.00  0.00           H  
ATOM   1193  N   ALA A  83      10.431  22.050  -2.981  1.00  0.00           N  
ATOM   1194  CA  ALA A  83      10.814  22.169  -4.375  1.00  0.00           C  
ATOM   1195  C   ALA A  83      11.614  23.452  -4.642  1.00  0.00           C  
ATOM   1196  O   ALA A  83      12.698  23.389  -5.229  1.00  0.00           O  
ATOM   1197  CB  ALA A  83       9.554  22.121  -5.232  1.00  0.00           C  
ATOM   1198  H   ALA A  83       9.448  22.003  -2.745  1.00  0.00           H  
ATOM   1199  HA  ALA A  83      11.449  21.316  -4.625  1.00  0.00           H  
ATOM   1200  HB1 ALA A  83       8.879  22.933  -4.966  1.00  0.00           H  
ATOM   1201  HB2 ALA A  83       9.842  22.224  -6.275  1.00  0.00           H  
ATOM   1202  HB3 ALA A  83       9.047  21.167  -5.085  1.00  0.00           H  
ATOM   1203  N   ASP A  84      11.081  24.617  -4.279  1.00  0.00           N  
ATOM   1204  CA  ASP A  84      11.716  25.923  -4.466  1.00  0.00           C  
ATOM   1205  C   ASP A  84      12.983  26.011  -3.610  1.00  0.00           C  
ATOM   1206  O   ASP A  84      14.055  26.286  -4.124  1.00  0.00           O  
ATOM   1207  CB  ASP A  84      10.710  27.022  -4.111  1.00  0.00           C  
ATOM   1208  CG  ASP A  84      11.299  28.424  -4.216  1.00  0.00           C  
ATOM   1209  OD1 ASP A  84      11.999  28.856  -3.274  1.00  0.00           O  
ATOM   1210  OD2 ASP A  84      10.957  29.157  -5.177  1.00  0.00           O  
ATOM   1211  H   ASP A  84      10.187  24.622  -3.797  1.00  0.00           H  
ATOM   1212  HA  ASP A  84      12.000  26.053  -5.517  1.00  0.00           H  
ATOM   1213  HB2 ASP A  84       9.849  26.945  -4.779  1.00  0.00           H  
ATOM   1214  HB3 ASP A  84      10.357  26.882  -3.089  1.00  0.00           H  
ATOM   1215  N   VAL A  85      12.927  25.685  -2.325  1.00  0.00           N  
ATOM   1216  CA  VAL A  85      14.063  25.749  -1.411  1.00  0.00           C  
ATOM   1217  C   VAL A  85      15.204  24.830  -1.844  1.00  0.00           C  
ATOM   1218  O   VAL A  85      16.364  25.254  -1.836  1.00  0.00           O  
ATOM   1219  CB  VAL A  85      13.561  25.560   0.034  1.00  0.00           C  
ATOM   1220  CG1 VAL A  85      14.651  25.133   1.026  1.00  0.00           C  
ATOM   1221  CG2 VAL A  85      12.977  26.905   0.472  1.00  0.00           C  
ATOM   1222  H   VAL A  85      12.014  25.485  -1.947  1.00  0.00           H  
ATOM   1223  HA  VAL A  85      14.477  26.748  -1.477  1.00  0.00           H  
ATOM   1224  HB  VAL A  85      12.771  24.812   0.064  1.00  0.00           H  
ATOM   1225 HG11 VAL A  85      14.271  25.192   2.047  1.00  0.00           H  
ATOM   1226 HG12 VAL A  85      14.954  24.105   0.823  1.00  0.00           H  
ATOM   1227 HG13 VAL A  85      15.512  25.790   0.922  1.00  0.00           H  
ATOM   1228 HG21 VAL A  85      13.769  27.651   0.529  1.00  0.00           H  
ATOM   1229 HG22 VAL A  85      12.219  27.240  -0.237  1.00  0.00           H  
ATOM   1230 HG23 VAL A  85      12.506  26.808   1.442  1.00  0.00           H  
ATOM   1231  N   VAL A  86      14.929  23.616  -2.307  1.00  0.00           N  
ATOM   1232  CA  VAL A  86      15.986  22.790  -2.871  1.00  0.00           C  
ATOM   1233  C   VAL A  86      16.539  23.455  -4.141  1.00  0.00           C  
ATOM   1234  O   VAL A  86      17.760  23.454  -4.331  1.00  0.00           O  
ATOM   1235  CB  VAL A  86      15.482  21.349  -3.054  1.00  0.00           C  
ATOM   1236  CG1 VAL A  86      16.512  20.493  -3.796  1.00  0.00           C  
ATOM   1237  CG2 VAL A  86      15.224  20.739  -1.659  1.00  0.00           C  
ATOM   1238  H   VAL A  86      13.975  23.266  -2.340  1.00  0.00           H  
ATOM   1239  HA  VAL A  86      16.807  22.760  -2.156  1.00  0.00           H  
ATOM   1240  HB  VAL A  86      14.554  21.353  -3.633  1.00  0.00           H  
ATOM   1241 HG11 VAL A  86      16.160  19.464  -3.861  1.00  0.00           H  
ATOM   1242 HG12 VAL A  86      16.640  20.879  -4.809  1.00  0.00           H  
ATOM   1243 HG13 VAL A  86      17.469  20.526  -3.275  1.00  0.00           H  
ATOM   1244 HG21 VAL A  86      16.149  20.703  -1.084  1.00  0.00           H  
ATOM   1245 HG22 VAL A  86      14.495  21.330  -1.092  1.00  0.00           H  
ATOM   1246 HG23 VAL A  86      14.841  19.725  -1.755  1.00  0.00           H  
ATOM   1247  N   LYS A  87      15.702  24.103  -4.965  1.00  0.00           N  
ATOM   1248  CA  LYS A  87      16.219  24.819  -6.140  1.00  0.00           C  
ATOM   1249  C   LYS A  87      17.106  25.979  -5.695  1.00  0.00           C  
ATOM   1250  O   LYS A  87      18.117  26.260  -6.332  1.00  0.00           O  
ATOM   1251  CB  LYS A  87      15.087  25.226  -7.111  1.00  0.00           C  
ATOM   1252  CG  LYS A  87      14.616  26.700  -7.128  1.00  0.00           C  
ATOM   1253  CD  LYS A  87      15.319  27.610  -8.136  1.00  0.00           C  
ATOM   1254  CE  LYS A  87      14.813  27.349  -9.555  1.00  0.00           C  
ATOM   1255  NZ  LYS A  87      15.718  26.485 -10.341  1.00  0.00           N  
ATOM   1256  H   LYS A  87      14.733  24.243  -4.674  1.00  0.00           H  
ATOM   1257  HA  LYS A  87      16.863  24.117  -6.670  1.00  0.00           H  
ATOM   1258  HB2 LYS A  87      15.419  24.968  -8.114  1.00  0.00           H  
ATOM   1259  HB3 LYS A  87      14.219  24.601  -6.907  1.00  0.00           H  
ATOM   1260  HG2 LYS A  87      13.549  26.720  -7.343  1.00  0.00           H  
ATOM   1261  HG3 LYS A  87      14.743  27.174  -6.166  1.00  0.00           H  
ATOM   1262  HD2 LYS A  87      15.065  28.641  -7.881  1.00  0.00           H  
ATOM   1263  HD3 LYS A  87      16.402  27.511  -8.068  1.00  0.00           H  
ATOM   1264  HE2 LYS A  87      13.804  26.924  -9.501  1.00  0.00           H  
ATOM   1265  HE3 LYS A  87      14.755  28.311 -10.059  1.00  0.00           H  
ATOM   1266  HZ1 LYS A  87      16.692  26.698 -10.128  1.00  0.00           H  
ATOM   1267  HZ2 LYS A  87      15.544  25.499 -10.182  1.00  0.00           H  
ATOM   1268  HZ3 LYS A  87      15.619  26.687 -11.329  1.00  0.00           H  
ATOM   1269  N   LEU A  88      16.767  26.633  -4.586  1.00  0.00           N  
ATOM   1270  CA  LEU A  88      17.489  27.773  -4.055  1.00  0.00           C  
ATOM   1271  C   LEU A  88      18.875  27.308  -3.637  1.00  0.00           C  
ATOM   1272  O   LEU A  88      19.854  27.976  -3.964  1.00  0.00           O  
ATOM   1273  CB  LEU A  88      16.729  28.399  -2.872  1.00  0.00           C  
ATOM   1274  CG  LEU A  88      15.565  29.327  -3.269  1.00  0.00           C  
ATOM   1275  CD1 LEU A  88      14.726  29.630  -2.021  1.00  0.00           C  
ATOM   1276  CD2 LEU A  88      16.101  30.639  -3.853  1.00  0.00           C  
ATOM   1277  H   LEU A  88      15.930  26.322  -4.104  1.00  0.00           H  
ATOM   1278  HA  LEU A  88      17.608  28.515  -4.848  1.00  0.00           H  
ATOM   1279  HB2 LEU A  88      16.350  27.615  -2.228  1.00  0.00           H  
ATOM   1280  HB3 LEU A  88      17.435  28.965  -2.271  1.00  0.00           H  
ATOM   1281  HG  LEU A  88      14.934  28.842  -4.012  1.00  0.00           H  
ATOM   1282 HD11 LEU A  88      14.032  30.445  -2.222  1.00  0.00           H  
ATOM   1283 HD12 LEU A  88      14.120  28.755  -1.774  1.00  0.00           H  
ATOM   1284 HD13 LEU A  88      15.362  29.905  -1.182  1.00  0.00           H  
ATOM   1285 HD21 LEU A  88      16.794  31.103  -3.152  1.00  0.00           H  
ATOM   1286 HD22 LEU A  88      16.597  30.451  -4.806  1.00  0.00           H  
ATOM   1287 HD23 LEU A  88      15.270  31.317  -4.044  1.00  0.00           H  
ATOM   1288  N   PHE A  89      18.994  26.174  -2.944  1.00  0.00           N  
ATOM   1289  CA  PHE A  89      20.290  25.627  -2.566  1.00  0.00           C  
ATOM   1290  C   PHE A  89      21.106  25.226  -3.799  1.00  0.00           C  
ATOM   1291  O   PHE A  89      22.308  25.504  -3.849  1.00  0.00           O  
ATOM   1292  CB  PHE A  89      20.112  24.452  -1.604  1.00  0.00           C  
ATOM   1293  CG  PHE A  89      19.714  24.852  -0.194  1.00  0.00           C  
ATOM   1294  CD1 PHE A  89      20.619  25.581   0.599  1.00  0.00           C  
ATOM   1295  CD2 PHE A  89      18.466  24.479   0.345  1.00  0.00           C  
ATOM   1296  CE1 PHE A  89      20.307  25.890   1.931  1.00  0.00           C  
ATOM   1297  CE2 PHE A  89      18.153  24.795   1.678  1.00  0.00           C  
ATOM   1298  CZ  PHE A  89      19.085  25.471   2.481  1.00  0.00           C  
ATOM   1299  H   PHE A  89      18.148  25.676  -2.677  1.00  0.00           H  
ATOM   1300  HA  PHE A  89      20.851  26.405  -2.049  1.00  0.00           H  
ATOM   1301  HB2 PHE A  89      19.381  23.756  -2.015  1.00  0.00           H  
ATOM   1302  HB3 PHE A  89      21.064  23.927  -1.536  1.00  0.00           H  
ATOM   1303  HD1 PHE A  89      21.567  25.904   0.203  1.00  0.00           H  
ATOM   1304  HD2 PHE A  89      17.742  23.937  -0.244  1.00  0.00           H  
ATOM   1305  HE1 PHE A  89      21.018  26.439   2.527  1.00  0.00           H  
ATOM   1306  HE2 PHE A  89      17.205  24.490   2.097  1.00  0.00           H  
ATOM   1307  HZ  PHE A  89      18.855  25.666   3.519  1.00  0.00           H  
ATOM   1308  N   GLN A  90      20.478  24.611  -4.806  1.00  0.00           N  
ATOM   1309  CA  GLN A  90      21.164  24.233  -6.037  1.00  0.00           C  
ATOM   1310  C   GLN A  90      21.569  25.453  -6.874  1.00  0.00           C  
ATOM   1311  O   GLN A  90      22.545  25.367  -7.624  1.00  0.00           O  
ATOM   1312  CB  GLN A  90      20.294  23.268  -6.852  1.00  0.00           C  
ATOM   1313  CG  GLN A  90      20.147  21.896  -6.170  1.00  0.00           C  
ATOM   1314  CD  GLN A  90      19.450  20.880  -7.072  1.00  0.00           C  
ATOM   1315  OE1 GLN A  90      18.632  21.222  -7.920  1.00  0.00           O  
ATOM   1316  NE2 GLN A  90      19.773  19.602  -6.929  1.00  0.00           N  
ATOM   1317  H   GLN A  90      19.494  24.371  -4.717  1.00  0.00           H  
ATOM   1318  HA  GLN A  90      22.082  23.710  -5.771  1.00  0.00           H  
ATOM   1319  HB2 GLN A  90      19.310  23.708  -7.012  1.00  0.00           H  
ATOM   1320  HB3 GLN A  90      20.764  23.115  -7.823  1.00  0.00           H  
ATOM   1321  HG2 GLN A  90      21.142  21.525  -5.924  1.00  0.00           H  
ATOM   1322  HG3 GLN A  90      19.586  21.989  -5.242  1.00  0.00           H  
ATOM   1323 HE21 GLN A  90      20.231  19.283  -6.074  1.00  0.00           H  
ATOM   1324 HE22 GLN A  90      19.328  18.917  -7.529  1.00  0.00           H  
ATOM   1325  N   SER A  91      20.876  26.592  -6.741  1.00  0.00           N  
ATOM   1326  CA  SER A  91      21.191  27.803  -7.497  1.00  0.00           C  
ATOM   1327  C   SER A  91      22.556  28.388  -7.104  1.00  0.00           C  
ATOM   1328  O   SER A  91      23.132  29.149  -7.880  1.00  0.00           O  
ATOM   1329  CB  SER A  91      20.047  28.829  -7.406  1.00  0.00           C  
ATOM   1330  OG  SER A  91      19.929  29.486  -6.156  1.00  0.00           O  
ATOM   1331  H   SER A  91      20.007  26.568  -6.219  1.00  0.00           H  
ATOM   1332  HA  SER A  91      21.246  27.519  -8.547  1.00  0.00           H  
ATOM   1333  HB2 SER A  91      20.213  29.589  -8.170  1.00  0.00           H  
ATOM   1334  HB3 SER A  91      19.102  28.335  -7.628  1.00  0.00           H  
ATOM   1335  HG  SER A  91      19.940  28.834  -5.428  1.00  0.00           H  
ATOM   1336  N   VAL A  92      23.103  28.009  -5.944  1.00  0.00           N  
ATOM   1337  CA  VAL A  92      24.399  28.453  -5.444  1.00  0.00           C  
ATOM   1338  C   VAL A  92      25.446  27.541  -6.085  1.00  0.00           C  
ATOM   1339  O   VAL A  92      25.397  26.333  -5.832  1.00  0.00           O  
ATOM   1340  CB  VAL A  92      24.452  28.333  -3.901  1.00  0.00           C  
ATOM   1341  CG1 VAL A  92      25.663  29.078  -3.317  1.00  0.00           C  
ATOM   1342  CG2 VAL A  92      23.180  28.861  -3.232  1.00  0.00           C  
ATOM   1343  H   VAL A  92      22.608  27.338  -5.370  1.00  0.00           H  
ATOM   1344  HA  VAL A  92      24.556  29.491  -5.724  1.00  0.00           H  
ATOM   1345  HB  VAL A  92      24.537  27.283  -3.621  1.00  0.00           H  
ATOM   1346 HG11 VAL A  92      25.675  29.004  -2.231  1.00  0.00           H  
ATOM   1347 HG12 VAL A  92      26.585  28.645  -3.704  1.00  0.00           H  
ATOM   1348 HG13 VAL A  92      25.618  30.134  -3.584  1.00  0.00           H  
ATOM   1349 HG21 VAL A  92      23.265  28.771  -2.153  1.00  0.00           H  
ATOM   1350 HG22 VAL A  92      23.013  29.903  -3.506  1.00  0.00           H  
ATOM   1351 HG23 VAL A  92      22.320  28.267  -3.531  1.00  0.00           H  
ATOM   1352  N   PRO A  93      26.365  28.038  -6.930  1.00  0.00           N  
ATOM   1353  CA  PRO A  93      27.432  27.199  -7.439  1.00  0.00           C  
ATOM   1354  C   PRO A  93      28.515  26.990  -6.374  1.00  0.00           C  
ATOM   1355  O   PRO A  93      28.521  27.613  -5.307  1.00  0.00           O  
ATOM   1356  CB  PRO A  93      27.935  27.906  -8.695  1.00  0.00           C  
ATOM   1357  CG  PRO A  93      27.679  29.376  -8.408  1.00  0.00           C  
ATOM   1358  CD  PRO A  93      26.492  29.395  -7.442  1.00  0.00           C  
ATOM   1359  HA  PRO A  93      27.033  26.224  -7.718  1.00  0.00           H  
ATOM   1360  HB2 PRO A  93      28.990  27.720  -8.892  1.00  0.00           H  
ATOM   1361  HB3 PRO A  93      27.334  27.590  -9.545  1.00  0.00           H  
ATOM   1362  HG2 PRO A  93      28.561  29.788  -7.927  1.00  0.00           H  
ATOM   1363  HG3 PRO A  93      27.456  29.916  -9.326  1.00  0.00           H  
ATOM   1364  HD2 PRO A  93      26.688  30.117  -6.646  1.00  0.00           H  
ATOM   1365  HD3 PRO A  93      25.589  29.661  -7.983  1.00  0.00           H  
ATOM   1366  N   ILE A  94      29.431  26.073  -6.669  1.00  0.00           N  
ATOM   1367  CA  ILE A  94      30.561  25.738  -5.827  1.00  0.00           C  
ATOM   1368  C   ILE A  94      31.442  26.984  -5.698  1.00  0.00           C  
ATOM   1369  O   ILE A  94      31.659  27.725  -6.662  1.00  0.00           O  
ATOM   1370  CB  ILE A  94      31.281  24.493  -6.400  1.00  0.00           C  
ATOM   1371  CG1 ILE A  94      30.314  23.282  -6.403  1.00  0.00           C  
ATOM   1372  CG2 ILE A  94      32.543  24.167  -5.587  1.00  0.00           C  
ATOM   1373  CD1 ILE A  94      30.861  22.033  -7.103  1.00  0.00           C  
ATOM   1374  H   ILE A  94      29.388  25.621  -7.575  1.00  0.00           H  
ATOM   1375  HA  ILE A  94      30.183  25.492  -4.837  1.00  0.00           H  
ATOM   1376  HB  ILE A  94      31.581  24.701  -7.427  1.00  0.00           H  
ATOM   1377 HG12 ILE A  94      30.042  23.028  -5.379  1.00  0.00           H  
ATOM   1378 HG13 ILE A  94      29.395  23.545  -6.927  1.00  0.00           H  
ATOM   1379 HG21 ILE A  94      33.068  23.322  -6.028  1.00  0.00           H  
ATOM   1380 HG22 ILE A  94      33.230  25.009  -5.605  1.00  0.00           H  
ATOM   1381 HG23 ILE A  94      32.268  23.954  -4.555  1.00  0.00           H  
ATOM   1382 HD11 ILE A  94      31.697  21.612  -6.546  1.00  0.00           H  
ATOM   1383 HD12 ILE A  94      30.071  21.285  -7.153  1.00  0.00           H  
ATOM   1384 HD13 ILE A  94      31.182  22.282  -8.115  1.00  0.00           H  
ATOM   1385  N   GLY A  95      31.948  27.201  -4.489  1.00  0.00           N  
ATOM   1386  CA  GLY A  95      32.828  28.291  -4.122  1.00  0.00           C  
ATOM   1387  C   GLY A  95      32.091  29.574  -3.754  1.00  0.00           C  
ATOM   1388  O   GLY A  95      32.771  30.536  -3.390  1.00  0.00           O  
ATOM   1389  H   GLY A  95      31.757  26.528  -3.754  1.00  0.00           H  
ATOM   1390  HA2 GLY A  95      33.420  27.976  -3.264  1.00  0.00           H  
ATOM   1391  HA3 GLY A  95      33.506  28.491  -4.946  1.00  0.00           H  
ATOM   1392  N   GLN A  96      30.754  29.620  -3.809  1.00  0.00           N  
ATOM   1393  CA  GLN A  96      29.997  30.787  -3.353  1.00  0.00           C  
ATOM   1394  C   GLN A  96      29.460  30.499  -1.958  1.00  0.00           C  
ATOM   1395  O   GLN A  96      29.559  29.369  -1.481  1.00  0.00           O  
ATOM   1396  CB  GLN A  96      28.848  31.119  -4.318  1.00  0.00           C  
ATOM   1397  CG  GLN A  96      29.270  31.290  -5.782  1.00  0.00           C  
ATOM   1398  CD  GLN A  96      30.207  32.453  -6.075  1.00  0.00           C  
ATOM   1399  OE1 GLN A  96      30.790  33.087  -5.199  1.00  0.00           O  
ATOM   1400  NE2 GLN A  96      30.392  32.748  -7.346  1.00  0.00           N  
ATOM   1401  H   GLN A  96      30.227  28.766  -3.988  1.00  0.00           H  
ATOM   1402  HA  GLN A  96      30.653  31.654  -3.280  1.00  0.00           H  
ATOM   1403  HB2 GLN A  96      28.118  30.312  -4.276  1.00  0.00           H  
ATOM   1404  HB3 GLN A  96      28.353  32.034  -3.989  1.00  0.00           H  
ATOM   1405  HG2 GLN A  96      29.736  30.369  -6.129  1.00  0.00           H  
ATOM   1406  HG3 GLN A  96      28.364  31.454  -6.361  1.00  0.00           H  
ATOM   1407 HE21 GLN A  96      29.911  32.234  -8.075  1.00  0.00           H  
ATOM   1408 HE22 GLN A  96      31.051  33.445  -7.650  1.00  0.00           H  
ATOM   1409  N   SER A  97      28.867  31.484  -1.293  1.00  0.00           N  
ATOM   1410  CA  SER A  97      28.269  31.322   0.001  1.00  0.00           C  
ATOM   1411  C   SER A  97      26.880  31.937   0.013  1.00  0.00           C  
ATOM   1412  O   SER A  97      26.565  32.814  -0.797  1.00  0.00           O  
ATOM   1413  CB  SER A  97      29.175  31.991   1.023  1.00  0.00           C  
ATOM   1414  OG  SER A  97      29.533  33.312   0.657  1.00  0.00           O  
ATOM   1415  H   SER A  97      28.781  32.437  -1.602  1.00  0.00           H  
ATOM   1416  HA  SER A  97      28.175  30.265   0.239  1.00  0.00           H  
ATOM   1417  HB2 SER A  97      28.616  32.034   1.935  1.00  0.00           H  
ATOM   1418  HB3 SER A  97      30.076  31.399   1.167  1.00  0.00           H  
ATOM   1419  HG  SER A  97      28.828  33.905   1.020  1.00  0.00           H  
ATOM   1420  N   VAL A  98      26.080  31.495   0.975  1.00  0.00           N  
ATOM   1421  CA  VAL A  98      24.767  32.049   1.261  1.00  0.00           C  
ATOM   1422  C   VAL A  98      24.608  32.249   2.758  1.00  0.00           C  
ATOM   1423  O   VAL A  98      25.249  31.545   3.539  1.00  0.00           O  
ATOM   1424  CB  VAL A  98      23.665  31.147   0.679  1.00  0.00           C  
ATOM   1425  CG1 VAL A  98      23.719  31.219  -0.845  1.00  0.00           C  
ATOM   1426  CG2 VAL A  98      23.776  29.683   1.143  1.00  0.00           C  
ATOM   1427  H   VAL A  98      26.420  30.768   1.592  1.00  0.00           H  
ATOM   1428  HA  VAL A  98      24.698  33.027   0.797  1.00  0.00           H  
ATOM   1429  HB  VAL A  98      22.696  31.528   0.982  1.00  0.00           H  
ATOM   1430 HG11 VAL A  98      23.766  32.257  -1.172  1.00  0.00           H  
ATOM   1431 HG12 VAL A  98      24.608  30.706  -1.202  1.00  0.00           H  
ATOM   1432 HG13 VAL A  98      22.817  30.776  -1.256  1.00  0.00           H  
ATOM   1433 HG21 VAL A  98      24.706  29.243   0.784  1.00  0.00           H  
ATOM   1434 HG22 VAL A  98      23.766  29.635   2.235  1.00  0.00           H  
ATOM   1435 HG23 VAL A  98      22.931  29.110   0.760  1.00  0.00           H  
ATOM   1436  N   ASN A  99      23.738  33.175   3.153  1.00  0.00           N  
ATOM   1437  CA  ASN A  99      23.307  33.307   4.537  1.00  0.00           C  
ATOM   1438  C   ASN A  99      22.171  32.319   4.783  1.00  0.00           C  
ATOM   1439  O   ASN A  99      21.511  31.897   3.830  1.00  0.00           O  
ATOM   1440  CB  ASN A  99      22.808  34.732   4.799  1.00  0.00           C  
ATOM   1441  CG  ASN A  99      23.201  35.138   6.204  1.00  0.00           C  
ATOM   1442  OD1 ASN A  99      22.492  34.891   7.173  1.00  0.00           O  
ATOM   1443  ND2 ASN A  99      24.370  35.731   6.338  1.00  0.00           N  
ATOM   1444  H   ASN A  99      23.186  33.661   2.461  1.00  0.00           H  
ATOM   1445  HA  ASN A  99      24.146  33.087   5.201  1.00  0.00           H  
ATOM   1446  HB2 ASN A  99      23.245  35.436   4.089  1.00  0.00           H  
ATOM   1447  HB3 ASN A  99      21.721  34.788   4.698  1.00  0.00           H  
ATOM   1448 HD21 ASN A  99      24.930  35.929   5.517  1.00  0.00           H  
ATOM   1449 HD22 ASN A  99      24.642  36.090   7.244  1.00  0.00           H  
ATOM   1450  N   LEU A 100      21.905  31.961   6.035  1.00  0.00           N  
ATOM   1451  CA  LEU A 100      20.766  31.139   6.430  1.00  0.00           C  
ATOM   1452  C   LEU A 100      20.344  31.655   7.805  1.00  0.00           C  
ATOM   1453  O   LEU A 100      21.213  31.967   8.620  1.00  0.00           O  
ATOM   1454  CB  LEU A 100      21.177  29.652   6.519  1.00  0.00           C  
ATOM   1455  CG  LEU A 100      21.703  29.010   5.215  1.00  0.00           C  
ATOM   1456  CD1 LEU A 100      22.473  27.722   5.504  1.00  0.00           C  
ATOM   1457  CD2 LEU A 100      20.610  28.697   4.190  1.00  0.00           C  
ATOM   1458  H   LEU A 100      22.452  32.337   6.805  1.00  0.00           H  
ATOM   1459  HA  LEU A 100      19.945  31.257   5.719  1.00  0.00           H  
ATOM   1460  HB2 LEU A 100      21.962  29.579   7.274  1.00  0.00           H  
ATOM   1461  HB3 LEU A 100      20.326  29.073   6.875  1.00  0.00           H  
ATOM   1462  HG  LEU A 100      22.407  29.681   4.736  1.00  0.00           H  
ATOM   1463 HD11 LEU A 100      21.801  26.974   5.911  1.00  0.00           H  
ATOM   1464 HD12 LEU A 100      22.944  27.363   4.591  1.00  0.00           H  
ATOM   1465 HD13 LEU A 100      23.253  27.918   6.239  1.00  0.00           H  
ATOM   1466 HD21 LEU A 100      19.951  29.557   4.093  1.00  0.00           H  
ATOM   1467 HD22 LEU A 100      21.078  28.531   3.222  1.00  0.00           H  
ATOM   1468 HD23 LEU A 100      20.048  27.805   4.484  1.00  0.00           H  
ATOM   1469  N   VAL A 101      19.043  31.720   8.087  1.00  0.00           N  
ATOM   1470  CA  VAL A 101      18.497  32.104   9.390  1.00  0.00           C  
ATOM   1471  C   VAL A 101      17.651  30.930   9.837  1.00  0.00           C  
ATOM   1472  O   VAL A 101      16.686  30.595   9.139  1.00  0.00           O  
ATOM   1473  CB  VAL A 101      17.605  33.359   9.311  1.00  0.00           C  
ATOM   1474  CG1 VAL A 101      17.251  33.911  10.700  1.00  0.00           C  
ATOM   1475  CG2 VAL A 101      18.241  34.482   8.480  1.00  0.00           C  
ATOM   1476  H   VAL A 101      18.368  31.450   7.379  1.00  0.00           H  
ATOM   1477  HA  VAL A 101      19.311  32.279  10.095  1.00  0.00           H  
ATOM   1478  HB  VAL A 101      16.663  33.053   8.854  1.00  0.00           H  
ATOM   1479 HG11 VAL A 101      18.148  34.266  11.211  1.00  0.00           H  
ATOM   1480 HG12 VAL A 101      16.541  34.738  10.596  1.00  0.00           H  
ATOM   1481 HG13 VAL A 101      16.784  33.130  11.304  1.00  0.00           H  
ATOM   1482 HG21 VAL A 101      18.413  34.156   7.455  1.00  0.00           H  
ATOM   1483 HG22 VAL A 101      17.582  35.351   8.460  1.00  0.00           H  
ATOM   1484 HG23 VAL A 101      19.197  34.776   8.900  1.00  0.00           H  
ATOM   1485  N   LEU A 102      18.010  30.306  10.960  1.00  0.00           N  
ATOM   1486  CA  LEU A 102      17.203  29.247  11.547  1.00  0.00           C  
ATOM   1487  C   LEU A 102      16.549  29.746  12.840  1.00  0.00           C  
ATOM   1488  O   LEU A 102      16.883  30.821  13.352  1.00  0.00           O  
ATOM   1489  CB  LEU A 102      17.980  27.916  11.719  1.00  0.00           C  
ATOM   1490  CG  LEU A 102      18.746  27.390  10.481  1.00  0.00           C  
ATOM   1491  CD1 LEU A 102      19.104  25.898  10.542  1.00  0.00           C  
ATOM   1492  CD2 LEU A 102      17.950  27.442   9.191  1.00  0.00           C  
ATOM   1493  H   LEU A 102      18.725  30.729  11.546  1.00  0.00           H  
ATOM   1494  HA  LEU A 102      16.392  29.046  10.858  1.00  0.00           H  
ATOM   1495  HB2 LEU A 102      18.683  28.013  12.544  1.00  0.00           H  
ATOM   1496  HB3 LEU A 102      17.256  27.163  12.017  1.00  0.00           H  
ATOM   1497  HG  LEU A 102      19.655  27.980  10.373  1.00  0.00           H  
ATOM   1498 HD11 LEU A 102      19.628  25.674  11.463  1.00  0.00           H  
ATOM   1499 HD12 LEU A 102      18.205  25.273  10.459  1.00  0.00           H  
ATOM   1500 HD13 LEU A 102      19.748  25.620   9.714  1.00  0.00           H  
ATOM   1501 HD21 LEU A 102      17.649  28.448   8.956  1.00  0.00           H  
ATOM   1502 HD22 LEU A 102      18.554  27.088   8.361  1.00  0.00           H  
ATOM   1503 HD23 LEU A 102      17.082  26.802   9.328  1.00  0.00           H  
ATOM   1504  N   CYS A 103      15.602  28.969  13.363  1.00  0.00           N  
ATOM   1505  CA  CYS A 103      14.958  29.190  14.653  1.00  0.00           C  
ATOM   1506  C   CYS A 103      15.194  27.944  15.510  1.00  0.00           C  
ATOM   1507  O   CYS A 103      15.245  26.832  14.971  1.00  0.00           O  
ATOM   1508  CB  CYS A 103      13.466  29.487  14.434  1.00  0.00           C  
ATOM   1509  SG  CYS A 103      12.672  29.995  15.984  1.00  0.00           S  
ATOM   1510  H   CYS A 103      15.384  28.102  12.880  1.00  0.00           H  
ATOM   1511  HA  CYS A 103      15.420  30.049  15.139  1.00  0.00           H  
ATOM   1512  HB2 CYS A 103      13.368  30.301  13.715  1.00  0.00           H  
ATOM   1513  HB3 CYS A 103      12.964  28.600  14.042  1.00  0.00           H  
ATOM   1514  HG  CYS A 103      13.514  31.003  16.264  1.00  0.00           H  
ATOM   1515  N   ARG A 104      15.393  28.127  16.820  1.00  0.00           N  
ATOM   1516  CA  ARG A 104      15.957  27.126  17.723  1.00  0.00           C  
ATOM   1517  C   ARG A 104      15.071  26.900  18.928  1.00  0.00           C  
ATOM   1518  O   ARG A 104      14.726  27.867  19.604  1.00  0.00           O  
ATOM   1519  CB  ARG A 104      17.339  27.600  18.176  1.00  0.00           C  
ATOM   1520  CG  ARG A 104      18.143  26.467  18.827  1.00  0.00           C  
ATOM   1521  CD  ARG A 104      19.648  26.648  18.636  1.00  0.00           C  
ATOM   1522  NE  ARG A 104      20.039  26.334  17.260  1.00  0.00           N  
ATOM   1523  CZ  ARG A 104      21.280  26.019  16.886  1.00  0.00           C  
ATOM   1524  NH1 ARG A 104      22.316  26.332  17.654  1.00  0.00           N  
ATOM   1525  NH2 ARG A 104      21.492  25.406  15.735  1.00  0.00           N  
ATOM   1526  H   ARG A 104      15.325  29.070  17.175  1.00  0.00           H  
ATOM   1527  HA  ARG A 104      16.065  26.188  17.178  1.00  0.00           H  
ATOM   1528  HB2 ARG A 104      17.859  27.988  17.310  1.00  0.00           H  
ATOM   1529  HB3 ARG A 104      17.242  28.423  18.883  1.00  0.00           H  
ATOM   1530  HG2 ARG A 104      17.918  26.447  19.889  1.00  0.00           H  
ATOM   1531  HG3 ARG A 104      17.859  25.502  18.407  1.00  0.00           H  
ATOM   1532  HD2 ARG A 104      19.952  27.661  18.890  1.00  0.00           H  
ATOM   1533  HD3 ARG A 104      20.159  25.946  19.292  1.00  0.00           H  
ATOM   1534  HE  ARG A 104      19.274  26.239  16.592  1.00  0.00           H  
ATOM   1535 HH11 ARG A 104      22.194  26.843  18.524  1.00  0.00           H  
ATOM   1536 HH12 ARG A 104      23.273  26.065  17.440  1.00  0.00           H  
ATOM   1537 HH21 ARG A 104      20.716  25.032  15.173  1.00  0.00           H  
ATOM   1538 HH22 ARG A 104      22.420  25.163  15.413  1.00  0.00           H  
ATOM   1539  N   GLY A 105      14.774  25.641  19.232  1.00  0.00           N  
ATOM   1540  CA  GLY A 105      13.765  25.252  20.208  1.00  0.00           C  
ATOM   1541  C   GLY A 105      12.791  24.249  19.597  1.00  0.00           C  
ATOM   1542  O   GLY A 105      12.152  23.495  20.326  1.00  0.00           O  
ATOM   1543  H   GLY A 105      15.183  24.885  18.690  1.00  0.00           H  
ATOM   1544  HA2 GLY A 105      14.241  24.807  21.078  1.00  0.00           H  
ATOM   1545  HA3 GLY A 105      13.197  26.124  20.526  1.00  0.00           H  
ATOM   1546  N   TYR A 106      12.688  24.218  18.267  1.00  0.00           N  
ATOM   1547  CA  TYR A 106      11.954  23.204  17.535  1.00  0.00           C  
ATOM   1548  C   TYR A 106      12.703  21.871  17.634  1.00  0.00           C  
ATOM   1549  O   TYR A 106      13.937  21.868  17.559  1.00  0.00           O  
ATOM   1550  CB  TYR A 106      11.785  23.645  16.074  1.00  0.00           C  
ATOM   1551  CG  TYR A 106      10.569  24.529  15.880  1.00  0.00           C  
ATOM   1552  CD1 TYR A 106       9.303  23.924  15.923  1.00  0.00           C  
ATOM   1553  CD2 TYR A 106      10.675  25.924  15.691  1.00  0.00           C  
ATOM   1554  CE1 TYR A 106       8.142  24.693  15.794  1.00  0.00           C  
ATOM   1555  CE2 TYR A 106       9.509  26.713  15.600  1.00  0.00           C  
ATOM   1556  CZ  TYR A 106       8.235  26.094  15.647  1.00  0.00           C  
ATOM   1557  OH  TYR A 106       7.091  26.829  15.556  1.00  0.00           O  
ATOM   1558  H   TYR A 106      13.224  24.887  17.736  1.00  0.00           H  
ATOM   1559  HA  TYR A 106      10.971  23.111  17.993  1.00  0.00           H  
ATOM   1560  HB2 TYR A 106      12.688  24.145  15.723  1.00  0.00           H  
ATOM   1561  HB3 TYR A 106      11.656  22.758  15.454  1.00  0.00           H  
ATOM   1562  HD1 TYR A 106       9.216  22.854  16.050  1.00  0.00           H  
ATOM   1563  HD2 TYR A 106      11.650  26.391  15.618  1.00  0.00           H  
ATOM   1564  HE1 TYR A 106       7.193  24.183  15.830  1.00  0.00           H  
ATOM   1565  HE2 TYR A 106       9.596  27.788  15.491  1.00  0.00           H  
ATOM   1566  HH  TYR A 106       6.322  26.227  15.581  1.00  0.00           H  
ATOM   1567  N   PRO A 107      12.000  20.742  17.821  1.00  0.00           N  
ATOM   1568  CA  PRO A 107      12.585  19.424  17.654  1.00  0.00           C  
ATOM   1569  C   PRO A 107      12.688  19.061  16.176  1.00  0.00           C  
ATOM   1570  O   PRO A 107      12.190  19.761  15.292  1.00  0.00           O  
ATOM   1571  CB  PRO A 107      11.631  18.468  18.368  1.00  0.00           C  
ATOM   1572  CG  PRO A 107      10.268  19.142  18.204  1.00  0.00           C  
ATOM   1573  CD  PRO A 107      10.585  20.635  18.144  1.00  0.00           C  
ATOM   1574  HA  PRO A 107      13.576  19.383  18.110  1.00  0.00           H  
ATOM   1575  HB2 PRO A 107      11.629  17.465  17.943  1.00  0.00           H  
ATOM   1576  HB3 PRO A 107      11.929  18.404  19.407  1.00  0.00           H  
ATOM   1577  HG2 PRO A 107       9.835  18.840  17.251  1.00  0.00           H  
ATOM   1578  HG3 PRO A 107       9.597  18.901  19.028  1.00  0.00           H  
ATOM   1579  HD2 PRO A 107       9.981  21.110  17.373  1.00  0.00           H  
ATOM   1580  HD3 PRO A 107      10.387  21.098  19.110  1.00  0.00           H  
ATOM   1581  N   LEU A 108      13.243  17.881  15.917  1.00  0.00           N  
ATOM   1582  CA  LEU A 108      13.051  17.202  14.638  1.00  0.00           C  
ATOM   1583  C   LEU A 108      11.567  16.943  14.393  1.00  0.00           C  
ATOM   1584  O   LEU A 108      10.813  16.785  15.362  1.00  0.00           O  
ATOM   1585  CB  LEU A 108      13.767  15.844  14.620  1.00  0.00           C  
ATOM   1586  CG  LEU A 108      15.203  15.962  14.064  1.00  0.00           C  
ATOM   1587  CD1 LEU A 108      16.246  15.743  15.167  1.00  0.00           C  
ATOM   1588  CD2 LEU A 108      15.403  15.001  12.894  1.00  0.00           C  
ATOM   1589  H   LEU A 108      13.507  17.363  16.743  1.00  0.00           H  
ATOM   1590  HA  LEU A 108      13.422  17.845  13.841  1.00  0.00           H  
ATOM   1591  HB2 LEU A 108      13.781  15.412  15.620  1.00  0.00           H  
ATOM   1592  HB3 LEU A 108      13.155  15.161  14.012  1.00  0.00           H  
ATOM   1593  HG  LEU A 108      15.367  16.963  13.672  1.00  0.00           H  
ATOM   1594 HD11 LEU A 108      16.013  16.385  16.019  1.00  0.00           H  
ATOM   1595 HD12 LEU A 108      16.238  14.702  15.485  1.00  0.00           H  
ATOM   1596 HD13 LEU A 108      17.234  16.017  14.807  1.00  0.00           H  
ATOM   1597 HD21 LEU A 108      14.759  15.320  12.073  1.00  0.00           H  
ATOM   1598 HD22 LEU A 108      16.428  15.024  12.534  1.00  0.00           H  
ATOM   1599 HD23 LEU A 108      15.138  13.984  13.184  1.00  0.00           H  
ATOM   1600  N   PRO A 109      11.150  16.753  13.132  1.00  0.00           N  
ATOM   1601  CA  PRO A 109       9.845  16.213  12.858  1.00  0.00           C  
ATOM   1602  C   PRO A 109       9.822  14.755  13.320  1.00  0.00           C  
ATOM   1603  O   PRO A 109      10.801  14.002  13.224  1.00  0.00           O  
ATOM   1604  CB  PRO A 109       9.610  16.381  11.357  1.00  0.00           C  
ATOM   1605  CG  PRO A 109      11.016  16.405  10.767  1.00  0.00           C  
ATOM   1606  CD  PRO A 109      11.926  16.844  11.908  1.00  0.00           C  
ATOM   1607  HA  PRO A 109       9.100  16.795  13.398  1.00  0.00           H  
ATOM   1608  HB2 PRO A 109       9.017  15.566  10.936  1.00  0.00           H  
ATOM   1609  HB3 PRO A 109       9.130  17.345  11.176  1.00  0.00           H  
ATOM   1610  HG2 PRO A 109      11.300  15.410  10.435  1.00  0.00           H  
ATOM   1611  HG3 PRO A 109      11.093  17.088   9.926  1.00  0.00           H  
ATOM   1612  HD2 PRO A 109      12.782  16.180  11.928  1.00  0.00           H  
ATOM   1613  HD3 PRO A 109      12.260  17.865  11.766  1.00  0.00           H  
ATOM   1614  N   PHE A 110       8.697  14.380  13.899  1.00  0.00           N  
ATOM   1615  CA  PHE A 110       8.187  13.017  13.878  1.00  0.00           C  
ATOM   1616  C   PHE A 110       7.905  12.670  12.413  1.00  0.00           C  
ATOM   1617  O   PHE A 110       7.300  13.472  11.701  1.00  0.00           O  
ATOM   1618  CB  PHE A 110       6.918  12.953  14.739  1.00  0.00           C  
ATOM   1619  CG  PHE A 110       5.974  11.804  14.431  1.00  0.00           C  
ATOM   1620  CD1 PHE A 110       6.330  10.478  14.743  1.00  0.00           C  
ATOM   1621  CD2 PHE A 110       4.729  12.067  13.825  1.00  0.00           C  
ATOM   1622  CE1 PHE A 110       5.452   9.424  14.437  1.00  0.00           C  
ATOM   1623  CE2 PHE A 110       3.849  11.014  13.529  1.00  0.00           C  
ATOM   1624  CZ  PHE A 110       4.214   9.690  13.825  1.00  0.00           C  
ATOM   1625  H   PHE A 110       8.017  15.127  13.935  1.00  0.00           H  
ATOM   1626  HA  PHE A 110       8.929  12.327  14.279  1.00  0.00           H  
ATOM   1627  HB2 PHE A 110       7.213  12.894  15.787  1.00  0.00           H  
ATOM   1628  HB3 PHE A 110       6.361  13.880  14.611  1.00  0.00           H  
ATOM   1629  HD1 PHE A 110       7.281  10.263  15.207  1.00  0.00           H  
ATOM   1630  HD2 PHE A 110       4.441  13.079  13.578  1.00  0.00           H  
ATOM   1631  HE1 PHE A 110       5.740   8.408  14.656  1.00  0.00           H  
ATOM   1632  HE2 PHE A 110       2.898  11.229  13.063  1.00  0.00           H  
ATOM   1633  HZ  PHE A 110       3.551   8.879  13.560  1.00  0.00           H  
ATOM   1634  N   ASP A 111       8.360  11.499  11.972  1.00  0.00           N  
ATOM   1635  CA  ASP A 111       8.130  10.982  10.629  1.00  0.00           C  
ATOM   1636  C   ASP A 111       6.902  10.079  10.694  1.00  0.00           C  
ATOM   1637  O   ASP A 111       6.996   9.017  11.311  1.00  0.00           O  
ATOM   1638  CB  ASP A 111       9.323  10.146  10.154  1.00  0.00           C  
ATOM   1639  CG  ASP A 111      10.438  11.003   9.584  1.00  0.00           C  
ATOM   1640  OD1 ASP A 111      10.317  11.483   8.435  1.00  0.00           O  
ATOM   1641  OD2 ASP A 111      11.477  11.162  10.263  1.00  0.00           O  
ATOM   1642  H   ASP A 111       8.772  10.851  12.622  1.00  0.00           H  
ATOM   1643  HA  ASP A 111       7.974  11.806   9.931  1.00  0.00           H  
ATOM   1644  HB2 ASP A 111       9.695   9.534  10.979  1.00  0.00           H  
ATOM   1645  HB3 ASP A 111       8.984   9.490   9.352  1.00  0.00           H  
ATOM   1646  N   PRO A 112       5.750  10.448  10.110  1.00  0.00           N  
ATOM   1647  CA  PRO A 112       4.562   9.613  10.178  1.00  0.00           C  
ATOM   1648  C   PRO A 112       4.664   8.358   9.299  1.00  0.00           C  
ATOM   1649  O   PRO A 112       3.939   7.397   9.562  1.00  0.00           O  
ATOM   1650  CB  PRO A 112       3.408  10.528   9.766  1.00  0.00           C  
ATOM   1651  CG  PRO A 112       4.070  11.535   8.826  1.00  0.00           C  
ATOM   1652  CD  PRO A 112       5.453  11.710   9.451  1.00  0.00           C  
ATOM   1653  HA  PRO A 112       4.405   9.286  11.204  1.00  0.00           H  
ATOM   1654  HB2 PRO A 112       2.612   9.971   9.278  1.00  0.00           H  
ATOM   1655  HB3 PRO A 112       3.026  11.050  10.645  1.00  0.00           H  
ATOM   1656  HG2 PRO A 112       4.170  11.103   7.828  1.00  0.00           H  
ATOM   1657  HG3 PRO A 112       3.522  12.478   8.788  1.00  0.00           H  
ATOM   1658  HD2 PRO A 112       6.188  11.945   8.684  1.00  0.00           H  
ATOM   1659  HD3 PRO A 112       5.425  12.508  10.191  1.00  0.00           H  
ATOM   1660  N   GLU A 113       5.519   8.352   8.269  1.00  0.00           N  
ATOM   1661  CA  GLU A 113       5.721   7.233   7.362  1.00  0.00           C  
ATOM   1662  C   GLU A 113       6.384   6.077   8.118  1.00  0.00           C  
ATOM   1663  O   GLU A 113       5.806   4.996   8.240  1.00  0.00           O  
ATOM   1664  CB  GLU A 113       6.563   7.741   6.174  1.00  0.00           C  
ATOM   1665  CG  GLU A 113       6.111   7.233   4.808  1.00  0.00           C  
ATOM   1666  CD  GLU A 113       6.629   5.841   4.423  1.00  0.00           C  
ATOM   1667  OE1 GLU A 113       7.847   5.656   4.189  1.00  0.00           O  
ATOM   1668  OE2 GLU A 113       5.784   4.933   4.221  1.00  0.00           O  
ATOM   1669  H   GLU A 113       6.047   9.177   8.030  1.00  0.00           H  
ATOM   1670  HA  GLU A 113       4.744   6.905   7.000  1.00  0.00           H  
ATOM   1671  HB2 GLU A 113       6.474   8.827   6.127  1.00  0.00           H  
ATOM   1672  HB3 GLU A 113       7.619   7.523   6.316  1.00  0.00           H  
ATOM   1673  HG2 GLU A 113       5.021   7.257   4.753  1.00  0.00           H  
ATOM   1674  HG3 GLU A 113       6.483   7.952   4.086  1.00  0.00           H  
ATOM   1675  N   ASP A 114       7.591   6.307   8.643  1.00  0.00           N  
ATOM   1676  CA  ASP A 114       8.332   5.371   9.485  1.00  0.00           C  
ATOM   1677  C   ASP A 114       9.342   6.162  10.327  1.00  0.00           C  
ATOM   1678  O   ASP A 114      10.336   6.638   9.764  1.00  0.00           O  
ATOM   1679  CB  ASP A 114       9.068   4.312   8.646  1.00  0.00           C  
ATOM   1680  CG  ASP A 114      10.013   3.473   9.513  1.00  0.00           C  
ATOM   1681  OD1 ASP A 114       9.822   3.374  10.736  1.00  0.00           O  
ATOM   1682  OD2 ASP A 114      10.978   2.890   8.948  1.00  0.00           O  
ATOM   1683  H   ASP A 114       8.004   7.223   8.530  1.00  0.00           H  
ATOM   1684  HA  ASP A 114       7.637   4.838  10.130  1.00  0.00           H  
ATOM   1685  HB2 ASP A 114       8.336   3.651   8.180  1.00  0.00           H  
ATOM   1686  HB3 ASP A 114       9.647   4.803   7.863  1.00  0.00           H  
ATOM   1687  N   PRO A 115       9.107   6.341  11.639  1.00  0.00           N  
ATOM   1688  CA  PRO A 115      10.033   7.019  12.534  1.00  0.00           C  
ATOM   1689  C   PRO A 115      11.115   6.099  13.120  1.00  0.00           C  
ATOM   1690  O   PRO A 115      12.038   6.632  13.746  1.00  0.00           O  
ATOM   1691  CB  PRO A 115       9.140   7.555  13.655  1.00  0.00           C  
ATOM   1692  CG  PRO A 115       8.104   6.441  13.799  1.00  0.00           C  
ATOM   1693  CD  PRO A 115       7.883   6.002  12.354  1.00  0.00           C  
ATOM   1694  HA  PRO A 115      10.521   7.848  12.024  1.00  0.00           H  
ATOM   1695  HB2 PRO A 115       9.689   7.724  14.580  1.00  0.00           H  
ATOM   1696  HB3 PRO A 115       8.656   8.475  13.331  1.00  0.00           H  
ATOM   1697  HG2 PRO A 115       8.524   5.616  14.377  1.00  0.00           H  
ATOM   1698  HG3 PRO A 115       7.182   6.794  14.253  1.00  0.00           H  
ATOM   1699  HD2 PRO A 115       7.688   4.933  12.323  1.00  0.00           H  
ATOM   1700  HD3 PRO A 115       7.044   6.544  11.919  1.00  0.00           H  
ATOM   1701  N   ALA A 116      11.007   4.770  12.948  1.00  0.00           N  
ATOM   1702  CA  ALA A 116      11.719   3.674  13.610  1.00  0.00           C  
ATOM   1703  C   ALA A 116      10.748   2.518  13.862  1.00  0.00           C  
ATOM   1704  O   ALA A 116      10.029   2.533  14.864  1.00  0.00           O  
ATOM   1705  CB  ALA A 116      12.408   4.071  14.923  1.00  0.00           C  
ATOM   1706  H   ALA A 116      10.284   4.437  12.311  1.00  0.00           H  
ATOM   1707  HA  ALA A 116      12.486   3.314  12.932  1.00  0.00           H  
ATOM   1708  HB1 ALA A 116      13.311   4.639  14.721  1.00  0.00           H  
ATOM   1709  HB2 ALA A 116      11.740   4.681  15.527  1.00  0.00           H  
ATOM   1710  HB3 ALA A 116      12.667   3.173  15.483  1.00  0.00           H  
ATOM   1711  N   ASN A 117      10.760   1.517  12.978  1.00  0.00           N  
ATOM   1712  CA  ASN A 117      10.026   0.254  13.087  1.00  0.00           C  
ATOM   1713  C   ASN A 117      10.998  -0.906  12.838  1.00  0.00           C  
ATOM   1714  O   ASN A 117      12.180  -0.686  12.544  1.00  0.00           O  
ATOM   1715  CB  ASN A 117       8.866   0.209  12.072  1.00  0.00           C  
ATOM   1716  CG  ASN A 117       7.675   1.053  12.488  1.00  0.00           C  
ATOM   1717  OD1 ASN A 117       6.698   0.551  13.039  1.00  0.00           O  
ATOM   1718  ND2 ASN A 117       7.701   2.341  12.210  1.00  0.00           N  
ATOM   1719  H   ASN A 117      11.384   1.583  12.178  1.00  0.00           H  
ATOM   1720  HA  ASN A 117       9.609   0.158  14.090  1.00  0.00           H  
ATOM   1721  HB2 ASN A 117       9.219   0.515  11.087  1.00  0.00           H  
ATOM   1722  HB3 ASN A 117       8.506  -0.814  11.977  1.00  0.00           H  
ATOM   1723 HD21 ASN A 117       8.516   2.709  11.707  1.00  0.00           H  
ATOM   1724 HD22 ASN A 117       6.954   2.949  12.499  1.00  0.00           H  
ATOM   1725  N   SER A 118      10.539  -2.154  12.963  1.00  0.00           N  
ATOM   1726  CA  SER A 118      11.155  -3.377  12.456  1.00  0.00           C  
ATOM   1727  C   SER A 118      10.103  -4.496  12.448  1.00  0.00           C  
ATOM   1728  O   SER A 118       9.068  -4.395  13.112  1.00  0.00           O  
ATOM   1729  CB  SER A 118      12.351  -3.776  13.337  1.00  0.00           C  
ATOM   1730  OG  SER A 118      13.444  -2.920  13.041  1.00  0.00           O  
ATOM   1731  H   SER A 118       9.590  -2.292  13.290  1.00  0.00           H  
ATOM   1732  HA  SER A 118      11.484  -3.213  11.426  1.00  0.00           H  
ATOM   1733  HB2 SER A 118      12.082  -3.685  14.392  1.00  0.00           H  
ATOM   1734  HB3 SER A 118      12.638  -4.809  13.133  1.00  0.00           H  
ATOM   1735  HG  SER A 118      13.030  -2.046  12.856  1.00  0.00           H  
ATOM   1736  N   GLY A 119      10.396  -5.575  11.716  1.00  0.00           N  
ATOM   1737  CA  GLY A 119       9.544  -6.745  11.574  1.00  0.00           C  
ATOM   1738  C   GLY A 119       9.752  -7.773  12.695  1.00  0.00           C  
ATOM   1739  O   GLY A 119      10.193  -7.414  13.791  1.00  0.00           O  
ATOM   1740  H   GLY A 119      11.259  -5.612  11.195  1.00  0.00           H  
ATOM   1741  HA2 GLY A 119       8.501  -6.427  11.578  1.00  0.00           H  
ATOM   1742  HA3 GLY A 119       9.760  -7.202  10.613  1.00  0.00           H  
ATOM   1743  N   PRO A 120       9.366  -9.045  12.479  1.00  0.00           N  
ATOM   1744  CA  PRO A 120       9.318 -10.084  13.502  1.00  0.00           C  
ATOM   1745  C   PRO A 120      10.702 -10.703  13.772  1.00  0.00           C  
ATOM   1746  O   PRO A 120      10.892 -11.920  13.645  1.00  0.00           O  
ATOM   1747  CB  PRO A 120       8.294 -11.086  12.954  1.00  0.00           C  
ATOM   1748  CG  PRO A 120       8.592 -11.062  11.458  1.00  0.00           C  
ATOM   1749  CD  PRO A 120       8.845  -9.574  11.226  1.00  0.00           C  
ATOM   1750  HA  PRO A 120       8.935  -9.681  14.439  1.00  0.00           H  
ATOM   1751  HB2 PRO A 120       8.386 -12.078  13.385  1.00  0.00           H  
ATOM   1752  HB3 PRO A 120       7.286 -10.715  13.138  1.00  0.00           H  
ATOM   1753  HG2 PRO A 120       9.498 -11.635  11.240  1.00  0.00           H  
ATOM   1754  HG3 PRO A 120       7.744 -11.420  10.881  1.00  0.00           H  
ATOM   1755  HD2 PRO A 120       9.554  -9.438  10.413  1.00  0.00           H  
ATOM   1756  HD3 PRO A 120       7.908  -9.075  10.994  1.00  0.00           H  
ATOM   1757  N   SER A 121      11.667  -9.893  14.202  1.00  0.00           N  
ATOM   1758  CA  SER A 121      12.802 -10.375  14.977  1.00  0.00           C  
ATOM   1759  C   SER A 121      12.229 -10.905  16.296  1.00  0.00           C  
ATOM   1760  O   SER A 121      11.384 -10.248  16.910  1.00  0.00           O  
ATOM   1761  CB  SER A 121      13.789  -9.220  15.220  1.00  0.00           C  
ATOM   1762  OG  SER A 121      15.111  -9.542  14.807  1.00  0.00           O  
ATOM   1763  H   SER A 121      11.464  -8.899  14.231  1.00  0.00           H  
ATOM   1764  HA  SER A 121      13.295 -11.178  14.426  1.00  0.00           H  
ATOM   1765  HB2 SER A 121      13.460  -8.333  14.675  1.00  0.00           H  
ATOM   1766  HB3 SER A 121      13.804  -8.971  16.278  1.00  0.00           H  
ATOM   1767  HG  SER A 121      15.650  -9.713  15.618  1.00  0.00           H  
ATOM   1768  N   SER A 122      12.631 -12.097  16.728  1.00  0.00           N  
ATOM   1769  CA  SER A 122      12.431 -12.510  18.115  1.00  0.00           C  
ATOM   1770  C   SER A 122      13.394 -11.715  19.011  1.00  0.00           C  
ATOM   1771  O   SER A 122      14.383 -11.154  18.521  1.00  0.00           O  
ATOM   1772  CB  SER A 122      12.609 -14.034  18.239  1.00  0.00           C  
ATOM   1773  OG  SER A 122      13.637 -14.570  17.418  1.00  0.00           O  
ATOM   1774  H   SER A 122      13.307 -12.621  16.190  1.00  0.00           H  
ATOM   1775  HA  SER A 122      11.413 -12.263  18.425  1.00  0.00           H  
ATOM   1776  HB2 SER A 122      12.805 -14.298  19.277  1.00  0.00           H  
ATOM   1777  HB3 SER A 122      11.672 -14.508  17.946  1.00  0.00           H  
ATOM   1778  HG  SER A 122      14.490 -14.161  17.674  1.00  0.00           H  
ATOM   1779  N   GLY A 123      13.152 -11.689  20.317  1.00  0.00           N  
ATOM   1780  CA  GLY A 123      13.977 -11.006  21.298  1.00  0.00           C  
ATOM   1781  C   GLY A 123      13.092 -10.496  22.418  1.00  0.00           C  
ATOM   1782  O   GLY A 123      13.640  -9.853  23.337  1.00  0.00           O  
ATOM   1783  H   GLY A 123      12.267 -11.980  20.715  1.00  0.00           H  
ATOM   1784  HA2 GLY A 123      14.700 -11.710  21.707  1.00  0.00           H  
ATOM   1785  HA3 GLY A 123      14.491 -10.158  20.844  1.00  0.00           H  
TER    1786      GLY A 123                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
