
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  247 ( 2001),  selected  247 , name 1e58_A
# Molecule2: number of CA atoms  247 ( 1945),  selected  247 , name T0394.pdb
# PARAMETERS: 1e58_A.T0394.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      N       1           -
LGA    -       -      L       2           -
LGA    -       -      Y       3           -
LGA    -       -      F       4           -
LGA    -       -      Q       5           -
LGA    -       -      S       6           -
LGA    V     2_A      A       7           #
LGA    T     3_A      R       8          3.808
LGA    -       -      F       9           -
LGA    K     4_A      A      10          1.460
LGA    L     5_A      L      11          1.016
LGA    V     6_A      T      12          0.500
LGA    L     7_A      V      13          0.414
LGA    V     8_A      V      14          0.243
LGA    R     9_A      R      15          0.530
LGA    X    10_A      H      16          0.515
LGA    G    11_A      G      17          0.760
LGA    E    12_A      E      18          0.950
LGA    S    13_A      T      19          1.379
LGA    Q    14_A      R      20          1.241
LGA    W    15_A      F      21          0.501
LGA    N    16_A      N      22          0.263
LGA    K    17_A      K      23          0.772
LGA    E    18_A      E      24          1.624
LGA    N    19_A      K      25          1.502
LGA    R    20_A      I      26          0.704
LGA    F    21_A      I      27          0.650
LGA    T    22_A      Q      28          1.060
LGA    G    23_A      G      29          0.853
LGA    W    24_A      Q      30          0.437
LGA    Y    25_A      G      31          1.999
LGA    -       -      V      32           -
LGA    D    26_A      D      33          0.580
LGA    V    27_A      E      34          0.689
LGA    D    28_A      P      35          0.839
LGA    L    29_A      L      36          0.798
LGA    S    30_A      S      37          1.206
LGA    E    31_A      E      38          1.031
LGA    K    32_A      T      39          0.873
LGA    G    33_A      G      40          0.961
LGA    V    34_A      F      41          0.885
LGA    S    35_A      K      42          0.911
LGA    E    36_A      Q      43          0.891
LGA    A    37_A      A      44          0.949
LGA    K    38_A      A      45          1.093
LGA    A    39_A      A      46          0.956
LGA    A    40_A      A      47          1.104
LGA    G    41_A      G      48          1.523
LGA    K    42_A      I      49          1.036
LGA    L    43_A      F      50          0.967
LGA    L    44_A      L      51          1.639
LGA    K    45_A      N      52          2.344
LGA    E    46_A      -       -           -
LGA    E    47_A      -       -           -
LGA    G    48_A      N      53          4.301
LGA    Y    49_A      V      54          1.710
LGA    S    50_A      K      55          1.861
LGA    F    51_A      F      56          1.043
LGA    D    52_A      T      57          1.383
LGA    F    53_A      H      58          1.285
LGA    A    54_A      A      59          0.829
LGA    Y    55_A      F      60          0.902
LGA    T    56_A      S      61          0.939
LGA    S    57_A      S      62          0.958
LGA    V    58_A      D      63          1.102
LGA    L    59_A      L      64          0.603
LGA    K    60_A      M      65          0.539
LGA    R    61_A      R      66          0.366
LGA    A    62_A      T      67          0.514
LGA    I    63_A      K      68          0.707
LGA    H    64_A      Q      69          0.575
LGA    T    65_A      T      70          0.511
LGA    L    66_A      M      71          0.388
LGA    W    67_A      H      72          0.596
LGA    N    68_A      G      73          0.561
LGA    V    69_A      I      74          0.480
LGA    L    70_A      L      75          0.503
LGA    D    71_A      E      76          0.858
LGA    E    72_A      R      77          1.315
LGA    L    73_A      S      78          0.828
LGA    D    74_A      K      79          3.893
LGA    -       -      F      80           -
LGA    Q    75_A      C      81          2.091
LGA    A    76_A      K      82          3.027
LGA    W    77_A      D      83          1.488
LGA    L    78_A      M      84          0.797
LGA    P    79_A      T      85          1.890
LGA    V    80_A      V      86          1.500
LGA    E    81_A      K      87          1.220
LGA    K    82_A      Y      88          0.663
LGA    S    83_A      D      89          1.383
LGA    W    84_A      S      90          1.269
LGA    K    85_A      R      91          1.114
LGA    L    86_A      L      92          0.840
LGA    N    87_A      R      93          0.566
LGA    E    88_A      E      94          0.297
LGA    R    89_A      R      95          0.373
LGA    H    90_A      K      96          0.465
LGA    Y    91_A      Y      97          0.613
LGA    G    92_A      G      98          0.960
LGA    A    93_A      V      99          0.581
LGA    L    94_A      V     100          0.375
LGA    Q    95_A      E     101          0.545
LGA    G    96_A      G     102          0.845
LGA    L    97_A      K     103          0.872
LGA    N    98_A      A     104          1.833
LGA    K    99_A      L     105          2.178
LGA    A   100_A      S     106          3.752
LGA    E   101_A      -       -           -
LGA    T   102_A      -       -           -
LGA    A   103_A      E     107          4.275
LGA    E   104_A      L     108           -
LGA    K   105_A      -       -           -
LGA    Y   106_A      -       -           -
LGA    G   107_A      -       -           -
LGA    D   108_A      -       -           -
LGA    E   109_A      R     109           #
LGA    Q   110_A      A     110          3.995
LGA    V   111_A      M     111           #
LGA    -       -      A     112           -
LGA    -       -      K     113           -
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    -       -      R     116           -
LGA    K   112_A      E     117           #
LGA    Q   113_A      E     118          2.664
LGA    W   114_A      C     119          4.242
LGA    R   115_A      P     120          3.852
LGA    R   116_A      -       -           -
LGA    G   117_A      V     121          1.337
LGA    F   118_A      -       -           -
LGA    A   119_A      -       -           -
LGA    V   120_A      F     122          2.688
LGA    T   121_A      T     123          1.083
LGA    P   122_A      P     124          1.414
LGA    P   123_A      P     125          2.743
LGA    E   124_A      G     126          3.214
LGA    L   125_A      -       -           -
LGA    T   126_A      -       -           -
LGA    K   127_A      -       -           -
LGA    D   128_A      -       -           -
LGA    D   129_A      -       -           -
LGA    E   130_A      -       -           -
LGA    R   131_A      -       -           -
LGA    Y   132_A      -       -           -
LGA    P   133_A      -       -           -
LGA    G   134_A      -       -           -
LGA    H   135_A      -       -           -
LGA    D   136_A      -       -           -
LGA    P   137_A      -       -           -
LGA    R   138_A      -       -           -
LGA    Y   139_A      -       -           -
LGA    A   140_A      -       -           -
LGA    K   141_A      -       -           -
LGA    L   142_A      -       -           -
LGA    S   143_A      -       -           -
LGA    E   144_A      -       -           -
LGA    K   145_A      -       -           -
LGA    E   146_A      -       -           -
LGA    L   147_A      -       -           -
LGA    P   148_A      -       -           -
LGA    L   149_A      -       -           -
LGA    T   150_A      G     127          1.486
LGA    E   151_A      E     128          0.823
LGA    S   152_A      T     129          1.874
LGA    L   153_A      L     130          1.696
LGA    A   154_A      D     131          1.235
LGA    L   155_A      Q     132          0.970
LGA    T   156_A      V     133          0.838
LGA    I   157_A      K     134          1.225
LGA    D   158_A      M     135          1.802
LGA    R   159_A      R     136          2.042
LGA    V   160_A      G     137          2.337
LGA    I   161_A      I     138          0.947
LGA    P   162_A      D     139          1.367
LGA    Y   163_A      F     140          2.165
LGA    W   164_A      F     141          1.508
LGA    N   165_A      E     142          0.567
LGA    E   166_A      F     143          2.491
LGA    T   167_A      -       -           -
LGA    I   168_A      L     144          1.078
LGA    L   169_A      C     145          1.500
LGA    P   170_A      Q     146          2.002
LGA    R   171_A      L     147          2.697
LGA    M   172_A      I     148          3.126
LGA    K   173_A      L     149          3.025
LGA    -       -      K     150           -
LGA    S   174_A      E     151          3.493
LGA    G   175_A      A     152          4.552
LGA    -       -      D     153           -
LGA    -       -      Q     154           -
LGA    -       -      K     155           -
LGA    -       -      N     165           -
LGA    -       -      C     166           -
LGA    -       -      L     167           -
LGA    -       -      E     168           -
LGA    -       -      T     169           -
LGA    -       -      S     170           -
LGA    -       -      L     171           -
LGA    -       -      A     172           -
LGA    -       -      E     173           -
LGA    -       -      I     174           -
LGA    -       -      F     175           -
LGA    -       -      P     176           -
LGA    -       -      L     177           -
LGA    -       -      I     191           -
LGA    -       -      P     192           -
LGA    -       -      G     193           -
LGA    -       -      L     194           -
LGA    -       -      A     195           -
LGA    E   176_A      A     196          2.680
LGA    R   177_A      S     197          1.880
LGA    V   178_A      V     198          0.872
LGA    I   179_A      L     199          0.618
LGA    I   180_A      V     200          0.582
LGA    A   181_A      V     201          0.319
LGA    A   182_A      S     202          0.470
LGA    H   183_A      H     203          0.498
LGA    G   184_A      G     204          0.920
LGA    N   185_A      A     205          1.672
LGA    S   186_A      Y     206          1.605
LGA    L   187_A      M     207          1.207
LGA    R   188_A      R     208          1.389
LGA    A   189_A      S     209          1.911
LGA    L   190_A      L     210          1.437
LGA    V   191_A      F     211          0.775
LGA    K   192_A      D     212          0.986
LGA    Y   193_A      Y     213          1.195
LGA    L   194_A      F     214          1.249
LGA    D   195_A      L     215          1.541
LGA    N   196_A      T     216          1.966
LGA    M   197_A      D     217           #
LGA    S   198_A      L     218           -
LGA    E   199_A      K     219           -
LGA    E   200_A      C     220           -
LGA    -       -      S     221           -
LGA    -       -      L     222           -
LGA    -       -      P     223           -
LGA    -       -      A     224           -
LGA    -       -      T     225           -
LGA    -       -      L     226           -
LGA    -       -      S     227           -
LGA    E   201_A      R     228          5.391
LGA    I   202_A      -       -           -
LGA    L   203_A      S     229           #
LGA    E   204_A      E     230          5.821
LGA    -       -      L     231           -
LGA    L   205_A      M     232          2.344
LGA    N   206_A      S     233          3.322
LGA    -       -      V     234           -
LGA    I   207_A      T     235          1.832
LGA    P   208_A      P     236          1.472
LGA    T   209_A      N     237          1.232
LGA    G   210_A      T     238          0.341
LGA    V   211_A      G     239          1.893
LGA    P   212_A      M     240          1.807
LGA    L   213_A      S     241          0.938
LGA    V   214_A      L     242          0.869
LGA    Y   215_A      F     243          0.841
LGA    E   216_A      I     244          1.763
LGA    F   217_A      I     245          2.663
LGA    D   218_A      N     246          3.206
LGA    E   219_A      F     247          4.539
LGA    N   220_A      E     248          3.045
LGA    -       -      E     249           -
LGA    -       -      G     250           -
LGA    -       -      R     251           -
LGA    -       -      E     252           -
LGA    -       -      V     253           -
LGA    -       -      K     254           -
LGA    F   221_A      P     255          3.918
LGA    K   222_A      T     256          1.244
LGA    P   223_A      V     257          0.967
LGA    L   224_A      Q     258          2.394
LGA    K   225_A      C     259          3.084
LGA    R   226_A      I     260          2.322
LGA    Y   227_A      C     261          0.594
LGA    Y   228_A      M     262          3.969
LGA    -       -      N     263           -
LGA    L   229_A      L     264          4.049
LGA    G   230_A      Q     265          4.225
LGA    N   231_A      D     266          3.161
LGA    A   232_A      H     267           -
LGA    D   233_A      L     268           -
LGA    E   234_A      N     269           #
LGA    I   235_A      -       -           -
LGA    A   236_A      -       -           -
LGA    A   237_A      -       -           -
LGA    K   238_A      -       -           -
LGA    A   239_A      -       -           -
LGA    A   240_A      -       -           -
LGA    A   241_A      -       -           -
LGA    V   242_A      -       -           -
LGA    A   243_A      -       -           -
LGA    N   244_A      -       -           -
LGA    Q   245_A      -       -           -
LGA    G   246_A      -       -           -
LGA    K   247_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  247  247    5.0    182    1.92    26.92     61.745     9.006

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.748380 * X  +  -0.360721 * Y  +  -0.556604 * Z  +  74.887733
  Y_new =   0.631037 * X  +  -0.645654 * Y  +  -0.430027 * Z  +  33.837009
  Z_new =  -0.204254 * X  +  -0.673061 * Y  +   0.710823 * Z  +   0.383924 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.758118    2.383474  [ DEG:   -43.4370    136.5630 ]
  Theta =   0.205702    2.935891  [ DEG:    11.7858    168.2142 ]
  Phi   =   2.441057   -0.700536  [ DEG:   139.8623    -40.1377 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1e58_A                                        
REMARK     2: T0394.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1e58_A.T0394.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  247  247   5.0  182   1.92   26.92  61.745
REMARK  ---------------------------------------------------------- 
MOLECULE 1e58_A
HEADER    ISOMERASE                               19-JUL-00   1E58              
TITLE     E.COLI COFACTOR-DEPENDENT PHOSPHOGLYCERATE MUTASE                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOGLYCERATE MUTASE;                                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 5.4.2.1;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: K12;                                                         
SOURCE   4 GENE: PGM1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET3A                                     
KEYWDS    PHOSPHOHISTIDINE, GLYCOLYSIS AND GLUCONEOGENESIS,                     
KEYWDS   2 PHOSPHOGLYCERATE MUTASE, ISOMERASE                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.S.BOND,W.N.HUNTER                                                   
REVDAT   2   01-APR-03 1E58    1       JRNL                                     
REVDAT   1   20-MAR-01 1E58    0                                                
JRNL        AUTH   C.S.BOND,M.F.WHITE,W.N.HUNTER                                
JRNL        TITL   HIGH RESOLUTION STRUCTURE OF THE                             
JRNL        TITL 2 PHOSPHOHISTIDINE-ACTIVATED FORM OF ESCHERICHIA               
JRNL        TITL 3 COLI COFACTOR-DEPENDENT PHOSPHOGLYCERATE MUTASE.             
JRNL        REF    J.BIOL.CHEM.                  V. 276  3247 2001              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.25 ANGSTROMS.                                          
DBREF  1E58 A    1   249  UNP    P62707   GPMA_ECOLI       1    249             
SEQRES   1 A  249  ALA VAL THR LYS LEU VAL LEU VAL ARG NEP GLY GLU SER          
SEQRES   2 A  249  GLN TRP ASN LYS GLU ASN ARG PHE THR GLY TRP TYR ASP          
SEQRES   3 A  249  VAL ASP LEU SER GLU LYS GLY VAL SER GLU ALA LYS ALA          
SEQRES   4 A  249  ALA GLY LYS LEU LEU LYS GLU GLU GLY TYR SER PHE ASP          
SEQRES   5 A  249  PHE ALA TYR THR SER VAL LEU LYS ARG ALA ILE HIS THR          
SEQRES   6 A  249  LEU TRP ASN VAL LEU ASP GLU LEU ASP GLN ALA TRP LEU          
SEQRES   7 A  249  PRO VAL GLU LYS SER TRP LYS LEU ASN GLU ARG HIS TYR          
SEQRES   8 A  249  GLY ALA LEU GLN GLY LEU ASN LYS ALA GLU THR ALA GLU          
SEQRES   9 A  249  LYS TYR GLY ASP GLU GLN VAL LYS GLN TRP ARG ARG GLY          
SEQRES  10 A  249  PHE ALA VAL THR PRO PRO GLU LEU THR LYS ASP ASP GLU          
SEQRES  11 A  249  ARG TYR PRO GLY HIS ASP PRO ARG TYR ALA LYS LEU SER          
SEQRES  12 A  249  GLU LYS GLU LEU PRO LEU THR GLU SER LEU ALA LEU THR          
SEQRES  13 A  249  ILE ASP ARG VAL ILE PRO TYR TRP ASN GLU THR ILE LEU          
SEQRES  14 A  249  PRO ARG MET LYS SER GLY GLU ARG VAL ILE ILE ALA ALA          
SEQRES  15 A  249  HIS GLY ASN SER LEU ARG ALA LEU VAL LYS TYR LEU ASP          
SEQRES  16 A  249  ASN MET SER GLU GLU GLU ILE LEU GLU LEU ASN ILE PRO          
SEQRES  17 A  249  THR GLY VAL PRO LEU VAL TYR GLU PHE ASP GLU ASN PHE          
SEQRES  18 A  249  LYS PRO LEU LYS ARG TYR TYR LEU GLY ASN ALA ASP GLU          
SEQRES  19 A  249  ILE ALA ALA LYS ALA ALA ALA VAL ALA ASN GLN GLY LYS          
SEQRES  20 A  249  ALA LYS                                                      
HET    NEP  A  10      19                                                       
HET    SO4  A1001       5                                                       
HET    SO4  A1002       5                                                       
HET     CL  A2001       1                                                       
HETNAM     NEP N1-PHOSPHONOHISTIDINE                                            
HETNAM     SO4 SULFATE ION                                                      
HETNAM      CL CHLORIDE ION                                                     
FORMUL   1  NEP    C6 H10 N3 O5 P                                               
FORMUL   2  SO4    2(O4 S 2-)                                                   
FORMUL   4   CL    CL 1-                                                        
FORMUL   5  HOH   *425(H2 O)                                                    
CRYST1   61.570  113.000   40.260  90.00  90.00  90.00 P 21 21 2     4          
ATOM      1  N   ALA A   1       7.949  51.618  14.047  0.25 36.45           N  
ATOM      3  CA  ALA A   1       8.045  50.291  14.677  0.25 31.86           C  
ATOM      5  C   ALA A   1       8.240  49.166  13.669  1.00 30.11           C  
ATOM      6  O   ALA A   1       8.169  47.953  13.895  1.00 27.20           O  
ATOM      7  CB  ALA A   1       6.840  50.142  15.589  0.25 32.19           C  
ATOM      9  N   VAL A   2       8.651  49.543  12.458  1.00 24.07           N  
ATOM     10  CA  VAL A   2       9.261  48.622  11.527  1.00 23.95           C  
ATOM     11  C   VAL A   2      10.706  48.325  11.943  1.00 18.21           C  
ATOM     12  O   VAL A   2      11.360  49.311  12.348  1.00 24.12           O  
ATOM     13  CB  VAL A   2       9.300  49.225  10.109  1.00 27.26           C  
ATOM     14  CG1 VAL A   2      10.176  48.358   9.246  1.00 37.30           C  
ATOM     15  CG2 VAL A   2       7.880  49.367   9.590  1.00 34.77           C  
ATOM     16  N   THR A   3      11.155  47.084  11.845  1.00 15.38           N  
ATOM     17  CA  THR A   3      12.511  46.649  12.140  1.00 13.74           C  
ATOM     18  C   THR A   3      13.228  46.389  10.826  1.00 12.99           C  
ATOM     19  O   THR A   3      12.686  45.727   9.924  1.00 15.43           O  
ATOM     20  CB  THR A   3      12.530  45.343  12.968  1.00 14.90           C  
ATOM     21  OG1 THR A   3      11.957  45.594  14.269  1.00 19.22           O  
ATOM     22  CG2 THR A   3      13.954  44.823  13.197  1.00 16.20           C  
ATOM     23  N   LYS A   4      14.439  46.889  10.643  1.00 11.41           N  
ATOM     24  CA  LYS A   4      15.241  46.657   9.471  1.00 11.55           C  
ATOM     25  C   LYS A   4      16.353  45.622   9.721  1.00 10.52           C  
ATOM     26  O   LYS A   4      16.976  45.633  10.802  1.00 10.18           O  
ATOM     27  CB  LYS A   4      15.872  47.949   8.956  1.00 14.63           C  
ATOM     28  CG  LYS A   4      14.773  48.922   8.532  1.00 23.75           C  
ATOM     29  CD  LYS A   4      15.272  49.862   7.476  1.00 25.72           C  
ATOM     30  CE  LYS A   4      14.260  50.857   6.970  1.00 20.55           C  
ATOM     31  NZ  LYS A   4      15.044  51.951   6.356  1.00 26.31           N  
ATOM     32  N   LEU A   5      16.551  44.788   8.697  1.00  8.27           N  
ATOM     33  CA  LEU A   5      17.631  43.801   8.585  1.00  7.49           C  
ATOM     34  C   LEU A   5      18.423  44.113   7.331  1.00  7.40           C  
ATOM     35  O   LEU A   5      17.797  44.346   6.294  1.00  9.04           O  
ATOM     36  CB  LEU A   5      17.087  42.380   8.538  1.00  8.38           C  
ATOM     37  CG  LEU A   5      18.040  41.244   8.230  1.00  8.28           C  
ATOM     38  CD1 LEU A   5      19.039  41.041   9.369  1.00  9.44           C  
ATOM     39  CD2 LEU A   5      17.279  39.965   7.975  1.00  9.52           C  
ATOM     40  N   VAL A   6      19.751  44.089   7.383  1.00  6.14           N  
ATOM     41  CA  VAL A   6      20.551  44.273   6.200  1.00  6.29           C  
ATOM     42  C   VAL A   6      21.354  43.013   5.908  1.00  5.79           C  
ATOM     43  O   VAL A   6      22.052  42.520   6.810  1.00  7.62           O  
ATOM     44  CB  VAL A   6      21.489  45.488   6.310  1.00  6.45           C  
ATOM     45  CG1 VAL A   6      22.404  45.619   5.102  1.00  7.91           C  
ATOM     46  CG2 VAL A   6      20.683  46.788   6.559  1.00  8.29           C  
ATOM     47  N   LEU A   7      21.259  42.518   4.676  1.00  6.26           N  
ATOM     48  CA  LEU A   7      22.007  41.404   4.148  1.00  6.08           C  
ATOM     49  C   LEU A   7      23.035  41.894   3.127  1.00  5.92           C  
ATOM     50  O   LEU A   7      22.712  42.771   2.331  1.00  6.86           O  
ATOM     51  CB  LEU A   7      21.097  40.389   3.452  1.00  6.63           C  
ATOM     52  CG  LEU A   7      19.871  39.912   4.238  1.00  8.11           C  
ATOM     53  CD1 LEU A   7      19.050  38.926   3.385  1.00  9.01           C  
ATOM     54  CD2 LEU A   7      20.225  39.292   5.556  1.00  8.14           C  
ATOM     55  N   VAL A   8      24.226  41.314   3.120  1.00  5.98           N  
ATOM     56  CA  VAL A   8      25.189  41.650   2.072  1.00  6.40           C  
ATOM     57  C   VAL A   8      25.996  40.404   1.737  1.00  5.36           C  
ATOM     58  O   VAL A   8      26.607  39.770   2.600  1.00  6.19           O  
ATOM     59  CB  VAL A   8      26.037  42.870   2.414  0.65  6.83           C  
ATOM     61  CG1 VAL A   8      26.957  42.597   3.590  0.65  7.04           C  
ATOM     63  CG2 VAL A   8      26.878  43.350   1.217  0.65 10.55           C  
ATOM     65  N   ARG A   9      25.980  40.060   0.461  1.00  5.57           N  
ATOM     66  CA  ARG A   9      26.905  39.049  -0.057  1.00  5.90           C  
ATOM     67  C   ARG A   9      28.332  39.610  -0.061  1.00  5.72           C  
ATOM     68  O   ARG A   9      28.548  40.766  -0.387  1.00  7.01           O  
ATOM     69  CB  ARG A   9      26.485  38.591  -1.456  1.00  6.01           C  
ATOM     70  CG  ARG A   9      27.344  37.482  -2.055  1.00  6.71           C  
ATOM     71  CD  ARG A   9      26.807  37.078  -3.439  1.00  6.86           C  
ATOM     72  NE  ARG A   9      27.728  36.160  -4.089  1.00  6.90           N  
ATOM     73  CZ  ARG A   9      27.815  35.952  -5.379  1.00  7.59           C  
ATOM     74  NH1 ARG A   9      27.002  36.590  -6.228  1.00  9.39           N  
ATOM     75  NH2 ARG A   9      28.728  35.092  -5.865  1.00  9.02           N  
HETATM   76  N   NEP A  10      29.324  38.744   0.250  1.00  5.66           N  
HETATM   77  CA  NEP A  10      30.738  39.135   0.174  1.00  5.83           C  
HETATM   78  C   NEP A  10      31.026  39.867  -1.146  1.00  6.20           C  
HETATM   79  O   NEP A  10      30.439  39.543  -2.205  1.00  6.59           O  
HETATM   80  CB  NEP A  10      31.635  37.914   0.296  1.00  6.25           C  
HETATM   81  CG  NEP A  10      31.455  36.916  -0.782  0.71  6.30           C  
HETATM   83  ND1 NEP A  10      31.989  37.043  -2.041  0.71  6.78           N  
HETATM   85  CD2 NEP A  10      30.809  35.699  -0.830  0.71  6.39           C  
HETATM   87  CE1 NEP A  10      31.672  36.017  -2.819  0.71  5.48           C  
HETATM   89  NE2 NEP A  10      30.959  35.188  -2.080  0.71  6.36           N  
HETATM   91  P   NEP A  10      30.349  33.717  -2.671  0.28  8.42           P  
HETATM   92  O1P NEP A  10      31.080  33.259  -3.886  0.28 16.17           O  
HETATM   93  O2P NEP A  10      30.678  32.872  -1.454  0.28 14.12           O  
HETATM   94  O3P NEP A  10      28.909  34.027  -2.835  0.28 14.78           O  
ATOM     95  N   GLY A  11      31.948  40.827  -1.081  1.00  6.23           N  
ATOM     96  CA  GLY A  11      32.506  41.402  -2.302  1.00  6.48           C  
ATOM     97  C   GLY A  11      33.152  40.339  -3.193  1.00  6.17           C  
ATOM     98  O   GLY A  11      33.460  39.230  -2.719  1.00  6.41           O  
ATOM     99  N   GLU A  12      33.310  40.614  -4.478  1.00  6.44           N  
ATOM    100  CA  GLU A  12      33.915  39.681  -5.420  1.00  6.57           C  
ATOM    101  C   GLU A  12      35.165  39.031  -4.830  1.00  6.28           C  
ATOM    102  O   GLU A  12      36.069  39.696  -4.339  1.00  6.51           O  
ATOM    103  CB  GLU A  12      34.285  40.397  -6.729  1.00  6.58           C  
ATOM    104  CG  GLU A  12      34.677  39.415  -7.824  1.00  6.96           C  
ATOM    105  CD  GLU A  12      35.422  40.015  -8.972  1.00  8.67           C  
ATOM    106  OE1 GLU A  12      36.503  40.614  -8.756  1.00  8.59           O  
ATOM    107  OE2 GLU A  12      34.952  39.911 -10.138  1.00 11.85           O  
ATOM    108  N   SER A  13      35.190  37.685  -4.923  1.00  6.66           N  
ATOM    109  CA  SER A  13      36.364  36.950  -4.492  1.00  6.74           C  
ATOM    110  C   SER A  13      37.349  36.711  -5.635  1.00  6.67           C  
ATOM    111  O   SER A  13      37.014  36.859  -6.815  1.00  7.59           O  
ATOM    112  CB  SER A  13      36.001  35.592  -3.876  1.00  6.90           C  
ATOM    113  OG  SER A  13      35.805  34.657  -4.918  1.00  7.63           O  
ATOM    114  N   GLN A  14      38.592  36.334  -5.291  1.00  7.06           N  
ATOM    115  CA  GLN A  14      39.579  36.029  -6.354  1.00  7.55           C  
ATOM    116  C   GLN A  14      39.100  34.871  -7.235  1.00  7.55           C  
ATOM    117  O   GLN A  14      39.374  34.868  -8.436  1.00  8.51           O  
ATOM    118  CB  GLN A  14      40.931  35.674  -5.717  1.00  9.03           C  
ATOM    119  CG  GLN A  14      42.127  35.669  -6.647  1.00 10.58           C  
ATOM    120  CD  GLN A  14      42.321  36.972  -7.389  1.00 13.50           C  
ATOM    121  OE1 GLN A  14      42.131  38.049  -6.780  1.00 16.29           O  
ATOM    122  NE2 GLN A  14      42.769  36.846  -8.621  1.00 18.02           N  
ATOM    123  N   TRP A  15      38.412  33.862  -6.679  1.00  7.21           N  
ATOM    124  CA  TRP A  15      37.914  32.734  -7.451  1.00  7.93           C  
ATOM    125  C   TRP A  15      36.601  33.061  -8.180  1.00  7.48           C  
ATOM    126  O   TRP A  15      36.320  32.425  -9.216  1.00  8.30           O  
ATOM    127  CB  TRP A  15      37.834  31.442  -6.640  1.00  7.57           C  
ATOM    128  CG  TRP A  15      39.164  30.822  -6.384  1.00  7.56           C  
ATOM    129  CD1 TRP A  15      40.411  31.359  -6.656  1.00  8.96           C  
ATOM    130  CD2 TRP A  15      39.416  29.514  -5.836  1.00  7.89           C  
ATOM    131  NE1 TRP A  15      41.399  30.465  -6.290  1.00  9.92           N  
ATOM    132  CE2 TRP A  15      40.801  29.316  -5.789  1.00  8.93           C  
ATOM    133  CE3 TRP A  15      38.578  28.494  -5.397  1.00  8.18           C  
ATOM    134  CZ2 TRP A  15      41.373  28.154  -5.297  1.00 10.66           C  
ATOM    135  CZ3 TRP A  15      39.150  27.322  -4.906  1.00  8.84           C  
ATOM    136  CH2 TRP A  15      40.552  27.155  -4.863  1.00 10.75           C  
ATOM    137  N   ASN A  16      35.810  34.047  -7.737  1.00  6.96           N  
ATOM    138  CA  ASN A  16      34.772  34.599  -8.582  1.00  7.23           C  
ATOM    139  C   ASN A  16      35.398  35.189  -9.884  1.00  7.13           C  
ATOM    140  O   ASN A  16      34.999  34.843 -11.015  1.00  8.09           O  
ATOM    141  CB  ASN A  16      33.970  35.653  -7.846  1.00  7.75           C  
ATOM    142  CG  ASN A  16      33.165  35.313  -6.628  1.00  6.46           C  
ATOM    143  OD1 ASN A  16      32.933  36.198  -5.760  1.00  7.93           O  
ATOM    144  ND2 ASN A  16      32.672  34.085  -6.518  1.00  7.51           N  
ATOM    145  N   LYS A  17      36.418  36.011  -9.746  1.00  7.74           N  
ATOM    146  CA  LYS A  17      37.120  36.600 -10.876  1.00  7.97           C  
ATOM    147  C   LYS A  17      37.684  35.515 -11.781  1.00  8.59           C  
ATOM    148  O   LYS A  17      37.515  35.623 -13.003  1.00  9.85           O  
ATOM    149  CB  LYS A  17      38.250  37.540 -10.423  1.00  8.74           C  
ATOM    150  CG  LYS A  17      39.092  38.048 -11.577  1.00  9.54           C  
ATOM    151  CD  LYS A  17      40.251  38.963 -11.253  1.00 11.13           C  
ATOM    152  CE  LYS A  17      41.128  39.261 -12.480  1.00 14.78           C  
ATOM    153  NZ  LYS A  17      42.188  40.267 -12.263  1.00 15.58           N  
ATOM    154  N   GLU A  18      38.316  34.483 -11.194  1.00  8.57           N  
ATOM    155  CA  GLU A  18      38.992  33.451 -11.972  1.00  9.06           C  
ATOM    156  C   GLU A  18      38.047  32.348 -12.449  1.00  9.18           C  
ATOM    157  O   GLU A  18      38.486  31.385 -13.111  1.00 12.26           O  
ATOM    158  CB  GLU A  18      40.165  32.855 -11.185  1.00 12.36           C  
ATOM    159  CG  GLU A  18      41.273  33.885 -10.868  1.00 16.79           C  
ATOM    160  CD  GLU A  18      42.383  33.245 -10.033  1.00 23.67           C  
ATOM    161  OE1 GLU A  18      42.458  32.000  -9.888  1.00 27.90           O  
ATOM    162  OE2 GLU A  18      43.256  33.949  -9.523  1.00 30.34           O  
ATOM    163  N   ASN A  19      36.745  32.422 -12.145  1.00  8.92           N  
ATOM    164  CA  ASN A  19      35.748  31.453 -12.621  1.00  8.92           C  
ATOM    165  C   ASN A  19      36.056  30.064 -12.109  1.00  8.29           C  
ATOM    166  O   ASN A  19      36.054  29.087 -12.865  1.00  9.67           O  
ATOM    167  CB  ASN A  19      35.635  31.517 -14.149  1.00 10.14           C  
ATOM    168  CG  ASN A  19      34.385  30.818 -14.671  1.00  9.65           C  
ATOM    169  OD1 ASN A  19      33.367  30.810 -13.975  1.00 10.41           O  
ATOM    170  ND2 ASN A  19      34.479  30.218 -15.870  1.00 11.29           N  
ATOM    171  N   ARG A  20      36.278  29.936 -10.779  1.00  7.95           N  
ATOM    172  CA  ARG A  20      36.505  28.654 -10.107  1.00  8.40           C  
ATOM    173  C   ARG A  20      35.451  28.420  -9.044  1.00  7.87           C  
ATOM    174  O   ARG A  20      35.077  29.317  -8.272  1.00  8.83           O  
ATOM    175  CB  ARG A  20      37.911  28.579  -9.468  1.00  9.72           C  
ATOM    176  CG  ARG A  20      39.083  28.643 -10.419  1.00 10.60           C  
ATOM    177  CD  ARG A  20      40.459  28.731  -9.792  0.50 13.19           C  
ATOM    179  NE  ARG A  20      41.021  27.517  -9.235  0.50 13.41           N  
ATOM    181  CZ  ARG A  20      42.192  27.220  -8.717  0.50 16.50           C  
ATOM    183  NH1 ARG A  20      43.113  28.188  -8.648  0.50 22.86           N  
ATOM    185  NH2 ARG A  20      42.547  26.015  -8.238  0.50 19.02           N  
ATOM    187  N   PHE A  21      34.948  27.179  -8.969  1.00  7.16           N  
ATOM    188  CA  PHE A  21      34.072  26.785  -7.897  1.00  7.23           C  
ATOM    189  C   PHE A  21      34.798  26.868  -6.553  1.00  6.75           C  
ATOM    190  O   PHE A  21      35.895  26.325  -6.417  1.00  8.07           O  
ATOM    191  CB  PHE A  21      33.601  25.348  -8.089  1.00  7.82           C  
ATOM    192  CG  PHE A  21      32.954  24.976  -9.392  1.00  9.21           C  
ATOM    193  CD1 PHE A  21      31.698  25.392  -9.757  1.00 13.46           C  
ATOM    194  CD2 PHE A  21      33.678  24.156 -10.278  1.00 12.08           C  
ATOM    195  CE1 PHE A  21      31.127  24.948 -10.956  1.00 16.61           C  
ATOM    196  CE2 PHE A  21      33.158  23.747 -11.479  1.00 16.91           C  
ATOM    197  CZ  PHE A  21      31.869  24.135 -11.784  1.00 18.18           C  
ATOM    198  N   THR A  22      34.167  27.512  -5.561  1.00  6.62           N  
ATOM    199  CA  THR A  22      34.871  27.754  -4.291  1.00  6.90           C  
ATOM    200  C   THR A  22      34.312  26.955  -3.116  1.00  5.96           C  
ATOM    201  O   THR A  22      35.045  26.212  -2.455  1.00  6.51           O  
ATOM    202  CB  THR A  22      34.852  29.262  -3.920  1.00  6.57           C  
ATOM    203  OG1 THR A  22      35.310  30.060  -5.027  1.00  8.47           O  
ATOM    204  CG2 THR A  22      35.794  29.546  -2.770  1.00  7.21           C  
ATOM    205  N   GLY A  23      33.022  27.100  -2.817  1.00  6.14           N  
ATOM    206  CA  GLY A  23      32.428  26.401  -1.670  1.00  5.80           C  
ATOM    207  C   GLY A  23      33.085  26.847  -0.367  1.00  5.67           C  
ATOM    208  O   GLY A  23      33.228  28.048  -0.100  1.00  6.33           O  
ATOM    209  N   TRP A  24      33.549  25.885   0.453  1.00  5.55           N  
ATOM    210  CA  TRP A  24      34.203  26.189   1.706  1.00  5.41           C  
ATOM    211  C   TRP A  24      35.687  26.513   1.522  1.00  5.30           C  
ATOM    212  O   TRP A  24      36.323  26.887   2.493  1.00  6.13           O  
ATOM    213  CB  TRP A  24      34.016  25.031   2.715  1.00  5.36           C  
ATOM    214  CG  TRP A  24      32.640  24.896   3.272  1.00  5.59           C  
ATOM    215  CD1 TRP A  24      31.422  25.261   2.738  1.00  5.72           C  
ATOM    216  CD2 TRP A  24      32.324  24.318   4.556  1.00  6.05           C  
ATOM    217  NE1 TRP A  24      30.410  24.940   3.605  1.00  5.87           N  
ATOM    218  CE2 TRP A  24      30.933  24.365   4.746  1.00  5.93           C  
ATOM    219  CE3 TRP A  24      33.077  23.764   5.612  1.00  6.02           C  
ATOM    220  CZ2 TRP A  24      30.311  23.888   5.889  1.00  6.35           C  
ATOM    221  CZ3 TRP A  24      32.479  23.290   6.763  1.00  6.63           C  
ATOM    222  CH2 TRP A  24      31.075  23.367   6.888  1.00  6.69           C  
ATOM    223  N   TYR A  25      36.268  26.449   0.328  1.00  5.82           N  
ATOM    224  CA  TYR A  25      37.643  26.891   0.205  1.00  5.84           C  
ATOM    225  C   TYR A  25      37.759  28.354   0.619  1.00  5.93           C  
ATOM    226  O   TYR A  25      36.939  29.199   0.175  1.00  6.54           O  
ATOM    227  CB  TYR A  25      38.186  26.677  -1.246  1.00  7.08           C  
ATOM    228  CG  TYR A  25      39.605  27.170  -1.347  1.00  6.29           C  
ATOM    229  CD1 TYR A  25      40.668  26.422  -0.887  1.00  9.52           C  
ATOM    230  CD2 TYR A  25      39.915  28.441  -1.863  1.00  8.19           C  
ATOM    231  CE1 TYR A  25      41.997  26.884  -0.960  1.00 10.48           C  
ATOM    232  CE2 TYR A  25      41.204  28.925  -1.931  1.00  8.80           C  
ATOM    233  CZ  TYR A  25      42.245  28.137  -1.476  1.00 10.38           C  
ATOM    234  OH  TYR A  25      43.549  28.567  -1.515  1.00 14.71           O  
ATOM    235  N   ASP A  26      38.764  28.689   1.432  1.00  6.24           N  
ATOM    236  CA  ASP A  26      38.770  29.997   2.098  1.00  6.27           C  
ATOM    237  C   ASP A  26      39.549  31.066   1.319  1.00  5.61           C  
ATOM    238  O   ASP A  26      40.532  31.643   1.788  1.00  7.66           O  
ATOM    239  CB  ASP A  26      39.330  29.850   3.521  1.00  6.01           C  
ATOM    240  CG  ASP A  26      38.986  31.013   4.405  1.00  6.22           C  
ATOM    241  OD1 ASP A  26      38.058  31.790   4.046  1.00  6.77           O  
ATOM    242  OD2 ASP A  26      39.642  31.170   5.462  1.00  9.02           O  
ATOM    243  N   VAL A  27      39.079  31.364   0.096  1.00  6.56           N  
ATOM    244  CA  VAL A  27      39.718  32.343  -0.775  1.00  6.58           C  
ATOM    245  C   VAL A  27      39.440  33.779  -0.333  1.00  6.49           C  
ATOM    246  O   VAL A  27      38.357  34.087   0.187  1.00  6.74           O  
ATOM    247  CB  VAL A  27      39.277  32.128  -2.237  1.00  6.89           C  
ATOM    248  CG1 VAL A  27      37.845  32.544  -2.466  1.00  8.43           C  
ATOM    249  CG2 VAL A  27      40.234  32.821  -3.236  1.00 10.27           C  
ATOM    250  N   ASP A  28      40.349  34.700  -0.578  1.00  6.68           N  
ATOM    251  CA  ASP A  28      40.118  36.091  -0.198  1.00  7.50           C  
ATOM    252  C   ASP A  28      39.383  36.866  -1.309  1.00  6.26           C  
ATOM    253  O   ASP A  28      39.190  36.445  -2.446  1.00  6.98           O  
ATOM    254  CB  ASP A  28      41.396  36.784   0.242  1.00  9.19           C  
ATOM    255  CG  ASP A  28      41.216  37.757   1.409  1.00  9.34           C  
ATOM    256  OD1 ASP A  28      40.124  38.306   1.648  1.00 10.76           O  
ATOM    257  OD2 ASP A  28      42.223  38.064   2.080  1.00 14.03           O  
ATOM    258  N   LEU A  29      38.977  38.080  -0.897  1.00  6.42           N  
ATOM    259  CA  LEU A  29      38.503  39.116  -1.791  1.00  5.98           C  
ATOM    260  C   LEU A  29      39.493  39.381  -2.909  1.00  6.38           C  
ATOM    261  O   LEU A  29      40.706  39.389  -2.668  1.00  7.22           O  
ATOM    262  CB  LEU A  29      38.213  40.414  -1.017  1.00  6.05           C  
ATOM    263  CG  LEU A  29      37.067  40.356  -0.017  1.00  6.14           C  
ATOM    264  CD1 LEU A  29      36.958  41.656   0.753  1.00  7.37           C  
ATOM    265  CD2 LEU A  29      35.754  40.021  -0.703  1.00  6.73           C  
ATOM    266  N   SER A  30      39.027  39.643  -4.124  1.00  6.46           N  
ATOM    267  CA  SER A  30      39.881  40.248  -5.152  1.00  6.92           C  
ATOM    268  C   SER A  30      40.046  41.764  -4.819  1.00  6.79           C  
ATOM    269  O   SER A  30      39.337  42.288  -3.947  1.00  7.05           O  
ATOM    270  CB  SER A  30      39.234  40.111  -6.516  1.00  7.46           C  
ATOM    271  OG  SER A  30      38.011  40.872  -6.499  1.00  7.33           O  
ATOM    272  N   GLU A  31      40.914  42.434  -5.542  1.00  8.07           N  
ATOM    273  CA  GLU A  31      41.024  43.888  -5.445  1.00  8.53           C  
ATOM    274  C   GLU A  31      39.677  44.569  -5.670  1.00  7.72           C  
ATOM    275  O   GLU A  31      39.261  45.475  -4.907  1.00  8.27           O  
ATOM    276  CB  GLU A  31      42.085  44.431  -6.395  1.00 11.91           C  
ATOM    277  CG  GLU A  31      42.380  45.913  -6.262  1.00 12.69           C  
ATOM    278  CD  GLU A  31      43.680  46.402  -6.821  1.00 14.41           C  
ATOM    279  OE1 GLU A  31      44.391  45.648  -7.499  1.00 22.99           O  
ATOM    280  OE2 GLU A  31      43.982  47.591  -6.605  1.00 14.43           O  
ATOM    281  N   LYS A  32      38.954  44.142  -6.700  1.00  7.25           N  
ATOM    282  CA  LYS A  32      37.603  44.677  -6.966  1.00  7.77           C  
ATOM    283  C   LYS A  32      36.666  44.359  -5.827  1.00  6.55           C  
ATOM    284  O   LYS A  32      35.806  45.213  -5.468  1.00  7.67           O  
ATOM    285  CB  LYS A  32      37.076  44.132  -8.296  1.00  9.19           C  
ATOM    286  CG  LYS A  32      35.687  44.555  -8.693  1.00 15.00           C  
ATOM    287  CD  LYS A  32      35.245  43.933 -10.010  1.00 24.66           C  
ATOM    288  CE  LYS A  32      33.802  44.291 -10.369  1.00 33.49           C  
ATOM    289  NZ  LYS A  32      33.682  44.399 -11.853  1.00 58.62           N  
ATOM    290  N   GLY A  33      36.753  43.187  -5.207  1.00  6.52           N  
ATOM    291  CA  GLY A  33      35.901  42.893  -4.085  1.00  6.84           C  
ATOM    292  C   GLY A  33      36.122  43.745  -2.851  1.00  5.70           C  
ATOM    293  O   GLY A  33      35.177  44.053  -2.119  1.00  6.63           O  
ATOM    294  N   VAL A  34      37.392  44.108  -2.595  1.00  6.56           N  
ATOM    295  CA  VAL A  34      37.675  45.085  -1.542  1.00  6.21           C  
ATOM    296  C   VAL A  34      36.965  46.412  -1.886  1.00  6.77           C  
ATOM    297  O   VAL A  34      36.310  46.982  -1.012  1.00  7.14           O  
ATOM    298  CB  VAL A  34      39.191  45.285  -1.301  1.00  6.65           C  
ATOM    299  CG1 VAL A  34      39.465  46.388  -0.290  1.00  8.59           C  
ATOM    300  CG2 VAL A  34      39.846  43.971  -0.862  1.00  7.98           C  
ATOM    301  N   SER A  35      37.098  46.888  -3.122  1.00  6.48           N  
ATOM    302  CA  SER A  35      36.409  48.101  -3.560  1.00  7.66           C  
ATOM    303  C   SER A  35      34.911  47.956  -3.317  1.00  6.28           C  
ATOM    304  O   SER A  35      34.251  48.892  -2.818  1.00  7.90           O  
ATOM    305  CB  SER A  35      36.699  48.397  -5.031  1.00  9.28           C  
ATOM    306  OG  SER A  35      38.109  48.605  -5.252  1.00  9.96           O  
ATOM    307  N   GLU A  36      34.309  46.819  -3.680  1.00  6.84           N  
ATOM    308  CA  GLU A  36      32.878  46.636  -3.519  1.00  6.97           C  
ATOM    309  C   GLU A  36      32.471  46.703  -2.052  1.00  6.59           C  
ATOM    310  O   GLU A  36      31.438  47.288  -1.658  1.00  6.97           O  
ATOM    311  CB  GLU A  36      32.412  45.278  -4.079  0.81  7.43           C  
ATOM    313  CG  GLU A  36      32.435  45.199  -5.611  0.81  7.50           C  
ATOM    315  CD  GLU A  36      31.984  43.855  -6.164  0.81  7.51           C  
ATOM    317  OE1 GLU A  36      31.818  42.887  -5.386  0.81  7.38           O  
ATOM    319  OE2 GLU A  36      31.831  43.764  -7.390  0.81 10.92           O  
ATOM    321  N   ALA A  37      33.255  46.056  -1.162  1.00  6.57           N  
ATOM    322  CA  ALA A  37      32.942  46.047   0.259  1.00  6.34           C  
ATOM    323  C   ALA A  37      32.975  47.471   0.849  1.00  6.39           C  
ATOM    324  O   ALA A  37      32.086  47.870   1.585  1.00  7.46           O  
ATOM    325  CB  ALA A  37      33.912  45.161   1.023  1.00  7.24           C  
ATOM    326  N   LYS A  38      34.025  48.224   0.514  1.00  6.88           N  
ATOM    327  CA  LYS A  38      34.116  49.610   0.998  1.00  6.66           C  
ATOM    328  C   LYS A  38      32.959  50.438   0.448  1.00  7.14           C  
ATOM    329  O   LYS A  38      32.380  51.275   1.171  1.00  7.99           O  
ATOM    330  CB  LYS A  38      35.473  50.197   0.629  1.00  7.11           C  
ATOM    331  CG  LYS A  38      36.621  49.565   1.382  1.00  8.22           C  
ATOM    332  CD  LYS A  38      37.966  50.218   1.113  1.00 10.00           C  
ATOM    333  CE  LYS A  38      39.029  49.607   2.030  0.50 10.80           C  
ATOM    335  NZ  LYS A  38      40.386  50.098   1.692  0.50 20.28           N  
ATOM    337  N   ALA A  39      32.609  50.255  -0.826  1.00  7.81           N  
ATOM    338  CA  ALA A  39      31.508  51.032  -1.406  1.00  7.83           C  
ATOM    339  C   ALA A  39      30.197  50.719  -0.681  1.00  7.47           C  
ATOM    340  O   ALA A  39      29.358  51.617  -0.465  1.00  8.83           O  
ATOM    341  CB  ALA A  39      31.379  50.766  -2.880  1.00  8.84           C  
ATOM    342  N   ALA A  40      29.963  49.461  -0.324  1.00  7.74           N  
ATOM    343  CA  ALA A  40      28.733  49.078   0.370  1.00  7.32           C  
ATOM    344  C   ALA A  40      28.633  49.778   1.719  1.00  7.75           C  
ATOM    345  O   ALA A  40      27.568  50.244   2.125  1.00  7.96           O  
ATOM    346  CB  ALA A  40      28.645  47.559   0.536  1.00  7.57           C  
ATOM    347  N   GLY A  41      29.748  49.834   2.444  1.00  7.56           N  
ATOM    348  CA  GLY A  41      29.766  50.538   3.728  1.00  7.34           C  
ATOM    349  C   GLY A  41      29.535  52.029   3.584  1.00  7.51           C  
ATOM    350  O   GLY A  41      28.776  52.605   4.385  1.00  7.99           O  
ATOM    351  N   LYS A  42      30.162  52.661   2.609  1.00  7.74           N  
ATOM    352  CA  LYS A  42      29.989  54.079   2.391  1.00  8.21           C  
ATOM    353  C   LYS A  42      28.519  54.365   2.059  1.00  7.80           C  
ATOM    354  O   LYS A  42      27.919  55.345   2.497  1.00  9.45           O  
ATOM    355  CB  LYS A  42      30.940  54.532   1.293  0.35  9.44           C  
ATOM    357  CG  LYS A  42      30.902  56.031   1.033  0.35  9.76           C  
ATOM    359  CD  LYS A  42      32.029  56.440   0.098  0.35 14.42           C  
ATOM    361  CE  LYS A  42      31.945  57.924  -0.236  0.35 20.68           C  
ATOM    363  NZ  LYS A  42      33.154  58.512  -0.860  0.35 28.33           N  
ATOM    365  N   LEU A  43      27.894  53.528   1.239  1.00  7.73           N  
ATOM    366  CA  LEU A  43      26.494  53.700   0.819  1.00  8.45           C  
ATOM    367  C   LEU A  43      25.557  53.529   2.025  1.00  7.68           C  
ATOM    368  O   LEU A  43      24.622  54.276   2.214  1.00  9.47           O  
ATOM    369  CB  LEU A  43      26.157  52.683  -0.247  1.00  8.59           C  
ATOM    370  CG  LEU A  43      24.744  52.704  -0.806  1.00  9.90           C  
ATOM    371  CD1 LEU A  43      24.359  54.063  -1.427  1.00 13.17           C  
ATOM    372  CD2 LEU A  43      24.551  51.560  -1.825  1.00 10.93           C  
ATOM    373  N   LEU A  44      25.799  52.521   2.864  1.00  7.54           N  
ATOM    374  CA  LEU A  44      24.989  52.309   4.055  1.00  8.04           C  
ATOM    375  C   LEU A  44      25.075  53.558   4.946  1.00  7.88           C  
ATOM    376  O   LEU A  44      24.041  54.008   5.480  1.00  8.75           O  
ATOM    377  CB  LEU A  44      25.399  51.060   4.807  1.00  6.95           C  
ATOM    378  CG  LEU A  44      24.933  49.745   4.203  1.00  7.27           C  
ATOM    379  CD1 LEU A  44      25.718  48.554   4.712  1.00  8.88           C  
ATOM    380  CD2 LEU A  44      23.439  49.530   4.472  1.00  8.62           C  
ATOM    381  N   LYS A  45      26.270  54.119   5.115  1.00  8.37           N  
ATOM    382  CA  LYS A  45      26.397  55.347   5.908  1.00  9.46           C  
ATOM    383  C   LYS A  45      25.578  56.475   5.292  1.00 10.35           C  
ATOM    384  O   LYS A  45      24.796  57.183   5.964  1.00 11.93           O  
ATOM    385  CB  LYS A  45      27.857  55.763   6.005  0.35 12.59           C  
ATOM    387  CG  LYS A  45      28.106  56.966   6.912  0.35 16.38           C  
ATOM    389  CD  LYS A  45      28.441  58.232   6.143  0.35 20.97           C  
ATOM    391  CE  LYS A  45      27.266  59.188   6.099  0.35 24.94           C  
ATOM    393  NZ  LYS A  45      27.333  60.174   4.990  0.35 27.93           N  
ATOM    395  N   GLU A  46      25.745  56.707   3.994  1.00 11.00           N  
ATOM    396  CA  GLU A  46      25.023  57.753   3.312  1.00 11.98           C  
ATOM    397  C   GLU A  46      23.497  57.614   3.425  1.00 12.00           C  
ATOM    398  O   GLU A  46      22.773  58.637   3.484  1.00 13.60           O  
ATOM    399  CB  GLU A  46      25.461  57.783   1.822  1.00 15.59           C  
ATOM    400  CG  GLU A  46      26.856  58.454   1.696  1.00 20.33           C  
ATOM    401  CD  GLU A  46      27.493  58.174   0.344  1.00 20.30           C  
ATOM    402  OE1 GLU A  46      26.884  57.367  -0.442  1.00 27.73           O  
ATOM    403  OE2 GLU A  46      28.574  58.739   0.165  1.00 30.67           O  
ATOM    404  N   GLU A  47      23.025  56.392   3.439  1.00 11.01           N  
ATOM    405  CA  GLU A  47      21.592  56.082   3.527  1.00 12.20           C  
ATOM    406  C   GLU A  47      21.064  56.003   4.947  1.00 11.71           C  
ATOM    407  O   GLU A  47      19.883  55.684   5.185  1.00 13.53           O  
ATOM    408  CB  GLU A  47      21.335  54.777   2.737  1.00 13.72           C  
ATOM    409  CG  GLU A  47      21.613  54.964   1.246  1.00 15.20           C  
ATOM    410  CD  GLU A  47      20.388  55.258   0.410  1.00 20.36           C  
ATOM    411  OE1 GLU A  47      19.297  55.461   0.979  1.00 30.85           O  
ATOM    412  OE2 GLU A  47      20.549  55.297  -0.814  1.00 25.64           O  
ATOM    413  N   GLY A  48      21.888  56.291   5.952  1.00 11.74           N  
ATOM    414  CA  GLY A  48      21.494  56.457   7.328  1.00 12.24           C  
ATOM    415  C   GLY A  48      21.457  55.193   8.158  1.00 11.90           C  
ATOM    416  O   GLY A  48      20.834  55.179   9.237  1.00 16.19           O  
ATOM    417  N   TYR A  49      22.106  54.129   7.719  1.00  9.87           N  
ATOM    418  CA  TYR A  49      22.121  52.849   8.423  1.00  9.01           C  
ATOM    419  C   TYR A  49      23.273  52.737   9.408  1.00  9.13           C  
ATOM    420  O   TYR A  49      24.406  52.983   9.039  1.00 13.66           O  
ATOM    421  CB  TYR A  49      22.178  51.680   7.391  1.00 10.38           C  
ATOM    422  CG  TYR A  49      20.872  51.465   6.630  1.00 10.45           C  
ATOM    423  CD1 TYR A  49      20.601  52.258   5.494  1.00 10.86           C  
ATOM    424  CD2 TYR A  49      19.900  50.571   6.998  1.00 11.47           C  
ATOM    425  CE1 TYR A  49      19.419  52.117   4.782  1.00 11.06           C  
ATOM    426  CE2 TYR A  49      18.711  50.412   6.312  1.00 12.08           C  
ATOM    427  CZ  TYR A  49      18.487  51.183   5.192  1.00 11.51           C  
ATOM    428  OH  TYR A  49      17.290  51.017   4.545  1.00 13.63           O  
ATOM    429  N   SER A  50      23.007  52.307  10.624  1.00  8.53           N  
ATOM    430  CA  SER A  50      24.017  51.806  11.557  1.00  8.80           C  
ATOM    431  C   SER A  50      23.439  50.592  12.238  1.00  7.97           C  
ATOM    432  O   SER A  50      22.242  50.277  12.135  1.00  8.59           O  
ATOM    433  CB  SER A  50      24.507  52.862  12.563  1.00 11.64           C  
ATOM    434  OG  SER A  50      23.504  53.255  13.398  1.00 15.33           O  
ATOM    435  N   PHE A  51      24.288  49.866  12.968  1.00  7.50           N  
ATOM    436  CA  PHE A  51      23.927  48.560  13.510  1.00  7.05           C  
ATOM    437  C   PHE A  51      24.232  48.441  15.015  1.00  6.13           C  
ATOM    438  O   PHE A  51      24.977  49.254  15.592  1.00  6.95           O  
ATOM    439  CB  PHE A  51      24.664  47.455  12.735  1.00  7.11           C  
ATOM    440  CG  PHE A  51      24.309  47.577  11.235  1.00  8.28           C  
ATOM    441  CD1 PHE A  51      23.087  47.118  10.788  1.00  7.17           C  
ATOM    442  CD2 PHE A  51      25.181  48.159  10.333  1.00  8.96           C  
ATOM    443  CE1 PHE A  51      22.702  47.284   9.461  1.00  8.23           C  
ATOM    444  CE2 PHE A  51      24.820  48.336   9.019  1.00 10.67           C  
ATOM    445  CZ  PHE A  51      23.584  47.854   8.565  1.00  9.54           C  
ATOM    446  N   ASP A  52      23.651  47.385  15.602  1.00  6.88           N  
ATOM    447  CA  ASP A  52      23.954  46.964  16.962  1.00  6.49           C  
ATOM    448  C   ASP A  52      24.703  45.633  17.029  1.00  6.44           C  
ATOM    449  O   ASP A  52      25.349  45.323  18.059  1.00  7.37           O  
ATOM    450  CB  ASP A  52      22.682  46.841  17.810  1.00  8.61           C  
ATOM    451  CG  ASP A  52      21.926  48.166  17.807  1.00  8.78           C  
ATOM    452  OD1 ASP A  52      22.525  49.208  18.226  1.00 11.05           O  
ATOM    453  OD2 ASP A  52      20.766  48.201  17.349  1.00 10.58           O  
ATOM    454  N   PHE A  53      24.647  44.785  16.030  1.00  5.89           N  
ATOM    455  CA  PHE A  53      25.243  43.444  16.064  1.00  5.68           C  
ATOM    456  C   PHE A  53      25.466  42.960  14.640  1.00  5.13           C  
ATOM    457  O   PHE A  53      24.600  43.224  13.766  1.00  6.88           O  
ATOM    458  CB  PHE A  53      24.336  42.463  16.830  1.00  6.91           C  
ATOM    459  CG  PHE A  53      25.030  41.216  17.327  1.00  6.66           C  
ATOM    460  CD1 PHE A  53      25.194  40.090  16.500  1.00  7.44           C  
ATOM    461  CD2 PHE A  53      25.533  41.160  18.608  1.00  7.78           C  
ATOM    462  CE1 PHE A  53      25.839  38.982  16.940  1.00  7.96           C  
ATOM    463  CE2 PHE A  53      26.197  40.028  19.081  1.00  7.57           C  
ATOM    464  CZ  PHE A  53      26.332  38.947  18.228  1.00  8.63           C  
ATOM    465  N   ALA A  54      26.547  42.215  14.396  1.00  5.17           N  
ATOM    466  CA  ALA A  54      26.802  41.607  13.080  1.00  5.28           C  
ATOM    467  C   ALA A  54      26.987  40.091  13.163  1.00  4.78           C  
ATOM    468  O   ALA A  54      27.677  39.595  14.056  1.00  6.18           O  
ATOM    469  CB  ALA A  54      28.039  42.205  12.446  1.00  5.63           C  
ATOM    470  N   TYR A  55      26.433  39.374  12.177  1.00  5.20           N  
ATOM    471  CA  TYR A  55      26.703  37.979  11.930  1.00  5.24           C  
ATOM    472  C   TYR A  55      27.465  37.793  10.627  1.00  5.21           C  
ATOM    473  O   TYR A  55      27.172  38.454   9.596  1.00  6.30           O  
ATOM    474  CB  TYR A  55      25.412  37.128  11.827  1.00  5.92           C  
ATOM    475  CG  TYR A  55      24.669  37.057  13.156  1.00  5.91           C  
ATOM    476  CD1 TYR A  55      25.007  36.090  14.095  1.00  6.27           C  
ATOM    477  CD2 TYR A  55      23.692  37.985  13.507  1.00  6.23           C  
ATOM    478  CE1 TYR A  55      24.371  36.023  15.338  1.00  6.68           C  
ATOM    479  CE2 TYR A  55      23.043  37.926  14.714  1.00  7.57           C  
ATOM    480  CZ  TYR A  55      23.371  36.940  15.651  1.00  7.24           C  
ATOM    481  OH  TYR A  55      22.731  36.948  16.870  1.00  8.30           O  
ATOM    482  N   THR A  56      28.394  36.843  10.580  1.00  5.25           N  
ATOM    483  CA  THR A  56      29.077  36.459   9.367  1.00  5.14           C  
ATOM    484  C   THR A  56      29.464  34.983   9.448  1.00  5.24           C  
ATOM    485  O   THR A  56      29.153  34.291  10.421  1.00  5.92           O  
ATOM    486  CB  THR A  56      30.262  37.423   9.113  1.00  6.03           C  
ATOM    487  OG1 THR A  56      30.824  37.208   7.804  1.00  6.38           O  
ATOM    488  CG2 THR A  56      31.421  37.276  10.088  1.00  6.19           C  
ATOM    489  N   SER A  57      30.098  34.464   8.386  1.00  5.22           N  
ATOM    490  CA  SER A  57      30.563  33.100   8.335  1.00  5.13           C  
ATOM    491  C   SER A  57      31.964  32.982   8.941  1.00  5.27           C  
ATOM    492  O   SER A  57      32.455  33.915   9.567  1.00  6.14           O  
ATOM    493  CB  SER A  57      30.531  32.610   6.887  1.00  5.27           C  
ATOM    494  OG  SER A  57      31.598  33.259   6.176  1.00  5.73           O  
ATOM    495  N   VAL A  58      32.617  31.834   8.737  1.00  5.12           N  
ATOM    496  CA  VAL A  58      34.023  31.666   9.088  1.00  5.22           C  
ATOM    497  C   VAL A  58      34.944  31.749   7.879  1.00  5.56           C  
ATOM    498  O   VAL A  58      36.139  31.420   7.940  1.00  7.44           O  
ATOM    499  CB  VAL A  58      34.290  30.391   9.931  1.00  5.64           C  
ATOM    500  CG1 VAL A  58      33.603  30.505  11.272  1.00  7.39           C  
ATOM    501  CG2 VAL A  58      33.908  29.107   9.212  1.00  7.80           C  
ATOM    502  N   LEU A  59      34.415  32.242   6.730  1.00  5.17           N  
ATOM    503  CA  LEU A  59      35.183  32.373   5.492  1.00  4.82           C  
ATOM    504  C   LEU A  59      35.592  33.821   5.294  1.00  5.55           C  
ATOM    505  O   LEU A  59      34.778  34.783   5.378  1.00  5.59           O  
ATOM    506  CB  LEU A  59      34.359  31.815   4.351  1.00  5.72           C  
ATOM    507  CG  LEU A  59      33.908  30.363   4.508  1.00  5.92           C  
ATOM    508  CD1 LEU A  59      32.963  29.962   3.403  1.00  6.85           C  
ATOM    509  CD2 LEU A  59      35.080  29.391   4.592  1.00  8.96           C  
ATOM    510  N   LYS A  60      36.878  34.059   5.035  1.00  5.27           N  
ATOM    511  CA  LYS A  60      37.463  35.379   5.010  1.00  5.11           C  
ATOM    512  C   LYS A  60      36.870  36.282   3.953  1.00  5.22           C  
ATOM    513  O   LYS A  60      36.873  37.510   4.125  1.00  6.16           O  
ATOM    514  CB  LYS A  60      39.022  35.346   4.922  1.00  6.66           C  
ATOM    515  CG  LYS A  60      39.569  34.869   3.591  1.00  6.91           C  
ATOM    516  CD  LYS A  60      41.106  34.851   3.520  1.00  8.12           C  
ATOM    517  CE  LYS A  60      41.677  33.717   4.342  1.00  8.41           C  
ATOM    518  NZ  LYS A  60      43.132  33.603   4.261  1.00 14.25           N  
ATOM    519  N   ARG A  61      36.375  35.786   2.840  1.00  5.25           N  
ATOM    520  CA  ARG A  61      35.794  36.694   1.862  1.00  5.48           C  
ATOM    521  C   ARG A  61      34.588  37.432   2.507  1.00  5.23           C  
ATOM    522  O   ARG A  61      34.371  38.620   2.189  1.00  5.94           O  
ATOM    523  CB  ARG A  61      35.445  35.982   0.553  1.00  5.48           C  
ATOM    524  CG  ARG A  61      34.382  34.855   0.613  1.00  5.48           C  
ATOM    525  CD  ARG A  61      34.365  34.017  -0.590  1.00  5.64           C  
ATOM    526  NE  ARG A  61      33.548  32.889  -0.730  1.00  6.03           N  
ATOM    527  CZ  ARG A  61      33.813  31.613  -0.533  1.00  5.97           C  
ATOM    528  NH1 ARG A  61      34.863  31.287   0.184  1.00  5.86           N  
ATOM    529  NH2 ARG A  61      32.975  30.709  -0.998  1.00  6.25           N  
ATOM    530  N   ALA A  62      33.797  36.739   3.335  1.00  5.46           N  
ATOM    531  CA  ALA A  62      32.673  37.358   4.037  1.00  5.18           C  
ATOM    532  C   ALA A  62      33.157  38.202   5.235  1.00  4.98           C  
ATOM    533  O   ALA A  62      32.709  39.336   5.397  1.00  5.64           O  
ATOM    534  CB  ALA A  62      31.656  36.318   4.468  1.00  6.15           C  
ATOM    535  N   ILE A  63      34.079  37.673   6.049  1.00  5.27           N  
ATOM    536  CA  ILE A  63      34.566  38.366   7.226  1.00  5.24           C  
ATOM    537  C   ILE A  63      35.214  39.699   6.787  1.00  5.48           C  
ATOM    538  O   ILE A  63      34.959  40.759   7.377  1.00  5.29           O  
ATOM    539  CB  ILE A  63      35.561  37.516   8.014  1.00  5.50           C  
ATOM    540  CG1 ILE A  63      34.905  36.244   8.562  1.00  6.20           C  
ATOM    541  CG2 ILE A  63      36.203  38.329   9.151  1.00  6.29           C  
ATOM    542  CD1 ILE A  63      35.930  35.176   8.932  1.00  6.63           C  
ATOM    543  N   HIS A  64      36.067  39.657   5.761  1.00  5.26           N  
ATOM    544  CA  HIS A  64      36.721  40.877   5.282  1.00  5.46           C  
ATOM    545  C   HIS A  64      35.752  41.879   4.664  1.00  5.45           C  
ATOM    546  O   HIS A  64      35.941  43.109   4.760  1.00  5.93           O  
ATOM    547  CB  HIS A  64      37.839  40.522   4.291  1.00  5.71           C  
ATOM    548  CG  HIS A  64      39.001  39.846   4.947  1.00  5.74           C  
ATOM    549  ND1 HIS A  64      39.965  39.180   4.225  1.00  6.91           N  
ATOM    550  CD2 HIS A  64      39.394  39.787   6.246  1.00  6.60           C  
ATOM    551  CE1 HIS A  64      40.907  38.738   5.057  1.00  6.61           C  
ATOM    552  NE2 HIS A  64      40.553  39.092   6.280  1.00  7.13           N  
ATOM    553  N   THR A  65      34.674  41.346   4.039  1.00  5.35           N  
ATOM    554  CA  THR A  65      33.625  42.281   3.594  1.00  5.34           C  
ATOM    555  C   THR A  65      33.031  43.013   4.800  1.00  5.44           C  
ATOM    556  O   THR A  65      32.899  44.246   4.766  1.00  6.27           O  
ATOM    557  CB  THR A  65      32.539  41.545   2.827  1.00  5.12           C  
ATOM    558  OG1 THR A  65      33.083  41.008   1.590  1.00  6.47           O  
ATOM    559  CG2 THR A  65      31.404  42.455   2.389  1.00  6.13           C  
ATOM    560  N   LEU A  66      32.691  42.285   5.853  1.00  5.25           N  
ATOM    561  CA  LEU A  66      32.173  42.898   7.067  1.00  5.27           C  
ATOM    562  C   LEU A  66      33.145  43.907   7.689  1.00  5.61           C  
ATOM    563  O   LEU A  66      32.734  45.030   8.045  1.00  5.86           O  
ATOM    564  CB  LEU A  66      31.809  41.796   8.107  1.00  5.63           C  
ATOM    565  CG  LEU A  66      31.249  42.323   9.412  1.00  5.85           C  
ATOM    566  CD1 LEU A  66      29.941  43.080   9.215  1.00  6.52           C  
ATOM    567  CD2 LEU A  66      31.108  41.177  10.437  1.00  7.36           C  
ATOM    568  N   TRP A  67      34.424  43.552   7.833  1.00  5.95           N  
ATOM    569  CA  TRP A  67      35.397  44.486   8.421  1.00  5.60           C  
ATOM    570  C   TRP A  67      35.448  45.794   7.637  1.00  5.12           C  
ATOM    571  O   TRP A  67      35.459  46.872   8.205  1.00  6.36           O  
ATOM    572  CB  TRP A  67      36.751  43.805   8.545  1.00  5.95           C  
ATOM    573  CG  TRP A  67      36.869  42.727   9.583  1.00  5.60           C  
ATOM    574  CD1 TRP A  67      35.942  42.382  10.516  1.00  6.32           C  
ATOM    575  CD2 TRP A  67      37.990  41.866   9.803  1.00  6.04           C  
ATOM    576  NE1 TRP A  67      36.400  41.338  11.306  1.00  6.91           N  
ATOM    577  CE2 TRP A  67      37.680  41.025  10.877  1.00  7.09           C  
ATOM    578  CE3 TRP A  67      39.257  41.743   9.180  1.00  6.59           C  
ATOM    579  CZ2 TRP A  67      38.569  40.058  11.370  1.00  7.75           C  
ATOM    580  CZ3 TRP A  67      40.131  40.799   9.647  1.00  7.62           C  
ATOM    581  CH2 TRP A  67      39.781  39.977  10.727  1.00  8.48           C  
ATOM    582  N   ASN A  68      35.474  45.716   6.300  1.00  5.35           N  
ATOM    583  CA  ASN A  68      35.512  46.903   5.477  1.00  5.65           C  
ATOM    584  C   ASN A  68      34.241  47.728   5.641  1.00  5.94           C  
ATOM    585  O   ASN A  68      34.301  48.969   5.738  1.00  6.55           O  
ATOM    586  CB  ASN A  68      35.721  46.515   4.007  1.00  7.01           C  
ATOM    587  CG  ASN A  68      37.127  46.202   3.633  1.00  7.70           C  
ATOM    588  OD1 ASN A  68      38.062  46.972   3.861  1.00 13.87           O  
ATOM    589  ND2 ASN A  68      37.350  45.071   2.963  1.00 11.03           N  
ATOM    590  N   VAL A  69      33.062  47.099   5.682  1.00  5.66           N  
ATOM    591  CA  VAL A  69      31.806  47.802   5.920  1.00  5.71           C  
ATOM    592  C   VAL A  69      31.819  48.505   7.278  1.00  5.68           C  
ATOM    593  O   VAL A  69      31.454  49.693   7.363  1.00  6.45           O  
ATOM    594  CB  VAL A  69      30.622  46.807   5.778  1.00  5.90           C  
ATOM    595  CG1 VAL A  69      29.323  47.389   6.354  1.00  7.70           C  
ATOM    596  CG2 VAL A  69      30.424  46.420   4.322  1.00  7.03           C  
ATOM    597  N   LEU A  70      32.228  47.775   8.317  1.00  5.82           N  
ATOM    598  CA  LEU A  70      32.257  48.361   9.660  1.00  5.42           C  
ATOM    599  C   LEU A  70      33.175  49.573   9.702  1.00  6.08           C  
ATOM    600  O   LEU A  70      32.855  50.583  10.354  1.00  6.38           O  
ATOM    601  CB  LEU A  70      32.660  47.321  10.730  1.00  7.33           C  
ATOM    602  CG  LEU A  70      31.658  46.163  10.929  1.00  7.91           C  
ATOM    603  CD1 LEU A  70      32.197  45.189  11.970  1.00  9.94           C  
ATOM    604  CD2 LEU A  70      30.276  46.651  11.314  1.00  9.13           C  
ATOM    605  N   ASP A  71      34.332  49.503   9.044  1.00  6.23           N  
ATOM    606  CA  ASP A  71      35.219  50.693   9.064  1.00  5.82           C  
ATOM    607  C   ASP A  71      34.553  51.875   8.395  1.00  6.54           C  
ATOM    608  O   ASP A  71      34.637  53.025   8.903  1.00  8.06           O  
ATOM    609  CB  ASP A  71      36.540  50.338   8.416  1.00  6.98           C  
ATOM    610  CG  ASP A  71      37.476  49.514   9.278  1.00  7.39           C  
ATOM    611  OD1 ASP A  71      37.351  49.549  10.514  1.00  8.38           O  
ATOM    612  OD2 ASP A  71      38.419  48.915   8.689  1.00  9.29           O  
ATOM    613  N   GLU A  72      33.855  51.707   7.274  1.00  6.62           N  
ATOM    614  CA  GLU A  72      33.172  52.839   6.632  1.00  6.69           C  
ATOM    615  C   GLU A  72      32.105  53.428   7.520  1.00  7.18           C  
ATOM    616  O   GLU A  72      31.811  54.637   7.446  1.00  9.07           O  
ATOM    617  CB  GLU A  72      32.587  52.412   5.301  1.00  7.92           C  
ATOM    618  CG  GLU A  72      33.652  51.978   4.292  1.00  8.50           C  
ATOM    619  CD  GLU A  72      34.645  53.034   3.877  1.00  9.98           C  
ATOM    620  OE1 GLU A  72      34.339  54.234   3.910  1.00 15.77           O  
ATOM    621  OE2 GLU A  72      35.764  52.660   3.459  1.00 13.74           O  
ATOM    622  N   LEU A  73      31.502  52.624   8.385  1.00  7.00           N  
ATOM    623  CA  LEU A  73      30.468  53.061   9.318  1.00  7.23           C  
ATOM    624  C   LEU A  73      31.021  53.610  10.632  1.00  7.00           C  
ATOM    625  O   LEU A  73      30.288  54.077  11.501  1.00  8.58           O  
ATOM    626  CB  LEU A  73      29.531  51.879   9.635  1.00  8.37           C  
ATOM    627  CG  LEU A  73      28.712  51.321   8.484  1.00  9.12           C  
ATOM    628  CD1 LEU A  73      28.015  50.028   8.901  1.00 12.89           C  
ATOM    629  CD2 LEU A  73      27.749  52.341   7.920  1.00 14.66           C  
ATOM    630  N   ASP A  74      32.337  53.517  10.822  1.00  6.92           N  
ATOM    631  CA  ASP A  74      32.969  53.825  12.107  1.00  7.44           C  
ATOM    632  C   ASP A  74      32.365  52.980  13.227  1.00  7.03           C  
ATOM    633  O   ASP A  74      32.129  53.449  14.346  1.00  7.70           O  
ATOM    634  CB  ASP A  74      33.003  55.336  12.466  1.00  7.78           C  
ATOM    635  CG  ASP A  74      34.013  55.652  13.531  1.00  8.66           C  
ATOM    636  OD1 ASP A  74      34.988  54.895  13.746  1.00  9.86           O  
ATOM    637  OD2 ASP A  74      33.821  56.686  14.194  1.00 12.98           O  
ATOM    638  N   GLN A  75      32.149  51.697  12.921  1.00  6.30           N  
ATOM    639  CA  GLN A  75      31.626  50.730  13.868  1.00  6.87           C  
ATOM    640  C   GLN A  75      32.527  49.472  13.957  1.00  5.72           C  
ATOM    641  O   GLN A  75      32.028  48.346  14.119  1.00  6.59           O  
ATOM    642  CB  GLN A  75      30.185  50.340  13.542  1.00  6.86           C  
ATOM    643  CG  GLN A  75      29.173  51.490  13.703  1.00  6.93           C  
ATOM    644  CD  GLN A  75      27.765  50.971  13.776  1.00  7.27           C  
ATOM    645  OE1 GLN A  75      27.153  50.533  12.778  1.00  8.18           O  
ATOM    646  NE2 GLN A  75      27.212  50.923  14.971  1.00  8.38           N  
ATOM    647  N   ALA A  76      33.855  49.655  13.924  1.00  6.29           N  
ATOM    648  CA  ALA A  76      34.776  48.545  14.097  1.00  5.99           C  
ATOM    649  C   ALA A  76      34.615  47.869  15.447  1.00  5.36           C  
ATOM    650  O   ALA A  76      34.993  46.712  15.632  1.00  6.55           O  
ATOM    651  CB  ALA A  76      36.234  48.938  13.850  1.00  8.28           C  
ATOM    652  N   TRP A  77      34.040  48.604  16.419  1.00  5.65           N  
ATOM    653  CA  TRP A  77      33.760  48.133  17.756  1.00  6.39           C  
ATOM    654  C   TRP A  77      32.550  47.236  17.880  1.00  6.07           C  
ATOM    655  O   TRP A  77      32.290  46.694  18.970  1.00  7.41           O  
ATOM    656  CB  TRP A  77      33.577  49.338  18.725  1.00  6.82           C  
ATOM    657  CG  TRP A  77      32.582  50.360  18.218  1.00  7.11           C  
ATOM    658  CD1 TRP A  77      32.895  51.483  17.469  1.00  8.16           C  
ATOM    659  CD2 TRP A  77      31.163  50.419  18.380  1.00  7.96           C  
ATOM    660  NE1 TRP A  77      31.772  52.193  17.184  1.00  9.52           N  
ATOM    661  CE2 TRP A  77      30.694  51.589  17.718  1.00  9.25           C  
ATOM    662  CE3 TRP A  77      30.260  49.588  19.036  1.00 10.50           C  
ATOM    663  CZ2 TRP A  77      29.326  51.948  17.687  1.00 10.69           C  
ATOM    664  CZ3 TRP A  77      28.897  49.934  19.026  1.00 11.53           C  
ATOM    665  CH2 TRP A  77      28.488  51.108  18.346  1.00 13.11           C  
ATOM    666  N   LEU A  78      31.788  47.033  16.830  1.00  6.18           N  
ATOM    667  CA  LEU A  78      30.514  46.312  16.885  1.00  6.29           C  
ATOM    668  C   LEU A  78      30.730  44.882  17.336  1.00  5.41           C  
ATOM    669  O   LEU A  78      31.658  44.220  16.850  1.00  6.04           O  
ATOM    670  CB  LEU A  78      29.862  46.270  15.489  1.00  6.90           C  
ATOM    671  CG  LEU A  78      28.365  46.052  15.476  1.00  7.85           C  
ATOM    672  CD1 LEU A  78      27.601  47.242  16.041  1.00 11.04           C  
ATOM    673  CD2 LEU A  78      27.944  45.743  14.054  1.00  9.11           C  
ATOM    674  N   PRO A  79      29.865  44.320  18.179  1.00  6.18           N  
ATOM    675  CA  PRO A  79      29.925  42.877  18.417  1.00  5.93           C  
ATOM    676  C   PRO A  79      29.684  42.087  17.136  1.00  5.56           C  
ATOM    677  O   PRO A  79      28.776  42.381  16.353  1.00  6.19           O  
ATOM    678  CB  PRO A  79      28.774  42.622  19.432  1.00  8.22           C  
ATOM    679  CG  PRO A  79      28.508  43.962  20.052  1.00 10.28           C  
ATOM    680  CD  PRO A  79      28.792  44.956  18.985  1.00  7.30           C  
ATOM    681  N   VAL A  80      30.520  41.055  16.929  1.00  5.53           N  
ATOM    682  CA  VAL A  80      30.467  40.173  15.740  1.00  5.01           C  
ATOM    683  C   VAL A  80      30.436  38.723  16.176  1.00  5.40           C  
ATOM    684  O   VAL A  80      31.209  38.331  17.074  1.00  6.84           O  
ATOM    685  CB  VAL A  80      31.727  40.417  14.856  1.00  5.47           C  
ATOM    686  CG1 VAL A  80      31.755  39.426  13.680  1.00  7.35           C  
ATOM    687  CG2 VAL A  80      31.804  41.847  14.379  1.00  6.64           C  
ATOM    688  N   GLU A  81      29.564  37.918  15.569  1.00  5.66           N  
ATOM    689  CA  GLU A  81      29.528  36.483  15.740  1.00  5.39           C  
ATOM    690  C   GLU A  81      29.807  35.837  14.374  1.00  5.99           C  
ATOM    691  O   GLU A  81      29.125  36.161  13.401  1.00  6.44           O  
ATOM    692  CB  GLU A  81      28.179  36.023  16.309  1.00  6.81           C  
ATOM    693  CG  GLU A  81      28.073  34.532  16.557  1.00  7.83           C  
ATOM    694  CD  GLU A  81      26.860  34.142  17.384  1.00  9.27           C  
ATOM    695  OE1 GLU A  81      26.529  34.881  18.372  1.00 10.11           O  
ATOM    696  OE2 GLU A  81      26.264  33.072  17.091  1.00 10.15           O  
ATOM    697  N   LYS A  82      30.796  34.949  14.346  1.00  6.11           N  
ATOM    698  CA  LYS A  82      31.259  34.272  13.148  1.00  6.07           C  
ATOM    699  C   LYS A  82      30.835  32.802  13.225  1.00  7.82           C  
ATOM    700  O   LYS A  82      31.222  32.088  14.157  1.00 13.06           O  
ATOM    701  CB  LYS A  82      32.774  34.372  13.012  1.00  7.97           C  
ATOM    702  CG  LYS A  82      33.272  35.821  13.090  1.00  7.00           C  
ATOM    703  CD  LYS A  82      34.731  36.023  12.888  1.00 11.64           C  
ATOM    704  CE  LYS A  82      35.226  37.440  13.024  1.00 11.39           C  
ATOM    705  NZ  LYS A  82      35.497  37.858  14.426  1.00 15.35           N  
ATOM    706  N   SER A  83      29.980  32.318  12.311  1.00  6.92           N  
ATOM    707  CA  SER A  83      29.452  30.959  12.413  1.00  7.31           C  
ATOM    708  C   SER A  83      29.594  30.205  11.104  1.00  5.90           C  
ATOM    709  O   SER A  83      29.179  30.691  10.037  1.00  6.25           O  
ATOM    710  CB  SER A  83      27.987  31.006  12.804  1.00  9.13           C  
ATOM    711  OG  SER A  83      27.354  29.762  12.801  1.00 10.51           O  
ATOM    712  N   TRP A  84      30.076  28.955  11.187  1.00  6.30           N  
ATOM    713  CA  TRP A  84      30.097  28.064  10.031  1.00  5.90           C  
ATOM    714  C   TRP A  84      28.733  27.833   9.440  1.00  6.09           C  
ATOM    715  O   TRP A  84      28.600  27.471   8.270  1.00  6.76           O  
ATOM    716  CB  TRP A  84      30.696  26.745  10.441  1.00  7.47           C  
ATOM    717  CG  TRP A  84      29.850  25.864  11.334  1.00  7.97           C  
ATOM    718  CD1 TRP A  84      29.747  25.838  12.671  1.00 10.11           C  
ATOM    719  CD2 TRP A  84      28.968  24.803  10.876  1.00  8.76           C  
ATOM    720  NE1 TRP A  84      28.868  24.877  13.088  1.00 11.96           N  
ATOM    721  CE2 TRP A  84      28.379  24.213  12.005  1.00 10.65           C  
ATOM    722  CE3 TRP A  84      28.621  24.300   9.623  1.00  9.73           C  
ATOM    723  CZ2 TRP A  84      27.482  23.155  11.865  1.00 14.52           C  
ATOM    724  CZ3 TRP A  84      27.735  23.250   9.483  1.00 14.26           C  
ATOM    725  CH2 TRP A  84      27.163  22.691  10.633  1.00 14.71           C  
ATOM    726  N   LYS A  85      27.701  27.964  10.188  1.00  6.52           N  
ATOM    727  CA  LYS A  85      26.293  27.788   9.781  1.00  5.90           C  
ATOM    728  C   LYS A  85      25.900  28.762   8.660  1.00  6.26           C  
ATOM    729  O   LYS A  85      24.944  28.502   7.914  1.00  6.51           O  
ATOM    730  CB  LYS A  85      25.345  27.803  10.962  1.00  7.10           C  
ATOM    731  CG  LYS A  85      25.640  26.680  11.972  1.00  8.68           C  
ATOM    732  CD  LYS A  85      24.828  26.756  13.243  1.00 10.93           C  
ATOM    733  CE  LYS A  85      25.201  25.615  14.190  1.00 12.02           C  
ATOM    734  NZ  LYS A  85      24.415  25.511  15.418  1.00 16.94           N  
ATOM    735  N   LEU A  86      26.594  29.900   8.516  1.00  6.11           N  
ATOM    736  CA  LEU A  86      26.401  30.843   7.433  1.00  5.82           C  
ATOM    737  C   LEU A  86      27.375  30.642   6.252  1.00  5.00           C  
ATOM    738  O   LEU A  86      27.359  31.442   5.312  1.00  5.61           O  
ATOM    739  CB  LEU A  86      26.489  32.316   7.938  1.00  5.88           C  
ATOM    740  CG  LEU A  86      25.329  32.718   8.849  1.00  6.71           C  
ATOM    741  CD1 LEU A  86      25.619  34.117   9.457  1.00  6.98           C  
ATOM    742  CD2 LEU A  86      23.998  32.728   8.162  1.00  9.93           C  
ATOM    743  N   ASN A  87      28.185  29.603   6.273  1.00  5.87           N  
ATOM    744  CA  ASN A  87      29.117  29.315   5.186  1.00  5.56           C  
ATOM    745  C   ASN A  87      28.375  29.136   3.851  1.00  5.70           C  
ATOM    746  O   ASN A  87      27.209  28.707   3.784  1.00  6.44           O  
ATOM    747  CB  ASN A  87      29.965  28.061   5.464  1.00  5.53           C  
ATOM    748  CG  ASN A  87      31.184  28.301   6.312  1.00  5.56           C  
ATOM    749  OD1 ASN A  87      31.395  29.382   6.856  1.00  6.06           O  
ATOM    750  ND2 ASN A  87      32.023  27.265   6.421  1.00  6.74           N  
ATOM    751  N   GLU A  88      29.089  29.420   2.761  1.00  5.82           N  
ATOM    752  CA  GLU A  88      28.704  29.020   1.393  1.00  5.50           C  
ATOM    753  C   GLU A  88      28.369  27.545   1.368  1.00  5.54           C  
ATOM    754  O   GLU A  88      28.861  26.735   2.158  1.00  5.99           O  
ATOM    755  CB  GLU A  88      29.857  29.334   0.432  1.00  5.43           C  
ATOM    756  CG  GLU A  88      29.556  29.139  -1.008  1.00  5.93           C  
ATOM    757  CD  GLU A  88      28.356  29.945  -1.471  1.00  6.16           C  
ATOM    758  OE1 GLU A  88      27.202  29.498  -1.301  1.00  7.51           O  
ATOM    759  OE2 GLU A  88      28.601  31.090  -1.938  1.00  7.45           O  
ATOM    760  N   ARG A  89      27.488  27.157   0.424  1.00  6.61           N  
ATOM    761  CA  ARG A  89      27.278  25.731   0.119  1.00  6.87           C  
ATOM    762  C   ARG A  89      28.597  25.065  -0.230  1.00  6.39           C  
ATOM    763  O   ARG A  89      29.320  25.552  -1.107  1.00  7.30           O  
ATOM    764  CB  ARG A  89      26.260  25.660  -1.028  0.62  8.37           C  
ATOM    766  CG  ARG A  89      26.047  24.296  -1.622  0.62  9.64           C  
ATOM    768  CD  ARG A  89      26.949  23.984  -2.826  0.62 16.20           C  
ATOM    770  NE  ARG A  89      26.567  24.778  -3.917  0.62 15.23           N  
ATOM    772  CZ  ARG A  89      25.823  24.567  -4.969  0.62 12.22           C  
ATOM    774  NH1 ARG A  89      25.210  23.413  -5.199  0.62 12.70           N  
ATOM    776  NH2 ARG A  89      25.721  25.623  -5.788  0.62 15.27           N  
ATOM    778  N   HIS A  90      28.850  23.911   0.373  1.00  5.88           N  
ATOM    779  CA  HIS A  90      30.037  23.149   0.047  1.00  6.42           C  
ATOM    780  C   HIS A  90      29.964  22.568  -1.377  1.00  6.07           C  
ATOM    781  O   HIS A  90      28.928  21.997  -1.763  1.00  7.60           O  
ATOM    782  CB  HIS A  90      30.217  22.001   1.098  1.00  6.56           C  
ATOM    783  CG  HIS A  90      31.599  21.443   1.144  1.00  6.72           C  
ATOM    784  ND1 HIS A  90      32.048  20.497   0.265  1.00  8.08           N  
ATOM    785  CD2 HIS A  90      32.670  21.696   1.917  1.00  7.36           C  
ATOM    786  CE1 HIS A  90      33.316  20.246   0.441  1.00  7.54           C  
ATOM    787  NE2 HIS A  90      33.720  20.961   1.499  1.00  7.22           N  
ATOM    788  N   TYR A  91      31.039  22.677  -2.147  1.00  6.55           N  
ATOM    789  CA  TYR A  91      31.040  22.287  -3.559  1.00  6.64           C  
ATOM    790  C   TYR A  91      31.650  20.931  -3.824  1.00  7.46           C  
ATOM    791  O   TYR A  91      31.909  20.528  -4.967  1.00  8.20           O  
ATOM    792  CB  TYR A  91      31.780  23.341  -4.426  1.00  8.64           C  
ATOM    793  CG  TYR A  91      30.951  24.098  -5.406  1.00  9.93           C  
ATOM    794  CD1 TYR A  91      30.278  23.427  -6.405  1.00 13.15           C  
ATOM    795  CD2 TYR A  91      30.813  25.493  -5.383  1.00 10.65           C  
ATOM    796  CE1 TYR A  91      29.517  24.080  -7.351  1.00 15.47           C  
ATOM    797  CE2 TYR A  91      30.054  26.167  -6.307  1.00 12.28           C  
ATOM    798  CZ  TYR A  91      29.393  25.454  -7.300  1.00 17.17           C  
ATOM    799  OH  TYR A  91      28.620  26.118  -8.216  1.00 19.63           O  
ATOM    800  N   GLY A  92      31.887  20.142  -2.851  1.00  7.50           N  
ATOM    801  CA  GLY A  92      32.423  18.769  -2.940  1.00  7.10           C  
ATOM    802  C   GLY A  92      33.744  18.760  -3.671  1.00  7.03           C  
ATOM    803  O   GLY A  92      34.593  19.627  -3.505  1.00  7.58           O  
ATOM    804  N   ALA A  93      33.911  17.736  -4.509  1.00  7.88           N  
ATOM    805  CA  ALA A  93      35.096  17.533  -5.340  1.00  8.74           C  
ATOM    806  C   ALA A  93      35.240  18.626  -6.404  1.00  8.76           C  
ATOM    807  O   ALA A  93      36.283  18.705  -7.047  1.00 10.05           O  
ATOM    808  CB  ALA A  93      35.051  16.171  -5.998  1.00  9.44           C  
ATOM    809  N   LEU A  94      34.242  19.492  -6.626  1.00  8.66           N  
ATOM    810  CA  LEU A  94      34.408  20.579  -7.578  1.00  8.75           C  
ATOM    811  C   LEU A  94      35.233  21.725  -7.003  1.00  8.47           C  
ATOM    812  O   LEU A  94      35.648  22.611  -7.757  1.00  9.21           O  
ATOM    813  CB  LEU A  94      33.060  21.103  -8.067  1.00  8.94           C  
ATOM    814  CG  LEU A  94      32.141  20.046  -8.684  1.00  9.45           C  
ATOM    815  CD1 LEU A  94      30.878  20.702  -9.210  1.00 10.24           C  
ATOM    816  CD2 LEU A  94      32.832  19.209  -9.758  1.00 11.74           C  
ATOM    817  N   GLN A  95      35.492  21.803  -5.690  1.00  8.63           N  
ATOM    818  CA  GLN A  95      36.203  22.972  -5.123  1.00  8.09           C  
ATOM    819  C   GLN A  95      37.591  23.086  -5.743  1.00  7.90           C  
ATOM    820  O   GLN A  95      38.412  22.161  -5.700  1.00  9.80           O  
ATOM    821  CB  GLN A  95      36.262  22.879  -3.592  1.00  8.24           C  
ATOM    822  CG  GLN A  95      34.904  23.017  -2.931  1.00  7.72           C  
ATOM    823  CD  GLN A  95      34.831  23.094  -1.426  1.00  7.63           C  
ATOM    824  OE1 GLN A  95      33.688  23.317  -0.917  1.00  7.36           O  
ATOM    825  NE2 GLN A  95      35.940  22.939  -0.706  1.00  7.57           N  
ATOM    826  N   GLY A  96      37.857  24.254  -6.327  1.00  8.45           N  
ATOM    827  CA  GLY A  96      39.095  24.590  -6.999  1.00  8.00           C  
ATOM    828  C   GLY A  96      39.058  24.438  -8.507  1.00  8.67           C  
ATOM    829  O   GLY A  96      39.946  24.956  -9.168  1.00 10.70           O  
ATOM    830  N   LEU A  97      38.083  23.741  -9.046  1.00  9.16           N  
ATOM    831  CA  LEU A  97      38.024  23.511 -10.503  1.00  8.77           C  
ATOM    832  C   LEU A  97      37.506  24.749 -11.225  1.00  8.84           C  
ATOM    833  O   LEU A  97      36.646  25.482 -10.724  1.00  9.81           O  
ATOM    834  CB  LEU A  97      37.176  22.271 -10.822  1.00 10.06           C  
ATOM    835  CG  LEU A  97      37.629  20.918 -10.279  1.00 14.13           C  
ATOM    836  CD1 LEU A  97      36.692  19.821 -10.784  1.00 14.09           C  
ATOM    837  CD2 LEU A  97      39.075  20.574 -10.612  1.00 17.54           C  
ATOM    838  N   ASN A  98      37.964  24.969 -12.449  1.00  8.89           N  
ATOM    839  CA  ASN A  98      37.484  26.028 -13.309  1.00  9.46           C  
ATOM    840  C   ASN A  98      36.123  25.636 -13.890  1.00  8.37           C  
ATOM    841  O   ASN A  98      35.944  24.513 -14.368  1.00 10.09           O  
ATOM    842  CB  ASN A  98      38.513  26.319 -14.418  1.00 10.60           C  
ATOM    843  CG  ASN A  98      38.042  27.350 -15.416  1.00 10.69           C  
ATOM    844  OD1 ASN A  98      37.221  27.031 -16.287  1.00 11.16           O  
ATOM    845  ND2 ASN A  98      38.552  28.596 -15.332  1.00 14.21           N  
ATOM    846  N   LYS A  99      35.143  26.533 -13.822  1.00  8.72           N  
ATOM    847  CA  LYS A  99      33.787  26.247 -14.219  1.00  9.01           C  
ATOM    848  C   LYS A  99      33.640  25.962 -15.715  1.00  9.55           C  
ATOM    849  O   LYS A  99      32.875  25.087 -16.116  1.00  9.97           O  
ATOM    850  CB  LYS A  99      32.817  27.348 -13.764  1.00  8.25           C  
ATOM    851  CG  LYS A  99      32.969  27.717 -12.282  1.00  9.35           C  
ATOM    852  CD  LYS A  99      31.866  28.670 -11.801  1.00 10.60           C  
ATOM    853  CE  LYS A  99      32.386  29.486 -10.623  1.00  9.70           C  
ATOM    854  NZ  LYS A  99      31.352  30.439 -10.055  1.00 10.60           N  
ATOM    855  N   ALA A 100      34.377  26.686 -16.548  1.00  9.58           N  
ATOM    856  CA  ALA A 100      34.337  26.495 -17.982  1.00 10.93           C  
ATOM    857  C   ALA A 100      34.949  25.149 -18.363  1.00 10.50           C  
ATOM    858  O   ALA A 100      34.392  24.389 -19.189  1.00 11.43           O  
ATOM    859  CB  ALA A 100      35.043  27.630 -18.742  1.00 12.75           C  
ATOM    860  N   GLU A 101      36.100  24.818 -17.790  1.00 11.50           N  
ATOM    861  CA  GLU A 101      36.796  23.564 -18.048  1.00 11.19           C  
ATOM    862  C   GLU A 101      35.941  22.380 -17.620  1.00 10.70           C  
ATOM    863  O   GLU A 101      35.903  21.342 -18.290  1.00 11.18           O  
ATOM    864  CB  GLU A 101      38.156  23.548 -17.376  1.00 12.57           C  
ATOM    865  CG  GLU A 101      39.135  24.581 -17.882  1.00 14.74           C  
ATOM    866  CD  GLU A 101      40.389  24.665 -17.039  1.00 16.70           C  
ATOM    867  OE1 GLU A 101      40.683  23.677 -16.311  1.00 20.16           O  
ATOM    868  OE2 GLU A 101      41.022  25.750 -17.113  1.00 23.25           O  
ATOM    869  N   THR A 102      35.239  22.560 -16.482  1.00 10.03           N  
ATOM    870  CA  THR A 102      34.400  21.502 -15.951  1.00  9.45           C  
ATOM    871  C   THR A 102      33.182  21.292 -16.864  1.00  8.91           C  
ATOM    872  O   THR A 102      32.790  20.143 -17.167  1.00 10.09           O  
ATOM    873  CB  THR A 102      33.978  21.795 -14.500  1.00 10.08           C  
ATOM    874  OG1 THR A 102      35.173  21.964 -13.701  1.00 11.65           O  
ATOM    875  CG2 THR A 102      33.147  20.686 -13.886  1.00 11.28           C  
ATOM    876  N   ALA A 103      32.578  22.392 -17.348  1.00 10.41           N  
ATOM    877  CA  ALA A 103      31.451  22.283 -18.267  1.00  9.98           C  
ATOM    878  C   ALA A 103      31.879  21.619 -19.577  1.00 11.59           C  
ATOM    879  O   ALA A 103      31.114  20.858 -20.194  1.00 11.39           O  
ATOM    880  CB  ALA A 103      30.889  23.655 -18.550  1.00 11.46           C  
ATOM    881  N   GLU A 104      33.101  21.870 -20.063  1.00 10.14           N  
ATOM    882  CA  GLU A 104      33.564  21.197 -21.267  1.00 10.69           C  
ATOM    883  C   GLU A 104      33.711  19.697 -21.006  1.00 10.24           C  
ATOM    884  O   GLU A 104      33.318  18.848 -21.837  1.00 11.33           O  
ATOM    885  CB  GLU A 104      34.884  21.776 -21.708  1.00 11.25           C  
ATOM    886  CG  GLU A 104      35.340  21.212 -23.036  0.60 10.84           C  
ATOM    888  CD  GLU A 104      36.587  21.825 -23.610  0.60 11.50           C  
ATOM    890  OE1 GLU A 104      36.603  23.045 -23.846  0.60 16.40           O  
ATOM    892  OE2 GLU A 104      37.557  21.088 -23.848  0.60 11.50           O  
ATOM    894  N   LYS A 105      34.306  19.297 -19.872  1.00  9.40           N  
ATOM    895  CA  LYS A 105      34.647  17.899 -19.636  1.00  9.37           C  
ATOM    896  C   LYS A 105      33.439  17.021 -19.335  1.00  8.51           C  
ATOM    897  O   LYS A 105      33.432  15.854 -19.687  1.00  9.59           O  
ATOM    898  CB  LYS A 105      35.652  17.788 -18.495  0.68 12.28           C  
ATOM    900  CG  LYS A 105      37.056  18.173 -18.906  0.68 17.05           C  
ATOM    902  CD  LYS A 105      38.003  17.701 -17.787  0.68 21.87           C  
ATOM    904  CE  LYS A 105      39.355  17.573 -18.474  0.68 28.32           C  
ATOM    906  NZ  LYS A 105      39.661  18.870 -19.119  0.68 34.11           N  
ATOM    908  N   TYR A 106      32.427  17.589 -18.642  1.00  9.46           N  
ATOM    909  CA  TYR A 106      31.269  16.875 -18.145  1.00 10.66           C  
ATOM    910  C   TYR A 106      29.925  17.321 -18.754  1.00 11.52           C  
ATOM    911  O   TYR A 106      28.910  16.683 -18.476  1.00 15.39           O  
ATOM    912  CB  TYR A 106      31.201  17.027 -16.611  1.00 10.72           C  
ATOM    913  CG  TYR A 106      32.379  16.404 -15.895  1.00 11.23           C  
ATOM    914  CD1 TYR A 106      32.529  15.008 -15.761  1.00 11.62           C  
ATOM    915  CD2 TYR A 106      33.372  17.169 -15.349  1.00 11.80           C  
ATOM    916  CE1 TYR A 106      33.620  14.475 -15.099  1.00 10.86           C  
ATOM    917  CE2 TYR A 106      34.463  16.656 -14.689  1.00 11.07           C  
ATOM    918  CZ  TYR A 106      34.605  15.294 -14.561  1.00  9.70           C  
ATOM    919  OH  TYR A 106      35.659  14.705 -13.921  1.00 10.93           O  
ATOM    920  N   GLY A 107      29.924  18.391 -19.547  1.00 12.59           N  
ATOM    921  CA  GLY A 107      28.694  18.920 -20.128  1.00 12.67           C  
ATOM    922  C   GLY A 107      28.138  20.139 -19.453  1.00 14.08           C  
ATOM    923  O   GLY A 107      28.134  20.263 -18.198  1.00 14.92           O  
ATOM    924  N   ASP A 108      27.624  21.094 -20.198  1.00 13.25           N  
ATOM    925  CA  ASP A 108      27.139  22.384 -19.665  1.00 13.07           C  
ATOM    926  C   ASP A 108      25.938  22.145 -18.783  1.00 14.14           C  
ATOM    927  O   ASP A 108      25.807  22.719 -17.726  1.00 16.20           O  
ATOM    928  CB  ASP A 108      26.842  23.343 -20.826  0.51 17.78           C  
ATOM    930  CG  ASP A 108      27.740  24.464 -21.272  0.51 15.58           C  
ATOM    932  OD1 ASP A 108      28.607  24.989 -20.530  0.51 14.28           O  
ATOM    934  OD2 ASP A 108      27.611  24.945 -22.447  0.51 16.33           O  
ATOM    936  N   GLU A 109      25.020  21.248 -19.200  1.00 14.15           N  
ATOM    937  CA  GLU A 109      23.799  21.014 -18.399  1.00 16.74           C  
ATOM    938  C   GLU A 109      24.165  20.348 -17.081  1.00 13.75           C  
ATOM    939  O   GLU A 109      23.632  20.730 -16.004  1.00 17.53           O  
ATOM    940  CB  GLU A 109      22.751  20.214 -19.196  1.00 23.75           C  
ATOM    941  CG  GLU A 109      21.483  19.991 -18.359  1.00 27.64           C  
ATOM    942  CD  GLU A 109      20.798  21.297 -17.955  1.00 33.39           C  
ATOM    943  OE1 GLU A 109      20.913  22.314 -18.692  1.00 39.94           O  
ATOM    944  OE2 GLU A 109      20.122  21.330 -16.886  1.00 41.98           O  
ATOM    945  N   GLN A 110      25.061  19.361 -17.091  1.00 15.90           N  
ATOM    946  CA  GLN A 110      25.556  18.758 -15.851  1.00 16.62           C  
ATOM    947  C   GLN A 110      26.144  19.803 -14.911  1.00 16.01           C  
ATOM    948  O   GLN A 110      25.923  19.816 -13.693  1.00 17.58           O  
ATOM    949  CB  GLN A 110      26.579  17.653 -16.164  1.00 16.10           C  
ATOM    950  CG  GLN A 110      27.126  17.008 -14.880  1.00 16.43           C  
ATOM    951  CD  GLN A 110      26.029  16.259 -14.129  1.00 18.58           C  
ATOM    952  OE1 GLN A 110      25.637  15.143 -14.514  1.00 21.08           O  
ATOM    953  NE2 GLN A 110      25.492  16.822 -13.046  1.00 19.70           N  
ATOM    954  N   VAL A 111      26.916  20.754 -15.456  1.00 15.85           N  
ATOM    955  CA  VAL A 111      27.472  21.784 -14.551  1.00 15.74           C  
ATOM    956  C   VAL A 111      26.335  22.640 -14.004  1.00 18.02           C  
ATOM    957  O   VAL A 111      26.382  23.037 -12.847  1.00 21.34           O  
ATOM    958  CB  VAL A 111      28.634  22.544 -15.208  1.00 15.53           C  
ATOM    959  CG1 VAL A 111      29.027  23.814 -14.452  1.00 16.88           C  
ATOM    960  CG2 VAL A 111      29.902  21.682 -15.304  1.00 16.93           C  
ATOM    961  N   LYS A 112      25.313  22.944 -14.801  1.00 18.34           N  
ATOM    962  CA  LYS A 112      24.234  23.819 -14.323  1.00 17.90           C  
ATOM    963  C   LYS A 112      23.540  23.158 -13.159  1.00 19.46           C  
ATOM    964  O   LYS A 112      23.137  23.807 -12.172  1.00 20.86           O  
ATOM    965  CB  LYS A 112      23.315  24.130 -15.503  1.00 18.33           C  
ATOM    966  CG  LYS A 112      23.774  25.327 -16.300  1.00 31.48           C  
ATOM    967  CD  LYS A 112      24.116  25.158 -17.739  1.00 41.99           C  
ATOM    968  CE  LYS A 112      24.117  26.474 -18.518  1.00 43.76           C  
ATOM    969  NZ  LYS A 112      22.840  26.664 -19.268  1.00 51.37           N  
ATOM    970  N   GLN A 113      23.396  21.832 -13.272  1.00 17.37           N  
ATOM    971  CA  GLN A 113      22.759  21.080 -12.195  1.00 20.86           C  
ATOM    972  C   GLN A 113      23.622  21.055 -10.947  1.00 20.07           C  
ATOM    973  O   GLN A 113      23.157  21.211  -9.805  1.00 19.22           O  
ATOM    974  CB  GLN A 113      22.490  19.632 -12.613  1.00 20.66           C  
ATOM    975  CG  GLN A 113      21.299  19.558 -13.583  1.00 23.98           C  
ATOM    976  CD  GLN A 113      20.031  20.048 -12.901  1.00 26.98           C  
ATOM    977  OE1 GLN A 113      19.448  21.060 -13.297  1.00 49.84           O  
ATOM    978  NE2 GLN A 113      19.576  19.370 -11.856  1.00 36.44           N  
ATOM    979  N   TRP A 114      24.935  20.857 -11.140  1.00 21.56           N  
ATOM    980  CA  TRP A 114      25.808  20.886  -9.975  1.00 20.91           C  
ATOM    981  C   TRP A 114      25.824  22.296  -9.342  1.00 22.50           C  
ATOM    982  O   TRP A 114      26.068  22.389  -8.118  1.00 28.35           O  
ATOM    983  CB  TRP A 114      27.195  20.489 -10.392  1.00 18.05           C  
ATOM    984  CG  TRP A 114      27.448  19.026 -10.603  1.00 15.29           C  
ATOM    985  CD1 TRP A 114      26.732  17.997 -10.061  1.00 17.37           C  
ATOM    986  CD2 TRP A 114      28.477  18.420 -11.379  1.00 12.96           C  
ATOM    987  NE1 TRP A 114      27.253  16.792 -10.465  1.00 15.92           N  
ATOM    988  CE2 TRP A 114      28.332  17.019 -11.277  1.00 12.62           C  
ATOM    989  CE3 TRP A 114      29.524  18.930 -12.157  1.00 12.13           C  
ATOM    990  CZ2 TRP A 114      29.193  16.148 -11.936  1.00 13.20           C  
ATOM    991  CZ3 TRP A 114      30.374  18.036 -12.805  1.00 11.08           C  
ATOM    992  CH2 TRP A 114      30.209  16.681 -12.680  1.00 10.56           C  
ATOM    993  N   ARG A 115      25.627  23.349 -10.106  1.00 22.86           N  
ATOM    994  CA  ARG A 115      25.637  24.719  -9.542  1.00 19.16           C  
ATOM    995  C   ARG A 115      24.358  25.031  -8.801  1.00 19.32           C  
ATOM    996  O   ARG A 115      24.326  25.702  -7.774  1.00 20.57           O  
ATOM    997  CB  ARG A 115      25.848  25.774 -10.660  1.00 19.37           C  
ATOM    998  CG  ARG A 115      27.255  25.917 -11.217  1.00 20.52           C  
ATOM    999  CD  ARG A 115      27.408  26.932 -12.319  1.00 18.52           C  
ATOM   1000  NE  ARG A 115      27.058  28.345 -12.050  1.00 24.71           N  
ATOM   1001  CZ  ARG A 115      26.999  29.325 -12.977  1.00 23.40           C  
ATOM   1002  NH1 ARG A 115      27.268  29.189 -14.291  1.00 20.84           N  
ATOM   1003  NH2 ARG A 115      26.654  30.590 -12.665  1.00 23.75           N  
ATOM   1004  N   ARG A 116      23.224  24.628  -9.340  1.00 19.39           N  
ATOM   1005  CA  ARG A 116      21.926  25.178  -9.014  1.00 18.50           C  
ATOM   1006  C   ARG A 116      20.814  24.191  -8.748  1.00 20.31           C  
ATOM   1007  O   ARG A 116      19.755  24.650  -8.293  1.00 23.84           O  
ATOM   1008  CB  ARG A 116      21.431  25.987 -10.229  1.00 16.08           C  
ATOM   1009  CG  ARG A 116      22.033  27.352 -10.413  1.00 20.30           C  
ATOM   1010  CD  ARG A 116      21.118  28.137  -9.404  1.00 27.51           C  
ATOM   1011  NE  ARG A 116      21.973  29.140  -8.893  1.00 22.38           N  
ATOM   1012  CZ  ARG A 116      21.730  30.406  -8.665  1.00 14.08           C  
ATOM   1013  NH1 ARG A 116      20.548  30.961  -8.889  1.00 14.62           N  
ATOM   1014  NH2 ARG A 116      22.716  31.107  -8.177  1.00 13.96           N  
ATOM   1015  N   GLY A 117      20.951  22.916  -9.071  1.00 20.78           N  
ATOM   1016  CA  GLY A 117      19.827  22.018  -8.849  1.00 20.21           C  
ATOM   1017  C   GLY A 117      19.443  21.963  -7.383  1.00 17.71           C  
ATOM   1018  O   GLY A 117      20.296  21.764  -6.520  1.00 17.89           O  
ATOM   1019  N   PHE A 118      18.187  22.120  -6.997  1.00 13.59           N  
ATOM   1020  CA  PHE A 118      17.767  22.458  -5.651  1.00 12.00           C  
ATOM   1021  C   PHE A 118      18.308  21.470  -4.610  1.00 10.78           C  
ATOM   1022  O   PHE A 118      18.914  21.856  -3.608  1.00 10.04           O  
ATOM   1023  CB  PHE A 118      16.230  22.554  -5.532  1.00 13.95           C  
ATOM   1024  CG  PHE A 118      15.762  22.942  -4.116  1.00 12.32           C  
ATOM   1025  CD1 PHE A 118      15.905  24.270  -3.691  1.00 11.64           C  
ATOM   1026  CD2 PHE A 118      15.243  22.020  -3.242  1.00 11.96           C  
ATOM   1027  CE1 PHE A 118      15.511  24.626  -2.417  1.00 12.24           C  
ATOM   1028  CE2 PHE A 118      14.840  22.377  -1.968  1.00 12.10           C  
ATOM   1029  CZ  PHE A 118      15.017  23.694  -1.521  1.00 11.19           C  
ATOM   1030  N   ALA A 119      18.045  20.173  -4.852  1.00 11.59           N  
ATOM   1031  CA  ALA A 119      18.475  19.101  -3.955  1.00 12.46           C  
ATOM   1032  C   ALA A 119      19.648  18.303  -4.543  1.00 11.86           C  
ATOM   1033  O   ALA A 119      20.012  17.287  -3.946  1.00 15.15           O  
ATOM   1034  CB  ALA A 119      17.338  18.155  -3.546  1.00 14.25           C  
ATOM   1035  N   VAL A 120      20.227  18.745  -5.649  1.00 14.55           N  
ATOM   1036  CA  VAL A 120      21.355  18.101  -6.309  1.00 14.01           C  
ATOM   1037  C   VAL A 120      22.645  18.411  -5.535  1.00 13.88           C  
ATOM   1038  O   VAL A 120      22.930  19.547  -5.194  1.00 14.28           O  
ATOM   1039  CB  VAL A 120      21.475  18.556  -7.762  1.00 17.45           C  
ATOM   1040  CG1 VAL A 120      22.732  17.990  -8.421  1.00 20.56           C  
ATOM   1041  CG2 VAL A 120      20.220  18.144  -8.541  1.00 22.78           C  
ATOM   1042  N   THR A 121      23.424  17.363  -5.264  1.00 14.10           N  
ATOM   1043  CA  THR A 121      24.711  17.552  -4.635  1.00 12.67           C  
ATOM   1044  C   THR A 121      25.851  17.416  -5.637  1.00 11.53           C  
ATOM   1045  O   THR A 121      25.886  16.491  -6.432  1.00 12.16           O  
ATOM   1046  CB  THR A 121      24.939  16.541  -3.493  1.00 12.99           C  
ATOM   1047  OG1 THR A 121      24.635  15.202  -3.964  1.00 15.81           O  
ATOM   1048  CG2 THR A 121      24.060  16.893  -2.303  1.00 14.64           C  
ATOM   1049  N   PRO A 122      26.841  18.309  -5.605  1.00 10.22           N  
ATOM   1050  CA  PRO A 122      28.074  18.068  -6.374  1.00  9.71           C  
ATOM   1051  C   PRO A 122      28.709  16.758  -5.992  1.00  9.61           C  
ATOM   1052  O   PRO A 122      28.434  16.247  -4.898  1.00 10.62           O  
ATOM   1053  CB  PRO A 122      28.931  19.278  -5.966  1.00 11.38           C  
ATOM   1054  CG  PRO A 122      27.936  20.356  -5.649  1.00 11.13           C  
ATOM   1055  CD  PRO A 122      26.853  19.616  -4.886  1.00 10.82           C  
ATOM   1056  N   PRO A 123      29.544  16.174  -6.835  1.00 10.10           N  
ATOM   1057  CA  PRO A 123      30.266  14.935  -6.507  1.00 10.28           C  
ATOM   1058  C   PRO A 123      30.994  15.085  -5.168  1.00 10.38           C  
ATOM   1059  O   PRO A 123      31.571  16.148  -4.861  1.00 10.48           O  
ATOM   1060  CB  PRO A 123      31.210  14.721  -7.695  1.00 11.77           C  
ATOM   1061  CG  PRO A 123      30.490  15.470  -8.815  1.00 14.99           C  
ATOM   1062  CD  PRO A 123      29.896  16.694  -8.174  1.00 12.13           C  
ATOM   1063  N   GLU A 124      30.997  14.033  -4.361  1.00  9.57           N  
ATOM   1064  CA  GLU A 124      31.467  14.054  -2.980  1.00 10.33           C  
ATOM   1065  C   GLU A 124      32.974  13.922  -2.844  1.00  9.07           C  
ATOM   1066  O   GLU A 124      33.647  13.178  -3.608  1.00 11.09           O  
ATOM   1067  CB  GLU A 124      30.868  12.897  -2.179  1.00 14.93           C  
ATOM   1068  CG  GLU A 124      29.434  12.740  -1.870  1.00 16.96           C  
ATOM   1069  CD  GLU A 124      29.063  11.647  -0.880  1.00 22.87           C  
ATOM   1070  OE1 GLU A 124      29.754  10.630  -0.671  1.00 21.68           O  
ATOM   1071  OE2 GLU A 124      27.985  11.819  -0.255  1.00 29.04           O  
ATOM   1072  N   LEU A 125      33.560  14.591  -1.859  1.00  8.46           N  
ATOM   1073  CA  LEU A 125      34.856  14.300  -1.300  1.00  8.29           C  
ATOM   1074  C   LEU A 125      34.829  12.969  -0.537  1.00  9.17           C  
ATOM   1075  O   LEU A 125      33.761  12.509  -0.114  1.00 10.05           O  
ATOM   1076  CB  LEU A 125      35.284  15.369  -0.275  1.00  8.23           C  
ATOM   1077  CG  LEU A 125      35.437  16.818  -0.750  1.00  8.57           C  
ATOM   1078  CD1 LEU A 125      35.896  17.677   0.430  1.00  8.99           C  
ATOM   1079  CD2 LEU A 125      36.431  16.921  -1.895  1.00  8.99           C  
ATOM   1080  N   THR A 126      36.004  12.412  -0.304  1.00  8.98           N  
ATOM   1081  CA  THR A 126      36.250  11.436   0.739  1.00  8.98           C  
ATOM   1082  C   THR A 126      36.997  12.124   1.900  1.00  9.05           C  
ATOM   1083  O   THR A 126      37.591  13.209   1.737  1.00 10.40           O  
ATOM   1084  CB  THR A 126      36.990  10.154   0.297  0.81  9.78           C  
ATOM   1086  OG1 THR A 126      38.257  10.615  -0.204  0.81 10.04           O  
ATOM   1088  CG2 THR A 126      36.217   9.422  -0.778  0.81 12.69           C  
ATOM   1090  N   LYS A 127      36.982  11.530   3.102  1.00  9.68           N  
ATOM   1091  CA  LYS A 127      37.534  12.144   4.304  1.00  8.96           C  
ATOM   1092  C   LYS A 127      39.052  12.294   4.269  1.00  9.07           C  
ATOM   1093  O   LYS A 127      39.616  13.120   5.022  1.00 10.77           O  
ATOM   1094  CB  LYS A 127      37.049  11.345   5.500  1.00 10.02           C  
ATOM   1095  CG  LYS A 127      35.563  11.437   5.768  1.00 11.45           C  
ATOM   1096  CD  LYS A 127      35.089  10.858   7.085  1.00 15.03           C  
ATOM   1097  CE  LYS A 127      35.219   9.352   6.997  1.00 17.24           C  
ATOM   1098  NZ  LYS A 127      34.635   8.729   8.241  1.00 18.85           N  
ATOM   1099  N   ASP A 128      39.745  11.522   3.429  1.00  8.78           N  
ATOM   1100  CA  ASP A 128      41.186  11.634   3.286  1.00  8.79           C  
ATOM   1101  C   ASP A 128      41.601  12.806   2.390  1.00  9.06           C  
ATOM   1102  O   ASP A 128      42.756  13.244   2.422  1.00 10.28           O  
ATOM   1103  CB  ASP A 128      41.838  10.349   2.710  1.00 10.72           C  
ATOM   1104  CG  ASP A 128      41.349  10.141   1.303  1.00 10.26           C  
ATOM   1105  OD1 ASP A 128      40.178   9.677   1.197  1.00 11.45           O  
ATOM   1106  OD2 ASP A 128      42.115  10.429   0.340  1.00 11.07           O  
ATOM   1107  N   ASP A 129      40.694  13.352   1.601  1.00  8.34           N  
ATOM   1108  CA  ASP A 129      41.009  14.457   0.685  1.00  8.23           C  
ATOM   1109  C   ASP A 129      41.574  15.617   1.490  1.00  7.93           C  
ATOM   1110  O   ASP A 129      41.071  15.938   2.559  1.00  8.64           O  
ATOM   1111  CB  ASP A 129      39.789  14.851  -0.112  1.00  8.43           C  
ATOM   1112  CG  ASP A 129      40.028  15.716  -1.324  1.00  8.24           C  
ATOM   1113  OD1 ASP A 129      40.558  16.835  -1.175  1.00  9.14           O  
ATOM   1114  OD2 ASP A 129      39.629  15.277  -2.453  1.00  8.66           O  
ATOM   1115  N   GLU A 130      42.605  16.304   0.969  1.00  7.71           N  
ATOM   1116  CA  GLU A 130      43.159  17.461   1.579  1.00  9.41           C  
ATOM   1117  C   GLU A 130      42.092  18.532   1.883  1.00  9.53           C  
ATOM   1118  O   GLU A 130      42.275  19.319   2.813  1.00  9.68           O  
ATOM   1119  CB  GLU A 130      44.262  18.067   0.714  1.00 19.04           C  
ATOM   1120  CG  GLU A 130      45.577  17.353   0.541  1.00 32.68           C  
ATOM   1121  CD  GLU A 130      46.591  18.161  -0.262  1.00 38.65           C  
ATOM   1122  OE1 GLU A 130      46.242  19.291  -0.680  1.00 41.56           O  
ATOM   1123  OE2 GLU A 130      47.700  17.614  -0.429  1.00 54.52           O  
ATOM   1124  N   ARG A 131      41.023  18.545   1.072  1.00  8.31           N  
ATOM   1125  CA  ARG A 131      39.976  19.558   1.184  1.00  8.05           C  
ATOM   1126  C   ARG A 131      38.915  19.226   2.219  1.00  7.47           C  
ATOM   1127  O   ARG A 131      38.025  20.033   2.501  1.00  8.69           O  
ATOM   1128  CB  ARG A 131      39.326  19.754  -0.199  1.00  8.67           C  
ATOM   1129  CG  ARG A 131      40.267  20.207  -1.289  1.00  8.71           C  
ATOM   1130  CD  ARG A 131      39.660  20.199  -2.665  1.00  9.31           C  
ATOM   1131  NE  ARG A 131      39.454  18.816  -3.111  1.00  8.41           N  
ATOM   1132  CZ  ARG A 131      38.898  18.427  -4.228  1.00  8.73           C  
ATOM   1133  NH1 ARG A 131      38.454  19.348  -5.065  1.00  9.75           N  
ATOM   1134  NH2 ARG A 131      38.808  17.136  -4.515  1.00  9.07           N  
ATOM   1135  N   TYR A 132      38.936  18.033   2.816  1.00  7.48           N  
ATOM   1136  CA  TYR A 132      37.882  17.634   3.771  1.00  7.47           C  
ATOM   1137  C   TYR A 132      37.833  18.626   4.937  1.00  6.50           C  
ATOM   1138  O   TYR A 132      38.897  18.841   5.568  1.00  8.05           O  
ATOM   1139  CB  TYR A 132      38.093  16.245   4.308  1.00  8.19           C  
ATOM   1140  CG  TYR A 132      37.069  15.767   5.293  1.00  8.41           C  
ATOM   1141  CD1 TYR A 132      35.709  15.788   5.023  1.00  9.09           C  
ATOM   1142  CD2 TYR A 132      37.447  15.250   6.530  1.00  8.92           C  
ATOM   1143  CE1 TYR A 132      34.791  15.344   5.930  1.00  9.87           C  
ATOM   1144  CE2 TYR A 132      36.509  14.777   7.431  1.00 10.31           C  
ATOM   1145  CZ  TYR A 132      35.173  14.827   7.147  1.00  9.98           C  
ATOM   1146  OH  TYR A 132      34.216  14.329   8.023  1.00 12.67           O  
ATOM   1147  N   PRO A 133      36.694  19.231   5.279  1.00  6.96           N  
ATOM   1148  CA  PRO A 133      36.667  20.200   6.376  1.00  6.99           C  
ATOM   1149  C   PRO A 133      37.174  19.659   7.727  1.00  7.57           C  
ATOM   1150  O   PRO A 133      37.638  20.492   8.542  1.00  8.53           O  
ATOM   1151  CB  PRO A 133      35.193  20.649   6.442  1.00  8.08           C  
ATOM   1152  CG  PRO A 133      34.745  20.538   5.023  1.00  8.16           C  
ATOM   1153  CD  PRO A 133      35.408  19.255   4.565  1.00  7.62           C  
ATOM   1154  N   GLY A 134      37.126  18.377   7.981  1.00  7.80           N  
ATOM   1155  CA  GLY A 134      37.600  17.868   9.252  1.00  8.65           C  
ATOM   1156  C   GLY A 134      39.061  18.144   9.554  1.00  8.72           C  
ATOM   1157  O   GLY A 134      39.412  18.147  10.731  1.00 10.14           O  
ATOM   1158  N   HIS A 135      39.890  18.357   8.550  1.00  9.29           N  
ATOM   1159  CA  HIS A 135      41.289  18.658   8.793  1.00  9.05           C  
ATOM   1160  C   HIS A 135      41.549  20.073   9.308  1.00  8.53           C  
ATOM   1161  O   HIS A 135      42.633  20.387   9.793  1.00 11.47           O  
ATOM   1162  CB  HIS A 135      42.129  18.483   7.512  1.00 10.80           C  
ATOM   1163  CG  HIS A 135      41.964  17.165   6.847  1.00 10.30           C  
ATOM   1164  ND1 HIS A 135      42.136  15.970   7.467  1.00 14.18           N  
ATOM   1165  CD2 HIS A 135      41.694  16.900   5.556  1.00 11.56           C  
ATOM   1166  CE1 HIS A 135      41.948  15.003   6.623  1.00 16.26           C  
ATOM   1167  NE2 HIS A 135      41.665  15.518   5.447  1.00 13.83           N  
ATOM   1168  N   ASP A 136      40.596  20.970   9.170  1.00  8.97           N  
ATOM   1169  CA  ASP A 136      40.792  22.415   9.388  1.00  8.29           C  
ATOM   1170  C   ASP A 136      40.429  22.785  10.792  1.00  8.23           C  
ATOM   1171  O   ASP A 136      39.324  22.455  11.281  1.00  8.61           O  
ATOM   1172  CB  ASP A 136      40.091  23.366   8.410  0.53  8.80           C  
ATOM   1174  CG  ASP A 136      40.364  24.843   8.613  0.53 11.59           C  
ATOM   1176  OD1 ASP A 136      40.091  25.341   9.740  0.53 11.82           O  
ATOM   1178  OD2 ASP A 136      40.852  25.574   7.712  0.53 10.25           O  
ATOM   1180  N   PRO A 137      41.299  23.517  11.492  1.00 12.73           N  
ATOM   1181  CA  PRO A 137      41.005  23.897  12.877  1.00 16.91           C  
ATOM   1182  C   PRO A 137      39.770  24.718  13.064  1.00 17.92           C  
ATOM   1183  O   PRO A 137      39.232  24.776  14.166  1.00 20.90           O  
ATOM   1184  CB  PRO A 137      42.263  24.702  13.272  1.00 22.91           C  
ATOM   1185  CG  PRO A 137      42.835  25.200  11.983  1.00 23.66           C  
ATOM   1186  CD  PRO A 137      42.599  24.050  11.013  1.00 16.65           C  
ATOM   1187  N   ARG A 138      39.226  25.388  12.075  1.00 15.15           N  
ATOM   1188  CA  ARG A 138      38.056  26.089  12.623  1.00 13.32           C  
ATOM   1189  C   ARG A 138      36.804  25.257  12.676  1.00 12.35           C  
ATOM   1190  O   ARG A 138      35.772  25.774  13.119  1.00 12.48           O  
ATOM   1191  CB  ARG A 138      37.810  27.247  11.711  1.00 12.39           C  
ATOM   1192  CG  ARG A 138      37.221  26.793  10.431  1.00  9.22           C  
ATOM   1193  CD  ARG A 138      37.264  27.856   9.330  1.00 13.09           C  
ATOM   1194  NE  ARG A 138      38.622  27.854   8.834  1.00 15.43           N  
ATOM   1195  CZ  ARG A 138      39.204  28.674   7.950  1.00  9.82           C  
ATOM   1196  NH1 ARG A 138      38.505  29.640   7.427  1.00 14.02           N  
ATOM   1197  NH2 ARG A 138      40.496  28.502   7.667  1.00 13.01           N  
ATOM   1198  N   TYR A 139      36.845  23.996  12.263  1.00  8.21           N  
ATOM   1199  CA  TYR A 139      35.733  23.072  12.406  1.00  8.38           C  
ATOM   1200  C   TYR A 139      35.986  22.019  13.475  1.00  9.69           C  
ATOM   1201  O   TYR A 139      35.301  20.972  13.479  1.00 10.99           O  
ATOM   1202  CB  TYR A 139      35.365  22.398  11.030  1.00  7.70           C  
ATOM   1203  CG  TYR A 139      35.236  23.455   9.971  1.00  6.65           C  
ATOM   1204  CD1 TYR A 139      34.227  24.420  10.024  1.00  7.16           C  
ATOM   1205  CD2 TYR A 139      36.109  23.532   8.875  1.00  6.66           C  
ATOM   1206  CE1 TYR A 139      34.111  25.403   9.062  1.00  6.50           C  
ATOM   1207  CE2 TYR A 139      35.989  24.517   7.908  1.00  6.52           C  
ATOM   1208  CZ  TYR A 139      34.994  25.452   7.991  1.00  6.33           C  
ATOM   1209  OH  TYR A 139      34.838  26.475   7.060  1.00  6.69           O  
ATOM   1210  N   ALA A 140      36.913  22.297  14.409  1.00 11.86           N  
ATOM   1211  CA  ALA A 140      37.305  21.319  15.409  1.00 15.15           C  
ATOM   1212  C   ALA A 140      36.102  20.860  16.252  1.00 15.23           C  
ATOM   1213  O   ALA A 140      36.131  19.736  16.793  1.00 19.93           O  
ATOM   1214  CB  ALA A 140      38.365  21.895  16.347  1.00 19.81           C  
ATOM   1215  N   LYS A 141      35.069  21.697  16.421  1.00 14.38           N  
ATOM   1216  CA  LYS A 141      33.927  21.350  17.283  1.00 16.69           C  
ATOM   1217  C   LYS A 141      32.819  20.646  16.518  1.00 18.02           C  
ATOM   1218  O   LYS A 141      31.833  20.162  17.104  1.00 20.54           O  
ATOM   1219  CB  LYS A 141      33.442  22.577  18.075  1.00 19.97           C  
ATOM   1220  CG  LYS A 141      34.470  23.141  19.048  1.00 22.73           C  
ATOM   1221  CD  LYS A 141      33.853  24.385  19.692  1.00 28.65           C  
ATOM   1222  CE  LYS A 141      34.918  25.136  20.453  1.00 37.98           C  
ATOM   1223  NZ  LYS A 141      34.415  26.446  20.965  1.00 49.16           N  
ATOM   1224  N   LEU A 142      32.941  20.475  15.190  1.00 13.68           N  
ATOM   1225  CA  LEU A 142      31.884  19.837  14.413  1.00 13.65           C  
ATOM   1226  C   LEU A 142      31.951  18.330  14.495  1.00 15.92           C  
ATOM   1227  O   LEU A 142      33.055  17.767  14.562  1.00 18.67           O  
ATOM   1228  CB  LEU A 142      31.936  20.267  12.925  1.00 11.78           C  
ATOM   1229  CG  LEU A 142      31.231  21.572  12.551  1.00 12.03           C  
ATOM   1230  CD1 LEU A 142      31.878  22.761  13.242  1.00 10.90           C  
ATOM   1231  CD2 LEU A 142      31.225  21.770  11.028  1.00 11.32           C  
ATOM   1232  N   SER A 143      30.779  17.661  14.448  1.00 18.13           N  
ATOM   1233  CA  SER A 143      30.692  16.215  14.289  1.00 20.87           C  
ATOM   1234  C   SER A 143      30.864  15.719  12.831  1.00 20.51           C  
ATOM   1235  O   SER A 143      30.786  16.530  11.929  1.00 15.05           O  
ATOM   1236  CB  SER A 143      29.323  15.716  14.797  1.00 24.89           C  
ATOM   1237  OG  SER A 143      28.339  16.194  13.872  1.00 24.63           O  
ATOM   1238  N   GLU A 144      31.051  14.386  12.580  1.00 19.78           N  
ATOM   1239  CA  GLU A 144      31.151  13.843  11.230  1.00 21.62           C  
ATOM   1240  C   GLU A 144      29.928  14.232  10.421  1.00 18.91           C  
ATOM   1241  O   GLU A 144      30.044  14.593   9.241  1.00 19.94           O  
ATOM   1242  CB  GLU A 144      31.260  12.309  11.200  1.00 19.35           C  
ATOM   1243  CG  GLU A 144      31.294  11.756   9.784  1.00 19.25           C  
ATOM   1244  CD  GLU A 144      31.599  10.289   9.640  1.00 18.65           C  
ATOM   1245  OE1 GLU A 144      31.674   9.577  10.673  1.00 15.96           O  
ATOM   1246  OE2 GLU A 144      31.797   9.751   8.500  1.00 18.69           O  
ATOM   1247  N   LYS A 145      28.764  14.113  11.093  1.00 22.64           N  
ATOM   1248  CA  LYS A 145      27.554  14.459  10.372  1.00 26.91           C  
ATOM   1249  C   LYS A 145      27.495  15.953  10.049  1.00 21.89           C  
ATOM   1250  O   LYS A 145      26.853  16.264   9.037  1.00 28.68           O  
ATOM   1251  CB  LYS A 145      26.230  14.078  11.067  1.00 35.58           C  
ATOM   1252  CG  LYS A 145      24.992  14.324  10.237  1.00 46.15           C  
ATOM   1253  CD  LYS A 145      24.915  13.991   8.766  1.00 53.13           C  
ATOM   1254  CE  LYS A 145      24.201  12.681   8.469  1.00 59.90           C  
ATOM   1255  NZ  LYS A 145      24.032  12.469   6.999  1.00 71.88           N  
ATOM   1256  N   GLU A 146      28.100  16.822  10.856  1.00 17.62           N  
ATOM   1257  CA  GLU A 146      28.098  18.256  10.476  1.00 15.45           C  
ATOM   1258  C   GLU A 146      29.114  18.553   9.397  1.00 12.23           C  
ATOM   1259  O   GLU A 146      28.937  19.509   8.630  1.00 14.78           O  
ATOM   1260  CB  GLU A 146      28.325  19.081  11.731  1.00 12.78           C  
ATOM   1261  CG  GLU A 146      27.092  19.161  12.681  1.00 16.62           C  
ATOM   1262  CD  GLU A 146      27.444  19.772  14.017  1.00 16.92           C  
ATOM   1263  OE1 GLU A 146      28.528  19.536  14.609  1.00 18.64           O  
ATOM   1264  OE2 GLU A 146      26.610  20.538  14.530  1.00 23.81           O  
ATOM   1265  N   LEU A 147      30.250  17.859   9.340  1.00 10.79           N  
ATOM   1266  CA  LEU A 147      31.326  18.104   8.420  1.00  9.56           C  
ATOM   1267  C   LEU A 147      30.895  17.654   7.023  1.00 10.28           C  
ATOM   1268  O   LEU A 147      30.665  16.455   6.797  1.00 12.81           O  
ATOM   1269  CB  LEU A 147      32.588  17.314   8.830  1.00 10.38           C  
ATOM   1270  CG  LEU A 147      33.276  17.794  10.103  1.00  9.65           C  
ATOM   1271  CD1 LEU A 147      34.269  16.755  10.626  1.00 10.14           C  
ATOM   1272  CD2 LEU A 147      33.990  19.127   9.916  1.00  9.82           C  
ATOM   1273  N   PRO A 148      30.728  18.528   6.043  1.00 10.26           N  
ATOM   1274  CA  PRO A 148      30.227  18.086   4.747  1.00 10.01           C  
ATOM   1275  C   PRO A 148      31.261  17.466   3.820  1.00  8.85           C  
ATOM   1276  O   PRO A 148      32.408  17.911   3.761  1.00 10.40           O  
ATOM   1277  CB  PRO A 148      29.691  19.398   4.119  1.00 12.24           C  
ATOM   1278  CG  PRO A 148      30.603  20.435   4.722  1.00 14.26           C  
ATOM   1279  CD  PRO A 148      30.894  19.997   6.139  1.00 11.06           C  
ATOM   1280  N   LEU A 149      30.812  16.489   3.037  1.00  8.77           N  
ATOM   1281  CA  LEU A 149      31.503  15.999   1.858  1.00  8.66           C  
ATOM   1282  C   LEU A 149      31.088  16.706   0.549  1.00  8.44           C  
ATOM   1283  O   LEU A 149      31.824  16.603  -0.448  1.00  9.11           O  
ATOM   1284  CB  LEU A 149      31.268  14.482   1.711  1.00  9.65           C  
ATOM   1285  CG  LEU A 149      31.711  13.608   2.878  1.00 11.19           C  
ATOM   1286  CD1 LEU A 149      31.272  12.151   2.603  1.00 13.57           C  
ATOM   1287  CD2 LEU A 149      33.208  13.693   3.114  1.00 13.10           C  
ATOM   1288  N   THR A 150      29.928  17.365   0.620  1.00  8.26           N  
ATOM   1289  CA  THR A 150      29.230  18.051  -0.455  1.00  7.52           C  
ATOM   1290  C   THR A 150      27.958  18.669   0.141  1.00  8.14           C  
ATOM   1291  O   THR A 150      27.551  18.206   1.224  1.00  9.62           O  
ATOM   1292  CB  THR A 150      28.889  17.089  -1.583  1.00  8.62           C  
ATOM   1293  OG1 THR A 150      28.364  17.890  -2.642  1.00  9.59           O  
ATOM   1294  CG2 THR A 150      27.851  16.031  -1.205  1.00 12.94           C  
ATOM   1295  N   GLU A 151      27.348  19.630  -0.482  1.00  7.03           N  
ATOM   1296  CA  GLU A 151      26.068  20.185  -0.076  1.00  7.93           C  
ATOM   1297  C   GLU A 151      25.271  20.588  -1.317  1.00  8.35           C  
ATOM   1298  O   GLU A 151      25.804  20.962  -2.355  1.00 11.32           O  
ATOM   1299  CB  GLU A 151      26.203  21.385   0.907  1.00  8.22           C  
ATOM   1300  CG  GLU A 151      26.709  21.027   2.301  1.00  9.31           C  
ATOM   1301  CD  GLU A 151      26.797  22.273   3.186  1.00  8.11           C  
ATOM   1302  OE1 GLU A 151      27.334  23.276   2.694  1.00  7.76           O  
ATOM   1303  OE2 GLU A 151      26.323  22.218   4.369  1.00  9.89           O  
ATOM   1304  N   SER A 152      23.957  20.616  -1.141  1.00  9.93           N  
ATOM   1305  CA  SER A 152      22.990  21.193  -2.043  1.00  9.18           C  
ATOM   1306  C   SER A 152      22.419  22.465  -1.401  1.00  8.26           C  
ATOM   1307  O   SER A 152      22.602  22.708  -0.182  1.00  8.90           O  
ATOM   1308  CB  SER A 152      21.843  20.220  -2.256  1.00  9.49           C  
ATOM   1309  OG  SER A 152      21.213  19.951  -1.018  1.00 10.02           O  
ATOM   1310  N   LEU A 153      21.640  23.251  -2.145  1.00  9.01           N  
ATOM   1311  CA  LEU A 153      20.899  24.370  -1.525  1.00  8.82           C  
ATOM   1312  C   LEU A 153      19.944  23.798  -0.479  1.00  8.15           C  
ATOM   1313  O   LEU A 153      19.782  24.407   0.582  1.00  8.80           O  
ATOM   1314  CB  LEU A 153      20.126  25.188  -2.552  1.00  9.45           C  
ATOM   1315  CG  LEU A 153      19.296  26.376  -2.026  1.00  8.16           C  
ATOM   1316  CD1 LEU A 153      20.155  27.382  -1.212  1.00 10.63           C  
ATOM   1317  CD2 LEU A 153      18.572  27.074  -3.172  1.00 11.00           C  
ATOM   1318  N   ALA A 154      19.295  22.664  -0.718  1.00  9.05           N  
ATOM   1319  CA  ALA A 154      18.365  22.071   0.264  1.00  9.80           C  
ATOM   1320  C   ALA A 154      19.096  21.833   1.594  1.00  9.29           C  
ATOM   1321  O   ALA A 154      18.592  22.185   2.671  1.00  9.50           O  
ATOM   1322  CB  ALA A 154      17.754  20.791  -0.226  1.00 10.00           C  
ATOM   1323  N   LEU A 155      20.329  21.253   1.536  1.00  8.85           N  
ATOM   1324  CA  LEU A 155      21.095  21.016   2.759  1.00  9.38           C  
ATOM   1325  C   LEU A 155      21.607  22.311   3.417  1.00  9.05           C  
ATOM   1326  O   LEU A 155      21.724  22.385   4.654  1.00 10.00           O  
ATOM   1327  CB  LEU A 155      22.250  20.043   2.491  1.00 10.30           C  
ATOM   1328  CG  LEU A 155      21.845  18.604   2.202  1.00 11.68           C  
ATOM   1329  CD1 LEU A 155      22.985  17.734   1.683  1.00 12.81           C  
ATOM   1330  CD2 LEU A 155      21.228  17.915   3.460  1.00 15.76           C  
ATOM   1331  N   THR A 156      21.863  23.334   2.589  1.00  8.65           N  
ATOM   1332  CA  THR A 156      22.260  24.665   3.096  1.00  7.82           C  
ATOM   1333  C   THR A 156      21.111  25.278   3.882  1.00  7.92           C  
ATOM   1334  O   THR A 156      21.307  25.765   5.020  1.00  8.09           O  
ATOM   1335  CB  THR A 156      22.716  25.554   1.933  1.00  7.24           C  
ATOM   1336  OG1 THR A 156      23.804  24.931   1.243  1.00  9.43           O  
ATOM   1337  CG2 THR A 156      23.224  26.884   2.462  1.00  8.64           C  
ATOM   1338  N   ILE A 157      19.873  25.198   3.377  1.00  8.34           N  
ATOM   1339  CA  ILE A 157      18.684  25.637   4.105  1.00  8.25           C  
ATOM   1340  C   ILE A 157      18.593  24.952   5.449  1.00  9.00           C  
ATOM   1341  O   ILE A 157      18.259  25.562   6.474  1.00  8.65           O  
ATOM   1342  CB  ILE A 157      17.425  25.413   3.239  1.00  8.61           C  
ATOM   1343  CG1 ILE A 157      17.401  26.365   2.038  1.00  8.69           C  
ATOM   1344  CG2 ILE A 157      16.171  25.500   4.024  1.00 10.72           C  
ATOM   1345  CD1 ILE A 157      16.494  25.998   0.892  1.00  8.96           C  
ATOM   1346  N   ASP A 158      18.857  23.642   5.462  1.00  9.27           N  
ATOM   1347  CA  ASP A 158      18.718  22.844   6.681  1.00  9.29           C  
ATOM   1348  C   ASP A 158      19.668  23.292   7.783  1.00  9.88           C  
ATOM   1349  O   ASP A 158      19.373  22.995   8.938  1.00 11.99           O  
ATOM   1350  CB  ASP A 158      18.930  21.353   6.417  1.00  9.81           C  
ATOM   1351  CG  ASP A 158      17.815  20.690   5.628  1.00 12.60           C  
ATOM   1352  OD1 ASP A 158      16.704  21.250   5.591  1.00 14.75           O  
ATOM   1353  OD2 ASP A 158      18.059  19.592   5.077  1.00 18.05           O  
ATOM   1354  N   ARG A 159      20.772  23.999   7.493  1.00  9.37           N  
ATOM   1355  CA  ARG A 159      21.589  24.602   8.575  1.00  8.78           C  
ATOM   1356  C   ARG A 159      21.375  26.092   8.794  1.00  8.51           C  
ATOM   1357  O   ARG A 159      21.432  26.582   9.926  1.00  9.77           O  
ATOM   1358  CB  ARG A 159      23.078  24.285   8.416  1.00  9.91           C  
ATOM   1359  CG  ARG A 159      23.665  24.654   7.115  1.00 10.04           C  
ATOM   1360  CD  ARG A 159      25.210  24.518   7.115  1.00  8.94           C  
ATOM   1361  NE  ARG A 159      25.832  24.586   5.793  1.00  7.06           N  
ATOM   1362  CZ  ARG A 159      26.184  25.727   5.189  1.00  6.68           C  
ATOM   1363  NH1 ARG A 159      25.952  26.912   5.730  1.00  6.38           N  
ATOM   1364  NH2 ARG A 159      26.763  25.682   4.012  1.00  7.91           N  
ATOM   1365  N   VAL A 160      21.080  26.846   7.724  1.00  8.49           N  
ATOM   1366  CA  VAL A 160      20.874  28.282   7.876  1.00  7.95           C  
ATOM   1367  C   VAL A 160      19.585  28.651   8.599  1.00  8.31           C  
ATOM   1368  O   VAL A 160      19.578  29.542   9.470  1.00  9.16           O  
ATOM   1369  CB  VAL A 160      20.918  28.990   6.488  1.00  7.27           C  
ATOM   1370  CG1 VAL A 160      20.532  30.449   6.597  1.00  8.46           C  
ATOM   1371  CG2 VAL A 160      22.276  28.860   5.827  1.00  8.60           C  
ATOM   1372  N   ILE A 161      18.478  28.010   8.247  1.00  7.90           N  
ATOM   1373  CA  ILE A 161      17.187  28.393   8.809  1.00  8.66           C  
ATOM   1374  C   ILE A 161      17.158  28.082  10.306  1.00  8.37           C  
ATOM   1375  O   ILE A 161      16.626  28.967  11.072  1.00  8.90           O  
ATOM   1376  CB  ILE A 161      16.035  27.780   7.978  1.00  9.01           C  
ATOM   1377  CG1 ILE A 161      15.788  28.470   6.657  0.50 11.86           C  
ATOM   1379  CG2 ILE A 161      14.768  27.784   8.848  1.00 16.80           C  
ATOM   1380  CD1 ILE A 161      16.905  28.636   5.674  0.50 19.24           C  
ATOM   1382  N   PRO A 162      17.626  26.949  10.830  1.00  9.10           N  
ATOM   1383  CA  PRO A 162      17.668  26.812  12.313  1.00  9.46           C  
ATOM   1384  C   PRO A 162      18.487  27.889  12.995  1.00  8.39           C  
ATOM   1385  O   PRO A 162      18.126  28.341  14.065  1.00  9.09           O  
ATOM   1386  CB  PRO A 162      18.255  25.383  12.528  1.00 10.18           C  
ATOM   1387  CG  PRO A 162      17.774  24.676  11.294  1.00 10.37           C  
ATOM   1388  CD  PRO A 162      18.024  25.699  10.178  1.00 10.46           C  
ATOM   1389  N   TYR A 163      19.614  28.299  12.409  1.00  8.88           N  
ATOM   1390  CA  TYR A 163      20.445  29.366  13.004  1.00  8.01           C  
ATOM   1391  C   TYR A 163      19.704  30.693  13.051  1.00  7.77           C  
ATOM   1392  O   TYR A 163      19.722  31.442  14.041  1.00  7.71           O  
ATOM   1393  CB  TYR A 163      21.769  29.455  12.258  1.00  8.79           C  
ATOM   1394  CG  TYR A 163      22.803  30.372  12.843  1.00  7.44           C  
ATOM   1395  CD1 TYR A 163      23.258  30.231  14.151  1.00  8.22           C  
ATOM   1396  CD2 TYR A 163      23.385  31.396  12.116  1.00  8.33           C  
ATOM   1397  CE1 TYR A 163      24.199  31.048  14.716  1.00  7.31           C  
ATOM   1398  CE2 TYR A 163      24.340  32.220  12.657  1.00  8.49           C  
ATOM   1399  CZ  TYR A 163      24.763  32.068  13.973  1.00  7.42           C  
ATOM   1400  OH  TYR A 163      25.733  32.908  14.455  1.00  8.66           O  
ATOM   1401  N   TRP A 164      19.002  30.984  11.950  1.00  8.57           N  
ATOM   1402  CA  TRP A 164      18.065  32.110  11.880  1.00  8.12           C  
ATOM   1403  C   TRP A 164      17.050  32.090  13.034  1.00  8.17           C  
ATOM   1404  O   TRP A 164      16.909  33.066  13.798  1.00  8.76           O  
ATOM   1405  CB  TRP A 164      17.389  32.201  10.536  1.00  8.41           C  
ATOM   1406  CG  TRP A 164      16.241  33.164  10.425  1.00  9.20           C  
ATOM   1407  CD1 TRP A 164      14.892  32.788  10.383  1.00 10.37           C  
ATOM   1408  CD2 TRP A 164      16.285  34.581  10.316  1.00  8.33           C  
ATOM   1409  NE1 TRP A 164      14.120  33.927  10.254  1.00 10.55           N  
ATOM   1410  CE2 TRP A 164      14.948  35.016  10.217  1.00  9.90           C  
ATOM   1411  CE3 TRP A 164      17.323  35.524  10.269  1.00  8.93           C  
ATOM   1412  CZ2 TRP A 164      14.629  36.375  10.102  1.00 10.80           C  
ATOM   1413  CZ3 TRP A 164      16.986  36.860  10.162  1.00 11.00           C  
ATOM   1414  CH2 TRP A 164      15.659  37.247  10.077  1.00 11.19           C  
ATOM   1415  N   ASN A 165      16.320  30.962  13.169  1.00  8.78           N  
ATOM   1416  CA  ASN A 165      15.260  30.882  14.179  1.00  8.35           C  
ATOM   1417  C   ASN A 165      15.774  30.797  15.614  1.00  8.70           C  
ATOM   1418  O   ASN A 165      15.121  31.336  16.521  1.00 10.68           O  
ATOM   1419  CB  ASN A 165      14.350  29.685  13.849  1.00 10.30           C  
ATOM   1420  CG  ASN A 165      13.360  29.972  12.748  1.00 13.29           C  
ATOM   1421  OD1 ASN A 165      12.840  31.083  12.693  1.00 15.10           O  
ATOM   1422  ND2 ASN A 165      13.144  28.982  11.899  1.00 17.35           N  
ATOM   1423  N   GLU A 166      16.924  30.162  15.845  1.00  8.67           N  
ATOM   1424  CA  GLU A 166      17.437  29.978  17.220  1.00  8.00           C  
ATOM   1425  C   GLU A 166      18.173  31.191  17.734  1.00  7.82           C  
ATOM   1426  O   GLU A 166      18.135  31.463  18.939  1.00  9.36           O  
ATOM   1427  CB  GLU A 166      18.414  28.786  17.232  1.00  8.98           C  
ATOM   1428  CG  GLU A 166      17.801  27.437  16.949  1.00  9.33           C  
ATOM   1429  CD  GLU A 166      18.796  26.401  16.465  1.00 10.44           C  
ATOM   1430  OE1 GLU A 166      20.000  26.656  16.366  1.00 13.20           O  
ATOM   1431  OE2 GLU A 166      18.339  25.261  16.232  1.00 12.08           O  
ATOM   1432  N   THR A 167      18.839  31.908  16.839  1.00  8.15           N  
ATOM   1433  CA  THR A 167      19.869  32.901  17.216  1.00  7.55           C  
ATOM   1434  C   THR A 167      19.619  34.266  16.628  1.00  7.32           C  
ATOM   1435  O   THR A 167      19.529  35.298  17.356  1.00  8.17           O  
ATOM   1436  CB  THR A 167      21.268  32.349  16.826  1.00  7.75           C  
ATOM   1437  OG1 THR A 167      21.462  31.155  17.572  1.00  9.21           O  
ATOM   1438  CG2 THR A 167      22.364  33.380  17.053  1.00  8.71           C  
ATOM   1439  N   ILE A 168      19.512  34.414  15.315  1.00  7.08           N  
ATOM   1440  CA  ILE A 168      19.513  35.737  14.672  1.00  6.35           C  
ATOM   1441  C   ILE A 168      18.196  36.457  14.903  1.00  6.95           C  
ATOM   1442  O   ILE A 168      18.138  37.629  15.339  1.00  7.62           O  
ATOM   1443  CB  ILE A 168      19.892  35.659  13.197  1.00  6.66           C  
ATOM   1444  CG1 ILE A 168      21.243  34.973  12.976  1.00  7.32           C  
ATOM   1445  CG2 ILE A 168      19.870  37.065  12.605  1.00  7.56           C  
ATOM   1446  CD1 ILE A 168      21.670  34.806  11.508  1.00  8.51           C  
ATOM   1447  N   LEU A 169      17.075  35.801  14.554  1.00  7.19           N  
ATOM   1448  CA  LEU A 169      15.753  36.432  14.664  1.00  8.35           C  
ATOM   1449  C   LEU A 169      15.493  36.812  16.097  1.00  9.00           C  
ATOM   1450  O   LEU A 169      14.975  37.913  16.356  1.00  9.87           O  
ATOM   1451  CB  LEU A 169      14.674  35.518  14.035  1.00 10.35           C  
ATOM   1452  CG  LEU A 169      13.233  36.044  14.165  1.00 11.73           C  
ATOM   1453  CD1 LEU A 169      13.095  37.409  13.508  1.00 14.44           C  
ATOM   1454  CD2 LEU A 169      12.295  34.980  13.584  1.00 14.70           C  
ATOM   1455  N   PRO A 170      15.758  35.998  17.127  1.00  9.09           N  
ATOM   1456  CA  PRO A 170      15.529  36.471  18.506  1.00 10.12           C  
ATOM   1457  C   PRO A 170      16.298  37.740  18.851  1.00  9.84           C  
ATOM   1458  O   PRO A 170      15.827  38.591  19.618  1.00 11.69           O  
ATOM   1459  CB  PRO A 170      16.014  35.291  19.344  1.00 11.92           C  
ATOM   1460  CG  PRO A 170      15.652  34.078  18.463  1.00 11.13           C  
ATOM   1461  CD  PRO A 170      16.078  34.568  17.102  1.00  9.85           C  
ATOM   1462  N   ARG A 171      17.528  37.865  18.329  1.00  9.97           N  
ATOM   1463  CA  ARG A 171      18.275  39.102  18.605  1.00  9.69           C  
ATOM   1464  C   ARG A 171      17.565  40.295  17.989  1.00  9.21           C  
ATOM   1465  O   ARG A 171      17.444  41.339  18.602  1.00 11.17           O  
ATOM   1466  CB  ARG A 171      19.705  38.988  18.114  1.00 10.29           C  
ATOM   1467  CG  ARG A 171      20.476  40.246  18.503  1.00 10.59           C  
ATOM   1468  CD  ARG A 171      21.959  40.093  18.164  1.00 10.56           C  
ATOM   1469  NE  ARG A 171      22.680  39.106  18.935  1.00  9.10           N  
ATOM   1470  CZ  ARG A 171      23.128  39.202  20.199  1.00  9.60           C  
ATOM   1471  NH1 ARG A 171      22.984  40.260  20.935  1.00 11.41           N  
ATOM   1472  NH2 ARG A 171      23.782  38.177  20.755  1.00 10.25           N  
ATOM   1473  N   MET A 172      17.092  40.140  16.743  1.00  8.95           N  
ATOM   1474  CA  MET A 172      16.317  41.190  16.127  1.00  9.87           C  
ATOM   1475  C   MET A 172      15.088  41.534  16.958  1.00 11.03           C  
ATOM   1476  O   MET A 172      14.787  42.698  17.152  1.00 13.53           O  
ATOM   1477  CB  MET A 172      15.882  40.822  14.724  1.00 10.72           C  
ATOM   1478  CG  MET A 172      17.039  40.560  13.807  1.00 10.78           C  
ATOM   1479  SD  MET A 172      16.517  39.763  12.285  1.00 12.60           S  
ATOM   1480  CE  MET A 172      15.204  40.990  11.810  1.00 10.04           C  
ATOM   1481  N   LYS A 173      14.410  40.548  17.477  1.00 11.54           N  
ATOM   1482  CA  LYS A 173      13.167  40.780  18.210  1.00 15.13           C  
ATOM   1483  C   LYS A 173      13.425  41.527  19.517  1.00 17.73           C  
ATOM   1484  O   LYS A 173      12.515  42.221  20.003  1.00 19.29           O  
ATOM   1485  CB  LYS A 173      12.368  39.502  18.438  1.00 14.25           C  
ATOM   1486  CG  LYS A 173      11.697  38.942  17.170  1.00 14.41           C  
ATOM   1487  CD  LYS A 173      10.968  37.656  17.373  1.00 18.87           C  
ATOM   1488  CE  LYS A 173      10.104  37.257  16.195  1.00 19.08           C  
ATOM   1489  NZ  LYS A 173       9.562  35.892  16.439  1.00 23.78           N  
ATOM   1490  N   SER A 174      14.638  41.395  20.069  1.00 15.71           N  
ATOM   1491  CA  SER A 174      15.046  42.119  21.274  1.00 17.40           C  
ATOM   1492  C   SER A 174      15.341  43.604  21.029  1.00 18.31           C  
ATOM   1493  O   SER A 174      15.554  44.325  22.005  1.00 21.91           O  
ATOM   1494  CB  SER A 174      16.267  41.456  21.905  1.00 19.35           C  
ATOM   1495  OG  SER A 174      17.484  41.780  21.250  1.00 19.57           O  
ATOM   1496  N   GLY A 175      15.269  44.077  19.800  1.00 17.94           N  
ATOM   1497  CA  GLY A 175      15.345  45.472  19.375  1.00 17.27           C  
ATOM   1498  C   GLY A 175      16.677  45.832  18.784  1.00 15.11           C  
ATOM   1499  O   GLY A 175      17.021  47.003  18.580  1.00 24.26           O  
ATOM   1500  N   GLU A 176      17.550  44.900  18.482  1.00 12.60           N  
ATOM   1501  CA  GLU A 176      18.858  45.154  17.903  1.00 12.64           C  
ATOM   1502  C   GLU A 176      18.849  45.170  16.381  1.00 12.09           C  
ATOM   1503  O   GLU A 176      18.154  44.357  15.735  1.00 15.42           O  
ATOM   1504  CB  GLU A 176      19.899  44.122  18.395  1.00 11.79           C  
ATOM   1505  CG  GLU A 176      20.016  44.204  19.923  1.00 15.41           C  
ATOM   1506  CD  GLU A 176      21.133  43.369  20.486  1.00 15.51           C  
ATOM   1507  OE1 GLU A 176      22.072  43.047  19.756  1.00 16.70           O  
ATOM   1508  OE2 GLU A 176      21.073  42.974  21.659  1.00 24.73           O  
ATOM   1509  N   ARG A 177      19.588  46.117  15.816  1.00  9.33           N  
ATOM   1510  CA  ARG A 177      19.727  46.286  14.364  1.00  8.19           C  
ATOM   1511  C   ARG A 177      20.839  45.365  13.889  1.00  6.71           C  
ATOM   1512  O   ARG A 177      21.990  45.582  14.264  1.00  7.23           O  
ATOM   1513  CB  ARG A 177      20.007  47.730  14.019  1.00  8.87           C  
ATOM   1514  CG  ARG A 177      18.911  48.730  14.325  1.00 10.70           C  
ATOM   1515  CD  ARG A 177      19.421  50.176  14.251  1.00 12.65           C  
ATOM   1516  NE  ARG A 177      20.349  50.418  15.359  1.00 13.36           N  
ATOM   1517  CZ  ARG A 177      20.951  51.579  15.598  1.00 16.42           C  
ATOM   1518  NH1 ARG A 177      20.716  52.620  14.812  1.00 21.27           N  
ATOM   1519  NH2 ARG A 177      21.751  51.653  16.643  1.00 20.34           N  
ATOM   1520  N   VAL A 178      20.534  44.360  13.088  1.00  6.69           N  
ATOM   1521  CA  VAL A 178      21.457  43.318  12.632  1.00  6.01           C  
ATOM   1522  C   VAL A 178      21.871  43.544  11.171  1.00  5.79           C  
ATOM   1523  O   VAL A 178      21.057  43.957  10.316  1.00  6.41           O  
ATOM   1524  CB  VAL A 178      20.808  41.930  12.830  1.00  6.55           C  
ATOM   1525  CG1 VAL A 178      21.618  40.852  12.150  1.00  7.99           C  
ATOM   1526  CG2 VAL A 178      20.600  41.630  14.322  1.00  7.86           C  
ATOM   1527  N   ILE A 179      23.142  43.263  10.904  1.00  5.83           N  
ATOM   1528  CA  ILE A 179      23.703  43.056   9.557  1.00  6.23           C  
ATOM   1529  C   ILE A 179      24.221  41.627   9.475  1.00  5.99           C  
ATOM   1530  O   ILE A 179      24.829  41.128  10.444  1.00  6.19           O  
ATOM   1531  CB  ILE A 179      24.782  44.084   9.208  1.00  6.54           C  
ATOM   1532  CG1 ILE A 179      25.317  43.895   7.771  1.00  6.76           C  
ATOM   1533  CG2 ILE A 179      25.962  44.107  10.185  1.00  7.10           C  
ATOM   1534  CD1 ILE A 179      26.128  45.014   7.213  1.00  8.72           C  
ATOM   1535  N   ILE A 180      23.975  40.965   8.328  1.00  5.68           N  
ATOM   1536  CA  ILE A 180      24.512  39.642   8.013  1.00  5.67           C  
ATOM   1537  C   ILE A 180      25.362  39.780   6.749  1.00  5.88           C  
ATOM   1538  O   ILE A 180      24.845  40.157   5.692  1.00  6.93           O  
ATOM   1539  CB  ILE A 180      23.435  38.586   7.771  1.00  6.24           C  
ATOM   1540  CG1 ILE A 180      22.439  38.527   8.957  1.00  6.75           C  
ATOM   1541  CG2 ILE A 180      24.046  37.232   7.475  1.00  7.08           C  
ATOM   1542  CD1 ILE A 180      21.261  37.611   8.691  1.00  7.92           C  
ATOM   1543  N   ALA A 181      26.678  39.474   6.851  1.00  5.72           N  
ATOM   1544  CA  ALA A 181      27.608  39.449   5.718  1.00  5.22           C  
ATOM   1545  C   ALA A 181      27.905  37.975   5.446  1.00  5.46           C  
ATOM   1546  O   ALA A 181      28.502  37.285   6.258  1.00  6.19           O  
ATOM   1547  CB  ALA A 181      28.860  40.202   6.021  1.00  6.56           C  
ATOM   1548  N   ALA A 182      27.469  37.487   4.267  1.00  6.07           N  
ATOM   1549  CA  ALA A 182      27.575  36.022   4.038  1.00  6.85           C  
ATOM   1550  C   ALA A 182      27.772  35.705   2.554  1.00  6.18           C  
ATOM   1551  O   ALA A 182      28.586  36.405   1.889  1.00  7.10           O  
ATOM   1552  CB  ALA A 182      26.449  35.265   4.724  1.00  6.84           C  
ATOM   1553  N   HIS A 183      27.131  34.694   2.031  1.00  5.91           N  
ATOM   1554  CA  HIS A 183      27.461  34.050   0.766  1.00  5.65           C  
ATOM   1555  C   HIS A 183      26.244  33.864  -0.114  1.00  6.46           C  
ATOM   1556  O   HIS A 183      25.100  33.894   0.359  1.00  7.25           O  
ATOM   1557  CB  HIS A 183      28.111  32.672   1.025  1.00  5.79           C  
ATOM   1558  CG  HIS A 183      29.376  32.773   1.836  1.00  5.11           C  
ATOM   1559  ND1 HIS A 183      30.611  32.976   1.259  1.00  5.79           N  
ATOM   1560  CD2 HIS A 183      29.588  32.784   3.174  1.00  6.10           C  
ATOM   1561  CE1 HIS A 183      31.500  33.068   2.259  1.00  5.55           C  
ATOM   1562  NE2 HIS A 183      30.938  32.978   3.443  1.00  5.60           N  
ATOM   1563  N   GLY A 184      26.444  33.625  -1.400  1.00  8.21           N  
ATOM   1564  CA  GLY A 184      25.387  33.369  -2.330  1.00  8.87           C  
ATOM   1565  C   GLY A 184      24.329  32.366  -1.892  1.00  8.88           C  
ATOM   1566  O   GLY A 184      23.142  32.699  -1.823  1.00  9.33           O  
ATOM   1567  N   ASN A 185      24.734  31.131  -1.568  1.00  8.29           N  
ATOM   1568  CA  ASN A 185      23.718  30.135  -1.258  1.00  8.48           C  
ATOM   1569  C   ASN A 185      23.209  30.225   0.169  1.00  7.67           C  
ATOM   1570  O   ASN A 185      22.054  29.848   0.397  1.00  8.75           O  
ATOM   1571  CB  ASN A 185      24.273  28.790  -1.780  0.49 12.01           C  
ATOM   1573  CG  ASN A 185      24.594  28.879  -3.279  0.49 11.05           C  
ATOM   1575  OD1 ASN A 185      23.717  29.174  -4.103  0.49 13.55           O  
ATOM   1577  ND2 ASN A 185      25.832  28.548  -3.596  0.49 15.62           N  
ATOM   1579  N   SER A 186      23.985  30.725   1.118  1.00  7.20           N  
ATOM   1580  CA  SER A 186      23.436  30.902   2.471  1.00  6.73           C  
ATOM   1581  C   SER A 186      22.432  32.030   2.526  1.00  6.51           C  
ATOM   1582  O   SER A 186      21.413  31.939   3.217  1.00  7.46           O  
ATOM   1583  CB  SER A 186      24.544  30.974   3.502  1.00  7.54           C  
ATOM   1584  OG  SER A 186      25.501  31.976   3.234  1.00  7.10           O  
ATOM   1585  N   LEU A 187      22.669  33.113   1.763  1.00  6.87           N  
ATOM   1586  CA  LEU A 187      21.704  34.190   1.654  1.00  7.29           C  
ATOM   1587  C   LEU A 187      20.499  33.811   0.786  1.00  7.95           C  
ATOM   1588  O   LEU A 187      19.366  34.151   1.121  1.00  9.12           O  
ATOM   1589  CB  LEU A 187      22.314  35.512   1.204  1.00  7.48           C  
ATOM   1590  CG  LEU A 187      23.336  36.136   2.161  1.00  7.57           C  
ATOM   1591  CD1 LEU A 187      24.000  37.348   1.505  1.00  8.84           C  
ATOM   1592  CD2 LEU A 187      22.710  36.481   3.488  1.00  8.39           C  
ATOM   1593  N   ARG A 188      20.704  33.036  -0.285  1.00  8.01           N  
ATOM   1594  CA  ARG A 188      19.571  32.519  -1.056  1.00  9.22           C  
ATOM   1595  C   ARG A 188      18.691  31.623  -0.181  1.00  7.93           C  
ATOM   1596  O   ARG A 188      17.463  31.669  -0.292  1.00  8.96           O  
ATOM   1597  CB  ARG A 188      20.026  31.855  -2.366  1.00  9.79           C  
ATOM   1598  CG  ARG A 188      20.455  32.811  -3.450  1.00 13.88           C  
ATOM   1599  CD  ARG A 188      21.187  32.214  -4.654  1.00 16.51           C  
ATOM   1600  NE  ARG A 188      20.283  31.292  -5.344  1.00 15.80           N  
ATOM   1601  CZ  ARG A 188      20.345  29.973  -5.496  1.00 16.14           C  
ATOM   1602  NH1 ARG A 188      21.366  29.275  -4.982  1.00 20.50           N  
ATOM   1603  NH2 ARG A 188      19.379  29.318  -6.158  1.00 16.29           N  
ATOM   1604  N   ALA A 189      19.294  30.807   0.694  1.00  7.96           N  
ATOM   1605  CA  ALA A 189      18.530  29.992   1.623  1.00  8.40           C  
ATOM   1606  C   ALA A 189      17.623  30.861   2.499  1.00  8.34           C  
ATOM   1607  O   ALA A 189      16.421  30.591   2.638  1.00  9.44           O  
ATOM   1608  CB  ALA A 189      19.477  29.179   2.488  1.00  8.61           C  
ATOM   1609  N   LEU A 190      18.217  31.918   3.098  1.00  8.74           N  
ATOM   1610  CA  LEU A 190      17.422  32.794   3.964  1.00  8.80           C  
ATOM   1611  C   LEU A 190      16.345  33.508   3.167  1.00  8.40           C  
ATOM   1612  O   LEU A 190      15.199  33.599   3.642  1.00 10.66           O  
ATOM   1613  CB  LEU A 190      18.359  33.759   4.699  1.00  9.27           C  
ATOM   1614  CG  LEU A 190      17.657  34.724   5.680  1.00  9.75           C  
ATOM   1615  CD1 LEU A 190      16.873  33.992   6.772  1.00 11.93           C  
ATOM   1616  CD2 LEU A 190      18.645  35.688   6.273  1.00 11.07           C  
ATOM   1617  N   VAL A 191      16.654  34.051   1.989  1.00  8.73           N  
ATOM   1618  CA  VAL A 191      15.662  34.765   1.160  1.00  9.38           C  
ATOM   1619  C   VAL A 191      14.520  33.853   0.740  1.00  9.57           C  
ATOM   1620  O   VAL A 191      13.358  34.255   0.774  1.00 10.88           O  
ATOM   1621  CB  VAL A 191      16.313  35.456  -0.055  1.00 11.21           C  
ATOM   1622  CG1 VAL A 191      15.317  35.971  -1.064  1.00 12.84           C  
ATOM   1623  CG2 VAL A 191      17.170  36.636   0.425  1.00 11.39           C  
ATOM   1624  N   LYS A 192      14.809  32.586   0.380  1.00  9.70           N  
ATOM   1625  CA  LYS A 192      13.728  31.678   0.023  1.00  9.86           C  
ATOM   1626  C   LYS A 192      12.736  31.572   1.176  1.00 10.74           C  
ATOM   1627  O   LYS A 192      11.530  31.512   0.952  1.00 11.46           O  
ATOM   1628  CB  LYS A 192      14.280  30.284  -0.278  1.00  9.93           C  
ATOM   1629  CG  LYS A 192      13.271  29.318  -0.818  1.00 11.23           C  
ATOM   1630  CD  LYS A 192      13.759  27.891  -0.954  1.00 11.27           C  
ATOM   1631  CE  LYS A 192      12.666  26.975  -1.510  0.69 12.61           C  
ATOM   1633  NZ  LYS A 192      11.548  26.768  -0.565  0.69 11.79           N  
ATOM   1635  N   TYR A 193      13.271  31.468   2.397  1.00  9.76           N  
ATOM   1636  CA  TYR A 193      12.453  31.278   3.576  1.00 11.08           C  
ATOM   1637  C   TYR A 193      11.640  32.544   3.885  1.00 11.59           C  
ATOM   1638  O   TYR A 193      10.435  32.512   4.153  1.00 14.21           O  
ATOM   1639  CB  TYR A 193      13.325  30.909   4.750  1.00 11.97           C  
ATOM   1640  CG  TYR A 193      12.665  30.581   6.046  1.00 12.62           C  
ATOM   1641  CD1 TYR A 193      11.953  29.361   6.182  1.00 13.58           C  
ATOM   1642  CD2 TYR A 193      12.739  31.437   7.138  1.00 15.23           C  
ATOM   1643  CE1 TYR A 193      11.329  29.041   7.375  1.00 15.28           C  
ATOM   1644  CE2 TYR A 193      12.125  31.101   8.347  1.00 17.41           C  
ATOM   1645  CZ  TYR A 193      11.423  29.908   8.454  1.00 19.08           C  
ATOM   1646  OH  TYR A 193      10.847  29.612   9.678  1.00 23.93           O  
ATOM   1647  N   LEU A 194      12.326  33.691   3.838  1.00 11.46           N  
ATOM   1648  CA  LEU A 194      11.611  34.934   4.144  1.00 12.46           C  
ATOM   1649  C   LEU A 194      10.591  35.317   3.084  1.00 13.85           C  
ATOM   1650  O   LEU A 194       9.542  35.894   3.436  1.00 17.15           O  
ATOM   1651  CB  LEU A 194      12.634  36.030   4.328  1.00 11.44           C  
ATOM   1652  CG  LEU A 194      13.592  35.936   5.512  1.00 11.70           C  
ATOM   1653  CD1 LEU A 194      14.536  37.123   5.562  1.00 11.81           C  
ATOM   1654  CD2 LEU A 194      12.826  35.976   6.829  1.00 15.56           C  
ATOM   1655  N   ASP A 195      10.874  35.066   1.799  1.00 13.66           N  
ATOM   1656  CA  ASP A 195      10.025  35.450   0.673  1.00 11.99           C  
ATOM   1657  C   ASP A 195       9.007  34.380   0.322  1.00 12.53           C  
ATOM   1658  O   ASP A 195       8.230  34.550  -0.623  1.00 14.26           O  
ATOM   1659  CB  ASP A 195      10.899  35.813  -0.561  1.00 13.26           C  
ATOM   1660  CG  ASP A 195      11.663  37.100  -0.460  1.00 12.67           C  
ATOM   1661  OD1 ASP A 195      11.814  37.592   0.661  1.00 15.00           O  
ATOM   1662  OD2 ASP A 195      12.148  37.579  -1.505  1.00 16.71           O  
ATOM   1663  N   ASN A 196       8.946  33.244   1.012  1.00 13.48           N  
ATOM   1664  CA  ASN A 196       8.006  32.175   0.662  1.00 14.40           C  
ATOM   1665  C   ASN A 196       8.164  31.733  -0.775  1.00 14.30           C  
ATOM   1666  O   ASN A 196       7.196  31.441  -1.451  1.00 15.06           O  
ATOM   1667  CB  ASN A 196       6.539  32.585   0.935  1.00 16.05           C  
ATOM   1668  CG  ASN A 196       6.393  33.188   2.307  1.00 18.32           C  
ATOM   1669  OD1 ASN A 196       5.891  34.302   2.530  1.00 26.63           O  
ATOM   1670  ND2 ASN A 196       6.853  32.401   3.258  1.00 22.85           N  
ATOM   1671  N   MET A 197       9.407  31.605  -1.236  1.00 12.77           N  
ATOM   1672  CA  MET A 197       9.634  31.207  -2.618  1.00 11.91           C  
ATOM   1673  C   MET A 197       9.596  29.698  -2.865  1.00 11.65           C  
ATOM   1674  O   MET A 197       9.957  28.873  -1.994  1.00 11.89           O  
ATOM   1675  CB  MET A 197      11.004  31.699  -3.087  1.00 11.94           C  
ATOM   1676  CG  MET A 197      11.074  33.194  -3.373  1.00 14.46           C  
ATOM   1677  SD  MET A 197      12.743  33.713  -3.765  1.00 19.21           S  
ATOM   1678  CE  MET A 197      12.473  35.443  -4.043  1.00 21.51           C  
ATOM   1679  N   SER A 198       9.159  29.338  -4.072  1.00 11.79           N  
ATOM   1680  CA  SER A 198       9.161  27.948  -4.534  1.00 13.24           C  
ATOM   1681  C   SER A 198      10.592  27.528  -4.908  1.00 11.88           C  
ATOM   1682  O   SER A 198      11.494  28.371  -5.051  1.00 12.86           O  
ATOM   1683  CB  SER A 198       8.218  27.746  -5.734  1.00 13.19           C  
ATOM   1684  OG  SER A 198       8.738  28.523  -6.799  1.00 15.49           O  
ATOM   1685  N   GLU A 199      10.778  26.217  -5.151  1.00 13.53           N  
ATOM   1686  CA  GLU A 199      12.067  25.848  -5.723  1.00 13.66           C  
ATOM   1687  C   GLU A 199      12.328  26.556  -7.060  1.00 14.60           C  
ATOM   1688  O   GLU A 199      13.449  26.979  -7.321  1.00 16.32           O  
ATOM   1689  CB  GLU A 199      12.141  24.330  -5.922  1.00 14.88           C  
ATOM   1690  CG  GLU A 199      12.144  23.521  -4.680  1.00 15.51           C  
ATOM   1691  CD  GLU A 199      12.251  22.031  -4.892  1.00 15.25           C  
ATOM   1692  OE1 GLU A 199      12.744  21.552  -5.924  1.00 19.09           O  
ATOM   1693  OE2 GLU A 199      11.871  21.304  -3.965  1.00 18.23           O  
ATOM   1694  N   GLU A 200      11.307  26.614  -7.937  1.00 14.72           N  
ATOM   1695  CA  GLU A 200      11.491  27.279  -9.254  1.00 17.64           C  
ATOM   1696  C   GLU A 200      11.901  28.728  -9.088  1.00 17.75           C  
ATOM   1697  O   GLU A 200      12.763  29.312  -9.780  1.00 21.05           O  
ATOM   1698  CB  GLU A 200      10.185  26.964 -10.000  1.00 24.93           C  
ATOM   1699  CG  GLU A 200       9.838  25.476 -10.094  1.00 34.39           C  
ATOM   1700  CD  GLU A 200       9.409  24.546  -8.992  1.00 34.89           C  
ATOM   1701  OE1 GLU A 200       8.935  24.991  -7.895  1.00 27.44           O  
ATOM   1702  OE2 GLU A 200       9.549  23.300  -9.215  1.00 35.72           O  
ATOM   1703  N   GLU A 201      11.322  29.469  -8.131  1.00 15.28           N  
ATOM   1704  CA  GLU A 201      11.632  30.892  -7.919  1.00 14.94           C  
ATOM   1705  C   GLU A 201      13.019  31.061  -7.375  1.00 14.42           C  
ATOM   1706  O   GLU A 201      13.719  31.914  -7.875  1.00 17.40           O  
ATOM   1707  CB  GLU A 201      10.582  31.538  -7.002  1.00 16.69           C  
ATOM   1708  CG  GLU A 201       9.225  31.760  -7.694  1.00 16.77           C  
ATOM   1709  CD  GLU A 201       8.111  32.119  -6.753  1.00 17.84           C  
ATOM   1710  OE1 GLU A 201       8.133  31.743  -5.552  1.00 15.09           O  
ATOM   1711  OE2 GLU A 201       7.142  32.744  -7.277  1.00 21.72           O  
ATOM   1712  N   ILE A 202      13.439  30.234  -6.411  1.00 14.12           N  
ATOM   1713  CA  ILE A 202      14.759  30.497  -5.854  1.00 12.59           C  
ATOM   1714  C   ILE A 202      15.872  30.187  -6.846  1.00 12.90           C  
ATOM   1715  O   ILE A 202      16.959  30.787  -6.822  1.00 12.80           O  
ATOM   1716  CB  ILE A 202      14.988  29.728  -4.522  1.00 11.80           C  
ATOM   1717  CG1 ILE A 202      16.137  30.345  -3.742  1.00 11.30           C  
ATOM   1718  CG2 ILE A 202      15.148  28.243  -4.777  1.00 13.77           C  
ATOM   1719  CD1 ILE A 202      16.039  31.817  -3.388  1.00 13.14           C  
ATOM   1720  N   LEU A 203      15.651  29.240  -7.752  1.00 13.75           N  
ATOM   1721  CA  LEU A 203      16.643  28.891  -8.778  1.00 16.64           C  
ATOM   1722  C   LEU A 203      16.914  30.091  -9.669  1.00 14.82           C  
ATOM   1723  O   LEU A 203      17.997  30.223 -10.219  1.00 17.89           O  
ATOM   1724  CB  LEU A 203      16.277  27.659  -9.577  1.00 23.81           C  
ATOM   1725  CG  LEU A 203      14.890  27.401 -10.110  1.00 35.60           C  
ATOM   1726  CD1 LEU A 203      14.573  28.023 -11.466  1.00 48.04           C  
ATOM   1727  CD2 LEU A 203      14.693  25.882 -10.259  1.00 46.98           C  
ATOM   1728  N   GLU A 204      15.984  31.007  -9.827  1.00 15.61           N  
ATOM   1729  CA  GLU A 204      16.200  32.174 -10.689  1.00 18.36           C  
ATOM   1730  C   GLU A 204      16.957  33.280 -10.004  1.00 17.20           C  
ATOM   1731  O   GLU A 204      17.433  34.201 -10.670  1.00 17.39           O  
ATOM   1732  CB  GLU A 204      14.843  32.727 -11.161  1.00 25.13           C  
ATOM   1733  CG  GLU A 204      14.247  31.880 -12.282  1.00 39.80           C  
ATOM   1734  CD  GLU A 204      14.969  32.194 -13.602  1.00 48.40           C  
ATOM   1735  OE1 GLU A 204      15.312  33.389 -13.811  1.00 58.89           O  
ATOM   1736  OE2 GLU A 204      15.217  31.274 -14.405  1.00 79.20           O  
ATOM   1737  N   LEU A 205      17.008  33.303  -8.677  1.00 13.46           N  
ATOM   1738  CA  LEU A 205      17.556  34.430  -7.953  1.00 12.77           C  
ATOM   1739  C   LEU A 205      19.077  34.360  -7.876  1.00  9.64           C  
ATOM   1740  O   LEU A 205      19.648  33.368  -7.412  1.00 11.18           O  
ATOM   1741  CB  LEU A 205      17.021  34.547  -6.518  1.00 14.18           C  
ATOM   1742  CG  LEU A 205      17.695  35.622  -5.629  1.00 16.38           C  
ATOM   1743  CD1 LEU A 205      17.450  37.033  -6.123  1.00 20.56           C  
ATOM   1744  CD2 LEU A 205      17.208  35.449  -4.169  1.00 17.66           C  
ATOM   1745  N   ASN A 206      19.725  35.450  -8.244  1.00 10.03           N  
ATOM   1746  CA  ASN A 206      21.145  35.664  -7.982  1.00 11.15           C  
ATOM   1747  C   ASN A 206      21.281  36.934  -7.171  1.00 11.01           C  
ATOM   1748  O   ASN A 206      20.862  38.024  -7.571  1.00 15.42           O  
ATOM   1749  CB  ASN A 206      21.930  35.759  -9.275  1.00 13.47           C  
ATOM   1750  CG  ASN A 206      21.713  34.585 -10.193  1.00 17.32           C  
ATOM   1751  OD1 ASN A 206      22.118  33.496  -9.890  1.00 26.10           O  
ATOM   1752  ND2 ASN A 206      21.123  34.893 -11.350  1.00 21.41           N  
ATOM   1753  N   ILE A 207      21.881  36.809  -6.002  1.00 11.15           N  
ATOM   1754  CA  ILE A 207      22.154  38.005  -5.178  1.00 12.21           C  
ATOM   1755  C   ILE A 207      23.526  38.558  -5.544  1.00 10.20           C  
ATOM   1756  O   ILE A 207      24.510  37.806  -5.424  1.00 11.84           O  
ATOM   1757  CB  ILE A 207      22.049  37.678  -3.678  1.00 13.92           C  
ATOM   1758  CG1 ILE A 207      20.657  37.143  -3.324  1.00 16.81           C  
ATOM   1759  CG2 ILE A 207      22.416  38.896  -2.864  1.00 14.40           C  
ATOM   1760  CD1 ILE A 207      20.551  36.659  -1.883  1.00 15.94           C  
ATOM   1761  N   PRO A 208      23.668  39.771  -6.052  1.00  9.39           N  
ATOM   1762  CA  PRO A 208      24.989  40.209  -6.514  1.00  9.01           C  
ATOM   1763  C   PRO A 208      25.948  40.499  -5.367  1.00  7.16           C  
ATOM   1764  O   PRO A 208      25.593  40.858  -4.262  1.00  8.55           O  
ATOM   1765  CB  PRO A 208      24.741  41.472  -7.305  1.00 10.81           C  
ATOM   1766  CG  PRO A 208      23.275  41.607  -7.400  1.00 18.41           C  
ATOM   1767  CD  PRO A 208      22.587  40.709  -6.371  1.00 10.87           C  
ATOM   1768  N   THR A 209      27.251  40.356  -5.663  1.00  7.98           N  
ATOM   1769  CA  THR A 209      28.286  40.615  -4.663  1.00  7.21           C  
ATOM   1770  C   THR A 209      28.261  42.081  -4.211  1.00  7.19           C  
ATOM   1771  O   THR A 209      28.173  43.035  -4.999  1.00  8.46           O  
ATOM   1772  CB  THR A 209      29.685  40.241  -5.169  1.00  8.28           C  
ATOM   1773  OG1 THR A 209      30.040  41.004  -6.364  1.00  8.86           O  
ATOM   1774  CG2 THR A 209      29.852  38.758  -5.488  1.00  9.22           C  
ATOM   1775  N   GLY A 210      28.401  42.306  -2.912  1.00  6.87           N  
ATOM   1776  CA  GLY A 210      28.567  43.640  -2.374  1.00  7.33           C  
ATOM   1777  C   GLY A 210      27.401  44.592  -2.431  1.00  6.78           C  
ATOM   1778  O   GLY A 210      27.605  45.799  -2.239  1.00 10.01           O  
ATOM   1779  N   VAL A 211      26.196  44.109  -2.629  1.00  7.36           N  
ATOM   1780  CA  VAL A 211      25.037  44.989  -2.771  1.00  7.39           C  
ATOM   1781  C   VAL A 211      24.122  44.888  -1.541  1.00  7.34           C  
ATOM   1782  O   VAL A 211      23.544  43.805  -1.297  1.00  7.80           O  
ATOM   1783  CB  VAL A 211      24.196  44.700  -4.036  1.00  8.74           C  
ATOM   1784  CG1 VAL A 211      22.953  45.609  -4.097  1.00  9.99           C  
ATOM   1785  CG2 VAL A 211      25.043  44.873  -5.302  1.00  9.73           C  
ATOM   1786  N   PRO A 212      23.950  45.935  -0.730  1.00  6.92           N  
ATOM   1787  CA  PRO A 212      23.041  45.792   0.433  1.00  7.46           C  
ATOM   1788  C   PRO A 212      21.606  45.459   0.036  1.00  6.77           C  
ATOM   1789  O   PRO A 212      21.071  46.098  -0.851  1.00  7.91           O  
ATOM   1790  CB  PRO A 212      23.146  47.144   1.139  1.00  7.89           C  
ATOM   1791  CG  PRO A 212      24.469  47.694   0.677  1.00  8.77           C  
ATOM   1792  CD  PRO A 212      24.570  47.274  -0.754  1.00  8.39           C  
ATOM   1793  N   LEU A 213      21.027  44.465   0.703  1.00  7.09           N  
ATOM   1794  CA  LEU A 213      19.643  44.008   0.550  1.00  6.58           C  
ATOM   1795  C   LEU A 213      18.959  44.231   1.886  1.00  6.54           C  
ATOM   1796  O   LEU A 213      19.306  43.606   2.896  1.00  7.87           O  
ATOM   1797  CB  LEU A 213      19.607  42.536   0.095  1.00  8.40           C  
ATOM   1798  CG  LEU A 213      18.227  41.880   0.028  1.00  8.72           C  
ATOM   1799  CD1 LEU A 213      17.266  42.664  -0.820  1.00 10.11           C  
ATOM   1800  CD2 LEU A 213      18.365  40.449  -0.458  1.00 11.16           C  
ATOM   1801  N   VAL A 214      18.025  45.176   1.928  1.00  7.48           N  
ATOM   1802  CA  VAL A 214      17.328  45.566   3.135  1.00  7.50           C  
ATOM   1803  C   VAL A 214      15.959  44.902   3.230  1.00  8.27           C  
ATOM   1804  O   VAL A 214      15.153  44.979   2.275  1.00  9.86           O  
ATOM   1805  CB  VAL A 214      17.143  47.113   3.189  1.00  8.39           C  
ATOM   1806  CG1 VAL A 214      16.428  47.553   4.453  1.00  9.93           C  
ATOM   1807  CG2 VAL A 214      18.455  47.846   2.998  1.00 10.19           C  
ATOM   1808  N   TYR A 215      15.657  44.305   4.369  1.00  8.04           N  
ATOM   1809  CA  TYR A 215      14.357  43.813   4.727  1.00  8.44           C  
ATOM   1810  C   TYR A 215      13.713  44.686   5.797  1.00  9.16           C  
ATOM   1811  O   TYR A 215      14.355  45.047   6.774  1.00 10.65           O  
ATOM   1812  CB  TYR A 215      14.410  42.356   5.271  1.00  9.95           C  
ATOM   1813  CG  TYR A 215      14.380  41.315   4.194  1.00  8.89           C  
ATOM   1814  CD1 TYR A 215      15.508  40.999   3.434  1.00  9.86           C  
ATOM   1815  CD2 TYR A 215      13.201  40.621   3.901  1.00  9.44           C  
ATOM   1816  CE1 TYR A 215      15.449  40.043   2.452  1.00 10.35           C  
ATOM   1817  CE2 TYR A 215      13.157  39.660   2.886  1.00 10.19           C  
ATOM   1818  CZ  TYR A 215      14.301  39.376   2.163  1.00  9.66           C  
ATOM   1819  OH  TYR A 215      14.310  38.433   1.156  1.00 12.89           O  
ATOM   1820  N   GLU A 216      12.427  44.990   5.612  1.00  9.53           N  
ATOM   1821  CA  GLU A 216      11.531  45.575   6.611  1.00 10.24           C  
ATOM   1822  C   GLU A 216      10.612  44.528   7.184  1.00 10.82           C  
ATOM   1823  O   GLU A 216       9.998  43.778   6.412  1.00 12.72           O  
ATOM   1824  CB  GLU A 216      10.716  46.712   5.968  1.00 11.67           C  
ATOM   1825  CG  GLU A 216      11.597  47.855   5.514  1.00 13.55           C  
ATOM   1826  CD  GLU A 216      10.833  49.098   5.072  1.00 14.33           C  
ATOM   1827  OE1 GLU A 216       9.613  49.132   5.208  1.00 20.27           O  
ATOM   1828  OE2 GLU A 216      11.493  50.056   4.606  1.00 15.57           O  
ATOM   1829  N   PHE A 217      10.532  44.485   8.501  1.00 12.11           N  
ATOM   1830  CA  PHE A 217       9.676  43.571   9.239  1.00 13.64           C  
ATOM   1831  C   PHE A 217       8.637  44.362  10.042  1.00 14.68           C  
ATOM   1832  O   PHE A 217       8.993  45.397  10.680  1.00 13.79           O  
ATOM   1833  CB  PHE A 217      10.552  42.758  10.201  1.00 12.20           C  
ATOM   1834  CG  PHE A 217      11.396  41.681   9.568  1.00 10.27           C  
ATOM   1835  CD1 PHE A 217      12.664  41.972   9.083  1.00 10.36           C  
ATOM   1836  CD2 PHE A 217      10.928  40.373   9.440  1.00 12.48           C  
ATOM   1837  CE1 PHE A 217      13.436  40.997   8.480  1.00 10.17           C  
ATOM   1838  CE2 PHE A 217      11.706  39.367   8.852  1.00 11.74           C  
ATOM   1839  CZ  PHE A 217      12.968  39.708   8.407  1.00 11.70           C  
ATOM   1840  N   ASP A 218       7.393  43.859  10.070  1.00 15.44           N  
ATOM   1841  CA  ASP A 218       6.356  44.509  10.882  1.00 18.09           C  
ATOM   1842  C   ASP A 218       6.493  44.115  12.351  1.00 18.62           C  
ATOM   1843  O   ASP A 218       7.489  43.511  12.755  1.00 19.08           O  
ATOM   1844  CB  ASP A 218       4.965  44.201  10.324  1.00 19.46           C  
ATOM   1845  CG  ASP A 218       4.509  42.764  10.485  1.00 20.74           C  
ATOM   1846  OD1 ASP A 218       5.066  41.984  11.293  1.00 19.77           O  
ATOM   1847  OD2 ASP A 218       3.526  42.375   9.805  1.00 25.07           O  
ATOM   1848  N   GLU A 219       5.469  44.430  13.144  1.00 24.77           N  
ATOM   1849  CA  GLU A 219       5.571  44.317  14.577  1.00 26.14           C  
ATOM   1850  C   GLU A 219       5.485  42.854  14.995  1.00 25.62           C  
ATOM   1851  O   GLU A 219       5.880  42.554  16.120  1.00 30.14           O  
ATOM   1852  CB  GLU A 219       4.512  45.121  15.360  1.00 35.50           C  
ATOM   1853  CG  GLU A 219       4.002  46.407  14.742  1.00 47.14           C  
ATOM   1854  CD  GLU A 219       4.987  47.543  14.814  1.00 46.86           C  
ATOM   1855  OE1 GLU A 219       5.996  47.433  15.555  1.00 59.98           O  
ATOM   1856  OE2 GLU A 219       4.782  48.587  14.141  1.00 60.08           O  
ATOM   1857  N   ASN A 220       4.973  42.044  14.066  1.00 25.69           N  
ATOM   1858  CA  ASN A 220       4.916  40.618  14.286  1.00 27.03           C  
ATOM   1859  C   ASN A 220       6.098  39.917  13.629  1.00 21.99           C  
ATOM   1860  O   ASN A 220       6.085  38.687  13.561  1.00 21.27           O  
ATOM   1861  CB  ASN A 220       3.630  39.982  13.722  1.00 32.14           C  
ATOM   1862  CG  ASN A 220       2.413  40.326  14.545  1.00 34.14           C  
ATOM   1863  OD1 ASN A 220       2.410  40.039  15.742  1.00 37.25           O  
ATOM   1864  ND2 ASN A 220       1.427  40.936  13.911  1.00 37.41           N  
ATOM   1865  N   PHE A 221       7.049  40.681  13.153  1.00 16.65           N  
ATOM   1866  CA  PHE A 221       8.200  40.160  12.397  1.00 16.24           C  
ATOM   1867  C   PHE A 221       7.801  39.340  11.183  1.00 18.87           C  
ATOM   1868  O   PHE A 221       8.493  38.407  10.773  1.00 19.37           O  
ATOM   1869  CB  PHE A 221       9.169  39.393  13.323  1.00 18.45           C  
ATOM   1870  CG  PHE A 221       9.893  40.416  14.192  1.00 21.85           C  
ATOM   1871  CD1 PHE A 221       9.330  40.830  15.383  1.00 25.53           C  
ATOM   1872  CD2 PHE A 221      11.106  40.941  13.751  1.00 21.91           C  
ATOM   1873  CE1 PHE A 221       9.932  41.769  16.177  1.00 24.80           C  
ATOM   1874  CE2 PHE A 221      11.716  41.871  14.567  1.00 23.95           C  
ATOM   1875  CZ  PHE A 221      11.145  42.287  15.753  1.00 25.67           C  
ATOM   1876  N   LYS A 222       6.710  39.726  10.529  1.00 17.06           N  
ATOM   1877  CA  LYS A 222       6.400  39.278   9.159  1.00 17.51           C  
ATOM   1878  C   LYS A 222       7.113  40.236   8.209  1.00 14.80           C  
ATOM   1879  O   LYS A 222       7.036  41.464   8.361  1.00 14.87           O  
ATOM   1880  CB  LYS A 222       4.907  39.210   8.896  1.00 22.58           C  
ATOM   1881  CG  LYS A 222       4.447  38.789   7.504  1.00 22.94           C  
ATOM   1882  CD  LYS A 222       2.944  38.850   7.266  1.00 27.05           C  
ATOM   1883  CE  LYS A 222       2.663  38.535   5.799  1.00 29.09           C  
ATOM   1884  NZ  LYS A 222       3.280  39.449   4.792  1.00 56.88           N  
ATOM   1885  N   PRO A 223       7.860  39.707   7.223  1.00 14.39           N  
ATOM   1886  CA  PRO A 223       8.451  40.622   6.231  1.00 13.87           C  
ATOM   1887  C   PRO A 223       7.397  41.483   5.543  1.00 14.69           C  
ATOM   1888  O   PRO A 223       6.354  40.966   5.072  1.00 18.31           O  
ATOM   1889  CB  PRO A 223       9.139  39.670   5.258  1.00 17.79           C  
ATOM   1890  CG  PRO A 223       9.343  38.412   6.030  1.00 18.84           C  
ATOM   1891  CD  PRO A 223       8.264  38.301   7.043  1.00 17.54           C  
ATOM   1892  N   LEU A 224       7.666  42.779   5.465  1.00 13.80           N  
ATOM   1893  CA  LEU A 224       6.814  43.766   4.776  1.00 15.29           C  
ATOM   1894  C   LEU A 224       7.309  44.101   3.372  1.00 14.28           C  
ATOM   1895  O   LEU A 224       6.518  44.264   2.424  1.00 16.34           O  
ATOM   1896  CB  LEU A 224       6.770  45.054   5.586  1.00 19.14           C  
ATOM   1897  CG  LEU A 224       5.997  45.281   6.857  1.00 24.21           C  
ATOM   1898  CD1 LEU A 224       6.469  46.575   7.521  1.00 27.06           C  
ATOM   1899  CD2 LEU A 224       4.512  45.323   6.569  1.00 27.28           C  
ATOM   1900  N   LYS A 225       8.613  44.231   3.193  1.00 12.86           N  
ATOM   1901  CA  LYS A 225       9.210  44.673   1.941  1.00 13.60           C  
ATOM   1902  C   LYS A 225      10.699  44.340   1.947  1.00  9.34           C  
ATOM   1903  O   LYS A 225      11.267  44.184   3.040  1.00 10.43           O  
ATOM   1904  CB  LYS A 225       9.087  46.179   1.786  1.00 20.44           C  
ATOM   1905  CG  LYS A 225       9.658  46.804   0.551  1.00 29.07           C  
ATOM   1906  CD  LYS A 225       9.590  48.324   0.706  1.00 33.83           C  
ATOM   1907  CE  LYS A 225       8.363  48.751   1.506  1.00 33.44           C  
ATOM   1908  NZ  LYS A 225       8.181  50.253   1.429  1.00 42.99           N  
ATOM   1909  N   ARG A 226      11.282  44.249   0.763  1.00 10.38           N  
ATOM   1910  CA  ARG A 226      12.724  44.082   0.640  1.00  9.50           C  
ATOM   1911  C   ARG A 226      13.197  44.862  -0.580  1.00  9.16           C  
ATOM   1912  O   ARG A 226      12.469  44.919  -1.583  1.00 10.41           O  
ATOM   1913  CB  ARG A 226      13.205  42.634   0.671  1.00 10.57           C  
ATOM   1914  CG  ARG A 226      13.045  41.798  -0.558  1.00 12.12           C  
ATOM   1915  CD  ARG A 226      11.633  41.400  -0.908  1.00 12.78           C  
ATOM   1916  NE  ARG A 226      11.074  40.438   0.033  1.00 14.39           N  
ATOM   1917  CZ  ARG A 226       9.897  40.423   0.633  1.00 13.17           C  
ATOM   1918  NH1 ARG A 226       9.004  41.391   0.451  1.00 16.34           N  
ATOM   1919  NH2 ARG A 226       9.623  39.403   1.461  1.00 14.05           N  
ATOM   1920  N   TYR A 227      14.385  45.434  -0.535  1.00  8.72           N  
ATOM   1921  CA  TYR A 227      14.891  46.281  -1.604  1.00  9.21           C  
ATOM   1922  C   TYR A 227      16.419  46.394  -1.537  1.00  8.32           C  
ATOM   1923  O   TYR A 227      17.043  46.306  -0.485  1.00  9.17           O  
ATOM   1924  CB  TYR A 227      14.253  47.645  -1.555  1.00  9.23           C  
ATOM   1925  CG  TYR A 227      14.222  48.309  -0.211  1.00  9.80           C  
ATOM   1926  CD1 TYR A 227      15.241  49.102   0.283  1.00 10.60           C  
ATOM   1927  CD2 TYR A 227      13.104  48.147   0.614  1.00 11.93           C  
ATOM   1928  CE1 TYR A 227      15.136  49.695   1.534  1.00 11.87           C  
ATOM   1929  CE2 TYR A 227      13.009  48.743   1.865  1.00 12.24           C  
ATOM   1930  CZ  TYR A 227      14.017  49.518   2.345  1.00 10.54           C  
ATOM   1931  OH  TYR A 227      14.031  50.158   3.573  1.00 12.67           O  
ATOM   1932  N   TYR A 228      16.997  46.588  -2.708  1.00  8.64           N  
ATOM   1933  CA  TYR A 228      18.441  46.800  -2.801  1.00  8.62           C  
ATOM   1934  C   TYR A 228      18.777  48.278  -2.657  1.00  8.64           C  
ATOM   1935  O   TYR A 228      17.984  49.136  -3.018  1.00 12.23           O  
ATOM   1936  CB  TYR A 228      18.995  46.307  -4.131  1.00  8.90           C  
ATOM   1937  CG  TYR A 228      19.030  44.834  -4.416  1.00  9.04           C  
ATOM   1938  CD1 TYR A 228      19.721  43.953  -3.602  1.00  9.19           C  
ATOM   1939  CD2 TYR A 228      18.438  44.295  -5.545  1.00 12.00           C  
ATOM   1940  CE1 TYR A 228      19.794  42.606  -3.864  1.00 10.50           C  
ATOM   1941  CE2 TYR A 228      18.496  42.931  -5.823  1.00 13.70           C  
ATOM   1942  CZ  TYR A 228      19.178  42.086  -4.982  1.00 12.29           C  
ATOM   1943  OH  TYR A 228      19.293  40.717  -5.167  1.00 16.29           O  
ATOM   1944  N   LEU A 229      19.950  48.572  -2.085  1.00  8.82           N  
ATOM   1945  CA  LEU A 229      20.520  49.889  -2.052  1.00  9.07           C  
ATOM   1946  C   LEU A 229      21.588  50.060  -3.131  1.00  8.27           C  
ATOM   1947  O   LEU A 229      22.456  49.191  -3.309  1.00  9.12           O  
ATOM   1948  CB  LEU A 229      21.151  50.229  -0.700  1.00  9.17           C  
ATOM   1949  CG  LEU A 229      20.244  50.100   0.513  1.00 10.41           C  
ATOM   1950  CD1 LEU A 229      21.025  50.427   1.793  1.00 10.41           C  
ATOM   1951  CD2 LEU A 229      19.014  50.975   0.379  1.00 12.25           C  
ATOM   1952  N   GLY A 230      21.541  51.153  -3.857  1.00  9.19           N  
ATOM   1953  CA  GLY A 230      22.530  51.526  -4.852  1.00 11.11           C  
ATOM   1954  C   GLY A 230      21.922  51.843  -6.208  1.00  9.44           C  
ATOM   1955  O   GLY A 230      20.761  52.181  -6.325  1.00 11.44           O  
ATOM   1956  N   ASN A 231      22.754  51.760  -7.234  1.00  9.98           N  
ATOM   1957  CA  ASN A 231      22.399  52.137  -8.593  1.00  9.99           C  
ATOM   1958  C   ASN A 231      21.592  51.014  -9.256  1.00 10.12           C  
ATOM   1959  O   ASN A 231      22.112  49.888  -9.486  1.00  9.99           O  
ATOM   1960  CB  ASN A 231      23.653  52.485  -9.379  1.00 12.59           C  
ATOM   1961  CG  ASN A 231      23.320  52.917 -10.810  1.00 12.90           C  
ATOM   1962  OD1 ASN A 231      22.978  52.112 -11.683  1.00 14.00           O  
ATOM   1963  ND2 ASN A 231      23.427  54.222 -11.013  1.00 17.46           N  
ATOM   1964  N   ALA A 232      20.318  51.282  -9.559  1.00 10.51           N  
ATOM   1965  CA  ALA A 232      19.409  50.242  -9.999  1.00 10.07           C  
ATOM   1966  C   ALA A 232      19.879  49.571 -11.302  1.00 10.22           C  
ATOM   1967  O   ALA A 232      19.818  48.316 -11.437  1.00 10.59           O  
ATOM   1968  CB  ALA A 232      17.999  50.775 -10.140  1.00 13.05           C  
ATOM   1969  N   ASP A 233      20.335  50.372 -12.273  1.00 10.68           N  
ATOM   1970  CA  ASP A 233      20.759  49.781 -13.550  1.00 11.26           C  
ATOM   1971  C   ASP A 233      21.942  48.848 -13.345  1.00 10.30           C  
ATOM   1972  O   ASP A 233      21.979  47.753 -13.892  1.00 13.25           O  
ATOM   1973  CB  ASP A 233      21.146  50.877 -14.512  1.00 13.94           C  
ATOM   1974  CG  ASP A 233      20.000  51.561 -15.220  1.00 17.02           C  
ATOM   1975  OD1 ASP A 233      18.867  51.511 -14.752  1.00 29.13           O  
ATOM   1976  OD2 ASP A 233      20.289  52.166 -16.274  1.00 19.66           O  
ATOM   1977  N   GLU A 234      22.915  49.238 -12.537  1.00 10.71           N  
ATOM   1978  CA  GLU A 234      24.092  48.441 -12.262  1.00 10.34           C  
ATOM   1979  C   GLU A 234      23.744  47.151 -11.515  1.00 10.16           C  
ATOM   1980  O   GLU A 234      24.204  46.077 -11.877  1.00 10.63           O  
ATOM   1981  CB  GLU A 234      25.168  49.251 -11.523  1.00 13.16           C  
ATOM   1982  CG  GLU A 234      25.816  50.272 -12.412  1.00 19.82           C  
ATOM   1983  CD  GLU A 234      26.715  51.256 -11.648  1.00 26.50           C  
ATOM   1984  OE1 GLU A 234      26.970  51.033 -10.434  1.00 30.44           O  
ATOM   1985  OE2 GLU A 234      27.149  52.221 -12.307  1.00 37.85           O  
ATOM   1986  N   ILE A 235      22.909  47.261 -10.499  1.00  9.56           N  
ATOM   1987  CA  ILE A 235      22.528  46.104  -9.676  1.00  8.93           C  
ATOM   1988  C   ILE A 235      21.736  45.086 -10.490  1.00  8.06           C  
ATOM   1989  O   ILE A 235      22.036  43.888 -10.488  1.00  9.74           O  
ATOM   1990  CB  ILE A 235      21.745  46.585  -8.449  1.00  8.42           C  
ATOM   1991  CG1 ILE A 235      22.574  47.487  -7.533  1.00  8.79           C  
ATOM   1992  CG2 ILE A 235      21.200  45.359  -7.732  1.00  9.34           C  
ATOM   1993  CD1 ILE A 235      21.791  48.306  -6.538  1.00 10.62           C  
ATOM   1994  N   ALA A 236      20.724  45.588 -11.233  1.00  8.96           N  
ATOM   1995  CA  ALA A 236      19.896  44.619 -12.010  1.00  9.32           C  
ATOM   1996  C   ALA A 236      20.727  43.922 -13.046  1.00  9.30           C  
ATOM   1997  O   ALA A 236      20.567  42.725 -13.288  1.00 10.59           O  
ATOM   1998  CB  ALA A 236      18.705  45.376 -12.564  1.00 11.24           C  
ATOM   1999  N   ALA A 237      21.691  44.639 -13.709  1.00 10.02           N  
ATOM   2000  CA  ALA A 237      22.556  43.948 -14.670  1.00 11.02           C  
ATOM   2001  C   ALA A 237      23.391  42.864 -14.007  1.00 10.19           C  
ATOM   2002  O   ALA A 237      23.618  41.786 -14.556  1.00 12.22           O  
ATOM   2003  CB  ALA A 237      23.389  44.964 -15.430  1.00 11.53           C  
ATOM   2004  N   LYS A 238      23.901  43.181 -12.808  1.00 10.61           N  
ATOM   2005  CA  LYS A 238      24.738  42.279 -12.037  1.00 12.23           C  
ATOM   2006  C   LYS A 238      23.997  41.076 -11.455  1.00 11.60           C  
ATOM   2007  O   LYS A 238      24.645  40.058 -11.123  1.00 13.87           O  
ATOM   2008  CB  LYS A 238      25.340  43.075 -10.862  1.00 14.11           C  
ATOM   2009  CG  LYS A 238      26.739  42.657 -10.448  1.00 14.85           C  
ATOM   2010  CD  LYS A 238      27.280  43.542  -9.321  1.00 17.64           C  
ATOM   2011  CE  LYS A 238      28.616  43.038  -8.803  1.00 17.39           C  
ATOM   2012  NZ  LYS A 238      29.033  43.701  -7.576  1.00 18.03           N  
ATOM   2013  N   ALA A 239      22.700  41.158 -11.326  1.00 10.68           N  
ATOM   2014  CA  ALA A 239      21.880  40.073 -10.784  1.00 10.37           C  
ATOM   2015  C   ALA A 239      21.454  39.042 -11.835  1.00  9.75           C  
ATOM   2016  O   ALA A 239      20.808  38.028 -11.441  1.00 12.03           O  
ATOM   2017  CB  ALA A 239      20.651  40.637 -10.078  1.00 13.40           C  
ATOM   2018  N   ALA A 240      21.804  39.224 -13.085  1.00 10.39           N  
ATOM   2019  CA  ALA A 240      21.561  38.226 -14.151  1.00  9.72           C  
ATOM   2020  C   ALA A 240      22.501  37.033 -13.994  1.00 11.08           C  
ATOM   2021  O   ALA A 240      23.674  37.190 -13.590  1.00 10.91           O  
ATOM   2022  CB  ALA A 240      21.809  38.811 -15.525  1.00 10.78           C  
ATOM   2023  N   ALA A 241      22.054  35.827 -14.336  1.00  9.99           N  
ATOM   2024  CA  ALA A 241      22.905  34.636 -14.315  1.00 10.70           C  
ATOM   2025  C   ALA A 241      24.003  34.686 -15.373  1.00 10.58           C  
ATOM   2026  O   ALA A 241      23.752  35.099 -16.527  1.00 11.79           O  
ATOM   2027  CB  ALA A 241      22.056  33.394 -14.557  1.00 12.21           C  
ATOM   2028  N   VAL A 242      25.206  34.270 -14.993  1.00 10.17           N  
ATOM   2029  CA  VAL A 242      26.359  34.233 -15.862  1.00  9.83           C  
ATOM   2030  C   VAL A 242      26.633  32.824 -16.355  1.00  9.60           C  
ATOM   2031  O   VAL A 242      26.538  31.879 -15.584  1.00 11.27           O  
ATOM   2032  CB  VAL A 242      27.607  34.772 -15.139  1.00 10.73           C  
ATOM   2033  CG1 VAL A 242      28.849  34.669 -16.005  1.00 12.25           C  
ATOM   2034  CG2 VAL A 242      27.353  36.225 -14.696  1.00 13.31           C  
ATOM   2035  N   ALA A 243      26.952  32.668 -17.633  1.00 10.09           N  
ATOM   2036  CA  ALA A 243      27.192  31.347 -18.214  1.00 11.63           C  
ATOM   2037  C   ALA A 243      28.357  30.646 -17.525  1.00 10.70           C  
ATOM   2038  O   ALA A 243      29.247  31.286 -16.962  1.00 11.29           O  
ATOM   2039  CB  ALA A 243      27.450  31.550 -19.704  1.00 14.37           C  
ATOM   2040  N   ASN A 244      28.458  29.323 -17.652  1.00 11.71           N  
ATOM   2041  CA  ASN A 244      29.586  28.572 -17.126  1.00 12.07           C  
ATOM   2042  C   ASN A 244      30.897  29.036 -17.727  1.00 12.67           C  
ATOM   2043  O   ASN A 244      31.940  28.903 -17.065  1.00 14.10           O  
ATOM   2044  CB  ASN A 244      29.489  27.051 -17.384  1.00 12.65           C  
ATOM   2045  CG  ASN A 244      28.302  26.391 -16.752  1.00 13.79           C  
ATOM   2046  OD1 ASN A 244      27.905  26.783 -15.637  1.00 14.97           O  
ATOM   2047  ND2 ASN A 244      27.699  25.387 -17.413  1.00 16.52           N  
ATOM   2048  N   GLN A 245      30.850  29.586 -18.934  1.00 14.19           N  
ATOM   2049  CA  GLN A 245      32.078  30.016 -19.634  1.00 18.76           C  
ATOM   2050  C   GLN A 245      32.576  31.362 -19.100  1.00 17.71           C  
ATOM   2051  O   GLN A 245      33.671  31.768 -19.509  1.00 22.00           O  
ATOM   2052  CB  GLN A 245      31.847  30.116 -21.137  1.00 22.11           C  
ATOM   2053  CG  GLN A 245      31.696  28.775 -21.870  1.00 22.13           C  
ATOM   2054  CD  GLN A 245      30.397  28.074 -21.469  1.00 21.23           C  
ATOM   2055  OE1 GLN A 245      29.353  28.711 -21.327  1.00 20.55           O  
ATOM   2056  NE2 GLN A 245      30.394  26.751 -21.230  1.00 20.60           N  
ATOM   2057  N   GLY A 246      31.817  32.039 -18.221  1.00 16.95           N  
ATOM   2058  CA  GLY A 246      32.099  33.362 -17.691  1.00 17.17           C  
ATOM   2059  C   GLY A 246      31.406  34.491 -18.442  1.00 15.29           C  
ATOM   2060  O   GLY A 246      30.765  34.324 -19.478  1.00 15.67           O  
ATOM   2061  N   LYS A 247      31.524  35.741 -17.953  1.00 15.16           N  
ATOM   2062  CA  LYS A 247      31.063  36.977 -18.489  1.00 16.94           C  
ATOM   2063  C   LYS A 247      32.155  37.726 -19.310  1.00 27.24           C  
ATOM   2064  O   LYS A 247      32.942  37.086 -19.989  1.00 35.62           O  
ATOM   2065  CB  LYS A 247      30.864  37.966 -17.321  1.00 19.83           C  
ATOM   2066  CG  LYS A 247      30.069  39.198 -17.645  1.00 29.35           C  
ATOM   2067  CD  LYS A 247      29.344  39.741 -16.426  1.00 32.99           C  
ATOM   2068  CE  LYS A 247      30.225  39.722 -15.197  1.00 39.17           C  
ATOM   2069  NZ  LYS A 247      31.465  40.507 -15.476  1.00 50.61           N  
TER    2070      LYS A 247                                                      
END
MOLECULE T0394.pdb
ATOM      1  N   ASN     1       7.131  28.263  26.435  1.00 37.08           N  
ATOM      2  CA  ASN     1       7.437  29.315  25.416  1.00 36.05           C  
ATOM      3  C   ASN     1       7.192  30.735  25.903  1.00 34.53           C  
ATOM      4  O   ASN     1       6.216  30.997  26.611  1.00 34.93           O  
ATOM      5  CB  ASN     1       6.662  29.047  24.125  1.00 37.00           C  
ATOM      6  CG  ASN     1       7.395  28.086  23.213  1.00 39.47           C  
ATOM      7  OD1 ASN     1       7.200  26.869  23.286  1.00 43.62           O  
ATOM      8  ND2 ASN     1       8.288  28.624  22.384  1.00 40.23           N  
ATOM      9  N   LEU     2       8.082  31.640  25.492  1.00 32.19           N  
ATOM     10  CA  LEU     2       8.122  33.016  25.993  1.00 29.95           C  
ATOM     11  C   LEU     2       7.110  33.917  25.298  1.00 28.07           C  
ATOM     12  O   LEU     2       6.983  33.894  24.068  1.00 28.29           O  
ATOM     13  CB  LEU     2       9.527  33.600  25.804  1.00 29.69           C  
ATOM     14  CG  LEU     2      10.670  32.930  26.564  1.00 29.92           C  
ATOM     15  CD1 LEU     2      12.000  33.222  25.886  1.00 29.23           C  
ATOM     16  CD2 LEU     2      10.663  33.446  27.989  1.00 28.60           C  
ATOM     17  N   TYR     3       6.407  34.722  26.095  1.00 25.72           N  
ATOM     18  CA  TYR     3       5.529  35.769  25.587  1.00 24.38           C  
ATOM     19  C   TYR     3       6.320  37.041  25.320  1.00 23.44           C  
ATOM     20  O   TYR     3       7.033  37.574  26.203  1.00 21.70           O  
ATOM     21  CB  TYR     3       4.386  36.067  26.569  1.00 24.95           C  
ATOM     22  CG  TYR     3       3.542  37.283  26.201  1.00 24.49           C  
ATOM     23  CD1 TYR     3       2.296  37.140  25.578  1.00 25.41           C  
ATOM     24  CD2 TYR     3       3.986  38.574  26.489  1.00 24.54           C  
ATOM     25  CE1 TYR     3       1.528  38.265  25.239  1.00 26.31           C  
ATOM     26  CE2 TYR     3       3.232  39.700  26.154  1.00 24.99           C  
ATOM     27  CZ  TYR     3       2.015  39.541  25.528  1.00 26.12           C  
ATOM     28  OH  TYR     3       1.282  40.675  25.217  1.00 29.19           O  
ATOM     29  N   PHE     4       6.198  37.532  24.092  1.00 21.28           N  
ATOM     30  CA  PHE     4       6.804  38.796  23.732  1.00 21.92           C  
ATOM     31  C   PHE     4       5.758  39.769  23.248  1.00 22.33           C  
ATOM     32  O   PHE     4       4.744  39.358  22.707  1.00 21.26           O  
ATOM     33  CB  PHE     4       7.841  38.598  22.620  1.00 21.80           C  
ATOM     34  CG  PHE     4       9.019  37.763  23.036  1.00 20.69           C  
ATOM     35  CD1 PHE     4       9.930  38.245  23.973  1.00 18.93           C  
ATOM     36  CD2 PHE     4       9.209  36.497  22.501  1.00 21.68           C  
ATOM     37  CE1 PHE     4      11.035  37.458  24.352  1.00 20.05           C  
ATOM     38  CE2 PHE     4      10.302  35.717  22.866  1.00 22.45           C  
ATOM     39  CZ  PHE     4      11.222  36.218  23.803  1.00 21.82           C  
ATOM     40  N   GLN     5       6.032  41.054  23.450  1.00 22.99           N  
ATOM     41  CA  GLN     5       5.226  42.107  22.871  1.00 24.75           C  
ATOM     42  C   GLN     5       5.521  42.151  21.367  1.00 23.85           C  
ATOM     43  O   GLN     5       6.451  41.461  20.899  1.00 23.54           O  
ATOM     44  CB  GLN     5       5.532  43.444  23.553  1.00 26.07           C  
ATOM     45  CG  GLN     5       5.034  43.473  25.022  1.00 31.04           C  
ATOM     46  CD  GLN     5       4.811  44.878  25.566  1.00 37.81           C  
ATOM     47  OE1 GLN     5       5.661  45.777  25.403  1.00 41.06           O  
ATOM     48  NE2 GLN     5       3.660  45.079  26.215  1.00 38.49           N  
ATOM     49  N   SER     6       4.726  42.924  20.628  1.00 23.52           N  
ATOM     50  CA  SER     6       4.940  43.126  19.191  0.50 23.55           C  
ATOM     52  C   SER     6       6.337  43.702  18.962  1.00 22.75           C  
ATOM     53  O   SER     6       6.858  44.463  19.805  1.00 22.96           O  
ATOM     54  CB  SER     6       3.856  44.057  18.638  0.50 23.94           C  
ATOM     56  OG  SER     6       3.940  44.174  17.233  0.50 25.41           O  
ATOM     58  N   ALA     7       6.977  43.335  17.852  1.00 21.09           N  
ATOM     59  CA  ALA     7       8.341  43.796  17.589  1.00 19.34           C  
ATOM     60  C   ALA     7       8.616  43.806  16.096  1.00 18.62           C  
ATOM     61  O   ALA     7       7.962  43.078  15.352  1.00 17.81           O  
ATOM     62  CB  ALA     7       9.361  42.902  18.314  1.00 18.58           C  
ATOM     63  N   ARG     8       9.540  44.662  15.692  1.00 17.77           N  
ATOM     64  CA  ARG     8       9.981  44.808  14.311  1.00 18.09           C  
ATOM     65  C   ARG     8      11.475  45.003  14.342  1.00 17.38           C  
ATOM     66  O   ARG     8      11.988  45.711  15.227  1.00 16.45           O  
ATOM     67  CB  ARG     8       9.398  46.071  13.683  1.00 19.36           C  
ATOM     68  CG  ARG     8       7.946  46.007  13.335  1.00 23.70           C  
ATOM     69  CD  ARG     8       7.465  47.406  12.982  1.00 28.18           C  
ATOM     70  NE  ARG     8       7.941  47.887  11.680  1.00 30.83           N  
ATOM     71  CZ  ARG     8       8.710  48.960  11.501  1.00 30.42           C  
ATOM     72  NH1 ARG     8       9.117  49.682  12.536  1.00 32.52           N  
ATOM     73  NH2 ARG     8       9.060  49.316  10.274  1.00 29.09           N  
ATOM     74  N   PHE     9      12.184  44.376  13.397  1.00 15.44           N  
ATOM     75  CA  PHE     9      13.609  44.661  13.228  1.00 14.36           C  
ATOM     76  C   PHE     9      14.024  44.617  11.750  1.00 14.07           C  
ATOM     77  O   PHE     9      13.327  44.021  10.922  1.00 14.11           O  
ATOM     78  CB  PHE     9      14.503  43.808  14.139  1.00 14.06           C  
ATOM     79  CG  PHE     9      14.646  42.339  13.723  1.00 14.99           C  
ATOM     80  CD1 PHE     9      15.716  41.917  12.893  1.00 14.73           C  
ATOM     81  CD2 PHE     9      13.778  41.373  14.237  1.00 14.99           C  
ATOM     82  CE1 PHE     9      15.873  40.529  12.575  1.00 15.03           C  
ATOM     83  CE2 PHE     9      13.931  40.017  13.902  1.00 13.86           C  
ATOM     84  CZ  PHE     9      14.979  39.616  13.065  1.00 15.53           C  
ATOM     85  N   ALA    10      15.107  45.315  11.432  1.00 13.59           N  
ATOM     86  CA  ALA    10      15.614  45.381  10.074  1.00 13.29           C  
ATOM     87  C   ALA    10      16.736  44.351   9.943  1.00 12.11           C  
ATOM     88  O   ALA    10      17.515  44.114  10.867  1.00 12.79           O  
ATOM     89  CB  ALA    10      16.127  46.747   9.770  1.00 13.92           C  
ATOM     90  N   LEU    11      16.820  43.776   8.765  1.00 11.89           N  
ATOM     91  CA  LEU    11      17.884  42.825   8.461  1.00 11.66           C  
ATOM     92  C   LEU    11      18.479  43.206   7.106  1.00 11.25           C  
ATOM     93  O   LEU    11      17.791  43.100   6.088  1.00 11.70           O  
ATOM     94  CB  LEU    11      17.268  41.424   8.382  1.00 11.80           C  
ATOM     95  CG  LEU    11      18.199  40.311   7.867  1.00 11.81           C  
ATOM     96  CD1 LEU    11      19.499  40.184   8.709  1.00 11.54           C  
ATOM     97  CD2 LEU    11      17.431  38.946   7.835  1.00 11.16           C  
ATOM     98  N   THR    12      19.739  43.651   7.093  1.00 11.06           N  
ATOM     99  CA  THR    12      20.437  43.941   5.843  1.00 10.80           C  
ATOM    100  C   THR    12      21.431  42.812   5.554  1.00 10.75           C  
ATOM    101  O   THR    12      22.268  42.492   6.427  1.00 10.78           O  
ATOM    102  CB  THR    12      21.207  45.258   5.979  1.00 12.04           C  
ATOM    103  OG1 THR    12      20.261  46.309   6.268  1.00 13.87           O  
ATOM    104  CG2 THR    12      21.944  45.545   4.716  1.00 11.84           C  
ATOM    105  N   VAL    13      21.329  42.215   4.366  1.00 10.59           N  
ATOM    106  CA  VAL    13      22.159  41.059   3.976  1.00 10.00           C  
ATOM    107  C   VAL    13      23.009  41.448   2.754  1.00 10.55           C  
ATOM    108  O   VAL    13      22.471  41.918   1.733  1.00 10.36           O  
ATOM    109  CB  VAL    13      21.256  39.828   3.638  1.00 10.02           C  
ATOM    110  CG1 VAL    13      22.153  38.561   3.516  1.00  9.93           C  
ATOM    111  CG2 VAL    13      20.243  39.644   4.736  1.00 12.14           C  
ATOM    112  N   VAL    14      24.327  41.288   2.872  1.00 10.61           N  
ATOM    113  CA  VAL    14      25.251  41.780   1.877  1.00 10.14           C  
ATOM    114  C   VAL    14      26.202  40.645   1.457  1.00 10.94           C  
ATOM    115  O   VAL    14      26.790  40.007   2.325  1.00 10.94           O  
ATOM    116  CB  VAL    14      26.075  42.959   2.446  1.00 11.36           C  
ATOM    117  CG1 VAL    14      27.056  43.456   1.382  1.00  9.89           C  
ATOM    118  CG2 VAL    14      25.134  44.137   2.849  1.00 12.81           C  
ATOM    119  N   ARG    15      26.318  40.368   0.158  1.00 10.04           N  
ATOM    120  CA  ARG    15      27.289  39.336  -0.282  1.00 10.79           C  
ATOM    121  C   ARG    15      28.699  39.909  -0.117  1.00 10.29           C  
ATOM    122  O   ARG    15      28.904  41.106  -0.283  1.00 11.57           O  
ATOM    123  CB  ARG    15      27.048  38.936  -1.768  1.00  9.43           C  
ATOM    124  CG  ARG    15      28.024  37.834  -2.263  1.00 11.35           C  
ATOM    125  CD  ARG    15      27.585  37.222  -3.602  1.00 12.46           C  
ATOM    126  NE  ARG    15      28.624  36.330  -4.093  1.00 13.39           N  
ATOM    127  CZ  ARG    15      29.143  36.335  -5.318  1.00 15.37           C  
ATOM    128  NH1 ARG    15      28.674  37.137  -6.260  1.00 14.12           N  
ATOM    129  NH2 ARG    15      30.131  35.500  -5.608  1.00 13.89           N  
ATOM    130  N   HIS    16      29.679  39.062   0.166  1.00 11.14           N  
ATOM    131  CA  HIS    16      31.080  39.515   0.244  1.00 11.40           C  
ATOM    132  C   HIS    16      31.557  40.087  -1.118  1.00 12.40           C  
ATOM    133  O   HIS    16      30.975  39.795  -2.202  1.00 12.27           O  
ATOM    134  CB  HIS    16      31.969  38.326   0.622  1.00 11.89           C  
ATOM    135  CG  HIS    16      31.909  37.244  -0.383  1.00 11.77           C  
ATOM    136  ND1 HIS    16      32.675  37.259  -1.532  1.00 10.88           N  
ATOM    137  CD2 HIS    16      31.113  36.155  -0.466  1.00 14.23           C  
ATOM    138  CE1 HIS    16      32.387  36.191  -2.256  1.00 16.26           C  
ATOM    139  NE2 HIS    16      31.442  35.506  -1.630  1.00 14.39           N  
ATOM    140  N   GLY    17      32.636  40.876  -1.055  1.00 12.57           N  
ATOM    141  CA  GLY    17      33.265  41.387  -2.260  1.00 12.64           C  
ATOM    142  C   GLY    17      33.923  40.326  -3.120  1.00 13.60           C  
ATOM    143  O   GLY    17      34.100  39.176  -2.698  1.00 12.67           O  
ATOM    144  N   GLU    18      34.245  40.696  -4.356  1.00 12.79           N  
ATOM    145  CA  GLU    18      34.855  39.768  -5.308  1.00 14.33           C  
ATOM    146  C   GLU    18      36.181  39.161  -4.816  1.00 14.19           C  
ATOM    147  O   GLU    18      36.985  39.853  -4.170  1.00 13.24           O  
ATOM    148  CB  GLU    18      35.072  40.498  -6.641  1.00 15.58           C  
ATOM    149  CG  GLU    18      35.615  39.646  -7.737  1.00 18.58           C  
ATOM    150  CD  GLU    18      36.423  40.473  -8.747  1.00 26.24           C  
ATOM    151  OE1 GLU    18      37.548  40.925  -8.432  1.00 28.76           O  
ATOM    152  OE2 GLU    18      35.935  40.634  -9.857  1.00 27.17           O  
ATOM    153  N   THR    19      36.361  37.856  -5.065  1.00 14.63           N  
ATOM    154  CA  THR    19      37.661  37.193  -4.893  1.00 15.69           C  
ATOM    155  C   THR    19      38.223  36.845  -6.260  1.00 16.12           C  
ATOM    156  O   THR    19      37.525  36.893  -7.282  1.00 15.11           O  
ATOM    157  CB  THR    19      37.572  35.837  -4.120  1.00 14.87           C  
ATOM    158  OG1 THR    19      36.910  34.873  -4.955  1.00 16.55           O  
ATOM    159  CG2 THR    19      36.837  35.983  -2.742  1.00 12.93           C  
ATOM    160  N   ARG    20      39.495  36.453  -6.260  1.00 16.97           N  
ATOM    161  CA  ARG    20      40.161  35.912  -7.443  1.00 18.93           C  
ATOM    162  C   ARG    20      39.322  34.822  -8.158  1.00 19.29           C  
ATOM    163  O   ARG    20      39.202  34.812  -9.396  1.00 20.04           O  
ATOM    164  CB  ARG    20      41.546  35.408  -6.992  1.00 19.32           C  
ATOM    165  CG  ARG    20      42.275  34.361  -7.777  1.00 22.18           C  
ATOM    166  CD  ARG    20      43.709  34.338  -7.214  1.00 21.66           C  
ATOM    167  NE  ARG    20      43.840  33.443  -6.063  1.00 20.51           N  
ATOM    168  CZ  ARG    20      44.436  32.262  -6.102  1.00 22.87           C  
ATOM    169  NH1 ARG    20      44.481  31.517  -5.016  1.00 24.91           N  
ATOM    170  NH2 ARG    20      44.975  31.823  -7.228  1.00 23.22           N  
ATOM    171  N   PHE    21      38.714  33.939  -7.373  1.00 17.76           N  
ATOM    172  CA  PHE    21      37.948  32.834  -7.941  1.00 17.97           C  
ATOM    173  C   PHE    21      36.604  33.277  -8.506  1.00 17.74           C  
ATOM    174  O   PHE    21      36.151  32.759  -9.544  1.00 16.99           O  
ATOM    175  CB  PHE    21      37.833  31.701  -6.911  1.00 19.01           C  
ATOM    176  CG  PHE    21      39.181  31.131  -6.530  1.00 20.00           C  
ATOM    177  CD1 PHE    21      40.117  30.838  -7.512  1.00 23.92           C  
ATOM    178  CD2 PHE    21      39.525  30.940  -5.202  1.00 24.47           C  
ATOM    179  CE1 PHE    21      41.375  30.310  -7.171  1.00 24.93           C  
ATOM    180  CE2 PHE    21      40.774  30.412  -4.859  1.00 25.63           C  
ATOM    181  CZ  PHE    21      41.691  30.099  -5.842  1.00 24.75           C  
ATOM    182  N   ASN    22      35.962  34.229  -7.840  1.00 17.57           N  
ATOM    183  CA  ASN    22      34.719  34.794  -8.414  1.00 18.52           C  
ATOM    184  C   ASN    22      34.988  35.351  -9.818  1.00 19.89           C  
ATOM    185  O   ASN    22      34.228  35.105 -10.771  1.00 19.51           O  
ATOM    186  CB  ASN    22      34.190  35.907  -7.554  1.00 18.37           C  
ATOM    187  CG  ASN    22      33.602  35.407  -6.245  1.00 19.37           C  
ATOM    188  OD1 ASN    22      33.150  34.237  -6.104  1.00 18.97           O  
ATOM    189  ND2 ASN    22      33.568  36.286  -5.301  1.00 13.55           N  
ATOM    190  N   LYS    23      36.093  36.074  -9.948  1.00 20.75           N  
ATOM    191  CA  LYS    23      36.443  36.692 -11.235  1.00 23.46           C  
ATOM    192  C   LYS    23      36.623  35.624 -12.306  1.00 24.29           C  
ATOM    193  O   LYS    23      36.138  35.776 -13.428  1.00 25.47           O  
ATOM    194  CB  LYS    23      37.690  37.556 -11.072  1.00 23.52           C  
ATOM    195  CG  LYS    23      38.222  38.212 -12.349  1.00 27.47           C  
ATOM    196  CD  LYS    23      37.326  39.322 -12.822  1.00 32.44           C  
ATOM    197  CE  LYS    23      38.108  40.299 -13.700  1.00 35.21           C  
ATOM    198  NZ  LYS    23      37.221  41.431 -14.082  1.00 39.24           N  
ATOM    199  N   GLU    24      37.280  34.531 -11.936  1.00 25.02           N  
ATOM    200  CA  GLU    24      37.646  33.470 -12.881  1.00 26.99           C  
ATOM    201  C   GLU    24      36.574  32.393 -13.025  1.00 26.34           C  
ATOM    202  O   GLU    24      36.802  31.393 -13.728  1.00 27.71           O  
ATOM    203  CB  GLU    24      38.981  32.836 -12.465  1.00 27.65           C  
ATOM    204  CG  GLU    24      40.141  33.811 -12.232  1.00 30.31           C  
ATOM    205  CD  GLU    24      40.401  34.779 -13.408  1.00 36.92           C  
ATOM    206  OE1 GLU    24      40.063  34.451 -14.569  1.00 38.73           O  
ATOM    207  OE2 GLU    24      40.950  35.884 -13.159  1.00 38.71           O  
ATOM    208  N   LYS    25      35.421  32.604 -12.378  1.00 25.57           N  
ATOM    209  CA  LYS    25      34.277  31.667 -12.408  1.00 24.89           C  
ATOM    210  C   LYS    25      34.691  30.274 -11.910  1.00 22.95           C  
ATOM    211  O   LYS    25      34.323  29.237 -12.514  1.00 24.07           O  
ATOM    212  CB  LYS    25      33.655  31.563 -13.820  1.00 26.00           C  
ATOM    213  CG  LYS    25      33.068  32.889 -14.367  1.00 30.31           C  
ATOM    214  CD  LYS    25      31.531  32.954 -14.285  1.00 37.00           C  
ATOM    215  CE  LYS    25      30.851  32.201 -15.442  1.00 39.72           C  
ATOM    216  NZ  LYS    25      29.358  32.126 -15.292  1.00 41.81           N  
ATOM    217  N   ILE    26      35.474  30.269 -10.834  1.00 20.24           N  
ATOM    218  CA  ILE    26      35.921  29.042 -10.172  0.50 19.68           C  
ATOM    220  C   ILE    26      35.057  28.826  -8.941  1.00 18.78           C  
ATOM    221  O   ILE    26      34.810  29.759  -8.172  1.00 18.27           O  
ATOM    222  CB  ILE    26      37.425  29.134  -9.782  0.50 19.24           C  
ATOM    224  CG1 ILE    26      38.297  29.028 -11.046  0.50 20.15           C  
ATOM    226  CG2 ILE    26      37.834  28.074  -8.758  0.50 19.79           C  
ATOM    228  CD1 ILE    26      39.716  29.509 -10.829  0.50 19.10           C  
ATOM    230  N   ILE    27      34.588  27.598  -8.779  1.00 17.64           N  
ATOM    231  CA  ILE    27      33.708  27.274  -7.670  0.50 17.31           C  
ATOM    233  C   ILE    27      34.422  27.476  -6.353  1.00 17.86           C  
ATOM    234  O   ILE    27      35.542  27.019  -6.154  1.00 16.33           O  
ATOM    235  CB  ILE    27      33.170  25.849  -7.774  0.50 16.83           C  
ATOM    237  CG1 ILE    27      32.426  25.673  -9.102  0.50 18.12           C  
ATOM    239  CG2 ILE    27      32.228  25.543  -6.610  0.50 15.69           C  
ATOM    241  CD1 ILE    27      32.230  24.258  -9.481  0.50 17.55           C  
ATOM    243  N   GLN    28      33.712  28.157  -5.457  1.00 19.94           N  
ATOM    244  CA  GLN    28      34.188  28.558  -4.186  1.00 21.00           C  
ATOM    245  C   GLN    28      33.026  28.413  -3.207  1.00 20.63           C  
ATOM    246  O   GLN    28      32.128  29.284  -3.155  1.00 21.79           O  
ATOM    247  CB  GLN    28      34.493  30.038  -4.326  1.00 22.79           C  
ATOM    248  CG  GLN    28      35.186  30.690  -3.187  1.00 25.95           C  
ATOM    249  CD  GLN    28      35.402  32.143  -3.518  1.00 23.19           C  
ATOM    250  OE1 GLN    28      34.439  32.916  -3.650  1.00 26.05           O  
ATOM    251  NE2 GLN    28      36.658  32.528  -3.684  1.00 18.04           N  
ATOM    252  N   GLY    29      33.023  27.314  -2.470  1.00 18.42           N  
ATOM    253  CA  GLY    29      32.073  27.123  -1.387  1.00 18.14           C  
ATOM    254  C   GLY    29      32.830  27.131  -0.072  1.00 18.33           C  
ATOM    255  O   GLY    29      33.116  28.190   0.473  1.00 18.58           O  
ATOM    256  N   GLN    30      33.180  25.950   0.427  1.00 18.10           N  
ATOM    257  CA  GLN    30      33.966  25.825   1.659  1.00 19.44           C  
ATOM    258  C   GLN    30      35.303  25.107   1.278  1.00 21.53           C  
ATOM    259  O   GLN    30      35.699  24.135   1.898  1.00 22.52           O  
ATOM    260  CB  GLN    30      33.146  25.074   2.757  1.00 18.80           C  
ATOM    261  CG  GLN    30      31.821  25.772   3.166  1.00 17.51           C  
ATOM    262  CD  GLN    30      31.107  25.155   4.393  1.00 18.30           C  
ATOM    263  OE1 GLN    30      31.751  24.637   5.332  1.00 17.71           O  
ATOM    264  NE2 GLN    30      29.785  25.260   4.418  1.00 15.39           N  
ATOM    265  N   GLY    31      35.971  25.592   0.233  1.00 23.08           N  
ATOM    266  CA  GLY    31      37.221  24.988  -0.236  1.00 24.28           C  
ATOM    267  C   GLY    31      38.442  25.756   0.219  1.00 24.89           C  
ATOM    268  O   GLY    31      38.798  25.700   1.396  1.00 24.91           O  
ATOM    269  N   VAL    32      39.121  26.439  -0.706  1.00 24.97           N  
ATOM    270  CA  VAL    32      40.138  27.382  -0.288  1.00 24.40           C  
ATOM    271  C   VAL    32      39.368  28.547   0.340  1.00 22.92           C  
ATOM    272  O   VAL    32      38.374  29.027  -0.170  1.00 23.11           O  
ATOM    273  CB  VAL    32      41.112  27.879  -1.434  1.00 25.58           C  
ATOM    274  CG1 VAL    32      41.796  29.243  -1.078  1.00 25.76           C  
ATOM    275  CG2 VAL    32      42.175  26.840  -1.736  1.00 26.45           C  
ATOM    276  N   ASP    33      39.840  28.949   1.490  1.00 21.48           N  
ATOM    277  CA  ASP    33      39.335  30.116   2.151  1.00 19.20           C  
ATOM    278  C   ASP    33      40.047  31.316   1.497  1.00 17.34           C  
ATOM    279  O   ASP    33      41.003  31.846   2.054  1.00 18.03           O  
ATOM    280  CB  ASP    33      39.747  29.960   3.601  1.00 18.89           C  
ATOM    281  CG  ASP    33      39.039  30.875   4.486  1.00 18.74           C  
ATOM    282  OD1 ASP    33      38.258  31.695   3.971  1.00 16.19           O  
ATOM    283  OD2 ASP    33      39.269  30.786   5.698  1.00 18.51           O  
ATOM    284  N   GLU    34      39.564  31.721   0.315  1.00 16.16           N  
ATOM    285  CA  GLU    34      40.199  32.771  -0.530  1.00 13.68           C  
ATOM    286  C   GLU    34      39.829  34.184  -0.062  1.00 13.01           C  
ATOM    287  O   GLU    34      38.658  34.481   0.182  1.00 12.76           O  
ATOM    288  CB  GLU    34      39.758  32.569  -1.988  1.00 13.32           C  
ATOM    289  CG  GLU    34      40.392  33.542  -2.987  1.00 14.27           C  
ATOM    290  CD  GLU    34      41.895  33.337  -3.121  1.00 17.56           C  
ATOM    291  OE1 GLU    34      42.406  32.292  -2.657  1.00 16.95           O  
ATOM    292  OE2 GLU    34      42.561  34.222  -3.687  1.00 14.35           O  
ATOM    293  N   PRO    35      40.816  35.087   0.038  1.00 12.61           N  
ATOM    294  CA  PRO    35      40.519  36.460   0.441  1.00 12.40           C  
ATOM    295  C   PRO    35      39.941  37.281  -0.696  1.00 12.19           C  
ATOM    296  O   PRO    35      39.870  36.798  -1.836  1.00 12.16           O  
ATOM    297  CB  PRO    35      41.903  37.012   0.800  1.00 13.18           C  
ATOM    298  CG  PRO    35      42.830  36.282  -0.091  1.00 11.73           C  
ATOM    299  CD  PRO    35      42.257  34.876  -0.197  1.00 12.29           C  
ATOM    300  N   LEU    36      39.553  38.525  -0.381  1.00 13.27           N  
ATOM    301  CA  LEU    36      39.129  39.442  -1.419  1.00 13.91           C  
ATOM    302  C   LEU    36      40.288  39.748  -2.367  1.00 14.60           C  
ATOM    303  O   LEU    36      41.477  39.720  -1.959  1.00 15.26           O  
ATOM    304  CB  LEU    36      38.660  40.730  -0.791  1.00 13.30           C  
ATOM    305  CG  LEU    36      37.476  40.669   0.167  1.00 11.16           C  
ATOM    306  CD1 LEU    36      37.120  42.084   0.644  1.00 12.32           C  
ATOM    307  CD2 LEU    36      36.294  40.061  -0.606  1.00 14.18           C  
ATOM    308  N   SER    37      39.942  40.002  -3.627  1.00 14.66           N  
ATOM    309  CA  SER    37      40.887  40.588  -4.581  1.00 15.07           C  
ATOM    310  C   SER    37      40.955  42.115  -4.361  1.00 16.18           C  
ATOM    311  O   SER    37      40.191  42.650  -3.561  1.00 15.86           O  
ATOM    312  CB  SER    37      40.387  40.310  -5.990  1.00 15.28           C  
ATOM    313  OG  SER    37      39.163  40.991  -6.245  1.00 15.00           O  
ATOM    314  N   GLU    38      41.843  42.819  -5.053  0.50 16.90           N  
ATOM    316  CA  GLU    38      41.822  44.275  -4.919  0.50 17.68           C  
ATOM    318  C   GLU    38      40.468  44.909  -5.349  0.50 17.34           C  
ATOM    320  O   GLU    38      39.992  45.839  -4.683  0.50 16.87           O  
ATOM    322  CB  GLU    38      43.062  44.905  -5.555  0.50 18.44           C  
ATOM    324  CG  GLU    38      44.363  44.465  -4.861  0.50 20.32           C  
ATOM    326  CD  GLU    38      44.498  45.003  -3.442  0.50 23.44           C  
ATOM    328  OE1 GLU    38      44.550  46.248  -3.280  0.50 23.55           O  
ATOM    330  OE2 GLU    38      44.564  44.191  -2.493  0.50 20.46           O  
ATOM    332  N   THR    39      39.818  44.357  -6.381  1.00 17.89           N  
ATOM    333  CA  THR    39      38.442  44.762  -6.739  1.00 18.70           C  
ATOM    334  C   THR    39      37.477  44.495  -5.573  1.00 17.31           C  
ATOM    335  O   THR    39      36.641  45.350  -5.250  1.00 16.75           O  
ATOM    336  CB  THR    39      37.965  44.078  -8.026  1.00 19.07           C  
ATOM    337  OG1 THR    39      38.780  44.507  -9.123  1.00 23.74           O  
ATOM    338  CG2 THR    39      36.491  44.402  -8.353  1.00 21.10           C  
ATOM    339  N   GLY    40      37.635  43.343  -4.911  1.00 16.64           N  
ATOM    340  CA  GLY    40      36.796  43.013  -3.755  1.00 15.47           C  
ATOM    341  C   GLY    40      36.961  43.990  -2.593  1.00 15.29           C  
ATOM    342  O   GLY    40      35.992  44.422  -1.961  1.00 14.78           O  
ATOM    343  N   PHE    41      38.204  44.362  -2.311  1.00 14.84           N  
ATOM    344  CA  PHE    41      38.482  45.341  -1.283  1.00 16.00           C  
ATOM    345  C   PHE    41      37.857  46.706  -1.643  1.00 15.44           C  
ATOM    346  O   PHE    41      37.278  47.347  -0.781  1.00 16.26           O  
ATOM    347  CB  PHE    41      39.994  45.489  -1.080  1.00 16.48           C  
ATOM    348  CG  PHE    41      40.600  44.395  -0.260  1.00 16.72           C  
ATOM    349  CD1 PHE    41      40.213  44.206   1.066  1.00 16.36           C  
ATOM    350  CD2 PHE    41      41.607  43.599  -0.798  1.00 18.31           C  
ATOM    351  CE1 PHE    41      40.788  43.184   1.839  1.00 17.37           C  
ATOM    352  CE2 PHE    41      42.194  42.576  -0.035  1.00 17.66           C  
ATOM    353  CZ  PHE    41      41.779  42.378   1.287  1.00 17.32           C  
ATOM    354  N   LYS    42      37.973  47.118  -2.900  1.00 15.99           N  
ATOM    355  CA  LYS    42      37.278  48.329  -3.408  1.00 17.34           C  
ATOM    356  C   LYS    42      35.755  48.273  -3.244  1.00 17.57           C  
ATOM    357  O   LYS    42      35.146  49.256  -2.833  1.00 16.74           O  
ATOM    358  CB  LYS    42      37.634  48.638  -4.865  1.00 18.01           C  
ATOM    359  CG  LYS    42      39.093  49.050  -5.043  1.00 21.90           C  
ATOM    360  CD  LYS    42      39.416  49.194  -6.520  1.00 25.92           C  
ATOM    361  CE  LYS    42      40.607  50.124  -6.698  1.00 31.54           C  
ATOM    362  NZ  LYS    42      40.793  50.449  -8.144  1.00 35.78           N  
ATOM    363  N   GLN    43      35.141  47.130  -3.560  1.00 17.23           N  
ATOM    364  CA  GLN    43      33.689  46.988  -3.408  1.00 16.65           C  
ATOM    365  C   GLN    43      33.281  47.098  -1.934  1.00 16.50           C  
ATOM    366  O   GLN    43      32.313  47.778  -1.603  1.00 15.99           O  
ATOM    367  CB  GLN    43      33.204  45.648  -3.998  1.00 17.02           C  
ATOM    368  CG  GLN    43      33.434  45.511  -5.503  1.00 14.54           C  
ATOM    369  CD  GLN    43      33.179  44.106  -6.005  1.00 17.25           C  
ATOM    370  OE1 GLN    43      33.287  43.143  -5.240  1.00 15.36           O  
ATOM    371  NE2 GLN    43      32.798  43.981  -7.286  1.00 17.54           N  
ATOM    372  N   ALA    44      34.049  46.460  -1.053  1.00 17.00           N  
ATOM    373  CA  ALA    44      33.780  46.481   0.362  1.00 18.25           C  
ATOM    374  C   ALA    44      33.894  47.920   0.893  1.00 18.29           C  
ATOM    375  O   ALA    44      33.071  48.365   1.710  1.00 19.67           O  
ATOM    376  CB  ALA    44      34.726  45.538   1.082  1.00 18.12           C  
ATOM    377  N   ALA    45      34.879  48.659   0.370  1.00 18.75           N  
ATOM    378  CA  ALA    45      35.095  50.055   0.802  1.00 18.36           C  
ATOM    379  C   ALA    45      33.906  50.917   0.356  1.00 17.22           C  
ATOM    380  O   ALA    45      33.358  51.719   1.139  1.00 18.63           O  
ATOM    381  CB  ALA    45      36.430  50.601   0.207  1.00 18.25           C  
ATOM    382  N   ALA    46      33.485  50.718  -0.884  1.00 17.27           N  
ATOM    383  CA  ALA    46      32.370  51.440  -1.471  1.00 17.55           C  
ATOM    384  C   ALA    46      31.100  51.155  -0.685  1.00 18.90           C  
ATOM    385  O   ALA    46      30.296  52.059  -0.395  1.00 17.88           O  
ATOM    386  CB  ALA    46      32.196  51.040  -2.903  1.00 18.02           C  
ATOM    387  N   ALA    47      30.886  49.882  -0.369  1.00 17.73           N  
ATOM    388  CA  ALA    47      29.743  49.513   0.469  1.00 18.26           C  
ATOM    389  C   ALA    47      29.810  50.180   1.851  1.00 18.11           C  
ATOM    390  O   ALA    47      28.780  50.598   2.404  1.00 19.38           O  
ATOM    391  CB  ALA    47      29.686  47.977   0.621  1.00 18.48           C  
ATOM    392  N   GLY    48      31.011  50.248   2.408  1.00 18.17           N  
ATOM    393  CA  GLY    48      31.250  50.880   3.714  1.00 19.13           C  
ATOM    394  C   GLY    48      30.921  52.359   3.648  1.00 19.49           C  
ATOM    395  O   GLY    48      30.279  52.887   4.548  1.00 20.37           O  
ATOM    396  N   ILE    49      31.301  53.017   2.557  1.00 21.18           N  
ATOM    397  CA  ILE    49      30.955  54.451   2.406  1.00 21.55           C  
ATOM    398  C   ILE    49      29.445  54.633   2.232  1.00 21.40           C  
ATOM    399  O   ILE    49      28.849  55.497   2.891  1.00 20.53           O  
ATOM    400  CB  ILE    49      31.725  55.134   1.271  1.00 21.92           C  
ATOM    401  CG1 ILE    49      33.240  55.058   1.563  1.00 22.53           C  
ATOM    402  CG2 ILE    49      31.190  56.604   1.066  1.00 23.77           C  
ATOM    403  CD1 ILE    49      34.126  55.098   0.360  1.00 25.96           C  
ATOM    404  N   PHE    50      28.825  53.794   1.396  1.00 20.95           N  
ATOM    405  CA  PHE    50      27.381  53.811   1.189  1.00 20.87           C  
ATOM    406  C   PHE    50      26.614  53.701   2.519  1.00 20.75           C  
ATOM    407  O   PHE    50      25.611  54.421   2.729  1.00 20.09           O  
ATOM    408  CB  PHE    50      26.959  52.675   0.236  1.00 21.75           C  
ATOM    409  CG  PHE    50      25.505  52.713  -0.165  1.00 21.42           C  
ATOM    410  CD1 PHE    50      25.034  53.666  -1.070  1.00 23.70           C  
ATOM    411  CD2 PHE    50      24.615  51.769   0.344  1.00 22.52           C  
ATOM    412  CE1 PHE    50      23.685  53.701  -1.454  1.00 25.31           C  
ATOM    413  CE2 PHE    50      23.278  51.778  -0.020  1.00 20.38           C  
ATOM    414  CZ  PHE    50      22.794  52.747  -0.929  1.00 23.41           C  
ATOM    415  N   LEU    51      27.106  52.823   3.398  1.00 20.65           N  
ATOM    416  CA  LEU    51      26.477  52.528   4.707  1.00 20.31           C  
ATOM    417  C   LEU    51      26.994  53.347   5.909  1.00 20.94           C  
ATOM    418  O   LEU    51      26.689  53.035   7.074  1.00 20.47           O  
ATOM    419  CB  LEU    51      26.620  51.024   5.012  1.00 20.45           C  
ATOM    420  CG  LEU    51      26.018  50.029   4.002  1.00 18.73           C  
ATOM    421  CD1 LEU    51      26.516  48.571   4.293  1.00 17.74           C  
ATOM    422  CD2 LEU    51      24.503  50.071   4.006  1.00 18.95           C  
ATOM    423  N   ASN    52      27.776  54.391   5.646  1.00 22.08           N  
ATOM    424  CA  ASN    52      28.569  54.990   6.714  1.00 24.34           C  
ATOM    425  C   ASN    52      27.711  55.621   7.834  1.00 24.30           C  
ATOM    426  O   ASN    52      28.155  55.738   8.984  1.00 24.66           O  
ATOM    427  CB  ASN    52      29.517  56.037   6.111  1.00 25.39           C  
ATOM    428  CG  ASN    52      28.787  57.295   5.740  1.00 28.11           C  
ATOM    429  OD1 ASN    52      28.587  58.166   6.588  1.00 33.96           O  
ATOM    430  ND2 ASN    52      28.315  57.376   4.501  1.00 29.08           N  
ATOM    431  N   ASN    53      26.498  56.042   7.487  1.00 25.05           N  
ATOM    432  CA  ASN    53      25.632  56.715   8.469  1.00 25.92           C  
ATOM    433  C   ASN    53      24.488  55.833   8.952  1.00 25.06           C  
ATOM    434  O   ASN    53      23.578  56.317   9.638  1.00 25.23           O  
ATOM    435  CB  ASN    53      25.075  58.026   7.904  1.00 27.15           C  
ATOM    436  CG  ASN    53      24.652  58.988   9.000  1.00 30.53           C  
ATOM    437  OD1 ASN    53      25.455  59.349   9.865  1.00 36.72           O  
ATOM    438  ND2 ASN    53      23.382  59.389   8.986  1.00 34.91           N  
ATOM    439  N   VAL    54      24.521  54.547   8.585  1.00 23.11           N  
ATOM    440  CA  VAL    54      23.505  53.626   9.060  1.00 21.47           C  
ATOM    441  C   VAL    54      23.824  53.191  10.471  1.00 21.39           C  
ATOM    442  O   VAL    54      24.938  52.731  10.780  1.00 22.40           O  
ATOM    443  CB  VAL    54      23.363  52.343   8.167  1.00 20.54           C  
ATOM    444  CG1 VAL    54      22.303  51.405   8.775  1.00 20.21           C  
ATOM    445  CG2 VAL    54      22.991  52.714   6.759  1.00 20.99           C  
ATOM    446  N   LYS    55      22.832  53.303  11.339  1.00 21.50           N  
ATOM    447  CA  LYS    55      23.011  52.869  12.707  1.00 22.40           C  
ATOM    448  C   LYS    55      22.615  51.395  12.855  1.00 21.79           C  
ATOM    449  O   LYS    55      21.475  51.073  13.260  1.00 22.74           O  
ATOM    450  CB  LYS    55      22.190  53.741  13.659  1.00 23.17           C  
ATOM    451  CG  LYS    55      22.523  55.236  13.533  1.00 26.63           C  
ATOM    452  CD  LYS    55      22.200  55.945  14.829  1.00 32.13           C  
ATOM    453  CE  LYS    55      22.697  57.386  14.808  1.00 34.40           C  
ATOM    454  NZ  LYS    55      22.953  57.903  16.192  1.00 36.92           N  
ATOM    455  N   PHE    56      23.546  50.503  12.539  1.00 20.73           N  
ATOM    456  CA  PHE    56      23.337  49.078  12.823  1.00 19.15           C  
ATOM    457  C   PHE    56      23.510  48.812  14.304  1.00 19.61           C  
ATOM    458  O   PHE    56      24.285  49.504  15.000  1.00 21.15           O  
ATOM    459  CB  PHE    56      24.321  48.167  12.053  1.00 18.58           C  
ATOM    460  CG  PHE    56      24.172  48.230  10.567  1.00 17.80           C  
ATOM    461  CD1 PHE    56      23.018  47.719   9.935  1.00 14.64           C  
ATOM    462  CD2 PHE    56      25.183  48.753   9.779  1.00 16.61           C  
ATOM    463  CE1 PHE    56      22.881  47.789   8.533  1.00 14.77           C  
ATOM    464  CE2 PHE    56      25.061  48.793   8.381  1.00 16.45           C  
ATOM    465  CZ  PHE    56      23.904  48.324   7.749  1.00 14.90           C  
ATOM    466  N   THR    57      22.861  47.749  14.765  1.00 17.09           N  
ATOM    467  CA  THR    57      22.898  47.326  16.146  1.00 16.54           C  
ATOM    468  C   THR    57      23.611  45.992  16.347  1.00 16.67           C  
ATOM    469  O   THR    57      24.075  45.688  17.445  1.00 17.10           O  
ATOM    470  CB  THR    57      21.474  47.200  16.744  1.00 17.55           C  
ATOM    471  OG1 THR    57      20.692  46.278  15.957  1.00 14.51           O  
ATOM    472  CG2 THR    57      20.772  48.546  16.751  1.00 15.49           C  
ATOM    473  N   HIS    58      23.659  45.185  15.272  1.00 15.40           N  
ATOM    474  CA  HIS    58      24.258  43.857  15.350  1.00 14.88           C  
ATOM    475  C   HIS    58      24.974  43.589  14.027  1.00 14.04           C  
ATOM    476  O   HIS    58      24.557  44.082  12.977  1.00 13.96           O  
ATOM    477  CB  HIS    58      23.178  42.780  15.466  1.00 13.38           C  
ATOM    478  CG  HIS    58      22.385  42.839  16.735  1.00 14.77           C  
ATOM    479  ND1 HIS    58      21.409  43.785  16.961  1.00 15.83           N  
ATOM    480  CD2 HIS    58      22.419  42.059  17.838  1.00 15.46           C  
ATOM    481  CE1 HIS    58      20.892  43.595  18.164  1.00 17.07           C  
ATOM    482  NE2 HIS    58      21.460  42.535  18.700  1.00 15.53           N  
ATOM    483  N   ALA    59      26.044  42.806  14.100  1.00 13.04           N  
ATOM    484  CA  ALA    59      26.787  42.411  12.878  1.00 13.95           C  
ATOM    485  C   ALA    59      27.139  40.942  12.968  1.00 14.25           C  
ATOM    486  O   ALA    59      27.758  40.502  13.951  1.00 14.77           O  
ATOM    487  CB  ALA    59      28.058  43.213  12.703  1.00 14.18           C  
ATOM    488  N   PHE    60      26.778  40.185  11.930  1.00 12.96           N  
ATOM    489  CA  PHE    60      27.139  38.760  11.816  1.00 12.74           C  
ATOM    490  C   PHE    60      27.780  38.498  10.478  1.00 12.41           C  
ATOM    491  O   PHE    60      27.340  39.056   9.465  1.00 13.16           O  
ATOM    492  CB  PHE    60      25.911  37.831  11.919  1.00 13.31           C  
ATOM    493  CG  PHE    60      25.207  37.891  13.256  1.00 13.17           C  
ATOM    494  CD1 PHE    60      25.482  36.946  14.244  1.00 15.99           C  
ATOM    495  CD2 PHE    60      24.249  38.868  13.490  1.00 16.08           C  
ATOM    496  CE1 PHE    60      24.827  36.980  15.485  1.00 17.65           C  
ATOM    497  CE2 PHE    60      23.575  38.909  14.728  1.00 17.11           C  
ATOM    498  CZ  PHE    60      23.877  37.976  15.714  1.00 15.95           C  
ATOM    499  N   SER    61      28.775  37.602  10.451  1.00 11.13           N  
ATOM    500  CA  SER    61      29.467  37.297   9.202  1.00 12.21           C  
ATOM    501  C   SER    61      29.727  35.794   9.216  1.00 11.56           C  
ATOM    502  O   SER    61      29.983  35.205  10.263  1.00 12.53           O  
ATOM    503  CB  SER    61      30.800  38.071   9.126  1.00 11.54           C  
ATOM    504  OG  SER    61      31.557  37.684   7.995  1.00 14.79           O  
ATOM    505  N   SER    62      29.687  35.174   8.047  1.00 10.94           N  
ATOM    506  CA  SER    62      30.357  33.901   7.851  1.00 11.59           C  
ATOM    507  C   SER    62      31.798  33.973   8.360  1.00 11.84           C  
ATOM    508  O   SER    62      32.420  35.019   8.272  1.00 11.46           O  
ATOM    509  CB  SER    62      30.392  33.669   6.338  1.00 12.08           C  
ATOM    510  OG  SER    62      31.297  32.701   6.015  1.00 16.57           O  
ATOM    511  N   ASP    63      32.276  32.831   8.853  0.50 12.21           N  
ATOM    513  CA  ASP    63      33.641  32.659   9.378  0.50 13.48           C  
ATOM    515  C   ASP    63      34.594  32.183   8.266  0.50 13.52           C  
ATOM    517  O   ASP    63      35.392  31.242   8.442  0.50 13.40           O  
ATOM    519  CB  ASP    63      33.669  31.742  10.624  0.50 13.93           C  
ATOM    521  CG  ASP    63      33.182  30.313  10.355  0.50 14.36           C  
ATOM    523  OD1 ASP    63      32.267  30.105   9.530  0.50 10.93           O  
ATOM    525  OD2 ASP    63      33.724  29.377  10.988  0.50 15.00           O  
ATOM    527  N   LEU    64      34.455  32.830   7.104  1.00 14.85           N  
ATOM    528  CA  LEU    64      35.372  32.683   5.974  1.00 14.13           C  
ATOM    529  C   LEU    64      36.040  34.045   5.711  1.00 13.74           C  
ATOM    530  O   LEU    64      35.487  35.081   6.092  1.00 12.53           O  
ATOM    531  CB  LEU    64      34.610  32.144   4.735  1.00 14.06           C  
ATOM    532  CG  LEU    64      34.112  30.684   4.857  1.00 15.57           C  
ATOM    533  CD1 LEU    64      33.222  30.172   3.726  1.00 16.81           C  
ATOM    534  CD2 LEU    64      35.373  29.730   5.011  1.00 16.50           C  
ATOM    535  N   MET    65      37.244  34.054   5.120  1.00 13.80           N  
ATOM    536  CA  MET    65      37.997  35.312   4.978  1.00 14.27           C  
ATOM    537  C   MET    65      37.259  36.328   4.141  1.00 12.80           C  
ATOM    538  O   MET    65      37.249  37.513   4.483  1.00 12.68           O  
ATOM    539  CB  MET    65      39.344  35.088   4.268  1.00 14.39           C  
ATOM    540  CG  MET    65      40.368  34.551   5.151  1.00 19.40           C  
ATOM    541  SD  MET    65      42.061  34.816   4.234  1.00 17.57          SE  
ATOM    542  CE  MET    65      42.703  36.459   4.953  1.00 18.75           C  
ATOM    543  N   ARG    66      36.664  35.878   3.035  1.00 11.81           N  
ATOM    544  CA  ARG    66      36.066  36.820   2.071  1.00 11.30           C  
ATOM    545  C   ARG    66      34.928  37.632   2.693  1.00 12.24           C  
ATOM    546  O   ARG    66      34.802  38.856   2.479  1.00 11.93           O  
ATOM    547  CB  ARG    66      35.654  36.107   0.777  1.00 10.46           C  
ATOM    548  CG  ARG    66      34.682  34.894   0.959  1.00 10.29           C  
ATOM    549  CD  ARG    66      34.627  34.203  -0.373  1.00 12.79           C  
ATOM    550  NE  ARG    66      33.700  33.054  -0.470  1.00 11.27           N  
ATOM    551  CZ  ARG    66      33.988  31.816  -0.053  1.00 14.16           C  
ATOM    552  NH1 ARG    66      33.126  30.849  -0.290  1.00 12.57           N  
ATOM    553  NH2 ARG    66      35.111  31.536   0.612  1.00 11.25           N  
ATOM    554  N   THR    67      34.149  36.966   3.543  1.00 11.56           N  
ATOM    555  CA  THR    67      33.050  37.640   4.242  1.00 12.08           C  
ATOM    556  C   THR    67      33.622  38.488   5.417  1.00 11.63           C  
ATOM    557  O   THR    67      33.223  39.648   5.611  1.00 12.77           O  
ATOM    558  CB  THR    67      32.050  36.601   4.741  1.00 10.04           C  
ATOM    559  OG1 THR    67      32.796  35.490   5.240  1.00 12.29           O  
ATOM    560  CG2 THR    67      31.131  36.086   3.571  1.00 11.13           C  
ATOM    561  N   LYS    68      34.592  37.937   6.151  1.00 13.01           N  
ATOM    562  CA  LYS    68      35.199  38.673   7.299  1.00 13.10           C  
ATOM    563  C   LYS    68      35.821  40.001   6.795  1.00 11.78           C  
ATOM    564  O   LYS    68      35.613  41.042   7.377  1.00 11.93           O  
ATOM    565  CB  LYS    68      36.239  37.809   8.024  1.00 13.79           C  
ATOM    566  CG  LYS    68      37.010  38.545   9.119  1.00 16.70           C  
ATOM    567  CD  LYS    68      37.820  37.554   9.999  1.00 17.70           C  
ATOM    568  CE  LYS    68      38.271  38.243  11.310  1.00 22.84           C  
ATOM    569  NZ  LYS    68      38.987  37.265  12.187  1.00 25.71           N  
ATOM    570  N   GLN    69      36.578  39.925   5.702  1.00 11.45           N  
ATOM    571  CA  GLN    69      37.230  41.109   5.149  1.00 12.01           C  
ATOM    572  C   GLN    69      36.212  42.128   4.655  1.00 12.80           C  
ATOM    573  O   GLN    69      36.421  43.360   4.776  1.00 12.36           O  
ATOM    574  CB  GLN    69      38.143  40.690   4.024  1.00 11.90           C  
ATOM    575  CG  GLN    69      39.389  39.947   4.540  1.00 11.34           C  
ATOM    576  CD  GLN    69      40.288  39.535   3.414  1.00 14.07           C  
ATOM    577  OE1 GLN    69      39.807  39.100   2.363  1.00 12.32           O  
ATOM    578  NE2 GLN    69      41.613  39.608   3.639  1.00 15.02           N  
ATOM    579  N   THR    70      35.107  41.621   4.080  1.00 12.32           N  
ATOM    580  CA  THR    70      34.067  42.536   3.591  1.00 12.94           C  
ATOM    581  C   THR    70      33.409  43.288   4.778  1.00 12.24           C  
ATOM    582  O   THR    70      33.180  44.519   4.705  1.00 12.26           O  
ATOM    583  CB  THR    70      33.005  41.781   2.757  1.00 12.52           C  
ATOM    584  OG1 THR    70      33.657  41.176   1.623  1.00 12.51           O  
ATOM    585  CG2 THR    70      31.874  42.738   2.253  1.00 11.26           C  
ATOM    586  N   MET    71      33.076  42.532   5.819  1.00 12.95           N  
ATOM    587  CA  MET    71      32.513  43.084   7.054  1.00 14.04           C  
ATOM    588  C   MET    71      33.506  44.129   7.601  1.00 15.16           C  
ATOM    589  O   MET    71      33.100  45.209   8.015  1.00 14.69           O  
ATOM    590  CB  MET    71      32.311  42.000   8.084  1.00 14.72           C  
ATOM    591  CG  MET    71      31.741  42.503   9.416  1.00 16.03           C  
ATOM    592  SD  MET    71      30.009  43.366   9.266  1.00 12.53          SE  
ATOM    593  CE  MET    71      28.976  41.707   9.223  1.00 13.52           C  
ATOM    594  N   HIS    72      34.798  43.805   7.570  1.00 15.73           N  
ATOM    595  CA  HIS    72      35.798  44.765   8.079  1.00 17.92           C  
ATOM    596  C   HIS    72      35.799  46.068   7.279  1.00 18.23           C  
ATOM    597  O   HIS    72      35.806  47.170   7.877  1.00 18.65           O  
ATOM    598  CB  HIS    72      37.197  44.172   8.104  1.00 18.26           C  
ATOM    599  CG  HIS    72      38.231  45.134   8.616  1.00 22.21           C  
ATOM    600  ND1 HIS    72      38.329  45.480   9.946  1.00 26.17           N  
ATOM    601  CD2 HIS    72      39.186  45.851   7.968  1.00 26.64           C  
ATOM    602  CE1 HIS    72      39.323  46.337  10.106  1.00 25.60           C  
ATOM    603  NE2 HIS    72      39.856  46.583   8.920  1.00 28.23           N  
ATOM    604  N   GLY    73      35.786  45.922   5.950  1.00 17.64           N  
ATOM    605  CA  GLY    73      35.749  47.021   4.982  1.00 18.22           C  
ATOM    606  C   GLY    73      34.553  47.914   5.241  1.00 18.59           C  
ATOM    607  O   GLY    73      34.632  49.135   5.137  1.00 17.35           O  
ATOM    608  N   ILE    74      33.422  47.293   5.569  1.00 17.82           N  
ATOM    609  CA  ILE    74      32.208  48.049   5.833  1.00 18.14           C  
ATOM    610  C   ILE    74      32.322  48.766   7.168  1.00 19.12           C  
ATOM    611  O   ILE    74      32.124  49.976   7.216  1.00 20.75           O  
ATOM    612  CB  ILE    74      30.929  47.127   5.787  1.00 17.24           C  
ATOM    613  CG1 ILE    74      30.633  46.719   4.347  1.00 18.41           C  
ATOM    614  CG2 ILE    74      29.716  47.847   6.393  1.00 17.25           C  
ATOM    615  CD1 ILE    74      29.677  45.514   4.249  1.00 17.62           C  
ATOM    616  N   LEU    75      32.660  48.047   8.242  1.00 20.26           N  
ATOM    617  CA  LEU    75      32.654  48.660   9.584  1.00 20.39           C  
ATOM    618  C   LEU    75      33.748  49.711   9.784  1.00 21.93           C  
ATOM    619  O   LEU    75      33.506  50.723  10.442  1.00 21.81           O  
ATOM    620  CB  LEU    75      32.682  47.618  10.687  1.00 20.74           C  
ATOM    621  CG  LEU    75      31.457  46.705  10.768  1.00 18.86           C  
ATOM    622  CD1 LEU    75      31.706  45.688  11.869  1.00 20.32           C  
ATOM    623  CD2 LEU    75      30.175  47.516  10.991  1.00 20.37           C  
ATOM    624  N   GLU    76      34.907  49.519   9.165  1.00 22.34           N  
ATOM    625  CA  GLU    76      35.997  50.479   9.357  1.00 25.10           C  
ATOM    626  C   GLU    76      35.621  51.889   8.865  1.00 25.23           C  
ATOM    627  O   GLU    76      36.219  52.863   9.314  1.00 26.75           O  
ATOM    628  CB  GLU    76      37.318  49.973   8.753  1.00 24.36           C  
ATOM    629  CG  GLU    76      37.476  50.167   7.255  1.00 25.72           C  
ATOM    630  CD  GLU    76      38.694  49.424   6.693  1.00 27.22           C  
ATOM    631  OE1 GLU    76      39.583  49.024   7.479  1.00 30.93           O  
ATOM    632  OE2 GLU    76      38.774  49.240   5.461  1.00 32.26           O  
ATOM    633  N   ARG    77      34.624  51.982   7.977  1.00 25.58           N  
ATOM    634  CA  ARG    77      34.132  53.257   7.427  1.00 26.51           C  
ATOM    635  C   ARG    77      32.831  53.782   8.025  1.00 26.65           C  
ATOM    636  O   ARG    77      32.262  54.749   7.501  1.00 26.66           O  
ATOM    637  CB  ARG    77      33.949  53.141   5.920  1.00 26.38           C  
ATOM    638  CG  ARG    77      35.290  53.011   5.227  1.00 27.67           C  
ATOM    639  CD  ARG    77      35.178  52.485   3.846  1.00 30.97           C  
ATOM    640  NE  ARG    77      36.510  52.433   3.255  1.00 30.98           N  
ATOM    641  CZ  ARG    77      37.312  51.372   3.292  1.00 35.20           C  
ATOM    642  NH1 ARG    77      38.520  51.454   2.715  1.00 36.34           N  
ATOM    643  NH2 ARG    77      36.910  50.228   3.875  1.00 28.89           N  
ATOM    644  N   SER    78      32.357  53.130   9.079  1.00 26.15           N  
ATOM    645  CA  SER    78      31.086  53.486   9.669  1.00 27.03           C  
ATOM    646  C   SER    78      31.300  54.636  10.634  1.00 27.68           C  
ATOM    647  O   SER    78      32.276  54.646  11.391  1.00 27.16           O  
ATOM    648  CB  SER    78      30.468  52.308  10.416  1.00 26.71           C  
ATOM    649  OG  SER    78      29.259  52.707  11.068  1.00 26.27           O  
ATOM    650  N   LYS    79      30.379  55.591  10.600  1.00 29.19           N  
ATOM    651  CA  LYS    79      30.364  56.674  11.605  1.00 30.36           C  
ATOM    652  C   LYS    79      30.015  56.189  13.025  1.00 30.63           C  
ATOM    653  O   LYS    79      30.639  56.613  14.014  1.00 30.77           O  
ATOM    654  CB  LYS    79      29.411  57.772  11.163  1.00 30.35           C  
ATOM    655  CG  LYS    79      29.804  58.387   9.823  1.00 34.19           C  
ATOM    656  CD  LYS    79      28.840  59.478   9.389  1.00 38.11           C  
ATOM    657  CE  LYS    79      29.545  60.497   8.510  1.00 41.68           C  
ATOM    658  NZ  LYS    79      30.320  59.884   7.374  1.00 44.79           N  
ATOM    659  N   PHE    80      29.039  55.283  13.132  1.00 30.30           N  
ATOM    660  CA  PHE    80      28.579  54.815  14.441  1.00 29.95           C  
ATOM    661  C   PHE    80      29.020  53.438  14.871  1.00 29.66           C  
ATOM    662  O   PHE    80      29.052  53.163  16.069  1.00 29.18           O  
ATOM    663  CB  PHE    80      27.053  54.898  14.522  1.00 31.44           C  
ATOM    664  CG  PHE    80      26.530  56.235  14.154  1.00 34.11           C  
ATOM    665  CD1 PHE    80      26.564  57.278  15.077  1.00 37.99           C  
ATOM    666  CD2 PHE    80      26.056  56.478  12.874  1.00 35.72           C  
ATOM    667  CE1 PHE    80      26.106  58.537  14.729  1.00 38.23           C  
ATOM    668  CE2 PHE    80      25.597  57.722  12.519  1.00 39.19           C  
ATOM    669  CZ  PHE    80      25.623  58.758  13.446  1.00 38.01           C  
ATOM    670  N   CYS    81      29.366  52.575  13.910  1.00 28.01           N  
ATOM    671  CA  CYS    81      29.606  51.158  14.197  1.00 27.84           C  
ATOM    672  C   CYS    81      31.044  50.686  13.981  1.00 27.70           C  
ATOM    673  O   CYS    81      31.309  49.485  14.007  1.00 26.84           O  
ATOM    674  CB  CYS    81      28.645  50.276  13.398  1.00 27.28           C  
ATOM    675  SG  CYS    81      26.920  50.779  13.612  1.00 28.89           S  
ATOM    676  N   LYS    82      31.985  51.617  13.832  1.00 27.45           N  
ATOM    677  CA  LYS    82      33.403  51.222  13.766  1.00 28.50           C  
ATOM    678  C   LYS    82      33.834  50.144  14.796  1.00 27.82           C  
ATOM    679  O   LYS    82      34.547  49.182  14.454  1.00 28.25           O  
ATOM    680  CB  LYS    82      34.281  52.465  13.927  1.00 28.86           C  
ATOM    681  CG  LYS    82      35.101  52.816  12.713  1.00 32.47           C  
ATOM    682  CD  LYS    82      36.212  53.785  13.150  1.00 36.51           C  
ATOM    683  CE  LYS    82      37.407  53.769  12.213  1.00 39.21           C  
ATOM    684  NZ  LYS    82      38.422  54.834  12.584  1.00 41.30           N  
ATOM    685  N   ASP    83      33.375  50.304  16.039  1.00 27.50           N  
ATOM    686  CA  ASP    83      33.775  49.512  17.197  1.00 28.02           C  
ATOM    687  C   ASP    83      32.878  48.306  17.488  1.00 27.52           C  
ATOM    688  O   ASP    83      33.135  47.570  18.441  1.00 26.64           O  
ATOM    689  CB  ASP    83      33.731  50.395  18.458  1.00 29.41           C  
ATOM    690  CG  ASP    83      35.074  50.979  18.833  1.00 33.35           C  
ATOM    691  OD1 ASP    83      36.018  50.982  18.002  1.00 37.87           O  
ATOM    692  OD2 ASP    83      35.171  51.465  19.991  1.00 39.80           O  
ATOM    693  N   MET    84      31.827  48.123  16.684  1.00 27.33           N  
ATOM    694  CA  MET    84      30.888  47.015  16.853  1.00 27.36           C  
ATOM    695  C   MET    84      31.554  45.635  16.835  1.00 26.64           C  
ATOM    696  O   MET    84      32.397  45.363  15.972  1.00 26.44           O  
ATOM    697  CB  MET    84      29.828  47.074  15.754  1.00 27.33           C  
ATOM    698  CG  MET    84      28.843  45.919  15.820  1.00 29.83           C  
ATOM    699  SD  MET    84      27.184  46.452  15.025  1.00 28.68          SE  
ATOM    700  CE  MET    84      26.622  47.647  16.472  1.00 31.10           C  
ATOM    701  N   THR    85      31.151  44.771  17.770  1.00 25.42           N  
ATOM    702  CA  THR    85      31.643  43.400  17.829  1.00 25.35           C  
ATOM    703  C   THR    85      30.957  42.626  16.710  1.00 23.90           C  
ATOM    704  O   THR    85      29.733  42.626  16.620  1.00 25.42           O  
ATOM    705  CB  THR    85      31.307  42.725  19.175  1.00 26.00           C  
ATOM    706  OG1 THR    85      31.981  43.414  20.236  1.00 30.50           O  
ATOM    707  CG2 THR    85      31.750  41.256  19.191  1.00 26.88           C  
ATOM    708  N   VAL    86      31.747  41.998  15.858  1.00 21.60           N  
ATOM    709  CA  VAL    86      31.200  41.111  14.828  1.00 20.01           C  
ATOM    710  C   VAL    86      31.084  39.709  15.396  1.00 19.18           C  
ATOM    711  O   VAL    86      32.048  39.192  15.994  1.00 18.56           O  
ATOM    712  CB  VAL    86      32.133  41.078  13.584  1.00 19.70           C  
ATOM    713  CG1 VAL    86      31.600  40.066  12.497  1.00 19.54           C  
ATOM    714  CG2 VAL    86      32.330  42.463  13.026  1.00 19.51           C  
ATOM    715  N   LYS    87      29.931  39.060  15.205  1.00 18.68           N  
ATOM    716  CA  LYS    87      29.822  37.655  15.569  1.00 18.36           C  
ATOM    717  C   LYS    87      30.030  36.774  14.329  1.00 18.76           C  
ATOM    718  O   LYS    87      29.404  37.017  13.300  1.00 17.89           O  
ATOM    719  CB  LYS    87      28.465  37.363  16.219  1.00 20.32           C  
ATOM    720  CG  LYS    87      28.207  38.121  17.539  1.00 23.26           C  
ATOM    721  CD  LYS    87      28.881  37.441  18.727  1.00 29.51           C  
ATOM    722  CE  LYS    87      28.862  38.306  20.018  1.00 29.46           C  
ATOM    723  NZ  LYS    87      27.499  38.859  20.350  1.00 34.69           N  
ATOM    724  N   TYR    88      30.908  35.778  14.414  1.00 17.24           N  
ATOM    725  CA  TYR    88      31.205  34.925  13.245  1.00 17.08           C  
ATOM    726  C   TYR    88      30.472  33.634  13.446  1.00 17.77           C  
ATOM    727  O   TYR    88      30.595  33.005  14.519  1.00 19.09           O  
ATOM    728  CB  TYR    88      32.723  34.681  13.083  1.00 16.63           C  
ATOM    729  CG  TYR    88      33.416  35.982  12.807  1.00 16.87           C  
ATOM    730  CD1 TYR    88      33.417  36.518  11.521  1.00 15.13           C  
ATOM    731  CD2 TYR    88      33.947  36.751  13.855  1.00 19.18           C  
ATOM    732  CE1 TYR    88      33.996  37.748  11.259  1.00 16.39           C  
ATOM    733  CE2 TYR    88      34.524  37.980  13.606  1.00 16.91           C  
ATOM    734  CZ  TYR    88      34.548  38.461  12.314  1.00 18.38           C  
ATOM    735  OH  TYR    88      35.119  39.660  12.080  1.00 18.80           O  
ATOM    736  N   ASP    89      29.706  33.225  12.429  1.00 15.32           N  
ATOM    737  CA  ASP    89      28.752  32.138  12.598  1.00 14.95           C  
ATOM    738  C   ASP    89      28.880  31.221  11.400  1.00 14.21           C  
ATOM    739  O   ASP    89      28.637  31.632  10.269  1.00 13.18           O  
ATOM    740  CB  ASP    89      27.320  32.705  12.754  1.00 13.62           C  
ATOM    741  CG  ASP    89      26.326  31.703  13.309  1.00 17.57           C  
ATOM    742  OD1 ASP    89      26.216  30.557  12.790  1.00 16.56           O  
ATOM    743  OD2 ASP    89      25.635  32.056  14.296  1.00 18.76           O  
ATOM    744  N   SER    90      29.255  29.979  11.660  1.00 13.24           N  
ATOM    745  CA  SER    90      29.434  28.988  10.594  1.00 13.21           C  
ATOM    746  C   SER    90      28.127  28.694   9.846  1.00 12.15           C  
ATOM    747  O   SER    90      28.166  28.199   8.726  1.00 12.17           O  
ATOM    748  CB  SER    90      30.017  27.664  11.149  1.00 14.65           C  
ATOM    749  OG  SER    90      29.081  27.013  11.999  1.00 16.86           O  
ATOM    750  N   ARG    91      26.978  28.922  10.475  1.00 11.21           N  
ATOM    751  CA  ARG    91      25.693  28.726   9.753  1.00 11.52           C  
ATOM    752  C   ARG    91      25.545  29.632   8.523  1.00 10.85           C  
ATOM    753  O   ARG    91      24.752  29.346   7.617  1.00 11.71           O  
ATOM    754  CB  ARG    91      24.487  28.872  10.673  1.00 10.94           C  
ATOM    755  CG  ARG    91      24.441  27.792  11.768  1.00 13.03           C  
ATOM    756  CD  ARG    91      23.351  28.149  12.747  1.00 15.77           C  
ATOM    757  NE  ARG    91      23.786  29.244  13.608  1.00 15.09           N  
ATOM    758  CZ  ARG    91      23.191  29.560  14.752  1.00 17.43           C  
ATOM    759  NH1 ARG    91      22.113  28.881  15.146  1.00 16.56           N  
ATOM    760  NH2 ARG    91      23.653  30.574  15.469  1.00 16.42           N  
ATOM    761  N   LEU    92      26.309  30.720   8.483  1.00 10.05           N  
ATOM    762  CA  LEU    92      26.264  31.669   7.370  1.00 10.24           C  
ATOM    763  C   LEU    92      27.184  31.304   6.192  1.00 10.17           C  
ATOM    764  O   LEU    92      27.289  32.071   5.230  1.00  9.19           O  
ATOM    765  CB  LEU    92      26.659  33.064   7.888  1.00 10.64           C  
ATOM    766  CG  LEU    92      25.647  33.620   8.896  1.00  7.81           C  
ATOM    767  CD1 LEU    92      26.151  34.998   9.449  1.00  9.51           C  
ATOM    768  CD2 LEU    92      24.265  33.840   8.216  1.00  9.67           C  
ATOM    769  N   ARG    93      27.896  30.172   6.322  1.00  9.79           N  
ATOM    770  CA  ARG    93      28.920  29.832   5.307  0.50 10.74           C  
ATOM    772  C   ARG    93      28.293  29.473   3.946  1.00 10.23           C  
ATOM    773  O   ARG    93      27.130  29.136   3.852  1.00  9.45           O  
ATOM    774  CB  ARG    93      29.871  28.723   5.810  0.50 10.99           C  
ATOM    776  CG  ARG    93      30.830  29.182   6.953  0.50 10.53           C  
ATOM    778  CD  ARG    93      31.618  28.043   7.722  0.50 13.00           C  
ATOM    780  NE  ARG    93      32.947  27.783   7.170  0.50 16.63           N  
ATOM    782  CZ  ARG    93      33.539  26.581   7.087  0.50 18.09           C  
ATOM    784  NH1 ARG    93      34.723  26.475   6.518  0.50 20.66           N  
ATOM    786  NH2 ARG    93      32.953  25.481   7.538  0.50 21.05           N  
ATOM    788  N   GLU    94      29.087  29.574   2.874  1.00  9.81           N  
ATOM    789  CA  GLU    94      28.566  29.225   1.559  1.00  9.24           C  
ATOM    790  C   GLU    94      28.222  27.720   1.486  1.00  8.74           C  
ATOM    791  O   GLU    94      28.737  26.905   2.264  1.00 10.34           O  
ATOM    792  CB  GLU    94      29.576  29.564   0.464  1.00 11.27           C  
ATOM    793  CG  GLU    94      29.088  29.349  -0.995  1.00 12.74           C  
ATOM    794  CD  GLU    94      27.785  30.006  -1.403  1.00 10.47           C  
ATOM    795  OE1 GLU    94      26.737  29.737  -0.779  1.00 14.15           O  
ATOM    796  OE2 GLU    94      27.760  30.741  -2.438  1.00 16.89           O  
ATOM    797  N   ARG    95      27.340  27.399   0.548  1.00  9.78           N  
ATOM    798  CA  ARG    95      27.030  25.998   0.196  1.00  9.41           C  
ATOM    799  C   ARG    95      28.352  25.240  -0.046  1.00 10.34           C  
ATOM    800  O   ARG    95      29.275  25.768  -0.680  1.00 10.97           O  
ATOM    801  CB  ARG    95      26.208  26.018  -1.105  1.00 10.13           C  
ATOM    802  CG  ARG    95      25.946  24.628  -1.684  1.00 11.28           C  
ATOM    803  CD  ARG    95      24.903  24.690  -2.839  1.00 10.27           C  
ATOM    804  NE  ARG    95      24.391  23.349  -3.179  1.00 11.61           N  
ATOM    805  CZ  ARG    95      23.752  23.052  -4.310  1.00 14.85           C  
ATOM    806  NH1 ARG    95      23.582  23.987  -5.240  1.00 13.49           N  
ATOM    807  NH2 ARG    95      23.327  21.791  -4.534  1.00 15.15           N  
ATOM    808  N   LYS    96      28.445  24.020   0.483  1.00 10.77           N  
ATOM    809  CA  LYS    96      29.595  23.136   0.192  1.00 11.17           C  
ATOM    810  C   LYS    96      29.486  22.581  -1.218  1.00 10.95           C  
ATOM    811  O   LYS    96      28.428  22.118  -1.598  1.00 10.65           O  
ATOM    812  CB  LYS    96      29.583  21.978   1.171  1.00 11.63           C  
ATOM    813  CG  LYS    96      30.032  22.318   2.529  1.00 13.62           C  
ATOM    814  CD  LYS    96      29.955  21.039   3.375  1.00 16.90           C  
ATOM    815  CE  LYS    96      30.787  21.227   4.642  1.00 21.22           C  
ATOM    816  NZ  LYS    96      30.972  19.848   5.295  1.00 27.76           N  
ATOM    817  N   TYR    97      30.603  22.551  -1.955  1.00 11.30           N  
ATOM    818  CA  TYR    97      30.624  21.926  -3.290  1.00 12.22           C  
ATOM    819  C   TYR    97      31.571  20.706  -3.360  1.00 11.94           C  
ATOM    820  O   TYR    97      31.841  20.166  -4.447  1.00 12.35           O  
ATOM    821  CB  TYR    97      31.000  22.967  -4.355  1.00 13.04           C  
ATOM    822  CG  TYR    97      29.936  24.034  -4.515  1.00 14.72           C  
ATOM    823  CD1 TYR    97      28.774  23.798  -5.274  1.00 14.38           C  
ATOM    824  CD2 TYR    97      30.088  25.270  -3.896  1.00 15.43           C  
ATOM    825  CE1 TYR    97      27.810  24.791  -5.393  1.00 14.73           C  
ATOM    826  CE2 TYR    97      29.122  26.262  -4.010  1.00 12.53           C  
ATOM    827  CZ  TYR    97      27.999  26.014  -4.720  1.00 14.34           C  
ATOM    828  OH  TYR    97      27.092  27.032  -4.827  1.00 16.25           O  
ATOM    829  N   GLY    98      32.089  20.291  -2.206  1.00 11.77           N  
ATOM    830  CA  GLY    98      32.826  19.036  -2.111  1.00 12.24           C  
ATOM    831  C   GLY    98      33.949  18.921  -3.124  1.00 11.83           C  
ATOM    832  O   GLY    98      34.843  19.794  -3.224  1.00 11.40           O  
ATOM    833  N   VAL    99      33.936  17.809  -3.851  1.00 12.50           N  
ATOM    834  CA  VAL    99      35.079  17.516  -4.759  1.00 12.04           C  
ATOM    835  C   VAL    99      35.247  18.503  -5.926  1.00 13.67           C  
ATOM    836  O   VAL    99      36.288  18.456  -6.634  1.00 14.68           O  
ATOM    837  CB  VAL    99      34.966  16.107  -5.330  1.00 12.48           C  
ATOM    838  CG1 VAL    99      34.952  15.066  -4.205  1.00 11.02           C  
ATOM    839  CG2 VAL    99      33.676  16.004  -6.206  1.00 10.02           C  
ATOM    840  N   VAL   100      34.243  19.356  -6.190  1.00 13.11           N  
ATOM    841  CA  VAL   100      34.429  20.384  -7.258  1.00 14.81           C  
ATOM    842  C   VAL   100      34.881  21.755  -6.749  1.00 14.74           C  
ATOM    843  O   VAL   100      35.011  22.702  -7.539  1.00 14.67           O  
ATOM    844  CB  VAL   100      33.220  20.532  -8.215  1.00 15.29           C  
ATOM    845  CG1 VAL   100      32.946  19.211  -8.916  1.00 19.59           C  
ATOM    846  CG2 VAL   100      32.006  20.981  -7.464  1.00 14.33           C  
ATOM    847  N   GLU   101      35.136  21.874  -5.446  1.00 14.02           N  
ATOM    848  CA  GLU   101      35.714  23.106  -4.924  1.00 14.89           C  
ATOM    849  C   GLU   101      37.010  23.377  -5.661  1.00 16.00           C  
ATOM    850  O   GLU   101      37.861  22.484  -5.742  1.00 16.46           O  
ATOM    851  CB  GLU   101      36.007  22.975  -3.420  1.00 15.96           C  
ATOM    852  CG  GLU   101      34.792  22.693  -2.590  1.00 18.68           C  
ATOM    853  CD  GLU   101      34.050  23.919  -2.181  1.00 21.81           C  
ATOM    854  OE1 GLU   101      34.382  25.012  -2.728  1.00 23.06           O  
ATOM    855  OE2 GLU   101      33.145  23.767  -1.300  1.00 19.19           O  
ATOM    856  N   GLY   102      37.147  24.585  -6.197  1.00 16.89           N  
ATOM    857  CA  GLY   102      38.361  24.997  -6.908  1.00 18.62           C  
ATOM    858  C   GLY   102      38.395  24.590  -8.367  1.00 19.14           C  
ATOM    859  O   GLY   102      39.412  24.832  -9.049  1.00 20.07           O  
ATOM    860  N   LYS   103      37.291  24.032  -8.876  1.00 18.98           N  
ATOM    861  CA  LYS   103      37.197  23.699 -10.299  1.00 20.92           C  
ATOM    862  C   LYS   103      36.380  24.757 -11.029  1.00 21.03           C  
ATOM    863  O   LYS   103      35.632  25.519 -10.411  1.00 20.19           O  
ATOM    864  CB  LYS   103      36.570  22.310 -10.518  1.00 20.50           C  
ATOM    865  CG  LYS   103      37.190  21.159  -9.715  1.00 22.86           C  
ATOM    866  CD  LYS   103      38.507  20.669 -10.290  1.00 23.45           C  
ATOM    867  CE  LYS   103      38.950  19.375  -9.614  1.00 23.50           C  
ATOM    868  NZ  LYS   103      40.298  18.991 -10.102  1.00 25.68           N  
ATOM    869  N   ALA   104      36.531  24.809 -12.356  1.00 22.14           N  
ATOM    870  CA  ALA   104      35.691  25.672 -13.175  1.00 23.68           C  
ATOM    871  C   ALA   104      34.233  25.281 -13.011  1.00 24.89           C  
ATOM    872  O   ALA   104      33.888  24.084 -12.896  1.00 23.99           O  
ATOM    873  CB  ALA   104      36.097  25.574 -14.678  1.00 24.14           C  
ATOM    874  N   LEU   105      33.380  26.298 -12.996  1.00 27.07           N  
ATOM    875  CA  LEU   105      31.931  26.103 -13.087  1.00 28.87           C  
ATOM    876  C   LEU   105      31.530  25.061 -14.143  1.00 29.02           C  
ATOM    877  O   LEU   105      30.664  24.232 -13.898  1.00 29.23           O  
ATOM    878  CB  LEU   105      31.257  27.442 -13.362  1.00 29.23           C  
ATOM    879  CG  LEU   105      29.755  27.479 -13.668  1.00 31.02           C  
ATOM    880  CD1 LEU   105      28.907  27.141 -12.425  1.00 32.77           C  
ATOM    881  CD2 LEU   105      29.399  28.852 -14.209  1.00 30.51           C  
ATOM    882  N   SER   106      32.178  25.086 -15.307  1.00 29.91           N  
ATOM    883  CA  SER   106      31.881  24.149 -16.387  1.00 29.14           C  
ATOM    884  C   SER   106      32.051  22.681 -15.998  1.00 29.11           C  
ATOM    885  O   SER   106      31.355  21.822 -16.527  1.00 29.44           O  
ATOM    886  CB  SER   106      32.728  24.472 -17.622  1.00 29.72           C  
ATOM    887  OG  SER   106      34.098  24.225 -17.361  1.00 30.00           O  
ATOM    888  N   GLU   107      32.982  22.398 -15.080  1.00 27.75           N  
ATOM    889  CA  GLU   107      33.183  21.041 -14.562  1.00 27.48           C  
ATOM    890  C   GLU   107      32.013  20.561 -13.714  1.00 26.29           C  
ATOM    891  O   GLU   107      31.682  19.367 -13.708  1.00 25.83           O  
ATOM    892  CB  GLU   107      34.431  20.982 -13.697  1.00 27.28           C  
ATOM    893  CG  GLU   107      35.726  20.925 -14.471  1.00 31.09           C  
ATOM    894  CD  GLU   107      36.761  20.054 -13.765  1.00 34.47           C  
ATOM    895  OE1 GLU   107      36.413  18.951 -13.265  1.00 39.28           O  
ATOM    896  OE2 GLU   107      37.930  20.465 -13.731  1.00 36.57           O  
ATOM    897  N   LEU   108      31.437  21.482 -12.953  1.00 24.91           N  
ATOM    898  CA  LEU   108      30.246  21.168 -12.154  1.00 24.54           C  
ATOM    899  C   LEU   108      29.064  20.903 -13.085  1.00 24.38           C  
ATOM    900  O   LEU   108      28.318  19.949 -12.900  1.00 23.94           O  
ATOM    901  CB  LEU   108      29.924  22.317 -11.200  1.00 23.85           C  
ATOM    902  CG  LEU   108      28.633  22.283 -10.366  1.00 24.31           C  
ATOM    903  CD1 LEU   108      28.572  21.058  -9.475  1.00 24.85           C  
ATOM    904  CD2 LEU   108      28.493  23.548  -9.560  1.00 25.05           C  
ATOM    905  N   ARG   109      28.905  21.759 -14.093  1.00 24.69           N  
ATOM    906  CA  ARG   109      27.797  21.593 -15.046  1.00 25.81           C  
ATOM    907  C   ARG   109      27.927  20.267 -15.799  1.00 25.60           C  
ATOM    908  O   ARG   109      26.936  19.578 -16.013  1.00 25.88           O  
ATOM    909  CB  ARG   109      27.722  22.778 -16.012  1.00 26.38           C  
ATOM    910  CG  ARG   109      27.505  24.090 -15.295  1.00 29.70           C  
ATOM    911  CD  ARG   109      26.671  25.027 -16.096  1.00 37.60           C  
ATOM    912  NE  ARG   109      26.665  26.367 -15.512  1.00 43.01           N  
ATOM    913  CZ  ARG   109      26.248  27.449 -16.166  1.00 45.11           C  
ATOM    914  NH1 ARG   109      25.796  27.329 -17.408  1.00 47.16           N  
ATOM    915  NH2 ARG   109      26.277  28.645 -15.585  1.00 47.45           N  
ATOM    916  N   ALA   110      29.155  19.917 -16.190  1.00 25.45           N  
ATOM    917  CA  ALA   110      29.412  18.652 -16.891  1.00 25.48           C  
ATOM    918  C   ALA   110      29.078  17.447 -16.012  1.00 25.62           C  
ATOM    919  O   ALA   110      28.485  16.465 -16.476  1.00 25.86           O  
ATOM    920  CB  ALA   110      30.848  18.593 -17.374  1.00 25.39           C  
ATOM    921  N   MET   111      29.438  17.540 -14.729  1.00 24.85           N  
ATOM    922  CA  MET   111      29.117  16.514 -13.757  0.50 23.26           C  
ATOM    924  C   MET   111      27.592  16.359 -13.584  1.00 24.91           C  
ATOM    925  O   MET   111      27.085  15.230 -13.477  1.00 24.74           O  
ATOM    926  CB  MET   111      29.815  16.828 -12.422  0.50 23.59           C  
ATOM    928  CG  MET   111      30.092  15.611 -11.579  0.50 20.75           C  
ATOM    930  SD  MET   111      30.883  16.032  -9.843  0.50 18.95          SE  
ATOM    932  CE  MET   111      32.747  15.837 -10.220  0.50 15.17           C  
ATOM    934  N   ALA   112      26.884  17.494 -13.540  1.00 25.44           N  
ATOM    935  CA  ALA   112      25.427  17.512 -13.439  1.00 26.76           C  
ATOM    936  C   ALA   112      24.818  16.790 -14.647  1.00 27.56           C  
ATOM    937  O   ALA   112      24.077  15.821 -14.486  1.00 27.10           O  
ATOM    938  CB  ALA   112      24.911  18.932 -13.376  1.00 26.49           C  
ATOM    939  N   LYS   113      25.139  17.300 -15.834  1.00 29.94           N  
ATOM    940  CA  LYS   113      24.723  16.725 -17.128  1.00 31.32           C  
ATOM    941  C   LYS   113      24.909  15.206 -17.140  1.00 31.81           C  
ATOM    942  O   LYS   113      23.985  14.460 -17.480  1.00 32.12           O  
ATOM    943  CB  LYS   113      25.496  17.434 -18.269  1.00 32.12           C  
ATOM    944  CG  LYS   113      25.539  16.786 -19.681  1.00 32.56           C  
ATOM    945  CD  LYS   113      24.177  16.663 -20.371  1.00 37.78           C  
ATOM    946  CE  LYS   113      24.235  15.605 -21.499  1.00 38.53           C  
ATOM    947  NZ  LYS   113      22.973  14.790 -21.585  1.00 41.24           N  
ATOM    948  N   ALA   114      26.094  14.753 -16.737  1.00 32.76           N  
ATOM    949  CA  ALA   114      26.410  13.322 -16.690  1.00 33.68           C  
ATOM    950  C   ALA   114      25.518  12.546 -15.725  1.00 34.47           C  
ATOM    951  O   ALA   114      25.190  11.380 -15.980  1.00 34.78           O  
ATOM    952  CB  ALA   114      27.859  13.111 -16.338  1.00 33.77           C  
ATOM    953  N   ALA   115      25.130  13.181 -14.617  1.00 34.82           N  
ATOM    954  CA  ALA   115      24.253  12.533 -13.633  1.00 35.21           C  
ATOM    955  C   ALA   115      22.772  12.575 -14.030  1.00 35.51           C  
ATOM    956  O   ALA   115      21.914  12.092 -13.291  1.00 35.77           O  
ATOM    957  CB  ALA   115      24.458  13.149 -12.245  1.00 35.54           C  
ATOM    958  N   ARG   116      22.485  13.151 -15.197  1.00 35.81           N  
ATOM    959  CA  ARG   116      21.116  13.413 -15.664  1.00 36.57           C  
ATOM    960  C   ARG   116      20.358  14.336 -14.703  1.00 35.96           C  
ATOM    961  O   ARG   116      19.173  14.146 -14.421  1.00 35.58           O  
ATOM    962  CB  ARG   116      20.351  12.109 -15.954  1.00 36.76           C  
ATOM    963  CG  ARG   116      20.943  11.282 -17.109  1.00 38.35           C  
ATOM    964  CD  ARG   116      19.941  10.231 -17.616  1.00 39.16           C  
ATOM    965  NE  ARG   116      18.865  10.833 -18.415  1.00 45.58           N  
ATOM    966  CZ  ARG   116      18.722  10.692 -19.735  1.00 47.21           C  
ATOM    967  NH1 ARG   116      17.713  11.292 -20.360  1.00 48.53           N  
ATOM    968  NH2 ARG   116      19.577   9.950 -20.436  1.00 47.82           N  
ATOM    969  N   GLU   117      21.074  15.339 -14.198  1.00 35.11           N  
ATOM    970  CA  GLU   117      20.493  16.359 -13.344  1.00 34.78           C  
ATOM    971  C   GLU   117      20.925  17.749 -13.819  1.00 33.72           C  
ATOM    972  O   GLU   117      21.735  17.874 -14.752  1.00 33.94           O  
ATOM    973  CB  GLU   117      20.900  16.117 -11.888  1.00 34.37           C  
ATOM    974  CG  GLU   117      20.427  14.774 -11.341  1.00 35.31           C  
ATOM    975  CD  GLU   117      20.919  14.515  -9.929  1.00 36.02           C  
ATOM    976  OE1 GLU   117      21.039  15.488  -9.157  1.00 35.32           O  
ATOM    977  OE2 GLU   117      21.184  13.339  -9.586  1.00 39.92           O  
ATOM    978  N   GLU   118      20.361  18.785 -13.204  1.00 32.71           N  
ATOM    979  CA  GLU   118      20.663  20.176 -13.569  1.00 32.59           C  
ATOM    980  C   GLU   118      21.165  20.955 -12.355  1.00 30.03           C  
ATOM    981  O   GLU   118      20.750  20.663 -11.221  1.00 28.44           O  
ATOM    982  CB  GLU   118      19.410  20.892 -14.056  1.00 32.85           C  
ATOM    983  CG  GLU   118      18.594  20.155 -15.100  1.00 35.90           C  
ATOM    984  CD  GLU   118      17.471  21.020 -15.648  1.00 36.89           C  
ATOM    985  OE1 GLU   118      16.623  21.507 -14.845  1.00 42.48           O  
ATOM    986  OE2 GLU   118      17.447  21.218 -16.887  1.00 42.19           O  
ATOM    987  N   CYS   119      22.027  21.946 -12.614  1.00 28.23           N  
ATOM    988  CA  CYS   119      22.452  22.914 -11.593  1.00 26.98           C  
ATOM    989  C   CYS   119      21.342  23.946 -11.462  1.00 25.57           C  
ATOM    990  O   CYS   119      20.665  24.224 -12.462  1.00 25.73           O  
ATOM    991  CB  CYS   119      23.757  23.606 -12.002  1.00 27.45           C  
ATOM    992  SG  CYS   119      25.141  22.472 -12.121  1.00 29.53           S  
ATOM    993  N   PRO   120      21.139  24.523 -10.258  1.00 23.62           N  
ATOM    994  CA  PRO   120      21.849  24.302  -8.974  1.00 21.20           C  
ATOM    995  C   PRO   120      21.369  23.125  -8.124  1.00 20.06           C  
ATOM    996  O   PRO   120      21.936  22.885  -7.060  1.00 17.82           O  
ATOM    997  CB  PRO   120      21.537  25.580  -8.198  1.00 22.04           C  
ATOM    998  CG  PRO   120      20.144  25.948  -8.652  1.00 22.84           C  
ATOM    999  CD  PRO   120      20.095  25.560 -10.125  1.00 23.21           C  
ATOM   1000  N   VAL   121      20.349  22.390  -8.562  1.00 18.45           N  
ATOM   1001  CA  VAL   121      19.870  21.259  -7.749  1.00 17.90           C  
ATOM   1002  C   VAL   121      20.963  20.198  -7.540  1.00 16.37           C  
ATOM   1003  O   VAL   121      21.146  19.687  -6.433  1.00 16.62           O  
ATOM   1004  CB  VAL   121      18.557  20.661  -8.340  1.00 18.55           C  
ATOM   1005  CG1 VAL   121      18.271  19.271  -7.769  1.00 19.26           C  
ATOM   1006  CG2 VAL   121      17.409  21.618  -8.031  1.00 18.36           C  
ATOM   1007  N   PHE   122      21.673  19.872  -8.610  1.00 16.51           N  
ATOM   1008  CA  PHE   122      22.654  18.799  -8.556  1.00 16.39           C  
ATOM   1009  C   PHE   122      23.668  19.052  -7.432  1.00 16.35           C  
ATOM   1010  O   PHE   122      24.175  20.152  -7.316  1.00 15.68           O  
ATOM   1011  CB  PHE   122      23.375  18.677  -9.889  1.00 17.53           C  
ATOM   1012  CG  PHE   122      24.571  17.769  -9.834  1.00 18.38           C  
ATOM   1013  CD1 PHE   122      24.405  16.393  -9.692  1.00 18.85           C  
ATOM   1014  CD2 PHE   122      25.873  18.316  -9.857  1.00 19.32           C  
ATOM   1015  CE1 PHE   122      25.520  15.545  -9.598  1.00 21.40           C  
ATOM   1016  CE2 PHE   122      26.990  17.492  -9.795  1.00 19.08           C  
ATOM   1017  CZ  PHE   122      26.818  16.100  -9.644  1.00 20.67           C  
ATOM   1018  N   THR   123      23.937  18.023  -6.636  1.00 14.58           N  
ATOM   1019  CA  THR   123      24.913  18.081  -5.558  1.00 13.79           C  
ATOM   1020  C   THR   123      26.057  17.091  -5.784  1.00 13.81           C  
ATOM   1021  O   THR   123      25.815  15.882  -5.743  1.00 14.03           O  
ATOM   1022  CB  THR   123      24.210  17.757  -4.229  1.00 13.79           C  
ATOM   1023  OG1 THR   123      23.150  18.714  -4.043  1.00 13.23           O  
ATOM   1024  CG2 THR   123      25.165  17.834  -3.075  1.00 13.37           C  
ATOM   1025  N   PRO   124      27.298  17.598  -5.974  1.00 13.35           N  
ATOM   1026  CA  PRO   124      28.459  16.717  -6.210  1.00 12.91           C  
ATOM   1027  C   PRO   124      28.835  15.980  -4.923  1.00 13.01           C  
ATOM   1028  O   PRO   124      28.407  16.405  -3.816  1.00 12.54           O  
ATOM   1029  CB  PRO   124      29.580  17.679  -6.617  1.00 14.14           C  
ATOM   1030  CG  PRO   124      29.146  19.047  -6.128  1.00 13.45           C  
ATOM   1031  CD  PRO   124      27.650  19.032  -5.972  1.00 12.87           C  
ATOM   1032  N   PRO   125      29.655  14.912  -5.037  1.00 13.44           N  
ATOM   1033  CA  PRO   125      30.187  14.273  -3.846  1.00 13.53           C  
ATOM   1034  C   PRO   125      30.823  15.290  -2.880  1.00 13.16           C  
ATOM   1035  O   PRO   125      31.621  16.109  -3.298  1.00 12.44           O  
ATOM   1036  CB  PRO   125      31.230  13.295  -4.423  1.00 14.24           C  
ATOM   1037  CG  PRO   125      30.673  12.977  -5.804  1.00 15.16           C  
ATOM   1038  CD  PRO   125      30.160  14.294  -6.276  1.00 14.35           C  
ATOM   1039  N   GLY   126      30.452  15.221  -1.600  1.00 13.37           N  
ATOM   1040  CA  GLY   126      30.991  16.124  -0.568  1.00 12.38           C  
ATOM   1041  C   GLY   126      30.260  17.469  -0.494  1.00 12.55           C  
ATOM   1042  O   GLY   126      30.558  18.265   0.386  1.00 14.16           O  
ATOM   1043  N   GLY   127      29.307  17.701  -1.375  1.00 12.12           N  
ATOM   1044  CA  GLY   127      28.544  18.974  -1.397  1.00 11.03           C  
ATOM   1045  C   GLY   127      27.258  18.895  -0.603  1.00 12.16           C  
ATOM   1046  O   GLY   127      26.846  17.783  -0.121  1.00 11.11           O  
ATOM   1047  N   GLU   128      26.644  20.072  -0.380  1.00 11.01           N  
ATOM   1048  CA  GLU   128      25.330  20.188   0.289  1.00 11.89           C  
ATOM   1049  C   GLU   128      24.229  20.326  -0.747  1.00 11.34           C  
ATOM   1050  O   GLU   128      24.424  20.983  -1.790  1.00 12.25           O  
ATOM   1051  CB  GLU   128      25.265  21.460   1.176  1.00 11.43           C  
ATOM   1052  CG  GLU   128      26.020  21.334   2.516  1.00 11.16           C  
ATOM   1053  CD  GLU   128      26.067  22.656   3.250  1.00 14.31           C  
ATOM   1054  OE1 GLU   128      26.553  23.629   2.649  1.00 12.14           O  
ATOM   1055  OE2 GLU   128      25.672  22.695   4.437  1.00 17.34           O  
ATOM   1056  N   THR   129      23.055  19.755  -0.451  1.00 11.74           N  
ATOM   1057  CA  THR   129      21.827  19.964  -1.236  1.00 11.64           C  
ATOM   1058  C   THR   129      21.280  21.373  -0.977  1.00 11.58           C  
ATOM   1059  O   THR   129      21.643  21.995   0.050  1.00 10.25           O  
ATOM   1060  CB  THR   129      20.719  18.950  -0.876  1.00 12.61           C  
ATOM   1061  OG1 THR   129      20.353  19.146   0.536  1.00 14.75           O  
ATOM   1062  CG2 THR   129      21.286  17.516  -0.977  1.00 15.54           C  
ATOM   1063  N   LEU   130      20.437  21.862  -1.904  1.00 11.52           N  
ATOM   1064  CA  LEU   130      19.738  23.143  -1.676  1.00 12.31           C  
ATOM   1065  C   LEU   130      18.949  23.100  -0.380  1.00 12.77           C  
ATOM   1066  O   LEU   130      18.929  24.072   0.332  1.00 10.77           O  
ATOM   1067  CB  LEU   130      18.831  23.525  -2.852  1.00 13.53           C  
ATOM   1068  CG  LEU   130      19.595  23.847  -4.142  1.00 14.68           C  
ATOM   1069  CD1 LEU   130      18.645  24.060  -5.326  1.00 17.49           C  
ATOM   1070  CD2 LEU   130      20.532  25.046  -3.947  1.00 18.17           C  
ATOM   1071  N   ASP   131      18.345  21.964  -0.042  1.00 12.80           N  
ATOM   1072  CA  ASP   131      17.546  21.916   1.175  1.00 13.89           C  
ATOM   1073  C   ASP   131      18.433  21.950   2.421  1.00 13.08           C  
ATOM   1074  O   ASP   131      18.056  22.543   3.433  1.00 12.35           O  
ATOM   1075  CB  ASP   131      16.610  20.690   1.175  1.00 15.29           C  
ATOM   1076  CG  ASP   131      15.323  20.920   0.350  1.00 19.19           C  
ATOM   1077  OD1 ASP   131      14.896  22.070   0.066  1.00 24.81           O  
ATOM   1078  OD2 ASP   131      14.735  19.904  -0.020  1.00 27.72           O  
ATOM   1079  N   GLN   132      19.621  21.349   2.346  1.00 12.26           N  
ATOM   1080  CA  GLN   132      20.561  21.450   3.443  1.00 11.76           C  
ATOM   1081  C   GLN   132      21.019  22.912   3.650  1.00 11.28           C  
ATOM   1082  O   GLN   132      21.130  23.390   4.812  1.00  9.47           O  
ATOM   1083  CB  GLN   132      21.777  20.566   3.167  1.00 12.20           C  
ATOM   1084  CG  GLN   132      21.508  19.091   3.488  1.00 15.13           C  
ATOM   1085  CD  GLN   132      22.679  18.210   3.078  1.00 18.85           C  
ATOM   1086  OE1 GLN   132      23.201  18.338   1.971  1.00 16.27           O  
ATOM   1087  NE2 GLN   132      23.110  17.325   3.991  1.00 23.69           N  
ATOM   1088  N   VAL   133      21.279  23.616   2.550  1.00  9.48           N  
ATOM   1089  CA  VAL   133      21.651  25.041   2.659  1.00  9.49           C  
ATOM   1090  C   VAL   133      20.518  25.854   3.282  1.00  9.92           C  
ATOM   1091  O   VAL   133      20.744  26.611   4.228  1.00  9.67           O  
ATOM   1092  CB  VAL   133      22.038  25.636   1.275  1.00 10.42           C  
ATOM   1093  CG1 VAL   133      22.439  27.068   1.402  1.00 10.99           C  
ATOM   1094  CG2 VAL   133      23.237  24.856   0.663  1.00  9.59           C  
ATOM   1095  N   LYS   134      19.309  25.698   2.754  1.00 10.05           N  
ATOM   1096  CA  LYS   134      18.129  26.384   3.308  1.00 10.95           C  
ATOM   1097  C   LYS   134      17.980  26.086   4.795  1.00 11.05           C  
ATOM   1098  O   LYS   134      17.592  26.959   5.566  1.00  9.92           O  
ATOM   1099  CB  LYS   134      16.856  25.966   2.585  1.00 10.96           C  
ATOM   1100  CG  LYS   134      15.648  26.772   3.054  1.00 13.28           C  
ATOM   1101  CD  LYS   134      14.331  26.418   2.340  1.00 15.14           C  
ATOM   1102  CE  LYS   134      14.135  27.178   1.071  1.00 19.20           C  
ATOM   1103  NZ  LYS   134      12.763  26.837   0.546  1.00 22.40           N  
ATOM   1104  N   MET   135      18.239  24.845   5.204  1.00  9.06           N  
ATOM   1105  CA  MET   135      18.044  24.514   6.621  1.00 11.12           C  
ATOM   1106  C   MET   135      19.006  25.323   7.494  1.00 10.30           C  
ATOM   1107  O   MET   135      18.621  25.789   8.531  1.00 10.53           O  
ATOM   1108  CB  MET   135      18.138  22.983   6.830  1.00 11.96           C  
ATOM   1109  CG  MET   135      17.896  22.479   8.257  1.00 13.35           C  
ATOM   1110  SD  MET   135      16.066  22.913   8.811  1.00 15.75          SE  
ATOM   1111  CE  MET   135      16.394  24.116  10.229  1.00 19.57           C  
ATOM   1112  N   ARG   136      20.245  25.528   7.042  1.00  9.96           N  
ATOM   1113  CA  ARG   136      21.207  26.423   7.733  1.00  9.44           C  
ATOM   1114  C   ARG   136      20.721  27.874   7.792  1.00 10.34           C  
ATOM   1115  O   ARG   136      20.948  28.566   8.776  1.00 11.05           O  
ATOM   1116  CB  ARG   136      22.596  26.348   7.102  1.00  8.92           C  
ATOM   1117  CG  ARG   136      23.220  24.964   7.297  1.00 10.88           C  
ATOM   1118  CD  ARG   136      24.692  25.051   7.080  1.00 10.58           C  
ATOM   1119  NE  ARG   136      25.105  25.173   5.661  1.00  9.48           N  
ATOM   1120  CZ  ARG   136      25.618  26.262   5.081  1.00 10.08           C  
ATOM   1121  NH1 ARG   136      25.626  27.455   5.692  1.00  9.95           N  
ATOM   1122  NH2 ARG   136      26.066  26.169   3.812  1.00  9.85           N  
ATOM   1123  N   GLY   137      19.974  28.275   6.763  1.00  9.12           N  
ATOM   1124  CA  GLY   137      19.362  29.616   6.694  1.00 10.59           C  
ATOM   1125  C   GLY   137      18.235  29.727   7.721  1.00 10.98           C  
ATOM   1126  O   GLY   137      18.143  30.735   8.466  1.00 10.49           O  
ATOM   1127  N   ILE   138      17.365  28.706   7.739  1.00 10.10           N  
ATOM   1128  CA  ILE   138      16.271  28.625   8.740  1.00  9.94           C  
ATOM   1129  C   ILE   138      16.838  28.634  10.204  1.00 10.47           C  
ATOM   1130  O   ILE   138      16.357  29.367  11.071  1.00 10.30           O  
ATOM   1131  CB  ILE   138      15.379  27.383   8.485  1.00  9.63           C  
ATOM   1132  CG1 ILE   138      14.688  27.518   7.103  1.00  9.46           C  
ATOM   1133  CG2 ILE   138      14.331  27.262   9.586  1.00 12.67           C  
ATOM   1134  CD1 ILE   138      13.942  26.227   6.728  1.00 10.38           C  
ATOM   1135  N   ASP   139      17.871  27.827  10.446  1.00 10.75           N  
ATOM   1136  CA  ASP   139      18.523  27.719  11.751  1.00 12.25           C  
ATOM   1137  C   ASP   139      19.051  29.087  12.177  1.00 11.78           C  
ATOM   1138  O   ASP   139      18.744  29.575  13.280  1.00 12.04           O  
ATOM   1139  CB  ASP   139      19.665  26.694  11.614  1.00 12.31           C  
ATOM   1140  CG  ASP   139      20.421  26.416  12.931  1.00 17.51           C  
ATOM   1141  OD1 ASP   139      20.224  27.111  13.931  1.00 23.55           O  
ATOM   1142  OD2 ASP   139      21.267  25.482  12.918  1.00 23.53           O  
ATOM   1143  N   PHE   140      19.828  29.719  11.300  1.00 10.99           N  
ATOM   1144  CA  PHE   140      20.375  31.032  11.623  1.00 11.07           C  
ATOM   1145  C   PHE   140      19.255  32.044  11.868  1.00 10.71           C  
ATOM   1146  O   PHE   140      19.280  32.819  12.844  1.00 11.15           O  
ATOM   1147  CB  PHE   140      21.308  31.564  10.533  1.00 10.66           C  
ATOM   1148  CG  PHE   140      21.842  32.928  10.882  1.00 11.12           C  
ATOM   1149  CD1 PHE   140      22.879  33.030  11.802  1.00 13.72           C  
ATOM   1150  CD2 PHE   140      21.241  34.092  10.383  1.00 11.20           C  
ATOM   1151  CE1 PHE   140      23.358  34.277  12.190  1.00 13.44           C  
ATOM   1152  CE2 PHE   140      21.724  35.384  10.768  1.00 11.43           C  
ATOM   1153  CZ  PHE   140      22.778  35.452  11.680  1.00 13.56           C  
ATOM   1154  N   PHE   141      18.275  32.061  10.961  1.00  9.26           N  
ATOM   1155  CA  PHE   141      17.192  33.042  11.078  1.00  9.67           C  
ATOM   1156  C   PHE   141      16.396  32.886  12.391  1.00  9.64           C  
ATOM   1157  O   PHE   141      16.073  33.884  13.054  1.00 10.41           O  
ATOM   1158  CB  PHE   141      16.224  32.908   9.897  1.00  9.66           C  
ATOM   1159  CG  PHE   141      15.129  33.941   9.915  1.00 10.69           C  
ATOM   1160  CD1 PHE   141      15.453  35.288   9.712  1.00 11.03           C  
ATOM   1161  CD2 PHE   141      13.787  33.576  10.129  1.00 13.04           C  
ATOM   1162  CE1 PHE   141      14.439  36.279   9.718  1.00 13.41           C  
ATOM   1163  CE2 PHE   141      12.752  34.558  10.131  1.00 12.72           C  
ATOM   1164  CZ  PHE   141      13.090  35.911   9.934  1.00 12.61           C  
ATOM   1165  N   GLU   142      16.056  31.654  12.739  1.00 10.90           N  
ATOM   1166  CA  GLU   142      15.343  31.419  14.018  1.00 12.50           C  
ATOM   1167  C   GLU   142      16.180  31.860  15.208  1.00 12.76           C  
ATOM   1168  O   GLU   142      15.645  32.512  16.144  1.00 12.86           O  
ATOM   1169  CB  GLU   142      14.956  29.948  14.133  1.00 14.29           C  
ATOM   1170  CG  GLU   142      13.950  29.649  13.002  1.00 18.51           C  
ATOM   1171  CD  GLU   142      13.206  28.339  13.106  1.00 26.10           C  
ATOM   1172  OE1 GLU   142      12.074  28.285  12.548  1.00 26.39           O  
ATOM   1173  OE2 GLU   142      13.733  27.380  13.716  1.00 30.36           O  
ATOM   1174  N   PHE   143      17.468  31.490  15.178  1.00 11.64           N  
ATOM   1175  CA  PHE   143      18.452  31.988  16.154  1.00 12.86           C  
ATOM   1176  C   PHE   143      18.407  33.541  16.285  1.00 13.14           C  
ATOM   1177  O   PHE   143      18.296  34.089  17.402  1.00 12.88           O  
ATOM   1178  CB  PHE   143      19.855  31.490  15.793  1.00 14.14           C  
ATOM   1179  CG  PHE   143      20.971  32.331  16.383  1.00 16.21           C  
ATOM   1180  CD1 PHE   143      21.327  32.196  17.723  1.00 19.07           C  
ATOM   1181  CD2 PHE   143      21.602  33.302  15.624  1.00 15.91           C  
ATOM   1182  CE1 PHE   143      22.348  32.991  18.271  1.00 20.54           C  
ATOM   1183  CE2 PHE   143      22.596  34.111  16.160  1.00 20.18           C  
ATOM   1184  CZ  PHE   143      22.977  33.955  17.484  1.00 17.61           C  
ATOM   1185  N   LEU   144      18.513  34.228  15.153  1.00 11.11           N  
ATOM   1186  CA  LEU   144      18.529  35.689  15.110  1.00 11.52           C  
ATOM   1187  C   LEU   144      17.234  36.287  15.704  1.00 11.63           C  
ATOM   1188  O   LEU   144      17.280  37.194  16.562  1.00 12.63           O  
ATOM   1189  CB  LEU   144      18.725  36.173  13.658  1.00 10.82           C  
ATOM   1190  CG  LEU   144      18.846  37.697  13.477  1.00 11.37           C  
ATOM   1191  CD1 LEU   144      20.007  38.293  14.264  1.00 14.98           C  
ATOM   1192  CD2 LEU   144      18.998  38.069  11.981  1.00 12.34           C  
ATOM   1193  N   CYS   145      16.089  35.738  15.280  1.00 11.54           N  
ATOM   1194  CA  CYS   145      14.771  36.188  15.771  1.00 12.26           C  
ATOM   1195  C   CYS   145      14.670  36.081  17.292  1.00 13.44           C  
ATOM   1196  O   CYS   145      14.323  37.070  17.943  1.00 13.67           O  
ATOM   1197  CB  CYS   145      13.644  35.406  15.096  1.00 12.21           C  
ATOM   1198  SG  CYS   145      13.463  35.951  13.328  1.00 14.79           S  
ATOM   1199  N   GLN   146      15.007  34.920  17.837  1.00 13.71           N  
ATOM   1200  CA  GLN   146      15.004  34.707  19.294  1.00 15.59           C  
ATOM   1201  C   GLN   146      15.946  35.663  20.006  1.00 15.93           C  
ATOM   1202  O   GLN   146      15.580  36.240  21.051  1.00 15.40           O  
ATOM   1203  CB  GLN   146      15.332  33.252  19.635  1.00 16.45           C  
ATOM   1204  CG  GLN   146      14.186  32.288  19.241  1.00 22.14           C  
ATOM   1205  CD  GLN   146      12.874  32.640  19.971  1.00 29.71           C  
ATOM   1206  OE1 GLN   146      12.777  32.509  21.201  1.00 32.44           O  
ATOM   1207  NE2 GLN   146      11.882  33.131  19.216  1.00 32.00           N  
ATOM   1208  N   LEU   147      17.138  35.859  19.428  1.00 15.37           N  
ATOM   1209  CA  LEU   147      18.154  36.782  19.976  1.00 15.16           C  
ATOM   1210  C   LEU   147      17.588  38.202  20.161  1.00 15.14           C  
ATOM   1211  O   LEU   147      17.635  38.785  21.258  1.00 15.30           O  
ATOM   1212  CB  LEU   147      19.390  36.799  19.053  1.00 14.58           C  
ATOM   1213  CG  LEU   147      20.477  37.750  19.578  1.00 18.48           C  
ATOM   1214  CD1 LEU   147      21.277  37.026  20.669  1.00 24.94           C  
ATOM   1215  CD2 LEU   147      21.391  38.217  18.509  1.00 21.05           C  
ATOM   1216  N   ILE   148      17.013  38.730  19.088  1.00 13.47           N  
ATOM   1217  CA  ILE   148      16.472  40.085  19.047  1.00 13.77           C  
ATOM   1218  C   ILE   148      15.277  40.239  19.987  1.00 13.26           C  
ATOM   1219  O   ILE   148      15.188  41.254  20.716  1.00 13.49           O  
ATOM   1220  CB  ILE   148      16.083  40.484  17.599  1.00 13.22           C  
ATOM   1221  CG1 ILE   148      17.315  40.531  16.688  1.00 12.36           C  
ATOM   1222  CG2 ILE   148      15.325  41.837  17.556  1.00 15.01           C  
ATOM   1223  CD1 ILE   148      18.530  41.337  17.225  1.00 14.76           C  
ATOM   1224  N   LEU   149      14.378  39.253  19.981  1.00 13.33           N  
ATOM   1225  CA  LEU   149      13.166  39.304  20.851  1.00 12.70           C  
ATOM   1226  C   LEU   149      13.587  39.302  22.328  1.00 13.92           C  
ATOM   1227  O   LEU   149      13.110  40.134  23.119  1.00 13.08           O  
ATOM   1228  CB  LEU   149      12.228  38.132  20.556  1.00 13.22           C  
ATOM   1229  CG  LEU   149      11.562  38.284  19.170  1.00 11.59           C  
ATOM   1230  CD1 LEU   149      10.787  36.997  18.820  1.00 14.38           C  
ATOM   1231  CD2 LEU   149      10.627  39.515  19.141  1.00 16.20           C  
ATOM   1232  N   LYS   150      14.521  38.415  22.660  1.00 13.32           N  
ATOM   1233  CA  LYS   150      15.031  38.306  24.051  1.00 15.01           C  
ATOM   1234  C   LYS   150      15.770  39.578  24.495  1.00 15.41           C  
ATOM   1235  O   LYS   150      15.614  40.042  25.647  1.00 15.91           O  
ATOM   1236  CB  LYS   150      15.924  37.077  24.192  1.00 15.61           C  
ATOM   1237  CG  LYS   150      15.172  35.781  24.225  1.00 18.33           C  
ATOM   1238  CD  LYS   150      16.140  34.636  24.225  1.00 22.37           C  
ATOM   1239  CE  LYS   150      15.405  33.333  24.046  1.00 29.21           C  
ATOM   1240  NZ  LYS   150      15.119  32.732  25.380  1.00 34.01           N  
ATOM   1241  N   GLU   151      16.566  40.159  23.600  1.00 16.59           N  
ATOM   1242  CA  GLU   151      17.236  41.421  23.903  1.00 18.62           C  
ATOM   1243  C   GLU   151      16.242  42.543  24.094  1.00 18.93           C  
ATOM   1244  O   GLU   151      16.381  43.320  25.036  1.00 19.86           O  
ATOM   1245  CB  GLU   151      18.279  41.783  22.826  1.00 18.64           C  
ATOM   1246  CG  GLU   151      19.491  40.830  22.871  1.00 20.23           C  
ATOM   1247  CD  GLU   151      20.613  41.209  21.915  1.00 21.22           C  
ATOM   1248  OE1 GLU   151      20.429  42.127  21.092  1.00 26.24           O  
ATOM   1249  OE2 GLU   151      21.676  40.557  21.971  1.00 24.90           O  
ATOM   1250  N   ALA   152      15.231  42.625  23.220  1.00 19.10           N  
ATOM   1251  CA  ALA   152      14.172  43.629  23.369  1.00 19.49           C  
ATOM   1252  C   ALA   152      13.473  43.445  24.730  1.00 19.77           C  
ATOM   1253  O   ALA   152      13.114  44.432  25.390  1.00 19.86           O  
ATOM   1254  CB  ALA   152      13.159  43.526  22.252  1.00 20.37           C  
ATOM   1255  N   ASP   153      13.259  42.188  25.112  1.00 19.41           N  
ATOM   1256  CA  ASP   153      12.605  41.850  26.380  1.00 21.62           C  
ATOM   1257  C   ASP   153      13.466  42.281  27.569  1.00 23.56           C  
ATOM   1258  O   ASP   153      12.959  42.809  28.560  1.00 23.49           O  
ATOM   1259  CB  ASP   153      12.369  40.338  26.494  1.00 20.56           C  
ATOM   1260  CG  ASP   153      11.495  39.982  27.680  1.00 19.09           C  
ATOM   1261  OD1 ASP   153      10.349  40.462  27.714  1.00 21.16           O  
ATOM   1262  OD2 ASP   153      11.962  39.243  28.563  1.00 19.70           O  
ATOM   1263  N   GLN   154      14.763  42.012  27.472  1.00 26.71           N  
ATOM   1264  CA  GLN   154      15.697  42.277  28.574  1.00 30.61           C  
ATOM   1265  C   GLN   154      16.002  43.776  28.747  1.00 32.44           C  
ATOM   1266  O   GLN   154      16.568  44.176  29.779  1.00 34.00           O  
ATOM   1267  CB  GLN   154      16.979  41.429  28.444  1.00 30.79           C  
ATOM   1268  CG  GLN   154      16.770  39.895  28.461  1.00 33.07           C  
ATOM   1269  CD  GLN   154      16.043  39.367  29.699  1.00 37.37           C  
ATOM   1270  OE1 GLN   154      16.550  39.443  30.823  1.00 39.46           O  
ATOM   1271  NE2 GLN   154      14.846  38.807  29.487  1.00 40.42           N  
ATOM   1272  N   LYS   155      15.587  44.612  27.785  1.00 34.64           N  
ATOM   1273  CA  LYS   155      15.755  46.085  27.881  1.00 36.26           C  
ATOM   1274  C   LYS   155      14.446  46.864  28.024  1.00 36.17           C  
ATOM   1275  O   LYS   155      13.360  46.298  28.201  1.00 37.58           O  
ATOM   1276  CB  LYS   155      16.523  46.682  26.678  1.00 36.32           C  
ATOM   1277  CG  LYS   155      17.355  45.733  25.836  1.00 39.40           C  
ATOM   1278  CD  LYS   155      18.806  45.627  26.267  1.00 40.09           C  
ATOM   1279  CE  LYS   155      19.565  44.727  25.301  1.00 43.03           C  
ATOM   1280  NZ  LYS   155      19.928  45.384  24.002  1.00 43.48           N  
ATOM   1281  N   ASN   165      12.474  55.446  15.912  1.00 41.07           N  
ATOM   1282  CA  ASN   165      12.786  56.233  14.721  1.00 40.86           C  
ATOM   1283  C   ASN   165      14.225  56.117  14.260  1.00 39.46           C  
ATOM   1284  O   ASN   165      14.474  55.926  13.065  1.00 39.76           O  
ATOM   1285  CB  ASN   165      12.495  57.726  14.953  1.00 41.56           C  
ATOM   1286  CG  ASN   165      11.019  58.026  15.088  1.00 43.79           C  
ATOM   1287  OD1 ASN   165      10.175  57.371  14.470  1.00 47.63           O  
ATOM   1288  ND2 ASN   165      10.696  59.042  15.885  1.00 46.17           N  
ATOM   1289  N   CYS   166      15.149  56.242  15.216  1.00 37.98           N  
ATOM   1290  CA  CYS   166      16.580  56.379  14.945  0.50 36.88           C  
ATOM   1292  C   CYS   166      17.170  55.327  13.986  1.00 36.05           C  
ATOM   1293  O   CYS   166      17.921  55.653  13.041  1.00 35.95           O  
ATOM   1294  CB  CYS   166      17.329  56.360  16.274  0.50 37.09           C  
ATOM   1296  SG  CYS   166      19.092  56.519  16.131  0.50 38.12           S  
ATOM   1298  N   LEU   167      16.844  54.063  14.232  1.00 33.59           N  
ATOM   1299  CA  LEU   167      17.349  52.984  13.376  1.00 30.89           C  
ATOM   1300  C   LEU   167      16.723  53.022  11.973  1.00 29.85           C  
ATOM   1301  O   LEU   167      17.438  52.862  10.974  1.00 28.15           O  
ATOM   1302  CB  LEU   167      17.144  51.623  14.043  1.00 29.90           C  
ATOM   1303  CG  LEU   167      17.722  51.341  15.434  1.00 29.69           C  
ATOM   1304  CD1 LEU   167      17.442  49.901  15.841  1.00 27.15           C  
ATOM   1305  CD2 LEU   167      19.210  51.625  15.503  1.00 27.72           C  
ATOM   1306  N   GLU   168      15.405  53.265  11.905  1.00 28.65           N  
ATOM   1307  CA  GLU   168      14.659  53.300  10.634  1.00 28.93           C  
ATOM   1308  C   GLU   168      15.057  54.494   9.758  1.00 27.44           C  
ATOM   1309  O   GLU   168      15.255  54.348   8.551  1.00 27.06           O  
ATOM   1310  CB  GLU   168      13.141  53.301  10.891  1.00 29.00           C  
ATOM   1311  CG  GLU   168      12.255  53.014   9.660  1.00 30.98           C  
ATOM   1312  CD  GLU   168      10.935  52.292  10.007  1.00 32.01           C  
ATOM   1313  OE1 GLU   168      10.464  52.369  11.172  1.00 35.69           O  
ATOM   1314  OE2 GLU   168      10.375  51.617   9.112  1.00 36.97           O  
ATOM   1315  N   THR   169      15.176  55.673  10.373  1.00 27.30           N  
ATOM   1316  CA  THR   169      15.520  56.891   9.635  1.00 27.25           C  
ATOM   1317  C   THR   169      16.842  56.760   8.882  1.00 26.37           C  
ATOM   1318  O   THR   169      16.923  57.137   7.709  1.00 26.91           O  
ATOM   1319  CB  THR   169      15.510  58.168  10.544  1.00 27.66           C  
ATOM   1320  OG1 THR   169      16.549  58.072  11.523  1.00 29.75           O  
ATOM   1321  CG2 THR   169      14.185  58.297  11.260  1.00 27.52           C  
ATOM   1322  N   SER   170      17.848  56.182   9.535  1.00 26.61           N  
ATOM   1323  CA  SER   170      19.174  56.002   8.917  1.00 26.93           C  
ATOM   1324  C   SER   170      19.123  55.010   7.750  1.00 26.69           C  
ATOM   1325  O   SER   170      19.792  55.208   6.740  1.00 27.67           O  
ATOM   1326  CB  SER   170      20.248  55.639   9.958  1.00 27.25           C  
ATOM   1327  OG  SER   170      20.071  54.353  10.510  1.00 28.32           O  
ATOM   1328  N   LEU   171      18.305  53.966   7.868  1.00 26.17           N  
ATOM   1329  CA  LEU   171      18.040  53.090   6.720  1.00 25.72           C  
ATOM   1330  C   LEU   171      17.287  53.802   5.580  1.00 26.04           C  
ATOM   1331  O   LEU   171      17.639  53.648   4.407  1.00 25.52           O  
ATOM   1332  CB  LEU   171      17.298  51.821   7.156  1.00 25.40           C  
ATOM   1333  CG  LEU   171      18.092  50.830   8.015  1.00 24.74           C  
ATOM   1334  CD1 LEU   171      17.136  49.817   8.632  1.00 23.70           C  
ATOM   1335  CD2 LEU   171      19.200  50.144   7.186  1.00 22.15           C  
ATOM   1336  N   ALA   172      16.256  54.588   5.927  1.00 26.86           N  
ATOM   1337  CA  ALA   172      15.388  55.251   4.933  1.00 27.07           C  
ATOM   1338  C   ALA   172      16.132  56.273   4.070  1.00 27.99           C  
ATOM   1339  O   ALA   172      15.687  56.601   2.959  1.00 28.28           O  
ATOM   1340  CB  ALA   172      14.173  55.917   5.628  1.00 26.59           C  
ATOM   1341  N   GLU   173      17.268  56.735   4.592  1.00 28.87           N  
ATOM   1342  CA  GLU   173      18.192  57.649   3.923  1.00 31.20           C  
ATOM   1343  C   GLU   173      18.737  57.100   2.610  1.00 30.70           C  
ATOM   1344  O   GLU   173      19.006  57.862   1.683  1.00 30.82           O  
ATOM   1345  CB  GLU   173      19.397  57.907   4.827  1.00 31.14           C  
ATOM   1346  CG  GLU   173      19.240  59.056   5.812  1.00 33.97           C  
ATOM   1347  CD  GLU   173      20.443  59.217   6.735  1.00 34.81           C  
ATOM   1348  OE1 GLU   173      21.599  58.949   6.305  1.00 37.15           O  
ATOM   1349  OE2 GLU   173      20.223  59.620   7.912  1.00 40.87           O  
ATOM   1350  N   ILE   174      18.937  55.779   2.550  1.00 29.59           N  
ATOM   1351  CA  ILE   174      19.664  55.177   1.444  1.00 28.75           C  
ATOM   1352  C   ILE   174      18.945  53.993   0.816  1.00 27.96           C  
ATOM   1353  O   ILE   174      19.270  53.604  -0.303  1.00 28.16           O  
ATOM   1354  CB  ILE   174      21.095  54.747   1.855  1.00 28.85           C  
ATOM   1355  CG1 ILE   174      21.047  53.714   2.996  1.00 28.35           C  
ATOM   1356  CG2 ILE   174      21.951  55.980   2.220  1.00 28.66           C  
ATOM   1357  CD1 ILE   174      22.382  53.050   3.268  1.00 28.84           C  
ATOM   1358  N   PHE   175      17.976  53.438   1.545  1.00 27.25           N  
ATOM   1359  CA  PHE   175      17.154  52.313   1.089  1.00 27.16           C  
ATOM   1360  C   PHE   175      15.712  52.748   0.844  1.00 27.96           C  
ATOM   1361  O   PHE   175      15.198  53.589   1.591  1.00 28.32           O  
ATOM   1362  CB  PHE   175      17.148  51.197   2.138  1.00 25.39           C  
ATOM   1363  CG  PHE   175      18.448  50.476   2.254  1.00 25.02           C  
ATOM   1364  CD1 PHE   175      19.000  49.831   1.144  1.00 22.62           C  
ATOM   1365  CD2 PHE   175      19.138  50.455   3.463  1.00 23.11           C  
ATOM   1366  CE1 PHE   175      20.233  49.168   1.253  1.00 22.60           C  
ATOM   1367  CE2 PHE   175      20.371  49.793   3.582  1.00 23.59           C  
ATOM   1368  CZ  PHE   175      20.907  49.145   2.472  1.00 22.09           C  
ATOM   1369  N   PRO   176      15.042  52.144  -0.159  1.00 28.92           N  
ATOM   1370  CA  PRO   176      13.659  52.519  -0.523  1.00 29.85           C  
ATOM   1371  C   PRO   176      12.546  52.111   0.472  1.00 30.23           C  
ATOM   1372  O   PRO   176      11.619  51.369   0.120  1.00 29.89           O  
ATOM   1373  CB  PRO   176      13.460  51.839  -1.879  1.00 29.67           C  
ATOM   1374  CG  PRO   176      14.364  50.658  -1.842  1.00 29.69           C  
ATOM   1375  CD  PRO   176      15.559  51.076  -1.037  1.00 29.70           C  
ATOM   1376  N   LEU   177      12.649  52.594   1.702  1.00 31.32           N  
ATOM   1377  CA  LEU   177      11.584  52.454   2.669  1.00 32.99           C  
ATOM   1378  C   LEU   177      10.558  53.566   2.434  1.00 34.01           C  
ATOM   1379  O   LEU   177       9.364  53.292   2.296  1.00 35.48           O  
ATOM   1380  CB  LEU   177      12.135  52.570   4.085  1.00 33.09           C  
ATOM   1381  CG  LEU   177      12.901  51.402   4.709  1.00 33.87           C  
ATOM   1382  CD1 LEU   177      13.626  51.910   5.929  1.00 35.29           C  
ATOM   1383  CD2 LEU   177      11.974  50.264   5.097  1.00 34.86           C  
ATOM   1384  N   ILE   191       3.939  49.630  13.570  1.00 39.51           N  
ATOM   1385  CA  ILE   191       3.880  50.674  14.609  1.00 39.47           C  
ATOM   1386  C   ILE   191       5.049  50.664  15.620  1.00 38.14           C  
ATOM   1387  O   ILE   191       5.580  51.740  15.924  1.00 37.87           O  
ATOM   1388  CB  ILE   191       2.462  50.789  15.328  1.00 39.29           C  
ATOM   1389  CG1 ILE   191       2.433  51.996  16.290  1.00 40.74           C  
ATOM   1390  CG2 ILE   191       2.038  49.463  16.001  1.00 40.80           C  
ATOM   1391  CD1 ILE   191       1.296  52.006  17.340  1.00 40.39           C  
ATOM   1392  N   PRO   192       5.482  49.463  16.109  1.00 37.22           N  
ATOM   1393  CA  PRO   192       6.645  49.479  17.014  1.00 35.79           C  
ATOM   1394  C   PRO   192       7.866  50.047  16.289  1.00 34.05           C  
ATOM   1395  O   PRO   192       8.092  49.699  15.126  1.00 34.00           O  
ATOM   1396  CB  PRO   192       6.894  47.986  17.313  1.00 35.96           C  
ATOM   1397  CG  PRO   192       5.638  47.306  17.007  1.00 36.88           C  
ATOM   1398  CD  PRO   192       5.026  48.079  15.861  1.00 37.57           C  
ATOM   1399  N   GLY   193       8.628  50.919  16.953  1.00 32.00           N  
ATOM   1400  CA  GLY   193       9.924  51.376  16.415  1.00 29.30           C  
ATOM   1401  C   GLY   193      10.830  50.158  16.267  1.00 26.86           C  
ATOM   1402  O   GLY   193      10.654  49.181  16.991  1.00 27.57           O  
ATOM   1403  N   LEU   194      11.785  50.196  15.335  1.00 25.02           N  
ATOM   1404  CA  LEU   194      12.666  49.029  15.119  1.00 22.05           C  
ATOM   1405  C   LEU   194      13.431  48.669  16.374  1.00 21.47           C  
ATOM   1406  O   LEU   194      14.097  49.519  16.968  1.00 20.52           O  
ATOM   1407  CB  LEU   194      13.667  49.268  13.981  1.00 22.03           C  
ATOM   1408  CG  LEU   194      13.115  49.448  12.567  1.00 21.92           C  
ATOM   1409  CD1 LEU   194      14.218  49.717  11.554  1.00 21.24           C  
ATOM   1410  CD2 LEU   194      12.268  48.216  12.181  1.00 19.60           C  
ATOM   1411  N   ALA   195      13.359  47.408  16.768  1.00 19.34           N  
ATOM   1412  CA  ALA   195      14.067  46.936  17.943  1.00 18.73           C  
ATOM   1413  C   ALA   195      15.570  46.801  17.690  1.00 18.18           C  
ATOM   1414  O   ALA   195      16.388  46.907  18.607  1.00 18.05           O  
ATOM   1415  CB  ALA   195      13.484  45.595  18.409  1.00 18.89           C  
ATOM   1416  N   ALA   196      15.917  46.565  16.437  1.00 16.89           N  
ATOM   1417  CA  ALA   196      17.301  46.288  16.039  1.00 15.01           C  
ATOM   1418  C   ALA   196      17.445  46.486  14.517  1.00 14.33           C  
ATOM   1419  O   ALA   196      16.454  46.568  13.795  1.00 13.96           O  
ATOM   1420  CB  ALA   196      17.727  44.886  16.457  1.00 15.92           C  
ATOM   1421  N   SER   197      18.707  46.610  14.069  1.00 13.64           N  
ATOM   1422  CA  SER   197      19.075  46.758  12.665  1.00 13.45           C  
ATOM   1423  C   SER   197      20.336  45.904  12.511  1.00 13.46           C  
ATOM   1424  O   SER   197      21.446  46.289  12.920  1.00 13.37           O  
ATOM   1425  CB  SER   197      19.358  48.221  12.305  1.00 13.58           C  
ATOM   1426  OG  SER   197      19.622  48.367  10.900  1.00 14.68           O  
ATOM   1427  N   VAL   198      20.138  44.726  11.921  1.00 13.15           N  
ATOM   1428  CA  VAL   198      21.175  43.684  11.893  1.00 13.08           C  
ATOM   1429  C   VAL   198      21.837  43.708  10.520  1.00 13.08           C  
ATOM   1430  O   VAL   198      21.150  43.812   9.488  1.00 13.79           O  
ATOM   1431  CB  VAL   198      20.539  42.297  12.111  1.00 12.94           C  
ATOM   1432  CG1 VAL   198      21.583  41.206  11.969  1.00 13.89           C  
ATOM   1433  CG2 VAL   198      19.785  42.182  13.457  1.00 12.57           C  
ATOM   1434  N   LEU   199      23.165  43.640  10.519  1.00 12.11           N  
ATOM   1435  CA  LEU   199      23.944  43.552   9.280  1.00 11.62           C  
ATOM   1436  C   LEU   199      24.484  42.142   9.161  1.00 11.23           C  
ATOM   1437  O   LEU   199      25.156  41.672  10.058  1.00 11.71           O  
ATOM   1438  CB  LEU   199      25.143  44.520   9.306  1.00 12.31           C  
ATOM   1439  CG  LEU   199      26.104  44.482   8.086  1.00 11.66           C  
ATOM   1440  CD1 LEU   199      25.454  44.717   6.697  1.00 13.39           C  
ATOM   1441  CD2 LEU   199      27.300  45.506   8.317  1.00 12.95           C  
ATOM   1442  N   VAL   200      24.258  41.507   8.006  1.00 10.78           N  
ATOM   1443  CA  VAL   200      24.776  40.120   7.811  1.00  8.76           C  
ATOM   1444  C   VAL   200      25.585  40.101   6.520  1.00  9.38           C  
ATOM   1445  O   VAL   200      25.108  40.550   5.475  1.00 10.10           O  
ATOM   1446  CB  VAL   200      23.609  39.072   7.698  1.00  8.66           C  
ATOM   1447  CG1 VAL   200      24.164  37.703   7.228  1.00  8.33           C  
ATOM   1448  CG2 VAL   200      22.846  38.947   9.017  1.00 10.38           C  
ATOM   1449  N   VAL   201      26.812  39.596   6.594  1.00  9.43           N  
ATOM   1450  CA  VAL   201      27.621  39.452   5.399  1.00  8.97           C  
ATOM   1451  C   VAL   201      27.796  37.959   5.116  1.00  9.62           C  
ATOM   1452  O   VAL   201      28.275  37.211   5.968  1.00  7.86           O  
ATOM   1453  CB  VAL   201      28.996  40.116   5.547  1.00  9.59           C  
ATOM   1454  CG1 VAL   201      29.874  39.759   4.306  1.00  9.68           C  
ATOM   1455  CG2 VAL   201      28.800  41.646   5.700  1.00 11.12           C  
ATOM   1456  N   SER   202      27.426  37.544   3.899  1.00  9.31           N  
ATOM   1457  CA  SER   202      27.409  36.101   3.605  1.00  8.95           C  
ATOM   1458  C   SER   202      27.682  35.867   2.128  1.00  9.16           C  
ATOM   1459  O   SER   202      28.438  36.636   1.488  1.00 10.38           O  
ATOM   1460  CB  SER   202      26.058  35.492   4.096  1.00  8.93           C  
ATOM   1461  OG  SER   202      25.903  34.092   3.831  1.00 10.01           O  
ATOM   1462  N   HIS   203      27.061  34.814   1.570  1.00 10.13           N  
ATOM   1463  CA  HIS   203      27.535  34.249   0.316  1.00  9.52           C  
ATOM   1464  C   HIS   203      26.367  34.086  -0.635  1.00 10.30           C  
ATOM   1465  O   HIS   203      25.216  33.917  -0.171  1.00  9.32           O  
ATOM   1466  CB  HIS   203      28.166  32.852   0.589  1.00  9.59           C  
ATOM   1467  CG  HIS   203      29.341  32.879   1.531  1.00  7.84           C  
ATOM   1468  ND1 HIS   203      30.649  32.959   1.093  1.00  9.11           N  
ATOM   1469  CD2 HIS   203      29.401  32.780   2.882  1.00 10.71           C  
ATOM   1470  CE1 HIS   203      31.465  32.895   2.139  1.00  9.53           C  
ATOM   1471  NE2 HIS   203      30.731  32.788   3.237  1.00  8.48           N  
ATOM   1472  N   GLY   204      26.642  34.041  -1.948  1.00  9.69           N  
ATOM   1473  CA  GLY   204      25.503  34.073  -2.911  1.00  9.75           C  
ATOM   1474  C   GLY   204      24.522  32.906  -2.808  1.00  9.54           C  
ATOM   1475  O   GLY   204      23.329  33.126  -2.661  1.00  9.85           O  
ATOM   1476  N   ALA   205      25.014  31.678  -2.814  1.00  9.62           N  
ATOM   1477  CA  ALA   205      24.075  30.533  -2.842  1.00  8.60           C  
ATOM   1478  C   ALA   205      23.305  30.459  -1.523  1.00  9.84           C  
ATOM   1479  O   ALA   205      22.099  30.182  -1.506  1.00  9.20           O  
ATOM   1480  CB  ALA   205      24.798  29.203  -3.200  1.00 11.04           C  
ATOM   1481  N   TYR   206      24.010  30.687  -0.419  1.00  8.72           N  
ATOM   1482  CA  TYR   206      23.350  30.676   0.884  1.00  8.73           C  
ATOM   1483  C   TYR   206      22.268  31.735   0.959  1.00  8.56           C  
ATOM   1484  O   TYR   206      21.148  31.498   1.465  1.00  8.88           O  
ATOM   1485  CB  TYR   206      24.384  30.938   1.962  1.00  7.66           C  
ATOM   1486  CG  TYR   206      23.785  30.956   3.365  1.00  9.51           C  
ATOM   1487  CD1 TYR   206      23.564  29.772   4.063  1.00  7.24           C  
ATOM   1488  CD2 TYR   206      23.374  32.155   3.961  1.00 10.79           C  
ATOM   1489  CE1 TYR   206      23.034  29.805   5.359  1.00 10.51           C  
ATOM   1490  CE2 TYR   206      22.854  32.198   5.246  1.00 11.50           C  
ATOM   1491  CZ  TYR   206      22.699  31.025   5.941  1.00 10.75           C  
ATOM   1492  OH  TYR   206      22.157  31.087   7.208  1.00 10.83           O  
ATOM   1493  N   MET   207      22.618  32.922   0.472  1.00  7.25           N  
ATOM   1494  CA  MET   207      21.640  34.024   0.460  1.00  9.04           C  
ATOM   1495  C   MET   207      20.403  33.663  -0.376  1.00  8.99           C  
ATOM   1496  O   MET   207      19.240  33.915   0.050  1.00 11.12           O  
ATOM   1497  CB  MET   207      22.287  35.307   0.016  1.00  8.31           C  
ATOM   1498  CG  MET   207      23.162  35.904   1.145  1.00  8.70           C  
ATOM   1499  SD  MET   207      24.421  37.241   0.441  1.00 11.06          SE  
ATOM   1500  CE  MET   207      23.098  38.585  -0.024  1.00 13.46           C  
ATOM   1501  N   ARG   208      20.636  33.083  -1.535  1.00 10.61           N  
ATOM   1502  CA  ARG   208      19.503  32.741  -2.425  1.00  9.90           C  
ATOM   1503  C   ARG   208      18.536  31.785  -1.713  1.00 11.11           C  
ATOM   1504  O   ARG   208      17.295  31.938  -1.782  1.00 11.37           O  
ATOM   1505  CB  ARG   208      20.015  32.179  -3.743  1.00 12.27           C  
ATOM   1506  CG  ARG   208      20.585  33.343  -4.610  1.00 15.78           C  
ATOM   1507  CD  ARG   208      20.941  32.873  -6.042  1.00 16.42           C  
ATOM   1508  NE  ARG   208      22.040  31.918  -6.103  1.00 17.26           N  
ATOM   1509  CZ  ARG   208      23.330  32.252  -6.152  1.00 16.45           C  
ATOM   1510  NH1 ARG   208      23.690  33.522  -6.102  1.00 17.32           N  
ATOM   1511  NH2 ARG   208      24.268  31.307  -6.225  1.00 17.91           N  
ATOM   1512  N   SER   209      19.091  30.845  -0.973  1.00  9.56           N  
ATOM   1513  CA  SER   209      18.271  29.853  -0.265  1.00 10.25           C  
ATOM   1514  C   SER   209      17.548  30.490   0.896  1.00 10.33           C  
ATOM   1515  O   SER   209      16.381  30.164   1.185  1.00 11.28           O  
ATOM   1516  CB  SER   209      19.144  28.705   0.232  1.00 11.33           C  
ATOM   1517  OG  SER   209      19.516  27.853  -0.832  1.00 13.34           O  
ATOM   1518  N   LEU   210      18.242  31.401   1.590  1.00 10.38           N  
ATOM   1519  CA  LEU   210      17.569  32.130   2.698  1.00  8.87           C  
ATOM   1520  C   LEU   210      16.428  32.977   2.120  1.00  9.51           C  
ATOM   1521  O   LEU   210      15.323  32.988   2.670  1.00  9.92           O  
ATOM   1522  CB  LEU   210      18.623  32.968   3.434  1.00  9.32           C  
ATOM   1523  CG  LEU   210      18.048  33.840   4.556  1.00  9.09           C  
ATOM   1524  CD1 LEU   210      17.590  32.951   5.718  1.00 10.71           C  
ATOM   1525  CD2 LEU   210      19.140  34.878   5.001  1.00 10.89           C  
ATOM   1526  N   PHE   211      16.667  33.630   0.980  1.00  9.30           N  
ATOM   1527  CA  PHE   211      15.672  34.526   0.423  1.00 10.50           C  
ATOM   1528  C   PHE   211      14.498  33.663  -0.069  1.00  9.99           C  
ATOM   1529  O   PHE   211      13.333  34.056   0.074  1.00  9.59           O  
ATOM   1530  CB  PHE   211      16.256  35.373  -0.710  1.00  9.65           C  
ATOM   1531  CG  PHE   211      17.358  36.303  -0.267  1.00 10.52           C  
ATOM   1532  CD1 PHE   211      17.539  36.610   1.083  1.00 11.62           C  
ATOM   1533  CD2 PHE   211      18.194  36.871  -1.203  1.00 14.73           C  
ATOM   1534  CE1 PHE   211      18.576  37.453   1.488  1.00 15.33           C  
ATOM   1535  CE2 PHE   211      19.217  37.745  -0.808  1.00 15.53           C  
ATOM   1536  CZ  PHE   211      19.387  38.034   0.550  1.00 13.13           C  
ATOM   1537  N   ASP   212      14.806  32.486  -0.590  1.00 10.28           N  
ATOM   1538  CA  ASP   212      13.733  31.557  -0.956  1.00 10.45           C  
ATOM   1539  C   ASP   212      12.895  31.125   0.242  1.00 10.32           C  
ATOM   1540  O   ASP   212      11.673  31.044   0.154  1.00  9.93           O  
ATOM   1541  CB  ASP   212      14.257  30.322  -1.670  1.00 11.35           C  
ATOM   1542  CG  ASP   212      13.113  29.499  -2.281  1.00 14.19           C  
ATOM   1543  OD1 ASP   212      12.306  30.036  -3.060  1.00 18.34           O  
ATOM   1544  OD2 ASP   212      12.958  28.348  -1.923  1.00 19.95           O  
ATOM   1545  N   TYR   213      13.533  30.877   1.375  1.00  9.34           N  
ATOM   1546  CA  TYR   213      12.773  30.636   2.621  1.00  9.28           C  
ATOM   1547  C   TYR   213      11.844  31.819   2.913  1.00 10.01           C  
ATOM   1548  O   TYR   213      10.654  31.633   3.166  1.00  9.71           O  
ATOM   1549  CB  TYR   213      13.741  30.430   3.765  1.00 10.44           C  
ATOM   1550  CG  TYR   213      13.072  30.316   5.104  1.00  9.68           C  
ATOM   1551  CD1 TYR   213      12.126  29.302   5.346  1.00 11.69           C  
ATOM   1552  CD2 TYR   213      13.423  31.187   6.162  1.00 11.29           C  
ATOM   1553  CE1 TYR   213      11.512  29.192   6.584  1.00 14.86           C  
ATOM   1554  CE2 TYR   213      12.818  31.065   7.378  1.00 12.39           C  
ATOM   1555  CZ  TYR   213      11.875  30.086   7.587  1.00 15.18           C  
ATOM   1556  OH  TYR   213      11.328  29.987   8.860  1.00 18.19           O  
ATOM   1557  N   PHE   214      12.362  33.044   2.825  1.00  9.20           N  
ATOM   1558  CA  PHE   214      11.530  34.208   3.131  1.00  9.42           C  
ATOM   1559  C   PHE   214      10.352  34.318   2.171  1.00 10.67           C  
ATOM   1560  O   PHE   214       9.267  34.633   2.596  1.00 10.12           O  
ATOM   1561  CB  PHE   214      12.333  35.500   3.002  1.00  9.95           C  
ATOM   1562  CG  PHE   214      13.394  35.690   4.060  1.00  8.70           C  
ATOM   1563  CD1 PHE   214      13.403  34.963   5.244  1.00  8.58           C  
ATOM   1564  CD2 PHE   214      14.387  36.661   3.852  1.00 10.59           C  
ATOM   1565  CE1 PHE   214      14.396  35.198   6.210  1.00 10.02           C  
ATOM   1566  CE2 PHE   214      15.386  36.898   4.808  1.00 10.61           C  
ATOM   1567  CZ  PHE   214      15.385  36.182   5.976  1.00 11.62           C  
ATOM   1568  N   LEU   215      10.583  34.056   0.879  1.00 10.25           N  
ATOM   1569  CA  LEU   215       9.506  34.231  -0.114  1.00 10.38           C  
ATOM   1570  C   LEU   215       8.566  33.038  -0.161  1.00 10.77           C  
ATOM   1571  O   LEU   215       7.339  33.174   0.017  1.00 11.28           O  
ATOM   1572  CB  LEU   215      10.121  34.485  -1.488  1.00 10.63           C  
ATOM   1573  CG  LEU   215       9.069  34.627  -2.612  1.00  9.43           C  
ATOM   1574  CD1 LEU   215       8.138  35.785  -2.313  1.00 12.74           C  
ATOM   1575  CD2 LEU   215       9.785  34.860  -3.967  1.00 12.27           C  
ATOM   1576  N   THR   216       9.131  31.865  -0.398  1.00 11.00           N  
ATOM   1577  CA  THR   216       8.307  30.671  -0.567  1.00 12.81           C  
ATOM   1578  C   THR   216       7.626  30.239   0.730  1.00 12.62           C  
ATOM   1579  O   THR   216       6.467  29.852   0.720  1.00 13.60           O  
ATOM   1580  CB  THR   216       9.152  29.534  -1.189  1.00 12.36           C  
ATOM   1581  OG1 THR   216       9.636  29.972  -2.460  1.00 14.69           O  
ATOM   1582  CG2 THR   216       8.319  28.262  -1.368  1.00 14.27           C  
ATOM   1583  N   ASP   217       8.359  30.285   1.847  1.00 13.20           N  
ATOM   1584  CA  ASP   217       7.882  29.746   3.104  1.00 12.92           C  
ATOM   1585  C   ASP   217       7.256  30.784   4.037  1.00 13.22           C  
ATOM   1586  O   ASP   217       6.143  30.582   4.550  1.00 15.48           O  
ATOM   1587  CB  ASP   217       9.011  28.934   3.761  1.00 13.79           C  
ATOM   1588  CG  ASP   217       9.519  27.832   2.822  1.00 16.22           C  
ATOM   1589  OD1 ASP   217       8.673  27.023   2.386  1.00 18.83           O  
ATOM   1590  OD2 ASP   217      10.702  27.797   2.466  1.00 15.17           O  
ATOM   1591  N   LEU   218       7.916  31.930   4.212  1.00 10.94           N  
ATOM   1592  CA  LEU   218       7.348  32.985   5.050  1.00 11.53           C  
ATOM   1593  C   LEU   218       6.392  33.937   4.297  1.00 11.62           C  
ATOM   1594  O   LEU   218       5.723  34.808   4.914  1.00 12.88           O  
ATOM   1595  CB  LEU   218       8.481  33.745   5.769  1.00 11.54           C  
ATOM   1596  CG  LEU   218       9.332  32.906   6.752  1.00 12.78           C  
ATOM   1597  CD1 LEU   218      10.272  33.818   7.514  1.00 12.03           C  
ATOM   1598  CD2 LEU   218       8.443  32.131   7.731  1.00 15.13           C  
ATOM   1599  N   LYS   219       6.339  33.766   2.979  1.00 11.24           N  
ATOM   1600  CA  LYS   219       5.419  34.528   2.134  1.00 12.22           C  
ATOM   1601  C   LYS   219       5.700  36.040   2.224  1.00 12.08           C  
ATOM   1602  O   LYS   219       4.752  36.851   2.263  1.00 12.49           O  
ATOM   1603  CB  LYS   219       3.949  34.225   2.515  1.00 14.45           C  
ATOM   1604  CG  LYS   219       3.542  32.732   2.601  1.00 17.85           C  
ATOM   1605  CD  LYS   219       3.793  31.984   1.282  1.00 19.35           C  
ATOM   1606  CE  LYS   219       3.347  30.499   1.371  1.00 22.17           C  
ATOM   1607  NZ  LYS   219       3.656  29.950   2.699  1.00 27.12           N  
ATOM   1608  N   CYS   220       7.000  36.404   2.185  1.00 11.26           N  
ATOM   1609  CA  CYS   220       7.395  37.824   2.261  0.80 11.17           C  
ATOM   1611  C   CYS   220       6.842  38.615   1.085  1.00 11.75           C  
ATOM   1612  O   CYS   220       6.593  38.082  -0.005  1.00 11.77           O  
ATOM   1613  CB  CYS   220       8.907  38.003   2.340  0.80 11.41           C  
ATOM   1615  SG  CYS   220       9.772  37.747   0.774  0.80 12.73           S  
ATOM   1617  N   SER   221       6.585  39.897   1.334  1.00 12.01           N  
ATOM   1618  CA  SER   221       6.150  40.778   0.265  1.00 13.09           C  
ATOM   1619  C   SER   221       7.377  41.226  -0.550  1.00 14.04           C  
ATOM   1620  O   SER   221       8.492  41.258  -0.029  1.00 14.60           O  
ATOM   1621  CB  SER   221       5.389  41.968   0.837  1.00 13.77           C  
ATOM   1622  OG  SER   221       6.180  42.739   1.729  1.00 13.35           O  
ATOM   1623  N   LEU   222       7.165  41.555  -1.822  1.00 15.54           N  
ATOM   1624  CA  LEU   222       8.265  41.947  -2.720  1.00 17.54           C  
ATOM   1625  C   LEU   222       7.970  43.329  -3.322  1.00 19.60           C  
ATOM   1626  O   LEU   222       6.825  43.619  -3.649  1.00 20.17           O  
ATOM   1627  CB  LEU   222       8.395  40.946  -3.869  1.00 17.61           C  
ATOM   1628  CG  LEU   222       8.783  39.513  -3.568  1.00 18.69           C  
ATOM   1629  CD1 LEU   222       8.813  38.720  -4.849  1.00 19.94           C  
ATOM   1630  CD2 LEU   222      10.141  39.432  -2.857  1.00 20.71           C  
ATOM   1631  N   PRO   223       9.006  44.170  -3.499  1.00 22.05           N  
ATOM   1632  CA  PRO   223       8.735  45.432  -4.199  1.00 23.24           C  
ATOM   1633  C   PRO   223       8.219  45.147  -5.644  1.00 24.73           C  
ATOM   1634  O   PRO   223       8.453  44.071  -6.172  1.00 23.36           O  
ATOM   1635  CB  PRO   223      10.102  46.129  -4.224  1.00 22.98           C  
ATOM   1636  CG  PRO   223      10.992  45.386  -3.256  1.00 23.58           C  
ATOM   1637  CD  PRO   223      10.414  43.998  -3.114  1.00 22.06           C  
ATOM   1638  N   ALA   224       7.538  46.118  -6.255  1.00 26.52           N  
ATOM   1639  CA  ALA   224       7.013  45.993  -7.628  1.00 27.20           C  
ATOM   1640  C   ALA   224       8.122  45.798  -8.679  1.00 27.32           C  
ATOM   1641  O   ALA   224       7.891  45.228  -9.744  1.00 27.65           O  
ATOM   1642  CB  ALA   224       6.187  47.210  -7.969  1.00 27.94           C  
ATOM   1643  N   THR   225       9.320  46.257  -8.349  1.00 27.06           N  
ATOM   1644  CA  THR   225      10.485  46.172  -9.227  1.00 27.45           C  
ATOM   1645  C   THR   225      11.260  44.855  -9.100  1.00 26.00           C  
ATOM   1646  O   THR   225      12.251  44.629  -9.804  1.00 26.66           O  
ATOM   1647  CB  THR   225      11.428  47.339  -8.900  1.00 28.46           C  
ATOM   1648  OG1 THR   225      11.377  47.607  -7.486  1.00 31.78           O  
ATOM   1649  CG2 THR   225      10.985  48.581  -9.650  1.00 30.14           C  
ATOM   1650  N   LEU   226      10.828  43.975  -8.199  1.00 23.06           N  
ATOM   1651  CA  LEU   226      11.565  42.749  -7.951  0.70 22.35           C  
ATOM   1653  C   LEU   226      10.794  41.516  -8.397  1.00 22.73           C  
ATOM   1654  O   LEU   226       9.766  41.165  -7.805  1.00 23.06           O  
ATOM   1655  CB  LEU   226      11.915  42.621  -6.462  0.70 22.21           C  
ATOM   1657  CG  LEU   226      12.645  41.357  -6.011  0.70 21.36           C  
ATOM   1659  CD1 LEU   226      14.027  41.305  -6.595  0.70 19.42           C  
ATOM   1661  CD2 LEU   226      12.727  41.337  -4.500  0.70 21.10           C  
ATOM   1663  N   SER   227      11.318  40.850  -9.417  1.00 21.25           N  
ATOM   1664  CA  SER   227      10.727  39.614  -9.908  1.00 20.51           C  
ATOM   1665  C   SER   227      11.064  38.461  -8.957  1.00 20.26           C  
ATOM   1666  O   SER   227      12.080  38.498  -8.239  1.00 19.13           O  
ATOM   1667  CB  SER   227      11.282  39.296 -11.304  1.00 20.26           C  
ATOM   1668  OG  SER   227      12.667  39.041 -11.219  1.00 20.10           O  
ATOM   1669  N   ARG   228      10.236  37.418  -8.960  1.00 20.07           N  
ATOM   1670  CA  ARG   228      10.622  36.175  -8.282  1.00 19.92           C  
ATOM   1671  C   ARG   228      11.911  35.579  -8.856  1.00 20.94           C  
ATOM   1672  O   ARG   228      12.730  35.000  -8.118  1.00 20.58           O  
ATOM   1673  CB  ARG   228       9.483  35.143  -8.344  1.00 19.92           C  
ATOM   1674  CG  ARG   228       8.135  35.696  -7.878  1.00 20.51           C  
ATOM   1675  CD  ARG   228       7.076  34.614  -7.959  1.00 21.49           C  
ATOM   1676  NE  ARG   228       7.084  33.695  -6.813  1.00 21.75           N  
ATOM   1677  CZ  ARG   228       6.488  33.960  -5.648  1.00 21.92           C  
ATOM   1678  NH1 ARG   228       6.549  33.053  -4.678  1.00 21.92           N  
ATOM   1679  NH2 ARG   228       5.858  35.129  -5.441  1.00 19.45           N  
ATOM   1680  N   SER   229      12.135  35.746 -10.171  1.00 20.25           N  
ATOM   1681  CA  SER   229      13.321  35.200 -10.798  1.00 20.93           C  
ATOM   1682  C   SER   229      14.635  35.825 -10.306  1.00 20.97           C  
ATOM   1683  O   SER   229      15.655  35.134 -10.249  1.00 20.98           O  
ATOM   1684  CB  SER   229      13.227  35.330 -12.319  1.00 21.06           C  
ATOM   1685  OG  SER   229      12.191  34.481 -12.787  1.00 21.93           O  
ATOM   1686  N   GLU   230      14.582  37.105  -9.951  1.00 21.77           N  
ATOM   1687  CA  GLU   230      15.745  37.842  -9.443  1.00 23.44           C  
ATOM   1688  C   GLU   230      16.241  37.121  -8.208  1.00 24.30           C  
ATOM   1689  O   GLU   230      17.427  36.822  -8.038  1.00 23.11           O  
ATOM   1690  CB  GLU   230      15.327  39.232  -8.986  1.00 24.88           C  
ATOM   1691  CG  GLU   230      16.446  39.964  -8.211  1.00 25.43           C  
ATOM   1692  CD  GLU   230      17.011  41.126  -8.957  1.00 26.89           C  
ATOM   1693  OE1 GLU   230      16.267  41.704  -9.768  1.00 24.08           O  
ATOM   1694  OE2 GLU   230      18.173  41.500  -8.684  1.00 27.40           O  
ATOM   1695  N   LEU   231      15.273  36.842  -7.355  1.00 24.65           N  
ATOM   1696  CA  LEU   231      15.505  36.472  -5.987  1.00 27.37           C  
ATOM   1697  C   LEU   231      16.227  35.128  -5.920  1.00 29.19           C  
ATOM   1698  O   LEU   231      17.116  34.926  -5.074  1.00 30.79           O  
ATOM   1699  CB  LEU   231      14.133  36.437  -5.258  1.00 26.15           C  
ATOM   1700  CG  LEU   231      14.103  35.965  -3.808  1.00 25.48           C  
ATOM   1701  CD1 LEU   231      13.097  36.817  -3.039  1.00 24.11           C  
ATOM   1702  CD2 LEU   231      13.722  34.484  -3.709  1.00 24.46           C  
ATOM   1703  N   MET   232      15.892  34.259  -6.869  1.00 31.30           N  
ATOM   1704  CA  MET   232      16.273  32.841  -6.802  0.50 32.60           C  
ATOM   1706  C   MET   232      17.579  32.519  -7.520  1.00 32.66           C  
ATOM   1707  O   MET   232      18.270  31.545  -7.156  1.00 33.58           O  
ATOM   1708  CB  MET   232      15.130  31.960  -7.316  0.50 32.48           C  
ATOM   1710  CG  MET   232      13.833  32.197  -6.556  0.50 33.23           C  
ATOM   1712  SD  MET   232      12.288  31.294  -7.301  0.50 34.88          SE  
ATOM   1714  CE  MET   232      12.824  29.439  -6.973  0.50 35.68           C  
ATOM   1716  N   SER   233      17.902  33.327  -8.515  1.00 32.34           N  
ATOM   1717  CA  SER   233      19.173  33.283  -9.197  1.00 32.73           C  
ATOM   1718  C   SER   233      19.526  34.735  -9.260  1.00 32.27           C  
ATOM   1719  O   SER   233      18.661  35.516  -9.653  1.00 33.00           O  
ATOM   1720  CB  SER   233      19.010  32.787 -10.617  1.00 33.04           C  
ATOM   1721  OG  SER   233      18.096  33.619 -11.336  1.00 37.07           O  
ATOM   1722  N   VAL   234      20.759  35.092  -8.861  1.00 30.11           N  
ATOM   1723  CA  VAL   234      21.353  36.417  -9.039  1.00 29.06           C  
ATOM   1724  C   VAL   234      21.759  36.972  -7.668  1.00 27.42           C  
ATOM   1725  O   VAL   234      20.861  37.292  -6.847  1.00 27.92           O  
ATOM   1726  CB  VAL   234      20.401  37.472  -9.761  1.00 30.12           C  
ATOM   1727  CG1 VAL   234      21.032  38.881  -9.755  1.00 32.18           C  
ATOM   1728  CG2 VAL   234      20.084  37.050 -11.177  1.00 30.59           C  
ATOM   1729  N   THR   235      23.084  37.044  -7.414  1.00 24.54           N  
ATOM   1730  CA  THR   235      23.611  37.828  -6.274  1.00 21.55           C  
ATOM   1731  C   THR   235      24.970  38.463  -6.580  1.00 20.36           C  
ATOM   1732  O   THR   235      25.994  37.787  -6.534  1.00 20.67           O  
ATOM   1733  CB  THR   235      23.793  36.967  -4.996  1.00 20.99           C  
ATOM   1734  OG1 THR   235      22.701  36.060  -4.860  1.00 21.81           O  
ATOM   1735  CG2 THR   235      23.909  37.893  -3.732  1.00 19.10           C  
ATOM   1736  N   PRO   236      24.994  39.767  -6.880  1.00 18.67           N  
ATOM   1737  CA  PRO   236      26.263  40.458  -7.209  1.00 17.30           C  
ATOM   1738  C   PRO   236      27.175  40.544  -5.981  1.00 16.11           C  
ATOM   1739  O   PRO   236      26.660  40.543  -4.861  1.00 15.24           O  
ATOM   1740  CB  PRO   236      25.813  41.883  -7.586  1.00 18.40           C  
ATOM   1741  CG  PRO   236      24.320  41.835  -7.742  1.00 19.11           C  
ATOM   1742  CD  PRO   236      23.824  40.662  -6.942  1.00 18.91           C  
ATOM   1743  N   ASN   237      28.495  40.623  -6.184  1.00 15.37           N  
ATOM   1744  CA  ASN   237      29.410  40.915  -5.067  1.00 14.60           C  
ATOM   1745  C   ASN   237      29.053  42.256  -4.406  1.00 13.70           C  
ATOM   1746  O   ASN   237      28.875  43.267  -5.093  1.00 15.31           O  
ATOM   1747  CB  ASN   237      30.871  40.917  -5.503  1.00 14.73           C  
ATOM   1748  CG  ASN   237      31.377  39.526  -5.865  1.00 15.52           C  
ATOM   1749  OD1 ASN   237      31.642  39.260  -7.037  1.00 19.53           O  
ATOM   1750  ND2 ASN   237      31.449  38.610  -4.870  1.00 14.35           N  
ATOM   1751  N   THR   238      28.974  42.244  -3.083  1.00 12.97           N  
ATOM   1752  CA  THR   238      28.441  43.358  -2.231  1.00 12.00           C  
ATOM   1753  C   THR   238      27.022  43.852  -2.533  1.00 13.36           C  
ATOM   1754  O   THR   238      26.633  44.940  -2.108  1.00 13.65           O  
ATOM   1755  CB  THR   238      29.436  44.556  -2.091  1.00 12.82           C  
ATOM   1756  OG1 THR   238      29.545  45.243  -3.343  1.00 14.76           O  
ATOM   1757  CG2 THR   238      30.807  44.035  -1.598  1.00 13.59           C  
ATOM   1758  N   GLY   239      26.268  43.034  -3.271  1.00 13.24           N  
ATOM   1759  CA  GLY   239      24.830  43.263  -3.519  1.00 13.93           C  
ATOM   1760  C   GLY   239      24.107  43.245  -2.182  1.00 13.74           C  
ATOM   1761  O   GLY   239      24.339  42.340  -1.368  1.00 14.21           O  
ATOM   1762  N   MET   240      23.242  44.239  -1.966  1.00 12.78           N  
ATOM   1763  CA  MET   240      22.584  44.447  -0.685  1.00 13.58           C  
ATOM   1764  C   MET   240      21.069  44.208  -0.750  1.00 13.24           C  
ATOM   1765  O   MET   240      20.395  44.680  -1.660  1.00 13.69           O  
ATOM   1766  CB  MET   240      22.806  45.896  -0.220  1.00 15.11           C  
ATOM   1767  CG  MET   240      24.272  46.251  -0.086  1.00 15.12           C  
ATOM   1768  SD  MET   240      24.362  48.070   0.611  1.00 18.77          SE  
ATOM   1769  CE  MET   240      26.264  48.246   0.501  1.00 18.08           C  
ATOM   1770  N   SER   241      20.549  43.509   0.255  1.00 13.14           N  
ATOM   1771  CA  SER   241      19.119  43.255   0.356  0.70 12.52           C  
ATOM   1773  C   SER   241      18.692  43.676   1.746  1.00 13.29           C  
ATOM   1774  O   SER   241      19.403  43.434   2.713  1.00 14.20           O  
ATOM   1775  CB  SER   241      18.850  41.760   0.131  0.70 12.45           C  
ATOM   1777  OG  SER   241      19.292  41.387  -1.161  0.70 10.80           O  
ATOM   1779  N   LEU   242      17.529  44.328   1.846  1.00 12.23           N  
ATOM   1780  CA  LEU   242      16.979  44.770   3.117  1.00 12.90           C  
ATOM   1781  C   LEU   242      15.586  44.170   3.282  1.00 11.83           C  
ATOM   1782  O   LEU   242      14.755  44.272   2.345  1.00 12.05           O  
ATOM   1783  CB  LEU   242      16.875  46.318   3.160  1.00 13.04           C  
ATOM   1784  CG  LEU   242      16.191  46.884   4.429  1.00 15.99           C  
ATOM   1785  CD1 LEU   242      16.974  46.593   5.720  1.00 15.29           C  
ATOM   1786  CD2 LEU   242      16.016  48.428   4.269  1.00 14.21           C  
ATOM   1787  N   PHE   243      15.361  43.622   4.482  1.00 11.67           N  
ATOM   1788  CA  PHE   243      14.080  43.045   4.930  1.00 12.76           C  
ATOM   1789  C   PHE   243      13.642  43.680   6.256  1.00 12.46           C  
ATOM   1790  O   PHE   243      14.480  43.930   7.155  1.00 12.87           O  
ATOM   1791  CB  PHE   243      14.219  41.532   5.128  1.00 12.81           C  
ATOM   1792  CG  PHE   243      14.701  40.822   3.892  1.00 13.64           C  
ATOM   1793  CD1 PHE   243      13.810  40.355   2.948  1.00 14.82           C  
ATOM   1794  CD2 PHE   243      16.068  40.676   3.672  1.00 15.31           C  
ATOM   1795  CE1 PHE   243      14.283  39.710   1.748  1.00 14.92           C  
ATOM   1796  CE2 PHE   243      16.548  40.066   2.540  1.00 12.18           C  
ATOM   1797  CZ  PHE   243      15.672  39.588   1.565  1.00 10.84           C  
ATOM   1798  N   ILE   244      12.335  43.896   6.398  1.00 12.62           N  
ATOM   1799  CA  ILE   244      11.789  44.211   7.698  1.00 12.69           C  
ATOM   1800  C   ILE   244      11.060  42.959   8.227  1.00 11.90           C  
ATOM   1801  O   ILE   244      10.181  42.396   7.558  1.00 12.22           O  
ATOM   1802  CB  ILE   244      10.846  45.460   7.683  1.00 13.59           C  
ATOM   1803  CG1 ILE   244      11.553  46.710   7.095  1.00 16.20           C  
ATOM   1804  CG2 ILE   244      10.370  45.738   9.092  1.00 14.97           C  
ATOM   1805  CD1 ILE   244      12.795  47.147   7.862  1.00 19.67           C  
ATOM   1806  N   ILE   245      11.453  42.509   9.412  1.00 11.60           N  
ATOM   1807  CA  ILE   245      10.858  41.320  10.032  1.00 11.68           C  
ATOM   1808  C   ILE   245       9.879  41.784  11.105  1.00 13.67           C  
ATOM   1809  O   ILE   245      10.246  42.595  11.946  1.00 13.43           O  
ATOM   1810  CB  ILE   245      11.944  40.445  10.706  1.00 11.82           C  
ATOM   1811  CG1 ILE   245      13.184  40.245   9.781  1.00 12.57           C  
ATOM   1812  CG2 ILE   245      11.358  39.134  11.191  1.00 13.22           C  
ATOM   1813  CD1 ILE   245      12.849  39.659   8.365  1.00 14.11           C  
ATOM   1814  N   ASN   246       8.674  41.220  11.116  1.00 12.98           N  
ATOM   1815  CA  ASN   246       7.570  41.742  11.953  1.00 14.16           C  
ATOM   1816  C   ASN   246       6.988  40.612  12.804  1.00 14.34           C  
ATOM   1817  O   ASN   246       6.585  39.556  12.275  1.00 13.56           O  
ATOM   1818  CB  ASN   246       6.425  42.270  11.045  1.00 15.39           C  
ATOM   1819  CG  ASN   246       6.871  43.351  10.067  1.00 18.81           C  
ATOM   1820  OD1 ASN   246       7.381  43.092   8.938  1.00 23.58           O  
ATOM   1821  ND2 ASN   246       6.644  44.593  10.475  1.00 22.31           N  
ATOM   1822  N   PHE   247       6.923  40.822  14.127  1.00 15.67           N  
ATOM   1823  CA  PHE   247       6.282  39.853  14.997  1.00 16.23           C  
ATOM   1824  C   PHE   247       5.077  40.508  15.677  1.00 18.30           C  
ATOM   1825  O   PHE   247       5.220  41.540  16.320  1.00 17.11           O  
ATOM   1826  CB  PHE   247       7.234  39.383  16.116  1.00 17.45           C  
ATOM   1827  CG  PHE   247       8.305  38.430  15.667  1.00 16.77           C  
ATOM   1828  CD1 PHE   247       8.106  37.063  15.754  1.00 17.77           C  
ATOM   1829  CD2 PHE   247       9.519  38.909  15.190  1.00 19.72           C  
ATOM   1830  CE1 PHE   247       9.088  36.164  15.310  1.00 19.81           C  
ATOM   1831  CE2 PHE   247      10.509  38.024  14.758  1.00 17.22           C  
ATOM   1832  CZ  PHE   247      10.293  36.657  14.829  1.00 18.61           C  
ATOM   1833  N   GLU   248       3.923  39.876  15.551  1.00 19.35           N  
ATOM   1834  CA  GLU   248       2.781  40.197  16.416  1.00 22.23           C  
ATOM   1835  C   GLU   248       3.103  39.774  17.853  1.00 22.71           C  
ATOM   1836  O   GLU   248       4.013  38.979  18.080  1.00 20.96           O  
ATOM   1837  CB  GLU   248       1.532  39.491  15.889  1.00 22.61           C  
ATOM   1838  CG  GLU   248       0.932  40.248  14.695  1.00 25.01           C  
ATOM   1839  CD  GLU   248      -0.290  39.602  14.050  1.00 26.62           C  
ATOM   1840  OE1 GLU   248      -0.802  38.579  14.550  1.00 32.28           O  
ATOM   1841  OE2 GLU   248      -0.744  40.145  13.015  1.00 33.12           O  
ATOM   1842  N   GLU   249       2.374  40.335  18.822  1.00 24.15           N  
ATOM   1843  CA  GLU   249       2.566  39.933  20.207  1.00 26.26           C  
ATOM   1844  C   GLU   249       2.084  38.503  20.390  1.00 24.94           C  
ATOM   1845  O   GLU   249       1.216  38.006  19.641  1.00 24.12           O  
ATOM   1846  CB  GLU   249       1.843  40.888  21.148  1.00 25.98           C  
ATOM   1847  CG  GLU   249       0.531  40.375  21.742  1.00 31.22           C  
ATOM   1848  CD  GLU   249      -0.230  41.493  22.450  1.00 30.94           C  
ATOM   1849  OE1 GLU   249       0.432  42.430  22.991  1.00 38.11           O  
ATOM   1850  OE2 GLU   249      -1.481  41.457  22.429  1.00 37.68           O  
ATOM   1851  N   GLY   250       2.678  37.831  21.362  1.00 24.73           N  
ATOM   1852  CA  GLY   250       2.268  36.496  21.738  1.00 25.76           C  
ATOM   1853  C   GLY   250       3.414  35.552  21.992  1.00 25.75           C  
ATOM   1854  O   GLY   250       4.567  35.989  22.161  1.00 25.79           O  
ATOM   1855  N   ARG   251       3.088  34.256  22.015  1.00 26.24           N  
ATOM   1856  CA  ARG   251       4.046  33.166  22.217  1.00 27.25           C  
ATOM   1857  C   ARG   251       4.241  32.399  20.920  1.00 27.77           C  
ATOM   1858  O   ARG   251       3.263  32.141  20.216  1.00 28.46           O  
ATOM   1859  CB  ARG   251       3.515  32.186  23.283  1.00 27.24           C  
ATOM   1860  CG  ARG   251       3.140  32.856  24.591  1.00 28.49           C  
ATOM   1861  CD  ARG   251       2.561  31.859  25.640  1.00 28.57           C  
ATOM   1862  NE  ARG   251       1.780  32.587  26.639  1.00 33.40           N  
ATOM   1863  CZ  ARG   251       2.276  33.080  27.773  1.00 34.86           C  
ATOM   1864  NH1 ARG   251       3.558  32.901  28.084  1.00 34.71           N  
ATOM   1865  NH2 ARG   251       1.480  33.746  28.602  1.00 36.04           N  
ATOM   1866  N   GLU   252       5.493  32.042  20.616  1.00 27.82           N  
ATOM   1867  CA  GLU   252       5.857  31.247  19.428  1.00 28.91           C  
ATOM   1868  C   GLU   252       5.214  31.815  18.146  1.00 26.70           C  
ATOM   1869  O   GLU   252       4.576  31.089  17.373  1.00 27.41           O  
ATOM   1870  CB  GLU   252       5.455  29.774  19.617  1.00 28.85           C  
ATOM   1871  CG  GLU   252       6.465  28.782  19.055  1.00 32.65           C  
ATOM   1872  CD  GLU   252       6.321  27.363  19.621  1.00 32.84           C  
ATOM   1873  OE1 GLU   252       7.240  26.561  19.360  1.00 40.25           O  
ATOM   1874  OE2 GLU   252       5.302  27.029  20.290  1.00 38.53           O  
ATOM   1875  N   VAL   253       5.371  33.117  17.958  1.00 25.17           N  
ATOM   1876  CA  VAL   253       4.775  33.851  16.836  1.00 22.77           C  
ATOM   1877  C   VAL   253       5.595  33.691  15.556  1.00 21.79           C  
ATOM   1878  O   VAL   253       6.816  33.855  15.559  1.00 21.90           O  
ATOM   1879  CB  VAL   253       4.580  35.341  17.196  1.00 22.33           C  
ATOM   1880  CG1 VAL   253       4.074  36.171  15.993  1.00 21.72           C  
ATOM   1881  CG2 VAL   253       3.605  35.476  18.387  1.00 24.21           C  
ATOM   1882  N   LYS   254       4.895  33.354  14.475  1.00 20.12           N  
ATOM   1883  CA  LYS   254       5.478  33.286  13.146  1.00 18.03           C  
ATOM   1884  C   LYS   254       5.614  34.706  12.594  1.00 17.17           C  
ATOM   1885  O   LYS   254       4.621  35.404  12.471  1.00 16.18           O  
ATOM   1886  CB  LYS   254       4.570  32.497  12.207  1.00 19.08           C  
ATOM   1887  CG  LYS   254       5.238  32.176  10.891  1.00 19.33           C  
ATOM   1888  CD  LYS   254       4.260  31.439   9.948  1.00 26.85           C  
ATOM   1889  CE  LYS   254       4.926  31.017   8.656  1.00 30.92           C  
ATOM   1890  NZ  LYS   254       3.996  30.199   7.841  1.00 34.45           N  
ATOM   1891  N   PRO   255       6.841  35.118  12.235  1.00 15.86           N  
ATOM   1892  CA  PRO   255       6.987  36.492  11.743  1.00 14.73           C  
ATOM   1893  C   PRO   255       6.441  36.684  10.334  1.00 14.00           C  
ATOM   1894  O   PRO   255       6.259  35.704   9.594  1.00 15.12           O  
ATOM   1895  CB  PRO   255       8.517  36.704  11.706  1.00 14.51           C  
ATOM   1896  CG  PRO   255       9.068  35.329  11.521  1.00 15.15           C  
ATOM   1897  CD  PRO   255       8.117  34.382  12.249  1.00 16.49           C  
ATOM   1898  N   THR   256       6.163  37.928   9.982  1.00 13.78           N  
ATOM   1899  CA  THR   256       5.953  38.277   8.570  1.00 13.57           C  
ATOM   1900  C   THR   256       7.164  39.079   8.096  1.00 13.58           C  
ATOM   1901  O   THR   256       7.872  39.668   8.915  1.00 14.02           O  
ATOM   1902  CB  THR   256       4.658  39.061   8.380  1.00 13.94           C  
ATOM   1903  OG1 THR   256       4.633  40.216   9.244  1.00 15.02           O  
ATOM   1904  CG2 THR   256       3.466  38.145   8.671  1.00 14.83           C  
ATOM   1905  N   VAL   257       7.398  39.098   6.782  1.00 11.39           N  
ATOM   1906  CA  VAL   257       8.633  39.673   6.254  1.00 11.79           C  
ATOM   1907  C   VAL   257       8.275  40.582   5.067  1.00 12.49           C  
ATOM   1908  O   VAL   257       7.431  40.238   4.259  1.00 11.88           O  
ATOM   1909  CB  VAL   257       9.603  38.560   5.797  1.00 12.20           C  
ATOM   1910  CG1 VAL   257      10.891  39.173   5.158  1.00 12.84           C  
ATOM   1911  CG2 VAL   257       9.926  37.554   6.989  1.00 11.37           C  
ATOM   1912  N   GLN   258       8.886  41.761   5.028  1.00 12.80           N  
ATOM   1913  CA  GLN   258       8.757  42.676   3.898  1.00 14.83           C  
ATOM   1914  C   GLN   258      10.146  42.821   3.279  1.00 13.10           C  
ATOM   1915  O   GLN   258      11.081  43.235   3.951  1.00 13.61           O  
ATOM   1916  CB  GLN   258       8.279  44.066   4.374  1.00 15.18           C  
ATOM   1917  CG  GLN   258       6.887  44.059   4.975  1.00 18.60           C  
ATOM   1918  CD  GLN   258       6.563  45.334   5.754  1.00 21.61           C  
ATOM   1919  OE1 GLN   258       7.172  45.643   6.800  1.00 26.56           O  
ATOM   1920  NE2 GLN   258       5.584  46.086   5.239  1.00 28.76           N  
ATOM   1921  N   CYS   259      10.274  42.453   2.014  1.00 13.04           N  
ATOM   1922  CA  CYS   259      11.499  42.712   1.287  1.00 12.61           C  
ATOM   1923  C   CYS   259      11.459  44.148   0.753  1.00 13.03           C  
ATOM   1924  O   CYS   259      10.541  44.511  -0.009  1.00 14.63           O  
ATOM   1925  CB  CYS   259      11.669  41.726   0.144  1.00 13.09           C  
ATOM   1926  SG  CYS   259      13.167  42.105  -0.790  1.00 14.63           S  
ATOM   1927  N   ILE   260      12.415  44.952   1.191  1.00 13.62           N  
ATOM   1928  CA  ILE   260      12.519  46.388   0.817  1.00 14.08           C  
ATOM   1929  C   ILE   260      13.311  46.576  -0.486  1.00 15.41           C  
ATOM   1930  O   ILE   260      12.898  47.347  -1.378  1.00 15.09           O  
ATOM   1931  CB  ILE   260      13.128  47.246   1.960  1.00 14.59           C  
ATOM   1932  CG1 ILE   260      12.328  47.110   3.275  1.00 13.59           C  
ATOM   1933  CG2 ILE   260      13.302  48.705   1.519  1.00 15.12           C  
ATOM   1934  CD1 ILE   260      10.798  47.437   3.184  1.00 17.11           C  
ATOM   1935  N   CYS   261      14.436  45.867  -0.603  1.00 14.81           N  
ATOM   1936  CA  CYS   261      15.202  45.843  -1.858  1.00 15.96           C  
ATOM   1937  C   CYS   261      16.019  44.575  -1.893  1.00 16.00           C  
ATOM   1938  O   CYS   261      16.188  43.935  -0.853  1.00 16.30           O  
ATOM   1939  CB  CYS   261      16.111  47.071  -1.964  1.00 16.22           C  
ATOM   1940  SG  CYS   261      17.350  47.186  -0.680  1.00 20.19           S  
ATOM   1941  N   MET   262      16.475  44.188  -3.076  1.00 16.20           N  
ATOM   1942  CA  MET   262      17.340  43.008  -3.196  1.00 17.67           C  
ATOM   1943  C   MET   262      18.416  43.285  -4.214  1.00 17.67           C  
ATOM   1944  O   MET   262      18.147  43.915  -5.245  1.00 17.51           O  
ATOM   1945  CB  MET   262      16.526  41.772  -3.601  1.00 17.55           C  
ATOM   1946  CG  MET   262      17.351  40.476  -3.744  1.00 20.14           C  
ATOM   1947  SD  MET   262      16.188  38.954  -3.853  1.00 20.86          SE  
ATOM   1948  CE  MET   262      15.557  39.102  -2.039  1.00 21.38           C  
ATOM   1949  N   ASN   263      19.633  42.828  -3.916  1.00 16.44           N  
ATOM   1950  CA  ASN   263      20.752  42.967  -4.856  1.00 17.08           C  
ATOM   1951  C   ASN   263      21.022  44.425  -5.263  1.00 18.00           C  
ATOM   1952  O   ASN   263      21.442  44.694  -6.418  1.00 19.37           O  
ATOM   1953  CB  ASN   263      20.519  42.091  -6.092  1.00 16.01           C  
ATOM   1954  CG  ASN   263      20.470  40.618  -5.748  1.00 17.20           C  
ATOM   1955  OD1 ASN   263      21.136  40.190  -4.797  1.00 16.42           O  
ATOM   1956  ND2 ASN   263      19.749  39.824  -6.544  1.00 20.11           N  
ATOM   1957  N   LEU   264      20.781  45.343  -4.337  1.00 18.06           N  
ATOM   1958  CA  LEU   264      21.088  46.764  -4.563  1.00 20.40           C  
ATOM   1959  C   LEU   264      22.596  46.926  -4.814  1.00 21.29           C  
ATOM   1960  O   LEU   264      23.418  46.399  -4.050  1.00 20.30           O  
ATOM   1961  CB  LEU   264      20.687  47.612  -3.350  1.00 20.35           C  
ATOM   1962  CG  LEU   264      20.446  49.114  -3.581  1.00 23.12           C  
ATOM   1963  CD1 LEU   264      19.371  49.296  -4.670  1.00 24.12           C  
ATOM   1964  CD2 LEU   264      20.018  49.775  -2.298  1.00 21.83           C  
ATOM   1965  N   GLN   265      22.955  47.657  -5.874  1.00 22.67           N  
ATOM   1966  CA  GLN   265      24.380  47.952  -6.140  1.00 25.66           C  
ATOM   1967  C   GLN   265      24.668  49.436  -6.393  1.00 26.47           C  
ATOM   1968  O   GLN   265      25.604  49.743  -7.139  1.00 27.18           O  
ATOM   1969  CB  GLN   265      24.925  47.188  -7.351  1.00 25.38           C  
ATOM   1970  CG  GLN   265      24.243  45.906  -7.762  1.00 28.61           C  
ATOM   1971  CD  GLN   265      24.906  45.265  -8.962  1.00 28.26           C  
ATOM   1972  OE1 GLN   265      26.146  45.211  -9.065  1.00 33.40           O  
ATOM   1973  NE2 GLN   265      24.092  44.746  -9.872  1.00 33.70           N  
ATOM   1974  N   ASP   266      23.903  50.326  -5.753  1.00 28.13           N  
ATOM   1975  CA  ASP   266      24.028  51.794  -5.906  1.00 30.32           C  
ATOM   1976  C   ASP   266      25.391  52.326  -5.456  1.00 30.83           C  
ATOM   1977  O   ASP   266      25.838  53.402  -5.891  1.00 31.49           O  
ATOM   1978  CB  ASP   266      22.934  52.499  -5.094  1.00 30.71           C  
ATOM   1979  CG  ASP   266      21.547  52.313  -5.687  1.00 32.76           C  
ATOM   1980  OD1 ASP   266      21.434  51.819  -6.830  1.00 35.90           O  
ATOM   1981  OD2 ASP   266      20.569  52.687  -5.007  1.00 35.33           O  
ATOM   1982  N   HIS   267      26.040  51.590  -4.563  1.00 29.75           N  
ATOM   1983  CA  HIS   267      27.378  51.928  -4.124  1.00 29.59           C  
ATOM   1984  C   HIS   267      28.480  51.599  -5.154  1.00 30.49           C  
ATOM   1985  O   HIS   267      29.633  52.004  -4.962  1.00 31.58           O  
ATOM   1986  CB  HIS   267      27.657  51.216  -2.800  1.00 28.97           C  
ATOM   1987  CG  HIS   267      27.627  49.725  -2.912  1.00 24.06           C  
ATOM   1988  ND1 HIS   267      26.469  49.026  -3.188  1.00 22.05           N  
ATOM   1989  CD2 HIS   267      28.611  48.804  -2.805  1.00 21.74           C  
ATOM   1990  CE1 HIS   267      26.745  47.732  -3.246  1.00 20.69           C  
ATOM   1991  NE2 HIS   267      28.039  47.574  -3.021  1.00 19.76           N  
ATOM   1992  N   LEU   268      28.151  50.870  -6.222  1.00 31.07           N  
ATOM   1993  CA  LEU   268      29.165  50.394  -7.182  1.00 32.45           C  
ATOM   1994  C   LEU   268      29.296  51.186  -8.499  1.00 34.57           C  
ATOM   1995  O   LEU   268      30.254  50.978  -9.247  1.00 34.93           O  
ATOM   1996  CB  LEU   268      28.976  48.905  -7.512  1.00 31.83           C  
ATOM   1997  CG  LEU   268      29.246  47.899  -6.388  1.00 30.13           C  
ATOM   1998  CD1 LEU   268      29.144  46.464  -6.905  1.00 30.71           C  
ATOM   1999  CD2 LEU   268      30.618  48.155  -5.758  1.00 30.78           C  
ATOM   2000  N   ASN   269      28.346  52.062  -8.794  1.00 36.54           N  
ATOM   2001  CA  ASN   269      28.369  52.782 -10.078  1.00 38.57           C  
ATOM   2002  C   ASN   269      29.384  53.929 -10.094  1.00 39.07           C  
ATOM   2003  O   ASN   269      30.600  53.710  -9.978  1.00 39.36           O  
ATOM   2004  CB  ASN   269      26.960  53.264 -10.476  1.00 39.59           C  
ATOM   2005  CG  ASN   269      26.201  53.925  -9.316  1.00 41.98           C  
ATOM   2006  OD1 ASN   269      26.802  54.562  -8.435  1.00 44.75           O  
ATOM   2007  ND2 ASN   269      24.873  53.793  -9.327  1.00 44.56           N  
END
