
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  207 ( 1665),  selected  207 , name 1h2e_A
# Molecule2: number of CA atoms  247 ( 1945),  selected  247 , name T0394.pdb
# PARAMETERS: 1h2e_A.T0394.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      N       1           -
LGA    -       -      L       2           -
LGA    -       -      Y       3           -
LGA    -       -      F       4           -
LGA    -       -      Q       5           -
LGA    -       -      S       6           -
LGA    -       -      A       7           -
LGA    A     2_A      R       8          1.526
LGA    T     3_A      F       9          1.335
LGA    T     4_A      A      10          0.597
LGA    L     5_A      L      11          0.290
LGA    Y     6_A      T      12          0.250
LGA    L     7_A      V      13          0.328
LGA    T     8_A      V      14          0.774
LGA    R     9_A      R      15          0.368
LGA    H    10_A      H      16          0.474
LGA    G    11_A      G      17          0.323
LGA    E    12_A      E      18          0.367
LGA    T    13_A      T      19          0.366
LGA    K    14_A      R      20          0.275
LGA    W    15_A      F      21          0.349
LGA    N    16_A      N      22          0.319
LGA    V    17_A      K      23          0.639
LGA    E    18_A      E      24          0.998
LGA    R    19_A      K      25          0.740
LGA    R    20_A      I      26          0.574
LGA    M    21_A      I      27          0.455
LGA    Q    22_A      Q      28          0.802
LGA    G    23_A      G      29          0.558
LGA    W    24_A      Q      30          0.478
LGA    Q    25_A      G      31          1.943
LGA    D    26_A      V      32          3.614
LGA    -       -      D      33           -
LGA    S    27_A      E      34          1.370
LGA    P    28_A      P      35          1.947
LGA    L    29_A      L      36          0.935
LGA    T    30_A      S      37          1.415
LGA    E    31_A      E      38          1.478
LGA    K    32_A      T      39          1.324
LGA    G    33_A      G      40          1.046
LGA    R    34_A      F      41          0.994
LGA    Q    35_A      K      42          0.926
LGA    D    36_A      Q      43          0.965
LGA    A    37_A      A      44          0.810
LGA    M    38_A      A      45          0.755
LGA    R    39_A      A      46          0.996
LGA    L    40_A      A      47          0.867
LGA    G    41_A      G      48          0.776
LGA    K    42_A      I      49          1.195
LGA    R    43_A      F      50          1.444
LGA    L    44_A      L      51          1.252
LGA    E    45_A      N      52          1.258
LGA    A    46_A      N      53          1.295
LGA    V    47_A      V      54          1.100
LGA    E    48_A      K      55          0.855
LGA    L    49_A      F      56          0.939
LGA    A    50_A      T      57          1.268
LGA    A    51_A      H      58          1.887
LGA    I    52_A      A      59          1.042
LGA    Y    53_A      F      60          0.326
LGA    T    54_A      S      61          0.490
LGA    S    55_A      S      62          0.624
LGA    T    56_A      D      63          0.733
LGA    S    57_A      L      64          0.763
LGA    G    58_A      M      65          0.629
LGA    R    59_A      R      66          0.363
LGA    A    60_A      T      67          0.459
LGA    L    61_A      K      68          0.396
LGA    E    62_A      Q      69          0.507
LGA    T    63_A      T      70          0.349
LGA    A    64_A      M      71          0.387
LGA    E    65_A      H      72          0.522
LGA    I    66_A      G      73          0.612
LGA    V    67_A      I      74          0.363
LGA    R    68_A      L      75          0.396
LGA    G    69_A      E      76          0.534
LGA    G    70_A      R      77          6.125
LGA    -       -      S      78           -
LGA    -       -      K      79           -
LGA    -       -      F      80           -
LGA    -       -      C      81           -
LGA    R    71_A      K      82          0.486
LGA    L    72_A      D      83          1.603
LGA    I    73_A      M      84          0.978
LGA    P    74_A      T      85          1.075
LGA    I    75_A      V      86          0.441
LGA    Y    76_A      K      87          0.494
LGA    Q    77_A      Y      88          0.452
LGA    D    78_A      D      89          0.475
LGA    E    79_A      S      90          0.532
LGA    R    80_A      R      91          0.462
LGA    L    81_A      L      92          0.448
LGA    R    82_A      R      93          0.376
LGA    E    83_A      E      94          0.390
LGA    I    84_A      R      95          0.428
LGA    H    85_A      K      96          0.621
LGA    L    86_A      Y      97          0.550
LGA    G    87_A      G      98          0.240
LGA    D    88_A      V      99          0.640
LGA    W    89_A      V     100          0.711
LGA    E    90_A      E     101          0.267
LGA    G    91_A      G     102          0.527
LGA    K    92_A      K     103          0.562
LGA    T    93_A      A     104          0.766
LGA    H    94_A      L     105          1.995
LGA    D    95_A      S     106          3.055
LGA    E    96_A      E     107          3.503
LGA    I    97_A      L     108          3.501
LGA    R    98_A      R     109          4.371
LGA    Q    99_A      A     110          4.956
LGA    M   100_A      -       -           -
LGA    D   101_A      -       -           -
LGA    P   102_A      -       -           -
LGA    I   103_A      M     111          4.825
LGA    A   104_A      A     112          1.983
LGA    F   105_A      K     113           #
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    -       -      R     116           -
LGA    D   106_A      E     117          5.558
LGA    H   107_A      E     118          1.439
LGA    F   108_A      C     119          1.827
LGA    W   109_A      P     120          3.396
LGA    Q   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    P   112_A      V     121          2.228
LGA    H   113_A      -       -           -
LGA    L   114_A      -       -           -
LGA    Y   115_A      F     122          2.319
LGA    A   116_A      T     123          4.236
LGA    P   117_A      P     124          3.746
LGA    Q   118_A      P     125          3.819
LGA    R   119_A      G     126          2.230
LGA    G   120_A      G     127          1.589
LGA    E   121_A      E     128          0.728
LGA    R   122_A      T     129          0.205
LGA    F   123_A      L     130          0.486
LGA    C   124_A      D     131          0.422
LGA    D   125_A      Q     132          0.396
LGA    V   126_A      V     133          0.580
LGA    Q   127_A      K     134          0.435
LGA    Q   128_A      M     135          0.724
LGA    R   129_A      R     136          0.916
LGA    A   130_A      G     137          1.538
LGA    L   131_A      I     138          1.925
LGA    E   132_A      D     139          1.170
LGA    A   133_A      F     140          0.777
LGA    V   134_A      F     141          2.036
LGA    Q   135_A      E     142          2.125
LGA    S   136_A      F     143          1.180
LGA    I   137_A      L     144          1.766
LGA    V   138_A      C     145          2.586
LGA    D   139_A      Q     146          2.085
LGA    R   140_A      L     147          1.653
LGA    H   141_A      I     148          2.452
LGA    E   142_A      L     149          3.964
LGA    -       -      K     150           -
LGA    -       -      E     151           -
LGA    -       -      A     152           -
LGA    -       -      D     153           -
LGA    -       -      Q     154           -
LGA    -       -      K     155           -
LGA    -       -      N     165           -
LGA    -       -      C     166           -
LGA    -       -      L     167           -
LGA    -       -      E     168           -
LGA    -       -      T     169           -
LGA    -       -      S     170           -
LGA    -       -      L     171           -
LGA    -       -      A     172           -
LGA    -       -      E     173           -
LGA    -       -      I     174           -
LGA    -       -      F     175           -
LGA    -       -      P     176           -
LGA    -       -      L     177           -
LGA    -       -      I     191           -
LGA    -       -      P     192           -
LGA    -       -      G     193           -
LGA    -       -      L     194           -
LGA    G   143_A      A     195          0.847
LGA    E   144_A      A     196          0.635
LGA    T   145_A      S     197          0.461
LGA    V   146_A      V     198          1.002
LGA    L   147_A      L     199          0.403
LGA    I   148_A      V     200          0.342
LGA    V   149_A      V     201          0.377
LGA    T   150_A      S     202          0.398
LGA    H   151_A      H     203          0.340
LGA    G   152_A      G     204          0.410
LGA    V   153_A      A     205          0.354
LGA    V   154_A      Y     206          0.589
LGA    L   155_A      M     207          0.774
LGA    K   156_A      R     208          0.497
LGA    T   157_A      S     209          0.448
LGA    L   158_A      L     210          0.983
LGA    M   159_A      F     211          1.048
LGA    A   160_A      D     212          0.790
LGA    A   161_A      Y     213          0.930
LGA    F   162_A      F     214          0.846
LGA    K   163_A      L     215          0.916
LGA    D   164_A      T     216          1.010
LGA    T   165_A      D     217          6.665
LGA    P   166_A      L     218           -
LGA    L   167_A      K     219           -
LGA    D   168_A      C     220           -
LGA    H   169_A      S     221           -
LGA    L   170_A      L     222           -
LGA    W   171_A      P     223           -
LGA    -       -      A     224           -
LGA    -       -      T     225           -
LGA    -       -      L     226           -
LGA    -       -      S     227           -
LGA    -       -      R     228           -
LGA    S   172_A      S     229          2.617
LGA    P   173_A      E     230          1.362
LGA    P   174_A      L     231          4.574
LGA    -       -      M     232           -
LGA    -       -      S     233           -
LGA    Y   175_A      V     234          1.825
LGA    M   176_A      T     235          1.262
LGA    Y   177_A      P     236          0.622
LGA    G   178_A      N     237          0.958
LGA    T   179_A      T     238          0.759
LGA    S   180_A      G     239          1.063
LGA    V   181_A      M     240          1.143
LGA    T   182_A      S     241          0.392
LGA    I   183_A      L     242          0.483
LGA    I   184_A      F     243          0.882
LGA    E   185_A      I     244          0.452
LGA    V   186_A      I     245          0.580
LGA    D   187_A      N     246          0.763
LGA    G   188_A      F     247          1.863
LGA    -       -      E     248           -
LGA    -       -      E     249           -
LGA    -       -      G     250           -
LGA    -       -      R     251           -
LGA    -       -      E     252           -
LGA    -       -      V     253           -
LGA    -       -      K     254           -
LGA    G   189_A      P     255          1.745
LGA    T   190_A      T     256          1.497
LGA    F   191_A      V     257          2.010
LGA    H   192_A      Q     258          1.735
LGA    V   193_A      C     259          0.998
LGA    A   194_A      I     260          1.328
LGA    V   195_A      C     261          1.177
LGA    E   196_A      M     262          1.019
LGA    G   197_A      N     263          1.020
LGA    D   198_A      L     264          0.886
LGA    V   199_A      Q     265          0.909
LGA    S   200_A      D     266          1.051
LGA    H   201_A      H     267          1.017
LGA    I   202_A      L     268          0.953
LGA    E   203_A      N     269          2.318
LGA    E   204_A      -       -           -
LGA    V   205_A      -       -           -
LGA    K   206_A      -       -           -
LGA    E   207_A      -       -           -
LGA    V   208_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  207  247    5.0    188    1.67    26.06     71.385    10.612

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.951439 * X  +  -0.033692 * Y  +  -0.305989 * Z  +  80.647110
  Y_new =   0.218050 * X  +   0.627885 * Y  +  -0.747137 * Z  +  30.255260
  Z_new =   0.217298 * X  +  -0.777576 * Y  +  -0.590048 * Z  + -45.697742 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.219925    0.921668  [ DEG:  -127.1923     52.8077 ]
  Theta =  -0.219046   -2.922547  [ DEG:   -12.5504   -167.4496 ]
  Phi   =   2.916304   -0.225289  [ DEG:   167.0919    -12.9081 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1h2e_A                                        
REMARK     2: T0394.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1h2e_A.T0394.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  207  247   5.0  188   1.67   26.06  71.385
REMARK  ---------------------------------------------------------- 
MOLECULE 1h2e_A
HEADER    HYDROLASE                               08-AUG-02   1H2E              
TITLE     BACILLUS STEAROTHERMOPHILUS PHOE (PREVIOUSLY KNOWN AS YHFR)           
TITLE    2 IN COMPLEX WITH PHOSPHATE                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHATASE;                                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: YHFR;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS STEAROTHERMOPHILUS;                    
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   5 EXPRESSION_SYSTEM_PLASMID: PS3297                                    
KEYWDS    HYDROLASE, BROAD SPECIFICITY PHOSPHATASE, DPGM HOMOLOG                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.J.RIGDEN,J.LITTLEJOHN,M.J.JEDRZEJAS                                 
REVDAT   2   17-MAR-05 1H2E    1       JRNL                                     
REVDAT   1   12-AUG-02 1H2E    0                                                
JRNL        AUTH   D.J.RIGDEN,J.E.LITTLEJOHN,K.HENDERSON,M.J.JEDRZEJAS          
JRNL        TITL   STRUCTURES OF PHOSPHATE AND TRIVANADATE COMPLEXES            
JRNL        TITL 2 OF BACILLUS STEAROTHERMOPHILUS PHOSPHATASE PHOE:             
JRNL        TITL 3 STRUCTURAL AND FUNCTIONAL ANALYSIS IN THE                    
JRNL        TITL 4 COFACTOR-DEPENDENT PHOSPHOGLYCERATE MUTASE                   
JRNL        TITL 5 SUPERFAMILY.                                                 
JRNL        REF    J.MOL.BIOL.                   V. 325   411 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.69 ANGSTROMS.                                          
DBREF  1H2E A    2     7  UNP    Q9ALU0   Q9ALU0_BACST     2      7             
DBREF  1H2E A    8   202  UNP    Q9ALU0   Q9ALU0           1    195             
DBREF  1H2E A  203   208  UNP    Q9ALU0   Q9ALU0_BACST   203    208             
SEQRES   1 A  207  ALA THR THR LEU TYR LEU THR ARG HIS GLY GLU THR LYS          
SEQRES   2 A  207  TRP ASN VAL GLU ARG ARG MET GLN GLY TRP GLN ASP SER          
SEQRES   3 A  207  PRO LEU THR GLU LYS GLY ARG GLN ASP ALA MET ARG LEU          
SEQRES   4 A  207  GLY LYS ARG LEU GLU ALA VAL GLU LEU ALA ALA ILE TYR          
SEQRES   5 A  207  THR SER THR SER GLY ARG ALA LEU GLU THR ALA GLU ILE          
SEQRES   6 A  207  VAL ARG GLY GLY ARG LEU ILE PRO ILE TYR GLN ASP GLU          
SEQRES   7 A  207  ARG LEU ARG GLU ILE HIS LEU GLY ASP TRP GLU GLY LYS          
SEQRES   8 A  207  THR HIS ASP GLU ILE ARG GLN MET ASP PRO ILE ALA PHE          
SEQRES   9 A  207  ASP HIS PHE TRP GLN ALA PRO HIS LEU TYR ALA PRO GLN          
SEQRES  10 A  207  ARG GLY GLU ARG PHE CYS ASP VAL GLN GLN ARG ALA LEU          
SEQRES  11 A  207  GLU ALA VAL GLN SER ILE VAL ASP ARG HIS GLU GLY GLU          
SEQRES  12 A  207  THR VAL LEU ILE VAL THR HIS GLY VAL VAL LEU LYS THR          
SEQRES  13 A  207  LEU MET ALA ALA PHE LYS ASP THR PRO LEU ASP HIS LEU          
SEQRES  14 A  207  TRP SER PRO PRO TYR MET TYR GLY THR SER VAL THR ILE          
SEQRES  15 A  207  ILE GLU VAL ASP GLY GLY THR PHE HIS VAL ALA VAL GLU          
SEQRES  16 A  207  GLY ASP VAL SER HIS ILE GLU GLU VAL LYS GLU VAL              
HET    PO4  A1209       5                                                       
HET    EDO  A1210       4                                                       
HET    EDO  A1211       4                                                       
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   2  PO4    O4 P 3-                                                      
FORMUL   3  EDO    2(C2 H6 O2)                                                  
FORMUL   5  HOH   *174(H2 O)                                                    
CRYST1   55.546   55.546  164.645  90.00  90.00  90.00 P 41 21 2     8          
ATOM      1  N   ALA A   2      10.373  42.791  16.191  1.00 37.34           N  
ATOM      2  CA  ALA A   2      10.739  43.933  15.305  1.00 36.69           C  
ATOM      3  C   ALA A   2      12.252  44.026  15.155  1.00 36.61           C  
ATOM      4  O   ALA A   2      12.945  44.522  16.046  1.00 36.29           O  
ATOM      5  CB  ALA A   2      10.196  45.232  15.878  1.00 35.39           C  
ATOM      6  N   THR A   3      12.758  43.548  14.024  1.00 34.14           N  
ATOM      7  CA  THR A   3      14.190  43.577  13.750  1.00 31.34           C  
ATOM      8  C   THR A   3      14.394  43.923  12.279  1.00 31.03           C  
ATOM      9  O   THR A   3      13.638  43.463  11.432  1.00 29.99           O  
ATOM     10  CB  THR A   3      14.838  42.194  14.024  1.00 31.93           C  
ATOM     11  OG1 THR A   3      14.606  41.811  15.388  1.00 31.57           O  
ATOM     12  CG2 THR A   3      16.338  42.244  13.768  1.00 29.92           C  
ATOM     13  N   THR A   4      15.397  44.746  11.979  1.00 28.51           N  
ATOM     14  CA  THR A   4      15.696  45.100  10.594  1.00 27.09           C  
ATOM     15  C   THR A   4      16.981  44.375  10.202  1.00 28.54           C  
ATOM     16  O   THR A   4      18.003  44.504  10.882  1.00 28.15           O  
ATOM     17  CB  THR A   4      15.894  46.622  10.418  1.00 29.91           C  
ATOM     18  OG1 THR A   4      14.658  47.297  10.682  1.00 28.66           O  
ATOM     19  CG2 THR A   4      16.348  46.945   8.997  1.00 26.63           C  
ATOM     20  N   LEU A   5      16.925  43.601   9.120  1.00 25.39           N  
ATOM     21  CA  LEU A   5      18.092  42.850   8.662  1.00 27.54           C  
ATOM     22  C   LEU A   5      18.641  43.312   7.318  1.00 26.01           C  
ATOM     23  O   LEU A   5      17.915  43.346   6.324  1.00 26.63           O  
ATOM     24  CB  LEU A   5      17.754  41.358   8.527  1.00 26.38           C  
ATOM     25  CG  LEU A   5      17.222  40.572   9.724  1.00 24.63           C  
ATOM     26  CD1 LEU A   5      16.868  39.154   9.272  1.00 26.62           C  
ATOM     27  CD2 LEU A   5      18.261  40.551  10.835  1.00 28.71           C  
ATOM     28  N   TYR A   6      19.919  43.679   7.289  1.00 24.51           N  
ATOM     29  CA  TYR A   6      20.564  44.047   6.031  1.00 24.75           C  
ATOM     30  C   TYR A   6      21.346  42.794   5.651  1.00 26.06           C  
ATOM     31  O   TYR A   6      22.116  42.273   6.461  1.00 25.07           O  
ATOM     32  CB  TYR A   6      21.545  45.216   6.201  1.00 24.04           C  
ATOM     33  CG  TYR A   6      20.896  46.583   6.171  1.00 29.04           C  
ATOM     34  CD1 TYR A   6      20.069  47.004   7.209  1.00 27.87           C  
ATOM     35  CD2 TYR A   6      21.112  47.455   5.101  1.00 28.96           C  
ATOM     36  CE1 TYR A   6      19.468  48.265   7.186  1.00 31.34           C  
ATOM     37  CE2 TYR A   6      20.516  48.718   5.067  1.00 30.19           C  
ATOM     38  CZ  TYR A   6      19.696  49.114   6.113  1.00 31.50           C  
ATOM     39  OH  TYR A   6      19.098  50.351   6.086  1.00 33.59           O  
ATOM     40  N   LEU A   7      21.139  42.302   4.435  1.00 25.42           N  
ATOM     41  CA  LEU A   7      21.834  41.104   3.974  1.00 26.85           C  
ATOM     42  C   LEU A   7      22.711  41.464   2.784  1.00 28.06           C  
ATOM     43  O   LEU A   7      22.286  42.212   1.905  1.00 29.06           O  
ATOM     44  CB  LEU A   7      20.836  40.026   3.524  1.00 30.07           C  
ATOM     45  CG  LEU A   7      19.688  39.616   4.449  1.00 33.16           C  
ATOM     46  CD1 LEU A   7      18.878  38.499   3.790  1.00 34.81           C  
ATOM     47  CD2 LEU A   7      20.240  39.160   5.784  1.00 36.23           C  
ATOM     48  N   THR A   8      23.927  40.927   2.747  1.00 26.65           N  
ATOM     49  CA  THR A   8      24.813  41.195   1.622  1.00 25.50           C  
ATOM     50  C   THR A   8      25.699  39.989   1.336  1.00 25.27           C  
ATOM     51  O   THR A   8      25.747  39.029   2.115  1.00 24.22           O  
ATOM     52  CB  THR A   8      25.698  42.448   1.871  1.00 24.48           C  
ATOM     53  OG1 THR A   8      26.325  42.837   0.641  1.00 29.40           O  
ATOM     54  CG2 THR A   8      26.786  42.161   2.911  1.00 22.25           C  
ATOM     55  N   ARG A   9      26.383  40.037   0.198  1.00 24.30           N  
ATOM     56  CA  ARG A   9      27.293  38.975  -0.210  1.00 26.96           C  
ATOM     57  C   ARG A   9      28.719  39.512  -0.106  1.00 25.31           C  
ATOM     58  O   ARG A   9      28.945  40.711  -0.276  1.00 27.71           O  
ATOM     59  CB  ARG A   9      27.002  38.570  -1.657  1.00 26.77           C  
ATOM     60  CG  ARG A   9      27.837  37.406  -2.158  1.00 29.86           C  
ATOM     61  CD  ARG A   9      27.535  37.139  -3.624  1.00 32.51           C  
ATOM     62  NE  ARG A   9      28.407  36.117  -4.191  1.00 32.75           N  
ATOM     63  CZ  ARG A   9      28.566  35.927  -5.498  1.00 38.91           C  
ATOM     64  NH1 ARG A   9      27.910  36.694  -6.361  1.00 39.81           N  
ATOM     65  NH2 ARG A   9      29.387  34.985  -5.945  1.00 39.33           N  
ATOM     66  N   HIS A  10      29.674  38.635   0.180  1.00 23.63           N  
ATOM     67  CA  HIS A  10      31.071  39.043   0.285  1.00 26.03           C  
ATOM     68  C   HIS A  10      31.497  39.712  -1.030  1.00 28.72           C  
ATOM     69  O   HIS A  10      30.891  39.487  -2.090  1.00 25.37           O  
ATOM     70  CB  HIS A  10      31.949  37.819   0.541  1.00 27.56           C  
ATOM     71  CG  HIS A  10      32.048  36.909  -0.641  1.00 26.41           C  
ATOM     72  ND1 HIS A  10      32.914  37.144  -1.688  1.00 29.08           N  
ATOM     73  CD2 HIS A  10      31.324  35.818  -0.990  1.00 28.45           C  
ATOM     74  CE1 HIS A  10      32.716  36.241  -2.631  1.00 29.54           C  
ATOM     75  NE2 HIS A  10      31.755  35.426  -2.233  1.00 30.91           N  
ATOM     76  N   GLY A  11      32.533  40.539  -0.960  1.00 27.38           N  
ATOM     77  CA  GLY A  11      33.021  41.203  -2.156  1.00 30.59           C  
ATOM     78  C   GLY A  11      33.716  40.248  -3.115  1.00 30.86           C  
ATOM     79  O   GLY A  11      34.116  39.146  -2.741  1.00 31.29           O  
ATOM     80  N   GLU A  12      33.869  40.678  -4.363  1.00 32.20           N  
ATOM     81  CA  GLU A  12      34.510  39.861  -5.392  1.00 31.52           C  
ATOM     82  C   GLU A  12      35.866  39.290  -4.982  1.00 31.35           C  
ATOM     83  O   GLU A  12      36.723  40.013  -4.472  1.00 31.78           O  
ATOM     84  CB  GLU A  12      34.698  40.691  -6.662  1.00 31.66           C  
ATOM     85  CG  GLU A  12      35.308  39.916  -7.818  1.00 35.35           C  
ATOM     86  CD  GLU A  12      35.620  40.803  -9.011  1.00 36.72           C  
ATOM     87  OE1 GLU A  12      36.641  41.521  -8.968  1.00 36.61           O  
ATOM     88  OE2 GLU A  12      34.836  40.788  -9.983  1.00 38.80           O  
ATOM     89  N   THR A  13      36.059  37.994  -5.227  1.00 31.52           N  
ATOM     90  CA  THR A  13      37.320  37.322  -4.916  1.00 30.69           C  
ATOM     91  C   THR A  13      37.999  36.878  -6.215  1.00 36.11           C  
ATOM     92  O   THR A  13      37.423  36.987  -7.304  1.00 34.77           O  
ATOM     93  CB  THR A  13      37.107  36.065  -4.062  1.00 32.01           C  
ATOM     94  OG1 THR A  13      36.374  35.094  -4.822  1.00 30.21           O  
ATOM     95  CG2 THR A  13      36.349  36.406  -2.779  1.00 27.87           C  
ATOM     96  N   LYS A  14      39.217  36.364  -6.089  1.00 37.83           N  
ATOM     97  CA  LYS A  14      39.975  35.903  -7.241  1.00 40.67           C  
ATOM     98  C   LYS A  14      39.285  34.708  -7.922  1.00 40.61           C  
ATOM     99  O   LYS A  14      39.204  34.652  -9.151  1.00 40.60           O  
ATOM    100  CB  LYS A  14      41.404  35.552  -6.807  1.00 44.28           C  
ATOM    101  CG  LYS A  14      42.358  35.319  -7.964  1.00 53.50           C  
ATOM    102  CD  LYS A  14      43.777  35.125  -7.469  1.00 61.19           C  
ATOM    103  CE  LYS A  14      44.747  34.977  -8.631  1.00 65.00           C  
ATOM    104  NZ  LYS A  14      46.154  34.791  -8.169  1.00 69.32           N  
ATOM    105  N   TRP A  15      38.765  33.769  -7.136  1.00 36.19           N  
ATOM    106  CA  TRP A  15      38.083  32.611  -7.709  1.00 35.63           C  
ATOM    107  C   TRP A  15      36.768  33.021  -8.402  1.00 35.84           C  
ATOM    108  O   TRP A  15      36.349  32.374  -9.369  1.00 36.48           O  
ATOM    109  CB  TRP A  15      37.825  31.553  -6.627  1.00 35.72           C  
ATOM    110  CG  TRP A  15      39.040  30.760  -6.275  1.00 34.38           C  
ATOM    111  CD1 TRP A  15      40.325  31.048  -6.622  1.00 34.79           C  
ATOM    112  CD2 TRP A  15      39.094  29.556  -5.500  1.00 33.08           C  
ATOM    113  NE1 TRP A  15      41.177  30.103  -6.113  1.00 37.07           N  
ATOM    114  CE2 TRP A  15      40.449  29.175  -5.418  1.00 35.41           C  
ATOM    115  CE3 TRP A  15      38.128  28.764  -4.864  1.00 35.38           C  
ATOM    116  CZ2 TRP A  15      40.869  28.034  -4.726  1.00 36.05           C  
ATOM    117  CZ3 TRP A  15      38.546  27.624  -4.173  1.00 35.22           C  
ATOM    118  CH2 TRP A  15      39.906  27.274  -4.111  1.00 36.18           C  
ATOM    119  N   ASN A  16      36.119  34.089  -7.927  1.00 33.65           N  
ATOM    120  CA  ASN A  16      34.878  34.560  -8.562  1.00 34.35           C  
ATOM    121  C   ASN A  16      35.220  34.964  -9.999  1.00 37.13           C  
ATOM    122  O   ASN A  16      34.515  34.611 -10.950  1.00 37.73           O  
ATOM    123  CB  ASN A  16      34.301  35.781  -7.829  1.00 34.60           C  
ATOM    124  CG  ASN A  16      33.589  35.417  -6.531  1.00 33.64           C  
ATOM    125  OD1 ASN A  16      33.439  36.255  -5.638  1.00 34.56           O  
ATOM    126  ND2 ASN A  16      33.134  34.173  -6.428  1.00 34.72           N  
ATOM    127  N   VAL A  17      36.302  35.725 -10.138  1.00 37.40           N  
ATOM    128  CA  VAL A  17      36.761  36.179 -11.444  1.00 39.41           C  
ATOM    129  C   VAL A  17      37.170  34.993 -12.321  1.00 39.11           C  
ATOM    130  O   VAL A  17      36.875  34.971 -13.517  1.00 40.21           O  
ATOM    131  CB  VAL A  17      37.968  37.137 -11.308  1.00 39.24           C  
ATOM    132  CG1 VAL A  17      38.560  37.433 -12.680  1.00 40.68           C  
ATOM    133  CG2 VAL A  17      37.534  38.429 -10.644  1.00 39.07           C  
ATOM    134  N   GLU A  18      37.842  34.009 -11.727  1.00 38.18           N  
ATOM    135  CA  GLU A  18      38.294  32.832 -12.469  1.00 41.02           C  
ATOM    136  C   GLU A  18      37.189  31.793 -12.656  1.00 42.24           C  
ATOM    137  O   GLU A  18      37.434  30.708 -13.186  1.00 40.69           O  
ATOM    138  CB  GLU A  18      39.480  32.179 -11.751  1.00 42.38           C  
ATOM    139  CG  GLU A  18      40.594  33.148 -11.379  1.00 45.28           C  
ATOM    140  CD  GLU A  18      41.739  32.466 -10.656  1.00 47.29           C  
ATOM    141  OE1 GLU A  18      41.504  31.422 -10.011  1.00 49.12           O  
ATOM    142  OE2 GLU A  18      42.873  32.985 -10.716  1.00 52.39           O  
ATOM    143  N   ARG A  19      35.976  32.124 -12.224  1.00 42.69           N  
ATOM    144  CA  ARG A  19      34.849  31.204 -12.336  1.00 43.21           C  
ATOM    145  C   ARG A  19      35.137  29.860 -11.671  1.00 42.05           C  
ATOM    146  O   ARG A  19      34.751  28.806 -12.188  1.00 40.39           O  
ATOM    147  CB  ARG A  19      34.478  30.972 -13.804  1.00 50.98           C  
ATOM    148  CG  ARG A  19      33.324  31.826 -14.315  1.00 59.91           C  
ATOM    149  CD  ARG A  19      33.753  33.235 -14.699  1.00 67.00           C  
ATOM    150  NE  ARG A  19      32.617  34.007 -15.203  1.00 74.73           N  
ATOM    151  CZ  ARG A  19      32.710  35.211 -15.762  1.00 78.20           C  
ATOM    152  NH1 ARG A  19      33.893  35.795 -15.898  1.00 80.54           N  
ATOM    153  NH2 ARG A  19      31.617  35.833 -16.184  1.00 79.25           N  
ATOM    154  N   ARG A  20      35.832  29.900 -10.537  1.00 36.19           N  
ATOM    155  CA  ARG A  20      36.151  28.692  -9.779  1.00 37.31           C  
ATOM    156  C   ARG A  20      35.220  28.647  -8.577  1.00 37.37           C  
ATOM    157  O   ARG A  20      35.076  29.642  -7.867  1.00 36.28           O  
ATOM    158  CB  ARG A  20      37.588  28.722  -9.259  1.00 38.91           C  
ATOM    159  CG  ARG A  20      38.620  28.134 -10.180  1.00 44.10           C  
ATOM    160  CD  ARG A  20      39.992  28.195  -9.524  1.00 45.02           C  
ATOM    161  NE  ARG A  20      41.039  28.400 -10.517  1.00 46.86           N  
ATOM    162  CZ  ARG A  20      41.433  27.482 -11.391  1.00 46.77           C  
ATOM    163  NH1 ARG A  20      40.872  26.281 -11.393  1.00 46.94           N  
ATOM    164  NH2 ARG A  20      42.377  27.771 -12.275  1.00 49.14           N  
ATOM    165  N   MET A  21      34.580  27.504  -8.354  0.50 33.79           N  
ATOM    167  CA  MET A  21      33.663  27.373  -7.228  0.50 32.74           C  
ATOM    169  C   MET A  21      34.427  27.302  -5.910  0.50 32.80           C  
ATOM    171  O   MET A  21      35.382  26.535  -5.767  0.50 31.44           O  
ATOM    173  CB  MET A  21      32.774  26.139  -7.411  0.50 30.45           C  
ATOM    175  CG  MET A  21      31.982  26.172  -8.714  0.50 30.12           C  
ATOM    177  SD  MET A  21      30.664  24.947  -8.860  0.50 29.64           S  
ATOM    179  CE  MET A  21      29.246  25.906  -8.371  0.50 31.91           C  
ATOM    181  N   GLN A  22      33.994  28.110  -4.948  1.00 34.53           N  
ATOM    182  CA  GLN A  22      34.642  28.179  -3.643  1.00 31.34           C  
ATOM    183  C   GLN A  22      34.058  27.265  -2.567  1.00 29.76           C  
ATOM    184  O   GLN A  22      34.776  26.440  -1.998  1.00 31.69           O  
ATOM    185  CB  GLN A  22      34.646  29.631  -3.154  1.00 34.37           C  
ATOM    186  CG  GLN A  22      35.402  30.578  -4.082  1.00 37.49           C  
ATOM    187  CD  GLN A  22      35.279  32.033  -3.676  1.00 36.54           C  
ATOM    188  OE1 GLN A  22      36.252  32.658  -3.269  1.00 36.45           O  
ATOM    189  NE2 GLN A  22      34.073  32.578  -3.782  1.00 39.62           N  
ATOM    190  N   GLY A  23      32.763  27.402  -2.294  1.00 25.52           N  
ATOM    191  CA  GLY A  23      32.142  26.583  -1.264  1.00 25.56           C  
ATOM    192  C   GLY A  23      32.767  26.899   0.086  1.00 22.20           C  
ATOM    193  O   GLY A  23      32.788  28.057   0.499  1.00 24.47           O  
ATOM    194  N   TRP A  24      33.281  25.879   0.767  1.00 22.43           N  
ATOM    195  CA  TRP A  24      33.928  26.079   2.062  1.00 21.43           C  
ATOM    196  C   TRP A  24      35.394  26.482   1.893  1.00 24.74           C  
ATOM    197  O   TRP A  24      36.053  26.881   2.862  1.00 24.12           O  
ATOM    198  CB  TRP A  24      33.813  24.826   2.924  1.00 24.17           C  
ATOM    199  CG  TRP A  24      32.429  24.628   3.495  1.00 24.08           C  
ATOM    200  CD1 TRP A  24      31.293  25.320   3.168  1.00 22.81           C  
ATOM    201  CD2 TRP A  24      32.046  23.679   4.492  1.00 25.45           C  
ATOM    202  NE1 TRP A  24      30.228  24.859   3.904  1.00 23.50           N  
ATOM    203  CE2 TRP A  24      30.663  23.853   4.727  1.00 24.64           C  
ATOM    204  CE3 TRP A  24      32.739  22.701   5.218  1.00 28.49           C  
ATOM    205  CZ2 TRP A  24      29.957  23.076   5.651  1.00 26.50           C  
ATOM    206  CZ3 TRP A  24      32.036  21.929   6.140  1.00 26.99           C  
ATOM    207  CH2 TRP A  24      30.659  22.125   6.351  1.00 27.70           C  
ATOM    208  N   GLN A  25      35.911  26.376   0.673  1.00 23.28           N  
ATOM    209  CA  GLN A  25      37.276  26.815   0.425  1.00 25.61           C  
ATOM    210  C   GLN A  25      37.188  28.321   0.234  1.00 27.31           C  
ATOM    211  O   GLN A  25      36.098  28.866   0.049  1.00 27.33           O  
ATOM    212  CB  GLN A  25      37.886  26.093  -0.784  1.00 27.82           C  
ATOM    213  CG  GLN A  25      38.148  24.623  -0.455  1.00 32.33           C  
ATOM    214  CD  GLN A  25      38.927  23.879  -1.524  1.00 39.45           C  
ATOM    215  OE1 GLN A  25      39.109  22.663  -1.435  1.00 43.07           O  
ATOM    216  NE2 GLN A  25      39.391  24.601  -2.534  1.00 39.27           N  
ATOM    217  N   ASP A  26      38.324  29.004   0.273  1.00 26.52           N  
ATOM    218  CA  ASP A  26      38.313  30.460   0.215  1.00 27.39           C  
ATOM    219  C   ASP A  26      39.385  31.033  -0.706  1.00 30.46           C  
ATOM    220  O   ASP A  26      40.308  30.331  -1.116  1.00 32.78           O  
ATOM    221  CB  ASP A  26      38.500  30.962   1.665  1.00 27.33           C  
ATOM    222  CG  ASP A  26      38.232  32.456   1.846  1.00 31.56           C  
ATOM    223  OD1 ASP A  26      37.196  32.964   1.371  1.00 31.15           O  
ATOM    224  OD2 ASP A  26      39.056  33.126   2.512  1.00 29.53           O  
ATOM    225  N   SER A  27      39.245  32.310  -1.045  0.50 30.53           N  
ATOM    227  CA  SER A  27      40.220  33.010  -1.879  0.50 32.50           C  
ATOM    229  C   SER A  27      40.146  34.487  -1.503  0.50 33.64           C  
ATOM    231  O   SER A  27      39.108  34.966  -1.046  0.50 30.16           O  
ATOM    233  CB  SER A  27      39.938  32.804  -3.375  0.50 31.76           C  
ATOM    235  OG  SER A  27      38.704  33.365  -3.770  0.50 29.53           O  
ATOM    237  N   PRO A  28      41.249  35.230  -1.685  1.00 35.93           N  
ATOM    238  CA  PRO A  28      41.278  36.657  -1.342  1.00 35.41           C  
ATOM    239  C   PRO A  28      40.430  37.588  -2.207  1.00 31.83           C  
ATOM    240  O   PRO A  28      40.210  37.333  -3.390  1.00 34.33           O  
ATOM    241  CB  PRO A  28      42.766  36.991  -1.414  1.00 37.86           C  
ATOM    242  CG  PRO A  28      43.242  36.103  -2.524  1.00 38.36           C  
ATOM    243  CD  PRO A  28      42.555  34.788  -2.212  1.00 36.59           C  
ATOM    244  N   LEU A  29      39.946  38.668  -1.601  1.00 31.77           N  
ATOM    245  CA  LEU A  29      39.157  39.647  -2.331  1.00 33.32           C  
ATOM    246  C   LEU A  29      40.068  40.291  -3.367  1.00 35.59           C  
ATOM    247  O   LEU A  29      41.287  40.351  -3.181  1.00 34.93           O  
ATOM    248  CB  LEU A  29      38.639  40.751  -1.402  1.00 35.70           C  
ATOM    249  CG  LEU A  29      37.632  40.458  -0.288  1.00 36.51           C  
ATOM    250  CD1 LEU A  29      37.316  41.758   0.444  1.00 39.23           C  
ATOM    251  CD2 LEU A  29      36.365  39.872  -0.862  1.00 38.51           C  
ATOM    252  N   THR A  30      39.475  40.770  -4.453  1.00 34.10           N  
ATOM    253  CA  THR A  30      40.231  41.444  -5.497  1.00 36.60           C  
ATOM    254  C   THR A  30      40.181  42.924  -5.156  1.00 37.26           C  
ATOM    255  O   THR A  30      39.486  43.327  -4.221  1.00 33.61           O  
ATOM    256  CB  THR A  30      39.587  41.253  -6.880  1.00 36.71           C  
ATOM    257  OG1 THR A  30      38.263  41.802  -6.865  1.00 35.60           O  
ATOM    258  CG2 THR A  30      39.528  39.779  -7.246  1.00 35.73           C  
ATOM    259  N   GLU A  31      40.916  43.737  -5.909  1.00 38.01           N  
ATOM    260  CA  GLU A  31      40.923  45.175  -5.673  1.00 39.23           C  
ATOM    261  C   GLU A  31      39.497  45.679  -5.828  1.00 39.64           C  
ATOM    262  O   GLU A  31      39.022  46.507  -5.049  1.00 40.81           O  
ATOM    263  CB  GLU A  31      41.837  45.871  -6.687  1.00 41.25           C  
ATOM    264  CG  GLU A  31      41.817  47.399  -6.635  1.00 44.01           C  
ATOM    265  CD  GLU A  31      42.198  47.951  -5.273  1.00 47.56           C  
ATOM    266  OE1 GLU A  31      43.114  47.390  -4.636  1.00 50.28           O  
ATOM    267  OE2 GLU A  31      41.589  48.956  -4.847  1.00 49.74           O  
ATOM    268  N   LYS A  32      38.809  45.149  -6.832  1.00 40.61           N  
ATOM    269  CA  LYS A  32      37.443  45.551  -7.100  1.00 40.90           C  
ATOM    270  C   LYS A  32      36.564  45.139  -5.940  1.00 38.41           C  
ATOM    271  O   LYS A  32      35.703  45.887  -5.516  1.00 34.28           O  
ATOM    272  CB  LYS A  32      36.942  44.892  -8.390  1.00 45.61           C  
ATOM    273  CG  LYS A  32      35.684  45.529  -8.998  1.00 48.30           C  
ATOM    274  CD  LYS A  32      34.476  44.632  -8.808  1.00 51.94           C  
ATOM    275  CE  LYS A  32      33.237  45.136  -9.552  1.00 52.07           C  
ATOM    276  NZ  LYS A  32      32.958  46.611  -9.296  1.00 56.32           N  
ATOM    277  N   GLY A  33      36.796  43.926  -5.440  1.00 39.88           N  
ATOM    278  CA  GLY A  33      36.017  43.421  -4.322  1.00 36.35           C  
ATOM    279  C   GLY A  33      36.165  44.329  -3.115  1.00 35.85           C  
ATOM    280  O   GLY A  33      35.182  44.641  -2.434  1.00 30.98           O  
ATOM    281  N   ARG A  34      37.392  44.763  -2.846  0.50 32.75           N  
ATOM    283  CA  ARG A  34      37.638  45.643  -1.712  0.50 34.09           C  
ATOM    285  C   ARG A  34      36.999  47.005  -1.941  0.50 33.98           C  
ATOM    287  O   ARG A  34      36.453  47.603  -1.014  0.50 33.33           O  
ATOM    289  CB  ARG A  34      39.138  45.808  -1.474  0.50 33.94           C  
ATOM    291  CG  ARG A  34      39.847  44.522  -1.088  0.50 34.14           C  
ATOM    293  CD  ARG A  34      41.175  44.824  -0.422  0.50 36.19           C  
ATOM    295  NE  ARG A  34      42.084  45.557  -1.297  0.50 35.99           N  
ATOM    297  CZ  ARG A  34      43.039  44.992  -2.028  0.50 35.49           C  
ATOM    299  NH1 ARG A  34      43.221  43.680  -1.993  0.50 35.94           N  
ATOM    301  NH2 ARG A  34      43.819  45.743  -2.795  0.50 37.49           N  
ATOM    303  N   GLN A  35      37.066  47.489  -3.178  1.00 36.10           N  
ATOM    304  CA  GLN A  35      36.478  48.783  -3.520  1.00 37.43           C  
ATOM    305  C   GLN A  35      34.963  48.754  -3.325  1.00 35.04           C  
ATOM    306  O   GLN A  35      34.373  49.725  -2.841  1.00 34.40           O  
ATOM    307  CB  GLN A  35      36.795  49.154  -4.974  1.00 40.95           C  
ATOM    308  CG  GLN A  35      38.243  49.547  -5.231  1.00 46.54           C  
ATOM    309  CD  GLN A  35      38.656  50.784  -4.456  1.00 48.74           C  
ATOM    310  OE1 GLN A  35      37.953  51.796  -4.460  1.00 49.40           O  
ATOM    311  NE2 GLN A  35      39.807  50.713  -3.794  1.00 52.36           N  
ATOM    312  N   ASP A  36      34.334  47.646  -3.713  1.00 33.84           N  
ATOM    313  CA  ASP A  36      32.886  47.500  -3.563  1.00 33.40           C  
ATOM    314  C   ASP A  36      32.506  47.480  -2.084  1.00 32.01           C  
ATOM    315  O   ASP A  36      31.521  48.099  -1.675  1.00 32.67           O  
ATOM    316  CB  ASP A  36      32.388  46.209  -4.232  1.00 33.30           C  
ATOM    317  CG  ASP A  36      32.434  46.270  -5.755  1.00 38.74           C  
ATOM    318  OD1 ASP A  36      32.447  47.389  -6.314  1.00 41.40           O  
ATOM    319  OD2 ASP A  36      32.438  45.195  -6.392  1.00 38.44           O  
ATOM    320  N   ALA A  37      33.286  46.758  -1.284  1.00 29.22           N  
ATOM    321  CA  ALA A  37      33.023  46.674   0.147  1.00 29.08           C  
ATOM    322  C   ALA A  37      33.143  48.070   0.759  1.00 31.46           C  
ATOM    323  O   ALA A  37      32.355  48.452   1.626  1.00 31.61           O  
ATOM    324  CB  ALA A  37      34.011  45.713   0.803  1.00 29.70           C  
ATOM    325  N   MET A  38      34.133  48.828   0.294  1.00 32.47           N  
ATOM    326  CA  MET A  38      34.353  50.189   0.770  1.00 35.46           C  
ATOM    327  C   MET A  38      33.134  51.056   0.459  1.00 35.78           C  
ATOM    328  O   MET A  38      32.691  51.840   1.297  1.00 36.23           O  
ATOM    329  CB  MET A  38      35.596  50.781   0.105  1.00 37.64           C  
ATOM    330  CG  MET A  38      36.894  50.151   0.554  1.00 41.43           C  
ATOM    331  SD  MET A  38      38.226  50.414  -0.637  1.00 48.16           S  
ATOM    332  CE  MET A  38      38.640  52.094  -0.279  1.00 45.20           C  
ATOM    333  N   ARG A  39      32.623  50.906  -0.761  1.00 37.14           N  
ATOM    334  CA  ARG A  39      31.434  51.639  -1.195  1.00 40.83           C  
ATOM    335  C   ARG A  39      30.222  51.270  -0.315  1.00 38.48           C  
ATOM    336  O   ARG A  39      29.405  52.112   0.001  1.00 35.67           O  
ATOM    337  CB  ARG A  39      31.093  51.317  -2.662  1.00 47.51           C  
ATOM    338  CG  ARG A  39      32.070  51.831  -3.730  1.00 58.36           C  
ATOM    339  CD  ARG A  39      31.523  53.109  -4.314  1.00 66.09           C  
ATOM    340  NE  ARG A  39      32.371  53.687  -5.351  1.00 72.46           N  
ATOM    341  CZ  ARG A  39      32.144  54.870  -5.913  1.00 73.68           C  
ATOM    342  NH1 ARG A  39      31.094  55.595  -5.528  1.00 73.85           N  
ATOM    343  NH2 ARG A  39      32.966  55.330  -6.848  1.00 74.08           N  
ATOM    344  N   LEU A  40      30.113  50.004   0.088  1.00 35.28           N  
ATOM    345  CA  LEU A  40      28.997  49.545   0.910  1.00 31.85           C  
ATOM    346  C   LEU A  40      29.133  50.133   2.314  1.00 31.70           C  
ATOM    347  O   LEU A  40      28.143  50.521   2.934  1.00 33.37           O  
ATOM    348  CB  LEU A  40      28.961  48.012   0.985  1.00 32.06           C  
ATOM    349  CG  LEU A  40      27.901  47.404   1.919  1.00 29.29           C  
ATOM    350  CD1 LEU A  40      26.513  47.889   1.530  1.00 31.33           C  
ATOM    351  CD2 LEU A  40      27.966  45.882   1.851  1.00 29.59           C  
ATOM    352  N   GLY A  41      30.365  50.195   2.808  1.00 31.05           N  
ATOM    353  CA  GLY A  41      30.605  50.754   4.127  1.00 32.10           C  
ATOM    354  C   GLY A  41      30.152  52.203   4.196  1.00 35.70           C  
ATOM    355  O   GLY A  41      29.625  52.652   5.215  1.00 36.24           O  
ATOM    356  N   LYS A  42      30.352  52.940   3.107  1.00 38.85           N  
ATOM    357  CA  LYS A  42      29.961  54.345   3.061  1.00 40.81           C  
ATOM    358  C   LYS A  42      28.442  54.458   3.033  1.00 39.15           C  
ATOM    359  O   LYS A  42      27.861  55.327   3.682  1.00 39.74           O  
ATOM    360  CB  LYS A  42      30.551  55.026   1.822  1.00 45.60           C  
ATOM    361  CG  LYS A  42      30.280  56.521   1.751  1.00 49.28           C  
ATOM    362  CD  LYS A  42      30.915  57.251   2.926  1.00 54.51           C  
ATOM    363  CE  LYS A  42      30.665  58.750   2.855  1.00 57.92           C  
ATOM    364  NZ  LYS A  42      31.339  59.476   3.966  1.00 59.53           N  
ATOM    365  N   ARG A  43      27.806  53.567   2.280  1.00 37.65           N  
ATOM    366  CA  ARG A  43      26.354  53.555   2.171  1.00 37.75           C  
ATOM    367  C   ARG A  43      25.680  53.277   3.513  1.00 36.77           C  
ATOM    368  O   ARG A  43      24.589  53.775   3.779  1.00 37.04           O  
ATOM    369  CB  ARG A  43      25.912  52.503   1.149  1.00 37.71           C  
ATOM    370  CG  ARG A  43      24.411  52.294   1.110  1.00 39.35           C  
ATOM    371  CD  ARG A  43      23.993  51.314   0.028  1.00 39.01           C  
ATOM    372  NE  ARG A  43      22.542  51.159   0.002  1.00 42.96           N  
ATOM    373  CZ  ARG A  43      21.865  50.536  -0.958  1.00 45.01           C  
ATOM    374  NH1 ARG A  43      22.508  49.998  -1.989  1.00 44.43           N  
ATOM    375  NH2 ARG A  43      20.542  50.458  -0.889  1.00 42.86           N  
ATOM    376  N   LEU A  44      26.334  52.489   4.360  1.00 35.30           N  
ATOM    377  CA  LEU A  44      25.764  52.143   5.661  1.00 35.95           C  
ATOM    378  C   LEU A  44      26.304  52.969   6.834  1.00 33.91           C  
ATOM    379  O   LEU A  44      25.978  52.693   7.988  1.00 32.68           O  
ATOM    380  CB  LEU A  44      25.999  50.651   5.941  1.00 31.67           C  
ATOM    381  CG  LEU A  44      25.503  49.679   4.859  1.00 30.99           C  
ATOM    382  CD1 LEU A  44      25.890  48.253   5.227  1.00 30.41           C  
ATOM    383  CD2 LEU A  44      23.992  49.802   4.710  1.00 31.73           C  
ATOM    384  N   GLU A  45      27.122  53.975   6.544  0.50 37.46           N  
ATOM    386  CA  GLU A  45      27.697  54.803   7.601  0.50 40.23           C  
ATOM    388  C   GLU A  45      26.664  55.501   8.479  0.50 41.17           C  
ATOM    390  O   GLU A  45      26.946  55.826   9.632  0.50 42.72           O  
ATOM    392  CB  GLU A  45      28.669  55.828   7.010  0.50 42.24           C  
ATOM    394  CG  GLU A  45      30.133  55.434   7.182  0.50 45.55           C  
ATOM    396  CD  GLU A  45      31.096  56.441   6.583  0.50 47.89           C  
ATOM    398  OE1 GLU A  45      30.839  57.657   6.703  0.50 49.91           O  
ATOM    400  OE2 GLU A  45      32.118  56.016   6.002  0.50 47.42           O  
ATOM    402  N   ALA A  46      25.470  55.729   7.939  1.00 41.24           N  
ATOM    403  CA  ALA A  46      24.404  56.378   8.703  1.00 42.64           C  
ATOM    404  C   ALA A  46      23.445  55.380   9.355  1.00 42.15           C  
ATOM    405  O   ALA A  46      22.634  55.755  10.203  1.00 42.61           O  
ATOM    406  CB  ALA A  46      23.625  57.337   7.805  1.00 43.75           C  
ATOM    407  N   VAL A  47      23.533  54.114   8.959  1.00 39.42           N  
ATOM    408  CA  VAL A  47      22.664  53.088   9.523  1.00 37.49           C  
ATOM    409  C   VAL A  47      23.210  52.643  10.878  1.00 37.62           C  
ATOM    410  O   VAL A  47      24.387  52.296  10.997  1.00 35.63           O  
ATOM    411  CB  VAL A  47      22.568  51.862   8.585  1.00 38.54           C  
ATOM    412  CG1 VAL A  47      21.644  50.812   9.189  1.00 37.43           C  
ATOM    413  CG2 VAL A  47      22.060  52.295   7.216  1.00 39.51           C  
ATOM    414  N   GLU A  48      22.353  52.655  11.896  0.50 37.70           N  
ATOM    416  CA  GLU A  48      22.754  52.251  13.240  0.50 39.29           C  
ATOM    418  C   GLU A  48      22.777  50.732  13.377  0.50 38.64           C  
ATOM    420  O   GLU A  48      21.767  50.112  13.712  0.50 40.16           O  
ATOM    422  CB  GLU A  48      21.805  52.852  14.284  0.50 40.86           C  
ATOM    424  CG  GLU A  48      22.072  52.379  15.708  0.50 43.99           C  
ATOM    426  CD  GLU A  48      21.261  53.128  16.747  0.50 46.99           C  
ATOM    428  OE1 GLU A  48      20.026  53.224  16.591  0.50 48.96           O  
ATOM    430  OE2 GLU A  48      21.861  53.618  17.727  0.50 48.16           O  
ATOM    432  N   LEU A  49      23.938  50.140  13.117  1.00 36.89           N  
ATOM    433  CA  LEU A  49      24.102  48.693  13.208  1.00 34.59           C  
ATOM    434  C   LEU A  49      24.510  48.263  14.616  1.00 32.29           C  
ATOM    435  O   LEU A  49      25.518  48.727  15.147  1.00 31.01           O  
ATOM    436  CB  LEU A  49      25.159  48.229  12.202  1.00 30.59           C  
ATOM    437  CG  LEU A  49      24.882  48.544  10.727  1.00 29.38           C  
ATOM    438  CD1 LEU A  49      26.121  48.248   9.887  1.00 30.57           C  
ATOM    439  CD2 LEU A  49      23.701  47.719  10.237  1.00 29.79           C  
ATOM    440  N   ALA A  50      23.722  47.375  15.214  1.00 27.57           N  
ATOM    441  CA  ALA A  50      24.011  46.880  16.558  1.00 28.33           C  
ATOM    442  C   ALA A  50      25.066  45.779  16.521  1.00 28.06           C  
ATOM    443  O   ALA A  50      25.766  45.538  17.506  1.00 28.07           O  
ATOM    444  CB  ALA A  50      22.732  46.352  17.208  1.00 30.66           C  
ATOM    445  N   ALA A  51      25.172  45.108  15.380  1.00 26.02           N  
ATOM    446  CA  ALA A  51      26.133  44.029  15.225  1.00 25.23           C  
ATOM    447  C   ALA A  51      26.213  43.627  13.768  1.00 24.45           C  
ATOM    448  O   ALA A  51      25.366  44.012  12.967  1.00 23.93           O  
ATOM    449  CB  ALA A  51      25.710  42.826  16.060  1.00 25.41           C  
ATOM    450  N   ILE A  52      27.257  42.872  13.440  1.00 23.44           N  
ATOM    451  CA  ILE A  52      27.472  42.353  12.096  1.00 24.60           C  
ATOM    452  C   ILE A  52      27.735  40.858  12.243  1.00 23.05           C  
ATOM    453  O   ILE A  52      28.578  40.437  13.040  1.00 23.46           O  
ATOM    454  CB  ILE A  52      28.699  43.012  11.414  1.00 25.85           C  
ATOM    455  CG1 ILE A  52      28.417  44.494  11.162  1.00 24.51           C  
ATOM    456  CG2 ILE A  52      29.015  42.291  10.085  1.00 25.94           C  
ATOM    457  CD1 ILE A  52      29.668  45.295  10.780  1.00 31.14           C  
ATOM    458  N   TYR A  53      26.987  40.055  11.498  1.00 22.02           N  
ATOM    459  CA  TYR A  53      27.160  38.608  11.529  1.00 23.04           C  
ATOM    460  C   TYR A  53      27.759  38.206  10.192  1.00 22.35           C  
ATOM    461  O   TYR A  53      27.359  38.713   9.147  1.00 23.95           O  
ATOM    462  CB  TYR A  53      25.814  37.911  11.740  1.00 23.30           C  
ATOM    463  CG  TYR A  53      25.311  38.030  13.165  1.00 24.44           C  
ATOM    464  CD1 TYR A  53      25.627  37.064  14.120  1.00 28.67           C  
ATOM    465  CD2 TYR A  53      24.577  39.142  13.571  1.00 25.73           C  
ATOM    466  CE1 TYR A  53      25.226  37.207  15.455  1.00 26.09           C  
ATOM    467  CE2 TYR A  53      24.176  39.298  14.901  1.00 26.09           C  
ATOM    468  CZ  TYR A  53      24.505  38.329  15.834  1.00 28.64           C  
ATOM    469  OH  TYR A  53      24.133  38.503  17.154  1.00 30.06           O  
ATOM    470  N   THR A  54      28.715  37.290  10.226  1.00 22.25           N  
ATOM    471  CA  THR A  54      29.364  36.864   8.997  1.00 24.42           C  
ATOM    472  C   THR A  54      29.601  35.363   9.026  1.00 23.15           C  
ATOM    473  O   THR A  54      29.592  34.744  10.092  1.00 25.86           O  
ATOM    474  CB  THR A  54      30.722  37.609   8.836  1.00 25.54           C  
ATOM    475  OG1 THR A  54      31.301  37.299   7.563  1.00 32.70           O  
ATOM    476  CG2 THR A  54      31.702  37.193   9.940  1.00 25.68           C  
ATOM    477  N   SER A  55      29.778  34.754   7.857  1.00 21.48           N  
ATOM    478  CA  SER A  55      30.080  33.342   7.844  1.00 23.87           C  
ATOM    479  C   SER A  55      31.557  33.339   8.256  1.00 26.56           C  
ATOM    480  O   SER A  55      32.197  34.398   8.274  1.00 28.10           O  
ATOM    481  CB  SER A  55      29.893  32.746   6.443  1.00 31.25           C  
ATOM    482  OG  SER A  55      31.092  32.730   5.704  1.00 26.19           O  
ATOM    483  N   THR A  56      32.087  32.167   8.587  1.00 28.19           N  
ATOM    484  CA  THR A  56      33.474  32.044   9.014  1.00 29.86           C  
ATOM    485  C   THR A  56      34.501  32.128   7.877  1.00 31.54           C  
ATOM    486  O   THR A  56      35.713  32.132   8.126  1.00 34.22           O  
ATOM    487  CB  THR A  56      33.674  30.729   9.811  1.00 28.95           C  
ATOM    488  OG1 THR A  56      33.137  29.621   9.072  1.00 32.45           O  
ATOM    489  CG2 THR A  56      32.956  30.814  11.156  1.00 29.98           C  
ATOM    490  N   SER A  57      34.028  32.210   6.636  1.00 27.41           N  
ATOM    491  CA  SER A  57      34.928  32.303   5.484  1.00 25.97           C  
ATOM    492  C   SER A  57      35.705  33.618   5.462  1.00 27.16           C  
ATOM    493  O   SER A  57      35.145  34.690   5.706  1.00 26.36           O  
ATOM    494  CB  SER A  57      34.141  32.168   4.174  1.00 29.14           C  
ATOM    495  OG  SER A  57      33.587  30.868   4.044  1.00 28.40           O  
ATOM    496  N   GLY A  58      37.000  33.531   5.158  1.00 26.43           N  
ATOM    497  CA  GLY A  58      37.826  34.720   5.102  1.00 25.23           C  
ATOM    498  C   GLY A  58      37.249  35.826   4.233  1.00 25.90           C  
ATOM    499  O   GLY A  58      37.253  36.990   4.629  1.00 25.22           O  
ATOM    500  N   ARG A  59      36.736  35.476   3.058  1.00 25.49           N  
ATOM    501  CA  ARG A  59      36.182  36.490   2.166  1.00 23.12           C  
ATOM    502  C   ARG A  59      35.011  37.241   2.787  1.00 23.18           C  
ATOM    503  O   ARG A  59      34.832  38.431   2.533  1.00 27.01           O  
ATOM    504  CB  ARG A  59      35.766  35.869   0.826  1.00 24.92           C  
ATOM    505  CG  ARG A  59      34.700  34.777   0.885  1.00 23.03           C  
ATOM    506  CD  ARG A  59      34.614  34.137  -0.503  1.00 24.36           C  
ATOM    507  NE  ARG A  59      33.687  33.012  -0.624  1.00 23.22           N  
ATOM    508  CZ  ARG A  59      33.889  31.790  -0.139  1.00 25.18           C  
ATOM    509  NH1 ARG A  59      32.968  30.851  -0.337  1.00 26.22           N  
ATOM    510  NH2 ARG A  59      34.986  31.502   0.554  1.00 25.49           N  
ATOM    511  N   ALA A  60      34.217  36.552   3.603  1.00 24.61           N  
ATOM    512  CA  ALA A  60      33.079  37.183   4.271  1.00 23.96           C  
ATOM    513  C   ALA A  60      33.570  38.076   5.418  1.00 22.46           C  
ATOM    514  O   ALA A  60      33.131  39.221   5.561  1.00 22.95           O  
ATOM    515  CB  ALA A  60      32.118  36.113   4.811  1.00 23.56           C  
ATOM    516  N   LEU A  61      34.476  37.550   6.237  1.00 22.80           N  
ATOM    517  CA  LEU A  61      35.015  38.326   7.352  1.00 24.19           C  
ATOM    518  C   LEU A  61      35.719  39.596   6.861  1.00 24.94           C  
ATOM    519  O   LEU A  61      35.536  40.672   7.423  1.00 25.56           O  
ATOM    520  CB  LEU A  61      35.998  37.487   8.171  1.00 26.02           C  
ATOM    521  CG  LEU A  61      36.646  38.236   9.347  1.00 27.11           C  
ATOM    522  CD1 LEU A  61      35.566  38.702  10.318  1.00 28.65           C  
ATOM    523  CD2 LEU A  61      37.632  37.328  10.053  1.00 27.96           C  
ATOM    524  N   GLU A  62      36.531  39.466   5.814  0.50 24.63           N  
ATOM    526  CA  GLU A  62      37.247  40.617   5.270  0.50 24.84           C  
ATOM    528  C   GLU A  62      36.273  41.687   4.783  0.50 25.03           C  
ATOM    530  O   GLU A  62      36.502  42.879   4.980  0.50 23.49           O  
ATOM    532  CB  GLU A  62      38.174  40.185   4.124  0.50 25.27           C  
ATOM    534  CG  GLU A  62      38.904  41.343   3.447  0.50 27.58           C  
ATOM    536  CD  GLU A  62      39.971  40.885   2.462  0.50 30.97           C  
ATOM    538  OE1 GLU A  62      40.541  41.745   1.758  0.50 30.82           O  
ATOM    540  OE2 GLU A  62      40.242  39.669   2.394  0.50 35.10           O  
ATOM    542  N   THR A  63      35.181  41.265   4.151  1.00 25.33           N  
ATOM    543  CA  THR A  63      34.185  42.218   3.672  1.00 23.92           C  
ATOM    544  C   THR A  63      33.543  42.930   4.865  1.00 25.92           C  
ATOM    545  O   THR A  63      33.332  44.142   4.845  1.00 25.30           O  
ATOM    546  CB  THR A  63      33.078  41.512   2.854  1.00 23.98           C  
ATOM    547  OG1 THR A  63      33.647  40.973   1.657  1.00 26.15           O  
ATOM    548  CG2 THR A  63      31.971  42.488   2.490  1.00 22.96           C  
ATOM    549  N   ALA A  64      33.234  42.165   5.905  1.00 24.56           N  
ATOM    550  CA  ALA A  64      32.613  42.713   7.103  1.00 22.32           C  
ATOM    551  C   ALA A  64      33.505  43.757   7.788  1.00 24.61           C  
ATOM    552  O   ALA A  64      33.017  44.785   8.260  1.00 25.22           O  
ATOM    553  CB  ALA A  64      32.289  41.588   8.071  1.00 23.01           C  
ATOM    554  N   GLU A  65      34.809  43.494   7.828  1.00 25.19           N  
ATOM    555  CA  GLU A  65      35.754  44.413   8.462  1.00 26.20           C  
ATOM    556  C   GLU A  65      35.853  45.721   7.694  1.00 27.49           C  
ATOM    557  O   GLU A  65      35.919  46.798   8.289  1.00 26.28           O  
ATOM    558  CB  GLU A  65      37.136  43.766   8.568  1.00 26.26           C  
ATOM    559  CG  GLU A  65      37.162  42.558   9.472  1.00 29.34           C  
ATOM    560  CD  GLU A  65      38.502  41.864   9.480  1.00 30.57           C  
ATOM    561  OE1 GLU A  65      39.177  41.871   8.431  1.00 37.61           O  
ATOM    562  OE2 GLU A  65      38.870  41.298  10.527  1.00 33.02           O  
ATOM    563  N   ILE A  66      35.860  45.626   6.368  1.00 28.18           N  
ATOM    564  CA  ILE A  66      35.937  46.812   5.525  1.00 28.62           C  
ATOM    565  C   ILE A  66      34.674  47.647   5.695  1.00 27.96           C  
ATOM    566  O   ILE A  66      34.734  48.870   5.814  1.00 26.80           O  
ATOM    567  CB  ILE A  66      36.110  46.422   4.033  1.00 29.22           C  
ATOM    568  CG1 ILE A  66      37.490  45.790   3.822  1.00 30.09           C  
ATOM    569  CG2 ILE A  66      35.919  47.647   3.143  1.00 25.14           C  
ATOM    570  CD1 ILE A  66      37.733  45.253   2.408  1.00 27.47           C  
ATOM    571  N   VAL A  67      33.523  46.984   5.714  1.00 26.06           N  
ATOM    572  CA  VAL A  67      32.264  47.694   5.882  1.00 24.14           C  
ATOM    573  C   VAL A  67      32.228  48.393   7.242  1.00 26.08           C  
ATOM    574  O   VAL A  67      31.789  49.543   7.345  1.00 26.14           O  
ATOM    575  CB  VAL A  67      31.065  46.729   5.753  1.00 25.82           C  
ATOM    576  CG1 VAL A  67      29.779  47.406   6.235  1.00 22.96           C  
ATOM    577  CG2 VAL A  67      30.918  46.303   4.297  1.00 25.61           C  
ATOM    578  N   ARG A  68      32.703  47.704   8.275  1.00 24.64           N  
ATOM    579  CA  ARG A  68      32.723  48.272   9.622  1.00 25.08           C  
ATOM    580  C   ARG A  68      33.649  49.492   9.639  1.00 26.80           C  
ATOM    581  O   ARG A  68      33.330  50.522  10.233  1.00 27.12           O  
ATOM    582  CB  ARG A  68      33.206  47.232  10.635  1.00 25.99           C  
ATOM    583  CG  ARG A  68      33.214  47.749  12.076  1.00 27.49           C  
ATOM    584  CD  ARG A  68      33.405  46.637  13.092  1.00 23.72           C  
ATOM    585  NE  ARG A  68      34.662  45.917  12.923  1.00 24.84           N  
ATOM    586  CZ  ARG A  68      35.066  44.928  13.713  1.00 27.32           C  
ATOM    587  NH1 ARG A  68      34.308  44.540  14.734  1.00 27.60           N  
ATOM    588  NH2 ARG A  68      36.232  44.332  13.490  1.00 23.77           N  
ATOM    589  N   GLY A  69      34.795  49.355   8.978  1.00 27.21           N  
ATOM    590  CA  GLY A  69      35.753  50.444   8.883  1.00 28.32           C  
ATOM    591  C   GLY A  69      36.095  51.170  10.174  1.00 28.31           C  
ATOM    592  O   GLY A  69      36.072  52.400  10.221  1.00 29.19           O  
ATOM    593  N   GLY A  70      36.415  50.419  11.219  1.00 27.64           N  
ATOM    594  CA  GLY A  70      36.778  51.038  12.486  1.00 28.60           C  
ATOM    595  C   GLY A  70      35.644  51.429  13.424  1.00 30.81           C  
ATOM    596  O   GLY A  70      35.900  51.827  14.563  1.00 30.77           O  
ATOM    597  N   ARG A  71      34.397  51.337  12.965  1.00 32.70           N  
ATOM    598  CA  ARG A  71      33.254  51.682  13.816  1.00 28.84           C  
ATOM    599  C   ARG A  71      33.152  50.705  14.985  1.00 28.65           C  
ATOM    600  O   ARG A  71      33.602  49.557  14.889  1.00 26.86           O  
ATOM    601  CB  ARG A  71      31.952  51.645  13.010  1.00 30.78           C  
ATOM    602  CG  ARG A  71      31.827  52.736  11.959  1.00 30.33           C  
ATOM    603  CD  ARG A  71      30.635  52.504  11.031  1.00 32.85           C  
ATOM    604  NE  ARG A  71      29.354  52.532  11.738  1.00 34.74           N  
ATOM    605  CZ  ARG A  71      28.169  52.394  11.150  1.00 33.91           C  
ATOM    606  NH1 ARG A  71      28.089  52.215   9.839  1.00 32.92           N  
ATOM    607  NH2 ARG A  71      27.059  52.435  11.876  1.00 35.69           N  
ATOM    608  N   LEU A  72      32.563  51.162  16.088  1.00 29.38           N  
ATOM    609  CA  LEU A  72      32.395  50.324  17.277  1.00 33.12           C  
ATOM    610  C   LEU A  72      31.178  49.417  17.100  1.00 33.29           C  
ATOM    611  O   LEU A  72      30.081  49.718  17.576  1.00 33.27           O  
ATOM    612  CB  LEU A  72      32.222  51.196  18.529  1.00 34.43           C  
ATOM    613  CG  LEU A  72      32.109  50.453  19.868  1.00 38.42           C  
ATOM    614  CD1 LEU A  72      33.352  49.603  20.097  1.00 36.38           C  
ATOM    615  CD2 LEU A  72      31.935  51.456  21.001  1.00 39.58           C  
ATOM    616  N   ILE A  73      31.385  48.306  16.399  1.00 30.97           N  
ATOM    617  CA  ILE A  73      30.318  47.340  16.128  1.00 30.43           C  
ATOM    618  C   ILE A  73      30.905  45.944  16.243  1.00 28.07           C  
ATOM    619  O   ILE A  73      31.903  45.634  15.593  1.00 28.89           O  
ATOM    620  CB  ILE A  73      29.772  47.497  14.693  1.00 28.99           C  
ATOM    621  CG1 ILE A  73      29.327  48.938  14.453  1.00 31.20           C  
ATOM    622  CG2 ILE A  73      28.606  46.537  14.468  1.00 27.63           C  
ATOM    623  CD1 ILE A  73      28.939  49.210  13.012  1.00 34.30           C  
ATOM    624  N   PRO A  74      30.294  45.071  17.056  1.00 27.54           N  
ATOM    625  CA  PRO A  74      30.875  43.732  17.154  1.00 26.02           C  
ATOM    626  C   PRO A  74      30.615  42.892  15.909  1.00 27.84           C  
ATOM    627  O   PRO A  74      29.577  43.039  15.263  1.00 26.69           O  
ATOM    628  CB  PRO A  74      30.182  43.147  18.379  1.00 27.69           C  
ATOM    629  CG  PRO A  74      28.813  43.762  18.300  1.00 25.57           C  
ATOM    630  CD  PRO A  74      29.113  45.205  17.932  1.00 28.74           C  
ATOM    631  N   ILE A  75      31.573  42.038  15.563  1.00 25.21           N  
ATOM    632  CA  ILE A  75      31.402  41.121  14.436  1.00 25.15           C  
ATOM    633  C   ILE A  75      31.341  39.718  15.034  1.00 25.27           C  
ATOM    634  O   ILE A  75      32.211  39.328  15.813  1.00 25.98           O  
ATOM    635  CB  ILE A  75      32.579  41.175  13.420  1.00 23.56           C  
ATOM    636  CG1 ILE A  75      32.480  42.441  12.564  1.00 25.35           C  
ATOM    637  CG2 ILE A  75      32.550  39.926  12.520  1.00 24.70           C  
ATOM    638  CD1 ILE A  75      33.644  42.614  11.577  1.00 26.46           C  
ATOM    639  N   TYR A  76      30.299  38.968  14.689  1.00 24.52           N  
ATOM    640  CA  TYR A  76      30.132  37.606  15.187  1.00 24.97           C  
ATOM    641  C   TYR A  76      30.169  36.663  13.991  1.00 25.96           C  
ATOM    642  O   TYR A  76      29.553  36.941  12.969  1.00 24.39           O  
ATOM    643  CB  TYR A  76      28.785  37.450  15.902  1.00 25.81           C  
ATOM    644  CG  TYR A  76      28.625  38.336  17.117  1.00 28.21           C  
ATOM    645  CD1 TYR A  76      29.419  38.149  18.249  1.00 27.65           C  
ATOM    646  CD2 TYR A  76      27.675  39.356  17.136  1.00 29.70           C  
ATOM    647  CE1 TYR A  76      29.266  38.956  19.375  1.00 31.68           C  
ATOM    648  CE2 TYR A  76      27.514  40.168  18.255  1.00 31.13           C  
ATOM    649  CZ  TYR A  76      28.312  39.960  19.370  1.00 33.42           C  
ATOM    650  OH  TYR A  76      28.149  40.749  20.481  1.00 33.98           O  
ATOM    651  N   GLN A  77      30.893  35.557  14.119  1.00 25.00           N  
ATOM    652  CA  GLN A  77      30.992  34.589  13.032  1.00 25.67           C  
ATOM    653  C   GLN A  77      30.141  33.364  13.351  1.00 28.99           C  
ATOM    654  O   GLN A  77      30.112  32.887  14.494  1.00 25.75           O  
ATOM    655  CB  GLN A  77      32.447  34.186  12.828  1.00 26.88           C  
ATOM    656  CG  GLN A  77      33.365  35.373  12.560  1.00 28.22           C  
ATOM    657  CD  GLN A  77      34.813  34.957  12.409  1.00 31.04           C  
ATOM    658  OE1 GLN A  77      35.119  34.004  11.693  1.00 33.74           O  
ATOM    659  NE2 GLN A  77      35.713  35.675  13.077  1.00 28.26           N  
ATOM    660  N   ASP A  78      29.457  32.851  12.331  1.00 25.07           N  
ATOM    661  CA  ASP A  78      28.568  31.712  12.500  1.00 24.56           C  
ATOM    662  C   ASP A  78      28.740  30.744  11.328  1.00 26.50           C  
ATOM    663  O   ASP A  78      28.556  31.135  10.171  1.00 24.31           O  
ATOM    664  CB  ASP A  78      27.121  32.221  12.558  1.00 25.35           C  
ATOM    665  CG  ASP A  78      26.139  31.168  13.053  1.00 29.18           C  
ATOM    666  OD1 ASP A  78      26.264  29.987  12.671  1.00 27.55           O  
ATOM    667  OD2 ASP A  78      25.226  31.535  13.826  1.00 34.64           O  
ATOM    668  N   GLU A  79      29.097  29.493  11.625  1.00 24.22           N  
ATOM    669  CA  GLU A  79      29.288  28.476  10.592  1.00 25.42           C  
ATOM    670  C   GLU A  79      28.032  28.233   9.758  1.00 24.91           C  
ATOM    671  O   GLU A  79      28.121  27.786   8.616  1.00 25.13           O  
ATOM    672  CB  GLU A  79      29.724  27.138  11.208  1.00 29.25           C  
ATOM    673  CG  GLU A  79      31.217  26.997  11.497  1.00 32.93           C  
ATOM    674  CD  GLU A  79      31.667  27.744  12.737  1.00 38.77           C  
ATOM    675  OE1 GLU A  79      30.794  28.227  13.494  1.00 38.34           O  
ATOM    676  OE2 GLU A  79      32.897  27.836  12.954  1.00 36.15           O  
ATOM    677  N   ARG A  80      26.865  28.509  10.329  1.00 25.09           N  
ATOM    678  CA  ARG A  80      25.608  28.296   9.609  1.00 23.48           C  
ATOM    679  C   ARG A  80      25.419  29.252   8.435  1.00 26.04           C  
ATOM    680  O   ARG A  80      24.514  29.060   7.613  1.00 25.13           O  
ATOM    681  CB  ARG A  80      24.428  28.400  10.583  1.00 24.82           C  
ATOM    682  CG  ARG A  80      24.428  27.287  11.631  1.00 26.69           C  
ATOM    683  CD  ARG A  80      23.355  27.507  12.690  1.00 25.25           C  
ATOM    684  NE  ARG A  80      23.566  28.756  13.413  1.00 28.74           N  
ATOM    685  CZ  ARG A  80      22.784  29.196  14.394  1.00 32.00           C  
ATOM    686  NH1 ARG A  80      21.730  28.485  14.775  1.00 31.48           N  
ATOM    687  NH2 ARG A  80      23.060  30.340  15.003  1.00 30.34           N  
ATOM    688  N   LEU A  81      26.282  30.262   8.344  1.00 22.16           N  
ATOM    689  CA  LEU A  81      26.217  31.236   7.263  1.00 20.47           C  
ATOM    690  C   LEU A  81      27.209  30.935   6.140  1.00 21.18           C  
ATOM    691  O   LEU A  81      27.292  31.693   5.176  1.00 22.27           O  
ATOM    692  CB  LEU A  81      26.464  32.653   7.795  1.00 21.66           C  
ATOM    693  CG  LEU A  81      25.359  33.225   8.686  1.00 25.17           C  
ATOM    694  CD1 LEU A  81      25.784  34.576   9.257  1.00 25.61           C  
ATOM    695  CD2 LEU A  81      24.072  33.356   7.866  1.00 25.20           C  
ATOM    696  N   ARG A  82      27.963  29.843   6.262  1.00 21.04           N  
ATOM    697  CA  ARG A  82      28.919  29.468   5.215  1.00 22.08           C  
ATOM    698  C   ARG A  82      28.187  29.115   3.922  1.00 24.22           C  
ATOM    699  O   ARG A  82      27.014  28.721   3.938  1.00 22.95           O  
ATOM    700  CB  ARG A  82      29.746  28.248   5.630  1.00 22.04           C  
ATOM    701  CG  ARG A  82      30.739  28.501   6.757  1.00 24.75           C  
ATOM    702  CD  ARG A  82      31.366  27.193   7.233  1.00 23.52           C  
ATOM    703  NE  ARG A  82      30.383  26.287   7.838  1.00 24.36           N  
ATOM    704  CZ  ARG A  82      30.694  25.132   8.415  1.00 26.58           C  
ATOM    705  NH1 ARG A  82      31.961  24.733   8.471  1.00 28.70           N  
ATOM    706  NH2 ARG A  82      29.741  24.374   8.940  1.00 27.76           N  
ATOM    707  N   GLU A  83      28.898  29.246   2.809  1.00 22.95           N  
ATOM    708  CA  GLU A  83      28.337  28.914   1.504  1.00 24.65           C  
ATOM    709  C   GLU A  83      28.094  27.405   1.434  1.00 24.94           C  
ATOM    710  O   GLU A  83      28.604  26.634   2.262  1.00 25.14           O  
ATOM    711  CB  GLU A  83      29.318  29.341   0.405  1.00 23.01           C  
ATOM    712  CG  GLU A  83      28.853  29.066  -1.035  1.00 23.43           C  
ATOM    713  CD  GLU A  83      27.552  29.778  -1.406  1.00 24.29           C  
ATOM    714  OE1 GLU A  83      26.536  29.545  -0.731  1.00 23.90           O  
ATOM    715  OE2 GLU A  83      27.538  30.563  -2.381  1.00 23.83           O  
ATOM    716  N   ILE A  84      27.311  26.985   0.449  1.00 22.98           N  
ATOM    717  CA  ILE A  84      27.024  25.575   0.264  1.00 23.57           C  
ATOM    718  C   ILE A  84      28.334  24.806   0.106  1.00 22.98           C  
ATOM    719  O   ILE A  84      29.238  25.238  -0.613  1.00 23.52           O  
ATOM    720  CB  ILE A  84      26.136  25.359  -0.986  1.00 25.54           C  
ATOM    721  CG1 ILE A  84      25.872  23.863  -1.194  1.00 27.14           C  
ATOM    722  CG2 ILE A  84      26.799  25.995  -2.214  1.00 23.37           C  
ATOM    723  CD1 ILE A  84      24.758  23.577  -2.198  1.00 25.77           C  
ATOM    724  N   HIS A  85      28.435  23.681   0.805  1.00 24.24           N  
ATOM    725  CA  HIS A  85      29.628  22.843   0.738  1.00 26.09           C  
ATOM    726  C   HIS A  85      29.551  22.075  -0.585  1.00 27.67           C  
ATOM    727  O   HIS A  85      28.629  21.290  -0.800  1.00 23.81           O  
ATOM    728  CB  HIS A  85      29.646  21.887   1.932  1.00 25.94           C  
ATOM    729  CG  HIS A  85      30.989  21.289   2.208  1.00 29.89           C  
ATOM    730  ND1 HIS A  85      32.128  21.673   1.530  1.00 32.74           N  
ATOM    731  CD2 HIS A  85      31.382  20.348   3.099  1.00 31.89           C  
ATOM    732  CE1 HIS A  85      33.162  20.994   1.991  1.00 31.62           C  
ATOM    733  NE2 HIS A  85      32.739  20.184   2.945  1.00 33.60           N  
ATOM    734  N   LEU A  86      30.524  22.312  -1.465  1.00 28.64           N  
ATOM    735  CA  LEU A  86      30.543  21.699  -2.795  1.00 34.01           C  
ATOM    736  C   LEU A  86      31.534  20.555  -3.024  1.00 34.99           C  
ATOM    737  O   LEU A  86      31.836  20.219  -4.170  1.00 36.80           O  
ATOM    738  CB  LEU A  86      30.785  22.798  -3.836  1.00 32.43           C  
ATOM    739  CG  LEU A  86      29.714  23.890  -3.875  1.00 35.31           C  
ATOM    740  CD1 LEU A  86      30.266  25.135  -4.560  1.00 37.62           C  
ATOM    741  CD2 LEU A  86      28.474  23.364  -4.597  1.00 31.35           C  
ATOM    742  N   GLY A  87      32.027  19.968  -1.938  1.00 34.67           N  
ATOM    743  CA  GLY A  87      32.960  18.857  -2.022  1.00 39.92           C  
ATOM    744  C   GLY A  87      33.950  18.842  -3.173  1.00 40.25           C  
ATOM    745  O   GLY A  87      34.836  19.688  -3.256  1.00 40.07           O  
ATOM    746  N   ASP A  88      33.785  17.871  -4.065  1.00 42.46           N  
ATOM    747  CA  ASP A  88      34.663  17.678  -5.218  1.00 45.48           C  
ATOM    748  C   ASP A  88      34.836  18.848  -6.173  1.00 39.10           C  
ATOM    749  O   ASP A  88      35.849  18.928  -6.866  1.00 36.87           O  
ATOM    750  CB  ASP A  88      34.189  16.473  -6.029  1.00 55.92           C  
ATOM    751  CG  ASP A  88      33.697  15.347  -5.152  1.00 65.58           C  
ATOM    752  OD1 ASP A  88      34.112  15.302  -3.977  1.00 70.84           O  
ATOM    753  OD2 ASP A  88      32.907  14.507  -5.634  1.00 71.37           O  
ATOM    754  N   TRP A  89      33.862  19.750  -6.220  1.00 31.88           N  
ATOM    755  CA  TRP A  89      33.932  20.880  -7.142  1.00 28.26           C  
ATOM    756  C   TRP A  89      34.690  22.105  -6.654  1.00 30.75           C  
ATOM    757  O   TRP A  89      35.009  22.993  -7.443  1.00 28.62           O  
ATOM    758  CB  TRP A  89      32.525  21.335  -7.532  1.00 29.23           C  
ATOM    759  CG  TRP A  89      31.672  20.288  -8.154  1.00 29.20           C  
ATOM    760  CD1 TRP A  89      32.041  19.031  -8.533  1.00 33.70           C  
ATOM    761  CD2 TRP A  89      30.297  20.430  -8.513  1.00 30.33           C  
ATOM    762  NE1 TRP A  89      30.973  18.377  -9.110  1.00 31.68           N  
ATOM    763  CE2 TRP A  89      29.890  19.218  -9.109  1.00 32.15           C  
ATOM    764  CE3 TRP A  89      29.365  21.470  -8.386  1.00 27.95           C  
ATOM    765  CZ2 TRP A  89      28.586  19.015  -9.586  1.00 32.00           C  
ATOM    766  CZ3 TRP A  89      28.070  21.269  -8.858  1.00 30.14           C  
ATOM    767  CH2 TRP A  89      27.695  20.051  -9.449  1.00 27.36           C  
ATOM    768  N   GLU A  90      34.960  22.183  -5.361  1.00 31.62           N  
ATOM    769  CA  GLU A  90      35.654  23.357  -4.855  1.00 32.92           C  
ATOM    770  C   GLU A  90      37.055  23.502  -5.443  1.00 32.90           C  
ATOM    771  O   GLU A  90      37.808  22.537  -5.520  1.00 33.33           O  
ATOM    772  CB  GLU A  90      35.679  23.315  -3.330  1.00 33.92           C  
ATOM    773  CG  GLU A  90      34.303  23.620  -2.733  1.00 35.10           C  
ATOM    774  CD  GLU A  90      34.221  23.331  -1.257  1.00 36.80           C  
ATOM    775  OE1 GLU A  90      35.257  22.919  -0.684  1.00 33.78           O  
ATOM    776  OE2 GLU A  90      33.121  23.504  -0.678  1.00 27.87           O  
ATOM    777  N   GLY A  91      37.369  24.714  -5.891  1.00 34.31           N  
ATOM    778  CA  GLY A  91      38.667  24.990  -6.480  1.00 38.81           C  
ATOM    779  C   GLY A  91      38.719  24.745  -7.976  1.00 40.34           C  
ATOM    780  O   GLY A  91      39.707  25.076  -8.631  1.00 40.18           O  
ATOM    781  N   LYS A  92      37.650  24.177  -8.527  1.00 39.99           N  
ATOM    782  CA  LYS A  92      37.603  23.874  -9.952  1.00 39.05           C  
ATOM    783  C   LYS A  92      36.745  24.829 -10.771  1.00 37.83           C  
ATOM    784  O   LYS A  92      35.768  25.387 -10.273  1.00 37.48           O  
ATOM    785  CB  LYS A  92      37.123  22.433 -10.138  1.00 40.49           C  
ATOM    786  CG  LYS A  92      38.126  21.429  -9.605  1.00 44.14           C  
ATOM    787  CD  LYS A  92      37.531  20.057  -9.376  1.00 48.32           C  
ATOM    788  CE  LYS A  92      38.562  19.160  -8.709  1.00 50.06           C  
ATOM    789  NZ  LYS A  92      37.948  17.945  -8.113  1.00 54.62           N  
ATOM    790  N   THR A  93      37.121  25.027 -12.032  1.00 36.73           N  
ATOM    791  CA  THR A  93      36.370  25.914 -12.915  1.00 34.67           C  
ATOM    792  C   THR A  93      35.145  25.179 -13.458  1.00 34.77           C  
ATOM    793  O   THR A  93      35.055  23.956 -13.367  1.00 34.34           O  
ATOM    794  CB  THR A  93      37.214  26.372 -14.119  1.00 37.91           C  
ATOM    795  OG1 THR A  93      37.469  25.249 -14.975  1.00 37.87           O  
ATOM    796  CG2 THR A  93      38.537  26.970 -13.650  1.00 39.23           C  
ATOM    797  N   HIS A  94      34.207  25.928 -14.028  1.00 35.93           N  
ATOM    798  CA  HIS A  94      32.999  25.329 -14.584  1.00 38.42           C  
ATOM    799  C   HIS A  94      33.324  24.278 -15.639  1.00 38.49           C  
ATOM    800  O   HIS A  94      32.725  23.203 -15.662  1.00 32.47           O  
ATOM    801  CB  HIS A  94      32.102  26.409 -15.188  1.00 39.39           C  
ATOM    802  CG  HIS A  94      31.458  27.297 -14.168  1.00 41.41           C  
ATOM    803  ND1 HIS A  94      30.564  28.288 -14.502  1.00 44.82           N  
ATOM    804  CD2 HIS A  94      31.579  27.334 -12.820  1.00 41.55           C  
ATOM    805  CE1 HIS A  94      30.159  28.903 -13.402  1.00 44.11           C  
ATOM    806  NE2 HIS A  94      30.760  28.344 -12.370  1.00 43.15           N  
ATOM    807  N   ASP A  95      34.284  24.581 -16.507  1.00 41.57           N  
ATOM    808  CA  ASP A  95      34.661  23.634 -17.545  1.00 44.00           C  
ATOM    809  C   ASP A  95      35.224  22.355 -16.951  1.00 41.66           C  
ATOM    810  O   ASP A  95      34.929  21.262 -17.426  1.00 38.61           O  
ATOM    811  CB  ASP A  95      35.669  24.263 -18.500  1.00 50.69           C  
ATOM    812  CG  ASP A  95      35.040  25.318 -19.381  1.00 57.07           C  
ATOM    813  OD1 ASP A  95      34.018  25.009 -20.029  1.00 60.90           O  
ATOM    814  OD2 ASP A  95      35.567  26.450 -19.428  1.00 64.18           O  
ATOM    815  N   GLU A  96      36.026  22.486 -15.903  1.00 37.35           N  
ATOM    816  CA  GLU A  96      36.603  21.311 -15.267  1.00 37.40           C  
ATOM    817  C   GLU A  96      35.507  20.454 -14.642  1.00 36.33           C  
ATOM    818  O   GLU A  96      35.551  19.226 -14.708  1.00 34.97           O  
ATOM    819  CB  GLU A  96      37.625  21.736 -14.210  1.00 39.88           C  
ATOM    820  CG  GLU A  96      38.741  22.597 -14.775  1.00 43.26           C  
ATOM    821  CD  GLU A  96      39.754  23.014 -13.729  1.00 46.54           C  
ATOM    822  OE1 GLU A  96      39.340  23.523 -12.666  1.00 42.58           O  
ATOM    823  OE2 GLU A  96      40.967  22.838 -13.975  1.00 48.69           O  
ATOM    824  N   ILE A  97      34.515  21.105 -14.044  1.00 33.62           N  
ATOM    825  CA  ILE A  97      33.415  20.384 -13.420  1.00 32.32           C  
ATOM    826  C   ILE A  97      32.524  19.743 -14.492  1.00 33.21           C  
ATOM    827  O   ILE A  97      32.047  18.620 -14.323  1.00 33.53           O  
ATOM    828  CB  ILE A  97      32.577  21.329 -12.531  1.00 32.22           C  
ATOM    829  CG1 ILE A  97      33.467  21.903 -11.420  1.00 32.53           C  
ATOM    830  CG2 ILE A  97      31.403  20.570 -11.922  1.00 30.81           C  
ATOM    831  CD1 ILE A  97      32.851  23.080 -10.671  1.00 35.36           C  
ATOM    832  N   ARG A  98      32.309  20.451 -15.595  1.00 36.60           N  
ATOM    833  CA  ARG A  98      31.487  19.913 -16.679  1.00 41.02           C  
ATOM    834  C   ARG A  98      32.101  18.615 -17.206  1.00 43.62           C  
ATOM    835  O   ARG A  98      31.399  17.750 -17.730  1.00 44.92           O  
ATOM    836  CB  ARG A  98      31.355  20.933 -17.813  1.00 42.04           C  
ATOM    837  CG  ARG A  98      30.049  21.723 -17.786  1.00 41.98           C  
ATOM    838  CD  ARG A  98      29.914  22.629 -19.002  1.00 43.84           C  
ATOM    839  NE  ARG A  98      30.771  23.808 -18.907  1.00 45.59           N  
ATOM    840  CZ  ARG A  98      30.351  25.017 -18.548  1.00 43.37           C  
ATOM    841  NH1 ARG A  98      29.072  25.227 -18.252  1.00 41.63           N  
ATOM    842  NH2 ARG A  98      31.217  26.018 -18.473  1.00 44.67           N  
ATOM    843  N   GLN A  99      33.417  18.492 -17.060  0.50 43.21           N  
ATOM    845  CA  GLN A  99      34.142  17.305 -17.503  0.50 44.71           C  
ATOM    847  C   GLN A  99      34.044  16.182 -16.479  0.50 44.74           C  
ATOM    849  O   GLN A  99      34.157  15.005 -16.817  0.50 46.30           O  
ATOM    851  CB  GLN A  99      35.616  17.646 -17.735  0.50 47.22           C  
ATOM    853  CG  GLN A  99      35.942  18.067 -19.151  0.50 48.51           C  
ATOM    855  CD  GLN A  99      35.730  16.940 -20.140  0.50 50.11           C  
ATOM    857  OE1 GLN A  99      36.356  15.883 -20.039  0.50 51.75           O  
ATOM    859  NE2 GLN A  99      34.843  17.158 -21.103  0.50 49.89           N  
ATOM    861  N   MET A 100      33.828  16.557 -15.223  1.00 43.59           N  
ATOM    862  CA  MET A 100      33.731  15.595 -14.132  1.00 43.02           C  
ATOM    863  C   MET A 100      32.343  15.002 -13.943  1.00 41.05           C  
ATOM    864  O   MET A 100      32.162  13.787 -13.976  1.00 39.72           O  
ATOM    865  CB  MET A 100      34.117  16.249 -12.810  1.00 47.17           C  
ATOM    866  CG  MET A 100      35.588  16.355 -12.514  1.00 51.66           C  
ATOM    867  SD  MET A 100      35.775  17.171 -10.916  1.00 57.60           S  
ATOM    868  CE  MET A 100      34.831  16.051  -9.847  1.00 56.53           C  
ATOM    869  N   ASP A 101      31.371  15.883 -13.715  0.50 37.55           N  
ATOM    871  CA  ASP A 101      29.991  15.484 -13.476  0.50 35.66           C  
ATOM    873  C   ASP A 101      29.023  16.405 -14.215  0.50 35.08           C  
ATOM    875  O   ASP A 101      28.394  17.271 -13.604  0.50 32.15           O  
ATOM    877  CB  ASP A 101      29.684  15.547 -11.976  0.50 35.36           C  
ATOM    879  CG  ASP A 101      30.759  14.894 -11.129  0.50 37.84           C  
ATOM    881  OD1 ASP A 101      31.060  13.706 -11.367  0.50 36.25           O  
ATOM    883  OD2 ASP A 101      31.297  15.568 -10.222  0.50 35.36           O  
ATOM    885  N   PRO A 102      28.889  16.228 -15.538  1.00 34.46           N  
ATOM    886  CA  PRO A 102      27.992  17.051 -16.360  1.00 33.00           C  
ATOM    887  C   PRO A 102      26.515  17.083 -15.955  1.00 28.80           C  
ATOM    888  O   PRO A 102      25.887  18.146 -15.962  1.00 29.74           O  
ATOM    889  CB  PRO A 102      28.203  16.486 -17.768  1.00 32.68           C  
ATOM    890  CG  PRO A 102      28.555  15.048 -17.507  1.00 33.27           C  
ATOM    891  CD  PRO A 102      29.527  15.181 -16.360  1.00 35.68           C  
ATOM    892  N   ILE A 103      25.967  15.925 -15.606  0.50 29.03           N  
ATOM    894  CA  ILE A 103      24.565  15.833 -15.206  0.50 29.55           C  
ATOM    896  C   ILE A 103      24.291  16.595 -13.910  0.50 29.37           C  
ATOM    898  O   ILE A 103      23.362  17.398 -13.841  0.50 25.76           O  
ATOM    900  CB  ILE A 103      24.132  14.364 -14.997  0.50 31.45           C  
ATOM    902  CG1 ILE A 103      24.229  13.588 -16.315  0.50 34.88           C  
ATOM    904  CG2 ILE A 103      22.704  14.318 -14.457  0.50 31.80           C  
ATOM    906  CD1 ILE A 103      23.072  13.829 -17.271  0.50 33.84           C  
ATOM    908  N   ALA A 104      25.099  16.338 -12.884  1.00 27.25           N  
ATOM    909  CA  ALA A 104      24.917  17.002 -11.591  1.00 27.92           C  
ATOM    910  C   ALA A 104      25.116  18.506 -11.731  1.00 24.92           C  
ATOM    911  O   ALA A 104      24.408  19.293 -11.098  1.00 25.78           O  
ATOM    912  CB  ALA A 104      25.894  16.435 -10.552  1.00 27.23           C  
ATOM    913  N   PHE A 105      26.078  18.908 -12.553  1.00 23.60           N  
ATOM    914  CA  PHE A 105      26.335  20.323 -12.764  1.00 25.22           C  
ATOM    915  C   PHE A 105      25.116  20.967 -13.435  1.00 25.85           C  
ATOM    916  O   PHE A 105      24.714  22.080 -13.080  1.00 24.83           O  
ATOM    917  CB  PHE A 105      27.579  20.509 -13.637  1.00 26.71           C  
ATOM    918  CG  PHE A 105      28.077  21.922 -13.688  1.00 31.57           C  
ATOM    919  CD1 PHE A 105      27.977  22.668 -14.860  1.00 27.30           C  
ATOM    920  CD2 PHE A 105      28.672  22.502 -12.571  1.00 29.42           C  
ATOM    921  CE1 PHE A 105      28.466  23.968 -14.921  1.00 31.95           C  
ATOM    922  CE2 PHE A 105      29.165  23.804 -12.622  1.00 31.56           C  
ATOM    923  CZ  PHE A 105      29.064  24.539 -13.800  1.00 30.16           C  
ATOM    924  N   ASP A 106      24.528  20.270 -14.404  1.00 24.32           N  
ATOM    925  CA  ASP A 106      23.344  20.804 -15.078  1.00 24.29           C  
ATOM    926  C   ASP A 106      22.201  20.946 -14.068  1.00 24.21           C  
ATOM    927  O   ASP A 106      21.478  21.948 -14.089  1.00 26.82           O  
ATOM    928  CB  ASP A 106      22.904  19.899 -16.241  1.00 24.34           C  
ATOM    929  CG  ASP A 106      21.768  20.518 -17.057  1.00 23.44           C  
ATOM    930  OD1 ASP A 106      21.982  21.601 -17.647  1.00 24.85           O  
ATOM    931  OD2 ASP A 106      20.665  19.937 -17.098  1.00 26.77           O  
ATOM    932  N   HIS A 107      22.035  19.955 -13.188  1.00 23.89           N  
ATOM    933  CA  HIS A 107      20.981  20.020 -12.175  1.00 25.04           C  
ATOM    934  C   HIS A 107      21.220  21.198 -11.230  1.00 24.81           C  
ATOM    935  O   HIS A 107      20.296  21.934 -10.901  1.00 25.74           O  
ATOM    936  CB  HIS A 107      20.919  18.748 -11.319  1.00 25.97           C  
ATOM    937  CG  HIS A 107      20.466  17.524 -12.051  1.00 28.71           C  
ATOM    938  ND1 HIS A 107      19.712  17.576 -13.206  1.00 31.36           N  
ATOM    939  CD2 HIS A 107      20.628  16.210 -11.769  1.00 32.54           C  
ATOM    940  CE1 HIS A 107      19.431  16.347 -13.601  1.00 33.11           C  
ATOM    941  NE2 HIS A 107      19.976  15.499 -12.745  1.00 33.60           N  
ATOM    942  N   PHE A 108      22.461  21.360 -10.781  1.00 25.95           N  
ATOM    943  CA  PHE A 108      22.806  22.449  -9.862  1.00 26.25           C  
ATOM    944  C   PHE A 108      22.230  23.788 -10.333  1.00 26.78           C  
ATOM    945  O   PHE A 108      21.643  24.541  -9.545  1.00 25.08           O  
ATOM    946  CB  PHE A 108      24.328  22.573  -9.745  1.00 26.07           C  
ATOM    947  CG  PHE A 108      24.776  23.533  -8.677  1.00 24.85           C  
ATOM    948  CD1 PHE A 108      24.932  23.105  -7.363  1.00 25.04           C  
ATOM    949  CD2 PHE A 108      25.040  24.864  -8.988  1.00 27.27           C  
ATOM    950  CE1 PHE A 108      25.352  23.996  -6.368  1.00 29.26           C  
ATOM    951  CE2 PHE A 108      25.460  25.765  -8.004  1.00 26.80           C  
ATOM    952  CZ  PHE A 108      25.617  25.327  -6.695  1.00 26.44           C  
ATOM    953  N   TRP A 109      22.383  24.067 -11.626  1.00 26.09           N  
ATOM    954  CA  TRP A 109      21.908  25.318 -12.214  1.00 26.47           C  
ATOM    955  C   TRP A 109      20.508  25.315 -12.812  1.00 29.53           C  
ATOM    956  O   TRP A 109      19.819  26.338 -12.766  1.00 29.77           O  
ATOM    957  CB  TRP A 109      22.888  25.788 -13.298  1.00 24.95           C  
ATOM    958  CG  TRP A 109      24.262  26.071 -12.771  1.00 30.29           C  
ATOM    959  CD1 TRP A 109      25.381  25.303 -12.929  1.00 28.80           C  
ATOM    960  CD2 TRP A 109      24.650  27.185 -11.959  1.00 30.80           C  
ATOM    961  NE1 TRP A 109      26.443  25.870 -12.262  1.00 31.33           N  
ATOM    962  CE2 TRP A 109      26.021  27.026 -11.659  1.00 30.00           C  
ATOM    963  CE3 TRP A 109      23.970  28.302 -11.453  1.00 32.90           C  
ATOM    964  CZ2 TRP A 109      26.726  27.945 -10.873  1.00 34.91           C  
ATOM    965  CZ3 TRP A 109      24.674  29.217 -10.671  1.00 34.90           C  
ATOM    966  CH2 TRP A 109      26.036  29.030 -10.391  1.00 32.86           C  
ATOM    967  N   GLN A 110      20.099  24.174 -13.364  1.00 26.60           N  
ATOM    968  CA  GLN A 110      18.803  24.024 -14.039  1.00 30.85           C  
ATOM    969  C   GLN A 110      17.658  23.326 -13.356  1.00 30.45           C  
ATOM    970  O   GLN A 110      16.502  23.518 -13.736  1.00 32.29           O  
ATOM    971  CB  GLN A 110      18.982  23.286 -15.349  1.00 29.84           C  
ATOM    972  CG  GLN A 110      18.795  24.144 -16.513  1.00 38.85           C  
ATOM    973  CD  GLN A 110      19.940  25.057 -16.658  1.00 33.45           C  
ATOM    974  OE1 GLN A 110      19.841  26.243 -16.358  1.00 36.96           O  
ATOM    975  NE2 GLN A 110      21.063  24.513 -17.105  1.00 25.88           N  
ATOM    976  N   ALA A 111      17.971  22.460 -12.410  1.00 29.04           N  
ATOM    977  CA  ALA A 111      16.937  21.717 -11.711  1.00 30.06           C  
ATOM    978  C   ALA A 111      17.478  21.489 -10.315  1.00 28.53           C  
ATOM    979  O   ALA A 111      17.806  20.365  -9.939  1.00 27.78           O  
ATOM    980  CB  ALA A 111      16.687  20.387 -12.421  1.00 30.02           C  
ATOM    981  N   PRO A 112      17.580  22.571  -9.526  1.00 30.04           N  
ATOM    982  CA  PRO A 112      18.091  22.538  -8.153  1.00 32.24           C  
ATOM    983  C   PRO A 112      17.531  21.407  -7.299  1.00 35.38           C  
ATOM    984  O   PRO A 112      18.257  20.789  -6.519  1.00 34.91           O  
ATOM    985  CB  PRO A 112      17.717  23.918  -7.611  1.00 33.03           C  
ATOM    986  CG  PRO A 112      17.769  24.780  -8.827  1.00 33.83           C  
ATOM    987  CD  PRO A 112      17.089  23.920  -9.866  1.00 30.03           C  
ATOM    988  N   HIS A 113      16.240  21.126  -7.452  1.00 34.86           N  
ATOM    989  CA  HIS A 113      15.618  20.065  -6.673  1.00 38.11           C  
ATOM    990  C   HIS A 113      16.166  18.676  -7.029  1.00 37.54           C  
ATOM    991  O   HIS A 113      16.029  17.731  -6.249  1.00 41.30           O  
ATOM    992  CB  HIS A 113      14.095  20.106  -6.849  1.00 40.95           C  
ATOM    993  CG  HIS A 113      13.643  19.922  -8.263  1.00 42.06           C  
ATOM    994  ND1 HIS A 113      13.966  20.805  -9.271  1.00 42.18           N  
ATOM    995  CD2 HIS A 113      12.906  18.944  -8.840  1.00 42.99           C  
ATOM    996  CE1 HIS A 113      13.452  20.375 -10.409  1.00 41.45           C  
ATOM    997  NE2 HIS A 113      12.804  19.248 -10.175  1.00 44.68           N  
ATOM    998  N   LEU A 114      16.794  18.561  -8.196  1.00 35.17           N  
ATOM    999  CA  LEU A 114      17.370  17.295  -8.659  1.00 35.51           C  
ATOM   1000  C   LEU A 114      18.830  17.118  -8.239  1.00 34.64           C  
ATOM   1001  O   LEU A 114      19.408  16.042  -8.405  1.00 32.59           O  
ATOM   1002  CB  LEU A 114      17.288  17.205 -10.188  1.00 35.30           C  
ATOM   1003  CG  LEU A 114      16.094  16.502 -10.840  1.00 40.90           C  
ATOM   1004  CD1 LEU A 114      14.820  16.831 -10.105  1.00 40.07           C  
ATOM   1005  CD2 LEU A 114      16.010  16.903 -12.307  1.00 35.49           C  
ATOM   1006  N   TYR A 115      19.435  18.181  -7.721  1.00 28.97           N  
ATOM   1007  CA  TYR A 115      20.830  18.121  -7.295  1.00 28.47           C  
ATOM   1008  C   TYR A 115      20.954  17.262  -6.036  1.00 29.40           C  
ATOM   1009  O   TYR A 115      20.413  17.605  -4.986  1.00 27.12           O  
ATOM   1010  CB  TYR A 115      21.350  19.541  -7.039  1.00 28.26           C  
ATOM   1011  CG  TYR A 115      22.788  19.604  -6.575  1.00 27.21           C  
ATOM   1012  CD1 TYR A 115      23.820  19.064  -7.345  1.00 27.08           C  
ATOM   1013  CD2 TYR A 115      23.117  20.212  -5.362  1.00 28.87           C  
ATOM   1014  CE1 TYR A 115      25.153  19.129  -6.914  1.00 29.65           C  
ATOM   1015  CE2 TYR A 115      24.440  20.282  -4.921  1.00 27.53           C  
ATOM   1016  CZ  TYR A 115      25.449  19.741  -5.694  1.00 30.32           C  
ATOM   1017  OH  TYR A 115      26.749  19.798  -5.244  1.00 26.42           O  
ATOM   1018  N   ALA A 116      21.656  16.137  -6.150  1.00 31.59           N  
ATOM   1019  CA  ALA A 116      21.830  15.226  -5.020  1.00 34.24           C  
ATOM   1020  C   ALA A 116      23.244  14.644  -5.011  1.00 33.80           C  
ATOM   1021  O   ALA A 116      23.459  13.509  -5.427  1.00 34.59           O  
ATOM   1022  CB  ALA A 116      20.799  14.108  -5.099  1.00 34.85           C  
ATOM   1023  N   PRO A 117      24.224  15.419  -4.522  1.00 35.85           N  
ATOM   1024  CA  PRO A 117      25.630  14.998  -4.456  1.00 37.03           C  
ATOM   1025  C   PRO A 117      25.931  13.916  -3.416  1.00 39.86           C  
ATOM   1026  O   PRO A 117      25.281  13.853  -2.373  1.00 39.18           O  
ATOM   1027  CB  PRO A 117      26.354  16.304  -4.151  1.00 36.53           C  
ATOM   1028  CG  PRO A 117      25.384  16.998  -3.244  1.00 35.09           C  
ATOM   1029  CD  PRO A 117      24.052  16.765  -3.942  1.00 34.21           C  
ATOM   1030  N   GLN A 118      26.910  13.063  -3.711  1.00 44.13           N  
ATOM   1031  CA  GLN A 118      27.308  12.000  -2.782  1.00 50.78           C  
ATOM   1032  C   GLN A 118      28.050  12.653  -1.625  1.00 49.83           C  
ATOM   1033  O   GLN A 118      27.923  12.243  -0.469  1.00 50.76           O  
ATOM   1034  CB  GLN A 118      28.257  11.001  -3.451  1.00 56.60           C  
ATOM   1035  CG  GLN A 118      27.701  10.271  -4.657  1.00 66.38           C  
ATOM   1036  CD  GLN A 118      28.687   9.260  -5.212  1.00 71.17           C  
ATOM   1037  OE1 GLN A 118      29.832   9.595  -5.518  1.00 75.38           O  
ATOM   1038  NE2 GLN A 118      28.248   8.014  -5.344  1.00 75.43           N  
ATOM   1039  N   ARG A 119      28.840  13.666  -1.961  1.00 47.91           N  
ATOM   1040  CA  ARG A 119      29.622  14.414  -0.987  1.00 49.80           C  
ATOM   1041  C   ARG A 119      29.343  15.896  -1.165  1.00 47.19           C  
ATOM   1042  O   ARG A 119      29.729  16.506  -2.163  1.00 48.33           O  
ATOM   1043  CB  ARG A 119      31.112  14.136  -1.178  1.00 53.47           C  
ATOM   1044  CG  ARG A 119      31.571  12.814  -0.582  1.00 59.83           C  
ATOM   1045  CD  ARG A 119      32.804  12.306  -1.295  1.00 63.99           C  
ATOM   1046  NE  ARG A 119      32.473  11.873  -2.648  1.00 68.98           N  
ATOM   1047  CZ  ARG A 119      33.200  12.167  -3.720  1.00 71.60           C  
ATOM   1048  NH1 ARG A 119      34.298  12.898  -3.595  1.00 73.21           N  
ATOM   1049  NH2 ARG A 119      32.825  11.731  -4.914  1.00 71.89           N  
ATOM   1050  N   GLY A 120      28.660  16.472  -0.188  1.00 44.24           N  
ATOM   1051  CA  GLY A 120      28.329  17.876  -0.268  1.00 38.64           C  
ATOM   1052  C   GLY A 120      26.897  18.092   0.162  1.00 36.75           C  
ATOM   1053  O   GLY A 120      26.114  17.144   0.285  1.00 34.57           O  
ATOM   1054  N   GLU A 121      26.549  19.351   0.381  1.00 31.83           N  
ATOM   1055  CA  GLU A 121      25.210  19.697   0.813  1.00 29.68           C  
ATOM   1056  C   GLU A 121      24.256  19.944  -0.336  1.00 28.61           C  
ATOM   1057  O   GLU A 121      24.660  20.345  -1.426  1.00 28.91           O  
ATOM   1058  CB  GLU A 121      25.237  20.969   1.654  1.00 27.11           C  
ATOM   1059  CG  GLU A 121      26.037  20.897   2.932  1.00 26.39           C  
ATOM   1060  CD  GLU A 121      26.099  22.250   3.614  1.00 27.01           C  
ATOM   1061  OE1 GLU A 121      26.642  23.191   3.000  1.00 23.14           O  
ATOM   1062  OE2 GLU A 121      25.600  22.373   4.757  1.00 27.50           O  
ATOM   1063  N   ARG A 122      22.979  19.700  -0.081  0.50 28.07           N  
ATOM   1065  CA  ARG A 122      21.956  19.956  -1.077  0.50 27.64           C  
ATOM   1067  C   ARG A 122      21.423  21.338  -0.730  0.50 27.78           C  
ATOM   1069  O   ARG A 122      21.677  21.855   0.361  0.50 26.66           O  
ATOM   1071  CB  ARG A 122      20.836  18.927  -0.974  0.50 28.33           C  
ATOM   1073  CG  ARG A 122      21.251  17.529  -1.359  0.50 28.32           C  
ATOM   1075  CD  ARG A 122      20.271  16.540  -0.787  0.50 29.63           C  
ATOM   1077  NE  ARG A 122      20.210  16.676   0.664  0.50 29.69           N  
ATOM   1079  CZ  ARG A 122      19.304  16.082   1.428  0.50 29.52           C  
ATOM   1081  NH1 ARG A 122      18.379  15.311   0.873  0.50 28.76           N  
ATOM   1083  NH2 ARG A 122      19.325  16.257   2.743  0.50 30.34           N  
ATOM   1085  N   PHE A 123      20.696  21.944  -1.658  1.00 26.75           N  
ATOM   1086  CA  PHE A 123      20.135  23.265  -1.424  1.00 26.64           C  
ATOM   1087  C   PHE A 123      19.251  23.364  -0.185  1.00 27.98           C  
ATOM   1088  O   PHE A 123      19.252  24.385   0.499  1.00 27.77           O  
ATOM   1089  CB  PHE A 123      19.375  23.736  -2.665  1.00 26.41           C  
ATOM   1090  CG  PHE A 123      20.266  23.999  -3.851  1.00 26.15           C  
ATOM   1091  CD1 PHE A 123      20.227  23.169  -4.969  1.00 25.56           C  
ATOM   1092  CD2 PHE A 123      21.148  25.074  -3.845  1.00 24.90           C  
ATOM   1093  CE1 PHE A 123      21.051  23.407  -6.067  1.00 28.29           C  
ATOM   1094  CE2 PHE A 123      21.980  25.323  -4.941  1.00 27.66           C  
ATOM   1095  CZ  PHE A 123      21.931  24.488  -6.055  1.00 26.55           C  
ATOM   1096  N   CYS A 124      18.503  22.308   0.111  0.50 28.59           N  
ATOM   1098  CA  CYS A 124      17.624  22.318   1.276  0.50 29.60           C  
ATOM   1100  C   CYS A 124      18.415  22.296   2.587  0.50 28.92           C  
ATOM   1102  O   CYS A 124      17.963  22.851   3.589  0.50 27.53           O  
ATOM   1104  CB  CYS A 124      16.669  21.130   1.222  0.50 28.48           C  
ATOM   1106  SG  CYS A 124      17.513  19.563   1.209  0.50 27.32           S  
ATOM   1108  N   ASP A 125      19.582  21.650   2.584  1.00 27.95           N  
ATOM   1109  CA  ASP A 125      20.425  21.599   3.784  1.00 28.36           C  
ATOM   1110  C   ASP A 125      20.867  23.024   4.109  1.00 26.34           C  
ATOM   1111  O   ASP A 125      20.843  23.458   5.266  1.00 23.99           O  
ATOM   1112  CB  ASP A 125      21.688  20.755   3.557  1.00 30.19           C  
ATOM   1113  CG  ASP A 125      21.390  19.282   3.343  1.00 35.91           C  
ATOM   1114  OD1 ASP A 125      20.593  18.721   4.115  1.00 39.01           O  
ATOM   1115  OD2 ASP A 125      21.969  18.677   2.414  1.00 36.86           O  
ATOM   1116  N   VAL A 126      21.274  23.747   3.071  1.00 23.67           N  
ATOM   1117  CA  VAL A 126      21.737  25.123   3.226  1.00 22.85           C  
ATOM   1118  C   VAL A 126      20.606  26.037   3.687  1.00 24.22           C  
ATOM   1119  O   VAL A 126      20.773  26.832   4.614  1.00 22.51           O  
ATOM   1120  CB  VAL A 126      22.322  25.662   1.895  1.00 22.75           C  
ATOM   1121  CG1 VAL A 126      22.772  27.113   2.070  1.00 26.14           C  
ATOM   1122  CG2 VAL A 126      23.493  24.793   1.455  1.00 22.64           C  
ATOM   1123  N   GLN A 127      19.442  25.916   3.053  1.00 23.63           N  
ATOM   1124  CA  GLN A 127      18.318  26.754   3.435  1.00 22.49           C  
ATOM   1125  C   GLN A 127      17.951  26.589   4.907  1.00 23.58           C  
ATOM   1126  O   GLN A 127      17.693  27.572   5.599  1.00 23.18           O  
ATOM   1127  CB  GLN A 127      17.090  26.439   2.578  1.00 24.81           C  
ATOM   1128  CG  GLN A 127      15.936  27.410   2.814  1.00 24.67           C  
ATOM   1129  CD  GLN A 127      14.724  27.081   1.960  1.00 27.01           C  
ATOM   1130  OE1 GLN A 127      14.161  25.987   2.054  1.00 29.16           O  
ATOM   1131  NE2 GLN A 127      14.319  28.026   1.119  1.00 28.28           N  
ATOM   1132  N   GLN A 128      17.948  25.346   5.383  0.50 24.09           N  
ATOM   1134  CA  GLN A 128      17.595  25.062   6.768  0.50 24.09           C  
ATOM   1136  C   GLN A 128      18.568  25.655   7.788  0.50 22.63           C  
ATOM   1138  O   GLN A 128      18.140  26.253   8.774  0.50 22.92           O  
ATOM   1140  CB  GLN A 128      17.466  23.552   6.983  0.50 26.59           C  
ATOM   1142  CG  GLN A 128      16.917  23.170   8.349  0.50 29.91           C  
ATOM   1144  CD  GLN A 128      16.303  21.782   8.364  0.50 36.34           C  
ATOM   1146  OE1 GLN A 128      16.955  20.795   8.017  0.50 40.67           O  
ATOM   1148  NE2 GLN A 128      15.040  21.698   8.770  0.50 35.89           N  
ATOM   1150  N   ARG A 129      19.867  25.495   7.558  1.00 21.78           N  
ATOM   1151  CA  ARG A 129      20.856  26.041   8.488  1.00 21.90           C  
ATOM   1152  C   ARG A 129      20.937  27.561   8.410  1.00 23.83           C  
ATOM   1153  O   ARG A 129      21.105  28.227   9.427  1.00 22.76           O  
ATOM   1154  CB  ARG A 129      22.244  25.413   8.275  1.00 22.32           C  
ATOM   1155  CG  ARG A 129      22.929  25.653   6.930  1.00 22.46           C  
ATOM   1156  CD  ARG A 129      24.314  25.020   6.994  1.00 23.11           C  
ATOM   1157  NE  ARG A 129      25.046  24.977   5.728  1.00 21.31           N  
ATOM   1158  CZ  ARG A 129      25.641  26.017   5.152  1.00 23.31           C  
ATOM   1159  NH1 ARG A 129      25.598  27.220   5.714  1.00 25.08           N  
ATOM   1160  NH2 ARG A 129      26.324  25.842   4.023  1.00 21.60           N  
ATOM   1161  N   ALA A 130      20.791  28.118   7.210  1.00 22.87           N  
ATOM   1162  CA  ALA A 130      20.854  29.568   7.063  1.00 24.44           C  
ATOM   1163  C   ALA A 130      19.662  30.225   7.755  1.00 24.64           C  
ATOM   1164  O   ALA A 130      19.813  31.262   8.412  1.00 23.87           O  
ATOM   1165  CB  ALA A 130      20.903  29.947   5.584  1.00 22.72           C  
ATOM   1166  N   LEU A 131      18.481  29.628   7.616  0.50 22.89           N  
ATOM   1168  CA  LEU A 131      17.287  30.182   8.241  0.50 24.85           C  
ATOM   1170  C   LEU A 131      17.397  30.083   9.763  0.50 24.22           C  
ATOM   1172  O   LEU A 131      16.941  30.974  10.481  0.50 24.77           O  
ATOM   1174  CB  LEU A 131      16.031  29.443   7.758  0.50 24.31           C  
ATOM   1176  CG  LEU A 131      14.690  30.104   8.095  0.50 25.59           C  
ATOM   1178  CD1 LEU A 131      14.614  31.478   7.440  0.50 24.29           C  
ATOM   1180  CD2 LEU A 131      13.542  29.220   7.615  0.50 23.04           C  
ATOM   1182  N   GLU A 132      17.997  29.003  10.252  0.50 23.58           N  
ATOM   1184  CA  GLU A 132      18.159  28.829  11.692  0.50 23.81           C  
ATOM   1186  C   GLU A 132      19.052  29.948  12.219  0.50 25.63           C  
ATOM   1188  O   GLU A 132      18.763  30.545  13.257  0.50 24.21           O  
ATOM   1190  CB  GLU A 132      18.779  27.463  12.008  0.50 25.07           C  
ATOM   1192  CG  GLU A 132      18.985  27.200  13.499  0.50 27.28           C  
ATOM   1194  CD  GLU A 132      19.624  25.845  13.771  0.50 30.85           C  
ATOM   1196  OE1 GLU A 132      18.950  24.812  13.568  0.50 31.62           O  
ATOM   1198  OE2 GLU A 132      20.803  25.814  14.180  0.50 27.01           O  
ATOM   1200  N   ALA A 133      20.132  30.235  11.497  1.00 24.94           N  
ATOM   1201  CA  ALA A 133      21.046  31.304  11.904  1.00 24.35           C  
ATOM   1202  C   ALA A 133      20.324  32.654  11.892  1.00 24.71           C  
ATOM   1203  O   ALA A 133      20.434  33.437  12.837  1.00 24.34           O  
ATOM   1204  CB  ALA A 133      22.261  31.342  10.967  1.00 23.50           C  
ATOM   1205  N   VAL A 134      19.587  32.929  10.823  1.00 21.81           N  
ATOM   1206  CA  VAL A 134      18.844  34.179  10.727  1.00 23.36           C  
ATOM   1207  C   VAL A 134      17.872  34.298  11.906  1.00 23.35           C  
ATOM   1208  O   VAL A 134      17.753  35.361  12.524  1.00 24.38           O  
ATOM   1209  CB  VAL A 134      18.060  34.259   9.394  1.00 22.41           C  
ATOM   1210  CG1 VAL A 134      17.056  35.398   9.437  1.00 25.87           C  
ATOM   1211  CG2 VAL A 134      19.032  34.470   8.239  1.00 26.30           C  
ATOM   1212  N   GLN A 135      17.200  33.200  12.229  1.00 24.22           N  
ATOM   1213  CA  GLN A 135      16.249  33.215  13.333  1.00 25.91           C  
ATOM   1214  C   GLN A 135      16.950  33.513  14.664  1.00 24.80           C  
ATOM   1215  O   GLN A 135      16.455  34.312  15.464  1.00 24.97           O  
ATOM   1216  CB  GLN A 135      15.501  31.883  13.410  1.00 26.28           C  
ATOM   1217  CG  GLN A 135      14.298  31.931  14.342  1.00 32.09           C  
ATOM   1218  CD  GLN A 135      13.302  33.010  13.937  1.00 35.68           C  
ATOM   1219  OE1 GLN A 135      12.728  32.964  12.846  1.00 36.28           O  
ATOM   1220  NE2 GLN A 135      13.100  33.991  14.812  1.00 37.03           N  
ATOM   1221  N   SER A 136      18.096  32.879  14.895  0.50 24.87           N  
ATOM   1223  CA  SER A 136      18.842  33.102  16.131  0.50 25.12           C  
ATOM   1225  C   SER A 136      19.312  34.552  16.220  0.50 25.46           C  
ATOM   1227  O   SER A 136      19.383  35.126  17.307  0.50 24.84           O  
ATOM   1229  CB  SER A 136      20.049  32.158  16.216  0.50 25.20           C  
ATOM   1231  OG  SER A 136      20.999  32.437  15.203  0.50 29.31           O  
ATOM   1233  N   ILE A 137      19.630  35.144  15.072  1.00 24.05           N  
ATOM   1234  CA  ILE A 137      20.080  36.530  15.029  1.00 23.40           C  
ATOM   1235  C   ILE A 137      18.912  37.438  15.404  1.00 25.13           C  
ATOM   1236  O   ILE A 137      19.059  38.354  16.214  1.00 24.18           O  
ATOM   1237  CB  ILE A 137      20.632  36.877  13.618  1.00 23.12           C  
ATOM   1238  CG1 ILE A 137      21.981  36.170  13.425  1.00 24.01           C  
ATOM   1239  CG2 ILE A 137      20.789  38.387  13.450  1.00 24.24           C  
ATOM   1240  CD1 ILE A 137      22.523  36.225  11.999  1.00 24.46           C  
ATOM   1241  N   VAL A 138      17.746  37.168  14.826  1.00 24.57           N  
ATOM   1242  CA  VAL A 138      16.550  37.950  15.126  1.00 27.43           C  
ATOM   1243  C   VAL A 138      16.218  37.846  16.618  1.00 27.32           C  
ATOM   1244  O   VAL A 138      15.910  38.845  17.272  1.00 28.18           O  
ATOM   1245  CB  VAL A 138      15.333  37.431  14.313  1.00 29.96           C  
ATOM   1246  CG1 VAL A 138      14.044  38.059  14.826  1.00 29.02           C  
ATOM   1247  CG2 VAL A 138      15.529  37.753  12.845  1.00 25.21           C  
ATOM   1248  N   ASP A 139      16.278  36.631  17.148  0.50 26.28           N  
ATOM   1250  CA  ASP A 139      15.963  36.403  18.551  0.50 28.17           C  
ATOM   1252  C   ASP A 139      16.895  37.147  19.511  0.50 29.68           C  
ATOM   1254  O   ASP A 139      16.504  37.468  20.635  0.50 28.24           O  
ATOM   1256  CB  ASP A 139      15.966  34.899  18.859  0.50 27.86           C  
ATOM   1258  CG  ASP A 139      14.824  34.155  18.164  0.50 28.77           C  
ATOM   1260  OD1 ASP A 139      13.857  34.812  17.724  0.50 29.83           O  
ATOM   1262  OD2 ASP A 139      14.885  32.914  18.071  0.50 28.62           O  
ATOM   1264  N   ARG A 140      18.120  37.429  19.074  1.00 29.48           N  
ATOM   1265  CA  ARG A 140      19.074  38.154  19.914  1.00 30.67           C  
ATOM   1266  C   ARG A 140      19.089  39.663  19.680  1.00 29.24           C  
ATOM   1267  O   ARG A 140      19.790  40.391  20.389  1.00 28.05           O  
ATOM   1268  CB  ARG A 140      20.487  37.611  19.683  1.00 36.89           C  
ATOM   1269  CG  ARG A 140      20.690  36.178  20.123  1.00 42.27           C  
ATOM   1270  CD  ARG A 140      21.924  35.587  19.463  1.00 52.34           C  
ATOM   1271  NE  ARG A 140      23.115  36.400  19.700  1.00 60.52           N  
ATOM   1272  CZ  ARG A 140      23.710  36.532  20.881  1.00 62.56           C  
ATOM   1273  NH1 ARG A 140      23.231  35.900  21.947  1.00 63.00           N  
ATOM   1274  NH2 ARG A 140      24.785  37.302  20.998  1.00 62.99           N  
ATOM   1275  N   HIS A 141      18.316  40.142  18.706  1.00 26.24           N  
ATOM   1276  CA  HIS A 141      18.306  41.567  18.372  1.00 26.55           C  
ATOM   1277  C   HIS A 141      16.940  42.207  18.208  1.00 29.26           C  
ATOM   1278  O   HIS A 141      16.651  42.878  17.201  1.00 27.23           O  
ATOM   1279  CB  HIS A 141      19.146  41.792  17.109  1.00 25.96           C  
ATOM   1280  CG  HIS A 141      20.601  41.536  17.330  1.00 28.78           C  
ATOM   1281  ND1 HIS A 141      21.408  42.405  18.031  1.00 27.31           N  
ATOM   1282  CD2 HIS A 141      21.369  40.463  17.031  1.00 29.50           C  
ATOM   1283  CE1 HIS A 141      22.613  41.877  18.156  1.00 29.03           C  
ATOM   1284  NE2 HIS A 141      22.616  40.699  17.558  1.00 31.07           N  
ATOM   1285  N   GLU A 142      16.107  41.997  19.219  1.00 28.05           N  
ATOM   1286  CA  GLU A 142      14.766  42.550  19.233  1.00 30.89           C  
ATOM   1287  C   GLU A 142      14.864  44.073  19.283  1.00 29.94           C  
ATOM   1288  O   GLU A 142      15.538  44.639  20.154  1.00 29.84           O  
ATOM   1289  CB  GLU A 142      14.009  42.011  20.461  1.00 31.91           C  
ATOM   1290  CG  GLU A 142      12.534  42.394  20.540  1.00 37.13           C  
ATOM   1291  CD  GLU A 142      11.728  41.969  19.327  1.00 32.78           C  
ATOM   1292  OE1 GLU A 142      11.734  40.768  18.963  1.00 41.98           O  
ATOM   1293  OE2 GLU A 142      11.076  42.853  18.739  1.00 35.32           O  
ATOM   1294  N   GLY A 143      14.219  44.729  18.324  1.00 28.44           N  
ATOM   1295  CA  GLY A 143      14.224  46.173  18.276  1.00 29.49           C  
ATOM   1296  C   GLY A 143      15.497  46.772  17.714  1.00 32.62           C  
ATOM   1297  O   GLY A 143      15.688  47.978  17.821  1.00 31.02           O  
ATOM   1298  N   GLU A 144      16.364  45.959  17.114  1.00 27.85           N  
ATOM   1299  CA  GLU A 144      17.612  46.476  16.560  1.00 28.05           C  
ATOM   1300  C   GLU A 144      17.780  46.219  15.061  1.00 28.38           C  
ATOM   1301  O   GLU A 144      16.950  45.560  14.431  1.00 25.80           O  
ATOM   1302  CB  GLU A 144      18.807  45.885  17.328  1.00 26.28           C  
ATOM   1303  CG  GLU A 144      18.882  46.367  18.769  1.00 30.44           C  
ATOM   1304  CD  GLU A 144      19.909  45.626  19.611  1.00 35.08           C  
ATOM   1305  OE1 GLU A 144      20.387  46.221  20.601  1.00 36.03           O  
ATOM   1306  OE2 GLU A 144      20.228  44.455  19.303  1.00 31.25           O  
ATOM   1307  N   THR A 145      18.856  46.763  14.501  1.00 29.57           N  
ATOM   1308  CA  THR A 145      19.176  46.594  13.084  1.00 28.26           C  
ATOM   1309  C   THR A 145      20.561  45.957  12.996  1.00 28.00           C  
ATOM   1310  O   THR A 145      21.488  46.382  13.686  1.00 27.74           O  
ATOM   1311  CB  THR A 145      19.211  47.953  12.352  1.00 29.22           C  
ATOM   1312  OG1 THR A 145      17.928  48.581  12.452  1.00 28.51           O  
ATOM   1313  CG2 THR A 145      19.570  47.765  10.883  1.00 30.71           C  
ATOM   1314  N   VAL A 146      20.702  44.935  12.157  1.00 26.07           N  
ATOM   1315  CA  VAL A 146      21.986  44.261  12.006  1.00 25.72           C  
ATOM   1316  C   VAL A 146      22.325  43.940  10.553  1.00 25.19           C  
ATOM   1317  O   VAL A 146      21.452  43.919   9.684  1.00 26.30           O  
ATOM   1318  CB  VAL A 146      22.034  42.946  12.811  1.00 28.59           C  
ATOM   1319  CG1 VAL A 146      21.806  43.233  14.298  1.00 27.95           C  
ATOM   1320  CG2 VAL A 146      20.994  41.973  12.288  1.00 30.86           C  
ATOM   1321  N   LEU A 147      23.607  43.690  10.308  1.00 24.89           N  
ATOM   1322  CA  LEU A 147      24.097  43.342   8.972  1.00 24.51           C  
ATOM   1323  C   LEU A 147      24.567  41.900   8.976  1.00 22.82           C  
ATOM   1324  O   LEU A 147      25.184  41.438   9.944  1.00 22.68           O  
ATOM   1325  CB  LEU A 147      25.278  44.239   8.570  1.00 23.63           C  
ATOM   1326  CG  LEU A 147      25.999  43.842   7.265  1.00 25.30           C  
ATOM   1327  CD1 LEU A 147      25.089  44.121   6.084  1.00 24.67           C  
ATOM   1328  CD2 LEU A 147      27.313  44.618   7.114  1.00 23.75           C  
ATOM   1329  N   ILE A 148      24.269  41.189   7.889  1.00 21.99           N  
ATOM   1330  CA  ILE A 148      24.680  39.801   7.732  1.00 22.55           C  
ATOM   1331  C   ILE A 148      25.464  39.706   6.424  1.00 23.10           C  
ATOM   1332  O   ILE A 148      24.958  40.072   5.362  1.00 24.58           O  
ATOM   1333  CB  ILE A 148      23.458  38.843   7.649  1.00 24.28           C  
ATOM   1334  CG1 ILE A 148      22.648  38.908   8.951  1.00 24.76           C  
ATOM   1335  CG2 ILE A 148      23.945  37.414   7.366  1.00 24.94           C  
ATOM   1336  CD1 ILE A 148      21.347  38.101   8.922  1.00 26.20           C  
ATOM   1337  N   VAL A 149      26.704  39.237   6.508  1.00 23.13           N  
ATOM   1338  CA  VAL A 149      27.539  39.092   5.322  1.00 23.68           C  
ATOM   1339  C   VAL A 149      27.651  37.608   5.046  1.00 22.08           C  
ATOM   1340  O   VAL A 149      28.169  36.846   5.864  1.00 23.37           O  
ATOM   1341  CB  VAL A 149      28.939  39.707   5.542  1.00 24.58           C  
ATOM   1342  CG1 VAL A 149      29.776  39.595   4.261  1.00 22.66           C  
ATOM   1343  CG2 VAL A 149      28.795  41.157   5.956  1.00 22.06           C  
ATOM   1344  N   THR A 150      27.155  37.181   3.894  1.00 19.71           N  
ATOM   1345  CA  THR A 150      27.192  35.768   3.600  1.00 21.70           C  
ATOM   1346  C   THR A 150      27.535  35.479   2.149  1.00 23.65           C  
ATOM   1347  O   THR A 150      28.302  36.232   1.537  1.00 22.48           O  
ATOM   1348  CB  THR A 150      25.851  35.098   4.054  1.00 22.84           C  
ATOM   1349  OG1 THR A 150      25.909  33.681   3.854  1.00 22.54           O  
ATOM   1350  CG2 THR A 150      24.669  35.696   3.310  1.00 23.89           C  
ATOM   1351  N   HIS A 151      26.966  34.414   1.595  1.00 22.33           N  
ATOM   1352  CA  HIS A 151      27.316  34.001   0.239  1.00 22.11           C  
ATOM   1353  C   HIS A 151      26.162  33.899  -0.756  1.00 25.28           C  
ATOM   1354  O   HIS A 151      24.998  33.911  -0.376  1.00 23.72           O  
ATOM   1355  CB  HIS A 151      28.051  32.666   0.340  1.00 23.09           C  
ATOM   1356  CG  HIS A 151      29.202  32.694   1.300  1.00 24.75           C  
ATOM   1357  ND1 HIS A 151      30.498  32.939   0.900  1.00 23.69           N  
ATOM   1358  CD2 HIS A 151      29.244  32.565   2.650  1.00 23.01           C  
ATOM   1359  CE1 HIS A 151      31.288  32.962   1.960  1.00 25.78           C  
ATOM   1360  NE2 HIS A 151      30.552  32.738   3.034  1.00 24.94           N  
ATOM   1361  N   GLY A 152      26.517  33.788  -2.036  1.00 24.94           N  
ATOM   1362  CA  GLY A 152      25.528  33.710  -3.100  1.00 25.98           C  
ATOM   1363  C   GLY A 152      24.425  32.673  -2.985  1.00 25.79           C  
ATOM   1364  O   GLY A 152      23.243  33.020  -3.001  1.00 24.38           O  
ATOM   1365  N   VAL A 153      24.786  31.399  -2.887  1.00 25.58           N  
ATOM   1366  CA  VAL A 153      23.770  30.361  -2.791  1.00 24.01           C  
ATOM   1367  C   VAL A 153      22.951  30.527  -1.516  1.00 25.35           C  
ATOM   1368  O   VAL A 153      21.731  30.363  -1.526  1.00 26.55           O  
ATOM   1369  CB  VAL A 153      24.399  28.950  -2.852  1.00 25.69           C  
ATOM   1370  CG1 VAL A 153      23.333  27.879  -2.615  1.00 27.80           C  
ATOM   1371  CG2 VAL A 153      25.035  28.749  -4.210  1.00 26.97           C  
ATOM   1372  N   VAL A 154      23.617  30.865  -0.418  1.00 21.85           N  
ATOM   1373  CA  VAL A 154      22.911  31.065   0.840  1.00 20.43           C  
ATOM   1374  C   VAL A 154      21.827  32.135   0.682  1.00 20.77           C  
ATOM   1375  O   VAL A 154      20.693  31.939   1.111  1.00 23.60           O  
ATOM   1376  CB  VAL A 154      23.875  31.520   1.954  1.00 21.60           C  
ATOM   1377  CG1 VAL A 154      23.084  31.955   3.188  1.00 23.44           C  
ATOM   1378  CG2 VAL A 154      24.841  30.383   2.292  1.00 23.30           C  
ATOM   1379  N   LEU A 155      22.191  33.269   0.085  1.00 22.24           N  
ATOM   1380  CA  LEU A 155      21.250  34.369  -0.113  1.00 23.81           C  
ATOM   1381  C   LEU A 155      20.056  33.936  -0.948  1.00 24.50           C  
ATOM   1382  O   LEU A 155      18.917  34.287  -0.651  1.00 23.44           O  
ATOM   1383  CB  LEU A 155      21.957  35.552  -0.780  1.00 23.44           C  
ATOM   1384  CG  LEU A 155      22.918  36.301   0.147  1.00 26.46           C  
ATOM   1385  CD1 LEU A 155      23.758  37.298  -0.645  1.00 26.32           C  
ATOM   1386  CD2 LEU A 155      22.107  37.018   1.222  1.00 25.52           C  
ATOM   1387  N   LYS A 156      20.323  33.173  -2.000  1.00 24.33           N  
ATOM   1388  CA  LYS A 156      19.251  32.686  -2.849  1.00 26.67           C  
ATOM   1389  C   LYS A 156      18.285  31.773  -2.097  1.00 25.06           C  
ATOM   1390  O   LYS A 156      17.069  31.864  -2.297  1.00 24.81           O  
ATOM   1391  CB  LYS A 156      19.838  31.971  -4.064  1.00 28.97           C  
ATOM   1392  CG  LYS A 156      20.283  32.934  -5.136  1.00 35.16           C  
ATOM   1393  CD  LYS A 156      19.077  33.758  -5.563  1.00 41.76           C  
ATOM   1394  CE  LYS A 156      19.368  34.677  -6.721  1.00 45.67           C  
ATOM   1395  NZ  LYS A 156      18.136  35.437  -7.048  1.00 44.07           N  
ATOM   1396  N   THR A 157      18.802  30.898  -1.229  1.00 23.63           N  
ATOM   1397  CA  THR A 157      17.912  30.012  -0.481  1.00 23.45           C  
ATOM   1398  C   THR A 157      17.123  30.790   0.569  1.00 22.98           C  
ATOM   1399  O   THR A 157      15.999  30.420   0.904  1.00 22.59           O  
ATOM   1400  CB  THR A 157      18.663  28.850   0.227  1.00 24.94           C  
ATOM   1401  OG1 THR A 157      19.519  29.377   1.248  1.00 23.66           O  
ATOM   1402  CG2 THR A 157      19.479  28.046  -0.776  1.00 26.52           C  
ATOM   1403  N   LEU A 158      17.709  31.860   1.101  1.00 24.12           N  
ATOM   1404  CA  LEU A 158      17.008  32.666   2.095  1.00 24.08           C  
ATOM   1405  C   LEU A 158      15.873  33.446   1.436  1.00 24.68           C  
ATOM   1406  O   LEU A 158      14.770  33.517   1.973  1.00 26.25           O  
ATOM   1407  CB  LEU A 158      17.968  33.641   2.784  1.00 23.94           C  
ATOM   1408  CG  LEU A 158      18.911  33.020   3.820  1.00 24.28           C  
ATOM   1409  CD1 LEU A 158      19.900  34.065   4.300  1.00 23.58           C  
ATOM   1410  CD2 LEU A 158      18.096  32.464   4.981  1.00 24.79           C  
ATOM   1411  N   MET A 159      16.136  34.027   0.271  1.00 26.04           N  
ATOM   1412  CA  MET A 159      15.095  34.792  -0.411  1.00 26.37           C  
ATOM   1413  C   MET A 159      13.931  33.879  -0.793  1.00 27.63           C  
ATOM   1414  O   MET A 159      12.763  34.288  -0.722  1.00 26.26           O  
ATOM   1415  CB  MET A 159      15.661  35.489  -1.651  1.00 28.24           C  
ATOM   1416  CG  MET A 159      16.732  36.527  -1.344  1.00 28.18           C  
ATOM   1417  SD  MET A 159      16.264  37.690  -0.030  1.00 33.84           S  
ATOM   1418  CE  MET A 159      14.953  38.604  -0.837  1.00 33.39           C  
ATOM   1419  N   ALA A 160      14.250  32.643  -1.185  1.00 25.28           N  
ATOM   1420  CA  ALA A 160      13.227  31.665  -1.553  1.00 27.42           C  
ATOM   1421  C   ALA A 160      12.329  31.414  -0.345  1.00 29.04           C  
ATOM   1422  O   ALA A 160      11.107  31.311  -0.474  1.00 30.46           O  
ATOM   1423  CB  ALA A 160      13.887  30.346  -2.017  1.00 25.03           C  
ATOM   1424  N   ALA A 161      12.942  31.329   0.833  1.00 29.21           N  
ATOM   1425  CA  ALA A 161      12.195  31.107   2.065  1.00 31.46           C  
ATOM   1426  C   ALA A 161      11.310  32.312   2.372  1.00 31.35           C  
ATOM   1427  O   ALA A 161      10.118  32.158   2.642  1.00 33.33           O  
ATOM   1428  CB  ALA A 161      13.155  30.848   3.227  1.00 30.84           C  
ATOM   1429  N   PHE A 162      11.886  33.512   2.312  1.00 28.78           N  
ATOM   1430  CA  PHE A 162      11.124  34.725   2.598  1.00 30.42           C  
ATOM   1431  C   PHE A 162       9.991  34.952   1.600  1.00 34.50           C  
ATOM   1432  O   PHE A 162       8.894  35.364   1.985  1.00 34.86           O  
ATOM   1433  CB  PHE A 162      12.035  35.959   2.606  1.00 28.66           C  
ATOM   1434  CG  PHE A 162      13.163  35.884   3.599  1.00 30.51           C  
ATOM   1435  CD1 PHE A 162      12.991  35.257   4.832  1.00 30.52           C  
ATOM   1436  CD2 PHE A 162      14.400  36.450   3.303  1.00 29.56           C  
ATOM   1437  CE1 PHE A 162      14.041  35.195   5.756  1.00 31.64           C  
ATOM   1438  CE2 PHE A 162      15.450  36.393   4.217  1.00 32.30           C  
ATOM   1439  CZ  PHE A 162      15.268  35.762   5.445  1.00 31.99           C  
ATOM   1440  N   LYS A 163      10.257  34.687   0.325  0.50 33.80           N  
ATOM   1442  CA  LYS A 163       9.251  34.874  -0.715  0.50 35.98           C  
ATOM   1444  C   LYS A 163       8.346  33.658  -0.885  0.50 37.92           C  
ATOM   1446  O   LYS A 163       7.452  33.658  -1.729  0.50 36.47           O  
ATOM   1448  CB  LYS A 163       9.921  35.221  -2.050  0.50 35.52           C  
ATOM   1450  CG  LYS A 163      10.565  36.602  -2.068  0.50 36.71           C  
ATOM   1452  CD  LYS A 163      11.039  37.005  -3.461  0.50 38.34           C  
ATOM   1454  CE  LYS A 163      12.249  36.206  -3.912  0.50 38.35           C  
ATOM   1456  NZ  LYS A 163      12.728  36.653  -5.252  0.50 38.12           N  
ATOM   1458  N   ASP A 164       8.584  32.625  -0.081  1.00 38.85           N  
ATOM   1459  CA  ASP A 164       7.777  31.412  -0.131  1.00 41.73           C  
ATOM   1460  C   ASP A 164       7.813  30.773  -1.522  1.00 42.28           C  
ATOM   1461  O   ASP A 164       6.788  30.356  -2.063  1.00 44.90           O  
ATOM   1462  CB  ASP A 164       6.339  31.759   0.266  1.00 48.22           C  
ATOM   1463  CG  ASP A 164       5.560  30.562   0.739  1.00 52.95           C  
ATOM   1464  OD1 ASP A 164       6.100  29.799   1.571  1.00 54.01           O  
ATOM   1465  OD2 ASP A 164       4.407  30.391   0.289  1.00 57.84           O  
ATOM   1466  N   THR A 165       9.013  30.694  -2.084  1.00 41.62           N  
ATOM   1467  CA  THR A 165       9.243  30.129  -3.409  1.00 41.95           C  
ATOM   1468  C   THR A 165       9.823  28.716  -3.318  1.00 41.09           C  
ATOM   1469  O   THR A 165      10.745  28.467  -2.545  1.00 39.41           O  
ATOM   1470  CB  THR A 165      10.248  30.993  -4.192  1.00 45.44           C  
ATOM   1471  OG1 THR A 165       9.760  32.337  -4.277  1.00 51.49           O  
ATOM   1472  CG2 THR A 165      10.464  30.435  -5.591  1.00 49.96           C  
ATOM   1473  N   PRO A 166       9.280  27.770  -4.102  0.50 40.05           N  
ATOM   1475  CA  PRO A 166       9.789  26.395  -4.071  0.50 38.84           C  
ATOM   1477  C   PRO A 166      11.241  26.370  -4.551  0.50 39.07           C  
ATOM   1479  O   PRO A 166      11.620  27.136  -5.435  0.50 36.13           O  
ATOM   1481  CB  PRO A 166       8.850  25.659  -5.025  0.50 39.07           C  
ATOM   1483  CG  PRO A 166       7.566  26.432  -4.893  0.50 38.63           C  
ATOM   1485  CD  PRO A 166       8.059  27.857  -4.921  0.50 40.13           C  
ATOM   1487  N   LEU A 167      12.049  25.491  -3.968  1.00 39.97           N  
ATOM   1488  CA  LEU A 167      13.456  25.396  -4.345  1.00 39.98           C  
ATOM   1489  C   LEU A 167      13.744  25.142  -5.822  1.00 40.10           C  
ATOM   1490  O   LEU A 167      14.782  25.563  -6.327  1.00 41.46           O  
ATOM   1491  CB  LEU A 167      14.167  24.350  -3.481  1.00 42.18           C  
ATOM   1492  CG  LEU A 167      14.450  24.816  -2.048  1.00 41.26           C  
ATOM   1493  CD1 LEU A 167      15.201  23.731  -1.292  1.00 44.14           C  
ATOM   1494  CD2 LEU A 167      15.268  26.103  -2.077  1.00 44.41           C  
ATOM   1495  N   ASP A 168      12.849  24.472  -6.535  1.00 42.24           N  
ATOM   1496  CA  ASP A 168      13.122  24.237  -7.946  1.00 45.41           C  
ATOM   1497  C   ASP A 168      13.236  25.571  -8.702  1.00 45.14           C  
ATOM   1498  O   ASP A 168      13.737  25.615  -9.823  1.00 46.86           O  
ATOM   1499  CB  ASP A 168      12.049  23.330  -8.578  1.00 49.29           C  
ATOM   1500  CG  ASP A 168      10.686  23.993  -8.673  1.00 53.63           C  
ATOM   1501  OD1 ASP A 168      10.175  24.476  -7.641  1.00 56.82           O  
ATOM   1502  OD2 ASP A 168      10.114  24.020  -9.786  1.00 55.84           O  
ATOM   1503  N   HIS A 169      12.796  26.659  -8.071  1.00 44.65           N  
ATOM   1504  CA  HIS A 169      12.856  27.989  -8.687  1.00 45.04           C  
ATOM   1505  C   HIS A 169      13.840  28.903  -7.956  1.00 42.17           C  
ATOM   1506  O   HIS A 169      13.748  30.133  -8.024  1.00 38.31           O  
ATOM   1507  CB  HIS A 169      11.466  28.633  -8.694  1.00 51.12           C  
ATOM   1508  CG  HIS A 169      10.483  27.936  -9.585  1.00 56.87           C  
ATOM   1509  ND1 HIS A 169      10.694  27.774 -10.935  1.00 59.39           N  
ATOM   1510  CD2 HIS A 169       9.290  27.357  -9.314  1.00 58.69           C  
ATOM   1511  CE1 HIS A 169       9.671  27.121 -11.463  1.00 61.31           C  
ATOM   1512  NE2 HIS A 169       8.808  26.857 -10.500  1.00 61.41           N  
ATOM   1513  N   LEU A 170      14.789  28.282  -7.265  1.00 37.49           N  
ATOM   1514  CA  LEU A 170      15.814  28.985  -6.499  1.00 37.51           C  
ATOM   1515  C   LEU A 170      16.572  30.087  -7.241  1.00 36.48           C  
ATOM   1516  O   LEU A 170      16.841  31.156  -6.684  1.00 32.76           O  
ATOM   1517  CB  LEU A 170      16.832  27.970  -5.977  1.00 40.28           C  
ATOM   1518  CG  LEU A 170      18.085  28.536  -5.317  1.00 40.25           C  
ATOM   1519  CD1 LEU A 170      17.717  29.170  -3.988  1.00 41.09           C  
ATOM   1520  CD2 LEU A 170      19.090  27.421  -5.111  1.00 42.02           C  
ATOM   1521  N   TRP A 171      16.918  29.824  -8.496  1.00 34.50           N  
ATOM   1522  CA  TRP A 171      17.698  30.773  -9.281  1.00 37.57           C  
ATOM   1523  C   TRP A 171      16.953  31.924  -9.955  1.00 40.42           C  
ATOM   1524  O   TRP A 171      17.508  32.601 -10.822  1.00 42.84           O  
ATOM   1525  CB  TRP A 171      18.524  30.013 -10.323  1.00 35.32           C  
ATOM   1526  CG  TRP A 171      19.516  29.069  -9.710  1.00 34.25           C  
ATOM   1527  CD1 TRP A 171      19.519  27.705  -9.800  1.00 33.82           C  
ATOM   1528  CD2 TRP A 171      20.643  29.420  -8.896  1.00 33.99           C  
ATOM   1529  NE1 TRP A 171      20.578  27.185  -9.090  1.00 32.70           N  
ATOM   1530  CE2 TRP A 171      21.285  28.215  -8.527  1.00 33.24           C  
ATOM   1531  CE3 TRP A 171      21.173  30.637  -8.443  1.00 34.03           C  
ATOM   1532  CZ2 TRP A 171      22.431  28.190  -7.725  1.00 34.63           C  
ATOM   1533  CZ3 TRP A 171      22.317  30.613  -7.643  1.00 36.26           C  
ATOM   1534  CH2 TRP A 171      22.930  29.393  -7.294  1.00 37.56           C  
ATOM   1535  N   SER A 172      15.704  32.151  -9.564  0.50 41.32           N  
ATOM   1537  CA  SER A 172      14.928  33.240 -10.149  0.50 41.70           C  
ATOM   1539  C   SER A 172      15.547  34.579  -9.755  0.50 43.38           C  
ATOM   1541  O   SER A 172      16.085  34.724  -8.657  0.50 43.46           O  
ATOM   1543  CB  SER A 172      13.476  33.177  -9.672  0.50 41.84           C  
ATOM   1545  OG  SER A 172      12.840  31.995 -10.129  0.50 40.55           O  
ATOM   1547  N   PRO A 173      15.484  35.578 -10.652  0.50 44.66           N  
ATOM   1549  CA  PRO A 173      16.040  36.912 -10.393  0.50 43.63           C  
ATOM   1551  C   PRO A 173      15.558  37.502  -9.066  0.50 43.31           C  
ATOM   1553  O   PRO A 173      14.561  37.052  -8.504  0.50 43.33           O  
ATOM   1555  CB  PRO A 173      15.559  37.719 -11.595  0.50 45.04           C  
ATOM   1557  CG  PRO A 173      15.552  36.698 -12.689  0.50 44.64           C  
ATOM   1559  CD  PRO A 173      14.913  35.506 -12.010  0.50 44.75           C  
ATOM   1561  N   PRO A 174      16.258  38.529  -8.556  1.00 41.52           N  
ATOM   1562  CA  PRO A 174      17.452  39.153  -9.140  1.00 42.46           C  
ATOM   1563  C   PRO A 174      18.770  38.502  -8.723  1.00 41.92           C  
ATOM   1564  O   PRO A 174      18.839  37.796  -7.720  1.00 42.12           O  
ATOM   1565  CB  PRO A 174      17.352  40.583  -8.637  1.00 42.40           C  
ATOM   1566  CG  PRO A 174      16.863  40.374  -7.241  1.00 42.02           C  
ATOM   1567  CD  PRO A 174      15.792  39.302  -7.390  1.00 41.76           C  
ATOM   1568  N   TYR A 175      19.816  38.762  -9.497  1.00 41.52           N  
ATOM   1569  CA  TYR A 175      21.143  38.221  -9.219  1.00 40.79           C  
ATOM   1570  C   TYR A 175      21.718  38.907  -7.978  1.00 38.40           C  
ATOM   1571  O   TYR A 175      21.690  40.129  -7.875  1.00 37.89           O  
ATOM   1572  CB  TYR A 175      22.060  38.486 -10.410  1.00 44.04           C  
ATOM   1573  CG  TYR A 175      23.401  37.811 -10.313  1.00 46.26           C  
ATOM   1574  CD1 TYR A 175      23.569  36.494 -10.738  1.00 47.58           C  
ATOM   1575  CD2 TYR A 175      24.505  38.488  -9.796  1.00 45.53           C  
ATOM   1576  CE1 TYR A 175      24.808  35.868 -10.655  1.00 50.03           C  
ATOM   1577  CE2 TYR A 175      25.747  37.870  -9.705  1.00 47.13           C  
ATOM   1578  CZ  TYR A 175      25.892  36.562 -10.137  1.00 49.24           C  
ATOM   1579  OH  TYR A 175      27.120  35.951 -10.053  1.00 51.70           O  
ATOM   1580  N   MET A 176      22.244  38.126  -7.041  1.00 37.46           N  
ATOM   1581  CA  MET A 176      22.813  38.694  -5.820  1.00 37.23           C  
ATOM   1582  C   MET A 176      24.293  39.031  -6.004  1.00 35.65           C  
ATOM   1583  O   MET A 176      25.172  38.218  -5.710  1.00 32.52           O  
ATOM   1584  CB  MET A 176      22.638  37.712  -4.658  1.00 40.57           C  
ATOM   1585  CG  MET A 176      21.184  37.359  -4.371  1.00 44.75           C  
ATOM   1586  SD  MET A 176      20.213  38.783  -3.831  1.00 52.77           S  
ATOM   1587  CE  MET A 176      20.134  38.489  -2.080  1.00 51.76           C  
ATOM   1588  N   TYR A 177      24.566  40.237  -6.491  1.00 34.92           N  
ATOM   1589  CA  TYR A 177      25.937  40.671  -6.724  1.00 37.57           C  
ATOM   1590  C   TYR A 177      26.693  40.880  -5.420  1.00 37.70           C  
ATOM   1591  O   TYR A 177      26.091  41.053  -4.360  1.00 33.60           O  
ATOM   1592  CB  TYR A 177      25.960  41.981  -7.523  1.00 41.76           C  
ATOM   1593  CG  TYR A 177      25.298  41.898  -8.880  1.00 45.14           C  
ATOM   1594  CD1 TYR A 177      23.914  41.994  -9.013  1.00 48.48           C  
ATOM   1595  CD2 TYR A 177      26.059  41.703 -10.030  1.00 48.45           C  
ATOM   1596  CE1 TYR A 177      23.301  41.899 -10.264  1.00 50.85           C  
ATOM   1597  CE2 TYR A 177      25.459  41.605 -11.285  1.00 50.95           C  
ATOM   1598  CZ  TYR A 177      24.081  41.703 -11.395  1.00 52.54           C  
ATOM   1599  OH  TYR A 177      23.486  41.592 -12.632  1.00 53.29           O  
ATOM   1600  N   GLY A 178      28.020  40.865  -5.505  1.00 38.72           N  
ATOM   1601  CA  GLY A 178      28.832  41.089  -4.324  1.00 36.68           C  
ATOM   1602  C   GLY A 178      28.524  42.454  -3.727  1.00 38.81           C  
ATOM   1603  O   GLY A 178      28.391  43.444  -4.450  1.00 38.59           O  
ATOM   1604  N   THR A 179      28.411  42.497  -2.401  1.00 35.78           N  
ATOM   1605  CA  THR A 179      28.110  43.710  -1.645  1.00 35.07           C  
ATOM   1606  C   THR A 179      26.760  44.346  -1.979  1.00 33.66           C  
ATOM   1607  O   THR A 179      26.530  45.512  -1.664  1.00 35.10           O  
ATOM   1608  CB  THR A 179      29.220  44.794  -1.797  1.00 36.39           C  
ATOM   1609  OG1 THR A 179      29.117  45.430  -3.078  1.00 37.58           O  
ATOM   1610  CG2 THR A 179      30.596  44.167  -1.642  1.00 36.50           C  
ATOM   1611  N   SER A 180      25.867  43.586  -2.611  1.00 36.44           N  
ATOM   1612  CA  SER A 180      24.534  44.101  -2.937  1.00 34.02           C  
ATOM   1613  C   SER A 180      23.755  44.258  -1.630  1.00 34.78           C  
ATOM   1614  O   SER A 180      24.040  43.573  -0.644  1.00 33.59           O  
ATOM   1615  CB  SER A 180      23.795  43.135  -3.867  1.00 35.66           C  
ATOM   1616  OG  SER A 180      23.673  41.847  -3.286  1.00 35.56           O  
ATOM   1617  N   VAL A 181      22.771  45.151  -1.618  1.00 31.85           N  
ATOM   1618  CA  VAL A 181      21.990  45.383  -0.407  1.00 32.59           C  
ATOM   1619  C   VAL A 181      20.565  44.849  -0.464  1.00 32.25           C  
ATOM   1620  O   VAL A 181      19.793  45.179  -1.364  1.00 33.18           O  
ATOM   1621  CB  VAL A 181      21.935  46.894  -0.059  1.00 33.75           C  
ATOM   1622  CG1 VAL A 181      21.017  47.132   1.132  1.00 35.10           C  
ATOM   1623  CG2 VAL A 181      23.334  47.400   0.252  1.00 36.92           C  
ATOM   1624  N   THR A 182      20.233  44.012   0.511  1.00 28.98           N  
ATOM   1625  CA  THR A 182      18.906  43.429   0.635  1.00 27.53           C  
ATOM   1626  C   THR A 182      18.465  43.771   2.051  1.00 26.89           C  
ATOM   1627  O   THR A 182      19.238  43.612   2.999  1.00 28.23           O  
ATOM   1628  CB  THR A 182      18.944  41.895   0.450  1.00 29.71           C  
ATOM   1629  OG1 THR A 182      19.238  41.588  -0.922  1.00 32.65           O  
ATOM   1630  CG2 THR A 182      17.608  41.269   0.828  1.00 27.62           C  
ATOM   1631  N   ILE A 183      17.239  44.267   2.192  1.00 26.21           N  
ATOM   1632  CA  ILE A 183      16.727  44.634   3.506  1.00 28.75           C  
ATOM   1633  C   ILE A 183      15.470  43.850   3.833  1.00 27.63           C  
ATOM   1634  O   ILE A 183      14.519  43.831   3.055  1.00 27.55           O  
ATOM   1635  CB  ILE A 183      16.417  46.142   3.595  1.00 29.31           C  
ATOM   1636  CG1 ILE A 183      17.676  46.946   3.261  1.00 31.40           C  
ATOM   1637  CG2 ILE A 183      15.918  46.490   5.001  1.00 31.28           C  
ATOM   1638  CD1 ILE A 183      17.472  48.454   3.249  1.00 33.26           C  
ATOM   1639  N   ILE A 184      15.488  43.198   4.990  1.00 27.11           N  
ATOM   1640  CA  ILE A 184      14.367  42.388   5.444  1.00 28.26           C  
ATOM   1641  C   ILE A 184      13.823  42.973   6.739  1.00 30.06           C  
ATOM   1642  O   ILE A 184      14.556  43.126   7.720  1.00 27.98           O  
ATOM   1643  CB  ILE A 184      14.803  40.928   5.728  1.00 29.33           C  
ATOM   1644  CG1 ILE A 184      15.552  40.346   4.525  1.00 29.77           C  
ATOM   1645  CG2 ILE A 184      13.581  40.081   6.089  1.00 28.85           C  
ATOM   1646  CD1 ILE A 184      14.741  40.252   3.251  1.00 28.11           C  
ATOM   1647  N   GLU A 185      12.538  43.311   6.744  1.00 29.16           N  
ATOM   1648  CA  GLU A 185      11.922  43.856   7.945  1.00 29.42           C  
ATOM   1649  C   GLU A 185      11.191  42.710   8.632  1.00 31.03           C  
ATOM   1650  O   GLU A 185      10.324  42.073   8.034  1.00 32.68           O  
ATOM   1651  CB  GLU A 185      10.941  44.975   7.582  1.00 33.80           C  
ATOM   1652  CG  GLU A 185      11.605  46.234   7.045  1.00 38.96           C  
ATOM   1653  CD  GLU A 185      12.440  46.959   8.092  1.00 43.22           C  
ATOM   1654  OE1 GLU A 185      13.059  47.989   7.741  1.00 47.08           O  
ATOM   1655  OE2 GLU A 185      12.475  46.511   9.262  1.00 42.40           O  
ATOM   1656  N   VAL A 186      11.563  42.425   9.876  1.00 29.03           N  
ATOM   1657  CA  VAL A 186      10.926  41.343  10.608  1.00 29.71           C  
ATOM   1658  C   VAL A 186       9.998  41.938  11.654  1.00 31.96           C  
ATOM   1659  O   VAL A 186      10.443  42.462  12.678  1.00 32.30           O  
ATOM   1660  CB  VAL A 186      11.967  40.435  11.298  1.00 28.46           C  
ATOM   1661  CG1 VAL A 186      11.282  39.196  11.847  1.00 27.34           C  
ATOM   1662  CG2 VAL A 186      13.062  40.053  10.312  1.00 29.85           C  
ATOM   1663  N   ASP A 187       8.702  41.857  11.388  1.00 30.16           N  
ATOM   1664  CA  ASP A 187       7.711  42.408  12.297  1.00 32.15           C  
ATOM   1665  C   ASP A 187       6.559  41.421  12.441  1.00 30.90           C  
ATOM   1666  O   ASP A 187       6.189  40.746  11.477  1.00 26.61           O  
ATOM   1667  CB  ASP A 187       7.196  43.742  11.746  1.00 38.38           C  
ATOM   1668  CG  ASP A 187       8.322  44.713  11.405  1.00 46.17           C  
ATOM   1669  OD1 ASP A 187       9.061  45.124  12.325  1.00 51.24           O  
ATOM   1670  OD2 ASP A 187       8.471  45.064  10.214  1.00 49.37           O  
ATOM   1671  N   GLY A 188       6.010  41.331  13.648  1.00 29.81           N  
ATOM   1672  CA  GLY A 188       4.896  40.431  13.894  1.00 31.25           C  
ATOM   1673  C   GLY A 188       5.129  38.990  13.473  1.00 33.59           C  
ATOM   1674  O   GLY A 188       4.218  38.322  12.966  1.00 35.54           O  
ATOM   1675  N   GLY A 189       6.353  38.515  13.678  1.00 31.26           N  
ATOM   1676  CA  GLY A 189       6.702  37.151  13.333  1.00 31.46           C  
ATOM   1677  C   GLY A 189       6.794  36.838  11.850  1.00 31.11           C  
ATOM   1678  O   GLY A 189       6.842  35.668  11.475  1.00 34.97           O  
ATOM   1679  N   THR A 190       6.829  37.871  11.013  0.50 29.52           N  
ATOM   1681  CA  THR A 190       6.901  37.684   9.565  0.50 30.67           C  
ATOM   1683  C   THR A 190       8.097  38.393   8.929  0.50 31.10           C  
ATOM   1685  O   THR A 190       8.487  39.482   9.350  0.50 30.83           O  
ATOM   1687  CB  THR A 190       5.612  38.203   8.882  0.50 29.65           C  
ATOM   1689  OG1 THR A 190       4.479  37.505   9.408  0.50 34.30           O  
ATOM   1691  CG2 THR A 190       5.677  37.992   7.376  0.50 30.29           C  
ATOM   1693  N   PHE A 191       8.676  37.767   7.908  1.00 31.41           N  
ATOM   1694  CA  PHE A 191       9.814  38.349   7.199  1.00 33.32           C  
ATOM   1695  C   PHE A 191       9.255  39.101   5.989  1.00 35.53           C  
ATOM   1696  O   PHE A 191       8.548  38.516   5.168  1.00 39.56           O  
ATOM   1697  CB  PHE A 191      10.766  37.247   6.707  1.00 32.36           C  
ATOM   1698  CG  PHE A 191      11.505  36.529   7.805  1.00 36.42           C  
ATOM   1699  CD1 PHE A 191      12.541  37.156   8.489  1.00 35.85           C  
ATOM   1700  CD2 PHE A 191      11.176  35.215   8.142  1.00 38.88           C  
ATOM   1701  CE1 PHE A 191      13.247  36.487   9.495  1.00 36.52           C  
ATOM   1702  CE2 PHE A 191      11.876  34.534   9.145  1.00 40.85           C  
ATOM   1703  CZ  PHE A 191      12.915  35.175   9.825  1.00 38.39           C  
ATOM   1704  N   HIS A 192       9.576  40.388   5.888  0.50 34.52           N  
ATOM   1706  CA  HIS A 192       9.104  41.227   4.786  0.50 34.34           C  
ATOM   1708  C   HIS A 192      10.285  41.696   3.939  0.50 34.30           C  
ATOM   1710  O   HIS A 192      11.208  42.317   4.462  0.50 33.04           O  
ATOM   1712  CB  HIS A 192       8.383  42.462   5.337  0.50 36.28           C  
ATOM   1714  CG  HIS A 192       7.359  42.157   6.386  0.50 38.20           C  
ATOM   1716  ND1 HIS A 192       6.122  41.625   6.093  0.50 40.70           N  
ATOM   1718  CD2 HIS A 192       7.391  42.315   7.732  0.50 37.67           C  
ATOM   1720  CE1 HIS A 192       5.435  41.470   7.211  0.50 40.11           C  
ATOM   1722  NE2 HIS A 192       6.182  41.881   8.219  0.50 40.60           N  
ATOM   1724  N   VAL A 193      10.259  41.414   2.639  1.00 32.77           N  
ATOM   1725  CA  VAL A 193      11.340  41.849   1.762  1.00 34.81           C  
ATOM   1726  C   VAL A 193      11.115  43.304   1.352  1.00 35.15           C  
ATOM   1727  O   VAL A 193      10.245  43.595   0.534  1.00 36.76           O  
ATOM   1728  CB  VAL A 193      11.419  40.978   0.487  1.00 33.98           C  
ATOM   1729  CG1 VAL A 193      12.528  41.490  -0.425  1.00 35.42           C  
ATOM   1730  CG2 VAL A 193      11.674  39.526   0.862  1.00 32.99           C  
ATOM   1731  N   ALA A 194      11.897  44.215   1.924  1.00 33.53           N  
ATOM   1732  CA  ALA A 194      11.766  45.635   1.610  1.00 36.37           C  
ATOM   1733  C   ALA A 194      12.581  46.010   0.376  1.00 38.06           C  
ATOM   1734  O   ALA A 194      12.091  46.706  -0.512  1.00 41.76           O  
ATOM   1735  CB  ALA A 194      12.209  46.475   2.799  1.00 36.49           C  
ATOM   1736  N   VAL A 195      13.826  45.543   0.334  1.00 37.09           N  
ATOM   1737  CA  VAL A 195      14.735  45.807  -0.778  1.00 37.42           C  
ATOM   1738  C   VAL A 195      15.460  44.503  -1.096  1.00 38.27           C  
ATOM   1739  O   VAL A 195      15.769  43.736  -0.191  1.00 37.24           O  
ATOM   1740  CB  VAL A 195      15.796  46.873  -0.398  1.00 38.18           C  
ATOM   1741  CG1 VAL A 195      16.699  47.155  -1.583  1.00 40.34           C  
ATOM   1742  CG2 VAL A 195      15.113  48.149   0.072  1.00 39.73           C  
ATOM   1743  N   GLU A 196      15.732  44.248  -2.373  1.00 38.18           N  
ATOM   1744  CA  GLU A 196      16.423  43.021  -2.751  1.00 40.02           C  
ATOM   1745  C   GLU A 196      17.498  43.201  -3.822  1.00 40.62           C  
ATOM   1746  O   GLU A 196      17.224  43.685  -4.921  1.00 39.32           O  
ATOM   1747  CB  GLU A 196      15.405  41.977  -3.214  1.00 41.48           C  
ATOM   1748  CG  GLU A 196      16.020  40.703  -3.770  1.00 43.87           C  
ATOM   1749  CD  GLU A 196      14.966  39.667  -4.087  1.00 45.04           C  
ATOM   1750  OE1 GLU A 196      13.895  40.062  -4.590  1.00 45.48           O  
ATOM   1751  OE2 GLU A 196      15.204  38.466  -3.840  1.00 44.77           O  
ATOM   1752  N   GLY A 197      18.722  42.808  -3.483  1.00 37.10           N  
ATOM   1753  CA  GLY A 197      19.834  42.902  -4.415  1.00 40.19           C  
ATOM   1754  C   GLY A 197      20.136  44.280  -4.980  1.00 40.45           C  
ATOM   1755  O   GLY A 197      20.546  44.401  -6.134  1.00 41.68           O  
ATOM   1756  N   ASP A 198      19.950  45.317  -4.172  1.00 39.37           N  
ATOM   1757  CA  ASP A 198      20.207  46.684  -4.617  1.00 42.64           C  
ATOM   1758  C   ASP A 198      21.706  46.932  -4.787  1.00 43.94           C  
ATOM   1759  O   ASP A 198      22.495  46.667  -3.876  1.00 40.24           O  
ATOM   1760  CB  ASP A 198      19.638  47.680  -3.607  1.00 44.15           C  
ATOM   1761  CG  ASP A 198      19.610  49.094  -4.141  1.00 48.31           C  
ATOM   1762  OD1 ASP A 198      18.817  49.367  -5.069  1.00 51.62           O  
ATOM   1763  OD2 ASP A 198      20.387  49.932  -3.643  1.00 50.60           O  
ATOM   1764  N   VAL A 199      22.095  47.444  -5.954  1.00 42.02           N  
ATOM   1765  CA  VAL A 199      23.504  47.729  -6.229  1.00 44.40           C  
ATOM   1766  C   VAL A 199      23.755  49.199  -6.569  1.00 45.96           C  
ATOM   1767  O   VAL A 199      24.673  49.520  -7.320  1.00 45.42           O  
ATOM   1768  CB  VAL A 199      24.040  46.867  -7.399  1.00 42.36           C  
ATOM   1769  CG1 VAL A 199      24.007  45.395  -7.021  1.00 43.75           C  
ATOM   1770  CG2 VAL A 199      23.213  47.120  -8.653  1.00 43.50           C  
ATOM   1771  N   SER A 200      22.942  50.085  -6.004  1.00 47.94           N  
ATOM   1772  CA  SER A 200      23.072  51.520  -6.246  1.00 50.99           C  
ATOM   1773  C   SER A 200      24.492  52.045  -6.028  1.00 51.85           C  
ATOM   1774  O   SER A 200      24.996  52.846  -6.815  1.00 52.37           O  
ATOM   1775  CB  SER A 200      22.112  52.291  -5.336  1.00 51.60           C  
ATOM   1776  OG  SER A 200      20.765  51.941  -5.590  1.00 56.74           O  
ATOM   1777  N   HIS A 201      25.127  51.586  -4.956  1.00 50.62           N  
ATOM   1778  CA  HIS A 201      26.479  52.013  -4.593  1.00 52.23           C  
ATOM   1779  C   HIS A 201      27.622  51.453  -5.444  1.00 55.45           C  
ATOM   1780  O   HIS A 201      28.761  51.910  -5.325  1.00 54.75           O  
ATOM   1781  CB  HIS A 201      26.744  51.652  -3.127  1.00 48.86           C  
ATOM   1782  CG  HIS A 201      26.601  50.188  -2.836  1.00 45.67           C  
ATOM   1783  ND1 HIS A 201      25.387  49.539  -2.877  1.00 44.81           N  
ATOM   1784  CD2 HIS A 201      27.527  49.242  -2.551  1.00 44.93           C  
ATOM   1785  CE1 HIS A 201      25.572  48.251  -2.635  1.00 44.57           C  
ATOM   1786  NE2 HIS A 201      26.860  48.046  -2.435  1.00 43.97           N  
ATOM   1787  N   ILE A 202      27.328  50.483  -6.312  1.00 58.09           N  
ATOM   1788  CA  ILE A 202      28.373  49.868  -7.127  1.00 63.71           C  
ATOM   1789  C   ILE A 202      28.580  50.492  -8.502  1.00 68.20           C  
ATOM   1790  O   ILE A 202      27.640  50.640  -9.281  1.00 69.09           O  
ATOM   1791  CB  ILE A 202      28.128  48.349  -7.325  1.00 64.70           C  
ATOM   1792  CG1 ILE A 202      28.041  47.652  -5.962  1.00 64.29           C  
ATOM   1793  CG2 ILE A 202      29.235  47.758  -8.198  1.00 62.84           C  
ATOM   1794  CD1 ILE A 202      27.277  46.337  -5.999  1.00 65.76           C  
ATOM   1795  N   GLU A 203      29.839  50.835  -8.779  1.00 72.72           N  
ATOM   1796  CA  GLU A 203      30.249  51.426 -10.055  1.00 77.02           C  
ATOM   1797  C   GLU A 203      30.043  50.482 -11.256  1.00 78.39           C  
ATOM   1798  O   GLU A 203      29.176  50.721 -12.111  1.00 77.39           O  
ATOM   1799  CB  GLU A 203      31.725  51.851  -9.975  1.00 79.84           C  
ATOM   1800  CG  GLU A 203      32.650  50.900  -9.181  1.00 84.18           C  
ATOM   1801  CD  GLU A 203      32.577  51.114  -7.661  1.00 86.47           C  
ATOM   1802  OE1 GLU A 203      32.575  52.286  -7.233  1.00 88.36           O  
ATOM   1803  OE2 GLU A 203      32.540  50.123  -6.894  1.00 85.74           O  
ATOM   1804  N   GLU A 204      30.853  49.427 -11.320  1.00 81.06           N  
ATOM   1805  CA  GLU A 204      30.763  48.434 -12.394  1.00 83.53           C  
ATOM   1806  C   GLU A 204      30.212  47.126 -11.820  1.00 84.10           C  
ATOM   1807  O   GLU A 204      30.859  46.478 -10.990  1.00 84.10           O  
ATOM   1808  CB  GLU A 204      32.139  48.158 -13.012  1.00 85.30           C  
ATOM   1809  CG  GLU A 204      32.966  49.395 -13.332  1.00 88.02           C  
ATOM   1810  CD  GLU A 204      34.142  49.087 -14.261  1.00 89.67           C  
ATOM   1811  OE1 GLU A 204      34.933  48.160 -13.958  1.00 89.73           O  
ATOM   1812  OE2 GLU A 204      34.275  49.778 -15.300  1.00 89.93           O  
ATOM   1813  N   VAL A 205      29.032  46.743 -12.272  1.00 84.48           N  
ATOM   1814  CA  VAL A 205      28.391  45.526 -11.798  1.00 85.52           C  
ATOM   1815  C   VAL A 205      28.808  44.323 -12.683  1.00 85.98           C  
ATOM   1816  O   VAL A 205      28.714  44.384 -13.911  1.00 85.66           O  
ATOM   1817  CB  VAL A 205      26.842  45.758 -11.775  1.00 85.67           C  
ATOM   1818  CG1 VAL A 205      26.122  44.555 -11.264  1.00 84.40           C  
ATOM   1819  CG2 VAL A 205      26.517  46.958 -10.877  1.00 85.44           C  
ATOM   1820  N   LYS A 206      29.302  43.250 -12.051  1.00 86.10           N  
ATOM   1821  CA  LYS A 206      29.740  42.033 -12.762  1.00 86.93           C  
ATOM   1822  C   LYS A 206      28.982  40.766 -12.318  1.00 87.29           C  
ATOM   1823  O   LYS A 206      28.925  40.468 -11.120  1.00 86.54           O  
ATOM   1824  CB  LYS A 206      31.227  41.741 -12.514  1.00 87.28           C  
ATOM   1825  CG  LYS A 206      32.263  42.768 -12.939  1.00 87.30           C  
ATOM   1826  CD  LYS A 206      33.650  42.131 -12.738  1.00 87.20           C  
ATOM   1827  CE  LYS A 206      34.798  43.126 -12.786  1.00 87.05           C  
ATOM   1828  NZ  LYS A 206      36.087  42.460 -12.450  1.00 85.61           N  
ATOM   1829  N   GLU A 207      28.441  40.005 -13.275  1.00 87.85           N  
ATOM   1830  CA  GLU A 207      27.718  38.767 -12.956  1.00 88.45           C  
ATOM   1831  C   GLU A 207      28.682  37.654 -12.531  1.00 88.72           C  
ATOM   1832  O   GLU A 207      28.728  36.572 -13.128  1.00 88.23           O  
ATOM   1833  CB  GLU A 207      26.877  38.304 -14.152  1.00 88.95           C  
ATOM   1834  CG  GLU A 207      25.462  38.872 -14.161  1.00 90.27           C  
ATOM   1835  CD  GLU A 207      25.392  40.314 -14.639  1.00 91.70           C  
ATOM   1836  OE1 GLU A 207      26.289  41.119 -14.300  1.00 92.18           O  
ATOM   1837  OE2 GLU A 207      24.420  40.646 -15.350  1.00 93.87           O  
ATOM   1838  N   VAL A 208      29.436  37.943 -11.469  1.00 89.27           N  
ATOM   1839  CA  VAL A 208      30.441  37.041 -10.910  1.00 89.22           C  
ATOM   1840  C   VAL A 208      30.161  36.685  -9.435  1.00 89.41           C  
ATOM   1841  O   VAL A 208      30.230  35.480  -9.092  1.00 89.16           O  
ATOM   1842  CB  VAL A 208      31.843  37.688 -11.024  1.00 89.05           C  
ATOM   1843  CG1 VAL A 208      32.871  36.814 -10.394  1.00 89.13           C  
ATOM   1844  CG2 VAL A 208      32.188  37.926 -12.484  1.00 89.16           C  
ATOM   1845  OXT VAL A 208      29.889  37.610  -8.635  1.00 89.33           O  
TER    1846      VAL A 208                                                      
END
MOLECULE T0394.pdb
ATOM      1  N   ASN     1       7.131  28.263  26.435  1.00 37.08           N  
ATOM      2  CA  ASN     1       7.437  29.315  25.416  1.00 36.05           C  
ATOM      3  C   ASN     1       7.192  30.735  25.903  1.00 34.53           C  
ATOM      4  O   ASN     1       6.216  30.997  26.611  1.00 34.93           O  
ATOM      5  CB  ASN     1       6.662  29.047  24.125  1.00 37.00           C  
ATOM      6  CG  ASN     1       7.395  28.086  23.213  1.00 39.47           C  
ATOM      7  OD1 ASN     1       7.200  26.869  23.286  1.00 43.62           O  
ATOM      8  ND2 ASN     1       8.288  28.624  22.384  1.00 40.23           N  
ATOM      9  N   LEU     2       8.082  31.640  25.492  1.00 32.19           N  
ATOM     10  CA  LEU     2       8.122  33.016  25.993  1.00 29.95           C  
ATOM     11  C   LEU     2       7.110  33.917  25.298  1.00 28.07           C  
ATOM     12  O   LEU     2       6.983  33.894  24.068  1.00 28.29           O  
ATOM     13  CB  LEU     2       9.527  33.600  25.804  1.00 29.69           C  
ATOM     14  CG  LEU     2      10.670  32.930  26.564  1.00 29.92           C  
ATOM     15  CD1 LEU     2      12.000  33.222  25.886  1.00 29.23           C  
ATOM     16  CD2 LEU     2      10.663  33.446  27.989  1.00 28.60           C  
ATOM     17  N   TYR     3       6.407  34.722  26.095  1.00 25.72           N  
ATOM     18  CA  TYR     3       5.529  35.769  25.587  1.00 24.38           C  
ATOM     19  C   TYR     3       6.320  37.041  25.320  1.00 23.44           C  
ATOM     20  O   TYR     3       7.033  37.574  26.203  1.00 21.70           O  
ATOM     21  CB  TYR     3       4.386  36.067  26.569  1.00 24.95           C  
ATOM     22  CG  TYR     3       3.542  37.283  26.201  1.00 24.49           C  
ATOM     23  CD1 TYR     3       2.296  37.140  25.578  1.00 25.41           C  
ATOM     24  CD2 TYR     3       3.986  38.574  26.489  1.00 24.54           C  
ATOM     25  CE1 TYR     3       1.528  38.265  25.239  1.00 26.31           C  
ATOM     26  CE2 TYR     3       3.232  39.700  26.154  1.00 24.99           C  
ATOM     27  CZ  TYR     3       2.015  39.541  25.528  1.00 26.12           C  
ATOM     28  OH  TYR     3       1.282  40.675  25.217  1.00 29.19           O  
ATOM     29  N   PHE     4       6.198  37.532  24.092  1.00 21.28           N  
ATOM     30  CA  PHE     4       6.804  38.796  23.732  1.00 21.92           C  
ATOM     31  C   PHE     4       5.758  39.769  23.248  1.00 22.33           C  
ATOM     32  O   PHE     4       4.744  39.358  22.707  1.00 21.26           O  
ATOM     33  CB  PHE     4       7.841  38.598  22.620  1.00 21.80           C  
ATOM     34  CG  PHE     4       9.019  37.763  23.036  1.00 20.69           C  
ATOM     35  CD1 PHE     4       9.930  38.245  23.973  1.00 18.93           C  
ATOM     36  CD2 PHE     4       9.209  36.497  22.501  1.00 21.68           C  
ATOM     37  CE1 PHE     4      11.035  37.458  24.352  1.00 20.05           C  
ATOM     38  CE2 PHE     4      10.302  35.717  22.866  1.00 22.45           C  
ATOM     39  CZ  PHE     4      11.222  36.218  23.803  1.00 21.82           C  
ATOM     40  N   GLN     5       6.032  41.054  23.450  1.00 22.99           N  
ATOM     41  CA  GLN     5       5.226  42.107  22.871  1.00 24.75           C  
ATOM     42  C   GLN     5       5.521  42.151  21.367  1.00 23.85           C  
ATOM     43  O   GLN     5       6.451  41.461  20.899  1.00 23.54           O  
ATOM     44  CB  GLN     5       5.532  43.444  23.553  1.00 26.07           C  
ATOM     45  CG  GLN     5       5.034  43.473  25.022  1.00 31.04           C  
ATOM     46  CD  GLN     5       4.811  44.878  25.566  1.00 37.81           C  
ATOM     47  OE1 GLN     5       5.661  45.777  25.403  1.00 41.06           O  
ATOM     48  NE2 GLN     5       3.660  45.079  26.215  1.00 38.49           N  
ATOM     49  N   SER     6       4.726  42.924  20.628  1.00 23.52           N  
ATOM     50  CA  SER     6       4.940  43.126  19.191  0.50 23.55           C  
ATOM     52  C   SER     6       6.337  43.702  18.962  1.00 22.75           C  
ATOM     53  O   SER     6       6.858  44.463  19.805  1.00 22.96           O  
ATOM     54  CB  SER     6       3.856  44.057  18.638  0.50 23.94           C  
ATOM     56  OG  SER     6       3.940  44.174  17.233  0.50 25.41           O  
ATOM     58  N   ALA     7       6.977  43.335  17.852  1.00 21.09           N  
ATOM     59  CA  ALA     7       8.341  43.796  17.589  1.00 19.34           C  
ATOM     60  C   ALA     7       8.616  43.806  16.096  1.00 18.62           C  
ATOM     61  O   ALA     7       7.962  43.078  15.352  1.00 17.81           O  
ATOM     62  CB  ALA     7       9.361  42.902  18.314  1.00 18.58           C  
ATOM     63  N   ARG     8       9.540  44.662  15.692  1.00 17.77           N  
ATOM     64  CA  ARG     8       9.981  44.808  14.311  1.00 18.09           C  
ATOM     65  C   ARG     8      11.475  45.003  14.342  1.00 17.38           C  
ATOM     66  O   ARG     8      11.988  45.711  15.227  1.00 16.45           O  
ATOM     67  CB  ARG     8       9.398  46.071  13.683  1.00 19.36           C  
ATOM     68  CG  ARG     8       7.946  46.007  13.335  1.00 23.70           C  
ATOM     69  CD  ARG     8       7.465  47.406  12.982  1.00 28.18           C  
ATOM     70  NE  ARG     8       7.941  47.887  11.680  1.00 30.83           N  
ATOM     71  CZ  ARG     8       8.710  48.960  11.501  1.00 30.42           C  
ATOM     72  NH1 ARG     8       9.117  49.682  12.536  1.00 32.52           N  
ATOM     73  NH2 ARG     8       9.060  49.316  10.274  1.00 29.09           N  
ATOM     74  N   PHE     9      12.184  44.376  13.397  1.00 15.44           N  
ATOM     75  CA  PHE     9      13.609  44.661  13.228  1.00 14.36           C  
ATOM     76  C   PHE     9      14.024  44.617  11.750  1.00 14.07           C  
ATOM     77  O   PHE     9      13.327  44.021  10.922  1.00 14.11           O  
ATOM     78  CB  PHE     9      14.503  43.808  14.139  1.00 14.06           C  
ATOM     79  CG  PHE     9      14.646  42.339  13.723  1.00 14.99           C  
ATOM     80  CD1 PHE     9      15.716  41.917  12.893  1.00 14.73           C  
ATOM     81  CD2 PHE     9      13.778  41.373  14.237  1.00 14.99           C  
ATOM     82  CE1 PHE     9      15.873  40.529  12.575  1.00 15.03           C  
ATOM     83  CE2 PHE     9      13.931  40.017  13.902  1.00 13.86           C  
ATOM     84  CZ  PHE     9      14.979  39.616  13.065  1.00 15.53           C  
ATOM     85  N   ALA    10      15.107  45.315  11.432  1.00 13.59           N  
ATOM     86  CA  ALA    10      15.614  45.381  10.074  1.00 13.29           C  
ATOM     87  C   ALA    10      16.736  44.351   9.943  1.00 12.11           C  
ATOM     88  O   ALA    10      17.515  44.114  10.867  1.00 12.79           O  
ATOM     89  CB  ALA    10      16.127  46.747   9.770  1.00 13.92           C  
ATOM     90  N   LEU    11      16.820  43.776   8.765  1.00 11.89           N  
ATOM     91  CA  LEU    11      17.884  42.825   8.461  1.00 11.66           C  
ATOM     92  C   LEU    11      18.479  43.206   7.106  1.00 11.25           C  
ATOM     93  O   LEU    11      17.791  43.100   6.088  1.00 11.70           O  
ATOM     94  CB  LEU    11      17.268  41.424   8.382  1.00 11.80           C  
ATOM     95  CG  LEU    11      18.199  40.311   7.867  1.00 11.81           C  
ATOM     96  CD1 LEU    11      19.499  40.184   8.709  1.00 11.54           C  
ATOM     97  CD2 LEU    11      17.431  38.946   7.835  1.00 11.16           C  
ATOM     98  N   THR    12      19.739  43.651   7.093  1.00 11.06           N  
ATOM     99  CA  THR    12      20.437  43.941   5.843  1.00 10.80           C  
ATOM    100  C   THR    12      21.431  42.812   5.554  1.00 10.75           C  
ATOM    101  O   THR    12      22.268  42.492   6.427  1.00 10.78           O  
ATOM    102  CB  THR    12      21.207  45.258   5.979  1.00 12.04           C  
ATOM    103  OG1 THR    12      20.261  46.309   6.268  1.00 13.87           O  
ATOM    104  CG2 THR    12      21.944  45.545   4.716  1.00 11.84           C  
ATOM    105  N   VAL    13      21.329  42.215   4.366  1.00 10.59           N  
ATOM    106  CA  VAL    13      22.159  41.059   3.976  1.00 10.00           C  
ATOM    107  C   VAL    13      23.009  41.448   2.754  1.00 10.55           C  
ATOM    108  O   VAL    13      22.471  41.918   1.733  1.00 10.36           O  
ATOM    109  CB  VAL    13      21.256  39.828   3.638  1.00 10.02           C  
ATOM    110  CG1 VAL    13      22.153  38.561   3.516  1.00  9.93           C  
ATOM    111  CG2 VAL    13      20.243  39.644   4.736  1.00 12.14           C  
ATOM    112  N   VAL    14      24.327  41.288   2.872  1.00 10.61           N  
ATOM    113  CA  VAL    14      25.251  41.780   1.877  1.00 10.14           C  
ATOM    114  C   VAL    14      26.202  40.645   1.457  1.00 10.94           C  
ATOM    115  O   VAL    14      26.790  40.007   2.325  1.00 10.94           O  
ATOM    116  CB  VAL    14      26.075  42.959   2.446  1.00 11.36           C  
ATOM    117  CG1 VAL    14      27.056  43.456   1.382  1.00  9.89           C  
ATOM    118  CG2 VAL    14      25.134  44.137   2.849  1.00 12.81           C  
ATOM    119  N   ARG    15      26.318  40.368   0.158  1.00 10.04           N  
ATOM    120  CA  ARG    15      27.289  39.336  -0.282  1.00 10.79           C  
ATOM    121  C   ARG    15      28.699  39.909  -0.117  1.00 10.29           C  
ATOM    122  O   ARG    15      28.904  41.106  -0.283  1.00 11.57           O  
ATOM    123  CB  ARG    15      27.048  38.936  -1.768  1.00  9.43           C  
ATOM    124  CG  ARG    15      28.024  37.834  -2.263  1.00 11.35           C  
ATOM    125  CD  ARG    15      27.585  37.222  -3.602  1.00 12.46           C  
ATOM    126  NE  ARG    15      28.624  36.330  -4.093  1.00 13.39           N  
ATOM    127  CZ  ARG    15      29.143  36.335  -5.318  1.00 15.37           C  
ATOM    128  NH1 ARG    15      28.674  37.137  -6.260  1.00 14.12           N  
ATOM    129  NH2 ARG    15      30.131  35.500  -5.608  1.00 13.89           N  
ATOM    130  N   HIS    16      29.679  39.062   0.166  1.00 11.14           N  
ATOM    131  CA  HIS    16      31.080  39.515   0.244  1.00 11.40           C  
ATOM    132  C   HIS    16      31.557  40.087  -1.118  1.00 12.40           C  
ATOM    133  O   HIS    16      30.975  39.795  -2.202  1.00 12.27           O  
ATOM    134  CB  HIS    16      31.969  38.326   0.622  1.00 11.89           C  
ATOM    135  CG  HIS    16      31.909  37.244  -0.383  1.00 11.77           C  
ATOM    136  ND1 HIS    16      32.675  37.259  -1.532  1.00 10.88           N  
ATOM    137  CD2 HIS    16      31.113  36.155  -0.466  1.00 14.23           C  
ATOM    138  CE1 HIS    16      32.387  36.191  -2.256  1.00 16.26           C  
ATOM    139  NE2 HIS    16      31.442  35.506  -1.630  1.00 14.39           N  
ATOM    140  N   GLY    17      32.636  40.876  -1.055  1.00 12.57           N  
ATOM    141  CA  GLY    17      33.265  41.387  -2.260  1.00 12.64           C  
ATOM    142  C   GLY    17      33.923  40.326  -3.120  1.00 13.60           C  
ATOM    143  O   GLY    17      34.100  39.176  -2.698  1.00 12.67           O  
ATOM    144  N   GLU    18      34.245  40.696  -4.356  1.00 12.79           N  
ATOM    145  CA  GLU    18      34.855  39.768  -5.308  1.00 14.33           C  
ATOM    146  C   GLU    18      36.181  39.161  -4.816  1.00 14.19           C  
ATOM    147  O   GLU    18      36.985  39.853  -4.170  1.00 13.24           O  
ATOM    148  CB  GLU    18      35.072  40.498  -6.641  1.00 15.58           C  
ATOM    149  CG  GLU    18      35.615  39.646  -7.737  1.00 18.58           C  
ATOM    150  CD  GLU    18      36.423  40.473  -8.747  1.00 26.24           C  
ATOM    151  OE1 GLU    18      37.548  40.925  -8.432  1.00 28.76           O  
ATOM    152  OE2 GLU    18      35.935  40.634  -9.857  1.00 27.17           O  
ATOM    153  N   THR    19      36.361  37.856  -5.065  1.00 14.63           N  
ATOM    154  CA  THR    19      37.661  37.193  -4.893  1.00 15.69           C  
ATOM    155  C   THR    19      38.223  36.845  -6.260  1.00 16.12           C  
ATOM    156  O   THR    19      37.525  36.893  -7.282  1.00 15.11           O  
ATOM    157  CB  THR    19      37.572  35.837  -4.120  1.00 14.87           C  
ATOM    158  OG1 THR    19      36.910  34.873  -4.955  1.00 16.55           O  
ATOM    159  CG2 THR    19      36.837  35.983  -2.742  1.00 12.93           C  
ATOM    160  N   ARG    20      39.495  36.453  -6.260  1.00 16.97           N  
ATOM    161  CA  ARG    20      40.161  35.912  -7.443  1.00 18.93           C  
ATOM    162  C   ARG    20      39.322  34.822  -8.158  1.00 19.29           C  
ATOM    163  O   ARG    20      39.202  34.812  -9.396  1.00 20.04           O  
ATOM    164  CB  ARG    20      41.546  35.408  -6.992  1.00 19.32           C  
ATOM    165  CG  ARG    20      42.275  34.361  -7.777  1.00 22.18           C  
ATOM    166  CD  ARG    20      43.709  34.338  -7.214  1.00 21.66           C  
ATOM    167  NE  ARG    20      43.840  33.443  -6.063  1.00 20.51           N  
ATOM    168  CZ  ARG    20      44.436  32.262  -6.102  1.00 22.87           C  
ATOM    169  NH1 ARG    20      44.481  31.517  -5.016  1.00 24.91           N  
ATOM    170  NH2 ARG    20      44.975  31.823  -7.228  1.00 23.22           N  
ATOM    171  N   PHE    21      38.714  33.939  -7.373  1.00 17.76           N  
ATOM    172  CA  PHE    21      37.948  32.834  -7.941  1.00 17.97           C  
ATOM    173  C   PHE    21      36.604  33.277  -8.506  1.00 17.74           C  
ATOM    174  O   PHE    21      36.151  32.759  -9.544  1.00 16.99           O  
ATOM    175  CB  PHE    21      37.833  31.701  -6.911  1.00 19.01           C  
ATOM    176  CG  PHE    21      39.181  31.131  -6.530  1.00 20.00           C  
ATOM    177  CD1 PHE    21      40.117  30.838  -7.512  1.00 23.92           C  
ATOM    178  CD2 PHE    21      39.525  30.940  -5.202  1.00 24.47           C  
ATOM    179  CE1 PHE    21      41.375  30.310  -7.171  1.00 24.93           C  
ATOM    180  CE2 PHE    21      40.774  30.412  -4.859  1.00 25.63           C  
ATOM    181  CZ  PHE    21      41.691  30.099  -5.842  1.00 24.75           C  
ATOM    182  N   ASN    22      35.962  34.229  -7.840  1.00 17.57           N  
ATOM    183  CA  ASN    22      34.719  34.794  -8.414  1.00 18.52           C  
ATOM    184  C   ASN    22      34.988  35.351  -9.818  1.00 19.89           C  
ATOM    185  O   ASN    22      34.228  35.105 -10.771  1.00 19.51           O  
ATOM    186  CB  ASN    22      34.190  35.907  -7.554  1.00 18.37           C  
ATOM    187  CG  ASN    22      33.602  35.407  -6.245  1.00 19.37           C  
ATOM    188  OD1 ASN    22      33.150  34.237  -6.104  1.00 18.97           O  
ATOM    189  ND2 ASN    22      33.568  36.286  -5.301  1.00 13.55           N  
ATOM    190  N   LYS    23      36.093  36.074  -9.948  1.00 20.75           N  
ATOM    191  CA  LYS    23      36.443  36.692 -11.235  1.00 23.46           C  
ATOM    192  C   LYS    23      36.623  35.624 -12.306  1.00 24.29           C  
ATOM    193  O   LYS    23      36.138  35.776 -13.428  1.00 25.47           O  
ATOM    194  CB  LYS    23      37.690  37.556 -11.072  1.00 23.52           C  
ATOM    195  CG  LYS    23      38.222  38.212 -12.349  1.00 27.47           C  
ATOM    196  CD  LYS    23      37.326  39.322 -12.822  1.00 32.44           C  
ATOM    197  CE  LYS    23      38.108  40.299 -13.700  1.00 35.21           C  
ATOM    198  NZ  LYS    23      37.221  41.431 -14.082  1.00 39.24           N  
ATOM    199  N   GLU    24      37.280  34.531 -11.936  1.00 25.02           N  
ATOM    200  CA  GLU    24      37.646  33.470 -12.881  1.00 26.99           C  
ATOM    201  C   GLU    24      36.574  32.393 -13.025  1.00 26.34           C  
ATOM    202  O   GLU    24      36.802  31.393 -13.728  1.00 27.71           O  
ATOM    203  CB  GLU    24      38.981  32.836 -12.465  1.00 27.65           C  
ATOM    204  CG  GLU    24      40.141  33.811 -12.232  1.00 30.31           C  
ATOM    205  CD  GLU    24      40.401  34.779 -13.408  1.00 36.92           C  
ATOM    206  OE1 GLU    24      40.063  34.451 -14.569  1.00 38.73           O  
ATOM    207  OE2 GLU    24      40.950  35.884 -13.159  1.00 38.71           O  
ATOM    208  N   LYS    25      35.421  32.604 -12.378  1.00 25.57           N  
ATOM    209  CA  LYS    25      34.277  31.667 -12.408  1.00 24.89           C  
ATOM    210  C   LYS    25      34.691  30.274 -11.910  1.00 22.95           C  
ATOM    211  O   LYS    25      34.323  29.237 -12.514  1.00 24.07           O  
ATOM    212  CB  LYS    25      33.655  31.563 -13.820  1.00 26.00           C  
ATOM    213  CG  LYS    25      33.068  32.889 -14.367  1.00 30.31           C  
ATOM    214  CD  LYS    25      31.531  32.954 -14.285  1.00 37.00           C  
ATOM    215  CE  LYS    25      30.851  32.201 -15.442  1.00 39.72           C  
ATOM    216  NZ  LYS    25      29.358  32.126 -15.292  1.00 41.81           N  
ATOM    217  N   ILE    26      35.474  30.269 -10.834  1.00 20.24           N  
ATOM    218  CA  ILE    26      35.921  29.042 -10.172  0.50 19.68           C  
ATOM    220  C   ILE    26      35.057  28.826  -8.941  1.00 18.78           C  
ATOM    221  O   ILE    26      34.810  29.759  -8.172  1.00 18.27           O  
ATOM    222  CB  ILE    26      37.425  29.134  -9.782  0.50 19.24           C  
ATOM    224  CG1 ILE    26      38.297  29.028 -11.046  0.50 20.15           C  
ATOM    226  CG2 ILE    26      37.834  28.074  -8.758  0.50 19.79           C  
ATOM    228  CD1 ILE    26      39.716  29.509 -10.829  0.50 19.10           C  
ATOM    230  N   ILE    27      34.588  27.598  -8.779  1.00 17.64           N  
ATOM    231  CA  ILE    27      33.708  27.274  -7.670  0.50 17.31           C  
ATOM    233  C   ILE    27      34.422  27.476  -6.353  1.00 17.86           C  
ATOM    234  O   ILE    27      35.542  27.019  -6.154  1.00 16.33           O  
ATOM    235  CB  ILE    27      33.170  25.849  -7.774  0.50 16.83           C  
ATOM    237  CG1 ILE    27      32.426  25.673  -9.102  0.50 18.12           C  
ATOM    239  CG2 ILE    27      32.228  25.543  -6.610  0.50 15.69           C  
ATOM    241  CD1 ILE    27      32.230  24.258  -9.481  0.50 17.55           C  
ATOM    243  N   GLN    28      33.712  28.157  -5.457  1.00 19.94           N  
ATOM    244  CA  GLN    28      34.188  28.558  -4.186  1.00 21.00           C  
ATOM    245  C   GLN    28      33.026  28.413  -3.207  1.00 20.63           C  
ATOM    246  O   GLN    28      32.128  29.284  -3.155  1.00 21.79           O  
ATOM    247  CB  GLN    28      34.493  30.038  -4.326  1.00 22.79           C  
ATOM    248  CG  GLN    28      35.186  30.690  -3.187  1.00 25.95           C  
ATOM    249  CD  GLN    28      35.402  32.143  -3.518  1.00 23.19           C  
ATOM    250  OE1 GLN    28      34.439  32.916  -3.650  1.00 26.05           O  
ATOM    251  NE2 GLN    28      36.658  32.528  -3.684  1.00 18.04           N  
ATOM    252  N   GLY    29      33.023  27.314  -2.470  1.00 18.42           N  
ATOM    253  CA  GLY    29      32.073  27.123  -1.387  1.00 18.14           C  
ATOM    254  C   GLY    29      32.830  27.131  -0.072  1.00 18.33           C  
ATOM    255  O   GLY    29      33.116  28.190   0.473  1.00 18.58           O  
ATOM    256  N   GLN    30      33.180  25.950   0.427  1.00 18.10           N  
ATOM    257  CA  GLN    30      33.966  25.825   1.659  1.00 19.44           C  
ATOM    258  C   GLN    30      35.303  25.107   1.278  1.00 21.53           C  
ATOM    259  O   GLN    30      35.699  24.135   1.898  1.00 22.52           O  
ATOM    260  CB  GLN    30      33.146  25.074   2.757  1.00 18.80           C  
ATOM    261  CG  GLN    30      31.821  25.772   3.166  1.00 17.51           C  
ATOM    262  CD  GLN    30      31.107  25.155   4.393  1.00 18.30           C  
ATOM    263  OE1 GLN    30      31.751  24.637   5.332  1.00 17.71           O  
ATOM    264  NE2 GLN    30      29.785  25.260   4.418  1.00 15.39           N  
ATOM    265  N   GLY    31      35.971  25.592   0.233  1.00 23.08           N  
ATOM    266  CA  GLY    31      37.221  24.988  -0.236  1.00 24.28           C  
ATOM    267  C   GLY    31      38.442  25.756   0.219  1.00 24.89           C  
ATOM    268  O   GLY    31      38.798  25.700   1.396  1.00 24.91           O  
ATOM    269  N   VAL    32      39.121  26.439  -0.706  1.00 24.97           N  
ATOM    270  CA  VAL    32      40.138  27.382  -0.288  1.00 24.40           C  
ATOM    271  C   VAL    32      39.368  28.547   0.340  1.00 22.92           C  
ATOM    272  O   VAL    32      38.374  29.027  -0.170  1.00 23.11           O  
ATOM    273  CB  VAL    32      41.112  27.879  -1.434  1.00 25.58           C  
ATOM    274  CG1 VAL    32      41.796  29.243  -1.078  1.00 25.76           C  
ATOM    275  CG2 VAL    32      42.175  26.840  -1.736  1.00 26.45           C  
ATOM    276  N   ASP    33      39.840  28.949   1.490  1.00 21.48           N  
ATOM    277  CA  ASP    33      39.335  30.116   2.151  1.00 19.20           C  
ATOM    278  C   ASP    33      40.047  31.316   1.497  1.00 17.34           C  
ATOM    279  O   ASP    33      41.003  31.846   2.054  1.00 18.03           O  
ATOM    280  CB  ASP    33      39.747  29.960   3.601  1.00 18.89           C  
ATOM    281  CG  ASP    33      39.039  30.875   4.486  1.00 18.74           C  
ATOM    282  OD1 ASP    33      38.258  31.695   3.971  1.00 16.19           O  
ATOM    283  OD2 ASP    33      39.269  30.786   5.698  1.00 18.51           O  
ATOM    284  N   GLU    34      39.564  31.721   0.315  1.00 16.16           N  
ATOM    285  CA  GLU    34      40.199  32.771  -0.530  1.00 13.68           C  
ATOM    286  C   GLU    34      39.829  34.184  -0.062  1.00 13.01           C  
ATOM    287  O   GLU    34      38.658  34.481   0.182  1.00 12.76           O  
ATOM    288  CB  GLU    34      39.758  32.569  -1.988  1.00 13.32           C  
ATOM    289  CG  GLU    34      40.392  33.542  -2.987  1.00 14.27           C  
ATOM    290  CD  GLU    34      41.895  33.337  -3.121  1.00 17.56           C  
ATOM    291  OE1 GLU    34      42.406  32.292  -2.657  1.00 16.95           O  
ATOM    292  OE2 GLU    34      42.561  34.222  -3.687  1.00 14.35           O  
ATOM    293  N   PRO    35      40.816  35.087   0.038  1.00 12.61           N  
ATOM    294  CA  PRO    35      40.519  36.460   0.441  1.00 12.40           C  
ATOM    295  C   PRO    35      39.941  37.281  -0.696  1.00 12.19           C  
ATOM    296  O   PRO    35      39.870  36.798  -1.836  1.00 12.16           O  
ATOM    297  CB  PRO    35      41.903  37.012   0.800  1.00 13.18           C  
ATOM    298  CG  PRO    35      42.830  36.282  -0.091  1.00 11.73           C  
ATOM    299  CD  PRO    35      42.257  34.876  -0.197  1.00 12.29           C  
ATOM    300  N   LEU    36      39.553  38.525  -0.381  1.00 13.27           N  
ATOM    301  CA  LEU    36      39.129  39.442  -1.419  1.00 13.91           C  
ATOM    302  C   LEU    36      40.288  39.748  -2.367  1.00 14.60           C  
ATOM    303  O   LEU    36      41.477  39.720  -1.959  1.00 15.26           O  
ATOM    304  CB  LEU    36      38.660  40.730  -0.791  1.00 13.30           C  
ATOM    305  CG  LEU    36      37.476  40.669   0.167  1.00 11.16           C  
ATOM    306  CD1 LEU    36      37.120  42.084   0.644  1.00 12.32           C  
ATOM    307  CD2 LEU    36      36.294  40.061  -0.606  1.00 14.18           C  
ATOM    308  N   SER    37      39.942  40.002  -3.627  1.00 14.66           N  
ATOM    309  CA  SER    37      40.887  40.588  -4.581  1.00 15.07           C  
ATOM    310  C   SER    37      40.955  42.115  -4.361  1.00 16.18           C  
ATOM    311  O   SER    37      40.191  42.650  -3.561  1.00 15.86           O  
ATOM    312  CB  SER    37      40.387  40.310  -5.990  1.00 15.28           C  
ATOM    313  OG  SER    37      39.163  40.991  -6.245  1.00 15.00           O  
ATOM    314  N   GLU    38      41.843  42.819  -5.053  0.50 16.90           N  
ATOM    316  CA  GLU    38      41.822  44.275  -4.919  0.50 17.68           C  
ATOM    318  C   GLU    38      40.468  44.909  -5.349  0.50 17.34           C  
ATOM    320  O   GLU    38      39.992  45.839  -4.683  0.50 16.87           O  
ATOM    322  CB  GLU    38      43.062  44.905  -5.555  0.50 18.44           C  
ATOM    324  CG  GLU    38      44.363  44.465  -4.861  0.50 20.32           C  
ATOM    326  CD  GLU    38      44.498  45.003  -3.442  0.50 23.44           C  
ATOM    328  OE1 GLU    38      44.550  46.248  -3.280  0.50 23.55           O  
ATOM    330  OE2 GLU    38      44.564  44.191  -2.493  0.50 20.46           O  
ATOM    332  N   THR    39      39.818  44.357  -6.381  1.00 17.89           N  
ATOM    333  CA  THR    39      38.442  44.762  -6.739  1.00 18.70           C  
ATOM    334  C   THR    39      37.477  44.495  -5.573  1.00 17.31           C  
ATOM    335  O   THR    39      36.641  45.350  -5.250  1.00 16.75           O  
ATOM    336  CB  THR    39      37.965  44.078  -8.026  1.00 19.07           C  
ATOM    337  OG1 THR    39      38.780  44.507  -9.123  1.00 23.74           O  
ATOM    338  CG2 THR    39      36.491  44.402  -8.353  1.00 21.10           C  
ATOM    339  N   GLY    40      37.635  43.343  -4.911  1.00 16.64           N  
ATOM    340  CA  GLY    40      36.796  43.013  -3.755  1.00 15.47           C  
ATOM    341  C   GLY    40      36.961  43.990  -2.593  1.00 15.29           C  
ATOM    342  O   GLY    40      35.992  44.422  -1.961  1.00 14.78           O  
ATOM    343  N   PHE    41      38.204  44.362  -2.311  1.00 14.84           N  
ATOM    344  CA  PHE    41      38.482  45.341  -1.283  1.00 16.00           C  
ATOM    345  C   PHE    41      37.857  46.706  -1.643  1.00 15.44           C  
ATOM    346  O   PHE    41      37.278  47.347  -0.781  1.00 16.26           O  
ATOM    347  CB  PHE    41      39.994  45.489  -1.080  1.00 16.48           C  
ATOM    348  CG  PHE    41      40.600  44.395  -0.260  1.00 16.72           C  
ATOM    349  CD1 PHE    41      40.213  44.206   1.066  1.00 16.36           C  
ATOM    350  CD2 PHE    41      41.607  43.599  -0.798  1.00 18.31           C  
ATOM    351  CE1 PHE    41      40.788  43.184   1.839  1.00 17.37           C  
ATOM    352  CE2 PHE    41      42.194  42.576  -0.035  1.00 17.66           C  
ATOM    353  CZ  PHE    41      41.779  42.378   1.287  1.00 17.32           C  
ATOM    354  N   LYS    42      37.973  47.118  -2.900  1.00 15.99           N  
ATOM    355  CA  LYS    42      37.278  48.329  -3.408  1.00 17.34           C  
ATOM    356  C   LYS    42      35.755  48.273  -3.244  1.00 17.57           C  
ATOM    357  O   LYS    42      35.146  49.256  -2.833  1.00 16.74           O  
ATOM    358  CB  LYS    42      37.634  48.638  -4.865  1.00 18.01           C  
ATOM    359  CG  LYS    42      39.093  49.050  -5.043  1.00 21.90           C  
ATOM    360  CD  LYS    42      39.416  49.194  -6.520  1.00 25.92           C  
ATOM    361  CE  LYS    42      40.607  50.124  -6.698  1.00 31.54           C  
ATOM    362  NZ  LYS    42      40.793  50.449  -8.144  1.00 35.78           N  
ATOM    363  N   GLN    43      35.141  47.130  -3.560  1.00 17.23           N  
ATOM    364  CA  GLN    43      33.689  46.988  -3.408  1.00 16.65           C  
ATOM    365  C   GLN    43      33.281  47.098  -1.934  1.00 16.50           C  
ATOM    366  O   GLN    43      32.313  47.778  -1.603  1.00 15.99           O  
ATOM    367  CB  GLN    43      33.204  45.648  -3.998  1.00 17.02           C  
ATOM    368  CG  GLN    43      33.434  45.511  -5.503  1.00 14.54           C  
ATOM    369  CD  GLN    43      33.179  44.106  -6.005  1.00 17.25           C  
ATOM    370  OE1 GLN    43      33.287  43.143  -5.240  1.00 15.36           O  
ATOM    371  NE2 GLN    43      32.798  43.981  -7.286  1.00 17.54           N  
ATOM    372  N   ALA    44      34.049  46.460  -1.053  1.00 17.00           N  
ATOM    373  CA  ALA    44      33.780  46.481   0.362  1.00 18.25           C  
ATOM    374  C   ALA    44      33.894  47.920   0.893  1.00 18.29           C  
ATOM    375  O   ALA    44      33.071  48.365   1.710  1.00 19.67           O  
ATOM    376  CB  ALA    44      34.726  45.538   1.082  1.00 18.12           C  
ATOM    377  N   ALA    45      34.879  48.659   0.370  1.00 18.75           N  
ATOM    378  CA  ALA    45      35.095  50.055   0.802  1.00 18.36           C  
ATOM    379  C   ALA    45      33.906  50.917   0.356  1.00 17.22           C  
ATOM    380  O   ALA    45      33.358  51.719   1.139  1.00 18.63           O  
ATOM    381  CB  ALA    45      36.430  50.601   0.207  1.00 18.25           C  
ATOM    382  N   ALA    46      33.485  50.718  -0.884  1.00 17.27           N  
ATOM    383  CA  ALA    46      32.370  51.440  -1.471  1.00 17.55           C  
ATOM    384  C   ALA    46      31.100  51.155  -0.685  1.00 18.90           C  
ATOM    385  O   ALA    46      30.296  52.059  -0.395  1.00 17.88           O  
ATOM    386  CB  ALA    46      32.196  51.040  -2.903  1.00 18.02           C  
ATOM    387  N   ALA    47      30.886  49.882  -0.369  1.00 17.73           N  
ATOM    388  CA  ALA    47      29.743  49.513   0.469  1.00 18.26           C  
ATOM    389  C   ALA    47      29.810  50.180   1.851  1.00 18.11           C  
ATOM    390  O   ALA    47      28.780  50.598   2.404  1.00 19.38           O  
ATOM    391  CB  ALA    47      29.686  47.977   0.621  1.00 18.48           C  
ATOM    392  N   GLY    48      31.011  50.248   2.408  1.00 18.17           N  
ATOM    393  CA  GLY    48      31.250  50.880   3.714  1.00 19.13           C  
ATOM    394  C   GLY    48      30.921  52.359   3.648  1.00 19.49           C  
ATOM    395  O   GLY    48      30.279  52.887   4.548  1.00 20.37           O  
ATOM    396  N   ILE    49      31.301  53.017   2.557  1.00 21.18           N  
ATOM    397  CA  ILE    49      30.955  54.451   2.406  1.00 21.55           C  
ATOM    398  C   ILE    49      29.445  54.633   2.232  1.00 21.40           C  
ATOM    399  O   ILE    49      28.849  55.497   2.891  1.00 20.53           O  
ATOM    400  CB  ILE    49      31.725  55.134   1.271  1.00 21.92           C  
ATOM    401  CG1 ILE    49      33.240  55.058   1.563  1.00 22.53           C  
ATOM    402  CG2 ILE    49      31.190  56.604   1.066  1.00 23.77           C  
ATOM    403  CD1 ILE    49      34.126  55.098   0.360  1.00 25.96           C  
ATOM    404  N   PHE    50      28.825  53.794   1.396  1.00 20.95           N  
ATOM    405  CA  PHE    50      27.381  53.811   1.189  1.00 20.87           C  
ATOM    406  C   PHE    50      26.614  53.701   2.519  1.00 20.75           C  
ATOM    407  O   PHE    50      25.611  54.421   2.729  1.00 20.09           O  
ATOM    408  CB  PHE    50      26.959  52.675   0.236  1.00 21.75           C  
ATOM    409  CG  PHE    50      25.505  52.713  -0.165  1.00 21.42           C  
ATOM    410  CD1 PHE    50      25.034  53.666  -1.070  1.00 23.70           C  
ATOM    411  CD2 PHE    50      24.615  51.769   0.344  1.00 22.52           C  
ATOM    412  CE1 PHE    50      23.685  53.701  -1.454  1.00 25.31           C  
ATOM    413  CE2 PHE    50      23.278  51.778  -0.020  1.00 20.38           C  
ATOM    414  CZ  PHE    50      22.794  52.747  -0.929  1.00 23.41           C  
ATOM    415  N   LEU    51      27.106  52.823   3.398  1.00 20.65           N  
ATOM    416  CA  LEU    51      26.477  52.528   4.707  1.00 20.31           C  
ATOM    417  C   LEU    51      26.994  53.347   5.909  1.00 20.94           C  
ATOM    418  O   LEU    51      26.689  53.035   7.074  1.00 20.47           O  
ATOM    419  CB  LEU    51      26.620  51.024   5.012  1.00 20.45           C  
ATOM    420  CG  LEU    51      26.018  50.029   4.002  1.00 18.73           C  
ATOM    421  CD1 LEU    51      26.516  48.571   4.293  1.00 17.74           C  
ATOM    422  CD2 LEU    51      24.503  50.071   4.006  1.00 18.95           C  
ATOM    423  N   ASN    52      27.776  54.391   5.646  1.00 22.08           N  
ATOM    424  CA  ASN    52      28.569  54.990   6.714  1.00 24.34           C  
ATOM    425  C   ASN    52      27.711  55.621   7.834  1.00 24.30           C  
ATOM    426  O   ASN    52      28.155  55.738   8.984  1.00 24.66           O  
ATOM    427  CB  ASN    52      29.517  56.037   6.111  1.00 25.39           C  
ATOM    428  CG  ASN    52      28.787  57.295   5.740  1.00 28.11           C  
ATOM    429  OD1 ASN    52      28.587  58.166   6.588  1.00 33.96           O  
ATOM    430  ND2 ASN    52      28.315  57.376   4.501  1.00 29.08           N  
ATOM    431  N   ASN    53      26.498  56.042   7.487  1.00 25.05           N  
ATOM    432  CA  ASN    53      25.632  56.715   8.469  1.00 25.92           C  
ATOM    433  C   ASN    53      24.488  55.833   8.952  1.00 25.06           C  
ATOM    434  O   ASN    53      23.578  56.317   9.638  1.00 25.23           O  
ATOM    435  CB  ASN    53      25.075  58.026   7.904  1.00 27.15           C  
ATOM    436  CG  ASN    53      24.652  58.988   9.000  1.00 30.53           C  
ATOM    437  OD1 ASN    53      25.455  59.349   9.865  1.00 36.72           O  
ATOM    438  ND2 ASN    53      23.382  59.389   8.986  1.00 34.91           N  
ATOM    439  N   VAL    54      24.521  54.547   8.585  1.00 23.11           N  
ATOM    440  CA  VAL    54      23.505  53.626   9.060  1.00 21.47           C  
ATOM    441  C   VAL    54      23.824  53.191  10.471  1.00 21.39           C  
ATOM    442  O   VAL    54      24.938  52.731  10.780  1.00 22.40           O  
ATOM    443  CB  VAL    54      23.363  52.343   8.167  1.00 20.54           C  
ATOM    444  CG1 VAL    54      22.303  51.405   8.775  1.00 20.21           C  
ATOM    445  CG2 VAL    54      22.991  52.714   6.759  1.00 20.99           C  
ATOM    446  N   LYS    55      22.832  53.303  11.339  1.00 21.50           N  
ATOM    447  CA  LYS    55      23.011  52.869  12.707  1.00 22.40           C  
ATOM    448  C   LYS    55      22.615  51.395  12.855  1.00 21.79           C  
ATOM    449  O   LYS    55      21.475  51.073  13.260  1.00 22.74           O  
ATOM    450  CB  LYS    55      22.190  53.741  13.659  1.00 23.17           C  
ATOM    451  CG  LYS    55      22.523  55.236  13.533  1.00 26.63           C  
ATOM    452  CD  LYS    55      22.200  55.945  14.829  1.00 32.13           C  
ATOM    453  CE  LYS    55      22.697  57.386  14.808  1.00 34.40           C  
ATOM    454  NZ  LYS    55      22.953  57.903  16.192  1.00 36.92           N  
ATOM    455  N   PHE    56      23.546  50.503  12.539  1.00 20.73           N  
ATOM    456  CA  PHE    56      23.337  49.078  12.823  1.00 19.15           C  
ATOM    457  C   PHE    56      23.510  48.812  14.304  1.00 19.61           C  
ATOM    458  O   PHE    56      24.285  49.504  15.000  1.00 21.15           O  
ATOM    459  CB  PHE    56      24.321  48.167  12.053  1.00 18.58           C  
ATOM    460  CG  PHE    56      24.172  48.230  10.567  1.00 17.80           C  
ATOM    461  CD1 PHE    56      23.018  47.719   9.935  1.00 14.64           C  
ATOM    462  CD2 PHE    56      25.183  48.753   9.779  1.00 16.61           C  
ATOM    463  CE1 PHE    56      22.881  47.789   8.533  1.00 14.77           C  
ATOM    464  CE2 PHE    56      25.061  48.793   8.381  1.00 16.45           C  
ATOM    465  CZ  PHE    56      23.904  48.324   7.749  1.00 14.90           C  
ATOM    466  N   THR    57      22.861  47.749  14.765  1.00 17.09           N  
ATOM    467  CA  THR    57      22.898  47.326  16.146  1.00 16.54           C  
ATOM    468  C   THR    57      23.611  45.992  16.347  1.00 16.67           C  
ATOM    469  O   THR    57      24.075  45.688  17.445  1.00 17.10           O  
ATOM    470  CB  THR    57      21.474  47.200  16.744  1.00 17.55           C  
ATOM    471  OG1 THR    57      20.692  46.278  15.957  1.00 14.51           O  
ATOM    472  CG2 THR    57      20.772  48.546  16.751  1.00 15.49           C  
ATOM    473  N   HIS    58      23.659  45.185  15.272  1.00 15.40           N  
ATOM    474  CA  HIS    58      24.258  43.857  15.350  1.00 14.88           C  
ATOM    475  C   HIS    58      24.974  43.589  14.027  1.00 14.04           C  
ATOM    476  O   HIS    58      24.557  44.082  12.977  1.00 13.96           O  
ATOM    477  CB  HIS    58      23.178  42.780  15.466  1.00 13.38           C  
ATOM    478  CG  HIS    58      22.385  42.839  16.735  1.00 14.77           C  
ATOM    479  ND1 HIS    58      21.409  43.785  16.961  1.00 15.83           N  
ATOM    480  CD2 HIS    58      22.419  42.059  17.838  1.00 15.46           C  
ATOM    481  CE1 HIS    58      20.892  43.595  18.164  1.00 17.07           C  
ATOM    482  NE2 HIS    58      21.460  42.535  18.700  1.00 15.53           N  
ATOM    483  N   ALA    59      26.044  42.806  14.100  1.00 13.04           N  
ATOM    484  CA  ALA    59      26.787  42.411  12.878  1.00 13.95           C  
ATOM    485  C   ALA    59      27.139  40.942  12.968  1.00 14.25           C  
ATOM    486  O   ALA    59      27.758  40.502  13.951  1.00 14.77           O  
ATOM    487  CB  ALA    59      28.058  43.213  12.703  1.00 14.18           C  
ATOM    488  N   PHE    60      26.778  40.185  11.930  1.00 12.96           N  
ATOM    489  CA  PHE    60      27.139  38.760  11.816  1.00 12.74           C  
ATOM    490  C   PHE    60      27.780  38.498  10.478  1.00 12.41           C  
ATOM    491  O   PHE    60      27.340  39.056   9.465  1.00 13.16           O  
ATOM    492  CB  PHE    60      25.911  37.831  11.919  1.00 13.31           C  
ATOM    493  CG  PHE    60      25.207  37.891  13.256  1.00 13.17           C  
ATOM    494  CD1 PHE    60      25.482  36.946  14.244  1.00 15.99           C  
ATOM    495  CD2 PHE    60      24.249  38.868  13.490  1.00 16.08           C  
ATOM    496  CE1 PHE    60      24.827  36.980  15.485  1.00 17.65           C  
ATOM    497  CE2 PHE    60      23.575  38.909  14.728  1.00 17.11           C  
ATOM    498  CZ  PHE    60      23.877  37.976  15.714  1.00 15.95           C  
ATOM    499  N   SER    61      28.775  37.602  10.451  1.00 11.13           N  
ATOM    500  CA  SER    61      29.467  37.297   9.202  1.00 12.21           C  
ATOM    501  C   SER    61      29.727  35.794   9.216  1.00 11.56           C  
ATOM    502  O   SER    61      29.983  35.205  10.263  1.00 12.53           O  
ATOM    503  CB  SER    61      30.800  38.071   9.126  1.00 11.54           C  
ATOM    504  OG  SER    61      31.557  37.684   7.995  1.00 14.79           O  
ATOM    505  N   SER    62      29.687  35.174   8.047  1.00 10.94           N  
ATOM    506  CA  SER    62      30.357  33.901   7.851  1.00 11.59           C  
ATOM    507  C   SER    62      31.798  33.973   8.360  1.00 11.84           C  
ATOM    508  O   SER    62      32.420  35.019   8.272  1.00 11.46           O  
ATOM    509  CB  SER    62      30.392  33.669   6.338  1.00 12.08           C  
ATOM    510  OG  SER    62      31.297  32.701   6.015  1.00 16.57           O  
ATOM    511  N   ASP    63      32.276  32.831   8.853  0.50 12.21           N  
ATOM    513  CA  ASP    63      33.641  32.659   9.378  0.50 13.48           C  
ATOM    515  C   ASP    63      34.594  32.183   8.266  0.50 13.52           C  
ATOM    517  O   ASP    63      35.392  31.242   8.442  0.50 13.40           O  
ATOM    519  CB  ASP    63      33.669  31.742  10.624  0.50 13.93           C  
ATOM    521  CG  ASP    63      33.182  30.313  10.355  0.50 14.36           C  
ATOM    523  OD1 ASP    63      32.267  30.105   9.530  0.50 10.93           O  
ATOM    525  OD2 ASP    63      33.724  29.377  10.988  0.50 15.00           O  
ATOM    527  N   LEU    64      34.455  32.830   7.104  1.00 14.85           N  
ATOM    528  CA  LEU    64      35.372  32.683   5.974  1.00 14.13           C  
ATOM    529  C   LEU    64      36.040  34.045   5.711  1.00 13.74           C  
ATOM    530  O   LEU    64      35.487  35.081   6.092  1.00 12.53           O  
ATOM    531  CB  LEU    64      34.610  32.144   4.735  1.00 14.06           C  
ATOM    532  CG  LEU    64      34.112  30.684   4.857  1.00 15.57           C  
ATOM    533  CD1 LEU    64      33.222  30.172   3.726  1.00 16.81           C  
ATOM    534  CD2 LEU    64      35.373  29.730   5.011  1.00 16.50           C  
ATOM    535  N   MET    65      37.244  34.054   5.120  1.00 13.80           N  
ATOM    536  CA  MET    65      37.997  35.312   4.978  1.00 14.27           C  
ATOM    537  C   MET    65      37.259  36.328   4.141  1.00 12.80           C  
ATOM    538  O   MET    65      37.249  37.513   4.483  1.00 12.68           O  
ATOM    539  CB  MET    65      39.344  35.088   4.268  1.00 14.39           C  
ATOM    540  CG  MET    65      40.368  34.551   5.151  1.00 19.40           C  
ATOM    541  SD  MET    65      42.061  34.816   4.234  1.00 17.57          SE  
ATOM    542  CE  MET    65      42.703  36.459   4.953  1.00 18.75           C  
ATOM    543  N   ARG    66      36.664  35.878   3.035  1.00 11.81           N  
ATOM    544  CA  ARG    66      36.066  36.820   2.071  1.00 11.30           C  
ATOM    545  C   ARG    66      34.928  37.632   2.693  1.00 12.24           C  
ATOM    546  O   ARG    66      34.802  38.856   2.479  1.00 11.93           O  
ATOM    547  CB  ARG    66      35.654  36.107   0.777  1.00 10.46           C  
ATOM    548  CG  ARG    66      34.682  34.894   0.959  1.00 10.29           C  
ATOM    549  CD  ARG    66      34.627  34.203  -0.373  1.00 12.79           C  
ATOM    550  NE  ARG    66      33.700  33.054  -0.470  1.00 11.27           N  
ATOM    551  CZ  ARG    66      33.988  31.816  -0.053  1.00 14.16           C  
ATOM    552  NH1 ARG    66      33.126  30.849  -0.290  1.00 12.57           N  
ATOM    553  NH2 ARG    66      35.111  31.536   0.612  1.00 11.25           N  
ATOM    554  N   THR    67      34.149  36.966   3.543  1.00 11.56           N  
ATOM    555  CA  THR    67      33.050  37.640   4.242  1.00 12.08           C  
ATOM    556  C   THR    67      33.622  38.488   5.417  1.00 11.63           C  
ATOM    557  O   THR    67      33.223  39.648   5.611  1.00 12.77           O  
ATOM    558  CB  THR    67      32.050  36.601   4.741  1.00 10.04           C  
ATOM    559  OG1 THR    67      32.796  35.490   5.240  1.00 12.29           O  
ATOM    560  CG2 THR    67      31.131  36.086   3.571  1.00 11.13           C  
ATOM    561  N   LYS    68      34.592  37.937   6.151  1.00 13.01           N  
ATOM    562  CA  LYS    68      35.199  38.673   7.299  1.00 13.10           C  
ATOM    563  C   LYS    68      35.821  40.001   6.795  1.00 11.78           C  
ATOM    564  O   LYS    68      35.613  41.042   7.377  1.00 11.93           O  
ATOM    565  CB  LYS    68      36.239  37.809   8.024  1.00 13.79           C  
ATOM    566  CG  LYS    68      37.010  38.545   9.119  1.00 16.70           C  
ATOM    567  CD  LYS    68      37.820  37.554   9.999  1.00 17.70           C  
ATOM    568  CE  LYS    68      38.271  38.243  11.310  1.00 22.84           C  
ATOM    569  NZ  LYS    68      38.987  37.265  12.187  1.00 25.71           N  
ATOM    570  N   GLN    69      36.578  39.925   5.702  1.00 11.45           N  
ATOM    571  CA  GLN    69      37.230  41.109   5.149  1.00 12.01           C  
ATOM    572  C   GLN    69      36.212  42.128   4.655  1.00 12.80           C  
ATOM    573  O   GLN    69      36.421  43.360   4.776  1.00 12.36           O  
ATOM    574  CB  GLN    69      38.143  40.690   4.024  1.00 11.90           C  
ATOM    575  CG  GLN    69      39.389  39.947   4.540  1.00 11.34           C  
ATOM    576  CD  GLN    69      40.288  39.535   3.414  1.00 14.07           C  
ATOM    577  OE1 GLN    69      39.807  39.100   2.363  1.00 12.32           O  
ATOM    578  NE2 GLN    69      41.613  39.608   3.639  1.00 15.02           N  
ATOM    579  N   THR    70      35.107  41.621   4.080  1.00 12.32           N  
ATOM    580  CA  THR    70      34.067  42.536   3.591  1.00 12.94           C  
ATOM    581  C   THR    70      33.409  43.288   4.778  1.00 12.24           C  
ATOM    582  O   THR    70      33.180  44.519   4.705  1.00 12.26           O  
ATOM    583  CB  THR    70      33.005  41.781   2.757  1.00 12.52           C  
ATOM    584  OG1 THR    70      33.657  41.176   1.623  1.00 12.51           O  
ATOM    585  CG2 THR    70      31.874  42.738   2.253  1.00 11.26           C  
ATOM    586  N   MET    71      33.076  42.532   5.819  1.00 12.95           N  
ATOM    587  CA  MET    71      32.513  43.084   7.054  1.00 14.04           C  
ATOM    588  C   MET    71      33.506  44.129   7.601  1.00 15.16           C  
ATOM    589  O   MET    71      33.100  45.209   8.015  1.00 14.69           O  
ATOM    590  CB  MET    71      32.311  42.000   8.084  1.00 14.72           C  
ATOM    591  CG  MET    71      31.741  42.503   9.416  1.00 16.03           C  
ATOM    592  SD  MET    71      30.009  43.366   9.266  1.00 12.53          SE  
ATOM    593  CE  MET    71      28.976  41.707   9.223  1.00 13.52           C  
ATOM    594  N   HIS    72      34.798  43.805   7.570  1.00 15.73           N  
ATOM    595  CA  HIS    72      35.798  44.765   8.079  1.00 17.92           C  
ATOM    596  C   HIS    72      35.799  46.068   7.279  1.00 18.23           C  
ATOM    597  O   HIS    72      35.806  47.170   7.877  1.00 18.65           O  
ATOM    598  CB  HIS    72      37.197  44.172   8.104  1.00 18.26           C  
ATOM    599  CG  HIS    72      38.231  45.134   8.616  1.00 22.21           C  
ATOM    600  ND1 HIS    72      38.329  45.480   9.946  1.00 26.17           N  
ATOM    601  CD2 HIS    72      39.186  45.851   7.968  1.00 26.64           C  
ATOM    602  CE1 HIS    72      39.323  46.337  10.106  1.00 25.60           C  
ATOM    603  NE2 HIS    72      39.856  46.583   8.920  1.00 28.23           N  
ATOM    604  N   GLY    73      35.786  45.922   5.950  1.00 17.64           N  
ATOM    605  CA  GLY    73      35.749  47.021   4.982  1.00 18.22           C  
ATOM    606  C   GLY    73      34.553  47.914   5.241  1.00 18.59           C  
ATOM    607  O   GLY    73      34.632  49.135   5.137  1.00 17.35           O  
ATOM    608  N   ILE    74      33.422  47.293   5.569  1.00 17.82           N  
ATOM    609  CA  ILE    74      32.208  48.049   5.833  1.00 18.14           C  
ATOM    610  C   ILE    74      32.322  48.766   7.168  1.00 19.12           C  
ATOM    611  O   ILE    74      32.124  49.976   7.216  1.00 20.75           O  
ATOM    612  CB  ILE    74      30.929  47.127   5.787  1.00 17.24           C  
ATOM    613  CG1 ILE    74      30.633  46.719   4.347  1.00 18.41           C  
ATOM    614  CG2 ILE    74      29.716  47.847   6.393  1.00 17.25           C  
ATOM    615  CD1 ILE    74      29.677  45.514   4.249  1.00 17.62           C  
ATOM    616  N   LEU    75      32.660  48.047   8.242  1.00 20.26           N  
ATOM    617  CA  LEU    75      32.654  48.660   9.584  1.00 20.39           C  
ATOM    618  C   LEU    75      33.748  49.711   9.784  1.00 21.93           C  
ATOM    619  O   LEU    75      33.506  50.723  10.442  1.00 21.81           O  
ATOM    620  CB  LEU    75      32.682  47.618  10.687  1.00 20.74           C  
ATOM    621  CG  LEU    75      31.457  46.705  10.768  1.00 18.86           C  
ATOM    622  CD1 LEU    75      31.706  45.688  11.869  1.00 20.32           C  
ATOM    623  CD2 LEU    75      30.175  47.516  10.991  1.00 20.37           C  
ATOM    624  N   GLU    76      34.907  49.519   9.165  1.00 22.34           N  
ATOM    625  CA  GLU    76      35.997  50.479   9.357  1.00 25.10           C  
ATOM    626  C   GLU    76      35.621  51.889   8.865  1.00 25.23           C  
ATOM    627  O   GLU    76      36.219  52.863   9.314  1.00 26.75           O  
ATOM    628  CB  GLU    76      37.318  49.973   8.753  1.00 24.36           C  
ATOM    629  CG  GLU    76      37.476  50.167   7.255  1.00 25.72           C  
ATOM    630  CD  GLU    76      38.694  49.424   6.693  1.00 27.22           C  
ATOM    631  OE1 GLU    76      39.583  49.024   7.479  1.00 30.93           O  
ATOM    632  OE2 GLU    76      38.774  49.240   5.461  1.00 32.26           O  
ATOM    633  N   ARG    77      34.624  51.982   7.977  1.00 25.58           N  
ATOM    634  CA  ARG    77      34.132  53.257   7.427  1.00 26.51           C  
ATOM    635  C   ARG    77      32.831  53.782   8.025  1.00 26.65           C  
ATOM    636  O   ARG    77      32.262  54.749   7.501  1.00 26.66           O  
ATOM    637  CB  ARG    77      33.949  53.141   5.920  1.00 26.38           C  
ATOM    638  CG  ARG    77      35.290  53.011   5.227  1.00 27.67           C  
ATOM    639  CD  ARG    77      35.178  52.485   3.846  1.00 30.97           C  
ATOM    640  NE  ARG    77      36.510  52.433   3.255  1.00 30.98           N  
ATOM    641  CZ  ARG    77      37.312  51.372   3.292  1.00 35.20           C  
ATOM    642  NH1 ARG    77      38.520  51.454   2.715  1.00 36.34           N  
ATOM    643  NH2 ARG    77      36.910  50.228   3.875  1.00 28.89           N  
ATOM    644  N   SER    78      32.357  53.130   9.079  1.00 26.15           N  
ATOM    645  CA  SER    78      31.086  53.486   9.669  1.00 27.03           C  
ATOM    646  C   SER    78      31.300  54.636  10.634  1.00 27.68           C  
ATOM    647  O   SER    78      32.276  54.646  11.391  1.00 27.16           O  
ATOM    648  CB  SER    78      30.468  52.308  10.416  1.00 26.71           C  
ATOM    649  OG  SER    78      29.259  52.707  11.068  1.00 26.27           O  
ATOM    650  N   LYS    79      30.379  55.591  10.600  1.00 29.19           N  
ATOM    651  CA  LYS    79      30.364  56.674  11.605  1.00 30.36           C  
ATOM    652  C   LYS    79      30.015  56.189  13.025  1.00 30.63           C  
ATOM    653  O   LYS    79      30.639  56.613  14.014  1.00 30.77           O  
ATOM    654  CB  LYS    79      29.411  57.772  11.163  1.00 30.35           C  
ATOM    655  CG  LYS    79      29.804  58.387   9.823  1.00 34.19           C  
ATOM    656  CD  LYS    79      28.840  59.478   9.389  1.00 38.11           C  
ATOM    657  CE  LYS    79      29.545  60.497   8.510  1.00 41.68           C  
ATOM    658  NZ  LYS    79      30.320  59.884   7.374  1.00 44.79           N  
ATOM    659  N   PHE    80      29.039  55.283  13.132  1.00 30.30           N  
ATOM    660  CA  PHE    80      28.579  54.815  14.441  1.00 29.95           C  
ATOM    661  C   PHE    80      29.020  53.438  14.871  1.00 29.66           C  
ATOM    662  O   PHE    80      29.052  53.163  16.069  1.00 29.18           O  
ATOM    663  CB  PHE    80      27.053  54.898  14.522  1.00 31.44           C  
ATOM    664  CG  PHE    80      26.530  56.235  14.154  1.00 34.11           C  
ATOM    665  CD1 PHE    80      26.564  57.278  15.077  1.00 37.99           C  
ATOM    666  CD2 PHE    80      26.056  56.478  12.874  1.00 35.72           C  
ATOM    667  CE1 PHE    80      26.106  58.537  14.729  1.00 38.23           C  
ATOM    668  CE2 PHE    80      25.597  57.722  12.519  1.00 39.19           C  
ATOM    669  CZ  PHE    80      25.623  58.758  13.446  1.00 38.01           C  
ATOM    670  N   CYS    81      29.366  52.575  13.910  1.00 28.01           N  
ATOM    671  CA  CYS    81      29.606  51.158  14.197  1.00 27.84           C  
ATOM    672  C   CYS    81      31.044  50.686  13.981  1.00 27.70           C  
ATOM    673  O   CYS    81      31.309  49.485  14.007  1.00 26.84           O  
ATOM    674  CB  CYS    81      28.645  50.276  13.398  1.00 27.28           C  
ATOM    675  SG  CYS    81      26.920  50.779  13.612  1.00 28.89           S  
ATOM    676  N   LYS    82      31.985  51.617  13.832  1.00 27.45           N  
ATOM    677  CA  LYS    82      33.403  51.222  13.766  1.00 28.50           C  
ATOM    678  C   LYS    82      33.834  50.144  14.796  1.00 27.82           C  
ATOM    679  O   LYS    82      34.547  49.182  14.454  1.00 28.25           O  
ATOM    680  CB  LYS    82      34.281  52.465  13.927  1.00 28.86           C  
ATOM    681  CG  LYS    82      35.101  52.816  12.713  1.00 32.47           C  
ATOM    682  CD  LYS    82      36.212  53.785  13.150  1.00 36.51           C  
ATOM    683  CE  LYS    82      37.407  53.769  12.213  1.00 39.21           C  
ATOM    684  NZ  LYS    82      38.422  54.834  12.584  1.00 41.30           N  
ATOM    685  N   ASP    83      33.375  50.304  16.039  1.00 27.50           N  
ATOM    686  CA  ASP    83      33.775  49.512  17.197  1.00 28.02           C  
ATOM    687  C   ASP    83      32.878  48.306  17.488  1.00 27.52           C  
ATOM    688  O   ASP    83      33.135  47.570  18.441  1.00 26.64           O  
ATOM    689  CB  ASP    83      33.731  50.395  18.458  1.00 29.41           C  
ATOM    690  CG  ASP    83      35.074  50.979  18.833  1.00 33.35           C  
ATOM    691  OD1 ASP    83      36.018  50.982  18.002  1.00 37.87           O  
ATOM    692  OD2 ASP    83      35.171  51.465  19.991  1.00 39.80           O  
ATOM    693  N   MET    84      31.827  48.123  16.684  1.00 27.33           N  
ATOM    694  CA  MET    84      30.888  47.015  16.853  1.00 27.36           C  
ATOM    695  C   MET    84      31.554  45.635  16.835  1.00 26.64           C  
ATOM    696  O   MET    84      32.397  45.363  15.972  1.00 26.44           O  
ATOM    697  CB  MET    84      29.828  47.074  15.754  1.00 27.33           C  
ATOM    698  CG  MET    84      28.843  45.919  15.820  1.00 29.83           C  
ATOM    699  SD  MET    84      27.184  46.452  15.025  1.00 28.68          SE  
ATOM    700  CE  MET    84      26.622  47.647  16.472  1.00 31.10           C  
ATOM    701  N   THR    85      31.151  44.771  17.770  1.00 25.42           N  
ATOM    702  CA  THR    85      31.643  43.400  17.829  1.00 25.35           C  
ATOM    703  C   THR    85      30.957  42.626  16.710  1.00 23.90           C  
ATOM    704  O   THR    85      29.733  42.626  16.620  1.00 25.42           O  
ATOM    705  CB  THR    85      31.307  42.725  19.175  1.00 26.00           C  
ATOM    706  OG1 THR    85      31.981  43.414  20.236  1.00 30.50           O  
ATOM    707  CG2 THR    85      31.750  41.256  19.191  1.00 26.88           C  
ATOM    708  N   VAL    86      31.747  41.998  15.858  1.00 21.60           N  
ATOM    709  CA  VAL    86      31.200  41.111  14.828  1.00 20.01           C  
ATOM    710  C   VAL    86      31.084  39.709  15.396  1.00 19.18           C  
ATOM    711  O   VAL    86      32.048  39.192  15.994  1.00 18.56           O  
ATOM    712  CB  VAL    86      32.133  41.078  13.584  1.00 19.70           C  
ATOM    713  CG1 VAL    86      31.600  40.066  12.497  1.00 19.54           C  
ATOM    714  CG2 VAL    86      32.330  42.463  13.026  1.00 19.51           C  
ATOM    715  N   LYS    87      29.931  39.060  15.205  1.00 18.68           N  
ATOM    716  CA  LYS    87      29.822  37.655  15.569  1.00 18.36           C  
ATOM    717  C   LYS    87      30.030  36.774  14.329  1.00 18.76           C  
ATOM    718  O   LYS    87      29.404  37.017  13.300  1.00 17.89           O  
ATOM    719  CB  LYS    87      28.465  37.363  16.219  1.00 20.32           C  
ATOM    720  CG  LYS    87      28.207  38.121  17.539  1.00 23.26           C  
ATOM    721  CD  LYS    87      28.881  37.441  18.727  1.00 29.51           C  
ATOM    722  CE  LYS    87      28.862  38.306  20.018  1.00 29.46           C  
ATOM    723  NZ  LYS    87      27.499  38.859  20.350  1.00 34.69           N  
ATOM    724  N   TYR    88      30.908  35.778  14.414  1.00 17.24           N  
ATOM    725  CA  TYR    88      31.205  34.925  13.245  1.00 17.08           C  
ATOM    726  C   TYR    88      30.472  33.634  13.446  1.00 17.77           C  
ATOM    727  O   TYR    88      30.595  33.005  14.519  1.00 19.09           O  
ATOM    728  CB  TYR    88      32.723  34.681  13.083  1.00 16.63           C  
ATOM    729  CG  TYR    88      33.416  35.982  12.807  1.00 16.87           C  
ATOM    730  CD1 TYR    88      33.417  36.518  11.521  1.00 15.13           C  
ATOM    731  CD2 TYR    88      33.947  36.751  13.855  1.00 19.18           C  
ATOM    732  CE1 TYR    88      33.996  37.748  11.259  1.00 16.39           C  
ATOM    733  CE2 TYR    88      34.524  37.980  13.606  1.00 16.91           C  
ATOM    734  CZ  TYR    88      34.548  38.461  12.314  1.00 18.38           C  
ATOM    735  OH  TYR    88      35.119  39.660  12.080  1.00 18.80           O  
ATOM    736  N   ASP    89      29.706  33.225  12.429  1.00 15.32           N  
ATOM    737  CA  ASP    89      28.752  32.138  12.598  1.00 14.95           C  
ATOM    738  C   ASP    89      28.880  31.221  11.400  1.00 14.21           C  
ATOM    739  O   ASP    89      28.637  31.632  10.269  1.00 13.18           O  
ATOM    740  CB  ASP    89      27.320  32.705  12.754  1.00 13.62           C  
ATOM    741  CG  ASP    89      26.326  31.703  13.309  1.00 17.57           C  
ATOM    742  OD1 ASP    89      26.216  30.557  12.790  1.00 16.56           O  
ATOM    743  OD2 ASP    89      25.635  32.056  14.296  1.00 18.76           O  
ATOM    744  N   SER    90      29.255  29.979  11.660  1.00 13.24           N  
ATOM    745  CA  SER    90      29.434  28.988  10.594  1.00 13.21           C  
ATOM    746  C   SER    90      28.127  28.694   9.846  1.00 12.15           C  
ATOM    747  O   SER    90      28.166  28.199   8.726  1.00 12.17           O  
ATOM    748  CB  SER    90      30.017  27.664  11.149  1.00 14.65           C  
ATOM    749  OG  SER    90      29.081  27.013  11.999  1.00 16.86           O  
ATOM    750  N   ARG    91      26.978  28.922  10.475  1.00 11.21           N  
ATOM    751  CA  ARG    91      25.693  28.726   9.753  1.00 11.52           C  
ATOM    752  C   ARG    91      25.545  29.632   8.523  1.00 10.85           C  
ATOM    753  O   ARG    91      24.752  29.346   7.617  1.00 11.71           O  
ATOM    754  CB  ARG    91      24.487  28.872  10.673  1.00 10.94           C  
ATOM    755  CG  ARG    91      24.441  27.792  11.768  1.00 13.03           C  
ATOM    756  CD  ARG    91      23.351  28.149  12.747  1.00 15.77           C  
ATOM    757  NE  ARG    91      23.786  29.244  13.608  1.00 15.09           N  
ATOM    758  CZ  ARG    91      23.191  29.560  14.752  1.00 17.43           C  
ATOM    759  NH1 ARG    91      22.113  28.881  15.146  1.00 16.56           N  
ATOM    760  NH2 ARG    91      23.653  30.574  15.469  1.00 16.42           N  
ATOM    761  N   LEU    92      26.309  30.720   8.483  1.00 10.05           N  
ATOM    762  CA  LEU    92      26.264  31.669   7.370  1.00 10.24           C  
ATOM    763  C   LEU    92      27.184  31.304   6.192  1.00 10.17           C  
ATOM    764  O   LEU    92      27.289  32.071   5.230  1.00  9.19           O  
ATOM    765  CB  LEU    92      26.659  33.064   7.888  1.00 10.64           C  
ATOM    766  CG  LEU    92      25.647  33.620   8.896  1.00  7.81           C  
ATOM    767  CD1 LEU    92      26.151  34.998   9.449  1.00  9.51           C  
ATOM    768  CD2 LEU    92      24.265  33.840   8.216  1.00  9.67           C  
ATOM    769  N   ARG    93      27.896  30.172   6.322  1.00  9.79           N  
ATOM    770  CA  ARG    93      28.920  29.832   5.307  0.50 10.74           C  
ATOM    772  C   ARG    93      28.293  29.473   3.946  1.00 10.23           C  
ATOM    773  O   ARG    93      27.130  29.136   3.852  1.00  9.45           O  
ATOM    774  CB  ARG    93      29.871  28.723   5.810  0.50 10.99           C  
ATOM    776  CG  ARG    93      30.830  29.182   6.953  0.50 10.53           C  
ATOM    778  CD  ARG    93      31.618  28.043   7.722  0.50 13.00           C  
ATOM    780  NE  ARG    93      32.947  27.783   7.170  0.50 16.63           N  
ATOM    782  CZ  ARG    93      33.539  26.581   7.087  0.50 18.09           C  
ATOM    784  NH1 ARG    93      34.723  26.475   6.518  0.50 20.66           N  
ATOM    786  NH2 ARG    93      32.953  25.481   7.538  0.50 21.05           N  
ATOM    788  N   GLU    94      29.087  29.574   2.874  1.00  9.81           N  
ATOM    789  CA  GLU    94      28.566  29.225   1.559  1.00  9.24           C  
ATOM    790  C   GLU    94      28.222  27.720   1.486  1.00  8.74           C  
ATOM    791  O   GLU    94      28.737  26.905   2.264  1.00 10.34           O  
ATOM    792  CB  GLU    94      29.576  29.564   0.464  1.00 11.27           C  
ATOM    793  CG  GLU    94      29.088  29.349  -0.995  1.00 12.74           C  
ATOM    794  CD  GLU    94      27.785  30.006  -1.403  1.00 10.47           C  
ATOM    795  OE1 GLU    94      26.737  29.737  -0.779  1.00 14.15           O  
ATOM    796  OE2 GLU    94      27.760  30.741  -2.438  1.00 16.89           O  
ATOM    797  N   ARG    95      27.340  27.399   0.548  1.00  9.78           N  
ATOM    798  CA  ARG    95      27.030  25.998   0.196  1.00  9.41           C  
ATOM    799  C   ARG    95      28.352  25.240  -0.046  1.00 10.34           C  
ATOM    800  O   ARG    95      29.275  25.768  -0.680  1.00 10.97           O  
ATOM    801  CB  ARG    95      26.208  26.018  -1.105  1.00 10.13           C  
ATOM    802  CG  ARG    95      25.946  24.628  -1.684  1.00 11.28           C  
ATOM    803  CD  ARG    95      24.903  24.690  -2.839  1.00 10.27           C  
ATOM    804  NE  ARG    95      24.391  23.349  -3.179  1.00 11.61           N  
ATOM    805  CZ  ARG    95      23.752  23.052  -4.310  1.00 14.85           C  
ATOM    806  NH1 ARG    95      23.582  23.987  -5.240  1.00 13.49           N  
ATOM    807  NH2 ARG    95      23.327  21.791  -4.534  1.00 15.15           N  
ATOM    808  N   LYS    96      28.445  24.020   0.483  1.00 10.77           N  
ATOM    809  CA  LYS    96      29.595  23.136   0.192  1.00 11.17           C  
ATOM    810  C   LYS    96      29.486  22.581  -1.218  1.00 10.95           C  
ATOM    811  O   LYS    96      28.428  22.118  -1.598  1.00 10.65           O  
ATOM    812  CB  LYS    96      29.583  21.978   1.171  1.00 11.63           C  
ATOM    813  CG  LYS    96      30.032  22.318   2.529  1.00 13.62           C  
ATOM    814  CD  LYS    96      29.955  21.039   3.375  1.00 16.90           C  
ATOM    815  CE  LYS    96      30.787  21.227   4.642  1.00 21.22           C  
ATOM    816  NZ  LYS    96      30.972  19.848   5.295  1.00 27.76           N  
ATOM    817  N   TYR    97      30.603  22.551  -1.955  1.00 11.30           N  
ATOM    818  CA  TYR    97      30.624  21.926  -3.290  1.00 12.22           C  
ATOM    819  C   TYR    97      31.571  20.706  -3.360  1.00 11.94           C  
ATOM    820  O   TYR    97      31.841  20.166  -4.447  1.00 12.35           O  
ATOM    821  CB  TYR    97      31.000  22.967  -4.355  1.00 13.04           C  
ATOM    822  CG  TYR    97      29.936  24.034  -4.515  1.00 14.72           C  
ATOM    823  CD1 TYR    97      28.774  23.798  -5.274  1.00 14.38           C  
ATOM    824  CD2 TYR    97      30.088  25.270  -3.896  1.00 15.43           C  
ATOM    825  CE1 TYR    97      27.810  24.791  -5.393  1.00 14.73           C  
ATOM    826  CE2 TYR    97      29.122  26.262  -4.010  1.00 12.53           C  
ATOM    827  CZ  TYR    97      27.999  26.014  -4.720  1.00 14.34           C  
ATOM    828  OH  TYR    97      27.092  27.032  -4.827  1.00 16.25           O  
ATOM    829  N   GLY    98      32.089  20.291  -2.206  1.00 11.77           N  
ATOM    830  CA  GLY    98      32.826  19.036  -2.111  1.00 12.24           C  
ATOM    831  C   GLY    98      33.949  18.921  -3.124  1.00 11.83           C  
ATOM    832  O   GLY    98      34.843  19.794  -3.224  1.00 11.40           O  
ATOM    833  N   VAL    99      33.936  17.809  -3.851  1.00 12.50           N  
ATOM    834  CA  VAL    99      35.079  17.516  -4.759  1.00 12.04           C  
ATOM    835  C   VAL    99      35.247  18.503  -5.926  1.00 13.67           C  
ATOM    836  O   VAL    99      36.288  18.456  -6.634  1.00 14.68           O  
ATOM    837  CB  VAL    99      34.966  16.107  -5.330  1.00 12.48           C  
ATOM    838  CG1 VAL    99      34.952  15.066  -4.205  1.00 11.02           C  
ATOM    839  CG2 VAL    99      33.676  16.004  -6.206  1.00 10.02           C  
ATOM    840  N   VAL   100      34.243  19.356  -6.190  1.00 13.11           N  
ATOM    841  CA  VAL   100      34.429  20.384  -7.258  1.00 14.81           C  
ATOM    842  C   VAL   100      34.881  21.755  -6.749  1.00 14.74           C  
ATOM    843  O   VAL   100      35.011  22.702  -7.539  1.00 14.67           O  
ATOM    844  CB  VAL   100      33.220  20.532  -8.215  1.00 15.29           C  
ATOM    845  CG1 VAL   100      32.946  19.211  -8.916  1.00 19.59           C  
ATOM    846  CG2 VAL   100      32.006  20.981  -7.464  1.00 14.33           C  
ATOM    847  N   GLU   101      35.136  21.874  -5.446  1.00 14.02           N  
ATOM    848  CA  GLU   101      35.714  23.106  -4.924  1.00 14.89           C  
ATOM    849  C   GLU   101      37.010  23.377  -5.661  1.00 16.00           C  
ATOM    850  O   GLU   101      37.861  22.484  -5.742  1.00 16.46           O  
ATOM    851  CB  GLU   101      36.007  22.975  -3.420  1.00 15.96           C  
ATOM    852  CG  GLU   101      34.792  22.693  -2.590  1.00 18.68           C  
ATOM    853  CD  GLU   101      34.050  23.919  -2.181  1.00 21.81           C  
ATOM    854  OE1 GLU   101      34.382  25.012  -2.728  1.00 23.06           O  
ATOM    855  OE2 GLU   101      33.145  23.767  -1.300  1.00 19.19           O  
ATOM    856  N   GLY   102      37.147  24.585  -6.197  1.00 16.89           N  
ATOM    857  CA  GLY   102      38.361  24.997  -6.908  1.00 18.62           C  
ATOM    858  C   GLY   102      38.395  24.590  -8.367  1.00 19.14           C  
ATOM    859  O   GLY   102      39.412  24.832  -9.049  1.00 20.07           O  
ATOM    860  N   LYS   103      37.291  24.032  -8.876  1.00 18.98           N  
ATOM    861  CA  LYS   103      37.197  23.699 -10.299  1.00 20.92           C  
ATOM    862  C   LYS   103      36.380  24.757 -11.029  1.00 21.03           C  
ATOM    863  O   LYS   103      35.632  25.519 -10.411  1.00 20.19           O  
ATOM    864  CB  LYS   103      36.570  22.310 -10.518  1.00 20.50           C  
ATOM    865  CG  LYS   103      37.190  21.159  -9.715  1.00 22.86           C  
ATOM    866  CD  LYS   103      38.507  20.669 -10.290  1.00 23.45           C  
ATOM    867  CE  LYS   103      38.950  19.375  -9.614  1.00 23.50           C  
ATOM    868  NZ  LYS   103      40.298  18.991 -10.102  1.00 25.68           N  
ATOM    869  N   ALA   104      36.531  24.809 -12.356  1.00 22.14           N  
ATOM    870  CA  ALA   104      35.691  25.672 -13.175  1.00 23.68           C  
ATOM    871  C   ALA   104      34.233  25.281 -13.011  1.00 24.89           C  
ATOM    872  O   ALA   104      33.888  24.084 -12.896  1.00 23.99           O  
ATOM    873  CB  ALA   104      36.097  25.574 -14.678  1.00 24.14           C  
ATOM    874  N   LEU   105      33.380  26.298 -12.996  1.00 27.07           N  
ATOM    875  CA  LEU   105      31.931  26.103 -13.087  1.00 28.87           C  
ATOM    876  C   LEU   105      31.530  25.061 -14.143  1.00 29.02           C  
ATOM    877  O   LEU   105      30.664  24.232 -13.898  1.00 29.23           O  
ATOM    878  CB  LEU   105      31.257  27.442 -13.362  1.00 29.23           C  
ATOM    879  CG  LEU   105      29.755  27.479 -13.668  1.00 31.02           C  
ATOM    880  CD1 LEU   105      28.907  27.141 -12.425  1.00 32.77           C  
ATOM    881  CD2 LEU   105      29.399  28.852 -14.209  1.00 30.51           C  
ATOM    882  N   SER   106      32.178  25.086 -15.307  1.00 29.91           N  
ATOM    883  CA  SER   106      31.881  24.149 -16.387  1.00 29.14           C  
ATOM    884  C   SER   106      32.051  22.681 -15.998  1.00 29.11           C  
ATOM    885  O   SER   106      31.355  21.822 -16.527  1.00 29.44           O  
ATOM    886  CB  SER   106      32.728  24.472 -17.622  1.00 29.72           C  
ATOM    887  OG  SER   106      34.098  24.225 -17.361  1.00 30.00           O  
ATOM    888  N   GLU   107      32.982  22.398 -15.080  1.00 27.75           N  
ATOM    889  CA  GLU   107      33.183  21.041 -14.562  1.00 27.48           C  
ATOM    890  C   GLU   107      32.013  20.561 -13.714  1.00 26.29           C  
ATOM    891  O   GLU   107      31.682  19.367 -13.708  1.00 25.83           O  
ATOM    892  CB  GLU   107      34.431  20.982 -13.697  1.00 27.28           C  
ATOM    893  CG  GLU   107      35.726  20.925 -14.471  1.00 31.09           C  
ATOM    894  CD  GLU   107      36.761  20.054 -13.765  1.00 34.47           C  
ATOM    895  OE1 GLU   107      36.413  18.951 -13.265  1.00 39.28           O  
ATOM    896  OE2 GLU   107      37.930  20.465 -13.731  1.00 36.57           O  
ATOM    897  N   LEU   108      31.437  21.482 -12.953  1.00 24.91           N  
ATOM    898  CA  LEU   108      30.246  21.168 -12.154  1.00 24.54           C  
ATOM    899  C   LEU   108      29.064  20.903 -13.085  1.00 24.38           C  
ATOM    900  O   LEU   108      28.318  19.949 -12.900  1.00 23.94           O  
ATOM    901  CB  LEU   108      29.924  22.317 -11.200  1.00 23.85           C  
ATOM    902  CG  LEU   108      28.633  22.283 -10.366  1.00 24.31           C  
ATOM    903  CD1 LEU   108      28.572  21.058  -9.475  1.00 24.85           C  
ATOM    904  CD2 LEU   108      28.493  23.548  -9.560  1.00 25.05           C  
ATOM    905  N   ARG   109      28.905  21.759 -14.093  1.00 24.69           N  
ATOM    906  CA  ARG   109      27.797  21.593 -15.046  1.00 25.81           C  
ATOM    907  C   ARG   109      27.927  20.267 -15.799  1.00 25.60           C  
ATOM    908  O   ARG   109      26.936  19.578 -16.013  1.00 25.88           O  
ATOM    909  CB  ARG   109      27.722  22.778 -16.012  1.00 26.38           C  
ATOM    910  CG  ARG   109      27.505  24.090 -15.295  1.00 29.70           C  
ATOM    911  CD  ARG   109      26.671  25.027 -16.096  1.00 37.60           C  
ATOM    912  NE  ARG   109      26.665  26.367 -15.512  1.00 43.01           N  
ATOM    913  CZ  ARG   109      26.248  27.449 -16.166  1.00 45.11           C  
ATOM    914  NH1 ARG   109      25.796  27.329 -17.408  1.00 47.16           N  
ATOM    915  NH2 ARG   109      26.277  28.645 -15.585  1.00 47.45           N  
ATOM    916  N   ALA   110      29.155  19.917 -16.190  1.00 25.45           N  
ATOM    917  CA  ALA   110      29.412  18.652 -16.891  1.00 25.48           C  
ATOM    918  C   ALA   110      29.078  17.447 -16.012  1.00 25.62           C  
ATOM    919  O   ALA   110      28.485  16.465 -16.476  1.00 25.86           O  
ATOM    920  CB  ALA   110      30.848  18.593 -17.374  1.00 25.39           C  
ATOM    921  N   MET   111      29.438  17.540 -14.729  1.00 24.85           N  
ATOM    922  CA  MET   111      29.117  16.514 -13.757  0.50 23.26           C  
ATOM    924  C   MET   111      27.592  16.359 -13.584  1.00 24.91           C  
ATOM    925  O   MET   111      27.085  15.230 -13.477  1.00 24.74           O  
ATOM    926  CB  MET   111      29.815  16.828 -12.422  0.50 23.59           C  
ATOM    928  CG  MET   111      30.092  15.611 -11.579  0.50 20.75           C  
ATOM    930  SD  MET   111      30.883  16.032  -9.843  0.50 18.95          SE  
ATOM    932  CE  MET   111      32.747  15.837 -10.220  0.50 15.17           C  
ATOM    934  N   ALA   112      26.884  17.494 -13.540  1.00 25.44           N  
ATOM    935  CA  ALA   112      25.427  17.512 -13.439  1.00 26.76           C  
ATOM    936  C   ALA   112      24.818  16.790 -14.647  1.00 27.56           C  
ATOM    937  O   ALA   112      24.077  15.821 -14.486  1.00 27.10           O  
ATOM    938  CB  ALA   112      24.911  18.932 -13.376  1.00 26.49           C  
ATOM    939  N   LYS   113      25.139  17.300 -15.834  1.00 29.94           N  
ATOM    940  CA  LYS   113      24.723  16.725 -17.128  1.00 31.32           C  
ATOM    941  C   LYS   113      24.909  15.206 -17.140  1.00 31.81           C  
ATOM    942  O   LYS   113      23.985  14.460 -17.480  1.00 32.12           O  
ATOM    943  CB  LYS   113      25.496  17.434 -18.269  1.00 32.12           C  
ATOM    944  CG  LYS   113      25.539  16.786 -19.681  1.00 32.56           C  
ATOM    945  CD  LYS   113      24.177  16.663 -20.371  1.00 37.78           C  
ATOM    946  CE  LYS   113      24.235  15.605 -21.499  1.00 38.53           C  
ATOM    947  NZ  LYS   113      22.973  14.790 -21.585  1.00 41.24           N  
ATOM    948  N   ALA   114      26.094  14.753 -16.737  1.00 32.76           N  
ATOM    949  CA  ALA   114      26.410  13.322 -16.690  1.00 33.68           C  
ATOM    950  C   ALA   114      25.518  12.546 -15.725  1.00 34.47           C  
ATOM    951  O   ALA   114      25.190  11.380 -15.980  1.00 34.78           O  
ATOM    952  CB  ALA   114      27.859  13.111 -16.338  1.00 33.77           C  
ATOM    953  N   ALA   115      25.130  13.181 -14.617  1.00 34.82           N  
ATOM    954  CA  ALA   115      24.253  12.533 -13.633  1.00 35.21           C  
ATOM    955  C   ALA   115      22.772  12.575 -14.030  1.00 35.51           C  
ATOM    956  O   ALA   115      21.914  12.092 -13.291  1.00 35.77           O  
ATOM    957  CB  ALA   115      24.458  13.149 -12.245  1.00 35.54           C  
ATOM    958  N   ARG   116      22.485  13.151 -15.197  1.00 35.81           N  
ATOM    959  CA  ARG   116      21.116  13.413 -15.664  1.00 36.57           C  
ATOM    960  C   ARG   116      20.358  14.336 -14.703  1.00 35.96           C  
ATOM    961  O   ARG   116      19.173  14.146 -14.421  1.00 35.58           O  
ATOM    962  CB  ARG   116      20.351  12.109 -15.954  1.00 36.76           C  
ATOM    963  CG  ARG   116      20.943  11.282 -17.109  1.00 38.35           C  
ATOM    964  CD  ARG   116      19.941  10.231 -17.616  1.00 39.16           C  
ATOM    965  NE  ARG   116      18.865  10.833 -18.415  1.00 45.58           N  
ATOM    966  CZ  ARG   116      18.722  10.692 -19.735  1.00 47.21           C  
ATOM    967  NH1 ARG   116      17.713  11.292 -20.360  1.00 48.53           N  
ATOM    968  NH2 ARG   116      19.577   9.950 -20.436  1.00 47.82           N  
ATOM    969  N   GLU   117      21.074  15.339 -14.198  1.00 35.11           N  
ATOM    970  CA  GLU   117      20.493  16.359 -13.344  1.00 34.78           C  
ATOM    971  C   GLU   117      20.925  17.749 -13.819  1.00 33.72           C  
ATOM    972  O   GLU   117      21.735  17.874 -14.752  1.00 33.94           O  
ATOM    973  CB  GLU   117      20.900  16.117 -11.888  1.00 34.37           C  
ATOM    974  CG  GLU   117      20.427  14.774 -11.341  1.00 35.31           C  
ATOM    975  CD  GLU   117      20.919  14.515  -9.929  1.00 36.02           C  
ATOM    976  OE1 GLU   117      21.039  15.488  -9.157  1.00 35.32           O  
ATOM    977  OE2 GLU   117      21.184  13.339  -9.586  1.00 39.92           O  
ATOM    978  N   GLU   118      20.361  18.785 -13.204  1.00 32.71           N  
ATOM    979  CA  GLU   118      20.663  20.176 -13.569  1.00 32.59           C  
ATOM    980  C   GLU   118      21.165  20.955 -12.355  1.00 30.03           C  
ATOM    981  O   GLU   118      20.750  20.663 -11.221  1.00 28.44           O  
ATOM    982  CB  GLU   118      19.410  20.892 -14.056  1.00 32.85           C  
ATOM    983  CG  GLU   118      18.594  20.155 -15.100  1.00 35.90           C  
ATOM    984  CD  GLU   118      17.471  21.020 -15.648  1.00 36.89           C  
ATOM    985  OE1 GLU   118      16.623  21.507 -14.845  1.00 42.48           O  
ATOM    986  OE2 GLU   118      17.447  21.218 -16.887  1.00 42.19           O  
ATOM    987  N   CYS   119      22.027  21.946 -12.614  1.00 28.23           N  
ATOM    988  CA  CYS   119      22.452  22.914 -11.593  1.00 26.98           C  
ATOM    989  C   CYS   119      21.342  23.946 -11.462  1.00 25.57           C  
ATOM    990  O   CYS   119      20.665  24.224 -12.462  1.00 25.73           O  
ATOM    991  CB  CYS   119      23.757  23.606 -12.002  1.00 27.45           C  
ATOM    992  SG  CYS   119      25.141  22.472 -12.121  1.00 29.53           S  
ATOM    993  N   PRO   120      21.139  24.523 -10.258  1.00 23.62           N  
ATOM    994  CA  PRO   120      21.849  24.302  -8.974  1.00 21.20           C  
ATOM    995  C   PRO   120      21.369  23.125  -8.124  1.00 20.06           C  
ATOM    996  O   PRO   120      21.936  22.885  -7.060  1.00 17.82           O  
ATOM    997  CB  PRO   120      21.537  25.580  -8.198  1.00 22.04           C  
ATOM    998  CG  PRO   120      20.144  25.948  -8.652  1.00 22.84           C  
ATOM    999  CD  PRO   120      20.095  25.560 -10.125  1.00 23.21           C  
ATOM   1000  N   VAL   121      20.349  22.390  -8.562  1.00 18.45           N  
ATOM   1001  CA  VAL   121      19.870  21.259  -7.749  1.00 17.90           C  
ATOM   1002  C   VAL   121      20.963  20.198  -7.540  1.00 16.37           C  
ATOM   1003  O   VAL   121      21.146  19.687  -6.433  1.00 16.62           O  
ATOM   1004  CB  VAL   121      18.557  20.661  -8.340  1.00 18.55           C  
ATOM   1005  CG1 VAL   121      18.271  19.271  -7.769  1.00 19.26           C  
ATOM   1006  CG2 VAL   121      17.409  21.618  -8.031  1.00 18.36           C  
ATOM   1007  N   PHE   122      21.673  19.872  -8.610  1.00 16.51           N  
ATOM   1008  CA  PHE   122      22.654  18.799  -8.556  1.00 16.39           C  
ATOM   1009  C   PHE   122      23.668  19.052  -7.432  1.00 16.35           C  
ATOM   1010  O   PHE   122      24.175  20.152  -7.316  1.00 15.68           O  
ATOM   1011  CB  PHE   122      23.375  18.677  -9.889  1.00 17.53           C  
ATOM   1012  CG  PHE   122      24.571  17.769  -9.834  1.00 18.38           C  
ATOM   1013  CD1 PHE   122      24.405  16.393  -9.692  1.00 18.85           C  
ATOM   1014  CD2 PHE   122      25.873  18.316  -9.857  1.00 19.32           C  
ATOM   1015  CE1 PHE   122      25.520  15.545  -9.598  1.00 21.40           C  
ATOM   1016  CE2 PHE   122      26.990  17.492  -9.795  1.00 19.08           C  
ATOM   1017  CZ  PHE   122      26.818  16.100  -9.644  1.00 20.67           C  
ATOM   1018  N   THR   123      23.937  18.023  -6.636  1.00 14.58           N  
ATOM   1019  CA  THR   123      24.913  18.081  -5.558  1.00 13.79           C  
ATOM   1020  C   THR   123      26.057  17.091  -5.784  1.00 13.81           C  
ATOM   1021  O   THR   123      25.815  15.882  -5.743  1.00 14.03           O  
ATOM   1022  CB  THR   123      24.210  17.757  -4.229  1.00 13.79           C  
ATOM   1023  OG1 THR   123      23.150  18.714  -4.043  1.00 13.23           O  
ATOM   1024  CG2 THR   123      25.165  17.834  -3.075  1.00 13.37           C  
ATOM   1025  N   PRO   124      27.298  17.598  -5.974  1.00 13.35           N  
ATOM   1026  CA  PRO   124      28.459  16.717  -6.210  1.00 12.91           C  
ATOM   1027  C   PRO   124      28.835  15.980  -4.923  1.00 13.01           C  
ATOM   1028  O   PRO   124      28.407  16.405  -3.816  1.00 12.54           O  
ATOM   1029  CB  PRO   124      29.580  17.679  -6.617  1.00 14.14           C  
ATOM   1030  CG  PRO   124      29.146  19.047  -6.128  1.00 13.45           C  
ATOM   1031  CD  PRO   124      27.650  19.032  -5.972  1.00 12.87           C  
ATOM   1032  N   PRO   125      29.655  14.912  -5.037  1.00 13.44           N  
ATOM   1033  CA  PRO   125      30.187  14.273  -3.846  1.00 13.53           C  
ATOM   1034  C   PRO   125      30.823  15.290  -2.880  1.00 13.16           C  
ATOM   1035  O   PRO   125      31.621  16.109  -3.298  1.00 12.44           O  
ATOM   1036  CB  PRO   125      31.230  13.295  -4.423  1.00 14.24           C  
ATOM   1037  CG  PRO   125      30.673  12.977  -5.804  1.00 15.16           C  
ATOM   1038  CD  PRO   125      30.160  14.294  -6.276  1.00 14.35           C  
ATOM   1039  N   GLY   126      30.452  15.221  -1.600  1.00 13.37           N  
ATOM   1040  CA  GLY   126      30.991  16.124  -0.568  1.00 12.38           C  
ATOM   1041  C   GLY   126      30.260  17.469  -0.494  1.00 12.55           C  
ATOM   1042  O   GLY   126      30.558  18.265   0.386  1.00 14.16           O  
ATOM   1043  N   GLY   127      29.307  17.701  -1.375  1.00 12.12           N  
ATOM   1044  CA  GLY   127      28.544  18.974  -1.397  1.00 11.03           C  
ATOM   1045  C   GLY   127      27.258  18.895  -0.603  1.00 12.16           C  
ATOM   1046  O   GLY   127      26.846  17.783  -0.121  1.00 11.11           O  
ATOM   1047  N   GLU   128      26.644  20.072  -0.380  1.00 11.01           N  
ATOM   1048  CA  GLU   128      25.330  20.188   0.289  1.00 11.89           C  
ATOM   1049  C   GLU   128      24.229  20.326  -0.747  1.00 11.34           C  
ATOM   1050  O   GLU   128      24.424  20.983  -1.790  1.00 12.25           O  
ATOM   1051  CB  GLU   128      25.265  21.460   1.176  1.00 11.43           C  
ATOM   1052  CG  GLU   128      26.020  21.334   2.516  1.00 11.16           C  
ATOM   1053  CD  GLU   128      26.067  22.656   3.250  1.00 14.31           C  
ATOM   1054  OE1 GLU   128      26.553  23.629   2.649  1.00 12.14           O  
ATOM   1055  OE2 GLU   128      25.672  22.695   4.437  1.00 17.34           O  
ATOM   1056  N   THR   129      23.055  19.755  -0.451  1.00 11.74           N  
ATOM   1057  CA  THR   129      21.827  19.964  -1.236  1.00 11.64           C  
ATOM   1058  C   THR   129      21.280  21.373  -0.977  1.00 11.58           C  
ATOM   1059  O   THR   129      21.643  21.995   0.050  1.00 10.25           O  
ATOM   1060  CB  THR   129      20.719  18.950  -0.876  1.00 12.61           C  
ATOM   1061  OG1 THR   129      20.353  19.146   0.536  1.00 14.75           O  
ATOM   1062  CG2 THR   129      21.286  17.516  -0.977  1.00 15.54           C  
ATOM   1063  N   LEU   130      20.437  21.862  -1.904  1.00 11.52           N  
ATOM   1064  CA  LEU   130      19.738  23.143  -1.676  1.00 12.31           C  
ATOM   1065  C   LEU   130      18.949  23.100  -0.380  1.00 12.77           C  
ATOM   1066  O   LEU   130      18.929  24.072   0.332  1.00 10.77           O  
ATOM   1067  CB  LEU   130      18.831  23.525  -2.852  1.00 13.53           C  
ATOM   1068  CG  LEU   130      19.595  23.847  -4.142  1.00 14.68           C  
ATOM   1069  CD1 LEU   130      18.645  24.060  -5.326  1.00 17.49           C  
ATOM   1070  CD2 LEU   130      20.532  25.046  -3.947  1.00 18.17           C  
ATOM   1071  N   ASP   131      18.345  21.964  -0.042  1.00 12.80           N  
ATOM   1072  CA  ASP   131      17.546  21.916   1.175  1.00 13.89           C  
ATOM   1073  C   ASP   131      18.433  21.950   2.421  1.00 13.08           C  
ATOM   1074  O   ASP   131      18.056  22.543   3.433  1.00 12.35           O  
ATOM   1075  CB  ASP   131      16.610  20.690   1.175  1.00 15.29           C  
ATOM   1076  CG  ASP   131      15.323  20.920   0.350  1.00 19.19           C  
ATOM   1077  OD1 ASP   131      14.896  22.070   0.066  1.00 24.81           O  
ATOM   1078  OD2 ASP   131      14.735  19.904  -0.020  1.00 27.72           O  
ATOM   1079  N   GLN   132      19.621  21.349   2.346  1.00 12.26           N  
ATOM   1080  CA  GLN   132      20.561  21.450   3.443  1.00 11.76           C  
ATOM   1081  C   GLN   132      21.019  22.912   3.650  1.00 11.28           C  
ATOM   1082  O   GLN   132      21.130  23.390   4.812  1.00  9.47           O  
ATOM   1083  CB  GLN   132      21.777  20.566   3.167  1.00 12.20           C  
ATOM   1084  CG  GLN   132      21.508  19.091   3.488  1.00 15.13           C  
ATOM   1085  CD  GLN   132      22.679  18.210   3.078  1.00 18.85           C  
ATOM   1086  OE1 GLN   132      23.201  18.338   1.971  1.00 16.27           O  
ATOM   1087  NE2 GLN   132      23.110  17.325   3.991  1.00 23.69           N  
ATOM   1088  N   VAL   133      21.279  23.616   2.550  1.00  9.48           N  
ATOM   1089  CA  VAL   133      21.651  25.041   2.659  1.00  9.49           C  
ATOM   1090  C   VAL   133      20.518  25.854   3.282  1.00  9.92           C  
ATOM   1091  O   VAL   133      20.744  26.611   4.228  1.00  9.67           O  
ATOM   1092  CB  VAL   133      22.038  25.636   1.275  1.00 10.42           C  
ATOM   1093  CG1 VAL   133      22.439  27.068   1.402  1.00 10.99           C  
ATOM   1094  CG2 VAL   133      23.237  24.856   0.663  1.00  9.59           C  
ATOM   1095  N   LYS   134      19.309  25.698   2.754  1.00 10.05           N  
ATOM   1096  CA  LYS   134      18.129  26.384   3.308  1.00 10.95           C  
ATOM   1097  C   LYS   134      17.980  26.086   4.795  1.00 11.05           C  
ATOM   1098  O   LYS   134      17.592  26.959   5.566  1.00  9.92           O  
ATOM   1099  CB  LYS   134      16.856  25.966   2.585  1.00 10.96           C  
ATOM   1100  CG  LYS   134      15.648  26.772   3.054  1.00 13.28           C  
ATOM   1101  CD  LYS   134      14.331  26.418   2.340  1.00 15.14           C  
ATOM   1102  CE  LYS   134      14.135  27.178   1.071  1.00 19.20           C  
ATOM   1103  NZ  LYS   134      12.763  26.837   0.546  1.00 22.40           N  
ATOM   1104  N   MET   135      18.239  24.845   5.204  1.00  9.06           N  
ATOM   1105  CA  MET   135      18.044  24.514   6.621  1.00 11.12           C  
ATOM   1106  C   MET   135      19.006  25.323   7.494  1.00 10.30           C  
ATOM   1107  O   MET   135      18.621  25.789   8.531  1.00 10.53           O  
ATOM   1108  CB  MET   135      18.138  22.983   6.830  1.00 11.96           C  
ATOM   1109  CG  MET   135      17.896  22.479   8.257  1.00 13.35           C  
ATOM   1110  SD  MET   135      16.066  22.913   8.811  1.00 15.75          SE  
ATOM   1111  CE  MET   135      16.394  24.116  10.229  1.00 19.57           C  
ATOM   1112  N   ARG   136      20.245  25.528   7.042  1.00  9.96           N  
ATOM   1113  CA  ARG   136      21.207  26.423   7.733  1.00  9.44           C  
ATOM   1114  C   ARG   136      20.721  27.874   7.792  1.00 10.34           C  
ATOM   1115  O   ARG   136      20.948  28.566   8.776  1.00 11.05           O  
ATOM   1116  CB  ARG   136      22.596  26.348   7.102  1.00  8.92           C  
ATOM   1117  CG  ARG   136      23.220  24.964   7.297  1.00 10.88           C  
ATOM   1118  CD  ARG   136      24.692  25.051   7.080  1.00 10.58           C  
ATOM   1119  NE  ARG   136      25.105  25.173   5.661  1.00  9.48           N  
ATOM   1120  CZ  ARG   136      25.618  26.262   5.081  1.00 10.08           C  
ATOM   1121  NH1 ARG   136      25.626  27.455   5.692  1.00  9.95           N  
ATOM   1122  NH2 ARG   136      26.066  26.169   3.812  1.00  9.85           N  
ATOM   1123  N   GLY   137      19.974  28.275   6.763  1.00  9.12           N  
ATOM   1124  CA  GLY   137      19.362  29.616   6.694  1.00 10.59           C  
ATOM   1125  C   GLY   137      18.235  29.727   7.721  1.00 10.98           C  
ATOM   1126  O   GLY   137      18.143  30.735   8.466  1.00 10.49           O  
ATOM   1127  N   ILE   138      17.365  28.706   7.739  1.00 10.10           N  
ATOM   1128  CA  ILE   138      16.271  28.625   8.740  1.00  9.94           C  
ATOM   1129  C   ILE   138      16.838  28.634  10.204  1.00 10.47           C  
ATOM   1130  O   ILE   138      16.357  29.367  11.071  1.00 10.30           O  
ATOM   1131  CB  ILE   138      15.379  27.383   8.485  1.00  9.63           C  
ATOM   1132  CG1 ILE   138      14.688  27.518   7.103  1.00  9.46           C  
ATOM   1133  CG2 ILE   138      14.331  27.262   9.586  1.00 12.67           C  
ATOM   1134  CD1 ILE   138      13.942  26.227   6.728  1.00 10.38           C  
ATOM   1135  N   ASP   139      17.871  27.827  10.446  1.00 10.75           N  
ATOM   1136  CA  ASP   139      18.523  27.719  11.751  1.00 12.25           C  
ATOM   1137  C   ASP   139      19.051  29.087  12.177  1.00 11.78           C  
ATOM   1138  O   ASP   139      18.744  29.575  13.280  1.00 12.04           O  
ATOM   1139  CB  ASP   139      19.665  26.694  11.614  1.00 12.31           C  
ATOM   1140  CG  ASP   139      20.421  26.416  12.931  1.00 17.51           C  
ATOM   1141  OD1 ASP   139      20.224  27.111  13.931  1.00 23.55           O  
ATOM   1142  OD2 ASP   139      21.267  25.482  12.918  1.00 23.53           O  
ATOM   1143  N   PHE   140      19.828  29.719  11.300  1.00 10.99           N  
ATOM   1144  CA  PHE   140      20.375  31.032  11.623  1.00 11.07           C  
ATOM   1145  C   PHE   140      19.255  32.044  11.868  1.00 10.71           C  
ATOM   1146  O   PHE   140      19.280  32.819  12.844  1.00 11.15           O  
ATOM   1147  CB  PHE   140      21.308  31.564  10.533  1.00 10.66           C  
ATOM   1148  CG  PHE   140      21.842  32.928  10.882  1.00 11.12           C  
ATOM   1149  CD1 PHE   140      22.879  33.030  11.802  1.00 13.72           C  
ATOM   1150  CD2 PHE   140      21.241  34.092  10.383  1.00 11.20           C  
ATOM   1151  CE1 PHE   140      23.358  34.277  12.190  1.00 13.44           C  
ATOM   1152  CE2 PHE   140      21.724  35.384  10.768  1.00 11.43           C  
ATOM   1153  CZ  PHE   140      22.778  35.452  11.680  1.00 13.56           C  
ATOM   1154  N   PHE   141      18.275  32.061  10.961  1.00  9.26           N  
ATOM   1155  CA  PHE   141      17.192  33.042  11.078  1.00  9.67           C  
ATOM   1156  C   PHE   141      16.396  32.886  12.391  1.00  9.64           C  
ATOM   1157  O   PHE   141      16.073  33.884  13.054  1.00 10.41           O  
ATOM   1158  CB  PHE   141      16.224  32.908   9.897  1.00  9.66           C  
ATOM   1159  CG  PHE   141      15.129  33.941   9.915  1.00 10.69           C  
ATOM   1160  CD1 PHE   141      15.453  35.288   9.712  1.00 11.03           C  
ATOM   1161  CD2 PHE   141      13.787  33.576  10.129  1.00 13.04           C  
ATOM   1162  CE1 PHE   141      14.439  36.279   9.718  1.00 13.41           C  
ATOM   1163  CE2 PHE   141      12.752  34.558  10.131  1.00 12.72           C  
ATOM   1164  CZ  PHE   141      13.090  35.911   9.934  1.00 12.61           C  
ATOM   1165  N   GLU   142      16.056  31.654  12.739  1.00 10.90           N  
ATOM   1166  CA  GLU   142      15.343  31.419  14.018  1.00 12.50           C  
ATOM   1167  C   GLU   142      16.180  31.860  15.208  1.00 12.76           C  
ATOM   1168  O   GLU   142      15.645  32.512  16.144  1.00 12.86           O  
ATOM   1169  CB  GLU   142      14.956  29.948  14.133  1.00 14.29           C  
ATOM   1170  CG  GLU   142      13.950  29.649  13.002  1.00 18.51           C  
ATOM   1171  CD  GLU   142      13.206  28.339  13.106  1.00 26.10           C  
ATOM   1172  OE1 GLU   142      12.074  28.285  12.548  1.00 26.39           O  
ATOM   1173  OE2 GLU   142      13.733  27.380  13.716  1.00 30.36           O  
ATOM   1174  N   PHE   143      17.468  31.490  15.178  1.00 11.64           N  
ATOM   1175  CA  PHE   143      18.452  31.988  16.154  1.00 12.86           C  
ATOM   1176  C   PHE   143      18.407  33.541  16.285  1.00 13.14           C  
ATOM   1177  O   PHE   143      18.296  34.089  17.402  1.00 12.88           O  
ATOM   1178  CB  PHE   143      19.855  31.490  15.793  1.00 14.14           C  
ATOM   1179  CG  PHE   143      20.971  32.331  16.383  1.00 16.21           C  
ATOM   1180  CD1 PHE   143      21.327  32.196  17.723  1.00 19.07           C  
ATOM   1181  CD2 PHE   143      21.602  33.302  15.624  1.00 15.91           C  
ATOM   1182  CE1 PHE   143      22.348  32.991  18.271  1.00 20.54           C  
ATOM   1183  CE2 PHE   143      22.596  34.111  16.160  1.00 20.18           C  
ATOM   1184  CZ  PHE   143      22.977  33.955  17.484  1.00 17.61           C  
ATOM   1185  N   LEU   144      18.513  34.228  15.153  1.00 11.11           N  
ATOM   1186  CA  LEU   144      18.529  35.689  15.110  1.00 11.52           C  
ATOM   1187  C   LEU   144      17.234  36.287  15.704  1.00 11.63           C  
ATOM   1188  O   LEU   144      17.280  37.194  16.562  1.00 12.63           O  
ATOM   1189  CB  LEU   144      18.725  36.173  13.658  1.00 10.82           C  
ATOM   1190  CG  LEU   144      18.846  37.697  13.477  1.00 11.37           C  
ATOM   1191  CD1 LEU   144      20.007  38.293  14.264  1.00 14.98           C  
ATOM   1192  CD2 LEU   144      18.998  38.069  11.981  1.00 12.34           C  
ATOM   1193  N   CYS   145      16.089  35.738  15.280  1.00 11.54           N  
ATOM   1194  CA  CYS   145      14.771  36.188  15.771  1.00 12.26           C  
ATOM   1195  C   CYS   145      14.670  36.081  17.292  1.00 13.44           C  
ATOM   1196  O   CYS   145      14.323  37.070  17.943  1.00 13.67           O  
ATOM   1197  CB  CYS   145      13.644  35.406  15.096  1.00 12.21           C  
ATOM   1198  SG  CYS   145      13.463  35.951  13.328  1.00 14.79           S  
ATOM   1199  N   GLN   146      15.007  34.920  17.837  1.00 13.71           N  
ATOM   1200  CA  GLN   146      15.004  34.707  19.294  1.00 15.59           C  
ATOM   1201  C   GLN   146      15.946  35.663  20.006  1.00 15.93           C  
ATOM   1202  O   GLN   146      15.580  36.240  21.051  1.00 15.40           O  
ATOM   1203  CB  GLN   146      15.332  33.252  19.635  1.00 16.45           C  
ATOM   1204  CG  GLN   146      14.186  32.288  19.241  1.00 22.14           C  
ATOM   1205  CD  GLN   146      12.874  32.640  19.971  1.00 29.71           C  
ATOM   1206  OE1 GLN   146      12.777  32.509  21.201  1.00 32.44           O  
ATOM   1207  NE2 GLN   146      11.882  33.131  19.216  1.00 32.00           N  
ATOM   1208  N   LEU   147      17.138  35.859  19.428  1.00 15.37           N  
ATOM   1209  CA  LEU   147      18.154  36.782  19.976  1.00 15.16           C  
ATOM   1210  C   LEU   147      17.588  38.202  20.161  1.00 15.14           C  
ATOM   1211  O   LEU   147      17.635  38.785  21.258  1.00 15.30           O  
ATOM   1212  CB  LEU   147      19.390  36.799  19.053  1.00 14.58           C  
ATOM   1213  CG  LEU   147      20.477  37.750  19.578  1.00 18.48           C  
ATOM   1214  CD1 LEU   147      21.277  37.026  20.669  1.00 24.94           C  
ATOM   1215  CD2 LEU   147      21.391  38.217  18.509  1.00 21.05           C  
ATOM   1216  N   ILE   148      17.013  38.730  19.088  1.00 13.47           N  
ATOM   1217  CA  ILE   148      16.472  40.085  19.047  1.00 13.77           C  
ATOM   1218  C   ILE   148      15.277  40.239  19.987  1.00 13.26           C  
ATOM   1219  O   ILE   148      15.188  41.254  20.716  1.00 13.49           O  
ATOM   1220  CB  ILE   148      16.083  40.484  17.599  1.00 13.22           C  
ATOM   1221  CG1 ILE   148      17.315  40.531  16.688  1.00 12.36           C  
ATOM   1222  CG2 ILE   148      15.325  41.837  17.556  1.00 15.01           C  
ATOM   1223  CD1 ILE   148      18.530  41.337  17.225  1.00 14.76           C  
ATOM   1224  N   LEU   149      14.378  39.253  19.981  1.00 13.33           N  
ATOM   1225  CA  LEU   149      13.166  39.304  20.851  1.00 12.70           C  
ATOM   1226  C   LEU   149      13.587  39.302  22.328  1.00 13.92           C  
ATOM   1227  O   LEU   149      13.110  40.134  23.119  1.00 13.08           O  
ATOM   1228  CB  LEU   149      12.228  38.132  20.556  1.00 13.22           C  
ATOM   1229  CG  LEU   149      11.562  38.284  19.170  1.00 11.59           C  
ATOM   1230  CD1 LEU   149      10.787  36.997  18.820  1.00 14.38           C  
ATOM   1231  CD2 LEU   149      10.627  39.515  19.141  1.00 16.20           C  
ATOM   1232  N   LYS   150      14.521  38.415  22.660  1.00 13.32           N  
ATOM   1233  CA  LYS   150      15.031  38.306  24.051  1.00 15.01           C  
ATOM   1234  C   LYS   150      15.770  39.578  24.495  1.00 15.41           C  
ATOM   1235  O   LYS   150      15.614  40.042  25.647  1.00 15.91           O  
ATOM   1236  CB  LYS   150      15.924  37.077  24.192  1.00 15.61           C  
ATOM   1237  CG  LYS   150      15.172  35.781  24.225  1.00 18.33           C  
ATOM   1238  CD  LYS   150      16.140  34.636  24.225  1.00 22.37           C  
ATOM   1239  CE  LYS   150      15.405  33.333  24.046  1.00 29.21           C  
ATOM   1240  NZ  LYS   150      15.119  32.732  25.380  1.00 34.01           N  
ATOM   1241  N   GLU   151      16.566  40.159  23.600  1.00 16.59           N  
ATOM   1242  CA  GLU   151      17.236  41.421  23.903  1.00 18.62           C  
ATOM   1243  C   GLU   151      16.242  42.543  24.094  1.00 18.93           C  
ATOM   1244  O   GLU   151      16.381  43.320  25.036  1.00 19.86           O  
ATOM   1245  CB  GLU   151      18.279  41.783  22.826  1.00 18.64           C  
ATOM   1246  CG  GLU   151      19.491  40.830  22.871  1.00 20.23           C  
ATOM   1247  CD  GLU   151      20.613  41.209  21.915  1.00 21.22           C  
ATOM   1248  OE1 GLU   151      20.429  42.127  21.092  1.00 26.24           O  
ATOM   1249  OE2 GLU   151      21.676  40.557  21.971  1.00 24.90           O  
ATOM   1250  N   ALA   152      15.231  42.625  23.220  1.00 19.10           N  
ATOM   1251  CA  ALA   152      14.172  43.629  23.369  1.00 19.49           C  
ATOM   1252  C   ALA   152      13.473  43.445  24.730  1.00 19.77           C  
ATOM   1253  O   ALA   152      13.114  44.432  25.390  1.00 19.86           O  
ATOM   1254  CB  ALA   152      13.159  43.526  22.252  1.00 20.37           C  
ATOM   1255  N   ASP   153      13.259  42.188  25.112  1.00 19.41           N  
ATOM   1256  CA  ASP   153      12.605  41.850  26.380  1.00 21.62           C  
ATOM   1257  C   ASP   153      13.466  42.281  27.569  1.00 23.56           C  
ATOM   1258  O   ASP   153      12.959  42.809  28.560  1.00 23.49           O  
ATOM   1259  CB  ASP   153      12.369  40.338  26.494  1.00 20.56           C  
ATOM   1260  CG  ASP   153      11.495  39.982  27.680  1.00 19.09           C  
ATOM   1261  OD1 ASP   153      10.349  40.462  27.714  1.00 21.16           O  
ATOM   1262  OD2 ASP   153      11.962  39.243  28.563  1.00 19.70           O  
ATOM   1263  N   GLN   154      14.763  42.012  27.472  1.00 26.71           N  
ATOM   1264  CA  GLN   154      15.697  42.277  28.574  1.00 30.61           C  
ATOM   1265  C   GLN   154      16.002  43.776  28.747  1.00 32.44           C  
ATOM   1266  O   GLN   154      16.568  44.176  29.779  1.00 34.00           O  
ATOM   1267  CB  GLN   154      16.979  41.429  28.444  1.00 30.79           C  
ATOM   1268  CG  GLN   154      16.770  39.895  28.461  1.00 33.07           C  
ATOM   1269  CD  GLN   154      16.043  39.367  29.699  1.00 37.37           C  
ATOM   1270  OE1 GLN   154      16.550  39.443  30.823  1.00 39.46           O  
ATOM   1271  NE2 GLN   154      14.846  38.807  29.487  1.00 40.42           N  
ATOM   1272  N   LYS   155      15.587  44.612  27.785  1.00 34.64           N  
ATOM   1273  CA  LYS   155      15.755  46.085  27.881  1.00 36.26           C  
ATOM   1274  C   LYS   155      14.446  46.864  28.024  1.00 36.17           C  
ATOM   1275  O   LYS   155      13.360  46.298  28.201  1.00 37.58           O  
ATOM   1276  CB  LYS   155      16.523  46.682  26.678  1.00 36.32           C  
ATOM   1277  CG  LYS   155      17.355  45.733  25.836  1.00 39.40           C  
ATOM   1278  CD  LYS   155      18.806  45.627  26.267  1.00 40.09           C  
ATOM   1279  CE  LYS   155      19.565  44.727  25.301  1.00 43.03           C  
ATOM   1280  NZ  LYS   155      19.928  45.384  24.002  1.00 43.48           N  
ATOM   1281  N   ASN   165      12.474  55.446  15.912  1.00 41.07           N  
ATOM   1282  CA  ASN   165      12.786  56.233  14.721  1.00 40.86           C  
ATOM   1283  C   ASN   165      14.225  56.117  14.260  1.00 39.46           C  
ATOM   1284  O   ASN   165      14.474  55.926  13.065  1.00 39.76           O  
ATOM   1285  CB  ASN   165      12.495  57.726  14.953  1.00 41.56           C  
ATOM   1286  CG  ASN   165      11.019  58.026  15.088  1.00 43.79           C  
ATOM   1287  OD1 ASN   165      10.175  57.371  14.470  1.00 47.63           O  
ATOM   1288  ND2 ASN   165      10.696  59.042  15.885  1.00 46.17           N  
ATOM   1289  N   CYS   166      15.149  56.242  15.216  1.00 37.98           N  
ATOM   1290  CA  CYS   166      16.580  56.379  14.945  0.50 36.88           C  
ATOM   1292  C   CYS   166      17.170  55.327  13.986  1.00 36.05           C  
ATOM   1293  O   CYS   166      17.921  55.653  13.041  1.00 35.95           O  
ATOM   1294  CB  CYS   166      17.329  56.360  16.274  0.50 37.09           C  
ATOM   1296  SG  CYS   166      19.092  56.519  16.131  0.50 38.12           S  
ATOM   1298  N   LEU   167      16.844  54.063  14.232  1.00 33.59           N  
ATOM   1299  CA  LEU   167      17.349  52.984  13.376  1.00 30.89           C  
ATOM   1300  C   LEU   167      16.723  53.022  11.973  1.00 29.85           C  
ATOM   1301  O   LEU   167      17.438  52.862  10.974  1.00 28.15           O  
ATOM   1302  CB  LEU   167      17.144  51.623  14.043  1.00 29.90           C  
ATOM   1303  CG  LEU   167      17.722  51.341  15.434  1.00 29.69           C  
ATOM   1304  CD1 LEU   167      17.442  49.901  15.841  1.00 27.15           C  
ATOM   1305  CD2 LEU   167      19.210  51.625  15.503  1.00 27.72           C  
ATOM   1306  N   GLU   168      15.405  53.265  11.905  1.00 28.65           N  
ATOM   1307  CA  GLU   168      14.659  53.300  10.634  1.00 28.93           C  
ATOM   1308  C   GLU   168      15.057  54.494   9.758  1.00 27.44           C  
ATOM   1309  O   GLU   168      15.255  54.348   8.551  1.00 27.06           O  
ATOM   1310  CB  GLU   168      13.141  53.301  10.891  1.00 29.00           C  
ATOM   1311  CG  GLU   168      12.255  53.014   9.660  1.00 30.98           C  
ATOM   1312  CD  GLU   168      10.935  52.292  10.007  1.00 32.01           C  
ATOM   1313  OE1 GLU   168      10.464  52.369  11.172  1.00 35.69           O  
ATOM   1314  OE2 GLU   168      10.375  51.617   9.112  1.00 36.97           O  
ATOM   1315  N   THR   169      15.176  55.673  10.373  1.00 27.30           N  
ATOM   1316  CA  THR   169      15.520  56.891   9.635  1.00 27.25           C  
ATOM   1317  C   THR   169      16.842  56.760   8.882  1.00 26.37           C  
ATOM   1318  O   THR   169      16.923  57.137   7.709  1.00 26.91           O  
ATOM   1319  CB  THR   169      15.510  58.168  10.544  1.00 27.66           C  
ATOM   1320  OG1 THR   169      16.549  58.072  11.523  1.00 29.75           O  
ATOM   1321  CG2 THR   169      14.185  58.297  11.260  1.00 27.52           C  
ATOM   1322  N   SER   170      17.848  56.182   9.535  1.00 26.61           N  
ATOM   1323  CA  SER   170      19.174  56.002   8.917  1.00 26.93           C  
ATOM   1324  C   SER   170      19.123  55.010   7.750  1.00 26.69           C  
ATOM   1325  O   SER   170      19.792  55.208   6.740  1.00 27.67           O  
ATOM   1326  CB  SER   170      20.248  55.639   9.958  1.00 27.25           C  
ATOM   1327  OG  SER   170      20.071  54.353  10.510  1.00 28.32           O  
ATOM   1328  N   LEU   171      18.305  53.966   7.868  1.00 26.17           N  
ATOM   1329  CA  LEU   171      18.040  53.090   6.720  1.00 25.72           C  
ATOM   1330  C   LEU   171      17.287  53.802   5.580  1.00 26.04           C  
ATOM   1331  O   LEU   171      17.639  53.648   4.407  1.00 25.52           O  
ATOM   1332  CB  LEU   171      17.298  51.821   7.156  1.00 25.40           C  
ATOM   1333  CG  LEU   171      18.092  50.830   8.015  1.00 24.74           C  
ATOM   1334  CD1 LEU   171      17.136  49.817   8.632  1.00 23.70           C  
ATOM   1335  CD2 LEU   171      19.200  50.144   7.186  1.00 22.15           C  
ATOM   1336  N   ALA   172      16.256  54.588   5.927  1.00 26.86           N  
ATOM   1337  CA  ALA   172      15.388  55.251   4.933  1.00 27.07           C  
ATOM   1338  C   ALA   172      16.132  56.273   4.070  1.00 27.99           C  
ATOM   1339  O   ALA   172      15.687  56.601   2.959  1.00 28.28           O  
ATOM   1340  CB  ALA   172      14.173  55.917   5.628  1.00 26.59           C  
ATOM   1341  N   GLU   173      17.268  56.735   4.592  1.00 28.87           N  
ATOM   1342  CA  GLU   173      18.192  57.649   3.923  1.00 31.20           C  
ATOM   1343  C   GLU   173      18.737  57.100   2.610  1.00 30.70           C  
ATOM   1344  O   GLU   173      19.006  57.862   1.683  1.00 30.82           O  
ATOM   1345  CB  GLU   173      19.397  57.907   4.827  1.00 31.14           C  
ATOM   1346  CG  GLU   173      19.240  59.056   5.812  1.00 33.97           C  
ATOM   1347  CD  GLU   173      20.443  59.217   6.735  1.00 34.81           C  
ATOM   1348  OE1 GLU   173      21.599  58.949   6.305  1.00 37.15           O  
ATOM   1349  OE2 GLU   173      20.223  59.620   7.912  1.00 40.87           O  
ATOM   1350  N   ILE   174      18.937  55.779   2.550  1.00 29.59           N  
ATOM   1351  CA  ILE   174      19.664  55.177   1.444  1.00 28.75           C  
ATOM   1352  C   ILE   174      18.945  53.993   0.816  1.00 27.96           C  
ATOM   1353  O   ILE   174      19.270  53.604  -0.303  1.00 28.16           O  
ATOM   1354  CB  ILE   174      21.095  54.747   1.855  1.00 28.85           C  
ATOM   1355  CG1 ILE   174      21.047  53.714   2.996  1.00 28.35           C  
ATOM   1356  CG2 ILE   174      21.951  55.980   2.220  1.00 28.66           C  
ATOM   1357  CD1 ILE   174      22.382  53.050   3.268  1.00 28.84           C  
ATOM   1358  N   PHE   175      17.976  53.438   1.545  1.00 27.25           N  
ATOM   1359  CA  PHE   175      17.154  52.313   1.089  1.00 27.16           C  
ATOM   1360  C   PHE   175      15.712  52.748   0.844  1.00 27.96           C  
ATOM   1361  O   PHE   175      15.198  53.589   1.591  1.00 28.32           O  
ATOM   1362  CB  PHE   175      17.148  51.197   2.138  1.00 25.39           C  
ATOM   1363  CG  PHE   175      18.448  50.476   2.254  1.00 25.02           C  
ATOM   1364  CD1 PHE   175      19.000  49.831   1.144  1.00 22.62           C  
ATOM   1365  CD2 PHE   175      19.138  50.455   3.463  1.00 23.11           C  
ATOM   1366  CE1 PHE   175      20.233  49.168   1.253  1.00 22.60           C  
ATOM   1367  CE2 PHE   175      20.371  49.793   3.582  1.00 23.59           C  
ATOM   1368  CZ  PHE   175      20.907  49.145   2.472  1.00 22.09           C  
ATOM   1369  N   PRO   176      15.042  52.144  -0.159  1.00 28.92           N  
ATOM   1370  CA  PRO   176      13.659  52.519  -0.523  1.00 29.85           C  
ATOM   1371  C   PRO   176      12.546  52.111   0.472  1.00 30.23           C  
ATOM   1372  O   PRO   176      11.619  51.369   0.120  1.00 29.89           O  
ATOM   1373  CB  PRO   176      13.460  51.839  -1.879  1.00 29.67           C  
ATOM   1374  CG  PRO   176      14.364  50.658  -1.842  1.00 29.69           C  
ATOM   1375  CD  PRO   176      15.559  51.076  -1.037  1.00 29.70           C  
ATOM   1376  N   LEU   177      12.649  52.594   1.702  1.00 31.32           N  
ATOM   1377  CA  LEU   177      11.584  52.454   2.669  1.00 32.99           C  
ATOM   1378  C   LEU   177      10.558  53.566   2.434  1.00 34.01           C  
ATOM   1379  O   LEU   177       9.364  53.292   2.296  1.00 35.48           O  
ATOM   1380  CB  LEU   177      12.135  52.570   4.085  1.00 33.09           C  
ATOM   1381  CG  LEU   177      12.901  51.402   4.709  1.00 33.87           C  
ATOM   1382  CD1 LEU   177      13.626  51.910   5.929  1.00 35.29           C  
ATOM   1383  CD2 LEU   177      11.974  50.264   5.097  1.00 34.86           C  
ATOM   1384  N   ILE   191       3.939  49.630  13.570  1.00 39.51           N  
ATOM   1385  CA  ILE   191       3.880  50.674  14.609  1.00 39.47           C  
ATOM   1386  C   ILE   191       5.049  50.664  15.620  1.00 38.14           C  
ATOM   1387  O   ILE   191       5.580  51.740  15.924  1.00 37.87           O  
ATOM   1388  CB  ILE   191       2.462  50.789  15.328  1.00 39.29           C  
ATOM   1389  CG1 ILE   191       2.433  51.996  16.290  1.00 40.74           C  
ATOM   1390  CG2 ILE   191       2.038  49.463  16.001  1.00 40.80           C  
ATOM   1391  CD1 ILE   191       1.296  52.006  17.340  1.00 40.39           C  
ATOM   1392  N   PRO   192       5.482  49.463  16.109  1.00 37.22           N  
ATOM   1393  CA  PRO   192       6.645  49.479  17.014  1.00 35.79           C  
ATOM   1394  C   PRO   192       7.866  50.047  16.289  1.00 34.05           C  
ATOM   1395  O   PRO   192       8.092  49.699  15.126  1.00 34.00           O  
ATOM   1396  CB  PRO   192       6.894  47.986  17.313  1.00 35.96           C  
ATOM   1397  CG  PRO   192       5.638  47.306  17.007  1.00 36.88           C  
ATOM   1398  CD  PRO   192       5.026  48.079  15.861  1.00 37.57           C  
ATOM   1399  N   GLY   193       8.628  50.919  16.953  1.00 32.00           N  
ATOM   1400  CA  GLY   193       9.924  51.376  16.415  1.00 29.30           C  
ATOM   1401  C   GLY   193      10.830  50.158  16.267  1.00 26.86           C  
ATOM   1402  O   GLY   193      10.654  49.181  16.991  1.00 27.57           O  
ATOM   1403  N   LEU   194      11.785  50.196  15.335  1.00 25.02           N  
ATOM   1404  CA  LEU   194      12.666  49.029  15.119  1.00 22.05           C  
ATOM   1405  C   LEU   194      13.431  48.669  16.374  1.00 21.47           C  
ATOM   1406  O   LEU   194      14.097  49.519  16.968  1.00 20.52           O  
ATOM   1407  CB  LEU   194      13.667  49.268  13.981  1.00 22.03           C  
ATOM   1408  CG  LEU   194      13.115  49.448  12.567  1.00 21.92           C  
ATOM   1409  CD1 LEU   194      14.218  49.717  11.554  1.00 21.24           C  
ATOM   1410  CD2 LEU   194      12.268  48.216  12.181  1.00 19.60           C  
ATOM   1411  N   ALA   195      13.359  47.408  16.768  1.00 19.34           N  
ATOM   1412  CA  ALA   195      14.067  46.936  17.943  1.00 18.73           C  
ATOM   1413  C   ALA   195      15.570  46.801  17.690  1.00 18.18           C  
ATOM   1414  O   ALA   195      16.388  46.907  18.607  1.00 18.05           O  
ATOM   1415  CB  ALA   195      13.484  45.595  18.409  1.00 18.89           C  
ATOM   1416  N   ALA   196      15.917  46.565  16.437  1.00 16.89           N  
ATOM   1417  CA  ALA   196      17.301  46.288  16.039  1.00 15.01           C  
ATOM   1418  C   ALA   196      17.445  46.486  14.517  1.00 14.33           C  
ATOM   1419  O   ALA   196      16.454  46.568  13.795  1.00 13.96           O  
ATOM   1420  CB  ALA   196      17.727  44.886  16.457  1.00 15.92           C  
ATOM   1421  N   SER   197      18.707  46.610  14.069  1.00 13.64           N  
ATOM   1422  CA  SER   197      19.075  46.758  12.665  1.00 13.45           C  
ATOM   1423  C   SER   197      20.336  45.904  12.511  1.00 13.46           C  
ATOM   1424  O   SER   197      21.446  46.289  12.920  1.00 13.37           O  
ATOM   1425  CB  SER   197      19.358  48.221  12.305  1.00 13.58           C  
ATOM   1426  OG  SER   197      19.622  48.367  10.900  1.00 14.68           O  
ATOM   1427  N   VAL   198      20.138  44.726  11.921  1.00 13.15           N  
ATOM   1428  CA  VAL   198      21.175  43.684  11.893  1.00 13.08           C  
ATOM   1429  C   VAL   198      21.837  43.708  10.520  1.00 13.08           C  
ATOM   1430  O   VAL   198      21.150  43.812   9.488  1.00 13.79           O  
ATOM   1431  CB  VAL   198      20.539  42.297  12.111  1.00 12.94           C  
ATOM   1432  CG1 VAL   198      21.583  41.206  11.969  1.00 13.89           C  
ATOM   1433  CG2 VAL   198      19.785  42.182  13.457  1.00 12.57           C  
ATOM   1434  N   LEU   199      23.165  43.640  10.519  1.00 12.11           N  
ATOM   1435  CA  LEU   199      23.944  43.552   9.280  1.00 11.62           C  
ATOM   1436  C   LEU   199      24.484  42.142   9.161  1.00 11.23           C  
ATOM   1437  O   LEU   199      25.156  41.672  10.058  1.00 11.71           O  
ATOM   1438  CB  LEU   199      25.143  44.520   9.306  1.00 12.31           C  
ATOM   1439  CG  LEU   199      26.104  44.482   8.086  1.00 11.66           C  
ATOM   1440  CD1 LEU   199      25.454  44.717   6.697  1.00 13.39           C  
ATOM   1441  CD2 LEU   199      27.300  45.506   8.317  1.00 12.95           C  
ATOM   1442  N   VAL   200      24.258  41.507   8.006  1.00 10.78           N  
ATOM   1443  CA  VAL   200      24.776  40.120   7.811  1.00  8.76           C  
ATOM   1444  C   VAL   200      25.585  40.101   6.520  1.00  9.38           C  
ATOM   1445  O   VAL   200      25.108  40.550   5.475  1.00 10.10           O  
ATOM   1446  CB  VAL   200      23.609  39.072   7.698  1.00  8.66           C  
ATOM   1447  CG1 VAL   200      24.164  37.703   7.228  1.00  8.33           C  
ATOM   1448  CG2 VAL   200      22.846  38.947   9.017  1.00 10.38           C  
ATOM   1449  N   VAL   201      26.812  39.596   6.594  1.00  9.43           N  
ATOM   1450  CA  VAL   201      27.621  39.452   5.399  1.00  8.97           C  
ATOM   1451  C   VAL   201      27.796  37.959   5.116  1.00  9.62           C  
ATOM   1452  O   VAL   201      28.275  37.211   5.968  1.00  7.86           O  
ATOM   1453  CB  VAL   201      28.996  40.116   5.547  1.00  9.59           C  
ATOM   1454  CG1 VAL   201      29.874  39.759   4.306  1.00  9.68           C  
ATOM   1455  CG2 VAL   201      28.800  41.646   5.700  1.00 11.12           C  
ATOM   1456  N   SER   202      27.426  37.544   3.899  1.00  9.31           N  
ATOM   1457  CA  SER   202      27.409  36.101   3.605  1.00  8.95           C  
ATOM   1458  C   SER   202      27.682  35.867   2.128  1.00  9.16           C  
ATOM   1459  O   SER   202      28.438  36.636   1.488  1.00 10.38           O  
ATOM   1460  CB  SER   202      26.058  35.492   4.096  1.00  8.93           C  
ATOM   1461  OG  SER   202      25.903  34.092   3.831  1.00 10.01           O  
ATOM   1462  N   HIS   203      27.061  34.814   1.570  1.00 10.13           N  
ATOM   1463  CA  HIS   203      27.535  34.249   0.316  1.00  9.52           C  
ATOM   1464  C   HIS   203      26.367  34.086  -0.635  1.00 10.30           C  
ATOM   1465  O   HIS   203      25.216  33.917  -0.171  1.00  9.32           O  
ATOM   1466  CB  HIS   203      28.166  32.852   0.589  1.00  9.59           C  
ATOM   1467  CG  HIS   203      29.341  32.879   1.531  1.00  7.84           C  
ATOM   1468  ND1 HIS   203      30.649  32.959   1.093  1.00  9.11           N  
ATOM   1469  CD2 HIS   203      29.401  32.780   2.882  1.00 10.71           C  
ATOM   1470  CE1 HIS   203      31.465  32.895   2.139  1.00  9.53           C  
ATOM   1471  NE2 HIS   203      30.731  32.788   3.237  1.00  8.48           N  
ATOM   1472  N   GLY   204      26.642  34.041  -1.948  1.00  9.69           N  
ATOM   1473  CA  GLY   204      25.503  34.073  -2.911  1.00  9.75           C  
ATOM   1474  C   GLY   204      24.522  32.906  -2.808  1.00  9.54           C  
ATOM   1475  O   GLY   204      23.329  33.126  -2.661  1.00  9.85           O  
ATOM   1476  N   ALA   205      25.014  31.678  -2.814  1.00  9.62           N  
ATOM   1477  CA  ALA   205      24.075  30.533  -2.842  1.00  8.60           C  
ATOM   1478  C   ALA   205      23.305  30.459  -1.523  1.00  9.84           C  
ATOM   1479  O   ALA   205      22.099  30.182  -1.506  1.00  9.20           O  
ATOM   1480  CB  ALA   205      24.798  29.203  -3.200  1.00 11.04           C  
ATOM   1481  N   TYR   206      24.010  30.687  -0.419  1.00  8.72           N  
ATOM   1482  CA  TYR   206      23.350  30.676   0.884  1.00  8.73           C  
ATOM   1483  C   TYR   206      22.268  31.735   0.959  1.00  8.56           C  
ATOM   1484  O   TYR   206      21.148  31.498   1.465  1.00  8.88           O  
ATOM   1485  CB  TYR   206      24.384  30.938   1.962  1.00  7.66           C  
ATOM   1486  CG  TYR   206      23.785  30.956   3.365  1.00  9.51           C  
ATOM   1487  CD1 TYR   206      23.564  29.772   4.063  1.00  7.24           C  
ATOM   1488  CD2 TYR   206      23.374  32.155   3.961  1.00 10.79           C  
ATOM   1489  CE1 TYR   206      23.034  29.805   5.359  1.00 10.51           C  
ATOM   1490  CE2 TYR   206      22.854  32.198   5.246  1.00 11.50           C  
ATOM   1491  CZ  TYR   206      22.699  31.025   5.941  1.00 10.75           C  
ATOM   1492  OH  TYR   206      22.157  31.087   7.208  1.00 10.83           O  
ATOM   1493  N   MET   207      22.618  32.922   0.472  1.00  7.25           N  
ATOM   1494  CA  MET   207      21.640  34.024   0.460  1.00  9.04           C  
ATOM   1495  C   MET   207      20.403  33.663  -0.376  1.00  8.99           C  
ATOM   1496  O   MET   207      19.240  33.915   0.050  1.00 11.12           O  
ATOM   1497  CB  MET   207      22.287  35.307   0.016  1.00  8.31           C  
ATOM   1498  CG  MET   207      23.162  35.904   1.145  1.00  8.70           C  
ATOM   1499  SD  MET   207      24.421  37.241   0.441  1.00 11.06          SE  
ATOM   1500  CE  MET   207      23.098  38.585  -0.024  1.00 13.46           C  
ATOM   1501  N   ARG   208      20.636  33.083  -1.535  1.00 10.61           N  
ATOM   1502  CA  ARG   208      19.503  32.741  -2.425  1.00  9.90           C  
ATOM   1503  C   ARG   208      18.536  31.785  -1.713  1.00 11.11           C  
ATOM   1504  O   ARG   208      17.295  31.938  -1.782  1.00 11.37           O  
ATOM   1505  CB  ARG   208      20.015  32.179  -3.743  1.00 12.27           C  
ATOM   1506  CG  ARG   208      20.585  33.343  -4.610  1.00 15.78           C  
ATOM   1507  CD  ARG   208      20.941  32.873  -6.042  1.00 16.42           C  
ATOM   1508  NE  ARG   208      22.040  31.918  -6.103  1.00 17.26           N  
ATOM   1509  CZ  ARG   208      23.330  32.252  -6.152  1.00 16.45           C  
ATOM   1510  NH1 ARG   208      23.690  33.522  -6.102  1.00 17.32           N  
ATOM   1511  NH2 ARG   208      24.268  31.307  -6.225  1.00 17.91           N  
ATOM   1512  N   SER   209      19.091  30.845  -0.973  1.00  9.56           N  
ATOM   1513  CA  SER   209      18.271  29.853  -0.265  1.00 10.25           C  
ATOM   1514  C   SER   209      17.548  30.490   0.896  1.00 10.33           C  
ATOM   1515  O   SER   209      16.381  30.164   1.185  1.00 11.28           O  
ATOM   1516  CB  SER   209      19.144  28.705   0.232  1.00 11.33           C  
ATOM   1517  OG  SER   209      19.516  27.853  -0.832  1.00 13.34           O  
ATOM   1518  N   LEU   210      18.242  31.401   1.590  1.00 10.38           N  
ATOM   1519  CA  LEU   210      17.569  32.130   2.698  1.00  8.87           C  
ATOM   1520  C   LEU   210      16.428  32.977   2.120  1.00  9.51           C  
ATOM   1521  O   LEU   210      15.323  32.988   2.670  1.00  9.92           O  
ATOM   1522  CB  LEU   210      18.623  32.968   3.434  1.00  9.32           C  
ATOM   1523  CG  LEU   210      18.048  33.840   4.556  1.00  9.09           C  
ATOM   1524  CD1 LEU   210      17.590  32.951   5.718  1.00 10.71           C  
ATOM   1525  CD2 LEU   210      19.140  34.878   5.001  1.00 10.89           C  
ATOM   1526  N   PHE   211      16.667  33.630   0.980  1.00  9.30           N  
ATOM   1527  CA  PHE   211      15.672  34.526   0.423  1.00 10.50           C  
ATOM   1528  C   PHE   211      14.498  33.663  -0.069  1.00  9.99           C  
ATOM   1529  O   PHE   211      13.333  34.056   0.074  1.00  9.59           O  
ATOM   1530  CB  PHE   211      16.256  35.373  -0.710  1.00  9.65           C  
ATOM   1531  CG  PHE   211      17.358  36.303  -0.267  1.00 10.52           C  
ATOM   1532  CD1 PHE   211      17.539  36.610   1.083  1.00 11.62           C  
ATOM   1533  CD2 PHE   211      18.194  36.871  -1.203  1.00 14.73           C  
ATOM   1534  CE1 PHE   211      18.576  37.453   1.488  1.00 15.33           C  
ATOM   1535  CE2 PHE   211      19.217  37.745  -0.808  1.00 15.53           C  
ATOM   1536  CZ  PHE   211      19.387  38.034   0.550  1.00 13.13           C  
ATOM   1537  N   ASP   212      14.806  32.486  -0.590  1.00 10.28           N  
ATOM   1538  CA  ASP   212      13.733  31.557  -0.956  1.00 10.45           C  
ATOM   1539  C   ASP   212      12.895  31.125   0.242  1.00 10.32           C  
ATOM   1540  O   ASP   212      11.673  31.044   0.154  1.00  9.93           O  
ATOM   1541  CB  ASP   212      14.257  30.322  -1.670  1.00 11.35           C  
ATOM   1542  CG  ASP   212      13.113  29.499  -2.281  1.00 14.19           C  
ATOM   1543  OD1 ASP   212      12.306  30.036  -3.060  1.00 18.34           O  
ATOM   1544  OD2 ASP   212      12.958  28.348  -1.923  1.00 19.95           O  
ATOM   1545  N   TYR   213      13.533  30.877   1.375  1.00  9.34           N  
ATOM   1546  CA  TYR   213      12.773  30.636   2.621  1.00  9.28           C  
ATOM   1547  C   TYR   213      11.844  31.819   2.913  1.00 10.01           C  
ATOM   1548  O   TYR   213      10.654  31.633   3.166  1.00  9.71           O  
ATOM   1549  CB  TYR   213      13.741  30.430   3.765  1.00 10.44           C  
ATOM   1550  CG  TYR   213      13.072  30.316   5.104  1.00  9.68           C  
ATOM   1551  CD1 TYR   213      12.126  29.302   5.346  1.00 11.69           C  
ATOM   1552  CD2 TYR   213      13.423  31.187   6.162  1.00 11.29           C  
ATOM   1553  CE1 TYR   213      11.512  29.192   6.584  1.00 14.86           C  
ATOM   1554  CE2 TYR   213      12.818  31.065   7.378  1.00 12.39           C  
ATOM   1555  CZ  TYR   213      11.875  30.086   7.587  1.00 15.18           C  
ATOM   1556  OH  TYR   213      11.328  29.987   8.860  1.00 18.19           O  
ATOM   1557  N   PHE   214      12.362  33.044   2.825  1.00  9.20           N  
ATOM   1558  CA  PHE   214      11.530  34.208   3.131  1.00  9.42           C  
ATOM   1559  C   PHE   214      10.352  34.318   2.171  1.00 10.67           C  
ATOM   1560  O   PHE   214       9.267  34.633   2.596  1.00 10.12           O  
ATOM   1561  CB  PHE   214      12.333  35.500   3.002  1.00  9.95           C  
ATOM   1562  CG  PHE   214      13.394  35.690   4.060  1.00  8.70           C  
ATOM   1563  CD1 PHE   214      13.403  34.963   5.244  1.00  8.58           C  
ATOM   1564  CD2 PHE   214      14.387  36.661   3.852  1.00 10.59           C  
ATOM   1565  CE1 PHE   214      14.396  35.198   6.210  1.00 10.02           C  
ATOM   1566  CE2 PHE   214      15.386  36.898   4.808  1.00 10.61           C  
ATOM   1567  CZ  PHE   214      15.385  36.182   5.976  1.00 11.62           C  
ATOM   1568  N   LEU   215      10.583  34.056   0.879  1.00 10.25           N  
ATOM   1569  CA  LEU   215       9.506  34.231  -0.114  1.00 10.38           C  
ATOM   1570  C   LEU   215       8.566  33.038  -0.161  1.00 10.77           C  
ATOM   1571  O   LEU   215       7.339  33.174   0.017  1.00 11.28           O  
ATOM   1572  CB  LEU   215      10.121  34.485  -1.488  1.00 10.63           C  
ATOM   1573  CG  LEU   215       9.069  34.627  -2.612  1.00  9.43           C  
ATOM   1574  CD1 LEU   215       8.138  35.785  -2.313  1.00 12.74           C  
ATOM   1575  CD2 LEU   215       9.785  34.860  -3.967  1.00 12.27           C  
ATOM   1576  N   THR   216       9.131  31.865  -0.398  1.00 11.00           N  
ATOM   1577  CA  THR   216       8.307  30.671  -0.567  1.00 12.81           C  
ATOM   1578  C   THR   216       7.626  30.239   0.730  1.00 12.62           C  
ATOM   1579  O   THR   216       6.467  29.852   0.720  1.00 13.60           O  
ATOM   1580  CB  THR   216       9.152  29.534  -1.189  1.00 12.36           C  
ATOM   1581  OG1 THR   216       9.636  29.972  -2.460  1.00 14.69           O  
ATOM   1582  CG2 THR   216       8.319  28.262  -1.368  1.00 14.27           C  
ATOM   1583  N   ASP   217       8.359  30.285   1.847  1.00 13.20           N  
ATOM   1584  CA  ASP   217       7.882  29.746   3.104  1.00 12.92           C  
ATOM   1585  C   ASP   217       7.256  30.784   4.037  1.00 13.22           C  
ATOM   1586  O   ASP   217       6.143  30.582   4.550  1.00 15.48           O  
ATOM   1587  CB  ASP   217       9.011  28.934   3.761  1.00 13.79           C  
ATOM   1588  CG  ASP   217       9.519  27.832   2.822  1.00 16.22           C  
ATOM   1589  OD1 ASP   217       8.673  27.023   2.386  1.00 18.83           O  
ATOM   1590  OD2 ASP   217      10.702  27.797   2.466  1.00 15.17           O  
ATOM   1591  N   LEU   218       7.916  31.930   4.212  1.00 10.94           N  
ATOM   1592  CA  LEU   218       7.348  32.985   5.050  1.00 11.53           C  
ATOM   1593  C   LEU   218       6.392  33.937   4.297  1.00 11.62           C  
ATOM   1594  O   LEU   218       5.723  34.808   4.914  1.00 12.88           O  
ATOM   1595  CB  LEU   218       8.481  33.745   5.769  1.00 11.54           C  
ATOM   1596  CG  LEU   218       9.332  32.906   6.752  1.00 12.78           C  
ATOM   1597  CD1 LEU   218      10.272  33.818   7.514  1.00 12.03           C  
ATOM   1598  CD2 LEU   218       8.443  32.131   7.731  1.00 15.13           C  
ATOM   1599  N   LYS   219       6.339  33.766   2.979  1.00 11.24           N  
ATOM   1600  CA  LYS   219       5.419  34.528   2.134  1.00 12.22           C  
ATOM   1601  C   LYS   219       5.700  36.040   2.224  1.00 12.08           C  
ATOM   1602  O   LYS   219       4.752  36.851   2.263  1.00 12.49           O  
ATOM   1603  CB  LYS   219       3.949  34.225   2.515  1.00 14.45           C  
ATOM   1604  CG  LYS   219       3.542  32.732   2.601  1.00 17.85           C  
ATOM   1605  CD  LYS   219       3.793  31.984   1.282  1.00 19.35           C  
ATOM   1606  CE  LYS   219       3.347  30.499   1.371  1.00 22.17           C  
ATOM   1607  NZ  LYS   219       3.656  29.950   2.699  1.00 27.12           N  
ATOM   1608  N   CYS   220       7.000  36.404   2.185  1.00 11.26           N  
ATOM   1609  CA  CYS   220       7.395  37.824   2.261  0.80 11.17           C  
ATOM   1611  C   CYS   220       6.842  38.615   1.085  1.00 11.75           C  
ATOM   1612  O   CYS   220       6.593  38.082  -0.005  1.00 11.77           O  
ATOM   1613  CB  CYS   220       8.907  38.003   2.340  0.80 11.41           C  
ATOM   1615  SG  CYS   220       9.772  37.747   0.774  0.80 12.73           S  
ATOM   1617  N   SER   221       6.585  39.897   1.334  1.00 12.01           N  
ATOM   1618  CA  SER   221       6.150  40.778   0.265  1.00 13.09           C  
ATOM   1619  C   SER   221       7.377  41.226  -0.550  1.00 14.04           C  
ATOM   1620  O   SER   221       8.492  41.258  -0.029  1.00 14.60           O  
ATOM   1621  CB  SER   221       5.389  41.968   0.837  1.00 13.77           C  
ATOM   1622  OG  SER   221       6.180  42.739   1.729  1.00 13.35           O  
ATOM   1623  N   LEU   222       7.165  41.555  -1.822  1.00 15.54           N  
ATOM   1624  CA  LEU   222       8.265  41.947  -2.720  1.00 17.54           C  
ATOM   1625  C   LEU   222       7.970  43.329  -3.322  1.00 19.60           C  
ATOM   1626  O   LEU   222       6.825  43.619  -3.649  1.00 20.17           O  
ATOM   1627  CB  LEU   222       8.395  40.946  -3.869  1.00 17.61           C  
ATOM   1628  CG  LEU   222       8.783  39.513  -3.568  1.00 18.69           C  
ATOM   1629  CD1 LEU   222       8.813  38.720  -4.849  1.00 19.94           C  
ATOM   1630  CD2 LEU   222      10.141  39.432  -2.857  1.00 20.71           C  
ATOM   1631  N   PRO   223       9.006  44.170  -3.499  1.00 22.05           N  
ATOM   1632  CA  PRO   223       8.735  45.432  -4.199  1.00 23.24           C  
ATOM   1633  C   PRO   223       8.219  45.147  -5.644  1.00 24.73           C  
ATOM   1634  O   PRO   223       8.453  44.071  -6.172  1.00 23.36           O  
ATOM   1635  CB  PRO   223      10.102  46.129  -4.224  1.00 22.98           C  
ATOM   1636  CG  PRO   223      10.992  45.386  -3.256  1.00 23.58           C  
ATOM   1637  CD  PRO   223      10.414  43.998  -3.114  1.00 22.06           C  
ATOM   1638  N   ALA   224       7.538  46.118  -6.255  1.00 26.52           N  
ATOM   1639  CA  ALA   224       7.013  45.993  -7.628  1.00 27.20           C  
ATOM   1640  C   ALA   224       8.122  45.798  -8.679  1.00 27.32           C  
ATOM   1641  O   ALA   224       7.891  45.228  -9.744  1.00 27.65           O  
ATOM   1642  CB  ALA   224       6.187  47.210  -7.969  1.00 27.94           C  
ATOM   1643  N   THR   225       9.320  46.257  -8.349  1.00 27.06           N  
ATOM   1644  CA  THR   225      10.485  46.172  -9.227  1.00 27.45           C  
ATOM   1645  C   THR   225      11.260  44.855  -9.100  1.00 26.00           C  
ATOM   1646  O   THR   225      12.251  44.629  -9.804  1.00 26.66           O  
ATOM   1647  CB  THR   225      11.428  47.339  -8.900  1.00 28.46           C  
ATOM   1648  OG1 THR   225      11.377  47.607  -7.486  1.00 31.78           O  
ATOM   1649  CG2 THR   225      10.985  48.581  -9.650  1.00 30.14           C  
ATOM   1650  N   LEU   226      10.828  43.975  -8.199  1.00 23.06           N  
ATOM   1651  CA  LEU   226      11.565  42.749  -7.951  0.70 22.35           C  
ATOM   1653  C   LEU   226      10.794  41.516  -8.397  1.00 22.73           C  
ATOM   1654  O   LEU   226       9.766  41.165  -7.805  1.00 23.06           O  
ATOM   1655  CB  LEU   226      11.915  42.621  -6.462  0.70 22.21           C  
ATOM   1657  CG  LEU   226      12.645  41.357  -6.011  0.70 21.36           C  
ATOM   1659  CD1 LEU   226      14.027  41.305  -6.595  0.70 19.42           C  
ATOM   1661  CD2 LEU   226      12.727  41.337  -4.500  0.70 21.10           C  
ATOM   1663  N   SER   227      11.318  40.850  -9.417  1.00 21.25           N  
ATOM   1664  CA  SER   227      10.727  39.614  -9.908  1.00 20.51           C  
ATOM   1665  C   SER   227      11.064  38.461  -8.957  1.00 20.26           C  
ATOM   1666  O   SER   227      12.080  38.498  -8.239  1.00 19.13           O  
ATOM   1667  CB  SER   227      11.282  39.296 -11.304  1.00 20.26           C  
ATOM   1668  OG  SER   227      12.667  39.041 -11.219  1.00 20.10           O  
ATOM   1669  N   ARG   228      10.236  37.418  -8.960  1.00 20.07           N  
ATOM   1670  CA  ARG   228      10.622  36.175  -8.282  1.00 19.92           C  
ATOM   1671  C   ARG   228      11.911  35.579  -8.856  1.00 20.94           C  
ATOM   1672  O   ARG   228      12.730  35.000  -8.118  1.00 20.58           O  
ATOM   1673  CB  ARG   228       9.483  35.143  -8.344  1.00 19.92           C  
ATOM   1674  CG  ARG   228       8.135  35.696  -7.878  1.00 20.51           C  
ATOM   1675  CD  ARG   228       7.076  34.614  -7.959  1.00 21.49           C  
ATOM   1676  NE  ARG   228       7.084  33.695  -6.813  1.00 21.75           N  
ATOM   1677  CZ  ARG   228       6.488  33.960  -5.648  1.00 21.92           C  
ATOM   1678  NH1 ARG   228       6.549  33.053  -4.678  1.00 21.92           N  
ATOM   1679  NH2 ARG   228       5.858  35.129  -5.441  1.00 19.45           N  
ATOM   1680  N   SER   229      12.135  35.746 -10.171  1.00 20.25           N  
ATOM   1681  CA  SER   229      13.321  35.200 -10.798  1.00 20.93           C  
ATOM   1682  C   SER   229      14.635  35.825 -10.306  1.00 20.97           C  
ATOM   1683  O   SER   229      15.655  35.134 -10.249  1.00 20.98           O  
ATOM   1684  CB  SER   229      13.227  35.330 -12.319  1.00 21.06           C  
ATOM   1685  OG  SER   229      12.191  34.481 -12.787  1.00 21.93           O  
ATOM   1686  N   GLU   230      14.582  37.105  -9.951  1.00 21.77           N  
ATOM   1687  CA  GLU   230      15.745  37.842  -9.443  1.00 23.44           C  
ATOM   1688  C   GLU   230      16.241  37.121  -8.208  1.00 24.30           C  
ATOM   1689  O   GLU   230      17.427  36.822  -8.038  1.00 23.11           O  
ATOM   1690  CB  GLU   230      15.327  39.232  -8.986  1.00 24.88           C  
ATOM   1691  CG  GLU   230      16.446  39.964  -8.211  1.00 25.43           C  
ATOM   1692  CD  GLU   230      17.011  41.126  -8.957  1.00 26.89           C  
ATOM   1693  OE1 GLU   230      16.267  41.704  -9.768  1.00 24.08           O  
ATOM   1694  OE2 GLU   230      18.173  41.500  -8.684  1.00 27.40           O  
ATOM   1695  N   LEU   231      15.273  36.842  -7.355  1.00 24.65           N  
ATOM   1696  CA  LEU   231      15.505  36.472  -5.987  1.00 27.37           C  
ATOM   1697  C   LEU   231      16.227  35.128  -5.920  1.00 29.19           C  
ATOM   1698  O   LEU   231      17.116  34.926  -5.074  1.00 30.79           O  
ATOM   1699  CB  LEU   231      14.133  36.437  -5.258  1.00 26.15           C  
ATOM   1700  CG  LEU   231      14.103  35.965  -3.808  1.00 25.48           C  
ATOM   1701  CD1 LEU   231      13.097  36.817  -3.039  1.00 24.11           C  
ATOM   1702  CD2 LEU   231      13.722  34.484  -3.709  1.00 24.46           C  
ATOM   1703  N   MET   232      15.892  34.259  -6.869  1.00 31.30           N  
ATOM   1704  CA  MET   232      16.273  32.841  -6.802  0.50 32.60           C  
ATOM   1706  C   MET   232      17.579  32.519  -7.520  1.00 32.66           C  
ATOM   1707  O   MET   232      18.270  31.545  -7.156  1.00 33.58           O  
ATOM   1708  CB  MET   232      15.130  31.960  -7.316  0.50 32.48           C  
ATOM   1710  CG  MET   232      13.833  32.197  -6.556  0.50 33.23           C  
ATOM   1712  SD  MET   232      12.288  31.294  -7.301  0.50 34.88          SE  
ATOM   1714  CE  MET   232      12.824  29.439  -6.973  0.50 35.68           C  
ATOM   1716  N   SER   233      17.902  33.327  -8.515  1.00 32.34           N  
ATOM   1717  CA  SER   233      19.173  33.283  -9.197  1.00 32.73           C  
ATOM   1718  C   SER   233      19.526  34.735  -9.260  1.00 32.27           C  
ATOM   1719  O   SER   233      18.661  35.516  -9.653  1.00 33.00           O  
ATOM   1720  CB  SER   233      19.010  32.787 -10.617  1.00 33.04           C  
ATOM   1721  OG  SER   233      18.096  33.619 -11.336  1.00 37.07           O  
ATOM   1722  N   VAL   234      20.759  35.092  -8.861  1.00 30.11           N  
ATOM   1723  CA  VAL   234      21.353  36.417  -9.039  1.00 29.06           C  
ATOM   1724  C   VAL   234      21.759  36.972  -7.668  1.00 27.42           C  
ATOM   1725  O   VAL   234      20.861  37.292  -6.847  1.00 27.92           O  
ATOM   1726  CB  VAL   234      20.401  37.472  -9.761  1.00 30.12           C  
ATOM   1727  CG1 VAL   234      21.032  38.881  -9.755  1.00 32.18           C  
ATOM   1728  CG2 VAL   234      20.084  37.050 -11.177  1.00 30.59           C  
ATOM   1729  N   THR   235      23.084  37.044  -7.414  1.00 24.54           N  
ATOM   1730  CA  THR   235      23.611  37.828  -6.274  1.00 21.55           C  
ATOM   1731  C   THR   235      24.970  38.463  -6.580  1.00 20.36           C  
ATOM   1732  O   THR   235      25.994  37.787  -6.534  1.00 20.67           O  
ATOM   1733  CB  THR   235      23.793  36.967  -4.996  1.00 20.99           C  
ATOM   1734  OG1 THR   235      22.701  36.060  -4.860  1.00 21.81           O  
ATOM   1735  CG2 THR   235      23.909  37.893  -3.732  1.00 19.10           C  
ATOM   1736  N   PRO   236      24.994  39.767  -6.880  1.00 18.67           N  
ATOM   1737  CA  PRO   236      26.263  40.458  -7.209  1.00 17.30           C  
ATOM   1738  C   PRO   236      27.175  40.544  -5.981  1.00 16.11           C  
ATOM   1739  O   PRO   236      26.660  40.543  -4.861  1.00 15.24           O  
ATOM   1740  CB  PRO   236      25.813  41.883  -7.586  1.00 18.40           C  
ATOM   1741  CG  PRO   236      24.320  41.835  -7.742  1.00 19.11           C  
ATOM   1742  CD  PRO   236      23.824  40.662  -6.942  1.00 18.91           C  
ATOM   1743  N   ASN   237      28.495  40.623  -6.184  1.00 15.37           N  
ATOM   1744  CA  ASN   237      29.410  40.915  -5.067  1.00 14.60           C  
ATOM   1745  C   ASN   237      29.053  42.256  -4.406  1.00 13.70           C  
ATOM   1746  O   ASN   237      28.875  43.267  -5.093  1.00 15.31           O  
ATOM   1747  CB  ASN   237      30.871  40.917  -5.503  1.00 14.73           C  
ATOM   1748  CG  ASN   237      31.377  39.526  -5.865  1.00 15.52           C  
ATOM   1749  OD1 ASN   237      31.642  39.260  -7.037  1.00 19.53           O  
ATOM   1750  ND2 ASN   237      31.449  38.610  -4.870  1.00 14.35           N  
ATOM   1751  N   THR   238      28.974  42.244  -3.083  1.00 12.97           N  
ATOM   1752  CA  THR   238      28.441  43.358  -2.231  1.00 12.00           C  
ATOM   1753  C   THR   238      27.022  43.852  -2.533  1.00 13.36           C  
ATOM   1754  O   THR   238      26.633  44.940  -2.108  1.00 13.65           O  
ATOM   1755  CB  THR   238      29.436  44.556  -2.091  1.00 12.82           C  
ATOM   1756  OG1 THR   238      29.545  45.243  -3.343  1.00 14.76           O  
ATOM   1757  CG2 THR   238      30.807  44.035  -1.598  1.00 13.59           C  
ATOM   1758  N   GLY   239      26.268  43.034  -3.271  1.00 13.24           N  
ATOM   1759  CA  GLY   239      24.830  43.263  -3.519  1.00 13.93           C  
ATOM   1760  C   GLY   239      24.107  43.245  -2.182  1.00 13.74           C  
ATOM   1761  O   GLY   239      24.339  42.340  -1.368  1.00 14.21           O  
ATOM   1762  N   MET   240      23.242  44.239  -1.966  1.00 12.78           N  
ATOM   1763  CA  MET   240      22.584  44.447  -0.685  1.00 13.58           C  
ATOM   1764  C   MET   240      21.069  44.208  -0.750  1.00 13.24           C  
ATOM   1765  O   MET   240      20.395  44.680  -1.660  1.00 13.69           O  
ATOM   1766  CB  MET   240      22.806  45.896  -0.220  1.00 15.11           C  
ATOM   1767  CG  MET   240      24.272  46.251  -0.086  1.00 15.12           C  
ATOM   1768  SD  MET   240      24.362  48.070   0.611  1.00 18.77          SE  
ATOM   1769  CE  MET   240      26.264  48.246   0.501  1.00 18.08           C  
ATOM   1770  N   SER   241      20.549  43.509   0.255  1.00 13.14           N  
ATOM   1771  CA  SER   241      19.119  43.255   0.356  0.70 12.52           C  
ATOM   1773  C   SER   241      18.692  43.676   1.746  1.00 13.29           C  
ATOM   1774  O   SER   241      19.403  43.434   2.713  1.00 14.20           O  
ATOM   1775  CB  SER   241      18.850  41.760   0.131  0.70 12.45           C  
ATOM   1777  OG  SER   241      19.292  41.387  -1.161  0.70 10.80           O  
ATOM   1779  N   LEU   242      17.529  44.328   1.846  1.00 12.23           N  
ATOM   1780  CA  LEU   242      16.979  44.770   3.117  1.00 12.90           C  
ATOM   1781  C   LEU   242      15.586  44.170   3.282  1.00 11.83           C  
ATOM   1782  O   LEU   242      14.755  44.272   2.345  1.00 12.05           O  
ATOM   1783  CB  LEU   242      16.875  46.318   3.160  1.00 13.04           C  
ATOM   1784  CG  LEU   242      16.191  46.884   4.429  1.00 15.99           C  
ATOM   1785  CD1 LEU   242      16.974  46.593   5.720  1.00 15.29           C  
ATOM   1786  CD2 LEU   242      16.016  48.428   4.269  1.00 14.21           C  
ATOM   1787  N   PHE   243      15.361  43.622   4.482  1.00 11.67           N  
ATOM   1788  CA  PHE   243      14.080  43.045   4.930  1.00 12.76           C  
ATOM   1789  C   PHE   243      13.642  43.680   6.256  1.00 12.46           C  
ATOM   1790  O   PHE   243      14.480  43.930   7.155  1.00 12.87           O  
ATOM   1791  CB  PHE   243      14.219  41.532   5.128  1.00 12.81           C  
ATOM   1792  CG  PHE   243      14.701  40.822   3.892  1.00 13.64           C  
ATOM   1793  CD1 PHE   243      13.810  40.355   2.948  1.00 14.82           C  
ATOM   1794  CD2 PHE   243      16.068  40.676   3.672  1.00 15.31           C  
ATOM   1795  CE1 PHE   243      14.283  39.710   1.748  1.00 14.92           C  
ATOM   1796  CE2 PHE   243      16.548  40.066   2.540  1.00 12.18           C  
ATOM   1797  CZ  PHE   243      15.672  39.588   1.565  1.00 10.84           C  
ATOM   1798  N   ILE   244      12.335  43.896   6.398  1.00 12.62           N  
ATOM   1799  CA  ILE   244      11.789  44.211   7.698  1.00 12.69           C  
ATOM   1800  C   ILE   244      11.060  42.959   8.227  1.00 11.90           C  
ATOM   1801  O   ILE   244      10.181  42.396   7.558  1.00 12.22           O  
ATOM   1802  CB  ILE   244      10.846  45.460   7.683  1.00 13.59           C  
ATOM   1803  CG1 ILE   244      11.553  46.710   7.095  1.00 16.20           C  
ATOM   1804  CG2 ILE   244      10.370  45.738   9.092  1.00 14.97           C  
ATOM   1805  CD1 ILE   244      12.795  47.147   7.862  1.00 19.67           C  
ATOM   1806  N   ILE   245      11.453  42.509   9.412  1.00 11.60           N  
ATOM   1807  CA  ILE   245      10.858  41.320  10.032  1.00 11.68           C  
ATOM   1808  C   ILE   245       9.879  41.784  11.105  1.00 13.67           C  
ATOM   1809  O   ILE   245      10.246  42.595  11.946  1.00 13.43           O  
ATOM   1810  CB  ILE   245      11.944  40.445  10.706  1.00 11.82           C  
ATOM   1811  CG1 ILE   245      13.184  40.245   9.781  1.00 12.57           C  
ATOM   1812  CG2 ILE   245      11.358  39.134  11.191  1.00 13.22           C  
ATOM   1813  CD1 ILE   245      12.849  39.659   8.365  1.00 14.11           C  
ATOM   1814  N   ASN   246       8.674  41.220  11.116  1.00 12.98           N  
ATOM   1815  CA  ASN   246       7.570  41.742  11.953  1.00 14.16           C  
ATOM   1816  C   ASN   246       6.988  40.612  12.804  1.00 14.34           C  
ATOM   1817  O   ASN   246       6.585  39.556  12.275  1.00 13.56           O  
ATOM   1818  CB  ASN   246       6.425  42.270  11.045  1.00 15.39           C  
ATOM   1819  CG  ASN   246       6.871  43.351  10.067  1.00 18.81           C  
ATOM   1820  OD1 ASN   246       7.381  43.092   8.938  1.00 23.58           O  
ATOM   1821  ND2 ASN   246       6.644  44.593  10.475  1.00 22.31           N  
ATOM   1822  N   PHE   247       6.923  40.822  14.127  1.00 15.67           N  
ATOM   1823  CA  PHE   247       6.282  39.853  14.997  1.00 16.23           C  
ATOM   1824  C   PHE   247       5.077  40.508  15.677  1.00 18.30           C  
ATOM   1825  O   PHE   247       5.220  41.540  16.320  1.00 17.11           O  
ATOM   1826  CB  PHE   247       7.234  39.383  16.116  1.00 17.45           C  
ATOM   1827  CG  PHE   247       8.305  38.430  15.667  1.00 16.77           C  
ATOM   1828  CD1 PHE   247       8.106  37.063  15.754  1.00 17.77           C  
ATOM   1829  CD2 PHE   247       9.519  38.909  15.190  1.00 19.72           C  
ATOM   1830  CE1 PHE   247       9.088  36.164  15.310  1.00 19.81           C  
ATOM   1831  CE2 PHE   247      10.509  38.024  14.758  1.00 17.22           C  
ATOM   1832  CZ  PHE   247      10.293  36.657  14.829  1.00 18.61           C  
ATOM   1833  N   GLU   248       3.923  39.876  15.551  1.00 19.35           N  
ATOM   1834  CA  GLU   248       2.781  40.197  16.416  1.00 22.23           C  
ATOM   1835  C   GLU   248       3.103  39.774  17.853  1.00 22.71           C  
ATOM   1836  O   GLU   248       4.013  38.979  18.080  1.00 20.96           O  
ATOM   1837  CB  GLU   248       1.532  39.491  15.889  1.00 22.61           C  
ATOM   1838  CG  GLU   248       0.932  40.248  14.695  1.00 25.01           C  
ATOM   1839  CD  GLU   248      -0.290  39.602  14.050  1.00 26.62           C  
ATOM   1840  OE1 GLU   248      -0.802  38.579  14.550  1.00 32.28           O  
ATOM   1841  OE2 GLU   248      -0.744  40.145  13.015  1.00 33.12           O  
ATOM   1842  N   GLU   249       2.374  40.335  18.822  1.00 24.15           N  
ATOM   1843  CA  GLU   249       2.566  39.933  20.207  1.00 26.26           C  
ATOM   1844  C   GLU   249       2.084  38.503  20.390  1.00 24.94           C  
ATOM   1845  O   GLU   249       1.216  38.006  19.641  1.00 24.12           O  
ATOM   1846  CB  GLU   249       1.843  40.888  21.148  1.00 25.98           C  
ATOM   1847  CG  GLU   249       0.531  40.375  21.742  1.00 31.22           C  
ATOM   1848  CD  GLU   249      -0.230  41.493  22.450  1.00 30.94           C  
ATOM   1849  OE1 GLU   249       0.432  42.430  22.991  1.00 38.11           O  
ATOM   1850  OE2 GLU   249      -1.481  41.457  22.429  1.00 37.68           O  
ATOM   1851  N   GLY   250       2.678  37.831  21.362  1.00 24.73           N  
ATOM   1852  CA  GLY   250       2.268  36.496  21.738  1.00 25.76           C  
ATOM   1853  C   GLY   250       3.414  35.552  21.992  1.00 25.75           C  
ATOM   1854  O   GLY   250       4.567  35.989  22.161  1.00 25.79           O  
ATOM   1855  N   ARG   251       3.088  34.256  22.015  1.00 26.24           N  
ATOM   1856  CA  ARG   251       4.046  33.166  22.217  1.00 27.25           C  
ATOM   1857  C   ARG   251       4.241  32.399  20.920  1.00 27.77           C  
ATOM   1858  O   ARG   251       3.263  32.141  20.216  1.00 28.46           O  
ATOM   1859  CB  ARG   251       3.515  32.186  23.283  1.00 27.24           C  
ATOM   1860  CG  ARG   251       3.140  32.856  24.591  1.00 28.49           C  
ATOM   1861  CD  ARG   251       2.561  31.859  25.640  1.00 28.57           C  
ATOM   1862  NE  ARG   251       1.780  32.587  26.639  1.00 33.40           N  
ATOM   1863  CZ  ARG   251       2.276  33.080  27.773  1.00 34.86           C  
ATOM   1864  NH1 ARG   251       3.558  32.901  28.084  1.00 34.71           N  
ATOM   1865  NH2 ARG   251       1.480  33.746  28.602  1.00 36.04           N  
ATOM   1866  N   GLU   252       5.493  32.042  20.616  1.00 27.82           N  
ATOM   1867  CA  GLU   252       5.857  31.247  19.428  1.00 28.91           C  
ATOM   1868  C   GLU   252       5.214  31.815  18.146  1.00 26.70           C  
ATOM   1869  O   GLU   252       4.576  31.089  17.373  1.00 27.41           O  
ATOM   1870  CB  GLU   252       5.455  29.774  19.617  1.00 28.85           C  
ATOM   1871  CG  GLU   252       6.465  28.782  19.055  1.00 32.65           C  
ATOM   1872  CD  GLU   252       6.321  27.363  19.621  1.00 32.84           C  
ATOM   1873  OE1 GLU   252       7.240  26.561  19.360  1.00 40.25           O  
ATOM   1874  OE2 GLU   252       5.302  27.029  20.290  1.00 38.53           O  
ATOM   1875  N   VAL   253       5.371  33.117  17.958  1.00 25.17           N  
ATOM   1876  CA  VAL   253       4.775  33.851  16.836  1.00 22.77           C  
ATOM   1877  C   VAL   253       5.595  33.691  15.556  1.00 21.79           C  
ATOM   1878  O   VAL   253       6.816  33.855  15.559  1.00 21.90           O  
ATOM   1879  CB  VAL   253       4.580  35.341  17.196  1.00 22.33           C  
ATOM   1880  CG1 VAL   253       4.074  36.171  15.993  1.00 21.72           C  
ATOM   1881  CG2 VAL   253       3.605  35.476  18.387  1.00 24.21           C  
ATOM   1882  N   LYS   254       4.895  33.354  14.475  1.00 20.12           N  
ATOM   1883  CA  LYS   254       5.478  33.286  13.146  1.00 18.03           C  
ATOM   1884  C   LYS   254       5.614  34.706  12.594  1.00 17.17           C  
ATOM   1885  O   LYS   254       4.621  35.404  12.471  1.00 16.18           O  
ATOM   1886  CB  LYS   254       4.570  32.497  12.207  1.00 19.08           C  
ATOM   1887  CG  LYS   254       5.238  32.176  10.891  1.00 19.33           C  
ATOM   1888  CD  LYS   254       4.260  31.439   9.948  1.00 26.85           C  
ATOM   1889  CE  LYS   254       4.926  31.017   8.656  1.00 30.92           C  
ATOM   1890  NZ  LYS   254       3.996  30.199   7.841  1.00 34.45           N  
ATOM   1891  N   PRO   255       6.841  35.118  12.235  1.00 15.86           N  
ATOM   1892  CA  PRO   255       6.987  36.492  11.743  1.00 14.73           C  
ATOM   1893  C   PRO   255       6.441  36.684  10.334  1.00 14.00           C  
ATOM   1894  O   PRO   255       6.259  35.704   9.594  1.00 15.12           O  
ATOM   1895  CB  PRO   255       8.517  36.704  11.706  1.00 14.51           C  
ATOM   1896  CG  PRO   255       9.068  35.329  11.521  1.00 15.15           C  
ATOM   1897  CD  PRO   255       8.117  34.382  12.249  1.00 16.49           C  
ATOM   1898  N   THR   256       6.163  37.928   9.982  1.00 13.78           N  
ATOM   1899  CA  THR   256       5.953  38.277   8.570  1.00 13.57           C  
ATOM   1900  C   THR   256       7.164  39.079   8.096  1.00 13.58           C  
ATOM   1901  O   THR   256       7.872  39.668   8.915  1.00 14.02           O  
ATOM   1902  CB  THR   256       4.658  39.061   8.380  1.00 13.94           C  
ATOM   1903  OG1 THR   256       4.633  40.216   9.244  1.00 15.02           O  
ATOM   1904  CG2 THR   256       3.466  38.145   8.671  1.00 14.83           C  
ATOM   1905  N   VAL   257       7.398  39.098   6.782  1.00 11.39           N  
ATOM   1906  CA  VAL   257       8.633  39.673   6.254  1.00 11.79           C  
ATOM   1907  C   VAL   257       8.275  40.582   5.067  1.00 12.49           C  
ATOM   1908  O   VAL   257       7.431  40.238   4.259  1.00 11.88           O  
ATOM   1909  CB  VAL   257       9.603  38.560   5.797  1.00 12.20           C  
ATOM   1910  CG1 VAL   257      10.891  39.173   5.158  1.00 12.84           C  
ATOM   1911  CG2 VAL   257       9.926  37.554   6.989  1.00 11.37           C  
ATOM   1912  N   GLN   258       8.886  41.761   5.028  1.00 12.80           N  
ATOM   1913  CA  GLN   258       8.757  42.676   3.898  1.00 14.83           C  
ATOM   1914  C   GLN   258      10.146  42.821   3.279  1.00 13.10           C  
ATOM   1915  O   GLN   258      11.081  43.235   3.951  1.00 13.61           O  
ATOM   1916  CB  GLN   258       8.279  44.066   4.374  1.00 15.18           C  
ATOM   1917  CG  GLN   258       6.887  44.059   4.975  1.00 18.60           C  
ATOM   1918  CD  GLN   258       6.563  45.334   5.754  1.00 21.61           C  
ATOM   1919  OE1 GLN   258       7.172  45.643   6.800  1.00 26.56           O  
ATOM   1920  NE2 GLN   258       5.584  46.086   5.239  1.00 28.76           N  
ATOM   1921  N   CYS   259      10.274  42.453   2.014  1.00 13.04           N  
ATOM   1922  CA  CYS   259      11.499  42.712   1.287  1.00 12.61           C  
ATOM   1923  C   CYS   259      11.459  44.148   0.753  1.00 13.03           C  
ATOM   1924  O   CYS   259      10.541  44.511  -0.009  1.00 14.63           O  
ATOM   1925  CB  CYS   259      11.669  41.726   0.144  1.00 13.09           C  
ATOM   1926  SG  CYS   259      13.167  42.105  -0.790  1.00 14.63           S  
ATOM   1927  N   ILE   260      12.415  44.952   1.191  1.00 13.62           N  
ATOM   1928  CA  ILE   260      12.519  46.388   0.817  1.00 14.08           C  
ATOM   1929  C   ILE   260      13.311  46.576  -0.486  1.00 15.41           C  
ATOM   1930  O   ILE   260      12.898  47.347  -1.378  1.00 15.09           O  
ATOM   1931  CB  ILE   260      13.128  47.246   1.960  1.00 14.59           C  
ATOM   1932  CG1 ILE   260      12.328  47.110   3.275  1.00 13.59           C  
ATOM   1933  CG2 ILE   260      13.302  48.705   1.519  1.00 15.12           C  
ATOM   1934  CD1 ILE   260      10.798  47.437   3.184  1.00 17.11           C  
ATOM   1935  N   CYS   261      14.436  45.867  -0.603  1.00 14.81           N  
ATOM   1936  CA  CYS   261      15.202  45.843  -1.858  1.00 15.96           C  
ATOM   1937  C   CYS   261      16.019  44.575  -1.893  1.00 16.00           C  
ATOM   1938  O   CYS   261      16.188  43.935  -0.853  1.00 16.30           O  
ATOM   1939  CB  CYS   261      16.111  47.071  -1.964  1.00 16.22           C  
ATOM   1940  SG  CYS   261      17.350  47.186  -0.680  1.00 20.19           S  
ATOM   1941  N   MET   262      16.475  44.188  -3.076  1.00 16.20           N  
ATOM   1942  CA  MET   262      17.340  43.008  -3.196  1.00 17.67           C  
ATOM   1943  C   MET   262      18.416  43.285  -4.214  1.00 17.67           C  
ATOM   1944  O   MET   262      18.147  43.915  -5.245  1.00 17.51           O  
ATOM   1945  CB  MET   262      16.526  41.772  -3.601  1.00 17.55           C  
ATOM   1946  CG  MET   262      17.351  40.476  -3.744  1.00 20.14           C  
ATOM   1947  SD  MET   262      16.188  38.954  -3.853  1.00 20.86          SE  
ATOM   1948  CE  MET   262      15.557  39.102  -2.039  1.00 21.38           C  
ATOM   1949  N   ASN   263      19.633  42.828  -3.916  1.00 16.44           N  
ATOM   1950  CA  ASN   263      20.752  42.967  -4.856  1.00 17.08           C  
ATOM   1951  C   ASN   263      21.022  44.425  -5.263  1.00 18.00           C  
ATOM   1952  O   ASN   263      21.442  44.694  -6.418  1.00 19.37           O  
ATOM   1953  CB  ASN   263      20.519  42.091  -6.092  1.00 16.01           C  
ATOM   1954  CG  ASN   263      20.470  40.618  -5.748  1.00 17.20           C  
ATOM   1955  OD1 ASN   263      21.136  40.190  -4.797  1.00 16.42           O  
ATOM   1956  ND2 ASN   263      19.749  39.824  -6.544  1.00 20.11           N  
ATOM   1957  N   LEU   264      20.781  45.343  -4.337  1.00 18.06           N  
ATOM   1958  CA  LEU   264      21.088  46.764  -4.563  1.00 20.40           C  
ATOM   1959  C   LEU   264      22.596  46.926  -4.814  1.00 21.29           C  
ATOM   1960  O   LEU   264      23.418  46.399  -4.050  1.00 20.30           O  
ATOM   1961  CB  LEU   264      20.687  47.612  -3.350  1.00 20.35           C  
ATOM   1962  CG  LEU   264      20.446  49.114  -3.581  1.00 23.12           C  
ATOM   1963  CD1 LEU   264      19.371  49.296  -4.670  1.00 24.12           C  
ATOM   1964  CD2 LEU   264      20.018  49.775  -2.298  1.00 21.83           C  
ATOM   1965  N   GLN   265      22.955  47.657  -5.874  1.00 22.67           N  
ATOM   1966  CA  GLN   265      24.380  47.952  -6.140  1.00 25.66           C  
ATOM   1967  C   GLN   265      24.668  49.436  -6.393  1.00 26.47           C  
ATOM   1968  O   GLN   265      25.604  49.743  -7.139  1.00 27.18           O  
ATOM   1969  CB  GLN   265      24.925  47.188  -7.351  1.00 25.38           C  
ATOM   1970  CG  GLN   265      24.243  45.906  -7.762  1.00 28.61           C  
ATOM   1971  CD  GLN   265      24.906  45.265  -8.962  1.00 28.26           C  
ATOM   1972  OE1 GLN   265      26.146  45.211  -9.065  1.00 33.40           O  
ATOM   1973  NE2 GLN   265      24.092  44.746  -9.872  1.00 33.70           N  
ATOM   1974  N   ASP   266      23.903  50.326  -5.753  1.00 28.13           N  
ATOM   1975  CA  ASP   266      24.028  51.794  -5.906  1.00 30.32           C  
ATOM   1976  C   ASP   266      25.391  52.326  -5.456  1.00 30.83           C  
ATOM   1977  O   ASP   266      25.838  53.402  -5.891  1.00 31.49           O  
ATOM   1978  CB  ASP   266      22.934  52.499  -5.094  1.00 30.71           C  
ATOM   1979  CG  ASP   266      21.547  52.313  -5.687  1.00 32.76           C  
ATOM   1980  OD1 ASP   266      21.434  51.819  -6.830  1.00 35.90           O  
ATOM   1981  OD2 ASP   266      20.569  52.687  -5.007  1.00 35.33           O  
ATOM   1982  N   HIS   267      26.040  51.590  -4.563  1.00 29.75           N  
ATOM   1983  CA  HIS   267      27.378  51.928  -4.124  1.00 29.59           C  
ATOM   1984  C   HIS   267      28.480  51.599  -5.154  1.00 30.49           C  
ATOM   1985  O   HIS   267      29.633  52.004  -4.962  1.00 31.58           O  
ATOM   1986  CB  HIS   267      27.657  51.216  -2.800  1.00 28.97           C  
ATOM   1987  CG  HIS   267      27.627  49.725  -2.912  1.00 24.06           C  
ATOM   1988  ND1 HIS   267      26.469  49.026  -3.188  1.00 22.05           N  
ATOM   1989  CD2 HIS   267      28.611  48.804  -2.805  1.00 21.74           C  
ATOM   1990  CE1 HIS   267      26.745  47.732  -3.246  1.00 20.69           C  
ATOM   1991  NE2 HIS   267      28.039  47.574  -3.021  1.00 19.76           N  
ATOM   1992  N   LEU   268      28.151  50.870  -6.222  1.00 31.07           N  
ATOM   1993  CA  LEU   268      29.165  50.394  -7.182  1.00 32.45           C  
ATOM   1994  C   LEU   268      29.296  51.186  -8.499  1.00 34.57           C  
ATOM   1995  O   LEU   268      30.254  50.978  -9.247  1.00 34.93           O  
ATOM   1996  CB  LEU   268      28.976  48.905  -7.512  1.00 31.83           C  
ATOM   1997  CG  LEU   268      29.246  47.899  -6.388  1.00 30.13           C  
ATOM   1998  CD1 LEU   268      29.144  46.464  -6.905  1.00 30.71           C  
ATOM   1999  CD2 LEU   268      30.618  48.155  -5.758  1.00 30.78           C  
ATOM   2000  N   ASN   269      28.346  52.062  -8.794  1.00 36.54           N  
ATOM   2001  CA  ASN   269      28.369  52.782 -10.078  1.00 38.57           C  
ATOM   2002  C   ASN   269      29.384  53.929 -10.094  1.00 39.07           C  
ATOM   2003  O   ASN   269      30.600  53.710  -9.978  1.00 39.36           O  
ATOM   2004  CB  ASN   269      26.960  53.264 -10.476  1.00 39.59           C  
ATOM   2005  CG  ASN   269      26.201  53.925  -9.316  1.00 41.98           C  
ATOM   2006  OD1 ASN   269      26.802  54.562  -8.435  1.00 44.75           O  
ATOM   2007  ND2 ASN   269      24.873  53.793  -9.327  1.00 44.56           N  
END
