
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  243 ( 1875),  selected  243 , name 1rii_A
# Molecule2: number of CA atoms  247 ( 1945),  selected  247 , name T0394.pdb
# PARAMETERS: 1rii_A.T0394.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_A      N       1           -
LGA    -       -      L       2           -
LGA    -       -      Y       3           -
LGA    -       -      F       4           -
LGA    -       -      Q       5           -
LGA    -       -      S       6           -
LGA    N     3_A      A       7          3.818
LGA    T     4_A      R       8          1.288
LGA    G     5_A      F       9          1.672
LGA    S     6_A      A      10          1.035
LGA    L     7_A      L      11          0.647
LGA    V     8_A      T      12          0.401
LGA    L     9_A      V      13          0.546
LGA    L    10_A      V      14          0.197
LGA    R    11_A      R      15          0.515
LGA    H    12_A      H      16          1.124
LGA    G    13_A      G      17          2.048
LGA    E    14_A      E      18          1.032
LGA    S    15_A      T      19          0.677
LGA    D    16_A      R      20          1.614
LGA    W    17_A      F      21          1.443
LGA    N    18_A      N      22          1.674
LGA    A    19_A      K      23          2.726
LGA    L    20_A      E      24          3.322
LGA    N    21_A      K      25          2.987
LGA    L    22_A      I      26          1.804
LGA    F    23_A      I      27          1.240
LGA    T    24_A      Q      28          1.352
LGA    G    25_A      G      29          0.879
LGA    W    26_A      Q      30          0.495
LGA    V    27_A      G      31          2.070
LGA    -       -      V      32           -
LGA    D    28_A      D      33          0.658
LGA    V    29_A      E      34          0.565
LGA    G    30_A      P      35          0.687
LGA    L    31_A      L      36          0.643
LGA    T    32_A      S      37          0.632
LGA    D    33_A      E      38          0.505
LGA    K    34_A      T      39          0.411
LGA    G    35_A      G      40          0.824
LGA    Q    36_A      F      41          0.944
LGA    A    37_A      K      42          0.713
LGA    E    38_A      Q      43          0.598
LGA    A    39_A      A      44          0.841
LGA    V    40_A      A      45          1.068
LGA    R    41_A      A      46          1.142
LGA    S    42_A      A      47          1.203
LGA    G    43_A      G      48          1.617
LGA    E    44_A      I      49          1.870
LGA    L    45_A      F      50          1.879
LGA    I    46_A      L      51          2.014
LGA    A    47_A      N      52          2.871
LGA    E    48_A      -       -           -
LGA    H    49_A      -       -           -
LGA    D    50_A      N      53          4.481
LGA    L    51_A      V      54          3.006
LGA    L    52_A      K      55          2.211
LGA    P    53_A      F      56          1.232
LGA    D    54_A      T      57          1.039
LGA    V    55_A      H      58          1.018
LGA    L    56_A      A      59          0.666
LGA    Y    57_A      F      60          0.678
LGA    T    58_A      S      61          0.809
LGA    S    59_A      S      62          0.840
LGA    L    60_A      D      63          1.130
LGA    L    61_A      L      64          0.685
LGA    R    62_A      M      65          0.479
LGA    R    63_A      R      66          0.154
LGA    A    64_A      T      67          0.378
LGA    I    65_A      K      68          0.613
LGA    T    66_A      Q      69          0.458
LGA    T    67_A      T      70          0.309
LGA    A    68_A      M      71          0.399
LGA    H    69_A      H      72          0.613
LGA    L    70_A      G      73          0.390
LGA    A    71_A      I      74          0.661
LGA    L    72_A      L      75          1.084
LGA    D    73_A      E      76          1.238
LGA    S    74_A      R      77          1.575
LGA    A    75_A      S      78          2.018
LGA    D    76_A      K      79          3.309
LGA    -       -      F      80           -
LGA    R    77_A      C      81          1.505
LGA    L    78_A      K      82          2.365
LGA    W    79_A      D      83          1.008
LGA    I    80_A      M      84          1.098
LGA    P    81_A      T      85          2.123
LGA    V    82_A      V      86          1.734
LGA    R    83_A      K      87          1.169
LGA    R    84_A      Y      88          1.208
LGA    S    85_A      D      89          1.382
LGA    W    86_A      S      90          1.244
LGA    R    87_A      R      91          0.877
LGA    L    88_A      L      92          0.490
LGA    N    89_A      R      93          0.394
LGA    E    90_A      E      94          0.358
LGA    R    91_A      R      95          0.375
LGA    H    92_A      K      96          0.419
LGA    Y    93_A      Y      97          0.639
LGA    G    94_A      G      98          1.315
LGA    A    95_A      V      99          0.964
LGA    L    96_A      V     100          0.570
LGA    Q    97_A      E     101          0.575
LGA    G    98_A      G     102          1.646
LGA    L    99_A      K     103          1.403
LGA    D   100_A      A     104          2.172
LGA    K   101_A      L     105          2.498
LGA    A   102_A      S     106          3.804
LGA    E   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    K   105_A      E     107          4.313
LGA    A   106_A      L     108           -
LGA    R   107_A      -       -           -
LGA    Y   108_A      -       -           -
LGA    G   109_A      -       -           -
LGA    E   110_A      -       -           -
LGA    E   111_A      R     109           #
LGA    Q   112_A      A     110          4.479
LGA    F   113_A      M     111           #
LGA    -       -      A     112           -
LGA    -       -      K     113           -
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    -       -      R     116           -
LGA    M   114_A      E     117           #
LGA    A   115_A      E     118          2.213
LGA    W   116_A      C     119          3.638
LGA    R   117_A      P     120          3.571
LGA    R   118_A      -       -           -
LGA    S   119_A      V     121          1.192
LGA    Y   120_A      -       -           -
LGA    D   121_A      -       -           -
LGA    T   122_A      F     122          3.658
LGA    P   123_A      T     123          1.251
LGA    P   124_A      P     124          1.560
LGA    P   125_A      P     125          2.183
LGA    P   126_A      G     126          2.606
LGA    I   127_A      -       -           -
LGA    E   128_A      -       -           -
LGA    R   129_A      -       -           -
LGA    G   130_A      -       -           -
LGA    S   131_A      -       -           -
LGA    Q   132_A      -       -           -
LGA    F   133_A      -       -           -
LGA    S   134_A      -       -           -
LGA    Q   135_A      -       -           -
LGA    D   136_A      -       -           -
LGA    A   137_A      -       -           -
LGA    D   138_A      -       -           -
LGA    P   139_A      -       -           -
LGA    R   140_A      -       -           -
LGA    Y   141_A      -       -           -
LGA    A   142_A      -       -           -
LGA    D   143_A      -       -           -
LGA    I   144_A      -       -           -
LGA    G   145_A      -       -           -
LGA    G   146_A      -       -           -
LGA    G   147_A      -       -           -
LGA    P   148_A      -       -           -
LGA    L   149_A      -       -           -
LGA    T   150_A      G     127          1.244
LGA    E   151_A      E     128          0.767
LGA    C   152_A      T     129          2.012
LGA    L   153_A      L     130          1.709
LGA    A   154_A      D     131          1.125
LGA    D   155_A      Q     132          0.910
LGA    V   156_A      V     133          0.680
LGA    V   157_A      K     134          0.946
LGA    A   158_A      M     135          1.354
LGA    R   159_A      R     136          2.424
LGA    F   160_A      G     137          2.864
LGA    L   161_A      I     138          1.653
LGA    P   162_A      D     139          1.484
LGA    Y   163_A      F     140          2.254
LGA    F   164_A      F     141          1.770
LGA    T   165_A      E     142          0.503
LGA    D   166_A      F     143          1.976
LGA    V   167_A      L     144          3.434
LGA    I   168_A      C     145          4.831
LGA    V   169_A      Q     146          4.745
LGA    G   170_A      L     147          2.730
LGA    D   171_A      I     148          2.085
LGA    L   172_A      -       -           -
LGA    R   173_A      L     149          3.620
LGA    V   174_A      K     150           #
LGA    -       -      E     151           -
LGA    -       -      A     152           -
LGA    -       -      D     153           -
LGA    -       -      Q     154           -
LGA    -       -      K     155           -
LGA    -       -      N     165           -
LGA    -       -      C     166           -
LGA    -       -      L     167           -
LGA    -       -      E     168           -
LGA    -       -      T     169           -
LGA    -       -      S     170           -
LGA    -       -      L     171           -
LGA    -       -      A     172           -
LGA    -       -      E     173           -
LGA    -       -      I     174           -
LGA    -       -      F     175           -
LGA    -       -      P     176           -
LGA    -       -      L     177           -
LGA    -       -      I     191           -
LGA    -       -      P     192           -
LGA    -       -      G     193           -
LGA    -       -      L     194           -
LGA    G   175_A      A     195          0.999
LGA    K   176_A      A     196          1.272
LGA    T   177_A      S     197          0.662
LGA    V   178_A      V     198          0.246
LGA    L   179_A      L     199          0.382
LGA    I   180_A      V     200          0.455
LGA    V   181_A      V     201          0.152
LGA    A   182_A      S     202          0.254
LGA    H   183_A      H     203          0.228
LGA    G   184_A      G     204          0.598
LGA    N   185_A      A     205          1.465
LGA    S   186_A      Y     206          1.436
LGA    L   187_A      M     207          1.211
LGA    R   188_A      R     208          1.410
LGA    A   189_A      S     209          1.972
LGA    L   190_A      L     210          1.609
LGA    V   191_A      F     211          0.973
LGA    K   192_A      D     212          1.393
LGA    H   193_A      Y     213          1.710
LGA    L   194_A      F     214          1.738
LGA    D   195_A      L     215          1.948
LGA    Q   196_A      T     216          2.515
LGA    M   197_A      D     217          5.410
LGA    S   198_A      L     218           -
LGA    D   199_A      K     219           -
LGA    D   200_A      C     220           -
LGA    -       -      S     221           -
LGA    -       -      L     222           -
LGA    -       -      P     223           -
LGA    -       -      A     224           -
LGA    -       -      T     225           -
LGA    -       -      L     226           -
LGA    -       -      S     227           -
LGA    E   201_A      R     228           #
LGA    I   202_A      -       -           -
LGA    V   203_A      -       -           -
LGA    G   204_A      S     229          4.523
LGA    -       -      E     230           -
LGA    -       -      L     231           -
LGA    L   205_A      M     232          1.737
LGA    N   206_A      S     233          3.014
LGA    -       -      V     234           -
LGA    I   207_A      T     235          2.204
LGA    P   208_A      P     236          2.371
LGA    T   209_A      N     237          2.151
LGA    G   210_A      T     238          1.476
LGA    I   211_A      G     239          2.862
LGA    P   212_A      M     240          1.999
LGA    L   213_A      S     241          1.304
LGA    R   214_A      L     242          1.103
LGA    Y   215_A      F     243          0.681
LGA    D   216_A      I     244          1.540
LGA    L   217_A      I     245          1.994
LGA    D   218_A      N     246          1.461
LGA    S   219_A      F     247          1.352
LGA    A   220_A      E     248           #
LGA    -       -      E     249           -
LGA    -       -      G     250           -
LGA    -       -      R     251           -
LGA    -       -      E     252           -
LGA    -       -      V     253           -
LGA    -       -      K     254           -
LGA    M   221_A      P     255          3.050
LGA    R   222_A      T     256          1.573
LGA    P   223_A      V     257          1.607
LGA    L   224_A      Q     258          2.755
LGA    V   225_A      C     259          3.766
LGA    R   226_A      -       -           -
LGA    G   227_A      -       -           -
LGA    G   228_A      I     260          3.097
LGA    T   229_A      C     261          1.454
LGA    Y   230_A      M     262          4.346
LGA    -       -      N     263           -
LGA    L   231_A      L     264          4.970
LGA    -       -      Q     265           -
LGA    D   232_A      D     266          3.357
LGA    P   233_A      H     267           -
LGA    E   234_A      -       -           -
LGA    A   235_A      L     268           #
LGA    A   236_A      -       -           -
LGA    A   237_A      -       -           -
LGA    A   238_A      N     269           #
LGA    G   239_A      -       -           -
LGA    A   240_A      -       -           -
LGA    A   241_A      -       -           -
LGA    A   242_A      -       -           -
LGA    V   243_A      -       -           -
LGA    A   244_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  243  247    5.0    181    1.97    23.76     56.309     8.742

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.949364 * X  +   0.313288 * Y  +  -0.023624 * Z  +  11.107855
  Y_new =  -0.183172 * X  +   0.613021 * Y  +   0.768540 * Z  +  25.488312
  Z_new =   0.255256 * X  +  -0.725297 * Y  +   0.639366 * Z  +  10.062272 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.848284    2.293309  [ DEG:   -48.6031    131.3969 ]
  Theta =  -0.258112   -2.883480  [ DEG:   -14.7888   -165.2112 ]
  Phi   =  -0.190599    2.950993  [ DEG:   -10.9205    169.0795 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1rii_A                                        
REMARK     2: T0394.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1rii_A.T0394.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  243  247   5.0  181   1.97   23.76  56.309
REMARK  ---------------------------------------------------------- 
MOLECULE 1rii_A
HEADER    ISOMERASE                               17-NOV-03   1RII              
TITLE     CRYSTAL STRUCTURE OF PHOSPHOGLYCERATE MUTASE FROM M.                  
TITLE    2 TUBERCULOSIS                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 2,3-BISPHOSPHOGLYCERATE-DEPENDENT                          
COMPND   3 PHOSPHOGLYCERATE MUTASE;                                             
COMPND   4 CHAIN: A, B, C, D;                                                   
COMPND   5 SYNONYM: PHOSPHOGLYCEROMUTASE, PGAM, BPG-DEPENDENT PGAM,             
COMPND   6 DPGM;                                                                
COMPND   7 EC: 5.4.2.1;                                                         
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 GENE: GPMA, GPM, PGM, GPM1, RV0489, MT0508, MTCY20G9.15,             
SOURCE   4 MB0499;                                                              
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21-GOLD (DE3);                           
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET22B                                    
KEYWDS    PHOSPHOGLYERATE MUTASE, SH3 DOMAIN BINDING, STRUCTURAL                
KEYWDS   2 GENOMICS, TBSGC, PROTEIN STRUCTURE INITIATIVE, PSI, TB               
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.MUELLER,M.R.SAWAYA,S.CHAN,Y.WU,I.PASHKOVA,J.PERRY,                  
AUTHOR   2 D.EISENBERG,TB STRUCTURAL GENOMICS CONSORTIUM (TBSGC)                
REVDAT   3   12-APR-05 1RII    1       JRNL                                     
REVDAT   2   01-FEB-05 1RII    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   05-OCT-04 1RII    0                                                
JRNL        AUTH   P.MULLER,M.R.SAWAYA,I.PASHKOV,S.CHAN,C.NGUYEN,Y.WU,          
JRNL        AUTH 2 L.J.PERRY,D.EISENBERG                                        
JRNL        TITL   THE 1.70 ANGSTROMS X-RAY CRYSTAL STRUCTURE OF                
JRNL        TITL 2 MYCOBACTERIUM TUBERCULOSIS PHOSPHOGLYCERATE MUTASE.          
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  61   309 2005              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1RII A    1   249  UNP    P0A5R6   GPMA_MYCTU       1    249             
DBREF  1RII B    1   249  UNP    P0A5R6   GPMA_MYCTU       1    249             
DBREF  1RII C    1   249  UNP    P0A5R6   GPMA_MYCTU       1    249             
DBREF  1RII D    1   249  UNP    P0A5R6   GPMA_MYCTU       1    249             
SEQRES   1 A  265  MET ALA ASN THR GLY SER LEU VAL LEU LEU ARG HIS GLY          
SEQRES   2 A  265  GLU SER ASP TRP ASN ALA LEU ASN LEU PHE THR GLY TRP          
SEQRES   3 A  265  VAL ASP VAL GLY LEU THR ASP LYS GLY GLN ALA GLU ALA          
SEQRES   4 A  265  VAL ARG SER GLY GLU LEU ILE ALA GLU HIS ASP LEU LEU          
SEQRES   5 A  265  PRO ASP VAL LEU TYR THR SER LEU LEU ARG ARG ALA ILE          
SEQRES   6 A  265  THR THR ALA HIS LEU ALA LEU ASP SER ALA ASP ARG LEU          
SEQRES   7 A  265  TRP ILE PRO VAL ARG ARG SER TRP ARG LEU ASN GLU ARG          
SEQRES   8 A  265  HIS TYR GLY ALA LEU GLN GLY LEU ASP LYS ALA GLU THR          
SEQRES   9 A  265  LYS ALA ARG TYR GLY GLU GLU GLN PHE MET ALA TRP ARG          
SEQRES  10 A  265  ARG SER TYR ASP THR PRO PRO PRO PRO ILE GLU ARG GLY          
SEQRES  11 A  265  SER GLN PHE SER GLN ASP ALA ASP PRO ARG TYR ALA ASP          
SEQRES  12 A  265  ILE GLY GLY GLY PRO LEU THR GLU CYS LEU ALA ASP VAL          
SEQRES  13 A  265  VAL ALA ARG PHE LEU PRO TYR PHE THR ASP VAL ILE VAL          
SEQRES  14 A  265  GLY ASP LEU ARG VAL GLY LYS THR VAL LEU ILE VAL ALA          
SEQRES  15 A  265  HIS GLY ASN SER LEU ARG ALA LEU VAL LYS HIS LEU ASP          
SEQRES  16 A  265  GLN MET SER ASP ASP GLU ILE VAL GLY LEU ASN ILE PRO          
SEQRES  17 A  265  THR GLY ILE PRO LEU ARG TYR ASP LEU ASP SER ALA MET          
SEQRES  18 A  265  ARG PRO LEU VAL ARG GLY GLY THR TYR LEU ASP PRO GLU          
SEQRES  19 A  265  ALA ALA ALA ALA GLY ALA ALA ALA VAL ALA GLY GLN GLY          
SEQRES  20 A  265  ARG GLY GLY VAL PRO ARG GLY ALA ALA ALA LEU GLU HIS          
SEQRES  21 A  265  HIS HIS HIS HIS HIS                                          
SEQRES   1 B  265  MET ALA ASN THR GLY SER LEU VAL LEU LEU ARG HIS GLY          
SEQRES   2 B  265  GLU SER ASP TRP ASN ALA LEU ASN LEU PHE THR GLY TRP          
SEQRES   3 B  265  VAL ASP VAL GLY LEU THR ASP LYS GLY GLN ALA GLU ALA          
SEQRES   4 B  265  VAL ARG SER GLY GLU LEU ILE ALA GLU HIS ASP LEU LEU          
SEQRES   5 B  265  PRO ASP VAL LEU TYR THR SER LEU LEU ARG ARG ALA ILE          
SEQRES   6 B  265  THR THR ALA HIS LEU ALA LEU ASP SER ALA ASP ARG LEU          
SEQRES   7 B  265  TRP ILE PRO VAL ARG ARG SER TRP ARG LEU ASN GLU ARG          
SEQRES   8 B  265  HIS TYR GLY ALA LEU GLN GLY LEU ASP LYS ALA GLU THR          
SEQRES   9 B  265  LYS ALA ARG TYR GLY GLU GLU GLN PHE MET ALA TRP ARG          
SEQRES  10 B  265  ARG SER TYR ASP THR PRO PRO PRO PRO ILE GLU ARG GLY          
SEQRES  11 B  265  SER GLN PHE SER GLN ASP ALA ASP PRO ARG TYR ALA ASP          
SEQRES  12 B  265  ILE GLY GLY GLY PRO LEU THR GLU CYS LEU ALA ASP VAL          
SEQRES  13 B  265  VAL ALA ARG PHE LEU PRO TYR PHE THR ASP VAL ILE VAL          
SEQRES  14 B  265  GLY ASP LEU ARG VAL GLY LYS THR VAL LEU ILE VAL ALA          
SEQRES  15 B  265  HIS GLY ASN SER LEU ARG ALA LEU VAL LYS HIS LEU ASP          
SEQRES  16 B  265  GLN MET SER ASP ASP GLU ILE VAL GLY LEU ASN ILE PRO          
SEQRES  17 B  265  THR GLY ILE PRO LEU ARG TYR ASP LEU ASP SER ALA MET          
SEQRES  18 B  265  ARG PRO LEU VAL ARG GLY GLY THR TYR LEU ASP PRO GLU          
SEQRES  19 B  265  ALA ALA ALA ALA GLY ALA ALA ALA VAL ALA GLY GLN GLY          
SEQRES  20 B  265  ARG GLY GLY VAL PRO ARG GLY ALA ALA ALA LEU GLU HIS          
SEQRES  21 B  265  HIS HIS HIS HIS HIS                                          
SEQRES   1 C  265  MET ALA ASN THR GLY SER LEU VAL LEU LEU ARG HIS GLY          
SEQRES   2 C  265  GLU SER ASP TRP ASN ALA LEU ASN LEU PHE THR GLY TRP          
SEQRES   3 C  265  VAL ASP VAL GLY LEU THR ASP LYS GLY GLN ALA GLU ALA          
SEQRES   4 C  265  VAL ARG SER GLY GLU LEU ILE ALA GLU HIS ASP LEU LEU          
SEQRES   5 C  265  PRO ASP VAL LEU TYR THR SER LEU LEU ARG ARG ALA ILE          
SEQRES   6 C  265  THR THR ALA HIS LEU ALA LEU ASP SER ALA ASP ARG LEU          
SEQRES   7 C  265  TRP ILE PRO VAL ARG ARG SER TRP ARG LEU ASN GLU ARG          
SEQRES   8 C  265  HIS TYR GLY ALA LEU GLN GLY LEU ASP LYS ALA GLU THR          
SEQRES   9 C  265  LYS ALA ARG TYR GLY GLU GLU GLN PHE MET ALA TRP ARG          
SEQRES  10 C  265  ARG SER TYR ASP THR PRO PRO PRO PRO ILE GLU ARG GLY          
SEQRES  11 C  265  SER GLN PHE SER GLN ASP ALA ASP PRO ARG TYR ALA ASP          
SEQRES  12 C  265  ILE GLY GLY GLY PRO LEU THR GLU CYS LEU ALA ASP VAL          
SEQRES  13 C  265  VAL ALA ARG PHE LEU PRO TYR PHE THR ASP VAL ILE VAL          
SEQRES  14 C  265  GLY ASP LEU ARG VAL GLY LYS THR VAL LEU ILE VAL ALA          
SEQRES  15 C  265  HIS GLY ASN SER LEU ARG ALA LEU VAL LYS HIS LEU ASP          
SEQRES  16 C  265  GLN MET SER ASP ASP GLU ILE VAL GLY LEU ASN ILE PRO          
SEQRES  17 C  265  THR GLY ILE PRO LEU ARG TYR ASP LEU ASP SER ALA MET          
SEQRES  18 C  265  ARG PRO LEU VAL ARG GLY GLY THR TYR LEU ASP PRO GLU          
SEQRES  19 C  265  ALA ALA ALA ALA GLY ALA ALA ALA VAL ALA GLY GLN GLY          
SEQRES  20 C  265  ARG GLY GLY VAL PRO ARG GLY ALA ALA ALA LEU GLU HIS          
SEQRES  21 C  265  HIS HIS HIS HIS HIS                                          
SEQRES   1 D  265  MET ALA ASN THR GLY SER LEU VAL LEU LEU ARG HIS GLY          
SEQRES   2 D  265  GLU SER ASP TRP ASN ALA LEU ASN LEU PHE THR GLY TRP          
SEQRES   3 D  265  VAL ASP VAL GLY LEU THR ASP LYS GLY GLN ALA GLU ALA          
SEQRES   4 D  265  VAL ARG SER GLY GLU LEU ILE ALA GLU HIS ASP LEU LEU          
SEQRES   5 D  265  PRO ASP VAL LEU TYR THR SER LEU LEU ARG ARG ALA ILE          
SEQRES   6 D  265  THR THR ALA HIS LEU ALA LEU ASP SER ALA ASP ARG LEU          
SEQRES   7 D  265  TRP ILE PRO VAL ARG ARG SER TRP ARG LEU ASN GLU ARG          
SEQRES   8 D  265  HIS TYR GLY ALA LEU GLN GLY LEU ASP LYS ALA GLU THR          
SEQRES   9 D  265  LYS ALA ARG TYR GLY GLU GLU GLN PHE MET ALA TRP ARG          
SEQRES  10 D  265  ARG SER TYR ASP THR PRO PRO PRO PRO ILE GLU ARG GLY          
SEQRES  11 D  265  SER GLN PHE SER GLN ASP ALA ASP PRO ARG TYR ALA ASP          
SEQRES  12 D  265  ILE GLY GLY GLY PRO LEU THR GLU CYS LEU ALA ASP VAL          
SEQRES  13 D  265  VAL ALA ARG PHE LEU PRO TYR PHE THR ASP VAL ILE VAL          
SEQRES  14 D  265  GLY ASP LEU ARG VAL GLY LYS THR VAL LEU ILE VAL ALA          
SEQRES  15 D  265  HIS GLY ASN SER LEU ARG ALA LEU VAL LYS HIS LEU ASP          
SEQRES  16 D  265  GLN MET SER ASP ASP GLU ILE VAL GLY LEU ASN ILE PRO          
SEQRES  17 D  265  THR GLY ILE PRO LEU ARG TYR ASP LEU ASP SER ALA MET          
SEQRES  18 D  265  ARG PRO LEU VAL ARG GLY GLY THR TYR LEU ASP PRO GLU          
SEQRES  19 D  265  ALA ALA ALA ALA GLY ALA ALA ALA VAL ALA GLY GLN GLY          
SEQRES  20 D  265  ARG GLY GLY VAL PRO ARG GLY ALA ALA ALA LEU GLU HIS          
SEQRES  21 D  265  HIS HIS HIS HIS HIS                                          
HET    GOL    501       6                                                       
HET    GOL    502       6                                                       
HET    GOL    503       6                                                       
HET    GOL    504       6                                                       
HET    GOL    505       6                                                       
HETNAM     GOL GLYCEROL                                                         
FORMUL   5  GOL    5(C3 H8 O3)                                                  
FORMUL  10  HOH   *451(H2 O)                                                    
CRYST1   58.914  136.790   65.929  90.00  97.78  90.00 P 1 21 1      8          
ATOM      1  N   ALA A   2      10.049  46.375  21.783  1.00 51.72           N  
ATOM      2  CA  ALA A   2      10.567  47.090  20.628  1.00 52.44           C  
ATOM      3  C   ALA A   2       9.904  46.677  19.317  1.00 50.66           C  
ATOM      4  O   ALA A   2       9.587  45.512  19.102  1.00 50.98           O  
ATOM      5  CB  ALA A   2      12.074  46.866  20.498  1.00 56.84           C  
ATOM      6  N   ASN A   3       9.734  47.670  18.448  1.00 49.13           N  
ATOM      7  CA  ASN A   3       9.382  47.431  17.055  1.00 47.03           C  
ATOM      8  C   ASN A   3      10.518  46.700  16.354  1.00 44.24           C  
ATOM      9  O   ASN A   3      11.687  46.867  16.704  1.00 46.77           O  
ATOM     10  CB  ASN A   3       9.081  48.749  16.340  1.00 48.31           C  
ATOM     11  CG  ASN A   3       7.638  49.137  16.654  1.00 50.28           C  
ATOM     12  OD1 ASN A   3       7.398  49.926  17.563  1.00 55.70           O  
ATOM     13  ND2 ASN A   3       6.725  48.543  15.899  1.00 50.55           N  
ATOM     14  N   THR A   4      10.189  45.878  15.371  1.00 40.47           N  
ATOM     15  CA  THR A   4      11.172  44.985  14.771  1.00 36.86           C  
ATOM     16  C   THR A   4      12.306  45.683  14.038  1.00 32.82           C  
ATOM     17  O   THR A   4      12.114  46.566  13.198  1.00 28.58           O  
ATOM     18  CB  THR A   4      10.405  44.059  13.800  1.00 36.30           C  
ATOM     19  OG1 THR A   4       9.213  43.655  14.485  1.00 41.18           O  
ATOM     20  CG2 THR A   4      11.245  42.852  13.463  1.00 34.72           C  
ATOM     21  N   GLY A   5      13.528  45.254  14.361  1.00 30.36           N  
ATOM     22  CA  GLY A   5      14.735  45.777  13.760  1.00 27.57           C  
ATOM     23  C   GLY A   5      14.819  45.602  12.258  1.00 26.76           C  
ATOM     24  O   GLY A   5      14.218  44.710  11.645  1.00 28.87           O  
ATOM     25  N   SER A   6      15.607  46.478  11.639  1.00 24.70           N  
ATOM     26  CA  SER A   6      15.904  46.364  10.218  1.00 24.50           C  
ATOM     27  C   SER A   6      16.888  45.227   9.982  1.00 24.64           C  
ATOM     28  O   SER A   6      17.862  45.110  10.718  1.00 24.23           O  
ATOM     29  CB  SER A   6      16.525  47.651   9.662  1.00 26.35           C  
ATOM     30  OG  SER A   6      15.564  48.698   9.682  1.00 33.68           O  
ATOM     31  N   LEU A   7      16.627  44.429   8.957  1.00 24.73           N  
ATOM     32  CA  LEU A   7      17.562  43.369   8.600  1.00 23.26           C  
ATOM     33  C   LEU A   7      18.278  43.765   7.315  1.00 25.79           C  
ATOM     34  O   LEU A   7      17.627  44.060   6.315  1.00 26.92           O  
ATOM     35  CB  LEU A   7      16.808  42.066   8.469  1.00 23.24           C  
ATOM     36  CG  LEU A   7      17.591  40.842   7.996  1.00 22.84           C  
ATOM     37  CD1 LEU A   7      18.694  40.526   8.999  1.00 22.88           C  
ATOM     38  CD2 LEU A   7      16.671  39.657   7.793  1.00 23.37           C  
ATOM     39  N   VAL A   8      19.605  43.766   7.345  1.00 24.76           N  
ATOM     40  CA  VAL A   8      20.397  44.143   6.188  1.00 24.44           C  
ATOM     41  C   VAL A   8      21.215  42.967   5.664  1.00 24.23           C  
ATOM     42  O   VAL A   8      22.006  42.436   6.445  1.00 24.82           O  
ATOM     43  CB  VAL A   8      21.385  45.284   6.517  1.00 24.00           C  
ATOM     44  CG1 VAL A   8      22.107  45.703   5.248  1.00 25.66           C  
ATOM     45  CG2 VAL A   8      20.688  46.466   7.161  1.00 32.87           C  
ATOM     46  N   LEU A   9      21.069  42.590   4.402  1.00 23.52           N  
ATOM     47  CA  LEU A   9      21.808  41.459   3.853  1.00 23.18           C  
ATOM     48  C   LEU A   9      22.892  41.951   2.895  1.00 24.31           C  
ATOM     49  O   LEU A   9      22.669  42.866   2.114  1.00 23.91           O  
ATOM     50  CB  LEU A   9      20.854  40.496   3.145  1.00 22.08           C  
ATOM     51  CG  LEU A   9      19.638  39.992   3.920  1.00 22.75           C  
ATOM     52  CD1 LEU A   9      18.977  38.861   3.138  1.00 25.67           C  
ATOM     53  CD2 LEU A   9      20.008  39.539   5.318  1.00 24.48           C  
ATOM     54  N   LEU A  10      24.092  41.364   2.925  1.00 23.50           N  
ATOM     55  CA  LEU A  10      25.172  41.804   2.056  1.00 22.71           C  
ATOM     56  C   LEU A  10      25.964  40.613   1.524  1.00 24.67           C  
ATOM     57  O   LEU A  10      26.514  39.836   2.307  1.00 24.32           O  
ATOM     58  CB  LEU A  10      26.147  42.743   2.773  1.00 23.18           C  
ATOM     59  CG  LEU A  10      27.300  43.262   1.906  1.00 24.91           C  
ATOM     60  CD1 LEU A  10      26.785  43.928   0.637  1.00 24.41           C  
ATOM     61  CD2 LEU A  10      28.176  44.227   2.698  1.00 29.79           C  
ATOM     62  N   ARG A  11      26.010  40.498   0.203  1.00 25.16           N  
ATOM     63  CA  ARG A  11      26.835  39.500  -0.459  1.00 25.96           C  
ATOM     64  C   ARG A  11      28.203  40.069  -0.794  1.00 26.29           C  
ATOM     65  O   ARG A  11      28.387  41.161  -1.337  1.00 24.92           O  
ATOM     66  CB  ARG A  11      26.117  39.002  -1.724  1.00 26.78           C  
ATOM     67  CG  ARG A  11      26.820  37.869  -2.437  1.00 27.72           C  
ATOM     68  CD  ARG A  11      26.152  37.511  -3.760  1.00 30.06           C  
ATOM     69  NE  ARG A  11      26.914  36.441  -4.427  1.00 30.58           N  
ATOM     70  CZ  ARG A  11      26.391  35.631  -5.329  1.00 31.28           C  
ATOM     71  NH1 ARG A  11      25.122  35.763  -5.680  1.00 28.81           N  
ATOM     72  NH2 ARG A  11      27.123  34.673  -5.901  1.00 36.60           N  
ATOM     73  N   HIS A  12      29.246  39.299  -0.457  1.00 26.63           N  
ATOM     74  CA  HIS A  12      30.606  39.744  -0.749  1.00 24.27           C  
ATOM     75  C   HIS A  12      30.882  39.807  -2.244  1.00 25.04           C  
ATOM     76  O   HIS A  12      30.227  39.179  -3.063  1.00 24.15           O  
ATOM     77  CB  HIS A  12      31.616  38.821  -0.078  1.00 23.49           C  
ATOM     78  CG  HIS A  12      31.659  37.424  -0.609  1.00 24.68           C  
ATOM     79  ND1 HIS A  12      32.340  37.105  -1.764  1.00 25.21           N  
ATOM     80  CD2 HIS A  12      31.141  36.256  -0.159  1.00 25.55           C  
ATOM     81  CE1 HIS A  12      32.229  35.824  -2.007  1.00 26.13           C  
ATOM     82  NE2 HIS A  12      31.502  35.275  -1.049  1.00 26.27           N  
ATOM     83  N   GLY A  13      31.907  40.582  -2.582  1.00 27.77           N  
ATOM     84  CA  GLY A  13      32.310  40.761  -3.961  1.00 27.46           C  
ATOM     85  C   GLY A  13      33.351  39.750  -4.395  1.00 28.25           C  
ATOM     86  O   GLY A  13      33.528  38.693  -3.792  1.00 27.83           O  
ATOM     87  N   GLU A  14      34.047  40.092  -5.473  1.00 28.79           N  
ATOM     88  CA  GLU A  14      34.954  39.196  -6.161  1.00 29.77           C  
ATOM     89  C   GLU A  14      36.079  38.623  -5.315  1.00 28.32           C  
ATOM     90  O   GLU A  14      36.838  39.362  -4.684  1.00 29.90           O  
ATOM     91  CB  GLU A  14      35.588  39.942  -7.355  1.00 31.93           C  
ATOM     92  CG  GLU A  14      36.443  39.027  -8.231  1.00 32.58           C  
ATOM     93  CD  GLU A  14      37.194  39.803  -9.297  1.00 33.75           C  
ATOM     94  OE1 GLU A  14      37.894  40.761  -8.920  1.00 27.98           O  
ATOM     95  OE2 GLU A  14      37.079  39.453 -10.491  1.00 38.02           O  
ATOM     96  N   SER A  15      36.211  37.292  -5.337  1.00 27.04           N  
ATOM     97  CA  SER A  15      37.333  36.634  -4.697  1.00 28.76           C  
ATOM     98  C   SER A  15      38.441  36.261  -5.671  1.00 29.73           C  
ATOM     99  O   SER A  15      38.257  36.201  -6.889  1.00 31.09           O  
ATOM    100  CB  SER A  15      36.848  35.337  -4.028  1.00 30.07           C  
ATOM    101  OG  SER A  15      36.837  34.277  -4.992  1.00 28.96           O  
ATOM    102  N   ASP A  16      39.621  35.961  -5.143  1.00 29.38           N  
ATOM    103  CA  ASP A  16      40.713  35.486  -5.987  1.00 31.07           C  
ATOM    104  C   ASP A  16      40.309  34.279  -6.837  1.00 30.64           C  
ATOM    105  O   ASP A  16      40.812  34.076  -7.942  1.00 31.29           O  
ATOM    106  CB  ASP A  16      41.923  35.116  -5.128  1.00 30.80           C  
ATOM    107  CG  ASP A  16      42.511  36.237  -4.311  1.00 32.50           C  
ATOM    108  OD1 ASP A  16      42.478  37.400  -4.762  1.00 33.12           O  
ATOM    109  OD2 ASP A  16      43.033  35.959  -3.203  1.00 37.64           O  
ATOM    110  N   TRP A  17      39.399  33.433  -6.351  1.00 28.47           N  
ATOM    111  CA  TRP A  17      38.985  32.259  -7.118  1.00 27.58           C  
ATOM    112  C   TRP A  17      37.886  32.593  -8.114  1.00 28.68           C  
ATOM    113  O   TRP A  17      37.809  31.852  -9.110  1.00 31.92           O  
ATOM    114  CB  TRP A  17      38.569  31.104  -6.202  1.00 26.06           C  
ATOM    115  CG  TRP A  17      39.746  30.263  -5.792  1.00 25.77           C  
ATOM    116  CD1 TRP A  17      41.046  30.670  -5.725  1.00 26.46           C  
ATOM    117  CD2 TRP A  17      39.747  28.885  -5.392  1.00 26.30           C  
ATOM    118  NE1 TRP A  17      41.867  29.639  -5.313  1.00 26.51           N  
ATOM    119  CE2 TRP A  17      41.079  28.531  -5.103  1.00 26.22           C  
ATOM    120  CE3 TRP A  17      38.741  27.919  -5.254  1.00 26.72           C  
ATOM    121  CZ2 TRP A  17      41.439  27.252  -4.681  1.00 25.73           C  
ATOM    122  CZ3 TRP A  17      39.104  26.651  -4.839  1.00 25.88           C  
ATOM    123  CH2 TRP A  17      40.438  26.329  -4.558  1.00 25.72           C  
ATOM    124  N   ASN A  18      37.090  33.636  -7.885  1.00 27.94           N  
ATOM    125  CA  ASN A  18      36.161  34.102  -8.907  1.00 29.68           C  
ATOM    126  C   ASN A  18      36.986  34.536 -10.126  1.00 32.27           C  
ATOM    127  O   ASN A  18      36.677  34.193 -11.262  1.00 35.43           O  
ATOM    128  CB  ASN A  18      35.280  35.256  -8.453  1.00 30.46           C  
ATOM    129  CG  ASN A  18      34.386  34.943  -7.271  1.00 32.97           C  
ATOM    130  OD1 ASN A  18      34.085  35.821  -6.453  1.00 34.13           O  
ATOM    131  ND2 ASN A  18      33.953  33.694  -7.134  1.00 28.13           N  
ATOM    132  N   ALA A  19      38.039  35.286  -9.826  1.00 33.88           N  
ATOM    133  CA  ALA A  19      38.978  35.777 -10.822  1.00 36.19           C  
ATOM    134  C   ALA A  19      39.677  34.635 -11.549  1.00 38.70           C  
ATOM    135  O   ALA A  19      39.994  34.763 -12.742  1.00 43.92           O  
ATOM    136  CB  ALA A  19      39.981  36.712 -10.156  1.00 31.66           C  
ATOM    137  N   LEU A  20      39.933  33.493 -10.908  1.00 37.00           N  
ATOM    138  CA  LEU A  20      40.548  32.401 -11.669  1.00 38.08           C  
ATOM    139  C   LEU A  20      39.524  31.423 -12.236  1.00 36.25           C  
ATOM    140  O   LEU A  20      39.914  30.406 -12.815  1.00 37.03           O  
ATOM    141  CB  LEU A  20      41.524  31.629 -10.789  1.00 38.76           C  
ATOM    142  CG  LEU A  20      42.633  32.425 -10.107  1.00 40.58           C  
ATOM    143  CD1 LEU A  20      43.182  31.671  -8.906  1.00 42.88           C  
ATOM    144  CD2 LEU A  20      43.758  32.749 -11.086  1.00 41.46           C  
ATOM    145  N   ASN A  21      38.243  31.703 -12.061  1.00 33.97           N  
ATOM    146  CA  ASN A  21      37.151  30.860 -12.517  1.00 36.02           C  
ATOM    147  C   ASN A  21      37.108  29.477 -11.879  1.00 35.01           C  
ATOM    148  O   ASN A  21      36.781  28.507 -12.578  1.00 35.39           O  
ATOM    149  CB  ASN A  21      37.260  30.681 -14.039  1.00 39.77           C  
ATOM    150  CG  ASN A  21      35.941  30.285 -14.671  1.00 43.05           C  
ATOM    151  OD1 ASN A  21      35.918  29.647 -15.726  1.00 49.50           O  
ATOM    152  ND2 ASN A  21      34.855  30.671 -14.012  1.00 41.24           N  
ATOM    153  N   LEU A  22      37.420  29.364 -10.595  1.00 31.50           N  
ATOM    154  CA  LEU A  22      37.420  28.072  -9.914  1.00 32.05           C  
ATOM    155  C   LEU A  22      36.223  27.955  -8.972  1.00 33.64           C  
ATOM    156  O   LEU A  22      35.848  28.957  -8.355  1.00 33.38           O  
ATOM    157  CB  LEU A  22      38.698  27.852  -9.105  1.00 33.87           C  
ATOM    158  CG  LEU A  22      40.051  27.881  -9.814  1.00 37.60           C  
ATOM    159  CD1 LEU A  22      41.202  27.630  -8.852  1.00 40.99           C  
ATOM    160  CD2 LEU A  22      40.092  26.852 -10.945  1.00 35.09           C  
ATOM    161  N   PHE A  23      35.648  26.758  -8.872  1.00 31.94           N  
ATOM    162  CA  PHE A  23      34.619  26.460  -7.880  1.00 30.15           C  
ATOM    163  C   PHE A  23      35.215  26.641  -6.486  1.00 26.82           C  
ATOM    164  O   PHE A  23      36.263  26.088  -6.190  1.00 27.99           O  
ATOM    165  CB  PHE A  23      34.100  25.040  -8.045  1.00 32.46           C  
ATOM    166  CG  PHE A  23      33.259  24.743  -9.278  1.00 32.91           C  
ATOM    167  CD1 PHE A  23      32.002  25.300  -9.432  1.00 33.80           C  
ATOM    168  CD2 PHE A  23      33.729  23.892 -10.263  1.00 33.49           C  
ATOM    169  CE1 PHE A  23      31.222  25.010 -10.538  1.00 33.83           C  
ATOM    170  CE2 PHE A  23      32.964  23.594 -11.377  1.00 33.69           C  
ATOM    171  CZ  PHE A  23      31.705  24.147 -11.502  1.00 33.30           C  
ATOM    172  N   THR A  24      34.614  27.409  -5.591  1.00 29.54           N  
ATOM    173  CA  THR A  24      35.224  27.697  -4.292  1.00 28.24           C  
ATOM    174  C   THR A  24      34.589  26.968  -3.116  1.00 26.78           C  
ATOM    175  O   THR A  24      35.273  26.240  -2.391  1.00 27.03           O  
ATOM    176  CB  THR A  24      35.135  29.216  -4.024  1.00 28.11           C  
ATOM    177  OG1 THR A  24      35.690  29.892  -5.151  1.00 28.50           O  
ATOM    178  CG2 THR A  24      35.941  29.605  -2.791  1.00 27.01           C  
ATOM    179  N   GLY A  25      33.294  27.178  -2.896  1.00 26.99           N  
ATOM    180  CA  GLY A  25      32.603  26.541  -1.779  1.00 27.05           C  
ATOM    181  C   GLY A  25      33.201  26.997  -0.450  1.00 28.82           C  
ATOM    182  O   GLY A  25      33.300  28.198  -0.203  1.00 25.82           O  
ATOM    183  N   TRP A  26      33.601  26.016   0.357  1.00 28.74           N  
ATOM    184  CA  TRP A  26      34.144  26.285   1.686  1.00 25.35           C  
ATOM    185  C   TRP A  26      35.621  26.611   1.622  1.00 24.85           C  
ATOM    186  O   TRP A  26      36.248  26.912   2.644  1.00 25.98           O  
ATOM    187  CB  TRP A  26      33.878  25.091   2.607  1.00 24.73           C  
ATOM    188  CG  TRP A  26      32.461  25.001   3.112  1.00 22.32           C  
ATOM    189  CD1 TRP A  26      31.324  25.482   2.542  1.00 22.54           C  
ATOM    190  CD2 TRP A  26      32.028  24.377   4.328  1.00 23.63           C  
ATOM    191  NE1 TRP A  26      30.211  25.202   3.311  1.00 22.63           N  
ATOM    192  CE2 TRP A  26      30.620  24.521   4.418  1.00 23.87           C  
ATOM    193  CE3 TRP A  26      32.708  23.710   5.345  1.00 24.50           C  
ATOM    194  CZ2 TRP A  26      29.898  24.016   5.495  1.00 24.41           C  
ATOM    195  CZ3 TRP A  26      31.980  23.211   6.409  1.00 24.11           C  
ATOM    196  CH2 TRP A  26      30.596  23.367   6.472  1.00 24.27           C  
ATOM    197  N   VAL A  27      36.244  26.552   0.447  1.00 24.69           N  
ATOM    198  CA  VAL A  27      37.664  26.909   0.394  1.00 23.62           C  
ATOM    199  C   VAL A  27      37.785  28.369   0.802  1.00 21.77           C  
ATOM    200  O   VAL A  27      37.051  29.202   0.278  1.00 24.66           O  
ATOM    201  CB  VAL A  27      38.299  26.686  -0.986  1.00 26.28           C  
ATOM    202  CG1 VAL A  27      39.713  27.257  -1.018  1.00 24.10           C  
ATOM    203  CG2 VAL A  27      38.270  25.204  -1.340  1.00 25.44           C  
ATOM    204  N   ASP A  28      38.667  28.658   1.743  1.00 21.30           N  
ATOM    205  CA  ASP A  28      38.733  29.969   2.373  1.00 22.92           C  
ATOM    206  C   ASP A  28      39.594  31.007   1.674  1.00 24.44           C  
ATOM    207  O   ASP A  28      40.539  31.559   2.248  1.00 25.79           O  
ATOM    208  CB  ASP A  28      39.224  29.764   3.825  1.00 25.47           C  
ATOM    209  CG  ASP A  28      38.789  30.898   4.730  1.00 26.45           C  
ATOM    210  OD1 ASP A  28      37.943  31.701   4.294  1.00 25.27           O  
ATOM    211  OD2 ASP A  28      39.292  30.972   5.873  1.00 28.40           O  
ATOM    212  N   VAL A  29      39.237  31.321   0.429  1.00 25.04           N  
ATOM    213  CA  VAL A  29      39.933  32.286  -0.415  1.00 26.27           C  
ATOM    214  C   VAL A  29      39.654  33.725  -0.001  1.00 25.86           C  
ATOM    215  O   VAL A  29      38.603  34.017   0.564  1.00 26.11           O  
ATOM    216  CB  VAL A  29      39.524  32.098  -1.885  1.00 28.60           C  
ATOM    217  CG1 VAL A  29      40.317  32.996  -2.814  1.00 41.07           C  
ATOM    218  CG2 VAL A  29      39.736  30.641  -2.288  1.00 36.60           C  
ATOM    219  N   GLY A  30      40.591  34.599  -0.302  1.00 27.74           N  
ATOM    220  CA  GLY A  30      40.552  36.021  -0.087  1.00 27.71           C  
ATOM    221  C   GLY A  30      39.853  36.775  -1.196  1.00 27.87           C  
ATOM    222  O   GLY A  30      39.435  36.220  -2.207  1.00 26.89           O  
ATOM    223  N   LEU A  31      39.737  38.078  -0.983  1.00 30.44           N  
ATOM    224  CA  LEU A  31      39.103  39.012  -1.896  1.00 31.71           C  
ATOM    225  C   LEU A  31      40.099  39.581  -2.903  1.00 31.93           C  
ATOM    226  O   LEU A  31      41.261  39.739  -2.532  1.00 31.87           O  
ATOM    227  CB  LEU A  31      38.527  40.180  -1.103  1.00 33.20           C  
ATOM    228  CG  LEU A  31      37.053  40.287  -0.751  1.00 34.63           C  
ATOM    229  CD1 LEU A  31      36.342  38.951  -0.749  1.00 36.72           C  
ATOM    230  CD2 LEU A  31      36.918  40.993   0.594  1.00 29.25           C  
ATOM    231  N   THR A  32      39.632  39.906  -4.103  1.00 31.13           N  
ATOM    232  CA  THR A  32      40.441  40.701  -5.014  1.00 31.64           C  
ATOM    233  C   THR A  32      40.431  42.170  -4.580  1.00 34.49           C  
ATOM    234  O   THR A  32      39.564  42.567  -3.797  1.00 32.59           O  
ATOM    235  CB  THR A  32      39.954  40.674  -6.471  1.00 31.26           C  
ATOM    236  OG1 THR A  32      38.597  41.119  -6.539  1.00 33.79           O  
ATOM    237  CG2 THR A  32      39.982  39.264  -7.048  1.00 33.19           C  
ATOM    238  N   ASP A  33      41.369  42.954  -5.114  1.00 34.48           N  
ATOM    239  CA  ASP A  33      41.336  44.393  -4.854  1.00 35.31           C  
ATOM    240  C   ASP A  33      39.969  44.948  -5.206  1.00 32.01           C  
ATOM    241  O   ASP A  33      39.440  45.790  -4.482  1.00 33.34           O  
ATOM    242  CB  ASP A  33      42.435  45.132  -5.634  1.00 38.08           C  
ATOM    243  CG  ASP A  33      43.757  44.948  -4.903  1.00 39.60           C  
ATOM    244  OD1 ASP A  33      43.732  44.196  -3.905  1.00 38.94           O  
ATOM    245  OD2 ASP A  33      44.779  45.532  -5.306  1.00 44.08           O  
ATOM    246  N   LYS A  34      39.397  44.446  -6.302  1.00 31.45           N  
ATOM    247  CA  LYS A  34      38.069  44.918  -6.668  1.00 32.36           C  
ATOM    248  C   LYS A  34      37.003  44.437  -5.680  1.00 31.07           C  
ATOM    249  O   LYS A  34      36.021  45.127  -5.418  1.00 30.80           O  
ATOM    250  CB  LYS A  34      37.638  44.449  -8.061  0.41 33.60           C  
ATOM    252  CG  LYS A  34      36.120  44.518  -8.229  0.41 33.75           C  
ATOM    254  CD  LYS A  34      35.683  45.896  -8.690  0.41 33.70           C  
ATOM    256  CE  LYS A  34      35.223  46.778  -7.536  0.41 33.38           C  
ATOM    258  NZ  LYS A  34      33.998  47.542  -7.913  0.41 38.19           N  
ATOM    260  N   GLY A  35      37.132  43.255  -5.098  1.00 29.62           N  
ATOM    261  CA  GLY A  35      36.096  42.822  -4.146  1.00 28.20           C  
ATOM    262  C   GLY A  35      36.261  43.632  -2.872  1.00 28.38           C  
ATOM    263  O   GLY A  35      35.294  43.967  -2.185  1.00 29.42           O  
ATOM    264  N   GLN A  36      37.505  43.980  -2.537  1.00 26.91           N  
ATOM    265  CA  GLN A  36      37.688  44.838  -1.363  1.00 28.44           C  
ATOM    266  C   GLN A  36      37.060  46.206  -1.614  1.00 31.17           C  
ATOM    267  O   GLN A  36      36.438  46.773  -0.718  1.00 32.21           O  
ATOM    268  CB  GLN A  36      39.163  45.002  -1.012  1.00 30.99           C  
ATOM    269  CG  GLN A  36      39.838  43.813  -0.347  1.00 32.89           C  
ATOM    270  CD  GLN A  36      41.225  44.168   0.166  1.00 36.71           C  
ATOM    271  OE1 GLN A  36      41.525  44.029   1.350  1.00 47.36           O  
ATOM    272  NE2 GLN A  36      42.102  44.651  -0.701  1.00 40.96           N  
ATOM    273  N   ALA A  37      37.217  46.753  -2.832  1.00 30.32           N  
ATOM    274  CA  ALA A  37      36.687  48.076  -3.099  1.00 30.60           C  
ATOM    275  C   ALA A  37      35.167  48.070  -3.041  1.00 31.25           C  
ATOM    276  O   ALA A  37      34.574  49.037  -2.554  1.00 33.66           O  
ATOM    277  CB  ALA A  37      37.173  48.605  -4.449  1.00 33.11           C  
ATOM    278  N   GLU A  38      34.559  46.993  -3.528  1.00 31.23           N  
ATOM    279  CA  GLU A  38      33.126  46.788  -3.412  1.00 31.77           C  
ATOM    280  C   GLU A  38      32.670  46.867  -1.962  1.00 30.08           C  
ATOM    281  O   GLU A  38      31.668  47.492  -1.630  1.00 31.48           O  
ATOM    282  CB  GLU A  38      32.721  45.422  -3.955  1.00 35.22           C  
ATOM    283  CG  GLU A  38      31.256  45.318  -4.331  1.00 39.03           C  
ATOM    284  CD  GLU A  38      30.883  43.966  -4.904  1.00 43.10           C  
ATOM    285  OE1 GLU A  38      31.121  43.717  -6.100  1.00 47.54           O  
ATOM    286  OE2 GLU A  38      30.345  43.128  -4.145  1.00 53.68           O  
ATOM    287  N   ALA A  39      33.421  46.209  -1.084  1.00 28.21           N  
ATOM    288  CA  ALA A  39      33.003  46.161   0.319  1.00 29.64           C  
ATOM    289  C   ALA A  39      33.040  47.552   0.941  1.00 29.21           C  
ATOM    290  O   ALA A  39      32.156  47.922   1.703  1.00 27.32           O  
ATOM    291  CB  ALA A  39      33.890  45.200   1.098  1.00 25.90           C  
ATOM    292  N   VAL A  40      34.087  48.321   0.620  1.00 29.34           N  
ATOM    293  CA  VAL A  40      34.152  49.683   1.139  1.00 28.69           C  
ATOM    294  C   VAL A  40      32.925  50.453   0.675  1.00 28.45           C  
ATOM    295  O   VAL A  40      32.307  51.213   1.423  1.00 27.12           O  
ATOM    296  CB  VAL A  40      35.435  50.392   0.702  1.00 30.54           C  
ATOM    297  CG1 VAL A  40      35.399  51.871   1.080  1.00 33.14           C  
ATOM    298  CG2 VAL A  40      36.659  49.752   1.338  1.00 29.09           C  
ATOM    299  N   ARG A  41      32.547  50.251  -0.588  1.00 30.05           N  
ATOM    300  CA  ARG A  41      31.391  50.978  -1.109  1.00 31.25           C  
ATOM    301  C   ARG A  41      30.085  50.551  -0.445  1.00 30.25           C  
ATOM    302  O   ARG A  41      29.153  51.343  -0.270  1.00 27.55           O  
ATOM    303  CB  ARG A  41      31.298  50.781  -2.622  1.00 34.91           C  
ATOM    304  CG  ARG A  41      30.115  51.531  -3.220  1.00 40.63           C  
ATOM    305  CD  ARG A  41      30.182  53.032  -2.985  1.00 43.97           C  
ATOM    306  NE  ARG A  41      29.002  53.706  -3.522  1.00 48.47           N  
ATOM    307  CZ  ARG A  41      28.346  54.664  -2.876  1.00 51.39           C  
ATOM    308  NH1 ARG A  41      28.762  55.052  -1.679  1.00 53.60           N  
ATOM    309  NH2 ARG A  41      27.281  55.232  -3.424  1.00 53.96           N  
ATOM    310  N   SER A  42      29.997  49.277  -0.076  1.00 27.43           N  
ATOM    311  CA  SER A  42      28.809  48.766   0.605  1.00 26.98           C  
ATOM    312  C   SER A  42      28.583  49.515   1.915  1.00 25.06           C  
ATOM    313  O   SER A  42      27.470  49.897   2.301  1.00 25.66           O  
ATOM    314  CB  SER A  42      28.960  47.268   0.880  1.00 28.28           C  
ATOM    315  OG  SER A  42      29.140  46.508  -0.299  1.00 34.15           O  
ATOM    316  N   GLY A  43      29.693  49.699   2.629  1.00 21.66           N  
ATOM    317  CA  GLY A  43      29.695  50.461   3.858  1.00 23.78           C  
ATOM    318  C   GLY A  43      29.186  51.884   3.671  1.00 27.69           C  
ATOM    319  O   GLY A  43      28.364  52.385   4.448  1.00 27.37           O  
ATOM    320  N   GLU A  44      29.666  52.569   2.637  1.00 29.28           N  
ATOM    321  CA  GLU A  44      29.164  53.915   2.354  1.00 32.58           C  
ATOM    322  C   GLU A  44      27.655  53.926   2.174  1.00 31.19           C  
ATOM    323  O   GLU A  44      26.935  54.768   2.701  1.00 34.13           O  
ATOM    324  CB  GLU A  44      29.793  54.478   1.076  1.00 35.03           C  
ATOM    325  CG  GLU A  44      31.232  54.928   1.211  1.00 36.55           C  
ATOM    326  CD  GLU A  44      31.893  55.095  -0.149  1.00 39.79           C  
ATOM    327  OE1 GLU A  44      31.211  55.169  -1.194  1.00 48.63           O  
ATOM    328  OE2 GLU A  44      33.140  55.145  -0.168  1.00 39.33           O  
ATOM    329  N   LEU A  45      27.150  52.966   1.397  1.00 31.15           N  
ATOM    330  CA  LEU A  45      25.712  52.949   1.143  1.00 30.62           C  
ATOM    331  C   LEU A  45      24.917  52.761   2.427  1.00 30.01           C  
ATOM    332  O   LEU A  45      23.932  53.453   2.699  1.00 28.26           O  
ATOM    333  CB  LEU A  45      25.348  51.832   0.165  1.00 31.10           C  
ATOM    334  CG  LEU A  45      25.731  52.093  -1.291  1.00 33.74           C  
ATOM    335  CD1 LEU A  45      25.643  50.816  -2.102  1.00 34.03           C  
ATOM    336  CD2 LEU A  45      24.827  53.178  -1.869  1.00 35.54           C  
ATOM    337  N   ILE A  46      25.353  51.798   3.241  1.00 27.52           N  
ATOM    338  CA  ILE A  46      24.681  51.634   4.531  1.00 29.60           C  
ATOM    339  C   ILE A  46      24.653  52.917   5.344  1.00 31.66           C  
ATOM    340  O   ILE A  46      23.665  53.289   5.992  1.00 36.06           O  
ATOM    341  CB  ILE A  46      25.391  50.510   5.318  1.00 28.53           C  
ATOM    342  CG1 ILE A  46      25.019  49.120   4.807  1.00 29.21           C  
ATOM    343  CG2 ILE A  46      25.158  50.706   6.802  1.00 30.33           C  
ATOM    344  CD1 ILE A  46      26.017  48.025   5.162  1.00 28.54           C  
ATOM    345  N   ALA A  47      25.760  53.664   5.322  1.00 30.60           N  
ATOM    346  CA  ALA A  47      25.777  54.925   6.050  1.00 31.10           C  
ATOM    347  C   ALA A  47      24.953  56.035   5.397  1.00 33.29           C  
ATOM    348  O   ALA A  47      24.229  56.805   6.041  1.00 30.35           O  
ATOM    349  CB  ALA A  47      27.208  55.419   6.195  1.00 29.89           C  
ATOM    350  N   GLU A  48      25.073  56.152   4.078  1.00 34.23           N  
ATOM    351  CA  GLU A  48      24.286  57.204   3.421  1.00 38.31           C  
ATOM    352  C   GLU A  48      22.798  56.950   3.578  1.00 38.08           C  
ATOM    353  O   GLU A  48      21.987  57.876   3.471  1.00 37.43           O  
ATOM    354  CB  GLU A  48      24.680  57.296   1.950  1.00 42.21           C  
ATOM    355  CG  GLU A  48      26.097  57.827   1.758  1.00 46.27           C  
ATOM    356  CD  GLU A  48      26.754  57.230   0.529  1.00 49.10           C  
ATOM    357  OE1 GLU A  48      26.249  56.207   0.021  1.00 59.16           O  
ATOM    358  OE2 GLU A  48      27.774  57.775   0.071  1.00 51.54           O  
ATOM    359  N   HIS A  49      22.415  55.698   3.842  1.00 35.75           N  
ATOM    360  CA  HIS A  49      20.989  55.406   3.996  1.00 33.41           C  
ATOM    361  C   HIS A  49      20.582  55.299   5.467  1.00 33.55           C  
ATOM    362  O   HIS A  49      19.553  54.680   5.744  1.00 37.11           O  
ATOM    363  CB  HIS A  49      20.626  54.114   3.263  1.00 30.82           C  
ATOM    364  CG  HIS A  49      20.523  54.246   1.777  1.00 32.14           C  
ATOM    365  ND1 HIS A  49      19.324  54.482   1.138  1.00 32.79           N  
ATOM    366  CD2 HIS A  49      21.460  54.177   0.802  1.00 33.64           C  
ATOM    367  CE1 HIS A  49      19.541  54.547  -0.164  1.00 33.97           C  
ATOM    368  NE2 HIS A  49      20.826  54.368  -0.403  1.00 33.96           N  
ATOM    369  N   ASP A  50      21.349  55.878   6.364  1.00 34.29           N  
ATOM    370  CA  ASP A  50      21.304  55.756   7.815  1.00 38.78           C  
ATOM    371  C   ASP A  50      20.748  54.419   8.283  1.00 39.00           C  
ATOM    372  O   ASP A  50      19.760  54.258   8.997  1.00 40.47           O  
ATOM    373  CB  ASP A  50      20.534  56.916   8.457  1.00 44.16           C  
ATOM    374  CG  ASP A  50      21.501  57.997   8.924  1.00 46.35           C  
ATOM    375  OD1 ASP A  50      22.112  57.850  10.007  1.00 47.80           O  
ATOM    376  OD2 ASP A  50      21.655  58.993   8.183  1.00 48.51           O  
ATOM    377  N   LEU A  51      21.447  53.362   7.869  1.00 38.71           N  
ATOM    378  CA  LEU A  51      21.082  52.017   8.301  1.00 38.13           C  
ATOM    379  C   LEU A  51      22.209  51.457   9.155  1.00 37.30           C  
ATOM    380  O   LEU A  51      22.679  50.351   8.857  1.00 42.37           O  
ATOM    381  CB  LEU A  51      20.851  51.092   7.119  1.00 39.29           C  
ATOM    382  CG  LEU A  51      19.448  50.769   6.637  1.00 42.15           C  
ATOM    383  CD1 LEU A  51      19.520  49.679   5.563  1.00 44.14           C  
ATOM    384  CD2 LEU A  51      18.530  50.334   7.765  1.00 35.27           C  
ATOM    385  N   LEU A  52      22.636  52.207  10.162  1.00 34.74           N  
ATOM    386  CA  LEU A  52      23.815  51.810  10.940  1.00 33.55           C  
ATOM    387  C   LEU A  52      23.589  50.559  11.766  1.00 29.54           C  
ATOM    388  O   LEU A  52      22.762  50.508  12.672  1.00 28.98           O  
ATOM    389  CB  LEU A  52      24.242  52.979  11.827  1.00 35.38           C  
ATOM    390  CG  LEU A  52      24.488  54.312  11.115  1.00 36.75           C  
ATOM    391  CD1 LEU A  52      24.760  55.382  12.161  1.00 41.21           C  
ATOM    392  CD2 LEU A  52      25.622  54.205  10.100  1.00 35.54           C  
ATOM    393  N   PRO A  53      24.317  49.479  11.498  1.00 27.77           N  
ATOM    394  CA  PRO A  53      24.035  48.242  12.248  1.00 26.89           C  
ATOM    395  C   PRO A  53      24.407  48.286  13.729  1.00 23.66           C  
ATOM    396  O   PRO A  53      25.305  48.997  14.175  1.00 23.39           O  
ATOM    397  CB  PRO A  53      24.909  47.203  11.541  1.00 26.84           C  
ATOM    398  CG  PRO A  53      25.907  47.936  10.755  1.00 28.52           C  
ATOM    399  CD  PRO A  53      25.383  49.322  10.506  1.00 28.73           C  
ATOM    400  N   ASP A  54      23.680  47.479  14.495  1.00 24.29           N  
ATOM    401  CA  ASP A  54      23.913  47.315  15.924  1.00 23.25           C  
ATOM    402  C   ASP A  54      24.683  46.026  16.217  1.00 22.23           C  
ATOM    403  O   ASP A  54      25.334  45.917  17.263  1.00 24.34           O  
ATOM    404  CB  ASP A  54      22.593  47.307  16.687  1.00 24.93           C  
ATOM    405  CG  ASP A  54      21.893  48.654  16.514  1.00 26.61           C  
ATOM    406  OD1 ASP A  54      22.577  49.670  16.744  1.00 24.77           O  
ATOM    407  OD2 ASP A  54      20.698  48.633  16.151  1.00 24.52           O  
ATOM    408  N   VAL A  55      24.576  45.100  15.279  1.00 21.05           N  
ATOM    409  CA  VAL A  55      25.273  43.817  15.420  1.00 21.92           C  
ATOM    410  C   VAL A  55      25.598  43.240  14.042  1.00 23.48           C  
ATOM    411  O   VAL A  55      24.888  43.478  13.067  1.00 22.94           O  
ATOM    412  CB  VAL A  55      24.478  42.822  16.263  1.00 23.69           C  
ATOM    413  CG1 VAL A  55      23.097  42.515  15.694  1.00 22.92           C  
ATOM    414  CG2 VAL A  55      25.234  41.491  16.404  1.00 27.43           C  
ATOM    415  N   LEU A  56      26.696  42.481  13.980  1.00 22.07           N  
ATOM    416  CA  LEU A  56      27.124  41.855  12.733  1.00 21.70           C  
ATOM    417  C   LEU A  56      27.175  40.333  12.870  1.00 21.71           C  
ATOM    418  O   LEU A  56      27.710  39.835  13.859  1.00 24.43           O  
ATOM    419  CB  LEU A  56      28.504  42.368  12.318  1.00 21.35           C  
ATOM    420  CG  LEU A  56      29.286  41.547  11.293  1.00 21.18           C  
ATOM    421  CD1 LEU A  56      28.698  41.713   9.900  1.00 21.48           C  
ATOM    422  CD2 LEU A  56      30.764  41.912  11.280  1.00 25.32           C  
ATOM    423  N   TYR A  57      26.636  39.623  11.895  1.00 22.43           N  
ATOM    424  CA  TYR A  57      26.788  38.196  11.683  1.00 21.81           C  
ATOM    425  C   TYR A  57      27.534  37.893  10.383  1.00 22.43           C  
ATOM    426  O   TYR A  57      27.253  38.480   9.333  1.00 21.58           O  
ATOM    427  CB  TYR A  57      25.420  37.483  11.637  1.00 23.80           C  
ATOM    428  CG  TYR A  57      24.725  37.632  12.982  1.00 22.89           C  
ATOM    429  CD1 TYR A  57      25.011  36.743  14.002  1.00 23.30           C  
ATOM    430  CD2 TYR A  57      23.811  38.651  13.225  1.00 23.66           C  
ATOM    431  CE1 TYR A  57      24.399  36.855  15.240  1.00 25.44           C  
ATOM    432  CE2 TYR A  57      23.187  38.773  14.466  1.00 23.37           C  
ATOM    433  CZ  TYR A  57      23.485  37.870  15.461  1.00 25.35           C  
ATOM    434  OH  TYR A  57      22.893  37.959  16.703  1.00 24.79           O  
ATOM    435  N   THR A  58      28.501  36.975  10.436  1.00 19.96           N  
ATOM    436  CA  THR A  58      29.215  36.530   9.259  1.00 21.94           C  
ATOM    437  C   THR A  58      29.330  34.998   9.268  1.00 21.02           C  
ATOM    438  O   THR A  58      29.069  34.360  10.280  1.00 21.53           O  
ATOM    439  CB  THR A  58      30.647  37.079   9.152  1.00 22.20           C  
ATOM    440  OG1 THR A  58      31.508  36.404  10.100  1.00 20.03           O  
ATOM    441  CG2 THR A  58      30.691  38.552   9.487  1.00 23.52           C  
ATOM    442  N   SER A  59      29.743  34.449   8.141  1.00 21.06           N  
ATOM    443  CA  SER A  59      30.238  33.092   8.043  1.00 21.45           C  
ATOM    444  C   SER A  59      31.630  32.985   8.648  1.00 22.37           C  
ATOM    445  O   SER A  59      32.148  33.924   9.243  1.00 21.84           O  
ATOM    446  CB  SER A  59      30.286  32.698   6.567  1.00 22.66           C  
ATOM    447  OG  SER A  59      31.277  33.497   5.934  1.00 23.45           O  
ATOM    448  N   LEU A  60      32.243  31.810   8.478  1.00 21.86           N  
ATOM    449  CA  LEU A  60      33.615  31.632   8.908  1.00 23.70           C  
ATOM    450  C   LEU A  60      34.616  31.860   7.773  1.00 24.41           C  
ATOM    451  O   LEU A  60      35.789  31.522   7.966  1.00 22.75           O  
ATOM    452  CB  LEU A  60      33.799  30.212   9.458  1.00 22.24           C  
ATOM    453  CG  LEU A  60      32.873  29.763  10.588  1.00 22.67           C  
ATOM    454  CD1 LEU A  60      33.341  28.423  11.158  1.00 27.38           C  
ATOM    455  CD2 LEU A  60      32.775  30.828  11.664  1.00 22.63           C  
ATOM    456  N   LEU A  61      34.160  32.391   6.648  1.00 23.18           N  
ATOM    457  CA  LEU A  61      34.989  32.484   5.443  1.00 23.14           C  
ATOM    458  C   LEU A  61      35.553  33.890   5.308  1.00 23.60           C  
ATOM    459  O   LEU A  61      34.812  34.873   5.402  1.00 24.19           O  
ATOM    460  CB  LEU A  61      34.178  32.033   4.214  1.00 24.68           C  
ATOM    461  CG  LEU A  61      33.633  30.587   4.332  1.00 23.89           C  
ATOM    462  CD1 LEU A  61      32.713  30.213   3.188  1.00 24.07           C  
ATOM    463  CD2 LEU A  61      34.778  29.588   4.418  1.00 24.59           C  
ATOM    464  N   ARG A  62      36.870  33.998   5.116  1.00 23.15           N  
ATOM    465  CA  ARG A  62      37.541  35.291   5.124  1.00 24.20           C  
ATOM    466  C   ARG A  62      36.971  36.259   4.101  1.00 24.94           C  
ATOM    467  O   ARG A  62      36.997  37.464   4.347  1.00 24.42           O  
ATOM    468  CB  ARG A  62      39.055  35.165   4.942  1.00 26.57           C  
ATOM    469  CG  ARG A  62      39.583  34.450   3.731  1.00 29.43           C  
ATOM    470  CD  ARG A  62      40.990  34.896   3.341  1.00 29.07           C  
ATOM    471  NE  ARG A  62      41.925  34.983   4.463  1.00 27.83           N  
ATOM    472  CZ  ARG A  62      42.495  33.912   5.008  1.00 30.40           C  
ATOM    473  NH1 ARG A  62      42.205  32.707   4.518  1.00 29.87           N  
ATOM    474  NH2 ARG A  62      43.340  34.026   6.027  1.00 29.17           N  
ATOM    475  N   ARG A  63      36.452  35.825   2.961  1.00 25.70           N  
ATOM    476  CA  ARG A  63      35.931  36.801   1.999  1.00 25.36           C  
ATOM    477  C   ARG A  63      34.710  37.551   2.519  1.00 25.19           C  
ATOM    478  O   ARG A  63      34.454  38.708   2.191  1.00 26.86           O  
ATOM    479  CB  ARG A  63      35.575  36.090   0.698  1.00 25.95           C  
ATOM    480  CG  ARG A  63      34.610  34.914   0.767  1.00 25.34           C  
ATOM    481  CD  ARG A  63      34.806  34.017  -0.435  1.00 25.13           C  
ATOM    482  NE  ARG A  63      33.835  32.963  -0.705  1.00 26.72           N  
ATOM    483  CZ  ARG A  63      34.004  31.668  -0.450  1.00 27.06           C  
ATOM    484  NH1 ARG A  63      35.135  31.256   0.123  1.00 23.12           N  
ATOM    485  NH2 ARG A  63      33.042  30.796  -0.756  1.00 24.27           N  
ATOM    486  N   ALA A  64      33.916  36.881   3.345  1.00 23.26           N  
ATOM    487  CA  ALA A  64      32.784  37.557   3.986  1.00 21.61           C  
ATOM    488  C   ALA A  64      33.286  38.366   5.175  1.00 22.52           C  
ATOM    489  O   ALA A  64      32.904  39.505   5.442  1.00 23.93           O  
ATOM    490  CB  ALA A  64      31.731  36.548   4.408  1.00 23.45           C  
ATOM    491  N   ILE A  65      34.198  37.772   5.937  1.00 22.31           N  
ATOM    492  CA  ILE A  65      34.642  38.463   7.152  1.00 21.22           C  
ATOM    493  C   ILE A  65      35.322  39.779   6.826  1.00 24.02           C  
ATOM    494  O   ILE A  65      35.077  40.809   7.447  1.00 23.27           O  
ATOM    495  CB  ILE A  65      35.560  37.547   7.967  1.00 19.44           C  
ATOM    496  CG1 ILE A  65      34.814  36.335   8.509  1.00 20.61           C  
ATOM    497  CG2 ILE A  65      36.248  38.338   9.059  1.00 22.36           C  
ATOM    498  CD1 ILE A  65      35.674  35.230   9.068  1.00 22.71           C  
ATOM    499  N   THR A  66      36.190  39.753   5.820  1.00 25.12           N  
ATOM    500  CA  THR A  66      36.880  40.985   5.417  1.00 24.31           C  
ATOM    501  C   THR A  66      35.935  41.955   4.732  1.00 23.86           C  
ATOM    502  O   THR A  66      36.054  43.165   4.970  1.00 22.61           O  
ATOM    503  CB  THR A  66      38.085  40.633   4.537  1.00 25.70           C  
ATOM    504  OG1 THR A  66      38.983  39.844   5.337  1.00 26.21           O  
ATOM    505  CG2 THR A  66      38.845  41.872   4.105  1.00 24.82           C  
ATOM    506  N   THR A  67      34.992  41.462   3.928  1.00 23.31           N  
ATOM    507  CA  THR A  67      33.920  42.319   3.427  1.00 23.53           C  
ATOM    508  C   THR A  67      33.227  43.081   4.552  1.00 22.02           C  
ATOM    509  O   THR A  67      33.005  44.294   4.470  1.00 22.95           O  
ATOM    510  CB  THR A  67      32.848  41.522   2.665  1.00 21.80           C  
ATOM    511  OG1 THR A  67      33.426  41.072   1.431  1.00 23.65           O  
ATOM    512  CG2 THR A  67      31.657  42.391   2.317  1.00 22.98           C  
ATOM    513  N   ALA A  68      32.876  42.387   5.624  1.00 22.13           N  
ATOM    514  CA  ALA A  68      32.238  42.976   6.786  1.00 24.21           C  
ATOM    515  C   ALA A  68      33.099  44.045   7.454  1.00 24.58           C  
ATOM    516  O   ALA A  68      32.626  45.140   7.766  1.00 23.67           O  
ATOM    517  CB  ALA A  68      31.907  41.886   7.810  1.00 22.68           C  
ATOM    518  N   HIS A  69      34.367  43.692   7.674  1.00 22.79           N  
ATOM    519  CA  HIS A  69      35.257  44.639   8.338  1.00 22.76           C  
ATOM    520  C   HIS A  69      35.320  45.932   7.535  1.00 23.27           C  
ATOM    521  O   HIS A  69      35.250  47.037   8.059  1.00 24.09           O  
ATOM    522  CB  HIS A  69      36.626  43.994   8.485  1.00 23.53           C  
ATOM    523  CG  HIS A  69      37.694  44.949   8.906  1.00 25.28           C  
ATOM    524  ND1 HIS A  69      37.997  45.141  10.233  1.00 26.91           N  
ATOM    525  CD2 HIS A  69      38.533  45.741   8.204  1.00 26.08           C  
ATOM    526  CE1 HIS A  69      38.977  46.025  10.325  1.00 25.63           C  
ATOM    527  NE2 HIS A  69      39.306  46.400   9.110  1.00 24.72           N  
ATOM    528  N   LEU A  70      35.473  45.783   6.218  1.00 25.04           N  
ATOM    529  CA  LEU A  70      35.667  46.954   5.358  1.00 25.05           C  
ATOM    530  C   LEU A  70      34.390  47.780   5.302  1.00 25.02           C  
ATOM    531  O   LEU A  70      34.403  49.009   5.283  1.00 26.24           O  
ATOM    532  CB  LEU A  70      36.119  46.560   3.949  1.00 25.27           C  
ATOM    533  CG  LEU A  70      37.518  45.958   3.835  1.00 25.21           C  
ATOM    534  CD1 LEU A  70      37.737  45.370   2.454  1.00 25.10           C  
ATOM    535  CD2 LEU A  70      38.599  46.998   4.137  1.00 28.08           C  
ATOM    536  N   ALA A  71      33.246  47.102   5.269  1.00 25.43           N  
ATOM    537  CA  ALA A  71      32.008  47.877   5.227  1.00 24.66           C  
ATOM    538  C   ALA A  71      31.783  48.606   6.536  1.00 27.12           C  
ATOM    539  O   ALA A  71      31.411  49.792   6.567  1.00 27.30           O  
ATOM    540  CB  ALA A  71      30.850  46.969   4.892  1.00 22.83           C  
ATOM    541  N   LEU A  72      31.990  47.918   7.658  1.00 24.85           N  
ATOM    542  CA  LEU A  72      31.788  48.598   8.934  1.00 26.22           C  
ATOM    543  C   LEU A  72      32.784  49.739   9.117  1.00 27.76           C  
ATOM    544  O   LEU A  72      32.517  50.787   9.713  1.00 24.93           O  
ATOM    545  CB  LEU A  72      31.894  47.614  10.092  1.00 26.85           C  
ATOM    546  CG  LEU A  72      30.786  46.557  10.180  1.00 27.09           C  
ATOM    547  CD1 LEU A  72      31.072  45.611  11.338  1.00 25.96           C  
ATOM    548  CD2 LEU A  72      29.405  47.173  10.334  1.00 28.24           C  
ATOM    549  N   ASP A  73      33.997  49.552   8.585  1.00 27.78           N  
ATOM    550  CA  ASP A  73      34.934  50.657   8.748  1.00 29.14           C  
ATOM    551  C   ASP A  73      34.471  51.880   7.958  1.00 31.17           C  
ATOM    552  O   ASP A  73      34.572  53.009   8.446  1.00 29.24           O  
ATOM    553  CB  ASP A  73      36.326  50.266   8.292  1.00 28.97           C  
ATOM    554  CG  ASP A  73      37.365  51.234   8.837  1.00 31.77           C  
ATOM    555  OD1 ASP A  73      37.047  52.084   9.691  1.00 36.47           O  
ATOM    556  OD2 ASP A  73      38.517  51.125   8.384  1.00 36.46           O  
ATOM    557  N   SER A  74      33.968  51.669   6.733  1.00 29.59           N  
ATOM    558  CA  SER A  74      33.530  52.881   6.021  1.00 29.39           C  
ATOM    559  C   SER A  74      32.246  53.445   6.617  1.00 29.18           C  
ATOM    560  O   SER A  74      32.036  54.656   6.518  1.00 27.90           O  
ATOM    561  CB  SER A  74      33.405  52.598   4.531  1.00 31.44           C  
ATOM    562  OG  SER A  74      32.597  51.476   4.255  1.00 38.78           O  
ATOM    563  N   ALA A  75      31.401  52.638   7.250  1.00 26.87           N  
ATOM    564  CA  ALA A  75      30.190  53.092   7.904  1.00 27.66           C  
ATOM    565  C   ALA A  75      30.481  53.587   9.327  1.00 28.98           C  
ATOM    566  O   ALA A  75      29.559  54.007  10.025  1.00 27.22           O  
ATOM    567  CB  ALA A  75      29.132  51.998   7.999  1.00 25.44           C  
ATOM    568  N   ASP A  76      31.744  53.510   9.734  1.00 28.81           N  
ATOM    569  CA  ASP A  76      32.134  53.929  11.076  1.00 30.83           C  
ATOM    570  C   ASP A  76      31.389  53.200  12.195  1.00 30.61           C  
ATOM    571  O   ASP A  76      31.032  53.868  13.174  1.00 28.35           O  
ATOM    572  CB  ASP A  76      31.887  55.433  11.287  1.00 34.50           C  
ATOM    573  CG  ASP A  76      32.738  55.991  12.417  1.00 38.30           C  
ATOM    574  OD1 ASP A  76      33.702  55.314  12.847  1.00 38.03           O  
ATOM    575  OD2 ASP A  76      32.447  57.115  12.879  1.00 42.01           O  
ATOM    576  N   ARG A  77      31.180  51.898  12.048  1.00 28.52           N  
ATOM    577  CA  ARG A  77      30.549  51.029  13.031  1.00 28.13           C  
ATOM    578  C   ARG A  77      31.416  49.793  13.314  1.00 26.89           C  
ATOM    579  O   ARG A  77      30.899  48.705  13.600  1.00 25.93           O  
ATOM    580  CB  ARG A  77      29.158  50.593  12.572  1.00 31.66           C  
ATOM    581  CG  ARG A  77      28.106  51.708  12.647  1.00 34.86           C  
ATOM    582  CD  ARG A  77      27.221  51.469  13.855  1.00 38.27           C  
ATOM    583  NE  ARG A  77      26.728  52.724  14.417  1.00 39.69           N  
ATOM    584  CZ  ARG A  77      25.766  52.723  15.338  1.00 37.90           C  
ATOM    585  NH1 ARG A  77      25.265  51.561  15.734  1.00 33.68           N  
ATOM    586  NH2 ARG A  77      25.345  53.879  15.821  1.00 37.61           N  
ATOM    587  N   LEU A  78      32.732  49.985  13.265  1.00 25.94           N  
ATOM    588  CA  LEU A  78      33.688  48.893  13.474  1.00 26.85           C  
ATOM    589  C   LEU A  78      33.535  48.307  14.874  1.00 25.32           C  
ATOM    590  O   LEU A  78      33.834  47.147  15.134  1.00 27.99           O  
ATOM    591  CB  LEU A  78      35.116  49.370  13.268  1.00 29.70           C  
ATOM    592  CG  LEU A  78      36.168  48.623  12.473  1.00 33.33           C  
ATOM    593  CD1 LEU A  78      35.566  47.576  11.537  1.00 32.52           C  
ATOM    594  CD2 LEU A  78      37.056  49.595  11.688  1.00 34.13           C  
ATOM    595  N   TRP A  79      33.087  49.117  15.826  1.00 24.69           N  
ATOM    596  CA  TRP A  79      33.095  48.769  17.235  1.00 23.49           C  
ATOM    597  C   TRP A  79      31.954  47.863  17.663  1.00 22.49           C  
ATOM    598  O   TRP A  79      31.881  47.396  18.802  1.00 21.70           O  
ATOM    599  CB  TRP A  79      33.078  50.064  18.063  1.00 24.05           C  
ATOM    600  CG  TRP A  79      31.933  50.962  17.744  1.00 23.28           C  
ATOM    601  CD1 TRP A  79      31.939  52.015  16.879  1.00 25.16           C  
ATOM    602  CD2 TRP A  79      30.598  50.895  18.281  1.00 24.84           C  
ATOM    603  NE1 TRP A  79      30.693  52.607  16.843  1.00 23.51           N  
ATOM    604  CE2 TRP A  79      29.860  51.939  17.692  1.00 24.76           C  
ATOM    605  CE3 TRP A  79      29.950  50.062  19.194  1.00 27.64           C  
ATOM    606  CZ2 TRP A  79      28.522  52.167  17.990  1.00 27.50           C  
ATOM    607  CZ3 TRP A  79      28.617  50.279  19.500  1.00 28.76           C  
ATOM    608  CH2 TRP A  79      27.914  51.331  18.895  1.00 29.62           C  
ATOM    609  N   ILE A  80      31.019  47.559  16.755  1.00 23.36           N  
ATOM    610  CA  ILE A  80      29.864  46.772  17.163  1.00 23.20           C  
ATOM    611  C   ILE A  80      30.194  45.297  17.383  1.00 23.89           C  
ATOM    612  O   ILE A  80      31.183  44.749  16.871  1.00 24.45           O  
ATOM    613  CB  ILE A  80      28.719  46.883  16.123  1.00 23.33           C  
ATOM    614  CG1 ILE A  80      29.086  46.266  14.783  1.00 22.60           C  
ATOM    615  CG2 ILE A  80      28.216  48.318  15.948  1.00 24.03           C  
ATOM    616  CD1 ILE A  80      27.947  46.231  13.792  1.00 23.85           C  
ATOM    617  N   PRO A  81      29.359  44.603  18.152  1.00 23.28           N  
ATOM    618  CA  PRO A  81      29.605  43.178  18.381  1.00 26.45           C  
ATOM    619  C   PRO A  81      29.394  42.382  17.094  1.00 25.54           C  
ATOM    620  O   PRO A  81      28.627  42.729  16.200  1.00 22.84           O  
ATOM    621  CB  PRO A  81      28.563  42.766  19.420  1.00 25.71           C  
ATOM    622  CG  PRO A  81      28.072  44.052  19.987  1.00 26.42           C  
ATOM    623  CD  PRO A  81      28.158  45.049  18.874  1.00 24.70           C  
ATOM    624  N   VAL A  82      30.117  41.271  17.032  1.00 24.56           N  
ATOM    625  CA  VAL A  82      30.001  40.401  15.860  1.00 27.60           C  
ATOM    626  C   VAL A  82      29.973  38.960  16.350  1.00 25.05           C  
ATOM    627  O   VAL A  82      30.547  38.608  17.379  1.00 23.88           O  
ATOM    628  CB  VAL A  82      31.111  40.673  14.838  1.00 32.20           C  
ATOM    629  CG1 VAL A  82      32.334  41.261  15.526  1.00 34.58           C  
ATOM    630  CG2 VAL A  82      31.491  39.441  14.033  1.00 28.01           C  
ATOM    631  N   ARG A  83      29.240  38.165  15.607  1.00 23.37           N  
ATOM    632  CA  ARG A  83      29.153  36.726  15.808  1.00 25.02           C  
ATOM    633  C   ARG A  83      29.310  36.053  14.451  1.00 22.06           C  
ATOM    634  O   ARG A  83      28.813  36.564  13.458  1.00 20.38           O  
ATOM    635  CB  ARG A  83      27.845  36.343  16.478  1.00 28.96           C  
ATOM    636  CG  ARG A  83      27.632  37.005  17.828  1.00 30.65           C  
ATOM    637  CD  ARG A  83      28.617  36.493  18.880  1.00 30.46           C  
ATOM    638  NE  ARG A  83      28.196  37.000  20.208  1.00 29.95           N  
ATOM    639  CZ  ARG A  83      28.615  38.170  20.666  1.00 29.57           C  
ATOM    640  NH1 ARG A  83      29.431  38.927  19.946  1.00 27.29           N  
ATOM    641  NH2 ARG A  83      28.233  38.611  21.850  1.00 35.92           N  
ATOM    642  N   ARG A  84      30.023  34.946  14.434  1.00 22.39           N  
ATOM    643  CA  ARG A  84      30.272  34.157  13.249  1.00 21.95           C  
ATOM    644  C   ARG A  84      29.784  32.725  13.396  1.00 23.44           C  
ATOM    645  O   ARG A  84      29.813  32.101  14.454  1.00 21.54           O  
ATOM    646  CB  ARG A  84      31.775  34.115  12.940  1.00 21.49           C  
ATOM    647  CG  ARG A  84      32.529  35.362  13.316  1.00 21.83           C  
ATOM    648  CD  ARG A  84      33.902  35.402  12.666  1.00 23.63           C  
ATOM    649  NE  ARG A  84      34.633  36.621  12.986  1.00 24.10           N  
ATOM    650  CZ  ARG A  84      34.451  37.839  12.499  1.00 24.95           C  
ATOM    651  NH1 ARG A  84      33.512  38.115  11.597  1.00 21.03           N  
ATOM    652  NH2 ARG A  84      35.232  38.835  12.917  1.00 24.93           N  
ATOM    653  N   SER A  85      29.338  32.172  12.264  1.00 24.03           N  
ATOM    654  CA  SER A  85      28.903  30.791  12.332  1.00 24.63           C  
ATOM    655  C   SER A  85      29.141  30.100  10.987  1.00 26.21           C  
ATOM    656  O   SER A  85      28.907  30.732   9.950  1.00 23.10           O  
ATOM    657  CB  SER A  85      27.428  30.710  12.703  1.00 21.04           C  
ATOM    658  OG  SER A  85      27.004  29.356  12.629  1.00 21.98           O  
ATOM    659  N   TRP A  86      29.533  28.830  11.065  1.00 23.52           N  
ATOM    660  CA  TRP A  86      29.587  27.981   9.881  1.00 23.26           C  
ATOM    661  C   TRP A  86      28.230  27.953   9.181  1.00 21.70           C  
ATOM    662  O   TRP A  86      28.150  27.726   7.980  1.00 23.86           O  
ATOM    663  CB  TRP A  86      30.006  26.553  10.225  1.00 24.41           C  
ATOM    664  CG  TRP A  86      29.001  25.652  10.864  1.00 24.21           C  
ATOM    665  CD1 TRP A  86      28.723  25.499  12.192  1.00 22.68           C  
ATOM    666  CD2 TRP A  86      28.121  24.748  10.176  1.00 23.95           C  
ATOM    667  NE1 TRP A  86      27.727  24.570  12.378  1.00 22.56           N  
ATOM    668  CE2 TRP A  86      27.346  24.092  11.158  1.00 24.94           C  
ATOM    669  CE3 TRP A  86      27.922  24.430   8.826  1.00 25.13           C  
ATOM    670  CZ2 TRP A  86      26.385  23.139  10.806  1.00 25.16           C  
ATOM    671  CZ3 TRP A  86      26.965  23.486   8.480  1.00 24.60           C  
ATOM    672  CH2 TRP A  86      26.208  22.853   9.477  1.00 23.68           C  
ATOM    673  N   ARG A  87      27.139  28.151   9.921  1.00 20.02           N  
ATOM    674  CA  ARG A  87      25.825  28.004   9.273  1.00 21.90           C  
ATOM    675  C   ARG A  87      25.552  29.092   8.248  1.00 22.18           C  
ATOM    676  O   ARG A  87      24.571  28.988   7.510  1.00 24.17           O  
ATOM    677  CB  ARG A  87      24.746  27.933  10.360  1.00 21.06           C  
ATOM    678  CG  ARG A  87      24.863  26.692  11.222  1.00 22.95           C  
ATOM    679  CD  ARG A  87      23.883  26.599  12.383  1.00 23.64           C  
ATOM    680  NE  ARG A  87      24.154  25.364  13.126  1.00 22.62           N  
ATOM    681  CZ  ARG A  87      23.696  24.160  12.809  1.00 26.93           C  
ATOM    682  NH1 ARG A  87      22.910  23.937  11.760  1.00 27.39           N  
ATOM    683  NH2 ARG A  87      24.036  23.127  13.582  1.00 25.49           N  
ATOM    684  N   LEU A  88      26.394  30.117   8.178  1.00 22.81           N  
ATOM    685  CA  LEU A  88      26.276  31.202   7.220  1.00 22.27           C  
ATOM    686  C   LEU A  88      27.232  30.974   6.057  1.00 21.44           C  
ATOM    687  O   LEU A  88      27.255  31.795   5.141  1.00 22.59           O  
ATOM    688  CB  LEU A  88      26.539  32.566   7.868  1.00 21.82           C  
ATOM    689  CG  LEU A  88      25.314  33.219   8.523  1.00 24.60           C  
ATOM    690  CD1 LEU A  88      24.631  32.218   9.438  1.00 34.14           C  
ATOM    691  CD2 LEU A  88      25.700  34.491   9.269  1.00 22.77           C  
ATOM    692  N   ASN A  89      27.993  29.883   6.078  1.00 22.53           N  
ATOM    693  CA  ASN A  89      28.920  29.598   4.991  1.00 20.04           C  
ATOM    694  C   ASN A  89      28.188  29.437   3.662  1.00 23.13           C  
ATOM    695  O   ASN A  89      27.038  29.041   3.620  1.00 24.29           O  
ATOM    696  CB  ASN A  89      29.712  28.309   5.232  1.00 21.89           C  
ATOM    697  CG  ASN A  89      30.885  28.464   6.174  1.00 23.47           C  
ATOM    698  OD1 ASN A  89      31.081  29.522   6.766  1.00 23.32           O  
ATOM    699  ND2 ASN A  89      31.712  27.421   6.293  1.00 24.08           N  
ATOM    700  N   GLU A  90      28.909  29.731   2.596  1.00 25.94           N  
ATOM    701  CA  GLU A  90      28.598  29.362   1.230  1.00 26.25           C  
ATOM    702  C   GLU A  90      28.226  27.882   1.182  1.00 24.16           C  
ATOM    703  O   GLU A  90      28.622  27.111   2.053  1.00 21.72           O  
ATOM    704  CB  GLU A  90      29.802  29.611   0.307  1.00 27.41           C  
ATOM    705  CG  GLU A  90      29.573  29.184  -1.145  1.00 28.02           C  
ATOM    706  CD  GLU A  90      28.454  29.994  -1.762  1.00 30.51           C  
ATOM    707  OE1 GLU A  90      27.273  29.642  -1.539  1.00 30.28           O  
ATOM    708  OE2 GLU A  90      28.764  30.986  -2.467  1.00 30.66           O  
ATOM    709  N   ARG A  91      27.483  27.476   0.156  1.00 24.99           N  
ATOM    710  CA  ARG A  91      27.245  26.073  -0.102  1.00 27.38           C  
ATOM    711  C   ARG A  91      28.560  25.306  -0.271  1.00 24.49           C  
ATOM    712  O   ARG A  91      29.446  25.807  -0.973  1.00 25.05           O  
ATOM    713  CB  ARG A  91      26.424  25.918  -1.389  1.00 32.94           C  
ATOM    714  CG  ARG A  91      26.513  24.497  -1.939  1.00 39.26           C  
ATOM    715  CD  ARG A  91      27.362  24.399  -3.194  1.00 41.65           C  
ATOM    716  NE  ARG A  91      26.860  25.174  -4.320  1.00 44.08           N  
ATOM    717  CZ  ARG A  91      26.090  24.661  -5.277  1.00 43.02           C  
ATOM    718  NH1 ARG A  91      25.752  23.378  -5.210  1.00 45.06           N  
ATOM    719  NH2 ARG A  91      25.669  25.411  -6.277  1.00 38.15           N  
ATOM    720  N   HIS A  92      28.698  24.124   0.317  1.00 23.88           N  
ATOM    721  CA  HIS A  92      29.929  23.346   0.051  1.00 23.07           C  
ATOM    722  C   HIS A  92      29.825  22.812  -1.379  1.00 25.69           C  
ATOM    723  O   HIS A  92      28.742  22.315  -1.706  1.00 30.04           O  
ATOM    724  CB  HIS A  92      30.060  22.248   1.077  1.00 22.83           C  
ATOM    725  CG  HIS A  92      31.338  21.480   1.098  1.00 25.81           C  
ATOM    726  ND1 HIS A  92      31.748  20.676   0.053  1.00 26.13           N  
ATOM    727  CD2 HIS A  92      32.291  21.379   2.051  1.00 23.70           C  
ATOM    728  CE1 HIS A  92      32.903  20.130   0.373  1.00 26.08           C  
ATOM    729  NE2 HIS A  92      33.257  20.542   1.579  1.00 25.21           N  
ATOM    730  N   TYR A  93      30.863  22.923  -2.200  1.00 25.75           N  
ATOM    731  CA  TYR A  93      30.756  22.477  -3.585  1.00 26.96           C  
ATOM    732  C   TYR A  93      31.240  21.057  -3.837  1.00 27.34           C  
ATOM    733  O   TYR A  93      31.437  20.649  -4.990  1.00 29.54           O  
ATOM    734  CB  TYR A  93      31.554  23.429  -4.489  1.00 30.71           C  
ATOM    735  CG  TYR A  93      30.655  24.142  -5.477  1.00 34.28           C  
ATOM    736  CD1 TYR A  93      29.907  23.398  -6.380  1.00 36.82           C  
ATOM    737  CD2 TYR A  93      30.580  25.520  -5.483  1.00 36.73           C  
ATOM    738  CE1 TYR A  93      29.088  24.042  -7.282  1.00 40.05           C  
ATOM    739  CE2 TYR A  93      29.757  26.177  -6.384  1.00 40.03           C  
ATOM    740  CZ  TYR A  93      29.020  25.422  -7.270  1.00 41.65           C  
ATOM    741  OH  TYR A  93      28.207  26.062  -8.170  1.00 44.73           O  
ATOM    742  N   GLY A  94      31.442  20.265  -2.793  1.00 26.95           N  
ATOM    743  CA  GLY A  94      31.847  18.885  -2.976  1.00 26.23           C  
ATOM    744  C   GLY A  94      33.122  18.767  -3.780  1.00 26.76           C  
ATOM    745  O   GLY A  94      34.027  19.615  -3.717  1.00 25.70           O  
ATOM    746  N   ALA A  95      33.186  17.693  -4.564  1.00 27.10           N  
ATOM    747  CA  ALA A  95      34.352  17.385  -5.379  1.00 25.92           C  
ATOM    748  C   ALA A  95      34.628  18.419  -6.456  1.00 25.70           C  
ATOM    749  O   ALA A  95      35.626  18.313  -7.170  1.00 29.86           O  
ATOM    750  CB  ALA A  95      34.163  16.026  -6.043  1.00 31.38           C  
ATOM    751  N   LEU A  96      33.772  19.403  -6.629  1.00 26.73           N  
ATOM    752  CA  LEU A  96      33.962  20.505  -7.561  1.00 27.94           C  
ATOM    753  C   LEU A  96      34.881  21.585  -6.999  1.00 27.31           C  
ATOM    754  O   LEU A  96      35.408  22.408  -7.749  1.00 26.85           O  
ATOM    755  CB  LEU A  96      32.617  21.124  -7.937  1.00 28.89           C  
ATOM    756  CG  LEU A  96      31.706  20.341  -8.881  1.00 31.35           C  
ATOM    757  CD1 LEU A  96      30.456  21.170  -9.188  1.00 30.25           C  
ATOM    758  CD2 LEU A  96      32.420  19.933 -10.156  1.00 32.12           C  
ATOM    759  N   GLN A  97      35.077  21.593  -5.674  1.00 26.24           N  
ATOM    760  CA  GLN A  97      35.963  22.622  -5.111  1.00 25.55           C  
ATOM    761  C   GLN A  97      37.361  22.559  -5.698  1.00 27.69           C  
ATOM    762  O   GLN A  97      38.001  21.503  -5.661  1.00 27.17           O  
ATOM    763  CB  GLN A  97      36.000  22.496  -3.577  1.00 23.80           C  
ATOM    764  CG  GLN A  97      34.673  22.842  -2.929  1.00 23.02           C  
ATOM    765  CD  GLN A  97      34.617  22.928  -1.423  1.00 25.10           C  
ATOM    766  OE1 GLN A  97      33.615  23.387  -0.856  1.00 26.14           O  
ATOM    767  NE2 GLN A  97      35.636  22.495  -0.691  1.00 27.56           N  
ATOM    768  N   GLY A  98      37.903  23.643  -6.251  1.00 28.58           N  
ATOM    769  CA  GLY A  98      39.269  23.632  -6.759  1.00 30.35           C  
ATOM    770  C   GLY A  98      39.398  23.409  -8.252  1.00 31.96           C  
ATOM    771  O   GLY A  98      40.495  23.572  -8.797  1.00 35.76           O  
ATOM    772  N   LEU A  99      38.328  23.043  -8.933  1.00 31.72           N  
ATOM    773  CA  LEU A  99      38.262  22.789 -10.364  1.00 32.23           C  
ATOM    774  C   LEU A  99      37.791  24.024 -11.129  1.00 33.60           C  
ATOM    775  O   LEU A  99      37.024  24.841 -10.629  1.00 31.31           O  
ATOM    776  CB  LEU A  99      37.304  21.639 -10.667  1.00 33.79           C  
ATOM    777  CG  LEU A  99      37.601  20.245 -10.124  1.00 36.85           C  
ATOM    778  CD1 LEU A  99      37.516  20.181  -8.605  1.00 42.64           C  
ATOM    779  CD2 LEU A  99      36.627  19.230 -10.719  1.00 42.81           C  
ATOM    780  N   ASP A 100      38.228  24.172 -12.375  1.00 35.99           N  
ATOM    781  CA  ASP A 100      37.828  25.290 -13.234  1.00 37.92           C  
ATOM    782  C   ASP A 100      36.438  25.037 -13.797  1.00 37.57           C  
ATOM    783  O   ASP A 100      36.118  23.944 -14.267  1.00 40.71           O  
ATOM    784  CB  ASP A 100      38.857  25.489 -14.339  1.00 42.00           C  
ATOM    785  CG  ASP A 100      38.414  26.425 -15.444  1.00 43.38           C  
ATOM    786  OD1 ASP A 100      37.490  26.039 -16.191  1.00 45.30           O  
ATOM    787  OD2 ASP A 100      38.986  27.533 -15.544  1.00 44.60           O  
ATOM    788  N   LYS A 101      35.591  26.048 -13.725  1.00 37.27           N  
ATOM    789  CA  LYS A 101      34.199  25.957 -14.124  1.00 39.41           C  
ATOM    790  C   LYS A 101      34.038  25.701 -15.617  1.00 39.86           C  
ATOM    791  O   LYS A 101      33.252  24.878 -16.078  1.00 40.85           O  
ATOM    792  CB  LYS A 101      33.496  27.268 -13.743  1.00 41.75           C  
ATOM    793  CG  LYS A 101      33.447  27.526 -12.239  1.00 45.20           C  
ATOM    794  CD  LYS A 101      33.257  29.001 -11.915  1.00 47.87           C  
ATOM    795  CE  LYS A 101      31.784  29.394 -11.869  1.00 49.85           C  
ATOM    796  NZ  LYS A 101      31.256  29.310 -10.477  1.00 51.35           N  
ATOM    797  N   ALA A 102      34.812  26.436 -16.410  1.00 40.90           N  
ATOM    798  CA  ALA A 102      34.736  26.191 -17.853  1.00 43.18           C  
ATOM    799  C   ALA A 102      35.207  24.782 -18.195  1.00 43.02           C  
ATOM    800  O   ALA A 102      34.537  24.029 -18.905  1.00 45.45           O  
ATOM    801  CB  ALA A 102      35.540  27.258 -18.572  1.00 43.38           C  
ATOM    802  N   GLU A 103      36.367  24.389 -17.693  1.00 41.86           N  
ATOM    803  CA  GLU A 103      36.928  23.080 -17.990  1.00 43.02           C  
ATOM    804  C   GLU A 103      35.942  21.977 -17.622  1.00 43.06           C  
ATOM    805  O   GLU A 103      35.800  20.959 -18.303  1.00 47.58           O  
ATOM    806  CB  GLU A 103      38.241  22.894 -17.240  1.00 46.56           C  
ATOM    807  CG  GLU A 103      39.525  23.196 -17.985  1.00 48.72           C  
ATOM    808  CD  GLU A 103      40.603  22.156 -17.724  1.00 51.56           C  
ATOM    809  OE1 GLU A 103      40.840  21.784 -16.550  1.00 49.55           O  
ATOM    810  OE2 GLU A 103      41.224  21.699 -18.711  1.00 56.87           O  
ATOM    811  N   THR A 104      35.248  22.187 -16.515  1.00 41.64           N  
ATOM    812  CA  THR A 104      34.261  21.275 -15.960  1.00 39.79           C  
ATOM    813  C   THR A 104      32.997  21.228 -16.806  1.00 41.35           C  
ATOM    814  O   THR A 104      32.411  20.168 -17.031  1.00 39.64           O  
ATOM    815  CB  THR A 104      33.940  21.707 -14.513  1.00 38.84           C  
ATOM    816  OG1 THR A 104      35.112  21.463 -13.718  1.00 35.26           O  
ATOM    817  CG2 THR A 104      32.798  20.906 -13.926  1.00 35.53           C  
ATOM    818  N   LYS A 105      32.587  22.391 -17.293  1.00 43.68           N  
ATOM    819  CA  LYS A 105      31.478  22.518 -18.238  1.00 46.30           C  
ATOM    820  C   LYS A 105      31.743  21.760 -19.533  1.00 45.00           C  
ATOM    821  O   LYS A 105      30.919  21.017 -20.062  1.00 36.30           O  
ATOM    822  CB  LYS A 105      31.242  24.007 -18.526  1.00 48.67           C  
ATOM    823  CG  LYS A 105      30.183  24.309 -19.570  1.00 51.38           C  
ATOM    824  CD  LYS A 105      29.462  25.618 -19.282  1.00 53.33           C  
ATOM    825  CE  LYS A 105      28.883  26.226 -20.554  1.00 54.14           C  
ATOM    826  NZ  LYS A 105      29.334  27.633 -20.751  1.00 56.21           N  
ATOM    827  N   ALA A 106      32.941  21.931 -20.082  1.00 46.86           N  
ATOM    828  CA  ALA A 106      33.315  21.246 -21.312  1.00 48.64           C  
ATOM    829  C   ALA A 106      33.124  19.734 -21.229  1.00 49.20           C  
ATOM    830  O   ALA A 106      32.495  19.157 -22.110  1.00 51.20           O  
ATOM    831  CB  ALA A 106      34.776  21.502 -21.648  1.00 48.64           C  
ATOM    832  N   ARG A 107      33.686  19.155 -20.183  1.00 49.02           N  
ATOM    833  CA  ARG A 107      33.780  17.728 -19.929  1.00 48.40           C  
ATOM    834  C   ARG A 107      32.470  17.072 -19.536  1.00 45.98           C  
ATOM    835  O   ARG A 107      32.163  15.947 -19.946  1.00 44.12           O  
ATOM    836  CB  ARG A 107      34.812  17.500 -18.815  1.00 51.00           C  
ATOM    837  CG  ARG A 107      34.691  16.184 -18.073  1.00 52.67           C  
ATOM    838  CD  ARG A 107      35.784  16.059 -17.017  1.00 54.28           C  
ATOM    839  NE  ARG A 107      35.609  14.846 -16.214  1.00 55.48           N  
ATOM    840  CZ  ARG A 107      36.484  14.406 -15.317  1.00 55.18           C  
ATOM    841  NH1 ARG A 107      37.608  15.071 -15.087  1.00 49.50           N  
ATOM    842  NH2 ARG A 107      36.237  13.294 -14.641  1.00 58.81           N  
ATOM    843  N   TYR A 108      31.684  17.765 -18.720  1.00 44.84           N  
ATOM    844  CA  TYR A 108      30.458  17.165 -18.200  1.00 44.52           C  
ATOM    845  C   TYR A 108      29.205  17.571 -18.938  1.00 45.78           C  
ATOM    846  O   TYR A 108      28.153  16.922 -18.888  1.00 49.05           O  
ATOM    847  CB  TYR A 108      30.334  17.538 -16.709  1.00 45.56           C  
ATOM    848  CG  TYR A 108      31.183  16.597 -15.872  1.00 46.73           C  
ATOM    849  CD1 TYR A 108      30.667  15.391 -15.424  1.00 47.81           C  
ATOM    850  CD2 TYR A 108      32.495  16.923 -15.554  1.00 47.74           C  
ATOM    851  CE1 TYR A 108      31.433  14.524 -14.666  1.00 48.71           C  
ATOM    852  CE2 TYR A 108      33.265  16.063 -14.794  1.00 49.26           C  
ATOM    853  CZ  TYR A 108      32.729  14.870 -14.356  1.00 50.65           C  
ATOM    854  OH  TYR A 108      33.491  14.009 -13.597  1.00 57.69           O  
ATOM    855  N   GLY A 109      29.264  18.685 -19.662  1.00 45.41           N  
ATOM    856  CA  GLY A 109      28.050  19.056 -20.376  1.00 47.31           C  
ATOM    857  C   GLY A 109      27.348  20.215 -19.692  1.00 48.05           C  
ATOM    858  O   GLY A 109      27.612  20.525 -18.531  1.00 41.68           O  
ATOM    859  N   GLU A 110      26.472  20.827 -20.475  1.00 50.14           N  
ATOM    860  CA  GLU A 110      25.727  22.007 -20.074  1.00 51.21           C  
ATOM    861  C   GLU A 110      24.767  21.636 -18.951  1.00 50.27           C  
ATOM    862  O   GLU A 110      24.844  22.195 -17.862  1.00 50.73           O  
ATOM    863  CB  GLU A 110      24.951  22.603 -21.249  1.00 53.76           C  
ATOM    864  CG  GLU A 110      25.729  23.677 -21.994  1.00 56.61           C  
ATOM    865  CD  GLU A 110      25.589  23.534 -23.499  1.00 59.11           C  
ATOM    866  OE1 GLU A 110      24.468  23.225 -23.954  1.00 61.83           O  
ATOM    867  OE2 GLU A 110      26.600  23.735 -24.202  1.00 63.49           O  
ATOM    868  N   GLU A 111      23.899  20.683 -19.281  1.00 50.26           N  
ATOM    869  CA  GLU A 111      22.866  20.304 -18.322  1.00 52.19           C  
ATOM    870  C   GLU A 111      23.492  19.908 -16.993  1.00 51.42           C  
ATOM    871  O   GLU A 111      23.023  20.377 -15.952  1.00 49.67           O  
ATOM    872  CB  GLU A 111      21.985  19.199 -18.903  1.00 54.31           C  
ATOM    873  CG  GLU A 111      21.313  19.560 -20.216  1.00 57.16           C  
ATOM    874  CD  GLU A 111      20.644  20.917 -20.221  1.00 59.50           C  
ATOM    875  OE1 GLU A 111      21.327  21.940 -19.989  1.00 64.48           O  
ATOM    876  OE2 GLU A 111      19.419  20.986 -20.470  1.00 61.80           O  
ATOM    877  N   GLN A 112      24.535  19.077 -16.995  1.00 51.25           N  
ATOM    878  CA  GLN A 112      25.094  18.670 -15.701  1.00 50.61           C  
ATOM    879  C   GLN A 112      25.639  19.887 -14.962  1.00 48.90           C  
ATOM    880  O   GLN A 112      25.418  20.053 -13.764  1.00 49.09           O  
ATOM    881  CB  GLN A 112      26.192  17.617 -15.827  1.00 51.39           C  
ATOM    882  CG  GLN A 112      26.717  17.118 -14.488  1.00 52.20           C  
ATOM    883  CD  GLN A 112      25.677  16.424 -13.634  1.00 52.33           C  
ATOM    884  OE1 GLN A 112      25.586  15.194 -13.604  1.00 50.82           O  
ATOM    885  NE2 GLN A 112      24.876  17.207 -12.920  1.00 51.08           N  
ATOM    886  N   PHE A 113      26.341  20.745 -15.688  1.00 47.19           N  
ATOM    887  CA  PHE A 113      26.920  21.931 -15.054  1.00 47.16           C  
ATOM    888  C   PHE A 113      25.846  22.785 -14.400  1.00 47.35           C  
ATOM    889  O   PHE A 113      25.968  23.247 -13.261  1.00 42.37           O  
ATOM    890  CB  PHE A 113      27.702  22.708 -16.106  1.00 46.18           C  
ATOM    891  CG  PHE A 113      28.413  23.948 -15.608  1.00 46.16           C  
ATOM    892  CD1 PHE A 113      29.685  23.873 -15.073  1.00 45.42           C  
ATOM    893  CD2 PHE A 113      27.802  25.190 -15.691  1.00 45.61           C  
ATOM    894  CE1 PHE A 113      30.336  25.012 -14.631  1.00 45.96           C  
ATOM    895  CE2 PHE A 113      28.445  26.326 -15.239  1.00 45.89           C  
ATOM    896  CZ  PHE A 113      29.718  26.248 -14.706  1.00 45.73           C  
ATOM    897  N   MET A 114      24.740  23.033 -15.106  1.00 47.99           N  
ATOM    898  CA  MET A 114      23.730  23.888 -14.464  1.00 48.89           C  
ATOM    899  C   MET A 114      22.987  23.168 -13.350  1.00 49.90           C  
ATOM    900  O   MET A 114      22.510  23.790 -12.397  1.00 49.74           O  
ATOM    901  CB  MET A 114      22.750  24.438 -15.500  1.00 49.00           C  
ATOM    902  CG  MET A 114      22.819  25.961 -15.624  1.00 50.05           C  
ATOM    903  SD  MET A 114      24.202  26.642 -14.680  1.00148.36           S  
ATOM    904  CE  MET A 114      23.660  28.334 -14.462  1.00115.59           C  
ATOM    905  N   ALA A 115      22.872  21.845 -13.414  1.00 50.93           N  
ATOM    906  CA  ALA A 115      22.227  21.123 -12.321  1.00 51.17           C  
ATOM    907  C   ALA A 115      23.028  21.229 -11.029  1.00 51.35           C  
ATOM    908  O   ALA A 115      22.498  21.431  -9.939  1.00 55.83           O  
ATOM    909  CB  ALA A 115      22.042  19.663 -12.697  1.00 52.49           C  
ATOM    910  N   TRP A 116      24.342  21.092 -11.129  1.00 49.89           N  
ATOM    911  CA  TRP A 116      25.224  21.203  -9.973  1.00 48.52           C  
ATOM    912  C   TRP A 116      25.160  22.570  -9.317  1.00 50.63           C  
ATOM    913  O   TRP A 116      25.025  22.729  -8.106  1.00 51.10           O  
ATOM    914  CB  TRP A 116      26.658  20.915 -10.433  1.00 44.54           C  
ATOM    915  CG  TRP A 116      26.934  19.444 -10.542  1.00 40.80           C  
ATOM    916  CD1 TRP A 116      26.315  18.418  -9.898  1.00 37.55           C  
ATOM    917  CD2 TRP A 116      27.944  18.859 -11.379  1.00 40.19           C  
ATOM    918  NE1 TRP A 116      26.874  17.219 -10.281  1.00 37.02           N  
ATOM    919  CE2 TRP A 116      27.873  17.465 -11.188  1.00 38.82           C  
ATOM    920  CE3 TRP A 116      28.887  19.397 -12.262  1.00 40.05           C  
ATOM    921  CZ2 TRP A 116      28.731  16.603 -11.867  1.00 39.67           C  
ATOM    922  CZ3 TRP A 116      29.739  18.535 -12.934  1.00 39.88           C  
ATOM    923  CH2 TRP A 116      29.646  17.154 -12.726  1.00 40.10           C  
ATOM    924  N   ARG A 117      25.268  23.615 -10.138  1.00 51.97           N  
ATOM    925  CA  ARG A 117      25.309  24.952  -9.567  1.00 53.07           C  
ATOM    926  C   ARG A 117      24.001  25.344  -8.909  1.00 53.04           C  
ATOM    927  O   ARG A 117      23.990  26.147  -7.972  1.00 55.22           O  
ATOM    928  CB  ARG A 117      25.665  25.977 -10.659  1.00 55.44           C  
ATOM    929  CG  ARG A 117      26.491  27.127 -10.100  1.00 58.01           C  
ATOM    930  CD  ARG A 117      27.073  28.009 -11.191  1.00 59.73           C  
ATOM    931  NE  ARG A 117      26.539  29.368 -11.089  1.00 60.73           N  
ATOM    932  CZ  ARG A 117      25.268  29.699 -11.274  1.00 60.39           C  
ATOM    933  NH1 ARG A 117      24.363  28.776 -11.579  1.00 59.72           N  
ATOM    934  NH2 ARG A 117      24.907  30.970 -11.154  1.00 59.53           N  
ATOM    935  N   ARG A 118      22.869  24.827  -9.385  1.00 51.81           N  
ATOM    936  CA  ARG A 118      21.614  25.400  -8.921  1.00 51.62           C  
ATOM    937  C   ARG A 118      20.554  24.400  -8.501  1.00 51.36           C  
ATOM    938  O   ARG A 118      19.593  24.860  -7.878  1.00 57.18           O  
ATOM    939  CB  ARG A 118      20.995  26.259 -10.036  1.00 53.27           C  
ATOM    940  CG  ARG A 118      21.939  27.315 -10.585  1.00 55.44           C  
ATOM    941  CD  ARG A 118      22.145  28.439  -9.589  1.00 55.72           C  
ATOM    942  NE  ARG A 118      21.034  29.388  -9.583  1.00 55.53           N  
ATOM    943  CZ  ARG A 118      21.096  30.570  -8.983  1.00 54.50           C  
ATOM    944  NH1 ARG A 118      22.206  30.930  -8.356  1.00 52.43           N  
ATOM    945  NH2 ARG A 118      20.043  31.373  -9.024  1.00 53.55           N  
ATOM    946  N   SER A 119      20.676  23.119  -8.830  1.00 49.52           N  
ATOM    947  CA  SER A 119      19.624  22.164  -8.484  1.00 46.53           C  
ATOM    948  C   SER A 119      19.307  22.224  -6.992  1.00 45.26           C  
ATOM    949  O   SER A 119      20.186  22.004  -6.150  1.00 48.37           O  
ATOM    950  CB  SER A 119      20.006  20.729  -8.843  1.00 45.53           C  
ATOM    951  OG  SER A 119      19.103  19.811  -8.237  1.00 43.17           O  
ATOM    952  N   TYR A 120      18.050  22.513  -6.670  1.00 42.05           N  
ATOM    953  CA  TYR A 120      17.707  22.729  -5.266  1.00 38.69           C  
ATOM    954  C   TYR A 120      17.993  21.523  -4.384  1.00 37.17           C  
ATOM    955  O   TYR A 120      18.456  21.711  -3.253  1.00 33.15           O  
ATOM    956  CB  TYR A 120      16.229  23.139  -5.134  1.00 37.03           C  
ATOM    957  CG  TYR A 120      15.899  23.542  -3.710  1.00 36.28           C  
ATOM    958  CD1 TYR A 120      16.346  24.749  -3.200  1.00 35.15           C  
ATOM    959  CD2 TYR A 120      15.150  22.721  -2.877  1.00 35.16           C  
ATOM    960  CE1 TYR A 120      16.056  25.137  -1.909  1.00 34.93           C  
ATOM    961  CE2 TYR A 120      14.858  23.103  -1.582  1.00 34.91           C  
ATOM    962  CZ  TYR A 120      15.313  24.310  -1.101  1.00 34.64           C  
ATOM    963  OH  TYR A 120      15.031  24.691   0.197  1.00 35.38           O  
ATOM    964  N   ASP A 121      17.726  20.308  -4.847  1.00 37.79           N  
ATOM    965  CA  ASP A 121      17.803  19.135  -3.978  1.00 39.57           C  
ATOM    966  C   ASP A 121      18.906  18.159  -4.355  1.00 37.91           C  
ATOM    967  O   ASP A 121      19.184  17.197  -3.624  1.00 38.76           O  
ATOM    968  CB  ASP A 121      16.443  18.428  -3.977  1.00 45.71           C  
ATOM    969  CG  ASP A 121      15.600  18.634  -2.739  1.00 50.44           C  
ATOM    970  OD1 ASP A 121      15.908  18.064  -1.664  1.00 59.79           O  
ATOM    971  OD2 ASP A 121      14.585  19.365  -2.792  1.00 57.65           O  
ATOM    972  N   THR A 122      19.599  18.330  -5.476  1.00 37.25           N  
ATOM    973  CA  THR A 122      20.690  17.416  -5.797  1.00 37.41           C  
ATOM    974  C   THR A 122      22.041  18.125  -5.696  1.00 37.34           C  
ATOM    975  O   THR A 122      22.383  19.041  -6.438  1.00 39.08           O  
ATOM    976  CB  THR A 122      20.593  16.809  -7.208  1.00 38.23           C  
ATOM    977  OG1 THR A 122      19.316  16.188  -7.391  1.00 40.24           O  
ATOM    978  CG2 THR A 122      21.635  15.709  -7.372  1.00 36.19           C  
ATOM    979  N   PRO A 123      22.838  17.695  -4.730  1.00 35.63           N  
ATOM    980  CA  PRO A 123      24.172  18.270  -4.568  1.00 35.19           C  
ATOM    981  C   PRO A 123      25.215  17.687  -5.511  1.00 34.55           C  
ATOM    982  O   PRO A 123      25.023  16.600  -6.071  1.00 33.51           O  
ATOM    983  CB  PRO A 123      24.521  17.852  -3.134  1.00 35.05           C  
ATOM    984  CG  PRO A 123      23.763  16.594  -2.902  1.00 34.54           C  
ATOM    985  CD  PRO A 123      22.519  16.674  -3.728  1.00 35.05           C  
ATOM    986  N   PRO A 124      26.324  18.399  -5.660  1.00 32.84           N  
ATOM    987  CA  PRO A 124      27.429  17.861  -6.464  1.00 32.93           C  
ATOM    988  C   PRO A 124      27.986  16.615  -5.782  1.00 33.77           C  
ATOM    989  O   PRO A 124      27.637  16.327  -4.636  1.00 33.48           O  
ATOM    990  CB  PRO A 124      28.461  18.980  -6.494  1.00 34.69           C  
ATOM    991  CG  PRO A 124      27.783  20.200  -5.968  1.00 34.84           C  
ATOM    992  CD  PRO A 124      26.639  19.725  -5.107  1.00 33.11           C  
ATOM    993  N   PRO A 125      28.841  15.855  -6.461  1.00 34.95           N  
ATOM    994  CA  PRO A 125      29.366  14.629  -5.838  1.00 35.48           C  
ATOM    995  C   PRO A 125      30.231  14.957  -4.622  1.00 34.47           C  
ATOM    996  O   PRO A 125      30.792  16.045  -4.556  1.00 32.84           O  
ATOM    997  CB  PRO A 125      30.204  13.998  -6.939  1.00 36.73           C  
ATOM    998  CG  PRO A 125      30.392  15.021  -8.002  1.00 36.86           C  
ATOM    999  CD  PRO A 125      29.362  16.096  -7.816  1.00 35.53           C  
ATOM   1000  N   PRO A 126      30.367  14.046  -3.680  1.00 36.43           N  
ATOM   1001  CA  PRO A 126      31.087  14.303  -2.430  1.00 36.62           C  
ATOM   1002  C   PRO A 126      32.582  14.475  -2.632  1.00 37.08           C  
ATOM   1003  O   PRO A 126      33.196  13.800  -3.453  1.00 35.73           O  
ATOM   1004  CB  PRO A 126      30.854  13.011  -1.629  1.00 37.74           C  
ATOM   1005  CG  PRO A 126      30.739  11.981  -2.715  1.00 38.58           C  
ATOM   1006  CD  PRO A 126      29.861  12.659  -3.740  1.00 37.75           C  
ATOM   1007  N   ILE A 127      33.189  15.388  -1.874  1.00 34.95           N  
ATOM   1008  CA  ILE A 127      34.634  15.556  -1.935  1.00 32.53           C  
ATOM   1009  C   ILE A 127      35.351  14.403  -1.234  1.00 31.45           C  
ATOM   1010  O   ILE A 127      34.772  13.741  -0.370  1.00 30.52           O  
ATOM   1011  CB  ILE A 127      35.042  16.901  -1.286  1.00 31.85           C  
ATOM   1012  CG1 ILE A 127      36.389  17.453  -1.737  1.00 32.61           C  
ATOM   1013  CG2 ILE A 127      34.956  16.753   0.231  1.00 31.44           C  
ATOM   1014  CD1 ILE A 127      36.633  18.901  -1.349  1.00 30.99           C  
ATOM   1015  N   GLU A 128      36.604  14.151  -1.592  1.00 32.61           N  
ATOM   1016  CA  GLU A 128      37.416  13.110  -0.963  1.00 33.26           C  
ATOM   1017  C   GLU A 128      37.946  13.591   0.380  1.00 31.00           C  
ATOM   1018  O   GLU A 128      38.651  14.606   0.419  1.00 31.40           O  
ATOM   1019  CB  GLU A 128      38.580  12.732  -1.885  1.00 34.90           C  
ATOM   1020  CG  GLU A 128      39.597  11.809  -1.256  1.00 37.04           C  
ATOM   1021  CD  GLU A 128      40.890  11.567  -1.993  1.00 40.18           C  
ATOM   1022  OE1 GLU A 128      41.230  12.220  -3.001  1.00 42.57           O  
ATOM   1023  OE2 GLU A 128      41.664  10.674  -1.556  1.00 46.39           O  
ATOM   1024  N   ARG A 129      37.605  12.892   1.455  1.00 31.13           N  
ATOM   1025  CA  ARG A 129      38.145  13.226   2.776  1.00 31.02           C  
ATOM   1026  C   ARG A 129      39.657  13.366   2.709  1.00 32.16           C  
ATOM   1027  O   ARG A 129      40.371  12.618   2.032  1.00 33.75           O  
ATOM   1028  CB  ARG A 129      37.737  12.177   3.821  1.00 30.49           C  
ATOM   1029  CG  ARG A 129      36.314  12.332   4.317  1.00 30.37           C  
ATOM   1030  CD  ARG A 129      35.902  11.341   5.399  1.00 29.37           C  
ATOM   1031  NE  ARG A 129      34.452  11.411   5.554  1.00 30.14           N  
ATOM   1032  CZ  ARG A 129      33.798  12.326   6.254  1.00 31.19           C  
ATOM   1033  NH1 ARG A 129      34.437  13.290   6.911  1.00 29.50           N  
ATOM   1034  NH2 ARG A 129      32.475  12.278   6.304  1.00 35.36           N  
ATOM   1035  N   GLY A 130      40.209  14.376   3.390  1.00 31.17           N  
ATOM   1036  CA  GLY A 130      41.645  14.531   3.404  1.00 29.53           C  
ATOM   1037  C   GLY A 130      42.236  15.161   2.168  1.00 28.69           C  
ATOM   1038  O   GLY A 130      43.441  15.443   2.163  1.00 32.59           O  
ATOM   1039  N   SER A 131      41.454  15.396   1.118  1.00 27.95           N  
ATOM   1040  CA  SER A 131      42.024  15.836  -0.158  1.00 27.09           C  
ATOM   1041  C   SER A 131      42.347  17.319  -0.149  1.00 29.33           C  
ATOM   1042  O   SER A 131      41.989  18.061   0.776  1.00 33.88           O  
ATOM   1043  CB  SER A 131      41.076  15.442  -1.301  1.00 23.63           C  
ATOM   1044  OG  SER A 131      39.888  16.198  -1.229  1.00 25.52           O  
ATOM   1045  N   GLN A 132      43.048  17.783  -1.178  1.00 28.18           N  
ATOM   1046  CA  GLN A 132      43.628  19.114  -1.193  1.00 27.82           C  
ATOM   1047  C   GLN A 132      42.629  20.238  -0.913  1.00 27.79           C  
ATOM   1048  O   GLN A 132      43.002  21.154  -0.167  1.00 30.96           O  
ATOM   1049  CB  GLN A 132      44.317  19.357  -2.540  1.00 28.71           C  
ATOM   1050  CG  GLN A 132      45.086  20.669  -2.596  1.00 30.96           C  
ATOM   1051  CD  GLN A 132      45.806  20.856  -3.911  1.00 31.70           C  
ATOM   1052  OE1 GLN A 132      46.589  21.791  -4.053  1.00 39.54           O  
ATOM   1053  NE2 GLN A 132      45.543  19.978  -4.865  1.00 30.69           N  
ATOM   1054  N   PHE A 133      41.425  20.199  -1.449  1.00 28.18           N  
ATOM   1055  CA  PHE A 133      40.448  21.288  -1.264  1.00 26.10           C  
ATOM   1056  C   PHE A 133      39.303  20.949  -0.324  1.00 23.99           C  
ATOM   1057  O   PHE A 133      38.196  21.477  -0.411  1.00 26.95           O  
ATOM   1058  CB  PHE A 133      39.909  21.678  -2.645  1.00 27.54           C  
ATOM   1059  CG  PHE A 133      41.027  21.924  -3.647  1.00 29.24           C  
ATOM   1060  CD1 PHE A 133      41.841  23.029  -3.506  1.00 31.48           C  
ATOM   1061  CD2 PHE A 133      41.248  21.051  -4.695  1.00 30.79           C  
ATOM   1062  CE1 PHE A 133      42.875  23.275  -4.393  1.00 33.58           C  
ATOM   1063  CE2 PHE A 133      42.264  21.278  -5.600  1.00 32.04           C  
ATOM   1064  CZ  PHE A 133      43.073  22.391  -5.448  1.00 33.81           C  
ATOM   1065  N   SER A 134      39.549  20.056   0.623  1.00 23.94           N  
ATOM   1066  CA  SER A 134      38.628  19.624   1.643  1.00 24.27           C  
ATOM   1067  C   SER A 134      38.930  20.278   2.994  1.00 23.65           C  
ATOM   1068  O   SER A 134      40.090  20.467   3.350  1.00 27.47           O  
ATOM   1069  CB  SER A 134      38.679  18.101   1.867  1.00 25.33           C  
ATOM   1070  OG  SER A 134      37.595  17.766   2.722  1.00 26.36           O  
ATOM   1071  N   GLN A 135      37.856  20.569   3.697  1.00 22.56           N  
ATOM   1072  CA  GLN A 135      37.807  21.244   4.964  1.00 25.10           C  
ATOM   1073  C   GLN A 135      37.570  20.265   6.109  1.00 26.24           C  
ATOM   1074  O   GLN A 135      37.591  20.656   7.273  1.00 26.89           O  
ATOM   1075  CB  GLN A 135      36.670  22.298   4.979  1.00 26.04           C  
ATOM   1076  CG  GLN A 135      36.937  23.487   4.065  1.00 24.85           C  
ATOM   1077  CD  GLN A 135      36.836  23.143   2.596  1.00 23.70           C  
ATOM   1078  OE1 GLN A 135      35.852  22.551   2.165  1.00 26.74           O  
ATOM   1079  NE2 GLN A 135      37.884  23.471   1.854  1.00 24.83           N  
ATOM   1080  N   ASP A 136      37.341  18.991   5.780  1.00 28.56           N  
ATOM   1081  CA  ASP A 136      36.970  18.021   6.808  1.00 28.26           C  
ATOM   1082  C   ASP A 136      37.953  17.970   7.973  1.00 27.08           C  
ATOM   1083  O   ASP A 136      37.498  17.555   9.049  1.00 29.11           O  
ATOM   1084  CB  ASP A 136      36.780  16.620   6.208  1.00 29.48           C  
ATOM   1085  CG  ASP A 136      38.052  15.914   5.789  1.00 29.52           C  
ATOM   1086  OD1 ASP A 136      38.636  16.283   4.750  1.00 29.65           O  
ATOM   1087  OD2 ASP A 136      38.474  14.965   6.490  1.00 28.96           O  
ATOM   1088  N   ALA A 137      39.215  18.359   7.845  1.00 27.11           N  
ATOM   1089  CA  ALA A 137      40.143  18.245   8.972  1.00 30.49           C  
ATOM   1090  C   ALA A 137      40.474  19.594   9.592  1.00 32.83           C  
ATOM   1091  O   ALA A 137      41.331  19.756  10.468  1.00 30.03           O  
ATOM   1092  CB  ALA A 137      41.424  17.538   8.543  1.00 34.71           C  
ATOM   1093  N   ASP A 138      39.763  20.631   9.146  1.00 32.97           N  
ATOM   1094  CA  ASP A 138      39.985  21.960   9.713  1.00 31.80           C  
ATOM   1095  C   ASP A 138      39.400  22.068  11.120  1.00 29.79           C  
ATOM   1096  O   ASP A 138      38.230  21.749  11.337  1.00 25.87           O  
ATOM   1097  CB  ASP A 138      39.396  23.021   8.784  0.53 31.44           C  
ATOM   1099  CG  ASP A 138      40.123  23.071   7.454  0.53 31.24           C  
ATOM   1101  OD1 ASP A 138      41.134  22.356   7.288  0.53 31.51           O  
ATOM   1103  OD2 ASP A 138      39.679  23.835   6.574  0.53 28.85           O  
ATOM   1105  N   PRO A 139      40.166  22.504  12.115  1.00 30.85           N  
ATOM   1106  CA  PRO A 139      39.653  22.569  13.490  1.00 30.04           C  
ATOM   1107  C   PRO A 139      38.382  23.384  13.640  1.00 28.27           C  
ATOM   1108  O   PRO A 139      37.529  23.157  14.506  1.00 30.78           O  
ATOM   1109  CB  PRO A 139      40.775  23.299  14.249  1.00 32.99           C  
ATOM   1110  CG  PRO A 139      42.008  22.925  13.482  1.00 34.74           C  
ATOM   1111  CD  PRO A 139      41.575  22.923  12.045  1.00 32.44           C  
ATOM   1112  N   ARG A 140      38.216  24.385  12.770  1.00 24.69           N  
ATOM   1113  CA  ARG A 140      37.023  25.231  12.961  1.00 23.30           C  
ATOM   1114  C   ARG A 140      35.736  24.451  12.800  1.00 24.31           C  
ATOM   1115  O   ARG A 140      34.689  24.902  13.273  1.00 25.59           O  
ATOM   1116  CB  ARG A 140      37.131  26.438  12.027  1.00 23.19           C  
ATOM   1117  CG  ARG A 140      36.730  26.149  10.593  1.00 25.14           C  
ATOM   1118  CD  ARG A 140      36.937  27.386   9.721  1.00 27.55           C  
ATOM   1119  NE  ARG A 140      38.352  27.571   9.416  1.00 29.33           N  
ATOM   1120  CZ  ARG A 140      38.802  28.432   8.504  1.00 31.07           C  
ATOM   1121  NH1 ARG A 140      37.935  29.179   7.820  1.00 28.46           N  
ATOM   1122  NH2 ARG A 140      40.111  28.524   8.305  1.00 30.92           N  
ATOM   1123  N   TYR A 141      35.763  23.266  12.201  1.00 23.53           N  
ATOM   1124  CA  TYR A 141      34.554  22.471  12.003  1.00 22.29           C  
ATOM   1125  C   TYR A 141      34.575  21.223  12.861  1.00 23.58           C  
ATOM   1126  O   TYR A 141      33.796  20.290  12.679  1.00 26.06           O  
ATOM   1127  CB  TYR A 141      34.380  22.090  10.533  1.00 21.81           C  
ATOM   1128  CG  TYR A 141      34.401  23.298   9.611  1.00 20.96           C  
ATOM   1129  CD1 TYR A 141      33.414  24.272   9.752  1.00 20.90           C  
ATOM   1130  CD2 TYR A 141      35.375  23.450   8.637  1.00 20.70           C  
ATOM   1131  CE1 TYR A 141      33.404  25.383   8.927  1.00 20.31           C  
ATOM   1132  CE2 TYR A 141      35.357  24.572   7.822  1.00 20.88           C  
ATOM   1133  CZ  TYR A 141      34.372  25.523   7.971  1.00 19.80           C  
ATOM   1134  OH  TYR A 141      34.397  26.624   7.149  1.00 23.82           O  
ATOM   1135  N   ALA A 142      35.496  21.228  13.824  1.00 26.05           N  
ATOM   1136  CA  ALA A 142      35.629  20.056  14.692  1.00 27.79           C  
ATOM   1137  C   ALA A 142      34.326  19.685  15.378  1.00 26.59           C  
ATOM   1138  O   ALA A 142      33.968  18.508  15.495  1.00 25.57           O  
ATOM   1139  CB  ALA A 142      36.733  20.318  15.704  1.00 33.04           C  
ATOM   1140  N   ASP A 143      33.572  20.669  15.871  1.00 26.86           N  
ATOM   1141  CA  ASP A 143      32.382  20.312  16.641  1.00 28.39           C  
ATOM   1142  C   ASP A 143      31.261  19.751  15.777  1.00 28.60           C  
ATOM   1143  O   ASP A 143      30.292  19.191  16.305  1.00 28.47           O  
ATOM   1144  CB  ASP A 143      31.849  21.517  17.415  1.00 30.15           C  
ATOM   1145  CG  ASP A 143      32.812  22.015  18.476  1.00 31.64           C  
ATOM   1146  OD1 ASP A 143      33.800  21.297  18.718  1.00 29.07           O  
ATOM   1147  OD2 ASP A 143      32.583  23.108  19.043  1.00 33.49           O  
ATOM   1148  N   ILE A 144      31.367  19.907  14.461  1.00 28.40           N  
ATOM   1149  CA  ILE A 144      30.374  19.292  13.580  1.00 26.51           C  
ATOM   1150  C   ILE A 144      30.986  18.133  12.812  1.00 27.35           C  
ATOM   1151  O   ILE A 144      30.595  17.703  11.721  1.00 29.91           O  
ATOM   1152  CB  ILE A 144      29.788  20.330  12.612  1.00 27.27           C  
ATOM   1153  CG1 ILE A 144      30.830  21.108  11.819  1.00 26.13           C  
ATOM   1154  CG2 ILE A 144      28.850  21.261  13.375  1.00 33.65           C  
ATOM   1155  CD1 ILE A 144      30.227  21.903  10.670  1.00 29.14           C  
ATOM   1156  N   GLY A 145      32.037  17.555  13.377  1.00 27.57           N  
ATOM   1157  CA  GLY A 145      32.600  16.377  12.735  1.00 29.81           C  
ATOM   1158  C   GLY A 145      33.282  16.628  11.407  1.00 29.46           C  
ATOM   1159  O   GLY A 145      33.403  15.717  10.584  1.00 31.20           O  
ATOM   1160  N   GLY A 146      33.738  17.852  11.186  1.00 26.63           N  
ATOM   1161  CA  GLY A 146      34.393  18.263   9.983  1.00 26.07           C  
ATOM   1162  C   GLY A 146      33.473  18.749   8.898  1.00 26.82           C  
ATOM   1163  O   GLY A 146      33.967  19.322   7.924  1.00 28.93           O  
ATOM   1164  N   GLY A 147      32.170  18.543   9.064  1.00 26.73           N  
ATOM   1165  CA  GLY A 147      31.187  19.084   8.169  1.00 25.72           C  
ATOM   1166  C   GLY A 147      30.803  18.174   7.026  1.00 28.43           C  
ATOM   1167  O   GLY A 147      31.241  17.019   6.925  1.00 28.07           O  
ATOM   1168  N   PRO A 148      29.960  18.721   6.146  1.00 30.14           N  
ATOM   1169  CA  PRO A 148      29.456  17.953   5.000  1.00 30.05           C  
ATOM   1170  C   PRO A 148      30.513  17.864   3.908  1.00 28.91           C  
ATOM   1171  O   PRO A 148      31.437  18.676   3.870  1.00 28.60           O  
ATOM   1172  CB  PRO A 148      28.266  18.798   4.539  1.00 31.94           C  
ATOM   1173  CG  PRO A 148      28.691  20.198   4.858  1.00 30.29           C  
ATOM   1174  CD  PRO A 148      29.445  20.100   6.164  1.00 29.22           C  
ATOM   1175  N   LEU A 149      30.383  16.875   3.034  1.00 27.49           N  
ATOM   1176  CA  LEU A 149      31.365  16.658   1.983  1.00 27.41           C  
ATOM   1177  C   LEU A 149      30.880  17.267   0.669  1.00 25.92           C  
ATOM   1178  O   LEU A 149      31.560  17.253  -0.363  1.00 28.02           O  
ATOM   1179  CB  LEU A 149      31.665  15.169   1.814  1.00 27.72           C  
ATOM   1180  CG  LEU A 149      32.345  14.445   2.982  1.00 29.31           C  
ATOM   1181  CD1 LEU A 149      32.683  13.016   2.597  1.00 29.93           C  
ATOM   1182  CD2 LEU A 149      33.599  15.184   3.433  1.00 29.06           C  
ATOM   1183  N   THR A 150      29.678  17.801   0.754  1.00 26.08           N  
ATOM   1184  CA  THR A 150      28.983  18.418  -0.375  1.00 25.80           C  
ATOM   1185  C   THR A 150      27.624  18.913   0.097  1.00 26.37           C  
ATOM   1186  O   THR A 150      27.082  18.415   1.088  1.00 26.52           O  
ATOM   1187  CB  THR A 150      28.823  17.436  -1.543  1.00 27.22           C  
ATOM   1188  OG1 THR A 150      28.136  18.045  -2.637  1.00 30.22           O  
ATOM   1189  CG2 THR A 150      27.938  16.264  -1.138  1.00 28.69           C  
ATOM   1190  N   GLU A 151      27.077  19.884  -0.618  1.00 28.52           N  
ATOM   1191  CA  GLU A 151      25.781  20.457  -0.269  1.00 30.63           C  
ATOM   1192  C   GLU A 151      24.998  20.925  -1.494  1.00 29.75           C  
ATOM   1193  O   GLU A 151      25.578  21.463  -2.437  1.00 27.28           O  
ATOM   1194  CB  GLU A 151      26.024  21.642   0.671  1.00 31.59           C  
ATOM   1195  CG  GLU A 151      26.386  21.324   2.121  1.00 29.98           C  
ATOM   1196  CD  GLU A 151      26.319  22.586   2.982  1.00 28.71           C  
ATOM   1197  OE1 GLU A 151      26.853  23.624   2.533  1.00 27.61           O  
ATOM   1198  OE2 GLU A 151      25.743  22.572   4.090  1.00 26.69           O  
ATOM   1199  N   CYS A 152      23.689  20.732  -1.463  1.00 29.84           N  
ATOM   1200  CA  CYS A 152      22.727  21.397  -2.324  1.00 29.79           C  
ATOM   1201  C   CYS A 152      22.094  22.557  -1.536  1.00 28.82           C  
ATOM   1202  O   CYS A 152      22.278  22.657  -0.321  1.00 27.21           O  
ATOM   1203  CB  CYS A 152      21.638  20.451  -2.844  1.00 27.97           C  
ATOM   1204  SG  CYS A 152      20.565  19.761  -1.572  1.00 35.41           S  
ATOM   1205  N   LEU A 153      21.354  23.436  -2.188  1.00 28.76           N  
ATOM   1206  CA  LEU A 153      20.686  24.558  -1.531  1.00 27.95           C  
ATOM   1207  C   LEU A 153      19.735  24.094  -0.445  1.00 26.92           C  
ATOM   1208  O   LEU A 153      19.628  24.714   0.623  1.00 29.00           O  
ATOM   1209  CB  LEU A 153      19.971  25.446  -2.555  1.00 27.99           C  
ATOM   1210  CG  LEU A 153      19.396  26.769  -2.034  1.00 28.60           C  
ATOM   1211  CD1 LEU A 153      20.460  27.596  -1.324  1.00 26.72           C  
ATOM   1212  CD2 LEU A 153      18.778  27.563  -3.174  1.00 27.78           C  
ATOM   1213  N   ALA A 154      19.026  22.993  -0.645  1.00 27.81           N  
ATOM   1214  CA  ALA A 154      18.191  22.419   0.403  1.00 28.02           C  
ATOM   1215  C   ALA A 154      18.939  22.148   1.706  1.00 27.36           C  
ATOM   1216  O   ALA A 154      18.438  22.389   2.813  1.00 28.97           O  
ATOM   1217  CB  ALA A 154      17.559  21.133  -0.118  1.00 31.22           C  
ATOM   1218  N   ASP A 155      20.150  21.634   1.597  1.00 28.95           N  
ATOM   1219  CA  ASP A 155      21.067  21.380   2.690  1.00 29.22           C  
ATOM   1220  C   ASP A 155      21.439  22.685   3.403  1.00 29.78           C  
ATOM   1221  O   ASP A 155      21.515  22.743   4.633  1.00 29.88           O  
ATOM   1222  CB  ASP A 155      22.357  20.726   2.206  1.00 31.14           C  
ATOM   1223  CG  ASP A 155      22.241  19.327   1.651  1.00 33.24           C  
ATOM   1224  OD1 ASP A 155      21.428  18.496   2.111  1.00 35.90           O  
ATOM   1225  OD2 ASP A 155      22.998  19.010   0.712  1.00 36.77           O  
ATOM   1226  N   VAL A 156      21.676  23.728   2.607  1.00 27.12           N  
ATOM   1227  CA  VAL A 156      22.078  25.012   3.187  1.00 25.23           C  
ATOM   1228  C   VAL A 156      20.911  25.601   3.963  1.00 27.55           C  
ATOM   1229  O   VAL A 156      21.024  26.137   5.062  1.00 27.40           O  
ATOM   1230  CB  VAL A 156      22.580  25.981   2.114  1.00 26.29           C  
ATOM   1231  CG1 VAL A 156      22.875  27.358   2.695  1.00 26.35           C  
ATOM   1232  CG2 VAL A 156      23.849  25.425   1.463  1.00 23.40           C  
ATOM   1233  N   VAL A 157      19.728  25.465   3.362  1.00 28.21           N  
ATOM   1234  CA  VAL A 157      18.532  25.946   4.043  1.00 27.66           C  
ATOM   1235  C   VAL A 157      18.347  25.234   5.376  1.00 28.95           C  
ATOM   1236  O   VAL A 157      18.003  25.826   6.406  1.00 28.24           O  
ATOM   1237  CB  VAL A 157      17.311  25.736   3.128  1.00 28.32           C  
ATOM   1238  CG1 VAL A 157      16.037  25.792   3.954  1.00 32.48           C  
ATOM   1239  CG2 VAL A 157      17.316  26.760   2.000  1.00 30.14           C  
ATOM   1240  N   ALA A 158      18.577  23.916   5.406  1.00 28.72           N  
ATOM   1241  CA  ALA A 158      18.360  23.198   6.663  1.00 29.17           C  
ATOM   1242  C   ALA A 158      19.336  23.609   7.755  1.00 28.75           C  
ATOM   1243  O   ALA A 158      19.001  23.678   8.941  1.00 28.79           O  
ATOM   1244  CB  ALA A 158      18.451  21.683   6.428  1.00 27.74           C  
ATOM   1245  N   ARG A 159      20.598  23.885   7.401  1.00 27.85           N  
ATOM   1246  CA  ARG A 159      21.588  24.135   8.438  1.00 27.17           C  
ATOM   1247  C   ARG A 159      21.675  25.628   8.747  1.00 26.81           C  
ATOM   1248  O   ARG A 159      22.212  25.993   9.797  1.00 27.64           O  
ATOM   1249  CB  ARG A 159      22.973  23.599   8.110  1.00 29.76           C  
ATOM   1250  CG  ARG A 159      23.568  23.731   6.731  1.00 27.76           C  
ATOM   1251  CD  ARG A 159      24.305  25.051   6.547  1.00 27.61           C  
ATOM   1252  NE  ARG A 159      25.220  25.021   5.399  1.00 25.71           N  
ATOM   1253  CZ  ARG A 159      25.774  26.103   4.884  1.00 24.41           C  
ATOM   1254  NH1 ARG A 159      25.522  27.310   5.391  1.00 23.89           N  
ATOM   1255  NH2 ARG A 159      26.595  25.994   3.852  1.00 23.11           N  
ATOM   1256  N   PHE A 160      21.148  26.460   7.856  1.00 26.34           N  
ATOM   1257  CA  PHE A 160      21.167  27.901   8.109  1.00 28.29           C  
ATOM   1258  C   PHE A 160      20.039  28.358   9.015  1.00 27.39           C  
ATOM   1259  O   PHE A 160      20.177  29.151   9.941  1.00 23.90           O  
ATOM   1260  CB  PHE A 160      21.096  28.655   6.773  1.00 30.92           C  
ATOM   1261  CG  PHE A 160      20.780  30.130   7.014  1.00 34.67           C  
ATOM   1262  CD1 PHE A 160      21.744  30.961   7.543  1.00 37.10           C  
ATOM   1263  CD2 PHE A 160      19.539  30.650   6.706  1.00 37.00           C  
ATOM   1264  CE1 PHE A 160      21.484  32.297   7.778  1.00 39.38           C  
ATOM   1265  CE2 PHE A 160      19.264  31.981   6.952  1.00 40.18           C  
ATOM   1266  CZ  PHE A 160      20.239  32.807   7.485  1.00 40.50           C  
ATOM   1267  N   LEU A 161      18.819  27.864   8.766  1.00 27.55           N  
ATOM   1268  CA  LEU A 161      17.705  28.389   9.528  1.00 29.02           C  
ATOM   1269  C   LEU A 161      17.776  28.227  11.037  1.00 28.29           C  
ATOM   1270  O   LEU A 161      17.251  29.128  11.732  1.00 30.11           O  
ATOM   1271  CB  LEU A 161      16.396  27.714   9.063  1.00 32.43           C  
ATOM   1272  CG  LEU A 161      15.143  28.496   9.485  1.00 35.03           C  
ATOM   1273  CD1 LEU A 161      15.035  29.753   8.635  1.00 40.51           C  
ATOM   1274  CD2 LEU A 161      13.923  27.595   9.389  1.00 37.73           C  
ATOM   1275  N   PRO A 162      18.306  27.168  11.623  1.00 26.20           N  
ATOM   1276  CA  PRO A 162      18.326  27.132  13.100  1.00 25.63           C  
ATOM   1277  C   PRO A 162      19.076  28.315  13.690  1.00 26.73           C  
ATOM   1278  O   PRO A 162      18.813  28.789  14.793  1.00 27.75           O  
ATOM   1279  CB  PRO A 162      19.061  25.821  13.400  1.00 26.04           C  
ATOM   1280  CG  PRO A 162      18.752  24.974  12.204  1.00 26.31           C  
ATOM   1281  CD  PRO A 162      18.856  25.932  11.049  1.00 26.59           C  
ATOM   1282  N   TYR A 163      20.070  28.813  12.943  1.00 26.86           N  
ATOM   1283  CA  TYR A 163      20.884  29.889  13.498  1.00 24.45           C  
ATOM   1284  C   TYR A 163      20.087  31.177  13.402  1.00 25.58           C  
ATOM   1285  O   TYR A 163      20.066  31.981  14.326  1.00 24.23           O  
ATOM   1286  CB  TYR A 163      22.219  30.007  12.771  1.00 26.01           C  
ATOM   1287  CG  TYR A 163      23.182  30.974  13.411  1.00 25.38           C  
ATOM   1288  CD1 TYR A 163      23.928  30.607  14.518  1.00 27.36           C  
ATOM   1289  CD2 TYR A 163      23.351  32.256  12.910  1.00 26.45           C  
ATOM   1290  CE1 TYR A 163      24.815  31.481  15.121  1.00 28.40           C  
ATOM   1291  CE2 TYR A 163      24.234  33.142  13.498  1.00 27.01           C  
ATOM   1292  CZ  TYR A 163      24.961  32.747  14.597  1.00 28.40           C  
ATOM   1293  OH  TYR A 163      25.847  33.617  15.195  1.00 27.19           O  
ATOM   1294  N   PHE A 164      19.410  31.348  12.264  1.00 26.31           N  
ATOM   1295  CA  PHE A 164      18.548  32.511  12.084  1.00 23.69           C  
ATOM   1296  C   PHE A 164      17.479  32.585  13.174  1.00 24.76           C  
ATOM   1297  O   PHE A 164      17.287  33.633  13.812  1.00 27.31           O  
ATOM   1298  CB  PHE A 164      17.894  32.479  10.703  1.00 26.39           C  
ATOM   1299  CG  PHE A 164      17.107  33.757  10.421  1.00 26.08           C  
ATOM   1300  CD1 PHE A 164      17.783  34.950  10.274  1.00 25.50           C  
ATOM   1301  CD2 PHE A 164      15.729  33.725  10.316  1.00 27.45           C  
ATOM   1302  CE1 PHE A 164      17.059  36.106  10.028  1.00 27.17           C  
ATOM   1303  CE2 PHE A 164      15.000  34.872  10.081  1.00 26.59           C  
ATOM   1304  CZ  PHE A 164      15.683  36.063   9.937  1.00 26.37           C  
ATOM   1305  N   THR A 165      16.744  31.500  13.421  1.00 23.76           N  
ATOM   1306  CA  THR A 165      15.641  31.620  14.369  1.00 24.12           C  
ATOM   1307  C   THR A 165      16.129  31.761  15.798  1.00 25.78           C  
ATOM   1308  O   THR A 165      15.569  32.501  16.604  1.00 28.56           O  
ATOM   1309  CB  THR A 165      14.669  30.430  14.302  1.00 27.08           C  
ATOM   1310  OG1 THR A 165      15.372  29.182  14.397  1.00 30.82           O  
ATOM   1311  CG2 THR A 165      13.933  30.463  12.972  1.00 30.36           C  
ATOM   1312  N   ASP A 166      17.182  31.009  16.141  1.00 25.28           N  
ATOM   1313  CA  ASP A 166      17.531  30.942  17.555  1.00 25.22           C  
ATOM   1314  C   ASP A 166      18.522  32.020  17.964  1.00 23.52           C  
ATOM   1315  O   ASP A 166      18.675  32.273  19.169  1.00 26.15           O  
ATOM   1316  CB  ASP A 166      18.101  29.567  17.873  1.00 28.71           C  
ATOM   1317  CG  ASP A 166      17.116  28.423  17.830  1.00 31.53           C  
ATOM   1318  OD1 ASP A 166      16.088  28.489  17.131  1.00 31.73           O  
ATOM   1319  OD2 ASP A 166      17.407  27.415  18.516  1.00 36.81           O  
ATOM   1320  N   VAL A 167      19.190  32.650  16.992  1.00 23.25           N  
ATOM   1321  CA  VAL A 167      20.175  33.672  17.350  1.00 22.43           C  
ATOM   1322  C   VAL A 167      19.789  35.015  16.762  1.00 23.64           C  
ATOM   1323  O   VAL A 167      19.577  35.980  17.485  1.00 25.34           O  
ATOM   1324  CB  VAL A 167      21.590  33.234  16.916  1.00 24.27           C  
ATOM   1325  CG1 VAL A 167      22.636  34.315  17.080  1.00 25.38           C  
ATOM   1326  CG2 VAL A 167      22.020  32.022  17.742  1.00 27.50           C  
ATOM   1327  N   ILE A 168      19.671  35.119  15.443  1.00 24.26           N  
ATOM   1328  CA  ILE A 168      19.498  36.419  14.800  1.00 23.13           C  
ATOM   1329  C   ILE A 168      18.118  37.030  15.011  1.00 24.79           C  
ATOM   1330  O   ILE A 168      17.999  38.234  15.288  1.00 23.92           O  
ATOM   1331  CB  ILE A 168      19.835  36.244  13.295  1.00 22.55           C  
ATOM   1332  CG1 ILE A 168      21.257  35.714  13.095  1.00 22.65           C  
ATOM   1333  CG2 ILE A 168      19.600  37.519  12.519  1.00 22.79           C  
ATOM   1334  CD1 ILE A 168      21.670  35.486  11.660  1.00 24.65           C  
ATOM   1335  N   VAL A 169      17.031  36.271  14.896  1.00 25.32           N  
ATOM   1336  CA  VAL A 169      15.676  36.798  15.088  1.00 25.63           C  
ATOM   1337  C   VAL A 169      15.491  37.534  16.408  1.00 25.82           C  
ATOM   1338  O   VAL A 169      14.861  38.587  16.473  1.00 26.13           O  
ATOM   1339  CB  VAL A 169      14.634  35.654  14.989  1.00 24.44           C  
ATOM   1340  CG1 VAL A 169      13.315  36.040  15.620  1.00 24.34           C  
ATOM   1341  CG2 VAL A 169      14.453  35.251  13.533  1.00 24.47           C  
ATOM   1342  N   GLY A 170      16.022  37.022  17.504  1.00 27.14           N  
ATOM   1343  CA  GLY A 170      15.860  37.676  18.797  1.00 27.90           C  
ATOM   1344  C   GLY A 170      16.499  39.042  18.828  1.00 28.22           C  
ATOM   1345  O   GLY A 170      16.036  39.947  19.530  1.00 27.12           O  
ATOM   1346  N   ASP A 171      17.573  39.211  18.049  1.00 26.61           N  
ATOM   1347  CA  ASP A 171      18.150  40.537  17.894  1.00 24.36           C  
ATOM   1348  C   ASP A 171      17.153  41.465  17.205  1.00 24.24           C  
ATOM   1349  O   ASP A 171      16.936  42.592  17.642  1.00 24.72           O  
ATOM   1350  CB  ASP A 171      19.470  40.513  17.115  1.00 24.71           C  
ATOM   1351  CG  ASP A 171      20.664  40.270  18.021  1.00 27.71           C  
ATOM   1352  OD1 ASP A 171      20.490  40.265  19.261  1.00 31.60           O  
ATOM   1353  OD2 ASP A 171      21.803  40.081  17.556  1.00 31.19           O  
ATOM   1354  N   LEU A 172      16.559  40.988  16.113  1.00 22.43           N  
ATOM   1355  CA  LEU A 172      15.589  41.763  15.373  1.00 23.05           C  
ATOM   1356  C   LEU A 172      14.373  42.121  16.222  1.00 26.80           C  
ATOM   1357  O   LEU A 172      13.772  43.189  16.170  1.00 25.33           O  
ATOM   1358  CB  LEU A 172      15.171  40.921  14.155  1.00 22.05           C  
ATOM   1359  CG  LEU A 172      16.231  40.716  13.068  1.00 22.81           C  
ATOM   1360  CD1 LEU A 172      15.765  39.713  12.019  1.00 25.48           C  
ATOM   1361  CD2 LEU A 172      16.570  42.044  12.407  1.00 23.80           C  
ATOM   1362  N   ARG A 173      13.988  41.158  17.059  1.00 27.98           N  
ATOM   1363  CA  ARG A 173      12.799  41.343  17.883  1.00 30.36           C  
ATOM   1364  C   ARG A 173      12.928  42.481  18.878  1.00 28.32           C  
ATOM   1365  O   ARG A 173      11.955  43.155  19.241  1.00 31.87           O  
ATOM   1366  CB  ARG A 173      12.533  40.030  18.635  1.00 34.12           C  
ATOM   1367  CG  ARG A 173      11.719  40.264  19.904  1.00 38.97           C  
ATOM   1368  CD  ARG A 173      10.379  39.567  19.780  1.00 43.03           C  
ATOM   1369  NE  ARG A 173      10.451  38.356  18.962  1.00 45.02           N  
ATOM   1370  CZ  ARG A 173       9.728  38.179  17.854  1.00 43.82           C  
ATOM   1371  NH1 ARG A 173       8.893  39.138  17.451  1.00 36.12           N  
ATOM   1372  NH2 ARG A 173       9.869  37.039  17.181  1.00 34.07           N  
ATOM   1373  N   VAL A 174      14.160  42.709  19.344  1.00 23.82           N  
ATOM   1374  CA  VAL A 174      14.327  43.793  20.311  1.00 23.39           C  
ATOM   1375  C   VAL A 174      14.739  45.088  19.626  1.00 24.43           C  
ATOM   1376  O   VAL A 174      15.100  46.030  20.330  1.00 27.49           O  
ATOM   1377  CB  VAL A 174      15.339  43.457  21.423  1.00 24.01           C  
ATOM   1378  CG1 VAL A 174      14.800  42.325  22.280  1.00 30.26           C  
ATOM   1379  CG2 VAL A 174      16.705  43.090  20.872  1.00 24.91           C  
ATOM   1380  N   GLY A 175      14.666  45.115  18.298  1.00 23.51           N  
ATOM   1381  CA  GLY A 175      14.760  46.342  17.536  1.00 24.72           C  
ATOM   1382  C   GLY A 175      16.135  46.660  17.012  1.00 21.98           C  
ATOM   1383  O   GLY A 175      16.342  47.765  16.519  1.00 23.11           O  
ATOM   1384  N   LYS A 176      17.072  45.714  17.106  1.00 21.84           N  
ATOM   1385  CA  LYS A 176      18.401  45.935  16.571  1.00 22.32           C  
ATOM   1386  C   LYS A 176      18.448  45.895  15.050  1.00 22.02           C  
ATOM   1387  O   LYS A 176      17.824  45.071  14.398  1.00 24.10           O  
ATOM   1388  CB  LYS A 176      19.408  44.898  17.108  1.00 23.83           C  
ATOM   1389  CG  LYS A 176      19.648  44.966  18.595  1.00 25.67           C  
ATOM   1390  CD  LYS A 176      20.614  43.907  19.087  1.00 28.90           C  
ATOM   1391  CE  LYS A 176      20.817  44.040  20.591  1.00 31.36           C  
ATOM   1392  NZ  LYS A 176      21.954  43.205  21.068  1.00 37.11           N  
ATOM   1393  N   THR A 177      19.233  46.815  14.474  1.00 22.79           N  
ATOM   1394  CA  THR A 177      19.593  46.736  13.076  1.00 22.63           C  
ATOM   1395  C   THR A 177      20.680  45.675  12.890  1.00 23.07           C  
ATOM   1396  O   THR A 177      21.782  45.841  13.410  1.00 27.29           O  
ATOM   1397  CB  THR A 177      20.114  48.071  12.517  1.00 23.53           C  
ATOM   1398  OG1 THR A 177      19.053  49.023  12.609  1.00 25.56           O  
ATOM   1399  CG2 THR A 177      20.459  47.932  11.035  1.00 23.47           C  
ATOM   1400  N   VAL A 178      20.349  44.614  12.162  1.00 21.02           N  
ATOM   1401  CA  VAL A 178      21.268  43.496  12.021  1.00 21.26           C  
ATOM   1402  C   VAL A 178      21.850  43.478  10.611  1.00 23.55           C  
ATOM   1403  O   VAL A 178      21.100  43.579   9.649  1.00 23.30           O  
ATOM   1404  CB  VAL A 178      20.565  42.153  12.294  1.00 21.36           C  
ATOM   1405  CG1 VAL A 178      21.470  40.987  11.940  1.00 20.34           C  
ATOM   1406  CG2 VAL A 178      20.099  42.054  13.739  1.00 26.87           C  
ATOM   1407  N   LEU A 179      23.174  43.334  10.532  1.00 23.70           N  
ATOM   1408  CA  LEU A 179      23.866  43.179   9.269  1.00 21.78           C  
ATOM   1409  C   LEU A 179      24.390  41.748   9.182  1.00 21.44           C  
ATOM   1410  O   LEU A 179      25.151  41.337  10.069  1.00 22.60           O  
ATOM   1411  CB  LEU A 179      25.024  44.171   9.102  1.00 22.59           C  
ATOM   1412  CG  LEU A 179      25.911  44.011   7.873  1.00 23.57           C  
ATOM   1413  CD1 LEU A 179      25.131  44.333   6.599  1.00 24.14           C  
ATOM   1414  CD2 LEU A 179      27.159  44.876   7.971  1.00 24.91           C  
ATOM   1415  N   ILE A 180      23.957  41.050   8.141  1.00 20.23           N  
ATOM   1416  CA  ILE A 180      24.518  39.745   7.801  1.00 22.29           C  
ATOM   1417  C   ILE A 180      25.366  39.867   6.536  1.00 22.97           C  
ATOM   1418  O   ILE A 180      24.911  40.233   5.466  1.00 21.25           O  
ATOM   1419  CB  ILE A 180      23.419  38.686   7.616  1.00 23.90           C  
ATOM   1420  CG1 ILE A 180      22.451  38.601   8.806  1.00 24.58           C  
ATOM   1421  CG2 ILE A 180      24.013  37.321   7.306  1.00 24.44           C  
ATOM   1422  CD1 ILE A 180      21.281  37.671   8.594  1.00 24.01           C  
ATOM   1423  N   VAL A 181      26.647  39.547   6.642  1.00 22.27           N  
ATOM   1424  CA  VAL A 181      27.534  39.528   5.497  1.00 22.45           C  
ATOM   1425  C   VAL A 181      27.881  38.074   5.223  1.00 22.38           C  
ATOM   1426  O   VAL A 181      28.528  37.434   6.044  1.00 24.46           O  
ATOM   1427  CB  VAL A 181      28.780  40.373   5.736  1.00 21.93           C  
ATOM   1428  CG1 VAL A 181      29.748  40.300   4.560  1.00 24.03           C  
ATOM   1429  CG2 VAL A 181      28.374  41.820   5.979  1.00 24.11           C  
ATOM   1430  N   ALA A 182      27.384  37.595   4.085  1.00 22.24           N  
ATOM   1431  CA  ALA A 182      27.598  36.192   3.749  1.00 21.62           C  
ATOM   1432  C   ALA A 182      27.681  35.978   2.248  1.00 21.20           C  
ATOM   1433  O   ALA A 182      28.318  36.759   1.537  1.00 24.40           O  
ATOM   1434  CB  ALA A 182      26.515  35.362   4.435  1.00 24.83           C  
ATOM   1435  N   HIS A 183      27.083  34.912   1.729  1.00 22.54           N  
ATOM   1436  CA  HIS A 183      27.391  34.399   0.409  1.00 23.64           C  
ATOM   1437  C   HIS A 183      26.142  34.151  -0.417  1.00 25.63           C  
ATOM   1438  O   HIS A 183      25.029  34.192   0.112  1.00 26.59           O  
ATOM   1439  CB  HIS A 183      28.190  33.088   0.568  1.00 24.68           C  
ATOM   1440  CG  HIS A 183      29.310  33.199   1.575  1.00 26.18           C  
ATOM   1441  ND1 HIS A 183      30.598  33.503   1.199  1.00 24.41           N  
ATOM   1442  CD2 HIS A 183      29.347  33.065   2.925  1.00 24.97           C  
ATOM   1443  CE1 HIS A 183      31.378  33.543   2.268  1.00 23.49           C  
ATOM   1444  NE2 HIS A 183      30.653  33.283   3.343  1.00 23.36           N  
ATOM   1445  N   GLY A 184      26.347  33.880  -1.705  1.00 26.31           N  
ATOM   1446  CA  GLY A 184      25.240  33.634  -2.601  1.00 26.52           C  
ATOM   1447  C   GLY A 184      24.219  32.664  -2.088  1.00 25.44           C  
ATOM   1448  O   GLY A 184      23.029  32.966  -1.929  1.00 29.53           O  
ATOM   1449  N   ASN A 185      24.613  31.430  -1.818  1.00 26.00           N  
ATOM   1450  CA  ASN A 185      23.613  30.430  -1.455  1.00 30.61           C  
ATOM   1451  C   ASN A 185      23.021  30.603  -0.077  1.00 29.93           C  
ATOM   1452  O   ASN A 185      21.862  30.254   0.179  1.00 28.51           O  
ATOM   1453  CB  ASN A 185      24.248  29.026  -1.531  1.00 35.81           C  
ATOM   1454  CG  ASN A 185      24.462  28.619  -2.982  1.00 38.07           C  
ATOM   1455  OD1 ASN A 185      23.501  28.263  -3.661  1.00 44.06           O  
ATOM   1456  ND2 ASN A 185      25.706  28.678  -3.439  1.00 37.11           N  
ATOM   1457  N   SER A 186      23.828  31.112   0.863  1.00 29.29           N  
ATOM   1458  CA  SER A 186      23.275  31.186   2.225  1.00 27.09           C  
ATOM   1459  C   SER A 186      22.282  32.328   2.318  1.00 25.08           C  
ATOM   1460  O   SER A 186      21.268  32.312   3.019  1.00 25.30           O  
ATOM   1461  CB  SER A 186      24.417  31.303   3.233  1.00 27.39           C  
ATOM   1462  OG  SER A 186      25.403  32.230   2.817  1.00 22.95           O  
ATOM   1463  N   LEU A 187      22.563  33.398   1.558  1.00 24.42           N  
ATOM   1464  CA  LEU A 187      21.608  34.503   1.572  1.00 24.39           C  
ATOM   1465  C   LEU A 187      20.373  34.116   0.772  1.00 25.81           C  
ATOM   1466  O   LEU A 187      19.247  34.474   1.117  1.00 27.40           O  
ATOM   1467  CB  LEU A 187      22.275  35.760   1.039  1.00 24.94           C  
ATOM   1468  CG  LEU A 187      23.447  36.274   1.875  1.00 26.80           C  
ATOM   1469  CD1 LEU A 187      24.082  37.477   1.204  1.00 28.67           C  
ATOM   1470  CD2 LEU A 187      22.996  36.621   3.288  1.00 28.88           C  
ATOM   1471  N   ARG A 188      20.592  33.354  -0.299  1.00 27.36           N  
ATOM   1472  CA  ARG A 188      19.413  32.849  -1.022  1.00 30.50           C  
ATOM   1473  C   ARG A 188      18.600  31.914  -0.144  1.00 30.35           C  
ATOM   1474  O   ARG A 188      17.368  31.894  -0.208  1.00 28.31           O  
ATOM   1475  CB  ARG A 188      19.836  32.174  -2.330  1.00 32.25           C  
ATOM   1476  CG  ARG A 188      20.447  33.154  -3.328  1.00 36.37           C  
ATOM   1477  CD  ARG A 188      20.305  32.663  -4.761  1.00 41.04           C  
ATOM   1478  NE  ARG A 188      21.113  31.483  -4.985  1.00 43.71           N  
ATOM   1479  CZ  ARG A 188      20.757  30.328  -5.509  1.00 45.53           C  
ATOM   1480  NH1 ARG A 188      19.524  30.103  -5.932  1.00 47.40           N  
ATOM   1481  NH2 ARG A 188      21.679  29.377  -5.613  1.00 48.95           N  
ATOM   1482  N   ALA A 189      19.272  31.127   0.703  1.00 28.56           N  
ATOM   1483  CA  ALA A 189      18.529  30.291   1.641  1.00 29.31           C  
ATOM   1484  C   ALA A 189      17.680  31.141   2.579  1.00 29.68           C  
ATOM   1485  O   ALA A 189      16.528  30.807   2.866  1.00 28.97           O  
ATOM   1486  CB  ALA A 189      19.487  29.413   2.429  1.00 28.24           C  
ATOM   1487  N   LEU A 190      18.232  32.251   3.072  1.00 28.04           N  
ATOM   1488  CA  LEU A 190      17.462  33.123   3.960  1.00 28.09           C  
ATOM   1489  C   LEU A 190      16.278  33.772   3.247  1.00 27.12           C  
ATOM   1490  O   LEU A 190      15.143  33.826   3.749  1.00 25.44           O  
ATOM   1491  CB  LEU A 190      18.360  34.196   4.558  1.00 29.09           C  
ATOM   1492  CG  LEU A 190      17.752  35.299   5.410  1.00 30.14           C  
ATOM   1493  CD1 LEU A 190      16.863  34.736   6.504  1.00 31.90           C  
ATOM   1494  CD2 LEU A 190      18.855  36.147   6.052  1.00 28.46           C  
ATOM   1495  N   VAL A 191      16.529  34.278   2.049  1.00 26.94           N  
ATOM   1496  CA  VAL A 191      15.464  34.933   1.282  1.00 28.01           C  
ATOM   1497  C   VAL A 191      14.331  33.952   0.998  1.00 29.51           C  
ATOM   1498  O   VAL A 191      13.144  34.302   1.078  1.00 25.60           O  
ATOM   1499  CB  VAL A 191      16.049  35.552  -0.001  1.00 27.74           C  
ATOM   1500  CG1 VAL A 191      14.975  35.992  -0.982  1.00 30.04           C  
ATOM   1501  CG2 VAL A 191      16.929  36.755   0.329  1.00 27.06           C  
ATOM   1502  N   LYS A 192      14.685  32.705   0.670  1.00 29.65           N  
ATOM   1503  CA  LYS A 192      13.687  31.676   0.431  1.00 29.57           C  
ATOM   1504  C   LYS A 192      12.740  31.590   1.635  1.00 28.93           C  
ATOM   1505  O   LYS A 192      11.531  31.435   1.497  1.00 29.30           O  
ATOM   1506  CB  LYS A 192      14.312  30.305   0.146  1.00 30.71           C  
ATOM   1507  CG  LYS A 192      13.337  29.287  -0.437  1.00 31.83           C  
ATOM   1508  CD  LYS A 192      13.763  27.845  -0.265  1.00 34.93           C  
ATOM   1509  CE  LYS A 192      12.964  26.884  -1.140  1.00 36.41           C  
ATOM   1510  NZ  LYS A 192      11.554  26.748  -0.696  1.00 35.66           N  
ATOM   1511  N   HIS A 193      13.320  31.695   2.825  1.00 27.65           N  
ATOM   1512  CA  HIS A 193      12.579  31.526   4.068  1.00 27.74           C  
ATOM   1513  C   HIS A 193      11.765  32.784   4.375  1.00 27.45           C  
ATOM   1514  O   HIS A 193      10.586  32.677   4.720  1.00 27.02           O  
ATOM   1515  CB  HIS A 193      13.530  31.211   5.214  1.00 27.85           C  
ATOM   1516  CG  HIS A 193      12.905  31.196   6.574  1.00 30.89           C  
ATOM   1517  ND1 HIS A 193      12.199  30.129   7.075  1.00 33.19           N  
ATOM   1518  CD2 HIS A 193      12.897  32.125   7.560  1.00 32.49           C  
ATOM   1519  CE1 HIS A 193      11.780  30.404   8.297  1.00 33.63           C  
ATOM   1520  NE2 HIS A 193      12.188  31.618   8.616  1.00 32.51           N  
ATOM   1521  N   LEU A 194      12.385  33.950   4.235  1.00 26.68           N  
ATOM   1522  CA  LEU A 194      11.672  35.188   4.559  1.00 27.89           C  
ATOM   1523  C   LEU A 194      10.435  35.376   3.686  1.00 29.12           C  
ATOM   1524  O   LEU A 194       9.364  35.689   4.204  1.00 30.67           O  
ATOM   1525  CB  LEU A 194      12.569  36.420   4.430  1.00 29.05           C  
ATOM   1526  CG  LEU A 194      13.743  36.513   5.424  1.00 30.62           C  
ATOM   1527  CD1 LEU A 194      14.675  37.635   5.001  1.00 28.79           C  
ATOM   1528  CD2 LEU A 194      13.278  36.694   6.866  1.00 31.72           C  
ATOM   1529  N   ASP A 195      10.616  35.202   2.388  1.00 31.11           N  
ATOM   1530  CA  ASP A 195       9.572  35.456   1.399  1.00 31.24           C  
ATOM   1531  C   ASP A 195       8.770  34.197   1.109  1.00 32.96           C  
ATOM   1532  O   ASP A 195       7.892  34.199   0.235  1.00 32.57           O  
ATOM   1533  CB  ASP A 195      10.216  36.020   0.128  1.00 30.11           C  
ATOM   1534  CG  ASP A 195      10.613  37.475   0.268  1.00 31.35           C  
ATOM   1535  OD1 ASP A 195       9.853  38.249   0.888  1.00 31.53           O  
ATOM   1536  OD2 ASP A 195      11.686  37.884  -0.234  1.00 31.02           O  
ATOM   1537  N   GLN A 196       9.086  33.121   1.823  1.00 33.40           N  
ATOM   1538  CA  GLN A 196       8.402  31.840   1.658  1.00 34.93           C  
ATOM   1539  C   GLN A 196       8.319  31.437   0.195  1.00 35.23           C  
ATOM   1540  O   GLN A 196       7.260  31.125  -0.371  1.00 34.86           O  
ATOM   1541  CB  GLN A 196       7.002  31.913   2.280  1.00 37.80           C  
ATOM   1542  CG  GLN A 196       7.033  31.728   3.800  1.00 39.17           C  
ATOM   1543  CD  GLN A 196       7.574  30.352   4.155  1.00 41.73           C  
ATOM   1544  OE1 GLN A 196       6.894  29.331   4.008  1.00 43.63           O  
ATOM   1545  NE2 GLN A 196       8.815  30.325   4.634  1.00 41.95           N  
ATOM   1546  N   MET A 197       9.494  31.471  -0.415  1.00 33.43           N  
ATOM   1547  CA  MET A 197       9.601  31.146  -1.831  1.00 34.27           C  
ATOM   1548  C   MET A 197       9.561  29.649  -2.081  1.00 34.11           C  
ATOM   1549  O   MET A 197      10.022  28.843  -1.274  1.00 35.55           O  
ATOM   1550  CB  MET A 197      10.902  31.733  -2.385  1.00 34.89           C  
ATOM   1551  CG  MET A 197      10.795  33.247  -2.551  1.00 33.73           C  
ATOM   1552  SD  MET A 197      12.343  33.950  -3.158  1.00 42.83           S  
ATOM   1553  CE  MET A 197      11.848  35.670  -3.354  1.00 49.59           C  
ATOM   1554  N   SER A 198       9.008  29.269  -3.236  1.00 34.19           N  
ATOM   1555  CA  SER A 198       9.029  27.857  -3.597  1.00 35.64           C  
ATOM   1556  C   SER A 198      10.432  27.391  -3.978  1.00 36.85           C  
ATOM   1557  O   SER A 198      11.301  28.194  -4.326  1.00 37.49           O  
ATOM   1558  CB  SER A 198       8.070  27.572  -4.761  1.00 36.10           C  
ATOM   1559  OG  SER A 198       8.520  28.147  -5.965  1.00 38.26           O  
ATOM   1560  N   ASP A 199      10.619  26.078  -3.919  1.00 39.09           N  
ATOM   1561  CA  ASP A 199      11.838  25.476  -4.459  1.00 42.02           C  
ATOM   1562  C   ASP A 199      12.095  25.959  -5.872  1.00 43.83           C  
ATOM   1563  O   ASP A 199      13.180  26.343  -6.293  1.00 44.22           O  
ATOM   1564  CB  ASP A 199      11.706  23.953  -4.454  1.00 44.01           C  
ATOM   1565  CG  ASP A 199      11.858  23.398  -3.052  1.00 46.21           C  
ATOM   1566  OD1 ASP A 199      11.619  24.156  -2.089  1.00 46.24           O  
ATOM   1567  OD2 ASP A 199      12.228  22.214  -2.938  1.00 54.91           O  
ATOM   1568  N   ASP A 200      11.025  25.947  -6.669  1.00 46.42           N  
ATOM   1569  CA  ASP A 200      11.213  26.356  -8.060  1.00 47.71           C  
ATOM   1570  C   ASP A 200      11.606  27.818  -8.145  1.00 45.81           C  
ATOM   1571  O   ASP A 200      12.534  28.156  -8.883  1.00 51.38           O  
ATOM   1572  CB  ASP A 200       9.933  26.087  -8.855  1.00 49.96           C  
ATOM   1573  CG  ASP A 200       9.995  24.814  -9.668  1.00 50.98           C  
ATOM   1574  OD1 ASP A 200       9.978  23.719  -9.070  1.00 54.61           O  
ATOM   1575  OD2 ASP A 200      10.052  24.894 -10.912  1.00 55.80           O  
ATOM   1576  N   GLU A 201      10.916  28.686  -7.402  1.00 43.24           N  
ATOM   1577  CA  GLU A 201      11.235  30.114  -7.535  1.00 43.89           C  
ATOM   1578  C   GLU A 201      12.648  30.416  -7.087  1.00 41.17           C  
ATOM   1579  O   GLU A 201      13.344  31.230  -7.693  1.00 40.88           O  
ATOM   1580  CB  GLU A 201      10.225  30.967  -6.754  1.00 47.87           C  
ATOM   1581  CG  GLU A 201      10.312  32.472  -6.917  1.00 52.55           C  
ATOM   1582  CD  GLU A 201       9.035  33.219  -6.559  1.00 55.69           C  
ATOM   1583  OE1 GLU A 201       7.952  32.587  -6.520  1.00 59.72           O  
ATOM   1584  OE2 GLU A 201       9.080  34.447  -6.311  1.00 57.48           O  
ATOM   1585  N   ILE A 202      13.186  29.818  -6.015  1.00 41.11           N  
ATOM   1586  CA  ILE A 202      14.463  30.411  -5.598  1.00 41.18           C  
ATOM   1587  C   ILE A 202      15.583  29.994  -6.553  1.00 40.15           C  
ATOM   1588  O   ILE A 202      16.642  30.608  -6.512  1.00 31.74           O  
ATOM   1589  CB  ILE A 202      15.022  30.056  -4.208  1.00 42.29           C  
ATOM   1590  CG1 ILE A 202      14.414  28.789  -3.610  1.00 42.12           C  
ATOM   1591  CG2 ILE A 202      14.952  31.258  -3.274  1.00 43.93           C  
ATOM   1592  CD1 ILE A 202      14.840  27.560  -4.395  1.00 40.71           C  
ATOM   1593  N   VAL A 203      15.336  28.962  -7.357  1.00 41.14           N  
ATOM   1594  CA  VAL A 203      16.482  28.553  -8.192  1.00 42.36           C  
ATOM   1595  C   VAL A 203      16.772  29.646  -9.197  1.00 41.23           C  
ATOM   1596  O   VAL A 203      17.909  29.815  -9.633  1.00 45.27           O  
ATOM   1597  CB  VAL A 203      16.241  27.200  -8.873  1.00 45.09           C  
ATOM   1598  CG1 VAL A 203      16.992  27.071 -10.181  1.00 44.69           C  
ATOM   1599  CG2 VAL A 203      16.659  26.096  -7.898  1.00 45.80           C  
ATOM   1600  N   GLY A 204      15.738  30.412  -9.545  1.00 40.79           N  
ATOM   1601  CA  GLY A 204      15.936  31.526 -10.452  1.00 41.38           C  
ATOM   1602  C   GLY A 204      16.480  32.786  -9.824  1.00 41.43           C  
ATOM   1603  O   GLY A 204      16.912  33.675 -10.559  1.00 44.86           O  
ATOM   1604  N   LEU A 205      16.473  32.912  -8.500  1.00 41.14           N  
ATOM   1605  CA  LEU A 205      16.886  34.118  -7.807  1.00 38.72           C  
ATOM   1606  C   LEU A 205      18.386  34.372  -7.811  1.00 39.23           C  
ATOM   1607  O   LEU A 205      19.223  33.555  -7.432  1.00 41.03           O  
ATOM   1608  CB  LEU A 205      16.443  34.082  -6.335  1.00 39.13           C  
ATOM   1609  CG  LEU A 205      17.025  35.261  -5.523  1.00 40.93           C  
ATOM   1610  CD1 LEU A 205      16.222  36.521  -5.806  1.00 45.74           C  
ATOM   1611  CD2 LEU A 205      17.062  34.954  -4.034  1.00 36.15           C  
ATOM   1612  N   ASN A 206      18.776  35.573  -8.232  1.00 39.99           N  
ATOM   1613  CA  ASN A 206      20.186  35.931  -8.173  1.00 42.09           C  
ATOM   1614  C   ASN A 206      20.375  37.147  -7.275  1.00 40.13           C  
ATOM   1615  O   ASN A 206      19.712  38.170  -7.424  1.00 38.41           O  
ATOM   1616  CB  ASN A 206      20.751  36.220  -9.566  1.00 46.12           C  
ATOM   1617  CG  ASN A 206      20.433  35.110 -10.551  1.00 49.69           C  
ATOM   1618  OD1 ASN A 206      21.209  34.164 -10.682  1.00 53.27           O  
ATOM   1619  ND2 ASN A 206      19.294  35.233 -11.230  1.00 53.84           N  
ATOM   1620  N   ILE A 207      21.309  37.020  -6.334  1.00 37.41           N  
ATOM   1621  CA  ILE A 207      21.586  38.161  -5.472  1.00 34.15           C  
ATOM   1622  C   ILE A 207      22.901  38.819  -5.838  1.00 32.56           C  
ATOM   1623  O   ILE A 207      23.954  38.179  -5.851  1.00 31.65           O  
ATOM   1624  CB  ILE A 207      21.633  37.758  -3.991  1.00 33.66           C  
ATOM   1625  CG1 ILE A 207      20.307  37.205  -3.469  1.00 35.20           C  
ATOM   1626  CG2 ILE A 207      22.117  38.949  -3.181  1.00 30.23           C  
ATOM   1627  CD1 ILE A 207      19.235  38.270  -3.344  1.00 40.69           C  
ATOM   1628  N   PRO A 208      22.822  40.101  -6.135  1.00 30.96           N  
ATOM   1629  CA  PRO A 208      23.996  40.824  -6.617  1.00 30.14           C  
ATOM   1630  C   PRO A 208      24.993  41.041  -5.484  1.00 30.81           C  
ATOM   1631  O   PRO A 208      24.590  41.122  -4.326  1.00 27.26           O  
ATOM   1632  CB  PRO A 208      23.417  42.161  -7.063  1.00 32.05           C  
ATOM   1633  CG  PRO A 208      22.277  42.349  -6.104  1.00 32.75           C  
ATOM   1634  CD  PRO A 208      21.646  40.980  -6.007  1.00 33.34           C  
ATOM   1635  N   THR A 209      26.264  41.113  -5.846  1.00 29.92           N  
ATOM   1636  CA  THR A 209      27.312  41.349  -4.867  1.00 30.09           C  
ATOM   1637  C   THR A 209      27.380  42.821  -4.511  1.00 30.80           C  
ATOM   1638  O   THR A 209      27.026  43.643  -5.366  1.00 31.38           O  
ATOM   1639  CB  THR A 209      28.670  40.937  -5.464  1.00 31.82           C  
ATOM   1640  OG1 THR A 209      28.877  41.744  -6.639  1.00 33.58           O  
ATOM   1641  CG2 THR A 209      28.670  39.489  -5.906  1.00 32.73           C  
ATOM   1642  N   GLY A 210      27.843  43.191  -3.322  1.00 30.48           N  
ATOM   1643  CA  GLY A 210      28.129  44.569  -3.015  1.00 29.47           C  
ATOM   1644  C   GLY A 210      26.970  45.469  -2.680  1.00 29.23           C  
ATOM   1645  O   GLY A 210      27.175  46.601  -2.232  1.00 31.42           O  
ATOM   1646  N   ILE A 211      25.727  45.027  -2.860  1.00 27.71           N  
ATOM   1647  CA  ILE A 211      24.635  45.978  -2.634  1.00 27.08           C  
ATOM   1648  C   ILE A 211      23.730  45.509  -1.505  1.00 26.83           C  
ATOM   1649  O   ILE A 211      23.013  44.513  -1.614  1.00 25.60           O  
ATOM   1650  CB  ILE A 211      23.848  46.219  -3.921  1.00 28.17           C  
ATOM   1651  CG1 ILE A 211      24.799  46.567  -5.091  1.00 28.38           C  
ATOM   1652  CG2 ILE A 211      22.773  47.270  -3.747  1.00 30.31           C  
ATOM   1653  CD1 ILE A 211      24.915  45.366  -6.005  1.00 33.89           C  
ATOM   1654  N   PRO A 212      23.762  46.222  -0.388  1.00 26.89           N  
ATOM   1655  CA  PRO A 212      22.931  45.795   0.750  1.00 26.11           C  
ATOM   1656  C   PRO A 212      21.456  45.727   0.400  1.00 25.78           C  
ATOM   1657  O   PRO A 212      20.920  46.580  -0.313  1.00 27.15           O  
ATOM   1658  CB  PRO A 212      23.146  46.900   1.778  1.00 26.58           C  
ATOM   1659  CG  PRO A 212      24.504  47.445   1.441  1.00 26.26           C  
ATOM   1660  CD  PRO A 212      24.541  47.426  -0.058  1.00 26.76           C  
ATOM   1661  N   LEU A 213      20.828  44.698   0.938  1.00 24.25           N  
ATOM   1662  CA  LEU A 213      19.409  44.444   0.808  1.00 24.66           C  
ATOM   1663  C   LEU A 213      18.707  44.608   2.157  1.00 27.93           C  
ATOM   1664  O   LEU A 213      19.004  43.794   3.047  1.00 26.00           O  
ATOM   1665  CB  LEU A 213      19.171  43.027   0.308  1.00 24.76           C  
ATOM   1666  CG  LEU A 213      17.747  42.508   0.156  1.00 25.73           C  
ATOM   1667  CD1 LEU A 213      16.955  43.312  -0.866  1.00 27.97           C  
ATOM   1668  CD2 LEU A 213      17.792  41.043  -0.257  1.00 28.36           C  
ATOM   1669  N   ARG A 214      17.811  45.588   2.276  1.00 26.68           N  
ATOM   1670  CA  ARG A 214      17.081  45.792   3.518  1.00 27.57           C  
ATOM   1671  C   ARG A 214      15.730  45.091   3.557  1.00 28.15           C  
ATOM   1672  O   ARG A 214      14.874  45.264   2.684  1.00 27.20           O  
ATOM   1673  CB  ARG A 214      16.827  47.281   3.804  1.00 29.13           C  
ATOM   1674  CG  ARG A 214      16.353  47.499   5.244  1.00 30.61           C  
ATOM   1675  CD  ARG A 214      15.857  48.945   5.446  1.00 31.01           C  
ATOM   1676  NE  ARG A 214      14.610  49.085   4.690  1.00 33.33           N  
ATOM   1677  CZ  ARG A 214      14.525  49.848   3.605  1.00 33.79           C  
ATOM   1678  NH1 ARG A 214      15.607  50.506   3.225  1.00 30.78           N  
ATOM   1679  NH2 ARG A 214      13.371  49.931   2.955  1.00 35.82           N  
ATOM   1680  N   TYR A 215      15.539  44.293   4.604  1.00 26.95           N  
ATOM   1681  CA  TYR A 215      14.241  43.705   4.879  1.00 27.22           C  
ATOM   1682  C   TYR A 215      13.597  44.475   6.033  1.00 28.38           C  
ATOM   1683  O   TYR A 215      14.246  44.725   7.050  1.00 25.34           O  
ATOM   1684  CB  TYR A 215      14.315  42.215   5.214  1.00 26.64           C  
ATOM   1685  CG  TYR A 215      14.209  41.358   3.971  1.00 28.02           C  
ATOM   1686  CD1 TYR A 215      15.314  41.144   3.165  1.00 28.47           C  
ATOM   1687  CD2 TYR A 215      12.998  40.781   3.598  1.00 28.49           C  
ATOM   1688  CE1 TYR A 215      15.231  40.368   2.022  1.00 31.02           C  
ATOM   1689  CE2 TYR A 215      12.906  40.003   2.463  1.00 28.77           C  
ATOM   1690  CZ  TYR A 215      14.019  39.797   1.674  1.00 31.80           C  
ATOM   1691  OH  TYR A 215      13.915  39.017   0.542  1.00 35.35           O  
ATOM   1692  N   ASP A 216      12.333  44.834   5.802  1.00 27.30           N  
ATOM   1693  CA  ASP A 216      11.499  45.444   6.823  1.00 28.02           C  
ATOM   1694  C   ASP A 216      10.535  44.384   7.334  1.00 27.68           C  
ATOM   1695  O   ASP A 216       9.593  44.030   6.625  1.00 26.91           O  
ATOM   1696  CB  ASP A 216      10.724  46.635   6.258  1.00 32.11           C  
ATOM   1697  CG  ASP A 216      11.626  47.617   5.527  1.00 33.27           C  
ATOM   1698  OD1 ASP A 216      12.617  48.053   6.158  1.00 35.30           O  
ATOM   1699  OD2 ASP A 216      11.349  47.943   4.354  1.00 30.39           O  
ATOM   1700  N   LEU A 217      10.749  43.850   8.534  1.00 27.11           N  
ATOM   1701  CA  LEU A 217       9.929  42.719   8.957  1.00 28.06           C  
ATOM   1702  C   LEU A 217       8.865  43.122   9.966  1.00 29.89           C  
ATOM   1703  O   LEU A 217       9.036  44.130  10.645  1.00 28.20           O  
ATOM   1704  CB  LEU A 217      10.792  41.612   9.557  1.00 27.98           C  
ATOM   1705  CG  LEU A 217      12.034  41.264   8.722  1.00 30.76           C  
ATOM   1706  CD1 LEU A 217      13.033  40.468   9.554  1.00 36.21           C  
ATOM   1707  CD2 LEU A 217      11.645  40.508   7.460  1.00 28.88           C  
ATOM   1708  N   ASP A 218       7.782  42.335   9.995  1.00 29.98           N  
ATOM   1709  CA  ASP A 218       6.767  42.553  11.041  1.00 30.75           C  
ATOM   1710  C   ASP A 218       7.132  41.724  12.270  1.00 30.40           C  
ATOM   1711  O   ASP A 218       8.191  41.084  12.335  1.00 26.84           O  
ATOM   1712  CB  ASP A 218       5.349  42.261  10.547  1.00 32.03           C  
ATOM   1713  CG  ASP A 218       5.052  40.818  10.234  1.00 33.49           C  
ATOM   1714  OD1 ASP A 218       5.874  39.928  10.548  1.00 31.17           O  
ATOM   1715  OD2 ASP A 218       3.963  40.577   9.648  1.00 33.98           O  
ATOM   1716  N   SER A 219       6.252  41.737  13.257  1.00 30.67           N  
ATOM   1717  CA  SER A 219       6.499  41.107  14.541  1.00 32.74           C  
ATOM   1718  C   SER A 219       6.656  39.603  14.376  1.00 31.86           C  
ATOM   1719  O   SER A 219       7.273  38.903  15.189  1.00 30.94           O  
ATOM   1720  CB  SER A 219       5.367  41.466  15.511  1.00 36.56           C  
ATOM   1721  OG  SER A 219       4.163  40.792  15.177  1.00 40.72           O  
ATOM   1722  N   ALA A 220       6.089  39.089  13.282  1.00 31.12           N  
ATOM   1723  CA  ALA A 220       6.203  37.651  13.058  1.00 30.70           C  
ATOM   1724  C   ALA A 220       7.362  37.393  12.100  1.00 30.18           C  
ATOM   1725  O   ALA A 220       7.567  36.294  11.582  1.00 32.13           O  
ATOM   1726  CB  ALA A 220       4.865  37.115  12.583  1.00 28.70           C  
ATOM   1727  N   MET A 221       8.161  38.419  11.853  1.00 29.12           N  
ATOM   1728  CA  MET A 221       9.344  38.283  11.007  1.00 31.13           C  
ATOM   1729  C   MET A 221       8.994  38.036   9.541  1.00 33.20           C  
ATOM   1730  O   MET A 221       9.880  37.629   8.781  1.00 32.91           O  
ATOM   1731  CB  MET A 221      10.253  37.160  11.520  1.00 30.61           C  
ATOM   1732  CG  MET A 221      10.771  37.359  12.934  1.00 28.44           C  
ATOM   1733  SD  MET A 221      11.783  38.836  13.142  1.00 29.82           S  
ATOM   1734  CE  MET A 221      11.167  39.503  14.671  1.00 32.73           C  
ATOM   1735  N   ARG A 222       7.754  38.300   9.148  1.00 33.35           N  
ATOM   1736  CA  ARG A 222       7.303  38.347   7.765  1.00 32.62           C  
ATOM   1737  C   ARG A 222       7.672  39.665   7.087  1.00 28.50           C  
ATOM   1738  O   ARG A 222       7.406  40.735   7.666  1.00 25.66           O  
ATOM   1739  CB  ARG A 222       5.782  38.186   7.695  1.00 36.03           C  
ATOM   1740  CG  ARG A 222       5.213  36.924   8.305  1.00 40.75           C  
ATOM   1741  CD  ARG A 222       3.692  36.929   8.231  1.00 45.30           C  
ATOM   1742  NE  ARG A 222       3.054  37.670   9.317  1.00 48.14           N  
ATOM   1743  CZ  ARG A 222       2.436  37.109  10.352  1.00 51.53           C  
ATOM   1744  NH1 ARG A 222       2.363  35.787  10.466  1.00 49.50           N  
ATOM   1745  NH2 ARG A 222       1.877  37.861  11.301  1.00 56.17           N  
ATOM   1746  N   PRO A 223       8.290  39.646   5.910  1.00 27.69           N  
ATOM   1747  CA  PRO A 223       8.610  40.898   5.214  1.00 27.20           C  
ATOM   1748  C   PRO A 223       7.371  41.736   4.912  1.00 27.52           C  
ATOM   1749  O   PRO A 223       6.352  41.184   4.494  1.00 30.22           O  
ATOM   1750  CB  PRO A 223       9.265  40.449   3.887  1.00 28.23           C  
ATOM   1751  CG  PRO A 223       9.850  39.110   4.237  1.00 27.95           C  
ATOM   1752  CD  PRO A 223       8.811  38.493   5.157  1.00 28.73           C  
ATOM   1753  N   LEU A 224       7.493  43.038   5.097  1.00 27.99           N  
ATOM   1754  CA  LEU A 224       6.478  44.005   4.693  1.00 31.22           C  
ATOM   1755  C   LEU A 224       6.628  44.392   3.222  1.00 32.63           C  
ATOM   1756  O   LEU A 224       5.693  44.865   2.571  1.00 33.36           O  
ATOM   1757  CB  LEU A 224       6.543  45.276   5.542  1.00 34.00           C  
ATOM   1758  CG  LEU A 224       5.914  45.193   6.934  1.00 37.78           C  
ATOM   1759  CD1 LEU A 224       4.441  44.815   6.891  1.00 37.54           C  
ATOM   1760  CD2 LEU A 224       6.698  44.189   7.747  1.00 43.08           C  
ATOM   1761  N   VAL A 225       7.831  44.204   2.691  1.00 31.16           N  
ATOM   1762  CA  VAL A 225       8.116  44.368   1.276  1.00 29.30           C  
ATOM   1763  C   VAL A 225       8.687  43.031   0.784  1.00 32.25           C  
ATOM   1764  O   VAL A 225       9.870  42.768   1.064  1.00 30.87           O  
ATOM   1765  CB  VAL A 225       9.131  45.455   0.915  1.00 30.16           C  
ATOM   1766  CG1 VAL A 225       9.343  45.543  -0.602  1.00 29.01           C  
ATOM   1767  CG2 VAL A 225       8.752  46.838   1.438  1.00 31.07           C  
ATOM   1768  N   ARG A 226       7.859  42.251   0.091  1.00 32.38           N  
ATOM   1769  CA  ARG A 226       8.341  41.005  -0.493  1.00 33.66           C  
ATOM   1770  C   ARG A 226       9.581  41.280  -1.348  1.00 30.35           C  
ATOM   1771  O   ARG A 226       9.579  42.170  -2.200  1.00 28.62           O  
ATOM   1772  CB  ARG A 226       7.277  40.295  -1.339  1.00 38.02           C  
ATOM   1773  CG  ARG A 226       7.567  38.812  -1.502  1.00 42.39           C  
ATOM   1774  CD  ARG A 226       6.387  38.001  -2.008  1.00 47.64           C  
ATOM   1775  NE  ARG A 226       6.478  36.577  -1.661  1.00 51.06           N  
ATOM   1776  CZ  ARG A 226       6.932  35.618  -2.458  1.00 52.13           C  
ATOM   1777  NH1 ARG A 226       7.350  35.920  -3.683  1.00 58.18           N  
ATOM   1778  NH2 ARG A 226       6.992  34.343  -2.090  1.00 47.26           N  
ATOM   1779  N   GLY A 227      10.616  40.496  -1.085  1.00 28.95           N  
ATOM   1780  CA  GLY A 227      11.893  40.573  -1.733  1.00 27.82           C  
ATOM   1781  C   GLY A 227      12.809  41.665  -1.229  1.00 29.05           C  
ATOM   1782  O   GLY A 227      13.907  41.821  -1.782  1.00 29.13           O  
ATOM   1783  N   GLY A 228      12.391  42.414  -0.214  1.00 27.87           N  
ATOM   1784  CA  GLY A 228      13.259  43.410   0.400  1.00 26.94           C  
ATOM   1785  C   GLY A 228      13.520  44.576  -0.523  1.00 29.33           C  
ATOM   1786  O   GLY A 228      12.977  44.640  -1.625  1.00 34.09           O  
ATOM   1787  N   THR A 229      14.340  45.510  -0.067  1.00 29.51           N  
ATOM   1788  CA  THR A 229      14.658  46.707  -0.823  1.00 30.59           C  
ATOM   1789  C   THR A 229      16.165  46.922  -0.913  1.00 30.03           C  
ATOM   1790  O   THR A 229      16.811  47.111   0.112  1.00 28.94           O  
ATOM   1791  CB  THR A 229      13.995  47.933  -0.173  1.00 32.49           C  
ATOM   1792  OG1 THR A 229      12.590  47.653  -0.021  1.00 31.85           O  
ATOM   1793  CG2 THR A 229      14.125  49.141  -1.088  1.00 38.69           C  
ATOM   1794  N   TYR A 230      16.706  46.907  -2.123  1.00 29.03           N  
ATOM   1795  CA  TYR A 230      18.131  47.193  -2.328  1.00 27.09           C  
ATOM   1796  C   TYR A 230      18.433  48.663  -2.138  1.00 29.93           C  
ATOM   1797  O   TYR A 230      17.693  49.588  -2.481  1.00 30.52           O  
ATOM   1798  CB  TYR A 230      18.579  46.715  -3.707  1.00 28.18           C  
ATOM   1799  CG  TYR A 230      18.733  45.218  -3.842  1.00 30.75           C  
ATOM   1800  CD1 TYR A 230      19.840  44.548  -3.324  1.00 31.46           C  
ATOM   1801  CD2 TYR A 230      17.766  44.450  -4.485  1.00 31.12           C  
ATOM   1802  CE1 TYR A 230      20.000  43.177  -3.435  1.00 30.60           C  
ATOM   1803  CE2 TYR A 230      17.923  43.080  -4.599  1.00 30.97           C  
ATOM   1804  CZ  TYR A 230      19.029  42.448  -4.079  1.00 30.44           C  
ATOM   1805  OH  TYR A 230      19.158  41.087  -4.200  1.00 34.43           O  
ATOM   1806  N   LEU A 231      19.599  48.944  -1.540  1.00 33.43           N  
ATOM   1807  CA  LEU A 231      19.931  50.349  -1.321  1.00 34.57           C  
ATOM   1808  C   LEU A 231      20.287  51.048  -2.633  1.00 33.73           C  
ATOM   1809  O   LEU A 231      20.168  52.270  -2.697  1.00 33.67           O  
ATOM   1810  CB  LEU A 231      21.068  50.483  -0.305  1.00 34.59           C  
ATOM   1811  CG  LEU A 231      20.781  49.990   1.118  1.00 35.00           C  
ATOM   1812  CD1 LEU A 231      21.868  50.495   2.062  1.00 36.61           C  
ATOM   1813  CD2 LEU A 231      19.400  50.403   1.608  1.00 33.76           C  
ATOM   1814  N   ASP A 232      20.686  50.289  -3.628  1.00 36.70           N  
ATOM   1815  CA  ASP A 232      20.977  50.736  -4.989  1.00 38.81           C  
ATOM   1816  C   ASP A 232      20.294  49.800  -5.991  1.00 38.96           C  
ATOM   1817  O   ASP A 232      20.897  48.908  -6.582  1.00 40.13           O  
ATOM   1818  CB  ASP A 232      22.474  50.821  -5.274  1.00 39.90           C  
ATOM   1819  CG  ASP A 232      22.785  51.619  -6.531  1.00 43.36           C  
ATOM   1820  OD1 ASP A 232      21.919  51.680  -7.434  1.00 46.37           O  
ATOM   1821  OD2 ASP A 232      23.887  52.200  -6.657  1.00 47.09           O  
ATOM   1822  N   PRO A 233      18.997  50.040  -6.143  1.00 40.88           N  
ATOM   1823  CA  PRO A 233      18.136  49.178  -6.947  1.00 42.57           C  
ATOM   1824  C   PRO A 233      18.611  49.049  -8.398  1.00 43.84           C  
ATOM   1825  O   PRO A 233      18.398  47.979  -8.980  1.00 43.42           O  
ATOM   1826  CB  PRO A 233      16.772  49.867  -6.920  1.00 42.96           C  
ATOM   1827  CG  PRO A 233      16.834  50.858  -5.813  1.00 43.14           C  
ATOM   1828  CD  PRO A 233      18.277  51.172  -5.537  1.00 42.01           C  
ATOM   1829  N   GLU A 234      19.231  50.095  -8.935  1.00 43.76           N  
ATOM   1830  CA  GLU A 234      19.746  50.076 -10.303  1.00 43.11           C  
ATOM   1831  C   GLU A 234      20.920  49.114 -10.372  1.00 43.51           C  
ATOM   1832  O   GLU A 234      20.959  48.169 -11.152  1.00 48.29           O  
ATOM   1833  CB  GLU A 234      20.197  51.446 -10.787  1.00 42.16           C  
ATOM   1834  N   ALA A 235      21.876  49.392  -9.494  1.00 43.06           N  
ATOM   1835  CA  ALA A 235      23.053  48.542  -9.386  1.00 42.41           C  
ATOM   1836  C   ALA A 235      22.614  47.103  -9.160  1.00 43.81           C  
ATOM   1837  O   ALA A 235      23.183  46.140  -9.675  1.00 42.24           O  
ATOM   1838  CB  ALA A 235      23.926  49.043  -8.250  1.00 44.88           C  
ATOM   1839  N   ALA A 236      21.556  46.993  -8.354  1.00 45.03           N  
ATOM   1840  CA  ALA A 236      21.057  45.667  -7.987  1.00 47.26           C  
ATOM   1841  C   ALA A 236      20.642  44.884  -9.226  1.00 48.93           C  
ATOM   1842  O   ALA A 236      21.052  43.743  -9.447  1.00 45.88           O  
ATOM   1843  CB  ALA A 236      19.915  45.814  -6.998  1.00 46.56           C  
ATOM   1844  N   ALA A 237      19.812  45.531 -10.042  1.00 50.29           N  
ATOM   1845  CA  ALA A 237      19.371  44.933 -11.293  1.00 52.17           C  
ATOM   1846  C   ALA A 237      20.562  44.582 -12.178  1.00 53.63           C  
ATOM   1847  O   ALA A 237      20.558  43.579 -12.893  1.00 59.84           O  
ATOM   1848  CB  ALA A 237      18.426  45.880 -12.028  1.00 54.61           C  
ATOM   1849  N   ALA A 238      21.603  45.415 -12.140  1.00 52.90           N  
ATOM   1850  CA  ALA A 238      22.737  45.143 -13.022  1.00 53.77           C  
ATOM   1851  C   ALA A 238      23.681  44.117 -12.402  1.00 54.69           C  
ATOM   1852  O   ALA A 238      24.312  43.349 -13.132  1.00 54.19           O  
ATOM   1853  CB  ALA A 238      23.465  46.434 -13.356  1.00 51.14           C  
ATOM   1854  N   GLY A 239      23.780  44.099 -11.072  1.00 54.23           N  
ATOM   1855  CA  GLY A 239      24.613  43.105 -10.405  1.00 53.98           C  
ATOM   1856  C   GLY A 239      23.968  41.733 -10.507  1.00 55.15           C  
ATOM   1857  O   GLY A 239      24.627  40.704 -10.622  1.00 51.11           O  
ATOM   1858  N   ALA A 240      22.638  41.736 -10.461  1.00 58.03           N  
ATOM   1859  CA  ALA A 240      21.873  40.502 -10.607  1.00 60.77           C  
ATOM   1860  C   ALA A 240      22.168  39.894 -11.970  1.00 63.47           C  
ATOM   1861  O   ALA A 240      22.157  38.691 -12.207  1.00 61.28           O  
ATOM   1862  CB  ALA A 240      20.393  40.778 -10.418  1.00 61.20           C  
ATOM   1863  N   ALA A 241      22.467  40.781 -12.922  1.00 67.28           N  
ATOM   1864  CA  ALA A 241      22.843  40.284 -14.243  1.00 70.59           C  
ATOM   1865  C   ALA A 241      24.305  39.841 -14.238  1.00 73.07           C  
ATOM   1866  O   ALA A 241      24.613  38.687 -14.532  1.00 73.22           O  
ATOM   1867  CB  ALA A 241      22.575  41.349 -15.291  1.00 70.57           C  
ATOM   1868  N   ALA A 242      25.178  40.768 -13.891  1.00 75.43           N  
ATOM   1869  CA  ALA A 242      26.621  40.654 -13.921  1.00 78.44           C  
ATOM   1870  C   ALA A 242      27.148  39.287 -13.485  1.00 81.28           C  
ATOM   1871  O   ALA A 242      28.173  38.862 -14.032  1.00 83.43           O  
ATOM   1872  CB  ALA A 242      27.233  41.737 -13.035  1.00 78.49           C  
ATOM   1873  N   VAL A 243      26.479  38.657 -12.546  1.00 83.35           N  
ATOM   1874  CA  VAL A 243      26.787  37.427 -11.845  1.00 85.10           C  
ATOM   1875  C   VAL A 243      27.818  36.531 -12.526  1.00 87.54           C  
ATOM   1876  O   VAL A 243      28.042  36.587 -13.735  1.00 88.79           O  
ATOM   1877  CB  VAL A 243      25.499  36.600 -11.618  1.00 84.62           C  
ATOM   1878  CG1 VAL A 243      24.657  37.284 -10.549  1.00 85.61           C  
ATOM   1879  CG2 VAL A 243      24.721  36.419 -12.909  1.00 83.07           C  
ATOM   1880  N   ALA A 244      28.455  35.692 -11.713  1.00 89.22           N  
ATOM   1881  CA  ALA A 244      29.506  34.773 -12.127  1.00 90.45           C  
ATOM   1882  C   ALA A 244      30.836  35.495 -12.336  1.00 90.85           C  
ATOM   1883  O   ALA A 244      31.544  35.831 -11.386  1.00 91.94           O  
ATOM   1884  CB  ALA A 244      29.114  34.024 -13.395  1.00 91.56           C  
TER    1885      ALA A 244                                                      
END
MOLECULE T0394.pdb
ATOM      1  N   ASN     1       7.131  28.263  26.435  1.00 37.08           N  
ATOM      2  CA  ASN     1       7.437  29.315  25.416  1.00 36.05           C  
ATOM      3  C   ASN     1       7.192  30.735  25.903  1.00 34.53           C  
ATOM      4  O   ASN     1       6.216  30.997  26.611  1.00 34.93           O  
ATOM      5  CB  ASN     1       6.662  29.047  24.125  1.00 37.00           C  
ATOM      6  CG  ASN     1       7.395  28.086  23.213  1.00 39.47           C  
ATOM      7  OD1 ASN     1       7.200  26.869  23.286  1.00 43.62           O  
ATOM      8  ND2 ASN     1       8.288  28.624  22.384  1.00 40.23           N  
ATOM      9  N   LEU     2       8.082  31.640  25.492  1.00 32.19           N  
ATOM     10  CA  LEU     2       8.122  33.016  25.993  1.00 29.95           C  
ATOM     11  C   LEU     2       7.110  33.917  25.298  1.00 28.07           C  
ATOM     12  O   LEU     2       6.983  33.894  24.068  1.00 28.29           O  
ATOM     13  CB  LEU     2       9.527  33.600  25.804  1.00 29.69           C  
ATOM     14  CG  LEU     2      10.670  32.930  26.564  1.00 29.92           C  
ATOM     15  CD1 LEU     2      12.000  33.222  25.886  1.00 29.23           C  
ATOM     16  CD2 LEU     2      10.663  33.446  27.989  1.00 28.60           C  
ATOM     17  N   TYR     3       6.407  34.722  26.095  1.00 25.72           N  
ATOM     18  CA  TYR     3       5.529  35.769  25.587  1.00 24.38           C  
ATOM     19  C   TYR     3       6.320  37.041  25.320  1.00 23.44           C  
ATOM     20  O   TYR     3       7.033  37.574  26.203  1.00 21.70           O  
ATOM     21  CB  TYR     3       4.386  36.067  26.569  1.00 24.95           C  
ATOM     22  CG  TYR     3       3.542  37.283  26.201  1.00 24.49           C  
ATOM     23  CD1 TYR     3       2.296  37.140  25.578  1.00 25.41           C  
ATOM     24  CD2 TYR     3       3.986  38.574  26.489  1.00 24.54           C  
ATOM     25  CE1 TYR     3       1.528  38.265  25.239  1.00 26.31           C  
ATOM     26  CE2 TYR     3       3.232  39.700  26.154  1.00 24.99           C  
ATOM     27  CZ  TYR     3       2.015  39.541  25.528  1.00 26.12           C  
ATOM     28  OH  TYR     3       1.282  40.675  25.217  1.00 29.19           O  
ATOM     29  N   PHE     4       6.198  37.532  24.092  1.00 21.28           N  
ATOM     30  CA  PHE     4       6.804  38.796  23.732  1.00 21.92           C  
ATOM     31  C   PHE     4       5.758  39.769  23.248  1.00 22.33           C  
ATOM     32  O   PHE     4       4.744  39.358  22.707  1.00 21.26           O  
ATOM     33  CB  PHE     4       7.841  38.598  22.620  1.00 21.80           C  
ATOM     34  CG  PHE     4       9.019  37.763  23.036  1.00 20.69           C  
ATOM     35  CD1 PHE     4       9.930  38.245  23.973  1.00 18.93           C  
ATOM     36  CD2 PHE     4       9.209  36.497  22.501  1.00 21.68           C  
ATOM     37  CE1 PHE     4      11.035  37.458  24.352  1.00 20.05           C  
ATOM     38  CE2 PHE     4      10.302  35.717  22.866  1.00 22.45           C  
ATOM     39  CZ  PHE     4      11.222  36.218  23.803  1.00 21.82           C  
ATOM     40  N   GLN     5       6.032  41.054  23.450  1.00 22.99           N  
ATOM     41  CA  GLN     5       5.226  42.107  22.871  1.00 24.75           C  
ATOM     42  C   GLN     5       5.521  42.151  21.367  1.00 23.85           C  
ATOM     43  O   GLN     5       6.451  41.461  20.899  1.00 23.54           O  
ATOM     44  CB  GLN     5       5.532  43.444  23.553  1.00 26.07           C  
ATOM     45  CG  GLN     5       5.034  43.473  25.022  1.00 31.04           C  
ATOM     46  CD  GLN     5       4.811  44.878  25.566  1.00 37.81           C  
ATOM     47  OE1 GLN     5       5.661  45.777  25.403  1.00 41.06           O  
ATOM     48  NE2 GLN     5       3.660  45.079  26.215  1.00 38.49           N  
ATOM     49  N   SER     6       4.726  42.924  20.628  1.00 23.52           N  
ATOM     50  CA  SER     6       4.940  43.126  19.191  0.50 23.55           C  
ATOM     52  C   SER     6       6.337  43.702  18.962  1.00 22.75           C  
ATOM     53  O   SER     6       6.858  44.463  19.805  1.00 22.96           O  
ATOM     54  CB  SER     6       3.856  44.057  18.638  0.50 23.94           C  
ATOM     56  OG  SER     6       3.940  44.174  17.233  0.50 25.41           O  
ATOM     58  N   ALA     7       6.977  43.335  17.852  1.00 21.09           N  
ATOM     59  CA  ALA     7       8.341  43.796  17.589  1.00 19.34           C  
ATOM     60  C   ALA     7       8.616  43.806  16.096  1.00 18.62           C  
ATOM     61  O   ALA     7       7.962  43.078  15.352  1.00 17.81           O  
ATOM     62  CB  ALA     7       9.361  42.902  18.314  1.00 18.58           C  
ATOM     63  N   ARG     8       9.540  44.662  15.692  1.00 17.77           N  
ATOM     64  CA  ARG     8       9.981  44.808  14.311  1.00 18.09           C  
ATOM     65  C   ARG     8      11.475  45.003  14.342  1.00 17.38           C  
ATOM     66  O   ARG     8      11.988  45.711  15.227  1.00 16.45           O  
ATOM     67  CB  ARG     8       9.398  46.071  13.683  1.00 19.36           C  
ATOM     68  CG  ARG     8       7.946  46.007  13.335  1.00 23.70           C  
ATOM     69  CD  ARG     8       7.465  47.406  12.982  1.00 28.18           C  
ATOM     70  NE  ARG     8       7.941  47.887  11.680  1.00 30.83           N  
ATOM     71  CZ  ARG     8       8.710  48.960  11.501  1.00 30.42           C  
ATOM     72  NH1 ARG     8       9.117  49.682  12.536  1.00 32.52           N  
ATOM     73  NH2 ARG     8       9.060  49.316  10.274  1.00 29.09           N  
ATOM     74  N   PHE     9      12.184  44.376  13.397  1.00 15.44           N  
ATOM     75  CA  PHE     9      13.609  44.661  13.228  1.00 14.36           C  
ATOM     76  C   PHE     9      14.024  44.617  11.750  1.00 14.07           C  
ATOM     77  O   PHE     9      13.327  44.021  10.922  1.00 14.11           O  
ATOM     78  CB  PHE     9      14.503  43.808  14.139  1.00 14.06           C  
ATOM     79  CG  PHE     9      14.646  42.339  13.723  1.00 14.99           C  
ATOM     80  CD1 PHE     9      15.716  41.917  12.893  1.00 14.73           C  
ATOM     81  CD2 PHE     9      13.778  41.373  14.237  1.00 14.99           C  
ATOM     82  CE1 PHE     9      15.873  40.529  12.575  1.00 15.03           C  
ATOM     83  CE2 PHE     9      13.931  40.017  13.902  1.00 13.86           C  
ATOM     84  CZ  PHE     9      14.979  39.616  13.065  1.00 15.53           C  
ATOM     85  N   ALA    10      15.107  45.315  11.432  1.00 13.59           N  
ATOM     86  CA  ALA    10      15.614  45.381  10.074  1.00 13.29           C  
ATOM     87  C   ALA    10      16.736  44.351   9.943  1.00 12.11           C  
ATOM     88  O   ALA    10      17.515  44.114  10.867  1.00 12.79           O  
ATOM     89  CB  ALA    10      16.127  46.747   9.770  1.00 13.92           C  
ATOM     90  N   LEU    11      16.820  43.776   8.765  1.00 11.89           N  
ATOM     91  CA  LEU    11      17.884  42.825   8.461  1.00 11.66           C  
ATOM     92  C   LEU    11      18.479  43.206   7.106  1.00 11.25           C  
ATOM     93  O   LEU    11      17.791  43.100   6.088  1.00 11.70           O  
ATOM     94  CB  LEU    11      17.268  41.424   8.382  1.00 11.80           C  
ATOM     95  CG  LEU    11      18.199  40.311   7.867  1.00 11.81           C  
ATOM     96  CD1 LEU    11      19.499  40.184   8.709  1.00 11.54           C  
ATOM     97  CD2 LEU    11      17.431  38.946   7.835  1.00 11.16           C  
ATOM     98  N   THR    12      19.739  43.651   7.093  1.00 11.06           N  
ATOM     99  CA  THR    12      20.437  43.941   5.843  1.00 10.80           C  
ATOM    100  C   THR    12      21.431  42.812   5.554  1.00 10.75           C  
ATOM    101  O   THR    12      22.268  42.492   6.427  1.00 10.78           O  
ATOM    102  CB  THR    12      21.207  45.258   5.979  1.00 12.04           C  
ATOM    103  OG1 THR    12      20.261  46.309   6.268  1.00 13.87           O  
ATOM    104  CG2 THR    12      21.944  45.545   4.716  1.00 11.84           C  
ATOM    105  N   VAL    13      21.329  42.215   4.366  1.00 10.59           N  
ATOM    106  CA  VAL    13      22.159  41.059   3.976  1.00 10.00           C  
ATOM    107  C   VAL    13      23.009  41.448   2.754  1.00 10.55           C  
ATOM    108  O   VAL    13      22.471  41.918   1.733  1.00 10.36           O  
ATOM    109  CB  VAL    13      21.256  39.828   3.638  1.00 10.02           C  
ATOM    110  CG1 VAL    13      22.153  38.561   3.516  1.00  9.93           C  
ATOM    111  CG2 VAL    13      20.243  39.644   4.736  1.00 12.14           C  
ATOM    112  N   VAL    14      24.327  41.288   2.872  1.00 10.61           N  
ATOM    113  CA  VAL    14      25.251  41.780   1.877  1.00 10.14           C  
ATOM    114  C   VAL    14      26.202  40.645   1.457  1.00 10.94           C  
ATOM    115  O   VAL    14      26.790  40.007   2.325  1.00 10.94           O  
ATOM    116  CB  VAL    14      26.075  42.959   2.446  1.00 11.36           C  
ATOM    117  CG1 VAL    14      27.056  43.456   1.382  1.00  9.89           C  
ATOM    118  CG2 VAL    14      25.134  44.137   2.849  1.00 12.81           C  
ATOM    119  N   ARG    15      26.318  40.368   0.158  1.00 10.04           N  
ATOM    120  CA  ARG    15      27.289  39.336  -0.282  1.00 10.79           C  
ATOM    121  C   ARG    15      28.699  39.909  -0.117  1.00 10.29           C  
ATOM    122  O   ARG    15      28.904  41.106  -0.283  1.00 11.57           O  
ATOM    123  CB  ARG    15      27.048  38.936  -1.768  1.00  9.43           C  
ATOM    124  CG  ARG    15      28.024  37.834  -2.263  1.00 11.35           C  
ATOM    125  CD  ARG    15      27.585  37.222  -3.602  1.00 12.46           C  
ATOM    126  NE  ARG    15      28.624  36.330  -4.093  1.00 13.39           N  
ATOM    127  CZ  ARG    15      29.143  36.335  -5.318  1.00 15.37           C  
ATOM    128  NH1 ARG    15      28.674  37.137  -6.260  1.00 14.12           N  
ATOM    129  NH2 ARG    15      30.131  35.500  -5.608  1.00 13.89           N  
ATOM    130  N   HIS    16      29.679  39.062   0.166  1.00 11.14           N  
ATOM    131  CA  HIS    16      31.080  39.515   0.244  1.00 11.40           C  
ATOM    132  C   HIS    16      31.557  40.087  -1.118  1.00 12.40           C  
ATOM    133  O   HIS    16      30.975  39.795  -2.202  1.00 12.27           O  
ATOM    134  CB  HIS    16      31.969  38.326   0.622  1.00 11.89           C  
ATOM    135  CG  HIS    16      31.909  37.244  -0.383  1.00 11.77           C  
ATOM    136  ND1 HIS    16      32.675  37.259  -1.532  1.00 10.88           N  
ATOM    137  CD2 HIS    16      31.113  36.155  -0.466  1.00 14.23           C  
ATOM    138  CE1 HIS    16      32.387  36.191  -2.256  1.00 16.26           C  
ATOM    139  NE2 HIS    16      31.442  35.506  -1.630  1.00 14.39           N  
ATOM    140  N   GLY    17      32.636  40.876  -1.055  1.00 12.57           N  
ATOM    141  CA  GLY    17      33.265  41.387  -2.260  1.00 12.64           C  
ATOM    142  C   GLY    17      33.923  40.326  -3.120  1.00 13.60           C  
ATOM    143  O   GLY    17      34.100  39.176  -2.698  1.00 12.67           O  
ATOM    144  N   GLU    18      34.245  40.696  -4.356  1.00 12.79           N  
ATOM    145  CA  GLU    18      34.855  39.768  -5.308  1.00 14.33           C  
ATOM    146  C   GLU    18      36.181  39.161  -4.816  1.00 14.19           C  
ATOM    147  O   GLU    18      36.985  39.853  -4.170  1.00 13.24           O  
ATOM    148  CB  GLU    18      35.072  40.498  -6.641  1.00 15.58           C  
ATOM    149  CG  GLU    18      35.615  39.646  -7.737  1.00 18.58           C  
ATOM    150  CD  GLU    18      36.423  40.473  -8.747  1.00 26.24           C  
ATOM    151  OE1 GLU    18      37.548  40.925  -8.432  1.00 28.76           O  
ATOM    152  OE2 GLU    18      35.935  40.634  -9.857  1.00 27.17           O  
ATOM    153  N   THR    19      36.361  37.856  -5.065  1.00 14.63           N  
ATOM    154  CA  THR    19      37.661  37.193  -4.893  1.00 15.69           C  
ATOM    155  C   THR    19      38.223  36.845  -6.260  1.00 16.12           C  
ATOM    156  O   THR    19      37.525  36.893  -7.282  1.00 15.11           O  
ATOM    157  CB  THR    19      37.572  35.837  -4.120  1.00 14.87           C  
ATOM    158  OG1 THR    19      36.910  34.873  -4.955  1.00 16.55           O  
ATOM    159  CG2 THR    19      36.837  35.983  -2.742  1.00 12.93           C  
ATOM    160  N   ARG    20      39.495  36.453  -6.260  1.00 16.97           N  
ATOM    161  CA  ARG    20      40.161  35.912  -7.443  1.00 18.93           C  
ATOM    162  C   ARG    20      39.322  34.822  -8.158  1.00 19.29           C  
ATOM    163  O   ARG    20      39.202  34.812  -9.396  1.00 20.04           O  
ATOM    164  CB  ARG    20      41.546  35.408  -6.992  1.00 19.32           C  
ATOM    165  CG  ARG    20      42.275  34.361  -7.777  1.00 22.18           C  
ATOM    166  CD  ARG    20      43.709  34.338  -7.214  1.00 21.66           C  
ATOM    167  NE  ARG    20      43.840  33.443  -6.063  1.00 20.51           N  
ATOM    168  CZ  ARG    20      44.436  32.262  -6.102  1.00 22.87           C  
ATOM    169  NH1 ARG    20      44.481  31.517  -5.016  1.00 24.91           N  
ATOM    170  NH2 ARG    20      44.975  31.823  -7.228  1.00 23.22           N  
ATOM    171  N   PHE    21      38.714  33.939  -7.373  1.00 17.76           N  
ATOM    172  CA  PHE    21      37.948  32.834  -7.941  1.00 17.97           C  
ATOM    173  C   PHE    21      36.604  33.277  -8.506  1.00 17.74           C  
ATOM    174  O   PHE    21      36.151  32.759  -9.544  1.00 16.99           O  
ATOM    175  CB  PHE    21      37.833  31.701  -6.911  1.00 19.01           C  
ATOM    176  CG  PHE    21      39.181  31.131  -6.530  1.00 20.00           C  
ATOM    177  CD1 PHE    21      40.117  30.838  -7.512  1.00 23.92           C  
ATOM    178  CD2 PHE    21      39.525  30.940  -5.202  1.00 24.47           C  
ATOM    179  CE1 PHE    21      41.375  30.310  -7.171  1.00 24.93           C  
ATOM    180  CE2 PHE    21      40.774  30.412  -4.859  1.00 25.63           C  
ATOM    181  CZ  PHE    21      41.691  30.099  -5.842  1.00 24.75           C  
ATOM    182  N   ASN    22      35.962  34.229  -7.840  1.00 17.57           N  
ATOM    183  CA  ASN    22      34.719  34.794  -8.414  1.00 18.52           C  
ATOM    184  C   ASN    22      34.988  35.351  -9.818  1.00 19.89           C  
ATOM    185  O   ASN    22      34.228  35.105 -10.771  1.00 19.51           O  
ATOM    186  CB  ASN    22      34.190  35.907  -7.554  1.00 18.37           C  
ATOM    187  CG  ASN    22      33.602  35.407  -6.245  1.00 19.37           C  
ATOM    188  OD1 ASN    22      33.150  34.237  -6.104  1.00 18.97           O  
ATOM    189  ND2 ASN    22      33.568  36.286  -5.301  1.00 13.55           N  
ATOM    190  N   LYS    23      36.093  36.074  -9.948  1.00 20.75           N  
ATOM    191  CA  LYS    23      36.443  36.692 -11.235  1.00 23.46           C  
ATOM    192  C   LYS    23      36.623  35.624 -12.306  1.00 24.29           C  
ATOM    193  O   LYS    23      36.138  35.776 -13.428  1.00 25.47           O  
ATOM    194  CB  LYS    23      37.690  37.556 -11.072  1.00 23.52           C  
ATOM    195  CG  LYS    23      38.222  38.212 -12.349  1.00 27.47           C  
ATOM    196  CD  LYS    23      37.326  39.322 -12.822  1.00 32.44           C  
ATOM    197  CE  LYS    23      38.108  40.299 -13.700  1.00 35.21           C  
ATOM    198  NZ  LYS    23      37.221  41.431 -14.082  1.00 39.24           N  
ATOM    199  N   GLU    24      37.280  34.531 -11.936  1.00 25.02           N  
ATOM    200  CA  GLU    24      37.646  33.470 -12.881  1.00 26.99           C  
ATOM    201  C   GLU    24      36.574  32.393 -13.025  1.00 26.34           C  
ATOM    202  O   GLU    24      36.802  31.393 -13.728  1.00 27.71           O  
ATOM    203  CB  GLU    24      38.981  32.836 -12.465  1.00 27.65           C  
ATOM    204  CG  GLU    24      40.141  33.811 -12.232  1.00 30.31           C  
ATOM    205  CD  GLU    24      40.401  34.779 -13.408  1.00 36.92           C  
ATOM    206  OE1 GLU    24      40.063  34.451 -14.569  1.00 38.73           O  
ATOM    207  OE2 GLU    24      40.950  35.884 -13.159  1.00 38.71           O  
ATOM    208  N   LYS    25      35.421  32.604 -12.378  1.00 25.57           N  
ATOM    209  CA  LYS    25      34.277  31.667 -12.408  1.00 24.89           C  
ATOM    210  C   LYS    25      34.691  30.274 -11.910  1.00 22.95           C  
ATOM    211  O   LYS    25      34.323  29.237 -12.514  1.00 24.07           O  
ATOM    212  CB  LYS    25      33.655  31.563 -13.820  1.00 26.00           C  
ATOM    213  CG  LYS    25      33.068  32.889 -14.367  1.00 30.31           C  
ATOM    214  CD  LYS    25      31.531  32.954 -14.285  1.00 37.00           C  
ATOM    215  CE  LYS    25      30.851  32.201 -15.442  1.00 39.72           C  
ATOM    216  NZ  LYS    25      29.358  32.126 -15.292  1.00 41.81           N  
ATOM    217  N   ILE    26      35.474  30.269 -10.834  1.00 20.24           N  
ATOM    218  CA  ILE    26      35.921  29.042 -10.172  0.50 19.68           C  
ATOM    220  C   ILE    26      35.057  28.826  -8.941  1.00 18.78           C  
ATOM    221  O   ILE    26      34.810  29.759  -8.172  1.00 18.27           O  
ATOM    222  CB  ILE    26      37.425  29.134  -9.782  0.50 19.24           C  
ATOM    224  CG1 ILE    26      38.297  29.028 -11.046  0.50 20.15           C  
ATOM    226  CG2 ILE    26      37.834  28.074  -8.758  0.50 19.79           C  
ATOM    228  CD1 ILE    26      39.716  29.509 -10.829  0.50 19.10           C  
ATOM    230  N   ILE    27      34.588  27.598  -8.779  1.00 17.64           N  
ATOM    231  CA  ILE    27      33.708  27.274  -7.670  0.50 17.31           C  
ATOM    233  C   ILE    27      34.422  27.476  -6.353  1.00 17.86           C  
ATOM    234  O   ILE    27      35.542  27.019  -6.154  1.00 16.33           O  
ATOM    235  CB  ILE    27      33.170  25.849  -7.774  0.50 16.83           C  
ATOM    237  CG1 ILE    27      32.426  25.673  -9.102  0.50 18.12           C  
ATOM    239  CG2 ILE    27      32.228  25.543  -6.610  0.50 15.69           C  
ATOM    241  CD1 ILE    27      32.230  24.258  -9.481  0.50 17.55           C  
ATOM    243  N   GLN    28      33.712  28.157  -5.457  1.00 19.94           N  
ATOM    244  CA  GLN    28      34.188  28.558  -4.186  1.00 21.00           C  
ATOM    245  C   GLN    28      33.026  28.413  -3.207  1.00 20.63           C  
ATOM    246  O   GLN    28      32.128  29.284  -3.155  1.00 21.79           O  
ATOM    247  CB  GLN    28      34.493  30.038  -4.326  1.00 22.79           C  
ATOM    248  CG  GLN    28      35.186  30.690  -3.187  1.00 25.95           C  
ATOM    249  CD  GLN    28      35.402  32.143  -3.518  1.00 23.19           C  
ATOM    250  OE1 GLN    28      34.439  32.916  -3.650  1.00 26.05           O  
ATOM    251  NE2 GLN    28      36.658  32.528  -3.684  1.00 18.04           N  
ATOM    252  N   GLY    29      33.023  27.314  -2.470  1.00 18.42           N  
ATOM    253  CA  GLY    29      32.073  27.123  -1.387  1.00 18.14           C  
ATOM    254  C   GLY    29      32.830  27.131  -0.072  1.00 18.33           C  
ATOM    255  O   GLY    29      33.116  28.190   0.473  1.00 18.58           O  
ATOM    256  N   GLN    30      33.180  25.950   0.427  1.00 18.10           N  
ATOM    257  CA  GLN    30      33.966  25.825   1.659  1.00 19.44           C  
ATOM    258  C   GLN    30      35.303  25.107   1.278  1.00 21.53           C  
ATOM    259  O   GLN    30      35.699  24.135   1.898  1.00 22.52           O  
ATOM    260  CB  GLN    30      33.146  25.074   2.757  1.00 18.80           C  
ATOM    261  CG  GLN    30      31.821  25.772   3.166  1.00 17.51           C  
ATOM    262  CD  GLN    30      31.107  25.155   4.393  1.00 18.30           C  
ATOM    263  OE1 GLN    30      31.751  24.637   5.332  1.00 17.71           O  
ATOM    264  NE2 GLN    30      29.785  25.260   4.418  1.00 15.39           N  
ATOM    265  N   GLY    31      35.971  25.592   0.233  1.00 23.08           N  
ATOM    266  CA  GLY    31      37.221  24.988  -0.236  1.00 24.28           C  
ATOM    267  C   GLY    31      38.442  25.756   0.219  1.00 24.89           C  
ATOM    268  O   GLY    31      38.798  25.700   1.396  1.00 24.91           O  
ATOM    269  N   VAL    32      39.121  26.439  -0.706  1.00 24.97           N  
ATOM    270  CA  VAL    32      40.138  27.382  -0.288  1.00 24.40           C  
ATOM    271  C   VAL    32      39.368  28.547   0.340  1.00 22.92           C  
ATOM    272  O   VAL    32      38.374  29.027  -0.170  1.00 23.11           O  
ATOM    273  CB  VAL    32      41.112  27.879  -1.434  1.00 25.58           C  
ATOM    274  CG1 VAL    32      41.796  29.243  -1.078  1.00 25.76           C  
ATOM    275  CG2 VAL    32      42.175  26.840  -1.736  1.00 26.45           C  
ATOM    276  N   ASP    33      39.840  28.949   1.490  1.00 21.48           N  
ATOM    277  CA  ASP    33      39.335  30.116   2.151  1.00 19.20           C  
ATOM    278  C   ASP    33      40.047  31.316   1.497  1.00 17.34           C  
ATOM    279  O   ASP    33      41.003  31.846   2.054  1.00 18.03           O  
ATOM    280  CB  ASP    33      39.747  29.960   3.601  1.00 18.89           C  
ATOM    281  CG  ASP    33      39.039  30.875   4.486  1.00 18.74           C  
ATOM    282  OD1 ASP    33      38.258  31.695   3.971  1.00 16.19           O  
ATOM    283  OD2 ASP    33      39.269  30.786   5.698  1.00 18.51           O  
ATOM    284  N   GLU    34      39.564  31.721   0.315  1.00 16.16           N  
ATOM    285  CA  GLU    34      40.199  32.771  -0.530  1.00 13.68           C  
ATOM    286  C   GLU    34      39.829  34.184  -0.062  1.00 13.01           C  
ATOM    287  O   GLU    34      38.658  34.481   0.182  1.00 12.76           O  
ATOM    288  CB  GLU    34      39.758  32.569  -1.988  1.00 13.32           C  
ATOM    289  CG  GLU    34      40.392  33.542  -2.987  1.00 14.27           C  
ATOM    290  CD  GLU    34      41.895  33.337  -3.121  1.00 17.56           C  
ATOM    291  OE1 GLU    34      42.406  32.292  -2.657  1.00 16.95           O  
ATOM    292  OE2 GLU    34      42.561  34.222  -3.687  1.00 14.35           O  
ATOM    293  N   PRO    35      40.816  35.087   0.038  1.00 12.61           N  
ATOM    294  CA  PRO    35      40.519  36.460   0.441  1.00 12.40           C  
ATOM    295  C   PRO    35      39.941  37.281  -0.696  1.00 12.19           C  
ATOM    296  O   PRO    35      39.870  36.798  -1.836  1.00 12.16           O  
ATOM    297  CB  PRO    35      41.903  37.012   0.800  1.00 13.18           C  
ATOM    298  CG  PRO    35      42.830  36.282  -0.091  1.00 11.73           C  
ATOM    299  CD  PRO    35      42.257  34.876  -0.197  1.00 12.29           C  
ATOM    300  N   LEU    36      39.553  38.525  -0.381  1.00 13.27           N  
ATOM    301  CA  LEU    36      39.129  39.442  -1.419  1.00 13.91           C  
ATOM    302  C   LEU    36      40.288  39.748  -2.367  1.00 14.60           C  
ATOM    303  O   LEU    36      41.477  39.720  -1.959  1.00 15.26           O  
ATOM    304  CB  LEU    36      38.660  40.730  -0.791  1.00 13.30           C  
ATOM    305  CG  LEU    36      37.476  40.669   0.167  1.00 11.16           C  
ATOM    306  CD1 LEU    36      37.120  42.084   0.644  1.00 12.32           C  
ATOM    307  CD2 LEU    36      36.294  40.061  -0.606  1.00 14.18           C  
ATOM    308  N   SER    37      39.942  40.002  -3.627  1.00 14.66           N  
ATOM    309  CA  SER    37      40.887  40.588  -4.581  1.00 15.07           C  
ATOM    310  C   SER    37      40.955  42.115  -4.361  1.00 16.18           C  
ATOM    311  O   SER    37      40.191  42.650  -3.561  1.00 15.86           O  
ATOM    312  CB  SER    37      40.387  40.310  -5.990  1.00 15.28           C  
ATOM    313  OG  SER    37      39.163  40.991  -6.245  1.00 15.00           O  
ATOM    314  N   GLU    38      41.843  42.819  -5.053  0.50 16.90           N  
ATOM    316  CA  GLU    38      41.822  44.275  -4.919  0.50 17.68           C  
ATOM    318  C   GLU    38      40.468  44.909  -5.349  0.50 17.34           C  
ATOM    320  O   GLU    38      39.992  45.839  -4.683  0.50 16.87           O  
ATOM    322  CB  GLU    38      43.062  44.905  -5.555  0.50 18.44           C  
ATOM    324  CG  GLU    38      44.363  44.465  -4.861  0.50 20.32           C  
ATOM    326  CD  GLU    38      44.498  45.003  -3.442  0.50 23.44           C  
ATOM    328  OE1 GLU    38      44.550  46.248  -3.280  0.50 23.55           O  
ATOM    330  OE2 GLU    38      44.564  44.191  -2.493  0.50 20.46           O  
ATOM    332  N   THR    39      39.818  44.357  -6.381  1.00 17.89           N  
ATOM    333  CA  THR    39      38.442  44.762  -6.739  1.00 18.70           C  
ATOM    334  C   THR    39      37.477  44.495  -5.573  1.00 17.31           C  
ATOM    335  O   THR    39      36.641  45.350  -5.250  1.00 16.75           O  
ATOM    336  CB  THR    39      37.965  44.078  -8.026  1.00 19.07           C  
ATOM    337  OG1 THR    39      38.780  44.507  -9.123  1.00 23.74           O  
ATOM    338  CG2 THR    39      36.491  44.402  -8.353  1.00 21.10           C  
ATOM    339  N   GLY    40      37.635  43.343  -4.911  1.00 16.64           N  
ATOM    340  CA  GLY    40      36.796  43.013  -3.755  1.00 15.47           C  
ATOM    341  C   GLY    40      36.961  43.990  -2.593  1.00 15.29           C  
ATOM    342  O   GLY    40      35.992  44.422  -1.961  1.00 14.78           O  
ATOM    343  N   PHE    41      38.204  44.362  -2.311  1.00 14.84           N  
ATOM    344  CA  PHE    41      38.482  45.341  -1.283  1.00 16.00           C  
ATOM    345  C   PHE    41      37.857  46.706  -1.643  1.00 15.44           C  
ATOM    346  O   PHE    41      37.278  47.347  -0.781  1.00 16.26           O  
ATOM    347  CB  PHE    41      39.994  45.489  -1.080  1.00 16.48           C  
ATOM    348  CG  PHE    41      40.600  44.395  -0.260  1.00 16.72           C  
ATOM    349  CD1 PHE    41      40.213  44.206   1.066  1.00 16.36           C  
ATOM    350  CD2 PHE    41      41.607  43.599  -0.798  1.00 18.31           C  
ATOM    351  CE1 PHE    41      40.788  43.184   1.839  1.00 17.37           C  
ATOM    352  CE2 PHE    41      42.194  42.576  -0.035  1.00 17.66           C  
ATOM    353  CZ  PHE    41      41.779  42.378   1.287  1.00 17.32           C  
ATOM    354  N   LYS    42      37.973  47.118  -2.900  1.00 15.99           N  
ATOM    355  CA  LYS    42      37.278  48.329  -3.408  1.00 17.34           C  
ATOM    356  C   LYS    42      35.755  48.273  -3.244  1.00 17.57           C  
ATOM    357  O   LYS    42      35.146  49.256  -2.833  1.00 16.74           O  
ATOM    358  CB  LYS    42      37.634  48.638  -4.865  1.00 18.01           C  
ATOM    359  CG  LYS    42      39.093  49.050  -5.043  1.00 21.90           C  
ATOM    360  CD  LYS    42      39.416  49.194  -6.520  1.00 25.92           C  
ATOM    361  CE  LYS    42      40.607  50.124  -6.698  1.00 31.54           C  
ATOM    362  NZ  LYS    42      40.793  50.449  -8.144  1.00 35.78           N  
ATOM    363  N   GLN    43      35.141  47.130  -3.560  1.00 17.23           N  
ATOM    364  CA  GLN    43      33.689  46.988  -3.408  1.00 16.65           C  
ATOM    365  C   GLN    43      33.281  47.098  -1.934  1.00 16.50           C  
ATOM    366  O   GLN    43      32.313  47.778  -1.603  1.00 15.99           O  
ATOM    367  CB  GLN    43      33.204  45.648  -3.998  1.00 17.02           C  
ATOM    368  CG  GLN    43      33.434  45.511  -5.503  1.00 14.54           C  
ATOM    369  CD  GLN    43      33.179  44.106  -6.005  1.00 17.25           C  
ATOM    370  OE1 GLN    43      33.287  43.143  -5.240  1.00 15.36           O  
ATOM    371  NE2 GLN    43      32.798  43.981  -7.286  1.00 17.54           N  
ATOM    372  N   ALA    44      34.049  46.460  -1.053  1.00 17.00           N  
ATOM    373  CA  ALA    44      33.780  46.481   0.362  1.00 18.25           C  
ATOM    374  C   ALA    44      33.894  47.920   0.893  1.00 18.29           C  
ATOM    375  O   ALA    44      33.071  48.365   1.710  1.00 19.67           O  
ATOM    376  CB  ALA    44      34.726  45.538   1.082  1.00 18.12           C  
ATOM    377  N   ALA    45      34.879  48.659   0.370  1.00 18.75           N  
ATOM    378  CA  ALA    45      35.095  50.055   0.802  1.00 18.36           C  
ATOM    379  C   ALA    45      33.906  50.917   0.356  1.00 17.22           C  
ATOM    380  O   ALA    45      33.358  51.719   1.139  1.00 18.63           O  
ATOM    381  CB  ALA    45      36.430  50.601   0.207  1.00 18.25           C  
ATOM    382  N   ALA    46      33.485  50.718  -0.884  1.00 17.27           N  
ATOM    383  CA  ALA    46      32.370  51.440  -1.471  1.00 17.55           C  
ATOM    384  C   ALA    46      31.100  51.155  -0.685  1.00 18.90           C  
ATOM    385  O   ALA    46      30.296  52.059  -0.395  1.00 17.88           O  
ATOM    386  CB  ALA    46      32.196  51.040  -2.903  1.00 18.02           C  
ATOM    387  N   ALA    47      30.886  49.882  -0.369  1.00 17.73           N  
ATOM    388  CA  ALA    47      29.743  49.513   0.469  1.00 18.26           C  
ATOM    389  C   ALA    47      29.810  50.180   1.851  1.00 18.11           C  
ATOM    390  O   ALA    47      28.780  50.598   2.404  1.00 19.38           O  
ATOM    391  CB  ALA    47      29.686  47.977   0.621  1.00 18.48           C  
ATOM    392  N   GLY    48      31.011  50.248   2.408  1.00 18.17           N  
ATOM    393  CA  GLY    48      31.250  50.880   3.714  1.00 19.13           C  
ATOM    394  C   GLY    48      30.921  52.359   3.648  1.00 19.49           C  
ATOM    395  O   GLY    48      30.279  52.887   4.548  1.00 20.37           O  
ATOM    396  N   ILE    49      31.301  53.017   2.557  1.00 21.18           N  
ATOM    397  CA  ILE    49      30.955  54.451   2.406  1.00 21.55           C  
ATOM    398  C   ILE    49      29.445  54.633   2.232  1.00 21.40           C  
ATOM    399  O   ILE    49      28.849  55.497   2.891  1.00 20.53           O  
ATOM    400  CB  ILE    49      31.725  55.134   1.271  1.00 21.92           C  
ATOM    401  CG1 ILE    49      33.240  55.058   1.563  1.00 22.53           C  
ATOM    402  CG2 ILE    49      31.190  56.604   1.066  1.00 23.77           C  
ATOM    403  CD1 ILE    49      34.126  55.098   0.360  1.00 25.96           C  
ATOM    404  N   PHE    50      28.825  53.794   1.396  1.00 20.95           N  
ATOM    405  CA  PHE    50      27.381  53.811   1.189  1.00 20.87           C  
ATOM    406  C   PHE    50      26.614  53.701   2.519  1.00 20.75           C  
ATOM    407  O   PHE    50      25.611  54.421   2.729  1.00 20.09           O  
ATOM    408  CB  PHE    50      26.959  52.675   0.236  1.00 21.75           C  
ATOM    409  CG  PHE    50      25.505  52.713  -0.165  1.00 21.42           C  
ATOM    410  CD1 PHE    50      25.034  53.666  -1.070  1.00 23.70           C  
ATOM    411  CD2 PHE    50      24.615  51.769   0.344  1.00 22.52           C  
ATOM    412  CE1 PHE    50      23.685  53.701  -1.454  1.00 25.31           C  
ATOM    413  CE2 PHE    50      23.278  51.778  -0.020  1.00 20.38           C  
ATOM    414  CZ  PHE    50      22.794  52.747  -0.929  1.00 23.41           C  
ATOM    415  N   LEU    51      27.106  52.823   3.398  1.00 20.65           N  
ATOM    416  CA  LEU    51      26.477  52.528   4.707  1.00 20.31           C  
ATOM    417  C   LEU    51      26.994  53.347   5.909  1.00 20.94           C  
ATOM    418  O   LEU    51      26.689  53.035   7.074  1.00 20.47           O  
ATOM    419  CB  LEU    51      26.620  51.024   5.012  1.00 20.45           C  
ATOM    420  CG  LEU    51      26.018  50.029   4.002  1.00 18.73           C  
ATOM    421  CD1 LEU    51      26.516  48.571   4.293  1.00 17.74           C  
ATOM    422  CD2 LEU    51      24.503  50.071   4.006  1.00 18.95           C  
ATOM    423  N   ASN    52      27.776  54.391   5.646  1.00 22.08           N  
ATOM    424  CA  ASN    52      28.569  54.990   6.714  1.00 24.34           C  
ATOM    425  C   ASN    52      27.711  55.621   7.834  1.00 24.30           C  
ATOM    426  O   ASN    52      28.155  55.738   8.984  1.00 24.66           O  
ATOM    427  CB  ASN    52      29.517  56.037   6.111  1.00 25.39           C  
ATOM    428  CG  ASN    52      28.787  57.295   5.740  1.00 28.11           C  
ATOM    429  OD1 ASN    52      28.587  58.166   6.588  1.00 33.96           O  
ATOM    430  ND2 ASN    52      28.315  57.376   4.501  1.00 29.08           N  
ATOM    431  N   ASN    53      26.498  56.042   7.487  1.00 25.05           N  
ATOM    432  CA  ASN    53      25.632  56.715   8.469  1.00 25.92           C  
ATOM    433  C   ASN    53      24.488  55.833   8.952  1.00 25.06           C  
ATOM    434  O   ASN    53      23.578  56.317   9.638  1.00 25.23           O  
ATOM    435  CB  ASN    53      25.075  58.026   7.904  1.00 27.15           C  
ATOM    436  CG  ASN    53      24.652  58.988   9.000  1.00 30.53           C  
ATOM    437  OD1 ASN    53      25.455  59.349   9.865  1.00 36.72           O  
ATOM    438  ND2 ASN    53      23.382  59.389   8.986  1.00 34.91           N  
ATOM    439  N   VAL    54      24.521  54.547   8.585  1.00 23.11           N  
ATOM    440  CA  VAL    54      23.505  53.626   9.060  1.00 21.47           C  
ATOM    441  C   VAL    54      23.824  53.191  10.471  1.00 21.39           C  
ATOM    442  O   VAL    54      24.938  52.731  10.780  1.00 22.40           O  
ATOM    443  CB  VAL    54      23.363  52.343   8.167  1.00 20.54           C  
ATOM    444  CG1 VAL    54      22.303  51.405   8.775  1.00 20.21           C  
ATOM    445  CG2 VAL    54      22.991  52.714   6.759  1.00 20.99           C  
ATOM    446  N   LYS    55      22.832  53.303  11.339  1.00 21.50           N  
ATOM    447  CA  LYS    55      23.011  52.869  12.707  1.00 22.40           C  
ATOM    448  C   LYS    55      22.615  51.395  12.855  1.00 21.79           C  
ATOM    449  O   LYS    55      21.475  51.073  13.260  1.00 22.74           O  
ATOM    450  CB  LYS    55      22.190  53.741  13.659  1.00 23.17           C  
ATOM    451  CG  LYS    55      22.523  55.236  13.533  1.00 26.63           C  
ATOM    452  CD  LYS    55      22.200  55.945  14.829  1.00 32.13           C  
ATOM    453  CE  LYS    55      22.697  57.386  14.808  1.00 34.40           C  
ATOM    454  NZ  LYS    55      22.953  57.903  16.192  1.00 36.92           N  
ATOM    455  N   PHE    56      23.546  50.503  12.539  1.00 20.73           N  
ATOM    456  CA  PHE    56      23.337  49.078  12.823  1.00 19.15           C  
ATOM    457  C   PHE    56      23.510  48.812  14.304  1.00 19.61           C  
ATOM    458  O   PHE    56      24.285  49.504  15.000  1.00 21.15           O  
ATOM    459  CB  PHE    56      24.321  48.167  12.053  1.00 18.58           C  
ATOM    460  CG  PHE    56      24.172  48.230  10.567  1.00 17.80           C  
ATOM    461  CD1 PHE    56      23.018  47.719   9.935  1.00 14.64           C  
ATOM    462  CD2 PHE    56      25.183  48.753   9.779  1.00 16.61           C  
ATOM    463  CE1 PHE    56      22.881  47.789   8.533  1.00 14.77           C  
ATOM    464  CE2 PHE    56      25.061  48.793   8.381  1.00 16.45           C  
ATOM    465  CZ  PHE    56      23.904  48.324   7.749  1.00 14.90           C  
ATOM    466  N   THR    57      22.861  47.749  14.765  1.00 17.09           N  
ATOM    467  CA  THR    57      22.898  47.326  16.146  1.00 16.54           C  
ATOM    468  C   THR    57      23.611  45.992  16.347  1.00 16.67           C  
ATOM    469  O   THR    57      24.075  45.688  17.445  1.00 17.10           O  
ATOM    470  CB  THR    57      21.474  47.200  16.744  1.00 17.55           C  
ATOM    471  OG1 THR    57      20.692  46.278  15.957  1.00 14.51           O  
ATOM    472  CG2 THR    57      20.772  48.546  16.751  1.00 15.49           C  
ATOM    473  N   HIS    58      23.659  45.185  15.272  1.00 15.40           N  
ATOM    474  CA  HIS    58      24.258  43.857  15.350  1.00 14.88           C  
ATOM    475  C   HIS    58      24.974  43.589  14.027  1.00 14.04           C  
ATOM    476  O   HIS    58      24.557  44.082  12.977  1.00 13.96           O  
ATOM    477  CB  HIS    58      23.178  42.780  15.466  1.00 13.38           C  
ATOM    478  CG  HIS    58      22.385  42.839  16.735  1.00 14.77           C  
ATOM    479  ND1 HIS    58      21.409  43.785  16.961  1.00 15.83           N  
ATOM    480  CD2 HIS    58      22.419  42.059  17.838  1.00 15.46           C  
ATOM    481  CE1 HIS    58      20.892  43.595  18.164  1.00 17.07           C  
ATOM    482  NE2 HIS    58      21.460  42.535  18.700  1.00 15.53           N  
ATOM    483  N   ALA    59      26.044  42.806  14.100  1.00 13.04           N  
ATOM    484  CA  ALA    59      26.787  42.411  12.878  1.00 13.95           C  
ATOM    485  C   ALA    59      27.139  40.942  12.968  1.00 14.25           C  
ATOM    486  O   ALA    59      27.758  40.502  13.951  1.00 14.77           O  
ATOM    487  CB  ALA    59      28.058  43.213  12.703  1.00 14.18           C  
ATOM    488  N   PHE    60      26.778  40.185  11.930  1.00 12.96           N  
ATOM    489  CA  PHE    60      27.139  38.760  11.816  1.00 12.74           C  
ATOM    490  C   PHE    60      27.780  38.498  10.478  1.00 12.41           C  
ATOM    491  O   PHE    60      27.340  39.056   9.465  1.00 13.16           O  
ATOM    492  CB  PHE    60      25.911  37.831  11.919  1.00 13.31           C  
ATOM    493  CG  PHE    60      25.207  37.891  13.256  1.00 13.17           C  
ATOM    494  CD1 PHE    60      25.482  36.946  14.244  1.00 15.99           C  
ATOM    495  CD2 PHE    60      24.249  38.868  13.490  1.00 16.08           C  
ATOM    496  CE1 PHE    60      24.827  36.980  15.485  1.00 17.65           C  
ATOM    497  CE2 PHE    60      23.575  38.909  14.728  1.00 17.11           C  
ATOM    498  CZ  PHE    60      23.877  37.976  15.714  1.00 15.95           C  
ATOM    499  N   SER    61      28.775  37.602  10.451  1.00 11.13           N  
ATOM    500  CA  SER    61      29.467  37.297   9.202  1.00 12.21           C  
ATOM    501  C   SER    61      29.727  35.794   9.216  1.00 11.56           C  
ATOM    502  O   SER    61      29.983  35.205  10.263  1.00 12.53           O  
ATOM    503  CB  SER    61      30.800  38.071   9.126  1.00 11.54           C  
ATOM    504  OG  SER    61      31.557  37.684   7.995  1.00 14.79           O  
ATOM    505  N   SER    62      29.687  35.174   8.047  1.00 10.94           N  
ATOM    506  CA  SER    62      30.357  33.901   7.851  1.00 11.59           C  
ATOM    507  C   SER    62      31.798  33.973   8.360  1.00 11.84           C  
ATOM    508  O   SER    62      32.420  35.019   8.272  1.00 11.46           O  
ATOM    509  CB  SER    62      30.392  33.669   6.338  1.00 12.08           C  
ATOM    510  OG  SER    62      31.297  32.701   6.015  1.00 16.57           O  
ATOM    511  N   ASP    63      32.276  32.831   8.853  0.50 12.21           N  
ATOM    513  CA  ASP    63      33.641  32.659   9.378  0.50 13.48           C  
ATOM    515  C   ASP    63      34.594  32.183   8.266  0.50 13.52           C  
ATOM    517  O   ASP    63      35.392  31.242   8.442  0.50 13.40           O  
ATOM    519  CB  ASP    63      33.669  31.742  10.624  0.50 13.93           C  
ATOM    521  CG  ASP    63      33.182  30.313  10.355  0.50 14.36           C  
ATOM    523  OD1 ASP    63      32.267  30.105   9.530  0.50 10.93           O  
ATOM    525  OD2 ASP    63      33.724  29.377  10.988  0.50 15.00           O  
ATOM    527  N   LEU    64      34.455  32.830   7.104  1.00 14.85           N  
ATOM    528  CA  LEU    64      35.372  32.683   5.974  1.00 14.13           C  
ATOM    529  C   LEU    64      36.040  34.045   5.711  1.00 13.74           C  
ATOM    530  O   LEU    64      35.487  35.081   6.092  1.00 12.53           O  
ATOM    531  CB  LEU    64      34.610  32.144   4.735  1.00 14.06           C  
ATOM    532  CG  LEU    64      34.112  30.684   4.857  1.00 15.57           C  
ATOM    533  CD1 LEU    64      33.222  30.172   3.726  1.00 16.81           C  
ATOM    534  CD2 LEU    64      35.373  29.730   5.011  1.00 16.50           C  
ATOM    535  N   MET    65      37.244  34.054   5.120  1.00 13.80           N  
ATOM    536  CA  MET    65      37.997  35.312   4.978  1.00 14.27           C  
ATOM    537  C   MET    65      37.259  36.328   4.141  1.00 12.80           C  
ATOM    538  O   MET    65      37.249  37.513   4.483  1.00 12.68           O  
ATOM    539  CB  MET    65      39.344  35.088   4.268  1.00 14.39           C  
ATOM    540  CG  MET    65      40.368  34.551   5.151  1.00 19.40           C  
ATOM    541  SD  MET    65      42.061  34.816   4.234  1.00 17.57          SE  
ATOM    542  CE  MET    65      42.703  36.459   4.953  1.00 18.75           C  
ATOM    543  N   ARG    66      36.664  35.878   3.035  1.00 11.81           N  
ATOM    544  CA  ARG    66      36.066  36.820   2.071  1.00 11.30           C  
ATOM    545  C   ARG    66      34.928  37.632   2.693  1.00 12.24           C  
ATOM    546  O   ARG    66      34.802  38.856   2.479  1.00 11.93           O  
ATOM    547  CB  ARG    66      35.654  36.107   0.777  1.00 10.46           C  
ATOM    548  CG  ARG    66      34.682  34.894   0.959  1.00 10.29           C  
ATOM    549  CD  ARG    66      34.627  34.203  -0.373  1.00 12.79           C  
ATOM    550  NE  ARG    66      33.700  33.054  -0.470  1.00 11.27           N  
ATOM    551  CZ  ARG    66      33.988  31.816  -0.053  1.00 14.16           C  
ATOM    552  NH1 ARG    66      33.126  30.849  -0.290  1.00 12.57           N  
ATOM    553  NH2 ARG    66      35.111  31.536   0.612  1.00 11.25           N  
ATOM    554  N   THR    67      34.149  36.966   3.543  1.00 11.56           N  
ATOM    555  CA  THR    67      33.050  37.640   4.242  1.00 12.08           C  
ATOM    556  C   THR    67      33.622  38.488   5.417  1.00 11.63           C  
ATOM    557  O   THR    67      33.223  39.648   5.611  1.00 12.77           O  
ATOM    558  CB  THR    67      32.050  36.601   4.741  1.00 10.04           C  
ATOM    559  OG1 THR    67      32.796  35.490   5.240  1.00 12.29           O  
ATOM    560  CG2 THR    67      31.131  36.086   3.571  1.00 11.13           C  
ATOM    561  N   LYS    68      34.592  37.937   6.151  1.00 13.01           N  
ATOM    562  CA  LYS    68      35.199  38.673   7.299  1.00 13.10           C  
ATOM    563  C   LYS    68      35.821  40.001   6.795  1.00 11.78           C  
ATOM    564  O   LYS    68      35.613  41.042   7.377  1.00 11.93           O  
ATOM    565  CB  LYS    68      36.239  37.809   8.024  1.00 13.79           C  
ATOM    566  CG  LYS    68      37.010  38.545   9.119  1.00 16.70           C  
ATOM    567  CD  LYS    68      37.820  37.554   9.999  1.00 17.70           C  
ATOM    568  CE  LYS    68      38.271  38.243  11.310  1.00 22.84           C  
ATOM    569  NZ  LYS    68      38.987  37.265  12.187  1.00 25.71           N  
ATOM    570  N   GLN    69      36.578  39.925   5.702  1.00 11.45           N  
ATOM    571  CA  GLN    69      37.230  41.109   5.149  1.00 12.01           C  
ATOM    572  C   GLN    69      36.212  42.128   4.655  1.00 12.80           C  
ATOM    573  O   GLN    69      36.421  43.360   4.776  1.00 12.36           O  
ATOM    574  CB  GLN    69      38.143  40.690   4.024  1.00 11.90           C  
ATOM    575  CG  GLN    69      39.389  39.947   4.540  1.00 11.34           C  
ATOM    576  CD  GLN    69      40.288  39.535   3.414  1.00 14.07           C  
ATOM    577  OE1 GLN    69      39.807  39.100   2.363  1.00 12.32           O  
ATOM    578  NE2 GLN    69      41.613  39.608   3.639  1.00 15.02           N  
ATOM    579  N   THR    70      35.107  41.621   4.080  1.00 12.32           N  
ATOM    580  CA  THR    70      34.067  42.536   3.591  1.00 12.94           C  
ATOM    581  C   THR    70      33.409  43.288   4.778  1.00 12.24           C  
ATOM    582  O   THR    70      33.180  44.519   4.705  1.00 12.26           O  
ATOM    583  CB  THR    70      33.005  41.781   2.757  1.00 12.52           C  
ATOM    584  OG1 THR    70      33.657  41.176   1.623  1.00 12.51           O  
ATOM    585  CG2 THR    70      31.874  42.738   2.253  1.00 11.26           C  
ATOM    586  N   MET    71      33.076  42.532   5.819  1.00 12.95           N  
ATOM    587  CA  MET    71      32.513  43.084   7.054  1.00 14.04           C  
ATOM    588  C   MET    71      33.506  44.129   7.601  1.00 15.16           C  
ATOM    589  O   MET    71      33.100  45.209   8.015  1.00 14.69           O  
ATOM    590  CB  MET    71      32.311  42.000   8.084  1.00 14.72           C  
ATOM    591  CG  MET    71      31.741  42.503   9.416  1.00 16.03           C  
ATOM    592  SD  MET    71      30.009  43.366   9.266  1.00 12.53          SE  
ATOM    593  CE  MET    71      28.976  41.707   9.223  1.00 13.52           C  
ATOM    594  N   HIS    72      34.798  43.805   7.570  1.00 15.73           N  
ATOM    595  CA  HIS    72      35.798  44.765   8.079  1.00 17.92           C  
ATOM    596  C   HIS    72      35.799  46.068   7.279  1.00 18.23           C  
ATOM    597  O   HIS    72      35.806  47.170   7.877  1.00 18.65           O  
ATOM    598  CB  HIS    72      37.197  44.172   8.104  1.00 18.26           C  
ATOM    599  CG  HIS    72      38.231  45.134   8.616  1.00 22.21           C  
ATOM    600  ND1 HIS    72      38.329  45.480   9.946  1.00 26.17           N  
ATOM    601  CD2 HIS    72      39.186  45.851   7.968  1.00 26.64           C  
ATOM    602  CE1 HIS    72      39.323  46.337  10.106  1.00 25.60           C  
ATOM    603  NE2 HIS    72      39.856  46.583   8.920  1.00 28.23           N  
ATOM    604  N   GLY    73      35.786  45.922   5.950  1.00 17.64           N  
ATOM    605  CA  GLY    73      35.749  47.021   4.982  1.00 18.22           C  
ATOM    606  C   GLY    73      34.553  47.914   5.241  1.00 18.59           C  
ATOM    607  O   GLY    73      34.632  49.135   5.137  1.00 17.35           O  
ATOM    608  N   ILE    74      33.422  47.293   5.569  1.00 17.82           N  
ATOM    609  CA  ILE    74      32.208  48.049   5.833  1.00 18.14           C  
ATOM    610  C   ILE    74      32.322  48.766   7.168  1.00 19.12           C  
ATOM    611  O   ILE    74      32.124  49.976   7.216  1.00 20.75           O  
ATOM    612  CB  ILE    74      30.929  47.127   5.787  1.00 17.24           C  
ATOM    613  CG1 ILE    74      30.633  46.719   4.347  1.00 18.41           C  
ATOM    614  CG2 ILE    74      29.716  47.847   6.393  1.00 17.25           C  
ATOM    615  CD1 ILE    74      29.677  45.514   4.249  1.00 17.62           C  
ATOM    616  N   LEU    75      32.660  48.047   8.242  1.00 20.26           N  
ATOM    617  CA  LEU    75      32.654  48.660   9.584  1.00 20.39           C  
ATOM    618  C   LEU    75      33.748  49.711   9.784  1.00 21.93           C  
ATOM    619  O   LEU    75      33.506  50.723  10.442  1.00 21.81           O  
ATOM    620  CB  LEU    75      32.682  47.618  10.687  1.00 20.74           C  
ATOM    621  CG  LEU    75      31.457  46.705  10.768  1.00 18.86           C  
ATOM    622  CD1 LEU    75      31.706  45.688  11.869  1.00 20.32           C  
ATOM    623  CD2 LEU    75      30.175  47.516  10.991  1.00 20.37           C  
ATOM    624  N   GLU    76      34.907  49.519   9.165  1.00 22.34           N  
ATOM    625  CA  GLU    76      35.997  50.479   9.357  1.00 25.10           C  
ATOM    626  C   GLU    76      35.621  51.889   8.865  1.00 25.23           C  
ATOM    627  O   GLU    76      36.219  52.863   9.314  1.00 26.75           O  
ATOM    628  CB  GLU    76      37.318  49.973   8.753  1.00 24.36           C  
ATOM    629  CG  GLU    76      37.476  50.167   7.255  1.00 25.72           C  
ATOM    630  CD  GLU    76      38.694  49.424   6.693  1.00 27.22           C  
ATOM    631  OE1 GLU    76      39.583  49.024   7.479  1.00 30.93           O  
ATOM    632  OE2 GLU    76      38.774  49.240   5.461  1.00 32.26           O  
ATOM    633  N   ARG    77      34.624  51.982   7.977  1.00 25.58           N  
ATOM    634  CA  ARG    77      34.132  53.257   7.427  1.00 26.51           C  
ATOM    635  C   ARG    77      32.831  53.782   8.025  1.00 26.65           C  
ATOM    636  O   ARG    77      32.262  54.749   7.501  1.00 26.66           O  
ATOM    637  CB  ARG    77      33.949  53.141   5.920  1.00 26.38           C  
ATOM    638  CG  ARG    77      35.290  53.011   5.227  1.00 27.67           C  
ATOM    639  CD  ARG    77      35.178  52.485   3.846  1.00 30.97           C  
ATOM    640  NE  ARG    77      36.510  52.433   3.255  1.00 30.98           N  
ATOM    641  CZ  ARG    77      37.312  51.372   3.292  1.00 35.20           C  
ATOM    642  NH1 ARG    77      38.520  51.454   2.715  1.00 36.34           N  
ATOM    643  NH2 ARG    77      36.910  50.228   3.875  1.00 28.89           N  
ATOM    644  N   SER    78      32.357  53.130   9.079  1.00 26.15           N  
ATOM    645  CA  SER    78      31.086  53.486   9.669  1.00 27.03           C  
ATOM    646  C   SER    78      31.300  54.636  10.634  1.00 27.68           C  
ATOM    647  O   SER    78      32.276  54.646  11.391  1.00 27.16           O  
ATOM    648  CB  SER    78      30.468  52.308  10.416  1.00 26.71           C  
ATOM    649  OG  SER    78      29.259  52.707  11.068  1.00 26.27           O  
ATOM    650  N   LYS    79      30.379  55.591  10.600  1.00 29.19           N  
ATOM    651  CA  LYS    79      30.364  56.674  11.605  1.00 30.36           C  
ATOM    652  C   LYS    79      30.015  56.189  13.025  1.00 30.63           C  
ATOM    653  O   LYS    79      30.639  56.613  14.014  1.00 30.77           O  
ATOM    654  CB  LYS    79      29.411  57.772  11.163  1.00 30.35           C  
ATOM    655  CG  LYS    79      29.804  58.387   9.823  1.00 34.19           C  
ATOM    656  CD  LYS    79      28.840  59.478   9.389  1.00 38.11           C  
ATOM    657  CE  LYS    79      29.545  60.497   8.510  1.00 41.68           C  
ATOM    658  NZ  LYS    79      30.320  59.884   7.374  1.00 44.79           N  
ATOM    659  N   PHE    80      29.039  55.283  13.132  1.00 30.30           N  
ATOM    660  CA  PHE    80      28.579  54.815  14.441  1.00 29.95           C  
ATOM    661  C   PHE    80      29.020  53.438  14.871  1.00 29.66           C  
ATOM    662  O   PHE    80      29.052  53.163  16.069  1.00 29.18           O  
ATOM    663  CB  PHE    80      27.053  54.898  14.522  1.00 31.44           C  
ATOM    664  CG  PHE    80      26.530  56.235  14.154  1.00 34.11           C  
ATOM    665  CD1 PHE    80      26.564  57.278  15.077  1.00 37.99           C  
ATOM    666  CD2 PHE    80      26.056  56.478  12.874  1.00 35.72           C  
ATOM    667  CE1 PHE    80      26.106  58.537  14.729  1.00 38.23           C  
ATOM    668  CE2 PHE    80      25.597  57.722  12.519  1.00 39.19           C  
ATOM    669  CZ  PHE    80      25.623  58.758  13.446  1.00 38.01           C  
ATOM    670  N   CYS    81      29.366  52.575  13.910  1.00 28.01           N  
ATOM    671  CA  CYS    81      29.606  51.158  14.197  1.00 27.84           C  
ATOM    672  C   CYS    81      31.044  50.686  13.981  1.00 27.70           C  
ATOM    673  O   CYS    81      31.309  49.485  14.007  1.00 26.84           O  
ATOM    674  CB  CYS    81      28.645  50.276  13.398  1.00 27.28           C  
ATOM    675  SG  CYS    81      26.920  50.779  13.612  1.00 28.89           S  
ATOM    676  N   LYS    82      31.985  51.617  13.832  1.00 27.45           N  
ATOM    677  CA  LYS    82      33.403  51.222  13.766  1.00 28.50           C  
ATOM    678  C   LYS    82      33.834  50.144  14.796  1.00 27.82           C  
ATOM    679  O   LYS    82      34.547  49.182  14.454  1.00 28.25           O  
ATOM    680  CB  LYS    82      34.281  52.465  13.927  1.00 28.86           C  
ATOM    681  CG  LYS    82      35.101  52.816  12.713  1.00 32.47           C  
ATOM    682  CD  LYS    82      36.212  53.785  13.150  1.00 36.51           C  
ATOM    683  CE  LYS    82      37.407  53.769  12.213  1.00 39.21           C  
ATOM    684  NZ  LYS    82      38.422  54.834  12.584  1.00 41.30           N  
ATOM    685  N   ASP    83      33.375  50.304  16.039  1.00 27.50           N  
ATOM    686  CA  ASP    83      33.775  49.512  17.197  1.00 28.02           C  
ATOM    687  C   ASP    83      32.878  48.306  17.488  1.00 27.52           C  
ATOM    688  O   ASP    83      33.135  47.570  18.441  1.00 26.64           O  
ATOM    689  CB  ASP    83      33.731  50.395  18.458  1.00 29.41           C  
ATOM    690  CG  ASP    83      35.074  50.979  18.833  1.00 33.35           C  
ATOM    691  OD1 ASP    83      36.018  50.982  18.002  1.00 37.87           O  
ATOM    692  OD2 ASP    83      35.171  51.465  19.991  1.00 39.80           O  
ATOM    693  N   MET    84      31.827  48.123  16.684  1.00 27.33           N  
ATOM    694  CA  MET    84      30.888  47.015  16.853  1.00 27.36           C  
ATOM    695  C   MET    84      31.554  45.635  16.835  1.00 26.64           C  
ATOM    696  O   MET    84      32.397  45.363  15.972  1.00 26.44           O  
ATOM    697  CB  MET    84      29.828  47.074  15.754  1.00 27.33           C  
ATOM    698  CG  MET    84      28.843  45.919  15.820  1.00 29.83           C  
ATOM    699  SD  MET    84      27.184  46.452  15.025  1.00 28.68          SE  
ATOM    700  CE  MET    84      26.622  47.647  16.472  1.00 31.10           C  
ATOM    701  N   THR    85      31.151  44.771  17.770  1.00 25.42           N  
ATOM    702  CA  THR    85      31.643  43.400  17.829  1.00 25.35           C  
ATOM    703  C   THR    85      30.957  42.626  16.710  1.00 23.90           C  
ATOM    704  O   THR    85      29.733  42.626  16.620  1.00 25.42           O  
ATOM    705  CB  THR    85      31.307  42.725  19.175  1.00 26.00           C  
ATOM    706  OG1 THR    85      31.981  43.414  20.236  1.00 30.50           O  
ATOM    707  CG2 THR    85      31.750  41.256  19.191  1.00 26.88           C  
ATOM    708  N   VAL    86      31.747  41.998  15.858  1.00 21.60           N  
ATOM    709  CA  VAL    86      31.200  41.111  14.828  1.00 20.01           C  
ATOM    710  C   VAL    86      31.084  39.709  15.396  1.00 19.18           C  
ATOM    711  O   VAL    86      32.048  39.192  15.994  1.00 18.56           O  
ATOM    712  CB  VAL    86      32.133  41.078  13.584  1.00 19.70           C  
ATOM    713  CG1 VAL    86      31.600  40.066  12.497  1.00 19.54           C  
ATOM    714  CG2 VAL    86      32.330  42.463  13.026  1.00 19.51           C  
ATOM    715  N   LYS    87      29.931  39.060  15.205  1.00 18.68           N  
ATOM    716  CA  LYS    87      29.822  37.655  15.569  1.00 18.36           C  
ATOM    717  C   LYS    87      30.030  36.774  14.329  1.00 18.76           C  
ATOM    718  O   LYS    87      29.404  37.017  13.300  1.00 17.89           O  
ATOM    719  CB  LYS    87      28.465  37.363  16.219  1.00 20.32           C  
ATOM    720  CG  LYS    87      28.207  38.121  17.539  1.00 23.26           C  
ATOM    721  CD  LYS    87      28.881  37.441  18.727  1.00 29.51           C  
ATOM    722  CE  LYS    87      28.862  38.306  20.018  1.00 29.46           C  
ATOM    723  NZ  LYS    87      27.499  38.859  20.350  1.00 34.69           N  
ATOM    724  N   TYR    88      30.908  35.778  14.414  1.00 17.24           N  
ATOM    725  CA  TYR    88      31.205  34.925  13.245  1.00 17.08           C  
ATOM    726  C   TYR    88      30.472  33.634  13.446  1.00 17.77           C  
ATOM    727  O   TYR    88      30.595  33.005  14.519  1.00 19.09           O  
ATOM    728  CB  TYR    88      32.723  34.681  13.083  1.00 16.63           C  
ATOM    729  CG  TYR    88      33.416  35.982  12.807  1.00 16.87           C  
ATOM    730  CD1 TYR    88      33.417  36.518  11.521  1.00 15.13           C  
ATOM    731  CD2 TYR    88      33.947  36.751  13.855  1.00 19.18           C  
ATOM    732  CE1 TYR    88      33.996  37.748  11.259  1.00 16.39           C  
ATOM    733  CE2 TYR    88      34.524  37.980  13.606  1.00 16.91           C  
ATOM    734  CZ  TYR    88      34.548  38.461  12.314  1.00 18.38           C  
ATOM    735  OH  TYR    88      35.119  39.660  12.080  1.00 18.80           O  
ATOM    736  N   ASP    89      29.706  33.225  12.429  1.00 15.32           N  
ATOM    737  CA  ASP    89      28.752  32.138  12.598  1.00 14.95           C  
ATOM    738  C   ASP    89      28.880  31.221  11.400  1.00 14.21           C  
ATOM    739  O   ASP    89      28.637  31.632  10.269  1.00 13.18           O  
ATOM    740  CB  ASP    89      27.320  32.705  12.754  1.00 13.62           C  
ATOM    741  CG  ASP    89      26.326  31.703  13.309  1.00 17.57           C  
ATOM    742  OD1 ASP    89      26.216  30.557  12.790  1.00 16.56           O  
ATOM    743  OD2 ASP    89      25.635  32.056  14.296  1.00 18.76           O  
ATOM    744  N   SER    90      29.255  29.979  11.660  1.00 13.24           N  
ATOM    745  CA  SER    90      29.434  28.988  10.594  1.00 13.21           C  
ATOM    746  C   SER    90      28.127  28.694   9.846  1.00 12.15           C  
ATOM    747  O   SER    90      28.166  28.199   8.726  1.00 12.17           O  
ATOM    748  CB  SER    90      30.017  27.664  11.149  1.00 14.65           C  
ATOM    749  OG  SER    90      29.081  27.013  11.999  1.00 16.86           O  
ATOM    750  N   ARG    91      26.978  28.922  10.475  1.00 11.21           N  
ATOM    751  CA  ARG    91      25.693  28.726   9.753  1.00 11.52           C  
ATOM    752  C   ARG    91      25.545  29.632   8.523  1.00 10.85           C  
ATOM    753  O   ARG    91      24.752  29.346   7.617  1.00 11.71           O  
ATOM    754  CB  ARG    91      24.487  28.872  10.673  1.00 10.94           C  
ATOM    755  CG  ARG    91      24.441  27.792  11.768  1.00 13.03           C  
ATOM    756  CD  ARG    91      23.351  28.149  12.747  1.00 15.77           C  
ATOM    757  NE  ARG    91      23.786  29.244  13.608  1.00 15.09           N  
ATOM    758  CZ  ARG    91      23.191  29.560  14.752  1.00 17.43           C  
ATOM    759  NH1 ARG    91      22.113  28.881  15.146  1.00 16.56           N  
ATOM    760  NH2 ARG    91      23.653  30.574  15.469  1.00 16.42           N  
ATOM    761  N   LEU    92      26.309  30.720   8.483  1.00 10.05           N  
ATOM    762  CA  LEU    92      26.264  31.669   7.370  1.00 10.24           C  
ATOM    763  C   LEU    92      27.184  31.304   6.192  1.00 10.17           C  
ATOM    764  O   LEU    92      27.289  32.071   5.230  1.00  9.19           O  
ATOM    765  CB  LEU    92      26.659  33.064   7.888  1.00 10.64           C  
ATOM    766  CG  LEU    92      25.647  33.620   8.896  1.00  7.81           C  
ATOM    767  CD1 LEU    92      26.151  34.998   9.449  1.00  9.51           C  
ATOM    768  CD2 LEU    92      24.265  33.840   8.216  1.00  9.67           C  
ATOM    769  N   ARG    93      27.896  30.172   6.322  1.00  9.79           N  
ATOM    770  CA  ARG    93      28.920  29.832   5.307  0.50 10.74           C  
ATOM    772  C   ARG    93      28.293  29.473   3.946  1.00 10.23           C  
ATOM    773  O   ARG    93      27.130  29.136   3.852  1.00  9.45           O  
ATOM    774  CB  ARG    93      29.871  28.723   5.810  0.50 10.99           C  
ATOM    776  CG  ARG    93      30.830  29.182   6.953  0.50 10.53           C  
ATOM    778  CD  ARG    93      31.618  28.043   7.722  0.50 13.00           C  
ATOM    780  NE  ARG    93      32.947  27.783   7.170  0.50 16.63           N  
ATOM    782  CZ  ARG    93      33.539  26.581   7.087  0.50 18.09           C  
ATOM    784  NH1 ARG    93      34.723  26.475   6.518  0.50 20.66           N  
ATOM    786  NH2 ARG    93      32.953  25.481   7.538  0.50 21.05           N  
ATOM    788  N   GLU    94      29.087  29.574   2.874  1.00  9.81           N  
ATOM    789  CA  GLU    94      28.566  29.225   1.559  1.00  9.24           C  
ATOM    790  C   GLU    94      28.222  27.720   1.486  1.00  8.74           C  
ATOM    791  O   GLU    94      28.737  26.905   2.264  1.00 10.34           O  
ATOM    792  CB  GLU    94      29.576  29.564   0.464  1.00 11.27           C  
ATOM    793  CG  GLU    94      29.088  29.349  -0.995  1.00 12.74           C  
ATOM    794  CD  GLU    94      27.785  30.006  -1.403  1.00 10.47           C  
ATOM    795  OE1 GLU    94      26.737  29.737  -0.779  1.00 14.15           O  
ATOM    796  OE2 GLU    94      27.760  30.741  -2.438  1.00 16.89           O  
ATOM    797  N   ARG    95      27.340  27.399   0.548  1.00  9.78           N  
ATOM    798  CA  ARG    95      27.030  25.998   0.196  1.00  9.41           C  
ATOM    799  C   ARG    95      28.352  25.240  -0.046  1.00 10.34           C  
ATOM    800  O   ARG    95      29.275  25.768  -0.680  1.00 10.97           O  
ATOM    801  CB  ARG    95      26.208  26.018  -1.105  1.00 10.13           C  
ATOM    802  CG  ARG    95      25.946  24.628  -1.684  1.00 11.28           C  
ATOM    803  CD  ARG    95      24.903  24.690  -2.839  1.00 10.27           C  
ATOM    804  NE  ARG    95      24.391  23.349  -3.179  1.00 11.61           N  
ATOM    805  CZ  ARG    95      23.752  23.052  -4.310  1.00 14.85           C  
ATOM    806  NH1 ARG    95      23.582  23.987  -5.240  1.00 13.49           N  
ATOM    807  NH2 ARG    95      23.327  21.791  -4.534  1.00 15.15           N  
ATOM    808  N   LYS    96      28.445  24.020   0.483  1.00 10.77           N  
ATOM    809  CA  LYS    96      29.595  23.136   0.192  1.00 11.17           C  
ATOM    810  C   LYS    96      29.486  22.581  -1.218  1.00 10.95           C  
ATOM    811  O   LYS    96      28.428  22.118  -1.598  1.00 10.65           O  
ATOM    812  CB  LYS    96      29.583  21.978   1.171  1.00 11.63           C  
ATOM    813  CG  LYS    96      30.032  22.318   2.529  1.00 13.62           C  
ATOM    814  CD  LYS    96      29.955  21.039   3.375  1.00 16.90           C  
ATOM    815  CE  LYS    96      30.787  21.227   4.642  1.00 21.22           C  
ATOM    816  NZ  LYS    96      30.972  19.848   5.295  1.00 27.76           N  
ATOM    817  N   TYR    97      30.603  22.551  -1.955  1.00 11.30           N  
ATOM    818  CA  TYR    97      30.624  21.926  -3.290  1.00 12.22           C  
ATOM    819  C   TYR    97      31.571  20.706  -3.360  1.00 11.94           C  
ATOM    820  O   TYR    97      31.841  20.166  -4.447  1.00 12.35           O  
ATOM    821  CB  TYR    97      31.000  22.967  -4.355  1.00 13.04           C  
ATOM    822  CG  TYR    97      29.936  24.034  -4.515  1.00 14.72           C  
ATOM    823  CD1 TYR    97      28.774  23.798  -5.274  1.00 14.38           C  
ATOM    824  CD2 TYR    97      30.088  25.270  -3.896  1.00 15.43           C  
ATOM    825  CE1 TYR    97      27.810  24.791  -5.393  1.00 14.73           C  
ATOM    826  CE2 TYR    97      29.122  26.262  -4.010  1.00 12.53           C  
ATOM    827  CZ  TYR    97      27.999  26.014  -4.720  1.00 14.34           C  
ATOM    828  OH  TYR    97      27.092  27.032  -4.827  1.00 16.25           O  
ATOM    829  N   GLY    98      32.089  20.291  -2.206  1.00 11.77           N  
ATOM    830  CA  GLY    98      32.826  19.036  -2.111  1.00 12.24           C  
ATOM    831  C   GLY    98      33.949  18.921  -3.124  1.00 11.83           C  
ATOM    832  O   GLY    98      34.843  19.794  -3.224  1.00 11.40           O  
ATOM    833  N   VAL    99      33.936  17.809  -3.851  1.00 12.50           N  
ATOM    834  CA  VAL    99      35.079  17.516  -4.759  1.00 12.04           C  
ATOM    835  C   VAL    99      35.247  18.503  -5.926  1.00 13.67           C  
ATOM    836  O   VAL    99      36.288  18.456  -6.634  1.00 14.68           O  
ATOM    837  CB  VAL    99      34.966  16.107  -5.330  1.00 12.48           C  
ATOM    838  CG1 VAL    99      34.952  15.066  -4.205  1.00 11.02           C  
ATOM    839  CG2 VAL    99      33.676  16.004  -6.206  1.00 10.02           C  
ATOM    840  N   VAL   100      34.243  19.356  -6.190  1.00 13.11           N  
ATOM    841  CA  VAL   100      34.429  20.384  -7.258  1.00 14.81           C  
ATOM    842  C   VAL   100      34.881  21.755  -6.749  1.00 14.74           C  
ATOM    843  O   VAL   100      35.011  22.702  -7.539  1.00 14.67           O  
ATOM    844  CB  VAL   100      33.220  20.532  -8.215  1.00 15.29           C  
ATOM    845  CG1 VAL   100      32.946  19.211  -8.916  1.00 19.59           C  
ATOM    846  CG2 VAL   100      32.006  20.981  -7.464  1.00 14.33           C  
ATOM    847  N   GLU   101      35.136  21.874  -5.446  1.00 14.02           N  
ATOM    848  CA  GLU   101      35.714  23.106  -4.924  1.00 14.89           C  
ATOM    849  C   GLU   101      37.010  23.377  -5.661  1.00 16.00           C  
ATOM    850  O   GLU   101      37.861  22.484  -5.742  1.00 16.46           O  
ATOM    851  CB  GLU   101      36.007  22.975  -3.420  1.00 15.96           C  
ATOM    852  CG  GLU   101      34.792  22.693  -2.590  1.00 18.68           C  
ATOM    853  CD  GLU   101      34.050  23.919  -2.181  1.00 21.81           C  
ATOM    854  OE1 GLU   101      34.382  25.012  -2.728  1.00 23.06           O  
ATOM    855  OE2 GLU   101      33.145  23.767  -1.300  1.00 19.19           O  
ATOM    856  N   GLY   102      37.147  24.585  -6.197  1.00 16.89           N  
ATOM    857  CA  GLY   102      38.361  24.997  -6.908  1.00 18.62           C  
ATOM    858  C   GLY   102      38.395  24.590  -8.367  1.00 19.14           C  
ATOM    859  O   GLY   102      39.412  24.832  -9.049  1.00 20.07           O  
ATOM    860  N   LYS   103      37.291  24.032  -8.876  1.00 18.98           N  
ATOM    861  CA  LYS   103      37.197  23.699 -10.299  1.00 20.92           C  
ATOM    862  C   LYS   103      36.380  24.757 -11.029  1.00 21.03           C  
ATOM    863  O   LYS   103      35.632  25.519 -10.411  1.00 20.19           O  
ATOM    864  CB  LYS   103      36.570  22.310 -10.518  1.00 20.50           C  
ATOM    865  CG  LYS   103      37.190  21.159  -9.715  1.00 22.86           C  
ATOM    866  CD  LYS   103      38.507  20.669 -10.290  1.00 23.45           C  
ATOM    867  CE  LYS   103      38.950  19.375  -9.614  1.00 23.50           C  
ATOM    868  NZ  LYS   103      40.298  18.991 -10.102  1.00 25.68           N  
ATOM    869  N   ALA   104      36.531  24.809 -12.356  1.00 22.14           N  
ATOM    870  CA  ALA   104      35.691  25.672 -13.175  1.00 23.68           C  
ATOM    871  C   ALA   104      34.233  25.281 -13.011  1.00 24.89           C  
ATOM    872  O   ALA   104      33.888  24.084 -12.896  1.00 23.99           O  
ATOM    873  CB  ALA   104      36.097  25.574 -14.678  1.00 24.14           C  
ATOM    874  N   LEU   105      33.380  26.298 -12.996  1.00 27.07           N  
ATOM    875  CA  LEU   105      31.931  26.103 -13.087  1.00 28.87           C  
ATOM    876  C   LEU   105      31.530  25.061 -14.143  1.00 29.02           C  
ATOM    877  O   LEU   105      30.664  24.232 -13.898  1.00 29.23           O  
ATOM    878  CB  LEU   105      31.257  27.442 -13.362  1.00 29.23           C  
ATOM    879  CG  LEU   105      29.755  27.479 -13.668  1.00 31.02           C  
ATOM    880  CD1 LEU   105      28.907  27.141 -12.425  1.00 32.77           C  
ATOM    881  CD2 LEU   105      29.399  28.852 -14.209  1.00 30.51           C  
ATOM    882  N   SER   106      32.178  25.086 -15.307  1.00 29.91           N  
ATOM    883  CA  SER   106      31.881  24.149 -16.387  1.00 29.14           C  
ATOM    884  C   SER   106      32.051  22.681 -15.998  1.00 29.11           C  
ATOM    885  O   SER   106      31.355  21.822 -16.527  1.00 29.44           O  
ATOM    886  CB  SER   106      32.728  24.472 -17.622  1.00 29.72           C  
ATOM    887  OG  SER   106      34.098  24.225 -17.361  1.00 30.00           O  
ATOM    888  N   GLU   107      32.982  22.398 -15.080  1.00 27.75           N  
ATOM    889  CA  GLU   107      33.183  21.041 -14.562  1.00 27.48           C  
ATOM    890  C   GLU   107      32.013  20.561 -13.714  1.00 26.29           C  
ATOM    891  O   GLU   107      31.682  19.367 -13.708  1.00 25.83           O  
ATOM    892  CB  GLU   107      34.431  20.982 -13.697  1.00 27.28           C  
ATOM    893  CG  GLU   107      35.726  20.925 -14.471  1.00 31.09           C  
ATOM    894  CD  GLU   107      36.761  20.054 -13.765  1.00 34.47           C  
ATOM    895  OE1 GLU   107      36.413  18.951 -13.265  1.00 39.28           O  
ATOM    896  OE2 GLU   107      37.930  20.465 -13.731  1.00 36.57           O  
ATOM    897  N   LEU   108      31.437  21.482 -12.953  1.00 24.91           N  
ATOM    898  CA  LEU   108      30.246  21.168 -12.154  1.00 24.54           C  
ATOM    899  C   LEU   108      29.064  20.903 -13.085  1.00 24.38           C  
ATOM    900  O   LEU   108      28.318  19.949 -12.900  1.00 23.94           O  
ATOM    901  CB  LEU   108      29.924  22.317 -11.200  1.00 23.85           C  
ATOM    902  CG  LEU   108      28.633  22.283 -10.366  1.00 24.31           C  
ATOM    903  CD1 LEU   108      28.572  21.058  -9.475  1.00 24.85           C  
ATOM    904  CD2 LEU   108      28.493  23.548  -9.560  1.00 25.05           C  
ATOM    905  N   ARG   109      28.905  21.759 -14.093  1.00 24.69           N  
ATOM    906  CA  ARG   109      27.797  21.593 -15.046  1.00 25.81           C  
ATOM    907  C   ARG   109      27.927  20.267 -15.799  1.00 25.60           C  
ATOM    908  O   ARG   109      26.936  19.578 -16.013  1.00 25.88           O  
ATOM    909  CB  ARG   109      27.722  22.778 -16.012  1.00 26.38           C  
ATOM    910  CG  ARG   109      27.505  24.090 -15.295  1.00 29.70           C  
ATOM    911  CD  ARG   109      26.671  25.027 -16.096  1.00 37.60           C  
ATOM    912  NE  ARG   109      26.665  26.367 -15.512  1.00 43.01           N  
ATOM    913  CZ  ARG   109      26.248  27.449 -16.166  1.00 45.11           C  
ATOM    914  NH1 ARG   109      25.796  27.329 -17.408  1.00 47.16           N  
ATOM    915  NH2 ARG   109      26.277  28.645 -15.585  1.00 47.45           N  
ATOM    916  N   ALA   110      29.155  19.917 -16.190  1.00 25.45           N  
ATOM    917  CA  ALA   110      29.412  18.652 -16.891  1.00 25.48           C  
ATOM    918  C   ALA   110      29.078  17.447 -16.012  1.00 25.62           C  
ATOM    919  O   ALA   110      28.485  16.465 -16.476  1.00 25.86           O  
ATOM    920  CB  ALA   110      30.848  18.593 -17.374  1.00 25.39           C  
ATOM    921  N   MET   111      29.438  17.540 -14.729  1.00 24.85           N  
ATOM    922  CA  MET   111      29.117  16.514 -13.757  0.50 23.26           C  
ATOM    924  C   MET   111      27.592  16.359 -13.584  1.00 24.91           C  
ATOM    925  O   MET   111      27.085  15.230 -13.477  1.00 24.74           O  
ATOM    926  CB  MET   111      29.815  16.828 -12.422  0.50 23.59           C  
ATOM    928  CG  MET   111      30.092  15.611 -11.579  0.50 20.75           C  
ATOM    930  SD  MET   111      30.883  16.032  -9.843  0.50 18.95          SE  
ATOM    932  CE  MET   111      32.747  15.837 -10.220  0.50 15.17           C  
ATOM    934  N   ALA   112      26.884  17.494 -13.540  1.00 25.44           N  
ATOM    935  CA  ALA   112      25.427  17.512 -13.439  1.00 26.76           C  
ATOM    936  C   ALA   112      24.818  16.790 -14.647  1.00 27.56           C  
ATOM    937  O   ALA   112      24.077  15.821 -14.486  1.00 27.10           O  
ATOM    938  CB  ALA   112      24.911  18.932 -13.376  1.00 26.49           C  
ATOM    939  N   LYS   113      25.139  17.300 -15.834  1.00 29.94           N  
ATOM    940  CA  LYS   113      24.723  16.725 -17.128  1.00 31.32           C  
ATOM    941  C   LYS   113      24.909  15.206 -17.140  1.00 31.81           C  
ATOM    942  O   LYS   113      23.985  14.460 -17.480  1.00 32.12           O  
ATOM    943  CB  LYS   113      25.496  17.434 -18.269  1.00 32.12           C  
ATOM    944  CG  LYS   113      25.539  16.786 -19.681  1.00 32.56           C  
ATOM    945  CD  LYS   113      24.177  16.663 -20.371  1.00 37.78           C  
ATOM    946  CE  LYS   113      24.235  15.605 -21.499  1.00 38.53           C  
ATOM    947  NZ  LYS   113      22.973  14.790 -21.585  1.00 41.24           N  
ATOM    948  N   ALA   114      26.094  14.753 -16.737  1.00 32.76           N  
ATOM    949  CA  ALA   114      26.410  13.322 -16.690  1.00 33.68           C  
ATOM    950  C   ALA   114      25.518  12.546 -15.725  1.00 34.47           C  
ATOM    951  O   ALA   114      25.190  11.380 -15.980  1.00 34.78           O  
ATOM    952  CB  ALA   114      27.859  13.111 -16.338  1.00 33.77           C  
ATOM    953  N   ALA   115      25.130  13.181 -14.617  1.00 34.82           N  
ATOM    954  CA  ALA   115      24.253  12.533 -13.633  1.00 35.21           C  
ATOM    955  C   ALA   115      22.772  12.575 -14.030  1.00 35.51           C  
ATOM    956  O   ALA   115      21.914  12.092 -13.291  1.00 35.77           O  
ATOM    957  CB  ALA   115      24.458  13.149 -12.245  1.00 35.54           C  
ATOM    958  N   ARG   116      22.485  13.151 -15.197  1.00 35.81           N  
ATOM    959  CA  ARG   116      21.116  13.413 -15.664  1.00 36.57           C  
ATOM    960  C   ARG   116      20.358  14.336 -14.703  1.00 35.96           C  
ATOM    961  O   ARG   116      19.173  14.146 -14.421  1.00 35.58           O  
ATOM    962  CB  ARG   116      20.351  12.109 -15.954  1.00 36.76           C  
ATOM    963  CG  ARG   116      20.943  11.282 -17.109  1.00 38.35           C  
ATOM    964  CD  ARG   116      19.941  10.231 -17.616  1.00 39.16           C  
ATOM    965  NE  ARG   116      18.865  10.833 -18.415  1.00 45.58           N  
ATOM    966  CZ  ARG   116      18.722  10.692 -19.735  1.00 47.21           C  
ATOM    967  NH1 ARG   116      17.713  11.292 -20.360  1.00 48.53           N  
ATOM    968  NH2 ARG   116      19.577   9.950 -20.436  1.00 47.82           N  
ATOM    969  N   GLU   117      21.074  15.339 -14.198  1.00 35.11           N  
ATOM    970  CA  GLU   117      20.493  16.359 -13.344  1.00 34.78           C  
ATOM    971  C   GLU   117      20.925  17.749 -13.819  1.00 33.72           C  
ATOM    972  O   GLU   117      21.735  17.874 -14.752  1.00 33.94           O  
ATOM    973  CB  GLU   117      20.900  16.117 -11.888  1.00 34.37           C  
ATOM    974  CG  GLU   117      20.427  14.774 -11.341  1.00 35.31           C  
ATOM    975  CD  GLU   117      20.919  14.515  -9.929  1.00 36.02           C  
ATOM    976  OE1 GLU   117      21.039  15.488  -9.157  1.00 35.32           O  
ATOM    977  OE2 GLU   117      21.184  13.339  -9.586  1.00 39.92           O  
ATOM    978  N   GLU   118      20.361  18.785 -13.204  1.00 32.71           N  
ATOM    979  CA  GLU   118      20.663  20.176 -13.569  1.00 32.59           C  
ATOM    980  C   GLU   118      21.165  20.955 -12.355  1.00 30.03           C  
ATOM    981  O   GLU   118      20.750  20.663 -11.221  1.00 28.44           O  
ATOM    982  CB  GLU   118      19.410  20.892 -14.056  1.00 32.85           C  
ATOM    983  CG  GLU   118      18.594  20.155 -15.100  1.00 35.90           C  
ATOM    984  CD  GLU   118      17.471  21.020 -15.648  1.00 36.89           C  
ATOM    985  OE1 GLU   118      16.623  21.507 -14.845  1.00 42.48           O  
ATOM    986  OE2 GLU   118      17.447  21.218 -16.887  1.00 42.19           O  
ATOM    987  N   CYS   119      22.027  21.946 -12.614  1.00 28.23           N  
ATOM    988  CA  CYS   119      22.452  22.914 -11.593  1.00 26.98           C  
ATOM    989  C   CYS   119      21.342  23.946 -11.462  1.00 25.57           C  
ATOM    990  O   CYS   119      20.665  24.224 -12.462  1.00 25.73           O  
ATOM    991  CB  CYS   119      23.757  23.606 -12.002  1.00 27.45           C  
ATOM    992  SG  CYS   119      25.141  22.472 -12.121  1.00 29.53           S  
ATOM    993  N   PRO   120      21.139  24.523 -10.258  1.00 23.62           N  
ATOM    994  CA  PRO   120      21.849  24.302  -8.974  1.00 21.20           C  
ATOM    995  C   PRO   120      21.369  23.125  -8.124  1.00 20.06           C  
ATOM    996  O   PRO   120      21.936  22.885  -7.060  1.00 17.82           O  
ATOM    997  CB  PRO   120      21.537  25.580  -8.198  1.00 22.04           C  
ATOM    998  CG  PRO   120      20.144  25.948  -8.652  1.00 22.84           C  
ATOM    999  CD  PRO   120      20.095  25.560 -10.125  1.00 23.21           C  
ATOM   1000  N   VAL   121      20.349  22.390  -8.562  1.00 18.45           N  
ATOM   1001  CA  VAL   121      19.870  21.259  -7.749  1.00 17.90           C  
ATOM   1002  C   VAL   121      20.963  20.198  -7.540  1.00 16.37           C  
ATOM   1003  O   VAL   121      21.146  19.687  -6.433  1.00 16.62           O  
ATOM   1004  CB  VAL   121      18.557  20.661  -8.340  1.00 18.55           C  
ATOM   1005  CG1 VAL   121      18.271  19.271  -7.769  1.00 19.26           C  
ATOM   1006  CG2 VAL   121      17.409  21.618  -8.031  1.00 18.36           C  
ATOM   1007  N   PHE   122      21.673  19.872  -8.610  1.00 16.51           N  
ATOM   1008  CA  PHE   122      22.654  18.799  -8.556  1.00 16.39           C  
ATOM   1009  C   PHE   122      23.668  19.052  -7.432  1.00 16.35           C  
ATOM   1010  O   PHE   122      24.175  20.152  -7.316  1.00 15.68           O  
ATOM   1011  CB  PHE   122      23.375  18.677  -9.889  1.00 17.53           C  
ATOM   1012  CG  PHE   122      24.571  17.769  -9.834  1.00 18.38           C  
ATOM   1013  CD1 PHE   122      24.405  16.393  -9.692  1.00 18.85           C  
ATOM   1014  CD2 PHE   122      25.873  18.316  -9.857  1.00 19.32           C  
ATOM   1015  CE1 PHE   122      25.520  15.545  -9.598  1.00 21.40           C  
ATOM   1016  CE2 PHE   122      26.990  17.492  -9.795  1.00 19.08           C  
ATOM   1017  CZ  PHE   122      26.818  16.100  -9.644  1.00 20.67           C  
ATOM   1018  N   THR   123      23.937  18.023  -6.636  1.00 14.58           N  
ATOM   1019  CA  THR   123      24.913  18.081  -5.558  1.00 13.79           C  
ATOM   1020  C   THR   123      26.057  17.091  -5.784  1.00 13.81           C  
ATOM   1021  O   THR   123      25.815  15.882  -5.743  1.00 14.03           O  
ATOM   1022  CB  THR   123      24.210  17.757  -4.229  1.00 13.79           C  
ATOM   1023  OG1 THR   123      23.150  18.714  -4.043  1.00 13.23           O  
ATOM   1024  CG2 THR   123      25.165  17.834  -3.075  1.00 13.37           C  
ATOM   1025  N   PRO   124      27.298  17.598  -5.974  1.00 13.35           N  
ATOM   1026  CA  PRO   124      28.459  16.717  -6.210  1.00 12.91           C  
ATOM   1027  C   PRO   124      28.835  15.980  -4.923  1.00 13.01           C  
ATOM   1028  O   PRO   124      28.407  16.405  -3.816  1.00 12.54           O  
ATOM   1029  CB  PRO   124      29.580  17.679  -6.617  1.00 14.14           C  
ATOM   1030  CG  PRO   124      29.146  19.047  -6.128  1.00 13.45           C  
ATOM   1031  CD  PRO   124      27.650  19.032  -5.972  1.00 12.87           C  
ATOM   1032  N   PRO   125      29.655  14.912  -5.037  1.00 13.44           N  
ATOM   1033  CA  PRO   125      30.187  14.273  -3.846  1.00 13.53           C  
ATOM   1034  C   PRO   125      30.823  15.290  -2.880  1.00 13.16           C  
ATOM   1035  O   PRO   125      31.621  16.109  -3.298  1.00 12.44           O  
ATOM   1036  CB  PRO   125      31.230  13.295  -4.423  1.00 14.24           C  
ATOM   1037  CG  PRO   125      30.673  12.977  -5.804  1.00 15.16           C  
ATOM   1038  CD  PRO   125      30.160  14.294  -6.276  1.00 14.35           C  
ATOM   1039  N   GLY   126      30.452  15.221  -1.600  1.00 13.37           N  
ATOM   1040  CA  GLY   126      30.991  16.124  -0.568  1.00 12.38           C  
ATOM   1041  C   GLY   126      30.260  17.469  -0.494  1.00 12.55           C  
ATOM   1042  O   GLY   126      30.558  18.265   0.386  1.00 14.16           O  
ATOM   1043  N   GLY   127      29.307  17.701  -1.375  1.00 12.12           N  
ATOM   1044  CA  GLY   127      28.544  18.974  -1.397  1.00 11.03           C  
ATOM   1045  C   GLY   127      27.258  18.895  -0.603  1.00 12.16           C  
ATOM   1046  O   GLY   127      26.846  17.783  -0.121  1.00 11.11           O  
ATOM   1047  N   GLU   128      26.644  20.072  -0.380  1.00 11.01           N  
ATOM   1048  CA  GLU   128      25.330  20.188   0.289  1.00 11.89           C  
ATOM   1049  C   GLU   128      24.229  20.326  -0.747  1.00 11.34           C  
ATOM   1050  O   GLU   128      24.424  20.983  -1.790  1.00 12.25           O  
ATOM   1051  CB  GLU   128      25.265  21.460   1.176  1.00 11.43           C  
ATOM   1052  CG  GLU   128      26.020  21.334   2.516  1.00 11.16           C  
ATOM   1053  CD  GLU   128      26.067  22.656   3.250  1.00 14.31           C  
ATOM   1054  OE1 GLU   128      26.553  23.629   2.649  1.00 12.14           O  
ATOM   1055  OE2 GLU   128      25.672  22.695   4.437  1.00 17.34           O  
ATOM   1056  N   THR   129      23.055  19.755  -0.451  1.00 11.74           N  
ATOM   1057  CA  THR   129      21.827  19.964  -1.236  1.00 11.64           C  
ATOM   1058  C   THR   129      21.280  21.373  -0.977  1.00 11.58           C  
ATOM   1059  O   THR   129      21.643  21.995   0.050  1.00 10.25           O  
ATOM   1060  CB  THR   129      20.719  18.950  -0.876  1.00 12.61           C  
ATOM   1061  OG1 THR   129      20.353  19.146   0.536  1.00 14.75           O  
ATOM   1062  CG2 THR   129      21.286  17.516  -0.977  1.00 15.54           C  
ATOM   1063  N   LEU   130      20.437  21.862  -1.904  1.00 11.52           N  
ATOM   1064  CA  LEU   130      19.738  23.143  -1.676  1.00 12.31           C  
ATOM   1065  C   LEU   130      18.949  23.100  -0.380  1.00 12.77           C  
ATOM   1066  O   LEU   130      18.929  24.072   0.332  1.00 10.77           O  
ATOM   1067  CB  LEU   130      18.831  23.525  -2.852  1.00 13.53           C  
ATOM   1068  CG  LEU   130      19.595  23.847  -4.142  1.00 14.68           C  
ATOM   1069  CD1 LEU   130      18.645  24.060  -5.326  1.00 17.49           C  
ATOM   1070  CD2 LEU   130      20.532  25.046  -3.947  1.00 18.17           C  
ATOM   1071  N   ASP   131      18.345  21.964  -0.042  1.00 12.80           N  
ATOM   1072  CA  ASP   131      17.546  21.916   1.175  1.00 13.89           C  
ATOM   1073  C   ASP   131      18.433  21.950   2.421  1.00 13.08           C  
ATOM   1074  O   ASP   131      18.056  22.543   3.433  1.00 12.35           O  
ATOM   1075  CB  ASP   131      16.610  20.690   1.175  1.00 15.29           C  
ATOM   1076  CG  ASP   131      15.323  20.920   0.350  1.00 19.19           C  
ATOM   1077  OD1 ASP   131      14.896  22.070   0.066  1.00 24.81           O  
ATOM   1078  OD2 ASP   131      14.735  19.904  -0.020  1.00 27.72           O  
ATOM   1079  N   GLN   132      19.621  21.349   2.346  1.00 12.26           N  
ATOM   1080  CA  GLN   132      20.561  21.450   3.443  1.00 11.76           C  
ATOM   1081  C   GLN   132      21.019  22.912   3.650  1.00 11.28           C  
ATOM   1082  O   GLN   132      21.130  23.390   4.812  1.00  9.47           O  
ATOM   1083  CB  GLN   132      21.777  20.566   3.167  1.00 12.20           C  
ATOM   1084  CG  GLN   132      21.508  19.091   3.488  1.00 15.13           C  
ATOM   1085  CD  GLN   132      22.679  18.210   3.078  1.00 18.85           C  
ATOM   1086  OE1 GLN   132      23.201  18.338   1.971  1.00 16.27           O  
ATOM   1087  NE2 GLN   132      23.110  17.325   3.991  1.00 23.69           N  
ATOM   1088  N   VAL   133      21.279  23.616   2.550  1.00  9.48           N  
ATOM   1089  CA  VAL   133      21.651  25.041   2.659  1.00  9.49           C  
ATOM   1090  C   VAL   133      20.518  25.854   3.282  1.00  9.92           C  
ATOM   1091  O   VAL   133      20.744  26.611   4.228  1.00  9.67           O  
ATOM   1092  CB  VAL   133      22.038  25.636   1.275  1.00 10.42           C  
ATOM   1093  CG1 VAL   133      22.439  27.068   1.402  1.00 10.99           C  
ATOM   1094  CG2 VAL   133      23.237  24.856   0.663  1.00  9.59           C  
ATOM   1095  N   LYS   134      19.309  25.698   2.754  1.00 10.05           N  
ATOM   1096  CA  LYS   134      18.129  26.384   3.308  1.00 10.95           C  
ATOM   1097  C   LYS   134      17.980  26.086   4.795  1.00 11.05           C  
ATOM   1098  O   LYS   134      17.592  26.959   5.566  1.00  9.92           O  
ATOM   1099  CB  LYS   134      16.856  25.966   2.585  1.00 10.96           C  
ATOM   1100  CG  LYS   134      15.648  26.772   3.054  1.00 13.28           C  
ATOM   1101  CD  LYS   134      14.331  26.418   2.340  1.00 15.14           C  
ATOM   1102  CE  LYS   134      14.135  27.178   1.071  1.00 19.20           C  
ATOM   1103  NZ  LYS   134      12.763  26.837   0.546  1.00 22.40           N  
ATOM   1104  N   MET   135      18.239  24.845   5.204  1.00  9.06           N  
ATOM   1105  CA  MET   135      18.044  24.514   6.621  1.00 11.12           C  
ATOM   1106  C   MET   135      19.006  25.323   7.494  1.00 10.30           C  
ATOM   1107  O   MET   135      18.621  25.789   8.531  1.00 10.53           O  
ATOM   1108  CB  MET   135      18.138  22.983   6.830  1.00 11.96           C  
ATOM   1109  CG  MET   135      17.896  22.479   8.257  1.00 13.35           C  
ATOM   1110  SD  MET   135      16.066  22.913   8.811  1.00 15.75          SE  
ATOM   1111  CE  MET   135      16.394  24.116  10.229  1.00 19.57           C  
ATOM   1112  N   ARG   136      20.245  25.528   7.042  1.00  9.96           N  
ATOM   1113  CA  ARG   136      21.207  26.423   7.733  1.00  9.44           C  
ATOM   1114  C   ARG   136      20.721  27.874   7.792  1.00 10.34           C  
ATOM   1115  O   ARG   136      20.948  28.566   8.776  1.00 11.05           O  
ATOM   1116  CB  ARG   136      22.596  26.348   7.102  1.00  8.92           C  
ATOM   1117  CG  ARG   136      23.220  24.964   7.297  1.00 10.88           C  
ATOM   1118  CD  ARG   136      24.692  25.051   7.080  1.00 10.58           C  
ATOM   1119  NE  ARG   136      25.105  25.173   5.661  1.00  9.48           N  
ATOM   1120  CZ  ARG   136      25.618  26.262   5.081  1.00 10.08           C  
ATOM   1121  NH1 ARG   136      25.626  27.455   5.692  1.00  9.95           N  
ATOM   1122  NH2 ARG   136      26.066  26.169   3.812  1.00  9.85           N  
ATOM   1123  N   GLY   137      19.974  28.275   6.763  1.00  9.12           N  
ATOM   1124  CA  GLY   137      19.362  29.616   6.694  1.00 10.59           C  
ATOM   1125  C   GLY   137      18.235  29.727   7.721  1.00 10.98           C  
ATOM   1126  O   GLY   137      18.143  30.735   8.466  1.00 10.49           O  
ATOM   1127  N   ILE   138      17.365  28.706   7.739  1.00 10.10           N  
ATOM   1128  CA  ILE   138      16.271  28.625   8.740  1.00  9.94           C  
ATOM   1129  C   ILE   138      16.838  28.634  10.204  1.00 10.47           C  
ATOM   1130  O   ILE   138      16.357  29.367  11.071  1.00 10.30           O  
ATOM   1131  CB  ILE   138      15.379  27.383   8.485  1.00  9.63           C  
ATOM   1132  CG1 ILE   138      14.688  27.518   7.103  1.00  9.46           C  
ATOM   1133  CG2 ILE   138      14.331  27.262   9.586  1.00 12.67           C  
ATOM   1134  CD1 ILE   138      13.942  26.227   6.728  1.00 10.38           C  
ATOM   1135  N   ASP   139      17.871  27.827  10.446  1.00 10.75           N  
ATOM   1136  CA  ASP   139      18.523  27.719  11.751  1.00 12.25           C  
ATOM   1137  C   ASP   139      19.051  29.087  12.177  1.00 11.78           C  
ATOM   1138  O   ASP   139      18.744  29.575  13.280  1.00 12.04           O  
ATOM   1139  CB  ASP   139      19.665  26.694  11.614  1.00 12.31           C  
ATOM   1140  CG  ASP   139      20.421  26.416  12.931  1.00 17.51           C  
ATOM   1141  OD1 ASP   139      20.224  27.111  13.931  1.00 23.55           O  
ATOM   1142  OD2 ASP   139      21.267  25.482  12.918  1.00 23.53           O  
ATOM   1143  N   PHE   140      19.828  29.719  11.300  1.00 10.99           N  
ATOM   1144  CA  PHE   140      20.375  31.032  11.623  1.00 11.07           C  
ATOM   1145  C   PHE   140      19.255  32.044  11.868  1.00 10.71           C  
ATOM   1146  O   PHE   140      19.280  32.819  12.844  1.00 11.15           O  
ATOM   1147  CB  PHE   140      21.308  31.564  10.533  1.00 10.66           C  
ATOM   1148  CG  PHE   140      21.842  32.928  10.882  1.00 11.12           C  
ATOM   1149  CD1 PHE   140      22.879  33.030  11.802  1.00 13.72           C  
ATOM   1150  CD2 PHE   140      21.241  34.092  10.383  1.00 11.20           C  
ATOM   1151  CE1 PHE   140      23.358  34.277  12.190  1.00 13.44           C  
ATOM   1152  CE2 PHE   140      21.724  35.384  10.768  1.00 11.43           C  
ATOM   1153  CZ  PHE   140      22.778  35.452  11.680  1.00 13.56           C  
ATOM   1154  N   PHE   141      18.275  32.061  10.961  1.00  9.26           N  
ATOM   1155  CA  PHE   141      17.192  33.042  11.078  1.00  9.67           C  
ATOM   1156  C   PHE   141      16.396  32.886  12.391  1.00  9.64           C  
ATOM   1157  O   PHE   141      16.073  33.884  13.054  1.00 10.41           O  
ATOM   1158  CB  PHE   141      16.224  32.908   9.897  1.00  9.66           C  
ATOM   1159  CG  PHE   141      15.129  33.941   9.915  1.00 10.69           C  
ATOM   1160  CD1 PHE   141      15.453  35.288   9.712  1.00 11.03           C  
ATOM   1161  CD2 PHE   141      13.787  33.576  10.129  1.00 13.04           C  
ATOM   1162  CE1 PHE   141      14.439  36.279   9.718  1.00 13.41           C  
ATOM   1163  CE2 PHE   141      12.752  34.558  10.131  1.00 12.72           C  
ATOM   1164  CZ  PHE   141      13.090  35.911   9.934  1.00 12.61           C  
ATOM   1165  N   GLU   142      16.056  31.654  12.739  1.00 10.90           N  
ATOM   1166  CA  GLU   142      15.343  31.419  14.018  1.00 12.50           C  
ATOM   1167  C   GLU   142      16.180  31.860  15.208  1.00 12.76           C  
ATOM   1168  O   GLU   142      15.645  32.512  16.144  1.00 12.86           O  
ATOM   1169  CB  GLU   142      14.956  29.948  14.133  1.00 14.29           C  
ATOM   1170  CG  GLU   142      13.950  29.649  13.002  1.00 18.51           C  
ATOM   1171  CD  GLU   142      13.206  28.339  13.106  1.00 26.10           C  
ATOM   1172  OE1 GLU   142      12.074  28.285  12.548  1.00 26.39           O  
ATOM   1173  OE2 GLU   142      13.733  27.380  13.716  1.00 30.36           O  
ATOM   1174  N   PHE   143      17.468  31.490  15.178  1.00 11.64           N  
ATOM   1175  CA  PHE   143      18.452  31.988  16.154  1.00 12.86           C  
ATOM   1176  C   PHE   143      18.407  33.541  16.285  1.00 13.14           C  
ATOM   1177  O   PHE   143      18.296  34.089  17.402  1.00 12.88           O  
ATOM   1178  CB  PHE   143      19.855  31.490  15.793  1.00 14.14           C  
ATOM   1179  CG  PHE   143      20.971  32.331  16.383  1.00 16.21           C  
ATOM   1180  CD1 PHE   143      21.327  32.196  17.723  1.00 19.07           C  
ATOM   1181  CD2 PHE   143      21.602  33.302  15.624  1.00 15.91           C  
ATOM   1182  CE1 PHE   143      22.348  32.991  18.271  1.00 20.54           C  
ATOM   1183  CE2 PHE   143      22.596  34.111  16.160  1.00 20.18           C  
ATOM   1184  CZ  PHE   143      22.977  33.955  17.484  1.00 17.61           C  
ATOM   1185  N   LEU   144      18.513  34.228  15.153  1.00 11.11           N  
ATOM   1186  CA  LEU   144      18.529  35.689  15.110  1.00 11.52           C  
ATOM   1187  C   LEU   144      17.234  36.287  15.704  1.00 11.63           C  
ATOM   1188  O   LEU   144      17.280  37.194  16.562  1.00 12.63           O  
ATOM   1189  CB  LEU   144      18.725  36.173  13.658  1.00 10.82           C  
ATOM   1190  CG  LEU   144      18.846  37.697  13.477  1.00 11.37           C  
ATOM   1191  CD1 LEU   144      20.007  38.293  14.264  1.00 14.98           C  
ATOM   1192  CD2 LEU   144      18.998  38.069  11.981  1.00 12.34           C  
ATOM   1193  N   CYS   145      16.089  35.738  15.280  1.00 11.54           N  
ATOM   1194  CA  CYS   145      14.771  36.188  15.771  1.00 12.26           C  
ATOM   1195  C   CYS   145      14.670  36.081  17.292  1.00 13.44           C  
ATOM   1196  O   CYS   145      14.323  37.070  17.943  1.00 13.67           O  
ATOM   1197  CB  CYS   145      13.644  35.406  15.096  1.00 12.21           C  
ATOM   1198  SG  CYS   145      13.463  35.951  13.328  1.00 14.79           S  
ATOM   1199  N   GLN   146      15.007  34.920  17.837  1.00 13.71           N  
ATOM   1200  CA  GLN   146      15.004  34.707  19.294  1.00 15.59           C  
ATOM   1201  C   GLN   146      15.946  35.663  20.006  1.00 15.93           C  
ATOM   1202  O   GLN   146      15.580  36.240  21.051  1.00 15.40           O  
ATOM   1203  CB  GLN   146      15.332  33.252  19.635  1.00 16.45           C  
ATOM   1204  CG  GLN   146      14.186  32.288  19.241  1.00 22.14           C  
ATOM   1205  CD  GLN   146      12.874  32.640  19.971  1.00 29.71           C  
ATOM   1206  OE1 GLN   146      12.777  32.509  21.201  1.00 32.44           O  
ATOM   1207  NE2 GLN   146      11.882  33.131  19.216  1.00 32.00           N  
ATOM   1208  N   LEU   147      17.138  35.859  19.428  1.00 15.37           N  
ATOM   1209  CA  LEU   147      18.154  36.782  19.976  1.00 15.16           C  
ATOM   1210  C   LEU   147      17.588  38.202  20.161  1.00 15.14           C  
ATOM   1211  O   LEU   147      17.635  38.785  21.258  1.00 15.30           O  
ATOM   1212  CB  LEU   147      19.390  36.799  19.053  1.00 14.58           C  
ATOM   1213  CG  LEU   147      20.477  37.750  19.578  1.00 18.48           C  
ATOM   1214  CD1 LEU   147      21.277  37.026  20.669  1.00 24.94           C  
ATOM   1215  CD2 LEU   147      21.391  38.217  18.509  1.00 21.05           C  
ATOM   1216  N   ILE   148      17.013  38.730  19.088  1.00 13.47           N  
ATOM   1217  CA  ILE   148      16.472  40.085  19.047  1.00 13.77           C  
ATOM   1218  C   ILE   148      15.277  40.239  19.987  1.00 13.26           C  
ATOM   1219  O   ILE   148      15.188  41.254  20.716  1.00 13.49           O  
ATOM   1220  CB  ILE   148      16.083  40.484  17.599  1.00 13.22           C  
ATOM   1221  CG1 ILE   148      17.315  40.531  16.688  1.00 12.36           C  
ATOM   1222  CG2 ILE   148      15.325  41.837  17.556  1.00 15.01           C  
ATOM   1223  CD1 ILE   148      18.530  41.337  17.225  1.00 14.76           C  
ATOM   1224  N   LEU   149      14.378  39.253  19.981  1.00 13.33           N  
ATOM   1225  CA  LEU   149      13.166  39.304  20.851  1.00 12.70           C  
ATOM   1226  C   LEU   149      13.587  39.302  22.328  1.00 13.92           C  
ATOM   1227  O   LEU   149      13.110  40.134  23.119  1.00 13.08           O  
ATOM   1228  CB  LEU   149      12.228  38.132  20.556  1.00 13.22           C  
ATOM   1229  CG  LEU   149      11.562  38.284  19.170  1.00 11.59           C  
ATOM   1230  CD1 LEU   149      10.787  36.997  18.820  1.00 14.38           C  
ATOM   1231  CD2 LEU   149      10.627  39.515  19.141  1.00 16.20           C  
ATOM   1232  N   LYS   150      14.521  38.415  22.660  1.00 13.32           N  
ATOM   1233  CA  LYS   150      15.031  38.306  24.051  1.00 15.01           C  
ATOM   1234  C   LYS   150      15.770  39.578  24.495  1.00 15.41           C  
ATOM   1235  O   LYS   150      15.614  40.042  25.647  1.00 15.91           O  
ATOM   1236  CB  LYS   150      15.924  37.077  24.192  1.00 15.61           C  
ATOM   1237  CG  LYS   150      15.172  35.781  24.225  1.00 18.33           C  
ATOM   1238  CD  LYS   150      16.140  34.636  24.225  1.00 22.37           C  
ATOM   1239  CE  LYS   150      15.405  33.333  24.046  1.00 29.21           C  
ATOM   1240  NZ  LYS   150      15.119  32.732  25.380  1.00 34.01           N  
ATOM   1241  N   GLU   151      16.566  40.159  23.600  1.00 16.59           N  
ATOM   1242  CA  GLU   151      17.236  41.421  23.903  1.00 18.62           C  
ATOM   1243  C   GLU   151      16.242  42.543  24.094  1.00 18.93           C  
ATOM   1244  O   GLU   151      16.381  43.320  25.036  1.00 19.86           O  
ATOM   1245  CB  GLU   151      18.279  41.783  22.826  1.00 18.64           C  
ATOM   1246  CG  GLU   151      19.491  40.830  22.871  1.00 20.23           C  
ATOM   1247  CD  GLU   151      20.613  41.209  21.915  1.00 21.22           C  
ATOM   1248  OE1 GLU   151      20.429  42.127  21.092  1.00 26.24           O  
ATOM   1249  OE2 GLU   151      21.676  40.557  21.971  1.00 24.90           O  
ATOM   1250  N   ALA   152      15.231  42.625  23.220  1.00 19.10           N  
ATOM   1251  CA  ALA   152      14.172  43.629  23.369  1.00 19.49           C  
ATOM   1252  C   ALA   152      13.473  43.445  24.730  1.00 19.77           C  
ATOM   1253  O   ALA   152      13.114  44.432  25.390  1.00 19.86           O  
ATOM   1254  CB  ALA   152      13.159  43.526  22.252  1.00 20.37           C  
ATOM   1255  N   ASP   153      13.259  42.188  25.112  1.00 19.41           N  
ATOM   1256  CA  ASP   153      12.605  41.850  26.380  1.00 21.62           C  
ATOM   1257  C   ASP   153      13.466  42.281  27.569  1.00 23.56           C  
ATOM   1258  O   ASP   153      12.959  42.809  28.560  1.00 23.49           O  
ATOM   1259  CB  ASP   153      12.369  40.338  26.494  1.00 20.56           C  
ATOM   1260  CG  ASP   153      11.495  39.982  27.680  1.00 19.09           C  
ATOM   1261  OD1 ASP   153      10.349  40.462  27.714  1.00 21.16           O  
ATOM   1262  OD2 ASP   153      11.962  39.243  28.563  1.00 19.70           O  
ATOM   1263  N   GLN   154      14.763  42.012  27.472  1.00 26.71           N  
ATOM   1264  CA  GLN   154      15.697  42.277  28.574  1.00 30.61           C  
ATOM   1265  C   GLN   154      16.002  43.776  28.747  1.00 32.44           C  
ATOM   1266  O   GLN   154      16.568  44.176  29.779  1.00 34.00           O  
ATOM   1267  CB  GLN   154      16.979  41.429  28.444  1.00 30.79           C  
ATOM   1268  CG  GLN   154      16.770  39.895  28.461  1.00 33.07           C  
ATOM   1269  CD  GLN   154      16.043  39.367  29.699  1.00 37.37           C  
ATOM   1270  OE1 GLN   154      16.550  39.443  30.823  1.00 39.46           O  
ATOM   1271  NE2 GLN   154      14.846  38.807  29.487  1.00 40.42           N  
ATOM   1272  N   LYS   155      15.587  44.612  27.785  1.00 34.64           N  
ATOM   1273  CA  LYS   155      15.755  46.085  27.881  1.00 36.26           C  
ATOM   1274  C   LYS   155      14.446  46.864  28.024  1.00 36.17           C  
ATOM   1275  O   LYS   155      13.360  46.298  28.201  1.00 37.58           O  
ATOM   1276  CB  LYS   155      16.523  46.682  26.678  1.00 36.32           C  
ATOM   1277  CG  LYS   155      17.355  45.733  25.836  1.00 39.40           C  
ATOM   1278  CD  LYS   155      18.806  45.627  26.267  1.00 40.09           C  
ATOM   1279  CE  LYS   155      19.565  44.727  25.301  1.00 43.03           C  
ATOM   1280  NZ  LYS   155      19.928  45.384  24.002  1.00 43.48           N  
ATOM   1281  N   ASN   165      12.474  55.446  15.912  1.00 41.07           N  
ATOM   1282  CA  ASN   165      12.786  56.233  14.721  1.00 40.86           C  
ATOM   1283  C   ASN   165      14.225  56.117  14.260  1.00 39.46           C  
ATOM   1284  O   ASN   165      14.474  55.926  13.065  1.00 39.76           O  
ATOM   1285  CB  ASN   165      12.495  57.726  14.953  1.00 41.56           C  
ATOM   1286  CG  ASN   165      11.019  58.026  15.088  1.00 43.79           C  
ATOM   1287  OD1 ASN   165      10.175  57.371  14.470  1.00 47.63           O  
ATOM   1288  ND2 ASN   165      10.696  59.042  15.885  1.00 46.17           N  
ATOM   1289  N   CYS   166      15.149  56.242  15.216  1.00 37.98           N  
ATOM   1290  CA  CYS   166      16.580  56.379  14.945  0.50 36.88           C  
ATOM   1292  C   CYS   166      17.170  55.327  13.986  1.00 36.05           C  
ATOM   1293  O   CYS   166      17.921  55.653  13.041  1.00 35.95           O  
ATOM   1294  CB  CYS   166      17.329  56.360  16.274  0.50 37.09           C  
ATOM   1296  SG  CYS   166      19.092  56.519  16.131  0.50 38.12           S  
ATOM   1298  N   LEU   167      16.844  54.063  14.232  1.00 33.59           N  
ATOM   1299  CA  LEU   167      17.349  52.984  13.376  1.00 30.89           C  
ATOM   1300  C   LEU   167      16.723  53.022  11.973  1.00 29.85           C  
ATOM   1301  O   LEU   167      17.438  52.862  10.974  1.00 28.15           O  
ATOM   1302  CB  LEU   167      17.144  51.623  14.043  1.00 29.90           C  
ATOM   1303  CG  LEU   167      17.722  51.341  15.434  1.00 29.69           C  
ATOM   1304  CD1 LEU   167      17.442  49.901  15.841  1.00 27.15           C  
ATOM   1305  CD2 LEU   167      19.210  51.625  15.503  1.00 27.72           C  
ATOM   1306  N   GLU   168      15.405  53.265  11.905  1.00 28.65           N  
ATOM   1307  CA  GLU   168      14.659  53.300  10.634  1.00 28.93           C  
ATOM   1308  C   GLU   168      15.057  54.494   9.758  1.00 27.44           C  
ATOM   1309  O   GLU   168      15.255  54.348   8.551  1.00 27.06           O  
ATOM   1310  CB  GLU   168      13.141  53.301  10.891  1.00 29.00           C  
ATOM   1311  CG  GLU   168      12.255  53.014   9.660  1.00 30.98           C  
ATOM   1312  CD  GLU   168      10.935  52.292  10.007  1.00 32.01           C  
ATOM   1313  OE1 GLU   168      10.464  52.369  11.172  1.00 35.69           O  
ATOM   1314  OE2 GLU   168      10.375  51.617   9.112  1.00 36.97           O  
ATOM   1315  N   THR   169      15.176  55.673  10.373  1.00 27.30           N  
ATOM   1316  CA  THR   169      15.520  56.891   9.635  1.00 27.25           C  
ATOM   1317  C   THR   169      16.842  56.760   8.882  1.00 26.37           C  
ATOM   1318  O   THR   169      16.923  57.137   7.709  1.00 26.91           O  
ATOM   1319  CB  THR   169      15.510  58.168  10.544  1.00 27.66           C  
ATOM   1320  OG1 THR   169      16.549  58.072  11.523  1.00 29.75           O  
ATOM   1321  CG2 THR   169      14.185  58.297  11.260  1.00 27.52           C  
ATOM   1322  N   SER   170      17.848  56.182   9.535  1.00 26.61           N  
ATOM   1323  CA  SER   170      19.174  56.002   8.917  1.00 26.93           C  
ATOM   1324  C   SER   170      19.123  55.010   7.750  1.00 26.69           C  
ATOM   1325  O   SER   170      19.792  55.208   6.740  1.00 27.67           O  
ATOM   1326  CB  SER   170      20.248  55.639   9.958  1.00 27.25           C  
ATOM   1327  OG  SER   170      20.071  54.353  10.510  1.00 28.32           O  
ATOM   1328  N   LEU   171      18.305  53.966   7.868  1.00 26.17           N  
ATOM   1329  CA  LEU   171      18.040  53.090   6.720  1.00 25.72           C  
ATOM   1330  C   LEU   171      17.287  53.802   5.580  1.00 26.04           C  
ATOM   1331  O   LEU   171      17.639  53.648   4.407  1.00 25.52           O  
ATOM   1332  CB  LEU   171      17.298  51.821   7.156  1.00 25.40           C  
ATOM   1333  CG  LEU   171      18.092  50.830   8.015  1.00 24.74           C  
ATOM   1334  CD1 LEU   171      17.136  49.817   8.632  1.00 23.70           C  
ATOM   1335  CD2 LEU   171      19.200  50.144   7.186  1.00 22.15           C  
ATOM   1336  N   ALA   172      16.256  54.588   5.927  1.00 26.86           N  
ATOM   1337  CA  ALA   172      15.388  55.251   4.933  1.00 27.07           C  
ATOM   1338  C   ALA   172      16.132  56.273   4.070  1.00 27.99           C  
ATOM   1339  O   ALA   172      15.687  56.601   2.959  1.00 28.28           O  
ATOM   1340  CB  ALA   172      14.173  55.917   5.628  1.00 26.59           C  
ATOM   1341  N   GLU   173      17.268  56.735   4.592  1.00 28.87           N  
ATOM   1342  CA  GLU   173      18.192  57.649   3.923  1.00 31.20           C  
ATOM   1343  C   GLU   173      18.737  57.100   2.610  1.00 30.70           C  
ATOM   1344  O   GLU   173      19.006  57.862   1.683  1.00 30.82           O  
ATOM   1345  CB  GLU   173      19.397  57.907   4.827  1.00 31.14           C  
ATOM   1346  CG  GLU   173      19.240  59.056   5.812  1.00 33.97           C  
ATOM   1347  CD  GLU   173      20.443  59.217   6.735  1.00 34.81           C  
ATOM   1348  OE1 GLU   173      21.599  58.949   6.305  1.00 37.15           O  
ATOM   1349  OE2 GLU   173      20.223  59.620   7.912  1.00 40.87           O  
ATOM   1350  N   ILE   174      18.937  55.779   2.550  1.00 29.59           N  
ATOM   1351  CA  ILE   174      19.664  55.177   1.444  1.00 28.75           C  
ATOM   1352  C   ILE   174      18.945  53.993   0.816  1.00 27.96           C  
ATOM   1353  O   ILE   174      19.270  53.604  -0.303  1.00 28.16           O  
ATOM   1354  CB  ILE   174      21.095  54.747   1.855  1.00 28.85           C  
ATOM   1355  CG1 ILE   174      21.047  53.714   2.996  1.00 28.35           C  
ATOM   1356  CG2 ILE   174      21.951  55.980   2.220  1.00 28.66           C  
ATOM   1357  CD1 ILE   174      22.382  53.050   3.268  1.00 28.84           C  
ATOM   1358  N   PHE   175      17.976  53.438   1.545  1.00 27.25           N  
ATOM   1359  CA  PHE   175      17.154  52.313   1.089  1.00 27.16           C  
ATOM   1360  C   PHE   175      15.712  52.748   0.844  1.00 27.96           C  
ATOM   1361  O   PHE   175      15.198  53.589   1.591  1.00 28.32           O  
ATOM   1362  CB  PHE   175      17.148  51.197   2.138  1.00 25.39           C  
ATOM   1363  CG  PHE   175      18.448  50.476   2.254  1.00 25.02           C  
ATOM   1364  CD1 PHE   175      19.000  49.831   1.144  1.00 22.62           C  
ATOM   1365  CD2 PHE   175      19.138  50.455   3.463  1.00 23.11           C  
ATOM   1366  CE1 PHE   175      20.233  49.168   1.253  1.00 22.60           C  
ATOM   1367  CE2 PHE   175      20.371  49.793   3.582  1.00 23.59           C  
ATOM   1368  CZ  PHE   175      20.907  49.145   2.472  1.00 22.09           C  
ATOM   1369  N   PRO   176      15.042  52.144  -0.159  1.00 28.92           N  
ATOM   1370  CA  PRO   176      13.659  52.519  -0.523  1.00 29.85           C  
ATOM   1371  C   PRO   176      12.546  52.111   0.472  1.00 30.23           C  
ATOM   1372  O   PRO   176      11.619  51.369   0.120  1.00 29.89           O  
ATOM   1373  CB  PRO   176      13.460  51.839  -1.879  1.00 29.67           C  
ATOM   1374  CG  PRO   176      14.364  50.658  -1.842  1.00 29.69           C  
ATOM   1375  CD  PRO   176      15.559  51.076  -1.037  1.00 29.70           C  
ATOM   1376  N   LEU   177      12.649  52.594   1.702  1.00 31.32           N  
ATOM   1377  CA  LEU   177      11.584  52.454   2.669  1.00 32.99           C  
ATOM   1378  C   LEU   177      10.558  53.566   2.434  1.00 34.01           C  
ATOM   1379  O   LEU   177       9.364  53.292   2.296  1.00 35.48           O  
ATOM   1380  CB  LEU   177      12.135  52.570   4.085  1.00 33.09           C  
ATOM   1381  CG  LEU   177      12.901  51.402   4.709  1.00 33.87           C  
ATOM   1382  CD1 LEU   177      13.626  51.910   5.929  1.00 35.29           C  
ATOM   1383  CD2 LEU   177      11.974  50.264   5.097  1.00 34.86           C  
ATOM   1384  N   ILE   191       3.939  49.630  13.570  1.00 39.51           N  
ATOM   1385  CA  ILE   191       3.880  50.674  14.609  1.00 39.47           C  
ATOM   1386  C   ILE   191       5.049  50.664  15.620  1.00 38.14           C  
ATOM   1387  O   ILE   191       5.580  51.740  15.924  1.00 37.87           O  
ATOM   1388  CB  ILE   191       2.462  50.789  15.328  1.00 39.29           C  
ATOM   1389  CG1 ILE   191       2.433  51.996  16.290  1.00 40.74           C  
ATOM   1390  CG2 ILE   191       2.038  49.463  16.001  1.00 40.80           C  
ATOM   1391  CD1 ILE   191       1.296  52.006  17.340  1.00 40.39           C  
ATOM   1392  N   PRO   192       5.482  49.463  16.109  1.00 37.22           N  
ATOM   1393  CA  PRO   192       6.645  49.479  17.014  1.00 35.79           C  
ATOM   1394  C   PRO   192       7.866  50.047  16.289  1.00 34.05           C  
ATOM   1395  O   PRO   192       8.092  49.699  15.126  1.00 34.00           O  
ATOM   1396  CB  PRO   192       6.894  47.986  17.313  1.00 35.96           C  
ATOM   1397  CG  PRO   192       5.638  47.306  17.007  1.00 36.88           C  
ATOM   1398  CD  PRO   192       5.026  48.079  15.861  1.00 37.57           C  
ATOM   1399  N   GLY   193       8.628  50.919  16.953  1.00 32.00           N  
ATOM   1400  CA  GLY   193       9.924  51.376  16.415  1.00 29.30           C  
ATOM   1401  C   GLY   193      10.830  50.158  16.267  1.00 26.86           C  
ATOM   1402  O   GLY   193      10.654  49.181  16.991  1.00 27.57           O  
ATOM   1403  N   LEU   194      11.785  50.196  15.335  1.00 25.02           N  
ATOM   1404  CA  LEU   194      12.666  49.029  15.119  1.00 22.05           C  
ATOM   1405  C   LEU   194      13.431  48.669  16.374  1.00 21.47           C  
ATOM   1406  O   LEU   194      14.097  49.519  16.968  1.00 20.52           O  
ATOM   1407  CB  LEU   194      13.667  49.268  13.981  1.00 22.03           C  
ATOM   1408  CG  LEU   194      13.115  49.448  12.567  1.00 21.92           C  
ATOM   1409  CD1 LEU   194      14.218  49.717  11.554  1.00 21.24           C  
ATOM   1410  CD2 LEU   194      12.268  48.216  12.181  1.00 19.60           C  
ATOM   1411  N   ALA   195      13.359  47.408  16.768  1.00 19.34           N  
ATOM   1412  CA  ALA   195      14.067  46.936  17.943  1.00 18.73           C  
ATOM   1413  C   ALA   195      15.570  46.801  17.690  1.00 18.18           C  
ATOM   1414  O   ALA   195      16.388  46.907  18.607  1.00 18.05           O  
ATOM   1415  CB  ALA   195      13.484  45.595  18.409  1.00 18.89           C  
ATOM   1416  N   ALA   196      15.917  46.565  16.437  1.00 16.89           N  
ATOM   1417  CA  ALA   196      17.301  46.288  16.039  1.00 15.01           C  
ATOM   1418  C   ALA   196      17.445  46.486  14.517  1.00 14.33           C  
ATOM   1419  O   ALA   196      16.454  46.568  13.795  1.00 13.96           O  
ATOM   1420  CB  ALA   196      17.727  44.886  16.457  1.00 15.92           C  
ATOM   1421  N   SER   197      18.707  46.610  14.069  1.00 13.64           N  
ATOM   1422  CA  SER   197      19.075  46.758  12.665  1.00 13.45           C  
ATOM   1423  C   SER   197      20.336  45.904  12.511  1.00 13.46           C  
ATOM   1424  O   SER   197      21.446  46.289  12.920  1.00 13.37           O  
ATOM   1425  CB  SER   197      19.358  48.221  12.305  1.00 13.58           C  
ATOM   1426  OG  SER   197      19.622  48.367  10.900  1.00 14.68           O  
ATOM   1427  N   VAL   198      20.138  44.726  11.921  1.00 13.15           N  
ATOM   1428  CA  VAL   198      21.175  43.684  11.893  1.00 13.08           C  
ATOM   1429  C   VAL   198      21.837  43.708  10.520  1.00 13.08           C  
ATOM   1430  O   VAL   198      21.150  43.812   9.488  1.00 13.79           O  
ATOM   1431  CB  VAL   198      20.539  42.297  12.111  1.00 12.94           C  
ATOM   1432  CG1 VAL   198      21.583  41.206  11.969  1.00 13.89           C  
ATOM   1433  CG2 VAL   198      19.785  42.182  13.457  1.00 12.57           C  
ATOM   1434  N   LEU   199      23.165  43.640  10.519  1.00 12.11           N  
ATOM   1435  CA  LEU   199      23.944  43.552   9.280  1.00 11.62           C  
ATOM   1436  C   LEU   199      24.484  42.142   9.161  1.00 11.23           C  
ATOM   1437  O   LEU   199      25.156  41.672  10.058  1.00 11.71           O  
ATOM   1438  CB  LEU   199      25.143  44.520   9.306  1.00 12.31           C  
ATOM   1439  CG  LEU   199      26.104  44.482   8.086  1.00 11.66           C  
ATOM   1440  CD1 LEU   199      25.454  44.717   6.697  1.00 13.39           C  
ATOM   1441  CD2 LEU   199      27.300  45.506   8.317  1.00 12.95           C  
ATOM   1442  N   VAL   200      24.258  41.507   8.006  1.00 10.78           N  
ATOM   1443  CA  VAL   200      24.776  40.120   7.811  1.00  8.76           C  
ATOM   1444  C   VAL   200      25.585  40.101   6.520  1.00  9.38           C  
ATOM   1445  O   VAL   200      25.108  40.550   5.475  1.00 10.10           O  
ATOM   1446  CB  VAL   200      23.609  39.072   7.698  1.00  8.66           C  
ATOM   1447  CG1 VAL   200      24.164  37.703   7.228  1.00  8.33           C  
ATOM   1448  CG2 VAL   200      22.846  38.947   9.017  1.00 10.38           C  
ATOM   1449  N   VAL   201      26.812  39.596   6.594  1.00  9.43           N  
ATOM   1450  CA  VAL   201      27.621  39.452   5.399  1.00  8.97           C  
ATOM   1451  C   VAL   201      27.796  37.959   5.116  1.00  9.62           C  
ATOM   1452  O   VAL   201      28.275  37.211   5.968  1.00  7.86           O  
ATOM   1453  CB  VAL   201      28.996  40.116   5.547  1.00  9.59           C  
ATOM   1454  CG1 VAL   201      29.874  39.759   4.306  1.00  9.68           C  
ATOM   1455  CG2 VAL   201      28.800  41.646   5.700  1.00 11.12           C  
ATOM   1456  N   SER   202      27.426  37.544   3.899  1.00  9.31           N  
ATOM   1457  CA  SER   202      27.409  36.101   3.605  1.00  8.95           C  
ATOM   1458  C   SER   202      27.682  35.867   2.128  1.00  9.16           C  
ATOM   1459  O   SER   202      28.438  36.636   1.488  1.00 10.38           O  
ATOM   1460  CB  SER   202      26.058  35.492   4.096  1.00  8.93           C  
ATOM   1461  OG  SER   202      25.903  34.092   3.831  1.00 10.01           O  
ATOM   1462  N   HIS   203      27.061  34.814   1.570  1.00 10.13           N  
ATOM   1463  CA  HIS   203      27.535  34.249   0.316  1.00  9.52           C  
ATOM   1464  C   HIS   203      26.367  34.086  -0.635  1.00 10.30           C  
ATOM   1465  O   HIS   203      25.216  33.917  -0.171  1.00  9.32           O  
ATOM   1466  CB  HIS   203      28.166  32.852   0.589  1.00  9.59           C  
ATOM   1467  CG  HIS   203      29.341  32.879   1.531  1.00  7.84           C  
ATOM   1468  ND1 HIS   203      30.649  32.959   1.093  1.00  9.11           N  
ATOM   1469  CD2 HIS   203      29.401  32.780   2.882  1.00 10.71           C  
ATOM   1470  CE1 HIS   203      31.465  32.895   2.139  1.00  9.53           C  
ATOM   1471  NE2 HIS   203      30.731  32.788   3.237  1.00  8.48           N  
ATOM   1472  N   GLY   204      26.642  34.041  -1.948  1.00  9.69           N  
ATOM   1473  CA  GLY   204      25.503  34.073  -2.911  1.00  9.75           C  
ATOM   1474  C   GLY   204      24.522  32.906  -2.808  1.00  9.54           C  
ATOM   1475  O   GLY   204      23.329  33.126  -2.661  1.00  9.85           O  
ATOM   1476  N   ALA   205      25.014  31.678  -2.814  1.00  9.62           N  
ATOM   1477  CA  ALA   205      24.075  30.533  -2.842  1.00  8.60           C  
ATOM   1478  C   ALA   205      23.305  30.459  -1.523  1.00  9.84           C  
ATOM   1479  O   ALA   205      22.099  30.182  -1.506  1.00  9.20           O  
ATOM   1480  CB  ALA   205      24.798  29.203  -3.200  1.00 11.04           C  
ATOM   1481  N   TYR   206      24.010  30.687  -0.419  1.00  8.72           N  
ATOM   1482  CA  TYR   206      23.350  30.676   0.884  1.00  8.73           C  
ATOM   1483  C   TYR   206      22.268  31.735   0.959  1.00  8.56           C  
ATOM   1484  O   TYR   206      21.148  31.498   1.465  1.00  8.88           O  
ATOM   1485  CB  TYR   206      24.384  30.938   1.962  1.00  7.66           C  
ATOM   1486  CG  TYR   206      23.785  30.956   3.365  1.00  9.51           C  
ATOM   1487  CD1 TYR   206      23.564  29.772   4.063  1.00  7.24           C  
ATOM   1488  CD2 TYR   206      23.374  32.155   3.961  1.00 10.79           C  
ATOM   1489  CE1 TYR   206      23.034  29.805   5.359  1.00 10.51           C  
ATOM   1490  CE2 TYR   206      22.854  32.198   5.246  1.00 11.50           C  
ATOM   1491  CZ  TYR   206      22.699  31.025   5.941  1.00 10.75           C  
ATOM   1492  OH  TYR   206      22.157  31.087   7.208  1.00 10.83           O  
ATOM   1493  N   MET   207      22.618  32.922   0.472  1.00  7.25           N  
ATOM   1494  CA  MET   207      21.640  34.024   0.460  1.00  9.04           C  
ATOM   1495  C   MET   207      20.403  33.663  -0.376  1.00  8.99           C  
ATOM   1496  O   MET   207      19.240  33.915   0.050  1.00 11.12           O  
ATOM   1497  CB  MET   207      22.287  35.307   0.016  1.00  8.31           C  
ATOM   1498  CG  MET   207      23.162  35.904   1.145  1.00  8.70           C  
ATOM   1499  SD  MET   207      24.421  37.241   0.441  1.00 11.06          SE  
ATOM   1500  CE  MET   207      23.098  38.585  -0.024  1.00 13.46           C  
ATOM   1501  N   ARG   208      20.636  33.083  -1.535  1.00 10.61           N  
ATOM   1502  CA  ARG   208      19.503  32.741  -2.425  1.00  9.90           C  
ATOM   1503  C   ARG   208      18.536  31.785  -1.713  1.00 11.11           C  
ATOM   1504  O   ARG   208      17.295  31.938  -1.782  1.00 11.37           O  
ATOM   1505  CB  ARG   208      20.015  32.179  -3.743  1.00 12.27           C  
ATOM   1506  CG  ARG   208      20.585  33.343  -4.610  1.00 15.78           C  
ATOM   1507  CD  ARG   208      20.941  32.873  -6.042  1.00 16.42           C  
ATOM   1508  NE  ARG   208      22.040  31.918  -6.103  1.00 17.26           N  
ATOM   1509  CZ  ARG   208      23.330  32.252  -6.152  1.00 16.45           C  
ATOM   1510  NH1 ARG   208      23.690  33.522  -6.102  1.00 17.32           N  
ATOM   1511  NH2 ARG   208      24.268  31.307  -6.225  1.00 17.91           N  
ATOM   1512  N   SER   209      19.091  30.845  -0.973  1.00  9.56           N  
ATOM   1513  CA  SER   209      18.271  29.853  -0.265  1.00 10.25           C  
ATOM   1514  C   SER   209      17.548  30.490   0.896  1.00 10.33           C  
ATOM   1515  O   SER   209      16.381  30.164   1.185  1.00 11.28           O  
ATOM   1516  CB  SER   209      19.144  28.705   0.232  1.00 11.33           C  
ATOM   1517  OG  SER   209      19.516  27.853  -0.832  1.00 13.34           O  
ATOM   1518  N   LEU   210      18.242  31.401   1.590  1.00 10.38           N  
ATOM   1519  CA  LEU   210      17.569  32.130   2.698  1.00  8.87           C  
ATOM   1520  C   LEU   210      16.428  32.977   2.120  1.00  9.51           C  
ATOM   1521  O   LEU   210      15.323  32.988   2.670  1.00  9.92           O  
ATOM   1522  CB  LEU   210      18.623  32.968   3.434  1.00  9.32           C  
ATOM   1523  CG  LEU   210      18.048  33.840   4.556  1.00  9.09           C  
ATOM   1524  CD1 LEU   210      17.590  32.951   5.718  1.00 10.71           C  
ATOM   1525  CD2 LEU   210      19.140  34.878   5.001  1.00 10.89           C  
ATOM   1526  N   PHE   211      16.667  33.630   0.980  1.00  9.30           N  
ATOM   1527  CA  PHE   211      15.672  34.526   0.423  1.00 10.50           C  
ATOM   1528  C   PHE   211      14.498  33.663  -0.069  1.00  9.99           C  
ATOM   1529  O   PHE   211      13.333  34.056   0.074  1.00  9.59           O  
ATOM   1530  CB  PHE   211      16.256  35.373  -0.710  1.00  9.65           C  
ATOM   1531  CG  PHE   211      17.358  36.303  -0.267  1.00 10.52           C  
ATOM   1532  CD1 PHE   211      17.539  36.610   1.083  1.00 11.62           C  
ATOM   1533  CD2 PHE   211      18.194  36.871  -1.203  1.00 14.73           C  
ATOM   1534  CE1 PHE   211      18.576  37.453   1.488  1.00 15.33           C  
ATOM   1535  CE2 PHE   211      19.217  37.745  -0.808  1.00 15.53           C  
ATOM   1536  CZ  PHE   211      19.387  38.034   0.550  1.00 13.13           C  
ATOM   1537  N   ASP   212      14.806  32.486  -0.590  1.00 10.28           N  
ATOM   1538  CA  ASP   212      13.733  31.557  -0.956  1.00 10.45           C  
ATOM   1539  C   ASP   212      12.895  31.125   0.242  1.00 10.32           C  
ATOM   1540  O   ASP   212      11.673  31.044   0.154  1.00  9.93           O  
ATOM   1541  CB  ASP   212      14.257  30.322  -1.670  1.00 11.35           C  
ATOM   1542  CG  ASP   212      13.113  29.499  -2.281  1.00 14.19           C  
ATOM   1543  OD1 ASP   212      12.306  30.036  -3.060  1.00 18.34           O  
ATOM   1544  OD2 ASP   212      12.958  28.348  -1.923  1.00 19.95           O  
ATOM   1545  N   TYR   213      13.533  30.877   1.375  1.00  9.34           N  
ATOM   1546  CA  TYR   213      12.773  30.636   2.621  1.00  9.28           C  
ATOM   1547  C   TYR   213      11.844  31.819   2.913  1.00 10.01           C  
ATOM   1548  O   TYR   213      10.654  31.633   3.166  1.00  9.71           O  
ATOM   1549  CB  TYR   213      13.741  30.430   3.765  1.00 10.44           C  
ATOM   1550  CG  TYR   213      13.072  30.316   5.104  1.00  9.68           C  
ATOM   1551  CD1 TYR   213      12.126  29.302   5.346  1.00 11.69           C  
ATOM   1552  CD2 TYR   213      13.423  31.187   6.162  1.00 11.29           C  
ATOM   1553  CE1 TYR   213      11.512  29.192   6.584  1.00 14.86           C  
ATOM   1554  CE2 TYR   213      12.818  31.065   7.378  1.00 12.39           C  
ATOM   1555  CZ  TYR   213      11.875  30.086   7.587  1.00 15.18           C  
ATOM   1556  OH  TYR   213      11.328  29.987   8.860  1.00 18.19           O  
ATOM   1557  N   PHE   214      12.362  33.044   2.825  1.00  9.20           N  
ATOM   1558  CA  PHE   214      11.530  34.208   3.131  1.00  9.42           C  
ATOM   1559  C   PHE   214      10.352  34.318   2.171  1.00 10.67           C  
ATOM   1560  O   PHE   214       9.267  34.633   2.596  1.00 10.12           O  
ATOM   1561  CB  PHE   214      12.333  35.500   3.002  1.00  9.95           C  
ATOM   1562  CG  PHE   214      13.394  35.690   4.060  1.00  8.70           C  
ATOM   1563  CD1 PHE   214      13.403  34.963   5.244  1.00  8.58           C  
ATOM   1564  CD2 PHE   214      14.387  36.661   3.852  1.00 10.59           C  
ATOM   1565  CE1 PHE   214      14.396  35.198   6.210  1.00 10.02           C  
ATOM   1566  CE2 PHE   214      15.386  36.898   4.808  1.00 10.61           C  
ATOM   1567  CZ  PHE   214      15.385  36.182   5.976  1.00 11.62           C  
ATOM   1568  N   LEU   215      10.583  34.056   0.879  1.00 10.25           N  
ATOM   1569  CA  LEU   215       9.506  34.231  -0.114  1.00 10.38           C  
ATOM   1570  C   LEU   215       8.566  33.038  -0.161  1.00 10.77           C  
ATOM   1571  O   LEU   215       7.339  33.174   0.017  1.00 11.28           O  
ATOM   1572  CB  LEU   215      10.121  34.485  -1.488  1.00 10.63           C  
ATOM   1573  CG  LEU   215       9.069  34.627  -2.612  1.00  9.43           C  
ATOM   1574  CD1 LEU   215       8.138  35.785  -2.313  1.00 12.74           C  
ATOM   1575  CD2 LEU   215       9.785  34.860  -3.967  1.00 12.27           C  
ATOM   1576  N   THR   216       9.131  31.865  -0.398  1.00 11.00           N  
ATOM   1577  CA  THR   216       8.307  30.671  -0.567  1.00 12.81           C  
ATOM   1578  C   THR   216       7.626  30.239   0.730  1.00 12.62           C  
ATOM   1579  O   THR   216       6.467  29.852   0.720  1.00 13.60           O  
ATOM   1580  CB  THR   216       9.152  29.534  -1.189  1.00 12.36           C  
ATOM   1581  OG1 THR   216       9.636  29.972  -2.460  1.00 14.69           O  
ATOM   1582  CG2 THR   216       8.319  28.262  -1.368  1.00 14.27           C  
ATOM   1583  N   ASP   217       8.359  30.285   1.847  1.00 13.20           N  
ATOM   1584  CA  ASP   217       7.882  29.746   3.104  1.00 12.92           C  
ATOM   1585  C   ASP   217       7.256  30.784   4.037  1.00 13.22           C  
ATOM   1586  O   ASP   217       6.143  30.582   4.550  1.00 15.48           O  
ATOM   1587  CB  ASP   217       9.011  28.934   3.761  1.00 13.79           C  
ATOM   1588  CG  ASP   217       9.519  27.832   2.822  1.00 16.22           C  
ATOM   1589  OD1 ASP   217       8.673  27.023   2.386  1.00 18.83           O  
ATOM   1590  OD2 ASP   217      10.702  27.797   2.466  1.00 15.17           O  
ATOM   1591  N   LEU   218       7.916  31.930   4.212  1.00 10.94           N  
ATOM   1592  CA  LEU   218       7.348  32.985   5.050  1.00 11.53           C  
ATOM   1593  C   LEU   218       6.392  33.937   4.297  1.00 11.62           C  
ATOM   1594  O   LEU   218       5.723  34.808   4.914  1.00 12.88           O  
ATOM   1595  CB  LEU   218       8.481  33.745   5.769  1.00 11.54           C  
ATOM   1596  CG  LEU   218       9.332  32.906   6.752  1.00 12.78           C  
ATOM   1597  CD1 LEU   218      10.272  33.818   7.514  1.00 12.03           C  
ATOM   1598  CD2 LEU   218       8.443  32.131   7.731  1.00 15.13           C  
ATOM   1599  N   LYS   219       6.339  33.766   2.979  1.00 11.24           N  
ATOM   1600  CA  LYS   219       5.419  34.528   2.134  1.00 12.22           C  
ATOM   1601  C   LYS   219       5.700  36.040   2.224  1.00 12.08           C  
ATOM   1602  O   LYS   219       4.752  36.851   2.263  1.00 12.49           O  
ATOM   1603  CB  LYS   219       3.949  34.225   2.515  1.00 14.45           C  
ATOM   1604  CG  LYS   219       3.542  32.732   2.601  1.00 17.85           C  
ATOM   1605  CD  LYS   219       3.793  31.984   1.282  1.00 19.35           C  
ATOM   1606  CE  LYS   219       3.347  30.499   1.371  1.00 22.17           C  
ATOM   1607  NZ  LYS   219       3.656  29.950   2.699  1.00 27.12           N  
ATOM   1608  N   CYS   220       7.000  36.404   2.185  1.00 11.26           N  
ATOM   1609  CA  CYS   220       7.395  37.824   2.261  0.80 11.17           C  
ATOM   1611  C   CYS   220       6.842  38.615   1.085  1.00 11.75           C  
ATOM   1612  O   CYS   220       6.593  38.082  -0.005  1.00 11.77           O  
ATOM   1613  CB  CYS   220       8.907  38.003   2.340  0.80 11.41           C  
ATOM   1615  SG  CYS   220       9.772  37.747   0.774  0.80 12.73           S  
ATOM   1617  N   SER   221       6.585  39.897   1.334  1.00 12.01           N  
ATOM   1618  CA  SER   221       6.150  40.778   0.265  1.00 13.09           C  
ATOM   1619  C   SER   221       7.377  41.226  -0.550  1.00 14.04           C  
ATOM   1620  O   SER   221       8.492  41.258  -0.029  1.00 14.60           O  
ATOM   1621  CB  SER   221       5.389  41.968   0.837  1.00 13.77           C  
ATOM   1622  OG  SER   221       6.180  42.739   1.729  1.00 13.35           O  
ATOM   1623  N   LEU   222       7.165  41.555  -1.822  1.00 15.54           N  
ATOM   1624  CA  LEU   222       8.265  41.947  -2.720  1.00 17.54           C  
ATOM   1625  C   LEU   222       7.970  43.329  -3.322  1.00 19.60           C  
ATOM   1626  O   LEU   222       6.825  43.619  -3.649  1.00 20.17           O  
ATOM   1627  CB  LEU   222       8.395  40.946  -3.869  1.00 17.61           C  
ATOM   1628  CG  LEU   222       8.783  39.513  -3.568  1.00 18.69           C  
ATOM   1629  CD1 LEU   222       8.813  38.720  -4.849  1.00 19.94           C  
ATOM   1630  CD2 LEU   222      10.141  39.432  -2.857  1.00 20.71           C  
ATOM   1631  N   PRO   223       9.006  44.170  -3.499  1.00 22.05           N  
ATOM   1632  CA  PRO   223       8.735  45.432  -4.199  1.00 23.24           C  
ATOM   1633  C   PRO   223       8.219  45.147  -5.644  1.00 24.73           C  
ATOM   1634  O   PRO   223       8.453  44.071  -6.172  1.00 23.36           O  
ATOM   1635  CB  PRO   223      10.102  46.129  -4.224  1.00 22.98           C  
ATOM   1636  CG  PRO   223      10.992  45.386  -3.256  1.00 23.58           C  
ATOM   1637  CD  PRO   223      10.414  43.998  -3.114  1.00 22.06           C  
ATOM   1638  N   ALA   224       7.538  46.118  -6.255  1.00 26.52           N  
ATOM   1639  CA  ALA   224       7.013  45.993  -7.628  1.00 27.20           C  
ATOM   1640  C   ALA   224       8.122  45.798  -8.679  1.00 27.32           C  
ATOM   1641  O   ALA   224       7.891  45.228  -9.744  1.00 27.65           O  
ATOM   1642  CB  ALA   224       6.187  47.210  -7.969  1.00 27.94           C  
ATOM   1643  N   THR   225       9.320  46.257  -8.349  1.00 27.06           N  
ATOM   1644  CA  THR   225      10.485  46.172  -9.227  1.00 27.45           C  
ATOM   1645  C   THR   225      11.260  44.855  -9.100  1.00 26.00           C  
ATOM   1646  O   THR   225      12.251  44.629  -9.804  1.00 26.66           O  
ATOM   1647  CB  THR   225      11.428  47.339  -8.900  1.00 28.46           C  
ATOM   1648  OG1 THR   225      11.377  47.607  -7.486  1.00 31.78           O  
ATOM   1649  CG2 THR   225      10.985  48.581  -9.650  1.00 30.14           C  
ATOM   1650  N   LEU   226      10.828  43.975  -8.199  1.00 23.06           N  
ATOM   1651  CA  LEU   226      11.565  42.749  -7.951  0.70 22.35           C  
ATOM   1653  C   LEU   226      10.794  41.516  -8.397  1.00 22.73           C  
ATOM   1654  O   LEU   226       9.766  41.165  -7.805  1.00 23.06           O  
ATOM   1655  CB  LEU   226      11.915  42.621  -6.462  0.70 22.21           C  
ATOM   1657  CG  LEU   226      12.645  41.357  -6.011  0.70 21.36           C  
ATOM   1659  CD1 LEU   226      14.027  41.305  -6.595  0.70 19.42           C  
ATOM   1661  CD2 LEU   226      12.727  41.337  -4.500  0.70 21.10           C  
ATOM   1663  N   SER   227      11.318  40.850  -9.417  1.00 21.25           N  
ATOM   1664  CA  SER   227      10.727  39.614  -9.908  1.00 20.51           C  
ATOM   1665  C   SER   227      11.064  38.461  -8.957  1.00 20.26           C  
ATOM   1666  O   SER   227      12.080  38.498  -8.239  1.00 19.13           O  
ATOM   1667  CB  SER   227      11.282  39.296 -11.304  1.00 20.26           C  
ATOM   1668  OG  SER   227      12.667  39.041 -11.219  1.00 20.10           O  
ATOM   1669  N   ARG   228      10.236  37.418  -8.960  1.00 20.07           N  
ATOM   1670  CA  ARG   228      10.622  36.175  -8.282  1.00 19.92           C  
ATOM   1671  C   ARG   228      11.911  35.579  -8.856  1.00 20.94           C  
ATOM   1672  O   ARG   228      12.730  35.000  -8.118  1.00 20.58           O  
ATOM   1673  CB  ARG   228       9.483  35.143  -8.344  1.00 19.92           C  
ATOM   1674  CG  ARG   228       8.135  35.696  -7.878  1.00 20.51           C  
ATOM   1675  CD  ARG   228       7.076  34.614  -7.959  1.00 21.49           C  
ATOM   1676  NE  ARG   228       7.084  33.695  -6.813  1.00 21.75           N  
ATOM   1677  CZ  ARG   228       6.488  33.960  -5.648  1.00 21.92           C  
ATOM   1678  NH1 ARG   228       6.549  33.053  -4.678  1.00 21.92           N  
ATOM   1679  NH2 ARG   228       5.858  35.129  -5.441  1.00 19.45           N  
ATOM   1680  N   SER   229      12.135  35.746 -10.171  1.00 20.25           N  
ATOM   1681  CA  SER   229      13.321  35.200 -10.798  1.00 20.93           C  
ATOM   1682  C   SER   229      14.635  35.825 -10.306  1.00 20.97           C  
ATOM   1683  O   SER   229      15.655  35.134 -10.249  1.00 20.98           O  
ATOM   1684  CB  SER   229      13.227  35.330 -12.319  1.00 21.06           C  
ATOM   1685  OG  SER   229      12.191  34.481 -12.787  1.00 21.93           O  
ATOM   1686  N   GLU   230      14.582  37.105  -9.951  1.00 21.77           N  
ATOM   1687  CA  GLU   230      15.745  37.842  -9.443  1.00 23.44           C  
ATOM   1688  C   GLU   230      16.241  37.121  -8.208  1.00 24.30           C  
ATOM   1689  O   GLU   230      17.427  36.822  -8.038  1.00 23.11           O  
ATOM   1690  CB  GLU   230      15.327  39.232  -8.986  1.00 24.88           C  
ATOM   1691  CG  GLU   230      16.446  39.964  -8.211  1.00 25.43           C  
ATOM   1692  CD  GLU   230      17.011  41.126  -8.957  1.00 26.89           C  
ATOM   1693  OE1 GLU   230      16.267  41.704  -9.768  1.00 24.08           O  
ATOM   1694  OE2 GLU   230      18.173  41.500  -8.684  1.00 27.40           O  
ATOM   1695  N   LEU   231      15.273  36.842  -7.355  1.00 24.65           N  
ATOM   1696  CA  LEU   231      15.505  36.472  -5.987  1.00 27.37           C  
ATOM   1697  C   LEU   231      16.227  35.128  -5.920  1.00 29.19           C  
ATOM   1698  O   LEU   231      17.116  34.926  -5.074  1.00 30.79           O  
ATOM   1699  CB  LEU   231      14.133  36.437  -5.258  1.00 26.15           C  
ATOM   1700  CG  LEU   231      14.103  35.965  -3.808  1.00 25.48           C  
ATOM   1701  CD1 LEU   231      13.097  36.817  -3.039  1.00 24.11           C  
ATOM   1702  CD2 LEU   231      13.722  34.484  -3.709  1.00 24.46           C  
ATOM   1703  N   MET   232      15.892  34.259  -6.869  1.00 31.30           N  
ATOM   1704  CA  MET   232      16.273  32.841  -6.802  0.50 32.60           C  
ATOM   1706  C   MET   232      17.579  32.519  -7.520  1.00 32.66           C  
ATOM   1707  O   MET   232      18.270  31.545  -7.156  1.00 33.58           O  
ATOM   1708  CB  MET   232      15.130  31.960  -7.316  0.50 32.48           C  
ATOM   1710  CG  MET   232      13.833  32.197  -6.556  0.50 33.23           C  
ATOM   1712  SD  MET   232      12.288  31.294  -7.301  0.50 34.88          SE  
ATOM   1714  CE  MET   232      12.824  29.439  -6.973  0.50 35.68           C  
ATOM   1716  N   SER   233      17.902  33.327  -8.515  1.00 32.34           N  
ATOM   1717  CA  SER   233      19.173  33.283  -9.197  1.00 32.73           C  
ATOM   1718  C   SER   233      19.526  34.735  -9.260  1.00 32.27           C  
ATOM   1719  O   SER   233      18.661  35.516  -9.653  1.00 33.00           O  
ATOM   1720  CB  SER   233      19.010  32.787 -10.617  1.00 33.04           C  
ATOM   1721  OG  SER   233      18.096  33.619 -11.336  1.00 37.07           O  
ATOM   1722  N   VAL   234      20.759  35.092  -8.861  1.00 30.11           N  
ATOM   1723  CA  VAL   234      21.353  36.417  -9.039  1.00 29.06           C  
ATOM   1724  C   VAL   234      21.759  36.972  -7.668  1.00 27.42           C  
ATOM   1725  O   VAL   234      20.861  37.292  -6.847  1.00 27.92           O  
ATOM   1726  CB  VAL   234      20.401  37.472  -9.761  1.00 30.12           C  
ATOM   1727  CG1 VAL   234      21.032  38.881  -9.755  1.00 32.18           C  
ATOM   1728  CG2 VAL   234      20.084  37.050 -11.177  1.00 30.59           C  
ATOM   1729  N   THR   235      23.084  37.044  -7.414  1.00 24.54           N  
ATOM   1730  CA  THR   235      23.611  37.828  -6.274  1.00 21.55           C  
ATOM   1731  C   THR   235      24.970  38.463  -6.580  1.00 20.36           C  
ATOM   1732  O   THR   235      25.994  37.787  -6.534  1.00 20.67           O  
ATOM   1733  CB  THR   235      23.793  36.967  -4.996  1.00 20.99           C  
ATOM   1734  OG1 THR   235      22.701  36.060  -4.860  1.00 21.81           O  
ATOM   1735  CG2 THR   235      23.909  37.893  -3.732  1.00 19.10           C  
ATOM   1736  N   PRO   236      24.994  39.767  -6.880  1.00 18.67           N  
ATOM   1737  CA  PRO   236      26.263  40.458  -7.209  1.00 17.30           C  
ATOM   1738  C   PRO   236      27.175  40.544  -5.981  1.00 16.11           C  
ATOM   1739  O   PRO   236      26.660  40.543  -4.861  1.00 15.24           O  
ATOM   1740  CB  PRO   236      25.813  41.883  -7.586  1.00 18.40           C  
ATOM   1741  CG  PRO   236      24.320  41.835  -7.742  1.00 19.11           C  
ATOM   1742  CD  PRO   236      23.824  40.662  -6.942  1.00 18.91           C  
ATOM   1743  N   ASN   237      28.495  40.623  -6.184  1.00 15.37           N  
ATOM   1744  CA  ASN   237      29.410  40.915  -5.067  1.00 14.60           C  
ATOM   1745  C   ASN   237      29.053  42.256  -4.406  1.00 13.70           C  
ATOM   1746  O   ASN   237      28.875  43.267  -5.093  1.00 15.31           O  
ATOM   1747  CB  ASN   237      30.871  40.917  -5.503  1.00 14.73           C  
ATOM   1748  CG  ASN   237      31.377  39.526  -5.865  1.00 15.52           C  
ATOM   1749  OD1 ASN   237      31.642  39.260  -7.037  1.00 19.53           O  
ATOM   1750  ND2 ASN   237      31.449  38.610  -4.870  1.00 14.35           N  
ATOM   1751  N   THR   238      28.974  42.244  -3.083  1.00 12.97           N  
ATOM   1752  CA  THR   238      28.441  43.358  -2.231  1.00 12.00           C  
ATOM   1753  C   THR   238      27.022  43.852  -2.533  1.00 13.36           C  
ATOM   1754  O   THR   238      26.633  44.940  -2.108  1.00 13.65           O  
ATOM   1755  CB  THR   238      29.436  44.556  -2.091  1.00 12.82           C  
ATOM   1756  OG1 THR   238      29.545  45.243  -3.343  1.00 14.76           O  
ATOM   1757  CG2 THR   238      30.807  44.035  -1.598  1.00 13.59           C  
ATOM   1758  N   GLY   239      26.268  43.034  -3.271  1.00 13.24           N  
ATOM   1759  CA  GLY   239      24.830  43.263  -3.519  1.00 13.93           C  
ATOM   1760  C   GLY   239      24.107  43.245  -2.182  1.00 13.74           C  
ATOM   1761  O   GLY   239      24.339  42.340  -1.368  1.00 14.21           O  
ATOM   1762  N   MET   240      23.242  44.239  -1.966  1.00 12.78           N  
ATOM   1763  CA  MET   240      22.584  44.447  -0.685  1.00 13.58           C  
ATOM   1764  C   MET   240      21.069  44.208  -0.750  1.00 13.24           C  
ATOM   1765  O   MET   240      20.395  44.680  -1.660  1.00 13.69           O  
ATOM   1766  CB  MET   240      22.806  45.896  -0.220  1.00 15.11           C  
ATOM   1767  CG  MET   240      24.272  46.251  -0.086  1.00 15.12           C  
ATOM   1768  SD  MET   240      24.362  48.070   0.611  1.00 18.77          SE  
ATOM   1769  CE  MET   240      26.264  48.246   0.501  1.00 18.08           C  
ATOM   1770  N   SER   241      20.549  43.509   0.255  1.00 13.14           N  
ATOM   1771  CA  SER   241      19.119  43.255   0.356  0.70 12.52           C  
ATOM   1773  C   SER   241      18.692  43.676   1.746  1.00 13.29           C  
ATOM   1774  O   SER   241      19.403  43.434   2.713  1.00 14.20           O  
ATOM   1775  CB  SER   241      18.850  41.760   0.131  0.70 12.45           C  
ATOM   1777  OG  SER   241      19.292  41.387  -1.161  0.70 10.80           O  
ATOM   1779  N   LEU   242      17.529  44.328   1.846  1.00 12.23           N  
ATOM   1780  CA  LEU   242      16.979  44.770   3.117  1.00 12.90           C  
ATOM   1781  C   LEU   242      15.586  44.170   3.282  1.00 11.83           C  
ATOM   1782  O   LEU   242      14.755  44.272   2.345  1.00 12.05           O  
ATOM   1783  CB  LEU   242      16.875  46.318   3.160  1.00 13.04           C  
ATOM   1784  CG  LEU   242      16.191  46.884   4.429  1.00 15.99           C  
ATOM   1785  CD1 LEU   242      16.974  46.593   5.720  1.00 15.29           C  
ATOM   1786  CD2 LEU   242      16.016  48.428   4.269  1.00 14.21           C  
ATOM   1787  N   PHE   243      15.361  43.622   4.482  1.00 11.67           N  
ATOM   1788  CA  PHE   243      14.080  43.045   4.930  1.00 12.76           C  
ATOM   1789  C   PHE   243      13.642  43.680   6.256  1.00 12.46           C  
ATOM   1790  O   PHE   243      14.480  43.930   7.155  1.00 12.87           O  
ATOM   1791  CB  PHE   243      14.219  41.532   5.128  1.00 12.81           C  
ATOM   1792  CG  PHE   243      14.701  40.822   3.892  1.00 13.64           C  
ATOM   1793  CD1 PHE   243      13.810  40.355   2.948  1.00 14.82           C  
ATOM   1794  CD2 PHE   243      16.068  40.676   3.672  1.00 15.31           C  
ATOM   1795  CE1 PHE   243      14.283  39.710   1.748  1.00 14.92           C  
ATOM   1796  CE2 PHE   243      16.548  40.066   2.540  1.00 12.18           C  
ATOM   1797  CZ  PHE   243      15.672  39.588   1.565  1.00 10.84           C  
ATOM   1798  N   ILE   244      12.335  43.896   6.398  1.00 12.62           N  
ATOM   1799  CA  ILE   244      11.789  44.211   7.698  1.00 12.69           C  
ATOM   1800  C   ILE   244      11.060  42.959   8.227  1.00 11.90           C  
ATOM   1801  O   ILE   244      10.181  42.396   7.558  1.00 12.22           O  
ATOM   1802  CB  ILE   244      10.846  45.460   7.683  1.00 13.59           C  
ATOM   1803  CG1 ILE   244      11.553  46.710   7.095  1.00 16.20           C  
ATOM   1804  CG2 ILE   244      10.370  45.738   9.092  1.00 14.97           C  
ATOM   1805  CD1 ILE   244      12.795  47.147   7.862  1.00 19.67           C  
ATOM   1806  N   ILE   245      11.453  42.509   9.412  1.00 11.60           N  
ATOM   1807  CA  ILE   245      10.858  41.320  10.032  1.00 11.68           C  
ATOM   1808  C   ILE   245       9.879  41.784  11.105  1.00 13.67           C  
ATOM   1809  O   ILE   245      10.246  42.595  11.946  1.00 13.43           O  
ATOM   1810  CB  ILE   245      11.944  40.445  10.706  1.00 11.82           C  
ATOM   1811  CG1 ILE   245      13.184  40.245   9.781  1.00 12.57           C  
ATOM   1812  CG2 ILE   245      11.358  39.134  11.191  1.00 13.22           C  
ATOM   1813  CD1 ILE   245      12.849  39.659   8.365  1.00 14.11           C  
ATOM   1814  N   ASN   246       8.674  41.220  11.116  1.00 12.98           N  
ATOM   1815  CA  ASN   246       7.570  41.742  11.953  1.00 14.16           C  
ATOM   1816  C   ASN   246       6.988  40.612  12.804  1.00 14.34           C  
ATOM   1817  O   ASN   246       6.585  39.556  12.275  1.00 13.56           O  
ATOM   1818  CB  ASN   246       6.425  42.270  11.045  1.00 15.39           C  
ATOM   1819  CG  ASN   246       6.871  43.351  10.067  1.00 18.81           C  
ATOM   1820  OD1 ASN   246       7.381  43.092   8.938  1.00 23.58           O  
ATOM   1821  ND2 ASN   246       6.644  44.593  10.475  1.00 22.31           N  
ATOM   1822  N   PHE   247       6.923  40.822  14.127  1.00 15.67           N  
ATOM   1823  CA  PHE   247       6.282  39.853  14.997  1.00 16.23           C  
ATOM   1824  C   PHE   247       5.077  40.508  15.677  1.00 18.30           C  
ATOM   1825  O   PHE   247       5.220  41.540  16.320  1.00 17.11           O  
ATOM   1826  CB  PHE   247       7.234  39.383  16.116  1.00 17.45           C  
ATOM   1827  CG  PHE   247       8.305  38.430  15.667  1.00 16.77           C  
ATOM   1828  CD1 PHE   247       8.106  37.063  15.754  1.00 17.77           C  
ATOM   1829  CD2 PHE   247       9.519  38.909  15.190  1.00 19.72           C  
ATOM   1830  CE1 PHE   247       9.088  36.164  15.310  1.00 19.81           C  
ATOM   1831  CE2 PHE   247      10.509  38.024  14.758  1.00 17.22           C  
ATOM   1832  CZ  PHE   247      10.293  36.657  14.829  1.00 18.61           C  
ATOM   1833  N   GLU   248       3.923  39.876  15.551  1.00 19.35           N  
ATOM   1834  CA  GLU   248       2.781  40.197  16.416  1.00 22.23           C  
ATOM   1835  C   GLU   248       3.103  39.774  17.853  1.00 22.71           C  
ATOM   1836  O   GLU   248       4.013  38.979  18.080  1.00 20.96           O  
ATOM   1837  CB  GLU   248       1.532  39.491  15.889  1.00 22.61           C  
ATOM   1838  CG  GLU   248       0.932  40.248  14.695  1.00 25.01           C  
ATOM   1839  CD  GLU   248      -0.290  39.602  14.050  1.00 26.62           C  
ATOM   1840  OE1 GLU   248      -0.802  38.579  14.550  1.00 32.28           O  
ATOM   1841  OE2 GLU   248      -0.744  40.145  13.015  1.00 33.12           O  
ATOM   1842  N   GLU   249       2.374  40.335  18.822  1.00 24.15           N  
ATOM   1843  CA  GLU   249       2.566  39.933  20.207  1.00 26.26           C  
ATOM   1844  C   GLU   249       2.084  38.503  20.390  1.00 24.94           C  
ATOM   1845  O   GLU   249       1.216  38.006  19.641  1.00 24.12           O  
ATOM   1846  CB  GLU   249       1.843  40.888  21.148  1.00 25.98           C  
ATOM   1847  CG  GLU   249       0.531  40.375  21.742  1.00 31.22           C  
ATOM   1848  CD  GLU   249      -0.230  41.493  22.450  1.00 30.94           C  
ATOM   1849  OE1 GLU   249       0.432  42.430  22.991  1.00 38.11           O  
ATOM   1850  OE2 GLU   249      -1.481  41.457  22.429  1.00 37.68           O  
ATOM   1851  N   GLY   250       2.678  37.831  21.362  1.00 24.73           N  
ATOM   1852  CA  GLY   250       2.268  36.496  21.738  1.00 25.76           C  
ATOM   1853  C   GLY   250       3.414  35.552  21.992  1.00 25.75           C  
ATOM   1854  O   GLY   250       4.567  35.989  22.161  1.00 25.79           O  
ATOM   1855  N   ARG   251       3.088  34.256  22.015  1.00 26.24           N  
ATOM   1856  CA  ARG   251       4.046  33.166  22.217  1.00 27.25           C  
ATOM   1857  C   ARG   251       4.241  32.399  20.920  1.00 27.77           C  
ATOM   1858  O   ARG   251       3.263  32.141  20.216  1.00 28.46           O  
ATOM   1859  CB  ARG   251       3.515  32.186  23.283  1.00 27.24           C  
ATOM   1860  CG  ARG   251       3.140  32.856  24.591  1.00 28.49           C  
ATOM   1861  CD  ARG   251       2.561  31.859  25.640  1.00 28.57           C  
ATOM   1862  NE  ARG   251       1.780  32.587  26.639  1.00 33.40           N  
ATOM   1863  CZ  ARG   251       2.276  33.080  27.773  1.00 34.86           C  
ATOM   1864  NH1 ARG   251       3.558  32.901  28.084  1.00 34.71           N  
ATOM   1865  NH2 ARG   251       1.480  33.746  28.602  1.00 36.04           N  
ATOM   1866  N   GLU   252       5.493  32.042  20.616  1.00 27.82           N  
ATOM   1867  CA  GLU   252       5.857  31.247  19.428  1.00 28.91           C  
ATOM   1868  C   GLU   252       5.214  31.815  18.146  1.00 26.70           C  
ATOM   1869  O   GLU   252       4.576  31.089  17.373  1.00 27.41           O  
ATOM   1870  CB  GLU   252       5.455  29.774  19.617  1.00 28.85           C  
ATOM   1871  CG  GLU   252       6.465  28.782  19.055  1.00 32.65           C  
ATOM   1872  CD  GLU   252       6.321  27.363  19.621  1.00 32.84           C  
ATOM   1873  OE1 GLU   252       7.240  26.561  19.360  1.00 40.25           O  
ATOM   1874  OE2 GLU   252       5.302  27.029  20.290  1.00 38.53           O  
ATOM   1875  N   VAL   253       5.371  33.117  17.958  1.00 25.17           N  
ATOM   1876  CA  VAL   253       4.775  33.851  16.836  1.00 22.77           C  
ATOM   1877  C   VAL   253       5.595  33.691  15.556  1.00 21.79           C  
ATOM   1878  O   VAL   253       6.816  33.855  15.559  1.00 21.90           O  
ATOM   1879  CB  VAL   253       4.580  35.341  17.196  1.00 22.33           C  
ATOM   1880  CG1 VAL   253       4.074  36.171  15.993  1.00 21.72           C  
ATOM   1881  CG2 VAL   253       3.605  35.476  18.387  1.00 24.21           C  
ATOM   1882  N   LYS   254       4.895  33.354  14.475  1.00 20.12           N  
ATOM   1883  CA  LYS   254       5.478  33.286  13.146  1.00 18.03           C  
ATOM   1884  C   LYS   254       5.614  34.706  12.594  1.00 17.17           C  
ATOM   1885  O   LYS   254       4.621  35.404  12.471  1.00 16.18           O  
ATOM   1886  CB  LYS   254       4.570  32.497  12.207  1.00 19.08           C  
ATOM   1887  CG  LYS   254       5.238  32.176  10.891  1.00 19.33           C  
ATOM   1888  CD  LYS   254       4.260  31.439   9.948  1.00 26.85           C  
ATOM   1889  CE  LYS   254       4.926  31.017   8.656  1.00 30.92           C  
ATOM   1890  NZ  LYS   254       3.996  30.199   7.841  1.00 34.45           N  
ATOM   1891  N   PRO   255       6.841  35.118  12.235  1.00 15.86           N  
ATOM   1892  CA  PRO   255       6.987  36.492  11.743  1.00 14.73           C  
ATOM   1893  C   PRO   255       6.441  36.684  10.334  1.00 14.00           C  
ATOM   1894  O   PRO   255       6.259  35.704   9.594  1.00 15.12           O  
ATOM   1895  CB  PRO   255       8.517  36.704  11.706  1.00 14.51           C  
ATOM   1896  CG  PRO   255       9.068  35.329  11.521  1.00 15.15           C  
ATOM   1897  CD  PRO   255       8.117  34.382  12.249  1.00 16.49           C  
ATOM   1898  N   THR   256       6.163  37.928   9.982  1.00 13.78           N  
ATOM   1899  CA  THR   256       5.953  38.277   8.570  1.00 13.57           C  
ATOM   1900  C   THR   256       7.164  39.079   8.096  1.00 13.58           C  
ATOM   1901  O   THR   256       7.872  39.668   8.915  1.00 14.02           O  
ATOM   1902  CB  THR   256       4.658  39.061   8.380  1.00 13.94           C  
ATOM   1903  OG1 THR   256       4.633  40.216   9.244  1.00 15.02           O  
ATOM   1904  CG2 THR   256       3.466  38.145   8.671  1.00 14.83           C  
ATOM   1905  N   VAL   257       7.398  39.098   6.782  1.00 11.39           N  
ATOM   1906  CA  VAL   257       8.633  39.673   6.254  1.00 11.79           C  
ATOM   1907  C   VAL   257       8.275  40.582   5.067  1.00 12.49           C  
ATOM   1908  O   VAL   257       7.431  40.238   4.259  1.00 11.88           O  
ATOM   1909  CB  VAL   257       9.603  38.560   5.797  1.00 12.20           C  
ATOM   1910  CG1 VAL   257      10.891  39.173   5.158  1.00 12.84           C  
ATOM   1911  CG2 VAL   257       9.926  37.554   6.989  1.00 11.37           C  
ATOM   1912  N   GLN   258       8.886  41.761   5.028  1.00 12.80           N  
ATOM   1913  CA  GLN   258       8.757  42.676   3.898  1.00 14.83           C  
ATOM   1914  C   GLN   258      10.146  42.821   3.279  1.00 13.10           C  
ATOM   1915  O   GLN   258      11.081  43.235   3.951  1.00 13.61           O  
ATOM   1916  CB  GLN   258       8.279  44.066   4.374  1.00 15.18           C  
ATOM   1917  CG  GLN   258       6.887  44.059   4.975  1.00 18.60           C  
ATOM   1918  CD  GLN   258       6.563  45.334   5.754  1.00 21.61           C  
ATOM   1919  OE1 GLN   258       7.172  45.643   6.800  1.00 26.56           O  
ATOM   1920  NE2 GLN   258       5.584  46.086   5.239  1.00 28.76           N  
ATOM   1921  N   CYS   259      10.274  42.453   2.014  1.00 13.04           N  
ATOM   1922  CA  CYS   259      11.499  42.712   1.287  1.00 12.61           C  
ATOM   1923  C   CYS   259      11.459  44.148   0.753  1.00 13.03           C  
ATOM   1924  O   CYS   259      10.541  44.511  -0.009  1.00 14.63           O  
ATOM   1925  CB  CYS   259      11.669  41.726   0.144  1.00 13.09           C  
ATOM   1926  SG  CYS   259      13.167  42.105  -0.790  1.00 14.63           S  
ATOM   1927  N   ILE   260      12.415  44.952   1.191  1.00 13.62           N  
ATOM   1928  CA  ILE   260      12.519  46.388   0.817  1.00 14.08           C  
ATOM   1929  C   ILE   260      13.311  46.576  -0.486  1.00 15.41           C  
ATOM   1930  O   ILE   260      12.898  47.347  -1.378  1.00 15.09           O  
ATOM   1931  CB  ILE   260      13.128  47.246   1.960  1.00 14.59           C  
ATOM   1932  CG1 ILE   260      12.328  47.110   3.275  1.00 13.59           C  
ATOM   1933  CG2 ILE   260      13.302  48.705   1.519  1.00 15.12           C  
ATOM   1934  CD1 ILE   260      10.798  47.437   3.184  1.00 17.11           C  
ATOM   1935  N   CYS   261      14.436  45.867  -0.603  1.00 14.81           N  
ATOM   1936  CA  CYS   261      15.202  45.843  -1.858  1.00 15.96           C  
ATOM   1937  C   CYS   261      16.019  44.575  -1.893  1.00 16.00           C  
ATOM   1938  O   CYS   261      16.188  43.935  -0.853  1.00 16.30           O  
ATOM   1939  CB  CYS   261      16.111  47.071  -1.964  1.00 16.22           C  
ATOM   1940  SG  CYS   261      17.350  47.186  -0.680  1.00 20.19           S  
ATOM   1941  N   MET   262      16.475  44.188  -3.076  1.00 16.20           N  
ATOM   1942  CA  MET   262      17.340  43.008  -3.196  1.00 17.67           C  
ATOM   1943  C   MET   262      18.416  43.285  -4.214  1.00 17.67           C  
ATOM   1944  O   MET   262      18.147  43.915  -5.245  1.00 17.51           O  
ATOM   1945  CB  MET   262      16.526  41.772  -3.601  1.00 17.55           C  
ATOM   1946  CG  MET   262      17.351  40.476  -3.744  1.00 20.14           C  
ATOM   1947  SD  MET   262      16.188  38.954  -3.853  1.00 20.86          SE  
ATOM   1948  CE  MET   262      15.557  39.102  -2.039  1.00 21.38           C  
ATOM   1949  N   ASN   263      19.633  42.828  -3.916  1.00 16.44           N  
ATOM   1950  CA  ASN   263      20.752  42.967  -4.856  1.00 17.08           C  
ATOM   1951  C   ASN   263      21.022  44.425  -5.263  1.00 18.00           C  
ATOM   1952  O   ASN   263      21.442  44.694  -6.418  1.00 19.37           O  
ATOM   1953  CB  ASN   263      20.519  42.091  -6.092  1.00 16.01           C  
ATOM   1954  CG  ASN   263      20.470  40.618  -5.748  1.00 17.20           C  
ATOM   1955  OD1 ASN   263      21.136  40.190  -4.797  1.00 16.42           O  
ATOM   1956  ND2 ASN   263      19.749  39.824  -6.544  1.00 20.11           N  
ATOM   1957  N   LEU   264      20.781  45.343  -4.337  1.00 18.06           N  
ATOM   1958  CA  LEU   264      21.088  46.764  -4.563  1.00 20.40           C  
ATOM   1959  C   LEU   264      22.596  46.926  -4.814  1.00 21.29           C  
ATOM   1960  O   LEU   264      23.418  46.399  -4.050  1.00 20.30           O  
ATOM   1961  CB  LEU   264      20.687  47.612  -3.350  1.00 20.35           C  
ATOM   1962  CG  LEU   264      20.446  49.114  -3.581  1.00 23.12           C  
ATOM   1963  CD1 LEU   264      19.371  49.296  -4.670  1.00 24.12           C  
ATOM   1964  CD2 LEU   264      20.018  49.775  -2.298  1.00 21.83           C  
ATOM   1965  N   GLN   265      22.955  47.657  -5.874  1.00 22.67           N  
ATOM   1966  CA  GLN   265      24.380  47.952  -6.140  1.00 25.66           C  
ATOM   1967  C   GLN   265      24.668  49.436  -6.393  1.00 26.47           C  
ATOM   1968  O   GLN   265      25.604  49.743  -7.139  1.00 27.18           O  
ATOM   1969  CB  GLN   265      24.925  47.188  -7.351  1.00 25.38           C  
ATOM   1970  CG  GLN   265      24.243  45.906  -7.762  1.00 28.61           C  
ATOM   1971  CD  GLN   265      24.906  45.265  -8.962  1.00 28.26           C  
ATOM   1972  OE1 GLN   265      26.146  45.211  -9.065  1.00 33.40           O  
ATOM   1973  NE2 GLN   265      24.092  44.746  -9.872  1.00 33.70           N  
ATOM   1974  N   ASP   266      23.903  50.326  -5.753  1.00 28.13           N  
ATOM   1975  CA  ASP   266      24.028  51.794  -5.906  1.00 30.32           C  
ATOM   1976  C   ASP   266      25.391  52.326  -5.456  1.00 30.83           C  
ATOM   1977  O   ASP   266      25.838  53.402  -5.891  1.00 31.49           O  
ATOM   1978  CB  ASP   266      22.934  52.499  -5.094  1.00 30.71           C  
ATOM   1979  CG  ASP   266      21.547  52.313  -5.687  1.00 32.76           C  
ATOM   1980  OD1 ASP   266      21.434  51.819  -6.830  1.00 35.90           O  
ATOM   1981  OD2 ASP   266      20.569  52.687  -5.007  1.00 35.33           O  
ATOM   1982  N   HIS   267      26.040  51.590  -4.563  1.00 29.75           N  
ATOM   1983  CA  HIS   267      27.378  51.928  -4.124  1.00 29.59           C  
ATOM   1984  C   HIS   267      28.480  51.599  -5.154  1.00 30.49           C  
ATOM   1985  O   HIS   267      29.633  52.004  -4.962  1.00 31.58           O  
ATOM   1986  CB  HIS   267      27.657  51.216  -2.800  1.00 28.97           C  
ATOM   1987  CG  HIS   267      27.627  49.725  -2.912  1.00 24.06           C  
ATOM   1988  ND1 HIS   267      26.469  49.026  -3.188  1.00 22.05           N  
ATOM   1989  CD2 HIS   267      28.611  48.804  -2.805  1.00 21.74           C  
ATOM   1990  CE1 HIS   267      26.745  47.732  -3.246  1.00 20.69           C  
ATOM   1991  NE2 HIS   267      28.039  47.574  -3.021  1.00 19.76           N  
ATOM   1992  N   LEU   268      28.151  50.870  -6.222  1.00 31.07           N  
ATOM   1993  CA  LEU   268      29.165  50.394  -7.182  1.00 32.45           C  
ATOM   1994  C   LEU   268      29.296  51.186  -8.499  1.00 34.57           C  
ATOM   1995  O   LEU   268      30.254  50.978  -9.247  1.00 34.93           O  
ATOM   1996  CB  LEU   268      28.976  48.905  -7.512  1.00 31.83           C  
ATOM   1997  CG  LEU   268      29.246  47.899  -6.388  1.00 30.13           C  
ATOM   1998  CD1 LEU   268      29.144  46.464  -6.905  1.00 30.71           C  
ATOM   1999  CD2 LEU   268      30.618  48.155  -5.758  1.00 30.78           C  
ATOM   2000  N   ASN   269      28.346  52.062  -8.794  1.00 36.54           N  
ATOM   2001  CA  ASN   269      28.369  52.782 -10.078  1.00 38.57           C  
ATOM   2002  C   ASN   269      29.384  53.929 -10.094  1.00 39.07           C  
ATOM   2003  O   ASN   269      30.600  53.710  -9.978  1.00 39.36           O  
ATOM   2004  CB  ASN   269      26.960  53.264 -10.476  1.00 39.59           C  
ATOM   2005  CG  ASN   269      26.201  53.925  -9.316  1.00 41.98           C  
ATOM   2006  OD1 ASN   269      26.802  54.562  -8.435  1.00 44.75           O  
ATOM   2007  ND2 ASN   269      24.873  53.793  -9.327  1.00 44.56           N  
END
