
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  241 ( 1967),  selected  241 , name 1xq9_A
# Molecule2: number of CA atoms  247 ( 1945),  selected  247 , name T0394.pdb
# PARAMETERS: 1xq9_A.T0394.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     9_A      N       1           -
LGA    -       -      L       2           -
LGA    -       -      Y       3           -
LGA    -       -      F       4           -
LGA    -       -      Q       5           -
LGA    T    10_A      S       6           #
LGA    T    11_A      A       7           #
LGA    Y    12_A      R       8          3.396
LGA    -       -      F       9           -
LGA    T    13_A      A      10          1.424
LGA    L    14_A      L      11          1.135
LGA    V    15_A      T      12          0.529
LGA    L    16_A      V      13          0.577
LGA    L    17_A      V      14          0.508
LGA    R    18_A      R      15          0.710
LGA    H    19_A      H      16          0.971
LGA    G    20_A      G      17          1.619
LGA    E    21_A      E      18          1.008
LGA    S    22_A      T      19          0.717
LGA    T    23_A      R      20          1.020
LGA    W    24_A      F      21          0.605
LGA    N    25_A      N      22          1.748
LGA    K    26_A      K      23          2.411
LGA    E    27_A      E      24          2.266
LGA    N    28_A      K      25          2.884
LGA    K    29_A      I      26          2.191
LGA    F    30_A      I      27          1.489
LGA    T    31_A      Q      28          1.450
LGA    G    32_A      G      29          1.026
LGA    W    33_A      Q      30          0.756
LGA    T    34_A      G      31          2.194
LGA    -       -      V      32           -
LGA    D    35_A      D      33          0.562
LGA    V    36_A      E      34          0.673
LGA    P    37_A      P      35          0.694
LGA    L    38_A      L      36          0.710
LGA    S    39_A      S      37          0.830
LGA    E    40_A      E      38          0.809
LGA    K    41_A      T      39          0.887
LGA    G    42_A      G      40          1.218
LGA    E    43_A      F      41          1.060
LGA    E    44_A      K      42          1.155
LGA    E    45_A      Q      43          1.133
LGA    A    46_A      A      44          1.291
LGA    I    47_A      A      45          1.291
LGA    A    48_A      A      46          1.107
LGA    A    49_A      A      47          1.231
LGA    G    50_A      G      48          1.531
LGA    K    51_A      I      49          1.092
LGA    Y    52_A      F      50          1.167
LGA    L    53_A      L      51          1.295
LGA    K    54_A      N      52          1.720
LGA    E    55_A      -       -           -
LGA    K    56_A      -       -           -
LGA    N    57_A      N      53          3.292
LGA    F    58_A      V      54          1.658
LGA    K    59_A      K      55          1.257
LGA    F    60_A      F      56          1.519
LGA    D    61_A      T      57          1.800
LGA    V    62_A      H      58          1.457
LGA    V    63_A      A      59          0.840
LGA    Y    64_A      F      60          0.915
LGA    T    65_A      S      61          1.003
LGA    S    66_A      S      62          0.794
LGA    V    67_A      D      63          0.929
LGA    L    68_A      L      64          0.802
LGA    K    69_A      M      65          0.437
LGA    R    70_A      R      66          0.235
LGA    A    71_A      T      67          0.340
LGA    I    72_A      K      68          0.584
LGA    C    73_A      Q      69          0.614
LGA    T    74_A      T      70          0.789
LGA    A    75_A      M      71          0.829
LGA    W    76_A      H      72          0.955
LGA    N    77_A      G      73          0.813
LGA    V    78_A      I      74          0.562
LGA    L    79_A      L      75          0.542
LGA    K    80_A      E      76          0.510
LGA    T    81_A      R      77          0.814
LGA    A    82_A      S      78          0.927
LGA    D    83_A      K      79          3.704
LGA    -       -      F      80           -
LGA    L    84_A      C      81          1.643
LGA    L    85_A      K      82          2.627
LGA    H    86_A      D      83          1.574
LGA    V    87_A      M      84          0.964
LGA    P    88_A      T      85          1.460
LGA    V    89_A      V      86          0.964
LGA    V    90_A      K      87          1.039
LGA    K    91_A      Y      88          0.813
LGA    T    92_A      D      89          1.483
LGA    W    93_A      S      90          1.483
LGA    R    94_A      R      91          0.992
LGA    L    95_A      L      92          0.660
LGA    N    96_A      R      93          0.592
LGA    E    97_A      E      94          0.605
LGA    R    98_A      R      95          0.414
LGA    H    99_A      K      96          0.416
LGA    Y   100_A      Y      97          0.449
LGA    G   101_A      G      98          1.332
LGA    S   102_A      V      99          0.797
LGA    L   103_A      V     100          0.632
LGA    Q   104_A      E     101          0.801
LGA    G   105_A      G     102          1.593
LGA    L   106_A      K     103          1.911
LGA    N   107_A      A     104          2.713
LGA    K   108_A      L     105          3.095
LGA    S   109_A      S     106          3.630
LGA    E   110_A      -       -           -
LGA    T   111_A      -       -           -
LGA    A   112_A      E     107          3.848
LGA    K   113_A      L     108           -
LGA    K   114_A      R     109           -
LGA    Y   115_A      A     110          4.287
LGA    G   116_A      -       -           -
LGA    E   117_A      -       -           -
LGA    E   118_A      M     111           #
LGA    Q   119_A      A     112          1.901
LGA    V   120_A      K     113          5.371
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    -       -      R     116           -
LGA    K   121_A      E     117           #
LGA    I   122_A      E     118          1.873
LGA    W   123_A      -       -           -
LGA    R   124_A      C     119          3.211
LGA    R   125_A      P     120          2.174
LGA    S   126_A      V     121          2.274
LGA    Y   127_A      -       -           -
LGA    D   128_A      -       -           -
LGA    I   129_A      F     122          3.292
LGA    P   130_A      T     123          1.235
LGA    P   131_A      P     124          0.948
LGA    P   132_A      P     125          1.814
LGA    K   133_A      G     126          2.708
LGA    L   134_A      -       -           -
LGA    D   135_A      -       -           -
LGA    K   136_A      -       -           -
LGA    E   137_A      -       -           -
LGA    D   138_A      -       -           -
LGA    N   139_A      -       -           -
LGA    R   140_A      -       -           -
LGA    W   141_A      -       -           -
LGA    P   142_A      -       -           -
LGA    G   143_A      -       -           -
LGA    H   144_A      -       -           -
LGA    N   145_A      -       -           -
LGA    V   146_A      -       -           -
LGA    V   147_A      -       -           -
LGA    Y   148_A      -       -           -
LGA    K   149_A      -       -           -
LGA    N   150_A      -       -           -
LGA    V   151_A      -       -           -
LGA    P   152_A      -       -           -
LGA    K   153_A      -       -           -
LGA    D   154_A      -       -           -
LGA    A   155_A      -       -           -
LGA    L   156_A      -       -           -
LGA    P   157_A      -       -           -
LGA    F   158_A      -       -           -
LGA    T   159_A      G     127          1.645
LGA    E   160_A      E     128          0.883
LGA    C   161_A      T     129          2.011
LGA    L   162_A      L     130          1.848
LGA    K   163_A      D     131          1.534
LGA    D   164_A      Q     132          1.102
LGA    T   165_A      V     133          0.891
LGA    V   166_A      K     134          0.971
LGA    E   167_A      M     135          1.129
LGA    R   168_A      R     136          2.150
LGA    V   169_A      G     137          2.584
LGA    L   170_A      I     138          1.512
LGA    P   171_A      D     139          1.200
LGA    F   172_A      F     140          1.860
LGA    W   173_A      F     141          1.615
LGA    F   174_A      E     142          0.885
LGA    D   175_A      F     143          1.789
LGA    H   176_A      L     144          3.197
LGA    I   177_A      -       -           -
LGA    A   178_A      C     145          1.474
LGA    P   179_A      Q     146          2.220
LGA    D   180_A      L     147          3.496
LGA    I   181_A      I     148          3.848
LGA    L   182_A      L     149          3.154
LGA    -       -      K     150           -
LGA    A   183_A      E     151          3.949
LGA    N   184_A      A     152          4.845
LGA    -       -      D     153           -
LGA    -       -      Q     154           -
LGA    -       -      K     155           -
LGA    -       -      N     165           -
LGA    -       -      C     166           -
LGA    -       -      L     167           -
LGA    -       -      E     168           -
LGA    -       -      T     169           -
LGA    -       -      S     170           -
LGA    -       -      L     171           -
LGA    -       -      A     172           -
LGA    -       -      E     173           -
LGA    -       -      I     174           -
LGA    -       -      F     175           -
LGA    -       -      P     176           -
LGA    -       -      L     177           -
LGA    -       -      I     191           -
LGA    -       -      P     192           -
LGA    -       -      G     193           -
LGA    -       -      L     194           -
LGA    -       -      A     195           -
LGA    K   185_A      A     196          2.302
LGA    K   186_A      S     197          1.685
LGA    V   187_A      V     198          0.751
LGA    M   188_A      L     199          0.655
LGA    V   189_A      V     200          0.757
LGA    A   190_A      V     201          0.517
LGA    A   191_A      S     202          0.654
LGA    H   192_A      H     203          0.616
LGA    G   193_A      G     204          1.209
LGA    N   194_A      A     205          1.573
LGA    S   195_A      Y     206          1.639
LGA    L   196_A      M     207          1.648
LGA    R   197_A      R     208          1.993
LGA    G   198_A      S     209          2.632
LGA    L   199_A      L     210          2.109
LGA    V   200_A      F     211          1.592
LGA    K   201_A      D     212          1.794
LGA    H   202_A      Y     213          2.106
LGA    L   203_A      F     214          2.010
LGA    D   204_A      L     215          2.222
LGA    N   205_A      T     216          2.873
LGA    L   206_A      D     217           #
LGA    S   207_A      L     218           -
LGA    E   208_A      K     219           -
LGA    A   209_A      C     220           -
LGA    -       -      S     221           -
LGA    -       -      L     222           -
LGA    -       -      P     223           -
LGA    -       -      A     224           -
LGA    -       -      T     225           -
LGA    -       -      L     226           -
LGA    -       -      S     227           -
LGA    D   210_A      R     228          5.102
LGA    V   211_A      -       -           -
LGA    L   212_A      S     229           #
LGA    E   213_A      E     230           #
LGA    L   214_A      L     231          2.740
LGA    -       -      M     232           -
LGA    -       -      S     233           -
LGA    N   215_A      V     234          1.405
LGA    I   216_A      T     235          2.166
LGA    P   217_A      P     236          2.022
LGA    T   218_A      N     237          1.727
LGA    G   219_A      T     238          0.919
LGA    V   220_A      G     239          2.480
LGA    P   221_A      M     240          2.119
LGA    L   222_A      S     241          1.213
LGA    V   223_A      L     242          1.327
LGA    Y   224_A      F     243          1.148
LGA    E   225_A      I     244          2.059
LGA    L   226_A      I     245          2.595
LGA    D   227_A      N     246          2.189
LGA    E   228_A      F     247          2.501
LGA    N   229_A      E     248          4.691
LGA    -       -      E     249           -
LGA    -       -      G     250           -
LGA    -       -      R     251           -
LGA    -       -      E     252           -
LGA    -       -      V     253           -
LGA    -       -      K     254           -
LGA    L   230_A      P     255          3.543
LGA    K   231_A      T     256          1.563
LGA    P   232_A      V     257          1.952
LGA    I   233_A      Q     258          2.925
LGA    K   234_A      C     259          3.791
LGA    H   235_A      I     260          1.412
LGA    Y   236_A      C     261          1.495
LGA    Y   237_A      M     262          4.731
LGA    -       -      N     263           -
LGA    L   238_A      L     264          4.896
LGA    -       -      Q     265           -
LGA    L   239_A      D     266          2.185
LGA    D   240_A      H     267           #
LGA    S   241_A      L     268           -
LGA    E   242_A      -       -           -
LGA    E   243_A      N     269          4.110
LGA    L   244_A      -       -           -
LGA    K   245_A      -       -           -
LGA    K   246_A      -       -           -
LGA    K   247_A      -       -           -
LGA    M   248_A      -       -           -
LGA    D   249_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  241  247    5.0    183    2.00    29.51     61.244     8.720

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.469080 * X  +  -0.726806 * Y  +   0.501714 * Z  +  66.961639
  Y_new =  -0.604053 * X  +   0.678466 * Y  +   0.418095 * Z  +  -4.005020
  Z_new =  -0.644270 * X  +  -0.106941 * Y  +  -0.757284 * Z  +  32.019527 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.001303    0.140289  [ DEG:  -171.9620      8.0380 ]
  Theta =   0.700068    2.441524  [ DEG:    40.1110    139.8890 ]
  Phi   =  -2.231077    0.910516  [ DEG:  -127.8313     52.1687 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1xq9_A                                        
REMARK     2: T0394.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1xq9_A.T0394.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  241  247   5.0  183   2.00   29.51  61.244
REMARK  ---------------------------------------------------------- 
MOLECULE 1xq9_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   11-OCT-04   1XQ9              
TITLE     STRUCTURE OF PHOSPHOGLYCERATE MUTASE FROM PLASMODIUM                  
TITLE    2 FALCIPARUM AT 2.6 RESOLUTION                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOGLYCERATE MUTASE;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: PGAM;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PLASMODIUM FALCIPARUM;                          
SOURCE   3 ORGANISM_COMMON: PLASMODIUM;                                         
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-STAR;                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: BG1861                                    
KEYWDS    PHOSPHOGLYCERATE, PGAM, GLYCOLYSIS, MUTASE, STRUCTURAL                
KEYWDS   2 GENOMICS, PROTEIN STRUCTURE INITIATIVE, PSI, STRUCTURAL              
KEYWDS   3 GENOMICS OF PATHOGENIC PROTOZOA CONSORTIUM, SGPP                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.M.CARUTHERS,W.G.J.HOL,STRUCTURAL GENOMICS OF PATHOGENIC             
AUTHOR   2 PROTOZOA CONSORTIUM (SGPP)                                           
REVDAT   1   21-DEC-04 1XQ9    0                                                
JRNL        AUTH   J.M.CARUTHERS,W.G.J.HOL,                                     
JRNL        AUTH 2 STRUCTURAL GENOMICS OF PATHOGENIC PROTOZOA                   
JRNL        AUTH 3 CONSORTIUM (SGPP)                                            
JRNL        TITL   STRUCTURE OF PHOSPHOGLYCERATE MUTASE FROM                    
JRNL        TITL 2 PLASMODIUM FALCIPARUM AT 2.6 RESOLUTION                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.58 ANGSTROMS.                                          
DBREF  1XQ9 A    9   258  GB     23508399 NP_701068        1    250             
DBREF  1XQ9 B    9   258  GB     23508399 NP_701068        1    250             
SEQRES   1 A  258  MET ALA HIS HIS HIS HIS HIS HIS MET THR THR TYR THR          
SEQRES   2 A  258  LEU VAL LEU LEU ARG HIS GLY GLU SER THR TRP ASN LYS          
SEQRES   3 A  258  GLU ASN LYS PHE THR GLY TRP THR ASP VAL PRO LEU SER          
SEQRES   4 A  258  GLU LYS GLY GLU GLU GLU ALA ILE ALA ALA GLY LYS TYR          
SEQRES   5 A  258  LEU LYS GLU LYS ASN PHE LYS PHE ASP VAL VAL TYR THR          
SEQRES   6 A  258  SER VAL LEU LYS ARG ALA ILE CYS THR ALA TRP ASN VAL          
SEQRES   7 A  258  LEU LYS THR ALA ASP LEU LEU HIS VAL PRO VAL VAL LYS          
SEQRES   8 A  258  THR TRP ARG LEU ASN GLU ARG HIS TYR GLY SER LEU GLN          
SEQRES   9 A  258  GLY LEU ASN LYS SER GLU THR ALA LYS LYS TYR GLY GLU          
SEQRES  10 A  258  GLU GLN VAL LYS ILE TRP ARG ARG SER TYR ASP ILE PRO          
SEQRES  11 A  258  PRO PRO LYS LEU ASP LYS GLU ASP ASN ARG TRP PRO GLY          
SEQRES  12 A  258  HIS ASN VAL VAL TYR LYS ASN VAL PRO LYS ASP ALA LEU          
SEQRES  13 A  258  PRO PHE THR GLU CYS LEU LYS ASP THR VAL GLU ARG VAL          
SEQRES  14 A  258  LEU PRO PHE TRP PHE ASP HIS ILE ALA PRO ASP ILE LEU          
SEQRES  15 A  258  ALA ASN LYS LYS VAL MET VAL ALA ALA HIS GLY ASN SER          
SEQRES  16 A  258  LEU ARG GLY LEU VAL LYS HIS LEU ASP ASN LEU SER GLU          
SEQRES  17 A  258  ALA ASP VAL LEU GLU LEU ASN ILE PRO THR GLY VAL PRO          
SEQRES  18 A  258  LEU VAL TYR GLU LEU ASP GLU ASN LEU LYS PRO ILE LYS          
SEQRES  19 A  258  HIS TYR TYR LEU LEU ASP SER GLU GLU LEU LYS LYS LYS          
SEQRES  20 A  258  MET ASP GLU VAL ALA ASN GLN GLY LYS ALA LYS                  
SEQRES   1 B  258  MET ALA HIS HIS HIS HIS HIS HIS MET THR THR TYR THR          
SEQRES   2 B  258  LEU VAL LEU LEU ARG HIS GLY GLU SER THR TRP ASN LYS          
SEQRES   3 B  258  GLU ASN LYS PHE THR GLY TRP THR ASP VAL PRO LEU SER          
SEQRES   4 B  258  GLU LYS GLY GLU GLU GLU ALA ILE ALA ALA GLY LYS TYR          
SEQRES   5 B  258  LEU LYS GLU LYS ASN PHE LYS PHE ASP VAL VAL TYR THR          
SEQRES   6 B  258  SER VAL LEU LYS ARG ALA ILE CYS THR ALA TRP ASN VAL          
SEQRES   7 B  258  LEU LYS THR ALA ASP LEU LEU HIS VAL PRO VAL VAL LYS          
SEQRES   8 B  258  THR TRP ARG LEU ASN GLU ARG HIS TYR GLY SER LEU GLN          
SEQRES   9 B  258  GLY LEU ASN LYS SER GLU THR ALA LYS LYS TYR GLY GLU          
SEQRES  10 B  258  GLU GLN VAL LYS ILE TRP ARG ARG SER TYR ASP ILE PRO          
SEQRES  11 B  258  PRO PRO LYS LEU ASP LYS GLU ASP ASN ARG TRP PRO GLY          
SEQRES  12 B  258  HIS ASN VAL VAL TYR LYS ASN VAL PRO LYS ASP ALA LEU          
SEQRES  13 B  258  PRO PHE THR GLU CYS LEU LYS ASP THR VAL GLU ARG VAL          
SEQRES  14 B  258  LEU PRO PHE TRP PHE ASP HIS ILE ALA PRO ASP ILE LEU          
SEQRES  15 B  258  ALA ASN LYS LYS VAL MET VAL ALA ALA HIS GLY ASN SER          
SEQRES  16 B  258  LEU ARG GLY LEU VAL LYS HIS LEU ASP ASN LEU SER GLU          
SEQRES  17 B  258  ALA ASP VAL LEU GLU LEU ASN ILE PRO THR GLY VAL PRO          
SEQRES  18 B  258  LEU VAL TYR GLU LEU ASP GLU ASN LEU LYS PRO ILE LYS          
SEQRES  19 B  258  HIS TYR TYR LEU LEU ASP SER GLU GLU LEU LYS LYS LYS          
SEQRES  20 B  258  MET ASP GLU VAL ALA ASN GLN GLY LYS ALA LYS                  
HET    SCN    500       3                                                       
HET    SCN    501       3                                                       
HET    SCN    502       3                                                       
HETNAM     SCN THIOCYANATE ION                                                  
FORMUL   3  SCN    3(C N S 1-)                                                  
FORMUL   6  HOH   *52(H2 O)                                                     
CRYST1  121.241   71.516   74.883  90.00 113.79  90.00 C 1 2 1       8          
ATOM      1  N   MET A   9       2.090  49.123  13.692  1.00 35.50           N  
ATOM      2  CA  MET A   9       2.655  50.223  14.553  1.00 35.91           C  
ATOM      3  C   MET A   9       4.194  50.206  14.659  1.00 35.34           C  
ATOM      4  O   MET A   9       4.800  51.252  14.923  1.00 35.75           O  
ATOM      5  CB  MET A   9       2.025  50.216  15.966  1.00 36.04           C  
ATOM      6  CG  MET A   9       2.083  48.856  16.716  1.00 38.41           C  
ATOM      7  SD  MET A   9       1.283  48.872  18.357  1.00 43.78           S  
ATOM      8  CE  MET A   9      -0.481  48.939  17.944  1.00 41.54           C  
ATOM      9  N   THR A  10       4.805  49.026  14.480  1.00 34.09           N  
ATOM     10  CA  THR A  10       6.260  48.846  14.639  1.00 33.02           C  
ATOM     11  C   THR A  10       6.938  47.961  13.567  1.00 32.12           C  
ATOM     12  O   THR A  10       6.433  46.898  13.187  1.00 31.66           O  
ATOM     13  CB  THR A  10       6.680  48.307  16.049  0.35 33.10           C  
ATOM     14  OG1 THR A  10       6.077  47.028  16.292  1.00 32.43           O  
ATOM     15  CG2 THR A  10       6.337  49.297  17.177  1.00 32.66           C  
ATOM     16  N   THR A  11       8.133  48.410  13.174  1.00 30.73           N  
ATOM     17  CA  THR A  11       8.857  47.958  12.005  1.00 29.06           C  
ATOM     18  C   THR A  11      10.276  47.605  12.423  1.00 28.20           C  
ATOM     19  O   THR A  11      10.881  48.313  13.223  1.00 28.87           O  
ATOM     20  CB  THR A  11       8.956  49.102  11.018  1.00 28.84           C  
ATOM     21  OG1 THR A  11       7.639  49.545  10.698  1.00 29.32           O  
ATOM     22  CG2 THR A  11       9.665  48.672   9.742  1.00 29.55           C  
ATOM     23  N   TYR A  12      10.814  46.519  11.881  1.00 26.11           N  
ATOM     24  CA  TYR A  12      12.196  46.168  12.126  1.00 24.03           C  
ATOM     25  C   TYR A  12      12.963  46.354  10.828  1.00 22.58           C  
ATOM     26  O   TYR A  12      12.370  46.249   9.746  1.00 22.81           O  
ATOM     27  CB  TYR A  12      12.295  44.715  12.583  1.00 23.89           C  
ATOM     28  CG  TYR A  12      11.662  44.399  13.928  1.00 24.04           C  
ATOM     29  CD1 TYR A  12      10.603  43.485  14.024  1.00 22.09           C  
ATOM     30  CD2 TYR A  12      12.133  44.989  15.115  1.00 24.18           C  
ATOM     31  CE1 TYR A  12      10.027  43.173  15.246  1.00 20.33           C  
ATOM     32  CE2 TYR A  12      11.552  44.664  16.350  1.00 22.75           C  
ATOM     33  CZ  TYR A  12      10.505  43.752  16.399  1.00 21.19           C  
ATOM     34  OH  TYR A  12       9.918  43.432  17.603  1.00 21.91           O  
ATOM     35  N   THR A  13      14.263  46.625  10.933  1.00 20.30           N  
ATOM     36  CA  THR A  13      15.144  46.690   9.767  1.00 18.72           C  
ATOM     37  C   THR A  13      16.319  45.706   9.834  1.00 18.15           C  
ATOM     38  O   THR A  13      17.181  45.792  10.731  1.00 19.03           O  
ATOM     39  CB  THR A  13      15.657  48.112   9.519  1.00 17.81           C  
ATOM     40  OG1 THR A  13      14.545  48.933   9.219  1.00 18.43           O  
ATOM     41  CG2 THR A  13      16.525  48.168   8.297  1.00 18.62           C  
ATOM     42  N   LEU A  14      16.353  44.795   8.859  1.00 16.70           N  
ATOM     43  CA  LEU A  14      17.438  43.849   8.658  1.00 15.43           C  
ATOM     44  C   LEU A  14      18.198  44.205   7.357  1.00 15.09           C  
ATOM     45  O   LEU A  14      17.567  44.540   6.332  1.00 13.35           O  
ATOM     46  CB  LEU A  14      16.858  42.423   8.610  1.00 15.38           C  
ATOM     47  CG  LEU A  14      17.758  41.238   8.217  1.00 16.26           C  
ATOM     48  CD1 LEU A  14      18.746  40.963   9.342  1.00 18.11           C  
ATOM     49  CD2 LEU A  14      16.999  39.939   7.881  1.00 12.60           C  
ATOM     50  N   VAL A  15      19.542  44.127   7.408  1.00 15.17           N  
ATOM     51  CA  VAL A  15      20.407  44.301   6.230  1.00 15.36           C  
ATOM     52  C   VAL A  15      21.178  43.045   5.805  1.00 16.54           C  
ATOM     53  O   VAL A  15      22.134  42.647   6.500  1.00 17.45           O  
ATOM     54  CB  VAL A  15      21.446  45.427   6.425  1.00 14.95           C  
ATOM     55  CG1 VAL A  15      22.331  45.542   5.198  1.00 13.63           C  
ATOM     56  CG2 VAL A  15      20.760  46.783   6.686  1.00 15.50           C  
ATOM     57  N   LEU A  16      20.817  42.444   4.657  1.00 17.10           N  
ATOM     58  CA  LEU A  16      21.664  41.341   4.071  1.00 17.53           C  
ATOM     59  C   LEU A  16      22.672  41.915   3.071  1.00 18.45           C  
ATOM     60  O   LEU A  16      22.307  42.825   2.301  1.00 18.82           O  
ATOM     61  CB  LEU A  16      20.832  40.217   3.433  1.00 16.06           C  
ATOM     62  CG  LEU A  16      19.612  39.860   4.265  1.00 14.05           C  
ATOM     63  CD1 LEU A  16      18.495  39.132   3.509  1.00 10.27           C  
ATOM     64  CD2 LEU A  16      20.042  39.109   5.491  1.00 13.87           C  
ATOM     65  N   LEU A  17      23.928  41.428   3.127  1.00 19.03           N  
ATOM     66  CA  LEU A  17      25.046  41.942   2.313  1.00 19.04           C  
ATOM     67  C   LEU A  17      25.828  40.750   1.793  1.00 20.15           C  
ATOM     68  O   LEU A  17      26.416  39.960   2.563  1.00 20.08           O  
ATOM     69  CB  LEU A  17      25.996  42.837   3.116  0.35 18.53           C  
ATOM     70  CG  LEU A  17      26.842  43.939   2.430  1.00 19.26           C  
ATOM     71  CD1 LEU A  17      28.268  44.090   3.010  1.00 14.87           C  
ATOM     72  CD2 LEU A  17      26.949  43.906   0.878  1.00 18.34           C  
ATOM     73  N   ARG A  18      25.847  40.610   0.476  1.00 20.88           N  
ATOM     74  CA  ARG A  18      26.630  39.549  -0.126  1.00 21.50           C  
ATOM     75  C   ARG A  18      28.064  40.041  -0.185  1.00 21.71           C  
ATOM     76  O   ARG A  18      28.306  41.235  -0.055  1.00 23.02           O  
ATOM     77  CB  ARG A  18      26.084  39.246  -1.507  1.00 21.27           C  
ATOM     78  CG  ARG A  18      26.721  38.027  -2.093  1.00 23.29           C  
ATOM     79  CD  ARG A  18      26.257  37.755  -3.480  1.00 23.40           C  
ATOM     80  NE  ARG A  18      27.264  36.971  -4.173  1.00 25.01           N  
ATOM     81  CZ  ARG A  18      27.066  36.333  -5.319  1.00 24.10           C  
ATOM     82  NH1 ARG A  18      25.886  36.362  -5.911  1.00 23.87           N  
ATOM     83  NH2 ARG A  18      28.065  35.660  -5.865  1.00 26.39           N  
ATOM     84  N   HIS A  19      29.036  39.164  -0.349  1.00 21.59           N  
ATOM     85  CA  HIS A  19      30.403  39.655  -0.437  1.00 20.89           C  
ATOM     86  C   HIS A  19      30.756  39.970  -1.891  1.00 22.14           C  
ATOM     87  O   HIS A  19      30.229  39.356  -2.858  1.00 21.61           O  
ATOM     88  CB  HIS A  19      31.370  38.640   0.144  1.00 20.94           C  
ATOM     89  CG  HIS A  19      31.522  37.416  -0.702  1.00 19.76           C  
ATOM     90  ND1 HIS A  19      32.236  37.414  -1.877  1.00 18.44           N  
ATOM     91  CD2 HIS A  19      31.022  36.167  -0.564  1.00 19.98           C  
ATOM     92  CE1 HIS A  19      32.175  36.217  -2.426  1.00 19.78           C  
ATOM     93  NE2 HIS A  19      31.434  35.443  -1.655  1.00 20.12           N  
ATOM     94  N   GLY A  20      31.679  40.918  -2.051  1.00 23.03           N  
ATOM     95  CA  GLY A  20      32.082  41.377  -3.365  1.00 23.85           C  
ATOM     96  C   GLY A  20      32.941  40.327  -4.030  1.00 24.58           C  
ATOM     97  O   GLY A  20      33.208  39.296  -3.452  1.00 24.71           O  
ATOM     98  N   GLU A  21      33.368  40.605  -5.253  1.00 25.65           N  
ATOM     99  CA  GLU A  21      34.174  39.699  -6.048  1.00 26.70           C  
ATOM    100  C   GLU A  21      35.358  39.153  -5.249  1.00 26.74           C  
ATOM    101  O   GLU A  21      35.869  39.806  -4.350  1.00 26.38           O  
ATOM    102  CB  GLU A  21      34.669  40.446  -7.314  1.00 27.51           C  
ATOM    103  CG  GLU A  21      35.438  39.588  -8.334  1.00 27.30           C  
ATOM    104  CD  GLU A  21      36.283  40.419  -9.301  1.00 28.80           C  
ATOM    105  OE1 GLU A  21      37.382  40.890  -8.913  1.00 28.87           O  
ATOM    106  OE2 GLU A  21      35.850  40.590 -10.460  1.00 29.33           O  
ATOM    107  N   SER A  22      35.795  37.951  -5.595  1.00 27.51           N  
ATOM    108  CA  SER A  22      36.964  37.348  -4.954  1.00 28.17           C  
ATOM    109  C   SER A  22      38.044  37.022  -5.997  1.00 28.63           C  
ATOM    110  O   SER A  22      37.835  37.204  -7.201  1.00 28.80           O  
ATOM    111  CB  SER A  22      36.561  36.078  -4.203  1.00 27.48           C  
ATOM    112  OG  SER A  22      36.655  34.976  -5.068  1.00 26.60           O  
ATOM    113  N   THR A  23      39.183  36.522  -5.536  1.00 29.19           N  
ATOM    114  CA  THR A  23      40.237  36.127  -6.448  1.00 30.40           C  
ATOM    115  C   THR A  23      39.752  35.067  -7.469  1.00 31.24           C  
ATOM    116  O   THR A  23      40.111  35.116  -8.640  1.00 31.82           O  
ATOM    117  CB  THR A  23      41.541  35.702  -5.694  1.00 30.31           C  
ATOM    118  OG1 THR A  23      41.253  34.648  -4.768  1.00 30.09           O  
ATOM    119  CG2 THR A  23      42.143  36.886  -4.942  1.00 29.91           C  
ATOM    120  N   TRP A  24      38.901  34.143  -7.049  1.00 32.36           N  
ATOM    121  CA  TRP A  24      38.513  33.049  -7.942  1.00 33.18           C  
ATOM    122  C   TRP A  24      37.499  33.413  -9.037  1.00 34.35           C  
ATOM    123  O   TRP A  24      37.451  32.765 -10.081  1.00 34.83           O  
ATOM    124  CB  TRP A  24      38.138  31.796  -7.146  1.00 32.25           C  
ATOM    125  CG  TRP A  24      39.370  31.046  -6.758  1.00 31.70           C  
ATOM    126  CD1 TRP A  24      40.643  31.542  -6.713  1.00 30.65           C  
ATOM    127  CD2 TRP A  24      39.467  29.670  -6.358  1.00 31.74           C  
ATOM    128  NE1 TRP A  24      41.524  30.566  -6.318  1.00 30.58           N  
ATOM    129  CE2 TRP A  24      40.833  29.407  -6.099  1.00 31.75           C  
ATOM    130  CE3 TRP A  24      38.538  28.634  -6.202  1.00 30.90           C  
ATOM    131  CZ2 TRP A  24      41.286  28.156  -5.676  1.00 32.86           C  
ATOM    132  CZ3 TRP A  24      38.987  27.393  -5.790  1.00 30.77           C  
ATOM    133  CH2 TRP A  24      40.348  27.163  -5.530  1.00 32.73           C  
ATOM    134  N   ASN A  25      36.730  34.474  -8.829  1.00 35.81           N  
ATOM    135  CA  ASN A  25      35.750  34.909  -9.821  1.00 37.26           C  
ATOM    136  C   ASN A  25      36.339  35.120 -11.214  1.00 37.91           C  
ATOM    137  O   ASN A  25      35.696  34.823 -12.220  1.00 38.47           O  
ATOM    138  CB  ASN A  25      35.039  36.184  -9.360  1.00 37.64           C  
ATOM    139  CG  ASN A  25      34.607  37.067 -10.529  1.00 38.74           C  
ATOM    140  OD1 ASN A  25      33.541  36.871 -11.142  1.00 38.64           O  
ATOM    141  ND2 ASN A  25      35.446  38.041 -10.853  1.00 39.91           N  
ATOM    142  N   LYS A  26      37.552  35.652 -11.275  1.00 38.68           N  
ATOM    143  CA  LYS A  26      38.246  35.775 -12.546  1.00 39.10           C  
ATOM    144  C   LYS A  26      39.176  34.590 -12.781  1.00 39.38           C  
ATOM    145  O   LYS A  26      40.318  34.778 -13.186  1.00 39.74           O  
ATOM    146  CB  LYS A  26      38.993  37.117 -12.643  1.00 39.24           C  
ATOM    147  CG  LYS A  26      38.077  38.306 -12.971  1.00 39.81           C  
ATOM    148  CD  LYS A  26      37.098  37.888 -14.081  1.00 41.24           C  
ATOM    149  CE  LYS A  26      35.825  38.716 -14.126  1.00 40.70           C  
ATOM    150  NZ  LYS A  26      35.054  38.374 -15.357  1.00 39.27           N  
ATOM    151  N   GLU A  27      38.680  33.370 -12.530  1.00 39.34           N  
ATOM    152  CA  GLU A  27      39.466  32.129 -12.718  1.00 38.79           C  
ATOM    153  C   GLU A  27      38.639  30.898 -13.084  1.00 37.87           C  
ATOM    154  O   GLU A  27      39.157  29.934 -13.657  1.00 37.74           O  
ATOM    155  CB  GLU A  27      40.325  31.816 -11.488  1.00 39.14           C  
ATOM    156  CG  GLU A  27      41.666  32.521 -11.496  1.00 40.26           C  
ATOM    157  CD  GLU A  27      42.824  31.572 -11.328  1.00 42.73           C  
ATOM    158  OE1 GLU A  27      42.751  30.429 -11.847  1.00 42.78           O  
ATOM    159  OE2 GLU A  27      43.818  31.976 -10.685  1.00 44.40           O  
ATOM    160  N   ASN A  28      37.361  30.931 -12.736  1.00 36.88           N  
ATOM    161  CA  ASN A  28      36.421  29.869 -13.109  1.00 36.35           C  
ATOM    162  C   ASN A  28      36.547  28.512 -12.408  1.00 35.20           C  
ATOM    163  O   ASN A  28      36.007  27.526 -12.864  1.00 35.29           O  
ATOM    164  CB  ASN A  28      36.343  29.709 -14.623  1.00 36.36           C  
ATOM    165  CG  ASN A  28      35.238  30.540 -15.215  1.00 39.22           C  
ATOM    166  OD1 ASN A  28      35.371  31.759 -15.401  1.00 40.93           O  
ATOM    167  ND2 ASN A  28      34.114  29.890 -15.503  1.00 42.61           N  
ATOM    168  N   LYS A  29      37.251  28.478 -11.288  1.00 34.18           N  
ATOM    169  CA  LYS A  29      37.252  27.318 -10.414  1.00 32.91           C  
ATOM    170  C   LYS A  29      35.998  27.373  -9.528  1.00 31.81           C  
ATOM    171  O   LYS A  29      35.628  28.451  -9.055  1.00 32.44           O  
ATOM    172  CB  LYS A  29      38.503  27.346  -9.524  1.00 33.09           C  
ATOM    173  CG  LYS A  29      39.835  27.284 -10.251  1.00 32.66           C  
ATOM    174  CD  LYS A  29      40.910  27.976  -9.444  0.50 34.09           C  
ATOM    175  CE  LYS A  29      42.257  27.303  -9.627  1.00 34.85           C  
ATOM    176  NZ  LYS A  29      42.308  26.020  -8.844  1.00 36.78           N  
ATOM    177  N   PHE A  30      35.349  26.229  -9.311  1.00 30.02           N  
ATOM    178  CA  PHE A  30      34.374  26.060  -8.217  1.00 28.12           C  
ATOM    179  C   PHE A  30      35.048  26.286  -6.867  1.00 27.10           C  
ATOM    180  O   PHE A  30      36.055  25.650  -6.553  1.00 27.02           O  
ATOM    181  CB  PHE A  30      33.844  24.639  -8.185  1.00 28.24           C  
ATOM    182  CG  PHE A  30      33.144  24.198  -9.445  1.00 28.56           C  
ATOM    183  CD1 PHE A  30      31.961  24.828  -9.872  1.00 27.32           C  
ATOM    184  CD2 PHE A  30      33.641  23.122 -10.180  1.00 25.95           C  
ATOM    185  CE1 PHE A  30      31.288  24.398 -11.006  1.00 26.86           C  
ATOM    186  CE2 PHE A  30      32.965  22.690 -11.333  1.00 26.95           C  
ATOM    187  CZ  PHE A  30      31.794  23.328 -11.745  1.00 26.04           C  
ATOM    188  N   THR A  31      34.475  27.174  -6.062  1.00 25.50           N  
ATOM    189  CA  THR A  31      35.089  27.617  -4.821  1.00 24.17           C  
ATOM    190  C   THR A  31      34.463  27.044  -3.540  1.00 22.72           C  
ATOM    191  O   THR A  31      35.181  26.564  -2.678  1.00 22.73           O  
ATOM    192  CB  THR A  31      35.249  29.196  -4.792  1.00 24.81           C  
ATOM    193  OG1 THR A  31      34.934  29.722  -3.491  1.00 26.66           O  
ATOM    194  CG2 THR A  31      34.388  29.880  -5.868  1.00 23.62           C  
ATOM    195  N   GLY A  32      33.143  27.105  -3.402  1.00 21.47           N  
ATOM    196  CA  GLY A  32      32.443  26.601  -2.189  1.00 19.93           C  
ATOM    197  C   GLY A  32      33.025  27.087  -0.852  1.00 18.47           C  
ATOM    198  O   GLY A  32      33.067  28.288  -0.563  1.00 16.83           O  
ATOM    199  N   TRP A  33      33.479  26.138  -0.045  1.00 18.16           N  
ATOM    200  CA  TRP A  33      34.094  26.448   1.250  1.00 17.86           C  
ATOM    201  C   TRP A  33      35.588  26.754   1.172  1.00 17.48           C  
ATOM    202  O   TRP A  33      36.189  26.884   2.226  1.00 17.79           O  
ATOM    203  CB  TRP A  33      33.896  25.316   2.266  1.00 16.72           C  
ATOM    204  CG  TRP A  33      32.546  25.221   2.952  1.00 16.52           C  
ATOM    205  CD1 TRP A  33      31.301  25.491   2.412  1.00 16.41           C  
ATOM    206  CD2 TRP A  33      32.298  24.749   4.284  1.00 13.96           C  
ATOM    207  NE1 TRP A  33      30.318  25.234   3.336  1.00 13.25           N  
ATOM    208  CE2 TRP A  33      30.896  24.768   4.486  1.00 13.23           C  
ATOM    209  CE3 TRP A  33      33.119  24.312   5.316  1.00 11.31           C  
ATOM    210  CZ2 TRP A  33      30.309  24.390   5.689  1.00 12.32           C  
ATOM    211  CZ3 TRP A  33      32.538  23.912   6.491  1.00 13.95           C  
ATOM    212  CH2 TRP A  33      31.139  23.950   6.670  1.00 13.06           C  
ATOM    213  N   THR A  34      36.176  26.830  -0.032  1.00 17.41           N  
ATOM    214  CA  THR A  34      37.617  27.145  -0.191  1.00 18.02           C  
ATOM    215  C   THR A  34      37.896  28.577   0.219  1.00 18.48           C  
ATOM    216  O   THR A  34      37.231  29.494  -0.247  1.00 18.99           O  
ATOM    217  CB  THR A  34      38.147  27.010  -1.631  1.00 17.90           C  
ATOM    218  OG1 THR A  34      37.729  25.764  -2.189  1.00 17.92           O  
ATOM    219  CG2 THR A  34      39.692  27.079  -1.645  1.00 17.09           C  
ATOM    220  N   ASP A  35      38.897  28.784   1.070  1.00 19.12           N  
ATOM    221  CA  ASP A  35      38.973  30.060   1.725  1.00 19.63           C  
ATOM    222  C   ASP A  35      39.670  31.170   0.937  1.00 19.24           C  
ATOM    223  O   ASP A  35      40.703  31.642   1.369  1.00 19.33           O  
ATOM    224  CB  ASP A  35      39.480  29.949   3.161  1.00 19.73           C  
ATOM    225  CG  ASP A  35      38.972  31.089   4.013  1.00 21.31           C  
ATOM    226  OD1 ASP A  35      37.828  31.522   3.792  1.00 24.24           O  
ATOM    227  OD2 ASP A  35      39.703  31.596   4.873  1.00 25.12           O  
ATOM    228  N   VAL A  36      39.079  31.616  -0.177  1.00 18.83           N  
ATOM    229  CA  VAL A  36      39.760  32.620  -1.018  1.00 19.41           C  
ATOM    230  C   VAL A  36      39.473  34.032  -0.512  1.00 19.69           C  
ATOM    231  O   VAL A  36      38.370  34.327   0.006  1.00 18.91           O  
ATOM    232  CB  VAL A  36      39.463  32.503  -2.571  1.00 19.58           C  
ATOM    233  CG1 VAL A  36      39.786  31.112  -3.122  1.00 17.92           C  
ATOM    234  CG2 VAL A  36      38.013  32.868  -2.891  1.00 21.16           C  
ATOM    235  N   PRO A  37      40.485  34.903  -0.604  1.00 20.27           N  
ATOM    236  CA  PRO A  37      40.355  36.327  -0.220  1.00 19.97           C  
ATOM    237  C   PRO A  37      39.526  37.110  -1.213  1.00 20.11           C  
ATOM    238  O   PRO A  37      39.351  36.678  -2.348  1.00 19.82           O  
ATOM    239  CB  PRO A  37      41.806  36.842  -0.266  1.00 20.06           C  
ATOM    240  CG  PRO A  37      42.521  35.930  -1.278  1.00 19.86           C  
ATOM    241  CD  PRO A  37      41.859  34.556  -1.030  1.00 20.50           C  
ATOM    242  N   LEU A  38      39.039  38.273  -0.798  1.00 20.49           N  
ATOM    243  CA  LEU A  38      38.531  39.246  -1.746  1.00 20.62           C  
ATOM    244  C   LEU A  38      39.612  39.675  -2.787  1.00 20.65           C  
ATOM    245  O   LEU A  38      40.814  39.502  -2.567  1.00 20.41           O  
ATOM    246  CB  LEU A  38      38.030  40.464  -0.966  1.00 21.10           C  
ATOM    247  CG  LEU A  38      36.733  40.355  -0.149  1.00 21.37           C  
ATOM    248  CD1 LEU A  38      36.489  41.691   0.581  1.00 20.40           C  
ATOM    249  CD2 LEU A  38      35.528  39.929  -1.019  1.00 18.65           C  
ATOM    250  N   SER A  39      39.192  40.221  -3.922  1.00 20.86           N  
ATOM    251  CA  SER A  39      40.143  40.835  -4.853  1.00 21.36           C  
ATOM    252  C   SER A  39      40.143  42.347  -4.625  1.00 22.02           C  
ATOM    253  O   SER A  39      39.277  42.869  -3.903  1.00 21.99           O  
ATOM    254  CB  SER A  39      39.766  40.519  -6.298  1.00 21.01           C  
ATOM    255  OG  SER A  39      38.632  41.266  -6.712  1.00 21.34           O  
ATOM    256  N   GLU A  40      41.094  43.055  -5.233  1.00 22.65           N  
ATOM    257  CA  GLU A  40      41.093  44.518  -5.169  1.00 23.31           C  
ATOM    258  C   GLU A  40      39.657  45.020  -5.317  1.00 23.52           C  
ATOM    259  O   GLU A  40      39.183  45.774  -4.484  1.00 23.56           O  
ATOM    260  CB  GLU A  40      41.997  45.133  -6.255  1.00 23.44           C  
ATOM    261  CG  GLU A  40      43.446  45.386  -5.813  1.00 24.91           C  
ATOM    262  CD  GLU A  40      44.061  46.679  -6.407  1.00 25.51           C  
ATOM    263  OE1 GLU A  40      44.350  46.697  -7.620  1.00 25.26           O  
ATOM    264  OE2 GLU A  40      44.269  47.672  -5.659  1.00 25.66           O  
ATOM    265  N   LYS A  41      38.956  44.566  -6.358  1.00 23.99           N  
ATOM    266  CA  LYS A  41      37.608  45.053  -6.656  1.00 24.70           C  
ATOM    267  C   LYS A  41      36.557  44.753  -5.547  1.00 25.07           C  
ATOM    268  O   LYS A  41      35.769  45.632  -5.196  1.00 25.25           O  
ATOM    269  CB  LYS A  41      37.156  44.633  -8.077  1.00 24.20           C  
ATOM    270  CG  LYS A  41      35.712  45.022  -8.412  1.00 26.78           C  
ATOM    271  CD  LYS A  41      35.495  45.488  -9.859  1.00 32.32           C  
ATOM    272  CE  LYS A  41      35.427  44.311 -10.868  1.00 36.84           C  
ATOM    273  NZ  LYS A  41      34.428  43.230 -10.516  1.00 38.64           N  
ATOM    274  N   GLY A  42      36.548  43.537  -4.994  1.00 25.66           N  
ATOM    275  CA  GLY A  42      35.599  43.182  -3.906  1.00 26.22           C  
ATOM    276  C   GLY A  42      35.850  43.918  -2.588  1.00 26.87           C  
ATOM    277  O   GLY A  42      34.952  44.075  -1.760  1.00 26.97           O  
ATOM    278  N   GLU A  43      37.087  44.364  -2.391  1.00 27.22           N  
ATOM    279  CA  GLU A  43      37.430  45.211  -1.286  1.00 27.70           C  
ATOM    280  C   GLU A  43      36.754  46.558  -1.511  1.00 27.97           C  
ATOM    281  O   GLU A  43      36.174  47.142  -0.579  1.00 28.76           O  
ATOM    282  CB  GLU A  43      38.951  45.386  -1.206  1.00 27.59           C  
ATOM    283  CG  GLU A  43      39.707  44.112  -0.823  1.00 29.31           C  
ATOM    284  CD  GLU A  43      39.856  43.927   0.680  1.00 32.36           C  
ATOM    285  OE1 GLU A  43      39.951  44.949   1.391  1.00 32.72           O  
ATOM    286  OE2 GLU A  43      39.877  42.765   1.156  1.00 33.58           O  
ATOM    287  N   GLU A  44      36.827  47.050  -2.747  1.00 27.47           N  
ATOM    288  CA  GLU A  44      36.160  48.300  -3.121  1.00 27.06           C  
ATOM    289  C   GLU A  44      34.661  48.214  -2.940  1.00 25.68           C  
ATOM    290  O   GLU A  44      34.060  49.185  -2.543  1.00 26.43           O  
ATOM    291  CB  GLU A  44      36.471  48.706  -4.566  1.00 27.90           C  
ATOM    292  CG  GLU A  44      37.884  49.317  -4.821  1.00 30.35           C  
ATOM    293  CD  GLU A  44      38.239  49.355  -6.324  1.00 34.98           C  
ATOM    294  OE1 GLU A  44      39.226  50.045  -6.697  1.00 36.56           O  
ATOM    295  OE2 GLU A  44      37.531  48.688  -7.134  1.00 35.56           O  
ATOM    296  N   GLU A  45      34.061  47.061  -3.228  1.00 24.17           N  
ATOM    297  CA  GLU A  45      32.620  46.857  -3.058  1.00 22.72           C  
ATOM    298  C   GLU A  45      32.144  46.962  -1.607  1.00 21.93           C  
ATOM    299  O   GLU A  45      31.107  47.542  -1.329  1.00 22.14           O  
ATOM    300  CB  GLU A  45      32.195  45.521  -3.657  0.81 22.84           C  
ATOM    301  CG  GLU A  45      32.038  45.542  -5.181  0.81 24.03           C  
ATOM    302  CD  GLU A  45      31.805  44.164  -5.774  0.81 23.35           C  
ATOM    303  OE1 GLU A  45      30.743  43.588  -5.545  0.81 26.93           O  
ATOM    304  OE2 GLU A  45      32.663  43.652  -6.492  0.81 24.38           O  
ATOM    305  N   ALA A  46      32.908  46.411  -0.674  1.00 21.07           N  
ATOM    306  CA  ALA A  46      32.543  46.476   0.734  1.00 20.03           C  
ATOM    307  C   ALA A  46      32.741  47.867   1.363  1.00 19.51           C  
ATOM    308  O   ALA A  46      31.968  48.256   2.240  1.00 19.87           O  
ATOM    309  CB  ALA A  46      33.280  45.423   1.525  1.00 19.78           C  
ATOM    310  N   ILE A  47      33.775  48.598   0.945  1.00 18.23           N  
ATOM    311  CA  ILE A  47      33.960  49.959   1.409  1.00 17.01           C  
ATOM    312  C   ILE A  47      32.788  50.775   0.900  1.00 17.20           C  
ATOM    313  O   ILE A  47      32.166  51.483   1.685  1.00 17.39           O  
ATOM    314  CB  ILE A  47      35.343  50.606   0.960  1.00 17.48           C  
ATOM    315  CG1 ILE A  47      36.513  50.057   1.795  1.00 15.95           C  
ATOM    316  CG2 ILE A  47      35.309  52.155   1.054  1.00 12.71           C  
ATOM    317  CD1 ILE A  47      37.843  50.054   1.083  1.00 14.17           C  
ATOM    318  N   ALA A  48      32.480  50.672  -0.396  1.00 17.26           N  
ATOM    319  CA  ALA A  48      31.371  51.438  -0.994  1.00 18.10           C  
ATOM    320  C   ALA A  48      30.065  51.167  -0.228  1.00 18.79           C  
ATOM    321  O   ALA A  48      29.436  52.076   0.289  1.00 18.21           O  
ATOM    322  CB  ALA A  48      31.221  51.126  -2.457  1.00 17.14           C  
ATOM    323  N   ALA A  49      29.712  49.893  -0.101  1.00 20.05           N  
ATOM    324  CA  ALA A  49      28.524  49.487   0.634  1.00 20.80           C  
ATOM    325  C   ALA A  49      28.490  50.194   1.955  1.00 21.48           C  
ATOM    326  O   ALA A  49      27.528  50.887   2.242  1.00 21.84           O  
ATOM    327  CB  ALA A  49      28.485  47.981   0.802  1.00 20.18           C  
ATOM    328  N   GLY A  50      29.562  50.048   2.731  1.00 23.52           N  
ATOM    329  CA  GLY A  50      29.752  50.751   4.003  1.00 25.66           C  
ATOM    330  C   GLY A  50      29.493  52.259   3.922  1.00 27.61           C  
ATOM    331  O   GLY A  50      28.787  52.822   4.775  1.00 27.46           O  
ATOM    332  N   LYS A  51      30.058  52.893   2.883  1.00 29.06           N  
ATOM    333  CA  LYS A  51      29.881  54.326   2.565  1.00 30.10           C  
ATOM    334  C   LYS A  51      28.413  54.709   2.372  1.00 31.14           C  
ATOM    335  O   LYS A  51      27.966  55.758   2.847  1.00 32.04           O  
ATOM    336  CB  LYS A  51      30.712  54.684   1.324  0.35 29.82           C  
ATOM    337  CG  LYS A  51      30.552  56.092   0.802  0.35 29.53           C  
ATOM    338  CD  LYS A  51      31.405  56.302  -0.447  0.35 29.04           C  
ATOM    339  CE  LYS A  51      30.988  57.554  -1.216  0.35 28.25           C  
ATOM    340  NZ  LYS A  51      31.103  58.784  -0.393  0.35 27.33           N  
ATOM    341  N   TYR A  52      27.671  53.851   1.690  1.00 31.81           N  
ATOM    342  CA  TYR A  52      26.274  54.089   1.434  1.00 33.24           C  
ATOM    343  C   TYR A  52      25.509  53.933   2.743  1.00 33.28           C  
ATOM    344  O   TYR A  52      24.601  54.725   3.064  1.00 33.31           O  
ATOM    345  CB  TYR A  52      25.746  53.105   0.377  1.00 34.10           C  
ATOM    346  CG  TYR A  52      24.833  53.766  -0.635  1.00 38.10           C  
ATOM    347  CD1 TYR A  52      25.326  54.173  -1.875  1.00 41.61           C  
ATOM    348  CD2 TYR A  52      23.482  54.019  -0.339  1.00 40.63           C  
ATOM    349  CE1 TYR A  52      24.494  54.814  -2.812  1.00 43.53           C  
ATOM    350  CE2 TYR A  52      22.648  54.644  -1.260  1.00 42.68           C  
ATOM    351  CZ  TYR A  52      23.160  55.042  -2.494  1.00 44.32           C  
ATOM    352  OH  TYR A  52      22.345  55.670  -3.413  1.00 46.32           O  
ATOM    353  N   LEU A  53      25.878  52.912   3.510  1.00 33.04           N  
ATOM    354  CA  LEU A  53      25.191  52.666   4.768  1.00 32.50           C  
ATOM    355  C   LEU A  53      25.374  53.881   5.681  1.00 32.18           C  
ATOM    356  O   LEU A  53      24.395  54.395   6.219  1.00 32.29           O  
ATOM    357  CB  LEU A  53      25.598  51.315   5.399  1.00 32.33           C  
ATOM    358  CG  LEU A  53      25.134  50.055   4.623  1.00 32.07           C  
ATOM    359  CD1 LEU A  53      25.816  48.750   5.066  1.00 31.13           C  
ATOM    360  CD2 LEU A  53      23.620  49.875   4.649  1.00 31.48           C  
ATOM    361  N   LYS A  54      26.612  54.368   5.785  1.00 32.00           N  
ATOM    362  CA  LYS A  54      26.947  55.550   6.595  1.00 31.87           C  
ATOM    363  C   LYS A  54      26.105  56.753   6.161  1.00 32.20           C  
ATOM    364  O   LYS A  54      25.472  57.406   7.001  1.00 32.21           O  
ATOM    365  CB  LYS A  54      28.448  55.874   6.513  0.35 31.62           C  
ATOM    366  CG  LYS A  54      28.869  57.204   7.149  0.35 30.75           C  
ATOM    367  CD  LYS A  54      29.184  57.082   8.632  0.35 30.03           C  
ATOM    368  CE  LYS A  54      29.119  58.436   9.348  0.35 29.55           C  
ATOM    369  NZ  LYS A  54      30.140  59.407   8.867  0.35 28.70           N  
ATOM    370  N   GLU A  55      26.078  57.013   4.852  1.00 31.93           N  
ATOM    371  CA  GLU A  55      25.429  58.211   4.319  1.00 32.34           C  
ATOM    372  C   GLU A  55      23.934  58.206   4.535  1.00 31.69           C  
ATOM    373  O   GLU A  55      23.341  59.261   4.615  1.00 31.69           O  
ATOM    374  CB  GLU A  55      25.749  58.430   2.827  1.00 32.64           C  
ATOM    375  CG  GLU A  55      27.160  59.001   2.574  1.00 35.35           C  
ATOM    376  CD  GLU A  55      27.628  58.893   1.113  1.00 38.94           C  
ATOM    377  OE1 GLU A  55      26.956  58.199   0.303  1.00 38.49           O  
ATOM    378  OE2 GLU A  55      28.683  59.507   0.787  1.00 39.51           O  
ATOM    379  N   LYS A  56      23.337  57.017   4.640  1.00 31.40           N  
ATOM    380  CA  LYS A  56      21.878  56.880   4.750  1.00 30.31           C  
ATOM    381  C   LYS A  56      21.482  56.667   6.181  1.00 29.38           C  
ATOM    382  O   LYS A  56      20.297  56.534   6.475  1.00 28.68           O  
ATOM    383  CB  LYS A  56      21.350  55.721   3.889  1.00 30.52           C  
ATOM    384  CG  LYS A  56      21.260  56.017   2.414  1.00 31.05           C  
ATOM    385  CD  LYS A  56      20.204  57.066   2.148  1.00 33.70           C  
ATOM    386  CE  LYS A  56      20.757  58.198   1.287  1.00 34.40           C  
ATOM    387  NZ  LYS A  56      19.654  58.928   0.623  1.00 36.23           N  
ATOM    388  N   ASN A  57      22.500  56.600   7.047  1.00 28.70           N  
ATOM    389  CA  ASN A  57      22.344  56.552   8.502  1.00 28.10           C  
ATOM    390  C   ASN A  57      21.842  55.218   9.064  1.00 27.32           C  
ATOM    391  O   ASN A  57      21.042  55.196   9.984  1.00 27.55           O  
ATOM    392  CB  ASN A  57      21.488  57.731   9.000  1.00 28.30           C  
ATOM    393  CG  ASN A  57      22.284  59.005   9.140  1.00 29.90           C  
ATOM    394  OD1 ASN A  57      23.134  59.111  10.034  1.00 34.01           O  
ATOM    395  ND2 ASN A  57      22.025  59.992   8.264  1.00 29.35           N  
ATOM    396  N   PHE A  58      22.309  54.109   8.503  1.00 27.00           N  
ATOM    397  CA  PHE A  58      22.084  52.773   9.090  1.00 26.05           C  
ATOM    398  C   PHE A  58      23.099  52.449  10.178  1.00 25.89           C  
ATOM    399  O   PHE A  58      24.313  52.469   9.926  1.00 26.30           O  
ATOM    400  CB  PHE A  58      22.180  51.703   8.021  1.00 25.64           C  
ATOM    401  CG  PHE A  58      20.959  51.600   7.157  1.00 26.27           C  
ATOM    402  CD1 PHE A  58      20.817  52.409   6.035  1.00 26.47           C  
ATOM    403  CD2 PHE A  58      19.952  50.688   7.466  1.00 24.99           C  
ATOM    404  CE1 PHE A  58      19.688  52.307   5.233  1.00 28.15           C  
ATOM    405  CE2 PHE A  58      18.822  50.584   6.685  1.00 25.82           C  
ATOM    406  CZ  PHE A  58      18.690  51.380   5.553  1.00 27.26           C  
ATOM    407  N   LYS A  59      22.601  52.159  11.380  1.00 25.30           N  
ATOM    408  CA  LYS A  59      23.433  51.704  12.499  1.00 24.98           C  
ATOM    409  C   LYS A  59      23.210  50.215  12.749  1.00 24.57           C  
ATOM    410  O   LYS A  59      22.123  49.705  12.449  1.00 24.56           O  
ATOM    411  CB  LYS A  59      23.113  52.485  13.767  1.00 25.32           C  
ATOM    412  CG  LYS A  59      23.147  54.003  13.617  1.00 25.52           C  
ATOM    413  CD  LYS A  59      24.429  54.495  13.007  1.00 27.90           C  
ATOM    414  CE  LYS A  59      24.819  55.826  13.599  1.00 30.29           C  
ATOM    415  NZ  LYS A  59      25.642  55.599  14.831  1.00 33.65           N  
ATOM    416  N   PHE A  60      24.245  49.527  13.256  1.00 23.76           N  
ATOM    417  CA  PHE A  60      24.165  48.095  13.631  1.00 22.77           C  
ATOM    418  C   PHE A  60      24.484  47.853  15.122  1.00 21.92           C  
ATOM    419  O   PHE A  60      25.294  48.552  15.682  1.00 21.52           O  
ATOM    420  CB  PHE A  60      25.006  47.174  12.689  1.00 22.10           C  
ATOM    421  CG  PHE A  60      24.725  47.384  11.232  1.00 20.99           C  
ATOM    422  CD1 PHE A  60      23.444  47.147  10.704  1.00 20.92           C  
ATOM    423  CD2 PHE A  60      25.731  47.844  10.370  1.00 21.71           C  
ATOM    424  CE1 PHE A  60      23.161  47.374   9.317  1.00 19.32           C  
ATOM    425  CE2 PHE A  60      25.466  48.084   8.972  1.00 20.40           C  
ATOM    426  CZ  PHE A  60      24.174  47.840   8.458  1.00 19.13           C  
ATOM    427  N   ASP A  61      23.796  46.886  15.741  1.00 21.86           N  
ATOM    428  CA  ASP A  61      24.112  46.379  17.079  1.00 21.49           C  
ATOM    429  C   ASP A  61      24.894  45.042  16.993  1.00 21.45           C  
ATOM    430  O   ASP A  61      25.684  44.736  17.889  1.00 22.42           O  
ATOM    431  CB  ASP A  61      22.839  46.181  17.919  1.00 21.40           C  
ATOM    432  CG  ASP A  61      22.027  47.476  18.105  1.00 22.17           C  
ATOM    433  OD1 ASP A  61      20.879  47.557  17.608  1.00 20.40           O  
ATOM    434  OD2 ASP A  61      22.527  48.422  18.750  1.00 23.13           O  
ATOM    435  N   VAL A  62      24.671  44.252  15.936  1.00 20.64           N  
ATOM    436  CA  VAL A  62      25.340  42.956  15.726  1.00 19.59           C  
ATOM    437  C   VAL A  62      25.602  42.706  14.248  1.00 19.59           C  
ATOM    438  O   VAL A  62      24.770  43.008  13.381  1.00 20.44           O  
ATOM    439  CB  VAL A  62      24.488  41.716  16.180  1.00 19.71           C  
ATOM    440  CG1 VAL A  62      25.429  40.557  16.639  1.00 19.78           C  
ATOM    441  CG2 VAL A  62      23.507  42.045  17.265  1.00 17.97           C  
ATOM    442  N   VAL A  63      26.733  42.106  13.955  1.00 19.44           N  
ATOM    443  CA  VAL A  63      26.994  41.644  12.606  1.00 20.27           C  
ATOM    444  C   VAL A  63      27.226  40.154  12.689  1.00 20.42           C  
ATOM    445  O   VAL A  63      28.013  39.686  13.515  1.00 21.69           O  
ATOM    446  CB  VAL A  63      28.217  42.348  11.953  1.00 20.52           C  
ATOM    447  CG1 VAL A  63      28.499  41.757  10.605  1.00 20.05           C  
ATOM    448  CG2 VAL A  63      27.957  43.870  11.824  1.00 20.80           C  
ATOM    449  N   TYR A  64      26.498  39.411  11.866  1.00 20.08           N  
ATOM    450  CA  TYR A  64      26.668  37.978  11.743  1.00 19.15           C  
ATOM    451  C   TYR A  64      27.411  37.692  10.440  1.00 18.61           C  
ATOM    452  O   TYR A  64      27.142  38.340   9.434  1.00 18.65           O  
ATOM    453  CB  TYR A  64      25.303  37.304  11.777  1.00 19.14           C  
ATOM    454  CG  TYR A  64      24.695  37.320  13.150  1.00 20.03           C  
ATOM    455  CD1 TYR A  64      25.169  36.477  14.147  1.00 20.66           C  
ATOM    456  CD2 TYR A  64      23.660  38.208  13.467  1.00 23.05           C  
ATOM    457  CE1 TYR A  64      24.625  36.500  15.432  1.00 22.61           C  
ATOM    458  CE2 TYR A  64      23.093  38.249  14.766  1.00 22.03           C  
ATOM    459  CZ  TYR A  64      23.588  37.394  15.743  1.00 23.25           C  
ATOM    460  OH  TYR A  64      23.053  37.427  17.024  1.00 21.49           O  
ATOM    461  N   THR A  65      28.357  36.755  10.452  1.00 17.60           N  
ATOM    462  CA  THR A  65      29.051  36.384   9.211  1.00 17.40           C  
ATOM    463  C   THR A  65      29.463  34.886   9.144  1.00 17.20           C  
ATOM    464  O   THR A  65      29.286  34.102  10.095  1.00 17.43           O  
ATOM    465  CB  THR A  65      30.253  37.366   8.901  1.00 18.09           C  
ATOM    466  OG1 THR A  65      30.719  37.191   7.558  1.00 18.01           O  
ATOM    467  CG2 THR A  65      31.458  37.177   9.894  1.00 18.01           C  
ATOM    468  N   SER A  66      29.998  34.477   8.009  1.00 16.44           N  
ATOM    469  CA  SER A  66      30.403  33.109   7.870  1.00 16.42           C  
ATOM    470  C   SER A  66      31.738  33.036   8.556  1.00 16.59           C  
ATOM    471  O   SER A  66      32.167  34.009   9.217  1.00 17.21           O  
ATOM    472  CB  SER A  66      30.548  32.740   6.395  1.00 16.59           C  
ATOM    473  OG  SER A  66      31.725  33.320   5.855  1.00 15.90           O  
ATOM    474  N   VAL A  67      32.424  31.916   8.403  1.00 15.84           N  
ATOM    475  CA  VAL A  67      33.796  31.877   8.901  1.00 15.70           C  
ATOM    476  C   VAL A  67      34.747  31.918   7.694  1.00 17.15           C  
ATOM    477  O   VAL A  67      35.953  31.715   7.826  1.00 18.39           O  
ATOM    478  CB  VAL A  67      34.079  30.725   9.964  1.00 14.58           C  
ATOM    479  CG1 VAL A  67      33.210  30.910  11.192  1.00 12.45           C  
ATOM    480  CG2 VAL A  67      33.830  29.388   9.412  1.00 11.96           C  
ATOM    481  N   LEU A  68      34.205  32.236   6.520  1.00 17.58           N  
ATOM    482  CA  LEU A  68      35.042  32.346   5.325  1.00 18.18           C  
ATOM    483  C   LEU A  68      35.531  33.784   5.120  1.00 19.37           C  
ATOM    484  O   LEU A  68      34.738  34.727   5.016  1.00 21.10           O  
ATOM    485  CB  LEU A  68      34.297  31.826   4.102  1.00 17.58           C  
ATOM    486  CG  LEU A  68      34.355  30.346   3.760  1.00 16.65           C  
ATOM    487  CD1 LEU A  68      35.171  29.524   4.735  1.00 14.88           C  
ATOM    488  CD2 LEU A  68      32.958  29.826   3.598  1.00 13.65           C  
ATOM    489  N   LYS A  69      36.843  33.933   5.097  1.00 19.85           N  
ATOM    490  CA  LYS A  69      37.576  35.198   4.972  1.00 20.06           C  
ATOM    491  C   LYS A  69      36.921  36.269   4.104  1.00 20.49           C  
ATOM    492  O   LYS A  69      36.970  37.467   4.410  1.00 22.10           O  
ATOM    493  CB  LYS A  69      38.929  34.817   4.367  1.00 20.58           C  
ATOM    494  CG  LYS A  69      40.085  35.717   4.512  1.00 18.92           C  
ATOM    495  CD  LYS A  69      41.075  35.352   3.370  1.00 20.25           C  
ATOM    496  CE  LYS A  69      42.314  34.566   3.839  1.00 20.95           C  
ATOM    497  NZ  LYS A  69      41.932  33.230   4.367  1.00 21.46           N  
ATOM    498  N   ARG A  70      36.313  35.861   3.004  1.00 20.59           N  
ATOM    499  CA  ARG A  70      35.832  36.829   2.045  1.00 20.05           C  
ATOM    500  C   ARG A  70      34.623  37.561   2.559  1.00 20.11           C  
ATOM    501  O   ARG A  70      34.326  38.659   2.073  1.00 21.17           O  
ATOM    502  CB  ARG A  70      35.553  36.182   0.689  1.00 20.09           C  
ATOM    503  CG  ARG A  70      34.693  34.923   0.737  1.00 21.03           C  
ATOM    504  CD  ARG A  70      34.831  34.221  -0.581  1.00 23.12           C  
ATOM    505  NE  ARG A  70      33.807  33.216  -0.854  1.00 24.58           N  
ATOM    506  CZ  ARG A  70      33.947  31.892  -0.716  1.00 25.29           C  
ATOM    507  NH1 ARG A  70      35.059  31.336  -0.240  1.00 22.05           N  
ATOM    508  NH2 ARG A  70      32.928  31.112  -1.048  1.00 29.08           N  
ATOM    509  N   ALA A  71      33.910  36.981   3.525  1.00 19.64           N  
ATOM    510  CA  ALA A  71      32.747  37.672   4.091  1.00 19.18           C  
ATOM    511  C   ALA A  71      33.155  38.470   5.318  1.00 19.04           C  
ATOM    512  O   ALA A  71      32.759  39.628   5.467  1.00 18.26           O  
ATOM    513  CB  ALA A  71      31.626  36.705   4.399  1.00 19.72           C  
ATOM    514  N   ILE A  72      33.986  37.853   6.166  1.00 18.39           N  
ATOM    515  CA  ILE A  72      34.627  38.558   7.273  1.00 17.69           C  
ATOM    516  C   ILE A  72      35.274  39.886   6.832  1.00 18.07           C  
ATOM    517  O   ILE A  72      34.995  40.913   7.458  1.00 18.79           O  
ATOM    518  CB  ILE A  72      35.613  37.635   8.070  1.00 17.91           C  
ATOM    519  CG1 ILE A  72      34.888  36.381   8.566  1.00 17.06           C  
ATOM    520  CG2 ILE A  72      36.235  38.357   9.282  1.00 15.64           C  
ATOM    521  CD1 ILE A  72      35.779  35.184   8.643  1.00 19.86           C  
ATOM    522  N   CYS A  73      36.094  39.916   5.772  1.00 17.91           N  
ATOM    523  CA  CYS A  73      36.649  41.221   5.313  1.00 18.38           C  
ATOM    524  C   CYS A  73      35.584  42.232   4.881  1.00 18.35           C  
ATOM    525  O   CYS A  73      35.744  43.441   5.073  1.00 17.81           O  
ATOM    526  CB  CYS A  73      37.601  41.033   4.175  1.00 18.18           C  
ATOM    527  SG  CYS A  73      38.960  39.992   4.636  1.00 23.80           S  
ATOM    528  N   THR A  74      34.501  41.718   4.299  1.00 18.42           N  
ATOM    529  CA  THR A  74      33.350  42.503   3.920  1.00 18.68           C  
ATOM    530  C   THR A  74      32.705  43.195   5.116  1.00 18.88           C  
ATOM    531  O   THR A  74      32.581  44.434   5.125  1.00 19.18           O  
ATOM    532  CB  THR A  74      32.305  41.624   3.194  1.00 18.83           C  
ATOM    533  OG1 THR A  74      32.952  40.926   2.113  1.00 21.14           O  
ATOM    534  CG2 THR A  74      31.204  42.454   2.643  1.00 15.37           C  
ATOM    535  N   ALA A  75      32.288  42.410   6.106  1.00 18.69           N  
ATOM    536  CA  ALA A  75      31.749  42.963   7.352  1.00 18.81           C  
ATOM    537  C   ALA A  75      32.707  44.009   7.897  1.00 18.51           C  
ATOM    538  O   ALA A  75      32.276  45.128   8.245  1.00 18.42           O  
ATOM    539  CB  ALA A  75      31.496  41.858   8.418  1.00 18.93           C  
ATOM    540  N   TRP A  76      33.993  43.654   7.937  1.00 17.94           N  
ATOM    541  CA  TRP A  76      35.007  44.498   8.543  1.00 18.10           C  
ATOM    542  C   TRP A  76      35.158  45.821   7.808  1.00 18.90           C  
ATOM    543  O   TRP A  76      35.169  46.884   8.430  1.00 20.56           O  
ATOM    544  CB  TRP A  76      36.333  43.772   8.646  1.00 18.11           C  
ATOM    545  CG  TRP A  76      37.471  44.654   8.993  1.00 19.39           C  
ATOM    546  CD1 TRP A  76      38.378  45.179   8.139  1.00 19.91           C  
ATOM    547  CD2 TRP A  76      37.813  45.145  10.299  1.00 22.71           C  
ATOM    548  NE1 TRP A  76      39.278  45.976   8.814  1.00 21.29           N  
ATOM    549  CE2 TRP A  76      38.951  45.981  10.145  1.00 22.47           C  
ATOM    550  CE3 TRP A  76      37.274  44.956  11.590  1.00 22.74           C  
ATOM    551  CZ2 TRP A  76      39.573  46.625  11.235  1.00 20.75           C  
ATOM    552  CZ3 TRP A  76      37.886  45.599  12.668  1.00 23.01           C  
ATOM    553  CH2 TRP A  76      39.032  46.419  12.480  1.00 21.38           C  
ATOM    554  N   ASN A  77      35.238  45.782   6.489  1.00 19.20           N  
ATOM    555  CA  ASN A  77      35.375  47.001   5.703  1.00 18.60           C  
ATOM    556  C   ASN A  77      34.184  47.903   5.809  1.00 18.44           C  
ATOM    557  O   ASN A  77      34.357  49.121   5.733  1.00 18.65           O  
ATOM    558  CB  ASN A  77      35.641  46.675   4.242  1.00 18.78           C  
ATOM    559  CG  ASN A  77      37.097  46.356   3.991  1.00 19.09           C  
ATOM    560  OD1 ASN A  77      37.953  46.846   4.720  1.00 18.87           O  
ATOM    561  ND2 ASN A  77      37.396  45.563   2.941  1.00 18.80           N  
ATOM    562  N   VAL A  78      32.997  47.319   6.010  1.00 18.05           N  
ATOM    563  CA  VAL A  78      31.766  48.097   6.178  1.00 18.27           C  
ATOM    564  C   VAL A  78      31.835  48.827   7.497  1.00 18.72           C  
ATOM    565  O   VAL A  78      31.583  50.038   7.569  1.00 18.65           O  
ATOM    566  CB  VAL A  78      30.455  47.211   6.163  1.00 18.81           C  
ATOM    567  CG1 VAL A  78      29.226  47.971   6.796  1.00 16.97           C  
ATOM    568  CG2 VAL A  78      30.120  46.749   4.762  1.00 18.54           C  
ATOM    569  N   LEU A  79      32.180  48.089   8.547  1.00 19.02           N  
ATOM    570  CA  LEU A  79      32.193  48.678   9.867  1.00 19.12           C  
ATOM    571  C   LEU A  79      33.249  49.794   9.961  1.00 18.89           C  
ATOM    572  O   LEU A  79      32.995  50.835  10.597  1.00 18.12           O  
ATOM    573  CB  LEU A  79      32.391  47.606  10.950  1.00 19.51           C  
ATOM    574  CG  LEU A  79      31.297  46.543  11.154  1.00 20.23           C  
ATOM    575  CD1 LEU A  79      31.843  45.458  12.050  1.00 18.07           C  
ATOM    576  CD2 LEU A  79      30.010  47.152  11.759  1.00 23.46           C  
ATOM    577  N   LYS A  80      34.412  49.576   9.333  1.00 18.43           N  
ATOM    578  CA  LYS A  80      35.494  50.565   9.366  1.00 19.37           C  
ATOM    579  C   LYS A  80      35.006  51.857   8.722  1.00 19.82           C  
ATOM    580  O   LYS A  80      35.006  52.926   9.337  1.00 19.22           O  
ATOM    581  CB  LYS A  80      36.766  50.055   8.675  1.00 19.11           C  
ATOM    582  CG  LYS A  80      37.973  50.939   8.889  1.00 20.99           C  
ATOM    583  CD  LYS A  80      39.194  50.498   8.063  1.00 24.83           C  
ATOM    584  CE  LYS A  80      39.549  51.512   6.959  1.00 27.86           C  
ATOM    585  NZ  LYS A  80      38.461  51.696   5.906  1.00 26.77           N  
ATOM    586  N   THR A  81      34.535  51.721   7.492  1.00 20.68           N  
ATOM    587  CA  THR A  81      34.019  52.840   6.738  1.00 21.81           C  
ATOM    588  C   THR A  81      32.882  53.548   7.513  1.00 21.83           C  
ATOM    589  O   THR A  81      32.838  54.760   7.571  1.00 21.31           O  
ATOM    590  CB  THR A  81      33.530  52.353   5.345  1.00 22.16           C  
ATOM    591  OG1 THR A  81      34.604  51.698   4.652  1.00 21.49           O  
ATOM    592  CG2 THR A  81      32.971  53.528   4.498  1.00 23.20           C  
ATOM    593  N   ALA A  82      31.974  52.769   8.097  1.00 22.53           N  
ATOM    594  CA  ALA A  82      30.800  53.314   8.804  1.00 23.12           C  
ATOM    595  C   ALA A  82      31.081  53.696  10.265  1.00 23.48           C  
ATOM    596  O   ALA A  82      30.167  54.189  10.955  1.00 24.68           O  
ATOM    597  CB  ALA A  82      29.587  52.338   8.717  1.00 22.49           C  
ATOM    598  N   ASP A  83      32.325  53.483  10.728  1.00 22.76           N  
ATOM    599  CA  ASP A  83      32.739  53.873  12.082  1.00 21.74           C  
ATOM    600  C   ASP A  83      31.953  53.131  13.145  1.00 21.09           C  
ATOM    601  O   ASP A  83      31.355  53.737  14.040  1.00 21.19           O  
ATOM    602  CB  ASP A  83      32.572  55.362  12.301  1.00 21.57           C  
ATOM    603  CG  ASP A  83      33.652  55.930  13.182  1.00 24.07           C  
ATOM    604  OD1 ASP A  83      33.385  56.931  13.849  1.00 27.03           O  
ATOM    605  OD2 ASP A  83      34.788  55.396  13.203  1.00 27.56           O  
ATOM    606  N   LEU A  84      31.920  51.813  13.013  1.00 19.71           N  
ATOM    607  CA  LEU A  84      31.221  50.994  13.940  1.00 18.70           C  
ATOM    608  C   LEU A  84      32.089  49.794  14.295  1.00 18.77           C  
ATOM    609  O   LEU A  84      31.582  48.680  14.462  1.00 18.81           O  
ATOM    610  CB  LEU A  84      29.911  50.544  13.301  1.00 19.15           C  
ATOM    611  CG  LEU A  84      28.821  51.613  13.105  1.00 18.91           C  
ATOM    612  CD1 LEU A  84      27.617  51.053  12.298  1.00 16.86           C  
ATOM    613  CD2 LEU A  84      28.384  52.135  14.446  1.00 17.27           C  
ATOM    614  N   LEU A  85      33.403  50.021  14.411  1.00 18.55           N  
ATOM    615  CA  LEU A  85      34.350  48.938  14.653  1.00 17.67           C  
ATOM    616  C   LEU A  85      34.125  48.266  15.985  1.00 17.70           C  
ATOM    617  O   LEU A  85      34.535  47.116  16.185  1.00 17.45           O  
ATOM    618  CB  LEU A  85      35.794  49.391  14.518  1.00 17.10           C  
ATOM    619  CG  LEU A  85      36.554  49.123  13.201  1.00 16.73           C  
ATOM    620  CD1 LEU A  85      35.891  48.160  12.166  1.00 14.94           C  
ATOM    621  CD2 LEU A  85      36.964  50.400  12.538  1.00 17.46           C  
ATOM    622  N   HIS A  86      33.422  48.972  16.866  1.00 17.56           N  
ATOM    623  CA  HIS A  86      33.143  48.492  18.216  1.00 18.10           C  
ATOM    624  C   HIS A  86      32.036  47.437  18.199  1.00 18.39           C  
ATOM    625  O   HIS A  86      31.824  46.759  19.200  1.00 19.31           O  
ATOM    626  CB  HIS A  86      32.711  49.663  19.120  1.00 17.57           C  
ATOM    627  CG  HIS A  86      31.422  50.302  18.686  1.00 18.08           C  
ATOM    628  ND1 HIS A  86      31.374  51.335  17.771  1.00 17.81           N  
ATOM    629  CD2 HIS A  86      30.130  50.019  19.003  1.00 16.99           C  
ATOM    630  CE1 HIS A  86      30.109  51.674  17.561  1.00 18.51           C  
ATOM    631  NE2 HIS A  86      29.335  50.883  18.287  1.00 16.71           N  
ATOM    632  N   VAL A  87      31.304  47.321  17.087  1.00 18.30           N  
ATOM    633  CA  VAL A  87      30.137  46.436  17.026  1.00 17.86           C  
ATOM    634  C   VAL A  87      30.540  44.958  17.040  1.00 18.54           C  
ATOM    635  O   VAL A  87      31.434  44.566  16.294  1.00 18.99           O  
ATOM    636  CB  VAL A  87      29.281  46.732  15.780  1.00 18.23           C  
ATOM    637  CG1 VAL A  87      28.584  45.496  15.295  1.00 14.36           C  
ATOM    638  CG2 VAL A  87      28.306  47.887  16.073  1.00 16.07           C  
ATOM    639  N   PRO A  88      29.878  44.134  17.882  1.00 18.43           N  
ATOM    640  CA  PRO A  88      30.344  42.770  18.043  1.00 18.06           C  
ATOM    641  C   PRO A  88      30.080  42.011  16.780  1.00 17.90           C  
ATOM    642  O   PRO A  88      29.100  42.279  16.106  1.00 19.01           O  
ATOM    643  CB  PRO A  88      29.499  42.226  19.202  1.00 18.26           C  
ATOM    644  CG  PRO A  88      28.349  43.169  19.354  1.00 18.83           C  
ATOM    645  CD  PRO A  88      28.662  44.430  18.667  1.00 18.29           C  
ATOM    646  N   VAL A  89      30.960  41.080  16.443  1.00 17.94           N  
ATOM    647  CA  VAL A  89      30.873  40.287  15.206  1.00 16.86           C  
ATOM    648  C   VAL A  89      30.822  38.780  15.557  1.00 16.67           C  
ATOM    649  O   VAL A  89      31.657  38.271  16.305  1.00 16.24           O  
ATOM    650  CB  VAL A  89      32.082  40.628  14.232  1.00 16.81           C  
ATOM    651  CG1 VAL A  89      32.194  39.615  13.076  1.00 15.64           C  
ATOM    652  CG2 VAL A  89      31.964  42.058  13.692  1.00 14.56           C  
ATOM    653  N   VAL A  90      29.828  38.082  15.020  1.00 16.79           N  
ATOM    654  CA  VAL A  90      29.600  36.669  15.325  1.00 16.32           C  
ATOM    655  C   VAL A  90      29.802  35.946  14.021  1.00 16.82           C  
ATOM    656  O   VAL A  90      29.160  36.297  13.017  1.00 16.30           O  
ATOM    657  CB  VAL A  90      28.161  36.373  15.866  1.00 16.26           C  
ATOM    658  CG1 VAL A  90      28.067  34.924  16.409  1.00 14.50           C  
ATOM    659  CG2 VAL A  90      27.758  37.375  16.931  1.00 13.90           C  
ATOM    660  N   LYS A  91      30.732  34.982  14.041  1.00 17.26           N  
ATOM    661  CA  LYS A  91      31.139  34.211  12.862  1.00 18.11           C  
ATOM    662  C   LYS A  91      30.637  32.775  12.951  1.00 18.75           C  
ATOM    663  O   LYS A  91      30.870  32.086  13.953  1.00 19.05           O  
ATOM    664  CB  LYS A  91      32.664  34.225  12.741  1.00 18.39           C  
ATOM    665  CG  LYS A  91      33.266  35.633  12.718  1.00 19.05           C  
ATOM    666  CD  LYS A  91      34.753  35.673  13.005  1.00 17.97           C  
ATOM    667  CE  LYS A  91      35.138  37.094  13.394  1.00 16.15           C  
ATOM    668  NZ  LYS A  91      36.594  37.320  13.242  1.00 16.10           N  
ATOM    669  N   THR A  92      29.927  32.303  11.939  1.00 19.27           N  
ATOM    670  CA  THR A  92      29.405  30.929  12.039  1.00 19.89           C  
ATOM    671  C   THR A  92      29.474  30.160  10.714  1.00 19.76           C  
ATOM    672  O   THR A  92      29.156  30.723   9.647  1.00 19.09           O  
ATOM    673  CB  THR A  92      27.957  30.885  12.622  1.00 20.38           C  
ATOM    674  OG1 THR A  92      27.454  29.538  12.562  1.00 20.31           O  
ATOM    675  CG2 THR A  92      27.020  31.846  11.816  1.00 20.96           C  
ATOM    676  N   TRP A  93      29.889  28.875  10.804  1.00 19.31           N  
ATOM    677  CA  TRP A  93      30.032  28.016   9.647  1.00 17.75           C  
ATOM    678  C   TRP A  93      28.668  27.930   9.008  1.00 17.20           C  
ATOM    679  O   TRP A  93      28.534  27.805   7.784  1.00 17.03           O  
ATOM    680  CB  TRP A  93      30.539  26.640  10.057  1.00 17.91           C  
ATOM    681  CG  TRP A  93      29.555  25.776  10.838  1.00 19.40           C  
ATOM    682  CD1 TRP A  93      29.437  25.703  12.207  1.00 20.60           C  
ATOM    683  CD2 TRP A  93      28.602  24.829  10.309  1.00 17.96           C  
ATOM    684  NE1 TRP A  93      28.463  24.799  12.547  1.00 21.54           N  
ATOM    685  CE2 TRP A  93      27.925  24.261  11.407  1.00 19.02           C  
ATOM    686  CE3 TRP A  93      28.224  24.450   9.020  1.00 18.67           C  
ATOM    687  CZ2 TRP A  93      26.902  23.316  11.255  1.00 18.67           C  
ATOM    688  CZ3 TRP A  93      27.214  23.493   8.865  1.00 18.47           C  
ATOM    689  CH2 TRP A  93      26.569  22.936   9.975  1.00 18.23           C  
ATOM    690  N   ARG A  94      27.648  28.056   9.858  1.00 16.61           N  
ATOM    691  CA  ARG A  94      26.255  27.979   9.421  1.00 15.84           C  
ATOM    692  C   ARG A  94      25.954  29.063   8.403  1.00 14.88           C  
ATOM    693  O   ARG A  94      24.983  28.940   7.677  1.00 14.57           O  
ATOM    694  CB  ARG A  94      25.264  27.990  10.603  1.00 15.66           C  
ATOM    695  CG  ARG A  94      25.699  27.062  11.799  1.00 18.51           C  
ATOM    696  CD  ARG A  94      24.549  26.644  12.701  1.00 18.30           C  
ATOM    697  NE  ARG A  94      23.731  25.800  11.882  1.00 22.38           N  
ATOM    698  CZ  ARG A  94      23.539  24.504  12.071  1.00 23.13           C  
ATOM    699  NH1 ARG A  94      24.053  23.888  13.129  1.00 22.96           N  
ATOM    700  NH2 ARG A  94      22.799  23.839  11.192  1.00 24.33           N  
ATOM    701  N   LEU A  95      26.795  30.096   8.296  1.00 14.18           N  
ATOM    702  CA  LEU A  95      26.556  31.090   7.247  1.00 14.32           C  
ATOM    703  C   LEU A  95      27.365  30.907   5.982  1.00 14.46           C  
ATOM    704  O   LEU A  95      27.237  31.712   5.077  1.00 13.93           O  
ATOM    705  CB  LEU A  95      26.711  32.524   7.733  1.00 14.33           C  
ATOM    706  CG  LEU A  95      25.499  33.115   8.419  1.00 15.44           C  
ATOM    707  CD1 LEU A  95      25.928  34.383   9.210  1.00 15.64           C  
ATOM    708  CD2 LEU A  95      24.375  33.389   7.447  1.00 14.46           C  
ATOM    709  N   ASN A  96      28.190  29.857   5.928  1.00 15.33           N  
ATOM    710  CA  ASN A  96      29.067  29.610   4.779  1.00 16.48           C  
ATOM    711  C   ASN A  96      28.368  29.529   3.403  1.00 16.44           C  
ATOM    712  O   ASN A  96      27.145  29.278   3.313  1.00 15.96           O  
ATOM    713  CB  ASN A  96      29.921  28.355   5.014  1.00 16.75           C  
ATOM    714  CG  ASN A  96      31.008  28.602   6.031  1.00 18.90           C  
ATOM    715  OD1 ASN A  96      31.191  29.740   6.453  1.00 22.48           O  
ATOM    716  ND2 ASN A  96      31.723  27.553   6.446  1.00 16.62           N  
ATOM    717  N   GLU A  97      29.150  29.750   2.345  1.00 16.06           N  
ATOM    718  CA  GLU A  97      28.740  29.343   0.992  1.00 16.83           C  
ATOM    719  C   GLU A  97      28.244  27.884   1.034  1.00 16.56           C  
ATOM    720  O   GLU A  97      28.640  27.110   1.912  1.00 16.75           O  
ATOM    721  CB  GLU A  97      29.915  29.521   0.018  1.00 16.76           C  
ATOM    722  CG  GLU A  97      29.664  29.270  -1.435  1.00 18.05           C  
ATOM    723  CD  GLU A  97      28.528  30.109  -2.050  1.00 21.48           C  
ATOM    724  OE1 GLU A  97      27.341  29.728  -1.953  1.00 22.12           O  
ATOM    725  OE2 GLU A  97      28.830  31.125  -2.703  1.00 23.21           O  
ATOM    726  N   ARG A  98      27.332  27.542   0.136  1.00 16.17           N  
ATOM    727  CA  ARG A  98      27.062  26.138  -0.192  1.00 16.73           C  
ATOM    728  C   ARG A  98      28.368  25.398  -0.549  1.00 17.11           C  
ATOM    729  O   ARG A  98      29.120  25.833  -1.417  1.00 17.69           O  
ATOM    730  CB  ARG A  98      26.042  26.024  -1.359  0.62 16.05           C  
ATOM    731  CG  ARG A  98      25.836  24.609  -1.895  0.62 14.04           C  
ATOM    732  CD  ARG A  98      24.817  24.544  -3.022  0.62 12.07           C  
ATOM    733  NE  ARG A  98      25.271  25.240  -4.228  0.62 13.40           N  
ATOM    734  CZ  ARG A  98      24.510  25.490  -5.295  0.62 11.94           C  
ATOM    735  NH1 ARG A  98      23.255  25.113  -5.306  0.62 11.83           N  
ATOM    736  NH2 ARG A  98      25.004  26.129  -6.346  0.62 11.13           N  
ATOM    737  N   HIS A  99      28.619  24.302   0.152  1.00 17.51           N  
ATOM    738  CA  HIS A  99      29.719  23.386  -0.116  1.00 18.55           C  
ATOM    739  C   HIS A  99      29.603  22.714  -1.477  1.00 19.12           C  
ATOM    740  O   HIS A  99      28.543  22.174  -1.781  1.00 21.20           O  
ATOM    741  CB  HIS A  99      29.720  22.318   0.978  1.00 18.08           C  
ATOM    742  CG  HIS A  99      31.049  21.657   1.161  1.00 18.98           C  
ATOM    743  ND1 HIS A  99      31.427  20.534   0.453  1.00 17.94           N  
ATOM    744  CD2 HIS A  99      32.114  21.995   1.924  1.00 18.43           C  
ATOM    745  CE1 HIS A  99      32.652  20.189   0.804  1.00 16.83           C  
ATOM    746  NE2 HIS A  99      33.086  21.050   1.706  1.00 16.64           N  
ATOM    747  N   TYR A 100      30.665  22.734  -2.289  1.00 20.18           N  
ATOM    748  CA  TYR A 100      30.681  22.142  -3.680  1.00 20.92           C  
ATOM    749  C   TYR A 100      31.253  20.691  -3.814  1.00 20.71           C  
ATOM    750  O   TYR A 100      31.606  20.256  -4.912  1.00 19.67           O  
ATOM    751  CB  TYR A 100      31.496  23.015  -4.661  1.00 21.74           C  
ATOM    752  CG  TYR A 100      31.035  24.429  -4.911  1.00 24.64           C  
ATOM    753  CD1 TYR A 100      29.692  24.830  -4.750  1.00 28.96           C  
ATOM    754  CD2 TYR A 100      31.944  25.360  -5.371  1.00 30.29           C  
ATOM    755  CE1 TYR A 100      29.288  26.208  -4.987  1.00 34.21           C  
ATOM    756  CE2 TYR A 100      31.573  26.736  -5.631  1.00 34.41           C  
ATOM    757  CZ  TYR A 100      30.267  27.163  -5.430  1.00 35.00           C  
ATOM    758  OH  TYR A 100      29.996  28.504  -5.690  1.00 32.39           O  
ATOM    759  N   GLY A 101      31.388  19.960  -2.714  1.00 20.35           N  
ATOM    760  CA  GLY A 101      31.802  18.566  -2.821  1.00 21.22           C  
ATOM    761  C   GLY A 101      33.168  18.316  -3.439  1.00 21.51           C  
ATOM    762  O   GLY A 101      34.134  19.003  -3.143  1.00 21.93           O  
ATOM    763  N   SER A 102      33.254  17.311  -4.295  1.00 21.83           N  
ATOM    764  CA  SER A 102      34.519  16.971  -4.914  1.00 22.19           C  
ATOM    765  C   SER A 102      34.845  17.959  -6.011  1.00 22.61           C  
ATOM    766  O   SER A 102      35.965  17.996  -6.506  1.00 23.68           O  
ATOM    767  CB  SER A 102      34.509  15.535  -5.449  1.00 21.97           C  
ATOM    768  OG  SER A 102      33.602  15.407  -6.521  1.00 21.60           O  
ATOM    769  N   LEU A 103      33.868  18.781  -6.372  1.00 23.40           N  
ATOM    770  CA  LEU A 103      34.063  19.876  -7.345  1.00 23.84           C  
ATOM    771  C   LEU A 103      34.985  21.031  -6.910  1.00 23.87           C  
ATOM    772  O   LEU A 103      35.509  21.735  -7.758  1.00 23.62           O  
ATOM    773  CB  LEU A 103      32.716  20.444  -7.792  1.00 23.64           C  
ATOM    774  CG  LEU A 103      31.829  19.409  -8.462  1.00 23.19           C  
ATOM    775  CD1 LEU A 103      30.497  20.047  -8.861  1.00 23.70           C  
ATOM    776  CD2 LEU A 103      32.550  18.844  -9.661  1.00 23.24           C  
ATOM    777  N   GLN A 104      35.185  21.192  -5.603  1.00 24.89           N  
ATOM    778  CA  GLN A 104      35.904  22.335  -5.024  1.00 26.00           C  
ATOM    779  C   GLN A 104      37.284  22.351  -5.576  1.00 27.22           C  
ATOM    780  O   GLN A 104      37.909  21.292  -5.708  1.00 27.96           O  
ATOM    781  CB  GLN A 104      36.019  22.174  -3.517  1.00 25.74           C  
ATOM    782  CG  GLN A 104      35.870  23.436  -2.707  1.00 25.31           C  
ATOM    783  CD  GLN A 104      35.381  23.159  -1.251  1.00 25.92           C  
ATOM    784  OE1 GLN A 104      36.177  22.767  -0.379  1.00 25.36           O  
ATOM    785  NE2 GLN A 104      34.075  23.359  -1.004  1.00 21.02           N  
ATOM    786  N   GLY A 105      37.776  23.540  -5.892  1.00 28.31           N  
ATOM    787  CA  GLY A 105      39.120  23.675  -6.446  1.00 29.69           C  
ATOM    788  C   GLY A 105      39.211  23.344  -7.930  1.00 30.59           C  
ATOM    789  O   GLY A 105      40.134  23.809  -8.597  1.00 30.55           O  
ATOM    790  N   LEU A 106      38.253  22.566  -8.439  1.00 31.57           N  
ATOM    791  CA  LEU A 106      38.214  22.144  -9.852  1.00 33.29           C  
ATOM    792  C   LEU A 106      37.685  23.192 -10.870  1.00 34.52           C  
ATOM    793  O   LEU A 106      36.830  24.021 -10.542  1.00 34.48           O  
ATOM    794  CB  LEU A 106      37.483  20.798  -9.985  1.00 32.90           C  
ATOM    795  CG  LEU A 106      38.311  19.522  -9.771  1.00 32.51           C  
ATOM    796  CD1 LEU A 106      38.437  19.158  -8.315  1.00 33.34           C  
ATOM    797  CD2 LEU A 106      37.676  18.352 -10.503  1.00 34.16           C  
ATOM    798  N   ASN A 107      38.211  23.140 -12.099  1.00 36.20           N  
ATOM    799  CA  ASN A 107      37.907  24.107 -13.174  1.00 38.05           C  
ATOM    800  C   ASN A 107      36.566  23.838 -13.863  1.00 38.84           C  
ATOM    801  O   ASN A 107      36.308  22.715 -14.326  1.00 38.89           O  
ATOM    802  CB  ASN A 107      39.045  24.114 -14.213  1.00 38.58           C  
ATOM    803  CG  ASN A 107      38.957  25.299 -15.197  1.00 41.11           C  
ATOM    804  OD1 ASN A 107      38.034  25.384 -16.023  1.00 44.12           O  
ATOM    805  ND2 ASN A 107      39.941  26.195 -15.133  1.00 42.54           N  
ATOM    806  N   LYS A 108      35.728  24.872 -13.947  1.00 39.72           N  
ATOM    807  CA  LYS A 108      34.350  24.725 -14.439  1.00 40.70           C  
ATOM    808  C   LYS A 108      34.291  24.061 -15.791  1.00 41.43           C  
ATOM    809  O   LYS A 108      33.492  23.158 -15.982  1.00 41.66           O  
ATOM    810  CB  LYS A 108      33.609  26.070 -14.505  1.00 40.64           C  
ATOM    811  CG  LYS A 108      32.878  26.469 -13.249  1.00 39.90           C  
ATOM    812  CD  LYS A 108      32.663  27.979 -13.204  1.00 39.85           C  
ATOM    813  CE  LYS A 108      31.926  28.417 -11.922  1.00 39.80           C  
ATOM    814  NZ  LYS A 108      32.105  29.887 -11.646  1.00 39.82           N  
ATOM    815  N   SER A 109      35.117  24.504 -16.733  1.00 42.83           N  
ATOM    816  CA  SER A 109      35.083  23.913 -18.081  1.00 44.22           C  
ATOM    817  C   SER A 109      35.683  22.499 -18.091  1.00 44.96           C  
ATOM    818  O   SER A 109      35.091  21.567 -18.647  1.00 44.80           O  
ATOM    819  CB  SER A 109      35.767  24.810 -19.120  1.00 44.21           C  
ATOM    820  OG  SER A 109      37.100  24.391 -19.352  1.00 44.30           O  
ATOM    821  N   GLU A 110      36.845  22.335 -17.459  1.00 45.90           N  
ATOM    822  CA  GLU A 110      37.486  21.014 -17.384  1.00 46.86           C  
ATOM    823  C   GLU A 110      36.582  19.952 -16.689  1.00 47.02           C  
ATOM    824  O   GLU A 110      36.741  18.742 -16.894  1.00 47.21           O  
ATOM    825  CB  GLU A 110      38.899  21.148 -16.774  1.00 47.19           C  
ATOM    826  CG  GLU A 110      39.620  19.847 -16.366  1.00 48.76           C  
ATOM    827  CD  GLU A 110      39.177  19.328 -14.986  1.00 50.80           C  
ATOM    828  OE1 GLU A 110      38.768  18.149 -14.894  1.00 51.52           O  
ATOM    829  OE2 GLU A 110      39.224  20.105 -13.999  1.00 51.41           O  
ATOM    830  N   THR A 111      35.611  20.401 -15.898  1.00 47.35           N  
ATOM    831  CA  THR A 111      34.623  19.468 -15.332  1.00 47.33           C  
ATOM    832  C   THR A 111      33.370  19.316 -16.200  1.00 47.65           C  
ATOM    833  O   THR A 111      32.656  18.312 -16.100  1.00 47.68           O  
ATOM    834  CB  THR A 111      34.306  19.737 -13.845  1.00 47.11           C  
ATOM    835  OG1 THR A 111      34.136  21.139 -13.618  1.00 46.79           O  
ATOM    836  CG2 THR A 111      35.450  19.242 -12.993  1.00 46.84           C  
ATOM    837  N   ALA A 112      33.126  20.294 -17.075  1.00 48.13           N  
ATOM    838  CA  ALA A 112      32.131  20.144 -18.153  1.00 48.45           C  
ATOM    839  C   ALA A 112      32.623  19.222 -19.274  1.00 48.60           C  
ATOM    840  O   ALA A 112      31.872  18.928 -20.205  1.00 48.68           O  
ATOM    841  CB  ALA A 112      31.732  21.502 -18.725  1.00 48.41           C  
ATOM    842  N   LYS A 113      33.876  18.772 -19.184  1.00 48.77           N  
ATOM    843  CA  LYS A 113      34.446  17.867 -20.181  1.00 49.08           C  
ATOM    844  C   LYS A 113      34.892  16.527 -19.572  1.00 49.45           C  
ATOM    845  O   LYS A 113      35.195  15.574 -20.291  1.00 49.55           O  
ATOM    846  CB  LYS A 113      35.583  18.554 -20.969  1.00 48.95           C  
ATOM    847  CG  LYS A 113      37.002  18.221 -20.525  0.60 48.28           C  
ATOM    848  CD  LYS A 113      38.016  19.035 -21.312  0.60 47.54           C  
ATOM    849  CE  LYS A 113      39.409  18.436 -21.214  1.00 46.97           C  
ATOM    850  NZ  LYS A 113      39.835  18.230 -19.812  1.00 46.98           N  
ATOM    851  N   LYS A 114      34.934  16.464 -18.247  1.00 49.80           N  
ATOM    852  CA  LYS A 114      35.157  15.197 -17.558  1.00 50.39           C  
ATOM    853  C   LYS A 114      33.825  14.579 -17.110  1.00 50.57           C  
ATOM    854  O   LYS A 114      33.807  13.589 -16.376  1.00 50.75           O  
ATOM    855  CB  LYS A 114      36.115  15.379 -16.368  0.68 50.35           C  
ATOM    856  CG  LYS A 114      37.597  15.473 -16.772  0.68 50.61           C  
ATOM    857  CD  LYS A 114      38.536  14.976 -15.673  0.68 50.33           C  
ATOM    858  CE  LYS A 114      38.418  13.467 -15.471  0.68 50.52           C  
ATOM    859  NZ  LYS A 114      39.229  12.980 -14.323  0.68 50.53           N  
ATOM    860  N   TYR A 115      32.725  15.184 -17.572  1.00 50.71           N  
ATOM    861  CA  TYR A 115      31.328  14.833 -17.230  1.00 50.83           C  
ATOM    862  C   TYR A 115      30.436  15.566 -18.231  1.00 50.52           C  
ATOM    863  O   TYR A 115      30.881  16.539 -18.847  1.00 50.64           O  
ATOM    864  CB  TYR A 115      30.932  15.378 -15.853  1.00 50.97           C  
ATOM    865  CG  TYR A 115      31.510  14.687 -14.648  1.00 51.75           C  
ATOM    866  CD1 TYR A 115      30.964  13.494 -14.178  1.00 52.78           C  
ATOM    867  CD2 TYR A 115      32.578  15.248 -13.952  1.00 52.39           C  
ATOM    868  CE1 TYR A 115      31.478  12.865 -13.057  1.00 53.65           C  
ATOM    869  CE2 TYR A 115      33.104  14.629 -12.833  1.00 53.56           C  
ATOM    870  CZ  TYR A 115      32.547  13.439 -12.388  1.00 54.64           C  
ATOM    871  OH  TYR A 115      33.063  12.822 -11.267  1.00 56.61           O  
ATOM    872  N   GLY A 116      29.180  15.152 -18.368  1.00 49.91           N  
ATOM    873  CA  GLY A 116      28.239  15.912 -19.190  1.00 49.56           C  
ATOM    874  C   GLY A 116      28.225  17.409 -18.856  1.00 49.56           C  
ATOM    875  O   GLY A 116      28.475  17.814 -17.704  1.00 49.62           O  
ATOM    876  N   GLU A 117      27.957  18.235 -19.870  1.00 48.98           N  
ATOM    877  CA  GLU A 117      27.694  19.660 -19.673  1.00 48.16           C  
ATOM    878  C   GLU A 117      26.292  19.845 -19.080  1.00 47.73           C  
ATOM    879  O   GLU A 117      25.917  20.946 -18.679  1.00 47.77           O  
ATOM    880  CB  GLU A 117      27.831  20.426 -20.987  0.51 48.14           C  
ATOM    881  CG  GLU A 117      27.115  19.769 -22.168  0.51 48.81           C  
ATOM    882  CD  GLU A 117      27.199  20.586 -23.442  1.00 49.31           C  
ATOM    883  OE1 GLU A 117      26.710  20.103 -24.484  1.00 48.17           O  
ATOM    884  OE2 GLU A 117      27.746  21.715 -23.395  1.00 50.46           O  
ATOM    885  N   GLU A 118      25.516  18.762 -19.037  1.00 47.23           N  
ATOM    886  CA  GLU A 118      24.203  18.788 -18.377  1.00 46.35           C  
ATOM    887  C   GLU A 118      24.265  18.250 -16.959  1.00 45.24           C  
ATOM    888  O   GLU A 118      23.379  18.521 -16.153  1.00 45.15           O  
ATOM    889  CB  GLU A 118      23.134  18.073 -19.213  1.00 46.50           C  
ATOM    890  CG  GLU A 118      22.702  18.880 -20.448  1.00 48.05           C  
ATOM    891  CD  GLU A 118      22.287  20.319 -20.098  1.00 50.03           C  
ATOM    892  OE1 GLU A 118      23.094  21.263 -20.330  1.00 49.49           O  
ATOM    893  OE2 GLU A 118      21.160  20.497 -19.571  1.00 49.73           O  
ATOM    894  N   GLN A 119      25.326  17.499 -16.656  1.00 44.13           N  
ATOM    895  CA  GLN A 119      25.599  17.078 -15.282  1.00 42.84           C  
ATOM    896  C   GLN A 119      26.018  18.246 -14.396  1.00 42.03           C  
ATOM    897  O   GLN A 119      25.401  18.460 -13.354  1.00 41.96           O  
ATOM    898  CB  GLN A 119      26.583  15.901 -15.186  1.00 42.65           C  
ATOM    899  CG  GLN A 119      25.948  14.628 -14.617  1.00 42.07           C  
ATOM    900  CD  GLN A 119      25.023  14.908 -13.435  1.00 42.18           C  
ATOM    901  OE1 GLN A 119      23.984  14.283 -13.265  1.00 42.69           O  
ATOM    902  NE2 GLN A 119      25.394  15.871 -12.632  1.00 43.19           N  
ATOM    903  N   VAL A 120      27.035  19.001 -14.815  1.00 41.16           N  
ATOM    904  CA  VAL A 120      27.434  20.249 -14.115  1.00 40.53           C  
ATOM    905  C   VAL A 120      26.311  21.294 -13.925  1.00 39.99           C  
ATOM    906  O   VAL A 120      26.363  22.087 -12.968  1.00 40.30           O  
ATOM    907  CB  VAL A 120      28.676  20.952 -14.749  1.00 40.51           C  
ATOM    908  CG1 VAL A 120      29.820  19.951 -14.967  1.00 40.67           C  
ATOM    909  CG2 VAL A 120      28.307  21.680 -16.041  1.00 40.58           C  
ATOM    910  N   LYS A 121      25.312  21.291 -14.815  1.00 38.75           N  
ATOM    911  CA  LYS A 121      24.180  22.208 -14.705  1.00 37.75           C  
ATOM    912  C   LYS A 121      23.233  21.822 -13.571  1.00 36.68           C  
ATOM    913  O   LYS A 121      22.821  22.685 -12.775  1.00 36.50           O  
ATOM    914  CB  LYS A 121      23.414  22.319 -16.027  1.00 38.03           C  
ATOM    915  CG  LYS A 121      22.564  23.593 -16.124  1.00 38.88           C  
ATOM    916  CD  LYS A 121      21.874  23.732 -17.484  1.00 41.39           C  
ATOM    917  CE  LYS A 121      21.201  25.090 -17.608  1.00 42.52           C  
ATOM    918  NZ  LYS A 121      22.114  26.192 -17.142  1.00 44.72           N  
ATOM    919  N   ILE A 122      22.881  20.537 -13.513  1.00 35.18           N  
ATOM    920  CA  ILE A 122      22.103  19.994 -12.385  1.00 34.20           C  
ATOM    921  C   ILE A 122      22.812  20.233 -11.038  1.00 33.56           C  
ATOM    922  O   ILE A 122      22.176  20.517 -10.029  1.00 33.16           O  
ATOM    923  CB  ILE A 122      21.838  18.472 -12.544  1.00 34.03           C  
ATOM    924  CG1 ILE A 122      20.968  18.202 -13.780  1.00 33.53           C  
ATOM    925  CG2 ILE A 122      21.218  17.904 -11.272  1.00 32.98           C  
ATOM    926  CD1 ILE A 122      20.818  16.732 -14.132  1.00 32.28           C  
ATOM    927  N   TRP A 123      24.135  20.108 -11.037  1.00 32.96           N  
ATOM    928  CA  TRP A 123      24.903  20.171  -9.808  1.00 32.44           C  
ATOM    929  C   TRP A 123      25.017  21.604  -9.340  1.00 32.67           C  
ATOM    930  O   TRP A 123      25.218  21.870  -8.151  1.00 32.77           O  
ATOM    931  CB  TRP A 123      26.301  19.582 -10.028  1.00 32.03           C  
ATOM    932  CG  TRP A 123      26.356  18.070 -10.058  1.00 29.65           C  
ATOM    933  CD1 TRP A 123      25.470  17.194  -9.485  1.00 28.17           C  
ATOM    934  CD2 TRP A 123      27.378  17.269 -10.661  1.00 27.57           C  
ATOM    935  NE1 TRP A 123      25.868  15.898  -9.716  1.00 28.06           N  
ATOM    936  CE2 TRP A 123      27.037  15.915 -10.433  1.00 27.97           C  
ATOM    937  CE3 TRP A 123      28.533  17.563 -11.399  1.00 27.04           C  
ATOM    938  CZ2 TRP A 123      27.809  14.854 -10.921  1.00 28.43           C  
ATOM    939  CZ3 TRP A 123      29.305  16.517 -11.875  1.00 27.80           C  
ATOM    940  CH2 TRP A 123      28.942  15.176 -11.632  1.00 29.64           C  
ATOM    941  N   ARG A 124      24.869  22.511 -10.307  1.00 32.71           N  
ATOM    942  CA  ARG A 124      25.142  23.933 -10.166  1.00 32.23           C  
ATOM    943  C   ARG A 124      23.849  24.714  -9.992  1.00 31.46           C  
ATOM    944  O   ARG A 124      23.788  25.637  -9.197  1.00 30.71           O  
ATOM    945  CB  ARG A 124      25.819  24.406 -11.448  1.00 32.87           C  
ATOM    946  CG  ARG A 124      27.152  25.122 -11.264  1.00 35.63           C  
ATOM    947  CD  ARG A 124      27.496  26.008 -12.470  1.00 39.69           C  
ATOM    948  NE  ARG A 124      28.379  27.099 -12.041  1.00 43.95           N  
ATOM    949  CZ  ARG A 124      27.965  28.251 -11.510  1.00 45.01           C  
ATOM    950  NH1 ARG A 124      26.670  28.508 -11.357  1.00 44.16           N  
ATOM    951  NH2 ARG A 124      28.855  29.156 -11.130  1.00 46.76           N  
ATOM    952  N   ARG A 125      22.810  24.313 -10.730  1.00 31.28           N  
ATOM    953  CA  ARG A 125      21.638  25.153 -10.964  1.00 30.87           C  
ATOM    954  C   ARG A 125      20.329  24.546 -10.438  1.00 29.46           C  
ATOM    955  O   ARG A 125      19.287  25.214 -10.454  1.00 29.06           O  
ATOM    956  CB  ARG A 125      21.519  25.453 -12.470  1.00 31.57           C  
ATOM    957  CG  ARG A 125      20.812  26.756 -12.832  1.00 34.38           C  
ATOM    958  CD  ARG A 125      21.804  27.882 -13.181  1.00 39.63           C  
ATOM    959  NE  ARG A 125      22.622  27.541 -14.353  1.00 43.29           N  
ATOM    960  CZ  ARG A 125      23.843  28.026 -14.620  1.00 43.86           C  
ATOM    961  NH1 ARG A 125      24.429  28.906 -13.802  1.00 42.40           N  
ATOM    962  NH2 ARG A 125      24.479  27.624 -15.720  1.00 43.08           N  
ATOM    963  N   SER A 126      20.372  23.297  -9.987  1.00 27.70           N  
ATOM    964  CA  SER A 126      19.183  22.674  -9.391  1.00 27.15           C  
ATOM    965  C   SER A 126      19.027  23.042  -7.898  1.00 27.22           C  
ATOM    966  O   SER A 126      19.751  23.896  -7.385  1.00 27.99           O  
ATOM    967  CB  SER A 126      19.195  21.155  -9.580  1.00 26.37           C  
ATOM    968  OG  SER A 126      20.091  20.554  -8.678  1.00 25.09           O  
ATOM    969  N   TYR A 127      18.091  22.401  -7.202  1.00 26.65           N  
ATOM    970  CA  TYR A 127      17.825  22.725  -5.812  1.00 25.76           C  
ATOM    971  C   TYR A 127      18.235  21.617  -4.881  1.00 25.83           C  
ATOM    972  O   TYR A 127      18.659  21.892  -3.761  1.00 26.83           O  
ATOM    973  CB  TYR A 127      16.338  23.036  -5.581  1.00 25.51           C  
ATOM    974  CG  TYR A 127      16.027  23.507  -4.180  1.00 23.57           C  
ATOM    975  CD1 TYR A 127      16.460  24.762  -3.733  1.00 22.83           C  
ATOM    976  CD2 TYR A 127      15.316  22.710  -3.302  1.00 21.73           C  
ATOM    977  CE1 TYR A 127      16.193  25.222  -2.445  1.00 20.49           C  
ATOM    978  CE2 TYR A 127      15.047  23.144  -2.012  1.00 23.85           C  
ATOM    979  CZ  TYR A 127      15.494  24.413  -1.584  1.00 23.37           C  
ATOM    980  OH  TYR A 127      15.215  24.868  -0.311  1.00 21.55           O  
ATOM    981  N   ASP A 128      18.085  20.368  -5.315  1.00 25.17           N  
ATOM    982  CA  ASP A 128      18.214  19.245  -4.377  1.00 24.35           C  
ATOM    983  C   ASP A 128      19.014  18.050  -4.877  1.00 23.10           C  
ATOM    984  O   ASP A 128      18.907  16.959  -4.329  1.00 22.65           O  
ATOM    985  CB  ASP A 128      16.836  18.815  -3.807  1.00 24.56           C  
ATOM    986  CG  ASP A 128      15.912  18.192  -4.853  1.00 26.31           C  
ATOM    987  OD1 ASP A 128      14.829  17.687  -4.459  1.00 27.90           O  
ATOM    988  OD2 ASP A 128      16.256  18.195  -6.057  1.00 27.13           O  
ATOM    989  N   ILE A 129      19.842  18.274  -5.889  1.00 22.41           N  
ATOM    990  CA  ILE A 129      20.756  17.240  -6.365  1.00 21.84           C  
ATOM    991  C   ILE A 129      22.225  17.666  -6.195  1.00 21.15           C  
ATOM    992  O   ILE A 129      22.773  18.376  -7.046  1.00 20.92           O  
ATOM    993  CB  ILE A 129      20.426  16.785  -7.814  1.00 22.40           C  
ATOM    994  CG1 ILE A 129      18.976  16.258  -7.878  1.00 22.42           C  
ATOM    995  CG2 ILE A 129      21.454  15.708  -8.293  1.00 21.62           C  
ATOM    996  CD1 ILE A 129      18.319  16.353  -9.247  1.00 25.95           C  
ATOM    997  N   PRO A 130      22.853  17.226  -5.082  1.00 20.49           N  
ATOM    998  CA  PRO A 130      24.234  17.550  -4.674  1.00 20.53           C  
ATOM    999  C   PRO A 130      25.314  16.943  -5.586  1.00 20.31           C  
ATOM   1000  O   PRO A 130      25.106  15.876  -6.158  1.00 20.51           O  
ATOM   1001  CB  PRO A 130      24.340  16.909  -3.277  1.00 20.67           C  
ATOM   1002  CG  PRO A 130      23.315  15.769  -3.301  1.00 19.06           C  
ATOM   1003  CD  PRO A 130      22.187  16.322  -4.113  1.00 19.82           C  
ATOM   1004  N   PRO A 131      26.470  17.612  -5.702  1.00 20.62           N  
ATOM   1005  CA  PRO A 131      27.604  17.057  -6.439  1.00 20.80           C  
ATOM   1006  C   PRO A 131      28.245  15.931  -5.632  1.00 20.64           C  
ATOM   1007  O   PRO A 131      27.892  15.753  -4.461  1.00 20.40           O  
ATOM   1008  CB  PRO A 131      28.565  18.264  -6.556  1.00 21.23           C  
ATOM   1009  CG  PRO A 131      27.694  19.487  -6.214  1.00 19.84           C  
ATOM   1010  CD  PRO A 131      26.802  18.942  -5.158  1.00 20.39           C  
ATOM   1011  N   PRO A 132      29.113  15.123  -6.272  1.00 20.34           N  
ATOM   1012  CA  PRO A 132      29.734  13.985  -5.578  1.00 19.74           C  
ATOM   1013  C   PRO A 132      30.354  14.391  -4.259  1.00 18.81           C  
ATOM   1014  O   PRO A 132      31.074  15.366  -4.210  1.00 18.76           O  
ATOM   1015  CB  PRO A 132      30.821  13.492  -6.553  1.00 20.05           C  
ATOM   1016  CG  PRO A 132      30.688  14.320  -7.797  1.00 20.89           C  
ATOM   1017  CD  PRO A 132      29.461  15.173  -7.701  1.00 20.44           C  
ATOM   1018  N   LYS A 133      30.029  13.631  -3.222  1.00 18.29           N  
ATOM   1019  CA  LYS A 133      30.483  13.794  -1.852  1.00 18.27           C  
ATOM   1020  C   LYS A 133      31.969  13.630  -1.777  1.00 18.57           C  
ATOM   1021  O   LYS A 133      32.488  12.757  -2.436  1.00 18.96           O  
ATOM   1022  CB  LYS A 133      29.851  12.707  -0.981  1.00 17.60           C  
ATOM   1023  CG  LYS A 133      28.338  12.877  -0.879  1.00 18.10           C  
ATOM   1024  CD  LYS A 133      27.554  11.580  -0.758  1.00 19.95           C  
ATOM   1025  CE  LYS A 133      27.254  11.187   0.699  1.00 21.73           C  
ATOM   1026  NZ  LYS A 133      28.510  10.905   1.426  1.00 19.71           N  
ATOM   1027  N   LEU A 134      32.653  14.481  -1.003  1.00 18.48           N  
ATOM   1028  CA  LEU A 134      34.045  14.231  -0.632  1.00 18.67           C  
ATOM   1029  C   LEU A 134      34.188  13.021   0.320  1.00 19.04           C  
ATOM   1030  O   LEU A 134      33.245  12.674   1.058  1.00 18.61           O  
ATOM   1031  CB  LEU A 134      34.635  15.444   0.080  1.00 18.25           C  
ATOM   1032  CG  LEU A 134      34.996  16.708  -0.692  1.00 19.09           C  
ATOM   1033  CD1 LEU A 134      35.184  17.861   0.300  1.00 18.30           C  
ATOM   1034  CD2 LEU A 134      36.256  16.478  -1.540  1.00 17.87           C  
ATOM   1035  N   ASP A 135      35.374  12.409   0.302  1.00 18.98           N  
ATOM   1036  CA  ASP A 135      35.834  11.514   1.372  1.00 19.68           C  
ATOM   1037  C   ASP A 135      36.431  12.273   2.554  1.00 20.21           C  
ATOM   1038  O   ASP A 135      37.079  13.330   2.370  1.00 20.17           O  
ATOM   1039  CB  ASP A 135      36.916  10.577   0.843  0.81 19.50           C  
ATOM   1040  CG  ASP A 135      36.503   9.912  -0.416  1.00 20.22           C  
ATOM   1041  OD1 ASP A 135      37.020  10.289  -1.488  1.00 19.28           O  
ATOM   1042  OD2 ASP A 135      35.615   9.038  -0.335  1.00 24.61           O  
ATOM   1043  N   LYS A 136      36.234  11.719   3.754  1.00 20.67           N  
ATOM   1044  CA  LYS A 136      36.820  12.262   5.002  1.00 21.55           C  
ATOM   1045  C   LYS A 136      38.321  12.466   4.892  1.00 20.92           C  
ATOM   1046  O   LYS A 136      38.879  13.347   5.536  1.00 21.91           O  
ATOM   1047  CB  LYS A 136      36.567  11.312   6.186  1.00 21.86           C  
ATOM   1048  CG  LYS A 136      35.725  11.844   7.325  1.00 24.74           C  
ATOM   1049  CD  LYS A 136      35.871  10.908   8.561  1.00 28.68           C  
ATOM   1050  CE  LYS A 136      34.618  10.929   9.473  1.00 29.63           C  
ATOM   1051  NZ  LYS A 136      34.278   9.544   9.935  1.00 28.05           N  
ATOM   1052  N   GLU A 137      38.958  11.628   4.086  1.00 20.20           N  
ATOM   1053  CA  GLU A 137      40.414  11.482   4.043  1.00 19.65           C  
ATOM   1054  C   GLU A 137      41.043  12.391   2.995  1.00 19.24           C  
ATOM   1055  O   GLU A 137      42.259  12.543   2.943  1.00 17.94           O  
ATOM   1056  CB  GLU A 137      40.783  10.017   3.753  1.00 19.74           C  
ATOM   1057  CG  GLU A 137      40.274   9.018   4.787  1.00 20.08           C  
ATOM   1058  CD  GLU A 137      38.843   8.546   4.540  1.00 21.59           C  
ATOM   1059  OE1 GLU A 137      38.444   7.552   5.152  1.00 22.98           O  
ATOM   1060  OE2 GLU A 137      38.105   9.144   3.737  1.00 23.50           O  
ATOM   1061  N   ASP A 138      40.191  12.957   2.144  1.00 19.36           N  
ATOM   1062  CA  ASP A 138      40.569  14.022   1.228  1.00 20.03           C  
ATOM   1063  C   ASP A 138      41.019  15.247   2.027  1.00 20.48           C  
ATOM   1064  O   ASP A 138      40.530  15.519   3.132  1.00 20.37           O  
ATOM   1065  CB  ASP A 138      39.359  14.358   0.359  1.00 20.29           C  
ATOM   1066  CG  ASP A 138      39.671  15.318  -0.755  1.00 19.91           C  
ATOM   1067  OD1 ASP A 138      39.617  14.906  -1.926  1.00 17.27           O  
ATOM   1068  OD2 ASP A 138      39.937  16.492  -0.461  1.00 21.42           O  
ATOM   1069  N   ASN A 139      41.968  15.992   1.493  1.00 21.41           N  
ATOM   1070  CA  ASN A 139      42.454  17.159   2.232  1.00 22.17           C  
ATOM   1071  C   ASN A 139      41.529  18.359   2.215  1.00 22.25           C  
ATOM   1072  O   ASN A 139      41.702  19.264   3.026  1.00 23.34           O  
ATOM   1073  CB  ASN A 139      43.835  17.569   1.769  1.00 22.51           C  
ATOM   1074  CG  ASN A 139      43.943  17.710   0.263  1.00 25.69           C  
ATOM   1075  OD1 ASN A 139      45.063  17.794  -0.257  1.00 30.00           O  
ATOM   1076  ND2 ASN A 139      42.799  17.738  -0.457  1.00 27.36           N  
ATOM   1077  N   ARG A 140      40.562  18.370   1.291  1.00 21.80           N  
ATOM   1078  CA  ARG A 140      39.508  19.388   1.246  1.00 20.59           C  
ATOM   1079  C   ARG A 140      38.413  19.160   2.319  1.00 21.15           C  
ATOM   1080  O   ARG A 140      37.620  20.085   2.576  1.00 21.93           O  
ATOM   1081  CB  ARG A 140      38.900  19.517  -0.173  1.00 19.57           C  
ATOM   1082  CG  ARG A 140      39.912  19.976  -1.239  1.00 17.58           C  
ATOM   1083  CD  ARG A 140      39.478  19.711  -2.689  1.00 15.10           C  
ATOM   1084  NE  ARG A 140      39.338  18.275  -2.968  1.00 13.91           N  
ATOM   1085  CZ  ARG A 140      38.634  17.745  -3.968  1.00 11.81           C  
ATOM   1086  NH1 ARG A 140      37.990  18.510  -4.851  1.00 12.64           N  
ATOM   1087  NH2 ARG A 140      38.575  16.436  -4.088  1.00 10.09           N  
ATOM   1088  N   TRP A 141      38.347  17.970   2.945  1.00 20.48           N  
ATOM   1089  CA  TRP A 141      37.401  17.774   4.056  1.00 20.41           C  
ATOM   1090  C   TRP A 141      37.559  18.954   5.017  1.00 20.89           C  
ATOM   1091  O   TRP A 141      38.706  19.275   5.440  1.00 20.99           O  
ATOM   1092  CB  TRP A 141      37.597  16.438   4.793  1.00 20.46           C  
ATOM   1093  CG  TRP A 141      36.508  16.130   5.879  1.00 21.38           C  
ATOM   1094  CD1 TRP A 141      35.126  16.212   5.728  1.00 20.79           C  
ATOM   1095  CD2 TRP A 141      36.724  15.671   7.234  1.00 20.52           C  
ATOM   1096  NE1 TRP A 141      34.493  15.852   6.902  1.00 20.07           N  
ATOM   1097  CE2 TRP A 141      35.441  15.524   7.842  1.00 20.62           C  
ATOM   1098  CE3 TRP A 141      37.869  15.377   7.992  1.00 21.84           C  
ATOM   1099  CZ2 TRP A 141      35.280  15.080   9.161  1.00 18.22           C  
ATOM   1100  CZ3 TRP A 141      37.711  14.956   9.314  1.00 22.18           C  
ATOM   1101  CH2 TRP A 141      36.417  14.805   9.882  1.00 21.41           C  
ATOM   1102  N   PRO A 142      36.435  19.668   5.302  1.00 20.74           N  
ATOM   1103  CA  PRO A 142      36.462  20.803   6.270  1.00 20.55           C  
ATOM   1104  C   PRO A 142      37.022  20.362   7.616  1.00 20.26           C  
ATOM   1105  O   PRO A 142      37.767  21.105   8.222  1.00 21.50           O  
ATOM   1106  CB  PRO A 142      34.996  21.184   6.426  1.00 20.58           C  
ATOM   1107  CG  PRO A 142      34.325  20.629   5.172  1.00 20.76           C  
ATOM   1108  CD  PRO A 142      35.095  19.448   4.733  1.00 20.16           C  
ATOM   1109  N   GLY A 143      36.713  19.142   8.049  1.00 19.56           N  
ATOM   1110  CA  GLY A 143      37.190  18.632   9.330  1.00 19.26           C  
ATOM   1111  C   GLY A 143      38.700  18.526   9.602  1.00 18.55           C  
ATOM   1112  O   GLY A 143      39.091  18.161  10.721  1.00 18.90           O  
ATOM   1113  N   HIS A 144      39.532  18.828   8.601  1.00 17.23           N  
ATOM   1114  CA  HIS A 144      41.001  18.775   8.726  1.00 15.96           C  
ATOM   1115  C   HIS A 144      41.499  20.171   8.972  1.00 16.70           C  
ATOM   1116  O   HIS A 144      42.660  20.385   9.362  1.00 17.45           O  
ATOM   1117  CB  HIS A 144      41.668  18.274   7.437  1.00 14.89           C  
ATOM   1118  CG  HIS A 144      41.529  16.803   7.203  1.00 10.65           C  
ATOM   1119  ND1 HIS A 144      42.145  15.862   7.995  1.00  8.37           N  
ATOM   1120  CD2 HIS A 144      40.867  16.112   6.252  1.00  9.38           C  
ATOM   1121  CE1 HIS A 144      41.848  14.651   7.569  1.00  6.09           C  
ATOM   1122  NE2 HIS A 144      41.067  14.773   6.513  1.00  8.59           N  
ATOM   1123  N   ASN A 145      40.604  21.120   8.742  1.00 16.69           N  
ATOM   1124  CA  ASN A 145      40.943  22.523   8.693  1.00 16.70           C  
ATOM   1125  C   ASN A 145      40.689  23.196  10.036  1.00 17.58           C  
ATOM   1126  O   ASN A 145      39.537  23.327  10.462  1.00 18.00           O  
ATOM   1127  CB  ASN A 145      40.126  23.213   7.594  0.53 15.63           C  
ATOM   1128  CG  ASN A 145      40.452  24.671   7.467  0.53 13.62           C  
ATOM   1129  OD1 ASN A 145      40.533  25.406   8.445  0.53  9.52           O  
ATOM   1130  ND2 ASN A 145      40.652  25.098   6.260  1.00 12.42           N  
ATOM   1131  N   VAL A 146      41.755  23.680  10.666  1.00 18.51           N  
ATOM   1132  CA  VAL A 146      41.634  24.311  12.004  1.00 19.23           C  
ATOM   1133  C   VAL A 146      40.515  25.340  12.116  1.00 19.32           C  
ATOM   1134  O   VAL A 146      39.998  25.544  13.216  1.00 19.68           O  
ATOM   1135  CB  VAL A 146      42.968  24.908  12.551  1.00 18.93           C  
ATOM   1136  CG1 VAL A 146      43.921  23.775  12.961  1.00 19.52           C  
ATOM   1137  CG2 VAL A 146      43.605  25.875  11.543  1.00 17.93           C  
ATOM   1138  N   VAL A 147      40.127  25.953  10.991  1.00 19.08           N  
ATOM   1139  CA  VAL A 147      39.004  26.879  10.995  1.00 18.91           C  
ATOM   1140  C   VAL A 147      37.832  26.231  11.723  1.00 19.14           C  
ATOM   1141  O   VAL A 147      37.102  26.913  12.457  1.00 19.38           O  
ATOM   1142  CB  VAL A 147      38.608  27.363   9.577  1.00 18.82           C  
ATOM   1143  CG1 VAL A 147      37.210  27.844   9.571  1.00 18.57           C  
ATOM   1144  CG2 VAL A 147      39.508  28.490   9.114  1.00 17.02           C  
ATOM   1145  N   TYR A 148      37.723  24.910  11.596  1.00 18.97           N  
ATOM   1146  CA  TYR A 148      36.626  24.161  12.195  1.00 19.48           C  
ATOM   1147  C   TYR A 148      37.025  23.298  13.335  1.00 19.86           C  
ATOM   1148  O   TYR A 148      36.339  22.320  13.642  1.00 19.96           O  
ATOM   1149  CB  TYR A 148      35.950  23.309  11.142  1.00 19.11           C  
ATOM   1150  CG  TYR A 148      35.587  24.153   9.993  1.00 19.80           C  
ATOM   1151  CD1 TYR A 148      34.683  25.205  10.150  1.00 20.75           C  
ATOM   1152  CD2 TYR A 148      36.188  23.970   8.751  1.00 20.99           C  
ATOM   1153  CE1 TYR A 148      34.340  26.005   9.086  1.00 19.85           C  
ATOM   1154  CE2 TYR A 148      35.853  24.786   7.682  1.00 20.86           C  
ATOM   1155  CZ  TYR A 148      34.928  25.798   7.870  1.00 20.28           C  
ATOM   1156  OH  TYR A 148      34.589  26.615   6.834  1.00 23.76           O  
ATOM   1157  N   LYS A 149      38.142  23.658  13.953  1.00 21.20           N  
ATOM   1158  CA  LYS A 149      38.715  22.931  15.097  1.00 22.77           C  
ATOM   1159  C   LYS A 149      37.731  22.799  16.272  1.00 24.26           C  
ATOM   1160  O   LYS A 149      37.750  21.807  17.011  1.00 24.05           O  
ATOM   1161  CB  LYS A 149      39.991  23.655  15.531  1.00 22.60           C  
ATOM   1162  CG  LYS A 149      40.382  23.606  17.005  1.00 22.09           C  
ATOM   1163  CD  LYS A 149      41.612  24.498  17.206  1.00 20.45           C  
ATOM   1164  CE  LYS A 149      42.348  24.234  18.502  1.00 19.82           C  
ATOM   1165  NZ  LYS A 149      41.551  24.735  19.644  1.00 18.86           N  
ATOM   1166  N   ASN A 150      36.868  23.810  16.410  1.00 25.72           N  
ATOM   1167  CA  ASN A 150      36.003  23.976  17.575  1.00 27.06           C  
ATOM   1168  C   ASN A 150      34.540  23.619  17.251  1.00 27.66           C  
ATOM   1169  O   ASN A 150      33.604  24.093  17.910  1.00 28.12           O  
ATOM   1170  CB  ASN A 150      36.152  25.411  18.124  1.00 26.92           C  
ATOM   1171  CG  ASN A 150      37.525  25.651  18.780  1.00 27.54           C  
ATOM   1172  OD1 ASN A 150      38.062  24.759  19.433  1.00 27.67           O  
ATOM   1173  ND2 ASN A 150      38.081  26.859  18.619  1.00 26.52           N  
ATOM   1174  N   VAL A 151      34.365  22.766  16.241  1.00 27.61           N  
ATOM   1175  CA  VAL A 151      33.049  22.368  15.768  1.00 27.48           C  
ATOM   1176  C   VAL A 151      33.086  20.886  15.576  1.00 27.60           C  
ATOM   1177  O   VAL A 151      34.000  20.381  14.905  1.00 27.71           O  
ATOM   1178  CB  VAL A 151      32.704  23.007  14.388  1.00 27.85           C  
ATOM   1179  CG1 VAL A 151      31.448  22.369  13.778  1.00 26.90           C  
ATOM   1180  CG2 VAL A 151      32.536  24.524  14.514  1.00 27.72           C  
ATOM   1181  N   PRO A 152      32.093  20.172  16.146  1.00 27.54           N  
ATOM   1182  CA  PRO A 152      32.046  18.733  15.990  1.00 27.45           C  
ATOM   1183  C   PRO A 152      32.219  18.418  14.517  1.00 27.54           C  
ATOM   1184  O   PRO A 152      31.512  18.979  13.659  1.00 27.43           O  
ATOM   1185  CB  PRO A 152      30.626  18.384  16.440  1.00 27.88           C  
ATOM   1186  CG  PRO A 152      30.293  19.431  17.417  1.00 27.32           C  
ATOM   1187  CD  PRO A 152      30.964  20.673  16.946  1.00 27.41           C  
ATOM   1188  N   LYS A 153      33.173  17.548  14.220  1.00 27.41           N  
ATOM   1189  CA  LYS A 153      33.517  17.253  12.829  1.00 26.76           C  
ATOM   1190  C   LYS A 153      32.362  16.653  12.060  1.00 25.57           C  
ATOM   1191  O   LYS A 153      32.276  16.859  10.872  1.00 25.27           O  
ATOM   1192  CB  LYS A 153      34.745  16.371  12.764  1.00 26.74           C  
ATOM   1193  CG  LYS A 153      35.912  16.896  13.586  1.00 29.79           C  
ATOM   1194  CD  LYS A 153      36.994  15.791  13.763  1.00 35.76           C  
ATOM   1195  CE  LYS A 153      36.423  14.459  14.308  1.00 37.74           C  
ATOM   1196  NZ  LYS A 153      35.702  13.531  13.323  1.00 38.85           N  
ATOM   1197  N   ASP A 154      31.451  15.961  12.746  1.00 25.15           N  
ATOM   1198  CA  ASP A 154      30.240  15.399  12.098  1.00 25.03           C  
ATOM   1199  C   ASP A 154      29.161  16.423  11.695  1.00 24.09           C  
ATOM   1200  O   ASP A 154      28.141  16.044  11.160  1.00 23.92           O  
ATOM   1201  CB  ASP A 154      29.599  14.230  12.890  1.00 25.65           C  
ATOM   1202  CG  ASP A 154      30.021  14.173  14.379  1.00 29.46           C  
ATOM   1203  OD1 ASP A 154      30.577  15.165  14.928  1.00 34.80           O  
ATOM   1204  OD2 ASP A 154      29.807  13.107  15.008  1.00 31.44           O  
ATOM   1205  N   ALA A 155      29.376  17.710  11.955  1.00 23.43           N  
ATOM   1206  CA  ALA A 155      28.420  18.744  11.546  1.00 22.17           C  
ATOM   1207  C   ALA A 155      28.745  19.212  10.130  1.00 21.88           C  
ATOM   1208  O   ALA A 155      27.934  19.942   9.508  1.00 21.73           O  
ATOM   1209  CB  ALA A 155      28.441  19.938  12.514  1.00 21.01           C  
ATOM   1210  N   LEU A 156      29.925  18.814   9.635  1.00 20.50           N  
ATOM   1211  CA  LEU A 156      30.516  19.454   8.451  1.00 19.93           C  
ATOM   1212  C   LEU A 156      30.170  18.673   7.194  1.00 19.66           C  
ATOM   1213  O   LEU A 156      30.288  17.476   7.178  1.00 19.17           O  
ATOM   1214  CB  LEU A 156      32.041  19.615   8.601  1.00 19.03           C  
ATOM   1215  CG  LEU A 156      32.486  20.330   9.895  1.00 19.23           C  
ATOM   1216  CD1 LEU A 156      34.023  20.261  10.075  1.00 17.18           C  
ATOM   1217  CD2 LEU A 156      31.923  21.800  10.099  1.00 13.90           C  
ATOM   1218  N   PRO A 157      29.717  19.359   6.135  1.00 20.18           N  
ATOM   1219  CA  PRO A 157      29.338  18.618   4.919  1.00 19.93           C  
ATOM   1220  C   PRO A 157      30.527  18.011   4.152  1.00 20.16           C  
ATOM   1221  O   PRO A 157      31.631  18.562   4.134  1.00 20.65           O  
ATOM   1222  CB  PRO A 157      28.670  19.683   4.056  1.00 19.43           C  
ATOM   1223  CG  PRO A 157      29.273  20.946   4.461  1.00 19.25           C  
ATOM   1224  CD  PRO A 157      29.545  20.814   5.965  1.00 19.97           C  
ATOM   1225  N   PHE A 158      30.275  16.855   3.554  1.00 20.33           N  
ATOM   1226  CA  PHE A 158      31.090  16.281   2.501  1.00 19.48           C  
ATOM   1227  C   PHE A 158      30.660  16.869   1.146  1.00 19.99           C  
ATOM   1228  O   PHE A 158      31.429  16.831   0.178  1.00 20.67           O  
ATOM   1229  CB  PHE A 158      30.847  14.782   2.478  1.00 18.90           C  
ATOM   1230  CG  PHE A 158      31.152  14.091   3.789  1.00 18.14           C  
ATOM   1231  CD1 PHE A 158      30.125  13.539   4.554  1.00 15.70           C  
ATOM   1232  CD2 PHE A 158      32.470  13.971   4.250  1.00 16.27           C  
ATOM   1233  CE1 PHE A 158      30.399  12.870   5.746  1.00 14.30           C  
ATOM   1234  CE2 PHE A 158      32.756  13.313   5.461  1.00 15.11           C  
ATOM   1235  CZ  PHE A 158      31.718  12.759   6.207  1.00 13.83           C  
ATOM   1236  N   THR A 159      29.428  17.383   1.076  1.00 19.67           N  
ATOM   1237  CA  THR A 159      28.870  17.967  -0.138  1.00 19.69           C  
ATOM   1238  C   THR A 159      27.568  18.669   0.209  1.00 20.29           C  
ATOM   1239  O   THR A 159      26.897  18.301   1.173  1.00 19.92           O  
ATOM   1240  CB  THR A 159      28.526  16.895  -1.206  1.00 19.92           C  
ATOM   1241  OG1 THR A 159      28.265  17.531  -2.465  1.00 19.78           O  
ATOM   1242  CG2 THR A 159      27.291  16.115  -0.802  1.00 17.80           C  
ATOM   1243  N   GLU A 160      27.200  19.671  -0.577  1.00 20.73           N  
ATOM   1244  CA  GLU A 160      25.926  20.324  -0.348  1.00 21.88           C  
ATOM   1245  C   GLU A 160      25.146  20.585  -1.629  1.00 22.72           C  
ATOM   1246  O   GLU A 160      25.728  20.774  -2.706  1.00 23.57           O  
ATOM   1247  CB  GLU A 160      26.089  21.599   0.497  1.00 21.49           C  
ATOM   1248  CG  GLU A 160      26.015  21.323   1.988  1.00 20.68           C  
ATOM   1249  CD  GLU A 160      26.236  22.539   2.879  1.00 21.61           C  
ATOM   1250  OE1 GLU A 160      26.061  22.385   4.108  1.00 19.23           O  
ATOM   1251  OE2 GLU A 160      26.601  23.632   2.377  1.00 22.27           O  
ATOM   1252  N   CYS A 161      23.828  20.521  -1.502  1.00 23.06           N  
ATOM   1253  CA  CYS A 161      22.926  21.106  -2.474  1.00 24.36           C  
ATOM   1254  C   CYS A 161      22.244  22.264  -1.758  1.00 24.43           C  
ATOM   1255  O   CYS A 161      22.229  22.311  -0.527  1.00 25.45           O  
ATOM   1256  CB  CYS A 161      21.900  20.077  -2.979  1.00 24.41           C  
ATOM   1257  SG  CYS A 161      20.606  19.660  -1.808  1.00 25.59           S  
ATOM   1258  N   LEU A 162      21.677  23.194  -2.508  1.00 24.30           N  
ATOM   1259  CA  LEU A 162      21.094  24.377  -1.904  1.00 23.75           C  
ATOM   1260  C   LEU A 162      20.132  24.019  -0.770  1.00 23.22           C  
ATOM   1261  O   LEU A 162      20.047  24.728   0.231  1.00 22.37           O  
ATOM   1262  CB  LEU A 162      20.361  25.196  -2.949  1.00 23.57           C  
ATOM   1263  CG  LEU A 162      20.358  26.717  -2.782  1.00 24.56           C  
ATOM   1264  CD1 LEU A 162      18.998  27.221  -3.226  1.00 25.22           C  
ATOM   1265  CD2 LEU A 162      20.671  27.253  -1.389  1.00 22.95           C  
ATOM   1266  N   LYS A 163      19.418  22.911  -0.912  1.00 22.81           N  
ATOM   1267  CA  LYS A 163      18.448  22.568   0.119  1.00 23.04           C  
ATOM   1268  C   LYS A 163      19.199  22.290   1.437  1.00 22.61           C  
ATOM   1269  O   LYS A 163      18.775  22.784   2.494  1.00 23.38           O  
ATOM   1270  CB  LYS A 163      17.556  21.408  -0.320  1.00 23.67           C  
ATOM   1271  CG  LYS A 163      16.497  20.977   0.684  1.00 25.22           C  
ATOM   1272  CD  LYS A 163      15.973  19.554   0.375  1.00 27.42           C  
ATOM   1273  CE  LYS A 163      16.626  18.449   1.248  1.00 30.57           C  
ATOM   1274  NZ  LYS A 163      18.143  18.350   1.222  1.00 31.75           N  
ATOM   1275  N   ASP A 164      20.316  21.551   1.370  1.00 20.74           N  
ATOM   1276  CA  ASP A 164      21.185  21.347   2.540  1.00 19.66           C  
ATOM   1277  C   ASP A 164      21.662  22.661   3.149  1.00 18.81           C  
ATOM   1278  O   ASP A 164      21.724  22.782   4.371  1.00 18.10           O  
ATOM   1279  CB  ASP A 164      22.442  20.521   2.205  1.00 19.69           C  
ATOM   1280  CG  ASP A 164      22.132  19.204   1.548  1.00 20.18           C  
ATOM   1281  OD1 ASP A 164      21.402  18.388   2.174  1.00 20.42           O  
ATOM   1282  OD2 ASP A 164      22.638  18.994   0.419  1.00 19.09           O  
ATOM   1283  N   THR A 165      22.043  23.613   2.296  1.00 17.68           N  
ATOM   1284  CA  THR A 165      22.527  24.910   2.757  1.00 17.43           C  
ATOM   1285  C   THR A 165      21.424  25.683   3.538  1.00 18.42           C  
ATOM   1286  O   THR A 165      21.659  26.221   4.642  1.00 18.97           O  
ATOM   1287  CB  THR A 165      23.060  25.762   1.553  1.00 17.46           C  
ATOM   1288  OG1 THR A 165      24.138  25.064   0.896  1.00 14.70           O  
ATOM   1289  CG2 THR A 165      23.497  27.174   2.006  1.00 13.18           C  
ATOM   1290  N   VAL A 166      20.231  25.726   2.953  1.00 18.31           N  
ATOM   1291  CA  VAL A 166      19.066  26.324   3.554  1.00 18.46           C  
ATOM   1292  C   VAL A 166      18.805  25.665   4.941  1.00 19.04           C  
ATOM   1293  O   VAL A 166      18.660  26.345   5.966  1.00 19.39           O  
ATOM   1294  CB  VAL A 166      17.840  26.133   2.589  1.00 18.57           C  
ATOM   1295  CG1 VAL A 166      16.522  26.534   3.271  1.00 18.19           C  
ATOM   1296  CG2 VAL A 166      18.053  26.881   1.240  1.00 17.04           C  
ATOM   1297  N   GLU A 167      18.759  24.335   4.965  1.00 19.16           N  
ATOM   1298  CA  GLU A 167      18.497  23.570   6.199  1.00 18.97           C  
ATOM   1299  C   GLU A 167      19.490  23.861   7.321  1.00 18.10           C  
ATOM   1300  O   GLU A 167      19.090  23.891   8.482  1.00 18.51           O  
ATOM   1301  CB  GLU A 167      18.483  22.072   5.908  1.00 18.88           C  
ATOM   1302  CG  GLU A 167      17.368  21.651   4.982  1.00 20.96           C  
ATOM   1303  CD  GLU A 167      17.286  20.148   4.807  1.00 25.32           C  
ATOM   1304  OE1 GLU A 167      18.304  19.454   5.081  1.00 26.90           O  
ATOM   1305  OE2 GLU A 167      16.198  19.654   4.399  1.00 25.81           O  
ATOM   1306  N   ARG A 168      20.764  24.072   6.984  1.00 16.22           N  
ATOM   1307  CA  ARG A 168      21.766  24.365   7.999  1.00 15.95           C  
ATOM   1308  C   ARG A 168      21.874  25.882   8.333  1.00 14.91           C  
ATOM   1309  O   ARG A 168      22.395  26.267   9.378  1.00 13.53           O  
ATOM   1310  CB  ARG A 168      23.139  23.782   7.614  1.00 16.63           C  
ATOM   1311  CG  ARG A 168      23.730  24.426   6.347  1.00 18.60           C  
ATOM   1312  CD  ARG A 168      25.153  24.879   6.489  1.00 18.88           C  
ATOM   1313  NE  ARG A 168      25.767  25.116   5.177  1.00 20.71           N  
ATOM   1314  CZ  ARG A 168      26.021  26.301   4.625  1.00 21.91           C  
ATOM   1315  NH1 ARG A 168      25.707  27.449   5.246  1.00 22.24           N  
ATOM   1316  NH2 ARG A 168      26.616  26.331   3.429  1.00 22.21           N  
ATOM   1317  N   VAL A 169      21.364  26.723   7.441  1.00 14.29           N  
ATOM   1318  CA  VAL A 169      21.230  28.147   7.711  1.00 14.12           C  
ATOM   1319  C   VAL A 169      20.075  28.465   8.690  1.00 13.83           C  
ATOM   1320  O   VAL A 169      20.253  29.268   9.574  1.00 12.66           O  
ATOM   1321  CB  VAL A 169      21.056  28.964   6.358  1.00 14.72           C  
ATOM   1322  CG1 VAL A 169      20.436  30.370   6.579  1.00 12.46           C  
ATOM   1323  CG2 VAL A 169      22.370  29.073   5.609  1.00 15.20           C  
ATOM   1324  N   LEU A 170      18.888  27.879   8.494  1.00 14.36           N  
ATOM   1325  CA  LEU A 170      17.659  28.292   9.240  1.00 15.12           C  
ATOM   1326  C   LEU A 170      17.724  28.138  10.784  1.00 14.55           C  
ATOM   1327  O   LEU A 170      17.122  28.941  11.529  1.00 13.79           O  
ATOM   1328  CB  LEU A 170      16.401  27.602   8.679  1.00 15.40           C  
ATOM   1329  CG  LEU A 170      15.492  28.347   7.692  1.00 19.08           C  
ATOM   1330  CD1 LEU A 170      14.838  29.565   8.420  1.00 20.66           C  
ATOM   1331  CD2 LEU A 170      16.223  28.778   6.357  1.00 20.01           C  
ATOM   1332  N   PRO A 171      18.445  27.107  11.267  1.00 14.22           N  
ATOM   1333  CA  PRO A 171      18.645  27.022  12.721  1.00 14.75           C  
ATOM   1334  C   PRO A 171      19.325  28.248  13.301  1.00 15.21           C  
ATOM   1335  O   PRO A 171      18.956  28.710  14.421  1.00 14.79           O  
ATOM   1336  CB  PRO A 171      19.501  25.783  12.894  1.00 15.30           C  
ATOM   1337  CG  PRO A 171      19.148  24.919  11.601  1.00 15.96           C  
ATOM   1338  CD  PRO A 171      19.030  25.964  10.542  1.00 13.73           C  
ATOM   1339  N   PHE A 172      20.285  28.788  12.545  1.00 15.43           N  
ATOM   1340  CA  PHE A 172      21.020  29.962  13.002  1.00 15.76           C  
ATOM   1341  C   PHE A 172      20.182  31.203  12.989  1.00 15.52           C  
ATOM   1342  O   PHE A 172      20.444  32.125  13.760  1.00 16.71           O  
ATOM   1343  CB  PHE A 172      22.289  30.239  12.201  1.00 16.04           C  
ATOM   1344  CG  PHE A 172      23.308  31.077  12.974  1.00 16.39           C  
ATOM   1345  CD1 PHE A 172      24.073  30.499  14.005  1.00 15.34           C  
ATOM   1346  CD2 PHE A 172      23.483  32.417  12.689  1.00 16.20           C  
ATOM   1347  CE1 PHE A 172      25.015  31.242  14.731  1.00 14.99           C  
ATOM   1348  CE2 PHE A 172      24.426  33.177  13.401  1.00 17.80           C  
ATOM   1349  CZ  PHE A 172      25.183  32.581  14.438  1.00 17.53           C  
ATOM   1350  N   TRP A 173      19.188  31.234  12.112  1.00 14.80           N  
ATOM   1351  CA  TRP A 173      18.295  32.366  12.046  1.00 14.53           C  
ATOM   1352  C   TRP A 173      17.316  32.296  13.257  1.00 15.70           C  
ATOM   1353  O   TRP A 173      17.141  33.287  14.009  1.00 15.25           O  
ATOM   1354  CB  TRP A 173      17.615  32.409  10.669  1.00 14.18           C  
ATOM   1355  CG  TRP A 173      16.300  33.114  10.635  1.00 12.18           C  
ATOM   1356  CD1 TRP A 173      15.087  32.541  10.777  1.00 11.98           C  
ATOM   1357  CD2 TRP A 173      16.071  34.517  10.470  1.00  9.76           C  
ATOM   1358  NE1 TRP A 173      14.103  33.497  10.714  1.00 11.91           N  
ATOM   1359  CE2 TRP A 173      14.691  34.723  10.543  1.00 11.14           C  
ATOM   1360  CE3 TRP A 173      16.904  35.628  10.302  1.00 13.56           C  
ATOM   1361  CZ2 TRP A 173      14.110  35.989  10.417  1.00  9.84           C  
ATOM   1362  CZ3 TRP A 173      16.321  36.900  10.199  1.00 13.89           C  
ATOM   1363  CH2 TRP A 173      14.940  37.056  10.239  1.00 11.35           C  
ATOM   1364  N   PHE A 174      16.713  31.121  13.472  1.00 16.02           N  
ATOM   1365  CA  PHE A 174      15.800  30.945  14.609  1.00 16.17           C  
ATOM   1366  C   PHE A 174      16.450  31.048  15.958  1.00 16.56           C  
ATOM   1367  O   PHE A 174      15.845  31.520  16.898  1.00 17.03           O  
ATOM   1368  CB  PHE A 174      15.038  29.633  14.519  1.00 15.92           C  
ATOM   1369  CG  PHE A 174      14.002  29.616  13.433  1.00 15.42           C  
ATOM   1370  CD1 PHE A 174      13.202  30.721  13.200  1.00 16.15           C  
ATOM   1371  CD2 PHE A 174      13.831  28.505  12.641  1.00 13.64           C  
ATOM   1372  CE1 PHE A 174      12.243  30.689  12.196  1.00 16.08           C  
ATOM   1373  CE2 PHE A 174      12.893  28.480  11.656  1.00 11.48           C  
ATOM   1374  CZ  PHE A 174      12.095  29.555  11.436  1.00 13.94           C  
ATOM   1375  N   ASP A 175      17.695  30.609  16.071  1.00 17.44           N  
ATOM   1376  CA  ASP A 175      18.359  30.673  17.364  1.00 17.38           C  
ATOM   1377  C   ASP A 175      19.012  32.017  17.619  1.00 17.25           C  
ATOM   1378  O   ASP A 175      18.943  32.543  18.716  1.00 17.42           O  
ATOM   1379  CB  ASP A 175      19.375  29.542  17.507  1.00 17.81           C  
ATOM   1380  CG  ASP A 175      18.740  28.260  17.943  1.00 17.38           C  
ATOM   1381  OD1 ASP A 175      17.509  28.210  18.153  1.00 17.89           O  
ATOM   1382  OD2 ASP A 175      19.479  27.287  18.087  1.00 20.56           O  
ATOM   1383  N   HIS A 176      19.649  32.589  16.616  1.00 17.23           N  
ATOM   1384  CA  HIS A 176      20.388  33.798  16.895  1.00 16.86           C  
ATOM   1385  C   HIS A 176      19.934  35.023  16.133  1.00 16.36           C  
ATOM   1386  O   HIS A 176      19.605  36.026  16.793  1.00 15.79           O  
ATOM   1387  CB  HIS A 176      21.884  33.558  16.778  1.00 17.54           C  
ATOM   1388  CG  HIS A 176      22.349  32.379  17.565  1.00 19.14           C  
ATOM   1389  ND1 HIS A 176      22.538  32.424  18.932  1.00 19.82           N  
ATOM   1390  CD2 HIS A 176      22.623  31.106  17.183  1.00 21.05           C  
ATOM   1391  CE1 HIS A 176      22.947  31.238  19.352  1.00 22.53           C  
ATOM   1392  NE2 HIS A 176      23.009  30.421  18.312  1.00 23.50           N  
ATOM   1393  N   ILE A 177      19.876  34.968  14.794  1.00 15.16           N  
ATOM   1394  CA  ILE A 177      19.539  36.196  14.046  1.00 15.37           C  
ATOM   1395  C   ILE A 177      18.177  36.750  14.449  1.00 15.79           C  
ATOM   1396  O   ILE A 177      18.032  37.946  14.805  1.00 16.07           O  
ATOM   1397  CB  ILE A 177      19.689  36.065  12.499  1.00 15.50           C  
ATOM   1398  CG1 ILE A 177      21.172  36.065  12.110  1.00 15.36           C  
ATOM   1399  CG2 ILE A 177      19.112  37.235  11.828  1.00 13.45           C  
ATOM   1400  CD1 ILE A 177      21.440  35.384  10.814  1.00 15.43           C  
ATOM   1401  N   ALA A 178      17.193  35.859  14.469  1.00 16.05           N  
ATOM   1402  CA  ALA A 178      15.818  36.256  14.736  1.00 16.52           C  
ATOM   1403  C   ALA A 178      15.550  36.715  16.166  1.00 16.07           C  
ATOM   1404  O   ALA A 178      15.044  37.798  16.350  1.00 17.32           O  
ATOM   1405  CB  ALA A 178      14.847  35.166  14.294  1.00 17.26           C  
ATOM   1406  N   PRO A 179      15.852  35.907  17.186  1.00 16.19           N  
ATOM   1407  CA  PRO A 179      15.760  36.632  18.488  1.00 16.40           C  
ATOM   1408  C   PRO A 179      16.332  38.073  18.491  1.00 16.32           C  
ATOM   1409  O   PRO A 179      15.660  38.979  18.983  1.00 16.09           O  
ATOM   1410  CB  PRO A 179      16.471  35.687  19.476  1.00 15.70           C  
ATOM   1411  CG  PRO A 179      16.147  34.299  18.888  1.00 15.84           C  
ATOM   1412  CD  PRO A 179      16.156  34.466  17.374  1.00 15.47           C  
ATOM   1413  N   ASP A 180      17.513  38.298  17.906  1.00 16.49           N  
ATOM   1414  CA  ASP A 180      18.120  39.637  17.958  1.00 16.71           C  
ATOM   1415  C   ASP A 180      17.175  40.731  17.416  1.00 17.00           C  
ATOM   1416  O   ASP A 180      16.912  41.724  18.105  1.00 15.78           O  
ATOM   1417  CB  ASP A 180      19.432  39.667  17.168  1.00 17.18           C  
ATOM   1418  CG  ASP A 180      20.659  39.419  18.028  1.00 16.31           C  
ATOM   1419  OD1 ASP A 180      20.530  39.093  19.228  1.00 17.32           O  
ATOM   1420  OD2 ASP A 180      21.760  39.522  17.469  1.00 14.79           O  
ATOM   1421  N   ILE A 181      16.687  40.530  16.170  1.00 17.23           N  
ATOM   1422  CA  ILE A 181      15.733  41.436  15.521  1.00 17.18           C  
ATOM   1423  C   ILE A 181      14.554  41.639  16.444  1.00 17.96           C  
ATOM   1424  O   ILE A 181      14.169  42.790  16.682  1.00 17.64           O  
ATOM   1425  CB  ILE A 181      15.229  40.950  14.121  1.00 16.91           C  
ATOM   1426  CG1 ILE A 181      16.409  40.707  13.165  1.00 17.54           C  
ATOM   1427  CG2 ILE A 181      14.290  41.966  13.514  1.00 13.34           C  
ATOM   1428  CD1 ILE A 181      16.017  40.167  11.779  1.00 17.72           C  
ATOM   1429  N   LEU A 182      14.021  40.523  16.986  1.00 18.71           N  
ATOM   1430  CA  LEU A 182      12.891  40.547  17.965  1.00 18.90           C  
ATOM   1431  C   LEU A 182      13.197  41.306  19.273  1.00 19.19           C  
ATOM   1432  O   LEU A 182      12.285  41.725  19.977  1.00 19.03           O  
ATOM   1433  CB  LEU A 182      12.363  39.134  18.256  1.00 18.23           C  
ATOM   1434  CG  LEU A 182      11.469  38.455  17.195  1.00 17.39           C  
ATOM   1435  CD1 LEU A 182      11.219  36.986  17.569  1.00 14.67           C  
ATOM   1436  CD2 LEU A 182      10.133  39.172  16.915  1.00 12.80           C  
ATOM   1437  N   ALA A 183      14.486  41.515  19.551  1.00 20.07           N  
ATOM   1438  CA  ALA A 183      14.963  42.189  20.766  1.00 20.68           C  
ATOM   1439  C   ALA A 183      15.243  43.670  20.535  1.00 21.11           C  
ATOM   1440  O   ALA A 183      15.829  44.355  21.392  1.00 22.00           O  
ATOM   1441  CB  ALA A 183      16.229  41.484  21.316  1.00 20.09           C  
ATOM   1442  N   ASN A 184      14.825  44.155  19.376  1.00 21.61           N  
ATOM   1443  CA  ASN A 184      14.978  45.562  19.001  1.00 22.17           C  
ATOM   1444  C   ASN A 184      16.381  46.005  18.621  1.00 21.87           C  
ATOM   1445  O   ASN A 184      16.670  47.179  18.571  1.00 21.26           O  
ATOM   1446  CB  ASN A 184      14.397  46.471  20.074  1.00 22.49           C  
ATOM   1447  CG  ASN A 184      12.992  46.874  19.760  1.00 24.98           C  
ATOM   1448  OD1 ASN A 184      12.061  46.047  19.755  1.00 26.58           O  
ATOM   1449  ND2 ASN A 184      12.817  48.151  19.460  1.00 27.50           N  
ATOM   1450  N   LYS A 185      17.252  45.051  18.315  1.00 22.57           N  
ATOM   1451  CA  LYS A 185      18.554  45.400  17.754  1.00 22.85           C  
ATOM   1452  C   LYS A 185      18.714  45.252  16.226  1.00 22.66           C  
ATOM   1453  O   LYS A 185      18.099  44.396  15.598  1.00 23.02           O  
ATOM   1454  CB  LYS A 185      19.678  44.748  18.538  1.00 23.26           C  
ATOM   1455  CG  LYS A 185      19.910  43.325  18.324  1.00 22.95           C  
ATOM   1456  CD  LYS A 185      20.936  42.958  19.371  1.00 23.42           C  
ATOM   1457  CE  LYS A 185      20.312  42.738  20.747  1.00 21.85           C  
ATOM   1458  NZ  LYS A 185      20.997  41.535  21.374  1.00 18.08           N  
ATOM   1459  N   LYS A 186      19.479  46.179  15.649  1.00 22.37           N  
ATOM   1460  CA  LYS A 186      19.613  46.334  14.205  1.00 21.91           C  
ATOM   1461  C   LYS A 186      20.741  45.402  13.817  1.00 21.34           C  
ATOM   1462  O   LYS A 186      21.877  45.520  14.335  1.00 22.07           O  
ATOM   1463  CB  LYS A 186      19.957  47.793  13.837  1.00 22.25           C  
ATOM   1464  CG  LYS A 186      19.042  48.893  14.452  1.00 24.26           C  
ATOM   1465  CD  LYS A 186      17.705  48.981  13.694  1.00 31.21           C  
ATOM   1466  CE  LYS A 186      16.450  48.835  14.602  1.00 33.80           C  
ATOM   1467  NZ  LYS A 186      15.361  47.929  14.022  1.00 33.00           N  
ATOM   1468  N   VAL A 187      20.433  44.439  12.969  1.00 19.61           N  
ATOM   1469  CA  VAL A 187      21.446  43.486  12.566  1.00 19.03           C  
ATOM   1470  C   VAL A 187      21.785  43.589  11.064  1.00 18.95           C  
ATOM   1471  O   VAL A 187      20.892  43.881  10.239  1.00 18.92           O  
ATOM   1472  CB  VAL A 187      21.122  42.022  13.038  1.00 18.65           C  
ATOM   1473  CG1 VAL A 187      19.774  41.913  13.600  1.00 19.23           C  
ATOM   1474  CG2 VAL A 187      21.334  40.989  11.954  1.00 17.31           C  
ATOM   1475  N   MET A 188      23.070  43.401  10.737  1.00 17.10           N  
ATOM   1476  CA  MET A 188      23.456  43.123   9.366  1.00 16.55           C  
ATOM   1477  C   MET A 188      23.975  41.671   9.304  1.00 17.20           C  
ATOM   1478  O   MET A 188      24.707  41.207  10.203  1.00 17.08           O  
ATOM   1479  CB  MET A 188      24.524  44.114   8.876  1.00 16.15           C  
ATOM   1480  CG  MET A 188      25.288  43.681   7.593  1.00 14.16           C  
ATOM   1481  SD  MET A 188      26.415  44.919   6.907  1.00  3.81           S  
ATOM   1482  CE  MET A 188      27.738  44.794   8.059  1.00  3.28           C  
ATOM   1483  N   VAL A 189      23.560  40.954   8.266  1.00 17.23           N  
ATOM   1484  CA  VAL A 189      24.169  39.675   7.892  1.00 17.32           C  
ATOM   1485  C   VAL A 189      25.071  39.793   6.610  1.00 17.56           C  
ATOM   1486  O   VAL A 189      24.593  39.942   5.466  1.00 16.92           O  
ATOM   1487  CB  VAL A 189      23.104  38.592   7.723  1.00 16.88           C  
ATOM   1488  CG1 VAL A 189      23.762  37.260   7.443  1.00 17.70           C  
ATOM   1489  CG2 VAL A 189      22.243  38.506   8.990  1.00 16.98           C  
ATOM   1490  N   ALA A 190      26.379  39.755   6.816  1.00 17.50           N  
ATOM   1491  CA  ALA A 190      27.317  39.740   5.702  1.00 18.05           C  
ATOM   1492  C   ALA A 190      27.696  38.276   5.454  1.00 18.33           C  
ATOM   1493  O   ALA A 190      28.576  37.765   6.134  1.00 19.51           O  
ATOM   1494  CB  ALA A 190      28.533  40.547   6.063  1.00 17.65           C  
ATOM   1495  N   ALA A 191      27.015  37.588   4.535  1.00 17.90           N  
ATOM   1496  CA  ALA A 191      27.317  36.191   4.246  1.00 17.09           C  
ATOM   1497  C   ALA A 191      27.575  35.919   2.749  1.00 17.53           C  
ATOM   1498  O   ALA A 191      28.233  36.706   2.063  1.00 17.21           O  
ATOM   1499  CB  ALA A 191      26.226  35.329   4.767  1.00 16.71           C  
ATOM   1500  N   HIS A 192      27.063  34.795   2.250  1.00 18.48           N  
ATOM   1501  CA  HIS A 192      27.284  34.366   0.866  1.00 18.76           C  
ATOM   1502  C   HIS A 192      25.963  34.271   0.143  1.00 19.22           C  
ATOM   1503  O   HIS A 192      24.901  34.150   0.791  1.00 20.06           O  
ATOM   1504  CB  HIS A 192      28.027  33.039   0.857  1.00 19.05           C  
ATOM   1505  CG  HIS A 192      29.301  33.084   1.638  1.00 18.22           C  
ATOM   1506  ND1 HIS A 192      30.507  33.407   1.061  1.00 16.44           N  
ATOM   1507  CD2 HIS A 192      29.541  32.931   2.965  1.00 18.34           C  
ATOM   1508  CE1 HIS A 192      31.448  33.408   1.994  1.00 19.59           C  
ATOM   1509  NE2 HIS A 192      30.888  33.137   3.162  1.00 17.64           N  
ATOM   1510  N   GLY A 193      26.005  34.368  -1.185  1.00 18.96           N  
ATOM   1511  CA  GLY A 193      24.766  34.344  -1.992  1.00 18.46           C  
ATOM   1512  C   GLY A 193      23.861  33.143  -1.740  1.00 17.88           C  
ATOM   1513  O   GLY A 193      22.641  33.283  -1.633  1.00 18.50           O  
ATOM   1514  N   ASN A 194      24.439  31.955  -1.638  1.00 17.21           N  
ATOM   1515  CA  ASN A 194      23.639  30.775  -1.350  1.00 17.16           C  
ATOM   1516  C   ASN A 194      23.044  30.760   0.064  1.00 17.89           C  
ATOM   1517  O   ASN A 194      21.861  30.353   0.228  1.00 18.15           O  
ATOM   1518  CB  ASN A 194      24.403  29.487  -1.632  0.49 16.62           C  
ATOM   1519  CG  ASN A 194      24.249  29.041  -3.060  0.49 15.37           C  
ATOM   1520  OD1 ASN A 194      25.225  28.808  -3.753  0.49 11.97           O  
ATOM   1521  ND2 ASN A 194      23.009  28.955  -3.520  0.49 14.28           N  
ATOM   1522  N   SER A 195      23.836  31.184   1.066  1.00 17.03           N  
ATOM   1523  CA  SER A 195      23.332  31.211   2.433  1.00 17.05           C  
ATOM   1524  C   SER A 195      22.319  32.337   2.602  1.00 17.45           C  
ATOM   1525  O   SER A 195      21.287  32.155   3.267  1.00 18.22           O  
ATOM   1526  CB  SER A 195      24.451  31.310   3.483  1.00 17.07           C  
ATOM   1527  OG  SER A 195      25.375  32.348   3.238  1.00 14.78           O  
ATOM   1528  N   LEU A 196      22.587  33.493   1.993  1.00 16.76           N  
ATOM   1529  CA  LEU A 196      21.588  34.570   2.014  1.00 16.48           C  
ATOM   1530  C   LEU A 196      20.300  34.173   1.272  1.00 16.44           C  
ATOM   1531  O   LEU A 196      19.208  34.633   1.619  1.00 16.30           O  
ATOM   1532  CB  LEU A 196      22.145  35.856   1.412  1.00 15.79           C  
ATOM   1533  CG  LEU A 196      23.224  36.558   2.205  1.00 13.82           C  
ATOM   1534  CD1 LEU A 196      23.724  37.732   1.418  1.00 10.34           C  
ATOM   1535  CD2 LEU A 196      22.711  36.958   3.556  1.00 10.61           C  
ATOM   1536  N   ARG A 197      20.438  33.331   0.253  1.00 16.55           N  
ATOM   1537  CA  ARG A 197      19.271  32.823  -0.447  1.00 17.99           C  
ATOM   1538  C   ARG A 197      18.456  31.884   0.411  1.00 17.88           C  
ATOM   1539  O   ARG A 197      17.257  31.811   0.228  1.00 17.50           O  
ATOM   1540  CB  ARG A 197      19.643  32.156  -1.783  1.00 19.02           C  
ATOM   1541  CG  ARG A 197      19.774  33.136  -2.940  1.00 19.61           C  
ATOM   1542  CD  ARG A 197      19.685  32.403  -4.240  1.00 23.49           C  
ATOM   1543  NE  ARG A 197      20.854  31.574  -4.505  1.00 25.31           N  
ATOM   1544  CZ  ARG A 197      20.909  30.651  -5.464  1.00 26.98           C  
ATOM   1545  NH1 ARG A 197      19.870  30.447  -6.257  1.00 29.25           N  
ATOM   1546  NH2 ARG A 197      21.997  29.924  -5.633  1.00 26.37           N  
ATOM   1547  N   GLY A 198      19.096  31.199   1.365  1.00 18.57           N  
ATOM   1548  CA  GLY A 198      18.367  30.347   2.318  1.00 19.32           C  
ATOM   1549  C   GLY A 198      17.480  31.217   3.176  1.00 20.38           C  
ATOM   1550  O   GLY A 198      16.311  30.889   3.434  1.00 20.69           O  
ATOM   1551  N   LEU A 199      18.046  32.362   3.560  1.00 21.14           N  
ATOM   1552  CA  LEU A 199      17.412  33.376   4.393  1.00 21.58           C  
ATOM   1553  C   LEU A 199      16.231  34.070   3.721  1.00 22.41           C  
ATOM   1554  O   LEU A 199      15.150  34.163   4.317  1.00 23.00           O  
ATOM   1555  CB  LEU A 199      18.446  34.401   4.771  1.00 21.00           C  
ATOM   1556  CG  LEU A 199      18.542  34.767   6.237  1.00 22.37           C  
ATOM   1557  CD1 LEU A 199      18.513  33.506   7.132  1.00 21.65           C  
ATOM   1558  CD2 LEU A 199      19.820  35.637   6.461  1.00 20.77           C  
ATOM   1559  N   VAL A 200      16.394  34.554   2.493  1.00 22.96           N  
ATOM   1560  CA  VAL A 200      15.204  35.110   1.828  1.00 23.86           C  
ATOM   1561  C   VAL A 200      14.183  34.043   1.434  1.00 23.72           C  
ATOM   1562  O   VAL A 200      12.994  34.328   1.480  1.00 24.75           O  
ATOM   1563  CB  VAL A 200      15.471  36.126   0.650  1.00 23.90           C  
ATOM   1564  CG1 VAL A 200      16.378  37.239   1.096  1.00 23.71           C  
ATOM   1565  CG2 VAL A 200      16.043  35.460  -0.515  1.00 25.26           C  
ATOM   1566  N   LYS A 201      14.615  32.829   1.079  1.00 23.18           N  
ATOM   1567  CA  LYS A 201      13.643  31.765   0.824  1.00 23.29           C  
ATOM   1568  C   LYS A 201      12.577  31.710   1.911  1.00 23.70           C  
ATOM   1569  O   LYS A 201      11.387  31.726   1.628  1.00 23.26           O  
ATOM   1570  CB  LYS A 201      14.271  30.375   0.690  1.00 23.06           C  
ATOM   1571  CG  LYS A 201      13.189  29.344   0.302  1.00 21.30           C  
ATOM   1572  CD  LYS A 201      13.731  28.029  -0.210  1.00 20.50           C  
ATOM   1573  CE  LYS A 201      12.601  27.132  -0.744  0.69 20.84           C  
ATOM   1574  NZ  LYS A 201      11.467  26.867   0.235  0.69 18.50           N  
ATOM   1575  N   HIS A 202      13.041  31.628   3.157  1.00 24.56           N  
ATOM   1576  CA  HIS A 202      12.193  31.687   4.351  1.00 24.59           C  
ATOM   1577  C   HIS A 202      11.447  33.025   4.565  1.00 24.52           C  
ATOM   1578  O   HIS A 202      10.250  33.027   4.858  1.00 24.55           O  
ATOM   1579  CB  HIS A 202      13.045  31.384   5.587  1.00 24.79           C  
ATOM   1580  CG  HIS A 202      12.289  31.502   6.867  1.00 25.24           C  
ATOM   1581  ND1 HIS A 202      11.425  30.523   7.310  1.00 26.60           N  
ATOM   1582  CD2 HIS A 202      12.237  32.495   7.785  1.00 24.59           C  
ATOM   1583  CE1 HIS A 202      10.879  30.905   8.450  1.00 25.42           C  
ATOM   1584  NE2 HIS A 202      11.361  32.094   8.763  1.00 24.84           N  
ATOM   1585  N   LEU A 203      12.156  34.149   4.462  1.00 24.21           N  
ATOM   1586  CA  LEU A 203      11.543  35.451   4.710  1.00 24.39           C  
ATOM   1587  C   LEU A 203      10.404  35.745   3.735  1.00 25.11           C  
ATOM   1588  O   LEU A 203       9.310  36.099   4.151  1.00 25.11           O  
ATOM   1589  CB  LEU A 203      12.582  36.568   4.645  1.00 24.04           C  
ATOM   1590  CG  LEU A 203      13.614  36.728   5.773  1.00 23.47           C  
ATOM   1591  CD1 LEU A 203      14.716  37.732   5.385  1.00 21.08           C  
ATOM   1592  CD2 LEU A 203      12.957  37.128   7.110  1.00 24.31           C  
ATOM   1593  N   ASP A 204      10.667  35.579   2.440  1.00 25.83           N  
ATOM   1594  CA  ASP A 204       9.672  35.843   1.407  1.00 26.23           C  
ATOM   1595  C   ASP A 204       8.834  34.605   1.171  1.00 26.79           C  
ATOM   1596  O   ASP A 204       7.901  34.592   0.352  1.00 26.75           O  
ATOM   1597  CB  ASP A 204      10.336  36.347   0.123  1.00 25.82           C  
ATOM   1598  CG  ASP A 204      10.654  37.820   0.187  1.00 25.46           C  
ATOM   1599  OD1 ASP A 204      11.612  38.281  -0.440  1.00 27.71           O  
ATOM   1600  OD2 ASP A 204       9.944  38.547   0.877  1.00 26.32           O  
ATOM   1601  N   ASN A 205       9.142  33.577   1.953  1.00 27.62           N  
ATOM   1602  CA  ASN A 205       8.502  32.260   1.818  1.00 28.41           C  
ATOM   1603  C   ASN A 205       8.365  31.804   0.350  1.00 27.68           C  
ATOM   1604  O   ASN A 205       7.276  31.503  -0.139  1.00 27.27           O  
ATOM   1605  CB  ASN A 205       7.178  32.183   2.594  1.00 28.85           C  
ATOM   1606  CG  ASN A 205       6.638  30.756   2.661  1.00 30.96           C  
ATOM   1607  OD1 ASN A 205       7.304  29.853   3.182  1.00 33.19           O  
ATOM   1608  ND2 ASN A 205       5.442  30.541   2.107  1.00 31.02           N  
ATOM   1609  N   LEU A 206       9.509  31.788  -0.326  1.00 27.31           N  
ATOM   1610  CA  LEU A 206       9.639  31.388  -1.715  1.00 27.16           C  
ATOM   1611  C   LEU A 206       9.557  29.859  -1.908  1.00 27.65           C  
ATOM   1612  O   LEU A 206      10.084  29.073  -1.106  1.00 28.15           O  
ATOM   1613  CB  LEU A 206      10.970  31.904  -2.269  1.00 26.50           C  
ATOM   1614  CG  LEU A 206      11.252  33.405  -2.197  1.00 25.45           C  
ATOM   1615  CD1 LEU A 206      12.668  33.693  -2.599  1.00 23.62           C  
ATOM   1616  CD2 LEU A 206      10.293  34.183  -3.096  1.00 25.60           C  
ATOM   1617  N   SER A 207       8.882  29.444  -2.971  1.00 27.67           N  
ATOM   1618  CA  SER A 207       8.966  28.073  -3.461  1.00 27.62           C  
ATOM   1619  C   SER A 207      10.435  27.727  -3.807  1.00 28.26           C  
ATOM   1620  O   SER A 207      11.284  28.628  -3.915  1.00 28.48           O  
ATOM   1621  CB  SER A 207       8.130  27.954  -4.729  1.00 26.75           C  
ATOM   1622  OG  SER A 207       8.752  28.692  -5.769  1.00 24.64           O  
ATOM   1623  N   GLU A 208      10.718  26.433  -3.992  1.00 28.51           N  
ATOM   1624  CA  GLU A 208      11.953  25.987  -4.633  1.00 28.93           C  
ATOM   1625  C   GLU A 208      12.173  26.765  -5.937  1.00 29.46           C  
ATOM   1626  O   GLU A 208      13.235  27.340  -6.139  1.00 30.08           O  
ATOM   1627  CB  GLU A 208      11.922  24.476  -4.940  1.00 29.01           C  
ATOM   1628  CG  GLU A 208      11.066  23.639  -4.026  1.00 27.99           C  
ATOM   1629  CD  GLU A 208      11.846  22.488  -3.428  1.00 27.05           C  
ATOM   1630  OE1 GLU A 208      12.185  21.544  -4.163  1.00 25.92           O  
ATOM   1631  OE2 GLU A 208      12.119  22.529  -2.212  1.00 28.06           O  
ATOM   1632  N   ALA A 209      11.169  26.788  -6.812  1.00 29.56           N  
ATOM   1633  CA  ALA A 209      11.266  27.501  -8.083  1.00 29.97           C  
ATOM   1634  C   ALA A 209      11.876  28.887  -7.934  1.00 29.95           C  
ATOM   1635  O   ALA A 209      13.046  29.078  -8.246  1.00 29.90           O  
ATOM   1636  CB  ALA A 209       9.888  27.577  -8.788  1.00 29.94           C  
ATOM   1637  N   ASP A 210      11.098  29.837  -7.435  1.00 30.27           N  
ATOM   1638  CA  ASP A 210      11.542  31.241  -7.362  1.00 31.02           C  
ATOM   1639  C   ASP A 210      12.929  31.489  -6.726  1.00 30.88           C  
ATOM   1640  O   ASP A 210      13.695  32.323  -7.197  1.00 31.25           O  
ATOM   1641  CB  ASP A 210      10.473  32.120  -6.693  1.00 31.22           C  
ATOM   1642  CG  ASP A 210       9.148  32.136  -7.467  1.00 32.16           C  
ATOM   1643  OD1 ASP A 210       9.138  31.748  -8.654  1.00 32.48           O  
ATOM   1644  OD2 ASP A 210       8.110  32.532  -6.881  1.00 33.08           O  
ATOM   1645  N   VAL A 211      13.266  30.746  -5.680  1.00 30.82           N  
ATOM   1646  CA  VAL A 211      14.543  30.951  -4.986  1.00 30.14           C  
ATOM   1647  C   VAL A 211      15.740  30.585  -5.851  1.00 29.84           C  
ATOM   1648  O   VAL A 211      16.804  31.143  -5.703  1.00 29.60           O  
ATOM   1649  CB  VAL A 211      14.572  30.248  -3.620  1.00 29.79           C  
ATOM   1650  CG1 VAL A 211      14.599  28.741  -3.774  1.00 29.18           C  
ATOM   1651  CG2 VAL A 211      15.736  30.754  -2.810  1.00 30.09           C  
ATOM   1652  N   LEU A 212      15.533  29.655  -6.771  1.00 30.60           N  
ATOM   1653  CA  LEU A 212      16.524  29.295  -7.788  1.00 30.70           C  
ATOM   1654  C   LEU A 212      16.607  30.338  -8.902  1.00 31.45           C  
ATOM   1655  O   LEU A 212      17.595  30.393  -9.630  1.00 31.88           O  
ATOM   1656  CB  LEU A 212      16.167  27.956  -8.429  1.00 29.84           C  
ATOM   1657  CG  LEU A 212      16.219  26.649  -7.649  1.00 28.27           C  
ATOM   1658  CD1 LEU A 212      15.549  25.535  -8.480  1.00 24.63           C  
ATOM   1659  CD2 LEU A 212      17.654  26.290  -7.292  1.00 26.11           C  
ATOM   1660  N   GLU A 213      15.557  31.126  -9.084  1.00 32.03           N  
ATOM   1661  CA  GLU A 213      15.615  32.170 -10.095  1.00 32.89           C  
ATOM   1662  C   GLU A 213      16.200  33.452  -9.462  1.00 32.43           C  
ATOM   1663  O   GLU A 213      16.488  34.427 -10.151  1.00 32.14           O  
ATOM   1664  CB  GLU A 213      14.238  32.389 -10.775  1.00 33.49           C  
ATOM   1665  CG  GLU A 213      13.256  33.323 -10.032  1.00 35.98           C  
ATOM   1666  CD  GLU A 213      11.783  33.145 -10.470  1.00 41.16           C  
ATOM   1667  OE1 GLU A 213      11.514  32.336 -11.408  1.00 43.21           O  
ATOM   1668  OE2 GLU A 213      10.888  33.803  -9.866  1.00 40.91           O  
ATOM   1669  N   LEU A 214      16.396  33.428  -8.147  1.00 31.83           N  
ATOM   1670  CA  LEU A 214      16.872  34.605  -7.456  1.00 31.47           C  
ATOM   1671  C   LEU A 214      18.401  34.749  -7.507  1.00 31.21           C  
ATOM   1672  O   LEU A 214      19.134  33.909  -6.957  1.00 30.07           O  
ATOM   1673  CB  LEU A 214      16.336  34.653  -6.007  1.00 31.36           C  
ATOM   1674  CG  LEU A 214      16.740  35.849  -5.113  1.00 31.64           C  
ATOM   1675  CD1 LEU A 214      16.217  37.236  -5.609  1.00 30.01           C  
ATOM   1676  CD2 LEU A 214      16.339  35.596  -3.659  1.00 30.41           C  
ATOM   1677  N   ASN A 215      18.847  35.839  -8.156  1.00 31.30           N  
ATOM   1678  CA  ASN A 215      20.262  36.276  -8.165  1.00 31.78           C  
ATOM   1679  C   ASN A 215      20.596  37.543  -7.298  1.00 31.65           C  
ATOM   1680  O   ASN A 215      20.180  38.675  -7.618  1.00 32.15           O  
ATOM   1681  CB  ASN A 215      20.761  36.482  -9.604  1.00 31.84           C  
ATOM   1682  CG  ASN A 215      20.651  35.217 -10.490  1.00 32.98           C  
ATOM   1683  OD1 ASN A 215      20.597  35.333 -11.711  1.00 32.74           O  
ATOM   1684  ND2 ASN A 215      20.643  34.026  -9.884  1.00 35.46           N  
ATOM   1685  N   ILE A 216      21.341  37.345  -6.207  1.00 30.63           N  
ATOM   1686  CA  ILE A 216      21.755  38.449  -5.347  1.00 30.01           C  
ATOM   1687  C   ILE A 216      23.089  39.017  -5.817  1.00 29.62           C  
ATOM   1688  O   ILE A 216      24.103  38.324  -5.797  1.00 29.73           O  
ATOM   1689  CB  ILE A 216      21.882  38.025  -3.867  1.00 29.74           C  
ATOM   1690  CG1 ILE A 216      20.510  37.671  -3.290  1.00 29.64           C  
ATOM   1691  CG2 ILE A 216      22.535  39.137  -3.053  1.00 29.86           C  
ATOM   1692  CD1 ILE A 216      20.561  36.828  -2.002  1.00 29.38           C  
ATOM   1693  N   PRO A 217      23.097  40.286  -6.236  1.00 29.16           N  
ATOM   1694  CA  PRO A 217      24.353  40.892  -6.708  1.00 28.87           C  
ATOM   1695  C   PRO A 217      25.373  41.059  -5.570  1.00 28.55           C  
ATOM   1696  O   PRO A 217      24.984  41.139  -4.400  1.00 28.94           O  
ATOM   1697  CB  PRO A 217      23.906  42.260  -7.243  1.00 28.97           C  
ATOM   1698  CG  PRO A 217      22.589  42.557  -6.513  1.00 28.87           C  
ATOM   1699  CD  PRO A 217      21.949  41.214  -6.286  1.00 29.11           C  
ATOM   1700  N   THR A 218      26.656  41.100  -5.913  1.00 27.41           N  
ATOM   1701  CA  THR A 218      27.713  41.198  -4.925  1.00 26.58           C  
ATOM   1702  C   THR A 218      27.912  42.650  -4.459  1.00 26.48           C  
ATOM   1703  O   THR A 218      27.802  43.590  -5.253  1.00 27.34           O  
ATOM   1704  CB  THR A 218      29.057  40.742  -5.519  1.00 26.56           C  
ATOM   1705  OG1 THR A 218      29.405  41.629  -6.579  1.00 26.17           O  
ATOM   1706  CG2 THR A 218      29.001  39.322  -6.055  1.00 25.55           C  
ATOM   1707  N   GLY A 219      28.248  42.838  -3.186  1.00 25.62           N  
ATOM   1708  CA  GLY A 219      28.516  44.171  -2.654  1.00 24.41           C  
ATOM   1709  C   GLY A 219      27.363  45.168  -2.580  1.00 23.73           C  
ATOM   1710  O   GLY A 219      27.613  46.359  -2.361  1.00 24.12           O  
ATOM   1711  N   VAL A 220      26.120  44.711  -2.747  1.00 22.71           N  
ATOM   1712  CA  VAL A 220      24.953  45.592  -2.677  1.00 22.42           C  
ATOM   1713  C   VAL A 220      24.073  45.290  -1.455  1.00 22.60           C  
ATOM   1714  O   VAL A 220      23.516  44.174  -1.358  1.00 22.65           O  
ATOM   1715  CB  VAL A 220      24.060  45.516  -3.972  1.00 22.51           C  
ATOM   1716  CG1 VAL A 220      22.802  46.334  -3.804  1.00 21.96           C  
ATOM   1717  CG2 VAL A 220      24.797  46.008  -5.182  1.00 22.22           C  
ATOM   1718  N   PRO A 221      23.917  46.278  -0.529  1.00 22.43           N  
ATOM   1719  CA  PRO A 221      23.056  46.022   0.651  1.00 22.47           C  
ATOM   1720  C   PRO A 221      21.605  45.719   0.270  1.00 22.39           C  
ATOM   1721  O   PRO A 221      21.054  46.390  -0.577  1.00 22.60           O  
ATOM   1722  CB  PRO A 221      23.162  47.328   1.470  1.00 21.80           C  
ATOM   1723  CG  PRO A 221      24.427  47.993   0.999  1.00 21.42           C  
ATOM   1724  CD  PRO A 221      24.511  47.631  -0.477  1.00 22.15           C  
ATOM   1725  N   LEU A 222      21.015  44.702   0.895  1.00 23.04           N  
ATOM   1726  CA  LEU A 222      19.600  44.314   0.699  1.00 22.77           C  
ATOM   1727  C   LEU A 222      18.839  44.584   2.016  1.00 22.96           C  
ATOM   1728  O   LEU A 222      18.982  43.849   3.004  1.00 23.04           O  
ATOM   1729  CB  LEU A 222      19.509  42.828   0.252  1.00 21.67           C  
ATOM   1730  CG  LEU A 222      18.187  42.060   0.032  1.00 22.10           C  
ATOM   1731  CD1 LEU A 222      17.219  42.699  -0.960  1.00 19.12           C  
ATOM   1732  CD2 LEU A 222      18.442  40.604  -0.381  1.00 21.83           C  
ATOM   1733  N   VAL A 223      18.039  45.648   2.022  1.00 22.85           N  
ATOM   1734  CA  VAL A 223      17.308  46.052   3.217  1.00 22.80           C  
ATOM   1735  C   VAL A 223      15.917  45.411   3.236  1.00 23.26           C  
ATOM   1736  O   VAL A 223      15.121  45.568   2.297  1.00 23.15           O  
ATOM   1737  CB  VAL A 223      17.156  47.603   3.297  1.00 22.79           C  
ATOM   1738  CG1 VAL A 223      16.346  48.013   4.491  1.00 22.52           C  
ATOM   1739  CG2 VAL A 223      18.507  48.301   3.332  1.00 23.10           C  
ATOM   1740  N   TYR A 224      15.653  44.667   4.306  1.00 23.74           N  
ATOM   1741  CA  TYR A 224      14.337  44.110   4.588  1.00 23.73           C  
ATOM   1742  C   TYR A 224      13.703  44.851   5.721  1.00 23.92           C  
ATOM   1743  O   TYR A 224      14.340  45.092   6.755  1.00 23.20           O  
ATOM   1744  CB  TYR A 224      14.471  42.673   5.003  1.00 23.74           C  
ATOM   1745  CG  TYR A 224      14.333  41.742   3.851  1.00 25.97           C  
ATOM   1746  CD1 TYR A 224      15.441  41.372   3.083  1.00 24.83           C  
ATOM   1747  CD2 TYR A 224      13.069  41.237   3.504  1.00 26.74           C  
ATOM   1748  CE1 TYR A 224      15.286  40.514   2.004  1.00 25.66           C  
ATOM   1749  CE2 TYR A 224      12.914  40.380   2.448  1.00 26.63           C  
ATOM   1750  CZ  TYR A 224      14.018  40.019   1.700  1.00 25.72           C  
ATOM   1751  OH  TYR A 224      13.816  39.175   0.644  1.00 25.42           O  
ATOM   1752  N   GLU A 225      12.444  45.210   5.517  1.00 24.53           N  
ATOM   1753  CA  GLU A 225      11.635  45.887   6.513  1.00 25.74           C  
ATOM   1754  C   GLU A 225      10.679  44.869   7.037  1.00 25.09           C  
ATOM   1755  O   GLU A 225       9.864  44.370   6.273  1.00 25.66           O  
ATOM   1756  CB  GLU A 225      10.801  46.964   5.822  1.00 26.91           C  
ATOM   1757  CG  GLU A 225      11.553  48.204   5.419  1.00 30.82           C  
ATOM   1758  CD  GLU A 225      11.513  49.212   6.520  1.00 37.85           C  
ATOM   1759  OE1 GLU A 225      12.392  49.075   7.423  1.00 38.31           O  
ATOM   1760  OE2 GLU A 225      10.590  50.094   6.482  1.00 38.55           O  
ATOM   1761  N   LEU A 226      10.751  44.543   8.316  1.00 25.19           N  
ATOM   1762  CA  LEU A 226       9.930  43.430   8.839  1.00 25.54           C  
ATOM   1763  C   LEU A 226       8.946  43.870   9.904  1.00 26.15           C  
ATOM   1764  O   LEU A 226       9.250  44.762  10.677  1.00 26.98           O  
ATOM   1765  CB  LEU A 226      10.809  42.284   9.378  1.00 24.93           C  
ATOM   1766  CG  LEU A 226      12.054  41.826   8.606  1.00 23.25           C  
ATOM   1767  CD1 LEU A 226      12.854  40.812   9.426  1.00 20.47           C  
ATOM   1768  CD2 LEU A 226      11.674  41.253   7.234  1.00 22.58           C  
ATOM   1769  N   ASP A 227       7.772  43.239   9.961  1.00 27.25           N  
ATOM   1770  CA  ASP A 227       6.774  43.550  11.010  1.00 27.36           C  
ATOM   1771  C   ASP A 227       7.034  42.789  12.343  1.00 27.36           C  
ATOM   1772  O   ASP A 227       8.024  42.063  12.456  1.00 26.62           O  
ATOM   1773  CB  ASP A 227       5.327  43.377  10.478  1.00 27.05           C  
ATOM   1774  CG  ASP A 227       4.935  41.922  10.241  1.00 27.97           C  
ATOM   1775  OD1 ASP A 227       5.299  41.014  11.030  1.00 29.83           O  
ATOM   1776  OD2 ASP A 227       4.209  41.679   9.259  1.00 29.96           O  
ATOM   1777  N   GLU A 228       6.145  42.972  13.332  1.00 27.93           N  
ATOM   1778  CA  GLU A 228       6.256  42.329  14.650  1.00 28.30           C  
ATOM   1779  C   GLU A 228       6.352  40.796  14.611  1.00 28.03           C  
ATOM   1780  O   GLU A 228       6.847  40.193  15.552  1.00 27.37           O  
ATOM   1781  CB  GLU A 228       5.108  42.757  15.585  1.00 28.82           C  
ATOM   1782  CG  GLU A 228       5.191  42.149  17.039  1.00 30.83           C  
ATOM   1783  CD  GLU A 228       6.467  42.568  17.845  1.00 33.82           C  
ATOM   1784  OE1 GLU A 228       6.425  43.613  18.559  1.00 31.82           O  
ATOM   1785  OE2 GLU A 228       7.499  41.836  17.780  1.00 34.70           O  
ATOM   1786  N   ASN A 229       5.856  40.179  13.540  1.00 28.09           N  
ATOM   1787  CA  ASN A 229       6.018  38.742  13.349  1.00 28.22           C  
ATOM   1788  C   ASN A 229       7.160  38.420  12.364  1.00 28.09           C  
ATOM   1789  O   ASN A 229       7.138  37.371  11.733  1.00 28.29           O  
ATOM   1790  CB  ASN A 229       4.713  38.096  12.833  1.00 28.34           C  
ATOM   1791  CG  ASN A 229       3.457  38.693  13.445  1.00 28.09           C  
ATOM   1792  OD1 ASN A 229       3.231  38.606  14.655  1.00 27.27           O  
ATOM   1793  ND2 ASN A 229       2.612  39.283  12.594  1.00 27.66           N  
ATOM   1794  N   LEU A 230       8.124  39.327  12.207  1.00 28.14           N  
ATOM   1795  CA  LEU A 230       9.228  39.187  11.229  1.00 28.50           C  
ATOM   1796  C   LEU A 230       8.849  38.753   9.780  1.00 28.99           C  
ATOM   1797  O   LEU A 230       9.667  38.119   9.096  1.00 28.51           O  
ATOM   1798  CB  LEU A 230      10.310  38.225  11.760  1.00 28.68           C  
ATOM   1799  CG  LEU A 230      10.736  38.227  13.228  1.00 27.50           C  
ATOM   1800  CD1 LEU A 230      11.726  37.129  13.429  1.00 25.91           C  
ATOM   1801  CD2 LEU A 230      11.324  39.552  13.590  1.00 26.71           C  
ATOM   1802  N   LYS A 231       7.617  39.050   9.335  1.00 28.89           N  
ATOM   1803  CA  LYS A 231       7.257  38.853   7.930  1.00 29.16           C  
ATOM   1804  C   LYS A 231       7.508  40.185   7.200  1.00 28.94           C  
ATOM   1805  O   LYS A 231       7.204  41.247   7.740  1.00 28.34           O  
ATOM   1806  CB  LYS A 231       5.813  38.304   7.759  1.00 29.29           C  
ATOM   1807  CG  LYS A 231       4.692  39.359   7.602  1.00 30.64           C  
ATOM   1808  CD  LYS A 231       3.289  38.737   7.647  1.00 33.92           C  
ATOM   1809  CE  LYS A 231       2.587  38.677   6.266  1.00 34.94           C  
ATOM   1810  NZ  LYS A 231       3.186  37.690   5.297  1.00 35.98           N  
ATOM   1811  N   PRO A 232       8.137  40.140   6.009  1.00 29.04           N  
ATOM   1812  CA  PRO A 232       8.511  41.377   5.310  1.00 28.98           C  
ATOM   1813  C   PRO A 232       7.329  42.286   5.047  1.00 28.89           C  
ATOM   1814  O   PRO A 232       6.209  41.817   4.919  1.00 28.65           O  
ATOM   1815  CB  PRO A 232       9.099  40.878   3.976  1.00 28.41           C  
ATOM   1816  CG  PRO A 232       9.546  39.528   4.241  1.00 28.88           C  
ATOM   1817  CD  PRO A 232       8.598  38.952   5.277  1.00 29.33           C  
ATOM   1818  N   ILE A 233       7.612  43.582   4.962  1.00 29.06           N  
ATOM   1819  CA  ILE A 233       6.661  44.608   4.555  1.00 28.90           C  
ATOM   1820  C   ILE A 233       7.057  45.038   3.132  1.00 28.78           C  
ATOM   1821  O   ILE A 233       6.203  45.194   2.252  1.00 28.28           O  
ATOM   1822  CB  ILE A 233       6.685  45.804   5.573  1.00 29.21           C  
ATOM   1823  CG1 ILE A 233       6.018  45.402   6.896  1.00 29.15           C  
ATOM   1824  CG2 ILE A 233       6.054  47.097   4.988  1.00 29.52           C  
ATOM   1825  CD1 ILE A 233       6.166  46.422   8.010  1.00 31.19           C  
ATOM   1826  N   LYS A 234       8.371  45.211   2.935  1.00 28.83           N  
ATOM   1827  CA  LYS A 234       9.011  45.550   1.647  1.00 28.40           C  
ATOM   1828  C   LYS A 234      10.504  45.217   1.755  1.00 28.25           C  
ATOM   1829  O   LYS A 234      10.992  44.942   2.852  1.00 27.81           O  
ATOM   1830  CB  LYS A 234       8.801  47.024   1.265  1.00 27.78           C  
ATOM   1831  CG  LYS A 234       9.526  48.047   2.148  1.00 28.29           C  
ATOM   1832  CD  LYS A 234       8.859  49.457   2.083  1.00 29.29           C  
ATOM   1833  CE  LYS A 234       9.075  50.254   3.389  1.00 28.87           C  
ATOM   1834  NZ  LYS A 234       7.839  51.010   3.746  1.00 29.83           N  
ATOM   1835  N   HIS A 235      11.210  45.237   0.626  1.00 28.35           N  
ATOM   1836  CA  HIS A 235      12.659  45.001   0.594  1.00 29.09           C  
ATOM   1837  C   HIS A 235      13.307  45.735  -0.585  1.00 29.28           C  
ATOM   1838  O   HIS A 235      12.796  45.694  -1.703  1.00 29.08           O  
ATOM   1839  CB  HIS A 235      12.999  43.481   0.601  1.00 28.87           C  
ATOM   1840  CG  HIS A 235      12.630  42.756  -0.660  1.00 30.10           C  
ATOM   1841  ND1 HIS A 235      13.480  42.665  -1.746  1.00 31.34           N  
ATOM   1842  CD2 HIS A 235      11.505  42.087  -1.007  1.00 29.82           C  
ATOM   1843  CE1 HIS A 235      12.893  41.968  -2.703  1.00 29.88           C  
ATOM   1844  NE2 HIS A 235      11.690  41.617  -2.285  1.00 27.76           N  
ATOM   1845  N   TYR A 236      14.424  46.413  -0.344  1.00 29.96           N  
ATOM   1846  CA  TYR A 236      15.043  47.253  -1.390  1.00 30.42           C  
ATOM   1847  C   TYR A 236      16.539  47.259  -1.334  1.00 31.45           C  
ATOM   1848  O   TYR A 236      17.134  47.146  -0.243  1.00 31.88           O  
ATOM   1849  CB  TYR A 236      14.582  48.705  -1.304  1.00 29.52           C  
ATOM   1850  CG  TYR A 236      14.671  49.313   0.073  1.00 29.72           C  
ATOM   1851  CD1 TYR A 236      15.791  50.058   0.479  1.00 29.57           C  
ATOM   1852  CD2 TYR A 236      13.617  49.159   0.974  1.00 28.33           C  
ATOM   1853  CE1 TYR A 236      15.824  50.637   1.752  1.00 29.51           C  
ATOM   1854  CE2 TYR A 236      13.645  49.710   2.225  1.00 27.23           C  
ATOM   1855  CZ  TYR A 236      14.734  50.442   2.623  1.00 28.32           C  
ATOM   1856  OH  TYR A 236      14.703  50.959   3.900  1.00 27.33           O  
ATOM   1857  N   TYR A 237      17.135  47.416  -2.517  1.00 32.47           N  
ATOM   1858  CA  TYR A 237      18.577  47.544  -2.668  1.00 33.46           C  
ATOM   1859  C   TYR A 237      19.007  48.976  -2.536  1.00 34.84           C  
ATOM   1860  O   TYR A 237      18.486  49.852  -3.248  1.00 34.90           O  
ATOM   1861  CB  TYR A 237      19.019  47.033  -4.033  1.00 33.30           C  
ATOM   1862  CG  TYR A 237      19.072  45.531  -4.143  1.00 32.64           C  
ATOM   1863  CD1 TYR A 237      19.885  44.779  -3.283  1.00 31.08           C  
ATOM   1864  CD2 TYR A 237      18.322  44.865  -5.109  1.00 30.99           C  
ATOM   1865  CE1 TYR A 237      19.948  43.420  -3.383  1.00 31.27           C  
ATOM   1866  CE2 TYR A 237      18.377  43.500  -5.219  1.00 31.60           C  
ATOM   1867  CZ  TYR A 237      19.188  42.784  -4.348  1.00 32.24           C  
ATOM   1868  OH  TYR A 237      19.257  41.427  -4.454  1.00 33.92           O  
ATOM   1869  N   LEU A 238      19.947  49.211  -1.617  1.00 36.44           N  
ATOM   1870  CA  LEU A 238      20.581  50.520  -1.463  1.00 38.27           C  
ATOM   1871  C   LEU A 238      21.694  50.739  -2.495  1.00 39.41           C  
ATOM   1872  O   LEU A 238      22.883  50.497  -2.237  1.00 39.78           O  
ATOM   1873  CB  LEU A 238      21.134  50.727  -0.044  1.00 38.37           C  
ATOM   1874  CG  LEU A 238      20.429  51.641   0.975  1.00 38.70           C  
ATOM   1875  CD1 LEU A 238      21.376  51.897   2.158  1.00 37.42           C  
ATOM   1876  CD2 LEU A 238      19.964  52.981   0.376  1.00 38.25           C  
ATOM   1877  N   LEU A 239      21.287  51.192  -3.672  1.00 40.66           N  
ATOM   1878  CA  LEU A 239      22.221  51.671  -4.684  1.00 41.67           C  
ATOM   1879  C   LEU A 239      21.536  52.695  -5.571  1.00 42.63           C  
ATOM   1880  O   LEU A 239      20.303  52.786  -5.561  1.00 42.36           O  
ATOM   1881  CB  LEU A 239      22.808  50.523  -5.517  1.00 41.00           C  
ATOM   1882  CG  LEU A 239      24.288  50.196  -5.302  1.00 40.48           C  
ATOM   1883  CD1 LEU A 239      24.828  49.284  -6.427  1.00 38.64           C  
ATOM   1884  CD2 LEU A 239      25.134  51.462  -5.198  1.00 39.28           C  
ATOM   1885  N   ASP A 240      22.339  53.479  -6.303  1.00 44.15           N  
ATOM   1886  CA  ASP A 240      21.807  54.383  -7.315  1.00 46.01           C  
ATOM   1887  C   ASP A 240      21.335  53.532  -8.496  1.00 46.55           C  
ATOM   1888  O   ASP A 240      22.088  52.656  -8.948  1.00 46.89           O  
ATOM   1889  CB  ASP A 240      22.861  55.416  -7.757  1.00 46.35           C  
ATOM   1890  CG  ASP A 240      23.745  54.905  -8.876  1.00 47.02           C  
ATOM   1891  OD1 ASP A 240      24.417  53.871  -8.652  1.00 48.16           O  
ATOM   1892  OD2 ASP A 240      23.747  55.522  -9.969  1.00 45.21           O  
ATOM   1893  N   SER A 241      20.105  53.785  -8.969  1.00 47.09           N  
ATOM   1894  CA  SER A 241      19.455  53.006 -10.057  1.00 47.72           C  
ATOM   1895  C   SER A 241      20.140  53.053 -11.456  1.00 47.93           C  
ATOM   1896  O   SER A 241      19.474  52.943 -12.501  1.00 48.12           O  
ATOM   1897  CB  SER A 241      17.950  53.364 -10.171  1.00 47.83           C  
ATOM   1898  OG  SER A 241      17.095  52.333  -9.676  1.00 48.16           O  
ATOM   1899  N   GLU A 242      21.463  53.214 -11.466  1.00 48.10           N  
ATOM   1900  CA  GLU A 242      22.263  53.095 -12.691  1.00 48.23           C  
ATOM   1901  C   GLU A 242      23.367  52.055 -12.523  1.00 48.35           C  
ATOM   1902  O   GLU A 242      23.727  51.358 -13.472  1.00 47.91           O  
ATOM   1903  CB  GLU A 242      22.856  54.447 -13.120  1.00 48.14           C  
ATOM   1904  CG  GLU A 242      21.830  55.475 -13.609  1.00 48.06           C  
ATOM   1905  CD  GLU A 242      20.989  55.001 -14.799  1.00 47.63           C  
ATOM   1906  OE1 GLU A 242      21.315  53.967 -15.426  1.00 46.72           O  
ATOM   1907  OE2 GLU A 242      19.991  55.685 -15.108  1.00 47.95           O  
ATOM   1908  N   GLU A 243      23.904  51.963 -11.310  1.00 48.81           N  
ATOM   1909  CA  GLU A 243      24.832  50.896 -10.989  1.00 49.58           C  
ATOM   1910  C   GLU A 243      24.069  49.613 -10.742  1.00 49.62           C  
ATOM   1911  O   GLU A 243      24.503  48.556 -11.181  1.00 49.28           O  
ATOM   1912  CB  GLU A 243      25.684  51.242  -9.778  1.00 49.67           C  
ATOM   1913  CG  GLU A 243      26.823  52.167 -10.097  1.00 51.21           C  
ATOM   1914  CD  GLU A 243      27.335  52.874  -8.862  1.00 53.72           C  
ATOM   1915  OE1 GLU A 243      26.981  52.440  -7.737  1.00 52.98           O  
ATOM   1916  OE2 GLU A 243      28.089  53.867  -9.019  1.00 54.94           O  
ATOM   1917  N   LEU A 244      22.933  49.719 -10.048  1.00 49.86           N  
ATOM   1918  CA  LEU A 244      22.088  48.564  -9.747  1.00 50.31           C  
ATOM   1919  C   LEU A 244      21.701  47.777 -11.013  1.00 50.70           C  
ATOM   1920  O   LEU A 244      21.885  46.552 -11.069  1.00 50.42           O  
ATOM   1921  CB  LEU A 244      20.839  48.977  -8.946  1.00 50.26           C  
ATOM   1922  CG  LEU A 244      19.846  47.874  -8.523  1.00 50.46           C  
ATOM   1923  CD1 LEU A 244      20.499  46.832  -7.611  1.00 49.50           C  
ATOM   1924  CD2 LEU A 244      18.589  48.459  -7.859  1.00 50.64           C  
ATOM   1925  N   LYS A 245      21.172  48.483 -12.018  1.00 51.16           N  
ATOM   1926  CA  LYS A 245      20.827  47.860 -13.304  1.00 51.37           C  
ATOM   1927  C   LYS A 245      22.044  47.171 -13.937  1.00 51.50           C  
ATOM   1928  O   LYS A 245      21.945  46.045 -14.405  1.00 51.67           O  
ATOM   1929  CB  LYS A 245      20.193  48.877 -14.261  1.00 51.35           C  
ATOM   1930  CG  LYS A 245      18.835  49.396 -13.789  1.00 51.49           C  
ATOM   1931  CD  LYS A 245      18.018  50.005 -14.929  1.00 51.36           C  
ATOM   1932  CE  LYS A 245      18.459  51.425 -15.274  1.00 50.55           C  
ATOM   1933  NZ  LYS A 245      17.898  51.819 -16.595  1.00 49.51           N  
ATOM   1934  N   LYS A 246      23.190  47.849 -13.919  1.00 51.77           N  
ATOM   1935  CA  LYS A 246      24.456  47.285 -14.387  1.00 52.11           C  
ATOM   1936  C   LYS A 246      24.817  46.065 -13.534  1.00 52.10           C  
ATOM   1937  O   LYS A 246      25.035  44.966 -14.050  1.00 52.42           O  
ATOM   1938  CB  LYS A 246      25.560  48.360 -14.314  1.00 52.30           C  
ATOM   1939  CG  LYS A 246      26.845  48.075 -15.105  1.00 52.49           C  
ATOM   1940  CD  LYS A 246      27.738  49.323 -15.165  1.00 52.04           C  
ATOM   1941  CE  LYS A 246      28.649  49.297 -16.400  1.00 52.13           C  
ATOM   1942  NZ  LYS A 246      29.117  50.659 -16.806  1.00 50.28           N  
ATOM   1943  N   LYS A 247      24.827  46.273 -12.221  1.00 52.05           N  
ATOM   1944  CA  LYS A 247      25.187  45.269 -11.216  1.00 51.97           C  
ATOM   1945  C   LYS A 247      24.241  44.046 -11.176  1.00 51.94           C  
ATOM   1946  O   LYS A 247      24.465  43.114 -10.415  1.00 52.20           O  
ATOM   1947  CB  LYS A 247      25.269  45.970  -9.836  1.00 51.78           C  
ATOM   1948  CG  LYS A 247      25.821  45.161  -8.671  1.00 52.02           C  
ATOM   1949  CD  LYS A 247      27.293  44.798  -8.822  1.00 52.65           C  
ATOM   1950  CE  LYS A 247      28.208  45.863  -8.259  1.00 52.37           C  
ATOM   1951  NZ  LYS A 247      29.432  45.216  -7.691  1.00 53.26           N  
ATOM   1952  N   MET A 248      23.191  44.042 -11.988  1.00 51.87           N  
ATOM   1953  CA  MET A 248      22.248  42.931 -11.965  1.00 51.80           C  
ATOM   1954  C   MET A 248      22.562  41.864 -13.031  1.00 52.36           C  
ATOM   1955  O   MET A 248      21.912  41.790 -14.084  1.00 52.30           O  
ATOM   1956  CB  MET A 248      20.795  43.428 -12.005  1.00 51.44           C  
ATOM   1957  CG  MET A 248      20.333  44.033 -10.669  1.00 49.48           C  
ATOM   1958  SD  MET A 248      19.946  42.789  -9.420  1.00 45.34           S  
ATOM   1959  CE  MET A 248      18.176  42.707  -9.620  1.00 46.00           C  
ATOM   1960  N   ASP A 249      23.588  41.059 -12.727  1.00 52.59           N  
ATOM   1961  CA  ASP A 249      24.011  39.886 -13.527  1.00 52.65           C  
ATOM   1962  C   ASP A 249      24.938  38.928 -12.727  1.00 52.52           C  
ATOM   1963  O   ASP A 249      24.472  37.895 -12.222  1.00 52.30           O  
ATOM   1964  CB  ASP A 249      24.633  40.280 -14.894  1.00 52.56           C  
ATOM   1965  CG  ASP A 249      25.291  41.664 -14.882  1.00 52.65           C  
ATOM   1966  OD1 ASP A 249      24.689  42.606 -15.442  1.00 51.72           O  
ATOM   1967  OD2 ASP A 249      26.397  41.810 -14.316  1.00 52.40           O  
TER    1968      ASP A 249                                                      
END
MOLECULE T0394.pdb
ATOM      1  N   ASN     1       7.131  28.263  26.435  1.00 37.08           N  
ATOM      2  CA  ASN     1       7.437  29.315  25.416  1.00 36.05           C  
ATOM      3  C   ASN     1       7.192  30.735  25.903  1.00 34.53           C  
ATOM      4  O   ASN     1       6.216  30.997  26.611  1.00 34.93           O  
ATOM      5  CB  ASN     1       6.662  29.047  24.125  1.00 37.00           C  
ATOM      6  CG  ASN     1       7.395  28.086  23.213  1.00 39.47           C  
ATOM      7  OD1 ASN     1       7.200  26.869  23.286  1.00 43.62           O  
ATOM      8  ND2 ASN     1       8.288  28.624  22.384  1.00 40.23           N  
ATOM      9  N   LEU     2       8.082  31.640  25.492  1.00 32.19           N  
ATOM     10  CA  LEU     2       8.122  33.016  25.993  1.00 29.95           C  
ATOM     11  C   LEU     2       7.110  33.917  25.298  1.00 28.07           C  
ATOM     12  O   LEU     2       6.983  33.894  24.068  1.00 28.29           O  
ATOM     13  CB  LEU     2       9.527  33.600  25.804  1.00 29.69           C  
ATOM     14  CG  LEU     2      10.670  32.930  26.564  1.00 29.92           C  
ATOM     15  CD1 LEU     2      12.000  33.222  25.886  1.00 29.23           C  
ATOM     16  CD2 LEU     2      10.663  33.446  27.989  1.00 28.60           C  
ATOM     17  N   TYR     3       6.407  34.722  26.095  1.00 25.72           N  
ATOM     18  CA  TYR     3       5.529  35.769  25.587  1.00 24.38           C  
ATOM     19  C   TYR     3       6.320  37.041  25.320  1.00 23.44           C  
ATOM     20  O   TYR     3       7.033  37.574  26.203  1.00 21.70           O  
ATOM     21  CB  TYR     3       4.386  36.067  26.569  1.00 24.95           C  
ATOM     22  CG  TYR     3       3.542  37.283  26.201  1.00 24.49           C  
ATOM     23  CD1 TYR     3       2.296  37.140  25.578  1.00 25.41           C  
ATOM     24  CD2 TYR     3       3.986  38.574  26.489  1.00 24.54           C  
ATOM     25  CE1 TYR     3       1.528  38.265  25.239  1.00 26.31           C  
ATOM     26  CE2 TYR     3       3.232  39.700  26.154  1.00 24.99           C  
ATOM     27  CZ  TYR     3       2.015  39.541  25.528  1.00 26.12           C  
ATOM     28  OH  TYR     3       1.282  40.675  25.217  1.00 29.19           O  
ATOM     29  N   PHE     4       6.198  37.532  24.092  1.00 21.28           N  
ATOM     30  CA  PHE     4       6.804  38.796  23.732  1.00 21.92           C  
ATOM     31  C   PHE     4       5.758  39.769  23.248  1.00 22.33           C  
ATOM     32  O   PHE     4       4.744  39.358  22.707  1.00 21.26           O  
ATOM     33  CB  PHE     4       7.841  38.598  22.620  1.00 21.80           C  
ATOM     34  CG  PHE     4       9.019  37.763  23.036  1.00 20.69           C  
ATOM     35  CD1 PHE     4       9.930  38.245  23.973  1.00 18.93           C  
ATOM     36  CD2 PHE     4       9.209  36.497  22.501  1.00 21.68           C  
ATOM     37  CE1 PHE     4      11.035  37.458  24.352  1.00 20.05           C  
ATOM     38  CE2 PHE     4      10.302  35.717  22.866  1.00 22.45           C  
ATOM     39  CZ  PHE     4      11.222  36.218  23.803  1.00 21.82           C  
ATOM     40  N   GLN     5       6.032  41.054  23.450  1.00 22.99           N  
ATOM     41  CA  GLN     5       5.226  42.107  22.871  1.00 24.75           C  
ATOM     42  C   GLN     5       5.521  42.151  21.367  1.00 23.85           C  
ATOM     43  O   GLN     5       6.451  41.461  20.899  1.00 23.54           O  
ATOM     44  CB  GLN     5       5.532  43.444  23.553  1.00 26.07           C  
ATOM     45  CG  GLN     5       5.034  43.473  25.022  1.00 31.04           C  
ATOM     46  CD  GLN     5       4.811  44.878  25.566  1.00 37.81           C  
ATOM     47  OE1 GLN     5       5.661  45.777  25.403  1.00 41.06           O  
ATOM     48  NE2 GLN     5       3.660  45.079  26.215  1.00 38.49           N  
ATOM     49  N   SER     6       4.726  42.924  20.628  1.00 23.52           N  
ATOM     50  CA  SER     6       4.940  43.126  19.191  0.50 23.55           C  
ATOM     52  C   SER     6       6.337  43.702  18.962  1.00 22.75           C  
ATOM     53  O   SER     6       6.858  44.463  19.805  1.00 22.96           O  
ATOM     54  CB  SER     6       3.856  44.057  18.638  0.50 23.94           C  
ATOM     56  OG  SER     6       3.940  44.174  17.233  0.50 25.41           O  
ATOM     58  N   ALA     7       6.977  43.335  17.852  1.00 21.09           N  
ATOM     59  CA  ALA     7       8.341  43.796  17.589  1.00 19.34           C  
ATOM     60  C   ALA     7       8.616  43.806  16.096  1.00 18.62           C  
ATOM     61  O   ALA     7       7.962  43.078  15.352  1.00 17.81           O  
ATOM     62  CB  ALA     7       9.361  42.902  18.314  1.00 18.58           C  
ATOM     63  N   ARG     8       9.540  44.662  15.692  1.00 17.77           N  
ATOM     64  CA  ARG     8       9.981  44.808  14.311  1.00 18.09           C  
ATOM     65  C   ARG     8      11.475  45.003  14.342  1.00 17.38           C  
ATOM     66  O   ARG     8      11.988  45.711  15.227  1.00 16.45           O  
ATOM     67  CB  ARG     8       9.398  46.071  13.683  1.00 19.36           C  
ATOM     68  CG  ARG     8       7.946  46.007  13.335  1.00 23.70           C  
ATOM     69  CD  ARG     8       7.465  47.406  12.982  1.00 28.18           C  
ATOM     70  NE  ARG     8       7.941  47.887  11.680  1.00 30.83           N  
ATOM     71  CZ  ARG     8       8.710  48.960  11.501  1.00 30.42           C  
ATOM     72  NH1 ARG     8       9.117  49.682  12.536  1.00 32.52           N  
ATOM     73  NH2 ARG     8       9.060  49.316  10.274  1.00 29.09           N  
ATOM     74  N   PHE     9      12.184  44.376  13.397  1.00 15.44           N  
ATOM     75  CA  PHE     9      13.609  44.661  13.228  1.00 14.36           C  
ATOM     76  C   PHE     9      14.024  44.617  11.750  1.00 14.07           C  
ATOM     77  O   PHE     9      13.327  44.021  10.922  1.00 14.11           O  
ATOM     78  CB  PHE     9      14.503  43.808  14.139  1.00 14.06           C  
ATOM     79  CG  PHE     9      14.646  42.339  13.723  1.00 14.99           C  
ATOM     80  CD1 PHE     9      15.716  41.917  12.893  1.00 14.73           C  
ATOM     81  CD2 PHE     9      13.778  41.373  14.237  1.00 14.99           C  
ATOM     82  CE1 PHE     9      15.873  40.529  12.575  1.00 15.03           C  
ATOM     83  CE2 PHE     9      13.931  40.017  13.902  1.00 13.86           C  
ATOM     84  CZ  PHE     9      14.979  39.616  13.065  1.00 15.53           C  
ATOM     85  N   ALA    10      15.107  45.315  11.432  1.00 13.59           N  
ATOM     86  CA  ALA    10      15.614  45.381  10.074  1.00 13.29           C  
ATOM     87  C   ALA    10      16.736  44.351   9.943  1.00 12.11           C  
ATOM     88  O   ALA    10      17.515  44.114  10.867  1.00 12.79           O  
ATOM     89  CB  ALA    10      16.127  46.747   9.770  1.00 13.92           C  
ATOM     90  N   LEU    11      16.820  43.776   8.765  1.00 11.89           N  
ATOM     91  CA  LEU    11      17.884  42.825   8.461  1.00 11.66           C  
ATOM     92  C   LEU    11      18.479  43.206   7.106  1.00 11.25           C  
ATOM     93  O   LEU    11      17.791  43.100   6.088  1.00 11.70           O  
ATOM     94  CB  LEU    11      17.268  41.424   8.382  1.00 11.80           C  
ATOM     95  CG  LEU    11      18.199  40.311   7.867  1.00 11.81           C  
ATOM     96  CD1 LEU    11      19.499  40.184   8.709  1.00 11.54           C  
ATOM     97  CD2 LEU    11      17.431  38.946   7.835  1.00 11.16           C  
ATOM     98  N   THR    12      19.739  43.651   7.093  1.00 11.06           N  
ATOM     99  CA  THR    12      20.437  43.941   5.843  1.00 10.80           C  
ATOM    100  C   THR    12      21.431  42.812   5.554  1.00 10.75           C  
ATOM    101  O   THR    12      22.268  42.492   6.427  1.00 10.78           O  
ATOM    102  CB  THR    12      21.207  45.258   5.979  1.00 12.04           C  
ATOM    103  OG1 THR    12      20.261  46.309   6.268  1.00 13.87           O  
ATOM    104  CG2 THR    12      21.944  45.545   4.716  1.00 11.84           C  
ATOM    105  N   VAL    13      21.329  42.215   4.366  1.00 10.59           N  
ATOM    106  CA  VAL    13      22.159  41.059   3.976  1.00 10.00           C  
ATOM    107  C   VAL    13      23.009  41.448   2.754  1.00 10.55           C  
ATOM    108  O   VAL    13      22.471  41.918   1.733  1.00 10.36           O  
ATOM    109  CB  VAL    13      21.256  39.828   3.638  1.00 10.02           C  
ATOM    110  CG1 VAL    13      22.153  38.561   3.516  1.00  9.93           C  
ATOM    111  CG2 VAL    13      20.243  39.644   4.736  1.00 12.14           C  
ATOM    112  N   VAL    14      24.327  41.288   2.872  1.00 10.61           N  
ATOM    113  CA  VAL    14      25.251  41.780   1.877  1.00 10.14           C  
ATOM    114  C   VAL    14      26.202  40.645   1.457  1.00 10.94           C  
ATOM    115  O   VAL    14      26.790  40.007   2.325  1.00 10.94           O  
ATOM    116  CB  VAL    14      26.075  42.959   2.446  1.00 11.36           C  
ATOM    117  CG1 VAL    14      27.056  43.456   1.382  1.00  9.89           C  
ATOM    118  CG2 VAL    14      25.134  44.137   2.849  1.00 12.81           C  
ATOM    119  N   ARG    15      26.318  40.368   0.158  1.00 10.04           N  
ATOM    120  CA  ARG    15      27.289  39.336  -0.282  1.00 10.79           C  
ATOM    121  C   ARG    15      28.699  39.909  -0.117  1.00 10.29           C  
ATOM    122  O   ARG    15      28.904  41.106  -0.283  1.00 11.57           O  
ATOM    123  CB  ARG    15      27.048  38.936  -1.768  1.00  9.43           C  
ATOM    124  CG  ARG    15      28.024  37.834  -2.263  1.00 11.35           C  
ATOM    125  CD  ARG    15      27.585  37.222  -3.602  1.00 12.46           C  
ATOM    126  NE  ARG    15      28.624  36.330  -4.093  1.00 13.39           N  
ATOM    127  CZ  ARG    15      29.143  36.335  -5.318  1.00 15.37           C  
ATOM    128  NH1 ARG    15      28.674  37.137  -6.260  1.00 14.12           N  
ATOM    129  NH2 ARG    15      30.131  35.500  -5.608  1.00 13.89           N  
ATOM    130  N   HIS    16      29.679  39.062   0.166  1.00 11.14           N  
ATOM    131  CA  HIS    16      31.080  39.515   0.244  1.00 11.40           C  
ATOM    132  C   HIS    16      31.557  40.087  -1.118  1.00 12.40           C  
ATOM    133  O   HIS    16      30.975  39.795  -2.202  1.00 12.27           O  
ATOM    134  CB  HIS    16      31.969  38.326   0.622  1.00 11.89           C  
ATOM    135  CG  HIS    16      31.909  37.244  -0.383  1.00 11.77           C  
ATOM    136  ND1 HIS    16      32.675  37.259  -1.532  1.00 10.88           N  
ATOM    137  CD2 HIS    16      31.113  36.155  -0.466  1.00 14.23           C  
ATOM    138  CE1 HIS    16      32.387  36.191  -2.256  1.00 16.26           C  
ATOM    139  NE2 HIS    16      31.442  35.506  -1.630  1.00 14.39           N  
ATOM    140  N   GLY    17      32.636  40.876  -1.055  1.00 12.57           N  
ATOM    141  CA  GLY    17      33.265  41.387  -2.260  1.00 12.64           C  
ATOM    142  C   GLY    17      33.923  40.326  -3.120  1.00 13.60           C  
ATOM    143  O   GLY    17      34.100  39.176  -2.698  1.00 12.67           O  
ATOM    144  N   GLU    18      34.245  40.696  -4.356  1.00 12.79           N  
ATOM    145  CA  GLU    18      34.855  39.768  -5.308  1.00 14.33           C  
ATOM    146  C   GLU    18      36.181  39.161  -4.816  1.00 14.19           C  
ATOM    147  O   GLU    18      36.985  39.853  -4.170  1.00 13.24           O  
ATOM    148  CB  GLU    18      35.072  40.498  -6.641  1.00 15.58           C  
ATOM    149  CG  GLU    18      35.615  39.646  -7.737  1.00 18.58           C  
ATOM    150  CD  GLU    18      36.423  40.473  -8.747  1.00 26.24           C  
ATOM    151  OE1 GLU    18      37.548  40.925  -8.432  1.00 28.76           O  
ATOM    152  OE2 GLU    18      35.935  40.634  -9.857  1.00 27.17           O  
ATOM    153  N   THR    19      36.361  37.856  -5.065  1.00 14.63           N  
ATOM    154  CA  THR    19      37.661  37.193  -4.893  1.00 15.69           C  
ATOM    155  C   THR    19      38.223  36.845  -6.260  1.00 16.12           C  
ATOM    156  O   THR    19      37.525  36.893  -7.282  1.00 15.11           O  
ATOM    157  CB  THR    19      37.572  35.837  -4.120  1.00 14.87           C  
ATOM    158  OG1 THR    19      36.910  34.873  -4.955  1.00 16.55           O  
ATOM    159  CG2 THR    19      36.837  35.983  -2.742  1.00 12.93           C  
ATOM    160  N   ARG    20      39.495  36.453  -6.260  1.00 16.97           N  
ATOM    161  CA  ARG    20      40.161  35.912  -7.443  1.00 18.93           C  
ATOM    162  C   ARG    20      39.322  34.822  -8.158  1.00 19.29           C  
ATOM    163  O   ARG    20      39.202  34.812  -9.396  1.00 20.04           O  
ATOM    164  CB  ARG    20      41.546  35.408  -6.992  1.00 19.32           C  
ATOM    165  CG  ARG    20      42.275  34.361  -7.777  1.00 22.18           C  
ATOM    166  CD  ARG    20      43.709  34.338  -7.214  1.00 21.66           C  
ATOM    167  NE  ARG    20      43.840  33.443  -6.063  1.00 20.51           N  
ATOM    168  CZ  ARG    20      44.436  32.262  -6.102  1.00 22.87           C  
ATOM    169  NH1 ARG    20      44.481  31.517  -5.016  1.00 24.91           N  
ATOM    170  NH2 ARG    20      44.975  31.823  -7.228  1.00 23.22           N  
ATOM    171  N   PHE    21      38.714  33.939  -7.373  1.00 17.76           N  
ATOM    172  CA  PHE    21      37.948  32.834  -7.941  1.00 17.97           C  
ATOM    173  C   PHE    21      36.604  33.277  -8.506  1.00 17.74           C  
ATOM    174  O   PHE    21      36.151  32.759  -9.544  1.00 16.99           O  
ATOM    175  CB  PHE    21      37.833  31.701  -6.911  1.00 19.01           C  
ATOM    176  CG  PHE    21      39.181  31.131  -6.530  1.00 20.00           C  
ATOM    177  CD1 PHE    21      40.117  30.838  -7.512  1.00 23.92           C  
ATOM    178  CD2 PHE    21      39.525  30.940  -5.202  1.00 24.47           C  
ATOM    179  CE1 PHE    21      41.375  30.310  -7.171  1.00 24.93           C  
ATOM    180  CE2 PHE    21      40.774  30.412  -4.859  1.00 25.63           C  
ATOM    181  CZ  PHE    21      41.691  30.099  -5.842  1.00 24.75           C  
ATOM    182  N   ASN    22      35.962  34.229  -7.840  1.00 17.57           N  
ATOM    183  CA  ASN    22      34.719  34.794  -8.414  1.00 18.52           C  
ATOM    184  C   ASN    22      34.988  35.351  -9.818  1.00 19.89           C  
ATOM    185  O   ASN    22      34.228  35.105 -10.771  1.00 19.51           O  
ATOM    186  CB  ASN    22      34.190  35.907  -7.554  1.00 18.37           C  
ATOM    187  CG  ASN    22      33.602  35.407  -6.245  1.00 19.37           C  
ATOM    188  OD1 ASN    22      33.150  34.237  -6.104  1.00 18.97           O  
ATOM    189  ND2 ASN    22      33.568  36.286  -5.301  1.00 13.55           N  
ATOM    190  N   LYS    23      36.093  36.074  -9.948  1.00 20.75           N  
ATOM    191  CA  LYS    23      36.443  36.692 -11.235  1.00 23.46           C  
ATOM    192  C   LYS    23      36.623  35.624 -12.306  1.00 24.29           C  
ATOM    193  O   LYS    23      36.138  35.776 -13.428  1.00 25.47           O  
ATOM    194  CB  LYS    23      37.690  37.556 -11.072  1.00 23.52           C  
ATOM    195  CG  LYS    23      38.222  38.212 -12.349  1.00 27.47           C  
ATOM    196  CD  LYS    23      37.326  39.322 -12.822  1.00 32.44           C  
ATOM    197  CE  LYS    23      38.108  40.299 -13.700  1.00 35.21           C  
ATOM    198  NZ  LYS    23      37.221  41.431 -14.082  1.00 39.24           N  
ATOM    199  N   GLU    24      37.280  34.531 -11.936  1.00 25.02           N  
ATOM    200  CA  GLU    24      37.646  33.470 -12.881  1.00 26.99           C  
ATOM    201  C   GLU    24      36.574  32.393 -13.025  1.00 26.34           C  
ATOM    202  O   GLU    24      36.802  31.393 -13.728  1.00 27.71           O  
ATOM    203  CB  GLU    24      38.981  32.836 -12.465  1.00 27.65           C  
ATOM    204  CG  GLU    24      40.141  33.811 -12.232  1.00 30.31           C  
ATOM    205  CD  GLU    24      40.401  34.779 -13.408  1.00 36.92           C  
ATOM    206  OE1 GLU    24      40.063  34.451 -14.569  1.00 38.73           O  
ATOM    207  OE2 GLU    24      40.950  35.884 -13.159  1.00 38.71           O  
ATOM    208  N   LYS    25      35.421  32.604 -12.378  1.00 25.57           N  
ATOM    209  CA  LYS    25      34.277  31.667 -12.408  1.00 24.89           C  
ATOM    210  C   LYS    25      34.691  30.274 -11.910  1.00 22.95           C  
ATOM    211  O   LYS    25      34.323  29.237 -12.514  1.00 24.07           O  
ATOM    212  CB  LYS    25      33.655  31.563 -13.820  1.00 26.00           C  
ATOM    213  CG  LYS    25      33.068  32.889 -14.367  1.00 30.31           C  
ATOM    214  CD  LYS    25      31.531  32.954 -14.285  1.00 37.00           C  
ATOM    215  CE  LYS    25      30.851  32.201 -15.442  1.00 39.72           C  
ATOM    216  NZ  LYS    25      29.358  32.126 -15.292  1.00 41.81           N  
ATOM    217  N   ILE    26      35.474  30.269 -10.834  1.00 20.24           N  
ATOM    218  CA  ILE    26      35.921  29.042 -10.172  0.50 19.68           C  
ATOM    220  C   ILE    26      35.057  28.826  -8.941  1.00 18.78           C  
ATOM    221  O   ILE    26      34.810  29.759  -8.172  1.00 18.27           O  
ATOM    222  CB  ILE    26      37.425  29.134  -9.782  0.50 19.24           C  
ATOM    224  CG1 ILE    26      38.297  29.028 -11.046  0.50 20.15           C  
ATOM    226  CG2 ILE    26      37.834  28.074  -8.758  0.50 19.79           C  
ATOM    228  CD1 ILE    26      39.716  29.509 -10.829  0.50 19.10           C  
ATOM    230  N   ILE    27      34.588  27.598  -8.779  1.00 17.64           N  
ATOM    231  CA  ILE    27      33.708  27.274  -7.670  0.50 17.31           C  
ATOM    233  C   ILE    27      34.422  27.476  -6.353  1.00 17.86           C  
ATOM    234  O   ILE    27      35.542  27.019  -6.154  1.00 16.33           O  
ATOM    235  CB  ILE    27      33.170  25.849  -7.774  0.50 16.83           C  
ATOM    237  CG1 ILE    27      32.426  25.673  -9.102  0.50 18.12           C  
ATOM    239  CG2 ILE    27      32.228  25.543  -6.610  0.50 15.69           C  
ATOM    241  CD1 ILE    27      32.230  24.258  -9.481  0.50 17.55           C  
ATOM    243  N   GLN    28      33.712  28.157  -5.457  1.00 19.94           N  
ATOM    244  CA  GLN    28      34.188  28.558  -4.186  1.00 21.00           C  
ATOM    245  C   GLN    28      33.026  28.413  -3.207  1.00 20.63           C  
ATOM    246  O   GLN    28      32.128  29.284  -3.155  1.00 21.79           O  
ATOM    247  CB  GLN    28      34.493  30.038  -4.326  1.00 22.79           C  
ATOM    248  CG  GLN    28      35.186  30.690  -3.187  1.00 25.95           C  
ATOM    249  CD  GLN    28      35.402  32.143  -3.518  1.00 23.19           C  
ATOM    250  OE1 GLN    28      34.439  32.916  -3.650  1.00 26.05           O  
ATOM    251  NE2 GLN    28      36.658  32.528  -3.684  1.00 18.04           N  
ATOM    252  N   GLY    29      33.023  27.314  -2.470  1.00 18.42           N  
ATOM    253  CA  GLY    29      32.073  27.123  -1.387  1.00 18.14           C  
ATOM    254  C   GLY    29      32.830  27.131  -0.072  1.00 18.33           C  
ATOM    255  O   GLY    29      33.116  28.190   0.473  1.00 18.58           O  
ATOM    256  N   GLN    30      33.180  25.950   0.427  1.00 18.10           N  
ATOM    257  CA  GLN    30      33.966  25.825   1.659  1.00 19.44           C  
ATOM    258  C   GLN    30      35.303  25.107   1.278  1.00 21.53           C  
ATOM    259  O   GLN    30      35.699  24.135   1.898  1.00 22.52           O  
ATOM    260  CB  GLN    30      33.146  25.074   2.757  1.00 18.80           C  
ATOM    261  CG  GLN    30      31.821  25.772   3.166  1.00 17.51           C  
ATOM    262  CD  GLN    30      31.107  25.155   4.393  1.00 18.30           C  
ATOM    263  OE1 GLN    30      31.751  24.637   5.332  1.00 17.71           O  
ATOM    264  NE2 GLN    30      29.785  25.260   4.418  1.00 15.39           N  
ATOM    265  N   GLY    31      35.971  25.592   0.233  1.00 23.08           N  
ATOM    266  CA  GLY    31      37.221  24.988  -0.236  1.00 24.28           C  
ATOM    267  C   GLY    31      38.442  25.756   0.219  1.00 24.89           C  
ATOM    268  O   GLY    31      38.798  25.700   1.396  1.00 24.91           O  
ATOM    269  N   VAL    32      39.121  26.439  -0.706  1.00 24.97           N  
ATOM    270  CA  VAL    32      40.138  27.382  -0.288  1.00 24.40           C  
ATOM    271  C   VAL    32      39.368  28.547   0.340  1.00 22.92           C  
ATOM    272  O   VAL    32      38.374  29.027  -0.170  1.00 23.11           O  
ATOM    273  CB  VAL    32      41.112  27.879  -1.434  1.00 25.58           C  
ATOM    274  CG1 VAL    32      41.796  29.243  -1.078  1.00 25.76           C  
ATOM    275  CG2 VAL    32      42.175  26.840  -1.736  1.00 26.45           C  
ATOM    276  N   ASP    33      39.840  28.949   1.490  1.00 21.48           N  
ATOM    277  CA  ASP    33      39.335  30.116   2.151  1.00 19.20           C  
ATOM    278  C   ASP    33      40.047  31.316   1.497  1.00 17.34           C  
ATOM    279  O   ASP    33      41.003  31.846   2.054  1.00 18.03           O  
ATOM    280  CB  ASP    33      39.747  29.960   3.601  1.00 18.89           C  
ATOM    281  CG  ASP    33      39.039  30.875   4.486  1.00 18.74           C  
ATOM    282  OD1 ASP    33      38.258  31.695   3.971  1.00 16.19           O  
ATOM    283  OD2 ASP    33      39.269  30.786   5.698  1.00 18.51           O  
ATOM    284  N   GLU    34      39.564  31.721   0.315  1.00 16.16           N  
ATOM    285  CA  GLU    34      40.199  32.771  -0.530  1.00 13.68           C  
ATOM    286  C   GLU    34      39.829  34.184  -0.062  1.00 13.01           C  
ATOM    287  O   GLU    34      38.658  34.481   0.182  1.00 12.76           O  
ATOM    288  CB  GLU    34      39.758  32.569  -1.988  1.00 13.32           C  
ATOM    289  CG  GLU    34      40.392  33.542  -2.987  1.00 14.27           C  
ATOM    290  CD  GLU    34      41.895  33.337  -3.121  1.00 17.56           C  
ATOM    291  OE1 GLU    34      42.406  32.292  -2.657  1.00 16.95           O  
ATOM    292  OE2 GLU    34      42.561  34.222  -3.687  1.00 14.35           O  
ATOM    293  N   PRO    35      40.816  35.087   0.038  1.00 12.61           N  
ATOM    294  CA  PRO    35      40.519  36.460   0.441  1.00 12.40           C  
ATOM    295  C   PRO    35      39.941  37.281  -0.696  1.00 12.19           C  
ATOM    296  O   PRO    35      39.870  36.798  -1.836  1.00 12.16           O  
ATOM    297  CB  PRO    35      41.903  37.012   0.800  1.00 13.18           C  
ATOM    298  CG  PRO    35      42.830  36.282  -0.091  1.00 11.73           C  
ATOM    299  CD  PRO    35      42.257  34.876  -0.197  1.00 12.29           C  
ATOM    300  N   LEU    36      39.553  38.525  -0.381  1.00 13.27           N  
ATOM    301  CA  LEU    36      39.129  39.442  -1.419  1.00 13.91           C  
ATOM    302  C   LEU    36      40.288  39.748  -2.367  1.00 14.60           C  
ATOM    303  O   LEU    36      41.477  39.720  -1.959  1.00 15.26           O  
ATOM    304  CB  LEU    36      38.660  40.730  -0.791  1.00 13.30           C  
ATOM    305  CG  LEU    36      37.476  40.669   0.167  1.00 11.16           C  
ATOM    306  CD1 LEU    36      37.120  42.084   0.644  1.00 12.32           C  
ATOM    307  CD2 LEU    36      36.294  40.061  -0.606  1.00 14.18           C  
ATOM    308  N   SER    37      39.942  40.002  -3.627  1.00 14.66           N  
ATOM    309  CA  SER    37      40.887  40.588  -4.581  1.00 15.07           C  
ATOM    310  C   SER    37      40.955  42.115  -4.361  1.00 16.18           C  
ATOM    311  O   SER    37      40.191  42.650  -3.561  1.00 15.86           O  
ATOM    312  CB  SER    37      40.387  40.310  -5.990  1.00 15.28           C  
ATOM    313  OG  SER    37      39.163  40.991  -6.245  1.00 15.00           O  
ATOM    314  N   GLU    38      41.843  42.819  -5.053  0.50 16.90           N  
ATOM    316  CA  GLU    38      41.822  44.275  -4.919  0.50 17.68           C  
ATOM    318  C   GLU    38      40.468  44.909  -5.349  0.50 17.34           C  
ATOM    320  O   GLU    38      39.992  45.839  -4.683  0.50 16.87           O  
ATOM    322  CB  GLU    38      43.062  44.905  -5.555  0.50 18.44           C  
ATOM    324  CG  GLU    38      44.363  44.465  -4.861  0.50 20.32           C  
ATOM    326  CD  GLU    38      44.498  45.003  -3.442  0.50 23.44           C  
ATOM    328  OE1 GLU    38      44.550  46.248  -3.280  0.50 23.55           O  
ATOM    330  OE2 GLU    38      44.564  44.191  -2.493  0.50 20.46           O  
ATOM    332  N   THR    39      39.818  44.357  -6.381  1.00 17.89           N  
ATOM    333  CA  THR    39      38.442  44.762  -6.739  1.00 18.70           C  
ATOM    334  C   THR    39      37.477  44.495  -5.573  1.00 17.31           C  
ATOM    335  O   THR    39      36.641  45.350  -5.250  1.00 16.75           O  
ATOM    336  CB  THR    39      37.965  44.078  -8.026  1.00 19.07           C  
ATOM    337  OG1 THR    39      38.780  44.507  -9.123  1.00 23.74           O  
ATOM    338  CG2 THR    39      36.491  44.402  -8.353  1.00 21.10           C  
ATOM    339  N   GLY    40      37.635  43.343  -4.911  1.00 16.64           N  
ATOM    340  CA  GLY    40      36.796  43.013  -3.755  1.00 15.47           C  
ATOM    341  C   GLY    40      36.961  43.990  -2.593  1.00 15.29           C  
ATOM    342  O   GLY    40      35.992  44.422  -1.961  1.00 14.78           O  
ATOM    343  N   PHE    41      38.204  44.362  -2.311  1.00 14.84           N  
ATOM    344  CA  PHE    41      38.482  45.341  -1.283  1.00 16.00           C  
ATOM    345  C   PHE    41      37.857  46.706  -1.643  1.00 15.44           C  
ATOM    346  O   PHE    41      37.278  47.347  -0.781  1.00 16.26           O  
ATOM    347  CB  PHE    41      39.994  45.489  -1.080  1.00 16.48           C  
ATOM    348  CG  PHE    41      40.600  44.395  -0.260  1.00 16.72           C  
ATOM    349  CD1 PHE    41      40.213  44.206   1.066  1.00 16.36           C  
ATOM    350  CD2 PHE    41      41.607  43.599  -0.798  1.00 18.31           C  
ATOM    351  CE1 PHE    41      40.788  43.184   1.839  1.00 17.37           C  
ATOM    352  CE2 PHE    41      42.194  42.576  -0.035  1.00 17.66           C  
ATOM    353  CZ  PHE    41      41.779  42.378   1.287  1.00 17.32           C  
ATOM    354  N   LYS    42      37.973  47.118  -2.900  1.00 15.99           N  
ATOM    355  CA  LYS    42      37.278  48.329  -3.408  1.00 17.34           C  
ATOM    356  C   LYS    42      35.755  48.273  -3.244  1.00 17.57           C  
ATOM    357  O   LYS    42      35.146  49.256  -2.833  1.00 16.74           O  
ATOM    358  CB  LYS    42      37.634  48.638  -4.865  1.00 18.01           C  
ATOM    359  CG  LYS    42      39.093  49.050  -5.043  1.00 21.90           C  
ATOM    360  CD  LYS    42      39.416  49.194  -6.520  1.00 25.92           C  
ATOM    361  CE  LYS    42      40.607  50.124  -6.698  1.00 31.54           C  
ATOM    362  NZ  LYS    42      40.793  50.449  -8.144  1.00 35.78           N  
ATOM    363  N   GLN    43      35.141  47.130  -3.560  1.00 17.23           N  
ATOM    364  CA  GLN    43      33.689  46.988  -3.408  1.00 16.65           C  
ATOM    365  C   GLN    43      33.281  47.098  -1.934  1.00 16.50           C  
ATOM    366  O   GLN    43      32.313  47.778  -1.603  1.00 15.99           O  
ATOM    367  CB  GLN    43      33.204  45.648  -3.998  1.00 17.02           C  
ATOM    368  CG  GLN    43      33.434  45.511  -5.503  1.00 14.54           C  
ATOM    369  CD  GLN    43      33.179  44.106  -6.005  1.00 17.25           C  
ATOM    370  OE1 GLN    43      33.287  43.143  -5.240  1.00 15.36           O  
ATOM    371  NE2 GLN    43      32.798  43.981  -7.286  1.00 17.54           N  
ATOM    372  N   ALA    44      34.049  46.460  -1.053  1.00 17.00           N  
ATOM    373  CA  ALA    44      33.780  46.481   0.362  1.00 18.25           C  
ATOM    374  C   ALA    44      33.894  47.920   0.893  1.00 18.29           C  
ATOM    375  O   ALA    44      33.071  48.365   1.710  1.00 19.67           O  
ATOM    376  CB  ALA    44      34.726  45.538   1.082  1.00 18.12           C  
ATOM    377  N   ALA    45      34.879  48.659   0.370  1.00 18.75           N  
ATOM    378  CA  ALA    45      35.095  50.055   0.802  1.00 18.36           C  
ATOM    379  C   ALA    45      33.906  50.917   0.356  1.00 17.22           C  
ATOM    380  O   ALA    45      33.358  51.719   1.139  1.00 18.63           O  
ATOM    381  CB  ALA    45      36.430  50.601   0.207  1.00 18.25           C  
ATOM    382  N   ALA    46      33.485  50.718  -0.884  1.00 17.27           N  
ATOM    383  CA  ALA    46      32.370  51.440  -1.471  1.00 17.55           C  
ATOM    384  C   ALA    46      31.100  51.155  -0.685  1.00 18.90           C  
ATOM    385  O   ALA    46      30.296  52.059  -0.395  1.00 17.88           O  
ATOM    386  CB  ALA    46      32.196  51.040  -2.903  1.00 18.02           C  
ATOM    387  N   ALA    47      30.886  49.882  -0.369  1.00 17.73           N  
ATOM    388  CA  ALA    47      29.743  49.513   0.469  1.00 18.26           C  
ATOM    389  C   ALA    47      29.810  50.180   1.851  1.00 18.11           C  
ATOM    390  O   ALA    47      28.780  50.598   2.404  1.00 19.38           O  
ATOM    391  CB  ALA    47      29.686  47.977   0.621  1.00 18.48           C  
ATOM    392  N   GLY    48      31.011  50.248   2.408  1.00 18.17           N  
ATOM    393  CA  GLY    48      31.250  50.880   3.714  1.00 19.13           C  
ATOM    394  C   GLY    48      30.921  52.359   3.648  1.00 19.49           C  
ATOM    395  O   GLY    48      30.279  52.887   4.548  1.00 20.37           O  
ATOM    396  N   ILE    49      31.301  53.017   2.557  1.00 21.18           N  
ATOM    397  CA  ILE    49      30.955  54.451   2.406  1.00 21.55           C  
ATOM    398  C   ILE    49      29.445  54.633   2.232  1.00 21.40           C  
ATOM    399  O   ILE    49      28.849  55.497   2.891  1.00 20.53           O  
ATOM    400  CB  ILE    49      31.725  55.134   1.271  1.00 21.92           C  
ATOM    401  CG1 ILE    49      33.240  55.058   1.563  1.00 22.53           C  
ATOM    402  CG2 ILE    49      31.190  56.604   1.066  1.00 23.77           C  
ATOM    403  CD1 ILE    49      34.126  55.098   0.360  1.00 25.96           C  
ATOM    404  N   PHE    50      28.825  53.794   1.396  1.00 20.95           N  
ATOM    405  CA  PHE    50      27.381  53.811   1.189  1.00 20.87           C  
ATOM    406  C   PHE    50      26.614  53.701   2.519  1.00 20.75           C  
ATOM    407  O   PHE    50      25.611  54.421   2.729  1.00 20.09           O  
ATOM    408  CB  PHE    50      26.959  52.675   0.236  1.00 21.75           C  
ATOM    409  CG  PHE    50      25.505  52.713  -0.165  1.00 21.42           C  
ATOM    410  CD1 PHE    50      25.034  53.666  -1.070  1.00 23.70           C  
ATOM    411  CD2 PHE    50      24.615  51.769   0.344  1.00 22.52           C  
ATOM    412  CE1 PHE    50      23.685  53.701  -1.454  1.00 25.31           C  
ATOM    413  CE2 PHE    50      23.278  51.778  -0.020  1.00 20.38           C  
ATOM    414  CZ  PHE    50      22.794  52.747  -0.929  1.00 23.41           C  
ATOM    415  N   LEU    51      27.106  52.823   3.398  1.00 20.65           N  
ATOM    416  CA  LEU    51      26.477  52.528   4.707  1.00 20.31           C  
ATOM    417  C   LEU    51      26.994  53.347   5.909  1.00 20.94           C  
ATOM    418  O   LEU    51      26.689  53.035   7.074  1.00 20.47           O  
ATOM    419  CB  LEU    51      26.620  51.024   5.012  1.00 20.45           C  
ATOM    420  CG  LEU    51      26.018  50.029   4.002  1.00 18.73           C  
ATOM    421  CD1 LEU    51      26.516  48.571   4.293  1.00 17.74           C  
ATOM    422  CD2 LEU    51      24.503  50.071   4.006  1.00 18.95           C  
ATOM    423  N   ASN    52      27.776  54.391   5.646  1.00 22.08           N  
ATOM    424  CA  ASN    52      28.569  54.990   6.714  1.00 24.34           C  
ATOM    425  C   ASN    52      27.711  55.621   7.834  1.00 24.30           C  
ATOM    426  O   ASN    52      28.155  55.738   8.984  1.00 24.66           O  
ATOM    427  CB  ASN    52      29.517  56.037   6.111  1.00 25.39           C  
ATOM    428  CG  ASN    52      28.787  57.295   5.740  1.00 28.11           C  
ATOM    429  OD1 ASN    52      28.587  58.166   6.588  1.00 33.96           O  
ATOM    430  ND2 ASN    52      28.315  57.376   4.501  1.00 29.08           N  
ATOM    431  N   ASN    53      26.498  56.042   7.487  1.00 25.05           N  
ATOM    432  CA  ASN    53      25.632  56.715   8.469  1.00 25.92           C  
ATOM    433  C   ASN    53      24.488  55.833   8.952  1.00 25.06           C  
ATOM    434  O   ASN    53      23.578  56.317   9.638  1.00 25.23           O  
ATOM    435  CB  ASN    53      25.075  58.026   7.904  1.00 27.15           C  
ATOM    436  CG  ASN    53      24.652  58.988   9.000  1.00 30.53           C  
ATOM    437  OD1 ASN    53      25.455  59.349   9.865  1.00 36.72           O  
ATOM    438  ND2 ASN    53      23.382  59.389   8.986  1.00 34.91           N  
ATOM    439  N   VAL    54      24.521  54.547   8.585  1.00 23.11           N  
ATOM    440  CA  VAL    54      23.505  53.626   9.060  1.00 21.47           C  
ATOM    441  C   VAL    54      23.824  53.191  10.471  1.00 21.39           C  
ATOM    442  O   VAL    54      24.938  52.731  10.780  1.00 22.40           O  
ATOM    443  CB  VAL    54      23.363  52.343   8.167  1.00 20.54           C  
ATOM    444  CG1 VAL    54      22.303  51.405   8.775  1.00 20.21           C  
ATOM    445  CG2 VAL    54      22.991  52.714   6.759  1.00 20.99           C  
ATOM    446  N   LYS    55      22.832  53.303  11.339  1.00 21.50           N  
ATOM    447  CA  LYS    55      23.011  52.869  12.707  1.00 22.40           C  
ATOM    448  C   LYS    55      22.615  51.395  12.855  1.00 21.79           C  
ATOM    449  O   LYS    55      21.475  51.073  13.260  1.00 22.74           O  
ATOM    450  CB  LYS    55      22.190  53.741  13.659  1.00 23.17           C  
ATOM    451  CG  LYS    55      22.523  55.236  13.533  1.00 26.63           C  
ATOM    452  CD  LYS    55      22.200  55.945  14.829  1.00 32.13           C  
ATOM    453  CE  LYS    55      22.697  57.386  14.808  1.00 34.40           C  
ATOM    454  NZ  LYS    55      22.953  57.903  16.192  1.00 36.92           N  
ATOM    455  N   PHE    56      23.546  50.503  12.539  1.00 20.73           N  
ATOM    456  CA  PHE    56      23.337  49.078  12.823  1.00 19.15           C  
ATOM    457  C   PHE    56      23.510  48.812  14.304  1.00 19.61           C  
ATOM    458  O   PHE    56      24.285  49.504  15.000  1.00 21.15           O  
ATOM    459  CB  PHE    56      24.321  48.167  12.053  1.00 18.58           C  
ATOM    460  CG  PHE    56      24.172  48.230  10.567  1.00 17.80           C  
ATOM    461  CD1 PHE    56      23.018  47.719   9.935  1.00 14.64           C  
ATOM    462  CD2 PHE    56      25.183  48.753   9.779  1.00 16.61           C  
ATOM    463  CE1 PHE    56      22.881  47.789   8.533  1.00 14.77           C  
ATOM    464  CE2 PHE    56      25.061  48.793   8.381  1.00 16.45           C  
ATOM    465  CZ  PHE    56      23.904  48.324   7.749  1.00 14.90           C  
ATOM    466  N   THR    57      22.861  47.749  14.765  1.00 17.09           N  
ATOM    467  CA  THR    57      22.898  47.326  16.146  1.00 16.54           C  
ATOM    468  C   THR    57      23.611  45.992  16.347  1.00 16.67           C  
ATOM    469  O   THR    57      24.075  45.688  17.445  1.00 17.10           O  
ATOM    470  CB  THR    57      21.474  47.200  16.744  1.00 17.55           C  
ATOM    471  OG1 THR    57      20.692  46.278  15.957  1.00 14.51           O  
ATOM    472  CG2 THR    57      20.772  48.546  16.751  1.00 15.49           C  
ATOM    473  N   HIS    58      23.659  45.185  15.272  1.00 15.40           N  
ATOM    474  CA  HIS    58      24.258  43.857  15.350  1.00 14.88           C  
ATOM    475  C   HIS    58      24.974  43.589  14.027  1.00 14.04           C  
ATOM    476  O   HIS    58      24.557  44.082  12.977  1.00 13.96           O  
ATOM    477  CB  HIS    58      23.178  42.780  15.466  1.00 13.38           C  
ATOM    478  CG  HIS    58      22.385  42.839  16.735  1.00 14.77           C  
ATOM    479  ND1 HIS    58      21.409  43.785  16.961  1.00 15.83           N  
ATOM    480  CD2 HIS    58      22.419  42.059  17.838  1.00 15.46           C  
ATOM    481  CE1 HIS    58      20.892  43.595  18.164  1.00 17.07           C  
ATOM    482  NE2 HIS    58      21.460  42.535  18.700  1.00 15.53           N  
ATOM    483  N   ALA    59      26.044  42.806  14.100  1.00 13.04           N  
ATOM    484  CA  ALA    59      26.787  42.411  12.878  1.00 13.95           C  
ATOM    485  C   ALA    59      27.139  40.942  12.968  1.00 14.25           C  
ATOM    486  O   ALA    59      27.758  40.502  13.951  1.00 14.77           O  
ATOM    487  CB  ALA    59      28.058  43.213  12.703  1.00 14.18           C  
ATOM    488  N   PHE    60      26.778  40.185  11.930  1.00 12.96           N  
ATOM    489  CA  PHE    60      27.139  38.760  11.816  1.00 12.74           C  
ATOM    490  C   PHE    60      27.780  38.498  10.478  1.00 12.41           C  
ATOM    491  O   PHE    60      27.340  39.056   9.465  1.00 13.16           O  
ATOM    492  CB  PHE    60      25.911  37.831  11.919  1.00 13.31           C  
ATOM    493  CG  PHE    60      25.207  37.891  13.256  1.00 13.17           C  
ATOM    494  CD1 PHE    60      25.482  36.946  14.244  1.00 15.99           C  
ATOM    495  CD2 PHE    60      24.249  38.868  13.490  1.00 16.08           C  
ATOM    496  CE1 PHE    60      24.827  36.980  15.485  1.00 17.65           C  
ATOM    497  CE2 PHE    60      23.575  38.909  14.728  1.00 17.11           C  
ATOM    498  CZ  PHE    60      23.877  37.976  15.714  1.00 15.95           C  
ATOM    499  N   SER    61      28.775  37.602  10.451  1.00 11.13           N  
ATOM    500  CA  SER    61      29.467  37.297   9.202  1.00 12.21           C  
ATOM    501  C   SER    61      29.727  35.794   9.216  1.00 11.56           C  
ATOM    502  O   SER    61      29.983  35.205  10.263  1.00 12.53           O  
ATOM    503  CB  SER    61      30.800  38.071   9.126  1.00 11.54           C  
ATOM    504  OG  SER    61      31.557  37.684   7.995  1.00 14.79           O  
ATOM    505  N   SER    62      29.687  35.174   8.047  1.00 10.94           N  
ATOM    506  CA  SER    62      30.357  33.901   7.851  1.00 11.59           C  
ATOM    507  C   SER    62      31.798  33.973   8.360  1.00 11.84           C  
ATOM    508  O   SER    62      32.420  35.019   8.272  1.00 11.46           O  
ATOM    509  CB  SER    62      30.392  33.669   6.338  1.00 12.08           C  
ATOM    510  OG  SER    62      31.297  32.701   6.015  1.00 16.57           O  
ATOM    511  N   ASP    63      32.276  32.831   8.853  0.50 12.21           N  
ATOM    513  CA  ASP    63      33.641  32.659   9.378  0.50 13.48           C  
ATOM    515  C   ASP    63      34.594  32.183   8.266  0.50 13.52           C  
ATOM    517  O   ASP    63      35.392  31.242   8.442  0.50 13.40           O  
ATOM    519  CB  ASP    63      33.669  31.742  10.624  0.50 13.93           C  
ATOM    521  CG  ASP    63      33.182  30.313  10.355  0.50 14.36           C  
ATOM    523  OD1 ASP    63      32.267  30.105   9.530  0.50 10.93           O  
ATOM    525  OD2 ASP    63      33.724  29.377  10.988  0.50 15.00           O  
ATOM    527  N   LEU    64      34.455  32.830   7.104  1.00 14.85           N  
ATOM    528  CA  LEU    64      35.372  32.683   5.974  1.00 14.13           C  
ATOM    529  C   LEU    64      36.040  34.045   5.711  1.00 13.74           C  
ATOM    530  O   LEU    64      35.487  35.081   6.092  1.00 12.53           O  
ATOM    531  CB  LEU    64      34.610  32.144   4.735  1.00 14.06           C  
ATOM    532  CG  LEU    64      34.112  30.684   4.857  1.00 15.57           C  
ATOM    533  CD1 LEU    64      33.222  30.172   3.726  1.00 16.81           C  
ATOM    534  CD2 LEU    64      35.373  29.730   5.011  1.00 16.50           C  
ATOM    535  N   MET    65      37.244  34.054   5.120  1.00 13.80           N  
ATOM    536  CA  MET    65      37.997  35.312   4.978  1.00 14.27           C  
ATOM    537  C   MET    65      37.259  36.328   4.141  1.00 12.80           C  
ATOM    538  O   MET    65      37.249  37.513   4.483  1.00 12.68           O  
ATOM    539  CB  MET    65      39.344  35.088   4.268  1.00 14.39           C  
ATOM    540  CG  MET    65      40.368  34.551   5.151  1.00 19.40           C  
ATOM    541  SD  MET    65      42.061  34.816   4.234  1.00 17.57          SE  
ATOM    542  CE  MET    65      42.703  36.459   4.953  1.00 18.75           C  
ATOM    543  N   ARG    66      36.664  35.878   3.035  1.00 11.81           N  
ATOM    544  CA  ARG    66      36.066  36.820   2.071  1.00 11.30           C  
ATOM    545  C   ARG    66      34.928  37.632   2.693  1.00 12.24           C  
ATOM    546  O   ARG    66      34.802  38.856   2.479  1.00 11.93           O  
ATOM    547  CB  ARG    66      35.654  36.107   0.777  1.00 10.46           C  
ATOM    548  CG  ARG    66      34.682  34.894   0.959  1.00 10.29           C  
ATOM    549  CD  ARG    66      34.627  34.203  -0.373  1.00 12.79           C  
ATOM    550  NE  ARG    66      33.700  33.054  -0.470  1.00 11.27           N  
ATOM    551  CZ  ARG    66      33.988  31.816  -0.053  1.00 14.16           C  
ATOM    552  NH1 ARG    66      33.126  30.849  -0.290  1.00 12.57           N  
ATOM    553  NH2 ARG    66      35.111  31.536   0.612  1.00 11.25           N  
ATOM    554  N   THR    67      34.149  36.966   3.543  1.00 11.56           N  
ATOM    555  CA  THR    67      33.050  37.640   4.242  1.00 12.08           C  
ATOM    556  C   THR    67      33.622  38.488   5.417  1.00 11.63           C  
ATOM    557  O   THR    67      33.223  39.648   5.611  1.00 12.77           O  
ATOM    558  CB  THR    67      32.050  36.601   4.741  1.00 10.04           C  
ATOM    559  OG1 THR    67      32.796  35.490   5.240  1.00 12.29           O  
ATOM    560  CG2 THR    67      31.131  36.086   3.571  1.00 11.13           C  
ATOM    561  N   LYS    68      34.592  37.937   6.151  1.00 13.01           N  
ATOM    562  CA  LYS    68      35.199  38.673   7.299  1.00 13.10           C  
ATOM    563  C   LYS    68      35.821  40.001   6.795  1.00 11.78           C  
ATOM    564  O   LYS    68      35.613  41.042   7.377  1.00 11.93           O  
ATOM    565  CB  LYS    68      36.239  37.809   8.024  1.00 13.79           C  
ATOM    566  CG  LYS    68      37.010  38.545   9.119  1.00 16.70           C  
ATOM    567  CD  LYS    68      37.820  37.554   9.999  1.00 17.70           C  
ATOM    568  CE  LYS    68      38.271  38.243  11.310  1.00 22.84           C  
ATOM    569  NZ  LYS    68      38.987  37.265  12.187  1.00 25.71           N  
ATOM    570  N   GLN    69      36.578  39.925   5.702  1.00 11.45           N  
ATOM    571  CA  GLN    69      37.230  41.109   5.149  1.00 12.01           C  
ATOM    572  C   GLN    69      36.212  42.128   4.655  1.00 12.80           C  
ATOM    573  O   GLN    69      36.421  43.360   4.776  1.00 12.36           O  
ATOM    574  CB  GLN    69      38.143  40.690   4.024  1.00 11.90           C  
ATOM    575  CG  GLN    69      39.389  39.947   4.540  1.00 11.34           C  
ATOM    576  CD  GLN    69      40.288  39.535   3.414  1.00 14.07           C  
ATOM    577  OE1 GLN    69      39.807  39.100   2.363  1.00 12.32           O  
ATOM    578  NE2 GLN    69      41.613  39.608   3.639  1.00 15.02           N  
ATOM    579  N   THR    70      35.107  41.621   4.080  1.00 12.32           N  
ATOM    580  CA  THR    70      34.067  42.536   3.591  1.00 12.94           C  
ATOM    581  C   THR    70      33.409  43.288   4.778  1.00 12.24           C  
ATOM    582  O   THR    70      33.180  44.519   4.705  1.00 12.26           O  
ATOM    583  CB  THR    70      33.005  41.781   2.757  1.00 12.52           C  
ATOM    584  OG1 THR    70      33.657  41.176   1.623  1.00 12.51           O  
ATOM    585  CG2 THR    70      31.874  42.738   2.253  1.00 11.26           C  
ATOM    586  N   MET    71      33.076  42.532   5.819  1.00 12.95           N  
ATOM    587  CA  MET    71      32.513  43.084   7.054  1.00 14.04           C  
ATOM    588  C   MET    71      33.506  44.129   7.601  1.00 15.16           C  
ATOM    589  O   MET    71      33.100  45.209   8.015  1.00 14.69           O  
ATOM    590  CB  MET    71      32.311  42.000   8.084  1.00 14.72           C  
ATOM    591  CG  MET    71      31.741  42.503   9.416  1.00 16.03           C  
ATOM    592  SD  MET    71      30.009  43.366   9.266  1.00 12.53          SE  
ATOM    593  CE  MET    71      28.976  41.707   9.223  1.00 13.52           C  
ATOM    594  N   HIS    72      34.798  43.805   7.570  1.00 15.73           N  
ATOM    595  CA  HIS    72      35.798  44.765   8.079  1.00 17.92           C  
ATOM    596  C   HIS    72      35.799  46.068   7.279  1.00 18.23           C  
ATOM    597  O   HIS    72      35.806  47.170   7.877  1.00 18.65           O  
ATOM    598  CB  HIS    72      37.197  44.172   8.104  1.00 18.26           C  
ATOM    599  CG  HIS    72      38.231  45.134   8.616  1.00 22.21           C  
ATOM    600  ND1 HIS    72      38.329  45.480   9.946  1.00 26.17           N  
ATOM    601  CD2 HIS    72      39.186  45.851   7.968  1.00 26.64           C  
ATOM    602  CE1 HIS    72      39.323  46.337  10.106  1.00 25.60           C  
ATOM    603  NE2 HIS    72      39.856  46.583   8.920  1.00 28.23           N  
ATOM    604  N   GLY    73      35.786  45.922   5.950  1.00 17.64           N  
ATOM    605  CA  GLY    73      35.749  47.021   4.982  1.00 18.22           C  
ATOM    606  C   GLY    73      34.553  47.914   5.241  1.00 18.59           C  
ATOM    607  O   GLY    73      34.632  49.135   5.137  1.00 17.35           O  
ATOM    608  N   ILE    74      33.422  47.293   5.569  1.00 17.82           N  
ATOM    609  CA  ILE    74      32.208  48.049   5.833  1.00 18.14           C  
ATOM    610  C   ILE    74      32.322  48.766   7.168  1.00 19.12           C  
ATOM    611  O   ILE    74      32.124  49.976   7.216  1.00 20.75           O  
ATOM    612  CB  ILE    74      30.929  47.127   5.787  1.00 17.24           C  
ATOM    613  CG1 ILE    74      30.633  46.719   4.347  1.00 18.41           C  
ATOM    614  CG2 ILE    74      29.716  47.847   6.393  1.00 17.25           C  
ATOM    615  CD1 ILE    74      29.677  45.514   4.249  1.00 17.62           C  
ATOM    616  N   LEU    75      32.660  48.047   8.242  1.00 20.26           N  
ATOM    617  CA  LEU    75      32.654  48.660   9.584  1.00 20.39           C  
ATOM    618  C   LEU    75      33.748  49.711   9.784  1.00 21.93           C  
ATOM    619  O   LEU    75      33.506  50.723  10.442  1.00 21.81           O  
ATOM    620  CB  LEU    75      32.682  47.618  10.687  1.00 20.74           C  
ATOM    621  CG  LEU    75      31.457  46.705  10.768  1.00 18.86           C  
ATOM    622  CD1 LEU    75      31.706  45.688  11.869  1.00 20.32           C  
ATOM    623  CD2 LEU    75      30.175  47.516  10.991  1.00 20.37           C  
ATOM    624  N   GLU    76      34.907  49.519   9.165  1.00 22.34           N  
ATOM    625  CA  GLU    76      35.997  50.479   9.357  1.00 25.10           C  
ATOM    626  C   GLU    76      35.621  51.889   8.865  1.00 25.23           C  
ATOM    627  O   GLU    76      36.219  52.863   9.314  1.00 26.75           O  
ATOM    628  CB  GLU    76      37.318  49.973   8.753  1.00 24.36           C  
ATOM    629  CG  GLU    76      37.476  50.167   7.255  1.00 25.72           C  
ATOM    630  CD  GLU    76      38.694  49.424   6.693  1.00 27.22           C  
ATOM    631  OE1 GLU    76      39.583  49.024   7.479  1.00 30.93           O  
ATOM    632  OE2 GLU    76      38.774  49.240   5.461  1.00 32.26           O  
ATOM    633  N   ARG    77      34.624  51.982   7.977  1.00 25.58           N  
ATOM    634  CA  ARG    77      34.132  53.257   7.427  1.00 26.51           C  
ATOM    635  C   ARG    77      32.831  53.782   8.025  1.00 26.65           C  
ATOM    636  O   ARG    77      32.262  54.749   7.501  1.00 26.66           O  
ATOM    637  CB  ARG    77      33.949  53.141   5.920  1.00 26.38           C  
ATOM    638  CG  ARG    77      35.290  53.011   5.227  1.00 27.67           C  
ATOM    639  CD  ARG    77      35.178  52.485   3.846  1.00 30.97           C  
ATOM    640  NE  ARG    77      36.510  52.433   3.255  1.00 30.98           N  
ATOM    641  CZ  ARG    77      37.312  51.372   3.292  1.00 35.20           C  
ATOM    642  NH1 ARG    77      38.520  51.454   2.715  1.00 36.34           N  
ATOM    643  NH2 ARG    77      36.910  50.228   3.875  1.00 28.89           N  
ATOM    644  N   SER    78      32.357  53.130   9.079  1.00 26.15           N  
ATOM    645  CA  SER    78      31.086  53.486   9.669  1.00 27.03           C  
ATOM    646  C   SER    78      31.300  54.636  10.634  1.00 27.68           C  
ATOM    647  O   SER    78      32.276  54.646  11.391  1.00 27.16           O  
ATOM    648  CB  SER    78      30.468  52.308  10.416  1.00 26.71           C  
ATOM    649  OG  SER    78      29.259  52.707  11.068  1.00 26.27           O  
ATOM    650  N   LYS    79      30.379  55.591  10.600  1.00 29.19           N  
ATOM    651  CA  LYS    79      30.364  56.674  11.605  1.00 30.36           C  
ATOM    652  C   LYS    79      30.015  56.189  13.025  1.00 30.63           C  
ATOM    653  O   LYS    79      30.639  56.613  14.014  1.00 30.77           O  
ATOM    654  CB  LYS    79      29.411  57.772  11.163  1.00 30.35           C  
ATOM    655  CG  LYS    79      29.804  58.387   9.823  1.00 34.19           C  
ATOM    656  CD  LYS    79      28.840  59.478   9.389  1.00 38.11           C  
ATOM    657  CE  LYS    79      29.545  60.497   8.510  1.00 41.68           C  
ATOM    658  NZ  LYS    79      30.320  59.884   7.374  1.00 44.79           N  
ATOM    659  N   PHE    80      29.039  55.283  13.132  1.00 30.30           N  
ATOM    660  CA  PHE    80      28.579  54.815  14.441  1.00 29.95           C  
ATOM    661  C   PHE    80      29.020  53.438  14.871  1.00 29.66           C  
ATOM    662  O   PHE    80      29.052  53.163  16.069  1.00 29.18           O  
ATOM    663  CB  PHE    80      27.053  54.898  14.522  1.00 31.44           C  
ATOM    664  CG  PHE    80      26.530  56.235  14.154  1.00 34.11           C  
ATOM    665  CD1 PHE    80      26.564  57.278  15.077  1.00 37.99           C  
ATOM    666  CD2 PHE    80      26.056  56.478  12.874  1.00 35.72           C  
ATOM    667  CE1 PHE    80      26.106  58.537  14.729  1.00 38.23           C  
ATOM    668  CE2 PHE    80      25.597  57.722  12.519  1.00 39.19           C  
ATOM    669  CZ  PHE    80      25.623  58.758  13.446  1.00 38.01           C  
ATOM    670  N   CYS    81      29.366  52.575  13.910  1.00 28.01           N  
ATOM    671  CA  CYS    81      29.606  51.158  14.197  1.00 27.84           C  
ATOM    672  C   CYS    81      31.044  50.686  13.981  1.00 27.70           C  
ATOM    673  O   CYS    81      31.309  49.485  14.007  1.00 26.84           O  
ATOM    674  CB  CYS    81      28.645  50.276  13.398  1.00 27.28           C  
ATOM    675  SG  CYS    81      26.920  50.779  13.612  1.00 28.89           S  
ATOM    676  N   LYS    82      31.985  51.617  13.832  1.00 27.45           N  
ATOM    677  CA  LYS    82      33.403  51.222  13.766  1.00 28.50           C  
ATOM    678  C   LYS    82      33.834  50.144  14.796  1.00 27.82           C  
ATOM    679  O   LYS    82      34.547  49.182  14.454  1.00 28.25           O  
ATOM    680  CB  LYS    82      34.281  52.465  13.927  1.00 28.86           C  
ATOM    681  CG  LYS    82      35.101  52.816  12.713  1.00 32.47           C  
ATOM    682  CD  LYS    82      36.212  53.785  13.150  1.00 36.51           C  
ATOM    683  CE  LYS    82      37.407  53.769  12.213  1.00 39.21           C  
ATOM    684  NZ  LYS    82      38.422  54.834  12.584  1.00 41.30           N  
ATOM    685  N   ASP    83      33.375  50.304  16.039  1.00 27.50           N  
ATOM    686  CA  ASP    83      33.775  49.512  17.197  1.00 28.02           C  
ATOM    687  C   ASP    83      32.878  48.306  17.488  1.00 27.52           C  
ATOM    688  O   ASP    83      33.135  47.570  18.441  1.00 26.64           O  
ATOM    689  CB  ASP    83      33.731  50.395  18.458  1.00 29.41           C  
ATOM    690  CG  ASP    83      35.074  50.979  18.833  1.00 33.35           C  
ATOM    691  OD1 ASP    83      36.018  50.982  18.002  1.00 37.87           O  
ATOM    692  OD2 ASP    83      35.171  51.465  19.991  1.00 39.80           O  
ATOM    693  N   MET    84      31.827  48.123  16.684  1.00 27.33           N  
ATOM    694  CA  MET    84      30.888  47.015  16.853  1.00 27.36           C  
ATOM    695  C   MET    84      31.554  45.635  16.835  1.00 26.64           C  
ATOM    696  O   MET    84      32.397  45.363  15.972  1.00 26.44           O  
ATOM    697  CB  MET    84      29.828  47.074  15.754  1.00 27.33           C  
ATOM    698  CG  MET    84      28.843  45.919  15.820  1.00 29.83           C  
ATOM    699  SD  MET    84      27.184  46.452  15.025  1.00 28.68          SE  
ATOM    700  CE  MET    84      26.622  47.647  16.472  1.00 31.10           C  
ATOM    701  N   THR    85      31.151  44.771  17.770  1.00 25.42           N  
ATOM    702  CA  THR    85      31.643  43.400  17.829  1.00 25.35           C  
ATOM    703  C   THR    85      30.957  42.626  16.710  1.00 23.90           C  
ATOM    704  O   THR    85      29.733  42.626  16.620  1.00 25.42           O  
ATOM    705  CB  THR    85      31.307  42.725  19.175  1.00 26.00           C  
ATOM    706  OG1 THR    85      31.981  43.414  20.236  1.00 30.50           O  
ATOM    707  CG2 THR    85      31.750  41.256  19.191  1.00 26.88           C  
ATOM    708  N   VAL    86      31.747  41.998  15.858  1.00 21.60           N  
ATOM    709  CA  VAL    86      31.200  41.111  14.828  1.00 20.01           C  
ATOM    710  C   VAL    86      31.084  39.709  15.396  1.00 19.18           C  
ATOM    711  O   VAL    86      32.048  39.192  15.994  1.00 18.56           O  
ATOM    712  CB  VAL    86      32.133  41.078  13.584  1.00 19.70           C  
ATOM    713  CG1 VAL    86      31.600  40.066  12.497  1.00 19.54           C  
ATOM    714  CG2 VAL    86      32.330  42.463  13.026  1.00 19.51           C  
ATOM    715  N   LYS    87      29.931  39.060  15.205  1.00 18.68           N  
ATOM    716  CA  LYS    87      29.822  37.655  15.569  1.00 18.36           C  
ATOM    717  C   LYS    87      30.030  36.774  14.329  1.00 18.76           C  
ATOM    718  O   LYS    87      29.404  37.017  13.300  1.00 17.89           O  
ATOM    719  CB  LYS    87      28.465  37.363  16.219  1.00 20.32           C  
ATOM    720  CG  LYS    87      28.207  38.121  17.539  1.00 23.26           C  
ATOM    721  CD  LYS    87      28.881  37.441  18.727  1.00 29.51           C  
ATOM    722  CE  LYS    87      28.862  38.306  20.018  1.00 29.46           C  
ATOM    723  NZ  LYS    87      27.499  38.859  20.350  1.00 34.69           N  
ATOM    724  N   TYR    88      30.908  35.778  14.414  1.00 17.24           N  
ATOM    725  CA  TYR    88      31.205  34.925  13.245  1.00 17.08           C  
ATOM    726  C   TYR    88      30.472  33.634  13.446  1.00 17.77           C  
ATOM    727  O   TYR    88      30.595  33.005  14.519  1.00 19.09           O  
ATOM    728  CB  TYR    88      32.723  34.681  13.083  1.00 16.63           C  
ATOM    729  CG  TYR    88      33.416  35.982  12.807  1.00 16.87           C  
ATOM    730  CD1 TYR    88      33.417  36.518  11.521  1.00 15.13           C  
ATOM    731  CD2 TYR    88      33.947  36.751  13.855  1.00 19.18           C  
ATOM    732  CE1 TYR    88      33.996  37.748  11.259  1.00 16.39           C  
ATOM    733  CE2 TYR    88      34.524  37.980  13.606  1.00 16.91           C  
ATOM    734  CZ  TYR    88      34.548  38.461  12.314  1.00 18.38           C  
ATOM    735  OH  TYR    88      35.119  39.660  12.080  1.00 18.80           O  
ATOM    736  N   ASP    89      29.706  33.225  12.429  1.00 15.32           N  
ATOM    737  CA  ASP    89      28.752  32.138  12.598  1.00 14.95           C  
ATOM    738  C   ASP    89      28.880  31.221  11.400  1.00 14.21           C  
ATOM    739  O   ASP    89      28.637  31.632  10.269  1.00 13.18           O  
ATOM    740  CB  ASP    89      27.320  32.705  12.754  1.00 13.62           C  
ATOM    741  CG  ASP    89      26.326  31.703  13.309  1.00 17.57           C  
ATOM    742  OD1 ASP    89      26.216  30.557  12.790  1.00 16.56           O  
ATOM    743  OD2 ASP    89      25.635  32.056  14.296  1.00 18.76           O  
ATOM    744  N   SER    90      29.255  29.979  11.660  1.00 13.24           N  
ATOM    745  CA  SER    90      29.434  28.988  10.594  1.00 13.21           C  
ATOM    746  C   SER    90      28.127  28.694   9.846  1.00 12.15           C  
ATOM    747  O   SER    90      28.166  28.199   8.726  1.00 12.17           O  
ATOM    748  CB  SER    90      30.017  27.664  11.149  1.00 14.65           C  
ATOM    749  OG  SER    90      29.081  27.013  11.999  1.00 16.86           O  
ATOM    750  N   ARG    91      26.978  28.922  10.475  1.00 11.21           N  
ATOM    751  CA  ARG    91      25.693  28.726   9.753  1.00 11.52           C  
ATOM    752  C   ARG    91      25.545  29.632   8.523  1.00 10.85           C  
ATOM    753  O   ARG    91      24.752  29.346   7.617  1.00 11.71           O  
ATOM    754  CB  ARG    91      24.487  28.872  10.673  1.00 10.94           C  
ATOM    755  CG  ARG    91      24.441  27.792  11.768  1.00 13.03           C  
ATOM    756  CD  ARG    91      23.351  28.149  12.747  1.00 15.77           C  
ATOM    757  NE  ARG    91      23.786  29.244  13.608  1.00 15.09           N  
ATOM    758  CZ  ARG    91      23.191  29.560  14.752  1.00 17.43           C  
ATOM    759  NH1 ARG    91      22.113  28.881  15.146  1.00 16.56           N  
ATOM    760  NH2 ARG    91      23.653  30.574  15.469  1.00 16.42           N  
ATOM    761  N   LEU    92      26.309  30.720   8.483  1.00 10.05           N  
ATOM    762  CA  LEU    92      26.264  31.669   7.370  1.00 10.24           C  
ATOM    763  C   LEU    92      27.184  31.304   6.192  1.00 10.17           C  
ATOM    764  O   LEU    92      27.289  32.071   5.230  1.00  9.19           O  
ATOM    765  CB  LEU    92      26.659  33.064   7.888  1.00 10.64           C  
ATOM    766  CG  LEU    92      25.647  33.620   8.896  1.00  7.81           C  
ATOM    767  CD1 LEU    92      26.151  34.998   9.449  1.00  9.51           C  
ATOM    768  CD2 LEU    92      24.265  33.840   8.216  1.00  9.67           C  
ATOM    769  N   ARG    93      27.896  30.172   6.322  1.00  9.79           N  
ATOM    770  CA  ARG    93      28.920  29.832   5.307  0.50 10.74           C  
ATOM    772  C   ARG    93      28.293  29.473   3.946  1.00 10.23           C  
ATOM    773  O   ARG    93      27.130  29.136   3.852  1.00  9.45           O  
ATOM    774  CB  ARG    93      29.871  28.723   5.810  0.50 10.99           C  
ATOM    776  CG  ARG    93      30.830  29.182   6.953  0.50 10.53           C  
ATOM    778  CD  ARG    93      31.618  28.043   7.722  0.50 13.00           C  
ATOM    780  NE  ARG    93      32.947  27.783   7.170  0.50 16.63           N  
ATOM    782  CZ  ARG    93      33.539  26.581   7.087  0.50 18.09           C  
ATOM    784  NH1 ARG    93      34.723  26.475   6.518  0.50 20.66           N  
ATOM    786  NH2 ARG    93      32.953  25.481   7.538  0.50 21.05           N  
ATOM    788  N   GLU    94      29.087  29.574   2.874  1.00  9.81           N  
ATOM    789  CA  GLU    94      28.566  29.225   1.559  1.00  9.24           C  
ATOM    790  C   GLU    94      28.222  27.720   1.486  1.00  8.74           C  
ATOM    791  O   GLU    94      28.737  26.905   2.264  1.00 10.34           O  
ATOM    792  CB  GLU    94      29.576  29.564   0.464  1.00 11.27           C  
ATOM    793  CG  GLU    94      29.088  29.349  -0.995  1.00 12.74           C  
ATOM    794  CD  GLU    94      27.785  30.006  -1.403  1.00 10.47           C  
ATOM    795  OE1 GLU    94      26.737  29.737  -0.779  1.00 14.15           O  
ATOM    796  OE2 GLU    94      27.760  30.741  -2.438  1.00 16.89           O  
ATOM    797  N   ARG    95      27.340  27.399   0.548  1.00  9.78           N  
ATOM    798  CA  ARG    95      27.030  25.998   0.196  1.00  9.41           C  
ATOM    799  C   ARG    95      28.352  25.240  -0.046  1.00 10.34           C  
ATOM    800  O   ARG    95      29.275  25.768  -0.680  1.00 10.97           O  
ATOM    801  CB  ARG    95      26.208  26.018  -1.105  1.00 10.13           C  
ATOM    802  CG  ARG    95      25.946  24.628  -1.684  1.00 11.28           C  
ATOM    803  CD  ARG    95      24.903  24.690  -2.839  1.00 10.27           C  
ATOM    804  NE  ARG    95      24.391  23.349  -3.179  1.00 11.61           N  
ATOM    805  CZ  ARG    95      23.752  23.052  -4.310  1.00 14.85           C  
ATOM    806  NH1 ARG    95      23.582  23.987  -5.240  1.00 13.49           N  
ATOM    807  NH2 ARG    95      23.327  21.791  -4.534  1.00 15.15           N  
ATOM    808  N   LYS    96      28.445  24.020   0.483  1.00 10.77           N  
ATOM    809  CA  LYS    96      29.595  23.136   0.192  1.00 11.17           C  
ATOM    810  C   LYS    96      29.486  22.581  -1.218  1.00 10.95           C  
ATOM    811  O   LYS    96      28.428  22.118  -1.598  1.00 10.65           O  
ATOM    812  CB  LYS    96      29.583  21.978   1.171  1.00 11.63           C  
ATOM    813  CG  LYS    96      30.032  22.318   2.529  1.00 13.62           C  
ATOM    814  CD  LYS    96      29.955  21.039   3.375  1.00 16.90           C  
ATOM    815  CE  LYS    96      30.787  21.227   4.642  1.00 21.22           C  
ATOM    816  NZ  LYS    96      30.972  19.848   5.295  1.00 27.76           N  
ATOM    817  N   TYR    97      30.603  22.551  -1.955  1.00 11.30           N  
ATOM    818  CA  TYR    97      30.624  21.926  -3.290  1.00 12.22           C  
ATOM    819  C   TYR    97      31.571  20.706  -3.360  1.00 11.94           C  
ATOM    820  O   TYR    97      31.841  20.166  -4.447  1.00 12.35           O  
ATOM    821  CB  TYR    97      31.000  22.967  -4.355  1.00 13.04           C  
ATOM    822  CG  TYR    97      29.936  24.034  -4.515  1.00 14.72           C  
ATOM    823  CD1 TYR    97      28.774  23.798  -5.274  1.00 14.38           C  
ATOM    824  CD2 TYR    97      30.088  25.270  -3.896  1.00 15.43           C  
ATOM    825  CE1 TYR    97      27.810  24.791  -5.393  1.00 14.73           C  
ATOM    826  CE2 TYR    97      29.122  26.262  -4.010  1.00 12.53           C  
ATOM    827  CZ  TYR    97      27.999  26.014  -4.720  1.00 14.34           C  
ATOM    828  OH  TYR    97      27.092  27.032  -4.827  1.00 16.25           O  
ATOM    829  N   GLY    98      32.089  20.291  -2.206  1.00 11.77           N  
ATOM    830  CA  GLY    98      32.826  19.036  -2.111  1.00 12.24           C  
ATOM    831  C   GLY    98      33.949  18.921  -3.124  1.00 11.83           C  
ATOM    832  O   GLY    98      34.843  19.794  -3.224  1.00 11.40           O  
ATOM    833  N   VAL    99      33.936  17.809  -3.851  1.00 12.50           N  
ATOM    834  CA  VAL    99      35.079  17.516  -4.759  1.00 12.04           C  
ATOM    835  C   VAL    99      35.247  18.503  -5.926  1.00 13.67           C  
ATOM    836  O   VAL    99      36.288  18.456  -6.634  1.00 14.68           O  
ATOM    837  CB  VAL    99      34.966  16.107  -5.330  1.00 12.48           C  
ATOM    838  CG1 VAL    99      34.952  15.066  -4.205  1.00 11.02           C  
ATOM    839  CG2 VAL    99      33.676  16.004  -6.206  1.00 10.02           C  
ATOM    840  N   VAL   100      34.243  19.356  -6.190  1.00 13.11           N  
ATOM    841  CA  VAL   100      34.429  20.384  -7.258  1.00 14.81           C  
ATOM    842  C   VAL   100      34.881  21.755  -6.749  1.00 14.74           C  
ATOM    843  O   VAL   100      35.011  22.702  -7.539  1.00 14.67           O  
ATOM    844  CB  VAL   100      33.220  20.532  -8.215  1.00 15.29           C  
ATOM    845  CG1 VAL   100      32.946  19.211  -8.916  1.00 19.59           C  
ATOM    846  CG2 VAL   100      32.006  20.981  -7.464  1.00 14.33           C  
ATOM    847  N   GLU   101      35.136  21.874  -5.446  1.00 14.02           N  
ATOM    848  CA  GLU   101      35.714  23.106  -4.924  1.00 14.89           C  
ATOM    849  C   GLU   101      37.010  23.377  -5.661  1.00 16.00           C  
ATOM    850  O   GLU   101      37.861  22.484  -5.742  1.00 16.46           O  
ATOM    851  CB  GLU   101      36.007  22.975  -3.420  1.00 15.96           C  
ATOM    852  CG  GLU   101      34.792  22.693  -2.590  1.00 18.68           C  
ATOM    853  CD  GLU   101      34.050  23.919  -2.181  1.00 21.81           C  
ATOM    854  OE1 GLU   101      34.382  25.012  -2.728  1.00 23.06           O  
ATOM    855  OE2 GLU   101      33.145  23.767  -1.300  1.00 19.19           O  
ATOM    856  N   GLY   102      37.147  24.585  -6.197  1.00 16.89           N  
ATOM    857  CA  GLY   102      38.361  24.997  -6.908  1.00 18.62           C  
ATOM    858  C   GLY   102      38.395  24.590  -8.367  1.00 19.14           C  
ATOM    859  O   GLY   102      39.412  24.832  -9.049  1.00 20.07           O  
ATOM    860  N   LYS   103      37.291  24.032  -8.876  1.00 18.98           N  
ATOM    861  CA  LYS   103      37.197  23.699 -10.299  1.00 20.92           C  
ATOM    862  C   LYS   103      36.380  24.757 -11.029  1.00 21.03           C  
ATOM    863  O   LYS   103      35.632  25.519 -10.411  1.00 20.19           O  
ATOM    864  CB  LYS   103      36.570  22.310 -10.518  1.00 20.50           C  
ATOM    865  CG  LYS   103      37.190  21.159  -9.715  1.00 22.86           C  
ATOM    866  CD  LYS   103      38.507  20.669 -10.290  1.00 23.45           C  
ATOM    867  CE  LYS   103      38.950  19.375  -9.614  1.00 23.50           C  
ATOM    868  NZ  LYS   103      40.298  18.991 -10.102  1.00 25.68           N  
ATOM    869  N   ALA   104      36.531  24.809 -12.356  1.00 22.14           N  
ATOM    870  CA  ALA   104      35.691  25.672 -13.175  1.00 23.68           C  
ATOM    871  C   ALA   104      34.233  25.281 -13.011  1.00 24.89           C  
ATOM    872  O   ALA   104      33.888  24.084 -12.896  1.00 23.99           O  
ATOM    873  CB  ALA   104      36.097  25.574 -14.678  1.00 24.14           C  
ATOM    874  N   LEU   105      33.380  26.298 -12.996  1.00 27.07           N  
ATOM    875  CA  LEU   105      31.931  26.103 -13.087  1.00 28.87           C  
ATOM    876  C   LEU   105      31.530  25.061 -14.143  1.00 29.02           C  
ATOM    877  O   LEU   105      30.664  24.232 -13.898  1.00 29.23           O  
ATOM    878  CB  LEU   105      31.257  27.442 -13.362  1.00 29.23           C  
ATOM    879  CG  LEU   105      29.755  27.479 -13.668  1.00 31.02           C  
ATOM    880  CD1 LEU   105      28.907  27.141 -12.425  1.00 32.77           C  
ATOM    881  CD2 LEU   105      29.399  28.852 -14.209  1.00 30.51           C  
ATOM    882  N   SER   106      32.178  25.086 -15.307  1.00 29.91           N  
ATOM    883  CA  SER   106      31.881  24.149 -16.387  1.00 29.14           C  
ATOM    884  C   SER   106      32.051  22.681 -15.998  1.00 29.11           C  
ATOM    885  O   SER   106      31.355  21.822 -16.527  1.00 29.44           O  
ATOM    886  CB  SER   106      32.728  24.472 -17.622  1.00 29.72           C  
ATOM    887  OG  SER   106      34.098  24.225 -17.361  1.00 30.00           O  
ATOM    888  N   GLU   107      32.982  22.398 -15.080  1.00 27.75           N  
ATOM    889  CA  GLU   107      33.183  21.041 -14.562  1.00 27.48           C  
ATOM    890  C   GLU   107      32.013  20.561 -13.714  1.00 26.29           C  
ATOM    891  O   GLU   107      31.682  19.367 -13.708  1.00 25.83           O  
ATOM    892  CB  GLU   107      34.431  20.982 -13.697  1.00 27.28           C  
ATOM    893  CG  GLU   107      35.726  20.925 -14.471  1.00 31.09           C  
ATOM    894  CD  GLU   107      36.761  20.054 -13.765  1.00 34.47           C  
ATOM    895  OE1 GLU   107      36.413  18.951 -13.265  1.00 39.28           O  
ATOM    896  OE2 GLU   107      37.930  20.465 -13.731  1.00 36.57           O  
ATOM    897  N   LEU   108      31.437  21.482 -12.953  1.00 24.91           N  
ATOM    898  CA  LEU   108      30.246  21.168 -12.154  1.00 24.54           C  
ATOM    899  C   LEU   108      29.064  20.903 -13.085  1.00 24.38           C  
ATOM    900  O   LEU   108      28.318  19.949 -12.900  1.00 23.94           O  
ATOM    901  CB  LEU   108      29.924  22.317 -11.200  1.00 23.85           C  
ATOM    902  CG  LEU   108      28.633  22.283 -10.366  1.00 24.31           C  
ATOM    903  CD1 LEU   108      28.572  21.058  -9.475  1.00 24.85           C  
ATOM    904  CD2 LEU   108      28.493  23.548  -9.560  1.00 25.05           C  
ATOM    905  N   ARG   109      28.905  21.759 -14.093  1.00 24.69           N  
ATOM    906  CA  ARG   109      27.797  21.593 -15.046  1.00 25.81           C  
ATOM    907  C   ARG   109      27.927  20.267 -15.799  1.00 25.60           C  
ATOM    908  O   ARG   109      26.936  19.578 -16.013  1.00 25.88           O  
ATOM    909  CB  ARG   109      27.722  22.778 -16.012  1.00 26.38           C  
ATOM    910  CG  ARG   109      27.505  24.090 -15.295  1.00 29.70           C  
ATOM    911  CD  ARG   109      26.671  25.027 -16.096  1.00 37.60           C  
ATOM    912  NE  ARG   109      26.665  26.367 -15.512  1.00 43.01           N  
ATOM    913  CZ  ARG   109      26.248  27.449 -16.166  1.00 45.11           C  
ATOM    914  NH1 ARG   109      25.796  27.329 -17.408  1.00 47.16           N  
ATOM    915  NH2 ARG   109      26.277  28.645 -15.585  1.00 47.45           N  
ATOM    916  N   ALA   110      29.155  19.917 -16.190  1.00 25.45           N  
ATOM    917  CA  ALA   110      29.412  18.652 -16.891  1.00 25.48           C  
ATOM    918  C   ALA   110      29.078  17.447 -16.012  1.00 25.62           C  
ATOM    919  O   ALA   110      28.485  16.465 -16.476  1.00 25.86           O  
ATOM    920  CB  ALA   110      30.848  18.593 -17.374  1.00 25.39           C  
ATOM    921  N   MET   111      29.438  17.540 -14.729  1.00 24.85           N  
ATOM    922  CA  MET   111      29.117  16.514 -13.757  0.50 23.26           C  
ATOM    924  C   MET   111      27.592  16.359 -13.584  1.00 24.91           C  
ATOM    925  O   MET   111      27.085  15.230 -13.477  1.00 24.74           O  
ATOM    926  CB  MET   111      29.815  16.828 -12.422  0.50 23.59           C  
ATOM    928  CG  MET   111      30.092  15.611 -11.579  0.50 20.75           C  
ATOM    930  SD  MET   111      30.883  16.032  -9.843  0.50 18.95          SE  
ATOM    932  CE  MET   111      32.747  15.837 -10.220  0.50 15.17           C  
ATOM    934  N   ALA   112      26.884  17.494 -13.540  1.00 25.44           N  
ATOM    935  CA  ALA   112      25.427  17.512 -13.439  1.00 26.76           C  
ATOM    936  C   ALA   112      24.818  16.790 -14.647  1.00 27.56           C  
ATOM    937  O   ALA   112      24.077  15.821 -14.486  1.00 27.10           O  
ATOM    938  CB  ALA   112      24.911  18.932 -13.376  1.00 26.49           C  
ATOM    939  N   LYS   113      25.139  17.300 -15.834  1.00 29.94           N  
ATOM    940  CA  LYS   113      24.723  16.725 -17.128  1.00 31.32           C  
ATOM    941  C   LYS   113      24.909  15.206 -17.140  1.00 31.81           C  
ATOM    942  O   LYS   113      23.985  14.460 -17.480  1.00 32.12           O  
ATOM    943  CB  LYS   113      25.496  17.434 -18.269  1.00 32.12           C  
ATOM    944  CG  LYS   113      25.539  16.786 -19.681  1.00 32.56           C  
ATOM    945  CD  LYS   113      24.177  16.663 -20.371  1.00 37.78           C  
ATOM    946  CE  LYS   113      24.235  15.605 -21.499  1.00 38.53           C  
ATOM    947  NZ  LYS   113      22.973  14.790 -21.585  1.00 41.24           N  
ATOM    948  N   ALA   114      26.094  14.753 -16.737  1.00 32.76           N  
ATOM    949  CA  ALA   114      26.410  13.322 -16.690  1.00 33.68           C  
ATOM    950  C   ALA   114      25.518  12.546 -15.725  1.00 34.47           C  
ATOM    951  O   ALA   114      25.190  11.380 -15.980  1.00 34.78           O  
ATOM    952  CB  ALA   114      27.859  13.111 -16.338  1.00 33.77           C  
ATOM    953  N   ALA   115      25.130  13.181 -14.617  1.00 34.82           N  
ATOM    954  CA  ALA   115      24.253  12.533 -13.633  1.00 35.21           C  
ATOM    955  C   ALA   115      22.772  12.575 -14.030  1.00 35.51           C  
ATOM    956  O   ALA   115      21.914  12.092 -13.291  1.00 35.77           O  
ATOM    957  CB  ALA   115      24.458  13.149 -12.245  1.00 35.54           C  
ATOM    958  N   ARG   116      22.485  13.151 -15.197  1.00 35.81           N  
ATOM    959  CA  ARG   116      21.116  13.413 -15.664  1.00 36.57           C  
ATOM    960  C   ARG   116      20.358  14.336 -14.703  1.00 35.96           C  
ATOM    961  O   ARG   116      19.173  14.146 -14.421  1.00 35.58           O  
ATOM    962  CB  ARG   116      20.351  12.109 -15.954  1.00 36.76           C  
ATOM    963  CG  ARG   116      20.943  11.282 -17.109  1.00 38.35           C  
ATOM    964  CD  ARG   116      19.941  10.231 -17.616  1.00 39.16           C  
ATOM    965  NE  ARG   116      18.865  10.833 -18.415  1.00 45.58           N  
ATOM    966  CZ  ARG   116      18.722  10.692 -19.735  1.00 47.21           C  
ATOM    967  NH1 ARG   116      17.713  11.292 -20.360  1.00 48.53           N  
ATOM    968  NH2 ARG   116      19.577   9.950 -20.436  1.00 47.82           N  
ATOM    969  N   GLU   117      21.074  15.339 -14.198  1.00 35.11           N  
ATOM    970  CA  GLU   117      20.493  16.359 -13.344  1.00 34.78           C  
ATOM    971  C   GLU   117      20.925  17.749 -13.819  1.00 33.72           C  
ATOM    972  O   GLU   117      21.735  17.874 -14.752  1.00 33.94           O  
ATOM    973  CB  GLU   117      20.900  16.117 -11.888  1.00 34.37           C  
ATOM    974  CG  GLU   117      20.427  14.774 -11.341  1.00 35.31           C  
ATOM    975  CD  GLU   117      20.919  14.515  -9.929  1.00 36.02           C  
ATOM    976  OE1 GLU   117      21.039  15.488  -9.157  1.00 35.32           O  
ATOM    977  OE2 GLU   117      21.184  13.339  -9.586  1.00 39.92           O  
ATOM    978  N   GLU   118      20.361  18.785 -13.204  1.00 32.71           N  
ATOM    979  CA  GLU   118      20.663  20.176 -13.569  1.00 32.59           C  
ATOM    980  C   GLU   118      21.165  20.955 -12.355  1.00 30.03           C  
ATOM    981  O   GLU   118      20.750  20.663 -11.221  1.00 28.44           O  
ATOM    982  CB  GLU   118      19.410  20.892 -14.056  1.00 32.85           C  
ATOM    983  CG  GLU   118      18.594  20.155 -15.100  1.00 35.90           C  
ATOM    984  CD  GLU   118      17.471  21.020 -15.648  1.00 36.89           C  
ATOM    985  OE1 GLU   118      16.623  21.507 -14.845  1.00 42.48           O  
ATOM    986  OE2 GLU   118      17.447  21.218 -16.887  1.00 42.19           O  
ATOM    987  N   CYS   119      22.027  21.946 -12.614  1.00 28.23           N  
ATOM    988  CA  CYS   119      22.452  22.914 -11.593  1.00 26.98           C  
ATOM    989  C   CYS   119      21.342  23.946 -11.462  1.00 25.57           C  
ATOM    990  O   CYS   119      20.665  24.224 -12.462  1.00 25.73           O  
ATOM    991  CB  CYS   119      23.757  23.606 -12.002  1.00 27.45           C  
ATOM    992  SG  CYS   119      25.141  22.472 -12.121  1.00 29.53           S  
ATOM    993  N   PRO   120      21.139  24.523 -10.258  1.00 23.62           N  
ATOM    994  CA  PRO   120      21.849  24.302  -8.974  1.00 21.20           C  
ATOM    995  C   PRO   120      21.369  23.125  -8.124  1.00 20.06           C  
ATOM    996  O   PRO   120      21.936  22.885  -7.060  1.00 17.82           O  
ATOM    997  CB  PRO   120      21.537  25.580  -8.198  1.00 22.04           C  
ATOM    998  CG  PRO   120      20.144  25.948  -8.652  1.00 22.84           C  
ATOM    999  CD  PRO   120      20.095  25.560 -10.125  1.00 23.21           C  
ATOM   1000  N   VAL   121      20.349  22.390  -8.562  1.00 18.45           N  
ATOM   1001  CA  VAL   121      19.870  21.259  -7.749  1.00 17.90           C  
ATOM   1002  C   VAL   121      20.963  20.198  -7.540  1.00 16.37           C  
ATOM   1003  O   VAL   121      21.146  19.687  -6.433  1.00 16.62           O  
ATOM   1004  CB  VAL   121      18.557  20.661  -8.340  1.00 18.55           C  
ATOM   1005  CG1 VAL   121      18.271  19.271  -7.769  1.00 19.26           C  
ATOM   1006  CG2 VAL   121      17.409  21.618  -8.031  1.00 18.36           C  
ATOM   1007  N   PHE   122      21.673  19.872  -8.610  1.00 16.51           N  
ATOM   1008  CA  PHE   122      22.654  18.799  -8.556  1.00 16.39           C  
ATOM   1009  C   PHE   122      23.668  19.052  -7.432  1.00 16.35           C  
ATOM   1010  O   PHE   122      24.175  20.152  -7.316  1.00 15.68           O  
ATOM   1011  CB  PHE   122      23.375  18.677  -9.889  1.00 17.53           C  
ATOM   1012  CG  PHE   122      24.571  17.769  -9.834  1.00 18.38           C  
ATOM   1013  CD1 PHE   122      24.405  16.393  -9.692  1.00 18.85           C  
ATOM   1014  CD2 PHE   122      25.873  18.316  -9.857  1.00 19.32           C  
ATOM   1015  CE1 PHE   122      25.520  15.545  -9.598  1.00 21.40           C  
ATOM   1016  CE2 PHE   122      26.990  17.492  -9.795  1.00 19.08           C  
ATOM   1017  CZ  PHE   122      26.818  16.100  -9.644  1.00 20.67           C  
ATOM   1018  N   THR   123      23.937  18.023  -6.636  1.00 14.58           N  
ATOM   1019  CA  THR   123      24.913  18.081  -5.558  1.00 13.79           C  
ATOM   1020  C   THR   123      26.057  17.091  -5.784  1.00 13.81           C  
ATOM   1021  O   THR   123      25.815  15.882  -5.743  1.00 14.03           O  
ATOM   1022  CB  THR   123      24.210  17.757  -4.229  1.00 13.79           C  
ATOM   1023  OG1 THR   123      23.150  18.714  -4.043  1.00 13.23           O  
ATOM   1024  CG2 THR   123      25.165  17.834  -3.075  1.00 13.37           C  
ATOM   1025  N   PRO   124      27.298  17.598  -5.974  1.00 13.35           N  
ATOM   1026  CA  PRO   124      28.459  16.717  -6.210  1.00 12.91           C  
ATOM   1027  C   PRO   124      28.835  15.980  -4.923  1.00 13.01           C  
ATOM   1028  O   PRO   124      28.407  16.405  -3.816  1.00 12.54           O  
ATOM   1029  CB  PRO   124      29.580  17.679  -6.617  1.00 14.14           C  
ATOM   1030  CG  PRO   124      29.146  19.047  -6.128  1.00 13.45           C  
ATOM   1031  CD  PRO   124      27.650  19.032  -5.972  1.00 12.87           C  
ATOM   1032  N   PRO   125      29.655  14.912  -5.037  1.00 13.44           N  
ATOM   1033  CA  PRO   125      30.187  14.273  -3.846  1.00 13.53           C  
ATOM   1034  C   PRO   125      30.823  15.290  -2.880  1.00 13.16           C  
ATOM   1035  O   PRO   125      31.621  16.109  -3.298  1.00 12.44           O  
ATOM   1036  CB  PRO   125      31.230  13.295  -4.423  1.00 14.24           C  
ATOM   1037  CG  PRO   125      30.673  12.977  -5.804  1.00 15.16           C  
ATOM   1038  CD  PRO   125      30.160  14.294  -6.276  1.00 14.35           C  
ATOM   1039  N   GLY   126      30.452  15.221  -1.600  1.00 13.37           N  
ATOM   1040  CA  GLY   126      30.991  16.124  -0.568  1.00 12.38           C  
ATOM   1041  C   GLY   126      30.260  17.469  -0.494  1.00 12.55           C  
ATOM   1042  O   GLY   126      30.558  18.265   0.386  1.00 14.16           O  
ATOM   1043  N   GLY   127      29.307  17.701  -1.375  1.00 12.12           N  
ATOM   1044  CA  GLY   127      28.544  18.974  -1.397  1.00 11.03           C  
ATOM   1045  C   GLY   127      27.258  18.895  -0.603  1.00 12.16           C  
ATOM   1046  O   GLY   127      26.846  17.783  -0.121  1.00 11.11           O  
ATOM   1047  N   GLU   128      26.644  20.072  -0.380  1.00 11.01           N  
ATOM   1048  CA  GLU   128      25.330  20.188   0.289  1.00 11.89           C  
ATOM   1049  C   GLU   128      24.229  20.326  -0.747  1.00 11.34           C  
ATOM   1050  O   GLU   128      24.424  20.983  -1.790  1.00 12.25           O  
ATOM   1051  CB  GLU   128      25.265  21.460   1.176  1.00 11.43           C  
ATOM   1052  CG  GLU   128      26.020  21.334   2.516  1.00 11.16           C  
ATOM   1053  CD  GLU   128      26.067  22.656   3.250  1.00 14.31           C  
ATOM   1054  OE1 GLU   128      26.553  23.629   2.649  1.00 12.14           O  
ATOM   1055  OE2 GLU   128      25.672  22.695   4.437  1.00 17.34           O  
ATOM   1056  N   THR   129      23.055  19.755  -0.451  1.00 11.74           N  
ATOM   1057  CA  THR   129      21.827  19.964  -1.236  1.00 11.64           C  
ATOM   1058  C   THR   129      21.280  21.373  -0.977  1.00 11.58           C  
ATOM   1059  O   THR   129      21.643  21.995   0.050  1.00 10.25           O  
ATOM   1060  CB  THR   129      20.719  18.950  -0.876  1.00 12.61           C  
ATOM   1061  OG1 THR   129      20.353  19.146   0.536  1.00 14.75           O  
ATOM   1062  CG2 THR   129      21.286  17.516  -0.977  1.00 15.54           C  
ATOM   1063  N   LEU   130      20.437  21.862  -1.904  1.00 11.52           N  
ATOM   1064  CA  LEU   130      19.738  23.143  -1.676  1.00 12.31           C  
ATOM   1065  C   LEU   130      18.949  23.100  -0.380  1.00 12.77           C  
ATOM   1066  O   LEU   130      18.929  24.072   0.332  1.00 10.77           O  
ATOM   1067  CB  LEU   130      18.831  23.525  -2.852  1.00 13.53           C  
ATOM   1068  CG  LEU   130      19.595  23.847  -4.142  1.00 14.68           C  
ATOM   1069  CD1 LEU   130      18.645  24.060  -5.326  1.00 17.49           C  
ATOM   1070  CD2 LEU   130      20.532  25.046  -3.947  1.00 18.17           C  
ATOM   1071  N   ASP   131      18.345  21.964  -0.042  1.00 12.80           N  
ATOM   1072  CA  ASP   131      17.546  21.916   1.175  1.00 13.89           C  
ATOM   1073  C   ASP   131      18.433  21.950   2.421  1.00 13.08           C  
ATOM   1074  O   ASP   131      18.056  22.543   3.433  1.00 12.35           O  
ATOM   1075  CB  ASP   131      16.610  20.690   1.175  1.00 15.29           C  
ATOM   1076  CG  ASP   131      15.323  20.920   0.350  1.00 19.19           C  
ATOM   1077  OD1 ASP   131      14.896  22.070   0.066  1.00 24.81           O  
ATOM   1078  OD2 ASP   131      14.735  19.904  -0.020  1.00 27.72           O  
ATOM   1079  N   GLN   132      19.621  21.349   2.346  1.00 12.26           N  
ATOM   1080  CA  GLN   132      20.561  21.450   3.443  1.00 11.76           C  
ATOM   1081  C   GLN   132      21.019  22.912   3.650  1.00 11.28           C  
ATOM   1082  O   GLN   132      21.130  23.390   4.812  1.00  9.47           O  
ATOM   1083  CB  GLN   132      21.777  20.566   3.167  1.00 12.20           C  
ATOM   1084  CG  GLN   132      21.508  19.091   3.488  1.00 15.13           C  
ATOM   1085  CD  GLN   132      22.679  18.210   3.078  1.00 18.85           C  
ATOM   1086  OE1 GLN   132      23.201  18.338   1.971  1.00 16.27           O  
ATOM   1087  NE2 GLN   132      23.110  17.325   3.991  1.00 23.69           N  
ATOM   1088  N   VAL   133      21.279  23.616   2.550  1.00  9.48           N  
ATOM   1089  CA  VAL   133      21.651  25.041   2.659  1.00  9.49           C  
ATOM   1090  C   VAL   133      20.518  25.854   3.282  1.00  9.92           C  
ATOM   1091  O   VAL   133      20.744  26.611   4.228  1.00  9.67           O  
ATOM   1092  CB  VAL   133      22.038  25.636   1.275  1.00 10.42           C  
ATOM   1093  CG1 VAL   133      22.439  27.068   1.402  1.00 10.99           C  
ATOM   1094  CG2 VAL   133      23.237  24.856   0.663  1.00  9.59           C  
ATOM   1095  N   LYS   134      19.309  25.698   2.754  1.00 10.05           N  
ATOM   1096  CA  LYS   134      18.129  26.384   3.308  1.00 10.95           C  
ATOM   1097  C   LYS   134      17.980  26.086   4.795  1.00 11.05           C  
ATOM   1098  O   LYS   134      17.592  26.959   5.566  1.00  9.92           O  
ATOM   1099  CB  LYS   134      16.856  25.966   2.585  1.00 10.96           C  
ATOM   1100  CG  LYS   134      15.648  26.772   3.054  1.00 13.28           C  
ATOM   1101  CD  LYS   134      14.331  26.418   2.340  1.00 15.14           C  
ATOM   1102  CE  LYS   134      14.135  27.178   1.071  1.00 19.20           C  
ATOM   1103  NZ  LYS   134      12.763  26.837   0.546  1.00 22.40           N  
ATOM   1104  N   MET   135      18.239  24.845   5.204  1.00  9.06           N  
ATOM   1105  CA  MET   135      18.044  24.514   6.621  1.00 11.12           C  
ATOM   1106  C   MET   135      19.006  25.323   7.494  1.00 10.30           C  
ATOM   1107  O   MET   135      18.621  25.789   8.531  1.00 10.53           O  
ATOM   1108  CB  MET   135      18.138  22.983   6.830  1.00 11.96           C  
ATOM   1109  CG  MET   135      17.896  22.479   8.257  1.00 13.35           C  
ATOM   1110  SD  MET   135      16.066  22.913   8.811  1.00 15.75          SE  
ATOM   1111  CE  MET   135      16.394  24.116  10.229  1.00 19.57           C  
ATOM   1112  N   ARG   136      20.245  25.528   7.042  1.00  9.96           N  
ATOM   1113  CA  ARG   136      21.207  26.423   7.733  1.00  9.44           C  
ATOM   1114  C   ARG   136      20.721  27.874   7.792  1.00 10.34           C  
ATOM   1115  O   ARG   136      20.948  28.566   8.776  1.00 11.05           O  
ATOM   1116  CB  ARG   136      22.596  26.348   7.102  1.00  8.92           C  
ATOM   1117  CG  ARG   136      23.220  24.964   7.297  1.00 10.88           C  
ATOM   1118  CD  ARG   136      24.692  25.051   7.080  1.00 10.58           C  
ATOM   1119  NE  ARG   136      25.105  25.173   5.661  1.00  9.48           N  
ATOM   1120  CZ  ARG   136      25.618  26.262   5.081  1.00 10.08           C  
ATOM   1121  NH1 ARG   136      25.626  27.455   5.692  1.00  9.95           N  
ATOM   1122  NH2 ARG   136      26.066  26.169   3.812  1.00  9.85           N  
ATOM   1123  N   GLY   137      19.974  28.275   6.763  1.00  9.12           N  
ATOM   1124  CA  GLY   137      19.362  29.616   6.694  1.00 10.59           C  
ATOM   1125  C   GLY   137      18.235  29.727   7.721  1.00 10.98           C  
ATOM   1126  O   GLY   137      18.143  30.735   8.466  1.00 10.49           O  
ATOM   1127  N   ILE   138      17.365  28.706   7.739  1.00 10.10           N  
ATOM   1128  CA  ILE   138      16.271  28.625   8.740  1.00  9.94           C  
ATOM   1129  C   ILE   138      16.838  28.634  10.204  1.00 10.47           C  
ATOM   1130  O   ILE   138      16.357  29.367  11.071  1.00 10.30           O  
ATOM   1131  CB  ILE   138      15.379  27.383   8.485  1.00  9.63           C  
ATOM   1132  CG1 ILE   138      14.688  27.518   7.103  1.00  9.46           C  
ATOM   1133  CG2 ILE   138      14.331  27.262   9.586  1.00 12.67           C  
ATOM   1134  CD1 ILE   138      13.942  26.227   6.728  1.00 10.38           C  
ATOM   1135  N   ASP   139      17.871  27.827  10.446  1.00 10.75           N  
ATOM   1136  CA  ASP   139      18.523  27.719  11.751  1.00 12.25           C  
ATOM   1137  C   ASP   139      19.051  29.087  12.177  1.00 11.78           C  
ATOM   1138  O   ASP   139      18.744  29.575  13.280  1.00 12.04           O  
ATOM   1139  CB  ASP   139      19.665  26.694  11.614  1.00 12.31           C  
ATOM   1140  CG  ASP   139      20.421  26.416  12.931  1.00 17.51           C  
ATOM   1141  OD1 ASP   139      20.224  27.111  13.931  1.00 23.55           O  
ATOM   1142  OD2 ASP   139      21.267  25.482  12.918  1.00 23.53           O  
ATOM   1143  N   PHE   140      19.828  29.719  11.300  1.00 10.99           N  
ATOM   1144  CA  PHE   140      20.375  31.032  11.623  1.00 11.07           C  
ATOM   1145  C   PHE   140      19.255  32.044  11.868  1.00 10.71           C  
ATOM   1146  O   PHE   140      19.280  32.819  12.844  1.00 11.15           O  
ATOM   1147  CB  PHE   140      21.308  31.564  10.533  1.00 10.66           C  
ATOM   1148  CG  PHE   140      21.842  32.928  10.882  1.00 11.12           C  
ATOM   1149  CD1 PHE   140      22.879  33.030  11.802  1.00 13.72           C  
ATOM   1150  CD2 PHE   140      21.241  34.092  10.383  1.00 11.20           C  
ATOM   1151  CE1 PHE   140      23.358  34.277  12.190  1.00 13.44           C  
ATOM   1152  CE2 PHE   140      21.724  35.384  10.768  1.00 11.43           C  
ATOM   1153  CZ  PHE   140      22.778  35.452  11.680  1.00 13.56           C  
ATOM   1154  N   PHE   141      18.275  32.061  10.961  1.00  9.26           N  
ATOM   1155  CA  PHE   141      17.192  33.042  11.078  1.00  9.67           C  
ATOM   1156  C   PHE   141      16.396  32.886  12.391  1.00  9.64           C  
ATOM   1157  O   PHE   141      16.073  33.884  13.054  1.00 10.41           O  
ATOM   1158  CB  PHE   141      16.224  32.908   9.897  1.00  9.66           C  
ATOM   1159  CG  PHE   141      15.129  33.941   9.915  1.00 10.69           C  
ATOM   1160  CD1 PHE   141      15.453  35.288   9.712  1.00 11.03           C  
ATOM   1161  CD2 PHE   141      13.787  33.576  10.129  1.00 13.04           C  
ATOM   1162  CE1 PHE   141      14.439  36.279   9.718  1.00 13.41           C  
ATOM   1163  CE2 PHE   141      12.752  34.558  10.131  1.00 12.72           C  
ATOM   1164  CZ  PHE   141      13.090  35.911   9.934  1.00 12.61           C  
ATOM   1165  N   GLU   142      16.056  31.654  12.739  1.00 10.90           N  
ATOM   1166  CA  GLU   142      15.343  31.419  14.018  1.00 12.50           C  
ATOM   1167  C   GLU   142      16.180  31.860  15.208  1.00 12.76           C  
ATOM   1168  O   GLU   142      15.645  32.512  16.144  1.00 12.86           O  
ATOM   1169  CB  GLU   142      14.956  29.948  14.133  1.00 14.29           C  
ATOM   1170  CG  GLU   142      13.950  29.649  13.002  1.00 18.51           C  
ATOM   1171  CD  GLU   142      13.206  28.339  13.106  1.00 26.10           C  
ATOM   1172  OE1 GLU   142      12.074  28.285  12.548  1.00 26.39           O  
ATOM   1173  OE2 GLU   142      13.733  27.380  13.716  1.00 30.36           O  
ATOM   1174  N   PHE   143      17.468  31.490  15.178  1.00 11.64           N  
ATOM   1175  CA  PHE   143      18.452  31.988  16.154  1.00 12.86           C  
ATOM   1176  C   PHE   143      18.407  33.541  16.285  1.00 13.14           C  
ATOM   1177  O   PHE   143      18.296  34.089  17.402  1.00 12.88           O  
ATOM   1178  CB  PHE   143      19.855  31.490  15.793  1.00 14.14           C  
ATOM   1179  CG  PHE   143      20.971  32.331  16.383  1.00 16.21           C  
ATOM   1180  CD1 PHE   143      21.327  32.196  17.723  1.00 19.07           C  
ATOM   1181  CD2 PHE   143      21.602  33.302  15.624  1.00 15.91           C  
ATOM   1182  CE1 PHE   143      22.348  32.991  18.271  1.00 20.54           C  
ATOM   1183  CE2 PHE   143      22.596  34.111  16.160  1.00 20.18           C  
ATOM   1184  CZ  PHE   143      22.977  33.955  17.484  1.00 17.61           C  
ATOM   1185  N   LEU   144      18.513  34.228  15.153  1.00 11.11           N  
ATOM   1186  CA  LEU   144      18.529  35.689  15.110  1.00 11.52           C  
ATOM   1187  C   LEU   144      17.234  36.287  15.704  1.00 11.63           C  
ATOM   1188  O   LEU   144      17.280  37.194  16.562  1.00 12.63           O  
ATOM   1189  CB  LEU   144      18.725  36.173  13.658  1.00 10.82           C  
ATOM   1190  CG  LEU   144      18.846  37.697  13.477  1.00 11.37           C  
ATOM   1191  CD1 LEU   144      20.007  38.293  14.264  1.00 14.98           C  
ATOM   1192  CD2 LEU   144      18.998  38.069  11.981  1.00 12.34           C  
ATOM   1193  N   CYS   145      16.089  35.738  15.280  1.00 11.54           N  
ATOM   1194  CA  CYS   145      14.771  36.188  15.771  1.00 12.26           C  
ATOM   1195  C   CYS   145      14.670  36.081  17.292  1.00 13.44           C  
ATOM   1196  O   CYS   145      14.323  37.070  17.943  1.00 13.67           O  
ATOM   1197  CB  CYS   145      13.644  35.406  15.096  1.00 12.21           C  
ATOM   1198  SG  CYS   145      13.463  35.951  13.328  1.00 14.79           S  
ATOM   1199  N   GLN   146      15.007  34.920  17.837  1.00 13.71           N  
ATOM   1200  CA  GLN   146      15.004  34.707  19.294  1.00 15.59           C  
ATOM   1201  C   GLN   146      15.946  35.663  20.006  1.00 15.93           C  
ATOM   1202  O   GLN   146      15.580  36.240  21.051  1.00 15.40           O  
ATOM   1203  CB  GLN   146      15.332  33.252  19.635  1.00 16.45           C  
ATOM   1204  CG  GLN   146      14.186  32.288  19.241  1.00 22.14           C  
ATOM   1205  CD  GLN   146      12.874  32.640  19.971  1.00 29.71           C  
ATOM   1206  OE1 GLN   146      12.777  32.509  21.201  1.00 32.44           O  
ATOM   1207  NE2 GLN   146      11.882  33.131  19.216  1.00 32.00           N  
ATOM   1208  N   LEU   147      17.138  35.859  19.428  1.00 15.37           N  
ATOM   1209  CA  LEU   147      18.154  36.782  19.976  1.00 15.16           C  
ATOM   1210  C   LEU   147      17.588  38.202  20.161  1.00 15.14           C  
ATOM   1211  O   LEU   147      17.635  38.785  21.258  1.00 15.30           O  
ATOM   1212  CB  LEU   147      19.390  36.799  19.053  1.00 14.58           C  
ATOM   1213  CG  LEU   147      20.477  37.750  19.578  1.00 18.48           C  
ATOM   1214  CD1 LEU   147      21.277  37.026  20.669  1.00 24.94           C  
ATOM   1215  CD2 LEU   147      21.391  38.217  18.509  1.00 21.05           C  
ATOM   1216  N   ILE   148      17.013  38.730  19.088  1.00 13.47           N  
ATOM   1217  CA  ILE   148      16.472  40.085  19.047  1.00 13.77           C  
ATOM   1218  C   ILE   148      15.277  40.239  19.987  1.00 13.26           C  
ATOM   1219  O   ILE   148      15.188  41.254  20.716  1.00 13.49           O  
ATOM   1220  CB  ILE   148      16.083  40.484  17.599  1.00 13.22           C  
ATOM   1221  CG1 ILE   148      17.315  40.531  16.688  1.00 12.36           C  
ATOM   1222  CG2 ILE   148      15.325  41.837  17.556  1.00 15.01           C  
ATOM   1223  CD1 ILE   148      18.530  41.337  17.225  1.00 14.76           C  
ATOM   1224  N   LEU   149      14.378  39.253  19.981  1.00 13.33           N  
ATOM   1225  CA  LEU   149      13.166  39.304  20.851  1.00 12.70           C  
ATOM   1226  C   LEU   149      13.587  39.302  22.328  1.00 13.92           C  
ATOM   1227  O   LEU   149      13.110  40.134  23.119  1.00 13.08           O  
ATOM   1228  CB  LEU   149      12.228  38.132  20.556  1.00 13.22           C  
ATOM   1229  CG  LEU   149      11.562  38.284  19.170  1.00 11.59           C  
ATOM   1230  CD1 LEU   149      10.787  36.997  18.820  1.00 14.38           C  
ATOM   1231  CD2 LEU   149      10.627  39.515  19.141  1.00 16.20           C  
ATOM   1232  N   LYS   150      14.521  38.415  22.660  1.00 13.32           N  
ATOM   1233  CA  LYS   150      15.031  38.306  24.051  1.00 15.01           C  
ATOM   1234  C   LYS   150      15.770  39.578  24.495  1.00 15.41           C  
ATOM   1235  O   LYS   150      15.614  40.042  25.647  1.00 15.91           O  
ATOM   1236  CB  LYS   150      15.924  37.077  24.192  1.00 15.61           C  
ATOM   1237  CG  LYS   150      15.172  35.781  24.225  1.00 18.33           C  
ATOM   1238  CD  LYS   150      16.140  34.636  24.225  1.00 22.37           C  
ATOM   1239  CE  LYS   150      15.405  33.333  24.046  1.00 29.21           C  
ATOM   1240  NZ  LYS   150      15.119  32.732  25.380  1.00 34.01           N  
ATOM   1241  N   GLU   151      16.566  40.159  23.600  1.00 16.59           N  
ATOM   1242  CA  GLU   151      17.236  41.421  23.903  1.00 18.62           C  
ATOM   1243  C   GLU   151      16.242  42.543  24.094  1.00 18.93           C  
ATOM   1244  O   GLU   151      16.381  43.320  25.036  1.00 19.86           O  
ATOM   1245  CB  GLU   151      18.279  41.783  22.826  1.00 18.64           C  
ATOM   1246  CG  GLU   151      19.491  40.830  22.871  1.00 20.23           C  
ATOM   1247  CD  GLU   151      20.613  41.209  21.915  1.00 21.22           C  
ATOM   1248  OE1 GLU   151      20.429  42.127  21.092  1.00 26.24           O  
ATOM   1249  OE2 GLU   151      21.676  40.557  21.971  1.00 24.90           O  
ATOM   1250  N   ALA   152      15.231  42.625  23.220  1.00 19.10           N  
ATOM   1251  CA  ALA   152      14.172  43.629  23.369  1.00 19.49           C  
ATOM   1252  C   ALA   152      13.473  43.445  24.730  1.00 19.77           C  
ATOM   1253  O   ALA   152      13.114  44.432  25.390  1.00 19.86           O  
ATOM   1254  CB  ALA   152      13.159  43.526  22.252  1.00 20.37           C  
ATOM   1255  N   ASP   153      13.259  42.188  25.112  1.00 19.41           N  
ATOM   1256  CA  ASP   153      12.605  41.850  26.380  1.00 21.62           C  
ATOM   1257  C   ASP   153      13.466  42.281  27.569  1.00 23.56           C  
ATOM   1258  O   ASP   153      12.959  42.809  28.560  1.00 23.49           O  
ATOM   1259  CB  ASP   153      12.369  40.338  26.494  1.00 20.56           C  
ATOM   1260  CG  ASP   153      11.495  39.982  27.680  1.00 19.09           C  
ATOM   1261  OD1 ASP   153      10.349  40.462  27.714  1.00 21.16           O  
ATOM   1262  OD2 ASP   153      11.962  39.243  28.563  1.00 19.70           O  
ATOM   1263  N   GLN   154      14.763  42.012  27.472  1.00 26.71           N  
ATOM   1264  CA  GLN   154      15.697  42.277  28.574  1.00 30.61           C  
ATOM   1265  C   GLN   154      16.002  43.776  28.747  1.00 32.44           C  
ATOM   1266  O   GLN   154      16.568  44.176  29.779  1.00 34.00           O  
ATOM   1267  CB  GLN   154      16.979  41.429  28.444  1.00 30.79           C  
ATOM   1268  CG  GLN   154      16.770  39.895  28.461  1.00 33.07           C  
ATOM   1269  CD  GLN   154      16.043  39.367  29.699  1.00 37.37           C  
ATOM   1270  OE1 GLN   154      16.550  39.443  30.823  1.00 39.46           O  
ATOM   1271  NE2 GLN   154      14.846  38.807  29.487  1.00 40.42           N  
ATOM   1272  N   LYS   155      15.587  44.612  27.785  1.00 34.64           N  
ATOM   1273  CA  LYS   155      15.755  46.085  27.881  1.00 36.26           C  
ATOM   1274  C   LYS   155      14.446  46.864  28.024  1.00 36.17           C  
ATOM   1275  O   LYS   155      13.360  46.298  28.201  1.00 37.58           O  
ATOM   1276  CB  LYS   155      16.523  46.682  26.678  1.00 36.32           C  
ATOM   1277  CG  LYS   155      17.355  45.733  25.836  1.00 39.40           C  
ATOM   1278  CD  LYS   155      18.806  45.627  26.267  1.00 40.09           C  
ATOM   1279  CE  LYS   155      19.565  44.727  25.301  1.00 43.03           C  
ATOM   1280  NZ  LYS   155      19.928  45.384  24.002  1.00 43.48           N  
ATOM   1281  N   ASN   165      12.474  55.446  15.912  1.00 41.07           N  
ATOM   1282  CA  ASN   165      12.786  56.233  14.721  1.00 40.86           C  
ATOM   1283  C   ASN   165      14.225  56.117  14.260  1.00 39.46           C  
ATOM   1284  O   ASN   165      14.474  55.926  13.065  1.00 39.76           O  
ATOM   1285  CB  ASN   165      12.495  57.726  14.953  1.00 41.56           C  
ATOM   1286  CG  ASN   165      11.019  58.026  15.088  1.00 43.79           C  
ATOM   1287  OD1 ASN   165      10.175  57.371  14.470  1.00 47.63           O  
ATOM   1288  ND2 ASN   165      10.696  59.042  15.885  1.00 46.17           N  
ATOM   1289  N   CYS   166      15.149  56.242  15.216  1.00 37.98           N  
ATOM   1290  CA  CYS   166      16.580  56.379  14.945  0.50 36.88           C  
ATOM   1292  C   CYS   166      17.170  55.327  13.986  1.00 36.05           C  
ATOM   1293  O   CYS   166      17.921  55.653  13.041  1.00 35.95           O  
ATOM   1294  CB  CYS   166      17.329  56.360  16.274  0.50 37.09           C  
ATOM   1296  SG  CYS   166      19.092  56.519  16.131  0.50 38.12           S  
ATOM   1298  N   LEU   167      16.844  54.063  14.232  1.00 33.59           N  
ATOM   1299  CA  LEU   167      17.349  52.984  13.376  1.00 30.89           C  
ATOM   1300  C   LEU   167      16.723  53.022  11.973  1.00 29.85           C  
ATOM   1301  O   LEU   167      17.438  52.862  10.974  1.00 28.15           O  
ATOM   1302  CB  LEU   167      17.144  51.623  14.043  1.00 29.90           C  
ATOM   1303  CG  LEU   167      17.722  51.341  15.434  1.00 29.69           C  
ATOM   1304  CD1 LEU   167      17.442  49.901  15.841  1.00 27.15           C  
ATOM   1305  CD2 LEU   167      19.210  51.625  15.503  1.00 27.72           C  
ATOM   1306  N   GLU   168      15.405  53.265  11.905  1.00 28.65           N  
ATOM   1307  CA  GLU   168      14.659  53.300  10.634  1.00 28.93           C  
ATOM   1308  C   GLU   168      15.057  54.494   9.758  1.00 27.44           C  
ATOM   1309  O   GLU   168      15.255  54.348   8.551  1.00 27.06           O  
ATOM   1310  CB  GLU   168      13.141  53.301  10.891  1.00 29.00           C  
ATOM   1311  CG  GLU   168      12.255  53.014   9.660  1.00 30.98           C  
ATOM   1312  CD  GLU   168      10.935  52.292  10.007  1.00 32.01           C  
ATOM   1313  OE1 GLU   168      10.464  52.369  11.172  1.00 35.69           O  
ATOM   1314  OE2 GLU   168      10.375  51.617   9.112  1.00 36.97           O  
ATOM   1315  N   THR   169      15.176  55.673  10.373  1.00 27.30           N  
ATOM   1316  CA  THR   169      15.520  56.891   9.635  1.00 27.25           C  
ATOM   1317  C   THR   169      16.842  56.760   8.882  1.00 26.37           C  
ATOM   1318  O   THR   169      16.923  57.137   7.709  1.00 26.91           O  
ATOM   1319  CB  THR   169      15.510  58.168  10.544  1.00 27.66           C  
ATOM   1320  OG1 THR   169      16.549  58.072  11.523  1.00 29.75           O  
ATOM   1321  CG2 THR   169      14.185  58.297  11.260  1.00 27.52           C  
ATOM   1322  N   SER   170      17.848  56.182   9.535  1.00 26.61           N  
ATOM   1323  CA  SER   170      19.174  56.002   8.917  1.00 26.93           C  
ATOM   1324  C   SER   170      19.123  55.010   7.750  1.00 26.69           C  
ATOM   1325  O   SER   170      19.792  55.208   6.740  1.00 27.67           O  
ATOM   1326  CB  SER   170      20.248  55.639   9.958  1.00 27.25           C  
ATOM   1327  OG  SER   170      20.071  54.353  10.510  1.00 28.32           O  
ATOM   1328  N   LEU   171      18.305  53.966   7.868  1.00 26.17           N  
ATOM   1329  CA  LEU   171      18.040  53.090   6.720  1.00 25.72           C  
ATOM   1330  C   LEU   171      17.287  53.802   5.580  1.00 26.04           C  
ATOM   1331  O   LEU   171      17.639  53.648   4.407  1.00 25.52           O  
ATOM   1332  CB  LEU   171      17.298  51.821   7.156  1.00 25.40           C  
ATOM   1333  CG  LEU   171      18.092  50.830   8.015  1.00 24.74           C  
ATOM   1334  CD1 LEU   171      17.136  49.817   8.632  1.00 23.70           C  
ATOM   1335  CD2 LEU   171      19.200  50.144   7.186  1.00 22.15           C  
ATOM   1336  N   ALA   172      16.256  54.588   5.927  1.00 26.86           N  
ATOM   1337  CA  ALA   172      15.388  55.251   4.933  1.00 27.07           C  
ATOM   1338  C   ALA   172      16.132  56.273   4.070  1.00 27.99           C  
ATOM   1339  O   ALA   172      15.687  56.601   2.959  1.00 28.28           O  
ATOM   1340  CB  ALA   172      14.173  55.917   5.628  1.00 26.59           C  
ATOM   1341  N   GLU   173      17.268  56.735   4.592  1.00 28.87           N  
ATOM   1342  CA  GLU   173      18.192  57.649   3.923  1.00 31.20           C  
ATOM   1343  C   GLU   173      18.737  57.100   2.610  1.00 30.70           C  
ATOM   1344  O   GLU   173      19.006  57.862   1.683  1.00 30.82           O  
ATOM   1345  CB  GLU   173      19.397  57.907   4.827  1.00 31.14           C  
ATOM   1346  CG  GLU   173      19.240  59.056   5.812  1.00 33.97           C  
ATOM   1347  CD  GLU   173      20.443  59.217   6.735  1.00 34.81           C  
ATOM   1348  OE1 GLU   173      21.599  58.949   6.305  1.00 37.15           O  
ATOM   1349  OE2 GLU   173      20.223  59.620   7.912  1.00 40.87           O  
ATOM   1350  N   ILE   174      18.937  55.779   2.550  1.00 29.59           N  
ATOM   1351  CA  ILE   174      19.664  55.177   1.444  1.00 28.75           C  
ATOM   1352  C   ILE   174      18.945  53.993   0.816  1.00 27.96           C  
ATOM   1353  O   ILE   174      19.270  53.604  -0.303  1.00 28.16           O  
ATOM   1354  CB  ILE   174      21.095  54.747   1.855  1.00 28.85           C  
ATOM   1355  CG1 ILE   174      21.047  53.714   2.996  1.00 28.35           C  
ATOM   1356  CG2 ILE   174      21.951  55.980   2.220  1.00 28.66           C  
ATOM   1357  CD1 ILE   174      22.382  53.050   3.268  1.00 28.84           C  
ATOM   1358  N   PHE   175      17.976  53.438   1.545  1.00 27.25           N  
ATOM   1359  CA  PHE   175      17.154  52.313   1.089  1.00 27.16           C  
ATOM   1360  C   PHE   175      15.712  52.748   0.844  1.00 27.96           C  
ATOM   1361  O   PHE   175      15.198  53.589   1.591  1.00 28.32           O  
ATOM   1362  CB  PHE   175      17.148  51.197   2.138  1.00 25.39           C  
ATOM   1363  CG  PHE   175      18.448  50.476   2.254  1.00 25.02           C  
ATOM   1364  CD1 PHE   175      19.000  49.831   1.144  1.00 22.62           C  
ATOM   1365  CD2 PHE   175      19.138  50.455   3.463  1.00 23.11           C  
ATOM   1366  CE1 PHE   175      20.233  49.168   1.253  1.00 22.60           C  
ATOM   1367  CE2 PHE   175      20.371  49.793   3.582  1.00 23.59           C  
ATOM   1368  CZ  PHE   175      20.907  49.145   2.472  1.00 22.09           C  
ATOM   1369  N   PRO   176      15.042  52.144  -0.159  1.00 28.92           N  
ATOM   1370  CA  PRO   176      13.659  52.519  -0.523  1.00 29.85           C  
ATOM   1371  C   PRO   176      12.546  52.111   0.472  1.00 30.23           C  
ATOM   1372  O   PRO   176      11.619  51.369   0.120  1.00 29.89           O  
ATOM   1373  CB  PRO   176      13.460  51.839  -1.879  1.00 29.67           C  
ATOM   1374  CG  PRO   176      14.364  50.658  -1.842  1.00 29.69           C  
ATOM   1375  CD  PRO   176      15.559  51.076  -1.037  1.00 29.70           C  
ATOM   1376  N   LEU   177      12.649  52.594   1.702  1.00 31.32           N  
ATOM   1377  CA  LEU   177      11.584  52.454   2.669  1.00 32.99           C  
ATOM   1378  C   LEU   177      10.558  53.566   2.434  1.00 34.01           C  
ATOM   1379  O   LEU   177       9.364  53.292   2.296  1.00 35.48           O  
ATOM   1380  CB  LEU   177      12.135  52.570   4.085  1.00 33.09           C  
ATOM   1381  CG  LEU   177      12.901  51.402   4.709  1.00 33.87           C  
ATOM   1382  CD1 LEU   177      13.626  51.910   5.929  1.00 35.29           C  
ATOM   1383  CD2 LEU   177      11.974  50.264   5.097  1.00 34.86           C  
ATOM   1384  N   ILE   191       3.939  49.630  13.570  1.00 39.51           N  
ATOM   1385  CA  ILE   191       3.880  50.674  14.609  1.00 39.47           C  
ATOM   1386  C   ILE   191       5.049  50.664  15.620  1.00 38.14           C  
ATOM   1387  O   ILE   191       5.580  51.740  15.924  1.00 37.87           O  
ATOM   1388  CB  ILE   191       2.462  50.789  15.328  1.00 39.29           C  
ATOM   1389  CG1 ILE   191       2.433  51.996  16.290  1.00 40.74           C  
ATOM   1390  CG2 ILE   191       2.038  49.463  16.001  1.00 40.80           C  
ATOM   1391  CD1 ILE   191       1.296  52.006  17.340  1.00 40.39           C  
ATOM   1392  N   PRO   192       5.482  49.463  16.109  1.00 37.22           N  
ATOM   1393  CA  PRO   192       6.645  49.479  17.014  1.00 35.79           C  
ATOM   1394  C   PRO   192       7.866  50.047  16.289  1.00 34.05           C  
ATOM   1395  O   PRO   192       8.092  49.699  15.126  1.00 34.00           O  
ATOM   1396  CB  PRO   192       6.894  47.986  17.313  1.00 35.96           C  
ATOM   1397  CG  PRO   192       5.638  47.306  17.007  1.00 36.88           C  
ATOM   1398  CD  PRO   192       5.026  48.079  15.861  1.00 37.57           C  
ATOM   1399  N   GLY   193       8.628  50.919  16.953  1.00 32.00           N  
ATOM   1400  CA  GLY   193       9.924  51.376  16.415  1.00 29.30           C  
ATOM   1401  C   GLY   193      10.830  50.158  16.267  1.00 26.86           C  
ATOM   1402  O   GLY   193      10.654  49.181  16.991  1.00 27.57           O  
ATOM   1403  N   LEU   194      11.785  50.196  15.335  1.00 25.02           N  
ATOM   1404  CA  LEU   194      12.666  49.029  15.119  1.00 22.05           C  
ATOM   1405  C   LEU   194      13.431  48.669  16.374  1.00 21.47           C  
ATOM   1406  O   LEU   194      14.097  49.519  16.968  1.00 20.52           O  
ATOM   1407  CB  LEU   194      13.667  49.268  13.981  1.00 22.03           C  
ATOM   1408  CG  LEU   194      13.115  49.448  12.567  1.00 21.92           C  
ATOM   1409  CD1 LEU   194      14.218  49.717  11.554  1.00 21.24           C  
ATOM   1410  CD2 LEU   194      12.268  48.216  12.181  1.00 19.60           C  
ATOM   1411  N   ALA   195      13.359  47.408  16.768  1.00 19.34           N  
ATOM   1412  CA  ALA   195      14.067  46.936  17.943  1.00 18.73           C  
ATOM   1413  C   ALA   195      15.570  46.801  17.690  1.00 18.18           C  
ATOM   1414  O   ALA   195      16.388  46.907  18.607  1.00 18.05           O  
ATOM   1415  CB  ALA   195      13.484  45.595  18.409  1.00 18.89           C  
ATOM   1416  N   ALA   196      15.917  46.565  16.437  1.00 16.89           N  
ATOM   1417  CA  ALA   196      17.301  46.288  16.039  1.00 15.01           C  
ATOM   1418  C   ALA   196      17.445  46.486  14.517  1.00 14.33           C  
ATOM   1419  O   ALA   196      16.454  46.568  13.795  1.00 13.96           O  
ATOM   1420  CB  ALA   196      17.727  44.886  16.457  1.00 15.92           C  
ATOM   1421  N   SER   197      18.707  46.610  14.069  1.00 13.64           N  
ATOM   1422  CA  SER   197      19.075  46.758  12.665  1.00 13.45           C  
ATOM   1423  C   SER   197      20.336  45.904  12.511  1.00 13.46           C  
ATOM   1424  O   SER   197      21.446  46.289  12.920  1.00 13.37           O  
ATOM   1425  CB  SER   197      19.358  48.221  12.305  1.00 13.58           C  
ATOM   1426  OG  SER   197      19.622  48.367  10.900  1.00 14.68           O  
ATOM   1427  N   VAL   198      20.138  44.726  11.921  1.00 13.15           N  
ATOM   1428  CA  VAL   198      21.175  43.684  11.893  1.00 13.08           C  
ATOM   1429  C   VAL   198      21.837  43.708  10.520  1.00 13.08           C  
ATOM   1430  O   VAL   198      21.150  43.812   9.488  1.00 13.79           O  
ATOM   1431  CB  VAL   198      20.539  42.297  12.111  1.00 12.94           C  
ATOM   1432  CG1 VAL   198      21.583  41.206  11.969  1.00 13.89           C  
ATOM   1433  CG2 VAL   198      19.785  42.182  13.457  1.00 12.57           C  
ATOM   1434  N   LEU   199      23.165  43.640  10.519  1.00 12.11           N  
ATOM   1435  CA  LEU   199      23.944  43.552   9.280  1.00 11.62           C  
ATOM   1436  C   LEU   199      24.484  42.142   9.161  1.00 11.23           C  
ATOM   1437  O   LEU   199      25.156  41.672  10.058  1.00 11.71           O  
ATOM   1438  CB  LEU   199      25.143  44.520   9.306  1.00 12.31           C  
ATOM   1439  CG  LEU   199      26.104  44.482   8.086  1.00 11.66           C  
ATOM   1440  CD1 LEU   199      25.454  44.717   6.697  1.00 13.39           C  
ATOM   1441  CD2 LEU   199      27.300  45.506   8.317  1.00 12.95           C  
ATOM   1442  N   VAL   200      24.258  41.507   8.006  1.00 10.78           N  
ATOM   1443  CA  VAL   200      24.776  40.120   7.811  1.00  8.76           C  
ATOM   1444  C   VAL   200      25.585  40.101   6.520  1.00  9.38           C  
ATOM   1445  O   VAL   200      25.108  40.550   5.475  1.00 10.10           O  
ATOM   1446  CB  VAL   200      23.609  39.072   7.698  1.00  8.66           C  
ATOM   1447  CG1 VAL   200      24.164  37.703   7.228  1.00  8.33           C  
ATOM   1448  CG2 VAL   200      22.846  38.947   9.017  1.00 10.38           C  
ATOM   1449  N   VAL   201      26.812  39.596   6.594  1.00  9.43           N  
ATOM   1450  CA  VAL   201      27.621  39.452   5.399  1.00  8.97           C  
ATOM   1451  C   VAL   201      27.796  37.959   5.116  1.00  9.62           C  
ATOM   1452  O   VAL   201      28.275  37.211   5.968  1.00  7.86           O  
ATOM   1453  CB  VAL   201      28.996  40.116   5.547  1.00  9.59           C  
ATOM   1454  CG1 VAL   201      29.874  39.759   4.306  1.00  9.68           C  
ATOM   1455  CG2 VAL   201      28.800  41.646   5.700  1.00 11.12           C  
ATOM   1456  N   SER   202      27.426  37.544   3.899  1.00  9.31           N  
ATOM   1457  CA  SER   202      27.409  36.101   3.605  1.00  8.95           C  
ATOM   1458  C   SER   202      27.682  35.867   2.128  1.00  9.16           C  
ATOM   1459  O   SER   202      28.438  36.636   1.488  1.00 10.38           O  
ATOM   1460  CB  SER   202      26.058  35.492   4.096  1.00  8.93           C  
ATOM   1461  OG  SER   202      25.903  34.092   3.831  1.00 10.01           O  
ATOM   1462  N   HIS   203      27.061  34.814   1.570  1.00 10.13           N  
ATOM   1463  CA  HIS   203      27.535  34.249   0.316  1.00  9.52           C  
ATOM   1464  C   HIS   203      26.367  34.086  -0.635  1.00 10.30           C  
ATOM   1465  O   HIS   203      25.216  33.917  -0.171  1.00  9.32           O  
ATOM   1466  CB  HIS   203      28.166  32.852   0.589  1.00  9.59           C  
ATOM   1467  CG  HIS   203      29.341  32.879   1.531  1.00  7.84           C  
ATOM   1468  ND1 HIS   203      30.649  32.959   1.093  1.00  9.11           N  
ATOM   1469  CD2 HIS   203      29.401  32.780   2.882  1.00 10.71           C  
ATOM   1470  CE1 HIS   203      31.465  32.895   2.139  1.00  9.53           C  
ATOM   1471  NE2 HIS   203      30.731  32.788   3.237  1.00  8.48           N  
ATOM   1472  N   GLY   204      26.642  34.041  -1.948  1.00  9.69           N  
ATOM   1473  CA  GLY   204      25.503  34.073  -2.911  1.00  9.75           C  
ATOM   1474  C   GLY   204      24.522  32.906  -2.808  1.00  9.54           C  
ATOM   1475  O   GLY   204      23.329  33.126  -2.661  1.00  9.85           O  
ATOM   1476  N   ALA   205      25.014  31.678  -2.814  1.00  9.62           N  
ATOM   1477  CA  ALA   205      24.075  30.533  -2.842  1.00  8.60           C  
ATOM   1478  C   ALA   205      23.305  30.459  -1.523  1.00  9.84           C  
ATOM   1479  O   ALA   205      22.099  30.182  -1.506  1.00  9.20           O  
ATOM   1480  CB  ALA   205      24.798  29.203  -3.200  1.00 11.04           C  
ATOM   1481  N   TYR   206      24.010  30.687  -0.419  1.00  8.72           N  
ATOM   1482  CA  TYR   206      23.350  30.676   0.884  1.00  8.73           C  
ATOM   1483  C   TYR   206      22.268  31.735   0.959  1.00  8.56           C  
ATOM   1484  O   TYR   206      21.148  31.498   1.465  1.00  8.88           O  
ATOM   1485  CB  TYR   206      24.384  30.938   1.962  1.00  7.66           C  
ATOM   1486  CG  TYR   206      23.785  30.956   3.365  1.00  9.51           C  
ATOM   1487  CD1 TYR   206      23.564  29.772   4.063  1.00  7.24           C  
ATOM   1488  CD2 TYR   206      23.374  32.155   3.961  1.00 10.79           C  
ATOM   1489  CE1 TYR   206      23.034  29.805   5.359  1.00 10.51           C  
ATOM   1490  CE2 TYR   206      22.854  32.198   5.246  1.00 11.50           C  
ATOM   1491  CZ  TYR   206      22.699  31.025   5.941  1.00 10.75           C  
ATOM   1492  OH  TYR   206      22.157  31.087   7.208  1.00 10.83           O  
ATOM   1493  N   MET   207      22.618  32.922   0.472  1.00  7.25           N  
ATOM   1494  CA  MET   207      21.640  34.024   0.460  1.00  9.04           C  
ATOM   1495  C   MET   207      20.403  33.663  -0.376  1.00  8.99           C  
ATOM   1496  O   MET   207      19.240  33.915   0.050  1.00 11.12           O  
ATOM   1497  CB  MET   207      22.287  35.307   0.016  1.00  8.31           C  
ATOM   1498  CG  MET   207      23.162  35.904   1.145  1.00  8.70           C  
ATOM   1499  SD  MET   207      24.421  37.241   0.441  1.00 11.06          SE  
ATOM   1500  CE  MET   207      23.098  38.585  -0.024  1.00 13.46           C  
ATOM   1501  N   ARG   208      20.636  33.083  -1.535  1.00 10.61           N  
ATOM   1502  CA  ARG   208      19.503  32.741  -2.425  1.00  9.90           C  
ATOM   1503  C   ARG   208      18.536  31.785  -1.713  1.00 11.11           C  
ATOM   1504  O   ARG   208      17.295  31.938  -1.782  1.00 11.37           O  
ATOM   1505  CB  ARG   208      20.015  32.179  -3.743  1.00 12.27           C  
ATOM   1506  CG  ARG   208      20.585  33.343  -4.610  1.00 15.78           C  
ATOM   1507  CD  ARG   208      20.941  32.873  -6.042  1.00 16.42           C  
ATOM   1508  NE  ARG   208      22.040  31.918  -6.103  1.00 17.26           N  
ATOM   1509  CZ  ARG   208      23.330  32.252  -6.152  1.00 16.45           C  
ATOM   1510  NH1 ARG   208      23.690  33.522  -6.102  1.00 17.32           N  
ATOM   1511  NH2 ARG   208      24.268  31.307  -6.225  1.00 17.91           N  
ATOM   1512  N   SER   209      19.091  30.845  -0.973  1.00  9.56           N  
ATOM   1513  CA  SER   209      18.271  29.853  -0.265  1.00 10.25           C  
ATOM   1514  C   SER   209      17.548  30.490   0.896  1.00 10.33           C  
ATOM   1515  O   SER   209      16.381  30.164   1.185  1.00 11.28           O  
ATOM   1516  CB  SER   209      19.144  28.705   0.232  1.00 11.33           C  
ATOM   1517  OG  SER   209      19.516  27.853  -0.832  1.00 13.34           O  
ATOM   1518  N   LEU   210      18.242  31.401   1.590  1.00 10.38           N  
ATOM   1519  CA  LEU   210      17.569  32.130   2.698  1.00  8.87           C  
ATOM   1520  C   LEU   210      16.428  32.977   2.120  1.00  9.51           C  
ATOM   1521  O   LEU   210      15.323  32.988   2.670  1.00  9.92           O  
ATOM   1522  CB  LEU   210      18.623  32.968   3.434  1.00  9.32           C  
ATOM   1523  CG  LEU   210      18.048  33.840   4.556  1.00  9.09           C  
ATOM   1524  CD1 LEU   210      17.590  32.951   5.718  1.00 10.71           C  
ATOM   1525  CD2 LEU   210      19.140  34.878   5.001  1.00 10.89           C  
ATOM   1526  N   PHE   211      16.667  33.630   0.980  1.00  9.30           N  
ATOM   1527  CA  PHE   211      15.672  34.526   0.423  1.00 10.50           C  
ATOM   1528  C   PHE   211      14.498  33.663  -0.069  1.00  9.99           C  
ATOM   1529  O   PHE   211      13.333  34.056   0.074  1.00  9.59           O  
ATOM   1530  CB  PHE   211      16.256  35.373  -0.710  1.00  9.65           C  
ATOM   1531  CG  PHE   211      17.358  36.303  -0.267  1.00 10.52           C  
ATOM   1532  CD1 PHE   211      17.539  36.610   1.083  1.00 11.62           C  
ATOM   1533  CD2 PHE   211      18.194  36.871  -1.203  1.00 14.73           C  
ATOM   1534  CE1 PHE   211      18.576  37.453   1.488  1.00 15.33           C  
ATOM   1535  CE2 PHE   211      19.217  37.745  -0.808  1.00 15.53           C  
ATOM   1536  CZ  PHE   211      19.387  38.034   0.550  1.00 13.13           C  
ATOM   1537  N   ASP   212      14.806  32.486  -0.590  1.00 10.28           N  
ATOM   1538  CA  ASP   212      13.733  31.557  -0.956  1.00 10.45           C  
ATOM   1539  C   ASP   212      12.895  31.125   0.242  1.00 10.32           C  
ATOM   1540  O   ASP   212      11.673  31.044   0.154  1.00  9.93           O  
ATOM   1541  CB  ASP   212      14.257  30.322  -1.670  1.00 11.35           C  
ATOM   1542  CG  ASP   212      13.113  29.499  -2.281  1.00 14.19           C  
ATOM   1543  OD1 ASP   212      12.306  30.036  -3.060  1.00 18.34           O  
ATOM   1544  OD2 ASP   212      12.958  28.348  -1.923  1.00 19.95           O  
ATOM   1545  N   TYR   213      13.533  30.877   1.375  1.00  9.34           N  
ATOM   1546  CA  TYR   213      12.773  30.636   2.621  1.00  9.28           C  
ATOM   1547  C   TYR   213      11.844  31.819   2.913  1.00 10.01           C  
ATOM   1548  O   TYR   213      10.654  31.633   3.166  1.00  9.71           O  
ATOM   1549  CB  TYR   213      13.741  30.430   3.765  1.00 10.44           C  
ATOM   1550  CG  TYR   213      13.072  30.316   5.104  1.00  9.68           C  
ATOM   1551  CD1 TYR   213      12.126  29.302   5.346  1.00 11.69           C  
ATOM   1552  CD2 TYR   213      13.423  31.187   6.162  1.00 11.29           C  
ATOM   1553  CE1 TYR   213      11.512  29.192   6.584  1.00 14.86           C  
ATOM   1554  CE2 TYR   213      12.818  31.065   7.378  1.00 12.39           C  
ATOM   1555  CZ  TYR   213      11.875  30.086   7.587  1.00 15.18           C  
ATOM   1556  OH  TYR   213      11.328  29.987   8.860  1.00 18.19           O  
ATOM   1557  N   PHE   214      12.362  33.044   2.825  1.00  9.20           N  
ATOM   1558  CA  PHE   214      11.530  34.208   3.131  1.00  9.42           C  
ATOM   1559  C   PHE   214      10.352  34.318   2.171  1.00 10.67           C  
ATOM   1560  O   PHE   214       9.267  34.633   2.596  1.00 10.12           O  
ATOM   1561  CB  PHE   214      12.333  35.500   3.002  1.00  9.95           C  
ATOM   1562  CG  PHE   214      13.394  35.690   4.060  1.00  8.70           C  
ATOM   1563  CD1 PHE   214      13.403  34.963   5.244  1.00  8.58           C  
ATOM   1564  CD2 PHE   214      14.387  36.661   3.852  1.00 10.59           C  
ATOM   1565  CE1 PHE   214      14.396  35.198   6.210  1.00 10.02           C  
ATOM   1566  CE2 PHE   214      15.386  36.898   4.808  1.00 10.61           C  
ATOM   1567  CZ  PHE   214      15.385  36.182   5.976  1.00 11.62           C  
ATOM   1568  N   LEU   215      10.583  34.056   0.879  1.00 10.25           N  
ATOM   1569  CA  LEU   215       9.506  34.231  -0.114  1.00 10.38           C  
ATOM   1570  C   LEU   215       8.566  33.038  -0.161  1.00 10.77           C  
ATOM   1571  O   LEU   215       7.339  33.174   0.017  1.00 11.28           O  
ATOM   1572  CB  LEU   215      10.121  34.485  -1.488  1.00 10.63           C  
ATOM   1573  CG  LEU   215       9.069  34.627  -2.612  1.00  9.43           C  
ATOM   1574  CD1 LEU   215       8.138  35.785  -2.313  1.00 12.74           C  
ATOM   1575  CD2 LEU   215       9.785  34.860  -3.967  1.00 12.27           C  
ATOM   1576  N   THR   216       9.131  31.865  -0.398  1.00 11.00           N  
ATOM   1577  CA  THR   216       8.307  30.671  -0.567  1.00 12.81           C  
ATOM   1578  C   THR   216       7.626  30.239   0.730  1.00 12.62           C  
ATOM   1579  O   THR   216       6.467  29.852   0.720  1.00 13.60           O  
ATOM   1580  CB  THR   216       9.152  29.534  -1.189  1.00 12.36           C  
ATOM   1581  OG1 THR   216       9.636  29.972  -2.460  1.00 14.69           O  
ATOM   1582  CG2 THR   216       8.319  28.262  -1.368  1.00 14.27           C  
ATOM   1583  N   ASP   217       8.359  30.285   1.847  1.00 13.20           N  
ATOM   1584  CA  ASP   217       7.882  29.746   3.104  1.00 12.92           C  
ATOM   1585  C   ASP   217       7.256  30.784   4.037  1.00 13.22           C  
ATOM   1586  O   ASP   217       6.143  30.582   4.550  1.00 15.48           O  
ATOM   1587  CB  ASP   217       9.011  28.934   3.761  1.00 13.79           C  
ATOM   1588  CG  ASP   217       9.519  27.832   2.822  1.00 16.22           C  
ATOM   1589  OD1 ASP   217       8.673  27.023   2.386  1.00 18.83           O  
ATOM   1590  OD2 ASP   217      10.702  27.797   2.466  1.00 15.17           O  
ATOM   1591  N   LEU   218       7.916  31.930   4.212  1.00 10.94           N  
ATOM   1592  CA  LEU   218       7.348  32.985   5.050  1.00 11.53           C  
ATOM   1593  C   LEU   218       6.392  33.937   4.297  1.00 11.62           C  
ATOM   1594  O   LEU   218       5.723  34.808   4.914  1.00 12.88           O  
ATOM   1595  CB  LEU   218       8.481  33.745   5.769  1.00 11.54           C  
ATOM   1596  CG  LEU   218       9.332  32.906   6.752  1.00 12.78           C  
ATOM   1597  CD1 LEU   218      10.272  33.818   7.514  1.00 12.03           C  
ATOM   1598  CD2 LEU   218       8.443  32.131   7.731  1.00 15.13           C  
ATOM   1599  N   LYS   219       6.339  33.766   2.979  1.00 11.24           N  
ATOM   1600  CA  LYS   219       5.419  34.528   2.134  1.00 12.22           C  
ATOM   1601  C   LYS   219       5.700  36.040   2.224  1.00 12.08           C  
ATOM   1602  O   LYS   219       4.752  36.851   2.263  1.00 12.49           O  
ATOM   1603  CB  LYS   219       3.949  34.225   2.515  1.00 14.45           C  
ATOM   1604  CG  LYS   219       3.542  32.732   2.601  1.00 17.85           C  
ATOM   1605  CD  LYS   219       3.793  31.984   1.282  1.00 19.35           C  
ATOM   1606  CE  LYS   219       3.347  30.499   1.371  1.00 22.17           C  
ATOM   1607  NZ  LYS   219       3.656  29.950   2.699  1.00 27.12           N  
ATOM   1608  N   CYS   220       7.000  36.404   2.185  1.00 11.26           N  
ATOM   1609  CA  CYS   220       7.395  37.824   2.261  0.80 11.17           C  
ATOM   1611  C   CYS   220       6.842  38.615   1.085  1.00 11.75           C  
ATOM   1612  O   CYS   220       6.593  38.082  -0.005  1.00 11.77           O  
ATOM   1613  CB  CYS   220       8.907  38.003   2.340  0.80 11.41           C  
ATOM   1615  SG  CYS   220       9.772  37.747   0.774  0.80 12.73           S  
ATOM   1617  N   SER   221       6.585  39.897   1.334  1.00 12.01           N  
ATOM   1618  CA  SER   221       6.150  40.778   0.265  1.00 13.09           C  
ATOM   1619  C   SER   221       7.377  41.226  -0.550  1.00 14.04           C  
ATOM   1620  O   SER   221       8.492  41.258  -0.029  1.00 14.60           O  
ATOM   1621  CB  SER   221       5.389  41.968   0.837  1.00 13.77           C  
ATOM   1622  OG  SER   221       6.180  42.739   1.729  1.00 13.35           O  
ATOM   1623  N   LEU   222       7.165  41.555  -1.822  1.00 15.54           N  
ATOM   1624  CA  LEU   222       8.265  41.947  -2.720  1.00 17.54           C  
ATOM   1625  C   LEU   222       7.970  43.329  -3.322  1.00 19.60           C  
ATOM   1626  O   LEU   222       6.825  43.619  -3.649  1.00 20.17           O  
ATOM   1627  CB  LEU   222       8.395  40.946  -3.869  1.00 17.61           C  
ATOM   1628  CG  LEU   222       8.783  39.513  -3.568  1.00 18.69           C  
ATOM   1629  CD1 LEU   222       8.813  38.720  -4.849  1.00 19.94           C  
ATOM   1630  CD2 LEU   222      10.141  39.432  -2.857  1.00 20.71           C  
ATOM   1631  N   PRO   223       9.006  44.170  -3.499  1.00 22.05           N  
ATOM   1632  CA  PRO   223       8.735  45.432  -4.199  1.00 23.24           C  
ATOM   1633  C   PRO   223       8.219  45.147  -5.644  1.00 24.73           C  
ATOM   1634  O   PRO   223       8.453  44.071  -6.172  1.00 23.36           O  
ATOM   1635  CB  PRO   223      10.102  46.129  -4.224  1.00 22.98           C  
ATOM   1636  CG  PRO   223      10.992  45.386  -3.256  1.00 23.58           C  
ATOM   1637  CD  PRO   223      10.414  43.998  -3.114  1.00 22.06           C  
ATOM   1638  N   ALA   224       7.538  46.118  -6.255  1.00 26.52           N  
ATOM   1639  CA  ALA   224       7.013  45.993  -7.628  1.00 27.20           C  
ATOM   1640  C   ALA   224       8.122  45.798  -8.679  1.00 27.32           C  
ATOM   1641  O   ALA   224       7.891  45.228  -9.744  1.00 27.65           O  
ATOM   1642  CB  ALA   224       6.187  47.210  -7.969  1.00 27.94           C  
ATOM   1643  N   THR   225       9.320  46.257  -8.349  1.00 27.06           N  
ATOM   1644  CA  THR   225      10.485  46.172  -9.227  1.00 27.45           C  
ATOM   1645  C   THR   225      11.260  44.855  -9.100  1.00 26.00           C  
ATOM   1646  O   THR   225      12.251  44.629  -9.804  1.00 26.66           O  
ATOM   1647  CB  THR   225      11.428  47.339  -8.900  1.00 28.46           C  
ATOM   1648  OG1 THR   225      11.377  47.607  -7.486  1.00 31.78           O  
ATOM   1649  CG2 THR   225      10.985  48.581  -9.650  1.00 30.14           C  
ATOM   1650  N   LEU   226      10.828  43.975  -8.199  1.00 23.06           N  
ATOM   1651  CA  LEU   226      11.565  42.749  -7.951  0.70 22.35           C  
ATOM   1653  C   LEU   226      10.794  41.516  -8.397  1.00 22.73           C  
ATOM   1654  O   LEU   226       9.766  41.165  -7.805  1.00 23.06           O  
ATOM   1655  CB  LEU   226      11.915  42.621  -6.462  0.70 22.21           C  
ATOM   1657  CG  LEU   226      12.645  41.357  -6.011  0.70 21.36           C  
ATOM   1659  CD1 LEU   226      14.027  41.305  -6.595  0.70 19.42           C  
ATOM   1661  CD2 LEU   226      12.727  41.337  -4.500  0.70 21.10           C  
ATOM   1663  N   SER   227      11.318  40.850  -9.417  1.00 21.25           N  
ATOM   1664  CA  SER   227      10.727  39.614  -9.908  1.00 20.51           C  
ATOM   1665  C   SER   227      11.064  38.461  -8.957  1.00 20.26           C  
ATOM   1666  O   SER   227      12.080  38.498  -8.239  1.00 19.13           O  
ATOM   1667  CB  SER   227      11.282  39.296 -11.304  1.00 20.26           C  
ATOM   1668  OG  SER   227      12.667  39.041 -11.219  1.00 20.10           O  
ATOM   1669  N   ARG   228      10.236  37.418  -8.960  1.00 20.07           N  
ATOM   1670  CA  ARG   228      10.622  36.175  -8.282  1.00 19.92           C  
ATOM   1671  C   ARG   228      11.911  35.579  -8.856  1.00 20.94           C  
ATOM   1672  O   ARG   228      12.730  35.000  -8.118  1.00 20.58           O  
ATOM   1673  CB  ARG   228       9.483  35.143  -8.344  1.00 19.92           C  
ATOM   1674  CG  ARG   228       8.135  35.696  -7.878  1.00 20.51           C  
ATOM   1675  CD  ARG   228       7.076  34.614  -7.959  1.00 21.49           C  
ATOM   1676  NE  ARG   228       7.084  33.695  -6.813  1.00 21.75           N  
ATOM   1677  CZ  ARG   228       6.488  33.960  -5.648  1.00 21.92           C  
ATOM   1678  NH1 ARG   228       6.549  33.053  -4.678  1.00 21.92           N  
ATOM   1679  NH2 ARG   228       5.858  35.129  -5.441  1.00 19.45           N  
ATOM   1680  N   SER   229      12.135  35.746 -10.171  1.00 20.25           N  
ATOM   1681  CA  SER   229      13.321  35.200 -10.798  1.00 20.93           C  
ATOM   1682  C   SER   229      14.635  35.825 -10.306  1.00 20.97           C  
ATOM   1683  O   SER   229      15.655  35.134 -10.249  1.00 20.98           O  
ATOM   1684  CB  SER   229      13.227  35.330 -12.319  1.00 21.06           C  
ATOM   1685  OG  SER   229      12.191  34.481 -12.787  1.00 21.93           O  
ATOM   1686  N   GLU   230      14.582  37.105  -9.951  1.00 21.77           N  
ATOM   1687  CA  GLU   230      15.745  37.842  -9.443  1.00 23.44           C  
ATOM   1688  C   GLU   230      16.241  37.121  -8.208  1.00 24.30           C  
ATOM   1689  O   GLU   230      17.427  36.822  -8.038  1.00 23.11           O  
ATOM   1690  CB  GLU   230      15.327  39.232  -8.986  1.00 24.88           C  
ATOM   1691  CG  GLU   230      16.446  39.964  -8.211  1.00 25.43           C  
ATOM   1692  CD  GLU   230      17.011  41.126  -8.957  1.00 26.89           C  
ATOM   1693  OE1 GLU   230      16.267  41.704  -9.768  1.00 24.08           O  
ATOM   1694  OE2 GLU   230      18.173  41.500  -8.684  1.00 27.40           O  
ATOM   1695  N   LEU   231      15.273  36.842  -7.355  1.00 24.65           N  
ATOM   1696  CA  LEU   231      15.505  36.472  -5.987  1.00 27.37           C  
ATOM   1697  C   LEU   231      16.227  35.128  -5.920  1.00 29.19           C  
ATOM   1698  O   LEU   231      17.116  34.926  -5.074  1.00 30.79           O  
ATOM   1699  CB  LEU   231      14.133  36.437  -5.258  1.00 26.15           C  
ATOM   1700  CG  LEU   231      14.103  35.965  -3.808  1.00 25.48           C  
ATOM   1701  CD1 LEU   231      13.097  36.817  -3.039  1.00 24.11           C  
ATOM   1702  CD2 LEU   231      13.722  34.484  -3.709  1.00 24.46           C  
ATOM   1703  N   MET   232      15.892  34.259  -6.869  1.00 31.30           N  
ATOM   1704  CA  MET   232      16.273  32.841  -6.802  0.50 32.60           C  
ATOM   1706  C   MET   232      17.579  32.519  -7.520  1.00 32.66           C  
ATOM   1707  O   MET   232      18.270  31.545  -7.156  1.00 33.58           O  
ATOM   1708  CB  MET   232      15.130  31.960  -7.316  0.50 32.48           C  
ATOM   1710  CG  MET   232      13.833  32.197  -6.556  0.50 33.23           C  
ATOM   1712  SD  MET   232      12.288  31.294  -7.301  0.50 34.88          SE  
ATOM   1714  CE  MET   232      12.824  29.439  -6.973  0.50 35.68           C  
ATOM   1716  N   SER   233      17.902  33.327  -8.515  1.00 32.34           N  
ATOM   1717  CA  SER   233      19.173  33.283  -9.197  1.00 32.73           C  
ATOM   1718  C   SER   233      19.526  34.735  -9.260  1.00 32.27           C  
ATOM   1719  O   SER   233      18.661  35.516  -9.653  1.00 33.00           O  
ATOM   1720  CB  SER   233      19.010  32.787 -10.617  1.00 33.04           C  
ATOM   1721  OG  SER   233      18.096  33.619 -11.336  1.00 37.07           O  
ATOM   1722  N   VAL   234      20.759  35.092  -8.861  1.00 30.11           N  
ATOM   1723  CA  VAL   234      21.353  36.417  -9.039  1.00 29.06           C  
ATOM   1724  C   VAL   234      21.759  36.972  -7.668  1.00 27.42           C  
ATOM   1725  O   VAL   234      20.861  37.292  -6.847  1.00 27.92           O  
ATOM   1726  CB  VAL   234      20.401  37.472  -9.761  1.00 30.12           C  
ATOM   1727  CG1 VAL   234      21.032  38.881  -9.755  1.00 32.18           C  
ATOM   1728  CG2 VAL   234      20.084  37.050 -11.177  1.00 30.59           C  
ATOM   1729  N   THR   235      23.084  37.044  -7.414  1.00 24.54           N  
ATOM   1730  CA  THR   235      23.611  37.828  -6.274  1.00 21.55           C  
ATOM   1731  C   THR   235      24.970  38.463  -6.580  1.00 20.36           C  
ATOM   1732  O   THR   235      25.994  37.787  -6.534  1.00 20.67           O  
ATOM   1733  CB  THR   235      23.793  36.967  -4.996  1.00 20.99           C  
ATOM   1734  OG1 THR   235      22.701  36.060  -4.860  1.00 21.81           O  
ATOM   1735  CG2 THR   235      23.909  37.893  -3.732  1.00 19.10           C  
ATOM   1736  N   PRO   236      24.994  39.767  -6.880  1.00 18.67           N  
ATOM   1737  CA  PRO   236      26.263  40.458  -7.209  1.00 17.30           C  
ATOM   1738  C   PRO   236      27.175  40.544  -5.981  1.00 16.11           C  
ATOM   1739  O   PRO   236      26.660  40.543  -4.861  1.00 15.24           O  
ATOM   1740  CB  PRO   236      25.813  41.883  -7.586  1.00 18.40           C  
ATOM   1741  CG  PRO   236      24.320  41.835  -7.742  1.00 19.11           C  
ATOM   1742  CD  PRO   236      23.824  40.662  -6.942  1.00 18.91           C  
ATOM   1743  N   ASN   237      28.495  40.623  -6.184  1.00 15.37           N  
ATOM   1744  CA  ASN   237      29.410  40.915  -5.067  1.00 14.60           C  
ATOM   1745  C   ASN   237      29.053  42.256  -4.406  1.00 13.70           C  
ATOM   1746  O   ASN   237      28.875  43.267  -5.093  1.00 15.31           O  
ATOM   1747  CB  ASN   237      30.871  40.917  -5.503  1.00 14.73           C  
ATOM   1748  CG  ASN   237      31.377  39.526  -5.865  1.00 15.52           C  
ATOM   1749  OD1 ASN   237      31.642  39.260  -7.037  1.00 19.53           O  
ATOM   1750  ND2 ASN   237      31.449  38.610  -4.870  1.00 14.35           N  
ATOM   1751  N   THR   238      28.974  42.244  -3.083  1.00 12.97           N  
ATOM   1752  CA  THR   238      28.441  43.358  -2.231  1.00 12.00           C  
ATOM   1753  C   THR   238      27.022  43.852  -2.533  1.00 13.36           C  
ATOM   1754  O   THR   238      26.633  44.940  -2.108  1.00 13.65           O  
ATOM   1755  CB  THR   238      29.436  44.556  -2.091  1.00 12.82           C  
ATOM   1756  OG1 THR   238      29.545  45.243  -3.343  1.00 14.76           O  
ATOM   1757  CG2 THR   238      30.807  44.035  -1.598  1.00 13.59           C  
ATOM   1758  N   GLY   239      26.268  43.034  -3.271  1.00 13.24           N  
ATOM   1759  CA  GLY   239      24.830  43.263  -3.519  1.00 13.93           C  
ATOM   1760  C   GLY   239      24.107  43.245  -2.182  1.00 13.74           C  
ATOM   1761  O   GLY   239      24.339  42.340  -1.368  1.00 14.21           O  
ATOM   1762  N   MET   240      23.242  44.239  -1.966  1.00 12.78           N  
ATOM   1763  CA  MET   240      22.584  44.447  -0.685  1.00 13.58           C  
ATOM   1764  C   MET   240      21.069  44.208  -0.750  1.00 13.24           C  
ATOM   1765  O   MET   240      20.395  44.680  -1.660  1.00 13.69           O  
ATOM   1766  CB  MET   240      22.806  45.896  -0.220  1.00 15.11           C  
ATOM   1767  CG  MET   240      24.272  46.251  -0.086  1.00 15.12           C  
ATOM   1768  SD  MET   240      24.362  48.070   0.611  1.00 18.77          SE  
ATOM   1769  CE  MET   240      26.264  48.246   0.501  1.00 18.08           C  
ATOM   1770  N   SER   241      20.549  43.509   0.255  1.00 13.14           N  
ATOM   1771  CA  SER   241      19.119  43.255   0.356  0.70 12.52           C  
ATOM   1773  C   SER   241      18.692  43.676   1.746  1.00 13.29           C  
ATOM   1774  O   SER   241      19.403  43.434   2.713  1.00 14.20           O  
ATOM   1775  CB  SER   241      18.850  41.760   0.131  0.70 12.45           C  
ATOM   1777  OG  SER   241      19.292  41.387  -1.161  0.70 10.80           O  
ATOM   1779  N   LEU   242      17.529  44.328   1.846  1.00 12.23           N  
ATOM   1780  CA  LEU   242      16.979  44.770   3.117  1.00 12.90           C  
ATOM   1781  C   LEU   242      15.586  44.170   3.282  1.00 11.83           C  
ATOM   1782  O   LEU   242      14.755  44.272   2.345  1.00 12.05           O  
ATOM   1783  CB  LEU   242      16.875  46.318   3.160  1.00 13.04           C  
ATOM   1784  CG  LEU   242      16.191  46.884   4.429  1.00 15.99           C  
ATOM   1785  CD1 LEU   242      16.974  46.593   5.720  1.00 15.29           C  
ATOM   1786  CD2 LEU   242      16.016  48.428   4.269  1.00 14.21           C  
ATOM   1787  N   PHE   243      15.361  43.622   4.482  1.00 11.67           N  
ATOM   1788  CA  PHE   243      14.080  43.045   4.930  1.00 12.76           C  
ATOM   1789  C   PHE   243      13.642  43.680   6.256  1.00 12.46           C  
ATOM   1790  O   PHE   243      14.480  43.930   7.155  1.00 12.87           O  
ATOM   1791  CB  PHE   243      14.219  41.532   5.128  1.00 12.81           C  
ATOM   1792  CG  PHE   243      14.701  40.822   3.892  1.00 13.64           C  
ATOM   1793  CD1 PHE   243      13.810  40.355   2.948  1.00 14.82           C  
ATOM   1794  CD2 PHE   243      16.068  40.676   3.672  1.00 15.31           C  
ATOM   1795  CE1 PHE   243      14.283  39.710   1.748  1.00 14.92           C  
ATOM   1796  CE2 PHE   243      16.548  40.066   2.540  1.00 12.18           C  
ATOM   1797  CZ  PHE   243      15.672  39.588   1.565  1.00 10.84           C  
ATOM   1798  N   ILE   244      12.335  43.896   6.398  1.00 12.62           N  
ATOM   1799  CA  ILE   244      11.789  44.211   7.698  1.00 12.69           C  
ATOM   1800  C   ILE   244      11.060  42.959   8.227  1.00 11.90           C  
ATOM   1801  O   ILE   244      10.181  42.396   7.558  1.00 12.22           O  
ATOM   1802  CB  ILE   244      10.846  45.460   7.683  1.00 13.59           C  
ATOM   1803  CG1 ILE   244      11.553  46.710   7.095  1.00 16.20           C  
ATOM   1804  CG2 ILE   244      10.370  45.738   9.092  1.00 14.97           C  
ATOM   1805  CD1 ILE   244      12.795  47.147   7.862  1.00 19.67           C  
ATOM   1806  N   ILE   245      11.453  42.509   9.412  1.00 11.60           N  
ATOM   1807  CA  ILE   245      10.858  41.320  10.032  1.00 11.68           C  
ATOM   1808  C   ILE   245       9.879  41.784  11.105  1.00 13.67           C  
ATOM   1809  O   ILE   245      10.246  42.595  11.946  1.00 13.43           O  
ATOM   1810  CB  ILE   245      11.944  40.445  10.706  1.00 11.82           C  
ATOM   1811  CG1 ILE   245      13.184  40.245   9.781  1.00 12.57           C  
ATOM   1812  CG2 ILE   245      11.358  39.134  11.191  1.00 13.22           C  
ATOM   1813  CD1 ILE   245      12.849  39.659   8.365  1.00 14.11           C  
ATOM   1814  N   ASN   246       8.674  41.220  11.116  1.00 12.98           N  
ATOM   1815  CA  ASN   246       7.570  41.742  11.953  1.00 14.16           C  
ATOM   1816  C   ASN   246       6.988  40.612  12.804  1.00 14.34           C  
ATOM   1817  O   ASN   246       6.585  39.556  12.275  1.00 13.56           O  
ATOM   1818  CB  ASN   246       6.425  42.270  11.045  1.00 15.39           C  
ATOM   1819  CG  ASN   246       6.871  43.351  10.067  1.00 18.81           C  
ATOM   1820  OD1 ASN   246       7.381  43.092   8.938  1.00 23.58           O  
ATOM   1821  ND2 ASN   246       6.644  44.593  10.475  1.00 22.31           N  
ATOM   1822  N   PHE   247       6.923  40.822  14.127  1.00 15.67           N  
ATOM   1823  CA  PHE   247       6.282  39.853  14.997  1.00 16.23           C  
ATOM   1824  C   PHE   247       5.077  40.508  15.677  1.00 18.30           C  
ATOM   1825  O   PHE   247       5.220  41.540  16.320  1.00 17.11           O  
ATOM   1826  CB  PHE   247       7.234  39.383  16.116  1.00 17.45           C  
ATOM   1827  CG  PHE   247       8.305  38.430  15.667  1.00 16.77           C  
ATOM   1828  CD1 PHE   247       8.106  37.063  15.754  1.00 17.77           C  
ATOM   1829  CD2 PHE   247       9.519  38.909  15.190  1.00 19.72           C  
ATOM   1830  CE1 PHE   247       9.088  36.164  15.310  1.00 19.81           C  
ATOM   1831  CE2 PHE   247      10.509  38.024  14.758  1.00 17.22           C  
ATOM   1832  CZ  PHE   247      10.293  36.657  14.829  1.00 18.61           C  
ATOM   1833  N   GLU   248       3.923  39.876  15.551  1.00 19.35           N  
ATOM   1834  CA  GLU   248       2.781  40.197  16.416  1.00 22.23           C  
ATOM   1835  C   GLU   248       3.103  39.774  17.853  1.00 22.71           C  
ATOM   1836  O   GLU   248       4.013  38.979  18.080  1.00 20.96           O  
ATOM   1837  CB  GLU   248       1.532  39.491  15.889  1.00 22.61           C  
ATOM   1838  CG  GLU   248       0.932  40.248  14.695  1.00 25.01           C  
ATOM   1839  CD  GLU   248      -0.290  39.602  14.050  1.00 26.62           C  
ATOM   1840  OE1 GLU   248      -0.802  38.579  14.550  1.00 32.28           O  
ATOM   1841  OE2 GLU   248      -0.744  40.145  13.015  1.00 33.12           O  
ATOM   1842  N   GLU   249       2.374  40.335  18.822  1.00 24.15           N  
ATOM   1843  CA  GLU   249       2.566  39.933  20.207  1.00 26.26           C  
ATOM   1844  C   GLU   249       2.084  38.503  20.390  1.00 24.94           C  
ATOM   1845  O   GLU   249       1.216  38.006  19.641  1.00 24.12           O  
ATOM   1846  CB  GLU   249       1.843  40.888  21.148  1.00 25.98           C  
ATOM   1847  CG  GLU   249       0.531  40.375  21.742  1.00 31.22           C  
ATOM   1848  CD  GLU   249      -0.230  41.493  22.450  1.00 30.94           C  
ATOM   1849  OE1 GLU   249       0.432  42.430  22.991  1.00 38.11           O  
ATOM   1850  OE2 GLU   249      -1.481  41.457  22.429  1.00 37.68           O  
ATOM   1851  N   GLY   250       2.678  37.831  21.362  1.00 24.73           N  
ATOM   1852  CA  GLY   250       2.268  36.496  21.738  1.00 25.76           C  
ATOM   1853  C   GLY   250       3.414  35.552  21.992  1.00 25.75           C  
ATOM   1854  O   GLY   250       4.567  35.989  22.161  1.00 25.79           O  
ATOM   1855  N   ARG   251       3.088  34.256  22.015  1.00 26.24           N  
ATOM   1856  CA  ARG   251       4.046  33.166  22.217  1.00 27.25           C  
ATOM   1857  C   ARG   251       4.241  32.399  20.920  1.00 27.77           C  
ATOM   1858  O   ARG   251       3.263  32.141  20.216  1.00 28.46           O  
ATOM   1859  CB  ARG   251       3.515  32.186  23.283  1.00 27.24           C  
ATOM   1860  CG  ARG   251       3.140  32.856  24.591  1.00 28.49           C  
ATOM   1861  CD  ARG   251       2.561  31.859  25.640  1.00 28.57           C  
ATOM   1862  NE  ARG   251       1.780  32.587  26.639  1.00 33.40           N  
ATOM   1863  CZ  ARG   251       2.276  33.080  27.773  1.00 34.86           C  
ATOM   1864  NH1 ARG   251       3.558  32.901  28.084  1.00 34.71           N  
ATOM   1865  NH2 ARG   251       1.480  33.746  28.602  1.00 36.04           N  
ATOM   1866  N   GLU   252       5.493  32.042  20.616  1.00 27.82           N  
ATOM   1867  CA  GLU   252       5.857  31.247  19.428  1.00 28.91           C  
ATOM   1868  C   GLU   252       5.214  31.815  18.146  1.00 26.70           C  
ATOM   1869  O   GLU   252       4.576  31.089  17.373  1.00 27.41           O  
ATOM   1870  CB  GLU   252       5.455  29.774  19.617  1.00 28.85           C  
ATOM   1871  CG  GLU   252       6.465  28.782  19.055  1.00 32.65           C  
ATOM   1872  CD  GLU   252       6.321  27.363  19.621  1.00 32.84           C  
ATOM   1873  OE1 GLU   252       7.240  26.561  19.360  1.00 40.25           O  
ATOM   1874  OE2 GLU   252       5.302  27.029  20.290  1.00 38.53           O  
ATOM   1875  N   VAL   253       5.371  33.117  17.958  1.00 25.17           N  
ATOM   1876  CA  VAL   253       4.775  33.851  16.836  1.00 22.77           C  
ATOM   1877  C   VAL   253       5.595  33.691  15.556  1.00 21.79           C  
ATOM   1878  O   VAL   253       6.816  33.855  15.559  1.00 21.90           O  
ATOM   1879  CB  VAL   253       4.580  35.341  17.196  1.00 22.33           C  
ATOM   1880  CG1 VAL   253       4.074  36.171  15.993  1.00 21.72           C  
ATOM   1881  CG2 VAL   253       3.605  35.476  18.387  1.00 24.21           C  
ATOM   1882  N   LYS   254       4.895  33.354  14.475  1.00 20.12           N  
ATOM   1883  CA  LYS   254       5.478  33.286  13.146  1.00 18.03           C  
ATOM   1884  C   LYS   254       5.614  34.706  12.594  1.00 17.17           C  
ATOM   1885  O   LYS   254       4.621  35.404  12.471  1.00 16.18           O  
ATOM   1886  CB  LYS   254       4.570  32.497  12.207  1.00 19.08           C  
ATOM   1887  CG  LYS   254       5.238  32.176  10.891  1.00 19.33           C  
ATOM   1888  CD  LYS   254       4.260  31.439   9.948  1.00 26.85           C  
ATOM   1889  CE  LYS   254       4.926  31.017   8.656  1.00 30.92           C  
ATOM   1890  NZ  LYS   254       3.996  30.199   7.841  1.00 34.45           N  
ATOM   1891  N   PRO   255       6.841  35.118  12.235  1.00 15.86           N  
ATOM   1892  CA  PRO   255       6.987  36.492  11.743  1.00 14.73           C  
ATOM   1893  C   PRO   255       6.441  36.684  10.334  1.00 14.00           C  
ATOM   1894  O   PRO   255       6.259  35.704   9.594  1.00 15.12           O  
ATOM   1895  CB  PRO   255       8.517  36.704  11.706  1.00 14.51           C  
ATOM   1896  CG  PRO   255       9.068  35.329  11.521  1.00 15.15           C  
ATOM   1897  CD  PRO   255       8.117  34.382  12.249  1.00 16.49           C  
ATOM   1898  N   THR   256       6.163  37.928   9.982  1.00 13.78           N  
ATOM   1899  CA  THR   256       5.953  38.277   8.570  1.00 13.57           C  
ATOM   1900  C   THR   256       7.164  39.079   8.096  1.00 13.58           C  
ATOM   1901  O   THR   256       7.872  39.668   8.915  1.00 14.02           O  
ATOM   1902  CB  THR   256       4.658  39.061   8.380  1.00 13.94           C  
ATOM   1903  OG1 THR   256       4.633  40.216   9.244  1.00 15.02           O  
ATOM   1904  CG2 THR   256       3.466  38.145   8.671  1.00 14.83           C  
ATOM   1905  N   VAL   257       7.398  39.098   6.782  1.00 11.39           N  
ATOM   1906  CA  VAL   257       8.633  39.673   6.254  1.00 11.79           C  
ATOM   1907  C   VAL   257       8.275  40.582   5.067  1.00 12.49           C  
ATOM   1908  O   VAL   257       7.431  40.238   4.259  1.00 11.88           O  
ATOM   1909  CB  VAL   257       9.603  38.560   5.797  1.00 12.20           C  
ATOM   1910  CG1 VAL   257      10.891  39.173   5.158  1.00 12.84           C  
ATOM   1911  CG2 VAL   257       9.926  37.554   6.989  1.00 11.37           C  
ATOM   1912  N   GLN   258       8.886  41.761   5.028  1.00 12.80           N  
ATOM   1913  CA  GLN   258       8.757  42.676   3.898  1.00 14.83           C  
ATOM   1914  C   GLN   258      10.146  42.821   3.279  1.00 13.10           C  
ATOM   1915  O   GLN   258      11.081  43.235   3.951  1.00 13.61           O  
ATOM   1916  CB  GLN   258       8.279  44.066   4.374  1.00 15.18           C  
ATOM   1917  CG  GLN   258       6.887  44.059   4.975  1.00 18.60           C  
ATOM   1918  CD  GLN   258       6.563  45.334   5.754  1.00 21.61           C  
ATOM   1919  OE1 GLN   258       7.172  45.643   6.800  1.00 26.56           O  
ATOM   1920  NE2 GLN   258       5.584  46.086   5.239  1.00 28.76           N  
ATOM   1921  N   CYS   259      10.274  42.453   2.014  1.00 13.04           N  
ATOM   1922  CA  CYS   259      11.499  42.712   1.287  1.00 12.61           C  
ATOM   1923  C   CYS   259      11.459  44.148   0.753  1.00 13.03           C  
ATOM   1924  O   CYS   259      10.541  44.511  -0.009  1.00 14.63           O  
ATOM   1925  CB  CYS   259      11.669  41.726   0.144  1.00 13.09           C  
ATOM   1926  SG  CYS   259      13.167  42.105  -0.790  1.00 14.63           S  
ATOM   1927  N   ILE   260      12.415  44.952   1.191  1.00 13.62           N  
ATOM   1928  CA  ILE   260      12.519  46.388   0.817  1.00 14.08           C  
ATOM   1929  C   ILE   260      13.311  46.576  -0.486  1.00 15.41           C  
ATOM   1930  O   ILE   260      12.898  47.347  -1.378  1.00 15.09           O  
ATOM   1931  CB  ILE   260      13.128  47.246   1.960  1.00 14.59           C  
ATOM   1932  CG1 ILE   260      12.328  47.110   3.275  1.00 13.59           C  
ATOM   1933  CG2 ILE   260      13.302  48.705   1.519  1.00 15.12           C  
ATOM   1934  CD1 ILE   260      10.798  47.437   3.184  1.00 17.11           C  
ATOM   1935  N   CYS   261      14.436  45.867  -0.603  1.00 14.81           N  
ATOM   1936  CA  CYS   261      15.202  45.843  -1.858  1.00 15.96           C  
ATOM   1937  C   CYS   261      16.019  44.575  -1.893  1.00 16.00           C  
ATOM   1938  O   CYS   261      16.188  43.935  -0.853  1.00 16.30           O  
ATOM   1939  CB  CYS   261      16.111  47.071  -1.964  1.00 16.22           C  
ATOM   1940  SG  CYS   261      17.350  47.186  -0.680  1.00 20.19           S  
ATOM   1941  N   MET   262      16.475  44.188  -3.076  1.00 16.20           N  
ATOM   1942  CA  MET   262      17.340  43.008  -3.196  1.00 17.67           C  
ATOM   1943  C   MET   262      18.416  43.285  -4.214  1.00 17.67           C  
ATOM   1944  O   MET   262      18.147  43.915  -5.245  1.00 17.51           O  
ATOM   1945  CB  MET   262      16.526  41.772  -3.601  1.00 17.55           C  
ATOM   1946  CG  MET   262      17.351  40.476  -3.744  1.00 20.14           C  
ATOM   1947  SD  MET   262      16.188  38.954  -3.853  1.00 20.86          SE  
ATOM   1948  CE  MET   262      15.557  39.102  -2.039  1.00 21.38           C  
ATOM   1949  N   ASN   263      19.633  42.828  -3.916  1.00 16.44           N  
ATOM   1950  CA  ASN   263      20.752  42.967  -4.856  1.00 17.08           C  
ATOM   1951  C   ASN   263      21.022  44.425  -5.263  1.00 18.00           C  
ATOM   1952  O   ASN   263      21.442  44.694  -6.418  1.00 19.37           O  
ATOM   1953  CB  ASN   263      20.519  42.091  -6.092  1.00 16.01           C  
ATOM   1954  CG  ASN   263      20.470  40.618  -5.748  1.00 17.20           C  
ATOM   1955  OD1 ASN   263      21.136  40.190  -4.797  1.00 16.42           O  
ATOM   1956  ND2 ASN   263      19.749  39.824  -6.544  1.00 20.11           N  
ATOM   1957  N   LEU   264      20.781  45.343  -4.337  1.00 18.06           N  
ATOM   1958  CA  LEU   264      21.088  46.764  -4.563  1.00 20.40           C  
ATOM   1959  C   LEU   264      22.596  46.926  -4.814  1.00 21.29           C  
ATOM   1960  O   LEU   264      23.418  46.399  -4.050  1.00 20.30           O  
ATOM   1961  CB  LEU   264      20.687  47.612  -3.350  1.00 20.35           C  
ATOM   1962  CG  LEU   264      20.446  49.114  -3.581  1.00 23.12           C  
ATOM   1963  CD1 LEU   264      19.371  49.296  -4.670  1.00 24.12           C  
ATOM   1964  CD2 LEU   264      20.018  49.775  -2.298  1.00 21.83           C  
ATOM   1965  N   GLN   265      22.955  47.657  -5.874  1.00 22.67           N  
ATOM   1966  CA  GLN   265      24.380  47.952  -6.140  1.00 25.66           C  
ATOM   1967  C   GLN   265      24.668  49.436  -6.393  1.00 26.47           C  
ATOM   1968  O   GLN   265      25.604  49.743  -7.139  1.00 27.18           O  
ATOM   1969  CB  GLN   265      24.925  47.188  -7.351  1.00 25.38           C  
ATOM   1970  CG  GLN   265      24.243  45.906  -7.762  1.00 28.61           C  
ATOM   1971  CD  GLN   265      24.906  45.265  -8.962  1.00 28.26           C  
ATOM   1972  OE1 GLN   265      26.146  45.211  -9.065  1.00 33.40           O  
ATOM   1973  NE2 GLN   265      24.092  44.746  -9.872  1.00 33.70           N  
ATOM   1974  N   ASP   266      23.903  50.326  -5.753  1.00 28.13           N  
ATOM   1975  CA  ASP   266      24.028  51.794  -5.906  1.00 30.32           C  
ATOM   1976  C   ASP   266      25.391  52.326  -5.456  1.00 30.83           C  
ATOM   1977  O   ASP   266      25.838  53.402  -5.891  1.00 31.49           O  
ATOM   1978  CB  ASP   266      22.934  52.499  -5.094  1.00 30.71           C  
ATOM   1979  CG  ASP   266      21.547  52.313  -5.687  1.00 32.76           C  
ATOM   1980  OD1 ASP   266      21.434  51.819  -6.830  1.00 35.90           O  
ATOM   1981  OD2 ASP   266      20.569  52.687  -5.007  1.00 35.33           O  
ATOM   1982  N   HIS   267      26.040  51.590  -4.563  1.00 29.75           N  
ATOM   1983  CA  HIS   267      27.378  51.928  -4.124  1.00 29.59           C  
ATOM   1984  C   HIS   267      28.480  51.599  -5.154  1.00 30.49           C  
ATOM   1985  O   HIS   267      29.633  52.004  -4.962  1.00 31.58           O  
ATOM   1986  CB  HIS   267      27.657  51.216  -2.800  1.00 28.97           C  
ATOM   1987  CG  HIS   267      27.627  49.725  -2.912  1.00 24.06           C  
ATOM   1988  ND1 HIS   267      26.469  49.026  -3.188  1.00 22.05           N  
ATOM   1989  CD2 HIS   267      28.611  48.804  -2.805  1.00 21.74           C  
ATOM   1990  CE1 HIS   267      26.745  47.732  -3.246  1.00 20.69           C  
ATOM   1991  NE2 HIS   267      28.039  47.574  -3.021  1.00 19.76           N  
ATOM   1992  N   LEU   268      28.151  50.870  -6.222  1.00 31.07           N  
ATOM   1993  CA  LEU   268      29.165  50.394  -7.182  1.00 32.45           C  
ATOM   1994  C   LEU   268      29.296  51.186  -8.499  1.00 34.57           C  
ATOM   1995  O   LEU   268      30.254  50.978  -9.247  1.00 34.93           O  
ATOM   1996  CB  LEU   268      28.976  48.905  -7.512  1.00 31.83           C  
ATOM   1997  CG  LEU   268      29.246  47.899  -6.388  1.00 30.13           C  
ATOM   1998  CD1 LEU   268      29.144  46.464  -6.905  1.00 30.71           C  
ATOM   1999  CD2 LEU   268      30.618  48.155  -5.758  1.00 30.78           C  
ATOM   2000  N   ASN   269      28.346  52.062  -8.794  1.00 36.54           N  
ATOM   2001  CA  ASN   269      28.369  52.782 -10.078  1.00 38.57           C  
ATOM   2002  C   ASN   269      29.384  53.929 -10.094  1.00 39.07           C  
ATOM   2003  O   ASN   269      30.600  53.710  -9.978  1.00 39.36           O  
ATOM   2004  CB  ASN   269      26.960  53.264 -10.476  1.00 39.59           C  
ATOM   2005  CG  ASN   269      26.201  53.925  -9.316  1.00 41.98           C  
ATOM   2006  OD1 ASN   269      26.802  54.562  -8.435  1.00 44.75           O  
ATOM   2007  ND2 ASN   269      24.873  53.793  -9.327  1.00 44.56           N  
END
