
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  147 ( 1152),  selected  147 , name 2rfl_F
# Molecule2: number of CA atoms  247 ( 1945),  selected  247 , name T0394.pdb
# PARAMETERS: 2rfl_F.T0394.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      N       1           -
LGA    -       -      L       2           -
LGA    -       -      Y       3           -
LGA    -       -      F       4           -
LGA    -       -      Q       5           -
LGA    S     4_F      S       6           #
LGA    F     5_F      A       7          5.018
LGA    P     6_F      R       8           #
LGA    T     7_F      F       9          1.097
LGA    R     8_F      A      10          0.721
LGA    V     9_F      L      11          0.645
LGA    Y    10_F      T      12          0.971
LGA    L    11_F      V      13          0.925
LGA    L    12_F      V      14          1.087
LGA    R    13_F      R      15          0.973
LGA    H    14_F      H      16          0.930
LGA    A    15_F      G      17          0.897
LGA    K    16_F      E      18          0.924
LGA    A    17_F      T      19          0.661
LGA    A    18_F      R      20          1.155
LGA    -       -      F      21           -
LGA    -       -      N      22           -
LGA    -       -      K      23           -
LGA    -       -      E      24           -
LGA    -       -      K      25           -
LGA    -       -      I      26           -
LGA    -       -      I      27           -
LGA    -       -      Q      28           -
LGA    -       -      G      29           -
LGA    -       -      Q      30           -
LGA    D    26_F      G      31          3.563
LGA    F    27_F      V      32          3.757
LGA    D    28_F      D      33          2.106
LGA    R    29_F      E      34          0.562
LGA    G    30_F      P      35          0.777
LGA    L    31_F      L      36          0.713
LGA    N    32_F      S      37          0.794
LGA    E    33_F      E      38          1.081
LGA    A    34_F      T      39          0.902
LGA    G    35_F      G      40          0.854
LGA    F    36_F      F      41          0.534
LGA    A    37_F      K      42          0.937
LGA    E    38_F      Q      43          0.673
LGA    A    39_F      A      44          1.193
LGA    E    40_F      A      45          1.043
LGA    I    41_F      A      46          0.856
LGA    I    42_F      A      47          1.527
LGA    A    43_F      G      48          1.996
LGA    D    44_F      I      49          1.353
LGA    L    45_F      F      50          1.059
LGA    A    46_F      L      51          1.964
LGA    A    47_F      N      52          2.273
LGA    D    48_F      N      53          4.339
LGA    R    49_F      -       -           -
LGA    R    50_F      -       -           -
LGA    Y    51_F      V      54          3.585
LGA    R    52_F      K      55          3.365
LGA    P    53_F      F      56          2.584
LGA    D    54_F      T      57          1.504
LGA    L    55_F      H      58          1.460
LGA    I    56_F      A      59          1.448
LGA    L    57_F      F      60          1.427
LGA    S    58_F      S      61          0.904
LGA    S    59_F      S      62          0.832
LGA    T    60_F      D      63          1.155
LGA    A    61_F      L      64          0.957
LGA    A    62_F      M      65          0.990
LGA    R    63_F      R      66          0.578
LGA    C    64_F      T      67          0.627
LGA    R    65_F      K      68          0.834
LGA    Q    66_F      Q      69          0.561
LGA    T    67_F      T      70          0.526
LGA    T    68_F      M      71          0.711
LGA    Q    69_F      H      72          0.317
LGA    A    70_F      G      73          1.237
LGA    W    71_F      I      74          2.075
LGA    Q    72_F      L      75          1.810
LGA    R    73_F      E      76          0.771
LGA    A    74_F      R      77          1.903
LGA    F    75_F      S      78          1.958
LGA    -       -      K      79           -
LGA    -       -      F      80           -
LGA    -       -      C      81           -
LGA    -       -      K      82           -
LGA    G    78_F      D      83          3.513
LGA    I    79_F      M      84          2.156
LGA    D    80_F      T      85          2.880
LGA    I    81_F      V      86          0.787
LGA    V    82_F      K      87          0.851
LGA    Y    83_F      Y      88          0.972
LGA    I    84_F      D      89          1.640
LGA    D    85_F      S      90          2.644
LGA    E    86_F      R      91          3.755
LGA    X    87_F      L      92          2.604
LGA    Y    88_F      R      93          2.053
LGA    N    89_F      E      94          3.802
LGA    A    90_F      R      95           #
LGA    -       -      K      96           -
LGA    -       -      Y      97           -
LGA    -       -      G      98           -
LGA    -       -      V      99           -
LGA    -       -      V     100           -
LGA    -       -      E     101           -
LGA    -       -      G     102           -
LGA    -       -      K     103           -
LGA    -       -      A     104           -
LGA    -       -      L     105           -
LGA    -       -      S     106           -
LGA    -       -      E     107           -
LGA    -       -      L     108           -
LGA    -       -      R     109           -
LGA    -       -      A     110           -
LGA    -       -      M     111           -
LGA    -       -      A     112           -
LGA    -       -      K     113           -
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    -       -      R     116           -
LGA    -       -      E     117           -
LGA    -       -      E     118           -
LGA    -       -      C     119           -
LGA    -       -      P     120           -
LGA    -       -      V     121           -
LGA    -       -      F     122           -
LGA    -       -      T     123           -
LGA    -       -      P     124           -
LGA    -       -      P     125           -
LGA    -       -      G     126           -
LGA    -       -      G     127           -
LGA    -       -      E     128           -
LGA    -       -      T     129           -
LGA    -       -      L     130           -
LGA    -       -      D     131           -
LGA    R    91_F      Q     132          4.588
LGA    S    92_F      V     133          3.480
LGA    E    93_F      K     134          1.310
LGA    T    94_F      M     135          4.926
LGA    -       -      R     136           -
LGA    Y    95_F      G     137          2.007
LGA    L    96_F      I     138          3.275
LGA    S    97_F      D     139          3.176
LGA    L    98_F      F     140          2.018
LGA    I    99_F      F     141          3.097
LGA    A   100_F      E     142          3.225
LGA    A   101_F      F     143          2.350
LGA    Q   102_F      L     144          3.186
LGA    -       -      C     145           -
LGA    -       -      Q     146           -
LGA    -       -      L     147           -
LGA    -       -      I     148           -
LGA    T   103_F      L     149          2.703
LGA    -       -      K     150           -
LGA    E   104_F      E     151          2.053
LGA    V   105_F      A     152           #
LGA    -       -      D     153           -
LGA    -       -      Q     154           -
LGA    -       -      K     155           -
LGA    -       -      N     165           -
LGA    -       -      C     166           -
LGA    -       -      L     167           -
LGA    -       -      E     168           -
LGA    -       -      T     169           -
LGA    -       -      S     170           -
LGA    -       -      L     171           -
LGA    -       -      A     172           -
LGA    -       -      E     173           -
LGA    -       -      I     174           -
LGA    -       -      F     175           -
LGA    -       -      P     176           -
LGA    -       -      L     177           -
LGA    -       -      I     191           -
LGA    -       -      P     192           -
LGA    -       -      G     193           -
LGA    -       -      L     194           -
LGA    Q   106_F      A     195          3.248
LGA    S   107_F      A     196          3.080
LGA    -       -      S     197           -
LGA    V   108_F      V     198          1.895
LGA    X   109_F      L     199          2.337
LGA    L   110_F      V     200          1.935
LGA    V   111_F      V     201          1.443
LGA    G   112_F      S     202          1.378
LGA    H   113_F      H     203          1.717
LGA    N   114_F      G     204          2.901
LGA    P   115_F      A     205          1.665
LGA    T   116_F      Y     206          1.373
LGA    X   117_F      M     207          0.702
LGA    E   118_F      R     208          1.068
LGA    A   119_F      S     209          1.379
LGA    T   120_F      L     210          1.034
LGA    L   121_F      F     211          1.524
LGA    E   122_F      D     212          2.327
LGA    A   123_F      Y     213          2.023
LGA    X   124_F      F     214          1.584
LGA    I   125_F      L     215          3.320
LGA    G   126_F      T     216          4.715
LGA    E   127_F      D     217           -
LGA    D   128_F      L     218           -
LGA    -       -      K     219           -
LGA    -       -      C     220           -
LGA    -       -      S     221           -
LGA    L   129_F      L     222          4.537
LGA    -       -      P     223           -
LGA    -       -      A     224           -
LGA    -       -      T     225           -
LGA    -       -      L     226           -
LGA    L   130_F      S     227          5.040
LGA    H   131_F      R     228          3.005
LGA    A   132_F      S     229           #
LGA    A   133_F      E     230          4.996
LGA    L   134_F      -       -           -
LGA    P   135_F      -       -           -
LGA    S   136_F      L     231           #
LGA    -       -      M     232           -
LGA    -       -      S     233           -
LGA    G   137_F      V     234          0.863
LGA    F   138_F      T     235          1.767
LGA    P   139_F      P     236          1.657
LGA    T   140_F      N     237          1.553
LGA    S   141_F      T     238          0.862
LGA    G   142_F      G     239          0.766
LGA    L   143_F      M     240          0.900
LGA    A   144_F      S     241          0.540
LGA    V   145_F      L     242          0.651
LGA    L   146_F      F     243          0.784
LGA    D   147_F      I     244          0.896
LGA    Q   148_F      I     245          3.330
LGA    D   149_F      N     246           #
LGA    -       -      F     247           -
LGA    -       -      E     248           -
LGA    -       -      E     249           -
LGA    -       -      G     250           -
LGA    -       -      R     251           -
LGA    -       -      E     252           -
LGA    -       -      V     253           -
LGA    -       -      K     254           -
LGA    N   157_F      P     255           #
LGA    R   158_F      T     256          1.884
LGA    W   159_F      V     257          1.053
LGA    R   160_F      Q     258          1.134
LGA    L   161_F      C     259          1.715
LGA    I   162_F      I     260          1.624
LGA    D   163_F      C     261          3.099
LGA    F   164_F      M     262          3.998
LGA    -       -      N     263           -
LGA    L   165_F      L     264          2.420
LGA    A   166_F      Q     265          1.564
LGA    -       -      D     266           -
LGA    -       -      H     267           -
LGA    -       -      L     268           -
LGA    -       -      N     269           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  147  247    5.0    133    2.20    17.29     39.741     5.780

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.725674 * X  +  -0.601564 * Y  +   0.333943 * Z  +  -2.875372
  Y_new =   0.352027 * X  +   0.092398 * Y  +   0.931418 * Z  +  20.842575
  Z_new =  -0.591163 * X  +   0.793463 * Y  +   0.144717 * Z  +  -5.016674 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.390393   -1.751200  [ DEG:    79.6637   -100.3363 ]
  Theta =   0.632501    2.509092  [ DEG:    36.2396    143.7604 ]
  Phi   =   2.689932   -0.451660  [ DEG:   154.1218    -25.8782 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rfl_F                                        
REMARK     2: T0394.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rfl_F.T0394.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  147  247   5.0  133   2.20   17.29  39.741
REMARK  ---------------------------------------------------------- 
MOLECULE 2rfl_F
HEADER    HYDROLASE, ISOMERASE                    01-OCT-07   2RFL              
TITLE     CRYSTAL STRUCTURE OF THE PUTATIVE PHOSPHOHISTIDINE                    
TITLE    2 PHOSPHATASE SIXA FROM AGROBACTERIUM TUMEFACIENS                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE PHOSPHOHISTIDINE PHOSPHATASE SIXA;                
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 SYNONYM: AGR_C_2511P, UNCHARACTERIZED PROTEIN ATU1358,               
COMPND   5 PHOSPHOGLYCERATE MUTASE;                                             
COMPND   6 EC: 5.4.2.1, 3.1.3.13, 5.4.2.4;                                      
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS STR. C58;             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C58;                                                         
SOURCE   5 ATCC: 33970;                                                         
SOURCE   6 GENE: AGR_C_2511, ATU1358;                                           
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ALPHA-BETA-ALPHA SANDWICH, STRUCTURAL GENOMICS, PSI-2,                
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG, HYDROLASE, ISOMERASE                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,T.BINKOWSKI,X.XU,A.M.EDWARDS,A.SAVCHENKO,A.JOACHIMIAK,          
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   23-OCT-07 2RFL    0                                                
JRNL        AUTH   Y.KIM,T.BINKOWSKI,X.XU,J.GU,Q.QUE,A.SAVCHENKO,               
JRNL        AUTH 2 A.M.EDWARDS,A.JOACHIMIAK                                     
JRNL        TITL   CRYSTAL STRUCTURE OF THE PUTATIVE PHOSPHOHISTIDINE           
JRNL        TITL 2 PHOSPHATASE SIXA FROM AGROBACTERIUM TUMEFACIENS.             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.35 ANGSTROMS.                                          
DBREF  2RFL A    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL B    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL C    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL D    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL E    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL F    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL G    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL H    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
SEQRES   1 A  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 A  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 A  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 A  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 A  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 A  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 A  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 A  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 A  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 A  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 A  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 A  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 A  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 A  173  GLY LYS GLY SER                                              
SEQRES   1 B  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 B  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 B  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 B  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 B  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 B  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 B  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 B  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 B  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 B  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 B  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 B  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 B  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 B  173  GLY LYS GLY SER                                              
SEQRES   1 C  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 C  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 C  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 C  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 C  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 C  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 C  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 C  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 C  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 C  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 C  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 C  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 C  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 C  173  GLY LYS GLY SER                                              
SEQRES   1 D  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 D  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 D  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 D  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 D  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 D  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 D  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 D  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 D  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 D  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 D  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 D  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 D  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 D  173  GLY LYS GLY SER                                              
SEQRES   1 E  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 E  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 E  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 E  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 E  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 E  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 E  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 E  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 E  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 E  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 E  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 E  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 E  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 E  173  GLY LYS GLY SER                                              
SEQRES   1 F  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 F  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 F  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 F  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 F  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 F  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 F  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 F  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 F  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 F  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 F  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 F  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 F  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 F  173  GLY LYS GLY SER                                              
SEQRES   1 G  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 G  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 G  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 G  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 G  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 G  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 G  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 G  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 G  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 G  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 G  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 G  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 G  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 G  173  GLY LYS GLY SER                                              
SEQRES   1 H  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 H  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 H  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 H  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 H  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 H  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 H  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 H  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 H  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 H  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 H  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 H  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 H  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 H  173  GLY LYS GLY SER                                              
HET    MSE  A  87       8                                                       
HET    MSE  A 109       8                                                       
HET    MSE  A 117       8                                                       
HET    MSE  A 124       8                                                       
HET    MSE  B  87       8                                                       
HET    MSE  B 109       8                                                       
HET    MSE  B 117       8                                                       
HET    MSE  B 124       8                                                       
HET    MSE  C  87       8                                                       
HET    MSE  C 109       8                                                       
HET    MSE  C 117       8                                                       
HET    MSE  C 124       8                                                       
HET    MSE  D  87       8                                                       
HET    MSE  D 109       8                                                       
HET    MSE  D 117       8                                                       
HET    MSE  D 124       8                                                       
HET    MSE  E  87       8                                                       
HET    MSE  E 109       8                                                       
HET    MSE  E 117       8                                                       
HET    MSE  E 124       8                                                       
HET    MSE  F  87       8                                                       
HET    MSE  F 109       8                                                       
HET    MSE  F 117       8                                                       
HET    MSE  F 124       8                                                       
HET    MSE  G  87       8                                                       
HET    MSE  G 109       8                                                       
HET    MSE  G 117       8                                                       
HET    MSE  G 124       8                                                       
HET    MSE  H  87       8                                                       
HET    MSE  H 109       8                                                       
HET    MSE  H 117       8                                                       
HET    MSE  H 124       8                                                       
HET    SCN  A 172       3                                                       
HET    GOL  A 173       6                                                       
HET    GOL  G 172       6                                                       
HET    ACY  D 172       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SCN THIOCYANATE ION                                                  
HETNAM     GOL GLYCEROL                                                         
HETNAM     ACY ACETIC ACID                                                      
FORMUL   1  MSE    32(C5 H11 N O2 SE)                                           
FORMUL   9  SCN    C N S 1-                                                     
FORMUL  10  GOL    2(C3 H8 O3)                                                  
FORMUL  12  ACY    C2 H4 O2                                                     
FORMUL  13  HOH   *581(H2 O)                                                    
CRYST1   58.966  201.503   72.717  90.00 113.98  90.00 P 1 21 1     16          
ATOM   6116  N   SER F   4       8.111  40.918  18.624  1.00 47.16           N  
ATOM   6117  CA  SER F   4       9.191  40.194  17.852  1.00 45.74           C  
ATOM   6118  C   SER F   4      10.343  41.060  17.302  1.00 44.65           C  
ATOM   6119  O   SER F   4      10.155  41.779  16.316  1.00 45.16           O  
ATOM   6120  CB  SER F   4       8.573  39.419  16.682  1.00 45.55           C  
ATOM   6121  OG  SER F   4       9.490  39.221  15.626  1.00 43.31           O  
ATOM   6122  N   PHE F   5      11.526  40.964  17.926  1.00 42.26           N  
ATOM   6123  CA  PHE F   5      12.767  41.446  17.331  1.00 39.25           C  
ATOM   6124  C   PHE F   5      13.410  40.195  16.644  1.00 35.88           C  
ATOM   6125  O   PHE F   5      13.063  39.077  16.992  1.00 35.11           O  
ATOM   6126  CB  PHE F   5      13.664  42.045  18.418  1.00 40.62           C  
ATOM   6127  CG  PHE F   5      13.390  43.516  18.760  1.00 43.49           C  
ATOM   6128  CD1 PHE F   5      12.165  44.126  18.517  1.00 45.61           C  
ATOM   6129  CD2 PHE F   5      14.381  44.268  19.421  1.00 48.55           C  
ATOM   6130  CE1 PHE F   5      11.947  45.493  18.855  1.00 48.72           C  
ATOM   6131  CE2 PHE F   5      14.172  45.625  19.772  1.00 50.12           C  
ATOM   6132  CZ  PHE F   5      12.956  46.242  19.482  1.00 47.12           C  
ATOM   6133  N   PRO F   6      14.263  40.361  15.605  1.00 32.68           N  
ATOM   6134  CA  PRO F   6      14.762  41.572  14.953  1.00 30.86           C  
ATOM   6135  C   PRO F   6      13.683  42.172  14.063  1.00 29.61           C  
ATOM   6136  O   PRO F   6      12.957  41.446  13.422  1.00 27.05           O  
ATOM   6137  CB  PRO F   6      15.956  41.086  14.118  1.00 28.83           C  
ATOM   6138  CG  PRO F   6      15.955  39.546  14.264  1.00 30.44           C  
ATOM   6139  CD  PRO F   6      14.725  39.131  14.917  1.00 31.78           C  
ATOM   6140  N   THR F   7      13.596  43.498  14.032  1.00 29.83           N  
ATOM   6141  CA  THR F   7      12.645  44.147  13.127  1.00 30.85           C  
ATOM   6142  C   THR F   7      13.256  44.576  11.765  1.00 29.78           C  
ATOM   6143  O   THR F   7      12.545  44.920  10.843  1.00 31.01           O  
ATOM   6144  CB  THR F   7      11.844  45.277  13.836  1.00 31.14           C  
ATOM   6145  OG1 THR F   7      12.739  46.272  14.321  1.00 33.05           O  
ATOM   6146  CG2 THR F   7      11.034  44.708  15.049  1.00 33.29           C  
ATOM   6147  N   ARG F   8      14.559  44.532  11.655  1.00 28.58           N  
ATOM   6148  CA  ARG F   8      15.254  44.861  10.421  1.00 29.00           C  
ATOM   6149  C   ARG F   8      16.291  43.778  10.129  1.00 27.86           C  
ATOM   6150  O   ARG F   8      16.949  43.288  11.063  1.00 27.14           O  
ATOM   6151  CB  ARG F   8      15.938  46.220  10.647  1.00 31.75           C  
ATOM   6152  CG  ARG F   8      17.134  46.612   9.811  1.00 32.20           C  
ATOM   6153  CD  ARG F   8      16.686  47.262   8.519  1.00 35.94           C  
ATOM   6154  NE  ARG F   8      15.589  48.246   8.638  1.00 34.27           N  
ATOM   6155  CZ  ARG F   8      15.671  49.520   8.248  1.00 33.84           C  
ATOM   6156  NH1 ARG F   8      16.807  50.029   7.782  1.00 31.50           N  
ATOM   6157  NH2 ARG F   8      14.606  50.301   8.341  1.00 35.18           N  
ATOM   6158  N   VAL F   9      16.410  43.372   8.859  1.00 26.66           N  
ATOM   6159  CA  VAL F   9      17.407  42.391   8.451  1.00 25.60           C  
ATOM   6160  C   VAL F   9      18.184  42.915   7.270  1.00 26.61           C  
ATOM   6161  O   VAL F   9      17.575  43.450   6.336  1.00 27.14           O  
ATOM   6162  CB  VAL F   9      16.768  40.994   8.107  1.00 25.61           C  
ATOM   6163  CG1 VAL F   9      17.811  39.959   7.659  1.00 18.47           C  
ATOM   6164  CG2 VAL F   9      15.966  40.445   9.337  1.00 26.47           C  
ATOM   6165  N   TYR F  10      19.523  42.781   7.327  1.00 26.69           N  
ATOM   6166  CA  TYR F  10      20.405  43.036   6.194  1.00 26.89           C  
ATOM   6167  C   TYR F  10      21.028  41.743   5.748  1.00 27.28           C  
ATOM   6168  O   TYR F  10      21.450  40.962   6.557  1.00 27.21           O  
ATOM   6169  CB  TYR F  10      21.533  44.005   6.548  1.00 26.67           C  
ATOM   6170  CG  TYR F  10      21.070  45.243   7.175  1.00 27.66           C  
ATOM   6171  CD1 TYR F  10      21.071  45.380   8.563  1.00 30.05           C  
ATOM   6172  CD2 TYR F  10      20.579  46.298   6.398  1.00 29.18           C  
ATOM   6173  CE1 TYR F  10      20.605  46.564   9.181  1.00 27.81           C  
ATOM   6174  CE2 TYR F  10      20.133  47.438   6.985  1.00 28.87           C  
ATOM   6175  CZ  TYR F  10      20.147  47.580   8.382  1.00 27.93           C  
ATOM   6176  OH  TYR F  10      19.690  48.744   8.954  1.00 26.64           O  
ATOM   6177  N   LEU F  11      21.094  41.523   4.442  1.00 28.66           N  
ATOM   6178  CA  LEU F  11      21.667  40.280   3.888  1.00 28.85           C  
ATOM   6179  C   LEU F  11      22.703  40.787   2.949  1.00 30.10           C  
ATOM   6180  O   LEU F  11      22.403  41.544   2.022  1.00 32.06           O  
ATOM   6181  CB  LEU F  11      20.624  39.399   3.147  1.00 27.24           C  
ATOM   6182  CG  LEU F  11      19.351  38.914   3.887  1.00 26.25           C  
ATOM   6183  CD1 LEU F  11      18.531  37.905   3.063  1.00 19.03           C  
ATOM   6184  CD2 LEU F  11      19.633  38.319   5.282  1.00 25.55           C  
ATOM   6185  N   LEU F  12      23.943  40.460   3.258  1.00 30.80           N  
ATOM   6186  CA  LEU F  12      25.069  40.905   2.496  1.00 31.21           C  
ATOM   6187  C   LEU F  12      25.840  39.684   1.962  1.00 32.25           C  
ATOM   6188  O   LEU F  12      26.322  38.874   2.753  1.00 31.37           O  
ATOM   6189  CB  LEU F  12      25.972  41.790   3.367  1.00 30.34           C  
ATOM   6190  CG  LEU F  12      27.276  42.250   2.675  1.00 28.35           C  
ATOM   6191  CD1 LEU F  12      27.025  43.040   1.349  1.00 23.41           C  
ATOM   6192  CD2 LEU F  12      28.138  43.059   3.651  1.00 24.12           C  
ATOM   6193  N   ARG F  13      25.922  39.549   0.633  1.00 33.63           N  
ATOM   6194  CA  ARG F  13      26.799  38.550   0.017  1.00 35.72           C  
ATOM   6195  C   ARG F  13      28.227  39.122  -0.005  1.00 37.83           C  
ATOM   6196  O   ARG F  13      28.426  40.308  -0.236  1.00 36.99           O  
ATOM   6197  CB  ARG F  13      26.325  38.176  -1.408  1.00 35.83           C  
ATOM   6198  CG  ARG F  13      27.129  37.016  -2.058  1.00 36.94           C  
ATOM   6199  CD  ARG F  13      26.647  36.570  -3.435  1.00 36.88           C  
ATOM   6200  NE  ARG F  13      27.538  35.535  -3.977  1.00 36.23           N  
ATOM   6201  CZ  ARG F  13      27.791  35.338  -5.274  1.00 36.97           C  
ATOM   6202  NH1 ARG F  13      27.218  36.094  -6.193  1.00 37.03           N  
ATOM   6203  NH2 ARG F  13      28.630  34.385  -5.664  1.00 35.23           N  
ATOM   6204  N   HIS F  14      29.217  38.290   0.275  1.00 40.19           N  
ATOM   6205  CA  HIS F  14      30.610  38.713   0.208  1.00 42.74           C  
ATOM   6206  C   HIS F  14      30.918  39.438  -1.102  1.00 45.43           C  
ATOM   6207  O   HIS F  14      30.259  39.233  -2.120  1.00 44.34           O  
ATOM   6208  CB  HIS F  14      31.546  37.503   0.366  1.00 42.85           C  
ATOM   6209  CG  HIS F  14      31.365  36.449  -0.694  1.00 43.44           C  
ATOM   6210  ND1 HIS F  14      30.454  35.420  -0.577  1.00 42.60           N  
ATOM   6211  CD2 HIS F  14      31.949  36.292  -1.908  1.00 42.10           C  
ATOM   6212  CE1 HIS F  14      30.501  34.666  -1.661  1.00 41.70           C  
ATOM   6213  NE2 HIS F  14      31.395  35.178  -2.485  1.00 42.30           N  
ATOM   6214  N   ALA F  15      31.924  40.300  -1.044  1.00 49.28           N  
ATOM   6215  CA  ALA F  15      32.556  40.838  -2.224  1.00 54.18           C  
ATOM   6216  C   ALA F  15      33.181  39.720  -3.073  1.00 57.51           C  
ATOM   6217  O   ALA F  15      33.530  38.635  -2.574  1.00 56.49           O  
ATOM   6218  CB  ALA F  15      33.629  41.873  -1.834  1.00 53.99           C  
ATOM   6219  N   LYS F  16      33.313  40.025  -4.363  1.00 62.25           N  
ATOM   6220  CA  LYS F  16      34.095  39.242  -5.300  1.00 66.70           C  
ATOM   6221  C   LYS F  16      35.521  39.117  -4.801  1.00 69.39           C  
ATOM   6222  O   LYS F  16      36.103  40.056  -4.261  1.00 69.41           O  
ATOM   6223  CB  LYS F  16      34.106  39.933  -6.653  1.00 67.81           C  
ATOM   6224  CG  LYS F  16      34.182  38.989  -7.855  1.00 69.89           C  
ATOM   6225  CD  LYS F  16      34.018  39.767  -9.181  1.00 71.06           C  
ATOM   6226  CE  LYS F  16      32.870  40.804  -9.140  1.00 67.76           C  
ATOM   6227  NZ  LYS F  16      31.528  40.200  -8.975  1.00 63.43           N  
ATOM   6228  N   ALA F  17      36.074  37.938  -4.987  1.00 72.36           N  
ATOM   6229  CA  ALA F  17      37.387  37.650  -4.502  1.00 75.33           C  
ATOM   6230  C   ALA F  17      38.217  37.264  -5.703  1.00 78.03           C  
ATOM   6231  O   ALA F  17      37.699  37.206  -6.814  1.00 77.98           O  
ATOM   6232  CB  ALA F  17      37.317  36.520  -3.486  1.00 74.36           C  
ATOM   6233  N   ALA F  18      39.499  37.010  -5.469  1.00 80.75           N  
ATOM   6234  CA  ALA F  18      40.406  36.503  -6.482  1.00 83.60           C  
ATOM   6235  C   ALA F  18      40.121  35.036  -6.798  1.00 83.95           C  
ATOM   6236  O   ALA F  18      39.153  34.709  -7.489  1.00 83.28           O  
ATOM   6237  CB  ALA F  18      41.836  36.677  -6.023  1.00 85.26           C  
ATOM   6238  N   ASP F  26      39.538  27.716  -1.678  1.00 69.95           N  
ATOM   6239  CA  ASP F  26      38.159  28.174  -1.526  1.00 68.89           C  
ATOM   6240  C   ASP F  26      38.005  29.021  -0.232  1.00 66.71           C  
ATOM   6241  O   ASP F  26      37.987  30.243  -0.293  1.00 66.07           O  
ATOM   6242  CB  ASP F  26      37.201  26.973  -1.566  1.00 69.04           C  
ATOM   6243  CG  ASP F  26      35.875  27.251  -2.328  1.00 69.61           C  
ATOM   6244  OD1 ASP F  26      35.632  28.354  -2.879  1.00 67.41           O  
ATOM   6245  OD2 ASP F  26      35.056  26.308  -2.384  1.00 71.02           O  
ATOM   6246  N   PHE F  27      37.933  28.370   0.930  1.00 64.54           N  
ATOM   6247  CA  PHE F  27      37.903  29.043   2.234  1.00 61.28           C  
ATOM   6248  C   PHE F  27      38.960  30.157   2.428  1.00 61.77           C  
ATOM   6249  O   PHE F  27      38.654  31.235   2.923  1.00 59.97           O  
ATOM   6250  CB  PHE F  27      38.025  27.993   3.355  1.00 60.25           C  
ATOM   6251  CG  PHE F  27      37.715  28.525   4.720  1.00 53.93           C  
ATOM   6252  CD1 PHE F  27      38.731  28.821   5.610  1.00 50.61           C  
ATOM   6253  CD2 PHE F  27      36.405  28.751   5.113  1.00 47.72           C  
ATOM   6254  CE1 PHE F  27      38.446  29.321   6.885  1.00 46.72           C  
ATOM   6255  CE2 PHE F  27      36.125  29.256   6.368  1.00 43.90           C  
ATOM   6256  CZ  PHE F  27      37.157  29.531   7.263  1.00 42.83           C  
ATOM   6257  N   ASP F  28      40.203  29.889   2.040  1.00 62.84           N  
ATOM   6258  CA  ASP F  28      41.304  30.863   2.202  1.00 63.40           C  
ATOM   6259  C   ASP F  28      41.334  31.998   1.155  1.00 63.46           C  
ATOM   6260  O   ASP F  28      42.132  32.939   1.260  1.00 63.42           O  
ATOM   6261  CB  ASP F  28      42.665  30.138   2.253  1.00 64.39           C  
ATOM   6262  CG  ASP F  28      42.981  29.570   3.625  1.00 63.18           C  
ATOM   6263  OD1 ASP F  28      42.062  29.439   4.467  1.00 64.57           O  
ATOM   6264  OD2 ASP F  28      44.153  29.252   3.878  1.00 60.73           O  
ATOM   6265  N   ARG F  29      40.463  31.897   0.156  1.00 62.93           N  
ATOM   6266  CA  ARG F  29      40.512  32.787  -0.997  1.00 63.72           C  
ATOM   6267  C   ARG F  29      40.002  34.179  -0.641  1.00 62.93           C  
ATOM   6268  O   ARG F  29      38.854  34.343  -0.228  1.00 60.93           O  
ATOM   6269  CB  ARG F  29      39.698  32.209  -2.156  1.00 63.85           C  
ATOM   6270  CG  ARG F  29      38.536  33.085  -2.595  1.00 63.75           C  
ATOM   6271  CD  ARG F  29      37.440  32.260  -3.251  1.00 64.44           C  
ATOM   6272  NE  ARG F  29      37.878  31.671  -4.512  1.00 68.26           N  
ATOM   6273  CZ  ARG F  29      37.897  32.318  -5.672  1.00 72.07           C  
ATOM   6274  NH1 ARG F  29      37.500  33.582  -5.736  1.00 72.02           N  
ATOM   6275  NH2 ARG F  29      38.313  31.702  -6.771  1.00 75.38           N  
ATOM   6276  N   GLY F  30      40.863  35.179  -0.803  1.00 63.87           N  
ATOM   6277  CA  GLY F  30      40.571  36.520  -0.332  1.00 63.60           C  
ATOM   6278  C   GLY F  30      40.059  37.424  -1.436  1.00 64.50           C  
ATOM   6279  O   GLY F  30      39.866  36.986  -2.569  1.00 63.82           O  
ATOM   6280  N   LEU F  31      39.838  38.691  -1.101  1.00 65.76           N  
ATOM   6281  CA  LEU F  31      39.336  39.662  -2.065  1.00 67.87           C  
ATOM   6282  C   LEU F  31      40.438  40.115  -3.018  1.00 71.63           C  
ATOM   6283  O   LEU F  31      41.599  40.234  -2.626  1.00 72.23           O  
ATOM   6284  CB  LEU F  31      38.733  40.870  -1.346  1.00 66.13           C  
ATOM   6285  CG  LEU F  31      37.650  40.570  -0.307  1.00 64.43           C  
ATOM   6286  CD1 LEU F  31      37.187  41.849   0.372  1.00 61.48           C  
ATOM   6287  CD2 LEU F  31      36.477  39.843  -0.948  1.00 65.86           C  
ATOM   6288  N   ASN F  32      40.068  40.366  -4.269  1.00 74.86           N  
ATOM   6289  CA  ASN F  32      40.930  41.093  -5.192  1.00 79.89           C  
ATOM   6290  C   ASN F  32      40.782  42.605  -5.049  1.00 82.20           C  
ATOM   6291  O   ASN F  32      40.091  43.089  -4.153  1.00 80.84           O  
ATOM   6292  CB  ASN F  32      40.648  40.671  -6.636  1.00 80.38           C  
ATOM   6293  CG  ASN F  32      39.288  41.133  -7.121  1.00 78.89           C  
ATOM   6294  OD1 ASN F  32      38.545  41.790  -6.392  1.00 75.14           O  
ATOM   6295  ND2 ASN F  32      38.955  40.790  -8.361  1.00 79.34           N  
ATOM   6296  N   GLU F  33      41.436  43.344  -5.940  1.00 86.60           N  
ATOM   6297  CA  GLU F  33      41.519  44.794  -5.818  0.20 89.84           C  
ATOM   6298  C   GLU F  33      40.214  45.459  -6.241  1.00 89.55           C  
ATOM   6299  O   GLU F  33      39.844  46.510  -5.718  1.00 89.04           O  
ATOM   6300  CB  GLU F  33      42.681  45.335  -6.656  0.20 92.30           C  
ATOM   6301  CG  GLU F  33      44.032  45.265  -5.962  0.20 96.19           C  
ATOM   6302  CD  GLU F  33      45.188  45.231  -6.941  0.20101.88           C  
ATOM   6303  OE1 GLU F  33      45.294  46.158  -7.772  0.20103.54           O  
ATOM   6304  OE2 GLU F  33      45.993  44.277  -6.880  0.20102.66           O  
ATOM   6305  N   ALA F  34      39.522  44.840  -7.192  1.00 89.63           N  
ATOM   6306  CA  ALA F  34      38.133  45.183  -7.474  1.00 88.38           C  
ATOM   6307  C   ALA F  34      37.265  45.045  -6.228  1.00 86.31           C  
ATOM   6308  O   ALA F  34      36.299  45.785  -6.047  1.00 85.76           O  
ATOM   6309  CB  ALA F  34      37.590  44.315  -8.600  1.00 88.54           C  
ATOM   6310  N   GLY F  35      37.617  44.091  -5.371  1.00 84.12           N  
ATOM   6311  CA  GLY F  35      36.673  43.533  -4.422  1.00 79.97           C  
ATOM   6312  C   GLY F  35      36.658  44.286  -3.106  1.00 77.15           C  
ATOM   6313  O   GLY F  35      35.595  44.562  -2.550  1.00 75.71           O  
ATOM   6314  N   PHE F  36      37.845  44.618  -2.607  1.00 75.72           N  
ATOM   6315  CA  PHE F  36      37.969  45.429  -1.403  1.00 73.10           C  
ATOM   6316  C   PHE F  36      37.153  46.713  -1.514  1.00 70.57           C  
ATOM   6317  O   PHE F  36      36.333  47.015  -0.649  1.00 68.53           O  
ATOM   6318  CB  PHE F  36      39.437  45.761  -1.129  1.00 74.68           C  
ATOM   6319  CG  PHE F  36      40.117  44.790  -0.207  1.00 75.54           C  
ATOM   6320  CD1 PHE F  36      40.052  44.954   1.166  1.00 75.73           C  
ATOM   6321  CD2 PHE F  36      40.822  43.711  -0.714  1.00 76.49           C  
ATOM   6322  CE1 PHE F  36      40.676  44.062   2.016  1.00 76.08           C  
ATOM   6323  CE2 PHE F  36      41.449  42.815   0.130  1.00 79.17           C  
ATOM   6324  CZ  PHE F  36      41.376  42.991   1.497  1.00 77.90           C  
ATOM   6325  N   ALA F  37      37.385  47.463  -2.587  1.00 69.10           N  
ATOM   6326  CA  ALA F  37      36.797  48.772  -2.737  1.00 66.62           C  
ATOM   6327  C   ALA F  37      35.296  48.692  -2.992  1.00 63.54           C  
ATOM   6328  O   ALA F  37      34.586  49.620  -2.645  1.00 62.84           O  
ATOM   6329  CB  ALA F  37      37.512  49.541  -3.840  1.00 68.40           C  
ATOM   6330  N   GLU F  38      34.820  47.598  -3.587  1.00 60.61           N  
ATOM   6331  CA  GLU F  38      33.390  47.411  -3.838  1.00 58.62           C  
ATOM   6332  C   GLU F  38      32.633  47.103  -2.532  1.00 56.86           C  
ATOM   6333  O   GLU F  38      31.554  47.642  -2.275  1.00 55.44           O  
ATOM   6334  CB  GLU F  38      33.136  46.361  -4.943  1.00 58.69           C  
ATOM   6335  CG  GLU F  38      32.712  46.986  -6.305  1.00 60.04           C  
ATOM   6336  CD  GLU F  38      32.752  46.028  -7.515  1.00 59.23           C  
ATOM   6337  OE1 GLU F  38      32.283  44.872  -7.384  1.00 58.57           O  
ATOM   6338  OE2 GLU F  38      33.240  46.452  -8.600  1.00 57.46           O  
ATOM   6339  N   ALA F  39      33.224  46.251  -1.701  1.00 55.75           N  
ATOM   6340  CA  ALA F  39      32.842  46.173  -0.307  1.00 55.01           C  
ATOM   6341  C   ALA F  39      32.854  47.555   0.367  1.00 54.87           C  
ATOM   6342  O   ALA F  39      31.817  47.989   0.875  1.00 54.09           O  
ATOM   6343  CB  ALA F  39      33.746  45.171   0.449  1.00 55.85           C  
ATOM   6344  N   GLU F  40      34.013  48.230   0.353  1.00 54.51           N  
ATOM   6345  CA  GLU F  40      34.158  49.600   0.856  1.00 54.30           C  
ATOM   6346  C   GLU F  40      33.049  50.561   0.383  1.00 53.42           C  
ATOM   6347  O   GLU F  40      32.519  51.297   1.192  1.00 52.58           O  
ATOM   6348  CB  GLU F  40      35.565  50.161   0.548  1.00 55.96           C  
ATOM   6349  CG  GLU F  40      35.682  51.685   0.488  1.00 56.63           C  
ATOM   6350  CD  GLU F  40      37.099  52.175   0.670  1.00 59.91           C  
ATOM   6351  OE1 GLU F  40      37.687  52.725  -0.284  1.00 57.40           O  
ATOM   6352  OE2 GLU F  40      37.641  52.003   1.788  1.00 63.60           O  
ATOM   6353  N   ILE F  41      32.700  50.540  -0.902  1.00 52.34           N  
ATOM   6354  CA  ILE F  41      31.532  51.275  -1.418  1.00 51.65           C  
ATOM   6355  C   ILE F  41      30.173  50.943  -0.778  1.00 49.95           C  
ATOM   6356  O   ILE F  41      29.577  51.809  -0.186  1.00 49.04           O  
ATOM   6357  CB  ILE F  41      31.405  51.152  -2.932  1.00 51.99           C  
ATOM   6358  CG1 ILE F  41      32.210  52.254  -3.633  1.00 53.30           C  
ATOM   6359  CG2 ILE F  41      29.952  51.283  -3.339  1.00 52.00           C  
ATOM   6360  CD1 ILE F  41      33.685  52.203  -3.380  1.00 52.84           C  
ATOM   6361  N   ILE F  42      29.703  49.694  -0.889  1.00 49.71           N  
ATOM   6362  CA  ILE F  42      28.432  49.228  -0.261  1.00 48.04           C  
ATOM   6363  C   ILE F  42      28.322  49.624   1.214  1.00 47.17           C  
ATOM   6364  O   ILE F  42      27.246  50.045   1.642  1.00 46.25           O  
ATOM   6365  CB  ILE F  42      28.195  47.691  -0.448  1.00 47.55           C  
ATOM   6366  CG1 ILE F  42      28.423  47.292  -1.902  1.00 49.62           C  
ATOM   6367  CG2 ILE F  42      26.795  47.243   0.007  1.00 44.91           C  
ATOM   6368  CD1 ILE F  42      27.401  47.855  -2.897  1.00 55.15           C  
ATOM   6369  N   ALA F  43      29.430  49.526   1.958  1.00 46.88           N  
ATOM   6370  CA  ALA F  43      29.497  49.996   3.356  1.00 47.25           C  
ATOM   6371  C   ALA F  43      29.326  51.504   3.506  1.00 48.06           C  
ATOM   6372  O   ALA F  43      28.737  51.969   4.475  1.00 47.36           O  
ATOM   6373  CB  ALA F  43      30.807  49.567   4.030  1.00 47.22           C  
ATOM   6374  N   ASP F  44      29.899  52.251   2.564  1.00 49.53           N  
ATOM   6375  CA  ASP F  44      29.840  53.697   2.551  1.00 50.70           C  
ATOM   6376  C   ASP F  44      28.367  54.090   2.388  1.00 49.56           C  
ATOM   6377  O   ASP F  44      27.819  54.789   3.225  1.00 49.07           O  
ATOM   6378  CB  ASP F  44      30.687  54.273   1.398  1.00 52.57           C  
ATOM   6379  CG  ASP F  44      32.199  54.002   1.532  1.00 55.57           C  
ATOM   6380  OD1 ASP F  44      32.666  53.528   2.596  1.00 60.69           O  
ATOM   6381  OD2 ASP F  44      32.942  54.293   0.561  1.00 57.17           O  
ATOM   6382  N   LEU F  45      27.755  53.604   1.309  1.00 48.26           N  
ATOM   6383  CA  LEU F  45      26.345  53.818   0.969  1.00 47.92           C  
ATOM   6384  C   LEU F  45      25.330  53.391   2.058  1.00 46.34           C  
ATOM   6385  O   LEU F  45      24.338  54.083   2.286  1.00 44.53           O  
ATOM   6386  CB  LEU F  45      26.031  53.102  -0.352  1.00 48.10           C  
ATOM   6387  CG  LEU F  45      25.887  53.843  -1.680  1.00 50.26           C  
ATOM   6388  CD1 LEU F  45      26.997  54.884  -1.950  1.00 59.03           C  
ATOM   6389  CD2 LEU F  45      25.840  52.833  -2.826  1.00 53.82           C  
ATOM   6390  N   ALA F  46      25.578  52.232   2.682  1.00 45.16           N  
ATOM   6391  CA  ALA F  46      24.849  51.804   3.880  1.00 44.38           C  
ATOM   6392  C   ALA F  46      24.951  52.845   5.006  1.00 44.78           C  
ATOM   6393  O   ALA F  46      24.001  53.061   5.771  1.00 42.85           O  
ATOM   6394  CB  ALA F  46      25.356  50.457   4.367  1.00 43.35           C  
ATOM   6395  N   ALA F  47      26.110  53.491   5.071  1.00 46.03           N  
ATOM   6396  CA  ALA F  47      26.441  54.429   6.144  1.00 47.31           C  
ATOM   6397  C   ALA F  47      25.855  55.803   5.860  1.00 48.58           C  
ATOM   6398  O   ALA F  47      25.727  56.624   6.760  1.00 49.32           O  
ATOM   6399  CB  ALA F  47      27.925  54.505   6.326  1.00 46.98           C  
ATOM   6400  N   ASP F  48      25.480  56.045   4.609  1.00 49.12           N  
ATOM   6401  CA  ASP F  48      24.837  57.293   4.242  1.00 50.30           C  
ATOM   6402  C   ASP F  48      23.368  57.152   4.595  1.00 49.66           C  
ATOM   6403  O   ASP F  48      22.697  58.115   4.971  1.00 50.54           O  
ATOM   6404  CB  ASP F  48      25.005  57.573   2.752  1.00 50.71           C  
ATOM   6405  CG  ASP F  48      26.422  57.993   2.383  1.00 51.74           C  
ATOM   6406  OD1 ASP F  48      26.989  58.845   3.085  1.00 52.06           O  
ATOM   6407  OD2 ASP F  48      26.955  57.498   1.362  1.00 51.13           O  
ATOM   6408  N   ARG F  49      22.903  55.916   4.498  1.00 47.93           N  
ATOM   6409  CA  ARG F  49      21.506  55.569   4.677  1.00 47.21           C  
ATOM   6410  C   ARG F  49      21.207  55.078   6.078  1.00 45.96           C  
ATOM   6411  O   ARG F  49      20.055  54.782   6.372  1.00 45.86           O  
ATOM   6412  CB  ARG F  49      21.072  54.515   3.640  1.00 45.99           C  
ATOM   6413  CG  ARG F  49      20.807  55.089   2.240  1.00 46.89           C  
ATOM   6414  CD  ARG F  49      20.448  53.977   1.289  1.00 49.29           C  
ATOM   6415  NE  ARG F  49      20.495  54.299  -0.129  1.00 51.46           N  
ATOM   6416  CZ  ARG F  49      21.497  54.911  -0.776  1.00 60.02           C  
ATOM   6417  NH1 ARG F  49      22.599  55.387  -0.160  1.00 60.04           N  
ATOM   6418  NH2 ARG F  49      21.372  55.106  -2.089  1.00 64.12           N  
ATOM   6419  N   ARG F  50      22.249  55.004   6.925  1.00 44.72           N  
ATOM   6420  CA  ARG F  50      22.178  54.536   8.320  1.00 41.89           C  
ATOM   6421  C   ARG F  50      21.553  53.166   8.430  1.00 39.95           C  
ATOM   6422  O   ARG F  50      20.699  52.935   9.279  1.00 39.72           O  
ATOM   6423  CB  ARG F  50      21.474  55.554   9.250  1.00 43.60           C  
ATOM   6424  CG  ARG F  50      22.391  56.667   9.874  1.00 43.21           C  
ATOM   6425  CD  ARG F  50      23.889  56.422   9.634  1.00 44.46           C  
ATOM   6426  NE  ARG F  50      24.696  55.661  10.619  1.00 45.10           N  
ATOM   6427  CZ  ARG F  50      24.409  55.455  11.904  1.00 47.14           C  
ATOM   6428  NH1 ARG F  50      25.247  54.816  12.687  1.00 43.04           N  
ATOM   6429  NH2 ARG F  50      23.282  55.899  12.431  1.00 55.85           N  
ATOM   6430  N   TYR F  51      21.970  52.284   7.520  1.00 37.64           N  
ATOM   6431  CA  TYR F  51      21.749  50.869   7.589  1.00 35.34           C  
ATOM   6432  C   TYR F  51      22.761  50.264   8.535  1.00 35.09           C  
ATOM   6433  O   TYR F  51      23.670  49.536   8.114  1.00 33.93           O  
ATOM   6434  CB  TYR F  51      21.920  50.240   6.209  1.00 34.91           C  
ATOM   6435  CG  TYR F  51      20.850  50.601   5.226  1.00 33.79           C  
ATOM   6436  CD1 TYR F  51      19.559  50.946   5.657  1.00 34.29           C  
ATOM   6437  CD2 TYR F  51      21.116  50.586   3.875  1.00 29.93           C  
ATOM   6438  CE1 TYR F  51      18.581  51.289   4.762  1.00 34.16           C  
ATOM   6439  CE2 TYR F  51      20.154  50.913   2.965  1.00 32.99           C  
ATOM   6440  CZ  TYR F  51      18.875  51.262   3.397  1.00 36.12           C  
ATOM   6441  OH  TYR F  51      17.879  51.589   2.462  1.00 38.04           O  
ATOM   6442  N   ARG F  52      22.592  50.555   9.824  1.00 35.12           N  
ATOM   6443  CA  ARG F  52      23.534  50.125  10.830  1.00 34.42           C  
ATOM   6444  C   ARG F  52      23.091  48.937  11.688  1.00 33.24           C  
ATOM   6445  O   ARG F  52      22.353  49.135  12.657  1.00 33.90           O  
ATOM   6446  CB  ARG F  52      23.924  51.306  11.719  1.00 35.20           C  
ATOM   6447  CG  ARG F  52      25.148  50.992  12.615  1.00 34.63           C  
ATOM   6448  CD  ARG F  52      24.991  51.625  13.989  1.00 37.21           C  
ATOM   6449  NE  ARG F  52      26.019  51.165  14.899  1.00 40.96           N  
ATOM   6450  CZ  ARG F  52      25.812  50.328  15.904  1.00 42.86           C  
ATOM   6451  NH1 ARG F  52      24.599  49.870  16.184  1.00 41.69           N  
ATOM   6452  NH2 ARG F  52      26.835  49.981  16.667  1.00 48.42           N  
ATOM   6453  N   PRO F  53      23.579  47.708  11.383  1.00 31.97           N  
ATOM   6454  CA  PRO F  53      23.127  46.573  12.224  1.00 30.99           C  
ATOM   6455  C   PRO F  53      23.726  46.586  13.644  1.00 31.45           C  
ATOM   6456  O   PRO F  53      24.838  47.097  13.877  1.00 30.46           O  
ATOM   6457  CB  PRO F  53      23.573  45.333  11.443  1.00 29.48           C  
ATOM   6458  CG  PRO F  53      24.696  45.754  10.655  1.00 30.20           C  
ATOM   6459  CD  PRO F  53      24.534  47.261  10.354  1.00 32.09           C  
ATOM   6460  N   ASP F  54      22.950  46.064  14.586  1.00 30.38           N  
ATOM   6461  CA  ASP F  54      23.385  45.917  15.946  1.00 30.51           C  
ATOM   6462  C   ASP F  54      24.331  44.729  16.017  1.00 29.05           C  
ATOM   6463  O   ASP F  54      25.237  44.701  16.797  1.00 29.61           O  
ATOM   6464  CB  ASP F  54      22.164  45.706  16.837  1.00 31.46           C  
ATOM   6465  CG  ASP F  54      21.140  46.799  16.668  1.00 32.88           C  
ATOM   6466  OD1 ASP F  54      21.522  47.932  16.316  1.00 36.52           O  
ATOM   6467  OD2 ASP F  54      19.948  46.547  16.890  1.00 36.25           O  
ATOM   6468  N   LEU F  55      24.130  43.783  15.121  1.00 27.70           N  
ATOM   6469  CA  LEU F  55      24.839  42.539  15.107  1.00 25.54           C  
ATOM   6470  C   LEU F  55      25.121  42.183  13.700  1.00 24.58           C  
ATOM   6471  O   LEU F  55      24.192  42.173  12.898  1.00 22.11           O  
ATOM   6472  CB  LEU F  55      23.948  41.457  15.636  1.00 24.19           C  
ATOM   6473  CG  LEU F  55      24.571  40.127  16.004  1.00 23.38           C  
ATOM   6474  CD1 LEU F  55      25.723  40.368  17.028  1.00 18.77           C  
ATOM   6475  CD2 LEU F  55      23.408  39.232  16.560  1.00 22.72           C  
ATOM   6476  N   ILE F  56      26.377  41.892  13.379  1.00 23.90           N  
ATOM   6477  CA  ILE F  56      26.708  41.151  12.169  1.00 24.00           C  
ATOM   6478  C   ILE F  56      27.072  39.705  12.488  1.00 23.81           C  
ATOM   6479  O   ILE F  56      27.981  39.444  13.277  1.00 23.07           O  
ATOM   6480  CB  ILE F  56      27.874  41.808  11.406  1.00 24.66           C  
ATOM   6481  CG1 ILE F  56      27.455  43.176  10.864  1.00 24.63           C  
ATOM   6482  CG2 ILE F  56      28.349  40.904  10.278  1.00 24.67           C  
ATOM   6483  CD1 ILE F  56      28.608  44.134  10.665  1.00 29.05           C  
ATOM   6484  N   LEU F  57      26.357  38.770  11.872  1.00 22.41           N  
ATOM   6485  CA  LEU F  57      26.787  37.377  11.834  1.00 22.78           C  
ATOM   6486  C   LEU F  57      27.475  37.050  10.512  1.00 24.08           C  
ATOM   6487  O   LEU F  57      26.923  37.290   9.438  1.00 22.38           O  
ATOM   6488  CB  LEU F  57      25.596  36.442  12.053  1.00 22.87           C  
ATOM   6489  CG  LEU F  57      24.756  36.698  13.305  1.00 22.11           C  
ATOM   6490  CD1 LEU F  57      23.574  35.742  13.364  1.00 18.52           C  
ATOM   6491  CD2 LEU F  57      25.609  36.580  14.559  1.00 17.80           C  
ATOM   6492  N   SER F  58      28.682  36.500  10.600  1.00 25.25           N  
ATOM   6493  CA  SER F  58      29.578  36.435   9.452  1.00 27.05           C  
ATOM   6494  C   SER F  58      30.163  35.036   9.287  1.00 29.41           C  
ATOM   6495  O   SER F  58      30.605  34.420  10.256  1.00 29.12           O  
ATOM   6496  CB  SER F  58      30.704  37.461   9.592  1.00 27.65           C  
ATOM   6497  OG  SER F  58      31.457  37.560   8.395  1.00 28.19           O  
ATOM   6498  N   SER F  59      30.161  34.540   8.053  1.00 30.40           N  
ATOM   6499  CA  SER F  59      31.010  33.415   7.678  1.00 33.02           C  
ATOM   6500  C   SER F  59      32.461  33.663   8.075  1.00 33.52           C  
ATOM   6501  O   SER F  59      32.902  34.807   8.170  1.00 33.97           O  
ATOM   6502  CB  SER F  59      30.914  33.150   6.174  1.00 33.27           C  
ATOM   6503  OG  SER F  59      32.138  32.650   5.665  1.00 34.61           O  
ATOM   6504  N   THR F  60      33.197  32.581   8.307  1.00 33.82           N  
ATOM   6505  CA  THR F  60      34.593  32.679   8.723  1.00 33.22           C  
ATOM   6506  C   THR F  60      35.527  32.693   7.518  1.00 35.38           C  
ATOM   6507  O   THR F  60      36.743  32.829   7.665  1.00 35.64           O  
ATOM   6508  CB  THR F  60      34.986  31.517   9.653  1.00 32.77           C  
ATOM   6509  OG1 THR F  60      34.618  30.271   9.049  1.00 32.38           O  
ATOM   6510  CG2 THR F  60      34.286  31.651  10.997  1.00 27.91           C  
ATOM   6511  N   ALA F  61      34.953  32.550   6.328  1.00 35.37           N  
ATOM   6512  CA  ALA F  61      35.732  32.570   5.095  1.00 36.22           C  
ATOM   6513  C   ALA F  61      36.422  33.916   4.900  1.00 36.78           C  
ATOM   6514  O   ALA F  61      35.938  34.947   5.369  1.00 36.86           O  
ATOM   6515  CB  ALA F  61      34.843  32.249   3.903  1.00 35.51           C  
ATOM   6516  N   ALA F  62      37.555  33.900   4.206  1.00 37.56           N  
ATOM   6517  CA  ALA F  62      38.412  35.075   4.111  1.00 37.92           C  
ATOM   6518  C   ALA F  62      37.693  36.229   3.419  1.00 37.49           C  
ATOM   6519  O   ALA F  62      37.746  37.370   3.878  1.00 37.45           O  
ATOM   6520  CB  ALA F  62      39.700  34.734   3.377  1.00 39.45           C  
ATOM   6521  N   ARG F  63      37.020  35.923   2.315  1.00 36.84           N  
ATOM   6522  CA  ARG F  63      36.298  36.935   1.554  1.00 36.29           C  
ATOM   6523  C   ARG F  63      35.167  37.541   2.376  1.00 34.66           C  
ATOM   6524  O   ARG F  63      34.957  38.755   2.362  1.00 34.34           O  
ATOM   6525  CB  ARG F  63      35.745  36.336   0.259  1.00 36.20           C  
ATOM   6526  CG  ARG F  63      34.903  35.087   0.462  1.00 35.89           C  
ATOM   6527  CD  ARG F  63      34.752  34.305  -0.833  1.00 39.27           C  
ATOM   6528  NE  ARG F  63      33.970  33.087  -0.648  1.00 37.08           N  
ATOM   6529  CZ  ARG F  63      34.478  31.860  -0.687  1.00 40.50           C  
ATOM   6530  NH1 ARG F  63      35.775  31.683  -0.903  1.00 40.07           N  
ATOM   6531  NH2 ARG F  63      33.691  30.807  -0.508  1.00 40.17           N  
ATOM   6532  N   CYS F  64      34.440  36.690   3.093  1.00 34.52           N  
ATOM   6533  CA  CYS F  64      33.415  37.161   4.067  1.00 34.30           C  
ATOM   6534  C   CYS F  64      34.002  37.986   5.240  1.00 33.26           C  
ATOM   6535  O   CYS F  64      33.491  39.048   5.559  1.00 31.36           O  
ATOM   6536  CB  CYS F  64      32.682  35.950   4.664  1.00 33.75           C  
ATOM   6537  SG  CYS F  64      31.356  35.174   3.676  1.00 38.63           S  
ATOM   6538  N   ARG F  65      35.070  37.482   5.866  1.00 33.29           N  
ATOM   6539  CA  ARG F  65      35.784  38.221   6.911  1.00 34.78           C  
ATOM   6540  C   ARG F  65      36.214  39.587   6.396  1.00 35.25           C  
ATOM   6541  O   ARG F  65      36.019  40.563   7.061  1.00 34.32           O  
ATOM   6542  CB  ARG F  65      37.061  37.481   7.458  1.00 34.49           C  
ATOM   6543  CG  ARG F  65      36.801  36.386   8.442  1.00 33.35           C  
ATOM   6544  CD  ARG F  65      37.998  36.061   9.320  1.00 32.58           C  
ATOM   6545  NE  ARG F  65      37.667  35.092  10.376  1.00 29.94           N  
ATOM   6546  CZ  ARG F  65      37.414  35.421  11.643  1.00 29.30           C  
ATOM   6547  NH1 ARG F  65      37.469  36.682  12.042  1.00 32.43           N  
ATOM   6548  NH2 ARG F  65      37.130  34.496  12.532  1.00 27.29           N  
ATOM   6549  N   GLN F  66      36.829  39.627   5.226  1.00 37.82           N  
ATOM   6550  CA  GLN F  66      37.343  40.874   4.653  1.00 40.74           C  
ATOM   6551  C   GLN F  66      36.237  41.792   4.160  1.00 41.13           C  
ATOM   6552  O   GLN F  66      36.397  43.020   4.110  1.00 42.42           O  
ATOM   6553  CB  GLN F  66      38.338  40.579   3.527  1.00 41.14           C  
ATOM   6554  CG  GLN F  66      39.453  39.670   3.966  1.00 41.96           C  
ATOM   6555  CD  GLN F  66      40.419  39.300   2.867  1.00 41.36           C  
ATOM   6556  OE1 GLN F  66      40.275  39.718   1.715  1.00 42.45           O  
ATOM   6557  NE2 GLN F  66      41.425  38.505   3.223  1.00 42.37           N  
ATOM   6558  N   THR F  67      35.114  41.211   3.789  1.00 41.16           N  
ATOM   6559  CA  THR F  67      33.941  42.039   3.473  1.00 41.83           C  
ATOM   6560  C   THR F  67      33.466  42.766   4.740  1.00 42.09           C  
ATOM   6561  O   THR F  67      33.037  43.914   4.676  1.00 43.46           O  
ATOM   6562  CB  THR F  67      32.781  41.217   2.769  1.00 40.62           C  
ATOM   6563  OG1 THR F  67      33.198  40.833   1.446  1.00 38.56           O  
ATOM   6564  CG2 THR F  67      31.487  42.054   2.669  1.00 39.81           C  
ATOM   6565  N   THR F  68      33.599  42.114   5.881  1.00 41.80           N  
ATOM   6566  CA  THR F  68      33.025  42.596   7.127  1.00 42.42           C  
ATOM   6567  C   THR F  68      33.837  43.742   7.685  1.00 45.04           C  
ATOM   6568  O   THR F  68      33.283  44.668   8.269  1.00 44.70           O  
ATOM   6569  CB  THR F  68      32.928  41.444   8.163  1.00 41.76           C  
ATOM   6570  OG1 THR F  68      31.631  40.861   8.125  1.00 36.90           O  
ATOM   6571  CG2 THR F  68      33.209  41.907   9.559  1.00 42.26           C  
ATOM   6572  N   GLN F  69      35.150  43.674   7.486  1.00 48.01           N  
ATOM   6573  CA  GLN F  69      36.084  44.648   8.006  1.00 51.36           C  
ATOM   6574  C   GLN F  69      35.724  46.031   7.465  1.00 53.35           C  
ATOM   6575  O   GLN F  69      35.895  47.046   8.152  1.00 53.51           O  
ATOM   6576  CB  GLN F  69      37.522  44.237   7.662  1.00 52.38           C  
ATOM   6577  CG  GLN F  69      38.071  43.102   8.540  1.00 53.67           C  
ATOM   6578  CD  GLN F  69      39.198  42.283   7.895  1.00 56.56           C  
ATOM   6579  OE1 GLN F  69      39.947  42.775   7.058  1.00 61.01           O  
ATOM   6580  NE2 GLN F  69      39.326  41.031   8.304  1.00 57.00           N  
ATOM   6581  N   ALA F  70      35.186  46.056   6.244  1.00 55.16           N  
ATOM   6582  CA  ALA F  70      34.718  47.298   5.607  1.00 56.85           C  
ATOM   6583  C   ALA F  70      33.623  47.978   6.437  1.00 56.99           C  
ATOM   6584  O   ALA F  70      33.609  49.191   6.579  1.00 57.45           O  
ATOM   6585  CB  ALA F  70      34.222  47.021   4.178  1.00 56.58           C  
ATOM   6586  N   TRP F  71      32.716  47.181   6.989  1.00 56.45           N  
ATOM   6587  CA  TRP F  71      31.631  47.711   7.797  1.00 56.71           C  
ATOM   6588  C   TRP F  71      32.113  48.294   9.110  1.00 58.26           C  
ATOM   6589  O   TRP F  71      31.601  49.332   9.559  1.00 58.75           O  
ATOM   6590  CB  TRP F  71      30.541  46.656   7.979  1.00 55.66           C  
ATOM   6591  CG  TRP F  71      29.915  46.370   6.644  1.00 52.79           C  
ATOM   6592  CD1 TRP F  71      30.515  45.776   5.574  1.00 52.18           C  
ATOM   6593  CD2 TRP F  71      28.612  46.738   6.218  1.00 48.68           C  
ATOM   6594  NE1 TRP F  71      29.661  45.726   4.510  1.00 49.60           N  
ATOM   6595  CE2 TRP F  71      28.476  46.304   4.876  1.00 49.59           C  
ATOM   6596  CE3 TRP F  71      27.533  47.364   6.845  1.00 45.61           C  
ATOM   6597  CZ2 TRP F  71      27.303  46.476   4.148  1.00 45.88           C  
ATOM   6598  CZ3 TRP F  71      26.384  47.541   6.144  1.00 44.33           C  
ATOM   6599  CH2 TRP F  71      26.268  47.090   4.798  1.00 49.50           C  
ATOM   6600  N   GLN F  72      33.120  47.643   9.693  1.00 58.63           N  
ATOM   6601  CA  GLN F  72      33.805  48.133  10.878  1.00 59.78           C  
ATOM   6602  C   GLN F  72      34.466  49.495  10.637  1.00 61.04           C  
ATOM   6603  O   GLN F  72      34.639  50.276  11.573  1.00 61.49           O  
ATOM   6604  CB  GLN F  72      34.848  47.110  11.328  1.00 59.94           C  
ATOM   6605  CG  GLN F  72      34.272  45.796  11.788  1.00 59.50           C  
ATOM   6606  CD  GLN F  72      35.291  44.667  11.805  1.00 60.76           C  
ATOM   6607  OE1 GLN F  72      35.035  43.580  11.290  1.00 56.58           O  
ATOM   6608  NE2 GLN F  72      36.466  44.925  12.399  1.00 64.65           N  
ATOM   6609  N   ARG F  73      34.822  49.755   9.376  1.00 61.40           N  
ATOM   6610  CA  ARG F  73      35.547  50.943   8.938  1.00 62.75           C  
ATOM   6611  C   ARG F  73      34.626  52.091   8.680  1.00 62.79           C  
ATOM   6612  O   ARG F  73      35.058  53.243   8.637  1.00 64.13           O  
ATOM   6613  CB  ARG F  73      36.226  50.671   7.605  1.00 62.97           C  
ATOM   6614  CG  ARG F  73      37.652  50.292   7.691  1.00 64.81           C  
ATOM   6615  CD  ARG F  73      38.168  49.935   6.314  1.00 67.72           C  
ATOM   6616  NE  ARG F  73      39.477  49.309   6.421  1.00 70.98           N  
ATOM   6617  CZ  ARG F  73      39.678  48.048   6.796  1.00 71.78           C  
ATOM   6618  NH1 ARG F  73      38.650  47.266   7.074  1.00 69.79           N  
ATOM   6619  NH2 ARG F  73      40.916  47.566   6.885  1.00 74.22           N  
ATOM   6620  N   ALA F  74      33.368  51.759   8.428  1.00 61.14           N  
ATOM   6621  CA  ALA F  74      32.390  52.713   7.965  1.00 60.13           C  
ATOM   6622  C   ALA F  74      31.591  53.180   9.166  1.00 59.21           C  
ATOM   6623  O   ALA F  74      30.973  54.238   9.134  1.00 59.71           O  
ATOM   6624  CB  ALA F  74      31.482  52.065   6.905  1.00 58.73           C  
ATOM   6625  N   PHE F  75      31.632  52.385  10.229  1.00 57.42           N  
ATOM   6626  CA  PHE F  75      30.822  52.630  11.410  1.00 56.46           C  
ATOM   6627  C   PHE F  75      31.707  52.619  12.647  1.00 56.47           C  
ATOM   6628  O   PHE F  75      32.876  52.982  12.595  1.00 55.37           O  
ATOM   6629  CB  PHE F  75      29.704  51.565  11.562  1.00 56.37           C  
ATOM   6630  CG  PHE F  75      28.702  51.521  10.413  1.00 53.48           C  
ATOM   6631  CD1 PHE F  75      27.581  52.361  10.409  1.00 50.68           C  
ATOM   6632  CD2 PHE F  75      28.892  50.642   9.348  1.00 52.23           C  
ATOM   6633  CE1 PHE F  75      26.658  52.325   9.358  1.00 52.61           C  
ATOM   6634  CE2 PHE F  75      27.959  50.576   8.283  1.00 53.71           C  
ATOM   6635  CZ  PHE F  75      26.839  51.421   8.287  1.00 53.16           C  
ATOM   6636  N   GLY F  78      31.130  50.379  16.417  1.00 56.47           N  
ATOM   6637  CA  GLY F  78      30.331  50.072  17.599  1.00 55.96           C  
ATOM   6638  C   GLY F  78      29.647  48.731  17.471  1.00 54.01           C  
ATOM   6639  O   GLY F  78      29.021  48.258  18.424  1.00 53.99           O  
ATOM   6640  N   ILE F  79      29.811  48.110  16.299  1.00 52.22           N  
ATOM   6641  CA  ILE F  79      28.984  46.950  15.844  1.00 49.71           C  
ATOM   6642  C   ILE F  79      29.397  45.517  16.310  1.00 47.64           C  
ATOM   6643  O   ILE F  79      30.370  44.941  15.832  1.00 45.58           O  
ATOM   6644  CB  ILE F  79      28.754  46.968  14.278  1.00 48.91           C  
ATOM   6645  CG1 ILE F  79      30.080  46.892  13.525  1.00 49.39           C  
ATOM   6646  CG2 ILE F  79      27.966  48.195  13.828  1.00 47.95           C  
ATOM   6647  CD1 ILE F  79      30.673  48.219  13.107  1.00 54.93           C  
ATOM   6648  N   ASP F  80      28.614  44.945  17.212  1.00 46.38           N  
ATOM   6649  CA  ASP F  80      28.777  43.552  17.586  1.00 45.59           C  
ATOM   6650  C   ASP F  80      28.985  42.671  16.334  1.00 43.65           C  
ATOM   6651  O   ASP F  80      28.189  42.709  15.381  1.00 41.66           O  
ATOM   6652  CB  ASP F  80      27.583  43.059  18.416  1.00 45.66           C  
ATOM   6653  CG  ASP F  80      27.295  43.930  19.666  1.00 48.31           C  
ATOM   6654  OD1 ASP F  80      27.939  44.993  19.845  1.00 49.64           O  
ATOM   6655  OD2 ASP F  80      26.398  43.541  20.477  1.00 47.03           O  
ATOM   6656  N   ILE F  81      30.070  41.889  16.360  1.00 43.32           N  
ATOM   6657  CA  ILE F  81      30.517  41.062  15.217  1.00 42.25           C  
ATOM   6658  C   ILE F  81      31.000  39.698  15.679  1.00 40.46           C  
ATOM   6659  O   ILE F  81      32.019  39.590  16.371  1.00 41.35           O  
ATOM   6660  CB  ILE F  81      31.653  41.757  14.370  1.00 43.58           C  
ATOM   6661  CG1 ILE F  81      31.210  43.136  13.911  1.00 44.42           C  
ATOM   6662  CG2 ILE F  81      32.039  40.917  13.136  1.00 43.37           C  
ATOM   6663  CD1 ILE F  81      31.893  43.598  12.679  1.00 50.76           C  
ATOM   6664  N   VAL F  82      30.267  38.662  15.286  1.00 37.77           N  
ATOM   6665  CA  VAL F  82      30.589  37.299  15.661  1.00 36.29           C  
ATOM   6666  C   VAL F  82      30.834  36.346  14.434  1.00 34.38           C  
ATOM   6667  O   VAL F  82      30.127  36.412  13.411  1.00 31.54           O  
ATOM   6668  CB  VAL F  82      29.509  36.736  16.585  1.00 36.34           C  
ATOM   6669  CG1 VAL F  82      29.145  37.710  17.655  1.00 36.33           C  
ATOM   6670  CG2 VAL F  82      28.269  36.508  15.793  1.00 41.60           C  
ATOM   6671  N   TYR F  83      31.827  35.446  14.541  1.00 33.26           N  
ATOM   6672  CA  TYR F  83      32.097  34.566  13.386  1.00 32.72           C  
ATOM   6673  C   TYR F  83      31.589  33.136  13.502  1.00 32.22           C  
ATOM   6674  O   TYR F  83      31.668  32.515  14.550  1.00 31.83           O  
ATOM   6675  CB  TYR F  83      33.546  34.659  12.906  1.00 32.35           C  
ATOM   6676  CG  TYR F  83      33.928  36.050  12.493  1.00 30.61           C  
ATOM   6677  CD1 TYR F  83      33.750  36.492  11.182  1.00 30.90           C  
ATOM   6678  CD2 TYR F  83      34.451  36.944  13.420  1.00 31.09           C  
ATOM   6679  CE1 TYR F  83      34.111  37.788  10.808  1.00 32.90           C  
ATOM   6680  CE2 TYR F  83      34.822  38.235  13.052  1.00 31.42           C  
ATOM   6681  CZ  TYR F  83      34.645  38.648  11.764  1.00 31.85           C  
ATOM   6682  OH  TYR F  83      35.012  39.934  11.434  1.00 38.50           O  
ATOM   6683  N   ILE F  84      30.994  32.668  12.408  1.00 32.43           N  
ATOM   6684  CA  ILE F  84      30.215  31.426  12.395  1.00 31.60           C  
ATOM   6685  C   ILE F  84      30.622  30.582  11.227  1.00 33.25           C  
ATOM   6686  O   ILE F  84      30.241  30.882  10.088  1.00 30.02           O  
ATOM   6687  CB  ILE F  84      28.688  31.688  12.302  1.00 31.87           C  
ATOM   6688  CG1 ILE F  84      28.258  32.713  13.375  1.00 27.65           C  
ATOM   6689  CG2 ILE F  84      27.895  30.332  12.231  1.00 25.33           C  
ATOM   6690  CD1 ILE F  84      26.865  32.638  13.790  1.00 24.24           C  
ATOM   6691  N   ASP F  85      31.419  29.551  11.544  1.00 35.77           N  
ATOM   6692  CA  ASP F  85      32.064  28.715  10.568  1.00 40.77           C  
ATOM   6693  C   ASP F  85      31.016  27.904   9.816  1.00 43.13           C  
ATOM   6694  O   ASP F  85      31.201  27.715   8.619  1.00 43.33           O  
ATOM   6695  CB  ASP F  85      33.094  27.789  11.233  1.00 41.42           C  
ATOM   6696  CG  ASP F  85      34.334  27.533  10.355  1.00 45.58           C  
ATOM   6697  OD1 ASP F  85      35.261  28.365  10.407  1.00 49.52           O  
ATOM   6698  OD2 ASP F  85      34.419  26.497   9.629  1.00 47.92           O  
ATOM   6699  N   GLU F  86      29.933  27.464  10.515  1.00 45.74           N  
ATOM   6700  CA  GLU F  86      28.825  26.663   9.935  1.00 48.58           C  
ATOM   6701  C   GLU F  86      28.040  27.464   8.873  1.00 48.68           C  
ATOM   6702  O   GLU F  86      27.160  26.920   8.210  1.00 48.99           O  
ATOM   6703  CB  GLU F  86      27.865  25.998  11.008  1.00 49.12           C  
ATOM   6704  CG  GLU F  86      28.098  24.411  11.320  1.00 53.64           C  
ATOM   6705  CD  GLU F  86      26.936  23.631  12.132  1.00 56.65           C  
ATOM   6706  OE1 GLU F  86      25.804  23.412  11.622  1.00 56.75           O  
ATOM   6707  OE2 GLU F  86      27.174  23.183  13.279  1.00 54.22           O  
HETATM 6708  N   MSE F  87      28.385  28.744   8.711  1.00 48.83           N  
HETATM 6709  CA  MSE F  87      27.813  29.597   7.665  1.00 48.56           C  
HETATM 6710  C   MSE F  87      28.587  29.446   6.334  1.00 48.52           C  
HETATM 6711  O   MSE F  87      28.066  29.771   5.255  1.00 47.72           O  
HETATM 6712  CB  MSE F  87      27.823  31.074   8.085  1.00 48.83           C  
HETATM 6713  CG  MSE F  87      26.927  31.464   9.248  1.00 48.25           C  
HETATM 6714 SE   MSE F  87      26.945  33.423   9.576  1.00 51.86          SE  
HETATM 6715  CE  MSE F  87      25.840  33.974   8.093  1.00 46.50           C  
ATOM   6716  N   TYR F  88      29.836  29.006   6.422  1.00 47.81           N  
ATOM   6717  CA  TYR F  88      30.557  28.594   5.238  1.00 48.43           C  
ATOM   6718  C   TYR F  88      30.085  27.209   4.842  1.00 48.77           C  
ATOM   6719  O   TYR F  88      30.091  26.290   5.652  1.00 48.34           O  
ATOM   6720  CB  TYR F  88      32.074  28.593   5.453  1.00 48.36           C  
ATOM   6721  CG  TYR F  88      32.839  28.145   4.215  1.00 47.18           C  
ATOM   6722  CD1 TYR F  88      32.953  28.981   3.103  1.00 45.55           C  
ATOM   6723  CD2 TYR F  88      33.453  26.897   4.155  1.00 45.36           C  
ATOM   6724  CE1 TYR F  88      33.642  28.584   1.975  1.00 43.48           C  
ATOM   6725  CE2 TYR F  88      34.164  26.493   3.017  1.00 44.61           C  
ATOM   6726  CZ  TYR F  88      34.249  27.339   1.925  1.00 43.25           C  
ATOM   6727  OH  TYR F  88      34.943  26.960   0.785  1.00 37.60           O  
ATOM   6728  N   ASN F  89      29.696  27.060   3.583  1.00 50.07           N  
ATOM   6729  CA  ASN F  89      29.146  25.795   3.093  1.00 51.30           C  
ATOM   6730  C   ASN F  89      28.167  25.204   4.095  1.00 51.12           C  
ATOM   6731  O   ASN F  89      28.478  24.194   4.767  1.00 51.26           O  
ATOM   6732  CB  ASN F  89      30.255  24.764   2.769  1.00 51.78           C  
ATOM   6733  CG  ASN F  89      29.683  23.443   2.275  1.00 51.41           C  
ATOM   6734  OD1 ASN F  89      28.925  23.419   1.301  1.00 49.48           O  
ATOM   6735  ND2 ASN F  89      30.012  22.343   2.965  1.00 47.27           N  
ATOM   6736  N   ALA F  90      27.003  25.834   4.217  1.00 51.11           N  
ATOM   6737  CA  ALA F  90      26.075  25.451   5.295  1.00 51.82           C  
ATOM   6738  C   ALA F  90      25.385  24.096   5.088  1.00 52.59           C  
ATOM   6739  O   ALA F  90      25.250  23.598   3.962  1.00 52.63           O  
ATOM   6740  CB  ALA F  90      25.065  26.553   5.584  1.00 50.77           C  
ATOM   6741  N   ARG F  91      24.971  23.497   6.202  1.00 53.47           N  
ATOM   6742  CA  ARG F  91      24.167  22.284   6.154  1.00 54.42           C  
ATOM   6743  C   ARG F  91      22.729  22.717   5.939  1.00 53.28           C  
ATOM   6744  O   ARG F  91      21.860  21.913   5.579  1.00 53.69           O  
ATOM   6745  CB  ARG F  91      24.336  21.447   7.429  1.00 54.56           C  
ATOM   6746  CG  ARG F  91      23.727  22.054   8.684  1.00 56.42           C  
ATOM   6747  CD  ARG F  91      23.888  21.091   9.869  1.00 62.82           C  
ATOM   6748  NE  ARG F  91      22.877  21.307  10.910  1.00 63.33           N  
ATOM   6749  CZ  ARG F  91      22.398  20.356  11.708  1.00 64.09           C  
ATOM   6750  NH1 ARG F  91      22.811  19.095  11.601  1.00 64.18           N  
ATOM   6751  NH2 ARG F  91      21.483  20.672  12.609  1.00 64.68           N  
ATOM   6752  N   SER F  92      22.518  24.017   6.144  1.00 51.90           N  
ATOM   6753  CA  SER F  92      21.215  24.646   6.089  1.00 50.01           C  
ATOM   6754  C   SER F  92      20.884  25.082   4.700  1.00 48.88           C  
ATOM   6755  O   SER F  92      21.737  25.607   3.999  1.00 49.52           O  
ATOM   6756  CB  SER F  92      21.204  25.880   6.969  1.00 49.84           C  
ATOM   6757  OG  SER F  92      21.108  25.505   8.316  1.00 51.58           O  
ATOM   6758  N   GLU F  93      19.631  24.877   4.304  1.00 46.85           N  
ATOM   6759  CA  GLU F  93      19.098  25.524   3.116  1.00 44.53           C  
ATOM   6760  C   GLU F  93      19.151  27.062   3.214  1.00 41.88           C  
ATOM   6761  O   GLU F  93      19.461  27.751   2.228  1.00 40.72           O  
ATOM   6762  CB  GLU F  93      17.658  25.074   2.880  1.00 45.00           C  
ATOM   6763  CG  GLU F  93      17.155  25.386   1.511  1.00 45.32           C  
ATOM   6764  CD  GLU F  93      15.787  24.845   1.298  1.00 49.95           C  
ATOM   6765  OE1 GLU F  93      15.682  23.863   0.549  1.00 52.48           O  
ATOM   6766  OE2 GLU F  93      14.813  25.381   1.881  1.00 52.45           O  
ATOM   6767  N   THR F  94      18.844  27.568   4.402  1.00 39.32           N  
ATOM   6768  CA  THR F  94      18.619  28.989   4.642  1.00 38.67           C  
ATOM   6769  C   THR F  94      19.373  29.437   5.874  1.00 36.00           C  
ATOM   6770  O   THR F  94      19.811  28.592   6.625  1.00 36.65           O  
ATOM   6771  CB  THR F  94      17.131  29.234   4.820  1.00 39.41           C  
ATOM   6772  OG1 THR F  94      16.498  29.076   3.525  1.00 46.30           O  
ATOM   6773  CG2 THR F  94      16.899  30.606   5.231  1.00 39.50           C  
ATOM   6774  N   TYR F  95      19.568  30.758   6.049  1.00 34.43           N  
ATOM   6775  CA  TYR F  95      20.069  31.390   7.310  1.00 30.69           C  
ATOM   6776  C   TYR F  95      18.921  31.833   8.212  1.00 29.83           C  
ATOM   6777  O   TYR F  95      19.128  32.503   9.170  1.00 28.80           O  
ATOM   6778  CB  TYR F  95      20.998  32.585   7.079  1.00 28.96           C  
ATOM   6779  CG  TYR F  95      22.307  32.283   6.368  1.00 27.86           C  
ATOM   6780  CD1 TYR F  95      23.259  31.391   6.893  1.00 27.75           C  
ATOM   6781  CD2 TYR F  95      22.601  32.904   5.178  1.00 24.30           C  
ATOM   6782  CE1 TYR F  95      24.423  31.122   6.198  1.00 25.24           C  
ATOM   6783  CE2 TYR F  95      23.746  32.658   4.496  1.00 24.67           C  
ATOM   6784  CZ  TYR F  95      24.653  31.780   4.990  1.00 26.59           C  
ATOM   6785  OH  TYR F  95      25.778  31.596   4.230  1.00 28.99           O  
ATOM   6786  N   LEU F  96      17.703  31.432   7.924  1.00 29.35           N  
ATOM   6787  CA  LEU F  96      16.595  31.884   8.719  1.00 30.48           C  
ATOM   6788  C   LEU F  96      16.802  31.876  10.235  1.00 30.64           C  
ATOM   6789  O   LEU F  96      16.535  32.831  10.885  1.00 30.65           O  
ATOM   6790  CB  LEU F  96      15.322  31.123   8.355  1.00 30.14           C  
ATOM   6791  CG  LEU F  96      14.375  32.066   7.628  1.00 32.64           C  
ATOM   6792  CD1 LEU F  96      13.849  32.976   8.748  1.00 39.50           C  
ATOM   6793  CD2 LEU F  96      15.026  32.906   6.537  1.00 25.73           C  
ATOM   6794  N   SER F  97      17.277  30.780  10.775  1.00 31.49           N  
ATOM   6795  CA  SER F  97      17.206  30.575  12.190  1.00 32.81           C  
ATOM   6796  C   SER F  97      18.245  31.398  12.919  1.00 32.04           C  
ATOM   6797  O   SER F  97      18.035  31.733  14.078  1.00 31.49           O  
ATOM   6798  CB  SER F  97      17.280  29.072  12.497  1.00 32.72           C  
ATOM   6799  OG  SER F  97      16.134  28.454  11.918  1.00 35.89           O  
ATOM   6800  N   LEU F  98      19.340  31.745  12.222  1.00 30.95           N  
ATOM   6801  CA  LEU F  98      20.294  32.705  12.749  1.00 30.22           C  
ATOM   6802  C   LEU F  98      19.650  34.071  13.047  1.00 30.14           C  
ATOM   6803  O   LEU F  98      20.023  34.722  14.031  1.00 29.60           O  
ATOM   6804  CB  LEU F  98      21.472  32.886  11.793  1.00 30.74           C  
ATOM   6805  CG  LEU F  98      22.642  31.887  11.799  1.00 31.28           C  
ATOM   6806  CD1 LEU F  98      23.549  32.207  10.629  1.00 31.97           C  
ATOM   6807  CD2 LEU F  98      23.445  31.882  13.111  1.00 31.78           C  
ATOM   6808  N   ILE F  99      18.686  34.475  12.198  1.00 28.59           N  
ATOM   6809  CA  ILE F  99      18.042  35.760  12.296  1.00 27.63           C  
ATOM   6810  C   ILE F  99      17.135  35.697  13.467  1.00 28.98           C  
ATOM   6811  O   ILE F  99      17.246  36.487  14.406  1.00 29.69           O  
ATOM   6812  CB  ILE F  99      17.068  36.100  11.089  1.00 26.73           C  
ATOM   6813  CG1 ILE F  99      17.817  36.704   9.896  1.00 25.06           C  
ATOM   6814  CG2 ILE F  99      15.940  37.048  11.573  1.00 19.96           C  
ATOM   6815  CD1 ILE F  99      17.784  35.843   8.624  1.00 21.82           C  
ATOM   6816  N   ALA F 100      16.211  34.748  13.347  1.00 28.89           N  
ATOM   6817  CA  ALA F 100      15.058  34.629  14.156  1.00 29.43           C  
ATOM   6818  C   ALA F 100      15.447  34.396  15.587  1.00 29.29           C  
ATOM   6819  O   ALA F 100      14.763  34.805  16.460  1.00 30.63           O  
ATOM   6820  CB  ALA F 100      14.185  33.484  13.613  1.00 29.21           C  
ATOM   6821  N   ALA F 101      16.570  33.755  15.828  1.00 29.98           N  
ATOM   6822  CA  ALA F 101      17.029  33.552  17.179  1.00 31.11           C  
ATOM   6823  C   ALA F 101      17.542  34.791  17.911  1.00 31.82           C  
ATOM   6824  O   ALA F 101      17.811  34.682  19.065  1.00 31.70           O  
ATOM   6825  CB  ALA F 101      18.064  32.522  17.203  1.00 31.12           C  
ATOM   6826  N   GLN F 102      17.749  35.933  17.260  1.00 32.42           N  
ATOM   6827  CA  GLN F 102      18.361  37.053  17.984  1.00 34.34           C  
ATOM   6828  C   GLN F 102      17.274  37.960  18.509  1.00 37.29           C  
ATOM   6829  O   GLN F 102      17.049  39.055  17.955  1.00 36.62           O  
ATOM   6830  CB  GLN F 102      19.371  37.842  17.139  1.00 32.79           C  
ATOM   6831  CG  GLN F 102      20.455  37.062  16.439  1.00 27.85           C  
ATOM   6832  CD  GLN F 102      21.149  36.026  17.305  1.00 22.43           C  
ATOM   6833  OE1 GLN F 102      21.426  36.259  18.457  1.00 16.40           O  
ATOM   6834  NE2 GLN F 102      21.436  34.864  16.719  1.00 20.48           N  
ATOM   6835  N   THR F 103      16.695  37.528  19.629  0.50 39.26           N  
ATOM   6837  CA  THR F 103      15.394  37.965  20.110  0.50 42.33           C  
ATOM   6839  C   THR F 103      15.457  39.266  20.911  0.50 43.98           C  
ATOM   6841  O   THR F 103      14.428  39.865  21.218  0.50 45.29           O  
ATOM   6843  CB  THR F 103      14.683  36.779  20.872  0.50 42.80           C  
ATOM   6845  OG1 THR F 103      13.928  35.996  19.931  0.50 42.02           O  
ATOM   6847  CG2 THR F 103      13.763  37.250  22.023  0.50 42.72           C  
ATOM   6849  N   GLU F 104      16.670  39.711  21.220  0.50 44.77           N  
ATOM   6851  CA  GLU F 104      16.874  40.969  21.933  0.50 45.63           C  
ATOM   6853  C   GLU F 104      17.720  41.962  21.126  0.50 45.14           C  
ATOM   6855  O   GLU F 104      18.223  42.954  21.651  0.50 45.95           O  
ATOM   6857  CB  GLU F 104      17.502  40.691  23.284  0.50 46.34           C  
ATOM   6859  CG  GLU F 104      16.756  39.640  24.087  0.50 45.54           C  
ATOM   6861  CD  GLU F 104      15.706  40.231  24.960  0.50 44.95           C  
ATOM   6863  OE1 GLU F 104      15.858  41.403  25.333  0.50 44.10           O  
ATOM   6865  OE2 GLU F 104      14.734  39.525  25.287  0.50 46.42           O  
ATOM   6867  N   VAL F 105      17.857  41.690  19.836  1.00 43.42           N  
ATOM   6868  CA  VAL F 105      18.562  42.577  18.937  1.00 41.64           C  
ATOM   6869  C   VAL F 105      17.542  43.200  17.968  1.00 41.29           C  
ATOM   6870  O   VAL F 105      16.694  42.530  17.379  1.00 40.47           O  
ATOM   6871  CB  VAL F 105      19.733  41.832  18.233  1.00 40.66           C  
ATOM   6872  CG1 VAL F 105      20.409  42.698  17.278  1.00 38.25           C  
ATOM   6873  CG2 VAL F 105      20.761  41.295  19.293  1.00 39.31           C  
ATOM   6874  N   GLN F 106      17.574  44.506  17.819  1.00 40.65           N  
ATOM   6875  CA  GLN F 106      16.545  45.072  16.977  1.00 39.48           C  
ATOM   6876  C   GLN F 106      16.882  44.856  15.516  1.00 36.48           C  
ATOM   6877  O   GLN F 106      16.005  44.543  14.750  1.00 35.76           O  
ATOM   6878  CB  GLN F 106      16.252  46.515  17.346  1.00 40.77           C  
ATOM   6879  CG  GLN F 106      15.449  47.266  16.338  1.00 42.67           C  
ATOM   6880  CD  GLN F 106      15.474  48.705  16.688  1.00 47.14           C  
ATOM   6881  OE1 GLN F 106      16.040  49.077  17.715  1.00 47.25           O  
ATOM   6882  NE2 GLN F 106      14.843  49.536  15.863  1.00 52.16           N  
ATOM   6883  N   SER F 107      18.157  44.925  15.170  1.00 34.88           N  
ATOM   6884  CA  SER F 107      18.587  44.605  13.803  1.00 33.76           C  
ATOM   6885  C   SER F 107      19.854  43.763  13.650  1.00 32.17           C  
ATOM   6886  O   SER F 107      20.822  43.931  14.369  1.00 30.94           O  
ATOM   6887  CB  SER F 107      18.670  45.857  12.921  1.00 34.00           C  
ATOM   6888  OG  SER F 107      19.771  46.644  13.279  1.00 32.84           O  
ATOM   6889  N   VAL F 108      19.809  42.863  12.675  1.00 31.65           N  
ATOM   6890  CA  VAL F 108      20.885  41.893  12.442  1.00 32.05           C  
ATOM   6891  C   VAL F 108      21.257  41.775  10.954  1.00 31.15           C  
ATOM   6892  O   VAL F 108      20.418  41.850  10.091  1.00 31.38           O  
ATOM   6893  CB  VAL F 108      20.630  40.508  13.217  1.00 31.73           C  
ATOM   6894  CG1 VAL F 108      19.168  40.104  13.197  1.00 32.33           C  
ATOM   6895  CG2 VAL F 108      21.507  39.373  12.740  1.00 30.36           C  
HETATM 6896  N   MSE F 109      22.536  41.668  10.670  1.00 31.33           N  
HETATM 6897  CA  MSE F 109      22.986  41.421   9.313  1.00 31.90           C  
HETATM 6898  C   MSE F 109      23.752  40.091   9.245  1.00 31.43           C  
HETATM 6899  O   MSE F 109      24.436  39.733  10.197  1.00 30.80           O  
HETATM 6900  CB  MSE F 109      23.839  42.596   8.823  1.00 32.06           C  
HETATM 6901  CG  MSE F 109      24.768  42.306   7.681  1.00 35.99           C  
HETATM 6902 SE   MSE F 109      25.486  43.970   6.928  1.00 48.59          SE  
HETATM 6903  CE  MSE F 109      27.393  43.612   7.200  1.00 48.60           C  
ATOM   6904  N   LEU F 110      23.596  39.361   8.127  1.00 30.86           N  
ATOM   6905  CA  LEU F 110      24.474  38.208   7.795  1.00 29.01           C  
ATOM   6906  C   LEU F 110      25.350  38.440   6.556  1.00 28.13           C  
ATOM   6907  O   LEU F 110      24.886  38.890   5.479  1.00 23.92           O  
ATOM   6908  CB  LEU F 110      23.681  36.940   7.570  1.00 28.76           C  
ATOM   6909  CG  LEU F 110      22.428  36.835   8.391  1.00 28.69           C  
ATOM   6910  CD1 LEU F 110      21.451  36.069   7.626  1.00 27.93           C  
ATOM   6911  CD2 LEU F 110      22.710  36.203   9.736  1.00 32.19           C  
ATOM   6912  N   VAL F 111      26.635  38.143   6.751  1.00 27.76           N  
ATOM   6913  CA  VAL F 111      27.565  38.029   5.630  1.00 27.98           C  
ATOM   6914  C   VAL F 111      27.813  36.560   5.319  1.00 28.11           C  
ATOM   6915  O   VAL F 111      28.461  35.848   6.089  1.00 27.54           O  
ATOM   6916  CB  VAL F 111      28.848  38.848   5.880  1.00 28.55           C  
ATOM   6917  CG1 VAL F 111      29.733  38.853   4.655  1.00 28.70           C  
ATOM   6918  CG2 VAL F 111      28.441  40.281   6.197  1.00 28.34           C  
ATOM   6919  N   GLY F 112      27.244  36.087   4.219  1.00 28.02           N  
ATOM   6920  CA  GLY F 112      27.529  34.737   3.760  1.00 29.77           C  
ATOM   6921  C   GLY F 112      27.556  34.436   2.274  1.00 31.29           C  
ATOM   6922  O   GLY F 112      27.890  35.273   1.431  1.00 31.12           O  
ATOM   6923  N   HIS F 113      27.187  33.197   1.972  1.00 33.30           N  
ATOM   6924  CA  HIS F 113      27.452  32.571   0.669  1.00 35.23           C  
ATOM   6925  C   HIS F 113      26.179  32.244  -0.057  1.00 36.38           C  
ATOM   6926  O   HIS F 113      25.097  32.210   0.551  1.00 35.59           O  
ATOM   6927  CB  HIS F 113      28.244  31.292   0.881  1.00 35.26           C  
ATOM   6928  CG  HIS F 113      29.497  31.497   1.658  1.00 34.57           C  
ATOM   6929  ND1 HIS F 113      30.665  31.944   1.078  1.00 37.55           N  
ATOM   6930  CD2 HIS F 113      29.755  31.371   2.979  1.00 33.84           C  
ATOM   6931  CE1 HIS F 113      31.599  32.052   2.007  1.00 38.20           C  
ATOM   6932  NE2 HIS F 113      31.075  31.699   3.169  1.00 36.97           N  
ATOM   6933  N   ASN F 114      26.288  32.073  -1.367  1.00 38.06           N  
ATOM   6934  CA  ASN F 114      25.271  31.305  -2.075  1.00 39.62           C  
ATOM   6935  C   ASN F 114      25.592  29.808  -1.994  1.00 40.64           C  
ATOM   6936  O   ASN F 114      26.758  29.429  -1.803  1.00 41.20           O  
ATOM   6937  CB  ASN F 114      25.117  31.777  -3.513  1.00 40.52           C  
ATOM   6938  CG  ASN F 114      24.347  33.066  -3.615  1.00 39.76           C  
ATOM   6939  OD1 ASN F 114      23.718  33.511  -2.653  1.00 39.41           O  
ATOM   6940  ND2 ASN F 114      24.404  33.686  -4.776  1.00 38.59           N  
ATOM   6941  N   PRO F 115      24.575  28.944  -2.134  1.00 40.72           N  
ATOM   6942  CA  PRO F 115      23.169  29.199  -2.425  1.00 40.11           C  
ATOM   6943  C   PRO F 115      22.325  29.783  -1.282  1.00 38.85           C  
ATOM   6944  O   PRO F 115      21.179  30.209  -1.496  1.00 37.21           O  
ATOM   6945  CB  PRO F 115      22.658  27.804  -2.835  1.00 40.15           C  
ATOM   6946  CG  PRO F 115      23.480  26.891  -2.083  1.00 41.01           C  
ATOM   6947  CD  PRO F 115      24.856  27.502  -2.066  1.00 40.90           C  
ATOM   6948  N   THR F 116      22.897  29.778  -0.087  1.00 38.89           N  
ATOM   6949  CA  THR F 116      22.165  30.033   1.145  1.00 38.12           C  
ATOM   6950  C   THR F 116      21.652  31.458   1.295  1.00 39.36           C  
ATOM   6951  O   THR F 116      20.507  31.653   1.715  1.00 39.39           O  
ATOM   6952  CB  THR F 116      23.015  29.649   2.346  1.00 37.11           C  
ATOM   6953  OG1 THR F 116      23.815  28.505   1.998  1.00 36.08           O  
ATOM   6954  CG2 THR F 116      22.125  29.327   3.535  1.00 32.91           C  
HETATM 6955  N   MSE F 117      22.484  32.437   0.943  1.00 40.58           N  
HETATM 6956  CA  MSE F 117      22.089  33.837   0.966  1.00 41.71           C  
HETATM 6957  C   MSE F 117      20.839  33.972   0.135  1.00 41.79           C  
HETATM 6958  O   MSE F 117      19.801  34.312   0.671  1.00 41.29           O  
HETATM 6959  CB  MSE F 117      23.235  34.753   0.490  1.00 42.07           C  
HETATM 6960  CG  MSE F 117      23.374  36.142   1.164  1.00 43.71           C  
HETATM 6961 SE   MSE F 117      22.800  36.385   3.039  0.85 51.22          SE  
HETATM 6962  CE  MSE F 117      24.472  36.152   3.897  1.00 50.52           C  
ATOM   6963  N   GLU F 118      20.929  33.618  -1.153  1.00 43.11           N  
ATOM   6964  CA  GLU F 118      19.825  33.721  -2.145  1.00 42.87           C  
ATOM   6965  C   GLU F 118      18.567  33.022  -1.646  1.00 41.49           C  
ATOM   6966  O   GLU F 118      17.465  33.556  -1.740  1.00 41.92           O  
ATOM   6967  CB  GLU F 118      20.259  33.066  -3.447  1.00 44.01           C  
ATOM   6968  CG  GLU F 118      20.197  33.898  -4.719  1.00 46.55           C  
ATOM   6969  CD  GLU F 118      20.716  33.076  -5.935  1.00 53.70           C  
ATOM   6970  OE1 GLU F 118      21.054  31.880  -5.777  1.00 53.90           O  
ATOM   6971  OE2 GLU F 118      20.804  33.607  -7.060  1.00 58.87           O  
ATOM   6972  N   ALA F 119      18.748  31.834  -1.088  1.00 39.20           N  
ATOM   6973  CA  ALA F 119      17.671  31.070  -0.513  1.00 37.84           C  
ATOM   6974  C   ALA F 119      17.089  31.690   0.770  1.00 36.13           C  
ATOM   6975  O   ALA F 119      15.948  31.486   1.083  1.00 36.40           O  
ATOM   6976  CB  ALA F 119      18.129  29.626  -0.267  1.00 38.01           C  
ATOM   6977  N   THR F 120      17.864  32.445   1.518  1.00 35.20           N  
ATOM   6978  CA  THR F 120      17.316  33.133   2.685  1.00 32.86           C  
ATOM   6979  C   THR F 120      16.408  34.213   2.161  1.00 34.14           C  
ATOM   6980  O   THR F 120      15.263  34.366   2.589  1.00 34.69           O  
ATOM   6981  CB  THR F 120      18.426  33.713   3.580  1.00 32.78           C  
ATOM   6982  OG1 THR F 120      19.416  32.684   3.860  1.00 28.08           O  
ATOM   6983  CG2 THR F 120      17.819  34.327   4.921  1.00 28.05           C  
ATOM   6984  N   LEU F 121      16.877  34.935   1.165  1.00 33.93           N  
ATOM   6985  CA  LEU F 121      16.043  35.983   0.672  1.00 35.31           C  
ATOM   6986  C   LEU F 121      14.710  35.417   0.218  1.00 35.26           C  
ATOM   6987  O   LEU F 121      13.644  35.917   0.584  1.00 34.22           O  
ATOM   6988  CB  LEU F 121      16.712  36.713  -0.487  1.00 35.50           C  
ATOM   6989  CG  LEU F 121      16.635  38.205  -0.305  1.00 37.16           C  
ATOM   6990  CD1 LEU F 121      16.283  38.692  -1.647  1.00 42.60           C  
ATOM   6991  CD2 LEU F 121      15.589  38.657   0.756  1.00 33.20           C  
ATOM   6992  N   GLU F 122      14.809  34.377  -0.599  1.00 36.14           N  
ATOM   6993  CA  GLU F 122      13.690  33.853  -1.334  1.00 37.52           C  
ATOM   6994  C   GLU F 122      12.557  33.412  -0.381  1.00 36.19           C  
ATOM   6995  O   GLU F 122      11.382  33.695  -0.635  1.00 36.05           O  
ATOM   6996  CB  GLU F 122      14.188  32.709  -2.226  1.00 38.94           C  
ATOM   6997  CG  GLU F 122      13.214  32.282  -3.306  1.00 44.76           C  
ATOM   6998  CD  GLU F 122      13.743  31.109  -4.107  1.00 53.35           C  
ATOM   6999  OE1 GLU F 122      14.974  31.013  -4.312  1.00 54.45           O  
ATOM   7000  OE2 GLU F 122      12.925  30.259  -4.541  1.00 59.84           O  
ATOM   7001  N   ALA F 123      12.935  32.749   0.709  1.00 34.16           N  
ATOM   7002  CA  ALA F 123      12.011  32.284   1.728  1.00 33.85           C  
ATOM   7003  C   ALA F 123      11.285  33.427   2.437  1.00 33.91           C  
ATOM   7004  O   ALA F 123      10.115  33.288   2.803  1.00 33.12           O  
ATOM   7005  CB  ALA F 123      12.760  31.418   2.752  1.00 33.94           C  
HETATM 7006  N   MSE F 124      12.008  34.536   2.642  1.00 33.62           N  
HETATM 7007  CA  MSE F 124      11.488  35.790   3.201  1.00 33.65           C  
HETATM 7008  C   MSE F 124      10.596  36.621   2.259  1.00 34.47           C  
HETATM 7009  O   MSE F 124       9.692  37.308   2.738  1.00 34.47           O  
HETATM 7010  CB  MSE F 124      12.637  36.676   3.612  1.00 33.07           C  
HETATM 7011  CG  MSE F 124      13.678  36.018   4.540  1.00 35.67           C  
HETATM 7012 SE   MSE F 124      15.002  37.316   5.121  0.80 43.11          SE  
HETATM 7013  CE  MSE F 124      14.121  38.163   6.612  1.00 38.27           C  
ATOM   7014  N   ILE F 125      10.843  36.623   0.945  1.00 34.65           N  
ATOM   7015  CA  ILE F 125      10.026  37.506   0.050  1.00 35.78           C  
ATOM   7016  C   ILE F 125       9.145  36.848  -1.041  1.00 37.80           C  
ATOM   7017  O   ILE F 125       8.122  37.434  -1.462  1.00 37.47           O  
ATOM   7018  CB  ILE F 125      10.800  38.731  -0.527  1.00 34.59           C  
ATOM   7019  CG1 ILE F 125      11.824  38.319  -1.576  1.00 33.26           C  
ATOM   7020  CG2 ILE F 125      11.360  39.597   0.604  1.00 35.00           C  
ATOM   7021  CD1 ILE F 125      12.714  39.494  -2.108  1.00 30.86           C  
ATOM   7022  N   GLY F 126       9.539  35.645  -1.465  1.00 39.56           N  
ATOM   7023  CA  GLY F 126       8.863  34.920  -2.535  1.00 43.64           C  
ATOM   7024  C   GLY F 126       9.652  34.910  -3.830  1.00 46.13           C  
ATOM   7025  O   GLY F 126      10.426  35.833  -4.101  1.00 45.55           O  
ATOM   7026  N   GLU F 127       9.433  33.888  -4.655  1.00 49.30           N  
ATOM   7027  CA  GLU F 127      10.246  33.730  -5.857  1.00 52.80           C  
ATOM   7028  C   GLU F 127      10.011  34.760  -6.952  1.00 54.14           C  
ATOM   7029  O   GLU F 127      10.997  35.285  -7.482  1.00 54.18           O  
ATOM   7030  CB  GLU F 127      10.205  32.321  -6.400  1.00 53.83           C  
ATOM   7031  CG  GLU F 127       8.847  31.709  -6.324  1.00 58.62           C  
ATOM   7032  CD  GLU F 127       8.666  30.620  -7.325  1.00 61.08           C  
ATOM   7033  OE1 GLU F 127       9.094  29.470  -7.062  1.00 59.99           O  
ATOM   7034  OE2 GLU F 127       8.066  30.937  -8.373  1.00 67.46           O  
ATOM   7035  N   ASP F 128       8.747  35.069  -7.268  1.00 55.47           N  
ATOM   7036  CA  ASP F 128       8.409  36.157  -8.206  1.00 56.90           C  
ATOM   7037  C   ASP F 128       9.005  37.554  -7.811  1.00 57.38           C  
ATOM   7038  O   ASP F 128       9.405  38.330  -8.686  1.00 57.20           O  
ATOM   7039  CB  ASP F 128       6.890  36.306  -8.371  1.00 57.43           C  
ATOM   7040  CG  ASP F 128       6.170  34.998  -8.656  1.00 58.61           C  
ATOM   7041  OD1 ASP F 128       6.789  34.030  -9.176  1.00 60.02           O  
ATOM   7042  OD2 ASP F 128       4.947  34.946  -8.361  1.00 56.90           O  
ATOM   7043  N   LEU F 129       9.023  37.864  -6.510  1.00 57.49           N  
ATOM   7044  CA  LEU F 129       9.625  39.090  -5.971  1.00 58.08           C  
ATOM   7045  C   LEU F 129      11.159  39.030  -6.054  1.00 58.02           C  
ATOM   7046  O   LEU F 129      11.817  40.031  -6.336  1.00 57.00           O  
ATOM   7047  CB  LEU F 129       9.175  39.294  -4.520  1.00 57.92           C  
ATOM   7048  CG  LEU F 129       8.824  40.650  -3.882  1.00 59.48           C  
ATOM   7049  CD1 LEU F 129       9.968  41.705  -3.964  1.00 63.07           C  
ATOM   7050  CD2 LEU F 129       7.552  41.233  -4.442  1.00 62.92           C  
ATOM   7051  N   LEU F 130      11.708  37.835  -5.815  1.00 58.81           N  
ATOM   7052  CA  LEU F 130      13.135  37.551  -5.990  1.00 59.47           C  
ATOM   7053  C   LEU F 130      13.559  37.590  -7.476  1.00 61.11           C  
ATOM   7054  O   LEU F 130      14.613  38.130  -7.806  1.00 60.76           O  
ATOM   7055  CB  LEU F 130      13.472  36.215  -5.318  1.00 58.30           C  
ATOM   7056  CG  LEU F 130      14.823  35.498  -5.122  1.00 57.59           C  
ATOM   7057  CD1 LEU F 130      15.519  35.159  -6.426  1.00 60.27           C  
ATOM   7058  CD2 LEU F 130      15.782  36.152  -4.162  1.00 55.81           C  
ATOM   7059  N   HIS F 131      12.740  37.034  -8.366  0.50 62.41           N  
ATOM   7061  CA  HIS F 131      13.071  37.044  -9.791  0.50 64.22           C  
ATOM   7063  C   HIS F 131      13.061  38.471 -10.357  0.50 63.60           C  
ATOM   7065  O   HIS F 131      13.960  38.835 -11.112  0.50 64.04           O  
ATOM   7067  CB  HIS F 131      12.150  36.103 -10.598  0.50 65.66           C  
ATOM   7069  CG  HIS F 131      12.781  35.530 -11.839  0.50 69.25           C  
ATOM   7071  ND1 HIS F 131      13.271  36.312 -12.865  0.50 71.98           N  
ATOM   7073  CD2 HIS F 131      12.968  34.246 -12.229  0.50 71.30           C  
ATOM   7075  CE1 HIS F 131      13.749  35.537 -13.823  0.50 72.65           C  
ATOM   7077  NE2 HIS F 131      13.574  34.279 -13.462  0.50 72.90           N  
ATOM   7079  N   ALA F 132      12.071  39.276  -9.967  1.00 62.51           N  
ATOM   7080  CA  ALA F 132      11.918  40.636 -10.499  1.00 61.60           C  
ATOM   7081  C   ALA F 132      13.030  41.589 -10.057  1.00 60.28           C  
ATOM   7082  O   ALA F 132      13.657  42.271 -10.873  1.00 59.27           O  
ATOM   7083  CB  ALA F 132      10.552  41.194 -10.137  1.00 60.69           C  
ATOM   7084  N   ALA F 133      13.282  41.606  -8.753  1.00 59.37           N  
ATOM   7085  CA  ALA F 133      14.294  42.456  -8.192  1.00 58.60           C  
ATOM   7086  C   ALA F 133      15.678  41.969  -8.658  1.00 59.48           C  
ATOM   7087  O   ALA F 133      16.537  42.784  -9.020  1.00 58.61           O  
ATOM   7088  CB  ALA F 133      14.144  42.500  -6.691  1.00 56.72           C  
ATOM   7089  N   LEU F 134      15.880  40.655  -8.645  1.00 61.26           N  
ATOM   7090  CA  LEU F 134      17.198  40.081  -8.886  1.00 64.23           C  
ATOM   7091  C   LEU F 134      17.198  39.200 -10.131  1.00 66.97           C  
ATOM   7092  O   LEU F 134      16.968  37.994 -10.049  1.00 66.27           O  
ATOM   7093  CB  LEU F 134      17.663  39.275  -7.671  1.00 63.32           C  
ATOM   7094  CG  LEU F 134      18.279  40.075  -6.522  1.00 63.71           C  
ATOM   7095  CD1 LEU F 134      18.760  39.146  -5.418  1.00 64.43           C  
ATOM   7096  CD2 LEU F 134      19.417  40.950  -7.026  1.00 65.52           C  
ATOM   7097  N   PRO F 135      17.455  39.811 -11.282  1.00 70.10           N  
ATOM   7098  CA  PRO F 135      17.387  39.101 -12.563  1.00 72.68           C  
ATOM   7099  C   PRO F 135      18.324  37.899 -12.596  1.00 74.11           C  
ATOM   7100  O   PRO F 135      17.886  36.783 -12.877  1.00 74.71           O  
ATOM   7101  CB  PRO F 135      17.851  40.157 -13.568  1.00 73.66           C  
ATOM   7102  CG  PRO F 135      17.485  41.453 -12.939  1.00 72.38           C  
ATOM   7103  CD  PRO F 135      17.667  41.258 -11.460  1.00 70.39           C  
ATOM   7104  N   SER F 136      19.600  38.130 -12.310  1.00 74.66           N  
ATOM   7105  CA  SER F 136      20.603  37.072 -12.365  1.00 75.01           C  
ATOM   7106  C   SER F 136      21.161  36.768 -10.980  1.00 72.74           C  
ATOM   7107  O   SER F 136      22.353  36.506 -10.824  1.00 73.35           O  
ATOM   7108  CB  SER F 136      21.737  37.459 -13.316  1.00 76.43           C  
ATOM   7109  OG  SER F 136      22.461  38.572 -12.820  1.00 77.40           O  
ATOM   7110  N   GLY F 137      20.291  36.803  -9.976  1.00 69.58           N  
ATOM   7111  CA  GLY F 137      20.593  36.217  -8.683  1.00 64.16           C  
ATOM   7112  C   GLY F 137      21.211  37.216  -7.724  1.00 60.38           C  
ATOM   7113  O   GLY F 137      21.631  38.300  -8.127  1.00 59.53           O  
ATOM   7114  N   PHE F 138      21.266  36.848  -6.449  1.00 56.79           N  
ATOM   7115  CA  PHE F 138      22.056  37.587  -5.471  1.00 52.76           C  
ATOM   7116  C   PHE F 138      23.504  37.733  -5.928  1.00 52.33           C  
ATOM   7117  O   PHE F 138      24.234  36.747  -6.029  1.00 52.44           O  
ATOM   7118  CB  PHE F 138      22.001  36.897  -4.106  1.00 51.47           C  
ATOM   7119  CG  PHE F 138      21.843  37.846  -2.953  1.00 46.25           C  
ATOM   7120  CD1 PHE F 138      22.920  38.589  -2.496  1.00 41.43           C  
ATOM   7121  CD2 PHE F 138      20.618  37.997  -2.325  1.00 40.25           C  
ATOM   7122  CE1 PHE F 138      22.778  39.463  -1.436  1.00 37.30           C  
ATOM   7123  CE2 PHE F 138      20.470  38.870  -1.263  1.00 39.22           C  
ATOM   7124  CZ  PHE F 138      21.551  39.604  -0.818  1.00 30.79           C  
ATOM   7125  N   PRO F 139      23.911  38.967  -6.202  1.00 50.92           N  
ATOM   7126  CA  PRO F 139      25.267  39.241  -6.686  1.00 50.84           C  
ATOM   7127  C   PRO F 139      26.262  39.377  -5.538  1.00 50.07           C  
ATOM   7128  O   PRO F 139      25.856  39.497  -4.382  1.00 49.48           O  
ATOM   7129  CB  PRO F 139      25.112  40.581  -7.408  1.00 51.33           C  
ATOM   7130  CG  PRO F 139      23.971  41.241  -6.722  1.00 50.14           C  
ATOM   7131  CD  PRO F 139      23.026  40.138  -6.339  1.00 50.89           C  
ATOM   7132  N   THR F 140      27.551  39.357  -5.860  1.00 50.01           N  
ATOM   7133  CA  THR F 140      28.582  39.614  -4.881  1.00 49.38           C  
ATOM   7134  C   THR F 140      28.393  41.033  -4.408  1.00 49.27           C  
ATOM   7135  O   THR F 140      28.074  41.929  -5.196  1.00 49.44           O  
ATOM   7136  CB  THR F 140      30.012  39.457  -5.422  1.00 50.17           C  
ATOM   7137  OG1 THR F 140      30.134  40.136  -6.662  1.00 50.14           O  
ATOM   7138  CG2 THR F 140      30.376  37.987  -5.628  1.00 52.09           C  
ATOM   7139  N   SER F 141      28.548  41.225  -3.100  1.00 48.53           N  
ATOM   7140  CA  SER F 141      28.524  42.545  -2.504  1.00 47.93           C  
ATOM   7141  C   SER F 141      27.117  43.121  -2.461  1.00 46.50           C  
ATOM   7142  O   SER F 141      26.945  44.229  -1.999  1.00 47.19           O  
ATOM   7143  CB  SER F 141      29.482  43.487  -3.255  1.00 49.42           C  
ATOM   7144  OG  SER F 141      29.712  44.676  -2.521  1.00 50.65           O  
ATOM   7145  N   GLY F 142      26.117  42.370  -2.921  1.00 44.77           N  
ATOM   7146  CA  GLY F 142      24.724  42.828  -2.898  1.00 42.99           C  
ATOM   7147  C   GLY F 142      24.121  42.883  -1.506  1.00 41.35           C  
ATOM   7148  O   GLY F 142      24.269  41.952  -0.686  1.00 41.28           O  
ATOM   7149  N   LEU F 143      23.453  43.989  -1.212  1.00 40.15           N  
ATOM   7150  CA  LEU F 143      22.884  44.189   0.123  1.00 36.67           C  
ATOM   7151  C   LEU F 143      21.390  44.293   0.087  1.00 35.54           C  
ATOM   7152  O   LEU F 143      20.845  45.193  -0.551  1.00 35.67           O  
ATOM   7153  CB  LEU F 143      23.430  45.437   0.773  1.00 36.58           C  
ATOM   7154  CG  LEU F 143      22.734  45.802   2.078  1.00 33.06           C  
ATOM   7155  CD1 LEU F 143      23.259  44.976   3.238  1.00 30.45           C  
ATOM   7156  CD2 LEU F 143      22.974  47.255   2.282  1.00 32.54           C  
ATOM   7157  N   ALA F 144      20.732  43.380   0.801  1.00 33.16           N  
ATOM   7158  CA  ALA F 144      19.297  43.365   0.854  1.00 31.50           C  
ATOM   7159  C   ALA F 144      18.829  43.885   2.205  1.00 30.40           C  
ATOM   7160  O   ALA F 144      19.433  43.547   3.225  1.00 29.32           O  
ATOM   7161  CB  ALA F 144      18.796  41.963   0.619  1.00 31.49           C  
ATOM   7162  N   VAL F 145      17.742  44.679   2.186  1.00 28.94           N  
ATOM   7163  CA  VAL F 145      17.174  45.346   3.348  1.00 27.00           C  
ATOM   7164  C   VAL F 145      15.704  45.027   3.487  1.00 28.11           C  
ATOM   7165  O   VAL F 145      14.897  45.424   2.648  1.00 27.25           O  
ATOM   7166  CB  VAL F 145      17.252  46.878   3.230  1.00 27.89           C  
ATOM   7167  CG1 VAL F 145      16.762  47.546   4.555  1.00 24.19           C  
ATOM   7168  CG2 VAL F 145      18.653  47.364   2.746  1.00 20.70           C  
ATOM   7169  N   LEU F 146      15.382  44.318   4.563  1.00 28.69           N  
ATOM   7170  CA  LEU F 146      14.053  43.824   4.854  1.00 30.21           C  
ATOM   7171  C   LEU F 146      13.511  44.342   6.171  1.00 32.01           C  
ATOM   7172  O   LEU F 146      14.221  44.406   7.152  1.00 32.21           O  
ATOM   7173  CB  LEU F 146      14.044  42.294   4.893  1.00 29.46           C  
ATOM   7174  CG  LEU F 146      14.605  41.653   3.614  1.00 29.02           C  
ATOM   7175  CD1 LEU F 146      16.053  41.240   3.884  1.00 26.64           C  
ATOM   7176  CD2 LEU F 146      13.747  40.477   3.144  1.00 31.16           C  
ATOM   7177  N   ASP F 147      12.241  44.704   6.178  1.00 34.06           N  
ATOM   7178  CA  ASP F 147      11.570  45.029   7.407  1.00 37.98           C  
ATOM   7179  C   ASP F 147      10.369  44.179   7.478  1.00 39.76           C  
ATOM   7180  O   ASP F 147       9.905  43.700   6.461  1.00 39.13           O  
ATOM   7181  CB  ASP F 147      11.167  46.526   7.464  1.00 39.36           C  
ATOM   7182  CG  ASP F 147      12.316  47.422   7.940  1.00 38.58           C  
ATOM   7183  OD1 ASP F 147      13.134  47.009   8.805  1.00 37.63           O  
ATOM   7184  OD2 ASP F 147      12.410  48.532   7.430  1.00 40.05           O  
ATOM   7185  N   GLN F 148       9.896  43.956   8.694  1.00 43.61           N  
ATOM   7186  CA  GLN F 148       8.544  43.433   8.904  1.00 47.82           C  
ATOM   7187  C   GLN F 148       7.499  44.461   8.438  1.00 50.16           C  
ATOM   7188  O   GLN F 148       7.734  45.678   8.501  1.00 50.45           O  
ATOM   7189  CB  GLN F 148       8.312  43.091  10.380  1.00 48.10           C  
ATOM   7190  CG  GLN F 148       9.546  42.624  11.112  1.00 48.84           C  
ATOM   7191  CD  GLN F 148       9.265  42.098  12.504  1.00 50.30           C  
ATOM   7192  OE1 GLN F 148      10.102  41.444  13.115  1.00 50.00           O  
ATOM   7193  NE2 GLN F 148       8.072  42.363  13.005  1.00 57.02           N  
ATOM   7194  N   ASP F 149       6.364  43.970   7.938  1.00 52.49           N  
ATOM   7195  CA  ASP F 149       5.178  44.832   7.756  1.00 54.65           C  
ATOM   7196  C   ASP F 149       4.445  45.012   9.092  1.00 55.94           C  
ATOM   7197  O   ASP F 149       4.975  44.685  10.163  1.00 55.48           O  
ATOM   7198  CB  ASP F 149       4.215  44.278   6.687  1.00 55.02           C  
ATOM   7199  CG  ASP F 149       4.768  44.411   5.269  1.00 54.43           C  
ATOM   7200  OD1 ASP F 149       5.747  43.704   4.955  1.00 53.82           O  
ATOM   7201  OD2 ASP F 149       4.232  45.220   4.475  1.00 52.50           O  
ATOM   7202  N   ASN F 157       1.672  40.868   9.134  1.00 67.48           N  
ATOM   7203  CA  ASN F 157       3.084  40.918   9.478  1.00 65.79           C  
ATOM   7204  C   ASN F 157       3.874  39.770   8.844  1.00 63.30           C  
ATOM   7205  O   ASN F 157       3.574  38.588   9.077  1.00 63.36           O  
ATOM   7206  CB  ASN F 157       3.291  40.950  10.997  1.00 66.82           C  
ATOM   7207  CG  ASN F 157       4.734  41.258  11.378  1.00 66.42           C  
ATOM   7208  OD1 ASN F 157       5.447  40.423  11.922  1.00 61.79           O  
ATOM   7209  ND2 ASN F 157       5.171  42.473  11.071  1.00 69.77           N  
ATOM   7210  N   ARG F 158       4.904  40.168   8.083  1.00 58.96           N  
ATOM   7211  CA  ARG F 158       5.616  39.380   7.080  1.00 54.29           C  
ATOM   7212  C   ARG F 158       6.914  40.154   6.706  1.00 51.05           C  
ATOM   7213  O   ARG F 158       7.077  41.309   7.129  1.00 51.20           O  
ATOM   7214  CB  ARG F 158       4.686  39.171   5.867  1.00 54.64           C  
ATOM   7215  CG  ARG F 158       5.218  39.607   4.505  1.00 53.79           C  
ATOM   7216  CD  ARG F 158       4.125  39.988   3.539  1.00 54.43           C  
ATOM   7217  NE  ARG F 158       4.513  41.106   2.669  1.00 56.18           N  
ATOM   7218  CZ  ARG F 158       4.788  41.021   1.360  1.00 54.54           C  
ATOM   7219  NH1 ARG F 158       4.749  39.856   0.721  1.00 49.76           N  
ATOM   7220  NH2 ARG F 158       5.118  42.116   0.684  1.00 52.92           N  
ATOM   7221  N   TRP F 159       7.826  39.550   5.936  1.00 45.97           N  
ATOM   7222  CA  TRP F 159       9.032  40.261   5.476  1.00 41.90           C  
ATOM   7223  C   TRP F 159       8.784  41.119   4.262  1.00 40.12           C  
ATOM   7224  O   TRP F 159       8.027  40.724   3.397  1.00 40.55           O  
ATOM   7225  CB  TRP F 159      10.193  39.294   5.246  1.00 41.05           C  
ATOM   7226  CG  TRP F 159      10.695  38.788   6.543  1.00 37.75           C  
ATOM   7227  CD1 TRP F 159      10.549  37.533   7.036  1.00 37.67           C  
ATOM   7228  CD2 TRP F 159      11.316  39.568   7.581  1.00 34.39           C  
ATOM   7229  NE1 TRP F 159      11.107  37.455   8.319  1.00 38.69           N  
ATOM   7230  CE2 TRP F 159      11.568  38.691   8.673  1.00 34.64           C  
ATOM   7231  CE3 TRP F 159      11.706  40.912   7.683  1.00 31.97           C  
ATOM   7232  CZ2 TRP F 159      12.191  39.109   9.838  1.00 34.48           C  
ATOM   7233  CZ3 TRP F 159      12.337  41.341   8.844  1.00 32.67           C  
ATOM   7234  CH2 TRP F 159      12.562  40.443   9.916  1.00 37.12           C  
ATOM   7235  N   ARG F 160       9.421  42.284   4.205  1.00 37.53           N  
ATOM   7236  CA  ARG F 160       9.323  43.154   3.040  1.00 34.79           C  
ATOM   7237  C   ARG F 160      10.687  43.719   2.657  1.00 32.38           C  
ATOM   7238  O   ARG F 160      11.414  44.239   3.503  1.00 30.61           O  
ATOM   7239  CB  ARG F 160       8.337  44.294   3.304  1.00 35.55           C  
ATOM   7240  CG  ARG F 160       8.010  45.129   2.077  1.00 34.38           C  
ATOM   7241  CD  ARG F 160       7.398  46.465   2.465  1.00 39.43           C  
ATOM   7242  NE  ARG F 160       7.870  47.551   1.610  1.00 45.23           N  
ATOM   7243  CZ  ARG F 160       7.783  48.839   1.924  1.00 50.29           C  
ATOM   7244  NH1 ARG F 160       7.241  49.208   3.077  1.00 51.23           N  
ATOM   7245  NH2 ARG F 160       8.238  49.761   1.085  1.00 49.18           N  
ATOM   7246  N   LEU F 161      11.027  43.613   1.377  1.00 32.31           N  
ATOM   7247  CA  LEU F 161      12.267  44.186   0.864  1.00 32.94           C  
ATOM   7248  C   LEU F 161      12.111  45.677   0.587  1.00 35.48           C  
ATOM   7249  O   LEU F 161      11.265  46.086  -0.210  1.00 34.42           O  
ATOM   7250  CB  LEU F 161      12.707  43.458  -0.408  1.00 31.82           C  
ATOM   7251  CG  LEU F 161      14.100  43.804  -0.938  1.00 31.03           C  
ATOM   7252  CD1 LEU F 161      15.169  43.031  -0.183  1.00 27.53           C  
ATOM   7253  CD2 LEU F 161      14.189  43.531  -2.432  1.00 27.98           C  
ATOM   7254  N   ILE F 162      12.931  46.486   1.250  1.00 38.76           N  
ATOM   7255  CA  ILE F 162      12.717  47.928   1.293  1.00 41.84           C  
ATOM   7256  C   ILE F 162      13.874  48.677   0.640  1.00 42.31           C  
ATOM   7257  O   ILE F 162      13.748  49.851   0.291  1.00 42.31           O  
ATOM   7258  CB  ILE F 162      12.542  48.430   2.738  1.00 42.82           C  
ATOM   7259  CG1 ILE F 162      11.396  47.686   3.426  1.00 44.59           C  
ATOM   7260  CG2 ILE F 162      12.297  49.930   2.755  1.00 43.83           C  
ATOM   7261  CD1 ILE F 162      10.735  48.476   4.534  1.00 47.71           C  
ATOM   7262  N   ASP F 163      15.001  47.991   0.479  1.00 43.06           N  
ATOM   7263  CA  ASP F 163      16.056  48.450  -0.416  1.00 44.63           C  
ATOM   7264  C   ASP F 163      16.885  47.280  -0.936  1.00 44.98           C  
ATOM   7265  O   ASP F 163      16.870  46.193  -0.361  1.00 44.12           O  
ATOM   7266  CB  ASP F 163      16.960  49.460   0.294  1.00 44.97           C  
ATOM   7267  CG  ASP F 163      17.628  50.422  -0.668  1.00 44.51           C  
ATOM   7268  OD1 ASP F 163      17.093  50.621  -1.779  1.00 43.21           O  
ATOM   7269  OD2 ASP F 163      18.690  50.977  -0.314  1.00 45.57           O  
ATOM   7270  N   PHE F 164      17.607  47.512  -2.028  1.00 46.63           N  
ATOM   7271  CA  PHE F 164      18.737  46.667  -2.395  1.00 47.59           C  
ATOM   7272  C   PHE F 164      19.878  47.493  -2.978  1.00 49.49           C  
ATOM   7273  O   PHE F 164      19.699  48.207  -3.965  1.00 49.62           O  
ATOM   7274  CB  PHE F 164      18.301  45.592  -3.392  1.00 47.38           C  
ATOM   7275  CG  PHE F 164      19.162  44.361  -3.372  1.00 45.48           C  
ATOM   7276  CD1 PHE F 164      20.312  44.292  -4.140  1.00 45.68           C  
ATOM   7277  CD2 PHE F 164      18.821  43.274  -2.586  1.00 42.37           C  
ATOM   7278  CE1 PHE F 164      21.106  43.161  -4.124  1.00 43.37           C  
ATOM   7279  CE2 PHE F 164      19.611  42.140  -2.565  1.00 36.80           C  
ATOM   7280  CZ  PHE F 164      20.754  42.083  -3.335  1.00 40.94           C  
ATOM   7281  N   LEU F 165      21.052  47.390  -2.364  1.00 50.78           N  
ATOM   7282  CA  LEU F 165      22.246  48.054  -2.875  1.00 52.16           C  
ATOM   7283  C   LEU F 165      23.171  47.063  -3.574  1.00 54.36           C  
ATOM   7284  O   LEU F 165      23.538  46.035  -3.006  1.00 53.80           O  
ATOM   7285  CB  LEU F 165      22.991  48.761  -1.741  1.00 51.52           C  
ATOM   7286  CG  LEU F 165      22.137  49.587  -0.779  1.00 48.72           C  
ATOM   7287  CD1 LEU F 165      22.981  50.123   0.366  1.00 44.36           C  
ATOM   7288  CD2 LEU F 165      21.442  50.722  -1.516  1.00 42.42           C  
ATOM   7289  N   ALA F 166      23.544  47.381  -4.809  1.00 56.21           N  
ATOM   7290  CA  ALA F 166      24.349  46.477  -5.622  1.00 57.70           C  
ATOM   7291  C   ALA F 166      25.659  47.132  -6.044  1.00 59.14           C  
ATOM   7292  O   ALA F 166      25.666  48.075  -6.836  1.00 59.50           O  
ATOM   7293  CB  ALA F 166      23.564  46.022  -6.843  1.00 58.68           C  
TER    7294      ALA F 166                                                      
END
MOLECULE T0394.pdb
ATOM      1  N   ASN     1       7.131  28.263  26.435  1.00 37.08           N  
ATOM      2  CA  ASN     1       7.437  29.315  25.416  1.00 36.05           C  
ATOM      3  C   ASN     1       7.192  30.735  25.903  1.00 34.53           C  
ATOM      4  O   ASN     1       6.216  30.997  26.611  1.00 34.93           O  
ATOM      5  CB  ASN     1       6.662  29.047  24.125  1.00 37.00           C  
ATOM      6  CG  ASN     1       7.395  28.086  23.213  1.00 39.47           C  
ATOM      7  OD1 ASN     1       7.200  26.869  23.286  1.00 43.62           O  
ATOM      8  ND2 ASN     1       8.288  28.624  22.384  1.00 40.23           N  
ATOM      9  N   LEU     2       8.082  31.640  25.492  1.00 32.19           N  
ATOM     10  CA  LEU     2       8.122  33.016  25.993  1.00 29.95           C  
ATOM     11  C   LEU     2       7.110  33.917  25.298  1.00 28.07           C  
ATOM     12  O   LEU     2       6.983  33.894  24.068  1.00 28.29           O  
ATOM     13  CB  LEU     2       9.527  33.600  25.804  1.00 29.69           C  
ATOM     14  CG  LEU     2      10.670  32.930  26.564  1.00 29.92           C  
ATOM     15  CD1 LEU     2      12.000  33.222  25.886  1.00 29.23           C  
ATOM     16  CD2 LEU     2      10.663  33.446  27.989  1.00 28.60           C  
ATOM     17  N   TYR     3       6.407  34.722  26.095  1.00 25.72           N  
ATOM     18  CA  TYR     3       5.529  35.769  25.587  1.00 24.38           C  
ATOM     19  C   TYR     3       6.320  37.041  25.320  1.00 23.44           C  
ATOM     20  O   TYR     3       7.033  37.574  26.203  1.00 21.70           O  
ATOM     21  CB  TYR     3       4.386  36.067  26.569  1.00 24.95           C  
ATOM     22  CG  TYR     3       3.542  37.283  26.201  1.00 24.49           C  
ATOM     23  CD1 TYR     3       2.296  37.140  25.578  1.00 25.41           C  
ATOM     24  CD2 TYR     3       3.986  38.574  26.489  1.00 24.54           C  
ATOM     25  CE1 TYR     3       1.528  38.265  25.239  1.00 26.31           C  
ATOM     26  CE2 TYR     3       3.232  39.700  26.154  1.00 24.99           C  
ATOM     27  CZ  TYR     3       2.015  39.541  25.528  1.00 26.12           C  
ATOM     28  OH  TYR     3       1.282  40.675  25.217  1.00 29.19           O  
ATOM     29  N   PHE     4       6.198  37.532  24.092  1.00 21.28           N  
ATOM     30  CA  PHE     4       6.804  38.796  23.732  1.00 21.92           C  
ATOM     31  C   PHE     4       5.758  39.769  23.248  1.00 22.33           C  
ATOM     32  O   PHE     4       4.744  39.358  22.707  1.00 21.26           O  
ATOM     33  CB  PHE     4       7.841  38.598  22.620  1.00 21.80           C  
ATOM     34  CG  PHE     4       9.019  37.763  23.036  1.00 20.69           C  
ATOM     35  CD1 PHE     4       9.930  38.245  23.973  1.00 18.93           C  
ATOM     36  CD2 PHE     4       9.209  36.497  22.501  1.00 21.68           C  
ATOM     37  CE1 PHE     4      11.035  37.458  24.352  1.00 20.05           C  
ATOM     38  CE2 PHE     4      10.302  35.717  22.866  1.00 22.45           C  
ATOM     39  CZ  PHE     4      11.222  36.218  23.803  1.00 21.82           C  
ATOM     40  N   GLN     5       6.032  41.054  23.450  1.00 22.99           N  
ATOM     41  CA  GLN     5       5.226  42.107  22.871  1.00 24.75           C  
ATOM     42  C   GLN     5       5.521  42.151  21.367  1.00 23.85           C  
ATOM     43  O   GLN     5       6.451  41.461  20.899  1.00 23.54           O  
ATOM     44  CB  GLN     5       5.532  43.444  23.553  1.00 26.07           C  
ATOM     45  CG  GLN     5       5.034  43.473  25.022  1.00 31.04           C  
ATOM     46  CD  GLN     5       4.811  44.878  25.566  1.00 37.81           C  
ATOM     47  OE1 GLN     5       5.661  45.777  25.403  1.00 41.06           O  
ATOM     48  NE2 GLN     5       3.660  45.079  26.215  1.00 38.49           N  
ATOM     49  N   SER     6       4.726  42.924  20.628  1.00 23.52           N  
ATOM     50  CA  SER     6       4.940  43.126  19.191  0.50 23.55           C  
ATOM     52  C   SER     6       6.337  43.702  18.962  1.00 22.75           C  
ATOM     53  O   SER     6       6.858  44.463  19.805  1.00 22.96           O  
ATOM     54  CB  SER     6       3.856  44.057  18.638  0.50 23.94           C  
ATOM     56  OG  SER     6       3.940  44.174  17.233  0.50 25.41           O  
ATOM     58  N   ALA     7       6.977  43.335  17.852  1.00 21.09           N  
ATOM     59  CA  ALA     7       8.341  43.796  17.589  1.00 19.34           C  
ATOM     60  C   ALA     7       8.616  43.806  16.096  1.00 18.62           C  
ATOM     61  O   ALA     7       7.962  43.078  15.352  1.00 17.81           O  
ATOM     62  CB  ALA     7       9.361  42.902  18.314  1.00 18.58           C  
ATOM     63  N   ARG     8       9.540  44.662  15.692  1.00 17.77           N  
ATOM     64  CA  ARG     8       9.981  44.808  14.311  1.00 18.09           C  
ATOM     65  C   ARG     8      11.475  45.003  14.342  1.00 17.38           C  
ATOM     66  O   ARG     8      11.988  45.711  15.227  1.00 16.45           O  
ATOM     67  CB  ARG     8       9.398  46.071  13.683  1.00 19.36           C  
ATOM     68  CG  ARG     8       7.946  46.007  13.335  1.00 23.70           C  
ATOM     69  CD  ARG     8       7.465  47.406  12.982  1.00 28.18           C  
ATOM     70  NE  ARG     8       7.941  47.887  11.680  1.00 30.83           N  
ATOM     71  CZ  ARG     8       8.710  48.960  11.501  1.00 30.42           C  
ATOM     72  NH1 ARG     8       9.117  49.682  12.536  1.00 32.52           N  
ATOM     73  NH2 ARG     8       9.060  49.316  10.274  1.00 29.09           N  
ATOM     74  N   PHE     9      12.184  44.376  13.397  1.00 15.44           N  
ATOM     75  CA  PHE     9      13.609  44.661  13.228  1.00 14.36           C  
ATOM     76  C   PHE     9      14.024  44.617  11.750  1.00 14.07           C  
ATOM     77  O   PHE     9      13.327  44.021  10.922  1.00 14.11           O  
ATOM     78  CB  PHE     9      14.503  43.808  14.139  1.00 14.06           C  
ATOM     79  CG  PHE     9      14.646  42.339  13.723  1.00 14.99           C  
ATOM     80  CD1 PHE     9      15.716  41.917  12.893  1.00 14.73           C  
ATOM     81  CD2 PHE     9      13.778  41.373  14.237  1.00 14.99           C  
ATOM     82  CE1 PHE     9      15.873  40.529  12.575  1.00 15.03           C  
ATOM     83  CE2 PHE     9      13.931  40.017  13.902  1.00 13.86           C  
ATOM     84  CZ  PHE     9      14.979  39.616  13.065  1.00 15.53           C  
ATOM     85  N   ALA    10      15.107  45.315  11.432  1.00 13.59           N  
ATOM     86  CA  ALA    10      15.614  45.381  10.074  1.00 13.29           C  
ATOM     87  C   ALA    10      16.736  44.351   9.943  1.00 12.11           C  
ATOM     88  O   ALA    10      17.515  44.114  10.867  1.00 12.79           O  
ATOM     89  CB  ALA    10      16.127  46.747   9.770  1.00 13.92           C  
ATOM     90  N   LEU    11      16.820  43.776   8.765  1.00 11.89           N  
ATOM     91  CA  LEU    11      17.884  42.825   8.461  1.00 11.66           C  
ATOM     92  C   LEU    11      18.479  43.206   7.106  1.00 11.25           C  
ATOM     93  O   LEU    11      17.791  43.100   6.088  1.00 11.70           O  
ATOM     94  CB  LEU    11      17.268  41.424   8.382  1.00 11.80           C  
ATOM     95  CG  LEU    11      18.199  40.311   7.867  1.00 11.81           C  
ATOM     96  CD1 LEU    11      19.499  40.184   8.709  1.00 11.54           C  
ATOM     97  CD2 LEU    11      17.431  38.946   7.835  1.00 11.16           C  
ATOM     98  N   THR    12      19.739  43.651   7.093  1.00 11.06           N  
ATOM     99  CA  THR    12      20.437  43.941   5.843  1.00 10.80           C  
ATOM    100  C   THR    12      21.431  42.812   5.554  1.00 10.75           C  
ATOM    101  O   THR    12      22.268  42.492   6.427  1.00 10.78           O  
ATOM    102  CB  THR    12      21.207  45.258   5.979  1.00 12.04           C  
ATOM    103  OG1 THR    12      20.261  46.309   6.268  1.00 13.87           O  
ATOM    104  CG2 THR    12      21.944  45.545   4.716  1.00 11.84           C  
ATOM    105  N   VAL    13      21.329  42.215   4.366  1.00 10.59           N  
ATOM    106  CA  VAL    13      22.159  41.059   3.976  1.00 10.00           C  
ATOM    107  C   VAL    13      23.009  41.448   2.754  1.00 10.55           C  
ATOM    108  O   VAL    13      22.471  41.918   1.733  1.00 10.36           O  
ATOM    109  CB  VAL    13      21.256  39.828   3.638  1.00 10.02           C  
ATOM    110  CG1 VAL    13      22.153  38.561   3.516  1.00  9.93           C  
ATOM    111  CG2 VAL    13      20.243  39.644   4.736  1.00 12.14           C  
ATOM    112  N   VAL    14      24.327  41.288   2.872  1.00 10.61           N  
ATOM    113  CA  VAL    14      25.251  41.780   1.877  1.00 10.14           C  
ATOM    114  C   VAL    14      26.202  40.645   1.457  1.00 10.94           C  
ATOM    115  O   VAL    14      26.790  40.007   2.325  1.00 10.94           O  
ATOM    116  CB  VAL    14      26.075  42.959   2.446  1.00 11.36           C  
ATOM    117  CG1 VAL    14      27.056  43.456   1.382  1.00  9.89           C  
ATOM    118  CG2 VAL    14      25.134  44.137   2.849  1.00 12.81           C  
ATOM    119  N   ARG    15      26.318  40.368   0.158  1.00 10.04           N  
ATOM    120  CA  ARG    15      27.289  39.336  -0.282  1.00 10.79           C  
ATOM    121  C   ARG    15      28.699  39.909  -0.117  1.00 10.29           C  
ATOM    122  O   ARG    15      28.904  41.106  -0.283  1.00 11.57           O  
ATOM    123  CB  ARG    15      27.048  38.936  -1.768  1.00  9.43           C  
ATOM    124  CG  ARG    15      28.024  37.834  -2.263  1.00 11.35           C  
ATOM    125  CD  ARG    15      27.585  37.222  -3.602  1.00 12.46           C  
ATOM    126  NE  ARG    15      28.624  36.330  -4.093  1.00 13.39           N  
ATOM    127  CZ  ARG    15      29.143  36.335  -5.318  1.00 15.37           C  
ATOM    128  NH1 ARG    15      28.674  37.137  -6.260  1.00 14.12           N  
ATOM    129  NH2 ARG    15      30.131  35.500  -5.608  1.00 13.89           N  
ATOM    130  N   HIS    16      29.679  39.062   0.166  1.00 11.14           N  
ATOM    131  CA  HIS    16      31.080  39.515   0.244  1.00 11.40           C  
ATOM    132  C   HIS    16      31.557  40.087  -1.118  1.00 12.40           C  
ATOM    133  O   HIS    16      30.975  39.795  -2.202  1.00 12.27           O  
ATOM    134  CB  HIS    16      31.969  38.326   0.622  1.00 11.89           C  
ATOM    135  CG  HIS    16      31.909  37.244  -0.383  1.00 11.77           C  
ATOM    136  ND1 HIS    16      32.675  37.259  -1.532  1.00 10.88           N  
ATOM    137  CD2 HIS    16      31.113  36.155  -0.466  1.00 14.23           C  
ATOM    138  CE1 HIS    16      32.387  36.191  -2.256  1.00 16.26           C  
ATOM    139  NE2 HIS    16      31.442  35.506  -1.630  1.00 14.39           N  
ATOM    140  N   GLY    17      32.636  40.876  -1.055  1.00 12.57           N  
ATOM    141  CA  GLY    17      33.265  41.387  -2.260  1.00 12.64           C  
ATOM    142  C   GLY    17      33.923  40.326  -3.120  1.00 13.60           C  
ATOM    143  O   GLY    17      34.100  39.176  -2.698  1.00 12.67           O  
ATOM    144  N   GLU    18      34.245  40.696  -4.356  1.00 12.79           N  
ATOM    145  CA  GLU    18      34.855  39.768  -5.308  1.00 14.33           C  
ATOM    146  C   GLU    18      36.181  39.161  -4.816  1.00 14.19           C  
ATOM    147  O   GLU    18      36.985  39.853  -4.170  1.00 13.24           O  
ATOM    148  CB  GLU    18      35.072  40.498  -6.641  1.00 15.58           C  
ATOM    149  CG  GLU    18      35.615  39.646  -7.737  1.00 18.58           C  
ATOM    150  CD  GLU    18      36.423  40.473  -8.747  1.00 26.24           C  
ATOM    151  OE1 GLU    18      37.548  40.925  -8.432  1.00 28.76           O  
ATOM    152  OE2 GLU    18      35.935  40.634  -9.857  1.00 27.17           O  
ATOM    153  N   THR    19      36.361  37.856  -5.065  1.00 14.63           N  
ATOM    154  CA  THR    19      37.661  37.193  -4.893  1.00 15.69           C  
ATOM    155  C   THR    19      38.223  36.845  -6.260  1.00 16.12           C  
ATOM    156  O   THR    19      37.525  36.893  -7.282  1.00 15.11           O  
ATOM    157  CB  THR    19      37.572  35.837  -4.120  1.00 14.87           C  
ATOM    158  OG1 THR    19      36.910  34.873  -4.955  1.00 16.55           O  
ATOM    159  CG2 THR    19      36.837  35.983  -2.742  1.00 12.93           C  
ATOM    160  N   ARG    20      39.495  36.453  -6.260  1.00 16.97           N  
ATOM    161  CA  ARG    20      40.161  35.912  -7.443  1.00 18.93           C  
ATOM    162  C   ARG    20      39.322  34.822  -8.158  1.00 19.29           C  
ATOM    163  O   ARG    20      39.202  34.812  -9.396  1.00 20.04           O  
ATOM    164  CB  ARG    20      41.546  35.408  -6.992  1.00 19.32           C  
ATOM    165  CG  ARG    20      42.275  34.361  -7.777  1.00 22.18           C  
ATOM    166  CD  ARG    20      43.709  34.338  -7.214  1.00 21.66           C  
ATOM    167  NE  ARG    20      43.840  33.443  -6.063  1.00 20.51           N  
ATOM    168  CZ  ARG    20      44.436  32.262  -6.102  1.00 22.87           C  
ATOM    169  NH1 ARG    20      44.481  31.517  -5.016  1.00 24.91           N  
ATOM    170  NH2 ARG    20      44.975  31.823  -7.228  1.00 23.22           N  
ATOM    171  N   PHE    21      38.714  33.939  -7.373  1.00 17.76           N  
ATOM    172  CA  PHE    21      37.948  32.834  -7.941  1.00 17.97           C  
ATOM    173  C   PHE    21      36.604  33.277  -8.506  1.00 17.74           C  
ATOM    174  O   PHE    21      36.151  32.759  -9.544  1.00 16.99           O  
ATOM    175  CB  PHE    21      37.833  31.701  -6.911  1.00 19.01           C  
ATOM    176  CG  PHE    21      39.181  31.131  -6.530  1.00 20.00           C  
ATOM    177  CD1 PHE    21      40.117  30.838  -7.512  1.00 23.92           C  
ATOM    178  CD2 PHE    21      39.525  30.940  -5.202  1.00 24.47           C  
ATOM    179  CE1 PHE    21      41.375  30.310  -7.171  1.00 24.93           C  
ATOM    180  CE2 PHE    21      40.774  30.412  -4.859  1.00 25.63           C  
ATOM    181  CZ  PHE    21      41.691  30.099  -5.842  1.00 24.75           C  
ATOM    182  N   ASN    22      35.962  34.229  -7.840  1.00 17.57           N  
ATOM    183  CA  ASN    22      34.719  34.794  -8.414  1.00 18.52           C  
ATOM    184  C   ASN    22      34.988  35.351  -9.818  1.00 19.89           C  
ATOM    185  O   ASN    22      34.228  35.105 -10.771  1.00 19.51           O  
ATOM    186  CB  ASN    22      34.190  35.907  -7.554  1.00 18.37           C  
ATOM    187  CG  ASN    22      33.602  35.407  -6.245  1.00 19.37           C  
ATOM    188  OD1 ASN    22      33.150  34.237  -6.104  1.00 18.97           O  
ATOM    189  ND2 ASN    22      33.568  36.286  -5.301  1.00 13.55           N  
ATOM    190  N   LYS    23      36.093  36.074  -9.948  1.00 20.75           N  
ATOM    191  CA  LYS    23      36.443  36.692 -11.235  1.00 23.46           C  
ATOM    192  C   LYS    23      36.623  35.624 -12.306  1.00 24.29           C  
ATOM    193  O   LYS    23      36.138  35.776 -13.428  1.00 25.47           O  
ATOM    194  CB  LYS    23      37.690  37.556 -11.072  1.00 23.52           C  
ATOM    195  CG  LYS    23      38.222  38.212 -12.349  1.00 27.47           C  
ATOM    196  CD  LYS    23      37.326  39.322 -12.822  1.00 32.44           C  
ATOM    197  CE  LYS    23      38.108  40.299 -13.700  1.00 35.21           C  
ATOM    198  NZ  LYS    23      37.221  41.431 -14.082  1.00 39.24           N  
ATOM    199  N   GLU    24      37.280  34.531 -11.936  1.00 25.02           N  
ATOM    200  CA  GLU    24      37.646  33.470 -12.881  1.00 26.99           C  
ATOM    201  C   GLU    24      36.574  32.393 -13.025  1.00 26.34           C  
ATOM    202  O   GLU    24      36.802  31.393 -13.728  1.00 27.71           O  
ATOM    203  CB  GLU    24      38.981  32.836 -12.465  1.00 27.65           C  
ATOM    204  CG  GLU    24      40.141  33.811 -12.232  1.00 30.31           C  
ATOM    205  CD  GLU    24      40.401  34.779 -13.408  1.00 36.92           C  
ATOM    206  OE1 GLU    24      40.063  34.451 -14.569  1.00 38.73           O  
ATOM    207  OE2 GLU    24      40.950  35.884 -13.159  1.00 38.71           O  
ATOM    208  N   LYS    25      35.421  32.604 -12.378  1.00 25.57           N  
ATOM    209  CA  LYS    25      34.277  31.667 -12.408  1.00 24.89           C  
ATOM    210  C   LYS    25      34.691  30.274 -11.910  1.00 22.95           C  
ATOM    211  O   LYS    25      34.323  29.237 -12.514  1.00 24.07           O  
ATOM    212  CB  LYS    25      33.655  31.563 -13.820  1.00 26.00           C  
ATOM    213  CG  LYS    25      33.068  32.889 -14.367  1.00 30.31           C  
ATOM    214  CD  LYS    25      31.531  32.954 -14.285  1.00 37.00           C  
ATOM    215  CE  LYS    25      30.851  32.201 -15.442  1.00 39.72           C  
ATOM    216  NZ  LYS    25      29.358  32.126 -15.292  1.00 41.81           N  
ATOM    217  N   ILE    26      35.474  30.269 -10.834  1.00 20.24           N  
ATOM    218  CA  ILE    26      35.921  29.042 -10.172  0.50 19.68           C  
ATOM    220  C   ILE    26      35.057  28.826  -8.941  1.00 18.78           C  
ATOM    221  O   ILE    26      34.810  29.759  -8.172  1.00 18.27           O  
ATOM    222  CB  ILE    26      37.425  29.134  -9.782  0.50 19.24           C  
ATOM    224  CG1 ILE    26      38.297  29.028 -11.046  0.50 20.15           C  
ATOM    226  CG2 ILE    26      37.834  28.074  -8.758  0.50 19.79           C  
ATOM    228  CD1 ILE    26      39.716  29.509 -10.829  0.50 19.10           C  
ATOM    230  N   ILE    27      34.588  27.598  -8.779  1.00 17.64           N  
ATOM    231  CA  ILE    27      33.708  27.274  -7.670  0.50 17.31           C  
ATOM    233  C   ILE    27      34.422  27.476  -6.353  1.00 17.86           C  
ATOM    234  O   ILE    27      35.542  27.019  -6.154  1.00 16.33           O  
ATOM    235  CB  ILE    27      33.170  25.849  -7.774  0.50 16.83           C  
ATOM    237  CG1 ILE    27      32.426  25.673  -9.102  0.50 18.12           C  
ATOM    239  CG2 ILE    27      32.228  25.543  -6.610  0.50 15.69           C  
ATOM    241  CD1 ILE    27      32.230  24.258  -9.481  0.50 17.55           C  
ATOM    243  N   GLN    28      33.712  28.157  -5.457  1.00 19.94           N  
ATOM    244  CA  GLN    28      34.188  28.558  -4.186  1.00 21.00           C  
ATOM    245  C   GLN    28      33.026  28.413  -3.207  1.00 20.63           C  
ATOM    246  O   GLN    28      32.128  29.284  -3.155  1.00 21.79           O  
ATOM    247  CB  GLN    28      34.493  30.038  -4.326  1.00 22.79           C  
ATOM    248  CG  GLN    28      35.186  30.690  -3.187  1.00 25.95           C  
ATOM    249  CD  GLN    28      35.402  32.143  -3.518  1.00 23.19           C  
ATOM    250  OE1 GLN    28      34.439  32.916  -3.650  1.00 26.05           O  
ATOM    251  NE2 GLN    28      36.658  32.528  -3.684  1.00 18.04           N  
ATOM    252  N   GLY    29      33.023  27.314  -2.470  1.00 18.42           N  
ATOM    253  CA  GLY    29      32.073  27.123  -1.387  1.00 18.14           C  
ATOM    254  C   GLY    29      32.830  27.131  -0.072  1.00 18.33           C  
ATOM    255  O   GLY    29      33.116  28.190   0.473  1.00 18.58           O  
ATOM    256  N   GLN    30      33.180  25.950   0.427  1.00 18.10           N  
ATOM    257  CA  GLN    30      33.966  25.825   1.659  1.00 19.44           C  
ATOM    258  C   GLN    30      35.303  25.107   1.278  1.00 21.53           C  
ATOM    259  O   GLN    30      35.699  24.135   1.898  1.00 22.52           O  
ATOM    260  CB  GLN    30      33.146  25.074   2.757  1.00 18.80           C  
ATOM    261  CG  GLN    30      31.821  25.772   3.166  1.00 17.51           C  
ATOM    262  CD  GLN    30      31.107  25.155   4.393  1.00 18.30           C  
ATOM    263  OE1 GLN    30      31.751  24.637   5.332  1.00 17.71           O  
ATOM    264  NE2 GLN    30      29.785  25.260   4.418  1.00 15.39           N  
ATOM    265  N   GLY    31      35.971  25.592   0.233  1.00 23.08           N  
ATOM    266  CA  GLY    31      37.221  24.988  -0.236  1.00 24.28           C  
ATOM    267  C   GLY    31      38.442  25.756   0.219  1.00 24.89           C  
ATOM    268  O   GLY    31      38.798  25.700   1.396  1.00 24.91           O  
ATOM    269  N   VAL    32      39.121  26.439  -0.706  1.00 24.97           N  
ATOM    270  CA  VAL    32      40.138  27.382  -0.288  1.00 24.40           C  
ATOM    271  C   VAL    32      39.368  28.547   0.340  1.00 22.92           C  
ATOM    272  O   VAL    32      38.374  29.027  -0.170  1.00 23.11           O  
ATOM    273  CB  VAL    32      41.112  27.879  -1.434  1.00 25.58           C  
ATOM    274  CG1 VAL    32      41.796  29.243  -1.078  1.00 25.76           C  
ATOM    275  CG2 VAL    32      42.175  26.840  -1.736  1.00 26.45           C  
ATOM    276  N   ASP    33      39.840  28.949   1.490  1.00 21.48           N  
ATOM    277  CA  ASP    33      39.335  30.116   2.151  1.00 19.20           C  
ATOM    278  C   ASP    33      40.047  31.316   1.497  1.00 17.34           C  
ATOM    279  O   ASP    33      41.003  31.846   2.054  1.00 18.03           O  
ATOM    280  CB  ASP    33      39.747  29.960   3.601  1.00 18.89           C  
ATOM    281  CG  ASP    33      39.039  30.875   4.486  1.00 18.74           C  
ATOM    282  OD1 ASP    33      38.258  31.695   3.971  1.00 16.19           O  
ATOM    283  OD2 ASP    33      39.269  30.786   5.698  1.00 18.51           O  
ATOM    284  N   GLU    34      39.564  31.721   0.315  1.00 16.16           N  
ATOM    285  CA  GLU    34      40.199  32.771  -0.530  1.00 13.68           C  
ATOM    286  C   GLU    34      39.829  34.184  -0.062  1.00 13.01           C  
ATOM    287  O   GLU    34      38.658  34.481   0.182  1.00 12.76           O  
ATOM    288  CB  GLU    34      39.758  32.569  -1.988  1.00 13.32           C  
ATOM    289  CG  GLU    34      40.392  33.542  -2.987  1.00 14.27           C  
ATOM    290  CD  GLU    34      41.895  33.337  -3.121  1.00 17.56           C  
ATOM    291  OE1 GLU    34      42.406  32.292  -2.657  1.00 16.95           O  
ATOM    292  OE2 GLU    34      42.561  34.222  -3.687  1.00 14.35           O  
ATOM    293  N   PRO    35      40.816  35.087   0.038  1.00 12.61           N  
ATOM    294  CA  PRO    35      40.519  36.460   0.441  1.00 12.40           C  
ATOM    295  C   PRO    35      39.941  37.281  -0.696  1.00 12.19           C  
ATOM    296  O   PRO    35      39.870  36.798  -1.836  1.00 12.16           O  
ATOM    297  CB  PRO    35      41.903  37.012   0.800  1.00 13.18           C  
ATOM    298  CG  PRO    35      42.830  36.282  -0.091  1.00 11.73           C  
ATOM    299  CD  PRO    35      42.257  34.876  -0.197  1.00 12.29           C  
ATOM    300  N   LEU    36      39.553  38.525  -0.381  1.00 13.27           N  
ATOM    301  CA  LEU    36      39.129  39.442  -1.419  1.00 13.91           C  
ATOM    302  C   LEU    36      40.288  39.748  -2.367  1.00 14.60           C  
ATOM    303  O   LEU    36      41.477  39.720  -1.959  1.00 15.26           O  
ATOM    304  CB  LEU    36      38.660  40.730  -0.791  1.00 13.30           C  
ATOM    305  CG  LEU    36      37.476  40.669   0.167  1.00 11.16           C  
ATOM    306  CD1 LEU    36      37.120  42.084   0.644  1.00 12.32           C  
ATOM    307  CD2 LEU    36      36.294  40.061  -0.606  1.00 14.18           C  
ATOM    308  N   SER    37      39.942  40.002  -3.627  1.00 14.66           N  
ATOM    309  CA  SER    37      40.887  40.588  -4.581  1.00 15.07           C  
ATOM    310  C   SER    37      40.955  42.115  -4.361  1.00 16.18           C  
ATOM    311  O   SER    37      40.191  42.650  -3.561  1.00 15.86           O  
ATOM    312  CB  SER    37      40.387  40.310  -5.990  1.00 15.28           C  
ATOM    313  OG  SER    37      39.163  40.991  -6.245  1.00 15.00           O  
ATOM    314  N   GLU    38      41.843  42.819  -5.053  0.50 16.90           N  
ATOM    316  CA  GLU    38      41.822  44.275  -4.919  0.50 17.68           C  
ATOM    318  C   GLU    38      40.468  44.909  -5.349  0.50 17.34           C  
ATOM    320  O   GLU    38      39.992  45.839  -4.683  0.50 16.87           O  
ATOM    322  CB  GLU    38      43.062  44.905  -5.555  0.50 18.44           C  
ATOM    324  CG  GLU    38      44.363  44.465  -4.861  0.50 20.32           C  
ATOM    326  CD  GLU    38      44.498  45.003  -3.442  0.50 23.44           C  
ATOM    328  OE1 GLU    38      44.550  46.248  -3.280  0.50 23.55           O  
ATOM    330  OE2 GLU    38      44.564  44.191  -2.493  0.50 20.46           O  
ATOM    332  N   THR    39      39.818  44.357  -6.381  1.00 17.89           N  
ATOM    333  CA  THR    39      38.442  44.762  -6.739  1.00 18.70           C  
ATOM    334  C   THR    39      37.477  44.495  -5.573  1.00 17.31           C  
ATOM    335  O   THR    39      36.641  45.350  -5.250  1.00 16.75           O  
ATOM    336  CB  THR    39      37.965  44.078  -8.026  1.00 19.07           C  
ATOM    337  OG1 THR    39      38.780  44.507  -9.123  1.00 23.74           O  
ATOM    338  CG2 THR    39      36.491  44.402  -8.353  1.00 21.10           C  
ATOM    339  N   GLY    40      37.635  43.343  -4.911  1.00 16.64           N  
ATOM    340  CA  GLY    40      36.796  43.013  -3.755  1.00 15.47           C  
ATOM    341  C   GLY    40      36.961  43.990  -2.593  1.00 15.29           C  
ATOM    342  O   GLY    40      35.992  44.422  -1.961  1.00 14.78           O  
ATOM    343  N   PHE    41      38.204  44.362  -2.311  1.00 14.84           N  
ATOM    344  CA  PHE    41      38.482  45.341  -1.283  1.00 16.00           C  
ATOM    345  C   PHE    41      37.857  46.706  -1.643  1.00 15.44           C  
ATOM    346  O   PHE    41      37.278  47.347  -0.781  1.00 16.26           O  
ATOM    347  CB  PHE    41      39.994  45.489  -1.080  1.00 16.48           C  
ATOM    348  CG  PHE    41      40.600  44.395  -0.260  1.00 16.72           C  
ATOM    349  CD1 PHE    41      40.213  44.206   1.066  1.00 16.36           C  
ATOM    350  CD2 PHE    41      41.607  43.599  -0.798  1.00 18.31           C  
ATOM    351  CE1 PHE    41      40.788  43.184   1.839  1.00 17.37           C  
ATOM    352  CE2 PHE    41      42.194  42.576  -0.035  1.00 17.66           C  
ATOM    353  CZ  PHE    41      41.779  42.378   1.287  1.00 17.32           C  
ATOM    354  N   LYS    42      37.973  47.118  -2.900  1.00 15.99           N  
ATOM    355  CA  LYS    42      37.278  48.329  -3.408  1.00 17.34           C  
ATOM    356  C   LYS    42      35.755  48.273  -3.244  1.00 17.57           C  
ATOM    357  O   LYS    42      35.146  49.256  -2.833  1.00 16.74           O  
ATOM    358  CB  LYS    42      37.634  48.638  -4.865  1.00 18.01           C  
ATOM    359  CG  LYS    42      39.093  49.050  -5.043  1.00 21.90           C  
ATOM    360  CD  LYS    42      39.416  49.194  -6.520  1.00 25.92           C  
ATOM    361  CE  LYS    42      40.607  50.124  -6.698  1.00 31.54           C  
ATOM    362  NZ  LYS    42      40.793  50.449  -8.144  1.00 35.78           N  
ATOM    363  N   GLN    43      35.141  47.130  -3.560  1.00 17.23           N  
ATOM    364  CA  GLN    43      33.689  46.988  -3.408  1.00 16.65           C  
ATOM    365  C   GLN    43      33.281  47.098  -1.934  1.00 16.50           C  
ATOM    366  O   GLN    43      32.313  47.778  -1.603  1.00 15.99           O  
ATOM    367  CB  GLN    43      33.204  45.648  -3.998  1.00 17.02           C  
ATOM    368  CG  GLN    43      33.434  45.511  -5.503  1.00 14.54           C  
ATOM    369  CD  GLN    43      33.179  44.106  -6.005  1.00 17.25           C  
ATOM    370  OE1 GLN    43      33.287  43.143  -5.240  1.00 15.36           O  
ATOM    371  NE2 GLN    43      32.798  43.981  -7.286  1.00 17.54           N  
ATOM    372  N   ALA    44      34.049  46.460  -1.053  1.00 17.00           N  
ATOM    373  CA  ALA    44      33.780  46.481   0.362  1.00 18.25           C  
ATOM    374  C   ALA    44      33.894  47.920   0.893  1.00 18.29           C  
ATOM    375  O   ALA    44      33.071  48.365   1.710  1.00 19.67           O  
ATOM    376  CB  ALA    44      34.726  45.538   1.082  1.00 18.12           C  
ATOM    377  N   ALA    45      34.879  48.659   0.370  1.00 18.75           N  
ATOM    378  CA  ALA    45      35.095  50.055   0.802  1.00 18.36           C  
ATOM    379  C   ALA    45      33.906  50.917   0.356  1.00 17.22           C  
ATOM    380  O   ALA    45      33.358  51.719   1.139  1.00 18.63           O  
ATOM    381  CB  ALA    45      36.430  50.601   0.207  1.00 18.25           C  
ATOM    382  N   ALA    46      33.485  50.718  -0.884  1.00 17.27           N  
ATOM    383  CA  ALA    46      32.370  51.440  -1.471  1.00 17.55           C  
ATOM    384  C   ALA    46      31.100  51.155  -0.685  1.00 18.90           C  
ATOM    385  O   ALA    46      30.296  52.059  -0.395  1.00 17.88           O  
ATOM    386  CB  ALA    46      32.196  51.040  -2.903  1.00 18.02           C  
ATOM    387  N   ALA    47      30.886  49.882  -0.369  1.00 17.73           N  
ATOM    388  CA  ALA    47      29.743  49.513   0.469  1.00 18.26           C  
ATOM    389  C   ALA    47      29.810  50.180   1.851  1.00 18.11           C  
ATOM    390  O   ALA    47      28.780  50.598   2.404  1.00 19.38           O  
ATOM    391  CB  ALA    47      29.686  47.977   0.621  1.00 18.48           C  
ATOM    392  N   GLY    48      31.011  50.248   2.408  1.00 18.17           N  
ATOM    393  CA  GLY    48      31.250  50.880   3.714  1.00 19.13           C  
ATOM    394  C   GLY    48      30.921  52.359   3.648  1.00 19.49           C  
ATOM    395  O   GLY    48      30.279  52.887   4.548  1.00 20.37           O  
ATOM    396  N   ILE    49      31.301  53.017   2.557  1.00 21.18           N  
ATOM    397  CA  ILE    49      30.955  54.451   2.406  1.00 21.55           C  
ATOM    398  C   ILE    49      29.445  54.633   2.232  1.00 21.40           C  
ATOM    399  O   ILE    49      28.849  55.497   2.891  1.00 20.53           O  
ATOM    400  CB  ILE    49      31.725  55.134   1.271  1.00 21.92           C  
ATOM    401  CG1 ILE    49      33.240  55.058   1.563  1.00 22.53           C  
ATOM    402  CG2 ILE    49      31.190  56.604   1.066  1.00 23.77           C  
ATOM    403  CD1 ILE    49      34.126  55.098   0.360  1.00 25.96           C  
ATOM    404  N   PHE    50      28.825  53.794   1.396  1.00 20.95           N  
ATOM    405  CA  PHE    50      27.381  53.811   1.189  1.00 20.87           C  
ATOM    406  C   PHE    50      26.614  53.701   2.519  1.00 20.75           C  
ATOM    407  O   PHE    50      25.611  54.421   2.729  1.00 20.09           O  
ATOM    408  CB  PHE    50      26.959  52.675   0.236  1.00 21.75           C  
ATOM    409  CG  PHE    50      25.505  52.713  -0.165  1.00 21.42           C  
ATOM    410  CD1 PHE    50      25.034  53.666  -1.070  1.00 23.70           C  
ATOM    411  CD2 PHE    50      24.615  51.769   0.344  1.00 22.52           C  
ATOM    412  CE1 PHE    50      23.685  53.701  -1.454  1.00 25.31           C  
ATOM    413  CE2 PHE    50      23.278  51.778  -0.020  1.00 20.38           C  
ATOM    414  CZ  PHE    50      22.794  52.747  -0.929  1.00 23.41           C  
ATOM    415  N   LEU    51      27.106  52.823   3.398  1.00 20.65           N  
ATOM    416  CA  LEU    51      26.477  52.528   4.707  1.00 20.31           C  
ATOM    417  C   LEU    51      26.994  53.347   5.909  1.00 20.94           C  
ATOM    418  O   LEU    51      26.689  53.035   7.074  1.00 20.47           O  
ATOM    419  CB  LEU    51      26.620  51.024   5.012  1.00 20.45           C  
ATOM    420  CG  LEU    51      26.018  50.029   4.002  1.00 18.73           C  
ATOM    421  CD1 LEU    51      26.516  48.571   4.293  1.00 17.74           C  
ATOM    422  CD2 LEU    51      24.503  50.071   4.006  1.00 18.95           C  
ATOM    423  N   ASN    52      27.776  54.391   5.646  1.00 22.08           N  
ATOM    424  CA  ASN    52      28.569  54.990   6.714  1.00 24.34           C  
ATOM    425  C   ASN    52      27.711  55.621   7.834  1.00 24.30           C  
ATOM    426  O   ASN    52      28.155  55.738   8.984  1.00 24.66           O  
ATOM    427  CB  ASN    52      29.517  56.037   6.111  1.00 25.39           C  
ATOM    428  CG  ASN    52      28.787  57.295   5.740  1.00 28.11           C  
ATOM    429  OD1 ASN    52      28.587  58.166   6.588  1.00 33.96           O  
ATOM    430  ND2 ASN    52      28.315  57.376   4.501  1.00 29.08           N  
ATOM    431  N   ASN    53      26.498  56.042   7.487  1.00 25.05           N  
ATOM    432  CA  ASN    53      25.632  56.715   8.469  1.00 25.92           C  
ATOM    433  C   ASN    53      24.488  55.833   8.952  1.00 25.06           C  
ATOM    434  O   ASN    53      23.578  56.317   9.638  1.00 25.23           O  
ATOM    435  CB  ASN    53      25.075  58.026   7.904  1.00 27.15           C  
ATOM    436  CG  ASN    53      24.652  58.988   9.000  1.00 30.53           C  
ATOM    437  OD1 ASN    53      25.455  59.349   9.865  1.00 36.72           O  
ATOM    438  ND2 ASN    53      23.382  59.389   8.986  1.00 34.91           N  
ATOM    439  N   VAL    54      24.521  54.547   8.585  1.00 23.11           N  
ATOM    440  CA  VAL    54      23.505  53.626   9.060  1.00 21.47           C  
ATOM    441  C   VAL    54      23.824  53.191  10.471  1.00 21.39           C  
ATOM    442  O   VAL    54      24.938  52.731  10.780  1.00 22.40           O  
ATOM    443  CB  VAL    54      23.363  52.343   8.167  1.00 20.54           C  
ATOM    444  CG1 VAL    54      22.303  51.405   8.775  1.00 20.21           C  
ATOM    445  CG2 VAL    54      22.991  52.714   6.759  1.00 20.99           C  
ATOM    446  N   LYS    55      22.832  53.303  11.339  1.00 21.50           N  
ATOM    447  CA  LYS    55      23.011  52.869  12.707  1.00 22.40           C  
ATOM    448  C   LYS    55      22.615  51.395  12.855  1.00 21.79           C  
ATOM    449  O   LYS    55      21.475  51.073  13.260  1.00 22.74           O  
ATOM    450  CB  LYS    55      22.190  53.741  13.659  1.00 23.17           C  
ATOM    451  CG  LYS    55      22.523  55.236  13.533  1.00 26.63           C  
ATOM    452  CD  LYS    55      22.200  55.945  14.829  1.00 32.13           C  
ATOM    453  CE  LYS    55      22.697  57.386  14.808  1.00 34.40           C  
ATOM    454  NZ  LYS    55      22.953  57.903  16.192  1.00 36.92           N  
ATOM    455  N   PHE    56      23.546  50.503  12.539  1.00 20.73           N  
ATOM    456  CA  PHE    56      23.337  49.078  12.823  1.00 19.15           C  
ATOM    457  C   PHE    56      23.510  48.812  14.304  1.00 19.61           C  
ATOM    458  O   PHE    56      24.285  49.504  15.000  1.00 21.15           O  
ATOM    459  CB  PHE    56      24.321  48.167  12.053  1.00 18.58           C  
ATOM    460  CG  PHE    56      24.172  48.230  10.567  1.00 17.80           C  
ATOM    461  CD1 PHE    56      23.018  47.719   9.935  1.00 14.64           C  
ATOM    462  CD2 PHE    56      25.183  48.753   9.779  1.00 16.61           C  
ATOM    463  CE1 PHE    56      22.881  47.789   8.533  1.00 14.77           C  
ATOM    464  CE2 PHE    56      25.061  48.793   8.381  1.00 16.45           C  
ATOM    465  CZ  PHE    56      23.904  48.324   7.749  1.00 14.90           C  
ATOM    466  N   THR    57      22.861  47.749  14.765  1.00 17.09           N  
ATOM    467  CA  THR    57      22.898  47.326  16.146  1.00 16.54           C  
ATOM    468  C   THR    57      23.611  45.992  16.347  1.00 16.67           C  
ATOM    469  O   THR    57      24.075  45.688  17.445  1.00 17.10           O  
ATOM    470  CB  THR    57      21.474  47.200  16.744  1.00 17.55           C  
ATOM    471  OG1 THR    57      20.692  46.278  15.957  1.00 14.51           O  
ATOM    472  CG2 THR    57      20.772  48.546  16.751  1.00 15.49           C  
ATOM    473  N   HIS    58      23.659  45.185  15.272  1.00 15.40           N  
ATOM    474  CA  HIS    58      24.258  43.857  15.350  1.00 14.88           C  
ATOM    475  C   HIS    58      24.974  43.589  14.027  1.00 14.04           C  
ATOM    476  O   HIS    58      24.557  44.082  12.977  1.00 13.96           O  
ATOM    477  CB  HIS    58      23.178  42.780  15.466  1.00 13.38           C  
ATOM    478  CG  HIS    58      22.385  42.839  16.735  1.00 14.77           C  
ATOM    479  ND1 HIS    58      21.409  43.785  16.961  1.00 15.83           N  
ATOM    480  CD2 HIS    58      22.419  42.059  17.838  1.00 15.46           C  
ATOM    481  CE1 HIS    58      20.892  43.595  18.164  1.00 17.07           C  
ATOM    482  NE2 HIS    58      21.460  42.535  18.700  1.00 15.53           N  
ATOM    483  N   ALA    59      26.044  42.806  14.100  1.00 13.04           N  
ATOM    484  CA  ALA    59      26.787  42.411  12.878  1.00 13.95           C  
ATOM    485  C   ALA    59      27.139  40.942  12.968  1.00 14.25           C  
ATOM    486  O   ALA    59      27.758  40.502  13.951  1.00 14.77           O  
ATOM    487  CB  ALA    59      28.058  43.213  12.703  1.00 14.18           C  
ATOM    488  N   PHE    60      26.778  40.185  11.930  1.00 12.96           N  
ATOM    489  CA  PHE    60      27.139  38.760  11.816  1.00 12.74           C  
ATOM    490  C   PHE    60      27.780  38.498  10.478  1.00 12.41           C  
ATOM    491  O   PHE    60      27.340  39.056   9.465  1.00 13.16           O  
ATOM    492  CB  PHE    60      25.911  37.831  11.919  1.00 13.31           C  
ATOM    493  CG  PHE    60      25.207  37.891  13.256  1.00 13.17           C  
ATOM    494  CD1 PHE    60      25.482  36.946  14.244  1.00 15.99           C  
ATOM    495  CD2 PHE    60      24.249  38.868  13.490  1.00 16.08           C  
ATOM    496  CE1 PHE    60      24.827  36.980  15.485  1.00 17.65           C  
ATOM    497  CE2 PHE    60      23.575  38.909  14.728  1.00 17.11           C  
ATOM    498  CZ  PHE    60      23.877  37.976  15.714  1.00 15.95           C  
ATOM    499  N   SER    61      28.775  37.602  10.451  1.00 11.13           N  
ATOM    500  CA  SER    61      29.467  37.297   9.202  1.00 12.21           C  
ATOM    501  C   SER    61      29.727  35.794   9.216  1.00 11.56           C  
ATOM    502  O   SER    61      29.983  35.205  10.263  1.00 12.53           O  
ATOM    503  CB  SER    61      30.800  38.071   9.126  1.00 11.54           C  
ATOM    504  OG  SER    61      31.557  37.684   7.995  1.00 14.79           O  
ATOM    505  N   SER    62      29.687  35.174   8.047  1.00 10.94           N  
ATOM    506  CA  SER    62      30.357  33.901   7.851  1.00 11.59           C  
ATOM    507  C   SER    62      31.798  33.973   8.360  1.00 11.84           C  
ATOM    508  O   SER    62      32.420  35.019   8.272  1.00 11.46           O  
ATOM    509  CB  SER    62      30.392  33.669   6.338  1.00 12.08           C  
ATOM    510  OG  SER    62      31.297  32.701   6.015  1.00 16.57           O  
ATOM    511  N   ASP    63      32.276  32.831   8.853  0.50 12.21           N  
ATOM    513  CA  ASP    63      33.641  32.659   9.378  0.50 13.48           C  
ATOM    515  C   ASP    63      34.594  32.183   8.266  0.50 13.52           C  
ATOM    517  O   ASP    63      35.392  31.242   8.442  0.50 13.40           O  
ATOM    519  CB  ASP    63      33.669  31.742  10.624  0.50 13.93           C  
ATOM    521  CG  ASP    63      33.182  30.313  10.355  0.50 14.36           C  
ATOM    523  OD1 ASP    63      32.267  30.105   9.530  0.50 10.93           O  
ATOM    525  OD2 ASP    63      33.724  29.377  10.988  0.50 15.00           O  
ATOM    527  N   LEU    64      34.455  32.830   7.104  1.00 14.85           N  
ATOM    528  CA  LEU    64      35.372  32.683   5.974  1.00 14.13           C  
ATOM    529  C   LEU    64      36.040  34.045   5.711  1.00 13.74           C  
ATOM    530  O   LEU    64      35.487  35.081   6.092  1.00 12.53           O  
ATOM    531  CB  LEU    64      34.610  32.144   4.735  1.00 14.06           C  
ATOM    532  CG  LEU    64      34.112  30.684   4.857  1.00 15.57           C  
ATOM    533  CD1 LEU    64      33.222  30.172   3.726  1.00 16.81           C  
ATOM    534  CD2 LEU    64      35.373  29.730   5.011  1.00 16.50           C  
ATOM    535  N   MET    65      37.244  34.054   5.120  1.00 13.80           N  
ATOM    536  CA  MET    65      37.997  35.312   4.978  1.00 14.27           C  
ATOM    537  C   MET    65      37.259  36.328   4.141  1.00 12.80           C  
ATOM    538  O   MET    65      37.249  37.513   4.483  1.00 12.68           O  
ATOM    539  CB  MET    65      39.344  35.088   4.268  1.00 14.39           C  
ATOM    540  CG  MET    65      40.368  34.551   5.151  1.00 19.40           C  
ATOM    541  SD  MET    65      42.061  34.816   4.234  1.00 17.57          SE  
ATOM    542  CE  MET    65      42.703  36.459   4.953  1.00 18.75           C  
ATOM    543  N   ARG    66      36.664  35.878   3.035  1.00 11.81           N  
ATOM    544  CA  ARG    66      36.066  36.820   2.071  1.00 11.30           C  
ATOM    545  C   ARG    66      34.928  37.632   2.693  1.00 12.24           C  
ATOM    546  O   ARG    66      34.802  38.856   2.479  1.00 11.93           O  
ATOM    547  CB  ARG    66      35.654  36.107   0.777  1.00 10.46           C  
ATOM    548  CG  ARG    66      34.682  34.894   0.959  1.00 10.29           C  
ATOM    549  CD  ARG    66      34.627  34.203  -0.373  1.00 12.79           C  
ATOM    550  NE  ARG    66      33.700  33.054  -0.470  1.00 11.27           N  
ATOM    551  CZ  ARG    66      33.988  31.816  -0.053  1.00 14.16           C  
ATOM    552  NH1 ARG    66      33.126  30.849  -0.290  1.00 12.57           N  
ATOM    553  NH2 ARG    66      35.111  31.536   0.612  1.00 11.25           N  
ATOM    554  N   THR    67      34.149  36.966   3.543  1.00 11.56           N  
ATOM    555  CA  THR    67      33.050  37.640   4.242  1.00 12.08           C  
ATOM    556  C   THR    67      33.622  38.488   5.417  1.00 11.63           C  
ATOM    557  O   THR    67      33.223  39.648   5.611  1.00 12.77           O  
ATOM    558  CB  THR    67      32.050  36.601   4.741  1.00 10.04           C  
ATOM    559  OG1 THR    67      32.796  35.490   5.240  1.00 12.29           O  
ATOM    560  CG2 THR    67      31.131  36.086   3.571  1.00 11.13           C  
ATOM    561  N   LYS    68      34.592  37.937   6.151  1.00 13.01           N  
ATOM    562  CA  LYS    68      35.199  38.673   7.299  1.00 13.10           C  
ATOM    563  C   LYS    68      35.821  40.001   6.795  1.00 11.78           C  
ATOM    564  O   LYS    68      35.613  41.042   7.377  1.00 11.93           O  
ATOM    565  CB  LYS    68      36.239  37.809   8.024  1.00 13.79           C  
ATOM    566  CG  LYS    68      37.010  38.545   9.119  1.00 16.70           C  
ATOM    567  CD  LYS    68      37.820  37.554   9.999  1.00 17.70           C  
ATOM    568  CE  LYS    68      38.271  38.243  11.310  1.00 22.84           C  
ATOM    569  NZ  LYS    68      38.987  37.265  12.187  1.00 25.71           N  
ATOM    570  N   GLN    69      36.578  39.925   5.702  1.00 11.45           N  
ATOM    571  CA  GLN    69      37.230  41.109   5.149  1.00 12.01           C  
ATOM    572  C   GLN    69      36.212  42.128   4.655  1.00 12.80           C  
ATOM    573  O   GLN    69      36.421  43.360   4.776  1.00 12.36           O  
ATOM    574  CB  GLN    69      38.143  40.690   4.024  1.00 11.90           C  
ATOM    575  CG  GLN    69      39.389  39.947   4.540  1.00 11.34           C  
ATOM    576  CD  GLN    69      40.288  39.535   3.414  1.00 14.07           C  
ATOM    577  OE1 GLN    69      39.807  39.100   2.363  1.00 12.32           O  
ATOM    578  NE2 GLN    69      41.613  39.608   3.639  1.00 15.02           N  
ATOM    579  N   THR    70      35.107  41.621   4.080  1.00 12.32           N  
ATOM    580  CA  THR    70      34.067  42.536   3.591  1.00 12.94           C  
ATOM    581  C   THR    70      33.409  43.288   4.778  1.00 12.24           C  
ATOM    582  O   THR    70      33.180  44.519   4.705  1.00 12.26           O  
ATOM    583  CB  THR    70      33.005  41.781   2.757  1.00 12.52           C  
ATOM    584  OG1 THR    70      33.657  41.176   1.623  1.00 12.51           O  
ATOM    585  CG2 THR    70      31.874  42.738   2.253  1.00 11.26           C  
ATOM    586  N   MET    71      33.076  42.532   5.819  1.00 12.95           N  
ATOM    587  CA  MET    71      32.513  43.084   7.054  1.00 14.04           C  
ATOM    588  C   MET    71      33.506  44.129   7.601  1.00 15.16           C  
ATOM    589  O   MET    71      33.100  45.209   8.015  1.00 14.69           O  
ATOM    590  CB  MET    71      32.311  42.000   8.084  1.00 14.72           C  
ATOM    591  CG  MET    71      31.741  42.503   9.416  1.00 16.03           C  
ATOM    592  SD  MET    71      30.009  43.366   9.266  1.00 12.53          SE  
ATOM    593  CE  MET    71      28.976  41.707   9.223  1.00 13.52           C  
ATOM    594  N   HIS    72      34.798  43.805   7.570  1.00 15.73           N  
ATOM    595  CA  HIS    72      35.798  44.765   8.079  1.00 17.92           C  
ATOM    596  C   HIS    72      35.799  46.068   7.279  1.00 18.23           C  
ATOM    597  O   HIS    72      35.806  47.170   7.877  1.00 18.65           O  
ATOM    598  CB  HIS    72      37.197  44.172   8.104  1.00 18.26           C  
ATOM    599  CG  HIS    72      38.231  45.134   8.616  1.00 22.21           C  
ATOM    600  ND1 HIS    72      38.329  45.480   9.946  1.00 26.17           N  
ATOM    601  CD2 HIS    72      39.186  45.851   7.968  1.00 26.64           C  
ATOM    602  CE1 HIS    72      39.323  46.337  10.106  1.00 25.60           C  
ATOM    603  NE2 HIS    72      39.856  46.583   8.920  1.00 28.23           N  
ATOM    604  N   GLY    73      35.786  45.922   5.950  1.00 17.64           N  
ATOM    605  CA  GLY    73      35.749  47.021   4.982  1.00 18.22           C  
ATOM    606  C   GLY    73      34.553  47.914   5.241  1.00 18.59           C  
ATOM    607  O   GLY    73      34.632  49.135   5.137  1.00 17.35           O  
ATOM    608  N   ILE    74      33.422  47.293   5.569  1.00 17.82           N  
ATOM    609  CA  ILE    74      32.208  48.049   5.833  1.00 18.14           C  
ATOM    610  C   ILE    74      32.322  48.766   7.168  1.00 19.12           C  
ATOM    611  O   ILE    74      32.124  49.976   7.216  1.00 20.75           O  
ATOM    612  CB  ILE    74      30.929  47.127   5.787  1.00 17.24           C  
ATOM    613  CG1 ILE    74      30.633  46.719   4.347  1.00 18.41           C  
ATOM    614  CG2 ILE    74      29.716  47.847   6.393  1.00 17.25           C  
ATOM    615  CD1 ILE    74      29.677  45.514   4.249  1.00 17.62           C  
ATOM    616  N   LEU    75      32.660  48.047   8.242  1.00 20.26           N  
ATOM    617  CA  LEU    75      32.654  48.660   9.584  1.00 20.39           C  
ATOM    618  C   LEU    75      33.748  49.711   9.784  1.00 21.93           C  
ATOM    619  O   LEU    75      33.506  50.723  10.442  1.00 21.81           O  
ATOM    620  CB  LEU    75      32.682  47.618  10.687  1.00 20.74           C  
ATOM    621  CG  LEU    75      31.457  46.705  10.768  1.00 18.86           C  
ATOM    622  CD1 LEU    75      31.706  45.688  11.869  1.00 20.32           C  
ATOM    623  CD2 LEU    75      30.175  47.516  10.991  1.00 20.37           C  
ATOM    624  N   GLU    76      34.907  49.519   9.165  1.00 22.34           N  
ATOM    625  CA  GLU    76      35.997  50.479   9.357  1.00 25.10           C  
ATOM    626  C   GLU    76      35.621  51.889   8.865  1.00 25.23           C  
ATOM    627  O   GLU    76      36.219  52.863   9.314  1.00 26.75           O  
ATOM    628  CB  GLU    76      37.318  49.973   8.753  1.00 24.36           C  
ATOM    629  CG  GLU    76      37.476  50.167   7.255  1.00 25.72           C  
ATOM    630  CD  GLU    76      38.694  49.424   6.693  1.00 27.22           C  
ATOM    631  OE1 GLU    76      39.583  49.024   7.479  1.00 30.93           O  
ATOM    632  OE2 GLU    76      38.774  49.240   5.461  1.00 32.26           O  
ATOM    633  N   ARG    77      34.624  51.982   7.977  1.00 25.58           N  
ATOM    634  CA  ARG    77      34.132  53.257   7.427  1.00 26.51           C  
ATOM    635  C   ARG    77      32.831  53.782   8.025  1.00 26.65           C  
ATOM    636  O   ARG    77      32.262  54.749   7.501  1.00 26.66           O  
ATOM    637  CB  ARG    77      33.949  53.141   5.920  1.00 26.38           C  
ATOM    638  CG  ARG    77      35.290  53.011   5.227  1.00 27.67           C  
ATOM    639  CD  ARG    77      35.178  52.485   3.846  1.00 30.97           C  
ATOM    640  NE  ARG    77      36.510  52.433   3.255  1.00 30.98           N  
ATOM    641  CZ  ARG    77      37.312  51.372   3.292  1.00 35.20           C  
ATOM    642  NH1 ARG    77      38.520  51.454   2.715  1.00 36.34           N  
ATOM    643  NH2 ARG    77      36.910  50.228   3.875  1.00 28.89           N  
ATOM    644  N   SER    78      32.357  53.130   9.079  1.00 26.15           N  
ATOM    645  CA  SER    78      31.086  53.486   9.669  1.00 27.03           C  
ATOM    646  C   SER    78      31.300  54.636  10.634  1.00 27.68           C  
ATOM    647  O   SER    78      32.276  54.646  11.391  1.00 27.16           O  
ATOM    648  CB  SER    78      30.468  52.308  10.416  1.00 26.71           C  
ATOM    649  OG  SER    78      29.259  52.707  11.068  1.00 26.27           O  
ATOM    650  N   LYS    79      30.379  55.591  10.600  1.00 29.19           N  
ATOM    651  CA  LYS    79      30.364  56.674  11.605  1.00 30.36           C  
ATOM    652  C   LYS    79      30.015  56.189  13.025  1.00 30.63           C  
ATOM    653  O   LYS    79      30.639  56.613  14.014  1.00 30.77           O  
ATOM    654  CB  LYS    79      29.411  57.772  11.163  1.00 30.35           C  
ATOM    655  CG  LYS    79      29.804  58.387   9.823  1.00 34.19           C  
ATOM    656  CD  LYS    79      28.840  59.478   9.389  1.00 38.11           C  
ATOM    657  CE  LYS    79      29.545  60.497   8.510  1.00 41.68           C  
ATOM    658  NZ  LYS    79      30.320  59.884   7.374  1.00 44.79           N  
ATOM    659  N   PHE    80      29.039  55.283  13.132  1.00 30.30           N  
ATOM    660  CA  PHE    80      28.579  54.815  14.441  1.00 29.95           C  
ATOM    661  C   PHE    80      29.020  53.438  14.871  1.00 29.66           C  
ATOM    662  O   PHE    80      29.052  53.163  16.069  1.00 29.18           O  
ATOM    663  CB  PHE    80      27.053  54.898  14.522  1.00 31.44           C  
ATOM    664  CG  PHE    80      26.530  56.235  14.154  1.00 34.11           C  
ATOM    665  CD1 PHE    80      26.564  57.278  15.077  1.00 37.99           C  
ATOM    666  CD2 PHE    80      26.056  56.478  12.874  1.00 35.72           C  
ATOM    667  CE1 PHE    80      26.106  58.537  14.729  1.00 38.23           C  
ATOM    668  CE2 PHE    80      25.597  57.722  12.519  1.00 39.19           C  
ATOM    669  CZ  PHE    80      25.623  58.758  13.446  1.00 38.01           C  
ATOM    670  N   CYS    81      29.366  52.575  13.910  1.00 28.01           N  
ATOM    671  CA  CYS    81      29.606  51.158  14.197  1.00 27.84           C  
ATOM    672  C   CYS    81      31.044  50.686  13.981  1.00 27.70           C  
ATOM    673  O   CYS    81      31.309  49.485  14.007  1.00 26.84           O  
ATOM    674  CB  CYS    81      28.645  50.276  13.398  1.00 27.28           C  
ATOM    675  SG  CYS    81      26.920  50.779  13.612  1.00 28.89           S  
ATOM    676  N   LYS    82      31.985  51.617  13.832  1.00 27.45           N  
ATOM    677  CA  LYS    82      33.403  51.222  13.766  1.00 28.50           C  
ATOM    678  C   LYS    82      33.834  50.144  14.796  1.00 27.82           C  
ATOM    679  O   LYS    82      34.547  49.182  14.454  1.00 28.25           O  
ATOM    680  CB  LYS    82      34.281  52.465  13.927  1.00 28.86           C  
ATOM    681  CG  LYS    82      35.101  52.816  12.713  1.00 32.47           C  
ATOM    682  CD  LYS    82      36.212  53.785  13.150  1.00 36.51           C  
ATOM    683  CE  LYS    82      37.407  53.769  12.213  1.00 39.21           C  
ATOM    684  NZ  LYS    82      38.422  54.834  12.584  1.00 41.30           N  
ATOM    685  N   ASP    83      33.375  50.304  16.039  1.00 27.50           N  
ATOM    686  CA  ASP    83      33.775  49.512  17.197  1.00 28.02           C  
ATOM    687  C   ASP    83      32.878  48.306  17.488  1.00 27.52           C  
ATOM    688  O   ASP    83      33.135  47.570  18.441  1.00 26.64           O  
ATOM    689  CB  ASP    83      33.731  50.395  18.458  1.00 29.41           C  
ATOM    690  CG  ASP    83      35.074  50.979  18.833  1.00 33.35           C  
ATOM    691  OD1 ASP    83      36.018  50.982  18.002  1.00 37.87           O  
ATOM    692  OD2 ASP    83      35.171  51.465  19.991  1.00 39.80           O  
ATOM    693  N   MET    84      31.827  48.123  16.684  1.00 27.33           N  
ATOM    694  CA  MET    84      30.888  47.015  16.853  1.00 27.36           C  
ATOM    695  C   MET    84      31.554  45.635  16.835  1.00 26.64           C  
ATOM    696  O   MET    84      32.397  45.363  15.972  1.00 26.44           O  
ATOM    697  CB  MET    84      29.828  47.074  15.754  1.00 27.33           C  
ATOM    698  CG  MET    84      28.843  45.919  15.820  1.00 29.83           C  
ATOM    699  SD  MET    84      27.184  46.452  15.025  1.00 28.68          SE  
ATOM    700  CE  MET    84      26.622  47.647  16.472  1.00 31.10           C  
ATOM    701  N   THR    85      31.151  44.771  17.770  1.00 25.42           N  
ATOM    702  CA  THR    85      31.643  43.400  17.829  1.00 25.35           C  
ATOM    703  C   THR    85      30.957  42.626  16.710  1.00 23.90           C  
ATOM    704  O   THR    85      29.733  42.626  16.620  1.00 25.42           O  
ATOM    705  CB  THR    85      31.307  42.725  19.175  1.00 26.00           C  
ATOM    706  OG1 THR    85      31.981  43.414  20.236  1.00 30.50           O  
ATOM    707  CG2 THR    85      31.750  41.256  19.191  1.00 26.88           C  
ATOM    708  N   VAL    86      31.747  41.998  15.858  1.00 21.60           N  
ATOM    709  CA  VAL    86      31.200  41.111  14.828  1.00 20.01           C  
ATOM    710  C   VAL    86      31.084  39.709  15.396  1.00 19.18           C  
ATOM    711  O   VAL    86      32.048  39.192  15.994  1.00 18.56           O  
ATOM    712  CB  VAL    86      32.133  41.078  13.584  1.00 19.70           C  
ATOM    713  CG1 VAL    86      31.600  40.066  12.497  1.00 19.54           C  
ATOM    714  CG2 VAL    86      32.330  42.463  13.026  1.00 19.51           C  
ATOM    715  N   LYS    87      29.931  39.060  15.205  1.00 18.68           N  
ATOM    716  CA  LYS    87      29.822  37.655  15.569  1.00 18.36           C  
ATOM    717  C   LYS    87      30.030  36.774  14.329  1.00 18.76           C  
ATOM    718  O   LYS    87      29.404  37.017  13.300  1.00 17.89           O  
ATOM    719  CB  LYS    87      28.465  37.363  16.219  1.00 20.32           C  
ATOM    720  CG  LYS    87      28.207  38.121  17.539  1.00 23.26           C  
ATOM    721  CD  LYS    87      28.881  37.441  18.727  1.00 29.51           C  
ATOM    722  CE  LYS    87      28.862  38.306  20.018  1.00 29.46           C  
ATOM    723  NZ  LYS    87      27.499  38.859  20.350  1.00 34.69           N  
ATOM    724  N   TYR    88      30.908  35.778  14.414  1.00 17.24           N  
ATOM    725  CA  TYR    88      31.205  34.925  13.245  1.00 17.08           C  
ATOM    726  C   TYR    88      30.472  33.634  13.446  1.00 17.77           C  
ATOM    727  O   TYR    88      30.595  33.005  14.519  1.00 19.09           O  
ATOM    728  CB  TYR    88      32.723  34.681  13.083  1.00 16.63           C  
ATOM    729  CG  TYR    88      33.416  35.982  12.807  1.00 16.87           C  
ATOM    730  CD1 TYR    88      33.417  36.518  11.521  1.00 15.13           C  
ATOM    731  CD2 TYR    88      33.947  36.751  13.855  1.00 19.18           C  
ATOM    732  CE1 TYR    88      33.996  37.748  11.259  1.00 16.39           C  
ATOM    733  CE2 TYR    88      34.524  37.980  13.606  1.00 16.91           C  
ATOM    734  CZ  TYR    88      34.548  38.461  12.314  1.00 18.38           C  
ATOM    735  OH  TYR    88      35.119  39.660  12.080  1.00 18.80           O  
ATOM    736  N   ASP    89      29.706  33.225  12.429  1.00 15.32           N  
ATOM    737  CA  ASP    89      28.752  32.138  12.598  1.00 14.95           C  
ATOM    738  C   ASP    89      28.880  31.221  11.400  1.00 14.21           C  
ATOM    739  O   ASP    89      28.637  31.632  10.269  1.00 13.18           O  
ATOM    740  CB  ASP    89      27.320  32.705  12.754  1.00 13.62           C  
ATOM    741  CG  ASP    89      26.326  31.703  13.309  1.00 17.57           C  
ATOM    742  OD1 ASP    89      26.216  30.557  12.790  1.00 16.56           O  
ATOM    743  OD2 ASP    89      25.635  32.056  14.296  1.00 18.76           O  
ATOM    744  N   SER    90      29.255  29.979  11.660  1.00 13.24           N  
ATOM    745  CA  SER    90      29.434  28.988  10.594  1.00 13.21           C  
ATOM    746  C   SER    90      28.127  28.694   9.846  1.00 12.15           C  
ATOM    747  O   SER    90      28.166  28.199   8.726  1.00 12.17           O  
ATOM    748  CB  SER    90      30.017  27.664  11.149  1.00 14.65           C  
ATOM    749  OG  SER    90      29.081  27.013  11.999  1.00 16.86           O  
ATOM    750  N   ARG    91      26.978  28.922  10.475  1.00 11.21           N  
ATOM    751  CA  ARG    91      25.693  28.726   9.753  1.00 11.52           C  
ATOM    752  C   ARG    91      25.545  29.632   8.523  1.00 10.85           C  
ATOM    753  O   ARG    91      24.752  29.346   7.617  1.00 11.71           O  
ATOM    754  CB  ARG    91      24.487  28.872  10.673  1.00 10.94           C  
ATOM    755  CG  ARG    91      24.441  27.792  11.768  1.00 13.03           C  
ATOM    756  CD  ARG    91      23.351  28.149  12.747  1.00 15.77           C  
ATOM    757  NE  ARG    91      23.786  29.244  13.608  1.00 15.09           N  
ATOM    758  CZ  ARG    91      23.191  29.560  14.752  1.00 17.43           C  
ATOM    759  NH1 ARG    91      22.113  28.881  15.146  1.00 16.56           N  
ATOM    760  NH2 ARG    91      23.653  30.574  15.469  1.00 16.42           N  
ATOM    761  N   LEU    92      26.309  30.720   8.483  1.00 10.05           N  
ATOM    762  CA  LEU    92      26.264  31.669   7.370  1.00 10.24           C  
ATOM    763  C   LEU    92      27.184  31.304   6.192  1.00 10.17           C  
ATOM    764  O   LEU    92      27.289  32.071   5.230  1.00  9.19           O  
ATOM    765  CB  LEU    92      26.659  33.064   7.888  1.00 10.64           C  
ATOM    766  CG  LEU    92      25.647  33.620   8.896  1.00  7.81           C  
ATOM    767  CD1 LEU    92      26.151  34.998   9.449  1.00  9.51           C  
ATOM    768  CD2 LEU    92      24.265  33.840   8.216  1.00  9.67           C  
ATOM    769  N   ARG    93      27.896  30.172   6.322  1.00  9.79           N  
ATOM    770  CA  ARG    93      28.920  29.832   5.307  0.50 10.74           C  
ATOM    772  C   ARG    93      28.293  29.473   3.946  1.00 10.23           C  
ATOM    773  O   ARG    93      27.130  29.136   3.852  1.00  9.45           O  
ATOM    774  CB  ARG    93      29.871  28.723   5.810  0.50 10.99           C  
ATOM    776  CG  ARG    93      30.830  29.182   6.953  0.50 10.53           C  
ATOM    778  CD  ARG    93      31.618  28.043   7.722  0.50 13.00           C  
ATOM    780  NE  ARG    93      32.947  27.783   7.170  0.50 16.63           N  
ATOM    782  CZ  ARG    93      33.539  26.581   7.087  0.50 18.09           C  
ATOM    784  NH1 ARG    93      34.723  26.475   6.518  0.50 20.66           N  
ATOM    786  NH2 ARG    93      32.953  25.481   7.538  0.50 21.05           N  
ATOM    788  N   GLU    94      29.087  29.574   2.874  1.00  9.81           N  
ATOM    789  CA  GLU    94      28.566  29.225   1.559  1.00  9.24           C  
ATOM    790  C   GLU    94      28.222  27.720   1.486  1.00  8.74           C  
ATOM    791  O   GLU    94      28.737  26.905   2.264  1.00 10.34           O  
ATOM    792  CB  GLU    94      29.576  29.564   0.464  1.00 11.27           C  
ATOM    793  CG  GLU    94      29.088  29.349  -0.995  1.00 12.74           C  
ATOM    794  CD  GLU    94      27.785  30.006  -1.403  1.00 10.47           C  
ATOM    795  OE1 GLU    94      26.737  29.737  -0.779  1.00 14.15           O  
ATOM    796  OE2 GLU    94      27.760  30.741  -2.438  1.00 16.89           O  
ATOM    797  N   ARG    95      27.340  27.399   0.548  1.00  9.78           N  
ATOM    798  CA  ARG    95      27.030  25.998   0.196  1.00  9.41           C  
ATOM    799  C   ARG    95      28.352  25.240  -0.046  1.00 10.34           C  
ATOM    800  O   ARG    95      29.275  25.768  -0.680  1.00 10.97           O  
ATOM    801  CB  ARG    95      26.208  26.018  -1.105  1.00 10.13           C  
ATOM    802  CG  ARG    95      25.946  24.628  -1.684  1.00 11.28           C  
ATOM    803  CD  ARG    95      24.903  24.690  -2.839  1.00 10.27           C  
ATOM    804  NE  ARG    95      24.391  23.349  -3.179  1.00 11.61           N  
ATOM    805  CZ  ARG    95      23.752  23.052  -4.310  1.00 14.85           C  
ATOM    806  NH1 ARG    95      23.582  23.987  -5.240  1.00 13.49           N  
ATOM    807  NH2 ARG    95      23.327  21.791  -4.534  1.00 15.15           N  
ATOM    808  N   LYS    96      28.445  24.020   0.483  1.00 10.77           N  
ATOM    809  CA  LYS    96      29.595  23.136   0.192  1.00 11.17           C  
ATOM    810  C   LYS    96      29.486  22.581  -1.218  1.00 10.95           C  
ATOM    811  O   LYS    96      28.428  22.118  -1.598  1.00 10.65           O  
ATOM    812  CB  LYS    96      29.583  21.978   1.171  1.00 11.63           C  
ATOM    813  CG  LYS    96      30.032  22.318   2.529  1.00 13.62           C  
ATOM    814  CD  LYS    96      29.955  21.039   3.375  1.00 16.90           C  
ATOM    815  CE  LYS    96      30.787  21.227   4.642  1.00 21.22           C  
ATOM    816  NZ  LYS    96      30.972  19.848   5.295  1.00 27.76           N  
ATOM    817  N   TYR    97      30.603  22.551  -1.955  1.00 11.30           N  
ATOM    818  CA  TYR    97      30.624  21.926  -3.290  1.00 12.22           C  
ATOM    819  C   TYR    97      31.571  20.706  -3.360  1.00 11.94           C  
ATOM    820  O   TYR    97      31.841  20.166  -4.447  1.00 12.35           O  
ATOM    821  CB  TYR    97      31.000  22.967  -4.355  1.00 13.04           C  
ATOM    822  CG  TYR    97      29.936  24.034  -4.515  1.00 14.72           C  
ATOM    823  CD1 TYR    97      28.774  23.798  -5.274  1.00 14.38           C  
ATOM    824  CD2 TYR    97      30.088  25.270  -3.896  1.00 15.43           C  
ATOM    825  CE1 TYR    97      27.810  24.791  -5.393  1.00 14.73           C  
ATOM    826  CE2 TYR    97      29.122  26.262  -4.010  1.00 12.53           C  
ATOM    827  CZ  TYR    97      27.999  26.014  -4.720  1.00 14.34           C  
ATOM    828  OH  TYR    97      27.092  27.032  -4.827  1.00 16.25           O  
ATOM    829  N   GLY    98      32.089  20.291  -2.206  1.00 11.77           N  
ATOM    830  CA  GLY    98      32.826  19.036  -2.111  1.00 12.24           C  
ATOM    831  C   GLY    98      33.949  18.921  -3.124  1.00 11.83           C  
ATOM    832  O   GLY    98      34.843  19.794  -3.224  1.00 11.40           O  
ATOM    833  N   VAL    99      33.936  17.809  -3.851  1.00 12.50           N  
ATOM    834  CA  VAL    99      35.079  17.516  -4.759  1.00 12.04           C  
ATOM    835  C   VAL    99      35.247  18.503  -5.926  1.00 13.67           C  
ATOM    836  O   VAL    99      36.288  18.456  -6.634  1.00 14.68           O  
ATOM    837  CB  VAL    99      34.966  16.107  -5.330  1.00 12.48           C  
ATOM    838  CG1 VAL    99      34.952  15.066  -4.205  1.00 11.02           C  
ATOM    839  CG2 VAL    99      33.676  16.004  -6.206  1.00 10.02           C  
ATOM    840  N   VAL   100      34.243  19.356  -6.190  1.00 13.11           N  
ATOM    841  CA  VAL   100      34.429  20.384  -7.258  1.00 14.81           C  
ATOM    842  C   VAL   100      34.881  21.755  -6.749  1.00 14.74           C  
ATOM    843  O   VAL   100      35.011  22.702  -7.539  1.00 14.67           O  
ATOM    844  CB  VAL   100      33.220  20.532  -8.215  1.00 15.29           C  
ATOM    845  CG1 VAL   100      32.946  19.211  -8.916  1.00 19.59           C  
ATOM    846  CG2 VAL   100      32.006  20.981  -7.464  1.00 14.33           C  
ATOM    847  N   GLU   101      35.136  21.874  -5.446  1.00 14.02           N  
ATOM    848  CA  GLU   101      35.714  23.106  -4.924  1.00 14.89           C  
ATOM    849  C   GLU   101      37.010  23.377  -5.661  1.00 16.00           C  
ATOM    850  O   GLU   101      37.861  22.484  -5.742  1.00 16.46           O  
ATOM    851  CB  GLU   101      36.007  22.975  -3.420  1.00 15.96           C  
ATOM    852  CG  GLU   101      34.792  22.693  -2.590  1.00 18.68           C  
ATOM    853  CD  GLU   101      34.050  23.919  -2.181  1.00 21.81           C  
ATOM    854  OE1 GLU   101      34.382  25.012  -2.728  1.00 23.06           O  
ATOM    855  OE2 GLU   101      33.145  23.767  -1.300  1.00 19.19           O  
ATOM    856  N   GLY   102      37.147  24.585  -6.197  1.00 16.89           N  
ATOM    857  CA  GLY   102      38.361  24.997  -6.908  1.00 18.62           C  
ATOM    858  C   GLY   102      38.395  24.590  -8.367  1.00 19.14           C  
ATOM    859  O   GLY   102      39.412  24.832  -9.049  1.00 20.07           O  
ATOM    860  N   LYS   103      37.291  24.032  -8.876  1.00 18.98           N  
ATOM    861  CA  LYS   103      37.197  23.699 -10.299  1.00 20.92           C  
ATOM    862  C   LYS   103      36.380  24.757 -11.029  1.00 21.03           C  
ATOM    863  O   LYS   103      35.632  25.519 -10.411  1.00 20.19           O  
ATOM    864  CB  LYS   103      36.570  22.310 -10.518  1.00 20.50           C  
ATOM    865  CG  LYS   103      37.190  21.159  -9.715  1.00 22.86           C  
ATOM    866  CD  LYS   103      38.507  20.669 -10.290  1.00 23.45           C  
ATOM    867  CE  LYS   103      38.950  19.375  -9.614  1.00 23.50           C  
ATOM    868  NZ  LYS   103      40.298  18.991 -10.102  1.00 25.68           N  
ATOM    869  N   ALA   104      36.531  24.809 -12.356  1.00 22.14           N  
ATOM    870  CA  ALA   104      35.691  25.672 -13.175  1.00 23.68           C  
ATOM    871  C   ALA   104      34.233  25.281 -13.011  1.00 24.89           C  
ATOM    872  O   ALA   104      33.888  24.084 -12.896  1.00 23.99           O  
ATOM    873  CB  ALA   104      36.097  25.574 -14.678  1.00 24.14           C  
ATOM    874  N   LEU   105      33.380  26.298 -12.996  1.00 27.07           N  
ATOM    875  CA  LEU   105      31.931  26.103 -13.087  1.00 28.87           C  
ATOM    876  C   LEU   105      31.530  25.061 -14.143  1.00 29.02           C  
ATOM    877  O   LEU   105      30.664  24.232 -13.898  1.00 29.23           O  
ATOM    878  CB  LEU   105      31.257  27.442 -13.362  1.00 29.23           C  
ATOM    879  CG  LEU   105      29.755  27.479 -13.668  1.00 31.02           C  
ATOM    880  CD1 LEU   105      28.907  27.141 -12.425  1.00 32.77           C  
ATOM    881  CD2 LEU   105      29.399  28.852 -14.209  1.00 30.51           C  
ATOM    882  N   SER   106      32.178  25.086 -15.307  1.00 29.91           N  
ATOM    883  CA  SER   106      31.881  24.149 -16.387  1.00 29.14           C  
ATOM    884  C   SER   106      32.051  22.681 -15.998  1.00 29.11           C  
ATOM    885  O   SER   106      31.355  21.822 -16.527  1.00 29.44           O  
ATOM    886  CB  SER   106      32.728  24.472 -17.622  1.00 29.72           C  
ATOM    887  OG  SER   106      34.098  24.225 -17.361  1.00 30.00           O  
ATOM    888  N   GLU   107      32.982  22.398 -15.080  1.00 27.75           N  
ATOM    889  CA  GLU   107      33.183  21.041 -14.562  1.00 27.48           C  
ATOM    890  C   GLU   107      32.013  20.561 -13.714  1.00 26.29           C  
ATOM    891  O   GLU   107      31.682  19.367 -13.708  1.00 25.83           O  
ATOM    892  CB  GLU   107      34.431  20.982 -13.697  1.00 27.28           C  
ATOM    893  CG  GLU   107      35.726  20.925 -14.471  1.00 31.09           C  
ATOM    894  CD  GLU   107      36.761  20.054 -13.765  1.00 34.47           C  
ATOM    895  OE1 GLU   107      36.413  18.951 -13.265  1.00 39.28           O  
ATOM    896  OE2 GLU   107      37.930  20.465 -13.731  1.00 36.57           O  
ATOM    897  N   LEU   108      31.437  21.482 -12.953  1.00 24.91           N  
ATOM    898  CA  LEU   108      30.246  21.168 -12.154  1.00 24.54           C  
ATOM    899  C   LEU   108      29.064  20.903 -13.085  1.00 24.38           C  
ATOM    900  O   LEU   108      28.318  19.949 -12.900  1.00 23.94           O  
ATOM    901  CB  LEU   108      29.924  22.317 -11.200  1.00 23.85           C  
ATOM    902  CG  LEU   108      28.633  22.283 -10.366  1.00 24.31           C  
ATOM    903  CD1 LEU   108      28.572  21.058  -9.475  1.00 24.85           C  
ATOM    904  CD2 LEU   108      28.493  23.548  -9.560  1.00 25.05           C  
ATOM    905  N   ARG   109      28.905  21.759 -14.093  1.00 24.69           N  
ATOM    906  CA  ARG   109      27.797  21.593 -15.046  1.00 25.81           C  
ATOM    907  C   ARG   109      27.927  20.267 -15.799  1.00 25.60           C  
ATOM    908  O   ARG   109      26.936  19.578 -16.013  1.00 25.88           O  
ATOM    909  CB  ARG   109      27.722  22.778 -16.012  1.00 26.38           C  
ATOM    910  CG  ARG   109      27.505  24.090 -15.295  1.00 29.70           C  
ATOM    911  CD  ARG   109      26.671  25.027 -16.096  1.00 37.60           C  
ATOM    912  NE  ARG   109      26.665  26.367 -15.512  1.00 43.01           N  
ATOM    913  CZ  ARG   109      26.248  27.449 -16.166  1.00 45.11           C  
ATOM    914  NH1 ARG   109      25.796  27.329 -17.408  1.00 47.16           N  
ATOM    915  NH2 ARG   109      26.277  28.645 -15.585  1.00 47.45           N  
ATOM    916  N   ALA   110      29.155  19.917 -16.190  1.00 25.45           N  
ATOM    917  CA  ALA   110      29.412  18.652 -16.891  1.00 25.48           C  
ATOM    918  C   ALA   110      29.078  17.447 -16.012  1.00 25.62           C  
ATOM    919  O   ALA   110      28.485  16.465 -16.476  1.00 25.86           O  
ATOM    920  CB  ALA   110      30.848  18.593 -17.374  1.00 25.39           C  
ATOM    921  N   MET   111      29.438  17.540 -14.729  1.00 24.85           N  
ATOM    922  CA  MET   111      29.117  16.514 -13.757  0.50 23.26           C  
ATOM    924  C   MET   111      27.592  16.359 -13.584  1.00 24.91           C  
ATOM    925  O   MET   111      27.085  15.230 -13.477  1.00 24.74           O  
ATOM    926  CB  MET   111      29.815  16.828 -12.422  0.50 23.59           C  
ATOM    928  CG  MET   111      30.092  15.611 -11.579  0.50 20.75           C  
ATOM    930  SD  MET   111      30.883  16.032  -9.843  0.50 18.95          SE  
ATOM    932  CE  MET   111      32.747  15.837 -10.220  0.50 15.17           C  
ATOM    934  N   ALA   112      26.884  17.494 -13.540  1.00 25.44           N  
ATOM    935  CA  ALA   112      25.427  17.512 -13.439  1.00 26.76           C  
ATOM    936  C   ALA   112      24.818  16.790 -14.647  1.00 27.56           C  
ATOM    937  O   ALA   112      24.077  15.821 -14.486  1.00 27.10           O  
ATOM    938  CB  ALA   112      24.911  18.932 -13.376  1.00 26.49           C  
ATOM    939  N   LYS   113      25.139  17.300 -15.834  1.00 29.94           N  
ATOM    940  CA  LYS   113      24.723  16.725 -17.128  1.00 31.32           C  
ATOM    941  C   LYS   113      24.909  15.206 -17.140  1.00 31.81           C  
ATOM    942  O   LYS   113      23.985  14.460 -17.480  1.00 32.12           O  
ATOM    943  CB  LYS   113      25.496  17.434 -18.269  1.00 32.12           C  
ATOM    944  CG  LYS   113      25.539  16.786 -19.681  1.00 32.56           C  
ATOM    945  CD  LYS   113      24.177  16.663 -20.371  1.00 37.78           C  
ATOM    946  CE  LYS   113      24.235  15.605 -21.499  1.00 38.53           C  
ATOM    947  NZ  LYS   113      22.973  14.790 -21.585  1.00 41.24           N  
ATOM    948  N   ALA   114      26.094  14.753 -16.737  1.00 32.76           N  
ATOM    949  CA  ALA   114      26.410  13.322 -16.690  1.00 33.68           C  
ATOM    950  C   ALA   114      25.518  12.546 -15.725  1.00 34.47           C  
ATOM    951  O   ALA   114      25.190  11.380 -15.980  1.00 34.78           O  
ATOM    952  CB  ALA   114      27.859  13.111 -16.338  1.00 33.77           C  
ATOM    953  N   ALA   115      25.130  13.181 -14.617  1.00 34.82           N  
ATOM    954  CA  ALA   115      24.253  12.533 -13.633  1.00 35.21           C  
ATOM    955  C   ALA   115      22.772  12.575 -14.030  1.00 35.51           C  
ATOM    956  O   ALA   115      21.914  12.092 -13.291  1.00 35.77           O  
ATOM    957  CB  ALA   115      24.458  13.149 -12.245  1.00 35.54           C  
ATOM    958  N   ARG   116      22.485  13.151 -15.197  1.00 35.81           N  
ATOM    959  CA  ARG   116      21.116  13.413 -15.664  1.00 36.57           C  
ATOM    960  C   ARG   116      20.358  14.336 -14.703  1.00 35.96           C  
ATOM    961  O   ARG   116      19.173  14.146 -14.421  1.00 35.58           O  
ATOM    962  CB  ARG   116      20.351  12.109 -15.954  1.00 36.76           C  
ATOM    963  CG  ARG   116      20.943  11.282 -17.109  1.00 38.35           C  
ATOM    964  CD  ARG   116      19.941  10.231 -17.616  1.00 39.16           C  
ATOM    965  NE  ARG   116      18.865  10.833 -18.415  1.00 45.58           N  
ATOM    966  CZ  ARG   116      18.722  10.692 -19.735  1.00 47.21           C  
ATOM    967  NH1 ARG   116      17.713  11.292 -20.360  1.00 48.53           N  
ATOM    968  NH2 ARG   116      19.577   9.950 -20.436  1.00 47.82           N  
ATOM    969  N   GLU   117      21.074  15.339 -14.198  1.00 35.11           N  
ATOM    970  CA  GLU   117      20.493  16.359 -13.344  1.00 34.78           C  
ATOM    971  C   GLU   117      20.925  17.749 -13.819  1.00 33.72           C  
ATOM    972  O   GLU   117      21.735  17.874 -14.752  1.00 33.94           O  
ATOM    973  CB  GLU   117      20.900  16.117 -11.888  1.00 34.37           C  
ATOM    974  CG  GLU   117      20.427  14.774 -11.341  1.00 35.31           C  
ATOM    975  CD  GLU   117      20.919  14.515  -9.929  1.00 36.02           C  
ATOM    976  OE1 GLU   117      21.039  15.488  -9.157  1.00 35.32           O  
ATOM    977  OE2 GLU   117      21.184  13.339  -9.586  1.00 39.92           O  
ATOM    978  N   GLU   118      20.361  18.785 -13.204  1.00 32.71           N  
ATOM    979  CA  GLU   118      20.663  20.176 -13.569  1.00 32.59           C  
ATOM    980  C   GLU   118      21.165  20.955 -12.355  1.00 30.03           C  
ATOM    981  O   GLU   118      20.750  20.663 -11.221  1.00 28.44           O  
ATOM    982  CB  GLU   118      19.410  20.892 -14.056  1.00 32.85           C  
ATOM    983  CG  GLU   118      18.594  20.155 -15.100  1.00 35.90           C  
ATOM    984  CD  GLU   118      17.471  21.020 -15.648  1.00 36.89           C  
ATOM    985  OE1 GLU   118      16.623  21.507 -14.845  1.00 42.48           O  
ATOM    986  OE2 GLU   118      17.447  21.218 -16.887  1.00 42.19           O  
ATOM    987  N   CYS   119      22.027  21.946 -12.614  1.00 28.23           N  
ATOM    988  CA  CYS   119      22.452  22.914 -11.593  1.00 26.98           C  
ATOM    989  C   CYS   119      21.342  23.946 -11.462  1.00 25.57           C  
ATOM    990  O   CYS   119      20.665  24.224 -12.462  1.00 25.73           O  
ATOM    991  CB  CYS   119      23.757  23.606 -12.002  1.00 27.45           C  
ATOM    992  SG  CYS   119      25.141  22.472 -12.121  1.00 29.53           S  
ATOM    993  N   PRO   120      21.139  24.523 -10.258  1.00 23.62           N  
ATOM    994  CA  PRO   120      21.849  24.302  -8.974  1.00 21.20           C  
ATOM    995  C   PRO   120      21.369  23.125  -8.124  1.00 20.06           C  
ATOM    996  O   PRO   120      21.936  22.885  -7.060  1.00 17.82           O  
ATOM    997  CB  PRO   120      21.537  25.580  -8.198  1.00 22.04           C  
ATOM    998  CG  PRO   120      20.144  25.948  -8.652  1.00 22.84           C  
ATOM    999  CD  PRO   120      20.095  25.560 -10.125  1.00 23.21           C  
ATOM   1000  N   VAL   121      20.349  22.390  -8.562  1.00 18.45           N  
ATOM   1001  CA  VAL   121      19.870  21.259  -7.749  1.00 17.90           C  
ATOM   1002  C   VAL   121      20.963  20.198  -7.540  1.00 16.37           C  
ATOM   1003  O   VAL   121      21.146  19.687  -6.433  1.00 16.62           O  
ATOM   1004  CB  VAL   121      18.557  20.661  -8.340  1.00 18.55           C  
ATOM   1005  CG1 VAL   121      18.271  19.271  -7.769  1.00 19.26           C  
ATOM   1006  CG2 VAL   121      17.409  21.618  -8.031  1.00 18.36           C  
ATOM   1007  N   PHE   122      21.673  19.872  -8.610  1.00 16.51           N  
ATOM   1008  CA  PHE   122      22.654  18.799  -8.556  1.00 16.39           C  
ATOM   1009  C   PHE   122      23.668  19.052  -7.432  1.00 16.35           C  
ATOM   1010  O   PHE   122      24.175  20.152  -7.316  1.00 15.68           O  
ATOM   1011  CB  PHE   122      23.375  18.677  -9.889  1.00 17.53           C  
ATOM   1012  CG  PHE   122      24.571  17.769  -9.834  1.00 18.38           C  
ATOM   1013  CD1 PHE   122      24.405  16.393  -9.692  1.00 18.85           C  
ATOM   1014  CD2 PHE   122      25.873  18.316  -9.857  1.00 19.32           C  
ATOM   1015  CE1 PHE   122      25.520  15.545  -9.598  1.00 21.40           C  
ATOM   1016  CE2 PHE   122      26.990  17.492  -9.795  1.00 19.08           C  
ATOM   1017  CZ  PHE   122      26.818  16.100  -9.644  1.00 20.67           C  
ATOM   1018  N   THR   123      23.937  18.023  -6.636  1.00 14.58           N  
ATOM   1019  CA  THR   123      24.913  18.081  -5.558  1.00 13.79           C  
ATOM   1020  C   THR   123      26.057  17.091  -5.784  1.00 13.81           C  
ATOM   1021  O   THR   123      25.815  15.882  -5.743  1.00 14.03           O  
ATOM   1022  CB  THR   123      24.210  17.757  -4.229  1.00 13.79           C  
ATOM   1023  OG1 THR   123      23.150  18.714  -4.043  1.00 13.23           O  
ATOM   1024  CG2 THR   123      25.165  17.834  -3.075  1.00 13.37           C  
ATOM   1025  N   PRO   124      27.298  17.598  -5.974  1.00 13.35           N  
ATOM   1026  CA  PRO   124      28.459  16.717  -6.210  1.00 12.91           C  
ATOM   1027  C   PRO   124      28.835  15.980  -4.923  1.00 13.01           C  
ATOM   1028  O   PRO   124      28.407  16.405  -3.816  1.00 12.54           O  
ATOM   1029  CB  PRO   124      29.580  17.679  -6.617  1.00 14.14           C  
ATOM   1030  CG  PRO   124      29.146  19.047  -6.128  1.00 13.45           C  
ATOM   1031  CD  PRO   124      27.650  19.032  -5.972  1.00 12.87           C  
ATOM   1032  N   PRO   125      29.655  14.912  -5.037  1.00 13.44           N  
ATOM   1033  CA  PRO   125      30.187  14.273  -3.846  1.00 13.53           C  
ATOM   1034  C   PRO   125      30.823  15.290  -2.880  1.00 13.16           C  
ATOM   1035  O   PRO   125      31.621  16.109  -3.298  1.00 12.44           O  
ATOM   1036  CB  PRO   125      31.230  13.295  -4.423  1.00 14.24           C  
ATOM   1037  CG  PRO   125      30.673  12.977  -5.804  1.00 15.16           C  
ATOM   1038  CD  PRO   125      30.160  14.294  -6.276  1.00 14.35           C  
ATOM   1039  N   GLY   126      30.452  15.221  -1.600  1.00 13.37           N  
ATOM   1040  CA  GLY   126      30.991  16.124  -0.568  1.00 12.38           C  
ATOM   1041  C   GLY   126      30.260  17.469  -0.494  1.00 12.55           C  
ATOM   1042  O   GLY   126      30.558  18.265   0.386  1.00 14.16           O  
ATOM   1043  N   GLY   127      29.307  17.701  -1.375  1.00 12.12           N  
ATOM   1044  CA  GLY   127      28.544  18.974  -1.397  1.00 11.03           C  
ATOM   1045  C   GLY   127      27.258  18.895  -0.603  1.00 12.16           C  
ATOM   1046  O   GLY   127      26.846  17.783  -0.121  1.00 11.11           O  
ATOM   1047  N   GLU   128      26.644  20.072  -0.380  1.00 11.01           N  
ATOM   1048  CA  GLU   128      25.330  20.188   0.289  1.00 11.89           C  
ATOM   1049  C   GLU   128      24.229  20.326  -0.747  1.00 11.34           C  
ATOM   1050  O   GLU   128      24.424  20.983  -1.790  1.00 12.25           O  
ATOM   1051  CB  GLU   128      25.265  21.460   1.176  1.00 11.43           C  
ATOM   1052  CG  GLU   128      26.020  21.334   2.516  1.00 11.16           C  
ATOM   1053  CD  GLU   128      26.067  22.656   3.250  1.00 14.31           C  
ATOM   1054  OE1 GLU   128      26.553  23.629   2.649  1.00 12.14           O  
ATOM   1055  OE2 GLU   128      25.672  22.695   4.437  1.00 17.34           O  
ATOM   1056  N   THR   129      23.055  19.755  -0.451  1.00 11.74           N  
ATOM   1057  CA  THR   129      21.827  19.964  -1.236  1.00 11.64           C  
ATOM   1058  C   THR   129      21.280  21.373  -0.977  1.00 11.58           C  
ATOM   1059  O   THR   129      21.643  21.995   0.050  1.00 10.25           O  
ATOM   1060  CB  THR   129      20.719  18.950  -0.876  1.00 12.61           C  
ATOM   1061  OG1 THR   129      20.353  19.146   0.536  1.00 14.75           O  
ATOM   1062  CG2 THR   129      21.286  17.516  -0.977  1.00 15.54           C  
ATOM   1063  N   LEU   130      20.437  21.862  -1.904  1.00 11.52           N  
ATOM   1064  CA  LEU   130      19.738  23.143  -1.676  1.00 12.31           C  
ATOM   1065  C   LEU   130      18.949  23.100  -0.380  1.00 12.77           C  
ATOM   1066  O   LEU   130      18.929  24.072   0.332  1.00 10.77           O  
ATOM   1067  CB  LEU   130      18.831  23.525  -2.852  1.00 13.53           C  
ATOM   1068  CG  LEU   130      19.595  23.847  -4.142  1.00 14.68           C  
ATOM   1069  CD1 LEU   130      18.645  24.060  -5.326  1.00 17.49           C  
ATOM   1070  CD2 LEU   130      20.532  25.046  -3.947  1.00 18.17           C  
ATOM   1071  N   ASP   131      18.345  21.964  -0.042  1.00 12.80           N  
ATOM   1072  CA  ASP   131      17.546  21.916   1.175  1.00 13.89           C  
ATOM   1073  C   ASP   131      18.433  21.950   2.421  1.00 13.08           C  
ATOM   1074  O   ASP   131      18.056  22.543   3.433  1.00 12.35           O  
ATOM   1075  CB  ASP   131      16.610  20.690   1.175  1.00 15.29           C  
ATOM   1076  CG  ASP   131      15.323  20.920   0.350  1.00 19.19           C  
ATOM   1077  OD1 ASP   131      14.896  22.070   0.066  1.00 24.81           O  
ATOM   1078  OD2 ASP   131      14.735  19.904  -0.020  1.00 27.72           O  
ATOM   1079  N   GLN   132      19.621  21.349   2.346  1.00 12.26           N  
ATOM   1080  CA  GLN   132      20.561  21.450   3.443  1.00 11.76           C  
ATOM   1081  C   GLN   132      21.019  22.912   3.650  1.00 11.28           C  
ATOM   1082  O   GLN   132      21.130  23.390   4.812  1.00  9.47           O  
ATOM   1083  CB  GLN   132      21.777  20.566   3.167  1.00 12.20           C  
ATOM   1084  CG  GLN   132      21.508  19.091   3.488  1.00 15.13           C  
ATOM   1085  CD  GLN   132      22.679  18.210   3.078  1.00 18.85           C  
ATOM   1086  OE1 GLN   132      23.201  18.338   1.971  1.00 16.27           O  
ATOM   1087  NE2 GLN   132      23.110  17.325   3.991  1.00 23.69           N  
ATOM   1088  N   VAL   133      21.279  23.616   2.550  1.00  9.48           N  
ATOM   1089  CA  VAL   133      21.651  25.041   2.659  1.00  9.49           C  
ATOM   1090  C   VAL   133      20.518  25.854   3.282  1.00  9.92           C  
ATOM   1091  O   VAL   133      20.744  26.611   4.228  1.00  9.67           O  
ATOM   1092  CB  VAL   133      22.038  25.636   1.275  1.00 10.42           C  
ATOM   1093  CG1 VAL   133      22.439  27.068   1.402  1.00 10.99           C  
ATOM   1094  CG2 VAL   133      23.237  24.856   0.663  1.00  9.59           C  
ATOM   1095  N   LYS   134      19.309  25.698   2.754  1.00 10.05           N  
ATOM   1096  CA  LYS   134      18.129  26.384   3.308  1.00 10.95           C  
ATOM   1097  C   LYS   134      17.980  26.086   4.795  1.00 11.05           C  
ATOM   1098  O   LYS   134      17.592  26.959   5.566  1.00  9.92           O  
ATOM   1099  CB  LYS   134      16.856  25.966   2.585  1.00 10.96           C  
ATOM   1100  CG  LYS   134      15.648  26.772   3.054  1.00 13.28           C  
ATOM   1101  CD  LYS   134      14.331  26.418   2.340  1.00 15.14           C  
ATOM   1102  CE  LYS   134      14.135  27.178   1.071  1.00 19.20           C  
ATOM   1103  NZ  LYS   134      12.763  26.837   0.546  1.00 22.40           N  
ATOM   1104  N   MET   135      18.239  24.845   5.204  1.00  9.06           N  
ATOM   1105  CA  MET   135      18.044  24.514   6.621  1.00 11.12           C  
ATOM   1106  C   MET   135      19.006  25.323   7.494  1.00 10.30           C  
ATOM   1107  O   MET   135      18.621  25.789   8.531  1.00 10.53           O  
ATOM   1108  CB  MET   135      18.138  22.983   6.830  1.00 11.96           C  
ATOM   1109  CG  MET   135      17.896  22.479   8.257  1.00 13.35           C  
ATOM   1110  SD  MET   135      16.066  22.913   8.811  1.00 15.75          SE  
ATOM   1111  CE  MET   135      16.394  24.116  10.229  1.00 19.57           C  
ATOM   1112  N   ARG   136      20.245  25.528   7.042  1.00  9.96           N  
ATOM   1113  CA  ARG   136      21.207  26.423   7.733  1.00  9.44           C  
ATOM   1114  C   ARG   136      20.721  27.874   7.792  1.00 10.34           C  
ATOM   1115  O   ARG   136      20.948  28.566   8.776  1.00 11.05           O  
ATOM   1116  CB  ARG   136      22.596  26.348   7.102  1.00  8.92           C  
ATOM   1117  CG  ARG   136      23.220  24.964   7.297  1.00 10.88           C  
ATOM   1118  CD  ARG   136      24.692  25.051   7.080  1.00 10.58           C  
ATOM   1119  NE  ARG   136      25.105  25.173   5.661  1.00  9.48           N  
ATOM   1120  CZ  ARG   136      25.618  26.262   5.081  1.00 10.08           C  
ATOM   1121  NH1 ARG   136      25.626  27.455   5.692  1.00  9.95           N  
ATOM   1122  NH2 ARG   136      26.066  26.169   3.812  1.00  9.85           N  
ATOM   1123  N   GLY   137      19.974  28.275   6.763  1.00  9.12           N  
ATOM   1124  CA  GLY   137      19.362  29.616   6.694  1.00 10.59           C  
ATOM   1125  C   GLY   137      18.235  29.727   7.721  1.00 10.98           C  
ATOM   1126  O   GLY   137      18.143  30.735   8.466  1.00 10.49           O  
ATOM   1127  N   ILE   138      17.365  28.706   7.739  1.00 10.10           N  
ATOM   1128  CA  ILE   138      16.271  28.625   8.740  1.00  9.94           C  
ATOM   1129  C   ILE   138      16.838  28.634  10.204  1.00 10.47           C  
ATOM   1130  O   ILE   138      16.357  29.367  11.071  1.00 10.30           O  
ATOM   1131  CB  ILE   138      15.379  27.383   8.485  1.00  9.63           C  
ATOM   1132  CG1 ILE   138      14.688  27.518   7.103  1.00  9.46           C  
ATOM   1133  CG2 ILE   138      14.331  27.262   9.586  1.00 12.67           C  
ATOM   1134  CD1 ILE   138      13.942  26.227   6.728  1.00 10.38           C  
ATOM   1135  N   ASP   139      17.871  27.827  10.446  1.00 10.75           N  
ATOM   1136  CA  ASP   139      18.523  27.719  11.751  1.00 12.25           C  
ATOM   1137  C   ASP   139      19.051  29.087  12.177  1.00 11.78           C  
ATOM   1138  O   ASP   139      18.744  29.575  13.280  1.00 12.04           O  
ATOM   1139  CB  ASP   139      19.665  26.694  11.614  1.00 12.31           C  
ATOM   1140  CG  ASP   139      20.421  26.416  12.931  1.00 17.51           C  
ATOM   1141  OD1 ASP   139      20.224  27.111  13.931  1.00 23.55           O  
ATOM   1142  OD2 ASP   139      21.267  25.482  12.918  1.00 23.53           O  
ATOM   1143  N   PHE   140      19.828  29.719  11.300  1.00 10.99           N  
ATOM   1144  CA  PHE   140      20.375  31.032  11.623  1.00 11.07           C  
ATOM   1145  C   PHE   140      19.255  32.044  11.868  1.00 10.71           C  
ATOM   1146  O   PHE   140      19.280  32.819  12.844  1.00 11.15           O  
ATOM   1147  CB  PHE   140      21.308  31.564  10.533  1.00 10.66           C  
ATOM   1148  CG  PHE   140      21.842  32.928  10.882  1.00 11.12           C  
ATOM   1149  CD1 PHE   140      22.879  33.030  11.802  1.00 13.72           C  
ATOM   1150  CD2 PHE   140      21.241  34.092  10.383  1.00 11.20           C  
ATOM   1151  CE1 PHE   140      23.358  34.277  12.190  1.00 13.44           C  
ATOM   1152  CE2 PHE   140      21.724  35.384  10.768  1.00 11.43           C  
ATOM   1153  CZ  PHE   140      22.778  35.452  11.680  1.00 13.56           C  
ATOM   1154  N   PHE   141      18.275  32.061  10.961  1.00  9.26           N  
ATOM   1155  CA  PHE   141      17.192  33.042  11.078  1.00  9.67           C  
ATOM   1156  C   PHE   141      16.396  32.886  12.391  1.00  9.64           C  
ATOM   1157  O   PHE   141      16.073  33.884  13.054  1.00 10.41           O  
ATOM   1158  CB  PHE   141      16.224  32.908   9.897  1.00  9.66           C  
ATOM   1159  CG  PHE   141      15.129  33.941   9.915  1.00 10.69           C  
ATOM   1160  CD1 PHE   141      15.453  35.288   9.712  1.00 11.03           C  
ATOM   1161  CD2 PHE   141      13.787  33.576  10.129  1.00 13.04           C  
ATOM   1162  CE1 PHE   141      14.439  36.279   9.718  1.00 13.41           C  
ATOM   1163  CE2 PHE   141      12.752  34.558  10.131  1.00 12.72           C  
ATOM   1164  CZ  PHE   141      13.090  35.911   9.934  1.00 12.61           C  
ATOM   1165  N   GLU   142      16.056  31.654  12.739  1.00 10.90           N  
ATOM   1166  CA  GLU   142      15.343  31.419  14.018  1.00 12.50           C  
ATOM   1167  C   GLU   142      16.180  31.860  15.208  1.00 12.76           C  
ATOM   1168  O   GLU   142      15.645  32.512  16.144  1.00 12.86           O  
ATOM   1169  CB  GLU   142      14.956  29.948  14.133  1.00 14.29           C  
ATOM   1170  CG  GLU   142      13.950  29.649  13.002  1.00 18.51           C  
ATOM   1171  CD  GLU   142      13.206  28.339  13.106  1.00 26.10           C  
ATOM   1172  OE1 GLU   142      12.074  28.285  12.548  1.00 26.39           O  
ATOM   1173  OE2 GLU   142      13.733  27.380  13.716  1.00 30.36           O  
ATOM   1174  N   PHE   143      17.468  31.490  15.178  1.00 11.64           N  
ATOM   1175  CA  PHE   143      18.452  31.988  16.154  1.00 12.86           C  
ATOM   1176  C   PHE   143      18.407  33.541  16.285  1.00 13.14           C  
ATOM   1177  O   PHE   143      18.296  34.089  17.402  1.00 12.88           O  
ATOM   1178  CB  PHE   143      19.855  31.490  15.793  1.00 14.14           C  
ATOM   1179  CG  PHE   143      20.971  32.331  16.383  1.00 16.21           C  
ATOM   1180  CD1 PHE   143      21.327  32.196  17.723  1.00 19.07           C  
ATOM   1181  CD2 PHE   143      21.602  33.302  15.624  1.00 15.91           C  
ATOM   1182  CE1 PHE   143      22.348  32.991  18.271  1.00 20.54           C  
ATOM   1183  CE2 PHE   143      22.596  34.111  16.160  1.00 20.18           C  
ATOM   1184  CZ  PHE   143      22.977  33.955  17.484  1.00 17.61           C  
ATOM   1185  N   LEU   144      18.513  34.228  15.153  1.00 11.11           N  
ATOM   1186  CA  LEU   144      18.529  35.689  15.110  1.00 11.52           C  
ATOM   1187  C   LEU   144      17.234  36.287  15.704  1.00 11.63           C  
ATOM   1188  O   LEU   144      17.280  37.194  16.562  1.00 12.63           O  
ATOM   1189  CB  LEU   144      18.725  36.173  13.658  1.00 10.82           C  
ATOM   1190  CG  LEU   144      18.846  37.697  13.477  1.00 11.37           C  
ATOM   1191  CD1 LEU   144      20.007  38.293  14.264  1.00 14.98           C  
ATOM   1192  CD2 LEU   144      18.998  38.069  11.981  1.00 12.34           C  
ATOM   1193  N   CYS   145      16.089  35.738  15.280  1.00 11.54           N  
ATOM   1194  CA  CYS   145      14.771  36.188  15.771  1.00 12.26           C  
ATOM   1195  C   CYS   145      14.670  36.081  17.292  1.00 13.44           C  
ATOM   1196  O   CYS   145      14.323  37.070  17.943  1.00 13.67           O  
ATOM   1197  CB  CYS   145      13.644  35.406  15.096  1.00 12.21           C  
ATOM   1198  SG  CYS   145      13.463  35.951  13.328  1.00 14.79           S  
ATOM   1199  N   GLN   146      15.007  34.920  17.837  1.00 13.71           N  
ATOM   1200  CA  GLN   146      15.004  34.707  19.294  1.00 15.59           C  
ATOM   1201  C   GLN   146      15.946  35.663  20.006  1.00 15.93           C  
ATOM   1202  O   GLN   146      15.580  36.240  21.051  1.00 15.40           O  
ATOM   1203  CB  GLN   146      15.332  33.252  19.635  1.00 16.45           C  
ATOM   1204  CG  GLN   146      14.186  32.288  19.241  1.00 22.14           C  
ATOM   1205  CD  GLN   146      12.874  32.640  19.971  1.00 29.71           C  
ATOM   1206  OE1 GLN   146      12.777  32.509  21.201  1.00 32.44           O  
ATOM   1207  NE2 GLN   146      11.882  33.131  19.216  1.00 32.00           N  
ATOM   1208  N   LEU   147      17.138  35.859  19.428  1.00 15.37           N  
ATOM   1209  CA  LEU   147      18.154  36.782  19.976  1.00 15.16           C  
ATOM   1210  C   LEU   147      17.588  38.202  20.161  1.00 15.14           C  
ATOM   1211  O   LEU   147      17.635  38.785  21.258  1.00 15.30           O  
ATOM   1212  CB  LEU   147      19.390  36.799  19.053  1.00 14.58           C  
ATOM   1213  CG  LEU   147      20.477  37.750  19.578  1.00 18.48           C  
ATOM   1214  CD1 LEU   147      21.277  37.026  20.669  1.00 24.94           C  
ATOM   1215  CD2 LEU   147      21.391  38.217  18.509  1.00 21.05           C  
ATOM   1216  N   ILE   148      17.013  38.730  19.088  1.00 13.47           N  
ATOM   1217  CA  ILE   148      16.472  40.085  19.047  1.00 13.77           C  
ATOM   1218  C   ILE   148      15.277  40.239  19.987  1.00 13.26           C  
ATOM   1219  O   ILE   148      15.188  41.254  20.716  1.00 13.49           O  
ATOM   1220  CB  ILE   148      16.083  40.484  17.599  1.00 13.22           C  
ATOM   1221  CG1 ILE   148      17.315  40.531  16.688  1.00 12.36           C  
ATOM   1222  CG2 ILE   148      15.325  41.837  17.556  1.00 15.01           C  
ATOM   1223  CD1 ILE   148      18.530  41.337  17.225  1.00 14.76           C  
ATOM   1224  N   LEU   149      14.378  39.253  19.981  1.00 13.33           N  
ATOM   1225  CA  LEU   149      13.166  39.304  20.851  1.00 12.70           C  
ATOM   1226  C   LEU   149      13.587  39.302  22.328  1.00 13.92           C  
ATOM   1227  O   LEU   149      13.110  40.134  23.119  1.00 13.08           O  
ATOM   1228  CB  LEU   149      12.228  38.132  20.556  1.00 13.22           C  
ATOM   1229  CG  LEU   149      11.562  38.284  19.170  1.00 11.59           C  
ATOM   1230  CD1 LEU   149      10.787  36.997  18.820  1.00 14.38           C  
ATOM   1231  CD2 LEU   149      10.627  39.515  19.141  1.00 16.20           C  
ATOM   1232  N   LYS   150      14.521  38.415  22.660  1.00 13.32           N  
ATOM   1233  CA  LYS   150      15.031  38.306  24.051  1.00 15.01           C  
ATOM   1234  C   LYS   150      15.770  39.578  24.495  1.00 15.41           C  
ATOM   1235  O   LYS   150      15.614  40.042  25.647  1.00 15.91           O  
ATOM   1236  CB  LYS   150      15.924  37.077  24.192  1.00 15.61           C  
ATOM   1237  CG  LYS   150      15.172  35.781  24.225  1.00 18.33           C  
ATOM   1238  CD  LYS   150      16.140  34.636  24.225  1.00 22.37           C  
ATOM   1239  CE  LYS   150      15.405  33.333  24.046  1.00 29.21           C  
ATOM   1240  NZ  LYS   150      15.119  32.732  25.380  1.00 34.01           N  
ATOM   1241  N   GLU   151      16.566  40.159  23.600  1.00 16.59           N  
ATOM   1242  CA  GLU   151      17.236  41.421  23.903  1.00 18.62           C  
ATOM   1243  C   GLU   151      16.242  42.543  24.094  1.00 18.93           C  
ATOM   1244  O   GLU   151      16.381  43.320  25.036  1.00 19.86           O  
ATOM   1245  CB  GLU   151      18.279  41.783  22.826  1.00 18.64           C  
ATOM   1246  CG  GLU   151      19.491  40.830  22.871  1.00 20.23           C  
ATOM   1247  CD  GLU   151      20.613  41.209  21.915  1.00 21.22           C  
ATOM   1248  OE1 GLU   151      20.429  42.127  21.092  1.00 26.24           O  
ATOM   1249  OE2 GLU   151      21.676  40.557  21.971  1.00 24.90           O  
ATOM   1250  N   ALA   152      15.231  42.625  23.220  1.00 19.10           N  
ATOM   1251  CA  ALA   152      14.172  43.629  23.369  1.00 19.49           C  
ATOM   1252  C   ALA   152      13.473  43.445  24.730  1.00 19.77           C  
ATOM   1253  O   ALA   152      13.114  44.432  25.390  1.00 19.86           O  
ATOM   1254  CB  ALA   152      13.159  43.526  22.252  1.00 20.37           C  
ATOM   1255  N   ASP   153      13.259  42.188  25.112  1.00 19.41           N  
ATOM   1256  CA  ASP   153      12.605  41.850  26.380  1.00 21.62           C  
ATOM   1257  C   ASP   153      13.466  42.281  27.569  1.00 23.56           C  
ATOM   1258  O   ASP   153      12.959  42.809  28.560  1.00 23.49           O  
ATOM   1259  CB  ASP   153      12.369  40.338  26.494  1.00 20.56           C  
ATOM   1260  CG  ASP   153      11.495  39.982  27.680  1.00 19.09           C  
ATOM   1261  OD1 ASP   153      10.349  40.462  27.714  1.00 21.16           O  
ATOM   1262  OD2 ASP   153      11.962  39.243  28.563  1.00 19.70           O  
ATOM   1263  N   GLN   154      14.763  42.012  27.472  1.00 26.71           N  
ATOM   1264  CA  GLN   154      15.697  42.277  28.574  1.00 30.61           C  
ATOM   1265  C   GLN   154      16.002  43.776  28.747  1.00 32.44           C  
ATOM   1266  O   GLN   154      16.568  44.176  29.779  1.00 34.00           O  
ATOM   1267  CB  GLN   154      16.979  41.429  28.444  1.00 30.79           C  
ATOM   1268  CG  GLN   154      16.770  39.895  28.461  1.00 33.07           C  
ATOM   1269  CD  GLN   154      16.043  39.367  29.699  1.00 37.37           C  
ATOM   1270  OE1 GLN   154      16.550  39.443  30.823  1.00 39.46           O  
ATOM   1271  NE2 GLN   154      14.846  38.807  29.487  1.00 40.42           N  
ATOM   1272  N   LYS   155      15.587  44.612  27.785  1.00 34.64           N  
ATOM   1273  CA  LYS   155      15.755  46.085  27.881  1.00 36.26           C  
ATOM   1274  C   LYS   155      14.446  46.864  28.024  1.00 36.17           C  
ATOM   1275  O   LYS   155      13.360  46.298  28.201  1.00 37.58           O  
ATOM   1276  CB  LYS   155      16.523  46.682  26.678  1.00 36.32           C  
ATOM   1277  CG  LYS   155      17.355  45.733  25.836  1.00 39.40           C  
ATOM   1278  CD  LYS   155      18.806  45.627  26.267  1.00 40.09           C  
ATOM   1279  CE  LYS   155      19.565  44.727  25.301  1.00 43.03           C  
ATOM   1280  NZ  LYS   155      19.928  45.384  24.002  1.00 43.48           N  
ATOM   1281  N   ASN   165      12.474  55.446  15.912  1.00 41.07           N  
ATOM   1282  CA  ASN   165      12.786  56.233  14.721  1.00 40.86           C  
ATOM   1283  C   ASN   165      14.225  56.117  14.260  1.00 39.46           C  
ATOM   1284  O   ASN   165      14.474  55.926  13.065  1.00 39.76           O  
ATOM   1285  CB  ASN   165      12.495  57.726  14.953  1.00 41.56           C  
ATOM   1286  CG  ASN   165      11.019  58.026  15.088  1.00 43.79           C  
ATOM   1287  OD1 ASN   165      10.175  57.371  14.470  1.00 47.63           O  
ATOM   1288  ND2 ASN   165      10.696  59.042  15.885  1.00 46.17           N  
ATOM   1289  N   CYS   166      15.149  56.242  15.216  1.00 37.98           N  
ATOM   1290  CA  CYS   166      16.580  56.379  14.945  0.50 36.88           C  
ATOM   1292  C   CYS   166      17.170  55.327  13.986  1.00 36.05           C  
ATOM   1293  O   CYS   166      17.921  55.653  13.041  1.00 35.95           O  
ATOM   1294  CB  CYS   166      17.329  56.360  16.274  0.50 37.09           C  
ATOM   1296  SG  CYS   166      19.092  56.519  16.131  0.50 38.12           S  
ATOM   1298  N   LEU   167      16.844  54.063  14.232  1.00 33.59           N  
ATOM   1299  CA  LEU   167      17.349  52.984  13.376  1.00 30.89           C  
ATOM   1300  C   LEU   167      16.723  53.022  11.973  1.00 29.85           C  
ATOM   1301  O   LEU   167      17.438  52.862  10.974  1.00 28.15           O  
ATOM   1302  CB  LEU   167      17.144  51.623  14.043  1.00 29.90           C  
ATOM   1303  CG  LEU   167      17.722  51.341  15.434  1.00 29.69           C  
ATOM   1304  CD1 LEU   167      17.442  49.901  15.841  1.00 27.15           C  
ATOM   1305  CD2 LEU   167      19.210  51.625  15.503  1.00 27.72           C  
ATOM   1306  N   GLU   168      15.405  53.265  11.905  1.00 28.65           N  
ATOM   1307  CA  GLU   168      14.659  53.300  10.634  1.00 28.93           C  
ATOM   1308  C   GLU   168      15.057  54.494   9.758  1.00 27.44           C  
ATOM   1309  O   GLU   168      15.255  54.348   8.551  1.00 27.06           O  
ATOM   1310  CB  GLU   168      13.141  53.301  10.891  1.00 29.00           C  
ATOM   1311  CG  GLU   168      12.255  53.014   9.660  1.00 30.98           C  
ATOM   1312  CD  GLU   168      10.935  52.292  10.007  1.00 32.01           C  
ATOM   1313  OE1 GLU   168      10.464  52.369  11.172  1.00 35.69           O  
ATOM   1314  OE2 GLU   168      10.375  51.617   9.112  1.00 36.97           O  
ATOM   1315  N   THR   169      15.176  55.673  10.373  1.00 27.30           N  
ATOM   1316  CA  THR   169      15.520  56.891   9.635  1.00 27.25           C  
ATOM   1317  C   THR   169      16.842  56.760   8.882  1.00 26.37           C  
ATOM   1318  O   THR   169      16.923  57.137   7.709  1.00 26.91           O  
ATOM   1319  CB  THR   169      15.510  58.168  10.544  1.00 27.66           C  
ATOM   1320  OG1 THR   169      16.549  58.072  11.523  1.00 29.75           O  
ATOM   1321  CG2 THR   169      14.185  58.297  11.260  1.00 27.52           C  
ATOM   1322  N   SER   170      17.848  56.182   9.535  1.00 26.61           N  
ATOM   1323  CA  SER   170      19.174  56.002   8.917  1.00 26.93           C  
ATOM   1324  C   SER   170      19.123  55.010   7.750  1.00 26.69           C  
ATOM   1325  O   SER   170      19.792  55.208   6.740  1.00 27.67           O  
ATOM   1326  CB  SER   170      20.248  55.639   9.958  1.00 27.25           C  
ATOM   1327  OG  SER   170      20.071  54.353  10.510  1.00 28.32           O  
ATOM   1328  N   LEU   171      18.305  53.966   7.868  1.00 26.17           N  
ATOM   1329  CA  LEU   171      18.040  53.090   6.720  1.00 25.72           C  
ATOM   1330  C   LEU   171      17.287  53.802   5.580  1.00 26.04           C  
ATOM   1331  O   LEU   171      17.639  53.648   4.407  1.00 25.52           O  
ATOM   1332  CB  LEU   171      17.298  51.821   7.156  1.00 25.40           C  
ATOM   1333  CG  LEU   171      18.092  50.830   8.015  1.00 24.74           C  
ATOM   1334  CD1 LEU   171      17.136  49.817   8.632  1.00 23.70           C  
ATOM   1335  CD2 LEU   171      19.200  50.144   7.186  1.00 22.15           C  
ATOM   1336  N   ALA   172      16.256  54.588   5.927  1.00 26.86           N  
ATOM   1337  CA  ALA   172      15.388  55.251   4.933  1.00 27.07           C  
ATOM   1338  C   ALA   172      16.132  56.273   4.070  1.00 27.99           C  
ATOM   1339  O   ALA   172      15.687  56.601   2.959  1.00 28.28           O  
ATOM   1340  CB  ALA   172      14.173  55.917   5.628  1.00 26.59           C  
ATOM   1341  N   GLU   173      17.268  56.735   4.592  1.00 28.87           N  
ATOM   1342  CA  GLU   173      18.192  57.649   3.923  1.00 31.20           C  
ATOM   1343  C   GLU   173      18.737  57.100   2.610  1.00 30.70           C  
ATOM   1344  O   GLU   173      19.006  57.862   1.683  1.00 30.82           O  
ATOM   1345  CB  GLU   173      19.397  57.907   4.827  1.00 31.14           C  
ATOM   1346  CG  GLU   173      19.240  59.056   5.812  1.00 33.97           C  
ATOM   1347  CD  GLU   173      20.443  59.217   6.735  1.00 34.81           C  
ATOM   1348  OE1 GLU   173      21.599  58.949   6.305  1.00 37.15           O  
ATOM   1349  OE2 GLU   173      20.223  59.620   7.912  1.00 40.87           O  
ATOM   1350  N   ILE   174      18.937  55.779   2.550  1.00 29.59           N  
ATOM   1351  CA  ILE   174      19.664  55.177   1.444  1.00 28.75           C  
ATOM   1352  C   ILE   174      18.945  53.993   0.816  1.00 27.96           C  
ATOM   1353  O   ILE   174      19.270  53.604  -0.303  1.00 28.16           O  
ATOM   1354  CB  ILE   174      21.095  54.747   1.855  1.00 28.85           C  
ATOM   1355  CG1 ILE   174      21.047  53.714   2.996  1.00 28.35           C  
ATOM   1356  CG2 ILE   174      21.951  55.980   2.220  1.00 28.66           C  
ATOM   1357  CD1 ILE   174      22.382  53.050   3.268  1.00 28.84           C  
ATOM   1358  N   PHE   175      17.976  53.438   1.545  1.00 27.25           N  
ATOM   1359  CA  PHE   175      17.154  52.313   1.089  1.00 27.16           C  
ATOM   1360  C   PHE   175      15.712  52.748   0.844  1.00 27.96           C  
ATOM   1361  O   PHE   175      15.198  53.589   1.591  1.00 28.32           O  
ATOM   1362  CB  PHE   175      17.148  51.197   2.138  1.00 25.39           C  
ATOM   1363  CG  PHE   175      18.448  50.476   2.254  1.00 25.02           C  
ATOM   1364  CD1 PHE   175      19.000  49.831   1.144  1.00 22.62           C  
ATOM   1365  CD2 PHE   175      19.138  50.455   3.463  1.00 23.11           C  
ATOM   1366  CE1 PHE   175      20.233  49.168   1.253  1.00 22.60           C  
ATOM   1367  CE2 PHE   175      20.371  49.793   3.582  1.00 23.59           C  
ATOM   1368  CZ  PHE   175      20.907  49.145   2.472  1.00 22.09           C  
ATOM   1369  N   PRO   176      15.042  52.144  -0.159  1.00 28.92           N  
ATOM   1370  CA  PRO   176      13.659  52.519  -0.523  1.00 29.85           C  
ATOM   1371  C   PRO   176      12.546  52.111   0.472  1.00 30.23           C  
ATOM   1372  O   PRO   176      11.619  51.369   0.120  1.00 29.89           O  
ATOM   1373  CB  PRO   176      13.460  51.839  -1.879  1.00 29.67           C  
ATOM   1374  CG  PRO   176      14.364  50.658  -1.842  1.00 29.69           C  
ATOM   1375  CD  PRO   176      15.559  51.076  -1.037  1.00 29.70           C  
ATOM   1376  N   LEU   177      12.649  52.594   1.702  1.00 31.32           N  
ATOM   1377  CA  LEU   177      11.584  52.454   2.669  1.00 32.99           C  
ATOM   1378  C   LEU   177      10.558  53.566   2.434  1.00 34.01           C  
ATOM   1379  O   LEU   177       9.364  53.292   2.296  1.00 35.48           O  
ATOM   1380  CB  LEU   177      12.135  52.570   4.085  1.00 33.09           C  
ATOM   1381  CG  LEU   177      12.901  51.402   4.709  1.00 33.87           C  
ATOM   1382  CD1 LEU   177      13.626  51.910   5.929  1.00 35.29           C  
ATOM   1383  CD2 LEU   177      11.974  50.264   5.097  1.00 34.86           C  
ATOM   1384  N   ILE   191       3.939  49.630  13.570  1.00 39.51           N  
ATOM   1385  CA  ILE   191       3.880  50.674  14.609  1.00 39.47           C  
ATOM   1386  C   ILE   191       5.049  50.664  15.620  1.00 38.14           C  
ATOM   1387  O   ILE   191       5.580  51.740  15.924  1.00 37.87           O  
ATOM   1388  CB  ILE   191       2.462  50.789  15.328  1.00 39.29           C  
ATOM   1389  CG1 ILE   191       2.433  51.996  16.290  1.00 40.74           C  
ATOM   1390  CG2 ILE   191       2.038  49.463  16.001  1.00 40.80           C  
ATOM   1391  CD1 ILE   191       1.296  52.006  17.340  1.00 40.39           C  
ATOM   1392  N   PRO   192       5.482  49.463  16.109  1.00 37.22           N  
ATOM   1393  CA  PRO   192       6.645  49.479  17.014  1.00 35.79           C  
ATOM   1394  C   PRO   192       7.866  50.047  16.289  1.00 34.05           C  
ATOM   1395  O   PRO   192       8.092  49.699  15.126  1.00 34.00           O  
ATOM   1396  CB  PRO   192       6.894  47.986  17.313  1.00 35.96           C  
ATOM   1397  CG  PRO   192       5.638  47.306  17.007  1.00 36.88           C  
ATOM   1398  CD  PRO   192       5.026  48.079  15.861  1.00 37.57           C  
ATOM   1399  N   GLY   193       8.628  50.919  16.953  1.00 32.00           N  
ATOM   1400  CA  GLY   193       9.924  51.376  16.415  1.00 29.30           C  
ATOM   1401  C   GLY   193      10.830  50.158  16.267  1.00 26.86           C  
ATOM   1402  O   GLY   193      10.654  49.181  16.991  1.00 27.57           O  
ATOM   1403  N   LEU   194      11.785  50.196  15.335  1.00 25.02           N  
ATOM   1404  CA  LEU   194      12.666  49.029  15.119  1.00 22.05           C  
ATOM   1405  C   LEU   194      13.431  48.669  16.374  1.00 21.47           C  
ATOM   1406  O   LEU   194      14.097  49.519  16.968  1.00 20.52           O  
ATOM   1407  CB  LEU   194      13.667  49.268  13.981  1.00 22.03           C  
ATOM   1408  CG  LEU   194      13.115  49.448  12.567  1.00 21.92           C  
ATOM   1409  CD1 LEU   194      14.218  49.717  11.554  1.00 21.24           C  
ATOM   1410  CD2 LEU   194      12.268  48.216  12.181  1.00 19.60           C  
ATOM   1411  N   ALA   195      13.359  47.408  16.768  1.00 19.34           N  
ATOM   1412  CA  ALA   195      14.067  46.936  17.943  1.00 18.73           C  
ATOM   1413  C   ALA   195      15.570  46.801  17.690  1.00 18.18           C  
ATOM   1414  O   ALA   195      16.388  46.907  18.607  1.00 18.05           O  
ATOM   1415  CB  ALA   195      13.484  45.595  18.409  1.00 18.89           C  
ATOM   1416  N   ALA   196      15.917  46.565  16.437  1.00 16.89           N  
ATOM   1417  CA  ALA   196      17.301  46.288  16.039  1.00 15.01           C  
ATOM   1418  C   ALA   196      17.445  46.486  14.517  1.00 14.33           C  
ATOM   1419  O   ALA   196      16.454  46.568  13.795  1.00 13.96           O  
ATOM   1420  CB  ALA   196      17.727  44.886  16.457  1.00 15.92           C  
ATOM   1421  N   SER   197      18.707  46.610  14.069  1.00 13.64           N  
ATOM   1422  CA  SER   197      19.075  46.758  12.665  1.00 13.45           C  
ATOM   1423  C   SER   197      20.336  45.904  12.511  1.00 13.46           C  
ATOM   1424  O   SER   197      21.446  46.289  12.920  1.00 13.37           O  
ATOM   1425  CB  SER   197      19.358  48.221  12.305  1.00 13.58           C  
ATOM   1426  OG  SER   197      19.622  48.367  10.900  1.00 14.68           O  
ATOM   1427  N   VAL   198      20.138  44.726  11.921  1.00 13.15           N  
ATOM   1428  CA  VAL   198      21.175  43.684  11.893  1.00 13.08           C  
ATOM   1429  C   VAL   198      21.837  43.708  10.520  1.00 13.08           C  
ATOM   1430  O   VAL   198      21.150  43.812   9.488  1.00 13.79           O  
ATOM   1431  CB  VAL   198      20.539  42.297  12.111  1.00 12.94           C  
ATOM   1432  CG1 VAL   198      21.583  41.206  11.969  1.00 13.89           C  
ATOM   1433  CG2 VAL   198      19.785  42.182  13.457  1.00 12.57           C  
ATOM   1434  N   LEU   199      23.165  43.640  10.519  1.00 12.11           N  
ATOM   1435  CA  LEU   199      23.944  43.552   9.280  1.00 11.62           C  
ATOM   1436  C   LEU   199      24.484  42.142   9.161  1.00 11.23           C  
ATOM   1437  O   LEU   199      25.156  41.672  10.058  1.00 11.71           O  
ATOM   1438  CB  LEU   199      25.143  44.520   9.306  1.00 12.31           C  
ATOM   1439  CG  LEU   199      26.104  44.482   8.086  1.00 11.66           C  
ATOM   1440  CD1 LEU   199      25.454  44.717   6.697  1.00 13.39           C  
ATOM   1441  CD2 LEU   199      27.300  45.506   8.317  1.00 12.95           C  
ATOM   1442  N   VAL   200      24.258  41.507   8.006  1.00 10.78           N  
ATOM   1443  CA  VAL   200      24.776  40.120   7.811  1.00  8.76           C  
ATOM   1444  C   VAL   200      25.585  40.101   6.520  1.00  9.38           C  
ATOM   1445  O   VAL   200      25.108  40.550   5.475  1.00 10.10           O  
ATOM   1446  CB  VAL   200      23.609  39.072   7.698  1.00  8.66           C  
ATOM   1447  CG1 VAL   200      24.164  37.703   7.228  1.00  8.33           C  
ATOM   1448  CG2 VAL   200      22.846  38.947   9.017  1.00 10.38           C  
ATOM   1449  N   VAL   201      26.812  39.596   6.594  1.00  9.43           N  
ATOM   1450  CA  VAL   201      27.621  39.452   5.399  1.00  8.97           C  
ATOM   1451  C   VAL   201      27.796  37.959   5.116  1.00  9.62           C  
ATOM   1452  O   VAL   201      28.275  37.211   5.968  1.00  7.86           O  
ATOM   1453  CB  VAL   201      28.996  40.116   5.547  1.00  9.59           C  
ATOM   1454  CG1 VAL   201      29.874  39.759   4.306  1.00  9.68           C  
ATOM   1455  CG2 VAL   201      28.800  41.646   5.700  1.00 11.12           C  
ATOM   1456  N   SER   202      27.426  37.544   3.899  1.00  9.31           N  
ATOM   1457  CA  SER   202      27.409  36.101   3.605  1.00  8.95           C  
ATOM   1458  C   SER   202      27.682  35.867   2.128  1.00  9.16           C  
ATOM   1459  O   SER   202      28.438  36.636   1.488  1.00 10.38           O  
ATOM   1460  CB  SER   202      26.058  35.492   4.096  1.00  8.93           C  
ATOM   1461  OG  SER   202      25.903  34.092   3.831  1.00 10.01           O  
ATOM   1462  N   HIS   203      27.061  34.814   1.570  1.00 10.13           N  
ATOM   1463  CA  HIS   203      27.535  34.249   0.316  1.00  9.52           C  
ATOM   1464  C   HIS   203      26.367  34.086  -0.635  1.00 10.30           C  
ATOM   1465  O   HIS   203      25.216  33.917  -0.171  1.00  9.32           O  
ATOM   1466  CB  HIS   203      28.166  32.852   0.589  1.00  9.59           C  
ATOM   1467  CG  HIS   203      29.341  32.879   1.531  1.00  7.84           C  
ATOM   1468  ND1 HIS   203      30.649  32.959   1.093  1.00  9.11           N  
ATOM   1469  CD2 HIS   203      29.401  32.780   2.882  1.00 10.71           C  
ATOM   1470  CE1 HIS   203      31.465  32.895   2.139  1.00  9.53           C  
ATOM   1471  NE2 HIS   203      30.731  32.788   3.237  1.00  8.48           N  
ATOM   1472  N   GLY   204      26.642  34.041  -1.948  1.00  9.69           N  
ATOM   1473  CA  GLY   204      25.503  34.073  -2.911  1.00  9.75           C  
ATOM   1474  C   GLY   204      24.522  32.906  -2.808  1.00  9.54           C  
ATOM   1475  O   GLY   204      23.329  33.126  -2.661  1.00  9.85           O  
ATOM   1476  N   ALA   205      25.014  31.678  -2.814  1.00  9.62           N  
ATOM   1477  CA  ALA   205      24.075  30.533  -2.842  1.00  8.60           C  
ATOM   1478  C   ALA   205      23.305  30.459  -1.523  1.00  9.84           C  
ATOM   1479  O   ALA   205      22.099  30.182  -1.506  1.00  9.20           O  
ATOM   1480  CB  ALA   205      24.798  29.203  -3.200  1.00 11.04           C  
ATOM   1481  N   TYR   206      24.010  30.687  -0.419  1.00  8.72           N  
ATOM   1482  CA  TYR   206      23.350  30.676   0.884  1.00  8.73           C  
ATOM   1483  C   TYR   206      22.268  31.735   0.959  1.00  8.56           C  
ATOM   1484  O   TYR   206      21.148  31.498   1.465  1.00  8.88           O  
ATOM   1485  CB  TYR   206      24.384  30.938   1.962  1.00  7.66           C  
ATOM   1486  CG  TYR   206      23.785  30.956   3.365  1.00  9.51           C  
ATOM   1487  CD1 TYR   206      23.564  29.772   4.063  1.00  7.24           C  
ATOM   1488  CD2 TYR   206      23.374  32.155   3.961  1.00 10.79           C  
ATOM   1489  CE1 TYR   206      23.034  29.805   5.359  1.00 10.51           C  
ATOM   1490  CE2 TYR   206      22.854  32.198   5.246  1.00 11.50           C  
ATOM   1491  CZ  TYR   206      22.699  31.025   5.941  1.00 10.75           C  
ATOM   1492  OH  TYR   206      22.157  31.087   7.208  1.00 10.83           O  
ATOM   1493  N   MET   207      22.618  32.922   0.472  1.00  7.25           N  
ATOM   1494  CA  MET   207      21.640  34.024   0.460  1.00  9.04           C  
ATOM   1495  C   MET   207      20.403  33.663  -0.376  1.00  8.99           C  
ATOM   1496  O   MET   207      19.240  33.915   0.050  1.00 11.12           O  
ATOM   1497  CB  MET   207      22.287  35.307   0.016  1.00  8.31           C  
ATOM   1498  CG  MET   207      23.162  35.904   1.145  1.00  8.70           C  
ATOM   1499  SD  MET   207      24.421  37.241   0.441  1.00 11.06          SE  
ATOM   1500  CE  MET   207      23.098  38.585  -0.024  1.00 13.46           C  
ATOM   1501  N   ARG   208      20.636  33.083  -1.535  1.00 10.61           N  
ATOM   1502  CA  ARG   208      19.503  32.741  -2.425  1.00  9.90           C  
ATOM   1503  C   ARG   208      18.536  31.785  -1.713  1.00 11.11           C  
ATOM   1504  O   ARG   208      17.295  31.938  -1.782  1.00 11.37           O  
ATOM   1505  CB  ARG   208      20.015  32.179  -3.743  1.00 12.27           C  
ATOM   1506  CG  ARG   208      20.585  33.343  -4.610  1.00 15.78           C  
ATOM   1507  CD  ARG   208      20.941  32.873  -6.042  1.00 16.42           C  
ATOM   1508  NE  ARG   208      22.040  31.918  -6.103  1.00 17.26           N  
ATOM   1509  CZ  ARG   208      23.330  32.252  -6.152  1.00 16.45           C  
ATOM   1510  NH1 ARG   208      23.690  33.522  -6.102  1.00 17.32           N  
ATOM   1511  NH2 ARG   208      24.268  31.307  -6.225  1.00 17.91           N  
ATOM   1512  N   SER   209      19.091  30.845  -0.973  1.00  9.56           N  
ATOM   1513  CA  SER   209      18.271  29.853  -0.265  1.00 10.25           C  
ATOM   1514  C   SER   209      17.548  30.490   0.896  1.00 10.33           C  
ATOM   1515  O   SER   209      16.381  30.164   1.185  1.00 11.28           O  
ATOM   1516  CB  SER   209      19.144  28.705   0.232  1.00 11.33           C  
ATOM   1517  OG  SER   209      19.516  27.853  -0.832  1.00 13.34           O  
ATOM   1518  N   LEU   210      18.242  31.401   1.590  1.00 10.38           N  
ATOM   1519  CA  LEU   210      17.569  32.130   2.698  1.00  8.87           C  
ATOM   1520  C   LEU   210      16.428  32.977   2.120  1.00  9.51           C  
ATOM   1521  O   LEU   210      15.323  32.988   2.670  1.00  9.92           O  
ATOM   1522  CB  LEU   210      18.623  32.968   3.434  1.00  9.32           C  
ATOM   1523  CG  LEU   210      18.048  33.840   4.556  1.00  9.09           C  
ATOM   1524  CD1 LEU   210      17.590  32.951   5.718  1.00 10.71           C  
ATOM   1525  CD2 LEU   210      19.140  34.878   5.001  1.00 10.89           C  
ATOM   1526  N   PHE   211      16.667  33.630   0.980  1.00  9.30           N  
ATOM   1527  CA  PHE   211      15.672  34.526   0.423  1.00 10.50           C  
ATOM   1528  C   PHE   211      14.498  33.663  -0.069  1.00  9.99           C  
ATOM   1529  O   PHE   211      13.333  34.056   0.074  1.00  9.59           O  
ATOM   1530  CB  PHE   211      16.256  35.373  -0.710  1.00  9.65           C  
ATOM   1531  CG  PHE   211      17.358  36.303  -0.267  1.00 10.52           C  
ATOM   1532  CD1 PHE   211      17.539  36.610   1.083  1.00 11.62           C  
ATOM   1533  CD2 PHE   211      18.194  36.871  -1.203  1.00 14.73           C  
ATOM   1534  CE1 PHE   211      18.576  37.453   1.488  1.00 15.33           C  
ATOM   1535  CE2 PHE   211      19.217  37.745  -0.808  1.00 15.53           C  
ATOM   1536  CZ  PHE   211      19.387  38.034   0.550  1.00 13.13           C  
ATOM   1537  N   ASP   212      14.806  32.486  -0.590  1.00 10.28           N  
ATOM   1538  CA  ASP   212      13.733  31.557  -0.956  1.00 10.45           C  
ATOM   1539  C   ASP   212      12.895  31.125   0.242  1.00 10.32           C  
ATOM   1540  O   ASP   212      11.673  31.044   0.154  1.00  9.93           O  
ATOM   1541  CB  ASP   212      14.257  30.322  -1.670  1.00 11.35           C  
ATOM   1542  CG  ASP   212      13.113  29.499  -2.281  1.00 14.19           C  
ATOM   1543  OD1 ASP   212      12.306  30.036  -3.060  1.00 18.34           O  
ATOM   1544  OD2 ASP   212      12.958  28.348  -1.923  1.00 19.95           O  
ATOM   1545  N   TYR   213      13.533  30.877   1.375  1.00  9.34           N  
ATOM   1546  CA  TYR   213      12.773  30.636   2.621  1.00  9.28           C  
ATOM   1547  C   TYR   213      11.844  31.819   2.913  1.00 10.01           C  
ATOM   1548  O   TYR   213      10.654  31.633   3.166  1.00  9.71           O  
ATOM   1549  CB  TYR   213      13.741  30.430   3.765  1.00 10.44           C  
ATOM   1550  CG  TYR   213      13.072  30.316   5.104  1.00  9.68           C  
ATOM   1551  CD1 TYR   213      12.126  29.302   5.346  1.00 11.69           C  
ATOM   1552  CD2 TYR   213      13.423  31.187   6.162  1.00 11.29           C  
ATOM   1553  CE1 TYR   213      11.512  29.192   6.584  1.00 14.86           C  
ATOM   1554  CE2 TYR   213      12.818  31.065   7.378  1.00 12.39           C  
ATOM   1555  CZ  TYR   213      11.875  30.086   7.587  1.00 15.18           C  
ATOM   1556  OH  TYR   213      11.328  29.987   8.860  1.00 18.19           O  
ATOM   1557  N   PHE   214      12.362  33.044   2.825  1.00  9.20           N  
ATOM   1558  CA  PHE   214      11.530  34.208   3.131  1.00  9.42           C  
ATOM   1559  C   PHE   214      10.352  34.318   2.171  1.00 10.67           C  
ATOM   1560  O   PHE   214       9.267  34.633   2.596  1.00 10.12           O  
ATOM   1561  CB  PHE   214      12.333  35.500   3.002  1.00  9.95           C  
ATOM   1562  CG  PHE   214      13.394  35.690   4.060  1.00  8.70           C  
ATOM   1563  CD1 PHE   214      13.403  34.963   5.244  1.00  8.58           C  
ATOM   1564  CD2 PHE   214      14.387  36.661   3.852  1.00 10.59           C  
ATOM   1565  CE1 PHE   214      14.396  35.198   6.210  1.00 10.02           C  
ATOM   1566  CE2 PHE   214      15.386  36.898   4.808  1.00 10.61           C  
ATOM   1567  CZ  PHE   214      15.385  36.182   5.976  1.00 11.62           C  
ATOM   1568  N   LEU   215      10.583  34.056   0.879  1.00 10.25           N  
ATOM   1569  CA  LEU   215       9.506  34.231  -0.114  1.00 10.38           C  
ATOM   1570  C   LEU   215       8.566  33.038  -0.161  1.00 10.77           C  
ATOM   1571  O   LEU   215       7.339  33.174   0.017  1.00 11.28           O  
ATOM   1572  CB  LEU   215      10.121  34.485  -1.488  1.00 10.63           C  
ATOM   1573  CG  LEU   215       9.069  34.627  -2.612  1.00  9.43           C  
ATOM   1574  CD1 LEU   215       8.138  35.785  -2.313  1.00 12.74           C  
ATOM   1575  CD2 LEU   215       9.785  34.860  -3.967  1.00 12.27           C  
ATOM   1576  N   THR   216       9.131  31.865  -0.398  1.00 11.00           N  
ATOM   1577  CA  THR   216       8.307  30.671  -0.567  1.00 12.81           C  
ATOM   1578  C   THR   216       7.626  30.239   0.730  1.00 12.62           C  
ATOM   1579  O   THR   216       6.467  29.852   0.720  1.00 13.60           O  
ATOM   1580  CB  THR   216       9.152  29.534  -1.189  1.00 12.36           C  
ATOM   1581  OG1 THR   216       9.636  29.972  -2.460  1.00 14.69           O  
ATOM   1582  CG2 THR   216       8.319  28.262  -1.368  1.00 14.27           C  
ATOM   1583  N   ASP   217       8.359  30.285   1.847  1.00 13.20           N  
ATOM   1584  CA  ASP   217       7.882  29.746   3.104  1.00 12.92           C  
ATOM   1585  C   ASP   217       7.256  30.784   4.037  1.00 13.22           C  
ATOM   1586  O   ASP   217       6.143  30.582   4.550  1.00 15.48           O  
ATOM   1587  CB  ASP   217       9.011  28.934   3.761  1.00 13.79           C  
ATOM   1588  CG  ASP   217       9.519  27.832   2.822  1.00 16.22           C  
ATOM   1589  OD1 ASP   217       8.673  27.023   2.386  1.00 18.83           O  
ATOM   1590  OD2 ASP   217      10.702  27.797   2.466  1.00 15.17           O  
ATOM   1591  N   LEU   218       7.916  31.930   4.212  1.00 10.94           N  
ATOM   1592  CA  LEU   218       7.348  32.985   5.050  1.00 11.53           C  
ATOM   1593  C   LEU   218       6.392  33.937   4.297  1.00 11.62           C  
ATOM   1594  O   LEU   218       5.723  34.808   4.914  1.00 12.88           O  
ATOM   1595  CB  LEU   218       8.481  33.745   5.769  1.00 11.54           C  
ATOM   1596  CG  LEU   218       9.332  32.906   6.752  1.00 12.78           C  
ATOM   1597  CD1 LEU   218      10.272  33.818   7.514  1.00 12.03           C  
ATOM   1598  CD2 LEU   218       8.443  32.131   7.731  1.00 15.13           C  
ATOM   1599  N   LYS   219       6.339  33.766   2.979  1.00 11.24           N  
ATOM   1600  CA  LYS   219       5.419  34.528   2.134  1.00 12.22           C  
ATOM   1601  C   LYS   219       5.700  36.040   2.224  1.00 12.08           C  
ATOM   1602  O   LYS   219       4.752  36.851   2.263  1.00 12.49           O  
ATOM   1603  CB  LYS   219       3.949  34.225   2.515  1.00 14.45           C  
ATOM   1604  CG  LYS   219       3.542  32.732   2.601  1.00 17.85           C  
ATOM   1605  CD  LYS   219       3.793  31.984   1.282  1.00 19.35           C  
ATOM   1606  CE  LYS   219       3.347  30.499   1.371  1.00 22.17           C  
ATOM   1607  NZ  LYS   219       3.656  29.950   2.699  1.00 27.12           N  
ATOM   1608  N   CYS   220       7.000  36.404   2.185  1.00 11.26           N  
ATOM   1609  CA  CYS   220       7.395  37.824   2.261  0.80 11.17           C  
ATOM   1611  C   CYS   220       6.842  38.615   1.085  1.00 11.75           C  
ATOM   1612  O   CYS   220       6.593  38.082  -0.005  1.00 11.77           O  
ATOM   1613  CB  CYS   220       8.907  38.003   2.340  0.80 11.41           C  
ATOM   1615  SG  CYS   220       9.772  37.747   0.774  0.80 12.73           S  
ATOM   1617  N   SER   221       6.585  39.897   1.334  1.00 12.01           N  
ATOM   1618  CA  SER   221       6.150  40.778   0.265  1.00 13.09           C  
ATOM   1619  C   SER   221       7.377  41.226  -0.550  1.00 14.04           C  
ATOM   1620  O   SER   221       8.492  41.258  -0.029  1.00 14.60           O  
ATOM   1621  CB  SER   221       5.389  41.968   0.837  1.00 13.77           C  
ATOM   1622  OG  SER   221       6.180  42.739   1.729  1.00 13.35           O  
ATOM   1623  N   LEU   222       7.165  41.555  -1.822  1.00 15.54           N  
ATOM   1624  CA  LEU   222       8.265  41.947  -2.720  1.00 17.54           C  
ATOM   1625  C   LEU   222       7.970  43.329  -3.322  1.00 19.60           C  
ATOM   1626  O   LEU   222       6.825  43.619  -3.649  1.00 20.17           O  
ATOM   1627  CB  LEU   222       8.395  40.946  -3.869  1.00 17.61           C  
ATOM   1628  CG  LEU   222       8.783  39.513  -3.568  1.00 18.69           C  
ATOM   1629  CD1 LEU   222       8.813  38.720  -4.849  1.00 19.94           C  
ATOM   1630  CD2 LEU   222      10.141  39.432  -2.857  1.00 20.71           C  
ATOM   1631  N   PRO   223       9.006  44.170  -3.499  1.00 22.05           N  
ATOM   1632  CA  PRO   223       8.735  45.432  -4.199  1.00 23.24           C  
ATOM   1633  C   PRO   223       8.219  45.147  -5.644  1.00 24.73           C  
ATOM   1634  O   PRO   223       8.453  44.071  -6.172  1.00 23.36           O  
ATOM   1635  CB  PRO   223      10.102  46.129  -4.224  1.00 22.98           C  
ATOM   1636  CG  PRO   223      10.992  45.386  -3.256  1.00 23.58           C  
ATOM   1637  CD  PRO   223      10.414  43.998  -3.114  1.00 22.06           C  
ATOM   1638  N   ALA   224       7.538  46.118  -6.255  1.00 26.52           N  
ATOM   1639  CA  ALA   224       7.013  45.993  -7.628  1.00 27.20           C  
ATOM   1640  C   ALA   224       8.122  45.798  -8.679  1.00 27.32           C  
ATOM   1641  O   ALA   224       7.891  45.228  -9.744  1.00 27.65           O  
ATOM   1642  CB  ALA   224       6.187  47.210  -7.969  1.00 27.94           C  
ATOM   1643  N   THR   225       9.320  46.257  -8.349  1.00 27.06           N  
ATOM   1644  CA  THR   225      10.485  46.172  -9.227  1.00 27.45           C  
ATOM   1645  C   THR   225      11.260  44.855  -9.100  1.00 26.00           C  
ATOM   1646  O   THR   225      12.251  44.629  -9.804  1.00 26.66           O  
ATOM   1647  CB  THR   225      11.428  47.339  -8.900  1.00 28.46           C  
ATOM   1648  OG1 THR   225      11.377  47.607  -7.486  1.00 31.78           O  
ATOM   1649  CG2 THR   225      10.985  48.581  -9.650  1.00 30.14           C  
ATOM   1650  N   LEU   226      10.828  43.975  -8.199  1.00 23.06           N  
ATOM   1651  CA  LEU   226      11.565  42.749  -7.951  0.70 22.35           C  
ATOM   1653  C   LEU   226      10.794  41.516  -8.397  1.00 22.73           C  
ATOM   1654  O   LEU   226       9.766  41.165  -7.805  1.00 23.06           O  
ATOM   1655  CB  LEU   226      11.915  42.621  -6.462  0.70 22.21           C  
ATOM   1657  CG  LEU   226      12.645  41.357  -6.011  0.70 21.36           C  
ATOM   1659  CD1 LEU   226      14.027  41.305  -6.595  0.70 19.42           C  
ATOM   1661  CD2 LEU   226      12.727  41.337  -4.500  0.70 21.10           C  
ATOM   1663  N   SER   227      11.318  40.850  -9.417  1.00 21.25           N  
ATOM   1664  CA  SER   227      10.727  39.614  -9.908  1.00 20.51           C  
ATOM   1665  C   SER   227      11.064  38.461  -8.957  1.00 20.26           C  
ATOM   1666  O   SER   227      12.080  38.498  -8.239  1.00 19.13           O  
ATOM   1667  CB  SER   227      11.282  39.296 -11.304  1.00 20.26           C  
ATOM   1668  OG  SER   227      12.667  39.041 -11.219  1.00 20.10           O  
ATOM   1669  N   ARG   228      10.236  37.418  -8.960  1.00 20.07           N  
ATOM   1670  CA  ARG   228      10.622  36.175  -8.282  1.00 19.92           C  
ATOM   1671  C   ARG   228      11.911  35.579  -8.856  1.00 20.94           C  
ATOM   1672  O   ARG   228      12.730  35.000  -8.118  1.00 20.58           O  
ATOM   1673  CB  ARG   228       9.483  35.143  -8.344  1.00 19.92           C  
ATOM   1674  CG  ARG   228       8.135  35.696  -7.878  1.00 20.51           C  
ATOM   1675  CD  ARG   228       7.076  34.614  -7.959  1.00 21.49           C  
ATOM   1676  NE  ARG   228       7.084  33.695  -6.813  1.00 21.75           N  
ATOM   1677  CZ  ARG   228       6.488  33.960  -5.648  1.00 21.92           C  
ATOM   1678  NH1 ARG   228       6.549  33.053  -4.678  1.00 21.92           N  
ATOM   1679  NH2 ARG   228       5.858  35.129  -5.441  1.00 19.45           N  
ATOM   1680  N   SER   229      12.135  35.746 -10.171  1.00 20.25           N  
ATOM   1681  CA  SER   229      13.321  35.200 -10.798  1.00 20.93           C  
ATOM   1682  C   SER   229      14.635  35.825 -10.306  1.00 20.97           C  
ATOM   1683  O   SER   229      15.655  35.134 -10.249  1.00 20.98           O  
ATOM   1684  CB  SER   229      13.227  35.330 -12.319  1.00 21.06           C  
ATOM   1685  OG  SER   229      12.191  34.481 -12.787  1.00 21.93           O  
ATOM   1686  N   GLU   230      14.582  37.105  -9.951  1.00 21.77           N  
ATOM   1687  CA  GLU   230      15.745  37.842  -9.443  1.00 23.44           C  
ATOM   1688  C   GLU   230      16.241  37.121  -8.208  1.00 24.30           C  
ATOM   1689  O   GLU   230      17.427  36.822  -8.038  1.00 23.11           O  
ATOM   1690  CB  GLU   230      15.327  39.232  -8.986  1.00 24.88           C  
ATOM   1691  CG  GLU   230      16.446  39.964  -8.211  1.00 25.43           C  
ATOM   1692  CD  GLU   230      17.011  41.126  -8.957  1.00 26.89           C  
ATOM   1693  OE1 GLU   230      16.267  41.704  -9.768  1.00 24.08           O  
ATOM   1694  OE2 GLU   230      18.173  41.500  -8.684  1.00 27.40           O  
ATOM   1695  N   LEU   231      15.273  36.842  -7.355  1.00 24.65           N  
ATOM   1696  CA  LEU   231      15.505  36.472  -5.987  1.00 27.37           C  
ATOM   1697  C   LEU   231      16.227  35.128  -5.920  1.00 29.19           C  
ATOM   1698  O   LEU   231      17.116  34.926  -5.074  1.00 30.79           O  
ATOM   1699  CB  LEU   231      14.133  36.437  -5.258  1.00 26.15           C  
ATOM   1700  CG  LEU   231      14.103  35.965  -3.808  1.00 25.48           C  
ATOM   1701  CD1 LEU   231      13.097  36.817  -3.039  1.00 24.11           C  
ATOM   1702  CD2 LEU   231      13.722  34.484  -3.709  1.00 24.46           C  
ATOM   1703  N   MET   232      15.892  34.259  -6.869  1.00 31.30           N  
ATOM   1704  CA  MET   232      16.273  32.841  -6.802  0.50 32.60           C  
ATOM   1706  C   MET   232      17.579  32.519  -7.520  1.00 32.66           C  
ATOM   1707  O   MET   232      18.270  31.545  -7.156  1.00 33.58           O  
ATOM   1708  CB  MET   232      15.130  31.960  -7.316  0.50 32.48           C  
ATOM   1710  CG  MET   232      13.833  32.197  -6.556  0.50 33.23           C  
ATOM   1712  SD  MET   232      12.288  31.294  -7.301  0.50 34.88          SE  
ATOM   1714  CE  MET   232      12.824  29.439  -6.973  0.50 35.68           C  
ATOM   1716  N   SER   233      17.902  33.327  -8.515  1.00 32.34           N  
ATOM   1717  CA  SER   233      19.173  33.283  -9.197  1.00 32.73           C  
ATOM   1718  C   SER   233      19.526  34.735  -9.260  1.00 32.27           C  
ATOM   1719  O   SER   233      18.661  35.516  -9.653  1.00 33.00           O  
ATOM   1720  CB  SER   233      19.010  32.787 -10.617  1.00 33.04           C  
ATOM   1721  OG  SER   233      18.096  33.619 -11.336  1.00 37.07           O  
ATOM   1722  N   VAL   234      20.759  35.092  -8.861  1.00 30.11           N  
ATOM   1723  CA  VAL   234      21.353  36.417  -9.039  1.00 29.06           C  
ATOM   1724  C   VAL   234      21.759  36.972  -7.668  1.00 27.42           C  
ATOM   1725  O   VAL   234      20.861  37.292  -6.847  1.00 27.92           O  
ATOM   1726  CB  VAL   234      20.401  37.472  -9.761  1.00 30.12           C  
ATOM   1727  CG1 VAL   234      21.032  38.881  -9.755  1.00 32.18           C  
ATOM   1728  CG2 VAL   234      20.084  37.050 -11.177  1.00 30.59           C  
ATOM   1729  N   THR   235      23.084  37.044  -7.414  1.00 24.54           N  
ATOM   1730  CA  THR   235      23.611  37.828  -6.274  1.00 21.55           C  
ATOM   1731  C   THR   235      24.970  38.463  -6.580  1.00 20.36           C  
ATOM   1732  O   THR   235      25.994  37.787  -6.534  1.00 20.67           O  
ATOM   1733  CB  THR   235      23.793  36.967  -4.996  1.00 20.99           C  
ATOM   1734  OG1 THR   235      22.701  36.060  -4.860  1.00 21.81           O  
ATOM   1735  CG2 THR   235      23.909  37.893  -3.732  1.00 19.10           C  
ATOM   1736  N   PRO   236      24.994  39.767  -6.880  1.00 18.67           N  
ATOM   1737  CA  PRO   236      26.263  40.458  -7.209  1.00 17.30           C  
ATOM   1738  C   PRO   236      27.175  40.544  -5.981  1.00 16.11           C  
ATOM   1739  O   PRO   236      26.660  40.543  -4.861  1.00 15.24           O  
ATOM   1740  CB  PRO   236      25.813  41.883  -7.586  1.00 18.40           C  
ATOM   1741  CG  PRO   236      24.320  41.835  -7.742  1.00 19.11           C  
ATOM   1742  CD  PRO   236      23.824  40.662  -6.942  1.00 18.91           C  
ATOM   1743  N   ASN   237      28.495  40.623  -6.184  1.00 15.37           N  
ATOM   1744  CA  ASN   237      29.410  40.915  -5.067  1.00 14.60           C  
ATOM   1745  C   ASN   237      29.053  42.256  -4.406  1.00 13.70           C  
ATOM   1746  O   ASN   237      28.875  43.267  -5.093  1.00 15.31           O  
ATOM   1747  CB  ASN   237      30.871  40.917  -5.503  1.00 14.73           C  
ATOM   1748  CG  ASN   237      31.377  39.526  -5.865  1.00 15.52           C  
ATOM   1749  OD1 ASN   237      31.642  39.260  -7.037  1.00 19.53           O  
ATOM   1750  ND2 ASN   237      31.449  38.610  -4.870  1.00 14.35           N  
ATOM   1751  N   THR   238      28.974  42.244  -3.083  1.00 12.97           N  
ATOM   1752  CA  THR   238      28.441  43.358  -2.231  1.00 12.00           C  
ATOM   1753  C   THR   238      27.022  43.852  -2.533  1.00 13.36           C  
ATOM   1754  O   THR   238      26.633  44.940  -2.108  1.00 13.65           O  
ATOM   1755  CB  THR   238      29.436  44.556  -2.091  1.00 12.82           C  
ATOM   1756  OG1 THR   238      29.545  45.243  -3.343  1.00 14.76           O  
ATOM   1757  CG2 THR   238      30.807  44.035  -1.598  1.00 13.59           C  
ATOM   1758  N   GLY   239      26.268  43.034  -3.271  1.00 13.24           N  
ATOM   1759  CA  GLY   239      24.830  43.263  -3.519  1.00 13.93           C  
ATOM   1760  C   GLY   239      24.107  43.245  -2.182  1.00 13.74           C  
ATOM   1761  O   GLY   239      24.339  42.340  -1.368  1.00 14.21           O  
ATOM   1762  N   MET   240      23.242  44.239  -1.966  1.00 12.78           N  
ATOM   1763  CA  MET   240      22.584  44.447  -0.685  1.00 13.58           C  
ATOM   1764  C   MET   240      21.069  44.208  -0.750  1.00 13.24           C  
ATOM   1765  O   MET   240      20.395  44.680  -1.660  1.00 13.69           O  
ATOM   1766  CB  MET   240      22.806  45.896  -0.220  1.00 15.11           C  
ATOM   1767  CG  MET   240      24.272  46.251  -0.086  1.00 15.12           C  
ATOM   1768  SD  MET   240      24.362  48.070   0.611  1.00 18.77          SE  
ATOM   1769  CE  MET   240      26.264  48.246   0.501  1.00 18.08           C  
ATOM   1770  N   SER   241      20.549  43.509   0.255  1.00 13.14           N  
ATOM   1771  CA  SER   241      19.119  43.255   0.356  0.70 12.52           C  
ATOM   1773  C   SER   241      18.692  43.676   1.746  1.00 13.29           C  
ATOM   1774  O   SER   241      19.403  43.434   2.713  1.00 14.20           O  
ATOM   1775  CB  SER   241      18.850  41.760   0.131  0.70 12.45           C  
ATOM   1777  OG  SER   241      19.292  41.387  -1.161  0.70 10.80           O  
ATOM   1779  N   LEU   242      17.529  44.328   1.846  1.00 12.23           N  
ATOM   1780  CA  LEU   242      16.979  44.770   3.117  1.00 12.90           C  
ATOM   1781  C   LEU   242      15.586  44.170   3.282  1.00 11.83           C  
ATOM   1782  O   LEU   242      14.755  44.272   2.345  1.00 12.05           O  
ATOM   1783  CB  LEU   242      16.875  46.318   3.160  1.00 13.04           C  
ATOM   1784  CG  LEU   242      16.191  46.884   4.429  1.00 15.99           C  
ATOM   1785  CD1 LEU   242      16.974  46.593   5.720  1.00 15.29           C  
ATOM   1786  CD2 LEU   242      16.016  48.428   4.269  1.00 14.21           C  
ATOM   1787  N   PHE   243      15.361  43.622   4.482  1.00 11.67           N  
ATOM   1788  CA  PHE   243      14.080  43.045   4.930  1.00 12.76           C  
ATOM   1789  C   PHE   243      13.642  43.680   6.256  1.00 12.46           C  
ATOM   1790  O   PHE   243      14.480  43.930   7.155  1.00 12.87           O  
ATOM   1791  CB  PHE   243      14.219  41.532   5.128  1.00 12.81           C  
ATOM   1792  CG  PHE   243      14.701  40.822   3.892  1.00 13.64           C  
ATOM   1793  CD1 PHE   243      13.810  40.355   2.948  1.00 14.82           C  
ATOM   1794  CD2 PHE   243      16.068  40.676   3.672  1.00 15.31           C  
ATOM   1795  CE1 PHE   243      14.283  39.710   1.748  1.00 14.92           C  
ATOM   1796  CE2 PHE   243      16.548  40.066   2.540  1.00 12.18           C  
ATOM   1797  CZ  PHE   243      15.672  39.588   1.565  1.00 10.84           C  
ATOM   1798  N   ILE   244      12.335  43.896   6.398  1.00 12.62           N  
ATOM   1799  CA  ILE   244      11.789  44.211   7.698  1.00 12.69           C  
ATOM   1800  C   ILE   244      11.060  42.959   8.227  1.00 11.90           C  
ATOM   1801  O   ILE   244      10.181  42.396   7.558  1.00 12.22           O  
ATOM   1802  CB  ILE   244      10.846  45.460   7.683  1.00 13.59           C  
ATOM   1803  CG1 ILE   244      11.553  46.710   7.095  1.00 16.20           C  
ATOM   1804  CG2 ILE   244      10.370  45.738   9.092  1.00 14.97           C  
ATOM   1805  CD1 ILE   244      12.795  47.147   7.862  1.00 19.67           C  
ATOM   1806  N   ILE   245      11.453  42.509   9.412  1.00 11.60           N  
ATOM   1807  CA  ILE   245      10.858  41.320  10.032  1.00 11.68           C  
ATOM   1808  C   ILE   245       9.879  41.784  11.105  1.00 13.67           C  
ATOM   1809  O   ILE   245      10.246  42.595  11.946  1.00 13.43           O  
ATOM   1810  CB  ILE   245      11.944  40.445  10.706  1.00 11.82           C  
ATOM   1811  CG1 ILE   245      13.184  40.245   9.781  1.00 12.57           C  
ATOM   1812  CG2 ILE   245      11.358  39.134  11.191  1.00 13.22           C  
ATOM   1813  CD1 ILE   245      12.849  39.659   8.365  1.00 14.11           C  
ATOM   1814  N   ASN   246       8.674  41.220  11.116  1.00 12.98           N  
ATOM   1815  CA  ASN   246       7.570  41.742  11.953  1.00 14.16           C  
ATOM   1816  C   ASN   246       6.988  40.612  12.804  1.00 14.34           C  
ATOM   1817  O   ASN   246       6.585  39.556  12.275  1.00 13.56           O  
ATOM   1818  CB  ASN   246       6.425  42.270  11.045  1.00 15.39           C  
ATOM   1819  CG  ASN   246       6.871  43.351  10.067  1.00 18.81           C  
ATOM   1820  OD1 ASN   246       7.381  43.092   8.938  1.00 23.58           O  
ATOM   1821  ND2 ASN   246       6.644  44.593  10.475  1.00 22.31           N  
ATOM   1822  N   PHE   247       6.923  40.822  14.127  1.00 15.67           N  
ATOM   1823  CA  PHE   247       6.282  39.853  14.997  1.00 16.23           C  
ATOM   1824  C   PHE   247       5.077  40.508  15.677  1.00 18.30           C  
ATOM   1825  O   PHE   247       5.220  41.540  16.320  1.00 17.11           O  
ATOM   1826  CB  PHE   247       7.234  39.383  16.116  1.00 17.45           C  
ATOM   1827  CG  PHE   247       8.305  38.430  15.667  1.00 16.77           C  
ATOM   1828  CD1 PHE   247       8.106  37.063  15.754  1.00 17.77           C  
ATOM   1829  CD2 PHE   247       9.519  38.909  15.190  1.00 19.72           C  
ATOM   1830  CE1 PHE   247       9.088  36.164  15.310  1.00 19.81           C  
ATOM   1831  CE2 PHE   247      10.509  38.024  14.758  1.00 17.22           C  
ATOM   1832  CZ  PHE   247      10.293  36.657  14.829  1.00 18.61           C  
ATOM   1833  N   GLU   248       3.923  39.876  15.551  1.00 19.35           N  
ATOM   1834  CA  GLU   248       2.781  40.197  16.416  1.00 22.23           C  
ATOM   1835  C   GLU   248       3.103  39.774  17.853  1.00 22.71           C  
ATOM   1836  O   GLU   248       4.013  38.979  18.080  1.00 20.96           O  
ATOM   1837  CB  GLU   248       1.532  39.491  15.889  1.00 22.61           C  
ATOM   1838  CG  GLU   248       0.932  40.248  14.695  1.00 25.01           C  
ATOM   1839  CD  GLU   248      -0.290  39.602  14.050  1.00 26.62           C  
ATOM   1840  OE1 GLU   248      -0.802  38.579  14.550  1.00 32.28           O  
ATOM   1841  OE2 GLU   248      -0.744  40.145  13.015  1.00 33.12           O  
ATOM   1842  N   GLU   249       2.374  40.335  18.822  1.00 24.15           N  
ATOM   1843  CA  GLU   249       2.566  39.933  20.207  1.00 26.26           C  
ATOM   1844  C   GLU   249       2.084  38.503  20.390  1.00 24.94           C  
ATOM   1845  O   GLU   249       1.216  38.006  19.641  1.00 24.12           O  
ATOM   1846  CB  GLU   249       1.843  40.888  21.148  1.00 25.98           C  
ATOM   1847  CG  GLU   249       0.531  40.375  21.742  1.00 31.22           C  
ATOM   1848  CD  GLU   249      -0.230  41.493  22.450  1.00 30.94           C  
ATOM   1849  OE1 GLU   249       0.432  42.430  22.991  1.00 38.11           O  
ATOM   1850  OE2 GLU   249      -1.481  41.457  22.429  1.00 37.68           O  
ATOM   1851  N   GLY   250       2.678  37.831  21.362  1.00 24.73           N  
ATOM   1852  CA  GLY   250       2.268  36.496  21.738  1.00 25.76           C  
ATOM   1853  C   GLY   250       3.414  35.552  21.992  1.00 25.75           C  
ATOM   1854  O   GLY   250       4.567  35.989  22.161  1.00 25.79           O  
ATOM   1855  N   ARG   251       3.088  34.256  22.015  1.00 26.24           N  
ATOM   1856  CA  ARG   251       4.046  33.166  22.217  1.00 27.25           C  
ATOM   1857  C   ARG   251       4.241  32.399  20.920  1.00 27.77           C  
ATOM   1858  O   ARG   251       3.263  32.141  20.216  1.00 28.46           O  
ATOM   1859  CB  ARG   251       3.515  32.186  23.283  1.00 27.24           C  
ATOM   1860  CG  ARG   251       3.140  32.856  24.591  1.00 28.49           C  
ATOM   1861  CD  ARG   251       2.561  31.859  25.640  1.00 28.57           C  
ATOM   1862  NE  ARG   251       1.780  32.587  26.639  1.00 33.40           N  
ATOM   1863  CZ  ARG   251       2.276  33.080  27.773  1.00 34.86           C  
ATOM   1864  NH1 ARG   251       3.558  32.901  28.084  1.00 34.71           N  
ATOM   1865  NH2 ARG   251       1.480  33.746  28.602  1.00 36.04           N  
ATOM   1866  N   GLU   252       5.493  32.042  20.616  1.00 27.82           N  
ATOM   1867  CA  GLU   252       5.857  31.247  19.428  1.00 28.91           C  
ATOM   1868  C   GLU   252       5.214  31.815  18.146  1.00 26.70           C  
ATOM   1869  O   GLU   252       4.576  31.089  17.373  1.00 27.41           O  
ATOM   1870  CB  GLU   252       5.455  29.774  19.617  1.00 28.85           C  
ATOM   1871  CG  GLU   252       6.465  28.782  19.055  1.00 32.65           C  
ATOM   1872  CD  GLU   252       6.321  27.363  19.621  1.00 32.84           C  
ATOM   1873  OE1 GLU   252       7.240  26.561  19.360  1.00 40.25           O  
ATOM   1874  OE2 GLU   252       5.302  27.029  20.290  1.00 38.53           O  
ATOM   1875  N   VAL   253       5.371  33.117  17.958  1.00 25.17           N  
ATOM   1876  CA  VAL   253       4.775  33.851  16.836  1.00 22.77           C  
ATOM   1877  C   VAL   253       5.595  33.691  15.556  1.00 21.79           C  
ATOM   1878  O   VAL   253       6.816  33.855  15.559  1.00 21.90           O  
ATOM   1879  CB  VAL   253       4.580  35.341  17.196  1.00 22.33           C  
ATOM   1880  CG1 VAL   253       4.074  36.171  15.993  1.00 21.72           C  
ATOM   1881  CG2 VAL   253       3.605  35.476  18.387  1.00 24.21           C  
ATOM   1882  N   LYS   254       4.895  33.354  14.475  1.00 20.12           N  
ATOM   1883  CA  LYS   254       5.478  33.286  13.146  1.00 18.03           C  
ATOM   1884  C   LYS   254       5.614  34.706  12.594  1.00 17.17           C  
ATOM   1885  O   LYS   254       4.621  35.404  12.471  1.00 16.18           O  
ATOM   1886  CB  LYS   254       4.570  32.497  12.207  1.00 19.08           C  
ATOM   1887  CG  LYS   254       5.238  32.176  10.891  1.00 19.33           C  
ATOM   1888  CD  LYS   254       4.260  31.439   9.948  1.00 26.85           C  
ATOM   1889  CE  LYS   254       4.926  31.017   8.656  1.00 30.92           C  
ATOM   1890  NZ  LYS   254       3.996  30.199   7.841  1.00 34.45           N  
ATOM   1891  N   PRO   255       6.841  35.118  12.235  1.00 15.86           N  
ATOM   1892  CA  PRO   255       6.987  36.492  11.743  1.00 14.73           C  
ATOM   1893  C   PRO   255       6.441  36.684  10.334  1.00 14.00           C  
ATOM   1894  O   PRO   255       6.259  35.704   9.594  1.00 15.12           O  
ATOM   1895  CB  PRO   255       8.517  36.704  11.706  1.00 14.51           C  
ATOM   1896  CG  PRO   255       9.068  35.329  11.521  1.00 15.15           C  
ATOM   1897  CD  PRO   255       8.117  34.382  12.249  1.00 16.49           C  
ATOM   1898  N   THR   256       6.163  37.928   9.982  1.00 13.78           N  
ATOM   1899  CA  THR   256       5.953  38.277   8.570  1.00 13.57           C  
ATOM   1900  C   THR   256       7.164  39.079   8.096  1.00 13.58           C  
ATOM   1901  O   THR   256       7.872  39.668   8.915  1.00 14.02           O  
ATOM   1902  CB  THR   256       4.658  39.061   8.380  1.00 13.94           C  
ATOM   1903  OG1 THR   256       4.633  40.216   9.244  1.00 15.02           O  
ATOM   1904  CG2 THR   256       3.466  38.145   8.671  1.00 14.83           C  
ATOM   1905  N   VAL   257       7.398  39.098   6.782  1.00 11.39           N  
ATOM   1906  CA  VAL   257       8.633  39.673   6.254  1.00 11.79           C  
ATOM   1907  C   VAL   257       8.275  40.582   5.067  1.00 12.49           C  
ATOM   1908  O   VAL   257       7.431  40.238   4.259  1.00 11.88           O  
ATOM   1909  CB  VAL   257       9.603  38.560   5.797  1.00 12.20           C  
ATOM   1910  CG1 VAL   257      10.891  39.173   5.158  1.00 12.84           C  
ATOM   1911  CG2 VAL   257       9.926  37.554   6.989  1.00 11.37           C  
ATOM   1912  N   GLN   258       8.886  41.761   5.028  1.00 12.80           N  
ATOM   1913  CA  GLN   258       8.757  42.676   3.898  1.00 14.83           C  
ATOM   1914  C   GLN   258      10.146  42.821   3.279  1.00 13.10           C  
ATOM   1915  O   GLN   258      11.081  43.235   3.951  1.00 13.61           O  
ATOM   1916  CB  GLN   258       8.279  44.066   4.374  1.00 15.18           C  
ATOM   1917  CG  GLN   258       6.887  44.059   4.975  1.00 18.60           C  
ATOM   1918  CD  GLN   258       6.563  45.334   5.754  1.00 21.61           C  
ATOM   1919  OE1 GLN   258       7.172  45.643   6.800  1.00 26.56           O  
ATOM   1920  NE2 GLN   258       5.584  46.086   5.239  1.00 28.76           N  
ATOM   1921  N   CYS   259      10.274  42.453   2.014  1.00 13.04           N  
ATOM   1922  CA  CYS   259      11.499  42.712   1.287  1.00 12.61           C  
ATOM   1923  C   CYS   259      11.459  44.148   0.753  1.00 13.03           C  
ATOM   1924  O   CYS   259      10.541  44.511  -0.009  1.00 14.63           O  
ATOM   1925  CB  CYS   259      11.669  41.726   0.144  1.00 13.09           C  
ATOM   1926  SG  CYS   259      13.167  42.105  -0.790  1.00 14.63           S  
ATOM   1927  N   ILE   260      12.415  44.952   1.191  1.00 13.62           N  
ATOM   1928  CA  ILE   260      12.519  46.388   0.817  1.00 14.08           C  
ATOM   1929  C   ILE   260      13.311  46.576  -0.486  1.00 15.41           C  
ATOM   1930  O   ILE   260      12.898  47.347  -1.378  1.00 15.09           O  
ATOM   1931  CB  ILE   260      13.128  47.246   1.960  1.00 14.59           C  
ATOM   1932  CG1 ILE   260      12.328  47.110   3.275  1.00 13.59           C  
ATOM   1933  CG2 ILE   260      13.302  48.705   1.519  1.00 15.12           C  
ATOM   1934  CD1 ILE   260      10.798  47.437   3.184  1.00 17.11           C  
ATOM   1935  N   CYS   261      14.436  45.867  -0.603  1.00 14.81           N  
ATOM   1936  CA  CYS   261      15.202  45.843  -1.858  1.00 15.96           C  
ATOM   1937  C   CYS   261      16.019  44.575  -1.893  1.00 16.00           C  
ATOM   1938  O   CYS   261      16.188  43.935  -0.853  1.00 16.30           O  
ATOM   1939  CB  CYS   261      16.111  47.071  -1.964  1.00 16.22           C  
ATOM   1940  SG  CYS   261      17.350  47.186  -0.680  1.00 20.19           S  
ATOM   1941  N   MET   262      16.475  44.188  -3.076  1.00 16.20           N  
ATOM   1942  CA  MET   262      17.340  43.008  -3.196  1.00 17.67           C  
ATOM   1943  C   MET   262      18.416  43.285  -4.214  1.00 17.67           C  
ATOM   1944  O   MET   262      18.147  43.915  -5.245  1.00 17.51           O  
ATOM   1945  CB  MET   262      16.526  41.772  -3.601  1.00 17.55           C  
ATOM   1946  CG  MET   262      17.351  40.476  -3.744  1.00 20.14           C  
ATOM   1947  SD  MET   262      16.188  38.954  -3.853  1.00 20.86          SE  
ATOM   1948  CE  MET   262      15.557  39.102  -2.039  1.00 21.38           C  
ATOM   1949  N   ASN   263      19.633  42.828  -3.916  1.00 16.44           N  
ATOM   1950  CA  ASN   263      20.752  42.967  -4.856  1.00 17.08           C  
ATOM   1951  C   ASN   263      21.022  44.425  -5.263  1.00 18.00           C  
ATOM   1952  O   ASN   263      21.442  44.694  -6.418  1.00 19.37           O  
ATOM   1953  CB  ASN   263      20.519  42.091  -6.092  1.00 16.01           C  
ATOM   1954  CG  ASN   263      20.470  40.618  -5.748  1.00 17.20           C  
ATOM   1955  OD1 ASN   263      21.136  40.190  -4.797  1.00 16.42           O  
ATOM   1956  ND2 ASN   263      19.749  39.824  -6.544  1.00 20.11           N  
ATOM   1957  N   LEU   264      20.781  45.343  -4.337  1.00 18.06           N  
ATOM   1958  CA  LEU   264      21.088  46.764  -4.563  1.00 20.40           C  
ATOM   1959  C   LEU   264      22.596  46.926  -4.814  1.00 21.29           C  
ATOM   1960  O   LEU   264      23.418  46.399  -4.050  1.00 20.30           O  
ATOM   1961  CB  LEU   264      20.687  47.612  -3.350  1.00 20.35           C  
ATOM   1962  CG  LEU   264      20.446  49.114  -3.581  1.00 23.12           C  
ATOM   1963  CD1 LEU   264      19.371  49.296  -4.670  1.00 24.12           C  
ATOM   1964  CD2 LEU   264      20.018  49.775  -2.298  1.00 21.83           C  
ATOM   1965  N   GLN   265      22.955  47.657  -5.874  1.00 22.67           N  
ATOM   1966  CA  GLN   265      24.380  47.952  -6.140  1.00 25.66           C  
ATOM   1967  C   GLN   265      24.668  49.436  -6.393  1.00 26.47           C  
ATOM   1968  O   GLN   265      25.604  49.743  -7.139  1.00 27.18           O  
ATOM   1969  CB  GLN   265      24.925  47.188  -7.351  1.00 25.38           C  
ATOM   1970  CG  GLN   265      24.243  45.906  -7.762  1.00 28.61           C  
ATOM   1971  CD  GLN   265      24.906  45.265  -8.962  1.00 28.26           C  
ATOM   1972  OE1 GLN   265      26.146  45.211  -9.065  1.00 33.40           O  
ATOM   1973  NE2 GLN   265      24.092  44.746  -9.872  1.00 33.70           N  
ATOM   1974  N   ASP   266      23.903  50.326  -5.753  1.00 28.13           N  
ATOM   1975  CA  ASP   266      24.028  51.794  -5.906  1.00 30.32           C  
ATOM   1976  C   ASP   266      25.391  52.326  -5.456  1.00 30.83           C  
ATOM   1977  O   ASP   266      25.838  53.402  -5.891  1.00 31.49           O  
ATOM   1978  CB  ASP   266      22.934  52.499  -5.094  1.00 30.71           C  
ATOM   1979  CG  ASP   266      21.547  52.313  -5.687  1.00 32.76           C  
ATOM   1980  OD1 ASP   266      21.434  51.819  -6.830  1.00 35.90           O  
ATOM   1981  OD2 ASP   266      20.569  52.687  -5.007  1.00 35.33           O  
ATOM   1982  N   HIS   267      26.040  51.590  -4.563  1.00 29.75           N  
ATOM   1983  CA  HIS   267      27.378  51.928  -4.124  1.00 29.59           C  
ATOM   1984  C   HIS   267      28.480  51.599  -5.154  1.00 30.49           C  
ATOM   1985  O   HIS   267      29.633  52.004  -4.962  1.00 31.58           O  
ATOM   1986  CB  HIS   267      27.657  51.216  -2.800  1.00 28.97           C  
ATOM   1987  CG  HIS   267      27.627  49.725  -2.912  1.00 24.06           C  
ATOM   1988  ND1 HIS   267      26.469  49.026  -3.188  1.00 22.05           N  
ATOM   1989  CD2 HIS   267      28.611  48.804  -2.805  1.00 21.74           C  
ATOM   1990  CE1 HIS   267      26.745  47.732  -3.246  1.00 20.69           C  
ATOM   1991  NE2 HIS   267      28.039  47.574  -3.021  1.00 19.76           N  
ATOM   1992  N   LEU   268      28.151  50.870  -6.222  1.00 31.07           N  
ATOM   1993  CA  LEU   268      29.165  50.394  -7.182  1.00 32.45           C  
ATOM   1994  C   LEU   268      29.296  51.186  -8.499  1.00 34.57           C  
ATOM   1995  O   LEU   268      30.254  50.978  -9.247  1.00 34.93           O  
ATOM   1996  CB  LEU   268      28.976  48.905  -7.512  1.00 31.83           C  
ATOM   1997  CG  LEU   268      29.246  47.899  -6.388  1.00 30.13           C  
ATOM   1998  CD1 LEU   268      29.144  46.464  -6.905  1.00 30.71           C  
ATOM   1999  CD2 LEU   268      30.618  48.155  -5.758  1.00 30.78           C  
ATOM   2000  N   ASN   269      28.346  52.062  -8.794  1.00 36.54           N  
ATOM   2001  CA  ASN   269      28.369  52.782 -10.078  1.00 38.57           C  
ATOM   2002  C   ASN   269      29.384  53.929 -10.094  1.00 39.07           C  
ATOM   2003  O   ASN   269      30.600  53.710  -9.978  1.00 39.36           O  
ATOM   2004  CB  ASN   269      26.960  53.264 -10.476  1.00 39.59           C  
ATOM   2005  CG  ASN   269      26.201  53.925  -9.316  1.00 41.98           C  
ATOM   2006  OD1 ASN   269      26.802  54.562  -8.435  1.00 44.75           O  
ATOM   2007  ND2 ASN   269      24.873  53.793  -9.327  1.00 44.56           N  
END
