
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  156 ( 1224),  selected  156 , name 2rfl_H
# Molecule2: number of CA atoms  247 ( 1945),  selected  247 , name T0394.pdb
# PARAMETERS: 2rfl_H.T0394.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      N       1           -
LGA    -       -      L       2           -
LGA    -       -      Y       3           -
LGA    -       -      F       4           -
LGA    A     3_H      Q       5          4.573
LGA    S     4_H      S       6           #
LGA    F     5_H      A       7          5.016
LGA    P     6_H      R       8           #
LGA    T     7_H      F       9          1.243
LGA    R     8_H      A      10          0.962
LGA    V     9_H      L      11          0.839
LGA    Y    10_H      T      12          1.155
LGA    L    11_H      V      13          0.983
LGA    L    12_H      V      14          1.187
LGA    R    13_H      R      15          0.997
LGA    H    14_H      H      16          0.928
LGA    A    15_H      G      17          1.063
LGA    K    16_H      E      18          0.685
LGA    A    17_H      T      19          0.705
LGA    A    18_H      R      20          1.288
LGA    W    19_H      F      21          1.804
LGA    A    20_H      N      22           -
LGA    A    21_H      K      23           -
LGA    P    22_H      E      24           -
LGA    G    23_H      K      25           -
LGA    E    24_H      I      26           -
LGA    -       -      I      27           -
LGA    -       -      Q      28           -
LGA    -       -      G      29           -
LGA    -       -      Q      30           -
LGA    R    25_H      G      31          4.733
LGA    D    26_H      V      32          2.179
LGA    F    27_H      D      33          1.784
LGA    D    28_H      -       -           -
LGA    R    29_H      E      34          0.242
LGA    G    30_H      P      35          0.955
LGA    L    31_H      L      36          0.249
LGA    N    32_H      S      37          1.079
LGA    E    33_H      E      38          1.324
LGA    A    34_H      T      39          1.177
LGA    G    35_H      G      40          1.019
LGA    F    36_H      F      41          0.974
LGA    A    37_H      K      42          0.692
LGA    E    38_H      Q      43          1.066
LGA    A    39_H      A      44          1.465
LGA    E    40_H      A      45          1.404
LGA    I    41_H      A      46          1.214
LGA    I    42_H      A      47          1.461
LGA    A    43_H      G      48          1.889
LGA    D    44_H      I      49          1.483
LGA    L    45_H      F      50          0.835
LGA    A    46_H      L      51          1.831
LGA    A    47_H      N      52          2.241
LGA    D    48_H      N      53          4.108
LGA    R    49_H      -       -           -
LGA    R    50_H      -       -           -
LGA    Y    51_H      V      54          3.276
LGA    R    52_H      K      55          3.153
LGA    P    53_H      F      56          2.217
LGA    D    54_H      T      57          1.308
LGA    L    55_H      H      58          1.283
LGA    I    56_H      A      59          1.331
LGA    L    57_H      F      60          1.398
LGA    S    58_H      S      61          0.757
LGA    S    59_H      S      62          0.795
LGA    T    60_H      D      63          1.067
LGA    A    61_H      L      64          0.878
LGA    A    62_H      M      65          0.652
LGA    R    63_H      R      66          0.457
LGA    C    64_H      T      67          0.566
LGA    R    65_H      K      68          0.715
LGA    Q    66_H      Q      69          0.518
LGA    T    67_H      T      70          0.379
LGA    T    68_H      M      71          0.748
LGA    Q    69_H      H      72          0.258
LGA    A    70_H      G      73          0.605
LGA    W    71_H      I      74          1.440
LGA    Q    72_H      L      75          1.641
LGA    R    73_H      E      76          0.853
LGA    A    74_H      R      77          1.911
LGA    F    75_H      S      78          1.621
LGA    -       -      K      79           -
LGA    -       -      F      80           -
LGA    -       -      C      81           -
LGA    -       -      K      82           -
LGA    -       -      D      83           -
LGA    I    79_H      M      84          1.746
LGA    D    80_H      T      85          2.979
LGA    I    81_H      V      86          1.019
LGA    V    82_H      K      87          0.661
LGA    Y    83_H      Y      88          0.752
LGA    I    84_H      D      89          1.869
LGA    D    85_H      S      90          2.739
LGA    E    86_H      R      91          3.669
LGA    X    87_H      L      92          2.431
LGA    Y    88_H      R      93          2.136
LGA    N    89_H      E      94          3.605
LGA    A    90_H      R      95          4.851
LGA    -       -      K      96           -
LGA    -       -      Y      97           -
LGA    -       -      G      98           -
LGA    -       -      V      99           -
LGA    -       -      V     100           -
LGA    -       -      E     101           -
LGA    -       -      G     102           -
LGA    -       -      K     103           -
LGA    -       -      A     104           -
LGA    -       -      L     105           -
LGA    -       -      S     106           -
LGA    -       -      E     107           -
LGA    -       -      L     108           -
LGA    -       -      R     109           -
LGA    -       -      A     110           -
LGA    -       -      M     111           -
LGA    -       -      A     112           -
LGA    -       -      K     113           -
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    -       -      R     116           -
LGA    -       -      E     117           -
LGA    -       -      E     118           -
LGA    -       -      C     119           -
LGA    -       -      P     120           -
LGA    -       -      V     121           -
LGA    -       -      F     122           -
LGA    -       -      T     123           -
LGA    -       -      P     124           -
LGA    -       -      P     125           -
LGA    -       -      G     126           -
LGA    -       -      G     127           -
LGA    -       -      E     128           -
LGA    -       -      T     129           -
LGA    -       -      L     130           -
LGA    -       -      D     131           -
LGA    R    91_H      Q     132          4.361
LGA    S    92_H      V     133          3.136
LGA    E    93_H      K     134          1.465
LGA    T    94_H      M     135           #
LGA    -       -      R     136           -
LGA    Y    95_H      G     137          2.076
LGA    L    96_H      I     138          3.548
LGA    S    97_H      D     139          2.871
LGA    L    98_H      F     140          1.745
LGA    I    99_H      F     141          2.904
LGA    A   100_H      E     142          2.915
LGA    A   101_H      F     143          2.015
LGA    Q   102_H      L     144          3.109
LGA    -       -      C     145           -
LGA    -       -      Q     146           -
LGA    -       -      L     147           -
LGA    T   103_H      I     148          3.141
LGA    E   104_H      L     149          3.199
LGA    V   105_H      K     150           #
LGA    -       -      E     151           -
LGA    -       -      A     152           -
LGA    -       -      D     153           -
LGA    -       -      Q     154           -
LGA    -       -      K     155           -
LGA    -       -      N     165           -
LGA    -       -      C     166           -
LGA    -       -      L     167           -
LGA    -       -      E     168           -
LGA    -       -      T     169           -
LGA    -       -      S     170           -
LGA    -       -      L     171           -
LGA    -       -      A     172           -
LGA    -       -      E     173           -
LGA    -       -      I     174           -
LGA    -       -      F     175           -
LGA    -       -      P     176           -
LGA    -       -      L     177           -
LGA    -       -      I     191           -
LGA    -       -      P     192           -
LGA    -       -      G     193           -
LGA    -       -      L     194           -
LGA    Q   106_H      A     195          3.337
LGA    S   107_H      A     196          3.055
LGA    -       -      S     197           -
LGA    V   108_H      V     198          1.873
LGA    X   109_H      L     199          2.314
LGA    L   110_H      V     200          1.979
LGA    V   111_H      V     201          1.431
LGA    G   112_H      S     202          1.276
LGA    H   113_H      H     203          1.194
LGA    N   114_H      G     204          2.102
LGA    P   115_H      A     205          0.913
LGA    T   116_H      Y     206          0.991
LGA    X   117_H      M     207          0.747
LGA    E   118_H      R     208          1.453
LGA    A   119_H      S     209          1.672
LGA    T   120_H      L     210          1.243
LGA    L   121_H      F     211          1.838
LGA    E   122_H      D     212          2.699
LGA    A   123_H      Y     213          2.339
LGA    X   124_H      F     214          1.696
LGA    I   125_H      L     215          3.619
LGA    G   126_H      T     216          5.010
LGA    E   127_H      D     217           -
LGA    D   128_H      L     218           -
LGA    -       -      K     219           -
LGA    -       -      C     220           -
LGA    -       -      S     221           -
LGA    L   129_H      L     222          4.129
LGA    -       -      P     223           -
LGA    -       -      A     224           -
LGA    -       -      T     225           -
LGA    -       -      L     226           -
LGA    L   130_H      S     227          4.834
LGA    H   131_H      R     228          3.395
LGA    A   132_H      S     229           #
LGA    A   133_H      E     230           #
LGA    L   134_H      -       -           -
LGA    P   135_H      -       -           -
LGA    S   136_H      L     231           #
LGA    -       -      M     232           -
LGA    -       -      S     233           -
LGA    G   137_H      V     234          1.114
LGA    F   138_H      T     235          1.688
LGA    P   139_H      P     236          1.314
LGA    T   140_H      N     237          1.112
LGA    S   141_H      T     238          0.515
LGA    G   142_H      G     239          0.901
LGA    L   143_H      M     240          1.068
LGA    A   144_H      S     241          0.821
LGA    V   145_H      L     242          1.130
LGA    L   146_H      F     243          1.076
LGA    D   147_H      I     244          1.146
LGA    Q   148_H      I     245          3.440
LGA    D   149_H      N     246           #
LGA    K   156_H      F     247           -
LGA    N   157_H      E     248           #
LGA    -       -      E     249           -
LGA    -       -      G     250           -
LGA    -       -      R     251           -
LGA    -       -      E     252           -
LGA    -       -      V     253           -
LGA    -       -      K     254           -
LGA    -       -      P     255           -
LGA    R   158_H      T     256          2.191
LGA    W   159_H      V     257          1.125
LGA    R   160_H      Q     258          1.044
LGA    L   161_H      C     259          1.730
LGA    I   162_H      I     260          1.811
LGA    D   163_H      C     261          3.229
LGA    F   164_H      M     262          4.191
LGA    -       -      N     263           -
LGA    L   165_H      L     264          2.679
LGA    A   166_H      Q     265          1.458
LGA    -       -      D     266           -
LGA    -       -      H     267           -
LGA    P   167_H      L     268          3.116
LGA    -       -      N     269           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  156  247    5.0    134    2.17    15.67     40.499     5.894

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.304848 * X  +   0.824286 * Y  +   0.477095 * Z  + -39.279480
  Y_new =   0.027121 * X  +  -0.493223 * Y  +   0.869480 * Z  +  35.537270
  Z_new =   0.952015 * X  +   0.277999 * Y  +   0.128002 * Z  +  23.367615 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.139293   -2.002300  [ DEG:    65.2767   -114.7233 ]
  Theta =  -1.259753   -1.881840  [ DEG:   -72.1785   -107.8215 ]
  Phi   =   3.052860   -0.088733  [ DEG:   174.9160     -5.0840 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rfl_H                                        
REMARK     2: T0394.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rfl_H.T0394.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  156  247   5.0  134   2.17   15.67  40.499
REMARK  ---------------------------------------------------------- 
MOLECULE 2rfl_H
HEADER    HYDROLASE, ISOMERASE                    01-OCT-07   2RFL              
TITLE     CRYSTAL STRUCTURE OF THE PUTATIVE PHOSPHOHISTIDINE                    
TITLE    2 PHOSPHATASE SIXA FROM AGROBACTERIUM TUMEFACIENS                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE PHOSPHOHISTIDINE PHOSPHATASE SIXA;                
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 SYNONYM: AGR_C_2511P, UNCHARACTERIZED PROTEIN ATU1358,               
COMPND   5 PHOSPHOGLYCERATE MUTASE;                                             
COMPND   6 EC: 5.4.2.1, 3.1.3.13, 5.4.2.4;                                      
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS STR. C58;             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C58;                                                         
SOURCE   5 ATCC: 33970;                                                         
SOURCE   6 GENE: AGR_C_2511, ATU1358;                                           
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ALPHA-BETA-ALPHA SANDWICH, STRUCTURAL GENOMICS, PSI-2,                
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG, HYDROLASE, ISOMERASE                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,T.BINKOWSKI,X.XU,A.M.EDWARDS,A.SAVCHENKO,A.JOACHIMIAK,          
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   23-OCT-07 2RFL    0                                                
JRNL        AUTH   Y.KIM,T.BINKOWSKI,X.XU,J.GU,Q.QUE,A.SAVCHENKO,               
JRNL        AUTH 2 A.M.EDWARDS,A.JOACHIMIAK                                     
JRNL        TITL   CRYSTAL STRUCTURE OF THE PUTATIVE PHOSPHOHISTIDINE           
JRNL        TITL 2 PHOSPHATASE SIXA FROM AGROBACTERIUM TUMEFACIENS.             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.35 ANGSTROMS.                                          
DBREF  2RFL A    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL B    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL C    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL D    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL E    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL F    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL G    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
DBREF  2RFL H    1   169  UNP    Q8UFN9   Q8UFN9_AGRT5     1    169             
SEQRES   1 A  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 A  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 A  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 A  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 A  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 A  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 A  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 A  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 A  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 A  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 A  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 A  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 A  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 A  173  GLY LYS GLY SER                                              
SEQRES   1 B  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 B  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 B  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 B  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 B  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 B  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 B  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 B  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 B  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 B  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 B  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 B  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 B  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 B  173  GLY LYS GLY SER                                              
SEQRES   1 C  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 C  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 C  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 C  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 C  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 C  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 C  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 C  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 C  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 C  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 C  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 C  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 C  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 C  173  GLY LYS GLY SER                                              
SEQRES   1 D  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 D  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 D  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 D  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 D  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 D  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 D  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 D  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 D  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 D  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 D  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 D  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 D  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 D  173  GLY LYS GLY SER                                              
SEQRES   1 E  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 E  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 E  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 E  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 E  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 E  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 E  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 E  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 E  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 E  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 E  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 E  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 E  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 E  173  GLY LYS GLY SER                                              
SEQRES   1 F  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 F  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 F  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 F  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 F  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 F  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 F  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 F  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 F  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 F  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 F  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 F  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 F  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 F  173  GLY LYS GLY SER                                              
SEQRES   1 G  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 G  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 G  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 G  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 G  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 G  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 G  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 G  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 G  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 G  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 G  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 G  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 G  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 G  173  GLY LYS GLY SER                                              
SEQRES   1 H  173  GLY HIS MSE THR ALA SER PHE PRO THR ARG VAL TYR LEU          
SEQRES   2 H  173  LEU ARG HIS ALA LYS ALA ALA TRP ALA ALA PRO GLY GLU          
SEQRES   3 H  173  ARG ASP PHE ASP ARG GLY LEU ASN GLU ALA GLY PHE ALA          
SEQRES   4 H  173  GLU ALA GLU ILE ILE ALA ASP LEU ALA ALA ASP ARG ARG          
SEQRES   5 H  173  TYR ARG PRO ASP LEU ILE LEU SER SER THR ALA ALA ARG          
SEQRES   6 H  173  CYS ARG GLN THR THR GLN ALA TRP GLN ARG ALA PHE ASN          
SEQRES   7 H  173  GLU GLY ILE ASP ILE VAL TYR ILE ASP GLU MSE TYR ASN          
SEQRES   8 H  173  ALA ARG SER GLU THR TYR LEU SER LEU ILE ALA ALA GLN          
SEQRES   9 H  173  THR GLU VAL GLN SER VAL MSE LEU VAL GLY HIS ASN PRO          
SEQRES  10 H  173  THR MSE GLU ALA THR LEU GLU ALA MSE ILE GLY GLU ASP          
SEQRES  11 H  173  LEU LEU HIS ALA ALA LEU PRO SER GLY PHE PRO THR SER          
SEQRES  12 H  173  GLY LEU ALA VAL LEU ASP GLN ASP ASP SER ALA ALA SER          
SEQRES  13 H  173  GLY LYS ASN ARG TRP ARG LEU ILE ASP PHE LEU ALA PRO          
SEQRES  14 H  173  GLY LYS GLY SER                                              
HET    MSE  A  87       8                                                       
HET    MSE  A 109       8                                                       
HET    MSE  A 117       8                                                       
HET    MSE  A 124       8                                                       
HET    MSE  B  87       8                                                       
HET    MSE  B 109       8                                                       
HET    MSE  B 117       8                                                       
HET    MSE  B 124       8                                                       
HET    MSE  C  87       8                                                       
HET    MSE  C 109       8                                                       
HET    MSE  C 117       8                                                       
HET    MSE  C 124       8                                                       
HET    MSE  D  87       8                                                       
HET    MSE  D 109       8                                                       
HET    MSE  D 117       8                                                       
HET    MSE  D 124       8                                                       
HET    MSE  E  87       8                                                       
HET    MSE  E 109       8                                                       
HET    MSE  E 117       8                                                       
HET    MSE  E 124       8                                                       
HET    MSE  F  87       8                                                       
HET    MSE  F 109       8                                                       
HET    MSE  F 117       8                                                       
HET    MSE  F 124       8                                                       
HET    MSE  G  87       8                                                       
HET    MSE  G 109       8                                                       
HET    MSE  G 117       8                                                       
HET    MSE  G 124       8                                                       
HET    MSE  H  87       8                                                       
HET    MSE  H 109       8                                                       
HET    MSE  H 117       8                                                       
HET    MSE  H 124       8                                                       
HET    SCN  A 172       3                                                       
HET    GOL  A 173       6                                                       
HET    GOL  G 172       6                                                       
HET    ACY  D 172       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SCN THIOCYANATE ION                                                  
HETNAM     GOL GLYCEROL                                                         
HETNAM     ACY ACETIC ACID                                                      
FORMUL   1  MSE    32(C5 H11 N O2 SE)                                           
FORMUL   9  SCN    C N S 1-                                                     
FORMUL  10  GOL    2(C3 H8 O3)                                                  
FORMUL  12  ACY    C2 H4 O2                                                     
FORMUL  13  HOH   *581(H2 O)                                                    
CRYST1   58.966  201.503   72.717  90.00 113.98  90.00 P 1 21 1     16          
ATOM   8513  N   ALA H   3       5.773  42.712  18.982  1.00 50.97           N  
ATOM   8514  CA  ALA H   3       5.466  41.410  18.358  1.00 50.51           C  
ATOM   8515  C   ALA H   3       6.691  40.429  18.315  1.00 50.38           C  
ATOM   8516  O   ALA H   3       6.772  39.496  19.149  1.00 51.83           O  
ATOM   8517  CB  ALA H   3       4.864  41.633  16.973  1.00 51.24           C  
ATOM   8518  N   SER H   4       7.594  40.615  17.345  0.50 47.29           N  
ATOM   8520  CA  SER H   4       8.841  39.854  17.267  0.50 44.67           C  
ATOM   8522  C   SER H   4      10.019  40.765  16.818  0.50 43.21           C  
ATOM   8524  O   SER H   4       9.829  41.728  16.092  0.50 41.31           O  
ATOM   8526  CB  SER H   4       8.646  38.547  16.430  0.50 45.17           C  
ATOM   8528  OG  SER H   4       9.442  38.427  15.250  0.50 39.49           O  
ATOM   8530  N   PHE H   5      11.188  40.471  17.373  1.00 42.66           N  
ATOM   8531  CA  PHE H   5      12.508  41.049  17.088  1.00 42.89           C  
ATOM   8532  C   PHE H   5      13.378  39.956  16.451  1.00 42.47           C  
ATOM   8533  O   PHE H   5      13.384  38.843  16.969  1.00 41.81           O  
ATOM   8534  CB  PHE H   5      13.163  41.392  18.427  1.00 43.40           C  
ATOM   8535  CG  PHE H   5      13.116  42.852  18.809  1.00 45.01           C  
ATOM   8536  CD1 PHE H   5      12.463  43.798  18.029  1.00 45.46           C  
ATOM   8537  CD2 PHE H   5      13.757  43.269  19.966  1.00 47.57           C  
ATOM   8538  CE1 PHE H   5      12.445  45.135  18.395  1.00 50.55           C  
ATOM   8539  CE2 PHE H   5      13.748  44.617  20.351  1.00 50.55           C  
ATOM   8540  CZ  PHE H   5      13.090  45.558  19.566  1.00 49.98           C  
ATOM   8541  N   PRO H   6      14.174  40.249  15.379  1.00 42.28           N  
ATOM   8542  CA  PRO H   6      14.589  41.458  14.644  1.00 42.04           C  
ATOM   8543  C   PRO H   6      13.528  42.131  13.842  1.00 41.69           C  
ATOM   8544  O   PRO H   6      12.854  41.515  13.027  1.00 40.16           O  
ATOM   8545  CB  PRO H   6      15.631  40.945  13.638  1.00 41.45           C  
ATOM   8546  CG  PRO H   6      16.054  39.643  14.164  1.00 43.05           C  
ATOM   8547  CD  PRO H   6      14.823  39.060  14.801  1.00 42.14           C  
ATOM   8548  N   THR H   7      13.448  43.430  14.009  0.50 41.64           N  
ATOM   8550  CA  THR H   7      12.471  44.164  13.261  0.50 42.22           C  
ATOM   8552  C   THR H   7      13.034  44.661  11.909  0.50 41.28           C  
ATOM   8554  O   THR H   7      12.303  45.115  11.027  0.50 40.18           O  
ATOM   8556  CB  THR H   7      11.781  45.185  14.188  0.50 42.82           C  
ATOM   8558  OG1 THR H   7      12.762  46.101  14.692  0.50 48.89           O  
ATOM   8560  CG2 THR H   7      11.040  44.554  15.254  0.50 39.82           C  
ATOM   8562  N   ARG H   8      14.354  44.517  11.770  1.00 40.12           N  
ATOM   8563  CA  ARG H   8      15.050  44.748  10.530  1.00 39.49           C  
ATOM   8564  C   ARG H   8      16.233  43.790  10.265  1.00 38.66           C  
ATOM   8565  O   ARG H   8      17.131  43.596  11.105  1.00 38.21           O  
ATOM   8566  CB  ARG H   8      15.555  46.186  10.431  1.00 40.18           C  
ATOM   8567  CG  ARG H   8      16.510  46.291   9.295  1.00 39.60           C  
ATOM   8568  CD  ARG H   8      16.729  47.660   8.897  1.00 40.30           C  
ATOM   8569  NE  ARG H   8      15.513  48.337   8.502  1.00 40.16           N  
ATOM   8570  CZ  ARG H   8      15.519  49.592   8.068  1.00 41.75           C  
ATOM   8571  NH1 ARG H   8      16.683  50.229   7.972  1.00 38.73           N  
ATOM   8572  NH2 ARG H   8      14.387  50.194   7.712  1.00 41.21           N  
ATOM   8573  N   VAL H   9      16.229  43.229   9.061  1.00 36.97           N  
ATOM   8574  CA  VAL H   9      17.255  42.299   8.638  1.00 34.58           C  
ATOM   8575  C   VAL H   9      18.079  42.895   7.513  1.00 34.14           C  
ATOM   8576  O   VAL H   9      17.560  43.514   6.585  1.00 34.44           O  
ATOM   8577  CB  VAL H   9      16.649  40.995   8.170  1.00 33.52           C  
ATOM   8578  CG1 VAL H   9      17.728  40.058   7.714  1.00 32.44           C  
ATOM   8579  CG2 VAL H   9      15.841  40.342   9.297  1.00 33.61           C  
ATOM   8580  N   TYR H  10      19.379  42.702   7.601  1.00 33.62           N  
ATOM   8581  CA  TYR H  10      20.236  43.011   6.498  1.00 32.71           C  
ATOM   8582  C   TYR H  10      20.820  41.704   6.026  1.00 32.14           C  
ATOM   8583  O   TYR H  10      21.265  40.880   6.865  1.00 31.60           O  
ATOM   8584  CB  TYR H  10      21.348  43.993   6.898  1.00 32.89           C  
ATOM   8585  CG  TYR H  10      20.917  45.342   7.458  1.00 32.63           C  
ATOM   8586  CD1 TYR H  10      21.089  45.632   8.803  1.00 33.71           C  
ATOM   8587  CD2 TYR H  10      20.415  46.350   6.631  1.00 33.00           C  
ATOM   8588  CE1 TYR H  10      20.743  46.856   9.337  1.00 31.73           C  
ATOM   8589  CE2 TYR H  10      20.037  47.559   7.157  1.00 33.49           C  
ATOM   8590  CZ  TYR H  10      20.204  47.808   8.520  1.00 33.12           C  
ATOM   8591  OH  TYR H  10      19.846  49.015   9.071  1.00 33.54           O  
ATOM   8592  N   LEU H  11      20.779  41.504   4.694  1.00 31.86           N  
ATOM   8593  CA  LEU H  11      21.456  40.372   3.997  1.00 31.34           C  
ATOM   8594  C   LEU H  11      22.622  40.891   3.122  1.00 32.42           C  
ATOM   8595  O   LEU H  11      22.416  41.702   2.244  1.00 32.05           O  
ATOM   8596  CB  LEU H  11      20.467  39.504   3.175  1.00 30.66           C  
ATOM   8597  CG  LEU H  11      19.132  39.007   3.765  1.00 28.15           C  
ATOM   8598  CD1 LEU H  11      18.487  37.961   2.910  1.00 30.60           C  
ATOM   8599  CD2 LEU H  11      19.306  38.391   5.076  1.00 26.87           C  
ATOM   8600  N   LEU H  12      23.847  40.429   3.371  1.00 32.75           N  
ATOM   8601  CA  LEU H  12      24.967  40.855   2.563  1.00 33.24           C  
ATOM   8602  C   LEU H  12      25.814  39.675   2.053  1.00 34.55           C  
ATOM   8603  O   LEU H  12      26.429  38.945   2.854  1.00 34.57           O  
ATOM   8604  CB  LEU H  12      25.848  41.911   3.309  1.00 32.64           C  
ATOM   8605  CG  LEU H  12      27.220  42.369   2.780  1.00 30.73           C  
ATOM   8606  CD1 LEU H  12      27.145  43.583   1.852  1.00 29.50           C  
ATOM   8607  CD2 LEU H  12      28.106  42.714   3.927  1.00 29.09           C  
ATOM   8608  N   ARG H  13      25.895  39.536   0.725  1.00 34.74           N  
ATOM   8609  CA  ARG H  13      26.802  38.575   0.140  1.00 36.22           C  
ATOM   8610  C   ARG H  13      28.253  39.120   0.035  1.00 38.18           C  
ATOM   8611  O   ARG H  13      28.490  40.272  -0.282  1.00 37.49           O  
ATOM   8612  CB  ARG H  13      26.265  38.077  -1.190  1.00 35.78           C  
ATOM   8613  CG  ARG H  13      26.999  36.863  -1.756  1.00 34.95           C  
ATOM   8614  CD  ARG H  13      27.102  37.081  -3.245  1.00 35.09           C  
ATOM   8615  NE  ARG H  13      27.857  36.062  -3.931  1.00 34.19           N  
ATOM   8616  CZ  ARG H  13      27.794  35.883  -5.239  1.00 34.43           C  
ATOM   8617  NH1 ARG H  13      27.006  36.677  -5.961  1.00 32.91           N  
ATOM   8618  NH2 ARG H  13      28.520  34.930  -5.823  1.00 33.37           N  
ATOM   8619  N   HIS H  14      29.230  38.288   0.351  1.00 40.58           N  
ATOM   8620  CA  HIS H  14      30.578  38.735   0.268  1.00 42.43           C  
ATOM   8621  C   HIS H  14      30.799  39.496  -1.066  1.00 45.10           C  
ATOM   8622  O   HIS H  14      30.086  39.290  -2.036  1.00 43.74           O  
ATOM   8623  CB  HIS H  14      31.492  37.536   0.429  1.00 41.60           C  
ATOM   8624  CG  HIS H  14      31.528  36.648  -0.771  1.00 38.22           C  
ATOM   8625  ND1 HIS H  14      32.336  36.897  -1.860  1.00 34.37           N  
ATOM   8626  CD2 HIS H  14      30.853  35.517  -1.058  1.00 35.51           C  
ATOM   8627  CE1 HIS H  14      32.154  35.957  -2.767  1.00 33.17           C  
ATOM   8628  NE2 HIS H  14      31.278  35.091  -2.292  1.00 33.82           N  
ATOM   8629  N   ALA H  15      31.773  40.414  -1.071  1.00 48.89           N  
ATOM   8630  CA  ALA H  15      32.240  41.106  -2.285  1.00 51.74           C  
ATOM   8631  C   ALA H  15      33.101  40.132  -3.061  1.00 53.76           C  
ATOM   8632  O   ALA H  15      33.490  39.102  -2.527  1.00 53.40           O  
ATOM   8633  CB  ALA H  15      33.025  42.331  -1.923  1.00 51.01           C  
ATOM   8634  N   LYS H  16      33.364  40.436  -4.327  1.00 56.48           N  
ATOM   8635  CA  LYS H  16      34.209  39.589  -5.168  1.00 59.86           C  
ATOM   8636  C   LYS H  16      35.532  39.164  -4.513  1.00 60.48           C  
ATOM   8637  O   LYS H  16      36.108  39.870  -3.679  1.00 60.20           O  
ATOM   8638  CB  LYS H  16      34.483  40.245  -6.540  0.20 60.89           C  
ATOM   8639  CG  LYS H  16      33.278  40.146  -7.502  0.20 65.10           C  
ATOM   8640  CD  LYS H  16      33.672  40.163  -8.995  0.20 67.33           C  
ATOM   8641  CE  LYS H  16      32.419  40.204  -9.855  0.20 69.20           C  
ATOM   8642  NZ  LYS H  16      32.715  40.660 -11.230  0.20 70.90           N  
ATOM   8643  N   ALA H  17      35.993  37.998  -4.939  1.00 61.43           N  
ATOM   8644  CA  ALA H  17      37.158  37.352  -4.425  1.00 62.10           C  
ATOM   8645  C   ALA H  17      38.087  37.117  -5.586  1.00 63.43           C  
ATOM   8646  O   ALA H  17      37.645  37.034  -6.737  1.00 62.91           O  
ATOM   8647  CB  ALA H  17      36.753  36.024  -3.846  1.00 62.21           C  
ATOM   8648  N   ALA H  18      39.380  36.993  -5.293  1.00 65.07           N  
ATOM   8649  CA  ALA H  18      40.286  36.356  -6.240  1.00 67.26           C  
ATOM   8650  C   ALA H  18      39.780  34.917  -6.383  1.00 69.36           C  
ATOM   8651  O   ALA H  18      39.151  34.377  -5.473  1.00 68.83           O  
ATOM   8652  CB  ALA H  18      41.708  36.381  -5.729  1.00 66.63           C  
ATOM   8653  N   TRP H  19      40.012  34.302  -7.533  1.00 72.55           N  
ATOM   8654  CA  TRP H  19      39.731  32.882  -7.668  1.00 75.79           C  
ATOM   8655  C   TRP H  19      40.911  32.143  -7.033  1.00 76.30           C  
ATOM   8656  O   TRP H  19      42.041  32.622  -7.093  1.00 76.06           O  
ATOM   8657  CB  TRP H  19      39.530  32.513  -9.145  0.20 77.45           C  
ATOM   8658  CG  TRP H  19      38.299  33.147  -9.734  1.00 82.03           C  
ATOM   8659  CD1 TRP H  19      38.221  34.369 -10.320  1.00 84.62           C  
ATOM   8660  CD2 TRP H  19      36.968  32.600  -9.769  0.20 88.05           C  
ATOM   8661  NE1 TRP H  19      36.936  34.627 -10.727  1.00 86.90           N  
ATOM   8662  CE2 TRP H  19      36.142  33.560 -10.403  0.20 88.71           C  
ATOM   8663  CE3 TRP H  19      36.394  31.394  -9.326  0.20 90.36           C  
ATOM   8664  CZ2 TRP H  19      34.768  33.355 -10.610  0.20 90.95           C  
ATOM   8665  CZ3 TRP H  19      35.027  31.188  -9.533  0.20 92.11           C  
ATOM   8666  CH2 TRP H  19      34.230  32.168 -10.171  0.20 92.47           C  
ATOM   8667  N   ALA H  20      40.650  31.006  -6.392  1.00 77.29           N  
ATOM   8668  CA  ALA H  20      41.711  30.271  -5.681  1.00 78.73           C  
ATOM   8669  C   ALA H  20      43.002  30.115  -6.499  1.00 79.88           C  
ATOM   8670  O   ALA H  20      42.962  29.949  -7.712  1.00 79.55           O  
ATOM   8671  CB  ALA H  20      41.202  28.904  -5.227  1.00 78.70           C  
ATOM   8672  N   ALA H  21      44.140  30.175  -5.824  1.00 81.79           N  
ATOM   8673  CA  ALA H  21      45.408  29.846  -6.449  1.00 84.55           C  
ATOM   8674  C   ALA H  21      45.541  28.325  -6.542  1.00 86.74           C  
ATOM   8675  O   ALA H  21      44.746  27.614  -5.935  1.00 86.36           O  
ATOM   8676  CB  ALA H  21      46.558  30.450  -5.654  1.00 84.75           C  
ATOM   8677  N   PRO H  22      46.536  27.819  -7.310  1.00 89.18           N  
ATOM   8678  CA  PRO H  22      46.779  26.375  -7.270  1.00 91.07           C  
ATOM   8679  C   PRO H  22      47.276  26.012  -5.885  1.00 92.05           C  
ATOM   8680  O   PRO H  22      48.292  26.539  -5.436  1.00 91.98           O  
ATOM   8681  CB  PRO H  22      47.894  26.158  -8.296  1.00 91.78           C  
ATOM   8682  CG  PRO H  22      48.029  27.448  -9.052  1.00 91.14           C  
ATOM   8683  CD  PRO H  22      47.475  28.526  -8.203  1.00 89.45           C  
ATOM   8684  N   GLY H  23      46.536  25.155  -5.193  1.00 92.89           N  
ATOM   8685  CA  GLY H  23      46.866  24.808  -3.807  0.20 93.44           C  
ATOM   8686  C   GLY H  23      45.988  25.457  -2.748  1.00 92.38           C  
ATOM   8687  O   GLY H  23      45.448  24.759  -1.883  0.20 93.15           O  
ATOM   8688  N   GLU H  24      45.866  26.783  -2.792  0.50 91.02           N  
ATOM   8690  CA  GLU H  24      45.062  27.514  -1.804  0.50 89.01           C  
ATOM   8692  C   GLU H  24      43.620  27.010  -1.763  0.50 86.57           C  
ATOM   8694  O   GLU H  24      43.018  26.718  -2.797  0.50 86.61           O  
ATOM   8696  CB  GLU H  24      45.112  29.042  -2.033  0.50 89.17           C  
ATOM   8698  CG  GLU H  24      44.051  29.840  -1.240  0.50 88.23           C  
ATOM   8700  CD  GLU H  24      44.444  31.284  -0.952  0.50 86.97           C  
ATOM   8702  OE1 GLU H  24      43.879  32.247  -1.722  0.50 85.25           O  
ATOM   8704  OE2 GLU H  24      45.312  31.459   0.056  0.50 87.25           O  
ATOM   8706  N   ARG H  25      43.091  26.904  -0.550  1.00 83.86           N  
ATOM   8707  CA  ARG H  25      41.721  26.452  -0.309  1.00 77.67           C  
ATOM   8708  C   ARG H  25      40.745  27.586  -0.640  1.00 72.02           C  
ATOM   8709  O   ARG H  25      41.023  28.742  -0.340  1.00 70.36           O  
ATOM   8710  CB  ARG H  25      41.530  26.018   1.147  1.00 77.72           C  
ATOM   8711  CG  ARG H  25      42.372  24.835   1.624  1.00 76.15           C  
ATOM   8712  CD  ARG H  25      42.135  24.560   3.108  1.00 73.52           C  
ATOM   8713  NE  ARG H  25      42.321  25.741   3.965  1.00 71.29           N  
ATOM   8714  CZ  ARG H  25      41.652  25.976   5.102  1.00 69.20           C  
ATOM   8715  NH1 ARG H  25      40.734  25.127   5.546  1.00 65.02           N  
ATOM   8716  NH2 ARG H  25      41.903  27.075   5.808  1.00 68.16           N  
ATOM   8717  N   ASP H  26      39.610  27.249  -1.256  1.00 66.00           N  
ATOM   8718  CA  ASP H  26      38.524  28.206  -1.497  1.00 60.11           C  
ATOM   8719  C   ASP H  26      38.139  28.970  -0.200  1.00 57.71           C  
ATOM   8720  O   ASP H  26      37.780  30.138  -0.251  1.00 56.18           O  
ATOM   8721  CB  ASP H  26      37.324  27.490  -2.166  1.00 58.91           C  
ATOM   8722  CG  ASP H  26      36.079  28.363  -2.278  1.00 53.99           C  
ATOM   8723  OD1 ASP H  26      35.798  28.826  -3.381  1.00 51.97           O  
ATOM   8724  OD2 ASP H  26      35.363  28.596  -1.281  1.00 44.53           O  
ATOM   8725  N   PHE H  27      38.241  28.314   0.955  1.00 55.81           N  
ATOM   8726  CA  PHE H  27      37.969  28.972   2.238  1.00 54.10           C  
ATOM   8727  C   PHE H  27      38.920  30.166   2.480  1.00 53.80           C  
ATOM   8728  O   PHE H  27      38.479  31.248   2.880  1.00 52.55           O  
ATOM   8729  CB  PHE H  27      38.023  27.961   3.399  1.00 53.61           C  
ATOM   8730  CG  PHE H  27      37.901  28.591   4.757  1.00 50.48           C  
ATOM   8731  CD1 PHE H  27      36.658  28.930   5.272  1.00 47.61           C  
ATOM   8732  CD2 PHE H  27      39.038  28.869   5.519  1.00 50.99           C  
ATOM   8733  CE1 PHE H  27      36.528  29.513   6.535  1.00 45.45           C  
ATOM   8734  CE2 PHE H  27      38.926  29.478   6.789  1.00 49.90           C  
ATOM   8735  CZ  PHE H  27      37.654  29.796   7.290  1.00 47.56           C  
ATOM   8736  N   ASP H  28      40.209  29.946   2.209  1.00 53.41           N  
ATOM   8737  CA  ASP H  28      41.273  30.937   2.384  1.00 53.45           C  
ATOM   8738  C   ASP H  28      41.335  32.036   1.339  1.00 53.54           C  
ATOM   8739  O   ASP H  28      42.230  32.868   1.360  1.00 53.03           O  
ATOM   8740  CB  ASP H  28      42.621  30.231   2.425  1.00 53.15           C  
ATOM   8741  CG  ASP H  28      42.928  29.714   3.770  1.00 50.54           C  
ATOM   8742  OD1 ASP H  28      42.039  29.784   4.616  1.00 48.36           O  
ATOM   8743  OD2 ASP H  28      44.051  29.269   4.005  1.00 50.02           O  
ATOM   8744  N   ARG H  29      40.355  32.031   0.449  1.00 54.09           N  
ATOM   8745  CA  ARG H  29      40.301  32.914  -0.697  1.00 54.41           C  
ATOM   8746  C   ARG H  29      40.093  34.371  -0.295  1.00 53.73           C  
ATOM   8747  O   ARG H  29      39.108  34.751   0.331  1.00 52.78           O  
ATOM   8748  CB  ARG H  29      39.158  32.462  -1.586  1.00 54.97           C  
ATOM   8749  CG  ARG H  29      39.410  32.515  -3.054  1.00 55.23           C  
ATOM   8750  CD  ARG H  29      38.502  31.476  -3.692  1.00 56.60           C  
ATOM   8751  NE  ARG H  29      37.823  32.012  -4.852  1.00 57.51           N  
ATOM   8752  CZ  ARG H  29      36.529  32.285  -4.894  1.00 56.36           C  
ATOM   8753  NH1 ARG H  29      35.788  32.026  -3.834  1.00 61.80           N  
ATOM   8754  NH2 ARG H  29      35.968  32.779  -5.992  1.00 52.00           N  
ATOM   8755  N   GLY H  30      41.051  35.189  -0.670  1.00 53.64           N  
ATOM   8756  CA  GLY H  30      40.975  36.591  -0.387  1.00 52.98           C  
ATOM   8757  C   GLY H  30      39.993  37.306  -1.274  1.00 52.22           C  
ATOM   8758  O   GLY H  30      39.612  36.838  -2.354  1.00 51.50           O  
ATOM   8759  N   LEU H  31      39.600  38.467  -0.793  1.00 51.95           N  
ATOM   8760  CA  LEU H  31      38.961  39.467  -1.602  1.00 51.76           C  
ATOM   8761  C   LEU H  31      39.974  40.018  -2.618  1.00 53.80           C  
ATOM   8762  O   LEU H  31      41.203  39.837  -2.494  1.00 52.03           O  
ATOM   8763  CB  LEU H  31      38.447  40.569  -0.670  1.00 50.59           C  
ATOM   8764  CG  LEU H  31      37.000  41.030  -0.735  1.00 46.11           C  
ATOM   8765  CD1 LEU H  31      36.058  39.869  -0.529  1.00 40.44           C  
ATOM   8766  CD2 LEU H  31      36.790  42.091   0.260  1.00 38.95           C  
ATOM   8767  N   ASN H  32      39.409  40.663  -3.630  1.00 56.35           N  
ATOM   8768  CA  ASN H  32      40.096  41.307  -4.728  1.00 58.81           C  
ATOM   8769  C   ASN H  32      40.112  42.811  -4.585  1.00 60.47           C  
ATOM   8770  O   ASN H  32      39.348  43.376  -3.816  1.00 58.33           O  
ATOM   8771  CB  ASN H  32      39.315  41.033  -6.018  1.00 58.91           C  
ATOM   8772  CG  ASN H  32      39.979  40.019  -6.933  1.00 58.48           C  
ATOM   8773  OD1 ASN H  32      39.386  39.621  -7.936  1.00 58.50           O  
ATOM   8774  ND2 ASN H  32      41.184  39.595  -6.600  1.00 53.20           N  
ATOM   8775  N   GLU H  33      40.987  43.436  -5.397  1.00 64.08           N  
ATOM   8776  CA  GLU H  33      40.983  44.877  -5.748  1.00 65.34           C  
ATOM   8777  C   GLU H  33      39.568  45.344  -6.103  1.00 65.31           C  
ATOM   8778  O   GLU H  33      38.965  46.135  -5.373  1.00 65.03           O  
ATOM   8779  CB  GLU H  33      41.912  45.112  -6.932  1.00 65.88           C  
ATOM   8780  CG  GLU H  33      42.254  46.558  -7.244  1.00 66.79           C  
ATOM   8781  CD  GLU H  33      43.553  46.654  -8.031  1.00 68.65           C  
ATOM   8782  OE1 GLU H  33      44.235  47.708  -7.995  1.00 69.30           O  
ATOM   8783  OE2 GLU H  33      43.913  45.647  -8.675  1.00 68.26           O  
ATOM   8784  N   ALA H  34      39.035  44.840  -7.215  1.00 64.87           N  
ATOM   8785  CA  ALA H  34      37.633  45.080  -7.532  1.00 63.81           C  
ATOM   8786  C   ALA H  34      36.761  44.820  -6.289  1.00 62.75           C  
ATOM   8787  O   ALA H  34      35.962  45.668  -5.919  1.00 62.20           O  
ATOM   8788  CB  ALA H  34      37.191  44.234  -8.708  1.00 63.89           C  
ATOM   8789  N   GLY H  35      36.965  43.680  -5.626  1.00 61.28           N  
ATOM   8790  CA  GLY H  35      36.137  43.278  -4.486  1.00 59.58           C  
ATOM   8791  C   GLY H  35      36.338  44.210  -3.302  1.00 58.54           C  
ATOM   8792  O   GLY H  35      35.376  44.538  -2.593  1.00 57.44           O  
ATOM   8793  N   PHE H  36      37.582  44.658  -3.108  1.00 57.04           N  
ATOM   8794  CA  PHE H  36      37.888  45.590  -2.014  1.00 56.27           C  
ATOM   8795  C   PHE H  36      37.234  46.932  -2.229  1.00 55.77           C  
ATOM   8796  O   PHE H  36      36.587  47.462  -1.350  1.00 55.61           O  
ATOM   8797  CB  PHE H  36      39.383  45.812  -1.835  1.00 55.33           C  
ATOM   8798  CG  PHE H  36      40.117  44.656  -1.233  1.00 54.99           C  
ATOM   8799  CD1 PHE H  36      39.919  44.303   0.102  1.00 55.55           C  
ATOM   8800  CD2 PHE H  36      41.058  43.947  -1.989  1.00 54.80           C  
ATOM   8801  CE1 PHE H  36      40.626  43.235   0.665  1.00 55.60           C  
ATOM   8802  CE2 PHE H  36      41.760  42.873  -1.443  1.00 55.09           C  
ATOM   8803  CZ  PHE H  36      41.542  42.514  -0.114  1.00 55.03           C  
ATOM   8804  N   ALA H  37      37.405  47.478  -3.419  1.00 56.09           N  
ATOM   8805  CA  ALA H  37      36.854  48.769  -3.732  1.00 55.96           C  
ATOM   8806  C   ALA H  37      35.345  48.701  -3.636  1.00 55.03           C  
ATOM   8807  O   ALA H  37      34.732  49.484  -2.939  1.00 53.46           O  
ATOM   8808  CB  ALA H  37      37.304  49.200  -5.116  1.00 57.11           C  
ATOM   8809  N   GLU H  38      34.772  47.701  -4.293  1.00 55.38           N  
ATOM   8810  CA  GLU H  38      33.329  47.450  -4.299  1.00 54.96           C  
ATOM   8811  C   GLU H  38      32.631  47.303  -2.927  1.00 54.81           C  
ATOM   8812  O   GLU H  38      31.510  47.750  -2.757  1.00 53.50           O  
ATOM   8813  CB  GLU H  38      33.008  46.266  -5.200  1.00 55.20           C  
ATOM   8814  CG  GLU H  38      33.052  46.578  -6.688  1.00 55.17           C  
ATOM   8815  CD  GLU H  38      32.310  45.536  -7.539  1.00 56.46           C  
ATOM   8816  OE1 GLU H  38      31.618  44.672  -6.925  1.00 53.74           O  
ATOM   8817  OE2 GLU H  38      32.420  45.605  -8.807  1.00 54.39           O  
ATOM   8818  N   ALA H  39      33.296  46.692  -1.958  1.00 55.34           N  
ATOM   8819  CA  ALA H  39      32.695  46.495  -0.622  1.00 56.08           C  
ATOM   8820  C   ALA H  39      32.687  47.764   0.238  1.00 55.90           C  
ATOM   8821  O   ALA H  39      31.896  47.896   1.174  1.00 54.76           O  
ATOM   8822  CB  ALA H  39      33.404  45.365   0.116  1.00 56.74           C  
ATOM   8823  N   GLU H  40      33.593  48.680  -0.098  1.00 56.14           N  
ATOM   8824  CA  GLU H  40      33.720  49.976   0.530  1.00 55.89           C  
ATOM   8825  C   GLU H  40      32.601  50.918   0.069  1.00 54.99           C  
ATOM   8826  O   GLU H  40      31.978  51.580   0.887  1.00 54.71           O  
ATOM   8827  CB  GLU H  40      35.101  50.540   0.194  1.00 56.95           C  
ATOM   8828  CG  GLU H  40      35.435  51.871   0.848  1.00 58.91           C  
ATOM   8829  CD  GLU H  40      36.903  52.141   0.859  1.00 59.37           C  
ATOM   8830  OE1 GLU H  40      37.501  52.173  -0.231  1.00 60.86           O  
ATOM   8831  OE2 GLU H  40      37.457  52.321   1.958  1.00 59.56           O  
ATOM   8832  N   ILE H  41      32.354  50.973  -1.237  1.00 54.09           N  
ATOM   8833  CA  ILE H  41      31.245  51.750  -1.805  1.00 53.37           C  
ATOM   8834  C   ILE H  41      29.882  51.313  -1.198  1.00 52.10           C  
ATOM   8835  O   ILE H  41      29.045  52.143  -0.869  1.00 51.42           O  
ATOM   8836  CB  ILE H  41      31.277  51.744  -3.390  1.00 53.87           C  
ATOM   8837  CG1 ILE H  41      32.217  52.819  -3.955  1.00 54.43           C  
ATOM   8838  CG2 ILE H  41      29.911  52.056  -4.005  1.00 55.08           C  
ATOM   8839  CD1 ILE H  41      33.702  52.460  -3.971  1.00 57.13           C  
ATOM   8840  N   ILE H  42      29.687  50.015  -1.003  1.00 51.15           N  
ATOM   8841  CA  ILE H  42      28.498  49.524  -0.295  1.00 50.24           C  
ATOM   8842  C   ILE H  42      28.518  49.849   1.208  1.00 49.70           C  
ATOM   8843  O   ILE H  42      27.551  50.363   1.748  1.00 48.51           O  
ATOM   8844  CB  ILE H  42      28.247  48.041  -0.562  1.00 49.88           C  
ATOM   8845  CG1 ILE H  42      28.232  47.762  -2.057  1.00 49.47           C  
ATOM   8846  CG2 ILE H  42      26.877  47.602  -0.007  1.00 52.70           C  
ATOM   8847  CD1 ILE H  42      27.090  48.470  -2.796  1.00 53.51           C  
ATOM   8848  N   ALA H  43      29.621  49.576   1.884  1.00 50.35           N  
ATOM   8849  CA  ALA H  43      29.684  49.911   3.293  1.00 52.11           C  
ATOM   8850  C   ALA H  43      29.345  51.386   3.527  1.00 53.36           C  
ATOM   8851  O   ALA H  43      28.385  51.670   4.222  1.00 53.85           O  
ATOM   8852  CB  ALA H  43      31.025  49.501   3.926  1.00 52.03           C  
ATOM   8853  N   ASP H  44      30.076  52.313   2.901  1.00 55.07           N  
ATOM   8854  CA  ASP H  44      29.795  53.756   3.016  1.00 56.60           C  
ATOM   8855  C   ASP H  44      28.420  54.259   2.489  1.00 56.38           C  
ATOM   8856  O   ASP H  44      27.760  55.085   3.100  1.00 55.07           O  
ATOM   8857  CB  ASP H  44      30.995  54.567   2.500  1.00 57.21           C  
ATOM   8858  CG  ASP H  44      32.159  54.594   3.509  1.00 60.50           C  
ATOM   8859  OD1 ASP H  44      31.916  54.581   4.741  1.00 62.82           O  
ATOM   8860  OD2 ASP H  44      33.335  54.639   3.081  1.00 64.79           O  
ATOM   8861  N   LEU H  45      27.966  53.722   1.381  1.00 57.57           N  
ATOM   8862  CA  LEU H  45      26.608  53.996   0.931  1.00 59.61           C  
ATOM   8863  C   LEU H  45      25.580  53.630   2.039  1.00 60.44           C  
ATOM   8864  O   LEU H  45      24.580  54.343   2.294  1.00 59.98           O  
ATOM   8865  CB  LEU H  45      26.367  53.229  -0.378  1.00 59.22           C  
ATOM   8866  CG  LEU H  45      25.150  53.292  -1.298  1.00 59.69           C  
ATOM   8867  CD1 LEU H  45      24.798  54.695  -1.751  1.00 63.01           C  
ATOM   8868  CD2 LEU H  45      25.442  52.422  -2.496  1.00 58.87           C  
ATOM   8869  N   ALA H  46      25.849  52.523   2.720  1.00 61.62           N  
ATOM   8870  CA  ALA H  46      24.962  52.079   3.783  1.00 62.70           C  
ATOM   8871  C   ALA H  46      25.055  52.978   5.014  1.00 63.30           C  
ATOM   8872  O   ALA H  46      24.063  53.146   5.715  1.00 63.52           O  
ATOM   8873  CB  ALA H  46      25.211  50.620   4.134  1.00 62.76           C  
ATOM   8874  N   ALA H  47      26.228  53.566   5.260  1.00 63.61           N  
ATOM   8875  CA  ALA H  47      26.416  54.447   6.411  1.00 64.59           C  
ATOM   8876  C   ALA H  47      25.788  55.808   6.169  1.00 65.19           C  
ATOM   8877  O   ALA H  47      25.308  56.451   7.094  1.00 65.14           O  
ATOM   8878  CB  ALA H  47      27.887  54.565   6.789  1.00 64.08           C  
ATOM   8879  N   ASP H  48      25.777  56.232   4.911  1.00 66.31           N  
ATOM   8880  CA  ASP H  48      24.936  57.349   4.470  1.00 67.12           C  
ATOM   8881  C   ASP H  48      23.469  57.171   4.835  1.00 67.05           C  
ATOM   8882  O   ASP H  48      22.830  58.117   5.287  1.00 67.42           O  
ATOM   8883  CB  ASP H  48      25.019  57.524   2.961  1.00 67.17           C  
ATOM   8884  CG  ASP H  48      26.385  57.936   2.501  1.00 67.32           C  
ATOM   8885  OD1 ASP H  48      27.199  58.373   3.352  1.00 67.36           O  
ATOM   8886  OD2 ASP H  48      26.635  57.830   1.281  1.00 65.75           O  
ATOM   8887  N   ARG H  49      22.928  55.974   4.611  1.00 66.27           N  
ATOM   8888  CA  ARG H  49      21.509  55.739   4.874  1.00 65.47           C  
ATOM   8889  C   ARG H  49      21.269  55.336   6.309  1.00 63.76           C  
ATOM   8890  O   ARG H  49      20.129  55.199   6.743  1.00 62.90           O  
ATOM   8891  CB  ARG H  49      20.903  54.754   3.875  1.00 65.57           C  
ATOM   8892  CG  ARG H  49      20.586  55.398   2.530  1.00 67.12           C  
ATOM   8893  CD  ARG H  49      20.759  54.407   1.390  1.00 69.21           C  
ATOM   8894  NE  ARG H  49      21.087  55.090   0.144  1.00 71.30           N  
ATOM   8895  CZ  ARG H  49      20.403  54.981  -0.991  1.00 71.56           C  
ATOM   8896  NH1 ARG H  49      19.338  54.195  -1.068  1.00 69.20           N  
ATOM   8897  NH2 ARG H  49      20.798  55.664  -2.057  1.00 71.72           N  
ATOM   8898  N   ARG H  50      22.370  55.195   7.043  1.00 62.24           N  
ATOM   8899  CA  ARG H  50      22.352  54.862   8.466  1.00 60.76           C  
ATOM   8900  C   ARG H  50      21.747  53.464   8.662  1.00 57.81           C  
ATOM   8901  O   ARG H  50      20.973  53.230   9.582  1.00 56.54           O  
ATOM   8902  CB  ARG H  50      21.593  55.943   9.270  1.00 62.12           C  
ATOM   8903  CG  ARG H  50      22.064  57.380   9.007  1.00 65.54           C  
ATOM   8904  CD  ARG H  50      22.821  57.964  10.181  1.00 69.71           C  
ATOM   8905  NE  ARG H  50      21.909  58.728  11.023  1.00 71.78           N  
ATOM   8906  CZ  ARG H  50      22.055  58.922  12.328  1.00 73.11           C  
ATOM   8907  NH1 ARG H  50      23.084  58.397  12.988  1.00 72.11           N  
ATOM   8908  NH2 ARG H  50      21.152  59.645  12.972  1.00 74.62           N  
ATOM   8909  N   TYR H  51      22.107  52.552   7.759  1.00 54.61           N  
ATOM   8910  CA  TYR H  51      21.704  51.172   7.848  1.00 51.85           C  
ATOM   8911  C   TYR H  51      22.701  50.427   8.728  1.00 50.53           C  
ATOM   8912  O   TYR H  51      23.270  49.411   8.313  1.00 49.57           O  
ATOM   8913  CB  TYR H  51      21.641  50.504   6.469  1.00 51.23           C  
ATOM   8914  CG  TYR H  51      20.536  50.926   5.505  1.00 49.42           C  
ATOM   8915  CD1 TYR H  51      19.232  51.222   5.931  1.00 45.73           C  
ATOM   8916  CD2 TYR H  51      20.798  50.995   4.130  1.00 48.69           C  
ATOM   8917  CE1 TYR H  51      18.242  51.581   5.010  1.00 39.93           C  
ATOM   8918  CE2 TYR H  51      19.806  51.357   3.216  1.00 43.31           C  
ATOM   8919  CZ  TYR H  51      18.549  51.644   3.657  1.00 39.92           C  
ATOM   8920  OH  TYR H  51      17.631  52.002   2.695  1.00 40.02           O  
ATOM   8921  N   ARG H  52      22.918  50.962   9.933  1.00 49.41           N  
ATOM   8922  CA  ARG H  52      23.768  50.355  10.962  1.00 47.44           C  
ATOM   8923  C   ARG H  52      23.015  49.246  11.673  1.00 45.34           C  
ATOM   8924  O   ARG H  52      21.941  49.485  12.255  1.00 45.11           O  
ATOM   8925  CB  ARG H  52      24.258  51.392  12.000  1.00 48.56           C  
ATOM   8926  CG  ARG H  52      25.157  50.799  13.087  1.00 48.82           C  
ATOM   8927  CD  ARG H  52      25.172  51.660  14.306  1.00 53.85           C  
ATOM   8928  NE  ARG H  52      26.214  51.271  15.259  1.00 58.42           N  
ATOM   8929  CZ  ARG H  52      25.987  50.682  16.434  1.00 60.78           C  
ATOM   8930  NH1 ARG H  52      24.745  50.385  16.811  1.00 62.83           N  
ATOM   8931  NH2 ARG H  52      27.004  50.376  17.230  1.00 60.71           N  
ATOM   8932  N   PRO H  53      23.567  48.022  11.610  1.00 43.06           N  
ATOM   8933  CA  PRO H  53      22.989  46.936  12.365  1.00 41.31           C  
ATOM   8934  C   PRO H  53      23.571  46.847  13.776  1.00 40.12           C  
ATOM   8935  O   PRO H  53      24.663  47.301  14.024  1.00 38.35           O  
ATOM   8936  CB  PRO H  53      23.345  45.717  11.527  1.00 40.56           C  
ATOM   8937  CG  PRO H  53      24.678  46.088  10.903  1.00 41.47           C  
ATOM   8938  CD  PRO H  53      24.726  47.586  10.802  1.00 42.42           C  
ATOM   8939  N   ASP H  54      22.808  46.242  14.681  1.00 39.77           N  
ATOM   8940  CA  ASP H  54      23.195  46.055  16.070  1.00 39.43           C  
ATOM   8941  C   ASP H  54      24.121  44.839  16.184  1.00 39.32           C  
ATOM   8942  O   ASP H  54      24.942  44.746  17.094  1.00 38.51           O  
ATOM   8943  CB  ASP H  54      21.951  45.852  16.972  1.00 38.90           C  
ATOM   8944  CG  ASP H  54      20.912  46.986  16.860  1.00 38.68           C  
ATOM   8945  OD1 ASP H  54      21.227  48.195  16.689  1.00 40.56           O  
ATOM   8946  OD2 ASP H  54      19.730  46.660  16.930  1.00 35.99           O  
ATOM   8947  N   LEU H  55      23.956  43.904  15.246  1.00 38.83           N  
ATOM   8948  CA  LEU H  55      24.692  42.654  15.240  1.00 38.02           C  
ATOM   8949  C   LEU H  55      24.963  42.180  13.817  1.00 36.74           C  
ATOM   8950  O   LEU H  55      24.033  42.078  12.976  1.00 36.84           O  
ATOM   8951  CB  LEU H  55      23.942  41.574  16.000  1.00 38.59           C  
ATOM   8952  CG  LEU H  55      24.546  40.173  15.868  1.00 40.75           C  
ATOM   8953  CD1 LEU H  55      25.884  40.023  16.600  1.00 44.20           C  
ATOM   8954  CD2 LEU H  55      23.538  39.058  16.321  1.00 47.50           C  
ATOM   8955  N   ILE H  56      26.231  41.875  13.570  1.00 33.32           N  
ATOM   8956  CA  ILE H  56      26.610  41.192  12.372  1.00 31.04           C  
ATOM   8957  C   ILE H  56      26.964  39.761  12.690  1.00 30.29           C  
ATOM   8958  O   ILE H  56      27.838  39.511  13.508  1.00 28.07           O  
ATOM   8959  CB  ILE H  56      27.783  41.891  11.619  1.00 30.15           C  
ATOM   8960  CG1 ILE H  56      27.457  43.375  11.433  1.00 29.78           C  
ATOM   8961  CG2 ILE H  56      28.045  41.179  10.320  1.00 29.33           C  
ATOM   8962  CD1 ILE H  56      28.586  44.317  11.109  1.00 25.55           C  
ATOM   8963  N   LEU H  57      26.249  38.829  12.041  1.00 29.56           N  
ATOM   8964  CA  LEU H  57      26.684  37.448  11.982  1.00 29.30           C  
ATOM   8965  C   LEU H  57      27.379  37.255  10.618  1.00 29.47           C  
ATOM   8966  O   LEU H  57      26.820  37.606   9.603  1.00 29.43           O  
ATOM   8967  CB  LEU H  57      25.471  36.534  12.157  1.00 27.95           C  
ATOM   8968  CG  LEU H  57      24.555  36.766  13.372  1.00 26.00           C  
ATOM   8969  CD1 LEU H  57      23.319  35.823  13.359  1.00 18.57           C  
ATOM   8970  CD2 LEU H  57      25.339  36.728  14.734  1.00 20.78           C  
ATOM   8971  N   SER H  58      28.607  36.739  10.618  1.00 30.26           N  
ATOM   8972  CA  SER H  58      29.465  36.573   9.423  1.00 29.69           C  
ATOM   8973  C   SER H  58      30.154  35.174   9.340  1.00 29.72           C  
ATOM   8974  O   SER H  58      30.557  34.593  10.340  1.00 27.70           O  
ATOM   8975  CB  SER H  58      30.563  37.645   9.395  1.00 30.41           C  
ATOM   8976  OG  SER H  58      31.495  37.459   8.288  1.00 30.50           O  
ATOM   8977  N   SER H  59      30.259  34.653   8.121  1.00 29.39           N  
ATOM   8978  CA  SER H  59      31.029  33.476   7.828  1.00 29.43           C  
ATOM   8979  C   SER H  59      32.498  33.765   8.186  1.00 29.37           C  
ATOM   8980  O   SER H  59      32.988  34.900   8.081  1.00 28.41           O  
ATOM   8981  CB  SER H  59      30.848  33.113   6.356  1.00 29.88           C  
ATOM   8982  OG  SER H  59      31.870  32.254   5.853  1.00 30.99           O  
ATOM   8983  N   THR H  60      33.176  32.738   8.665  1.00 29.18           N  
ATOM   8984  CA  THR H  60      34.595  32.825   8.931  1.00 29.16           C  
ATOM   8985  C   THR H  60      35.481  32.988   7.650  1.00 30.33           C  
ATOM   8986  O   THR H  60      36.570  33.494   7.722  1.00 30.70           O  
ATOM   8987  CB  THR H  60      35.021  31.572   9.700  1.00 28.89           C  
ATOM   8988  OG1 THR H  60      34.521  30.456   8.978  1.00 25.76           O  
ATOM   8989  CG2 THR H  60      34.433  31.571  11.155  1.00 24.39           C  
ATOM   8990  N   ALA H  61      35.030  32.544   6.477  1.00 31.93           N  
ATOM   8991  CA  ALA H  61      35.908  32.582   5.286  1.00 31.91           C  
ATOM   8992  C   ALA H  61      36.469  33.973   5.073  1.00 33.22           C  
ATOM   8993  O   ALA H  61      35.769  34.959   5.309  1.00 32.80           O  
ATOM   8994  CB  ALA H  61      35.154  32.107   4.037  1.00 30.58           C  
ATOM   8995  N   ALA H  62      37.706  34.044   4.564  1.00 34.53           N  
ATOM   8996  CA  ALA H  62      38.446  35.277   4.506  1.00 35.44           C  
ATOM   8997  C   ALA H  62      37.708  36.355   3.715  1.00 35.96           C  
ATOM   8998  O   ALA H  62      37.702  37.518   4.106  1.00 34.74           O  
ATOM   8999  CB  ALA H  62      39.877  35.038   3.955  1.00 36.09           C  
ATOM   9000  N   ARG H  63      37.075  35.954   2.613  1.00 36.67           N  
ATOM   9001  CA  ARG H  63      36.388  36.886   1.754  1.00 36.39           C  
ATOM   9002  C   ARG H  63      35.241  37.566   2.523  1.00 35.84           C  
ATOM   9003  O   ARG H  63      35.055  38.770   2.419  1.00 35.56           O  
ATOM   9004  CB  ARG H  63      35.941  36.202   0.452  1.00 37.06           C  
ATOM   9005  CG  ARG H  63      34.806  35.131   0.498  1.00 34.20           C  
ATOM   9006  CD  ARG H  63      34.672  34.537  -0.948  1.00 32.39           C  
ATOM   9007  NE  ARG H  63      33.945  33.269  -1.110  1.00 30.09           N  
ATOM   9008  CZ  ARG H  63      34.460  32.045  -0.993  1.00 28.89           C  
ATOM   9009  NH1 ARG H  63      35.727  31.866  -0.641  1.00 30.70           N  
ATOM   9010  NH2 ARG H  63      33.695  30.980  -1.219  1.00 27.11           N  
ATOM   9011  N   CYS H  64      34.531  36.781   3.325  1.00 35.36           N  
ATOM   9012  CA  CYS H  64      33.461  37.251   4.235  1.00 34.73           C  
ATOM   9013  C   CYS H  64      33.944  38.175   5.376  1.00 33.72           C  
ATOM   9014  O   CYS H  64      33.279  39.150   5.730  1.00 31.20           O  
ATOM   9015  CB  CYS H  64      32.794  36.048   4.850  1.00 33.81           C  
ATOM   9016  SG  CYS H  64      31.399  35.477   3.949  1.00 37.03           S  
ATOM   9017  N   ARG H  65      35.100  37.821   5.923  1.00 33.94           N  
ATOM   9018  CA  ARG H  65      35.819  38.580   6.955  1.00 35.00           C  
ATOM   9019  C   ARG H  65      36.329  39.938   6.506  1.00 35.49           C  
ATOM   9020  O   ARG H  65      36.181  40.930   7.233  1.00 34.55           O  
ATOM   9021  CB  ARG H  65      36.972  37.738   7.535  1.00 35.04           C  
ATOM   9022  CG  ARG H  65      36.484  36.617   8.532  1.00 29.70           C  
ATOM   9023  CD  ARG H  65      37.734  35.984   9.159  1.00 29.45           C  
ATOM   9024  NE  ARG H  65      37.438  34.952  10.157  1.00 30.60           N  
ATOM   9025  CZ  ARG H  65      37.298  35.184  11.460  1.00 30.46           C  
ATOM   9026  NH1 ARG H  65      37.441  36.408  11.921  1.00 29.76           N  
ATOM   9027  NH2 ARG H  65      37.025  34.194  12.306  1.00 30.51           N  
ATOM   9028  N   GLN H  66      36.863  39.981   5.283  1.00 36.90           N  
ATOM   9029  CA  GLN H  66      37.346  41.223   4.657  1.00 37.65           C  
ATOM   9030  C   GLN H  66      36.196  42.113   4.166  1.00 37.59           C  
ATOM   9031  O   GLN H  66      36.304  43.311   4.170  1.00 35.80           O  
ATOM   9032  CB  GLN H  66      38.318  40.915   3.525  1.00 37.71           C  
ATOM   9033  CG  GLN H  66      39.549  40.136   3.937  1.00 36.94           C  
ATOM   9034  CD  GLN H  66      40.210  39.453   2.757  1.00 37.47           C  
ATOM   9035  OE1 GLN H  66      39.644  39.391   1.670  1.00 35.88           O  
ATOM   9036  NE2 GLN H  66      41.412  38.928   2.965  1.00 38.34           N  
ATOM   9037  N   THR H  67      35.086  41.504   3.779  1.00 38.55           N  
ATOM   9038  CA  THR H  67      33.851  42.246   3.478  1.00 39.91           C  
ATOM   9039  C   THR H  67      33.192  42.799   4.776  1.00 41.01           C  
ATOM   9040  O   THR H  67      32.742  43.966   4.808  1.00 40.38           O  
ATOM   9041  CB  THR H  67      32.832  41.363   2.665  1.00 39.71           C  
ATOM   9042  OG1 THR H  67      33.546  40.632   1.658  1.00 38.07           O  
ATOM   9043  CG2 THR H  67      31.752  42.211   2.014  1.00 38.65           C  
ATOM   9044  N   THR H  68      33.141  41.952   5.826  1.00 41.36           N  
ATOM   9045  CA  THR H  68      32.793  42.399   7.166  1.00 41.27           C  
ATOM   9046  C   THR H  68      33.694  43.515   7.693  1.00 40.56           C  
ATOM   9047  O   THR H  68      33.178  44.505   8.142  1.00 39.62           O  
ATOM   9048  CB  THR H  68      32.638  41.262   8.182  1.00 41.67           C  
ATOM   9049  OG1 THR H  68      31.788  40.254   7.635  1.00 43.53           O  
ATOM   9050  CG2 THR H  68      31.959  41.753   9.462  1.00 41.95           C  
ATOM   9051  N   GLN H  69      35.017  43.395   7.616  1.00 40.76           N  
ATOM   9052  CA  GLN H  69      35.901  44.530   8.051  1.00 40.31           C  
ATOM   9053  C   GLN H  69      35.770  45.878   7.278  1.00 39.40           C  
ATOM   9054  O   GLN H  69      35.778  46.949   7.868  1.00 38.23           O  
ATOM   9055  CB  GLN H  69      37.373  44.107   8.170  1.00 40.61           C  
ATOM   9056  CG  GLN H  69      37.625  42.841   8.991  1.00 42.71           C  
ATOM   9057  CD  GLN H  69      38.958  42.223   8.634  1.00 44.73           C  
ATOM   9058  OE1 GLN H  69      39.877  42.950   8.354  1.00 51.93           O  
ATOM   9059  NE2 GLN H  69      39.063  40.903   8.609  1.00 42.53           N  
ATOM   9060  N   ALA H  70      35.641  45.836   5.964  1.00 39.16           N  
ATOM   9061  CA  ALA H  70      35.196  47.026   5.227  1.00 40.11           C  
ATOM   9062  C   ALA H  70      33.973  47.722   5.887  1.00 40.38           C  
ATOM   9063  O   ALA H  70      33.856  48.938   5.914  1.00 40.09           O  
ATOM   9064  CB  ALA H  70      34.914  46.685   3.744  1.00 38.23           C  
ATOM   9065  N   TRP H  71      33.065  46.939   6.434  1.00 42.57           N  
ATOM   9066  CA  TRP H  71      31.930  47.492   7.131  1.00 44.22           C  
ATOM   9067  C   TRP H  71      32.301  47.991   8.524  1.00 46.15           C  
ATOM   9068  O   TRP H  71      31.599  48.831   9.073  1.00 45.90           O  
ATOM   9069  CB  TRP H  71      30.816  46.453   7.206  1.00 43.79           C  
ATOM   9070  CG  TRP H  71      29.968  46.418   5.984  1.00 42.22           C  
ATOM   9071  CD1 TRP H  71      30.349  46.061   4.714  1.00 42.72           C  
ATOM   9072  CD2 TRP H  71      28.589  46.775   5.911  1.00 40.21           C  
ATOM   9073  NE1 TRP H  71      29.264  46.157   3.849  1.00 42.72           N  
ATOM   9074  CE2 TRP H  71      28.175  46.591   4.562  1.00 40.10           C  
ATOM   9075  CE3 TRP H  71      27.639  47.197   6.867  1.00 40.67           C  
ATOM   9076  CZ2 TRP H  71      26.860  46.827   4.142  1.00 39.06           C  
ATOM   9077  CZ3 TRP H  71      26.320  47.423   6.452  1.00 37.61           C  
ATOM   9078  CH2 TRP H  71      25.949  47.240   5.100  1.00 38.94           C  
ATOM   9079  N   GLN H  72      33.401  47.481   9.086  1.00 48.24           N  
ATOM   9080  CA  GLN H  72      33.846  47.906  10.422  1.00 51.28           C  
ATOM   9081  C   GLN H  72      34.478  49.303  10.369  1.00 52.41           C  
ATOM   9082  O   GLN H  72      34.597  49.975  11.382  1.00 52.50           O  
ATOM   9083  CB  GLN H  72      34.830  46.900  11.069  1.00 51.27           C  
ATOM   9084  CG  GLN H  72      34.233  45.749  11.896  1.00 52.07           C  
ATOM   9085  CD  GLN H  72      35.311  45.009  12.722  1.00 53.31           C  
ATOM   9086  OE1 GLN H  72      36.369  44.644  12.203  1.00 54.07           O  
ATOM   9087  NE2 GLN H  72      35.045  44.804  14.004  1.00 51.77           N  
ATOM   9088  N   ARG H  73      34.875  49.731   9.179  1.00 53.98           N  
ATOM   9089  CA  ARG H  73      35.471  51.044   8.994  1.00 55.66           C  
ATOM   9090  C   ARG H  73      34.421  52.111   8.689  1.00 56.47           C  
ATOM   9091  O   ARG H  73      34.522  53.256   9.177  1.00 56.36           O  
ATOM   9092  CB  ARG H  73      36.520  50.997   7.885  1.00 55.76           C  
ATOM   9093  CG  ARG H  73      37.533  49.922   8.087  1.00 55.35           C  
ATOM   9094  CD  ARG H  73      38.430  49.788   6.900  1.00 56.20           C  
ATOM   9095  NE  ARG H  73      39.003  48.452   6.897  1.00 56.08           N  
ATOM   9096  CZ  ARG H  73      39.012  47.643   5.852  1.00 56.11           C  
ATOM   9097  NH1 ARG H  73      38.504  48.033   4.693  1.00 55.54           N  
ATOM   9098  NH2 ARG H  73      39.542  46.439   5.974  1.00 57.77           N  
ATOM   9099  N   ALA H  74      33.410  51.734   7.904  1.00 56.63           N  
ATOM   9100  CA  ALA H  74      32.328  52.646   7.582  1.00 57.62           C  
ATOM   9101  C   ALA H  74      31.558  53.138   8.818  1.00 58.31           C  
ATOM   9102  O   ALA H  74      30.949  54.200   8.780  1.00 58.56           O  
ATOM   9103  CB  ALA H  74      31.404  52.052   6.555  1.00 56.87           C  
ATOM   9104  N   PHE H  75      31.630  52.409   9.927  1.00 58.37           N  
ATOM   9105  CA  PHE H  75      30.888  52.804  11.126  1.00 58.49           C  
ATOM   9106  C   PHE H  75      31.755  53.117  12.360  1.00 57.25           C  
ATOM   9107  O   PHE H  75      31.652  54.201  12.942  1.00 56.32           O  
ATOM   9108  CB  PHE H  75      29.813  51.765  11.443  1.00 58.96           C  
ATOM   9109  CG  PHE H  75      28.700  51.678  10.385  1.00 62.93           C  
ATOM   9110  CD1 PHE H  75      28.907  51.023   9.162  1.00 63.42           C  
ATOM   9111  CD2 PHE H  75      27.439  52.223  10.626  1.00 63.30           C  
ATOM   9112  CE1 PHE H  75      27.899  50.940   8.215  1.00 60.01           C  
ATOM   9113  CE2 PHE H  75      26.446  52.125   9.675  1.00 61.61           C  
ATOM   9114  CZ  PHE H  75      26.680  51.483   8.479  1.00 60.20           C  
ATOM   9115  N   ILE H  79      30.402  48.046  16.297  1.00 50.42           N  
ATOM   9116  CA  ILE H  79      29.288  47.074  16.157  1.00 50.42           C  
ATOM   9117  C   ILE H  79      29.590  45.621  16.639  1.00 48.55           C  
ATOM   9118  O   ILE H  79      30.734  45.156  16.539  1.00 47.94           O  
ATOM   9119  CB  ILE H  79      28.621  47.070  14.718  1.00 50.72           C  
ATOM   9120  CG1 ILE H  79      29.572  47.383  13.545  1.00 53.54           C  
ATOM   9121  CG2 ILE H  79      27.586  48.145  14.634  1.00 51.45           C  
ATOM   9122  CD1 ILE H  79      30.977  46.696  13.534  1.00 58.41           C  
ATOM   9123  N   ASP H  80      28.565  44.925  17.160  1.00 45.76           N  
ATOM   9124  CA  ASP H  80      28.679  43.506  17.543  1.00 43.41           C  
ATOM   9125  C   ASP H  80      28.774  42.514  16.401  1.00 41.26           C  
ATOM   9126  O   ASP H  80      27.885  42.397  15.590  1.00 38.37           O  
ATOM   9127  CB  ASP H  80      27.556  43.089  18.467  1.00 43.42           C  
ATOM   9128  CG  ASP H  80      27.664  43.729  19.780  1.00 44.27           C  
ATOM   9129  OD1 ASP H  80      28.792  44.167  20.126  1.00 43.92           O  
ATOM   9130  OD2 ASP H  80      26.635  43.791  20.472  1.00 45.86           O  
ATOM   9131  N   ILE H  81      29.881  41.795  16.377  1.00 41.06           N  
ATOM   9132  CA  ILE H  81      30.285  40.952  15.248  1.00 41.13           C  
ATOM   9133  C   ILE H  81      30.456  39.611  15.875  1.00 40.29           C  
ATOM   9134  O   ILE H  81      30.947  39.532  16.985  1.00 42.30           O  
ATOM   9135  CB  ILE H  81      31.700  41.330  14.719  1.00 41.91           C  
ATOM   9136  CG1 ILE H  81      31.654  42.469  13.713  1.00 42.13           C  
ATOM   9137  CG2 ILE H  81      32.408  40.115  14.108  1.00 41.62           C  
ATOM   9138  CD1 ILE H  81      30.812  43.567  14.144  1.00 44.03           C  
ATOM   9139  N   VAL H  82      30.078  38.559  15.173  1.00 37.73           N  
ATOM   9140  CA  VAL H  82      30.331  37.237  15.632  1.00 35.78           C  
ATOM   9141  C   VAL H  82      30.554  36.351  14.410  1.00 35.46           C  
ATOM   9142  O   VAL H  82      29.730  36.358  13.474  1.00 35.02           O  
ATOM   9143  CB  VAL H  82      29.136  36.744  16.505  1.00 35.94           C  
ATOM   9144  CG1 VAL H  82      29.091  35.191  16.617  1.00 32.04           C  
ATOM   9145  CG2 VAL H  82      29.150  37.451  17.882  1.00 33.76           C  
ATOM   9146  N   TYR H  83      31.635  35.575  14.428  1.00 34.29           N  
ATOM   9147  CA  TYR H  83      31.920  34.698  13.293  1.00 35.00           C  
ATOM   9148  C   TYR H  83      31.556  33.257  13.504  1.00 34.53           C  
ATOM   9149  O   TYR H  83      31.659  32.732  14.589  1.00 35.68           O  
ATOM   9150  CB  TYR H  83      33.364  34.806  12.810  1.00 34.97           C  
ATOM   9151  CG  TYR H  83      33.795  36.206  12.586  1.00 35.76           C  
ATOM   9152  CD1 TYR H  83      34.258  36.994  13.668  1.00 37.71           C  
ATOM   9153  CD2 TYR H  83      33.766  36.763  11.313  1.00 35.06           C  
ATOM   9154  CE1 TYR H  83      34.662  38.313  13.463  1.00 40.75           C  
ATOM   9155  CE2 TYR H  83      34.183  38.073  11.090  1.00 36.89           C  
ATOM   9156  CZ  TYR H  83      34.628  38.838  12.170  1.00 38.37           C  
ATOM   9157  OH  TYR H  83      35.035  40.129  11.987  1.00 41.17           O  
ATOM   9158  N   ILE H  84      31.163  32.605  12.428  1.00 34.29           N  
ATOM   9159  CA  ILE H  84      30.435  31.332  12.497  1.00 33.41           C  
ATOM   9160  C   ILE H  84      30.842  30.470  11.320  1.00 34.10           C  
ATOM   9161  O   ILE H  84      30.474  30.767  10.189  1.00 32.03           O  
ATOM   9162  CB  ILE H  84      28.900  31.610  12.478  1.00 32.38           C  
ATOM   9163  CG1 ILE H  84      28.465  32.371  13.757  1.00 31.62           C  
ATOM   9164  CG2 ILE H  84      28.110  30.350  12.222  1.00 29.86           C  
ATOM   9165  CD1 ILE H  84      27.002  32.686  13.892  1.00 26.22           C  
ATOM   9166  N   ASP H  85      31.606  29.415  11.596  1.00 36.09           N  
ATOM   9167  CA  ASP H  85      32.130  28.512  10.540  1.00 39.50           C  
ATOM   9168  C   ASP H  85      31.101  27.866   9.650  1.00 40.20           C  
ATOM   9169  O   ASP H  85      31.267  27.856   8.440  1.00 39.38           O  
ATOM   9170  CB  ASP H  85      32.978  27.394  11.122  1.00 40.40           C  
ATOM   9171  CG  ASP H  85      34.377  27.766  11.231  1.00 42.68           C  
ATOM   9172  OD1 ASP H  85      34.929  28.339  10.260  1.00 42.22           O  
ATOM   9173  OD2 ASP H  85      34.930  27.476  12.305  1.00 49.35           O  
ATOM   9174  N   GLU H  86      30.085  27.293  10.297  1.00 42.09           N  
ATOM   9175  CA  GLU H  86      28.838  26.837   9.685  1.00 44.01           C  
ATOM   9176  C   GLU H  86      28.139  27.730   8.631  1.00 42.43           C  
ATOM   9177  O   GLU H  86      27.343  27.202   7.841  1.00 42.26           O  
ATOM   9178  CB  GLU H  86      27.852  26.497  10.784  1.00 45.13           C  
ATOM   9179  CG  GLU H  86      27.961  25.051  11.217  1.00 54.86           C  
ATOM   9180  CD  GLU H  86      27.605  24.039  10.088  1.00 64.28           C  
ATOM   9181  OE1 GLU H  86      26.562  24.251   9.387  1.00 64.99           O  
ATOM   9182  OE2 GLU H  86      28.365  23.028   9.930  1.00 67.43           O  
HETATM 9183  N   MSE H  87      28.396  29.047   8.604  1.00 40.05           N  
HETATM 9184  CA  MSE H  87      27.899  29.872   7.479  1.00 38.13           C  
HETATM 9185  C   MSE H  87      28.682  29.590   6.172  1.00 37.16           C  
HETATM 9186  O   MSE H  87      28.206  29.889   5.074  1.00 34.97           O  
HETATM 9187  CB  MSE H  87      27.871  31.376   7.793  1.00 37.12           C  
HETATM 9188  CG  MSE H  87      26.718  31.802   8.671  1.00 37.49           C  
HETATM 9189 SE   MSE H  87      26.864  33.649   9.349  0.90 39.06          SE  
HETATM 9190  CE  MSE H  87      25.585  34.667   8.177  1.00 29.85           C  
ATOM   9191  N   TYR H  88      29.881  29.018   6.309  1.00 36.96           N  
ATOM   9192  CA  TYR H  88      30.671  28.618   5.151  1.00 36.71           C  
ATOM   9193  C   TYR H  88      30.219  27.235   4.680  1.00 36.46           C  
ATOM   9194  O   TYR H  88      30.125  26.289   5.467  1.00 36.53           O  
ATOM   9195  CB  TYR H  88      32.166  28.630   5.464  1.00 37.21           C  
ATOM   9196  CG  TYR H  88      33.003  28.250   4.260  1.00 37.12           C  
ATOM   9197  CD1 TYR H  88      33.243  29.171   3.254  1.00 37.86           C  
ATOM   9198  CD2 TYR H  88      33.509  26.962   4.112  1.00 37.40           C  
ATOM   9199  CE1 TYR H  88      33.987  28.834   2.134  1.00 37.37           C  
ATOM   9200  CE2 TYR H  88      34.254  26.605   3.004  1.00 37.34           C  
ATOM   9201  CZ  TYR H  88      34.487  27.550   2.009  1.00 38.99           C  
ATOM   9202  OH  TYR H  88      35.244  27.234   0.897  1.00 37.20           O  
ATOM   9203  N   ASN H  89      29.866  27.153   3.410  1.00 36.14           N  
ATOM   9204  CA  ASN H  89      29.337  25.946   2.844  1.00 37.83           C  
ATOM   9205  C   ASN H  89      28.283  25.352   3.806  1.00 39.33           C  
ATOM   9206  O   ASN H  89      28.494  24.288   4.434  1.00 39.35           O  
ATOM   9207  CB  ASN H  89      30.516  25.015   2.544  1.00 38.41           C  
ATOM   9208  CG  ASN H  89      30.251  24.072   1.407  1.00 40.06           C  
ATOM   9209  OD1 ASN H  89      30.806  22.968   1.392  1.00 45.46           O  
ATOM   9210  ND2 ASN H  89      29.403  24.469   0.458  1.00 35.85           N  
ATOM   9211  N   ALA H  90      27.158  26.076   3.942  1.00 39.77           N  
ATOM   9212  CA  ALA H  90      26.151  25.774   4.962  1.00 41.12           C  
ATOM   9213  C   ALA H  90      25.415  24.512   4.620  1.00 42.12           C  
ATOM   9214  O   ALA H  90      25.219  24.184   3.432  1.00 41.70           O  
ATOM   9215  CB  ALA H  90      25.147  26.959   5.203  1.00 40.57           C  
ATOM   9216  N   ARG H  91      25.029  23.788   5.663  0.50 42.22           N  
ATOM   9218  CA  ARG H  91      24.235  22.602   5.491  0.50 43.24           C  
ATOM   9220  C   ARG H  91      22.815  22.980   5.100  0.50 42.86           C  
ATOM   9222  O   ARG H  91      22.247  22.428   4.151  0.50 42.50           O  
ATOM   9224  CB  ARG H  91      24.271  21.733   6.747  0.50 43.49           C  
ATOM   9226  CG  ARG H  91      25.125  20.545   6.539  0.50 43.34           C  
ATOM   9228  CD  ARG H  91      26.220  20.501   7.550  0.50 45.31           C  
ATOM   9230  NE  ARG H  91      27.203  19.482   7.220  0.50 47.77           N  
ATOM   9232  CZ  ARG H  91      28.386  19.377   7.804  0.50 52.55           C  
ATOM   9234  NH1 ARG H  91      28.755  20.248   8.740  0.50 54.51           N  
ATOM   9236  NH2 ARG H  91      29.215  18.413   7.437  0.50 54.78           N  
ATOM   9238  N   SER H  92      22.286  23.956   5.821  1.00 42.18           N  
ATOM   9239  CA  SER H  92      20.922  24.447   5.651  1.00 42.24           C  
ATOM   9240  C   SER H  92      20.750  25.171   4.325  1.00 40.39           C  
ATOM   9241  O   SER H  92      21.735  25.620   3.762  1.00 41.38           O  
ATOM   9242  CB  SER H  92      20.624  25.360   6.833  1.00 42.11           C  
ATOM   9243  OG  SER H  92      21.701  25.237   7.775  1.00 43.56           O  
ATOM   9244  N   GLU H  93      19.532  25.267   3.806  1.00 38.59           N  
ATOM   9245  CA  GLU H  93      19.329  25.995   2.562  1.00 37.53           C  
ATOM   9246  C   GLU H  93      19.358  27.525   2.709  1.00 35.13           C  
ATOM   9247  O   GLU H  93      19.764  28.246   1.803  1.00 33.65           O  
ATOM   9248  CB  GLU H  93      18.098  25.510   1.804  1.00 37.77           C  
ATOM   9249  CG  GLU H  93      16.766  26.074   2.304  1.00 44.66           C  
ATOM   9250  CD  GLU H  93      15.659  25.968   1.277  1.00 49.15           C  
ATOM   9251  OE1 GLU H  93      15.923  25.321   0.225  1.00 49.34           O  
ATOM   9252  OE2 GLU H  93      14.541  26.510   1.551  1.00 51.52           O  
ATOM   9253  N   THR H  94      18.944  28.000   3.872  1.00 34.39           N  
ATOM   9254  CA  THR H  94      18.877  29.419   4.167  1.00 33.16           C  
ATOM   9255  C   THR H  94      19.559  29.737   5.470  1.00 32.38           C  
ATOM   9256  O   THR H  94      19.991  28.845   6.213  1.00 32.84           O  
ATOM   9257  CB  THR H  94      17.435  29.903   4.341  1.00 33.72           C  
ATOM   9258  OG1 THR H  94      16.925  29.384   5.573  1.00 33.48           O  
ATOM   9259  CG2 THR H  94      16.558  29.505   3.150  1.00 31.26           C  
ATOM   9260  N   TYR H  95      19.642  31.024   5.755  1.00 31.04           N  
ATOM   9261  CA  TYR H  95      20.235  31.478   6.981  1.00 29.85           C  
ATOM   9262  C   TYR H  95      19.163  31.859   8.016  1.00 30.95           C  
ATOM   9263  O   TYR H  95      19.468  32.262   9.107  1.00 29.92           O  
ATOM   9264  CB  TYR H  95      21.112  32.653   6.673  1.00 28.88           C  
ATOM   9265  CG  TYR H  95      22.449  32.376   6.018  1.00 25.08           C  
ATOM   9266  CD1 TYR H  95      23.316  31.414   6.523  1.00 22.70           C  
ATOM   9267  CD2 TYR H  95      22.876  33.157   4.946  1.00 19.55           C  
ATOM   9268  CE1 TYR H  95      24.539  31.201   5.952  1.00 22.39           C  
ATOM   9269  CE2 TYR H  95      24.098  32.951   4.347  1.00 21.30           C  
ATOM   9270  CZ  TYR H  95      24.951  32.005   4.866  1.00 24.74           C  
ATOM   9271  OH  TYR H  95      26.164  31.791   4.248  1.00 24.11           O  
ATOM   9272  N   LEU H  96      17.899  31.693   7.653  1.00 32.97           N  
ATOM   9273  CA  LEU H  96      16.765  32.127   8.458  1.00 35.21           C  
ATOM   9274  C   LEU H  96      16.703  31.747   9.921  1.00 35.48           C  
ATOM   9275  O   LEU H  96      16.037  32.426  10.696  1.00 35.16           O  
ATOM   9276  CB  LEU H  96      15.466  31.673   7.821  1.00 36.25           C  
ATOM   9277  CG  LEU H  96      14.988  32.649   6.743  1.00 39.30           C  
ATOM   9278  CD1 LEU H  96      13.770  32.005   6.029  1.00 46.42           C  
ATOM   9279  CD2 LEU H  96      14.678  34.041   7.287  1.00 38.22           C  
ATOM   9280  N   SER H  97      17.314  30.641  10.308  1.00 36.12           N  
ATOM   9281  CA  SER H  97      17.233  30.284  11.722  1.00 36.82           C  
ATOM   9282  C   SER H  97      18.190  31.141  12.531  1.00 35.90           C  
ATOM   9283  O   SER H  97      17.948  31.368  13.701  1.00 35.50           O  
ATOM   9284  CB  SER H  97      17.424  28.795  11.963  1.00 37.01           C  
ATOM   9285  OG  SER H  97      16.503  28.098  11.167  1.00 38.21           O  
ATOM   9286  N   LEU H  98      19.239  31.630  11.877  1.00 34.95           N  
ATOM   9287  CA  LEU H  98      20.222  32.555  12.462  1.00 34.88           C  
ATOM   9288  C   LEU H  98      19.607  33.881  12.869  1.00 33.75           C  
ATOM   9289  O   LEU H  98      19.930  34.421  13.903  1.00 32.80           O  
ATOM   9290  CB  LEU H  98      21.321  32.858  11.435  1.00 35.37           C  
ATOM   9291  CG  LEU H  98      22.252  31.731  11.038  1.00 35.96           C  
ATOM   9292  CD1 LEU H  98      23.531  32.332  10.652  1.00 34.70           C  
ATOM   9293  CD2 LEU H  98      22.500  30.873  12.243  1.00 42.90           C  
ATOM   9294  N   ILE H  99      18.759  34.402  11.989  1.00 33.44           N  
ATOM   9295  CA  ILE H  99      17.995  35.608  12.175  1.00 32.86           C  
ATOM   9296  C   ILE H  99      17.003  35.450  13.326  1.00 33.50           C  
ATOM   9297  O   ILE H  99      17.037  36.217  14.285  1.00 32.95           O  
ATOM   9298  CB  ILE H  99      17.242  35.929  10.851  1.00 33.53           C  
ATOM   9299  CG1 ILE H  99      18.262  36.303   9.757  1.00 34.04           C  
ATOM   9300  CG2 ILE H  99      16.043  36.943  11.068  1.00 30.03           C  
ATOM   9301  CD1 ILE H  99      17.755  36.209   8.294  1.00 33.53           C  
ATOM   9302  N   ALA H 100      16.129  34.448  13.231  1.00 33.17           N  
ATOM   9303  CA  ALA H 100      15.042  34.314  14.173  1.00 33.73           C  
ATOM   9304  C   ALA H 100      15.464  33.955  15.626  1.00 34.10           C  
ATOM   9305  O   ALA H 100      14.685  34.117  16.560  1.00 34.81           O  
ATOM   9306  CB  ALA H 100      14.005  33.376  13.629  1.00 33.69           C  
ATOM   9307  N   ALA H 101      16.717  33.547  15.820  1.00 34.28           N  
ATOM   9308  CA  ALA H 101      17.251  33.255  17.160  1.00 33.66           C  
ATOM   9309  C   ALA H 101      17.491  34.505  17.996  1.00 33.65           C  
ATOM   9310  O   ALA H 101      17.447  34.449  19.208  1.00 33.16           O  
ATOM   9311  CB  ALA H 101      18.481  32.460  17.050  1.00 32.51           C  
ATOM   9312  N   GLN H 102      17.744  35.627  17.330  1.00 34.61           N  
ATOM   9313  CA  GLN H 102      18.202  36.851  17.975  1.00 36.32           C  
ATOM   9314  C   GLN H 102      16.967  37.659  18.433  1.00 39.17           C  
ATOM   9315  O   GLN H 102      16.711  38.778  17.948  1.00 36.87           O  
ATOM   9316  CB  GLN H 102      19.139  37.648  17.034  1.00 35.43           C  
ATOM   9317  CG  GLN H 102      20.151  36.829  16.168  1.00 30.37           C  
ATOM   9318  CD  GLN H 102      20.965  35.753  16.940  1.00 26.38           C  
ATOM   9319  OE1 GLN H 102      21.322  35.928  18.104  1.00 23.15           O  
ATOM   9320  NE2 GLN H 102      21.256  34.644  16.273  1.00 24.18           N  
ATOM   9321  N   THR H 103      16.225  37.062  19.385  1.00 42.81           N  
ATOM   9322  CA  THR H 103      14.860  37.481  19.744  1.00 47.06           C  
ATOM   9323  C   THR H 103      14.754  38.748  20.556  1.00 48.88           C  
ATOM   9324  O   THR H 103      13.650  39.248  20.771  1.00 48.31           O  
ATOM   9325  CB  THR H 103      14.105  36.405  20.536  1.00 48.20           C  
ATOM   9326  OG1 THR H 103      14.840  36.043  21.720  1.00 46.96           O  
ATOM   9327  CG2 THR H 103      13.817  35.169  19.640  1.00 50.62           C  
ATOM   9328  N   GLU H 104      15.903  39.233  21.017  1.00 51.02           N  
ATOM   9329  CA  GLU H 104      16.000  40.460  21.780  1.00 53.33           C  
ATOM   9330  C   GLU H 104      17.026  41.449  21.179  1.00 52.09           C  
ATOM   9331  O   GLU H 104      17.459  42.374  21.872  1.00 52.87           O  
ATOM   9332  CB  GLU H 104      16.215  40.151  23.289  1.00 54.44           C  
ATOM   9333  CG  GLU H 104      14.976  39.397  23.916  1.00 59.82           C  
ATOM   9334  CD  GLU H 104      14.884  39.398  25.458  1.00 63.69           C  
ATOM   9335  OE1 GLU H 104      14.990  40.494  26.069  1.00 64.74           O  
ATOM   9336  OE2 GLU H 104      14.670  38.299  26.045  1.00 62.53           O  
ATOM   9337  N   VAL H 105      17.404  41.241  19.902  1.00 49.73           N  
ATOM   9338  CA  VAL H 105      18.171  42.226  19.088  1.00 46.65           C  
ATOM   9339  C   VAL H 105      17.317  42.914  18.000  1.00 45.19           C  
ATOM   9340  O   VAL H 105      16.636  42.242  17.223  1.00 43.39           O  
ATOM   9341  CB  VAL H 105      19.411  41.624  18.346  1.00 46.30           C  
ATOM   9342  CG1 VAL H 105      20.230  42.740  17.779  1.00 44.90           C  
ATOM   9343  CG2 VAL H 105      20.270  40.754  19.236  1.00 43.66           C  
ATOM   9344  N   GLN H 106      17.406  44.241  17.920  1.00 43.84           N  
ATOM   9345  CA  GLN H 106      16.619  45.022  16.962  1.00 43.42           C  
ATOM   9346  C   GLN H 106      16.986  44.877  15.459  1.00 41.86           C  
ATOM   9347  O   GLN H 106      16.122  44.575  14.637  1.00 41.37           O  
ATOM   9348  CB  GLN H 106      16.569  46.483  17.381  1.00 44.75           C  
ATOM   9349  CG  GLN H 106      15.740  47.375  16.461  1.00 46.92           C  
ATOM   9350  CD  GLN H 106      14.924  48.392  17.227  1.00 50.80           C  
ATOM   9351  OE1 GLN H 106      15.362  48.902  18.279  1.00 50.70           O  
ATOM   9352  NE2 GLN H 106      13.715  48.695  16.711  1.00 51.15           N  
ATOM   9353  N   SER H 107      18.247  45.088  15.092  1.00 39.86           N  
ATOM   9354  CA  SER H 107      18.646  44.846  13.706  1.00 37.53           C  
ATOM   9355  C   SER H 107      19.808  43.852  13.616  1.00 36.49           C  
ATOM   9356  O   SER H 107      20.672  43.801  14.482  1.00 34.57           O  
ATOM   9357  CB  SER H 107      18.912  46.151  12.942  1.00 36.54           C  
ATOM   9358  OG  SER H 107      20.244  46.536  13.117  1.00 34.60           O  
ATOM   9359  N   VAL H 108      19.787  43.040  12.566  1.00 35.83           N  
ATOM   9360  CA  VAL H 108      20.736  41.949  12.446  1.00 35.95           C  
ATOM   9361  C   VAL H 108      21.193  41.719  10.998  1.00 35.24           C  
ATOM   9362  O   VAL H 108      20.398  41.755  10.055  1.00 33.37           O  
ATOM   9363  CB  VAL H 108      20.220  40.674  13.198  1.00 35.08           C  
ATOM   9364  CG1 VAL H 108      18.976  40.242  12.618  1.00 40.50           C  
ATOM   9365  CG2 VAL H 108      21.196  39.529  13.146  1.00 35.55           C  
HETATM 9366  N   MSE H 109      22.513  41.533  10.855  1.00 35.85           N  
HETATM 9367  CA  MSE H 109      23.169  41.389   9.562  1.00 35.24           C  
HETATM 9368  C   MSE H 109      23.935  40.066   9.402  1.00 34.09           C  
HETATM 9369  O   MSE H 109      24.749  39.650  10.267  1.00 32.94           O  
HETATM 9370  CB  MSE H 109      24.061  42.592   9.251  1.00 36.19           C  
HETATM 9371  CG  MSE H 109      24.826  42.474   7.922  1.00 40.18           C  
HETATM 9372 SE   MSE H 109      25.578  44.170   7.216  1.00 58.69          SE  
HETATM 9373  CE  MSE H 109      27.454  43.673   7.157  1.00 49.48           C  
ATOM   9374  N   LEU H 110      23.636  39.404   8.282  1.00 31.88           N  
ATOM   9375  CA  LEU H 110      24.326  38.195   7.887  1.00 30.22           C  
ATOM   9376  C   LEU H 110      25.334  38.499   6.812  1.00 28.83           C  
ATOM   9377  O   LEU H 110      24.988  39.102   5.826  1.00 28.98           O  
ATOM   9378  CB  LEU H 110      23.345  37.187   7.341  1.00 29.00           C  
ATOM   9379  CG  LEU H 110      22.134  37.096   8.218  1.00 28.51           C  
ATOM   9380  CD1 LEU H 110      21.127  36.194   7.493  1.00 32.39           C  
ATOM   9381  CD2 LEU H 110      22.500  36.568   9.643  1.00 26.37           C  
ATOM   9382  N   VAL H 111      26.564  38.059   6.994  1.00 27.59           N  
ATOM   9383  CA  VAL H 111      27.546  38.118   5.912  1.00 28.18           C  
ATOM   9384  C   VAL H 111      27.896  36.697   5.498  1.00 28.47           C  
ATOM   9385  O   VAL H 111      28.728  36.057   6.100  1.00 29.56           O  
ATOM   9386  CB  VAL H 111      28.840  39.072   6.240  1.00 27.37           C  
ATOM   9387  CG1 VAL H 111      29.777  39.242   5.065  1.00 24.32           C  
ATOM   9388  CG2 VAL H 111      28.392  40.422   6.722  1.00 25.41           C  
ATOM   9389  N   GLY H 112      27.230  36.200   4.479  1.00 29.03           N  
ATOM   9390  CA  GLY H 112      27.577  34.888   3.966  1.00 31.47           C  
ATOM   9391  C   GLY H 112      27.672  34.779   2.462  1.00 31.98           C  
ATOM   9392  O   GLY H 112      27.881  35.756   1.798  1.00 30.83           O  
ATOM   9393  N   HIS H 113      27.411  33.568   1.968  1.00 34.49           N  
ATOM   9394  CA  HIS H 113      27.696  33.102   0.604  1.00 36.28           C  
ATOM   9395  C   HIS H 113      26.416  32.674  -0.137  1.00 36.94           C  
ATOM   9396  O   HIS H 113      25.457  32.222   0.485  1.00 36.50           O  
ATOM   9397  CB  HIS H 113      28.585  31.848   0.680  1.00 36.54           C  
ATOM   9398  CG  HIS H 113      29.772  31.994   1.585  1.00 37.28           C  
ATOM   9399  ND1 HIS H 113      31.013  32.371   1.120  1.00 32.91           N  
ATOM   9400  CD2 HIS H 113      29.909  31.821   2.925  1.00 37.52           C  
ATOM   9401  CE1 HIS H 113      31.864  32.432   2.130  1.00 34.55           C  
ATOM   9402  NE2 HIS H 113      31.225  32.098   3.236  1.00 37.14           N  
ATOM   9403  N   ASN H 114      26.409  32.807  -1.464  1.00 36.73           N  
ATOM   9404  CA  ASN H 114      25.458  32.070  -2.276  1.00 36.19           C  
ATOM   9405  C   ASN H 114      25.844  30.601  -2.311  1.00 36.90           C  
ATOM   9406  O   ASN H 114      27.008  30.280  -2.050  1.00 36.51           O  
ATOM   9407  CB  ASN H 114      25.392  32.638  -3.676  1.00 36.04           C  
ATOM   9408  CG  ASN H 114      24.462  33.777  -3.770  1.00 33.32           C  
ATOM   9409  OD1 ASN H 114      23.581  33.909  -2.967  1.00 33.35           O  
ATOM   9410  ND2 ASN H 114      24.649  34.616  -4.749  1.00 34.89           N  
ATOM   9411  N   PRO H 115      24.867  29.697  -2.568  1.00 37.47           N  
ATOM   9412  CA  PRO H 115      23.404  29.915  -2.807  1.00 37.14           C  
ATOM   9413  C   PRO H 115      22.572  30.196  -1.550  1.00 36.54           C  
ATOM   9414  O   PRO H 115      21.381  30.587  -1.640  1.00 37.07           O  
ATOM   9415  CB  PRO H 115      22.950  28.575  -3.415  1.00 37.21           C  
ATOM   9416  CG  PRO H 115      23.809  27.578  -2.734  1.00 38.79           C  
ATOM   9417  CD  PRO H 115      25.206  28.258  -2.618  1.00 37.77           C  
ATOM   9418  N   THR H 116      23.163  29.949  -0.395  1.00 35.06           N  
ATOM   9419  CA  THR H 116      22.495  30.177   0.858  1.00 34.71           C  
ATOM   9420  C   THR H 116      21.909  31.617   0.993  1.00 34.29           C  
ATOM   9421  O   THR H 116      20.726  31.794   1.329  1.00 32.71           O  
ATOM   9422  CB  THR H 116      23.416  29.766   2.029  1.00 34.36           C  
ATOM   9423  OG1 THR H 116      24.253  28.705   1.575  1.00 36.98           O  
ATOM   9424  CG2 THR H 116      22.642  29.293   3.263  1.00 31.08           C  
HETATM 9425  N   MSE H 117      22.719  32.621   0.727  1.00 34.59           N  
HETATM 9426  CA  MSE H 117      22.272  34.011   0.858  1.00 36.60           C  
HETATM 9427  C   MSE H 117      21.053  34.342  -0.015  1.00 35.58           C  
HETATM 9428  O   MSE H 117      20.108  34.952   0.472  1.00 35.46           O  
HETATM 9429  CB  MSE H 117      23.458  35.005   0.605  1.00 38.92           C  
HETATM 9430  CG  MSE H 117      23.247  36.463   1.079  1.00 41.27           C  
HETATM 9431 SE   MSE H 117      22.649  36.503   2.941  1.00 56.42          SE  
HETATM 9432  CE  MSE H 117      24.385  36.515   3.787  1.00 52.48           C  
ATOM   9433  N   GLU H 118      21.075  33.936  -1.285  1.00 35.17           N  
ATOM   9434  CA  GLU H 118      19.938  34.108  -2.194  1.00 35.28           C  
ATOM   9435  C   GLU H 118      18.690  33.261  -1.888  1.00 33.51           C  
ATOM   9436  O   GLU H 118      17.574  33.718  -2.034  1.00 33.32           O  
ATOM   9437  CB  GLU H 118      20.350  33.921  -3.654  1.00 36.65           C  
ATOM   9438  CG  GLU H 118      19.172  34.167  -4.636  1.00 41.65           C  
ATOM   9439  CD  GLU H 118      19.607  34.382  -6.097  1.00 48.86           C  
ATOM   9440  OE1 GLU H 118      20.816  34.531  -6.369  1.00 50.14           O  
ATOM   9441  OE2 GLU H 118      18.716  34.402  -6.985  1.00 55.58           O  
ATOM   9442  N   ALA H 119      18.863  32.024  -1.461  1.00 32.30           N  
ATOM   9443  CA  ALA H 119      17.715  31.259  -0.978  1.00 29.93           C  
ATOM   9444  C   ALA H 119      17.074  31.950   0.236  1.00 28.94           C  
ATOM   9445  O   ALA H 119      15.850  31.978   0.342  1.00 27.81           O  
ATOM   9446  CB  ALA H 119      18.087  29.797  -0.687  1.00 29.40           C  
ATOM   9447  N   THR H 120      17.896  32.560   1.108  1.00 28.89           N  
ATOM   9448  CA  THR H 120      17.402  33.299   2.310  1.00 28.30           C  
ATOM   9449  C   THR H 120      16.346  34.390   1.984  1.00 29.07           C  
ATOM   9450  O   THR H 120      15.206  34.348   2.492  1.00 28.95           O  
ATOM   9451  CB  THR H 120      18.559  33.825   3.243  1.00 27.93           C  
ATOM   9452  OG1 THR H 120      19.601  32.854   3.338  1.00 23.68           O  
ATOM   9453  CG2 THR H 120      18.043  34.103   4.673  1.00 25.54           C  
ATOM   9454  N   LEU H 121      16.731  35.300   1.107  1.00 29.99           N  
ATOM   9455  CA  LEU H 121      15.895  36.346   0.553  1.00 31.98           C  
ATOM   9456  C   LEU H 121      14.690  35.780  -0.169  1.00 33.36           C  
ATOM   9457  O   LEU H 121      13.585  36.247   0.081  1.00 32.70           O  
ATOM   9458  CB  LEU H 121      16.716  37.260  -0.400  1.00 32.07           C  
ATOM   9459  CG  LEU H 121      16.073  38.544  -0.998  1.00 33.55           C  
ATOM   9460  CD1 LEU H 121      15.467  39.520   0.089  1.00 31.07           C  
ATOM   9461  CD2 LEU H 121      17.034  39.302  -1.965  1.00 30.44           C  
ATOM   9462  N   GLU H 122      14.889  34.777  -1.033  1.00 35.22           N  
ATOM   9463  CA  GLU H 122      13.766  34.146  -1.720  1.00 38.29           C  
ATOM   9464  C   GLU H 122      12.704  33.701  -0.709  1.00 38.80           C  
ATOM   9465  O   GLU H 122      11.506  33.903  -0.928  1.00 38.57           O  
ATOM   9466  CB  GLU H 122      14.162  32.960  -2.631  1.00 39.01           C  
ATOM   9467  CG  GLU H 122      13.057  32.658  -3.687  1.00 42.38           C  
ATOM   9468  CD  GLU H 122      12.668  31.162  -3.790  1.00 50.97           C  
ATOM   9469  OE1 GLU H 122      13.338  30.340  -3.134  1.00 58.16           O  
ATOM   9470  OE2 GLU H 122      11.705  30.779  -4.515  1.00 51.20           O  
ATOM   9471  N   ALA H 123      13.150  33.097   0.393  1.00 39.53           N  
ATOM   9472  CA  ALA H 123      12.230  32.537   1.371  1.00 40.22           C  
ATOM   9473  C   ALA H 123      11.510  33.615   2.177  1.00 40.16           C  
ATOM   9474  O   ALA H 123      10.435  33.397   2.651  1.00 40.24           O  
ATOM   9475  CB  ALA H 123      12.944  31.508   2.278  1.00 40.21           C  
HETATM 9476  N   MSE H 124      12.103  34.789   2.309  1.00 41.56           N  
HETATM 9477  CA  MSE H 124      11.488  35.900   3.029  1.00 41.75           C  
HETATM 9478  C   MSE H 124      10.531  36.722   2.141  1.00 41.87           C  
HETATM 9479  O   MSE H 124       9.516  37.205   2.618  1.00 42.20           O  
HETATM 9480  CB  MSE H 124      12.565  36.812   3.604  1.00 42.44           C  
HETATM 9481  CG  MSE H 124      13.594  36.174   4.563  1.00 44.80           C  
HETATM 9482 SE   MSE H 124      15.125  37.404   5.108  1.00 53.53          SE  
HETATM 9483  CE  MSE H 124      14.203  38.583   6.366  1.00 47.15           C  
ATOM   9484  N   ILE H 125      10.825  36.876   0.850  1.00 41.45           N  
ATOM   9485  CA  ILE H 125      10.034  37.808   0.025  1.00 41.24           C  
ATOM   9486  C   ILE H 125       9.380  37.182  -1.162  1.00 42.42           C  
ATOM   9487  O   ILE H 125       8.513  37.798  -1.773  1.00 41.18           O  
ATOM   9488  CB  ILE H 125      10.841  39.091  -0.483  1.00 40.74           C  
ATOM   9489  CG1 ILE H 125      11.954  38.724  -1.513  1.00 37.61           C  
ATOM   9490  CG2 ILE H 125      11.259  39.967   0.687  1.00 37.88           C  
ATOM   9491  CD1 ILE H 125      12.684  39.938  -2.146  1.00 29.83           C  
ATOM   9492  N   GLY H 126       9.835  35.979  -1.503  1.00 44.58           N  
ATOM   9493  CA  GLY H 126       9.227  35.173  -2.564  1.00 47.14           C  
ATOM   9494  C   GLY H 126       9.934  35.401  -3.877  1.00 48.85           C  
ATOM   9495  O   GLY H 126      10.391  36.504  -4.147  1.00 47.60           O  
ATOM   9496  N   GLU H 127       9.998  34.348  -4.691  1.00 51.68           N  
ATOM   9497  CA  GLU H 127      10.637  34.360  -6.014  1.00 54.42           C  
ATOM   9498  C   GLU H 127      10.104  35.394  -7.015  1.00 54.66           C  
ATOM   9499  O   GLU H 127      10.833  35.833  -7.892  1.00 54.86           O  
ATOM   9500  CB  GLU H 127      10.598  32.962  -6.649  1.00 55.44           C  
ATOM   9501  CG  GLU H 127       9.218  32.446  -7.000  1.00 60.54           C  
ATOM   9502  CD  GLU H 127       9.278  31.127  -7.730  1.00 67.54           C  
ATOM   9503  OE1 GLU H 127       9.440  30.081  -7.059  1.00 70.45           O  
ATOM   9504  OE2 GLU H 127       9.159  31.130  -8.980  1.00 71.15           O  
ATOM   9505  N   ASP H 128       8.848  35.782  -6.899  1.00 55.15           N  
ATOM   9506  CA  ASP H 128       8.317  36.740  -7.843  1.00 55.91           C  
ATOM   9507  C   ASP H 128       8.960  38.109  -7.637  1.00 55.85           C  
ATOM   9508  O   ASP H 128       9.495  38.707  -8.570  1.00 54.57           O  
ATOM   9509  CB  ASP H 128       6.788  36.797  -7.770  1.00 55.72           C  
ATOM   9510  CG  ASP H 128       6.132  35.567  -8.372  1.00 55.24           C  
ATOM   9511  OD1 ASP H 128       6.617  35.069  -9.417  1.00 51.09           O  
ATOM   9512  OD2 ASP H 128       5.137  35.096  -7.780  1.00 53.07           O  
ATOM   9513  N   LEU H 129       8.914  38.571  -6.396  1.00 56.63           N  
ATOM   9514  CA  LEU H 129       9.546  39.818  -6.017  1.00 57.72           C  
ATOM   9515  C   LEU H 129      11.069  39.747  -6.097  1.00 57.66           C  
ATOM   9516  O   LEU H 129      11.697  40.729  -6.456  1.00 57.45           O  
ATOM   9517  CB  LEU H 129       9.105  40.246  -4.617  1.00 57.77           C  
ATOM   9518  CG  LEU H 129       9.330  41.705  -4.215  1.00 59.89           C  
ATOM   9519  CD1 LEU H 129      10.725  41.928  -3.715  1.00 61.11           C  
ATOM   9520  CD2 LEU H 129       9.019  42.693  -5.350  1.00 63.58           C  
ATOM   9521  N   LEU H 130      11.659  38.599  -5.758  1.00 57.99           N  
ATOM   9522  CA  LEU H 130      13.097  38.444  -5.861  1.00 58.32           C  
ATOM   9523  C   LEU H 130      13.542  38.601  -7.325  1.00 58.70           C  
ATOM   9524  O   LEU H 130      14.500  39.322  -7.608  1.00 57.43           O  
ATOM   9525  CB  LEU H 130      13.575  37.116  -5.249  1.00 58.49           C  
ATOM   9526  CG  LEU H 130      15.054  36.744  -5.467  1.00 57.73           C  
ATOM   9527  CD1 LEU H 130      15.674  36.254  -4.206  1.00 60.45           C  
ATOM   9528  CD2 LEU H 130      15.254  35.718  -6.559  1.00 56.46           C  
ATOM   9529  N   HIS H 131      12.822  37.943  -8.236  1.00 59.33           N  
ATOM   9530  CA  HIS H 131      13.098  38.038  -9.668  1.00 59.90           C  
ATOM   9531  C   HIS H 131      12.921  39.428 -10.261  1.00 58.92           C  
ATOM   9532  O   HIS H 131      13.704  39.821 -11.121  1.00 58.90           O  
ATOM   9533  CB  HIS H 131      12.274  37.027 -10.443  1.00 60.56           C  
ATOM   9534  CG  HIS H 131      12.886  35.670 -10.477  1.00 63.28           C  
ATOM   9535  ND1 HIS H 131      12.471  34.688 -11.352  1.00 67.31           N  
ATOM   9536  CD2 HIS H 131      13.892  35.130  -9.749  1.00 64.71           C  
ATOM   9537  CE1 HIS H 131      13.193  33.596 -11.153  1.00 69.08           C  
ATOM   9538  NE2 HIS H 131      14.067  33.842 -10.190  1.00 66.94           N  
ATOM   9539  N   ALA H 132      11.902  40.153  -9.794  1.00 57.78           N  
ATOM   9540  CA  ALA H 132      11.604  41.510 -10.255  1.00 56.74           C  
ATOM   9541  C   ALA H 132      12.650  42.513  -9.781  1.00 55.47           C  
ATOM   9542  O   ALA H 132      13.031  43.421 -10.528  1.00 54.26           O  
ATOM   9543  CB  ALA H 132      10.211  41.950  -9.808  1.00 56.77           C  
ATOM   9544  N   ALA H 133      13.092  42.333  -8.538  1.00 54.29           N  
ATOM   9545  CA  ALA H 133      14.131  43.153  -7.943  1.00 53.68           C  
ATOM   9546  C   ALA H 133      15.569  42.724  -8.315  1.00 53.22           C  
ATOM   9547  O   ALA H 133      16.440  43.561  -8.389  1.00 51.98           O  
ATOM   9548  CB  ALA H 133      13.945  43.245  -6.413  1.00 53.29           C  
ATOM   9549  N   LEU H 134      15.806  41.433  -8.525  1.00 53.98           N  
ATOM   9550  CA  LEU H 134      17.127  40.921  -8.914  1.00 55.62           C  
ATOM   9551  C   LEU H 134      17.078  39.963 -10.126  1.00 57.49           C  
ATOM   9552  O   LEU H 134      17.004  38.745  -9.949  1.00 56.98           O  
ATOM   9553  CB  LEU H 134      17.822  40.240  -7.731  1.00 55.16           C  
ATOM   9554  CG  LEU H 134      18.038  40.985  -6.413  1.00 55.57           C  
ATOM   9555  CD1 LEU H 134      18.651  40.059  -5.399  1.00 56.98           C  
ATOM   9556  CD2 LEU H 134      18.928  42.250  -6.574  1.00 58.18           C  
ATOM   9557  N   PRO H 135      17.148  40.519 -11.356  1.00 59.38           N  
ATOM   9558  CA  PRO H 135      17.021  39.801 -12.618  1.00 61.16           C  
ATOM   9559  C   PRO H 135      18.209  38.906 -12.955  1.00 62.10           C  
ATOM   9560  O   PRO H 135      18.086  38.019 -13.809  1.00 62.09           O  
ATOM   9561  CB  PRO H 135      16.934  40.930 -13.658  1.00 61.57           C  
ATOM   9562  CG  PRO H 135      16.722  42.179 -12.887  1.00 60.77           C  
ATOM   9563  CD  PRO H 135      17.386  41.951 -11.596  1.00 59.90           C  
ATOM   9564  N   SER H 136      19.351  39.163 -12.321  1.00 62.43           N  
ATOM   9565  CA  SER H 136      20.548  38.351 -12.532  1.00 62.94           C  
ATOM   9566  C   SER H 136      21.012  37.665 -11.241  1.00 62.13           C  
ATOM   9567  O   SER H 136      22.141  37.175 -11.149  1.00 62.16           O  
ATOM   9568  CB  SER H 136      21.690  39.143 -13.259  1.00 63.69           C  
ATOM   9569  OG  SER H 136      22.093  40.356 -12.607  1.00 61.56           O  
ATOM   9570  N   GLY H 137      20.119  37.624 -10.256  1.00 60.82           N  
ATOM   9571  CA  GLY H 137      20.379  36.953  -8.972  1.00 58.48           C  
ATOM   9572  C   GLY H 137      20.865  37.899  -7.890  1.00 55.95           C  
ATOM   9573  O   GLY H 137      20.638  39.097  -7.972  1.00 55.32           O  
ATOM   9574  N   PHE H 138      21.546  37.345  -6.888  1.00 53.78           N  
ATOM   9575  CA  PHE H 138      22.039  38.103  -5.722  1.00 50.78           C  
ATOM   9576  C   PHE H 138      23.547  38.361  -5.825  1.00 49.32           C  
ATOM   9577  O   PHE H 138      24.350  37.441  -5.658  1.00 48.14           O  
ATOM   9578  CB  PHE H 138      21.706  37.359  -4.421  1.00 49.84           C  
ATOM   9579  CG  PHE H 138      21.776  38.210  -3.194  1.00 46.91           C  
ATOM   9580  CD1 PHE H 138      22.900  38.973  -2.905  1.00 44.57           C  
ATOM   9581  CD2 PHE H 138      20.721  38.234  -2.295  1.00 45.49           C  
ATOM   9582  CE1 PHE H 138      22.958  39.757  -1.781  1.00 38.82           C  
ATOM   9583  CE2 PHE H 138      20.798  39.025  -1.170  1.00 41.73           C  
ATOM   9584  CZ  PHE H 138      21.922  39.772  -0.921  1.00 38.47           C  
ATOM   9585  N   PRO H 139      23.925  39.626  -6.093  1.00 48.69           N  
ATOM   9586  CA  PRO H 139      25.280  40.027  -6.451  1.00 48.10           C  
ATOM   9587  C   PRO H 139      26.241  40.163  -5.276  1.00 48.12           C  
ATOM   9588  O   PRO H 139      25.820  40.394  -4.136  1.00 48.37           O  
ATOM   9589  CB  PRO H 139      25.062  41.392  -7.107  1.00 47.43           C  
ATOM   9590  CG  PRO H 139      23.569  41.549  -7.212  1.00 47.63           C  
ATOM   9591  CD  PRO H 139      23.037  40.797  -6.094  1.00 48.31           C  
ATOM   9592  N   THR H 140      27.527  40.025  -5.576  1.00 48.51           N  
ATOM   9593  CA  THR H 140      28.608  40.279  -4.632  1.00 48.60           C  
ATOM   9594  C   THR H 140      28.597  41.665  -4.030  1.00 48.72           C  
ATOM   9595  O   THR H 140      28.594  42.678  -4.739  1.00 48.77           O  
ATOM   9596  CB  THR H 140      30.011  39.991  -5.218  1.00 48.48           C  
ATOM   9597  OG1 THR H 140      30.075  40.393  -6.595  1.00 48.53           O  
ATOM   9598  CG2 THR H 140      30.369  38.503  -5.070  1.00 47.91           C  
ATOM   9599  N   SER H 141      28.594  41.694  -2.700  1.00 48.66           N  
ATOM   9600  CA  SER H 141      28.513  42.945  -1.932  1.00 48.17           C  
ATOM   9601  C   SER H 141      27.118  43.550  -2.009  1.00 46.72           C  
ATOM   9602  O   SER H 141      26.895  44.669  -1.559  1.00 46.99           O  
ATOM   9603  CB  SER H 141      29.546  43.973  -2.396  1.00 48.27           C  
ATOM   9604  OG  SER H 141      29.629  45.007  -1.429  1.00 48.79           O  
ATOM   9605  N   GLY H 142      26.193  42.809  -2.599  1.00 44.77           N  
ATOM   9606  CA  GLY H 142      24.820  43.211  -2.620  1.00 41.70           C  
ATOM   9607  C   GLY H 142      24.288  43.064  -1.210  1.00 40.27           C  
ATOM   9608  O   GLY H 142      24.768  42.194  -0.417  1.00 37.28           O  
ATOM   9609  N   LEU H 143      23.304  43.934  -0.952  1.00 38.86           N  
ATOM   9610  CA  LEU H 143      22.688  44.169   0.341  1.00 38.04           C  
ATOM   9611  C   LEU H 143      21.156  44.304   0.257  1.00 37.83           C  
ATOM   9612  O   LEU H 143      20.633  45.193  -0.432  1.00 37.61           O  
ATOM   9613  CB  LEU H 143      23.264  45.437   0.973  1.00 37.51           C  
ATOM   9614  CG  LEU H 143      22.749  45.705   2.384  1.00 36.59           C  
ATOM   9615  CD1 LEU H 143      23.633  44.973   3.388  1.00 42.63           C  
ATOM   9616  CD2 LEU H 143      22.669  47.169   2.722  1.00 35.83           C  
ATOM   9617  N   ALA H 144      20.442  43.433   0.968  1.00 37.21           N  
ATOM   9618  CA  ALA H 144      18.995  43.580   1.100  1.00 37.11           C  
ATOM   9619  C   ALA H 144      18.700  44.143   2.474  1.00 36.48           C  
ATOM   9620  O   ALA H 144      19.306  43.743   3.463  1.00 34.78           O  
ATOM   9621  CB  ALA H 144      18.269  42.254   0.907  1.00 36.90           C  
ATOM   9622  N   VAL H 145      17.757  45.078   2.495  1.00 36.65           N  
ATOM   9623  CA  VAL H 145      17.260  45.706   3.684  1.00 36.56           C  
ATOM   9624  C   VAL H 145      15.792  45.259   3.833  1.00 37.07           C  
ATOM   9625  O   VAL H 145      14.968  45.490   2.944  1.00 35.73           O  
ATOM   9626  CB  VAL H 145      17.350  47.258   3.569  1.00 36.88           C  
ATOM   9627  CG1 VAL H 145      17.196  47.877   4.933  1.00 41.09           C  
ATOM   9628  CG2 VAL H 145      18.675  47.752   2.967  1.00 34.43           C  
ATOM   9629  N   LEU H 146      15.453  44.613   4.951  1.00 37.67           N  
ATOM   9630  CA  LEU H 146      14.092  44.104   5.118  1.00 38.33           C  
ATOM   9631  C   LEU H 146      13.464  44.513   6.424  1.00 40.82           C  
ATOM   9632  O   LEU H 146      14.089  44.484   7.475  1.00 40.18           O  
ATOM   9633  CB  LEU H 146      14.043  42.587   4.967  1.00 37.48           C  
ATOM   9634  CG  LEU H 146      14.478  42.115   3.587  1.00 33.64           C  
ATOM   9635  CD1 LEU H 146      15.593  41.091   3.682  1.00 31.10           C  
ATOM   9636  CD2 LEU H 146      13.281  41.607   2.839  1.00 35.15           C  
ATOM   9637  N   ASP H 147      12.207  44.901   6.333  1.00 44.08           N  
ATOM   9638  CA  ASP H 147      11.424  45.275   7.482  1.00 47.57           C  
ATOM   9639  C   ASP H 147      10.246  44.321   7.658  1.00 49.03           C  
ATOM   9640  O   ASP H 147       9.863  43.627   6.730  1.00 48.10           O  
ATOM   9641  CB  ASP H 147      10.934  46.713   7.339  1.00 47.51           C  
ATOM   9642  CG  ASP H 147      11.714  47.676   8.184  1.00 50.61           C  
ATOM   9643  OD1 ASP H 147      12.211  47.256   9.266  1.00 53.08           O  
ATOM   9644  OD2 ASP H 147      11.824  48.865   7.773  1.00 52.46           O  
ATOM   9645  N   GLN H 148       9.676  44.309   8.852  1.00 51.73           N  
ATOM   9646  CA  GLN H 148       8.449  43.581   9.073  1.00 55.51           C  
ATOM   9647  C   GLN H 148       7.201  44.303   8.560  1.00 58.75           C  
ATOM   9648  O   GLN H 148       7.249  45.478   8.230  1.00 58.61           O  
ATOM   9649  CB  GLN H 148       8.299  43.224  10.532  1.00 54.42           C  
ATOM   9650  CG  GLN H 148       9.321  42.270  11.004  1.00 48.14           C  
ATOM   9651  CD  GLN H 148       9.010  41.836  12.397  1.00 43.56           C  
ATOM   9652  OE1 GLN H 148       9.906  41.494  13.175  1.00 36.66           O  
ATOM   9653  NE2 GLN H 148       7.724  41.871  12.744  1.00 38.15           N  
ATOM   9654  N   ASP H 149       6.091  43.561   8.527  1.00 62.94           N  
ATOM   9655  CA  ASP H 149       4.798  43.957   7.930  1.00 65.67           C  
ATOM   9656  C   ASP H 149       4.557  43.191   6.636  1.00 66.15           C  
ATOM   9657  O   ASP H 149       3.640  43.499   5.878  1.00 67.03           O  
ATOM   9658  CB  ASP H 149       4.715  45.460   7.667  1.00 66.51           C  
ATOM   9659  CG  ASP H 149       4.131  46.221   8.821  1.00 68.72           C  
ATOM   9660  OD1 ASP H 149       4.399  45.872   9.988  1.00 68.19           O  
ATOM   9661  OD2 ASP H 149       3.401  47.198   8.550  1.00 73.57           O  
ATOM   9662  N   LYS H 156      -1.160  39.300   9.436  1.00 66.89           N  
ATOM   9663  CA  LYS H 156      -0.436  38.246   8.730  1.00 66.97           C  
ATOM   9664  C   LYS H 156       0.993  38.735   8.419  1.00 64.83           C  
ATOM   9665  O   LYS H 156       1.288  39.121   7.286  1.00 64.38           O  
ATOM   9666  CB  LYS H 156      -1.218  37.834   7.463  1.00 67.57           C  
ATOM   9667  CG  LYS H 156      -0.820  36.485   6.816  1.00 68.91           C  
ATOM   9668  CD  LYS H 156      -1.669  36.161   5.536  1.00 66.62           C  
ATOM   9669  CE  LYS H 156      -1.069  34.965   4.785  1.00 65.93           C  
ATOM   9670  NZ  LYS H 156      -1.716  34.584   3.493  1.00 62.10           N  
ATOM   9671  N   ASN H 157       1.860  38.717   9.438  1.00 62.11           N  
ATOM   9672  CA  ASN H 157       3.242  39.268   9.356  1.00 58.54           C  
ATOM   9673  C   ASN H 157       4.113  38.613   8.275  1.00 56.40           C  
ATOM   9674  O   ASN H 157       4.095  37.397   8.079  1.00 55.58           O  
ATOM   9675  CB  ASN H 157       3.955  39.229  10.725  1.00 57.89           C  
ATOM   9676  CG  ASN H 157       4.863  40.453  10.981  1.00 55.22           C  
ATOM   9677  OD1 ASN H 157       5.504  40.559  12.027  1.00 47.15           O  
ATOM   9678  ND2 ASN H 157       4.891  41.386  10.040  1.00 54.14           N  
ATOM   9679  N   ARG H 158       4.843  39.453   7.552  1.00 53.97           N  
ATOM   9680  CA  ARG H 158       5.768  39.004   6.511  1.00 51.15           C  
ATOM   9681  C   ARG H 158       6.885  40.017   6.336  1.00 49.75           C  
ATOM   9682  O   ARG H 158       6.710  41.182   6.646  1.00 48.59           O  
ATOM   9683  CB  ARG H 158       5.052  38.747   5.181  1.00 50.79           C  
ATOM   9684  CG  ARG H 158       4.160  39.861   4.713  1.00 47.76           C  
ATOM   9685  CD  ARG H 158       3.912  39.698   3.256  1.00 44.06           C  
ATOM   9686  NE  ARG H 158       3.051  40.746   2.728  1.00 41.65           N  
ATOM   9687  CZ  ARG H 158       3.179  41.280   1.518  1.00 41.02           C  
ATOM   9688  NH1 ARG H 158       4.152  40.891   0.698  1.00 38.35           N  
ATOM   9689  NH2 ARG H 158       2.327  42.216   1.124  1.00 43.75           N  
ATOM   9690  N   TRP H 159       8.040  39.546   5.877  1.00 48.29           N  
ATOM   9691  CA  TRP H 159       9.175  40.411   5.601  1.00 46.84           C  
ATOM   9692  C   TRP H 159       8.902  41.226   4.362  1.00 46.78           C  
ATOM   9693  O   TRP H 159       8.316  40.732   3.405  1.00 46.67           O  
ATOM   9694  CB  TRP H 159      10.443  39.573   5.436  1.00 46.07           C  
ATOM   9695  CG  TRP H 159      10.847  38.965   6.740  1.00 43.60           C  
ATOM   9696  CD1 TRP H 159      10.701  37.657   7.130  1.00 40.22           C  
ATOM   9697  CD2 TRP H 159      11.413  39.657   7.855  1.00 40.33           C  
ATOM   9698  NE1 TRP H 159      11.146  37.495   8.413  1.00 34.48           N  
ATOM   9699  CE2 TRP H 159      11.601  38.696   8.887  1.00 36.19           C  
ATOM   9700  CE3 TRP H 159      11.794  41.000   8.082  1.00 38.48           C  
ATOM   9701  CZ2 TRP H 159      12.141  39.025  10.130  1.00 32.76           C  
ATOM   9702  CZ3 TRP H 159      12.331  41.339   9.312  1.00 38.49           C  
ATOM   9703  CH2 TRP H 159      12.491  40.346  10.334  1.00 38.91           C  
ATOM   9704  N   ARG H 160       9.295  42.493   4.387  1.00 46.78           N  
ATOM   9705  CA  ARG H 160       9.159  43.336   3.197  1.00 46.62           C  
ATOM   9706  C   ARG H 160      10.524  43.842   2.762  1.00 45.84           C  
ATOM   9707  O   ARG H 160      11.320  44.262   3.574  1.00 44.02           O  
ATOM   9708  CB  ARG H 160       8.144  44.486   3.388  1.00 46.73           C  
ATOM   9709  CG  ARG H 160       6.759  44.094   3.915  1.00 47.40           C  
ATOM   9710  CD  ARG H 160       5.804  43.539   2.825  1.00 53.17           C  
ATOM   9711  NE  ARG H 160       5.044  44.611   2.147  1.00 57.08           N  
ATOM   9712  CZ  ARG H 160       4.593  44.543   0.894  1.00 59.11           C  
ATOM   9713  NH1 ARG H 160       4.788  43.470   0.142  1.00 62.04           N  
ATOM   9714  NH2 ARG H 160       3.964  45.564   0.369  1.00 63.21           N  
ATOM   9715  N   LEU H 161      10.800  43.737   1.473  1.00 46.29           N  
ATOM   9716  CA  LEU H 161      11.984  44.331   0.919  1.00 47.55           C  
ATOM   9717  C   LEU H 161      11.695  45.845   0.900  1.00 48.78           C  
ATOM   9718  O   LEU H 161      10.571  46.261   0.574  1.00 48.39           O  
ATOM   9719  CB  LEU H 161      12.265  43.761  -0.478  1.00 47.03           C  
ATOM   9720  CG  LEU H 161      13.426  44.358  -1.283  1.00 47.46           C  
ATOM   9721  CD1 LEU H 161      14.807  43.772  -0.965  1.00 43.95           C  
ATOM   9722  CD2 LEU H 161      13.125  44.172  -2.741  1.00 51.25           C  
ATOM   9723  N   ILE H 162      12.671  46.637   1.343  1.00 49.61           N  
ATOM   9724  CA  ILE H 162      12.515  48.090   1.435  1.00 52.17           C  
ATOM   9725  C   ILE H 162      13.603  48.811   0.682  1.00 52.54           C  
ATOM   9726  O   ILE H 162      13.439  49.972   0.336  1.00 53.10           O  
ATOM   9727  CB  ILE H 162      12.454  48.648   2.903  1.00 52.30           C  
ATOM   9728  CG1 ILE H 162      13.831  48.582   3.569  1.00 51.74           C  
ATOM   9729  CG2 ILE H 162      11.292  47.990   3.696  1.00 54.22           C  
ATOM   9730  CD1 ILE H 162      13.878  47.770   4.859  1.00 52.36           C  
ATOM   9731  N   ASP H 163      14.712  48.122   0.438  1.00 53.23           N  
ATOM   9732  CA  ASP H 163      15.776  48.661  -0.390  1.00 54.28           C  
ATOM   9733  C   ASP H 163      16.792  47.580  -0.684  1.00 54.42           C  
ATOM   9734  O   ASP H 163      16.920  46.639   0.083  1.00 54.51           O  
ATOM   9735  CB  ASP H 163      16.437  49.860   0.313  1.00 54.38           C  
ATOM   9736  CG  ASP H 163      17.430  50.587  -0.563  1.00 53.18           C  
ATOM   9737  OD1 ASP H 163      17.351  50.447  -1.802  1.00 50.94           O  
ATOM   9738  OD2 ASP H 163      18.290  51.296   0.011  1.00 50.60           O  
ATOM   9739  N   PHE H 164      17.487  47.730  -1.810  1.00 54.69           N  
ATOM   9740  CA  PHE H 164      18.597  46.877  -2.191  1.00 54.73           C  
ATOM   9741  C   PHE H 164      19.811  47.655  -2.732  1.00 54.22           C  
ATOM   9742  O   PHE H 164      19.741  48.296  -3.781  1.00 54.02           O  
ATOM   9743  CB  PHE H 164      18.158  45.856  -3.229  1.00 55.25           C  
ATOM   9744  CG  PHE H 164      19.060  44.673  -3.307  1.00 57.35           C  
ATOM   9745  CD1 PHE H 164      20.215  44.717  -4.064  1.00 59.57           C  
ATOM   9746  CD2 PHE H 164      18.754  43.508  -2.596  1.00 61.94           C  
ATOM   9747  CE1 PHE H 164      21.074  43.617  -4.130  1.00 64.89           C  
ATOM   9748  CE2 PHE H 164      19.601  42.376  -2.641  1.00 64.06           C  
ATOM   9749  CZ  PHE H 164      20.767  42.424  -3.410  1.00 65.42           C  
ATOM   9750  N   LEU H 165      20.935  47.575  -2.035  1.00 53.63           N  
ATOM   9751  CA  LEU H 165      22.159  48.176  -2.554  1.00 53.39           C  
ATOM   9752  C   LEU H 165      23.042  47.153  -3.286  1.00 53.96           C  
ATOM   9753  O   LEU H 165      23.203  46.008  -2.863  1.00 53.39           O  
ATOM   9754  CB  LEU H 165      22.896  49.005  -1.493  1.00 52.02           C  
ATOM   9755  CG  LEU H 165      22.040  49.999  -0.675  1.00 50.68           C  
ATOM   9756  CD1 LEU H 165      22.915  50.891   0.239  1.00 47.64           C  
ATOM   9757  CD2 LEU H 165      21.080  50.842  -1.525  1.00 44.56           C  
ATOM   9758  N   ALA H 166      23.529  47.575  -4.448  1.00 55.20           N  
ATOM   9759  CA  ALA H 166      24.400  46.764  -5.295  1.00 56.09           C  
ATOM   9760  C   ALA H 166      25.252  47.706  -6.112  1.00 56.02           C  
ATOM   9761  O   ALA H 166      24.817  48.815  -6.385  1.00 55.96           O  
ATOM   9762  CB  ALA H 166      23.579  45.845  -6.225  1.00 56.58           C  
ATOM   9763  N   PRO H 167      26.486  47.292  -6.446  1.00 56.17           N  
ATOM   9764  CA  PRO H 167      27.288  47.926  -7.487  1.00 56.53           C  
ATOM   9765  C   PRO H 167      26.829  47.550  -8.908  1.00 56.65           C  
ATOM   9766  O   PRO H 167      26.376  46.421  -9.168  1.00 56.20           O  
ATOM   9767  CB  PRO H 167      28.699  47.380  -7.219  1.00 56.49           C  
ATOM   9768  CG  PRO H 167      28.636  46.768  -5.852  1.00 56.62           C  
ATOM   9769  CD  PRO H 167      27.247  46.226  -5.784  1.00 56.16           C  
TER    9770      PRO H 167                                                      
END
MOLECULE T0394.pdb
ATOM      1  N   ASN     1       7.131  28.263  26.435  1.00 37.08           N  
ATOM      2  CA  ASN     1       7.437  29.315  25.416  1.00 36.05           C  
ATOM      3  C   ASN     1       7.192  30.735  25.903  1.00 34.53           C  
ATOM      4  O   ASN     1       6.216  30.997  26.611  1.00 34.93           O  
ATOM      5  CB  ASN     1       6.662  29.047  24.125  1.00 37.00           C  
ATOM      6  CG  ASN     1       7.395  28.086  23.213  1.00 39.47           C  
ATOM      7  OD1 ASN     1       7.200  26.869  23.286  1.00 43.62           O  
ATOM      8  ND2 ASN     1       8.288  28.624  22.384  1.00 40.23           N  
ATOM      9  N   LEU     2       8.082  31.640  25.492  1.00 32.19           N  
ATOM     10  CA  LEU     2       8.122  33.016  25.993  1.00 29.95           C  
ATOM     11  C   LEU     2       7.110  33.917  25.298  1.00 28.07           C  
ATOM     12  O   LEU     2       6.983  33.894  24.068  1.00 28.29           O  
ATOM     13  CB  LEU     2       9.527  33.600  25.804  1.00 29.69           C  
ATOM     14  CG  LEU     2      10.670  32.930  26.564  1.00 29.92           C  
ATOM     15  CD1 LEU     2      12.000  33.222  25.886  1.00 29.23           C  
ATOM     16  CD2 LEU     2      10.663  33.446  27.989  1.00 28.60           C  
ATOM     17  N   TYR     3       6.407  34.722  26.095  1.00 25.72           N  
ATOM     18  CA  TYR     3       5.529  35.769  25.587  1.00 24.38           C  
ATOM     19  C   TYR     3       6.320  37.041  25.320  1.00 23.44           C  
ATOM     20  O   TYR     3       7.033  37.574  26.203  1.00 21.70           O  
ATOM     21  CB  TYR     3       4.386  36.067  26.569  1.00 24.95           C  
ATOM     22  CG  TYR     3       3.542  37.283  26.201  1.00 24.49           C  
ATOM     23  CD1 TYR     3       2.296  37.140  25.578  1.00 25.41           C  
ATOM     24  CD2 TYR     3       3.986  38.574  26.489  1.00 24.54           C  
ATOM     25  CE1 TYR     3       1.528  38.265  25.239  1.00 26.31           C  
ATOM     26  CE2 TYR     3       3.232  39.700  26.154  1.00 24.99           C  
ATOM     27  CZ  TYR     3       2.015  39.541  25.528  1.00 26.12           C  
ATOM     28  OH  TYR     3       1.282  40.675  25.217  1.00 29.19           O  
ATOM     29  N   PHE     4       6.198  37.532  24.092  1.00 21.28           N  
ATOM     30  CA  PHE     4       6.804  38.796  23.732  1.00 21.92           C  
ATOM     31  C   PHE     4       5.758  39.769  23.248  1.00 22.33           C  
ATOM     32  O   PHE     4       4.744  39.358  22.707  1.00 21.26           O  
ATOM     33  CB  PHE     4       7.841  38.598  22.620  1.00 21.80           C  
ATOM     34  CG  PHE     4       9.019  37.763  23.036  1.00 20.69           C  
ATOM     35  CD1 PHE     4       9.930  38.245  23.973  1.00 18.93           C  
ATOM     36  CD2 PHE     4       9.209  36.497  22.501  1.00 21.68           C  
ATOM     37  CE1 PHE     4      11.035  37.458  24.352  1.00 20.05           C  
ATOM     38  CE2 PHE     4      10.302  35.717  22.866  1.00 22.45           C  
ATOM     39  CZ  PHE     4      11.222  36.218  23.803  1.00 21.82           C  
ATOM     40  N   GLN     5       6.032  41.054  23.450  1.00 22.99           N  
ATOM     41  CA  GLN     5       5.226  42.107  22.871  1.00 24.75           C  
ATOM     42  C   GLN     5       5.521  42.151  21.367  1.00 23.85           C  
ATOM     43  O   GLN     5       6.451  41.461  20.899  1.00 23.54           O  
ATOM     44  CB  GLN     5       5.532  43.444  23.553  1.00 26.07           C  
ATOM     45  CG  GLN     5       5.034  43.473  25.022  1.00 31.04           C  
ATOM     46  CD  GLN     5       4.811  44.878  25.566  1.00 37.81           C  
ATOM     47  OE1 GLN     5       5.661  45.777  25.403  1.00 41.06           O  
ATOM     48  NE2 GLN     5       3.660  45.079  26.215  1.00 38.49           N  
ATOM     49  N   SER     6       4.726  42.924  20.628  1.00 23.52           N  
ATOM     50  CA  SER     6       4.940  43.126  19.191  0.50 23.55           C  
ATOM     52  C   SER     6       6.337  43.702  18.962  1.00 22.75           C  
ATOM     53  O   SER     6       6.858  44.463  19.805  1.00 22.96           O  
ATOM     54  CB  SER     6       3.856  44.057  18.638  0.50 23.94           C  
ATOM     56  OG  SER     6       3.940  44.174  17.233  0.50 25.41           O  
ATOM     58  N   ALA     7       6.977  43.335  17.852  1.00 21.09           N  
ATOM     59  CA  ALA     7       8.341  43.796  17.589  1.00 19.34           C  
ATOM     60  C   ALA     7       8.616  43.806  16.096  1.00 18.62           C  
ATOM     61  O   ALA     7       7.962  43.078  15.352  1.00 17.81           O  
ATOM     62  CB  ALA     7       9.361  42.902  18.314  1.00 18.58           C  
ATOM     63  N   ARG     8       9.540  44.662  15.692  1.00 17.77           N  
ATOM     64  CA  ARG     8       9.981  44.808  14.311  1.00 18.09           C  
ATOM     65  C   ARG     8      11.475  45.003  14.342  1.00 17.38           C  
ATOM     66  O   ARG     8      11.988  45.711  15.227  1.00 16.45           O  
ATOM     67  CB  ARG     8       9.398  46.071  13.683  1.00 19.36           C  
ATOM     68  CG  ARG     8       7.946  46.007  13.335  1.00 23.70           C  
ATOM     69  CD  ARG     8       7.465  47.406  12.982  1.00 28.18           C  
ATOM     70  NE  ARG     8       7.941  47.887  11.680  1.00 30.83           N  
ATOM     71  CZ  ARG     8       8.710  48.960  11.501  1.00 30.42           C  
ATOM     72  NH1 ARG     8       9.117  49.682  12.536  1.00 32.52           N  
ATOM     73  NH2 ARG     8       9.060  49.316  10.274  1.00 29.09           N  
ATOM     74  N   PHE     9      12.184  44.376  13.397  1.00 15.44           N  
ATOM     75  CA  PHE     9      13.609  44.661  13.228  1.00 14.36           C  
ATOM     76  C   PHE     9      14.024  44.617  11.750  1.00 14.07           C  
ATOM     77  O   PHE     9      13.327  44.021  10.922  1.00 14.11           O  
ATOM     78  CB  PHE     9      14.503  43.808  14.139  1.00 14.06           C  
ATOM     79  CG  PHE     9      14.646  42.339  13.723  1.00 14.99           C  
ATOM     80  CD1 PHE     9      15.716  41.917  12.893  1.00 14.73           C  
ATOM     81  CD2 PHE     9      13.778  41.373  14.237  1.00 14.99           C  
ATOM     82  CE1 PHE     9      15.873  40.529  12.575  1.00 15.03           C  
ATOM     83  CE2 PHE     9      13.931  40.017  13.902  1.00 13.86           C  
ATOM     84  CZ  PHE     9      14.979  39.616  13.065  1.00 15.53           C  
ATOM     85  N   ALA    10      15.107  45.315  11.432  1.00 13.59           N  
ATOM     86  CA  ALA    10      15.614  45.381  10.074  1.00 13.29           C  
ATOM     87  C   ALA    10      16.736  44.351   9.943  1.00 12.11           C  
ATOM     88  O   ALA    10      17.515  44.114  10.867  1.00 12.79           O  
ATOM     89  CB  ALA    10      16.127  46.747   9.770  1.00 13.92           C  
ATOM     90  N   LEU    11      16.820  43.776   8.765  1.00 11.89           N  
ATOM     91  CA  LEU    11      17.884  42.825   8.461  1.00 11.66           C  
ATOM     92  C   LEU    11      18.479  43.206   7.106  1.00 11.25           C  
ATOM     93  O   LEU    11      17.791  43.100   6.088  1.00 11.70           O  
ATOM     94  CB  LEU    11      17.268  41.424   8.382  1.00 11.80           C  
ATOM     95  CG  LEU    11      18.199  40.311   7.867  1.00 11.81           C  
ATOM     96  CD1 LEU    11      19.499  40.184   8.709  1.00 11.54           C  
ATOM     97  CD2 LEU    11      17.431  38.946   7.835  1.00 11.16           C  
ATOM     98  N   THR    12      19.739  43.651   7.093  1.00 11.06           N  
ATOM     99  CA  THR    12      20.437  43.941   5.843  1.00 10.80           C  
ATOM    100  C   THR    12      21.431  42.812   5.554  1.00 10.75           C  
ATOM    101  O   THR    12      22.268  42.492   6.427  1.00 10.78           O  
ATOM    102  CB  THR    12      21.207  45.258   5.979  1.00 12.04           C  
ATOM    103  OG1 THR    12      20.261  46.309   6.268  1.00 13.87           O  
ATOM    104  CG2 THR    12      21.944  45.545   4.716  1.00 11.84           C  
ATOM    105  N   VAL    13      21.329  42.215   4.366  1.00 10.59           N  
ATOM    106  CA  VAL    13      22.159  41.059   3.976  1.00 10.00           C  
ATOM    107  C   VAL    13      23.009  41.448   2.754  1.00 10.55           C  
ATOM    108  O   VAL    13      22.471  41.918   1.733  1.00 10.36           O  
ATOM    109  CB  VAL    13      21.256  39.828   3.638  1.00 10.02           C  
ATOM    110  CG1 VAL    13      22.153  38.561   3.516  1.00  9.93           C  
ATOM    111  CG2 VAL    13      20.243  39.644   4.736  1.00 12.14           C  
ATOM    112  N   VAL    14      24.327  41.288   2.872  1.00 10.61           N  
ATOM    113  CA  VAL    14      25.251  41.780   1.877  1.00 10.14           C  
ATOM    114  C   VAL    14      26.202  40.645   1.457  1.00 10.94           C  
ATOM    115  O   VAL    14      26.790  40.007   2.325  1.00 10.94           O  
ATOM    116  CB  VAL    14      26.075  42.959   2.446  1.00 11.36           C  
ATOM    117  CG1 VAL    14      27.056  43.456   1.382  1.00  9.89           C  
ATOM    118  CG2 VAL    14      25.134  44.137   2.849  1.00 12.81           C  
ATOM    119  N   ARG    15      26.318  40.368   0.158  1.00 10.04           N  
ATOM    120  CA  ARG    15      27.289  39.336  -0.282  1.00 10.79           C  
ATOM    121  C   ARG    15      28.699  39.909  -0.117  1.00 10.29           C  
ATOM    122  O   ARG    15      28.904  41.106  -0.283  1.00 11.57           O  
ATOM    123  CB  ARG    15      27.048  38.936  -1.768  1.00  9.43           C  
ATOM    124  CG  ARG    15      28.024  37.834  -2.263  1.00 11.35           C  
ATOM    125  CD  ARG    15      27.585  37.222  -3.602  1.00 12.46           C  
ATOM    126  NE  ARG    15      28.624  36.330  -4.093  1.00 13.39           N  
ATOM    127  CZ  ARG    15      29.143  36.335  -5.318  1.00 15.37           C  
ATOM    128  NH1 ARG    15      28.674  37.137  -6.260  1.00 14.12           N  
ATOM    129  NH2 ARG    15      30.131  35.500  -5.608  1.00 13.89           N  
ATOM    130  N   HIS    16      29.679  39.062   0.166  1.00 11.14           N  
ATOM    131  CA  HIS    16      31.080  39.515   0.244  1.00 11.40           C  
ATOM    132  C   HIS    16      31.557  40.087  -1.118  1.00 12.40           C  
ATOM    133  O   HIS    16      30.975  39.795  -2.202  1.00 12.27           O  
ATOM    134  CB  HIS    16      31.969  38.326   0.622  1.00 11.89           C  
ATOM    135  CG  HIS    16      31.909  37.244  -0.383  1.00 11.77           C  
ATOM    136  ND1 HIS    16      32.675  37.259  -1.532  1.00 10.88           N  
ATOM    137  CD2 HIS    16      31.113  36.155  -0.466  1.00 14.23           C  
ATOM    138  CE1 HIS    16      32.387  36.191  -2.256  1.00 16.26           C  
ATOM    139  NE2 HIS    16      31.442  35.506  -1.630  1.00 14.39           N  
ATOM    140  N   GLY    17      32.636  40.876  -1.055  1.00 12.57           N  
ATOM    141  CA  GLY    17      33.265  41.387  -2.260  1.00 12.64           C  
ATOM    142  C   GLY    17      33.923  40.326  -3.120  1.00 13.60           C  
ATOM    143  O   GLY    17      34.100  39.176  -2.698  1.00 12.67           O  
ATOM    144  N   GLU    18      34.245  40.696  -4.356  1.00 12.79           N  
ATOM    145  CA  GLU    18      34.855  39.768  -5.308  1.00 14.33           C  
ATOM    146  C   GLU    18      36.181  39.161  -4.816  1.00 14.19           C  
ATOM    147  O   GLU    18      36.985  39.853  -4.170  1.00 13.24           O  
ATOM    148  CB  GLU    18      35.072  40.498  -6.641  1.00 15.58           C  
ATOM    149  CG  GLU    18      35.615  39.646  -7.737  1.00 18.58           C  
ATOM    150  CD  GLU    18      36.423  40.473  -8.747  1.00 26.24           C  
ATOM    151  OE1 GLU    18      37.548  40.925  -8.432  1.00 28.76           O  
ATOM    152  OE2 GLU    18      35.935  40.634  -9.857  1.00 27.17           O  
ATOM    153  N   THR    19      36.361  37.856  -5.065  1.00 14.63           N  
ATOM    154  CA  THR    19      37.661  37.193  -4.893  1.00 15.69           C  
ATOM    155  C   THR    19      38.223  36.845  -6.260  1.00 16.12           C  
ATOM    156  O   THR    19      37.525  36.893  -7.282  1.00 15.11           O  
ATOM    157  CB  THR    19      37.572  35.837  -4.120  1.00 14.87           C  
ATOM    158  OG1 THR    19      36.910  34.873  -4.955  1.00 16.55           O  
ATOM    159  CG2 THR    19      36.837  35.983  -2.742  1.00 12.93           C  
ATOM    160  N   ARG    20      39.495  36.453  -6.260  1.00 16.97           N  
ATOM    161  CA  ARG    20      40.161  35.912  -7.443  1.00 18.93           C  
ATOM    162  C   ARG    20      39.322  34.822  -8.158  1.00 19.29           C  
ATOM    163  O   ARG    20      39.202  34.812  -9.396  1.00 20.04           O  
ATOM    164  CB  ARG    20      41.546  35.408  -6.992  1.00 19.32           C  
ATOM    165  CG  ARG    20      42.275  34.361  -7.777  1.00 22.18           C  
ATOM    166  CD  ARG    20      43.709  34.338  -7.214  1.00 21.66           C  
ATOM    167  NE  ARG    20      43.840  33.443  -6.063  1.00 20.51           N  
ATOM    168  CZ  ARG    20      44.436  32.262  -6.102  1.00 22.87           C  
ATOM    169  NH1 ARG    20      44.481  31.517  -5.016  1.00 24.91           N  
ATOM    170  NH2 ARG    20      44.975  31.823  -7.228  1.00 23.22           N  
ATOM    171  N   PHE    21      38.714  33.939  -7.373  1.00 17.76           N  
ATOM    172  CA  PHE    21      37.948  32.834  -7.941  1.00 17.97           C  
ATOM    173  C   PHE    21      36.604  33.277  -8.506  1.00 17.74           C  
ATOM    174  O   PHE    21      36.151  32.759  -9.544  1.00 16.99           O  
ATOM    175  CB  PHE    21      37.833  31.701  -6.911  1.00 19.01           C  
ATOM    176  CG  PHE    21      39.181  31.131  -6.530  1.00 20.00           C  
ATOM    177  CD1 PHE    21      40.117  30.838  -7.512  1.00 23.92           C  
ATOM    178  CD2 PHE    21      39.525  30.940  -5.202  1.00 24.47           C  
ATOM    179  CE1 PHE    21      41.375  30.310  -7.171  1.00 24.93           C  
ATOM    180  CE2 PHE    21      40.774  30.412  -4.859  1.00 25.63           C  
ATOM    181  CZ  PHE    21      41.691  30.099  -5.842  1.00 24.75           C  
ATOM    182  N   ASN    22      35.962  34.229  -7.840  1.00 17.57           N  
ATOM    183  CA  ASN    22      34.719  34.794  -8.414  1.00 18.52           C  
ATOM    184  C   ASN    22      34.988  35.351  -9.818  1.00 19.89           C  
ATOM    185  O   ASN    22      34.228  35.105 -10.771  1.00 19.51           O  
ATOM    186  CB  ASN    22      34.190  35.907  -7.554  1.00 18.37           C  
ATOM    187  CG  ASN    22      33.602  35.407  -6.245  1.00 19.37           C  
ATOM    188  OD1 ASN    22      33.150  34.237  -6.104  1.00 18.97           O  
ATOM    189  ND2 ASN    22      33.568  36.286  -5.301  1.00 13.55           N  
ATOM    190  N   LYS    23      36.093  36.074  -9.948  1.00 20.75           N  
ATOM    191  CA  LYS    23      36.443  36.692 -11.235  1.00 23.46           C  
ATOM    192  C   LYS    23      36.623  35.624 -12.306  1.00 24.29           C  
ATOM    193  O   LYS    23      36.138  35.776 -13.428  1.00 25.47           O  
ATOM    194  CB  LYS    23      37.690  37.556 -11.072  1.00 23.52           C  
ATOM    195  CG  LYS    23      38.222  38.212 -12.349  1.00 27.47           C  
ATOM    196  CD  LYS    23      37.326  39.322 -12.822  1.00 32.44           C  
ATOM    197  CE  LYS    23      38.108  40.299 -13.700  1.00 35.21           C  
ATOM    198  NZ  LYS    23      37.221  41.431 -14.082  1.00 39.24           N  
ATOM    199  N   GLU    24      37.280  34.531 -11.936  1.00 25.02           N  
ATOM    200  CA  GLU    24      37.646  33.470 -12.881  1.00 26.99           C  
ATOM    201  C   GLU    24      36.574  32.393 -13.025  1.00 26.34           C  
ATOM    202  O   GLU    24      36.802  31.393 -13.728  1.00 27.71           O  
ATOM    203  CB  GLU    24      38.981  32.836 -12.465  1.00 27.65           C  
ATOM    204  CG  GLU    24      40.141  33.811 -12.232  1.00 30.31           C  
ATOM    205  CD  GLU    24      40.401  34.779 -13.408  1.00 36.92           C  
ATOM    206  OE1 GLU    24      40.063  34.451 -14.569  1.00 38.73           O  
ATOM    207  OE2 GLU    24      40.950  35.884 -13.159  1.00 38.71           O  
ATOM    208  N   LYS    25      35.421  32.604 -12.378  1.00 25.57           N  
ATOM    209  CA  LYS    25      34.277  31.667 -12.408  1.00 24.89           C  
ATOM    210  C   LYS    25      34.691  30.274 -11.910  1.00 22.95           C  
ATOM    211  O   LYS    25      34.323  29.237 -12.514  1.00 24.07           O  
ATOM    212  CB  LYS    25      33.655  31.563 -13.820  1.00 26.00           C  
ATOM    213  CG  LYS    25      33.068  32.889 -14.367  1.00 30.31           C  
ATOM    214  CD  LYS    25      31.531  32.954 -14.285  1.00 37.00           C  
ATOM    215  CE  LYS    25      30.851  32.201 -15.442  1.00 39.72           C  
ATOM    216  NZ  LYS    25      29.358  32.126 -15.292  1.00 41.81           N  
ATOM    217  N   ILE    26      35.474  30.269 -10.834  1.00 20.24           N  
ATOM    218  CA  ILE    26      35.921  29.042 -10.172  0.50 19.68           C  
ATOM    220  C   ILE    26      35.057  28.826  -8.941  1.00 18.78           C  
ATOM    221  O   ILE    26      34.810  29.759  -8.172  1.00 18.27           O  
ATOM    222  CB  ILE    26      37.425  29.134  -9.782  0.50 19.24           C  
ATOM    224  CG1 ILE    26      38.297  29.028 -11.046  0.50 20.15           C  
ATOM    226  CG2 ILE    26      37.834  28.074  -8.758  0.50 19.79           C  
ATOM    228  CD1 ILE    26      39.716  29.509 -10.829  0.50 19.10           C  
ATOM    230  N   ILE    27      34.588  27.598  -8.779  1.00 17.64           N  
ATOM    231  CA  ILE    27      33.708  27.274  -7.670  0.50 17.31           C  
ATOM    233  C   ILE    27      34.422  27.476  -6.353  1.00 17.86           C  
ATOM    234  O   ILE    27      35.542  27.019  -6.154  1.00 16.33           O  
ATOM    235  CB  ILE    27      33.170  25.849  -7.774  0.50 16.83           C  
ATOM    237  CG1 ILE    27      32.426  25.673  -9.102  0.50 18.12           C  
ATOM    239  CG2 ILE    27      32.228  25.543  -6.610  0.50 15.69           C  
ATOM    241  CD1 ILE    27      32.230  24.258  -9.481  0.50 17.55           C  
ATOM    243  N   GLN    28      33.712  28.157  -5.457  1.00 19.94           N  
ATOM    244  CA  GLN    28      34.188  28.558  -4.186  1.00 21.00           C  
ATOM    245  C   GLN    28      33.026  28.413  -3.207  1.00 20.63           C  
ATOM    246  O   GLN    28      32.128  29.284  -3.155  1.00 21.79           O  
ATOM    247  CB  GLN    28      34.493  30.038  -4.326  1.00 22.79           C  
ATOM    248  CG  GLN    28      35.186  30.690  -3.187  1.00 25.95           C  
ATOM    249  CD  GLN    28      35.402  32.143  -3.518  1.00 23.19           C  
ATOM    250  OE1 GLN    28      34.439  32.916  -3.650  1.00 26.05           O  
ATOM    251  NE2 GLN    28      36.658  32.528  -3.684  1.00 18.04           N  
ATOM    252  N   GLY    29      33.023  27.314  -2.470  1.00 18.42           N  
ATOM    253  CA  GLY    29      32.073  27.123  -1.387  1.00 18.14           C  
ATOM    254  C   GLY    29      32.830  27.131  -0.072  1.00 18.33           C  
ATOM    255  O   GLY    29      33.116  28.190   0.473  1.00 18.58           O  
ATOM    256  N   GLN    30      33.180  25.950   0.427  1.00 18.10           N  
ATOM    257  CA  GLN    30      33.966  25.825   1.659  1.00 19.44           C  
ATOM    258  C   GLN    30      35.303  25.107   1.278  1.00 21.53           C  
ATOM    259  O   GLN    30      35.699  24.135   1.898  1.00 22.52           O  
ATOM    260  CB  GLN    30      33.146  25.074   2.757  1.00 18.80           C  
ATOM    261  CG  GLN    30      31.821  25.772   3.166  1.00 17.51           C  
ATOM    262  CD  GLN    30      31.107  25.155   4.393  1.00 18.30           C  
ATOM    263  OE1 GLN    30      31.751  24.637   5.332  1.00 17.71           O  
ATOM    264  NE2 GLN    30      29.785  25.260   4.418  1.00 15.39           N  
ATOM    265  N   GLY    31      35.971  25.592   0.233  1.00 23.08           N  
ATOM    266  CA  GLY    31      37.221  24.988  -0.236  1.00 24.28           C  
ATOM    267  C   GLY    31      38.442  25.756   0.219  1.00 24.89           C  
ATOM    268  O   GLY    31      38.798  25.700   1.396  1.00 24.91           O  
ATOM    269  N   VAL    32      39.121  26.439  -0.706  1.00 24.97           N  
ATOM    270  CA  VAL    32      40.138  27.382  -0.288  1.00 24.40           C  
ATOM    271  C   VAL    32      39.368  28.547   0.340  1.00 22.92           C  
ATOM    272  O   VAL    32      38.374  29.027  -0.170  1.00 23.11           O  
ATOM    273  CB  VAL    32      41.112  27.879  -1.434  1.00 25.58           C  
ATOM    274  CG1 VAL    32      41.796  29.243  -1.078  1.00 25.76           C  
ATOM    275  CG2 VAL    32      42.175  26.840  -1.736  1.00 26.45           C  
ATOM    276  N   ASP    33      39.840  28.949   1.490  1.00 21.48           N  
ATOM    277  CA  ASP    33      39.335  30.116   2.151  1.00 19.20           C  
ATOM    278  C   ASP    33      40.047  31.316   1.497  1.00 17.34           C  
ATOM    279  O   ASP    33      41.003  31.846   2.054  1.00 18.03           O  
ATOM    280  CB  ASP    33      39.747  29.960   3.601  1.00 18.89           C  
ATOM    281  CG  ASP    33      39.039  30.875   4.486  1.00 18.74           C  
ATOM    282  OD1 ASP    33      38.258  31.695   3.971  1.00 16.19           O  
ATOM    283  OD2 ASP    33      39.269  30.786   5.698  1.00 18.51           O  
ATOM    284  N   GLU    34      39.564  31.721   0.315  1.00 16.16           N  
ATOM    285  CA  GLU    34      40.199  32.771  -0.530  1.00 13.68           C  
ATOM    286  C   GLU    34      39.829  34.184  -0.062  1.00 13.01           C  
ATOM    287  O   GLU    34      38.658  34.481   0.182  1.00 12.76           O  
ATOM    288  CB  GLU    34      39.758  32.569  -1.988  1.00 13.32           C  
ATOM    289  CG  GLU    34      40.392  33.542  -2.987  1.00 14.27           C  
ATOM    290  CD  GLU    34      41.895  33.337  -3.121  1.00 17.56           C  
ATOM    291  OE1 GLU    34      42.406  32.292  -2.657  1.00 16.95           O  
ATOM    292  OE2 GLU    34      42.561  34.222  -3.687  1.00 14.35           O  
ATOM    293  N   PRO    35      40.816  35.087   0.038  1.00 12.61           N  
ATOM    294  CA  PRO    35      40.519  36.460   0.441  1.00 12.40           C  
ATOM    295  C   PRO    35      39.941  37.281  -0.696  1.00 12.19           C  
ATOM    296  O   PRO    35      39.870  36.798  -1.836  1.00 12.16           O  
ATOM    297  CB  PRO    35      41.903  37.012   0.800  1.00 13.18           C  
ATOM    298  CG  PRO    35      42.830  36.282  -0.091  1.00 11.73           C  
ATOM    299  CD  PRO    35      42.257  34.876  -0.197  1.00 12.29           C  
ATOM    300  N   LEU    36      39.553  38.525  -0.381  1.00 13.27           N  
ATOM    301  CA  LEU    36      39.129  39.442  -1.419  1.00 13.91           C  
ATOM    302  C   LEU    36      40.288  39.748  -2.367  1.00 14.60           C  
ATOM    303  O   LEU    36      41.477  39.720  -1.959  1.00 15.26           O  
ATOM    304  CB  LEU    36      38.660  40.730  -0.791  1.00 13.30           C  
ATOM    305  CG  LEU    36      37.476  40.669   0.167  1.00 11.16           C  
ATOM    306  CD1 LEU    36      37.120  42.084   0.644  1.00 12.32           C  
ATOM    307  CD2 LEU    36      36.294  40.061  -0.606  1.00 14.18           C  
ATOM    308  N   SER    37      39.942  40.002  -3.627  1.00 14.66           N  
ATOM    309  CA  SER    37      40.887  40.588  -4.581  1.00 15.07           C  
ATOM    310  C   SER    37      40.955  42.115  -4.361  1.00 16.18           C  
ATOM    311  O   SER    37      40.191  42.650  -3.561  1.00 15.86           O  
ATOM    312  CB  SER    37      40.387  40.310  -5.990  1.00 15.28           C  
ATOM    313  OG  SER    37      39.163  40.991  -6.245  1.00 15.00           O  
ATOM    314  N   GLU    38      41.843  42.819  -5.053  0.50 16.90           N  
ATOM    316  CA  GLU    38      41.822  44.275  -4.919  0.50 17.68           C  
ATOM    318  C   GLU    38      40.468  44.909  -5.349  0.50 17.34           C  
ATOM    320  O   GLU    38      39.992  45.839  -4.683  0.50 16.87           O  
ATOM    322  CB  GLU    38      43.062  44.905  -5.555  0.50 18.44           C  
ATOM    324  CG  GLU    38      44.363  44.465  -4.861  0.50 20.32           C  
ATOM    326  CD  GLU    38      44.498  45.003  -3.442  0.50 23.44           C  
ATOM    328  OE1 GLU    38      44.550  46.248  -3.280  0.50 23.55           O  
ATOM    330  OE2 GLU    38      44.564  44.191  -2.493  0.50 20.46           O  
ATOM    332  N   THR    39      39.818  44.357  -6.381  1.00 17.89           N  
ATOM    333  CA  THR    39      38.442  44.762  -6.739  1.00 18.70           C  
ATOM    334  C   THR    39      37.477  44.495  -5.573  1.00 17.31           C  
ATOM    335  O   THR    39      36.641  45.350  -5.250  1.00 16.75           O  
ATOM    336  CB  THR    39      37.965  44.078  -8.026  1.00 19.07           C  
ATOM    337  OG1 THR    39      38.780  44.507  -9.123  1.00 23.74           O  
ATOM    338  CG2 THR    39      36.491  44.402  -8.353  1.00 21.10           C  
ATOM    339  N   GLY    40      37.635  43.343  -4.911  1.00 16.64           N  
ATOM    340  CA  GLY    40      36.796  43.013  -3.755  1.00 15.47           C  
ATOM    341  C   GLY    40      36.961  43.990  -2.593  1.00 15.29           C  
ATOM    342  O   GLY    40      35.992  44.422  -1.961  1.00 14.78           O  
ATOM    343  N   PHE    41      38.204  44.362  -2.311  1.00 14.84           N  
ATOM    344  CA  PHE    41      38.482  45.341  -1.283  1.00 16.00           C  
ATOM    345  C   PHE    41      37.857  46.706  -1.643  1.00 15.44           C  
ATOM    346  O   PHE    41      37.278  47.347  -0.781  1.00 16.26           O  
ATOM    347  CB  PHE    41      39.994  45.489  -1.080  1.00 16.48           C  
ATOM    348  CG  PHE    41      40.600  44.395  -0.260  1.00 16.72           C  
ATOM    349  CD1 PHE    41      40.213  44.206   1.066  1.00 16.36           C  
ATOM    350  CD2 PHE    41      41.607  43.599  -0.798  1.00 18.31           C  
ATOM    351  CE1 PHE    41      40.788  43.184   1.839  1.00 17.37           C  
ATOM    352  CE2 PHE    41      42.194  42.576  -0.035  1.00 17.66           C  
ATOM    353  CZ  PHE    41      41.779  42.378   1.287  1.00 17.32           C  
ATOM    354  N   LYS    42      37.973  47.118  -2.900  1.00 15.99           N  
ATOM    355  CA  LYS    42      37.278  48.329  -3.408  1.00 17.34           C  
ATOM    356  C   LYS    42      35.755  48.273  -3.244  1.00 17.57           C  
ATOM    357  O   LYS    42      35.146  49.256  -2.833  1.00 16.74           O  
ATOM    358  CB  LYS    42      37.634  48.638  -4.865  1.00 18.01           C  
ATOM    359  CG  LYS    42      39.093  49.050  -5.043  1.00 21.90           C  
ATOM    360  CD  LYS    42      39.416  49.194  -6.520  1.00 25.92           C  
ATOM    361  CE  LYS    42      40.607  50.124  -6.698  1.00 31.54           C  
ATOM    362  NZ  LYS    42      40.793  50.449  -8.144  1.00 35.78           N  
ATOM    363  N   GLN    43      35.141  47.130  -3.560  1.00 17.23           N  
ATOM    364  CA  GLN    43      33.689  46.988  -3.408  1.00 16.65           C  
ATOM    365  C   GLN    43      33.281  47.098  -1.934  1.00 16.50           C  
ATOM    366  O   GLN    43      32.313  47.778  -1.603  1.00 15.99           O  
ATOM    367  CB  GLN    43      33.204  45.648  -3.998  1.00 17.02           C  
ATOM    368  CG  GLN    43      33.434  45.511  -5.503  1.00 14.54           C  
ATOM    369  CD  GLN    43      33.179  44.106  -6.005  1.00 17.25           C  
ATOM    370  OE1 GLN    43      33.287  43.143  -5.240  1.00 15.36           O  
ATOM    371  NE2 GLN    43      32.798  43.981  -7.286  1.00 17.54           N  
ATOM    372  N   ALA    44      34.049  46.460  -1.053  1.00 17.00           N  
ATOM    373  CA  ALA    44      33.780  46.481   0.362  1.00 18.25           C  
ATOM    374  C   ALA    44      33.894  47.920   0.893  1.00 18.29           C  
ATOM    375  O   ALA    44      33.071  48.365   1.710  1.00 19.67           O  
ATOM    376  CB  ALA    44      34.726  45.538   1.082  1.00 18.12           C  
ATOM    377  N   ALA    45      34.879  48.659   0.370  1.00 18.75           N  
ATOM    378  CA  ALA    45      35.095  50.055   0.802  1.00 18.36           C  
ATOM    379  C   ALA    45      33.906  50.917   0.356  1.00 17.22           C  
ATOM    380  O   ALA    45      33.358  51.719   1.139  1.00 18.63           O  
ATOM    381  CB  ALA    45      36.430  50.601   0.207  1.00 18.25           C  
ATOM    382  N   ALA    46      33.485  50.718  -0.884  1.00 17.27           N  
ATOM    383  CA  ALA    46      32.370  51.440  -1.471  1.00 17.55           C  
ATOM    384  C   ALA    46      31.100  51.155  -0.685  1.00 18.90           C  
ATOM    385  O   ALA    46      30.296  52.059  -0.395  1.00 17.88           O  
ATOM    386  CB  ALA    46      32.196  51.040  -2.903  1.00 18.02           C  
ATOM    387  N   ALA    47      30.886  49.882  -0.369  1.00 17.73           N  
ATOM    388  CA  ALA    47      29.743  49.513   0.469  1.00 18.26           C  
ATOM    389  C   ALA    47      29.810  50.180   1.851  1.00 18.11           C  
ATOM    390  O   ALA    47      28.780  50.598   2.404  1.00 19.38           O  
ATOM    391  CB  ALA    47      29.686  47.977   0.621  1.00 18.48           C  
ATOM    392  N   GLY    48      31.011  50.248   2.408  1.00 18.17           N  
ATOM    393  CA  GLY    48      31.250  50.880   3.714  1.00 19.13           C  
ATOM    394  C   GLY    48      30.921  52.359   3.648  1.00 19.49           C  
ATOM    395  O   GLY    48      30.279  52.887   4.548  1.00 20.37           O  
ATOM    396  N   ILE    49      31.301  53.017   2.557  1.00 21.18           N  
ATOM    397  CA  ILE    49      30.955  54.451   2.406  1.00 21.55           C  
ATOM    398  C   ILE    49      29.445  54.633   2.232  1.00 21.40           C  
ATOM    399  O   ILE    49      28.849  55.497   2.891  1.00 20.53           O  
ATOM    400  CB  ILE    49      31.725  55.134   1.271  1.00 21.92           C  
ATOM    401  CG1 ILE    49      33.240  55.058   1.563  1.00 22.53           C  
ATOM    402  CG2 ILE    49      31.190  56.604   1.066  1.00 23.77           C  
ATOM    403  CD1 ILE    49      34.126  55.098   0.360  1.00 25.96           C  
ATOM    404  N   PHE    50      28.825  53.794   1.396  1.00 20.95           N  
ATOM    405  CA  PHE    50      27.381  53.811   1.189  1.00 20.87           C  
ATOM    406  C   PHE    50      26.614  53.701   2.519  1.00 20.75           C  
ATOM    407  O   PHE    50      25.611  54.421   2.729  1.00 20.09           O  
ATOM    408  CB  PHE    50      26.959  52.675   0.236  1.00 21.75           C  
ATOM    409  CG  PHE    50      25.505  52.713  -0.165  1.00 21.42           C  
ATOM    410  CD1 PHE    50      25.034  53.666  -1.070  1.00 23.70           C  
ATOM    411  CD2 PHE    50      24.615  51.769   0.344  1.00 22.52           C  
ATOM    412  CE1 PHE    50      23.685  53.701  -1.454  1.00 25.31           C  
ATOM    413  CE2 PHE    50      23.278  51.778  -0.020  1.00 20.38           C  
ATOM    414  CZ  PHE    50      22.794  52.747  -0.929  1.00 23.41           C  
ATOM    415  N   LEU    51      27.106  52.823   3.398  1.00 20.65           N  
ATOM    416  CA  LEU    51      26.477  52.528   4.707  1.00 20.31           C  
ATOM    417  C   LEU    51      26.994  53.347   5.909  1.00 20.94           C  
ATOM    418  O   LEU    51      26.689  53.035   7.074  1.00 20.47           O  
ATOM    419  CB  LEU    51      26.620  51.024   5.012  1.00 20.45           C  
ATOM    420  CG  LEU    51      26.018  50.029   4.002  1.00 18.73           C  
ATOM    421  CD1 LEU    51      26.516  48.571   4.293  1.00 17.74           C  
ATOM    422  CD2 LEU    51      24.503  50.071   4.006  1.00 18.95           C  
ATOM    423  N   ASN    52      27.776  54.391   5.646  1.00 22.08           N  
ATOM    424  CA  ASN    52      28.569  54.990   6.714  1.00 24.34           C  
ATOM    425  C   ASN    52      27.711  55.621   7.834  1.00 24.30           C  
ATOM    426  O   ASN    52      28.155  55.738   8.984  1.00 24.66           O  
ATOM    427  CB  ASN    52      29.517  56.037   6.111  1.00 25.39           C  
ATOM    428  CG  ASN    52      28.787  57.295   5.740  1.00 28.11           C  
ATOM    429  OD1 ASN    52      28.587  58.166   6.588  1.00 33.96           O  
ATOM    430  ND2 ASN    52      28.315  57.376   4.501  1.00 29.08           N  
ATOM    431  N   ASN    53      26.498  56.042   7.487  1.00 25.05           N  
ATOM    432  CA  ASN    53      25.632  56.715   8.469  1.00 25.92           C  
ATOM    433  C   ASN    53      24.488  55.833   8.952  1.00 25.06           C  
ATOM    434  O   ASN    53      23.578  56.317   9.638  1.00 25.23           O  
ATOM    435  CB  ASN    53      25.075  58.026   7.904  1.00 27.15           C  
ATOM    436  CG  ASN    53      24.652  58.988   9.000  1.00 30.53           C  
ATOM    437  OD1 ASN    53      25.455  59.349   9.865  1.00 36.72           O  
ATOM    438  ND2 ASN    53      23.382  59.389   8.986  1.00 34.91           N  
ATOM    439  N   VAL    54      24.521  54.547   8.585  1.00 23.11           N  
ATOM    440  CA  VAL    54      23.505  53.626   9.060  1.00 21.47           C  
ATOM    441  C   VAL    54      23.824  53.191  10.471  1.00 21.39           C  
ATOM    442  O   VAL    54      24.938  52.731  10.780  1.00 22.40           O  
ATOM    443  CB  VAL    54      23.363  52.343   8.167  1.00 20.54           C  
ATOM    444  CG1 VAL    54      22.303  51.405   8.775  1.00 20.21           C  
ATOM    445  CG2 VAL    54      22.991  52.714   6.759  1.00 20.99           C  
ATOM    446  N   LYS    55      22.832  53.303  11.339  1.00 21.50           N  
ATOM    447  CA  LYS    55      23.011  52.869  12.707  1.00 22.40           C  
ATOM    448  C   LYS    55      22.615  51.395  12.855  1.00 21.79           C  
ATOM    449  O   LYS    55      21.475  51.073  13.260  1.00 22.74           O  
ATOM    450  CB  LYS    55      22.190  53.741  13.659  1.00 23.17           C  
ATOM    451  CG  LYS    55      22.523  55.236  13.533  1.00 26.63           C  
ATOM    452  CD  LYS    55      22.200  55.945  14.829  1.00 32.13           C  
ATOM    453  CE  LYS    55      22.697  57.386  14.808  1.00 34.40           C  
ATOM    454  NZ  LYS    55      22.953  57.903  16.192  1.00 36.92           N  
ATOM    455  N   PHE    56      23.546  50.503  12.539  1.00 20.73           N  
ATOM    456  CA  PHE    56      23.337  49.078  12.823  1.00 19.15           C  
ATOM    457  C   PHE    56      23.510  48.812  14.304  1.00 19.61           C  
ATOM    458  O   PHE    56      24.285  49.504  15.000  1.00 21.15           O  
ATOM    459  CB  PHE    56      24.321  48.167  12.053  1.00 18.58           C  
ATOM    460  CG  PHE    56      24.172  48.230  10.567  1.00 17.80           C  
ATOM    461  CD1 PHE    56      23.018  47.719   9.935  1.00 14.64           C  
ATOM    462  CD2 PHE    56      25.183  48.753   9.779  1.00 16.61           C  
ATOM    463  CE1 PHE    56      22.881  47.789   8.533  1.00 14.77           C  
ATOM    464  CE2 PHE    56      25.061  48.793   8.381  1.00 16.45           C  
ATOM    465  CZ  PHE    56      23.904  48.324   7.749  1.00 14.90           C  
ATOM    466  N   THR    57      22.861  47.749  14.765  1.00 17.09           N  
ATOM    467  CA  THR    57      22.898  47.326  16.146  1.00 16.54           C  
ATOM    468  C   THR    57      23.611  45.992  16.347  1.00 16.67           C  
ATOM    469  O   THR    57      24.075  45.688  17.445  1.00 17.10           O  
ATOM    470  CB  THR    57      21.474  47.200  16.744  1.00 17.55           C  
ATOM    471  OG1 THR    57      20.692  46.278  15.957  1.00 14.51           O  
ATOM    472  CG2 THR    57      20.772  48.546  16.751  1.00 15.49           C  
ATOM    473  N   HIS    58      23.659  45.185  15.272  1.00 15.40           N  
ATOM    474  CA  HIS    58      24.258  43.857  15.350  1.00 14.88           C  
ATOM    475  C   HIS    58      24.974  43.589  14.027  1.00 14.04           C  
ATOM    476  O   HIS    58      24.557  44.082  12.977  1.00 13.96           O  
ATOM    477  CB  HIS    58      23.178  42.780  15.466  1.00 13.38           C  
ATOM    478  CG  HIS    58      22.385  42.839  16.735  1.00 14.77           C  
ATOM    479  ND1 HIS    58      21.409  43.785  16.961  1.00 15.83           N  
ATOM    480  CD2 HIS    58      22.419  42.059  17.838  1.00 15.46           C  
ATOM    481  CE1 HIS    58      20.892  43.595  18.164  1.00 17.07           C  
ATOM    482  NE2 HIS    58      21.460  42.535  18.700  1.00 15.53           N  
ATOM    483  N   ALA    59      26.044  42.806  14.100  1.00 13.04           N  
ATOM    484  CA  ALA    59      26.787  42.411  12.878  1.00 13.95           C  
ATOM    485  C   ALA    59      27.139  40.942  12.968  1.00 14.25           C  
ATOM    486  O   ALA    59      27.758  40.502  13.951  1.00 14.77           O  
ATOM    487  CB  ALA    59      28.058  43.213  12.703  1.00 14.18           C  
ATOM    488  N   PHE    60      26.778  40.185  11.930  1.00 12.96           N  
ATOM    489  CA  PHE    60      27.139  38.760  11.816  1.00 12.74           C  
ATOM    490  C   PHE    60      27.780  38.498  10.478  1.00 12.41           C  
ATOM    491  O   PHE    60      27.340  39.056   9.465  1.00 13.16           O  
ATOM    492  CB  PHE    60      25.911  37.831  11.919  1.00 13.31           C  
ATOM    493  CG  PHE    60      25.207  37.891  13.256  1.00 13.17           C  
ATOM    494  CD1 PHE    60      25.482  36.946  14.244  1.00 15.99           C  
ATOM    495  CD2 PHE    60      24.249  38.868  13.490  1.00 16.08           C  
ATOM    496  CE1 PHE    60      24.827  36.980  15.485  1.00 17.65           C  
ATOM    497  CE2 PHE    60      23.575  38.909  14.728  1.00 17.11           C  
ATOM    498  CZ  PHE    60      23.877  37.976  15.714  1.00 15.95           C  
ATOM    499  N   SER    61      28.775  37.602  10.451  1.00 11.13           N  
ATOM    500  CA  SER    61      29.467  37.297   9.202  1.00 12.21           C  
ATOM    501  C   SER    61      29.727  35.794   9.216  1.00 11.56           C  
ATOM    502  O   SER    61      29.983  35.205  10.263  1.00 12.53           O  
ATOM    503  CB  SER    61      30.800  38.071   9.126  1.00 11.54           C  
ATOM    504  OG  SER    61      31.557  37.684   7.995  1.00 14.79           O  
ATOM    505  N   SER    62      29.687  35.174   8.047  1.00 10.94           N  
ATOM    506  CA  SER    62      30.357  33.901   7.851  1.00 11.59           C  
ATOM    507  C   SER    62      31.798  33.973   8.360  1.00 11.84           C  
ATOM    508  O   SER    62      32.420  35.019   8.272  1.00 11.46           O  
ATOM    509  CB  SER    62      30.392  33.669   6.338  1.00 12.08           C  
ATOM    510  OG  SER    62      31.297  32.701   6.015  1.00 16.57           O  
ATOM    511  N   ASP    63      32.276  32.831   8.853  0.50 12.21           N  
ATOM    513  CA  ASP    63      33.641  32.659   9.378  0.50 13.48           C  
ATOM    515  C   ASP    63      34.594  32.183   8.266  0.50 13.52           C  
ATOM    517  O   ASP    63      35.392  31.242   8.442  0.50 13.40           O  
ATOM    519  CB  ASP    63      33.669  31.742  10.624  0.50 13.93           C  
ATOM    521  CG  ASP    63      33.182  30.313  10.355  0.50 14.36           C  
ATOM    523  OD1 ASP    63      32.267  30.105   9.530  0.50 10.93           O  
ATOM    525  OD2 ASP    63      33.724  29.377  10.988  0.50 15.00           O  
ATOM    527  N   LEU    64      34.455  32.830   7.104  1.00 14.85           N  
ATOM    528  CA  LEU    64      35.372  32.683   5.974  1.00 14.13           C  
ATOM    529  C   LEU    64      36.040  34.045   5.711  1.00 13.74           C  
ATOM    530  O   LEU    64      35.487  35.081   6.092  1.00 12.53           O  
ATOM    531  CB  LEU    64      34.610  32.144   4.735  1.00 14.06           C  
ATOM    532  CG  LEU    64      34.112  30.684   4.857  1.00 15.57           C  
ATOM    533  CD1 LEU    64      33.222  30.172   3.726  1.00 16.81           C  
ATOM    534  CD2 LEU    64      35.373  29.730   5.011  1.00 16.50           C  
ATOM    535  N   MET    65      37.244  34.054   5.120  1.00 13.80           N  
ATOM    536  CA  MET    65      37.997  35.312   4.978  1.00 14.27           C  
ATOM    537  C   MET    65      37.259  36.328   4.141  1.00 12.80           C  
ATOM    538  O   MET    65      37.249  37.513   4.483  1.00 12.68           O  
ATOM    539  CB  MET    65      39.344  35.088   4.268  1.00 14.39           C  
ATOM    540  CG  MET    65      40.368  34.551   5.151  1.00 19.40           C  
ATOM    541  SD  MET    65      42.061  34.816   4.234  1.00 17.57          SE  
ATOM    542  CE  MET    65      42.703  36.459   4.953  1.00 18.75           C  
ATOM    543  N   ARG    66      36.664  35.878   3.035  1.00 11.81           N  
ATOM    544  CA  ARG    66      36.066  36.820   2.071  1.00 11.30           C  
ATOM    545  C   ARG    66      34.928  37.632   2.693  1.00 12.24           C  
ATOM    546  O   ARG    66      34.802  38.856   2.479  1.00 11.93           O  
ATOM    547  CB  ARG    66      35.654  36.107   0.777  1.00 10.46           C  
ATOM    548  CG  ARG    66      34.682  34.894   0.959  1.00 10.29           C  
ATOM    549  CD  ARG    66      34.627  34.203  -0.373  1.00 12.79           C  
ATOM    550  NE  ARG    66      33.700  33.054  -0.470  1.00 11.27           N  
ATOM    551  CZ  ARG    66      33.988  31.816  -0.053  1.00 14.16           C  
ATOM    552  NH1 ARG    66      33.126  30.849  -0.290  1.00 12.57           N  
ATOM    553  NH2 ARG    66      35.111  31.536   0.612  1.00 11.25           N  
ATOM    554  N   THR    67      34.149  36.966   3.543  1.00 11.56           N  
ATOM    555  CA  THR    67      33.050  37.640   4.242  1.00 12.08           C  
ATOM    556  C   THR    67      33.622  38.488   5.417  1.00 11.63           C  
ATOM    557  O   THR    67      33.223  39.648   5.611  1.00 12.77           O  
ATOM    558  CB  THR    67      32.050  36.601   4.741  1.00 10.04           C  
ATOM    559  OG1 THR    67      32.796  35.490   5.240  1.00 12.29           O  
ATOM    560  CG2 THR    67      31.131  36.086   3.571  1.00 11.13           C  
ATOM    561  N   LYS    68      34.592  37.937   6.151  1.00 13.01           N  
ATOM    562  CA  LYS    68      35.199  38.673   7.299  1.00 13.10           C  
ATOM    563  C   LYS    68      35.821  40.001   6.795  1.00 11.78           C  
ATOM    564  O   LYS    68      35.613  41.042   7.377  1.00 11.93           O  
ATOM    565  CB  LYS    68      36.239  37.809   8.024  1.00 13.79           C  
ATOM    566  CG  LYS    68      37.010  38.545   9.119  1.00 16.70           C  
ATOM    567  CD  LYS    68      37.820  37.554   9.999  1.00 17.70           C  
ATOM    568  CE  LYS    68      38.271  38.243  11.310  1.00 22.84           C  
ATOM    569  NZ  LYS    68      38.987  37.265  12.187  1.00 25.71           N  
ATOM    570  N   GLN    69      36.578  39.925   5.702  1.00 11.45           N  
ATOM    571  CA  GLN    69      37.230  41.109   5.149  1.00 12.01           C  
ATOM    572  C   GLN    69      36.212  42.128   4.655  1.00 12.80           C  
ATOM    573  O   GLN    69      36.421  43.360   4.776  1.00 12.36           O  
ATOM    574  CB  GLN    69      38.143  40.690   4.024  1.00 11.90           C  
ATOM    575  CG  GLN    69      39.389  39.947   4.540  1.00 11.34           C  
ATOM    576  CD  GLN    69      40.288  39.535   3.414  1.00 14.07           C  
ATOM    577  OE1 GLN    69      39.807  39.100   2.363  1.00 12.32           O  
ATOM    578  NE2 GLN    69      41.613  39.608   3.639  1.00 15.02           N  
ATOM    579  N   THR    70      35.107  41.621   4.080  1.00 12.32           N  
ATOM    580  CA  THR    70      34.067  42.536   3.591  1.00 12.94           C  
ATOM    581  C   THR    70      33.409  43.288   4.778  1.00 12.24           C  
ATOM    582  O   THR    70      33.180  44.519   4.705  1.00 12.26           O  
ATOM    583  CB  THR    70      33.005  41.781   2.757  1.00 12.52           C  
ATOM    584  OG1 THR    70      33.657  41.176   1.623  1.00 12.51           O  
ATOM    585  CG2 THR    70      31.874  42.738   2.253  1.00 11.26           C  
ATOM    586  N   MET    71      33.076  42.532   5.819  1.00 12.95           N  
ATOM    587  CA  MET    71      32.513  43.084   7.054  1.00 14.04           C  
ATOM    588  C   MET    71      33.506  44.129   7.601  1.00 15.16           C  
ATOM    589  O   MET    71      33.100  45.209   8.015  1.00 14.69           O  
ATOM    590  CB  MET    71      32.311  42.000   8.084  1.00 14.72           C  
ATOM    591  CG  MET    71      31.741  42.503   9.416  1.00 16.03           C  
ATOM    592  SD  MET    71      30.009  43.366   9.266  1.00 12.53          SE  
ATOM    593  CE  MET    71      28.976  41.707   9.223  1.00 13.52           C  
ATOM    594  N   HIS    72      34.798  43.805   7.570  1.00 15.73           N  
ATOM    595  CA  HIS    72      35.798  44.765   8.079  1.00 17.92           C  
ATOM    596  C   HIS    72      35.799  46.068   7.279  1.00 18.23           C  
ATOM    597  O   HIS    72      35.806  47.170   7.877  1.00 18.65           O  
ATOM    598  CB  HIS    72      37.197  44.172   8.104  1.00 18.26           C  
ATOM    599  CG  HIS    72      38.231  45.134   8.616  1.00 22.21           C  
ATOM    600  ND1 HIS    72      38.329  45.480   9.946  1.00 26.17           N  
ATOM    601  CD2 HIS    72      39.186  45.851   7.968  1.00 26.64           C  
ATOM    602  CE1 HIS    72      39.323  46.337  10.106  1.00 25.60           C  
ATOM    603  NE2 HIS    72      39.856  46.583   8.920  1.00 28.23           N  
ATOM    604  N   GLY    73      35.786  45.922   5.950  1.00 17.64           N  
ATOM    605  CA  GLY    73      35.749  47.021   4.982  1.00 18.22           C  
ATOM    606  C   GLY    73      34.553  47.914   5.241  1.00 18.59           C  
ATOM    607  O   GLY    73      34.632  49.135   5.137  1.00 17.35           O  
ATOM    608  N   ILE    74      33.422  47.293   5.569  1.00 17.82           N  
ATOM    609  CA  ILE    74      32.208  48.049   5.833  1.00 18.14           C  
ATOM    610  C   ILE    74      32.322  48.766   7.168  1.00 19.12           C  
ATOM    611  O   ILE    74      32.124  49.976   7.216  1.00 20.75           O  
ATOM    612  CB  ILE    74      30.929  47.127   5.787  1.00 17.24           C  
ATOM    613  CG1 ILE    74      30.633  46.719   4.347  1.00 18.41           C  
ATOM    614  CG2 ILE    74      29.716  47.847   6.393  1.00 17.25           C  
ATOM    615  CD1 ILE    74      29.677  45.514   4.249  1.00 17.62           C  
ATOM    616  N   LEU    75      32.660  48.047   8.242  1.00 20.26           N  
ATOM    617  CA  LEU    75      32.654  48.660   9.584  1.00 20.39           C  
ATOM    618  C   LEU    75      33.748  49.711   9.784  1.00 21.93           C  
ATOM    619  O   LEU    75      33.506  50.723  10.442  1.00 21.81           O  
ATOM    620  CB  LEU    75      32.682  47.618  10.687  1.00 20.74           C  
ATOM    621  CG  LEU    75      31.457  46.705  10.768  1.00 18.86           C  
ATOM    622  CD1 LEU    75      31.706  45.688  11.869  1.00 20.32           C  
ATOM    623  CD2 LEU    75      30.175  47.516  10.991  1.00 20.37           C  
ATOM    624  N   GLU    76      34.907  49.519   9.165  1.00 22.34           N  
ATOM    625  CA  GLU    76      35.997  50.479   9.357  1.00 25.10           C  
ATOM    626  C   GLU    76      35.621  51.889   8.865  1.00 25.23           C  
ATOM    627  O   GLU    76      36.219  52.863   9.314  1.00 26.75           O  
ATOM    628  CB  GLU    76      37.318  49.973   8.753  1.00 24.36           C  
ATOM    629  CG  GLU    76      37.476  50.167   7.255  1.00 25.72           C  
ATOM    630  CD  GLU    76      38.694  49.424   6.693  1.00 27.22           C  
ATOM    631  OE1 GLU    76      39.583  49.024   7.479  1.00 30.93           O  
ATOM    632  OE2 GLU    76      38.774  49.240   5.461  1.00 32.26           O  
ATOM    633  N   ARG    77      34.624  51.982   7.977  1.00 25.58           N  
ATOM    634  CA  ARG    77      34.132  53.257   7.427  1.00 26.51           C  
ATOM    635  C   ARG    77      32.831  53.782   8.025  1.00 26.65           C  
ATOM    636  O   ARG    77      32.262  54.749   7.501  1.00 26.66           O  
ATOM    637  CB  ARG    77      33.949  53.141   5.920  1.00 26.38           C  
ATOM    638  CG  ARG    77      35.290  53.011   5.227  1.00 27.67           C  
ATOM    639  CD  ARG    77      35.178  52.485   3.846  1.00 30.97           C  
ATOM    640  NE  ARG    77      36.510  52.433   3.255  1.00 30.98           N  
ATOM    641  CZ  ARG    77      37.312  51.372   3.292  1.00 35.20           C  
ATOM    642  NH1 ARG    77      38.520  51.454   2.715  1.00 36.34           N  
ATOM    643  NH2 ARG    77      36.910  50.228   3.875  1.00 28.89           N  
ATOM    644  N   SER    78      32.357  53.130   9.079  1.00 26.15           N  
ATOM    645  CA  SER    78      31.086  53.486   9.669  1.00 27.03           C  
ATOM    646  C   SER    78      31.300  54.636  10.634  1.00 27.68           C  
ATOM    647  O   SER    78      32.276  54.646  11.391  1.00 27.16           O  
ATOM    648  CB  SER    78      30.468  52.308  10.416  1.00 26.71           C  
ATOM    649  OG  SER    78      29.259  52.707  11.068  1.00 26.27           O  
ATOM    650  N   LYS    79      30.379  55.591  10.600  1.00 29.19           N  
ATOM    651  CA  LYS    79      30.364  56.674  11.605  1.00 30.36           C  
ATOM    652  C   LYS    79      30.015  56.189  13.025  1.00 30.63           C  
ATOM    653  O   LYS    79      30.639  56.613  14.014  1.00 30.77           O  
ATOM    654  CB  LYS    79      29.411  57.772  11.163  1.00 30.35           C  
ATOM    655  CG  LYS    79      29.804  58.387   9.823  1.00 34.19           C  
ATOM    656  CD  LYS    79      28.840  59.478   9.389  1.00 38.11           C  
ATOM    657  CE  LYS    79      29.545  60.497   8.510  1.00 41.68           C  
ATOM    658  NZ  LYS    79      30.320  59.884   7.374  1.00 44.79           N  
ATOM    659  N   PHE    80      29.039  55.283  13.132  1.00 30.30           N  
ATOM    660  CA  PHE    80      28.579  54.815  14.441  1.00 29.95           C  
ATOM    661  C   PHE    80      29.020  53.438  14.871  1.00 29.66           C  
ATOM    662  O   PHE    80      29.052  53.163  16.069  1.00 29.18           O  
ATOM    663  CB  PHE    80      27.053  54.898  14.522  1.00 31.44           C  
ATOM    664  CG  PHE    80      26.530  56.235  14.154  1.00 34.11           C  
ATOM    665  CD1 PHE    80      26.564  57.278  15.077  1.00 37.99           C  
ATOM    666  CD2 PHE    80      26.056  56.478  12.874  1.00 35.72           C  
ATOM    667  CE1 PHE    80      26.106  58.537  14.729  1.00 38.23           C  
ATOM    668  CE2 PHE    80      25.597  57.722  12.519  1.00 39.19           C  
ATOM    669  CZ  PHE    80      25.623  58.758  13.446  1.00 38.01           C  
ATOM    670  N   CYS    81      29.366  52.575  13.910  1.00 28.01           N  
ATOM    671  CA  CYS    81      29.606  51.158  14.197  1.00 27.84           C  
ATOM    672  C   CYS    81      31.044  50.686  13.981  1.00 27.70           C  
ATOM    673  O   CYS    81      31.309  49.485  14.007  1.00 26.84           O  
ATOM    674  CB  CYS    81      28.645  50.276  13.398  1.00 27.28           C  
ATOM    675  SG  CYS    81      26.920  50.779  13.612  1.00 28.89           S  
ATOM    676  N   LYS    82      31.985  51.617  13.832  1.00 27.45           N  
ATOM    677  CA  LYS    82      33.403  51.222  13.766  1.00 28.50           C  
ATOM    678  C   LYS    82      33.834  50.144  14.796  1.00 27.82           C  
ATOM    679  O   LYS    82      34.547  49.182  14.454  1.00 28.25           O  
ATOM    680  CB  LYS    82      34.281  52.465  13.927  1.00 28.86           C  
ATOM    681  CG  LYS    82      35.101  52.816  12.713  1.00 32.47           C  
ATOM    682  CD  LYS    82      36.212  53.785  13.150  1.00 36.51           C  
ATOM    683  CE  LYS    82      37.407  53.769  12.213  1.00 39.21           C  
ATOM    684  NZ  LYS    82      38.422  54.834  12.584  1.00 41.30           N  
ATOM    685  N   ASP    83      33.375  50.304  16.039  1.00 27.50           N  
ATOM    686  CA  ASP    83      33.775  49.512  17.197  1.00 28.02           C  
ATOM    687  C   ASP    83      32.878  48.306  17.488  1.00 27.52           C  
ATOM    688  O   ASP    83      33.135  47.570  18.441  1.00 26.64           O  
ATOM    689  CB  ASP    83      33.731  50.395  18.458  1.00 29.41           C  
ATOM    690  CG  ASP    83      35.074  50.979  18.833  1.00 33.35           C  
ATOM    691  OD1 ASP    83      36.018  50.982  18.002  1.00 37.87           O  
ATOM    692  OD2 ASP    83      35.171  51.465  19.991  1.00 39.80           O  
ATOM    693  N   MET    84      31.827  48.123  16.684  1.00 27.33           N  
ATOM    694  CA  MET    84      30.888  47.015  16.853  1.00 27.36           C  
ATOM    695  C   MET    84      31.554  45.635  16.835  1.00 26.64           C  
ATOM    696  O   MET    84      32.397  45.363  15.972  1.00 26.44           O  
ATOM    697  CB  MET    84      29.828  47.074  15.754  1.00 27.33           C  
ATOM    698  CG  MET    84      28.843  45.919  15.820  1.00 29.83           C  
ATOM    699  SD  MET    84      27.184  46.452  15.025  1.00 28.68          SE  
ATOM    700  CE  MET    84      26.622  47.647  16.472  1.00 31.10           C  
ATOM    701  N   THR    85      31.151  44.771  17.770  1.00 25.42           N  
ATOM    702  CA  THR    85      31.643  43.400  17.829  1.00 25.35           C  
ATOM    703  C   THR    85      30.957  42.626  16.710  1.00 23.90           C  
ATOM    704  O   THR    85      29.733  42.626  16.620  1.00 25.42           O  
ATOM    705  CB  THR    85      31.307  42.725  19.175  1.00 26.00           C  
ATOM    706  OG1 THR    85      31.981  43.414  20.236  1.00 30.50           O  
ATOM    707  CG2 THR    85      31.750  41.256  19.191  1.00 26.88           C  
ATOM    708  N   VAL    86      31.747  41.998  15.858  1.00 21.60           N  
ATOM    709  CA  VAL    86      31.200  41.111  14.828  1.00 20.01           C  
ATOM    710  C   VAL    86      31.084  39.709  15.396  1.00 19.18           C  
ATOM    711  O   VAL    86      32.048  39.192  15.994  1.00 18.56           O  
ATOM    712  CB  VAL    86      32.133  41.078  13.584  1.00 19.70           C  
ATOM    713  CG1 VAL    86      31.600  40.066  12.497  1.00 19.54           C  
ATOM    714  CG2 VAL    86      32.330  42.463  13.026  1.00 19.51           C  
ATOM    715  N   LYS    87      29.931  39.060  15.205  1.00 18.68           N  
ATOM    716  CA  LYS    87      29.822  37.655  15.569  1.00 18.36           C  
ATOM    717  C   LYS    87      30.030  36.774  14.329  1.00 18.76           C  
ATOM    718  O   LYS    87      29.404  37.017  13.300  1.00 17.89           O  
ATOM    719  CB  LYS    87      28.465  37.363  16.219  1.00 20.32           C  
ATOM    720  CG  LYS    87      28.207  38.121  17.539  1.00 23.26           C  
ATOM    721  CD  LYS    87      28.881  37.441  18.727  1.00 29.51           C  
ATOM    722  CE  LYS    87      28.862  38.306  20.018  1.00 29.46           C  
ATOM    723  NZ  LYS    87      27.499  38.859  20.350  1.00 34.69           N  
ATOM    724  N   TYR    88      30.908  35.778  14.414  1.00 17.24           N  
ATOM    725  CA  TYR    88      31.205  34.925  13.245  1.00 17.08           C  
ATOM    726  C   TYR    88      30.472  33.634  13.446  1.00 17.77           C  
ATOM    727  O   TYR    88      30.595  33.005  14.519  1.00 19.09           O  
ATOM    728  CB  TYR    88      32.723  34.681  13.083  1.00 16.63           C  
ATOM    729  CG  TYR    88      33.416  35.982  12.807  1.00 16.87           C  
ATOM    730  CD1 TYR    88      33.417  36.518  11.521  1.00 15.13           C  
ATOM    731  CD2 TYR    88      33.947  36.751  13.855  1.00 19.18           C  
ATOM    732  CE1 TYR    88      33.996  37.748  11.259  1.00 16.39           C  
ATOM    733  CE2 TYR    88      34.524  37.980  13.606  1.00 16.91           C  
ATOM    734  CZ  TYR    88      34.548  38.461  12.314  1.00 18.38           C  
ATOM    735  OH  TYR    88      35.119  39.660  12.080  1.00 18.80           O  
ATOM    736  N   ASP    89      29.706  33.225  12.429  1.00 15.32           N  
ATOM    737  CA  ASP    89      28.752  32.138  12.598  1.00 14.95           C  
ATOM    738  C   ASP    89      28.880  31.221  11.400  1.00 14.21           C  
ATOM    739  O   ASP    89      28.637  31.632  10.269  1.00 13.18           O  
ATOM    740  CB  ASP    89      27.320  32.705  12.754  1.00 13.62           C  
ATOM    741  CG  ASP    89      26.326  31.703  13.309  1.00 17.57           C  
ATOM    742  OD1 ASP    89      26.216  30.557  12.790  1.00 16.56           O  
ATOM    743  OD2 ASP    89      25.635  32.056  14.296  1.00 18.76           O  
ATOM    744  N   SER    90      29.255  29.979  11.660  1.00 13.24           N  
ATOM    745  CA  SER    90      29.434  28.988  10.594  1.00 13.21           C  
ATOM    746  C   SER    90      28.127  28.694   9.846  1.00 12.15           C  
ATOM    747  O   SER    90      28.166  28.199   8.726  1.00 12.17           O  
ATOM    748  CB  SER    90      30.017  27.664  11.149  1.00 14.65           C  
ATOM    749  OG  SER    90      29.081  27.013  11.999  1.00 16.86           O  
ATOM    750  N   ARG    91      26.978  28.922  10.475  1.00 11.21           N  
ATOM    751  CA  ARG    91      25.693  28.726   9.753  1.00 11.52           C  
ATOM    752  C   ARG    91      25.545  29.632   8.523  1.00 10.85           C  
ATOM    753  O   ARG    91      24.752  29.346   7.617  1.00 11.71           O  
ATOM    754  CB  ARG    91      24.487  28.872  10.673  1.00 10.94           C  
ATOM    755  CG  ARG    91      24.441  27.792  11.768  1.00 13.03           C  
ATOM    756  CD  ARG    91      23.351  28.149  12.747  1.00 15.77           C  
ATOM    757  NE  ARG    91      23.786  29.244  13.608  1.00 15.09           N  
ATOM    758  CZ  ARG    91      23.191  29.560  14.752  1.00 17.43           C  
ATOM    759  NH1 ARG    91      22.113  28.881  15.146  1.00 16.56           N  
ATOM    760  NH2 ARG    91      23.653  30.574  15.469  1.00 16.42           N  
ATOM    761  N   LEU    92      26.309  30.720   8.483  1.00 10.05           N  
ATOM    762  CA  LEU    92      26.264  31.669   7.370  1.00 10.24           C  
ATOM    763  C   LEU    92      27.184  31.304   6.192  1.00 10.17           C  
ATOM    764  O   LEU    92      27.289  32.071   5.230  1.00  9.19           O  
ATOM    765  CB  LEU    92      26.659  33.064   7.888  1.00 10.64           C  
ATOM    766  CG  LEU    92      25.647  33.620   8.896  1.00  7.81           C  
ATOM    767  CD1 LEU    92      26.151  34.998   9.449  1.00  9.51           C  
ATOM    768  CD2 LEU    92      24.265  33.840   8.216  1.00  9.67           C  
ATOM    769  N   ARG    93      27.896  30.172   6.322  1.00  9.79           N  
ATOM    770  CA  ARG    93      28.920  29.832   5.307  0.50 10.74           C  
ATOM    772  C   ARG    93      28.293  29.473   3.946  1.00 10.23           C  
ATOM    773  O   ARG    93      27.130  29.136   3.852  1.00  9.45           O  
ATOM    774  CB  ARG    93      29.871  28.723   5.810  0.50 10.99           C  
ATOM    776  CG  ARG    93      30.830  29.182   6.953  0.50 10.53           C  
ATOM    778  CD  ARG    93      31.618  28.043   7.722  0.50 13.00           C  
ATOM    780  NE  ARG    93      32.947  27.783   7.170  0.50 16.63           N  
ATOM    782  CZ  ARG    93      33.539  26.581   7.087  0.50 18.09           C  
ATOM    784  NH1 ARG    93      34.723  26.475   6.518  0.50 20.66           N  
ATOM    786  NH2 ARG    93      32.953  25.481   7.538  0.50 21.05           N  
ATOM    788  N   GLU    94      29.087  29.574   2.874  1.00  9.81           N  
ATOM    789  CA  GLU    94      28.566  29.225   1.559  1.00  9.24           C  
ATOM    790  C   GLU    94      28.222  27.720   1.486  1.00  8.74           C  
ATOM    791  O   GLU    94      28.737  26.905   2.264  1.00 10.34           O  
ATOM    792  CB  GLU    94      29.576  29.564   0.464  1.00 11.27           C  
ATOM    793  CG  GLU    94      29.088  29.349  -0.995  1.00 12.74           C  
ATOM    794  CD  GLU    94      27.785  30.006  -1.403  1.00 10.47           C  
ATOM    795  OE1 GLU    94      26.737  29.737  -0.779  1.00 14.15           O  
ATOM    796  OE2 GLU    94      27.760  30.741  -2.438  1.00 16.89           O  
ATOM    797  N   ARG    95      27.340  27.399   0.548  1.00  9.78           N  
ATOM    798  CA  ARG    95      27.030  25.998   0.196  1.00  9.41           C  
ATOM    799  C   ARG    95      28.352  25.240  -0.046  1.00 10.34           C  
ATOM    800  O   ARG    95      29.275  25.768  -0.680  1.00 10.97           O  
ATOM    801  CB  ARG    95      26.208  26.018  -1.105  1.00 10.13           C  
ATOM    802  CG  ARG    95      25.946  24.628  -1.684  1.00 11.28           C  
ATOM    803  CD  ARG    95      24.903  24.690  -2.839  1.00 10.27           C  
ATOM    804  NE  ARG    95      24.391  23.349  -3.179  1.00 11.61           N  
ATOM    805  CZ  ARG    95      23.752  23.052  -4.310  1.00 14.85           C  
ATOM    806  NH1 ARG    95      23.582  23.987  -5.240  1.00 13.49           N  
ATOM    807  NH2 ARG    95      23.327  21.791  -4.534  1.00 15.15           N  
ATOM    808  N   LYS    96      28.445  24.020   0.483  1.00 10.77           N  
ATOM    809  CA  LYS    96      29.595  23.136   0.192  1.00 11.17           C  
ATOM    810  C   LYS    96      29.486  22.581  -1.218  1.00 10.95           C  
ATOM    811  O   LYS    96      28.428  22.118  -1.598  1.00 10.65           O  
ATOM    812  CB  LYS    96      29.583  21.978   1.171  1.00 11.63           C  
ATOM    813  CG  LYS    96      30.032  22.318   2.529  1.00 13.62           C  
ATOM    814  CD  LYS    96      29.955  21.039   3.375  1.00 16.90           C  
ATOM    815  CE  LYS    96      30.787  21.227   4.642  1.00 21.22           C  
ATOM    816  NZ  LYS    96      30.972  19.848   5.295  1.00 27.76           N  
ATOM    817  N   TYR    97      30.603  22.551  -1.955  1.00 11.30           N  
ATOM    818  CA  TYR    97      30.624  21.926  -3.290  1.00 12.22           C  
ATOM    819  C   TYR    97      31.571  20.706  -3.360  1.00 11.94           C  
ATOM    820  O   TYR    97      31.841  20.166  -4.447  1.00 12.35           O  
ATOM    821  CB  TYR    97      31.000  22.967  -4.355  1.00 13.04           C  
ATOM    822  CG  TYR    97      29.936  24.034  -4.515  1.00 14.72           C  
ATOM    823  CD1 TYR    97      28.774  23.798  -5.274  1.00 14.38           C  
ATOM    824  CD2 TYR    97      30.088  25.270  -3.896  1.00 15.43           C  
ATOM    825  CE1 TYR    97      27.810  24.791  -5.393  1.00 14.73           C  
ATOM    826  CE2 TYR    97      29.122  26.262  -4.010  1.00 12.53           C  
ATOM    827  CZ  TYR    97      27.999  26.014  -4.720  1.00 14.34           C  
ATOM    828  OH  TYR    97      27.092  27.032  -4.827  1.00 16.25           O  
ATOM    829  N   GLY    98      32.089  20.291  -2.206  1.00 11.77           N  
ATOM    830  CA  GLY    98      32.826  19.036  -2.111  1.00 12.24           C  
ATOM    831  C   GLY    98      33.949  18.921  -3.124  1.00 11.83           C  
ATOM    832  O   GLY    98      34.843  19.794  -3.224  1.00 11.40           O  
ATOM    833  N   VAL    99      33.936  17.809  -3.851  1.00 12.50           N  
ATOM    834  CA  VAL    99      35.079  17.516  -4.759  1.00 12.04           C  
ATOM    835  C   VAL    99      35.247  18.503  -5.926  1.00 13.67           C  
ATOM    836  O   VAL    99      36.288  18.456  -6.634  1.00 14.68           O  
ATOM    837  CB  VAL    99      34.966  16.107  -5.330  1.00 12.48           C  
ATOM    838  CG1 VAL    99      34.952  15.066  -4.205  1.00 11.02           C  
ATOM    839  CG2 VAL    99      33.676  16.004  -6.206  1.00 10.02           C  
ATOM    840  N   VAL   100      34.243  19.356  -6.190  1.00 13.11           N  
ATOM    841  CA  VAL   100      34.429  20.384  -7.258  1.00 14.81           C  
ATOM    842  C   VAL   100      34.881  21.755  -6.749  1.00 14.74           C  
ATOM    843  O   VAL   100      35.011  22.702  -7.539  1.00 14.67           O  
ATOM    844  CB  VAL   100      33.220  20.532  -8.215  1.00 15.29           C  
ATOM    845  CG1 VAL   100      32.946  19.211  -8.916  1.00 19.59           C  
ATOM    846  CG2 VAL   100      32.006  20.981  -7.464  1.00 14.33           C  
ATOM    847  N   GLU   101      35.136  21.874  -5.446  1.00 14.02           N  
ATOM    848  CA  GLU   101      35.714  23.106  -4.924  1.00 14.89           C  
ATOM    849  C   GLU   101      37.010  23.377  -5.661  1.00 16.00           C  
ATOM    850  O   GLU   101      37.861  22.484  -5.742  1.00 16.46           O  
ATOM    851  CB  GLU   101      36.007  22.975  -3.420  1.00 15.96           C  
ATOM    852  CG  GLU   101      34.792  22.693  -2.590  1.00 18.68           C  
ATOM    853  CD  GLU   101      34.050  23.919  -2.181  1.00 21.81           C  
ATOM    854  OE1 GLU   101      34.382  25.012  -2.728  1.00 23.06           O  
ATOM    855  OE2 GLU   101      33.145  23.767  -1.300  1.00 19.19           O  
ATOM    856  N   GLY   102      37.147  24.585  -6.197  1.00 16.89           N  
ATOM    857  CA  GLY   102      38.361  24.997  -6.908  1.00 18.62           C  
ATOM    858  C   GLY   102      38.395  24.590  -8.367  1.00 19.14           C  
ATOM    859  O   GLY   102      39.412  24.832  -9.049  1.00 20.07           O  
ATOM    860  N   LYS   103      37.291  24.032  -8.876  1.00 18.98           N  
ATOM    861  CA  LYS   103      37.197  23.699 -10.299  1.00 20.92           C  
ATOM    862  C   LYS   103      36.380  24.757 -11.029  1.00 21.03           C  
ATOM    863  O   LYS   103      35.632  25.519 -10.411  1.00 20.19           O  
ATOM    864  CB  LYS   103      36.570  22.310 -10.518  1.00 20.50           C  
ATOM    865  CG  LYS   103      37.190  21.159  -9.715  1.00 22.86           C  
ATOM    866  CD  LYS   103      38.507  20.669 -10.290  1.00 23.45           C  
ATOM    867  CE  LYS   103      38.950  19.375  -9.614  1.00 23.50           C  
ATOM    868  NZ  LYS   103      40.298  18.991 -10.102  1.00 25.68           N  
ATOM    869  N   ALA   104      36.531  24.809 -12.356  1.00 22.14           N  
ATOM    870  CA  ALA   104      35.691  25.672 -13.175  1.00 23.68           C  
ATOM    871  C   ALA   104      34.233  25.281 -13.011  1.00 24.89           C  
ATOM    872  O   ALA   104      33.888  24.084 -12.896  1.00 23.99           O  
ATOM    873  CB  ALA   104      36.097  25.574 -14.678  1.00 24.14           C  
ATOM    874  N   LEU   105      33.380  26.298 -12.996  1.00 27.07           N  
ATOM    875  CA  LEU   105      31.931  26.103 -13.087  1.00 28.87           C  
ATOM    876  C   LEU   105      31.530  25.061 -14.143  1.00 29.02           C  
ATOM    877  O   LEU   105      30.664  24.232 -13.898  1.00 29.23           O  
ATOM    878  CB  LEU   105      31.257  27.442 -13.362  1.00 29.23           C  
ATOM    879  CG  LEU   105      29.755  27.479 -13.668  1.00 31.02           C  
ATOM    880  CD1 LEU   105      28.907  27.141 -12.425  1.00 32.77           C  
ATOM    881  CD2 LEU   105      29.399  28.852 -14.209  1.00 30.51           C  
ATOM    882  N   SER   106      32.178  25.086 -15.307  1.00 29.91           N  
ATOM    883  CA  SER   106      31.881  24.149 -16.387  1.00 29.14           C  
ATOM    884  C   SER   106      32.051  22.681 -15.998  1.00 29.11           C  
ATOM    885  O   SER   106      31.355  21.822 -16.527  1.00 29.44           O  
ATOM    886  CB  SER   106      32.728  24.472 -17.622  1.00 29.72           C  
ATOM    887  OG  SER   106      34.098  24.225 -17.361  1.00 30.00           O  
ATOM    888  N   GLU   107      32.982  22.398 -15.080  1.00 27.75           N  
ATOM    889  CA  GLU   107      33.183  21.041 -14.562  1.00 27.48           C  
ATOM    890  C   GLU   107      32.013  20.561 -13.714  1.00 26.29           C  
ATOM    891  O   GLU   107      31.682  19.367 -13.708  1.00 25.83           O  
ATOM    892  CB  GLU   107      34.431  20.982 -13.697  1.00 27.28           C  
ATOM    893  CG  GLU   107      35.726  20.925 -14.471  1.00 31.09           C  
ATOM    894  CD  GLU   107      36.761  20.054 -13.765  1.00 34.47           C  
ATOM    895  OE1 GLU   107      36.413  18.951 -13.265  1.00 39.28           O  
ATOM    896  OE2 GLU   107      37.930  20.465 -13.731  1.00 36.57           O  
ATOM    897  N   LEU   108      31.437  21.482 -12.953  1.00 24.91           N  
ATOM    898  CA  LEU   108      30.246  21.168 -12.154  1.00 24.54           C  
ATOM    899  C   LEU   108      29.064  20.903 -13.085  1.00 24.38           C  
ATOM    900  O   LEU   108      28.318  19.949 -12.900  1.00 23.94           O  
ATOM    901  CB  LEU   108      29.924  22.317 -11.200  1.00 23.85           C  
ATOM    902  CG  LEU   108      28.633  22.283 -10.366  1.00 24.31           C  
ATOM    903  CD1 LEU   108      28.572  21.058  -9.475  1.00 24.85           C  
ATOM    904  CD2 LEU   108      28.493  23.548  -9.560  1.00 25.05           C  
ATOM    905  N   ARG   109      28.905  21.759 -14.093  1.00 24.69           N  
ATOM    906  CA  ARG   109      27.797  21.593 -15.046  1.00 25.81           C  
ATOM    907  C   ARG   109      27.927  20.267 -15.799  1.00 25.60           C  
ATOM    908  O   ARG   109      26.936  19.578 -16.013  1.00 25.88           O  
ATOM    909  CB  ARG   109      27.722  22.778 -16.012  1.00 26.38           C  
ATOM    910  CG  ARG   109      27.505  24.090 -15.295  1.00 29.70           C  
ATOM    911  CD  ARG   109      26.671  25.027 -16.096  1.00 37.60           C  
ATOM    912  NE  ARG   109      26.665  26.367 -15.512  1.00 43.01           N  
ATOM    913  CZ  ARG   109      26.248  27.449 -16.166  1.00 45.11           C  
ATOM    914  NH1 ARG   109      25.796  27.329 -17.408  1.00 47.16           N  
ATOM    915  NH2 ARG   109      26.277  28.645 -15.585  1.00 47.45           N  
ATOM    916  N   ALA   110      29.155  19.917 -16.190  1.00 25.45           N  
ATOM    917  CA  ALA   110      29.412  18.652 -16.891  1.00 25.48           C  
ATOM    918  C   ALA   110      29.078  17.447 -16.012  1.00 25.62           C  
ATOM    919  O   ALA   110      28.485  16.465 -16.476  1.00 25.86           O  
ATOM    920  CB  ALA   110      30.848  18.593 -17.374  1.00 25.39           C  
ATOM    921  N   MET   111      29.438  17.540 -14.729  1.00 24.85           N  
ATOM    922  CA  MET   111      29.117  16.514 -13.757  0.50 23.26           C  
ATOM    924  C   MET   111      27.592  16.359 -13.584  1.00 24.91           C  
ATOM    925  O   MET   111      27.085  15.230 -13.477  1.00 24.74           O  
ATOM    926  CB  MET   111      29.815  16.828 -12.422  0.50 23.59           C  
ATOM    928  CG  MET   111      30.092  15.611 -11.579  0.50 20.75           C  
ATOM    930  SD  MET   111      30.883  16.032  -9.843  0.50 18.95          SE  
ATOM    932  CE  MET   111      32.747  15.837 -10.220  0.50 15.17           C  
ATOM    934  N   ALA   112      26.884  17.494 -13.540  1.00 25.44           N  
ATOM    935  CA  ALA   112      25.427  17.512 -13.439  1.00 26.76           C  
ATOM    936  C   ALA   112      24.818  16.790 -14.647  1.00 27.56           C  
ATOM    937  O   ALA   112      24.077  15.821 -14.486  1.00 27.10           O  
ATOM    938  CB  ALA   112      24.911  18.932 -13.376  1.00 26.49           C  
ATOM    939  N   LYS   113      25.139  17.300 -15.834  1.00 29.94           N  
ATOM    940  CA  LYS   113      24.723  16.725 -17.128  1.00 31.32           C  
ATOM    941  C   LYS   113      24.909  15.206 -17.140  1.00 31.81           C  
ATOM    942  O   LYS   113      23.985  14.460 -17.480  1.00 32.12           O  
ATOM    943  CB  LYS   113      25.496  17.434 -18.269  1.00 32.12           C  
ATOM    944  CG  LYS   113      25.539  16.786 -19.681  1.00 32.56           C  
ATOM    945  CD  LYS   113      24.177  16.663 -20.371  1.00 37.78           C  
ATOM    946  CE  LYS   113      24.235  15.605 -21.499  1.00 38.53           C  
ATOM    947  NZ  LYS   113      22.973  14.790 -21.585  1.00 41.24           N  
ATOM    948  N   ALA   114      26.094  14.753 -16.737  1.00 32.76           N  
ATOM    949  CA  ALA   114      26.410  13.322 -16.690  1.00 33.68           C  
ATOM    950  C   ALA   114      25.518  12.546 -15.725  1.00 34.47           C  
ATOM    951  O   ALA   114      25.190  11.380 -15.980  1.00 34.78           O  
ATOM    952  CB  ALA   114      27.859  13.111 -16.338  1.00 33.77           C  
ATOM    953  N   ALA   115      25.130  13.181 -14.617  1.00 34.82           N  
ATOM    954  CA  ALA   115      24.253  12.533 -13.633  1.00 35.21           C  
ATOM    955  C   ALA   115      22.772  12.575 -14.030  1.00 35.51           C  
ATOM    956  O   ALA   115      21.914  12.092 -13.291  1.00 35.77           O  
ATOM    957  CB  ALA   115      24.458  13.149 -12.245  1.00 35.54           C  
ATOM    958  N   ARG   116      22.485  13.151 -15.197  1.00 35.81           N  
ATOM    959  CA  ARG   116      21.116  13.413 -15.664  1.00 36.57           C  
ATOM    960  C   ARG   116      20.358  14.336 -14.703  1.00 35.96           C  
ATOM    961  O   ARG   116      19.173  14.146 -14.421  1.00 35.58           O  
ATOM    962  CB  ARG   116      20.351  12.109 -15.954  1.00 36.76           C  
ATOM    963  CG  ARG   116      20.943  11.282 -17.109  1.00 38.35           C  
ATOM    964  CD  ARG   116      19.941  10.231 -17.616  1.00 39.16           C  
ATOM    965  NE  ARG   116      18.865  10.833 -18.415  1.00 45.58           N  
ATOM    966  CZ  ARG   116      18.722  10.692 -19.735  1.00 47.21           C  
ATOM    967  NH1 ARG   116      17.713  11.292 -20.360  1.00 48.53           N  
ATOM    968  NH2 ARG   116      19.577   9.950 -20.436  1.00 47.82           N  
ATOM    969  N   GLU   117      21.074  15.339 -14.198  1.00 35.11           N  
ATOM    970  CA  GLU   117      20.493  16.359 -13.344  1.00 34.78           C  
ATOM    971  C   GLU   117      20.925  17.749 -13.819  1.00 33.72           C  
ATOM    972  O   GLU   117      21.735  17.874 -14.752  1.00 33.94           O  
ATOM    973  CB  GLU   117      20.900  16.117 -11.888  1.00 34.37           C  
ATOM    974  CG  GLU   117      20.427  14.774 -11.341  1.00 35.31           C  
ATOM    975  CD  GLU   117      20.919  14.515  -9.929  1.00 36.02           C  
ATOM    976  OE1 GLU   117      21.039  15.488  -9.157  1.00 35.32           O  
ATOM    977  OE2 GLU   117      21.184  13.339  -9.586  1.00 39.92           O  
ATOM    978  N   GLU   118      20.361  18.785 -13.204  1.00 32.71           N  
ATOM    979  CA  GLU   118      20.663  20.176 -13.569  1.00 32.59           C  
ATOM    980  C   GLU   118      21.165  20.955 -12.355  1.00 30.03           C  
ATOM    981  O   GLU   118      20.750  20.663 -11.221  1.00 28.44           O  
ATOM    982  CB  GLU   118      19.410  20.892 -14.056  1.00 32.85           C  
ATOM    983  CG  GLU   118      18.594  20.155 -15.100  1.00 35.90           C  
ATOM    984  CD  GLU   118      17.471  21.020 -15.648  1.00 36.89           C  
ATOM    985  OE1 GLU   118      16.623  21.507 -14.845  1.00 42.48           O  
ATOM    986  OE2 GLU   118      17.447  21.218 -16.887  1.00 42.19           O  
ATOM    987  N   CYS   119      22.027  21.946 -12.614  1.00 28.23           N  
ATOM    988  CA  CYS   119      22.452  22.914 -11.593  1.00 26.98           C  
ATOM    989  C   CYS   119      21.342  23.946 -11.462  1.00 25.57           C  
ATOM    990  O   CYS   119      20.665  24.224 -12.462  1.00 25.73           O  
ATOM    991  CB  CYS   119      23.757  23.606 -12.002  1.00 27.45           C  
ATOM    992  SG  CYS   119      25.141  22.472 -12.121  1.00 29.53           S  
ATOM    993  N   PRO   120      21.139  24.523 -10.258  1.00 23.62           N  
ATOM    994  CA  PRO   120      21.849  24.302  -8.974  1.00 21.20           C  
ATOM    995  C   PRO   120      21.369  23.125  -8.124  1.00 20.06           C  
ATOM    996  O   PRO   120      21.936  22.885  -7.060  1.00 17.82           O  
ATOM    997  CB  PRO   120      21.537  25.580  -8.198  1.00 22.04           C  
ATOM    998  CG  PRO   120      20.144  25.948  -8.652  1.00 22.84           C  
ATOM    999  CD  PRO   120      20.095  25.560 -10.125  1.00 23.21           C  
ATOM   1000  N   VAL   121      20.349  22.390  -8.562  1.00 18.45           N  
ATOM   1001  CA  VAL   121      19.870  21.259  -7.749  1.00 17.90           C  
ATOM   1002  C   VAL   121      20.963  20.198  -7.540  1.00 16.37           C  
ATOM   1003  O   VAL   121      21.146  19.687  -6.433  1.00 16.62           O  
ATOM   1004  CB  VAL   121      18.557  20.661  -8.340  1.00 18.55           C  
ATOM   1005  CG1 VAL   121      18.271  19.271  -7.769  1.00 19.26           C  
ATOM   1006  CG2 VAL   121      17.409  21.618  -8.031  1.00 18.36           C  
ATOM   1007  N   PHE   122      21.673  19.872  -8.610  1.00 16.51           N  
ATOM   1008  CA  PHE   122      22.654  18.799  -8.556  1.00 16.39           C  
ATOM   1009  C   PHE   122      23.668  19.052  -7.432  1.00 16.35           C  
ATOM   1010  O   PHE   122      24.175  20.152  -7.316  1.00 15.68           O  
ATOM   1011  CB  PHE   122      23.375  18.677  -9.889  1.00 17.53           C  
ATOM   1012  CG  PHE   122      24.571  17.769  -9.834  1.00 18.38           C  
ATOM   1013  CD1 PHE   122      24.405  16.393  -9.692  1.00 18.85           C  
ATOM   1014  CD2 PHE   122      25.873  18.316  -9.857  1.00 19.32           C  
ATOM   1015  CE1 PHE   122      25.520  15.545  -9.598  1.00 21.40           C  
ATOM   1016  CE2 PHE   122      26.990  17.492  -9.795  1.00 19.08           C  
ATOM   1017  CZ  PHE   122      26.818  16.100  -9.644  1.00 20.67           C  
ATOM   1018  N   THR   123      23.937  18.023  -6.636  1.00 14.58           N  
ATOM   1019  CA  THR   123      24.913  18.081  -5.558  1.00 13.79           C  
ATOM   1020  C   THR   123      26.057  17.091  -5.784  1.00 13.81           C  
ATOM   1021  O   THR   123      25.815  15.882  -5.743  1.00 14.03           O  
ATOM   1022  CB  THR   123      24.210  17.757  -4.229  1.00 13.79           C  
ATOM   1023  OG1 THR   123      23.150  18.714  -4.043  1.00 13.23           O  
ATOM   1024  CG2 THR   123      25.165  17.834  -3.075  1.00 13.37           C  
ATOM   1025  N   PRO   124      27.298  17.598  -5.974  1.00 13.35           N  
ATOM   1026  CA  PRO   124      28.459  16.717  -6.210  1.00 12.91           C  
ATOM   1027  C   PRO   124      28.835  15.980  -4.923  1.00 13.01           C  
ATOM   1028  O   PRO   124      28.407  16.405  -3.816  1.00 12.54           O  
ATOM   1029  CB  PRO   124      29.580  17.679  -6.617  1.00 14.14           C  
ATOM   1030  CG  PRO   124      29.146  19.047  -6.128  1.00 13.45           C  
ATOM   1031  CD  PRO   124      27.650  19.032  -5.972  1.00 12.87           C  
ATOM   1032  N   PRO   125      29.655  14.912  -5.037  1.00 13.44           N  
ATOM   1033  CA  PRO   125      30.187  14.273  -3.846  1.00 13.53           C  
ATOM   1034  C   PRO   125      30.823  15.290  -2.880  1.00 13.16           C  
ATOM   1035  O   PRO   125      31.621  16.109  -3.298  1.00 12.44           O  
ATOM   1036  CB  PRO   125      31.230  13.295  -4.423  1.00 14.24           C  
ATOM   1037  CG  PRO   125      30.673  12.977  -5.804  1.00 15.16           C  
ATOM   1038  CD  PRO   125      30.160  14.294  -6.276  1.00 14.35           C  
ATOM   1039  N   GLY   126      30.452  15.221  -1.600  1.00 13.37           N  
ATOM   1040  CA  GLY   126      30.991  16.124  -0.568  1.00 12.38           C  
ATOM   1041  C   GLY   126      30.260  17.469  -0.494  1.00 12.55           C  
ATOM   1042  O   GLY   126      30.558  18.265   0.386  1.00 14.16           O  
ATOM   1043  N   GLY   127      29.307  17.701  -1.375  1.00 12.12           N  
ATOM   1044  CA  GLY   127      28.544  18.974  -1.397  1.00 11.03           C  
ATOM   1045  C   GLY   127      27.258  18.895  -0.603  1.00 12.16           C  
ATOM   1046  O   GLY   127      26.846  17.783  -0.121  1.00 11.11           O  
ATOM   1047  N   GLU   128      26.644  20.072  -0.380  1.00 11.01           N  
ATOM   1048  CA  GLU   128      25.330  20.188   0.289  1.00 11.89           C  
ATOM   1049  C   GLU   128      24.229  20.326  -0.747  1.00 11.34           C  
ATOM   1050  O   GLU   128      24.424  20.983  -1.790  1.00 12.25           O  
ATOM   1051  CB  GLU   128      25.265  21.460   1.176  1.00 11.43           C  
ATOM   1052  CG  GLU   128      26.020  21.334   2.516  1.00 11.16           C  
ATOM   1053  CD  GLU   128      26.067  22.656   3.250  1.00 14.31           C  
ATOM   1054  OE1 GLU   128      26.553  23.629   2.649  1.00 12.14           O  
ATOM   1055  OE2 GLU   128      25.672  22.695   4.437  1.00 17.34           O  
ATOM   1056  N   THR   129      23.055  19.755  -0.451  1.00 11.74           N  
ATOM   1057  CA  THR   129      21.827  19.964  -1.236  1.00 11.64           C  
ATOM   1058  C   THR   129      21.280  21.373  -0.977  1.00 11.58           C  
ATOM   1059  O   THR   129      21.643  21.995   0.050  1.00 10.25           O  
ATOM   1060  CB  THR   129      20.719  18.950  -0.876  1.00 12.61           C  
ATOM   1061  OG1 THR   129      20.353  19.146   0.536  1.00 14.75           O  
ATOM   1062  CG2 THR   129      21.286  17.516  -0.977  1.00 15.54           C  
ATOM   1063  N   LEU   130      20.437  21.862  -1.904  1.00 11.52           N  
ATOM   1064  CA  LEU   130      19.738  23.143  -1.676  1.00 12.31           C  
ATOM   1065  C   LEU   130      18.949  23.100  -0.380  1.00 12.77           C  
ATOM   1066  O   LEU   130      18.929  24.072   0.332  1.00 10.77           O  
ATOM   1067  CB  LEU   130      18.831  23.525  -2.852  1.00 13.53           C  
ATOM   1068  CG  LEU   130      19.595  23.847  -4.142  1.00 14.68           C  
ATOM   1069  CD1 LEU   130      18.645  24.060  -5.326  1.00 17.49           C  
ATOM   1070  CD2 LEU   130      20.532  25.046  -3.947  1.00 18.17           C  
ATOM   1071  N   ASP   131      18.345  21.964  -0.042  1.00 12.80           N  
ATOM   1072  CA  ASP   131      17.546  21.916   1.175  1.00 13.89           C  
ATOM   1073  C   ASP   131      18.433  21.950   2.421  1.00 13.08           C  
ATOM   1074  O   ASP   131      18.056  22.543   3.433  1.00 12.35           O  
ATOM   1075  CB  ASP   131      16.610  20.690   1.175  1.00 15.29           C  
ATOM   1076  CG  ASP   131      15.323  20.920   0.350  1.00 19.19           C  
ATOM   1077  OD1 ASP   131      14.896  22.070   0.066  1.00 24.81           O  
ATOM   1078  OD2 ASP   131      14.735  19.904  -0.020  1.00 27.72           O  
ATOM   1079  N   GLN   132      19.621  21.349   2.346  1.00 12.26           N  
ATOM   1080  CA  GLN   132      20.561  21.450   3.443  1.00 11.76           C  
ATOM   1081  C   GLN   132      21.019  22.912   3.650  1.00 11.28           C  
ATOM   1082  O   GLN   132      21.130  23.390   4.812  1.00  9.47           O  
ATOM   1083  CB  GLN   132      21.777  20.566   3.167  1.00 12.20           C  
ATOM   1084  CG  GLN   132      21.508  19.091   3.488  1.00 15.13           C  
ATOM   1085  CD  GLN   132      22.679  18.210   3.078  1.00 18.85           C  
ATOM   1086  OE1 GLN   132      23.201  18.338   1.971  1.00 16.27           O  
ATOM   1087  NE2 GLN   132      23.110  17.325   3.991  1.00 23.69           N  
ATOM   1088  N   VAL   133      21.279  23.616   2.550  1.00  9.48           N  
ATOM   1089  CA  VAL   133      21.651  25.041   2.659  1.00  9.49           C  
ATOM   1090  C   VAL   133      20.518  25.854   3.282  1.00  9.92           C  
ATOM   1091  O   VAL   133      20.744  26.611   4.228  1.00  9.67           O  
ATOM   1092  CB  VAL   133      22.038  25.636   1.275  1.00 10.42           C  
ATOM   1093  CG1 VAL   133      22.439  27.068   1.402  1.00 10.99           C  
ATOM   1094  CG2 VAL   133      23.237  24.856   0.663  1.00  9.59           C  
ATOM   1095  N   LYS   134      19.309  25.698   2.754  1.00 10.05           N  
ATOM   1096  CA  LYS   134      18.129  26.384   3.308  1.00 10.95           C  
ATOM   1097  C   LYS   134      17.980  26.086   4.795  1.00 11.05           C  
ATOM   1098  O   LYS   134      17.592  26.959   5.566  1.00  9.92           O  
ATOM   1099  CB  LYS   134      16.856  25.966   2.585  1.00 10.96           C  
ATOM   1100  CG  LYS   134      15.648  26.772   3.054  1.00 13.28           C  
ATOM   1101  CD  LYS   134      14.331  26.418   2.340  1.00 15.14           C  
ATOM   1102  CE  LYS   134      14.135  27.178   1.071  1.00 19.20           C  
ATOM   1103  NZ  LYS   134      12.763  26.837   0.546  1.00 22.40           N  
ATOM   1104  N   MET   135      18.239  24.845   5.204  1.00  9.06           N  
ATOM   1105  CA  MET   135      18.044  24.514   6.621  1.00 11.12           C  
ATOM   1106  C   MET   135      19.006  25.323   7.494  1.00 10.30           C  
ATOM   1107  O   MET   135      18.621  25.789   8.531  1.00 10.53           O  
ATOM   1108  CB  MET   135      18.138  22.983   6.830  1.00 11.96           C  
ATOM   1109  CG  MET   135      17.896  22.479   8.257  1.00 13.35           C  
ATOM   1110  SD  MET   135      16.066  22.913   8.811  1.00 15.75          SE  
ATOM   1111  CE  MET   135      16.394  24.116  10.229  1.00 19.57           C  
ATOM   1112  N   ARG   136      20.245  25.528   7.042  1.00  9.96           N  
ATOM   1113  CA  ARG   136      21.207  26.423   7.733  1.00  9.44           C  
ATOM   1114  C   ARG   136      20.721  27.874   7.792  1.00 10.34           C  
ATOM   1115  O   ARG   136      20.948  28.566   8.776  1.00 11.05           O  
ATOM   1116  CB  ARG   136      22.596  26.348   7.102  1.00  8.92           C  
ATOM   1117  CG  ARG   136      23.220  24.964   7.297  1.00 10.88           C  
ATOM   1118  CD  ARG   136      24.692  25.051   7.080  1.00 10.58           C  
ATOM   1119  NE  ARG   136      25.105  25.173   5.661  1.00  9.48           N  
ATOM   1120  CZ  ARG   136      25.618  26.262   5.081  1.00 10.08           C  
ATOM   1121  NH1 ARG   136      25.626  27.455   5.692  1.00  9.95           N  
ATOM   1122  NH2 ARG   136      26.066  26.169   3.812  1.00  9.85           N  
ATOM   1123  N   GLY   137      19.974  28.275   6.763  1.00  9.12           N  
ATOM   1124  CA  GLY   137      19.362  29.616   6.694  1.00 10.59           C  
ATOM   1125  C   GLY   137      18.235  29.727   7.721  1.00 10.98           C  
ATOM   1126  O   GLY   137      18.143  30.735   8.466  1.00 10.49           O  
ATOM   1127  N   ILE   138      17.365  28.706   7.739  1.00 10.10           N  
ATOM   1128  CA  ILE   138      16.271  28.625   8.740  1.00  9.94           C  
ATOM   1129  C   ILE   138      16.838  28.634  10.204  1.00 10.47           C  
ATOM   1130  O   ILE   138      16.357  29.367  11.071  1.00 10.30           O  
ATOM   1131  CB  ILE   138      15.379  27.383   8.485  1.00  9.63           C  
ATOM   1132  CG1 ILE   138      14.688  27.518   7.103  1.00  9.46           C  
ATOM   1133  CG2 ILE   138      14.331  27.262   9.586  1.00 12.67           C  
ATOM   1134  CD1 ILE   138      13.942  26.227   6.728  1.00 10.38           C  
ATOM   1135  N   ASP   139      17.871  27.827  10.446  1.00 10.75           N  
ATOM   1136  CA  ASP   139      18.523  27.719  11.751  1.00 12.25           C  
ATOM   1137  C   ASP   139      19.051  29.087  12.177  1.00 11.78           C  
ATOM   1138  O   ASP   139      18.744  29.575  13.280  1.00 12.04           O  
ATOM   1139  CB  ASP   139      19.665  26.694  11.614  1.00 12.31           C  
ATOM   1140  CG  ASP   139      20.421  26.416  12.931  1.00 17.51           C  
ATOM   1141  OD1 ASP   139      20.224  27.111  13.931  1.00 23.55           O  
ATOM   1142  OD2 ASP   139      21.267  25.482  12.918  1.00 23.53           O  
ATOM   1143  N   PHE   140      19.828  29.719  11.300  1.00 10.99           N  
ATOM   1144  CA  PHE   140      20.375  31.032  11.623  1.00 11.07           C  
ATOM   1145  C   PHE   140      19.255  32.044  11.868  1.00 10.71           C  
ATOM   1146  O   PHE   140      19.280  32.819  12.844  1.00 11.15           O  
ATOM   1147  CB  PHE   140      21.308  31.564  10.533  1.00 10.66           C  
ATOM   1148  CG  PHE   140      21.842  32.928  10.882  1.00 11.12           C  
ATOM   1149  CD1 PHE   140      22.879  33.030  11.802  1.00 13.72           C  
ATOM   1150  CD2 PHE   140      21.241  34.092  10.383  1.00 11.20           C  
ATOM   1151  CE1 PHE   140      23.358  34.277  12.190  1.00 13.44           C  
ATOM   1152  CE2 PHE   140      21.724  35.384  10.768  1.00 11.43           C  
ATOM   1153  CZ  PHE   140      22.778  35.452  11.680  1.00 13.56           C  
ATOM   1154  N   PHE   141      18.275  32.061  10.961  1.00  9.26           N  
ATOM   1155  CA  PHE   141      17.192  33.042  11.078  1.00  9.67           C  
ATOM   1156  C   PHE   141      16.396  32.886  12.391  1.00  9.64           C  
ATOM   1157  O   PHE   141      16.073  33.884  13.054  1.00 10.41           O  
ATOM   1158  CB  PHE   141      16.224  32.908   9.897  1.00  9.66           C  
ATOM   1159  CG  PHE   141      15.129  33.941   9.915  1.00 10.69           C  
ATOM   1160  CD1 PHE   141      15.453  35.288   9.712  1.00 11.03           C  
ATOM   1161  CD2 PHE   141      13.787  33.576  10.129  1.00 13.04           C  
ATOM   1162  CE1 PHE   141      14.439  36.279   9.718  1.00 13.41           C  
ATOM   1163  CE2 PHE   141      12.752  34.558  10.131  1.00 12.72           C  
ATOM   1164  CZ  PHE   141      13.090  35.911   9.934  1.00 12.61           C  
ATOM   1165  N   GLU   142      16.056  31.654  12.739  1.00 10.90           N  
ATOM   1166  CA  GLU   142      15.343  31.419  14.018  1.00 12.50           C  
ATOM   1167  C   GLU   142      16.180  31.860  15.208  1.00 12.76           C  
ATOM   1168  O   GLU   142      15.645  32.512  16.144  1.00 12.86           O  
ATOM   1169  CB  GLU   142      14.956  29.948  14.133  1.00 14.29           C  
ATOM   1170  CG  GLU   142      13.950  29.649  13.002  1.00 18.51           C  
ATOM   1171  CD  GLU   142      13.206  28.339  13.106  1.00 26.10           C  
ATOM   1172  OE1 GLU   142      12.074  28.285  12.548  1.00 26.39           O  
ATOM   1173  OE2 GLU   142      13.733  27.380  13.716  1.00 30.36           O  
ATOM   1174  N   PHE   143      17.468  31.490  15.178  1.00 11.64           N  
ATOM   1175  CA  PHE   143      18.452  31.988  16.154  1.00 12.86           C  
ATOM   1176  C   PHE   143      18.407  33.541  16.285  1.00 13.14           C  
ATOM   1177  O   PHE   143      18.296  34.089  17.402  1.00 12.88           O  
ATOM   1178  CB  PHE   143      19.855  31.490  15.793  1.00 14.14           C  
ATOM   1179  CG  PHE   143      20.971  32.331  16.383  1.00 16.21           C  
ATOM   1180  CD1 PHE   143      21.327  32.196  17.723  1.00 19.07           C  
ATOM   1181  CD2 PHE   143      21.602  33.302  15.624  1.00 15.91           C  
ATOM   1182  CE1 PHE   143      22.348  32.991  18.271  1.00 20.54           C  
ATOM   1183  CE2 PHE   143      22.596  34.111  16.160  1.00 20.18           C  
ATOM   1184  CZ  PHE   143      22.977  33.955  17.484  1.00 17.61           C  
ATOM   1185  N   LEU   144      18.513  34.228  15.153  1.00 11.11           N  
ATOM   1186  CA  LEU   144      18.529  35.689  15.110  1.00 11.52           C  
ATOM   1187  C   LEU   144      17.234  36.287  15.704  1.00 11.63           C  
ATOM   1188  O   LEU   144      17.280  37.194  16.562  1.00 12.63           O  
ATOM   1189  CB  LEU   144      18.725  36.173  13.658  1.00 10.82           C  
ATOM   1190  CG  LEU   144      18.846  37.697  13.477  1.00 11.37           C  
ATOM   1191  CD1 LEU   144      20.007  38.293  14.264  1.00 14.98           C  
ATOM   1192  CD2 LEU   144      18.998  38.069  11.981  1.00 12.34           C  
ATOM   1193  N   CYS   145      16.089  35.738  15.280  1.00 11.54           N  
ATOM   1194  CA  CYS   145      14.771  36.188  15.771  1.00 12.26           C  
ATOM   1195  C   CYS   145      14.670  36.081  17.292  1.00 13.44           C  
ATOM   1196  O   CYS   145      14.323  37.070  17.943  1.00 13.67           O  
ATOM   1197  CB  CYS   145      13.644  35.406  15.096  1.00 12.21           C  
ATOM   1198  SG  CYS   145      13.463  35.951  13.328  1.00 14.79           S  
ATOM   1199  N   GLN   146      15.007  34.920  17.837  1.00 13.71           N  
ATOM   1200  CA  GLN   146      15.004  34.707  19.294  1.00 15.59           C  
ATOM   1201  C   GLN   146      15.946  35.663  20.006  1.00 15.93           C  
ATOM   1202  O   GLN   146      15.580  36.240  21.051  1.00 15.40           O  
ATOM   1203  CB  GLN   146      15.332  33.252  19.635  1.00 16.45           C  
ATOM   1204  CG  GLN   146      14.186  32.288  19.241  1.00 22.14           C  
ATOM   1205  CD  GLN   146      12.874  32.640  19.971  1.00 29.71           C  
ATOM   1206  OE1 GLN   146      12.777  32.509  21.201  1.00 32.44           O  
ATOM   1207  NE2 GLN   146      11.882  33.131  19.216  1.00 32.00           N  
ATOM   1208  N   LEU   147      17.138  35.859  19.428  1.00 15.37           N  
ATOM   1209  CA  LEU   147      18.154  36.782  19.976  1.00 15.16           C  
ATOM   1210  C   LEU   147      17.588  38.202  20.161  1.00 15.14           C  
ATOM   1211  O   LEU   147      17.635  38.785  21.258  1.00 15.30           O  
ATOM   1212  CB  LEU   147      19.390  36.799  19.053  1.00 14.58           C  
ATOM   1213  CG  LEU   147      20.477  37.750  19.578  1.00 18.48           C  
ATOM   1214  CD1 LEU   147      21.277  37.026  20.669  1.00 24.94           C  
ATOM   1215  CD2 LEU   147      21.391  38.217  18.509  1.00 21.05           C  
ATOM   1216  N   ILE   148      17.013  38.730  19.088  1.00 13.47           N  
ATOM   1217  CA  ILE   148      16.472  40.085  19.047  1.00 13.77           C  
ATOM   1218  C   ILE   148      15.277  40.239  19.987  1.00 13.26           C  
ATOM   1219  O   ILE   148      15.188  41.254  20.716  1.00 13.49           O  
ATOM   1220  CB  ILE   148      16.083  40.484  17.599  1.00 13.22           C  
ATOM   1221  CG1 ILE   148      17.315  40.531  16.688  1.00 12.36           C  
ATOM   1222  CG2 ILE   148      15.325  41.837  17.556  1.00 15.01           C  
ATOM   1223  CD1 ILE   148      18.530  41.337  17.225  1.00 14.76           C  
ATOM   1224  N   LEU   149      14.378  39.253  19.981  1.00 13.33           N  
ATOM   1225  CA  LEU   149      13.166  39.304  20.851  1.00 12.70           C  
ATOM   1226  C   LEU   149      13.587  39.302  22.328  1.00 13.92           C  
ATOM   1227  O   LEU   149      13.110  40.134  23.119  1.00 13.08           O  
ATOM   1228  CB  LEU   149      12.228  38.132  20.556  1.00 13.22           C  
ATOM   1229  CG  LEU   149      11.562  38.284  19.170  1.00 11.59           C  
ATOM   1230  CD1 LEU   149      10.787  36.997  18.820  1.00 14.38           C  
ATOM   1231  CD2 LEU   149      10.627  39.515  19.141  1.00 16.20           C  
ATOM   1232  N   LYS   150      14.521  38.415  22.660  1.00 13.32           N  
ATOM   1233  CA  LYS   150      15.031  38.306  24.051  1.00 15.01           C  
ATOM   1234  C   LYS   150      15.770  39.578  24.495  1.00 15.41           C  
ATOM   1235  O   LYS   150      15.614  40.042  25.647  1.00 15.91           O  
ATOM   1236  CB  LYS   150      15.924  37.077  24.192  1.00 15.61           C  
ATOM   1237  CG  LYS   150      15.172  35.781  24.225  1.00 18.33           C  
ATOM   1238  CD  LYS   150      16.140  34.636  24.225  1.00 22.37           C  
ATOM   1239  CE  LYS   150      15.405  33.333  24.046  1.00 29.21           C  
ATOM   1240  NZ  LYS   150      15.119  32.732  25.380  1.00 34.01           N  
ATOM   1241  N   GLU   151      16.566  40.159  23.600  1.00 16.59           N  
ATOM   1242  CA  GLU   151      17.236  41.421  23.903  1.00 18.62           C  
ATOM   1243  C   GLU   151      16.242  42.543  24.094  1.00 18.93           C  
ATOM   1244  O   GLU   151      16.381  43.320  25.036  1.00 19.86           O  
ATOM   1245  CB  GLU   151      18.279  41.783  22.826  1.00 18.64           C  
ATOM   1246  CG  GLU   151      19.491  40.830  22.871  1.00 20.23           C  
ATOM   1247  CD  GLU   151      20.613  41.209  21.915  1.00 21.22           C  
ATOM   1248  OE1 GLU   151      20.429  42.127  21.092  1.00 26.24           O  
ATOM   1249  OE2 GLU   151      21.676  40.557  21.971  1.00 24.90           O  
ATOM   1250  N   ALA   152      15.231  42.625  23.220  1.00 19.10           N  
ATOM   1251  CA  ALA   152      14.172  43.629  23.369  1.00 19.49           C  
ATOM   1252  C   ALA   152      13.473  43.445  24.730  1.00 19.77           C  
ATOM   1253  O   ALA   152      13.114  44.432  25.390  1.00 19.86           O  
ATOM   1254  CB  ALA   152      13.159  43.526  22.252  1.00 20.37           C  
ATOM   1255  N   ASP   153      13.259  42.188  25.112  1.00 19.41           N  
ATOM   1256  CA  ASP   153      12.605  41.850  26.380  1.00 21.62           C  
ATOM   1257  C   ASP   153      13.466  42.281  27.569  1.00 23.56           C  
ATOM   1258  O   ASP   153      12.959  42.809  28.560  1.00 23.49           O  
ATOM   1259  CB  ASP   153      12.369  40.338  26.494  1.00 20.56           C  
ATOM   1260  CG  ASP   153      11.495  39.982  27.680  1.00 19.09           C  
ATOM   1261  OD1 ASP   153      10.349  40.462  27.714  1.00 21.16           O  
ATOM   1262  OD2 ASP   153      11.962  39.243  28.563  1.00 19.70           O  
ATOM   1263  N   GLN   154      14.763  42.012  27.472  1.00 26.71           N  
ATOM   1264  CA  GLN   154      15.697  42.277  28.574  1.00 30.61           C  
ATOM   1265  C   GLN   154      16.002  43.776  28.747  1.00 32.44           C  
ATOM   1266  O   GLN   154      16.568  44.176  29.779  1.00 34.00           O  
ATOM   1267  CB  GLN   154      16.979  41.429  28.444  1.00 30.79           C  
ATOM   1268  CG  GLN   154      16.770  39.895  28.461  1.00 33.07           C  
ATOM   1269  CD  GLN   154      16.043  39.367  29.699  1.00 37.37           C  
ATOM   1270  OE1 GLN   154      16.550  39.443  30.823  1.00 39.46           O  
ATOM   1271  NE2 GLN   154      14.846  38.807  29.487  1.00 40.42           N  
ATOM   1272  N   LYS   155      15.587  44.612  27.785  1.00 34.64           N  
ATOM   1273  CA  LYS   155      15.755  46.085  27.881  1.00 36.26           C  
ATOM   1274  C   LYS   155      14.446  46.864  28.024  1.00 36.17           C  
ATOM   1275  O   LYS   155      13.360  46.298  28.201  1.00 37.58           O  
ATOM   1276  CB  LYS   155      16.523  46.682  26.678  1.00 36.32           C  
ATOM   1277  CG  LYS   155      17.355  45.733  25.836  1.00 39.40           C  
ATOM   1278  CD  LYS   155      18.806  45.627  26.267  1.00 40.09           C  
ATOM   1279  CE  LYS   155      19.565  44.727  25.301  1.00 43.03           C  
ATOM   1280  NZ  LYS   155      19.928  45.384  24.002  1.00 43.48           N  
ATOM   1281  N   ASN   165      12.474  55.446  15.912  1.00 41.07           N  
ATOM   1282  CA  ASN   165      12.786  56.233  14.721  1.00 40.86           C  
ATOM   1283  C   ASN   165      14.225  56.117  14.260  1.00 39.46           C  
ATOM   1284  O   ASN   165      14.474  55.926  13.065  1.00 39.76           O  
ATOM   1285  CB  ASN   165      12.495  57.726  14.953  1.00 41.56           C  
ATOM   1286  CG  ASN   165      11.019  58.026  15.088  1.00 43.79           C  
ATOM   1287  OD1 ASN   165      10.175  57.371  14.470  1.00 47.63           O  
ATOM   1288  ND2 ASN   165      10.696  59.042  15.885  1.00 46.17           N  
ATOM   1289  N   CYS   166      15.149  56.242  15.216  1.00 37.98           N  
ATOM   1290  CA  CYS   166      16.580  56.379  14.945  0.50 36.88           C  
ATOM   1292  C   CYS   166      17.170  55.327  13.986  1.00 36.05           C  
ATOM   1293  O   CYS   166      17.921  55.653  13.041  1.00 35.95           O  
ATOM   1294  CB  CYS   166      17.329  56.360  16.274  0.50 37.09           C  
ATOM   1296  SG  CYS   166      19.092  56.519  16.131  0.50 38.12           S  
ATOM   1298  N   LEU   167      16.844  54.063  14.232  1.00 33.59           N  
ATOM   1299  CA  LEU   167      17.349  52.984  13.376  1.00 30.89           C  
ATOM   1300  C   LEU   167      16.723  53.022  11.973  1.00 29.85           C  
ATOM   1301  O   LEU   167      17.438  52.862  10.974  1.00 28.15           O  
ATOM   1302  CB  LEU   167      17.144  51.623  14.043  1.00 29.90           C  
ATOM   1303  CG  LEU   167      17.722  51.341  15.434  1.00 29.69           C  
ATOM   1304  CD1 LEU   167      17.442  49.901  15.841  1.00 27.15           C  
ATOM   1305  CD2 LEU   167      19.210  51.625  15.503  1.00 27.72           C  
ATOM   1306  N   GLU   168      15.405  53.265  11.905  1.00 28.65           N  
ATOM   1307  CA  GLU   168      14.659  53.300  10.634  1.00 28.93           C  
ATOM   1308  C   GLU   168      15.057  54.494   9.758  1.00 27.44           C  
ATOM   1309  O   GLU   168      15.255  54.348   8.551  1.00 27.06           O  
ATOM   1310  CB  GLU   168      13.141  53.301  10.891  1.00 29.00           C  
ATOM   1311  CG  GLU   168      12.255  53.014   9.660  1.00 30.98           C  
ATOM   1312  CD  GLU   168      10.935  52.292  10.007  1.00 32.01           C  
ATOM   1313  OE1 GLU   168      10.464  52.369  11.172  1.00 35.69           O  
ATOM   1314  OE2 GLU   168      10.375  51.617   9.112  1.00 36.97           O  
ATOM   1315  N   THR   169      15.176  55.673  10.373  1.00 27.30           N  
ATOM   1316  CA  THR   169      15.520  56.891   9.635  1.00 27.25           C  
ATOM   1317  C   THR   169      16.842  56.760   8.882  1.00 26.37           C  
ATOM   1318  O   THR   169      16.923  57.137   7.709  1.00 26.91           O  
ATOM   1319  CB  THR   169      15.510  58.168  10.544  1.00 27.66           C  
ATOM   1320  OG1 THR   169      16.549  58.072  11.523  1.00 29.75           O  
ATOM   1321  CG2 THR   169      14.185  58.297  11.260  1.00 27.52           C  
ATOM   1322  N   SER   170      17.848  56.182   9.535  1.00 26.61           N  
ATOM   1323  CA  SER   170      19.174  56.002   8.917  1.00 26.93           C  
ATOM   1324  C   SER   170      19.123  55.010   7.750  1.00 26.69           C  
ATOM   1325  O   SER   170      19.792  55.208   6.740  1.00 27.67           O  
ATOM   1326  CB  SER   170      20.248  55.639   9.958  1.00 27.25           C  
ATOM   1327  OG  SER   170      20.071  54.353  10.510  1.00 28.32           O  
ATOM   1328  N   LEU   171      18.305  53.966   7.868  1.00 26.17           N  
ATOM   1329  CA  LEU   171      18.040  53.090   6.720  1.00 25.72           C  
ATOM   1330  C   LEU   171      17.287  53.802   5.580  1.00 26.04           C  
ATOM   1331  O   LEU   171      17.639  53.648   4.407  1.00 25.52           O  
ATOM   1332  CB  LEU   171      17.298  51.821   7.156  1.00 25.40           C  
ATOM   1333  CG  LEU   171      18.092  50.830   8.015  1.00 24.74           C  
ATOM   1334  CD1 LEU   171      17.136  49.817   8.632  1.00 23.70           C  
ATOM   1335  CD2 LEU   171      19.200  50.144   7.186  1.00 22.15           C  
ATOM   1336  N   ALA   172      16.256  54.588   5.927  1.00 26.86           N  
ATOM   1337  CA  ALA   172      15.388  55.251   4.933  1.00 27.07           C  
ATOM   1338  C   ALA   172      16.132  56.273   4.070  1.00 27.99           C  
ATOM   1339  O   ALA   172      15.687  56.601   2.959  1.00 28.28           O  
ATOM   1340  CB  ALA   172      14.173  55.917   5.628  1.00 26.59           C  
ATOM   1341  N   GLU   173      17.268  56.735   4.592  1.00 28.87           N  
ATOM   1342  CA  GLU   173      18.192  57.649   3.923  1.00 31.20           C  
ATOM   1343  C   GLU   173      18.737  57.100   2.610  1.00 30.70           C  
ATOM   1344  O   GLU   173      19.006  57.862   1.683  1.00 30.82           O  
ATOM   1345  CB  GLU   173      19.397  57.907   4.827  1.00 31.14           C  
ATOM   1346  CG  GLU   173      19.240  59.056   5.812  1.00 33.97           C  
ATOM   1347  CD  GLU   173      20.443  59.217   6.735  1.00 34.81           C  
ATOM   1348  OE1 GLU   173      21.599  58.949   6.305  1.00 37.15           O  
ATOM   1349  OE2 GLU   173      20.223  59.620   7.912  1.00 40.87           O  
ATOM   1350  N   ILE   174      18.937  55.779   2.550  1.00 29.59           N  
ATOM   1351  CA  ILE   174      19.664  55.177   1.444  1.00 28.75           C  
ATOM   1352  C   ILE   174      18.945  53.993   0.816  1.00 27.96           C  
ATOM   1353  O   ILE   174      19.270  53.604  -0.303  1.00 28.16           O  
ATOM   1354  CB  ILE   174      21.095  54.747   1.855  1.00 28.85           C  
ATOM   1355  CG1 ILE   174      21.047  53.714   2.996  1.00 28.35           C  
ATOM   1356  CG2 ILE   174      21.951  55.980   2.220  1.00 28.66           C  
ATOM   1357  CD1 ILE   174      22.382  53.050   3.268  1.00 28.84           C  
ATOM   1358  N   PHE   175      17.976  53.438   1.545  1.00 27.25           N  
ATOM   1359  CA  PHE   175      17.154  52.313   1.089  1.00 27.16           C  
ATOM   1360  C   PHE   175      15.712  52.748   0.844  1.00 27.96           C  
ATOM   1361  O   PHE   175      15.198  53.589   1.591  1.00 28.32           O  
ATOM   1362  CB  PHE   175      17.148  51.197   2.138  1.00 25.39           C  
ATOM   1363  CG  PHE   175      18.448  50.476   2.254  1.00 25.02           C  
ATOM   1364  CD1 PHE   175      19.000  49.831   1.144  1.00 22.62           C  
ATOM   1365  CD2 PHE   175      19.138  50.455   3.463  1.00 23.11           C  
ATOM   1366  CE1 PHE   175      20.233  49.168   1.253  1.00 22.60           C  
ATOM   1367  CE2 PHE   175      20.371  49.793   3.582  1.00 23.59           C  
ATOM   1368  CZ  PHE   175      20.907  49.145   2.472  1.00 22.09           C  
ATOM   1369  N   PRO   176      15.042  52.144  -0.159  1.00 28.92           N  
ATOM   1370  CA  PRO   176      13.659  52.519  -0.523  1.00 29.85           C  
ATOM   1371  C   PRO   176      12.546  52.111   0.472  1.00 30.23           C  
ATOM   1372  O   PRO   176      11.619  51.369   0.120  1.00 29.89           O  
ATOM   1373  CB  PRO   176      13.460  51.839  -1.879  1.00 29.67           C  
ATOM   1374  CG  PRO   176      14.364  50.658  -1.842  1.00 29.69           C  
ATOM   1375  CD  PRO   176      15.559  51.076  -1.037  1.00 29.70           C  
ATOM   1376  N   LEU   177      12.649  52.594   1.702  1.00 31.32           N  
ATOM   1377  CA  LEU   177      11.584  52.454   2.669  1.00 32.99           C  
ATOM   1378  C   LEU   177      10.558  53.566   2.434  1.00 34.01           C  
ATOM   1379  O   LEU   177       9.364  53.292   2.296  1.00 35.48           O  
ATOM   1380  CB  LEU   177      12.135  52.570   4.085  1.00 33.09           C  
ATOM   1381  CG  LEU   177      12.901  51.402   4.709  1.00 33.87           C  
ATOM   1382  CD1 LEU   177      13.626  51.910   5.929  1.00 35.29           C  
ATOM   1383  CD2 LEU   177      11.974  50.264   5.097  1.00 34.86           C  
ATOM   1384  N   ILE   191       3.939  49.630  13.570  1.00 39.51           N  
ATOM   1385  CA  ILE   191       3.880  50.674  14.609  1.00 39.47           C  
ATOM   1386  C   ILE   191       5.049  50.664  15.620  1.00 38.14           C  
ATOM   1387  O   ILE   191       5.580  51.740  15.924  1.00 37.87           O  
ATOM   1388  CB  ILE   191       2.462  50.789  15.328  1.00 39.29           C  
ATOM   1389  CG1 ILE   191       2.433  51.996  16.290  1.00 40.74           C  
ATOM   1390  CG2 ILE   191       2.038  49.463  16.001  1.00 40.80           C  
ATOM   1391  CD1 ILE   191       1.296  52.006  17.340  1.00 40.39           C  
ATOM   1392  N   PRO   192       5.482  49.463  16.109  1.00 37.22           N  
ATOM   1393  CA  PRO   192       6.645  49.479  17.014  1.00 35.79           C  
ATOM   1394  C   PRO   192       7.866  50.047  16.289  1.00 34.05           C  
ATOM   1395  O   PRO   192       8.092  49.699  15.126  1.00 34.00           O  
ATOM   1396  CB  PRO   192       6.894  47.986  17.313  1.00 35.96           C  
ATOM   1397  CG  PRO   192       5.638  47.306  17.007  1.00 36.88           C  
ATOM   1398  CD  PRO   192       5.026  48.079  15.861  1.00 37.57           C  
ATOM   1399  N   GLY   193       8.628  50.919  16.953  1.00 32.00           N  
ATOM   1400  CA  GLY   193       9.924  51.376  16.415  1.00 29.30           C  
ATOM   1401  C   GLY   193      10.830  50.158  16.267  1.00 26.86           C  
ATOM   1402  O   GLY   193      10.654  49.181  16.991  1.00 27.57           O  
ATOM   1403  N   LEU   194      11.785  50.196  15.335  1.00 25.02           N  
ATOM   1404  CA  LEU   194      12.666  49.029  15.119  1.00 22.05           C  
ATOM   1405  C   LEU   194      13.431  48.669  16.374  1.00 21.47           C  
ATOM   1406  O   LEU   194      14.097  49.519  16.968  1.00 20.52           O  
ATOM   1407  CB  LEU   194      13.667  49.268  13.981  1.00 22.03           C  
ATOM   1408  CG  LEU   194      13.115  49.448  12.567  1.00 21.92           C  
ATOM   1409  CD1 LEU   194      14.218  49.717  11.554  1.00 21.24           C  
ATOM   1410  CD2 LEU   194      12.268  48.216  12.181  1.00 19.60           C  
ATOM   1411  N   ALA   195      13.359  47.408  16.768  1.00 19.34           N  
ATOM   1412  CA  ALA   195      14.067  46.936  17.943  1.00 18.73           C  
ATOM   1413  C   ALA   195      15.570  46.801  17.690  1.00 18.18           C  
ATOM   1414  O   ALA   195      16.388  46.907  18.607  1.00 18.05           O  
ATOM   1415  CB  ALA   195      13.484  45.595  18.409  1.00 18.89           C  
ATOM   1416  N   ALA   196      15.917  46.565  16.437  1.00 16.89           N  
ATOM   1417  CA  ALA   196      17.301  46.288  16.039  1.00 15.01           C  
ATOM   1418  C   ALA   196      17.445  46.486  14.517  1.00 14.33           C  
ATOM   1419  O   ALA   196      16.454  46.568  13.795  1.00 13.96           O  
ATOM   1420  CB  ALA   196      17.727  44.886  16.457  1.00 15.92           C  
ATOM   1421  N   SER   197      18.707  46.610  14.069  1.00 13.64           N  
ATOM   1422  CA  SER   197      19.075  46.758  12.665  1.00 13.45           C  
ATOM   1423  C   SER   197      20.336  45.904  12.511  1.00 13.46           C  
ATOM   1424  O   SER   197      21.446  46.289  12.920  1.00 13.37           O  
ATOM   1425  CB  SER   197      19.358  48.221  12.305  1.00 13.58           C  
ATOM   1426  OG  SER   197      19.622  48.367  10.900  1.00 14.68           O  
ATOM   1427  N   VAL   198      20.138  44.726  11.921  1.00 13.15           N  
ATOM   1428  CA  VAL   198      21.175  43.684  11.893  1.00 13.08           C  
ATOM   1429  C   VAL   198      21.837  43.708  10.520  1.00 13.08           C  
ATOM   1430  O   VAL   198      21.150  43.812   9.488  1.00 13.79           O  
ATOM   1431  CB  VAL   198      20.539  42.297  12.111  1.00 12.94           C  
ATOM   1432  CG1 VAL   198      21.583  41.206  11.969  1.00 13.89           C  
ATOM   1433  CG2 VAL   198      19.785  42.182  13.457  1.00 12.57           C  
ATOM   1434  N   LEU   199      23.165  43.640  10.519  1.00 12.11           N  
ATOM   1435  CA  LEU   199      23.944  43.552   9.280  1.00 11.62           C  
ATOM   1436  C   LEU   199      24.484  42.142   9.161  1.00 11.23           C  
ATOM   1437  O   LEU   199      25.156  41.672  10.058  1.00 11.71           O  
ATOM   1438  CB  LEU   199      25.143  44.520   9.306  1.00 12.31           C  
ATOM   1439  CG  LEU   199      26.104  44.482   8.086  1.00 11.66           C  
ATOM   1440  CD1 LEU   199      25.454  44.717   6.697  1.00 13.39           C  
ATOM   1441  CD2 LEU   199      27.300  45.506   8.317  1.00 12.95           C  
ATOM   1442  N   VAL   200      24.258  41.507   8.006  1.00 10.78           N  
ATOM   1443  CA  VAL   200      24.776  40.120   7.811  1.00  8.76           C  
ATOM   1444  C   VAL   200      25.585  40.101   6.520  1.00  9.38           C  
ATOM   1445  O   VAL   200      25.108  40.550   5.475  1.00 10.10           O  
ATOM   1446  CB  VAL   200      23.609  39.072   7.698  1.00  8.66           C  
ATOM   1447  CG1 VAL   200      24.164  37.703   7.228  1.00  8.33           C  
ATOM   1448  CG2 VAL   200      22.846  38.947   9.017  1.00 10.38           C  
ATOM   1449  N   VAL   201      26.812  39.596   6.594  1.00  9.43           N  
ATOM   1450  CA  VAL   201      27.621  39.452   5.399  1.00  8.97           C  
ATOM   1451  C   VAL   201      27.796  37.959   5.116  1.00  9.62           C  
ATOM   1452  O   VAL   201      28.275  37.211   5.968  1.00  7.86           O  
ATOM   1453  CB  VAL   201      28.996  40.116   5.547  1.00  9.59           C  
ATOM   1454  CG1 VAL   201      29.874  39.759   4.306  1.00  9.68           C  
ATOM   1455  CG2 VAL   201      28.800  41.646   5.700  1.00 11.12           C  
ATOM   1456  N   SER   202      27.426  37.544   3.899  1.00  9.31           N  
ATOM   1457  CA  SER   202      27.409  36.101   3.605  1.00  8.95           C  
ATOM   1458  C   SER   202      27.682  35.867   2.128  1.00  9.16           C  
ATOM   1459  O   SER   202      28.438  36.636   1.488  1.00 10.38           O  
ATOM   1460  CB  SER   202      26.058  35.492   4.096  1.00  8.93           C  
ATOM   1461  OG  SER   202      25.903  34.092   3.831  1.00 10.01           O  
ATOM   1462  N   HIS   203      27.061  34.814   1.570  1.00 10.13           N  
ATOM   1463  CA  HIS   203      27.535  34.249   0.316  1.00  9.52           C  
ATOM   1464  C   HIS   203      26.367  34.086  -0.635  1.00 10.30           C  
ATOM   1465  O   HIS   203      25.216  33.917  -0.171  1.00  9.32           O  
ATOM   1466  CB  HIS   203      28.166  32.852   0.589  1.00  9.59           C  
ATOM   1467  CG  HIS   203      29.341  32.879   1.531  1.00  7.84           C  
ATOM   1468  ND1 HIS   203      30.649  32.959   1.093  1.00  9.11           N  
ATOM   1469  CD2 HIS   203      29.401  32.780   2.882  1.00 10.71           C  
ATOM   1470  CE1 HIS   203      31.465  32.895   2.139  1.00  9.53           C  
ATOM   1471  NE2 HIS   203      30.731  32.788   3.237  1.00  8.48           N  
ATOM   1472  N   GLY   204      26.642  34.041  -1.948  1.00  9.69           N  
ATOM   1473  CA  GLY   204      25.503  34.073  -2.911  1.00  9.75           C  
ATOM   1474  C   GLY   204      24.522  32.906  -2.808  1.00  9.54           C  
ATOM   1475  O   GLY   204      23.329  33.126  -2.661  1.00  9.85           O  
ATOM   1476  N   ALA   205      25.014  31.678  -2.814  1.00  9.62           N  
ATOM   1477  CA  ALA   205      24.075  30.533  -2.842  1.00  8.60           C  
ATOM   1478  C   ALA   205      23.305  30.459  -1.523  1.00  9.84           C  
ATOM   1479  O   ALA   205      22.099  30.182  -1.506  1.00  9.20           O  
ATOM   1480  CB  ALA   205      24.798  29.203  -3.200  1.00 11.04           C  
ATOM   1481  N   TYR   206      24.010  30.687  -0.419  1.00  8.72           N  
ATOM   1482  CA  TYR   206      23.350  30.676   0.884  1.00  8.73           C  
ATOM   1483  C   TYR   206      22.268  31.735   0.959  1.00  8.56           C  
ATOM   1484  O   TYR   206      21.148  31.498   1.465  1.00  8.88           O  
ATOM   1485  CB  TYR   206      24.384  30.938   1.962  1.00  7.66           C  
ATOM   1486  CG  TYR   206      23.785  30.956   3.365  1.00  9.51           C  
ATOM   1487  CD1 TYR   206      23.564  29.772   4.063  1.00  7.24           C  
ATOM   1488  CD2 TYR   206      23.374  32.155   3.961  1.00 10.79           C  
ATOM   1489  CE1 TYR   206      23.034  29.805   5.359  1.00 10.51           C  
ATOM   1490  CE2 TYR   206      22.854  32.198   5.246  1.00 11.50           C  
ATOM   1491  CZ  TYR   206      22.699  31.025   5.941  1.00 10.75           C  
ATOM   1492  OH  TYR   206      22.157  31.087   7.208  1.00 10.83           O  
ATOM   1493  N   MET   207      22.618  32.922   0.472  1.00  7.25           N  
ATOM   1494  CA  MET   207      21.640  34.024   0.460  1.00  9.04           C  
ATOM   1495  C   MET   207      20.403  33.663  -0.376  1.00  8.99           C  
ATOM   1496  O   MET   207      19.240  33.915   0.050  1.00 11.12           O  
ATOM   1497  CB  MET   207      22.287  35.307   0.016  1.00  8.31           C  
ATOM   1498  CG  MET   207      23.162  35.904   1.145  1.00  8.70           C  
ATOM   1499  SD  MET   207      24.421  37.241   0.441  1.00 11.06          SE  
ATOM   1500  CE  MET   207      23.098  38.585  -0.024  1.00 13.46           C  
ATOM   1501  N   ARG   208      20.636  33.083  -1.535  1.00 10.61           N  
ATOM   1502  CA  ARG   208      19.503  32.741  -2.425  1.00  9.90           C  
ATOM   1503  C   ARG   208      18.536  31.785  -1.713  1.00 11.11           C  
ATOM   1504  O   ARG   208      17.295  31.938  -1.782  1.00 11.37           O  
ATOM   1505  CB  ARG   208      20.015  32.179  -3.743  1.00 12.27           C  
ATOM   1506  CG  ARG   208      20.585  33.343  -4.610  1.00 15.78           C  
ATOM   1507  CD  ARG   208      20.941  32.873  -6.042  1.00 16.42           C  
ATOM   1508  NE  ARG   208      22.040  31.918  -6.103  1.00 17.26           N  
ATOM   1509  CZ  ARG   208      23.330  32.252  -6.152  1.00 16.45           C  
ATOM   1510  NH1 ARG   208      23.690  33.522  -6.102  1.00 17.32           N  
ATOM   1511  NH2 ARG   208      24.268  31.307  -6.225  1.00 17.91           N  
ATOM   1512  N   SER   209      19.091  30.845  -0.973  1.00  9.56           N  
ATOM   1513  CA  SER   209      18.271  29.853  -0.265  1.00 10.25           C  
ATOM   1514  C   SER   209      17.548  30.490   0.896  1.00 10.33           C  
ATOM   1515  O   SER   209      16.381  30.164   1.185  1.00 11.28           O  
ATOM   1516  CB  SER   209      19.144  28.705   0.232  1.00 11.33           C  
ATOM   1517  OG  SER   209      19.516  27.853  -0.832  1.00 13.34           O  
ATOM   1518  N   LEU   210      18.242  31.401   1.590  1.00 10.38           N  
ATOM   1519  CA  LEU   210      17.569  32.130   2.698  1.00  8.87           C  
ATOM   1520  C   LEU   210      16.428  32.977   2.120  1.00  9.51           C  
ATOM   1521  O   LEU   210      15.323  32.988   2.670  1.00  9.92           O  
ATOM   1522  CB  LEU   210      18.623  32.968   3.434  1.00  9.32           C  
ATOM   1523  CG  LEU   210      18.048  33.840   4.556  1.00  9.09           C  
ATOM   1524  CD1 LEU   210      17.590  32.951   5.718  1.00 10.71           C  
ATOM   1525  CD2 LEU   210      19.140  34.878   5.001  1.00 10.89           C  
ATOM   1526  N   PHE   211      16.667  33.630   0.980  1.00  9.30           N  
ATOM   1527  CA  PHE   211      15.672  34.526   0.423  1.00 10.50           C  
ATOM   1528  C   PHE   211      14.498  33.663  -0.069  1.00  9.99           C  
ATOM   1529  O   PHE   211      13.333  34.056   0.074  1.00  9.59           O  
ATOM   1530  CB  PHE   211      16.256  35.373  -0.710  1.00  9.65           C  
ATOM   1531  CG  PHE   211      17.358  36.303  -0.267  1.00 10.52           C  
ATOM   1532  CD1 PHE   211      17.539  36.610   1.083  1.00 11.62           C  
ATOM   1533  CD2 PHE   211      18.194  36.871  -1.203  1.00 14.73           C  
ATOM   1534  CE1 PHE   211      18.576  37.453   1.488  1.00 15.33           C  
ATOM   1535  CE2 PHE   211      19.217  37.745  -0.808  1.00 15.53           C  
ATOM   1536  CZ  PHE   211      19.387  38.034   0.550  1.00 13.13           C  
ATOM   1537  N   ASP   212      14.806  32.486  -0.590  1.00 10.28           N  
ATOM   1538  CA  ASP   212      13.733  31.557  -0.956  1.00 10.45           C  
ATOM   1539  C   ASP   212      12.895  31.125   0.242  1.00 10.32           C  
ATOM   1540  O   ASP   212      11.673  31.044   0.154  1.00  9.93           O  
ATOM   1541  CB  ASP   212      14.257  30.322  -1.670  1.00 11.35           C  
ATOM   1542  CG  ASP   212      13.113  29.499  -2.281  1.00 14.19           C  
ATOM   1543  OD1 ASP   212      12.306  30.036  -3.060  1.00 18.34           O  
ATOM   1544  OD2 ASP   212      12.958  28.348  -1.923  1.00 19.95           O  
ATOM   1545  N   TYR   213      13.533  30.877   1.375  1.00  9.34           N  
ATOM   1546  CA  TYR   213      12.773  30.636   2.621  1.00  9.28           C  
ATOM   1547  C   TYR   213      11.844  31.819   2.913  1.00 10.01           C  
ATOM   1548  O   TYR   213      10.654  31.633   3.166  1.00  9.71           O  
ATOM   1549  CB  TYR   213      13.741  30.430   3.765  1.00 10.44           C  
ATOM   1550  CG  TYR   213      13.072  30.316   5.104  1.00  9.68           C  
ATOM   1551  CD1 TYR   213      12.126  29.302   5.346  1.00 11.69           C  
ATOM   1552  CD2 TYR   213      13.423  31.187   6.162  1.00 11.29           C  
ATOM   1553  CE1 TYR   213      11.512  29.192   6.584  1.00 14.86           C  
ATOM   1554  CE2 TYR   213      12.818  31.065   7.378  1.00 12.39           C  
ATOM   1555  CZ  TYR   213      11.875  30.086   7.587  1.00 15.18           C  
ATOM   1556  OH  TYR   213      11.328  29.987   8.860  1.00 18.19           O  
ATOM   1557  N   PHE   214      12.362  33.044   2.825  1.00  9.20           N  
ATOM   1558  CA  PHE   214      11.530  34.208   3.131  1.00  9.42           C  
ATOM   1559  C   PHE   214      10.352  34.318   2.171  1.00 10.67           C  
ATOM   1560  O   PHE   214       9.267  34.633   2.596  1.00 10.12           O  
ATOM   1561  CB  PHE   214      12.333  35.500   3.002  1.00  9.95           C  
ATOM   1562  CG  PHE   214      13.394  35.690   4.060  1.00  8.70           C  
ATOM   1563  CD1 PHE   214      13.403  34.963   5.244  1.00  8.58           C  
ATOM   1564  CD2 PHE   214      14.387  36.661   3.852  1.00 10.59           C  
ATOM   1565  CE1 PHE   214      14.396  35.198   6.210  1.00 10.02           C  
ATOM   1566  CE2 PHE   214      15.386  36.898   4.808  1.00 10.61           C  
ATOM   1567  CZ  PHE   214      15.385  36.182   5.976  1.00 11.62           C  
ATOM   1568  N   LEU   215      10.583  34.056   0.879  1.00 10.25           N  
ATOM   1569  CA  LEU   215       9.506  34.231  -0.114  1.00 10.38           C  
ATOM   1570  C   LEU   215       8.566  33.038  -0.161  1.00 10.77           C  
ATOM   1571  O   LEU   215       7.339  33.174   0.017  1.00 11.28           O  
ATOM   1572  CB  LEU   215      10.121  34.485  -1.488  1.00 10.63           C  
ATOM   1573  CG  LEU   215       9.069  34.627  -2.612  1.00  9.43           C  
ATOM   1574  CD1 LEU   215       8.138  35.785  -2.313  1.00 12.74           C  
ATOM   1575  CD2 LEU   215       9.785  34.860  -3.967  1.00 12.27           C  
ATOM   1576  N   THR   216       9.131  31.865  -0.398  1.00 11.00           N  
ATOM   1577  CA  THR   216       8.307  30.671  -0.567  1.00 12.81           C  
ATOM   1578  C   THR   216       7.626  30.239   0.730  1.00 12.62           C  
ATOM   1579  O   THR   216       6.467  29.852   0.720  1.00 13.60           O  
ATOM   1580  CB  THR   216       9.152  29.534  -1.189  1.00 12.36           C  
ATOM   1581  OG1 THR   216       9.636  29.972  -2.460  1.00 14.69           O  
ATOM   1582  CG2 THR   216       8.319  28.262  -1.368  1.00 14.27           C  
ATOM   1583  N   ASP   217       8.359  30.285   1.847  1.00 13.20           N  
ATOM   1584  CA  ASP   217       7.882  29.746   3.104  1.00 12.92           C  
ATOM   1585  C   ASP   217       7.256  30.784   4.037  1.00 13.22           C  
ATOM   1586  O   ASP   217       6.143  30.582   4.550  1.00 15.48           O  
ATOM   1587  CB  ASP   217       9.011  28.934   3.761  1.00 13.79           C  
ATOM   1588  CG  ASP   217       9.519  27.832   2.822  1.00 16.22           C  
ATOM   1589  OD1 ASP   217       8.673  27.023   2.386  1.00 18.83           O  
ATOM   1590  OD2 ASP   217      10.702  27.797   2.466  1.00 15.17           O  
ATOM   1591  N   LEU   218       7.916  31.930   4.212  1.00 10.94           N  
ATOM   1592  CA  LEU   218       7.348  32.985   5.050  1.00 11.53           C  
ATOM   1593  C   LEU   218       6.392  33.937   4.297  1.00 11.62           C  
ATOM   1594  O   LEU   218       5.723  34.808   4.914  1.00 12.88           O  
ATOM   1595  CB  LEU   218       8.481  33.745   5.769  1.00 11.54           C  
ATOM   1596  CG  LEU   218       9.332  32.906   6.752  1.00 12.78           C  
ATOM   1597  CD1 LEU   218      10.272  33.818   7.514  1.00 12.03           C  
ATOM   1598  CD2 LEU   218       8.443  32.131   7.731  1.00 15.13           C  
ATOM   1599  N   LYS   219       6.339  33.766   2.979  1.00 11.24           N  
ATOM   1600  CA  LYS   219       5.419  34.528   2.134  1.00 12.22           C  
ATOM   1601  C   LYS   219       5.700  36.040   2.224  1.00 12.08           C  
ATOM   1602  O   LYS   219       4.752  36.851   2.263  1.00 12.49           O  
ATOM   1603  CB  LYS   219       3.949  34.225   2.515  1.00 14.45           C  
ATOM   1604  CG  LYS   219       3.542  32.732   2.601  1.00 17.85           C  
ATOM   1605  CD  LYS   219       3.793  31.984   1.282  1.00 19.35           C  
ATOM   1606  CE  LYS   219       3.347  30.499   1.371  1.00 22.17           C  
ATOM   1607  NZ  LYS   219       3.656  29.950   2.699  1.00 27.12           N  
ATOM   1608  N   CYS   220       7.000  36.404   2.185  1.00 11.26           N  
ATOM   1609  CA  CYS   220       7.395  37.824   2.261  0.80 11.17           C  
ATOM   1611  C   CYS   220       6.842  38.615   1.085  1.00 11.75           C  
ATOM   1612  O   CYS   220       6.593  38.082  -0.005  1.00 11.77           O  
ATOM   1613  CB  CYS   220       8.907  38.003   2.340  0.80 11.41           C  
ATOM   1615  SG  CYS   220       9.772  37.747   0.774  0.80 12.73           S  
ATOM   1617  N   SER   221       6.585  39.897   1.334  1.00 12.01           N  
ATOM   1618  CA  SER   221       6.150  40.778   0.265  1.00 13.09           C  
ATOM   1619  C   SER   221       7.377  41.226  -0.550  1.00 14.04           C  
ATOM   1620  O   SER   221       8.492  41.258  -0.029  1.00 14.60           O  
ATOM   1621  CB  SER   221       5.389  41.968   0.837  1.00 13.77           C  
ATOM   1622  OG  SER   221       6.180  42.739   1.729  1.00 13.35           O  
ATOM   1623  N   LEU   222       7.165  41.555  -1.822  1.00 15.54           N  
ATOM   1624  CA  LEU   222       8.265  41.947  -2.720  1.00 17.54           C  
ATOM   1625  C   LEU   222       7.970  43.329  -3.322  1.00 19.60           C  
ATOM   1626  O   LEU   222       6.825  43.619  -3.649  1.00 20.17           O  
ATOM   1627  CB  LEU   222       8.395  40.946  -3.869  1.00 17.61           C  
ATOM   1628  CG  LEU   222       8.783  39.513  -3.568  1.00 18.69           C  
ATOM   1629  CD1 LEU   222       8.813  38.720  -4.849  1.00 19.94           C  
ATOM   1630  CD2 LEU   222      10.141  39.432  -2.857  1.00 20.71           C  
ATOM   1631  N   PRO   223       9.006  44.170  -3.499  1.00 22.05           N  
ATOM   1632  CA  PRO   223       8.735  45.432  -4.199  1.00 23.24           C  
ATOM   1633  C   PRO   223       8.219  45.147  -5.644  1.00 24.73           C  
ATOM   1634  O   PRO   223       8.453  44.071  -6.172  1.00 23.36           O  
ATOM   1635  CB  PRO   223      10.102  46.129  -4.224  1.00 22.98           C  
ATOM   1636  CG  PRO   223      10.992  45.386  -3.256  1.00 23.58           C  
ATOM   1637  CD  PRO   223      10.414  43.998  -3.114  1.00 22.06           C  
ATOM   1638  N   ALA   224       7.538  46.118  -6.255  1.00 26.52           N  
ATOM   1639  CA  ALA   224       7.013  45.993  -7.628  1.00 27.20           C  
ATOM   1640  C   ALA   224       8.122  45.798  -8.679  1.00 27.32           C  
ATOM   1641  O   ALA   224       7.891  45.228  -9.744  1.00 27.65           O  
ATOM   1642  CB  ALA   224       6.187  47.210  -7.969  1.00 27.94           C  
ATOM   1643  N   THR   225       9.320  46.257  -8.349  1.00 27.06           N  
ATOM   1644  CA  THR   225      10.485  46.172  -9.227  1.00 27.45           C  
ATOM   1645  C   THR   225      11.260  44.855  -9.100  1.00 26.00           C  
ATOM   1646  O   THR   225      12.251  44.629  -9.804  1.00 26.66           O  
ATOM   1647  CB  THR   225      11.428  47.339  -8.900  1.00 28.46           C  
ATOM   1648  OG1 THR   225      11.377  47.607  -7.486  1.00 31.78           O  
ATOM   1649  CG2 THR   225      10.985  48.581  -9.650  1.00 30.14           C  
ATOM   1650  N   LEU   226      10.828  43.975  -8.199  1.00 23.06           N  
ATOM   1651  CA  LEU   226      11.565  42.749  -7.951  0.70 22.35           C  
ATOM   1653  C   LEU   226      10.794  41.516  -8.397  1.00 22.73           C  
ATOM   1654  O   LEU   226       9.766  41.165  -7.805  1.00 23.06           O  
ATOM   1655  CB  LEU   226      11.915  42.621  -6.462  0.70 22.21           C  
ATOM   1657  CG  LEU   226      12.645  41.357  -6.011  0.70 21.36           C  
ATOM   1659  CD1 LEU   226      14.027  41.305  -6.595  0.70 19.42           C  
ATOM   1661  CD2 LEU   226      12.727  41.337  -4.500  0.70 21.10           C  
ATOM   1663  N   SER   227      11.318  40.850  -9.417  1.00 21.25           N  
ATOM   1664  CA  SER   227      10.727  39.614  -9.908  1.00 20.51           C  
ATOM   1665  C   SER   227      11.064  38.461  -8.957  1.00 20.26           C  
ATOM   1666  O   SER   227      12.080  38.498  -8.239  1.00 19.13           O  
ATOM   1667  CB  SER   227      11.282  39.296 -11.304  1.00 20.26           C  
ATOM   1668  OG  SER   227      12.667  39.041 -11.219  1.00 20.10           O  
ATOM   1669  N   ARG   228      10.236  37.418  -8.960  1.00 20.07           N  
ATOM   1670  CA  ARG   228      10.622  36.175  -8.282  1.00 19.92           C  
ATOM   1671  C   ARG   228      11.911  35.579  -8.856  1.00 20.94           C  
ATOM   1672  O   ARG   228      12.730  35.000  -8.118  1.00 20.58           O  
ATOM   1673  CB  ARG   228       9.483  35.143  -8.344  1.00 19.92           C  
ATOM   1674  CG  ARG   228       8.135  35.696  -7.878  1.00 20.51           C  
ATOM   1675  CD  ARG   228       7.076  34.614  -7.959  1.00 21.49           C  
ATOM   1676  NE  ARG   228       7.084  33.695  -6.813  1.00 21.75           N  
ATOM   1677  CZ  ARG   228       6.488  33.960  -5.648  1.00 21.92           C  
ATOM   1678  NH1 ARG   228       6.549  33.053  -4.678  1.00 21.92           N  
ATOM   1679  NH2 ARG   228       5.858  35.129  -5.441  1.00 19.45           N  
ATOM   1680  N   SER   229      12.135  35.746 -10.171  1.00 20.25           N  
ATOM   1681  CA  SER   229      13.321  35.200 -10.798  1.00 20.93           C  
ATOM   1682  C   SER   229      14.635  35.825 -10.306  1.00 20.97           C  
ATOM   1683  O   SER   229      15.655  35.134 -10.249  1.00 20.98           O  
ATOM   1684  CB  SER   229      13.227  35.330 -12.319  1.00 21.06           C  
ATOM   1685  OG  SER   229      12.191  34.481 -12.787  1.00 21.93           O  
ATOM   1686  N   GLU   230      14.582  37.105  -9.951  1.00 21.77           N  
ATOM   1687  CA  GLU   230      15.745  37.842  -9.443  1.00 23.44           C  
ATOM   1688  C   GLU   230      16.241  37.121  -8.208  1.00 24.30           C  
ATOM   1689  O   GLU   230      17.427  36.822  -8.038  1.00 23.11           O  
ATOM   1690  CB  GLU   230      15.327  39.232  -8.986  1.00 24.88           C  
ATOM   1691  CG  GLU   230      16.446  39.964  -8.211  1.00 25.43           C  
ATOM   1692  CD  GLU   230      17.011  41.126  -8.957  1.00 26.89           C  
ATOM   1693  OE1 GLU   230      16.267  41.704  -9.768  1.00 24.08           O  
ATOM   1694  OE2 GLU   230      18.173  41.500  -8.684  1.00 27.40           O  
ATOM   1695  N   LEU   231      15.273  36.842  -7.355  1.00 24.65           N  
ATOM   1696  CA  LEU   231      15.505  36.472  -5.987  1.00 27.37           C  
ATOM   1697  C   LEU   231      16.227  35.128  -5.920  1.00 29.19           C  
ATOM   1698  O   LEU   231      17.116  34.926  -5.074  1.00 30.79           O  
ATOM   1699  CB  LEU   231      14.133  36.437  -5.258  1.00 26.15           C  
ATOM   1700  CG  LEU   231      14.103  35.965  -3.808  1.00 25.48           C  
ATOM   1701  CD1 LEU   231      13.097  36.817  -3.039  1.00 24.11           C  
ATOM   1702  CD2 LEU   231      13.722  34.484  -3.709  1.00 24.46           C  
ATOM   1703  N   MET   232      15.892  34.259  -6.869  1.00 31.30           N  
ATOM   1704  CA  MET   232      16.273  32.841  -6.802  0.50 32.60           C  
ATOM   1706  C   MET   232      17.579  32.519  -7.520  1.00 32.66           C  
ATOM   1707  O   MET   232      18.270  31.545  -7.156  1.00 33.58           O  
ATOM   1708  CB  MET   232      15.130  31.960  -7.316  0.50 32.48           C  
ATOM   1710  CG  MET   232      13.833  32.197  -6.556  0.50 33.23           C  
ATOM   1712  SD  MET   232      12.288  31.294  -7.301  0.50 34.88          SE  
ATOM   1714  CE  MET   232      12.824  29.439  -6.973  0.50 35.68           C  
ATOM   1716  N   SER   233      17.902  33.327  -8.515  1.00 32.34           N  
ATOM   1717  CA  SER   233      19.173  33.283  -9.197  1.00 32.73           C  
ATOM   1718  C   SER   233      19.526  34.735  -9.260  1.00 32.27           C  
ATOM   1719  O   SER   233      18.661  35.516  -9.653  1.00 33.00           O  
ATOM   1720  CB  SER   233      19.010  32.787 -10.617  1.00 33.04           C  
ATOM   1721  OG  SER   233      18.096  33.619 -11.336  1.00 37.07           O  
ATOM   1722  N   VAL   234      20.759  35.092  -8.861  1.00 30.11           N  
ATOM   1723  CA  VAL   234      21.353  36.417  -9.039  1.00 29.06           C  
ATOM   1724  C   VAL   234      21.759  36.972  -7.668  1.00 27.42           C  
ATOM   1725  O   VAL   234      20.861  37.292  -6.847  1.00 27.92           O  
ATOM   1726  CB  VAL   234      20.401  37.472  -9.761  1.00 30.12           C  
ATOM   1727  CG1 VAL   234      21.032  38.881  -9.755  1.00 32.18           C  
ATOM   1728  CG2 VAL   234      20.084  37.050 -11.177  1.00 30.59           C  
ATOM   1729  N   THR   235      23.084  37.044  -7.414  1.00 24.54           N  
ATOM   1730  CA  THR   235      23.611  37.828  -6.274  1.00 21.55           C  
ATOM   1731  C   THR   235      24.970  38.463  -6.580  1.00 20.36           C  
ATOM   1732  O   THR   235      25.994  37.787  -6.534  1.00 20.67           O  
ATOM   1733  CB  THR   235      23.793  36.967  -4.996  1.00 20.99           C  
ATOM   1734  OG1 THR   235      22.701  36.060  -4.860  1.00 21.81           O  
ATOM   1735  CG2 THR   235      23.909  37.893  -3.732  1.00 19.10           C  
ATOM   1736  N   PRO   236      24.994  39.767  -6.880  1.00 18.67           N  
ATOM   1737  CA  PRO   236      26.263  40.458  -7.209  1.00 17.30           C  
ATOM   1738  C   PRO   236      27.175  40.544  -5.981  1.00 16.11           C  
ATOM   1739  O   PRO   236      26.660  40.543  -4.861  1.00 15.24           O  
ATOM   1740  CB  PRO   236      25.813  41.883  -7.586  1.00 18.40           C  
ATOM   1741  CG  PRO   236      24.320  41.835  -7.742  1.00 19.11           C  
ATOM   1742  CD  PRO   236      23.824  40.662  -6.942  1.00 18.91           C  
ATOM   1743  N   ASN   237      28.495  40.623  -6.184  1.00 15.37           N  
ATOM   1744  CA  ASN   237      29.410  40.915  -5.067  1.00 14.60           C  
ATOM   1745  C   ASN   237      29.053  42.256  -4.406  1.00 13.70           C  
ATOM   1746  O   ASN   237      28.875  43.267  -5.093  1.00 15.31           O  
ATOM   1747  CB  ASN   237      30.871  40.917  -5.503  1.00 14.73           C  
ATOM   1748  CG  ASN   237      31.377  39.526  -5.865  1.00 15.52           C  
ATOM   1749  OD1 ASN   237      31.642  39.260  -7.037  1.00 19.53           O  
ATOM   1750  ND2 ASN   237      31.449  38.610  -4.870  1.00 14.35           N  
ATOM   1751  N   THR   238      28.974  42.244  -3.083  1.00 12.97           N  
ATOM   1752  CA  THR   238      28.441  43.358  -2.231  1.00 12.00           C  
ATOM   1753  C   THR   238      27.022  43.852  -2.533  1.00 13.36           C  
ATOM   1754  O   THR   238      26.633  44.940  -2.108  1.00 13.65           O  
ATOM   1755  CB  THR   238      29.436  44.556  -2.091  1.00 12.82           C  
ATOM   1756  OG1 THR   238      29.545  45.243  -3.343  1.00 14.76           O  
ATOM   1757  CG2 THR   238      30.807  44.035  -1.598  1.00 13.59           C  
ATOM   1758  N   GLY   239      26.268  43.034  -3.271  1.00 13.24           N  
ATOM   1759  CA  GLY   239      24.830  43.263  -3.519  1.00 13.93           C  
ATOM   1760  C   GLY   239      24.107  43.245  -2.182  1.00 13.74           C  
ATOM   1761  O   GLY   239      24.339  42.340  -1.368  1.00 14.21           O  
ATOM   1762  N   MET   240      23.242  44.239  -1.966  1.00 12.78           N  
ATOM   1763  CA  MET   240      22.584  44.447  -0.685  1.00 13.58           C  
ATOM   1764  C   MET   240      21.069  44.208  -0.750  1.00 13.24           C  
ATOM   1765  O   MET   240      20.395  44.680  -1.660  1.00 13.69           O  
ATOM   1766  CB  MET   240      22.806  45.896  -0.220  1.00 15.11           C  
ATOM   1767  CG  MET   240      24.272  46.251  -0.086  1.00 15.12           C  
ATOM   1768  SD  MET   240      24.362  48.070   0.611  1.00 18.77          SE  
ATOM   1769  CE  MET   240      26.264  48.246   0.501  1.00 18.08           C  
ATOM   1770  N   SER   241      20.549  43.509   0.255  1.00 13.14           N  
ATOM   1771  CA  SER   241      19.119  43.255   0.356  0.70 12.52           C  
ATOM   1773  C   SER   241      18.692  43.676   1.746  1.00 13.29           C  
ATOM   1774  O   SER   241      19.403  43.434   2.713  1.00 14.20           O  
ATOM   1775  CB  SER   241      18.850  41.760   0.131  0.70 12.45           C  
ATOM   1777  OG  SER   241      19.292  41.387  -1.161  0.70 10.80           O  
ATOM   1779  N   LEU   242      17.529  44.328   1.846  1.00 12.23           N  
ATOM   1780  CA  LEU   242      16.979  44.770   3.117  1.00 12.90           C  
ATOM   1781  C   LEU   242      15.586  44.170   3.282  1.00 11.83           C  
ATOM   1782  O   LEU   242      14.755  44.272   2.345  1.00 12.05           O  
ATOM   1783  CB  LEU   242      16.875  46.318   3.160  1.00 13.04           C  
ATOM   1784  CG  LEU   242      16.191  46.884   4.429  1.00 15.99           C  
ATOM   1785  CD1 LEU   242      16.974  46.593   5.720  1.00 15.29           C  
ATOM   1786  CD2 LEU   242      16.016  48.428   4.269  1.00 14.21           C  
ATOM   1787  N   PHE   243      15.361  43.622   4.482  1.00 11.67           N  
ATOM   1788  CA  PHE   243      14.080  43.045   4.930  1.00 12.76           C  
ATOM   1789  C   PHE   243      13.642  43.680   6.256  1.00 12.46           C  
ATOM   1790  O   PHE   243      14.480  43.930   7.155  1.00 12.87           O  
ATOM   1791  CB  PHE   243      14.219  41.532   5.128  1.00 12.81           C  
ATOM   1792  CG  PHE   243      14.701  40.822   3.892  1.00 13.64           C  
ATOM   1793  CD1 PHE   243      13.810  40.355   2.948  1.00 14.82           C  
ATOM   1794  CD2 PHE   243      16.068  40.676   3.672  1.00 15.31           C  
ATOM   1795  CE1 PHE   243      14.283  39.710   1.748  1.00 14.92           C  
ATOM   1796  CE2 PHE   243      16.548  40.066   2.540  1.00 12.18           C  
ATOM   1797  CZ  PHE   243      15.672  39.588   1.565  1.00 10.84           C  
ATOM   1798  N   ILE   244      12.335  43.896   6.398  1.00 12.62           N  
ATOM   1799  CA  ILE   244      11.789  44.211   7.698  1.00 12.69           C  
ATOM   1800  C   ILE   244      11.060  42.959   8.227  1.00 11.90           C  
ATOM   1801  O   ILE   244      10.181  42.396   7.558  1.00 12.22           O  
ATOM   1802  CB  ILE   244      10.846  45.460   7.683  1.00 13.59           C  
ATOM   1803  CG1 ILE   244      11.553  46.710   7.095  1.00 16.20           C  
ATOM   1804  CG2 ILE   244      10.370  45.738   9.092  1.00 14.97           C  
ATOM   1805  CD1 ILE   244      12.795  47.147   7.862  1.00 19.67           C  
ATOM   1806  N   ILE   245      11.453  42.509   9.412  1.00 11.60           N  
ATOM   1807  CA  ILE   245      10.858  41.320  10.032  1.00 11.68           C  
ATOM   1808  C   ILE   245       9.879  41.784  11.105  1.00 13.67           C  
ATOM   1809  O   ILE   245      10.246  42.595  11.946  1.00 13.43           O  
ATOM   1810  CB  ILE   245      11.944  40.445  10.706  1.00 11.82           C  
ATOM   1811  CG1 ILE   245      13.184  40.245   9.781  1.00 12.57           C  
ATOM   1812  CG2 ILE   245      11.358  39.134  11.191  1.00 13.22           C  
ATOM   1813  CD1 ILE   245      12.849  39.659   8.365  1.00 14.11           C  
ATOM   1814  N   ASN   246       8.674  41.220  11.116  1.00 12.98           N  
ATOM   1815  CA  ASN   246       7.570  41.742  11.953  1.00 14.16           C  
ATOM   1816  C   ASN   246       6.988  40.612  12.804  1.00 14.34           C  
ATOM   1817  O   ASN   246       6.585  39.556  12.275  1.00 13.56           O  
ATOM   1818  CB  ASN   246       6.425  42.270  11.045  1.00 15.39           C  
ATOM   1819  CG  ASN   246       6.871  43.351  10.067  1.00 18.81           C  
ATOM   1820  OD1 ASN   246       7.381  43.092   8.938  1.00 23.58           O  
ATOM   1821  ND2 ASN   246       6.644  44.593  10.475  1.00 22.31           N  
ATOM   1822  N   PHE   247       6.923  40.822  14.127  1.00 15.67           N  
ATOM   1823  CA  PHE   247       6.282  39.853  14.997  1.00 16.23           C  
ATOM   1824  C   PHE   247       5.077  40.508  15.677  1.00 18.30           C  
ATOM   1825  O   PHE   247       5.220  41.540  16.320  1.00 17.11           O  
ATOM   1826  CB  PHE   247       7.234  39.383  16.116  1.00 17.45           C  
ATOM   1827  CG  PHE   247       8.305  38.430  15.667  1.00 16.77           C  
ATOM   1828  CD1 PHE   247       8.106  37.063  15.754  1.00 17.77           C  
ATOM   1829  CD2 PHE   247       9.519  38.909  15.190  1.00 19.72           C  
ATOM   1830  CE1 PHE   247       9.088  36.164  15.310  1.00 19.81           C  
ATOM   1831  CE2 PHE   247      10.509  38.024  14.758  1.00 17.22           C  
ATOM   1832  CZ  PHE   247      10.293  36.657  14.829  1.00 18.61           C  
ATOM   1833  N   GLU   248       3.923  39.876  15.551  1.00 19.35           N  
ATOM   1834  CA  GLU   248       2.781  40.197  16.416  1.00 22.23           C  
ATOM   1835  C   GLU   248       3.103  39.774  17.853  1.00 22.71           C  
ATOM   1836  O   GLU   248       4.013  38.979  18.080  1.00 20.96           O  
ATOM   1837  CB  GLU   248       1.532  39.491  15.889  1.00 22.61           C  
ATOM   1838  CG  GLU   248       0.932  40.248  14.695  1.00 25.01           C  
ATOM   1839  CD  GLU   248      -0.290  39.602  14.050  1.00 26.62           C  
ATOM   1840  OE1 GLU   248      -0.802  38.579  14.550  1.00 32.28           O  
ATOM   1841  OE2 GLU   248      -0.744  40.145  13.015  1.00 33.12           O  
ATOM   1842  N   GLU   249       2.374  40.335  18.822  1.00 24.15           N  
ATOM   1843  CA  GLU   249       2.566  39.933  20.207  1.00 26.26           C  
ATOM   1844  C   GLU   249       2.084  38.503  20.390  1.00 24.94           C  
ATOM   1845  O   GLU   249       1.216  38.006  19.641  1.00 24.12           O  
ATOM   1846  CB  GLU   249       1.843  40.888  21.148  1.00 25.98           C  
ATOM   1847  CG  GLU   249       0.531  40.375  21.742  1.00 31.22           C  
ATOM   1848  CD  GLU   249      -0.230  41.493  22.450  1.00 30.94           C  
ATOM   1849  OE1 GLU   249       0.432  42.430  22.991  1.00 38.11           O  
ATOM   1850  OE2 GLU   249      -1.481  41.457  22.429  1.00 37.68           O  
ATOM   1851  N   GLY   250       2.678  37.831  21.362  1.00 24.73           N  
ATOM   1852  CA  GLY   250       2.268  36.496  21.738  1.00 25.76           C  
ATOM   1853  C   GLY   250       3.414  35.552  21.992  1.00 25.75           C  
ATOM   1854  O   GLY   250       4.567  35.989  22.161  1.00 25.79           O  
ATOM   1855  N   ARG   251       3.088  34.256  22.015  1.00 26.24           N  
ATOM   1856  CA  ARG   251       4.046  33.166  22.217  1.00 27.25           C  
ATOM   1857  C   ARG   251       4.241  32.399  20.920  1.00 27.77           C  
ATOM   1858  O   ARG   251       3.263  32.141  20.216  1.00 28.46           O  
ATOM   1859  CB  ARG   251       3.515  32.186  23.283  1.00 27.24           C  
ATOM   1860  CG  ARG   251       3.140  32.856  24.591  1.00 28.49           C  
ATOM   1861  CD  ARG   251       2.561  31.859  25.640  1.00 28.57           C  
ATOM   1862  NE  ARG   251       1.780  32.587  26.639  1.00 33.40           N  
ATOM   1863  CZ  ARG   251       2.276  33.080  27.773  1.00 34.86           C  
ATOM   1864  NH1 ARG   251       3.558  32.901  28.084  1.00 34.71           N  
ATOM   1865  NH2 ARG   251       1.480  33.746  28.602  1.00 36.04           N  
ATOM   1866  N   GLU   252       5.493  32.042  20.616  1.00 27.82           N  
ATOM   1867  CA  GLU   252       5.857  31.247  19.428  1.00 28.91           C  
ATOM   1868  C   GLU   252       5.214  31.815  18.146  1.00 26.70           C  
ATOM   1869  O   GLU   252       4.576  31.089  17.373  1.00 27.41           O  
ATOM   1870  CB  GLU   252       5.455  29.774  19.617  1.00 28.85           C  
ATOM   1871  CG  GLU   252       6.465  28.782  19.055  1.00 32.65           C  
ATOM   1872  CD  GLU   252       6.321  27.363  19.621  1.00 32.84           C  
ATOM   1873  OE1 GLU   252       7.240  26.561  19.360  1.00 40.25           O  
ATOM   1874  OE2 GLU   252       5.302  27.029  20.290  1.00 38.53           O  
ATOM   1875  N   VAL   253       5.371  33.117  17.958  1.00 25.17           N  
ATOM   1876  CA  VAL   253       4.775  33.851  16.836  1.00 22.77           C  
ATOM   1877  C   VAL   253       5.595  33.691  15.556  1.00 21.79           C  
ATOM   1878  O   VAL   253       6.816  33.855  15.559  1.00 21.90           O  
ATOM   1879  CB  VAL   253       4.580  35.341  17.196  1.00 22.33           C  
ATOM   1880  CG1 VAL   253       4.074  36.171  15.993  1.00 21.72           C  
ATOM   1881  CG2 VAL   253       3.605  35.476  18.387  1.00 24.21           C  
ATOM   1882  N   LYS   254       4.895  33.354  14.475  1.00 20.12           N  
ATOM   1883  CA  LYS   254       5.478  33.286  13.146  1.00 18.03           C  
ATOM   1884  C   LYS   254       5.614  34.706  12.594  1.00 17.17           C  
ATOM   1885  O   LYS   254       4.621  35.404  12.471  1.00 16.18           O  
ATOM   1886  CB  LYS   254       4.570  32.497  12.207  1.00 19.08           C  
ATOM   1887  CG  LYS   254       5.238  32.176  10.891  1.00 19.33           C  
ATOM   1888  CD  LYS   254       4.260  31.439   9.948  1.00 26.85           C  
ATOM   1889  CE  LYS   254       4.926  31.017   8.656  1.00 30.92           C  
ATOM   1890  NZ  LYS   254       3.996  30.199   7.841  1.00 34.45           N  
ATOM   1891  N   PRO   255       6.841  35.118  12.235  1.00 15.86           N  
ATOM   1892  CA  PRO   255       6.987  36.492  11.743  1.00 14.73           C  
ATOM   1893  C   PRO   255       6.441  36.684  10.334  1.00 14.00           C  
ATOM   1894  O   PRO   255       6.259  35.704   9.594  1.00 15.12           O  
ATOM   1895  CB  PRO   255       8.517  36.704  11.706  1.00 14.51           C  
ATOM   1896  CG  PRO   255       9.068  35.329  11.521  1.00 15.15           C  
ATOM   1897  CD  PRO   255       8.117  34.382  12.249  1.00 16.49           C  
ATOM   1898  N   THR   256       6.163  37.928   9.982  1.00 13.78           N  
ATOM   1899  CA  THR   256       5.953  38.277   8.570  1.00 13.57           C  
ATOM   1900  C   THR   256       7.164  39.079   8.096  1.00 13.58           C  
ATOM   1901  O   THR   256       7.872  39.668   8.915  1.00 14.02           O  
ATOM   1902  CB  THR   256       4.658  39.061   8.380  1.00 13.94           C  
ATOM   1903  OG1 THR   256       4.633  40.216   9.244  1.00 15.02           O  
ATOM   1904  CG2 THR   256       3.466  38.145   8.671  1.00 14.83           C  
ATOM   1905  N   VAL   257       7.398  39.098   6.782  1.00 11.39           N  
ATOM   1906  CA  VAL   257       8.633  39.673   6.254  1.00 11.79           C  
ATOM   1907  C   VAL   257       8.275  40.582   5.067  1.00 12.49           C  
ATOM   1908  O   VAL   257       7.431  40.238   4.259  1.00 11.88           O  
ATOM   1909  CB  VAL   257       9.603  38.560   5.797  1.00 12.20           C  
ATOM   1910  CG1 VAL   257      10.891  39.173   5.158  1.00 12.84           C  
ATOM   1911  CG2 VAL   257       9.926  37.554   6.989  1.00 11.37           C  
ATOM   1912  N   GLN   258       8.886  41.761   5.028  1.00 12.80           N  
ATOM   1913  CA  GLN   258       8.757  42.676   3.898  1.00 14.83           C  
ATOM   1914  C   GLN   258      10.146  42.821   3.279  1.00 13.10           C  
ATOM   1915  O   GLN   258      11.081  43.235   3.951  1.00 13.61           O  
ATOM   1916  CB  GLN   258       8.279  44.066   4.374  1.00 15.18           C  
ATOM   1917  CG  GLN   258       6.887  44.059   4.975  1.00 18.60           C  
ATOM   1918  CD  GLN   258       6.563  45.334   5.754  1.00 21.61           C  
ATOM   1919  OE1 GLN   258       7.172  45.643   6.800  1.00 26.56           O  
ATOM   1920  NE2 GLN   258       5.584  46.086   5.239  1.00 28.76           N  
ATOM   1921  N   CYS   259      10.274  42.453   2.014  1.00 13.04           N  
ATOM   1922  CA  CYS   259      11.499  42.712   1.287  1.00 12.61           C  
ATOM   1923  C   CYS   259      11.459  44.148   0.753  1.00 13.03           C  
ATOM   1924  O   CYS   259      10.541  44.511  -0.009  1.00 14.63           O  
ATOM   1925  CB  CYS   259      11.669  41.726   0.144  1.00 13.09           C  
ATOM   1926  SG  CYS   259      13.167  42.105  -0.790  1.00 14.63           S  
ATOM   1927  N   ILE   260      12.415  44.952   1.191  1.00 13.62           N  
ATOM   1928  CA  ILE   260      12.519  46.388   0.817  1.00 14.08           C  
ATOM   1929  C   ILE   260      13.311  46.576  -0.486  1.00 15.41           C  
ATOM   1930  O   ILE   260      12.898  47.347  -1.378  1.00 15.09           O  
ATOM   1931  CB  ILE   260      13.128  47.246   1.960  1.00 14.59           C  
ATOM   1932  CG1 ILE   260      12.328  47.110   3.275  1.00 13.59           C  
ATOM   1933  CG2 ILE   260      13.302  48.705   1.519  1.00 15.12           C  
ATOM   1934  CD1 ILE   260      10.798  47.437   3.184  1.00 17.11           C  
ATOM   1935  N   CYS   261      14.436  45.867  -0.603  1.00 14.81           N  
ATOM   1936  CA  CYS   261      15.202  45.843  -1.858  1.00 15.96           C  
ATOM   1937  C   CYS   261      16.019  44.575  -1.893  1.00 16.00           C  
ATOM   1938  O   CYS   261      16.188  43.935  -0.853  1.00 16.30           O  
ATOM   1939  CB  CYS   261      16.111  47.071  -1.964  1.00 16.22           C  
ATOM   1940  SG  CYS   261      17.350  47.186  -0.680  1.00 20.19           S  
ATOM   1941  N   MET   262      16.475  44.188  -3.076  1.00 16.20           N  
ATOM   1942  CA  MET   262      17.340  43.008  -3.196  1.00 17.67           C  
ATOM   1943  C   MET   262      18.416  43.285  -4.214  1.00 17.67           C  
ATOM   1944  O   MET   262      18.147  43.915  -5.245  1.00 17.51           O  
ATOM   1945  CB  MET   262      16.526  41.772  -3.601  1.00 17.55           C  
ATOM   1946  CG  MET   262      17.351  40.476  -3.744  1.00 20.14           C  
ATOM   1947  SD  MET   262      16.188  38.954  -3.853  1.00 20.86          SE  
ATOM   1948  CE  MET   262      15.557  39.102  -2.039  1.00 21.38           C  
ATOM   1949  N   ASN   263      19.633  42.828  -3.916  1.00 16.44           N  
ATOM   1950  CA  ASN   263      20.752  42.967  -4.856  1.00 17.08           C  
ATOM   1951  C   ASN   263      21.022  44.425  -5.263  1.00 18.00           C  
ATOM   1952  O   ASN   263      21.442  44.694  -6.418  1.00 19.37           O  
ATOM   1953  CB  ASN   263      20.519  42.091  -6.092  1.00 16.01           C  
ATOM   1954  CG  ASN   263      20.470  40.618  -5.748  1.00 17.20           C  
ATOM   1955  OD1 ASN   263      21.136  40.190  -4.797  1.00 16.42           O  
ATOM   1956  ND2 ASN   263      19.749  39.824  -6.544  1.00 20.11           N  
ATOM   1957  N   LEU   264      20.781  45.343  -4.337  1.00 18.06           N  
ATOM   1958  CA  LEU   264      21.088  46.764  -4.563  1.00 20.40           C  
ATOM   1959  C   LEU   264      22.596  46.926  -4.814  1.00 21.29           C  
ATOM   1960  O   LEU   264      23.418  46.399  -4.050  1.00 20.30           O  
ATOM   1961  CB  LEU   264      20.687  47.612  -3.350  1.00 20.35           C  
ATOM   1962  CG  LEU   264      20.446  49.114  -3.581  1.00 23.12           C  
ATOM   1963  CD1 LEU   264      19.371  49.296  -4.670  1.00 24.12           C  
ATOM   1964  CD2 LEU   264      20.018  49.775  -2.298  1.00 21.83           C  
ATOM   1965  N   GLN   265      22.955  47.657  -5.874  1.00 22.67           N  
ATOM   1966  CA  GLN   265      24.380  47.952  -6.140  1.00 25.66           C  
ATOM   1967  C   GLN   265      24.668  49.436  -6.393  1.00 26.47           C  
ATOM   1968  O   GLN   265      25.604  49.743  -7.139  1.00 27.18           O  
ATOM   1969  CB  GLN   265      24.925  47.188  -7.351  1.00 25.38           C  
ATOM   1970  CG  GLN   265      24.243  45.906  -7.762  1.00 28.61           C  
ATOM   1971  CD  GLN   265      24.906  45.265  -8.962  1.00 28.26           C  
ATOM   1972  OE1 GLN   265      26.146  45.211  -9.065  1.00 33.40           O  
ATOM   1973  NE2 GLN   265      24.092  44.746  -9.872  1.00 33.70           N  
ATOM   1974  N   ASP   266      23.903  50.326  -5.753  1.00 28.13           N  
ATOM   1975  CA  ASP   266      24.028  51.794  -5.906  1.00 30.32           C  
ATOM   1976  C   ASP   266      25.391  52.326  -5.456  1.00 30.83           C  
ATOM   1977  O   ASP   266      25.838  53.402  -5.891  1.00 31.49           O  
ATOM   1978  CB  ASP   266      22.934  52.499  -5.094  1.00 30.71           C  
ATOM   1979  CG  ASP   266      21.547  52.313  -5.687  1.00 32.76           C  
ATOM   1980  OD1 ASP   266      21.434  51.819  -6.830  1.00 35.90           O  
ATOM   1981  OD2 ASP   266      20.569  52.687  -5.007  1.00 35.33           O  
ATOM   1982  N   HIS   267      26.040  51.590  -4.563  1.00 29.75           N  
ATOM   1983  CA  HIS   267      27.378  51.928  -4.124  1.00 29.59           C  
ATOM   1984  C   HIS   267      28.480  51.599  -5.154  1.00 30.49           C  
ATOM   1985  O   HIS   267      29.633  52.004  -4.962  1.00 31.58           O  
ATOM   1986  CB  HIS   267      27.657  51.216  -2.800  1.00 28.97           C  
ATOM   1987  CG  HIS   267      27.627  49.725  -2.912  1.00 24.06           C  
ATOM   1988  ND1 HIS   267      26.469  49.026  -3.188  1.00 22.05           N  
ATOM   1989  CD2 HIS   267      28.611  48.804  -2.805  1.00 21.74           C  
ATOM   1990  CE1 HIS   267      26.745  47.732  -3.246  1.00 20.69           C  
ATOM   1991  NE2 HIS   267      28.039  47.574  -3.021  1.00 19.76           N  
ATOM   1992  N   LEU   268      28.151  50.870  -6.222  1.00 31.07           N  
ATOM   1993  CA  LEU   268      29.165  50.394  -7.182  1.00 32.45           C  
ATOM   1994  C   LEU   268      29.296  51.186  -8.499  1.00 34.57           C  
ATOM   1995  O   LEU   268      30.254  50.978  -9.247  1.00 34.93           O  
ATOM   1996  CB  LEU   268      28.976  48.905  -7.512  1.00 31.83           C  
ATOM   1997  CG  LEU   268      29.246  47.899  -6.388  1.00 30.13           C  
ATOM   1998  CD1 LEU   268      29.144  46.464  -6.905  1.00 30.71           C  
ATOM   1999  CD2 LEU   268      30.618  48.155  -5.758  1.00 30.78           C  
ATOM   2000  N   ASN   269      28.346  52.062  -8.794  1.00 36.54           N  
ATOM   2001  CA  ASN   269      28.369  52.782 -10.078  1.00 38.57           C  
ATOM   2002  C   ASN   269      29.384  53.929 -10.094  1.00 39.07           C  
ATOM   2003  O   ASN   269      30.600  53.710  -9.978  1.00 39.36           O  
ATOM   2004  CB  ASN   269      26.960  53.264 -10.476  1.00 39.59           C  
ATOM   2005  CG  ASN   269      26.201  53.925  -9.316  1.00 41.98           C  
ATOM   2006  OD1 ASN   269      26.802  54.562  -8.435  1.00 44.75           O  
ATOM   2007  ND2 ASN   269      24.873  53.793  -9.327  1.00 44.56           N  
END
