
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  127 (  985),  selected  127 , name 1onl_A
# Molecule2: number of CA atoms   68 (  548),  selected   68 , name T0397_83_150.pdb
# PARAMETERS: 1onl_A.T0397_83_150.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     2_A      -       -           -
LGA    I     3_A      -       -           -
LGA    P     4_A      -       -           -
LGA    K     5_A      -       -           -
LGA    D     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    F     8_A      -       -           -
LGA    Y     9_A      -       -           -
LGA    T    10_A      -       -           -
LGA    K    11_A      -       -           -
LGA    T    12_A      -       -           -
LGA    H    13_A      -       -           -
LGA    E    14_A      -       -           -
LGA    W    15_A      -       -           -
LGA    A    16_A      -       -           -
LGA    L    17_A      -       -           -
LGA    P    18_A      -       -           -
LGA    E    19_A      -       -           -
LGA    G    20_A      -       -           -
LGA    D    21_A      -       -           -
LGA    T    22_A      L      83          1.321
LGA    V    23_A      I      84          0.910
LGA    L    24_A      S      85          0.666
LGA    V    25_A      V      86          0.883
LGA    G    26_A      P      87          1.870
LGA    I    27_A      A      88          5.771
LGA    T    28_A      -       -           -
LGA    D    29_A      -       -           -
LGA    Y    30_A      -       -           -
LGA    A    31_A      -       -           -
LGA    Q    32_A      E      89           #
LGA    D    33_A      -       -           -
LGA    A    34_A      -       -           -
LGA    L    35_A      -       -           -
LGA    G    36_A      -       -           -
LGA    D    37_A      -       -           -
LGA    V    38_A      G      90          3.071
LGA    V    39_A      Y      91          3.019
LGA    Y    40_A      K      92          1.922
LGA    V    41_A      V      93          1.283
LGA    E    42_A      Y      94          1.398
LGA    L    43_A      P      95          1.634
LGA    P    44_A      I      96          1.766
LGA    E    45_A      M      97          3.527
LGA    V    46_A      D      98          3.075
LGA    -       -      F      99           -
LGA    G    47_A      G     100          1.423
LGA    R    48_A      F     101          1.624
LGA    V    49_A      R     102          0.926
LGA    V    50_A      V     103          0.654
LGA    E    51_A      L     104          0.460
LGA    K    52_A      K     105          0.512
LGA    G    53_A      G     106          0.753
LGA    E    54_A      Y     107          1.196
LGA    A    55_A      R     108          1.301
LGA    V    56_A      L     109          1.799
LGA    A    57_A      A     110          1.036
LGA    V    58_A      T     111          1.130
LGA    V    59_A      L     112          1.624
LGA    E    60_A      E     113          1.710
LGA    S    61_A      S     114          1.816
LGA    V    62_A      K     115          1.267
LGA    K    63_A      K     116          3.741
LGA    -       -      G     117           -
LGA    T    64_A      D     118          1.088
LGA    A    65_A      L     119          1.539
LGA    S    66_A      R     120          1.194
LGA    D    67_A      Y     121          1.310
LGA    I    68_A      V     122          0.776
LGA    Y    69_A      N     123          0.478
LGA    A    70_A      S     124          0.287
LGA    P    71_A      P     125          0.097
LGA    V    72_A      V     126          0.372
LGA    A    73_A      S     127          0.639
LGA    G    74_A      G     128          1.012
LGA    E    75_A      T     129          1.250
LGA    I    76_A      V     130          1.115
LGA    V    77_A      I     131          1.014
LGA    E    78_A      F     132          1.204
LGA    V    79_A      M     133          1.038
LGA    N    80_A      N     134          1.978
LGA    L    81_A      E     135          2.499
LGA    A    82_A      I     136          4.162
LGA    L    83_A      P     137           #
LGA    E    84_A      S     138           -
LGA    K    85_A      E     139           #
LGA    T    86_A      R     140          2.908
LGA    P    87_A      A     141          1.294
LGA    E    88_A      N     142           #
LGA    L    89_A      -       -           -
LGA    V    90_A      -       -           -
LGA    N    91_A      -       -           -
LGA    Q    92_A      -       -           -
LGA    D    93_A      -       -           -
LGA    P    94_A      -       -           -
LGA    Y    95_A      -       -           -
LGA    G    96_A      -       -           -
LGA    E    97_A      -       -           -
LGA    G    98_A      -       -           -
LGA    W    99_A      Y     143          5.248
LGA    I   100_A      V     144          2.042
LGA    F   101_A      F     145          0.990
LGA    R   102_A      Y     146          0.867
LGA    L   103_A      M     147          1.285
LGA    K   104_A      L     148          1.235
LGA    P   105_A      E     149          0.763
LGA    R   106_A      E     150          1.396
LGA    D   107_A      -       -           -
LGA    M   108_A      -       -           -
LGA    G   109_A      -       -           -
LGA    D   110_A      -       -           -
LGA    L   111_A      -       -           -
LGA    D   112_A      -       -           -
LGA    E   113_A      -       -           -
LGA    L   114_A      -       -           -
LGA    L   115_A      -       -           -
LGA    D   116_A      -       -           -
LGA    A   117_A      -       -           -
LGA    G   118_A      -       -           -
LGA    G   119_A      -       -           -
LGA    Y   120_A      -       -           -
LGA    Q   121_A      -       -           -
LGA    E   122_A      -       -           -
LGA    V   123_A      -       -           -
LGA    L   124_A      -       -           -
LGA    E   125_A      -       -           -
LGA    S   126_A      -       -           -
LGA    E   127_A      -       -           -
LGA    A   128_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  127   68    5.0     61    1.93    24.59     75.962     3.009

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.187192 * X  +  -0.823686 * Y  +  -0.535257 * Z  + 124.167244
  Y_new =  -0.470142 * X  +   0.403308 * Y  +  -0.785054 * Z  +  95.544304
  Z_new =   0.862512 * X  +   0.398602 * Y  +  -0.311754 * Z  +  52.150013 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.234538   -0.907055  [ DEG:   128.0296    -51.9704 ]
  Theta =  -1.040212   -2.101381  [ DEG:   -59.5998   -120.4002 ]
  Phi   =  -1.191877    1.949715  [ DEG:   -68.2895    111.7105 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1onl_A                                        
REMARK     2: T0397_83_150.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1onl_A.T0397_83_150.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  127   68   5.0   61   1.93   24.59  75.962
REMARK  ---------------------------------------------------------- 
MOLECULE 1onl_A
HEADER    OXIDOREDUCTASE                          28-FEB-03   1ONL              
TITLE     CRYSTAL STRUCTURE OF THERMUS THERMOPHILUS HB8 H-PROTEIN OF            
TITLE    2 THE GLYCINE CLEAVAGE SYSTEM                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLYCINE CLEAVAGE SYSTEM H PROTEIN;                         
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: GCVH;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET11A-GCVH                               
KEYWDS    HYBRID BARREL-SANDWICH STRUCTURE, STRUCTURAL GENOMICS,                
KEYWDS   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.NAKAI,J.ISHIJIMA,R.MASUI,S.KURAMITSU,N.KAMIYA,RIKEN                 
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   26-AUG-03 1ONL    0                                                
JRNL        AUTH   T.NAKAI,J.ISHIJIMA,R.MASUI,S.KURAMITSU,N.KAMIYA              
JRNL        TITL   STRUCTURE OF THERMUS THERMOPHILUS HB8 H-PROTEIN OF           
JRNL        TITL 2 THE GLYCINE-CLEAVAGE SYSTEM, RESOLVED BY A                   
JRNL        TITL 3 SIX-DIMENSIONAL MOLECULAR-REPLACEMENT METHOD.                
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  59  1610 2003              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1ONL A    1   128  UNP    P83697   P83697_THETH     1    128             
DBREF  1ONL B    1   128  UNP    P83697   P83697_THETH     1    128             
DBREF  1ONL C    1   128  UNP    P83697   P83697_THETH     1    128             
SEQRES   1 A  128  MET ASP ILE PRO LYS ASP ARG PHE TYR THR LYS THR HIS          
SEQRES   2 A  128  GLU TRP ALA LEU PRO GLU GLY ASP THR VAL LEU VAL GLY          
SEQRES   3 A  128  ILE THR ASP TYR ALA GLN ASP ALA LEU GLY ASP VAL VAL          
SEQRES   4 A  128  TYR VAL GLU LEU PRO GLU VAL GLY ARG VAL VAL GLU LYS          
SEQRES   5 A  128  GLY GLU ALA VAL ALA VAL VAL GLU SER VAL LYS THR ALA          
SEQRES   6 A  128  SER ASP ILE TYR ALA PRO VAL ALA GLY GLU ILE VAL GLU          
SEQRES   7 A  128  VAL ASN LEU ALA LEU GLU LYS THR PRO GLU LEU VAL ASN          
SEQRES   8 A  128  GLN ASP PRO TYR GLY GLU GLY TRP ILE PHE ARG LEU LYS          
SEQRES   9 A  128  PRO ARG ASP MET GLY ASP LEU ASP GLU LEU LEU ASP ALA          
SEQRES  10 A  128  GLY GLY TYR GLN GLU VAL LEU GLU SER GLU ALA                  
SEQRES   1 B  128  MET ASP ILE PRO LYS ASP ARG PHE TYR THR LYS THR HIS          
SEQRES   2 B  128  GLU TRP ALA LEU PRO GLU GLY ASP THR VAL LEU VAL GLY          
SEQRES   3 B  128  ILE THR ASP TYR ALA GLN ASP ALA LEU GLY ASP VAL VAL          
SEQRES   4 B  128  TYR VAL GLU LEU PRO GLU VAL GLY ARG VAL VAL GLU LYS          
SEQRES   5 B  128  GLY GLU ALA VAL ALA VAL VAL GLU SER VAL LYS THR ALA          
SEQRES   6 B  128  SER ASP ILE TYR ALA PRO VAL ALA GLY GLU ILE VAL GLU          
SEQRES   7 B  128  VAL ASN LEU ALA LEU GLU LYS THR PRO GLU LEU VAL ASN          
SEQRES   8 B  128  GLN ASP PRO TYR GLY GLU GLY TRP ILE PHE ARG LEU LYS          
SEQRES   9 B  128  PRO ARG ASP MET GLY ASP LEU ASP GLU LEU LEU ASP ALA          
SEQRES  10 B  128  GLY GLY TYR GLN GLU VAL LEU GLU SER GLU ALA                  
SEQRES   1 C  128  MET ASP ILE PRO LYS ASP ARG PHE TYR THR LYS THR HIS          
SEQRES   2 C  128  GLU TRP ALA LEU PRO GLU GLY ASP THR VAL LEU VAL GLY          
SEQRES   3 C  128  ILE THR ASP TYR ALA GLN ASP ALA LEU GLY ASP VAL VAL          
SEQRES   4 C  128  TYR VAL GLU LEU PRO GLU VAL GLY ARG VAL VAL GLU LYS          
SEQRES   5 C  128  GLY GLU ALA VAL ALA VAL VAL GLU SER VAL LYS THR ALA          
SEQRES   6 C  128  SER ASP ILE TYR ALA PRO VAL ALA GLY GLU ILE VAL GLU          
SEQRES   7 C  128  VAL ASN LEU ALA LEU GLU LYS THR PRO GLU LEU VAL ASN          
SEQRES   8 C  128  GLN ASP PRO TYR GLY GLU GLY TRP ILE PHE ARG LEU LYS          
SEQRES   9 C  128  PRO ARG ASP MET GLY ASP LEU ASP GLU LEU LEU ASP ALA          
SEQRES  10 C  128  GLY GLY TYR GLN GLU VAL LEU GLU SER GLU ALA                  
FORMUL   4  HOH   *115(H2 O)                                                    
CRYST1   55.775   55.775  191.190  90.00  90.00 120.00 P 65         18          
ATOM      1  N   ASP A   2      55.006  22.446  40.091  1.00 28.03           N  
ATOM      2  CA  ASP A   2      54.595  22.352  41.520  1.00 27.18           C  
ATOM      3  C   ASP A   2      53.074  22.259  41.639  1.00 25.95           C  
ATOM      4  O   ASP A   2      52.364  23.258  41.524  1.00 24.90           O  
ATOM      5  CB  ASP A   2      55.116  23.563  42.297  1.00 28.52           C  
ATOM      6  CG  ASP A   2      54.729  23.521  43.762  1.00 30.77           C  
ATOM      7  OD1 ASP A   2      54.299  22.444  44.231  1.00 34.48           O  
ATOM      8  OD2 ASP A   2      54.864  24.551  44.454  1.00 31.37           O  
ATOM      9  N   ILE A   3      52.591  21.040  41.880  1.00 25.06           N  
ATOM     10  CA  ILE A   3      51.160  20.766  41.998  1.00 21.41           C  
ATOM     11  C   ILE A   3      50.863  19.808  43.143  1.00 20.82           C  
ATOM     12  O   ILE A   3      50.687  18.610  42.922  1.00 18.70           O  
ATOM     13  CB  ILE A   3      50.625  20.121  40.713  1.00 17.70           C  
ATOM     14  CG1 ILE A   3      51.013  20.970  39.505  1.00 16.64           C  
ATOM     15  CG2 ILE A   3      49.121  19.959  40.805  1.00 15.07           C  
ATOM     16  CD1 ILE A   3      50.798  20.280  38.187  1.00 14.49           C  
ATOM     17  N   PRO A   4      50.793  20.319  44.380  1.00 21.13           N  
ATOM     18  CA  PRO A   4      50.508  19.444  45.529  1.00 21.41           C  
ATOM     19  C   PRO A   4      49.220  18.641  45.303  1.00 21.26           C  
ATOM     20  O   PRO A   4      48.255  19.157  44.721  1.00 19.06           O  
ATOM     21  CB  PRO A   4      50.404  20.427  46.696  1.00 20.29           C  
ATOM     22  CG  PRO A   4      49.901  21.682  46.034  1.00 21.93           C  
ATOM     23  CD  PRO A   4      50.734  21.737  44.767  1.00 21.07           C  
ATOM     24  N   LYS A   5      49.211  17.387  45.757  1.00 19.95           N  
ATOM     25  CA  LYS A   5      48.048  16.511  45.574  1.00 19.23           C  
ATOM     26  C   LYS A   5      47.122  16.462  46.784  1.00 18.92           C  
ATOM     27  O   LYS A   5      46.426  15.471  47.010  1.00 19.32           O  
ATOM     28  CB  LYS A   5      48.508  15.090  45.237  1.00 16.73           C  
ATOM     29  CG  LYS A   5      49.483  14.992  44.069  1.00 17.60           C  
ATOM     30  CD  LYS A   5      49.900  13.541  43.853  1.00 20.51           C  
ATOM     31  CE  LYS A   5      51.160  13.404  42.992  1.00 20.73           C  
ATOM     32  NZ  LYS A   5      50.938  13.739  41.567  1.00 22.84           N  
ATOM     33  N   ASP A   6      47.108  17.536  47.563  1.00 20.70           N  
ATOM     34  CA  ASP A   6      46.269  17.598  48.753  1.00 21.83           C  
ATOM     35  C   ASP A   6      45.056  18.486  48.543  1.00 22.39           C  
ATOM     36  O   ASP A   6      44.397  18.874  49.498  1.00 24.03           O  
ATOM     37  CB  ASP A   6      47.089  18.103  49.947  1.00 21.48           C  
ATOM     38  CG  ASP A   6      47.881  19.358  49.625  1.00 23.57           C  
ATOM     39  OD1 ASP A   6      47.822  19.817  48.467  1.00 24.57           O  
ATOM     40  OD2 ASP A   6      48.568  19.888  50.526  1.00 24.35           O  
ATOM     41  N   ARG A   7      44.746  18.787  47.288  1.00 23.96           N  
ATOM     42  CA  ARG A   7      43.615  19.655  46.990  1.00 24.66           C  
ATOM     43  C   ARG A   7      43.053  19.480  45.581  1.00 24.11           C  
ATOM     44  O   ARG A   7      43.671  18.847  44.726  1.00 23.53           O  
ATOM     45  CB  ARG A   7      44.042  21.106  47.164  1.00 25.29           C  
ATOM     46  CG  ARG A   7      45.236  21.466  46.297  1.00 26.93           C  
ATOM     47  CD  ARG A   7      46.414  21.889  47.150  1.00 29.00           C  
ATOM     48  NE  ARG A   7      46.236  23.235  47.675  1.00 29.88           N  
ATOM     49  CZ  ARG A   7      46.960  23.764  48.654  1.00 29.11           C  
ATOM     50  NH1 ARG A   7      47.922  23.060  49.235  1.00 25.45           N  
ATOM     51  NH2 ARG A   7      46.725  25.012  49.042  1.00 30.37           N  
ATOM     52  N   PHE A   8      41.872  20.050  45.359  1.00 23.18           N  
ATOM     53  CA  PHE A   8      41.223  20.011  44.059  1.00 23.41           C  
ATOM     54  C   PHE A   8      41.769  21.156  43.221  1.00 23.92           C  
ATOM     55  O   PHE A   8      42.307  22.122  43.760  1.00 23.51           O  
ATOM     56  CB  PHE A   8      39.713  20.184  44.192  1.00 21.88           C  
ATOM     57  CG  PHE A   8      39.025  19.008  44.790  1.00 20.99           C  
ATOM     58  CD1 PHE A   8      38.749  18.965  46.150  1.00 21.42           C  
ATOM     59  CD2 PHE A   8      38.656  17.932  43.992  1.00 19.80           C  
ATOM     60  CE1 PHE A   8      38.108  17.859  46.716  1.00 20.92           C  
ATOM     61  CE2 PHE A   8      38.015  16.823  44.548  1.00 21.10           C  
ATOM     62  CZ  PHE A   8      37.740  16.789  45.911  1.00 20.77           C  
ATOM     63  N   TYR A   9      41.616  21.051  41.905  1.00 23.96           N  
ATOM     64  CA  TYR A   9      42.099  22.088  41.002  1.00 23.80           C  
ATOM     65  C   TYR A   9      41.048  22.520  39.998  1.00 25.26           C  
ATOM     66  O   TYR A   9      40.052  21.828  39.768  1.00 25.33           O  
ATOM     67  CB  TYR A   9      43.355  21.614  40.274  1.00 21.16           C  
ATOM     68  CG  TYR A   9      44.560  21.558  41.175  1.00 20.75           C  
ATOM     69  CD1 TYR A   9      45.438  22.640  41.267  1.00 21.10           C  
ATOM     70  CD2 TYR A   9      44.815  20.430  41.955  1.00 18.24           C  
ATOM     71  CE1 TYR A   9      46.542  22.594  42.115  1.00 22.40           C  
ATOM     72  CE2 TYR A   9      45.904  20.374  42.799  1.00 19.08           C  
ATOM     73  CZ  TYR A   9      46.769  21.453  42.877  1.00 20.91           C  
ATOM     74  OH  TYR A   9      47.870  21.376  43.701  1.00 22.57           O  
ATOM     75  N   THR A  10      41.298  23.668  39.387  1.00 26.53           N  
ATOM     76  CA  THR A  10      40.377  24.245  38.432  1.00 27.69           C  
ATOM     77  C   THR A  10      41.074  24.546  37.096  1.00 27.36           C  
ATOM     78  O   THR A  10      42.275  24.827  37.062  1.00 25.37           O  
ATOM     79  CB  THR A  10      39.801  25.529  39.049  1.00 28.71           C  
ATOM     80  OG1 THR A  10      38.401  25.616  38.778  1.00 33.53           O  
ATOM     81  CG2 THR A  10      40.510  26.736  38.505  1.00 29.93           C  
ATOM     82  N   LYS A  11      40.327  24.477  35.996  1.00 27.47           N  
ATOM     83  CA  LYS A  11      40.910  24.764  34.688  1.00 29.02           C  
ATOM     84  C   LYS A  11      41.328  26.229  34.645  1.00 28.98           C  
ATOM     85  O   LYS A  11      42.161  26.628  33.825  1.00 29.65           O  
ATOM     86  CB  LYS A  11      39.916  24.483  33.558  1.00 32.72           C  
ATOM     87  CG  LYS A  11      39.553  23.012  33.390  1.00 37.69           C  
ATOM     88  CD  LYS A  11      38.751  22.753  32.114  1.00 41.59           C  
ATOM     89  CE  LYS A  11      37.356  23.379  32.154  1.00 43.92           C  
ATOM     90  NZ  LYS A  11      37.377  24.872  32.207  1.00 44.72           N  
ATOM     91  N   THR A  12      40.742  27.029  35.527  1.00 26.83           N  
ATOM     92  CA  THR A  12      41.076  28.444  35.601  1.00 25.86           C  
ATOM     93  C   THR A  12      42.250  28.656  36.566  1.00 24.92           C  
ATOM     94  O   THR A  12      42.410  29.715  37.159  1.00 26.06           O  
ATOM     95  CB  THR A  12      39.841  29.298  36.035  1.00 26.33           C  
ATOM     96  OG1 THR A  12      39.181  28.684  37.149  1.00 24.51           O  
ATOM     97  CG2 THR A  12      38.854  29.432  34.883  1.00 22.63           C  
ATOM     98  N   HIS A  13      43.073  27.626  36.707  1.00 24.75           N  
ATOM     99  CA  HIS A  13      44.255  27.676  37.562  1.00 24.58           C  
ATOM    100  C   HIS A  13      43.995  28.176  38.971  1.00 24.28           C  
ATOM    101  O   HIS A  13      44.574  29.175  39.408  1.00 23.74           O  
ATOM    102  CB  HIS A  13      45.343  28.533  36.911  1.00 24.97           C  
ATOM    103  CG  HIS A  13      45.558  28.229  35.465  1.00 24.86           C  
ATOM    104  ND1 HIS A  13      44.796  28.795  34.467  1.00 26.25           N  
ATOM    105  CD2 HIS A  13      46.417  27.386  34.847  1.00 26.81           C  
ATOM    106  CE1 HIS A  13      45.178  28.316  33.296  1.00 26.33           C  
ATOM    107  NE2 HIS A  13      46.161  27.459  33.499  1.00 27.08           N  
ATOM    108  N   GLU A  14      43.122  27.458  39.671  1.00 23.49           N  
ATOM    109  CA  GLU A  14      42.758  27.752  41.047  1.00 22.39           C  
ATOM    110  C   GLU A  14      42.731  26.432  41.801  1.00 21.17           C  
ATOM    111  O   GLU A  14      42.674  25.361  41.196  1.00 21.28           O  
ATOM    112  CB  GLU A  14      41.375  28.401  41.121  1.00 23.44           C  
ATOM    113  CG  GLU A  14      41.341  29.863  40.734  1.00 26.90           C  
ATOM    114  CD  GLU A  14      39.930  30.411  40.695  1.00 28.34           C  
ATOM    115  OE1 GLU A  14      39.127  30.029  41.574  1.00 27.88           O  
ATOM    116  OE2 GLU A  14      39.627  31.225  39.791  1.00 28.84           O  
ATOM    117  N   TRP A  15      42.759  26.510  43.122  1.00 20.58           N  
ATOM    118  CA  TRP A  15      42.744  25.315  43.944  1.00 20.24           C  
ATOM    119  C   TRP A  15      41.763  25.445  45.091  1.00 21.11           C  
ATOM    120  O   TRP A  15      41.459  26.555  45.537  1.00 20.94           O  
ATOM    121  CB  TRP A  15      44.145  25.025  44.502  1.00 18.05           C  
ATOM    122  CG  TRP A  15      44.826  26.182  45.191  1.00 15.00           C  
ATOM    123  CD1 TRP A  15      45.760  27.012  44.658  1.00 16.67           C  
ATOM    124  CD2 TRP A  15      44.652  26.602  46.554  1.00 16.53           C  
ATOM    125  NE1 TRP A  15      46.190  27.923  45.601  1.00 15.10           N  
ATOM    126  CE2 TRP A  15      45.522  27.692  46.772  1.00 15.61           C  
ATOM    127  CE3 TRP A  15      43.844  26.165  47.609  1.00 16.32           C  
ATOM    128  CZ2 TRP A  15      45.606  28.348  48.000  1.00 16.34           C  
ATOM    129  CZ3 TRP A  15      43.925  26.817  48.828  1.00 16.01           C  
ATOM    130  CH2 TRP A  15      44.801  27.896  49.014  1.00 17.25           C  
ATOM    131  N   ALA A  16      41.271  24.303  45.564  1.00 21.84           N  
ATOM    132  CA  ALA A  16      40.324  24.267  46.677  1.00 22.97           C  
ATOM    133  C   ALA A  16      40.800  23.232  47.686  1.00 22.42           C  
ATOM    134  O   ALA A  16      40.787  22.032  47.422  1.00 22.35           O  
ATOM    135  CB  ALA A  16      38.907  23.921  46.172  1.00 21.81           C  
ATOM    136  N   LEU A  17      41.231  23.715  48.841  1.00 23.54           N  
ATOM    137  CA  LEU A  17      41.738  22.863  49.903  1.00 23.41           C  
ATOM    138  C   LEU A  17      40.612  22.423  50.843  1.00 23.63           C  
ATOM    139  O   LEU A  17      40.135  23.217  51.662  1.00 24.08           O  
ATOM    140  CB  LEU A  17      42.791  23.636  50.702  1.00 23.92           C  
ATOM    141  CG  LEU A  17      44.043  22.901  51.181  1.00 26.36           C  
ATOM    142  CD1 LEU A  17      44.706  23.739  52.266  1.00 23.26           C  
ATOM    143  CD2 LEU A  17      43.692  21.518  51.713  1.00 25.61           C  
ATOM    144  N   PRO A  18      40.161  21.161  50.732  1.00 22.25           N  
ATOM    145  CA  PRO A  18      39.086  20.706  51.618  1.00 22.18           C  
ATOM    146  C   PRO A  18      39.511  20.707  53.089  1.00 22.28           C  
ATOM    147  O   PRO A  18      40.619  20.294  53.433  1.00 20.98           O  
ATOM    148  CB  PRO A  18      38.782  19.306  51.095  1.00 20.80           C  
ATOM    149  CG  PRO A  18      39.068  19.429  49.649  1.00 19.80           C  
ATOM    150  CD  PRO A  18      40.377  20.185  49.652  1.00 22.02           C  
ATOM    151  N   GLU A  19      38.618  21.198  53.937  1.00 23.04           N  
ATOM    152  CA  GLU A  19      38.844  21.275  55.374  1.00 24.27           C  
ATOM    153  C   GLU A  19      37.482  21.240  56.061  1.00 25.84           C  
ATOM    154  O   GLU A  19      36.858  22.280  56.288  1.00 25.62           O  
ATOM    155  CB  GLU A  19      39.565  22.574  55.727  1.00 23.02           C  
ATOM    156  CG  GLU A  19      41.070  22.515  55.599  1.00 23.07           C  
ATOM    157  CD  GLU A  19      41.722  23.832  55.956  1.00 26.43           C  
ATOM    158  OE1 GLU A  19      41.167  24.568  56.800  1.00 28.64           O  
ATOM    159  OE2 GLU A  19      42.798  24.137  55.408  1.00 29.05           O  
ATOM    160  N   GLY A  20      37.019  20.040  56.391  1.00 26.49           N  
ATOM    161  CA  GLY A  20      35.719  19.928  57.015  1.00 28.40           C  
ATOM    162  C   GLY A  20      34.693  20.226  55.944  1.00 29.80           C  
ATOM    163  O   GLY A  20      34.873  19.827  54.798  1.00 31.22           O  
ATOM    164  N   ASP A  21      33.627  20.935  56.289  1.00 31.98           N  
ATOM    165  CA  ASP A  21      32.602  21.241  55.300  1.00 32.93           C  
ATOM    166  C   ASP A  21      32.920  22.484  54.478  1.00 32.06           C  
ATOM    167  O   ASP A  21      32.020  23.102  53.904  1.00 31.55           O  
ATOM    168  CB  ASP A  21      31.222  21.371  55.976  1.00 35.91           C  
ATOM    169  CG  ASP A  21      31.254  22.207  57.256  1.00 40.59           C  
ATOM    170  OD1 ASP A  21      31.571  23.419  57.193  1.00 42.74           O  
ATOM    171  OD2 ASP A  21      30.951  21.645  58.335  1.00 42.02           O  
ATOM    172  N   THR A  22      34.200  22.846  54.414  1.00 30.89           N  
ATOM    173  CA  THR A  22      34.626  24.019  53.641  1.00 30.02           C  
ATOM    174  C   THR A  22      35.867  23.734  52.783  1.00 30.21           C  
ATOM    175  O   THR A  22      36.415  22.628  52.795  1.00 31.51           O  
ATOM    176  CB  THR A  22      34.952  25.244  54.564  1.00 27.10           C  
ATOM    177  OG1 THR A  22      36.142  24.982  55.310  1.00 27.14           O  
ATOM    178  CG2 THR A  22      33.823  25.514  55.541  1.00 23.82           C  
ATOM    179  N   VAL A  23      36.302  24.739  52.032  1.00 29.07           N  
ATOM    180  CA  VAL A  23      37.488  24.612  51.194  1.00 28.06           C  
ATOM    181  C   VAL A  23      38.222  25.937  51.119  1.00 26.67           C  
ATOM    182  O   VAL A  23      37.592  26.987  50.955  1.00 25.66           O  
ATOM    183  CB  VAL A  23      37.142  24.208  49.741  1.00 28.50           C  
ATOM    184  CG1 VAL A  23      36.584  22.797  49.710  1.00 29.20           C  
ATOM    185  CG2 VAL A  23      36.150  25.200  49.154  1.00 26.92           C  
ATOM    186  N   LEU A  24      39.544  25.895  51.263  1.00 22.89           N  
ATOM    187  CA  LEU A  24      40.329  27.110  51.144  1.00 20.73           C  
ATOM    188  C   LEU A  24      40.497  27.287  49.643  1.00 20.16           C  
ATOM    189  O   LEU A  24      40.505  26.306  48.900  1.00 15.78           O  
ATOM    190  CB  LEU A  24      41.700  26.973  51.814  1.00 20.73           C  
ATOM    191  CG  LEU A  24      41.800  27.172  53.331  1.00 19.42           C  
ATOM    192  CD1 LEU A  24      43.259  27.206  53.715  1.00 17.30           C  
ATOM    193  CD2 LEU A  24      41.121  28.478  53.757  1.00 16.57           C  
ATOM    194  N   VAL A  25      40.613  28.536  49.199  1.00 20.79           N  
ATOM    195  CA  VAL A  25      40.760  28.825  47.775  1.00 20.69           C  
ATOM    196  C   VAL A  25      41.921  29.767  47.480  1.00 19.99           C  
ATOM    197  O   VAL A  25      42.130  30.756  48.176  1.00 20.88           O  
ATOM    198  CB  VAL A  25      39.449  29.430  47.190  1.00 20.03           C  
ATOM    199  CG1 VAL A  25      39.660  29.850  45.741  1.00 20.03           C  
ATOM    200  CG2 VAL A  25      38.332  28.412  47.260  1.00 19.37           C  
ATOM    201  N   GLY A  26      42.680  29.444  46.440  1.00 20.36           N  
ATOM    202  CA  GLY A  26      43.804  30.279  46.058  1.00 21.33           C  
ATOM    203  C   GLY A  26      44.214  29.968  44.634  1.00 21.45           C  
ATOM    204  O   GLY A  26      43.598  29.124  43.979  1.00 20.80           O  
ATOM    205  N   ILE A  27      45.246  30.642  44.140  1.00 22.16           N  
ATOM    206  CA  ILE A  27      45.697  30.371  42.780  1.00 22.21           C  
ATOM    207  C   ILE A  27      46.868  29.383  42.806  1.00 22.01           C  
ATOM    208  O   ILE A  27      47.552  29.237  43.824  1.00 20.50           O  
ATOM    209  CB  ILE A  27      46.107  31.670  42.049  1.00 22.62           C  
ATOM    210  CG1 ILE A  27      47.352  32.279  42.693  1.00 23.63           C  
ATOM    211  CG2 ILE A  27      44.951  32.666  42.091  1.00 23.06           C  
ATOM    212  CD1 ILE A  27      47.835  33.548  41.993  1.00 23.61           C  
ATOM    213  N   THR A  28      47.075  28.693  41.693  1.00 21.29           N  
ATOM    214  CA  THR A  28      48.149  27.720  41.583  1.00 20.19           C  
ATOM    215  C   THR A  28      49.525  28.393  41.445  1.00 22.06           C  
ATOM    216  O   THR A  28      49.615  29.600  41.208  1.00 22.26           O  
ATOM    217  CB  THR A  28      47.890  26.762  40.388  1.00 19.24           C  
ATOM    218  OG1 THR A  28      47.869  27.496  39.158  1.00 13.21           O  
ATOM    219  CG2 THR A  28      46.539  26.062  40.561  1.00 19.30           C  
ATOM    220  N   ASP A  29      50.589  27.615  41.635  1.00 22.66           N  
ATOM    221  CA  ASP A  29      51.953  28.127  41.525  1.00 23.09           C  
ATOM    222  C   ASP A  29      52.145  28.661  40.110  1.00 23.68           C  
ATOM    223  O   ASP A  29      52.758  29.707  39.886  1.00 22.42           O  
ATOM    224  CB  ASP A  29      52.959  27.003  41.791  1.00 21.96           C  
ATOM    225  CG  ASP A  29      54.399  27.467  41.682  1.00 23.43           C  
ATOM    226  OD1 ASP A  29      54.801  28.343  42.473  1.00 23.86           O  
ATOM    227  OD2 ASP A  29      55.131  26.956  40.803  1.00 24.34           O  
ATOM    228  N   TYR A  30      51.611  27.917  39.155  1.00 24.49           N  
ATOM    229  CA  TYR A  30      51.683  28.297  37.758  1.00 26.04           C  
ATOM    230  C   TYR A  30      51.046  29.680  37.589  1.00 26.54           C  
ATOM    231  O   TYR A  30      51.605  30.560  36.932  1.00 27.31           O  
ATOM    232  CB  TYR A  30      50.932  27.268  36.921  1.00 26.23           C  
ATOM    233  CG  TYR A  30      50.744  27.645  35.476  1.00 30.79           C  
ATOM    234  CD1 TYR A  30      51.792  27.538  34.560  1.00 31.55           C  
ATOM    235  CD2 TYR A  30      49.504  28.086  35.012  1.00 31.00           C  
ATOM    236  CE1 TYR A  30      51.606  27.854  33.214  1.00 32.56           C  
ATOM    237  CE2 TYR A  30      49.308  28.406  33.675  1.00 32.71           C  
ATOM    238  CZ  TYR A  30      50.361  28.286  32.781  1.00 33.98           C  
ATOM    239  OH  TYR A  30      50.160  28.591  31.453  1.00 36.02           O  
ATOM    240  N   ALA A  31      49.885  29.867  38.206  1.00 24.12           N  
ATOM    241  CA  ALA A  31      49.160  31.123  38.115  1.00 25.12           C  
ATOM    242  C   ALA A  31      49.930  32.358  38.583  1.00 25.87           C  
ATOM    243  O   ALA A  31      49.855  33.402  37.937  1.00 26.85           O  
ATOM    244  CB  ALA A  31      47.839  31.017  38.880  1.00 24.02           C  
ATOM    245  N   GLN A  32      50.653  32.259  39.698  1.00 26.01           N  
ATOM    246  CA  GLN A  32      51.387  33.417  40.203  1.00 28.20           C  
ATOM    247  C   GLN A  32      52.686  33.634  39.431  1.00 28.42           C  
ATOM    248  O   GLN A  32      53.220  34.741  39.394  1.00 28.24           O  
ATOM    249  CB  GLN A  32      51.639  33.295  41.719  1.00 27.97           C  
ATOM    250  CG  GLN A  32      52.513  32.129  42.168  1.00 31.23           C  
ATOM    251  CD  GLN A  32      54.001  32.372  41.947  1.00 31.01           C  
ATOM    252  OE1 GLN A  32      54.510  33.459  42.225  1.00 29.92           O  
ATOM    253  NE2 GLN A  32      54.706  31.351  41.465  1.00 30.84           N  
ATOM    254  N   ASP A  33      53.190  32.570  38.816  1.00 28.63           N  
ATOM    255  CA  ASP A  33      54.389  32.667  37.996  1.00 28.12           C  
ATOM    256  C   ASP A  33      54.024  33.529  36.785  1.00 27.45           C  
ATOM    257  O   ASP A  33      54.757  34.440  36.404  1.00 27.64           O  
ATOM    258  CB  ASP A  33      54.809  31.284  37.508  1.00 29.95           C  
ATOM    259  CG  ASP A  33      55.919  30.685  38.337  1.00 31.13           C  
ATOM    260  OD1 ASP A  33      56.282  29.521  38.068  1.00 33.98           O  
ATOM    261  OD2 ASP A  33      56.432  31.374  39.242  1.00 28.70           O  
ATOM    262  N   ALA A  34      52.872  33.226  36.194  1.00 25.89           N  
ATOM    263  CA  ALA A  34      52.376  33.940  35.025  1.00 25.80           C  
ATOM    264  C   ALA A  34      51.992  35.392  35.326  1.00 26.31           C  
ATOM    265  O   ALA A  34      52.091  36.256  34.451  1.00 25.71           O  
ATOM    266  CB  ALA A  34      51.180  33.197  34.442  1.00 24.21           C  
ATOM    267  N   LEU A  35      51.562  35.660  36.560  1.00 24.86           N  
ATOM    268  CA  LEU A  35      51.157  37.009  36.947  1.00 25.27           C  
ATOM    269  C   LEU A  35      52.302  37.921  37.333  1.00 26.86           C  
ATOM    270  O   LEU A  35      52.267  39.126  37.070  1.00 27.27           O  
ATOM    271  CB  LEU A  35      50.182  36.958  38.115  1.00 22.15           C  
ATOM    272  CG  LEU A  35      48.779  36.528  37.725  1.00 23.54           C  
ATOM    273  CD1 LEU A  35      47.895  36.479  38.959  1.00 25.42           C  
ATOM    274  CD2 LEU A  35      48.237  37.499  36.699  1.00 20.11           C  
ATOM    275  N   GLY A  36      53.316  37.341  37.961  1.00 28.44           N  
ATOM    276  CA  GLY A  36      54.444  38.127  38.414  1.00 28.31           C  
ATOM    277  C   GLY A  36      54.105  38.642  39.800  1.00 30.07           C  
ATOM    278  O   GLY A  36      53.115  38.211  40.407  1.00 28.65           O  
ATOM    279  N   ASP A  37      54.920  39.566  40.299  1.00 30.72           N  
ATOM    280  CA  ASP A  37      54.697  40.140  41.616  1.00 32.16           C  
ATOM    281  C   ASP A  37      53.265  40.655  41.789  1.00 31.72           C  
ATOM    282  O   ASP A  37      52.763  41.432  40.970  1.00 31.95           O  
ATOM    283  CB  ASP A  37      55.683  41.285  41.860  1.00 33.99           C  
ATOM    284  CG  ASP A  37      57.128  40.822  41.881  1.00 35.56           C  
ATOM    285  OD1 ASP A  37      57.512  40.121  42.841  1.00 36.90           O  
ATOM    286  OD2 ASP A  37      57.878  41.154  40.940  1.00 36.21           O  
ATOM    287  N   VAL A  38      52.612  40.207  42.859  1.00 29.27           N  
ATOM    288  CA  VAL A  38      51.258  40.640  43.165  1.00 25.76           C  
ATOM    289  C   VAL A  38      51.373  41.886  44.036  1.00 25.37           C  
ATOM    290  O   VAL A  38      52.169  41.937  44.978  1.00 24.37           O  
ATOM    291  CB  VAL A  38      50.486  39.537  43.903  1.00 25.11           C  
ATOM    292  CG1 VAL A  38      49.091  40.028  44.300  1.00 21.29           C  
ATOM    293  CG2 VAL A  38      50.389  38.314  43.005  1.00 21.03           C  
ATOM    294  N   VAL A  39      50.583  42.897  43.710  1.00 24.70           N  
ATOM    295  CA  VAL A  39      50.625  44.143  44.455  1.00 25.31           C  
ATOM    296  C   VAL A  39      49.332  44.482  45.203  1.00 24.96           C  
ATOM    297  O   VAL A  39      49.324  45.349  46.069  1.00 25.22           O  
ATOM    298  CB  VAL A  39      51.000  45.301  43.512  1.00 26.84           C  
ATOM    299  CG1 VAL A  39      52.416  45.080  42.973  1.00 25.31           C  
ATOM    300  CG2 VAL A  39      50.000  45.382  42.353  1.00 24.54           C  
ATOM    301  N   TYR A  40      48.246  43.787  44.886  1.00 25.17           N  
ATOM    302  CA  TYR A  40      46.975  44.052  45.546  1.00 27.44           C  
ATOM    303  C   TYR A  40      45.949  42.949  45.289  1.00 25.88           C  
ATOM    304  O   TYR A  40      45.900  42.379  44.203  1.00 25.59           O  
ATOM    305  CB  TYR A  40      46.437  45.409  45.069  1.00 30.62           C  
ATOM    306  CG  TYR A  40      45.019  45.729  45.490  1.00 35.27           C  
ATOM    307  CD1 TYR A  40      44.703  46.027  46.819  1.00 34.90           C  
ATOM    308  CD2 TYR A  40      43.987  45.738  44.545  1.00 37.51           C  
ATOM    309  CE1 TYR A  40      43.388  46.327  47.195  1.00 36.24           C  
ATOM    310  CE2 TYR A  40      42.674  46.035  44.906  1.00 38.31           C  
ATOM    311  CZ  TYR A  40      42.379  46.327  46.228  1.00 39.42           C  
ATOM    312  OH  TYR A  40      41.073  46.621  46.561  1.00 41.70           O  
ATOM    313  N   VAL A  41      45.142  42.637  46.299  1.00 25.21           N  
ATOM    314  CA  VAL A  41      44.111  41.613  46.152  1.00 25.18           C  
ATOM    315  C   VAL A  41      42.745  42.116  46.589  1.00 25.28           C  
ATOM    316  O   VAL A  41      42.567  42.508  47.739  1.00 27.29           O  
ATOM    317  CB  VAL A  41      44.405  40.353  46.981  1.00 23.57           C  
ATOM    318  CG1 VAL A  41      43.321  39.314  46.720  1.00 21.08           C  
ATOM    319  CG2 VAL A  41      45.768  39.797  46.634  1.00 24.96           C  
ATOM    320  N   GLU A  42      41.786  42.095  45.670  1.00 23.71           N  
ATOM    321  CA  GLU A  42      40.431  42.527  45.968  1.00 23.77           C  
ATOM    322  C   GLU A  42      39.712  41.329  46.573  1.00 22.73           C  
ATOM    323  O   GLU A  42      39.569  40.298  45.931  1.00 22.30           O  
ATOM    324  CB  GLU A  42      39.739  42.971  44.683  1.00 28.37           C  
ATOM    325  CG  GLU A  42      38.348  43.561  44.878  1.00 33.76           C  
ATOM    326  CD  GLU A  42      37.756  44.087  43.574  1.00 36.15           C  
ATOM    327  OE1 GLU A  42      36.893  43.402  42.973  1.00 35.87           O  
ATOM    328  OE2 GLU A  42      38.172  45.185  43.149  1.00 36.20           O  
ATOM    329  N   LEU A  43      39.255  41.459  47.807  1.00 22.10           N  
ATOM    330  CA  LEU A  43      38.592  40.348  48.471  1.00 22.56           C  
ATOM    331  C   LEU A  43      37.077  40.471  48.484  1.00 23.06           C  
ATOM    332  O   LEU A  43      36.538  41.571  48.553  1.00 24.79           O  
ATOM    333  CB  LEU A  43      39.133  40.233  49.893  1.00 21.02           C  
ATOM    334  CG  LEU A  43      40.658  40.069  49.878  1.00 22.87           C  
ATOM    335  CD1 LEU A  43      41.255  40.357  51.256  1.00 20.59           C  
ATOM    336  CD2 LEU A  43      40.995  38.654  49.395  1.00 21.48           C  
ATOM    337  N   PRO A  44      36.368  39.335  48.404  1.00 23.54           N  
ATOM    338  CA  PRO A  44      34.902  39.333  48.412  1.00 23.88           C  
ATOM    339  C   PRO A  44      34.412  39.486  49.837  1.00 24.83           C  
ATOM    340  O   PRO A  44      35.054  39.005  50.774  1.00 26.15           O  
ATOM    341  CB  PRO A  44      34.564  37.957  47.855  1.00 24.47           C  
ATOM    342  CG  PRO A  44      35.649  37.103  48.476  1.00 23.52           C  
ATOM    343  CD  PRO A  44      36.896  37.962  48.277  1.00 22.70           C  
ATOM    344  N   GLU A  45      33.277  40.157  49.998  1.00 24.74           N  
ATOM    345  CA  GLU A  45      32.679  40.365  51.315  1.00 23.99           C  
ATOM    346  C   GLU A  45      32.331  39.031  51.976  1.00 22.61           C  
ATOM    347  O   GLU A  45      31.820  38.132  51.313  1.00 23.93           O  
ATOM    348  CB  GLU A  45      31.418  41.209  51.164  1.00 24.62           C  
ATOM    349  CG  GLU A  45      30.427  41.059  52.291  1.00 27.15           C  
ATOM    350  CD  GLU A  45      29.233  41.974  52.124  1.00 28.26           C  
ATOM    351  OE1 GLU A  45      28.565  41.906  51.069  1.00 27.99           O  
ATOM    352  OE2 GLU A  45      28.966  42.763  53.052  1.00 29.50           O  
ATOM    353  N   VAL A  46      32.607  38.901  53.274  1.00 21.15           N  
ATOM    354  CA  VAL A  46      32.301  37.664  54.001  1.00 20.07           C  
ATOM    355  C   VAL A  46      30.801  37.523  54.195  1.00 20.15           C  
ATOM    356  O   VAL A  46      30.142  38.458  54.646  1.00 22.58           O  
ATOM    357  CB  VAL A  46      32.983  37.628  55.406  1.00 20.46           C  
ATOM    358  CG1 VAL A  46      32.306  36.601  56.301  1.00 17.18           C  
ATOM    359  CG2 VAL A  46      34.452  37.267  55.264  1.00 21.08           C  
ATOM    360  N   GLY A  47      30.265  36.355  53.855  1.00 19.26           N  
ATOM    361  CA  GLY A  47      28.836  36.125  54.010  1.00 20.15           C  
ATOM    362  C   GLY A  47      28.070  36.069  52.698  1.00 20.81           C  
ATOM    363  O   GLY A  47      26.968  35.537  52.631  1.00 21.65           O  
ATOM    364  N   ARG A  48      28.645  36.633  51.646  1.00 21.94           N  
ATOM    365  CA  ARG A  48      27.998  36.614  50.350  1.00 22.36           C  
ATOM    366  C   ARG A  48      27.768  35.190  49.883  1.00 23.90           C  
ATOM    367  O   ARG A  48      28.572  34.295  50.155  1.00 23.37           O  
ATOM    368  CB  ARG A  48      28.862  37.320  49.307  1.00 22.91           C  
ATOM    369  CG  ARG A  48      28.844  38.831  49.371  1.00 26.27           C  
ATOM    370  CD  ARG A  48      29.615  39.390  48.192  1.00 27.73           C  
ATOM    371  NE  ARG A  48      29.168  38.773  46.949  1.00 26.85           N  
ATOM    372  CZ  ARG A  48      29.894  38.712  45.841  1.00 26.32           C  
ATOM    373  NH1 ARG A  48      31.113  39.235  45.807  1.00 25.84           N  
ATOM    374  NH2 ARG A  48      29.406  38.101  44.775  1.00 27.57           N  
ATOM    375  N   VAL A  49      26.658  34.982  49.183  1.00 25.37           N  
ATOM    376  CA  VAL A  49      26.347  33.674  48.624  1.00 25.80           C  
ATOM    377  C   VAL A  49      26.756  33.806  47.160  1.00 25.69           C  
ATOM    378  O   VAL A  49      26.320  34.722  46.464  1.00 25.83           O  
ATOM    379  CB  VAL A  49      24.839  33.337  48.736  1.00 25.82           C  
ATOM    380  CG1 VAL A  49      24.534  32.032  48.014  1.00 21.44           C  
ATOM    381  CG2 VAL A  49      24.452  33.222  50.196  1.00 24.42           C  
ATOM    382  N   VAL A  50      27.614  32.897  46.711  1.00 25.75           N  
ATOM    383  CA  VAL A  50      28.130  32.919  45.349  1.00 24.86           C  
ATOM    384  C   VAL A  50      27.828  31.631  44.581  1.00 25.70           C  
ATOM    385  O   VAL A  50      27.731  30.547  45.162  1.00 23.81           O  
ATOM    386  CB  VAL A  50      29.648  33.141  45.378  1.00 23.94           C  
ATOM    387  CG1 VAL A  50      29.961  34.508  45.968  1.00 24.06           C  
ATOM    388  CG2 VAL A  50      30.308  32.062  46.230  1.00 24.88           C  
ATOM    389  N   GLU A  51      27.678  31.757  43.268  1.00 26.91           N  
ATOM    390  CA  GLU A  51      27.389  30.604  42.427  1.00 28.64           C  
ATOM    391  C   GLU A  51      28.674  30.125  41.777  1.00 27.71           C  
ATOM    392  O   GLU A  51      29.655  30.861  41.696  1.00 28.52           O  
ATOM    393  CB  GLU A  51      26.367  30.969  41.337  1.00 31.56           C  
ATOM    394  CG  GLU A  51      25.134  31.692  41.854  1.00 35.68           C  
ATOM    395  CD  GLU A  51      24.478  30.975  43.023  1.00 39.76           C  
ATOM    396  OE1 GLU A  51      23.885  31.659  43.891  1.00 41.11           O  
ATOM    397  OE2 GLU A  51      24.547  29.728  43.076  1.00 41.51           O  
ATOM    398  N   LYS A  52      28.662  28.888  41.307  1.00 27.74           N  
ATOM    399  CA  LYS A  52      29.828  28.318  40.655  1.00 27.26           C  
ATOM    400  C   LYS A  52      30.267  29.139  39.444  1.00 28.42           C  
ATOM    401  O   LYS A  52      29.468  29.439  38.550  1.00 27.64           O  
ATOM    402  CB  LYS A  52      29.521  26.881  40.233  1.00 26.57           C  
ATOM    403  CG  LYS A  52      30.631  26.196  39.459  1.00 26.87           C  
ATOM    404  CD  LYS A  52      30.339  24.714  39.334  1.00 25.17           C  
ATOM    405  CE  LYS A  52      31.401  23.984  38.532  1.00 24.80           C  
ATOM    406  NZ  LYS A  52      31.104  22.517  38.509  1.00 26.31           N  
ATOM    407  N   GLY A  53      31.544  29.514  39.430  1.00 29.28           N  
ATOM    408  CA  GLY A  53      32.085  30.269  38.312  1.00 27.73           C  
ATOM    409  C   GLY A  53      31.982  31.775  38.415  1.00 27.55           C  
ATOM    410  O   GLY A  53      32.516  32.494  37.568  1.00 26.89           O  
ATOM    411  N   GLU A  54      31.299  32.258  39.447  1.00 26.21           N  
ATOM    412  CA  GLU A  54      31.136  33.689  39.637  1.00 25.73           C  
ATOM    413  C   GLU A  54      32.457  34.347  39.997  1.00 25.75           C  
ATOM    414  O   GLU A  54      33.190  33.855  40.852  1.00 26.04           O  
ATOM    415  CB  GLU A  54      30.124  33.955  40.745  1.00 25.12           C  
ATOM    416  CG  GLU A  54      29.744  35.409  40.884  1.00 26.15           C  
ATOM    417  CD  GLU A  54      28.717  35.633  41.974  1.00 28.36           C  
ATOM    418  OE1 GLU A  54      27.854  34.754  42.159  1.00 27.81           O  
ATOM    419  OE2 GLU A  54      28.761  36.690  42.638  1.00 30.65           O  
ATOM    420  N   ALA A  55      32.773  35.455  39.338  1.00 26.03           N  
ATOM    421  CA  ALA A  55      34.010  36.169  39.646  1.00 27.03           C  
ATOM    422  C   ALA A  55      33.784  36.847  41.002  1.00 27.26           C  
ATOM    423  O   ALA A  55      32.854  37.642  41.154  1.00 28.22           O  
ATOM    424  CB  ALA A  55      34.304  37.208  38.562  1.00 25.59           C  
ATOM    425  N   VAL A  56      34.630  36.535  41.983  1.00 26.03           N  
ATOM    426  CA  VAL A  56      34.474  37.086  43.325  1.00 24.26           C  
ATOM    427  C   VAL A  56      35.723  37.736  43.917  1.00 25.34           C  
ATOM    428  O   VAL A  56      35.662  38.347  44.987  1.00 24.89           O  
ATOM    429  CB  VAL A  56      34.011  35.992  44.296  1.00 24.70           C  
ATOM    430  CG1 VAL A  56      32.757  35.298  43.754  1.00 21.76           C  
ATOM    431  CG2 VAL A  56      35.133  34.989  44.504  1.00 24.29           C  
ATOM    432  N   ALA A  57      36.855  37.594  43.239  1.00 25.31           N  
ATOM    433  CA  ALA A  57      38.095  38.177  43.727  1.00 24.48           C  
ATOM    434  C   ALA A  57      38.959  38.610  42.565  1.00 25.69           C  
ATOM    435  O   ALA A  57      38.861  38.064  41.469  1.00 27.10           O  
ATOM    436  CB  ALA A  57      38.852  37.171  44.589  1.00 24.51           C  
ATOM    437  N   VAL A  58      39.805  39.605  42.802  1.00 26.34           N  
ATOM    438  CA  VAL A  58      40.693  40.090  41.760  1.00 26.38           C  
ATOM    439  C   VAL A  58      42.103  40.211  42.303  1.00 26.43           C  
ATOM    440  O   VAL A  58      42.345  40.942  43.265  1.00 27.97           O  
ATOM    441  CB  VAL A  58      40.249  41.470  41.215  1.00 25.75           C  
ATOM    442  CG1 VAL A  58      41.288  41.993  40.231  1.00 25.35           C  
ATOM    443  CG2 VAL A  58      38.899  41.351  40.523  1.00 24.64           C  
ATOM    444  N   VAL A  59      43.022  39.471  41.696  1.00 24.97           N  
ATOM    445  CA  VAL A  59      44.416  39.516  42.097  1.00 24.84           C  
ATOM    446  C   VAL A  59      45.087  40.447  41.099  1.00 24.42           C  
ATOM    447  O   VAL A  59      45.078  40.197  39.898  1.00 24.97           O  
ATOM    448  CB  VAL A  59      45.074  38.105  42.057  1.00 25.33           C  
ATOM    449  CG1 VAL A  59      44.347  37.154  43.020  1.00 22.57           C  
ATOM    450  CG2 VAL A  59      45.038  37.547  40.644  1.00 28.77           C  
ATOM    451  N   GLU A  60      45.635  41.542  41.598  1.00 24.28           N  
ATOM    452  CA  GLU A  60      46.291  42.521  40.748  1.00 24.67           C  
ATOM    453  C   GLU A  60      47.795  42.442  40.873  1.00 24.37           C  
ATOM    454  O   GLU A  60      48.344  42.666  41.949  1.00 25.09           O  
ATOM    455  CB  GLU A  60      45.813  43.924  41.117  1.00 24.90           C  
ATOM    456  CG  GLU A  60      44.376  44.184  40.718  1.00 27.51           C  
ATOM    457  CD  GLU A  60      43.801  45.432  41.354  1.00 27.87           C  
ATOM    458  OE1 GLU A  60      42.753  45.306  42.017  1.00 28.59           O  
ATOM    459  OE2 GLU A  60      44.383  46.528  41.194  1.00 27.26           O  
ATOM    460  N   SER A  61      48.464  42.133  39.769  1.00 24.63           N  
ATOM    461  CA  SER A  61      49.916  42.032  39.780  1.00 25.81           C  
ATOM    462  C   SER A  61      50.539  43.180  39.005  1.00 25.41           C  
ATOM    463  O   SER A  61      49.919  44.220  38.807  1.00 28.18           O  
ATOM    464  CB  SER A  61      50.363  40.705  39.169  1.00 26.50           C  
ATOM    465  OG  SER A  61      50.181  40.708  37.766  1.00 27.57           O  
ATOM    466  N   VAL A  62      51.773  42.984  38.561  1.00 25.07           N  
ATOM    467  CA  VAL A  62      52.477  44.007  37.811  1.00 23.49           C  
ATOM    468  C   VAL A  62      52.370  43.762  36.315  1.00 23.88           C  
ATOM    469  O   VAL A  62      52.992  44.459  35.516  1.00 24.14           O  
ATOM    470  CB  VAL A  62      53.956  44.058  38.218  1.00 23.43           C  
ATOM    471  CG1 VAL A  62      54.082  44.646  39.617  1.00 22.63           C  
ATOM    472  CG2 VAL A  62      54.553  42.664  38.173  1.00 20.86           C  
ATOM    473  N   LYS A  63      51.567  42.774  35.941  1.00 23.89           N  
ATOM    474  CA  LYS A  63      51.372  42.444  34.539  1.00 24.88           C  
ATOM    475  C   LYS A  63      49.912  42.606  34.125  1.00 25.29           C  
ATOM    476  O   LYS A  63      49.611  43.052  33.020  1.00 24.38           O  
ATOM    477  CB  LYS A  63      51.820  41.007  34.270  1.00 25.01           C  
ATOM    478  CG  LYS A  63      53.243  40.707  34.721  1.00 26.72           C  
ATOM    479  CD  LYS A  63      53.762  39.399  34.127  1.00 26.75           C  
ATOM    480  CE  LYS A  63      54.080  39.544  32.640  1.00 28.37           C  
ATOM    481  NZ  LYS A  63      55.111  40.605  32.404  1.00 27.28           N  
ATOM    482  N   THR A  64      49.006  42.255  35.026  1.00 26.63           N  
ATOM    483  CA  THR A  64      47.583  42.331  34.736  1.00 28.58           C  
ATOM    484  C   THR A  64      46.724  42.107  35.981  1.00 29.51           C  
ATOM    485  O   THR A  64      47.239  41.904  37.081  1.00 30.44           O  
ATOM    486  CB  THR A  64      47.198  41.263  33.695  1.00 29.38           C  
ATOM    487  OG1 THR A  64      45.798  41.349  33.408  1.00 30.97           O  
ATOM    488  CG2 THR A  64      47.522  39.871  34.224  1.00 28.19           C  
ATOM    489  N   ALA A  65      45.411  42.161  35.786  1.00 29.07           N  
ATOM    490  CA  ALA A  65      44.442  41.942  36.847  1.00 27.95           C  
ATOM    491  C   ALA A  65      43.742  40.647  36.465  1.00 27.54           C  
ATOM    492  O   ALA A  65      43.330  40.475  35.316  1.00 25.54           O  
ATOM    493  CB  ALA A  65      43.448  43.093  36.899  1.00 28.20           C  
ATOM    494  N   SER A  66      43.607  39.741  37.427  1.00 27.67           N  
ATOM    495  CA  SER A  66      42.990  38.445  37.171  1.00 28.08           C  
ATOM    496  C   SER A  66      41.752  38.140  38.010  1.00 30.07           C  
ATOM    497  O   SER A  66      41.794  38.170  39.244  1.00 31.68           O  
ATOM    498  CB  SER A  66      44.027  37.344  37.389  1.00 26.04           C  
ATOM    499  OG  SER A  66      43.449  36.067  37.208  1.00 26.06           O  
ATOM    500  N   ASP A  67      40.644  37.833  37.345  1.00 29.68           N  
ATOM    501  CA  ASP A  67      39.426  37.506  38.070  1.00 29.56           C  
ATOM    502  C   ASP A  67      39.491  36.083  38.633  1.00 28.36           C  
ATOM    503  O   ASP A  67      39.751  35.127  37.901  1.00 27.83           O  
ATOM    504  CB  ASP A  67      38.199  37.659  37.159  1.00 30.33           C  
ATOM    505  CG  ASP A  67      37.867  39.115  36.861  1.00 31.56           C  
ATOM    506  OD1 ASP A  67      38.168  39.988  37.710  1.00 29.54           O  
ATOM    507  OD2 ASP A  67      37.287  39.388  35.785  1.00 32.09           O  
ATOM    508  N   ILE A  68      39.269  35.963  39.941  1.00 26.87           N  
ATOM    509  CA  ILE A  68      39.278  34.680  40.642  1.00 23.37           C  
ATOM    510  C   ILE A  68      37.831  34.220  40.765  1.00 22.51           C  
ATOM    511  O   ILE A  68      36.975  34.965  41.234  1.00 22.30           O  
ATOM    512  CB  ILE A  68      39.907  34.831  42.048  1.00 23.26           C  
ATOM    513  CG1 ILE A  68      41.428  34.810  41.938  1.00 23.10           C  
ATOM    514  CG2 ILE A  68      39.458  33.712  42.962  1.00 25.26           C  
ATOM    515  CD1 ILE A  68      42.000  35.935  41.160  1.00 24.62           C  
ATOM    516  N   TYR A  69      37.555  32.992  40.346  1.00 21.78           N  
ATOM    517  CA  TYR A  69      36.189  32.486  40.382  1.00 21.46           C  
ATOM    518  C   TYR A  69      35.901  31.567  41.550  1.00 21.81           C  
ATOM    519  O   TYR A  69      36.818  31.074  42.208  1.00 23.41           O  
ATOM    520  CB  TYR A  69      35.876  31.779  39.066  1.00 22.16           C  
ATOM    521  CG  TYR A  69      36.373  32.567  37.878  1.00 22.02           C  
ATOM    522  CD1 TYR A  69      37.645  32.339  37.343  1.00 22.52           C  
ATOM    523  CD2 TYR A  69      35.612  33.599  37.345  1.00 20.02           C  
ATOM    524  CE1 TYR A  69      38.145  33.126  36.310  1.00 22.21           C  
ATOM    525  CE2 TYR A  69      36.100  34.394  36.317  1.00 22.79           C  
ATOM    526  CZ  TYR A  69      37.365  34.154  35.804  1.00 23.31           C  
ATOM    527  OH  TYR A  69      37.844  34.954  34.798  1.00 22.36           O  
ATOM    528  N   ALA A  70      34.618  31.360  41.822  1.00 20.51           N  
ATOM    529  CA  ALA A  70      34.221  30.490  42.919  1.00 21.70           C  
ATOM    530  C   ALA A  70      34.154  29.067  42.359  1.00 21.17           C  
ATOM    531  O   ALA A  70      33.203  28.721  41.667  1.00 22.76           O  
ATOM    532  CB  ALA A  70      32.864  30.920  43.475  1.00 18.05           C  
ATOM    533  N   PRO A  71      35.175  28.235  42.648  1.00 21.11           N  
ATOM    534  CA  PRO A  71      35.285  26.844  42.193  1.00 21.09           C  
ATOM    535  C   PRO A  71      33.965  26.098  42.185  1.00 20.62           C  
ATOM    536  O   PRO A  71      33.718  25.258  41.318  1.00 21.62           O  
ATOM    537  CB  PRO A  71      36.293  26.247  43.167  1.00 21.27           C  
ATOM    538  CG  PRO A  71      37.231  27.392  43.373  1.00 21.86           C  
ATOM    539  CD  PRO A  71      36.283  28.564  43.566  1.00 21.26           C  
ATOM    540  N   VAL A  72      33.123  26.406  43.160  1.00 19.07           N  
ATOM    541  CA  VAL A  72      31.810  25.797  43.259  1.00 20.29           C  
ATOM    542  C   VAL A  72      30.907  26.803  43.956  1.00 20.87           C  
ATOM    543  O   VAL A  72      31.398  27.753  44.564  1.00 21.54           O  
ATOM    544  CB  VAL A  72      31.840  24.471  44.078  1.00 22.14           C  
ATOM    545  CG1 VAL A  72      32.650  23.413  43.340  1.00 21.08           C  
ATOM    546  CG2 VAL A  72      32.421  24.712  45.461  1.00 21.51           C  
ATOM    547  N   ALA A  73      29.593  26.611  43.856  1.00 21.00           N  
ATOM    548  CA  ALA A  73      28.643  27.510  44.505  1.00 19.14           C  
ATOM    549  C   ALA A  73      28.726  27.342  46.021  1.00 18.87           C  
ATOM    550  O   ALA A  73      29.049  26.268  46.529  1.00 18.99           O  
ATOM    551  CB  ALA A  73      27.222  27.210  44.023  1.00 17.89           C  
ATOM    552  N   GLY A  74      28.428  28.407  46.748  1.00 19.65           N  
ATOM    553  CA  GLY A  74      28.483  28.336  48.193  1.00 19.80           C  
ATOM    554  C   GLY A  74      28.552  29.726  48.780  1.00 20.17           C  
ATOM    555  O   GLY A  74      28.163  30.693  48.128  1.00 20.74           O  
ATOM    556  N   GLU A  75      29.071  29.831  50.000  1.00 19.53           N  
ATOM    557  CA  GLU A  75      29.166  31.115  50.681  1.00 19.06           C  
ATOM    558  C   GLU A  75      30.586  31.397  51.157  1.00 19.70           C  
ATOM    559  O   GLU A  75      31.315  30.477  51.548  1.00 19.44           O  
ATOM    560  CB  GLU A  75      28.212  31.132  51.879  1.00 18.64           C  
ATOM    561  CG  GLU A  75      28.084  32.458  52.604  1.00 17.95           C  
ATOM    562  CD  GLU A  75      27.385  32.308  53.944  1.00 21.42           C  
ATOM    563  OE1 GLU A  75      26.626  31.327  54.102  1.00 25.89           O  
ATOM    564  OE2 GLU A  75      27.581  33.165  54.836  1.00 19.81           O  
ATOM    565  N   ILE A  76      30.966  32.674  51.120  1.00 18.03           N  
ATOM    566  CA  ILE A  76      32.284  33.103  51.566  1.00 18.77           C  
ATOM    567  C   ILE A  76      32.215  33.164  53.096  1.00 20.41           C  
ATOM    568  O   ILE A  76      31.436  33.939  53.654  1.00 20.58           O  
ATOM    569  CB  ILE A  76      32.650  34.519  51.012  1.00 16.96           C  
ATOM    570  CG1 ILE A  76      32.444  34.579  49.492  1.00 14.01           C  
ATOM    571  CG2 ILE A  76      34.099  34.837  51.332  1.00 17.99           C  
ATOM    572  CD1 ILE A  76      33.333  33.639  48.698  1.00 10.08           C  
ATOM    573  N   VAL A  77      33.008  32.344  53.778  1.00 19.77           N  
ATOM    574  CA  VAL A  77      32.973  32.347  55.235  1.00 19.68           C  
ATOM    575  C   VAL A  77      34.206  32.987  55.850  1.00 21.21           C  
ATOM    576  O   VAL A  77      34.276  33.166  57.063  1.00 20.80           O  
ATOM    577  CB  VAL A  77      32.809  30.913  55.804  1.00 18.18           C  
ATOM    578  CG1 VAL A  77      31.408  30.393  55.522  1.00 17.51           C  
ATOM    579  CG2 VAL A  77      33.826  29.994  55.183  1.00 17.36           C  
ATOM    580  N   GLU A  78      35.177  33.333  55.013  1.00 23.75           N  
ATOM    581  CA  GLU A  78      36.401  33.957  55.499  1.00 25.69           C  
ATOM    582  C   GLU A  78      37.206  34.582  54.371  1.00 25.88           C  
ATOM    583  O   GLU A  78      37.172  34.119  53.235  1.00 27.12           O  
ATOM    584  CB  GLU A  78      37.270  32.930  56.230  1.00 27.83           C  
ATOM    585  CG  GLU A  78      38.504  33.535  56.887  1.00 30.75           C  
ATOM    586  CD  GLU A  78      39.293  32.538  57.706  1.00 32.58           C  
ATOM    587  OE1 GLU A  78      40.342  32.933  58.266  1.00 35.50           O  
ATOM    588  OE2 GLU A  78      38.866  31.365  57.793  1.00 34.17           O  
ATOM    589  N   VAL A  79      37.940  35.635  54.708  1.00 26.31           N  
ATOM    590  CA  VAL A  79      38.771  36.352  53.754  1.00 26.70           C  
ATOM    591  C   VAL A  79      40.168  36.513  54.355  1.00 27.53           C  
ATOM    592  O   VAL A  79      40.293  36.812  55.544  1.00 27.91           O  
ATOM    593  CB  VAL A  79      38.148  37.738  53.453  1.00 25.52           C  
ATOM    594  CG1 VAL A  79      39.191  38.698  52.967  1.00 24.22           C  
ATOM    595  CG2 VAL A  79      37.066  37.583  52.407  1.00 27.29           C  
ATOM    596  N   ASN A  80      41.214  36.306  53.549  1.00 26.49           N  
ATOM    597  CA  ASN A  80      42.578  36.434  54.054  1.00 26.11           C  
ATOM    598  C   ASN A  80      43.009  37.884  54.135  1.00 25.77           C  
ATOM    599  O   ASN A  80      43.529  38.442  53.173  1.00 26.59           O  
ATOM    600  CB  ASN A  80      43.579  35.680  53.177  1.00 26.47           C  
ATOM    601  CG  ASN A  80      44.973  35.634  53.798  1.00 25.41           C  
ATOM    602  OD1 ASN A  80      45.317  36.462  54.649  1.00 23.53           O  
ATOM    603  ND2 ASN A  80      45.781  34.672  53.371  1.00 25.22           N  
ATOM    604  N   LEU A  81      42.814  38.480  55.303  1.00 27.00           N  
ATOM    605  CA  LEU A  81      43.161  39.870  55.533  1.00 27.16           C  
ATOM    606  C   LEU A  81      44.633  40.212  55.301  1.00 27.84           C  
ATOM    607  O   LEU A  81      44.956  41.305  54.829  1.00 28.21           O  
ATOM    608  CB  LEU A  81      42.747  40.261  56.950  1.00 27.88           C  
ATOM    609  CG  LEU A  81      41.231  40.318  57.162  1.00 28.67           C  
ATOM    610  CD1 LEU A  81      40.943  40.706  58.603  1.00 30.49           C  
ATOM    611  CD2 LEU A  81      40.605  41.326  56.206  1.00 26.78           C  
ATOM    612  N   ALA A  82      45.524  39.280  55.617  1.00 27.12           N  
ATOM    613  CA  ALA A  82      46.957  39.509  55.441  1.00 27.74           C  
ATOM    614  C   ALA A  82      47.346  39.892  54.005  1.00 28.47           C  
ATOM    615  O   ALA A  82      48.442  40.402  53.769  1.00 26.69           O  
ATOM    616  CB  ALA A  82      47.725  38.271  55.876  1.00 28.36           C  
ATOM    617  N   LEU A  83      46.459  39.643  53.047  1.00 29.14           N  
ATOM    618  CA  LEU A  83      46.758  39.974  51.659  1.00 30.49           C  
ATOM    619  C   LEU A  83      46.564  41.458  51.389  1.00 32.23           C  
ATOM    620  O   LEU A  83      46.881  41.949  50.304  1.00 33.30           O  
ATOM    621  CB  LEU A  83      45.903  39.140  50.697  1.00 26.27           C  
ATOM    622  CG  LEU A  83      46.167  37.630  50.724  1.00 24.67           C  
ATOM    623  CD1 LEU A  83      45.337  36.950  49.654  1.00 24.49           C  
ATOM    624  CD2 LEU A  83      47.650  37.347  50.502  1.00 24.52           C  
ATOM    625  N   GLU A  84      46.044  42.172  52.377  1.00 32.30           N  
ATOM    626  CA  GLU A  84      45.858  43.605  52.224  1.00 36.20           C  
ATOM    627  C   GLU A  84      47.194  44.288  52.484  1.00 37.32           C  
ATOM    628  O   GLU A  84      47.611  45.162  51.723  1.00 37.33           O  
ATOM    629  CB  GLU A  84      44.807  44.113  53.207  1.00 38.40           C  
ATOM    630  CG  GLU A  84      43.471  44.424  52.562  1.00 41.12           C  
ATOM    631  CD  GLU A  84      42.324  44.283  53.533  1.00 43.32           C  
ATOM    632  OE1 GLU A  84      42.460  44.766  54.679  1.00 42.92           O  
ATOM    633  OE2 GLU A  84      41.287  43.694  53.150  1.00 45.54           O  
ATOM    634  N   LYS A  85      47.868  43.860  53.550  1.00 38.49           N  
ATOM    635  CA  LYS A  85      49.162  44.415  53.927  1.00 39.18           C  
ATOM    636  C   LYS A  85      50.359  43.736  53.256  1.00 38.42           C  
ATOM    637  O   LYS A  85      51.394  44.366  53.044  1.00 37.18           O  
ATOM    638  CB  LYS A  85      49.327  44.371  55.450  1.00 41.38           C  
ATOM    639  CG  LYS A  85      48.693  45.556  56.183  1.00 44.03           C  
ATOM    640  CD  LYS A  85      49.385  46.871  55.820  1.00 47.21           C  
ATOM    641  CE  LYS A  85      48.494  47.781  54.983  1.00 47.38           C  
ATOM    642  NZ  LYS A  85      47.295  48.247  55.741  1.00 46.47           N  
ATOM    643  N   THR A  86      50.228  42.456  52.925  1.00 38.25           N  
ATOM    644  CA  THR A  86      51.322  41.742  52.277  1.00 37.06           C  
ATOM    645  C   THR A  86      50.819  40.845  51.150  1.00 37.14           C  
ATOM    646  O   THR A  86      50.833  39.621  51.264  1.00 37.90           O  
ATOM    647  CB  THR A  86      52.105  40.875  53.284  1.00 37.29           C  
ATOM    648  OG1 THR A  86      51.253  39.848  53.801  1.00 37.85           O  
ATOM    649  CG2 THR A  86      52.615  41.726  54.433  1.00 36.77           C  
ATOM    650  N   PRO A  87      50.366  41.452  50.043  1.00 36.80           N  
ATOM    651  CA  PRO A  87      49.848  40.740  48.870  1.00 34.44           C  
ATOM    652  C   PRO A  87      50.807  39.730  48.248  1.00 31.67           C  
ATOM    653  O   PRO A  87      50.376  38.723  47.692  1.00 29.50           O  
ATOM    654  CB  PRO A  87      49.515  41.875  47.901  1.00 34.97           C  
ATOM    655  CG  PRO A  87      49.099  42.969  48.818  1.00 37.49           C  
ATOM    656  CD  PRO A  87      50.166  42.904  49.891  1.00 37.06           C  
ATOM    657  N   GLU A  88      52.105  40.001  48.344  1.00 32.11           N  
ATOM    658  CA  GLU A  88      53.115  39.121  47.757  1.00 32.67           C  
ATOM    659  C   GLU A  88      53.077  37.682  48.281  1.00 31.36           C  
ATOM    660  O   GLU A  88      53.683  36.782  47.682  1.00 30.42           O  
ATOM    661  CB  GLU A  88      54.524  39.713  47.933  1.00 34.55           C  
ATOM    662  CG  GLU A  88      55.082  39.711  49.355  1.00 38.58           C  
ATOM    663  CD  GLU A  88      54.660  40.919  50.180  1.00 40.66           C  
ATOM    664  OE1 GLU A  88      55.194  41.070  51.299  1.00 41.08           O  
ATOM    665  OE2 GLU A  88      53.806  41.713  49.721  1.00 41.49           O  
ATOM    666  N   LEU A  89      52.366  37.468  49.388  1.00 27.17           N  
ATOM    667  CA  LEU A  89      52.233  36.138  49.962  1.00 25.05           C  
ATOM    668  C   LEU A  89      51.696  35.183  48.902  1.00 25.14           C  
ATOM    669  O   LEU A  89      51.971  33.980  48.931  1.00 24.22           O  
ATOM    670  CB  LEU A  89      51.271  36.156  51.150  1.00 25.17           C  
ATOM    671  CG  LEU A  89      51.772  36.657  52.500  1.00 23.37           C  
ATOM    672  CD1 LEU A  89      50.623  36.683  53.483  1.00 22.99           C  
ATOM    673  CD2 LEU A  89      52.864  35.745  53.006  1.00 24.59           C  
ATOM    674  N   VAL A  90      50.922  35.725  47.969  1.00 24.35           N  
ATOM    675  CA  VAL A  90      50.352  34.914  46.906  1.00 24.60           C  
ATOM    676  C   VAL A  90      51.465  34.299  46.068  1.00 24.76           C  
ATOM    677  O   VAL A  90      51.338  33.171  45.591  1.00 25.53           O  
ATOM    678  CB  VAL A  90      49.425  35.752  45.993  1.00 24.72           C  
ATOM    679  CG1 VAL A  90      48.836  34.873  44.905  1.00 24.70           C  
ATOM    680  CG2 VAL A  90      48.303  36.365  46.815  1.00 24.33           C  
ATOM    681  N   ASN A  91      52.556  35.040  45.896  1.00 25.02           N  
ATOM    682  CA  ASN A  91      53.697  34.570  45.110  1.00 25.19           C  
ATOM    683  C   ASN A  91      54.590  33.637  45.918  1.00 25.60           C  
ATOM    684  O   ASN A  91      54.965  32.554  45.463  1.00 23.65           O  
ATOM    685  CB  ASN A  91      54.560  35.746  44.643  1.00 25.84           C  
ATOM    686  CG  ASN A  91      53.830  36.687  43.716  1.00 26.21           C  
ATOM    687  OD1 ASN A  91      53.469  37.794  44.105  1.00 29.85           O  
ATOM    688  ND2 ASN A  91      53.614  36.254  42.482  1.00 28.00           N  
ATOM    689  N   GLN A  92      54.939  34.097  47.116  1.00 27.20           N  
ATOM    690  CA  GLN A  92      55.815  33.376  48.023  1.00 28.44           C  
ATOM    691  C   GLN A  92      55.296  32.020  48.454  1.00 29.02           C  
ATOM    692  O   GLN A  92      56.075  31.078  48.608  1.00 28.69           O  
ATOM    693  CB  GLN A  92      56.064  34.210  49.280  1.00 29.49           C  
ATOM    694  CG  GLN A  92      56.667  35.575  49.030  1.00 30.81           C  
ATOM    695  CD  GLN A  92      56.748  36.417  50.299  1.00 32.11           C  
ATOM    696  OE1 GLN A  92      57.354  37.487  50.306  1.00 33.59           O  
ATOM    697  NE2 GLN A  92      56.131  35.935  51.374  1.00 32.48           N  
ATOM    698  N   ASP A  93      53.986  31.923  48.650  1.00 28.86           N  
ATOM    699  CA  ASP A  93      53.382  30.678  49.118  1.00 30.23           C  
ATOM    700  C   ASP A  93      51.915  30.616  48.681  1.00 30.33           C  
ATOM    701  O   ASP A  93      51.002  30.704  49.499  1.00 31.05           O  
ATOM    702  CB  ASP A  93      53.519  30.621  50.648  1.00 29.43           C  
ATOM    703  CG  ASP A  93      53.053  29.314  51.242  1.00 30.39           C  
ATOM    704  OD1 ASP A  93      53.172  28.267  50.578  1.00 31.83           O  
ATOM    705  OD2 ASP A  93      52.585  29.333  52.396  1.00 32.58           O  
ATOM    706  N   PRO A  94      51.683  30.450  47.371  1.00 28.83           N  
ATOM    707  CA  PRO A  94      50.364  30.372  46.743  1.00 27.77           C  
ATOM    708  C   PRO A  94      49.439  29.317  47.314  1.00 27.79           C  
ATOM    709  O   PRO A  94      48.231  29.532  47.403  1.00 30.05           O  
ATOM    710  CB  PRO A  94      50.695  30.112  45.277  1.00 28.54           C  
ATOM    711  CG  PRO A  94      51.968  29.331  45.361  1.00 30.28           C  
ATOM    712  CD  PRO A  94      52.738  30.113  46.399  1.00 29.51           C  
ATOM    713  N   TYR A  95      50.002  28.177  47.694  1.00 26.37           N  
ATOM    714  CA  TYR A  95      49.205  27.094  48.254  1.00 24.11           C  
ATOM    715  C   TYR A  95      49.121  27.166  49.781  1.00 22.57           C  
ATOM    716  O   TYR A  95      48.314  26.472  50.391  1.00 19.93           O  
ATOM    717  CB  TYR A  95      49.799  25.745  47.853  1.00 24.60           C  
ATOM    718  CG  TYR A  95      49.887  25.523  46.362  1.00 25.23           C  
ATOM    719  CD1 TYR A  95      48.738  25.472  45.570  1.00 24.55           C  
ATOM    720  CD2 TYR A  95      51.125  25.346  45.740  1.00 26.86           C  
ATOM    721  CE1 TYR A  95      48.820  25.247  44.197  1.00 24.87           C  
ATOM    722  CE2 TYR A  95      51.222  25.120  44.367  1.00 26.06           C  
ATOM    723  CZ  TYR A  95      50.070  25.070  43.606  1.00 26.12           C  
ATOM    724  OH  TYR A  95      50.171  24.822  42.261  1.00 25.89           O  
ATOM    725  N   GLY A  96      49.946  28.008  50.395  1.00 21.12           N  
ATOM    726  CA  GLY A  96      49.930  28.102  51.842  1.00 21.67           C  
ATOM    727  C   GLY A  96      49.360  29.375  52.428  1.00 23.12           C  
ATOM    728  O   GLY A  96      48.146  29.584  52.447  1.00 22.98           O  
ATOM    729  N   GLU A  97      50.249  30.227  52.923  1.00 24.33           N  
ATOM    730  CA  GLU A  97      49.850  31.483  53.528  1.00 25.52           C  
ATOM    731  C   GLU A  97      49.255  32.436  52.497  1.00 24.78           C  
ATOM    732  O   GLU A  97      48.773  33.513  52.841  1.00 27.34           O  
ATOM    733  CB  GLU A  97      51.055  32.121  54.224  1.00 26.66           C  
ATOM    734  CG  GLU A  97      50.770  32.529  55.668  1.00 30.97           C  
ATOM    735  CD  GLU A  97      52.025  32.674  56.523  1.00 31.48           C  
ATOM    736  OE1 GLU A  97      51.895  33.101  57.692  1.00 32.90           O  
ATOM    737  OE2 GLU A  97      53.132  32.360  56.033  1.00 30.07           O  
ATOM    738  N   GLY A  98      49.276  32.027  51.233  1.00 23.90           N  
ATOM    739  CA  GLY A  98      48.734  32.857  50.173  1.00 23.44           C  
ATOM    740  C   GLY A  98      47.290  32.568  49.786  1.00 24.50           C  
ATOM    741  O   GLY A  98      46.842  33.016  48.741  1.00 26.73           O  
ATOM    742  N   TRP A  99      46.553  31.816  50.597  1.00 23.24           N  
ATOM    743  CA  TRP A  99      45.164  31.544  50.263  1.00 21.97           C  
ATOM    744  C   TRP A  99      44.457  32.893  50.157  1.00 21.21           C  
ATOM    745  O   TRP A  99      44.922  33.886  50.711  1.00 19.30           O  
ATOM    746  CB  TRP A  99      44.497  30.681  51.342  1.00 21.81           C  
ATOM    747  CG  TRP A  99      44.481  31.297  52.714  1.00 22.07           C  
ATOM    748  CD1 TRP A  99      45.524  31.367  53.594  1.00 20.56           C  
ATOM    749  CD2 TRP A  99      43.364  31.919  53.362  1.00 21.75           C  
ATOM    750  NE1 TRP A  99      45.125  31.987  54.751  1.00 21.32           N  
ATOM    751  CE2 TRP A  99      43.803  32.340  54.637  1.00 22.37           C  
ATOM    752  CE3 TRP A  99      42.034  32.169  52.988  1.00 22.97           C  
ATOM    753  CZ2 TRP A  99      42.956  32.990  55.552  1.00 23.47           C  
ATOM    754  CZ3 TRP A  99      41.186  32.818  53.898  1.00 22.46           C  
ATOM    755  CH2 TRP A  99      41.655  33.221  55.164  1.00 22.60           C  
ATOM    756  N   ILE A 100      43.334  32.929  49.453  1.00 21.29           N  
ATOM    757  CA  ILE A 100      42.602  34.177  49.267  1.00 21.51           C  
ATOM    758  C   ILE A 100      41.304  34.221  50.072  1.00 22.27           C  
ATOM    759  O   ILE A 100      41.034  35.199  50.780  1.00 22.13           O  
ATOM    760  CB  ILE A 100      42.285  34.385  47.785  1.00 21.08           C  
ATOM    761  CG1 ILE A 100      43.549  34.130  46.956  1.00 22.13           C  
ATOM    762  CG2 ILE A 100      41.785  35.796  47.555  1.00 20.46           C  
ATOM    763  CD1 ILE A 100      43.300  34.022  45.472  1.00 22.76           C  
ATOM    764  N   PHE A 101      40.500  33.167  49.970  1.00 21.00           N  
ATOM    765  CA  PHE A 101      39.250  33.114  50.713  1.00 19.94           C  
ATOM    766  C   PHE A 101      38.810  31.690  51.073  1.00 22.01           C  
ATOM    767  O   PHE A 101      39.216  30.708  50.439  1.00 22.05           O  
ATOM    768  CB  PHE A 101      38.137  33.836  49.933  1.00 16.57           C  
ATOM    769  CG  PHE A 101      37.748  33.171  48.625  1.00 13.62           C  
ATOM    770  CD1 PHE A 101      36.847  32.112  48.603  1.00 11.67           C  
ATOM    771  CD2 PHE A 101      38.266  33.629  47.414  1.00 13.76           C  
ATOM    772  CE1 PHE A 101      36.453  31.511  47.388  1.00 12.28           C  
ATOM    773  CE2 PHE A 101      37.886  33.045  46.196  1.00 12.52           C  
ATOM    774  CZ  PHE A 101      36.973  31.977  46.186  1.00 12.64           C  
ATOM    775  N   ARG A 102      37.996  31.595  52.119  1.00 21.58           N  
ATOM    776  CA  ARG A 102      37.454  30.330  52.581  1.00 20.94           C  
ATOM    777  C   ARG A 102      36.023  30.279  52.065  1.00 21.36           C  
ATOM    778  O   ARG A 102      35.240  31.202  52.268  1.00 20.06           O  
ATOM    779  CB  ARG A 102      37.465  30.275  54.106  1.00 22.23           C  
ATOM    780  CG  ARG A 102      36.663  29.128  54.699  1.00 22.64           C  
ATOM    781  CD  ARG A 102      37.537  27.968  55.081  1.00 23.33           C  
ATOM    782  NE  ARG A 102      38.528  28.333  56.085  1.00 21.00           N  
ATOM    783  CZ  ARG A 102      39.460  27.496  56.527  1.00 19.82           C  
ATOM    784  NH1 ARG A 102      39.507  26.261  56.048  1.00 18.73           N  
ATOM    785  NH2 ARG A 102      40.344  27.890  57.433  1.00 17.64           N  
ATOM    786  N   LEU A 103      35.688  29.190  51.392  1.00 24.71           N  
ATOM    787  CA  LEU A 103      34.362  29.017  50.820  1.00 25.19           C  
ATOM    788  C   LEU A 103      33.694  27.765  51.357  1.00 25.35           C  
ATOM    789  O   LEU A 103      34.322  26.706  51.461  1.00 26.30           O  
ATOM    790  CB  LEU A 103      34.472  28.916  49.297  1.00 26.14           C  
ATOM    791  CG  LEU A 103      33.214  28.624  48.486  1.00 28.26           C  
ATOM    792  CD1 LEU A 103      32.264  29.803  48.581  1.00 26.00           C  
ATOM    793  CD2 LEU A 103      33.600  28.357  47.030  1.00 29.38           C  
ATOM    794  N   LYS A 104      32.420  27.886  51.708  1.00 24.00           N  
ATOM    795  CA  LYS A 104      31.678  26.737  52.202  1.00 23.20           C  
ATOM    796  C   LYS A 104      30.774  26.308  51.062  1.00 22.79           C  
ATOM    797  O   LYS A 104      29.869  27.040  50.683  1.00 26.94           O  
ATOM    798  CB  LYS A 104      30.841  27.110  53.429  1.00 21.36           C  
ATOM    799  CG  LYS A 104      29.858  26.035  53.835  1.00 19.86           C  
ATOM    800  CD  LYS A 104      29.144  26.366  55.130  1.00 18.98           C  
ATOM    801  CE  LYS A 104      28.062  25.336  55.427  1.00 18.20           C  
ATOM    802  NZ  LYS A 104      28.539  23.945  55.205  1.00 16.59           N  
ATOM    803  N   PRO A 105      31.023  25.125  50.480  1.00 22.62           N  
ATOM    804  CA  PRO A 105      30.207  24.623  49.371  1.00 23.55           C  
ATOM    805  C   PRO A 105      28.714  24.467  49.701  1.00 24.78           C  
ATOM    806  O   PRO A 105      28.340  24.041  50.799  1.00 23.21           O  
ATOM    807  CB  PRO A 105      30.864  23.278  49.042  1.00 21.39           C  
ATOM    808  CG  PRO A 105      32.264  23.507  49.365  1.00 19.36           C  
ATOM    809  CD  PRO A 105      32.191  24.251  50.684  1.00 22.06           C  
ATOM    810  N   ARG A 106      27.866  24.823  48.744  1.00 26.55           N  
ATOM    811  CA  ARG A 106      26.436  24.684  48.934  1.00 29.90           C  
ATOM    812  C   ARG A 106      26.192  23.195  49.068  1.00 30.87           C  
ATOM    813  O   ARG A 106      25.239  22.762  49.706  1.00 32.58           O  
ATOM    814  CB  ARG A 106      25.682  25.212  47.718  1.00 31.38           C  
ATOM    815  CG  ARG A 106      24.187  25.255  47.914  1.00 36.21           C  
ATOM    816  CD  ARG A 106      23.477  25.820  46.699  1.00 38.19           C  
ATOM    817  NE  ARG A 106      24.158  26.981  46.133  1.00 43.86           N  
ATOM    818  CZ  ARG A 106      24.614  28.020  46.831  1.00 44.95           C  
ATOM    819  NH1 ARG A 106      24.474  28.058  48.151  1.00 46.38           N  
ATOM    820  NH2 ARG A 106      25.211  29.029  46.203  1.00 45.42           N  
ATOM    821  N   ASP A 107      27.086  22.424  48.454  1.00 32.93           N  
ATOM    822  CA  ASP A 107      27.038  20.966  48.454  1.00 34.08           C  
ATOM    823  C   ASP A 107      28.422  20.387  48.122  1.00 34.29           C  
ATOM    824  O   ASP A 107      28.930  20.566  47.016  1.00 34.59           O  
ATOM    825  CB  ASP A 107      26.005  20.485  47.437  1.00 35.71           C  
ATOM    826  CG  ASP A 107      26.052  18.989  47.221  1.00 38.99           C  
ATOM    827  OD1 ASP A 107      26.530  18.270  48.130  1.00 38.62           O  
ATOM    828  OD2 ASP A 107      25.599  18.540  46.145  1.00 39.53           O  
ATOM    829  N   MET A 108      29.021  19.693  49.087  1.00 33.36           N  
ATOM    830  CA  MET A 108      30.344  19.104  48.911  1.00 32.34           C  
ATOM    831  C   MET A 108      30.500  18.255  47.649  1.00 32.07           C  
ATOM    832  O   MET A 108      31.538  18.293  46.985  1.00 31.72           O  
ATOM    833  CB  MET A 108      30.708  18.261  50.137  1.00 32.51           C  
ATOM    834  CG  MET A 108      30.852  19.054  51.418  1.00 33.37           C  
ATOM    835  SD  MET A 108      31.989  20.442  51.242  1.00 35.82           S  
ATOM    836  CE  MET A 108      33.444  19.859  52.131  1.00 35.68           C  
ATOM    837  N   GLY A 109      29.473  17.480  47.323  1.00 32.68           N  
ATOM    838  CA  GLY A 109      29.533  16.633  46.148  1.00 31.83           C  
ATOM    839  C   GLY A 109      29.985  17.373  44.905  1.00 33.06           C  
ATOM    840  O   GLY A 109      30.457  16.759  43.942  1.00 31.64           O  
ATOM    841  N   ASP A 110      29.849  18.697  44.922  1.00 33.70           N  
ATOM    842  CA  ASP A 110      30.231  19.515  43.775  1.00 33.22           C  
ATOM    843  C   ASP A 110      31.733  19.545  43.562  1.00 33.25           C  
ATOM    844  O   ASP A 110      32.196  19.736  42.440  1.00 32.57           O  
ATOM    845  CB  ASP A 110      29.703  20.944  43.939  1.00 32.06           C  
ATOM    846  CG  ASP A 110      28.187  21.005  43.974  1.00 32.36           C  
ATOM    847  OD1 ASP A 110      27.637  22.120  44.121  1.00 31.59           O  
ATOM    848  OD2 ASP A 110      27.547  19.935  43.858  1.00 31.18           O  
ATOM    849  N   LEU A 111      32.497  19.353  44.630  1.00 33.81           N  
ATOM    850  CA  LEU A 111      33.946  19.363  44.510  1.00 36.15           C  
ATOM    851  C   LEU A 111      34.389  18.209  43.631  1.00 37.90           C  
ATOM    852  O   LEU A 111      35.355  18.324  42.869  1.00 38.40           O  
ATOM    853  CB  LEU A 111      34.605  19.249  45.888  1.00 36.41           C  
ATOM    854  CG  LEU A 111      34.389  20.418  46.864  1.00 36.15           C  
ATOM    855  CD1 LEU A 111      35.220  20.183  48.121  1.00 35.03           C  
ATOM    856  CD2 LEU A 111      34.788  21.733  46.213  1.00 33.24           C  
ATOM    857  N   ASP A 112      33.657  17.103  43.728  1.00 39.78           N  
ATOM    858  CA  ASP A 112      33.958  15.902  42.961  1.00 41.21           C  
ATOM    859  C   ASP A 112      33.815  16.130  41.451  1.00 41.43           C  
ATOM    860  O   ASP A 112      33.954  15.201  40.663  1.00 41.66           O  
ATOM    861  CB  ASP A 112      33.055  14.752  43.428  1.00 43.44           C  
ATOM    862  CG  ASP A 112      33.231  14.429  44.918  1.00 46.37           C  
ATOM    863  OD1 ASP A 112      32.527  13.523  45.426  1.00 46.90           O  
ATOM    864  OD2 ASP A 112      34.071  15.077  45.584  1.00 47.21           O  
ATOM    865  N   GLU A 113      33.539  17.372  41.057  1.00 41.51           N  
ATOM    866  CA  GLU A 113      33.407  17.733  39.643  1.00 41.24           C  
ATOM    867  C   GLU A 113      34.653  18.527  39.228  1.00 39.55           C  
ATOM    868  O   GLU A 113      34.773  18.991  38.080  1.00 38.76           O  
ATOM    869  CB  GLU A 113      32.152  18.592  39.408  1.00 44.60           C  
ATOM    870  CG  GLU A 113      30.893  17.833  38.965  1.00 48.12           C  
ATOM    871  CD  GLU A 113      30.373  16.856  40.014  1.00 52.03           C  
ATOM    872  OE1 GLU A 113      30.132  17.288  41.165  1.00 53.31           O  
ATOM    873  OE2 GLU A 113      30.194  15.660  39.687  1.00 52.09           O  
ATOM    874  N   LEU A 114      35.575  18.686  40.174  1.00 34.81           N  
ATOM    875  CA  LEU A 114      36.810  19.408  39.923  1.00 29.87           C  
ATOM    876  C   LEU A 114      37.940  18.460  39.560  1.00 27.79           C  
ATOM    877  O   LEU A 114      37.765  17.242  39.556  1.00 26.28           O  
ATOM    878  CB  LEU A 114      37.181  20.230  41.149  1.00 30.14           C  
ATOM    879  CG  LEU A 114      36.149  21.320  41.451  1.00 31.18           C  
ATOM    880  CD1 LEU A 114      36.576  22.066  42.695  1.00 32.08           C  
ATOM    881  CD2 LEU A 114      36.016  22.279  40.263  1.00 28.84           C  
ATOM    882  N   LEU A 115      39.102  19.027  39.260  1.00 25.29           N  
ATOM    883  CA  LEU A 115      40.276  18.244  38.875  1.00 21.91           C  
ATOM    884  C   LEU A 115      41.204  17.923  40.041  1.00 19.57           C  
ATOM    885  O   LEU A 115      41.215  18.633  41.047  1.00 17.86           O  
ATOM    886  CB  LEU A 115      41.088  19.016  37.841  1.00 22.58           C  
ATOM    887  CG  LEU A 115      40.405  19.528  36.585  1.00 25.57           C  
ATOM    888  CD1 LEU A 115      41.369  20.460  35.851  1.00 24.79           C  
ATOM    889  CD2 LEU A 115      39.978  18.345  35.704  1.00 24.96           C  
ATOM    890  N   ASP A 116      41.985  16.856  39.900  1.00 17.97           N  
ATOM    891  CA  ASP A 116      42.963  16.516  40.923  1.00 18.75           C  
ATOM    892  C   ASP A 116      44.317  16.908  40.346  1.00 19.03           C  
ATOM    893  O   ASP A 116      44.410  17.295  39.182  1.00 18.19           O  
ATOM    894  CB  ASP A 116      42.936  15.025  41.300  1.00 19.99           C  
ATOM    895  CG  ASP A 116      43.179  14.097  40.118  1.00 23.22           C  
ATOM    896  OD1 ASP A 116      43.697  14.545  39.071  1.00 26.19           O  
ATOM    897  OD2 ASP A 116      42.856  12.899  40.249  1.00 22.25           O  
ATOM    898  N   ALA A 117      45.360  16.820  41.158  1.00 19.10           N  
ATOM    899  CA  ALA A 117      46.687  17.201  40.713  1.00 20.13           C  
ATOM    900  C   ALA A 117      47.009  16.695  39.313  1.00 21.09           C  
ATOM    901  O   ALA A 117      47.718  17.361  38.560  1.00 23.48           O  
ATOM    902  CB  ALA A 117      47.735  16.704  41.709  1.00 19.41           C  
ATOM    903  N   GLY A 118      46.488  15.521  38.970  1.00 21.21           N  
ATOM    904  CA  GLY A 118      46.749  14.942  37.665  1.00 21.13           C  
ATOM    905  C   GLY A 118      45.941  15.622  36.582  1.00 23.63           C  
ATOM    906  O   GLY A 118      46.407  15.807  35.456  1.00 22.35           O  
ATOM    907  N   GLY A 119      44.715  15.991  36.924  1.00 23.96           N  
ATOM    908  CA  GLY A 119      43.872  16.663  35.961  1.00 25.00           C  
ATOM    909  C   GLY A 119      44.429  18.032  35.624  1.00 24.86           C  
ATOM    910  O   GLY A 119      44.461  18.421  34.458  1.00 25.79           O  
ATOM    911  N   TYR A 120      44.880  18.765  36.637  1.00 23.88           N  
ATOM    912  CA  TYR A 120      45.415  20.100  36.408  1.00 23.87           C  
ATOM    913  C   TYR A 120      46.705  20.075  35.607  1.00 25.87           C  
ATOM    914  O   TYR A 120      46.956  20.967  34.790  1.00 27.15           O  
ATOM    915  CB  TYR A 120      45.658  20.819  37.726  1.00 19.53           C  
ATOM    916  CG  TYR A 120      46.157  22.234  37.538  1.00 18.21           C  
ATOM    917  CD1 TYR A 120      45.363  23.197  36.910  1.00 15.03           C  
ATOM    918  CD2 TYR A 120      47.420  22.620  37.993  1.00 14.90           C  
ATOM    919  CE1 TYR A 120      45.813  24.497  36.747  1.00 12.13           C  
ATOM    920  CE2 TYR A 120      47.873  23.919  37.832  1.00 13.19           C  
ATOM    921  CZ  TYR A 120      47.063  24.850  37.211  1.00 11.46           C  
ATOM    922  OH  TYR A 120      47.497  26.141  37.081  1.00 14.83           O  
ATOM    923  N   GLN A 121      47.531  19.064  35.855  1.00 26.85           N  
ATOM    924  CA  GLN A 121      48.787  18.917  35.134  1.00 27.58           C  
ATOM    925  C   GLN A 121      48.517  18.665  33.650  1.00 27.97           C  
ATOM    926  O   GLN A 121      49.193  19.227  32.793  1.00 28.83           O  
ATOM    927  CB  GLN A 121      49.603  17.766  35.723  1.00 27.95           C  
ATOM    928  CG  GLN A 121      50.744  17.291  34.845  1.00 30.04           C  
ATOM    929  CD  GLN A 121      51.512  16.152  35.473  1.00 31.77           C  
ATOM    930  OE1 GLN A 121      50.941  15.320  36.176  1.00 35.02           O  
ATOM    931  NE2 GLN A 121      52.808  16.095  35.211  1.00 33.41           N  
ATOM    932  N   GLU A 122      47.531  17.822  33.351  1.00 28.91           N  
ATOM    933  CA  GLU A 122      47.176  17.528  31.965  1.00 30.98           C  
ATOM    934  C   GLU A 122      46.793  18.847  31.306  1.00 30.80           C  
ATOM    935  O   GLU A 122      47.165  19.116  30.166  1.00 30.35           O  
ATOM    936  CB  GLU A 122      45.992  16.551  31.896  1.00 34.19           C  
ATOM    937  CG  GLU A 122      46.217  15.251  32.647  1.00 40.78           C  
ATOM    938  CD  GLU A 122      45.065  14.265  32.508  1.00 44.36           C  
ATOM    939  OE1 GLU A 122      43.908  14.635  32.809  1.00 46.13           O  
ATOM    940  OE2 GLU A 122      45.330  13.109  32.104  1.00 47.58           O  
ATOM    941  N   VAL A 123      46.059  19.674  32.040  1.00 30.63           N  
ATOM    942  CA  VAL A 123      45.637  20.972  31.536  1.00 32.39           C  
ATOM    943  C   VAL A 123      46.821  21.896  31.233  1.00 32.85           C  
ATOM    944  O   VAL A 123      46.847  22.563  30.197  1.00 31.39           O  
ATOM    945  CB  VAL A 123      44.694  21.677  32.542  1.00 32.82           C  
ATOM    946  CG1 VAL A 123      44.523  23.148  32.167  1.00 29.86           C  
ATOM    947  CG2 VAL A 123      43.340  20.969  32.560  1.00 31.85           C  
ATOM    948  N   LEU A 124      47.796  21.946  32.132  1.00 32.94           N  
ATOM    949  CA  LEU A 124      48.943  22.804  31.902  1.00 34.69           C  
ATOM    950  C   LEU A 124      49.754  22.286  30.730  1.00 35.28           C  
ATOM    951  O   LEU A 124      50.264  23.061  29.929  1.00 35.01           O  
ATOM    952  CB  LEU A 124      49.825  22.889  33.151  1.00 33.95           C  
ATOM    953  CG  LEU A 124      49.224  23.567  34.381  1.00 33.73           C  
ATOM    954  CD1 LEU A 124      50.340  23.804  35.401  1.00 31.01           C  
ATOM    955  CD2 LEU A 124      48.572  24.885  33.994  1.00 32.62           C  
ATOM    956  N   GLU A 125      49.876  20.969  30.632  1.00 36.67           N  
ATOM    957  CA  GLU A 125      50.620  20.371  29.539  1.00 39.11           C  
ATOM    958  C   GLU A 125      49.859  20.534  28.222  1.00 41.01           C  
ATOM    959  O   GLU A 125      50.466  20.651  27.157  1.00 42.19           O  
ATOM    960  CB  GLU A 125      50.882  18.893  29.831  1.00 37.95           C  
ATOM    961  CG  GLU A 125      51.943  18.676  30.899  1.00 39.59           C  
ATOM    962  CD  GLU A 125      52.109  17.218  31.291  1.00 40.56           C  
ATOM    963  OE1 GLU A 125      53.087  16.903  32.004  1.00 38.66           O  
ATOM    964  OE2 GLU A 125      51.259  16.391  30.897  1.00 42.90           O  
ATOM    965  N   SER A 126      48.531  20.566  28.303  1.00 41.60           N  
ATOM    966  CA  SER A 126      47.695  20.715  27.120  1.00 42.86           C  
ATOM    967  C   SER A 126      47.855  22.095  26.492  1.00 43.89           C  
ATOM    968  O   SER A 126      47.828  22.235  25.272  1.00 44.67           O  
ATOM    969  CB  SER A 126      46.221  20.495  27.474  1.00 43.59           C  
ATOM    970  OG  SER A 126      45.699  21.578  28.231  1.00 44.09           O  
ATOM    971  N   GLU A 127      48.016  23.114  27.325  1.00 45.00           N  
ATOM    972  CA  GLU A 127      48.165  24.471  26.828  1.00 46.91           C  
ATOM    973  C   GLU A 127      49.609  24.975  26.766  1.00 47.83           C  
ATOM    974  O   GLU A 127      49.853  26.152  26.503  1.00 47.26           O  
ATOM    975  CB  GLU A 127      47.315  25.423  27.671  1.00 47.99           C  
ATOM    976  CG  GLU A 127      47.374  25.175  29.164  1.00 48.93           C  
ATOM    977  CD  GLU A 127      46.482  26.127  29.935  1.00 49.28           C  
ATOM    978  OE1 GLU A 127      46.891  27.287  30.147  1.00 50.18           O  
ATOM    979  OE2 GLU A 127      45.362  25.721  30.316  1.00 49.24           O  
ATOM    980  N   ALA A 128      50.566  24.082  26.994  1.00 49.41           N  
ATOM    981  CA  ALA A 128      51.972  24.465  26.951  1.00 51.26           C  
ATOM    982  C   ALA A 128      52.370  24.948  25.556  1.00 51.98           C  
ATOM    983  O   ALA A 128      51.539  24.834  24.630  1.00 52.13           O  
ATOM    984  CB  ALA A 128      52.847  23.283  27.364  1.00 50.87           C  
ATOM    985  OXT ALA A 128      53.513  25.429  25.404  1.00 53.73           O  
TER     986      ALA A 128                                                      
END
MOLECULE T0397_83_150.pdb
ATOM    717  N   LEU    83      35.835  21.935  54.102  1.00 33.12          
ATOM    718  CA  LEU    83      35.719  23.282  53.561  1.00 33.32          
ATOM    719  C   LEU    83      36.582  23.427  52.306  1.00 32.66          
ATOM    720  O   LEU    83      37.427  22.578  52.030  1.00 33.17          
ATOM    721  CB  LEU    83      36.184  24.314  54.588  1.00 33.05          
ATOM    722  CG  LEU    83      35.428  24.389  55.909  1.00 34.55          
ATOM    723  CD1 LEU    83      36.110  25.424  56.813  1.00 31.53          
ATOM    724  CD2 LEU    83      33.926  24.720  55.714  1.00 33.95          
ATOM    725  N   ILE    84      36.339  24.487  51.547  1.00 31.28          
ATOM    726  CA  ILE    84      37.113  24.815  50.390  1.00 31.86          
ATOM    727  C   ILE    84      37.899  26.128  50.688  1.00 31.86          
ATOM    728  O   ILE    84      37.374  27.068  51.262  1.00 30.84          
ATOM    729  CB  ILE    84      36.211  24.884  49.102  1.00 33.01          
ATOM    730  CG1 ILE    84      35.635  23.481  48.828  1.00 32.64          
ATOM    731  CG2 ILE    84      37.046  25.413  47.910  1.00 32.85          
ATOM    732  CD  ILE    84      34.896  23.257  47.596  1.00 34.41          
ATOM    733  N   SER    85      39.183  26.115  50.391  1.00 31.66          
ATOM    734  CA  SER    85      40.056  27.270  50.558  1.00 32.45          
ATOM    735  C   SER    85      40.379  27.753  49.179  1.00 30.88          
ATOM    736  O   SER    85      40.777  26.974  48.349  1.00 28.90          
ATOM    737  CB  SER    85      41.345  26.854  51.252  1.00 33.29          
ATOM    738  OG  SER    85      41.047  26.245  52.505  1.00 38.38          
ATOM    739  N   VAL    86      40.161  29.032  48.922  1.00 30.89          
ATOM    740  CA  VAL    86      40.406  29.618  47.617  1.00 30.18          
ATOM    741  C   VAL    86      41.432  30.751  47.751  1.00 30.50          
ATOM    742  O   VAL    86      41.128  31.827  48.263  1.00 29.45          
ATOM    743  CB  VAL    86      39.090  30.166  47.031  1.00 31.39          
ATOM    744  CG1 VAL    86      39.278  30.554  45.537  1.00 30.79          
ATOM    745  CG2 VAL    86      37.974  29.150  47.205  1.00 29.24          
ATOM    746  N   PRO    87      42.702  30.485  47.366  1.00 31.49          
ATOM    747  CA  PRO    87      43.702  31.557  47.420  1.00 30.98          
ATOM    748  C   PRO    87      43.541  32.615  46.290  1.00 30.90          
ATOM    749  O   PRO    87      43.077  32.315  45.202  1.00 29.79          
ATOM    750  CB  PRO    87      45.028  30.825  47.303  1.00 31.58          
ATOM    751  CG  PRO    87      44.693  29.422  46.847  1.00 32.96          
ATOM    752  CD  PRO    87      43.240  29.210  46.879  1.00 30.77          
ATOM    753  N   ALA    88      43.890  33.849  46.619  1.00 31.20          
ATOM    754  CA  ALA    88      43.874  34.986  45.725  1.00 31.18          
ATOM    755  C   ALA    88      45.284  35.570  45.884  1.00 31.56          
ATOM    756  O   ALA    88      45.555  36.263  46.864  1.00 31.99          
ATOM    757  CB  ALA    88      42.823  35.984  46.165  1.00 29.82          
ATOM    758  N   GLU    89      46.181  35.230  44.957  1.00 31.39          
ATOM    759  CA  GLU    89      47.591  35.660  44.994  1.00 31.91          
ATOM    760  C   GLU    89      48.000  36.444  43.779  1.00 31.08          
ATOM    761  O   GLU    89      47.752  36.021  42.661  1.00 32.28          
ATOM    762  CB  GLU    89      48.493  34.426  45.011  1.00 32.34          
ATOM    763  CG  GLU    89      48.251  33.502  46.184  1.00 35.65          
ATOM    764  CD  GLU    89      49.120  32.295  46.110  1.00 41.85          
ATOM    765  OE1 GLU    89      49.575  31.939  44.988  1.00 42.45          
ATOM    766  OE2 GLU    89      49.398  31.740  47.195  1.00 48.31          
ATOM    767  N   GLY    90      48.688  37.552  43.997  1.00 30.77          
ATOM    768  CA  GLY    90      49.163  38.409  42.917  1.00 30.21          
ATOM    769  C   GLY    90      49.928  39.585  43.484  1.00 30.04          
ATOM    770  O   GLY    90      49.980  39.771  44.709  1.00 30.76          
ATOM    771  N   TYR    91      50.541  40.360  42.604  1.00 29.01          
ATOM    772  CA  TYR    91      51.260  41.582  42.987  1.00 29.19          
ATOM    773  C   TYR    91      50.355  42.462  43.856  1.00 27.98          
ATOM    774  O   TYR    91      50.755  42.867  44.940  1.00 26.97          
ATOM    775  CB  TYR    91      51.788  42.315  41.750  1.00 28.63          
ATOM    776  CG  TYR    91      52.460  43.646  42.050  1.00 29.43          
ATOM    777  CD1 TYR    91      53.695  43.705  42.695  1.00 28.96          
ATOM    778  CD2 TYR    91      51.863  44.835  41.655  1.00 26.65          
ATOM    779  CE1 TYR    91      54.291  44.931  42.967  1.00 30.76          
ATOM    780  CE2 TYR    91      52.430  46.032  41.907  1.00 29.47          
ATOM    781  CZ  TYR    91      53.652  46.099  42.553  1.00 30.46          
ATOM    782  OH  TYR    91      54.196  47.339  42.759  1.00 29.11          
ATOM    783  N   LYS    92      49.133  42.689  43.373  1.00 27.98          
ATOM    784  CA  LYS    92      48.065  43.394  44.107  1.00 27.98          
ATOM    785  C   LYS    92      46.799  42.550  43.968  1.00 28.43          
ATOM    786  O   LYS    92      46.511  41.996  42.886  1.00 28.52          
ATOM    787  CB  LYS    92      47.799  44.807  43.567  1.00 28.07          
ATOM    788  CG  LYS    92      48.955  45.746  43.679  1.00 28.03          
ATOM    789  CD  LYS    92      48.737  47.040  42.914  1.00 28.62          
ATOM    790  CE  LYS    92      47.732  47.975  43.550  1.00 28.71          
ATOM    791  NZ  LYS    92      47.496  49.146  42.668  1.00 27.15          
ATOM    792  N   VAL    93      46.070  42.427  45.066  1.00 28.48          
ATOM    793  CA  VAL    93      44.861  41.611  45.110  1.00 28.35          
ATOM    794  C   VAL    93      43.738  42.456  45.613  1.00 28.50          
ATOM    795  O   VAL    93      43.891  43.173  46.603  1.00 28.44          
ATOM    796  CB  VAL    93      45.008  40.312  46.011  1.00 28.74          
ATOM    797  CG1 VAL    93      43.660  39.491  46.023  1.00 25.37          
ATOM    798  CG2 VAL    93      46.221  39.458  45.555  1.00 25.20          
ATOM    799  N   TYR    94      42.629  42.403  44.882  1.00 29.53          
ATOM    800  CA  TYR    94      41.404  43.147  45.179  1.00 29.93          
ATOM    801  C   TYR    94      40.300  42.124  45.422  1.00 29.26          
ATOM    802  O   TYR    94      39.606  41.728  44.531  1.00 29.00          
ATOM    803  CB  TYR    94      41.016  44.039  44.004  1.00 30.51          
ATOM    804  CG  TYR    94      42.016  45.110  43.674  1.00 31.04          
ATOM    805  CD1 TYR    94      41.983  46.336  44.320  1.00 30.17          
ATOM    806  CD2 TYR    94      42.999  44.891  42.701  1.00 30.58          
ATOM    807  CE1 TYR    94      42.912  47.327  44.017  1.00 30.75          
ATOM    808  CE2 TYR    94      43.917  45.847  42.398  1.00 31.08          
ATOM    809  CZ  TYR    94      43.877  47.079  43.045  1.00 33.26          
ATOM    810  OH  TYR    94      44.823  48.055  42.712  1.00 32.99          
ATOM    811  N   PRO    95      40.130  41.718  46.663  1.00 29.25          
ATOM    812  CA  PRO    95      39.185  40.737  46.999  1.00 29.79          
ATOM    813  C   PRO    95      37.842  41.315  47.422  1.00 30.52          
ATOM    814  O   PRO    95      37.770  42.473  47.786  1.00 29.82          
ATOM    815  CB  PRO    95      39.847  40.112  48.241  1.00 29.66          
ATOM    816  CG  PRO    95      40.385  41.315  48.942  1.00 28.17          
ATOM    817  CD  PRO    95      40.868  42.182  47.851  1.00 28.68          
ATOM    818  N   ILE    96      36.786  40.514  47.319  1.00 31.49          
ATOM    819  CA  ILE    96      35.486  40.905  47.859  0.50 31.87          
ATOM    821  C   ILE    96      35.675  40.903  49.385  1.00 32.49          
ATOM    822  O   ILE    96      36.019  39.877  49.980  1.00 31.70          
ATOM    823  CB  ILE    96      34.369  39.925  47.482  0.50 31.46          
ATOM    825  CG1 ILE    96      34.142  39.906  45.963  0.50 31.53          
ATOM    827  CG2 ILE    96      33.082  40.292  48.190  0.50 32.32          
ATOM    829  CD  ILE    96      33.676  41.217  45.363  0.50 27.56          
ATOM    831  N   MET    97      35.476  42.060  49.996  1.00 33.47          
ATOM    832  CA  MET    97      35.648  42.267  51.416  0.60 36.42          
ATOM    834  C   MET    97      34.295  42.009  52.082  1.00 33.49          
ATOM    835  O   MET    97      33.612  42.948  52.393  1.00 33.78          
ATOM    836  CB  MET    97      36.063  43.731  51.622  0.60 36.40          
ATOM    838  CG  MET    97      37.206  44.211  50.698  0.60 40.39          
ATOM    840  SD  MET    97      37.422  46.188  50.408  0.48 46.95          
ATOM    842  CE  MET    97      35.833  46.788  49.386  0.60 41.22          
ATOM    844  N   ASP    98      33.891  40.757  52.252  1.00 32.35          
ATOM    845  CA  ASP    98      32.579  40.482  52.802  1.00 32.10          
ATOM    846  C   ASP    98      32.580  39.078  53.350  1.00 30.95          
ATOM    847  O   ASP    98      33.521  38.336  53.109  1.00 31.18          
ATOM    848  CB  ASP    98      31.498  40.707  51.709  1.00 32.01          
ATOM    849  CG  ASP    98      30.106  40.961  52.283  1.00 33.32          
ATOM    850  OD1 ASP    98      29.907  40.894  53.519  1.00 35.35          
ATOM    851  OD2 ASP    98      29.201  41.265  51.493  1.00 33.61          
ATOM    852  N   PHE    99      31.514  38.719  54.066  1.00 30.94          
ATOM    853  CA  PHE    99      31.442  37.443  54.766  1.00 31.08          
ATOM    854  C   PHE    99      30.036  36.931  54.775  1.00 30.94          
ATOM    855  O   PHE    99      29.111  37.697  54.945  1.00 31.23          
ATOM    856  CB  PHE    99      31.855  37.614  56.263  1.00 30.83          
ATOM    857  CG  PHE    99      33.071  38.416  56.462  1.00 30.89          
ATOM    858  CD1 PHE    99      32.985  39.818  56.579  1.00 31.04          
ATOM    859  CD2 PHE    99      34.318  37.816  56.491  1.00 30.92          
ATOM    860  CE1 PHE    99      34.105  40.582  56.705  1.00 29.76          
ATOM    861  CE2 PHE    99      35.470  38.595  56.658  1.00 31.42          
ATOM    862  CZ  PHE    99      35.361  39.963  56.786  1.00 30.91          
ATOM    863  N   GLY   100      29.887  35.616  54.682  1.00 31.37          
ATOM    864  CA  GLY   100      28.591  34.973  54.808  1.00 31.40          
ATOM    865  C   GLY   100      27.667  35.250  53.645  1.00 31.50          
ATOM    866  O   GLY   100      26.492  35.490  53.835  1.00 32.03          
ATOM    867  N   PHE   101      28.199  35.166  52.431  1.00 30.55          
ATOM    868  CA  PHE   101      27.413  35.397  51.253  1.00 30.28          
ATOM    869  C   PHE   101      27.459  34.184  50.363  1.00 29.34          
ATOM    870  O   PHE   101      28.464  33.516  50.257  1.00 28.31          
ATOM    871  CB  PHE   101      27.845  36.675  50.529  1.00 29.24          
ATOM    872  CG  PHE   101      29.285  36.679  50.080  1.00 30.50          
ATOM    873  CD1 PHE   101      29.620  36.396  48.760  1.00 30.99          
ATOM    874  CD2 PHE   101      30.289  37.040  50.939  1.00 30.32          
ATOM    875  CE1 PHE   101      30.890  36.445  48.331  1.00 27.52          
ATOM    876  CE2 PHE   101      31.560  37.069  50.519  1.00 29.34          
ATOM    877  CZ  PHE   101      31.870  36.751  49.207  1.00 31.56          
ATOM    878  N   ARG   102      26.302  33.886  49.789  1.00 29.69          
ATOM    879  CA  ARG   102      26.146  32.804  48.868  1.00 29.70          
ATOM    880  C   ARG   102      26.595  33.238  47.449  1.00 29.72          
ATOM    881  O   ARG   102      26.510  34.415  47.053  1.00 30.28          
ATOM    882  CB  ARG   102      24.703  32.350  48.911  1.00 30.29          
ATOM    883  CG  ARG   102      24.413  31.126  48.107  1.00 30.83          
ATOM    884  CD  ARG   102      23.204  30.401  48.607  1.00 32.50          
ATOM    885  NE  ARG   102      22.898  29.317  47.683  1.00 33.96          
ATOM    886  CZ  ARG   102      22.165  29.443  46.589  1.00 36.08          
ATOM    887  NH1 ARG   102      21.621  30.608  46.257  1.00 37.22          
ATOM    888  NH2 ARG   102      21.952  28.384  45.817  1.00 38.60          
ATOM    889  N   VAL   103      27.151  32.267  46.724  1.00 29.73          
ATOM    890  CA  VAL   103      27.673  32.452  45.381  1.00 28.43          
ATOM    891  C   VAL   103      27.395  31.182  44.602  1.00 28.35          
ATOM    892  O   VAL   103      27.155  30.120  45.201  1.00 29.10          
ATOM    893  CB  VAL   103      29.220  32.663  45.375  1.00 29.57          
ATOM    894  CG1 VAL   103      29.684  33.944  46.197  1.00 25.27          
ATOM    895  CG2 VAL   103      29.943  31.382  45.828  1.00 27.50          
ATOM    896  N   LEU   104      27.399  31.290  43.277  1.00 27.46          
ATOM    897  CA  LEU   104      27.326  30.149  42.402  1.00 27.49          
ATOM    898  C   LEU   104      28.722  29.996  41.808  1.00 27.61          
ATOM    899  O   LEU   104      29.482  30.950  41.734  1.00 27.73          
ATOM    900  CB  LEU   104      26.306  30.314  41.269  1.00 27.73          
ATOM    901  CG  LEU   104      24.808  30.462  41.607  1.00 29.77          
ATOM    902  CD1 LEU   104      23.965  30.684  40.342  1.00 25.73          
ATOM    903  CD2 LEU   104      24.249  29.273  42.470  1.00 31.65          
ATOM    904  N   LYS   105      29.048  28.781  41.392  1.00 28.03          
ATOM    905  CA  LYS   105      30.311  28.459  40.746  1.00 28.18          
ATOM    906  C   LYS   105      30.597  29.432  39.618  1.00 27.83          
ATOM    907  O   LYS   105      29.753  29.661  38.739  1.00 27.59          
ATOM    908  CB  LYS   105      30.200  27.021  40.168  1.00 28.45          
ATOM    909  CG  LYS   105      31.380  26.551  39.395  1.00 30.45          
ATOM    910  CD  LYS   105      31.381  25.043  39.324  1.00 35.24          
ATOM    911  CE  LYS   105      32.578  24.465  38.580  1.00 38.56          
ATOM    912  NZ  LYS   105      32.346  24.168  37.154  1.00 40.94          
ATOM    913  N   GLY   106      31.791  29.999  39.629  1.00 27.43          
ATOM    914  CA  GLY   106      32.174  30.950  38.620  1.00 27.72          
ATOM    915  C   GLY   106      32.108  32.395  39.084  1.00 28.48          
ATOM    916  O   GLY   106      32.655  33.238  38.443  1.00 29.66          
ATOM    917  N   TYR   107      31.426  32.661  40.185  1.00 29.11          
ATOM    918  CA  TYR   107      31.336  33.998  40.775  1.00 30.38          
ATOM    919  C   TYR   107      32.745  34.570  41.056  1.00 30.20          
ATOM    920  O   TYR   107      33.594  33.884  41.596  1.00 29.79          
ATOM    921  CB  TYR   107      30.529  33.897  42.076  1.00 30.84          
ATOM    922  CG  TYR   107      30.172  35.178  42.775  1.00 30.61          
ATOM    923  CD1 TYR   107      31.062  35.798  43.646  1.00 29.64          
ATOM    924  CD2 TYR   107      28.896  35.705  42.665  1.00 30.62          
ATOM    925  CE1 TYR   107      30.718  36.969  44.305  1.00 33.41          
ATOM    926  CE2 TYR   107      28.543  36.850  43.325  1.00 33.62          
ATOM    927  CZ  TYR   107      29.454  37.486  44.145  1.00 34.42          
ATOM    928  OH  TYR   107      29.081  38.628  44.811  1.00 35.85          
ATOM    929  N   ARG   108      32.970  35.823  40.679  1.00 28.91          
ATOM    930  CA  ARG   108      34.264  36.453  40.890  1.00 30.07          
ATOM    931  C   ARG   108      34.493  36.891  42.361  1.00 29.95          
ATOM    932  O   ARG   108      33.747  37.702  42.894  1.00 30.55          
ATOM    933  CB  ARG   108      34.382  37.666  39.973  1.00 29.73          
ATOM    934  CG  ARG   108      35.738  38.344  40.010  1.00 30.04          
ATOM    935  CD  ARG   108      35.685  39.608  39.168  1.00 29.75          
ATOM    936  NE  ARG   108      35.655  39.296  37.739  1.00 31.85          
ATOM    937  CZ  ARG   108      35.598  40.209  36.777  1.00 30.58          
ATOM    938  NH1 ARG   108      35.534  41.488  37.066  1.00 29.91          
ATOM    939  NH2 ARG   108      35.587  39.834  35.529  1.00 31.01          
ATOM    940  N   LEU   109      35.531  36.346  42.978  1.00 28.92          
ATOM    941  CA  LEU   109      35.884  36.639  44.349  1.00 28.66          
ATOM    942  C   LEU   109      37.000  37.670  44.473  1.00 28.99          
ATOM    943  O   LEU   109      37.064  38.378  45.491  1.00 29.94          
ATOM    944  CB  LEU   109      36.297  35.361  45.084  1.00 28.34          
ATOM    945  CG  LEU   109      35.269  34.228  45.135  1.00 28.28          
ATOM    946  CD1 LEU   109      35.870  32.903  45.615  1.00 24.20          
ATOM    947  CD2 LEU   109      34.070  34.624  45.978  1.00 26.32          
ATOM    948  N   ALA   110      37.869  37.755  43.460  1.00 28.72          
ATOM    949  CA  ALA   110      38.972  38.673  43.486  1.00 28.85          
ATOM    950  C   ALA   110      39.487  38.973  42.092  1.00 28.20          
ATOM    951  O   ALA   110      39.349  38.165  41.182  1.00 28.69          
ATOM    952  CB  ALA   110      40.125  38.115  44.374  1.00 27.48          
ATOM    953  N   THR   111      40.053  40.168  41.955  1.00 28.00          
ATOM    954  CA  THR   111      40.796  40.619  40.767  1.00 27.96          
ATOM    955  C   THR   111      42.250  40.653  41.184  1.00 28.47          
ATOM    956  O   THR   111      42.573  41.096  42.288  1.00 28.25          
ATOM    957  CB  THR   111      40.370  42.000  40.317  1.00 28.12          
ATOM    958  OG1 THR   111      39.035  41.937  39.833  1.00 27.47          
ATOM    959  CG2 THR   111      41.266  42.562  39.207  1.00 27.78          
ATOM    960  N   LEU   112      43.133  40.139  40.336  1.00 29.31          
ATOM    961  CA  LEU   112      44.559  40.173  40.619  1.00 29.41          
ATOM    962  C   LEU   112      45.197  41.104  39.589  1.00 29.94          
ATOM    963  O   LEU   112      44.933  40.958  38.424  1.00 29.91          
ATOM    964  CB  LEU   112      45.180  38.782  40.491  1.00 30.01          
ATOM    965  CG  LEU   112      44.437  37.607  41.127  1.00 29.77          
ATOM    966  CD1 LEU   112      45.066  36.279  40.711  1.00 28.80          
ATOM    967  CD2 LEU   112      44.441  37.747  42.621  1.00 26.63          
ATOM    968  N   GLU   113      46.051  42.033  40.033  1.00 29.49          
ATOM    969  CA  GLU   113      46.730  42.979  39.160  1.00 29.48          
ATOM    970  C   GLU   113      48.231  42.744  39.255  1.00 29.28          
ATOM    971  O   GLU   113      48.794  42.656  40.343  1.00 27.97          
ATOM    972  CB  GLU   113      46.408  44.410  39.573  1.00 29.28          
ATOM    973  CG  GLU   113      46.978  45.490  38.687  1.00 31.66          
ATOM    974  CD  GLU   113      46.898  46.858  39.331  1.00 32.90          
ATOM    975  OE1 GLU   113      46.454  46.975  40.501  1.00 37.77          
ATOM    976  OE2 GLU   113      47.260  47.818  38.662  1.00 31.95          
ATOM    977  N   SER   114      48.871  42.632  38.098  1.00 29.97          
ATOM    978  CA  SER   114      50.300  42.391  38.042  1.00 30.52          
ATOM    979  C   SER   114      51.067  43.720  38.159  1.00 31.36          
ATOM    980  O   SER   114      50.469  44.799  38.086  1.00 31.23          
ATOM    981  CB  SER   114      50.670  41.689  36.722  1.00 30.65          
ATOM    982  OG  SER   114      50.747  42.605  35.639  1.00 30.72          
ATOM    983  N   LYS   115      52.390  43.608  38.282  1.00 31.74          
ATOM    984  CA  LYS   115      53.277  44.780  38.418  0.50 32.12          
ATOM    986  C   LYS   115      53.106  45.728  37.235  1.00 32.17          
ATOM    987  O   LYS   115      53.249  46.928  37.387  1.00 32.06          
ATOM    988  CB  LYS   115      54.752  44.347  38.577  0.50 31.97          
ATOM    990  CG  LYS   115      55.801  45.478  38.696  0.50 32.47          
ATOM    992  CD  LYS   115      55.729  46.251  40.024  0.50 32.71          
ATOM    994  CE  LYS   115      56.780  47.354  40.124  0.50 31.77          
ATOM    996  NZ  LYS   115      58.161  46.820  40.231  0.50 31.98          
ATOM    998  N   LYS   116      52.762  45.188  36.068  1.00 32.06          
ATOM    999  CA  LYS   116      52.553  45.980  34.858  1.00 32.15          
ATOM   1000  C   LYS   116      51.082  46.217  34.499  1.00 31.72          
ATOM   1001  O   LYS   116      50.784  46.647  33.385  1.00 31.63          
ATOM   1002  CB  LYS   116      53.342  45.372  33.666  1.00 32.29          
ATOM   1003  CG  LYS   116      54.850  45.627  33.743  1.00 32.32          
ATOM   1004  N   GLY   117      50.170  45.944  35.442  1.00 32.17          
ATOM   1005  CA  GLY   117      48.743  46.219  35.266  1.00 31.65          
ATOM   1006  C   GLY   117      47.889  45.171  34.583  1.00 32.02          
ATOM   1007  O   GLY   117      46.760  45.448  34.209  1.00 30.89          
ATOM   1008  N   ASP   118      48.425  43.977  34.386  1.00 33.07          
ATOM   1009  CA  ASP   118      47.646  42.886  33.802  1.00 33.69          
ATOM   1010  C   ASP   118      46.676  42.350  34.856  1.00 33.47          
ATOM   1011  O   ASP   118      47.048  42.171  36.024  1.00 33.70          
ATOM   1012  CB  ASP   118      48.564  41.756  33.373  1.00 34.70          
ATOM   1013  CG  ASP   118      49.562  42.169  32.288  1.00 36.13          
ATOM   1014  OD1 ASP   118      49.170  42.849  31.305  1.00 37.08          
ATOM   1015  OD2 ASP   118      50.738  41.765  32.428  1.00 38.14          
ATOM   1016  N   LEU   119      45.440  42.100  34.446  1.00 33.09          
ATOM   1017  CA  LEU   119      44.387  41.617  35.344  1.00 33.04          
ATOM   1018  C   LEU   119      44.009  40.149  35.114  1.00 32.88          
ATOM   1019  O   LEU   119      43.837  39.749  33.997  1.00 33.07          
ATOM   1020  CB  LEU   119      43.134  42.462  35.134  1.00 32.71          
ATOM   1021  CG  LEU   119      43.311  43.951  35.413  1.00 32.71          
ATOM   1022  CD1 LEU   119      42.062  44.678  35.032  1.00 32.27          
ATOM   1023  CD2 LEU   119      43.657  44.206  36.868  1.00 30.21          
ATOM   1024  N   ARG   120      43.908  39.376  36.185  1.00 32.63          
ATOM   1025  CA  ARG   120      43.437  37.998  36.158  1.00 33.15          
ATOM   1026  C   ARG   120      42.375  37.965  37.238  1.00 31.39          
ATOM   1027  O   ARG   120      42.294  38.887  38.054  1.00 31.30          
ATOM   1028  CB  ARG   120      44.544  36.988  36.469  1.00 32.65          
ATOM   1029  CG  ARG   120      45.616  36.885  35.399  1.00 35.91          
ATOM   1030  CD  ARG   120      46.797  35.979  35.783  1.00 38.66          
ATOM   1031  NE  ARG   120      47.527  36.434  36.987  1.00 44.57          
ATOM   1032  CZ  ARG   120      47.667  35.764  38.145  1.00 48.21          
ATOM   1033  NH1 ARG   120      47.168  34.512  38.324  1.00 51.17          
ATOM   1034  NH2 ARG   120      48.348  36.352  39.150  1.00 47.05          
ATOM   1035  N   TYR   121      41.566  36.910  37.257  1.00 30.65          
ATOM   1036  CA  TYR   121      40.498  36.770  38.232  1.00 29.52          
ATOM   1037  C   TYR   121      40.497  35.450  38.994  1.00 29.31          
ATOM   1038  O   TYR   121      40.944  34.430  38.500  1.00 29.67          
ATOM   1039  CB  TYR   121      39.178  36.955  37.531  1.00 29.22          
ATOM   1040  CG  TYR   121      39.180  38.215  36.761  1.00 30.47          
ATOM   1041  CD1 TYR   121      39.085  39.443  37.402  1.00 30.72          
ATOM   1042  CD2 TYR   121      39.357  38.208  35.399  1.00 31.47          
ATOM   1043  CE1 TYR   121      39.132  40.632  36.696  1.00 31.64          
ATOM   1044  CE2 TYR   121      39.419  39.404  34.685  1.00 32.50          
ATOM   1045  CZ  TYR   121      39.298  40.601  35.341  1.00 31.18          
ATOM   1046  OH  TYR   121      39.327  41.770  34.623  1.00 32.27          
ATOM   1047  N   VAL   122      39.991  35.502  40.220  1.00 28.84          
ATOM   1048  CA  VAL   122      39.818  34.333  41.077  1.00 28.57          
ATOM   1049  C   VAL   122      38.327  34.177  41.193  1.00 28.66          
ATOM   1050  O   VAL   122      37.629  35.069  41.675  1.00 27.80          
ATOM   1051  CB  VAL   122      40.446  34.528  42.440  1.00 28.46          
ATOM   1052  CG1 VAL   122      40.099  33.331  43.394  1.00 28.10          
ATOM   1053  CG2 VAL   122      41.995  34.756  42.248  1.00 28.42          
ATOM   1054  N   ASN   123      37.832  33.056  40.700  1.00 28.86          
ATOM   1055  CA  ASN   123      36.408  32.774  40.695  1.00 28.39          
ATOM   1056  C   ASN   123      36.123  31.648  41.616  1.00 28.56          
ATOM   1057  O   ASN   123      36.984  30.826  41.818  1.00 27.87          
ATOM   1058  CB  ASN   123      35.956  32.381  39.304  1.00 29.33          
ATOM   1059  CG  ASN   123      36.182  33.462  38.296  1.00 27.62          
ATOM   1060  OD1 ASN   123      35.988  34.628  38.564  1.00 32.47          
ATOM   1061  ND2 ASN   123      36.597  33.082  37.147  1.00 27.51          
ATOM   1062  N   SER   124      34.899  31.611  42.167  1.00 28.33          
ATOM   1063  CA  SER   124      34.486  30.526  43.025  1.00 28.38          
ATOM   1064  C   SER   124      34.494  29.189  42.288  1.00 28.59          
ATOM   1065  O   SER   124      33.860  29.067  41.234  1.00 27.48          
ATOM   1066  CB  SER   124      33.062  30.755  43.529  1.00 28.74          
ATOM   1067  OG  SER   124      32.815  29.870  44.572  1.00 24.63          
ATOM   1068  N   PRO   125      35.180  28.165  42.855  1.00 29.27          
ATOM   1069  CA  PRO   125      35.201  26.860  42.239  1.00 29.34          
ATOM   1070  C   PRO   125      33.907  26.060  42.416  1.00 29.48          
ATOM   1071  O   PRO   125      33.727  25.061  41.755  1.00 29.83          
ATOM   1072  CB  PRO   125      36.341  26.161  42.996  1.00 29.36          
ATOM   1073  CG  PRO   125      36.282  26.701  44.298  1.00 29.22          
ATOM   1074  CD  PRO   125      35.932  28.152  44.118  1.00 29.39          
ATOM   1075  N   VAL   126      33.029  26.483  43.331  1.00 30.06          
ATOM   1076  CA  VAL   126      31.809  25.778  43.631  1.00 29.39          
ATOM   1077  C   VAL   126      30.714  26.751  43.999  1.00 29.93          
ATOM   1078  O   VAL   126      30.942  27.936  44.183  1.00 30.98          
ATOM   1079  CB  VAL   126      31.997  24.820  44.859  1.00 30.07          
ATOM   1080  CG1 VAL   126      33.004  23.721  44.563  1.00 29.26          
ATOM   1081  CG2 VAL   126      32.403  25.597  46.126  1.00 28.09          
ATOM   1082  N   SER   127      29.512  26.226  44.085  1.00 29.28          
ATOM   1083  CA  SER   127      28.373  26.936  44.581  1.00 29.29          
ATOM   1084  C   SER   127      28.286  26.666  46.084  1.00 28.40          
ATOM   1085  O   SER   127      28.467  25.564  46.540  1.00 28.74          
ATOM   1086  CB  SER   127      27.103  26.448  43.880  1.00 28.97          
ATOM   1087  OG  SER   127      27.121  26.809  42.521  1.00 30.47          
ATOM   1088  N   GLY   128      27.994  27.692  46.865  1.00 29.10          
ATOM   1089  CA  GLY   128      27.890  27.524  48.307  1.00 28.32          
ATOM   1090  C   GLY   128      28.029  28.842  48.967  1.00 27.81          
ATOM   1091  O   GLY   128      27.764  29.826  48.359  1.00 28.32          
ATOM   1092  N   THR   129      28.516  28.851  50.197  1.00 28.38          
ATOM   1093  CA  THR   129      28.600  30.051  51.013  1.00 29.02          
ATOM   1094  C   THR   129      30.052  30.413  51.333  1.00 28.70          
ATOM   1095  O   THR   129      30.805  29.569  51.724  1.00 28.95          
ATOM   1096  CB  THR   129      27.871  29.820  52.367  1.00 29.10          
ATOM   1097  OG1 THR   129      26.538  29.280  52.147  1.00 28.63          
ATOM   1098  CG2 THR   129      27.797  31.113  53.170  1.00 26.94          
ATOM   1099  N   VAL   130      30.430  31.660  51.140  1.00 29.17          
ATOM   1100  CA  VAL   130      31.739  32.131  51.531  1.00 30.48          
ATOM   1101  C   VAL   130      31.538  32.462  52.984  1.00 30.69          
ATOM   1102  O   VAL   130      30.805  33.349  53.295  1.00 31.50          
ATOM   1103  CB  VAL   130      32.204  33.394  50.734  1.00 30.60          
ATOM   1104  CG1 VAL   130      33.557  33.925  51.266  1.00 29.82          
ATOM   1105  CG2 VAL   130      32.300  33.086  49.283  1.00 30.63          
ATOM   1106  N   ILE   131      32.216  31.747  53.861  1.00 32.65          
ATOM   1107  CA  ILE   131      32.070  31.890  55.295  1.00 33.61          
ATOM   1108  C   ILE   131      33.073  32.881  55.895  1.00 33.47          
ATOM   1109  O   ILE   131      32.757  33.594  56.835  1.00 34.54          
ATOM   1110  CB  ILE   131      32.058  30.469  56.003  1.00 34.99          
ATOM   1111  CG1 ILE   131      33.407  29.769  55.988  1.00 37.35          
ATOM   1112  CG2 ILE   131      31.005  29.503  55.369  1.00 32.31          
ATOM   1113  CD  ILE   131      33.339  28.349  56.558  1.00 36.05          
ATOM   1114  N   PHE   132      34.257  33.000  55.318  1.00 33.54          
ATOM   1115  CA  PHE   132      35.248  33.929  55.843  1.00 33.34          
ATOM   1116  C   PHE   132      36.238  34.235  54.771  1.00 32.81          
ATOM   1117  O   PHE   132      36.340  33.542  53.762  1.00 32.93          
ATOM   1118  CB  PHE   132      35.978  33.360  57.082  1.00 33.46          
ATOM   1119  CG  PHE   132      35.917  34.273  58.313  1.00 33.81          
ATOM   1120  CD1 PHE   132      36.636  35.459  58.376  1.00 33.52          
ATOM   1121  CD2 PHE   132      35.140  33.913  59.412  1.00 33.83          
ATOM   1122  CE1 PHE   132      36.568  36.285  59.487  1.00 34.34          
ATOM   1123  CE2 PHE   132      35.065  34.742  60.542  1.00 34.41          
ATOM   1124  CZ  PHE   132      35.771  35.924  60.576  1.00 33.89          
ATOM   1125  N   MET   133      36.904  35.362  54.935  1.00 32.69          
ATOM   1126  CA  MET   133      38.010  35.718  54.067  1.00 31.66          
ATOM   1127  C   MET   133      38.954  36.535  54.922  1.00 31.51          
ATOM   1128  O   MET   133      38.537  37.133  55.927  1.00 30.00          
ATOM   1129  CB  MET   133      37.526  36.476  52.840  1.00 31.10          
ATOM   1130  CG  MET   133      36.856  37.801  53.121  1.00 31.10          
ATOM   1131  SD  MET   133      38.027  39.306  53.371  0.75 27.39          
ATOM   1132  CE  MET   133      38.977  39.093  51.665  1.00 30.78          
ATOM   1133  N   ASN   134      40.221  36.573  54.505  1.00 31.65          
ATOM   1134  CA  ASN   134      41.234  37.341  55.187  1.00 31.18          
ATOM   1135  C   ASN   134      42.550  37.392  54.410  1.00 31.15          
ATOM   1136  O   ASN   134      42.766  36.638  53.465  1.00 30.05          
ATOM   1137  CB  ASN   134      41.495  36.734  56.590  1.00 30.95          
ATOM   1138  CG  ASN   134      41.738  35.215  56.546  1.00 30.15          
ATOM   1139  OD1 ASN   134      40.798  34.440  56.568  1.00 31.54          
ATOM   1140  ND2 ASN   134      42.995  34.799  56.503  1.00 29.15          
ATOM   1141  N   GLU   135      43.415  38.315  54.833  1.00 31.28          
ATOM   1142  CA  GLU   135      44.803  38.371  54.391  1.00 31.19          
ATOM   1143  C   GLU   135      45.467  37.105  54.902  1.00 31.28          
ATOM   1144  O   GLU   135      45.140  36.589  55.969  1.00 31.04          
ATOM   1145  CB  GLU   135      45.558  39.476  55.098  1.00 31.44          
ATOM   1146  CG  GLU   135      45.180  40.847  54.761  1.00 31.10          
ATOM   1147  CD  GLU   135      45.856  41.845  55.647  1.00 29.10          
ATOM   1148  OE1 GLU   135      46.045  41.590  56.849  1.00 28.16          
ATOM   1149  OE2 GLU   135      46.195  42.897  55.129  1.00 31.14          
ATOM   1150  N   ILE   136      46.428  36.630  54.138  1.00 31.61          
ATOM   1151  CA  ILE   136      47.195  35.464  54.493  1.00 32.13          
ATOM   1152  C   ILE   136      48.260  35.960  55.475  1.00 31.79          
ATOM   1153  O   ILE   136      48.986  36.842  55.151  1.00 31.36          
ATOM   1154  CB  ILE   136      47.756  34.806  53.214  1.00 32.92          
ATOM   1155  CG1 ILE   136      46.589  34.150  52.454  1.00 29.58          
ATOM   1156  CG2 ILE   136      48.856  33.804  53.539  1.00 32.26          
ATOM   1157  CD  ILE   136      46.975  33.467  51.130  1.00 32.30          
ATOM   1158  N   PRO   137      48.306  35.420  56.709  1.00 32.77          
ATOM   1159  CA  PRO   137      49.274  35.953  57.678  1.00 33.77          
ATOM   1160  C   PRO   137      50.699  36.014  57.169  1.00 34.29          
ATOM   1161  O   PRO   137      51.377  37.019  57.389  1.00 35.58          
ATOM   1162  CB  PRO   137      49.152  34.988  58.846  1.00 33.69          
ATOM   1163  CG  PRO   137      47.777  34.485  58.741  1.00 33.61          
ATOM   1164  CD  PRO   137      47.543  34.316  57.295  1.00 32.30          
ATOM   1165  N   SER   138      51.127  34.981  56.446  1.00 35.02          
ATOM   1166  CA  SER   138      52.505  34.911  55.921  1.00 35.03          
ATOM   1167  C   SER   138      52.782  35.841  54.769  1.00 34.80          
ATOM   1168  O   SER   138      53.940  36.110  54.460  1.00 35.23          
ATOM   1169  CB  SER   138      52.844  33.479  55.506  1.00 35.10          
ATOM   1170  OG  SER   138      51.877  32.964  54.630  1.00 36.69          
ATOM   1171  N   GLU   139      51.745  36.294  54.071  1.00 34.68          
ATOM   1172  CA  GLU   139      51.949  37.254  52.995  1.00 34.27          
ATOM   1173  C   GLU   139      50.666  38.041  52.816  1.00 33.05          
ATOM   1174  O   GLU   139      49.802  37.657  52.059  1.00 31.18          
ATOM   1175  CB  GLU   139      52.451  36.611  51.695  1.00 33.92          
ATOM   1176  CG  GLU   139      52.949  37.681  50.687  1.00 34.83          
ATOM   1177  CD  GLU   139      53.502  37.114  49.365  1.00 38.52          
ATOM   1178  OE1 GLU   139      53.819  35.880  49.300  1.00 45.31          
ATOM   1179  OE2 GLU   139      53.628  37.910  48.373  1.00 41.93          
ATOM   1180  N   ARG   140      50.601  39.169  53.525  1.00 33.00          
ATOM   1181  CA  ARG   140      49.403  40.016  53.617  1.00 33.02          
ATOM   1182  C   ARG   140      48.832  40.613  52.325  1.00 32.12          
ATOM   1183  O   ARG   140      47.656  40.969  52.287  1.00 33.01          
ATOM   1184  CB  ARG   140      49.625  41.110  54.641  1.00 33.55          
ATOM   1185  CG  ARG   140      49.618  40.603  56.020  1.00 33.72          
ATOM   1186  CD  ARG   140      49.867  41.760  56.931  1.00 33.98          
ATOM   1187  NE  ARG   140      50.073  41.335  58.312  1.00 31.90          
ATOM   1188  CZ  ARG   140      49.217  41.476  59.303  1.00 32.28          
ATOM   1189  NH1 ARG   140      48.041  42.066  59.130  1.00 32.64          
ATOM   1190  NH2 ARG   140      49.583  41.063  60.510  1.00 31.55          
ATOM   1191  N   ALA   141      49.650  40.687  51.297  1.00 31.04          
ATOM   1192  CA  ALA   141      49.264  41.118  49.961  1.00 31.25          
ATOM   1193  C   ALA   141      48.235  40.147  49.390  1.00 31.65          
ATOM   1194  O   ALA   141      47.406  40.544  48.588  1.00 31.63          
ATOM   1195  CB  ALA   141      50.563  41.125  49.009  1.00 30.79          
ATOM   1196  N   ASN   142      48.326  38.874  49.797  1.00 31.81          
ATOM   1197  CA  ASN   142      47.462  37.808  49.327  1.00 31.67          
ATOM   1198  C   ASN   142      46.288  37.546  50.303  1.00 31.60          
ATOM   1199  O   ASN   142      46.320  37.903  51.475  1.00 32.41          
ATOM   1200  CB  ASN   142      48.267  36.525  49.069  1.00 31.56          
ATOM   1201  CG  ASN   142      49.404  36.710  48.061  1.00 31.76          
ATOM   1202  OD1 ASN   142      49.383  37.601  47.221  1.00 32.48          
ATOM   1203  ND2 ASN   142      50.380  35.838  48.125  1.00 30.67          
ATOM   1204  N   TYR   143      45.237  36.943  49.771  1.00 30.91          
ATOM   1205  CA  TYR   143      44.031  36.663  50.498  1.00 29.87          
ATOM   1206  C   TYR   143      43.571  35.218  50.307  1.00 29.75          
ATOM   1207  O   TYR   143      43.975  34.535  49.396  1.00 28.22          
ATOM   1208  CB  TYR   143      42.927  37.625  50.042  1.00 29.90          
ATOM   1209  CG  TYR   143      43.155  39.083  50.455  1.00 29.48          
ATOM   1210  CD1 TYR   143      43.962  39.914  49.675  1.00 27.65          
ATOM   1211  CD2 TYR   143      42.558  39.617  51.586  1.00 28.99          
ATOM   1212  CE1 TYR   143      44.193  41.193  50.007  1.00 30.87          
ATOM   1213  CE2 TYR   143      42.791  40.948  51.960  1.00 30.29          
ATOM   1214  CZ  TYR   143      43.618  41.711  51.161  1.00 29.81          
ATOM   1215  OH  TYR   143      43.889  42.987  51.418  1.00 31.80          
ATOM   1216  N   VAL   144      42.674  34.788  51.179  1.00 30.32          
ATOM   1217  CA  VAL   144      42.092  33.471  51.114  1.00 29.85          
ATOM   1218  C   VAL   144      40.616  33.605  51.469  1.00 30.50          
ATOM   1219  O   VAL   144      40.258  34.388  52.334  1.00 29.82          
ATOM   1220  CB  VAL   144      42.831  32.484  52.080  1.00 30.16          
ATOM   1221  CG1 VAL   144      42.731  32.951  53.551  1.00 27.18          
ATOM   1222  CG2 VAL   144      42.364  31.038  51.848  1.00 26.04          
ATOM   1223  N   PHE   145      39.776  32.873  50.736  1.00 30.78          
ATOM   1224  CA  PHE   145      38.368  32.781  51.015  1.00 30.53          
ATOM   1225  C   PHE   145      38.091  31.372  51.542  1.00 31.23          
ATOM   1226  O   PHE   145      38.650  30.398  51.045  1.00 31.66          
ATOM   1227  CB  PHE   145      37.560  33.019  49.738  1.00 31.15          
ATOM   1228  CG  PHE   145      37.780  34.342  49.137  1.00 30.85          
ATOM   1229  CD1 PHE   145      38.842  34.558  48.281  1.00 34.03          
ATOM   1230  CD2 PHE   145      36.942  35.388  49.426  1.00 31.87          
ATOM   1231  CE1 PHE   145      39.066  35.816  47.740  1.00 34.40          
ATOM   1232  CE2 PHE   145      37.152  36.640  48.876  1.00 30.74          
ATOM   1233  CZ  PHE   145      38.202  36.853  48.047  1.00 33.01          
ATOM   1234  N   TYR   146      37.237  31.248  52.562  1.00 31.84          
ATOM   1235  CA  TYR   146      36.838  29.925  53.037  1.00 31.32          
ATOM   1236  C   TYR   146      35.381  29.768  52.699  1.00 31.18          
ATOM   1237  O   TYR   146      34.601  30.672  52.935  1.00 31.77          
ATOM   1238  CB  TYR   146      37.093  29.747  54.517  1.00 31.06          
ATOM   1239  CG  TYR   146      38.540  29.779  54.850  1.00 31.66          
ATOM   1240  CD1 TYR   146      39.353  28.675  54.624  1.00 30.78          
ATOM   1241  CD2 TYR   146      39.119  30.916  55.381  1.00 32.06          
ATOM   1242  CE1 TYR   146      40.710  28.737  54.912  1.00 29.18          
ATOM   1243  CE2 TYR   146      40.437  30.958  55.683  1.00 31.33          
ATOM   1244  CZ  TYR   146      41.229  29.871  55.449  1.00 29.30          
ATOM   1245  OH  TYR   146      42.553  29.946  55.758  1.00 28.91          
ATOM   1246  N   MET   147      35.046  28.631  52.095  1.00 30.69          
ATOM   1247  CA  MET   147      33.699  28.306  51.660  1.00 29.75          
ATOM   1248  C   MET   147      33.218  26.951  52.139  1.00 30.05          
ATOM   1249  O   MET   147      33.992  26.005  52.328  1.00 29.86          
ATOM   1250  CB  MET   147      33.628  28.236  50.136  1.00 29.81          
ATOM   1251  CG  MET   147      34.193  29.440  49.391  1.00 31.03          
ATOM   1252  SD  MET   147      33.768  29.343  47.480  0.75 24.67          
ATOM   1253  CE  MET   147      31.824  29.011  47.804  1.00 31.59          
ATOM   1254  N   LEU   148      31.906  26.880  52.290  1.00 30.34          
ATOM   1255  CA  LEU   148      31.204  25.643  52.525  1.00 30.70          
ATOM   1256  C   LEU   148      30.446  25.379  51.236  1.00 31.20          
ATOM   1257  O   LEU   148      29.611  26.178  50.845  1.00 30.39          
ATOM   1258  CB  LEU   148      30.226  25.776  53.678  1.00 31.03          
ATOM   1259  CG  LEU   148      29.417  24.551  54.099  1.00 31.02          
ATOM   1260  CD1 LEU   148      30.272  23.256  54.355  1.00 28.35          
ATOM   1261  CD2 LEU   148      28.555  24.945  55.327  1.00 30.25          
ATOM   1262  N   GLU   149      30.772  24.271  50.563  1.00 31.34          
ATOM   1263  CA  GLU   149      30.094  23.869  49.356  1.00 31.58          
ATOM   1264  C   GLU   149      28.685  23.391  49.687  1.00 31.67          
ATOM   1265  O   GLU   149      28.452  22.766  50.733  1.00 31.30          
ATOM   1266  CB  GLU   149      30.868  22.765  48.669  1.00 32.45          
ATOM   1267  CG  GLU   149      30.220  22.284  47.416  1.00 33.30          
ATOM   1268  CD  GLU   149      31.106  21.330  46.614  1.00 35.55          
ATOM   1269  OE1 GLU   149      32.085  20.774  47.165  1.00 36.82          
ATOM   1270  OE2 GLU   149      30.791  21.127  45.429  1.00 34.53          
ATOM   1271  N   GLU   150      27.724  23.708  48.820  1.00 31.85          
ATOM   1272  CA  GLU   150      26.365  23.296  49.066  1.00 31.76          
ATOM   1273  C   GLU   150      26.049  22.123  48.156  1.00 32.44          
ATOM   1274  OT1 GLU   150      26.770  21.884  47.194  1.00 31.65          
ATOM   1275  CB  GLU   150      25.387  24.453  48.842  1.00 31.59          
ATOM   1276  CG  GLU   150      25.137  24.836  47.399  1.00 31.11          
ATOM   1277  CD  GLU   150      24.323  26.107  47.253  1.00 31.51          
ATOM   1278  OE1 GLU   150      24.363  26.957  48.148  1.00 31.26          
ATOM   1279  OE2 GLU   150      23.660  26.276  46.205  1.00 32.14          
ATOM   1280  OT2 GLU   150      25.047  21.415  48.336  1.00 34.12          
END
