
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   97 (  736),  selected   97 , name 1y8n_B
# Molecule2: number of CA atoms   68 (  548),  selected   68 , name T0397_83_150.pdb
# PARAMETERS: 1y8n_B.T0397_83_150.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S   128_B      -       -           -
LGA    Y   129_B      -       -           -
LGA    P   130_B      -       -           -
LGA    P   131_B      -       -           -
LGA    H   132_B      L      83          1.111
LGA    M   133_B      I      84          1.049
LGA    Q   134_B      S      85          1.136
LGA    V   135_B      V      86          1.042
LGA    L   136_B      P      87          2.617
LGA    L   137_B      A      88          3.776
LGA    P   138_B      -       -           -
LGA    A   139_B      -       -           -
LGA    L   140_B      -       -           -
LGA    S   141_B      -       -           -
LGA    P   142_B      -       -           -
LGA    T   143_B      -       -           -
LGA    M   144_B      -       -           -
LGA    T   145_B      -       -           -
LGA    M   146_B      E      89          4.938
LGA    G   147_B      G      90          1.044
LGA    -       -      Y      91           -
LGA    T   148_B      K      92          2.131
LGA    V   149_B      V      93          1.753
LGA    Q   150_B      Y      94          1.971
LGA    R   151_B      P      95          3.269
LGA    W   152_B      I      96          1.386
LGA    E   153_B      M      97           #
LGA    K   154_B      -       -           -
LGA    K   155_B      D      98          2.779
LGA    V   156_B      F      99          1.146
LGA    G   157_B      G     100          1.399
LGA    E   158_B      F     101          1.052
LGA    K   159_B      R     102          0.857
LGA    L   160_B      V     103          1.555
LGA    S   161_B      L     104          0.576
LGA    E   162_B      K     105          0.833
LGA    G   163_B      G     106          0.930
LGA    D   164_B      Y     107          0.942
LGA    L   165_B      R     108          1.078
LGA    L   166_B      L     109          0.881
LGA    A   167_B      A     110          1.018
LGA    E   168_B      T     111          1.283
LGA    I   169_B      L     112          1.380
LGA    E   170_B      E     113          1.685
LGA    T   171_B      S     114          1.600
LGA    D   172_B      K     115          1.694
LGA    K   173_B      K     116          4.006
LGA    -       -      G     117           -
LGA    A   174_B      D     118          0.974
LGA    T   175_B      L     119          2.270
LGA    I   176_B      R     120          2.211
LGA    G   177_B      Y     121          2.710
LGA    F   178_B      V     122          1.961
LGA    E   179_B      N     123          1.337
LGA    V   180_B      S     124          1.174
LGA    Q   181_B      P     125          1.576
LGA    E   182_B      V     126          1.405
LGA    E   183_B      S     127          1.434
LGA    G   184_B      G     128          1.135
LGA    Y   185_B      T     129          0.430
LGA    L   186_B      V     130          0.415
LGA    A   187_B      I     131          0.619
LGA    K   188_B      F     132          0.333
LGA    I   189_B      M     133          0.433
LGA    L   190_B      N     134          2.458
LGA    V   191_B      E     135          1.996
LGA    P   192_B      I     136           -
LGA    E   193_B      P     137           -
LGA    G   194_B      S     138           -
LGA    -       -      E     139           -
LGA    T   195_B      R     140          4.355
LGA    R   196_B      A     141          2.492
LGA    D   197_B      -       -           -
LGA    V   198_B      N     142          2.970
LGA    P   199_B      -       -           -
LGA    L   200_B      -       -           -
LGA    G   201_B      -       -           -
LGA    T   202_B      -       -           -
LGA    P   203_B      Y     143           #
LGA    L   204_B      V     144          0.499
LGA    C   205_B      F     145          1.369
LGA    I   206_B      Y     146          0.458
LGA    I   207_B      M     147          0.389
LGA    V   208_B      L     148          0.593
LGA    E   209_B      E     149          2.612
LGA    K   210_B      E     150          4.962
LGA    E   211_B      -       -           -
LGA    A   212_B      -       -           -
LGA    D   213_B      -       -           -
LGA    I   214_B      -       -           -
LGA    S   215_B      -       -           -
LGA    A   216_B      -       -           -
LGA    F   217_B      -       -           -
LGA    A   218_B      -       -           -
LGA    D   219_B      -       -           -
LGA    Y   220_B      -       -           -
LGA    T   226_B      -       -           -
LGA    D   227_B      -       -           -
LGA    L   228_B      -       -           -
LGA    K   229_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   97   68    5.0     60    1.99    18.33     75.630     2.876

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.525088 * X  +   0.209816 * Y  +   0.824779 * Z  + -55.867874
  Y_new =  -0.366718 * X  +   0.818763 * Y  +  -0.441753 * Z  +  49.282955
  Z_new =  -0.767985 * X  +  -0.534420 * Y  +  -0.352979 * Z  +   1.432286 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.154510    0.987082  [ DEG:  -123.4444     56.5556 ]
  Theta =   0.875689    2.265904  [ DEG:    50.1733    129.8267 ]
  Phi   =  -2.531946    0.609647  [ DEG:  -145.0698     34.9302 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1y8n_B                                        
REMARK     2: T0397_83_150.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1y8n_B.T0397_83_150.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   97   68   5.0   60   1.99   18.33  75.630
REMARK  ---------------------------------------------------------- 
MOLECULE 1y8n_B
HEADER    TRANSFERASE                             13-DEC-04   1Y8N              
TITLE     CRYSTAL STRUCTURE OF THE PDK3-L2 COMPLEX                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: [PYRUVATE DEHYDROGENASE [LIPOAMIDE]] KINASE                
COMPND   3 ISOZYME 3;                                                           
COMPND   4 CHAIN: A;                                                            
COMPND   5 SYNONYM: PYRUVATE DEHYDROGENASE KINASE ISOFORM 3;                    
COMPND   6 EC: 2.7.1.99;                                                        
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: DIHYDROLIPOYLLYSINE-RESIDUE ACETYLTRANSFERASE              
COMPND  10 COMPONENT OF PYRUVATE DEHYDROGENASE COMPLEX;                         
COMPND  11 CHAIN: B;                                                            
COMPND  12 SYNONYM: E2, DIHYDROLIPOAMIDE ACETYLTRANSFERASE COMPONENT            
COMPND  13 OF PYRUVATE DEHYDROGENASE COMPLEX, PDC-E2, 70 KDA                    
COMPND  14 MITOCHONDRIAL AUTOANTIGEN OF PRIMARY BILIARY CIRRHOSIS,              
COMPND  15 PBC, M2 ANTIGEN COMPLEX 70 KDA SUBUNIT;                              
COMPND  16 EC: 2.3.1.12;                                                        
COMPND  17 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PDK3;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PTRCHISB;                                 
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE  12 ORGANISM_COMMON: HUMAN;                                              
SOURCE  13 GENE: DLAT, DLTA;                                                    
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PTRCHISB                                  
KEYWDS    PYRUVATE DEHYDROGENASE KINASE 3, LIPOYL-BEARING DOMAIN,               
KEYWDS   2 PROTEIN-PROTEIN COMPLEX                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.KATO,J.L.CHUANG,R.M.WYNN,D.T.CHUANG                                 
REVDAT   1   24-MAY-05 1Y8N    0                                                
JRNL        AUTH   M.KATO,J.L.CHUANG,S.C.TSO,R.M.WYNN,D.T.CHUANG                
JRNL        TITL   CRYSTAL STRUCTURE OF PYRUVATE DEHYDROGENASE KINASE           
JRNL        TITL 2 3 BOUND TO LIPOYL DOMAIN 2 OF HUMAN PYRUVATE                 
JRNL        TITL 3 DEHYDROGENASE COMPLEX.                                       
JRNL        REF    EMBO J.                       V.  24  1763 2005              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  1Y8N A    9   406  UNP    Q15120   PDK3_HUMAN       9    406             
DBREF  1Y8N B  126   233  UNP    P10515   ODP2_HUMAN     179    286             
SEQRES   1 A  419  GLY GLY SER HIS HIS HIS HIS HIS HIS GLY MET ALA ARG          
SEQRES   2 A  419  LEU GLU ASN LEU TYR PHE GLN GLY LYS GLN PRO VAL PRO          
SEQRES   3 A  419  LYS GLN ILE GLU ARG TYR SER ARG PHE SER PRO SER PRO          
SEQRES   4 A  419  LEU SER ILE LYS GLN PHE LEU ASP PHE GLY ARG ASP ASN          
SEQRES   5 A  419  ALA CYS GLU LYS THR SER TYR MET PHE LEU ARG LYS GLU          
SEQRES   6 A  419  LEU PRO VAL ARG LEU ALA ASN THR MET ARG GLU VAL ASN          
SEQRES   7 A  419  LEU LEU PRO ASP ASN LEU LEU ASN ARG PRO SER VAL GLY          
SEQRES   8 A  419  LEU VAL GLN SER TRP TYR MET GLN SER PHE LEU GLU LEU          
SEQRES   9 A  419  LEU GLU TYR GLU ASN LYS SER PRO GLU ASP PRO GLN VAL          
SEQRES  10 A  419  LEU ASP ASN PHE LEU GLN VAL LEU ILE LYS VAL ARG ASN          
SEQRES  11 A  419  ARG HIS ASN ASP VAL VAL PRO THR MET ALA GLN GLY VAL          
SEQRES  12 A  419  ILE GLU TYR LYS GLU LYS PHE GLY PHE ASP PRO PHE ILE          
SEQRES  13 A  419  SER THR ASN ILE GLN TYR PHE LEU ASP ARG PHE TYR THR          
SEQRES  14 A  419  ASN ARG ILE SER PHE ARG MET LEU ILE ASN GLN HIS THR          
SEQRES  15 A  419  LEU LEU PHE GLY GLY ASP THR ASN PRO VAL HIS PRO LYS          
SEQRES  16 A  419  HIS ILE GLY SER ILE ASP PRO THR CYS ASN VAL ALA ASP          
SEQRES  17 A  419  VAL VAL LYS ASP ALA TYR GLU THR ALA LYS MET LEU CYS          
SEQRES  18 A  419  GLU GLN TYR TYR LEU VAL ALA PRO GLU LEU GLU VAL GLU          
SEQRES  19 A  419  GLU PHE ASN ALA LYS ALA PRO ASP LYS PRO ILE GLN VAL          
SEQRES  20 A  419  VAL TYR VAL PRO SER HIS LEU PHE HIS MET LEU PHE GLU          
SEQRES  21 A  419  LEU PHE LYS ASN SER MET ARG ALA THR VAL GLU LEU TYR          
SEQRES  22 A  419  GLU ASP ARG LYS GLU GLY TYR PRO ALA VAL LYS THR LEU          
SEQRES  23 A  419  VAL THR LEU GLY LYS GLU ASP LEU SER ILE LYS ILE SER          
SEQRES  24 A  419  ASP LEU GLY GLY GLY VAL PRO LEU ARG LYS ILE ASP ARG          
SEQRES  25 A  419  LEU PHE ASN TYR MET TYR SER THR ALA PRO ARG PRO SER          
SEQRES  26 A  419  LEU GLU PRO THR ARG ALA ALA PRO LEU ALA GLY PHE GLY          
SEQRES  27 A  419  TYR GLY LEU PRO ILE SER ARG LEU TYR ALA ARG TYR PHE          
SEQRES  28 A  419  GLN GLY ASP LEU LYS LEU TYR SER MET GLU GLY VAL GLY          
SEQRES  29 A  419  THR ASP ALA VAL ILE TYR LEU LYS ALA LEU SER SER GLU          
SEQRES  30 A  419  SER PHE GLU ARG LEU PRO VAL PHE ASN LYS SER ALA TRP          
SEQRES  31 A  419  ARG HIS TYR LYS THR THR PRO GLU ALA ASP ASP TRP SER          
SEQRES  32 A  419  ASN PRO SER SER GLU PRO ARG ASP ALA SER LYS TYR LYS          
SEQRES  33 A  419  ALA LYS GLN                                                  
SEQRES   1 B  128  GLY GLY SER HIS HIS HIS HIS HIS HIS GLY MET ALA ARG          
SEQRES   2 B  128  LEU GLU ASN LEU TYR PHE GLN GLY SER SER TYR PRO PRO          
SEQRES   3 B  128  HIS MET GLN VAL LEU LEU PRO ALA LEU SER PRO THR MET          
SEQRES   4 B  128  THR MET GLY THR VAL GLN ARG TRP GLU LYS LYS VAL GLY          
SEQRES   5 B  128  GLU LYS LEU SER GLU GLY ASP LEU LEU ALA GLU ILE GLU          
SEQRES   6 B  128  THR ASP LYS ALA THR ILE GLY PHE GLU VAL GLN GLU GLU          
SEQRES   7 B  128  GLY TYR LEU ALA LYS ILE LEU VAL PRO GLU GLY THR ARG          
SEQRES   8 B  128  ASP VAL PRO LEU GLY THR PRO LEU CYS ILE ILE VAL GLU          
SEQRES   9 B  128  LYS GLU ALA ASP ILE SER ALA PHE ALA ASP TYR ARG PRO          
SEQRES  10 B  128  THR GLU VAL THR ASP LEU LYS PRO GLN VAL PRO                  
HET      K    501       1                                                       
HET    LPA  B 373      11                                                       
HETNAM       K POTASSIUM ION                                                    
HETNAM     LPA LIPOIC ACID                                                      
FORMUL   3    K    K 1+                                                         
FORMUL   4  LPA    C8 H14 O2 S2                                                 
FORMUL   5  HOH   *53(H2 O)                                                     
CRYST1  120.806  120.806  238.587  90.00  90.00 120.00 P 65 2 2     12          
ATOM   3068  N   SER B 128      34.341  18.472  63.785  1.00 87.20           N  
ATOM   3069  CA  SER B 128      35.567  19.243  64.158  1.00 87.83           C  
ATOM   3070  C   SER B 128      35.341  20.748  63.876  1.00 87.84           C  
ATOM   3071  O   SER B 128      34.972  21.515  64.789  1.00 87.75           O  
ATOM   3072  CB  SER B 128      36.782  18.675  63.406  1.00 87.95           C  
ATOM   3073  OG  SER B 128      37.988  19.286  63.831  1.00 89.46           O  
ATOM   3074  N   TYR B 129      35.600  21.159  62.623  1.00 87.32           N  
ATOM   3075  CA  TYR B 129      34.895  22.284  61.957  1.00 86.29           C  
ATOM   3076  C   TYR B 129      33.937  21.646  60.925  1.00 85.13           C  
ATOM   3077  O   TYR B 129      34.183  20.511  60.490  1.00 85.15           O  
ATOM   3078  CB  TYR B 129      35.880  23.182  61.209  1.00 86.47           C  
ATOM   3079  CG  TYR B 129      36.601  24.266  62.010  1.00 87.50           C  
ATOM   3080  CD1 TYR B 129      38.009  24.273  62.108  1.00 87.73           C  
ATOM   3081  CD2 TYR B 129      35.887  25.317  62.627  1.00 87.82           C  
ATOM   3082  CE1 TYR B 129      38.686  25.278  62.820  1.00 87.34           C  
ATOM   3083  CE2 TYR B 129      36.556  26.333  63.341  1.00 87.00           C  
ATOM   3084  CZ  TYR B 129      37.948  26.302  63.427  1.00 87.73           C  
ATOM   3085  OH  TYR B 129      38.607  27.291  64.123  1.00 87.90           O  
ATOM   3086  N   PRO B 130      32.845  22.333  60.523  1.00 83.82           N  
ATOM   3087  CA  PRO B 130      32.029  21.690  59.465  1.00 83.00           C  
ATOM   3088  C   PRO B 130      32.747  21.538  58.085  1.00 82.25           C  
ATOM   3089  O   PRO B 130      33.768  22.224  57.828  1.00 81.84           O  
ATOM   3090  CB  PRO B 130      30.778  22.574  59.366  1.00 82.66           C  
ATOM   3091  CG  PRO B 130      31.119  23.819  60.032  1.00 83.26           C  
ATOM   3092  CD  PRO B 130      32.279  23.615  60.964  1.00 83.54           C  
ATOM   3093  N   PRO B 131      32.226  20.633  57.210  1.00 81.35           N  
ATOM   3094  CA  PRO B 131      32.913  20.352  55.936  1.00 80.57           C  
ATOM   3095  C   PRO B 131      33.143  21.654  55.171  1.00 79.68           C  
ATOM   3096  O   PRO B 131      32.225  22.482  55.061  1.00 79.42           O  
ATOM   3097  CB  PRO B 131      31.933  19.435  55.188  1.00 80.70           C  
ATOM   3098  CG  PRO B 131      31.071  18.824  56.258  1.00 81.21           C  
ATOM   3099  CD  PRO B 131      30.970  19.863  57.348  1.00 81.08           C  
ATOM   3100  N   HIS B 132      34.368  21.842  54.687  1.00 78.55           N  
ATOM   3101  CA  HIS B 132      34.769  23.123  54.116  1.00 77.59           C  
ATOM   3102  C   HIS B 132      35.948  23.057  53.122  1.00 76.72           C  
ATOM   3103  O   HIS B 132      36.821  22.192  53.215  1.00 76.71           O  
ATOM   3104  CB  HIS B 132      35.074  24.118  55.241  1.00 77.66           C  
ATOM   3105  CG  HIS B 132      36.374  23.867  55.930  1.00 78.23           C  
ATOM   3106  ND1 HIS B 132      36.672  22.669  56.540  1.00 80.15           N  
ATOM   3107  CD2 HIS B 132      37.458  24.659  56.105  1.00 78.79           C  
ATOM   3108  CE1 HIS B 132      37.890  22.731  57.057  1.00 79.88           C  
ATOM   3109  NE2 HIS B 132      38.386  23.930  56.811  1.00 78.76           N  
ATOM   3110  N   MET B 133      35.973  24.016  52.202  1.00 75.32           N  
ATOM   3111  CA  MET B 133      36.962  24.091  51.134  1.00 73.61           C  
ATOM   3112  C   MET B 133      37.854  25.302  51.385  1.00 71.25           C  
ATOM   3113  O   MET B 133      37.400  26.346  51.820  1.00 70.88           O  
ATOM   3114  CB  MET B 133      36.185  24.265  49.830  1.00 74.78           C  
ATOM   3115  CG  MET B 133      36.659  23.489  48.633  1.00 78.15           C  
ATOM   3116  SD  MET B 133      38.014  24.386  47.851  1.00 89.95           S  
ATOM   3117  CE  MET B 133      38.029  23.625  46.222  1.00 86.00           C  
ATOM   3118  N   GLN B 134      39.132  25.173  51.120  1.00 69.07           N  
ATOM   3119  CA  GLN B 134      40.013  26.331  51.196  1.00 67.06           C  
ATOM   3120  C   GLN B 134      40.387  26.913  49.798  1.00 65.00           C  
ATOM   3121  O   GLN B 134      40.966  26.189  48.966  1.00 65.00           O  
ATOM   3122  CB  GLN B 134      41.272  25.899  51.917  1.00 67.67           C  
ATOM   3123  CG  GLN B 134      41.845  26.989  52.765  1.00 71.42           C  
ATOM   3124  CD  GLN B 134      43.029  26.528  53.596  1.00 74.23           C  
ATOM   3125  OE1 GLN B 134      43.867  25.731  53.142  1.00 75.35           O  
ATOM   3126  NE2 GLN B 134      43.120  27.054  54.815  1.00 74.39           N  
ATOM   3127  N   VAL B 135      40.073  28.193  49.530  1.00 61.41           N  
ATOM   3128  CA  VAL B 135      40.432  28.785  48.242  1.00 57.76           C  
ATOM   3129  C   VAL B 135      41.870  29.291  48.201  1.00 55.86           C  
ATOM   3130  O   VAL B 135      42.216  30.273  48.838  1.00 54.74           O  
ATOM   3131  CB  VAL B 135      39.432  29.883  47.757  1.00 58.51           C  
ATOM   3132  CG1 VAL B 135      39.921  30.559  46.443  1.00 55.83           C  
ATOM   3133  CG2 VAL B 135      38.067  29.294  47.528  1.00 57.58           C  
ATOM   3134  N   LEU B 136      42.695  28.611  47.421  1.00 54.02           N  
ATOM   3135  CA  LEU B 136      44.091  28.972  47.299  1.00 53.58           C  
ATOM   3136  C   LEU B 136      44.368  29.887  46.081  1.00 53.90           C  
ATOM   3137  O   LEU B 136      43.722  29.754  45.005  1.00 53.10           O  
ATOM   3138  CB  LEU B 136      44.942  27.695  47.189  1.00 53.92           C  
ATOM   3139  CG  LEU B 136      44.817  26.531  48.198  1.00 53.75           C  
ATOM   3140  CD1 LEU B 136      45.880  25.510  47.906  1.00 48.23           C  
ATOM   3141  CD2 LEU B 136      44.941  27.059  49.641  1.00 52.73           C  
ATOM   3142  N   LEU B 137      45.338  30.791  46.234  1.00 53.12           N  
ATOM   3143  CA  LEU B 137      45.665  31.710  45.160  1.00 53.26           C  
ATOM   3144  C   LEU B 137      46.414  30.961  44.070  1.00 53.16           C  
ATOM   3145  O   LEU B 137      47.579  30.615  44.280  1.00 54.56           O  
ATOM   3146  CB  LEU B 137      46.514  32.891  45.654  1.00 52.91           C  
ATOM   3147  CG  LEU B 137      47.015  33.895  44.589  1.00 53.19           C  
ATOM   3148  CD1 LEU B 137      45.828  34.680  43.992  1.00 51.09           C  
ATOM   3149  CD2 LEU B 137      48.148  34.864  45.092  1.00 49.41           C  
ATOM   3150  N   PRO B 138      45.778  30.739  42.886  1.00 52.23           N  
ATOM   3151  CA  PRO B 138      46.501  30.049  41.802  1.00 51.21           C  
ATOM   3152  C   PRO B 138      47.428  31.026  41.149  1.00 51.41           C  
ATOM   3153  O   PRO B 138      47.301  32.242  41.402  1.00 52.20           O  
ATOM   3154  CB  PRO B 138      45.385  29.682  40.817  1.00 50.66           C  
ATOM   3155  CG  PRO B 138      44.060  29.939  41.590  1.00 49.90           C  
ATOM   3156  CD  PRO B 138      44.413  31.099  42.467  1.00 51.09           C  
ATOM   3157  N   ALA B 139      48.378  30.530  40.357  1.00 51.64           N  
ATOM   3158  CA  ALA B 139      49.049  31.383  39.349  1.00 51.97           C  
ATOM   3159  C   ALA B 139      47.987  31.659  38.252  1.00 52.33           C  
ATOM   3160  O   ALA B 139      47.505  30.731  37.564  1.00 52.03           O  
ATOM   3161  CB  ALA B 139      50.287  30.704  38.767  1.00 50.73           C  
ATOM   3162  N   LEU B 140      47.572  32.919  38.139  1.00 53.13           N  
ATOM   3163  CA  LEU B 140      46.449  33.274  37.263  1.00 53.95           C  
ATOM   3164  C   LEU B 140      46.941  33.628  35.863  1.00 54.70           C  
ATOM   3165  O   LEU B 140      46.163  33.835  34.920  1.00 55.42           O  
ATOM   3166  CB  LEU B 140      45.665  34.407  37.879  1.00 53.71           C  
ATOM   3167  CG  LEU B 140      44.420  34.107  38.712  1.00 53.02           C  
ATOM   3168  CD1 LEU B 140      44.199  32.669  39.066  1.00 49.14           C  
ATOM   3169  CD2 LEU B 140      44.423  35.014  39.927  1.00 51.90           C  
ATOM   3170  N   SER B 141      48.257  33.619  35.742  1.00 55.22           N  
ATOM   3171  CA  SER B 141      48.937  33.892  34.527  1.00 56.26           C  
ATOM   3172  C   SER B 141      50.261  33.116  34.591  1.00 57.62           C  
ATOM   3173  O   SER B 141      50.833  32.927  35.681  1.00 57.29           O  
ATOM   3174  CB  SER B 141      49.114  35.408  34.411  1.00 55.88           C  
ATOM   3175  OG  SER B 141      50.446  35.787  34.217  1.00 56.70           O  
ATOM   3176  N   PRO B 142      50.782  32.683  33.425  1.00 58.96           N  
ATOM   3177  CA  PRO B 142      51.940  31.759  33.473  1.00 59.53           C  
ATOM   3178  C   PRO B 142      53.170  32.238  34.278  1.00 59.68           C  
ATOM   3179  O   PRO B 142      53.920  31.412  34.764  1.00 59.83           O  
ATOM   3180  CB  PRO B 142      52.273  31.535  31.997  1.00 59.34           C  
ATOM   3181  CG  PRO B 142      51.645  32.759  31.294  1.00 59.89           C  
ATOM   3182  CD  PRO B 142      50.387  32.992  32.039  1.00 58.62           C  
ATOM   3183  N   THR B 143      53.366  33.537  34.460  1.00 60.01           N  
ATOM   3184  CA  THR B 143      54.584  34.003  35.159  1.00 60.12           C  
ATOM   3185  C   THR B 143      54.275  34.539  36.550  1.00 59.35           C  
ATOM   3186  O   THR B 143      55.146  35.035  37.235  1.00 59.54           O  
ATOM   3187  CB  THR B 143      55.292  35.132  34.362  1.00 60.72           C  
ATOM   3188  OG1 THR B 143      54.328  36.155  34.063  1.00 61.47           O  
ATOM   3189  CG2 THR B 143      55.860  34.600  33.048  1.00 61.46           C  
ATOM   3190  N   MET B 144      53.033  34.453  36.972  1.00 58.90           N  
ATOM   3191  CA  MET B 144      52.650  35.047  38.235  1.00 59.08           C  
ATOM   3192  C   MET B 144      53.197  34.247  39.422  1.00 60.23           C  
ATOM   3193  O   MET B 144      52.959  33.042  39.509  1.00 60.41           O  
ATOM   3194  CB  MET B 144      51.129  35.089  38.324  1.00 57.91           C  
ATOM   3195  CG  MET B 144      50.610  35.724  39.557  1.00 55.18           C  
ATOM   3196  SD  MET B 144      48.863  35.445  39.563  1.00 55.48           S  
ATOM   3197  CE  MET B 144      48.439  35.927  41.236  1.00 55.07           C  
ATOM   3198  N   THR B 145      53.889  34.916  40.341  1.00 61.18           N  
ATOM   3199  CA  THR B 145      54.372  34.251  41.567  1.00 62.01           C  
ATOM   3200  C   THR B 145      53.722  34.796  42.844  1.00 62.92           C  
ATOM   3201  O   THR B 145      53.834  34.209  43.918  1.00 63.68           O  
ATOM   3202  CB  THR B 145      55.893  34.361  41.720  1.00 62.03           C  
ATOM   3203  OG1 THR B 145      56.248  35.735  41.932  1.00 61.53           O  
ATOM   3204  CG2 THR B 145      56.638  33.782  40.492  1.00 60.79           C  
ATOM   3205  N   MET B 146      53.026  35.913  42.720  1.00 63.79           N  
ATOM   3206  CA  MET B 146      52.315  36.516  43.837  1.00 64.29           C  
ATOM   3207  C   MET B 146      51.375  37.552  43.242  1.00 64.08           C  
ATOM   3208  O   MET B 146      51.541  37.942  42.072  1.00 64.25           O  
ATOM   3209  CB  MET B 146      53.307  37.239  44.729  1.00 64.94           C  
ATOM   3210  CG  MET B 146      54.126  38.220  43.929  1.00 68.12           C  
ATOM   3211  SD  MET B 146      55.265  39.177  44.899  1.00 78.46           S  
ATOM   3212  CE  MET B 146      56.744  38.141  44.754  1.00 73.37           C  
ATOM   3213  N   GLY B 147      50.422  38.015  44.045  1.00 63.02           N  
ATOM   3214  CA  GLY B 147      49.538  39.074  43.629  1.00 62.77           C  
ATOM   3215  C   GLY B 147      48.963  39.844  44.795  1.00 62.48           C  
ATOM   3216  O   GLY B 147      48.977  39.369  45.915  1.00 62.58           O  
ATOM   3217  N   THR B 148      48.437  41.031  44.521  1.00 61.71           N  
ATOM   3218  CA  THR B 148      47.784  41.834  45.532  1.00 61.02           C  
ATOM   3219  C   THR B 148      46.301  41.503  45.474  1.00 61.08           C  
ATOM   3220  O   THR B 148      45.738  41.411  44.393  1.00 62.14           O  
ATOM   3221  CB  THR B 148      47.991  43.311  45.201  1.00 60.92           C  
ATOM   3222  OG1 THR B 148      49.388  43.615  45.241  1.00 61.62           O  
ATOM   3223  CG2 THR B 148      47.224  44.226  46.147  1.00 59.79           C  
ATOM   3224  N   VAL B 149      45.671  41.295  46.620  1.00 60.70           N  
ATOM   3225  CA  VAL B 149      44.233  41.112  46.669  1.00 61.03           C  
ATOM   3226  C   VAL B 149      43.618  42.506  46.651  1.00 62.84           C  
ATOM   3227  O   VAL B 149      43.480  43.153  47.688  1.00 63.83           O  
ATOM   3228  CB  VAL B 149      43.786  40.311  47.923  1.00 60.22           C  
ATOM   3229  CG1 VAL B 149      42.294  40.300  48.067  1.00 58.60           C  
ATOM   3230  CG2 VAL B 149      44.277  38.894  47.841  1.00 59.18           C  
ATOM   3231  N   GLN B 150      43.275  43.007  45.473  1.00 64.04           N  
ATOM   3232  CA  GLN B 150      42.900  44.412  45.394  1.00 64.57           C  
ATOM   3233  C   GLN B 150      41.468  44.672  45.839  1.00 65.13           C  
ATOM   3234  O   GLN B 150      41.160  45.776  46.269  1.00 65.63           O  
ATOM   3235  CB  GLN B 150      43.183  44.975  44.007  1.00 64.59           C  
ATOM   3236  CG  GLN B 150      42.465  46.259  43.704  1.00 65.23           C  
ATOM   3237  CD  GLN B 150      42.492  46.583  42.236  1.00 66.35           C  
ATOM   3238  OE1 GLN B 150      41.434  46.674  41.581  1.00 67.79           O  
ATOM   3239  NE2 GLN B 150      43.699  46.739  41.692  1.00 64.78           N  
ATOM   3240  N   ARG B 151      40.598  43.663  45.773  1.00 65.46           N  
ATOM   3241  CA  ARG B 151      39.204  43.883  46.112  1.00 65.51           C  
ATOM   3242  C   ARG B 151      38.389  42.605  46.213  1.00 64.71           C  
ATOM   3243  O   ARG B 151      38.387  41.811  45.298  1.00 65.66           O  
ATOM   3244  CB  ARG B 151      38.581  44.793  45.039  1.00 66.20           C  
ATOM   3245  CG  ARG B 151      37.547  45.729  45.588  1.00 69.49           C  
ATOM   3246  CD  ARG B 151      36.671  46.244  44.505  1.00 75.88           C  
ATOM   3247  NE  ARG B 151      35.354  46.630  45.025  1.00 81.52           N  
ATOM   3248  CZ  ARG B 151      34.344  47.042  44.256  1.00 83.95           C  
ATOM   3249  NH1 ARG B 151      34.506  47.121  42.935  1.00 84.59           N  
ATOM   3250  NH2 ARG B 151      33.169  47.370  44.795  1.00 84.71           N  
ATOM   3251  N   TRP B 152      37.664  42.423  47.302  1.00 63.78           N  
ATOM   3252  CA  TRP B 152      36.737  41.314  47.425  1.00 63.28           C  
ATOM   3253  C   TRP B 152      35.458  41.688  46.735  1.00 63.95           C  
ATOM   3254  O   TRP B 152      35.034  42.826  46.832  1.00 64.58           O  
ATOM   3255  CB  TRP B 152      36.492  40.981  48.909  1.00 62.94           C  
ATOM   3256  CG  TRP B 152      37.687  40.253  49.439  1.00 62.14           C  
ATOM   3257  CD1 TRP B 152      38.747  40.786  50.117  1.00 60.95           C  
ATOM   3258  CD2 TRP B 152      38.004  38.873  49.216  1.00 60.07           C  
ATOM   3259  NE1 TRP B 152      39.689  39.812  50.364  1.00 61.20           N  
ATOM   3260  CE2 TRP B 152      39.260  38.631  49.815  1.00 60.64           C  
ATOM   3261  CE3 TRP B 152      37.341  37.817  48.578  1.00 58.71           C  
ATOM   3262  CZ2 TRP B 152      39.866  37.374  49.798  1.00 59.57           C  
ATOM   3263  CZ3 TRP B 152      37.940  36.558  48.570  1.00 59.98           C  
ATOM   3264  CH2 TRP B 152      39.191  36.351  49.171  1.00 59.26           C  
ATOM   3265  N   GLU B 153      34.838  40.754  46.024  1.00 64.13           N  
ATOM   3266  CA  GLU B 153      33.610  41.068  45.289  1.00 64.04           C  
ATOM   3267  C   GLU B 153      32.473  40.246  45.822  1.00 64.59           C  
ATOM   3268  O   GLU B 153      31.372  40.173  45.217  1.00 64.22           O  
ATOM   3269  CB  GLU B 153      33.790  40.835  43.788  1.00 63.81           C  
ATOM   3270  CG  GLU B 153      34.924  41.669  43.171  1.00 64.32           C  
ATOM   3271  CD  GLU B 153      34.548  43.132  42.992  1.00 64.56           C  
ATOM   3272  OE1 GLU B 153      33.363  43.470  43.162  1.00 64.43           O  
ATOM   3273  OE2 GLU B 153      35.440  43.950  42.694  1.00 67.01           O  
ATOM   3274  N   LYS B 154      32.759  39.613  46.958  1.00 64.98           N  
ATOM   3275  CA  LYS B 154      31.772  38.842  47.685  1.00 65.66           C  
ATOM   3276  C   LYS B 154      31.867  39.125  49.175  1.00 66.62           C  
ATOM   3277  O   LYS B 154      32.950  39.449  49.697  1.00 66.73           O  
ATOM   3278  CB  LYS B 154      31.939  37.353  47.400  1.00 65.90           C  
ATOM   3279  CG  LYS B 154      31.600  36.919  45.978  1.00 63.25           C  
ATOM   3280  CD  LYS B 154      30.137  37.037  45.691  1.00 60.67           C  
ATOM   3281  CE  LYS B 154      29.782  36.229  44.478  1.00 60.77           C  
ATOM   3282  NZ  LYS B 154      28.340  36.250  44.165  1.00 59.06           N  
ATOM   3283  N   LYS B 155      30.716  39.037  49.836  1.00 67.85           N  
ATOM   3284  CA  LYS B 155      30.607  39.244  51.286  1.00 69.40           C  
ATOM   3285  C   LYS B 155      30.466  37.912  52.003  1.00 69.17           C  
ATOM   3286  O   LYS B 155      29.722  37.021  51.555  1.00 68.55           O  
ATOM   3287  CB  LYS B 155      29.363  40.104  51.644  1.00 70.03           C  
ATOM   3288  CG  LYS B 155      29.381  41.578  51.184  1.00 73.22           C  
ATOM   3289  CD  LYS B 155      30.429  42.396  51.965  1.00 79.64           C  
ATOM   3290  CE  LYS B 155      30.987  43.583  51.155  1.00 81.55           C  
ATOM   3291  NZ  LYS B 155      29.927  44.615  50.972  1.00 83.87           N  
ATOM   3292  N   VAL B 156      31.139  37.799  53.143  1.00 69.66           N  
ATOM   3293  CA  VAL B 156      30.821  36.745  54.102  1.00 70.16           C  
ATOM   3294  C   VAL B 156      29.308  36.573  54.180  1.00 70.02           C  
ATOM   3295  O   VAL B 156      28.583  37.543  54.302  1.00 70.14           O  
ATOM   3296  CB  VAL B 156      31.328  37.065  55.512  1.00 70.60           C  
ATOM   3297  CG1 VAL B 156      31.051  35.859  56.432  1.00 70.97           C  
ATOM   3298  CG2 VAL B 156      32.833  37.429  55.513  1.00 70.52           C  
ATOM   3299  N   GLY B 157      28.833  35.339  54.078  1.00 70.59           N  
ATOM   3300  CA  GLY B 157      27.398  35.064  54.082  1.00 70.83           C  
ATOM   3301  C   GLY B 157      26.802  34.836  52.716  1.00 71.45           C  
ATOM   3302  O   GLY B 157      25.776  34.167  52.577  1.00 71.40           O  
ATOM   3303  N   GLU B 158      27.459  35.378  51.692  1.00 72.45           N  
ATOM   3304  CA  GLU B 158      26.895  35.386  50.337  1.00 72.87           C  
ATOM   3305  C   GLU B 158      27.018  34.047  49.635  1.00 72.55           C  
ATOM   3306  O   GLU B 158      28.031  33.349  49.784  1.00 72.87           O  
ATOM   3307  CB  GLU B 158      27.575  36.452  49.514  1.00 73.19           C  
ATOM   3308  CG  GLU B 158      27.020  37.840  49.741  1.00 75.79           C  
ATOM   3309  CD  GLU B 158      27.252  38.718  48.526  1.00 78.17           C  
ATOM   3310  OE1 GLU B 158      26.351  38.726  47.643  1.00 78.16           O  
ATOM   3311  OE2 GLU B 158      28.341  39.346  48.446  1.00 76.25           O  
ATOM   3312  N   LYS B 159      25.989  33.688  48.877  1.00 72.01           N  
ATOM   3313  CA  LYS B 159      26.038  32.480  48.082  1.00 72.06           C  
ATOM   3314  C   LYS B 159      27.128  32.603  46.990  1.00 71.46           C  
ATOM   3315  O   LYS B 159      27.437  33.704  46.509  1.00 71.22           O  
ATOM   3316  CB  LYS B 159      24.674  32.197  47.472  1.00 72.52           C  
ATOM   3317  CG  LYS B 159      24.571  30.857  46.728  1.00 75.54           C  
ATOM   3318  CD  LYS B 159      23.126  30.595  46.306  1.00 80.11           C  
ATOM   3319  CE  LYS B 159      23.006  29.443  45.316  1.00 82.99           C  
ATOM   3320  NZ  LYS B 159      21.557  29.216  44.993  1.00 84.89           N  
ATOM   3321  N   LEU B 160      27.729  31.468  46.642  1.00 70.32           N  
ATOM   3322  CA  LEU B 160      28.798  31.415  45.657  1.00 69.06           C  
ATOM   3323  C   LEU B 160      28.452  30.386  44.593  1.00 68.76           C  
ATOM   3324  O   LEU B 160      28.413  29.173  44.872  1.00 68.11           O  
ATOM   3325  CB  LEU B 160      30.124  31.069  46.316  1.00 68.82           C  
ATOM   3326  CG  LEU B 160      30.684  32.061  47.332  1.00 68.07           C  
ATOM   3327  CD1 LEU B 160      31.946  31.486  47.896  1.00 67.99           C  
ATOM   3328  CD2 LEU B 160      30.980  33.388  46.712  1.00 68.19           C  
ATOM   3329  N   SER B 161      28.134  30.892  43.398  1.00 68.02           N  
ATOM   3330  CA  SER B 161      27.869  30.071  42.225  1.00 67.57           C  
ATOM   3331  C   SER B 161      29.148  29.957  41.404  1.00 66.76           C  
ATOM   3332  O   SER B 161      29.959  30.890  41.358  1.00 66.46           O  
ATOM   3333  CB  SER B 161      26.764  30.702  41.388  1.00 68.02           C  
ATOM   3334  OG  SER B 161      25.512  30.085  41.633  1.00 70.49           O  
ATOM   3335  N   GLU B 162      29.332  28.813  40.767  1.00 66.19           N  
ATOM   3336  CA  GLU B 162      30.510  28.587  39.947  1.00 66.23           C  
ATOM   3337  C   GLU B 162      30.598  29.668  38.874  1.00 64.85           C  
ATOM   3338  O   GLU B 162      29.617  29.941  38.189  1.00 65.13           O  
ATOM   3339  CB  GLU B 162      30.457  27.188  39.330  1.00 66.92           C  
ATOM   3340  CG  GLU B 162      31.526  26.909  38.260  1.00 72.14           C  
ATOM   3341  CD  GLU B 162      31.776  25.392  38.026  1.00 79.43           C  
ATOM   3342  OE1 GLU B 162      31.004  24.542  38.592  1.00 81.03           O  
ATOM   3343  OE2 GLU B 162      32.760  25.066  37.288  1.00 79.33           O  
ATOM   3344  N   GLY B 163      31.761  30.301  38.761  1.00 63.22           N  
ATOM   3345  CA  GLY B 163      31.959  31.386  37.828  1.00 61.18           C  
ATOM   3346  C   GLY B 163      31.650  32.807  38.296  1.00 60.35           C  
ATOM   3347  O   GLY B 163      31.910  33.761  37.562  1.00 59.59           O  
ATOM   3348  N   ASP B 164      31.085  32.975  39.494  1.00 59.37           N  
ATOM   3349  CA  ASP B 164      30.868  34.329  40.027  1.00 57.93           C  
ATOM   3350  C   ASP B 164      32.218  34.957  40.183  1.00 55.75           C  
ATOM   3351  O   ASP B 164      33.222  34.249  40.333  1.00 55.01           O  
ATOM   3352  CB  ASP B 164      30.230  34.299  41.412  1.00 59.08           C  
ATOM   3353  CG  ASP B 164      28.750  33.933  41.392  1.00 62.01           C  
ATOM   3354  OD1 ASP B 164      28.148  33.880  40.288  1.00 63.12           O  
ATOM   3355  OD2 ASP B 164      28.199  33.695  42.514  1.00 64.34           O  
ATOM   3356  N   LEU B 165      32.246  36.280  40.159  1.00 53.74           N  
ATOM   3357  CA  LEU B 165      33.479  36.996  40.390  1.00 52.14           C  
ATOM   3358  C   LEU B 165      33.747  36.976  41.900  1.00 52.39           C  
ATOM   3359  O   LEU B 165      32.828  37.220  42.708  1.00 51.66           O  
ATOM   3360  CB  LEU B 165      33.384  38.428  39.853  1.00 51.47           C  
ATOM   3361  CG  LEU B 165      34.544  39.399  40.143  1.00 50.32           C  
ATOM   3362  CD1 LEU B 165      35.873  38.977  39.538  1.00 47.46           C  
ATOM   3363  CD2 LEU B 165      34.211  40.796  39.678  1.00 49.72           C  
ATOM   3364  N   LEU B 166      34.993  36.673  42.276  1.00 51.84           N  
ATOM   3365  CA  LEU B 166      35.321  36.558  43.675  1.00 51.97           C  
ATOM   3366  C   LEU B 166      36.187  37.706  44.175  1.00 51.81           C  
ATOM   3367  O   LEU B 166      35.924  38.279  45.234  1.00 52.00           O  
ATOM   3368  CB  LEU B 166      35.965  35.195  43.989  1.00 51.99           C  
ATOM   3369  CG  LEU B 166      36.232  34.923  45.495  1.00 51.98           C  
ATOM   3370  CD1 LEU B 166      34.920  34.946  46.269  1.00 49.66           C  
ATOM   3371  CD2 LEU B 166      37.025  33.610  45.804  1.00 48.62           C  
ATOM   3372  N   ALA B 167      37.218  38.045  43.412  1.00 51.77           N  
ATOM   3373  CA  ALA B 167      38.107  39.114  43.795  1.00 51.55           C  
ATOM   3374  C   ALA B 167      38.903  39.608  42.588  1.00 52.08           C  
ATOM   3375  O   ALA B 167      38.992  38.904  41.586  1.00 51.44           O  
ATOM   3376  CB  ALA B 167      39.036  38.656  44.899  1.00 50.88           C  
ATOM   3377  N   GLU B 168      39.465  40.818  42.706  1.00 52.09           N  
ATOM   3378  CA  GLU B 168      40.368  41.352  41.730  1.00 52.70           C  
ATOM   3379  C   GLU B 168      41.778  41.100  42.231  1.00 52.98           C  
ATOM   3380  O   GLU B 168      42.133  41.494  43.346  1.00 54.04           O  
ATOM   3381  CB  GLU B 168      40.173  42.874  41.566  1.00 53.31           C  
ATOM   3382  CG  GLU B 168      38.715  43.349  41.395  1.00 56.64           C  
ATOM   3383  CD  GLU B 168      38.104  42.856  40.094  1.00 63.42           C  
ATOM   3384  OE1 GLU B 168      38.860  42.623  39.100  1.00 61.05           O  
ATOM   3385  OE2 GLU B 168      36.860  42.687  40.074  1.00 67.22           O  
ATOM   3386  N   ILE B 169      42.606  40.484  41.412  1.00 52.19           N  
ATOM   3387  CA  ILE B 169      43.926  40.234  41.843  1.00 52.44           C  
ATOM   3388  C   ILE B 169      44.827  41.054  40.996  1.00 53.84           C  
ATOM   3389  O   ILE B 169      44.736  41.009  39.773  1.00 54.97           O  
ATOM   3390  CB  ILE B 169      44.298  38.735  41.690  1.00 52.52           C  
ATOM   3391  CG1 ILE B 169      43.259  37.851  42.398  1.00 50.50           C  
ATOM   3392  CG2 ILE B 169      45.756  38.491  42.159  1.00 50.66           C  
ATOM   3393  CD1 ILE B 169      43.146  38.113  43.924  1.00 51.65           C  
ATOM   3394  N   GLU B 170      45.720  41.803  41.613  1.00 54.37           N  
ATOM   3395  CA  GLU B 170      46.547  42.611  40.795  1.00 55.60           C  
ATOM   3396  C   GLU B 170      47.964  42.106  40.762  1.00 55.49           C  
ATOM   3397  O   GLU B 170      48.569  41.798  41.796  1.00 56.45           O  
ATOM   3398  CB  GLU B 170      46.492  44.087  41.203  1.00 56.75           C  
ATOM   3399  CG  GLU B 170      47.140  45.009  40.133  1.00 60.62           C  
ATOM   3400  CD  GLU B 170      47.532  46.347  40.697  1.00 65.40           C  
ATOM   3401  OE1 GLU B 170      46.841  47.333  40.380  1.00 64.02           O  
ATOM   3402  OE2 GLU B 170      48.518  46.392  41.478  1.00 68.64           O  
ATOM   3403  N   THR B 171      48.489  41.994  39.561  1.00 54.36           N  
ATOM   3404  CA  THR B 171      49.875  41.743  39.442  1.00 53.95           C  
ATOM   3405  C   THR B 171      50.511  42.894  38.747  1.00 53.94           C  
ATOM   3406  O   THR B 171      49.938  43.928  38.496  1.00 55.22           O  
ATOM   3407  CB  THR B 171      50.203  40.432  38.662  1.00 54.04           C  
ATOM   3408  OG1 THR B 171      50.085  40.641  37.243  1.00 55.59           O  
ATOM   3409  CG2 THR B 171      49.311  39.287  39.111  1.00 50.83           C  
ATOM   3410  N   ASP B 172      51.735  42.636  38.459  1.00 54.24           N  
ATOM   3411  CA  ASP B 172      52.671  43.374  37.691  1.00 55.61           C  
ATOM   3412  C   ASP B 172      52.286  43.470  36.178  1.00 55.31           C  
ATOM   3413  O   ASP B 172      52.806  44.321  35.419  1.00 54.75           O  
ATOM   3414  CB  ASP B 172      53.821  42.379  37.775  1.00 56.64           C  
ATOM   3415  CG  ASP B 172      55.070  42.951  37.469  1.00 58.79           C  
ATOM   3416  OD1 ASP B 172      55.899  42.196  36.966  1.00 63.92           O  
ATOM   3417  OD2 ASP B 172      55.224  44.140  37.726  1.00 64.64           O  
ATOM   3418  N   LYS B 173      51.430  42.528  35.763  1.00 53.75           N  
ATOM   3419  CA  LYS B 173      51.107  42.277  34.367  1.00 52.46           C  
ATOM   3420  C   LYS B 173      49.687  42.666  34.048  1.00 51.74           C  
ATOM   3421  O   LYS B 173      49.389  43.013  32.890  1.00 52.00           O  
ATOM   3422  CB  LYS B 173      51.292  40.790  34.006  1.00 52.36           C  
ATOM   3423  CG  LYS B 173      52.724  40.261  34.218  1.00 51.42           C  
ATOM   3424  CD  LYS B 173      53.768  41.213  33.613  1.00 51.34           C  
ATOM   3425  CE  LYS B 173      53.661  41.145  32.091  1.00 53.04           C  
ATOM   3426  NZ  LYS B 173      54.459  42.194  31.451  1.00 49.22           N  
ATOM   3427  N   ALA B 174      48.811  42.611  35.049  1.00 49.58           N  
ATOM   3428  CA  ALA B 174      47.416  42.723  34.735  1.00 48.64           C  
ATOM   3429  C   ALA B 174      46.582  42.870  36.009  1.00 48.56           C  
ATOM   3430  O   ALA B 174      47.117  42.685  37.108  1.00 49.68           O  
ATOM   3431  CB  ALA B 174      46.993  41.536  33.898  1.00 46.95           C  
ATOM   3432  N   THR B 175      45.318  43.265  35.865  1.00 46.88           N  
ATOM   3433  CA  THR B 175      44.357  43.225  36.947  1.00 46.70           C  
ATOM   3434  C   THR B 175      43.363  42.165  36.508  1.00 47.22           C  
ATOM   3435  O   THR B 175      42.781  42.302  35.439  1.00 48.05           O  
ATOM   3436  CB  THR B 175      43.613  44.602  37.142  1.00 46.40           C  
ATOM   3437  OG1 THR B 175      44.571  45.645  37.352  1.00 46.71           O  
ATOM   3438  CG2 THR B 175      42.635  44.580  38.303  1.00 41.30           C  
ATOM   3439  N   ILE B 176      43.145  41.141  37.339  1.00 46.56           N  
ATOM   3440  CA  ILE B 176      42.552  39.886  36.893  1.00 46.25           C  
ATOM   3441  C   ILE B 176      41.331  39.636  37.706  1.00 46.64           C  
ATOM   3442  O   ILE B 176      41.389  39.724  38.932  1.00 47.97           O  
ATOM   3443  CB  ILE B 176      43.547  38.675  37.116  1.00 46.42           C  
ATOM   3444  CG1 ILE B 176      44.817  38.882  36.272  1.00 45.49           C  
ATOM   3445  CG2 ILE B 176      42.839  37.347  36.857  1.00 45.01           C  
ATOM   3446  CD1 ILE B 176      45.900  37.840  36.427  1.00 47.19           C  
ATOM   3447  N   GLY B 177      40.215  39.343  37.056  1.00 46.58           N  
ATOM   3448  CA  GLY B 177      39.003  38.985  37.786  1.00 47.55           C  
ATOM   3449  C   GLY B 177      39.137  37.509  38.152  1.00 49.04           C  
ATOM   3450  O   GLY B 177      39.151  36.644  37.283  1.00 48.11           O  
ATOM   3451  N   PHE B 178      39.294  37.232  39.445  1.00 50.01           N  
ATOM   3452  CA  PHE B 178      39.410  35.877  39.938  1.00 50.62           C  
ATOM   3453  C   PHE B 178      38.020  35.293  40.157  1.00 50.56           C  
ATOM   3454  O   PHE B 178      37.195  35.879  40.867  1.00 49.76           O  
ATOM   3455  CB  PHE B 178      40.290  35.886  41.188  1.00 50.94           C  
ATOM   3456  CG  PHE B 178      40.487  34.550  41.811  1.00 55.11           C  
ATOM   3457  CD1 PHE B 178      40.717  33.401  41.021  1.00 57.67           C  
ATOM   3458  CD2 PHE B 178      40.448  34.415  43.204  1.00 56.09           C  
ATOM   3459  CE1 PHE B 178      40.879  32.129  41.617  1.00 55.77           C  
ATOM   3460  CE2 PHE B 178      40.620  33.159  43.792  1.00 56.07           C  
ATOM   3461  CZ  PHE B 178      40.829  32.013  42.989  1.00 55.40           C  
ATOM   3462  N   GLU B 179      37.733  34.160  39.514  1.00 51.35           N  
ATOM   3463  CA  GLU B 179      36.374  33.563  39.616  1.00 52.86           C  
ATOM   3464  C   GLU B 179      36.201  32.437  40.663  1.00 53.74           C  
ATOM   3465  O   GLU B 179      37.079  31.598  40.853  1.00 54.28           O  
ATOM   3466  CB  GLU B 179      35.893  33.082  38.232  1.00 52.47           C  
ATOM   3467  CG  GLU B 179      35.500  34.233  37.274  1.00 56.44           C  
ATOM   3468  CD  GLU B 179      35.402  33.833  35.779  1.00 61.99           C  
ATOM   3469  OE1 GLU B 179      35.923  32.757  35.402  1.00 64.86           O  
ATOM   3470  OE2 GLU B 179      34.794  34.602  34.977  1.00 61.83           O  
ATOM   3471  N   VAL B 180      35.062  32.412  41.336  1.00 55.02           N  
ATOM   3472  CA  VAL B 180      34.645  31.228  42.098  1.00 56.45           C  
ATOM   3473  C   VAL B 180      34.723  29.975  41.236  1.00 57.31           C  
ATOM   3474  O   VAL B 180      33.974  29.848  40.263  1.00 56.68           O  
ATOM   3475  CB  VAL B 180      33.141  31.313  42.502  1.00 56.36           C  
ATOM   3476  CG1 VAL B 180      32.665  30.018  43.090  1.00 56.10           C  
ATOM   3477  CG2 VAL B 180      32.872  32.449  43.433  1.00 57.18           C  
ATOM   3478  N   GLN B 181      35.591  29.037  41.612  1.00 59.52           N  
ATOM   3479  CA  GLN B 181      35.626  27.698  40.975  1.00 61.55           C  
ATOM   3480  C   GLN B 181      34.625  26.637  41.504  1.00 63.24           C  
ATOM   3481  O   GLN B 181      34.334  25.662  40.816  1.00 63.20           O  
ATOM   3482  CB  GLN B 181      37.044  27.158  40.968  1.00 61.25           C  
ATOM   3483  CG  GLN B 181      38.045  28.038  40.211  1.00 63.04           C  
ATOM   3484  CD  GLN B 181      39.208  28.506  41.103  1.00 64.98           C  
ATOM   3485  OE1 GLN B 181      38.994  29.037  42.224  1.00 65.58           O  
ATOM   3486  NE2 GLN B 181      40.441  28.311  40.617  1.00 62.49           N  
ATOM   3487  N   GLU B 182      34.079  26.807  42.709  1.00 65.59           N  
ATOM   3488  CA  GLU B 182      33.158  25.782  43.239  1.00 68.11           C  
ATOM   3489  C   GLU B 182      32.057  26.398  44.044  1.00 68.59           C  
ATOM   3490  O   GLU B 182      32.277  27.349  44.785  1.00 68.99           O  
ATOM   3491  CB  GLU B 182      33.885  24.689  44.057  1.00 68.70           C  
ATOM   3492  CG  GLU B 182      34.877  25.214  45.091  1.00 71.70           C  
ATOM   3493  CD  GLU B 182      36.100  25.872  44.447  1.00 75.99           C  
ATOM   3494  OE1 GLU B 182      36.847  25.165  43.713  1.00 75.54           O  
ATOM   3495  OE2 GLU B 182      36.294  27.104  44.658  1.00 78.33           O  
ATOM   3496  N   GLU B 183      30.866  25.846  43.908  1.00 69.42           N  
ATOM   3497  CA  GLU B 183      29.738  26.503  44.504  1.00 71.01           C  
ATOM   3498  C   GLU B 183      29.620  26.265  46.013  1.00 70.48           C  
ATOM   3499  O   GLU B 183      30.092  25.257  46.518  1.00 70.20           O  
ATOM   3500  CB  GLU B 183      28.462  26.216  43.720  1.00 72.21           C  
ATOM   3501  CG  GLU B 183      27.763  24.915  44.011  1.00 76.10           C  
ATOM   3502  CD  GLU B 183      26.396  24.912  43.338  1.00 81.21           C  
ATOM   3503  OE1 GLU B 183      26.275  24.264  42.266  1.00 83.05           O  
ATOM   3504  OE2 GLU B 183      25.467  25.605  43.851  1.00 81.39           O  
ATOM   3505  N   GLY B 184      29.042  27.235  46.721  1.00 70.16           N  
ATOM   3506  CA  GLY B 184      28.974  27.212  48.182  1.00 68.84           C  
ATOM   3507  C   GLY B 184      28.441  28.494  48.792  1.00 68.03           C  
ATOM   3508  O   GLY B 184      27.449  29.048  48.299  1.00 68.06           O  
ATOM   3509  N   TYR B 185      29.091  28.932  49.881  1.00 66.95           N  
ATOM   3510  CA  TYR B 185      28.759  30.145  50.625  1.00 66.12           C  
ATOM   3511  C   TYR B 185      30.067  30.653  51.175  1.00 66.25           C  
ATOM   3512  O   TYR B 185      30.892  29.858  51.631  1.00 66.72           O  
ATOM   3513  CB  TYR B 185      27.779  29.862  51.788  1.00 65.85           C  
ATOM   3514  CG  TYR B 185      26.359  29.563  51.348  1.00 64.66           C  
ATOM   3515  CD1 TYR B 185      26.002  28.283  50.947  1.00 63.49           C  
ATOM   3516  CD2 TYR B 185      25.375  30.575  51.310  1.00 66.10           C  
ATOM   3517  CE1 TYR B 185      24.709  27.984  50.507  1.00 65.75           C  
ATOM   3518  CE2 TYR B 185      24.062  30.300  50.871  1.00 66.05           C  
ATOM   3519  CZ  TYR B 185      23.733  28.983  50.470  1.00 67.65           C  
ATOM   3520  OH  TYR B 185      22.452  28.631  50.025  1.00 67.67           O  
ATOM   3521  N   LEU B 186      30.295  31.961  51.122  1.00 66.57           N  
ATOM   3522  CA  LEU B 186      31.556  32.481  51.658  1.00 67.45           C  
ATOM   3523  C   LEU B 186      31.512  32.405  53.193  1.00 68.35           C  
ATOM   3524  O   LEU B 186      30.624  33.014  53.835  1.00 68.36           O  
ATOM   3525  CB  LEU B 186      31.806  33.925  51.227  1.00 67.16           C  
ATOM   3526  CG  LEU B 186      33.217  34.420  50.886  1.00 66.32           C  
ATOM   3527  CD1 LEU B 186      33.280  35.904  51.065  1.00 65.98           C  
ATOM   3528  CD2 LEU B 186      34.363  33.806  51.644  1.00 67.79           C  
ATOM   3529  N   ALA B 187      32.463  31.666  53.768  1.00 68.46           N  
ATOM   3530  CA  ALA B 187      32.507  31.458  55.220  1.00 68.51           C  
ATOM   3531  C   ALA B 187      33.383  32.474  55.917  1.00 68.79           C  
ATOM   3532  O   ALA B 187      33.021  32.963  56.979  1.00 69.16           O  
ATOM   3533  CB  ALA B 187      32.976  30.046  55.559  1.00 68.29           C  
ATOM   3534  N   LYS B 188      34.541  32.783  55.338  1.00 68.69           N  
ATOM   3535  CA  LYS B 188      35.455  33.707  55.981  1.00 68.58           C  
ATOM   3536  C   LYS B 188      36.502  34.176  55.003  1.00 67.96           C  
ATOM   3537  O   LYS B 188      36.921  33.420  54.139  1.00 68.33           O  
ATOM   3538  CB  LYS B 188      36.141  33.038  57.171  1.00 69.17           C  
ATOM   3539  CG  LYS B 188      37.385  33.791  57.673  1.00 71.86           C  
ATOM   3540  CD  LYS B 188      37.625  33.595  59.165  1.00 75.95           C  
ATOM   3541  CE  LYS B 188      38.228  34.847  59.796  1.00 78.22           C  
ATOM   3542  NZ  LYS B 188      37.135  35.661  60.413  1.00 79.64           N  
ATOM   3543  N   ILE B 189      36.936  35.417  55.175  1.00 66.97           N  
ATOM   3544  CA  ILE B 189      38.004  35.993  54.402  1.00 66.28           C  
ATOM   3545  C   ILE B 189      39.328  35.924  55.179  1.00 66.41           C  
ATOM   3546  O   ILE B 189      39.523  36.623  56.171  1.00 66.79           O  
ATOM   3547  CB  ILE B 189      37.644  37.447  54.013  1.00 66.07           C  
ATOM   3548  CG1 ILE B 189      36.411  37.456  53.098  1.00 65.69           C  
ATOM   3549  CG2 ILE B 189      38.863  38.188  53.408  1.00 65.47           C  
ATOM   3550  CD1 ILE B 189      35.827  38.847  52.806  1.00 65.93           C  
ATOM   3551  N   LEU B 190      40.237  35.076  54.726  1.00 66.33           N  
ATOM   3552  CA  LEU B 190      41.538  34.908  55.362  1.00 66.22           C  
ATOM   3553  C   LEU B 190      42.538  35.962  54.958  1.00 67.25           C  
ATOM   3554  O   LEU B 190      43.569  36.106  55.623  1.00 67.17           O  
ATOM   3555  CB  LEU B 190      42.151  33.584  54.946  1.00 66.05           C  
ATOM   3556  CG  LEU B 190      41.709  32.255  55.533  1.00 64.85           C  
ATOM   3557  CD1 LEU B 190      40.220  32.115  55.559  1.00 65.65           C  
ATOM   3558  CD2 LEU B 190      42.329  31.183  54.686  1.00 60.91           C  
ATOM   3559  N   VAL B 191      42.310  36.626  53.818  1.00 68.11           N  
ATOM   3560  CA  VAL B 191      43.227  37.691  53.371  1.00 68.90           C  
ATOM   3561  C   VAL B 191      42.444  38.973  53.062  1.00 70.20           C  
ATOM   3562  O   VAL B 191      41.478  38.949  52.272  1.00 70.83           O  
ATOM   3563  CB  VAL B 191      44.126  37.273  52.203  1.00 68.25           C  
ATOM   3564  CG1 VAL B 191      44.968  38.438  51.742  1.00 68.73           C  
ATOM   3565  CG2 VAL B 191      45.044  36.148  52.613  1.00 67.44           C  
ATOM   3566  N   PRO B 192      42.803  40.084  53.732  1.00 70.67           N  
ATOM   3567  CA  PRO B 192      41.971  41.276  53.510  1.00 70.72           C  
ATOM   3568  C   PRO B 192      42.404  42.114  52.305  1.00 70.24           C  
ATOM   3569  O   PRO B 192      43.587  42.105  51.908  1.00 69.23           O  
ATOM   3570  CB  PRO B 192      42.090  42.062  54.837  1.00 70.49           C  
ATOM   3571  CG  PRO B 192      43.222  41.397  55.612  1.00 71.42           C  
ATOM   3572  CD  PRO B 192      43.856  40.330  54.730  1.00 70.95           C  
ATOM   3573  N   GLU B 193      41.410  42.804  51.733  1.00 70.18           N  
ATOM   3574  CA  GLU B 193      41.606  43.794  50.678  1.00 70.13           C  
ATOM   3575  C   GLU B 193      42.877  44.553  50.928  1.00 69.52           C  
ATOM   3576  O   GLU B 193      43.133  44.936  52.049  1.00 71.11           O  
ATOM   3577  CB  GLU B 193      40.476  44.803  50.708  1.00 70.09           C  
ATOM   3578  CG  GLU B 193      39.087  44.224  50.550  1.00 72.67           C  
ATOM   3579  CD  GLU B 193      38.200  45.114  49.697  1.00 75.85           C  
ATOM   3580  OE1 GLU B 193      38.496  46.331  49.616  1.00 78.50           O  
ATOM   3581  OE2 GLU B 193      37.222  44.610  49.097  1.00 75.81           O  
ATOM   3582  N   GLY B 194      43.685  44.779  49.917  1.00 68.35           N  
ATOM   3583  CA  GLY B 194      44.831  45.622  50.114  1.00 67.43           C  
ATOM   3584  C   GLY B 194      46.087  44.841  50.385  1.00 67.71           C  
ATOM   3585  O   GLY B 194      47.193  45.334  50.091  1.00 67.73           O  
ATOM   3586  N   THR B 195      45.961  43.629  50.935  1.00 67.42           N  
ATOM   3587  CA  THR B 195      47.176  42.849  51.172  1.00 67.25           C  
ATOM   3588  C   THR B 195      47.933  42.700  49.859  1.00 67.58           C  
ATOM   3589  O   THR B 195      47.427  42.113  48.913  1.00 67.25           O  
ATOM   3590  CB  THR B 195      46.938  41.432  51.726  1.00 67.02           C  
ATOM   3591  OG1 THR B 195      45.973  41.462  52.773  1.00 66.46           O  
ATOM   3592  CG2 THR B 195      48.267  40.846  52.224  1.00 65.36           C  
ATOM   3593  N   ARG B 196      49.145  43.221  49.818  1.00 68.06           N  
ATOM   3594  CA  ARG B 196      49.977  43.106  48.638  1.00 69.27           C  
ATOM   3595  C   ARG B 196      50.778  41.806  48.614  1.00 69.71           C  
ATOM   3596  O   ARG B 196      50.833  41.085  49.606  1.00 70.10           O  
ATOM   3597  CB  ARG B 196      50.913  44.302  48.574  1.00 69.16           C  
ATOM   3598  CG  ARG B 196      50.154  45.620  48.635  1.00 71.46           C  
ATOM   3599  CD  ARG B 196      51.113  46.793  48.567  1.00 76.65           C  
ATOM   3600  NE  ARG B 196      52.066  46.654  47.463  1.00 78.88           N  
ATOM   3601  CZ  ARG B 196      51.815  47.042  46.217  1.00 80.80           C  
ATOM   3602  NH1 ARG B 196      50.641  47.607  45.916  1.00 79.32           N  
ATOM   3603  NH2 ARG B 196      52.743  46.867  45.277  1.00 81.75           N  
ATOM   3604  N   ASP B 197      51.358  41.501  47.458  1.00 69.73           N  
ATOM   3605  CA  ASP B 197      52.337  40.429  47.304  1.00 69.63           C  
ATOM   3606  C   ASP B 197      52.019  39.053  47.895  1.00 68.37           C  
ATOM   3607  O   ASP B 197      52.936  38.242  48.112  1.00 68.91           O  
ATOM   3608  CB  ASP B 197      53.708  40.923  47.762  1.00 70.38           C  
ATOM   3609  CG  ASP B 197      54.209  42.083  46.921  1.00 73.83           C  
ATOM   3610  OD1 ASP B 197      53.592  42.361  45.865  1.00 75.51           O  
ATOM   3611  OD2 ASP B 197      55.215  42.727  47.315  1.00 77.31           O  
ATOM   3612  N   VAL B 198      50.739  38.768  48.116  1.00 66.28           N  
ATOM   3613  CA  VAL B 198      50.301  37.434  48.538  1.00 64.67           C  
ATOM   3614  C   VAL B 198      50.908  36.326  47.647  1.00 64.65           C  
ATOM   3615  O   VAL B 198      50.740  36.373  46.438  1.00 65.31           O  
ATOM   3616  CB  VAL B 198      48.798  37.345  48.497  1.00 63.89           C  
ATOM   3617  CG1 VAL B 198      48.344  36.015  48.981  1.00 63.72           C  
ATOM   3618  CG2 VAL B 198      48.194  38.465  49.323  1.00 62.99           C  
ATOM   3619  N   PRO B 199      51.655  35.348  48.230  1.00 64.26           N  
ATOM   3620  CA  PRO B 199      52.304  34.316  47.377  1.00 62.91           C  
ATOM   3621  C   PRO B 199      51.331  33.256  46.912  1.00 61.84           C  
ATOM   3622  O   PRO B 199      50.251  33.129  47.463  1.00 60.82           O  
ATOM   3623  CB  PRO B 199      53.357  33.682  48.309  1.00 63.21           C  
ATOM   3624  CG  PRO B 199      53.347  34.539  49.582  1.00 63.15           C  
ATOM   3625  CD  PRO B 199      51.990  35.154  49.657  1.00 63.69           C  
ATOM   3626  N   LEU B 200      51.720  32.508  45.887  1.00 61.66           N  
ATOM   3627  CA  LEU B 200      50.879  31.442  45.356  1.00 61.59           C  
ATOM   3628  C   LEU B 200      50.626  30.456  46.478  1.00 61.60           C  
ATOM   3629  O   LEU B 200      51.477  30.301  47.356  1.00 62.44           O  
ATOM   3630  CB  LEU B 200      51.598  30.719  44.203  1.00 61.55           C  
ATOM   3631  CG  LEU B 200      52.208  31.484  43.024  1.00 60.75           C  
ATOM   3632  CD1 LEU B 200      52.724  30.492  41.981  1.00 57.78           C  
ATOM   3633  CD2 LEU B 200      51.209  32.427  42.394  1.00 60.56           C  
ATOM   3634  N   GLY B 201      49.491  29.773  46.453  1.00 61.13           N  
ATOM   3635  CA  GLY B 201      49.188  28.797  47.485  1.00 61.10           C  
ATOM   3636  C   GLY B 201      48.574  29.400  48.751  1.00 61.63           C  
ATOM   3637  O   GLY B 201      47.806  28.711  49.446  1.00 61.62           O  
ATOM   3638  N   THR B 202      48.876  30.664  49.065  1.00 60.98           N  
ATOM   3639  CA  THR B 202      48.265  31.272  50.237  1.00 61.76           C  
ATOM   3640  C   THR B 202      46.752  31.047  50.236  1.00 62.05           C  
ATOM   3641  O   THR B 202      46.093  31.331  49.240  1.00 63.08           O  
ATOM   3642  CB  THR B 202      48.528  32.793  50.359  1.00 61.99           C  
ATOM   3643  OG1 THR B 202      49.938  33.072  50.345  1.00 62.29           O  
ATOM   3644  CG2 THR B 202      47.922  33.319  51.646  1.00 60.66           C  
ATOM   3645  N   PRO B 203      46.200  30.500  51.329  1.00 62.02           N  
ATOM   3646  CA  PRO B 203      44.746  30.413  51.438  1.00 61.96           C  
ATOM   3647  C   PRO B 203      44.175  31.805  51.551  1.00 62.46           C  
ATOM   3648  O   PRO B 203      44.808  32.672  52.169  1.00 63.09           O  
ATOM   3649  CB  PRO B 203      44.525  29.657  52.754  1.00 61.74           C  
ATOM   3650  CG  PRO B 203      45.800  28.962  53.031  1.00 62.34           C  
ATOM   3651  CD  PRO B 203      46.875  29.881  52.483  1.00 62.12           C  
ATOM   3652  N   LEU B 204      42.996  32.018  50.959  1.00 62.29           N  
ATOM   3653  CA  LEU B 204      42.453  33.362  50.787  1.00 61.87           C  
ATOM   3654  C   LEU B 204      41.132  33.508  51.463  1.00 61.27           C  
ATOM   3655  O   LEU B 204      40.772  34.598  51.889  1.00 60.92           O  
ATOM   3656  CB  LEU B 204      42.248  33.673  49.298  1.00 62.13           C  
ATOM   3657  CG  LEU B 204      43.497  33.850  48.448  1.00 62.15           C  
ATOM   3658  CD1 LEU B 204      43.065  33.936  46.990  1.00 62.04           C  
ATOM   3659  CD2 LEU B 204      44.250  35.087  48.879  1.00 60.29           C  
ATOM   3660  N   CYS B 205      40.390  32.417  51.512  1.00 60.58           N  
ATOM   3661  CA  CYS B 205      39.093  32.429  52.121  1.00 61.27           C  
ATOM   3662  C   CYS B 205      38.605  30.995  52.268  1.00 62.16           C  
ATOM   3663  O   CYS B 205      39.226  30.064  51.753  1.00 62.20           O  
ATOM   3664  CB  CYS B 205      38.116  33.265  51.284  1.00 61.61           C  
ATOM   3665  SG  CYS B 205      38.039  32.829  49.514  1.00 61.57           S  
ATOM   3666  N   ILE B 206      37.486  30.822  52.962  1.00 63.29           N  
ATOM   3667  CA  ILE B 206      36.935  29.507  53.197  1.00 65.03           C  
ATOM   3668  C   ILE B 206      35.539  29.456  52.620  1.00 66.19           C  
ATOM   3669  O   ILE B 206      34.794  30.428  52.724  1.00 66.26           O  
ATOM   3670  CB  ILE B 206      36.920  29.174  54.720  1.00 65.19           C  
ATOM   3671  CG1 ILE B 206      38.348  28.965  55.215  1.00 66.20           C  
ATOM   3672  CG2 ILE B 206      36.107  27.935  55.014  1.00 64.84           C  
ATOM   3673  CD1 ILE B 206      38.553  29.327  56.670  1.00 69.37           C  
ATOM   3674  N   ILE B 207      35.198  28.317  52.023  1.00 67.68           N  
ATOM   3675  CA  ILE B 207      33.909  28.117  51.393  1.00 69.72           C  
ATOM   3676  C   ILE B 207      33.256  26.925  52.039  1.00 71.41           C  
ATOM   3677  O   ILE B 207      33.899  25.907  52.268  1.00 71.37           O  
ATOM   3678  CB  ILE B 207      34.059  27.836  49.865  1.00 69.42           C  
ATOM   3679  CG1 ILE B 207      34.302  29.130  49.087  1.00 68.38           C  
ATOM   3680  CG2 ILE B 207      32.844  27.068  49.302  1.00 68.92           C  
ATOM   3681  CD1 ILE B 207      34.695  28.892  47.600  1.00 67.72           C  
ATOM   3682  N   VAL B 208      31.966  27.040  52.279  1.00 73.80           N  
ATOM   3683  CA  VAL B 208      31.235  26.021  52.981  1.00 76.76           C  
ATOM   3684  C   VAL B 208      30.063  25.633  52.120  1.00 79.14           C  
ATOM   3685  O   VAL B 208      29.516  26.466  51.392  1.00 79.22           O  
ATOM   3686  CB  VAL B 208      30.738  26.567  54.359  1.00 77.00           C  
ATOM   3687  CG1 VAL B 208      29.511  25.835  54.840  1.00 77.61           C  
ATOM   3688  CG2 VAL B 208      31.840  26.484  55.402  1.00 76.27           C  
ATOM   3689  N   GLU B 209      29.670  24.370  52.230  1.00 82.14           N  
ATOM   3690  CA  GLU B 209      28.562  23.828  51.472  1.00 85.11           C  
ATOM   3691  C   GLU B 209      27.223  24.431  51.886  1.00 86.51           C  
ATOM   3692  O   GLU B 209      26.429  24.813  51.021  1.00 87.00           O  
ATOM   3693  CB  GLU B 209      28.523  22.315  51.626  1.00 85.50           C  
ATOM   3694  CG  GLU B 209      27.579  21.627  50.653  1.00 89.09           C  
ATOM   3695  CD  GLU B 209      27.465  20.122  50.919  1.00 93.31           C  
ATOM   3696  OE1 GLU B 209      26.318  19.625  51.073  1.00 93.32           O  
ATOM   3697  OE2 GLU B 209      28.526  19.445  50.988  1.00 94.77           O  
ATOM   3698  N   LYS B 210      26.958  24.513  53.192  1.00 88.14           N  
ATOM   3699  CA  LYS B 210      25.649  25.010  53.668  1.00 89.58           C  
ATOM   3700  C   LYS B 210      25.710  26.259  54.559  1.00 90.21           C  
ATOM   3701  O   LYS B 210      26.641  26.423  55.347  1.00 90.05           O  
ATOM   3702  CB  LYS B 210      24.815  23.883  54.298  1.00 89.78           C  
ATOM   3703  CG  LYS B 210      23.697  23.394  53.364  1.00 91.39           C  
ATOM   3704  CD  LYS B 210      23.400  21.896  53.495  1.00 93.29           C  
ATOM   3705  CE  LYS B 210      22.119  21.535  52.726  1.00 93.91           C  
ATOM   3706  NZ  LYS B 210      22.136  20.127  52.237  1.00 92.94           N  
ATOM   3707  N   GLU B 211      24.712  27.130  54.438  1.00 91.15           N  
ATOM   3708  CA  GLU B 211      24.770  28.414  55.145  1.00 92.46           C  
ATOM   3709  C   GLU B 211      24.649  28.321  56.662  1.00 92.82           C  
ATOM   3710  O   GLU B 211      25.132  29.214  57.378  1.00 92.90           O  
ATOM   3711  CB  GLU B 211      23.782  29.432  54.584  1.00 92.80           C  
ATOM   3712  CG  GLU B 211      22.351  28.951  54.408  1.00 94.46           C  
ATOM   3713  CD  GLU B 211      21.515  30.012  53.712  1.00 96.18           C  
ATOM   3714  OE1 GLU B 211      21.819  31.215  53.895  1.00 96.87           O  
ATOM   3715  OE2 GLU B 211      20.577  29.653  52.967  1.00 96.92           O  
ATOM   3716  N   ALA B 212      24.017  27.247  57.145  1.00 93.18           N  
ATOM   3717  CA  ALA B 212      24.045  26.900  58.580  1.00 93.42           C  
ATOM   3718  C   ALA B 212      25.474  27.000  59.173  1.00 93.41           C  
ATOM   3719  O   ALA B 212      25.675  27.549  60.266  1.00 93.35           O  
ATOM   3720  CB  ALA B 212      23.460  25.494  58.794  1.00 93.27           C  
ATOM   3721  N   ASP B 213      26.448  26.513  58.399  1.00 93.40           N  
ATOM   3722  CA  ASP B 213      27.841  26.346  58.809  1.00 93.33           C  
ATOM   3723  C   ASP B 213      28.716  27.600  58.752  1.00 93.46           C  
ATOM   3724  O   ASP B 213      29.910  27.532  59.071  1.00 93.39           O  
ATOM   3725  CB  ASP B 213      28.501  25.262  57.946  1.00 93.37           C  
ATOM   3726  CG  ASP B 213      27.698  23.976  57.891  1.00 93.81           C  
ATOM   3727  OD1 ASP B 213      27.534  23.347  58.949  1.00 94.71           O  
ATOM   3728  OD2 ASP B 213      27.238  23.584  56.794  1.00 93.93           O  
ATOM   3729  N   ILE B 214      28.161  28.736  58.338  1.00 93.57           N  
ATOM   3730  CA  ILE B 214      28.981  29.947  58.242  1.00 93.91           C  
ATOM   3731  C   ILE B 214      29.387  30.437  59.631  1.00 94.10           C  
ATOM   3732  O   ILE B 214      30.527  30.880  59.829  1.00 93.71           O  
ATOM   3733  CB  ILE B 214      28.276  31.092  57.483  1.00 94.05           C  
ATOM   3734  CG1 ILE B 214      27.701  30.593  56.160  1.00 93.97           C  
ATOM   3735  CG2 ILE B 214      29.251  32.256  57.258  1.00 93.93           C  
ATOM   3736  CD1 ILE B 214      26.686  31.533  55.540  1.00 94.98           C  
ATOM   3737  N   SER B 215      28.434  30.351  60.569  1.00 94.51           N  
ATOM   3738  CA  SER B 215      28.619  30.730  61.980  1.00 94.67           C  
ATOM   3739  C   SER B 215      29.856  30.073  62.593  1.00 94.71           C  
ATOM   3740  O   SER B 215      30.722  30.760  63.141  1.00 94.55           O  
ATOM   3741  CB  SER B 215      27.350  30.421  62.807  1.00 94.69           C  
ATOM   3742  OG  SER B 215      26.517  29.461  62.170  1.00 93.72           O  
ATOM   3743  N   ALA B 216      29.952  28.753  62.440  1.00 94.90           N  
ATOM   3744  CA  ALA B 216      31.062  27.955  62.977  1.00 95.26           C  
ATOM   3745  C   ALA B 216      32.470  28.490  62.687  1.00 95.73           C  
ATOM   3746  O   ALA B 216      33.461  28.030  63.272  1.00 95.72           O  
ATOM   3747  CB  ALA B 216      30.945  26.535  62.484  1.00 94.99           C  
ATOM   3748  N   PHE B 217      32.550  29.467  61.790  1.00 96.59           N  
ATOM   3749  CA  PHE B 217      33.829  29.919  61.241  1.00 97.11           C  
ATOM   3750  C   PHE B 217      34.232  31.322  61.648  1.00 98.96           C  
ATOM   3751  O   PHE B 217      35.382  31.723  61.422  1.00 99.15           O  
ATOM   3752  CB  PHE B 217      33.841  29.777  59.720  1.00 96.04           C  
ATOM   3753  CG  PHE B 217      34.083  28.377  59.258  1.00 91.70           C  
ATOM   3754  CD1 PHE B 217      33.017  27.551  58.917  1.00 87.77           C  
ATOM   3755  CD2 PHE B 217      35.378  27.870  59.193  1.00 87.92           C  
ATOM   3756  CE1 PHE B 217      33.236  26.242  58.502  1.00 85.07           C  
ATOM   3757  CE2 PHE B 217      35.605  26.564  58.780  1.00 85.32           C  
ATOM   3758  CZ  PHE B 217      34.531  25.751  58.430  1.00 84.30           C  
ATOM   3759  N   ALA B 218      33.295  32.056  62.253  1.00101.09           N  
ATOM   3760  CA  ALA B 218      33.600  33.349  62.873  1.00103.02           C  
ATOM   3761  C   ALA B 218      34.561  33.140  64.057  1.00104.39           C  
ATOM   3762  O   ALA B 218      34.834  34.063  64.826  1.00104.78           O  
ATOM   3763  CB  ALA B 218      32.306  34.062  63.307  1.00102.76           C  
ATOM   3764  N   ASP B 219      35.086  31.915  64.161  1.00106.22           N  
ATOM   3765  CA  ASP B 219      35.957  31.467  65.256  1.00107.78           C  
ATOM   3766  C   ASP B 219      37.399  31.241  64.805  1.00108.46           C  
ATOM   3767  O   ASP B 219      37.924  30.133  64.960  1.00108.69           O  
ATOM   3768  CB  ASP B 219      35.427  30.139  65.832  1.00108.01           C  
ATOM   3769  CG  ASP B 219      34.092  30.289  66.558  1.00108.68           C  
ATOM   3770  OD1 ASP B 219      33.783  31.401  67.053  1.00109.10           O  
ATOM   3771  OD2 ASP B 219      33.357  29.280  66.647  1.00108.58           O  
ATOM   3772  N   TYR B 220      38.050  32.272  64.273  1.00109.29           N  
ATOM   3773  CA  TYR B 220      39.368  32.070  63.677  1.00110.06           C  
ATOM   3774  C   TYR B 220      40.392  33.102  64.131  1.00110.11           C  
ATOM   3775  O   TYR B 220      41.576  32.979  63.819  1.00110.33           O  
ATOM   3776  CB  TYR B 220      39.247  32.090  62.157  1.00110.30           C  
ATOM   3777  CG  TYR B 220      39.983  30.981  61.434  1.00111.26           C  
ATOM   3778  CD1 TYR B 220      39.266  29.966  60.774  1.00111.18           C  
ATOM   3779  CD2 TYR B 220      41.393  30.952  61.382  1.00111.67           C  
ATOM   3780  CE1 TYR B 220      39.925  28.944  60.083  1.00111.56           C  
ATOM   3781  CE2 TYR B 220      42.070  29.929  60.690  1.00111.96           C  
ATOM   3782  CZ  TYR B 220      41.323  28.929  60.042  1.00111.88           C  
ATOM   3783  OH  TYR B 220      41.959  27.917  59.359  1.00110.85           O  
ATOM   3784  N   THR B 226      36.593  15.007  56.443  1.00116.93           N  
ATOM   3785  CA  THR B 226      36.286  15.077  55.025  1.00117.28           C  
ATOM   3786  C   THR B 226      34.962  14.366  54.678  1.00117.54           C  
ATOM   3787  O   THR B 226      34.936  13.409  53.891  1.00117.46           O  
ATOM   3788  CB  THR B 226      37.461  14.536  54.188  1.00117.05           C  
ATOM   3789  N   ASP B 227      33.864  14.836  55.279  1.00117.86           N  
ATOM   3790  CA  ASP B 227      32.507  14.482  54.821  1.00117.87           C  
ATOM   3791  C   ASP B 227      32.096  15.397  53.642  1.00117.87           C  
ATOM   3792  O   ASP B 227      30.909  15.489  53.297  1.00117.61           O  
ATOM   3793  CB  ASP B 227      31.494  14.560  55.982  1.00117.72           C  
ATOM   3794  N   LEU B 228      33.105  16.051  53.038  1.00117.96           N  
ATOM   3795  CA  LEU B 228      32.962  16.993  51.904  1.00117.96           C  
ATOM   3796  C   LEU B 228      32.916  16.322  50.521  1.00117.98           C  
ATOM   3797  O   LEU B 228      33.017  17.009  49.507  1.00118.22           O  
ATOM   3798  CB  LEU B 228      34.081  18.066  51.943  1.00117.56           C  
ATOM   3799  N   LYS B 229      32.749  14.993  50.495  1.00118.03           N  
ATOM   3800  CA  LYS B 229      32.704  14.163  49.269  1.00117.87           C  
ATOM   3801  C   LYS B 229      31.860  14.729  48.123  1.00117.89           C  
ATOM   3802  O   LYS B 229      32.303  14.766  46.969  1.00117.79           O  
ATOM   3803  CB  LYS B 229      32.236  12.743  49.612  1.00117.84           C  
TER    3804      LYS B 229                                                      
END
MOLECULE T0397_83_150.pdb
ATOM    717  N   LEU    83      35.835  21.935  54.102  1.00 33.12          
ATOM    718  CA  LEU    83      35.719  23.282  53.561  1.00 33.32          
ATOM    719  C   LEU    83      36.582  23.427  52.306  1.00 32.66          
ATOM    720  O   LEU    83      37.427  22.578  52.030  1.00 33.17          
ATOM    721  CB  LEU    83      36.184  24.314  54.588  1.00 33.05          
ATOM    722  CG  LEU    83      35.428  24.389  55.909  1.00 34.55          
ATOM    723  CD1 LEU    83      36.110  25.424  56.813  1.00 31.53          
ATOM    724  CD2 LEU    83      33.926  24.720  55.714  1.00 33.95          
ATOM    725  N   ILE    84      36.339  24.487  51.547  1.00 31.28          
ATOM    726  CA  ILE    84      37.113  24.815  50.390  1.00 31.86          
ATOM    727  C   ILE    84      37.899  26.128  50.688  1.00 31.86          
ATOM    728  O   ILE    84      37.374  27.068  51.262  1.00 30.84          
ATOM    729  CB  ILE    84      36.211  24.884  49.102  1.00 33.01          
ATOM    730  CG1 ILE    84      35.635  23.481  48.828  1.00 32.64          
ATOM    731  CG2 ILE    84      37.046  25.413  47.910  1.00 32.85          
ATOM    732  CD  ILE    84      34.896  23.257  47.596  1.00 34.41          
ATOM    733  N   SER    85      39.183  26.115  50.391  1.00 31.66          
ATOM    734  CA  SER    85      40.056  27.270  50.558  1.00 32.45          
ATOM    735  C   SER    85      40.379  27.753  49.179  1.00 30.88          
ATOM    736  O   SER    85      40.777  26.974  48.349  1.00 28.90          
ATOM    737  CB  SER    85      41.345  26.854  51.252  1.00 33.29          
ATOM    738  OG  SER    85      41.047  26.245  52.505  1.00 38.38          
ATOM    739  N   VAL    86      40.161  29.032  48.922  1.00 30.89          
ATOM    740  CA  VAL    86      40.406  29.618  47.617  1.00 30.18          
ATOM    741  C   VAL    86      41.432  30.751  47.751  1.00 30.50          
ATOM    742  O   VAL    86      41.128  31.827  48.263  1.00 29.45          
ATOM    743  CB  VAL    86      39.090  30.166  47.031  1.00 31.39          
ATOM    744  CG1 VAL    86      39.278  30.554  45.537  1.00 30.79          
ATOM    745  CG2 VAL    86      37.974  29.150  47.205  1.00 29.24          
ATOM    746  N   PRO    87      42.702  30.485  47.366  1.00 31.49          
ATOM    747  CA  PRO    87      43.702  31.557  47.420  1.00 30.98          
ATOM    748  C   PRO    87      43.541  32.615  46.290  1.00 30.90          
ATOM    749  O   PRO    87      43.077  32.315  45.202  1.00 29.79          
ATOM    750  CB  PRO    87      45.028  30.825  47.303  1.00 31.58          
ATOM    751  CG  PRO    87      44.693  29.422  46.847  1.00 32.96          
ATOM    752  CD  PRO    87      43.240  29.210  46.879  1.00 30.77          
ATOM    753  N   ALA    88      43.890  33.849  46.619  1.00 31.20          
ATOM    754  CA  ALA    88      43.874  34.986  45.725  1.00 31.18          
ATOM    755  C   ALA    88      45.284  35.570  45.884  1.00 31.56          
ATOM    756  O   ALA    88      45.555  36.263  46.864  1.00 31.99          
ATOM    757  CB  ALA    88      42.823  35.984  46.165  1.00 29.82          
ATOM    758  N   GLU    89      46.181  35.230  44.957  1.00 31.39          
ATOM    759  CA  GLU    89      47.591  35.660  44.994  1.00 31.91          
ATOM    760  C   GLU    89      48.000  36.444  43.779  1.00 31.08          
ATOM    761  O   GLU    89      47.752  36.021  42.661  1.00 32.28          
ATOM    762  CB  GLU    89      48.493  34.426  45.011  1.00 32.34          
ATOM    763  CG  GLU    89      48.251  33.502  46.184  1.00 35.65          
ATOM    764  CD  GLU    89      49.120  32.295  46.110  1.00 41.85          
ATOM    765  OE1 GLU    89      49.575  31.939  44.988  1.00 42.45          
ATOM    766  OE2 GLU    89      49.398  31.740  47.195  1.00 48.31          
ATOM    767  N   GLY    90      48.688  37.552  43.997  1.00 30.77          
ATOM    768  CA  GLY    90      49.163  38.409  42.917  1.00 30.21          
ATOM    769  C   GLY    90      49.928  39.585  43.484  1.00 30.04          
ATOM    770  O   GLY    90      49.980  39.771  44.709  1.00 30.76          
ATOM    771  N   TYR    91      50.541  40.360  42.604  1.00 29.01          
ATOM    772  CA  TYR    91      51.260  41.582  42.987  1.00 29.19          
ATOM    773  C   TYR    91      50.355  42.462  43.856  1.00 27.98          
ATOM    774  O   TYR    91      50.755  42.867  44.940  1.00 26.97          
ATOM    775  CB  TYR    91      51.788  42.315  41.750  1.00 28.63          
ATOM    776  CG  TYR    91      52.460  43.646  42.050  1.00 29.43          
ATOM    777  CD1 TYR    91      53.695  43.705  42.695  1.00 28.96          
ATOM    778  CD2 TYR    91      51.863  44.835  41.655  1.00 26.65          
ATOM    779  CE1 TYR    91      54.291  44.931  42.967  1.00 30.76          
ATOM    780  CE2 TYR    91      52.430  46.032  41.907  1.00 29.47          
ATOM    781  CZ  TYR    91      53.652  46.099  42.553  1.00 30.46          
ATOM    782  OH  TYR    91      54.196  47.339  42.759  1.00 29.11          
ATOM    783  N   LYS    92      49.133  42.689  43.373  1.00 27.98          
ATOM    784  CA  LYS    92      48.065  43.394  44.107  1.00 27.98          
ATOM    785  C   LYS    92      46.799  42.550  43.968  1.00 28.43          
ATOM    786  O   LYS    92      46.511  41.996  42.886  1.00 28.52          
ATOM    787  CB  LYS    92      47.799  44.807  43.567  1.00 28.07          
ATOM    788  CG  LYS    92      48.955  45.746  43.679  1.00 28.03          
ATOM    789  CD  LYS    92      48.737  47.040  42.914  1.00 28.62          
ATOM    790  CE  LYS    92      47.732  47.975  43.550  1.00 28.71          
ATOM    791  NZ  LYS    92      47.496  49.146  42.668  1.00 27.15          
ATOM    792  N   VAL    93      46.070  42.427  45.066  1.00 28.48          
ATOM    793  CA  VAL    93      44.861  41.611  45.110  1.00 28.35          
ATOM    794  C   VAL    93      43.738  42.456  45.613  1.00 28.50          
ATOM    795  O   VAL    93      43.891  43.173  46.603  1.00 28.44          
ATOM    796  CB  VAL    93      45.008  40.312  46.011  1.00 28.74          
ATOM    797  CG1 VAL    93      43.660  39.491  46.023  1.00 25.37          
ATOM    798  CG2 VAL    93      46.221  39.458  45.555  1.00 25.20          
ATOM    799  N   TYR    94      42.629  42.403  44.882  1.00 29.53          
ATOM    800  CA  TYR    94      41.404  43.147  45.179  1.00 29.93          
ATOM    801  C   TYR    94      40.300  42.124  45.422  1.00 29.26          
ATOM    802  O   TYR    94      39.606  41.728  44.531  1.00 29.00          
ATOM    803  CB  TYR    94      41.016  44.039  44.004  1.00 30.51          
ATOM    804  CG  TYR    94      42.016  45.110  43.674  1.00 31.04          
ATOM    805  CD1 TYR    94      41.983  46.336  44.320  1.00 30.17          
ATOM    806  CD2 TYR    94      42.999  44.891  42.701  1.00 30.58          
ATOM    807  CE1 TYR    94      42.912  47.327  44.017  1.00 30.75          
ATOM    808  CE2 TYR    94      43.917  45.847  42.398  1.00 31.08          
ATOM    809  CZ  TYR    94      43.877  47.079  43.045  1.00 33.26          
ATOM    810  OH  TYR    94      44.823  48.055  42.712  1.00 32.99          
ATOM    811  N   PRO    95      40.130  41.718  46.663  1.00 29.25          
ATOM    812  CA  PRO    95      39.185  40.737  46.999  1.00 29.79          
ATOM    813  C   PRO    95      37.842  41.315  47.422  1.00 30.52          
ATOM    814  O   PRO    95      37.770  42.473  47.786  1.00 29.82          
ATOM    815  CB  PRO    95      39.847  40.112  48.241  1.00 29.66          
ATOM    816  CG  PRO    95      40.385  41.315  48.942  1.00 28.17          
ATOM    817  CD  PRO    95      40.868  42.182  47.851  1.00 28.68          
ATOM    818  N   ILE    96      36.786  40.514  47.319  1.00 31.49          
ATOM    819  CA  ILE    96      35.486  40.905  47.859  0.50 31.87          
ATOM    821  C   ILE    96      35.675  40.903  49.385  1.00 32.49          
ATOM    822  O   ILE    96      36.019  39.877  49.980  1.00 31.70          
ATOM    823  CB  ILE    96      34.369  39.925  47.482  0.50 31.46          
ATOM    825  CG1 ILE    96      34.142  39.906  45.963  0.50 31.53          
ATOM    827  CG2 ILE    96      33.082  40.292  48.190  0.50 32.32          
ATOM    829  CD  ILE    96      33.676  41.217  45.363  0.50 27.56          
ATOM    831  N   MET    97      35.476  42.060  49.996  1.00 33.47          
ATOM    832  CA  MET    97      35.648  42.267  51.416  0.60 36.42          
ATOM    834  C   MET    97      34.295  42.009  52.082  1.00 33.49          
ATOM    835  O   MET    97      33.612  42.948  52.393  1.00 33.78          
ATOM    836  CB  MET    97      36.063  43.731  51.622  0.60 36.40          
ATOM    838  CG  MET    97      37.206  44.211  50.698  0.60 40.39          
ATOM    840  SD  MET    97      37.422  46.188  50.408  0.48 46.95          
ATOM    842  CE  MET    97      35.833  46.788  49.386  0.60 41.22          
ATOM    844  N   ASP    98      33.891  40.757  52.252  1.00 32.35          
ATOM    845  CA  ASP    98      32.579  40.482  52.802  1.00 32.10          
ATOM    846  C   ASP    98      32.580  39.078  53.350  1.00 30.95          
ATOM    847  O   ASP    98      33.521  38.336  53.109  1.00 31.18          
ATOM    848  CB  ASP    98      31.498  40.707  51.709  1.00 32.01          
ATOM    849  CG  ASP    98      30.106  40.961  52.283  1.00 33.32          
ATOM    850  OD1 ASP    98      29.907  40.894  53.519  1.00 35.35          
ATOM    851  OD2 ASP    98      29.201  41.265  51.493  1.00 33.61          
ATOM    852  N   PHE    99      31.514  38.719  54.066  1.00 30.94          
ATOM    853  CA  PHE    99      31.442  37.443  54.766  1.00 31.08          
ATOM    854  C   PHE    99      30.036  36.931  54.775  1.00 30.94          
ATOM    855  O   PHE    99      29.111  37.697  54.945  1.00 31.23          
ATOM    856  CB  PHE    99      31.855  37.614  56.263  1.00 30.83          
ATOM    857  CG  PHE    99      33.071  38.416  56.462  1.00 30.89          
ATOM    858  CD1 PHE    99      32.985  39.818  56.579  1.00 31.04          
ATOM    859  CD2 PHE    99      34.318  37.816  56.491  1.00 30.92          
ATOM    860  CE1 PHE    99      34.105  40.582  56.705  1.00 29.76          
ATOM    861  CE2 PHE    99      35.470  38.595  56.658  1.00 31.42          
ATOM    862  CZ  PHE    99      35.361  39.963  56.786  1.00 30.91          
ATOM    863  N   GLY   100      29.887  35.616  54.682  1.00 31.37          
ATOM    864  CA  GLY   100      28.591  34.973  54.808  1.00 31.40          
ATOM    865  C   GLY   100      27.667  35.250  53.645  1.00 31.50          
ATOM    866  O   GLY   100      26.492  35.490  53.835  1.00 32.03          
ATOM    867  N   PHE   101      28.199  35.166  52.431  1.00 30.55          
ATOM    868  CA  PHE   101      27.413  35.397  51.253  1.00 30.28          
ATOM    869  C   PHE   101      27.459  34.184  50.363  1.00 29.34          
ATOM    870  O   PHE   101      28.464  33.516  50.257  1.00 28.31          
ATOM    871  CB  PHE   101      27.845  36.675  50.529  1.00 29.24          
ATOM    872  CG  PHE   101      29.285  36.679  50.080  1.00 30.50          
ATOM    873  CD1 PHE   101      29.620  36.396  48.760  1.00 30.99          
ATOM    874  CD2 PHE   101      30.289  37.040  50.939  1.00 30.32          
ATOM    875  CE1 PHE   101      30.890  36.445  48.331  1.00 27.52          
ATOM    876  CE2 PHE   101      31.560  37.069  50.519  1.00 29.34          
ATOM    877  CZ  PHE   101      31.870  36.751  49.207  1.00 31.56          
ATOM    878  N   ARG   102      26.302  33.886  49.789  1.00 29.69          
ATOM    879  CA  ARG   102      26.146  32.804  48.868  1.00 29.70          
ATOM    880  C   ARG   102      26.595  33.238  47.449  1.00 29.72          
ATOM    881  O   ARG   102      26.510  34.415  47.053  1.00 30.28          
ATOM    882  CB  ARG   102      24.703  32.350  48.911  1.00 30.29          
ATOM    883  CG  ARG   102      24.413  31.126  48.107  1.00 30.83          
ATOM    884  CD  ARG   102      23.204  30.401  48.607  1.00 32.50          
ATOM    885  NE  ARG   102      22.898  29.317  47.683  1.00 33.96          
ATOM    886  CZ  ARG   102      22.165  29.443  46.589  1.00 36.08          
ATOM    887  NH1 ARG   102      21.621  30.608  46.257  1.00 37.22          
ATOM    888  NH2 ARG   102      21.952  28.384  45.817  1.00 38.60          
ATOM    889  N   VAL   103      27.151  32.267  46.724  1.00 29.73          
ATOM    890  CA  VAL   103      27.673  32.452  45.381  1.00 28.43          
ATOM    891  C   VAL   103      27.395  31.182  44.602  1.00 28.35          
ATOM    892  O   VAL   103      27.155  30.120  45.201  1.00 29.10          
ATOM    893  CB  VAL   103      29.220  32.663  45.375  1.00 29.57          
ATOM    894  CG1 VAL   103      29.684  33.944  46.197  1.00 25.27          
ATOM    895  CG2 VAL   103      29.943  31.382  45.828  1.00 27.50          
ATOM    896  N   LEU   104      27.399  31.290  43.277  1.00 27.46          
ATOM    897  CA  LEU   104      27.326  30.149  42.402  1.00 27.49          
ATOM    898  C   LEU   104      28.722  29.996  41.808  1.00 27.61          
ATOM    899  O   LEU   104      29.482  30.950  41.734  1.00 27.73          
ATOM    900  CB  LEU   104      26.306  30.314  41.269  1.00 27.73          
ATOM    901  CG  LEU   104      24.808  30.462  41.607  1.00 29.77          
ATOM    902  CD1 LEU   104      23.965  30.684  40.342  1.00 25.73          
ATOM    903  CD2 LEU   104      24.249  29.273  42.470  1.00 31.65          
ATOM    904  N   LYS   105      29.048  28.781  41.392  1.00 28.03          
ATOM    905  CA  LYS   105      30.311  28.459  40.746  1.00 28.18          
ATOM    906  C   LYS   105      30.597  29.432  39.618  1.00 27.83          
ATOM    907  O   LYS   105      29.753  29.661  38.739  1.00 27.59          
ATOM    908  CB  LYS   105      30.200  27.021  40.168  1.00 28.45          
ATOM    909  CG  LYS   105      31.380  26.551  39.395  1.00 30.45          
ATOM    910  CD  LYS   105      31.381  25.043  39.324  1.00 35.24          
ATOM    911  CE  LYS   105      32.578  24.465  38.580  1.00 38.56          
ATOM    912  NZ  LYS   105      32.346  24.168  37.154  1.00 40.94          
ATOM    913  N   GLY   106      31.791  29.999  39.629  1.00 27.43          
ATOM    914  CA  GLY   106      32.174  30.950  38.620  1.00 27.72          
ATOM    915  C   GLY   106      32.108  32.395  39.084  1.00 28.48          
ATOM    916  O   GLY   106      32.655  33.238  38.443  1.00 29.66          
ATOM    917  N   TYR   107      31.426  32.661  40.185  1.00 29.11          
ATOM    918  CA  TYR   107      31.336  33.998  40.775  1.00 30.38          
ATOM    919  C   TYR   107      32.745  34.570  41.056  1.00 30.20          
ATOM    920  O   TYR   107      33.594  33.884  41.596  1.00 29.79          
ATOM    921  CB  TYR   107      30.529  33.897  42.076  1.00 30.84          
ATOM    922  CG  TYR   107      30.172  35.178  42.775  1.00 30.61          
ATOM    923  CD1 TYR   107      31.062  35.798  43.646  1.00 29.64          
ATOM    924  CD2 TYR   107      28.896  35.705  42.665  1.00 30.62          
ATOM    925  CE1 TYR   107      30.718  36.969  44.305  1.00 33.41          
ATOM    926  CE2 TYR   107      28.543  36.850  43.325  1.00 33.62          
ATOM    927  CZ  TYR   107      29.454  37.486  44.145  1.00 34.42          
ATOM    928  OH  TYR   107      29.081  38.628  44.811  1.00 35.85          
ATOM    929  N   ARG   108      32.970  35.823  40.679  1.00 28.91          
ATOM    930  CA  ARG   108      34.264  36.453  40.890  1.00 30.07          
ATOM    931  C   ARG   108      34.493  36.891  42.361  1.00 29.95          
ATOM    932  O   ARG   108      33.747  37.702  42.894  1.00 30.55          
ATOM    933  CB  ARG   108      34.382  37.666  39.973  1.00 29.73          
ATOM    934  CG  ARG   108      35.738  38.344  40.010  1.00 30.04          
ATOM    935  CD  ARG   108      35.685  39.608  39.168  1.00 29.75          
ATOM    936  NE  ARG   108      35.655  39.296  37.739  1.00 31.85          
ATOM    937  CZ  ARG   108      35.598  40.209  36.777  1.00 30.58          
ATOM    938  NH1 ARG   108      35.534  41.488  37.066  1.00 29.91          
ATOM    939  NH2 ARG   108      35.587  39.834  35.529  1.00 31.01          
ATOM    940  N   LEU   109      35.531  36.346  42.978  1.00 28.92          
ATOM    941  CA  LEU   109      35.884  36.639  44.349  1.00 28.66          
ATOM    942  C   LEU   109      37.000  37.670  44.473  1.00 28.99          
ATOM    943  O   LEU   109      37.064  38.378  45.491  1.00 29.94          
ATOM    944  CB  LEU   109      36.297  35.361  45.084  1.00 28.34          
ATOM    945  CG  LEU   109      35.269  34.228  45.135  1.00 28.28          
ATOM    946  CD1 LEU   109      35.870  32.903  45.615  1.00 24.20          
ATOM    947  CD2 LEU   109      34.070  34.624  45.978  1.00 26.32          
ATOM    948  N   ALA   110      37.869  37.755  43.460  1.00 28.72          
ATOM    949  CA  ALA   110      38.972  38.673  43.486  1.00 28.85          
ATOM    950  C   ALA   110      39.487  38.973  42.092  1.00 28.20          
ATOM    951  O   ALA   110      39.349  38.165  41.182  1.00 28.69          
ATOM    952  CB  ALA   110      40.125  38.115  44.374  1.00 27.48          
ATOM    953  N   THR   111      40.053  40.168  41.955  1.00 28.00          
ATOM    954  CA  THR   111      40.796  40.619  40.767  1.00 27.96          
ATOM    955  C   THR   111      42.250  40.653  41.184  1.00 28.47          
ATOM    956  O   THR   111      42.573  41.096  42.288  1.00 28.25          
ATOM    957  CB  THR   111      40.370  42.000  40.317  1.00 28.12          
ATOM    958  OG1 THR   111      39.035  41.937  39.833  1.00 27.47          
ATOM    959  CG2 THR   111      41.266  42.562  39.207  1.00 27.78          
ATOM    960  N   LEU   112      43.133  40.139  40.336  1.00 29.31          
ATOM    961  CA  LEU   112      44.559  40.173  40.619  1.00 29.41          
ATOM    962  C   LEU   112      45.197  41.104  39.589  1.00 29.94          
ATOM    963  O   LEU   112      44.933  40.958  38.424  1.00 29.91          
ATOM    964  CB  LEU   112      45.180  38.782  40.491  1.00 30.01          
ATOM    965  CG  LEU   112      44.437  37.607  41.127  1.00 29.77          
ATOM    966  CD1 LEU   112      45.066  36.279  40.711  1.00 28.80          
ATOM    967  CD2 LEU   112      44.441  37.747  42.621  1.00 26.63          
ATOM    968  N   GLU   113      46.051  42.033  40.033  1.00 29.49          
ATOM    969  CA  GLU   113      46.730  42.979  39.160  1.00 29.48          
ATOM    970  C   GLU   113      48.231  42.744  39.255  1.00 29.28          
ATOM    971  O   GLU   113      48.794  42.656  40.343  1.00 27.97          
ATOM    972  CB  GLU   113      46.408  44.410  39.573  1.00 29.28          
ATOM    973  CG  GLU   113      46.978  45.490  38.687  1.00 31.66          
ATOM    974  CD  GLU   113      46.898  46.858  39.331  1.00 32.90          
ATOM    975  OE1 GLU   113      46.454  46.975  40.501  1.00 37.77          
ATOM    976  OE2 GLU   113      47.260  47.818  38.662  1.00 31.95          
ATOM    977  N   SER   114      48.871  42.632  38.098  1.00 29.97          
ATOM    978  CA  SER   114      50.300  42.391  38.042  1.00 30.52          
ATOM    979  C   SER   114      51.067  43.720  38.159  1.00 31.36          
ATOM    980  O   SER   114      50.469  44.799  38.086  1.00 31.23          
ATOM    981  CB  SER   114      50.670  41.689  36.722  1.00 30.65          
ATOM    982  OG  SER   114      50.747  42.605  35.639  1.00 30.72          
ATOM    983  N   LYS   115      52.390  43.608  38.282  1.00 31.74          
ATOM    984  CA  LYS   115      53.277  44.780  38.418  0.50 32.12          
ATOM    986  C   LYS   115      53.106  45.728  37.235  1.00 32.17          
ATOM    987  O   LYS   115      53.249  46.928  37.387  1.00 32.06          
ATOM    988  CB  LYS   115      54.752  44.347  38.577  0.50 31.97          
ATOM    990  CG  LYS   115      55.801  45.478  38.696  0.50 32.47          
ATOM    992  CD  LYS   115      55.729  46.251  40.024  0.50 32.71          
ATOM    994  CE  LYS   115      56.780  47.354  40.124  0.50 31.77          
ATOM    996  NZ  LYS   115      58.161  46.820  40.231  0.50 31.98          
ATOM    998  N   LYS   116      52.762  45.188  36.068  1.00 32.06          
ATOM    999  CA  LYS   116      52.553  45.980  34.858  1.00 32.15          
ATOM   1000  C   LYS   116      51.082  46.217  34.499  1.00 31.72          
ATOM   1001  O   LYS   116      50.784  46.647  33.385  1.00 31.63          
ATOM   1002  CB  LYS   116      53.342  45.372  33.666  1.00 32.29          
ATOM   1003  CG  LYS   116      54.850  45.627  33.743  1.00 32.32          
ATOM   1004  N   GLY   117      50.170  45.944  35.442  1.00 32.17          
ATOM   1005  CA  GLY   117      48.743  46.219  35.266  1.00 31.65          
ATOM   1006  C   GLY   117      47.889  45.171  34.583  1.00 32.02          
ATOM   1007  O   GLY   117      46.760  45.448  34.209  1.00 30.89          
ATOM   1008  N   ASP   118      48.425  43.977  34.386  1.00 33.07          
ATOM   1009  CA  ASP   118      47.646  42.886  33.802  1.00 33.69          
ATOM   1010  C   ASP   118      46.676  42.350  34.856  1.00 33.47          
ATOM   1011  O   ASP   118      47.048  42.171  36.024  1.00 33.70          
ATOM   1012  CB  ASP   118      48.564  41.756  33.373  1.00 34.70          
ATOM   1013  CG  ASP   118      49.562  42.169  32.288  1.00 36.13          
ATOM   1014  OD1 ASP   118      49.170  42.849  31.305  1.00 37.08          
ATOM   1015  OD2 ASP   118      50.738  41.765  32.428  1.00 38.14          
ATOM   1016  N   LEU   119      45.440  42.100  34.446  1.00 33.09          
ATOM   1017  CA  LEU   119      44.387  41.617  35.344  1.00 33.04          
ATOM   1018  C   LEU   119      44.009  40.149  35.114  1.00 32.88          
ATOM   1019  O   LEU   119      43.837  39.749  33.997  1.00 33.07          
ATOM   1020  CB  LEU   119      43.134  42.462  35.134  1.00 32.71          
ATOM   1021  CG  LEU   119      43.311  43.951  35.413  1.00 32.71          
ATOM   1022  CD1 LEU   119      42.062  44.678  35.032  1.00 32.27          
ATOM   1023  CD2 LEU   119      43.657  44.206  36.868  1.00 30.21          
ATOM   1024  N   ARG   120      43.908  39.376  36.185  1.00 32.63          
ATOM   1025  CA  ARG   120      43.437  37.998  36.158  1.00 33.15          
ATOM   1026  C   ARG   120      42.375  37.965  37.238  1.00 31.39          
ATOM   1027  O   ARG   120      42.294  38.887  38.054  1.00 31.30          
ATOM   1028  CB  ARG   120      44.544  36.988  36.469  1.00 32.65          
ATOM   1029  CG  ARG   120      45.616  36.885  35.399  1.00 35.91          
ATOM   1030  CD  ARG   120      46.797  35.979  35.783  1.00 38.66          
ATOM   1031  NE  ARG   120      47.527  36.434  36.987  1.00 44.57          
ATOM   1032  CZ  ARG   120      47.667  35.764  38.145  1.00 48.21          
ATOM   1033  NH1 ARG   120      47.168  34.512  38.324  1.00 51.17          
ATOM   1034  NH2 ARG   120      48.348  36.352  39.150  1.00 47.05          
ATOM   1035  N   TYR   121      41.566  36.910  37.257  1.00 30.65          
ATOM   1036  CA  TYR   121      40.498  36.770  38.232  1.00 29.52          
ATOM   1037  C   TYR   121      40.497  35.450  38.994  1.00 29.31          
ATOM   1038  O   TYR   121      40.944  34.430  38.500  1.00 29.67          
ATOM   1039  CB  TYR   121      39.178  36.955  37.531  1.00 29.22          
ATOM   1040  CG  TYR   121      39.180  38.215  36.761  1.00 30.47          
ATOM   1041  CD1 TYR   121      39.085  39.443  37.402  1.00 30.72          
ATOM   1042  CD2 TYR   121      39.357  38.208  35.399  1.00 31.47          
ATOM   1043  CE1 TYR   121      39.132  40.632  36.696  1.00 31.64          
ATOM   1044  CE2 TYR   121      39.419  39.404  34.685  1.00 32.50          
ATOM   1045  CZ  TYR   121      39.298  40.601  35.341  1.00 31.18          
ATOM   1046  OH  TYR   121      39.327  41.770  34.623  1.00 32.27          
ATOM   1047  N   VAL   122      39.991  35.502  40.220  1.00 28.84          
ATOM   1048  CA  VAL   122      39.818  34.333  41.077  1.00 28.57          
ATOM   1049  C   VAL   122      38.327  34.177  41.193  1.00 28.66          
ATOM   1050  O   VAL   122      37.629  35.069  41.675  1.00 27.80          
ATOM   1051  CB  VAL   122      40.446  34.528  42.440  1.00 28.46          
ATOM   1052  CG1 VAL   122      40.099  33.331  43.394  1.00 28.10          
ATOM   1053  CG2 VAL   122      41.995  34.756  42.248  1.00 28.42          
ATOM   1054  N   ASN   123      37.832  33.056  40.700  1.00 28.86          
ATOM   1055  CA  ASN   123      36.408  32.774  40.695  1.00 28.39          
ATOM   1056  C   ASN   123      36.123  31.648  41.616  1.00 28.56          
ATOM   1057  O   ASN   123      36.984  30.826  41.818  1.00 27.87          
ATOM   1058  CB  ASN   123      35.956  32.381  39.304  1.00 29.33          
ATOM   1059  CG  ASN   123      36.182  33.462  38.296  1.00 27.62          
ATOM   1060  OD1 ASN   123      35.988  34.628  38.564  1.00 32.47          
ATOM   1061  ND2 ASN   123      36.597  33.082  37.147  1.00 27.51          
ATOM   1062  N   SER   124      34.899  31.611  42.167  1.00 28.33          
ATOM   1063  CA  SER   124      34.486  30.526  43.025  1.00 28.38          
ATOM   1064  C   SER   124      34.494  29.189  42.288  1.00 28.59          
ATOM   1065  O   SER   124      33.860  29.067  41.234  1.00 27.48          
ATOM   1066  CB  SER   124      33.062  30.755  43.529  1.00 28.74          
ATOM   1067  OG  SER   124      32.815  29.870  44.572  1.00 24.63          
ATOM   1068  N   PRO   125      35.180  28.165  42.855  1.00 29.27          
ATOM   1069  CA  PRO   125      35.201  26.860  42.239  1.00 29.34          
ATOM   1070  C   PRO   125      33.907  26.060  42.416  1.00 29.48          
ATOM   1071  O   PRO   125      33.727  25.061  41.755  1.00 29.83          
ATOM   1072  CB  PRO   125      36.341  26.161  42.996  1.00 29.36          
ATOM   1073  CG  PRO   125      36.282  26.701  44.298  1.00 29.22          
ATOM   1074  CD  PRO   125      35.932  28.152  44.118  1.00 29.39          
ATOM   1075  N   VAL   126      33.029  26.483  43.331  1.00 30.06          
ATOM   1076  CA  VAL   126      31.809  25.778  43.631  1.00 29.39          
ATOM   1077  C   VAL   126      30.714  26.751  43.999  1.00 29.93          
ATOM   1078  O   VAL   126      30.942  27.936  44.183  1.00 30.98          
ATOM   1079  CB  VAL   126      31.997  24.820  44.859  1.00 30.07          
ATOM   1080  CG1 VAL   126      33.004  23.721  44.563  1.00 29.26          
ATOM   1081  CG2 VAL   126      32.403  25.597  46.126  1.00 28.09          
ATOM   1082  N   SER   127      29.512  26.226  44.085  1.00 29.28          
ATOM   1083  CA  SER   127      28.373  26.936  44.581  1.00 29.29          
ATOM   1084  C   SER   127      28.286  26.666  46.084  1.00 28.40          
ATOM   1085  O   SER   127      28.467  25.564  46.540  1.00 28.74          
ATOM   1086  CB  SER   127      27.103  26.448  43.880  1.00 28.97          
ATOM   1087  OG  SER   127      27.121  26.809  42.521  1.00 30.47          
ATOM   1088  N   GLY   128      27.994  27.692  46.865  1.00 29.10          
ATOM   1089  CA  GLY   128      27.890  27.524  48.307  1.00 28.32          
ATOM   1090  C   GLY   128      28.029  28.842  48.967  1.00 27.81          
ATOM   1091  O   GLY   128      27.764  29.826  48.359  1.00 28.32          
ATOM   1092  N   THR   129      28.516  28.851  50.197  1.00 28.38          
ATOM   1093  CA  THR   129      28.600  30.051  51.013  1.00 29.02          
ATOM   1094  C   THR   129      30.052  30.413  51.333  1.00 28.70          
ATOM   1095  O   THR   129      30.805  29.569  51.724  1.00 28.95          
ATOM   1096  CB  THR   129      27.871  29.820  52.367  1.00 29.10          
ATOM   1097  OG1 THR   129      26.538  29.280  52.147  1.00 28.63          
ATOM   1098  CG2 THR   129      27.797  31.113  53.170  1.00 26.94          
ATOM   1099  N   VAL   130      30.430  31.660  51.140  1.00 29.17          
ATOM   1100  CA  VAL   130      31.739  32.131  51.531  1.00 30.48          
ATOM   1101  C   VAL   130      31.538  32.462  52.984  1.00 30.69          
ATOM   1102  O   VAL   130      30.805  33.349  53.295  1.00 31.50          
ATOM   1103  CB  VAL   130      32.204  33.394  50.734  1.00 30.60          
ATOM   1104  CG1 VAL   130      33.557  33.925  51.266  1.00 29.82          
ATOM   1105  CG2 VAL   130      32.300  33.086  49.283  1.00 30.63          
ATOM   1106  N   ILE   131      32.216  31.747  53.861  1.00 32.65          
ATOM   1107  CA  ILE   131      32.070  31.890  55.295  1.00 33.61          
ATOM   1108  C   ILE   131      33.073  32.881  55.895  1.00 33.47          
ATOM   1109  O   ILE   131      32.757  33.594  56.835  1.00 34.54          
ATOM   1110  CB  ILE   131      32.058  30.469  56.003  1.00 34.99          
ATOM   1111  CG1 ILE   131      33.407  29.769  55.988  1.00 37.35          
ATOM   1112  CG2 ILE   131      31.005  29.503  55.369  1.00 32.31          
ATOM   1113  CD  ILE   131      33.339  28.349  56.558  1.00 36.05          
ATOM   1114  N   PHE   132      34.257  33.000  55.318  1.00 33.54          
ATOM   1115  CA  PHE   132      35.248  33.929  55.843  1.00 33.34          
ATOM   1116  C   PHE   132      36.238  34.235  54.771  1.00 32.81          
ATOM   1117  O   PHE   132      36.340  33.542  53.762  1.00 32.93          
ATOM   1118  CB  PHE   132      35.978  33.360  57.082  1.00 33.46          
ATOM   1119  CG  PHE   132      35.917  34.273  58.313  1.00 33.81          
ATOM   1120  CD1 PHE   132      36.636  35.459  58.376  1.00 33.52          
ATOM   1121  CD2 PHE   132      35.140  33.913  59.412  1.00 33.83          
ATOM   1122  CE1 PHE   132      36.568  36.285  59.487  1.00 34.34          
ATOM   1123  CE2 PHE   132      35.065  34.742  60.542  1.00 34.41          
ATOM   1124  CZ  PHE   132      35.771  35.924  60.576  1.00 33.89          
ATOM   1125  N   MET   133      36.904  35.362  54.935  1.00 32.69          
ATOM   1126  CA  MET   133      38.010  35.718  54.067  1.00 31.66          
ATOM   1127  C   MET   133      38.954  36.535  54.922  1.00 31.51          
ATOM   1128  O   MET   133      38.537  37.133  55.927  1.00 30.00          
ATOM   1129  CB  MET   133      37.526  36.476  52.840  1.00 31.10          
ATOM   1130  CG  MET   133      36.856  37.801  53.121  1.00 31.10          
ATOM   1131  SD  MET   133      38.027  39.306  53.371  0.75 27.39          
ATOM   1132  CE  MET   133      38.977  39.093  51.665  1.00 30.78          
ATOM   1133  N   ASN   134      40.221  36.573  54.505  1.00 31.65          
ATOM   1134  CA  ASN   134      41.234  37.341  55.187  1.00 31.18          
ATOM   1135  C   ASN   134      42.550  37.392  54.410  1.00 31.15          
ATOM   1136  O   ASN   134      42.766  36.638  53.465  1.00 30.05          
ATOM   1137  CB  ASN   134      41.495  36.734  56.590  1.00 30.95          
ATOM   1138  CG  ASN   134      41.738  35.215  56.546  1.00 30.15          
ATOM   1139  OD1 ASN   134      40.798  34.440  56.568  1.00 31.54          
ATOM   1140  ND2 ASN   134      42.995  34.799  56.503  1.00 29.15          
ATOM   1141  N   GLU   135      43.415  38.315  54.833  1.00 31.28          
ATOM   1142  CA  GLU   135      44.803  38.371  54.391  1.00 31.19          
ATOM   1143  C   GLU   135      45.467  37.105  54.902  1.00 31.28          
ATOM   1144  O   GLU   135      45.140  36.589  55.969  1.00 31.04          
ATOM   1145  CB  GLU   135      45.558  39.476  55.098  1.00 31.44          
ATOM   1146  CG  GLU   135      45.180  40.847  54.761  1.00 31.10          
ATOM   1147  CD  GLU   135      45.856  41.845  55.647  1.00 29.10          
ATOM   1148  OE1 GLU   135      46.045  41.590  56.849  1.00 28.16          
ATOM   1149  OE2 GLU   135      46.195  42.897  55.129  1.00 31.14          
ATOM   1150  N   ILE   136      46.428  36.630  54.138  1.00 31.61          
ATOM   1151  CA  ILE   136      47.195  35.464  54.493  1.00 32.13          
ATOM   1152  C   ILE   136      48.260  35.960  55.475  1.00 31.79          
ATOM   1153  O   ILE   136      48.986  36.842  55.151  1.00 31.36          
ATOM   1154  CB  ILE   136      47.756  34.806  53.214  1.00 32.92          
ATOM   1155  CG1 ILE   136      46.589  34.150  52.454  1.00 29.58          
ATOM   1156  CG2 ILE   136      48.856  33.804  53.539  1.00 32.26          
ATOM   1157  CD  ILE   136      46.975  33.467  51.130  1.00 32.30          
ATOM   1158  N   PRO   137      48.306  35.420  56.709  1.00 32.77          
ATOM   1159  CA  PRO   137      49.274  35.953  57.678  1.00 33.77          
ATOM   1160  C   PRO   137      50.699  36.014  57.169  1.00 34.29          
ATOM   1161  O   PRO   137      51.377  37.019  57.389  1.00 35.58          
ATOM   1162  CB  PRO   137      49.152  34.988  58.846  1.00 33.69          
ATOM   1163  CG  PRO   137      47.777  34.485  58.741  1.00 33.61          
ATOM   1164  CD  PRO   137      47.543  34.316  57.295  1.00 32.30          
ATOM   1165  N   SER   138      51.127  34.981  56.446  1.00 35.02          
ATOM   1166  CA  SER   138      52.505  34.911  55.921  1.00 35.03          
ATOM   1167  C   SER   138      52.782  35.841  54.769  1.00 34.80          
ATOM   1168  O   SER   138      53.940  36.110  54.460  1.00 35.23          
ATOM   1169  CB  SER   138      52.844  33.479  55.506  1.00 35.10          
ATOM   1170  OG  SER   138      51.877  32.964  54.630  1.00 36.69          
ATOM   1171  N   GLU   139      51.745  36.294  54.071  1.00 34.68          
ATOM   1172  CA  GLU   139      51.949  37.254  52.995  1.00 34.27          
ATOM   1173  C   GLU   139      50.666  38.041  52.816  1.00 33.05          
ATOM   1174  O   GLU   139      49.802  37.657  52.059  1.00 31.18          
ATOM   1175  CB  GLU   139      52.451  36.611  51.695  1.00 33.92          
ATOM   1176  CG  GLU   139      52.949  37.681  50.687  1.00 34.83          
ATOM   1177  CD  GLU   139      53.502  37.114  49.365  1.00 38.52          
ATOM   1178  OE1 GLU   139      53.819  35.880  49.300  1.00 45.31          
ATOM   1179  OE2 GLU   139      53.628  37.910  48.373  1.00 41.93          
ATOM   1180  N   ARG   140      50.601  39.169  53.525  1.00 33.00          
ATOM   1181  CA  ARG   140      49.403  40.016  53.617  1.00 33.02          
ATOM   1182  C   ARG   140      48.832  40.613  52.325  1.00 32.12          
ATOM   1183  O   ARG   140      47.656  40.969  52.287  1.00 33.01          
ATOM   1184  CB  ARG   140      49.625  41.110  54.641  1.00 33.55          
ATOM   1185  CG  ARG   140      49.618  40.603  56.020  1.00 33.72          
ATOM   1186  CD  ARG   140      49.867  41.760  56.931  1.00 33.98          
ATOM   1187  NE  ARG   140      50.073  41.335  58.312  1.00 31.90          
ATOM   1188  CZ  ARG   140      49.217  41.476  59.303  1.00 32.28          
ATOM   1189  NH1 ARG   140      48.041  42.066  59.130  1.00 32.64          
ATOM   1190  NH2 ARG   140      49.583  41.063  60.510  1.00 31.55          
ATOM   1191  N   ALA   141      49.650  40.687  51.297  1.00 31.04          
ATOM   1192  CA  ALA   141      49.264  41.118  49.961  1.00 31.25          
ATOM   1193  C   ALA   141      48.235  40.147  49.390  1.00 31.65          
ATOM   1194  O   ALA   141      47.406  40.544  48.588  1.00 31.63          
ATOM   1195  CB  ALA   141      50.563  41.125  49.009  1.00 30.79          
ATOM   1196  N   ASN   142      48.326  38.874  49.797  1.00 31.81          
ATOM   1197  CA  ASN   142      47.462  37.808  49.327  1.00 31.67          
ATOM   1198  C   ASN   142      46.288  37.546  50.303  1.00 31.60          
ATOM   1199  O   ASN   142      46.320  37.903  51.475  1.00 32.41          
ATOM   1200  CB  ASN   142      48.267  36.525  49.069  1.00 31.56          
ATOM   1201  CG  ASN   142      49.404  36.710  48.061  1.00 31.76          
ATOM   1202  OD1 ASN   142      49.383  37.601  47.221  1.00 32.48          
ATOM   1203  ND2 ASN   142      50.380  35.838  48.125  1.00 30.67          
ATOM   1204  N   TYR   143      45.237  36.943  49.771  1.00 30.91          
ATOM   1205  CA  TYR   143      44.031  36.663  50.498  1.00 29.87          
ATOM   1206  C   TYR   143      43.571  35.218  50.307  1.00 29.75          
ATOM   1207  O   TYR   143      43.975  34.535  49.396  1.00 28.22          
ATOM   1208  CB  TYR   143      42.927  37.625  50.042  1.00 29.90          
ATOM   1209  CG  TYR   143      43.155  39.083  50.455  1.00 29.48          
ATOM   1210  CD1 TYR   143      43.962  39.914  49.675  1.00 27.65          
ATOM   1211  CD2 TYR   143      42.558  39.617  51.586  1.00 28.99          
ATOM   1212  CE1 TYR   143      44.193  41.193  50.007  1.00 30.87          
ATOM   1213  CE2 TYR   143      42.791  40.948  51.960  1.00 30.29          
ATOM   1214  CZ  TYR   143      43.618  41.711  51.161  1.00 29.81          
ATOM   1215  OH  TYR   143      43.889  42.987  51.418  1.00 31.80          
ATOM   1216  N   VAL   144      42.674  34.788  51.179  1.00 30.32          
ATOM   1217  CA  VAL   144      42.092  33.471  51.114  1.00 29.85          
ATOM   1218  C   VAL   144      40.616  33.605  51.469  1.00 30.50          
ATOM   1219  O   VAL   144      40.258  34.388  52.334  1.00 29.82          
ATOM   1220  CB  VAL   144      42.831  32.484  52.080  1.00 30.16          
ATOM   1221  CG1 VAL   144      42.731  32.951  53.551  1.00 27.18          
ATOM   1222  CG2 VAL   144      42.364  31.038  51.848  1.00 26.04          
ATOM   1223  N   PHE   145      39.776  32.873  50.736  1.00 30.78          
ATOM   1224  CA  PHE   145      38.368  32.781  51.015  1.00 30.53          
ATOM   1225  C   PHE   145      38.091  31.372  51.542  1.00 31.23          
ATOM   1226  O   PHE   145      38.650  30.398  51.045  1.00 31.66          
ATOM   1227  CB  PHE   145      37.560  33.019  49.738  1.00 31.15          
ATOM   1228  CG  PHE   145      37.780  34.342  49.137  1.00 30.85          
ATOM   1229  CD1 PHE   145      38.842  34.558  48.281  1.00 34.03          
ATOM   1230  CD2 PHE   145      36.942  35.388  49.426  1.00 31.87          
ATOM   1231  CE1 PHE   145      39.066  35.816  47.740  1.00 34.40          
ATOM   1232  CE2 PHE   145      37.152  36.640  48.876  1.00 30.74          
ATOM   1233  CZ  PHE   145      38.202  36.853  48.047  1.00 33.01          
ATOM   1234  N   TYR   146      37.237  31.248  52.562  1.00 31.84          
ATOM   1235  CA  TYR   146      36.838  29.925  53.037  1.00 31.32          
ATOM   1236  C   TYR   146      35.381  29.768  52.699  1.00 31.18          
ATOM   1237  O   TYR   146      34.601  30.672  52.935  1.00 31.77          
ATOM   1238  CB  TYR   146      37.093  29.747  54.517  1.00 31.06          
ATOM   1239  CG  TYR   146      38.540  29.779  54.850  1.00 31.66          
ATOM   1240  CD1 TYR   146      39.353  28.675  54.624  1.00 30.78          
ATOM   1241  CD2 TYR   146      39.119  30.916  55.381  1.00 32.06          
ATOM   1242  CE1 TYR   146      40.710  28.737  54.912  1.00 29.18          
ATOM   1243  CE2 TYR   146      40.437  30.958  55.683  1.00 31.33          
ATOM   1244  CZ  TYR   146      41.229  29.871  55.449  1.00 29.30          
ATOM   1245  OH  TYR   146      42.553  29.946  55.758  1.00 28.91          
ATOM   1246  N   MET   147      35.046  28.631  52.095  1.00 30.69          
ATOM   1247  CA  MET   147      33.699  28.306  51.660  1.00 29.75          
ATOM   1248  C   MET   147      33.218  26.951  52.139  1.00 30.05          
ATOM   1249  O   MET   147      33.992  26.005  52.328  1.00 29.86          
ATOM   1250  CB  MET   147      33.628  28.236  50.136  1.00 29.81          
ATOM   1251  CG  MET   147      34.193  29.440  49.391  1.00 31.03          
ATOM   1252  SD  MET   147      33.768  29.343  47.480  0.75 24.67          
ATOM   1253  CE  MET   147      31.824  29.011  47.804  1.00 31.59          
ATOM   1254  N   LEU   148      31.906  26.880  52.290  1.00 30.34          
ATOM   1255  CA  LEU   148      31.204  25.643  52.525  1.00 30.70          
ATOM   1256  C   LEU   148      30.446  25.379  51.236  1.00 31.20          
ATOM   1257  O   LEU   148      29.611  26.178  50.845  1.00 30.39          
ATOM   1258  CB  LEU   148      30.226  25.776  53.678  1.00 31.03          
ATOM   1259  CG  LEU   148      29.417  24.551  54.099  1.00 31.02          
ATOM   1260  CD1 LEU   148      30.272  23.256  54.355  1.00 28.35          
ATOM   1261  CD2 LEU   148      28.555  24.945  55.327  1.00 30.25          
ATOM   1262  N   GLU   149      30.772  24.271  50.563  1.00 31.34          
ATOM   1263  CA  GLU   149      30.094  23.869  49.356  1.00 31.58          
ATOM   1264  C   GLU   149      28.685  23.391  49.687  1.00 31.67          
ATOM   1265  O   GLU   149      28.452  22.766  50.733  1.00 31.30          
ATOM   1266  CB  GLU   149      30.868  22.765  48.669  1.00 32.45          
ATOM   1267  CG  GLU   149      30.220  22.284  47.416  1.00 33.30          
ATOM   1268  CD  GLU   149      31.106  21.330  46.614  1.00 35.55          
ATOM   1269  OE1 GLU   149      32.085  20.774  47.165  1.00 36.82          
ATOM   1270  OE2 GLU   149      30.791  21.127  45.429  1.00 34.53          
ATOM   1271  N   GLU   150      27.724  23.708  48.820  1.00 31.85          
ATOM   1272  CA  GLU   150      26.365  23.296  49.066  1.00 31.76          
ATOM   1273  C   GLU   150      26.049  22.123  48.156  1.00 32.44          
ATOM   1274  OT1 GLU   150      26.770  21.884  47.194  1.00 31.65          
ATOM   1275  CB  GLU   150      25.387  24.453  48.842  1.00 31.59          
ATOM   1276  CG  GLU   150      25.137  24.836  47.399  1.00 31.11          
ATOM   1277  CD  GLU   150      24.323  26.107  47.253  1.00 31.51          
ATOM   1278  OE1 GLU   150      24.363  26.957  48.148  1.00 31.26          
ATOM   1279  OE2 GLU   150      23.660  26.276  46.205  1.00 32.14          
ATOM   1280  OT2 GLU   150      25.047  21.415  48.336  1.00 34.12          
END
