
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   72 ( 1123),  selected   72 , name 1z6h_A
# Molecule2: number of CA atoms   68 (  548),  selected   68 , name T0397_83_150.pdb
# PARAMETERS: 1z6h_A.T0397_83_150.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      L      83           -
LGA    -       -      I      84           -
LGA    T     2_A      S      85          1.111
LGA    V     3_A      V      86          0.769
LGA    S     4_A      P      87          0.996
LGA    I     5_A      A      88          2.263
LGA    Q     6_A      E      89          4.991
LGA    M     7_A      -       -           -
LGA    A     8_A      G      90          3.109
LGA    G     9_A      Y      91          1.628
LGA    N    10_A      K      92          1.373
LGA    L    11_A      V      93          1.007
LGA    W    12_A      Y      94          2.907
LGA    K    13_A      -       -           -
LGA    V    14_A      P      95          2.180
LGA    H    15_A      I      96          2.431
LGA    V    16_A      M      97          5.126
LGA    K    17_A      D      98          1.546
LGA    A    18_A      F      99          1.200
LGA    G    19_A      G     100          0.722
LGA    D    20_A      F     101          0.827
LGA    Q    21_A      R     102          1.140
LGA    I    22_A      V     103          1.527
LGA    E    23_A      L     104          1.483
LGA    K    24_A      K     105          1.261
LGA    G    25_A      G     106          0.965
LGA    Q    26_A      Y     107          0.956
LGA    E    27_A      R     108          0.860
LGA    V    28_A      L     109          0.853
LGA    A    29_A      A     110          0.963
LGA    I    30_A      T     111          0.663
LGA    L    31_A      L     112          0.987
LGA    E    32_A      E     113          1.365
LGA    S    33_A      S     114          1.619
LGA    M    34_A      K     115          0.973
LGA    K    35_A      K     116          2.667
LGA    M    36_A      G     117          2.916
LGA    -       -      D     118           -
LGA    E    37_A      L     119          1.276
LGA    I    38_A      R     120          1.215
LGA    P    39_A      Y     121          1.844
LGA    I    40_A      V     122          1.733
LGA    V    41_A      N     123          1.202
LGA    A    42_A      S     124          1.066
LGA    D    43_A      P     125          1.883
LGA    R    44_A      V     126          1.781
LGA    S    45_A      S     127          1.801
LGA    G    46_A      G     128          1.391
LGA    I    47_A      T     129          0.651
LGA    V    48_A      V     130          1.061
LGA    K    49_A      I     131          1.021
LGA    E    50_A      F     132          0.549
LGA    V    51_A      M     133          0.528
LGA    K    52_A      N     134          2.129
LGA    K    53_A      E     135          2.740
LGA    K    54_A      I     136           -
LGA    E    55_A      P     137           -
LGA    G    56_A      S     138           -
LGA    -       -      E     139           -
LGA    D    57_A      R     140          5.163
LGA    F    58_A      A     141          0.744
LGA    V    59_A      N     142          2.027
LGA    N    60_A      -       -           -
LGA    E    61_A      -       -           -
LGA    G    62_A      -       -           -
LGA    D    63_A      -       -           -
LGA    V    64_A      Y     143          5.016
LGA    L    65_A      V     144          1.396
LGA    L    66_A      F     145          0.320
LGA    E    67_A      Y     146          0.334
LGA    L    68_A      M     147          1.056
LGA    S    69_A      L     148          2.921
LGA    N    70_A      E     149          3.342
LGA    S    71_A      E     150           #
LGA    T    72_A      -       -           -
LGA    Q    73_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   72   68    5.0     60    2.05    20.00     78.122     2.795

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.917434 * X  +  -0.395971 * Y  +   0.039009 * Z  +  37.994457
  Y_new =  -0.226624 * X  +  -0.600608 * Y  +  -0.766754 * Z  +  30.170534
  Z_new =   0.327041 * X  +   0.694606 * Y  +  -0.640755 * Z  +  54.370548 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.315889   -0.825703  [ DEG:   132.6907    -47.3093 ]
  Theta =  -0.333171   -2.808421  [ DEG:   -19.0893   -160.9107 ]
  Phi   =  -0.242172    2.899421  [ DEG:   -13.8754    166.1246 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1z6h_A                                        
REMARK     2: T0397_83_150.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1z6h_A.T0397_83_150.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   72   68   5.0   60   2.05   20.00  78.122
REMARK  ---------------------------------------------------------- 
MOLECULE 1z6h_A
HEADER    BIOSYNTHETIC PROTEIN                    22-MAR-05   1Z6H              
TITLE     SOLUTION STRUCTURE OF BACILLUS SUBTILIS BLAP BIOTINYLATED-            
TITLE    2 FORM                                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BIOTIN/LIPOYL ATTACHMENT PROTEIN;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET 21A(+)                                
KEYWDS    BACILLUS SUBTILIS, SINGLE-DOMAIN BIOTIN/LIPOYL ATTACHMENT             
KEYWDS   2 PROTEIN, SOLUTION STRUCTURE                                          
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    G.CUI,B.XIA                                                           
REVDAT   2   10-JUL-07 1Z6H    1       JRNL                                     
REVDAT   1   22-MAR-06 1Z6H    0                                                
JRNL        AUTH   G.CUI,B.NAN,J.HU,Y.WANG,C.JIN,B.XIA                          
JRNL        TITL   IDENTIFICATION AND SOLUTION STRUCTURES OF A SINGLE           
JRNL        TITL 2 DOMAIN BIOTIN/LIPOYL ATTACHMENT PROTEIN FROM                 
JRNL        TITL 3 BACILLUS SUBTILIS                                            
JRNL        REF    J.BIOL.CHEM.                  V. 281 20598 2006              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1Z6H A    2    73  UNP    Q9R9I3   Q9R9I3_BACSU     2     73             
SEQRES   1 A   72  THR VAL SER ILE GLN MET ALA GLY ASN LEU TRP LYS VAL          
SEQRES   2 A   72  HIS VAL LYS ALA GLY ASP GLN ILE GLU LYS GLY GLN GLU          
SEQRES   3 A   72  VAL ALA ILE LEU GLU SER MET LYS MET GLU ILE PRO ILE          
SEQRES   4 A   72  VAL ALA ASP ARG SER GLY ILE VAL LYS GLU VAL LYS LYS          
SEQRES   5 A   72  LYS GLU GLY ASP PHE VAL ASN GLU GLY ASP VAL LEU LEU          
SEQRES   6 A   72  GLU LEU SER ASN SER THR GLN                                  
HET    BTI  A 135      30                                                       
HETNAM     BTI 5-(HEXAHYDRO-2-OXO-1H-THIENO[3,4-D]IMIDAZOL-6-YL)                
HETNAM   2 BTI  PENTANAL                                                        
FORMUL   2  BTI    C10 H16 N2 O2 S                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   THR A   2      39.772  27.460  51.567  0.00  0.00           N  
ATOM      2  CA  THR A   2      39.025  26.876  50.428  0.00  0.00           C  
ATOM      3  C   THR A   2      39.547  27.446  49.098  0.00  0.00           C  
ATOM      4  O   THR A   2      40.265  26.746  48.382  0.00  0.00           O  
ATOM      5  CB  THR A   2      37.498  27.032  50.596  0.00  0.00           C  
ATOM      6  OG1 THR A   2      37.073  26.696  51.906  0.00  0.00           O  
ATOM      7  CG2 THR A   2      36.696  26.184  49.608  0.00  0.00           C  
ATOM      8  H2  THR A   2      40.755  27.255  51.479  0.00  0.00           H  
ATOM      9  HA  THR A   2      39.238  25.806  50.418  0.00  0.00           H  
ATOM     10  HB  THR A   2      37.230  28.076  50.439  0.00  0.00           H  
ATOM     11  HG1 THR A   2      37.243  25.755  52.072  0.00  0.00           H  
ATOM     12 HG21 THR A   2      35.636  26.266  49.837  0.00  0.00           H  
ATOM     13 HG22 THR A   2      36.858  26.540  48.590  0.00  0.00           H  
ATOM     14 HG23 THR A   2      36.995  25.136  49.677  0.00  0.00           H  
ATOM     15  H1  THR A   2      39.423  27.071  52.430  0.00  0.00           H  
ATOM     16  H3  THR A   2      39.645  28.463  51.587  0.00  0.00           H  
ATOM     17  N   VAL A   3      39.199  28.692  48.744  0.00  0.00           N  
ATOM     18  CA  VAL A   3      39.691  29.349  47.535  0.00  0.00           C  
ATOM     19  C   VAL A   3      41.011  30.037  47.914  0.00  0.00           C  
ATOM     20  O   VAL A   3      41.163  30.504  49.051  0.00  0.00           O  
ATOM     21  CB  VAL A   3      38.635  30.340  46.981  0.00  0.00           C  
ATOM     22  CG1 VAL A   3      38.925  30.727  45.525  0.00  0.00           C  
ATOM     23  CG2 VAL A   3      37.197  29.782  47.013  0.00  0.00           C  
ATOM     24  H   VAL A   3      38.717  29.290  49.408  0.00  0.00           H  
ATOM     25  HA  VAL A   3      39.884  28.589  46.774  0.00  0.00           H  
ATOM     26  HB  VAL A   3      38.664  31.249  47.577  0.00  0.00           H  
ATOM     27 HG11 VAL A   3      38.923  29.838  44.895  0.00  0.00           H  
ATOM     28 HG12 VAL A   3      38.162  31.420  45.169  0.00  0.00           H  
ATOM     29 HG13 VAL A   3      39.892  31.224  45.447  0.00  0.00           H  
ATOM     30 HG21 VAL A   3      37.145  28.839  46.467  0.00  0.00           H  
ATOM     31 HG22 VAL A   3      36.865  29.619  48.038  0.00  0.00           H  
ATOM     32 HG23 VAL A   3      36.509  30.497  46.557  0.00  0.00           H  
ATOM     33  N   SER A   4      41.936  30.138  46.963  0.00  0.00           N  
ATOM     34  CA  SER A   4      43.265  30.704  47.150  0.00  0.00           C  
ATOM     35  C   SER A   4      43.645  31.493  45.895  0.00  0.00           C  
ATOM     36  O   SER A   4      43.107  31.254  44.808  0.00  0.00           O  
ATOM     37  CB  SER A   4      44.266  29.566  47.407  0.00  0.00           C  
ATOM     38  OG  SER A   4      43.917  28.833  48.573  0.00  0.00           O  
ATOM     39  H   SER A   4      41.739  29.794  46.033  0.00  0.00           H  
ATOM     40  HA  SER A   4      43.267  31.384  48.005  0.00  0.00           H  
ATOM     41  HB2 SER A   4      44.272  28.894  46.547  0.00  0.00           H  
ATOM     42  HB3 SER A   4      45.269  29.976  47.526  0.00  0.00           H  
ATOM     43  HG  SER A   4      44.544  28.096  48.662  0.00  0.00           H  
ATOM     44  N   ILE A   5      44.554  32.451  46.053  0.00  0.00           N  
ATOM     45  CA  ILE A   5      45.111  33.247  44.972  0.00  0.00           C  
ATOM     46  C   ILE A   5      46.026  32.341  44.125  0.00  0.00           C  
ATOM     47  O   ILE A   5      46.565  31.346  44.616  0.00  0.00           O  
ATOM     48  CB  ILE A   5      45.819  34.486  45.582  0.00  0.00           C  
ATOM     49  CG1 ILE A   5      44.821  35.412  46.323  0.00  0.00           C  
ATOM     50  CG2 ILE A   5      46.512  35.315  44.497  0.00  0.00           C  
ATOM     51  CD1 ILE A   5      44.844  35.203  47.838  0.00  0.00           C  
ATOM     52  H   ILE A   5      45.011  32.531  46.958  0.00  0.00           H  
ATOM     53  HA  ILE A   5      44.289  33.589  44.341  0.00  0.00           H  
ATOM     54  HB  ILE A   5      46.584  34.151  46.282  0.00  0.00           H  
ATOM     55 HG12 ILE A   5      45.063  36.459  46.140  0.00  0.00           H  
ATOM     56 HG13 ILE A   5      43.808  35.252  45.951  0.00  0.00           H  
ATOM     57 HG21 ILE A   5      47.323  34.742  44.057  0.00  0.00           H  
ATOM     58 HG22 ILE A   5      45.780  35.609  43.747  0.00  0.00           H  
ATOM     59 HG23 ILE A   5      46.969  36.206  44.921  0.00  0.00           H  
ATOM     60 HD11 ILE A   5      45.851  35.353  48.226  0.00  0.00           H  
ATOM     61 HD12 ILE A   5      44.167  35.909  48.316  0.00  0.00           H  
ATOM     62 HD13 ILE A   5      44.525  34.197  48.082  0.00  0.00           H  
ATOM     63  N   GLN A   6      46.220  32.694  42.848  0.00  0.00           N  
ATOM     64  CA  GLN A   6      46.880  31.854  41.844  0.00  0.00           C  
ATOM     65  C   GLN A   6      48.079  32.544  41.170  0.00  0.00           C  
ATOM     66  O   GLN A   6      48.681  31.969  40.264  0.00  0.00           O  
ATOM     67  CB  GLN A   6      45.822  31.402  40.822  0.00  0.00           C  
ATOM     68  CG  GLN A   6      45.288  32.548  39.939  0.00  0.00           C  
ATOM     69  CD  GLN A   6      44.036  32.127  39.172  0.00  0.00           C  
ATOM     70  OE1 GLN A   6      44.091  31.737  38.008  0.00  0.00           O  
ATOM     71  NE2 GLN A   6      42.882  32.189  39.817  0.00  0.00           N  
ATOM     72  H   GLN A   6      45.751  33.521  42.507  0.00  0.00           H  
ATOM     73  HA  GLN A   6      47.264  30.957  42.332  0.00  0.00           H  
ATOM     74  HB2 GLN A   6      46.248  30.632  40.176  0.00  0.00           H  
ATOM     75  HB3 GLN A   6      44.992  30.952  41.369  0.00  0.00           H  
ATOM     76  HG2 GLN A   6      45.041  33.413  40.555  0.00  0.00           H  
ATOM     77  HG3 GLN A   6      46.059  32.852  39.229  0.00  0.00           H  
ATOM     78 HE21 GLN A   6      42.863  32.488  40.781  0.00  0.00           H  
ATOM     79 HE22 GLN A   6      42.027  31.912  39.357  0.00  0.00           H  
ATOM     80  N   MET A   7      48.421  33.772  41.576  0.00  0.00           N  
ATOM     81  CA  MET A   7      49.487  34.573  40.978  0.00  0.00           C  
ATOM     82  C   MET A   7      50.017  35.560  42.029  0.00  0.00           C  
ATOM     83  O   MET A   7      49.294  35.940  42.952  0.00  0.00           O  
ATOM     84  CB  MET A   7      48.909  35.264  39.723  0.00  0.00           C  
ATOM     85  CG  MET A   7      49.802  36.325  39.079  0.00  0.00           C  
ATOM     86  SD  MET A   7      51.462  35.780  38.590  0.00  0.00           S  
ATOM     87  CE  MET A   7      52.113  37.387  38.060  0.00  0.00           C  
ATOM     88  H   MET A   7      47.917  34.205  42.338  0.00  0.00           H  
ATOM     89  HA  MET A   7      50.304  33.918  40.672  0.00  0.00           H  
ATOM     90  HB2 MET A   7      48.697  34.500  38.973  0.00  0.00           H  
ATOM     91  HB3 MET A   7      47.964  35.738  39.980  0.00  0.00           H  
ATOM     92  HG2 MET A   7      49.292  36.709  38.195  0.00  0.00           H  
ATOM     93  HG3 MET A   7      49.901  37.151  39.777  0.00  0.00           H  
ATOM     94  HE1 MET A   7      52.104  38.082  38.899  0.00  0.00           H  
ATOM     95  HE2 MET A   7      53.134  37.269  37.698  0.00  0.00           H  
ATOM     96  HE3 MET A   7      51.488  37.786  37.260  0.00  0.00           H  
ATOM     97  N   ALA A   8      51.289  35.950  41.915  0.00  0.00           N  
ATOM     98  CA  ALA A   8      51.916  36.975  42.737  0.00  0.00           C  
ATOM     99  C   ALA A   8      51.285  38.329  42.434  0.00  0.00           C  
ATOM    100  O   ALA A   8      51.151  38.693  41.264  0.00  0.00           O  
ATOM    101  CB  ALA A   8      53.422  36.984  42.464  0.00  0.00           C  
ATOM    102  H   ALA A   8      51.809  35.647  41.109  0.00  0.00           H  
ATOM    103  HA  ALA A   8      51.758  36.751  43.781  0.00  0.00           H  
ATOM    104  HB1 ALA A   8      53.612  37.188  41.409  0.00  0.00           H  
ATOM    105  HB2 ALA A   8      53.899  37.760  43.063  0.00  0.00           H  
ATOM    106  HB3 ALA A   8      53.843  36.014  42.734  0.00  0.00           H  
ATOM    107  N   GLY A   9      50.902  39.084  43.463  0.00  0.00           N  
ATOM    108  CA  GLY A   9      50.226  40.349  43.234  0.00  0.00           C  
ATOM    109  C   GLY A   9      49.678  40.996  44.496  0.00  0.00           C  
ATOM    110  O   GLY A   9      50.115  40.731  45.618  0.00  0.00           O  
ATOM    111  H   GLY A   9      50.996  38.751  44.419  0.00  0.00           H  
ATOM    112  HA2 GLY A   9      50.915  41.045  42.756  0.00  0.00           H  
ATOM    113  HA3 GLY A   9      49.398  40.171  42.547  0.00  0.00           H  
ATOM    114  N   ASN A  10      48.702  41.869  44.282  0.00  0.00           N  
ATOM    115  CA  ASN A  10      48.040  42.685  45.282  0.00  0.00           C  
ATOM    116  C   ASN A  10      46.558  42.572  44.974  0.00  0.00           C  
ATOM    117  O   ASN A  10      46.147  42.662  43.814  0.00  0.00           O  
ATOM    118  CB  ASN A  10      48.520  44.139  45.194  0.00  0.00           C  
ATOM    119  CG  ASN A  10      50.004  44.245  45.525  0.00  0.00           C  
ATOM    120  OD1 ASN A  10      50.385  44.326  46.688  0.00  0.00           O  
ATOM    121  ND2 ASN A  10      50.869  44.209  44.523  0.00  0.00           N  
ATOM    122  H   ASN A  10      48.365  41.984  43.328  0.00  0.00           H  
ATOM    123  HA  ASN A  10      48.251  42.298  46.280  0.00  0.00           H  
ATOM    124  HB2 ASN A  10      48.327  44.528  44.194  0.00  0.00           H  
ATOM    125  HB3 ASN A  10      47.954  44.742  45.905  0.00  0.00           H  
ATOM    126 HD21 ASN A  10      50.536  44.213  43.550  0.00  0.00           H  
ATOM    127 HD22 ASN A  10      51.857  44.235  44.704  0.00  0.00           H  
ATOM    128  N   LEU A  11      45.749  42.348  46.003  0.00  0.00           N  
ATOM    129  CA  LEU A  11      44.343  41.995  45.884  0.00  0.00           C  
ATOM    130  C   LEU A  11      43.500  43.255  45.661  0.00  0.00           C  
ATOM    131  O   LEU A  11      42.750  43.679  46.539  0.00  0.00           O  
ATOM    132  CB  LEU A  11      43.962  41.168  47.120  0.00  0.00           C  
ATOM    133  CG  LEU A  11      42.686  40.330  46.947  0.00  0.00           C  
ATOM    134  CD1 LEU A  11      42.865  39.226  45.893  0.00  0.00           C  
ATOM    135  CD2 LEU A  11      42.364  39.670  48.290  0.00  0.00           C  
ATOM    136  H   LEU A  11      46.141  42.355  46.941  0.00  0.00           H  
ATOM    137  HA  LEU A  11      44.237  41.369  44.998  0.00  0.00           H  
ATOM    138  HB2 LEU A  11      44.780  40.489  47.361  0.00  0.00           H  
ATOM    139  HB3 LEU A  11      43.851  41.841  47.967  0.00  0.00           H  
ATOM    140  HG  LEU A  11      41.859  40.975  46.657  0.00  0.00           H  
ATOM    141 HD11 LEU A  11      43.790  38.677  46.069  0.00  0.00           H  
ATOM    142 HD12 LEU A  11      42.037  38.521  45.943  0.00  0.00           H  
ATOM    143 HD13 LEU A  11      42.885  39.657  44.892  0.00  0.00           H  
ATOM    144 HD21 LEU A  11      41.423  39.126  48.221  0.00  0.00           H  
ATOM    145 HD22 LEU A  11      43.158  38.978  48.568  0.00  0.00           H  
ATOM    146 HD23 LEU A  11      42.263  40.433  49.061  0.00  0.00           H  
ATOM    147  N   TRP A  12      43.713  43.879  44.500  0.00  0.00           N  
ATOM    148  CA  TRP A  12      43.166  45.142  44.010  0.00  0.00           C  
ATOM    149  C   TRP A  12      41.727  45.382  44.464  0.00  0.00           C  
ATOM    150  O   TRP A  12      41.451  46.462  44.987  0.00  0.00           O  
ATOM    151  CB  TRP A  12      43.331  45.130  42.478  0.00  0.00           C  
ATOM    152  CG  TRP A  12      42.669  46.151  41.591  0.00  0.00           C  
ATOM    153  CD1 TRP A  12      42.000  47.276  41.936  0.00  0.00           C  
ATOM    154  CD2 TRP A  12      42.583  46.103  40.135  0.00  0.00           C  
ATOM    155  NE1 TRP A  12      41.490  47.895  40.814  0.00  0.00           N  
ATOM    156  CE2 TRP A  12      41.780  47.187  39.673  0.00  0.00           C  
ATOM    157  CE3 TRP A  12      43.095  45.228  39.159  0.00  0.00           C  
ATOM    158  CZ2 TRP A  12      41.454  47.359  38.319  0.00  0.00           C  
ATOM    159  CZ3 TRP A  12      42.777  45.389  37.802  0.00  0.00           C  
ATOM    160  CH2 TRP A  12      41.948  46.442  37.378  0.00  0.00           C  
ATOM    161  H   TRP A  12      44.377  43.425  43.884  0.00  0.00           H  
ATOM    162  HA  TRP A  12      43.775  45.952  44.410  0.00  0.00           H  
ATOM    163  HB2 TRP A  12      44.399  45.179  42.271  0.00  0.00           H  
ATOM    164  HB3 TRP A  12      42.984  44.163  42.114  0.00  0.00           H  
ATOM    165  HD1 TRP A  12      41.840  47.629  42.940  0.00  0.00           H  
ATOM    166  HE1 TRP A  12      40.965  48.762  40.852  0.00  0.00           H  
ATOM    167  HE3 TRP A  12      43.734  44.415  39.462  0.00  0.00           H  
ATOM    168  HZ2 TRP A  12      40.847  48.195  38.003  0.00  0.00           H  
ATOM    169  HZ3 TRP A  12      43.181  44.695  37.088  0.00  0.00           H  
ATOM    170  HH2 TRP A  12      41.721  46.565  36.328  0.00  0.00           H  
ATOM    171  N   LYS A  13      40.829  44.401  44.321  0.00  0.00           N  
ATOM    172  CA  LYS A  13      39.463  44.495  44.831  0.00  0.00           C  
ATOM    173  C   LYS A  13      39.024  43.153  45.382  0.00  0.00           C  
ATOM    174  O   LYS A  13      39.547  42.118  44.967  0.00  0.00           O  
ATOM    175  CB  LYS A  13      38.483  45.020  43.772  0.00  0.00           C  
ATOM    176  CG  LYS A  13      38.661  46.531  43.536  0.00  0.00           C  
ATOM    177  CD  LYS A  13      37.566  47.156  42.664  0.00  0.00           C  
ATOM    178  CE  LYS A  13      37.592  46.520  41.273  0.00  0.00           C  
ATOM    179  NZ  LYS A  13      36.666  47.189  40.322  0.00  0.00           N  
ATOM    180  H   LYS A  13      41.140  43.490  44.004  0.00  0.00           H  
ATOM    181  HA  LYS A  13      39.441  45.194  45.652  0.00  0.00           H  
ATOM    182  HB2 LYS A  13      38.611  44.461  42.845  0.00  0.00           H  
ATOM    183  HB3 LYS A  13      37.472  44.863  44.144  0.00  0.00           H  
ATOM    184  HG2 LYS A  13      38.660  47.047  44.496  0.00  0.00           H  
ATOM    185  HG3 LYS A  13      39.618  46.705  43.055  0.00  0.00           H  
ATOM    186  HD2 LYS A  13      36.592  47.008  43.133  0.00  0.00           H  
ATOM    187  HD3 LYS A  13      37.760  48.226  42.583  0.00  0.00           H  
ATOM    188  HE2 LYS A  13      38.619  46.579  40.902  0.00  0.00           H  
ATOM    189  HE3 LYS A  13      37.331  45.463  41.375  0.00  0.00           H  
ATOM    190  HZ1 LYS A  13      35.709  47.145  40.642  0.00  0.00           H  
ATOM    191  HZ2 LYS A  13      36.907  48.162  40.197  0.00  0.00           H  
ATOM    192  HZ3 LYS A  13      36.703  46.751  39.412  0.00  0.00           H  
ATOM    193  N   VAL A  14      38.049  43.180  46.285  0.00  0.00           N  
ATOM    194  CA  VAL A  14      37.415  42.003  46.864  0.00  0.00           C  
ATOM    195  C   VAL A  14      35.906  42.243  46.782  0.00  0.00           C  
ATOM    196  O   VAL A  14      35.434  43.374  46.932  0.00  0.00           O  
ATOM    197  CB  VAL A  14      37.942  41.753  48.296  0.00  0.00           C  
ATOM    198  CG1 VAL A  14      37.234  40.584  48.995  0.00  0.00           C  
ATOM    199  CG2 VAL A  14      39.439  41.410  48.273  0.00  0.00           C  
ATOM    200  H   VAL A  14      37.650  44.079  46.548  0.00  0.00           H  
ATOM    201  HA  VAL A  14      37.657  41.131  46.255  0.00  0.00           H  
ATOM    202  HB  VAL A  14      37.797  42.651  48.897  0.00  0.00           H  
ATOM    203 HG11 VAL A  14      36.182  40.821  49.155  0.00  0.00           H  
ATOM    204 HG12 VAL A  14      37.325  39.675  48.399  0.00  0.00           H  
ATOM    205 HG13 VAL A  14      37.684  40.412  49.973  0.00  0.00           H  
ATOM    206 HG21 VAL A  14      39.795  41.192  49.280  0.00  0.00           H  
ATOM    207 HG22 VAL A  14      39.603  40.537  47.642  0.00  0.00           H  
ATOM    208 HG23 VAL A  14      40.018  42.242  47.877  0.00  0.00           H  
ATOM    209  N   HIS A  15      35.158  41.169  46.535  0.00  0.00           N  
ATOM    210  CA  HIS A  15      33.732  41.184  46.199  0.00  0.00           C  
ATOM    211  C   HIS A  15      32.962  40.108  46.981  0.00  0.00           C  
ATOM    212  O   HIS A  15      31.846  39.739  46.614  0.00  0.00           O  
ATOM    213  CB  HIS A  15      33.570  41.012  44.677  0.00  0.00           C  
ATOM    214  CG  HIS A  15      34.384  41.991  43.864  0.00  0.00           C  
ATOM    215  ND1 HIS A  15      34.209  43.356  43.807  0.00  0.00           N  
ATOM    216  CD2 HIS A  15      35.490  41.695  43.111  0.00  0.00           C  
ATOM    217  CE1 HIS A  15      35.188  43.866  43.041  0.00  0.00           C  
ATOM    218  NE2 HIS A  15      36.001  42.892  42.597  0.00  0.00           N  
ATOM    219  H   HIS A  15      35.637  40.275  46.454  0.00  0.00           H  
ATOM    220  HA  HIS A  15      33.315  42.152  46.481  0.00  0.00           H  
ATOM    221  HB2 HIS A  15      33.864  39.999  44.401  0.00  0.00           H  
ATOM    222  HB3 HIS A  15      32.519  41.136  44.413  0.00  0.00           H  
ATOM    223  HD1 HIS A  15      33.490  43.893  44.279  0.00  0.00           H  
ATOM    224  HD2 HIS A  15      35.909  40.710  42.966  0.00  0.00           H  
ATOM    225  HE1 HIS A  15      35.324  44.922  42.838  0.00  0.00           H  
ATOM    226  N   VAL A  16      33.557  39.606  48.064  0.00  0.00           N  
ATOM    227  CA  VAL A  16      32.989  38.625  48.979  0.00  0.00           C  
ATOM    228  C   VAL A  16      33.067  39.168  50.404  0.00  0.00           C  
ATOM    229  O   VAL A  16      33.890  40.038  50.704  0.00  0.00           O  
ATOM    230  CB  VAL A  16      33.723  37.275  48.844  0.00  0.00           C  
ATOM    231  CG1 VAL A  16      33.217  36.538  47.608  0.00  0.00           C  
ATOM    232  CG2 VAL A  16      35.255  37.399  48.773  0.00  0.00           C  
ATOM    233  H   VAL A  16      34.475  39.945  48.305  0.00  0.00           H  
ATOM    234  HA  VAL A  16      31.933  38.478  48.744  0.00  0.00           H  
ATOM    235  HB  VAL A  16      33.476  36.661  49.711  0.00  0.00           H  
ATOM    236 HG11 VAL A  16      33.684  35.554  47.549  0.00  0.00           H  
ATOM    237 HG12 VAL A  16      32.137  36.406  47.683  0.00  0.00           H  
ATOM    238 HG13 VAL A  16      33.443  37.110  46.710  0.00  0.00           H  
ATOM    239 HG21 VAL A  16      35.563  37.976  47.904  0.00  0.00           H  
ATOM    240 HG22 VAL A  16      35.634  37.875  49.678  0.00  0.00           H  
ATOM    241 HG23 VAL A  16      35.701  36.413  48.679  0.00  0.00           H  
ATOM    242  N   LYS A  17      32.207  38.645  51.280  0.00  0.00           N  
ATOM    243  CA  LYS A  17      32.106  39.015  52.685  0.00  0.00           C  
ATOM    244  C   LYS A  17      31.761  37.737  53.448  0.00  0.00           C  
ATOM    245  O   LYS A  17      31.189  36.824  52.853  0.00  0.00           O  
ATOM    246  CB  LYS A  17      30.981  40.051  52.893  0.00  0.00           C  
ATOM    247  CG  LYS A  17      31.111  41.318  52.027  0.00  0.00           C  
ATOM    248  CD  LYS A  17      30.012  42.354  52.312  0.00  0.00           C  
ATOM    249  CE  LYS A  17      28.574  41.885  52.023  0.00  0.00           C  
ATOM    250  NZ  LYS A  17      28.314  41.595  50.590  0.00  0.00           N  
ATOM    251  H   LYS A  17      31.597  37.888  50.992  0.00  0.00           H  
ATOM    252  HA  LYS A  17      33.065  39.422  53.013  0.00  0.00           H  
ATOM    253  HB2 LYS A  17      30.024  39.575  52.678  0.00  0.00           H  
ATOM    254  HB3 LYS A  17      30.975  40.348  53.943  0.00  0.00           H  
ATOM    255  HG2 LYS A  17      32.079  41.778  52.226  0.00  0.00           H  
ATOM    256  HG3 LYS A  17      31.068  41.052  50.971  0.00  0.00           H  
ATOM    257  HD2 LYS A  17      30.073  42.640  53.362  0.00  0.00           H  
ATOM    258  HD3 LYS A  17      30.217  43.249  51.721  0.00  0.00           H  
ATOM    259  HE2 LYS A  17      28.351  41.000  52.624  0.00  0.00           H  
ATOM    260  HE3 LYS A  17      27.897  42.679  52.345  0.00  0.00           H  
ATOM    261  HZ1 LYS A  17      28.721  40.708  50.287  0.00  0.00           H  
ATOM    262  HZ2 LYS A  17      27.321  41.511  50.427  0.00  0.00           H  
ATOM    263  HZ3 LYS A  17      28.654  42.334  49.992  0.00  0.00           H  
ATOM    264  N   ALA A  18      32.045  37.659  54.748  0.00  0.00           N  
ATOM    265  CA  ALA A  18      31.548  36.561  55.572  0.00  0.00           C  
ATOM    266  C   ALA A  18      30.016  36.531  55.497  0.00  0.00           C  
ATOM    267  O   ALA A  18      29.366  37.574  55.616  0.00  0.00           O  
ATOM    268  CB  ALA A  18      32.035  36.723  57.016  0.00  0.00           C  
ATOM    269  H   ALA A  18      32.499  38.431  55.206  0.00  0.00           H  
ATOM    270  HA  ALA A  18      31.944  35.624  55.179  0.00  0.00           H  
ATOM    271  HB1 ALA A  18      33.125  36.719  57.045  0.00  0.00           H  
ATOM    272  HB2 ALA A  18      31.662  37.658  57.437  0.00  0.00           H  
ATOM    273  HB3 ALA A  18      31.663  35.893  57.619  0.00  0.00           H  
ATOM    274  N   GLY A  19      29.441  35.342  55.304  0.00  0.00           N  
ATOM    275  CA  GLY A  19      28.004  35.122  55.202  0.00  0.00           C  
ATOM    276  C   GLY A  19      27.438  35.404  53.805  0.00  0.00           C  
ATOM    277  O   GLY A  19      26.235  35.229  53.604  0.00  0.00           O  
ATOM    278  H   GLY A  19      30.025  34.519  55.196  0.00  0.00           H  
ATOM    279  HA2 GLY A  19      27.803  34.080  55.451  0.00  0.00           H  
ATOM    280  HA3 GLY A  19      27.491  35.756  55.926  0.00  0.00           H  
ATOM    281  N   ASP A  20      28.259  35.849  52.845  0.00  0.00           N  
ATOM    282  CA  ASP A  20      27.831  36.080  51.462  0.00  0.00           C  
ATOM    283  C   ASP A  20      27.688  34.734  50.728  0.00  0.00           C  
ATOM    284  O   ASP A  20      28.075  33.690  51.258  0.00  0.00           O  
ATOM    285  CB  ASP A  20      28.832  37.020  50.768  0.00  0.00           C  
ATOM    286  CG  ASP A  20      28.217  37.907  49.674  0.00  0.00           C  
ATOM    287  OD1 ASP A  20      27.253  37.493  48.995  0.00  0.00           O  
ATOM    288  OD2 ASP A  20      28.698  39.055  49.531  0.00  0.00           O  
ATOM    289  H   ASP A  20      29.245  35.963  53.046  0.00  0.00           H  
ATOM    290  HA  ASP A  20      26.859  36.576  51.481  0.00  0.00           H  
ATOM    291  HB2 ASP A  20      29.234  37.696  51.522  0.00  0.00           H  
ATOM    292  HB3 ASP A  20      29.663  36.442  50.358  0.00  0.00           H  
ATOM    293  N   GLN A  21      27.175  34.740  49.499  0.00  0.00           N  
ATOM    294  CA  GLN A  21      26.966  33.566  48.654  0.00  0.00           C  
ATOM    295  C   GLN A  21      27.794  33.764  47.388  0.00  0.00           C  
ATOM    296  O   GLN A  21      27.803  34.857  46.814  0.00  0.00           O  
ATOM    297  CB  GLN A  21      25.461  33.448  48.326  0.00  0.00           C  
ATOM    298  CG  GLN A  21      25.068  32.391  47.271  0.00  0.00           C  
ATOM    299  CD  GLN A  21      25.112  30.945  47.774  0.00  0.00           C  
ATOM    300  OE1 GLN A  21      24.317  30.548  48.620  0.00  0.00           O  
ATOM    301  NE2 GLN A  21      25.992  30.108  47.248  0.00  0.00           N  
ATOM    302  H   GLN A  21      26.985  35.645  49.071  0.00  0.00           H  
ATOM    303  HA  GLN A  21      27.294  32.662  49.169  0.00  0.00           H  
ATOM    304  HB2 GLN A  21      24.911  33.251  49.248  0.00  0.00           H  
ATOM    305  HB3 GLN A  21      25.125  34.415  47.949  0.00  0.00           H  
ATOM    306  HG2 GLN A  21      24.042  32.597  46.962  0.00  0.00           H  
ATOM    307  HG3 GLN A  21      25.684  32.500  46.378  0.00  0.00           H  
ATOM    308 HE21 GLN A  21      26.652  30.404  46.530  0.00  0.00           H  
ATOM    309 HE22 GLN A  21      25.996  29.146  47.547  0.00  0.00           H  
ATOM    310  N   ILE A  22      28.435  32.693  46.918  0.00  0.00           N  
ATOM    311  CA  ILE A  22      29.161  32.663  45.653  0.00  0.00           C  
ATOM    312  C   ILE A  22      28.779  31.413  44.880  0.00  0.00           C  
ATOM    313  O   ILE A  22      28.201  30.469  45.429  0.00  0.00           O  
ATOM    314  CB  ILE A  22      30.687  32.775  45.874  0.00  0.00           C  
ATOM    315  CG1 ILE A  22      31.278  31.535  46.582  0.00  0.00           C  
ATOM    316  CG2 ILE A  22      31.019  34.075  46.621  0.00  0.00           C  
ATOM    317  CD1 ILE A  22      32.784  31.634  46.819  0.00  0.00           C  
ATOM    318  H   ILE A  22      28.419  31.828  47.453  0.00  0.00           H  
ATOM    319  HA  ILE A  22      28.840  33.502  45.034  0.00  0.00           H  
ATOM    320  HB  ILE A  22      31.155  32.844  44.891  0.00  0.00           H  
ATOM    321 HG12 ILE A  22      30.798  31.397  47.549  0.00  0.00           H  
ATOM    322 HG13 ILE A  22      31.096  30.650  45.973  0.00  0.00           H  
ATOM    323 HG21 ILE A  22      32.091  34.238  46.594  0.00  0.00           H  
ATOM    324 HG22 ILE A  22      30.532  34.921  46.135  0.00  0.00           H  
ATOM    325 HG23 ILE A  22      30.695  34.017  47.660  0.00  0.00           H  
ATOM    326 HD11 ILE A  22      32.977  32.368  47.600  0.00  0.00           H  
ATOM    327 HD12 ILE A  22      33.164  30.664  47.134  0.00  0.00           H  
ATOM    328 HD13 ILE A  22      33.296  31.934  45.909  0.00  0.00           H  
ATOM    329  N   GLU A  23      29.126  31.417  43.598  0.00  0.00           N  
ATOM    330  CA  GLU A  23      28.768  30.402  42.635  0.00  0.00           C  
ATOM    331  C   GLU A  23      30.005  30.233  41.760  0.00  0.00           C  
ATOM    332  O   GLU A  23      30.688  31.221  41.482  0.00  0.00           O  
ATOM    333  CB  GLU A  23      27.540  30.882  41.851  0.00  0.00           C  
ATOM    334  CG  GLU A  23      26.985  29.770  40.961  0.00  0.00           C  
ATOM    335  CD  GLU A  23      25.714  30.214  40.218  0.00  0.00           C  
ATOM    336  OE1 GLU A  23      25.816  30.792  39.111  0.00  0.00           O  
ATOM    337  OE2 GLU A  23      24.592  29.975  40.722  0.00  0.00           O  
ATOM    338  H   GLU A  23      29.717  32.153  43.225  0.00  0.00           H  
ATOM    339  HA  GLU A  23      28.525  29.475  43.148  0.00  0.00           H  
ATOM    340  HB2 GLU A  23      26.763  31.180  42.556  0.00  0.00           H  
ATOM    341  HB3 GLU A  23      27.804  31.747  41.240  0.00  0.00           H  
ATOM    342  HG2 GLU A  23      27.751  29.476  40.242  0.00  0.00           H  
ATOM    343  HG3 GLU A  23      26.764  28.909  41.594  0.00  0.00           H  
ATOM    344  N   LYS A  24      30.334  29.001  41.372  0.00  0.00           N  
ATOM    345  CA  LYS A  24      31.542  28.697  40.612  0.00  0.00           C  
ATOM    346  C   LYS A  24      31.621  29.606  39.378  0.00  0.00           C  
ATOM    347  O   LYS A  24      30.699  29.619  38.559  0.00  0.00           O  
ATOM    348  CB  LYS A  24      31.546  27.199  40.268  0.00  0.00           C  
ATOM    349  CG  LYS A  24      32.870  26.758  39.629  0.00  0.00           C  
ATOM    350  CD  LYS A  24      32.929  25.227  39.499  0.00  0.00           C  
ATOM    351  CE  LYS A  24      34.309  24.715  39.059  0.00  0.00           C  
ATOM    352  NZ  LYS A  24      34.664  25.100  37.668  0.00  0.00           N  
ATOM    353  H   LYS A  24      29.744  28.226  41.663  0.00  0.00           H  
ATOM    354  HA  LYS A  24      32.394  28.905  41.258  0.00  0.00           H  
ATOM    355  HB2 LYS A  24      31.397  26.635  41.190  0.00  0.00           H  
ATOM    356  HB3 LYS A  24      30.717  26.970  39.597  0.00  0.00           H  
ATOM    357  HG2 LYS A  24      32.967  27.214  38.643  0.00  0.00           H  
ATOM    358  HG3 LYS A  24      33.695  27.097  40.254  0.00  0.00           H  
ATOM    359  HD2 LYS A  24      32.713  24.784  40.473  0.00  0.00           H  
ATOM    360  HD3 LYS A  24      32.166  24.886  38.798  0.00  0.00           H  
ATOM    361  HE2 LYS A  24      35.062  25.096  39.755  0.00  0.00           H  
ATOM    362  HE3 LYS A  24      34.311  23.626  39.140  0.00  0.00           H  
ATOM    363  HZ1 LYS A  24      35.561  24.714  37.415  0.00  0.00           H  
ATOM    364  HZ2 LYS A  24      33.987  24.748  37.007  0.00  0.00           H  
ATOM    365  HZ3 LYS A  24      34.725  26.101  37.563  0.00  0.00           H  
ATOM    366  N   GLY A  25      32.711  30.368  39.261  0.00  0.00           N  
ATOM    367  CA  GLY A  25      32.948  31.290  38.154  0.00  0.00           C  
ATOM    368  C   GLY A  25      32.472  32.728  38.406  0.00  0.00           C  
ATOM    369  O   GLY A  25      32.690  33.578  37.543  0.00  0.00           O  
ATOM    370  H   GLY A  25      33.447  30.274  39.954  0.00  0.00           H  
ATOM    371  HA2 GLY A  25      34.018  31.307  37.951  0.00  0.00           H  
ATOM    372  HA3 GLY A  25      32.448  30.913  37.260  0.00  0.00           H  
ATOM    373  N   GLN A  26      31.839  33.036  39.546  0.00  0.00           N  
ATOM    374  CA  GLN A  26      31.450  34.395  39.913  0.00  0.00           C  
ATOM    375  C   GLN A  26      32.715  35.103  40.425  0.00  0.00           C  
ATOM    376  O   GLN A  26      33.562  34.473  41.055  0.00  0.00           O  
ATOM    377  CB  GLN A  26      30.318  34.322  40.965  0.00  0.00           C  
ATOM    378  CG  GLN A  26      29.352  35.519  40.983  0.00  0.00           C  
ATOM    379  CD  GLN A  26      30.045  36.835  41.317  0.00  0.00           C  
ATOM    380  OE1 GLN A  26      30.271  37.667  40.442  0.00  0.00           O  
ATOM    381  NE2 GLN A  26      30.460  37.018  42.559  0.00  0.00           N  
ATOM    382  H   GLN A  26      31.718  32.332  40.263  0.00  0.00           H  
ATOM    383  HA  GLN A  26      31.075  34.903  39.023  0.00  0.00           H  
ATOM    384  HB2 GLN A  26      29.699  33.453  40.744  0.00  0.00           H  
ATOM    385  HB3 GLN A  26      30.751  34.178  41.957  0.00  0.00           H  
ATOM    386  HG2 GLN A  26      28.871  35.602  40.008  0.00  0.00           H  
ATOM    387  HG3 GLN A  26      28.574  35.329  41.724  0.00  0.00           H  
ATOM    388 HE21 GLN A  26      30.265  36.335  43.274  0.00  0.00           H  
ATOM    389 HE22 GLN A  26      31.171  37.727  42.731  0.00  0.00           H  
ATOM    390  N   GLU A  27      32.873  36.391  40.138  0.00  0.00           N  
ATOM    391  CA  GLU A  27      34.035  37.194  40.517  0.00  0.00           C  
ATOM    392  C   GLU A  27      34.027  37.448  42.028  0.00  0.00           C  
ATOM    393  O   GLU A  27      33.077  38.026  42.561  0.00  0.00           O  
ATOM    394  CB  GLU A  27      34.012  38.497  39.704  0.00  0.00           C  
ATOM    395  CG  GLU A  27      35.262  39.367  39.902  0.00  0.00           C  
ATOM    396  CD  GLU A  27      35.226  40.583  38.958  0.00  0.00           C  
ATOM    397  OE1 GLU A  27      34.478  41.550  39.228  0.00  0.00           O  
ATOM    398  OE2 GLU A  27      35.924  40.569  37.919  0.00  0.00           O  
ATOM    399  H   GLU A  27      32.095  36.877  39.713  0.00  0.00           H  
ATOM    400  HA  GLU A  27      34.943  36.651  40.260  0.00  0.00           H  
ATOM    401  HB2 GLU A  27      33.944  38.239  38.646  0.00  0.00           H  
ATOM    402  HB3 GLU A  27      33.127  39.077  39.968  0.00  0.00           H  
ATOM    403  HG2 GLU A  27      35.313  39.705  40.939  0.00  0.00           H  
ATOM    404  HG3 GLU A  27      36.151  38.764  39.701  0.00  0.00           H  
ATOM    405  N   VAL A  28      35.094  37.040  42.715  0.00  0.00           N  
ATOM    406  CA  VAL A  28      35.234  37.158  44.161  0.00  0.00           C  
ATOM    407  C   VAL A  28      36.358  38.129  44.527  0.00  0.00           C  
ATOM    408  O   VAL A  28      36.275  38.760  45.580  0.00  0.00           O  
ATOM    409  CB  VAL A  28      35.407  35.763  44.800  0.00  0.00           C  
ATOM    410  CG1 VAL A  28      34.132  34.928  44.621  0.00  0.00           C  
ATOM    411  CG2 VAL A  28      36.578  34.947  44.230  0.00  0.00           C  
ATOM    412  H   VAL A  28      35.855  36.575  42.233  0.00  0.00           H  
ATOM    413  HA  VAL A  28      34.319  37.587  44.570  0.00  0.00           H  
ATOM    414  HB  VAL A  28      35.577  35.898  45.869  0.00  0.00           H  
ATOM    415 HG11 VAL A  28      34.209  34.018  45.215  0.00  0.00           H  
ATOM    416 HG12 VAL A  28      33.261  35.496  44.948  0.00  0.00           H  
ATOM    417 HG13 VAL A  28      33.992  34.663  43.575  0.00  0.00           H  
ATOM    418 HG21 VAL A  28      36.396  34.706  43.184  0.00  0.00           H  
ATOM    419 HG22 VAL A  28      37.510  35.507  44.316  0.00  0.00           H  
ATOM    420 HG23 VAL A  28      36.682  34.015  44.787  0.00  0.00           H  
ATOM    421  N   ALA A  29      37.361  38.330  43.665  0.00  0.00           N  
ATOM    422  CA  ALA A  29      38.389  39.344  43.856  0.00  0.00           C  
ATOM    423  C   ALA A  29      39.010  39.702  42.504  0.00  0.00           C  
ATOM    424  O   ALA A  29      38.664  39.115  41.478  0.00  0.00           O  
ATOM    425  CB  ALA A  29      39.442  38.832  44.852  0.00  0.00           C  
ATOM    426  H   ALA A  29      37.412  37.813  42.788  0.00  0.00           H  
ATOM    427  HA  ALA A  29      37.928  40.244  44.264  0.00  0.00           H  
ATOM    428  HB1 ALA A  29      39.929  37.936  44.474  0.00  0.00           H  
ATOM    429  HB2 ALA A  29      40.192  39.605  45.015  0.00  0.00           H  
ATOM    430  HB3 ALA A  29      38.973  38.608  45.810  0.00  0.00           H  
ATOM    431  N   ILE A  30      39.947  40.645  42.499  0.00  0.00           N  
ATOM    432  CA  ILE A  30      40.780  40.952  41.340  0.00  0.00           C  
ATOM    433  C   ILE A  30      42.209  41.128  41.848  0.00  0.00           C  
ATOM    434  O   ILE A  30      42.422  41.682  42.929  0.00  0.00           O  
ATOM    435  CB  ILE A  30      40.292  42.221  40.593  0.00  0.00           C  
ATOM    436  CG1 ILE A  30      38.788  42.156  40.243  0.00  0.00           C  
ATOM    437  CG2 ILE A  30      41.127  42.428  39.313  0.00  0.00           C  
ATOM    438  CD1 ILE A  30      38.269  43.398  39.509  0.00  0.00           C  
ATOM    439  H   ILE A  30      40.160  41.117  43.375  0.00  0.00           H  
ATOM    440  HA  ILE A  30      40.754  40.110  40.648  0.00  0.00           H  
ATOM    441  HB  ILE A  30      40.448  43.083  41.244  0.00  0.00           H  
ATOM    442 HG12 ILE A  30      38.587  41.274  39.634  0.00  0.00           H  
ATOM    443 HG13 ILE A  30      38.217  42.071  41.166  0.00  0.00           H  
ATOM    444 HG21 ILE A  30      42.177  42.562  39.563  0.00  0.00           H  
ATOM    445 HG22 ILE A  30      41.024  41.568  38.650  0.00  0.00           H  
ATOM    446 HG23 ILE A  30      40.823  43.333  38.792  0.00  0.00           H  
ATOM    447 HD11 ILE A  30      38.651  44.297  39.994  0.00  0.00           H  
ATOM    448 HD12 ILE A  30      38.590  43.385  38.467  0.00  0.00           H  
ATOM    449 HD13 ILE A  30      37.179  43.405  39.536  0.00  0.00           H  
ATOM    450  N   LEU A  31      43.176  40.672  41.054  0.00  0.00           N  
ATOM    451  CA  LEU A  31      44.589  40.933  41.248  0.00  0.00           C  
ATOM    452  C   LEU A  31      44.997  42.080  40.344  0.00  0.00           C  
ATOM    453  O   LEU A  31      44.773  42.038  39.129  0.00  0.00           O  
ATOM    454  CB  LEU A  31      45.431  39.726  40.833  0.00  0.00           C  
ATOM    455  CG  LEU A  31      45.436  38.576  41.839  0.00  0.00           C  
ATOM    456  CD1 LEU A  31      46.329  37.473  41.260  0.00  0.00           C  
ATOM    457  CD2 LEU A  31      45.962  38.994  43.214  0.00  0.00           C  
ATOM    458  H   LEU A  31      42.918  40.240  40.171  0.00  0.00           H  
ATOM    459  HA  LEU A  31      44.788  41.196  42.285  0.00  0.00           H  
ATOM    460  HB2 LEU A  31      45.055  39.368  39.877  0.00  0.00           H  
ATOM    461  HB3 LEU A  31      46.463  40.044  40.673  0.00  0.00           H  
ATOM    462  HG  LEU A  31      44.418  38.204  41.961  0.00  0.00           H  
ATOM    463 HD11 LEU A  31      47.357  37.833  41.182  0.00  0.00           H  
ATOM    464 HD12 LEU A  31      46.311  36.594  41.893  0.00  0.00           H  
ATOM    465 HD13 LEU A  31      45.979  37.192  40.267  0.00  0.00           H  
ATOM    466 HD21 LEU A  31      45.255  39.658  43.714  0.00  0.00           H  
ATOM    467 HD22 LEU A  31      46.078  38.107  43.830  0.00  0.00           H  
ATOM    468 HD23 LEU A  31      46.924  39.497  43.113  0.00  0.00           H  
ATOM    469  N   GLU A  32      45.669  43.048  40.951  0.00  0.00           N  
ATOM    470  CA  GLU A  32      46.787  43.706  40.314  0.00  0.00           C  
ATOM    471  C   GLU A  32      47.954  42.746  40.502  0.00  0.00           C  
ATOM    472  O   GLU A  32      48.090  42.131  41.561  0.00  0.00           O  
ATOM    473  CB  GLU A  32      47.041  45.056  41.011  0.00  0.00           C  
ATOM    474  CG  GLU A  32      48.360  45.755  40.631  0.00  0.00           C  
ATOM    475  CD  GLU A  32      49.437  45.626  41.727  0.00  0.00           C  
ATOM    476  OE1 GLU A  32      50.125  44.583  41.806  0.00  0.00           O  
ATOM    477  OE2 GLU A  32      49.601  46.585  42.516  0.00  0.00           O  
ATOM    478  H   GLU A  32      45.835  42.908  41.942  0.00  0.00           H  
ATOM    479  HA  GLU A  32      46.600  43.852  39.251  0.00  0.00           H  
ATOM    480  HB2 GLU A  32      46.214  45.717  40.749  0.00  0.00           H  
ATOM    481  HB3 GLU A  32      47.014  44.912  42.092  0.00  0.00           H  
ATOM    482  HG2 GLU A  32      48.734  45.376  39.677  0.00  0.00           H  
ATOM    483  HG3 GLU A  32      48.147  46.815  40.486  0.00  0.00           H  
ATOM    484  N   SER A  33      48.797  42.638  39.489  0.00  0.00           N  
ATOM    485  CA  SER A  33      50.012  41.862  39.545  0.00  0.00           C  
ATOM    486  C   SER A  33      51.097  42.683  38.869  0.00  0.00           C  
ATOM    487  O   SER A  33      51.361  42.524  37.678  0.00  0.00           O  
ATOM    488  CB  SER A  33      49.754  40.517  38.875  0.00  0.00           C  
ATOM    489  OG  SER A  33      49.147  39.616  39.776  0.00  0.00           O  
ATOM    490  H   SER A  33      48.548  43.057  38.599  0.00  0.00           H  
ATOM    491  HA  SER A  33      50.312  41.693  40.578  0.00  0.00           H  
ATOM    492  HB2 SER A  33      49.091  40.672  38.028  0.00  0.00           H  
ATOM    493  HB3 SER A  33      50.697  40.113  38.525  0.00  0.00           H  
ATOM    494  HG  SER A  33      49.858  39.277  40.355  0.00  0.00           H  
ATOM    495  N   MET A  34      51.681  43.612  39.628  0.00  0.00           N  
ATOM    496  CA  MET A  34      52.790  44.460  39.198  0.00  0.00           C  
ATOM    497  C   MET A  34      52.481  45.146  37.853  0.00  0.00           C  
ATOM    498  O   MET A  34      53.327  45.174  36.952  0.00  0.00           O  
ATOM    499  CB  MET A  34      54.118  43.669  39.223  0.00  0.00           C  
ATOM    500  CG  MET A  34      54.449  43.047  40.592  0.00  0.00           C  
ATOM    501  SD  MET A  34      53.594  41.492  41.003  0.00  0.00           S  
ATOM    502  CE  MET A  34      54.105  41.296  42.731  0.00  0.00           C  
ATOM    503  H   MET A  34      51.303  43.775  40.562  0.00  0.00           H  
ATOM    504  HA  MET A  34      52.875  45.257  39.937  0.00  0.00           H  
ATOM    505  HB2 MET A  34      54.100  42.882  38.467  0.00  0.00           H  
ATOM    506  HB3 MET A  34      54.925  44.359  38.971  0.00  0.00           H  
ATOM    507  HG2 MET A  34      55.521  42.845  40.616  0.00  0.00           H  
ATOM    508  HG3 MET A  34      54.238  43.783  41.369  0.00  0.00           H  
ATOM    509  HE1 MET A  34      53.668  40.384  43.139  0.00  0.00           H  
ATOM    510  HE2 MET A  34      55.192  41.230  42.789  0.00  0.00           H  
ATOM    511  HE3 MET A  34      53.762  42.149  43.316  0.00  0.00           H  
ATOM    512  N   LYS A  35      51.240  45.662  37.750  0.00  0.00           N  
ATOM    513  CA  LYS A  35      50.629  46.418  36.653  0.00  0.00           C  
ATOM    514  C   LYS A  35      49.903  45.537  35.618  0.00  0.00           C  
ATOM    515  O   LYS A  35      49.440  46.060  34.605  0.00  0.00           O  
ATOM    516  CB  LYS A  35      51.566  47.461  36.008  0.00  0.00           C  
ATOM    517  CG  LYS A  35      52.168  48.431  37.037  0.00  0.00           C  
ATOM    518  CD  LYS A  35      52.955  49.546  36.338  0.00  0.00           C  
ATOM    519  CE  LYS A  35      53.628  50.495  37.334  0.00  0.00           C  
ATOM    520  NZ  LYS A  35      52.626  51.349  37.951  0.00  0.00           N  
ATOM    521  H   LYS A  35      50.641  45.542  38.555  0.00  0.00           H  
ATOM    522  HA  LYS A  35      49.837  46.983  37.139  0.00  0.00           H  
ATOM    523  HB2 LYS A  35      52.360  46.966  35.449  0.00  0.00           H  
ATOM    524  HB3 LYS A  35      50.982  48.049  35.298  0.00  0.00           H  
ATOM    525  HG2 LYS A  35      51.361  48.870  37.619  0.00  0.00           H  
ATOM    526  HG3 LYS A  35      52.838  47.896  37.710  0.00  0.00           H  
ATOM    527  HD2 LYS A  35      53.728  49.097  35.713  0.00  0.00           H  
ATOM    528  HD3 LYS A  35      52.275  50.123  35.706  0.00  0.00           H  
ATOM    529  HE2 LYS A  35      54.174  49.923  38.085  0.00  0.00           H  
ATOM    530  HE3 LYS A  35      54.333  51.128  36.796  0.00  0.00           H  
ATOM    531  HZ1 LYS A  35      52.149  51.988  37.331  0.00  0.00           H  
ATOM    532  N   MET A  36      49.764  44.225  35.875  0.00  0.00           N  
ATOM    533  CA  MET A  36      48.917  43.312  35.105  0.00  0.00           C  
ATOM    534  C   MET A  36      47.594  43.127  35.861  0.00  0.00           C  
ATOM    535  O   MET A  36      47.502  43.463  37.044  0.00  0.00           O  
ATOM    536  CB  MET A  36      49.625  41.960  34.911  0.00  0.00           C  
ATOM    537  CG  MET A  36      50.962  42.100  34.170  0.00  0.00           C  
ATOM    538  SD  MET A  36      51.848  40.541  33.883  0.00  0.00           S  
ATOM    539  CE  MET A  36      52.408  40.172  35.570  0.00  0.00           C  
ATOM    540  H   MET A  36      50.162  43.830  36.719  0.00  0.00           H  
ATOM    541  HA  MET A  36      48.706  43.734  34.121  0.00  0.00           H  
ATOM    542  HB2 MET A  36      49.788  41.496  35.882  0.00  0.00           H  
ATOM    543  HB3 MET A  36      48.977  41.302  34.329  0.00  0.00           H  
ATOM    544  HG2 MET A  36      50.767  42.563  33.202  0.00  0.00           H  
ATOM    545  HG3 MET A  36      51.618  42.765  34.733  0.00  0.00           H  
ATOM    546  HE1 MET A  36      53.016  39.267  35.563  0.00  0.00           H  
ATOM    547  HE2 MET A  36      53.003  41.002  35.951  0.00  0.00           H  
ATOM    548  HE3 MET A  36      51.548  40.019  36.222  0.00  0.00           H  
ATOM    549  N   GLU A  37      46.576  42.581  35.197  0.00  0.00           N  
ATOM    550  CA  GLU A  37      45.207  42.529  35.698  0.00  0.00           C  
ATOM    551  C   GLU A  37      44.663  41.111  35.520  0.00  0.00           C  
ATOM    552  O   GLU A  37      44.699  40.577  34.409  0.00  0.00           O  
ATOM    553  CB  GLU A  37      44.349  43.591  34.976  0.00  0.00           C  
ATOM    554  CG  GLU A  37      44.389  43.588  33.437  0.00  0.00           C  
ATOM    555  CD  GLU A  37      43.541  44.731  32.852  0.00  0.00           C  
ATOM    556  OE1 GLU A  37      42.307  44.571  32.707  0.00  0.00           O  
ATOM    557  OE2 GLU A  37      44.100  45.795  32.501  0.00  0.00           O  
ATOM    558  H   GLU A  37      46.715  42.258  34.250  0.00  0.00           H  
ATOM    559  HA  GLU A  37      45.200  42.770  36.761  0.00  0.00           H  
ATOM    560  HB2 GLU A  37      43.314  43.456  35.286  0.00  0.00           H  
ATOM    561  HB3 GLU A  37      44.683  44.573  35.316  0.00  0.00           H  
ATOM    562  HG2 GLU A  37      45.421  43.695  33.095  0.00  0.00           H  
ATOM    563  HG3 GLU A  37      44.008  42.638  33.060  0.00  0.00           H  
ATOM    564  N   ILE A  38      44.187  40.487  36.607  0.00  0.00           N  
ATOM    565  CA  ILE A  38      43.707  39.103  36.585  0.00  0.00           C  
ATOM    566  C   ILE A  38      42.444  39.008  37.461  0.00  0.00           C  
ATOM    567  O   ILE A  38      42.549  39.178  38.679  0.00  0.00           O  
ATOM    568  CB  ILE A  38      44.802  38.095  37.044  0.00  0.00           C  
ATOM    569  CG1 ILE A  38      46.190  38.274  36.382  0.00  0.00           C  
ATOM    570  CG2 ILE A  38      44.341  36.659  36.753  0.00  0.00           C  
ATOM    571  CD1 ILE A  38      47.119  39.197  37.167  0.00  0.00           C  
ATOM    572  H   ILE A  38      44.225  40.955  37.511  0.00  0.00           H  
ATOM    573  HA  ILE A  38      43.456  38.843  35.558  0.00  0.00           H  
ATOM    574  HB  ILE A  38      44.932  38.171  38.121  0.00  0.00           H  
ATOM    575 HG12 ILE A  38      46.703  37.314  36.325  0.00  0.00           H  
ATOM    576 HG13 ILE A  38      46.085  38.647  35.366  0.00  0.00           H  
ATOM    577 HG21 ILE A  38      45.080  35.951  37.136  0.00  0.00           H  
ATOM    578 HG22 ILE A  38      43.396  36.453  37.254  0.00  0.00           H  
ATOM    579 HG23 ILE A  38      44.225  36.509  35.680  0.00  0.00           H  
ATOM    580 HD11 ILE A  38      46.714  40.205  37.245  0.00  0.00           H  
ATOM    581 HD12 ILE A  38      47.260  38.789  38.168  0.00  0.00           H  
ATOM    582 HD13 ILE A  38      48.081  39.239  36.658  0.00  0.00           H  
ATOM    583  N   PRO A  39      41.246  38.785  36.886  0.00  0.00           N  
ATOM    584  CA  PRO A  39      40.044  38.459  37.649  0.00  0.00           C  
ATOM    585  C   PRO A  39      40.272  37.198  38.483  0.00  0.00           C  
ATOM    586  O   PRO A  39      40.882  36.243  37.995  0.00  0.00           O  
ATOM    587  CB  PRO A  39      38.936  38.194  36.619  0.00  0.00           C  
ATOM    588  CG  PRO A  39      39.433  38.904  35.360  0.00  0.00           C  
ATOM    589  CD  PRO A  39      40.952  38.794  35.464  0.00  0.00           C  
ATOM    590  HA  PRO A  39      39.775  39.305  38.284  0.00  0.00           H  
ATOM    591  HB2 PRO A  39      38.842  37.120  36.424  0.00  0.00           H  
ATOM    592  HB3 PRO A  39      37.978  38.589  36.954  0.00  0.00           H  
ATOM    593  HG2 PRO A  39      39.053  38.433  34.452  0.00  0.00           H  
ATOM    594  HG3 PRO A  39      39.142  39.955  35.396  0.00  0.00           H  
ATOM    595  HD3 PRO A  39      41.292  37.856  35.023  0.00  0.00           H  
ATOM    596  HD2 PRO A  39      41.428  39.642  34.970  0.00  0.00           H  
ATOM    597  N   ILE A  40      39.715  37.151  39.693  0.00  0.00           N  
ATOM    598  CA  ILE A  40      39.770  35.988  40.564  0.00  0.00           C  
ATOM    599  C   ILE A  40      38.319  35.602  40.818  0.00  0.00           C  
ATOM    600  O   ILE A  40      37.533  36.372  41.378  0.00  0.00           O  
ATOM    601  CB  ILE A  40      40.570  36.286  41.853  0.00  0.00           C  
ATOM    602  CG1 ILE A  40      41.913  37.006  41.595  0.00  0.00           C  
ATOM    603  CG2 ILE A  40      40.815  34.995  42.651  0.00  0.00           C  
ATOM    604  CD1 ILE A  40      42.926  36.223  40.744  0.00  0.00           C  
ATOM    605  H   ILE A  40      39.215  37.957  40.059  0.00  0.00           H  
ATOM    606  HA  ILE A  40      40.262  35.168  40.042  0.00  0.00           H  
ATOM    607  HB  ILE A  40      39.968  36.947  42.472  0.00  0.00           H  
ATOM    608 HG12 ILE A  40      41.718  37.960  41.106  0.00  0.00           H  
ATOM    609 HG13 ILE A  40      42.374  37.241  42.555  0.00  0.00           H  
ATOM    610 HG21 ILE A  40      41.432  35.215  43.523  0.00  0.00           H  
ATOM    611 HG22 ILE A  40      39.867  34.579  42.993  0.00  0.00           H  
ATOM    612 HG23 ILE A  40      41.327  34.253  42.036  0.00  0.00           H  
ATOM    613 HD11 ILE A  40      43.606  36.926  40.265  0.00  0.00           H  
ATOM    614 HD12 ILE A  40      43.490  35.537  41.376  0.00  0.00           H  
ATOM    615 HD13 ILE A  40      42.433  35.657  39.959  0.00  0.00           H  
ATOM    616  N   VAL A  41      37.963  34.411  40.357  0.00  0.00           N  
ATOM    617  CA  VAL A  41      36.603  33.902  40.330  0.00  0.00           C  
ATOM    618  C   VAL A  41      36.521  32.675  41.240  0.00  0.00           C  
ATOM    619  O   VAL A  41      37.529  32.009  41.494  0.00  0.00           O  
ATOM    620  CB  VAL A  41      36.169  33.616  38.873  0.00  0.00           C  
ATOM    621  CG1 VAL A  41      35.806  34.907  38.124  0.00  0.00           C  
ATOM    622  CG2 VAL A  41      37.248  32.906  38.035  0.00  0.00           C  
ATOM    623  H   VAL A  41      38.666  33.807  39.958  0.00  0.00           H  
ATOM    624  HA  VAL A  41      35.935  34.656  40.738  0.00  0.00           H  
ATOM    625  HB  VAL A  41      35.277  32.988  38.915  0.00  0.00           H  
ATOM    626 HG11 VAL A  41      36.618  35.633  38.186  0.00  0.00           H  
ATOM    627 HG12 VAL A  41      35.605  34.686  37.075  0.00  0.00           H  
ATOM    628 HG13 VAL A  41      34.900  35.332  38.543  0.00  0.00           H  
ATOM    629 HG21 VAL A  41      36.813  32.570  37.092  0.00  0.00           H  
ATOM    630 HG22 VAL A  41      38.068  33.594  37.804  0.00  0.00           H  
ATOM    631 HG23 VAL A  41      37.630  32.035  38.568  0.00  0.00           H  
ATOM    632  N   ALA A  42      35.323  32.406  41.762  0.00  0.00           N  
ATOM    633  CA  ALA A  42      35.078  31.366  42.743  0.00  0.00           C  
ATOM    634  C   ALA A  42      35.428  30.011  42.137  0.00  0.00           C  
ATOM    635  O   ALA A  42      34.836  29.611  41.132  0.00  0.00           O  
ATOM    636  CB  ALA A  42      33.605  31.392  43.153  0.00  0.00           C  
ATOM    637  H   ALA A  42      34.545  33.013  41.525  0.00  0.00           H  
ATOM    638  HA  ALA A  42      35.696  31.557  43.623  0.00  0.00           H  
ATOM    639  HB1 ALA A  42      33.419  30.624  43.903  0.00  0.00           H  
ATOM    640  HB2 ALA A  42      33.338  32.365  43.558  0.00  0.00           H  
ATOM    641  HB3 ALA A  42      32.989  31.188  42.283  0.00  0.00           H  
ATOM    642  N   ASP A  43      36.358  29.299  42.773  0.00  0.00           N  
ATOM    643  CA  ASP A  43      36.737  27.939  42.383  0.00  0.00           C  
ATOM    644  C   ASP A  43      35.572  26.953  42.543  0.00  0.00           C  
ATOM    645  O   ASP A  43      35.508  25.950  41.835  0.00  0.00           O  
ATOM    646  CB  ASP A  43      37.927  27.470  43.228  0.00  0.00           C  
ATOM    647  CG  ASP A  43      38.348  26.034  42.867  0.00  0.00           C  
ATOM    648  OD1 ASP A  43      38.914  25.825  41.769  0.00  0.00           O  
ATOM    649  OD2 ASP A  43      38.167  25.120  43.701  0.00  0.00           O  
ATOM    650  H   ASP A  43      36.854  29.737  43.536  0.00  0.00           H  
ATOM    651  HA  ASP A  43      37.039  27.946  41.335  0.00  0.00           H  
ATOM    652  HB2 ASP A  43      38.769  28.145  43.065  0.00  0.00           H  
ATOM    653  HB3 ASP A  43      37.657  27.520  44.285  0.00  0.00           H  
ATOM    654  N   ARG A  44      34.643  27.239  43.462  0.00  0.00           N  
ATOM    655  CA  ARG A  44      33.463  26.429  43.750  0.00  0.00           C  
ATOM    656  C   ARG A  44      32.409  27.313  44.412  0.00  0.00           C  
ATOM    657  O   ARG A  44      32.754  28.304  45.060  0.00  0.00           O  
ATOM    658  CB  ARG A  44      33.837  25.218  44.634  0.00  0.00           C  
ATOM    659  CG  ARG A  44      34.724  25.546  45.851  0.00  0.00           C  
ATOM    660  CD  ARG A  44      35.203  24.279  46.569  0.00  0.00           C  
ATOM    661  NE  ARG A  44      34.197  23.748  47.504  0.00  0.00           N  
ATOM    662  CZ  ARG A  44      33.368  22.714  47.325  0.00  0.00           C  
ATOM    663  NH1 ARG A  44      33.329  22.046  46.174  0.00  0.00           N  
ATOM    664  NH2 ARG A  44      32.578  22.362  48.333  0.00  0.00           N  
ATOM    665  H   ARG A  44      34.726  28.096  43.994  0.00  0.00           H  
ATOM    666  HA  ARG A  44      33.063  26.054  42.808  0.00  0.00           H  
ATOM    667  HB2 ARG A  44      32.921  24.737  44.978  0.00  0.00           H  
ATOM    668  HB3 ARG A  44      34.372  24.503  44.006  0.00  0.00           H  
ATOM    669  HG2 ARG A  44      35.617  26.076  45.520  0.00  0.00           H  
ATOM    670  HG3 ARG A  44      34.183  26.189  46.545  0.00  0.00           H  
ATOM    671  HD2 ARG A  44      35.499  23.528  45.835  0.00  0.00           H  
ATOM    672  HD3 ARG A  44      36.091  24.535  47.147  0.00  0.00           H  
ATOM    673  HE  ARG A  44      34.171  24.198  48.419  0.00  0.00           H  
ATOM    674 HH11 ARG A  44      33.943  22.295  45.414  0.00  0.00           H  
ATOM    675 HH12 ARG A  44      32.708  21.262  46.029  0.00  0.00           H  
ATOM    676 HH21 ARG A  44      32.653  22.867  49.214  0.00  0.00           H  
ATOM    677 HH22 ARG A  44      31.928  21.591  48.275  0.00  0.00           H  
ATOM    678  N   SER A  45      31.139  26.961  44.237  0.00  0.00           N  
ATOM    679  CA  SER A  45      30.010  27.629  44.868  0.00  0.00           C  
ATOM    680  C   SER A  45      30.035  27.418  46.388  0.00  0.00           C  
ATOM    681  O   SER A  45      30.601  26.428  46.865  0.00  0.00           O  
ATOM    682  CB  SER A  45      28.726  27.040  44.271  0.00  0.00           C  
ATOM    683  OG  SER A  45      28.795  27.032  42.851  0.00  0.00           O  
ATOM    684  H   SER A  45      30.913  26.158  43.670  0.00  0.00           H  
ATOM    685  HA  SER A  45      30.062  28.695  44.652  0.00  0.00           H  
ATOM    686  HB2 SER A  45      28.608  26.013  44.617  0.00  0.00           H  
ATOM    687  HB3 SER A  45      27.865  27.625  44.599  0.00  0.00           H  
ATOM    688  HG  SER A  45      28.036  26.522  42.519  0.00  0.00           H  
ATOM    689  N   GLY A  46      29.367  28.293  47.148  0.00  0.00           N  
ATOM    690  CA  GLY A  46      29.137  28.080  48.573  0.00  0.00           C  
ATOM    691  C   GLY A  46      28.780  29.362  49.318  0.00  0.00           C  
ATOM    692  O   GLY A  46      28.770  30.449  48.736  0.00  0.00           O  
ATOM    693  H   GLY A  46      28.944  29.117  46.727  0.00  0.00           H  
ATOM    694  HA2 GLY A  46      28.331  27.357  48.699  0.00  0.00           H  
ATOM    695  HA3 GLY A  46      30.040  27.667  49.027  0.00  0.00           H  
ATOM    696  N   ILE A  47      28.470  29.225  50.608  0.00  0.00           N  
ATOM    697  CA  ILE A  47      28.331  30.354  51.523  0.00  0.00           C  
ATOM    698  C   ILE A  47      29.748  30.644  52.013  0.00  0.00           C  
ATOM    699  O   ILE A  47      30.470  29.721  52.397  0.00  0.00           O  
ATOM    700  CB  ILE A  47      27.376  30.006  52.691  0.00  0.00           C  
ATOM    701  CG1 ILE A  47      25.918  29.804  52.215  0.00  0.00           C  
ATOM    702  CG2 ILE A  47      27.421  31.056  53.819  0.00  0.00           C  
ATOM    703  CD1 ILE A  47      25.206  31.072  51.724  0.00  0.00           C  
ATOM    704  H   ILE A  47      28.525  28.309  51.028  0.00  0.00           H  
ATOM    705  HA  ILE A  47      27.950  31.220  50.983  0.00  0.00           H  
ATOM    706  HB  ILE A  47      27.709  29.061  53.124  0.00  0.00           H  
ATOM    707 HG12 ILE A  47      25.900  29.064  51.414  0.00  0.00           H  
ATOM    708 HG13 ILE A  47      25.339  29.392  53.044  0.00  0.00           H  
ATOM    709 HG21 ILE A  47      27.261  32.057  53.419  0.00  0.00           H  
ATOM    710 HG22 ILE A  47      26.655  30.837  54.564  0.00  0.00           H  
ATOM    711 HG23 ILE A  47      28.391  31.029  54.317  0.00  0.00           H  
ATOM    712 HD11 ILE A  47      24.201  30.810  51.389  0.00  0.00           H  
ATOM    713 HD12 ILE A  47      25.116  31.800  52.529  0.00  0.00           H  
ATOM    714 HD13 ILE A  47      25.751  31.516  50.892  0.00  0.00           H  
ATOM    715  N   VAL A  48      30.156  31.906  52.003  0.00  0.00           N  
ATOM    716  CA  VAL A  48      31.442  32.326  52.530  0.00  0.00           C  
ATOM    717  C   VAL A  48      31.395  32.206  54.055  0.00  0.00           C  
ATOM    718  O   VAL A  48      30.527  32.796  54.699  0.00  0.00           O  
ATOM    719  CB  VAL A  48      31.740  33.766  52.084  0.00  0.00           C  
ATOM    720  CG1 VAL A  48      33.115  34.218  52.597  0.00  0.00           C  
ATOM    721  CG2 VAL A  48      31.711  33.927  50.555  0.00  0.00           C  
ATOM    722  H   VAL A  48      29.503  32.632  51.720  0.00  0.00           H  
ATOM    723  HA  VAL A  48      32.214  31.668  52.137  0.00  0.00           H  
ATOM    724  HB  VAL A  48      30.970  34.411  52.504  0.00  0.00           H  
ATOM    725 HG11 VAL A  48      33.340  35.216  52.220  0.00  0.00           H  
ATOM    726 HG12 VAL A  48      33.121  34.263  53.684  0.00  0.00           H  
ATOM    727 HG13 VAL A  48      33.885  33.520  52.269  0.00  0.00           H  
ATOM    728 HG21 VAL A  48      31.953  34.957  50.294  0.00  0.00           H  
ATOM    729 HG22 VAL A  48      32.431  33.254  50.093  0.00  0.00           H  
ATOM    730 HG23 VAL A  48      30.716  33.709  50.169  0.00  0.00           H  
ATOM    731  N   LYS A  49      32.349  31.483  54.640  0.00  0.00           N  
ATOM    732  CA  LYS A  49      32.564  31.457  56.077  0.00  0.00           C  
ATOM    733  C   LYS A  49      33.492  32.604  56.450  0.00  0.00           C  
ATOM    734  O   LYS A  49      33.168  33.355  57.369  0.00  0.00           O  
ATOM    735  CB  LYS A  49      33.160  30.103  56.490  0.00  0.00           C  
ATOM    736  CG  LYS A  49      33.429  30.018  57.999  0.00  0.00           C  
ATOM    737  CD  LYS A  49      34.032  28.651  58.343  0.00  0.00           C  
ATOM    738  CE  LYS A  49      34.468  28.549  59.811  0.00  0.00           C  
ATOM    739  NZ  LYS A  49      35.651  29.391  60.113  0.00  0.00           N  
ATOM    740  H   LYS A  49      33.080  31.079  54.063  0.00  0.00           H  
ATOM    741  HA  LYS A  49      31.608  31.597  56.588  0.00  0.00           H  
ATOM    742  HB2 LYS A  49      32.463  29.313  56.217  0.00  0.00           H  
ATOM    743  HB3 LYS A  49      34.096  29.938  55.957  0.00  0.00           H  
ATOM    744  HG2 LYS A  49      34.131  30.799  58.288  0.00  0.00           H  
ATOM    745  HG3 LYS A  49      32.496  30.154  58.547  0.00  0.00           H  
ATOM    746  HD2 LYS A  49      33.287  27.881  58.145  0.00  0.00           H  
ATOM    747  HD3 LYS A  49      34.893  28.469  57.702  0.00  0.00           H  
ATOM    748  HE2 LYS A  49      33.632  28.831  60.454  0.00  0.00           H  
ATOM    749  HE3 LYS A  49      34.720  27.506  60.013  0.00  0.00           H  
ATOM    750  HZ1 LYS A  49      36.387  29.231  59.421  0.00  0.00           H  
ATOM    751  HZ2 LYS A  49      35.420  30.372  60.098  0.00  0.00           H  
ATOM    752  HZ3 LYS A  49      36.023  29.172  61.026  0.00  0.00           H  
ATOM    753  N   GLU A  50      34.628  32.763  55.759  0.00  0.00           N  
ATOM    754  CA  GLU A  50      35.647  33.725  56.160  0.00  0.00           C  
ATOM    755  C   GLU A  50      36.390  34.213  54.920  0.00  0.00           C  
ATOM    756  O   GLU A  50      36.625  33.427  54.000  0.00  0.00           O  
ATOM    757  CB  GLU A  50      36.611  33.041  57.153  0.00  0.00           C  
ATOM    758  CG  GLU A  50      37.211  34.034  58.149  0.00  0.00           C  
ATOM    759  CD  GLU A  50      38.100  33.327  59.185  0.00  0.00           C  
ATOM    760  OE1 GLU A  50      39.275  33.030  58.875  0.00  0.00           O  
ATOM    761  OE2 GLU A  50      37.633  33.075  60.321  0.00  0.00           O  
ATOM    762  H   GLU A  50      34.867  32.152  54.977  0.00  0.00           H  
ATOM    763  HA  GLU A  50      35.163  34.574  56.648  0.00  0.00           H  
ATOM    764  HB2 GLU A  50      36.073  32.282  57.723  0.00  0.00           H  
ATOM    765  HB3 GLU A  50      37.414  32.544  56.611  0.00  0.00           H  
ATOM    766  HG2 GLU A  50      37.796  34.777  57.606  0.00  0.00           H  
ATOM    767  HG3 GLU A  50      36.392  34.543  58.661  0.00  0.00           H  
ATOM    768  N   VAL A  51      36.793  35.483  54.905  0.00  0.00           N  
ATOM    769  CA  VAL A  51      37.651  36.050  53.869  0.00  0.00           C  
ATOM    770  C   VAL A  51      39.041  36.144  54.498  0.00  0.00           C  
ATOM    771  O   VAL A  51      39.203  36.719  55.577  0.00  0.00           O  
ATOM    772  CB  VAL A  51      37.115  37.416  53.378  0.00  0.00           C  
ATOM    773  CG1 VAL A  51      37.795  37.816  52.061  0.00  0.00           C  
ATOM    774  CG2 VAL A  51      35.592  37.424  53.140  0.00  0.00           C  
ATOM    775  H   VAL A  51      36.616  36.070  55.710  0.00  0.00           H  
ATOM    776  HA  VAL A  51      37.694  35.371  53.018  0.00  0.00           H  
ATOM    777  HB  VAL A  51      37.335  38.176  54.129  0.00  0.00           H  
ATOM    778 HG11 VAL A  51      37.488  38.823  51.781  0.00  0.00           H  
ATOM    779 HG12 VAL A  51      38.877  37.804  52.172  0.00  0.00           H  
ATOM    780 HG13 VAL A  51      37.521  37.125  51.265  0.00  0.00           H  
ATOM    781 HG21 VAL A  51      35.315  36.638  52.441  0.00  0.00           H  
ATOM    782 HG22 VAL A  51      35.059  37.275  54.079  0.00  0.00           H  
ATOM    783 HG23 VAL A  51      35.290  38.388  52.729  0.00  0.00           H  
ATOM    784  N   LYS A  52      40.043  35.531  53.862  0.00  0.00           N  
ATOM    785  CA  LYS A  52      41.371  35.350  54.446  0.00  0.00           C  
ATOM    786  C   LYS A  52      42.310  36.516  54.106  0.00  0.00           C  
ATOM    787  O   LYS A  52      43.461  36.522  54.545  0.00  0.00           O  
ATOM    788  CB  LYS A  52      41.940  33.994  53.982  0.00  0.00           C  
ATOM    789  CG  LYS A  52      40.979  32.794  54.133  0.00  0.00           C  
ATOM    790  CD  LYS A  52      40.486  32.512  55.561  0.00  0.00           C  
ATOM    791  CE  LYS A  52      41.579  31.889  56.437  0.00  0.00           C  
ATOM    792  NZ  LYS A  52      41.009  31.270  57.656  0.00  0.00           N  
ATOM    793  H   LYS A  52      39.881  35.106  52.950  0.00  0.00           H  
ATOM    794  HA  LYS A  52      41.275  35.330  55.533  0.00  0.00           H  
ATOM    795  HB2 LYS A  52      42.221  34.076  52.932  0.00  0.00           H  
ATOM    796  HB3 LYS A  52      42.846  33.793  54.548  0.00  0.00           H  
ATOM    797  HG2 LYS A  52      40.103  32.955  53.506  0.00  0.00           H  
ATOM    798  HG3 LYS A  52      41.473  31.899  53.755  0.00  0.00           H  
ATOM    799  HD2 LYS A  52      40.106  33.423  56.024  0.00  0.00           H  
ATOM    800  HD3 LYS A  52      39.656  31.814  55.492  0.00  0.00           H  
ATOM    801  HE2 LYS A  52      42.098  31.118  55.863  0.00  0.00           H  
ATOM    802  HE3 LYS A  52      42.298  32.662  56.714  0.00  0.00           H  
ATOM    803  HZ1 LYS A  52      40.413  30.476  57.415  0.00  0.00           H  
ATOM    804  HZ2 LYS A  52      41.737  30.939  58.272  0.00  0.00           H  
ATOM    805  HZ3 LYS A  52      40.436  31.945  58.168  0.00  0.00           H  
ATOM    806  N   LYS A  53      41.835  37.493  53.328  0.00  0.00           N  
ATOM    807  CA  LYS A  53      42.547  38.687  52.868  0.00  0.00           C  
ATOM    808  C   LYS A  53      41.551  39.844  52.853  0.00  0.00           C  
ATOM    809  O   LYS A  53      40.376  39.657  53.183  0.00  0.00           O  
ATOM    810  CB  LYS A  53      43.131  38.449  51.460  0.00  0.00           C  
ATOM    811  CG  LYS A  53      44.250  37.403  51.408  0.00  0.00           C  
ATOM    812  CD  LYS A  53      45.535  37.925  52.062  0.00  0.00           C  
ATOM    813  CE  LYS A  53      46.620  36.858  51.969  0.00  0.00           C  
ATOM    814  NZ  LYS A  53      47.978  37.404  52.183  0.00  0.00           N  
ATOM    815  H   LYS A  53      40.855  37.465  53.087  0.00  0.00           H  
ATOM    816  HA  LYS A  53      43.343  38.942  53.567  0.00  0.00           H  
ATOM    817  HB2 LYS A  53      42.325  38.127  50.798  0.00  0.00           H  
ATOM    818  HB3 LYS A  53      43.542  39.384  51.065  0.00  0.00           H  
ATOM    819  HG2 LYS A  53      43.931  36.481  51.888  0.00  0.00           H  
ATOM    820  HG3 LYS A  53      44.454  37.179  50.361  0.00  0.00           H  
ATOM    821  HD2 LYS A  53      45.861  38.819  51.530  0.00  0.00           H  
ATOM    822  HD3 LYS A  53      45.363  38.160  53.112  0.00  0.00           H  
ATOM    823  HE2 LYS A  53      46.409  36.070  52.692  0.00  0.00           H  
ATOM    824  HE3 LYS A  53      46.577  36.420  50.973  0.00  0.00           H  
ATOM    825  HZ1 LYS A  53      48.153  38.212  51.590  0.00  0.00           H  
ATOM    826  HZ2 LYS A  53      48.143  37.648  53.148  0.00  0.00           H  
ATOM    827  HZ3 LYS A  53      48.647  36.690  51.888  0.00  0.00           H  
ATOM    828  N   LYS A  54      42.000  41.031  52.449  0.00  0.00           N  
ATOM    829  CA  LYS A  54      41.157  42.205  52.266  0.00  0.00           C  
ATOM    830  C   LYS A  54      41.567  42.907  50.981  0.00  0.00           C  
ATOM    831  O   LYS A  54      42.670  42.690  50.474  0.00  0.00           O  
ATOM    832  CB  LYS A  54      41.253  43.135  53.493  0.00  0.00           C  
ATOM    833  CG  LYS A  54      42.669  43.682  53.758  0.00  0.00           C  
ATOM    834  CD  LYS A  54      42.679  44.628  54.966  0.00  0.00           C  
ATOM    835  CE  LYS A  54      44.099  45.158  55.206  0.00  0.00           C  
ATOM    836  NZ  LYS A  54      44.165  46.081  56.367  0.00  0.00           N  
ATOM    837  H   LYS A  54      42.955  41.118  52.125  0.00  0.00           H  
ATOM    838  HA  LYS A  54      40.118  41.882  52.162  0.00  0.00           H  
ATOM    839  HB2 LYS A  54      40.574  43.977  53.346  0.00  0.00           H  
ATOM    840  HB3 LYS A  54      40.915  42.586  54.374  0.00  0.00           H  
ATOM    841  HG2 LYS A  54      43.348  42.852  53.956  0.00  0.00           H  
ATOM    842  HG3 LYS A  54      43.023  44.227  52.882  0.00  0.00           H  
ATOM    843  HD2 LYS A  54      42.004  45.464  54.773  0.00  0.00           H  
ATOM    844  HD3 LYS A  54      42.335  44.087  55.850  0.00  0.00           H  
ATOM    845  HE2 LYS A  54      44.766  44.310  55.378  0.00  0.00           H  
ATOM    846  HE3 LYS A  54      44.437  45.679  54.307  0.00  0.00           H  
ATOM    847  HZ1 LYS A  54      45.108  46.416  56.503  0.00  0.00           H  
ATOM    848  HZ2 LYS A  54      43.574  46.888  56.229  0.00  0.00           H  
ATOM    849  HZ3 LYS A  54      43.879  45.622  57.219  0.00  0.00           H  
ATOM    850  N   GLU A  55      40.686  43.758  50.470  0.00  0.00           N  
ATOM    851  CA  GLU A  55      40.968  44.673  49.378  0.00  0.00           C  
ATOM    852  C   GLU A  55      42.252  45.458  49.680  0.00  0.00           C  
ATOM    853  O   GLU A  55      42.325  46.192  50.668  0.00  0.00           O  
ATOM    854  CB  GLU A  55      39.726  45.557  49.197  0.00  0.00           C  
ATOM    855  CG  GLU A  55      39.834  46.545  48.033  0.00  0.00           C  
ATOM    856  CD  GLU A  55      38.441  47.020  47.579  0.00  0.00           C  
ATOM    857  OE1 GLU A  55      37.663  46.188  47.058  0.00  0.00           O  
ATOM    858  OE2 GLU A  55      38.121  48.221  47.745  0.00  0.00           O  
ATOM    859  H   GLU A  55      39.772  43.830  50.893  0.00  0.00           H  
ATOM    860  HA  GLU A  55      41.121  44.091  48.467  0.00  0.00           H  
ATOM    861  HB2 GLU A  55      38.882  44.891  49.017  0.00  0.00           H  
ATOM    862  HB3 GLU A  55      39.525  46.112  50.114  0.00  0.00           H  
ATOM    863  HG2 GLU A  55      40.450  47.394  48.330  0.00  0.00           H  
ATOM    864  HG3 GLU A  55      40.338  46.057  47.205  0.00  0.00           H  
ATOM    865  N   GLY A  56      43.269  45.265  48.838  0.00  0.00           N  
ATOM    866  CA  GLY A  56      44.560  45.933  48.913  0.00  0.00           C  
ATOM    867  C   GLY A  56      45.651  45.099  49.592  0.00  0.00           C  
ATOM    868  O   GLY A  56      46.789  45.569  49.659  0.00  0.00           O  
ATOM    869  H   GLY A  56      43.136  44.621  48.063  0.00  0.00           H  
ATOM    870  HA2 GLY A  56      44.882  46.160  47.896  0.00  0.00           H  
ATOM    871  HA3 GLY A  56      44.452  46.875  49.452  0.00  0.00           H  
ATOM    872  N   ASP A  57      45.351  43.900  50.110  0.00  0.00           N  
ATOM    873  CA  ASP A  57      46.364  43.060  50.761  0.00  0.00           C  
ATOM    874  C   ASP A  57      47.357  42.518  49.723  0.00  0.00           C  
ATOM    875  O   ASP A  57      47.033  42.406  48.537  0.00  0.00           O  
ATOM    876  CB  ASP A  57      45.724  41.900  51.545  0.00  0.00           C  
ATOM    877  CG  ASP A  57      46.582  41.417  52.732  0.00  0.00           C  
ATOM    878  OD1 ASP A  57      47.797  41.708  52.803  0.00  0.00           O  
ATOM    879  OD2 ASP A  57      46.011  40.762  53.632  0.00  0.00           O  
ATOM    880  H   ASP A  57      44.409  43.530  50.031  0.00  0.00           H  
ATOM    881  HA  ASP A  57      46.904  43.690  51.471  0.00  0.00           H  
ATOM    882  HB2 ASP A  57      44.765  42.216  51.949  0.00  0.00           H  
ATOM    883  HB3 ASP A  57      45.525  41.075  50.860  0.00  0.00           H  
ATOM    884  N   PHE A  58      48.554  42.143  50.166  0.00  0.00           N  
ATOM    885  CA  PHE A  58      49.532  41.443  49.347  0.00  0.00           C  
ATOM    886  C   PHE A  58      49.142  39.967  49.300  0.00  0.00           C  
ATOM    887  O   PHE A  58      48.670  39.416  50.302  0.00  0.00           O  
ATOM    888  CB  PHE A  58      50.932  41.612  49.949  0.00  0.00           C  
ATOM    889  CG  PHE A  58      52.021  40.916  49.153  0.00  0.00           C  
ATOM    890  CD1 PHE A  58      52.488  41.485  47.953  0.00  0.00           C  
ATOM    891  CD2 PHE A  58      52.547  39.685  49.591  0.00  0.00           C  
ATOM    892  CE1 PHE A  58      53.484  40.834  47.201  0.00  0.00           C  
ATOM    893  CE2 PHE A  58      53.543  39.034  48.840  0.00  0.00           C  
ATOM    894  CZ  PHE A  58      54.015  39.612  47.647  0.00  0.00           C  
ATOM    895  H   PHE A  58      48.665  42.080  51.175  0.00  0.00           H  
ATOM    896  HA  PHE A  58      49.527  41.857  48.338  0.00  0.00           H  
ATOM    897  HB2 PHE A  58      51.161  42.676  50.003  0.00  0.00           H  
ATOM    898  HB3 PHE A  58      50.929  41.224  50.969  0.00  0.00           H  
ATOM    899  HD1 PHE A  58      52.080  42.422  47.600  0.00  0.00           H  
ATOM    900  HD2 PHE A  58      52.188  39.232  50.506  0.00  0.00           H  
ATOM    901  HE1 PHE A  58      53.838  41.275  46.280  0.00  0.00           H  
ATOM    902  HE2 PHE A  58      53.947  38.090  49.180  0.00  0.00           H  
ATOM    903  HZ  PHE A  58      54.786  39.115  47.074  0.00  0.00           H  
ATOM    904  N   VAL A  59      49.350  39.320  48.157  0.00  0.00           N  
ATOM    905  CA  VAL A  59      48.897  37.961  47.903  0.00  0.00           C  
ATOM    906  C   VAL A  59      49.854  37.268  46.933  0.00  0.00           C  
ATOM    907  O   VAL A  59      50.638  37.919  46.229  0.00  0.00           O  
ATOM    908  CB  VAL A  59      47.453  37.978  47.363  0.00  0.00           C  
ATOM    909  CG1 VAL A  59      46.421  38.184  48.473  0.00  0.00           C  
ATOM    910  CG2 VAL A  59      47.208  39.033  46.279  0.00  0.00           C  
ATOM    911  H   VAL A  59      49.782  39.799  47.368  0.00  0.00           H  
ATOM    912  HA  VAL A  59      48.919  37.396  48.837  0.00  0.00           H  
ATOM    913  HB  VAL A  59      47.256  36.996  46.940  0.00  0.00           H  
ATOM    914 HG11 VAL A  59      45.417  38.057  48.070  0.00  0.00           H  
ATOM    915 HG12 VAL A  59      46.586  37.429  49.237  0.00  0.00           H  
ATOM    916 HG13 VAL A  59      46.501  39.181  48.904  0.00  0.00           H  
ATOM    917 HG21 VAL A  59      47.360  40.036  46.673  0.00  0.00           H  
ATOM    918 HG22 VAL A  59      47.886  38.865  45.441  0.00  0.00           H  
ATOM    919 HG23 VAL A  59      46.180  38.960  45.933  0.00  0.00           H  
ATOM    920  N   ASN A  60      49.825  35.934  46.903  0.00  0.00           N  
ATOM    921  CA  ASN A  60      50.739  35.153  46.085  0.00  0.00           C  
ATOM    922  C   ASN A  60      50.108  33.849  45.630  0.00  0.00           C  
ATOM    923  O   ASN A  60      49.041  33.470  46.112  0.00  0.00           O  
ATOM    924  CB  ASN A  60      52.067  34.921  46.836  0.00  0.00           C  
ATOM    925  CG  ASN A  60      53.236  35.506  46.056  0.00  0.00           C  
ATOM    926  OD1 ASN A  60      54.087  34.780  45.552  0.00  0.00           O  
ATOM    927  ND2 ASN A  60      53.277  36.822  45.906  0.00  0.00           N  
ATOM    928  H   ASN A  60      49.142  35.417  47.442  0.00  0.00           H  
ATOM    929  HA  ASN A  60      50.931  35.716  45.183  0.00  0.00           H  
ATOM    930  HB2 ASN A  60      52.038  35.388  47.823  0.00  0.00           H  
ATOM    931  HB3 ASN A  60      52.231  33.853  46.992  0.00  0.00           H  
ATOM    932 HD21 ASN A  60      52.527  37.407  46.277  0.00  0.00           H  
ATOM    933 HD22 ASN A  60      54.033  37.252  45.397  0.00  0.00           H  
ATOM    934  N   GLU A  61      50.769  33.158  44.700  0.00  0.00           N  
ATOM    935  CA  GLU A  61      50.332  31.852  44.225  0.00  0.00           C  
ATOM    936  C   GLU A  61      50.230  30.887  45.416  0.00  0.00           C  
ATOM    937  O   GLU A  61      51.221  30.638  46.108  0.00  0.00           O  
ATOM    938  CB  GLU A  61      51.311  31.360  43.146  0.00  0.00           C  
ATOM    939  CG  GLU A  61      50.861  30.040  42.504  0.00  0.00           C  
ATOM    940  CD  GLU A  61      51.901  29.518  41.497  0.00  0.00           C  
ATOM    941  OE1 GLU A  61      51.840  29.874  40.298  0.00  0.00           O  
ATOM    942  OE2 GLU A  61      52.786  28.722  41.889  0.00  0.00           O  
ATOM    943  H   GLU A  61      51.657  33.505  44.362  0.00  0.00           H  
ATOM    944  HA  GLU A  61      49.345  31.967  43.774  0.00  0.00           H  
ATOM    945  HB2 GLU A  61      51.386  32.118  42.365  0.00  0.00           H  
ATOM    946  HB3 GLU A  61      52.299  31.227  43.589  0.00  0.00           H  
ATOM    947  HG2 GLU A  61      50.709  29.291  43.284  0.00  0.00           H  
ATOM    948  HG3 GLU A  61      49.903  30.199  42.008  0.00  0.00           H  
ATOM    949  N   GLY A  62      49.029  30.355  45.657  0.00  0.00           N  
ATOM    950  CA  GLY A  62      48.746  29.403  46.721  0.00  0.00           C  
ATOM    951  C   GLY A  62      48.495  30.069  48.078  0.00  0.00           C  
ATOM    952  O   GLY A  62      48.315  29.353  49.065  0.00  0.00           O  
ATOM    953  H   GLY A  62      48.230  30.668  45.113  0.00  0.00           H  
ATOM    954  HA2 GLY A  62      47.856  28.839  46.444  0.00  0.00           H  
ATOM    955  HA3 GLY A  62      49.581  28.708  46.814  0.00  0.00           H  
ATOM    956  N   ASP A  63      48.489  31.405  48.164  0.00  0.00           N  
ATOM    957  CA  ASP A  63      48.124  32.116  49.382  0.00  0.00           C  
ATOM    958  C   ASP A  63      46.601  32.070  49.504  0.00  0.00           C  
ATOM    959  O   ASP A  63      45.899  32.135  48.495  0.00  0.00           O  
ATOM    960  CB  ASP A  63      48.646  33.556  49.307  0.00  0.00           C  
ATOM    961  CG  ASP A  63      48.632  34.286  50.656  0.00  0.00           C  
ATOM    962  OD1 ASP A  63      48.184  33.727  51.681  0.00  0.00           O  
ATOM    963  OD2 ASP A  63      49.112  35.440  50.679  0.00  0.00           O  
ATOM    964  H   ASP A  63      48.552  31.971  47.326  0.00  0.00           H  
ATOM    965  HA  ASP A  63      48.585  31.620  50.237  0.00  0.00           H  
ATOM    966  HB2 ASP A  63      49.678  33.534  48.950  0.00  0.00           H  
ATOM    967  HB3 ASP A  63      48.051  34.120  48.587  0.00  0.00           H  
ATOM    968  N   VAL A  64      46.077  31.905  50.713  0.00  0.00           N  
ATOM    969  CA  VAL A  64      44.650  31.706  50.954  0.00  0.00           C  
ATOM    970  C   VAL A  64      43.847  32.970  50.626  0.00  0.00           C  
ATOM    971  O   VAL A  64      44.347  34.087  50.779  0.00  0.00           O  
ATOM    972  CB  VAL A  64      44.418  31.245  52.407  0.00  0.00           C  
ATOM    973  CG1 VAL A  64      44.829  29.779  52.579  0.00  0.00           C  
ATOM    974  CG2 VAL A  64      45.136  32.102  53.463  0.00  0.00           C  
ATOM    975  H   VAL A  64      46.686  31.999  51.511  0.00  0.00           H  
ATOM    976  HA  VAL A  64      44.304  30.918  50.285  0.00  0.00           H  
ATOM    977  HB  VAL A  64      43.350  31.302  52.599  0.00  0.00           H  
ATOM    978 HG11 VAL A  64      44.579  29.445  53.587  0.00  0.00           H  
ATOM    979 HG12 VAL A  64      44.281  29.161  51.864  0.00  0.00           H  
ATOM    980 HG13 VAL A  64      45.899  29.657  52.412  0.00  0.00           H  
ATOM    981 HG21 VAL A  64      44.904  33.157  53.311  0.00  0.00           H  
ATOM    982 HG22 VAL A  64      44.799  31.812  54.459  0.00  0.00           H  
ATOM    983 HG23 VAL A  64      46.216  31.965  53.407  0.00  0.00           H  
ATOM    984  N   LEU A  65      42.579  32.795  50.226  0.00  0.00           N  
ATOM    985  CA  LEU A  65      41.683  33.888  49.846  0.00  0.00           C  
ATOM    986  C   LEU A  65      40.341  33.791  50.560  0.00  0.00           C  
ATOM    987  O   LEU A  65      39.869  34.799  51.085  0.00  0.00           O  
ATOM    988  CB  LEU A  65      41.429  33.854  48.323  0.00  0.00           C  
ATOM    989  CG  LEU A  65      40.461  34.936  47.798  0.00  0.00           C  
ATOM    990  CD1 LEU A  65      40.993  36.355  48.011  0.00  0.00           C  
ATOM    991  CD2 LEU A  65      40.215  34.706  46.303  0.00  0.00           C  
ATOM    992  H   LEU A  65      42.228  31.848  50.113  0.00  0.00           H  
ATOM    993  HA  LEU A  65      42.142  34.843  50.105  0.00  0.00           H  
ATOM    994  HB2 LEU A  65      42.373  33.942  47.794  0.00  0.00           H  
ATOM    995  HB3 LEU A  65      41.004  32.885  48.065  0.00  0.00           H  
ATOM    996  HG  LEU A  65      39.499  34.852  48.302  0.00  0.00           H  
ATOM    997 HD11 LEU A  65      41.096  36.564  49.075  0.00  0.00           H  
ATOM    998 HD12 LEU A  65      41.959  36.477  47.521  0.00  0.00           H  
ATOM    999 HD13 LEU A  65      40.287  37.074  47.594  0.00  0.00           H  
ATOM   1000 HD21 LEU A  65      39.748  33.732  46.150  0.00  0.00           H  
ATOM   1001 HD22 LEU A  65      39.545  35.473  45.913  0.00  0.00           H  
ATOM   1002 HD23 LEU A  65      41.160  34.740  45.762  0.00  0.00           H  
ATOM   1003  N   LEU A  66      39.725  32.606  50.605  0.00  0.00           N  
ATOM   1004  CA  LEU A  66      38.347  32.463  51.043  0.00  0.00           C  
ATOM   1005  C   LEU A  66      38.151  31.089  51.655  0.00  0.00           C  
ATOM   1006  O   LEU A  66      38.765  30.111  51.222  0.00  0.00           O  
ATOM   1007  CB  LEU A  66      37.458  32.613  49.792  0.00  0.00           C  
ATOM   1008  CG  LEU A  66      36.046  33.164  50.011  0.00  0.00           C  
ATOM   1009  CD1 LEU A  66      36.061  34.531  50.689  0.00  0.00           C  
ATOM   1010  CD2 LEU A  66      35.387  33.320  48.638  0.00  0.00           C  
ATOM   1011  H   LEU A  66      40.164  31.765  50.246  0.00  0.00           H  
ATOM   1012  HA  LEU A  66      38.118  33.230  51.781  0.00  0.00           H  
ATOM   1013  HB2 LEU A  66      37.954  33.272  49.078  0.00  0.00           H  
ATOM   1014  HB3 LEU A  66      37.365  31.636  49.323  0.00  0.00           H  
ATOM   1015  HG  LEU A  66      35.467  32.469  50.615  0.00  0.00           H  
ATOM   1016 HD11 LEU A  66      36.245  34.405  51.750  0.00  0.00           H  
ATOM   1017 HD12 LEU A  66      36.841  35.157  50.255  0.00  0.00           H  
ATOM   1018 HD13 LEU A  66      35.093  35.017  50.578  0.00  0.00           H  
ATOM   1019 HD21 LEU A  66      35.371  32.361  48.119  0.00  0.00           H  
ATOM   1020 HD22 LEU A  66      34.366  33.673  48.766  0.00  0.00           H  
ATOM   1021 HD23 LEU A  66      35.937  34.037  48.027  0.00  0.00           H  
ATOM   1022  N   GLU A  67      37.246  31.003  52.611  0.00  0.00           N  
ATOM   1023  CA  GLU A  67      36.894  29.801  53.342  0.00  0.00           C  
ATOM   1024  C   GLU A  67      35.382  29.752  53.292  0.00  0.00           C  
ATOM   1025  O   GLU A  67      34.741  30.785  53.502  0.00  0.00           O  
ATOM   1026  CB  GLU A  67      37.476  29.948  54.751  0.00  0.00           C  
ATOM   1027  CG  GLU A  67      37.380  28.721  55.656  0.00  0.00           C  
ATOM   1028  CD  GLU A  67      38.105  28.993  56.988  0.00  0.00           C  
ATOM   1029  OE1 GLU A  67      39.351  29.127  56.991  0.00  0.00           O  
ATOM   1030  OE2 GLU A  67      37.432  29.102  58.037  0.00  0.00           O  
ATOM   1031  H   GLU A  67      36.770  31.850  52.918  0.00  0.00           H  
ATOM   1032  HA  GLU A  67      37.293  28.920  52.851  0.00  0.00           H  
ATOM   1033  HB2 GLU A  67      38.529  30.183  54.627  0.00  0.00           H  
ATOM   1034  HB3 GLU A  67      36.993  30.788  55.247  0.00  0.00           H  
ATOM   1035  HG2 GLU A  67      36.328  28.496  55.836  0.00  0.00           H  
ATOM   1036  HG3 GLU A  67      37.840  27.866  55.156  0.00  0.00           H  
ATOM   1037  N   LEU A  68      34.814  28.592  52.968  0.00  0.00           N  
ATOM   1038  CA  LEU A  68      33.394  28.459  52.660  0.00  0.00           C  
ATOM   1039  C   LEU A  68      32.771  27.446  53.605  0.00  0.00           C  
ATOM   1040  O   LEU A  68      33.357  26.390  53.845  0.00  0.00           O  
ATOM   1041  CB  LEU A  68      33.198  28.004  51.202  0.00  0.00           C  
ATOM   1042  CG  LEU A  68      33.925  28.812  50.110  0.00  0.00           C  
ATOM   1043  CD1 LEU A  68      33.625  28.233  48.721  0.00  0.00           C  
ATOM   1044  CD2 LEU A  68      33.544  30.293  50.121  0.00  0.00           C  
ATOM   1045  H   LEU A  68      35.394  27.766  52.855  0.00  0.00           H  
ATOM   1046  HA  LEU A  68      32.896  29.419  52.788  0.00  0.00           H  
ATOM   1047  HB2 LEU A  68      33.510  26.965  51.129  0.00  0.00           H  
ATOM   1048  HB3 LEU A  68      32.134  28.036  50.995  0.00  0.00           H  
ATOM   1049  HG  LEU A  68      34.998  28.737  50.273  0.00  0.00           H  
ATOM   1050 HD11 LEU A  68      32.583  28.405  48.453  0.00  0.00           H  
ATOM   1051 HD12 LEU A  68      34.273  28.700  47.976  0.00  0.00           H  
ATOM   1052 HD13 LEU A  68      33.809  27.159  48.717  0.00  0.00           H  
ATOM   1053 HD21 LEU A  68      34.056  30.803  49.309  0.00  0.00           H  
ATOM   1054 HD22 LEU A  68      32.466  30.411  50.007  0.00  0.00           H  
ATOM   1055 HD23 LEU A  68      33.869  30.750  51.053  0.00  0.00           H  
ATOM   1056  N   SER A  69      31.584  27.738  54.126  0.00  0.00           N  
ATOM   1057  CA  SER A  69      30.912  26.926  55.133  0.00  0.00           C  
ATOM   1058  C   SER A  69      30.648  25.508  54.618  0.00  0.00           C  
ATOM   1059  O   SER A  69      30.920  24.532  55.317  0.00  0.00           O  
ATOM   1060  CB  SER A  69      29.601  27.620  55.521  0.00  0.00           C  
ATOM   1061  OG  SER A  69      29.826  28.992  55.804  0.00  0.00           O  
ATOM   1062  H   SER A  69      31.128  28.611  53.873  0.00  0.00           H  
ATOM   1063  HA  SER A  69      31.550  26.863  56.015  0.00  0.00           H  
ATOM   1064  HB2 SER A  69      28.898  27.543  54.690  0.00  0.00           H  
ATOM   1065  HB3 SER A  69      29.176  27.124  56.394  0.00  0.00           H  
ATOM   1066  HG  SER A  69      29.010  29.358  56.181  0.00  0.00           H  
ATOM   1067  N   ASN A  70      30.208  25.386  53.359  0.00  0.00           N  
ATOM   1068  CA  ASN A  70      29.970  24.104  52.688  0.00  0.00           C  
ATOM   1069  C   ASN A  70      31.256  23.296  52.458  0.00  0.00           C  
ATOM   1070  O   ASN A  70      31.171  22.127  52.081  0.00  0.00           O  
ATOM   1071  CB  ASN A  70      29.243  24.313  51.345  0.00  0.00           C  
ATOM   1072  CG  ASN A  70      30.120  24.911  50.245  0.00  0.00           C  
ATOM   1073  OD1 ASN A  70      31.118  25.575  50.512  0.00  0.00           O  
ATOM   1074  ND2 ASN A  70      29.761  24.714  48.990  0.00  0.00           N  
ATOM   1075  H   ASN A  70      30.090  26.227  52.811  0.00  0.00           H  
ATOM   1076  HA  ASN A  70      29.320  23.513  53.335  0.00  0.00           H  
ATOM   1077  HB2 ASN A  70      28.884  23.338  51.009  0.00  0.00           H  
ATOM   1078  HB3 ASN A  70      28.367  24.946  51.494  0.00  0.00           H  
ATOM   1079 HD21 ASN A  70      28.940  24.174  48.763  0.00  0.00           H  
ATOM   1080 HD22 ASN A  70      30.271  25.191  48.246  0.00  0.00           H  
ATOM   1081  N   SER A  71      32.426  23.889  52.696  0.00  0.00           N  
ATOM   1082  CA  SER A  71      33.740  23.304  52.462  0.00  0.00           C  
ATOM   1083  C   SER A  71      34.571  23.266  53.759  0.00  0.00           C  
ATOM   1084  O   SER A  71      35.729  22.844  53.741  0.00  0.00           O  
ATOM   1085  CB  SER A  71      34.433  24.118  51.365  0.00  0.00           C  
ATOM   1086  OG  SER A  71      33.569  24.306  50.248  0.00  0.00           O  
ATOM   1087  H   SER A  71      32.425  24.857  52.995  0.00  0.00           H  
ATOM   1088  HA  SER A  71      33.626  22.279  52.107  0.00  0.00           H  
ATOM   1089  HB2 SER A  71      34.719  25.091  51.766  0.00  0.00           H  
ATOM   1090  HB3 SER A  71      35.332  23.595  51.042  0.00  0.00           H  
ATOM   1091  HG  SER A  71      32.825  24.883  50.515  0.00  0.00           H  
ATOM   1092  N   THR A  72      33.969  23.665  54.886  0.00  0.00           N  
ATOM   1093  CA  THR A  72      34.583  23.743  56.211  0.00  0.00           C  
ATOM   1094  C   THR A  72      33.576  23.170  57.235  0.00  0.00           C  
ATOM   1095  O   THR A  72      33.455  23.654  58.364  0.00  0.00           O  
ATOM   1096  CB  THR A  72      35.018  25.203  56.496  0.00  0.00           C  
ATOM   1097  OG1 THR A  72      35.526  25.840  55.337  0.00  0.00           O  
ATOM   1098  CG2 THR A  72      36.124  25.291  57.555  0.00  0.00           C  
ATOM   1099  H   THR A  72      33.016  24.004  54.828  0.00  0.00           H  
ATOM   1100  HA  THR A  72      35.468  23.105  56.223  0.00  0.00           H  
ATOM   1101  HB  THR A  72      34.152  25.773  56.834  0.00  0.00           H  
ATOM   1102  HG1 THR A  72      34.767  25.990  54.743  0.00  0.00           H  
ATOM   1103 HG21 THR A  72      35.773  24.884  58.503  0.00  0.00           H  
ATOM   1104 HG22 THR A  72      37.000  24.729  57.229  0.00  0.00           H  
ATOM   1105 HG23 THR A  72      36.404  26.333  57.708  0.00  0.00           H  
ATOM   1106  N   GLN A  73      32.791  22.174  56.801  0.00  0.00           N  
ATOM   1107  CA  GLN A  73      31.743  21.533  57.587  0.00  0.00           C  
ATOM   1108  C   GLN A  73      32.354  20.896  58.835  0.00  0.00           C  
ATOM   1109  O   GLN A  73      33.404  20.227  58.724  0.00  0.00           O  
ATOM   1110  CB  GLN A  73      30.996  20.488  56.736  0.00  0.00           C  
ATOM   1111  CG  GLN A  73      30.289  21.088  55.506  0.00  0.00           C  
ATOM   1112  CD  GLN A  73      29.537  20.031  54.686  0.00  0.00           C  
ATOM   1113  OE1 GLN A  73      28.790  19.211  55.217  0.00  0.00           O  
ATOM   1114  NE2 GLN A  73      29.709  20.014  53.373  0.00  0.00           N  
ATOM   1115  OXT GLN A  73      31.774  21.051  59.928  0.00  0.00           O  
ATOM   1116  H   GLN A  73      32.967  21.801  55.882  0.00  0.00           H  
ATOM   1117  HA  GLN A  73      31.033  22.302  57.895  0.00  0.00           H  
ATOM   1118  HB2 GLN A  73      31.697  19.720  56.406  0.00  0.00           H  
ATOM   1119  HB3 GLN A  73      30.247  20.009  57.370  0.00  0.00           H  
ATOM   1120  HG2 GLN A  73      29.581  21.852  55.829  0.00  0.00           H  
ATOM   1121  HG3 GLN A  73      31.032  21.569  54.868  0.00  0.00           H  
ATOM   1122 HE21 GLN A  73      30.319  20.695  52.922  0.00  0.00           H  
ATOM   1123 HE22 GLN A  73      29.231  19.328  52.807  0.00  0.00           H  
TER    1124      GLN A  73                                                      
END
MOLECULE T0397_83_150.pdb
ATOM    717  N   LEU    83      35.835  21.935  54.102  1.00 33.12          
ATOM    718  CA  LEU    83      35.719  23.282  53.561  1.00 33.32          
ATOM    719  C   LEU    83      36.582  23.427  52.306  1.00 32.66          
ATOM    720  O   LEU    83      37.427  22.578  52.030  1.00 33.17          
ATOM    721  CB  LEU    83      36.184  24.314  54.588  1.00 33.05          
ATOM    722  CG  LEU    83      35.428  24.389  55.909  1.00 34.55          
ATOM    723  CD1 LEU    83      36.110  25.424  56.813  1.00 31.53          
ATOM    724  CD2 LEU    83      33.926  24.720  55.714  1.00 33.95          
ATOM    725  N   ILE    84      36.339  24.487  51.547  1.00 31.28          
ATOM    726  CA  ILE    84      37.113  24.815  50.390  1.00 31.86          
ATOM    727  C   ILE    84      37.899  26.128  50.688  1.00 31.86          
ATOM    728  O   ILE    84      37.374  27.068  51.262  1.00 30.84          
ATOM    729  CB  ILE    84      36.211  24.884  49.102  1.00 33.01          
ATOM    730  CG1 ILE    84      35.635  23.481  48.828  1.00 32.64          
ATOM    731  CG2 ILE    84      37.046  25.413  47.910  1.00 32.85          
ATOM    732  CD  ILE    84      34.896  23.257  47.596  1.00 34.41          
ATOM    733  N   SER    85      39.183  26.115  50.391  1.00 31.66          
ATOM    734  CA  SER    85      40.056  27.270  50.558  1.00 32.45          
ATOM    735  C   SER    85      40.379  27.753  49.179  1.00 30.88          
ATOM    736  O   SER    85      40.777  26.974  48.349  1.00 28.90          
ATOM    737  CB  SER    85      41.345  26.854  51.252  1.00 33.29          
ATOM    738  OG  SER    85      41.047  26.245  52.505  1.00 38.38          
ATOM    739  N   VAL    86      40.161  29.032  48.922  1.00 30.89          
ATOM    740  CA  VAL    86      40.406  29.618  47.617  1.00 30.18          
ATOM    741  C   VAL    86      41.432  30.751  47.751  1.00 30.50          
ATOM    742  O   VAL    86      41.128  31.827  48.263  1.00 29.45          
ATOM    743  CB  VAL    86      39.090  30.166  47.031  1.00 31.39          
ATOM    744  CG1 VAL    86      39.278  30.554  45.537  1.00 30.79          
ATOM    745  CG2 VAL    86      37.974  29.150  47.205  1.00 29.24          
ATOM    746  N   PRO    87      42.702  30.485  47.366  1.00 31.49          
ATOM    747  CA  PRO    87      43.702  31.557  47.420  1.00 30.98          
ATOM    748  C   PRO    87      43.541  32.615  46.290  1.00 30.90          
ATOM    749  O   PRO    87      43.077  32.315  45.202  1.00 29.79          
ATOM    750  CB  PRO    87      45.028  30.825  47.303  1.00 31.58          
ATOM    751  CG  PRO    87      44.693  29.422  46.847  1.00 32.96          
ATOM    752  CD  PRO    87      43.240  29.210  46.879  1.00 30.77          
ATOM    753  N   ALA    88      43.890  33.849  46.619  1.00 31.20          
ATOM    754  CA  ALA    88      43.874  34.986  45.725  1.00 31.18          
ATOM    755  C   ALA    88      45.284  35.570  45.884  1.00 31.56          
ATOM    756  O   ALA    88      45.555  36.263  46.864  1.00 31.99          
ATOM    757  CB  ALA    88      42.823  35.984  46.165  1.00 29.82          
ATOM    758  N   GLU    89      46.181  35.230  44.957  1.00 31.39          
ATOM    759  CA  GLU    89      47.591  35.660  44.994  1.00 31.91          
ATOM    760  C   GLU    89      48.000  36.444  43.779  1.00 31.08          
ATOM    761  O   GLU    89      47.752  36.021  42.661  1.00 32.28          
ATOM    762  CB  GLU    89      48.493  34.426  45.011  1.00 32.34          
ATOM    763  CG  GLU    89      48.251  33.502  46.184  1.00 35.65          
ATOM    764  CD  GLU    89      49.120  32.295  46.110  1.00 41.85          
ATOM    765  OE1 GLU    89      49.575  31.939  44.988  1.00 42.45          
ATOM    766  OE2 GLU    89      49.398  31.740  47.195  1.00 48.31          
ATOM    767  N   GLY    90      48.688  37.552  43.997  1.00 30.77          
ATOM    768  CA  GLY    90      49.163  38.409  42.917  1.00 30.21          
ATOM    769  C   GLY    90      49.928  39.585  43.484  1.00 30.04          
ATOM    770  O   GLY    90      49.980  39.771  44.709  1.00 30.76          
ATOM    771  N   TYR    91      50.541  40.360  42.604  1.00 29.01          
ATOM    772  CA  TYR    91      51.260  41.582  42.987  1.00 29.19          
ATOM    773  C   TYR    91      50.355  42.462  43.856  1.00 27.98          
ATOM    774  O   TYR    91      50.755  42.867  44.940  1.00 26.97          
ATOM    775  CB  TYR    91      51.788  42.315  41.750  1.00 28.63          
ATOM    776  CG  TYR    91      52.460  43.646  42.050  1.00 29.43          
ATOM    777  CD1 TYR    91      53.695  43.705  42.695  1.00 28.96          
ATOM    778  CD2 TYR    91      51.863  44.835  41.655  1.00 26.65          
ATOM    779  CE1 TYR    91      54.291  44.931  42.967  1.00 30.76          
ATOM    780  CE2 TYR    91      52.430  46.032  41.907  1.00 29.47          
ATOM    781  CZ  TYR    91      53.652  46.099  42.553  1.00 30.46          
ATOM    782  OH  TYR    91      54.196  47.339  42.759  1.00 29.11          
ATOM    783  N   LYS    92      49.133  42.689  43.373  1.00 27.98          
ATOM    784  CA  LYS    92      48.065  43.394  44.107  1.00 27.98          
ATOM    785  C   LYS    92      46.799  42.550  43.968  1.00 28.43          
ATOM    786  O   LYS    92      46.511  41.996  42.886  1.00 28.52          
ATOM    787  CB  LYS    92      47.799  44.807  43.567  1.00 28.07          
ATOM    788  CG  LYS    92      48.955  45.746  43.679  1.00 28.03          
ATOM    789  CD  LYS    92      48.737  47.040  42.914  1.00 28.62          
ATOM    790  CE  LYS    92      47.732  47.975  43.550  1.00 28.71          
ATOM    791  NZ  LYS    92      47.496  49.146  42.668  1.00 27.15          
ATOM    792  N   VAL    93      46.070  42.427  45.066  1.00 28.48          
ATOM    793  CA  VAL    93      44.861  41.611  45.110  1.00 28.35          
ATOM    794  C   VAL    93      43.738  42.456  45.613  1.00 28.50          
ATOM    795  O   VAL    93      43.891  43.173  46.603  1.00 28.44          
ATOM    796  CB  VAL    93      45.008  40.312  46.011  1.00 28.74          
ATOM    797  CG1 VAL    93      43.660  39.491  46.023  1.00 25.37          
ATOM    798  CG2 VAL    93      46.221  39.458  45.555  1.00 25.20          
ATOM    799  N   TYR    94      42.629  42.403  44.882  1.00 29.53          
ATOM    800  CA  TYR    94      41.404  43.147  45.179  1.00 29.93          
ATOM    801  C   TYR    94      40.300  42.124  45.422  1.00 29.26          
ATOM    802  O   TYR    94      39.606  41.728  44.531  1.00 29.00          
ATOM    803  CB  TYR    94      41.016  44.039  44.004  1.00 30.51          
ATOM    804  CG  TYR    94      42.016  45.110  43.674  1.00 31.04          
ATOM    805  CD1 TYR    94      41.983  46.336  44.320  1.00 30.17          
ATOM    806  CD2 TYR    94      42.999  44.891  42.701  1.00 30.58          
ATOM    807  CE1 TYR    94      42.912  47.327  44.017  1.00 30.75          
ATOM    808  CE2 TYR    94      43.917  45.847  42.398  1.00 31.08          
ATOM    809  CZ  TYR    94      43.877  47.079  43.045  1.00 33.26          
ATOM    810  OH  TYR    94      44.823  48.055  42.712  1.00 32.99          
ATOM    811  N   PRO    95      40.130  41.718  46.663  1.00 29.25          
ATOM    812  CA  PRO    95      39.185  40.737  46.999  1.00 29.79          
ATOM    813  C   PRO    95      37.842  41.315  47.422  1.00 30.52          
ATOM    814  O   PRO    95      37.770  42.473  47.786  1.00 29.82          
ATOM    815  CB  PRO    95      39.847  40.112  48.241  1.00 29.66          
ATOM    816  CG  PRO    95      40.385  41.315  48.942  1.00 28.17          
ATOM    817  CD  PRO    95      40.868  42.182  47.851  1.00 28.68          
ATOM    818  N   ILE    96      36.786  40.514  47.319  1.00 31.49          
ATOM    819  CA  ILE    96      35.486  40.905  47.859  0.50 31.87          
ATOM    821  C   ILE    96      35.675  40.903  49.385  1.00 32.49          
ATOM    822  O   ILE    96      36.019  39.877  49.980  1.00 31.70          
ATOM    823  CB  ILE    96      34.369  39.925  47.482  0.50 31.46          
ATOM    825  CG1 ILE    96      34.142  39.906  45.963  0.50 31.53          
ATOM    827  CG2 ILE    96      33.082  40.292  48.190  0.50 32.32          
ATOM    829  CD  ILE    96      33.676  41.217  45.363  0.50 27.56          
ATOM    831  N   MET    97      35.476  42.060  49.996  1.00 33.47          
ATOM    832  CA  MET    97      35.648  42.267  51.416  0.60 36.42          
ATOM    834  C   MET    97      34.295  42.009  52.082  1.00 33.49          
ATOM    835  O   MET    97      33.612  42.948  52.393  1.00 33.78          
ATOM    836  CB  MET    97      36.063  43.731  51.622  0.60 36.40          
ATOM    838  CG  MET    97      37.206  44.211  50.698  0.60 40.39          
ATOM    840  SD  MET    97      37.422  46.188  50.408  0.48 46.95          
ATOM    842  CE  MET    97      35.833  46.788  49.386  0.60 41.22          
ATOM    844  N   ASP    98      33.891  40.757  52.252  1.00 32.35          
ATOM    845  CA  ASP    98      32.579  40.482  52.802  1.00 32.10          
ATOM    846  C   ASP    98      32.580  39.078  53.350  1.00 30.95          
ATOM    847  O   ASP    98      33.521  38.336  53.109  1.00 31.18          
ATOM    848  CB  ASP    98      31.498  40.707  51.709  1.00 32.01          
ATOM    849  CG  ASP    98      30.106  40.961  52.283  1.00 33.32          
ATOM    850  OD1 ASP    98      29.907  40.894  53.519  1.00 35.35          
ATOM    851  OD2 ASP    98      29.201  41.265  51.493  1.00 33.61          
ATOM    852  N   PHE    99      31.514  38.719  54.066  1.00 30.94          
ATOM    853  CA  PHE    99      31.442  37.443  54.766  1.00 31.08          
ATOM    854  C   PHE    99      30.036  36.931  54.775  1.00 30.94          
ATOM    855  O   PHE    99      29.111  37.697  54.945  1.00 31.23          
ATOM    856  CB  PHE    99      31.855  37.614  56.263  1.00 30.83          
ATOM    857  CG  PHE    99      33.071  38.416  56.462  1.00 30.89          
ATOM    858  CD1 PHE    99      32.985  39.818  56.579  1.00 31.04          
ATOM    859  CD2 PHE    99      34.318  37.816  56.491  1.00 30.92          
ATOM    860  CE1 PHE    99      34.105  40.582  56.705  1.00 29.76          
ATOM    861  CE2 PHE    99      35.470  38.595  56.658  1.00 31.42          
ATOM    862  CZ  PHE    99      35.361  39.963  56.786  1.00 30.91          
ATOM    863  N   GLY   100      29.887  35.616  54.682  1.00 31.37          
ATOM    864  CA  GLY   100      28.591  34.973  54.808  1.00 31.40          
ATOM    865  C   GLY   100      27.667  35.250  53.645  1.00 31.50          
ATOM    866  O   GLY   100      26.492  35.490  53.835  1.00 32.03          
ATOM    867  N   PHE   101      28.199  35.166  52.431  1.00 30.55          
ATOM    868  CA  PHE   101      27.413  35.397  51.253  1.00 30.28          
ATOM    869  C   PHE   101      27.459  34.184  50.363  1.00 29.34          
ATOM    870  O   PHE   101      28.464  33.516  50.257  1.00 28.31          
ATOM    871  CB  PHE   101      27.845  36.675  50.529  1.00 29.24          
ATOM    872  CG  PHE   101      29.285  36.679  50.080  1.00 30.50          
ATOM    873  CD1 PHE   101      29.620  36.396  48.760  1.00 30.99          
ATOM    874  CD2 PHE   101      30.289  37.040  50.939  1.00 30.32          
ATOM    875  CE1 PHE   101      30.890  36.445  48.331  1.00 27.52          
ATOM    876  CE2 PHE   101      31.560  37.069  50.519  1.00 29.34          
ATOM    877  CZ  PHE   101      31.870  36.751  49.207  1.00 31.56          
ATOM    878  N   ARG   102      26.302  33.886  49.789  1.00 29.69          
ATOM    879  CA  ARG   102      26.146  32.804  48.868  1.00 29.70          
ATOM    880  C   ARG   102      26.595  33.238  47.449  1.00 29.72          
ATOM    881  O   ARG   102      26.510  34.415  47.053  1.00 30.28          
ATOM    882  CB  ARG   102      24.703  32.350  48.911  1.00 30.29          
ATOM    883  CG  ARG   102      24.413  31.126  48.107  1.00 30.83          
ATOM    884  CD  ARG   102      23.204  30.401  48.607  1.00 32.50          
ATOM    885  NE  ARG   102      22.898  29.317  47.683  1.00 33.96          
ATOM    886  CZ  ARG   102      22.165  29.443  46.589  1.00 36.08          
ATOM    887  NH1 ARG   102      21.621  30.608  46.257  1.00 37.22          
ATOM    888  NH2 ARG   102      21.952  28.384  45.817  1.00 38.60          
ATOM    889  N   VAL   103      27.151  32.267  46.724  1.00 29.73          
ATOM    890  CA  VAL   103      27.673  32.452  45.381  1.00 28.43          
ATOM    891  C   VAL   103      27.395  31.182  44.602  1.00 28.35          
ATOM    892  O   VAL   103      27.155  30.120  45.201  1.00 29.10          
ATOM    893  CB  VAL   103      29.220  32.663  45.375  1.00 29.57          
ATOM    894  CG1 VAL   103      29.684  33.944  46.197  1.00 25.27          
ATOM    895  CG2 VAL   103      29.943  31.382  45.828  1.00 27.50          
ATOM    896  N   LEU   104      27.399  31.290  43.277  1.00 27.46          
ATOM    897  CA  LEU   104      27.326  30.149  42.402  1.00 27.49          
ATOM    898  C   LEU   104      28.722  29.996  41.808  1.00 27.61          
ATOM    899  O   LEU   104      29.482  30.950  41.734  1.00 27.73          
ATOM    900  CB  LEU   104      26.306  30.314  41.269  1.00 27.73          
ATOM    901  CG  LEU   104      24.808  30.462  41.607  1.00 29.77          
ATOM    902  CD1 LEU   104      23.965  30.684  40.342  1.00 25.73          
ATOM    903  CD2 LEU   104      24.249  29.273  42.470  1.00 31.65          
ATOM    904  N   LYS   105      29.048  28.781  41.392  1.00 28.03          
ATOM    905  CA  LYS   105      30.311  28.459  40.746  1.00 28.18          
ATOM    906  C   LYS   105      30.597  29.432  39.618  1.00 27.83          
ATOM    907  O   LYS   105      29.753  29.661  38.739  1.00 27.59          
ATOM    908  CB  LYS   105      30.200  27.021  40.168  1.00 28.45          
ATOM    909  CG  LYS   105      31.380  26.551  39.395  1.00 30.45          
ATOM    910  CD  LYS   105      31.381  25.043  39.324  1.00 35.24          
ATOM    911  CE  LYS   105      32.578  24.465  38.580  1.00 38.56          
ATOM    912  NZ  LYS   105      32.346  24.168  37.154  1.00 40.94          
ATOM    913  N   GLY   106      31.791  29.999  39.629  1.00 27.43          
ATOM    914  CA  GLY   106      32.174  30.950  38.620  1.00 27.72          
ATOM    915  C   GLY   106      32.108  32.395  39.084  1.00 28.48          
ATOM    916  O   GLY   106      32.655  33.238  38.443  1.00 29.66          
ATOM    917  N   TYR   107      31.426  32.661  40.185  1.00 29.11          
ATOM    918  CA  TYR   107      31.336  33.998  40.775  1.00 30.38          
ATOM    919  C   TYR   107      32.745  34.570  41.056  1.00 30.20          
ATOM    920  O   TYR   107      33.594  33.884  41.596  1.00 29.79          
ATOM    921  CB  TYR   107      30.529  33.897  42.076  1.00 30.84          
ATOM    922  CG  TYR   107      30.172  35.178  42.775  1.00 30.61          
ATOM    923  CD1 TYR   107      31.062  35.798  43.646  1.00 29.64          
ATOM    924  CD2 TYR   107      28.896  35.705  42.665  1.00 30.62          
ATOM    925  CE1 TYR   107      30.718  36.969  44.305  1.00 33.41          
ATOM    926  CE2 TYR   107      28.543  36.850  43.325  1.00 33.62          
ATOM    927  CZ  TYR   107      29.454  37.486  44.145  1.00 34.42          
ATOM    928  OH  TYR   107      29.081  38.628  44.811  1.00 35.85          
ATOM    929  N   ARG   108      32.970  35.823  40.679  1.00 28.91          
ATOM    930  CA  ARG   108      34.264  36.453  40.890  1.00 30.07          
ATOM    931  C   ARG   108      34.493  36.891  42.361  1.00 29.95          
ATOM    932  O   ARG   108      33.747  37.702  42.894  1.00 30.55          
ATOM    933  CB  ARG   108      34.382  37.666  39.973  1.00 29.73          
ATOM    934  CG  ARG   108      35.738  38.344  40.010  1.00 30.04          
ATOM    935  CD  ARG   108      35.685  39.608  39.168  1.00 29.75          
ATOM    936  NE  ARG   108      35.655  39.296  37.739  1.00 31.85          
ATOM    937  CZ  ARG   108      35.598  40.209  36.777  1.00 30.58          
ATOM    938  NH1 ARG   108      35.534  41.488  37.066  1.00 29.91          
ATOM    939  NH2 ARG   108      35.587  39.834  35.529  1.00 31.01          
ATOM    940  N   LEU   109      35.531  36.346  42.978  1.00 28.92          
ATOM    941  CA  LEU   109      35.884  36.639  44.349  1.00 28.66          
ATOM    942  C   LEU   109      37.000  37.670  44.473  1.00 28.99          
ATOM    943  O   LEU   109      37.064  38.378  45.491  1.00 29.94          
ATOM    944  CB  LEU   109      36.297  35.361  45.084  1.00 28.34          
ATOM    945  CG  LEU   109      35.269  34.228  45.135  1.00 28.28          
ATOM    946  CD1 LEU   109      35.870  32.903  45.615  1.00 24.20          
ATOM    947  CD2 LEU   109      34.070  34.624  45.978  1.00 26.32          
ATOM    948  N   ALA   110      37.869  37.755  43.460  1.00 28.72          
ATOM    949  CA  ALA   110      38.972  38.673  43.486  1.00 28.85          
ATOM    950  C   ALA   110      39.487  38.973  42.092  1.00 28.20          
ATOM    951  O   ALA   110      39.349  38.165  41.182  1.00 28.69          
ATOM    952  CB  ALA   110      40.125  38.115  44.374  1.00 27.48          
ATOM    953  N   THR   111      40.053  40.168  41.955  1.00 28.00          
ATOM    954  CA  THR   111      40.796  40.619  40.767  1.00 27.96          
ATOM    955  C   THR   111      42.250  40.653  41.184  1.00 28.47          
ATOM    956  O   THR   111      42.573  41.096  42.288  1.00 28.25          
ATOM    957  CB  THR   111      40.370  42.000  40.317  1.00 28.12          
ATOM    958  OG1 THR   111      39.035  41.937  39.833  1.00 27.47          
ATOM    959  CG2 THR   111      41.266  42.562  39.207  1.00 27.78          
ATOM    960  N   LEU   112      43.133  40.139  40.336  1.00 29.31          
ATOM    961  CA  LEU   112      44.559  40.173  40.619  1.00 29.41          
ATOM    962  C   LEU   112      45.197  41.104  39.589  1.00 29.94          
ATOM    963  O   LEU   112      44.933  40.958  38.424  1.00 29.91          
ATOM    964  CB  LEU   112      45.180  38.782  40.491  1.00 30.01          
ATOM    965  CG  LEU   112      44.437  37.607  41.127  1.00 29.77          
ATOM    966  CD1 LEU   112      45.066  36.279  40.711  1.00 28.80          
ATOM    967  CD2 LEU   112      44.441  37.747  42.621  1.00 26.63          
ATOM    968  N   GLU   113      46.051  42.033  40.033  1.00 29.49          
ATOM    969  CA  GLU   113      46.730  42.979  39.160  1.00 29.48          
ATOM    970  C   GLU   113      48.231  42.744  39.255  1.00 29.28          
ATOM    971  O   GLU   113      48.794  42.656  40.343  1.00 27.97          
ATOM    972  CB  GLU   113      46.408  44.410  39.573  1.00 29.28          
ATOM    973  CG  GLU   113      46.978  45.490  38.687  1.00 31.66          
ATOM    974  CD  GLU   113      46.898  46.858  39.331  1.00 32.90          
ATOM    975  OE1 GLU   113      46.454  46.975  40.501  1.00 37.77          
ATOM    976  OE2 GLU   113      47.260  47.818  38.662  1.00 31.95          
ATOM    977  N   SER   114      48.871  42.632  38.098  1.00 29.97          
ATOM    978  CA  SER   114      50.300  42.391  38.042  1.00 30.52          
ATOM    979  C   SER   114      51.067  43.720  38.159  1.00 31.36          
ATOM    980  O   SER   114      50.469  44.799  38.086  1.00 31.23          
ATOM    981  CB  SER   114      50.670  41.689  36.722  1.00 30.65          
ATOM    982  OG  SER   114      50.747  42.605  35.639  1.00 30.72          
ATOM    983  N   LYS   115      52.390  43.608  38.282  1.00 31.74          
ATOM    984  CA  LYS   115      53.277  44.780  38.418  0.50 32.12          
ATOM    986  C   LYS   115      53.106  45.728  37.235  1.00 32.17          
ATOM    987  O   LYS   115      53.249  46.928  37.387  1.00 32.06          
ATOM    988  CB  LYS   115      54.752  44.347  38.577  0.50 31.97          
ATOM    990  CG  LYS   115      55.801  45.478  38.696  0.50 32.47          
ATOM    992  CD  LYS   115      55.729  46.251  40.024  0.50 32.71          
ATOM    994  CE  LYS   115      56.780  47.354  40.124  0.50 31.77          
ATOM    996  NZ  LYS   115      58.161  46.820  40.231  0.50 31.98          
ATOM    998  N   LYS   116      52.762  45.188  36.068  1.00 32.06          
ATOM    999  CA  LYS   116      52.553  45.980  34.858  1.00 32.15          
ATOM   1000  C   LYS   116      51.082  46.217  34.499  1.00 31.72          
ATOM   1001  O   LYS   116      50.784  46.647  33.385  1.00 31.63          
ATOM   1002  CB  LYS   116      53.342  45.372  33.666  1.00 32.29          
ATOM   1003  CG  LYS   116      54.850  45.627  33.743  1.00 32.32          
ATOM   1004  N   GLY   117      50.170  45.944  35.442  1.00 32.17          
ATOM   1005  CA  GLY   117      48.743  46.219  35.266  1.00 31.65          
ATOM   1006  C   GLY   117      47.889  45.171  34.583  1.00 32.02          
ATOM   1007  O   GLY   117      46.760  45.448  34.209  1.00 30.89          
ATOM   1008  N   ASP   118      48.425  43.977  34.386  1.00 33.07          
ATOM   1009  CA  ASP   118      47.646  42.886  33.802  1.00 33.69          
ATOM   1010  C   ASP   118      46.676  42.350  34.856  1.00 33.47          
ATOM   1011  O   ASP   118      47.048  42.171  36.024  1.00 33.70          
ATOM   1012  CB  ASP   118      48.564  41.756  33.373  1.00 34.70          
ATOM   1013  CG  ASP   118      49.562  42.169  32.288  1.00 36.13          
ATOM   1014  OD1 ASP   118      49.170  42.849  31.305  1.00 37.08          
ATOM   1015  OD2 ASP   118      50.738  41.765  32.428  1.00 38.14          
ATOM   1016  N   LEU   119      45.440  42.100  34.446  1.00 33.09          
ATOM   1017  CA  LEU   119      44.387  41.617  35.344  1.00 33.04          
ATOM   1018  C   LEU   119      44.009  40.149  35.114  1.00 32.88          
ATOM   1019  O   LEU   119      43.837  39.749  33.997  1.00 33.07          
ATOM   1020  CB  LEU   119      43.134  42.462  35.134  1.00 32.71          
ATOM   1021  CG  LEU   119      43.311  43.951  35.413  1.00 32.71          
ATOM   1022  CD1 LEU   119      42.062  44.678  35.032  1.00 32.27          
ATOM   1023  CD2 LEU   119      43.657  44.206  36.868  1.00 30.21          
ATOM   1024  N   ARG   120      43.908  39.376  36.185  1.00 32.63          
ATOM   1025  CA  ARG   120      43.437  37.998  36.158  1.00 33.15          
ATOM   1026  C   ARG   120      42.375  37.965  37.238  1.00 31.39          
ATOM   1027  O   ARG   120      42.294  38.887  38.054  1.00 31.30          
ATOM   1028  CB  ARG   120      44.544  36.988  36.469  1.00 32.65          
ATOM   1029  CG  ARG   120      45.616  36.885  35.399  1.00 35.91          
ATOM   1030  CD  ARG   120      46.797  35.979  35.783  1.00 38.66          
ATOM   1031  NE  ARG   120      47.527  36.434  36.987  1.00 44.57          
ATOM   1032  CZ  ARG   120      47.667  35.764  38.145  1.00 48.21          
ATOM   1033  NH1 ARG   120      47.168  34.512  38.324  1.00 51.17          
ATOM   1034  NH2 ARG   120      48.348  36.352  39.150  1.00 47.05          
ATOM   1035  N   TYR   121      41.566  36.910  37.257  1.00 30.65          
ATOM   1036  CA  TYR   121      40.498  36.770  38.232  1.00 29.52          
ATOM   1037  C   TYR   121      40.497  35.450  38.994  1.00 29.31          
ATOM   1038  O   TYR   121      40.944  34.430  38.500  1.00 29.67          
ATOM   1039  CB  TYR   121      39.178  36.955  37.531  1.00 29.22          
ATOM   1040  CG  TYR   121      39.180  38.215  36.761  1.00 30.47          
ATOM   1041  CD1 TYR   121      39.085  39.443  37.402  1.00 30.72          
ATOM   1042  CD2 TYR   121      39.357  38.208  35.399  1.00 31.47          
ATOM   1043  CE1 TYR   121      39.132  40.632  36.696  1.00 31.64          
ATOM   1044  CE2 TYR   121      39.419  39.404  34.685  1.00 32.50          
ATOM   1045  CZ  TYR   121      39.298  40.601  35.341  1.00 31.18          
ATOM   1046  OH  TYR   121      39.327  41.770  34.623  1.00 32.27          
ATOM   1047  N   VAL   122      39.991  35.502  40.220  1.00 28.84          
ATOM   1048  CA  VAL   122      39.818  34.333  41.077  1.00 28.57          
ATOM   1049  C   VAL   122      38.327  34.177  41.193  1.00 28.66          
ATOM   1050  O   VAL   122      37.629  35.069  41.675  1.00 27.80          
ATOM   1051  CB  VAL   122      40.446  34.528  42.440  1.00 28.46          
ATOM   1052  CG1 VAL   122      40.099  33.331  43.394  1.00 28.10          
ATOM   1053  CG2 VAL   122      41.995  34.756  42.248  1.00 28.42          
ATOM   1054  N   ASN   123      37.832  33.056  40.700  1.00 28.86          
ATOM   1055  CA  ASN   123      36.408  32.774  40.695  1.00 28.39          
ATOM   1056  C   ASN   123      36.123  31.648  41.616  1.00 28.56          
ATOM   1057  O   ASN   123      36.984  30.826  41.818  1.00 27.87          
ATOM   1058  CB  ASN   123      35.956  32.381  39.304  1.00 29.33          
ATOM   1059  CG  ASN   123      36.182  33.462  38.296  1.00 27.62          
ATOM   1060  OD1 ASN   123      35.988  34.628  38.564  1.00 32.47          
ATOM   1061  ND2 ASN   123      36.597  33.082  37.147  1.00 27.51          
ATOM   1062  N   SER   124      34.899  31.611  42.167  1.00 28.33          
ATOM   1063  CA  SER   124      34.486  30.526  43.025  1.00 28.38          
ATOM   1064  C   SER   124      34.494  29.189  42.288  1.00 28.59          
ATOM   1065  O   SER   124      33.860  29.067  41.234  1.00 27.48          
ATOM   1066  CB  SER   124      33.062  30.755  43.529  1.00 28.74          
ATOM   1067  OG  SER   124      32.815  29.870  44.572  1.00 24.63          
ATOM   1068  N   PRO   125      35.180  28.165  42.855  1.00 29.27          
ATOM   1069  CA  PRO   125      35.201  26.860  42.239  1.00 29.34          
ATOM   1070  C   PRO   125      33.907  26.060  42.416  1.00 29.48          
ATOM   1071  O   PRO   125      33.727  25.061  41.755  1.00 29.83          
ATOM   1072  CB  PRO   125      36.341  26.161  42.996  1.00 29.36          
ATOM   1073  CG  PRO   125      36.282  26.701  44.298  1.00 29.22          
ATOM   1074  CD  PRO   125      35.932  28.152  44.118  1.00 29.39          
ATOM   1075  N   VAL   126      33.029  26.483  43.331  1.00 30.06          
ATOM   1076  CA  VAL   126      31.809  25.778  43.631  1.00 29.39          
ATOM   1077  C   VAL   126      30.714  26.751  43.999  1.00 29.93          
ATOM   1078  O   VAL   126      30.942  27.936  44.183  1.00 30.98          
ATOM   1079  CB  VAL   126      31.997  24.820  44.859  1.00 30.07          
ATOM   1080  CG1 VAL   126      33.004  23.721  44.563  1.00 29.26          
ATOM   1081  CG2 VAL   126      32.403  25.597  46.126  1.00 28.09          
ATOM   1082  N   SER   127      29.512  26.226  44.085  1.00 29.28          
ATOM   1083  CA  SER   127      28.373  26.936  44.581  1.00 29.29          
ATOM   1084  C   SER   127      28.286  26.666  46.084  1.00 28.40          
ATOM   1085  O   SER   127      28.467  25.564  46.540  1.00 28.74          
ATOM   1086  CB  SER   127      27.103  26.448  43.880  1.00 28.97          
ATOM   1087  OG  SER   127      27.121  26.809  42.521  1.00 30.47          
ATOM   1088  N   GLY   128      27.994  27.692  46.865  1.00 29.10          
ATOM   1089  CA  GLY   128      27.890  27.524  48.307  1.00 28.32          
ATOM   1090  C   GLY   128      28.029  28.842  48.967  1.00 27.81          
ATOM   1091  O   GLY   128      27.764  29.826  48.359  1.00 28.32          
ATOM   1092  N   THR   129      28.516  28.851  50.197  1.00 28.38          
ATOM   1093  CA  THR   129      28.600  30.051  51.013  1.00 29.02          
ATOM   1094  C   THR   129      30.052  30.413  51.333  1.00 28.70          
ATOM   1095  O   THR   129      30.805  29.569  51.724  1.00 28.95          
ATOM   1096  CB  THR   129      27.871  29.820  52.367  1.00 29.10          
ATOM   1097  OG1 THR   129      26.538  29.280  52.147  1.00 28.63          
ATOM   1098  CG2 THR   129      27.797  31.113  53.170  1.00 26.94          
ATOM   1099  N   VAL   130      30.430  31.660  51.140  1.00 29.17          
ATOM   1100  CA  VAL   130      31.739  32.131  51.531  1.00 30.48          
ATOM   1101  C   VAL   130      31.538  32.462  52.984  1.00 30.69          
ATOM   1102  O   VAL   130      30.805  33.349  53.295  1.00 31.50          
ATOM   1103  CB  VAL   130      32.204  33.394  50.734  1.00 30.60          
ATOM   1104  CG1 VAL   130      33.557  33.925  51.266  1.00 29.82          
ATOM   1105  CG2 VAL   130      32.300  33.086  49.283  1.00 30.63          
ATOM   1106  N   ILE   131      32.216  31.747  53.861  1.00 32.65          
ATOM   1107  CA  ILE   131      32.070  31.890  55.295  1.00 33.61          
ATOM   1108  C   ILE   131      33.073  32.881  55.895  1.00 33.47          
ATOM   1109  O   ILE   131      32.757  33.594  56.835  1.00 34.54          
ATOM   1110  CB  ILE   131      32.058  30.469  56.003  1.00 34.99          
ATOM   1111  CG1 ILE   131      33.407  29.769  55.988  1.00 37.35          
ATOM   1112  CG2 ILE   131      31.005  29.503  55.369  1.00 32.31          
ATOM   1113  CD  ILE   131      33.339  28.349  56.558  1.00 36.05          
ATOM   1114  N   PHE   132      34.257  33.000  55.318  1.00 33.54          
ATOM   1115  CA  PHE   132      35.248  33.929  55.843  1.00 33.34          
ATOM   1116  C   PHE   132      36.238  34.235  54.771  1.00 32.81          
ATOM   1117  O   PHE   132      36.340  33.542  53.762  1.00 32.93          
ATOM   1118  CB  PHE   132      35.978  33.360  57.082  1.00 33.46          
ATOM   1119  CG  PHE   132      35.917  34.273  58.313  1.00 33.81          
ATOM   1120  CD1 PHE   132      36.636  35.459  58.376  1.00 33.52          
ATOM   1121  CD2 PHE   132      35.140  33.913  59.412  1.00 33.83          
ATOM   1122  CE1 PHE   132      36.568  36.285  59.487  1.00 34.34          
ATOM   1123  CE2 PHE   132      35.065  34.742  60.542  1.00 34.41          
ATOM   1124  CZ  PHE   132      35.771  35.924  60.576  1.00 33.89          
ATOM   1125  N   MET   133      36.904  35.362  54.935  1.00 32.69          
ATOM   1126  CA  MET   133      38.010  35.718  54.067  1.00 31.66          
ATOM   1127  C   MET   133      38.954  36.535  54.922  1.00 31.51          
ATOM   1128  O   MET   133      38.537  37.133  55.927  1.00 30.00          
ATOM   1129  CB  MET   133      37.526  36.476  52.840  1.00 31.10          
ATOM   1130  CG  MET   133      36.856  37.801  53.121  1.00 31.10          
ATOM   1131  SD  MET   133      38.027  39.306  53.371  0.75 27.39          
ATOM   1132  CE  MET   133      38.977  39.093  51.665  1.00 30.78          
ATOM   1133  N   ASN   134      40.221  36.573  54.505  1.00 31.65          
ATOM   1134  CA  ASN   134      41.234  37.341  55.187  1.00 31.18          
ATOM   1135  C   ASN   134      42.550  37.392  54.410  1.00 31.15          
ATOM   1136  O   ASN   134      42.766  36.638  53.465  1.00 30.05          
ATOM   1137  CB  ASN   134      41.495  36.734  56.590  1.00 30.95          
ATOM   1138  CG  ASN   134      41.738  35.215  56.546  1.00 30.15          
ATOM   1139  OD1 ASN   134      40.798  34.440  56.568  1.00 31.54          
ATOM   1140  ND2 ASN   134      42.995  34.799  56.503  1.00 29.15          
ATOM   1141  N   GLU   135      43.415  38.315  54.833  1.00 31.28          
ATOM   1142  CA  GLU   135      44.803  38.371  54.391  1.00 31.19          
ATOM   1143  C   GLU   135      45.467  37.105  54.902  1.00 31.28          
ATOM   1144  O   GLU   135      45.140  36.589  55.969  1.00 31.04          
ATOM   1145  CB  GLU   135      45.558  39.476  55.098  1.00 31.44          
ATOM   1146  CG  GLU   135      45.180  40.847  54.761  1.00 31.10          
ATOM   1147  CD  GLU   135      45.856  41.845  55.647  1.00 29.10          
ATOM   1148  OE1 GLU   135      46.045  41.590  56.849  1.00 28.16          
ATOM   1149  OE2 GLU   135      46.195  42.897  55.129  1.00 31.14          
ATOM   1150  N   ILE   136      46.428  36.630  54.138  1.00 31.61          
ATOM   1151  CA  ILE   136      47.195  35.464  54.493  1.00 32.13          
ATOM   1152  C   ILE   136      48.260  35.960  55.475  1.00 31.79          
ATOM   1153  O   ILE   136      48.986  36.842  55.151  1.00 31.36          
ATOM   1154  CB  ILE   136      47.756  34.806  53.214  1.00 32.92          
ATOM   1155  CG1 ILE   136      46.589  34.150  52.454  1.00 29.58          
ATOM   1156  CG2 ILE   136      48.856  33.804  53.539  1.00 32.26          
ATOM   1157  CD  ILE   136      46.975  33.467  51.130  1.00 32.30          
ATOM   1158  N   PRO   137      48.306  35.420  56.709  1.00 32.77          
ATOM   1159  CA  PRO   137      49.274  35.953  57.678  1.00 33.77          
ATOM   1160  C   PRO   137      50.699  36.014  57.169  1.00 34.29          
ATOM   1161  O   PRO   137      51.377  37.019  57.389  1.00 35.58          
ATOM   1162  CB  PRO   137      49.152  34.988  58.846  1.00 33.69          
ATOM   1163  CG  PRO   137      47.777  34.485  58.741  1.00 33.61          
ATOM   1164  CD  PRO   137      47.543  34.316  57.295  1.00 32.30          
ATOM   1165  N   SER   138      51.127  34.981  56.446  1.00 35.02          
ATOM   1166  CA  SER   138      52.505  34.911  55.921  1.00 35.03          
ATOM   1167  C   SER   138      52.782  35.841  54.769  1.00 34.80          
ATOM   1168  O   SER   138      53.940  36.110  54.460  1.00 35.23          
ATOM   1169  CB  SER   138      52.844  33.479  55.506  1.00 35.10          
ATOM   1170  OG  SER   138      51.877  32.964  54.630  1.00 36.69          
ATOM   1171  N   GLU   139      51.745  36.294  54.071  1.00 34.68          
ATOM   1172  CA  GLU   139      51.949  37.254  52.995  1.00 34.27          
ATOM   1173  C   GLU   139      50.666  38.041  52.816  1.00 33.05          
ATOM   1174  O   GLU   139      49.802  37.657  52.059  1.00 31.18          
ATOM   1175  CB  GLU   139      52.451  36.611  51.695  1.00 33.92          
ATOM   1176  CG  GLU   139      52.949  37.681  50.687  1.00 34.83          
ATOM   1177  CD  GLU   139      53.502  37.114  49.365  1.00 38.52          
ATOM   1178  OE1 GLU   139      53.819  35.880  49.300  1.00 45.31          
ATOM   1179  OE2 GLU   139      53.628  37.910  48.373  1.00 41.93          
ATOM   1180  N   ARG   140      50.601  39.169  53.525  1.00 33.00          
ATOM   1181  CA  ARG   140      49.403  40.016  53.617  1.00 33.02          
ATOM   1182  C   ARG   140      48.832  40.613  52.325  1.00 32.12          
ATOM   1183  O   ARG   140      47.656  40.969  52.287  1.00 33.01          
ATOM   1184  CB  ARG   140      49.625  41.110  54.641  1.00 33.55          
ATOM   1185  CG  ARG   140      49.618  40.603  56.020  1.00 33.72          
ATOM   1186  CD  ARG   140      49.867  41.760  56.931  1.00 33.98          
ATOM   1187  NE  ARG   140      50.073  41.335  58.312  1.00 31.90          
ATOM   1188  CZ  ARG   140      49.217  41.476  59.303  1.00 32.28          
ATOM   1189  NH1 ARG   140      48.041  42.066  59.130  1.00 32.64          
ATOM   1190  NH2 ARG   140      49.583  41.063  60.510  1.00 31.55          
ATOM   1191  N   ALA   141      49.650  40.687  51.297  1.00 31.04          
ATOM   1192  CA  ALA   141      49.264  41.118  49.961  1.00 31.25          
ATOM   1193  C   ALA   141      48.235  40.147  49.390  1.00 31.65          
ATOM   1194  O   ALA   141      47.406  40.544  48.588  1.00 31.63          
ATOM   1195  CB  ALA   141      50.563  41.125  49.009  1.00 30.79          
ATOM   1196  N   ASN   142      48.326  38.874  49.797  1.00 31.81          
ATOM   1197  CA  ASN   142      47.462  37.808  49.327  1.00 31.67          
ATOM   1198  C   ASN   142      46.288  37.546  50.303  1.00 31.60          
ATOM   1199  O   ASN   142      46.320  37.903  51.475  1.00 32.41          
ATOM   1200  CB  ASN   142      48.267  36.525  49.069  1.00 31.56          
ATOM   1201  CG  ASN   142      49.404  36.710  48.061  1.00 31.76          
ATOM   1202  OD1 ASN   142      49.383  37.601  47.221  1.00 32.48          
ATOM   1203  ND2 ASN   142      50.380  35.838  48.125  1.00 30.67          
ATOM   1204  N   TYR   143      45.237  36.943  49.771  1.00 30.91          
ATOM   1205  CA  TYR   143      44.031  36.663  50.498  1.00 29.87          
ATOM   1206  C   TYR   143      43.571  35.218  50.307  1.00 29.75          
ATOM   1207  O   TYR   143      43.975  34.535  49.396  1.00 28.22          
ATOM   1208  CB  TYR   143      42.927  37.625  50.042  1.00 29.90          
ATOM   1209  CG  TYR   143      43.155  39.083  50.455  1.00 29.48          
ATOM   1210  CD1 TYR   143      43.962  39.914  49.675  1.00 27.65          
ATOM   1211  CD2 TYR   143      42.558  39.617  51.586  1.00 28.99          
ATOM   1212  CE1 TYR   143      44.193  41.193  50.007  1.00 30.87          
ATOM   1213  CE2 TYR   143      42.791  40.948  51.960  1.00 30.29          
ATOM   1214  CZ  TYR   143      43.618  41.711  51.161  1.00 29.81          
ATOM   1215  OH  TYR   143      43.889  42.987  51.418  1.00 31.80          
ATOM   1216  N   VAL   144      42.674  34.788  51.179  1.00 30.32          
ATOM   1217  CA  VAL   144      42.092  33.471  51.114  1.00 29.85          
ATOM   1218  C   VAL   144      40.616  33.605  51.469  1.00 30.50          
ATOM   1219  O   VAL   144      40.258  34.388  52.334  1.00 29.82          
ATOM   1220  CB  VAL   144      42.831  32.484  52.080  1.00 30.16          
ATOM   1221  CG1 VAL   144      42.731  32.951  53.551  1.00 27.18          
ATOM   1222  CG2 VAL   144      42.364  31.038  51.848  1.00 26.04          
ATOM   1223  N   PHE   145      39.776  32.873  50.736  1.00 30.78          
ATOM   1224  CA  PHE   145      38.368  32.781  51.015  1.00 30.53          
ATOM   1225  C   PHE   145      38.091  31.372  51.542  1.00 31.23          
ATOM   1226  O   PHE   145      38.650  30.398  51.045  1.00 31.66          
ATOM   1227  CB  PHE   145      37.560  33.019  49.738  1.00 31.15          
ATOM   1228  CG  PHE   145      37.780  34.342  49.137  1.00 30.85          
ATOM   1229  CD1 PHE   145      38.842  34.558  48.281  1.00 34.03          
ATOM   1230  CD2 PHE   145      36.942  35.388  49.426  1.00 31.87          
ATOM   1231  CE1 PHE   145      39.066  35.816  47.740  1.00 34.40          
ATOM   1232  CE2 PHE   145      37.152  36.640  48.876  1.00 30.74          
ATOM   1233  CZ  PHE   145      38.202  36.853  48.047  1.00 33.01          
ATOM   1234  N   TYR   146      37.237  31.248  52.562  1.00 31.84          
ATOM   1235  CA  TYR   146      36.838  29.925  53.037  1.00 31.32          
ATOM   1236  C   TYR   146      35.381  29.768  52.699  1.00 31.18          
ATOM   1237  O   TYR   146      34.601  30.672  52.935  1.00 31.77          
ATOM   1238  CB  TYR   146      37.093  29.747  54.517  1.00 31.06          
ATOM   1239  CG  TYR   146      38.540  29.779  54.850  1.00 31.66          
ATOM   1240  CD1 TYR   146      39.353  28.675  54.624  1.00 30.78          
ATOM   1241  CD2 TYR   146      39.119  30.916  55.381  1.00 32.06          
ATOM   1242  CE1 TYR   146      40.710  28.737  54.912  1.00 29.18          
ATOM   1243  CE2 TYR   146      40.437  30.958  55.683  1.00 31.33          
ATOM   1244  CZ  TYR   146      41.229  29.871  55.449  1.00 29.30          
ATOM   1245  OH  TYR   146      42.553  29.946  55.758  1.00 28.91          
ATOM   1246  N   MET   147      35.046  28.631  52.095  1.00 30.69          
ATOM   1247  CA  MET   147      33.699  28.306  51.660  1.00 29.75          
ATOM   1248  C   MET   147      33.218  26.951  52.139  1.00 30.05          
ATOM   1249  O   MET   147      33.992  26.005  52.328  1.00 29.86          
ATOM   1250  CB  MET   147      33.628  28.236  50.136  1.00 29.81          
ATOM   1251  CG  MET   147      34.193  29.440  49.391  1.00 31.03          
ATOM   1252  SD  MET   147      33.768  29.343  47.480  0.75 24.67          
ATOM   1253  CE  MET   147      31.824  29.011  47.804  1.00 31.59          
ATOM   1254  N   LEU   148      31.906  26.880  52.290  1.00 30.34          
ATOM   1255  CA  LEU   148      31.204  25.643  52.525  1.00 30.70          
ATOM   1256  C   LEU   148      30.446  25.379  51.236  1.00 31.20          
ATOM   1257  O   LEU   148      29.611  26.178  50.845  1.00 30.39          
ATOM   1258  CB  LEU   148      30.226  25.776  53.678  1.00 31.03          
ATOM   1259  CG  LEU   148      29.417  24.551  54.099  1.00 31.02          
ATOM   1260  CD1 LEU   148      30.272  23.256  54.355  1.00 28.35          
ATOM   1261  CD2 LEU   148      28.555  24.945  55.327  1.00 30.25          
ATOM   1262  N   GLU   149      30.772  24.271  50.563  1.00 31.34          
ATOM   1263  CA  GLU   149      30.094  23.869  49.356  1.00 31.58          
ATOM   1264  C   GLU   149      28.685  23.391  49.687  1.00 31.67          
ATOM   1265  O   GLU   149      28.452  22.766  50.733  1.00 31.30          
ATOM   1266  CB  GLU   149      30.868  22.765  48.669  1.00 32.45          
ATOM   1267  CG  GLU   149      30.220  22.284  47.416  1.00 33.30          
ATOM   1268  CD  GLU   149      31.106  21.330  46.614  1.00 35.55          
ATOM   1269  OE1 GLU   149      32.085  20.774  47.165  1.00 36.82          
ATOM   1270  OE2 GLU   149      30.791  21.127  45.429  1.00 34.53          
ATOM   1271  N   GLU   150      27.724  23.708  48.820  1.00 31.85          
ATOM   1272  CA  GLU   150      26.365  23.296  49.066  1.00 31.76          
ATOM   1273  C   GLU   150      26.049  22.123  48.156  1.00 32.44          
ATOM   1274  OT1 GLU   150      26.770  21.884  47.194  1.00 31.65          
ATOM   1275  CB  GLU   150      25.387  24.453  48.842  1.00 31.59          
ATOM   1276  CG  GLU   150      25.137  24.836  47.399  1.00 31.11          
ATOM   1277  CD  GLU   150      24.323  26.107  47.253  1.00 31.51          
ATOM   1278  OE1 GLU   150      24.363  26.957  48.148  1.00 31.26          
ATOM   1279  OE2 GLU   150      23.660  26.276  46.205  1.00 32.14          
ATOM   1280  OT2 GLU   150      25.047  21.415  48.336  1.00 34.12          
END
