
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   99 ( 1453),  selected   99 , name 2ejm_A
# Molecule2: number of CA atoms   68 (  548),  selected   68 , name T0397_83_150.pdb
# PARAMETERS: 2ejm_A.T0397_83_150.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    V     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    S    10_A      -       -           -
LGA    Q    11_A      -       -           -
LGA    E    12_A      -       -           -
LGA    T    13_A      -       -           -
LGA    Q    14_A      L      83          5.106
LGA    G    15_A      I      84          0.559
LGA    G    16_A      S      85          2.093
LGA    P    17_A      V      86          1.470
LGA    L    18_A      P      87          2.403
LGA    A    19_A      A      88          3.092
LGA    P    20_A      E      89          4.953
LGA    M    21_A      -       -           -
LGA    T    22_A      G      90          3.797
LGA    G    23_A      Y      91          2.290
LGA    T    24_A      K      92          1.930
LGA    I    25_A      V      93          1.622
LGA    E    26_A      Y      94          2.870
LGA    K    27_A      -       -           -
LGA    V    28_A      P      95          2.678
LGA    F    29_A      I      96          2.789
LGA    V    30_A      M      97          5.013
LGA    K    31_A      D      98          1.749
LGA    A    32_A      F      99          1.094
LGA    G    33_A      G     100          0.657
LGA    D    34_A      F     101          0.712
LGA    K    35_A      R     102          1.370
LGA    V    36_A      V     103          1.345
LGA    K    37_A      L     104          1.591
LGA    A    38_A      K     105          0.885
LGA    G    39_A      G     106          0.833
LGA    D    40_A      Y     107          1.179
LGA    S    41_A      R     108          1.258
LGA    L    42_A      L     109          0.812
LGA    M    43_A      A     110          1.459
LGA    V    44_A      T     111          1.594
LGA    M    45_A      L     112          1.990
LGA    I    46_A      E     113          2.117
LGA    A    47_A      S     114          2.628
LGA    M    48_A      K     115          3.635
LGA    K    49_A      K     116          2.831
LGA    M    50_A      G     117          3.191
LGA    -       -      D     118           -
LGA    E    51_A      L     119          1.907
LGA    H    52_A      R     120          2.029
LGA    T    53_A      Y     121          1.706
LGA    I    54_A      V     122          1.267
LGA    K    55_A      N     123          1.328
LGA    S    56_A      S     124          1.328
LGA    P    57_A      P     125          1.212
LGA    K    58_A      V     126          1.323
LGA    D    59_A      S     127          1.461
LGA    G    60_A      G     128          1.302
LGA    T    61_A      T     129          0.665
LGA    V    62_A      V     130          0.591
LGA    K    63_A      I     131          0.591
LGA    K    64_A      F     132          0.480
LGA    V    65_A      M     133          0.751
LGA    F    66_A      N     134          0.965
LGA    Y    67_A      E     135          3.347
LGA    R    68_A      I     136           -
LGA    E    69_A      P     137           -
LGA    G    70_A      S     138           -
LGA    -       -      E     139           -
LGA    A    71_A      R     140          5.126
LGA    Q    72_A      A     141          0.199
LGA    A    73_A      N     142          1.518
LGA    N    74_A      -       -           -
LGA    R    75_A      -       -           -
LGA    H    76_A      -       -           -
LGA    T    77_A      -       -           -
LGA    P    78_A      Y     143           #
LGA    L    79_A      V     144          1.347
LGA    V    80_A      F     145          0.206
LGA    E    81_A      Y     146          0.234
LGA    F    82_A      M     147          0.278
LGA    E    83_A      L     148          2.545
LGA    E    84_A      -       -           -
LGA    E    85_A      E     149          4.007
LGA    E    86_A      E     150          5.357
LGA    S    87_A      -       -           -
LGA    D    88_A      -       -           -
LGA    K    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    E    91_A      -       -           -
LGA    S    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    S    94_A      -       -           -
LGA    G    95_A      -       -           -
LGA    P    96_A      -       -           -
LGA    S    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    G    99_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   99   68    5.0     62    2.32    20.97     73.288     2.562

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.740660 * X  +  -0.455415 * Y  +  -0.493984 * Z  +  42.697659
  Y_new =  -0.635850 * X  +  -0.712645 * Y  +  -0.296364 * Z  +  35.140862
  Z_new =  -0.217067 * X  +   0.533605 * Y  +  -0.817403 * Z  +  47.370407 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.563248   -0.578344  [ DEG:   146.8633    -33.1367 ]
  Theta =   0.218809    2.922784  [ DEG:    12.5368    167.4632 ]
  Phi   =  -0.709403    2.432190  [ DEG:   -40.6458    139.3542 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ejm_A                                        
REMARK     2: T0397_83_150.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ejm_A.T0397_83_150.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   99   68   5.0   62   2.32   20.97  73.288
REMARK  ---------------------------------------------------------- 
MOLECULE 2ejm_A
HEADER    LIGASE                                  19-MAR-07   2EJM              
TITLE     SOLUTION STRUCTURE OF RUH-072, AN APO-BIOTNYL DOMAIN FORM             
TITLE    2 HUMAN ACETYL COENZYME A CARBOXYLASE                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: METHYLCROTONOYL-COA CARBOXYLASE SUBUNIT ALPHA;             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: C-TERMINAL DOMAIN OF ACETYL COA CARBOXYLASE;               
COMPND   5 SYNONYM: 3-METHYLCROTONYL-COA CARBOXYLASE 1, MCCASE                  
COMPND   6 SUBUNIT ALPHA, 3-METHYLCROTONYL-COA:CARBON DIOXIDE LIGASE            
COMPND   7 SUBUNIT ALPHA, 3- METHYLCROTONYL-COA CARBOXYLASE BIOTIN-             
COMPND   8 CONTAINING SUBUNIT;                                                  
COMPND   9 EC: 6.4.1.4;                                                         
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MCCC1, MCCA;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PO50719-21;                               
SOURCE   8 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    BIOTIN-REQUIRING ENZYME, BIOTIN, ACTYL COA CARBOXYLASE,               
KEYWDS   2 FATTY ACID SYNTHESIS, STRUCTURAL GENOMICS, NPPSFA, NATIONAL          
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,               
KEYWDS   5 LIGASE                                                               
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.Z.M.RUHUL MOMEN,H.HIROTA,F.HAYASHI,S.YOKOYAMA,RIKEN                 
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   25-SEP-07 2EJM    0                                                
JRNL        AUTH   A.Z.M.RUHUL MOMEN,H.HIROTA,F.HAYASHI,S.YOKOYAMA              
JRNL        TITL   SOLUTION STRUCTURE OF RUH-072, AN APO-BIOTNYL                
JRNL        TITL 2 DOMAIN FORM HUMAN ACETYL COENZYME A CARBOXYLASE              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EJM A    8    93  UNP    Q96RQ3   MCCA_HUMAN     640    725             
SEQRES   1 A   99  GLY SER SER GLY SER SER GLY VAL SER SER GLN GLU THR          
SEQRES   2 A   99  GLN GLY GLY PRO LEU ALA PRO MET THR GLY THR ILE GLU          
SEQRES   3 A   99  LYS VAL PHE VAL LYS ALA GLY ASP LYS VAL LYS ALA GLY          
SEQRES   4 A   99  ASP SER LEU MET VAL MET ILE ALA MET LYS MET GLU HIS          
SEQRES   5 A   99  THR ILE LYS SER PRO LYS ASP GLY THR VAL LYS LYS VAL          
SEQRES   6 A   99  PHE TYR ARG GLU GLY ALA GLN ALA ASN ARG HIS THR PRO          
SEQRES   7 A   99  LEU VAL GLU PHE GLU GLU GLU GLU SER ASP LYS ARG GLU          
SEQRES   8 A   99  SER GLU SER GLY PRO SER SER GLY                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      41.896  19.688  39.143  1.00  0.00           N  
ATOM      2  CA  GLY A   1      42.741  19.135  40.188  1.00  0.00           C  
ATOM      3  C   GLY A   1      41.897  18.570  41.333  1.00  0.00           C  
ATOM      4  O   GLY A   1      41.462  19.312  42.212  1.00  0.00           O  
ATOM      5  H1  GLY A   1      42.331  19.768  38.247  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      43.371  18.349  39.773  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      43.406  19.909  40.570  1.00  0.00           H  
ATOM      8  N   SER A   2      41.693  17.263  41.285  1.00  0.00           N  
ATOM      9  CA  SER A   2      40.910  16.589  42.307  1.00  0.00           C  
ATOM     10  C   SER A   2      41.323  15.119  42.399  1.00  0.00           C  
ATOM     11  O   SER A   2      41.797  14.542  41.422  1.00  0.00           O  
ATOM     12  CB  SER A   2      39.413  16.704  42.018  1.00  0.00           C  
ATOM     13  OG  SER A   2      38.941  18.040  42.162  1.00  0.00           O  
ATOM     14  H   SER A   2      42.052  16.666  40.566  1.00  0.00           H  
ATOM     15  HA  SER A   2      41.140  17.110  43.237  1.00  0.00           H  
ATOM     16  HB2 SER A   2      39.211  16.356  41.004  1.00  0.00           H  
ATOM     17  HB3 SER A   2      38.862  16.050  42.694  1.00  0.00           H  
ATOM     18  HG  SER A   2      37.978  18.037  42.432  1.00  0.00           H  
ATOM     19  N   SER A   3      41.127  14.555  43.581  1.00  0.00           N  
ATOM     20  CA  SER A   3      41.472  13.162  43.813  1.00  0.00           C  
ATOM     21  C   SER A   3      42.986  12.975  43.708  1.00  0.00           C  
ATOM     22  O   SER A   3      43.542  12.981  42.612  1.00  0.00           O  
ATOM     23  CB  SER A   3      40.754  12.245  42.822  1.00  0.00           C  
ATOM     24  OG  SER A   3      39.540  11.725  43.358  1.00  0.00           O  
ATOM     25  H   SER A   3      40.740  15.031  44.371  1.00  0.00           H  
ATOM     26  HA  SER A   3      41.128  12.944  44.824  1.00  0.00           H  
ATOM     27  HB2 SER A   3      40.539  12.797  41.907  1.00  0.00           H  
ATOM     28  HB3 SER A   3      41.412  11.420  42.550  1.00  0.00           H  
ATOM     29  HG  SER A   3      39.694  11.381  44.284  1.00  0.00           H  
ATOM     30  N   GLY A   4      43.613  12.812  44.865  1.00  0.00           N  
ATOM     31  CA  GLY A   4      45.052  12.623  44.917  1.00  0.00           C  
ATOM     32  C   GLY A   4      45.784  13.965  44.853  1.00  0.00           C  
ATOM     33  O   GLY A   4      45.161  15.008  44.661  1.00  0.00           O  
ATOM     34  H   GLY A   4      43.154  12.808  45.754  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      45.321  12.102  45.836  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      45.369  11.991  44.088  1.00  0.00           H  
ATOM     37  N   SER A   5      47.097  13.895  45.016  1.00  0.00           N  
ATOM     38  CA  SER A   5      47.921  15.092  44.978  1.00  0.00           C  
ATOM     39  C   SER A   5      49.389  14.723  45.198  1.00  0.00           C  
ATOM     40  O   SER A   5      50.275  15.272  44.545  1.00  0.00           O  
ATOM     41  CB  SER A   5      47.465  16.107  46.028  1.00  0.00           C  
ATOM     42  OG  SER A   5      46.390  15.610  46.820  1.00  0.00           O  
ATOM     43  H   SER A   5      47.596  13.042  45.171  1.00  0.00           H  
ATOM     44  HA  SER A   5      47.776  15.510  43.982  1.00  0.00           H  
ATOM     45  HB2 SER A   5      48.305  16.360  46.676  1.00  0.00           H  
ATOM     46  HB3 SER A   5      47.156  17.027  45.533  1.00  0.00           H  
ATOM     47  HG  SER A   5      45.520  15.963  46.475  1.00  0.00           H  
ATOM     48  N   SER A   6      49.602  13.796  46.120  1.00  0.00           N  
ATOM     49  CA  SER A   6      50.948  13.348  46.434  1.00  0.00           C  
ATOM     50  C   SER A   6      51.726  14.469  47.125  1.00  0.00           C  
ATOM     51  O   SER A   6      51.379  15.642  46.993  1.00  0.00           O  
ATOM     52  CB  SER A   6      51.684  12.890  45.173  1.00  0.00           C  
ATOM     53  OG  SER A   6      52.703  11.937  45.466  1.00  0.00           O  
ATOM     54  H   SER A   6      48.875  13.354  46.647  1.00  0.00           H  
ATOM     55  HA  SER A   6      50.819  12.500  47.107  1.00  0.00           H  
ATOM     56  HB2 SER A   6      50.970  12.454  44.475  1.00  0.00           H  
ATOM     57  HB3 SER A   6      52.127  13.754  44.679  1.00  0.00           H  
ATOM     58  HG  SER A   6      52.561  11.554  46.379  1.00  0.00           H  
ATOM     59  N   GLY A   7      52.762  14.070  47.847  1.00  0.00           N  
ATOM     60  CA  GLY A   7      53.592  15.027  48.559  1.00  0.00           C  
ATOM     61  C   GLY A   7      52.738  15.947  49.435  1.00  0.00           C  
ATOM     62  O   GLY A   7      52.512  17.106  49.088  1.00  0.00           O  
ATOM     63  H   GLY A   7      53.037  13.115  47.949  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      54.315  14.497  49.179  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      54.160  15.623  47.844  1.00  0.00           H  
ATOM     66  N   VAL A   8      52.288  15.397  50.552  1.00  0.00           N  
ATOM     67  CA  VAL A   8      51.465  16.154  51.480  1.00  0.00           C  
ATOM     68  C   VAL A   8      51.425  15.430  52.827  1.00  0.00           C  
ATOM     69  O   VAL A   8      51.686  14.230  52.899  1.00  0.00           O  
ATOM     70  CB  VAL A   8      50.075  16.380  50.882  1.00  0.00           C  
ATOM     71  CG1 VAL A   8      49.133  15.226  51.232  1.00  0.00           C  
ATOM     72  CG2 VAL A   8      49.493  17.720  51.338  1.00  0.00           C  
ATOM     73  H   VAL A   8      52.476  14.454  50.827  1.00  0.00           H  
ATOM     74  HA  VAL A   8      51.936  17.127  51.618  1.00  0.00           H  
ATOM     75  HB  VAL A   8      50.178  16.411  49.797  1.00  0.00           H  
ATOM     76 HG11 VAL A   8      48.842  15.300  52.280  1.00  0.00           H  
ATOM     77 HG12 VAL A   8      48.244  15.279  50.604  1.00  0.00           H  
ATOM     78 HG13 VAL A   8      49.642  14.277  51.062  1.00  0.00           H  
ATOM     79 HG21 VAL A   8      49.542  18.435  50.517  1.00  0.00           H  
ATOM     80 HG22 VAL A   8      48.455  17.582  51.639  1.00  0.00           H  
ATOM     81 HG23 VAL A   8      50.070  18.097  52.183  1.00  0.00           H  
ATOM     82  N   SER A   9      51.098  16.189  53.862  1.00  0.00           N  
ATOM     83  CA  SER A   9      51.021  15.635  55.203  1.00  0.00           C  
ATOM     84  C   SER A   9      49.566  15.322  55.557  1.00  0.00           C  
ATOM     85  O   SER A   9      49.282  14.309  56.196  1.00  0.00           O  
ATOM     86  CB  SER A   9      51.622  16.595  56.231  1.00  0.00           C  
ATOM     87  OG  SER A   9      51.349  17.957  55.915  1.00  0.00           O  
ATOM     88  H   SER A   9      50.887  17.165  53.795  1.00  0.00           H  
ATOM     89  HA  SER A   9      51.613  14.721  55.172  1.00  0.00           H  
ATOM     90  HB2 SER A   9      51.223  16.365  57.219  1.00  0.00           H  
ATOM     91  HB3 SER A   9      52.701  16.444  56.281  1.00  0.00           H  
ATOM     92  HG  SER A   9      51.604  18.545  56.681  1.00  0.00           H  
ATOM     93  N   SER A  10      48.681  16.210  55.127  1.00  0.00           N  
ATOM     94  CA  SER A  10      47.262  16.042  55.391  1.00  0.00           C  
ATOM     95  C   SER A  10      46.444  16.561  54.208  1.00  0.00           C  
ATOM     96  O   SER A  10      46.004  15.782  53.364  1.00  0.00           O  
ATOM     97  CB  SER A  10      46.852  16.762  56.677  1.00  0.00           C  
ATOM     98  OG  SER A  10      47.222  16.029  57.842  1.00  0.00           O  
ATOM     99  H   SER A  10      48.920  17.031  54.610  1.00  0.00           H  
ATOM    100  HA  SER A  10      47.118  14.968  55.515  1.00  0.00           H  
ATOM    101  HB2 SER A  10      47.318  17.747  56.706  1.00  0.00           H  
ATOM    102  HB3 SER A  10      45.773  16.920  56.675  1.00  0.00           H  
ATOM    103  HG  SER A  10      48.133  16.306  58.145  1.00  0.00           H  
ATOM    104  N   GLN A  11      46.267  17.874  54.183  1.00  0.00           N  
ATOM    105  CA  GLN A  11      45.509  18.506  53.116  1.00  0.00           C  
ATOM    106  C   GLN A  11      46.016  19.930  52.878  1.00  0.00           C  
ATOM    107  O   GLN A  11      45.719  20.836  53.655  1.00  0.00           O  
ATOM    108  CB  GLN A  11      44.012  18.502  53.430  1.00  0.00           C  
ATOM    109  CG  GLN A  11      43.183  18.576  52.146  1.00  0.00           C  
ATOM    110  CD  GLN A  11      42.607  17.205  51.785  1.00  0.00           C  
ATOM    111  OE1 GLN A  11      41.894  16.580  52.554  1.00  0.00           O  
ATOM    112  NE2 GLN A  11      42.955  16.772  50.577  1.00  0.00           N  
ATOM    113  H   GLN A  11      46.629  18.500  54.873  1.00  0.00           H  
ATOM    114  HA  GLN A  11      45.691  17.896  52.231  1.00  0.00           H  
ATOM    115  HB2 GLN A  11      43.755  17.598  53.981  1.00  0.00           H  
ATOM    116  HB3 GLN A  11      43.769  19.347  54.073  1.00  0.00           H  
ATOM    117  HG2 GLN A  11      42.371  19.293  52.274  1.00  0.00           H  
ATOM    118  HG3 GLN A  11      43.804  18.939  51.328  1.00  0.00           H  
ATOM    119 HE21 GLN A  11      43.543  17.334  49.995  1.00  0.00           H  
ATOM    120 HE22 GLN A  11      42.627  15.886  50.249  1.00  0.00           H  
ATOM    121  N   GLU A  12      46.771  20.083  51.801  1.00  0.00           N  
ATOM    122  CA  GLU A  12      47.322  21.382  51.451  1.00  0.00           C  
ATOM    123  C   GLU A  12      46.242  22.461  51.553  1.00  0.00           C  
ATOM    124  O   GLU A  12      46.439  23.480  52.212  1.00  0.00           O  
ATOM    125  CB  GLU A  12      47.940  21.356  50.052  1.00  0.00           C  
ATOM    126  CG  GLU A  12      48.531  22.719  49.688  1.00  0.00           C  
ATOM    127  CD  GLU A  12      48.538  22.928  48.173  1.00  0.00           C  
ATOM    128  OE1 GLU A  12      49.473  22.403  47.531  1.00  0.00           O  
ATOM    129  OE2 GLU A  12      47.606  23.607  47.689  1.00  0.00           O  
ATOM    130  H   GLU A  12      47.009  19.341  51.174  1.00  0.00           H  
ATOM    131  HA  GLU A  12      48.105  21.571  52.184  1.00  0.00           H  
ATOM    132  HB2 GLU A  12      48.719  20.594  50.008  1.00  0.00           H  
ATOM    133  HB3 GLU A  12      47.181  21.078  49.319  1.00  0.00           H  
ATOM    134  HG2 GLU A  12      47.952  23.510  50.165  1.00  0.00           H  
ATOM    135  HG3 GLU A  12      49.549  22.793  50.073  1.00  0.00           H  
ATOM    136  N   THR A  13      45.124  22.199  50.891  1.00  0.00           N  
ATOM    137  CA  THR A  13      44.013  23.135  50.900  1.00  0.00           C  
ATOM    138  C   THR A  13      42.684  22.386  51.012  1.00  0.00           C  
ATOM    139  O   THR A  13      42.636  21.170  50.828  1.00  0.00           O  
ATOM    140  CB  THR A  13      44.117  24.004  49.644  1.00  0.00           C  
ATOM    141  OG1 THR A  13      43.201  25.069  49.882  1.00  0.00           O  
ATOM    142  CG2 THR A  13      43.562  23.305  48.402  1.00  0.00           C  
ATOM    143  H   THR A  13      44.972  21.367  50.357  1.00  0.00           H  
ATOM    144  HA  THR A  13      44.101  23.765  51.786  1.00  0.00           H  
ATOM    145  HB  THR A  13      45.144  24.331  49.481  1.00  0.00           H  
ATOM    146  HG1 THR A  13      43.461  25.870  49.343  1.00  0.00           H  
ATOM    147 HG21 THR A  13      42.475  23.397  48.389  1.00  0.00           H  
ATOM    148 HG22 THR A  13      43.976  23.771  47.508  1.00  0.00           H  
ATOM    149 HG23 THR A  13      43.837  22.251  48.424  1.00  0.00           H  
ATOM    150  N   GLN A  14      41.638  23.141  51.313  1.00  0.00           N  
ATOM    151  CA  GLN A  14      40.313  22.564  51.452  1.00  0.00           C  
ATOM    152  C   GLN A  14      39.274  23.664  51.672  1.00  0.00           C  
ATOM    153  O   GLN A  14      39.413  24.482  52.580  1.00  0.00           O  
ATOM    154  CB  GLN A  14      40.276  21.540  52.589  1.00  0.00           C  
ATOM    155  CG  GLN A  14      38.968  20.747  52.572  1.00  0.00           C  
ATOM    156  CD  GLN A  14      39.124  19.417  53.314  1.00  0.00           C  
ATOM    157  OE1 GLN A  14      39.914  19.279  54.232  1.00  0.00           O  
ATOM    158  NE2 GLN A  14      38.328  18.452  52.864  1.00  0.00           N  
ATOM    159  H   GLN A  14      41.687  24.129  51.461  1.00  0.00           H  
ATOM    160  HA  GLN A  14      40.119  22.054  50.508  1.00  0.00           H  
ATOM    161  HB2 GLN A  14      41.121  20.857  52.496  1.00  0.00           H  
ATOM    162  HB3 GLN A  14      40.384  22.051  53.546  1.00  0.00           H  
ATOM    163  HG2 GLN A  14      38.176  21.335  53.035  1.00  0.00           H  
ATOM    164  HG3 GLN A  14      38.666  20.560  51.542  1.00  0.00           H  
ATOM    165 HE21 GLN A  14      37.702  18.632  52.106  1.00  0.00           H  
ATOM    166 HE22 GLN A  14      38.355  17.545  53.286  1.00  0.00           H  
ATOM    167  N   GLY A  15      38.256  23.651  50.824  1.00  0.00           N  
ATOM    168  CA  GLY A  15      37.194  24.639  50.915  1.00  0.00           C  
ATOM    169  C   GLY A  15      37.755  26.059  50.812  1.00  0.00           C  
ATOM    170  O   GLY A  15      38.010  26.704  51.828  1.00  0.00           O  
ATOM    171  H   GLY A  15      38.150  22.984  50.088  1.00  0.00           H  
ATOM    172  HA2 GLY A  15      36.469  24.472  50.118  1.00  0.00           H  
ATOM    173  HA3 GLY A  15      36.662  24.521  51.859  1.00  0.00           H  
ATOM    174  N   GLY A  16      37.932  26.502  49.577  1.00  0.00           N  
ATOM    175  CA  GLY A  16      38.458  27.834  49.329  1.00  0.00           C  
ATOM    176  C   GLY A  16      39.456  27.822  48.168  1.00  0.00           C  
ATOM    177  O   GLY A  16      40.190  26.851  47.986  1.00  0.00           O  
ATOM    178  H   GLY A  16      37.722  25.971  48.756  1.00  0.00           H  
ATOM    179  HA2 GLY A  16      37.640  28.517  49.101  1.00  0.00           H  
ATOM    180  HA3 GLY A  16      38.946  28.210  50.228  1.00  0.00           H  
ATOM    181  N   PRO A  17      39.450  28.939  47.393  1.00  0.00           N  
ATOM    182  CA  PRO A  17      40.345  29.066  46.256  1.00  0.00           C  
ATOM    183  C   PRO A  17      41.777  29.350  46.714  1.00  0.00           C  
ATOM    184  O   PRO A  17      42.026  29.536  47.904  1.00  0.00           O  
ATOM    185  CB  PRO A  17      39.757  30.187  45.415  1.00  0.00           C  
ATOM    186  CG  PRO A  17      38.825  30.955  46.339  1.00  0.00           C  
ATOM    187  CD  PRO A  17      38.594  30.107  47.578  1.00  0.00           C  
ATOM    188  HA  PRO A  17      40.385  28.204  45.748  1.00  0.00           H  
ATOM    189  HB2 PRO A  17      40.542  30.835  45.025  1.00  0.00           H  
ATOM    190  HB3 PRO A  17      39.215  29.790  44.557  1.00  0.00           H  
ATOM    191  HG2 PRO A  17      39.264  31.916  46.610  1.00  0.00           H  
ATOM    192  HG3 PRO A  17      37.880  31.166  45.838  1.00  0.00           H  
ATOM    193  HD2 PRO A  17      38.857  30.651  48.486  1.00  0.00           H  
ATOM    194  HD3 PRO A  17      37.546  29.819  47.671  1.00  0.00           H  
ATOM    195  N   LEU A  18      42.680  29.373  45.745  1.00  0.00           N  
ATOM    196  CA  LEU A  18      44.081  29.631  46.034  1.00  0.00           C  
ATOM    197  C   LEU A  18      44.626  30.647  45.028  1.00  0.00           C  
ATOM    198  O   LEU A  18      44.510  30.453  43.819  1.00  0.00           O  
ATOM    199  CB  LEU A  18      44.870  28.321  46.073  1.00  0.00           C  
ATOM    200  CG  LEU A  18      44.606  27.415  47.278  1.00  0.00           C  
ATOM    201  CD1 LEU A  18      45.458  26.146  47.205  1.00  0.00           C  
ATOM    202  CD2 LEU A  18      44.819  28.173  48.590  1.00  0.00           C  
ATOM    203  H   LEU A  18      42.469  29.221  44.780  1.00  0.00           H  
ATOM    204  HA  LEU A  18      44.133  30.069  47.030  1.00  0.00           H  
ATOM    205  HB2 LEU A  18      44.647  27.758  45.166  1.00  0.00           H  
ATOM    206  HB3 LEU A  18      45.933  28.559  46.047  1.00  0.00           H  
ATOM    207  HG  LEU A  18      43.562  27.105  47.251  1.00  0.00           H  
ATOM    208 HD11 LEU A  18      44.919  25.378  46.651  1.00  0.00           H  
ATOM    209 HD12 LEU A  18      46.398  26.367  46.700  1.00  0.00           H  
ATOM    210 HD13 LEU A  18      45.663  25.788  48.214  1.00  0.00           H  
ATOM    211 HD21 LEU A  18      45.612  28.910  48.460  1.00  0.00           H  
ATOM    212 HD22 LEU A  18      43.895  28.679  48.871  1.00  0.00           H  
ATOM    213 HD23 LEU A  18      45.101  27.471  49.374  1.00  0.00           H  
ATOM    214  N   ALA A  19      45.209  31.709  45.565  1.00  0.00           N  
ATOM    215  CA  ALA A  19      45.771  32.757  44.729  1.00  0.00           C  
ATOM    216  C   ALA A  19      46.633  32.122  43.635  1.00  0.00           C  
ATOM    217  O   ALA A  19      47.229  31.066  43.843  1.00  0.00           O  
ATOM    218  CB  ALA A  19      46.563  33.734  45.601  1.00  0.00           C  
ATOM    219  H   ALA A  19      45.299  31.860  46.550  1.00  0.00           H  
ATOM    220  HA  ALA A  19      44.944  33.291  44.265  1.00  0.00           H  
ATOM    221  HB1 ALA A  19      46.000  34.661  45.710  1.00  0.00           H  
ATOM    222  HB2 ALA A  19      46.730  33.292  46.584  1.00  0.00           H  
ATOM    223  HB3 ALA A  19      47.523  33.945  45.130  1.00  0.00           H  
ATOM    224  N   PRO A  20      46.670  32.810  42.463  1.00  0.00           N  
ATOM    225  CA  PRO A  20      47.448  32.325  41.335  1.00  0.00           C  
ATOM    226  C   PRO A  20      48.943  32.558  41.560  1.00  0.00           C  
ATOM    227  O   PRO A  20      49.740  31.624  41.479  1.00  0.00           O  
ATOM    228  CB  PRO A  20      46.904  33.076  40.131  1.00  0.00           C  
ATOM    229  CG  PRO A  20      46.169  34.283  40.689  1.00  0.00           C  
ATOM    230  CD  PRO A  20      45.976  34.063  42.181  1.00  0.00           C  
ATOM    231  HA  PRO A  20      47.337  31.336  41.237  1.00  0.00           H  
ATOM    232  HB2 PRO A  20      47.711  33.383  39.465  1.00  0.00           H  
ATOM    233  HB3 PRO A  20      46.233  32.445  39.548  1.00  0.00           H  
ATOM    234  HG2 PRO A  20      46.739  35.194  40.508  1.00  0.00           H  
ATOM    235  HG3 PRO A  20      45.206  34.406  40.194  1.00  0.00           H  
ATOM    236  HD2 PRO A  20      46.394  34.886  42.760  1.00  0.00           H  
ATOM    237  HD3 PRO A  20      44.919  33.996  42.438  1.00  0.00           H  
ATOM    238  N   MET A  21      49.280  33.809  41.837  1.00  0.00           N  
ATOM    239  CA  MET A  21      50.665  34.176  42.074  1.00  0.00           C  
ATOM    240  C   MET A  21      50.763  35.318  43.089  1.00  0.00           C  
ATOM    241  O   MET A  21      49.746  35.846  43.535  1.00  0.00           O  
ATOM    242  CB  MET A  21      51.312  34.607  40.757  1.00  0.00           C  
ATOM    243  CG  MET A  21      50.316  35.371  39.881  1.00  0.00           C  
ATOM    244  SD  MET A  21      51.036  35.700  38.281  1.00  0.00           S  
ATOM    245  CE  MET A  21      49.655  35.285  37.229  1.00  0.00           C  
ATOM    246  H   MET A  21      48.626  34.563  41.902  1.00  0.00           H  
ATOM    247  HA  MET A  21      51.141  33.282  42.476  1.00  0.00           H  
ATOM    248  HB2 MET A  21      52.179  35.235  40.961  1.00  0.00           H  
ATOM    249  HB3 MET A  21      51.673  33.730  40.220  1.00  0.00           H  
ATOM    250  HG2 MET A  21      49.402  34.791  39.765  1.00  0.00           H  
ATOM    251  HG3 MET A  21      50.040  36.309  40.364  1.00  0.00           H  
ATOM    252  HE1 MET A  21      49.276  34.300  37.499  1.00  0.00           H  
ATOM    253  HE2 MET A  21      48.866  36.026  37.358  1.00  0.00           H  
ATOM    254  HE3 MET A  21      49.981  35.277  36.188  1.00  0.00           H  
ATOM    255  N   THR A  22      51.998  35.665  43.423  1.00  0.00           N  
ATOM    256  CA  THR A  22      52.243  36.734  44.375  1.00  0.00           C  
ATOM    257  C   THR A  22      51.770  38.074  43.807  1.00  0.00           C  
ATOM    258  O   THR A  22      52.382  38.612  42.886  1.00  0.00           O  
ATOM    259  CB  THR A  22      53.730  36.717  44.733  1.00  0.00           C  
ATOM    260  OG1 THR A  22      53.990  35.358  45.074  1.00  0.00           O  
ATOM    261  CG2 THR A  22      54.033  37.488  46.020  1.00  0.00           C  
ATOM    262  H   THR A  22      52.820  35.231  43.054  1.00  0.00           H  
ATOM    263  HA  THR A  22      51.652  36.539  45.270  1.00  0.00           H  
ATOM    264  HB  THR A  22      54.334  37.089  43.905  1.00  0.00           H  
ATOM    265  HG1 THR A  22      53.322  35.041  45.747  1.00  0.00           H  
ATOM    266 HG21 THR A  22      53.147  38.044  46.327  1.00  0.00           H  
ATOM    267 HG22 THR A  22      54.313  36.787  46.805  1.00  0.00           H  
ATOM    268 HG23 THR A  22      54.854  38.183  45.842  1.00  0.00           H  
ATOM    269  N   GLY A  23      50.686  38.573  44.381  1.00  0.00           N  
ATOM    270  CA  GLY A  23      50.124  39.840  43.944  1.00  0.00           C  
ATOM    271  C   GLY A  23      49.496  40.596  45.117  1.00  0.00           C  
ATOM    272  O   GLY A  23      49.699  40.232  46.274  1.00  0.00           O  
ATOM    273  H   GLY A  23      50.194  38.129  45.130  1.00  0.00           H  
ATOM    274  HA2 GLY A  23      50.903  40.449  43.488  1.00  0.00           H  
ATOM    275  HA3 GLY A  23      49.369  39.662  43.177  1.00  0.00           H  
ATOM    276  N   THR A  24      48.748  41.635  44.778  1.00  0.00           N  
ATOM    277  CA  THR A  24      48.090  42.445  45.788  1.00  0.00           C  
ATOM    278  C   THR A  24      46.595  42.566  45.485  1.00  0.00           C  
ATOM    279  O   THR A  24      46.207  42.814  44.346  1.00  0.00           O  
ATOM    280  CB  THR A  24      48.808  43.796  45.852  1.00  0.00           C  
ATOM    281  OG1 THR A  24      50.137  43.464  46.243  1.00  0.00           O  
ATOM    282  CG2 THR A  24      48.294  44.678  46.990  1.00  0.00           C  
ATOM    283  H   THR A  24      48.588  41.924  43.834  1.00  0.00           H  
ATOM    284  HA  THR A  24      48.183  41.939  46.749  1.00  0.00           H  
ATOM    285  HB  THR A  24      48.744  44.315  44.896  1.00  0.00           H  
ATOM    286  HG1 THR A  24      50.510  42.767  45.630  1.00  0.00           H  
ATOM    287 HG21 THR A  24      48.015  45.655  46.595  1.00  0.00           H  
ATOM    288 HG22 THR A  24      47.423  44.210  47.449  1.00  0.00           H  
ATOM    289 HG23 THR A  24      49.077  44.799  47.739  1.00  0.00           H  
ATOM    290  N   ILE A  25      45.798  42.385  46.527  1.00  0.00           N  
ATOM    291  CA  ILE A  25      44.353  42.470  46.388  1.00  0.00           C  
ATOM    292  C   ILE A  25      43.959  43.916  46.083  1.00  0.00           C  
ATOM    293  O   ILE A  25      44.154  44.804  46.912  1.00  0.00           O  
ATOM    294  CB  ILE A  25      43.661  41.890  47.622  1.00  0.00           C  
ATOM    295  CG1 ILE A  25      44.197  40.495  47.948  1.00  0.00           C  
ATOM    296  CG2 ILE A  25      42.140  41.894  47.450  1.00  0.00           C  
ATOM    297  CD1 ILE A  25      43.890  39.512  46.817  1.00  0.00           C  
ATOM    298  H   ILE A  25      46.121  42.184  47.452  1.00  0.00           H  
ATOM    299  HA  ILE A  25      44.070  41.849  45.538  1.00  0.00           H  
ATOM    300  HB  ILE A  25      43.889  42.531  48.474  1.00  0.00           H  
ATOM    301 HG12 ILE A  25      45.275  40.545  48.110  1.00  0.00           H  
ATOM    302 HG13 ILE A  25      43.751  40.138  48.877  1.00  0.00           H  
ATOM    303 HG21 ILE A  25      41.720  42.771  47.943  1.00  0.00           H  
ATOM    304 HG22 ILE A  25      41.895  41.921  46.389  1.00  0.00           H  
ATOM    305 HG23 ILE A  25      41.722  40.991  47.897  1.00  0.00           H  
ATOM    306 HD11 ILE A  25      43.348  40.027  46.025  1.00  0.00           H  
ATOM    307 HD12 ILE A  25      44.824  39.114  46.419  1.00  0.00           H  
ATOM    308 HD13 ILE A  25      43.282  38.694  47.202  1.00  0.00           H  
ATOM    309  N   GLU A  26      43.412  44.110  44.892  1.00  0.00           N  
ATOM    310  CA  GLU A  26      42.988  45.433  44.469  1.00  0.00           C  
ATOM    311  C   GLU A  26      41.545  45.694  44.906  1.00  0.00           C  
ATOM    312  O   GLU A  26      41.250  46.735  45.491  1.00  0.00           O  
ATOM    313  CB  GLU A  26      43.141  45.599  42.956  1.00  0.00           C  
ATOM    314  CG  GLU A  26      42.794  47.025  42.523  1.00  0.00           C  
ATOM    315  CD  GLU A  26      43.704  48.043  43.212  1.00  0.00           C  
ATOM    316  OE1 GLU A  26      44.936  47.834  43.158  1.00  0.00           O  
ATOM    317  OE2 GLU A  26      43.148  49.009  43.779  1.00  0.00           O  
ATOM    318  H   GLU A  26      43.257  43.382  44.225  1.00  0.00           H  
ATOM    319  HA  GLU A  26      43.660  46.128  44.973  1.00  0.00           H  
ATOM    320  HB2 GLU A  26      44.165  45.365  42.661  1.00  0.00           H  
ATOM    321  HB3 GLU A  26      42.492  44.891  42.441  1.00  0.00           H  
ATOM    322  HG2 GLU A  26      42.896  47.115  41.441  1.00  0.00           H  
ATOM    323  HG3 GLU A  26      41.754  47.239  42.764  1.00  0.00           H  
ATOM    324  N   LYS A  27      40.687  44.732  44.605  1.00  0.00           N  
ATOM    325  CA  LYS A  27      39.282  44.845  44.961  1.00  0.00           C  
ATOM    326  C   LYS A  27      38.821  43.544  45.620  1.00  0.00           C  
ATOM    327  O   LYS A  27      39.461  42.506  45.468  1.00  0.00           O  
ATOM    328  CB  LYS A  27      38.451  45.242  43.738  1.00  0.00           C  
ATOM    329  CG  LYS A  27      38.348  46.764  43.617  1.00  0.00           C  
ATOM    330  CD  LYS A  27      37.147  47.296  44.401  1.00  0.00           C  
ATOM    331  CE  LYS A  27      37.552  48.467  45.299  1.00  0.00           C  
ATOM    332  NZ  LYS A  27      36.387  48.958  46.068  1.00  0.00           N  
ATOM    333  H   LYS A  27      40.935  43.888  44.129  1.00  0.00           H  
ATOM    334  HA  LYS A  27      39.193  45.652  45.687  1.00  0.00           H  
ATOM    335  HB2 LYS A  27      38.904  44.832  42.836  1.00  0.00           H  
ATOM    336  HB3 LYS A  27      37.452  44.812  43.818  1.00  0.00           H  
ATOM    337  HG2 LYS A  27      39.262  47.225  43.990  1.00  0.00           H  
ATOM    338  HG3 LYS A  27      38.255  47.043  42.567  1.00  0.00           H  
ATOM    339  HD2 LYS A  27      36.369  47.619  43.707  1.00  0.00           H  
ATOM    340  HD3 LYS A  27      36.721  46.497  45.008  1.00  0.00           H  
ATOM    341  HE2 LYS A  27      38.340  48.151  45.983  1.00  0.00           H  
ATOM    342  HE3 LYS A  27      37.962  49.274  44.691  1.00  0.00           H  
ATOM    343  HZ1 LYS A  27      36.506  48.731  47.034  1.00  0.00           H  
ATOM    344  HZ2 LYS A  27      36.315  49.950  45.965  1.00  0.00           H  
ATOM    345  HZ3 LYS A  27      35.554  48.526  45.724  1.00  0.00           H  
ATOM    346  N   VAL A  28      37.713  43.644  46.341  1.00  0.00           N  
ATOM    347  CA  VAL A  28      37.159  42.488  47.025  1.00  0.00           C  
ATOM    348  C   VAL A  28      35.632  42.530  46.932  1.00  0.00           C  
ATOM    349  O   VAL A  28      34.985  43.308  47.630  1.00  0.00           O  
ATOM    350  CB  VAL A  28      37.669  42.439  48.467  1.00  0.00           C  
ATOM    351  CG1 VAL A  28      36.919  41.380  49.278  1.00  0.00           C  
ATOM    352  CG2 VAL A  28      39.178  42.194  48.506  1.00  0.00           C  
ATOM    353  H   VAL A  28      37.198  44.493  46.459  1.00  0.00           H  
ATOM    354  HA  VAL A  28      37.518  41.597  46.510  1.00  0.00           H  
ATOM    355  HB  VAL A  28      37.476  43.410  48.924  1.00  0.00           H  
ATOM    356 HG11 VAL A  28      36.488  41.842  50.167  1.00  0.00           H  
ATOM    357 HG12 VAL A  28      36.125  40.952  48.668  1.00  0.00           H  
ATOM    358 HG13 VAL A  28      37.613  40.594  49.577  1.00  0.00           H  
ATOM    359 HG21 VAL A  28      39.464  41.549  47.676  1.00  0.00           H  
ATOM    360 HG22 VAL A  28      39.704  43.146  48.424  1.00  0.00           H  
ATOM    361 HG23 VAL A  28      39.444  41.712  49.447  1.00  0.00           H  
ATOM    362  N   PHE A  29      35.101  41.682  46.064  1.00  0.00           N  
ATOM    363  CA  PHE A  29      33.663  41.611  45.870  1.00  0.00           C  
ATOM    364  C   PHE A  29      33.075  40.380  46.564  1.00  0.00           C  
ATOM    365  O   PHE A  29      32.339  39.610  45.951  1.00  0.00           O  
ATOM    366  CB  PHE A  29      33.419  41.498  44.364  1.00  0.00           C  
ATOM    367  CG  PHE A  29      34.095  42.596  43.540  1.00  0.00           C  
ATOM    368  CD1 PHE A  29      33.837  43.903  43.809  1.00  0.00           C  
ATOM    369  CD2 PHE A  29      34.953  42.263  42.539  1.00  0.00           C  
ATOM    370  CE1 PHE A  29      34.465  44.922  43.043  1.00  0.00           C  
ATOM    371  CE2 PHE A  29      35.582  43.282  41.774  1.00  0.00           C  
ATOM    372  CZ  PHE A  29      35.324  44.589  42.043  1.00  0.00           C  
ATOM    373  H   PHE A  29      35.635  41.051  45.499  1.00  0.00           H  
ATOM    374  HA  PHE A  29      33.233  42.511  46.308  1.00  0.00           H  
ATOM    375  HB2 PHE A  29      33.777  40.527  44.020  1.00  0.00           H  
ATOM    376  HB3 PHE A  29      32.345  41.527  44.177  1.00  0.00           H  
ATOM    377  HD1 PHE A  29      33.150  44.170  44.611  1.00  0.00           H  
ATOM    378  HD2 PHE A  29      35.160  41.214  42.324  1.00  0.00           H  
ATOM    379  HE1 PHE A  29      34.259  45.971  43.259  1.00  0.00           H  
ATOM    380  HE2 PHE A  29      36.269  43.015  40.972  1.00  0.00           H  
ATOM    381  HZ  PHE A  29      35.805  45.371  41.455  1.00  0.00           H  
ATOM    382  N   VAL A  30      33.425  40.233  47.833  1.00  0.00           N  
ATOM    383  CA  VAL A  30      32.942  39.109  48.617  1.00  0.00           C  
ATOM    384  C   VAL A  30      32.821  39.530  50.083  1.00  0.00           C  
ATOM    385  O   VAL A  30      33.043  40.691  50.421  1.00  0.00           O  
ATOM    386  CB  VAL A  30      33.857  37.900  48.416  1.00  0.00           C  
ATOM    387  CG1 VAL A  30      33.835  37.431  46.960  1.00  0.00           C  
ATOM    388  CG2 VAL A  30      35.285  38.210  48.871  1.00  0.00           C  
ATOM    389  H   VAL A  30      34.025  40.864  48.325  1.00  0.00           H  
ATOM    390  HA  VAL A  30      31.952  38.849  48.243  1.00  0.00           H  
ATOM    391  HB  VAL A  30      33.478  37.086  49.035  1.00  0.00           H  
ATOM    392 HG11 VAL A  30      34.524  36.595  46.837  1.00  0.00           H  
ATOM    393 HG12 VAL A  30      32.826  37.113  46.696  1.00  0.00           H  
ATOM    394 HG13 VAL A  30      34.139  38.252  46.310  1.00  0.00           H  
ATOM    395 HG21 VAL A  30      35.264  39.008  49.613  1.00  0.00           H  
ATOM    396 HG22 VAL A  30      35.729  37.317  49.310  1.00  0.00           H  
ATOM    397 HG23 VAL A  30      35.878  38.527  48.013  1.00  0.00           H  
ATOM    398  N   LYS A  31      32.467  38.561  50.916  1.00  0.00           N  
ATOM    399  CA  LYS A  31      32.313  38.816  52.338  1.00  0.00           C  
ATOM    400  C   LYS A  31      31.811  37.547  53.028  1.00  0.00           C  
ATOM    401  O   LYS A  31      31.363  36.612  52.367  1.00  0.00           O  
ATOM    402  CB  LYS A  31      31.419  40.036  52.569  1.00  0.00           C  
ATOM    403  CG  LYS A  31      30.141  39.947  51.734  1.00  0.00           C  
ATOM    404  CD  LYS A  31      28.970  39.433  52.575  1.00  0.00           C  
ATOM    405  CE  LYS A  31      28.470  40.515  53.535  1.00  0.00           C  
ATOM    406  NZ  LYS A  31      27.048  40.289  53.874  1.00  0.00           N  
ATOM    407  H   LYS A  31      32.287  37.620  50.634  1.00  0.00           H  
ATOM    408  HA  LYS A  31      33.298  39.060  52.735  1.00  0.00           H  
ATOM    409  HB2 LYS A  31      31.162  40.109  53.627  1.00  0.00           H  
ATOM    410  HB3 LYS A  31      31.963  40.945  52.312  1.00  0.00           H  
ATOM    411  HG2 LYS A  31      29.898  40.928  51.326  1.00  0.00           H  
ATOM    412  HG3 LYS A  31      30.303  39.281  50.886  1.00  0.00           H  
ATOM    413  HD2 LYS A  31      28.157  39.120  51.920  1.00  0.00           H  
ATOM    414  HD3 LYS A  31      29.281  38.555  53.141  1.00  0.00           H  
ATOM    415  HE2 LYS A  31      29.072  40.510  54.443  1.00  0.00           H  
ATOM    416  HE3 LYS A  31      28.589  41.498  53.079  1.00  0.00           H  
ATOM    417  HZ1 LYS A  31      26.934  39.362  54.234  1.00  0.00           H  
ATOM    418  HZ2 LYS A  31      26.761  40.952  54.566  1.00  0.00           H  
ATOM    419  HZ3 LYS A  31      26.487  40.399  53.054  1.00  0.00           H  
ATOM    420  N   ALA A  32      31.904  37.554  54.350  1.00  0.00           N  
ATOM    421  CA  ALA A  32      31.466  36.415  55.138  1.00  0.00           C  
ATOM    422  C   ALA A  32      29.940  36.314  55.077  1.00  0.00           C  
ATOM    423  O   ALA A  32      29.253  37.327  54.961  1.00  0.00           O  
ATOM    424  CB  ALA A  32      31.984  36.553  56.570  1.00  0.00           C  
ATOM    425  H   ALA A  32      32.270  38.319  54.881  1.00  0.00           H  
ATOM    426  HA  ALA A  32      31.898  35.518  54.693  1.00  0.00           H  
ATOM    427  HB1 ALA A  32      31.143  36.544  57.264  1.00  0.00           H  
ATOM    428  HB2 ALA A  32      32.651  35.722  56.798  1.00  0.00           H  
ATOM    429  HB3 ALA A  32      32.528  37.492  56.670  1.00  0.00           H  
ATOM    430  N   GLY A  33      29.456  35.084  55.157  1.00  0.00           N  
ATOM    431  CA  GLY A  33      28.024  34.839  55.113  1.00  0.00           C  
ATOM    432  C   GLY A  33      27.414  35.387  53.821  1.00  0.00           C  
ATOM    433  O   GLY A  33      26.236  35.739  53.788  1.00  0.00           O  
ATOM    434  H   GLY A  33      30.022  34.265  55.251  1.00  0.00           H  
ATOM    435  HA2 GLY A  33      27.833  33.768  55.184  1.00  0.00           H  
ATOM    436  HA3 GLY A  33      27.545  35.307  55.973  1.00  0.00           H  
ATOM    437  N   ASP A  34      28.243  35.442  52.790  1.00  0.00           N  
ATOM    438  CA  ASP A  34      27.800  35.941  51.499  1.00  0.00           C  
ATOM    439  C   ASP A  34      27.446  34.759  50.594  1.00  0.00           C  
ATOM    440  O   ASP A  34      27.677  33.606  50.955  1.00  0.00           O  
ATOM    441  CB  ASP A  34      28.904  36.748  50.812  1.00  0.00           C  
ATOM    442  CG  ASP A  34      28.419  37.714  49.728  1.00  0.00           C  
ATOM    443  OD1 ASP A  34      27.234  38.104  49.803  1.00  0.00           O  
ATOM    444  OD2 ASP A  34      29.245  38.038  48.847  1.00  0.00           O  
ATOM    445  H   ASP A  34      29.200  35.153  52.825  1.00  0.00           H  
ATOM    446  HA  ASP A  34      26.938  36.572  51.717  1.00  0.00           H  
ATOM    447  HB2 ASP A  34      29.441  37.319  51.570  1.00  0.00           H  
ATOM    448  HB3 ASP A  34      29.618  36.055  50.368  1.00  0.00           H  
ATOM    449  N   LYS A  35      26.892  35.087  49.436  1.00  0.00           N  
ATOM    450  CA  LYS A  35      26.503  34.067  48.477  1.00  0.00           C  
ATOM    451  C   LYS A  35      27.148  34.374  47.124  1.00  0.00           C  
ATOM    452  O   LYS A  35      27.023  35.485  46.611  1.00  0.00           O  
ATOM    453  CB  LYS A  35      24.980  33.939  48.418  1.00  0.00           C  
ATOM    454  CG  LYS A  35      24.392  33.741  49.817  1.00  0.00           C  
ATOM    455  CD  LYS A  35      24.549  32.289  50.276  1.00  0.00           C  
ATOM    456  CE  LYS A  35      23.588  31.971  51.424  1.00  0.00           C  
ATOM    457  NZ  LYS A  35      22.450  31.159  50.938  1.00  0.00           N  
ATOM    458  H   LYS A  35      26.707  36.028  49.151  1.00  0.00           H  
ATOM    459  HA  LYS A  35      26.893  33.115  48.837  1.00  0.00           H  
ATOM    460  HB2 LYS A  35      24.553  34.833  47.964  1.00  0.00           H  
ATOM    461  HB3 LYS A  35      24.707  33.097  47.781  1.00  0.00           H  
ATOM    462  HG2 LYS A  35      24.891  34.405  50.522  1.00  0.00           H  
ATOM    463  HG3 LYS A  35      23.336  34.013  49.813  1.00  0.00           H  
ATOM    464  HD2 LYS A  35      24.357  31.617  49.440  1.00  0.00           H  
ATOM    465  HD3 LYS A  35      25.575  32.114  50.597  1.00  0.00           H  
ATOM    466  HE2 LYS A  35      24.117  31.433  52.211  1.00  0.00           H  
ATOM    467  HE3 LYS A  35      23.219  32.897  51.864  1.00  0.00           H  
ATOM    468  HZ1 LYS A  35      22.555  30.993  49.957  1.00  0.00           H  
ATOM    469  HZ2 LYS A  35      22.432  30.286  51.425  1.00  0.00           H  
ATOM    470  HZ3 LYS A  35      21.595  31.651  51.103  1.00  0.00           H  
ATOM    471  N   VAL A  36      27.824  33.370  46.584  1.00  0.00           N  
ATOM    472  CA  VAL A  36      28.487  33.519  45.301  1.00  0.00           C  
ATOM    473  C   VAL A  36      28.041  32.392  44.367  1.00  0.00           C  
ATOM    474  O   VAL A  36      27.325  31.483  44.783  1.00  0.00           O  
ATOM    475  CB  VAL A  36      30.004  33.567  45.497  1.00  0.00           C  
ATOM    476  CG1 VAL A  36      30.434  34.900  46.113  1.00  0.00           C  
ATOM    477  CG2 VAL A  36      30.483  32.390  46.349  1.00  0.00           C  
ATOM    478  H   VAL A  36      27.921  32.470  47.009  1.00  0.00           H  
ATOM    479  HA  VAL A  36      28.172  34.473  44.875  1.00  0.00           H  
ATOM    480  HB  VAL A  36      30.472  33.484  44.518  1.00  0.00           H  
ATOM    481 HG11 VAL A  36      30.917  34.718  47.074  1.00  0.00           H  
ATOM    482 HG12 VAL A  36      31.135  35.400  45.444  1.00  0.00           H  
ATOM    483 HG13 VAL A  36      29.558  35.532  46.261  1.00  0.00           H  
ATOM    484 HG21 VAL A  36      31.564  32.290  46.255  1.00  0.00           H  
ATOM    485 HG22 VAL A  36      30.224  32.567  47.393  1.00  0.00           H  
ATOM    486 HG23 VAL A  36      30.002  31.474  46.007  1.00  0.00           H  
ATOM    487  N   LYS A  37      28.483  32.489  43.121  1.00  0.00           N  
ATOM    488  CA  LYS A  37      28.138  31.489  42.125  1.00  0.00           C  
ATOM    489  C   LYS A  37      29.402  31.068  41.373  1.00  0.00           C  
ATOM    490  O   LYS A  37      30.191  31.915  40.954  1.00  0.00           O  
ATOM    491  CB  LYS A  37      27.023  32.003  41.213  1.00  0.00           C  
ATOM    492  CG  LYS A  37      25.683  32.040  41.953  1.00  0.00           C  
ATOM    493  CD  LYS A  37      24.614  31.260  41.187  1.00  0.00           C  
ATOM    494  CE  LYS A  37      23.331  32.082  41.046  1.00  0.00           C  
ATOM    495  NZ  LYS A  37      22.305  31.612  42.003  1.00  0.00           N  
ATOM    496  H   LYS A  37      29.066  33.232  42.791  1.00  0.00           H  
ATOM    497  HA  LYS A  37      27.747  30.621  42.655  1.00  0.00           H  
ATOM    498  HB2 LYS A  37      27.272  33.002  40.855  1.00  0.00           H  
ATOM    499  HB3 LYS A  37      26.941  31.362  40.335  1.00  0.00           H  
ATOM    500  HG2 LYS A  37      25.804  31.616  42.950  1.00  0.00           H  
ATOM    501  HG3 LYS A  37      25.363  33.073  42.082  1.00  0.00           H  
ATOM    502  HD2 LYS A  37      24.989  30.993  40.199  1.00  0.00           H  
ATOM    503  HD3 LYS A  37      24.396  30.326  41.707  1.00  0.00           H  
ATOM    504  HE2 LYS A  37      23.547  33.135  41.224  1.00  0.00           H  
ATOM    505  HE3 LYS A  37      22.951  32.003  40.027  1.00  0.00           H  
ATOM    506  HZ1 LYS A  37      22.609  31.798  42.937  1.00  0.00           H  
ATOM    507  HZ2 LYS A  37      21.444  32.090  41.830  1.00  0.00           H  
ATOM    508  HZ3 LYS A  37      22.168  30.627  41.887  1.00  0.00           H  
ATOM    509  N   ALA A  38      29.556  29.761  41.223  1.00  0.00           N  
ATOM    510  CA  ALA A  38      30.711  29.218  40.529  1.00  0.00           C  
ATOM    511  C   ALA A  38      31.025  30.089  39.311  1.00  0.00           C  
ATOM    512  O   ALA A  38      30.190  30.242  38.421  1.00  0.00           O  
ATOM    513  CB  ALA A  38      30.439  27.761  40.148  1.00  0.00           C  
ATOM    514  H   ALA A  38      28.911  29.079  41.567  1.00  0.00           H  
ATOM    515  HA  ALA A  38      31.557  29.249  41.216  1.00  0.00           H  
ATOM    516  HB1 ALA A  38      29.611  27.377  40.745  1.00  0.00           H  
ATOM    517  HB2 ALA A  38      30.183  27.703  39.091  1.00  0.00           H  
ATOM    518  HB3 ALA A  38      31.331  27.163  40.339  1.00  0.00           H  
ATOM    519  N   GLY A  39      32.231  30.638  39.312  1.00  0.00           N  
ATOM    520  CA  GLY A  39      32.666  31.490  38.218  1.00  0.00           C  
ATOM    521  C   GLY A  39      32.232  32.940  38.446  1.00  0.00           C  
ATOM    522  O   GLY A  39      31.835  33.628  37.507  1.00  0.00           O  
ATOM    523  H   GLY A  39      32.904  30.509  40.039  1.00  0.00           H  
ATOM    524  HA2 GLY A  39      33.750  31.442  38.123  1.00  0.00           H  
ATOM    525  HA3 GLY A  39      32.247  31.126  37.279  1.00  0.00           H  
ATOM    526  N   ASP A  40      32.322  33.360  39.699  1.00  0.00           N  
ATOM    527  CA  ASP A  40      31.944  34.715  40.064  1.00  0.00           C  
ATOM    528  C   ASP A  40      33.194  35.497  40.471  1.00  0.00           C  
ATOM    529  O   ASP A  40      34.144  34.922  41.002  1.00  0.00           O  
ATOM    530  CB  ASP A  40      30.977  34.717  41.249  1.00  0.00           C  
ATOM    531  CG  ASP A  40      29.493  34.684  40.874  1.00  0.00           C  
ATOM    532  OD1 ASP A  40      29.178  34.015  39.868  1.00  0.00           O  
ATOM    533  OD2 ASP A  40      28.709  35.328  41.604  1.00  0.00           O  
ATOM    534  H   ASP A  40      32.646  32.793  40.457  1.00  0.00           H  
ATOM    535  HA  ASP A  40      31.465  35.127  39.175  1.00  0.00           H  
ATOM    536  HB2 ASP A  40      31.196  33.855  41.879  1.00  0.00           H  
ATOM    537  HB3 ASP A  40      31.165  35.607  41.850  1.00  0.00           H  
ATOM    538  N   SER A  41      33.153  36.795  40.208  1.00  0.00           N  
ATOM    539  CA  SER A  41      34.271  37.661  40.541  1.00  0.00           C  
ATOM    540  C   SER A  41      34.328  37.884  42.053  1.00  0.00           C  
ATOM    541  O   SER A  41      33.633  38.749  42.584  1.00  0.00           O  
ATOM    542  CB  SER A  41      34.166  39.002  39.810  1.00  0.00           C  
ATOM    543  OG  SER A  41      34.946  39.023  38.618  1.00  0.00           O  
ATOM    544  H   SER A  41      32.377  37.254  39.776  1.00  0.00           H  
ATOM    545  HA  SER A  41      35.160  37.130  40.198  1.00  0.00           H  
ATOM    546  HB2 SER A  41      33.123  39.199  39.564  1.00  0.00           H  
ATOM    547  HB3 SER A  41      34.494  39.802  40.473  1.00  0.00           H  
ATOM    548  HG  SER A  41      35.125  39.967  38.343  1.00  0.00           H  
ATOM    549  N   LEU A  42      35.163  37.088  42.705  1.00  0.00           N  
ATOM    550  CA  LEU A  42      35.320  37.188  44.147  1.00  0.00           C  
ATOM    551  C   LEU A  42      36.105  38.458  44.483  1.00  0.00           C  
ATOM    552  O   LEU A  42      35.561  39.388  45.077  1.00  0.00           O  
ATOM    553  CB  LEU A  42      35.949  35.910  44.707  1.00  0.00           C  
ATOM    554  CG  LEU A  42      35.139  34.625  44.517  1.00  0.00           C  
ATOM    555  CD1 LEU A  42      35.951  33.399  44.938  1.00  0.00           C  
ATOM    556  CD2 LEU A  42      33.800  34.708  45.253  1.00  0.00           C  
ATOM    557  H   LEU A  42      35.725  36.388  42.266  1.00  0.00           H  
ATOM    558  HA  LEU A  42      34.323  37.273  44.579  1.00  0.00           H  
ATOM    559  HB2 LEU A  42      36.924  35.774  44.239  1.00  0.00           H  
ATOM    560  HB3 LEU A  42      36.124  36.052  45.773  1.00  0.00           H  
ATOM    561  HG  LEU A  42      34.917  34.515  43.455  1.00  0.00           H  
ATOM    562 HD11 LEU A  42      36.450  33.601  45.886  1.00  0.00           H  
ATOM    563 HD12 LEU A  42      35.284  32.545  45.055  1.00  0.00           H  
ATOM    564 HD13 LEU A  42      36.696  33.176  44.175  1.00  0.00           H  
ATOM    565 HD21 LEU A  42      33.272  35.611  44.947  1.00  0.00           H  
ATOM    566 HD22 LEU A  42      33.198  33.833  45.010  1.00  0.00           H  
ATOM    567 HD23 LEU A  42      33.979  34.739  46.328  1.00  0.00           H  
ATOM    568  N   MET A  43      37.369  38.456  44.089  1.00  0.00           N  
ATOM    569  CA  MET A  43      38.234  39.596  44.342  1.00  0.00           C  
ATOM    570  C   MET A  43      39.145  39.870  43.143  1.00  0.00           C  
ATOM    571  O   MET A  43      39.131  39.123  42.166  1.00  0.00           O  
ATOM    572  CB  MET A  43      39.089  39.324  45.580  1.00  0.00           C  
ATOM    573  CG  MET A  43      38.212  39.099  46.814  1.00  0.00           C  
ATOM    574  SD  MET A  43      38.424  37.433  47.419  1.00  0.00           S  
ATOM    575  CE  MET A  43      39.665  37.714  48.672  1.00  0.00           C  
ATOM    576  H   MET A  43      37.804  37.695  43.607  1.00  0.00           H  
ATOM    577  HA  MET A  43      37.565  40.442  44.500  1.00  0.00           H  
ATOM    578  HB2 MET A  43      39.715  38.447  45.410  1.00  0.00           H  
ATOM    579  HB3 MET A  43      39.761  40.164  45.756  1.00  0.00           H  
ATOM    580  HG2 MET A  43      38.476  39.815  47.593  1.00  0.00           H  
ATOM    581  HG3 MET A  43      37.166  39.273  46.563  1.00  0.00           H  
ATOM    582  HE1 MET A  43      40.601  37.251  48.365  1.00  0.00           H  
ATOM    583  HE2 MET A  43      39.814  38.786  48.801  1.00  0.00           H  
ATOM    584  HE3 MET A  43      39.334  37.277  49.615  1.00  0.00           H  
ATOM    585  N   VAL A  44      39.913  40.944  43.257  1.00  0.00           N  
ATOM    586  CA  VAL A  44      40.828  41.325  42.195  1.00  0.00           C  
ATOM    587  C   VAL A  44      42.242  41.447  42.766  1.00  0.00           C  
ATOM    588  O   VAL A  44      42.444  42.069  43.808  1.00  0.00           O  
ATOM    589  CB  VAL A  44      40.342  42.612  41.524  1.00  0.00           C  
ATOM    590  CG1 VAL A  44      41.342  43.092  40.471  1.00  0.00           C  
ATOM    591  CG2 VAL A  44      38.952  42.419  40.912  1.00  0.00           C  
ATOM    592  H   VAL A  44      39.917  41.546  44.056  1.00  0.00           H  
ATOM    593  HA  VAL A  44      40.817  40.530  41.450  1.00  0.00           H  
ATOM    594  HB  VAL A  44      40.266  43.383  42.290  1.00  0.00           H  
ATOM    595 HG11 VAL A  44      41.010  44.046  40.063  1.00  0.00           H  
ATOM    596 HG12 VAL A  44      42.323  43.216  40.931  1.00  0.00           H  
ATOM    597 HG13 VAL A  44      41.407  42.356  39.669  1.00  0.00           H  
ATOM    598 HG21 VAL A  44      39.039  42.354  39.827  1.00  0.00           H  
ATOM    599 HG22 VAL A  44      38.510  41.501  41.297  1.00  0.00           H  
ATOM    600 HG23 VAL A  44      38.318  43.265  41.176  1.00  0.00           H  
ATOM    601  N   MET A  45      43.185  40.844  42.057  1.00  0.00           N  
ATOM    602  CA  MET A  45      44.575  40.877  42.480  1.00  0.00           C  
ATOM    603  C   MET A  45      45.431  41.666  41.488  1.00  0.00           C  
ATOM    604  O   MET A  45      44.999  41.940  40.369  1.00  0.00           O  
ATOM    605  CB  MET A  45      45.109  39.446  42.590  1.00  0.00           C  
ATOM    606  CG  MET A  45      45.107  38.971  44.045  1.00  0.00           C  
ATOM    607  SD  MET A  45      45.860  37.357  44.161  1.00  0.00           S  
ATOM    608  CE  MET A  45      47.473  37.811  44.777  1.00  0.00           C  
ATOM    609  H   MET A  45      43.013  40.340  41.211  1.00  0.00           H  
ATOM    610  HA  MET A  45      44.574  41.375  43.449  1.00  0.00           H  
ATOM    611  HB2 MET A  45      44.497  38.778  41.984  1.00  0.00           H  
ATOM    612  HB3 MET A  45      46.122  39.401  42.190  1.00  0.00           H  
ATOM    613  HG2 MET A  45      45.652  39.680  44.669  1.00  0.00           H  
ATOM    614  HG3 MET A  45      44.086  38.933  44.421  1.00  0.00           H  
ATOM    615  HE1 MET A  45      47.372  38.239  45.773  1.00  0.00           H  
ATOM    616  HE2 MET A  45      48.105  36.924  44.825  1.00  0.00           H  
ATOM    617  HE3 MET A  45      47.924  38.543  44.109  1.00  0.00           H  
ATOM    618  N   ILE A  46      46.630  42.011  41.935  1.00  0.00           N  
ATOM    619  CA  ILE A  46      47.551  42.764  41.100  1.00  0.00           C  
ATOM    620  C   ILE A  46      48.960  42.187  41.253  1.00  0.00           C  
ATOM    621  O   ILE A  46      49.583  42.330  42.303  1.00  0.00           O  
ATOM    622  CB  ILE A  46      47.461  44.259  41.417  1.00  0.00           C  
ATOM    623  CG1 ILE A  46      46.031  44.773  41.233  1.00  0.00           C  
ATOM    624  CG2 ILE A  46      48.468  45.056  40.587  1.00  0.00           C  
ATOM    625  CD1 ILE A  46      45.701  44.955  39.751  1.00  0.00           C  
ATOM    626  H   ILE A  46      46.974  41.785  42.846  1.00  0.00           H  
ATOM    627  HA  ILE A  46      47.235  42.635  40.065  1.00  0.00           H  
ATOM    628  HB  ILE A  46      47.723  44.402  42.465  1.00  0.00           H  
ATOM    629 HG12 ILE A  46      45.329  44.072  41.682  1.00  0.00           H  
ATOM    630 HG13 ILE A  46      45.913  45.722  41.756  1.00  0.00           H  
ATOM    631 HG21 ILE A  46      49.480  44.727  40.827  1.00  0.00           H  
ATOM    632 HG22 ILE A  46      48.276  44.893  39.526  1.00  0.00           H  
ATOM    633 HG23 ILE A  46      48.368  46.118  40.814  1.00  0.00           H  
ATOM    634 HD11 ILE A  46      44.652  45.233  39.644  1.00  0.00           H  
ATOM    635 HD12 ILE A  46      46.330  45.742  39.333  1.00  0.00           H  
ATOM    636 HD13 ILE A  46      45.885  44.023  39.219  1.00  0.00           H  
ATOM    637  N   ALA A  47      49.421  41.545  40.189  1.00  0.00           N  
ATOM    638  CA  ALA A  47      50.744  40.946  40.191  1.00  0.00           C  
ATOM    639  C   ALA A  47      51.606  41.618  39.121  1.00  0.00           C  
ATOM    640  O   ALA A  47      52.426  42.481  39.431  1.00  0.00           O  
ATOM    641  CB  ALA A  47      50.621  39.436  39.976  1.00  0.00           C  
ATOM    642  H   ALA A  47      48.907  41.433  39.338  1.00  0.00           H  
ATOM    643  HA  ALA A  47      51.188  41.127  41.170  1.00  0.00           H  
ATOM    644  HB1 ALA A  47      51.074  39.167  39.022  1.00  0.00           H  
ATOM    645  HB2 ALA A  47      51.133  38.912  40.783  1.00  0.00           H  
ATOM    646  HB3 ALA A  47      49.567  39.155  39.971  1.00  0.00           H  
ATOM    647  N   MET A  48      51.390  41.198  37.883  1.00  0.00           N  
ATOM    648  CA  MET A  48      52.137  41.750  36.764  1.00  0.00           C  
ATOM    649  C   MET A  48      51.453  43.002  36.213  1.00  0.00           C  
ATOM    650  O   MET A  48      51.161  43.079  35.020  1.00  0.00           O  
ATOM    651  CB  MET A  48      52.250  40.699  35.658  1.00  0.00           C  
ATOM    652  CG  MET A  48      53.538  39.887  35.803  1.00  0.00           C  
ATOM    653  SD  MET A  48      54.748  40.444  34.615  1.00  0.00           S  
ATOM    654  CE  MET A  48      54.678  39.096  33.447  1.00  0.00           C  
ATOM    655  H   MET A  48      50.721  40.497  37.639  1.00  0.00           H  
ATOM    656  HA  MET A  48      53.117  42.010  37.167  1.00  0.00           H  
ATOM    657  HB2 MET A  48      51.388  40.032  35.696  1.00  0.00           H  
ATOM    658  HB3 MET A  48      52.231  41.187  34.685  1.00  0.00           H  
ATOM    659  HG2 MET A  48      53.932  39.992  36.813  1.00  0.00           H  
ATOM    660  HG3 MET A  48      53.328  38.827  35.652  1.00  0.00           H  
ATOM    661  HE1 MET A  48      53.646  38.761  33.339  1.00  0.00           H  
ATOM    662  HE2 MET A  48      55.053  39.433  32.480  1.00  0.00           H  
ATOM    663  HE3 MET A  48      55.293  38.270  33.806  1.00  0.00           H  
ATOM    664  N   LYS A  49      51.217  43.951  37.106  1.00  0.00           N  
ATOM    665  CA  LYS A  49      50.572  45.196  36.722  1.00  0.00           C  
ATOM    666  C   LYS A  49      49.304  44.884  35.926  1.00  0.00           C  
ATOM    667  O   LYS A  49      48.835  45.715  35.148  1.00  0.00           O  
ATOM    668  CB  LYS A  49      51.557  46.103  35.981  1.00  0.00           C  
ATOM    669  CG  LYS A  49      52.229  47.084  36.943  1.00  0.00           C  
ATOM    670  CD  LYS A  49      53.106  48.083  36.184  1.00  0.00           C  
ATOM    671  CE  LYS A  49      54.215  48.632  37.083  1.00  0.00           C  
ATOM    672  NZ  LYS A  49      53.977  50.062  37.384  1.00  0.00           N  
ATOM    673  H   LYS A  49      51.457  43.880  38.074  1.00  0.00           H  
ATOM    674  HA  LYS A  49      50.287  45.711  37.639  1.00  0.00           H  
ATOM    675  HB2 LYS A  49      52.314  45.496  35.486  1.00  0.00           H  
ATOM    676  HB3 LYS A  49      51.031  46.655  35.201  1.00  0.00           H  
ATOM    677  HG2 LYS A  49      51.470  47.620  37.512  1.00  0.00           H  
ATOM    678  HG3 LYS A  49      52.837  46.535  37.662  1.00  0.00           H  
ATOM    679  HD2 LYS A  49      53.546  47.597  35.313  1.00  0.00           H  
ATOM    680  HD3 LYS A  49      52.492  48.904  35.814  1.00  0.00           H  
ATOM    681  HE2 LYS A  49      54.257  48.061  38.010  1.00  0.00           H  
ATOM    682  HE3 LYS A  49      55.181  48.514  36.592  1.00  0.00           H  
ATOM    683  HZ1 LYS A  49      54.446  50.306  38.233  1.00  0.00           H  
ATOM    684  HZ2 LYS A  49      54.329  50.623  36.635  1.00  0.00           H  
ATOM    685  HZ3 LYS A  49      52.995  50.222  37.487  1.00  0.00           H  
ATOM    686  N   MET A  50      48.784  43.686  36.146  1.00  0.00           N  
ATOM    687  CA  MET A  50      47.579  43.254  35.458  1.00  0.00           C  
ATOM    688  C   MET A  50      46.493  42.850  36.457  1.00  0.00           C  
ATOM    689  O   MET A  50      46.795  42.385  37.555  1.00  0.00           O  
ATOM    690  CB  MET A  50      47.906  42.066  34.552  1.00  0.00           C  
ATOM    691  CG  MET A  50      46.644  41.269  34.216  1.00  0.00           C  
ATOM    692  SD  MET A  50      46.913  40.292  32.746  1.00  0.00           S  
ATOM    693  CE  MET A  50      48.246  39.247  33.309  1.00  0.00           C  
ATOM    694  H   MET A  50      49.172  43.016  36.779  1.00  0.00           H  
ATOM    695  HA  MET A  50      47.249  44.116  34.880  1.00  0.00           H  
ATOM    696  HB2 MET A  50      48.371  42.422  33.634  1.00  0.00           H  
ATOM    697  HB3 MET A  50      48.630  41.416  35.044  1.00  0.00           H  
ATOM    698  HG2 MET A  50      46.380  40.621  35.051  1.00  0.00           H  
ATOM    699  HG3 MET A  50      45.806  41.949  34.061  1.00  0.00           H  
ATOM    700  HE1 MET A  50      47.971  38.201  33.169  1.00  0.00           H  
ATOM    701  HE2 MET A  50      49.146  39.466  32.736  1.00  0.00           H  
ATOM    702  HE3 MET A  50      48.434  39.435  34.367  1.00  0.00           H  
ATOM    703  N   GLU A  51      45.250  43.044  36.041  1.00  0.00           N  
ATOM    704  CA  GLU A  51      44.117  42.706  36.886  1.00  0.00           C  
ATOM    705  C   GLU A  51      43.775  41.221  36.745  1.00  0.00           C  
ATOM    706  O   GLU A  51      43.389  40.769  35.668  1.00  0.00           O  
ATOM    707  CB  GLU A  51      42.906  43.581  36.555  1.00  0.00           C  
ATOM    708  CG  GLU A  51      43.288  45.062  36.543  1.00  0.00           C  
ATOM    709  CD  GLU A  51      43.522  45.557  35.114  1.00  0.00           C  
ATOM    710  OE1 GLU A  51      42.863  45.004  34.208  1.00  0.00           O  
ATOM    711  OE2 GLU A  51      44.355  46.477  34.961  1.00  0.00           O  
ATOM    712  H   GLU A  51      45.013  43.423  35.146  1.00  0.00           H  
ATOM    713  HA  GLU A  51      44.442  42.916  37.904  1.00  0.00           H  
ATOM    714  HB2 GLU A  51      42.502  43.298  35.583  1.00  0.00           H  
ATOM    715  HB3 GLU A  51      42.119  43.411  37.290  1.00  0.00           H  
ATOM    716  HG2 GLU A  51      42.497  45.650  37.010  1.00  0.00           H  
ATOM    717  HG3 GLU A  51      44.191  45.214  37.137  1.00  0.00           H  
ATOM    718  N   HIS A  52      43.927  40.504  37.849  1.00  0.00           N  
ATOM    719  CA  HIS A  52      43.639  39.080  37.862  1.00  0.00           C  
ATOM    720  C   HIS A  52      42.335  38.828  38.621  1.00  0.00           C  
ATOM    721  O   HIS A  52      42.321  38.819  39.851  1.00  0.00           O  
ATOM    722  CB  HIS A  52      44.820  38.292  38.433  1.00  0.00           C  
ATOM    723  CG  HIS A  52      46.160  38.953  38.219  1.00  0.00           C  
ATOM    724  ND1 HIS A  52      46.778  39.013  36.982  1.00  0.00           N  
ATOM    725  CD2 HIS A  52      46.994  39.583  39.097  1.00  0.00           C  
ATOM    726  CE1 HIS A  52      47.931  39.651  37.121  1.00  0.00           C  
ATOM    727  NE2 HIS A  52      48.063  40.003  38.432  1.00  0.00           N  
ATOM    728  H   HIS A  52      44.242  40.880  38.720  1.00  0.00           H  
ATOM    729  HA  HIS A  52      43.509  38.777  36.823  1.00  0.00           H  
ATOM    730  HB2 HIS A  52      44.664  38.147  39.501  1.00  0.00           H  
ATOM    731  HB3 HIS A  52      44.838  37.302  37.976  1.00  0.00           H  
ATOM    732  HD1 HIS A  52      46.417  38.639  36.129  1.00  0.00           H  
ATOM    733  HD2 HIS A  52      46.811  39.719  40.163  1.00  0.00           H  
ATOM    734  HE1 HIS A  52      48.648  39.859  36.327  1.00  0.00           H  
ATOM    735  N   THR A  53      41.271  38.628  37.857  1.00  0.00           N  
ATOM    736  CA  THR A  53      39.966  38.377  38.443  1.00  0.00           C  
ATOM    737  C   THR A  53      39.900  36.957  39.008  1.00  0.00           C  
ATOM    738  O   THR A  53      39.731  35.994  38.262  1.00  0.00           O  
ATOM    739  CB  THR A  53      38.907  38.655  37.373  1.00  0.00           C  
ATOM    740  OG1 THR A  53      39.148  40.005  36.988  1.00  0.00           O  
ATOM    741  CG2 THR A  53      37.488  38.678  37.947  1.00  0.00           C  
ATOM    742  H   THR A  53      41.292  38.638  36.858  1.00  0.00           H  
ATOM    743  HA  THR A  53      39.827  39.061  39.279  1.00  0.00           H  
ATOM    744  HB  THR A  53      38.984  37.939  36.555  1.00  0.00           H  
ATOM    745  HG1 THR A  53      39.116  40.087  35.992  1.00  0.00           H  
ATOM    746 HG21 THR A  53      37.019  37.707  37.795  1.00  0.00           H  
ATOM    747 HG22 THR A  53      37.532  38.897  39.014  1.00  0.00           H  
ATOM    748 HG23 THR A  53      36.905  39.448  37.441  1.00  0.00           H  
ATOM    749  N   ILE A  54      40.038  36.871  40.324  1.00  0.00           N  
ATOM    750  CA  ILE A  54      39.996  35.585  40.999  1.00  0.00           C  
ATOM    751  C   ILE A  54      38.565  35.044  40.969  1.00  0.00           C  
ATOM    752  O   ILE A  54      37.745  35.399  41.813  1.00  0.00           O  
ATOM    753  CB  ILE A  54      40.580  35.700  42.408  1.00  0.00           C  
ATOM    754  CG1 ILE A  54      42.107  35.599  42.378  1.00  0.00           C  
ATOM    755  CG2 ILE A  54      39.955  34.666  43.347  1.00  0.00           C  
ATOM    756  CD1 ILE A  54      42.741  36.958  42.078  1.00  0.00           C  
ATOM    757  H   ILE A  54      40.176  37.659  40.924  1.00  0.00           H  
ATOM    758  HA  ILE A  54      40.635  34.902  40.439  1.00  0.00           H  
ATOM    759  HB  ILE A  54      40.331  36.685  42.802  1.00  0.00           H  
ATOM    760 HG12 ILE A  54      42.469  35.229  43.338  1.00  0.00           H  
ATOM    761 HG13 ILE A  54      42.413  34.876  41.622  1.00  0.00           H  
ATOM    762 HG21 ILE A  54      40.678  34.389  44.113  1.00  0.00           H  
ATOM    763 HG22 ILE A  54      39.070  35.093  43.818  1.00  0.00           H  
ATOM    764 HG23 ILE A  54      39.673  33.782  42.777  1.00  0.00           H  
ATOM    765 HD11 ILE A  54      42.066  37.753  42.398  1.00  0.00           H  
ATOM    766 HD12 ILE A  54      43.686  37.045  42.615  1.00  0.00           H  
ATOM    767 HD13 ILE A  54      42.922  37.047  41.007  1.00  0.00           H  
ATOM    768  N   LYS A  55      38.309  34.194  39.985  1.00  0.00           N  
ATOM    769  CA  LYS A  55      36.991  33.600  39.834  1.00  0.00           C  
ATOM    770  C   LYS A  55      36.836  32.452  40.834  1.00  0.00           C  
ATOM    771  O   LYS A  55      37.802  31.754  41.137  1.00  0.00           O  
ATOM    772  CB  LYS A  55      36.754  33.186  38.380  1.00  0.00           C  
ATOM    773  CG  LYS A  55      36.462  34.407  37.504  1.00  0.00           C  
ATOM    774  CD  LYS A  55      35.053  34.332  36.912  1.00  0.00           C  
ATOM    775  CE  LYS A  55      34.652  35.667  36.283  1.00  0.00           C  
ATOM    776  NZ  LYS A  55      34.455  35.515  34.823  1.00  0.00           N  
ATOM    777  H   LYS A  55      38.981  33.909  39.302  1.00  0.00           H  
ATOM    778  HA  LYS A  55      36.257  34.369  40.075  1.00  0.00           H  
ATOM    779  HB2 LYS A  55      37.630  32.661  38.000  1.00  0.00           H  
ATOM    780  HB3 LYS A  55      35.917  32.489  38.329  1.00  0.00           H  
ATOM    781  HG2 LYS A  55      36.564  35.316  38.095  1.00  0.00           H  
ATOM    782  HG3 LYS A  55      37.195  34.464  36.700  1.00  0.00           H  
ATOM    783  HD2 LYS A  55      35.013  33.544  36.159  1.00  0.00           H  
ATOM    784  HD3 LYS A  55      34.340  34.064  37.692  1.00  0.00           H  
ATOM    785  HE2 LYS A  55      33.733  36.032  36.743  1.00  0.00           H  
ATOM    786  HE3 LYS A  55      35.422  36.414  36.476  1.00  0.00           H  
ATOM    787  HZ1 LYS A  55      34.398  34.543  34.595  1.00  0.00           H  
ATOM    788  HZ2 LYS A  55      33.609  35.973  34.551  1.00  0.00           H  
ATOM    789  HZ3 LYS A  55      35.227  35.925  34.338  1.00  0.00           H  
ATOM    790  N   SER A  56      35.612  32.291  41.317  1.00  0.00           N  
ATOM    791  CA  SER A  56      35.317  31.240  42.275  1.00  0.00           C  
ATOM    792  C   SER A  56      35.385  29.875  41.590  1.00  0.00           C  
ATOM    793  O   SER A  56      34.931  29.720  40.457  1.00  0.00           O  
ATOM    794  CB  SER A  56      33.943  31.447  42.914  1.00  0.00           C  
ATOM    795  OG  SER A  56      33.908  30.990  44.263  1.00  0.00           O  
ATOM    796  H   SER A  56      34.832  32.864  41.063  1.00  0.00           H  
ATOM    797  HA  SER A  56      36.090  31.324  43.040  1.00  0.00           H  
ATOM    798  HB2 SER A  56      33.684  32.506  42.882  1.00  0.00           H  
ATOM    799  HB3 SER A  56      33.189  30.917  42.332  1.00  0.00           H  
ATOM    800  HG  SER A  56      33.023  30.566  44.457  1.00  0.00           H  
ATOM    801  N   PRO A  57      35.969  28.891  42.325  1.00  0.00           N  
ATOM    802  CA  PRO A  57      36.102  27.542  41.801  1.00  0.00           C  
ATOM    803  C   PRO A  57      34.759  26.810  41.826  1.00  0.00           C  
ATOM    804  O   PRO A  57      34.497  25.955  40.981  1.00  0.00           O  
ATOM    805  CB  PRO A  57      37.155  26.881  42.675  1.00  0.00           C  
ATOM    806  CG  PRO A  57      37.235  27.723  43.939  1.00  0.00           C  
ATOM    807  CD  PRO A  57      36.518  29.036  43.671  1.00  0.00           C  
ATOM    808  HA  PRO A  57      36.380  27.569  40.841  1.00  0.00           H  
ATOM    809  HB2 PRO A  57      36.880  25.852  42.908  1.00  0.00           H  
ATOM    810  HB3 PRO A  57      38.119  26.846  42.167  1.00  0.00           H  
ATOM    811  HG2 PRO A  57      36.773  27.199  44.776  1.00  0.00           H  
ATOM    812  HG3 PRO A  57      38.275  27.904  44.211  1.00  0.00           H  
ATOM    813  HD2 PRO A  57      35.730  29.213  44.402  1.00  0.00           H  
ATOM    814  HD3 PRO A  57      37.204  29.881  43.729  1.00  0.00           H  
ATOM    815  N   LYS A  58      33.941  27.172  42.804  1.00  0.00           N  
ATOM    816  CA  LYS A  58      32.632  26.559  42.951  1.00  0.00           C  
ATOM    817  C   LYS A  58      31.696  27.534  43.668  1.00  0.00           C  
ATOM    818  O   LYS A  58      32.078  28.665  43.962  1.00  0.00           O  
ATOM    819  CB  LYS A  58      32.750  25.199  43.641  1.00  0.00           C  
ATOM    820  CG  LYS A  58      33.560  24.220  42.788  1.00  0.00           C  
ATOM    821  CD  LYS A  58      33.488  22.804  43.362  1.00  0.00           C  
ATOM    822  CE  LYS A  58      32.713  21.873  42.427  1.00  0.00           C  
ATOM    823  NZ  LYS A  58      31.339  21.657  42.933  1.00  0.00           N  
ATOM    824  H   LYS A  58      34.162  27.867  43.488  1.00  0.00           H  
ATOM    825  HA  LYS A  58      32.242  26.380  41.949  1.00  0.00           H  
ATOM    826  HB2 LYS A  58      33.228  25.320  44.613  1.00  0.00           H  
ATOM    827  HB3 LYS A  58      31.756  24.792  43.823  1.00  0.00           H  
ATOM    828  HG2 LYS A  58      33.180  24.222  41.766  1.00  0.00           H  
ATOM    829  HG3 LYS A  58      34.600  24.546  42.743  1.00  0.00           H  
ATOM    830  HD2 LYS A  58      34.495  22.417  43.513  1.00  0.00           H  
ATOM    831  HD3 LYS A  58      33.006  22.828  44.339  1.00  0.00           H  
ATOM    832  HE2 LYS A  58      32.675  22.302  41.426  1.00  0.00           H  
ATOM    833  HE3 LYS A  58      33.230  20.917  42.345  1.00  0.00           H  
ATOM    834  HZ1 LYS A  58      30.964  22.524  43.261  1.00  0.00           H  
ATOM    835  HZ2 LYS A  58      30.763  21.305  42.195  1.00  0.00           H  
ATOM    836  HZ3 LYS A  58      31.360  20.997  43.685  1.00  0.00           H  
ATOM    837  N   ASP A  59      30.488  27.059  43.930  1.00  0.00           N  
ATOM    838  CA  ASP A  59      29.493  27.874  44.607  1.00  0.00           C  
ATOM    839  C   ASP A  59      29.463  27.504  46.092  1.00  0.00           C  
ATOM    840  O   ASP A  59      29.808  26.383  46.463  1.00  0.00           O  
ATOM    841  CB  ASP A  59      28.097  27.633  44.031  1.00  0.00           C  
ATOM    842  CG  ASP A  59      27.849  26.216  43.510  1.00  0.00           C  
ATOM    843  OD1 ASP A  59      28.014  25.277  44.319  1.00  0.00           O  
ATOM    844  OD2 ASP A  59      27.499  26.104  42.316  1.00  0.00           O  
ATOM    845  H   ASP A  59      30.184  26.137  43.688  1.00  0.00           H  
ATOM    846  HA  ASP A  59      29.806  28.905  44.441  1.00  0.00           H  
ATOM    847  HB2 ASP A  59      27.359  27.855  44.802  1.00  0.00           H  
ATOM    848  HB3 ASP A  59      27.929  28.337  43.217  1.00  0.00           H  
ATOM    849  N   GLY A  60      29.046  28.468  46.901  1.00  0.00           N  
ATOM    850  CA  GLY A  60      28.966  28.257  48.336  1.00  0.00           C  
ATOM    851  C   GLY A  60      28.825  29.587  49.078  1.00  0.00           C  
ATOM    852  O   GLY A  60      28.938  30.653  48.475  1.00  0.00           O  
ATOM    853  H   GLY A  60      28.767  29.376  46.590  1.00  0.00           H  
ATOM    854  HA2 GLY A  60      28.115  27.616  48.567  1.00  0.00           H  
ATOM    855  HA3 GLY A  60      29.859  27.736  48.681  1.00  0.00           H  
ATOM    856  N   THR A  61      28.582  29.481  50.377  1.00  0.00           N  
ATOM    857  CA  THR A  61      28.424  30.663  51.207  1.00  0.00           C  
ATOM    858  C   THR A  61      29.762  31.052  51.840  1.00  0.00           C  
ATOM    859  O   THR A  61      30.239  30.380  52.754  1.00  0.00           O  
ATOM    860  CB  THR A  61      27.327  30.377  52.234  1.00  0.00           C  
ATOM    861  OG1 THR A  61      26.159  30.172  51.445  1.00  0.00           O  
ATOM    862  CG2 THR A  61      26.990  31.601  53.088  1.00  0.00           C  
ATOM    863  H   THR A  61      28.492  28.611  50.859  1.00  0.00           H  
ATOM    864  HA  THR A  61      28.119  31.493  50.570  1.00  0.00           H  
ATOM    865  HB  THR A  61      27.593  29.526  52.861  1.00  0.00           H  
ATOM    866  HG1 THR A  61      26.307  29.422  50.801  1.00  0.00           H  
ATOM    867 HG21 THR A  61      27.909  32.020  53.500  1.00  0.00           H  
ATOM    868 HG22 THR A  61      26.494  32.349  52.470  1.00  0.00           H  
ATOM    869 HG23 THR A  61      26.329  31.304  53.902  1.00  0.00           H  
ATOM    870  N   VAL A  62      30.330  32.135  51.329  1.00  0.00           N  
ATOM    871  CA  VAL A  62      31.603  32.620  51.833  1.00  0.00           C  
ATOM    872  C   VAL A  62      31.590  32.580  53.362  1.00  0.00           C  
ATOM    873  O   VAL A  62      30.774  33.244  53.998  1.00  0.00           O  
ATOM    874  CB  VAL A  62      31.889  34.016  51.274  1.00  0.00           C  
ATOM    875  CG1 VAL A  62      33.094  34.649  51.971  1.00  0.00           C  
ATOM    876  CG2 VAL A  62      32.093  33.968  49.758  1.00  0.00           C  
ATOM    877  H   VAL A  62      29.935  32.675  50.586  1.00  0.00           H  
ATOM    878  HA  VAL A  62      32.379  31.946  51.470  1.00  0.00           H  
ATOM    879  HB  VAL A  62      31.020  34.642  51.474  1.00  0.00           H  
ATOM    880 HG11 VAL A  62      32.867  34.800  53.026  1.00  0.00           H  
ATOM    881 HG12 VAL A  62      33.957  33.989  51.876  1.00  0.00           H  
ATOM    882 HG13 VAL A  62      33.319  35.610  51.506  1.00  0.00           H  
ATOM    883 HG21 VAL A  62      31.473  34.728  49.284  1.00  0.00           H  
ATOM    884 HG22 VAL A  62      33.142  34.158  49.528  1.00  0.00           H  
ATOM    885 HG23 VAL A  62      31.812  32.983  49.385  1.00  0.00           H  
ATOM    886  N   LYS A  63      32.506  31.794  53.909  1.00  0.00           N  
ATOM    887  CA  LYS A  63      32.610  31.658  55.352  1.00  0.00           C  
ATOM    888  C   LYS A  63      33.274  32.909  55.931  1.00  0.00           C  
ATOM    889  O   LYS A  63      32.738  33.533  56.845  1.00  0.00           O  
ATOM    890  CB  LYS A  63      33.328  30.357  55.717  1.00  0.00           C  
ATOM    891  CG  LYS A  63      33.288  30.113  57.227  1.00  0.00           C  
ATOM    892  CD  LYS A  63      33.557  28.643  57.554  1.00  0.00           C  
ATOM    893  CE  LYS A  63      33.726  28.438  59.060  1.00  0.00           C  
ATOM    894  NZ  LYS A  63      33.101  27.166  59.483  1.00  0.00           N  
ATOM    895  H   LYS A  63      33.167  31.257  53.385  1.00  0.00           H  
ATOM    896  HA  LYS A  63      31.597  31.590  55.748  1.00  0.00           H  
ATOM    897  HB2 LYS A  63      32.860  29.520  55.198  1.00  0.00           H  
ATOM    898  HB3 LYS A  63      34.364  30.401  55.379  1.00  0.00           H  
ATOM    899  HG2 LYS A  63      34.031  30.741  57.719  1.00  0.00           H  
ATOM    900  HG3 LYS A  63      32.314  30.404  57.620  1.00  0.00           H  
ATOM    901  HD2 LYS A  63      32.733  28.030  57.189  1.00  0.00           H  
ATOM    902  HD3 LYS A  63      34.456  28.311  57.033  1.00  0.00           H  
ATOM    903  HE2 LYS A  63      34.787  28.432  59.314  1.00  0.00           H  
ATOM    904  HE3 LYS A  63      33.274  29.270  59.599  1.00  0.00           H  
ATOM    905  HZ1 LYS A  63      33.671  26.729  60.179  1.00  0.00           H  
ATOM    906  HZ2 LYS A  63      32.195  27.350  59.863  1.00  0.00           H  
ATOM    907  HZ3 LYS A  63      33.015  26.557  58.694  1.00  0.00           H  
ATOM    908  N   LYS A  64      34.431  33.238  55.374  1.00  0.00           N  
ATOM    909  CA  LYS A  64      35.173  34.403  55.824  1.00  0.00           C  
ATOM    910  C   LYS A  64      36.328  34.672  54.857  1.00  0.00           C  
ATOM    911  O   LYS A  64      36.903  33.739  54.297  1.00  0.00           O  
ATOM    912  CB  LYS A  64      35.617  34.228  57.278  1.00  0.00           C  
ATOM    913  CG  LYS A  64      36.048  35.565  57.885  1.00  0.00           C  
ATOM    914  CD  LYS A  64      37.327  35.406  58.708  1.00  0.00           C  
ATOM    915  CE  LYS A  64      37.063  35.675  60.191  1.00  0.00           C  
ATOM    916  NZ  LYS A  64      37.702  34.635  61.028  1.00  0.00           N  
ATOM    917  H   LYS A  64      34.860  32.724  54.631  1.00  0.00           H  
ATOM    918  HA  LYS A  64      34.493  35.255  55.795  1.00  0.00           H  
ATOM    919  HB2 LYS A  64      34.800  33.805  57.864  1.00  0.00           H  
ATOM    920  HB3 LYS A  64      36.443  33.518  57.327  1.00  0.00           H  
ATOM    921  HG2 LYS A  64      36.211  36.293  57.090  1.00  0.00           H  
ATOM    922  HG3 LYS A  64      35.251  35.955  58.517  1.00  0.00           H  
ATOM    923  HD2 LYS A  64      37.722  34.397  58.582  1.00  0.00           H  
ATOM    924  HD3 LYS A  64      38.089  36.093  58.341  1.00  0.00           H  
ATOM    925  HE2 LYS A  64      37.448  36.657  60.463  1.00  0.00           H  
ATOM    926  HE3 LYS A  64      35.988  35.691  60.377  1.00  0.00           H  
ATOM    927  HZ1 LYS A  64      37.759  33.780  60.513  1.00  0.00           H  
ATOM    928  HZ2 LYS A  64      38.622  34.932  61.284  1.00  0.00           H  
ATOM    929  HZ3 LYS A  64      37.157  34.492  61.855  1.00  0.00           H  
ATOM    930  N   VAL A  65      36.633  35.950  54.690  1.00  0.00           N  
ATOM    931  CA  VAL A  65      37.708  36.352  53.800  1.00  0.00           C  
ATOM    932  C   VAL A  65      38.949  36.691  54.628  1.00  0.00           C  
ATOM    933  O   VAL A  65      38.852  37.365  55.652  1.00  0.00           O  
ATOM    934  CB  VAL A  65      37.248  37.511  52.912  1.00  0.00           C  
ATOM    935  CG1 VAL A  65      38.111  37.614  51.653  1.00  0.00           C  
ATOM    936  CG2 VAL A  65      35.767  37.371  52.552  1.00  0.00           C  
ATOM    937  H   VAL A  65      36.160  36.702  55.148  1.00  0.00           H  
ATOM    938  HA  VAL A  65      37.938  35.504  53.155  1.00  0.00           H  
ATOM    939  HB  VAL A  65      37.369  38.434  53.478  1.00  0.00           H  
ATOM    940 HG11 VAL A  65      38.753  38.493  51.724  1.00  0.00           H  
ATOM    941 HG12 VAL A  65      38.728  36.720  51.562  1.00  0.00           H  
ATOM    942 HG13 VAL A  65      37.468  37.702  50.778  1.00  0.00           H  
ATOM    943 HG21 VAL A  65      35.520  36.315  52.438  1.00  0.00           H  
ATOM    944 HG22 VAL A  65      35.158  37.803  53.346  1.00  0.00           H  
ATOM    945 HG23 VAL A  65      35.570  37.894  51.617  1.00  0.00           H  
ATOM    946  N   PHE A  66      40.088  36.206  54.154  1.00  0.00           N  
ATOM    947  CA  PHE A  66      41.347  36.449  54.837  1.00  0.00           C  
ATOM    948  C   PHE A  66      42.198  37.466  54.075  1.00  0.00           C  
ATOM    949  O   PHE A  66      43.422  37.474  54.198  1.00  0.00           O  
ATOM    950  CB  PHE A  66      42.093  35.114  54.888  1.00  0.00           C  
ATOM    951  CG  PHE A  66      41.290  33.976  55.522  1.00  0.00           C  
ATOM    952  CD1 PHE A  66      40.367  33.303  54.785  1.00  0.00           C  
ATOM    953  CD2 PHE A  66      41.501  33.639  56.823  1.00  0.00           C  
ATOM    954  CE1 PHE A  66      39.622  32.247  55.375  1.00  0.00           C  
ATOM    955  CE2 PHE A  66      40.757  32.583  57.412  1.00  0.00           C  
ATOM    956  CZ  PHE A  66      39.833  31.909  56.675  1.00  0.00           C  
ATOM    957  H   PHE A  66      40.159  35.659  53.320  1.00  0.00           H  
ATOM    958  HA  PHE A  66      41.108  36.845  55.825  1.00  0.00           H  
ATOM    959  HB2 PHE A  66      42.372  34.827  53.874  1.00  0.00           H  
ATOM    960  HB3 PHE A  66      43.019  35.248  55.447  1.00  0.00           H  
ATOM    961  HD1 PHE A  66      40.199  33.573  53.743  1.00  0.00           H  
ATOM    962  HD2 PHE A  66      42.242  34.179  57.413  1.00  0.00           H  
ATOM    963  HE1 PHE A  66      38.883  31.706  54.784  1.00  0.00           H  
ATOM    964  HE2 PHE A  66      40.925  32.312  58.454  1.00  0.00           H  
ATOM    965  HZ  PHE A  66      39.262  31.098  57.127  1.00  0.00           H  
ATOM    966  N   TYR A  67      41.516  38.302  53.305  1.00  0.00           N  
ATOM    967  CA  TYR A  67      42.194  39.321  52.523  1.00  0.00           C  
ATOM    968  C   TYR A  67      41.243  40.470  52.177  1.00  0.00           C  
ATOM    969  O   TYR A  67      40.040  40.261  52.028  1.00  0.00           O  
ATOM    970  CB  TYR A  67      42.638  38.635  51.229  1.00  0.00           C  
ATOM    971  CG  TYR A  67      43.964  37.883  51.348  1.00  0.00           C  
ATOM    972  CD1 TYR A  67      43.986  36.601  51.861  1.00  0.00           C  
ATOM    973  CD2 TYR A  67      45.138  38.483  50.940  1.00  0.00           C  
ATOM    974  CE1 TYR A  67      45.235  35.892  51.973  1.00  0.00           C  
ATOM    975  CE2 TYR A  67      46.385  37.774  51.052  1.00  0.00           C  
ATOM    976  CZ  TYR A  67      46.373  36.514  51.563  1.00  0.00           C  
ATOM    977  OH  TYR A  67      47.552  35.843  51.668  1.00  0.00           O  
ATOM    978  H   TYR A  67      40.521  38.289  53.212  1.00  0.00           H  
ATOM    979  HA  TYR A  67      43.019  39.710  53.119  1.00  0.00           H  
ATOM    980  HB2 TYR A  67      41.861  37.937  50.915  1.00  0.00           H  
ATOM    981  HB3 TYR A  67      42.727  39.386  50.444  1.00  0.00           H  
ATOM    982  HD1 TYR A  67      43.059  36.127  52.183  1.00  0.00           H  
ATOM    983  HD2 TYR A  67      45.119  39.494  50.534  1.00  0.00           H  
ATOM    984  HE1 TYR A  67      45.267  34.880  52.377  1.00  0.00           H  
ATOM    985  HE2 TYR A  67      47.320  38.236  50.734  1.00  0.00           H  
ATOM    986  HH  TYR A  67      47.797  35.732  52.631  1.00  0.00           H  
ATOM    987  N   ARG A  68      41.819  41.657  52.060  1.00  0.00           N  
ATOM    988  CA  ARG A  68      41.038  42.838  51.734  1.00  0.00           C  
ATOM    989  C   ARG A  68      41.809  43.732  50.760  1.00  0.00           C  
ATOM    990  O   ARG A  68      42.895  43.373  50.310  1.00  0.00           O  
ATOM    991  CB  ARG A  68      40.701  43.639  52.993  1.00  0.00           C  
ATOM    992  CG  ARG A  68      39.673  42.902  53.853  1.00  0.00           C  
ATOM    993  CD  ARG A  68      38.758  43.888  54.582  1.00  0.00           C  
ATOM    994  NE  ARG A  68      37.344  43.487  54.413  1.00  0.00           N  
ATOM    995  CZ  ARG A  68      36.654  43.629  53.273  1.00  0.00           C  
ATOM    996  NH1 ARG A  68      37.243  44.163  52.195  1.00  0.00           N  
ATOM    997  NH2 ARG A  68      35.374  43.236  53.212  1.00  0.00           N  
ATOM    998  H   ARG A  68      42.798  41.819  52.182  1.00  0.00           H  
ATOM    999  HA  ARG A  68      40.127  42.453  51.276  1.00  0.00           H  
ATOM   1000  HB2 ARG A  68      41.608  43.812  53.572  1.00  0.00           H  
ATOM   1001  HB3 ARG A  68      40.310  44.618  52.713  1.00  0.00           H  
ATOM   1002  HG2 ARG A  68      39.074  42.242  53.225  1.00  0.00           H  
ATOM   1003  HG3 ARG A  68      40.186  42.271  54.579  1.00  0.00           H  
ATOM   1004  HD2 ARG A  68      39.012  43.918  55.642  1.00  0.00           H  
ATOM   1005  HD3 ARG A  68      38.909  44.894  54.190  1.00  0.00           H  
ATOM   1006  HE  ARG A  68      36.873  43.086  55.199  1.00  0.00           H  
ATOM   1007 HH11 ARG A  68      38.199  44.455  52.241  1.00  0.00           H  
ATOM   1008 HH12 ARG A  68      36.728  44.269  51.345  1.00  0.00           H  
ATOM   1009 HH21 ARG A  68      34.933  42.838  54.016  1.00  0.00           H  
ATOM   1010 HH22 ARG A  68      34.859  43.342  52.361  1.00  0.00           H  
ATOM   1011  N   GLU A  69      41.215  44.879  50.464  1.00  0.00           N  
ATOM   1012  CA  GLU A  69      41.831  45.827  49.552  1.00  0.00           C  
ATOM   1013  C   GLU A  69      43.213  46.236  50.065  1.00  0.00           C  
ATOM   1014  O   GLU A  69      43.360  46.618  51.226  1.00  0.00           O  
ATOM   1015  CB  GLU A  69      40.938  47.052  49.347  1.00  0.00           C  
ATOM   1016  CG  GLU A  69      39.534  46.638  48.902  1.00  0.00           C  
ATOM   1017  CD  GLU A  69      38.476  47.582  49.478  1.00  0.00           C  
ATOM   1018  OE1 GLU A  69      38.823  48.765  49.683  1.00  0.00           O  
ATOM   1019  OE2 GLU A  69      37.344  47.099  49.699  1.00  0.00           O  
ATOM   1020  H   GLU A  69      40.330  45.163  50.834  1.00  0.00           H  
ATOM   1021  HA  GLU A  69      41.932  45.295  48.605  1.00  0.00           H  
ATOM   1022  HB2 GLU A  69      40.877  47.621  50.274  1.00  0.00           H  
ATOM   1023  HB3 GLU A  69      41.381  47.709  48.598  1.00  0.00           H  
ATOM   1024  HG2 GLU A  69      39.477  46.642  47.814  1.00  0.00           H  
ATOM   1025  HG3 GLU A  69      39.331  45.617  49.228  1.00  0.00           H  
ATOM   1026  N   GLY A  70      44.192  46.142  49.178  1.00  0.00           N  
ATOM   1027  CA  GLY A  70      45.557  46.498  49.527  1.00  0.00           C  
ATOM   1028  C   GLY A  70      46.211  45.400  50.369  1.00  0.00           C  
ATOM   1029  O   GLY A  70      47.045  45.685  51.227  1.00  0.00           O  
ATOM   1030  H   GLY A  70      44.064  45.830  48.236  1.00  0.00           H  
ATOM   1031  HA2 GLY A  70      46.138  46.659  48.619  1.00  0.00           H  
ATOM   1032  HA3 GLY A  70      45.561  47.437  50.080  1.00  0.00           H  
ATOM   1033  N   ALA A  71      45.808  44.169  50.094  1.00  0.00           N  
ATOM   1034  CA  ALA A  71      46.344  43.027  50.815  1.00  0.00           C  
ATOM   1035  C   ALA A  71      47.414  42.346  49.959  1.00  0.00           C  
ATOM   1036  O   ALA A  71      47.369  42.414  48.732  1.00  0.00           O  
ATOM   1037  CB  ALA A  71      45.204  42.077  51.190  1.00  0.00           C  
ATOM   1038  H   ALA A  71      45.130  43.945  49.394  1.00  0.00           H  
ATOM   1039  HA  ALA A  71      46.805  43.399  51.730  1.00  0.00           H  
ATOM   1040  HB1 ALA A  71      44.588  41.886  50.311  1.00  0.00           H  
ATOM   1041  HB2 ALA A  71      45.620  41.138  51.554  1.00  0.00           H  
ATOM   1042  HB3 ALA A  71      44.595  42.532  51.970  1.00  0.00           H  
ATOM   1043  N   GLN A  72      48.350  41.702  50.641  1.00  0.00           N  
ATOM   1044  CA  GLN A  72      49.430  41.008  49.959  1.00  0.00           C  
ATOM   1045  C   GLN A  72      49.268  39.495  50.110  1.00  0.00           C  
ATOM   1046  O   GLN A  72      49.338  38.967  51.219  1.00  0.00           O  
ATOM   1047  CB  GLN A  72      50.793  41.468  50.479  1.00  0.00           C  
ATOM   1048  CG  GLN A  72      51.891  40.475  50.094  1.00  0.00           C  
ATOM   1049  CD  GLN A  72      53.219  41.193  49.845  1.00  0.00           C  
ATOM   1050  OE1 GLN A  72      53.835  41.741  50.745  1.00  0.00           O  
ATOM   1051  NE2 GLN A  72      53.623  41.162  48.579  1.00  0.00           N  
ATOM   1052  H   GLN A  72      48.380  41.651  51.640  1.00  0.00           H  
ATOM   1053  HA  GLN A  72      49.335  41.287  48.909  1.00  0.00           H  
ATOM   1054  HB2 GLN A  72      51.028  42.451  50.072  1.00  0.00           H  
ATOM   1055  HB3 GLN A  72      50.756  41.572  51.563  1.00  0.00           H  
ATOM   1056  HG2 GLN A  72      52.014  39.738  50.887  1.00  0.00           H  
ATOM   1057  HG3 GLN A  72      51.594  39.930  49.197  1.00  0.00           H  
ATOM   1058 HE21 GLN A  72      53.069  40.694  47.889  1.00  0.00           H  
ATOM   1059 HE22 GLN A  72      54.480  41.604  48.316  1.00  0.00           H  
ATOM   1060  N   ALA A  73      49.053  38.838  48.979  1.00  0.00           N  
ATOM   1061  CA  ALA A  73      48.879  37.396  48.973  1.00  0.00           C  
ATOM   1062  C   ALA A  73      50.126  36.740  48.376  1.00  0.00           C  
ATOM   1063  O   ALA A  73      50.936  37.407  47.734  1.00  0.00           O  
ATOM   1064  CB  ALA A  73      47.606  37.037  48.203  1.00  0.00           C  
ATOM   1065  H   ALA A  73      48.996  39.275  48.082  1.00  0.00           H  
ATOM   1066  HA  ALA A  73      48.767  37.070  50.007  1.00  0.00           H  
ATOM   1067  HB1 ALA A  73      46.926  37.888  48.211  1.00  0.00           H  
ATOM   1068  HB2 ALA A  73      47.862  36.788  47.173  1.00  0.00           H  
ATOM   1069  HB3 ALA A  73      47.125  36.182  48.675  1.00  0.00           H  
ATOM   1070  N   ASN A  74      50.241  35.440  48.608  1.00  0.00           N  
ATOM   1071  CA  ASN A  74      51.375  34.687  48.101  1.00  0.00           C  
ATOM   1072  C   ASN A  74      50.876  33.618  47.126  1.00  0.00           C  
ATOM   1073  O   ASN A  74      49.678  33.356  47.046  1.00  0.00           O  
ATOM   1074  CB  ASN A  74      52.119  33.980  49.236  1.00  0.00           C  
ATOM   1075  CG  ASN A  74      53.630  34.179  49.108  1.00  0.00           C  
ATOM   1076  OD1 ASN A  74      54.166  35.245  49.367  1.00  0.00           O  
ATOM   1077  ND2 ASN A  74      54.285  33.098  48.696  1.00  0.00           N  
ATOM   1078  H   ASN A  74      49.577  34.905  49.130  1.00  0.00           H  
ATOM   1079  HA  ASN A  74      52.017  35.424  47.619  1.00  0.00           H  
ATOM   1080  HB2 ASN A  74      51.778  34.368  50.196  1.00  0.00           H  
ATOM   1081  HB3 ASN A  74      51.886  32.916  49.222  1.00  0.00           H  
ATOM   1082 HD21 ASN A  74      53.785  32.254  48.501  1.00  0.00           H  
ATOM   1083 HD22 ASN A  74      55.278  33.128  48.581  1.00  0.00           H  
ATOM   1084  N   ARG A  75      51.823  33.030  46.408  1.00  0.00           N  
ATOM   1085  CA  ARG A  75      51.495  31.996  45.442  1.00  0.00           C  
ATOM   1086  C   ARG A  75      50.920  30.769  46.152  1.00  0.00           C  
ATOM   1087  O   ARG A  75      51.597  30.143  46.966  1.00  0.00           O  
ATOM   1088  CB  ARG A  75      52.730  31.580  44.640  1.00  0.00           C  
ATOM   1089  CG  ARG A  75      52.336  30.741  43.422  1.00  0.00           C  
ATOM   1090  CD  ARG A  75      53.049  31.238  42.162  1.00  0.00           C  
ATOM   1091  NE  ARG A  75      53.754  30.115  41.505  1.00  0.00           N  
ATOM   1092  CZ  ARG A  75      54.850  29.524  41.999  1.00  0.00           C  
ATOM   1093  NH1 ARG A  75      55.372  29.945  43.160  1.00  0.00           N  
ATOM   1094  NH2 ARG A  75      55.424  28.512  41.334  1.00  0.00           N  
ATOM   1095  H   ARG A  75      52.796  33.249  46.479  1.00  0.00           H  
ATOM   1096  HA  ARG A  75      50.754  32.452  44.786  1.00  0.00           H  
ATOM   1097  HB2 ARG A  75      53.273  32.467  44.315  1.00  0.00           H  
ATOM   1098  HB3 ARG A  75      53.405  31.008  45.276  1.00  0.00           H  
ATOM   1099  HG2 ARG A  75      52.588  29.696  43.599  1.00  0.00           H  
ATOM   1100  HG3 ARG A  75      51.257  30.789  43.277  1.00  0.00           H  
ATOM   1101  HD2 ARG A  75      52.324  31.676  41.474  1.00  0.00           H  
ATOM   1102  HD3 ARG A  75      53.759  32.023  42.421  1.00  0.00           H  
ATOM   1103  HE  ARG A  75      53.391  29.777  40.636  1.00  0.00           H  
ATOM   1104 HH11 ARG A  75      54.943  30.700  43.656  1.00  0.00           H  
ATOM   1105 HH12 ARG A  75      56.189  29.504  43.529  1.00  0.00           H  
ATOM   1106 HH21 ARG A  75      55.035  28.199  40.468  1.00  0.00           H  
ATOM   1107 HH22 ARG A  75      56.242  28.071  41.703  1.00  0.00           H  
ATOM   1108  N   HIS A  76      49.675  30.461  45.818  1.00  0.00           N  
ATOM   1109  CA  HIS A  76      49.000  29.320  46.413  1.00  0.00           C  
ATOM   1110  C   HIS A  76      48.664  29.627  47.874  1.00  0.00           C  
ATOM   1111  O   HIS A  76      49.180  28.979  48.783  1.00  0.00           O  
ATOM   1112  CB  HIS A  76      49.837  28.049  46.252  1.00  0.00           C  
ATOM   1113  CG  HIS A  76      50.265  27.772  44.830  1.00  0.00           C  
ATOM   1114  ND1 HIS A  76      51.003  26.657  44.474  1.00  0.00           N  
ATOM   1115  CD2 HIS A  76      50.048  28.474  43.682  1.00  0.00           C  
ATOM   1116  CE1 HIS A  76      51.217  26.698  43.167  1.00  0.00           C  
ATOM   1117  NE2 HIS A  76      50.625  27.824  42.678  1.00  0.00           N  
ATOM   1118  H   HIS A  76      49.130  30.975  45.155  1.00  0.00           H  
ATOM   1119  HA  HIS A  76      48.073  29.180  45.858  1.00  0.00           H  
ATOM   1120  HB2 HIS A  76      50.726  28.130  46.879  1.00  0.00           H  
ATOM   1121  HB3 HIS A  76      49.263  27.200  46.621  1.00  0.00           H  
ATOM   1122  HD1 HIS A  76      51.322  25.943  45.097  1.00  0.00           H  
ATOM   1123  HD2 HIS A  76      49.496  29.410  43.602  1.00  0.00           H  
ATOM   1124  HE1 HIS A  76      51.770  25.960  42.585  1.00  0.00           H  
ATOM   1125  N   THR A  77      47.803  30.617  48.054  1.00  0.00           N  
ATOM   1126  CA  THR A  77      47.391  31.018  49.389  1.00  0.00           C  
ATOM   1127  C   THR A  77      45.867  31.112  49.472  1.00  0.00           C  
ATOM   1128  O   THR A  77      45.199  31.342  48.464  1.00  0.00           O  
ATOM   1129  CB  THR A  77      48.101  32.331  49.728  1.00  0.00           C  
ATOM   1130  OG1 THR A  77      47.855  33.160  48.594  1.00  0.00           O  
ATOM   1131  CG2 THR A  77      49.623  32.183  49.758  1.00  0.00           C  
ATOM   1132  H   THR A  77      47.388  31.140  47.309  1.00  0.00           H  
ATOM   1133  HA  THR A  77      47.704  30.245  50.091  1.00  0.00           H  
ATOM   1134  HB  THR A  77      47.730  32.742  50.666  1.00  0.00           H  
ATOM   1135  HG1 THR A  77      47.413  34.009  48.881  1.00  0.00           H  
ATOM   1136 HG21 THR A  77      49.988  31.973  48.753  1.00  0.00           H  
ATOM   1137 HG22 THR A  77      50.071  33.109  50.121  1.00  0.00           H  
ATOM   1138 HG23 THR A  77      49.895  31.363  50.423  1.00  0.00           H  
ATOM   1139  N   PRO A  78      45.346  30.924  50.714  1.00  0.00           N  
ATOM   1140  CA  PRO A  78      43.913  30.985  50.942  1.00  0.00           C  
ATOM   1141  C   PRO A  78      43.414  32.432  50.914  1.00  0.00           C  
ATOM   1142  O   PRO A  78      43.894  33.272  51.673  1.00  0.00           O  
ATOM   1143  CB  PRO A  78      43.698  30.309  52.287  1.00  0.00           C  
ATOM   1144  CG  PRO A  78      45.054  30.311  52.974  1.00  0.00           C  
ATOM   1145  CD  PRO A  78      46.106  30.650  51.931  1.00  0.00           C  
ATOM   1146  HA  PRO A  78      43.424  30.514  50.208  1.00  0.00           H  
ATOM   1147  HB2 PRO A  78      42.959  30.846  52.880  1.00  0.00           H  
ATOM   1148  HB3 PRO A  78      43.326  29.293  52.158  1.00  0.00           H  
ATOM   1149  HG2 PRO A  78      45.071  31.040  53.784  1.00  0.00           H  
ATOM   1150  HG3 PRO A  78      45.258  29.336  53.418  1.00  0.00           H  
ATOM   1151  HD2 PRO A  78      46.698  31.514  52.230  1.00  0.00           H  
ATOM   1152  HD3 PRO A  78      46.800  29.823  51.785  1.00  0.00           H  
ATOM   1153  N   LEU A  79      42.457  32.677  50.031  1.00  0.00           N  
ATOM   1154  CA  LEU A  79      41.888  34.006  49.894  1.00  0.00           C  
ATOM   1155  C   LEU A  79      40.544  34.060  50.623  1.00  0.00           C  
ATOM   1156  O   LEU A  79      40.287  34.982  51.395  1.00  0.00           O  
ATOM   1157  CB  LEU A  79      41.805  34.405  48.419  1.00  0.00           C  
ATOM   1158  CG  LEU A  79      43.131  34.436  47.657  1.00  0.00           C  
ATOM   1159  CD1 LEU A  79      42.893  34.475  46.146  1.00  0.00           C  
ATOM   1160  CD2 LEU A  79      44.008  35.596  48.130  1.00  0.00           C  
ATOM   1161  H   LEU A  79      42.072  31.987  49.418  1.00  0.00           H  
ATOM   1162  HA  LEU A  79      42.571  34.706  50.378  1.00  0.00           H  
ATOM   1163  HB2 LEU A  79      41.134  33.710  47.914  1.00  0.00           H  
ATOM   1164  HB3 LEU A  79      41.348  35.392  48.355  1.00  0.00           H  
ATOM   1165  HG  LEU A  79      43.671  33.514  47.875  1.00  0.00           H  
ATOM   1166 HD11 LEU A  79      42.557  35.471  45.857  1.00  0.00           H  
ATOM   1167 HD12 LEU A  79      43.822  34.239  45.626  1.00  0.00           H  
ATOM   1168 HD13 LEU A  79      42.132  33.743  45.879  1.00  0.00           H  
ATOM   1169 HD21 LEU A  79      43.505  36.126  48.938  1.00  0.00           H  
ATOM   1170 HD22 LEU A  79      44.962  35.208  48.488  1.00  0.00           H  
ATOM   1171 HD23 LEU A  79      44.184  36.281  47.300  1.00  0.00           H  
ATOM   1172  N   VAL A  80      39.720  33.058  50.351  1.00  0.00           N  
ATOM   1173  CA  VAL A  80      38.408  32.978  50.971  1.00  0.00           C  
ATOM   1174  C   VAL A  80      38.121  31.527  51.360  1.00  0.00           C  
ATOM   1175  O   VAL A  80      38.640  30.599  50.741  1.00  0.00           O  
ATOM   1176  CB  VAL A  80      37.351  33.567  50.034  1.00  0.00           C  
ATOM   1177  CG1 VAL A  80      37.255  35.084  50.202  1.00  0.00           C  
ATOM   1178  CG2 VAL A  80      37.638  33.192  48.579  1.00  0.00           C  
ATOM   1179  H   VAL A  80      39.936  32.311  49.722  1.00  0.00           H  
ATOM   1180  HA  VAL A  80      38.435  33.585  51.876  1.00  0.00           H  
ATOM   1181  HB  VAL A  80      36.386  33.139  50.307  1.00  0.00           H  
ATOM   1182 HG11 VAL A  80      38.159  35.551  49.811  1.00  0.00           H  
ATOM   1183 HG12 VAL A  80      36.389  35.456  49.654  1.00  0.00           H  
ATOM   1184 HG13 VAL A  80      37.149  35.328  51.259  1.00  0.00           H  
ATOM   1185 HG21 VAL A  80      37.468  32.125  48.439  1.00  0.00           H  
ATOM   1186 HG22 VAL A  80      36.974  33.756  47.922  1.00  0.00           H  
ATOM   1187 HG23 VAL A  80      38.674  33.432  48.340  1.00  0.00           H  
ATOM   1188  N   GLU A  81      37.293  31.376  52.384  1.00  0.00           N  
ATOM   1189  CA  GLU A  81      36.930  30.053  52.864  1.00  0.00           C  
ATOM   1190  C   GLU A  81      35.424  29.830  52.717  1.00  0.00           C  
ATOM   1191  O   GLU A  81      34.626  30.676  53.116  1.00  0.00           O  
ATOM   1192  CB  GLU A  81      37.375  29.854  54.314  1.00  0.00           C  
ATOM   1193  CG  GLU A  81      36.769  28.579  54.903  1.00  0.00           C  
ATOM   1194  CD  GLU A  81      37.843  27.722  55.577  1.00  0.00           C  
ATOM   1195  OE1 GLU A  81      38.942  27.625  54.989  1.00  0.00           O  
ATOM   1196  OE2 GLU A  81      37.541  27.184  56.664  1.00  0.00           O  
ATOM   1197  H   GLU A  81      36.875  32.135  52.883  1.00  0.00           H  
ATOM   1198  HA  GLU A  81      37.472  29.354  52.225  1.00  0.00           H  
ATOM   1199  HB2 GLU A  81      38.463  29.800  54.361  1.00  0.00           H  
ATOM   1200  HB3 GLU A  81      37.073  30.715  54.912  1.00  0.00           H  
ATOM   1201  HG2 GLU A  81      35.999  28.840  55.629  1.00  0.00           H  
ATOM   1202  HG3 GLU A  81      36.282  28.005  54.115  1.00  0.00           H  
ATOM   1203  N   PHE A  82      35.080  28.687  52.141  1.00  0.00           N  
ATOM   1204  CA  PHE A  82      33.684  28.342  51.935  1.00  0.00           C  
ATOM   1205  C   PHE A  82      33.091  27.692  53.187  1.00  0.00           C  
ATOM   1206  O   PHE A  82      33.811  27.084  53.976  1.00  0.00           O  
ATOM   1207  CB  PHE A  82      33.636  27.338  50.782  1.00  0.00           C  
ATOM   1208  CG  PHE A  82      33.813  27.971  49.400  1.00  0.00           C  
ATOM   1209  CD1 PHE A  82      32.918  28.892  48.954  1.00  0.00           C  
ATOM   1210  CD2 PHE A  82      34.865  27.610  48.617  1.00  0.00           C  
ATOM   1211  CE1 PHE A  82      33.081  29.478  47.671  1.00  0.00           C  
ATOM   1212  CE2 PHE A  82      35.029  28.196  47.334  1.00  0.00           C  
ATOM   1213  CZ  PHE A  82      34.133  29.118  46.888  1.00  0.00           C  
ATOM   1214  H   PHE A  82      35.736  28.005  51.818  1.00  0.00           H  
ATOM   1215  HA  PHE A  82      33.150  29.268  51.722  1.00  0.00           H  
ATOM   1216  HB2 PHE A  82      34.415  26.591  50.931  1.00  0.00           H  
ATOM   1217  HB3 PHE A  82      32.681  26.814  50.811  1.00  0.00           H  
ATOM   1218  HD1 PHE A  82      32.074  29.181  49.581  1.00  0.00           H  
ATOM   1219  HD2 PHE A  82      35.582  26.871  48.975  1.00  0.00           H  
ATOM   1220  HE1 PHE A  82      32.365  30.217  47.313  1.00  0.00           H  
ATOM   1221  HE2 PHE A  82      35.873  27.908  46.707  1.00  0.00           H  
ATOM   1222  HZ  PHE A  82      34.260  29.568  45.903  1.00  0.00           H  
ATOM   1223  N   GLU A  83      31.781  27.843  53.329  1.00  0.00           N  
ATOM   1224  CA  GLU A  83      31.082  27.278  54.471  1.00  0.00           C  
ATOM   1225  C   GLU A  83      31.000  25.756  54.342  1.00  0.00           C  
ATOM   1226  O   GLU A  83      31.035  25.220  53.236  1.00  0.00           O  
ATOM   1227  CB  GLU A  83      29.689  27.893  54.619  1.00  0.00           C  
ATOM   1228  CG  GLU A  83      29.765  29.270  55.280  1.00  0.00           C  
ATOM   1229  CD  GLU A  83      29.519  29.170  56.787  1.00  0.00           C  
ATOM   1230  OE1 GLU A  83      28.329  29.138  57.167  1.00  0.00           O  
ATOM   1231  OE2 GLU A  83      30.527  29.127  57.525  1.00  0.00           O  
ATOM   1232  H   GLU A  83      31.203  28.340  52.682  1.00  0.00           H  
ATOM   1233  HA  GLU A  83      31.685  27.544  55.339  1.00  0.00           H  
ATOM   1234  HB2 GLU A  83      29.220  27.980  53.640  1.00  0.00           H  
ATOM   1235  HB3 GLU A  83      29.059  27.233  55.216  1.00  0.00           H  
ATOM   1236  HG2 GLU A  83      30.745  29.712  55.097  1.00  0.00           H  
ATOM   1237  HG3 GLU A  83      29.027  29.934  54.831  1.00  0.00           H  
ATOM   1238  N   GLU A  84      30.891  25.102  55.489  1.00  0.00           N  
ATOM   1239  CA  GLU A  84      30.802  23.652  55.519  1.00  0.00           C  
ATOM   1240  C   GLU A  84      29.789  23.160  54.483  1.00  0.00           C  
ATOM   1241  O   GLU A  84      28.651  23.627  54.452  1.00  0.00           O  
ATOM   1242  CB  GLU A  84      30.441  23.154  56.919  1.00  0.00           C  
ATOM   1243  CG  GLU A  84      31.563  22.291  57.501  1.00  0.00           C  
ATOM   1244  CD  GLU A  84      31.306  21.979  58.977  1.00  0.00           C  
ATOM   1245  OE1 GLU A  84      31.719  22.811  59.813  1.00  0.00           O  
ATOM   1246  OE2 GLU A  84      30.702  20.915  59.236  1.00  0.00           O  
ATOM   1247  H   GLU A  84      30.863  25.546  56.385  1.00  0.00           H  
ATOM   1248  HA  GLU A  84      31.799  23.296  55.259  1.00  0.00           H  
ATOM   1249  HB2 GLU A  84      30.254  24.004  57.575  1.00  0.00           H  
ATOM   1250  HB3 GLU A  84      29.518  22.575  56.877  1.00  0.00           H  
ATOM   1251  HG2 GLU A  84      31.642  21.362  56.938  1.00  0.00           H  
ATOM   1252  HG3 GLU A  84      32.516  22.809  57.396  1.00  0.00           H  
ATOM   1253  N   GLU A  85      30.238  22.224  53.661  1.00  0.00           N  
ATOM   1254  CA  GLU A  85      29.385  21.665  52.626  1.00  0.00           C  
ATOM   1255  C   GLU A  85      28.361  20.708  53.243  1.00  0.00           C  
ATOM   1256  O   GLU A  85      28.701  19.905  54.110  1.00  0.00           O  
ATOM   1257  CB  GLU A  85      30.216  20.961  51.551  1.00  0.00           C  
ATOM   1258  CG  GLU A  85      30.881  21.976  50.621  1.00  0.00           C  
ATOM   1259  CD  GLU A  85      32.339  21.599  50.352  1.00  0.00           C  
ATOM   1260  OE1 GLU A  85      33.093  21.500  51.344  1.00  0.00           O  
ATOM   1261  OE2 GLU A  85      32.669  21.419  49.160  1.00  0.00           O  
ATOM   1262  H   GLU A  85      31.165  21.849  53.693  1.00  0.00           H  
ATOM   1263  HA  GLU A  85      28.873  22.517  52.180  1.00  0.00           H  
ATOM   1264  HB2 GLU A  85      30.978  20.341  52.024  1.00  0.00           H  
ATOM   1265  HB3 GLU A  85      29.577  20.295  50.971  1.00  0.00           H  
ATOM   1266  HG2 GLU A  85      30.334  22.024  49.680  1.00  0.00           H  
ATOM   1267  HG3 GLU A  85      30.835  22.969  51.067  1.00  0.00           H  
ATOM   1268  N   GLU A  86      27.129  20.826  52.770  1.00  0.00           N  
ATOM   1269  CA  GLU A  86      26.055  19.983  53.264  1.00  0.00           C  
ATOM   1270  C   GLU A  86      25.281  19.368  52.095  1.00  0.00           C  
ATOM   1271  O   GLU A  86      25.180  19.973  51.028  1.00  0.00           O  
ATOM   1272  CB  GLU A  86      25.121  20.768  54.187  1.00  0.00           C  
ATOM   1273  CG  GLU A  86      25.225  20.267  55.629  1.00  0.00           C  
ATOM   1274  CD  GLU A  86      24.183  20.943  56.521  1.00  0.00           C  
ATOM   1275  OE1 GLU A  86      22.987  20.850  56.168  1.00  0.00           O  
ATOM   1276  OE2 GLU A  86      24.605  21.538  57.537  1.00  0.00           O  
ATOM   1277  H   GLU A  86      26.861  21.483  52.066  1.00  0.00           H  
ATOM   1278  HA  GLU A  86      26.545  19.196  53.838  1.00  0.00           H  
ATOM   1279  HB2 GLU A  86      25.371  21.828  54.147  1.00  0.00           H  
ATOM   1280  HB3 GLU A  86      24.092  20.670  53.838  1.00  0.00           H  
ATOM   1281  HG2 GLU A  86      25.084  19.187  55.654  1.00  0.00           H  
ATOM   1282  HG3 GLU A  86      26.225  20.467  56.015  1.00  0.00           H  
ATOM   1283  N   SER A  87      24.757  18.175  52.335  1.00  0.00           N  
ATOM   1284  CA  SER A  87      23.997  17.473  51.315  1.00  0.00           C  
ATOM   1285  C   SER A  87      24.783  17.446  50.003  1.00  0.00           C  
ATOM   1286  O   SER A  87      24.644  18.343  49.173  1.00  0.00           O  
ATOM   1287  CB  SER A  87      22.630  18.125  51.102  1.00  0.00           C  
ATOM   1288  OG  SER A  87      21.570  17.322  51.615  1.00  0.00           O  
ATOM   1289  H   SER A  87      24.845  17.691  53.205  1.00  0.00           H  
ATOM   1290  HA  SER A  87      23.862  16.463  51.701  1.00  0.00           H  
ATOM   1291  HB2 SER A  87      22.613  19.101  51.588  1.00  0.00           H  
ATOM   1292  HB3 SER A  87      22.472  18.297  50.037  1.00  0.00           H  
ATOM   1293  HG  SER A  87      21.482  17.463  52.601  1.00  0.00           H  
ATOM   1294  N   ASP A  88      25.592  16.407  49.856  1.00  0.00           N  
ATOM   1295  CA  ASP A  88      26.399  16.251  48.659  1.00  0.00           C  
ATOM   1296  C   ASP A  88      27.270  14.999  48.795  1.00  0.00           C  
ATOM   1297  O   ASP A  88      28.332  15.043  49.413  1.00  0.00           O  
ATOM   1298  CB  ASP A  88      27.326  17.452  48.459  1.00  0.00           C  
ATOM   1299  CG  ASP A  88      27.490  17.908  47.008  1.00  0.00           C  
ATOM   1300  OD1 ASP A  88      26.941  17.211  46.128  1.00  0.00           O  
ATOM   1301  OD2 ASP A  88      28.161  18.945  46.811  1.00  0.00           O  
ATOM   1302  H   ASP A  88      25.699  15.681  50.535  1.00  0.00           H  
ATOM   1303  HA  ASP A  88      25.685  16.174  47.839  1.00  0.00           H  
ATOM   1304  HB2 ASP A  88      26.945  18.287  49.046  1.00  0.00           H  
ATOM   1305  HB3 ASP A  88      28.310  17.203  48.859  1.00  0.00           H  
ATOM   1306  N   LYS A  89      26.786  13.915  48.208  1.00  0.00           N  
ATOM   1307  CA  LYS A  89      27.507  12.653  48.257  1.00  0.00           C  
ATOM   1308  C   LYS A  89      28.096  12.355  46.877  1.00  0.00           C  
ATOM   1309  O   LYS A  89      27.360  12.171  45.910  1.00  0.00           O  
ATOM   1310  CB  LYS A  89      26.604  11.541  48.793  1.00  0.00           C  
ATOM   1311  CG  LYS A  89      27.255  10.832  49.983  1.00  0.00           C  
ATOM   1312  CD  LYS A  89      26.663   9.435  50.179  1.00  0.00           C  
ATOM   1313  CE  LYS A  89      27.649   8.354  49.731  1.00  0.00           C  
ATOM   1314  NZ  LYS A  89      27.088   7.577  48.603  1.00  0.00           N  
ATOM   1315  H   LYS A  89      25.921  13.889  47.708  1.00  0.00           H  
ATOM   1316  HA  LYS A  89      28.326  12.773  48.965  1.00  0.00           H  
ATOM   1317  HB2 LYS A  89      25.644  11.960  49.097  1.00  0.00           H  
ATOM   1318  HB3 LYS A  89      26.400  10.819  48.002  1.00  0.00           H  
ATOM   1319  HG2 LYS A  89      28.330  10.757  49.822  1.00  0.00           H  
ATOM   1320  HG3 LYS A  89      27.109  11.423  50.887  1.00  0.00           H  
ATOM   1321  HD2 LYS A  89      26.411   9.287  51.230  1.00  0.00           H  
ATOM   1322  HD3 LYS A  89      25.737   9.345  49.613  1.00  0.00           H  
ATOM   1323  HE2 LYS A  89      28.590   8.814  49.429  1.00  0.00           H  
ATOM   1324  HE3 LYS A  89      27.872   7.688  50.564  1.00  0.00           H  
ATOM   1325  HZ1 LYS A  89      26.115   7.786  48.507  1.00  0.00           H  
ATOM   1326  HZ2 LYS A  89      27.565   7.821  47.759  1.00  0.00           H  
ATOM   1327  HZ3 LYS A  89      27.203   6.600  48.782  1.00  0.00           H  
ATOM   1328  N   ARG A  90      29.420  12.316  46.830  1.00  0.00           N  
ATOM   1329  CA  ARG A  90      30.117  12.042  45.586  1.00  0.00           C  
ATOM   1330  C   ARG A  90      29.812  10.622  45.107  1.00  0.00           C  
ATOM   1331  O   ARG A  90      29.306   9.801  45.871  1.00  0.00           O  
ATOM   1332  CB  ARG A  90      31.630  12.203  45.755  1.00  0.00           C  
ATOM   1333  CG  ARG A  90      32.215  13.082  44.648  1.00  0.00           C  
ATOM   1334  CD  ARG A  90      33.519  12.490  44.110  1.00  0.00           C  
ATOM   1335  NE  ARG A  90      34.655  13.379  44.446  1.00  0.00           N  
ATOM   1336  CZ  ARG A  90      35.288  13.374  45.626  1.00  0.00           C  
ATOM   1337  NH1 ARG A  90      34.900  12.528  46.591  1.00  0.00           N  
ATOM   1338  NH2 ARG A  90      36.308  14.214  45.843  1.00  0.00           N  
ATOM   1339  H   ARG A  90      30.012  12.467  47.622  1.00  0.00           H  
ATOM   1340  HA  ARG A  90      29.735  12.784  44.883  1.00  0.00           H  
ATOM   1341  HB2 ARG A  90      31.845  12.643  46.727  1.00  0.00           H  
ATOM   1342  HB3 ARG A  90      32.107  11.223  45.736  1.00  0.00           H  
ATOM   1343  HG2 ARG A  90      31.494  13.181  43.837  1.00  0.00           H  
ATOM   1344  HG3 ARG A  90      32.399  14.084  45.035  1.00  0.00           H  
ATOM   1345  HD2 ARG A  90      33.682  11.500  44.535  1.00  0.00           H  
ATOM   1346  HD3 ARG A  90      33.452  12.365  43.029  1.00  0.00           H  
ATOM   1347  HE  ARG A  90      34.969  14.022  43.748  1.00  0.00           H  
ATOM   1348 HH11 ARG A  90      34.139  11.901  46.430  1.00  0.00           H  
ATOM   1349 HH12 ARG A  90      35.373  12.525  47.473  1.00  0.00           H  
ATOM   1350 HH21 ARG A  90      36.597  14.846  45.123  1.00  0.00           H  
ATOM   1351 HH22 ARG A  90      36.781  14.211  46.724  1.00  0.00           H  
ATOM   1352  N   GLU A  91      30.131  10.375  43.845  1.00  0.00           N  
ATOM   1353  CA  GLU A  91      29.897   9.068  43.255  1.00  0.00           C  
ATOM   1354  C   GLU A  91      31.222   8.324  43.071  1.00  0.00           C  
ATOM   1355  O   GLU A  91      32.285   8.941  43.040  1.00  0.00           O  
ATOM   1356  CB  GLU A  91      29.148   9.191  41.927  1.00  0.00           C  
ATOM   1357  CG  GLU A  91      27.959   8.232  41.877  1.00  0.00           C  
ATOM   1358  CD  GLU A  91      27.566   7.920  40.432  1.00  0.00           C  
ATOM   1359  OE1 GLU A  91      28.361   7.225  39.765  1.00  0.00           O  
ATOM   1360  OE2 GLU A  91      26.477   8.383  40.027  1.00  0.00           O  
ATOM   1361  H   GLU A  91      30.542  11.048  43.230  1.00  0.00           H  
ATOM   1362  HA  GLU A  91      29.271   8.536  43.971  1.00  0.00           H  
ATOM   1363  HB2 GLU A  91      28.799  10.215  41.796  1.00  0.00           H  
ATOM   1364  HB3 GLU A  91      29.827   8.978  41.101  1.00  0.00           H  
ATOM   1365  HG2 GLU A  91      28.211   7.307  42.396  1.00  0.00           H  
ATOM   1366  HG3 GLU A  91      27.110   8.671  42.402  1.00  0.00           H  
ATOM   1367  N   SER A  92      31.114   7.009  42.954  1.00  0.00           N  
ATOM   1368  CA  SER A  92      32.290   6.175  42.773  1.00  0.00           C  
ATOM   1369  C   SER A  92      31.888   4.829  42.167  1.00  0.00           C  
ATOM   1370  O   SER A  92      30.711   4.470  42.167  1.00  0.00           O  
ATOM   1371  CB  SER A  92      33.023   5.962  44.098  1.00  0.00           C  
ATOM   1372  OG  SER A  92      34.068   6.912  44.289  1.00  0.00           O  
ATOM   1373  H   SER A  92      30.245   6.514  42.980  1.00  0.00           H  
ATOM   1374  HA  SER A  92      32.933   6.727  42.087  1.00  0.00           H  
ATOM   1375  HB2 SER A  92      32.312   6.035  44.921  1.00  0.00           H  
ATOM   1376  HB3 SER A  92      33.439   4.955  44.126  1.00  0.00           H  
ATOM   1377  HG  SER A  92      34.346   7.295  43.408  1.00  0.00           H  
ATOM   1378  N   GLU A  93      32.888   4.120  41.663  1.00  0.00           N  
ATOM   1379  CA  GLU A  93      32.654   2.821  41.055  1.00  0.00           C  
ATOM   1380  C   GLU A  93      33.879   1.923  41.235  1.00  0.00           C  
ATOM   1381  O   GLU A  93      35.014   2.387  41.135  1.00  0.00           O  
ATOM   1382  CB  GLU A  93      32.292   2.966  39.576  1.00  0.00           C  
ATOM   1383  CG  GLU A  93      31.622   1.696  39.049  1.00  0.00           C  
ATOM   1384  CD  GLU A  93      30.627   2.022  37.933  1.00  0.00           C  
ATOM   1385  OE1 GLU A  93      30.908   2.986  37.188  1.00  0.00           O  
ATOM   1386  OE2 GLU A  93      29.610   1.302  37.851  1.00  0.00           O  
ATOM   1387  H   GLU A  93      33.843   4.419  41.667  1.00  0.00           H  
ATOM   1388  HA  GLU A  93      31.804   2.400  41.592  1.00  0.00           H  
ATOM   1389  HB2 GLU A  93      31.623   3.816  39.443  1.00  0.00           H  
ATOM   1390  HB3 GLU A  93      33.191   3.174  38.996  1.00  0.00           H  
ATOM   1391  HG2 GLU A  93      32.380   1.008  38.675  1.00  0.00           H  
ATOM   1392  HG3 GLU A  93      31.106   1.188  39.863  1.00  0.00           H  
ATOM   1393  N   SER A  94      33.608   0.653  41.497  1.00  0.00           N  
ATOM   1394  CA  SER A  94      34.674  -0.315  41.691  1.00  0.00           C  
ATOM   1395  C   SER A  94      34.425  -1.550  40.822  1.00  0.00           C  
ATOM   1396  O   SER A  94      33.313  -1.760  40.341  1.00  0.00           O  
ATOM   1397  CB  SER A  94      34.793  -0.717  43.163  1.00  0.00           C  
ATOM   1398  OG  SER A  94      33.723  -1.566  43.571  1.00  0.00           O  
ATOM   1399  H   SER A  94      32.682   0.283  41.577  1.00  0.00           H  
ATOM   1400  HA  SER A  94      35.587   0.193  41.379  1.00  0.00           H  
ATOM   1401  HB2 SER A  94      35.743  -1.226  43.324  1.00  0.00           H  
ATOM   1402  HB3 SER A  94      34.802   0.179  43.783  1.00  0.00           H  
ATOM   1403  HG  SER A  94      33.941  -2.518  43.356  1.00  0.00           H  
ATOM   1404  N   GLY A  95      35.478  -2.335  40.649  1.00  0.00           N  
ATOM   1405  CA  GLY A  95      35.387  -3.543  39.846  1.00  0.00           C  
ATOM   1406  C   GLY A  95      36.380  -4.600  40.333  1.00  0.00           C  
ATOM   1407  O   GLY A  95      37.286  -4.297  41.110  1.00  0.00           O  
ATOM   1408  H   GLY A  95      36.379  -2.156  41.044  1.00  0.00           H  
ATOM   1409  HA2 GLY A  95      34.373  -3.940  39.895  1.00  0.00           H  
ATOM   1410  HA3 GLY A  95      35.588  -3.305  38.801  1.00  0.00           H  
ATOM   1411  N   PRO A  96      36.171  -5.852  39.845  1.00  0.00           N  
ATOM   1412  CA  PRO A  96      37.038  -6.957  40.222  1.00  0.00           C  
ATOM   1413  C   PRO A  96      38.386  -6.865  39.507  1.00  0.00           C  
ATOM   1414  O   PRO A  96      38.483  -6.280  38.429  1.00  0.00           O  
ATOM   1415  CB  PRO A  96      36.256  -8.210  39.861  1.00  0.00           C  
ATOM   1416  CG  PRO A  96      35.189  -7.766  38.874  1.00  0.00           C  
ATOM   1417  CD  PRO A  96      35.110  -6.249  38.925  1.00  0.00           C  
ATOM   1418  HA  PRO A  96      37.243  -6.917  41.201  1.00  0.00           H  
ATOM   1419  HB2 PRO A  96      36.910  -8.962  39.418  1.00  0.00           H  
ATOM   1420  HB3 PRO A  96      35.808  -8.659  40.746  1.00  0.00           H  
ATOM   1421  HG2 PRO A  96      35.437  -8.102  37.867  1.00  0.00           H  
ATOM   1422  HG3 PRO A  96      34.226  -8.207  39.129  1.00  0.00           H  
ATOM   1423  HD2 PRO A  96      35.258  -5.811  37.938  1.00  0.00           H  
ATOM   1424  HD3 PRO A  96      34.134  -5.915  39.278  1.00  0.00           H  
ATOM   1425  N   SER A  97      39.394  -7.452  40.135  1.00  0.00           N  
ATOM   1426  CA  SER A  97      40.734  -7.443  39.572  1.00  0.00           C  
ATOM   1427  C   SER A  97      41.226  -8.878  39.369  1.00  0.00           C  
ATOM   1428  O   SER A  97      40.819  -9.785  40.093  1.00  0.00           O  
ATOM   1429  CB  SER A  97      41.704  -6.672  40.469  1.00  0.00           C  
ATOM   1430  OG  SER A  97      41.922  -7.332  41.712  1.00  0.00           O  
ATOM   1431  H   SER A  97      39.308  -7.925  41.012  1.00  0.00           H  
ATOM   1432  HA  SER A  97      40.641  -6.932  38.613  1.00  0.00           H  
ATOM   1433  HB2 SER A  97      42.655  -6.548  39.952  1.00  0.00           H  
ATOM   1434  HB3 SER A  97      41.310  -5.672  40.653  1.00  0.00           H  
ATOM   1435  HG  SER A  97      41.544  -8.258  41.679  1.00  0.00           H  
ATOM   1436  N   SER A  98      42.093  -9.038  38.382  1.00  0.00           N  
ATOM   1437  CA  SER A  98      42.644 -10.347  38.074  1.00  0.00           C  
ATOM   1438  C   SER A  98      43.774 -10.682  39.052  1.00  0.00           C  
ATOM   1439  O   SER A  98      43.712 -11.688  39.757  1.00  0.00           O  
ATOM   1440  CB  SER A  98      43.155 -10.407  36.634  1.00  0.00           C  
ATOM   1441  OG  SER A  98      42.466 -11.387  35.863  1.00  0.00           O  
ATOM   1442  H   SER A  98      42.419  -8.296  37.797  1.00  0.00           H  
ATOM   1443  HA  SER A  98      41.816 -11.045  38.195  1.00  0.00           H  
ATOM   1444  HB2 SER A  98      43.036  -9.429  36.166  1.00  0.00           H  
ATOM   1445  HB3 SER A  98      44.222 -10.631  36.636  1.00  0.00           H  
ATOM   1446  HG  SER A  98      42.852 -12.293  36.038  1.00  0.00           H  
ATOM   1447  N   GLY A  99      44.778  -9.819  39.063  1.00  0.00           N  
ATOM   1448  CA  GLY A  99      45.920 -10.010  39.943  1.00  0.00           C  
ATOM   1449  C   GLY A  99      45.525  -9.804  41.406  1.00  0.00           C  
ATOM   1450  O   GLY A  99      45.542  -8.680  41.905  1.00  0.00           O  
ATOM   1451  H   GLY A  99      44.821  -9.003  38.487  1.00  0.00           H  
ATOM   1452  HA2 GLY A  99      46.321 -11.014  39.808  1.00  0.00           H  
ATOM   1453  HA3 GLY A  99      46.711  -9.311  39.673  1.00  0.00           H  
TER    1454      GLY A  99                                                      
END
MOLECULE T0397_83_150.pdb
ATOM    717  N   LEU    83      35.835  21.935  54.102  1.00 33.12          
ATOM    718  CA  LEU    83      35.719  23.282  53.561  1.00 33.32          
ATOM    719  C   LEU    83      36.582  23.427  52.306  1.00 32.66          
ATOM    720  O   LEU    83      37.427  22.578  52.030  1.00 33.17          
ATOM    721  CB  LEU    83      36.184  24.314  54.588  1.00 33.05          
ATOM    722  CG  LEU    83      35.428  24.389  55.909  1.00 34.55          
ATOM    723  CD1 LEU    83      36.110  25.424  56.813  1.00 31.53          
ATOM    724  CD2 LEU    83      33.926  24.720  55.714  1.00 33.95          
ATOM    725  N   ILE    84      36.339  24.487  51.547  1.00 31.28          
ATOM    726  CA  ILE    84      37.113  24.815  50.390  1.00 31.86          
ATOM    727  C   ILE    84      37.899  26.128  50.688  1.00 31.86          
ATOM    728  O   ILE    84      37.374  27.068  51.262  1.00 30.84          
ATOM    729  CB  ILE    84      36.211  24.884  49.102  1.00 33.01          
ATOM    730  CG1 ILE    84      35.635  23.481  48.828  1.00 32.64          
ATOM    731  CG2 ILE    84      37.046  25.413  47.910  1.00 32.85          
ATOM    732  CD  ILE    84      34.896  23.257  47.596  1.00 34.41          
ATOM    733  N   SER    85      39.183  26.115  50.391  1.00 31.66          
ATOM    734  CA  SER    85      40.056  27.270  50.558  1.00 32.45          
ATOM    735  C   SER    85      40.379  27.753  49.179  1.00 30.88          
ATOM    736  O   SER    85      40.777  26.974  48.349  1.00 28.90          
ATOM    737  CB  SER    85      41.345  26.854  51.252  1.00 33.29          
ATOM    738  OG  SER    85      41.047  26.245  52.505  1.00 38.38          
ATOM    739  N   VAL    86      40.161  29.032  48.922  1.00 30.89          
ATOM    740  CA  VAL    86      40.406  29.618  47.617  1.00 30.18          
ATOM    741  C   VAL    86      41.432  30.751  47.751  1.00 30.50          
ATOM    742  O   VAL    86      41.128  31.827  48.263  1.00 29.45          
ATOM    743  CB  VAL    86      39.090  30.166  47.031  1.00 31.39          
ATOM    744  CG1 VAL    86      39.278  30.554  45.537  1.00 30.79          
ATOM    745  CG2 VAL    86      37.974  29.150  47.205  1.00 29.24          
ATOM    746  N   PRO    87      42.702  30.485  47.366  1.00 31.49          
ATOM    747  CA  PRO    87      43.702  31.557  47.420  1.00 30.98          
ATOM    748  C   PRO    87      43.541  32.615  46.290  1.00 30.90          
ATOM    749  O   PRO    87      43.077  32.315  45.202  1.00 29.79          
ATOM    750  CB  PRO    87      45.028  30.825  47.303  1.00 31.58          
ATOM    751  CG  PRO    87      44.693  29.422  46.847  1.00 32.96          
ATOM    752  CD  PRO    87      43.240  29.210  46.879  1.00 30.77          
ATOM    753  N   ALA    88      43.890  33.849  46.619  1.00 31.20          
ATOM    754  CA  ALA    88      43.874  34.986  45.725  1.00 31.18          
ATOM    755  C   ALA    88      45.284  35.570  45.884  1.00 31.56          
ATOM    756  O   ALA    88      45.555  36.263  46.864  1.00 31.99          
ATOM    757  CB  ALA    88      42.823  35.984  46.165  1.00 29.82          
ATOM    758  N   GLU    89      46.181  35.230  44.957  1.00 31.39          
ATOM    759  CA  GLU    89      47.591  35.660  44.994  1.00 31.91          
ATOM    760  C   GLU    89      48.000  36.444  43.779  1.00 31.08          
ATOM    761  O   GLU    89      47.752  36.021  42.661  1.00 32.28          
ATOM    762  CB  GLU    89      48.493  34.426  45.011  1.00 32.34          
ATOM    763  CG  GLU    89      48.251  33.502  46.184  1.00 35.65          
ATOM    764  CD  GLU    89      49.120  32.295  46.110  1.00 41.85          
ATOM    765  OE1 GLU    89      49.575  31.939  44.988  1.00 42.45          
ATOM    766  OE2 GLU    89      49.398  31.740  47.195  1.00 48.31          
ATOM    767  N   GLY    90      48.688  37.552  43.997  1.00 30.77          
ATOM    768  CA  GLY    90      49.163  38.409  42.917  1.00 30.21          
ATOM    769  C   GLY    90      49.928  39.585  43.484  1.00 30.04          
ATOM    770  O   GLY    90      49.980  39.771  44.709  1.00 30.76          
ATOM    771  N   TYR    91      50.541  40.360  42.604  1.00 29.01          
ATOM    772  CA  TYR    91      51.260  41.582  42.987  1.00 29.19          
ATOM    773  C   TYR    91      50.355  42.462  43.856  1.00 27.98          
ATOM    774  O   TYR    91      50.755  42.867  44.940  1.00 26.97          
ATOM    775  CB  TYR    91      51.788  42.315  41.750  1.00 28.63          
ATOM    776  CG  TYR    91      52.460  43.646  42.050  1.00 29.43          
ATOM    777  CD1 TYR    91      53.695  43.705  42.695  1.00 28.96          
ATOM    778  CD2 TYR    91      51.863  44.835  41.655  1.00 26.65          
ATOM    779  CE1 TYR    91      54.291  44.931  42.967  1.00 30.76          
ATOM    780  CE2 TYR    91      52.430  46.032  41.907  1.00 29.47          
ATOM    781  CZ  TYR    91      53.652  46.099  42.553  1.00 30.46          
ATOM    782  OH  TYR    91      54.196  47.339  42.759  1.00 29.11          
ATOM    783  N   LYS    92      49.133  42.689  43.373  1.00 27.98          
ATOM    784  CA  LYS    92      48.065  43.394  44.107  1.00 27.98          
ATOM    785  C   LYS    92      46.799  42.550  43.968  1.00 28.43          
ATOM    786  O   LYS    92      46.511  41.996  42.886  1.00 28.52          
ATOM    787  CB  LYS    92      47.799  44.807  43.567  1.00 28.07          
ATOM    788  CG  LYS    92      48.955  45.746  43.679  1.00 28.03          
ATOM    789  CD  LYS    92      48.737  47.040  42.914  1.00 28.62          
ATOM    790  CE  LYS    92      47.732  47.975  43.550  1.00 28.71          
ATOM    791  NZ  LYS    92      47.496  49.146  42.668  1.00 27.15          
ATOM    792  N   VAL    93      46.070  42.427  45.066  1.00 28.48          
ATOM    793  CA  VAL    93      44.861  41.611  45.110  1.00 28.35          
ATOM    794  C   VAL    93      43.738  42.456  45.613  1.00 28.50          
ATOM    795  O   VAL    93      43.891  43.173  46.603  1.00 28.44          
ATOM    796  CB  VAL    93      45.008  40.312  46.011  1.00 28.74          
ATOM    797  CG1 VAL    93      43.660  39.491  46.023  1.00 25.37          
ATOM    798  CG2 VAL    93      46.221  39.458  45.555  1.00 25.20          
ATOM    799  N   TYR    94      42.629  42.403  44.882  1.00 29.53          
ATOM    800  CA  TYR    94      41.404  43.147  45.179  1.00 29.93          
ATOM    801  C   TYR    94      40.300  42.124  45.422  1.00 29.26          
ATOM    802  O   TYR    94      39.606  41.728  44.531  1.00 29.00          
ATOM    803  CB  TYR    94      41.016  44.039  44.004  1.00 30.51          
ATOM    804  CG  TYR    94      42.016  45.110  43.674  1.00 31.04          
ATOM    805  CD1 TYR    94      41.983  46.336  44.320  1.00 30.17          
ATOM    806  CD2 TYR    94      42.999  44.891  42.701  1.00 30.58          
ATOM    807  CE1 TYR    94      42.912  47.327  44.017  1.00 30.75          
ATOM    808  CE2 TYR    94      43.917  45.847  42.398  1.00 31.08          
ATOM    809  CZ  TYR    94      43.877  47.079  43.045  1.00 33.26          
ATOM    810  OH  TYR    94      44.823  48.055  42.712  1.00 32.99          
ATOM    811  N   PRO    95      40.130  41.718  46.663  1.00 29.25          
ATOM    812  CA  PRO    95      39.185  40.737  46.999  1.00 29.79          
ATOM    813  C   PRO    95      37.842  41.315  47.422  1.00 30.52          
ATOM    814  O   PRO    95      37.770  42.473  47.786  1.00 29.82          
ATOM    815  CB  PRO    95      39.847  40.112  48.241  1.00 29.66          
ATOM    816  CG  PRO    95      40.385  41.315  48.942  1.00 28.17          
ATOM    817  CD  PRO    95      40.868  42.182  47.851  1.00 28.68          
ATOM    818  N   ILE    96      36.786  40.514  47.319  1.00 31.49          
ATOM    819  CA  ILE    96      35.486  40.905  47.859  0.50 31.87          
ATOM    821  C   ILE    96      35.675  40.903  49.385  1.00 32.49          
ATOM    822  O   ILE    96      36.019  39.877  49.980  1.00 31.70          
ATOM    823  CB  ILE    96      34.369  39.925  47.482  0.50 31.46          
ATOM    825  CG1 ILE    96      34.142  39.906  45.963  0.50 31.53          
ATOM    827  CG2 ILE    96      33.082  40.292  48.190  0.50 32.32          
ATOM    829  CD  ILE    96      33.676  41.217  45.363  0.50 27.56          
ATOM    831  N   MET    97      35.476  42.060  49.996  1.00 33.47          
ATOM    832  CA  MET    97      35.648  42.267  51.416  0.60 36.42          
ATOM    834  C   MET    97      34.295  42.009  52.082  1.00 33.49          
ATOM    835  O   MET    97      33.612  42.948  52.393  1.00 33.78          
ATOM    836  CB  MET    97      36.063  43.731  51.622  0.60 36.40          
ATOM    838  CG  MET    97      37.206  44.211  50.698  0.60 40.39          
ATOM    840  SD  MET    97      37.422  46.188  50.408  0.48 46.95          
ATOM    842  CE  MET    97      35.833  46.788  49.386  0.60 41.22          
ATOM    844  N   ASP    98      33.891  40.757  52.252  1.00 32.35          
ATOM    845  CA  ASP    98      32.579  40.482  52.802  1.00 32.10          
ATOM    846  C   ASP    98      32.580  39.078  53.350  1.00 30.95          
ATOM    847  O   ASP    98      33.521  38.336  53.109  1.00 31.18          
ATOM    848  CB  ASP    98      31.498  40.707  51.709  1.00 32.01          
ATOM    849  CG  ASP    98      30.106  40.961  52.283  1.00 33.32          
ATOM    850  OD1 ASP    98      29.907  40.894  53.519  1.00 35.35          
ATOM    851  OD2 ASP    98      29.201  41.265  51.493  1.00 33.61          
ATOM    852  N   PHE    99      31.514  38.719  54.066  1.00 30.94          
ATOM    853  CA  PHE    99      31.442  37.443  54.766  1.00 31.08          
ATOM    854  C   PHE    99      30.036  36.931  54.775  1.00 30.94          
ATOM    855  O   PHE    99      29.111  37.697  54.945  1.00 31.23          
ATOM    856  CB  PHE    99      31.855  37.614  56.263  1.00 30.83          
ATOM    857  CG  PHE    99      33.071  38.416  56.462  1.00 30.89          
ATOM    858  CD1 PHE    99      32.985  39.818  56.579  1.00 31.04          
ATOM    859  CD2 PHE    99      34.318  37.816  56.491  1.00 30.92          
ATOM    860  CE1 PHE    99      34.105  40.582  56.705  1.00 29.76          
ATOM    861  CE2 PHE    99      35.470  38.595  56.658  1.00 31.42          
ATOM    862  CZ  PHE    99      35.361  39.963  56.786  1.00 30.91          
ATOM    863  N   GLY   100      29.887  35.616  54.682  1.00 31.37          
ATOM    864  CA  GLY   100      28.591  34.973  54.808  1.00 31.40          
ATOM    865  C   GLY   100      27.667  35.250  53.645  1.00 31.50          
ATOM    866  O   GLY   100      26.492  35.490  53.835  1.00 32.03          
ATOM    867  N   PHE   101      28.199  35.166  52.431  1.00 30.55          
ATOM    868  CA  PHE   101      27.413  35.397  51.253  1.00 30.28          
ATOM    869  C   PHE   101      27.459  34.184  50.363  1.00 29.34          
ATOM    870  O   PHE   101      28.464  33.516  50.257  1.00 28.31          
ATOM    871  CB  PHE   101      27.845  36.675  50.529  1.00 29.24          
ATOM    872  CG  PHE   101      29.285  36.679  50.080  1.00 30.50          
ATOM    873  CD1 PHE   101      29.620  36.396  48.760  1.00 30.99          
ATOM    874  CD2 PHE   101      30.289  37.040  50.939  1.00 30.32          
ATOM    875  CE1 PHE   101      30.890  36.445  48.331  1.00 27.52          
ATOM    876  CE2 PHE   101      31.560  37.069  50.519  1.00 29.34          
ATOM    877  CZ  PHE   101      31.870  36.751  49.207  1.00 31.56          
ATOM    878  N   ARG   102      26.302  33.886  49.789  1.00 29.69          
ATOM    879  CA  ARG   102      26.146  32.804  48.868  1.00 29.70          
ATOM    880  C   ARG   102      26.595  33.238  47.449  1.00 29.72          
ATOM    881  O   ARG   102      26.510  34.415  47.053  1.00 30.28          
ATOM    882  CB  ARG   102      24.703  32.350  48.911  1.00 30.29          
ATOM    883  CG  ARG   102      24.413  31.126  48.107  1.00 30.83          
ATOM    884  CD  ARG   102      23.204  30.401  48.607  1.00 32.50          
ATOM    885  NE  ARG   102      22.898  29.317  47.683  1.00 33.96          
ATOM    886  CZ  ARG   102      22.165  29.443  46.589  1.00 36.08          
ATOM    887  NH1 ARG   102      21.621  30.608  46.257  1.00 37.22          
ATOM    888  NH2 ARG   102      21.952  28.384  45.817  1.00 38.60          
ATOM    889  N   VAL   103      27.151  32.267  46.724  1.00 29.73          
ATOM    890  CA  VAL   103      27.673  32.452  45.381  1.00 28.43          
ATOM    891  C   VAL   103      27.395  31.182  44.602  1.00 28.35          
ATOM    892  O   VAL   103      27.155  30.120  45.201  1.00 29.10          
ATOM    893  CB  VAL   103      29.220  32.663  45.375  1.00 29.57          
ATOM    894  CG1 VAL   103      29.684  33.944  46.197  1.00 25.27          
ATOM    895  CG2 VAL   103      29.943  31.382  45.828  1.00 27.50          
ATOM    896  N   LEU   104      27.399  31.290  43.277  1.00 27.46          
ATOM    897  CA  LEU   104      27.326  30.149  42.402  1.00 27.49          
ATOM    898  C   LEU   104      28.722  29.996  41.808  1.00 27.61          
ATOM    899  O   LEU   104      29.482  30.950  41.734  1.00 27.73          
ATOM    900  CB  LEU   104      26.306  30.314  41.269  1.00 27.73          
ATOM    901  CG  LEU   104      24.808  30.462  41.607  1.00 29.77          
ATOM    902  CD1 LEU   104      23.965  30.684  40.342  1.00 25.73          
ATOM    903  CD2 LEU   104      24.249  29.273  42.470  1.00 31.65          
ATOM    904  N   LYS   105      29.048  28.781  41.392  1.00 28.03          
ATOM    905  CA  LYS   105      30.311  28.459  40.746  1.00 28.18          
ATOM    906  C   LYS   105      30.597  29.432  39.618  1.00 27.83          
ATOM    907  O   LYS   105      29.753  29.661  38.739  1.00 27.59          
ATOM    908  CB  LYS   105      30.200  27.021  40.168  1.00 28.45          
ATOM    909  CG  LYS   105      31.380  26.551  39.395  1.00 30.45          
ATOM    910  CD  LYS   105      31.381  25.043  39.324  1.00 35.24          
ATOM    911  CE  LYS   105      32.578  24.465  38.580  1.00 38.56          
ATOM    912  NZ  LYS   105      32.346  24.168  37.154  1.00 40.94          
ATOM    913  N   GLY   106      31.791  29.999  39.629  1.00 27.43          
ATOM    914  CA  GLY   106      32.174  30.950  38.620  1.00 27.72          
ATOM    915  C   GLY   106      32.108  32.395  39.084  1.00 28.48          
ATOM    916  O   GLY   106      32.655  33.238  38.443  1.00 29.66          
ATOM    917  N   TYR   107      31.426  32.661  40.185  1.00 29.11          
ATOM    918  CA  TYR   107      31.336  33.998  40.775  1.00 30.38          
ATOM    919  C   TYR   107      32.745  34.570  41.056  1.00 30.20          
ATOM    920  O   TYR   107      33.594  33.884  41.596  1.00 29.79          
ATOM    921  CB  TYR   107      30.529  33.897  42.076  1.00 30.84          
ATOM    922  CG  TYR   107      30.172  35.178  42.775  1.00 30.61          
ATOM    923  CD1 TYR   107      31.062  35.798  43.646  1.00 29.64          
ATOM    924  CD2 TYR   107      28.896  35.705  42.665  1.00 30.62          
ATOM    925  CE1 TYR   107      30.718  36.969  44.305  1.00 33.41          
ATOM    926  CE2 TYR   107      28.543  36.850  43.325  1.00 33.62          
ATOM    927  CZ  TYR   107      29.454  37.486  44.145  1.00 34.42          
ATOM    928  OH  TYR   107      29.081  38.628  44.811  1.00 35.85          
ATOM    929  N   ARG   108      32.970  35.823  40.679  1.00 28.91          
ATOM    930  CA  ARG   108      34.264  36.453  40.890  1.00 30.07          
ATOM    931  C   ARG   108      34.493  36.891  42.361  1.00 29.95          
ATOM    932  O   ARG   108      33.747  37.702  42.894  1.00 30.55          
ATOM    933  CB  ARG   108      34.382  37.666  39.973  1.00 29.73          
ATOM    934  CG  ARG   108      35.738  38.344  40.010  1.00 30.04          
ATOM    935  CD  ARG   108      35.685  39.608  39.168  1.00 29.75          
ATOM    936  NE  ARG   108      35.655  39.296  37.739  1.00 31.85          
ATOM    937  CZ  ARG   108      35.598  40.209  36.777  1.00 30.58          
ATOM    938  NH1 ARG   108      35.534  41.488  37.066  1.00 29.91          
ATOM    939  NH2 ARG   108      35.587  39.834  35.529  1.00 31.01          
ATOM    940  N   LEU   109      35.531  36.346  42.978  1.00 28.92          
ATOM    941  CA  LEU   109      35.884  36.639  44.349  1.00 28.66          
ATOM    942  C   LEU   109      37.000  37.670  44.473  1.00 28.99          
ATOM    943  O   LEU   109      37.064  38.378  45.491  1.00 29.94          
ATOM    944  CB  LEU   109      36.297  35.361  45.084  1.00 28.34          
ATOM    945  CG  LEU   109      35.269  34.228  45.135  1.00 28.28          
ATOM    946  CD1 LEU   109      35.870  32.903  45.615  1.00 24.20          
ATOM    947  CD2 LEU   109      34.070  34.624  45.978  1.00 26.32          
ATOM    948  N   ALA   110      37.869  37.755  43.460  1.00 28.72          
ATOM    949  CA  ALA   110      38.972  38.673  43.486  1.00 28.85          
ATOM    950  C   ALA   110      39.487  38.973  42.092  1.00 28.20          
ATOM    951  O   ALA   110      39.349  38.165  41.182  1.00 28.69          
ATOM    952  CB  ALA   110      40.125  38.115  44.374  1.00 27.48          
ATOM    953  N   THR   111      40.053  40.168  41.955  1.00 28.00          
ATOM    954  CA  THR   111      40.796  40.619  40.767  1.00 27.96          
ATOM    955  C   THR   111      42.250  40.653  41.184  1.00 28.47          
ATOM    956  O   THR   111      42.573  41.096  42.288  1.00 28.25          
ATOM    957  CB  THR   111      40.370  42.000  40.317  1.00 28.12          
ATOM    958  OG1 THR   111      39.035  41.937  39.833  1.00 27.47          
ATOM    959  CG2 THR   111      41.266  42.562  39.207  1.00 27.78          
ATOM    960  N   LEU   112      43.133  40.139  40.336  1.00 29.31          
ATOM    961  CA  LEU   112      44.559  40.173  40.619  1.00 29.41          
ATOM    962  C   LEU   112      45.197  41.104  39.589  1.00 29.94          
ATOM    963  O   LEU   112      44.933  40.958  38.424  1.00 29.91          
ATOM    964  CB  LEU   112      45.180  38.782  40.491  1.00 30.01          
ATOM    965  CG  LEU   112      44.437  37.607  41.127  1.00 29.77          
ATOM    966  CD1 LEU   112      45.066  36.279  40.711  1.00 28.80          
ATOM    967  CD2 LEU   112      44.441  37.747  42.621  1.00 26.63          
ATOM    968  N   GLU   113      46.051  42.033  40.033  1.00 29.49          
ATOM    969  CA  GLU   113      46.730  42.979  39.160  1.00 29.48          
ATOM    970  C   GLU   113      48.231  42.744  39.255  1.00 29.28          
ATOM    971  O   GLU   113      48.794  42.656  40.343  1.00 27.97          
ATOM    972  CB  GLU   113      46.408  44.410  39.573  1.00 29.28          
ATOM    973  CG  GLU   113      46.978  45.490  38.687  1.00 31.66          
ATOM    974  CD  GLU   113      46.898  46.858  39.331  1.00 32.90          
ATOM    975  OE1 GLU   113      46.454  46.975  40.501  1.00 37.77          
ATOM    976  OE2 GLU   113      47.260  47.818  38.662  1.00 31.95          
ATOM    977  N   SER   114      48.871  42.632  38.098  1.00 29.97          
ATOM    978  CA  SER   114      50.300  42.391  38.042  1.00 30.52          
ATOM    979  C   SER   114      51.067  43.720  38.159  1.00 31.36          
ATOM    980  O   SER   114      50.469  44.799  38.086  1.00 31.23          
ATOM    981  CB  SER   114      50.670  41.689  36.722  1.00 30.65          
ATOM    982  OG  SER   114      50.747  42.605  35.639  1.00 30.72          
ATOM    983  N   LYS   115      52.390  43.608  38.282  1.00 31.74          
ATOM    984  CA  LYS   115      53.277  44.780  38.418  0.50 32.12          
ATOM    986  C   LYS   115      53.106  45.728  37.235  1.00 32.17          
ATOM    987  O   LYS   115      53.249  46.928  37.387  1.00 32.06          
ATOM    988  CB  LYS   115      54.752  44.347  38.577  0.50 31.97          
ATOM    990  CG  LYS   115      55.801  45.478  38.696  0.50 32.47          
ATOM    992  CD  LYS   115      55.729  46.251  40.024  0.50 32.71          
ATOM    994  CE  LYS   115      56.780  47.354  40.124  0.50 31.77          
ATOM    996  NZ  LYS   115      58.161  46.820  40.231  0.50 31.98          
ATOM    998  N   LYS   116      52.762  45.188  36.068  1.00 32.06          
ATOM    999  CA  LYS   116      52.553  45.980  34.858  1.00 32.15          
ATOM   1000  C   LYS   116      51.082  46.217  34.499  1.00 31.72          
ATOM   1001  O   LYS   116      50.784  46.647  33.385  1.00 31.63          
ATOM   1002  CB  LYS   116      53.342  45.372  33.666  1.00 32.29          
ATOM   1003  CG  LYS   116      54.850  45.627  33.743  1.00 32.32          
ATOM   1004  N   GLY   117      50.170  45.944  35.442  1.00 32.17          
ATOM   1005  CA  GLY   117      48.743  46.219  35.266  1.00 31.65          
ATOM   1006  C   GLY   117      47.889  45.171  34.583  1.00 32.02          
ATOM   1007  O   GLY   117      46.760  45.448  34.209  1.00 30.89          
ATOM   1008  N   ASP   118      48.425  43.977  34.386  1.00 33.07          
ATOM   1009  CA  ASP   118      47.646  42.886  33.802  1.00 33.69          
ATOM   1010  C   ASP   118      46.676  42.350  34.856  1.00 33.47          
ATOM   1011  O   ASP   118      47.048  42.171  36.024  1.00 33.70          
ATOM   1012  CB  ASP   118      48.564  41.756  33.373  1.00 34.70          
ATOM   1013  CG  ASP   118      49.562  42.169  32.288  1.00 36.13          
ATOM   1014  OD1 ASP   118      49.170  42.849  31.305  1.00 37.08          
ATOM   1015  OD2 ASP   118      50.738  41.765  32.428  1.00 38.14          
ATOM   1016  N   LEU   119      45.440  42.100  34.446  1.00 33.09          
ATOM   1017  CA  LEU   119      44.387  41.617  35.344  1.00 33.04          
ATOM   1018  C   LEU   119      44.009  40.149  35.114  1.00 32.88          
ATOM   1019  O   LEU   119      43.837  39.749  33.997  1.00 33.07          
ATOM   1020  CB  LEU   119      43.134  42.462  35.134  1.00 32.71          
ATOM   1021  CG  LEU   119      43.311  43.951  35.413  1.00 32.71          
ATOM   1022  CD1 LEU   119      42.062  44.678  35.032  1.00 32.27          
ATOM   1023  CD2 LEU   119      43.657  44.206  36.868  1.00 30.21          
ATOM   1024  N   ARG   120      43.908  39.376  36.185  1.00 32.63          
ATOM   1025  CA  ARG   120      43.437  37.998  36.158  1.00 33.15          
ATOM   1026  C   ARG   120      42.375  37.965  37.238  1.00 31.39          
ATOM   1027  O   ARG   120      42.294  38.887  38.054  1.00 31.30          
ATOM   1028  CB  ARG   120      44.544  36.988  36.469  1.00 32.65          
ATOM   1029  CG  ARG   120      45.616  36.885  35.399  1.00 35.91          
ATOM   1030  CD  ARG   120      46.797  35.979  35.783  1.00 38.66          
ATOM   1031  NE  ARG   120      47.527  36.434  36.987  1.00 44.57          
ATOM   1032  CZ  ARG   120      47.667  35.764  38.145  1.00 48.21          
ATOM   1033  NH1 ARG   120      47.168  34.512  38.324  1.00 51.17          
ATOM   1034  NH2 ARG   120      48.348  36.352  39.150  1.00 47.05          
ATOM   1035  N   TYR   121      41.566  36.910  37.257  1.00 30.65          
ATOM   1036  CA  TYR   121      40.498  36.770  38.232  1.00 29.52          
ATOM   1037  C   TYR   121      40.497  35.450  38.994  1.00 29.31          
ATOM   1038  O   TYR   121      40.944  34.430  38.500  1.00 29.67          
ATOM   1039  CB  TYR   121      39.178  36.955  37.531  1.00 29.22          
ATOM   1040  CG  TYR   121      39.180  38.215  36.761  1.00 30.47          
ATOM   1041  CD1 TYR   121      39.085  39.443  37.402  1.00 30.72          
ATOM   1042  CD2 TYR   121      39.357  38.208  35.399  1.00 31.47          
ATOM   1043  CE1 TYR   121      39.132  40.632  36.696  1.00 31.64          
ATOM   1044  CE2 TYR   121      39.419  39.404  34.685  1.00 32.50          
ATOM   1045  CZ  TYR   121      39.298  40.601  35.341  1.00 31.18          
ATOM   1046  OH  TYR   121      39.327  41.770  34.623  1.00 32.27          
ATOM   1047  N   VAL   122      39.991  35.502  40.220  1.00 28.84          
ATOM   1048  CA  VAL   122      39.818  34.333  41.077  1.00 28.57          
ATOM   1049  C   VAL   122      38.327  34.177  41.193  1.00 28.66          
ATOM   1050  O   VAL   122      37.629  35.069  41.675  1.00 27.80          
ATOM   1051  CB  VAL   122      40.446  34.528  42.440  1.00 28.46          
ATOM   1052  CG1 VAL   122      40.099  33.331  43.394  1.00 28.10          
ATOM   1053  CG2 VAL   122      41.995  34.756  42.248  1.00 28.42          
ATOM   1054  N   ASN   123      37.832  33.056  40.700  1.00 28.86          
ATOM   1055  CA  ASN   123      36.408  32.774  40.695  1.00 28.39          
ATOM   1056  C   ASN   123      36.123  31.648  41.616  1.00 28.56          
ATOM   1057  O   ASN   123      36.984  30.826  41.818  1.00 27.87          
ATOM   1058  CB  ASN   123      35.956  32.381  39.304  1.00 29.33          
ATOM   1059  CG  ASN   123      36.182  33.462  38.296  1.00 27.62          
ATOM   1060  OD1 ASN   123      35.988  34.628  38.564  1.00 32.47          
ATOM   1061  ND2 ASN   123      36.597  33.082  37.147  1.00 27.51          
ATOM   1062  N   SER   124      34.899  31.611  42.167  1.00 28.33          
ATOM   1063  CA  SER   124      34.486  30.526  43.025  1.00 28.38          
ATOM   1064  C   SER   124      34.494  29.189  42.288  1.00 28.59          
ATOM   1065  O   SER   124      33.860  29.067  41.234  1.00 27.48          
ATOM   1066  CB  SER   124      33.062  30.755  43.529  1.00 28.74          
ATOM   1067  OG  SER   124      32.815  29.870  44.572  1.00 24.63          
ATOM   1068  N   PRO   125      35.180  28.165  42.855  1.00 29.27          
ATOM   1069  CA  PRO   125      35.201  26.860  42.239  1.00 29.34          
ATOM   1070  C   PRO   125      33.907  26.060  42.416  1.00 29.48          
ATOM   1071  O   PRO   125      33.727  25.061  41.755  1.00 29.83          
ATOM   1072  CB  PRO   125      36.341  26.161  42.996  1.00 29.36          
ATOM   1073  CG  PRO   125      36.282  26.701  44.298  1.00 29.22          
ATOM   1074  CD  PRO   125      35.932  28.152  44.118  1.00 29.39          
ATOM   1075  N   VAL   126      33.029  26.483  43.331  1.00 30.06          
ATOM   1076  CA  VAL   126      31.809  25.778  43.631  1.00 29.39          
ATOM   1077  C   VAL   126      30.714  26.751  43.999  1.00 29.93          
ATOM   1078  O   VAL   126      30.942  27.936  44.183  1.00 30.98          
ATOM   1079  CB  VAL   126      31.997  24.820  44.859  1.00 30.07          
ATOM   1080  CG1 VAL   126      33.004  23.721  44.563  1.00 29.26          
ATOM   1081  CG2 VAL   126      32.403  25.597  46.126  1.00 28.09          
ATOM   1082  N   SER   127      29.512  26.226  44.085  1.00 29.28          
ATOM   1083  CA  SER   127      28.373  26.936  44.581  1.00 29.29          
ATOM   1084  C   SER   127      28.286  26.666  46.084  1.00 28.40          
ATOM   1085  O   SER   127      28.467  25.564  46.540  1.00 28.74          
ATOM   1086  CB  SER   127      27.103  26.448  43.880  1.00 28.97          
ATOM   1087  OG  SER   127      27.121  26.809  42.521  1.00 30.47          
ATOM   1088  N   GLY   128      27.994  27.692  46.865  1.00 29.10          
ATOM   1089  CA  GLY   128      27.890  27.524  48.307  1.00 28.32          
ATOM   1090  C   GLY   128      28.029  28.842  48.967  1.00 27.81          
ATOM   1091  O   GLY   128      27.764  29.826  48.359  1.00 28.32          
ATOM   1092  N   THR   129      28.516  28.851  50.197  1.00 28.38          
ATOM   1093  CA  THR   129      28.600  30.051  51.013  1.00 29.02          
ATOM   1094  C   THR   129      30.052  30.413  51.333  1.00 28.70          
ATOM   1095  O   THR   129      30.805  29.569  51.724  1.00 28.95          
ATOM   1096  CB  THR   129      27.871  29.820  52.367  1.00 29.10          
ATOM   1097  OG1 THR   129      26.538  29.280  52.147  1.00 28.63          
ATOM   1098  CG2 THR   129      27.797  31.113  53.170  1.00 26.94          
ATOM   1099  N   VAL   130      30.430  31.660  51.140  1.00 29.17          
ATOM   1100  CA  VAL   130      31.739  32.131  51.531  1.00 30.48          
ATOM   1101  C   VAL   130      31.538  32.462  52.984  1.00 30.69          
ATOM   1102  O   VAL   130      30.805  33.349  53.295  1.00 31.50          
ATOM   1103  CB  VAL   130      32.204  33.394  50.734  1.00 30.60          
ATOM   1104  CG1 VAL   130      33.557  33.925  51.266  1.00 29.82          
ATOM   1105  CG2 VAL   130      32.300  33.086  49.283  1.00 30.63          
ATOM   1106  N   ILE   131      32.216  31.747  53.861  1.00 32.65          
ATOM   1107  CA  ILE   131      32.070  31.890  55.295  1.00 33.61          
ATOM   1108  C   ILE   131      33.073  32.881  55.895  1.00 33.47          
ATOM   1109  O   ILE   131      32.757  33.594  56.835  1.00 34.54          
ATOM   1110  CB  ILE   131      32.058  30.469  56.003  1.00 34.99          
ATOM   1111  CG1 ILE   131      33.407  29.769  55.988  1.00 37.35          
ATOM   1112  CG2 ILE   131      31.005  29.503  55.369  1.00 32.31          
ATOM   1113  CD  ILE   131      33.339  28.349  56.558  1.00 36.05          
ATOM   1114  N   PHE   132      34.257  33.000  55.318  1.00 33.54          
ATOM   1115  CA  PHE   132      35.248  33.929  55.843  1.00 33.34          
ATOM   1116  C   PHE   132      36.238  34.235  54.771  1.00 32.81          
ATOM   1117  O   PHE   132      36.340  33.542  53.762  1.00 32.93          
ATOM   1118  CB  PHE   132      35.978  33.360  57.082  1.00 33.46          
ATOM   1119  CG  PHE   132      35.917  34.273  58.313  1.00 33.81          
ATOM   1120  CD1 PHE   132      36.636  35.459  58.376  1.00 33.52          
ATOM   1121  CD2 PHE   132      35.140  33.913  59.412  1.00 33.83          
ATOM   1122  CE1 PHE   132      36.568  36.285  59.487  1.00 34.34          
ATOM   1123  CE2 PHE   132      35.065  34.742  60.542  1.00 34.41          
ATOM   1124  CZ  PHE   132      35.771  35.924  60.576  1.00 33.89          
ATOM   1125  N   MET   133      36.904  35.362  54.935  1.00 32.69          
ATOM   1126  CA  MET   133      38.010  35.718  54.067  1.00 31.66          
ATOM   1127  C   MET   133      38.954  36.535  54.922  1.00 31.51          
ATOM   1128  O   MET   133      38.537  37.133  55.927  1.00 30.00          
ATOM   1129  CB  MET   133      37.526  36.476  52.840  1.00 31.10          
ATOM   1130  CG  MET   133      36.856  37.801  53.121  1.00 31.10          
ATOM   1131  SD  MET   133      38.027  39.306  53.371  0.75 27.39          
ATOM   1132  CE  MET   133      38.977  39.093  51.665  1.00 30.78          
ATOM   1133  N   ASN   134      40.221  36.573  54.505  1.00 31.65          
ATOM   1134  CA  ASN   134      41.234  37.341  55.187  1.00 31.18          
ATOM   1135  C   ASN   134      42.550  37.392  54.410  1.00 31.15          
ATOM   1136  O   ASN   134      42.766  36.638  53.465  1.00 30.05          
ATOM   1137  CB  ASN   134      41.495  36.734  56.590  1.00 30.95          
ATOM   1138  CG  ASN   134      41.738  35.215  56.546  1.00 30.15          
ATOM   1139  OD1 ASN   134      40.798  34.440  56.568  1.00 31.54          
ATOM   1140  ND2 ASN   134      42.995  34.799  56.503  1.00 29.15          
ATOM   1141  N   GLU   135      43.415  38.315  54.833  1.00 31.28          
ATOM   1142  CA  GLU   135      44.803  38.371  54.391  1.00 31.19          
ATOM   1143  C   GLU   135      45.467  37.105  54.902  1.00 31.28          
ATOM   1144  O   GLU   135      45.140  36.589  55.969  1.00 31.04          
ATOM   1145  CB  GLU   135      45.558  39.476  55.098  1.00 31.44          
ATOM   1146  CG  GLU   135      45.180  40.847  54.761  1.00 31.10          
ATOM   1147  CD  GLU   135      45.856  41.845  55.647  1.00 29.10          
ATOM   1148  OE1 GLU   135      46.045  41.590  56.849  1.00 28.16          
ATOM   1149  OE2 GLU   135      46.195  42.897  55.129  1.00 31.14          
ATOM   1150  N   ILE   136      46.428  36.630  54.138  1.00 31.61          
ATOM   1151  CA  ILE   136      47.195  35.464  54.493  1.00 32.13          
ATOM   1152  C   ILE   136      48.260  35.960  55.475  1.00 31.79          
ATOM   1153  O   ILE   136      48.986  36.842  55.151  1.00 31.36          
ATOM   1154  CB  ILE   136      47.756  34.806  53.214  1.00 32.92          
ATOM   1155  CG1 ILE   136      46.589  34.150  52.454  1.00 29.58          
ATOM   1156  CG2 ILE   136      48.856  33.804  53.539  1.00 32.26          
ATOM   1157  CD  ILE   136      46.975  33.467  51.130  1.00 32.30          
ATOM   1158  N   PRO   137      48.306  35.420  56.709  1.00 32.77          
ATOM   1159  CA  PRO   137      49.274  35.953  57.678  1.00 33.77          
ATOM   1160  C   PRO   137      50.699  36.014  57.169  1.00 34.29          
ATOM   1161  O   PRO   137      51.377  37.019  57.389  1.00 35.58          
ATOM   1162  CB  PRO   137      49.152  34.988  58.846  1.00 33.69          
ATOM   1163  CG  PRO   137      47.777  34.485  58.741  1.00 33.61          
ATOM   1164  CD  PRO   137      47.543  34.316  57.295  1.00 32.30          
ATOM   1165  N   SER   138      51.127  34.981  56.446  1.00 35.02          
ATOM   1166  CA  SER   138      52.505  34.911  55.921  1.00 35.03          
ATOM   1167  C   SER   138      52.782  35.841  54.769  1.00 34.80          
ATOM   1168  O   SER   138      53.940  36.110  54.460  1.00 35.23          
ATOM   1169  CB  SER   138      52.844  33.479  55.506  1.00 35.10          
ATOM   1170  OG  SER   138      51.877  32.964  54.630  1.00 36.69          
ATOM   1171  N   GLU   139      51.745  36.294  54.071  1.00 34.68          
ATOM   1172  CA  GLU   139      51.949  37.254  52.995  1.00 34.27          
ATOM   1173  C   GLU   139      50.666  38.041  52.816  1.00 33.05          
ATOM   1174  O   GLU   139      49.802  37.657  52.059  1.00 31.18          
ATOM   1175  CB  GLU   139      52.451  36.611  51.695  1.00 33.92          
ATOM   1176  CG  GLU   139      52.949  37.681  50.687  1.00 34.83          
ATOM   1177  CD  GLU   139      53.502  37.114  49.365  1.00 38.52          
ATOM   1178  OE1 GLU   139      53.819  35.880  49.300  1.00 45.31          
ATOM   1179  OE2 GLU   139      53.628  37.910  48.373  1.00 41.93          
ATOM   1180  N   ARG   140      50.601  39.169  53.525  1.00 33.00          
ATOM   1181  CA  ARG   140      49.403  40.016  53.617  1.00 33.02          
ATOM   1182  C   ARG   140      48.832  40.613  52.325  1.00 32.12          
ATOM   1183  O   ARG   140      47.656  40.969  52.287  1.00 33.01          
ATOM   1184  CB  ARG   140      49.625  41.110  54.641  1.00 33.55          
ATOM   1185  CG  ARG   140      49.618  40.603  56.020  1.00 33.72          
ATOM   1186  CD  ARG   140      49.867  41.760  56.931  1.00 33.98          
ATOM   1187  NE  ARG   140      50.073  41.335  58.312  1.00 31.90          
ATOM   1188  CZ  ARG   140      49.217  41.476  59.303  1.00 32.28          
ATOM   1189  NH1 ARG   140      48.041  42.066  59.130  1.00 32.64          
ATOM   1190  NH2 ARG   140      49.583  41.063  60.510  1.00 31.55          
ATOM   1191  N   ALA   141      49.650  40.687  51.297  1.00 31.04          
ATOM   1192  CA  ALA   141      49.264  41.118  49.961  1.00 31.25          
ATOM   1193  C   ALA   141      48.235  40.147  49.390  1.00 31.65          
ATOM   1194  O   ALA   141      47.406  40.544  48.588  1.00 31.63          
ATOM   1195  CB  ALA   141      50.563  41.125  49.009  1.00 30.79          
ATOM   1196  N   ASN   142      48.326  38.874  49.797  1.00 31.81          
ATOM   1197  CA  ASN   142      47.462  37.808  49.327  1.00 31.67          
ATOM   1198  C   ASN   142      46.288  37.546  50.303  1.00 31.60          
ATOM   1199  O   ASN   142      46.320  37.903  51.475  1.00 32.41          
ATOM   1200  CB  ASN   142      48.267  36.525  49.069  1.00 31.56          
ATOM   1201  CG  ASN   142      49.404  36.710  48.061  1.00 31.76          
ATOM   1202  OD1 ASN   142      49.383  37.601  47.221  1.00 32.48          
ATOM   1203  ND2 ASN   142      50.380  35.838  48.125  1.00 30.67          
ATOM   1204  N   TYR   143      45.237  36.943  49.771  1.00 30.91          
ATOM   1205  CA  TYR   143      44.031  36.663  50.498  1.00 29.87          
ATOM   1206  C   TYR   143      43.571  35.218  50.307  1.00 29.75          
ATOM   1207  O   TYR   143      43.975  34.535  49.396  1.00 28.22          
ATOM   1208  CB  TYR   143      42.927  37.625  50.042  1.00 29.90          
ATOM   1209  CG  TYR   143      43.155  39.083  50.455  1.00 29.48          
ATOM   1210  CD1 TYR   143      43.962  39.914  49.675  1.00 27.65          
ATOM   1211  CD2 TYR   143      42.558  39.617  51.586  1.00 28.99          
ATOM   1212  CE1 TYR   143      44.193  41.193  50.007  1.00 30.87          
ATOM   1213  CE2 TYR   143      42.791  40.948  51.960  1.00 30.29          
ATOM   1214  CZ  TYR   143      43.618  41.711  51.161  1.00 29.81          
ATOM   1215  OH  TYR   143      43.889  42.987  51.418  1.00 31.80          
ATOM   1216  N   VAL   144      42.674  34.788  51.179  1.00 30.32          
ATOM   1217  CA  VAL   144      42.092  33.471  51.114  1.00 29.85          
ATOM   1218  C   VAL   144      40.616  33.605  51.469  1.00 30.50          
ATOM   1219  O   VAL   144      40.258  34.388  52.334  1.00 29.82          
ATOM   1220  CB  VAL   144      42.831  32.484  52.080  1.00 30.16          
ATOM   1221  CG1 VAL   144      42.731  32.951  53.551  1.00 27.18          
ATOM   1222  CG2 VAL   144      42.364  31.038  51.848  1.00 26.04          
ATOM   1223  N   PHE   145      39.776  32.873  50.736  1.00 30.78          
ATOM   1224  CA  PHE   145      38.368  32.781  51.015  1.00 30.53          
ATOM   1225  C   PHE   145      38.091  31.372  51.542  1.00 31.23          
ATOM   1226  O   PHE   145      38.650  30.398  51.045  1.00 31.66          
ATOM   1227  CB  PHE   145      37.560  33.019  49.738  1.00 31.15          
ATOM   1228  CG  PHE   145      37.780  34.342  49.137  1.00 30.85          
ATOM   1229  CD1 PHE   145      38.842  34.558  48.281  1.00 34.03          
ATOM   1230  CD2 PHE   145      36.942  35.388  49.426  1.00 31.87          
ATOM   1231  CE1 PHE   145      39.066  35.816  47.740  1.00 34.40          
ATOM   1232  CE2 PHE   145      37.152  36.640  48.876  1.00 30.74          
ATOM   1233  CZ  PHE   145      38.202  36.853  48.047  1.00 33.01          
ATOM   1234  N   TYR   146      37.237  31.248  52.562  1.00 31.84          
ATOM   1235  CA  TYR   146      36.838  29.925  53.037  1.00 31.32          
ATOM   1236  C   TYR   146      35.381  29.768  52.699  1.00 31.18          
ATOM   1237  O   TYR   146      34.601  30.672  52.935  1.00 31.77          
ATOM   1238  CB  TYR   146      37.093  29.747  54.517  1.00 31.06          
ATOM   1239  CG  TYR   146      38.540  29.779  54.850  1.00 31.66          
ATOM   1240  CD1 TYR   146      39.353  28.675  54.624  1.00 30.78          
ATOM   1241  CD2 TYR   146      39.119  30.916  55.381  1.00 32.06          
ATOM   1242  CE1 TYR   146      40.710  28.737  54.912  1.00 29.18          
ATOM   1243  CE2 TYR   146      40.437  30.958  55.683  1.00 31.33          
ATOM   1244  CZ  TYR   146      41.229  29.871  55.449  1.00 29.30          
ATOM   1245  OH  TYR   146      42.553  29.946  55.758  1.00 28.91          
ATOM   1246  N   MET   147      35.046  28.631  52.095  1.00 30.69          
ATOM   1247  CA  MET   147      33.699  28.306  51.660  1.00 29.75          
ATOM   1248  C   MET   147      33.218  26.951  52.139  1.00 30.05          
ATOM   1249  O   MET   147      33.992  26.005  52.328  1.00 29.86          
ATOM   1250  CB  MET   147      33.628  28.236  50.136  1.00 29.81          
ATOM   1251  CG  MET   147      34.193  29.440  49.391  1.00 31.03          
ATOM   1252  SD  MET   147      33.768  29.343  47.480  0.75 24.67          
ATOM   1253  CE  MET   147      31.824  29.011  47.804  1.00 31.59          
ATOM   1254  N   LEU   148      31.906  26.880  52.290  1.00 30.34          
ATOM   1255  CA  LEU   148      31.204  25.643  52.525  1.00 30.70          
ATOM   1256  C   LEU   148      30.446  25.379  51.236  1.00 31.20          
ATOM   1257  O   LEU   148      29.611  26.178  50.845  1.00 30.39          
ATOM   1258  CB  LEU   148      30.226  25.776  53.678  1.00 31.03          
ATOM   1259  CG  LEU   148      29.417  24.551  54.099  1.00 31.02          
ATOM   1260  CD1 LEU   148      30.272  23.256  54.355  1.00 28.35          
ATOM   1261  CD2 LEU   148      28.555  24.945  55.327  1.00 30.25          
ATOM   1262  N   GLU   149      30.772  24.271  50.563  1.00 31.34          
ATOM   1263  CA  GLU   149      30.094  23.869  49.356  1.00 31.58          
ATOM   1264  C   GLU   149      28.685  23.391  49.687  1.00 31.67          
ATOM   1265  O   GLU   149      28.452  22.766  50.733  1.00 31.30          
ATOM   1266  CB  GLU   149      30.868  22.765  48.669  1.00 32.45          
ATOM   1267  CG  GLU   149      30.220  22.284  47.416  1.00 33.30          
ATOM   1268  CD  GLU   149      31.106  21.330  46.614  1.00 35.55          
ATOM   1269  OE1 GLU   149      32.085  20.774  47.165  1.00 36.82          
ATOM   1270  OE2 GLU   149      30.791  21.127  45.429  1.00 34.53          
ATOM   1271  N   GLU   150      27.724  23.708  48.820  1.00 31.85          
ATOM   1272  CA  GLU   150      26.365  23.296  49.066  1.00 31.76          
ATOM   1273  C   GLU   150      26.049  22.123  48.156  1.00 32.44          
ATOM   1274  OT1 GLU   150      26.770  21.884  47.194  1.00 31.65          
ATOM   1275  CB  GLU   150      25.387  24.453  48.842  1.00 31.59          
ATOM   1276  CG  GLU   150      25.137  24.836  47.399  1.00 31.11          
ATOM   1277  CD  GLU   150      24.323  26.107  47.253  1.00 31.51          
ATOM   1278  OE1 GLU   150      24.363  26.957  48.148  1.00 31.26          
ATOM   1279  OE2 GLU   150      23.660  26.276  46.205  1.00 32.14          
ATOM   1280  OT2 GLU   150      25.047  21.415  48.336  1.00 34.12          
END
