
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  141 ( 2336),  selected  141 , name 2z5v_A
# Molecule2: number of CA atoms  143 ( 1066),  selected  143 , name T0398_1_124_272_290.pdb
# PARAMETERS: 2z5v_A.T0398_1_124_272_290.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     9_A      M       1           -
LGA    M    10_A      L       2           -
LGA    P    11_A      T       3           -
LGA    E    12_A      -       -           -
LGA    R    13_A      -       -           -
LGA    F    14_A      -       -           -
LGA    D    15_A      G       4          4.464
LGA    -       -      K       5           -
LGA    A    16_A      X       6          1.257
LGA    F    17_A      V       7          3.206
LGA    I    18_A      V       8          1.476
LGA    C    19_A      I       9          4.196
LGA    Y    20_A      I      10          1.888
LGA    C    21_A      G      11          3.338
LGA    P    22_A      -       -           -
LGA    S    23_A      -       -           -
LGA    D    24_A      G      12          2.605
LGA    I    25_A      D      13          3.860
LGA    Q    26_A      A      14          3.041
LGA    F    27_A      R      15          2.682
LGA    V    28_A      Q      16          3.104
LGA    Q    29_A      L      17          3.810
LGA    E    30_A      E      18          2.431
LGA    M    31_A      I      19          1.782
LGA    I    32_A      I      20          3.094
LGA    R    33_A      R      21          2.168
LGA    Q    34_A      K      22          1.600
LGA    L    35_A      L      23          2.189
LGA    E    36_A      S      24          2.430
LGA    Q    37_A      T      25          1.608
LGA    T    38_A      F      26          3.055
LGA    N    39_A      -       -           -
LGA    Y    40_A      -       -           -
LGA    R    41_A      D      27          2.854
LGA    L    42_A      A      28          1.936
LGA    K    43_A      K      29          2.113
LGA    L    44_A      I      30          1.783
LGA    C    45_A      S      31          1.843
LGA    V    46_A      L      32          1.069
LGA    S    47_A      V      33          1.976
LGA    D    48_A      G      34           #
LGA    R    49_A      F      35          4.148
LGA    D    50_A      D      36          0.748
LGA    V    51_A      Q      37          4.726
LGA    L    52_A      L      38          2.914
LGA    P    53_A      -       -           -
LGA    G    54_A      D      39          3.800
LGA    T    55_A      D      40          1.640
LGA    C    56_A      G      41          2.043
LGA    V    57_A      F      42          3.559
LGA    -       -      I      43           -
LGA    -       -      G      44           -
LGA    W    58_A      V      45          1.699
LGA    S    59_A      T      46          1.800
LGA    I    60_A      K      47          4.182
LGA    A    61_A      M      48          4.027
LGA    -       -      R      49           -
LGA    -       -      I      50           -
LGA    -       -      D      51           -
LGA    S    62_A      E      52          2.045
LGA    E    63_A      V      53          4.681
LGA    L    64_A      -       -           -
LGA    I    65_A      D      54          1.868
LGA    E    66_A      W      55          4.177
LGA    K    67_A      N      56           -
LGA    R    68_A      -       -           -
LGA    C    69_A      T      57          4.139
LGA    R    70_A      V      58          4.374
LGA    R    71_A      D      59          2.355
LGA    M    72_A      A      60          3.250
LGA    V    73_A      I      61          1.643
LGA    V    74_A      L      62          3.834
LGA    V    75_A      L      63          1.934
LGA    V    76_A      P      64           #
LGA    S    77_A      I      65           #
LGA    D    78_A      S      66          4.055
LGA    D    79_A      G      67          5.151
LGA    Y    80_A      T      68          1.811
LGA    L    81_A      N      69          2.416
LGA    Q    82_A      E      70          4.180
LGA    S    83_A      A      71          5.184
LGA    K    84_A      G      72          4.505
LGA    E    85_A      K      73          3.688
LGA    -       -      V      74           -
LGA    -       -      D      75           -
LGA    -       -      T      76           -
LGA    -       -      I      77           -
LGA    -       -      F      78           -
LGA    -       -      S      79           -
LGA    -       -      N      80           -
LGA    -       -      E      81           -
LGA    -       -      S      82           -
LGA    C    86_A      I      83           #
LGA    D    87_A      V      84          4.280
LGA    F    88_A      -       -           -
LGA    Q    89_A      L      85          2.426
LGA    T    90_A      T      86          2.078
LGA    K    91_A      E      87          2.645
LGA    F    92_A      E      88          2.693
LGA    A    93_A      M      89          2.754
LGA    L    94_A      I      90          3.531
LGA    S    95_A      E      91          3.308
LGA    L    96_A      K      92          1.866
LGA    S    97_A      -       -           -
LGA    P    98_A      -       -           -
LGA    G    99_A      -       -           -
LGA    A   100_A      -       -           -
LGA    H   101_A      T      93           #
LGA    Q   102_A      P      94           #
LGA    K   103_A      N      95          2.387
LGA    R   104_A      X      96          4.088
LGA    L   105_A      C      97          2.329
LGA    I   106_A      V      98          1.207
LGA    P   107_A      V      99          1.036
LGA    I   108_A      Y     100          0.962
LGA    K   109_A      S     101          1.375
LGA    Y   110_A      G     102          2.192
LGA    K   111_A      I     103          3.368
LGA    A   112_A      -       -           -
LGA    M   113_A      S     104          2.752
LGA    K   114_A      N     105          5.189
LGA    K   115_A      T     106          4.854
LGA    E   116_A      Y     107          4.038
LGA    F   117_A      L     108          2.769
LGA    P   118_A      N     109          4.253
LGA    S   119_A      Q     110          3.485
LGA    I   120_A      C     111          3.157
LGA    L   121_A      M     112          2.533
LGA    R   122_A      K     113          2.868
LGA    F   123_A      K     114           -
LGA    -       -      T     115           -
LGA    -       -      N     116           -
LGA    I   124_A      R     117          4.080
LGA    T   125_A      T     118          2.963
LGA    V   126_A      L     119          2.650
LGA    C   127_A      V     120          2.624
LGA    D   128_A      K     121          2.415
LGA    Y   129_A      L     122          2.772
LGA    -       -      M     123           -
LGA    T   130_A      E     124          2.395
LGA    N   131_A      A     272           -
LGA    -       -      P     273           -
LGA    -       -      K     274           -
LGA    -       -      T     275           -
LGA    -       -      A     276           -
LGA    -       -      G     277           -
LGA    -       -      R     278           -
LGA    P   132_A      I     279           #
LGA    C   133_A      -       -           -
LGA    T   134_A      -       -           -
LGA    K   135_A      -       -           -
LGA    S   136_A      L     280           #
LGA    W   137_A      A     281           -
LGA    -       -      D     282           -
LGA    F   138_A      V     283          3.507
LGA    W   139_A      L     284          2.199
LGA    T   140_A      V     285          3.199
LGA    R   141_A      K     286          3.388
LGA    L   142_A      L     287          3.332
LGA    A   143_A      L     288          3.368
LGA    K   144_A      A     289          1.329
LGA    A   145_A      E     290          4.758
LGA    L   146_A      -       -           -
LGA    S   147_A      -       -           -
LGA    L   148_A      -       -           -
LGA    P   149_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  141  143    5.0    103    3.09     9.71     39.140     3.225

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.233082 * X  +  -0.794027 * Y  +  -0.561422 * Z  +  31.099787
  Y_new =  -0.320081 * X  +   0.482512 * Y  +  -0.815310 * Z  +  15.036775
  Z_new =   0.918270 * X  +   0.369735 * Y  +  -0.141688 * Z  +  30.009546 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.936750   -1.204842  [ DEG:   110.9676    -69.0324 ]
  Theta =  -1.163690   -1.977903  [ DEG:   -66.6745   -113.3255 ]
  Phi   =  -0.941396    2.200196  [ DEG:   -53.9380    126.0620 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2z5v_A                                        
REMARK     2: T0398_1_124_272_290.pdb                       
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2z5v_A.T0398_1_124_272_290.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  141  143   5.0  103   3.09    9.71  39.140
REMARK  ---------------------------------------------------------- 
MOLECULE 2z5v_A
HEADER    IMMUNE SYSTEM                           19-JUL-07   2Z5V              
TITLE     SOLUTION STRUCTURE OF THE TIR DOMAIN OF HUMAN MYD88                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MYELOID DIFFERENTIATION PRIMARY RESPONSE PROTEIN           
COMPND   3 MYD88;                                                               
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: MYD88 TIR DOMAIN;                                          
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MYD88;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL-21 (DE3);                               
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PGEX-5X-3                                 
KEYWDS    SIGNAL TRANSDUCTION INNATE IMMUNITY, CYTOPLASM, IMMUNE                
KEYWDS   2 RESPONSE, INFLAMMATORY RESPONSE, IMMUNE SYSTEM                       
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.OHNISHI,H.TOCHIO,H.HIROAKI,N.KONDO,Z.KATO,M.SHIRAKAWA               
REVDAT   1   05-AUG-08 2Z5V    0                                                
JRNL        AUTH   H.OHNISHI,H.TOCHIO,H.HIROAKI,Z.KATO,N.KONDO,                 
JRNL        AUTH 2 M.SHIRAKAWA                                                  
JRNL        TITL   THE STRUCTURE OF THE TIR DOMAIN FROM THE CYTOSOLIC           
JRNL        TITL 2 ADAPTOR PROTEIN MYD88 REVEALS MULTIPLE INTERACTION           
JRNL        TITL 3 SITES EMPLOYED IN IL-18 AND TOLL-LIKE RECEPTOR 4             
JRNL        TITL 4 SIGNAL TRANSDUCTION                                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2Z5V A    1   149  UNP    Q99836   MYD88_HUMAN    148    296             
SEQRES   1 A  149  THR THR LEU ASP ASP PRO LEU GLY HIS MET PRO GLU ARG          
SEQRES   2 A  149  PHE ASP ALA PHE ILE CYS TYR CYS PRO SER ASP ILE GLN          
SEQRES   3 A  149  PHE VAL GLN GLU MET ILE ARG GLN LEU GLU GLN THR ASN          
SEQRES   4 A  149  TYR ARG LEU LYS LEU CYS VAL SER ASP ARG ASP VAL LEU          
SEQRES   5 A  149  PRO GLY THR CYS VAL TRP SER ILE ALA SER GLU LEU ILE          
SEQRES   6 A  149  GLU LYS ARG CYS ARG ARG MET VAL VAL VAL VAL SER ASP          
SEQRES   7 A  149  ASP TYR LEU GLN SER LYS GLU CYS ASP PHE GLN THR LYS          
SEQRES   8 A  149  PHE ALA LEU SER LEU SER PRO GLY ALA HIS GLN LYS ARG          
SEQRES   9 A  149  LEU ILE PRO ILE LYS TYR LYS ALA MET LYS LYS GLU PHE          
SEQRES  10 A  149  PRO SER ILE LEU ARG PHE ILE THR VAL CYS ASP TYR THR          
SEQRES  11 A  149  ASN PRO CYS THR LYS SER TRP PHE TRP THR ARG LEU ALA          
SEQRES  12 A  149  LYS ALA LEU SER LEU PRO                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   HIS A   9      47.846  24.384  23.046  1.00  0.00           N  
ATOM      2  CA  HIS A   9      47.356  23.848  21.783  1.00  0.00           C  
ATOM      3  C   HIS A   9      46.886  22.407  21.951  1.00  0.00           C  
ATOM      4  O   HIS A   9      47.419  21.664  22.773  1.00  0.00           O  
ATOM      5  CB  HIS A   9      48.448  23.923  20.714  1.00  0.00           C  
ATOM      6  CG  HIS A   9      48.300  25.095  19.792  1.00  0.00           C  
ATOM      7  ND1 HIS A   9      48.658  25.055  18.461  1.00  0.00           N  
ATOM      8  CD2 HIS A   9      47.829  26.344  20.017  1.00  0.00           C  
ATOM      9  CE1 HIS A   9      48.413  26.229  17.906  1.00  0.00           C  
ATOM     10  NE2 HIS A   9      47.909  27.028  18.829  1.00  0.00           N  
ATOM     11  H   HIS A   9      48.768  24.711  23.102  1.00  0.00           H  
ATOM     12  HA  HIS A   9      46.517  24.453  21.470  1.00  0.00           H  
ATOM     13  HB2 HIS A   9      49.411  24.000  21.196  1.00  0.00           H  
ATOM     14  HB3 HIS A   9      48.421  23.024  20.115  1.00  0.00           H  
ATOM     15  HD1 HIS A   9      49.034  24.281  17.992  1.00  0.00           H  
ATOM     16  HD2 HIS A   9      47.457  26.730  20.956  1.00  0.00           H  
ATOM     17  HE1 HIS A   9      48.591  26.490  16.874  1.00  0.00           H  
ATOM     18  HE2 HIS A   9      47.550  27.926  18.664  1.00  0.00           H  
ATOM     19  N   MET A  10      45.880  22.022  21.166  1.00  0.00           N  
ATOM     20  CA  MET A  10      45.320  20.670  21.219  1.00  0.00           C  
ATOM     21  C   MET A  10      46.416  19.611  21.353  1.00  0.00           C  
ATOM     22  O   MET A  10      47.049  19.235  20.367  1.00  0.00           O  
ATOM     23  CB  MET A  10      44.489  20.398  19.960  1.00  0.00           C  
ATOM     24  CG  MET A  10      43.760  19.064  19.985  1.00  0.00           C  
ATOM     25  SD  MET A  10      43.470  18.403  18.333  1.00  0.00           S  
ATOM     26  CE  MET A  10      41.808  18.994  18.020  1.00  0.00           C  
ATOM     27  H   MET A  10      45.499  22.667  20.534  1.00  0.00           H  
ATOM     28  HA  MET A  10      44.673  20.614  22.080  1.00  0.00           H  
ATOM     29  HB2 MET A  10      43.755  21.183  19.853  1.00  0.00           H  
ATOM     30  HB3 MET A  10      45.145  20.410  19.102  1.00  0.00           H  
ATOM     31  HG2 MET A  10      44.352  18.354  20.542  1.00  0.00           H  
ATOM     32  HG3 MET A  10      42.807  19.198  20.476  1.00  0.00           H  
ATOM     33  HE1 MET A  10      41.185  18.169  17.707  1.00  0.00           H  
ATOM     34  HE2 MET A  10      41.831  19.743  17.243  1.00  0.00           H  
ATOM     35  HE3 MET A  10      41.404  19.426  18.925  1.00  0.00           H  
ATOM     36  N   PRO A  11      46.655  19.112  22.581  1.00  0.00           N  
ATOM     37  CA  PRO A  11      47.678  18.092  22.833  1.00  0.00           C  
ATOM     38  C   PRO A  11      47.278  16.723  22.293  1.00  0.00           C  
ATOM     39  O   PRO A  11      46.321  16.601  21.527  1.00  0.00           O  
ATOM     40  CB  PRO A  11      47.770  18.055  24.360  1.00  0.00           C  
ATOM     41  CG  PRO A  11      46.426  18.492  24.826  1.00  0.00           C  
ATOM     42  CD  PRO A  11      45.945  19.499  23.817  1.00  0.00           C  
ATOM     43  HA  PRO A  11      48.633  18.378  22.417  1.00  0.00           H  
ATOM     44  HB2 PRO A  11      47.997  17.052  24.686  1.00  0.00           H  
ATOM     45  HB3 PRO A  11      48.542  18.733  24.694  1.00  0.00           H  
ATOM     46  HG2 PRO A  11      45.756  17.645  24.859  1.00  0.00           H  
ATOM     47  HG3 PRO A  11      46.505  18.947  25.802  1.00  0.00           H  
ATOM     48  HD2 PRO A  11      44.876  19.424  23.688  1.00  0.00           H  
ATOM     49  HD3 PRO A  11      46.219  20.497  24.124  1.00  0.00           H  
ATOM     50  N   GLU A  12      48.018  15.693  22.694  1.00  0.00           N  
ATOM     51  CA  GLU A  12      47.740  14.332  22.251  1.00  0.00           C  
ATOM     52  C   GLU A  12      46.989  13.552  23.327  1.00  0.00           C  
ATOM     53  O   GLU A  12      46.186  12.671  23.022  1.00  0.00           O  
ATOM     54  CB  GLU A  12      49.044  13.613  21.898  1.00  0.00           C  
ATOM     55  CG  GLU A  12      49.419  13.724  20.428  1.00  0.00           C  
ATOM     56  CD  GLU A  12      49.815  12.390  19.824  1.00  0.00           C  
ATOM     57  OE1 GLU A  12      49.297  11.352  20.284  1.00  0.00           O  
ATOM     58  OE2 GLU A  12      50.644  12.386  18.889  1.00  0.00           O  
ATOM     59  H   GLU A  12      48.768  15.855  23.305  1.00  0.00           H  
ATOM     60  HA  GLU A  12      47.121  14.391  21.369  1.00  0.00           H  
ATOM     61  HB2 GLU A  12      49.845  14.035  22.485  1.00  0.00           H  
ATOM     62  HB3 GLU A  12      48.942  12.566  22.143  1.00  0.00           H  
ATOM     63  HG2 GLU A  12      48.572  14.111  19.881  1.00  0.00           H  
ATOM     64  HG3 GLU A  12      50.249  14.408  20.334  1.00  0.00           H  
ATOM     65  N   ARG A  13      47.257  13.883  24.587  1.00  0.00           N  
ATOM     66  CA  ARG A  13      46.607  13.214  25.708  1.00  0.00           C  
ATOM     67  C   ARG A  13      45.599  14.141  26.381  1.00  0.00           C  
ATOM     68  O   ARG A  13      45.930  15.268  26.751  1.00  0.00           O  
ATOM     69  CB  ARG A  13      47.649  12.748  26.725  1.00  0.00           C  
ATOM     70  CG  ARG A  13      48.827  12.020  26.101  1.00  0.00           C  
ATOM     71  CD  ARG A  13      49.892  12.993  25.616  1.00  0.00           C  
ATOM     72  NE  ARG A  13      51.177  12.334  25.396  1.00  0.00           N  
ATOM     73  CZ  ARG A  13      52.157  12.849  24.657  1.00  0.00           C  
ATOM     74  NH1 ARG A  13      52.002  14.026  24.062  1.00  0.00           N  
ATOM     75  NH2 ARG A  13      53.295  12.183  24.511  1.00  0.00           N  
ATOM     76  H   ARG A  13      47.907  14.594  24.766  1.00  0.00           H  
ATOM     77  HA  ARG A  13      46.083  12.353  25.322  1.00  0.00           H  
ATOM     78  HB2 ARG A  13      48.026  13.609  27.256  1.00  0.00           H  
ATOM     79  HB3 ARG A  13      47.175  12.081  27.431  1.00  0.00           H  
ATOM     80  HG2 ARG A  13      49.265  11.364  26.839  1.00  0.00           H  
ATOM     81  HG3 ARG A  13      48.475  11.437  25.264  1.00  0.00           H  
ATOM     82  HD2 ARG A  13      49.559  13.433  24.688  1.00  0.00           H  
ATOM     83  HD3 ARG A  13      50.017  13.769  26.357  1.00  0.00           H  
ATOM     84  HE  ARG A  13      51.317  11.462  25.822  1.00  0.00           H  
ATOM     85 HH11 ARG A  13      51.147  14.532  24.169  1.00  0.00           H  
ATOM     86 HH12 ARG A  13      52.743  14.406  23.509  1.00  0.00           H  
ATOM     87 HH21 ARG A  13      53.416  11.296  24.954  1.00  0.00           H  
ATOM     88 HH22 ARG A  13      54.031  12.568  23.955  1.00  0.00           H  
ATOM     89  N   PHE A  14      44.368  13.662  26.533  1.00  0.00           N  
ATOM     90  CA  PHE A  14      43.314  14.454  27.159  1.00  0.00           C  
ATOM     91  C   PHE A  14      42.740  13.735  28.374  1.00  0.00           C  
ATOM     92  O   PHE A  14      43.072  12.579  28.642  1.00  0.00           O  
ATOM     93  CB  PHE A  14      42.202  14.745  26.151  1.00  0.00           C  
ATOM     94  CG  PHE A  14      42.597  15.737  25.096  1.00  0.00           C  
ATOM     95  CD1 PHE A  14      42.614  17.093  25.377  1.00  0.00           C  
ATOM     96  CD2 PHE A  14      42.950  15.315  23.825  1.00  0.00           C  
ATOM     97  CE1 PHE A  14      42.976  18.011  24.409  1.00  0.00           C  
ATOM     98  CE2 PHE A  14      43.314  16.227  22.853  1.00  0.00           C  
ATOM     99  CZ  PHE A  14      43.326  17.577  23.146  1.00  0.00           C  
ATOM    100  H   PHE A  14      44.162  12.759  26.215  1.00  0.00           H  
ATOM    101  HA  PHE A  14      43.746  15.388  27.482  1.00  0.00           H  
ATOM    102  HB2 PHE A  14      41.925  13.826  25.655  1.00  0.00           H  
ATOM    103  HB3 PHE A  14      41.343  15.138  26.676  1.00  0.00           H  
ATOM    104  HD1 PHE A  14      42.340  17.434  26.365  1.00  0.00           H  
ATOM    105  HD2 PHE A  14      42.941  14.259  23.595  1.00  0.00           H  
ATOM    106  HE1 PHE A  14      42.984  19.067  24.641  1.00  0.00           H  
ATOM    107  HE2 PHE A  14      43.588  15.886  21.866  1.00  0.00           H  
ATOM    108  HZ  PHE A  14      43.610  18.293  22.388  1.00  0.00           H  
ATOM    109  N   ASP A  15      41.876  14.428  29.109  1.00  0.00           N  
ATOM    110  CA  ASP A  15      41.254  13.859  30.299  1.00  0.00           C  
ATOM    111  C   ASP A  15      39.854  13.340  29.987  1.00  0.00           C  
ATOM    112  O   ASP A  15      39.597  12.139  30.059  1.00  0.00           O  
ATOM    113  CB  ASP A  15      41.191  14.903  31.417  1.00  0.00           C  
ATOM    114  CG  ASP A  15      41.931  14.461  32.666  1.00  0.00           C  
ATOM    115  OD1 ASP A  15      41.978  13.239  32.925  1.00  0.00           O  
ATOM    116  OD2 ASP A  15      42.461  15.334  33.382  1.00  0.00           O  
ATOM    117  H   ASP A  15      41.652  15.345  28.847  1.00  0.00           H  
ATOM    118  HA  ASP A  15      41.866  13.030  30.628  1.00  0.00           H  
ATOM    119  HB2 ASP A  15      41.636  15.823  31.067  1.00  0.00           H  
ATOM    120  HB3 ASP A  15      40.159  15.085  31.678  1.00  0.00           H  
ATOM    121  N   ALA A  16      38.950  14.252  29.641  1.00  0.00           N  
ATOM    122  CA  ALA A  16      37.577  13.879  29.322  1.00  0.00           C  
ATOM    123  C   ALA A  16      37.011  14.739  28.198  1.00  0.00           C  
ATOM    124  O   ALA A  16      37.633  15.710  27.768  1.00  0.00           O  
ATOM    125  CB  ALA A  16      36.694  13.991  30.558  1.00  0.00           C  
ATOM    126  H   ALA A  16      39.213  15.197  29.601  1.00  0.00           H  
ATOM    127  HA  ALA A  16      37.579  12.849  29.003  1.00  0.00           H  
ATOM    128  HB1 ALA A  16      35.752  14.446  30.288  1.00  0.00           H  
ATOM    129  HB2 ALA A  16      37.187  14.602  31.300  1.00  0.00           H  
ATOM    130  HB3 ALA A  16      36.514  13.008  30.964  1.00  0.00           H  
ATOM    131  N   PHE A  17      35.819  14.379  27.738  1.00  0.00           N  
ATOM    132  CA  PHE A  17      35.150  15.117  26.676  1.00  0.00           C  
ATOM    133  C   PHE A  17      33.814  15.664  27.169  1.00  0.00           C  
ATOM    134  O   PHE A  17      33.206  15.109  28.083  1.00  0.00           O  
ATOM    135  CB  PHE A  17      34.936  14.222  25.455  1.00  0.00           C  
ATOM    136  CG  PHE A  17      34.265  14.921  24.307  1.00  0.00           C  
ATOM    137  CD1 PHE A  17      32.883  14.935  24.198  1.00  0.00           C  
ATOM    138  CD2 PHE A  17      35.017  15.565  23.336  1.00  0.00           C  
ATOM    139  CE1 PHE A  17      32.263  15.577  23.143  1.00  0.00           C  
ATOM    140  CE2 PHE A  17      34.403  16.209  22.279  1.00  0.00           C  
ATOM    141  CZ  PHE A  17      33.025  16.215  22.182  1.00  0.00           C  
ATOM    142  H   PHE A  17      35.372  13.599  28.130  1.00  0.00           H  
ATOM    143  HA  PHE A  17      35.784  15.947  26.399  1.00  0.00           H  
ATOM    144  HB2 PHE A  17      35.892  13.861  25.111  1.00  0.00           H  
ATOM    145  HB3 PHE A  17      34.320  13.381  25.739  1.00  0.00           H  
ATOM    146  HD1 PHE A  17      32.289  14.438  24.949  1.00  0.00           H  
ATOM    147  HD2 PHE A  17      36.094  15.560  23.411  1.00  0.00           H  
ATOM    148  HE1 PHE A  17      31.186  15.581  23.070  1.00  0.00           H  
ATOM    149  HE2 PHE A  17      34.999  16.706  21.530  1.00  0.00           H  
ATOM    150  HZ  PHE A  17      32.542  16.718  21.357  1.00  0.00           H  
ATOM    151  N   ILE A  18      33.367  16.758  26.565  1.00  0.00           N  
ATOM    152  CA  ILE A  18      32.108  17.382  26.952  1.00  0.00           C  
ATOM    153  C   ILE A  18      31.041  17.199  25.877  1.00  0.00           C  
ATOM    154  O   ILE A  18      31.181  17.692  24.758  1.00  0.00           O  
ATOM    155  CB  ILE A  18      32.291  18.890  27.227  1.00  0.00           C  
ATOM    156  CG1 ILE A  18      33.325  19.109  28.334  1.00  0.00           C  
ATOM    157  CG2 ILE A  18      30.962  19.536  27.601  1.00  0.00           C  
ATOM    158  CD1 ILE A  18      32.858  18.665  29.703  1.00  0.00           C  
ATOM    159  H   ILE A  18      33.899  17.160  25.847  1.00  0.00           H  
ATOM    160  HA  ILE A  18      31.769  16.911  27.864  1.00  0.00           H  
ATOM    161  HB  ILE A  18      32.644  19.356  26.321  1.00  0.00           H  
ATOM    162 HG12 ILE A  18      34.220  18.553  28.096  1.00  0.00           H  
ATOM    163 HG13 ILE A  18      33.565  20.160  28.391  1.00  0.00           H  
ATOM    164 HG21 ILE A  18      30.610  19.124  28.536  1.00  0.00           H  
ATOM    165 HG22 ILE A  18      30.236  19.339  26.827  1.00  0.00           H  
ATOM    166 HG23 ILE A  18      31.097  20.602  27.706  1.00  0.00           H  
ATOM    167 HD11 ILE A  18      33.089  17.619  29.840  1.00  0.00           H  
ATOM    168 HD12 ILE A  18      31.792  18.812  29.787  1.00  0.00           H  
ATOM    169 HD13 ILE A  18      33.362  19.246  30.460  1.00  0.00           H  
ATOM    170  N   CYS A  19      29.968  16.499  26.233  1.00  0.00           N  
ATOM    171  CA  CYS A  19      28.869  16.267  25.307  1.00  0.00           C  
ATOM    172  C   CYS A  19      27.649  17.077  25.732  1.00  0.00           C  
ATOM    173  O   CYS A  19      26.886  16.658  26.604  1.00  0.00           O  
ATOM    174  CB  CYS A  19      28.516  14.779  25.258  1.00  0.00           C  
ATOM    175  SG  CYS A  19      29.750  13.757  24.415  1.00  0.00           S  
ATOM    176  H   CYS A  19      29.911  16.142  27.144  1.00  0.00           H  
ATOM    177  HA  CYS A  19      29.181  16.591  24.326  1.00  0.00           H  
ATOM    178  HB2 CYS A  19      28.415  14.405  26.265  1.00  0.00           H  
ATOM    179  HB3 CYS A  19      27.577  14.656  24.738  1.00  0.00           H  
ATOM    180  HG  CYS A  19      30.127  13.156  25.061  1.00  0.00           H  
ATOM    181  N   TYR A  20      27.478  18.246  25.125  1.00  0.00           N  
ATOM    182  CA  TYR A  20      26.358  19.119  25.457  1.00  0.00           C  
ATOM    183  C   TYR A  20      25.559  19.504  24.216  1.00  0.00           C  
ATOM    184  O   TYR A  20      25.941  19.185  23.091  1.00  0.00           O  
ATOM    185  CB  TYR A  20      26.859  20.379  26.172  1.00  0.00           C  
ATOM    186  CG  TYR A  20      28.004  21.082  25.472  1.00  0.00           C  
ATOM    187  CD1 TYR A  20      27.956  21.373  24.111  1.00  0.00           C  
ATOM    188  CD2 TYR A  20      29.139  21.463  26.178  1.00  0.00           C  
ATOM    189  CE1 TYR A  20      29.002  22.019  23.481  1.00  0.00           C  
ATOM    190  CE2 TYR A  20      30.188  22.111  25.554  1.00  0.00           C  
ATOM    191  CZ  TYR A  20      30.113  22.385  24.205  1.00  0.00           C  
ATOM    192  OH  TYR A  20      31.155  23.032  23.580  1.00  0.00           O  
ATOM    193  H   TYR A  20      28.124  18.534  24.446  1.00  0.00           H  
ATOM    194  HA  TYR A  20      25.709  18.576  26.128  1.00  0.00           H  
ATOM    195  HB2 TYR A  20      26.045  21.082  26.256  1.00  0.00           H  
ATOM    196  HB3 TYR A  20      27.194  20.108  27.163  1.00  0.00           H  
ATOM    197  HD1 TYR A  20      27.084  21.089  23.543  1.00  0.00           H  
ATOM    198  HD2 TYR A  20      29.195  21.246  27.236  1.00  0.00           H  
ATOM    199  HE1 TYR A  20      28.943  22.234  22.424  1.00  0.00           H  
ATOM    200  HE2 TYR A  20      31.060  22.399  26.123  1.00  0.00           H  
ATOM    201  HH  TYR A  20      30.807  23.659  22.943  1.00  0.00           H  
ATOM    202  N   CYS A  21      24.452  20.203  24.440  1.00  0.00           N  
ATOM    203  CA  CYS A  21      23.588  20.650  23.354  1.00  0.00           C  
ATOM    204  C   CYS A  21      23.635  22.171  23.223  1.00  0.00           C  
ATOM    205  O   CYS A  21      23.896  22.876  24.199  1.00  0.00           O  
ATOM    206  CB  CYS A  21      22.149  20.189  23.594  1.00  0.00           C  
ATOM    207  SG  CYS A  21      21.753  18.588  22.854  1.00  0.00           S  
ATOM    208  H   CYS A  21      24.210  20.429  25.359  1.00  0.00           H  
ATOM    209  HA  CYS A  21      23.951  20.209  22.436  1.00  0.00           H  
ATOM    210  HB2 CYS A  21      21.976  20.111  24.657  1.00  0.00           H  
ATOM    211  HB3 CYS A  21      21.471  20.921  23.178  1.00  0.00           H  
ATOM    212  HG  CYS A  21      21.097  18.160  23.409  1.00  0.00           H  
ATOM    213  N   PRO A  22      23.387  22.699  22.012  1.00  0.00           N  
ATOM    214  CA  PRO A  22      23.408  24.146  21.763  1.00  0.00           C  
ATOM    215  C   PRO A  22      22.229  24.884  22.400  1.00  0.00           C  
ATOM    216  O   PRO A  22      22.104  26.100  22.257  1.00  0.00           O  
ATOM    217  CB  PRO A  22      23.331  24.242  20.238  1.00  0.00           C  
ATOM    218  CG  PRO A  22      22.644  22.989  19.816  1.00  0.00           C  
ATOM    219  CD  PRO A  22      23.072  21.931  20.795  1.00  0.00           C  
ATOM    220  HA  PRO A  22      24.332  24.590  22.105  1.00  0.00           H  
ATOM    221  HB2 PRO A  22      22.765  25.118  19.959  1.00  0.00           H  
ATOM    222  HB3 PRO A  22      24.327  24.301  19.827  1.00  0.00           H  
ATOM    223  HG2 PRO A  22      21.574  23.127  19.855  1.00  0.00           H  
ATOM    224  HG3 PRO A  22      22.952  22.722  18.816  1.00  0.00           H  
ATOM    225  HD2 PRO A  22      22.264  21.235  20.975  1.00  0.00           H  
ATOM    226  HD3 PRO A  22      23.945  21.412  20.430  1.00  0.00           H  
ATOM    227  N   SER A  23      21.368  24.151  23.104  1.00  0.00           N  
ATOM    228  CA  SER A  23      20.211  24.753  23.756  1.00  0.00           C  
ATOM    229  C   SER A  23      20.630  25.486  25.024  1.00  0.00           C  
ATOM    230  O   SER A  23      20.072  26.529  25.367  1.00  0.00           O  
ATOM    231  CB  SER A  23      19.174  23.683  24.094  1.00  0.00           C  
ATOM    232  OG  SER A  23      19.543  22.966  25.260  1.00  0.00           O  
ATOM    233  H   SER A  23      21.512  23.191  23.191  1.00  0.00           H  
ATOM    234  HA  SER A  23      19.775  25.464  23.070  1.00  0.00           H  
ATOM    235  HB2 SER A  23      18.217  24.152  24.264  1.00  0.00           H  
ATOM    236  HB3 SER A  23      19.093  22.988  23.271  1.00  0.00           H  
ATOM    237  HG  SER A  23      20.287  22.392  25.061  1.00  0.00           H  
ATOM    238  N   ASP A  24      21.619  24.932  25.718  1.00  0.00           N  
ATOM    239  CA  ASP A  24      22.116  25.531  26.948  1.00  0.00           C  
ATOM    240  C   ASP A  24      23.595  25.214  27.151  1.00  0.00           C  
ATOM    241  O   ASP A  24      24.004  24.754  28.216  1.00  0.00           O  
ATOM    242  CB  ASP A  24      21.303  25.033  28.147  1.00  0.00           C  
ATOM    243  CG  ASP A  24      21.361  25.993  29.321  1.00  0.00           C  
ATOM    244  OD1 ASP A  24      21.253  27.216  29.095  1.00  0.00           O  
ATOM    245  OD2 ASP A  24      21.512  25.520  30.466  1.00  0.00           O  
ATOM    246  H   ASP A  24      22.024  24.101  25.393  1.00  0.00           H  
ATOM    247  HA  ASP A  24      21.998  26.599  26.863  1.00  0.00           H  
ATOM    248  HB2 ASP A  24      20.271  24.919  27.851  1.00  0.00           H  
ATOM    249  HB3 ASP A  24      21.690  24.078  28.465  1.00  0.00           H  
ATOM    250  N   ILE A  25      24.391  25.462  26.117  1.00  0.00           N  
ATOM    251  CA  ILE A  25      25.824  25.205  26.177  1.00  0.00           C  
ATOM    252  C   ILE A  25      26.531  26.224  27.067  1.00  0.00           C  
ATOM    253  O   ILE A  25      27.435  25.878  27.826  1.00  0.00           O  
ATOM    254  CB  ILE A  25      26.456  25.228  24.768  1.00  0.00           C  
ATOM    255  CG1 ILE A  25      27.816  24.524  24.776  1.00  0.00           C  
ATOM    256  CG2 ILE A  25      26.588  26.658  24.257  1.00  0.00           C  
ATOM    257  CD1 ILE A  25      28.892  25.270  25.538  1.00  0.00           C  
ATOM    258  H   ILE A  25      24.005  25.829  25.293  1.00  0.00           H  
ATOM    259  HA  ILE A  25      25.967  24.219  26.594  1.00  0.00           H  
ATOM    260  HB  ILE A  25      25.794  24.699  24.099  1.00  0.00           H  
ATOM    261 HG12 ILE A  25      27.705  23.553  25.231  1.00  0.00           H  
ATOM    262 HG13 ILE A  25      28.155  24.402  23.759  1.00  0.00           H  
ATOM    263 HG21 ILE A  25      27.367  27.164  24.805  1.00  0.00           H  
ATOM    264 HG22 ILE A  25      25.652  27.178  24.397  1.00  0.00           H  
ATOM    265 HG23 ILE A  25      26.837  26.643  23.207  1.00  0.00           H  
ATOM    266 HD11 ILE A  25      29.817  25.235  24.982  1.00  0.00           H  
ATOM    267 HD12 ILE A  25      29.035  24.808  26.505  1.00  0.00           H  
ATOM    268 HD13 ILE A  25      28.592  26.298  25.673  1.00  0.00           H  
ATOM    269  N   GLN A  26      26.111  27.484  26.961  1.00  0.00           N  
ATOM    270  CA  GLN A  26      26.701  28.564  27.752  1.00  0.00           C  
ATOM    271  C   GLN A  26      26.866  28.153  29.211  1.00  0.00           C  
ATOM    272  O   GLN A  26      27.905  28.401  29.824  1.00  0.00           O  
ATOM    273  CB  GLN A  26      25.832  29.819  27.661  1.00  0.00           C  
ATOM    274  CG  GLN A  26      25.685  30.360  26.248  1.00  0.00           C  
ATOM    275  CD  GLN A  26      24.432  31.194  26.071  1.00  0.00           C  
ATOM    276  OE1 GLN A  26      24.420  32.387  26.372  1.00  0.00           O  
ATOM    277  NE2 GLN A  26      23.368  30.568  25.581  1.00  0.00           N  
ATOM    278  H   GLN A  26      25.387  27.691  26.335  1.00  0.00           H  
ATOM    279  HA  GLN A  26      27.672  28.780  27.340  1.00  0.00           H  
ATOM    280  HB2 GLN A  26      24.847  29.590  28.040  1.00  0.00           H  
ATOM    281  HB3 GLN A  26      26.272  30.591  28.274  1.00  0.00           H  
ATOM    282  HG2 GLN A  26      26.542  30.973  26.020  1.00  0.00           H  
ATOM    283  HG3 GLN A  26      25.644  29.526  25.560  1.00  0.00           H  
ATOM    284 HE21 GLN A  26      23.450  29.615  25.365  1.00  0.00           H  
ATOM    285 HE22 GLN A  26      22.544  31.083  25.457  1.00  0.00           H  
ATOM    286  N   PHE A  27      25.836  27.522  29.756  1.00  0.00           N  
ATOM    287  CA  PHE A  27      25.864  27.071  31.143  1.00  0.00           C  
ATOM    288  C   PHE A  27      26.894  25.964  31.329  1.00  0.00           C  
ATOM    289  O   PHE A  27      27.683  25.989  32.276  1.00  0.00           O  
ATOM    290  CB  PHE A  27      24.480  26.575  31.569  1.00  0.00           C  
ATOM    291  CG  PHE A  27      24.375  26.288  33.041  1.00  0.00           C  
ATOM    292  CD1 PHE A  27      24.274  27.322  33.956  1.00  0.00           C  
ATOM    293  CD2 PHE A  27      24.379  24.981  33.506  1.00  0.00           C  
ATOM    294  CE1 PHE A  27      24.177  27.061  35.310  1.00  0.00           C  
ATOM    295  CE2 PHE A  27      24.283  24.715  34.858  1.00  0.00           C  
ATOM    296  CZ  PHE A  27      24.182  25.755  35.761  1.00  0.00           C  
ATOM    297  H   PHE A  27      25.040  27.351  29.211  1.00  0.00           H  
ATOM    298  HA  PHE A  27      26.140  27.914  31.760  1.00  0.00           H  
ATOM    299  HB2 PHE A  27      23.745  27.326  31.325  1.00  0.00           H  
ATOM    300  HB3 PHE A  27      24.251  25.666  31.035  1.00  0.00           H  
ATOM    301  HD1 PHE A  27      24.270  28.344  33.604  1.00  0.00           H  
ATOM    302  HD2 PHE A  27      24.457  24.168  32.801  1.00  0.00           H  
ATOM    303  HE1 PHE A  27      24.099  27.875  36.013  1.00  0.00           H  
ATOM    304  HE2 PHE A  27      24.287  23.693  35.209  1.00  0.00           H  
ATOM    305  HZ  PHE A  27      24.107  25.548  36.819  1.00  0.00           H  
ATOM    306  N   VAL A  28      26.883  24.996  30.423  1.00  0.00           N  
ATOM    307  CA  VAL A  28      27.817  23.880  30.484  1.00  0.00           C  
ATOM    308  C   VAL A  28      29.260  24.370  30.422  1.00  0.00           C  
ATOM    309  O   VAL A  28      30.061  24.079  31.307  1.00  0.00           O  
ATOM    310  CB  VAL A  28      27.579  22.879  29.339  1.00  0.00           C  
ATOM    311  CG1 VAL A  28      28.378  21.605  29.566  1.00  0.00           C  
ATOM    312  CG2 VAL A  28      26.096  22.570  29.198  1.00  0.00           C  
ATOM    313  H   VAL A  28      26.232  25.033  29.691  1.00  0.00           H  
ATOM    314  HA  VAL A  28      27.662  23.367  31.420  1.00  0.00           H  
ATOM    315  HB  VAL A  28      27.919  23.330  28.417  1.00  0.00           H  
ATOM    316 HG11 VAL A  28      28.078  20.858  28.847  1.00  0.00           H  
ATOM    317 HG12 VAL A  28      28.195  21.238  30.565  1.00  0.00           H  
ATOM    318 HG13 VAL A  28      29.431  21.815  29.448  1.00  0.00           H  
ATOM    319 HG21 VAL A  28      25.972  21.557  28.844  1.00  0.00           H  
ATOM    320 HG22 VAL A  28      25.650  23.255  28.493  1.00  0.00           H  
ATOM    321 HG23 VAL A  28      25.615  22.677  30.160  1.00  0.00           H  
ATOM    322  N   GLN A  29      29.582  25.118  29.370  1.00  0.00           N  
ATOM    323  CA  GLN A  29      30.923  25.651  29.190  1.00  0.00           C  
ATOM    324  C   GLN A  29      31.401  26.370  30.448  1.00  0.00           C  
ATOM    325  O   GLN A  29      32.572  26.280  30.816  1.00  0.00           O  
ATOM    326  CB  GLN A  29      30.953  26.601  27.993  1.00  0.00           C  
ATOM    327  CG  GLN A  29      30.023  27.795  28.135  1.00  0.00           C  
ATOM    328  CD  GLN A  29      30.348  28.903  27.152  1.00  0.00           C  
ATOM    329  OE1 GLN A  29      31.230  29.727  27.397  1.00  0.00           O  
ATOM    330  NE2 GLN A  29      29.634  28.929  26.031  1.00  0.00           N  
ATOM    331  H   GLN A  29      28.900  25.320  28.697  1.00  0.00           H  
ATOM    332  HA  GLN A  29      31.584  24.820  28.993  1.00  0.00           H  
ATOM    333  HB2 GLN A  29      31.956  26.967  27.869  1.00  0.00           H  
ATOM    334  HB3 GLN A  29      30.667  26.053  27.107  1.00  0.00           H  
ATOM    335  HG2 GLN A  29      29.009  27.468  27.964  1.00  0.00           H  
ATOM    336  HG3 GLN A  29      30.110  28.187  29.137  1.00  0.00           H  
ATOM    337 HE21 GLN A  29      28.948  28.242  25.902  1.00  0.00           H  
ATOM    338 HE22 GLN A  29      29.823  29.635  25.378  1.00  0.00           H  
ATOM    339  N   GLU A  30      30.488  27.075  31.108  1.00  0.00           N  
ATOM    340  CA  GLU A  30      30.819  27.799  32.328  1.00  0.00           C  
ATOM    341  C   GLU A  30      31.300  26.830  33.405  1.00  0.00           C  
ATOM    342  O   GLU A  30      32.268  27.099  34.117  1.00  0.00           O  
ATOM    343  CB  GLU A  30      29.607  28.585  32.832  1.00  0.00           C  
ATOM    344  CG  GLU A  30      29.681  30.073  32.532  1.00  0.00           C  
ATOM    345  CD  GLU A  30      28.789  30.482  31.375  1.00  0.00           C  
ATOM    346  OE1 GLU A  30      27.561  30.282  31.473  1.00  0.00           O  
ATOM    347  OE2 GLU A  30      29.321  31.001  30.372  1.00  0.00           O  
ATOM    348  H   GLU A  30      29.567  27.103  30.768  1.00  0.00           H  
ATOM    349  HA  GLU A  30      31.618  28.490  32.100  1.00  0.00           H  
ATOM    350  HB2 GLU A  30      28.717  28.190  32.361  1.00  0.00           H  
ATOM    351  HB3 GLU A  30      29.524  28.458  33.900  1.00  0.00           H  
ATOM    352  HG2 GLU A  30      29.374  30.619  33.413  1.00  0.00           H  
ATOM    353  HG3 GLU A  30      30.702  30.328  32.290  1.00  0.00           H  
ATOM    354  N   MET A  31      30.619  25.695  33.508  1.00  0.00           N  
ATOM    355  CA  MET A  31      30.976  24.677  34.486  1.00  0.00           C  
ATOM    356  C   MET A  31      32.293  24.010  34.102  1.00  0.00           C  
ATOM    357  O   MET A  31      33.173  23.822  34.941  1.00  0.00           O  
ATOM    358  CB  MET A  31      29.862  23.629  34.586  1.00  0.00           C  
ATOM    359  CG  MET A  31      30.235  22.410  35.417  1.00  0.00           C  
ATOM    360  SD  MET A  31      28.947  21.147  35.413  1.00  0.00           S  
ATOM    361  CE  MET A  31      28.571  21.051  33.664  1.00  0.00           C  
ATOM    362  H   MET A  31      29.859  25.536  32.907  1.00  0.00           H  
ATOM    363  HA  MET A  31      31.094  25.161  35.444  1.00  0.00           H  
ATOM    364  HB2 MET A  31      28.993  24.090  35.034  1.00  0.00           H  
ATOM    365  HB3 MET A  31      29.609  23.298  33.592  1.00  0.00           H  
ATOM    366  HG2 MET A  31      31.140  21.980  35.015  1.00  0.00           H  
ATOM    367  HG3 MET A  31      30.409  22.724  36.436  1.00  0.00           H  
ATOM    368  HE1 MET A  31      27.908  21.859  33.394  1.00  0.00           H  
ATOM    369  HE2 MET A  31      28.094  20.107  33.450  1.00  0.00           H  
ATOM    370  HE3 MET A  31      29.485  21.130  33.094  1.00  0.00           H  
ATOM    371  N   ILE A  32      32.420  23.657  32.827  1.00  0.00           N  
ATOM    372  CA  ILE A  32      33.627  23.011  32.329  1.00  0.00           C  
ATOM    373  C   ILE A  32      34.849  23.903  32.514  1.00  0.00           C  
ATOM    374  O   ILE A  32      35.832  23.501  33.139  1.00  0.00           O  
ATOM    375  CB  ILE A  32      33.488  22.641  30.835  1.00  0.00           C  
ATOM    376  CG1 ILE A  32      32.211  21.828  30.593  1.00  0.00           C  
ATOM    377  CG2 ILE A  32      34.714  21.870  30.360  1.00  0.00           C  
ATOM    378  CD1 ILE A  32      31.905  20.819  31.680  1.00  0.00           C  
ATOM    379  H   ILE A  32      31.682  23.837  32.207  1.00  0.00           H  
ATOM    380  HA  ILE A  32      33.771  22.101  32.892  1.00  0.00           H  
ATOM    381  HB  ILE A  32      33.433  23.558  30.266  1.00  0.00           H  
ATOM    382 HG12 ILE A  32      31.371  22.501  30.523  1.00  0.00           H  
ATOM    383 HG13 ILE A  32      32.309  21.290  29.660  1.00  0.00           H  
ATOM    384 HG21 ILE A  32      35.414  21.765  31.176  1.00  0.00           H  
ATOM    385 HG22 ILE A  32      35.184  22.407  29.549  1.00  0.00           H  
ATOM    386 HG23 ILE A  32      34.413  20.893  30.015  1.00  0.00           H  
ATOM    387 HD11 ILE A  32      32.825  20.370  32.025  1.00  0.00           H  
ATOM    388 HD12 ILE A  32      31.254  20.051  31.287  1.00  0.00           H  
ATOM    389 HD13 ILE A  32      31.416  21.317  32.505  1.00  0.00           H  
ATOM    390  N   ARG A  33      34.789  25.117  31.972  1.00  0.00           N  
ATOM    391  CA  ARG A  33      35.891  26.059  32.082  1.00  0.00           C  
ATOM    392  C   ARG A  33      36.280  26.270  33.542  1.00  0.00           C  
ATOM    393  O   ARG A  33      37.459  26.437  33.865  1.00  0.00           O  
ATOM    394  CB  ARG A  33      35.510  27.390  31.437  1.00  0.00           C  
ATOM    395  CG  ARG A  33      34.269  28.027  32.041  1.00  0.00           C  
ATOM    396  CD  ARG A  33      34.627  29.060  33.099  1.00  0.00           C  
ATOM    397  NE  ARG A  33      33.887  30.307  32.917  1.00  0.00           N  
ATOM    398  CZ  ARG A  33      34.148  31.190  31.957  1.00  0.00           C  
ATOM    399  NH1 ARG A  33      35.131  30.970  31.092  1.00  0.00           N  
ATOM    400  NH2 ARG A  33      33.424  32.295  31.859  1.00  0.00           N  
ATOM    401  H   ARG A  33      33.984  25.387  31.486  1.00  0.00           H  
ATOM    402  HA  ARG A  33      36.736  25.644  31.552  1.00  0.00           H  
ATOM    403  HB2 ARG A  33      36.330  28.076  31.552  1.00  0.00           H  
ATOM    404  HB3 ARG A  33      35.329  27.229  30.385  1.00  0.00           H  
ATOM    405  HG2 ARG A  33      33.707  28.511  31.256  1.00  0.00           H  
ATOM    406  HG3 ARG A  33      33.667  27.255  32.493  1.00  0.00           H  
ATOM    407  HD2 ARG A  33      34.395  28.654  34.072  1.00  0.00           H  
ATOM    408  HD3 ARG A  33      35.684  29.268  33.039  1.00  0.00           H  
ATOM    409  HE  ARG A  33      33.157  30.494  33.541  1.00  0.00           H  
ATOM    410 HH11 ARG A  33      35.682  30.138  31.160  1.00  0.00           H  
ATOM    411 HH12 ARG A  33      35.323  31.638  30.372  1.00  0.00           H  
ATOM    412 HH21 ARG A  33      32.682  32.467  32.507  1.00  0.00           H  
ATOM    413 HH22 ARG A  33      33.620  32.961  31.135  1.00  0.00           H  
ATOM    414  N   GLN A  34      35.284  26.249  34.423  1.00  0.00           N  
ATOM    415  CA  GLN A  34      35.523  26.428  35.848  1.00  0.00           C  
ATOM    416  C   GLN A  34      36.093  25.153  36.461  1.00  0.00           C  
ATOM    417  O   GLN A  34      36.707  25.186  37.527  1.00  0.00           O  
ATOM    418  CB  GLN A  34      34.225  26.816  36.560  1.00  0.00           C  
ATOM    419  CG  GLN A  34      34.447  27.477  37.911  1.00  0.00           C  
ATOM    420  CD  GLN A  34      34.254  28.978  37.863  1.00  0.00           C  
ATOM    421  OE1 GLN A  34      33.145  29.481  38.049  1.00  0.00           O  
ATOM    422  NE2 GLN A  34      35.335  29.707  37.613  1.00  0.00           N  
ATOM    423  H   GLN A  34      34.369  26.100  34.108  1.00  0.00           H  
ATOM    424  HA  GLN A  34      36.240  27.224  35.968  1.00  0.00           H  
ATOM    425  HB2 GLN A  34      33.675  27.502  35.932  1.00  0.00           H  
ATOM    426  HB3 GLN A  34      33.631  25.925  36.711  1.00  0.00           H  
ATOM    427  HG2 GLN A  34      33.745  27.061  38.619  1.00  0.00           H  
ATOM    428  HG3 GLN A  34      35.454  27.266  38.239  1.00  0.00           H  
ATOM    429 HE21 GLN A  34      36.186  29.240  37.475  1.00  0.00           H  
ATOM    430 HE22 GLN A  34      35.240  30.681  37.577  1.00  0.00           H  
ATOM    431  N   LEU A  35      35.880  24.029  35.783  1.00  0.00           N  
ATOM    432  CA  LEU A  35      36.367  22.746  36.259  1.00  0.00           C  
ATOM    433  C   LEU A  35      37.819  22.521  35.845  1.00  0.00           C  
ATOM    434  O   LEU A  35      38.586  21.878  36.561  1.00  0.00           O  
ATOM    435  CB  LEU A  35      35.492  21.617  35.714  1.00  0.00           C  
ATOM    436  CG  LEU A  35      34.170  21.405  36.455  1.00  0.00           C  
ATOM    437  CD1 LEU A  35      33.301  20.400  35.717  1.00  0.00           C  
ATOM    438  CD2 LEU A  35      34.427  20.946  37.881  1.00  0.00           C  
ATOM    439  H   LEU A  35      35.381  24.064  34.942  1.00  0.00           H  
ATOM    440  HA  LEU A  35      36.307  22.749  37.334  1.00  0.00           H  
ATOM    441  HB2 LEU A  35      35.269  21.831  34.678  1.00  0.00           H  
ATOM    442  HB3 LEU A  35      36.055  20.700  35.760  1.00  0.00           H  
ATOM    443  HG  LEU A  35      33.634  22.342  36.496  1.00  0.00           H  
ATOM    444 HD11 LEU A  35      33.714  19.409  35.838  1.00  0.00           H  
ATOM    445 HD12 LEU A  35      33.270  20.651  34.667  1.00  0.00           H  
ATOM    446 HD13 LEU A  35      32.300  20.425  36.122  1.00  0.00           H  
ATOM    447 HD21 LEU A  35      34.244  19.884  37.955  1.00  0.00           H  
ATOM    448 HD22 LEU A  35      33.765  21.473  38.553  1.00  0.00           H  
ATOM    449 HD23 LEU A  35      35.452  21.154  38.147  1.00  0.00           H  
ATOM    450  N   GLU A  36      38.187  23.050  34.684  1.00  0.00           N  
ATOM    451  CA  GLU A  36      39.546  22.903  34.173  1.00  0.00           C  
ATOM    452  C   GLU A  36      40.511  23.838  34.894  1.00  0.00           C  
ATOM    453  O   GLU A  36      41.663  23.485  35.141  1.00  0.00           O  
ATOM    454  CB  GLU A  36      39.585  23.173  32.667  1.00  0.00           C  
ATOM    455  CG  GLU A  36      38.838  24.429  32.256  1.00  0.00           C  
ATOM    456  CD  GLU A  36      39.168  24.869  30.843  1.00  0.00           C  
ATOM    457  OE1 GLU A  36      38.586  24.304  29.895  1.00  0.00           O  
ATOM    458  OE2 GLU A  36      40.009  25.779  30.686  1.00  0.00           O  
ATOM    459  H   GLU A  36      37.528  23.549  34.156  1.00  0.00           H  
ATOM    460  HA  GLU A  36      39.855  21.885  34.352  1.00  0.00           H  
ATOM    461  HB2 GLU A  36      40.615  23.276  32.358  1.00  0.00           H  
ATOM    462  HB3 GLU A  36      39.144  22.334  32.151  1.00  0.00           H  
ATOM    463  HG2 GLU A  36      37.779  24.237  32.317  1.00  0.00           H  
ATOM    464  HG3 GLU A  36      39.100  25.228  32.936  1.00  0.00           H  
ATOM    465  N   GLN A  37      40.033  25.031  35.228  1.00  0.00           N  
ATOM    466  CA  GLN A  37      40.855  26.015  35.919  1.00  0.00           C  
ATOM    467  C   GLN A  37      41.110  25.614  37.373  1.00  0.00           C  
ATOM    468  O   GLN A  37      41.892  26.258  38.070  1.00  0.00           O  
ATOM    469  CB  GLN A  37      40.181  27.385  35.865  1.00  0.00           C  
ATOM    470  CG  GLN A  37      38.752  27.384  36.381  1.00  0.00           C  
ATOM    471  CD  GLN A  37      38.557  28.311  37.564  1.00  0.00           C  
ATOM    472  OE1 GLN A  37      38.091  29.442  37.410  1.00  0.00           O  
ATOM    473  NE2 GLN A  37      38.914  27.841  38.753  1.00  0.00           N  
ATOM    474  H   GLN A  37      39.107  25.261  35.004  1.00  0.00           H  
ATOM    475  HA  GLN A  37      41.802  26.071  35.404  1.00  0.00           H  
ATOM    476  HB2 GLN A  37      40.755  28.072  36.459  1.00  0.00           H  
ATOM    477  HB3 GLN A  37      40.171  27.727  34.841  1.00  0.00           H  
ATOM    478  HG2 GLN A  37      38.096  27.698  35.584  1.00  0.00           H  
ATOM    479  HG3 GLN A  37      38.493  26.380  36.682  1.00  0.00           H  
ATOM    480 HE21 GLN A  37      39.278  26.932  38.799  1.00  0.00           H  
ATOM    481 HE22 GLN A  37      38.798  28.420  39.535  1.00  0.00           H  
ATOM    482  N   THR A  38      40.446  24.552  37.829  1.00  0.00           N  
ATOM    483  CA  THR A  38      40.609  24.078  39.200  1.00  0.00           C  
ATOM    484  C   THR A  38      42.082  23.873  39.543  1.00  0.00           C  
ATOM    485  O   THR A  38      42.962  24.109  38.715  1.00  0.00           O  
ATOM    486  CB  THR A  38      39.843  22.768  39.403  1.00  0.00           C  
ATOM    487  OG1 THR A  38      40.224  21.810  38.431  1.00  0.00           O  
ATOM    488  CG2 THR A  38      38.340  22.934  39.321  1.00  0.00           C  
ATOM    489  H   THR A  38      39.833  24.077  37.233  1.00  0.00           H  
ATOM    490  HA  THR A  38      40.200  24.827  39.860  1.00  0.00           H  
ATOM    491  HB  THR A  38      40.080  22.372  40.380  1.00  0.00           H  
ATOM    492  HG1 THR A  38      40.750  21.125  38.846  1.00  0.00           H  
ATOM    493 HG21 THR A  38      38.061  23.186  38.309  1.00  0.00           H  
ATOM    494 HG22 THR A  38      38.029  23.725  39.987  1.00  0.00           H  
ATOM    495 HG23 THR A  38      37.861  22.011  39.609  1.00  0.00           H  
ATOM    496  N   ASN A  39      42.344  23.436  40.770  1.00  0.00           N  
ATOM    497  CA  ASN A  39      43.710  23.202  41.226  1.00  0.00           C  
ATOM    498  C   ASN A  39      44.327  22.002  40.512  1.00  0.00           C  
ATOM    499  O   ASN A  39      45.460  22.067  40.037  1.00  0.00           O  
ATOM    500  CB  ASN A  39      43.733  22.977  42.739  1.00  0.00           C  
ATOM    501  CG  ASN A  39      43.007  24.071  43.496  1.00  0.00           C  
ATOM    502  OD1 ASN A  39      42.985  25.227  43.073  1.00  0.00           O  
ATOM    503  ND2 ASN A  39      42.405  23.711  44.623  1.00  0.00           N  
ATOM    504  H   ASN A  39      41.600  23.267  41.386  1.00  0.00           H  
ATOM    505  HA  ASN A  39      44.290  24.081  40.992  1.00  0.00           H  
ATOM    506  HB2 ASN A  39      43.260  22.034  42.963  1.00  0.00           H  
ATOM    507  HB3 ASN A  39      44.759  22.951  43.076  1.00  0.00           H  
ATOM    508 HD21 ASN A  39      42.464  22.773  44.900  1.00  0.00           H  
ATOM    509 HD22 ASN A  39      41.928  24.398  45.133  1.00  0.00           H  
ATOM    510  N   TYR A  40      43.575  20.908  40.445  1.00  0.00           N  
ATOM    511  CA  TYR A  40      44.051  19.695  39.791  1.00  0.00           C  
ATOM    512  C   TYR A  40      44.199  19.908  38.288  1.00  0.00           C  
ATOM    513  O   TYR A  40      43.526  20.755  37.701  1.00  0.00           O  
ATOM    514  CB  TYR A  40      43.090  18.535  40.063  1.00  0.00           C  
ATOM    515  CG  TYR A  40      43.559  17.603  41.157  1.00  0.00           C  
ATOM    516  CD1 TYR A  40      44.008  18.098  42.374  1.00  0.00           C  
ATOM    517  CD2 TYR A  40      43.552  16.225  40.972  1.00  0.00           C  
ATOM    518  CE1 TYR A  40      44.437  17.250  43.377  1.00  0.00           C  
ATOM    519  CE2 TYR A  40      43.979  15.369  41.969  1.00  0.00           C  
ATOM    520  CZ  TYR A  40      44.420  15.885  43.169  1.00  0.00           C  
ATOM    521  OH  TYR A  40      44.847  15.036  44.164  1.00  0.00           O  
ATOM    522  H   TYR A  40      42.681  20.917  40.844  1.00  0.00           H  
ATOM    523  HA  TYR A  40      45.018  19.453  40.205  1.00  0.00           H  
ATOM    524  HB2 TYR A  40      42.130  18.932  40.357  1.00  0.00           H  
ATOM    525  HB3 TYR A  40      42.972  17.954  39.159  1.00  0.00           H  
ATOM    526  HD1 TYR A  40      44.019  19.166  42.534  1.00  0.00           H  
ATOM    527  HD2 TYR A  40      43.206  15.824  40.032  1.00  0.00           H  
ATOM    528  HE1 TYR A  40      44.783  17.654  44.315  1.00  0.00           H  
ATOM    529  HE2 TYR A  40      43.965  14.302  41.806  1.00  0.00           H  
ATOM    530  HH  TYR A  40      44.169  14.973  44.843  1.00  0.00           H  
ATOM    531  N   ARG A  41      45.085  19.132  37.671  1.00  0.00           N  
ATOM    532  CA  ARG A  41      45.323  19.233  36.235  1.00  0.00           C  
ATOM    533  C   ARG A  41      44.215  18.536  35.452  1.00  0.00           C  
ATOM    534  O   ARG A  41      44.314  17.346  35.146  1.00  0.00           O  
ATOM    535  CB  ARG A  41      46.679  18.623  35.878  1.00  0.00           C  
ATOM    536  CG  ARG A  41      47.843  19.232  36.642  1.00  0.00           C  
ATOM    537  CD  ARG A  41      49.080  18.352  36.570  1.00  0.00           C  
ATOM    538  NE  ARG A  41      50.078  18.883  35.645  1.00  0.00           N  
ATOM    539  CZ  ARG A  41      50.905  19.883  35.939  1.00  0.00           C  
ATOM    540  NH1 ARG A  41      50.858  20.462  37.132  1.00  0.00           N  
ATOM    541  NH2 ARG A  41      51.781  20.304  35.038  1.00  0.00           N  
ATOM    542  H   ARG A  41      45.590  18.474  38.193  1.00  0.00           H  
ATOM    543  HA  ARG A  41      45.329  20.281  35.973  1.00  0.00           H  
ATOM    544  HB2 ARG A  41      46.652  17.563  36.092  1.00  0.00           H  
ATOM    545  HB3 ARG A  41      46.857  18.762  34.822  1.00  0.00           H  
ATOM    546  HG2 ARG A  41      48.075  20.198  36.215  1.00  0.00           H  
ATOM    547  HG3 ARG A  41      47.557  19.355  37.676  1.00  0.00           H  
ATOM    548  HD2 ARG A  41      49.517  18.288  37.556  1.00  0.00           H  
ATOM    549  HD3 ARG A  41      48.787  17.366  36.244  1.00  0.00           H  
ATOM    550  HE  ARG A  41      50.132  18.473  34.755  1.00  0.00           H  
ATOM    551 HH11 ARG A  41      50.201  20.149  37.817  1.00  0.00           H  
ATOM    552 HH12 ARG A  41      51.484  21.213  37.347  1.00  0.00           H  
ATOM    553 HH21 ARG A  41      51.821  19.872  34.137  1.00  0.00           H  
ATOM    554 HH22 ARG A  41      52.404  21.056  35.259  1.00  0.00           H  
ATOM    555  N   LEU A  42      43.163  19.279  35.130  1.00  0.00           N  
ATOM    556  CA  LEU A  42      42.038  18.729  34.384  1.00  0.00           C  
ATOM    557  C   LEU A  42      42.020  19.258  32.953  1.00  0.00           C  
ATOM    558  O   LEU A  42      42.170  20.458  32.721  1.00  0.00           O  
ATOM    559  CB  LEU A  42      40.719  19.071  35.082  1.00  0.00           C  
ATOM    560  CG  LEU A  42      39.506  18.267  34.602  1.00  0.00           C  
ATOM    561  CD1 LEU A  42      39.028  17.315  35.688  1.00  0.00           C  
ATOM    562  CD2 LEU A  42      38.381  19.201  34.178  1.00  0.00           C  
ATOM    563  H   LEU A  42      43.141  20.222  35.404  1.00  0.00           H  
ATOM    564  HA  LEU A  42      42.152  17.657  34.357  1.00  0.00           H  
ATOM    565  HB2 LEU A  42      40.844  18.901  36.142  1.00  0.00           H  
ATOM    566  HB3 LEU A  42      40.517  20.119  34.924  1.00  0.00           H  
ATOM    567  HG  LEU A  42      39.791  17.677  33.743  1.00  0.00           H  
ATOM    568 HD11 LEU A  42      39.435  16.330  35.507  1.00  0.00           H  
ATOM    569 HD12 LEU A  42      37.951  17.266  35.677  1.00  0.00           H  
ATOM    570 HD13 LEU A  42      39.365  17.669  36.650  1.00  0.00           H  
ATOM    571 HD21 LEU A  42      38.229  19.950  34.940  1.00  0.00           H  
ATOM    572 HD22 LEU A  42      37.471  18.632  34.045  1.00  0.00           H  
ATOM    573 HD23 LEU A  42      38.642  19.681  33.247  1.00  0.00           H  
ATOM    574  N   LYS A  43      41.835  18.354  31.998  1.00  0.00           N  
ATOM    575  CA  LYS A  43      41.795  18.724  30.588  1.00  0.00           C  
ATOM    576  C   LYS A  43      40.539  18.171  29.922  1.00  0.00           C  
ATOM    577  O   LYS A  43      40.486  16.999  29.547  1.00  0.00           O  
ATOM    578  CB  LYS A  43      43.042  18.208  29.869  1.00  0.00           C  
ATOM    579  CG  LYS A  43      44.334  18.482  30.622  1.00  0.00           C  
ATOM    580  CD  LYS A  43      44.640  19.971  30.681  1.00  0.00           C  
ATOM    581  CE  LYS A  43      45.027  20.405  32.087  1.00  0.00           C  
ATOM    582  NZ  LYS A  43      46.471  20.171  32.363  1.00  0.00           N  
ATOM    583  H   LYS A  43      41.720  17.413  32.248  1.00  0.00           H  
ATOM    584  HA  LYS A  43      41.774  19.803  30.527  1.00  0.00           H  
ATOM    585  HB2 LYS A  43      42.949  17.141  29.732  1.00  0.00           H  
ATOM    586  HB3 LYS A  43      43.107  18.682  28.899  1.00  0.00           H  
ATOM    587  HG2 LYS A  43      44.240  18.101  31.627  1.00  0.00           H  
ATOM    588  HG3 LYS A  43      45.145  17.976  30.118  1.00  0.00           H  
ATOM    589  HD2 LYS A  43      45.459  20.187  30.011  1.00  0.00           H  
ATOM    590  HD3 LYS A  43      43.765  20.521  30.372  1.00  0.00           H  
ATOM    591  HE2 LYS A  43      44.817  21.460  32.194  1.00  0.00           H  
ATOM    592  HE3 LYS A  43      44.438  19.847  32.797  1.00  0.00           H  
ATOM    593  HZ1 LYS A  43      47.043  20.940  31.959  1.00  0.00           H  
ATOM    594  HZ2 LYS A  43      46.774  19.269  31.941  1.00  0.00           H  
ATOM    595  HZ3 LYS A  43      46.637  20.132  33.389  1.00  0.00           H  
ATOM    596  N   LEU A  44      39.528  19.022  29.779  1.00  0.00           N  
ATOM    597  CA  LEU A  44      38.271  18.616  29.163  1.00  0.00           C  
ATOM    598  C   LEU A  44      38.176  19.121  27.726  1.00  0.00           C  
ATOM    599  O   LEU A  44      38.831  20.094  27.355  1.00  0.00           O  
ATOM    600  CB  LEU A  44      37.087  19.132  29.983  1.00  0.00           C  
ATOM    601  CG  LEU A  44      36.601  18.179  31.074  1.00  0.00           C  
ATOM    602  CD1 LEU A  44      35.548  18.848  31.944  1.00  0.00           C  
ATOM    603  CD2 LEU A  44      36.051  16.906  30.457  1.00  0.00           C  
ATOM    604  H   LEU A  44      39.628  19.942  30.101  1.00  0.00           H  
ATOM    605  HA  LEU A  44      38.243  17.537  29.152  1.00  0.00           H  
ATOM    606  HB2 LEU A  44      37.376  20.064  30.445  1.00  0.00           H  
ATOM    607  HB3 LEU A  44      36.264  19.322  29.310  1.00  0.00           H  
ATOM    608  HG  LEU A  44      37.434  17.911  31.706  1.00  0.00           H  
ATOM    609 HD11 LEU A  44      34.806  18.119  32.234  1.00  0.00           H  
ATOM    610 HD12 LEU A  44      35.076  19.643  31.389  1.00  0.00           H  
ATOM    611 HD13 LEU A  44      36.017  19.256  32.828  1.00  0.00           H  
ATOM    612 HD21 LEU A  44      35.640  16.278  31.233  1.00  0.00           H  
ATOM    613 HD22 LEU A  44      36.848  16.381  29.954  1.00  0.00           H  
ATOM    614 HD23 LEU A  44      35.277  17.154  29.745  1.00  0.00           H  
ATOM    615  N   CYS A  45      37.361  18.445  26.923  1.00  0.00           N  
ATOM    616  CA  CYS A  45      37.181  18.820  25.524  1.00  0.00           C  
ATOM    617  C   CYS A  45      35.710  19.050  25.202  1.00  0.00           C  
ATOM    618  O   CYS A  45      34.834  18.756  26.011  1.00  0.00           O  
ATOM    619  CB  CYS A  45      37.746  17.729  24.613  1.00  0.00           C  
ATOM    620  SG  CYS A  45      39.509  17.368  24.891  1.00  0.00           S  
ATOM    621  H   CYS A  45      36.869  17.676  27.277  1.00  0.00           H  
ATOM    622  HA  CYS A  45      37.724  19.735  25.353  1.00  0.00           H  
ATOM    623  HB2 CYS A  45      37.195  16.815  24.773  1.00  0.00           H  
ATOM    624  HB3 CYS A  45      37.631  18.037  23.584  1.00  0.00           H  
ATOM    625  N   VAL A  46      35.445  19.572  24.008  1.00  0.00           N  
ATOM    626  CA  VAL A  46      34.080  19.833  23.577  1.00  0.00           C  
ATOM    627  C   VAL A  46      33.897  19.462  22.110  1.00  0.00           C  
ATOM    628  O   VAL A  46      34.812  18.939  21.475  1.00  0.00           O  
ATOM    629  CB  VAL A  46      33.690  21.310  23.787  1.00  0.00           C  
ATOM    630  CG1 VAL A  46      33.761  21.676  25.261  1.00  0.00           C  
ATOM    631  CG2 VAL A  46      34.579  22.226  22.957  1.00  0.00           C  
ATOM    632  H   VAL A  46      36.184  19.782  23.400  1.00  0.00           H  
ATOM    633  HA  VAL A  46      33.420  19.220  24.176  1.00  0.00           H  
ATOM    634  HB  VAL A  46      32.670  21.440  23.458  1.00  0.00           H  
ATOM    635 HG11 VAL A  46      33.763  22.750  25.366  1.00  0.00           H  
ATOM    636 HG12 VAL A  46      34.664  21.270  25.690  1.00  0.00           H  
ATOM    637 HG13 VAL A  46      32.904  21.265  25.775  1.00  0.00           H  
ATOM    638 HG21 VAL A  46      33.962  22.845  22.321  1.00  0.00           H  
ATOM    639 HG22 VAL A  46      35.242  21.633  22.347  1.00  0.00           H  
ATOM    640 HG23 VAL A  46      35.161  22.857  23.614  1.00  0.00           H  
ATOM    641  N   SER A  47      32.713  19.737  21.577  1.00  0.00           N  
ATOM    642  CA  SER A  47      32.417  19.429  20.184  1.00  0.00           C  
ATOM    643  C   SER A  47      33.252  20.291  19.244  1.00  0.00           C  
ATOM    644  O   SER A  47      33.888  19.783  18.319  1.00  0.00           O  
ATOM    645  CB  SER A  47      30.928  19.636  19.906  1.00  0.00           C  
ATOM    646  OG  SER A  47      30.658  20.970  19.508  1.00  0.00           O  
ATOM    647  H   SER A  47      32.021  20.152  22.132  1.00  0.00           H  
ATOM    648  HA  SER A  47      32.663  18.391  20.016  1.00  0.00           H  
ATOM    649  HB2 SER A  47      30.616  18.968  19.118  1.00  0.00           H  
ATOM    650  HB3 SER A  47      30.365  19.421  20.804  1.00  0.00           H  
ATOM    651  HG  SER A  47      29.993  21.350  20.087  1.00  0.00           H  
ATOM    652  N   ASP A  48      33.247  21.598  19.484  1.00  0.00           N  
ATOM    653  CA  ASP A  48      34.007  22.528  18.658  1.00  0.00           C  
ATOM    654  C   ASP A  48      34.086  23.902  19.317  1.00  0.00           C  
ATOM    655  O   ASP A  48      33.672  24.078  20.463  1.00  0.00           O  
ATOM    656  CB  ASP A  48      33.372  22.650  17.272  1.00  0.00           C  
ATOM    657  CG  ASP A  48      34.406  22.704  16.163  1.00  0.00           C  
ATOM    658  OD1 ASP A  48      34.780  21.629  15.650  1.00  0.00           O  
ATOM    659  OD2 ASP A  48      34.842  23.819  15.812  1.00  0.00           O  
ATOM    660  H   ASP A  48      32.721  21.945  20.236  1.00  0.00           H  
ATOM    661  HA  ASP A  48      35.008  22.136  18.552  1.00  0.00           H  
ATOM    662  HB2 ASP A  48      32.731  21.798  17.099  1.00  0.00           H  
ATOM    663  HB3 ASP A  48      32.780  23.553  17.231  1.00  0.00           H  
ATOM    664  N   ARG A  49      34.623  24.874  18.585  1.00  0.00           N  
ATOM    665  CA  ARG A  49      34.759  26.233  19.096  1.00  0.00           C  
ATOM    666  C   ARG A  49      33.600  27.112  18.630  1.00  0.00           C  
ATOM    667  O   ARG A  49      33.256  28.099  19.282  1.00  0.00           O  
ATOM    668  CB  ARG A  49      36.089  26.839  18.648  1.00  0.00           C  
ATOM    669  CG  ARG A  49      37.225  26.610  19.632  1.00  0.00           C  
ATOM    670  CD  ARG A  49      38.464  26.058  18.946  1.00  0.00           C  
ATOM    671  NE  ARG A  49      39.647  26.872  19.215  1.00  0.00           N  
ATOM    672  CZ  ARG A  49      40.805  26.731  18.574  1.00  0.00           C  
ATOM    673  NH1 ARG A  49      40.941  25.810  17.627  1.00  0.00           N  
ATOM    674  NH2 ARG A  49      41.832  27.514  18.881  1.00  0.00           N  
ATOM    675  H   ARG A  49      34.935  24.672  17.679  1.00  0.00           H  
ATOM    676  HA  ARG A  49      34.742  26.183  20.175  1.00  0.00           H  
ATOM    677  HB2 ARG A  49      36.366  26.403  17.699  1.00  0.00           H  
ATOM    678  HB3 ARG A  49      35.960  27.905  18.518  1.00  0.00           H  
ATOM    679  HG2 ARG A  49      37.475  27.550  20.101  1.00  0.00           H  
ATOM    680  HG3 ARG A  49      36.898  25.908  20.385  1.00  0.00           H  
ATOM    681  HD2 ARG A  49      38.641  25.054  19.302  1.00  0.00           H  
ATOM    682  HD3 ARG A  49      38.292  26.034  17.880  1.00  0.00           H  
ATOM    683  HE  ARG A  49      39.576  27.559  19.911  1.00  0.00           H  
ATOM    684 HH11 ARG A  49      40.171  25.218  17.391  1.00  0.00           H  
ATOM    685 HH12 ARG A  49      41.814  25.710  17.150  1.00  0.00           H  
ATOM    686 HH21 ARG A  49      41.735  28.209  19.594  1.00  0.00           H  
ATOM    687 HH22 ARG A  49      42.703  27.409  18.399  1.00  0.00           H  
ATOM    688  N   ASP A  50      33.004  26.750  17.497  1.00  0.00           N  
ATOM    689  CA  ASP A  50      31.886  27.508  16.944  1.00  0.00           C  
ATOM    690  C   ASP A  50      30.762  27.652  17.966  1.00  0.00           C  
ATOM    691  O   ASP A  50      30.057  28.660  17.992  1.00  0.00           O  
ATOM    692  CB  ASP A  50      31.357  26.828  15.681  1.00  0.00           C  
ATOM    693  CG  ASP A  50      30.256  27.627  15.011  1.00  0.00           C  
ATOM    694  OD1 ASP A  50      30.582  28.574  14.263  1.00  0.00           O  
ATOM    695  OD2 ASP A  50      29.070  27.305  15.233  1.00  0.00           O  
ATOM    696  H   ASP A  50      33.323  25.956  17.021  1.00  0.00           H  
ATOM    697  HA  ASP A  50      32.249  28.492  16.687  1.00  0.00           H  
ATOM    698  HB2 ASP A  50      32.168  26.707  14.977  1.00  0.00           H  
ATOM    699  HB3 ASP A  50      30.965  25.855  15.940  1.00  0.00           H  
ATOM    700  N   VAL A  51      30.601  26.636  18.808  1.00  0.00           N  
ATOM    701  CA  VAL A  51      29.563  26.652  19.832  1.00  0.00           C  
ATOM    702  C   VAL A  51      29.902  27.640  20.943  1.00  0.00           C  
ATOM    703  O   VAL A  51      29.012  28.225  21.561  1.00  0.00           O  
ATOM    704  CB  VAL A  51      29.360  25.252  20.449  1.00  0.00           C  
ATOM    705  CG1 VAL A  51      28.170  25.253  21.396  1.00  0.00           C  
ATOM    706  CG2 VAL A  51      29.180  24.207  19.359  1.00  0.00           C  
ATOM    707  H   VAL A  51      31.195  25.859  18.740  1.00  0.00           H  
ATOM    708  HA  VAL A  51      28.638  26.953  19.365  1.00  0.00           H  
ATOM    709  HB  VAL A  51      30.244  25.001  21.018  1.00  0.00           H  
ATOM    710 HG11 VAL A  51      27.343  25.770  20.934  1.00  0.00           H  
ATOM    711 HG12 VAL A  51      28.441  25.754  22.315  1.00  0.00           H  
ATOM    712 HG13 VAL A  51      27.882  24.235  21.612  1.00  0.00           H  
ATOM    713 HG21 VAL A  51      28.136  23.947  19.276  1.00  0.00           H  
ATOM    714 HG22 VAL A  51      29.753  23.325  19.608  1.00  0.00           H  
ATOM    715 HG23 VAL A  51      29.527  24.606  18.415  1.00  0.00           H  
ATOM    716  N   LEU A  52      31.195  27.824  21.189  1.00  0.00           N  
ATOM    717  CA  LEU A  52      31.654  28.743  22.225  1.00  0.00           C  
ATOM    718  C   LEU A  52      32.263  30.000  21.607  1.00  0.00           C  
ATOM    719  O   LEU A  52      33.484  30.127  21.516  1.00  0.00           O  
ATOM    720  CB  LEU A  52      32.679  28.056  23.129  1.00  0.00           C  
ATOM    721  CG  LEU A  52      32.084  27.177  24.232  1.00  0.00           C  
ATOM    722  CD1 LEU A  52      31.925  25.745  23.745  1.00  0.00           C  
ATOM    723  CD2 LEU A  52      32.954  27.225  25.478  1.00  0.00           C  
ATOM    724  H   LEU A  52      31.859  27.330  20.663  1.00  0.00           H  
ATOM    725  HA  LEU A  52      30.797  29.027  22.818  1.00  0.00           H  
ATOM    726  HB2 LEU A  52      33.317  27.440  22.511  1.00  0.00           H  
ATOM    727  HB3 LEU A  52      33.285  28.818  23.595  1.00  0.00           H  
ATOM    728  HG  LEU A  52      31.104  27.552  24.491  1.00  0.00           H  
ATOM    729 HD11 LEU A  52      32.702  25.520  23.028  1.00  0.00           H  
ATOM    730 HD12 LEU A  52      30.959  25.629  23.276  1.00  0.00           H  
ATOM    731 HD13 LEU A  52      32.002  25.069  24.583  1.00  0.00           H  
ATOM    732 HD21 LEU A  52      32.643  28.048  26.104  1.00  0.00           H  
ATOM    733 HD22 LEU A  52      33.987  27.362  25.191  1.00  0.00           H  
ATOM    734 HD23 LEU A  52      32.853  26.299  26.024  1.00  0.00           H  
ATOM    735  N   PRO A  53      31.415  30.950  21.174  1.00  0.00           N  
ATOM    736  CA  PRO A  53      31.878  32.199  20.564  1.00  0.00           C  
ATOM    737  C   PRO A  53      32.530  33.132  21.578  1.00  0.00           C  
ATOM    738  O   PRO A  53      32.308  33.008  22.784  1.00  0.00           O  
ATOM    739  CB  PRO A  53      30.593  32.822  20.016  1.00  0.00           C  
ATOM    740  CG  PRO A  53      29.509  32.269  20.876  1.00  0.00           C  
ATOM    741  CD  PRO A  53      29.943  30.878  21.245  1.00  0.00           C  
ATOM    742  HA  PRO A  53      32.564  32.013  19.753  1.00  0.00           H  
ATOM    743  HB2 PRO A  53      30.650  33.899  20.093  1.00  0.00           H  
ATOM    744  HB3 PRO A  53      30.460  32.535  18.983  1.00  0.00           H  
ATOM    745  HG2 PRO A  53      29.398  32.875  21.763  1.00  0.00           H  
ATOM    746  HG3 PRO A  53      28.582  32.237  20.325  1.00  0.00           H  
ATOM    747  HD2 PRO A  53      29.617  30.634  22.246  1.00  0.00           H  
ATOM    748  HD3 PRO A  53      29.557  30.161  20.536  1.00  0.00           H  
ATOM    749  N   GLY A  54      33.336  34.067  21.083  1.00  0.00           N  
ATOM    750  CA  GLY A  54      34.009  35.008  21.960  1.00  0.00           C  
ATOM    751  C   GLY A  54      35.517  34.881  21.902  1.00  0.00           C  
ATOM    752  O   GLY A  54      36.190  35.693  21.265  1.00  0.00           O  
ATOM    753  H   GLY A  54      33.474  34.118  20.114  1.00  0.00           H  
ATOM    754  HA2 GLY A  54      33.730  36.011  21.672  1.00  0.00           H  
ATOM    755  HA3 GLY A  54      33.683  34.833  22.975  1.00  0.00           H  
ATOM    756  N   THR A  55      36.051  33.862  22.567  1.00  0.00           N  
ATOM    757  CA  THR A  55      37.492  33.636  22.588  1.00  0.00           C  
ATOM    758  C   THR A  55      37.811  32.149  22.460  1.00  0.00           C  
ATOM    759  O   THR A  55      36.950  31.298  22.681  1.00  0.00           O  
ATOM    760  CB  THR A  55      38.096  34.188  23.880  1.00  0.00           C  
ATOM    761  OG1 THR A  55      39.507  34.053  23.871  1.00  0.00           O  
ATOM    762  CG2 THR A  55      37.577  33.504  25.124  1.00  0.00           C  
ATOM    763  H   THR A  55      35.465  33.249  23.056  1.00  0.00           H  
ATOM    764  HA  THR A  55      37.922  34.158  21.746  1.00  0.00           H  
ATOM    765  HB  THR A  55      37.857  35.239  23.955  1.00  0.00           H  
ATOM    766  HG1 THR A  55      39.740  33.124  23.943  1.00  0.00           H  
ATOM    767 HG21 THR A  55      36.945  32.675  24.842  1.00  0.00           H  
ATOM    768 HG22 THR A  55      37.007  34.207  25.711  1.00  0.00           H  
ATOM    769 HG23 THR A  55      38.409  33.139  25.708  1.00  0.00           H  
ATOM    770  N   CYS A  56      39.055  31.846  22.101  1.00  0.00           N  
ATOM    771  CA  CYS A  56      39.490  30.463  21.944  1.00  0.00           C  
ATOM    772  C   CYS A  56      39.311  29.684  23.243  1.00  0.00           C  
ATOM    773  O   CYS A  56      39.673  30.160  24.320  1.00  0.00           O  
ATOM    774  CB  CYS A  56      40.955  30.415  21.507  1.00  0.00           C  
ATOM    775  SG  CYS A  56      42.092  31.245  22.640  1.00  0.00           S  
ATOM    776  H   CYS A  56      39.696  32.569  21.940  1.00  0.00           H  
ATOM    777  HA  CYS A  56      38.880  30.008  21.178  1.00  0.00           H  
ATOM    778  HB2 CYS A  56      41.267  29.383  21.429  1.00  0.00           H  
ATOM    779  HB3 CYS A  56      41.049  30.888  20.539  1.00  0.00           H  
ATOM    780  HG  CYS A  56      42.332  30.621  23.330  1.00  0.00           H  
ATOM    781  N   VAL A  57      38.748  28.486  23.135  1.00  0.00           N  
ATOM    782  CA  VAL A  57      38.518  27.641  24.304  1.00  0.00           C  
ATOM    783  C   VAL A  57      39.051  26.231  24.074  1.00  0.00           C  
ATOM    784  O   VAL A  57      39.634  25.938  23.029  1.00  0.00           O  
ATOM    785  CB  VAL A  57      37.019  27.563  24.651  1.00  0.00           C  
ATOM    786  CG1 VAL A  57      36.495  28.929  25.066  1.00  0.00           C  
ATOM    787  CG2 VAL A  57      36.224  27.013  23.476  1.00  0.00           C  
ATOM    788  H   VAL A  57      38.479  28.161  22.251  1.00  0.00           H  
ATOM    789  HA  VAL A  57      39.039  28.082  25.140  1.00  0.00           H  
ATOM    790  HB  VAL A  57      36.898  26.888  25.486  1.00  0.00           H  
ATOM    791 HG11 VAL A  57      37.151  29.356  25.810  1.00  0.00           H  
ATOM    792 HG12 VAL A  57      35.502  28.825  25.478  1.00  0.00           H  
ATOM    793 HG13 VAL A  57      36.460  29.578  24.203  1.00  0.00           H  
ATOM    794 HG21 VAL A  57      35.202  27.352  23.543  1.00  0.00           H  
ATOM    795 HG22 VAL A  57      36.250  25.934  23.497  1.00  0.00           H  
ATOM    796 HG23 VAL A  57      36.661  27.365  22.551  1.00  0.00           H  
ATOM    797  N   TRP A  58      38.850  25.361  25.059  1.00  0.00           N  
ATOM    798  CA  TRP A  58      39.310  23.982  24.967  1.00  0.00           C  
ATOM    799  C   TRP A  58      38.328  23.136  24.161  1.00  0.00           C  
ATOM    800  O   TRP A  58      37.178  22.953  24.561  1.00  0.00           O  
ATOM    801  CB  TRP A  58      39.484  23.392  26.369  1.00  0.00           C  
ATOM    802  CG  TRP A  58      40.816  22.740  26.575  1.00  0.00           C  
ATOM    803  CD1 TRP A  58      41.424  21.844  25.745  1.00  0.00           C  
ATOM    804  CD2 TRP A  58      41.706  22.931  27.681  1.00  0.00           C  
ATOM    805  NE1 TRP A  58      42.637  21.464  26.267  1.00  0.00           N  
ATOM    806  CE2 TRP A  58      42.833  22.118  27.455  1.00  0.00           C  
ATOM    807  CE3 TRP A  58      41.657  23.711  28.840  1.00  0.00           C  
ATOM    808  CZ2 TRP A  58      43.903  22.065  28.346  1.00  0.00           C  
ATOM    809  CZ3 TRP A  58      42.721  23.657  29.723  1.00  0.00           C  
ATOM    810  CH2 TRP A  58      43.829  22.838  29.472  1.00  0.00           C  
ATOM    811  H   TRP A  58      38.381  25.653  25.867  1.00  0.00           H  
ATOM    812  HA  TRP A  58      40.265  23.981  24.463  1.00  0.00           H  
ATOM    813  HB2 TRP A  58      39.383  24.181  27.099  1.00  0.00           H  
ATOM    814  HB3 TRP A  58      38.719  22.649  26.539  1.00  0.00           H  
ATOM    815  HD1 TRP A  58      40.999  21.493  24.816  1.00  0.00           H  
ATOM    816  HE1 TRP A  58      43.260  20.829  25.856  1.00  0.00           H  
ATOM    817  HE3 TRP A  58      40.813  24.349  29.050  1.00  0.00           H  
ATOM    818  HZ2 TRP A  58      44.765  21.439  28.166  1.00  0.00           H  
ATOM    819  HZ3 TRP A  58      42.702  24.253  30.623  1.00  0.00           H  
ATOM    820  HH2 TRP A  58      44.636  22.826  30.190  1.00  0.00           H  
ATOM    821  N   SER A  59      38.791  22.625  23.026  1.00  0.00           N  
ATOM    822  CA  SER A  59      37.953  21.799  22.163  1.00  0.00           C  
ATOM    823  C   SER A  59      38.760  20.661  21.546  1.00  0.00           C  
ATOM    824  O   SER A  59      39.990  20.665  21.590  1.00  0.00           O  
ATOM    825  CB  SER A  59      37.327  22.652  21.060  1.00  0.00           C  
ATOM    826  OG  SER A  59      36.649  23.772  21.603  1.00  0.00           O  
ATOM    827  H   SER A  59      39.716  22.806  22.760  1.00  0.00           H  
ATOM    828  HA  SER A  59      37.167  21.377  22.771  1.00  0.00           H  
ATOM    829  HB2 SER A  59      38.102  23.006  20.396  1.00  0.00           H  
ATOM    830  HB3 SER A  59      36.620  22.056  20.502  1.00  0.00           H  
ATOM    831  HG  SER A  59      35.867  23.957  21.081  1.00  0.00           H  
ATOM    832  N   ILE A  60      38.059  19.688  20.972  1.00  0.00           N  
ATOM    833  CA  ILE A  60      38.712  18.545  20.344  1.00  0.00           C  
ATOM    834  C   ILE A  60      37.786  17.862  19.342  1.00  0.00           C  
ATOM    835  O   ILE A  60      36.563  17.925  19.470  1.00  0.00           O  
ATOM    836  CB  ILE A  60      39.169  17.510  21.400  1.00  0.00           C  
ATOM    837  CG1 ILE A  60      40.426  16.777  20.915  1.00  0.00           C  
ATOM    838  CG2 ILE A  60      38.051  16.519  21.712  1.00  0.00           C  
ATOM    839  CD1 ILE A  60      40.691  15.474  21.641  1.00  0.00           C  
ATOM    840  H   ILE A  60      37.081  19.742  20.968  1.00  0.00           H  
ATOM    841  HA  ILE A  60      39.584  18.906  19.824  1.00  0.00           H  
ATOM    842  HB  ILE A  60      39.404  18.043  22.310  1.00  0.00           H  
ATOM    843 HG12 ILE A  60      40.322  16.554  19.867  1.00  0.00           H  
ATOM    844 HG13 ILE A  60      41.284  17.417  21.060  1.00  0.00           H  
ATOM    845 HG21 ILE A  60      38.076  15.711  20.992  1.00  0.00           H  
ATOM    846 HG22 ILE A  60      37.098  17.021  21.653  1.00  0.00           H  
ATOM    847 HG23 ILE A  60      38.189  16.120  22.705  1.00  0.00           H  
ATOM    848 HD11 ILE A  60      39.880  14.786  21.454  1.00  0.00           H  
ATOM    849 HD12 ILE A  60      40.767  15.660  22.703  1.00  0.00           H  
ATOM    850 HD13 ILE A  60      41.616  15.044  21.283  1.00  0.00           H  
ATOM    851  N   ALA A  61      38.376  17.194  18.358  1.00  0.00           N  
ATOM    852  CA  ALA A  61      37.600  16.484  17.353  1.00  0.00           C  
ATOM    853  C   ALA A  61      36.908  15.279  17.981  1.00  0.00           C  
ATOM    854  O   ALA A  61      37.488  14.587  18.818  1.00  0.00           O  
ATOM    855  CB  ALA A  61      38.493  16.055  16.200  1.00  0.00           C  
ATOM    856  H   ALA A  61      39.354  17.168  18.315  1.00  0.00           H  
ATOM    857  HA  ALA A  61      36.850  17.160  16.968  1.00  0.00           H  
ATOM    858  HB1 ALA A  61      38.561  14.976  16.178  1.00  0.00           H  
ATOM    859  HB2 ALA A  61      39.479  16.474  16.332  1.00  0.00           H  
ATOM    860  HB3 ALA A  61      38.074  16.407  15.269  1.00  0.00           H  
ATOM    861  N   SER A  62      35.663  15.040  17.585  1.00  0.00           N  
ATOM    862  CA  SER A  62      34.894  13.924  18.125  1.00  0.00           C  
ATOM    863  C   SER A  62      35.537  12.578  17.794  1.00  0.00           C  
ATOM    864  O   SER A  62      35.177  11.554  18.374  1.00  0.00           O  
ATOM    865  CB  SER A  62      33.462  13.961  17.589  1.00  0.00           C  
ATOM    866  OG  SER A  62      32.768  15.102  18.063  1.00  0.00           O  
ATOM    867  H   SER A  62      35.250  15.632  16.922  1.00  0.00           H  
ATOM    868  HA  SER A  62      34.866  14.036  19.198  1.00  0.00           H  
ATOM    869  HB2 SER A  62      33.483  13.991  16.510  1.00  0.00           H  
ATOM    870  HB3 SER A  62      32.935  13.075  17.914  1.00  0.00           H  
ATOM    871  HG  SER A  62      32.274  14.872  18.853  1.00  0.00           H  
ATOM    872  N   GLU A  63      36.488  12.578  16.864  1.00  0.00           N  
ATOM    873  CA  GLU A  63      37.166  11.349  16.472  1.00  0.00           C  
ATOM    874  C   GLU A  63      38.353  11.055  17.386  1.00  0.00           C  
ATOM    875  O   GLU A  63      38.847   9.928  17.428  1.00  0.00           O  
ATOM    876  CB  GLU A  63      37.635  11.437  15.018  1.00  0.00           C  
ATOM    877  CG  GLU A  63      38.308  12.755  14.670  1.00  0.00           C  
ATOM    878  CD  GLU A  63      39.305  12.620  13.536  1.00  0.00           C  
ATOM    879  OE1 GLU A  63      39.066  11.792  12.632  1.00  0.00           O  
ATOM    880  OE2 GLU A  63      40.325  13.340  13.553  1.00  0.00           O  
ATOM    881  H   GLU A  63      36.737  13.420  16.431  1.00  0.00           H  
ATOM    882  HA  GLU A  63      36.455  10.542  16.559  1.00  0.00           H  
ATOM    883  HB2 GLU A  63      38.338  10.640  14.831  1.00  0.00           H  
ATOM    884  HB3 GLU A  63      36.782  11.313  14.369  1.00  0.00           H  
ATOM    885  HG2 GLU A  63      37.550  13.467  14.381  1.00  0.00           H  
ATOM    886  HG3 GLU A  63      38.826  13.120  15.544  1.00  0.00           H  
ATOM    887  N   LEU A  64      38.812  12.069  18.118  1.00  0.00           N  
ATOM    888  CA  LEU A  64      39.938  11.908  19.021  1.00  0.00           C  
ATOM    889  C   LEU A  64      39.475  11.603  20.445  1.00  0.00           C  
ATOM    890  O   LEU A  64      40.292  11.478  21.355  1.00  0.00           O  
ATOM    891  CB  LEU A  64      40.805  13.167  19.025  1.00  0.00           C  
ATOM    892  CG  LEU A  64      40.655  14.077  17.807  1.00  0.00           C  
ATOM    893  CD1 LEU A  64      41.489  15.338  17.976  1.00  0.00           C  
ATOM    894  CD2 LEU A  64      41.056  13.339  16.542  1.00  0.00           C  
ATOM    895  H   LEU A  64      38.388  12.945  18.048  1.00  0.00           H  
ATOM    896  HA  LEU A  64      40.529  11.083  18.663  1.00  0.00           H  
ATOM    897  HB2 LEU A  64      40.566  13.741  19.907  1.00  0.00           H  
ATOM    898  HB3 LEU A  64      41.831  12.861  19.086  1.00  0.00           H  
ATOM    899  HG  LEU A  64      39.621  14.369  17.713  1.00  0.00           H  
ATOM    900 HD11 LEU A  64      40.926  16.193  17.629  1.00  0.00           H  
ATOM    901 HD12 LEU A  64      42.399  15.249  17.400  1.00  0.00           H  
ATOM    902 HD13 LEU A  64      41.736  15.469  19.020  1.00  0.00           H  
ATOM    903 HD21 LEU A  64      42.125  13.202  16.530  1.00  0.00           H  
ATOM    904 HD22 LEU A  64      40.755  13.914  15.680  1.00  0.00           H  
ATOM    905 HD23 LEU A  64      40.569  12.375  16.520  1.00  0.00           H  
ATOM    906  N   ILE A  65      38.163  11.494  20.639  1.00  0.00           N  
ATOM    907  CA  ILE A  65      37.614  11.215  21.960  1.00  0.00           C  
ATOM    908  C   ILE A  65      37.922   9.786  22.399  1.00  0.00           C  
ATOM    909  O   ILE A  65      38.577   9.566  23.418  1.00  0.00           O  
ATOM    910  CB  ILE A  65      36.089  11.433  21.994  1.00  0.00           C  
ATOM    911  CG1 ILE A  65      35.734  12.794  21.392  1.00  0.00           C  
ATOM    912  CG2 ILE A  65      35.572  11.326  23.421  1.00  0.00           C  
ATOM    913  CD1 ILE A  65      34.253  13.103  21.429  1.00  0.00           C  
ATOM    914  H   ILE A  65      37.554  11.608  19.883  1.00  0.00           H  
ATOM    915  HA  ILE A  65      38.069  11.899  22.658  1.00  0.00           H  
ATOM    916  HB  ILE A  65      35.623  10.655  21.409  1.00  0.00           H  
ATOM    917 HG12 ILE A  65      36.246  13.568  21.942  1.00  0.00           H  
ATOM    918 HG13 ILE A  65      36.053  12.818  20.361  1.00  0.00           H  
ATOM    919 HG21 ILE A  65      34.530  11.045  23.407  1.00  0.00           H  
ATOM    920 HG22 ILE A  65      35.681  12.280  23.915  1.00  0.00           H  
ATOM    921 HG23 ILE A  65      36.138  10.577  23.955  1.00  0.00           H  
ATOM    922 HD11 ILE A  65      33.718  12.367  20.847  1.00  0.00           H  
ATOM    923 HD12 ILE A  65      34.080  14.085  21.017  1.00  0.00           H  
ATOM    924 HD13 ILE A  65      33.905  13.074  22.451  1.00  0.00           H  
ATOM    925  N   GLU A  66      37.439   8.819  21.628  1.00  0.00           N  
ATOM    926  CA  GLU A  66      37.657   7.413  21.938  1.00  0.00           C  
ATOM    927  C   GLU A  66      39.127   7.023  21.789  1.00  0.00           C  
ATOM    928  O   GLU A  66      39.534   5.944  22.219  1.00  0.00           O  
ATOM    929  CB  GLU A  66      36.791   6.540  21.029  1.00  0.00           C  
ATOM    930  CG  GLU A  66      36.842   6.942  19.565  1.00  0.00           C  
ATOM    931  CD  GLU A  66      36.345   5.847  18.642  1.00  0.00           C  
ATOM    932  OE1 GLU A  66      35.428   5.100  19.047  1.00  0.00           O  
ATOM    933  OE2 GLU A  66      36.871   5.735  17.515  1.00  0.00           O  
ATOM    934  H   GLU A  66      36.923   9.055  20.831  1.00  0.00           H  
ATOM    935  HA  GLU A  66      37.357   7.253  22.963  1.00  0.00           H  
ATOM    936  HB2 GLU A  66      37.124   5.520  21.110  1.00  0.00           H  
ATOM    937  HB3 GLU A  66      35.765   6.602  21.362  1.00  0.00           H  
ATOM    938  HG2 GLU A  66      36.227   7.818  19.423  1.00  0.00           H  
ATOM    939  HG3 GLU A  66      37.863   7.177  19.303  1.00  0.00           H  
ATOM    940  N   LYS A  67      39.921   7.900  21.176  1.00  0.00           N  
ATOM    941  CA  LYS A  67      41.340   7.627  20.975  1.00  0.00           C  
ATOM    942  C   LYS A  67      42.200   8.374  21.992  1.00  0.00           C  
ATOM    943  O   LYS A  67      43.110   7.799  22.588  1.00  0.00           O  
ATOM    944  CB  LYS A  67      41.758   8.017  19.556  1.00  0.00           C  
ATOM    945  CG  LYS A  67      40.819   7.492  18.480  1.00  0.00           C  
ATOM    946  CD  LYS A  67      41.574   6.731  17.401  1.00  0.00           C  
ATOM    947  CE  LYS A  67      42.107   7.666  16.329  1.00  0.00           C  
ATOM    948  NZ  LYS A  67      42.080   7.036  14.978  1.00  0.00           N  
ATOM    949  H   LYS A  67      39.546   8.742  20.850  1.00  0.00           H  
ATOM    950  HA  LYS A  67      41.494   6.567  21.104  1.00  0.00           H  
ATOM    951  HB2 LYS A  67      41.786   9.095  19.485  1.00  0.00           H  
ATOM    952  HB3 LYS A  67      42.747   7.626  19.364  1.00  0.00           H  
ATOM    953  HG2 LYS A  67      40.099   6.831  18.935  1.00  0.00           H  
ATOM    954  HG3 LYS A  67      40.306   8.328  18.026  1.00  0.00           H  
ATOM    955  HD2 LYS A  67      42.405   6.211  17.855  1.00  0.00           H  
ATOM    956  HD3 LYS A  67      40.905   6.016  16.944  1.00  0.00           H  
ATOM    957  HE2 LYS A  67      41.498   8.558  16.312  1.00  0.00           H  
ATOM    958  HE3 LYS A  67      43.124   7.930  16.572  1.00  0.00           H  
ATOM    959  HZ1 LYS A  67      42.910   7.334  14.429  1.00  0.00           H  
ATOM    960  HZ2 LYS A  67      41.218   7.322  14.469  1.00  0.00           H  
ATOM    961  HZ3 LYS A  67      42.089   6.001  15.068  1.00  0.00           H  
ATOM    962  N   ARG A  68      41.915   9.659  22.177  1.00  0.00           N  
ATOM    963  CA  ARG A  68      42.673  10.480  23.116  1.00  0.00           C  
ATOM    964  C   ARG A  68      41.965  10.587  24.463  1.00  0.00           C  
ATOM    965  O   ARG A  68      42.501  10.168  25.489  1.00  0.00           O  
ATOM    966  CB  ARG A  68      42.903  11.878  22.537  1.00  0.00           C  
ATOM    967  CG  ARG A  68      43.483  11.866  21.132  1.00  0.00           C  
ATOM    968  CD  ARG A  68      44.131  13.197  20.786  1.00  0.00           C  
ATOM    969  NE  ARG A  68      44.077  13.481  19.353  1.00  0.00           N  
ATOM    970  CZ  ARG A  68      44.904  12.942  18.460  1.00  0.00           C  
ATOM    971  NH1 ARG A  68      45.844  12.089  18.846  1.00  0.00           N  
ATOM    972  NH2 ARG A  68      44.786  13.254  17.176  1.00  0.00           N  
ATOM    973  H   ARG A  68      41.184  10.066  21.667  1.00  0.00           H  
ATOM    974  HA  ARG A  68      43.631  10.005  23.267  1.00  0.00           H  
ATOM    975  HB2 ARG A  68      41.959  12.402  22.510  1.00  0.00           H  
ATOM    976  HB3 ARG A  68      43.584  12.413  23.180  1.00  0.00           H  
ATOM    977  HG2 ARG A  68      44.228  11.087  21.066  1.00  0.00           H  
ATOM    978  HG3 ARG A  68      42.690  11.669  20.426  1.00  0.00           H  
ATOM    979  HD2 ARG A  68      43.616  13.983  21.318  1.00  0.00           H  
ATOM    980  HD3 ARG A  68      45.164  13.173  21.101  1.00  0.00           H  
ATOM    981  HE  ARG A  68      43.391  14.105  19.041  1.00  0.00           H  
ATOM    982 HH11 ARG A  68      45.937  11.849  19.811  1.00  0.00           H  
ATOM    983 HH12 ARG A  68      46.462  11.688  18.169  1.00  0.00           H  
ATOM    984 HH21 ARG A  68      44.078  13.895  16.881  1.00  0.00           H  
ATOM    985 HH22 ARG A  68      45.407  12.849  16.505  1.00  0.00           H  
ATOM    986  N   CYS A  69      40.761  11.152  24.455  1.00  0.00           N  
ATOM    987  CA  CYS A  69      39.987  11.316  25.682  1.00  0.00           C  
ATOM    988  C   CYS A  69      39.784   9.977  26.386  1.00  0.00           C  
ATOM    989  O   CYS A  69      39.568   8.952  25.741  1.00  0.00           O  
ATOM    990  CB  CYS A  69      38.634  11.957  25.377  1.00  0.00           C  
ATOM    991  SG  CYS A  69      38.736  13.686  24.858  1.00  0.00           S  
ATOM    992  H   CYS A  69      40.387  11.471  23.607  1.00  0.00           H  
ATOM    993  HA  CYS A  69      40.543  11.970  26.338  1.00  0.00           H  
ATOM    994  HB2 CYS A  69      38.152  11.406  24.585  1.00  0.00           H  
ATOM    995  HB3 CYS A  69      38.015  11.917  26.263  1.00  0.00           H  
ATOM    996  HG  CYS A  69      37.859  13.966  24.583  1.00  0.00           H  
ATOM    997  N   ARG A  70      39.859   9.995  27.713  1.00  0.00           N  
ATOM    998  CA  ARG A  70      39.686   8.782  28.506  1.00  0.00           C  
ATOM    999  C   ARG A  70      38.244   8.637  28.985  1.00  0.00           C  
ATOM   1000  O   ARG A  70      37.646   7.568  28.867  1.00  0.00           O  
ATOM   1001  CB  ARG A  70      40.639   8.797  29.706  1.00  0.00           C  
ATOM   1002  CG  ARG A  70      41.797   7.819  29.574  1.00  0.00           C  
ATOM   1003  CD  ARG A  70      41.651   6.648  30.535  1.00  0.00           C  
ATOM   1004  NE  ARG A  70      42.561   5.555  30.209  1.00  0.00           N  
ATOM   1005  CZ  ARG A  70      42.407   4.306  30.645  1.00  0.00           C  
ATOM   1006  NH1 ARG A  70      41.383   3.991  31.429  1.00  0.00           N  
ATOM   1007  NH2 ARG A  70      43.279   3.371  30.298  1.00  0.00           N  
ATOM   1008  H   ARG A  70      40.036  10.844  28.171  1.00  0.00           H  
ATOM   1009  HA  ARG A  70      39.930   7.938  27.877  1.00  0.00           H  
ATOM   1010  HB2 ARG A  70      41.047   9.790  29.813  1.00  0.00           H  
ATOM   1011  HB3 ARG A  70      40.083   8.547  30.597  1.00  0.00           H  
ATOM   1012  HG2 ARG A  70      41.821   7.440  28.565  1.00  0.00           H  
ATOM   1013  HG3 ARG A  70      42.719   8.337  29.791  1.00  0.00           H  
ATOM   1014  HD2 ARG A  70      41.863   6.992  31.537  1.00  0.00           H  
ATOM   1015  HD3 ARG A  70      40.634   6.286  30.488  1.00  0.00           H  
ATOM   1016  HE  ARG A  70      43.328   5.760  29.632  1.00  0.00           H  
ATOM   1017 HH11 ARG A  70      40.721   4.692  31.694  1.00  0.00           H  
ATOM   1018 HH12 ARG A  70      41.273   3.052  31.753  1.00  0.00           H  
ATOM   1019 HH21 ARG A  70      44.054   3.601  29.709  1.00  0.00           H  
ATOM   1020 HH22 ARG A  70      43.165   2.433  30.625  1.00  0.00           H  
ATOM   1021  N   ARG A  71      37.691   9.719  29.526  1.00  0.00           N  
ATOM   1022  CA  ARG A  71      36.317   9.704  30.022  1.00  0.00           C  
ATOM   1023  C   ARG A  71      35.449  10.703  29.261  1.00  0.00           C  
ATOM   1024  O   ARG A  71      35.944  11.476  28.439  1.00  0.00           O  
ATOM   1025  CB  ARG A  71      36.272  10.009  31.523  1.00  0.00           C  
ATOM   1026  CG  ARG A  71      37.376  10.940  32.006  1.00  0.00           C  
ATOM   1027  CD  ARG A  71      38.513  10.166  32.654  1.00  0.00           C  
ATOM   1028  NE  ARG A  71      38.036   9.278  33.712  1.00  0.00           N  
ATOM   1029  CZ  ARG A  71      38.726   8.237  34.174  1.00  0.00           C  
ATOM   1030  NH1 ARG A  71      39.922   7.950  33.676  1.00  0.00           N  
ATOM   1031  NH2 ARG A  71      38.217   7.482  35.137  1.00  0.00           N  
ATOM   1032  H   ARG A  71      38.216  10.543  29.592  1.00  0.00           H  
ATOM   1033  HA  ARG A  71      35.922   8.713  29.857  1.00  0.00           H  
ATOM   1034  HB2 ARG A  71      35.321  10.467  31.757  1.00  0.00           H  
ATOM   1035  HB3 ARG A  71      36.354   9.079  32.067  1.00  0.00           H  
ATOM   1036  HG2 ARG A  71      37.762  11.492  31.163  1.00  0.00           H  
ATOM   1037  HG3 ARG A  71      36.962  11.626  32.730  1.00  0.00           H  
ATOM   1038  HD2 ARG A  71      39.004   9.574  31.896  1.00  0.00           H  
ATOM   1039  HD3 ARG A  71      39.216  10.868  33.073  1.00  0.00           H  
ATOM   1040  HE  ARG A  71      37.156   9.468  34.098  1.00  0.00           H  
ATOM   1041 HH11 ARG A  71      40.312   8.516  32.950  1.00  0.00           H  
ATOM   1042 HH12 ARG A  71      40.436   7.168  34.028  1.00  0.00           H  
ATOM   1043 HH21 ARG A  71      37.317   7.693  35.517  1.00  0.00           H  
ATOM   1044 HH22 ARG A  71      38.736   6.699  35.484  1.00  0.00           H  
ATOM   1045  N   MET A  72      34.149  10.672  29.532  1.00  0.00           N  
ATOM   1046  CA  MET A  72      33.209  11.567  28.868  1.00  0.00           C  
ATOM   1047  C   MET A  72      32.303  12.263  29.876  1.00  0.00           C  
ATOM   1048  O   MET A  72      32.027  11.735  30.954  1.00  0.00           O  
ATOM   1049  CB  MET A  72      32.363  10.787  27.858  1.00  0.00           C  
ATOM   1050  CG  MET A  72      32.748  11.052  26.412  1.00  0.00           C  
ATOM   1051  SD  MET A  72      32.363   9.664  25.325  1.00  0.00           S  
ATOM   1052  CE  MET A  72      33.970   8.889  25.183  1.00  0.00           C  
ATOM   1053  H   MET A  72      33.812  10.030  30.192  1.00  0.00           H  
ATOM   1054  HA  MET A  72      33.778  12.316  28.342  1.00  0.00           H  
ATOM   1055  HB2 MET A  72      32.479   9.730  28.050  1.00  0.00           H  
ATOM   1056  HB3 MET A  72      31.325  11.057  27.988  1.00  0.00           H  
ATOM   1057  HG2 MET A  72      32.210  11.922  26.065  1.00  0.00           H  
ATOM   1058  HG3 MET A  72      33.810  11.244  26.365  1.00  0.00           H  
ATOM   1059  HE1 MET A  72      33.848   7.819  25.103  1.00  0.00           H  
ATOM   1060  HE2 MET A  72      34.560   9.118  26.059  1.00  0.00           H  
ATOM   1061  HE3 MET A  72      34.473   9.262  24.303  1.00  0.00           H  
ATOM   1062  N   VAL A  73      31.836  13.448  29.513  1.00  0.00           N  
ATOM   1063  CA  VAL A  73      30.951  14.222  30.368  1.00  0.00           C  
ATOM   1064  C   VAL A  73      29.684  14.582  29.606  1.00  0.00           C  
ATOM   1065  O   VAL A  73      29.650  15.559  28.859  1.00  0.00           O  
ATOM   1066  CB  VAL A  73      31.639  15.504  30.873  1.00  0.00           C  
ATOM   1067  CG1 VAL A  73      30.709  16.292  31.784  1.00  0.00           C  
ATOM   1068  CG2 VAL A  73      32.935  15.162  31.591  1.00  0.00           C  
ATOM   1069  H   VAL A  73      32.087  13.811  28.637  1.00  0.00           H  
ATOM   1070  HA  VAL A  73      30.690  13.612  31.221  1.00  0.00           H  
ATOM   1071  HB  VAL A  73      31.879  16.119  30.019  1.00  0.00           H  
ATOM   1072 HG11 VAL A  73      29.759  16.437  31.291  1.00  0.00           H  
ATOM   1073 HG12 VAL A  73      31.151  17.253  32.006  1.00  0.00           H  
ATOM   1074 HG13 VAL A  73      30.557  15.744  32.704  1.00  0.00           H  
ATOM   1075 HG21 VAL A  73      32.771  15.179  32.658  1.00  0.00           H  
ATOM   1076 HG22 VAL A  73      33.691  15.887  31.332  1.00  0.00           H  
ATOM   1077 HG23 VAL A  73      33.263  14.178  31.293  1.00  0.00           H  
ATOM   1078  N   VAL A  74      28.649  13.769  29.785  1.00  0.00           N  
ATOM   1079  CA  VAL A  74      27.384  13.981  29.098  1.00  0.00           C  
ATOM   1080  C   VAL A  74      26.456  14.894  29.888  1.00  0.00           C  
ATOM   1081  O   VAL A  74      26.434  14.866  31.118  1.00  0.00           O  
ATOM   1082  CB  VAL A  74      26.666  12.644  28.831  1.00  0.00           C  
ATOM   1083  CG1 VAL A  74      25.556  12.831  27.809  1.00  0.00           C  
ATOM   1084  CG2 VAL A  74      27.657  11.585  28.366  1.00  0.00           C  
ATOM   1085  H   VAL A  74      28.746  12.998  30.382  1.00  0.00           H  
ATOM   1086  HA  VAL A  74      27.597  14.443  28.144  1.00  0.00           H  
ATOM   1087  HB  VAL A  74      26.220  12.309  29.756  1.00  0.00           H  
ATOM   1088 HG11 VAL A  74      25.507  11.963  27.168  1.00  0.00           H  
ATOM   1089 HG12 VAL A  74      25.760  13.707  27.212  1.00  0.00           H  
ATOM   1090 HG13 VAL A  74      24.613  12.954  28.320  1.00  0.00           H  
ATOM   1091 HG21 VAL A  74      28.306  12.008  27.613  1.00  0.00           H  
ATOM   1092 HG22 VAL A  74      27.120  10.747  27.950  1.00  0.00           H  
ATOM   1093 HG23 VAL A  74      28.248  11.254  29.206  1.00  0.00           H  
ATOM   1094  N   VAL A  75      25.688  15.702  29.166  1.00  0.00           N  
ATOM   1095  CA  VAL A  75      24.748  16.625  29.785  1.00  0.00           C  
ATOM   1096  C   VAL A  75      23.316  16.302  29.365  1.00  0.00           C  
ATOM   1097  O   VAL A  75      22.843  16.773  28.331  1.00  0.00           O  
ATOM   1098  CB  VAL A  75      25.070  18.086  29.414  1.00  0.00           C  
ATOM   1099  CG1 VAL A  75      24.124  19.044  30.121  1.00  0.00           C  
ATOM   1100  CG2 VAL A  75      26.518  18.414  29.750  1.00  0.00           C  
ATOM   1101  H   VAL A  75      25.753  15.673  28.188  1.00  0.00           H  
ATOM   1102  HA  VAL A  75      24.834  16.519  30.857  1.00  0.00           H  
ATOM   1103  HB  VAL A  75      24.936  18.203  28.349  1.00  0.00           H  
ATOM   1104 HG11 VAL A  75      23.102  18.766  29.909  1.00  0.00           H  
ATOM   1105 HG12 VAL A  75      24.302  20.051  29.772  1.00  0.00           H  
ATOM   1106 HG13 VAL A  75      24.296  18.999  31.188  1.00  0.00           H  
ATOM   1107 HG21 VAL A  75      26.794  19.346  29.281  1.00  0.00           H  
ATOM   1108 HG22 VAL A  75      27.158  17.624  29.385  1.00  0.00           H  
ATOM   1109 HG23 VAL A  75      26.629  18.502  30.820  1.00  0.00           H  
ATOM   1110  N   VAL A  76      22.633  15.487  30.166  1.00  0.00           N  
ATOM   1111  CA  VAL A  76      21.259  15.096  29.867  1.00  0.00           C  
ATOM   1112  C   VAL A  76      20.253  16.073  30.467  1.00  0.00           C  
ATOM   1113  O   VAL A  76      19.838  15.928  31.618  1.00  0.00           O  
ATOM   1114  CB  VAL A  76      20.951  13.674  30.376  1.00  0.00           C  
ATOM   1115  CG1 VAL A  76      21.131  13.590  31.885  1.00  0.00           C  
ATOM   1116  CG2 VAL A  76      19.546  13.251  29.972  1.00  0.00           C  
ATOM   1117  H   VAL A  76      23.066  15.138  30.974  1.00  0.00           H  
ATOM   1118  HA  VAL A  76      21.144  15.099  28.792  1.00  0.00           H  
ATOM   1119  HB  VAL A  76      21.653  12.993  29.916  1.00  0.00           H  
ATOM   1120 HG11 VAL A  76      21.665  12.684  32.132  1.00  0.00           H  
ATOM   1121 HG12 VAL A  76      20.163  13.577  32.362  1.00  0.00           H  
ATOM   1122 HG13 VAL A  76      21.692  14.444  32.230  1.00  0.00           H  
ATOM   1123 HG21 VAL A  76      18.900  14.115  29.952  1.00  0.00           H  
ATOM   1124 HG22 VAL A  76      19.168  12.535  30.686  1.00  0.00           H  
ATOM   1125 HG23 VAL A  76      19.574  12.800  28.991  1.00  0.00           H  
ATOM   1126  N   SER A  77      19.853  17.062  29.677  1.00  0.00           N  
ATOM   1127  CA  SER A  77      18.886  18.057  30.127  1.00  0.00           C  
ATOM   1128  C   SER A  77      17.698  18.132  29.168  1.00  0.00           C  
ATOM   1129  O   SER A  77      17.818  17.812  27.986  1.00  0.00           O  
ATOM   1130  CB  SER A  77      19.550  19.432  30.251  1.00  0.00           C  
ATOM   1131  OG  SER A  77      20.935  19.361  29.960  1.00  0.00           O  
ATOM   1132  H   SER A  77      20.212  17.121  28.768  1.00  0.00           H  
ATOM   1133  HA  SER A  77      18.527  17.753  31.100  1.00  0.00           H  
ATOM   1134  HB2 SER A  77      19.085  20.120  29.561  1.00  0.00           H  
ATOM   1135  HB3 SER A  77      19.425  19.796  31.259  1.00  0.00           H  
ATOM   1136  HG  SER A  77      21.423  19.893  30.593  1.00  0.00           H  
ATOM   1137  N   ASP A  78      16.551  18.551  29.697  1.00  0.00           N  
ATOM   1138  CA  ASP A  78      15.322  18.671  28.907  1.00  0.00           C  
ATOM   1139  C   ASP A  78      15.581  19.257  27.519  1.00  0.00           C  
ATOM   1140  O   ASP A  78      15.232  18.654  26.505  1.00  0.00           O  
ATOM   1141  CB  ASP A  78      14.315  19.554  29.653  1.00  0.00           C  
ATOM   1142  CG  ASP A  78      13.074  18.793  30.065  1.00  0.00           C  
ATOM   1143  OD1 ASP A  78      13.210  17.635  30.506  1.00  0.00           O  
ATOM   1144  OD2 ASP A  78      11.965  19.356  29.947  1.00  0.00           O  
ATOM   1145  H   ASP A  78      16.526  18.782  30.649  1.00  0.00           H  
ATOM   1146  HA  ASP A  78      14.904  17.683  28.798  1.00  0.00           H  
ATOM   1147  HB2 ASP A  78      14.783  19.951  30.542  1.00  0.00           H  
ATOM   1148  HB3 ASP A  78      14.018  20.372  29.012  1.00  0.00           H  
ATOM   1149  N   ASP A  79      16.175  20.445  27.486  1.00  0.00           N  
ATOM   1150  CA  ASP A  79      16.463  21.132  26.232  1.00  0.00           C  
ATOM   1151  C   ASP A  79      17.525  20.409  25.403  1.00  0.00           C  
ATOM   1152  O   ASP A  79      17.772  20.776  24.253  1.00  0.00           O  
ATOM   1153  CB  ASP A  79      16.920  22.559  26.519  1.00  0.00           C  
ATOM   1154  CG  ASP A  79      15.785  23.448  26.986  1.00  0.00           C  
ATOM   1155  OD1 ASP A  79      15.285  23.231  28.110  1.00  0.00           O  
ATOM   1156  OD2 ASP A  79      15.394  24.362  26.229  1.00  0.00           O  
ATOM   1157  H   ASP A  79      16.416  20.880  28.329  1.00  0.00           H  
ATOM   1158  HA  ASP A  79      15.547  21.170  25.662  1.00  0.00           H  
ATOM   1159  HB2 ASP A  79      17.679  22.542  27.286  1.00  0.00           H  
ATOM   1160  HB3 ASP A  79      17.336  22.981  25.622  1.00  0.00           H  
ATOM   1161  N   TYR A  80      18.150  19.387  25.976  1.00  0.00           N  
ATOM   1162  CA  TYR A  80      19.174  18.633  25.268  1.00  0.00           C  
ATOM   1163  C   TYR A  80      18.553  17.440  24.558  1.00  0.00           C  
ATOM   1164  O   TYR A  80      19.009  17.028  23.491  1.00  0.00           O  
ATOM   1165  CB  TYR A  80      20.254  18.151  26.241  1.00  0.00           C  
ATOM   1166  CG  TYR A  80      21.044  19.265  26.899  1.00  0.00           C  
ATOM   1167  CD1 TYR A  80      20.408  20.358  27.480  1.00  0.00           C  
ATOM   1168  CD2 TYR A  80      22.432  19.219  26.943  1.00  0.00           C  
ATOM   1169  CE1 TYR A  80      21.133  21.368  28.084  1.00  0.00           C  
ATOM   1170  CE2 TYR A  80      23.162  20.227  27.545  1.00  0.00           C  
ATOM   1171  CZ  TYR A  80      22.507  21.298  28.113  1.00  0.00           C  
ATOM   1172  OH  TYR A  80      23.232  22.303  28.713  1.00  0.00           O  
ATOM   1173  H   TYR A  80      17.917  19.129  26.889  1.00  0.00           H  
ATOM   1174  HA  TYR A  80      19.623  19.285  24.534  1.00  0.00           H  
ATOM   1175  HB2 TYR A  80      19.787  17.572  27.022  1.00  0.00           H  
ATOM   1176  HB3 TYR A  80      20.951  17.523  25.706  1.00  0.00           H  
ATOM   1177  HD1 TYR A  80      19.331  20.413  27.460  1.00  0.00           H  
ATOM   1178  HD2 TYR A  80      22.943  18.381  26.496  1.00  0.00           H  
ATOM   1179  HE1 TYR A  80      20.619  22.207  28.529  1.00  0.00           H  
ATOM   1180  HE2 TYR A  80      24.241  20.172  27.567  1.00  0.00           H  
ATOM   1181  HH  TYR A  80      23.658  21.961  29.503  1.00  0.00           H  
ATOM   1182  N   LEU A  81      17.508  16.888  25.163  1.00  0.00           N  
ATOM   1183  CA  LEU A  81      16.813  15.741  24.609  1.00  0.00           C  
ATOM   1184  C   LEU A  81      15.851  16.163  23.510  1.00  0.00           C  
ATOM   1185  O   LEU A  81      15.638  15.432  22.544  1.00  0.00           O  
ATOM   1186  CB  LEU A  81      16.063  15.018  25.722  1.00  0.00           C  
ATOM   1187  CG  LEU A  81      16.955  14.418  26.802  1.00  0.00           C  
ATOM   1188  CD1 LEU A  81      16.222  14.311  28.128  1.00  0.00           C  
ATOM   1189  CD2 LEU A  81      17.446  13.062  26.364  1.00  0.00           C  
ATOM   1190  H   LEU A  81      17.196  17.262  26.011  1.00  0.00           H  
ATOM   1191  HA  LEU A  81      17.552  15.075  24.193  1.00  0.00           H  
ATOM   1192  HB2 LEU A  81      15.382  15.712  26.188  1.00  0.00           H  
ATOM   1193  HB3 LEU A  81      15.492  14.222  25.278  1.00  0.00           H  
ATOM   1194  HG  LEU A  81      17.813  15.057  26.948  1.00  0.00           H  
ATOM   1195 HD11 LEU A  81      16.940  14.198  28.926  1.00  0.00           H  
ATOM   1196 HD12 LEU A  81      15.570  13.450  28.110  1.00  0.00           H  
ATOM   1197 HD13 LEU A  81      15.639  15.203  28.292  1.00  0.00           H  
ATOM   1198 HD21 LEU A  81      17.795  13.118  25.344  1.00  0.00           H  
ATOM   1199 HD22 LEU A  81      16.638  12.350  26.431  1.00  0.00           H  
ATOM   1200 HD23 LEU A  81      18.253  12.756  27.006  1.00  0.00           H  
ATOM   1201  N   GLN A  82      15.276  17.352  23.658  1.00  0.00           N  
ATOM   1202  CA  GLN A  82      14.345  17.873  22.674  1.00  0.00           C  
ATOM   1203  C   GLN A  82      15.008  17.982  21.301  1.00  0.00           C  
ATOM   1204  O   GLN A  82      14.328  18.062  20.278  1.00  0.00           O  
ATOM   1205  CB  GLN A  82      13.823  19.238  23.120  1.00  0.00           C  
ATOM   1206  CG  GLN A  82      14.875  20.336  23.088  1.00  0.00           C  
ATOM   1207  CD  GLN A  82      14.309  21.696  23.448  1.00  0.00           C  
ATOM   1208  OE1 GLN A  82      14.542  22.682  22.751  1.00  0.00           O  
ATOM   1209  NE2 GLN A  82      13.562  21.752  24.544  1.00  0.00           N  
ATOM   1210  H   GLN A  82      15.487  17.893  24.445  1.00  0.00           H  
ATOM   1211  HA  GLN A  82      13.515  17.185  22.607  1.00  0.00           H  
ATOM   1212  HB2 GLN A  82      13.015  19.528  22.474  1.00  0.00           H  
ATOM   1213  HB3 GLN A  82      13.453  19.155  24.131  1.00  0.00           H  
ATOM   1214  HG2 GLN A  82      15.656  20.090  23.792  1.00  0.00           H  
ATOM   1215  HG3 GLN A  82      15.292  20.389  22.093  1.00  0.00           H  
ATOM   1216 HE21 GLN A  82      13.418  20.927  25.052  1.00  0.00           H  
ATOM   1217 HE22 GLN A  82      13.183  22.620  24.802  1.00  0.00           H  
ATOM   1218  N   SER A  83      16.339  17.986  21.288  1.00  0.00           N  
ATOM   1219  CA  SER A  83      17.092  18.085  20.044  1.00  0.00           C  
ATOM   1220  C   SER A  83      17.613  16.718  19.610  1.00  0.00           C  
ATOM   1221  O   SER A  83      17.787  15.819  20.432  1.00  0.00           O  
ATOM   1222  CB  SER A  83      18.257  19.063  20.204  1.00  0.00           C  
ATOM   1223  OG  SER A  83      18.979  19.199  18.993  1.00  0.00           O  
ATOM   1224  H   SER A  83      16.827  17.921  22.136  1.00  0.00           H  
ATOM   1225  HA  SER A  83      16.421  18.459  19.285  1.00  0.00           H  
ATOM   1226  HB2 SER A  83      17.874  20.031  20.492  1.00  0.00           H  
ATOM   1227  HB3 SER A  83      18.927  18.699  20.970  1.00  0.00           H  
ATOM   1228  HG  SER A  83      19.767  19.725  19.148  1.00  0.00           H  
ATOM   1229  N   LYS A  84      17.862  16.570  18.312  1.00  0.00           N  
ATOM   1230  CA  LYS A  84      18.365  15.319  17.765  1.00  0.00           C  
ATOM   1231  C   LYS A  84      19.839  15.121  18.100  1.00  0.00           C  
ATOM   1232  O   LYS A  84      20.345  13.998  18.074  1.00  0.00           O  
ATOM   1233  CB  LYS A  84      18.163  15.293  16.249  1.00  0.00           C  
ATOM   1234  CG  LYS A  84      18.669  16.542  15.543  1.00  0.00           C  
ATOM   1235  CD  LYS A  84      17.564  17.224  14.750  1.00  0.00           C  
ATOM   1236  CE  LYS A  84      16.863  18.292  15.573  1.00  0.00           C  
ATOM   1237  NZ  LYS A  84      15.923  19.101  14.749  1.00  0.00           N  
ATOM   1238  H   LYS A  84      17.705  17.321  17.706  1.00  0.00           H  
ATOM   1239  HA  LYS A  84      17.796  14.514  18.206  1.00  0.00           H  
ATOM   1240  HB2 LYS A  84      18.688  14.445  15.848  1.00  0.00           H  
ATOM   1241  HB3 LYS A  84      17.109  15.187  16.039  1.00  0.00           H  
ATOM   1242  HG2 LYS A  84      19.046  17.234  16.281  1.00  0.00           H  
ATOM   1243  HG3 LYS A  84      19.466  16.264  14.870  1.00  0.00           H  
ATOM   1244  HD2 LYS A  84      17.996  17.685  13.873  1.00  0.00           H  
ATOM   1245  HD3 LYS A  84      16.841  16.480  14.449  1.00  0.00           H  
ATOM   1246  HE2 LYS A  84      16.311  17.812  16.367  1.00  0.00           H  
ATOM   1247  HE3 LYS A  84      17.610  18.946  16.000  1.00  0.00           H  
ATOM   1248  HZ1 LYS A  84      15.945  20.095  15.053  1.00  0.00           H  
ATOM   1249  HZ2 LYS A  84      14.953  18.738  14.854  1.00  0.00           H  
ATOM   1250  HZ3 LYS A  84      16.192  19.051  13.746  1.00  0.00           H  
ATOM   1251  N   GLU A  85      20.527  16.215  18.414  1.00  0.00           N  
ATOM   1252  CA  GLU A  85      21.944  16.157  18.757  1.00  0.00           C  
ATOM   1253  C   GLU A  85      22.190  15.141  19.867  1.00  0.00           C  
ATOM   1254  O   GLU A  85      23.241  14.501  19.918  1.00  0.00           O  
ATOM   1255  CB  GLU A  85      22.445  17.537  19.190  1.00  0.00           C  
ATOM   1256  CG  GLU A  85      22.697  18.485  18.027  1.00  0.00           C  
ATOM   1257  CD  GLU A  85      24.169  18.799  17.841  1.00  0.00           C  
ATOM   1258  OE1 GLU A  85      24.971  17.847  17.739  1.00  0.00           O  
ATOM   1259  OE2 GLU A  85      24.519  19.998  17.795  1.00  0.00           O  
ATOM   1260  H   GLU A  85      20.073  17.079  18.419  1.00  0.00           H  
ATOM   1261  HA  GLU A  85      22.486  15.848  17.875  1.00  0.00           H  
ATOM   1262  HB2 GLU A  85      21.706  17.986  19.838  1.00  0.00           H  
ATOM   1263  HB3 GLU A  85      23.367  17.417  19.738  1.00  0.00           H  
ATOM   1264  HG2 GLU A  85      22.325  18.030  17.122  1.00  0.00           H  
ATOM   1265  HG3 GLU A  85      22.168  19.408  18.211  1.00  0.00           H  
ATOM   1266  N   CYS A  86      21.206  14.991  20.748  1.00  0.00           N  
ATOM   1267  CA  CYS A  86      21.310  14.046  21.849  1.00  0.00           C  
ATOM   1268  C   CYS A  86      21.059  12.630  21.349  1.00  0.00           C  
ATOM   1269  O   CYS A  86      21.642  11.670  21.854  1.00  0.00           O  
ATOM   1270  CB  CYS A  86      20.311  14.399  22.952  1.00  0.00           C  
ATOM   1271  SG  CYS A  86      21.062  15.165  24.408  1.00  0.00           S  
ATOM   1272  H   CYS A  86      20.389  15.523  20.649  1.00  0.00           H  
ATOM   1273  HA  CYS A  86      22.312  14.106  22.245  1.00  0.00           H  
ATOM   1274  HB2 CYS A  86      19.579  15.090  22.560  1.00  0.00           H  
ATOM   1275  HB3 CYS A  86      19.808  13.500  23.277  1.00  0.00           H  
ATOM   1276  HG  CYS A  86      22.016  15.103  24.317  1.00  0.00           H  
ATOM   1277  N   ASP A  87      20.193  12.508  20.346  1.00  0.00           N  
ATOM   1278  CA  ASP A  87      19.874  11.209  19.773  1.00  0.00           C  
ATOM   1279  C   ASP A  87      21.126  10.561  19.199  1.00  0.00           C  
ATOM   1280  O   ASP A  87      21.337   9.357  19.339  1.00  0.00           O  
ATOM   1281  CB  ASP A  87      18.808  11.350  18.686  1.00  0.00           C  
ATOM   1282  CG  ASP A  87      17.410  11.074  19.205  1.00  0.00           C  
ATOM   1283  OD1 ASP A  87      17.033   9.885  19.291  1.00  0.00           O  
ATOM   1284  OD2 ASP A  87      16.694  12.044  19.527  1.00  0.00           O  
ATOM   1285  H   ASP A  87      19.765  13.312  19.982  1.00  0.00           H  
ATOM   1286  HA  ASP A  87      19.490  10.584  20.565  1.00  0.00           H  
ATOM   1287  HB2 ASP A  87      18.832  12.357  18.295  1.00  0.00           H  
ATOM   1288  HB3 ASP A  87      19.020  10.654  17.888  1.00  0.00           H  
ATOM   1289  N   PHE A  88      21.966  11.376  18.568  1.00  0.00           N  
ATOM   1290  CA  PHE A  88      23.208  10.884  17.989  1.00  0.00           C  
ATOM   1291  C   PHE A  88      24.199  10.553  19.098  1.00  0.00           C  
ATOM   1292  O   PHE A  88      24.859   9.513  19.073  1.00  0.00           O  
ATOM   1293  CB  PHE A  88      23.804  11.926  17.044  1.00  0.00           C  
ATOM   1294  CG  PHE A  88      24.966  11.415  16.242  1.00  0.00           C  
ATOM   1295  CD1 PHE A  88      24.790  10.409  15.303  1.00  0.00           C  
ATOM   1296  CD2 PHE A  88      26.237  11.939  16.425  1.00  0.00           C  
ATOM   1297  CE1 PHE A  88      25.857   9.938  14.564  1.00  0.00           C  
ATOM   1298  CE2 PHE A  88      27.308  11.470  15.688  1.00  0.00           C  
ATOM   1299  CZ  PHE A  88      27.118  10.469  14.757  1.00  0.00           C  
ATOM   1300  H   PHE A  88      21.748  12.332  18.501  1.00  0.00           H  
ATOM   1301  HA  PHE A  88      22.986   9.984  17.435  1.00  0.00           H  
ATOM   1302  HB2 PHE A  88      23.042  12.252  16.352  1.00  0.00           H  
ATOM   1303  HB3 PHE A  88      24.145  12.774  17.622  1.00  0.00           H  
ATOM   1304  HD1 PHE A  88      23.804   9.995  15.152  1.00  0.00           H  
ATOM   1305  HD2 PHE A  88      26.386  12.722  17.155  1.00  0.00           H  
ATOM   1306  HE1 PHE A  88      25.707   9.155  13.836  1.00  0.00           H  
ATOM   1307  HE2 PHE A  88      28.292  11.886  15.842  1.00  0.00           H  
ATOM   1308  HZ  PHE A  88      27.954  10.102  14.179  1.00  0.00           H  
ATOM   1309  N   GLN A  89      24.280  11.444  20.080  1.00  0.00           N  
ATOM   1310  CA  GLN A  89      25.172  11.253  21.214  1.00  0.00           C  
ATOM   1311  C   GLN A  89      24.782   9.999  21.985  1.00  0.00           C  
ATOM   1312  O   GLN A  89      25.637   9.284  22.505  1.00  0.00           O  
ATOM   1313  CB  GLN A  89      25.123  12.475  22.133  1.00  0.00           C  
ATOM   1314  CG  GLN A  89      26.389  12.675  22.947  1.00  0.00           C  
ATOM   1315  CD  GLN A  89      26.187  12.371  24.418  1.00  0.00           C  
ATOM   1316  OE1 GLN A  89      25.409  13.036  25.099  1.00  0.00           O  
ATOM   1317  NE2 GLN A  89      26.888  11.359  24.912  1.00  0.00           N  
ATOM   1318  H   GLN A  89      23.717  12.244  20.047  1.00  0.00           H  
ATOM   1319  HA  GLN A  89      26.176  11.134  20.834  1.00  0.00           H  
ATOM   1320  HB2 GLN A  89      24.965  13.357  21.530  1.00  0.00           H  
ATOM   1321  HB3 GLN A  89      24.295  12.363  22.814  1.00  0.00           H  
ATOM   1322  HG2 GLN A  89      27.157  12.021  22.563  1.00  0.00           H  
ATOM   1323  HG3 GLN A  89      26.708  13.702  22.848  1.00  0.00           H  
ATOM   1324 HE21 GLN A  89      27.489  10.874  24.308  1.00  0.00           H  
ATOM   1325 HE22 GLN A  89      26.777  11.138  25.860  1.00  0.00           H  
ATOM   1326  N   THR A  90      23.480   9.735  22.041  1.00  0.00           N  
ATOM   1327  CA  THR A  90      22.961   8.563  22.730  1.00  0.00           C  
ATOM   1328  C   THR A  90      23.406   7.293  22.040  1.00  0.00           C  
ATOM   1329  O   THR A  90      24.154   6.513  22.609  1.00  0.00           O  
ATOM   1330  CB  THR A  90      21.434   8.620  22.798  1.00  0.00           C  
ATOM   1331  OG1 THR A  90      21.002   9.847  23.358  1.00  0.00           O  
ATOM   1332  CG2 THR A  90      20.832   7.505  23.622  1.00  0.00           C  
ATOM   1333  H   THR A  90      22.851  10.339  21.598  1.00  0.00           H  
ATOM   1334  HA  THR A  90      23.356   8.547  23.731  1.00  0.00           H  
ATOM   1335  HB  THR A  90      21.037   8.544  21.796  1.00  0.00           H  
ATOM   1336  HG1 THR A  90      20.045   9.892  23.328  1.00  0.00           H  
ATOM   1337 HG21 THR A  90      20.150   6.933  23.011  1.00  0.00           H  
ATOM   1338 HG22 THR A  90      20.300   7.927  24.461  1.00  0.00           H  
ATOM   1339 HG23 THR A  90      21.621   6.859  23.981  1.00  0.00           H  
ATOM   1340  N   LYS A  91      22.951   7.085  20.814  1.00  0.00           N  
ATOM   1341  CA  LYS A  91      23.313   5.887  20.064  1.00  0.00           C  
ATOM   1342  C   LYS A  91      24.813   5.631  20.121  1.00  0.00           C  
ATOM   1343  O   LYS A  91      25.258   4.489  20.042  1.00  0.00           O  
ATOM   1344  CB  LYS A  91      22.849   6.001  18.612  1.00  0.00           C  
ATOM   1345  CG  LYS A  91      21.438   5.484  18.384  1.00  0.00           C  
ATOM   1346  CD  LYS A  91      20.410   6.339  19.107  1.00  0.00           C  
ATOM   1347  CE  LYS A  91      19.075   5.624  19.228  1.00  0.00           C  
ATOM   1348  NZ  LYS A  91      17.968   6.563  19.556  1.00  0.00           N  
ATOM   1349  H   LYS A  91      22.358   7.748  20.407  1.00  0.00           H  
ATOM   1350  HA  LYS A  91      22.813   5.054  20.532  1.00  0.00           H  
ATOM   1351  HB2 LYS A  91      22.885   7.038  18.314  1.00  0.00           H  
ATOM   1352  HB3 LYS A  91      23.522   5.433  17.986  1.00  0.00           H  
ATOM   1353  HG2 LYS A  91      21.224   5.504  17.324  1.00  0.00           H  
ATOM   1354  HG3 LYS A  91      21.372   4.472  18.749  1.00  0.00           H  
ATOM   1355  HD2 LYS A  91      20.778   6.563  20.098  1.00  0.00           H  
ATOM   1356  HD3 LYS A  91      20.267   7.258  18.558  1.00  0.00           H  
ATOM   1357  HE2 LYS A  91      18.857   5.136  18.289  1.00  0.00           H  
ATOM   1358  HE3 LYS A  91      19.149   4.882  20.009  1.00  0.00           H  
ATOM   1359  HZ1 LYS A  91      17.464   6.838  18.687  1.00  0.00           H  
ATOM   1360  HZ2 LYS A  91      18.349   7.419  20.008  1.00  0.00           H  
ATOM   1361  HZ3 LYS A  91      17.295   6.112  20.205  1.00  0.00           H  
ATOM   1362  N   PHE A  92      25.587   6.694  20.273  1.00  0.00           N  
ATOM   1363  CA  PHE A  92      27.033   6.561  20.358  1.00  0.00           C  
ATOM   1364  C   PHE A  92      27.473   6.422  21.811  1.00  0.00           C  
ATOM   1365  O   PHE A  92      28.525   5.855  22.103  1.00  0.00           O  
ATOM   1366  CB  PHE A  92      27.721   7.763  19.709  1.00  0.00           C  
ATOM   1367  CG  PHE A  92      29.134   7.486  19.279  1.00  0.00           C  
ATOM   1368  CD1 PHE A  92      29.411   6.465  18.385  1.00  0.00           C  
ATOM   1369  CD2 PHE A  92      30.181   8.249  19.767  1.00  0.00           C  
ATOM   1370  CE1 PHE A  92      30.709   6.208  17.988  1.00  0.00           C  
ATOM   1371  CE2 PHE A  92      31.482   7.997  19.372  1.00  0.00           C  
ATOM   1372  CZ  PHE A  92      31.745   6.975  18.481  1.00  0.00           C  
ATOM   1373  H   PHE A  92      25.181   7.586  20.341  1.00  0.00           H  
ATOM   1374  HA  PHE A  92      27.310   5.664  19.825  1.00  0.00           H  
ATOM   1375  HB2 PHE A  92      27.161   8.063  18.837  1.00  0.00           H  
ATOM   1376  HB3 PHE A  92      27.743   8.580  20.416  1.00  0.00           H  
ATOM   1377  HD1 PHE A  92      28.602   5.864  17.999  1.00  0.00           H  
ATOM   1378  HD2 PHE A  92      29.977   9.047  20.464  1.00  0.00           H  
ATOM   1379  HE1 PHE A  92      30.912   5.408  17.291  1.00  0.00           H  
ATOM   1380  HE2 PHE A  92      32.290   8.600  19.759  1.00  0.00           H  
ATOM   1381  HZ  PHE A  92      32.761   6.776  18.172  1.00  0.00           H  
ATOM   1382  N   ALA A  93      26.659   6.949  22.722  1.00  0.00           N  
ATOM   1383  CA  ALA A  93      26.961   6.889  24.147  1.00  0.00           C  
ATOM   1384  C   ALA A  93      26.352   5.653  24.808  1.00  0.00           C  
ATOM   1385  O   ALA A  93      26.845   5.181  25.831  1.00  0.00           O  
ATOM   1386  CB  ALA A  93      26.472   8.146  24.841  1.00  0.00           C  
ATOM   1387  H   ALA A  93      25.833   7.391  22.427  1.00  0.00           H  
ATOM   1388  HA  ALA A  93      28.033   6.847  24.255  1.00  0.00           H  
ATOM   1389  HB1 ALA A  93      26.508   8.004  25.911  1.00  0.00           H  
ATOM   1390  HB2 ALA A  93      25.455   8.350  24.539  1.00  0.00           H  
ATOM   1391  HB3 ALA A  93      27.104   8.977  24.565  1.00  0.00           H  
ATOM   1392  N   LEU A  94      25.275   5.138  24.225  1.00  0.00           N  
ATOM   1393  CA  LEU A  94      24.607   3.968  24.766  1.00  0.00           C  
ATOM   1394  C   LEU A  94      25.284   2.704  24.283  1.00  0.00           C  
ATOM   1395  O   LEU A  94      25.583   1.793  25.054  1.00  0.00           O  
ATOM   1396  CB  LEU A  94      23.140   3.973  24.346  1.00  0.00           C  
ATOM   1397  CG  LEU A  94      22.856   4.136  22.848  1.00  0.00           C  
ATOM   1398  CD1 LEU A  94      22.924   2.808  22.135  1.00  0.00           C  
ATOM   1399  CD2 LEU A  94      21.492   4.781  22.636  1.00  0.00           C  
ATOM   1400  H   LEU A  94      24.917   5.552  23.411  1.00  0.00           H  
ATOM   1401  HA  LEU A  94      24.666   4.012  25.844  1.00  0.00           H  
ATOM   1402  HB2 LEU A  94      22.691   3.055  24.675  1.00  0.00           H  
ATOM   1403  HB3 LEU A  94      22.670   4.781  24.851  1.00  0.00           H  
ATOM   1404  HG  LEU A  94      23.599   4.777  22.411  1.00  0.00           H  
ATOM   1405 HD11 LEU A  94      21.941   2.538  21.782  1.00  0.00           H  
ATOM   1406 HD12 LEU A  94      23.284   2.054  22.817  1.00  0.00           H  
ATOM   1407 HD13 LEU A  94      23.598   2.891  21.296  1.00  0.00           H  
ATOM   1408 HD21 LEU A  94      20.844   4.090  22.114  1.00  0.00           H  
ATOM   1409 HD22 LEU A  94      21.604   5.678  22.049  1.00  0.00           H  
ATOM   1410 HD23 LEU A  94      21.057   5.028  23.591  1.00  0.00           H  
ATOM   1411  N   SER A  95      25.522   2.677  22.990  1.00  0.00           N  
ATOM   1412  CA  SER A  95      26.174   1.542  22.347  1.00  0.00           C  
ATOM   1413  C   SER A  95      27.598   1.901  21.942  1.00  0.00           C  
ATOM   1414  O   SER A  95      27.982   1.761  20.779  1.00  0.00           O  
ATOM   1415  CB  SER A  95      25.378   1.082  21.122  1.00  0.00           C  
ATOM   1416  OG  SER A  95      25.460   2.030  20.073  1.00  0.00           O  
ATOM   1417  H   SER A  95      25.248   3.453  22.456  1.00  0.00           H  
ATOM   1418  HA  SER A  95      26.211   0.734  23.063  1.00  0.00           H  
ATOM   1419  HB2 SER A  95      25.774   0.142  20.771  1.00  0.00           H  
ATOM   1420  HB3 SER A  95      24.341   0.954  21.395  1.00  0.00           H  
ATOM   1421  HG  SER A  95      25.394   2.915  20.434  1.00  0.00           H  
ATOM   1422  N   LEU A  96      28.378   2.363  22.911  1.00  0.00           N  
ATOM   1423  CA  LEU A  96      29.766   2.742  22.659  1.00  0.00           C  
ATOM   1424  C   LEU A  96      30.661   1.508  22.630  1.00  0.00           C  
ATOM   1425  O   LEU A  96      31.043   1.026  21.564  1.00  0.00           O  
ATOM   1426  CB  LEU A  96      30.283   3.733  23.715  1.00  0.00           C  
ATOM   1427  CG  LEU A  96      29.297   4.117  24.820  1.00  0.00           C  
ATOM   1428  CD1 LEU A  96      29.252   3.043  25.896  1.00  0.00           C  
ATOM   1429  CD2 LEU A  96      29.685   5.457  25.423  1.00  0.00           C  
ATOM   1430  H   LEU A  96      28.012   2.443  23.814  1.00  0.00           H  
ATOM   1431  HA  LEU A  96      29.802   3.217  21.693  1.00  0.00           H  
ATOM   1432  HB2 LEU A  96      31.158   3.307  24.181  1.00  0.00           H  
ATOM   1433  HB3 LEU A  96      30.580   4.638  23.205  1.00  0.00           H  
ATOM   1434  HG  LEU A  96      28.310   4.213  24.399  1.00  0.00           H  
ATOM   1435 HD11 LEU A  96      28.525   3.316  26.646  1.00  0.00           H  
ATOM   1436 HD12 LEU A  96      30.226   2.952  26.356  1.00  0.00           H  
ATOM   1437 HD13 LEU A  96      28.975   2.099  25.452  1.00  0.00           H  
ATOM   1438 HD21 LEU A  96      30.625   5.358  25.942  1.00  0.00           H  
ATOM   1439 HD22 LEU A  96      28.922   5.775  26.116  1.00  0.00           H  
ATOM   1440 HD23 LEU A  96      29.784   6.189  24.635  1.00  0.00           H  
ATOM   1441  N   SER A  97      30.993   1.003  23.814  1.00  0.00           N  
ATOM   1442  CA  SER A  97      31.842  -0.174  23.940  1.00  0.00           C  
ATOM   1443  C   SER A  97      31.238  -1.177  24.920  1.00  0.00           C  
ATOM   1444  O   SER A  97      30.343  -0.839  25.697  1.00  0.00           O  
ATOM   1445  CB  SER A  97      33.243   0.230  24.403  1.00  0.00           C  
ATOM   1446  OG  SER A  97      34.113   0.411  23.299  1.00  0.00           O  
ATOM   1447  H   SER A  97      30.653   1.437  24.624  1.00  0.00           H  
ATOM   1448  HA  SER A  97      31.912  -0.638  22.968  1.00  0.00           H  
ATOM   1449  HB2 SER A  97      33.183   1.157  24.954  1.00  0.00           H  
ATOM   1450  HB3 SER A  97      33.646  -0.543  25.040  1.00  0.00           H  
ATOM   1451  HG  SER A  97      34.653   1.191  23.442  1.00  0.00           H  
ATOM   1452  N   PRO A  98      31.719  -2.432  24.896  1.00  0.00           N  
ATOM   1453  CA  PRO A  98      31.222  -3.486  25.784  1.00  0.00           C  
ATOM   1454  C   PRO A  98      31.713  -3.323  27.219  1.00  0.00           C  
ATOM   1455  O   PRO A  98      32.637  -4.013  27.650  1.00  0.00           O  
ATOM   1456  CB  PRO A  98      31.794  -4.760  25.164  1.00  0.00           C  
ATOM   1457  CG  PRO A  98      33.047  -4.317  24.492  1.00  0.00           C  
ATOM   1458  CD  PRO A  98      32.784  -2.921  23.999  1.00  0.00           C  
ATOM   1459  HA  PRO A  98      30.143  -3.533  25.777  1.00  0.00           H  
ATOM   1460  HB2 PRO A  98      31.995  -5.483  25.944  1.00  0.00           H  
ATOM   1461  HB3 PRO A  98      31.090  -5.170  24.456  1.00  0.00           H  
ATOM   1462  HG2 PRO A  98      33.862  -4.317  25.201  1.00  0.00           H  
ATOM   1463  HG3 PRO A  98      33.270  -4.972  23.664  1.00  0.00           H  
ATOM   1464  HD2 PRO A  98      33.672  -2.314  24.090  1.00  0.00           H  
ATOM   1465  HD3 PRO A  98      32.443  -2.941  22.974  1.00  0.00           H  
ATOM   1466  N   GLY A  99      31.088  -2.410  27.955  1.00  0.00           N  
ATOM   1467  CA  GLY A  99      31.474  -2.181  29.335  1.00  0.00           C  
ATOM   1468  C   GLY A  99      31.842  -0.734  29.610  1.00  0.00           C  
ATOM   1469  O   GLY A  99      32.755  -0.458  30.388  1.00  0.00           O  
ATOM   1470  H   GLY A  99      30.356  -1.892  27.558  1.00  0.00           H  
ATOM   1471  HA2 GLY A  99      30.652  -2.457  29.977  1.00  0.00           H  
ATOM   1472  HA3 GLY A  99      32.324  -2.807  29.569  1.00  0.00           H  
ATOM   1473  N   ALA A 100      31.132   0.189  28.973  1.00  0.00           N  
ATOM   1474  CA  ALA A 100      31.391   1.611  29.158  1.00  0.00           C  
ATOM   1475  C   ALA A 100      30.091   2.410  29.164  1.00  0.00           C  
ATOM   1476  O   ALA A 100      29.987   3.452  28.517  1.00  0.00           O  
ATOM   1477  CB  ALA A 100      32.323   2.123  28.071  1.00  0.00           C  
ATOM   1478  H   ALA A 100      30.415  -0.092  28.365  1.00  0.00           H  
ATOM   1479  HA  ALA A 100      31.883   1.738  30.112  1.00  0.00           H  
ATOM   1480  HB1 ALA A 100      32.547   3.164  28.249  1.00  0.00           H  
ATOM   1481  HB2 ALA A 100      31.847   2.016  27.107  1.00  0.00           H  
ATOM   1482  HB3 ALA A 100      33.239   1.551  28.084  1.00  0.00           H  
ATOM   1483  N   HIS A 101      29.101   1.916  29.901  1.00  0.00           N  
ATOM   1484  CA  HIS A 101      27.808   2.587  29.992  1.00  0.00           C  
ATOM   1485  C   HIS A 101      27.875   3.759  30.967  1.00  0.00           C  
ATOM   1486  O   HIS A 101      27.278   4.810  30.732  1.00  0.00           O  
ATOM   1487  CB  HIS A 101      26.726   1.598  30.429  1.00  0.00           C  
ATOM   1488  CG  HIS A 101      25.614   1.452  29.437  1.00  0.00           C  
ATOM   1489  ND1 HIS A 101      25.618   0.502  28.435  1.00  0.00           N  
ATOM   1490  CD2 HIS A 101      24.457   2.141  29.293  1.00  0.00           C  
ATOM   1491  CE1 HIS A 101      24.513   0.615  27.721  1.00  0.00           C  
ATOM   1492  NE2 HIS A 101      23.791   1.601  28.221  1.00  0.00           N  
ATOM   1493  H   HIS A 101      29.242   1.083  30.396  1.00  0.00           H  
ATOM   1494  HA  HIS A 101      27.563   2.965  29.010  1.00  0.00           H  
ATOM   1495  HB2 HIS A 101      27.174   0.626  30.571  1.00  0.00           H  
ATOM   1496  HB3 HIS A 101      26.296   1.931  31.363  1.00  0.00           H  
ATOM   1497  HD1 HIS A 101      26.326  -0.156  28.274  1.00  0.00           H  
ATOM   1498  HD2 HIS A 101      24.120   2.962  29.909  1.00  0.00           H  
ATOM   1499  HE1 HIS A 101      24.245   0.004  26.871  1.00  0.00           H  
ATOM   1500  HE2 HIS A 101      22.890   1.847  27.928  1.00  0.00           H  
ATOM   1501  N   GLN A 102      28.604   3.566  32.057  1.00  0.00           N  
ATOM   1502  CA  GLN A 102      28.756   4.601  33.072  1.00  0.00           C  
ATOM   1503  C   GLN A 102      30.097   4.466  33.784  1.00  0.00           C  
ATOM   1504  O   GLN A 102      30.236   4.842  34.948  1.00  0.00           O  
ATOM   1505  CB  GLN A 102      27.615   4.524  34.086  1.00  0.00           C  
ATOM   1506  CG  GLN A 102      27.595   3.229  34.882  1.00  0.00           C  
ATOM   1507  CD  GLN A 102      26.651   3.286  36.066  1.00  0.00           C  
ATOM   1508  OE1 GLN A 102      25.465   3.583  35.915  1.00  0.00           O  
ATOM   1509  NE2 GLN A 102      27.172   3.002  37.254  1.00  0.00           N  
ATOM   1510  H   GLN A 102      29.055   2.705  32.183  1.00  0.00           H  
ATOM   1511  HA  GLN A 102      28.720   5.560  32.574  1.00  0.00           H  
ATOM   1512  HB2 GLN A 102      27.709   5.347  34.781  1.00  0.00           H  
ATOM   1513  HB3 GLN A 102      26.675   4.614  33.562  1.00  0.00           H  
ATOM   1514  HG2 GLN A 102      27.285   2.426  34.232  1.00  0.00           H  
ATOM   1515  HG3 GLN A 102      28.594   3.031  35.247  1.00  0.00           H  
ATOM   1516 HE21 GLN A 102      28.124   2.774  37.300  1.00  0.00           H  
ATOM   1517 HE22 GLN A 102      26.583   3.031  38.038  1.00  0.00           H  
ATOM   1518  N   LYS A 103      31.083   3.921  33.077  1.00  0.00           N  
ATOM   1519  CA  LYS A 103      32.413   3.729  33.636  1.00  0.00           C  
ATOM   1520  C   LYS A 103      33.346   4.865  33.228  1.00  0.00           C  
ATOM   1521  O   LYS A 103      34.269   5.215  33.962  1.00  0.00           O  
ATOM   1522  CB  LYS A 103      32.988   2.391  33.170  1.00  0.00           C  
ATOM   1523  CG  LYS A 103      32.551   1.210  34.020  1.00  0.00           C  
ATOM   1524  CD  LYS A 103      31.120   0.800  33.711  1.00  0.00           C  
ATOM   1525  CE  LYS A 103      30.825  -0.608  34.203  1.00  0.00           C  
ATOM   1526  NZ  LYS A 103      30.698  -1.576  33.076  1.00  0.00           N  
ATOM   1527  H   LYS A 103      30.909   3.638  32.156  1.00  0.00           H  
ATOM   1528  HA  LYS A 103      32.323   3.717  34.712  1.00  0.00           H  
ATOM   1529  HB2 LYS A 103      32.668   2.212  32.153  1.00  0.00           H  
ATOM   1530  HB3 LYS A 103      34.063   2.449  33.194  1.00  0.00           H  
ATOM   1531  HG2 LYS A 103      33.207   0.376  33.823  1.00  0.00           H  
ATOM   1532  HG3 LYS A 103      32.621   1.486  35.062  1.00  0.00           H  
ATOM   1533  HD2 LYS A 103      30.446   1.488  34.199  1.00  0.00           H  
ATOM   1534  HD3 LYS A 103      30.968   0.839  32.643  1.00  0.00           H  
ATOM   1535  HE2 LYS A 103      31.628  -0.927  34.850  1.00  0.00           H  
ATOM   1536  HE3 LYS A 103      29.899  -0.595  34.759  1.00  0.00           H  
ATOM   1537  HZ1 LYS A 103      29.698  -1.812  32.919  1.00  0.00           H  
ATOM   1538  HZ2 LYS A 103      31.221  -2.449  33.296  1.00  0.00           H  
ATOM   1539  HZ3 LYS A 103      31.087  -1.164  32.204  1.00  0.00           H  
ATOM   1540  N   ARG A 104      33.101   5.428  32.050  1.00  0.00           N  
ATOM   1541  CA  ARG A 104      33.925   6.518  31.542  1.00  0.00           C  
ATOM   1542  C   ARG A 104      33.104   7.791  31.352  1.00  0.00           C  
ATOM   1543  O   ARG A 104      33.597   8.897  31.571  1.00  0.00           O  
ATOM   1544  CB  ARG A 104      34.571   6.115  30.216  1.00  0.00           C  
ATOM   1545  CG  ARG A 104      35.211   4.736  30.247  1.00  0.00           C  
ATOM   1546  CD  ARG A 104      35.575   4.255  28.850  1.00  0.00           C  
ATOM   1547  NE  ARG A 104      37.018   4.083  28.689  1.00  0.00           N  
ATOM   1548  CZ  ARG A 104      37.610   3.833  27.524  1.00  0.00           C  
ATOM   1549  NH1 ARG A 104      36.887   3.727  26.415  1.00  0.00           N  
ATOM   1550  NH2 ARG A 104      38.926   3.689  27.466  1.00  0.00           N  
ATOM   1551  H   ARG A 104      32.354   5.101  31.508  1.00  0.00           H  
ATOM   1552  HA  ARG A 104      34.703   6.712  32.264  1.00  0.00           H  
ATOM   1553  HB2 ARG A 104      33.816   6.119  29.443  1.00  0.00           H  
ATOM   1554  HB3 ARG A 104      35.334   6.836  29.964  1.00  0.00           H  
ATOM   1555  HG2 ARG A 104      36.109   4.781  30.846  1.00  0.00           H  
ATOM   1556  HG3 ARG A 104      34.517   4.038  30.688  1.00  0.00           H  
ATOM   1557  HD2 ARG A 104      35.088   3.311  28.670  1.00  0.00           H  
ATOM   1558  HD3 ARG A 104      35.228   4.982  28.131  1.00  0.00           H  
ATOM   1559  HE  ARG A 104      37.574   4.155  29.493  1.00  0.00           H  
ATOM   1560 HH11 ARG A 104      35.894   3.834  26.451  1.00  0.00           H  
ATOM   1561 HH12 ARG A 104      37.338   3.541  25.542  1.00  0.00           H  
ATOM   1562 HH21 ARG A 104      39.474   3.767  28.299  1.00  0.00           H  
ATOM   1563 HH22 ARG A 104      39.371   3.502  26.591  1.00  0.00           H  
ATOM   1564  N   LEU A 105      31.849   7.628  30.940  1.00  0.00           N  
ATOM   1565  CA  LEU A 105      30.966   8.765  30.718  1.00  0.00           C  
ATOM   1566  C   LEU A 105      30.031   8.976  31.904  1.00  0.00           C  
ATOM   1567  O   LEU A 105      29.609   8.018  32.553  1.00  0.00           O  
ATOM   1568  CB  LEU A 105      30.147   8.559  29.444  1.00  0.00           C  
ATOM   1569  CG  LEU A 105      29.714   7.117  29.168  1.00  0.00           C  
ATOM   1570  CD1 LEU A 105      28.341   7.086  28.517  1.00  0.00           C  
ATOM   1571  CD2 LEU A 105      30.738   6.413  28.292  1.00  0.00           C  
ATOM   1572  H   LEU A 105      31.511   6.726  30.779  1.00  0.00           H  
ATOM   1573  HA  LEU A 105      31.582   9.642  30.599  1.00  0.00           H  
ATOM   1574  HB2 LEU A 105      29.261   9.167  29.514  1.00  0.00           H  
ATOM   1575  HB3 LEU A 105      30.733   8.901  28.604  1.00  0.00           H  
ATOM   1576  HG  LEU A 105      29.650   6.583  30.105  1.00  0.00           H  
ATOM   1577 HD11 LEU A 105      27.865   6.138  28.723  1.00  0.00           H  
ATOM   1578 HD12 LEU A 105      28.447   7.209  27.449  1.00  0.00           H  
ATOM   1579 HD13 LEU A 105      27.735   7.886  28.913  1.00  0.00           H  
ATOM   1580 HD21 LEU A 105      30.290   5.536  27.849  1.00  0.00           H  
ATOM   1581 HD22 LEU A 105      31.586   6.118  28.893  1.00  0.00           H  
ATOM   1582 HD23 LEU A 105      31.065   7.083  27.512  1.00  0.00           H  
ATOM   1583  N   ILE A 106      29.709  10.236  32.183  1.00  0.00           N  
ATOM   1584  CA  ILE A 106      28.817  10.567  33.289  1.00  0.00           C  
ATOM   1585  C   ILE A 106      27.851  11.690  32.909  1.00  0.00           C  
ATOM   1586  O   ILE A 106      28.274  12.784  32.533  1.00  0.00           O  
ATOM   1587  CB  ILE A 106      29.603  10.991  34.546  1.00  0.00           C  
ATOM   1588  CG1 ILE A 106      30.721  11.976  34.177  1.00  0.00           C  
ATOM   1589  CG2 ILE A 106      30.161   9.767  35.262  1.00  0.00           C  
ATOM   1590  CD1 ILE A 106      32.011  11.311  33.743  1.00  0.00           C  
ATOM   1591  H   ILE A 106      30.073  10.957  31.630  1.00  0.00           H  
ATOM   1592  HA  ILE A 106      28.250   9.680  33.531  1.00  0.00           H  
ATOM   1593  HB  ILE A 106      28.916  11.481  35.219  1.00  0.00           H  
ATOM   1594 HG12 ILE A 106      30.384  12.600  33.364  1.00  0.00           H  
ATOM   1595 HG13 ILE A 106      30.940  12.596  35.034  1.00  0.00           H  
ATOM   1596 HG21 ILE A 106      31.122  10.012  35.694  1.00  0.00           H  
ATOM   1597 HG22 ILE A 106      30.278   8.960  34.555  1.00  0.00           H  
ATOM   1598 HG23 ILE A 106      29.480   9.467  36.046  1.00  0.00           H  
ATOM   1599 HD11 ILE A 106      31.787  10.408  33.196  1.00  0.00           H  
ATOM   1600 HD12 ILE A 106      32.601  11.066  34.614  1.00  0.00           H  
ATOM   1601 HD13 ILE A 106      32.568  11.987  33.111  1.00  0.00           H  
ATOM   1602  N   PRO A 107      26.532  11.429  32.994  1.00  0.00           N  
ATOM   1603  CA  PRO A 107      25.499  12.419  32.654  1.00  0.00           C  
ATOM   1604  C   PRO A 107      25.371  13.522  33.701  1.00  0.00           C  
ATOM   1605  O   PRO A 107      25.619  13.302  34.886  1.00  0.00           O  
ATOM   1606  CB  PRO A 107      24.218  11.584  32.612  1.00  0.00           C  
ATOM   1607  CG  PRO A 107      24.480  10.465  33.558  1.00  0.00           C  
ATOM   1608  CD  PRO A 107      25.940  10.145  33.416  1.00  0.00           C  
ATOM   1609  HA  PRO A 107      25.676  12.862  31.686  1.00  0.00           H  
ATOM   1610  HB2 PRO A 107      23.381  12.186  32.931  1.00  0.00           H  
ATOM   1611  HB3 PRO A 107      24.052  11.222  31.609  1.00  0.00           H  
ATOM   1612  HG2 PRO A 107      24.259  10.779  34.568  1.00  0.00           H  
ATOM   1613  HG3 PRO A 107      23.880   9.609  33.291  1.00  0.00           H  
ATOM   1614  HD2 PRO A 107      26.352   9.822  34.359  1.00  0.00           H  
ATOM   1615  HD3 PRO A 107      26.089   9.389  32.661  1.00  0.00           H  
ATOM   1616  N   ILE A 108      24.978  14.711  33.250  1.00  0.00           N  
ATOM   1617  CA  ILE A 108      24.809  15.856  34.138  1.00  0.00           C  
ATOM   1618  C   ILE A 108      23.722  16.794  33.610  1.00  0.00           C  
ATOM   1619  O   ILE A 108      23.383  16.757  32.427  1.00  0.00           O  
ATOM   1620  CB  ILE A 108      26.137  16.628  34.301  1.00  0.00           C  
ATOM   1621  CG1 ILE A 108      27.148  15.781  35.077  1.00  0.00           C  
ATOM   1622  CG2 ILE A 108      25.919  17.960  35.006  1.00  0.00           C  
ATOM   1623  CD1 ILE A 108      28.005  14.903  34.193  1.00  0.00           C  
ATOM   1624  H   ILE A 108      24.794  14.820  32.294  1.00  0.00           H  
ATOM   1625  HA  ILE A 108      24.510  15.483  35.108  1.00  0.00           H  
ATOM   1626  HB  ILE A 108      26.533  16.829  33.316  1.00  0.00           H  
ATOM   1627 HG12 ILE A 108      27.804  16.432  35.633  1.00  0.00           H  
ATOM   1628 HG13 ILE A 108      26.616  15.140  35.765  1.00  0.00           H  
ATOM   1629 HG21 ILE A 108      26.872  18.430  35.194  1.00  0.00           H  
ATOM   1630 HG22 ILE A 108      25.407  17.793  35.944  1.00  0.00           H  
ATOM   1631 HG23 ILE A 108      25.317  18.605  34.381  1.00  0.00           H  
ATOM   1632 HD11 ILE A 108      27.710  15.031  33.161  1.00  0.00           H  
ATOM   1633 HD12 ILE A 108      27.876  13.869  34.478  1.00  0.00           H  
ATOM   1634 HD13 ILE A 108      29.043  15.181  34.308  1.00  0.00           H  
ATOM   1635  N   LYS A 109      23.182  17.633  34.488  1.00  0.00           N  
ATOM   1636  CA  LYS A 109      22.139  18.576  34.094  1.00  0.00           C  
ATOM   1637  C   LYS A 109      21.947  19.660  35.150  1.00  0.00           C  
ATOM   1638  O   LYS A 109      22.287  19.471  36.319  1.00  0.00           O  
ATOM   1639  CB  LYS A 109      20.819  17.842  33.851  1.00  0.00           C  
ATOM   1640  CG  LYS A 109      20.355  17.007  35.034  1.00  0.00           C  
ATOM   1641  CD  LYS A 109      20.581  15.523  34.793  1.00  0.00           C  
ATOM   1642  CE  LYS A 109      19.600  14.673  35.582  1.00  0.00           C  
ATOM   1643  NZ  LYS A 109      18.186  15.065  35.323  1.00  0.00           N  
ATOM   1644  H   LYS A 109      23.490  17.621  35.418  1.00  0.00           H  
ATOM   1645  HA  LYS A 109      22.452  19.045  33.173  1.00  0.00           H  
ATOM   1646  HB2 LYS A 109      20.052  18.569  33.628  1.00  0.00           H  
ATOM   1647  HB3 LYS A 109      20.940  17.188  33.002  1.00  0.00           H  
ATOM   1648  HG2 LYS A 109      20.906  17.307  35.913  1.00  0.00           H  
ATOM   1649  HG3 LYS A 109      19.301  17.180  35.192  1.00  0.00           H  
ATOM   1650  HD2 LYS A 109      20.457  15.317  33.741  1.00  0.00           H  
ATOM   1651  HD3 LYS A 109      21.589  15.270  35.096  1.00  0.00           H  
ATOM   1652  HE2 LYS A 109      19.733  13.638  35.302  1.00  0.00           H  
ATOM   1653  HE3 LYS A 109      19.808  14.790  36.635  1.00  0.00           H  
ATOM   1654  HZ1 LYS A 109      17.614  14.221  35.113  1.00  0.00           H  
ATOM   1655  HZ2 LYS A 109      18.137  15.714  34.512  1.00  0.00           H  
ATOM   1656  HZ3 LYS A 109      17.788  15.540  36.157  1.00  0.00           H  
ATOM   1657  N   TYR A 110      21.398  20.793  34.728  1.00  0.00           N  
ATOM   1658  CA  TYR A 110      21.157  21.913  35.634  1.00  0.00           C  
ATOM   1659  C   TYR A 110      19.790  21.799  36.309  1.00  0.00           C  
ATOM   1660  O   TYR A 110      19.386  22.686  37.059  1.00  0.00           O  
ATOM   1661  CB  TYR A 110      21.256  23.239  34.876  1.00  0.00           C  
ATOM   1662  CG  TYR A 110      20.249  23.375  33.755  1.00  0.00           C  
ATOM   1663  CD1 TYR A 110      20.524  22.889  32.484  1.00  0.00           C  
ATOM   1664  CD2 TYR A 110      19.023  23.997  33.968  1.00  0.00           C  
ATOM   1665  CE1 TYR A 110      19.606  23.014  31.457  1.00  0.00           C  
ATOM   1666  CE2 TYR A 110      18.101  24.125  32.946  1.00  0.00           C  
ATOM   1667  CZ  TYR A 110      18.398  23.631  31.694  1.00  0.00           C  
ATOM   1668  OH  TYR A 110      17.482  23.759  30.674  1.00  0.00           O  
ATOM   1669  H   TYR A 110      21.150  20.883  33.784  1.00  0.00           H  
ATOM   1670  HA  TYR A 110      21.922  21.890  36.395  1.00  0.00           H  
ATOM   1671  HB2 TYR A 110      21.095  24.053  35.566  1.00  0.00           H  
ATOM   1672  HB3 TYR A 110      22.244  23.327  34.448  1.00  0.00           H  
ATOM   1673  HD1 TYR A 110      21.472  22.403  32.302  1.00  0.00           H  
ATOM   1674  HD2 TYR A 110      18.794  24.381  34.951  1.00  0.00           H  
ATOM   1675  HE1 TYR A 110      19.840  22.627  30.475  1.00  0.00           H  
ATOM   1676  HE2 TYR A 110      17.155  24.610  33.131  1.00  0.00           H  
ATOM   1677  HH  TYR A 110      17.941  23.953  29.854  1.00  0.00           H  
ATOM   1678  N   LYS A 111      19.082  20.703  36.040  1.00  0.00           N  
ATOM   1679  CA  LYS A 111      17.765  20.479  36.627  1.00  0.00           C  
ATOM   1680  C   LYS A 111      17.143  19.196  36.083  1.00  0.00           C  
ATOM   1681  O   LYS A 111      17.587  18.662  35.067  1.00  0.00           O  
ATOM   1682  CB  LYS A 111      16.840  21.665  36.346  1.00  0.00           C  
ATOM   1683  CG  LYS A 111      16.860  22.126  34.897  1.00  0.00           C  
ATOM   1684  CD  LYS A 111      15.668  21.587  34.123  1.00  0.00           C  
ATOM   1685  CE  LYS A 111      14.552  22.617  34.028  1.00  0.00           C  
ATOM   1686  NZ  LYS A 111      14.027  22.739  32.642  1.00  0.00           N  
ATOM   1687  H   LYS A 111      19.454  20.026  35.437  1.00  0.00           H  
ATOM   1688  HA  LYS A 111      17.890  20.376  37.693  1.00  0.00           H  
ATOM   1689  HB2 LYS A 111      15.828  21.386  36.598  1.00  0.00           H  
ATOM   1690  HB3 LYS A 111      17.140  22.495  36.968  1.00  0.00           H  
ATOM   1691  HG2 LYS A 111      16.834  23.204  34.873  1.00  0.00           H  
ATOM   1692  HG3 LYS A 111      17.770  21.776  34.431  1.00  0.00           H  
ATOM   1693  HD2 LYS A 111      15.986  21.324  33.126  1.00  0.00           H  
ATOM   1694  HD3 LYS A 111      15.293  20.707  34.626  1.00  0.00           H  
ATOM   1695  HE2 LYS A 111      13.747  22.318  34.684  1.00  0.00           H  
ATOM   1696  HE3 LYS A 111      14.936  23.575  34.346  1.00  0.00           H  
ATOM   1697  HZ1 LYS A 111      14.627  23.386  32.088  1.00  0.00           H  
ATOM   1698  HZ2 LYS A 111      13.057  23.113  32.657  1.00  0.00           H  
ATOM   1699  HZ3 LYS A 111      14.022  21.810  32.177  1.00  0.00           H  
ATOM   1700  N   ALA A 112      16.115  18.707  36.767  1.00  0.00           N  
ATOM   1701  CA  ALA A 112      15.434  17.486  36.352  1.00  0.00           C  
ATOM   1702  C   ALA A 112      14.728  17.678  35.014  1.00  0.00           C  
ATOM   1703  O   ALA A 112      14.185  18.747  34.735  1.00  0.00           O  
ATOM   1704  CB  ALA A 112      14.442  17.047  37.419  1.00  0.00           C  
ATOM   1705  H   ALA A 112      15.808  19.176  37.570  1.00  0.00           H  
ATOM   1706  HA  ALA A 112      16.179  16.711  36.247  1.00  0.00           H  
ATOM   1707  HB1 ALA A 112      14.964  16.877  38.348  1.00  0.00           H  
ATOM   1708  HB2 ALA A 112      13.957  16.134  37.105  1.00  0.00           H  
ATOM   1709  HB3 ALA A 112      13.700  17.818  37.558  1.00  0.00           H  
ATOM   1710  N   MET A 113      14.739  16.634  34.192  1.00  0.00           N  
ATOM   1711  CA  MET A 113      14.100  16.684  32.883  1.00  0.00           C  
ATOM   1712  C   MET A 113      12.612  16.362  32.993  1.00  0.00           C  
ATOM   1713  O   MET A 113      12.229  15.279  33.432  1.00  0.00           O  
ATOM   1714  CB  MET A 113      14.781  15.707  31.926  1.00  0.00           C  
ATOM   1715  CG  MET A 113      16.262  15.988  31.729  1.00  0.00           C  
ATOM   1716  SD  MET A 113      17.294  14.542  32.036  1.00  0.00           S  
ATOM   1717  CE  MET A 113      16.371  13.286  31.154  1.00  0.00           C  
ATOM   1718  H   MET A 113      15.189  15.811  34.473  1.00  0.00           H  
ATOM   1719  HA  MET A 113      14.211  17.685  32.498  1.00  0.00           H  
ATOM   1720  HB2 MET A 113      14.675  14.705  32.318  1.00  0.00           H  
ATOM   1721  HB3 MET A 113      14.294  15.761  30.966  1.00  0.00           H  
ATOM   1722  HG2 MET A 113      16.420  16.314  30.710  1.00  0.00           H  
ATOM   1723  HG3 MET A 113      16.559  16.776  32.408  1.00  0.00           H  
ATOM   1724  HE1 MET A 113      15.612  13.758  30.545  1.00  0.00           H  
ATOM   1725  HE2 MET A 113      15.903  12.620  31.861  1.00  0.00           H  
ATOM   1726  HE3 MET A 113      17.042  12.725  30.521  1.00  0.00           H  
ATOM   1727  N   LYS A 114      11.782  17.321  32.596  1.00  0.00           N  
ATOM   1728  CA  LYS A 114      10.334  17.156  32.652  1.00  0.00           C  
ATOM   1729  C   LYS A 114       9.833  16.171  31.595  1.00  0.00           C  
ATOM   1730  O   LYS A 114       8.671  15.766  31.625  1.00  0.00           O  
ATOM   1731  CB  LYS A 114       9.646  18.511  32.470  1.00  0.00           C  
ATOM   1732  CG  LYS A 114       8.749  18.896  33.637  1.00  0.00           C  
ATOM   1733  CD  LYS A 114       9.405  19.942  34.525  1.00  0.00           C  
ATOM   1734  CE  LYS A 114      10.297  19.300  35.576  1.00  0.00           C  
ATOM   1735  NZ  LYS A 114      10.402  20.137  36.803  1.00  0.00           N  
ATOM   1736  H   LYS A 114      12.153  18.165  32.263  1.00  0.00           H  
ATOM   1737  HA  LYS A 114      10.087  16.768  33.628  1.00  0.00           H  
ATOM   1738  HB2 LYS A 114      10.402  19.275  32.359  1.00  0.00           H  
ATOM   1739  HB3 LYS A 114       9.042  18.482  31.577  1.00  0.00           H  
ATOM   1740  HG2 LYS A 114       7.825  19.298  33.250  1.00  0.00           H  
ATOM   1741  HG3 LYS A 114       8.543  18.014  34.226  1.00  0.00           H  
ATOM   1742  HD2 LYS A 114      10.004  20.597  33.911  1.00  0.00           H  
ATOM   1743  HD3 LYS A 114       8.634  20.513  35.020  1.00  0.00           H  
ATOM   1744  HE2 LYS A 114       9.884  18.338  35.843  1.00  0.00           H  
ATOM   1745  HE3 LYS A 114      11.284  19.164  35.157  1.00  0.00           H  
ATOM   1746  HZ1 LYS A 114      10.920  21.014  36.592  1.00  0.00           H  
ATOM   1747  HZ2 LYS A 114      10.908  19.618  37.548  1.00  0.00           H  
ATOM   1748  HZ3 LYS A 114       9.453  20.385  37.149  1.00  0.00           H  
ATOM   1749  N   LYS A 115      10.703  15.781  30.663  1.00  0.00           N  
ATOM   1750  CA  LYS A 115      10.308  14.839  29.617  1.00  0.00           C  
ATOM   1751  C   LYS A 115      10.960  13.471  29.833  1.00  0.00           C  
ATOM   1752  O   LYS A 115      11.387  13.152  30.943  1.00  0.00           O  
ATOM   1753  CB  LYS A 115      10.611  15.399  28.221  1.00  0.00           C  
ATOM   1754  CG  LYS A 115      11.863  16.241  28.148  1.00  0.00           C  
ATOM   1755  CD  LYS A 115      13.104  15.374  28.161  1.00  0.00           C  
ATOM   1756  CE  LYS A 115      13.207  14.542  26.892  1.00  0.00           C  
ATOM   1757  NZ  LYS A 115      13.130  15.384  25.666  1.00  0.00           N  
ATOM   1758  H   LYS A 115      11.621  16.127  30.681  1.00  0.00           H  
ATOM   1759  HA  LYS A 115       9.245  14.709  29.700  1.00  0.00           H  
ATOM   1760  HB2 LYS A 115      10.717  14.579  27.528  1.00  0.00           H  
ATOM   1761  HB3 LYS A 115       9.778  16.010  27.906  1.00  0.00           H  
ATOM   1762  HG2 LYS A 115      11.847  16.815  27.232  1.00  0.00           H  
ATOM   1763  HG3 LYS A 115      11.889  16.909  28.992  1.00  0.00           H  
ATOM   1764  HD2 LYS A 115      13.964  16.010  28.237  1.00  0.00           H  
ATOM   1765  HD3 LYS A 115      13.063  14.715  29.013  1.00  0.00           H  
ATOM   1766  HE2 LYS A 115      14.146  14.014  26.896  1.00  0.00           H  
ATOM   1767  HE3 LYS A 115      12.396  13.828  26.878  1.00  0.00           H  
ATOM   1768  HZ1 LYS A 115      13.516  16.331  25.858  1.00  0.00           H  
ATOM   1769  HZ2 LYS A 115      12.139  15.480  25.360  1.00  0.00           H  
ATOM   1770  HZ3 LYS A 115      13.677  14.948  24.896  1.00  0.00           H  
ATOM   1771  N   GLU A 116      11.006  12.651  28.785  1.00  0.00           N  
ATOM   1772  CA  GLU A 116      11.571  11.314  28.884  1.00  0.00           C  
ATOM   1773  C   GLU A 116      13.092  11.340  28.928  1.00  0.00           C  
ATOM   1774  O   GLU A 116      13.724  12.303  28.493  1.00  0.00           O  
ATOM   1775  CB  GLU A 116      11.102  10.468  27.702  1.00  0.00           C  
ATOM   1776  CG  GLU A 116       9.621  10.617  27.392  1.00  0.00           C  
ATOM   1777  CD  GLU A 116       8.745  10.356  28.601  1.00  0.00           C  
ATOM   1778  OE1 GLU A 116       9.195   9.637  29.518  1.00  0.00           O  
ATOM   1779  OE2 GLU A 116       7.605  10.870  28.630  1.00  0.00           O  
ATOM   1780  H   GLU A 116      10.637  12.938  27.931  1.00  0.00           H  
ATOM   1781  HA  GLU A 116      11.205  10.867  29.796  1.00  0.00           H  
ATOM   1782  HB2 GLU A 116      11.663  10.754  26.824  1.00  0.00           H  
ATOM   1783  HB3 GLU A 116      11.298   9.433  27.920  1.00  0.00           H  
ATOM   1784  HG2 GLU A 116       9.439  11.623  27.044  1.00  0.00           H  
ATOM   1785  HG3 GLU A 116       9.357   9.916  26.616  1.00  0.00           H  
ATOM   1786  N   PHE A 117      13.670  10.262  29.450  1.00  0.00           N  
ATOM   1787  CA  PHE A 117      15.115  10.135  29.547  1.00  0.00           C  
ATOM   1788  C   PHE A 117      15.631   9.156  28.499  1.00  0.00           C  
ATOM   1789  O   PHE A 117      14.959   8.179  28.166  1.00  0.00           O  
ATOM   1790  CB  PHE A 117      15.531   9.665  30.948  1.00  0.00           C  
ATOM   1791  CG  PHE A 117      14.501   8.814  31.640  1.00  0.00           C  
ATOM   1792  CD1 PHE A 117      13.402   9.395  32.252  1.00  0.00           C  
ATOM   1793  CD2 PHE A 117      14.635   7.436  31.675  1.00  0.00           C  
ATOM   1794  CE1 PHE A 117      12.455   8.615  32.888  1.00  0.00           C  
ATOM   1795  CE2 PHE A 117      13.690   6.650  32.310  1.00  0.00           C  
ATOM   1796  CZ  PHE A 117      12.601   7.242  32.918  1.00  0.00           C  
ATOM   1797  H   PHE A 117      13.106   9.529  29.768  1.00  0.00           H  
ATOM   1798  HA  PHE A 117      15.552  11.105  29.359  1.00  0.00           H  
ATOM   1799  HB2 PHE A 117      16.434   9.085  30.865  1.00  0.00           H  
ATOM   1800  HB3 PHE A 117      15.720  10.529  31.566  1.00  0.00           H  
ATOM   1801  HD1 PHE A 117      13.288  10.469  32.230  1.00  0.00           H  
ATOM   1802  HD2 PHE A 117      15.487   6.973  31.201  1.00  0.00           H  
ATOM   1803  HE1 PHE A 117      11.603   9.079  33.362  1.00  0.00           H  
ATOM   1804  HE2 PHE A 117      13.805   5.578  32.332  1.00  0.00           H  
ATOM   1805  HZ  PHE A 117      11.861   6.630  33.414  1.00  0.00           H  
ATOM   1806  N   PRO A 118      16.832   9.405  27.961  1.00  0.00           N  
ATOM   1807  CA  PRO A 118      17.433   8.548  26.946  1.00  0.00           C  
ATOM   1808  C   PRO A 118      18.129   7.338  27.542  1.00  0.00           C  
ATOM   1809  O   PRO A 118      18.619   7.392  28.668  1.00  0.00           O  
ATOM   1810  CB  PRO A 118      18.445   9.474  26.282  1.00  0.00           C  
ATOM   1811  CG  PRO A 118      18.876  10.398  27.369  1.00  0.00           C  
ATOM   1812  CD  PRO A 118      17.699  10.550  28.299  1.00  0.00           C  
ATOM   1813  HA  PRO A 118      16.717   8.227  26.222  1.00  0.00           H  
ATOM   1814  HB2 PRO A 118      19.273   8.895  25.903  1.00  0.00           H  
ATOM   1815  HB3 PRO A 118      17.972  10.010  25.475  1.00  0.00           H  
ATOM   1816  HG2 PRO A 118      19.712   9.973  27.897  1.00  0.00           H  
ATOM   1817  HG3 PRO A 118      19.148  11.353  26.948  1.00  0.00           H  
ATOM   1818  HD2 PRO A 118      18.024  10.491  29.325  1.00  0.00           H  
ATOM   1819  HD3 PRO A 118      17.191  11.482  28.119  1.00  0.00           H  
ATOM   1820  N   SER A 119      18.196   6.252  26.769  1.00  0.00           N  
ATOM   1821  CA  SER A 119      18.876   5.042  27.219  1.00  0.00           C  
ATOM   1822  C   SER A 119      20.352   5.366  27.328  1.00  0.00           C  
ATOM   1823  O   SER A 119      21.170   4.936  26.515  1.00  0.00           O  
ATOM   1824  CB  SER A 119      18.646   3.889  26.238  1.00  0.00           C  
ATOM   1825  OG  SER A 119      17.693   2.971  26.741  1.00  0.00           O  
ATOM   1826  H   SER A 119      17.805   6.281  25.873  1.00  0.00           H  
ATOM   1827  HA  SER A 119      18.493   4.776  28.193  1.00  0.00           H  
ATOM   1828  HB2 SER A 119      18.286   4.285  25.300  1.00  0.00           H  
ATOM   1829  HB3 SER A 119      19.579   3.369  26.072  1.00  0.00           H  
ATOM   1830  HG  SER A 119      16.928   3.450  27.068  1.00  0.00           H  
ATOM   1831  N   ILE A 120      20.661   6.193  28.312  1.00  0.00           N  
ATOM   1832  CA  ILE A 120      22.002   6.678  28.529  1.00  0.00           C  
ATOM   1833  C   ILE A 120      22.244   6.921  30.015  1.00  0.00           C  
ATOM   1834  O   ILE A 120      23.279   6.546  30.564  1.00  0.00           O  
ATOM   1835  CB  ILE A 120      22.168   7.999  27.741  1.00  0.00           C  
ATOM   1836  CG1 ILE A 120      22.431   7.699  26.267  1.00  0.00           C  
ATOM   1837  CG2 ILE A 120      23.264   8.873  28.317  1.00  0.00           C  
ATOM   1838  CD1 ILE A 120      23.780   7.076  26.012  1.00  0.00           C  
ATOM   1839  H   ILE A 120      19.944   6.526  28.887  1.00  0.00           H  
ATOM   1840  HA  ILE A 120      22.705   5.953  28.153  1.00  0.00           H  
ATOM   1841  HB  ILE A 120      21.242   8.546  27.818  1.00  0.00           H  
ATOM   1842 HG12 ILE A 120      21.678   7.016  25.908  1.00  0.00           H  
ATOM   1843 HG13 ILE A 120      22.375   8.618  25.705  1.00  0.00           H  
ATOM   1844 HG21 ILE A 120      23.394   9.739  27.688  1.00  0.00           H  
ATOM   1845 HG22 ILE A 120      24.183   8.312  28.358  1.00  0.00           H  
ATOM   1846 HG23 ILE A 120      22.983   9.186  29.310  1.00  0.00           H  
ATOM   1847 HD11 ILE A 120      23.812   6.095  26.464  1.00  0.00           H  
ATOM   1848 HD12 ILE A 120      24.549   7.698  26.446  1.00  0.00           H  
ATOM   1849 HD13 ILE A 120      23.939   6.991  24.949  1.00  0.00           H  
ATOM   1850  N   LEU A 121      21.269   7.557  30.650  1.00  0.00           N  
ATOM   1851  CA  LEU A 121      21.343   7.870  32.069  1.00  0.00           C  
ATOM   1852  C   LEU A 121      20.153   7.277  32.821  1.00  0.00           C  
ATOM   1853  O   LEU A 121      19.688   7.844  33.810  1.00  0.00           O  
ATOM   1854  CB  LEU A 121      21.407   9.389  32.286  1.00  0.00           C  
ATOM   1855  CG  LEU A 121      20.411  10.240  31.479  1.00  0.00           C  
ATOM   1856  CD1 LEU A 121      20.893  10.434  30.049  1.00  0.00           C  
ATOM   1857  CD2 LEU A 121      19.017   9.625  31.496  1.00  0.00           C  
ATOM   1858  H   LEU A 121      20.477   7.826  30.143  1.00  0.00           H  
ATOM   1859  HA  LEU A 121      22.248   7.424  32.454  1.00  0.00           H  
ATOM   1860  HB2 LEU A 121      21.239   9.585  33.336  1.00  0.00           H  
ATOM   1861  HB3 LEU A 121      22.403   9.718  32.038  1.00  0.00           H  
ATOM   1862  HG  LEU A 121      20.344  11.218  31.933  1.00  0.00           H  
ATOM   1863 HD11 LEU A 121      21.810  11.007  30.052  1.00  0.00           H  
ATOM   1864 HD12 LEU A 121      20.141  10.968  29.487  1.00  0.00           H  
ATOM   1865 HD13 LEU A 121      21.069   9.478  29.587  1.00  0.00           H  
ATOM   1866 HD21 LEU A 121      18.780   9.298  32.497  1.00  0.00           H  
ATOM   1867 HD22 LEU A 121      18.984   8.781  30.824  1.00  0.00           H  
ATOM   1868 HD23 LEU A 121      18.295  10.364  31.182  1.00  0.00           H  
ATOM   1869  N   ARG A 122      19.662   6.135  32.337  1.00  0.00           N  
ATOM   1870  CA  ARG A 122      18.517   5.455  32.948  1.00  0.00           C  
ATOM   1871  C   ARG A 122      18.558   5.523  34.472  1.00  0.00           C  
ATOM   1872  O   ARG A 122      17.540   5.761  35.122  1.00  0.00           O  
ATOM   1873  CB  ARG A 122      18.467   3.993  32.496  1.00  0.00           C  
ATOM   1874  CG  ARG A 122      19.820   3.300  32.510  1.00  0.00           C  
ATOM   1875  CD  ARG A 122      19.755   1.942  31.831  1.00  0.00           C  
ATOM   1876  NE  ARG A 122      20.884   1.091  32.196  1.00  0.00           N  
ATOM   1877  CZ  ARG A 122      21.108  -0.110  31.670  1.00  0.00           C  
ATOM   1878  NH1 ARG A 122      20.285  -0.608  30.757  1.00  0.00           N  
ATOM   1879  NH2 ARG A 122      22.161  -0.820  32.058  1.00  0.00           N  
ATOM   1880  H   ARG A 122      20.078   5.740  31.543  1.00  0.00           H  
ATOM   1881  HA  ARG A 122      17.624   5.953  32.608  1.00  0.00           H  
ATOM   1882  HB2 ARG A 122      17.802   3.449  33.152  1.00  0.00           H  
ATOM   1883  HB3 ARG A 122      18.076   3.953  31.489  1.00  0.00           H  
ATOM   1884  HG2 ARG A 122      20.535   3.918  31.991  1.00  0.00           H  
ATOM   1885  HG3 ARG A 122      20.133   3.165  33.535  1.00  0.00           H  
ATOM   1886  HD2 ARG A 122      18.838   1.453  32.122  1.00  0.00           H  
ATOM   1887  HD3 ARG A 122      19.759   2.089  30.761  1.00  0.00           H  
ATOM   1888  HE  ARG A 122      21.509   1.432  32.871  1.00  0.00           H  
ATOM   1889 HH11 ARG A 122      19.489  -0.079  30.458  1.00  0.00           H  
ATOM   1890 HH12 ARG A 122      20.459  -1.511  30.364  1.00  0.00           H  
ATOM   1891 HH21 ARG A 122      22.786  -0.450  32.746  1.00  0.00           H  
ATOM   1892 HH22 ARG A 122      22.330  -1.721  31.663  1.00  0.00           H  
ATOM   1893  N   PHE A 123      19.743   5.320  35.036  1.00  0.00           N  
ATOM   1894  CA  PHE A 123      19.915   5.362  36.485  1.00  0.00           C  
ATOM   1895  C   PHE A 123      21.392   5.329  36.862  1.00  0.00           C  
ATOM   1896  O   PHE A 123      21.764   4.799  37.909  1.00  0.00           O  
ATOM   1897  CB  PHE A 123      19.182   4.192  37.142  1.00  0.00           C  
ATOM   1898  CG  PHE A 123      18.566   4.537  38.468  1.00  0.00           C  
ATOM   1899  CD1 PHE A 123      17.836   5.705  38.624  1.00  0.00           C  
ATOM   1900  CD2 PHE A 123      18.716   3.695  39.558  1.00  0.00           C  
ATOM   1901  CE1 PHE A 123      17.270   6.027  39.843  1.00  0.00           C  
ATOM   1902  CE2 PHE A 123      18.151   4.010  40.778  1.00  0.00           C  
ATOM   1903  CZ  PHE A 123      17.427   5.178  40.921  1.00  0.00           C  
ATOM   1904  H   PHE A 123      20.517   5.137  34.466  1.00  0.00           H  
ATOM   1905  HA  PHE A 123      19.488   6.288  36.841  1.00  0.00           H  
ATOM   1906  HB2 PHE A 123      18.392   3.857  36.486  1.00  0.00           H  
ATOM   1907  HB3 PHE A 123      19.880   3.382  37.300  1.00  0.00           H  
ATOM   1908  HD1 PHE A 123      17.714   6.370  37.781  1.00  0.00           H  
ATOM   1909  HD2 PHE A 123      19.282   2.781  39.448  1.00  0.00           H  
ATOM   1910  HE1 PHE A 123      16.705   6.941  39.951  1.00  0.00           H  
ATOM   1911  HE2 PHE A 123      18.274   3.346  41.621  1.00  0.00           H  
ATOM   1912  HZ  PHE A 123      16.983   5.427  41.875  1.00  0.00           H  
ATOM   1913  N   ILE A 124      22.230   5.893  36.001  1.00  0.00           N  
ATOM   1914  CA  ILE A 124      23.659   5.924  36.233  1.00  0.00           C  
ATOM   1915  C   ILE A 124      24.059   7.158  37.041  1.00  0.00           C  
ATOM   1916  O   ILE A 124      23.203   7.936  37.467  1.00  0.00           O  
ATOM   1917  CB  ILE A 124      24.418   5.906  34.892  1.00  0.00           C  
ATOM   1918  CG1 ILE A 124      24.294   7.256  34.177  1.00  0.00           C  
ATOM   1919  CG2 ILE A 124      23.894   4.781  34.009  1.00  0.00           C  
ATOM   1920  CD1 ILE A 124      24.896   7.266  32.785  1.00  0.00           C  
ATOM   1921  H   ILE A 124      21.881   6.294  35.181  1.00  0.00           H  
ATOM   1922  HA  ILE A 124      23.930   5.038  36.787  1.00  0.00           H  
ATOM   1923  HB  ILE A 124      25.451   5.712  35.100  1.00  0.00           H  
ATOM   1924 HG12 ILE A 124      23.251   7.514  34.089  1.00  0.00           H  
ATOM   1925 HG13 ILE A 124      24.797   8.012  34.760  1.00  0.00           H  
ATOM   1926 HG21 ILE A 124      24.707   4.369  33.431  1.00  0.00           H  
ATOM   1927 HG22 ILE A 124      23.139   5.171  33.342  1.00  0.00           H  
ATOM   1928 HG23 ILE A 124      23.463   4.008  34.628  1.00  0.00           H  
ATOM   1929 HD11 ILE A 124      24.685   6.327  32.294  1.00  0.00           H  
ATOM   1930 HD12 ILE A 124      25.965   7.402  32.857  1.00  0.00           H  
ATOM   1931 HD13 ILE A 124      24.469   8.075  32.214  1.00  0.00           H  
ATOM   1932  N   THR A 125      25.362   7.337  37.248  1.00  0.00           N  
ATOM   1933  CA  THR A 125      25.866   8.478  38.006  1.00  0.00           C  
ATOM   1934  C   THR A 125      25.407   9.792  37.375  1.00  0.00           C  
ATOM   1935  O   THR A 125      25.995  10.262  36.404  1.00  0.00           O  
ATOM   1936  CB  THR A 125      27.394   8.433  38.068  1.00  0.00           C  
ATOM   1937  OG1 THR A 125      27.831   7.289  38.781  1.00  0.00           O  
ATOM   1938  CG2 THR A 125      28.013   9.648  38.729  1.00  0.00           C  
ATOM   1939  H   THR A 125      25.996   6.686  36.885  1.00  0.00           H  
ATOM   1940  HA  THR A 125      25.470   8.415  39.008  1.00  0.00           H  
ATOM   1941  HB  THR A 125      27.783   8.373  37.061  1.00  0.00           H  
ATOM   1942  HG1 THR A 125      28.792   7.273  38.804  1.00  0.00           H  
ATOM   1943 HG21 THR A 125      28.568   9.341  39.601  1.00  0.00           H  
ATOM   1944 HG22 THR A 125      27.230  10.333  39.024  1.00  0.00           H  
ATOM   1945 HG23 THR A 125      28.676  10.138  38.032  1.00  0.00           H  
ATOM   1946  N   VAL A 126      24.350  10.377  37.932  1.00  0.00           N  
ATOM   1947  CA  VAL A 126      23.815  11.627  37.419  1.00  0.00           C  
ATOM   1948  C   VAL A 126      23.987  12.766  38.420  1.00  0.00           C  
ATOM   1949  O   VAL A 126      23.728  12.604  39.613  1.00  0.00           O  
ATOM   1950  CB  VAL A 126      22.322  11.486  37.062  1.00  0.00           C  
ATOM   1951  CG1 VAL A 126      21.484  11.258  38.313  1.00  0.00           C  
ATOM   1952  CG2 VAL A 126      21.834  12.707  36.296  1.00  0.00           C  
ATOM   1953  H   VAL A 126      23.921   9.954  38.700  1.00  0.00           H  
ATOM   1954  HA  VAL A 126      24.353  11.872  36.518  1.00  0.00           H  
ATOM   1955  HB  VAL A 126      22.210  10.621  36.425  1.00  0.00           H  
ATOM   1956 HG11 VAL A 126      20.695  10.552  38.095  1.00  0.00           H  
ATOM   1957 HG12 VAL A 126      21.051  12.194  38.630  1.00  0.00           H  
ATOM   1958 HG13 VAL A 126      22.111  10.866  39.101  1.00  0.00           H  
ATOM   1959 HG21 VAL A 126      21.263  12.387  35.438  1.00  0.00           H  
ATOM   1960 HG22 VAL A 126      22.682  13.287  35.966  1.00  0.00           H  
ATOM   1961 HG23 VAL A 126      21.212  13.312  36.939  1.00  0.00           H  
ATOM   1962  N   CYS A 127      24.423  13.921  37.922  1.00  0.00           N  
ATOM   1963  CA  CYS A 127      24.627  15.092  38.768  1.00  0.00           C  
ATOM   1964  C   CYS A 127      23.584  16.164  38.467  1.00  0.00           C  
ATOM   1965  O   CYS A 127      23.703  16.904  37.491  1.00  0.00           O  
ATOM   1966  CB  CYS A 127      26.031  15.657  38.562  1.00  0.00           C  
ATOM   1967  SG  CYS A 127      26.431  17.053  39.640  1.00  0.00           S  
ATOM   1968  H   CYS A 127      24.607  13.988  36.963  1.00  0.00           H  
ATOM   1969  HA  CYS A 127      24.520  14.781  39.797  1.00  0.00           H  
ATOM   1970  HB2 CYS A 127      26.756  14.880  38.753  1.00  0.00           H  
ATOM   1971  HB3 CYS A 127      26.131  15.993  37.540  1.00  0.00           H  
ATOM   1972  HG  CYS A 127      25.643  17.278  40.139  1.00  0.00           H  
ATOM   1973  N   ASP A 128      22.559  16.242  39.311  1.00  0.00           N  
ATOM   1974  CA  ASP A 128      21.495  17.226  39.134  1.00  0.00           C  
ATOM   1975  C   ASP A 128      21.400  18.152  40.341  1.00  0.00           C  
ATOM   1976  O   ASP A 128      21.614  17.730  41.478  1.00  0.00           O  
ATOM   1977  CB  ASP A 128      20.156  16.521  38.910  1.00  0.00           C  
ATOM   1978  CG  ASP A 128      19.185  17.366  38.108  1.00  0.00           C  
ATOM   1979  OD1 ASP A 128      19.635  18.332  37.456  1.00  0.00           O  
ATOM   1980  OD2 ASP A 128      17.976  17.059  38.129  1.00  0.00           O  
ATOM   1981  H   ASP A 128      22.517  15.626  40.071  1.00  0.00           H  
ATOM   1982  HA  ASP A 128      21.731  17.817  38.261  1.00  0.00           H  
ATOM   1983  HB2 ASP A 128      20.326  15.597  38.377  1.00  0.00           H  
ATOM   1984  HB3 ASP A 128      19.708  16.301  39.868  1.00  0.00           H  
ATOM   1985  N   TYR A 129      21.077  19.415  40.087  1.00  0.00           N  
ATOM   1986  CA  TYR A 129      20.953  20.399  41.155  1.00  0.00           C  
ATOM   1987  C   TYR A 129      19.696  20.152  41.978  1.00  0.00           C  
ATOM   1988  O   TYR A 129      18.663  20.786  41.761  1.00  0.00           O  
ATOM   1989  CB  TYR A 129      20.931  21.816  40.584  1.00  0.00           C  
ATOM   1990  CG  TYR A 129      22.219  22.211  39.897  1.00  0.00           C  
ATOM   1991  CD1 TYR A 129      23.450  21.925  40.475  1.00  0.00           C  
ATOM   1992  CD2 TYR A 129      22.205  22.864  38.672  1.00  0.00           C  
ATOM   1993  CE1 TYR A 129      24.631  22.281  39.851  1.00  0.00           C  
ATOM   1994  CE2 TYR A 129      23.382  23.223  38.041  1.00  0.00           C  
ATOM   1995  CZ  TYR A 129      24.590  22.930  38.634  1.00  0.00           C  
ATOM   1996  OH  TYR A 129      25.765  23.285  38.010  1.00  0.00           O  
ATOM   1997  H   TYR A 129      20.918  19.692  39.160  1.00  0.00           H  
ATOM   1998  HA  TYR A 129      21.815  20.296  41.799  1.00  0.00           H  
ATOM   1999  HB2 TYR A 129      20.132  21.894  39.862  1.00  0.00           H  
ATOM   2000  HB3 TYR A 129      20.752  22.517  41.385  1.00  0.00           H  
ATOM   2001  HD1 TYR A 129      23.477  21.417  41.425  1.00  0.00           H  
ATOM   2002  HD2 TYR A 129      21.257  23.094  38.209  1.00  0.00           H  
ATOM   2003  HE1 TYR A 129      25.578  22.051  40.316  1.00  0.00           H  
ATOM   2004  HE2 TYR A 129      23.350  23.731  37.088  1.00  0.00           H  
ATOM   2005  HH  TYR A 129      26.415  22.588  38.129  1.00  0.00           H  
ATOM   2006  N   THR A 130      19.798  19.237  42.933  1.00  0.00           N  
ATOM   2007  CA  THR A 130      18.676  18.914  43.804  1.00  0.00           C  
ATOM   2008  C   THR A 130      18.737  19.772  45.060  1.00  0.00           C  
ATOM   2009  O   THR A 130      17.713  20.165  45.617  1.00  0.00           O  
ATOM   2010  CB  THR A 130      18.695  17.431  44.176  1.00  0.00           C  
ATOM   2011  OG1 THR A 130      17.754  17.159  45.201  1.00  0.00           O  
ATOM   2012  CG2 THR A 130      20.048  16.953  44.657  1.00  0.00           C  
ATOM   2013  H   THR A 130      20.655  18.778  43.064  1.00  0.00           H  
ATOM   2014  HA  THR A 130      17.762  19.136  43.271  1.00  0.00           H  
ATOM   2015  HB  THR A 130      18.427  16.848  43.307  1.00  0.00           H  
ATOM   2016  HG1 THR A 130      17.348  16.303  45.043  1.00  0.00           H  
ATOM   2017 HG21 THR A 130      19.930  16.026  45.198  1.00  0.00           H  
ATOM   2018 HG22 THR A 130      20.482  17.698  45.306  1.00  0.00           H  
ATOM   2019 HG23 THR A 130      20.696  16.793  43.806  1.00  0.00           H  
ATOM   2020  N   ASN A 131      19.959  20.065  45.482  1.00  0.00           N  
ATOM   2021  CA  ASN A 131      20.199  20.888  46.655  1.00  0.00           C  
ATOM   2022  C   ASN A 131      21.591  21.510  46.575  1.00  0.00           C  
ATOM   2023  O   ASN A 131      22.391  21.383  47.501  1.00  0.00           O  
ATOM   2024  CB  ASN A 131      20.067  20.053  47.930  1.00  0.00           C  
ATOM   2025  CG  ASN A 131      18.647  20.040  48.467  1.00  0.00           C  
ATOM   2026  OD1 ASN A 131      17.786  19.324  47.959  1.00  0.00           O  
ATOM   2027  ND2 ASN A 131      18.399  20.835  49.501  1.00  0.00           N  
ATOM   2028  H   ASN A 131      20.728  19.724  44.980  1.00  0.00           H  
ATOM   2029  HA  ASN A 131      19.463  21.677  46.667  1.00  0.00           H  
ATOM   2030  HB2 ASN A 131      20.360  19.035  47.721  1.00  0.00           H  
ATOM   2031  HB3 ASN A 131      20.716  20.461  48.691  1.00  0.00           H  
ATOM   2032 HD21 ASN A 131      19.135  21.378  49.855  1.00  0.00           H  
ATOM   2033 HD22 ASN A 131      17.491  20.847  49.869  1.00  0.00           H  
ATOM   2034  N   PRO A 132      21.903  22.193  45.452  1.00  0.00           N  
ATOM   2035  CA  PRO A 132      23.205  22.830  45.251  1.00  0.00           C  
ATOM   2036  C   PRO A 132      23.681  23.562  46.492  1.00  0.00           C  
ATOM   2037  O   PRO A 132      24.878  23.648  46.758  1.00  0.00           O  
ATOM   2038  CB  PRO A 132      22.938  23.819  44.121  1.00  0.00           C  
ATOM   2039  CG  PRO A 132      21.854  23.186  43.324  1.00  0.00           C  
ATOM   2040  CD  PRO A 132      21.012  22.396  44.293  1.00  0.00           C  
ATOM   2041  HA  PRO A 132      23.951  22.114  44.944  1.00  0.00           H  
ATOM   2042  HB2 PRO A 132      22.626  24.766  44.535  1.00  0.00           H  
ATOM   2043  HB3 PRO A 132      23.833  23.951  43.535  1.00  0.00           H  
ATOM   2044  HG2 PRO A 132      21.257  23.950  42.848  1.00  0.00           H  
ATOM   2045  HG3 PRO A 132      22.284  22.530  42.581  1.00  0.00           H  
ATOM   2046  HD2 PRO A 132      20.135  22.959  44.577  1.00  0.00           H  
ATOM   2047  HD3 PRO A 132      20.728  21.451  43.856  1.00  0.00           H  
ATOM   2048  N   CYS A 133      22.724  24.079  47.250  1.00  0.00           N  
ATOM   2049  CA  CYS A 133      23.025  24.806  48.484  1.00  0.00           C  
ATOM   2050  C   CYS A 133      24.094  24.074  49.292  1.00  0.00           C  
ATOM   2051  O   CYS A 133      24.981  24.693  49.878  1.00  0.00           O  
ATOM   2052  CB  CYS A 133      21.754  24.973  49.323  1.00  0.00           C  
ATOM   2053  SG  CYS A 133      21.396  26.686  49.779  1.00  0.00           S  
ATOM   2054  H   CYS A 133      21.789  23.964  46.972  1.00  0.00           H  
ATOM   2055  HA  CYS A 133      23.399  25.779  48.212  1.00  0.00           H  
ATOM   2056  HB2 CYS A 133      20.911  24.600  48.763  1.00  0.00           H  
ATOM   2057  HB3 CYS A 133      21.854  24.403  50.236  1.00  0.00           H  
ATOM   2058  HG  CYS A 133      20.900  26.676  50.602  1.00  0.00           H  
ATOM   2059  N   THR A 134      24.004  22.748  49.299  1.00  0.00           N  
ATOM   2060  CA  THR A 134      24.963  21.916  50.014  1.00  0.00           C  
ATOM   2061  C   THR A 134      25.651  20.946  49.059  1.00  0.00           C  
ATOM   2062  O   THR A 134      26.817  20.595  49.244  1.00  0.00           O  
ATOM   2063  CB  THR A 134      24.269  21.142  51.137  1.00  0.00           C  
ATOM   2064  OG1 THR A 134      25.178  20.263  51.775  1.00  0.00           O  
ATOM   2065  CG2 THR A 134      23.093  20.319  50.659  1.00  0.00           C  
ATOM   2066  H   THR A 134      23.276  22.320  48.803  1.00  0.00           H  
ATOM   2067  HA  THR A 134      25.711  22.566  50.441  1.00  0.00           H  
ATOM   2068  HB  THR A 134      23.906  21.843  51.873  1.00  0.00           H  
ATOM   2069  HG1 THR A 134      25.424  19.559  51.169  1.00  0.00           H  
ATOM   2070 HG21 THR A 134      23.322  19.268  50.765  1.00  0.00           H  
ATOM   2071 HG22 THR A 134      22.897  20.542  49.621  1.00  0.00           H  
ATOM   2072 HG23 THR A 134      22.222  20.558  51.250  1.00  0.00           H  
ATOM   2073  N   LYS A 135      24.923  20.522  48.030  1.00  0.00           N  
ATOM   2074  CA  LYS A 135      25.459  19.601  47.036  1.00  0.00           C  
ATOM   2075  C   LYS A 135      26.423  20.316  46.087  1.00  0.00           C  
ATOM   2076  O   LYS A 135      27.036  19.685  45.227  1.00  0.00           O  
ATOM   2077  CB  LYS A 135      24.322  18.964  46.236  1.00  0.00           C  
ATOM   2078  CG  LYS A 135      23.223  18.376  47.103  1.00  0.00           C  
ATOM   2079  CD  LYS A 135      22.622  17.131  46.470  1.00  0.00           C  
ATOM   2080  CE  LYS A 135      23.409  15.884  46.835  1.00  0.00           C  
ATOM   2081  NZ  LYS A 135      23.245  15.526  48.271  1.00  0.00           N  
ATOM   2082  H   LYS A 135      24.002  20.842  47.934  1.00  0.00           H  
ATOM   2083  HA  LYS A 135      25.999  18.827  47.559  1.00  0.00           H  
ATOM   2084  HB2 LYS A 135      23.882  19.716  45.595  1.00  0.00           H  
ATOM   2085  HB3 LYS A 135      24.730  18.175  45.621  1.00  0.00           H  
ATOM   2086  HG2 LYS A 135      23.639  18.112  48.065  1.00  0.00           H  
ATOM   2087  HG3 LYS A 135      22.446  19.115  47.234  1.00  0.00           H  
ATOM   2088  HD2 LYS A 135      21.606  17.017  46.817  1.00  0.00           H  
ATOM   2089  HD3 LYS A 135      22.627  17.247  45.396  1.00  0.00           H  
ATOM   2090  HE2 LYS A 135      23.062  15.061  46.227  1.00  0.00           H  
ATOM   2091  HE3 LYS A 135      24.454  16.061  46.635  1.00  0.00           H  
ATOM   2092  HZ1 LYS A 135      23.621  16.283  48.876  1.00  0.00           H  
ATOM   2093  HZ2 LYS A 135      23.756  14.644  48.482  1.00  0.00           H  
ATOM   2094  HZ3 LYS A 135      22.238  15.389  48.494  1.00  0.00           H  
ATOM   2095  N   SER A 136      26.546  21.638  46.240  1.00  0.00           N  
ATOM   2096  CA  SER A 136      27.427  22.436  45.391  1.00  0.00           C  
ATOM   2097  C   SER A 136      28.788  21.762  45.200  1.00  0.00           C  
ATOM   2098  O   SER A 136      29.446  21.957  44.178  1.00  0.00           O  
ATOM   2099  CB  SER A 136      27.617  23.831  45.991  1.00  0.00           C  
ATOM   2100  OG  SER A 136      27.182  24.836  45.092  1.00  0.00           O  
ATOM   2101  H   SER A 136      26.026  22.088  46.941  1.00  0.00           H  
ATOM   2102  HA  SER A 136      26.954  22.535  44.426  1.00  0.00           H  
ATOM   2103  HB2 SER A 136      27.043  23.908  46.901  1.00  0.00           H  
ATOM   2104  HB3 SER A 136      28.663  23.989  46.208  1.00  0.00           H  
ATOM   2105  HG  SER A 136      27.876  25.019  44.455  1.00  0.00           H  
ATOM   2106  N   TRP A 137      29.200  20.969  46.185  1.00  0.00           N  
ATOM   2107  CA  TRP A 137      30.478  20.269  46.119  1.00  0.00           C  
ATOM   2108  C   TRP A 137      30.563  19.389  44.871  1.00  0.00           C  
ATOM   2109  O   TRP A 137      31.654  19.002  44.451  1.00  0.00           O  
ATOM   2110  CB  TRP A 137      30.682  19.415  47.371  1.00  0.00           C  
ATOM   2111  CG  TRP A 137      30.572  20.195  48.646  1.00  0.00           C  
ATOM   2112  CD1 TRP A 137      29.584  20.097  49.584  1.00  0.00           C  
ATOM   2113  CD2 TRP A 137      31.480  21.195  49.121  1.00  0.00           C  
ATOM   2114  NE1 TRP A 137      29.824  20.974  50.613  1.00  0.00           N  
ATOM   2115  CE2 TRP A 137      30.981  21.658  50.353  1.00  0.00           C  
ATOM   2116  CE3 TRP A 137      32.667  21.740  48.625  1.00  0.00           C  
ATOM   2117  CZ2 TRP A 137      31.630  22.643  51.096  1.00  0.00           C  
ATOM   2118  CZ3 TRP A 137      33.309  22.718  49.364  1.00  0.00           C  
ATOM   2119  CH2 TRP A 137      32.789  23.160  50.587  1.00  0.00           C  
ATOM   2120  H   TRP A 137      28.632  20.852  46.975  1.00  0.00           H  
ATOM   2121  HA  TRP A 137      31.259  21.012  46.072  1.00  0.00           H  
ATOM   2122  HB2 TRP A 137      29.939  18.634  47.392  1.00  0.00           H  
ATOM   2123  HB3 TRP A 137      31.666  18.968  47.337  1.00  0.00           H  
ATOM   2124  HD1 TRP A 137      28.743  19.424  49.513  1.00  0.00           H  
ATOM   2125  HE1 TRP A 137      29.258  21.089  51.406  1.00  0.00           H  
ATOM   2126  HE3 TRP A 137      33.083  21.414  47.684  1.00  0.00           H  
ATOM   2127  HZ2 TRP A 137      31.243  22.995  52.041  1.00  0.00           H  
ATOM   2128  HZ3 TRP A 137      34.228  23.152  48.996  1.00  0.00           H  
ATOM   2129  HH2 TRP A 137      33.325  23.926  51.128  1.00  0.00           H  
ATOM   2130  N   PHE A 138      29.408  19.071  44.286  1.00  0.00           N  
ATOM   2131  CA  PHE A 138      29.354  18.234  43.088  1.00  0.00           C  
ATOM   2132  C   PHE A 138      30.403  18.664  42.064  1.00  0.00           C  
ATOM   2133  O   PHE A 138      30.929  17.838  41.318  1.00  0.00           O  
ATOM   2134  CB  PHE A 138      27.959  18.298  42.461  1.00  0.00           C  
ATOM   2135  CG  PHE A 138      27.107  17.100  42.768  1.00  0.00           C  
ATOM   2136  CD1 PHE A 138      27.532  15.825  42.426  1.00  0.00           C  
ATOM   2137  CD2 PHE A 138      25.882  17.247  43.398  1.00  0.00           C  
ATOM   2138  CE1 PHE A 138      26.752  14.722  42.707  1.00  0.00           C  
ATOM   2139  CE2 PHE A 138      25.097  16.145  43.681  1.00  0.00           C  
ATOM   2140  CZ  PHE A 138      25.531  14.881  43.336  1.00  0.00           C  
ATOM   2141  H   PHE A 138      28.570  19.403  44.668  1.00  0.00           H  
ATOM   2142  HA  PHE A 138      29.556  17.216  43.386  1.00  0.00           H  
ATOM   2143  HB2 PHE A 138      27.445  19.173  42.831  1.00  0.00           H  
ATOM   2144  HB3 PHE A 138      28.056  18.371  41.388  1.00  0.00           H  
ATOM   2145  HD1 PHE A 138      28.487  15.700  41.938  1.00  0.00           H  
ATOM   2146  HD2 PHE A 138      25.540  18.235  43.668  1.00  0.00           H  
ATOM   2147  HE1 PHE A 138      27.095  13.733  42.435  1.00  0.00           H  
ATOM   2148  HE2 PHE A 138      24.143  16.273  44.171  1.00  0.00           H  
ATOM   2149  HZ  PHE A 138      24.919  14.019  43.555  1.00  0.00           H  
ATOM   2150  N   TRP A 139      30.708  19.957  42.038  1.00  0.00           N  
ATOM   2151  CA  TRP A 139      31.698  20.490  41.110  1.00  0.00           C  
ATOM   2152  C   TRP A 139      33.047  19.810  41.315  1.00  0.00           C  
ATOM   2153  O   TRP A 139      33.786  19.570  40.362  1.00  0.00           O  
ATOM   2154  CB  TRP A 139      31.844  22.002  41.293  1.00  0.00           C  
ATOM   2155  CG  TRP A 139      30.942  22.803  40.404  1.00  0.00           C  
ATOM   2156  CD1 TRP A 139      30.428  22.423  39.196  1.00  0.00           C  
ATOM   2157  CD2 TRP A 139      30.450  24.126  40.650  1.00  0.00           C  
ATOM   2158  NE1 TRP A 139      29.646  23.426  38.678  1.00  0.00           N  
ATOM   2159  CE2 TRP A 139      29.643  24.482  39.552  1.00  0.00           C  
ATOM   2160  CE3 TRP A 139      30.610  25.042  41.693  1.00  0.00           C  
ATOM   2161  CZ2 TRP A 139      29.002  25.716  39.469  1.00  0.00           C  
ATOM   2162  CZ3 TRP A 139      29.974  26.267  41.608  1.00  0.00           C  
ATOM   2163  CH2 TRP A 139      29.177  26.593  40.504  1.00  0.00           C  
ATOM   2164  H   TRP A 139      30.258  20.567  42.660  1.00  0.00           H  
ATOM   2165  HA  TRP A 139      31.357  20.288  40.107  1.00  0.00           H  
ATOM   2166  HB2 TRP A 139      31.610  22.257  42.317  1.00  0.00           H  
ATOM   2167  HB3 TRP A 139      32.863  22.288  41.079  1.00  0.00           H  
ATOM   2168  HD1 TRP A 139      30.617  21.469  38.727  1.00  0.00           H  
ATOM   2169  HE1 TRP A 139      29.169  23.392  37.824  1.00  0.00           H  
ATOM   2170  HE3 TRP A 139      31.221  24.807  42.553  1.00  0.00           H  
ATOM   2171  HZ2 TRP A 139      28.384  25.982  38.624  1.00  0.00           H  
ATOM   2172  HZ3 TRP A 139      30.088  26.987  42.404  1.00  0.00           H  
ATOM   2173  HH2 TRP A 139      28.700  27.562  40.480  1.00  0.00           H  
ATOM   2174  N   THR A 140      33.357  19.501  42.571  1.00  0.00           N  
ATOM   2175  CA  THR A 140      34.614  18.844  42.909  1.00  0.00           C  
ATOM   2176  C   THR A 140      34.549  17.355  42.587  1.00  0.00           C  
ATOM   2177  O   THR A 140      35.533  16.762  42.143  1.00  0.00           O  
ATOM   2178  CB  THR A 140      34.931  19.046  44.392  1.00  0.00           C  
ATOM   2179  OG1 THR A 140      35.035  20.425  44.698  1.00  0.00           O  
ATOM   2180  CG2 THR A 140      36.221  18.383  44.827  1.00  0.00           C  
ATOM   2181  H   THR A 140      32.724  19.717  43.286  1.00  0.00           H  
ATOM   2182  HA  THR A 140      35.397  19.295  42.316  1.00  0.00           H  
ATOM   2183  HB  THR A 140      34.129  18.627  44.981  1.00  0.00           H  
ATOM   2184  HG1 THR A 140      35.610  20.853  44.061  1.00  0.00           H  
ATOM   2185 HG21 THR A 140      36.286  17.398  44.388  1.00  0.00           H  
ATOM   2186 HG22 THR A 140      36.236  18.296  45.903  1.00  0.00           H  
ATOM   2187 HG23 THR A 140      37.061  18.979  44.501  1.00  0.00           H  
ATOM   2188  N   ARG A 141      33.382  16.756  42.810  1.00  0.00           N  
ATOM   2189  CA  ARG A 141      33.187  15.335  42.543  1.00  0.00           C  
ATOM   2190  C   ARG A 141      33.497  15.008  41.086  1.00  0.00           C  
ATOM   2191  O   ARG A 141      34.191  14.035  40.793  1.00  0.00           O  
ATOM   2192  CB  ARG A 141      31.750  14.926  42.875  1.00  0.00           C  
ATOM   2193  CG  ARG A 141      31.443  14.936  44.363  1.00  0.00           C  
ATOM   2194  CD  ARG A 141      29.973  14.657  44.629  1.00  0.00           C  
ATOM   2195  NE  ARG A 141      29.604  13.287  44.283  1.00  0.00           N  
ATOM   2196  CZ  ARG A 141      29.854  12.233  45.057  1.00  0.00           C  
ATOM   2197  NH1 ARG A 141      30.476  12.389  46.220  1.00  0.00           N  
ATOM   2198  NH2 ARG A 141      29.486  11.022  44.668  1.00  0.00           N  
ATOM   2199  H   ARG A 141      32.637  17.283  43.163  1.00  0.00           H  
ATOM   2200  HA  ARG A 141      33.864  14.782  43.175  1.00  0.00           H  
ATOM   2201  HB2 ARG A 141      31.072  15.608  42.384  1.00  0.00           H  
ATOM   2202  HB3 ARG A 141      31.577  13.929  42.501  1.00  0.00           H  
ATOM   2203  HG2 ARG A 141      32.036  14.176  44.850  1.00  0.00           H  
ATOM   2204  HG3 ARG A 141      31.695  15.906  44.766  1.00  0.00           H  
ATOM   2205  HD2 ARG A 141      29.774  14.820  45.678  1.00  0.00           H  
ATOM   2206  HD3 ARG A 141      29.378  15.341  44.041  1.00  0.00           H  
ATOM   2207  HE  ARG A 141      29.144  13.143  43.430  1.00  0.00           H  
ATOM   2208 HH11 ARG A 141      30.759  13.299  46.520  1.00  0.00           H  
ATOM   2209 HH12 ARG A 141      30.662  11.593  46.797  1.00  0.00           H  
ATOM   2210 HH21 ARG A 141      29.016  10.899  43.792  1.00  0.00           H  
ATOM   2211 HH22 ARG A 141      29.673  10.231  45.248  1.00  0.00           H  
ATOM   2212  N   LEU A 142      32.980  15.830  40.177  1.00  0.00           N  
ATOM   2213  CA  LEU A 142      33.205  15.629  38.751  1.00  0.00           C  
ATOM   2214  C   LEU A 142      34.616  16.054  38.361  1.00  0.00           C  
ATOM   2215  O   LEU A 142      35.230  15.466  37.470  1.00  0.00           O  
ATOM   2216  CB  LEU A 142      32.178  16.416  37.936  1.00  0.00           C  
ATOM   2217  CG  LEU A 142      31.822  15.804  36.578  1.00  0.00           C  
ATOM   2218  CD1 LEU A 142      31.223  14.418  36.758  1.00  0.00           C  
ATOM   2219  CD2 LEU A 142      30.861  16.710  35.823  1.00  0.00           C  
ATOM   2220  H   LEU A 142      32.438  16.590  40.473  1.00  0.00           H  
ATOM   2221  HA  LEU A 142      33.088  14.576  38.543  1.00  0.00           H  
ATOM   2222  HB2 LEU A 142      31.272  16.497  38.519  1.00  0.00           H  
ATOM   2223  HB3 LEU A 142      32.568  17.409  37.767  1.00  0.00           H  
ATOM   2224  HG  LEU A 142      32.723  15.705  35.989  1.00  0.00           H  
ATOM   2225 HD11 LEU A 142      30.460  14.257  36.012  1.00  0.00           H  
ATOM   2226 HD12 LEU A 142      30.789  14.340  37.743  1.00  0.00           H  
ATOM   2227 HD13 LEU A 142      31.998  13.675  36.646  1.00  0.00           H  
ATOM   2228 HD21 LEU A 142      29.887  16.671  36.289  1.00  0.00           H  
ATOM   2229 HD22 LEU A 142      30.783  16.378  34.798  1.00  0.00           H  
ATOM   2230 HD23 LEU A 142      31.230  17.726  35.845  1.00  0.00           H  
ATOM   2231  N   ALA A 143      35.125  17.079  39.037  1.00  0.00           N  
ATOM   2232  CA  ALA A 143      36.465  17.583  38.764  1.00  0.00           C  
ATOM   2233  C   ALA A 143      37.528  16.577  39.193  1.00  0.00           C  
ATOM   2234  O   ALA A 143      38.583  16.469  38.569  1.00  0.00           O  
ATOM   2235  CB  ALA A 143      36.679  18.916  39.467  1.00  0.00           C  
ATOM   2236  H   ALA A 143      34.587  17.504  39.737  1.00  0.00           H  
ATOM   2237  HA  ALA A 143      36.548  17.747  37.701  1.00  0.00           H  
ATOM   2238  HB1 ALA A 143      35.783  19.513  39.386  1.00  0.00           H  
ATOM   2239  HB2 ALA A 143      37.503  19.439  39.002  1.00  0.00           H  
ATOM   2240  HB3 ALA A 143      36.904  18.741  40.508  1.00  0.00           H  
ATOM   2241  N   LYS A 144      37.240  15.839  40.262  1.00  0.00           N  
ATOM   2242  CA  LYS A 144      38.169  14.837  40.773  1.00  0.00           C  
ATOM   2243  C   LYS A 144      37.984  13.504  40.051  1.00  0.00           C  
ATOM   2244  O   LYS A 144      38.908  12.695  39.977  1.00  0.00           O  
ATOM   2245  CB  LYS A 144      37.977  14.650  42.279  1.00  0.00           C  
ATOM   2246  CG  LYS A 144      36.637  14.034  42.652  1.00  0.00           C  
ATOM   2247  CD  LYS A 144      36.802  12.910  43.664  1.00  0.00           C  
ATOM   2248  CE  LYS A 144      37.599  11.753  43.085  1.00  0.00           C  
ATOM   2249  NZ  LYS A 144      37.488  10.527  43.924  1.00  0.00           N  
ATOM   2250  H   LYS A 144      36.380  15.969  40.715  1.00  0.00           H  
ATOM   2251  HA  LYS A 144      39.171  15.194  40.589  1.00  0.00           H  
ATOM   2252  HB2 LYS A 144      38.762  14.008  42.653  1.00  0.00           H  
ATOM   2253  HB3 LYS A 144      38.052  15.613  42.762  1.00  0.00           H  
ATOM   2254  HG2 LYS A 144      36.007  14.798  43.080  1.00  0.00           H  
ATOM   2255  HG3 LYS A 144      36.173  13.638  41.761  1.00  0.00           H  
ATOM   2256  HD2 LYS A 144      37.318  13.292  44.532  1.00  0.00           H  
ATOM   2257  HD3 LYS A 144      35.823  12.552  43.951  1.00  0.00           H  
ATOM   2258  HE2 LYS A 144      37.230  11.535  42.096  1.00  0.00           H  
ATOM   2259  HE3 LYS A 144      38.639  12.045  43.024  1.00  0.00           H  
ATOM   2260  HZ1 LYS A 144      38.341  10.415  44.509  1.00  0.00           H  
ATOM   2261  HZ2 LYS A 144      37.386   9.688  43.317  1.00  0.00           H  
ATOM   2262  HZ3 LYS A 144      36.660  10.593  44.547  1.00  0.00           H  
ATOM   2263  N   ALA A 145      36.785  13.285  39.521  1.00  0.00           N  
ATOM   2264  CA  ALA A 145      36.480  12.053  38.805  1.00  0.00           C  
ATOM   2265  C   ALA A 145      36.974  12.118  37.363  1.00  0.00           C  
ATOM   2266  O   ALA A 145      37.125  11.090  36.702  1.00  0.00           O  
ATOM   2267  CB  ALA A 145      34.985  11.780  38.841  1.00  0.00           C  
ATOM   2268  H   ALA A 145      36.090  13.967  39.610  1.00  0.00           H  
ATOM   2269  HA  ALA A 145      36.981  11.242  39.311  1.00  0.00           H  
ATOM   2270  HB1 ALA A 145      34.591  12.058  39.807  1.00  0.00           H  
ATOM   2271  HB2 ALA A 145      34.806  10.730  38.668  1.00  0.00           H  
ATOM   2272  HB3 ALA A 145      34.495  12.360  38.072  1.00  0.00           H  
ATOM   2273  N   LEU A 146      37.225  13.331  36.881  1.00  0.00           N  
ATOM   2274  CA  LEU A 146      37.701  13.530  35.519  1.00  0.00           C  
ATOM   2275  C   LEU A 146      39.224  13.465  35.465  1.00  0.00           C  
ATOM   2276  O   LEU A 146      39.805  13.093  34.444  1.00  0.00           O  
ATOM   2277  CB  LEU A 146      37.217  14.880  34.980  1.00  0.00           C  
ATOM   2278  CG  LEU A 146      35.975  14.817  34.090  1.00  0.00           C  
ATOM   2279  CD1 LEU A 146      34.856  14.054  34.782  1.00  0.00           C  
ATOM   2280  CD2 LEU A 146      35.516  16.222  33.723  1.00  0.00           C  
ATOM   2281  H   LEU A 146      37.087  14.112  37.456  1.00  0.00           H  
ATOM   2282  HA  LEU A 146      37.296  12.741  34.907  1.00  0.00           H  
ATOM   2283  HB2 LEU A 146      36.998  15.520  35.824  1.00  0.00           H  
ATOM   2284  HB3 LEU A 146      38.018  15.327  34.411  1.00  0.00           H  
ATOM   2285  HG  LEU A 146      36.221  14.295  33.176  1.00  0.00           H  
ATOM   2286 HD11 LEU A 146      34.413  14.677  35.544  1.00  0.00           H  
ATOM   2287 HD12 LEU A 146      35.255  13.159  35.234  1.00  0.00           H  
ATOM   2288 HD13 LEU A 146      34.101  13.785  34.056  1.00  0.00           H  
ATOM   2289 HD21 LEU A 146      34.660  16.160  33.068  1.00  0.00           H  
ATOM   2290 HD22 LEU A 146      36.319  16.741  33.217  1.00  0.00           H  
ATOM   2291 HD23 LEU A 146      35.248  16.760  34.619  1.00  0.00           H  
ATOM   2292  N   SER A 147      39.866  13.831  36.570  1.00  0.00           N  
ATOM   2293  CA  SER A 147      41.319  13.815  36.650  1.00  0.00           C  
ATOM   2294  C   SER A 147      41.791  13.120  37.925  1.00  0.00           C  
ATOM   2295  O   SER A 147      42.624  13.649  38.661  1.00  0.00           O  
ATOM   2296  CB  SER A 147      41.868  15.242  36.597  1.00  0.00           C  
ATOM   2297  OG  SER A 147      41.465  15.987  37.732  1.00  0.00           O  
ATOM   2298  H   SER A 147      39.351  14.116  37.350  1.00  0.00           H  
ATOM   2299  HA  SER A 147      41.688  13.265  35.801  1.00  0.00           H  
ATOM   2300  HB2 SER A 147      42.948  15.208  36.568  1.00  0.00           H  
ATOM   2301  HB3 SER A 147      41.500  15.733  35.708  1.00  0.00           H  
ATOM   2302  HG  SER A 147      41.271  16.891  37.469  1.00  0.00           H  
ATOM   2303  N   LEU A 148      41.256  11.929  38.179  1.00  0.00           N  
ATOM   2304  CA  LEU A 148      41.633  11.164  39.366  1.00  0.00           C  
ATOM   2305  C   LEU A 148      43.125  10.840  39.335  1.00  0.00           C  
ATOM   2306  O   LEU A 148      43.855  11.149  40.277  1.00  0.00           O  
ATOM   2307  CB  LEU A 148      40.828   9.859  39.483  1.00  0.00           C  
ATOM   2308  CG  LEU A 148      39.502   9.811  38.714  1.00  0.00           C  
ATOM   2309  CD1 LEU A 148      39.643   8.977  37.448  1.00  0.00           C  
ATOM   2310  CD2 LEU A 148      38.394   9.254  39.596  1.00  0.00           C  
ATOM   2311  H   LEU A 148      40.603  11.560  37.551  1.00  0.00           H  
ATOM   2312  HA  LEU A 148      41.430  11.778  40.230  1.00  0.00           H  
ATOM   2313  HB2 LEU A 148      41.449   9.047  39.134  1.00  0.00           H  
ATOM   2314  HB3 LEU A 148      40.614   9.695  40.528  1.00  0.00           H  
ATOM   2315  HG  LEU A 148      39.227  10.811  38.422  1.00  0.00           H  
ATOM   2316 HD11 LEU A 148      38.663   8.755  37.054  1.00  0.00           H  
ATOM   2317 HD12 LEU A 148      40.157   8.056  37.679  1.00  0.00           H  
ATOM   2318 HD13 LEU A 148      40.209   9.531  36.714  1.00  0.00           H  
ATOM   2319 HD21 LEU A 148      38.644   8.247  39.895  1.00  0.00           H  
ATOM   2320 HD22 LEU A 148      37.464   9.247  39.046  1.00  0.00           H  
ATOM   2321 HD23 LEU A 148      38.288   9.873  40.475  1.00  0.00           H  
ATOM   2322  N   PRO A 149      43.595  10.208  38.246  1.00  0.00           N  
ATOM   2323  CA  PRO A 149      45.005   9.842  38.095  1.00  0.00           C  
ATOM   2324  C   PRO A 149      45.885  11.042  37.767  1.00  0.00           C  
ATOM   2325  O   PRO A 149      45.396  11.963  37.079  1.00  0.00           O  
ATOM   2326  CB  PRO A 149      44.986   8.857  36.925  1.00  0.00           C  
ATOM   2327  CG  PRO A 149      43.810   9.269  36.107  1.00  0.00           C  
ATOM   2328  CD  PRO A 149      42.789   9.802  37.076  1.00  0.00           C  
ATOM   2329  OXT PRO A 149      47.056  11.053  38.202  1.00  0.00           O  
ATOM   2330  HA  PRO A 149      45.383   9.348  38.979  1.00  0.00           H  
ATOM   2331  HB2 PRO A 149      45.907   8.939  36.366  1.00  0.00           H  
ATOM   2332  HB3 PRO A 149      44.872   7.851  37.298  1.00  0.00           H  
ATOM   2333  HG2 PRO A 149      44.103  10.038  35.409  1.00  0.00           H  
ATOM   2334  HG3 PRO A 149      43.415   8.414  35.579  1.00  0.00           H  
ATOM   2335  HD2 PRO A 149      42.273  10.650  36.650  1.00  0.00           H  
ATOM   2336  HD3 PRO A 149      42.085   9.030  37.344  1.00  0.00           H  
TER    2337      PRO A 149                                                      
END
MOLECULE T0398_1_124_272_290.pdb
ATOM   4403  N   MET     1      43.764  18.893  40.120  1.00 55.49          
ATOM   4404  CA  MET     1      42.558  18.191  40.548  1.00 55.15          
ATOM   4405  C   MET     1      41.960  17.244  39.558  1.00 52.53          
ATOM   4406  O   MET     1      41.677  16.095  39.866  1.00 52.67          
ATOM   4407  CB  MET     1      41.504  19.213  40.832  1.00 56.64          
ATOM   4408  CG  MET     1      41.837  20.016  42.029  1.00 65.91          
ATOM   4409  SD  MET     1      40.890  19.252  43.539  0.75 86.37          
ATOM   4410  CE  MET     1      39.046  19.750  43.136  1.00 74.15          
ATOM   4411  N   LEU     2      41.740  17.775  38.376  1.00 50.01          
ATOM   4412  CA  LEU     2      41.058  17.044  37.302  1.00 47.50          
ATOM   4413  C   LEU     2      42.022  16.520  36.267  1.00 44.94          
ATOM   4414  O   LEU     2      41.659  16.226  35.143  1.00 43.98          
ATOM   4415  CB  LEU     2      40.001  17.943  36.654  1.00 47.84          
ATOM   4416  CG  LEU     2      38.907  18.467  37.592  1.00 44.34          
ATOM   4417  CD1 LEU     2      38.021  19.465  36.859  1.00 43.45          
ATOM   4418  CD2 LEU     2      38.091  17.333  38.174  1.00 42.64          
ATOM   4419  N   THR     3      43.266  16.406  36.685  1.00 43.85          
ATOM   4420  CA  THR     3      44.326  15.876  35.819  1.00 42.49          
ATOM   4421  C   THR     3      44.031  14.431  35.491  1.00 42.01          
ATOM   4422  O   THR     3      43.690  13.635  36.359  1.00 41.15          
ATOM   4423  CB  THR     3      45.730  15.948  36.483  1.00 42.25          
ATOM   4424  OG1 THR     3      46.051  17.313  36.795  1.00 42.87          
ATOM   4425  CG2 THR     3      46.803  15.367  35.556  1.00 41.76          
ATOM   4426  N   GLY     4      44.139  14.131  34.210  1.00 42.37          
ATOM   4427  CA  GLY     4      43.959  12.779  33.682  1.00 42.21          
ATOM   4428  C   GLY     4      42.517  12.443  33.398  1.00 42.02          
ATOM   4429  O   GLY     4      42.195  11.347  32.925  1.00 42.56          
ATOM   4430  N   LYS     5      41.645  13.388  33.717  1.00 41.56          
ATOM   4431  CA  LYS     5      40.213  13.210  33.469  1.00 41.24          
ATOM   4432  C   LYS     5      39.837  13.845  32.154  1.00 40.16          
ATOM   4433  O   LYS     5      40.386  14.858  31.769  1.00 40.02          
ATOM   4434  CB  LYS     5      39.371  13.690  34.648  1.00 41.99          
ATOM   4435  CG  LYS     5      39.582  12.745  35.825  1.00 45.76          
ATOM   4436  CD  LYS     5      38.475  12.772  36.875  1.00 47.66          
ATOM   4437  CE  LYS     5      38.531  11.474  37.702  1.00 48.49          
ATOM   4438  NZ  LYS     5      37.338  11.244  38.583  1.00 50.98          
ATOM   4439  N   HSD     6      38.965  13.166  31.428  1.00 39.11          
ATOM   4440  CA  HSD     6      38.509  13.635  30.130  1.00 38.59          
ATOM   4441  C   HSD     6      37.019  13.794  30.132  1.00 38.33          
ATOM   4442  O   HSD     6      36.283  12.836  30.346  1.00 39.52          
ATOM   4443  CB  HSD     6      38.966  12.683  29.026  1.00 39.64          
ATOM   4444  CG  HSD     6      38.361  12.965  27.682  1.00 38.98          
ATOM   4445  ND1 HSD     6      37.998  14.231  27.277  1.00 45.26          
ATOM   4446  CD2 HSD     6      38.136  12.155  26.621  1.00 40.01          
ATOM   4447  CE1 HSD     6      37.528  14.177  26.044  1.00 41.73          
ATOM   4448  NE2 HSD     6      37.605  12.930  25.621  1.00 38.56          
ATOM   4449  N   VAL     7      36.585  15.030  29.919  1.00 37.84          
ATOM   4450  CA  VAL     7      35.162  15.345  29.874  1.00 37.45          
ATOM   4451  C   VAL     7      34.748  15.959  28.534  1.00 37.14          
ATOM   4452  O   VAL     7      35.493  16.686  27.883  1.00 36.26          
ATOM   4453  CB  VAL     7      34.690  16.281  31.062  1.00 37.76          
ATOM   4454  CG1 VAL     7      35.401  15.919  32.367  1.00 34.41          
ATOM   4455  CG2 VAL     7      34.920  17.742  30.757  1.00 36.64          
ATOM   4456  N   VAL     8      33.544  15.594  28.120  1.00 36.76          
ATOM   4457  CA  VAL     8      32.949  16.169  26.932  1.00 35.56          
ATOM   4458  C   VAL     8      31.829  17.072  27.416  1.00 34.83          
ATOM   4459  O   VAL     8      30.981  16.683  28.221  1.00 32.25          
ATOM   4460  CB  VAL     8      32.446  15.122  25.905  1.00 36.93          
ATOM   4461  CG1 VAL     8      31.366  14.242  26.481  1.00 39.82          
ATOM   4462  CG2 VAL     8      31.929  15.820  24.643  1.00 34.85          
ATOM   4463  N   ILE     9      31.920  18.304  26.944  1.00 33.75          
ATOM   4464  CA  ILE     9      30.975  19.358  27.209  1.00 33.41          
ATOM   4465  C   ILE     9      30.252  19.608  25.912  1.00 33.48          
ATOM   4466  O   ILE     9      30.834  20.034  24.927  1.00 31.99          
ATOM   4467  CB  ILE     9      31.680  20.648  27.697  1.00 33.99          
ATOM   4468  CG1 ILE     9      32.451  20.394  29.002  1.00 34.60          
ATOM   4469  CG2 ILE     9      30.682  21.774  27.931  1.00 31.61          
ATOM   4470  CD  ILE     9      32.956  21.679  29.707  1.00 33.63          
ATOM   4471  N   ILE    10      28.956  19.348  25.949  1.00 34.64          
ATOM   4472  CA  ILE    10      28.094  19.403  24.771  1.00 34.75          
ATOM   4473  C   ILE    10      27.015  20.428  24.968  1.00 34.86          
ATOM   4474  O   ILE    10      26.146  20.281  25.822  1.00 34.68          
ATOM   4475  CB  ILE    10      27.449  18.032  24.520  1.00 34.11          
ATOM   4476  CG1 ILE    10      28.538  16.946  24.489  1.00 36.67          
ATOM   4477  CG2 ILE    10      26.676  18.014  23.191  1.00 36.69          
ATOM   4478  CD  ILE    10      28.004  15.544  24.255  1.00 26.82          
ATOM   4479  N   GLY    11      27.103  21.473  24.169  1.00 34.49          
ATOM   4480  CA  GLY    11      26.165  22.588  24.217  1.00 34.54          
ATOM   4481  C   GLY    11      26.043  23.347  25.519  1.00 33.46          
ATOM   4482  O   GLY    11      26.790  23.174  26.493  1.00 32.15          
ATOM   4483  N   GLY    12      25.044  24.205  25.486  1.00 33.78          
ATOM   4484  CA  GLY    12      24.650  25.018  26.630  1.00 33.29          
ATOM   4485  C   GLY    12      24.476  26.470  26.304  1.00 34.59          
ATOM   4486  O   GLY    12      24.203  26.868  25.168  1.00 33.16          
ATOM   4487  N   ASP    13      24.644  27.269  27.346  1.00 34.80          
ATOM   4488  CA  ASP    13      24.557  28.702  27.208  1.00 36.25          
ATOM   4489  C   ASP    13      25.726  29.384  27.877  1.00 35.47          
ATOM   4490  O   ASP    13      26.802  28.790  28.007  1.00 34.51          
ATOM   4491  CB  ASP    13      23.195  29.247  27.648  1.00 38.01          
ATOM   4492  CG  ASP    13      22.902  29.054  29.122  1.00 37.99          
ATOM   4493  OD1 ASP    13      23.831  29.004  29.937  1.00 40.27          
ATOM   4494  OD2 ASP    13      21.718  29.031  29.477  1.00 37.93          
ATOM   4495  N   ALA    14      25.524  30.625  28.274  1.00 36.36          
ATOM   4496  CA  ALA    14      26.653  31.410  28.822  1.00 36.45          
ATOM   4497  C   ALA    14      27.141  30.845  30.132  1.00 35.61          
ATOM   4498  O   ALA    14      28.306  30.996  30.485  1.00 37.24          
ATOM   4499  CB  ALA    14      26.331  32.922  28.929  1.00 37.20          
ATOM   4500  N   ARG    15      26.254  30.162  30.827  1.00 33.41          
ATOM   4501  CA  ARG    15      26.626  29.476  32.055  1.00 35.44          
ATOM   4502  C   ARG    15      27.787  28.546  31.826  1.00 34.37          
ATOM   4503  O   ARG    15      28.682  28.426  32.656  1.00 38.17          
ATOM   4504  CB  ARG    15      25.495  28.567  32.585  1.00 33.60          
ATOM   4505  CG  ARG    15      24.472  29.345  33.249  1.00 39.48          
ATOM   4506  CD  ARG    15      23.326  28.494  33.646  1.00 45.03          
ATOM   4507  NE  ARG    15      22.449  28.255  32.520  1.00 40.85          
ATOM   4508  CZ  ARG    15      21.164  27.967  32.658  1.00 42.27          
ATOM   4509  NH1 ARG    15      20.665  27.869  33.843  1.00 43.31          
ATOM   4510  NH2 ARG    15      20.393  27.754  31.622  1.00 44.80          
ATOM   4511  N   GLN    16      27.730  27.864  30.710  1.00 33.32          
ATOM   4512  CA  GLN    16      28.742  26.841  30.395  1.00 33.42          
ATOM   4513  C   GLN    16      30.149  27.408  30.279  1.00 32.86          
ATOM   4514  O   GLN    16      31.134  26.703  30.521  1.00 32.60          
ATOM   4515  CB  GLN    16      28.388  26.018  29.169  1.00 32.75          
ATOM   4516  CG  GLN    16      27.615  24.776  29.515  1.00 33.01          
ATOM   4517  CD  GLN    16      26.252  25.037  30.078  1.00 35.70          
ATOM   4518  OE1 GLN    16      25.559  25.982  29.679  1.00 34.65          
ATOM   4519  NE2 GLN    16      25.839  24.179  31.002  1.00 30.47          
ATOM   4520  N   LEU    17      30.217  28.693  29.954  1.00 33.52          
ATOM   4521  CA  LEU    17      31.503  29.368  29.789  1.00 34.88          
ATOM   4522  C   LEU    17      32.263  29.358  31.126  1.00 35.32          
ATOM   4523  O   LEU    17      33.490  29.270  31.146  1.00 35.18          
ATOM   4524  CB  LEU    17      31.353  30.815  29.275  1.00 34.62          
ATOM   4525  CG  LEU    17      30.758  30.997  27.872  1.00 37.77          
ATOM   4526  CD1 LEU    17      30.560  32.476  27.567  1.00 38.34          
ATOM   4527  CD2 LEU    17      31.623  30.343  26.830  1.00 37.30          
ATOM   4528  N   GLU    18      31.513  29.411  32.227  1.00 34.04          
ATOM   4529  CA  GLU    18      32.121  29.429  33.576  1.00 33.68          
ATOM   4530  C   GLU    18      32.633  28.042  33.918  1.00 33.63          
ATOM   4531  O   GLU    18      33.657  27.854  34.567  1.00 32.68          
ATOM   4532  CB  GLU    18      31.104  29.857  34.645  1.00 33.80          
ATOM   4533  CG  GLU    18      30.593  31.250  34.500  1.00 35.60          
ATOM   4534  CD  GLU    18      31.688  32.276  34.435  1.00 40.61          
ATOM   4535  OE1 GLU    18      32.721  32.137  35.148  1.00 36.68          
ATOM   4536  OE2 GLU    18      31.485  33.242  33.675  1.00 44.82          
ATOM   4537  N   ILE    19      31.886  27.069  33.450  1.00 34.38          
ATOM   4538  CA  ILE    19      32.221  25.656  33.670  1.00 36.53          
ATOM   4539  C   ILE    19      33.454  25.320  32.845  1.00 36.15          
ATOM   4540  O   ILE    19      34.400  24.728  33.346  1.00 37.57          
ATOM   4541  CB  ILE    19      31.044  24.695  33.289  1.00 35.97          
ATOM   4542  CG1 ILE    19      29.786  25.030  34.112  1.00 36.24          
ATOM   4543  CG2 ILE    19      31.454  23.216  33.511  1.00 33.94          
ATOM   4544  CD  ILE    19      28.543  24.257  33.695  1.00 34.52          
ATOM   4545  N   ILE    20      33.460  25.758  31.592  1.00 35.93          
ATOM   4546  CA  ILE    20      34.589  25.452  30.689  1.00 35.74          
ATOM   4547  C   ILE    20      35.883  26.026  31.282  1.00 34.79          
ATOM   4548  O   ILE    20      36.934  25.374  31.304  1.00 33.00          
ATOM   4549  CB  ILE    20      34.401  26.025  29.267  1.00 36.54          
ATOM   4550  CG1 ILE    20      33.227  25.354  28.548  1.00 37.53          
ATOM   4551  CG2 ILE    20      35.660  25.786  28.413  1.00 36.60          
ATOM   4552  CD  ILE    20      32.818  26.080  27.261  1.00 38.29          
ATOM   4553  N   ARG    21      35.759  27.229  31.811  1.00 33.64          
ATOM   4554  CA  ARG    21      36.918  27.949  32.350  1.00 35.13          
ATOM   4555  C   ARG    21      37.519  27.278  33.573  1.00 35.40          
ATOM   4556  O   ARG    21      38.728  27.094  33.668  1.00 33.92          
ATOM   4557  CB  ARG    21      36.564  29.404  32.697  1.00 34.56          
ATOM   4558  N   LYS    22      36.658  26.905  34.503  1.00 35.46          
ATOM   4559  CA  LYS    22      37.117  26.328  35.749  1.00 37.56          
ATOM   4560  C   LYS    22      37.740  24.971  35.516  1.00 37.12          
ATOM   4561  O   LYS    22      38.816  24.679  36.032  1.00 37.79          
ATOM   4562  CB  LYS    22      35.996  26.242  36.791  1.00 39.21          
ATOM   4563  CG  LYS    22      36.583  25.930  38.172  1.00 44.49          
ATOM   4564  CD  LYS    22      35.676  26.319  39.327  1.00 51.16          
ATOM   4565  CE  LYS    22      36.478  26.270  40.648  1.00 58.37          
ATOM   4566  NZ  LYS    22      35.667  26.448  41.903  1.00 59.05          
ATOM   4567  N   LEU    23      37.063  24.150  34.730  1.00 35.39          
ATOM   4568  CA  LEU    23      37.574  22.805  34.434  1.00 36.24          
ATOM   4569  C   LEU    23      38.952  22.893  33.781  1.00 36.26          
ATOM   4570  O   LEU    23      39.845  22.091  34.034  1.00 35.86          
ATOM   4571  CB  LEU    23      36.594  21.991  33.568  1.00 36.04          
ATOM   4572  CG  LEU    23      35.529  21.164  34.321  1.00 39.77          
ATOM   4573  CD1 LEU    23      35.034  21.824  35.612  1.00 36.00          
ATOM   4574  CD2 LEU    23      34.360  20.831  33.378  1.00 32.21          
ATOM   4575  N   SER    24      39.118  23.903  32.949  1.00 38.04          
ATOM   4576  CA  SER    24      40.398  24.133  32.258  1.00 38.92          
ATOM   4577  C   SER    24      41.516  24.368  33.269  1.00 39.62          
ATOM   4578  O   SER    24      42.599  23.756  33.216  1.00 38.97          
ATOM   4579  CB  SER    24      40.326  25.371  31.351  1.00 38.48          
ATOM   4580  OG  SER    24      41.504  25.469  30.565  1.00 40.80          
ATOM   4581  N   THR    25      41.224  25.254  34.207  1.00 38.91          
ATOM   4582  CA  THR    25      42.239  25.667  35.178  1.00 39.80          
ATOM   4583  C   THR    25      42.628  24.520  36.073  1.00 39.93          
ATOM   4584  O   THR    25      43.725  24.501  36.605  1.00 40.23          
ATOM   4585  CB  THR    25      41.803  26.853  36.058  1.00 39.64          
ATOM   4586  OG1 THR    25      40.652  26.470  36.802  1.00 44.04          
ATOM   4587  CG2 THR    25      41.476  28.102  35.214  1.00 37.98          
ATOM   4588  N   PHE    26      41.732  23.554  36.205  1.00 39.87          
ATOM   4589  CA  PHE    26      41.976  22.375  37.064  1.00 39.85          
ATOM   4590  C   PHE    26      42.606  21.230  36.299  1.00 38.56          
ATOM   4591  O   PHE    26      42.645  20.094  36.763  1.00 38.75          
ATOM   4592  CB  PHE    26      40.710  21.929  37.782  1.00 40.21          
ATOM   4593  CG  PHE    26      40.374  22.768  38.975  1.00 43.70          
ATOM   4594  CD1 PHE    26      40.144  24.119  38.851  1.00 51.13          
ATOM   4595  CD2 PHE    26      40.229  22.201  40.209  1.00 47.76          
ATOM   4596  CE1 PHE    26      39.815  24.886  39.953  1.00 50.53          
ATOM   4597  CE2 PHE    26      39.902  22.966  41.305  1.00 50.45          
ATOM   4598  CZ  PHE    26      39.694  24.304  41.172  1.00 49.02          
ATOM   4599  N   ASP    27      43.077  21.566  35.110  1.00 37.83          
ATOM   4600  CA  ASP    27      43.842  20.655  34.253  1.00 37.13          
ATOM   4601  C   ASP    27      43.073  19.467  33.680  1.00 37.50          
ATOM   4602  O   ASP    27      43.634  18.372  33.513  1.00 36.14          
ATOM   4603  CB  ASP    27      45.048  20.105  35.014  1.00 38.30          
ATOM   4604  CG  ASP    27      46.093  19.525  34.081  1.00 39.63          
ATOM   4605  OD1 ASP    27      46.268  20.105  32.980  1.00 40.77          
ATOM   4606  OD2 ASP    27      46.729  18.501  34.437  1.00 44.28          
ATOM   4607  N   ALA    28      41.789  19.672  33.403  1.00 37.30          
ATOM   4608  CA  ALA    28      40.967  18.624  32.775  1.00 37.56          
ATOM   4609  C   ALA    28      41.122  18.638  31.260  1.00 37.52          
ATOM   4610  O   ALA    28      41.397  19.675  30.644  1.00 37.59          
ATOM   4611  CB  ALA    28      39.489  18.782  33.148  1.00 37.86          
ATOM   4612  N   LYS    29      40.974  17.466  30.662  1.00 36.74          
ATOM   4613  CA  LYS    29      40.959  17.376  29.193  1.00 36.74          
ATOM   4614  C   LYS    29      39.511  17.569  28.780  1.00 36.02          
ATOM   4615  O   LYS    29      38.630  16.877  29.277  1.00 34.57          
ATOM   4616  CB  LYS    29      41.494  16.044  28.677  1.00 36.26          
ATOM   4617  CG  LYS    29      41.438  15.922  27.153  1.00 36.76          
ATOM   4618  CD  LYS    29      41.978  14.561  26.669  1.00 36.62          
ATOM   4619  CE  LYS    29      41.785  14.374  25.158  1.00 34.40          
ATOM   4620  NZ  LYS    29      42.192  13.035  24.703  1.00 38.71          
ATOM   4621  N   ILE    30      39.293  18.518  27.873  1.00 37.29          
ATOM   4622  CA  ILE    30      37.939  18.921  27.437  1.00 37.89          
ATOM   4623  C   ILE    30      37.660  18.937  25.942  1.00 37.95          
ATOM   4624  O   ILE    30      38.181  19.766  25.204  1.00 38.87          
ATOM   4625  CB  ILE    30      37.606  20.356  27.924  1.00 38.03          
ATOM   4626  CG1 ILE    30      37.816  20.487  29.438  1.00 38.81          
ATOM   4627  CG2 ILE    30      36.161  20.720  27.522  1.00 37.30          
ATOM   4628  CD  ILE    30      37.921  21.941  29.949  1.00 37.97          
ATOM   4629  N   SER    31      36.802  18.015  25.524  1.00 37.52          
ATOM   4630  CA  SER    31      36.301  17.969  24.146  1.00 35.75          
ATOM   4631  C   SER    31      35.053  18.819  24.131  1.00 34.97          
ATOM   4632  O   SER    31      34.109  18.568  24.885  1.00 35.65          
ATOM   4633  CB  SER    31      35.993  16.544  23.708  1.00 36.61          
ATOM   4634  OG  SER    31      37.178  15.789  23.587  1.00 32.57          
ATOM   4635  N   LEU    32      35.055  19.847  23.292  1.00 34.57          
ATOM   4636  CA  LEU    32      33.972  20.861  23.305  1.00 35.97          
ATOM   4637  C   LEU    32      33.111  20.894  22.049  1.00 36.19          
ATOM   4638  O   LEU    32      33.530  21.346  20.979  1.00 36.02          
ATOM   4639  CB  LEU    32      34.579  22.247  23.573  1.00 35.14          
ATOM   4640  CG  LEU    32      33.657  23.405  23.914  1.00 37.30          
ATOM   4641  CD1 LEU    32      32.910  23.128  25.239  1.00 32.62          
ATOM   4642  CD2 LEU    32      34.491  24.735  23.968  1.00 34.51          
ATOM   4643  N   VAL    33      31.873  20.446  22.221  1.00 35.98          
ATOM   4644  CA  VAL    33      30.924  20.342  21.102  1.00 36.03          
ATOM   4645  C   VAL    33      29.832  21.394  21.181  1.00 36.14          
ATOM   4646  O   VAL    33      29.202  21.594  22.230  1.00 36.67          
ATOM   4647  CB  VAL    33      30.281  18.920  21.041  1.00 35.25          
ATOM   4648  CG1 VAL    33      29.409  18.763  19.812  1.00 34.37          
ATOM   4649  CG2 VAL    33      31.336  17.848  21.083  1.00 33.86          
ATOM   4650  N   GLY    34      29.654  22.098  20.064  1.00 35.83          
ATOM   4651  CA  GLY    34      28.593  23.106  19.929  1.00 36.30          
ATOM   4652  C   GLY    34      29.016  24.533  20.182  1.00 36.74          
ATOM   4653  O   GLY    34      28.181  25.440  20.291  1.00 37.07          
ATOM   4654  N   PHE    35      30.320  24.748  20.218  1.00 36.68          
ATOM   4655  CA  PHE    35      30.861  26.085  20.507  1.00 37.57          
ATOM   4656  C   PHE    35      31.723  26.660  19.384  1.00 38.85          
ATOM   4657  O   PHE    35      32.679  27.387  19.615  1.00 38.02          
ATOM   4658  CB  PHE    35      31.661  26.029  21.809  1.00 38.22          
ATOM   4659  CG  PHE    35      30.823  25.741  23.032  1.00 39.24          
ATOM   4660  CD1 PHE    35      30.445  24.437  23.349  1.00 38.58          
ATOM   4661  CD2 PHE    35      30.443  26.763  23.872  1.00 34.14          
ATOM   4662  CE1 PHE    35      29.689  24.164  24.474  1.00 37.70          
ATOM   4663  CE2 PHE    35      29.679  26.491  25.011  1.00 38.54          
ATOM   4664  CZ  PHE    35      29.306  25.184  25.308  1.00 36.60          
ATOM   4665  N   ASP    36      31.363  26.340  18.154  1.00 41.48          
ATOM   4666  CA  ASP    36      32.144  26.809  17.011  1.00 43.59          
ATOM   4667  C   ASP    36      32.153  28.327  16.914  1.00 45.98          
ATOM   4668  O   ASP    36      33.122  28.915  16.426  1.00 45.82          
ATOM   4669  CB  ASP    36      31.707  26.151  15.701  1.00 44.75          
ATOM   4670  CG  ASP    36      30.232  26.142  15.531  1.00 44.46          
ATOM   4671  OD1 ASP    36      29.659  27.211  15.284  1.00 55.62          
ATOM   4672  OD2 ASP    36      29.645  25.056  15.651  1.00 45.16          
ATOM   4673  N   GLN    37      31.110  28.964  17.441  1.00 48.07          
ATOM   4674  CA  GLN    37      31.040  30.436  17.417  1.00 50.04          
ATOM   4675  C   GLN    37      31.861  31.072  18.527  1.00 52.43          
ATOM   4676  O   GLN    37      32.126  32.262  18.504  1.00 53.94          
ATOM   4677  CB  GLN    37      29.606  30.933  17.507  1.00 49.03          
ATOM   4678  CG  GLN    37      28.795  30.572  16.290  1.00 49.62          
ATOM   4679  CD  GLN    37      27.331  30.931  16.436  1.00 50.15          
ATOM   4680  OE1 GLN    37      26.525  30.603  15.577  1.00 50.91          
ATOM   4681  NE2 GLN    37      26.981  31.595  17.532  1.00 52.13          
ATOM   4682  N   LEU    38      32.253  30.261  19.493  1.00 54.37          
ATOM   4683  CA  LEU    38      33.058  30.734  20.626  1.00 56.35          
ATOM   4684  C   LEU    38      34.459  31.064  20.133  1.00 57.86          
ATOM   4685  O   LEU    38      35.272  30.207  19.832  1.00 57.73          
ATOM   4686  CB  LEU    38      33.103  29.705  21.760  1.00 56.41          
ATOM   4687  CG  LEU    38      33.820  30.150  23.027  1.00 53.73          
ATOM   4688  CD1 LEU    38      33.139  31.397  23.584  1.00 51.97          
ATOM   4689  CD2 LEU    38      33.846  29.022  24.058  1.00 50.20          
ATOM   4690  N   ASP    39      34.724  32.349  20.081  1.00 60.18          
ATOM   4691  CA  ASP    39      35.987  32.850  19.536  1.00 62.11          
ATOM   4692  C   ASP    39      37.144  32.429  20.442  1.00 61.85          
ATOM   4693  O   ASP    39      38.231  32.096  19.983  1.00 61.79          
ATOM   4694  CB  ASP    39      35.913  34.376  19.385  1.00 62.86          
ATOM   4695  CG  ASP    39      36.904  34.909  18.403  1.00 67.05          
ATOM   4696  OD1 ASP    39      37.746  34.126  17.906  1.00 73.73          
ATOM   4697  OD2 ASP    39      36.823  36.121  18.110  1.00 70.76          
ATOM   4698  N   ASP    40      36.849  32.365  21.730  1.00 62.05          
ATOM   4699  CA  ASP    40      37.857  32.045  22.750  1.00 61.83          
ATOM   4700  C   ASP    40      38.388  30.644  22.709  1.00 59.35          
ATOM   4701  O   ASP    40      37.735  29.702  22.264  1.00 59.01          
ATOM   4702  CB  ASP    40      37.329  32.285  24.167  1.00 63.09          
ATOM   4703  CG  ASP    40      37.024  33.734  24.433  1.00 68.60          
ATOM   4704  OD1 ASP    40      37.877  34.590  24.088  1.00 75.22          
ATOM   4705  OD2 ASP    40      35.934  34.003  24.988  1.00 73.01          
ATOM   4706  N   GLY    41      39.603  30.580  23.238  1.00 56.88          
ATOM   4707  CA  GLY    41      40.398  29.367  23.410  1.00 54.84          
ATOM   4708  C   GLY    41      40.685  29.144  24.888  1.00 53.07          
ATOM   4709  O   GLY    41      40.662  30.073  25.700  1.00 53.80          
ATOM   4710  N   PHE    42      40.903  27.889  25.242  1.00 49.93          
ATOM   4711  CA  PHE    42      41.209  27.522  26.630  1.00 47.33          
ATOM   4712  C   PHE    42      42.160  26.349  26.655  1.00 44.04          
ATOM   4713  O   PHE    42      42.057  25.440  25.842  1.00 41.07          
ATOM   4714  CB  PHE    42      39.950  27.098  27.402  1.00 47.17          
ATOM   4715  CG  PHE    42      38.834  28.081  27.336  1.00 49.36          
ATOM   4716  CD1 PHE    42      37.908  28.023  26.311  1.00 51.92          
ATOM   4717  CD2 PHE    42      38.698  29.063  28.302  1.00 49.27          
ATOM   4718  CE1 PHE    42      36.878  28.932  26.246  1.00 51.80          
ATOM   4719  CE2 PHE    42      37.682  29.974  28.236  1.00 50.17          
ATOM   4720  CZ  PHE    42      36.768  29.910  27.208  1.00 50.58          
ATOM   4721  N   ILE    43      43.060  26.380  27.628  1.00 42.52          
ATOM   4722  CA  ILE    43      44.008  25.291  27.842  1.00 41.22          
ATOM   4723  C   ILE    43      43.180  24.030  27.995  1.00 40.07          
ATOM   4724  O   ILE    43      42.135  24.029  28.661  1.00 39.34          
ATOM   4725  CB  ILE    43      44.862  25.468  29.143  1.00 41.99          
ATOM   4726  CG1 ILE    43      45.803  26.672  29.066  1.00 40.81          
ATOM   4727  CG2 ILE    43      45.714  24.235  29.400  1.00 36.97          
ATOM   4728  CD  ILE    43      46.794  26.498  28.044  1.00 44.15          
ATOM   4729  N   GLY    44      43.628  22.984  27.323  1.00 39.41          
ATOM   4730  CA  GLY    44      43.028  21.658  27.431  1.00 39.31          
ATOM   4731  C   GLY    44      41.781  21.428  26.623  1.00 38.87          
ATOM   4732  O   GLY    44      41.323  20.297  26.491  1.00 39.78          
ATOM   4733  N   VAL    45      41.257  22.506  26.063  1.00 38.89          
ATOM   4734  CA  VAL    45      40.014  22.465  25.263  1.00 38.57          
ATOM   4735  C   VAL    45      40.236  22.292  23.769  1.00 38.85          
ATOM   4736  O   VAL    45      40.993  23.032  23.154  1.00 38.02          
ATOM   4737  CB  VAL    45      39.169  23.756  25.452  1.00 39.07          
ATOM   4738  CG1 VAL    45      37.931  23.732  24.531  1.00 38.15          
ATOM   4739  CG2 VAL    45      38.763  23.922  26.895  1.00 37.64          
ATOM   4740  N   THR    46      39.542  21.299  23.215  1.00 38.76          
ATOM   4741  CA  THR    46      39.531  21.026  21.772  1.00 38.63          
ATOM   4742  C   THR    46      38.099  21.015  21.260  1.00 38.27          
ATOM   4743  O   THR    46      37.283  20.206  21.688  1.00 35.44          
ATOM   4744  CB  THR    46      40.162  19.670  21.415  1.00 38.23          
ATOM   4745  OG1 THR    46      41.466  19.571  21.999  1.00 36.98          
ATOM   4746  CG2 THR    46      40.271  19.506  19.887  1.00 38.28          
ATOM   4747  N   LYS    47      37.813  21.935  20.345  1.00 38.67          
ATOM   4748  CA  LYS    47      36.488  22.035  19.742  1.00 38.76          
ATOM   4749  C   LYS    47      36.314  21.007  18.660  1.00 38.83          
ATOM   4750  O   LYS    47      37.221  20.727  17.862  1.00 39.17          
ATOM   4751  CB  LYS    47      36.252  23.407  19.124  1.00 39.76          
ATOM   4752  CG  LYS    47      36.201  24.561  20.073  1.00 44.23          
ATOM   4753  CD  LYS    47      35.956  25.816  19.265  1.00 48.74          
ATOM   4754  CE  LYS    47      35.926  27.067  20.096  1.00 52.04          
ATOM   4755  NZ  LYS    47      35.803  28.208  19.155  1.00 54.57          
ATOM   4756  N   MET    48      35.126  20.437  18.622  1.00 38.10          
ATOM   4757  CA  MET    48      34.849  19.413  17.631  1.00 37.54          
ATOM   4758  C   MET    48      33.376  19.150  17.428  1.00 38.62          
ATOM   4759  O   MET    48      32.521  19.644  18.169  1.00 38.83          
ATOM   4760  CB  MET    48      35.533  18.103  18.047  1.00 37.25          
ATOM   4761  CG  MET    48      34.959  17.421  19.305  1.00 31.62          
ATOM   4762  SD  MET    48      36.163  15.988  19.891  0.75 33.44          
ATOM   4763  CE  MET    48      37.666  17.083  20.473  1.00 37.33          
ATOM   4764  N   ARG    49      33.125  18.360  16.392  1.00 39.08          
ATOM   4765  CA  ARG    49      31.779  17.897  16.039  1.00 40.01          
ATOM   4766  C   ARG    49      31.518  16.648  16.862  1.00 39.17          
ATOM   4767  O   ARG    49      32.442  15.908  17.209  1.00 37.42          
ATOM   4768  CB  ARG    49      31.634  17.567  14.535  1.00 41.16          
ATOM   4769  CG  ARG    49      31.832  18.747  13.587  1.00 43.79          
ATOM   4770  CD  ARG    49      31.556  18.364  12.133  1.00 46.37          
ATOM   4771  NE  ARG    49      32.252  17.139  11.743  1.00 50.72          
ATOM   4772  CZ  ARG    49      33.546  17.076  11.453  1.00 53.41          
ATOM   4773  NH1 ARG    49      34.305  18.162  11.522  1.00 56.06          
ATOM   4774  NH2 ARG    49      34.087  15.918  11.113  1.00 55.35          
ATOM   4775  N   ILE    50      30.244  16.409  17.137  1.00 39.23          
ATOM   4776  CA  ILE    50      29.837  15.300  18.008  1.00 39.08          
ATOM   4777  C   ILE    50      30.317  13.979  17.435  1.00 39.31          
ATOM   4778  O   ILE    50      30.633  13.041  18.166  1.00 38.63          
ATOM   4779  CB  ILE    50      28.296  15.295  18.296  1.00 39.35          
ATOM   4780  CG1 ILE    50      28.042  14.664  19.670  1.00 41.33          
ATOM   4781  CG2 ILE    50      27.527  14.641  17.160  1.00 37.80          
ATOM   4782  CD  ILE    50      26.601  14.757  20.168  1.00 42.96          
ATOM   4783  N   ASP    51      30.418  13.948  16.113  1.00 40.16          
ATOM   4784  CA  ASP    51      30.844  12.740  15.377  1.00 40.80          
ATOM   4785  C   ASP    51      32.355  12.534  15.446  1.00 40.74          
ATOM   4786  O   ASP    51      32.863  11.552  14.925  1.00 39.90          
ATOM   4787  CB  ASP    51      30.369  12.771  13.907  1.00 40.78          
ATOM   4788  CG  ASP    51      31.019  13.878  13.087  1.00 42.52          
ATOM   4789  OD1 ASP    51      30.385  14.943  12.940  1.00 50.66          
ATOM   4790  OD2 ASP    51      32.168  13.713  12.622  1.00 46.70          
ATOM   4791  N   GLU    52      33.062  13.461  16.087  1.00 40.15          
ATOM   4792  CA  GLU    52      34.541  13.365  16.189  1.00 40.68          
ATOM   4793  C   GLU    52      34.979  13.000  17.605  1.00 40.27          
ATOM   4794  O   GLU    52      36.163  12.839  17.882  1.00 40.31          
ATOM   4795  CB  GLU    52      35.212  14.697  15.815  1.00 41.47          
ATOM   4796  CG  GLU    52      34.839  15.272  14.453  1.00 42.63          
ATOM   4797  CD  GLU    52      35.625  16.550  14.119  1.00 44.35          
ATOM   4798  OE1 GLU    52      36.742  16.440  13.578  1.00 47.36          
ATOM   4799  OE2 GLU    52      35.113  17.666  14.341  1.00 40.06          
ATOM   4800  N   VAL    53      34.001  12.882  18.492  1.00 39.83          
ATOM   4801  CA  VAL    53      34.256  12.597  19.920  1.00 39.17          
ATOM   4802  C   VAL    53      34.836  11.199  20.095  1.00 38.69          
ATOM   4803  O   VAL    53      34.454  10.261  19.402  1.00 37.78          
ATOM   4804  CB  VAL    53      32.978  12.834  20.794  1.00 39.22          
ATOM   4805  CG1 VAL    53      33.219  12.501  22.263  1.00 39.33          
ATOM   4806  CG2 VAL    53      32.514  14.289  20.680  1.00 39.32          
ATOM   4807  N   ASP    54      35.810  11.107  20.989  1.00 39.00          
ATOM   4808  CA  ASP    54      36.518   9.848  21.312  1.00 39.24          
ATOM   4809  C   ASP    54      35.871   9.261  22.549  1.00 39.03          
ATOM   4810  O   ASP    54      36.428   9.299  23.656  1.00 39.24          
ATOM   4811  CB  ASP    54      38.005  10.136  21.557  1.00 39.46          
ATOM   4812  CG  ASP    54      38.792   8.904  21.973  1.00 43.49          
ATOM   4813  OD1 ASP    54      38.411   7.767  21.619  1.00 45.56          
ATOM   4814  OD2 ASP    54      39.816   9.083  22.661  1.00 50.71          
ATOM   4815  N   TRP    55      34.712   8.655  22.321  1.00 38.44          
ATOM   4816  CA  TRP    55      33.827   8.193  23.412  1.00 38.00          
ATOM   4817  C   TRP    55      34.435   7.242  24.418  1.00 38.37          
ATOM   4818  O   TRP    55      34.111   7.319  25.592  1.00 37.59          
ATOM   4819  CB  TRP    55      32.501   7.597  22.889  1.00 37.48          
ATOM   4820  CG  TRP    55      31.714   8.541  22.043  1.00 36.75          
ATOM   4821  CD1 TRP    55      31.604   8.529  20.675  1.00 38.32          
ATOM   4822  CD2 TRP    55      30.992   9.686  22.490  1.00 37.55          
ATOM   4823  NE1 TRP    55      30.830   9.583  20.252  1.00 36.79          
ATOM   4824  CE2 TRP    55      30.441  10.307  21.348  1.00 36.29          
ATOM   4825  CE3 TRP    55      30.741  10.241  23.750  1.00 35.76          
ATOM   4826  CZ2 TRP    55      29.656  11.448  21.431  1.00 36.23          
ATOM   4827  CZ3 TRP    55      29.959  11.374  23.827  1.00 36.92          
ATOM   4828  CH2 TRP    55      29.433  11.972  22.677  1.00 34.52          
ATOM   4829  N   ASN    56      35.307   6.351  23.966  1.00 40.38          
ATOM   4830  CA  ASN    56      35.869   5.325  24.877  1.00 41.17          
ATOM   4831  C   ASN    56      36.968   5.841  25.823  1.00 41.01          
ATOM   4832  O   ASN    56      37.585   5.063  26.549  1.00 41.14          
ATOM   4833  CB  ASN    56      36.234   3.996  24.159  1.00 42.28          
ATOM   4834  CG  ASN    56      37.248   4.157  23.068  1.00 45.88          
ATOM   4835  OD1 ASN    56      38.005   5.127  23.046  1.00 54.31          
ATOM   4836  ND2 ASN    56      37.281   3.194  22.142  1.00 48.30          
ATOM   4837  N   THR    57      37.159   7.161  25.857  1.00 40.01          
ATOM   4838  CA  THR    57      38.171   7.760  26.771  1.00 39.26          
ATOM   4839  C   THR    57      37.588   8.854  27.669  1.00 40.15          
ATOM   4840  O   THR    57      38.274   9.468  28.489  1.00 41.25          
ATOM   4841  CB  THR    57      39.391   8.316  26.001  1.00 38.80          
ATOM   4842  OG1 THR    57      38.977   9.346  25.094  1.00 38.45          
ATOM   4843  CG2 THR    57      40.080   7.201  25.222  1.00 35.68          
ATOM   4844  N   VAL    58      36.290   9.038  27.520  1.00 39.58          
ATOM   4845  CA  VAL    58      35.515  10.066  28.220  1.00 39.01          
ATOM   4846  C   VAL    58      35.028   9.638  29.593  1.00 39.66          
ATOM   4847  O   VAL    58      34.276   8.672  29.725  1.00 41.91          
ATOM   4848  CB  VAL    58      34.305  10.444  27.361  1.00 38.20          
ATOM   4849  CG1 VAL    58      33.370  11.325  28.117  1.00 36.17          
ATOM   4850  CG2 VAL    58      34.796  11.070  26.030  1.00 38.24          
ATOM   4851  N   ASP    59      35.455  10.364  30.614  1.00 38.81          
ATOM   4852  CA  ASP    59      35.076  10.032  31.996  1.00 38.63          
ATOM   4853  C   ASP    59      33.739  10.668  32.340  1.00 38.18          
ATOM   4854  O   ASP    59      33.080  10.301  33.324  1.00 38.12          
ATOM   4855  CB  ASP    59      36.107  10.526  33.024  1.00 39.38          
ATOM   4856  CG  ASP    59      37.526  10.023  32.752  1.00 38.78          
ATOM   4857  OD1 ASP    59      37.927   8.990  33.315  1.00 42.81          
ATOM   4858  OD2 ASP    59      38.253  10.679  31.991  1.00 38.75          
ATOM   4859  N   ALA    60      33.347  11.647  31.537  1.00 36.99          
ATOM   4860  CA  ALA    60      32.108  12.364  31.820  1.00 36.57          
ATOM   4861  C   ALA    60      31.572  13.222  30.699  1.00 36.84          
ATOM   4862  O   ALA    60      32.300  13.883  29.964  1.00 36.33          
ATOM   4863  CB  ALA    60      32.266  13.207  33.075  1.00 35.54          
ATOM   4864  N   ILE    61      30.248  13.199  30.629  1.00 36.82          
ATOM   4865  CA  ILE    61      29.495  13.959  29.653  1.00 36.24          
ATOM   4866  C   ILE    61      28.673  15.020  30.345  1.00 36.31          
ATOM   4867  O   ILE    61      27.839  14.718  31.175  1.00 37.66          
ATOM   4868  CB  ILE    61      28.584  13.035  28.844  1.00 36.77          
ATOM   4869  CG1 ILE    61      29.442  11.958  28.163  1.00 33.14          
ATOM   4870  CG2 ILE    61      27.731  13.848  27.851  1.00 36.10          
ATOM   4871  CD  ILE    61      28.671  11.049  27.234  1.00 34.86          
ATOM   4872  N   LEU    62      28.936  16.270  29.986  1.00 35.80          
ATOM   4873  CA  LEU    62      28.246  17.418  30.563  1.00 35.63          
ATOM   4874  C   LEU    62      27.300  18.022  29.570  1.00 35.63          
ATOM   4875  O   LEU    62      27.692  18.595  28.546  1.00 34.47          
ATOM   4876  CB  LEU    62      29.233  18.491  31.069  1.00 36.01          
ATOM   4877  CG  LEU    62      29.940  18.352  32.432  1.00 35.95          
ATOM   4878  CD1 LEU    62      30.427  16.952  32.729  1.00 31.50          
ATOM   4879  CD2 LEU    62      31.107  19.349  32.546  1.00 34.52          
ATOM   4880  N   LEU    63      26.030  17.875  29.911  1.00 35.56          
ATOM   4881  CA  LEU    63      24.955  18.428  29.116  1.00 35.76          
ATOM   4882  C   LEU    63      24.467  19.726  29.727  1.00 35.81          
ATOM   4883  O   LEU    63      24.721  20.009  30.905  1.00 35.24          
ATOM   4884  CB  LEU    63      23.793  17.440  29.024  1.00 36.73          
ATOM   4885  CG  LEU    63      24.080  16.063  28.438  1.00 36.27          
ATOM   4886  CD1 LEU    63      22.822  15.260  28.337  1.00 36.01          
ATOM   4887  CD2 LEU    63      24.734  16.230  27.064  1.00 35.47          
ATOM   4888  N   PRO    64      23.759  20.537  28.935  1.00 35.94          
ATOM   4889  CA  PRO    64      23.218  21.748  29.501  1.00 36.52          
ATOM   4890  C   PRO    64      22.240  21.452  30.613  1.00 37.61          
ATOM   4891  O   PRO    64      21.860  20.306  30.831  1.00 37.21          
ATOM   4892  CB  PRO    64      22.444  22.379  28.325  1.00 37.25          
ATOM   4893  CG  PRO    64      22.965  21.736  27.123  1.00 34.86          
ATOM   4894  CD  PRO    64      23.406  20.387  27.518  1.00 36.17          
ATOM   4895  N   ILE    65      21.808  22.502  31.296  1.00 37.84          
ATOM   4896  CA  ILE    65      20.840  22.332  32.378  1.00 37.53          
ATOM   4897  C   ILE    65      19.578  21.686  31.832  1.00 38.26          
ATOM   4898  O   ILE    65      18.956  20.856  32.481  1.00 38.75          
ATOM   4899  CB  ILE    65      20.536  23.670  33.090  1.00 38.40          
ATOM   4900  CG1 ILE    65      21.699  24.031  34.021  1.00 34.28          
ATOM   4901  CG2 ILE    65      19.262  23.603  33.867  1.00 35.40          
ATOM   4902  CD  ILE    65      22.001  23.005  35.095  1.00 34.09          
ATOM   4903  N   SER    66      19.240  22.040  30.601  1.00 38.51          
ATOM   4904  CA  SER    66      18.011  21.525  29.940  1.00 37.48          
ATOM   4905  C   SER    66      18.133  20.077  29.480  1.00 38.98          
ATOM   4906  O   SER    66      17.151  19.459  29.104  1.00 41.03          
ATOM   4907  CB  SER    66      17.670  22.389  28.726  1.00 37.57          
ATOM   4908  OG  SER    66      18.783  22.487  27.830  1.00 35.66          
ATOM   4909  N   GLY    67      19.337  19.528  29.535  1.00 38.05          
ATOM   4910  CA  GLY    67      19.580  18.160  29.058  1.00 38.83          
ATOM   4911  C   GLY    67      19.509  18.094  27.539  1.00 40.07          
ATOM   4912  O   GLY    67      20.231  18.807  26.835  1.00 39.32          
ATOM   4913  N   THR    68      18.671  17.177  27.048  1.00 41.47          
ATOM   4914  CA  THR    68      18.380  17.040  25.603  1.00 40.58          
ATOM   4915  C   THR    68      16.879  17.158  25.438  1.00 41.60          
ATOM   4916  O   THR    68      16.152  17.252  26.419  1.00 42.55          
ATOM   4917  CB  THR    68      18.770  15.659  24.994  1.00 40.70          
ATOM   4918  OG1 THR    68      17.934  14.640  25.540  1.00 39.29          
ATOM   4919  CG2 THR    68      20.210  15.301  25.248  1.00 38.45          
ATOM   4920  N   ASN    69      16.397  17.183  24.209  1.00 43.39          
ATOM   4921  CA  ASN    69      14.937  17.142  24.017  1.00 44.07          
ATOM   4922  C   ASN    69      14.585  15.691  23.823  1.00 44.81          
ATOM   4923  O   ASN    69      15.453  14.817  23.912  1.00 46.02          
ATOM   4924  CB  ASN    69      14.413  18.026  22.883  1.00 43.85          
ATOM   4925  CG  ASN    69      14.775  17.539  21.492  1.00 40.99          
ATOM   4926  OD1 ASN    69      15.437  16.521  21.289  1.00 42.32          
ATOM   4927  ND2 ASN    69      14.332  18.294  20.512  1.00 42.47          
ATOM   4928  N   GLU    70      13.331  15.427  23.496  1.00 46.24          
ATOM   4929  CA  GLU    70      12.860  14.030  23.385  1.00 45.74          
ATOM   4930  C   GLU    70      13.473  13.288  22.227  1.00 44.76          
ATOM   4931  O   GLU    70      13.321  12.074  22.116  1.00 46.18          
ATOM   4932  CB  GLU    70      11.339  13.957  23.317  1.00 46.44          
ATOM   4933  CG  GLU    70      10.655  14.435  24.606  1.00 49.19          
ATOM   4934  CD  GLU    70      11.021  13.581  25.828  1.00 52.88          
ATOM   4935  OE1 GLU    70      11.644  12.508  25.647  1.00 55.18          
ATOM   4936  OE2 GLU    70      10.683  13.976  26.971  1.00 50.41          
ATOM   4937  N   ALA    71      14.188  14.018  21.380  1.00 43.81          
ATOM   4938  CA  ALA    71      14.827  13.425  20.192  1.00 43.42          
ATOM   4939  C   ALA    71      16.330  13.328  20.383  1.00 42.93          
ATOM   4940  O   ALA    71      17.061  12.908  19.507  1.00 43.05          
ATOM   4941  CB  ALA    71      14.495  14.239  18.958  1.00 43.67          
ATOM   4942  N   GLY    72      16.765  13.739  21.559  1.00 43.06          
ATOM   4943  CA  GLY    72      18.169  13.662  21.950  1.00 41.94          
ATOM   4944  C   GLY    72      18.963  14.848  21.504  1.00 41.63          
ATOM   4945  O   GLY    72      20.189  14.840  21.580  1.00 41.99          
ATOM   4946  N   LYS    73      18.247  15.871  21.051  1.00 41.34          
ATOM   4947  CA  LYS    73      18.867  17.110  20.553  1.00 41.14          
ATOM   4948  C   LYS    73      19.323  18.026  21.694  1.00 40.31          
ATOM   4949  O   LYS    73      18.579  18.276  22.637  1.00 39.33          
ATOM   4950  CB  LYS    73      17.948  17.814  19.544  1.00 41.82          
ATOM   4951  CG  LYS    73      18.664  18.898  18.732  1.00 45.99          
ATOM   4952  CD  LYS    73      18.310  20.309  19.161  1.00 52.14          
ATOM   4953  CE  LYS    73      17.402  20.965  18.114  1.00 54.42          
ATOM   4954  NZ  LYS    73      18.130  21.146  16.824  1.00 54.99          
ATOM   4955  N   VAL    74      20.570  18.497  21.588  1.00 39.38          
ATOM   4956  CA  VAL    74      21.203  19.346  22.622  1.00 39.21          
ATOM   4957  C   VAL    74      21.259  20.795  22.183  1.00 39.61          
ATOM   4958  O   VAL    74      21.809  21.123  21.147  1.00 40.88          
ATOM   4959  CB  VAL    74      22.652  18.856  22.954  1.00 38.45          
ATOM   4960  CG1 VAL    74      23.245  19.629  24.143  1.00 34.24          
ATOM   4961  CG2 VAL    74      22.678  17.338  23.205  1.00 36.26          
ATOM   4962  N   ASP    75      20.680  21.667  22.980  1.00 40.25          
ATOM   4963  CA  ASP    75      20.694  23.104  22.658  1.00 41.88          
ATOM   4964  C   ASP    75      22.037  23.741  22.917  1.00 41.06          
ATOM   4965  O   ASP    75      22.779  23.368  23.833  1.00 42.07          
ATOM   4966  CB  ASP    75      19.603  23.886  23.407  1.00 42.49          
ATOM   4967  CG  ASP    75      18.197  23.586  22.872  1.00 50.00          
ATOM   4968  OD1 ASP    75      18.070  23.030  21.744  1.00 54.48          
ATOM   4969  OD2 ASP    75      17.215  23.916  23.584  1.00 60.70          
ATOM   4970  N   THR    76      22.310  24.705  22.057  1.00 39.96          
ATOM   4971  CA  THR    76      23.498  25.551  22.124  1.00 39.45          
ATOM   4972  C   THR    76      23.273  26.890  21.447  1.00 39.93          
ATOM   4973  O   THR    76      22.736  26.957  20.336  1.00 40.35          
ATOM   4974  CB  THR    76      24.723  24.909  21.454  1.00 40.41          
ATOM   4975  OG1 THR    76      25.807  25.832  21.522  1.00 34.09          
ATOM   4976  CG2 THR    76      24.441  24.568  19.989  1.00 35.23          
ATOM   4977  N   ILE    77      23.705  27.941  22.131  1.00 38.83          
ATOM   4978  CA  ILE    77      23.596  29.294  21.607  1.00 38.97          
ATOM   4979  C   ILE    77      24.911  29.682  20.907  1.00 38.50          
ATOM   4980  O   ILE    77      25.054  30.812  20.479  1.00 38.29          
ATOM   4981  CB  ILE    77      23.285  30.376  22.708  1.00 38.73          
ATOM   4982  CG1 ILE    77      24.481  30.595  23.651  1.00 39.21          
ATOM   4983  CG2 ILE    77      21.978  30.058  23.480  1.00 40.31          
ATOM   4984  CD  ILE    77      24.267  31.716  24.693  1.00 34.24          
ATOM   4985  N   PHE    78      25.865  28.754  20.847  1.00 37.56          
ATOM   4986  CA  PHE    78      27.204  29.037  20.261  1.00 38.37          
ATOM   4987  C   PHE    78      27.439  28.298  18.953  1.00 38.98          
ATOM   4988  O   PHE    78      28.566  28.073  18.532  1.00 38.82          
ATOM   4989  CB  PHE    78      28.333  28.672  21.232  1.00 39.10          
ATOM   4990  CG  PHE    78      28.295  29.424  22.526  1.00 39.13          
ATOM   4991  CD1 PHE    78      28.793  30.698  22.606  1.00 41.57          
ATOM   4992  CD2 PHE    78      27.762  28.849  23.662  1.00 41.83          
ATOM   4993  CE1 PHE    78      28.745  31.406  23.793  1.00 42.46          
ATOM   4994  CE2 PHE    78      27.735  29.544  24.847  1.00 40.21          
ATOM   4995  CZ  PHE    78      28.212  30.821  24.911  1.00 40.67          
ATOM   4996  N   SER    79      26.335  27.904  18.346  1.00 40.86          
ATOM   4997  CA  SER    79      26.332  27.181  17.061  1.00 41.96          
ATOM   4998  C   SER    79      24.931  27.027  16.510  1.00 42.49          
ATOM   4999  O   SER    79      23.944  26.935  17.248  1.00 40.87          
ATOM   5000  CB  SER    79      26.936  25.786  17.219  1.00 42.40          
ATOM   5001  OG  SER    79      26.836  25.044  16.001  1.00 42.26          
ATOM   5002  N   ASN    80      24.879  27.009  15.191  1.00 43.99          
ATOM   5003  CA  ASN    80      23.632  26.855  14.453  1.00 45.08          
ATOM   5004  C   ASN    80      23.486  25.403  14.051  1.00 46.10          
ATOM   5005  O   ASN    80      22.493  25.007  13.440  1.00 47.60          
ATOM   5006  CB  ASN    80      23.624  27.743  13.213  1.00 45.65          
ATOM   5007  CG  ASN    80      23.414  29.207  13.546  1.00 47.58          
ATOM   5008  OD1 ASN    80      22.568  29.551  14.369  1.00 44.02          
ATOM   5009  ND2 ASN    80      24.166  30.080  12.883  1.00 46.89          
ATOM   5010  N   GLU    81      24.497  24.620  14.413  1.00 45.74          
ATOM   5011  CA  GLU    81      24.544  23.184  14.090  1.00 45.83          
ATOM   5012  C   GLU    81      23.724  22.343  15.055  1.00 46.21          
ATOM   5013  O   GLU    81      23.673  22.589  16.262  1.00 46.28          
ATOM   5014  CB  GLU    81      25.988  22.660  14.036  1.00 45.19          
ATOM   5015  N   SER    82      23.089  21.341  14.462  1.00 46.49          
ATOM   5016  CA  SER    82      22.249  20.362  15.163  1.00 46.76          
ATOM   5017  C   SER    82      23.133  19.348  15.839  1.00 45.75          
ATOM   5018  O   SER    82      24.064  18.829  15.233  1.00 45.66          
ATOM   5019  CB  SER    82      21.331  19.618  14.179  1.00 47.51          
ATOM   5020  OG  SER    82      20.576  20.529  13.398  1.00 50.98          
ATOM   5021  N   ILE    83      22.818  19.067  17.098  1.00 44.47          
ATOM   5022  CA  ILE    83      23.592  18.115  17.911  1.00 43.16          
ATOM   5023  C   ILE    83      22.678  17.102  18.581  1.00 41.75          
ATOM   5024  O   ILE    83      21.863  17.439  19.418  1.00 41.38          
ATOM   5025  CB  ILE    83      24.432  18.880  18.968  1.00 42.86          
ATOM   5026  CG1 ILE    83      25.361  19.871  18.277  1.00 44.81          
ATOM   5027  CG2 ILE    83      25.259  17.941  19.824  1.00 40.37          
ATOM   5028  CD  ILE    83      26.002  20.839  19.232  1.00 48.86          
ATOM   5029  N   VAL    84      22.796  15.853  18.164  1.00 42.05          
ATOM   5030  CA  VAL    84      21.975  14.790  18.737  1.00 41.14          
ATOM   5031  C   VAL    84      22.832  13.773  19.445  1.00 40.58          
ATOM   5032  O   VAL    84      23.779  13.227  18.883  1.00 41.31          
ATOM   5033  CB  VAL    84      21.072  14.082  17.688  1.00 40.99          
ATOM   5034  CG1 VAL    84      20.271  12.986  18.358  1.00 38.23          
ATOM   5035  CG2 VAL    84      20.130  15.078  17.022  1.00 38.63          
ATOM   5036  N   LEU    85      22.488  13.555  20.706  1.00 40.12          
ATOM   5037  CA  LEU    85      23.178  12.592  21.554  1.00 40.47          
ATOM   5038  C   LEU    85      22.447  11.264  21.490  1.00 41.23          
ATOM   5039  O   LEU    85      21.321  11.136  21.953  1.00 41.32          
ATOM   5040  CB  LEU    85      23.246  13.085  23.002  1.00 40.40          
ATOM   5041  CG  LEU    85      24.065  12.201  23.945  1.00 39.40          
ATOM   5042  CD1 LEU    85      25.511  12.072  23.476  1.00 43.01          
ATOM   5043  CD2 LEU    85      24.022  12.747  25.338  1.00 42.01          
ATOM   5044  N   THR    86      23.111  10.277  20.915  1.00 41.91          
ATOM   5045  CA  THR    86      22.517   8.958  20.739  1.00 42.73          
ATOM   5046  C   THR    86      22.946   7.944  21.782  1.00 44.31          
ATOM   5047  O   THR    86      23.813   8.187  22.615  1.00 45.40          
ATOM   5048  CB  THR    86      22.892   8.361  19.383  1.00 42.28          
ATOM   5049  OG1 THR    86      24.309   8.257  19.301  1.00 42.73          
ATOM   5050  CG2 THR    86      22.391   9.216  18.244  1.00 41.62          
ATOM   5051  N   GLU    87      22.321   6.778  21.679  1.00 44.52          
ATOM   5052  CA  GLU    87      22.574   5.659  22.594  1.00 44.08          
ATOM   5053  C   GLU    87      23.876   5.027  22.203  1.00 43.25          
ATOM   5054  O   GLU    87      24.630   4.511  23.035  1.00 43.58          
ATOM   5055  CB  GLU    87      21.459   4.613  22.499  1.00 44.78          
ATOM   5056  CG  GLU    87      20.105   5.142  22.935  1.00 48.14          
ATOM   5057  CD  GLU    87      18.996   4.101  22.846  1.00 53.51          
ATOM   5058  OE1 GLU    87      19.280   2.924  22.503  1.00 48.36          
ATOM   5059  OE2 GLU    87      17.833   4.482  23.134  1.00 56.97          
ATOM   5060  N   GLU    88      24.127   5.108  20.906  1.00 41.89          
ATOM   5061  CA  GLU    88      25.299   4.501  20.306  1.00 40.97          
ATOM   5062  C   GLU    88      26.529   5.178  20.843  1.00 40.21          
ATOM   5063  O   GLU    88      27.522   4.541  21.138  1.00 40.74          
ATOM   5064  CB  GLU    88      25.263   4.589  18.770  1.00 40.79          
ATOM   5065  N   MET    89      26.438   6.484  20.998  1.00 39.94          
ATOM   5066  CA  MET    89      27.567   7.274  21.489  1.00 39.00          
ATOM   5067  C   MET    89      27.854   6.932  22.937  1.00 38.65          
ATOM   5068  O   MET    89      28.983   6.714  23.332  1.00 39.71          
ATOM   5069  CB  MET    89      27.258   8.772  21.380  1.00 39.19          
ATOM   5070  CG  MET    89      27.209   9.255  19.946  1.00 39.43          
ATOM   5071  SD  MET    89      26.478  11.058  19.702  0.75 40.29          
ATOM   5072  CE  MET    89      26.419  10.929  17.734  1.00 32.88          
ATOM   5073  N   ILE    90      26.790   6.837  23.707  1.00 39.07          
ATOM   5074  CA  ILE    90      26.884   6.637  25.162  1.00 39.23          
ATOM   5075  C   ILE    90      27.454   5.281  25.557  1.00 40.21          
ATOM   5076  O   ILE    90      28.150   5.171  26.567  1.00 40.36          
ATOM   5077  CB  ILE    90      25.531   6.956  25.833  1.00 39.83          
ATOM   5078  CG1 ILE    90      25.266   8.451  25.647  1.00 41.69          
ATOM   5079  CG2 ILE    90      25.540   6.659  27.332  1.00 39.16          
ATOM   5080  CD  ILE    90      23.911   8.916  26.069  1.00 45.27          
ATOM   5081  N   GLU    91      27.233   4.279  24.702  1.00 40.79          
ATOM   5082  CA  GLU    91      27.675   2.890  24.968  1.00 40.52          
ATOM   5083  C   GLU    91      29.153   2.727  24.655  1.00 40.24          
ATOM   5084  O   GLU    91      29.783   1.721  25.027  1.00 39.62          
ATOM   5085  CB  GLU    91      26.902   1.877  24.115  1.00 41.21          
ATOM   5086  CG  GLU    91      27.528   1.656  22.734  1.00 44.64          
ATOM   5087  CD  GLU    91      26.618   0.988  21.776  1.00 44.56          
ATOM   5088  OE1 GLU    91      25.545   0.517  22.211  1.00 45.73          
ATOM   5089  OE2 GLU    91      26.984   0.958  20.584  1.00 44.92          
ATOM   5090  N   LYS    92      29.678   3.689  23.899  1.00 40.31          
ATOM   5091  CA  LYS    92      31.098   3.696  23.553  1.00 39.95          
ATOM   5092  C   LYS    92      31.896   4.212  24.727  1.00 40.31          
ATOM   5093  O   LYS    92      33.102   4.040  24.772  1.00 40.53          
ATOM   5094  CB  LYS    92      31.443   4.523  22.308  1.00 40.14          
ATOM   5095  CG  LYS    92      31.526   3.730  20.994  1.00 42.94          
ATOM   5096  CD  LYS    92      30.279   3.818  20.143  1.00 46.49          
ATOM   5097  CE  LYS    92      30.103   5.230  19.569  1.00 48.98          
ATOM   5098  NZ  LYS    92      28.855   5.428  18.768  1.00 51.17          
ATOM   5099  N   THR    93      31.218   4.834  25.692  1.00 41.32          
ATOM   5100  CA  THR    93      31.920   5.405  26.853  1.00 40.85          
ATOM   5101  C   THR    93      32.387   4.300  27.803  1.00 41.25          
ATOM   5102  O   THR    93      31.928   3.161  27.709  1.00 42.04          
ATOM   5103  CB  THR    93      31.073   6.462  27.608  1.00 40.79          
ATOM   5104  OG1 THR    93      29.937   5.846  28.220  1.00 41.24          
ATOM   5105  CG2 THR    93      30.614   7.589  26.661  1.00 40.04          
ATOM   5106  N   PRO    94      33.356   4.609  28.675  1.00 41.25          
ATOM   5107  CA  PRO    94      33.762   3.618  29.652  1.00 41.00          
ATOM   5108  C   PRO    94      32.671   3.419  30.668  1.00 40.74          
ATOM   5109  O   PRO    94      31.797   4.273  30.844  1.00 41.85          
ATOM   5110  CB  PRO    94      34.998   4.237  30.314  1.00 41.62          
ATOM   5111  CG  PRO    94      35.413   5.363  29.444  1.00 41.78          
ATOM   5112  CD  PRO    94      34.191   5.817  28.737  1.00 41.47          
ATOM   5113  N   ASN    95      32.730   2.271  31.318  1.00 41.29          
ATOM   5114  CA  ASN    95      31.720   1.873  32.305  1.00 41.12          
ATOM   5115  C   ASN    95      31.466   2.941  33.347  1.00 39.92          
ATOM   5116  O   ASN    95      30.332   3.180  33.749  1.00 41.22          
ATOM   5117  CB  ASN    95      32.140   0.562  33.000  1.00 41.24          
ATOM   5118  N   HSD    96      32.545   3.577  33.767  1.00 39.10          
ATOM   5119  CA  HSD    96      32.507   4.586  34.853  1.00 39.41          
ATOM   5120  C   HSD    96      32.040   5.959  34.409  1.00 38.82          
ATOM   5121  O   HSD    96      31.812   6.828  35.235  1.00 38.97          
ATOM   5122  CB  HSD    96      33.871   4.729  35.539  1.00 39.24          
ATOM   5123  CG  HSD    96      34.959   5.133  34.608  1.00 37.82          
ATOM   5124  ND1 HSD    96      35.219   6.449  34.295  1.00 39.23          
ATOM   5125  CD2 HSD    96      35.827   4.392  33.889  1.00 34.40          
ATOM   5126  CE1 HSD    96      36.217   6.497  33.430  1.00 38.05          
ATOM   5127  NE2 HSD    96      36.599   5.262  33.163  1.00 37.70          
ATOM   5128  N   CYS    97      31.864   6.139  33.112  1.00 39.16          
ATOM   5129  CA  CYS    97      31.437   7.453  32.584  1.00 38.47          
ATOM   5130  C   CYS    97      30.115   7.884  33.172  1.00 37.90          
ATOM   5131  O   CYS    97      29.174   7.116  33.255  1.00 38.98          
ATOM   5132  CB  CYS    97      31.346   7.452  31.047  1.00 39.30          
ATOM   5133  SG  CYS    97      30.963   9.115  30.301  1.00 42.37          
ATOM   5134  N   VAL    98      30.074   9.141  33.581  1.00 36.74          
ATOM   5135  CA  VAL    98      28.884   9.752  34.176  1.00 36.19          
ATOM   5136  C   VAL    98      28.410  10.938  33.341  1.00 35.18          
ATOM   5137  O   VAL    98      29.196  11.746  32.836  1.00 33.04          
ATOM   5138  CB  VAL    98      29.152  10.216  35.642  1.00 35.13          
ATOM   5139  CG1 VAL    98      27.947  10.906  36.243  1.00 34.86          
ATOM   5140  CG2 VAL    98      29.584   9.036  36.488  1.00 35.61          
ATOM   5141  N   VAL    99      27.096  11.000  33.210  1.00 34.58          
ATOM   5142  CA  VAL    99      26.453  12.056  32.476  1.00 33.75          
ATOM   5143  C   VAL    99      25.872  13.006  33.473  1.00 33.22          
ATOM   5144  O   VAL    99      25.214  12.590  34.420  1.00 32.76          
ATOM   5145  CB  VAL    99      25.315  11.516  31.618  1.00 32.76          
ATOM   5146  CG1 VAL    99      24.709  12.652  30.822  1.00 32.87          
ATOM   5147  CG2 VAL    99      25.829  10.417  30.718  1.00 32.12          
ATOM   5148  N   TYR   100      26.145  14.286  33.264  1.00 33.37          
ATOM   5149  CA  TYR   100      25.634  15.362  34.136  1.00 34.46          
ATOM   5150  C   TYR   100      24.672  16.279  33.410  1.00 35.19          
ATOM   5151  O   TYR   100      24.944  16.785  32.330  1.00 37.50          
ATOM   5152  CB  TYR   100      26.784  16.238  34.720  1.00 34.17          
ATOM   5153  CG  TYR   100      27.662  15.534  35.729  1.00 33.89          
ATOM   5154  CD1 TYR   100      28.783  14.824  35.326  1.00 35.45          
ATOM   5155  CD2 TYR   100      27.373  15.597  37.098  1.00 36.43          
ATOM   5156  CE1 TYR   100      29.593  14.172  36.249  1.00 35.22          
ATOM   5157  CE2 TYR   100      28.165  14.951  38.030  1.00 35.34          
ATOM   5158  CZ  TYR   100      29.275  14.235  37.598  1.00 35.55          
ATOM   5159  OH  TYR   100      30.084  13.601  38.507  1.00 36.63          
ATOM   5160  N   SER   101      23.544  16.517  34.036  1.00 35.55          
ATOM   5161  CA  SER   101      22.561  17.426  33.469  1.00 35.84          
ATOM   5162  C   SER   101      21.973  18.304  34.583  1.00 35.85          
ATOM   5163  O   SER   101      22.370  18.236  35.753  1.00 34.93          
ATOM   5164  CB  SER   101      21.453  16.616  32.775  1.00 36.22          
ATOM   5165  OG  SER   101      20.556  17.443  32.062  1.00 37.59          
ATOM   5166  N   GLY   102      21.028  19.137  34.192  1.00 37.36          
ATOM   5167  CA  GLY   102      20.282  19.961  35.155  1.00 38.02          
ATOM   5168  C   GLY   102      19.080  19.090  35.466  1.00 39.55          
ATOM   5169  O   GLY   102      18.883  18.591  36.592  1.00 38.43          
ATOM   5170  N   ILE   103      18.323  18.866  34.403  1.00 41.31          
ATOM   5171  CA  ILE   103      17.132  18.016  34.419  1.00 42.71          
ATOM   5172  C   ILE   103      17.264  16.943  33.379  1.00 43.69          
ATOM   5173  O   ILE   103      18.220  16.893  32.613  1.00 44.46          
ATOM   5174  CB  ILE   103      15.808  18.800  34.134  1.00 43.33          
ATOM   5175  CG1 ILE   103      15.747  19.339  32.705  1.00 46.58          
ATOM   5176  CG2 ILE   103      15.609  19.967  35.110  1.00 41.75          
ATOM   5177  CD  ILE   103      14.665  20.434  32.518  1.00 42.38          
ATOM   5178  N   SER   104      16.276  16.075  33.358  1.00 44.62          
ATOM   5179  CA  SER   104      16.224  15.019  32.346  1.00 44.96          
ATOM   5180  C   SER   104      14.834  14.951  31.743  1.00 45.40          
ATOM   5181  O   SER   104      14.006  15.849  31.907  1.00 45.70          
ATOM   5182  CB  SER   104      16.584  13.651  32.928  1.00 44.28          
ATOM   5183  OG  SER   104      16.753  12.662  31.903  1.00 43.34          
ATOM   5184  N   ASN   105      14.632  13.879  31.004  1.00 46.31          
ATOM   5185  CA  ASN   105      13.341  13.571  30.409  1.00 46.32          
ATOM   5186  C   ASN   105      13.276  12.099  30.078  1.00 46.53          
ATOM   5187  O   ASN   105      14.206  11.347  30.351  1.00 46.60          
ATOM   5188  CB  ASN   105      13.030  14.414  29.179  1.00 46.13          
ATOM   5189  CG  ASN   105      14.004  14.208  28.065  1.00 47.12          
ATOM   5190  OD1 ASN   105      14.821  13.291  28.086  1.00 51.23          
ATOM   5191  ND2 ASN   105      13.926  15.066  27.068  1.00 52.56          
ATOM   5192  N   THR   106      12.192  11.707  29.439  1.00 46.61          
ATOM   5193  CA  THR   106      11.962  10.298  29.166  1.00 46.82          
ATOM   5194  C   THR   106      13.023   9.754  28.221  1.00 45.37          
ATOM   5195  O   THR   106      13.593   8.685  28.451  1.00 45.34          
ATOM   5196  CB  THR   106      10.532  10.055  28.632  1.00 47.66          
ATOM   5197  OG1 THR   106      10.319  10.860  27.472  1.00 54.98          
ATOM   5198  CG2 THR   106       9.490  10.449  29.683  1.00 47.33          
ATOM   5199  N   TYR   107      13.318  10.525  27.182  1.00 44.50          
ATOM   5200  CA  TYR   107      14.314  10.106  26.178  1.00 43.33          
ATOM   5201  C   TYR   107      15.660   9.897  26.803  1.00 43.27          
ATOM   5202  O   TYR   107      16.317   8.884  26.600  1.00 43.88          
ATOM   5203  CB  TYR   107      14.520  11.159  25.091  1.00 42.78          
ATOM   5204  CG  TYR   107      15.680  10.840  24.147  1.00 42.09          
ATOM   5205  CD1 TYR   107      16.976  11.269  24.417  1.00 42.21          
ATOM   5206  CD2 TYR   107      15.471  10.129  22.974  1.00 38.04          
ATOM   5207  CE1 TYR   107      18.029  10.973  23.541  1.00 40.49          
ATOM   5208  CE2 TYR   107      16.508   9.836  22.113  1.00 38.98          
ATOM   5209  CZ  TYR   107      17.778  10.263  22.393  1.00 40.03          
ATOM   5210  OH  TYR   107      18.794   9.953  21.513  1.00 36.13          
ATOM   5211  N   LEU   108      16.072  10.910  27.545  1.00 42.73          
ATOM   5212  CA  LEU   108      17.394  10.889  28.166  1.00 42.11          
ATOM   5213  C   LEU   108      17.451   9.780  29.201  1.00 42.08          
ATOM   5214  O   LEU   108      18.429   9.023  29.262  1.00 42.25          
ATOM   5215  CB  LEU   108      17.759  12.261  28.772  1.00 40.62          
ATOM   5216  CG  LEU   108      19.207  12.377  29.255  1.00 39.11          
ATOM   5217  CD1 LEU   108      20.142  11.983  28.092  1.00 32.04          
ATOM   5218  CD2 LEU   108      19.514  13.766  29.798  1.00 35.56          
ATOM   5219  N   ASN   109      16.381   9.676  29.979  1.00 42.76          
ATOM   5220  CA  ASN   109      16.284   8.652  31.039  1.00 44.85          
ATOM   5221  C   ASN   109      16.333   7.247  30.455  1.00 45.81          
ATOM   5222  O   ASN   109      16.835   6.307  31.073  1.00 46.87          
ATOM   5223  CB  ASN   109      15.003   8.779  31.871  1.00 44.49          
ATOM   5224  CG  ASN   109      15.012   9.972  32.795  1.00 47.20          
ATOM   5225  OD1 ASN   109      13.951  10.476  33.168  1.00 47.36          
ATOM   5226  ND2 ASN   109      16.205  10.440  33.168  1.00 48.94          
ATOM   5227  N   GLN   110      15.809   7.132  29.243  1.00 46.94          
ATOM   5228  CA  GLN   110      15.751   5.846  28.536  1.00 46.75          
ATOM   5229  C   GLN   110      17.115   5.465  28.002  1.00 46.94          
ATOM   5230  O   GLN   110      17.446   4.274  27.917  1.00 47.34          
ATOM   5231  CB  GLN   110      14.739   5.880  27.384  1.00 47.50          
ATOM   5232  N   CYS   111      17.910   6.464  27.633  1.00 46.37          
ATOM   5233  CA  CYS   111      19.244   6.178  27.077  1.00 47.24          
ATOM   5234  C   CYS   111      20.107   5.616  28.159  1.00 46.79          
ATOM   5235  O   CYS   111      20.815   4.630  27.981  1.00 46.91          
ATOM   5236  CB  CYS   111      19.953   7.437  26.567  1.00 47.93          
ATOM   5237  SG  CYS   111      19.319   8.133  25.029  1.00 52.51          
ATOM   5238  N   MET   112      20.031   6.298  29.289  1.00 46.58          
ATOM   5239  CA  MET   112      20.834   5.977  30.465  1.00 46.56          
ATOM   5240  C   MET   112      20.479   4.620  30.949  1.00 48.04          
ATOM   5241  O   MET   112      21.342   3.842  31.350  1.00 48.81          
ATOM   5242  CB  MET   112      20.581   6.965  31.602  1.00 46.03          
ATOM   5243  CG  MET   112      21.039   8.379  31.312  1.00 44.56          
ATOM   5244  SD  MET   112      22.905   8.445  30.819  0.75 42.63          
ATOM   5245  CE  MET   112      22.790   8.228  28.911  1.00 46.94          
ATOM   5246  N   LYS   113      19.183   4.344  30.861  1.00 49.10          
ATOM   5247  CA  LYS   113      18.611   3.087  31.332  1.00 48.93          
ATOM   5248  C   LYS   113      19.232   1.952  30.583  1.00 48.72          
ATOM   5249  O   LYS   113      19.876   1.086  31.155  1.00 49.42          
ATOM   5250  CB  LYS   113      17.092   3.061  31.121  1.00 49.02          
ATOM   5251  N   LYS   114      19.072   2.024  29.273  1.00 48.92          
ATOM   5252  CA  LYS   114      19.530   0.981  28.356  1.00 48.45          
ATOM   5253  C   LYS   114      21.042   0.861  28.230  1.00 48.47          
ATOM   5254  O   LYS   114      21.549  -0.217  27.892  1.00 48.25          
ATOM   5255  CB  LYS   114      18.937   1.196  26.959  1.00 48.69          
ATOM   5256  N   THR   115      21.760   1.953  28.483  1.00 47.56          
ATOM   5257  CA  THR   115      23.231   1.955  28.325  1.00 46.96          
ATOM   5258  C   THR   115      23.926   1.676  29.643  1.00 46.37          
ATOM   5259  O   THR   115      25.147   1.477  29.704  1.00 45.81          
ATOM   5260  CB  THR   115      23.755   3.273  27.729  1.00 47.28          
ATOM   5261  OG1 THR   115      23.370   4.363  28.569  1.00 45.57          
ATOM   5262  CG2 THR   115      23.209   3.473  26.305  1.00 46.92          
ATOM   5263  N   ASN   116      23.110   1.648  30.687  1.00 46.12          
ATOM   5264  CA  ASN   116      23.571   1.350  32.043  1.00 46.19          
ATOM   5265  C   ASN   116      24.596   2.359  32.537  1.00 46.36          
ATOM   5266  O   ASN   116      25.608   1.989  33.149  1.00 47.77          
ATOM   5267  CB  ASN   116      24.154  -0.077  32.113  1.00 46.58          
ATOM   5268  N   ARG   117      24.341   3.625  32.211  1.00 43.91          
ATOM   5269  CA  ARG   117      25.201   4.741  32.645  1.00 42.92          
ATOM   5270  C   ARG   117      24.505   5.593  33.690  1.00 41.81          
ATOM   5271  O   ARG   117      23.285   5.778  33.667  1.00 41.77          
ATOM   5272  CB  ARG   117      25.627   5.621  31.462  1.00 42.56          
ATOM   5273  CG  ARG   117      26.563   4.936  30.487  1.00 41.73          
ATOM   5274  CD  ARG   117      27.919   4.677  31.121  1.00 39.93          
ATOM   5275  NE  ARG   117      28.812   3.933  30.236  1.00 39.22          
ATOM   5276  CZ  ARG   117      28.726   2.624  30.033  1.00 37.06          
ATOM   5277  NH1 ARG   117      27.761   1.926  30.613  1.00 40.48          
ATOM   5278  NH2 ARG   117      29.579   2.015  29.227  1.00 33.39          
ATOM   5279  N   THR   118      25.308   6.083  34.624  1.00 41.06          
ATOM   5280  CA  THR   118      24.803   6.917  35.723  1.00 40.76          
ATOM   5281  C   THR   118      24.515   8.311  35.230  1.00 40.88          
ATOM   5282  O   THR   118      25.264   8.885  34.454  1.00 41.88          
ATOM   5283  CB  THR   118      25.789   6.964  36.903  1.00 40.55          
ATOM   5284  OG1 THR   118      25.888   5.651  37.481  1.00 39.17          
ATOM   5285  CG2 THR   118      25.324   7.949  37.972  1.00 38.35          
ATOM   5286  N   LEU   119      23.396   8.836  35.699  1.00 41.14          
ATOM   5287  CA  LEU   119      22.959  10.182  35.369  1.00 40.37          
ATOM   5288  C   LEU   119      22.736  11.005  36.613  1.00 40.86          
ATOM   5289  O   LEU   119      22.004  10.618  37.524  1.00 42.05          
ATOM   5290  CB  LEU   119      21.659  10.135  34.574  1.00 40.04          
ATOM   5291  CG  LEU   119      20.977  11.447  34.218  1.00 40.56          
ATOM   5292  CD1 LEU   119      21.805  12.264  33.222  1.00 38.38          
ATOM   5293  CD2 LEU   119      19.601  11.131  33.665  1.00 39.70          
ATOM   5294  N   VAL   120      23.394  12.155  36.621  1.00 39.92          
ATOM   5295  CA  VAL   120      23.270  13.125  37.684  1.00 38.32          
ATOM   5296  C   VAL   120      22.528  14.358  37.188  1.00 37.96          
ATOM   5297  O   VAL   120      22.954  15.068  36.297  1.00 37.18          
ATOM   5298  CB  VAL   120      24.641  13.515  38.244  1.00 38.18          
ATOM   5299  CG1 VAL   120      24.484  14.614  39.283  1.00 39.45          
ATOM   5300  CG2 VAL   120      25.315  12.305  38.842  1.00 35.61          
ATOM   5301  N   LYS   121      21.387  14.579  37.804  1.00 39.09          
ATOM   5302  CA  LYS   121      20.538  15.708  37.517  1.00 40.28          
ATOM   5303  C   LYS   121      20.794  16.727  38.609  1.00 40.44          
ATOM   5304  O   LYS   121      20.257  16.617  39.722  1.00 41.53          
ATOM   5305  CB  LYS   121      19.067  15.280  37.513  1.00 41.36          
ATOM   5306  CG  LYS   121      18.678  14.383  36.341  1.00 46.64          
ATOM   5307  CD  LYS   121      17.268  13.845  36.498  1.00 51.76          
ATOM   5308  CE  LYS   121      17.214  12.564  37.339  1.00 55.73          
ATOM   5309  NZ  LYS   121      17.794  11.378  36.632  1.00 62.99          
ATOM   5310  N   LEU   122      21.613  17.717  38.275  1.00 38.60          
ATOM   5311  CA  LEU   122      22.052  18.711  39.250  1.00 38.25          
ATOM   5312  C   LEU   122      20.918  19.472  39.889  1.00 38.05          
ATOM   5313  O   LEU   122      21.045  19.937  41.038  1.00 39.59          
ATOM   5314  CB  LEU   122      23.079  19.698  38.651  1.00 38.27          
ATOM   5315  CG  LEU   122      24.412  19.034  38.228  1.00 40.04          
ATOM   5316  CD1 LEU   122      25.362  20.069  37.607  1.00 38.19          
ATOM   5317  CD2 LEU   122      25.102  18.270  39.399  1.00 36.41          
ATOM   5318  N   MET   123      19.794  19.565  39.195  1.00 37.68          
ATOM   5319  CA  MET   123      18.660  20.354  39.721  1.00 40.14          
ATOM   5320  C   MET   123      17.887  19.613  40.805  1.00 40.62          
ATOM   5321  O   MET   123      17.015  20.179  41.443  1.00 42.50          
ATOM   5322  CB  MET   123      17.736  20.864  38.612  1.00 40.77          
ATOM   5323  CG  MET   123      18.422  21.916  37.734  1.00 40.86          
ATOM   5324  SD  MET   123      18.760  23.569  38.754  0.75 48.31          
ATOM   5325  CE  MET   123      16.899  24.055  38.763  1.00 60.03          
ATOM   5326  N   GLU   124      18.245  18.363  41.036  1.00 40.72          
ATOM   5327  CA  GLU   124      17.615  17.587  42.115  1.00 41.20          
ATOM   5328  C   GLU   124      18.319  17.830  43.435  1.00 40.98          
ATOM   5329  O   GLU   124      17.912  17.308  44.467  1.00 40.56          
ATOM   5330  CB  GLU   124      17.603  16.093  41.819  1.00 41.28          
ATOM   5331  CG  GLU   124      16.575  15.777  40.792  1.00 45.24          
ATOM   5332  CD  GLU   124      16.505  14.317  40.437  1.00 45.98          
ATOM   5333  OE1 GLU   124      17.314  13.503  40.925  1.00 49.43          
ATOM   5334  OE2 GLU   124      15.626  14.001  39.622  1.00 52.91          
ATOM   6418  N   ALA   272      21.807  35.858  34.651  1.00 35.38          
ATOM   6419  CA  ALA   272      22.948  35.845  35.578  1.00 35.24          
ATOM   6420  C   ALA   272      23.868  34.667  35.271  1.00 35.49          
ATOM   6421  O   ALA   272      24.188  33.876  36.161  1.00 35.95          
ATOM   6422  CB  ALA   272      22.439  35.763  37.026  1.00 34.02          
ATOM   6423  N   PRO   273      24.292  34.542  34.006  1.00 35.20          
ATOM   6424  CA  PRO   273      25.054  33.358  33.603  1.00 35.87          
ATOM   6425  C   PRO   273      26.382  33.146  34.347  1.00 35.09          
ATOM   6426  O   PRO   273      26.809  32.012  34.533  1.00 34.96          
ATOM   6427  CB  PRO   273      25.277  33.588  32.097  1.00 36.80          
ATOM   6428  CG  PRO   273      25.121  35.069  31.902  1.00 33.69          
ATOM   6429  CD  PRO   273      24.107  35.491  32.896  1.00 34.93          
ATOM   6430  N   LYS   274      27.008  34.241  34.769  1.00 36.07          
ATOM   6431  CA  LYS   274      28.282  34.152  35.477  1.00 35.81          
ATOM   6432  C   LYS   274      28.019  33.542  36.853  1.00 36.80          
ATOM   6433  O   LYS   274      28.656  32.557  37.244  1.00 34.09          
ATOM   6434  CB  LYS   274      28.977  35.504  35.599  1.00 36.99          
ATOM   6435  CG  LYS   274      30.304  35.427  36.347  1.00 42.83          
ATOM   6436  CD  LYS   274      31.130  36.698  36.306  1.00 48.06          
ATOM   6437  CE  LYS   274      31.991  36.745  35.026  1.00 58.72          
ATOM   6438  NZ  LYS   274      33.011  37.874  35.027  1.00 60.62          
ATOM   6439  N   THR   275      27.038  34.131  37.560  1.00 37.56          
ATOM   6440  CA  THR   275      26.678  33.663  38.904  1.00 37.02          
ATOM   6441  C   THR   275      26.243  32.191  38.810  1.00 37.27          
ATOM   6442  O   THR   275      26.744  31.350  39.516  1.00 37.85          
ATOM   6443  CB  THR   275      25.522  34.496  39.565  1.00 36.76          
ATOM   6444  OG1 THR   275      25.871  35.892  39.612  1.00 33.66          
ATOM   6445  CG2 THR   275      25.283  34.032  40.994  1.00 32.24          
ATOM   6446  N   ALA   276      25.328  31.906  37.896  1.00 36.46          
ATOM   6447  CA  ALA   276      24.756  30.563  37.786  1.00 35.63          
ATOM   6448  C   ALA   276      25.794  29.545  37.338  1.00 35.33          
ATOM   6449  O   ALA   276      25.844  28.418  37.818  1.00 35.30          
ATOM   6450  CB  ALA   276      23.562  30.576  36.842  1.00 35.71          
ATOM   6451  N   GLY   277      26.636  29.951  36.405  1.00 34.65          
ATOM   6452  CA  GLY   277      27.642  29.049  35.895  1.00 34.43          
ATOM   6453  C   GLY   277      28.707  28.673  36.913  1.00 34.38          
ATOM   6454  O   GLY   277      29.214  27.557  36.920  1.00 32.61          
ATOM   6455  N   ARG   278      29.076  29.638  37.741  1.00 35.41          
ATOM   6456  CA  ARG   278      30.142  29.437  38.742  1.00 36.75          
ATOM   6457  C   ARG   278      29.643  28.493  39.801  1.00 36.21          
ATOM   6458  O   ARG   278      30.390  27.674  40.327  1.00 37.56          
ATOM   6459  CB  ARG   278      30.623  30.762  39.357  1.00 38.69          
ATOM   6460  CG  ARG   278      31.522  31.505  38.406  1.00 45.43          
ATOM   6461  CD  ARG   278      32.090  32.796  38.976  1.00 52.00          
ATOM   6462  NE  ARG   278      33.088  33.355  38.072  1.00 53.88          
ATOM   6463  CZ  ARG   278      33.694  34.524  38.253  1.00 58.62          
ATOM   6464  NH1 ARG   278      33.396  35.267  39.305  1.00 62.92          
ATOM   6465  NH2 ARG   278      34.588  34.956  37.371  1.00 60.40          
ATOM   6466  N   ILE   279      28.357  28.568  40.064  1.00 36.67          
ATOM   6467  CA  ILE   279      27.775  27.657  41.033  1.00 38.68          
ATOM   6468  C   ILE   279      27.894  26.231  40.516  1.00 37.80          
ATOM   6469  O   ILE   279      28.311  25.344  41.235  1.00 35.52          
ATOM   6470  CB  ILE   279      26.353  28.004  41.360  1.00 39.89          
ATOM   6471  CG1 ILE   279      26.356  29.219  42.313  1.00 45.87          
ATOM   6472  CG2 ILE   279      25.659  26.804  42.012  1.00 45.64          
ATOM   6473  CD  ILE   279      24.973  29.766  42.545  1.00 44.81          
ATOM   6474  N   LEU   280      27.601  26.049  39.233  1.00 36.18          
ATOM   6475  CA  LEU   280      27.656  24.711  38.625  1.00 36.08          
ATOM   6476  C   LEU   280      29.070  24.210  38.531  1.00 36.05          
ATOM   6477  O   LEU   280      29.355  23.020  38.785  1.00 35.42          
ATOM   6478  CB  LEU   280      27.053  24.723  37.229  1.00 35.75          
ATOM   6479  CG  LEU   280      25.571  25.102  37.225  1.00 34.13          
ATOM   6480  CD1 LEU   280      25.086  25.208  35.782  1.00 33.56          
ATOM   6481  CD2 LEU   280      24.770  24.058  38.056  1.00 36.69          
ATOM   6482  N   ALA   281      29.953  25.138  38.177  1.00 36.20          
ATOM   6483  CA  ALA   281      31.375  24.821  37.986  1.00 36.81          
ATOM   6484  C   ALA   281      31.944  24.293  39.275  1.00 36.29          
ATOM   6485  O   ALA   281      32.630  23.285  39.306  1.00 36.89          
ATOM   6486  CB  ALA   281      32.183  26.052  37.494  1.00 36.74          
ATOM   6487  N   ASP   282      31.629  24.999  40.339  1.00 38.00          
ATOM   6488  CA  ASP   282      32.112  24.634  41.675  1.00 39.37          
ATOM   6489  C   ASP   282      31.688  23.222  42.070  1.00 38.38          
ATOM   6490  O   ASP   282      32.477  22.457  42.618  1.00 39.01          
ATOM   6491  CB  ASP   282      31.578  25.587  42.736  1.00 39.09          
ATOM   6492  CG  ASP   282      32.273  26.935  42.728  1.00 44.73          
ATOM   6493  OD1 ASP   282      33.403  27.032  42.211  1.00 48.54          
ATOM   6494  OD2 ASP   282      31.682  27.890  43.274  1.00 52.09          
ATOM   6495  N   VAL   283      30.432  22.896  41.815  1.00 36.83          
ATOM   6496  CA  VAL   283      29.913  21.587  42.226  1.00 38.27          
ATOM   6497  C   VAL   283      30.496  20.502  41.328  1.00 38.40          
ATOM   6498  O   VAL   283      30.854  19.385  41.787  1.00 38.78          
ATOM   6499  CB  VAL   283      28.353  21.540  42.295  1.00 39.45          
ATOM   6500  CG1 VAL   283      27.714  21.676  40.929  1.00 42.01          
ATOM   6501  CG2 VAL   283      27.927  20.224  42.934  1.00 40.02          
ATOM   6502  N   LEU   284      30.690  20.874  40.066  1.00 37.24          
ATOM   6503  CA  LEU   284      31.156  19.918  39.057  1.00 37.24          
ATOM   6504  C   LEU   284      32.607  19.516  39.341  1.00 38.09          
ATOM   6505  O   LEU   284      33.000  18.337  39.197  1.00 36.39          
ATOM   6506  CB  LEU   284      30.975  20.449  37.619  1.00 37.69          
ATOM   6507  CG  LEU   284      29.540  20.396  37.064  1.00 36.11          
ATOM   6508  CD1 LEU   284      29.350  21.193  35.763  1.00 25.72          
ATOM   6509  CD2 LEU   284      29.197  18.932  36.856  1.00 34.19          
ATOM   6510  N   VAL   285      33.395  20.507  39.740  1.00 38.57          
ATOM   6511  CA  VAL   285      34.806  20.264  40.049  1.00 39.64          
ATOM   6512  C   VAL   285      34.880  19.238  41.173  1.00 39.71          
ATOM   6513  O   VAL   285      35.650  18.281  41.126  1.00 41.10          
ATOM   6514  CB  VAL   285      35.549  21.556  40.475  1.00 40.45          
ATOM   6515  CG1 VAL   285      36.743  21.202  41.309  1.00 45.29          
ATOM   6516  CG2 VAL   285      35.963  22.382  39.259  1.00 42.88          
ATOM   6517  N   LYS   286      34.007  19.418  42.153  1.00 41.12          
ATOM   6518  CA  LYS   286      33.966  18.536  43.335  1.00 42.11          
ATOM   6519  C   LYS   286      33.515  17.123  42.988  1.00 42.29          
ATOM   6520  O   LYS   286      34.125  16.144  43.408  1.00 43.13          
ATOM   6521  CB  LYS   286      33.054  19.117  44.413  1.00 42.11          
ATOM   6522  N   LEU   287      32.469  17.044  42.178  1.00 42.60          
ATOM   6523  CA  LEU   287      31.847  15.764  41.790  1.00 42.28          
ATOM   6524  C   LEU   287      32.733  14.944  40.889  1.00 43.80          
ATOM   6525  O   LEU   287      32.813  13.721  41.011  1.00 46.63          
ATOM   6526  CB  LEU   287      30.482  15.987  41.125  1.00 40.67          
ATOM   6527  CG  LEU   287      29.431  16.534  42.102  1.00 41.63          
ATOM   6528  CD1 LEU   287      28.100  17.001  41.453  1.00 29.32          
ATOM   6529  CD2 LEU   287      29.198  15.465  43.170  1.00 41.60          
ATOM   6530  N   LEU   288      33.453  15.638  40.026  1.00 44.47          
ATOM   6531  CA  LEU   288      34.334  14.990  39.042  1.00 44.99          
ATOM   6532  C   LEU   288      35.599  14.494  39.702  1.00 45.87          
ATOM   6533  O   LEU   288      36.251  13.551  39.235  1.00 45.07          
ATOM   6534  CB  LEU   288      34.670  15.967  37.898  1.00 44.18          
ATOM   6535  CG  LEU   288      33.465  16.271  37.009  1.00 41.21          
ATOM   6536  CD1 LEU   288      33.672  17.483  36.137  1.00 37.69          
ATOM   6537  CD2 LEU   288      33.138  15.031  36.167  1.00 37.00          
ATOM   6538  N   ALA   289      35.891  15.113  40.834  1.00 47.89          
ATOM   6539  CA  ALA   289      37.121  14.849  41.589  1.00 50.34          
ATOM   6540  C   ALA   289      36.944  13.721  42.606  1.00 53.00          
ATOM   6541  O   ALA   289      37.840  13.426  43.395  1.00 54.41          
ATOM   6542  CB  ALA   289      37.601  16.125  42.269  1.00 50.35          
ATOM   6543  N   GLU   290      35.776  13.096  42.572  1.00 55.42          
ATOM   6544  CA  GLU   290      35.462  11.968  43.452  1.00 56.16          
ATOM   6545  C   GLU   290      35.895  10.701  42.758  1.00 56.78          
ATOM   6546  O   GLU   290      36.912  10.699  42.067  1.00 57.98          
ATOM   6547  CB  GLU   290      33.972  11.902  43.766  1.00 56.82          
ATOM   6548  CG  GLU   290      33.462  13.032  44.651  1.00 59.39          
ATOM   6549  CD  GLU   290      31.935  13.013  44.836  1.00 64.71          
ATOM   6550  OE1 GLU   290      31.247  12.181  44.174  1.00 61.89          
ATOM   6551  OE2 GLU   290      31.430  13.847  45.639  1.00 63.04          
END
