
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  164 ( 1362),  selected  164 , name 2q7b_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 2q7b_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    F    -2_A      -       -           -
LGA    Q    -1_A      -       -           -
LGA    G     0_A      A       2          2.736
LGA    X     1_A      I       3          1.807
LGA    E     2_A      N       4          0.882
LGA    I     3_A      I       5          0.663
LGA    K     4_A      I       6          0.601
LGA    E     5_A      E       7          0.620
LGA    Y     6_A      Y       8          0.791
LGA    E     7_A      N       9          1.388
LGA    N     8_A      R      10          1.593
LGA    N     9_A      S      11          0.858
LGA    P    10_A      -       -           -
LGA    Y    11_A      -       -           -
LGA    H    12_A      Y      12          2.255
LGA    L    13_A      K      13          2.068
LGA    A    14_A      E      14          2.401
LGA    Q    15_A      E      15          1.857
LGA    L    16_A      L      16          1.092
LGA    V    17_A      I      17          1.685
LGA    D    18_A      E      18          1.999
LGA    L    19_A      F      19          1.121
LGA    I    20_A      I      20          0.354
LGA    N    21_A      L      21          1.346
LGA    Y    22_A      S      22          1.532
LGA    C    23_A      I      23          1.091
LGA    Q    24_A      Q      24          0.271
LGA    N    25_A      K      25          0.491
LGA    I    26_A      N      26          0.905
LGA    E    27_A      E      27          0.978
LGA    A    28_A      F      28          0.667
LGA    K    29_A      N      29          0.291
LGA    L    30_A      I      30          0.408
LGA    D    31_A      K      31          2.586
LGA    I    32_A      I      32          1.311
LGA    K    33_A      D      33          0.867
LGA    X    34_A      R      34          0.679
LGA    A    35_A      D      35          1.052
LGA    E    36_A      D      36          0.881
LGA    Q    37_A      Q      37          0.734
LGA    D    38_A      P      38          1.532
LGA    D    39_A      D      39          1.295
LGA    I    40_A      L      40          1.170
LGA    F    41_A      E      41          1.562
LGA    Q    42_A      N      42          0.608
LGA    I    43_A      I      43          0.794
LGA    E    44_A      E      44          0.765
LGA    N    45_A      H      45          0.812
LGA    Y    46_A      N      46          0.796
LGA    Y    47_A      Y      47          0.781
LGA    Q    48_A      L      48          0.697
LGA    N    49_A      N      49          0.663
LGA    R    50_A      S      50          0.530
LGA    K    51_A      G      51          0.389
LGA    G    52_A      G      52          0.560
LGA    Q    53_A      Q      53          1.201
LGA    F    54_A      F      54          0.676
LGA    W    55_A      W      55          0.744
LGA    I    56_A      L      56          0.823
LGA    A    57_A      A      57          1.011
LGA    L    58_A      I      58          0.823
LGA    E    59_A      N      59          0.618
LGA    N    60_A      N      60          2.110
LGA    -       -      H      61           -
LGA    E    61_A      Q      62          0.769
LGA    K    62_A      N      63          0.670
LGA    V    63_A      I      64          1.014
LGA    V    64_A      V      65          1.222
LGA    G    65_A      G      66          0.819
LGA    S    66_A      T      67          0.570
LGA    I    67_A      I      68          0.325
LGA    A    68_A      G      69          0.601
LGA    L    69_A      L      70          0.728
LGA    L    70_A      I      71          0.230
LGA    R    71_A      R      72          0.264
LGA    I    72_A      L      73          0.452
LGA    D    73_A      D      74          1.876
LGA    D    74_A      N      75          4.564
LGA    K    75_A      N      76          1.583
LGA    T    76_A      M      77          0.366
LGA    A    77_A      S      78          0.382
LGA    V    78_A      A      79          0.245
LGA    L    79_A      L      80          0.371
LGA    K    80_A      K      81          0.292
LGA    K    81_A      K      82          0.942
LGA    F    82_A      M      83          0.698
LGA    F    83_A      F      84          0.879
LGA    T    84_A      V      85          0.811
LGA    Y    85_A      D      86          0.414
LGA    P    86_A      K      87          1.587
LGA    K    87_A      G      88          2.160
LGA    Y    88_A      Y      89          1.534
LGA    R    89_A      R      90          1.493
LGA    G    90_A      N      91          2.677
LGA    N    91_A      -       -           -
LGA    P    92_A      -       -           -
LGA    V    93_A      L      92          1.562
LGA    R    94_A      K      93          0.852
LGA    L    95_A      I      94          0.644
LGA    G    96_A      G      95          0.601
LGA    R    97_A      K      96          0.536
LGA    K    98_A      K      97          0.652
LGA    L    99_A      L      98          0.566
LGA    F   100_A      L      99          0.620
LGA    E   101_A      D     100          0.652
LGA    R   102_A      K     101          0.646
LGA    F   103_A      V     102          0.971
LGA    X   104_A      I     103          0.919
LGA    L   105_A      M     104          1.039
LGA    F   106_A      T     105          0.969
LGA    A   107_A      C     106          1.051
LGA    R   108_A      K     107          1.096
LGA    A   109_A      E     108          0.885
LGA    S   110_A      Q     109          0.928
LGA    K   111_A      N     110          0.758
LGA    F   112_A      I     111          0.993
LGA    T   113_A      D     112          0.959
LGA    R   114_A      G     113          1.368
LGA    I   115_A      I     114          0.385
LGA    V   116_A      Y     115          0.400
LGA    L   117_A      L     116          0.421
LGA    D   118_A      G     117          0.766
LGA    T   119_A      T     118          0.826
LGA    P   120_A      I     119          0.387
LGA    E   121_A      D     120          2.028
LGA    K   122_A      K     121          2.378
LGA    E   123_A      F     122          2.009
LGA    K   124_A      I     123          1.960
LGA    R   125_A      S     124          0.617
LGA    S   126_A      A     125          0.588
LGA    H   127_A      Q     126          0.528
LGA    F   128_A      Y     127          0.261
LGA    F   129_A      F     128          0.369
LGA    Y   130_A      Y     129          0.315
LGA    E   131_A      S     130          0.470
LGA    N   132_A      N     131          0.639
LGA    Q   133_A      N     132          0.530
LGA    G   134_A      G     133          0.919
LGA    F   135_A      F     134          0.329
LGA    K   136_A      R     135          0.392
LGA    Q   137_A      E     136          0.398
LGA    I   138_A      I     137          0.331
LGA    T   139_A      K     138          0.552
LGA    R   140_A      R     139          0.789
LGA    D   141_A      G     140          1.312
LGA    E   142_A      D     141          2.917
LGA    L   143_A      L     142          3.131
LGA    D   144_A      P     143          3.230
LGA    V   145_A      S     144          3.808
LGA    D   146_A      S     145          1.693
LGA    Y   147_A      F     146          1.872
LGA    I   148_A      P     147          3.628
LGA    F   149_A      K     148          1.539
LGA    P   150_A      L     149          1.049
LGA    D   151_A      D     150          1.510
LGA    R   152_A      V     151          2.123
LGA    D   153_A      D     152          4.845
LGA    S   154_A      N     153          1.392
LGA    R   155_A      R     154          0.482
LGA    I   156_A      F     155          0.658
LGA    Y   157_A      Y     156          0.460
LGA    V   158_A      Y     157          0.376
LGA    K   159_A      R     158          0.475
LGA    L   160_A      N     159          0.592
LGA    L   161_A      L     160          0.826
LGA    -       -      K     161           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  164  160    5.0    158    1.35    32.91     93.583    10.871

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.274956 * X  +   0.768631 * Y  +  -0.577586 * Z  + -47.040607
  Y_new =  -0.883509 * X  +  -0.438939 * Y  +  -0.163536 * Z  +  58.719944
  Z_new =  -0.379223 * X  +   0.465337 * Y  +   0.799782 * Z  +   5.897509 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.526952   -2.614640  [ DEG:    30.1922   -149.8078 ]
  Theta =   0.388957    2.752636  [ DEG:    22.2856    157.7144 ]
  Phi   =  -1.872504    1.269089  [ DEG:  -107.2866     72.7134 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2q7b_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2q7b_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  164  160   5.0  158   1.35   32.91  93.583
REMARK  ---------------------------------------------------------- 
MOLECULE 2q7b_A
HEADER    TRANSFERASE                             06-JUN-07   2Q7B              
TITLE     CRYSTAL STRUCTURE OF ACETYLTRANSFERASE (NP_689019.1) FROM             
TITLE    2 STREPTOCOCCUS AGALACTIAE 2603 AT 2.00 A RESOLUTION                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACETYLTRANSFERASE, GNAT FAMILY;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS AGALACTIAE 2603V/R;               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 2603 V/R, SEROTYPE V;                                        
SOURCE   5 ATCC: BAA-611;                                                       
SOURCE   6 GENE: NP_689019.1, SAG2033;                                          
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_689019.1, ACETYLTRANSFERASE (GNAT) FAMILY, STRUCTURAL              
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   26-JUN-07 2Q7B    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF ACETYLTRANSFERASE                       
JRNL        TITL 2 (NP_689019.1) FROM STREPTOCOCCUS AGALACTIAE 2603             
JRNL        TITL 3 AT 2.00 A RESOLUTION                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2Q7B A    1   162  UNP    Q8DX25   Q8DX25_STRA5     1    162             
SEQRES   1 A  181  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  181  ASN LEU TYR PHE GLN GLY MSE GLU ILE LYS GLU TYR GLU          
SEQRES   3 A  181  ASN ASN PRO TYR HIS LEU ALA GLN LEU VAL ASP LEU ILE          
SEQRES   4 A  181  ASN TYR CYS GLN ASN ILE GLU ALA LYS LEU ASP ILE LYS          
SEQRES   5 A  181  MSE ALA GLU GLN ASP ASP ILE PHE GLN ILE GLU ASN TYR          
SEQRES   6 A  181  TYR GLN ASN ARG LYS GLY GLN PHE TRP ILE ALA LEU GLU          
SEQRES   7 A  181  ASN GLU LYS VAL VAL GLY SER ILE ALA LEU LEU ARG ILE          
SEQRES   8 A  181  ASP ASP LYS THR ALA VAL LEU LYS LYS PHE PHE THR TYR          
SEQRES   9 A  181  PRO LYS TYR ARG GLY ASN PRO VAL ARG LEU GLY ARG LYS          
SEQRES  10 A  181  LEU PHE GLU ARG PHE MSE LEU PHE ALA ARG ALA SER LYS          
SEQRES  11 A  181  PHE THR ARG ILE VAL LEU ASP THR PRO GLU LYS GLU LYS          
SEQRES  12 A  181  ARG SER HIS PHE PHE TYR GLU ASN GLN GLY PHE LYS GLN          
SEQRES  13 A  181  ILE THR ARG ASP GLU LEU ASP VAL ASP TYR ILE PHE PRO          
SEQRES  14 A  181  ASP ARG ASP SER ARG ILE TYR VAL LYS LEU LEU ASP              
HET    MSE  A   1      16                                                       
HET    MSE  A  34       8                                                       
HET    MSE  A 104       8                                                       
HET     CL      1       1                                                       
HET    FLC      2      13                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     FLC CITRATE ANION                                                    
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2   CL    CL 1-                                                        
FORMUL   3  FLC    C6 H5 O7 3-                                                  
FORMUL   4  HOH   *92(H2 O)                                                     
CRYST1   67.985   67.985   87.772  90.00  90.00 120.00 P 31 2 1      6          
ATOM      1  N   PHE A  -2     -29.042  42.807  35.106  1.00 60.50           N  
ATOM      2  CA  PHE A  -2     -30.211  41.890  35.289  1.00 60.61           C  
ATOM      3  C   PHE A  -2     -31.043  42.339  36.513  1.00 59.62           C  
ATOM      4  O   PHE A  -2     -30.495  42.908  37.458  1.00 58.83           O  
ATOM      5  CB  PHE A  -2     -29.740  40.428  35.420  1.00 60.32           C  
ATOM      6  CG  PHE A  -2     -30.767  39.433  34.968  1.00 60.85           C  
ATOM      7  CD1 PHE A  -2     -31.765  38.987  35.841  1.00 60.77           C  
ATOM      8  CD2 PHE A  -2     -30.761  38.973  33.659  1.00 57.27           C  
ATOM      9  CE1 PHE A  -2     -32.731  38.096  35.414  1.00 58.98           C  
ATOM     10  CE2 PHE A  -2     -31.722  38.078  33.228  1.00 58.12           C  
ATOM     11  CZ  PHE A  -2     -32.713  37.645  34.100  1.00 57.75           C  
ATOM     12  N   GLN A  -1     -32.352  42.076  36.484  1.00 57.84           N  
ATOM     13  CA  GLN A  -1     -33.293  42.527  37.529  1.00 57.18           C  
ATOM     14  C   GLN A  -1     -32.965  42.128  38.972  1.00 55.09           C  
ATOM     15  O   GLN A  -1     -32.784  40.943  39.258  1.00 56.13           O  
ATOM     16  CB  GLN A  -1     -34.728  42.078  37.186  1.00 57.95           C  
ATOM     17  N   GLY A   0     -32.918  43.137  39.864  1.00 52.74           N  
ATOM     18  CA  GLY A   0     -32.619  42.992  41.319  1.00 49.82           C  
ATOM     19  C   GLY A   0     -31.256  42.391  41.642  1.00 47.65           C  
ATOM     20  O   GLY A   0     -31.056  41.781  42.694  1.00 49.14           O  
HETATM   21  N   MSE A   1     -30.299  42.656  40.769  0.50 45.46           N  
HETATM   23  CA  MSE A   1     -29.009  42.028  40.846  0.50 43.52           C  
HETATM   25  C   MSE A   1     -27.911  43.074  40.801  0.50 43.07           C  
HETATM   27  O   MSE A   1     -28.030  44.064  40.085  0.50 40.38           O  
HETATM   29  CB  MSE A   1     -28.944  41.086  39.654  0.50 43.65           C  
HETATM   31  CG  MSE A   1     -28.013  39.953  39.769  0.50 47.38           C  
HETATM   33 SE   MSE A   1     -28.855  38.376  38.982  0.37 39.74          SE  
HETATM   35  CE  MSE A   1     -27.510  37.281  39.530  0.50 39.24           C  
ATOM     37  N   GLU A   2     -26.857  42.859  41.583  1.00 42.94           N  
ATOM     38  CA  GLU A   2     -25.721  43.773  41.619  1.00 44.45           C  
ATOM     39  C   GLU A   2     -24.459  43.036  42.013  1.00 40.72           C  
ATOM     40  O   GLU A   2     -24.532  42.033  42.697  1.00 40.91           O  
ATOM     41  CB  GLU A   2     -25.950  44.941  42.569  1.00 46.25           C  
ATOM     42  CG  GLU A   2     -26.316  44.581  43.997  1.00 53.63           C  
ATOM     43  CD  GLU A   2     -26.271  45.793  44.958  1.00 54.32           C  
ATOM     44  OE1 GLU A   2     -25.832  46.906  44.546  1.00 59.14           O  
ATOM     45  OE2 GLU A   2     -26.659  45.608  46.145  1.00 72.00           O  
ATOM     46  N   ILE A   3     -23.316  43.508  41.530  1.00 36.21           N  
ATOM     47  CA  ILE A   3     -22.026  42.959  41.903  1.00 36.37           C  
ATOM     48  C   ILE A   3     -21.326  44.069  42.637  1.00 37.37           C  
ATOM     49  O   ILE A   3     -21.296  45.195  42.162  1.00 35.56           O  
ATOM     50  CB  ILE A   3     -21.174  42.559  40.688  1.00 35.13           C  
ATOM     51  CG1 ILE A   3     -21.796  41.337  40.000  1.00 34.17           C  
ATOM     52  CG2 ILE A   3     -19.719  42.277  41.114  1.00 33.49           C  
ATOM     53  CD1 ILE A   3     -21.222  41.066  38.632  1.00 36.98           C  
ATOM     54  N   LYS A   4     -20.771  43.773  43.805  1.00 39.58           N  
ATOM     55  CA  LYS A   4     -20.051  44.791  44.534  1.00 38.73           C  
ATOM     56  C   LYS A   4     -18.908  44.263  45.357  1.00 36.46           C  
ATOM     57  O   LYS A   4     -18.806  43.076  45.593  1.00 35.55           O  
ATOM     58  CB  LYS A   4     -21.021  45.628  45.363  1.00 41.57           C  
ATOM     59  CG  LYS A   4     -21.766  44.958  46.480  1.00 46.17           C  
ATOM     60  CD  LYS A   4     -22.825  45.963  46.965  1.00 54.71           C  
ATOM     61  CE  LYS A   4     -23.342  45.685  48.366  1.00 60.59           C  
ATOM     62  NZ  LYS A   4     -24.404  46.669  48.745  1.00 65.94           N  
ATOM     63  N   GLU A   5     -18.020  45.172  45.754  1.00 36.00           N  
ATOM     64  CA  GLU A   5     -16.870  44.818  46.569  1.00 36.63           C  
ATOM     65  C   GLU A   5     -17.356  44.339  47.928  1.00 34.72           C  
ATOM     66  O   GLU A   5     -18.310  44.894  48.472  1.00 35.23           O  
ATOM     67  CB  GLU A   5     -15.932  46.017  46.715  1.00 36.57           C  
ATOM     68  CG  GLU A   5     -15.257  46.381  45.401  1.00 38.38           C  
ATOM     69  CD  GLU A   5     -14.546  47.722  45.424  1.00 42.70           C  
ATOM     70  OE1 GLU A   5     -14.319  48.285  46.525  1.00 46.52           O  
ATOM     71  OE2 GLU A   5     -14.213  48.204  44.317  1.00 48.20           O  
ATOM     72  N   TYR A   6     -16.728  43.292  48.456  1.00 34.68           N  
ATOM     73  CA  TYR A   6     -17.113  42.751  49.755  1.00 35.65           C  
ATOM     74  C   TYR A   6     -16.912  43.801  50.876  1.00 35.43           C  
ATOM     75  O   TYR A   6     -15.992  44.610  50.822  1.00 36.15           O  
ATOM     76  CB  TYR A   6     -16.339  41.451  50.070  1.00 36.91           C  
ATOM     77  CG  TYR A   6     -16.694  40.876  51.428  1.00 40.07           C  
ATOM     78  CD1 TYR A   6     -17.787  40.022  51.581  1.00 42.23           C  
ATOM     79  CD2 TYR A   6     -15.964  41.218  52.570  1.00 35.92           C  
ATOM     80  CE1 TYR A   6     -18.153  39.524  52.833  1.00 41.39           C  
ATOM     81  CE2 TYR A   6     -16.314  40.701  53.830  1.00 38.38           C  
ATOM     82  CZ  TYR A   6     -17.423  39.861  53.947  1.00 42.15           C  
ATOM     83  OH  TYR A   6     -17.802  39.364  55.187  1.00 47.80           O  
ATOM     84  N   GLU A   7     -17.828  43.819  51.840  1.00 36.36           N  
ATOM     85  CA  GLU A   7     -17.731  44.639  53.048  1.00 37.91           C  
ATOM     86  C   GLU A   7     -18.136  43.722  54.196  1.00 36.68           C  
ATOM     87  O   GLU A   7     -19.048  42.906  54.038  1.00 35.19           O  
ATOM     88  CB  GLU A   7     -18.697  45.807  53.048  1.00 38.67           C  
ATOM     89  CG  GLU A   7     -18.618  46.752  51.874  1.00 49.94           C  
ATOM     90  CD  GLU A   7     -19.635  47.880  51.997  1.00 45.90           C  
ATOM     91  OE1 GLU A   7     -19.651  48.547  53.057  1.00 60.25           O  
ATOM     92  OE2 GLU A   7     -20.410  48.083  51.039  1.00 61.48           O  
ATOM     93  N   ASN A   8     -17.490  43.861  55.345  1.00 36.05           N  
ATOM     94  CA  ASN A   8     -17.768  42.985  56.479  1.00 38.20           C  
ATOM     95  C   ASN A   8     -19.252  43.031  56.769  1.00 36.50           C  
ATOM     96  O   ASN A   8     -19.813  44.084  57.012  1.00 34.66           O  
ATOM     97  CB  ASN A   8     -16.929  43.363  57.728  1.00 39.34           C  
ATOM     98  CG  ASN A   8     -15.391  43.172  57.523  1.00 49.26           C  
ATOM     99  OD1 ASN A   8     -14.933  42.353  56.702  1.00 52.04           O  
ATOM    100  ND2 ASN A   8     -14.596  43.925  58.301  1.00 55.47           N  
ATOM    101  N   ASN A   9     -19.884  41.866  56.699  1.00 37.41           N  
ATOM    102  CA  ASN A   9     -21.318  41.723  56.876  1.00 36.27           C  
ATOM    103  C   ASN A   9     -21.543  40.240  57.202  1.00 36.17           C  
ATOM    104  O   ASN A   9     -21.389  39.403  56.318  1.00 33.70           O  
ATOM    105  CB  ASN A   9     -22.022  42.175  55.573  1.00 36.84           C  
ATOM    106  CG  ASN A   9     -23.535  42.016  55.617  1.00 38.78           C  
ATOM    107  OD1 ASN A   9     -24.041  41.043  56.162  1.00 38.01           O  
ATOM    108  ND2 ASN A   9     -24.265  42.975  55.023  1.00 35.46           N  
ATOM    109  N   PRO A  10     -21.900  39.904  58.470  1.00 36.76           N  
ATOM    110  CA  PRO A  10     -22.048  38.479  58.841  1.00 36.82           C  
ATOM    111  C   PRO A  10     -23.137  37.725  58.061  1.00 36.96           C  
ATOM    112  O   PRO A  10     -23.035  36.514  57.887  1.00 35.55           O  
ATOM    113  CB  PRO A  10     -22.392  38.532  60.340  1.00 37.68           C  
ATOM    114  CG  PRO A  10     -23.009  39.888  60.557  1.00 36.54           C  
ATOM    115  CD  PRO A  10     -22.248  40.793  59.601  1.00 38.33           C  
ATOM    116  N   TYR A  11     -24.154  38.439  57.583  0.50 37.95           N  
ATOM    118  CA  TYR A  11     -25.232  37.819  56.816  0.50 39.20           C  
ATOM    120  C   TYR A  11     -24.693  37.412  55.447  0.50 38.77           C  
ATOM    122  O   TYR A  11     -24.878  36.268  55.013  0.50 37.75           O  
ATOM    124  CB  TYR A  11     -26.456  38.749  56.737  0.50 40.48           C  
ATOM    126  CG  TYR A  11     -26.949  39.121  58.120  0.50 42.85           C  
ATOM    128  CD1 TYR A  11     -27.824  38.291  58.821  0.50 48.01           C  
ATOM    130  CD2 TYR A  11     -26.495  40.275  58.754  0.50 48.20           C  
ATOM    132  CE1 TYR A  11     -28.253  38.610  60.106  0.50 40.46           C  
ATOM    134  CE2 TYR A  11     -26.916  40.606  60.044  0.50 46.89           C  
ATOM    136  CZ  TYR A  11     -27.792  39.769  60.712  0.50 46.10           C  
ATOM    138  OH  TYR A  11     -28.213  40.105  61.982  0.50 43.93           O  
ATOM    140  N   HIS A  12     -23.973  38.315  54.786  1.00 37.57           N  
ATOM    141  CA  HIS A  12     -23.384  37.971  53.498  1.00 35.81           C  
ATOM    142  C   HIS A  12     -22.293  36.913  53.624  1.00 34.53           C  
ATOM    143  O   HIS A  12     -22.128  36.066  52.735  1.00 33.78           O  
ATOM    144  CB  HIS A  12     -22.765  39.196  52.799  1.00 34.96           C  
ATOM    145  CG  HIS A  12     -23.765  40.192  52.327  1.00 35.62           C  
ATOM    146  ND1 HIS A  12     -23.435  41.506  52.055  1.00 34.45           N  
ATOM    147  CD2 HIS A  12     -25.097  40.079  52.110  1.00 35.31           C  
ATOM    148  CE1 HIS A  12     -24.519  42.145  51.658  1.00 37.65           C  
ATOM    149  NE2 HIS A  12     -25.540  41.306  51.691  1.00 33.65           N  
ATOM    150  N   LEU A  13     -21.538  36.971  54.714  1.00 34.56           N  
ATOM    151  CA  LEU A  13     -20.456  36.028  54.923  1.00 34.32           C  
ATOM    152  C   LEU A  13     -21.018  34.619  55.051  1.00 34.31           C  
ATOM    153  O   LEU A  13     -20.465  33.694  54.487  1.00 36.47           O  
ATOM    154  CB  LEU A  13     -19.602  36.413  56.136  1.00 32.70           C  
ATOM    155  CG  LEU A  13     -18.411  35.483  56.458  1.00 35.13           C  
ATOM    156  CD1 LEU A  13     -17.497  35.288  55.233  1.00 39.94           C  
ATOM    157  CD2 LEU A  13     -17.619  35.977  57.632  1.00 35.72           C  
ATOM    158  N   ALA A  14     -22.126  34.478  55.773  1.00 34.69           N  
ATOM    159  CA  ALA A  14     -22.796  33.180  55.926  1.00 32.77           C  
ATOM    160  C   ALA A  14     -23.246  32.660  54.576  1.00 32.96           C  
ATOM    161  O   ALA A  14     -23.022  31.504  54.250  1.00 33.27           O  
ATOM    162  CB  ALA A  14     -23.969  33.288  56.861  1.00 33.37           C  
ATOM    163  N   GLN A  15     -23.862  33.534  53.790  1.00 33.83           N  
ATOM    164  CA  GLN A  15     -24.320  33.206  52.453  1.00 34.05           C  
ATOM    165  C   GLN A  15     -23.163  32.857  51.525  1.00 33.08           C  
ATOM    166  O   GLN A  15     -23.302  31.983  50.654  1.00 32.85           O  
ATOM    167  CB  GLN A  15     -25.091  34.373  51.856  1.00 32.92           C  
ATOM    168  CG  GLN A  15     -26.400  34.702  52.525  1.00 37.07           C  
ATOM    169  CD  GLN A  15     -26.876  36.103  52.204  1.00 38.07           C  
ATOM    170  OE1 GLN A  15     -26.283  36.803  51.399  1.00 39.33           O  
ATOM    171  NE2 GLN A  15     -27.941  36.520  52.846  1.00 35.75           N  
ATOM    172  N   LEU A  16     -22.039  33.552  51.685  1.00 32.56           N  
ATOM    173  CA  LEU A  16     -20.838  33.266  50.884  1.00 32.86           C  
ATOM    174  C   LEU A  16     -20.310  31.872  51.187  1.00 32.79           C  
ATOM    175  O   LEU A  16     -19.967  31.125  50.283  1.00 35.58           O  
ATOM    176  CB  LEU A  16     -19.746  34.283  51.155  1.00 33.76           C  
ATOM    177  CG  LEU A  16     -18.405  34.112  50.435  1.00 32.45           C  
ATOM    178  CD1 LEU A  16     -18.579  34.066  48.912  1.00 32.56           C  
ATOM    179  CD2 LEU A  16     -17.530  35.264  50.836  1.00 37.80           C  
ATOM    180  N   VAL A  17     -20.229  31.541  52.474  1.00 34.05           N  
ATOM    181  CA  VAL A  17     -19.803  30.210  52.911  1.00 32.65           C  
ATOM    182  C   VAL A  17     -20.705  29.128  52.331  1.00 32.42           C  
ATOM    183  O   VAL A  17     -20.211  28.100  51.860  1.00 32.05           O  
ATOM    184  CB  VAL A  17     -19.726  30.124  54.462  1.00 32.29           C  
ATOM    185  CG1 VAL A  17     -19.479  28.688  54.961  1.00 37.11           C  
ATOM    186  CG2 VAL A  17     -18.640  31.077  54.980  1.00 33.51           C  
ATOM    187  N   ASP A  18     -22.026  29.364  52.317  1.00 34.41           N  
ATOM    188  CA  ASP A  18     -22.975  28.403  51.735  1.00 31.53           C  
ATOM    189  C   ASP A  18     -22.742  28.242  50.236  1.00 31.72           C  
ATOM    190  O   ASP A  18     -22.831  27.147  49.717  1.00 32.45           O  
ATOM    191  CB  ASP A  18     -24.443  28.799  51.990  1.00 32.13           C  
ATOM    192  CG  ASP A  18     -24.861  28.677  53.460  1.00 36.55           C  
ATOM    193  OD1 ASP A  18     -24.293  27.845  54.219  1.00 32.71           O  
ATOM    194  OD2 ASP A  18     -25.820  29.390  53.842  1.00 34.10           O  
ATOM    195  N   LEU A  19     -22.466  29.337  49.550  1.00 33.17           N  
ATOM    196  CA  LEU A  19     -22.182  29.305  48.102  1.00 33.09           C  
ATOM    197  C   LEU A  19     -20.935  28.500  47.800  1.00 31.42           C  
ATOM    198  O   LEU A  19     -20.930  27.637  46.928  1.00 32.79           O  
ATOM    199  CB  LEU A  19     -22.015  30.739  47.574  1.00 32.22           C  
ATOM    200  CG  LEU A  19     -21.460  30.916  46.154  1.00 35.03           C  
ATOM    201  CD1 LEU A  19     -22.390  30.326  45.096  1.00 33.53           C  
ATOM    202  CD2 LEU A  19     -21.254  32.348  45.891  1.00 35.37           C  
ATOM    203  N   ILE A  20     -19.864  28.800  48.532  1.00 30.96           N  
ATOM    204  CA  ILE A  20     -18.589  28.116  48.347  1.00 32.80           C  
ATOM    205  C   ILE A  20     -18.733  26.634  48.638  1.00 31.98           C  
ATOM    206  O   ILE A  20     -18.302  25.804  47.838  1.00 32.45           O  
ATOM    207  CB  ILE A  20     -17.459  28.750  49.204  1.00 29.39           C  
ATOM    208  CG1 ILE A  20     -17.210  30.209  48.777  1.00 35.78           C  
ATOM    209  CG2 ILE A  20     -16.194  27.915  49.101  1.00 34.99           C  
ATOM    210  CD1 ILE A  20     -16.287  30.963  49.692  1.00 37.89           C  
ATOM    211  N   ASN A  21     -19.335  26.306  49.785  1.00 33.15           N  
ATOM    212  CA  ASN A  21     -19.558  24.927  50.168  1.00 32.58           C  
ATOM    213  C   ASN A  21     -20.382  24.177  49.133  1.00 33.49           C  
ATOM    214  O   ASN A  21     -20.091  23.049  48.821  1.00 32.03           O  
ATOM    215  CB  ASN A  21     -20.283  24.843  51.516  1.00 33.92           C  
ATOM    216  CG  ASN A  21     -20.451  23.407  51.987  1.00 33.58           C  
ATOM    217  OD1 ASN A  21     -19.469  22.718  52.256  1.00 34.53           O  
ATOM    218  ND2 ASN A  21     -21.695  22.942  52.051  1.00 33.24           N  
ATOM    219  N   TYR A  22     -21.431  24.813  48.624  1.00 33.35           N  
ATOM    220  CA  TYR A  22     -22.268  24.188  47.624  1.00 33.52           C  
ATOM    221  C   TYR A  22     -21.455  23.808  46.346  1.00 31.71           C  
ATOM    222  O   TYR A  22     -21.469  22.672  45.866  1.00 32.43           O  
ATOM    223  CB  TYR A  22     -23.484  25.090  47.275  1.00 36.02           C  
ATOM    224  CG  TYR A  22     -24.222  24.503  46.105  1.00 35.53           C  
ATOM    225  CD1 TYR A  22     -25.143  23.478  46.287  1.00 41.42           C  
ATOM    226  CD2 TYR A  22     -23.905  24.882  44.802  1.00 43.36           C  
ATOM    227  CE1 TYR A  22     -25.762  22.868  45.201  1.00 37.94           C  
ATOM    228  CE2 TYR A  22     -24.523  24.283  43.717  1.00 38.56           C  
ATOM    229  CZ  TYR A  22     -25.441  23.279  43.929  1.00 39.53           C  
ATOM    230  OH  TYR A  22     -26.042  22.697  42.854  1.00 42.78           O  
ATOM    231  N   CYS A  23     -20.751  24.778  45.797  1.00 33.87           N  
ATOM    232  CA  CYS A  23     -19.999  24.579  44.576  1.00 34.70           C  
ATOM    233  C   CYS A  23     -18.878  23.580  44.736  1.00 34.04           C  
ATOM    234  O   CYS A  23     -18.697  22.725  43.888  1.00 34.24           O  
ATOM    235  CB  CYS A  23     -19.421  25.904  44.091  1.00 35.62           C  
ATOM    236  SG  CYS A  23     -20.657  27.049  43.527  1.00 36.96           S  
ATOM    237  N   GLN A  24     -18.121  23.693  45.824  1.00 36.25           N  
ATOM    238  CA  GLN A  24     -16.996  22.804  46.053  1.00 35.85           C  
ATOM    239  C   GLN A  24     -17.389  21.418  46.484  1.00 36.06           C  
ATOM    240  O   GLN A  24     -16.833  20.437  45.999  1.00 33.93           O  
ATOM    241  CB  GLN A  24     -16.069  23.368  47.128  1.00 34.86           C  
ATOM    242  CG  GLN A  24     -15.349  24.646  46.719  1.00 40.26           C  
ATOM    243  CD  GLN A  24     -14.430  25.200  47.796  1.00 35.67           C  
ATOM    244  OE1 GLN A  24     -14.682  25.051  49.005  1.00 34.57           O  
ATOM    245  NE2 GLN A  24     -13.365  25.878  47.358  1.00 34.59           N  
ATOM    246  N   ASN A  25     -18.355  21.345  47.393  1.00 36.08           N  
ATOM    247  CA  ASN A  25     -18.619  20.099  48.093  1.00 35.64           C  
ATOM    248  C   ASN A  25     -19.916  19.374  47.839  1.00 38.10           C  
ATOM    249  O   ASN A  25     -19.974  18.167  48.049  1.00 41.32           O  
ATOM    250  CB  ASN A  25     -18.473  20.343  49.584  1.00 34.30           C  
ATOM    251  CG  ASN A  25     -17.079  20.806  49.962  1.00 38.55           C  
ATOM    252  OD1 ASN A  25     -16.104  20.281  49.457  1.00 34.97           O  
ATOM    253  ND2 ASN A  25     -16.983  21.793  50.862  1.00 34.67           N  
ATOM    254  N   ILE A  26     -20.954  20.097  47.441  1.00 36.62           N  
ATOM    255  CA  ILE A  26     -22.235  19.468  47.135  1.00 37.67           C  
ATOM    256  C   ILE A  26     -22.282  19.183  45.642  1.00 36.87           C  
ATOM    257  O   ILE A  26     -22.553  18.065  45.223  1.00 36.42           O  
ATOM    258  CB  ILE A  26     -23.427  20.339  47.594  1.00 35.59           C  
ATOM    259  CG1 ILE A  26     -23.373  20.473  49.129  1.00 37.97           C  
ATOM    260  CG2 ILE A  26     -24.758  19.683  47.141  1.00 37.71           C  
ATOM    261  CD1 ILE A  26     -24.386  21.392  49.703  1.00 43.50           C  
ATOM    262  N   GLU A  27     -21.957  20.193  44.845  1.00 35.82           N  
ATOM    263  CA  GLU A  27     -21.973  20.064  43.398  1.00 34.97           C  
ATOM    264  C   GLU A  27     -20.745  19.345  42.852  1.00 35.49           C  
ATOM    265  O   GLU A  27     -20.896  18.366  42.142  1.00 36.98           O  
ATOM    266  CB  GLU A  27     -22.102  21.441  42.752  1.00 35.57           C  
ATOM    267  CG  GLU A  27     -22.315  21.374  41.260  1.00 35.20           C  
ATOM    268  CD  GLU A  27     -22.347  22.723  40.600  1.00 37.51           C  
ATOM    269  OE1 GLU A  27     -21.695  23.674  41.071  1.00 38.67           O  
ATOM    270  OE2 GLU A  27     -23.010  22.802  39.568  1.00 39.50           O  
ATOM    271  N   ALA A  28     -19.544  19.804  43.187  1.00 39.30           N  
ATOM    272  CA  ALA A  28     -18.303  19.196  42.679  1.00 40.25           C  
ATOM    273  C   ALA A  28     -17.705  18.086  43.558  1.00 44.64           C  
ATOM    274  O   ALA A  28     -16.759  17.430  43.122  1.00 47.04           O  
ATOM    275  CB  ALA A  28     -17.261  20.257  42.418  1.00 40.35           C  
ATOM    276  N   LYS A  29     -18.211  17.869  44.772  1.00 44.05           N  
ATOM    277  CA  LYS A  29     -17.718  16.768  45.616  1.00 45.85           C  
ATOM    278  C   LYS A  29     -16.184  16.767  45.839  1.00 44.75           C  
ATOM    279  O   LYS A  29     -15.559  15.704  45.842  1.00 45.91           O  
ATOM    280  CB  LYS A  29     -18.087  15.419  44.985  1.00 47.87           C  
ATOM    281  CG  LYS A  29     -19.489  15.282  44.382  1.00 54.26           C  
ATOM    282  CD  LYS A  29     -20.547  14.911  45.370  1.00 58.41           C  
ATOM    283  CE  LYS A  29     -21.823  14.568  44.619  1.00 63.68           C  
ATOM    284  NZ  LYS A  29     -22.800  13.851  45.484  1.00 73.08           N  
ATOM    285  N   LEU A  30     -15.587  17.942  46.031  1.00 43.35           N  
ATOM    286  CA  LEU A  30     -14.151  18.072  46.204  1.00 41.93           C  
ATOM    287  C   LEU A  30     -13.670  17.908  47.640  1.00 42.81           C  
ATOM    288  O   LEU A  30     -12.471  17.809  47.873  1.00 43.74           O  
ATOM    289  CB  LEU A  30     -13.688  19.430  45.695  1.00 42.70           C  
ATOM    290  CG  LEU A  30     -13.984  19.739  44.223  1.00 41.38           C  
ATOM    291  CD1 LEU A  30     -13.767  21.214  43.945  1.00 45.54           C  
ATOM    292  CD2 LEU A  30     -13.141  18.882  43.304  1.00 44.45           C  
ATOM    293  N   ASP A  31     -14.593  17.899  48.593  1.00 41.66           N  
ATOM    294  CA  ASP A  31     -14.264  17.766  50.018  1.00 43.54           C  
ATOM    295  C   ASP A  31     -13.204  18.781  50.483  1.00 40.76           C  
ATOM    296  O   ASP A  31     -12.189  18.421  51.063  1.00 41.68           O  
ATOM    297  CB  ASP A  31     -13.853  16.314  50.339  1.00 45.69           C  
ATOM    298  CG  ASP A  31     -13.696  16.062  51.835  1.00 53.25           C  
ATOM    299  OD1 ASP A  31     -14.433  16.696  52.633  1.00 60.46           O  
ATOM    300  OD2 ASP A  31     -12.828  15.228  52.212  1.00 63.08           O  
ATOM    301  N   ILE A  32     -13.457  20.058  50.217  1.00 36.30           N  
ATOM    302  CA  ILE A  32     -12.559  21.122  50.628  1.00 35.88           C  
ATOM    303  C   ILE A  32     -13.065  21.689  51.948  1.00 34.91           C  
ATOM    304  O   ILE A  32     -14.237  22.023  52.084  1.00 34.34           O  
ATOM    305  CB  ILE A  32     -12.441  22.249  49.572  1.00 35.26           C  
ATOM    306  CG1 ILE A  32     -11.868  21.689  48.270  1.00 37.43           C  
ATOM    307  CG2 ILE A  32     -11.555  23.379  50.099  1.00 40.69           C  
ATOM    308  CD1 ILE A  32     -11.922  22.664  47.086  1.00 37.66           C  
ATOM    309  N   LYS A  33     -12.177  21.795  52.927  1.00 34.03           N  
ATOM    310  CA  LYS A  33     -12.540  22.344  54.231  1.00 34.63           C  
ATOM    311  C   LYS A  33     -12.365  23.849  54.207  1.00 34.86           C  
ATOM    312  O   LYS A  33     -11.501  24.378  53.487  1.00 34.35           O  
ATOM    313  CB  LYS A  33     -11.663  21.749  55.336  1.00 34.29           C  
ATOM    314  CG  LYS A  33     -11.610  20.239  55.431  1.00 43.67           C  
ATOM    315  CD  LYS A  33     -12.958  19.576  55.599  1.00 52.17           C  
ATOM    316  CE  LYS A  33     -12.789  18.035  55.594  1.00 56.72           C  
HETATM  317  N   MSE A  34     -13.172  24.550  54.998  1.00 33.83           N  
HETATM  318  CA  MSE A  34     -13.069  25.991  55.108  1.00 33.55           C  
HETATM  319  C   MSE A  34     -11.707  26.376  55.741  1.00 33.47           C  
HETATM  320  O   MSE A  34     -11.159  27.432  55.429  1.00 34.22           O  
HETATM  321  CB  MSE A  34     -14.231  26.567  55.929  1.00 34.31           C  
HETATM  322  CG  MSE A  34     -15.600  26.351  55.275  1.00 39.29           C  
HETATM  323 SE   MSE A  34     -15.681  27.308  53.584  0.75 44.57          SE  
HETATM  324  CE  MSE A  34     -16.375  26.133  52.674  1.00 39.23           C  
ATOM    325  N   ALA A  35     -11.157  25.513  56.598  1.00 34.71           N  
ATOM    326  CA  ALA A  35      -9.829  25.733  57.192  1.00 34.81           C  
ATOM    327  C   ALA A  35      -8.726  25.758  56.119  1.00 35.72           C  
ATOM    328  O   ALA A  35      -7.670  26.338  56.350  1.00 39.02           O  
ATOM    329  CB  ALA A  35      -9.513  24.688  58.248  1.00 37.16           C  
ATOM    330  N   GLU A  36      -8.976  25.142  54.959  0.50 33.89           N  
ATOM    332  CA  GLU A  36      -8.034  25.161  53.843  0.50 35.52           C  
ATOM    334  C   GLU A  36      -8.126  26.452  53.037  0.50 35.66           C  
ATOM    336  O   GLU A  36      -7.345  26.646  52.108  0.50 35.62           O  
ATOM    338  CB  GLU A  36      -8.279  23.994  52.874  0.50 36.20           C  
ATOM    340  CG  GLU A  36      -8.151  22.609  53.461  0.50 37.96           C  
ATOM    342  CD  GLU A  36      -8.512  21.535  52.445  0.50 39.72           C  
ATOM    344  OE1 GLU A  36      -7.909  21.518  51.346  0.50 42.10           O  
ATOM    346  OE2 GLU A  36      -9.395  20.702  52.754  0.50 43.37           O  
ATOM    348  N   GLN A  37      -9.069  27.331  53.378  1.00 35.57           N  
ATOM    349  CA  GLN A  37      -9.253  28.587  52.661  1.00 37.39           C  
ATOM    350  C   GLN A  37      -9.788  29.613  53.636  1.00 35.10           C  
ATOM    351  O   GLN A  37     -10.801  30.268  53.401  1.00 37.22           O  
ATOM    352  CB  GLN A  37     -10.180  28.388  51.464  1.00 38.10           C  
ATOM    353  CG  GLN A  37     -11.463  27.640  51.824  1.00 40.05           C  
ATOM    354  CD  GLN A  37     -12.274  27.183  50.642  1.00 40.88           C  
ATOM    355  OE1 GLN A  37     -11.905  27.409  49.488  1.00 41.78           O  
ATOM    356  NE2 GLN A  37     -13.417  26.538  50.932  1.00 36.80           N  
ATOM    357  N   ASP A  38      -9.056  29.775  54.728  1.00 35.15           N  
ATOM    358  CA  ASP A  38      -9.469  30.691  55.798  1.00 35.77           C  
ATOM    359  C   ASP A  38      -9.371  32.191  55.421  1.00 34.64           C  
ATOM    360  O   ASP A  38      -9.835  33.038  56.172  1.00 33.76           O  
ATOM    361  CB  ASP A  38      -8.758  30.354  57.111  1.00 36.65           C  
ATOM    362  CG  ASP A  38      -7.237  30.443  56.996  1.00 43.01           C  
ATOM    363  OD1 ASP A  38      -6.746  31.461  56.477  1.00 49.39           O  
ATOM    364  OD2 ASP A  38      -6.551  29.497  57.405  1.00 56.48           O  
ATOM    365  N   ASP A  39      -8.777  32.503  54.262  1.00 34.50           N  
ATOM    366  CA  ASP A  39      -8.814  33.864  53.677  1.00 36.38           C  
ATOM    367  C   ASP A  39     -10.274  34.417  53.558  1.00 35.66           C  
ATOM    368  O   ASP A  39     -10.516  35.626  53.596  1.00 34.51           O  
ATOM    369  CB  ASP A  39      -8.143  33.890  52.282  1.00 36.97           C  
ATOM    370  CG  ASP A  39      -8.597  32.728  51.357  1.00 35.22           C  
ATOM    371  OD1 ASP A  39      -8.167  31.574  51.603  1.00 38.86           O  
ATOM    372  OD2 ASP A  39      -9.324  32.957  50.371  1.00 39.88           O  
ATOM    373  N   ILE A  40     -11.230  33.506  53.437  1.00 36.49           N  
ATOM    374  CA  ILE A  40     -12.677  33.809  53.379  1.00 37.41           C  
ATOM    375  C   ILE A  40     -13.155  34.546  54.637  1.00 34.49           C  
ATOM    376  O   ILE A  40     -14.087  35.350  54.572  1.00 36.09           O  
ATOM    377  CB  ILE A  40     -13.494  32.466  53.173  1.00 40.18           C  
ATOM    378  CG1 ILE A  40     -13.196  31.869  51.785  1.00 45.79           C  
ATOM    379  CG2 ILE A  40     -14.972  32.642  53.360  1.00 46.71           C  
ATOM    380  CD1 ILE A  40     -13.354  32.817  50.658  1.00 52.70           C  
ATOM    381  N   PHE A  41     -12.494  34.281  55.761  1.00 35.76           N  
ATOM    382  CA  PHE A  41     -12.829  34.870  57.066  1.00 36.64           C  
ATOM    383  C   PHE A  41     -11.997  36.121  57.408  1.00 36.46           C  
ATOM    384  O   PHE A  41     -12.138  36.706  58.477  1.00 35.45           O  
ATOM    385  CB  PHE A  41     -12.750  33.767  58.152  1.00 35.79           C  
ATOM    386  CG  PHE A  41     -13.613  32.585  57.825  1.00 33.77           C  
ATOM    387  CD1 PHE A  41     -14.982  32.645  57.992  1.00 41.89           C  
ATOM    388  CD2 PHE A  41     -13.080  31.462  57.241  1.00 34.57           C  
ATOM    389  CE1 PHE A  41     -15.792  31.591  57.629  1.00 40.80           C  
ATOM    390  CE2 PHE A  41     -13.896  30.394  56.872  1.00 37.00           C  
ATOM    391  CZ  PHE A  41     -15.254  30.462  57.062  1.00 38.20           C  
ATOM    392  N   GLN A  42     -11.154  36.544  56.469  1.00 37.01           N  
ATOM    393  CA  GLN A  42     -10.315  37.727  56.631  1.00 35.53           C  
ATOM    394  C   GLN A  42     -10.119  38.357  55.261  1.00 32.61           C  
ATOM    395  O   GLN A  42      -8.997  38.647  54.865  1.00 31.71           O  
ATOM    396  CB  GLN A  42      -8.978  37.356  57.275  1.00 35.88           C  
ATOM    397  CG  GLN A  42      -8.221  36.212  56.605  1.00 38.18           C  
ATOM    398  CD  GLN A  42      -7.037  35.711  57.446  1.00 38.90           C  
ATOM    399  OE1 GLN A  42      -6.304  36.502  57.998  1.00 45.83           O  
ATOM    400  NE2 GLN A  42      -6.859  34.390  57.525  1.00 44.12           N  
ATOM    401  N   ILE A  43     -11.226  38.573  54.554  1.00 33.02           N  
ATOM    402  CA  ILE A  43     -11.193  39.105  53.181  1.00 34.42           C  
ATOM    403  C   ILE A  43     -10.515  40.461  53.088  1.00 35.91           C  
ATOM    404  O   ILE A  43      -9.711  40.679  52.182  1.00 33.86           O  
ATOM    405  CB  ILE A  43     -12.604  39.138  52.539  1.00 35.06           C  
ATOM    406  CG1 ILE A  43     -13.042  37.704  52.218  1.00 34.18           C  
ATOM    407  CG2 ILE A  43     -12.616  39.984  51.285  1.00 35.20           C  
ATOM    408  CD1 ILE A  43     -14.496  37.549  51.858  1.00 37.02           C  
ATOM    409  N   GLU A  44     -10.831  41.364  54.020  1.00 36.02           N  
ATOM    410  CA  GLU A  44     -10.253  42.703  54.009  1.00 39.85           C  
ATOM    411  C   GLU A  44      -8.724  42.678  54.120  1.00 37.34           C  
ATOM    412  O   GLU A  44      -8.034  43.325  53.353  1.00 39.20           O  
ATOM    413  CB  GLU A  44     -10.891  43.584  55.096  1.00 38.29           C  
ATOM    414  CG  GLU A  44     -10.426  45.040  55.084  1.00 49.64           C  
ATOM    415  CD  GLU A  44     -11.112  45.930  56.137  1.00 49.26           C  
ATOM    416  OE1 GLU A  44     -12.070  45.473  56.806  1.00 61.60           O  
ATOM    417  OE2 GLU A  44     -10.679  47.101  56.279  1.00 64.66           O  
ATOM    418  N   ASN A  45      -8.197  41.912  55.055  1.00 37.00           N  
ATOM    419  CA  ASN A  45      -6.760  41.845  55.229  1.00 38.27           C  
ATOM    420  C   ASN A  45      -6.039  41.044  54.172  1.00 36.42           C  
ATOM    421  O   ASN A  45      -4.950  41.402  53.780  1.00 37.27           O  
ATOM    422  CB  ASN A  45      -6.416  41.259  56.595  1.00 38.63           C  
ATOM    423  CG  ASN A  45      -6.747  42.204  57.735  1.00 46.26           C  
ATOM    424  OD1 ASN A  45      -7.186  43.335  57.523  1.00 56.38           O  
ATOM    425  ND2 ASN A  45      -6.526  41.744  58.956  1.00 55.07           N  
ATOM    426  N   TYR A  46      -6.656  39.963  53.710  1.00 37.41           N  
ATOM    427  CA  TYR A  46      -6.005  39.055  52.784  1.00 35.76           C  
ATOM    428  C   TYR A  46      -6.048  39.588  51.366  1.00 35.11           C  
ATOM    429  O   TYR A  46      -5.057  39.535  50.662  1.00 32.17           O  
ATOM    430  CB  TYR A  46      -6.651  37.682  52.896  1.00 37.66           C  
ATOM    431  CG  TYR A  46      -5.938  36.574  52.170  1.00 36.33           C  
ATOM    432  CD1 TYR A  46      -6.163  36.354  50.808  1.00 39.47           C  
ATOM    433  CD2 TYR A  46      -5.083  35.710  52.853  1.00 40.17           C  
ATOM    434  CE1 TYR A  46      -5.547  35.333  50.144  1.00 42.73           C  
ATOM    435  CE2 TYR A  46      -4.439  34.687  52.180  1.00 39.02           C  
ATOM    436  CZ  TYR A  46      -4.681  34.509  50.836  1.00 41.90           C  
ATOM    437  OH  TYR A  46      -4.074  33.496  50.145  1.00 51.96           O  
ATOM    438  N   TYR A  47      -7.201  40.101  50.946  1.00 35.20           N  
ATOM    439  CA  TYR A  47      -7.369  40.604  49.581  1.00 33.76           C  
ATOM    440  C   TYR A  47      -7.286  42.119  49.479  1.00 34.24           C  
ATOM    441  O   TYR A  47      -6.391  42.659  48.844  1.00 32.10           O  
ATOM    442  CB  TYR A  47      -8.728  40.147  48.988  1.00 33.61           C  
ATOM    443  CG  TYR A  47      -8.836  38.655  48.808  1.00 31.42           C  
ATOM    444  CD1 TYR A  47      -8.298  38.035  47.699  1.00 27.66           C  
ATOM    445  CD2 TYR A  47      -9.427  37.861  49.773  1.00 32.36           C  
ATOM    446  CE1 TYR A  47      -8.378  36.652  47.529  1.00 33.72           C  
ATOM    447  CE2 TYR A  47      -9.520  36.487  49.613  1.00 33.35           C  
ATOM    448  CZ  TYR A  47      -8.989  35.892  48.486  1.00 35.82           C  
ATOM    449  OH  TYR A  47      -9.061  34.527  48.356  1.00 39.52           O  
ATOM    450  N   GLN A  48      -8.216  42.788  50.149  1.00 33.66           N  
ATOM    451  CA  GLN A  48      -8.429  44.216  49.964  1.00 33.64           C  
ATOM    452  C   GLN A  48      -7.320  45.146  50.432  1.00 33.13           C  
ATOM    453  O   GLN A  48      -7.050  46.131  49.769  1.00 33.03           O  
ATOM    454  CB  GLN A  48      -9.790  44.605  50.550  1.00 32.50           C  
ATOM    455  CG  GLN A  48     -10.940  43.880  49.841  1.00 32.08           C  
ATOM    456  CD  GLN A  48     -12.282  44.093  50.510  1.00 35.01           C  
ATOM    457  OE1 GLN A  48     -12.372  44.138  51.741  1.00 37.20           O  
ATOM    458  NE2 GLN A  48     -13.336  44.196  49.704  1.00 31.66           N  
ATOM    459  N   ASN A  49      -6.679  44.828  51.552  1.00 34.88           N  
ATOM    460  CA  ASN A  49      -5.590  45.640  52.069  1.00 35.70           C  
ATOM    461  C   ASN A  49      -4.261  45.363  51.381  1.00 35.44           C  
ATOM    462  O   ASN A  49      -3.293  46.062  51.637  1.00 37.15           O  
ATOM    463  CB  ASN A  49      -5.447  45.462  53.587  1.00 36.76           C  
ATOM    464  CG  ASN A  49      -6.633  46.040  54.360  1.00 41.53           C  
ATOM    465  OD1 ASN A  49      -7.450  46.795  53.818  1.00 42.07           O  
ATOM    466  ND2 ASN A  49      -6.717  45.699  55.639  1.00 47.97           N  
ATOM    467  N   ARG A  50      -4.212  44.358  50.509  1.00 34.20           N  
ATOM    468  CA  ARG A  50      -2.985  44.020  49.801  1.00 33.69           C  
ATOM    469  C   ARG A  50      -3.133  44.167  48.294  1.00 32.07           C  
ATOM    470  O   ARG A  50      -2.648  43.336  47.550  1.00 33.73           O  
ATOM    471  CB  ARG A  50      -2.556  42.595  50.167  1.00 34.26           C  
ATOM    472  CG  ARG A  50      -2.337  42.395  51.668  1.00 35.03           C  
ATOM    473  CD  ARG A  50      -1.595  41.095  51.933  1.00 37.96           C  
ATOM    474  NE  ARG A  50      -2.361  39.920  51.512  1.00 45.91           N  
ATOM    475  CZ  ARG A  50      -1.866  38.682  51.389  1.00 49.96           C  
ATOM    476  NH1 ARG A  50      -0.589  38.423  51.653  1.00 54.39           N  
ATOM    477  NH2 ARG A  50      -2.651  37.679  50.995  1.00 42.06           N  
ATOM    478  N   LYS A  51      -3.811  45.232  47.858  1.00 32.53           N  
ATOM    479  CA  LYS A  51      -3.997  45.571  46.436  1.00 32.30           C  
ATOM    480  C   LYS A  51      -4.756  44.525  45.605  1.00 32.77           C  
ATOM    481  O   LYS A  51      -4.653  44.479  44.367  1.00 30.98           O  
ATOM    482  CB  LYS A  51      -2.652  45.918  45.794  1.00 34.41           C  
ATOM    483  CG  LYS A  51      -1.973  47.100  46.458  1.00 35.29           C  
ATOM    484  CD  LYS A  51      -0.578  47.310  45.905  1.00 41.36           C  
ATOM    485  CE  LYS A  51       0.150  48.392  46.657  1.00 45.41           C  
ATOM    486  NZ  LYS A  51       1.613  48.383  46.325  1.00 50.07           N  
ATOM    487  N   GLY A  52      -5.535  43.697  46.297  1.00 30.18           N  
ATOM    488  CA  GLY A  52      -6.362  42.714  45.650  1.00 30.95           C  
ATOM    489  C   GLY A  52      -7.792  43.177  45.854  1.00 31.52           C  
ATOM    490  O   GLY A  52      -8.043  44.309  46.255  1.00 29.34           O  
ATOM    491  N   GLN A  53      -8.736  42.298  45.593  1.00 31.18           N  
ATOM    492  CA  GLN A  53     -10.116  42.662  45.746  1.00 33.18           C  
ATOM    493  C   GLN A  53     -10.948  41.389  45.812  1.00 32.90           C  
ATOM    494  O   GLN A  53     -10.471  40.298  45.471  1.00 32.56           O  
ATOM    495  CB  GLN A  53     -10.516  43.637  44.617  1.00 33.28           C  
ATOM    496  CG  GLN A  53     -11.848  44.334  44.788  1.00 39.38           C  
ATOM    497  CD  GLN A  53     -12.018  44.930  46.158  1.00 35.26           C  
ATOM    498  OE1 GLN A  53     -12.598  44.298  47.044  1.00 33.50           O  
ATOM    499  NE2 GLN A  53     -11.471  46.107  46.363  1.00 32.68           N  
ATOM    500  N   PHE A  54     -12.156  41.521  46.345  1.00 35.48           N  
ATOM    501  CA  PHE A  54     -13.084  40.415  46.488  1.00 33.75           C  
ATOM    502  C   PHE A  54     -14.466  40.965  46.172  1.00 34.29           C  
ATOM    503  O   PHE A  54     -14.902  41.925  46.794  1.00 34.11           O  
ATOM    504  CB  PHE A  54     -13.039  39.826  47.904  1.00 35.23           C  
ATOM    505  CG  PHE A  54     -13.637  38.437  48.010  1.00 33.02           C  
ATOM    506  CD1 PHE A  54     -15.006  38.230  47.890  1.00 35.15           C  
ATOM    507  CD2 PHE A  54     -12.828  37.335  48.244  1.00 34.88           C  
ATOM    508  CE1 PHE A  54     -15.544  36.943  47.975  1.00 35.31           C  
ATOM    509  CE2 PHE A  54     -13.353  36.071  48.340  1.00 32.91           C  
ATOM    510  CZ  PHE A  54     -14.719  35.870  48.189  1.00 35.35           C  
ATOM    511  N   TRP A  55     -15.152  40.359  45.198  1.00 34.04           N  
ATOM    512  CA  TRP A  55     -16.486  40.801  44.820  1.00 34.07           C  
ATOM    513  C   TRP A  55     -17.553  39.760  45.106  1.00 34.25           C  
ATOM    514  O   TRP A  55     -17.332  38.563  44.962  1.00 34.91           O  
ATOM    515  CB  TRP A  55     -16.570  41.125  43.325  1.00 34.29           C  
ATOM    516  CG  TRP A  55     -15.665  42.235  42.845  1.00 35.64           C  
ATOM    517  CD1 TRP A  55     -15.976  43.557  42.736  1.00 36.48           C  
ATOM    518  CD2 TRP A  55     -14.304  42.107  42.404  1.00 35.14           C  
ATOM    519  NE1 TRP A  55     -14.909  44.254  42.248  1.00 36.19           N  
ATOM    520  CE2 TRP A  55     -13.869  43.394  42.030  1.00 36.16           C  
ATOM    521  CE3 TRP A  55     -13.414  41.023  42.281  1.00 31.66           C  
ATOM    522  CZ2 TRP A  55     -12.583  43.638  41.544  1.00 33.82           C  
ATOM    523  CZ3 TRP A  55     -12.153  41.256  41.789  1.00 33.64           C  
ATOM    524  CH2 TRP A  55     -11.742  42.562  41.428  1.00 36.34           C  
ATOM    525  N   ILE A  56     -18.729  40.245  45.461  1.00 33.66           N  
ATOM    526  CA  ILE A  56     -19.886  39.384  45.622  1.00 34.73           C  
ATOM    527  C   ILE A  56     -21.023  39.844  44.692  1.00 33.15           C  
ATOM    528  O   ILE A  56     -21.239  41.038  44.498  1.00 31.77           O  
ATOM    529  CB  ILE A  56     -20.390  39.296  47.099  1.00 33.05           C  
ATOM    530  CG1 ILE A  56     -20.625  40.709  47.676  1.00 34.47           C  
ATOM    531  CG2 ILE A  56     -19.430  38.456  47.949  1.00 34.16           C  
ATOM    532  CD1 ILE A  56     -21.194  40.728  49.082  1.00 40.24           C  
ATOM    533  N   ALA A  57     -21.721  38.872  44.102  1.00 34.31           N  
ATOM    534  CA  ALA A  57     -22.915  39.140  43.313  1.00 34.01           C  
ATOM    535  C   ALA A  57     -24.077  38.914  44.244  1.00 34.71           C  
ATOM    536  O   ALA A  57     -24.153  37.875  44.918  1.00 35.17           O  
ATOM    537  CB  ALA A  57     -23.028  38.205  42.137  1.00 33.50           C  
ATOM    538  N   LEU A  58     -25.001  39.861  44.252  1.00 36.53           N  
ATOM    539  CA  LEU A  58     -26.175  39.795  45.094  1.00 38.48           C  
ATOM    540  C   LEU A  58     -27.452  39.804  44.264  1.00 40.58           C  
ATOM    541  O   LEU A  58     -27.578  40.606  43.349  1.00 41.19           O  
ATOM    542  CB  LEU A  58     -26.185  41.009  46.013  1.00 40.65           C  
ATOM    543  CG  LEU A  58     -24.962  41.164  46.915  1.00 39.15           C  
ATOM    544  CD1 LEU A  58     -24.804  42.574  47.385  1.00 41.03           C  
ATOM    545  CD2 LEU A  58     -25.072  40.230  48.080  1.00 42.08           C  
ATOM    546  N   GLU A  59     -28.348  38.865  44.523  1.00 42.00           N  
ATOM    547  CA  GLU A  59     -29.677  38.909  43.946  1.00 43.23           C  
ATOM    548  C   GLU A  59     -30.604  39.056  45.134  1.00 44.17           C  
ATOM    549  O   GLU A  59     -30.675  38.161  45.998  1.00 42.12           O  
ATOM    550  CB  GLU A  59     -30.066  37.679  43.161  1.00 43.46           C  
ATOM    551  CG  GLU A  59     -31.348  37.977  42.357  1.00 52.15           C  
ATOM    552  CD  GLU A  59     -32.027  36.751  41.836  1.00 61.17           C  
ATOM    553  OE1 GLU A  59     -31.908  35.680  42.470  1.00 62.77           O  
ATOM    554  OE2 GLU A  59     -32.711  36.872  40.802  1.00 72.69           O  
ATOM    555  N   ASN A  60     -31.291  40.199  45.176  1.00 48.08           N  
ATOM    556  CA  ASN A  60     -32.184  40.538  46.271  1.00 50.08           C  
ATOM    557  C   ASN A  60     -31.427  40.492  47.588  1.00 49.86           C  
ATOM    558  O   ASN A  60     -31.883  39.917  48.570  1.00 49.39           O  
ATOM    559  CB  ASN A  60     -33.413  39.628  46.260  1.00 50.40           C  
ATOM    560  CG  ASN A  60     -34.190  39.736  44.955  1.00 56.71           C  
ATOM    561  OD1 ASN A  60     -34.166  40.776  44.280  1.00 56.69           O  
ATOM    562  ND2 ASN A  60     -34.889  38.664  44.598  1.00 62.90           N  
ATOM    563  N   GLU A  61     -30.245  41.102  47.569  1.00 51.84           N  
ATOM    564  CA  GLU A  61     -29.349  41.175  48.729  1.00 54.66           C  
ATOM    565  C   GLU A  61     -28.869  39.834  49.331  1.00 53.54           C  
ATOM    566  O   GLU A  61     -28.399  39.793  50.478  1.00 57.82           O  
ATOM    567  CB  GLU A  61     -29.943  42.106  49.794  1.00 55.50           C  
ATOM    568  CG  GLU A  61     -30.017  43.577  49.331  1.00 62.23           C  
ATOM    569  CD  GLU A  61     -28.637  44.226  49.162  1.00 71.11           C  
ATOM    570  OE1 GLU A  61     -27.668  43.794  49.849  1.00 73.35           O  
ATOM    571  OE2 GLU A  61     -28.537  45.176  48.352  1.00 73.43           O  
ATOM    572  N   LYS A  62     -28.951  38.765  48.534  1.00 49.70           N  
ATOM    573  CA  LYS A  62     -28.430  37.455  48.901  1.00 45.29           C  
ATOM    574  C   LYS A  62     -27.264  37.117  47.955  1.00 39.51           C  
ATOM    575  O   LYS A  62     -27.338  37.326  46.745  1.00 37.02           O  
ATOM    576  CB  LYS A  62     -29.536  36.387  48.900  1.00 45.59           C  
ATOM    577  CG  LYS A  62     -30.685  36.732  49.882  1.00 51.78           C  
ATOM    578  CD  LYS A  62     -31.605  35.552  50.230  1.00 51.83           C  
ATOM    579  N   VAL A  63     -26.171  36.631  48.530  1.00 38.88           N  
ATOM    580  CA  VAL A  63     -24.958  36.309  47.775  1.00 38.00           C  
ATOM    581  C   VAL A  63     -25.227  35.085  46.895  1.00 36.01           C  
ATOM    582  O   VAL A  63     -25.607  34.034  47.387  1.00 36.82           O  
ATOM    583  CB  VAL A  63     -23.762  36.018  48.690  1.00 36.42           C  
ATOM    584  CG1 VAL A  63     -22.553  35.540  47.881  1.00 35.55           C  
ATOM    585  CG2 VAL A  63     -23.386  37.242  49.519  1.00 38.42           C  
ATOM    586  N   VAL A  64     -25.040  35.261  45.595  1.00 35.51           N  
ATOM    587  CA  VAL A  64     -25.242  34.198  44.618  1.00 33.56           C  
ATOM    588  C   VAL A  64     -24.025  33.955  43.707  1.00 33.93           C  
ATOM    589  O   VAL A  64     -24.025  33.011  42.915  1.00 33.49           O  
ATOM    590  CB  VAL A  64     -26.534  34.406  43.794  1.00 33.18           C  
ATOM    591  CG1 VAL A  64     -27.753  34.305  44.702  1.00 33.53           C  
ATOM    592  CG2 VAL A  64     -26.534  35.727  43.031  1.00 34.35           C  
ATOM    593  N   GLY A  65     -22.972  34.752  43.872  1.00 35.20           N  
ATOM    594  CA  GLY A  65     -21.754  34.596  43.112  1.00 35.78           C  
ATOM    595  C   GLY A  65     -20.626  35.330  43.795  1.00 36.63           C  
ATOM    596  O   GLY A  65     -20.867  36.210  44.641  1.00 33.37           O  
ATOM    597  N   SER A  66     -19.398  34.943  43.457  1.00 36.09           N  
ATOM    598  CA  SER A  66     -18.218  35.589  43.998  1.00 33.50           C  
ATOM    599  C   SER A  66     -17.051  35.470  43.034  1.00 33.09           C  
ATOM    600  O   SER A  66     -17.014  34.570  42.188  1.00 32.43           O  
ATOM    601  CB  SER A  66     -17.839  34.972  45.366  1.00 34.95           C  
ATOM    602  OG  SER A  66     -17.398  33.623  45.275  1.00 33.74           O  
ATOM    603  N   ILE A  67     -16.112  36.408  43.143  1.00 35.02           N  
ATOM    604  CA  ILE A  67     -14.835  36.319  42.455  1.00 32.66           C  
ATOM    605  C   ILE A  67     -13.825  37.184  43.236  1.00 34.13           C  
ATOM    606  O   ILE A  67     -14.202  38.148  43.875  1.00 33.42           O  
ATOM    607  CB  ILE A  67     -14.909  36.712  40.973  1.00 34.36           C  
ATOM    608  CG1 ILE A  67     -13.700  36.142  40.217  1.00 34.17           C  
ATOM    609  CG2 ILE A  67     -15.013  38.224  40.799  1.00 35.28           C  
ATOM    610  CD1 ILE A  67     -13.832  36.247  38.694  1.00 35.71           C  
ATOM    611  N   ALA A  68     -12.549  36.819  43.185  1.00 33.01           N  
ATOM    612  CA  ALA A  68     -11.516  37.537  43.914  1.00 33.74           C  
ATOM    613  C   ALA A  68     -10.271  37.645  43.084  1.00 32.77           C  
ATOM    614  O   ALA A  68      -9.992  36.785  42.243  1.00 32.85           O  
ATOM    615  CB  ALA A  68     -11.180  36.800  45.209  1.00 34.62           C  
ATOM    616  N   LEU A  69      -9.534  38.714  43.331  1.00 32.81           N  
ATOM    617  CA  LEU A  69      -8.247  38.948  42.716  1.00 34.07           C  
ATOM    618  C   LEU A  69      -7.231  39.035  43.838  1.00 32.69           C  
ATOM    619  O   LEU A  69      -7.415  39.805  44.782  1.00 32.84           O  
ATOM    620  CB  LEU A  69      -8.247  40.238  41.873  1.00 33.34           C  
ATOM    621  CG  LEU A  69      -6.951  40.584  41.134  1.00 35.23           C  
ATOM    622  CD1 LEU A  69      -7.220  41.390  39.886  1.00 39.66           C  
ATOM    623  CD2 LEU A  69      -5.918  41.302  42.023  1.00 38.80           C  
ATOM    624  N   LEU A  70      -6.163  38.237  43.723  1.00 33.24           N  
ATOM    625  CA  LEU A  70      -5.046  38.242  44.666  1.00 34.08           C  
ATOM    626  C   LEU A  70      -3.819  38.734  43.929  1.00 32.87           C  
ATOM    627  O   LEU A  70      -3.418  38.141  42.942  1.00 33.63           O  
ATOM    628  CB  LEU A  70      -4.782  36.822  45.218  1.00 33.36           C  
ATOM    629  CG  LEU A  70      -3.617  36.662  46.202  1.00 34.79           C  
ATOM    630  CD1 LEU A  70      -3.906  37.377  47.528  1.00 33.90           C  
ATOM    631  CD2 LEU A  70      -3.309  35.179  46.475  1.00 35.71           C  
ATOM    632  N   ARG A  71      -3.219  39.826  44.398  1.00 34.51           N  
ATOM    633  CA  ARG A  71      -1.997  40.337  43.787  1.00 33.59           C  
ATOM    634  C   ARG A  71      -0.801  39.483  44.224  1.00 35.54           C  
ATOM    635  O   ARG A  71      -0.611  39.230  45.415  1.00 35.99           O  
ATOM    636  CB  ARG A  71      -1.744  41.801  44.183  1.00 33.27           C  
ATOM    637  CG  ARG A  71      -0.394  42.327  43.735  1.00 34.32           C  
ATOM    638  CD  ARG A  71      -0.125  43.733  44.185  1.00 36.24           C  
ATOM    639  NE  ARG A  71       1.219  44.123  43.769  1.00 41.14           N  
ATOM    640  CZ  ARG A  71       2.340  43.880  44.453  1.00 36.13           C  
ATOM    641  NH1 ARG A  71       2.331  43.227  45.604  1.00 38.99           N  
ATOM    642  NH2 ARG A  71       3.496  44.273  43.957  1.00 38.48           N  
ATOM    643  N   ILE A  72      -0.027  39.021  43.241  1.00 35.25           N  
ATOM    644  CA  ILE A  72       1.222  38.293  43.482  1.00 35.85           C  
ATOM    645  C   ILE A  72       2.366  39.298  43.403  1.00 35.43           C  
ATOM    646  O   ILE A  72       3.216  39.348  44.288  1.00 35.13           O  
ATOM    647  CB  ILE A  72       1.431  37.143  42.469  1.00 35.54           C  
ATOM    648  CG1 ILE A  72       0.289  36.131  42.586  1.00 33.41           C  
ATOM    649  CG2 ILE A  72       2.790  36.477  42.680  1.00 39.31           C  
ATOM    650  CD1 ILE A  72       0.039  35.625  44.019  1.00 35.43           C  
ATOM    651  N   ASP A  73       2.366  40.103  42.348  1.00 35.98           N  
ATOM    652  CA  ASP A  73       3.363  41.161  42.150  1.00 35.75           C  
ATOM    653  C   ASP A  73       2.766  42.193  41.200  1.00 34.96           C  
ATOM    654  O   ASP A  73       1.609  42.054  40.833  1.00 35.51           O  
ATOM    655  CB  ASP A  73       4.703  40.577  41.674  1.00 36.38           C  
ATOM    656  CG  ASP A  73       4.591  39.757  40.395  1.00 36.82           C  
ATOM    657  OD1 ASP A  73       3.946  40.188  39.419  1.00 44.64           O  
ATOM    658  OD2 ASP A  73       5.201  38.674  40.356  1.00 42.42           O  
ATOM    659  N   ASP A  74       3.527  43.222  40.807  1.00 35.95           N  
ATOM    660  CA  ASP A  74       3.014  44.281  39.905  1.00 34.94           C  
ATOM    661  C   ASP A  74       2.443  43.779  38.576  1.00 34.86           C  
ATOM    662  O   ASP A  74       1.569  44.438  37.983  1.00 34.50           O  
ATOM    663  CB  ASP A  74       4.113  45.297  39.576  1.00 36.08           C  
ATOM    664  CG  ASP A  74       4.488  46.188  40.751  1.00 38.77           C  
ATOM    665  OD1 ASP A  74       3.737  46.267  41.746  1.00 39.73           O  
ATOM    666  OD2 ASP A  74       5.537  46.855  40.645  1.00 47.13           O  
ATOM    667  N   LYS A  75       2.945  42.628  38.121  1.00 34.56           N  
ATOM    668  CA  LYS A  75       2.567  42.023  36.847  1.00 34.01           C  
ATOM    669  C   LYS A  75       1.566  40.885  36.914  1.00 34.80           C  
ATOM    670  O   LYS A  75       0.783  40.715  35.992  1.00 35.72           O  
ATOM    671  CB  LYS A  75       3.825  41.491  36.158  1.00 37.58           C  
ATOM    672  N   THR A  76       1.571  40.125  38.003  1.00 34.89           N  
ATOM    673  CA  THR A  76       0.746  38.924  38.114  1.00 34.48           C  
ATOM    674  C   THR A  76      -0.292  38.936  39.228  1.00 32.31           C  
ATOM    675  O   THR A  76      -0.018  39.354  40.344  1.00 32.59           O  
ATOM    676  CB  THR A  76       1.666  37.701  38.330  1.00 36.19           C  
ATOM    677  OG1 THR A  76       2.553  37.600  37.216  1.00 40.97           O  
ATOM    678  CG2 THR A  76       0.880  36.396  38.458  1.00 36.87           C  
ATOM    679  N   ALA A  77      -1.489  38.475  38.891  1.00 32.41           N  
ATOM    680  CA  ALA A  77      -2.574  38.305  39.846  1.00 33.40           C  
ATOM    681  C   ALA A  77      -3.190  36.929  39.646  1.00 33.22           C  
ATOM    682  O   ALA A  77      -3.119  36.362  38.557  1.00 33.14           O  
ATOM    683  CB  ALA A  77      -3.607  39.378  39.671  1.00 33.87           C  
ATOM    684  N   VAL A  78      -3.767  36.389  40.710  1.00 32.12           N  
ATOM    685  CA  VAL A  78      -4.446  35.111  40.678  1.00 33.17           C  
ATOM    686  C   VAL A  78      -5.951  35.380  40.759  1.00 34.36           C  
ATOM    687  O   VAL A  78      -6.391  36.222  41.526  1.00 33.01           O  
ATOM    688  CB  VAL A  78      -4.050  34.215  41.900  1.00 34.61           C  
ATOM    689  CG1 VAL A  78      -4.694  32.822  41.812  1.00 34.64           C  
ATOM    690  CG2 VAL A  78      -2.540  34.079  41.991  1.00 33.88           C  
ATOM    691  N   LEU A  79      -6.718  34.662  39.942  1.00 35.31           N  
ATOM    692  CA  LEU A  79      -8.177  34.705  39.961  1.00 34.39           C  
ATOM    693  C   LEU A  79      -8.586  33.550  40.888  1.00 33.31           C  
ATOM    694  O   LEU A  79      -8.250  32.395  40.627  1.00 33.95           O  
ATOM    695  CB  LEU A  79      -8.722  34.544  38.540  1.00 36.01           C  
ATOM    696  CG  LEU A  79     -10.231  34.732  38.310  1.00 36.02           C  
ATOM    697  CD1 LEU A  79     -10.506  35.107  36.858  1.00 40.52           C  
ATOM    698  CD2 LEU A  79     -11.018  33.514  38.727  1.00 35.94           C  
ATOM    699  N   LYS A  80      -9.263  33.885  41.988  1.00 33.21           N  
ATOM    700  CA  LYS A  80      -9.642  32.932  43.021  1.00 36.07           C  
ATOM    701  C   LYS A  80     -11.094  33.089  43.412  1.00 33.30           C  
ATOM    702  O   LYS A  80     -11.736  34.078  43.071  1.00 34.35           O  
ATOM    703  CB  LYS A  80      -8.837  33.207  44.307  1.00 37.72           C  
ATOM    704  CG  LYS A  80      -7.356  32.924  44.254  1.00 42.86           C  
ATOM    705  CD  LYS A  80      -6.658  33.336  45.546  1.00 42.12           C  
ATOM    706  CE  LYS A  80      -7.033  32.493  46.766  1.00 42.20           C  
ATOM    707  NZ  LYS A  80      -6.680  31.084  46.570  1.00 51.33           N  
ATOM    708  N   LYS A  81     -11.576  32.101  44.163  1.00 32.86           N  
ATOM    709  CA  LYS A  81     -12.903  32.075  44.736  1.00 33.34           C  
ATOM    710  C   LYS A  81     -13.994  32.474  43.757  1.00 35.03           C  
ATOM    711  O   LYS A  81     -14.868  33.265  44.085  1.00 33.73           O  
ATOM    712  CB  LYS A  81     -12.937  32.941  45.984  1.00 34.56           C  
ATOM    713  CG  LYS A  81     -11.889  32.551  47.042  1.00 35.97           C  
ATOM    714  CD  LYS A  81     -11.987  31.093  47.482  1.00 41.04           C  
ATOM    715  CE  LYS A  81     -10.867  30.717  48.435  1.00 37.92           C  
ATOM    716  NZ  LYS A  81     -10.394  29.331  48.172  1.00 40.41           N  
ATOM    717  N   PHE A  82     -13.936  31.872  42.569  1.00 35.15           N  
ATOM    718  CA  PHE A  82     -14.890  32.154  41.513  1.00 34.85           C  
ATOM    719  C   PHE A  82     -16.037  31.143  41.563  1.00 34.32           C  
ATOM    720  O   PHE A  82     -15.881  30.004  41.155  1.00 35.34           O  
ATOM    721  CB  PHE A  82     -14.158  32.158  40.184  1.00 35.49           C  
ATOM    722  CG  PHE A  82     -15.023  32.479  38.994  1.00 35.53           C  
ATOM    723  CD1 PHE A  82     -16.167  33.266  39.081  1.00 36.78           C  
ATOM    724  CD2 PHE A  82     -14.589  32.104  37.748  1.00 50.87           C  
ATOM    725  CE1 PHE A  82     -16.898  33.561  37.966  1.00 38.53           C  
ATOM    726  CE2 PHE A  82     -15.297  32.421  36.639  1.00 49.75           C  
ATOM    727  CZ  PHE A  82     -16.466  33.143  36.748  1.00 44.81           C  
ATOM    728  N   PHE A  83     -17.184  31.576  42.061  1.00 32.58           N  
ATOM    729  CA  PHE A  83     -18.336  30.689  42.240  1.00 33.82           C  
ATOM    730  C   PHE A  83     -19.627  31.371  41.854  1.00 33.47           C  
ATOM    731  O   PHE A  83     -19.745  32.585  42.003  1.00 32.83           O  
ATOM    732  CB  PHE A  83     -18.451  30.268  43.710  1.00 34.10           C  
ATOM    733  CG  PHE A  83     -17.225  29.574  44.245  1.00 30.13           C  
ATOM    734  CD1 PHE A  83     -16.913  28.288  43.841  1.00 36.39           C  
ATOM    735  CD2 PHE A  83     -16.388  30.206  45.175  1.00 33.72           C  
ATOM    736  CE1 PHE A  83     -15.788  27.646  44.323  1.00 37.70           C  
ATOM    737  CE2 PHE A  83     -15.269  29.559  45.657  1.00 38.05           C  
ATOM    738  CZ  PHE A  83     -14.967  28.282  45.223  1.00 35.90           C  
ATOM    739  N   THR A  84     -20.576  30.582  41.348  1.00 32.35           N  
ATOM    740  CA  THR A  84     -21.906  31.067  41.012  1.00 35.34           C  
ATOM    741  C   THR A  84     -22.909  29.961  41.273  1.00 32.76           C  
ATOM    742  O   THR A  84     -22.588  28.810  41.074  1.00 33.93           O  
ATOM    743  CB  THR A  84     -22.041  31.472  39.502  1.00 34.62           C  
ATOM    744  OG1 THR A  84     -21.695  30.361  38.680  1.00 37.11           O  
ATOM    745  CG2 THR A  84     -21.141  32.621  39.134  1.00 34.71           C  
ATOM    746  N   TYR A  85     -24.106  30.292  41.743  1.00 33.67           N  
ATOM    747  CA  TYR A  85     -25.146  29.265  41.854  1.00 34.94           C  
ATOM    748  C   TYR A  85     -25.558  28.902  40.401  1.00 32.98           C  
ATOM    749  O   TYR A  85     -25.556  29.768  39.534  1.00 33.92           O  
ATOM    750  CB  TYR A  85     -26.345  29.695  42.729  1.00 34.58           C  
ATOM    751  CG  TYR A  85     -26.105  29.559  44.227  1.00 36.31           C  
ATOM    752  CD1 TYR A  85     -25.735  28.332  44.795  1.00 38.53           C  
ATOM    753  CD2 TYR A  85     -26.285  30.651  45.089  1.00 32.45           C  
ATOM    754  CE1 TYR A  85     -25.515  28.214  46.181  1.00 36.68           C  
ATOM    755  CE2 TYR A  85     -26.059  30.540  46.448  1.00 35.23           C  
ATOM    756  CZ  TYR A  85     -25.679  29.326  46.990  1.00 29.59           C  
ATOM    757  OH  TYR A  85     -25.497  29.256  48.351  1.00 36.71           O  
ATOM    758  N   PRO A  86     -25.833  27.613  40.123  1.00 34.31           N  
ATOM    759  CA  PRO A  86     -26.129  27.144  38.756  1.00 34.24           C  
ATOM    760  C   PRO A  86     -27.109  27.918  37.912  1.00 34.20           C  
ATOM    761  O   PRO A  86     -26.853  28.121  36.720  1.00 32.77           O  
ATOM    762  CB  PRO A  86     -26.653  25.723  38.985  1.00 37.61           C  
ATOM    763  CG  PRO A  86     -25.902  25.261  40.208  1.00 34.61           C  
ATOM    764  CD  PRO A  86     -25.783  26.486  41.078  1.00 35.07           C  
ATOM    765  N   LYS A  87     -28.215  28.368  38.486  1.00 33.64           N  
ATOM    766  CA  LYS A  87     -29.241  29.029  37.665  1.00 33.87           C  
ATOM    767  C   LYS A  87     -28.825  30.391  37.080  1.00 32.03           C  
ATOM    768  O   LYS A  87     -29.500  30.912  36.190  1.00 32.49           O  
ATOM    769  CB  LYS A  87     -30.573  29.137  38.430  1.00 33.73           C  
ATOM    770  CG  LYS A  87     -30.544  29.991  39.693  1.00 33.73           C  
ATOM    771  CD  LYS A  87     -31.943  30.140  40.242  1.00 37.53           C  
ATOM    772  CE  LYS A  87     -31.977  30.817  41.600  1.00 40.73           C  
ATOM    773  NZ  LYS A  87     -33.377  30.974  42.065  1.00 44.19           N  
ATOM    774  N   TYR A  88     -27.723  30.943  37.583  1.00 30.64           N  
ATOM    775  CA  TYR A  88     -27.184  32.235  37.161  1.00 31.57           C  
ATOM    776  C   TYR A  88     -26.111  32.086  36.098  1.00 30.62           C  
ATOM    777  O   TYR A  88     -25.628  33.075  35.575  1.00 32.07           O  
ATOM    778  CB  TYR A  88     -26.607  32.981  38.372  1.00 31.38           C  
ATOM    779  CG  TYR A  88     -27.640  33.226  39.455  1.00 34.17           C  
ATOM    780  CD1 TYR A  88     -28.540  34.261  39.349  1.00 32.57           C  
ATOM    781  CD2 TYR A  88     -27.699  32.430  40.588  1.00 33.30           C  
ATOM    782  CE1 TYR A  88     -29.490  34.487  40.314  1.00 36.69           C  
ATOM    783  CE2 TYR A  88     -28.663  32.653  41.566  1.00 32.98           C  
ATOM    784  CZ  TYR A  88     -29.536  33.688  41.423  1.00 34.49           C  
ATOM    785  OH  TYR A  88     -30.484  33.930  42.387  1.00 36.58           O  
ATOM    786  N   ARG A  89     -25.750  30.841  35.778  1.00 33.78           N  
ATOM    787  CA  ARG A  89     -24.725  30.527  34.765  1.00 33.21           C  
ATOM    788  C   ARG A  89     -25.301  30.549  33.378  1.00 31.56           C  
ATOM    789  O   ARG A  89     -26.428  30.107  33.159  1.00 31.61           O  
ATOM    790  CB  ARG A  89     -24.140  29.143  35.023  1.00 33.02           C  
ATOM    791  CG  ARG A  89     -23.507  29.021  36.399  1.00 33.79           C  
ATOM    792  CD  ARG A  89     -23.014  27.626  36.672  1.00 37.42           C  
ATOM    793  NE  ARG A  89     -22.597  27.445  38.072  1.00 33.68           N  
ATOM    794  CZ  ARG A  89     -22.478  26.266  38.682  1.00 38.59           C  
ATOM    795  NH1 ARG A  89     -22.746  25.144  38.045  1.00 37.05           N  
ATOM    796  NH2 ARG A  89     -22.122  26.201  39.959  1.00 36.09           N  
ATOM    797  N   GLY A  90     -24.541  31.059  32.420  1.00 31.40           N  
ATOM    798  CA  GLY A  90     -25.005  31.092  31.045  1.00 31.44           C  
ATOM    799  C   GLY A  90     -26.270  31.910  30.877  1.00 30.46           C  
ATOM    800  O   GLY A  90     -26.636  32.696  31.745  1.00 29.98           O  
ATOM    801  N   ASN A  91     -26.949  31.713  29.765  1.00 29.27           N  
ATOM    802  CA  ASN A  91     -28.179  32.453  29.517  1.00 30.13           C  
ATOM    803  C   ASN A  91     -29.228  32.146  30.596  1.00 29.89           C  
ATOM    804  O   ASN A  91     -29.310  31.005  31.037  1.00 30.91           O  
ATOM    805  CB  ASN A  91     -28.736  32.110  28.167  1.00 28.01           C  
ATOM    806  CG  ASN A  91     -27.840  32.553  27.043  1.00 36.49           C  
ATOM    807  OD1 ASN A  91     -27.404  33.706  27.005  1.00 32.90           O  
ATOM    808  ND2 ASN A  91     -27.601  31.655  26.087  1.00 30.45           N  
ATOM    809  N   PRO A  92     -30.000  33.167  31.041  1.00 28.04           N  
ATOM    810  CA  PRO A  92     -29.945  34.557  30.614  1.00 29.45           C  
ATOM    811  C   PRO A  92     -29.038  35.470  31.426  1.00 29.56           C  
ATOM    812  O   PRO A  92     -28.676  36.522  30.938  1.00 30.92           O  
ATOM    813  CB  PRO A  92     -31.401  35.016  30.765  1.00 31.73           C  
ATOM    814  CG  PRO A  92     -31.922  34.215  31.924  1.00 28.55           C  
ATOM    815  CD  PRO A  92     -31.083  32.956  32.025  1.00 29.73           C  
ATOM    816  N   VAL A  93     -28.642  35.073  32.627  1.00 31.17           N  
ATOM    817  CA  VAL A  93     -27.936  35.995  33.513  1.00 31.97           C  
ATOM    818  C   VAL A  93     -26.452  36.171  33.192  1.00 32.03           C  
ATOM    819  O   VAL A  93     -25.934  37.266  33.298  1.00 31.85           O  
ATOM    820  CB  VAL A  93     -28.083  35.582  35.013  1.00 33.35           C  
ATOM    821  CG1 VAL A  93     -27.517  36.667  35.918  1.00 35.96           C  
ATOM    822  CG2 VAL A  93     -29.525  35.326  35.382  1.00 31.41           C  
ATOM    823  N   ARG A  94     -25.781  35.092  32.792  0.50 31.49           N  
ATOM    825  CA  ARG A  94     -24.348  35.127  32.461  0.50 31.12           C  
ATOM    827  C   ARG A  94     -23.525  35.689  33.617  0.50 31.52           C  
ATOM    829  O   ARG A  94     -22.613  36.491  33.405  0.50 31.11           O  
ATOM    831  CB  ARG A  94     -24.080  35.947  31.185  0.50 30.81           C  
ATOM    833  CG  ARG A  94     -24.739  35.431  29.946  0.50 28.88           C  
ATOM    835  CD  ARG A  94     -24.616  36.425  28.789  0.50 29.02           C  
ATOM    837  NE  ARG A  94     -25.282  35.926  27.583  0.50 29.72           N  
ATOM    839  CZ  ARG A  94     -25.326  36.563  26.415  0.50 21.31           C  
ATOM    841  NH1 ARG A  94     -24.743  37.747  26.244  0.50 22.87           N  
ATOM    843  NH2 ARG A  94     -25.955  36.003  25.406  0.50 21.89           N  
ATOM    845  N   LEU A  95     -23.841  35.262  34.837  1.00 32.17           N  
ATOM    846  CA  LEU A  95     -23.177  35.799  36.011  1.00 32.74           C  
ATOM    847  C   LEU A  95     -21.676  35.556  36.042  1.00 32.14           C  
ATOM    848  O   LEU A  95     -20.926  36.408  36.510  1.00 32.92           O  
ATOM    849  CB  LEU A  95     -23.848  35.283  37.294  1.00 33.88           C  
ATOM    850  CG  LEU A  95     -23.383  35.948  38.595  1.00 36.06           C  
ATOM    851  CD1 LEU A  95     -23.657  37.442  38.545  1.00 32.65           C  
ATOM    852  CD2 LEU A  95     -24.054  35.279  39.785  1.00 33.89           C  
ATOM    853  N   GLY A  96     -21.229  34.404  35.559  1.00 34.23           N  
ATOM    854  CA  GLY A  96     -19.786  34.127  35.528  1.00 34.54           C  
ATOM    855  C   GLY A  96     -19.058  35.141  34.665  1.00 33.92           C  
ATOM    856  O   GLY A  96     -17.984  35.628  35.023  1.00 34.88           O  
ATOM    857  N   ARG A  97     -19.637  35.455  33.509  1.00 32.97           N  
ATOM    858  CA  ARG A  97     -19.072  36.452  32.607  1.00 34.02           C  
ATOM    859  C   ARG A  97     -19.082  37.833  33.247  1.00 33.54           C  
ATOM    860  O   ARG A  97     -18.126  38.570  33.122  1.00 32.38           O  
ATOM    861  CB  ARG A  97     -19.872  36.548  31.299  1.00 34.93           C  
ATOM    862  CG  ARG A  97     -19.917  35.275  30.486  1.00 47.26           C  
ATOM    863  N   LYS A  98     -20.181  38.188  33.908  1.00 34.24           N  
ATOM    864  CA  LYS A  98     -20.301  39.495  34.549  1.00 34.88           C  
ATOM    865  C   LYS A  98     -19.301  39.650  35.693  1.00 35.83           C  
ATOM    866  O   LYS A  98     -18.770  40.734  35.905  1.00 36.10           O  
ATOM    867  CB  LYS A  98     -21.724  39.714  35.052  1.00 35.45           C  
ATOM    868  CG  LYS A  98     -22.712  39.900  33.925  1.00 43.06           C  
ATOM    869  CD  LYS A  98     -24.140  39.894  34.404  1.00 45.72           C  
ATOM    870  CE  LYS A  98     -25.097  40.249  33.258  1.00 47.73           C  
ATOM    871  NZ  LYS A  98     -26.482  39.959  33.698  1.00 49.92           N  
ATOM    872  N   LEU A  99     -19.060  38.569  36.432  1.00 36.15           N  
ATOM    873  CA  LEU A  99     -18.078  38.575  37.522  1.00 35.72           C  
ATOM    874  C   LEU A  99     -16.671  38.694  36.931  1.00 37.50           C  
ATOM    875  O   LEU A  99     -15.867  39.517  37.368  1.00 37.50           O  
ATOM    876  CB  LEU A  99     -18.201  37.310  38.382  1.00 34.26           C  
ATOM    877  CG  LEU A  99     -19.360  37.293  39.367  1.00 35.06           C  
ATOM    878  CD1 LEU A  99     -19.646  35.896  39.846  1.00 36.33           C  
ATOM    879  CD2 LEU A  99     -19.081  38.231  40.541  1.00 38.00           C  
ATOM    880  N   PHE A 100     -16.406  37.872  35.924  1.00 40.33           N  
ATOM    881  CA  PHE A 100     -15.141  37.883  35.215  1.00 42.17           C  
ATOM    882  C   PHE A 100     -14.830  39.261  34.575  1.00 41.62           C  
ATOM    883  O   PHE A 100     -13.679  39.698  34.571  1.00 39.82           O  
ATOM    884  CB  PHE A 100     -15.115  36.783  34.156  1.00 43.81           C  
ATOM    885  CG  PHE A 100     -13.831  36.709  33.464  1.00 47.25           C  
ATOM    886  CD1 PHE A 100     -12.753  36.144  34.104  1.00 46.27           C  
ATOM    887  CD2 PHE A 100     -13.663  37.277  32.192  1.00 50.51           C  
ATOM    888  CE1 PHE A 100     -11.517  36.130  33.498  1.00 56.62           C  
ATOM    889  CE2 PHE A 100     -12.433  37.261  31.560  1.00 51.18           C  
ATOM    890  CZ  PHE A 100     -11.355  36.679  32.206  1.00 53.72           C  
ATOM    891  N   GLU A 101     -15.854  39.942  34.061  1.00 40.33           N  
ATOM    892  CA  GLU A 101     -15.698  41.292  33.523  1.00 41.70           C  
ATOM    893  C   GLU A 101     -15.322  42.309  34.594  1.00 40.63           C  
ATOM    894  O   GLU A 101     -14.503  43.191  34.341  1.00 37.85           O  
ATOM    895  CB  GLU A 101     -16.974  41.760  32.806  1.00 42.43           C  
ATOM    896  CG  GLU A 101     -17.143  41.175  31.416  1.00 45.59           C  
ATOM    897  CD  GLU A 101     -18.541  41.406  30.821  1.00 47.91           C  
ATOM    898  OE1 GLU A 101     -19.373  42.120  31.441  1.00 55.19           O  
ATOM    899  OE2 GLU A 101     -18.810  40.850  29.732  1.00 53.25           O  
ATOM    900  N   ARG A 102     -15.924  42.205  35.778  1.00 39.62           N  
ATOM    901  CA  ARG A 102     -15.617  43.130  36.863  1.00 41.28           C  
ATOM    902  C   ARG A 102     -14.175  42.920  37.362  1.00 42.27           C  
ATOM    903  O   ARG A 102     -13.444  43.900  37.631  1.00 42.16           O  
ATOM    904  CB  ARG A 102     -16.627  42.989  38.000  1.00 42.58           C  
ATOM    905  CG  ARG A 102     -16.303  43.868  39.195  1.00 48.81           C  
ATOM    906  CD  ARG A 102     -16.546  45.330  38.907  1.00 49.29           C  
ATOM    907  NE  ARG A 102     -17.956  45.598  39.125  1.00 50.40           N  
ATOM    908  CZ  ARG A 102     -18.483  46.143  40.225  1.00 51.44           C  
ATOM    909  NH1 ARG A 102     -17.733  46.586  41.249  1.00 42.85           N  
ATOM    910  NH2 ARG A 102     -19.800  46.294  40.274  1.00 52.25           N  
ATOM    911  N   PHE A 103     -13.792  41.643  37.506  1.00 40.43           N  
ATOM    912  CA  PHE A 103     -12.432  41.248  37.846  1.00 39.24           C  
ATOM    913  C   PHE A 103     -11.476  41.939  36.896  1.00 40.64           C  
ATOM    914  O   PHE A 103     -10.466  42.510  37.314  1.00 38.50           O  
ATOM    915  CB  PHE A 103     -12.287  39.725  37.710  1.00 41.67           C  
ATOM    916  CG  PHE A 103     -10.886  39.198  37.918  1.00 38.73           C  
ATOM    917  CD1 PHE A 103      -9.981  39.163  36.866  1.00 44.49           C  
ATOM    918  CD2 PHE A 103     -10.487  38.705  39.137  1.00 40.92           C  
ATOM    919  CE1 PHE A 103      -8.692  38.680  37.034  1.00 42.07           C  
ATOM    920  CE2 PHE A 103      -9.208  38.206  39.306  1.00 41.12           C  
ATOM    921  CZ  PHE A 103      -8.306  38.196  38.247  1.00 38.66           C  
HETATM  922  N   MSE A 104     -11.793  41.897  35.608  1.00 41.25           N  
HETATM  923  CA  MSE A 104     -10.900  42.522  34.649  1.00 43.40           C  
HETATM  924  C   MSE A 104     -10.772  43.994  34.530  1.00 40.56           C  
HETATM  925  O   MSE A 104      -9.704  44.466  34.163  1.00 40.29           O  
HETATM  926  CB  MSE A 104     -10.735  41.741  33.379  1.00 44.91           C  
HETATM  927  CG  MSE A 104      -9.445  41.012  33.670  1.00 42.68           C  
HETATM  928 SE   MSE A 104      -9.322  39.499  32.832  0.75 54.46          SE  
HETATM  929  CE  MSE A 104      -7.996  38.894  33.447  1.00 48.62           C  
ATOM    930  N   LEU A 105     -11.834  44.721  34.858  0.50 39.92           N  
ATOM    932  CA  LEU A 105     -11.765  46.173  34.917  0.50 38.94           C  
ATOM    934  C   LEU A 105     -10.727  46.543  35.987  0.50 38.49           C  
ATOM    936  O   LEU A 105      -9.923  47.453  35.803  0.50 37.64           O  
ATOM    938  CB  LEU A 105     -13.130  46.764  35.282  0.50 39.10           C  
ATOM    940  CG  LEU A 105     -13.216  48.293  35.258  0.50 38.89           C  
ATOM    942  N   PHE A 106     -10.740  45.811  37.097  1.00 37.67           N  
ATOM    943  CA  PHE A 106      -9.808  46.043  38.189  1.00 38.27           C  
ATOM    944  C   PHE A 106      -8.391  45.596  37.804  1.00 39.22           C  
ATOM    945  O   PHE A 106      -7.431  46.310  38.054  1.00 39.30           O  
ATOM    946  CB  PHE A 106     -10.273  45.286  39.438  1.00 38.72           C  
ATOM    947  CG  PHE A 106      -9.474  45.593  40.688  1.00 39.22           C  
ATOM    948  CD1 PHE A 106      -9.840  46.644  41.516  1.00 39.16           C  
ATOM    949  CD2 PHE A 106      -8.386  44.806  41.056  1.00 39.32           C  
ATOM    950  CE1 PHE A 106      -9.116  46.922  42.674  1.00 41.56           C  
ATOM    951  CE2 PHE A 106      -7.675  45.073  42.199  1.00 36.73           C  
ATOM    952  CZ  PHE A 106      -8.033  46.136  43.013  1.00 39.80           C  
ATOM    953  N   ALA A 107      -8.279  44.417  37.194  1.00 40.19           N  
ATOM    954  CA  ALA A 107      -6.990  43.869  36.798  1.00 40.46           C  
ATOM    955  C   ALA A 107      -6.272  44.779  35.819  1.00 41.88           C  
ATOM    956  O   ALA A 107      -5.074  45.005  35.970  1.00 43.18           O  
ATOM    957  CB  ALA A 107      -7.153  42.491  36.202  1.00 40.84           C  
ATOM    958  N   ARG A 108      -6.993  45.293  34.822  1.00 41.45           N  
ATOM    959  CA  ARG A 108      -6.400  46.213  33.851  1.00 43.05           C  
ATOM    960  C   ARG A 108      -6.039  47.563  34.463  1.00 42.43           C  
ATOM    961  O   ARG A 108      -4.955  48.092  34.196  1.00 42.51           O  
ATOM    962  CB  ARG A 108      -7.306  46.417  32.643  1.00 43.75           C  
ATOM    963  CG  ARG A 108      -7.383  45.197  31.770  1.00 49.23           C  
ATOM    964  CD  ARG A 108      -8.280  45.411  30.563  1.00 58.84           C  
ATOM    965  NE  ARG A 108      -8.420  44.156  29.827  1.00 62.82           N  
ATOM    966  CZ  ARG A 108      -7.533  43.667  28.957  1.00 65.06           C  
ATOM    967  NH1 ARG A 108      -6.396  44.314  28.665  1.00 62.53           N  
ATOM    968  NH2 ARG A 108      -7.787  42.501  28.368  1.00 63.76           N  
ATOM    969  N   ALA A 109      -6.937  48.123  35.271  1.00 41.53           N  
ATOM    970  CA  ALA A 109      -6.657  49.391  35.956  1.00 40.94           C  
ATOM    971  C   ALA A 109      -5.441  49.281  36.882  1.00 41.32           C  
ATOM    972  O   ALA A 109      -4.743  50.261  37.084  1.00 41.89           O  
ATOM    973  CB  ALA A 109      -7.865  49.841  36.746  1.00 41.80           C  
ATOM    974  N   SER A 110      -5.202  48.092  37.448  1.00 40.62           N  
ATOM    975  CA  SER A 110      -4.041  47.839  38.318  1.00 40.07           C  
ATOM    976  C   SER A 110      -2.753  47.558  37.534  1.00 39.15           C  
ATOM    977  O   SER A 110      -1.699  47.356  38.127  1.00 38.55           O  
ATOM    978  CB  SER A 110      -4.326  46.662  39.251  1.00 40.44           C  
ATOM    979  OG  SER A 110      -5.446  46.919  40.067  1.00 43.41           O  
ATOM    980  N   LYS A 111      -2.855  47.524  36.209  1.00 38.91           N  
ATOM    981  CA  LYS A 111      -1.717  47.321  35.311  1.00 40.05           C  
ATOM    982  C   LYS A 111      -1.108  45.917  35.409  1.00 39.73           C  
ATOM    983  O   LYS A 111       0.083  45.747  35.199  1.00 38.46           O  
ATOM    984  CB  LYS A 111      -0.631  48.405  35.510  1.00 40.19           C  
ATOM    985  CG  LYS A 111      -1.130  49.857  35.538  1.00 43.58           C  
ATOM    986  CD  LYS A 111      -1.852  50.254  34.237  1.00 47.17           C  
ATOM    987  CE  LYS A 111      -2.092  51.763  34.149  1.00 45.58           C  
ATOM    988  N   PHE A 112      -1.907  44.906  35.746  1.00 39.97           N  
ATOM    989  CA  PHE A 112      -1.402  43.535  35.726  1.00 40.17           C  
ATOM    990  C   PHE A 112      -1.335  43.122  34.266  1.00 41.36           C  
ATOM    991  O   PHE A 112      -2.124  43.587  33.458  1.00 42.90           O  
ATOM    992  CB  PHE A 112      -2.301  42.576  36.489  1.00 40.14           C  
ATOM    993  CG  PHE A 112      -2.387  42.864  37.955  1.00 39.87           C  
ATOM    994  CD1 PHE A 112      -1.262  42.787  38.756  1.00 44.89           C  
ATOM    995  CD2 PHE A 112      -3.600  43.168  38.552  1.00 42.84           C  
ATOM    996  CE1 PHE A 112      -1.344  43.033  40.111  1.00 41.94           C  
ATOM    997  CE2 PHE A 112      -3.679  43.411  39.914  1.00 37.52           C  
ATOM    998  CZ  PHE A 112      -2.557  43.348  40.686  1.00 41.17           C  
ATOM    999  N   THR A 113      -0.359  42.298  33.922  1.00 42.83           N  
ATOM   1000  CA  THR A 113      -0.198  41.815  32.550  1.00 43.45           C  
ATOM   1001  C   THR A 113      -0.435  40.307  32.427  1.00 43.30           C  
ATOM   1002  O   THR A 113      -0.446  39.780  31.319  1.00 43.58           O  
ATOM   1003  CB  THR A 113       1.226  42.106  32.028  1.00 42.08           C  
ATOM   1004  OG1 THR A 113       2.189  41.498  32.898  1.00 43.42           O  
ATOM   1005  CG2 THR A 113       1.473  43.598  31.965  1.00 45.75           C  
ATOM   1006  N   ARG A 114      -0.625  39.623  33.556  1.00 43.72           N  
ATOM   1007  CA  ARG A 114      -0.790  38.179  33.575  1.00 44.24           C  
ATOM   1008  C   ARG A 114      -1.773  37.774  34.674  1.00 42.55           C  
ATOM   1009  O   ARG A 114      -1.654  38.219  35.815  1.00 40.62           O  
ATOM   1010  CB  ARG A 114       0.579  37.511  33.830  1.00 44.14           C  
ATOM   1011  CG  ARG A 114       0.557  35.980  33.750  1.00 47.55           C  
ATOM   1012  CD  ARG A 114       1.948  35.338  33.827  1.00 47.56           C  
ATOM   1013  NE  ARG A 114       2.568  35.426  35.151  1.00 50.29           N  
ATOM   1014  CZ  ARG A 114       3.702  34.810  35.501  1.00 50.10           C  
ATOM   1015  NH1 ARG A 114       4.354  34.023  34.651  1.00 55.48           N  
ATOM   1016  NH2 ARG A 114       4.184  34.964  36.730  1.00 52.47           N  
ATOM   1017  N   ILE A 115      -2.747  36.941  34.316  1.00 41.92           N  
ATOM   1018  CA  ILE A 115      -3.706  36.403  35.280  1.00 41.68           C  
ATOM   1019  C   ILE A 115      -3.646  34.896  35.236  1.00 41.75           C  
ATOM   1020  O   ILE A 115      -3.789  34.315  34.162  1.00 39.99           O  
ATOM   1021  CB  ILE A 115      -5.152  36.830  34.980  1.00 42.51           C  
ATOM   1022  CG1 ILE A 115      -5.268  38.363  34.966  1.00 43.84           C  
ATOM   1023  CG2 ILE A 115      -6.132  36.162  35.966  1.00 43.38           C  
ATOM   1024  CD1 ILE A 115      -4.802  39.100  36.177  1.00 47.75           C  
ATOM   1025  N   VAL A 116      -3.469  34.274  36.404  1.00 41.88           N  
ATOM   1026  CA  VAL A 116      -3.376  32.826  36.523  1.00 40.87           C  
ATOM   1027  C   VAL A 116      -4.492  32.293  37.404  1.00 40.87           C  
ATOM   1028  O   VAL A 116      -5.064  33.013  38.219  1.00 39.90           O  
ATOM   1029  CB  VAL A 116      -1.998  32.373  37.085  1.00 41.78           C  
ATOM   1030  CG1 VAL A 116      -0.854  32.931  36.229  1.00 43.16           C  
ATOM   1031  CG2 VAL A 116      -1.809  32.793  38.532  1.00 47.00           C  
ATOM   1032  N   LEU A 117      -4.824  31.021  37.229  1.00 41.13           N  
ATOM   1033  CA  LEU A 117      -5.845  30.394  38.049  1.00 40.85           C  
ATOM   1034  C   LEU A 117      -5.719  28.906  37.930  1.00 39.65           C  
ATOM   1035  O   LEU A 117      -5.082  28.406  36.996  1.00 38.82           O  
ATOM   1036  CB  LEU A 117      -7.240  30.841  37.609  1.00 42.88           C  
ATOM   1037  CG  LEU A 117      -7.738  30.496  36.196  1.00 44.36           C  
ATOM   1038  CD1 LEU A 117      -8.342  29.079  36.103  1.00 42.20           C  
ATOM   1039  CD2 LEU A 117      -8.796  31.502  35.780  1.00 46.33           C  
ATOM   1040  N   ASP A 118      -6.314  28.184  38.867  1.00 38.40           N  
ATOM   1041  CA  ASP A 118      -6.361  26.748  38.712  1.00 40.34           C  
ATOM   1042  C   ASP A 118      -7.812  26.310  38.789  1.00 39.64           C  
ATOM   1043  O   ASP A 118      -8.664  27.015  39.328  1.00 38.11           O  
ATOM   1044  CB  ASP A 118      -5.476  25.981  39.701  1.00 43.97           C  
ATOM   1045  CG  ASP A 118      -6.050  25.948  41.066  1.00 48.77           C  
ATOM   1046  OD1 ASP A 118      -6.459  27.028  41.497  1.00 65.48           O  
ATOM   1047  OD2 ASP A 118      -6.076  24.872  41.697  1.00 60.79           O  
ATOM   1048  N   THR A 119      -8.075  25.144  38.225  1.00 39.89           N  
ATOM   1049  CA  THR A 119      -9.408  24.599  38.161  1.00 41.81           C  
ATOM   1050  C   THR A 119      -9.296  23.076  38.200  1.00 42.10           C  
ATOM   1051  O   THR A 119      -8.383  22.531  37.591  1.00 44.52           O  
ATOM   1052  CB  THR A 119     -10.132  25.094  36.856  1.00 41.86           C  
ATOM   1053  OG1 THR A 119     -11.356  24.384  36.680  1.00 47.39           O  
ATOM   1054  CG2 THR A 119      -9.274  24.903  35.616  1.00 38.73           C  
ATOM   1055  N   PRO A 120     -10.200  22.384  38.923  1.00 43.89           N  
ATOM   1056  CA  PRO A 120     -10.137  20.910  38.942  1.00 43.98           C  
ATOM   1057  C   PRO A 120     -10.177  20.285  37.538  1.00 44.55           C  
ATOM   1058  O   PRO A 120     -10.923  20.752  36.669  1.00 42.19           O  
ATOM   1059  CB  PRO A 120     -11.373  20.513  39.747  1.00 44.62           C  
ATOM   1060  CG  PRO A 120     -11.696  21.704  40.580  1.00 44.79           C  
ATOM   1061  CD  PRO A 120     -11.292  22.897  39.775  1.00 44.33           C  
ATOM   1062  N   GLU A 121      -9.411  19.210  37.340  1.00 46.77           N  
ATOM   1063  CA  GLU A 121      -9.306  18.558  36.035  1.00 46.22           C  
ATOM   1064  C   GLU A 121     -10.649  17.983  35.593  1.00 47.86           C  
ATOM   1065  O   GLU A 121     -10.866  17.812  34.398  1.00 46.40           O  
ATOM   1066  CB  GLU A 121      -8.219  17.466  36.031  1.00 46.90           C  
ATOM   1067  CG  GLU A 121      -7.466  17.254  34.672  1.00 43.44           C  
ATOM   1068  CD  GLU A 121      -8.290  16.601  33.575  1.00 42.48           C  
ATOM   1069  N   LYS A 122     -11.557  17.711  36.531  1.00 49.42           N  
ATOM   1070  CA  LYS A 122     -12.869  17.165  36.177  1.00 52.13           C  
ATOM   1071  C   LYS A 122     -13.916  18.221  35.839  1.00 52.29           C  
ATOM   1072  O   LYS A 122     -15.024  17.872  35.443  1.00 52.01           O  
ATOM   1073  CB  LYS A 122     -13.419  16.301  37.312  1.00 52.27           C  
ATOM   1074  CG  LYS A 122     -13.988  17.086  38.493  1.00 56.69           C  
ATOM   1075  CD  LYS A 122     -14.506  16.137  39.544  1.00 55.76           C  
ATOM   1076  CE  LYS A 122     -15.270  16.863  40.621  1.00 57.43           C  
ATOM   1077  NZ  LYS A 122     -15.856  15.859  41.553  1.00 60.51           N  
ATOM   1078  N   GLU A 123     -13.582  19.498  35.973  1.00 53.39           N  
ATOM   1079  CA  GLU A 123     -14.567  20.553  35.766  1.00 55.23           C  
ATOM   1080  C   GLU A 123     -14.509  21.041  34.312  1.00 53.34           C  
ATOM   1081  O   GLU A 123     -13.953  22.096  34.006  1.00 52.90           O  
ATOM   1082  CB  GLU A 123     -14.336  21.666  36.795  1.00 54.98           C  
ATOM   1083  CG  GLU A 123     -15.603  22.028  37.564  1.00 62.50           C  
ATOM   1084  CD  GLU A 123     -15.313  22.803  38.842  1.00 61.82           C  
ATOM   1085  OE1 GLU A 123     -14.904  23.989  38.735  1.00 69.57           O  
ATOM   1086  OE2 GLU A 123     -15.525  22.229  39.946  1.00 72.71           O  
ATOM   1087  N   LYS A 124     -15.093  20.235  33.426  1.00 50.44           N  
ATOM   1088  CA  LYS A 124     -15.116  20.497  31.986  1.00 50.84           C  
ATOM   1089  C   LYS A 124     -15.866  21.798  31.638  1.00 50.67           C  
ATOM   1090  O   LYS A 124     -15.407  22.580  30.787  1.00 48.35           O  
ATOM   1091  CB  LYS A 124     -15.734  19.287  31.249  1.00 49.73           C  
ATOM   1092  CG  LYS A 124     -15.750  19.394  29.732  1.00 49.72           C  
ATOM   1093  N   ARG A 125     -17.016  22.012  32.290  1.00 51.27           N  
ATOM   1094  CA  ARG A 125     -17.830  23.221  32.092  1.00 50.58           C  
ATOM   1095  C   ARG A 125     -16.998  24.475  32.353  1.00 49.36           C  
ATOM   1096  O   ARG A 125     -17.011  25.408  31.548  1.00 48.33           O  
ATOM   1097  CB  ARG A 125     -19.060  23.211  33.011  1.00 51.85           C  
ATOM   1098  N   SER A 126     -16.265  24.482  33.466  1.00 47.70           N  
ATOM   1099  CA  SER A 126     -15.411  25.614  33.810  1.00 47.82           C  
ATOM   1100  C   SER A 126     -14.266  25.791  32.823  1.00 45.71           C  
ATOM   1101  O   SER A 126     -13.927  26.914  32.494  1.00 44.87           O  
ATOM   1102  CB  SER A 126     -14.839  25.469  35.216  1.00 49.01           C  
ATOM   1103  OG  SER A 126     -15.885  25.313  36.151  1.00 55.61           O  
ATOM   1104  N   HIS A 127     -13.676  24.694  32.354  1.00 46.24           N  
ATOM   1105  CA  HIS A 127     -12.577  24.783  31.375  1.00 46.71           C  
ATOM   1106  C   HIS A 127     -13.007  25.444  30.060  1.00 48.38           C  
ATOM   1107  O   HIS A 127     -12.220  26.179  29.458  1.00 50.29           O  
ATOM   1108  CB  HIS A 127     -11.997  23.408  31.016  1.00 46.70           C  
ATOM   1109  CG  HIS A 127     -11.477  22.638  32.183  1.00 46.13           C  
ATOM   1110  ND1 HIS A 127     -11.401  21.263  32.185  1.00 43.83           N  
ATOM   1111  CD2 HIS A 127     -11.067  23.041  33.408  1.00 42.88           C  
ATOM   1112  CE1 HIS A 127     -10.923  20.856  33.347  1.00 42.32           C  
ATOM   1113  NE2 HIS A 127     -10.722  21.914  34.111  1.00 40.85           N  
ATOM   1114  N   PHE A 128     -14.227  25.159  29.597  1.00 48.57           N  
ATOM   1115  CA  PHE A 128     -14.717  25.759  28.342  1.00 49.06           C  
ATOM   1116  C   PHE A 128     -15.086  27.224  28.608  1.00 46.64           C  
ATOM   1117  O   PHE A 128     -14.854  28.088  27.776  1.00 45.64           O  
ATOM   1118  CB  PHE A 128     -15.884  24.953  27.752  1.00 50.08           C  
ATOM   1119  CG  PHE A 128     -16.070  25.139  26.257  1.00 55.15           C  
ATOM   1120  CD1 PHE A 128     -15.018  24.886  25.370  1.00 56.38           C  
ATOM   1121  CD2 PHE A 128     -17.311  25.491  25.729  1.00 58.09           C  
ATOM   1122  CE1 PHE A 128     -15.186  25.033  23.995  1.00 57.74           C  
ATOM   1123  CE2 PHE A 128     -17.487  25.631  24.355  1.00 55.24           C  
ATOM   1124  CZ  PHE A 128     -16.423  25.398  23.485  1.00 56.92           C  
ATOM   1125  N   PHE A 129     -15.648  27.489  29.784  1.00 46.61           N  
ATOM   1126  CA  PHE A 129     -15.943  28.855  30.208  1.00 45.56           C  
ATOM   1127  C   PHE A 129     -14.653  29.698  30.216  1.00 43.78           C  
ATOM   1128  O   PHE A 129     -14.637  30.772  29.622  1.00 41.62           O  
ATOM   1129  CB  PHE A 129     -16.644  28.903  31.595  1.00 46.48           C  
ATOM   1130  CG  PHE A 129     -16.823  30.302  32.122  1.00 47.33           C  
ATOM   1131  CD1 PHE A 129     -17.925  31.055  31.761  1.00 47.53           C  
ATOM   1132  CD2 PHE A 129     -15.857  30.890  32.923  1.00 47.61           C  
ATOM   1133  CE1 PHE A 129     -18.070  32.360  32.210  1.00 43.14           C  
ATOM   1134  CE2 PHE A 129     -16.001  32.194  33.352  1.00 50.78           C  
ATOM   1135  CZ  PHE A 129     -17.112  32.923  32.994  1.00 46.09           C  
ATOM   1136  N   TYR A 130     -13.589  29.207  30.860  1.00 43.39           N  
ATOM   1137  CA  TYR A 130     -12.302  29.938  30.905  1.00 46.42           C  
ATOM   1138  C   TYR A 130     -11.673  30.158  29.535  1.00 45.67           C  
ATOM   1139  O   TYR A 130     -11.130  31.216  29.284  1.00 45.36           O  
ATOM   1140  CB  TYR A 130     -11.265  29.271  31.826  1.00 49.90           C  
ATOM   1141  CG  TYR A 130     -11.634  29.298  33.295  1.00 51.91           C  
ATOM   1142  CD1 TYR A 130     -11.829  30.497  33.962  1.00 53.24           C  
ATOM   1143  CD2 TYR A 130     -11.767  28.120  34.012  1.00 54.13           C  
ATOM   1144  CE1 TYR A 130     -12.177  30.515  35.291  1.00 59.46           C  
ATOM   1145  CE2 TYR A 130     -12.124  28.121  35.330  1.00 55.19           C  
ATOM   1146  CZ  TYR A 130     -12.327  29.315  35.972  1.00 59.72           C  
ATOM   1147  OH  TYR A 130     -12.654  29.287  37.311  1.00 60.30           O  
ATOM   1148  N   GLU A 131     -11.749  29.169  28.664  1.00 47.30           N  
ATOM   1149  CA  GLU A 131     -11.196  29.289  27.312  1.00 51.52           C  
ATOM   1150  C   GLU A 131     -11.930  30.353  26.486  1.00 52.39           C  
ATOM   1151  O   GLU A 131     -11.306  31.063  25.678  1.00 51.45           O  
ATOM   1152  CB  GLU A 131     -11.188  27.920  26.631  1.00 52.65           C  
ATOM   1153  CG  GLU A 131     -10.153  26.985  27.264  1.00 57.97           C  
ATOM   1154  CD  GLU A 131     -10.367  25.518  26.950  1.00 64.51           C  
ATOM   1155  OE1 GLU A 131     -11.182  25.182  26.056  1.00 66.38           O  
ATOM   1156  OE2 GLU A 131      -9.706  24.696  27.617  1.00 67.57           O  
ATOM   1157  N   ASN A 132     -13.247  30.463  26.718  1.00 53.29           N  
ATOM   1158  CA  ASN A 132     -14.095  31.499  26.100  1.00 52.95           C  
ATOM   1159  C   ASN A 132     -13.843  32.899  26.682  1.00 53.09           C  
ATOM   1160  O   ASN A 132     -14.311  33.879  26.118  1.00 53.89           O  
ATOM   1161  CB  ASN A 132     -15.593  31.167  26.223  1.00 52.92           C  
ATOM   1162  CG  ASN A 132     -16.044  30.076  25.268  1.00 51.86           C  
ATOM   1163  OD1 ASN A 132     -16.657  29.097  25.690  1.00 54.49           O  
ATOM   1164  ND2 ASN A 132     -15.754  30.241  23.977  1.00 46.43           N  
ATOM   1165  N   GLN A 133     -13.144  33.003  27.815  1.00 52.44           N  
ATOM   1166  CA  GLN A 133     -12.765  34.304  28.354  1.00 51.66           C  
ATOM   1167  C   GLN A 133     -11.323  34.590  27.942  1.00 50.81           C  
ATOM   1168  O   GLN A 133     -10.729  35.533  28.444  1.00 51.92           O  
ATOM   1169  CB  GLN A 133     -12.883  34.362  29.883  1.00 53.17           C  
ATOM   1170  CG  GLN A 133     -14.189  33.824  30.512  1.00 54.04           C  
ATOM   1171  CD  GLN A 133     -15.448  34.280  29.789  1.00 61.91           C  
ATOM   1172  OE1 GLN A 133     -15.593  35.457  29.441  1.00 66.87           O  
ATOM   1173  NE2 GLN A 133     -16.375  33.343  29.563  1.00 54.89           N  
ATOM   1174  N   GLY A 134     -10.765  33.764  27.046  1.00 49.50           N  
ATOM   1175  CA  GLY A 134      -9.406  33.932  26.550  1.00 49.51           C  
ATOM   1176  C   GLY A 134      -8.256  33.308  27.328  1.00 50.56           C  
ATOM   1177  O   GLY A 134      -7.108  33.656  27.059  1.00 51.85           O  
ATOM   1178  N   PHE A 135      -8.529  32.404  28.282  1.00 49.58           N  
ATOM   1179  CA  PHE A 135      -7.449  31.724  29.037  1.00 49.43           C  
ATOM   1180  C   PHE A 135      -6.930  30.513  28.299  1.00 49.75           C  
ATOM   1181  O   PHE A 135      -7.733  29.754  27.742  1.00 48.64           O  
ATOM   1182  CB  PHE A 135      -7.905  31.216  30.398  1.00 47.44           C  
ATOM   1183  CG  PHE A 135      -8.023  32.273  31.422  1.00 49.73           C  
ATOM   1184  CD1 PHE A 135      -9.127  33.082  31.442  1.00 45.38           C  
ATOM   1185  CD2 PHE A 135      -7.035  32.456  32.384  1.00 47.72           C  
ATOM   1186  CE1 PHE A 135      -9.248  34.058  32.361  1.00 47.23           C  
ATOM   1187  CE2 PHE A 135      -7.152  33.448  33.320  1.00 45.89           C  
ATOM   1188  CZ  PHE A 135      -8.273  34.254  33.321  1.00 47.38           C  
ATOM   1189  N   LYS A 136      -5.606  30.320  28.341  1.00 48.45           N  
ATOM   1190  CA  LYS A 136      -4.947  29.172  27.726  1.00 48.59           C  
ATOM   1191  C   LYS A 136      -4.345  28.335  28.850  1.00 49.49           C  
ATOM   1192  O   LYS A 136      -3.902  28.889  29.849  1.00 48.91           O  
ATOM   1193  CB  LYS A 136      -3.864  29.637  26.756  1.00 49.05           C  
ATOM   1194  N   GLN A 137      -4.356  27.006  28.705  1.00 50.82           N  
ATOM   1195  CA  GLN A 137      -3.826  26.093  29.736  1.00 51.04           C  
ATOM   1196  C   GLN A 137      -2.304  26.180  29.774  1.00 50.98           C  
ATOM   1197  O   GLN A 137      -1.695  26.627  28.817  1.00 50.87           O  
ATOM   1198  CB  GLN A 137      -4.300  24.641  29.501  1.00 50.72           C  
ATOM   1199  CG  GLN A 137      -3.874  23.621  30.593  1.00 50.44           C  
ATOM   1200  CD  GLN A 137      -4.483  22.223  30.422  1.00 51.18           C  
ATOM   1201  OE1 GLN A 137      -5.238  21.960  29.480  1.00 49.71           O  
ATOM   1202  NE2 GLN A 137      -4.147  21.317  31.343  1.00 42.84           N  
ATOM   1203  N   ILE A 138      -1.713  25.797  30.904  1.00 52.88           N  
ATOM   1204  CA  ILE A 138      -0.269  25.823  31.098  1.00 53.94           C  
ATOM   1205  C   ILE A 138       0.119  24.752  32.121  1.00 54.62           C  
ATOM   1206  O   ILE A 138      -0.715  24.316  32.928  1.00 53.67           O  
ATOM   1207  CB  ILE A 138       0.216  27.238  31.560  1.00 54.43           C  
ATOM   1208  CG1 ILE A 138       1.695  27.465  31.223  1.00 57.30           C  
ATOM   1209  CG2 ILE A 138      -0.030  27.449  33.042  1.00 53.11           C  
ATOM   1210  CD1 ILE A 138       2.154  28.908  31.406  1.00 55.88           C  
ATOM   1211  N   THR A 139       1.383  24.335  32.078  1.00 56.92           N  
ATOM   1212  CA  THR A 139       1.910  23.314  32.977  1.00 58.64           C  
ATOM   1213  C   THR A 139       2.313  23.962  34.280  1.00 60.08           C  
ATOM   1214  O   THR A 139       2.740  25.121  34.307  1.00 59.99           O  
ATOM   1215  CB  THR A 139       3.173  22.626  32.404  1.00 59.77           C  
ATOM   1216  OG1 THR A 139       3.037  22.433  30.986  1.00 59.25           O  
ATOM   1217  CG2 THR A 139       3.438  21.289  33.113  1.00 59.27           C  
ATOM   1218  N   ARG A 140       2.197  23.201  35.359  1.00 62.46           N  
ATOM   1219  CA  ARG A 140       2.529  23.688  36.694  1.00 63.96           C  
ATOM   1220  C   ARG A 140       4.036  23.865  36.846  1.00 64.04           C  
ATOM   1221  O   ARG A 140       4.495  24.866  37.398  1.00 64.40           O  
ATOM   1222  CB  ARG A 140       1.969  22.723  37.739  1.00 65.03           C  
ATOM   1223  CG  ARG A 140       2.205  23.128  39.173  1.00 69.50           C  
ATOM   1224  CD  ARG A 140       1.183  22.459  40.092  1.00 76.24           C  
ATOM   1225  NE  ARG A 140       1.484  22.674  41.510  1.00 81.73           N  
ATOM   1226  CZ  ARG A 140       0.709  22.295  42.529  1.00 82.46           C  
ATOM   1227  NH1 ARG A 140      -0.451  21.665  42.323  1.00 81.53           N  
ATOM   1228  NH2 ARG A 140       1.101  22.558  43.776  1.00 81.86           N  
ATOM   1229  N   ASP A 141       4.796  22.891  36.343  1.00 63.96           N  
ATOM   1230  CA  ASP A 141       6.268  22.924  36.381  1.00 62.64           C  
ATOM   1231  C   ASP A 141       6.880  23.964  35.409  1.00 60.99           C  
ATOM   1232  O   ASP A 141       8.027  24.362  35.585  1.00 60.36           O  
ATOM   1233  CB  ASP A 141       6.842  21.524  36.107  1.00 62.29           C  
ATOM   1234  CG  ASP A 141       6.466  20.513  37.179  1.00 60.35           C  
ATOM   1235  N   GLU A 142       6.104  24.406  34.416  1.00 59.52           N  
ATOM   1236  CA  GLU A 142       6.550  25.389  33.424  1.00 58.48           C  
ATOM   1237  C   GLU A 142       6.088  26.830  33.668  1.00 57.15           C  
ATOM   1238  O   GLU A 142       6.490  27.734  32.944  1.00 56.01           O  
ATOM   1239  CB  GLU A 142       6.093  24.940  32.048  1.00 59.75           C  
ATOM   1240  CG  GLU A 142       6.647  23.565  31.670  1.00 61.88           C  
ATOM   1241  CD  GLU A 142       6.125  23.071  30.355  1.00 64.88           C  
ATOM   1242  OE1 GLU A 142       5.060  23.565  29.925  1.00 69.72           O  
ATOM   1243  OE2 GLU A 142       6.766  22.179  29.761  1.00 64.92           O  
ATOM   1244  N   LEU A 143       5.223  27.042  34.658  1.00 56.02           N  
ATOM   1245  CA  LEU A 143       4.783  28.390  35.025  1.00 54.81           C  
ATOM   1246  C   LEU A 143       5.647  28.821  36.198  1.00 52.93           C  
ATOM   1247  O   LEU A 143       5.688  28.112  37.198  1.00 54.63           O  
ATOM   1248  CB  LEU A 143       3.311  28.389  35.457  1.00 54.49           C  
ATOM   1249  CG  LEU A 143       2.719  29.721  35.952  1.00 54.88           C  
ATOM   1250  CD1 LEU A 143       2.751  30.799  34.877  1.00 51.64           C  
ATOM   1251  CD2 LEU A 143       1.294  29.520  36.445  1.00 53.14           C  
ATOM   1252  N   ASP A 144       6.345  29.950  36.082  1.00 49.38           N  
ATOM   1253  CA  ASP A 144       7.144  30.467  37.190  1.00 47.90           C  
ATOM   1254  C   ASP A 144       6.328  31.585  37.809  1.00 46.85           C  
ATOM   1255  O   ASP A 144       6.153  32.623  37.195  1.00 47.08           O  
ATOM   1256  CB  ASP A 144       8.500  30.986  36.715  1.00 49.58           C  
ATOM   1257  CG  ASP A 144       9.401  31.422  37.866  1.00 51.89           C  
ATOM   1258  OD1 ASP A 144       8.905  31.714  38.982  1.00 61.72           O  
ATOM   1259  OD2 ASP A 144      10.623  31.478  37.650  1.00 54.91           O  
ATOM   1260  N   VAL A 145       5.826  31.369  39.023  1.00 43.63           N  
ATOM   1261  CA  VAL A 145       4.991  32.353  39.689  1.00 41.42           C  
ATOM   1262  C   VAL A 145       5.192  32.233  41.219  1.00 39.62           C  
ATOM   1263  O   VAL A 145       5.387  31.136  41.744  1.00 39.50           O  
ATOM   1264  CB  VAL A 145       3.508  32.159  39.243  1.00 41.06           C  
ATOM   1265  CG1 VAL A 145       2.979  30.768  39.655  1.00 44.22           C  
ATOM   1266  CG2 VAL A 145       2.599  33.253  39.780  1.00 39.47           C  
ATOM   1267  N   ASP A 146       5.158  33.359  41.924  1.00 36.76           N  
ATOM   1268  CA  ASP A 146       5.369  33.377  43.374  1.00 37.03           C  
ATOM   1269  C   ASP A 146       4.064  33.017  44.072  1.00 35.09           C  
ATOM   1270  O   ASP A 146       3.520  33.791  44.846  1.00 34.43           O  
ATOM   1271  CB  ASP A 146       5.864  34.765  43.810  1.00 39.26           C  
ATOM   1272  CG  ASP A 146       6.375  34.800  45.250  1.00 45.84           C  
ATOM   1273  OD1 ASP A 146       6.858  33.767  45.757  1.00 54.20           O  
ATOM   1274  OD2 ASP A 146       6.322  35.885  45.867  1.00 54.09           O  
ATOM   1275  N   TYR A 147       3.591  31.808  43.803  1.00 34.81           N  
ATOM   1276  CA  TYR A 147       2.314  31.342  44.305  1.00 35.72           C  
ATOM   1277  C   TYR A 147       2.281  29.841  44.195  1.00 35.24           C  
ATOM   1278  O   TYR A 147       2.791  29.280  43.237  1.00 36.21           O  
ATOM   1279  CB  TYR A 147       1.193  31.956  43.462  1.00 37.01           C  
ATOM   1280  CG  TYR A 147      -0.193  31.607  43.924  1.00 37.06           C  
ATOM   1281  CD1 TYR A 147      -0.758  32.242  45.019  1.00 38.73           C  
ATOM   1282  CD2 TYR A 147      -0.951  30.660  43.244  1.00 36.02           C  
ATOM   1283  CE1 TYR A 147      -2.034  31.938  45.440  1.00 37.65           C  
ATOM   1284  CE2 TYR A 147      -2.207  30.351  43.657  1.00 36.93           C  
ATOM   1285  CZ  TYR A 147      -2.754  30.993  44.750  1.00 40.84           C  
ATOM   1286  OH  TYR A 147      -4.034  30.670  45.147  1.00 40.76           O  
ATOM   1287  N   ILE A 148       1.683  29.193  45.187  1.00 36.36           N  
ATOM   1288  CA  ILE A 148       1.562  27.748  45.187  1.00 35.80           C  
ATOM   1289  C   ILE A 148       0.085  27.409  45.093  1.00 36.90           C  
ATOM   1290  O   ILE A 148      -0.727  27.860  45.930  1.00 37.82           O  
ATOM   1291  CB  ILE A 148       2.165  27.107  46.470  1.00 34.21           C  
ATOM   1292  CG1 ILE A 148       3.619  27.550  46.709  1.00 34.00           C  
ATOM   1293  CG2 ILE A 148       2.097  25.577  46.386  1.00 34.99           C  
ATOM   1294  CD1 ILE A 148       4.607  26.924  45.850  1.00 34.20           C  
ATOM   1295  N   PHE A 149      -0.259  26.645  44.059  1.00 36.87           N  
ATOM   1296  CA  PHE A 149      -1.619  26.178  43.843  1.00 39.17           C  
ATOM   1297  C   PHE A 149      -1.857  24.978  44.759  1.00 40.99           C  
ATOM   1298  O   PHE A 149      -0.924  24.211  45.035  1.00 38.85           O  
ATOM   1299  CB  PHE A 149      -1.836  25.772  42.372  1.00 41.65           C  
ATOM   1300  CG  PHE A 149      -1.564  26.881  41.393  1.00 37.80           C  
ATOM   1301  CD1 PHE A 149      -2.513  27.850  41.140  1.00 43.09           C  
ATOM   1302  CD2 PHE A 149      -0.346  26.976  40.765  1.00 42.11           C  
ATOM   1303  CE1 PHE A 149      -2.241  28.889  40.241  1.00 37.59           C  
ATOM   1304  CE2 PHE A 149      -0.074  28.009  39.874  1.00 46.92           C  
ATOM   1305  CZ  PHE A 149      -1.029  28.965  39.625  1.00 41.91           C  
ATOM   1306  N   PRO A 150      -3.109  24.777  45.209  1.00 45.46           N  
ATOM   1307  CA  PRO A 150      -3.373  23.654  46.120  1.00 47.87           C  
ATOM   1308  C   PRO A 150      -3.003  22.296  45.519  1.00 49.85           C  
ATOM   1309  O   PRO A 150      -3.023  22.131  44.290  1.00 50.02           O  
ATOM   1310  CB  PRO A 150      -4.876  23.772  46.414  1.00 48.22           C  
ATOM   1311  CG  PRO A 150      -5.423  24.655  45.354  1.00 47.68           C  
ATOM   1312  CD  PRO A 150      -4.328  25.549  44.910  1.00 47.02           C  
ATOM   1313  N   ASP A 151      -2.637  21.350  46.387  1.00 52.94           N  
ATOM   1314  CA  ASP A 151      -2.208  20.007  45.948  1.00 56.33           C  
ATOM   1315  C   ASP A 151      -3.433  19.129  45.642  1.00 56.81           C  
ATOM   1316  O   ASP A 151      -3.834  18.272  46.447  1.00 55.59           O  
ATOM   1317  CB  ASP A 151      -1.273  19.357  46.993  1.00 56.87           C  
ATOM   1318  CG  ASP A 151      -0.467  18.189  46.431  1.00 61.65           C  
ATOM   1319  OD1 ASP A 151      -0.647  17.842  45.245  1.00 68.90           O  
ATOM   1320  OD2 ASP A 151       0.367  17.625  47.178  1.00 64.86           O  
ATOM   1321  N   ARG A 152      -4.028  19.389  44.474  1.00 57.73           N  
ATOM   1322  CA  ARG A 152      -5.207  18.671  43.983  1.00 59.16           C  
ATOM   1323  C   ARG A 152      -5.000  18.350  42.514  1.00 57.68           C  
ATOM   1324  O   ARG A 152      -4.039  18.816  41.889  1.00 56.08           O  
ATOM   1325  CB  ARG A 152      -6.475  19.521  44.130  1.00 59.14           C  
ATOM   1326  CG  ARG A 152      -6.850  19.845  45.575  1.00 62.98           C  
ATOM   1327  CD  ARG A 152      -7.869  20.982  45.679  1.00 62.68           C  
ATOM   1328  NE  ARG A 152      -7.777  21.609  47.002  1.00 66.82           N  
ATOM   1329  CZ  ARG A 152      -8.125  22.870  47.292  1.00 71.85           C  
ATOM   1330  NH1 ARG A 152      -8.603  23.694  46.349  1.00 67.33           N  
ATOM   1331  NH2 ARG A 152      -7.965  23.319  48.545  1.00 67.60           N  
ATOM   1332  N   ASP A 153      -5.900  17.533  41.978  1.00 57.65           N  
ATOM   1333  CA  ASP A 153      -5.891  17.182  40.559  1.00 56.49           C  
ATOM   1334  C   ASP A 153      -6.566  18.393  39.881  1.00 53.87           C  
ATOM   1335  O   ASP A 153      -7.791  18.427  39.718  1.00 52.79           O  
ATOM   1336  CB  ASP A 153      -6.653  15.867  40.335  1.00 56.57           C  
ATOM   1337  CG  ASP A 153      -6.581  15.374  38.898  1.00 59.79           C  
ATOM   1338  OD1 ASP A 153      -5.581  15.668  38.203  1.00 63.02           O  
ATOM   1339  OD2 ASP A 153      -7.527  14.672  38.474  1.00 61.38           O  
ATOM   1340  N   SER A 154      -5.749  19.379  39.510  0.50 52.82           N  
ATOM   1342  CA  SER A 154      -6.238  20.626  38.924  0.50 51.85           C  
ATOM   1344  C   SER A 154      -5.374  21.113  37.765  0.50 50.69           C  
ATOM   1346  O   SER A 154      -4.186  20.813  37.707  0.50 52.51           O  
ATOM   1348  CB  SER A 154      -6.290  21.711  40.007  0.50 51.73           C  
ATOM   1350  OG  SER A 154      -7.136  21.324  41.074  0.50 50.59           O  
ATOM   1352  N   ARG A 155      -5.986  21.869  36.853  1.00 48.98           N  
ATOM   1353  CA  ARG A 155      -5.295  22.436  35.694  1.00 45.63           C  
ATOM   1354  C   ARG A 155      -5.012  23.885  35.966  1.00 43.70           C  
ATOM   1355  O   ARG A 155      -5.834  24.557  36.600  1.00 41.33           O  
ATOM   1356  CB  ARG A 155      -6.196  22.463  34.469  1.00 45.97           C  
ATOM   1357  CG  ARG A 155      -6.679  21.162  34.017  1.00 46.11           C  
ATOM   1358  CD  ARG A 155      -7.352  21.330  32.687  1.00 46.41           C  
ATOM   1359  NE  ARG A 155      -7.845  20.052  32.208  1.00 43.20           N  
ATOM   1360  CZ  ARG A 155      -8.405  19.871  31.020  1.00 44.96           C  
ATOM   1361  NH1 ARG A 155      -8.562  20.891  30.182  1.00 43.60           N  
ATOM   1362  NH2 ARG A 155      -8.825  18.661  30.674  1.00 42.08           N  
ATOM   1363  N   ILE A 156      -3.878  24.369  35.460  1.00 41.93           N  
ATOM   1364  CA  ILE A 156      -3.506  25.766  35.586  1.00 42.76           C  
ATOM   1365  C   ILE A 156      -3.756  26.451  34.231  1.00 42.58           C  
ATOM   1366  O   ILE A 156      -3.372  25.932  33.179  1.00 41.35           O  
ATOM   1367  CB  ILE A 156      -2.035  25.958  36.107  1.00 42.57           C  
ATOM   1368  CG1 ILE A 156      -1.923  25.648  37.600  1.00 48.11           C  
ATOM   1369  CG2 ILE A 156      -1.600  27.419  36.028  1.00 42.06           C  
ATOM   1370  CD1 ILE A 156      -2.271  24.277  38.021  1.00 54.17           C  
ATOM   1371  N   TYR A 157      -4.426  27.602  34.287  1.00 44.13           N  
ATOM   1372  CA  TYR A 157      -4.760  28.442  33.126  1.00 44.60           C  
ATOM   1373  C   TYR A 157      -4.148  29.851  33.269  1.00 45.26           C  
ATOM   1374  O   TYR A 157      -3.983  30.352  34.386  1.00 43.81           O  
ATOM   1375  CB  TYR A 157      -6.286  28.569  32.986  1.00 46.05           C  
ATOM   1376  CG  TYR A 157      -6.952  27.397  32.313  1.00 46.00           C  
ATOM   1377  CD1 TYR A 157      -6.991  27.315  30.937  1.00 48.26           C  
ATOM   1378  CD2 TYR A 157      -7.550  26.384  33.048  1.00 49.46           C  
ATOM   1379  CE1 TYR A 157      -7.586  26.253  30.297  1.00 49.92           C  
ATOM   1380  CE2 TYR A 157      -8.151  25.309  32.418  1.00 48.49           C  
ATOM   1381  CZ  TYR A 157      -8.162  25.251  31.034  1.00 51.64           C  
ATOM   1382  OH  TYR A 157      -8.758  24.203  30.374  1.00 46.91           O  
ATOM   1383  N   VAL A 158      -3.834  30.480  32.139  0.50 45.37           N  
ATOM   1385  CA  VAL A 158      -3.235  31.819  32.130  0.50 45.45           C  
ATOM   1387  C   VAL A 158      -3.831  32.702  31.025  0.50 46.07           C  
ATOM   1389  O   VAL A 158      -4.190  32.210  29.951  0.50 45.49           O  
ATOM   1391  CB  VAL A 158      -1.688  31.747  31.975  0.50 44.77           C  
ATOM   1393  CG1 VAL A 158      -1.286  31.107  30.640  0.50 40.61           C  
ATOM   1395  CG2 VAL A 158      -1.059  33.125  32.120  0.50 45.94           C  
ATOM   1397  N   LYS A 159      -3.940  33.999  31.305  1.00 46.35           N  
ATOM   1398  CA  LYS A 159      -4.449  34.985  30.349  1.00 47.83           C  
ATOM   1399  C   LYS A 159      -3.527  36.203  30.403  1.00 49.01           C  
ATOM   1400  O   LYS A 159      -3.404  36.849  31.447  1.00 46.98           O  
ATOM   1401  CB  LYS A 159      -5.882  35.396  30.699  1.00 48.15           C  
ATOM   1402  CG  LYS A 159      -6.522  36.434  29.757  1.00 49.04           C  
ATOM   1403  CD  LYS A 159      -7.912  36.824  30.277  1.00 49.67           C  
ATOM   1404  CE  LYS A 159      -8.556  37.989  29.530  1.00 46.69           C  
ATOM   1405  NZ  LYS A 159      -8.899  37.631  28.128  1.00 44.84           N  
ATOM   1406  N   LEU A 160      -2.876  36.508  29.282  1.00 51.07           N  
ATOM   1407  CA  LEU A 160      -1.986  37.678  29.183  1.00 52.47           C  
ATOM   1408  C   LEU A 160      -2.813  38.879  28.733  1.00 53.62           C  
ATOM   1409  O   LEU A 160      -3.554  38.780  27.749  1.00 55.02           O  
ATOM   1410  CB  LEU A 160      -0.828  37.427  28.204  1.00 50.62           C  
ATOM   1411  CG  LEU A 160       0.076  36.225  28.516  1.00 51.47           C  
ATOM   1412  CD1 LEU A 160       1.257  36.149  27.568  1.00 50.19           C  
ATOM   1413  CD2 LEU A 160       0.584  36.276  29.948  1.00 54.13           C  
ATOM   1414  N   LEU A 161      -2.688  40.002  29.446  1.00 53.76           N  
ATOM   1415  CA  LEU A 161      -3.455  41.213  29.137  1.00 54.35           C  
ATOM   1416  C   LEU A 161      -2.769  42.144  28.117  1.00 54.68           C  
ATOM   1417  O   LEU A 161      -1.587  42.450  28.228  1.00 55.83           O  
ATOM   1418  CB  LEU A 161      -3.779  41.970  30.429  1.00 53.37           C  
ATOM   1419  CG  LEU A 161      -4.555  41.166  31.481  1.00 54.29           C  
ATOM   1420  CD1 LEU A 161      -4.931  42.043  32.672  1.00 53.54           C  
ATOM   1421  CD2 LEU A 161      -5.799  40.528  30.878  1.00 55.51           C  
TER    1422      LEU A 161                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
