
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  135 ( 1060),  selected  135 , name 2fhq_A
# Molecule2: number of CA atoms  124 (  982),  selected  124 , name T0402.pdb
# PARAMETERS: 2fhq_A.T0402.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     3_A      -       -           -
LGA    K     4_A      E       4          2.961
LGA    T     5_A      L       5          2.690
LGA    X     6_A      -       -           -
LGA    K     7_A      E       6          3.316
LGA    E     8_A      D       7          2.268
LGA    K     9_A      K       8          1.264
LGA    A    10_A      I       9          1.839
LGA    V    11_A      L      10          1.320
LGA    E    12_A      A      11          0.693
LGA    L    13_A      I      12          1.086
LGA    L    14_A      L      13          1.201
LGA    Q    15_A      E      14          0.531
LGA    K    16_A      Q      15          0.373
LGA    C    17_A      H      16          0.216
LGA    E    18_A      Q      17          1.536
LGA    V    19_A      V      18          0.828
LGA    V    20_A      G      19          1.435
LGA    T    21_A      V      20          1.149
LGA    L    22_A      L      21          0.977
LGA    A    23_A      T      22          1.320
LGA    S    24_A      S      23          0.957
LGA    V    25_A      V      24          0.416
LGA    N    26_A      Q      25          0.849
LGA    K    27_A      G      26          2.884
LGA    E    28_A      -       -           -
LGA    G    29_A      D      27          1.479
LGA    Y    30_A      F      28          0.925
LGA    P    31_A      P      29          1.258
LGA    R    32_A      H      30          0.925
LGA    P    33_A      A      31          1.222
LGA    V    34_A      R      32          0.817
LGA    P    35_A      Y      33          1.014
LGA    X    36_A      M      34          1.202
LGA    S    37_A      T      35          0.871
LGA    K    38_A      F      36          1.531
LGA    I    39_A      L      37          2.596
LGA    A    40_A      H      38          2.900
LGA    A    41_A      -       -           -
LGA    E    42_A      D      39          2.638
LGA    G    43_A      G      40          2.980
LGA    I    44_A      -       -           -
LGA    S    45_A      L      41          2.562
LGA    T    46_A      T      42          0.656
LGA    I    47_A      L      43          0.424
LGA    W    48_A      Y      44          0.894
LGA    X    49_A      T      45          0.968
LGA    S    50_A      P      46          0.771
LGA    T    51_A      S      47          0.414
LGA    G    52_A      G      48          0.406
LGA    A    53_A      K      49          0.624
LGA    D    54_A      E      50          0.504
LGA    S    55_A      L      51          0.676
LGA    L    56_A      P      52          0.572
LGA    K    57_A      K      53          0.682
LGA    T    58_A      T      54          0.626
LGA    I    59_A      E      55          0.634
LGA    D    60_A      E      56          0.458
LGA    F    61_A      V      57          0.845
LGA    L    62_A      R      58          0.938
LGA    S    63_A      R      59          0.803
LGA    N    64_A      N      60          0.712
LGA    P    65_A      P      61          0.703
LGA    K    66_A      H      62          0.720
LGA    A    67_A      V      63          0.714
LGA    G    68_A      C      64          0.671
LGA    L    69_A      V      65          0.642
LGA    C    70_A      L      66          0.902
LGA    F    71_A      I      67          0.590
LGA    Q    72_A      G      68          1.929
LGA    E    73_A      Y      69          3.826
LGA    -       -      D      70           -
LGA    K    74_A      S      71          3.928
LGA    G    75_A      P      72          3.744
LGA    -       -      G      73           -
LGA    -       -      S      74           -
LGA    D    76_A      A      75          1.538
LGA    S    77_A      F      76          1.644
LGA    V    78_A      L      77          0.888
LGA    A    79_A      E      78          0.567
LGA    L    80_A      I      79          0.615
LGA    X    81_A      N      80          0.235
LGA    G    82_A      G      81          0.737
LGA    E    83_A      L      82          0.544
LGA    V    84_A      A      83          0.417
LGA    E    85_A      S      84          0.760
LGA    V    86_A      L      85          0.898
LGA    V    87_A      E      86          1.785
LGA    T    88_A      E      87          3.768
LGA    D    89_A      D      88          2.801
LGA    E    90_A      E      89          1.969
LGA    K    91_A      S      90          1.499
LGA    L    92_A      I      91          1.417
LGA    K    93_A      K      92          1.550
LGA    Q    94_A      E      93          1.287
LGA    E    95_A      R      94          1.699
LGA    L    96_A      I      95          1.596
LGA    W    97_A      W      96          1.704
LGA    Q    98_A      E      97          3.107
LGA    -       -      N      98           -
LGA    -       -      I      99           -
LGA    D    99_A      S     100          1.942
LGA    W   100_A      K     101          5.190
LGA    F   101_A      D     102           -
LGA    -       -      W     103           -
LGA    I   102_A      F     104          5.684
LGA    E   103_A      Q     105           -
LGA    H   104_A      G     106           -
LGA    F   105_A      -       -           -
LGA    P   106_A      -       -           -
LGA    G   107_A      E     107          4.847
LGA    G   108_A      D     108          1.555
LGA    P   109_A      -       -           -
LGA    T   110_A      -       -           -
LGA    D   111_A      S     109          2.292
LGA    P   112_A      P     110          1.951
LGA    G   113_A      S     111          0.100
LGA    Y   114_A      F     112          0.597
LGA    V   115_A      V     113          0.338
LGA    L   116_A      V     114          0.512
LGA    L   117_A      I     115          0.571
LGA    K   118_A      K     116          0.422
LGA    F   119_A      I     117          0.352
LGA    T   120_A      V     118          0.478
LGA    A   121_A      P     119          0.464
LGA    N   122_A      E     120          0.484
LGA    H   123_A      Q     121          0.930
LGA    A   124_A      I     122          1.797
LGA    T   125_A      R     123          2.275
LGA    Y   126_A      I     124          1.617
LGA    W   127_A      L     125          1.276
LGA    I   128_A      N     126          3.749
LGA    E   129_A      S     127          2.647
LGA    G   130_A      -       -           -
LGA    T   131_A      -       -           -
LGA    F   132_A      -       -           -
LGA    I   133_A      -       -           -
LGA    H   134_A      -       -           -
LGA    K   135_A      -       -           -
LGA    K   136_A      -       -           -
LGA    L   137_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  135  124    5.0    115    1.80    19.13     85.105     6.059

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.608222 * X  +   0.362393 * Y  +  -0.706214 * Z  +  36.695984
  Y_new =  -0.736153 * X  +  -0.590302 * Y  +   0.331094 * Z  +  32.740566
  Z_new =  -0.296893 * X  +   0.721260 * Y  +   0.625811 * Z  + -16.179846 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.856137   -2.285456  [ DEG:    49.0530   -130.9470 ]
  Theta =   0.301438    2.840155  [ DEG:    17.2711    162.7289 ]
  Phi   =  -2.261320    0.880273  [ DEG:  -129.5641     50.4359 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fhq_A                                        
REMARK     2: T0402.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fhq_A.T0402.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  135  124   5.0  115   1.80   19.13  85.105
REMARK  ---------------------------------------------------------- 
MOLECULE 2fhq_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   26-DEC-05   2FHQ              
TITLE     CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN FROM                      
TITLE    2 BACTEROIDES THETAIOTAOMICRON                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE GENERAL STRESS PROTEIN;                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACTEROIDES THETAIOTAOMICRON;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: VPI-5482;                                                    
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21DE3;                                   
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    ALPHA-BETA STRUCTURE, STRUCTURAL GENOMICS, PSI, PROTEIN               
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,C.HATZOS,J.ABDULLAH,A.JOACHIMIAK,MIDWEST CENTER FOR             
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   07-FEB-06 2FHQ    0                                                
JRNL        AUTH   Y.KIM,C.HATZOS,J.ABDULLAH,A.JOACHIMIAK                       
JRNL        TITL   CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN FROM             
JRNL        TITL 2 BACTEROIDES THETAIOTAOMICRON                                 
JRNL        REF    TO BE PUBLISHED                            2006              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.87 ANGSTROMS.                                          
DBREF  2FHQ A    1   138  GB     29338736 AAO76536         1    138             
DBREF  2FHQ B    1   138  GB     29338736 AAO76536         1    138             
SEQRES   1 A  141  SER ASN ALA MSE SER THR LYS THR MSE LYS GLU LYS ALA          
SEQRES   2 A  141  VAL GLU LEU LEU GLN LYS CYS GLU VAL VAL THR LEU ALA          
SEQRES   3 A  141  SER VAL ASN LYS GLU GLY TYR PRO ARG PRO VAL PRO MSE          
SEQRES   4 A  141  SER LYS ILE ALA ALA GLU GLY ILE SER THR ILE TRP MSE          
SEQRES   5 A  141  SER THR GLY ALA ASP SER LEU LYS THR ILE ASP PHE LEU          
SEQRES   6 A  141  SER ASN PRO LYS ALA GLY LEU CYS PHE GLN GLU LYS GLY          
SEQRES   7 A  141  ASP SER VAL ALA LEU MSE GLY GLU VAL GLU VAL VAL THR          
SEQRES   8 A  141  ASP GLU LYS LEU LYS GLN GLU LEU TRP GLN ASP TRP PHE          
SEQRES   9 A  141  ILE GLU HIS PHE PRO GLY GLY PRO THR ASP PRO GLY TYR          
SEQRES  10 A  141  VAL LEU LEU LYS PHE THR ALA ASN HIS ALA THR TYR TRP          
SEQRES  11 A  141  ILE GLU GLY THR PHE ILE HIS LYS LYS LEU ASP                  
SEQRES   1 B  141  SER ASN ALA MSE SER THR LYS THR MSE LYS GLU LYS ALA          
SEQRES   2 B  141  VAL GLU LEU LEU GLN LYS CYS GLU VAL VAL THR LEU ALA          
SEQRES   3 B  141  SER VAL ASN LYS GLU GLY TYR PRO ARG PRO VAL PRO MSE          
SEQRES   4 B  141  SER LYS ILE ALA ALA GLU GLY ILE SER THR ILE TRP MSE          
SEQRES   5 B  141  SER THR GLY ALA ASP SER LEU LYS THR ILE ASP PHE LEU          
SEQRES   6 B  141  SER ASN PRO LYS ALA GLY LEU CYS PHE GLN GLU LYS GLY          
SEQRES   7 B  141  ASP SER VAL ALA LEU MSE GLY GLU VAL GLU VAL VAL THR          
SEQRES   8 B  141  ASP GLU LYS LEU LYS GLN GLU LEU TRP GLN ASP TRP PHE          
SEQRES   9 B  141  ILE GLU HIS PHE PRO GLY GLY PRO THR ASP PRO GLY TYR          
SEQRES  10 B  141  VAL LEU LEU LYS PHE THR ALA ASN HIS ALA THR TYR TRP          
SEQRES  11 B  141  ILE GLU GLY THR PHE ILE HIS LYS LYS LEU ASP                  
HET    MSE  A   6       8                                                       
HET    MSE  A  36       8                                                       
HET    MSE  A  49       8                                                       
HET    MSE  A  81      16                                                       
HET    MSE  B   6       8                                                       
HET    MSE  B  36       8                                                       
HET    MSE  B  49       8                                                       
HET    MSE  B  81       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *225(H2 O)                                                    
CRYST1   44.223   66.280   50.690  90.00 114.77  90.00 P 1 21 1      4          
ATOM      1  N   THR A   3     -18.681  -1.685  16.401  1.00 41.99           N  
ATOM      2  CA  THR A   3     -17.234  -1.455  16.109  1.00 41.94           C  
ATOM      3  C   THR A   3     -16.946  -0.016  15.692  1.00 41.48           C  
ATOM      4  O   THR A   3     -17.666   0.555  14.868  1.00 42.89           O  
ATOM      5  CB  THR A   3     -16.733  -2.351  14.972  1.00 41.88           C  
ATOM      6  OG1 THR A   3     -17.490  -2.060  13.793  1.00 43.50           O  
ATOM      7  CG2 THR A   3     -16.852  -3.838  15.331  1.00 41.70           C  
ATOM      8  N   LYS A   4     -15.860   0.535  16.225  1.00 39.32           N  
ATOM      9  CA  LYS A   4     -15.439   1.892  15.931  1.00 37.25           C  
ATOM     10  C   LYS A   4     -14.467   1.927  14.770  1.00 35.17           C  
ATOM     11  O   LYS A   4     -13.580   1.093  14.679  1.00 34.37           O  
ATOM     12  CB  LYS A   4     -14.773   2.508  17.156  1.00 37.49           C  
ATOM     13  CG  LYS A   4     -15.715   2.768  18.299  1.00 40.03           C  
ATOM     14  CD  LYS A   4     -15.764   1.588  19.268  1.00 43.86           C  
ATOM     15  CE  LYS A   4     -16.536   1.965  20.531  1.00 45.70           C  
ATOM     16  NZ  LYS A   4     -16.143   3.317  21.042  1.00 48.69           N  
ATOM     17  N   THR A   5     -14.630   2.914  13.896  1.00 33.47           N  
ATOM     18  CA  THR A   5     -13.716   3.130  12.779  1.00 32.23           C  
ATOM     19  C   THR A   5     -12.405   3.683  13.316  1.00 31.69           C  
ATOM     20  O   THR A   5     -12.335   4.077  14.481  1.00 31.66           O  
ATOM     21  CB  THR A   5     -14.268   4.167  11.802  1.00 32.59           C  
ATOM     22  OG1 THR A   5     -14.451   5.418  12.492  1.00 30.67           O  
ATOM     23  CG2 THR A   5     -15.590   3.686  11.179  1.00 32.61           C  
HETATM   24  N   MSE A   6     -11.374   3.701  12.483  1.00 30.27           N  
HETATM   25  CA  MSE A   6     -10.133   4.384  12.819  1.00 30.02           C  
HETATM   26  C   MSE A   6     -10.387   5.841  13.286  1.00 29.43           C  
HETATM   27  O   MSE A   6      -9.763   6.316  14.254  1.00 28.85           O  
HETATM   28  CB  MSE A   6      -9.197   4.378  11.621  1.00 29.69           C  
HETATM   29  CG  MSE A   6      -8.477   3.044  11.361  1.00 31.13           C  
HETATM   30 SE   MSE A   6      -7.554   2.363  12.905  0.70 32.66          SE  
HETATM   31  CE  MSE A   6      -5.982   1.695  11.997  1.00 31.23           C  
ATOM     32  N   LYS A   7     -11.284   6.548  12.606  1.00 29.55           N  
ATOM     33  CA  LYS A   7     -11.611   7.929  13.009  1.00 29.77           C  
ATOM     34  C   LYS A   7     -12.177   8.031  14.418  1.00 30.38           C  
ATOM     35  O   LYS A   7     -11.724   8.847  15.233  1.00 29.80           O  
ATOM     36  CB  LYS A   7     -12.542   8.591  12.011  1.00 30.56           C  
ATOM     37  CG  LYS A   7     -12.966  10.010  12.437  1.00 31.33           C  
ATOM     38  CD  LYS A   7     -12.954  10.977  11.280  1.00 33.72           C  
ATOM     39  CE  LYS A   7     -14.194  10.848  10.454  1.00 34.96           C  
ATOM     40  NZ  LYS A   7     -14.413  12.137   9.728  1.00 37.88           N  
ATOM     41  N   GLU A   8     -13.149   7.181  14.717  1.00 30.77           N  
ATOM     42  CA  GLU A   8     -13.774   7.135  16.029  1.00 31.03           C  
ATOM     43  C   GLU A   8     -12.781   6.736  17.135  1.00 31.71           C  
ATOM     44  O   GLU A   8     -12.810   7.276  18.253  1.00 31.56           O  
ATOM     45  CB  GLU A   8     -14.968   6.189  15.987  1.00 30.82           C  
ATOM     46  CG  GLU A   8     -16.105   6.686  15.084  1.00 31.48           C  
ATOM     47  CD  GLU A   8     -17.250   5.690  14.921  1.00 32.45           C  
ATOM     48  OE1 GLU A   8     -18.418   6.135  14.843  1.00 36.32           O  
ATOM     49  OE2 GLU A   8     -16.999   4.472  14.833  1.00 32.29           O  
ATOM     50  N   LYS A   9     -11.900   5.796  16.817  1.00 30.86           N  
ATOM     51  CA  LYS A   9     -10.820   5.400  17.724  1.00 31.56           C  
ATOM     52  C   LYS A   9      -9.848   6.567  18.003  1.00 31.13           C  
ATOM     53  O   LYS A   9      -9.392   6.756  19.143  1.00 30.80           O  
ATOM     54  CB  LYS A   9     -10.046   4.217  17.111  1.00 32.19           C  
ATOM     55  CG  LYS A   9     -10.895   2.983  16.786  1.00 33.66           C  
ATOM     56  CD  LYS A   9     -10.929   1.958  17.930  1.00 37.99           C  
ATOM     57  CE  LYS A   9     -11.639   2.494  19.166  1.00 39.34           C  
ATOM     58  NZ  LYS A   9     -11.157   1.835  20.424  1.00 41.57           N  
ATOM     59  N   ALA A  10      -9.534   7.326  16.949  1.00 30.64           N  
ATOM     60  CA  ALA A  10      -8.662   8.486  17.057  1.00 30.77           C  
ATOM     61  C   ALA A  10      -9.280   9.592  17.922  1.00 30.72           C  
ATOM     62  O   ALA A  10      -8.584  10.238  18.703  1.00 31.59           O  
ATOM     63  CB  ALA A  10      -8.339   9.003  15.720  1.00 30.46           C  
ATOM     64  N   VAL A  11     -10.586   9.808  17.784  1.00 30.78           N  
ATOM     65  CA  VAL A  11     -11.298  10.781  18.627  1.00 30.33           C  
ATOM     66  C   VAL A  11     -11.153  10.404  20.108  1.00 31.74           C  
ATOM     67  O   VAL A  11     -10.786  11.240  20.946  1.00 29.70           O  
ATOM     68  CB  VAL A  11     -12.785  10.941  18.196  1.00 30.37           C  
ATOM     69  CG1 VAL A  11     -13.566  11.849  19.168  1.00 28.62           C  
ATOM     70  CG2 VAL A  11     -12.863  11.478  16.786  1.00 28.22           C  
ATOM     71  N   GLU A  12     -11.376   9.122  20.410  1.00 32.64           N  
ATOM     72  CA  GLU A  12     -11.189   8.601  21.759  1.00 34.47           C  
ATOM     73  C   GLU A  12      -9.777   8.829  22.286  1.00 34.59           C  
ATOM     74  O   GLU A  12      -9.588   9.228  23.429  1.00 35.47           O  
ATOM     75  CB  GLU A  12     -11.488   7.109  21.783  1.00 34.64           C  
ATOM     76  CG  GLU A  12     -12.952   6.774  21.933  1.00 39.14           C  
ATOM     77  CD  GLU A  12     -13.165   5.332  22.354  1.00 43.71           C  
ATOM     78  OE1 GLU A  12     -13.886   5.097  23.354  1.00 44.70           O  
ATOM     79  OE2 GLU A  12     -12.586   4.437  21.700  1.00 45.66           O  
ATOM     80  N   LEU A  13      -8.793   8.557  21.438  1.00 34.99           N  
ATOM     81  CA  LEU A  13      -7.378   8.744  21.762  1.00 35.02           C  
ATOM     82  C   LEU A  13      -7.086  10.215  22.111  1.00 34.34           C  
ATOM     83  O   LEU A  13      -6.389  10.513  23.098  1.00 34.52           O  
ATOM     84  CB  LEU A  13      -6.560   8.367  20.526  1.00 35.14           C  
ATOM     85  CG  LEU A  13      -5.383   7.395  20.509  1.00 37.61           C  
ATOM     86  CD1 LEU A  13      -4.464   7.535  21.719  1.00 37.77           C  
ATOM     87  CD2 LEU A  13      -5.912   5.963  20.376  1.00 37.16           C  
ATOM     88  N   LEU A  14      -7.610  11.119  21.280  1.00 33.87           N  
ATOM     89  CA  LEU A  14      -7.372  12.559  21.426  1.00 32.96           C  
ATOM     90  C   LEU A  14      -7.931  13.052  22.740  1.00 34.40           C  
ATOM     91  O   LEU A  14      -7.267  13.798  23.453  1.00 34.52           O  
ATOM     92  CB  LEU A  14      -7.983  13.356  20.267  1.00 31.73           C  
ATOM     93  CG  LEU A  14      -7.546  14.835  20.179  1.00 29.50           C  
ATOM     94  CD1 LEU A  14      -6.029  15.032  20.408  1.00 27.82           C  
ATOM     95  CD2 LEU A  14      -7.969  15.425  18.842  1.00 30.07           C  
ATOM     96  N   GLN A  15      -9.153  12.633  23.050  1.00 36.32           N  
ATOM     97  CA  GLN A  15      -9.806  13.013  24.306  1.00 38.85           C  
ATOM     98  C   GLN A  15      -8.927  12.685  25.523  1.00 38.96           C  
ATOM     99  O   GLN A  15      -9.051  13.320  26.579  1.00 39.34           O  
ATOM    100  CB  GLN A  15     -11.217  12.390  24.404  1.00 38.81           C  
ATOM    101  CG  GLN A  15     -12.243  13.052  23.454  1.00 40.14           C  
ATOM    102  CD  GLN A  15     -13.566  12.272  23.282  1.00 40.61           C  
ATOM    103  OE1 GLN A  15     -13.680  11.087  23.642  1.00 42.31           O  
ATOM    104  NE2 GLN A  15     -14.559  12.940  22.704  1.00 41.60           N  
ATOM    105  N   LYS A  16      -8.010  11.734  25.352  1.00 39.66           N  
ATOM    106  CA  LYS A  16      -7.083  11.328  26.418  1.00 40.19           C  
ATOM    107  C   LYS A  16      -5.792  12.135  26.434  1.00 39.33           C  
ATOM    108  O   LYS A  16      -5.045  12.082  27.414  1.00 39.78           O  
ATOM    109  CB  LYS A  16      -6.742   9.835  26.306  1.00 40.38           C  
ATOM    110  CG  LYS A  16      -7.952   8.884  26.521  1.00 42.20           C  
ATOM    111  CD  LYS A  16      -7.581   7.404  26.345  1.00 42.70           C  
ATOM    112  CE  LYS A  16      -7.148   6.749  27.664  1.00 47.55           C  
ATOM    113  NZ  LYS A  16      -6.096   7.504  28.429  1.00 49.96           N  
ATOM    114  N   CYS A  17      -5.510  12.855  25.345  1.00 37.79           N  
ATOM    115  CA  CYS A  17      -4.273  13.626  25.230  1.00 36.29           C  
ATOM    116  C   CYS A  17      -4.510  15.088  25.592  1.00 34.97           C  
ATOM    117  O   CYS A  17      -5.464  15.707  25.105  1.00 34.78           O  
ATOM    118  CB  CYS A  17      -3.689  13.531  23.812  1.00 35.78           C  
ATOM    119  SG  CYS A  17      -3.287  11.871  23.261  1.00 39.16           S  
ATOM    120  N   GLU A  18      -3.665  15.641  26.452  0.50 34.42           N  
ATOM    122  CA  GLU A  18      -3.728  17.079  26.721  0.50 33.78           C  
ATOM    124  C   GLU A  18      -2.621  17.823  25.973  0.50 33.05           C  
ATOM    126  O   GLU A  18      -2.591  19.055  25.949  0.50 32.83           O  
ATOM    128  CB  GLU A  18      -3.715  17.374  28.230  0.50 34.06           C  
ATOM    130  CG  GLU A  18      -5.054  17.096  28.944  0.50 34.10           C  
ATOM    132  CD  GLU A  18      -6.255  17.863  28.353  0.50 36.10           C  
ATOM    134  OE1 GLU A  18      -6.108  19.035  27.931  0.50 35.05           O  
ATOM    136  OE2 GLU A  18      -7.361  17.282  28.320  0.50 37.26           O  
ATOM    138  N   VAL A  19      -1.733  17.054  25.343  1.00 32.52           N  
ATOM    139  CA  VAL A  19      -0.602  17.589  24.598  1.00 31.74           C  
ATOM    140  C   VAL A  19      -0.600  16.969  23.187  1.00 30.14           C  
ATOM    141  O   VAL A  19      -0.920  15.781  23.009  1.00 29.59           O  
ATOM    142  CB  VAL A  19       0.733  17.333  25.382  1.00 31.63           C  
ATOM    143  CG1 VAL A  19       1.969  17.471  24.505  1.00 33.93           C  
ATOM    144  CG2 VAL A  19       0.840  18.277  26.585  1.00 32.54           C  
ATOM    145  N   VAL A  20      -0.261  17.790  22.193  1.00 27.86           N  
ATOM    146  CA  VAL A  20      -0.101  17.334  20.817  1.00 26.33           C  
ATOM    147  C   VAL A  20       1.218  17.909  20.328  1.00 26.26           C  
ATOM    148  O   VAL A  20       1.775  18.781  20.977  1.00 26.69           O  
ATOM    149  CB  VAL A  20      -1.261  17.806  19.888  1.00 25.42           C  
ATOM    150  CG1 VAL A  20      -2.599  17.248  20.374  1.00 25.18           C  
ATOM    151  CG2 VAL A  20      -1.312  19.358  19.774  1.00 23.31           C  
ATOM    152  N   THR A  21       1.729  17.411  19.209  1.00 25.29           N  
ATOM    153  CA  THR A  21       2.888  18.039  18.570  1.00 24.99           C  
ATOM    154  C   THR A  21       2.454  18.676  17.256  1.00 24.45           C  
ATOM    155  O   THR A  21       1.866  17.996  16.389  1.00 23.82           O  
ATOM    156  CB  THR A  21       4.020  17.018  18.323  1.00 26.11           C  
ATOM    157  OG1 THR A  21       4.332  16.374  19.556  1.00 25.27           O  
ATOM    158  CG2 THR A  21       5.265  17.708  17.803  1.00 26.36           C  
ATOM    159  N   LEU A  22       2.770  19.960  17.099  1.00 23.47           N  
ATOM    160  CA  LEU A  22       2.312  20.755  15.958  1.00 22.67           C  
ATOM    161  C   LEU A  22       3.526  21.129  15.146  1.00 22.15           C  
ATOM    162  O   LEU A  22       4.540  21.548  15.721  1.00 23.11           O  
ATOM    163  CB  LEU A  22       1.580  22.022  16.451  1.00 23.32           C  
ATOM    164  CG  LEU A  22       1.106  23.006  15.374  1.00 21.82           C  
ATOM    165  CD1 LEU A  22       0.025  22.320  14.474  1.00 21.04           C  
ATOM    166  CD2 LEU A  22       0.594  24.333  15.972  1.00 22.73           C  
ATOM    167  N   ALA A  23       3.455  20.935  13.830  1.00 21.36           N  
ATOM    168  CA  ALA A  23       4.511  21.366  12.924  1.00 21.24           C  
ATOM    169  C   ALA A  23       4.047  22.451  11.967  1.00 21.84           C  
ATOM    170  O   ALA A  23       2.941  22.396  11.419  1.00 21.34           O  
ATOM    171  CB  ALA A  23       5.093  20.174  12.128  1.00 21.26           C  
ATOM    172  N   SER A  24       4.915  23.429  11.768  1.00 22.30           N  
ATOM    173  CA  SER A  24       4.771  24.418  10.719  1.00 23.71           C  
ATOM    174  C   SER A  24       5.917  24.168   9.754  1.00 24.35           C  
ATOM    175  O   SER A  24       6.779  23.340  10.021  1.00 24.59           O  
ATOM    176  CB  SER A  24       4.879  25.847  11.287  1.00 23.69           C  
ATOM    177  OG  SER A  24       6.103  26.037  11.994  1.00 24.78           O  
ATOM    178  N   VAL A  25       5.917  24.890   8.640  1.00 25.51           N  
ATOM    179  CA  VAL A  25       7.062  24.967   7.763  1.00 26.25           C  
ATOM    180  C   VAL A  25       7.554  26.421   7.824  1.00 26.78           C  
ATOM    181  O   VAL A  25       6.763  27.358   7.613  1.00 26.96           O  
ATOM    182  CB  VAL A  25       6.694  24.597   6.319  1.00 26.38           C  
ATOM    183  CG1 VAL A  25       7.925  24.596   5.442  1.00 27.43           C  
ATOM    184  CG2 VAL A  25       5.996  23.220   6.276  1.00 28.31           C  
ATOM    185  N   ASN A  26       8.834  26.615   8.129  1.00 26.52           N  
ATOM    186  CA  ASN A  26       9.353  27.979   8.173  1.00 28.43           C  
ATOM    187  C   ASN A  26       9.649  28.513   6.764  1.00 29.76           C  
ATOM    188  O   ASN A  26       9.510  27.792   5.767  1.00 29.34           O  
ATOM    189  CB  ASN A  26      10.515  28.142   9.172  1.00 27.62           C  
ATOM    190  CG  ASN A  26      11.863  27.721   8.616  1.00 27.02           C  
ATOM    191  OD1 ASN A  26      11.987  27.283   7.460  1.00 25.47           O  
ATOM    192  ND2 ASN A  26      12.903  27.894   9.434  1.00 27.47           N  
ATOM    193  N   LYS A  27      10.031  29.781   6.675  1.00 31.67           N  
ATOM    194  CA  LYS A  27      10.234  30.375   5.364  1.00 33.10           C  
ATOM    195  C   LYS A  27      11.351  29.696   4.572  1.00 32.82           C  
ATOM    196  O   LYS A  27      11.379  29.788   3.354  1.00 32.67           O  
ATOM    197  CB  LYS A  27      10.475  31.886   5.455  1.00 33.93           C  
ATOM    198  CG  LYS A  27      11.495  32.338   6.480  1.00 37.32           C  
ATOM    199  CD  LYS A  27      12.108  33.686   6.056  1.00 43.46           C  
ATOM    200  CE  LYS A  27      11.141  34.480   5.177  1.00 43.60           C  
ATOM    201  NZ  LYS A  27      11.853  35.378   4.205  1.00 47.02           N  
ATOM    202  N   GLU A  28      12.256  29.010   5.267  1.00 32.71           N  
ATOM    203  CA  GLU A  28      13.345  28.302   4.591  1.00 32.61           C  
ATOM    204  C   GLU A  28      13.008  26.867   4.154  1.00 31.37           C  
ATOM    205  O   GLU A  28      13.865  26.189   3.602  1.00 31.73           O  
ATOM    206  CB  GLU A  28      14.603  28.308   5.447  1.00 33.08           C  
ATOM    207  CG  GLU A  28      15.587  29.389   5.085  1.00 37.41           C  
ATOM    208  CD  GLU A  28      16.658  29.573   6.141  1.00 43.48           C  
ATOM    209  OE1 GLU A  28      16.655  30.656   6.755  1.00 46.75           O  
ATOM    210  OE2 GLU A  28      17.482  28.640   6.374  1.00 44.81           O  
ATOM    211  N   GLY A  29      11.778  26.416   4.412  1.00 29.92           N  
ATOM    212  CA  GLY A  29      11.320  25.086   4.000  1.00 28.38           C  
ATOM    213  C   GLY A  29      11.512  23.996   5.050  1.00 27.93           C  
ATOM    214  O   GLY A  29      11.255  22.827   4.780  1.00 27.42           O  
ATOM    215  N   TYR A  30      11.955  24.377   6.249  1.00 27.41           N  
ATOM    216  CA  TYR A  30      12.178  23.421   7.355  1.00 26.41           C  
ATOM    217  C   TYR A  30      10.918  23.198   8.147  1.00 25.55           C  
ATOM    218  O   TYR A  30      10.278  24.157   8.564  1.00 25.54           O  
ATOM    219  CB  TYR A  30      13.296  23.892   8.301  1.00 26.05           C  
ATOM    220  CG  TYR A  30      14.661  23.824   7.694  1.00 26.56           C  
ATOM    221  CD1 TYR A  30      15.422  22.658   7.775  1.00 28.05           C  
ATOM    222  CD2 TYR A  30      15.199  24.927   7.026  1.00 28.69           C  
ATOM    223  CE1 TYR A  30      16.692  22.584   7.186  1.00 29.26           C  
ATOM    224  CE2 TYR A  30      16.472  24.864   6.434  1.00 29.66           C  
ATOM    225  CZ  TYR A  30      17.200  23.697   6.526  1.00 28.10           C  
ATOM    226  OH  TYR A  30      18.444  23.636   5.964  1.00 29.17           O  
ATOM    227  N   PRO A  31      10.559  21.918   8.388  1.00 25.95           N  
ATOM    228  CA  PRO A  31       9.401  21.670   9.250  1.00 25.12           C  
ATOM    229  C   PRO A  31       9.833  21.835  10.710  1.00 25.44           C  
ATOM    230  O   PRO A  31      10.965  21.501  11.051  1.00 25.45           O  
ATOM    231  CB  PRO A  31       9.035  20.209   8.938  1.00 26.19           C  
ATOM    232  CG  PRO A  31      10.304  19.575   8.504  1.00 24.42           C  
ATOM    233  CD  PRO A  31      11.190  20.665   7.921  1.00 25.20           C  
ATOM    234  N   ARG A  32       8.937  22.352  11.551  1.00 25.34           N  
ATOM    235  CA  ARG A  32       9.262  22.715  12.931  1.00 25.90           C  
ATOM    236  C   ARG A  32       8.229  22.110  13.866  1.00 24.86           C  
ATOM    237  O   ARG A  32       7.220  22.754  14.140  1.00 24.94           O  
ATOM    238  CB  ARG A  32       9.223  24.243  13.092  1.00 26.02           C  
ATOM    239  CG  ARG A  32      10.361  25.012  12.415  1.00 27.71           C  
ATOM    240  CD  ARG A  32      10.342  26.523  12.823  1.00 28.00           C  
ATOM    241  NE  ARG A  32      10.384  26.704  14.273  1.00 32.59           N  
ATOM    242  CZ  ARG A  32      11.462  26.521  15.037  1.00 34.03           C  
ATOM    243  NH1 ARG A  32      11.379  26.690  16.349  1.00 33.97           N  
ATOM    244  NH2 ARG A  32      12.620  26.152  14.505  1.00 35.21           N  
ATOM    245  N   PRO A  33       8.481  20.880  14.361  1.00 24.43           N  
ATOM    246  CA  PRO A  33       7.580  20.234  15.304  1.00 23.74           C  
ATOM    247  C   PRO A  33       7.790  20.807  16.718  1.00 23.72           C  
ATOM    248  O   PRO A  33       8.925  20.995  17.144  1.00 24.33           O  
ATOM    249  CB  PRO A  33       7.986  18.756  15.229  1.00 23.76           C  
ATOM    250  CG  PRO A  33       9.437  18.762  14.840  1.00 23.39           C  
ATOM    251  CD  PRO A  33       9.646  20.029  14.023  1.00 24.50           C  
ATOM    252  N   VAL A  34       6.706  21.128  17.411  1.00 23.97           N  
ATOM    253  CA  VAL A  34       6.786  21.603  18.800  1.00 24.35           C  
ATOM    254  C   VAL A  34       5.605  21.044  19.606  1.00 24.12           C  
ATOM    255  O   VAL A  34       4.497  20.945  19.086  1.00 24.14           O  
ATOM    256  CB  VAL A  34       6.866  23.170  18.869  1.00 24.75           C  
ATOM    257  CG1 VAL A  34       5.601  23.781  18.359  1.00 24.82           C  
ATOM    258  CG2 VAL A  34       7.129  23.639  20.269  1.00 27.85           C  
ATOM    259  N   PRO A  35       5.847  20.631  20.864  1.00 23.97           N  
ATOM    260  CA  PRO A  35       4.737  20.217  21.719  1.00 24.30           C  
ATOM    261  C   PRO A  35       3.848  21.390  22.114  1.00 24.79           C  
ATOM    262  O   PRO A  35       4.353  22.471  22.419  1.00 24.57           O  
ATOM    263  CB  PRO A  35       5.435  19.626  22.960  1.00 25.34           C  
ATOM    264  CG  PRO A  35       6.834  20.161  22.929  1.00 24.69           C  
ATOM    265  CD  PRO A  35       7.166  20.478  21.519  1.00 24.56           C  
HETATM  266  N   MSE A  36       2.533  21.167  22.108  1.00 24.82           N  
HETATM  267  CA  MSE A  36       1.569  22.219  22.355  1.00 25.15           C  
HETATM  268  C   MSE A  36       0.466  21.674  23.237  1.00 25.47           C  
HETATM  269  O   MSE A  36       0.045  20.531  23.069  1.00 25.05           O  
HETATM  270  CB  MSE A  36       0.938  22.708  21.040  1.00 25.22           C  
HETATM  271  CG  MSE A  36       1.882  23.199  19.951  1.00 27.37           C  
HETATM  272 SE   MSE A  36       2.619  24.956  20.382  0.65 30.45          SE  
HETATM  273  CE  MSE A  36       1.001  25.986  20.208  1.00 30.37           C  
ATOM    274  N   SER A  37      -0.053  22.498  24.145  1.00 25.25           N  
ATOM    275  CA  SER A  37      -1.200  22.050  24.919  1.00 25.84           C  
ATOM    276  C   SER A  37      -2.403  22.128  24.007  1.00 25.68           C  
ATOM    277  O   SER A  37      -2.556  23.105  23.279  1.00 25.05           O  
ATOM    278  CB  SER A  37      -1.448  22.958  26.133  1.00 25.88           C  
ATOM    279  OG  SER A  37      -0.282  23.063  26.916  1.00 29.45           O  
ATOM    280  N   LYS A  38      -3.242  21.100  24.063  1.00 25.72           N  
ATOM    281  CA  LYS A  38      -4.488  21.030  23.322  1.00 26.75           C  
ATOM    282  C   LYS A  38      -5.538  21.749  24.163  1.00 27.52           C  
ATOM    283  O   LYS A  38      -5.903  21.261  25.245  1.00 26.42           O  
ATOM    284  CB  LYS A  38      -4.897  19.552  23.137  1.00 27.06           C  
ATOM    285  CG  LYS A  38      -6.284  19.385  22.502  1.00 27.03           C  
ATOM    286  CD  LYS A  38      -6.952  18.041  22.811  1.00 27.82           C  
ATOM    287  CE  LYS A  38      -7.582  17.994  24.192  1.00 28.31           C  
ATOM    288  NZ  LYS A  38      -7.967  16.577  24.470  1.00 30.12           N  
ATOM    289  N   ILE A  39      -6.020  22.902  23.702  1.00 27.36           N  
ATOM    290  CA  ILE A  39      -6.964  23.626  24.543  1.00 28.77           C  
ATOM    291  C   ILE A  39      -8.402  23.132  24.330  1.00 28.63           C  
ATOM    292  O   ILE A  39      -9.177  23.020  25.281  1.00 28.92           O  
ATOM    293  CB  ILE A  39      -6.718  25.207  24.630  1.00 29.35           C  
ATOM    294  CG1 ILE A  39      -7.318  25.999  23.473  1.00 31.08           C  
ATOM    295  CG2 ILE A  39      -5.216  25.514  24.923  1.00 29.99           C  
ATOM    296  CD1 ILE A  39      -6.775  27.464  23.388  1.00 29.84           C  
ATOM    297  N   ALA A  40      -8.712  22.749  23.098  1.00 27.27           N  
ATOM    298  CA  ALA A  40     -10.000  22.164  22.758  1.00 27.35           C  
ATOM    299  C   ALA A  40      -9.900  21.448  21.412  1.00 27.07           C  
ATOM    300  O   ALA A  40      -9.027  21.736  20.626  1.00 25.85           O  
ATOM    301  CB  ALA A  40     -11.078  23.264  22.698  1.00 27.10           C  
ATOM    302  N   ALA A  41     -10.818  20.525  21.161  1.00 29.00           N  
ATOM    303  CA  ALA A  41     -10.916  19.851  19.872  1.00 30.40           C  
ATOM    304  C   ALA A  41     -12.360  19.458  19.570  1.00 31.00           C  
ATOM    305  O   ALA A  41     -13.126  19.137  20.485  1.00 31.96           O  
ATOM    306  CB  ALA A  41     -10.017  18.621  19.860  1.00 30.27           C  
ATOM    307  N   GLU A  42     -12.725  19.500  18.290  1.00 31.17           N  
ATOM    308  CA  GLU A  42     -14.029  19.048  17.802  1.00 32.27           C  
ATOM    309  C   GLU A  42     -13.708  17.783  16.996  1.00 31.11           C  
ATOM    310  O   GLU A  42     -13.171  17.894  15.884  1.00 30.57           O  
ATOM    311  CB  GLU A  42     -14.660  20.135  16.904  1.00 31.90           C  
ATOM    312  CG  GLU A  42     -14.837  21.500  17.621  1.00 35.76           C  
ATOM    313  CD  GLU A  42     -14.875  22.728  16.684  1.00 36.57           C  
ATOM    314  OE1 GLU A  42     -14.066  23.671  16.907  1.00 41.87           O  
ATOM    315  OE2 GLU A  42     -15.725  22.776  15.758  1.00 41.94           O  
ATOM    316  N   GLY A  43     -14.007  16.606  17.557  1.00 30.68           N  
ATOM    317  CA  GLY A  43     -13.508  15.319  17.018  1.00 30.87           C  
ATOM    318  C   GLY A  43     -12.002  15.361  16.826  1.00 30.64           C  
ATOM    319  O   GLY A  43     -11.281  15.789  17.734  1.00 31.14           O  
ATOM    320  N   ILE A  44     -11.533  14.909  15.651  1.00 30.50           N  
ATOM    321  CA  ILE A  44     -10.164  15.153  15.169  1.00 29.64           C  
ATOM    322  C   ILE A  44     -10.155  16.180  14.037  1.00 30.19           C  
ATOM    323  O   ILE A  44      -9.109  16.457  13.440  1.00 31.54           O  
ATOM    324  CB  ILE A  44      -9.404  13.840  14.720  1.00 29.55           C  
ATOM    325  CG1 ILE A  44     -10.094  13.130  13.531  1.00 30.64           C  
ATOM    326  CG2 ILE A  44      -9.208  12.922  15.900  1.00 28.78           C  
ATOM    327  CD1 ILE A  44      -9.264  11.950  12.920  1.00 29.01           C  
ATOM    328  N   SER A  45     -11.320  16.759  13.764  1.00 29.70           N  
ATOM    329  CA  SER A  45     -11.494  17.685  12.652  1.00 29.84           C  
ATOM    330  C   SER A  45     -10.910  19.060  12.929  1.00 28.55           C  
ATOM    331  O   SER A  45     -10.338  19.686  12.050  1.00 28.46           O  
ATOM    332  CB  SER A  45     -12.985  17.823  12.322  1.00 29.82           C  
ATOM    333  OG  SER A  45     -13.511  16.572  11.887  1.00 35.78           O  
ATOM    334  N   THR A  46     -11.078  19.548  14.152  1.00 28.06           N  
ATOM    335  CA  THR A  46     -10.609  20.880  14.498  1.00 27.17           C  
ATOM    336  C   THR A  46      -9.891  20.793  15.821  1.00 25.85           C  
ATOM    337  O   THR A  46     -10.402  20.217  16.753  1.00 25.56           O  
ATOM    338  CB  THR A  46     -11.785  21.870  14.604  1.00 27.45           C  
ATOM    339  OG1 THR A  46     -12.506  21.868  13.358  1.00 30.04           O  
ATOM    340  CG2 THR A  46     -11.305  23.280  14.923  1.00 28.20           C  
ATOM    341  N   ILE A  47      -8.704  21.375  15.890  1.00 24.62           N  
ATOM    342  CA  ILE A  47      -7.946  21.328  17.130  1.00 25.38           C  
ATOM    343  C   ILE A  47      -7.428  22.726  17.430  1.00 25.29           C  
ATOM    344  O   ILE A  47      -6.864  23.378  16.554  1.00 24.87           O  
ATOM    345  CB  ILE A  47      -6.788  20.287  17.045  1.00 24.77           C  
ATOM    346  CG1 ILE A  47      -7.362  18.901  16.680  1.00 25.62           C  
ATOM    347  CG2 ILE A  47      -6.021  20.275  18.368  1.00 26.15           C  
ATOM    348  CD1 ILE A  47      -6.355  17.831  16.222  1.00 26.49           C  
ATOM    349  N   TRP A  48      -7.642  23.168  18.675  1.00 25.55           N  
ATOM    350  CA  TRP A  48      -7.364  24.536  19.099  1.00 25.84           C  
ATOM    351  C   TRP A  48      -6.162  24.590  20.014  1.00 25.52           C  
ATOM    352  O   TRP A  48      -6.107  23.852  20.993  1.00 25.16           O  
ATOM    353  CB  TRP A  48      -8.571  25.093  19.870  1.00 26.48           C  
ATOM    354  CG  TRP A  48      -9.769  25.359  19.018  1.00 26.95           C  
ATOM    355  CD1 TRP A  48     -10.863  24.556  18.848  1.00 27.69           C  
ATOM    356  CD2 TRP A  48      -9.992  26.522  18.221  1.00 28.76           C  
ATOM    357  NE1 TRP A  48     -11.751  25.150  17.986  1.00 28.15           N  
ATOM    358  CE2 TRP A  48     -11.239  26.359  17.585  1.00 28.95           C  
ATOM    359  CE3 TRP A  48      -9.263  27.699  17.995  1.00 28.14           C  
ATOM    360  CZ2 TRP A  48     -11.783  27.337  16.748  1.00 30.00           C  
ATOM    361  CZ3 TRP A  48      -9.793  28.656  17.136  1.00 27.82           C  
ATOM    362  CH2 TRP A  48     -11.043  28.484  16.544  1.00 27.77           C  
HETATM  363  N   MSE A  49      -5.233  25.492  19.711  1.00 25.08           N  
HETATM  364  CA  MSE A  49      -4.071  25.764  20.551  1.00 26.15           C  
HETATM  365  C   MSE A  49      -3.906  27.280  20.759  1.00 25.86           C  
HETATM  366  O   MSE A  49      -4.558  28.073  20.104  1.00 24.98           O  
HETATM  367  CB  MSE A  49      -2.829  25.161  19.905  1.00 25.39           C  
HETATM  368  CG  MSE A  49      -2.905  23.646  19.871  1.00 26.80           C  
HETATM  369 SE   MSE A  49      -2.034  22.802  18.394  0.75 29.22          SE  
HETATM  370  CE  MSE A  49      -3.327  23.205  16.966  1.00 23.02           C  
ATOM    371  N   SER A  50      -3.040  27.675  21.680  1.00 27.17           N  
ATOM    372  CA  SER A  50      -2.764  29.092  21.849  1.00 27.90           C  
ATOM    373  C   SER A  50      -1.278  29.317  21.673  1.00 27.75           C  
ATOM    374  O   SER A  50      -0.480  28.371  21.775  1.00 27.94           O  
ATOM    375  CB  SER A  50      -3.296  29.603  23.188  1.00 27.90           C  
ATOM    376  OG  SER A  50      -2.573  29.036  24.283  1.00 32.59           O  
ATOM    377  N   THR A  51      -0.907  30.562  21.379  1.00 27.56           N  
ATOM    378  CA  THR A  51       0.485  30.940  21.156  1.00 27.84           C  
ATOM    379  C   THR A  51       0.608  32.464  21.251  1.00 27.71           C  
ATOM    380  O   THR A  51      -0.385  33.144  21.334  1.00 26.75           O  
ATOM    381  CB  THR A  51       0.983  30.449  19.770  1.00 27.48           C  
ATOM    382  OG1 THR A  51       2.396  30.613  19.686  1.00 30.17           O  
ATOM    383  CG2 THR A  51       0.328  31.218  18.657  1.00 27.96           C  
ATOM    384  N   GLY A  52       1.835  32.973  21.299  1.00 29.07           N  
ATOM    385  CA  GLY A  52       2.082  34.435  21.250  1.00 30.52           C  
ATOM    386  C   GLY A  52       1.891  35.035  19.864  1.00 31.18           C  
ATOM    387  O   GLY A  52       2.150  34.388  18.843  1.00 31.21           O  
ATOM    388  N   ALA A  53       1.473  36.288  19.811  1.00 31.58           N  
ATOM    389  CA  ALA A  53       1.279  36.969  18.538  1.00 32.12           C  
ATOM    390  C   ALA A  53       2.590  37.101  17.770  1.00 32.36           C  
ATOM    391  O   ALA A  53       2.576  37.217  16.549  1.00 33.42           O  
ATOM    392  CB  ALA A  53       0.616  38.336  18.737  1.00 32.03           C  
ATOM    393  N   ASP A  54       3.713  37.042  18.477  1.00 33.03           N  
ATOM    394  CA  ASP A  54       5.042  37.138  17.842  1.00 33.82           C  
ATOM    395  C   ASP A  54       5.832  35.831  17.856  1.00 32.25           C  
ATOM    396  O   ASP A  54       7.047  35.837  17.633  1.00 31.30           O  
ATOM    397  CB  ASP A  54       5.883  38.251  18.492  1.00 35.01           C  
ATOM    398  CG  ASP A  54       6.909  38.847  17.531  1.00 39.47           C  
ATOM    399  OD1 ASP A  54       6.603  38.973  16.317  1.00 44.73           O  
ATOM    400  OD2 ASP A  54       8.024  39.205  18.000  1.00 45.27           O  
ATOM    401  N   SER A  55       5.149  34.713  18.117  1.00 30.72           N  
ATOM    402  CA  SER A  55       5.831  33.423  18.218  1.00 29.33           C  
ATOM    403  C   SER A  55       6.328  32.994  16.833  1.00 29.03           C  
ATOM    404  O   SER A  55       5.759  33.409  15.823  1.00 27.93           O  
ATOM    405  CB  SER A  55       4.878  32.366  18.757  1.00 29.34           C  
ATOM    406  OG  SER A  55       3.887  32.074  17.782  1.00 26.23           O  
ATOM    407  N   LEU A  56       7.358  32.149  16.794  1.00 28.72           N  
ATOM    408  CA  LEU A  56       7.828  31.566  15.534  1.00 28.60           C  
ATOM    409  C   LEU A  56       6.708  30.815  14.804  1.00 28.32           C  
ATOM    410  O   LEU A  56       6.610  30.878  13.587  1.00 28.48           O  
ATOM    411  CB  LEU A  56       9.037  30.639  15.754  1.00 28.51           C  
ATOM    412  CG  LEU A  56      10.287  31.188  16.462  1.00 29.58           C  
ATOM    413  CD1 LEU A  56      11.116  30.037  16.957  1.00 30.10           C  
ATOM    414  CD2 LEU A  56      11.113  32.066  15.563  1.00 31.42           C  
ATOM    415  N   LYS A  57       5.872  30.093  15.548  1.00 28.62           N  
ATOM    416  CA  LYS A  57       4.712  29.422  14.961  1.00 27.40           C  
ATOM    417  C   LYS A  57       3.797  30.419  14.243  1.00 27.85           C  
ATOM    418  O   LYS A  57       3.433  30.214  13.078  1.00 26.18           O  
ATOM    419  CB  LYS A  57       3.933  28.646  16.042  1.00 27.12           C  
ATOM    420  CG  LYS A  57       4.495  27.281  16.381  1.00 26.78           C  
ATOM    421  CD  LYS A  57       4.061  26.220  15.328  1.00 26.92           C  
ATOM    422  CE  LYS A  57       4.910  24.959  15.402  1.00 24.83           C  
ATOM    423  NZ  LYS A  57       6.325  25.214  15.009  1.00 23.79           N  
ATOM    424  N   THR A  58       3.427  31.509  14.928  1.00 27.93           N  
ATOM    425  CA  THR A  58       2.607  32.530  14.287  1.00 28.18           C  
ATOM    426  C   THR A  58       3.278  33.056  13.032  1.00 28.61           C  
ATOM    427  O   THR A  58       2.650  33.148  12.016  1.00 29.44           O  
ATOM    428  CB  THR A  58       2.208  33.677  15.256  1.00 28.64           C  
ATOM    429  OG1 THR A  58       1.389  33.135  16.303  1.00 28.09           O  
ATOM    430  CG2 THR A  58       1.414  34.784  14.510  1.00 28.43           C  
ATOM    431  N   ILE A  59       4.564  33.351  13.092  1.00 29.60           N  
ATOM    432  CA  ILE A  59       5.283  33.877  11.922  1.00 30.18           C  
ATOM    433  C   ILE A  59       5.236  32.887  10.745  1.00 29.92           C  
ATOM    434  O   ILE A  59       4.908  33.260   9.604  1.00 29.78           O  
ATOM    435  CB  ILE A  59       6.719  34.269  12.316  1.00 30.43           C  
ATOM    436  CG1 ILE A  59       6.685  35.539  13.176  1.00 31.47           C  
ATOM    437  CG2 ILE A  59       7.615  34.502  11.101  1.00 32.08           C  
ATOM    438  CD1 ILE A  59       7.961  35.771  13.947  1.00 33.45           C  
ATOM    439  N   ASP A  60       5.527  31.612  11.018  1.00 29.12           N  
ATOM    440  CA  ASP A  60       5.423  30.587   9.970  1.00 28.23           C  
ATOM    441  C   ASP A  60       4.043  30.531   9.328  1.00 27.95           C  
ATOM    442  O   ASP A  60       3.931  30.543   8.098  1.00 28.04           O  
ATOM    443  CB  ASP A  60       5.778  29.203  10.504  1.00 27.92           C  
ATOM    444  CG  ASP A  60       7.220  29.095  10.917  1.00 28.14           C  
ATOM    445  OD1 ASP A  60       8.009  30.000  10.576  1.00 28.28           O  
ATOM    446  OD2 ASP A  60       7.561  28.095  11.585  1.00 29.31           O  
ATOM    447  N   PHE A  61       2.998  30.469  10.152  1.00 27.64           N  
ATOM    448  CA  PHE A  61       1.645  30.230   9.638  1.00 28.03           C  
ATOM    449  C   PHE A  61       1.052  31.424   8.897  1.00 28.76           C  
ATOM    450  O   PHE A  61       0.158  31.253   8.053  1.00 28.59           O  
ATOM    451  CB  PHE A  61       0.694  29.777  10.741  1.00 27.63           C  
ATOM    452  CG  PHE A  61       0.966  28.368  11.257  1.00 27.29           C  
ATOM    453  CD1 PHE A  61       1.076  27.293  10.383  1.00 25.66           C  
ATOM    454  CD2 PHE A  61       1.091  28.132  12.622  1.00 27.12           C  
ATOM    455  CE1 PHE A  61       1.307  25.990  10.861  1.00 25.03           C  
ATOM    456  CE2 PHE A  61       1.316  26.835  13.115  1.00 25.33           C  
ATOM    457  CZ  PHE A  61       1.431  25.763  12.225  1.00 24.85           C  
ATOM    458  N   LEU A  62       1.548  32.615   9.226  1.00 29.69           N  
ATOM    459  CA  LEU A  62       1.168  33.838   8.513  1.00 30.59           C  
ATOM    460  C   LEU A  62       1.596  33.808   7.067  1.00 30.98           C  
ATOM    461  O   LEU A  62       0.971  34.451   6.234  1.00 32.00           O  
ATOM    462  CB  LEU A  62       1.728  35.079   9.200  1.00 30.64           C  
ATOM    463  CG  LEU A  62       0.983  35.449  10.490  1.00 31.21           C  
ATOM    464  CD1 LEU A  62       1.559  36.692  11.090  1.00 31.44           C  
ATOM    465  CD2 LEU A  62      -0.503  35.591  10.273  1.00 32.84           C  
ATOM    466  N   SER A  63       2.654  33.061   6.758  1.00 31.07           N  
ATOM    467  CA  SER A  63       3.093  32.950   5.374  1.00 31.66           C  
ATOM    468  C   SER A  63       2.864  31.572   4.737  1.00 31.29           C  
ATOM    469  O   SER A  63       2.805  31.460   3.516  1.00 30.41           O  
ATOM    470  CB  SER A  63       4.544  33.388   5.237  1.00 32.50           C  
ATOM    471  OG  SER A  63       5.390  32.258   5.193  1.00 37.33           O  
ATOM    472  N   ASN A  64       2.708  30.528   5.558  1.00 29.83           N  
ATOM    473  CA  ASN A  64       2.441  29.199   5.044  1.00 28.75           C  
ATOM    474  C   ASN A  64       1.463  28.508   5.978  1.00 28.31           C  
ATOM    475  O   ASN A  64       1.854  28.120   7.060  1.00 28.41           O  
ATOM    476  CB  ASN A  64       3.763  28.412   4.968  1.00 29.29           C  
ATOM    477  CG  ASN A  64       3.622  27.057   4.279  1.00 28.02           C  
ATOM    478  OD1 ASN A  64       2.514  26.560   4.041  1.00 29.22           O  
ATOM    479  ND2 ASN A  64       4.752  26.456   3.953  1.00 26.26           N  
ATOM    480  N   PRO A  65       0.189  28.351   5.565  1.00 27.86           N  
ATOM    481  CA  PRO A  65      -0.804  27.738   6.441  1.00 27.83           C  
ATOM    482  C   PRO A  65      -0.699  26.221   6.621  1.00 27.14           C  
ATOM    483  O   PRO A  65      -1.395  25.666   7.470  1.00 26.84           O  
ATOM    484  CB  PRO A  65      -2.142  28.078   5.760  1.00 28.19           C  
ATOM    485  CG  PRO A  65      -1.810  28.240   4.339  1.00 28.76           C  
ATOM    486  CD  PRO A  65      -0.380  28.731   4.254  1.00 28.33           C  
ATOM    487  N   LYS A  66       0.134  25.555   5.820  1.00 26.88           N  
ATOM    488  CA  LYS A  66       0.184  24.106   5.838  1.00 25.61           C  
ATOM    489  C   LYS A  66       0.811  23.606   7.135  1.00 24.99           C  
ATOM    490  O   LYS A  66       1.887  24.072   7.540  1.00 24.76           O  
ATOM    491  CB  LYS A  66       0.933  23.572   4.626  1.00 26.40           C  
ATOM    492  CG  LYS A  66       0.156  23.733   3.302  1.00 25.97           C  
ATOM    493  CD  LYS A  66       0.930  23.048   2.142  1.00 27.11           C  
ATOM    494  CE  LYS A  66       0.132  23.140   0.828  1.00 29.72           C  
ATOM    495  NZ  LYS A  66       1.063  22.937  -0.324  1.00 33.78           N  
ATOM    496  N   ALA A  67       0.115  22.655   7.759  1.00 24.03           N  
ATOM    497  CA  ALA A  67       0.469  22.162   9.091  1.00 24.39           C  
ATOM    498  C   ALA A  67       0.376  20.646   9.220  1.00 23.95           C  
ATOM    499  O   ALA A  67      -0.262  19.964   8.399  1.00 23.90           O  
ATOM    500  CB  ALA A  67      -0.438  22.845  10.133  1.00 23.49           C  
ATOM    501  N   GLY A  68       1.021  20.129  10.269  1.00 23.50           N  
ATOM    502  CA  GLY A  68       0.960  18.726  10.632  1.00 23.46           C  
ATOM    503  C   GLY A  68       0.815  18.644  12.144  1.00 23.56           C  
ATOM    504  O   GLY A  68       1.380  19.462  12.877  1.00 23.11           O  
ATOM    505  N   LEU A  69       0.029  17.688  12.609  1.00 22.80           N  
ATOM    506  CA  LEU A  69      -0.237  17.546  14.038  1.00 23.90           C  
ATOM    507  C   LEU A  69      -0.252  16.061  14.368  1.00 24.19           C  
ATOM    508  O   LEU A  69      -0.929  15.314  13.666  1.00 25.38           O  
ATOM    509  CB  LEU A  69      -1.600  18.180  14.381  1.00 23.50           C  
ATOM    510  CG  LEU A  69      -2.016  18.282  15.860  1.00 25.98           C  
ATOM    511  CD1 LEU A  69      -2.957  19.440  16.054  1.00 24.58           C  
ATOM    512  CD2 LEU A  69      -2.653  17.001  16.345  1.00 25.22           C  
ATOM    513  N   CYS A  70       0.470  15.635  15.412  1.00 23.22           N  
ATOM    514  CA  CYS A  70       0.378  14.260  15.864  1.00 24.48           C  
ATOM    515  C   CYS A  70       0.166  14.159  17.366  1.00 25.22           C  
ATOM    516  O   CYS A  70       0.378  15.126  18.122  1.00 25.37           O  
ATOM    517  CB  CYS A  70       1.576  13.423  15.405  1.00 24.57           C  
ATOM    518  SG  CYS A  70       3.166  13.846  16.163  1.00 26.16           S  
ATOM    519  N   PHE A  71      -0.309  12.997  17.785  1.00 26.31           N  
ATOM    520  CA  PHE A  71      -0.539  12.729  19.187  1.00 28.50           C  
ATOM    521  C   PHE A  71      -0.443  11.213  19.382  1.00 30.75           C  
ATOM    522  O   PHE A  71      -0.575  10.437  18.418  1.00 30.09           O  
ATOM    523  CB  PHE A  71      -1.849  13.368  19.700  1.00 27.52           C  
ATOM    524  CG  PHE A  71      -3.081  12.956  18.939  1.00 26.83           C  
ATOM    525  CD1 PHE A  71      -3.485  13.650  17.790  1.00 25.44           C  
ATOM    526  CD2 PHE A  71      -3.863  11.895  19.394  1.00 26.40           C  
ATOM    527  CE1 PHE A  71      -4.626  13.263  17.086  1.00 26.00           C  
ATOM    528  CE2 PHE A  71      -5.011  11.504  18.704  1.00 24.83           C  
ATOM    529  CZ  PHE A  71      -5.385  12.171  17.548  1.00 26.79           C  
ATOM    530  N   GLN A  72      -0.135  10.812  20.604  1.00 33.89           N  
ATOM    531  CA  GLN A  72       0.207   9.425  20.890  1.00 37.72           C  
ATOM    532  C   GLN A  72      -0.207   9.098  22.299  1.00 38.77           C  
ATOM    533  O   GLN A  72      -0.066   9.917  23.225  1.00 38.37           O  
ATOM    534  CB  GLN A  72       1.714   9.172  20.698  1.00 37.69           C  
ATOM    535  CG  GLN A  72       2.603   9.905  21.710  1.00 40.70           C  
ATOM    536  CD  GLN A  72       3.979   9.277  21.894  1.00 41.21           C  
ATOM    537  OE1 GLN A  72       4.448   8.505  21.054  1.00 47.82           O  
ATOM    538  NE2 GLN A  72       4.639   9.615  23.001  1.00 45.53           N  
ATOM    539  N   GLU A  73      -0.783   7.912  22.455  1.00 40.68           N  
ATOM    540  CA  GLU A  73      -0.957   7.344  23.776  1.00 42.84           C  
ATOM    541  C   GLU A  73      -0.870   5.828  23.677  1.00 43.53           C  
ATOM    542  O   GLU A  73      -1.708   5.185  23.035  1.00 44.24           O  
ATOM    543  CB  GLU A  73      -2.257   7.804  24.429  1.00 43.36           C  
ATOM    544  CG  GLU A  73      -2.094   8.123  25.920  1.00 46.29           C  
ATOM    545  CD  GLU A  73      -3.122   9.123  26.427  1.00 50.01           C  
ATOM    546  OE1 GLU A  73      -4.193   8.676  26.883  1.00 51.86           O  
ATOM    547  OE2 GLU A  73      -2.849  10.351  26.384  1.00 51.79           O  
ATOM    548  N   LYS A  74       0.199   5.291  24.262  1.00 44.19           N  
ATOM    549  CA  LYS A  74       0.374   3.850  24.478  1.00 44.25           C  
ATOM    550  C   LYS A  74       0.526   3.022  23.198  1.00 43.68           C  
ATOM    551  O   LYS A  74      -0.274   2.134  22.931  1.00 44.41           O  
ATOM    552  CB  LYS A  74      -0.762   3.302  25.360  1.00 44.71           C  
ATOM    553  CG  LYS A  74      -0.597   3.597  26.853  1.00 44.99           C  
ATOM    554  CD  LYS A  74      -1.827   3.175  27.664  1.00 44.74           C  
ATOM    555  CE  LYS A  74      -1.725   1.744  28.212  1.00 44.94           C  
ATOM    556  NZ  LYS A  74      -2.026   0.643  27.222  1.00 43.23           N  
ATOM    557  N   GLY A  75       1.561   3.311  22.414  1.00 42.26           N  
ATOM    558  CA  GLY A  75       1.796   2.587  21.165  1.00 40.71           C  
ATOM    559  C   GLY A  75       0.861   2.959  20.031  1.00 38.97           C  
ATOM    560  O   GLY A  75       1.127   2.635  18.884  1.00 40.00           O  
ATOM    561  N   ASP A  76      -0.237   3.637  20.358  1.00 37.38           N  
ATOM    562  CA  ASP A  76      -1.191   4.131  19.362  1.00 35.11           C  
ATOM    563  C   ASP A  76      -0.873   5.594  19.046  1.00 33.93           C  
ATOM    564  O   ASP A  76      -0.787   6.407  19.954  1.00 32.18           O  
ATOM    565  CB  ASP A  76      -2.601   4.067  19.947  1.00 34.84           C  
ATOM    566  CG  ASP A  76      -3.220   2.680  19.864  1.00 35.27           C  
ATOM    567  OD1 ASP A  76      -2.668   1.778  19.180  1.00 34.26           O  
ATOM    568  OD2 ASP A  76      -4.303   2.518  20.463  1.00 36.63           O  
ATOM    569  N   SER A  77      -0.710   5.920  17.774  1.00 32.41           N  
ATOM    570  CA  SER A  77      -0.433   7.297  17.381  1.00 31.97           C  
ATOM    571  C   SER A  77      -1.325   7.702  16.223  1.00 31.05           C  
ATOM    572  O   SER A  77      -1.802   6.847  15.490  1.00 30.24           O  
ATOM    573  CB  SER A  77       1.027   7.442  16.985  1.00 31.94           C  
ATOM    574  OG  SER A  77       1.270   6.831  15.736  1.00 35.00           O  
ATOM    575  N   VAL A  78      -1.551   9.008  16.071  1.00 30.31           N  
ATOM    576  CA  VAL A  78      -2.335   9.549  14.965  1.00 29.30           C  
ATOM    577  C   VAL A  78      -1.567  10.767  14.450  1.00 29.33           C  
ATOM    578  O   VAL A  78      -1.096  11.579  15.252  1.00 27.57           O  
ATOM    579  CB  VAL A  78      -3.743   9.995  15.431  1.00 29.15           C  
ATOM    580  CG1 VAL A  78      -4.498  10.619  14.289  1.00 29.70           C  
ATOM    581  CG2 VAL A  78      -4.534   8.847  16.021  1.00 28.45           C  
ATOM    582  N   ALA A  79      -1.410  10.849  13.136  1.00 29.05           N  
ATOM    583  CA  ALA A  79      -0.729  11.943  12.493  1.00 29.79           C  
ATOM    584  C   ALA A  79      -1.662  12.561  11.479  1.00 30.06           C  
ATOM    585  O   ALA A  79      -2.177  11.883  10.590  1.00 30.56           O  
ATOM    586  CB  ALA A  79       0.562  11.493  11.847  1.00 29.95           C  
ATOM    587  N   LEU A  80      -1.883  13.862  11.635  1.00 29.66           N  
ATOM    588  CA  LEU A  80      -2.883  14.585  10.874  1.00 29.00           C  
ATOM    589  C   LEU A  80      -2.186  15.580  10.002  1.00 28.74           C  
ATOM    590  O   LEU A  80      -1.121  16.115  10.358  1.00 27.47           O  
ATOM    591  CB  LEU A  80      -3.828  15.341  11.834  1.00 28.76           C  
ATOM    592  CG  LEU A  80      -5.148  14.757  12.353  1.00 30.41           C  
ATOM    593  CD1 LEU A  80      -5.269  13.238  12.333  1.00 31.20           C  
ATOM    594  CD2 LEU A  80      -5.502  15.321  13.721  1.00 28.82           C  
HETATM  595  N   MSE A  81      -2.763  15.818   8.838  0.50 27.49           N  
HETATM  597  CA  MSE A  81      -2.311  16.890   7.984  0.50 26.90           C  
HETATM  599  C   MSE A  81      -3.465  17.890   7.873  0.50 27.31           C  
HETATM  601  O   MSE A  81      -4.622  17.505   7.998  0.50 27.49           O  
HETATM  603  CB  MSE A  81      -1.909  16.334   6.617  0.50 26.74           C  
HETATM  605  CG  MSE A  81      -1.831  17.379   5.558  0.50 25.60           C  
HETATM  607 SE   MSE A  81      -2.170  16.756   3.745  0.05 24.50          SE  
HETATM  609  CE  MSE A  81      -0.749  15.679   3.705  0.50  7.63           C  
ATOM    611  N   GLY A  82      -3.147  19.167   7.666  1.00 28.73           N  
ATOM    612  CA  GLY A  82      -4.158  20.189   7.494  1.00 27.28           C  
ATOM    613  C   GLY A  82      -3.610  21.592   7.434  1.00 27.12           C  
ATOM    614  O   GLY A  82      -2.460  21.820   7.038  1.00 26.62           O  
ATOM    615  N   GLU A  83      -4.450  22.551   7.803  1.00 26.27           N  
ATOM    616  CA  GLU A  83      -4.031  23.931   7.788  1.00 27.31           C  
ATOM    617  C   GLU A  83      -4.312  24.602   9.116  1.00 26.57           C  
ATOM    618  O   GLU A  83      -5.235  24.205   9.816  1.00 26.48           O  
ATOM    619  CB  GLU A  83      -4.704  24.696   6.639  1.00 28.10           C  
ATOM    620  CG  GLU A  83      -4.009  24.457   5.282  1.00 32.56           C  
ATOM    621  CD  GLU A  83      -4.621  23.327   4.482  1.00 39.42           C  
ATOM    622  OE1 GLU A  83      -5.668  22.800   4.917  1.00 43.72           O  
ATOM    623  OE2 GLU A  83      -4.068  22.971   3.405  1.00 41.28           O  
ATOM    624  N   VAL A  84      -3.487  25.596   9.443  1.00 26.60           N  
ATOM    625  CA  VAL A  84      -3.695  26.461  10.612  1.00 26.93           C  
ATOM    626  C   VAL A  84      -4.097  27.874  10.193  1.00 27.94           C  
ATOM    627  O   VAL A  84      -3.455  28.498   9.327  1.00 28.99           O  
ATOM    628  CB  VAL A  84      -2.448  26.502  11.544  1.00 26.31           C  
ATOM    629  CG1 VAL A  84      -2.501  27.673  12.533  1.00 25.14           C  
ATOM    630  CG2 VAL A  84      -2.328  25.203  12.331  1.00 27.44           C  
ATOM    631  N   GLU A  85      -5.166  28.357  10.821  1.00 28.12           N  
ATOM    632  CA  GLU A  85      -5.568  29.758  10.797  1.00 29.10           C  
ATOM    633  C   GLU A  85      -5.134  30.398  12.121  1.00 29.68           C  
ATOM    634  O   GLU A  85      -5.356  29.818  13.201  1.00 29.44           O  
ATOM    635  CB  GLU A  85      -7.096  29.859  10.710  1.00 30.42           C  
ATOM    636  CG  GLU A  85      -7.752  29.259   9.467  1.00 34.12           C  
ATOM    637  CD  GLU A  85      -9.186  28.762   9.732  1.00 42.58           C  
ATOM    638  OE1 GLU A  85      -9.656  28.878  10.886  1.00 48.24           O  
ATOM    639  OE2 GLU A  85      -9.853  28.255   8.793  1.00 45.03           O  
ATOM    640  N   VAL A  86      -4.500  31.564  12.051  1.00 29.12           N  
ATOM    641  CA  VAL A  86      -4.198  32.345  13.251  1.00 29.77           C  
ATOM    642  C   VAL A  86      -5.465  33.131  13.569  1.00 30.84           C  
ATOM    643  O   VAL A  86      -5.952  33.885  12.713  1.00 30.44           O  
ATOM    644  CB  VAL A  86      -3.010  33.325  13.032  1.00 30.09           C  
ATOM    645  CG1 VAL A  86      -2.716  34.093  14.314  1.00 28.74           C  
ATOM    646  CG2 VAL A  86      -1.763  32.589  12.542  1.00 28.24           C  
ATOM    647  N   VAL A  87      -6.028  32.933  14.760  1.00 31.67           N  
ATOM    648  CA  VAL A  87      -7.281  33.601  15.069  1.00 32.92           C  
ATOM    649  C   VAL A  87      -7.132  34.641  16.179  1.00 33.11           C  
ATOM    650  O   VAL A  87      -6.439  34.422  17.168  1.00 31.53           O  
ATOM    651  CB  VAL A  87      -8.566  32.643  15.196  1.00 32.84           C  
ATOM    652  CG1 VAL A  87      -8.317  31.251  14.613  1.00 33.18           C  
ATOM    653  CG2 VAL A  87      -9.171  32.611  16.602  1.00 34.10           C  
ATOM    654  N   THR A  88      -7.740  35.804  15.962  1.00 34.59           N  
ATOM    655  CA  THR A  88      -7.636  36.890  16.933  1.00 35.43           C  
ATOM    656  C   THR A  88      -9.017  37.303  17.419  1.00 36.80           C  
ATOM    657  O   THR A  88      -9.126  38.274  18.168  1.00 37.26           O  
ATOM    658  CB  THR A  88      -6.938  38.139  16.348  1.00 35.59           C  
ATOM    659  OG1 THR A  88      -7.661  38.567  15.202  1.00 32.87           O  
ATOM    660  CG2 THR A  88      -5.486  37.873  15.955  1.00 35.62           C  
ATOM    661  N   ASP A  89     -10.051  36.575  16.977  1.00 37.91           N  
ATOM    662  CA  ASP A  89     -11.452  36.787  17.370  1.00 39.17           C  
ATOM    663  C   ASP A  89     -11.619  36.896  18.897  1.00 39.50           C  
ATOM    664  O   ASP A  89     -11.470  35.906  19.616  1.00 39.04           O  
ATOM    665  CB  ASP A  89     -12.334  35.658  16.797  1.00 39.75           C  
ATOM    666  CG  ASP A  89     -13.773  35.699  17.312  1.00 42.61           C  
ATOM    667  OD1 ASP A  89     -14.082  36.584  18.123  1.00 47.85           O  
ATOM    668  OD2 ASP A  89     -14.615  34.856  16.911  1.00 46.30           O  
ATOM    669  N   GLU A  90     -11.939  38.101  19.376  1.00 39.74           N  
ATOM    670  CA  GLU A  90     -12.115  38.368  20.821  1.00 39.98           C  
ATOM    671  C   GLU A  90     -13.006  37.346  21.536  1.00 38.43           C  
ATOM    672  O   GLU A  90     -12.734  36.963  22.677  1.00 39.02           O  
ATOM    673  CB  GLU A  90     -12.679  39.783  21.050  1.00 39.86           C  
ATOM    674  CG  GLU A  90     -11.741  40.932  20.654  1.00 41.60           C  
ATOM    675  CD  GLU A  90     -12.301  42.313  21.016  1.00 43.44           C  
ATOM    676  OE1 GLU A  90     -13.132  42.403  21.956  1.00 48.97           O  
ATOM    677  OE2 GLU A  90     -11.914  43.316  20.363  1.00 48.49           O  
ATOM    678  N   LYS A  91     -14.077  36.926  20.874  1.00 37.61           N  
ATOM    679  CA  LYS A  91     -15.050  35.996  21.448  1.00 36.82           C  
ATOM    680  C   LYS A  91     -14.454  34.603  21.701  1.00 36.34           C  
ATOM    681  O   LYS A  91     -14.779  33.933  22.697  1.00 35.72           O  
ATOM    682  CB  LYS A  91     -16.254  35.866  20.515  1.00 36.63           C  
ATOM    683  CG  LYS A  91     -17.308  34.885  21.003  1.00 36.74           C  
ATOM    684  CD  LYS A  91     -18.424  34.690  19.990  1.00 37.61           C  
ATOM    685  CE  LYS A  91     -19.397  33.648  20.500  1.00 40.12           C  
ATOM    686  NZ  LYS A  91     -20.584  33.487  19.606  1.00 42.80           N  
ATOM    687  N   LEU A  92     -13.621  34.162  20.764  1.00 35.18           N  
ATOM    688  CA  LEU A  92     -12.976  32.873  20.880  1.00 34.32           C  
ATOM    689  C   LEU A  92     -11.830  32.969  21.873  1.00 33.83           C  
ATOM    690  O   LEU A  92     -11.689  32.078  22.694  1.00 33.82           O  
ATOM    691  CB  LEU A  92     -12.538  32.324  19.515  1.00 34.27           C  
ATOM    692  CG  LEU A  92     -13.680  31.844  18.585  1.00 34.62           C  
ATOM    693  CD1 LEU A  92     -13.147  31.393  17.228  1.00 36.61           C  
ATOM    694  CD2 LEU A  92     -14.532  30.739  19.203  1.00 35.97           C  
ATOM    695  N   LYS A  93     -11.050  34.056  21.818  1.00 33.03           N  
ATOM    696  CA  LYS A  93     -10.002  34.334  22.816  1.00 33.17           C  
ATOM    697  C   LYS A  93     -10.503  34.223  24.247  1.00 33.46           C  
ATOM    698  O   LYS A  93      -9.826  33.647  25.122  1.00 33.14           O  
ATOM    699  CB  LYS A  93      -9.368  35.718  22.589  1.00 32.91           C  
ATOM    700  CG  LYS A  93      -8.404  35.777  21.416  1.00 32.33           C  
ATOM    701  CD  LYS A  93      -7.882  37.187  21.146  1.00 32.97           C  
ATOM    702  CE  LYS A  93      -7.019  37.706  22.306  1.00 31.61           C  
ATOM    703  NZ  LYS A  93      -6.193  38.915  21.967  1.00 33.10           N  
ATOM    704  N   GLN A  94     -11.692  34.757  24.499  0.50 33.60           N  
ATOM    706  CA  GLN A  94     -12.243  34.732  25.851  0.50 33.63           C  
ATOM    708  C   GLN A  94     -12.895  33.393  26.186  0.50 33.81           C  
ATOM    710  O   GLN A  94     -12.784  32.923  27.309  0.50 33.89           O  
ATOM    712  CB  GLN A  94     -13.196  35.909  26.080  0.50 33.67           C  
ATOM    714  CG  GLN A  94     -12.495  37.264  25.997  0.50 32.87           C  
ATOM    716  CD  GLN A  94     -12.723  38.118  27.230  0.50 31.96           C  
ATOM    718  OE1 GLN A  94     -12.998  37.602  28.315  0.50 32.37           O  
ATOM    720  NE2 GLN A  94     -12.594  39.422  27.076  0.50 31.06           N  
ATOM    722  N   GLU A  95     -13.550  32.765  25.212  1.00 34.21           N  
ATOM    723  CA  GLU A  95     -14.120  31.422  25.428  1.00 35.06           C  
ATOM    724  C   GLU A  95     -13.062  30.325  25.650  1.00 34.21           C  
ATOM    725  O   GLU A  95     -13.288  29.375  26.413  1.00 33.73           O  
ATOM    726  CB  GLU A  95     -15.036  31.036  24.274  1.00 35.69           C  
ATOM    727  CG  GLU A  95     -16.426  31.649  24.396  1.00 37.89           C  
ATOM    728  CD  GLU A  95     -17.284  31.479  23.136  1.00 38.60           C  
ATOM    729  OE1 GLU A  95     -16.742  31.175  22.036  1.00 42.92           O  
ATOM    730  OE2 GLU A  95     -18.517  31.653  23.262  1.00 43.73           O  
ATOM    731  N   LEU A  96     -11.907  30.476  25.011  1.00 32.61           N  
ATOM    732  CA  LEU A  96     -10.882  29.428  25.067  1.00 32.48           C  
ATOM    733  C   LEU A  96      -9.778  29.694  26.092  1.00 31.98           C  
ATOM    734  O   LEU A  96      -8.863  28.872  26.266  1.00 31.51           O  
ATOM    735  CB  LEU A  96     -10.307  29.150  23.664  1.00 31.64           C  
ATOM    736  CG  LEU A  96     -11.335  28.556  22.687  1.00 33.14           C  
ATOM    737  CD1 LEU A  96     -10.710  28.262  21.310  1.00 32.04           C  
ATOM    738  CD2 LEU A  96     -12.015  27.307  23.222  1.00 35.52           C  
ATOM    739  N   TRP A  97      -9.902  30.826  26.789  1.00 30.59           N  
ATOM    740  CA  TRP A  97      -8.950  31.207  27.818  1.00 30.03           C  
ATOM    741  C   TRP A  97      -8.906  30.143  28.914  1.00 29.59           C  
ATOM    742  O   TRP A  97      -9.950  29.649  29.364  1.00 29.46           O  
ATOM    743  CB  TRP A  97      -9.356  32.575  28.391  1.00 30.01           C  
ATOM    744  CG  TRP A  97      -8.525  33.014  29.516  1.00 28.55           C  
ATOM    745  CD1 TRP A  97      -8.770  32.809  30.840  1.00 29.46           C  
ATOM    746  CD2 TRP A  97      -7.319  33.770  29.438  1.00 28.44           C  
ATOM    747  NE1 TRP A  97      -7.772  33.358  31.594  1.00 29.63           N  
ATOM    748  CE2 TRP A  97      -6.864  33.959  30.760  1.00 28.84           C  
ATOM    749  CE3 TRP A  97      -6.553  34.264  28.380  1.00 27.87           C  
ATOM    750  CZ2 TRP A  97      -5.691  34.636  31.054  1.00 29.44           C  
ATOM    751  CZ3 TRP A  97      -5.391  34.952  28.666  1.00 29.31           C  
ATOM    752  CH2 TRP A  97      -4.968  35.135  29.992  1.00 30.84           C  
ATOM    753  N   GLN A  98      -7.689  29.789  29.321  1.00 29.61           N  
ATOM    754  CA  GLN A  98      -7.453  28.846  30.415  1.00 29.77           C  
ATOM    755  C   GLN A  98      -6.718  29.591  31.496  1.00 29.31           C  
ATOM    756  O   GLN A  98      -5.964  30.495  31.187  1.00 28.74           O  
ATOM    757  CB  GLN A  98      -6.594  27.654  29.948  1.00 30.06           C  
ATOM    758  CG  GLN A  98      -7.132  26.943  28.699  1.00 30.86           C  
ATOM    759  CD  GLN A  98      -8.541  26.440  28.899  1.00 33.13           C  
ATOM    760  OE1 GLN A  98      -8.839  25.800  29.903  1.00 37.30           O  
ATOM    761  NE2 GLN A  98      -9.427  26.736  27.949  1.00 34.82           N  
ATOM    762  N   ASP A  99      -6.900  29.192  32.754  1.00 29.47           N  
ATOM    763  CA  ASP A  99      -6.210  29.850  33.864  1.00 30.35           C  
ATOM    764  C   ASP A  99      -4.712  29.882  33.697  1.00 30.86           C  
ATOM    765  O   ASP A  99      -4.076  30.864  34.065  1.00 31.14           O  
ATOM    766  CB  ASP A  99      -6.538  29.178  35.195  1.00 30.54           C  
ATOM    767  CG  ASP A  99      -8.011  29.264  35.544  1.00 31.02           C  
ATOM    768  OD1 ASP A  99      -8.690  30.128  34.956  1.00 32.43           O  
ATOM    769  OD2 ASP A  99      -8.483  28.476  36.399  1.00 32.43           O  
ATOM    770  N   TRP A 100      -4.141  28.803  33.157  1.00 31.23           N  
ATOM    771  CA  TRP A 100      -2.688  28.706  33.054  1.00 31.15           C  
ATOM    772  C   TRP A 100      -2.127  29.670  31.995  1.00 30.63           C  
ATOM    773  O   TRP A 100      -0.904  29.898  31.928  1.00 30.48           O  
ATOM    774  CB  TRP A 100      -2.245  27.246  32.830  1.00 32.45           C  
ATOM    775  CG  TRP A 100      -2.629  26.657  31.495  1.00 33.05           C  
ATOM    776  CD1 TRP A 100      -3.742  25.915  31.204  1.00 34.24           C  
ATOM    777  CD2 TRP A 100      -1.880  26.748  30.284  1.00 34.77           C  
ATOM    778  NE1 TRP A 100      -3.739  25.556  29.871  1.00 34.66           N  
ATOM    779  CE2 TRP A 100      -2.602  26.047  29.288  1.00 34.07           C  
ATOM    780  CE3 TRP A 100      -0.651  27.341  29.945  1.00 33.72           C  
ATOM    781  CZ2 TRP A 100      -2.143  25.924  27.978  1.00 34.65           C  
ATOM    782  CZ3 TRP A 100      -0.211  27.242  28.629  1.00 35.15           C  
ATOM    783  CH2 TRP A 100      -0.950  26.526  27.665  1.00 34.74           C  
ATOM    784  N   PHE A 101      -3.021  30.264  31.205  1.00 30.81           N  
ATOM    785  CA  PHE A 101      -2.648  31.337  30.248  1.00 31.25           C  
ATOM    786  C   PHE A 101      -2.102  32.599  30.918  1.00 32.05           C  
ATOM    787  O   PHE A 101      -1.436  33.407  30.262  1.00 32.58           O  
ATOM    788  CB  PHE A 101      -3.837  31.753  29.386  1.00 31.31           C  
ATOM    789  CG  PHE A 101      -4.222  30.758  28.307  1.00 30.82           C  
ATOM    790  CD1 PHE A 101      -3.736  29.452  28.309  1.00 32.17           C  
ATOM    791  CD2 PHE A 101      -5.134  31.135  27.322  1.00 30.17           C  
ATOM    792  CE1 PHE A 101      -4.115  28.559  27.310  1.00 31.73           C  
ATOM    793  CE2 PHE A 101      -5.545  30.259  26.353  1.00 30.96           C  
ATOM    794  CZ  PHE A 101      -5.028  28.956  26.341  1.00 31.77           C  
ATOM    795  N   ILE A 102      -2.386  32.781  32.211  1.00 32.23           N  
ATOM    796  CA  ILE A 102      -1.975  34.015  32.894  1.00 32.44           C  
ATOM    797  C   ILE A 102      -0.462  34.175  32.896  1.00 33.76           C  
ATOM    798  O   ILE A 102       0.048  35.257  32.639  1.00 33.03           O  
ATOM    799  CB  ILE A 102      -2.509  34.128  34.346  1.00 32.57           C  
ATOM    800  CG1 ILE A 102      -4.044  34.199  34.369  1.00 28.73           C  
ATOM    801  CG2 ILE A 102      -1.945  35.405  34.993  1.00 30.20           C  
ATOM    802  CD1 ILE A 102      -4.636  33.909  35.738  1.00 30.12           C  
ATOM    803  N   GLU A 103       0.240  33.086  33.190  1.00 35.93           N  
ATOM    804  CA  GLU A 103       1.703  33.025  33.118  1.00 38.25           C  
ATOM    805  C   GLU A 103       2.298  33.482  31.782  1.00 39.21           C  
ATOM    806  O   GLU A 103       3.459  33.900  31.748  1.00 39.77           O  
ATOM    807  CB  GLU A 103       2.155  31.581  33.357  1.00 38.92           C  
ATOM    808  CG  GLU A 103       2.687  31.303  34.741  1.00 42.11           C  
ATOM    809  CD  GLU A 103       4.143  31.719  34.930  1.00 44.44           C  
ATOM    810  OE1 GLU A 103       4.954  31.574  33.983  1.00 47.17           O  
ATOM    811  OE2 GLU A 103       4.484  32.165  36.044  1.00 45.21           O  
ATOM    812  N   HIS A 104       1.516  33.372  30.697  1.00 39.49           N  
ATOM    813  CA  HIS A 104       1.985  33.645  29.329  1.00 40.17           C  
ATOM    814  C   HIS A 104       1.432  34.927  28.747  1.00 39.69           C  
ATOM    815  O   HIS A 104       2.111  35.587  27.980  1.00 40.45           O  
ATOM    816  CB  HIS A 104       1.610  32.495  28.380  1.00 40.48           C  
ATOM    817  CG  HIS A 104       2.213  31.176  28.748  1.00 42.80           C  
ATOM    818  ND1 HIS A 104       1.560  30.253  29.539  1.00 44.38           N  
ATOM    819  CD2 HIS A 104       3.402  30.616  28.419  1.00 42.69           C  
ATOM    820  CE1 HIS A 104       2.327  29.186  29.688  1.00 44.86           C  
ATOM    821  NE2 HIS A 104       3.447  29.380  29.016  1.00 44.57           N  
ATOM    822  N   PHE A 105       0.189  35.263  29.094  1.00 39.42           N  
ATOM    823  CA  PHE A 105      -0.467  36.464  28.591  1.00 38.43           C  
ATOM    824  C   PHE A 105      -0.972  37.308  29.752  1.00 37.78           C  
ATOM    825  O   PHE A 105      -2.153  37.238  30.095  1.00 37.21           O  
ATOM    826  CB  PHE A 105      -1.622  36.110  27.651  1.00 38.22           C  
ATOM    827  CG  PHE A 105      -1.279  35.037  26.640  1.00 39.31           C  
ATOM    828  CD1 PHE A 105      -2.015  33.856  26.591  1.00 37.97           C  
ATOM    829  CD2 PHE A 105      -0.204  35.205  25.764  1.00 39.95           C  
ATOM    830  CE1 PHE A 105      -1.695  32.841  25.668  1.00 39.99           C  
ATOM    831  CE2 PHE A 105       0.129  34.199  24.841  1.00 40.93           C  
ATOM    832  CZ  PHE A 105      -0.632  33.014  24.794  1.00 38.93           C  
ATOM    833  N   PRO A 106      -0.083  38.138  30.337  1.00 38.28           N  
ATOM    834  CA  PRO A 106      -0.390  38.880  31.577  1.00 37.94           C  
ATOM    835  C   PRO A 106      -1.539  39.896  31.466  1.00 38.00           C  
ATOM    836  O   PRO A 106      -2.014  40.400  32.497  1.00 37.78           O  
ATOM    837  CB  PRO A 106       0.931  39.600  31.910  1.00 38.35           C  
ATOM    838  CG  PRO A 106       1.996  38.936  31.020  1.00 38.62           C  
ATOM    839  CD  PRO A 106       1.267  38.457  29.817  1.00 37.78           C  
ATOM    840  N   GLY A 107      -1.989  40.186  30.246  1.00 37.11           N  
ATOM    841  CA  GLY A 107      -3.088  41.126  30.034  1.00 36.83           C  
ATOM    842  C   GLY A 107      -4.462  40.506  30.159  1.00 36.61           C  
ATOM    843  O   GLY A 107      -5.475  41.204  30.095  1.00 36.31           O  
ATOM    844  N   GLY A 108      -4.499  39.189  30.351  1.00 36.66           N  
ATOM    845  CA  GLY A 108      -5.762  38.443  30.352  1.00 37.34           C  
ATOM    846  C   GLY A 108      -6.280  38.120  28.950  1.00 37.58           C  
ATOM    847  O   GLY A 108      -5.555  38.291  27.968  1.00 37.38           O  
ATOM    848  N   PRO A 109      -7.540  37.655  28.852  1.00 37.46           N  
ATOM    849  CA  PRO A 109      -8.161  37.196  27.603  1.00 38.02           C  
ATOM    850  C   PRO A 109      -8.253  38.266  26.523  1.00 38.51           C  
ATOM    851  O   PRO A 109      -8.623  37.974  25.373  1.00 38.95           O  
ATOM    852  CB  PRO A 109      -9.558  36.755  28.041  1.00 38.21           C  
ATOM    853  CG  PRO A 109      -9.779  37.332  29.383  1.00 37.57           C  
ATOM    854  CD  PRO A 109      -8.444  37.503  30.004  1.00 37.94           C  
ATOM    855  N   THR A 110      -7.874  39.481  26.894  1.00 38.19           N  
ATOM    856  CA  THR A 110      -7.955  40.637  26.032  1.00 38.07           C  
ATOM    857  C   THR A 110      -6.546  41.052  25.549  1.00 37.70           C  
ATOM    858  O   THR A 110      -6.403  41.907  24.654  1.00 38.23           O  
ATOM    859  CB  THR A 110      -8.715  41.779  26.810  1.00 38.06           C  
ATOM    860  OG1 THR A 110      -9.562  42.505  25.922  1.00 39.85           O  
ATOM    861  CG2 THR A 110      -7.770  42.691  27.543  1.00 37.40           C  
ATOM    862  N   ASP A 111      -5.518  40.419  26.128  1.00 36.91           N  
ATOM    863  CA  ASP A 111      -4.102  40.667  25.821  1.00 36.56           C  
ATOM    864  C   ASP A 111      -3.853  40.624  24.307  1.00 36.53           C  
ATOM    865  O   ASP A 111      -4.213  39.634  23.646  1.00 35.87           O  
ATOM    866  CB  ASP A 111      -3.232  39.603  26.527  1.00 36.68           C  
ATOM    867  CG  ASP A 111      -1.755  39.957  26.561  1.00 36.69           C  
ATOM    868  OD1 ASP A 111      -1.182  40.355  25.528  1.00 38.61           O  
ATOM    869  OD2 ASP A 111      -1.141  39.802  27.633  1.00 38.66           O  
ATOM    870  N   PRO A 112      -3.224  41.686  23.754  1.00 36.55           N  
ATOM    871  CA  PRO A 112      -2.989  41.759  22.301  1.00 36.57           C  
ATOM    872  C   PRO A 112      -1.933  40.752  21.884  1.00 36.05           C  
ATOM    873  O   PRO A 112      -1.837  40.403  20.712  1.00 37.44           O  
ATOM    874  CB  PRO A 112      -2.435  43.179  22.100  1.00 36.29           C  
ATOM    875  CG  PRO A 112      -2.698  43.911  23.379  1.00 37.01           C  
ATOM    876  CD  PRO A 112      -2.670  42.866  24.448  1.00 36.98           C  
ATOM    877  N   GLY A 113      -1.133  40.303  22.845  1.00 35.63           N  
ATOM    878  CA  GLY A 113      -0.132  39.277  22.601  1.00 34.87           C  
ATOM    879  C   GLY A 113      -0.696  37.867  22.498  1.00 34.69           C  
ATOM    880  O   GLY A 113       0.052  36.943  22.171  1.00 34.76           O  
ATOM    881  N   TYR A 114      -2.004  37.711  22.754  1.00 33.83           N  
ATOM    882  CA  TYR A 114      -2.660  36.386  22.855  1.00 33.48           C  
ATOM    883  C   TYR A 114      -3.435  36.011  21.581  1.00 33.24           C  
ATOM    884  O   TYR A 114      -4.384  36.680  21.180  1.00 33.21           O  
ATOM    885  CB  TYR A 114      -3.528  36.302  24.133  1.00 32.80           C  
ATOM    886  CG  TYR A 114      -4.632  35.240  24.184  1.00 32.39           C  
ATOM    887  CD1 TYR A 114      -4.453  33.943  23.655  1.00 31.41           C  
ATOM    888  CD2 TYR A 114      -5.841  35.525  24.812  1.00 31.59           C  
ATOM    889  CE1 TYR A 114      -5.481  32.984  23.719  1.00 30.04           C  
ATOM    890  CE2 TYR A 114      -6.852  34.587  24.887  1.00 32.10           C  
ATOM    891  CZ  TYR A 114      -6.671  33.317  24.335  1.00 32.36           C  
ATOM    892  OH  TYR A 114      -7.707  32.410  24.430  1.00 32.65           O  
ATOM    893  N   VAL A 115      -3.006  34.911  20.960  1.00 32.66           N  
ATOM    894  CA  VAL A 115      -3.510  34.467  19.669  1.00 32.27           C  
ATOM    895  C   VAL A 115      -3.905  32.992  19.762  1.00 30.76           C  
ATOM    896  O   VAL A 115      -3.286  32.239  20.535  1.00 30.63           O  
ATOM    897  CB  VAL A 115      -2.370  34.693  18.632  1.00 32.96           C  
ATOM    898  CG1 VAL A 115      -2.281  33.593  17.598  1.00 33.06           C  
ATOM    899  CG2 VAL A 115      -2.468  36.101  18.039  1.00 34.02           C  
ATOM    900  N   LEU A 116      -4.944  32.597  19.030  1.00 29.38           N  
ATOM    901  CA  LEU A 116      -5.320  31.190  18.922  1.00 28.94           C  
ATOM    902  C   LEU A 116      -4.886  30.584  17.582  1.00 28.66           C  
ATOM    903  O   LEU A 116      -4.802  31.279  16.559  1.00 27.86           O  
ATOM    904  CB  LEU A 116      -6.816  30.976  19.116  1.00 28.91           C  
ATOM    905  CG  LEU A 116      -7.357  31.385  20.491  1.00 29.28           C  
ATOM    906  CD1 LEU A 116      -8.813  31.638  20.409  1.00 28.17           C  
ATOM    907  CD2 LEU A 116      -7.054  30.270  21.471  1.00 31.05           C  
ATOM    908  N   LEU A 117      -4.587  29.288  17.616  1.00 27.65           N  
ATOM    909  CA  LEU A 117      -4.279  28.545  16.392  1.00 26.91           C  
ATOM    910  C   LEU A 117      -5.354  27.495  16.177  1.00 27.08           C  
ATOM    911  O   LEU A 117      -5.551  26.595  17.006  1.00 26.35           O  
ATOM    912  CB  LEU A 117      -2.879  27.920  16.454  1.00 26.77           C  
ATOM    913  CG  LEU A 117      -1.669  28.813  16.733  1.00 26.08           C  
ATOM    914  CD1 LEU A 117      -0.361  27.989  16.913  1.00 24.85           C  
ATOM    915  CD2 LEU A 117      -1.470  29.912  15.646  1.00 24.86           C  
ATOM    916  N   LYS A 118      -6.085  27.641  15.077  1.00 26.61           N  
ATOM    917  CA  LYS A 118      -7.120  26.680  14.716  1.00 27.11           C  
ATOM    918  C   LYS A 118      -6.557  25.747  13.653  1.00 26.57           C  
ATOM    919  O   LYS A 118      -6.316  26.177  12.534  1.00 27.52           O  
ATOM    920  CB  LYS A 118      -8.348  27.412  14.138  1.00 26.30           C  
ATOM    921  CG  LYS A 118      -9.527  26.482  13.817  1.00 26.74           C  
ATOM    922  CD  LYS A 118     -10.751  27.270  13.378  1.00 28.64           C  
ATOM    923  CE  LYS A 118     -11.890  26.381  12.975  1.00 31.80           C  
ATOM    924  NZ  LYS A 118     -12.944  27.153  12.237  1.00 34.24           N  
ATOM    925  N   PHE A 119      -6.362  24.478  14.000  1.00 26.67           N  
ATOM    926  CA  PHE A 119      -5.890  23.470  13.054  1.00 26.21           C  
ATOM    927  C   PHE A 119      -7.087  22.736  12.481  1.00 26.88           C  
ATOM    928  O   PHE A 119      -7.891  22.184  13.236  1.00 27.46           O  
ATOM    929  CB  PHE A 119      -4.979  22.464  13.778  1.00 25.21           C  
ATOM    930  CG  PHE A 119      -4.499  21.314  12.903  1.00 24.33           C  
ATOM    931  CD1 PHE A 119      -3.306  21.419  12.168  1.00 22.84           C  
ATOM    932  CD2 PHE A 119      -5.241  20.149  12.817  1.00 22.62           C  
ATOM    933  CE1 PHE A 119      -2.846  20.342  11.369  1.00 23.49           C  
ATOM    934  CE2 PHE A 119      -4.801  19.059  12.000  1.00 24.02           C  
ATOM    935  CZ  PHE A 119      -3.607  19.167  11.284  1.00 23.03           C  
ATOM    936  N   THR A 120      -7.190  22.713  11.155  1.00 27.22           N  
ATOM    937  CA  THR A 120      -8.261  22.007  10.456  1.00 27.71           C  
ATOM    938  C   THR A 120      -7.650  20.885   9.646  1.00 26.83           C  
ATOM    939  O   THR A 120      -6.775  21.136   8.806  1.00 26.29           O  
ATOM    940  CB  THR A 120      -9.075  22.951   9.521  1.00 27.58           C  
ATOM    941  OG1 THR A 120      -9.647  24.007  10.301  1.00 30.00           O  
ATOM    942  CG2 THR A 120     -10.196  22.198   8.843  1.00 29.95           C  
ATOM    943  N   ALA A 121      -8.109  19.663   9.921  1.00 26.99           N  
ATOM    944  CA  ALA A 121      -7.485  18.452   9.379  1.00 28.39           C  
ATOM    945  C   ALA A 121      -8.035  18.131   7.999  1.00 29.24           C  
ATOM    946  O   ALA A 121      -9.216  18.345   7.750  1.00 29.40           O  
ATOM    947  CB  ALA A 121      -7.722  17.301  10.315  1.00 28.52           C  
ATOM    948  N   ASN A 122      -7.153  17.655   7.113  0.50 30.21           N  
ATOM    950  CA  ASN A 122      -7.502  17.213   5.751  0.50 31.33           C  
ATOM    952  C   ASN A 122      -7.324  15.703   5.573  0.50 31.30           C  
ATOM    954  O   ASN A 122      -8.035  15.063   4.790  0.50 31.29           O  
ATOM    956  CB  ASN A 122      -6.587  17.891   4.717  0.50 31.74           C  
ATOM    958  CG  ASN A 122      -6.862  19.376   4.542  0.50 33.48           C  
ATOM    960  OD1 ASN A 122      -5.939  20.148   4.264  0.50 35.39           O  
ATOM    962  ND2 ASN A 122      -8.123  19.781   4.663  0.50 35.68           N  
ATOM    964  N   HIS A 123      -6.353  15.151   6.297  1.00 30.87           N  
ATOM    965  CA  HIS A 123      -5.820  13.810   6.059  1.00 31.59           C  
ATOM    966  C   HIS A 123      -5.341  13.218   7.378  1.00 31.72           C  
ATOM    967  O   HIS A 123      -4.702  13.905   8.188  1.00 32.31           O  
ATOM    968  CB  HIS A 123      -4.655  13.877   5.051  1.00 31.59           C  
ATOM    969  CG  HIS A 123      -4.302  12.561   4.432  1.00 35.34           C  
ATOM    970  ND1 HIS A 123      -4.778  12.168   3.198  1.00 38.28           N  
ATOM    971  CD2 HIS A 123      -3.508  11.552   4.867  1.00 35.47           C  
ATOM    972  CE1 HIS A 123      -4.299  10.969   2.906  1.00 37.76           C  
ATOM    973  NE2 HIS A 123      -3.529  10.573   3.904  1.00 36.83           N  
ATOM    974  N   ALA A 124      -5.660  11.954   7.621  1.00 31.56           N  
ATOM    975  CA  ALA A 124      -5.117  11.268   8.787  1.00 31.77           C  
ATOM    976  C   ALA A 124      -4.295  10.037   8.408  1.00 32.49           C  
ATOM    977  O   ALA A 124      -4.551   9.367   7.380  1.00 32.89           O  
ATOM    978  CB  ALA A 124      -6.206  10.891   9.747  1.00 30.96           C  
ATOM    979  N   THR A 125      -3.308   9.766   9.250  1.00 32.47           N  
ATOM    980  CA  THR A 125      -2.531   8.560   9.227  1.00 33.46           C  
ATOM    981  C   THR A 125      -2.675   7.981  10.626  1.00 33.14           C  
ATOM    982  O   THR A 125      -2.246   8.590  11.624  1.00 33.07           O  
ATOM    983  CB  THR A 125      -1.065   8.859   8.845  1.00 33.61           C  
ATOM    984  OG1 THR A 125      -1.021   9.465   7.542  1.00 37.15           O  
ATOM    985  CG2 THR A 125      -0.225   7.591   8.842  1.00 35.97           C  
ATOM    986  N   TYR A 126      -3.321   6.826  10.714  1.00 32.88           N  
ATOM    987  CA  TYR A 126      -3.526   6.152  11.997  1.00 33.46           C  
ATOM    988  C   TYR A 126      -2.552   4.985  12.186  1.00 34.61           C  
ATOM    989  O   TYR A 126      -2.346   4.193  11.256  1.00 34.29           O  
ATOM    990  CB  TYR A 126      -4.960   5.606  12.113  1.00 32.44           C  
ATOM    991  CG  TYR A 126      -6.068   6.563  11.725  1.00 32.90           C  
ATOM    992  CD1 TYR A 126      -6.650   7.413  12.682  1.00 31.00           C  
ATOM    993  CD2 TYR A 126      -6.557   6.609  10.417  1.00 32.36           C  
ATOM    994  CE1 TYR A 126      -7.685   8.281  12.344  1.00 29.67           C  
ATOM    995  CE2 TYR A 126      -7.601   7.485  10.070  1.00 31.85           C  
ATOM    996  CZ  TYR A 126      -8.161   8.316  11.045  1.00 31.92           C  
ATOM    997  OH  TYR A 126      -9.171   9.214  10.710  1.00 28.87           O  
ATOM    998  N   TRP A 127      -1.974   4.888  13.386  1.00 36.07           N  
ATOM    999  CA  TRP A 127      -1.299   3.667  13.864  1.00 37.60           C  
ATOM   1000  C   TRP A 127      -2.057   3.208  15.089  1.00 37.11           C  
ATOM   1001  O   TRP A 127      -1.723   3.560  16.212  1.00 35.18           O  
ATOM   1002  CB  TRP A 127       0.181   3.911  14.215  1.00 40.32           C  
ATOM   1003  CG  TRP A 127       0.952   2.658  14.674  1.00 43.60           C  
ATOM   1004  CD1 TRP A 127       0.765   1.370  14.238  1.00 44.96           C  
ATOM   1005  CD2 TRP A 127       2.047   2.601  15.618  1.00 46.83           C  
ATOM   1006  NE1 TRP A 127       1.651   0.524  14.861  1.00 46.89           N  
ATOM   1007  CE2 TRP A 127       2.450   1.248  15.709  1.00 46.70           C  
ATOM   1008  CE3 TRP A 127       2.728   3.564  16.389  1.00 47.97           C  
ATOM   1009  CZ2 TRP A 127       3.501   0.823  16.552  1.00 47.06           C  
ATOM   1010  CZ3 TRP A 127       3.778   3.138  17.232  1.00 46.52           C  
ATOM   1011  CH2 TRP A 127       4.150   1.777  17.303  1.00 45.43           C  
ATOM   1012  N   ILE A 128      -3.130   2.461  14.867  1.00 36.52           N  
ATOM   1013  CA  ILE A 128      -3.914   1.961  15.970  1.00 36.21           C  
ATOM   1014  C   ILE A 128      -4.028   0.468  15.759  1.00 36.90           C  
ATOM   1015  O   ILE A 128      -4.113   0.008  14.615  1.00 36.75           O  
ATOM   1016  CB  ILE A 128      -5.298   2.659  16.050  1.00 36.39           C  
ATOM   1017  CG1 ILE A 128      -5.119   4.139  16.409  1.00 35.10           C  
ATOM   1018  CG2 ILE A 128      -6.211   1.994  17.071  1.00 36.02           C  
ATOM   1019  CD1 ILE A 128      -6.418   4.954  16.404  1.00 35.42           C  
ATOM   1020  N   GLU A 129      -3.997  -0.273  16.868  1.00 37.78           N  
ATOM   1021  CA  GLU A 129      -3.939  -1.747  16.865  1.00 38.45           C  
ATOM   1022  C   GLU A 129      -2.829  -2.285  15.958  1.00 38.59           C  
ATOM   1023  O   GLU A 129      -3.045  -3.202  15.143  1.00 38.28           O  
ATOM   1024  CB  GLU A 129      -5.306  -2.350  16.514  1.00 38.72           C  
ATOM   1025  CG  GLU A 129      -6.439  -1.617  17.178  1.00 41.35           C  
ATOM   1026  CD  GLU A 129      -7.488  -2.523  17.743  1.00 45.06           C  
ATOM   1027  OE1 GLU A 129      -7.614  -3.665  17.247  1.00 47.92           O  
ATOM   1028  OE2 GLU A 129      -8.187  -2.090  18.690  1.00 46.01           O  
ATOM   1029  N   GLY A 130      -1.638  -1.703  16.123  1.00 38.64           N  
ATOM   1030  CA  GLY A 130      -0.462  -2.024  15.306  1.00 38.72           C  
ATOM   1031  C   GLY A 130      -0.749  -2.112  13.818  1.00 38.82           C  
ATOM   1032  O   GLY A 130      -0.090  -2.874  13.088  1.00 39.58           O  
ATOM   1033  N   THR A 131      -1.742  -1.340  13.375  1.00 38.05           N  
ATOM   1034  CA  THR A 131      -2.174  -1.324  11.991  1.00 38.07           C  
ATOM   1035  C   THR A 131      -2.127   0.098  11.454  1.00 38.31           C  
ATOM   1036  O   THR A 131      -2.669   1.021  12.066  1.00 38.15           O  
ATOM   1037  CB  THR A 131      -3.610  -1.877  11.862  1.00 38.24           C  
ATOM   1038  OG1 THR A 131      -3.710  -3.112  12.581  1.00 37.63           O  
ATOM   1039  CG2 THR A 131      -3.988  -2.096  10.432  1.00 36.91           C  
ATOM   1040  N   PHE A 132      -1.484   0.261  10.307  1.00 39.11           N  
ATOM   1041  CA  PHE A 132      -1.392   1.550   9.642  1.00 39.73           C  
ATOM   1042  C   PHE A 132      -2.503   1.788   8.609  1.00 39.32           C  
ATOM   1043  O   PHE A 132      -2.735   0.958   7.733  1.00 39.54           O  
ATOM   1044  CB  PHE A 132      -0.005   1.728   9.012  1.00 40.36           C  
ATOM   1045  CG  PHE A 132       1.064   2.175   9.993  1.00 42.46           C  
ATOM   1046  CD1 PHE A 132       2.234   1.422  10.172  1.00 45.58           C  
ATOM   1047  CD2 PHE A 132       0.912   3.352  10.723  1.00 44.29           C  
ATOM   1048  CE1 PHE A 132       3.243   1.843  11.071  1.00 46.63           C  
ATOM   1049  CE2 PHE A 132       1.915   3.793  11.628  1.00 44.96           C  
ATOM   1050  CZ  PHE A 132       3.073   3.035  11.807  1.00 44.97           C  
ATOM   1051  N   ILE A 133      -3.186   2.929   8.727  1.00 38.52           N  
ATOM   1052  CA  ILE A 133      -4.208   3.359   7.755  1.00 38.40           C  
ATOM   1053  C   ILE A 133      -4.095   4.851   7.437  1.00 38.53           C  
ATOM   1054  O   ILE A 133      -3.930   5.669   8.339  1.00 37.84           O  
ATOM   1055  CB  ILE A 133      -5.634   2.954   8.198  1.00 38.19           C  
ATOM   1056  CG1 ILE A 133      -5.989   1.607   7.566  1.00 39.93           C  
ATOM   1057  CG2 ILE A 133      -6.680   3.982   7.756  1.00 36.91           C  
ATOM   1058  CD1 ILE A 133      -6.624   0.673   8.504  1.00 41.13           C  
ATOM   1059  N   HIS A 134      -4.156   5.184   6.152  1.00 39.13           N  
ATOM   1060  CA  HIS A 134      -3.914   6.535   5.687  1.00 40.28           C  
ATOM   1061  C   HIS A 134      -5.104   7.003   4.861  1.00 40.72           C  
ATOM   1062  O   HIS A 134      -5.228   6.648   3.668  1.00 41.11           O  
ATOM   1063  CB  HIS A 134      -2.620   6.626   4.855  1.00 40.94           C  
ATOM   1064  CG  HIS A 134      -1.488   5.775   5.360  1.00 43.49           C  
ATOM   1065  ND1 HIS A 134      -1.318   4.458   4.986  1.00 46.24           N  
ATOM   1066  CD2 HIS A 134      -0.449   6.066   6.181  1.00 45.55           C  
ATOM   1067  CE1 HIS A 134      -0.237   3.967   5.571  1.00 46.43           C  
ATOM   1068  NE2 HIS A 134       0.311   4.925   6.302  1.00 45.99           N  
ATOM   1069  N   LYS A 135      -5.963   7.806   5.495  1.00 40.34           N  
ATOM   1070  CA  LYS A 135      -7.248   8.252   4.926  1.00 40.33           C  
ATOM   1071  C   LYS A 135      -7.365   9.765   4.727  1.00 40.03           C  
ATOM   1072  O   LYS A 135      -6.920  10.538   5.577  1.00 39.47           O  
ATOM   1073  CB  LYS A 135      -8.380   7.887   5.890  1.00 40.28           C  
ATOM   1074  CG  LYS A 135      -8.939   6.511   5.794  1.00 41.54           C  
ATOM   1075  CD  LYS A 135     -10.180   6.391   6.686  1.00 43.97           C  
ATOM   1076  CE  LYS A 135      -9.972   6.935   8.142  1.00 42.19           C  
ATOM   1077  NZ  LYS A 135     -10.606   8.283   8.499  1.00 36.42           N  
ATOM   1078  N   LYS A 136      -8.031  10.182   3.646  1.00 39.36           N  
ATOM   1079  CA  LYS A 136      -8.504  11.571   3.501  1.00 39.50           C  
ATOM   1080  C   LYS A 136      -9.636  11.855   4.510  1.00 38.77           C  
ATOM   1081  O   LYS A 136     -10.431  10.975   4.785  1.00 38.08           O  
ATOM   1082  CB  LYS A 136      -8.978  11.793   2.053  1.00 39.73           C  
ATOM   1083  CG  LYS A 136      -9.412  13.194   1.696  1.00 41.63           C  
ATOM   1084  CD  LYS A 136     -10.930  13.274   1.581  1.00 44.30           C  
ATOM   1085  CE  LYS A 136     -11.370  14.583   0.981  1.00 46.71           C  
ATOM   1086  NZ  LYS A 136     -12.795  14.868   1.349  1.00 49.28           N  
ATOM   1087  N   LEU A 137      -9.687  13.062   5.079  1.00 38.79           N  
ATOM   1088  CA  LEU A 137     -10.778  13.437   6.005  1.00 39.30           C  
ATOM   1089  C   LEU A 137     -11.829  14.344   5.382  1.00 39.42           C  
ATOM   1090  O   LEU A 137     -11.499  15.372   4.788  1.00 40.51           O  
ATOM   1091  CB  LEU A 137     -10.242  14.085   7.294  1.00 39.37           C  
ATOM   1092  CG  LEU A 137      -9.420  13.229   8.269  1.00 39.65           C  
ATOM   1093  CD1 LEU A 137      -9.032  14.091   9.463  1.00 38.60           C  
ATOM   1094  CD2 LEU A 137     -10.149  11.962   8.739  1.00 39.30           C  
TER    1095      LEU A 137                                                      
END
MOLECULE T0402.pdb
ATOM    891  N   GLU     4     -17.272   4.676  13.528  1.00 42.38           N  
ATOM    892  CA  GLU     4     -16.568   4.393  14.819  1.00 41.19           C  
ATOM    893  C   GLU     4     -15.129   4.921  14.732  1.00 39.47           C  
ATOM    894  O   GLU     4     -14.418   5.029  15.752  1.00 37.31           O  
ATOM    895  CB  GLU     4     -16.579   2.885  15.144  1.00 41.11           C  
ATOM    896  CG  GLU     4     -15.897   2.013  14.106  1.00 39.34           C  
ATOM    897  N   LEU     5     -14.709   5.212  13.498  1.00 37.46           N  
ATOM    898  CA  LEU     5     -13.373   5.756  13.253  1.00 36.64           C  
ATOM    899  C   LEU     5     -13.270   7.119  13.922  1.00 34.39           C  
ATOM    900  O   LEU     5     -12.259   7.374  14.576  1.00 31.86           O  
ATOM    901  CB  LEU     5     -13.041   5.842  11.755  1.00 35.60           C  
ATOM    902  CG  LEU     5     -11.673   6.420  11.371  1.00 36.47           C  
ATOM    903  CD1 LEU     5     -10.569   5.783  12.155  1.00 37.02           C  
ATOM    904  CD2 LEU     5     -11.414   6.277   9.874  1.00 39.29           C  
ATOM    905  N   GLU     6     -14.305   7.972  13.775  1.00 34.67           N  
ATOM    906  CA  GLU     6     -14.280   9.313  14.409  1.00 35.57           C  
ATOM    907  C   GLU     6     -14.207   9.044  15.877  1.00 34.45           C  
ATOM    908  O   GLU     6     -13.529   9.753  16.596  1.00 36.01           O  
ATOM    909  CB  GLU     6     -15.568  10.169  14.314  1.00 37.20           C  
ATOM    910  CG  GLU     6     -16.228  10.447  13.005  1.00 44.92           C  
ATOM    911  CD  GLU     6     -15.278  10.933  12.002  1.00 51.63           C  
ATOM    912  OE1 GLU     6     -14.242  10.254  11.920  1.00 53.06           O  
ATOM    913  OE2 GLU     6     -15.580  11.931  11.294  1.00 55.13           O  
ATOM    914  N   ASP     7     -15.017   8.079  16.321  1.00 33.33           N  
ATOM    915  CA  ASP     7     -15.104   7.792  17.745  1.00 32.02           C  
ATOM    916  C   ASP     7     -13.745   7.451  18.271  1.00 28.94           C  
ATOM    917  O   ASP     7     -13.370   7.930  19.313  1.00 29.46           O  
ATOM    918  CB  ASP     7     -16.148   6.720  18.074  1.00 35.52           C  
ATOM    919  CG  ASP     7     -17.577   7.284  18.071  1.00 34.61           C  
ATOM    920  OD1 ASP     7     -17.718   8.522  17.995  1.00 47.65           O  
ATOM    921  OD2 ASP     7     -18.537   6.494  18.159  1.00 44.63           O  
ATOM    922  N   LYS     8     -12.953   6.719  17.499  1.00 28.43           N  
ATOM    923  CA  LYS     8     -11.595   6.371  17.956  1.00 28.59           C  
ATOM    924  C   LYS     8     -10.671   7.595  17.906  1.00 26.95           C  
ATOM    925  O   LYS     8      -9.827   7.799  18.761  1.00 27.30           O  
ATOM    926  CB  LYS     8     -11.017   5.169  17.162  1.00 29.46           C  
ATOM    927  N   ILE     9     -10.860   8.428  16.897  1.00 29.92           N  
ATOM    928  CA  ILE     9     -10.058   9.646  16.759  1.00 24.61           C  
ATOM    929  C   ILE     9     -10.353  10.515  17.961  1.00 25.27           C  
ATOM    930  O   ILE     9      -9.442  10.992  18.630  1.00 26.29           O  
ATOM    931  CB  ILE     9     -10.347  10.365  15.425  1.00 25.78           C  
ATOM    932  CG1 ILE     9      -9.843   9.544  14.266  1.00 23.30           C  
ATOM    933  CG2 ILE     9      -9.667  11.769  15.331  1.00 23.82           C  
ATOM    934  CD1 ILE     9     -10.406   9.932  12.926  1.00 25.41           C  
ATOM    935  N   LEU    10     -11.639  10.687  18.283  1.00 25.00           N  
ATOM    936  CA  LEU    10     -12.032  11.569  19.391  1.00 24.56           C  
ATOM    937  C   LEU    10     -11.529  11.095  20.721  1.00 23.92           C  
ATOM    938  O   LEU    10     -11.132  11.896  21.587  1.00 26.43           O  
ATOM    939  CB  LEU    10     -13.554  11.749  19.433  1.00 28.23           C  
ATOM    940  CG  LEU    10     -14.079  12.624  18.318  1.00 33.38           C  
ATOM    941  CD1 LEU    10     -15.593  12.512  18.157  1.00 34.45           C  
ATOM    942  CD2 LEU    10     -13.658  14.053  18.655  1.00 30.00           C  
ATOM    943  N   ALA    11     -11.521   9.776  20.889  1.00 27.09           N  
ATOM    944  CA  ALA    11     -11.074   9.165  22.143  1.00 27.06           C  
ATOM    945  C   ALA    11      -9.604   9.533  22.363  1.00 29.21           C  
ATOM    946  O   ALA    11      -9.195   9.934  23.460  1.00 31.11           O  
ATOM    947  CB  ALA    11     -11.282   7.610  22.115  1.00 29.17           C  
ATOM    948  N   ILE    12      -8.820   9.481  21.288  1.00 25.92           N  
ATOM    949  CA  ILE    12      -7.401   9.770  21.407  1.00 25.02           C  
ATOM    950  C   ILE    12      -7.223  11.290  21.738  1.00 27.97           C  
ATOM    951  O   ILE    12      -6.411  11.669  22.601  1.00 30.55           O  
ATOM    952  CB  ILE    12      -6.642   9.389  20.142  1.00 24.32           C  
ATOM    953  CG1 ILE    12      -6.626   7.866  19.899  1.00 28.56           C  
ATOM    954  CG2 ILE    12      -5.214   9.899  20.248  1.00 24.77           C  
ATOM    955  CD1 ILE    12      -6.018   7.449  18.563  1.00 27.21           C  
ATOM    956  N   LEU    13      -8.028  12.132  21.084  1.00 24.76           N  
ATOM    957  CA  LEU    13      -7.991  13.585  21.342  1.00 26.43           C  
ATOM    958  C   LEU    13      -8.484  13.900  22.755  1.00 27.50           C  
ATOM    959  O   LEU    13      -8.014  14.833  23.371  1.00 29.87           O  
ATOM    960  CB  LEU    13      -8.853  14.385  20.332  1.00 23.89           C  
ATOM    961  CG  LEU    13      -8.371  14.385  18.875  1.00 19.63           C  
ATOM    962  CD1 LEU    13      -9.317  15.119  17.935  1.00 22.84           C  
ATOM    963  CD2 LEU    13      -6.905  14.962  18.813  1.00 19.00           C  
ATOM    964  N   GLU    14      -9.430  13.123  23.270  1.00 25.13           N  
ATOM    965  CA  GLU    14      -9.968  13.437  24.582  1.00 30.44           C  
ATOM    966  C   GLU    14      -8.977  13.129  25.674  1.00 31.51           C  
ATOM    967  O   GLU    14      -8.949  13.800  26.711  1.00 35.14           O  
ATOM    968  CB  GLU    14     -11.298  12.700  24.820  1.00 31.33           C  
ATOM    969  CG  GLU    14     -12.354  13.066  23.791  1.00 34.80           C  
ATOM    970  CD  GLU    14     -13.585  12.222  23.868  1.00 40.92           C  
ATOM    971  OE1 GLU    14     -13.509  11.127  24.465  1.00 47.22           O  
ATOM    972  OE2 GLU    14     -14.621  12.634  23.291  1.00 47.24           O  
ATOM    973  N   GLN    15      -8.111  12.165  25.395  1.00 30.42           N  
ATOM    974  CA  GLN    15      -7.152  11.690  26.363  1.00 30.22           C  
ATOM    975  C   GLN    15      -5.791  12.293  26.251  1.00 31.37           C  
ATOM    976  O   GLN    15      -4.941  12.006  27.061  1.00 29.45           O  
ATOM    977  CB  GLN    15      -7.084  10.182  26.251  1.00 32.12           C  
ATOM    978  CG  GLN    15      -8.453   9.576  26.520  1.00 40.22           C  
ATOM    979  CD  GLN    15      -8.669   8.270  25.798  1.00 49.99           C  
ATOM    980  OE1 GLN    15      -7.713   7.647  25.335  1.00 59.08           O  
ATOM    981  NE2 GLN    15      -9.935   7.861  25.663  1.00 53.52           N  
ATOM    982  N   HIS    16      -5.573  13.155  25.256  1.00 30.45           N  
ATOM    983  CA  HIS    16      -4.253  13.783  25.084  1.00 31.78           C  
ATOM    984  C   HIS    16      -4.358  15.267  24.743  1.00 32.34           C  
ATOM    985  O   HIS    16      -5.080  15.665  23.852  1.00 35.60           O  
ATOM    986  CB  HIS    16      -3.438  13.094  23.977  1.00 30.41           C  
ATOM    987  CG  HIS    16      -3.245  11.640  24.206  1.00 28.32           C  
ATOM    988  ND1 HIS    16      -4.194  10.700  23.867  1.00 29.60           N  
ATOM    989  CD2 HIS    16      -2.236  10.964  24.790  1.00 25.56           C  
ATOM    990  CE1 HIS    16      -3.764   9.504  24.220  1.00 22.95           C  
ATOM    991  NE2 HIS    16      -2.582   9.637  24.787  1.00 25.21           N  
ATOM    992  N   GLN    17      -3.587  16.059  25.457  1.00 29.66           N  
ATOM    993  CA  GLN    17      -3.560  17.475  25.246  1.00 31.81           C  
ATOM    994  C   GLN    17      -2.163  17.938  24.808  1.00 33.52           C  
ATOM    995  O   GLN    17      -1.966  19.118  24.576  1.00 38.12           O  
ATOM    996  CB  GLN    17      -3.950  18.219  26.500  1.00 31.34           C  
ATOM    997  CG  GLN    17      -5.454  18.319  26.714  1.00 45.87           C  
ATOM    998  CD  GLN    17      -5.808  19.275  27.862  1.00 52.08           C  
ATOM    999  OE1 GLN    17      -4.943  19.675  28.645  1.00 54.96           O  
ATOM   1000  NE2 GLN    17      -7.085  19.632  27.964  1.00 47.07           N  
ATOM   1001  N   VAL    18      -1.187  17.036  24.784  1.00 31.15           N  
ATOM   1002  CA  VAL    18       0.139  17.405  24.279  1.00 29.14           C  
ATOM   1003  C   VAL    18       0.388  16.655  22.972  1.00 28.20           C  
ATOM   1004  O   VAL    18       0.133  15.457  22.858  1.00 28.91           O  
ATOM   1005  CB  VAL    18       1.280  17.118  25.286  1.00 30.69           C  
ATOM   1006  CG1 VAL    18       2.643  17.446  24.687  1.00 24.44           C  
ATOM   1007  CG2 VAL    18       1.092  17.868  26.582  1.00 31.96           C  
ATOM   1008  N   GLY    19       0.886  17.368  21.984  1.00 24.76           N  
ATOM   1009  CA  GLY    19       1.212  16.763  20.719  1.00 24.21           C  
ATOM   1010  C   GLY    19       2.391  17.474  20.138  1.00 24.11           C  
ATOM   1011  O   GLY    19       2.929  18.421  20.740  1.00 21.18           O  
ATOM   1012  N   VAL    20       2.785  17.018  18.961  1.00 22.91           N  
ATOM   1013  CA  VAL    20       3.893  17.612  18.213  1.00 25.08           C  
ATOM   1014  C   VAL    20       3.316  18.383  17.013  1.00 25.01           C  
ATOM   1015  O   VAL    20       2.585  17.824  16.208  1.00 23.67           O  
ATOM   1016  CB  VAL    20       4.898  16.486  17.708  1.00 28.01           C  
ATOM   1017  CG1 VAL    20       6.032  17.064  16.888  1.00 22.46           C  
ATOM   1018  CG2 VAL    20       5.472  15.657  18.879  1.00 22.38           C  
ATOM   1019  N   LEU    21       3.592  19.678  16.923  1.00 21.88           N  
ATOM   1020  CA  LEU    21       3.210  20.429  15.755  1.00 22.34           C  
ATOM   1021  C   LEU    21       4.419  20.533  14.843  1.00 23.69           C  
ATOM   1022  O   LEU    21       5.484  20.928  15.299  1.00 22.74           O  
ATOM   1023  CB  LEU    21       2.844  21.879  16.097  1.00 24.83           C  
ATOM   1024  CG  LEU    21       2.461  22.649  14.818  1.00 26.96           C  
ATOM   1025  CD1 LEU    21       1.037  22.263  14.304  1.00 20.26           C  
ATOM   1026  CD2 LEU    21       2.556  24.085  15.092  1.00 27.07           C  
ATOM   1027  N   THR    22       4.265  20.185  13.570  1.00 22.98           N  
ATOM   1028  CA  THR    22       5.339  20.387  12.611  1.00 21.66           C  
ATOM   1029  C   THR    22       4.841  21.406  11.621  1.00 20.32           C  
ATOM   1030  O   THR    22       3.785  21.246  11.027  1.00 20.75           O  
ATOM   1031  CB  THR    22       5.750  19.076  11.908  1.00 24.87           C  
ATOM   1032  OG1 THR    22       6.149  18.115  12.904  1.00 24.69           O  
ATOM   1033  CG2 THR    22       6.901  19.331  10.889  1.00 24.48           C  
ATOM   1034  N   SER    23       5.575  22.513  11.549  1.00 21.81           N  
ATOM   1035  CA  SER    23       5.320  23.637  10.643  1.00 22.75           C  
ATOM   1036  C   SER    23       6.566  23.797   9.753  1.00 23.27           C  
ATOM   1037  O   SER    23       7.585  23.085   9.925  1.00 21.19           O  
ATOM   1038  CB  SER    23       4.951  24.895  11.396  1.00 24.06           C  
ATOM   1039  OG  SER    23       5.857  25.136  12.474  1.00 31.42           O  
ATOM   1040  N   VAL    24       6.459  24.702   8.789  1.00 21.84           N  
ATOM   1041  CA  VAL    24       7.466  24.869   7.783  1.00 22.28           C  
ATOM   1042  C   VAL    24       7.885  26.316   7.716  1.00 24.89           C  
ATOM   1043  O   VAL    24       7.049  27.227   7.763  1.00 28.74           O  
ATOM   1044  CB  VAL    24       6.890  24.474   6.379  1.00 24.26           C  
ATOM   1045  CG1 VAL    24       7.872  24.796   5.229  1.00 21.44           C  
ATOM   1046  CG2 VAL    24       6.415  23.036   6.366  1.00 27.38           C  
ATOM   1047  N   GLN    25       9.185  26.504   7.658  1.00 24.78           N  
ATOM   1048  CA  GLN    25       9.804  27.826   7.471  1.00 26.17           C  
ATOM   1049  C   GLN    25      10.672  27.763   6.222  1.00 23.98           C  
ATOM   1050  O   GLN    25      11.868  27.458   6.277  1.00 24.12           O  
ATOM   1051  CB  GLN    25      10.676  28.168   8.679  1.00 28.26           C  
ATOM   1052  CG  GLN    25      11.407  29.462   8.537  1.00 32.78           C  
ATOM   1053  CD  GLN    25      12.921  29.305   8.789  1.00 46.32           C  
ATOM   1054  OE1 GLN    25      13.393  28.353   9.448  1.00 31.55           O  
ATOM   1055  NE2 GLN    25      13.686  30.243   8.248  1.00 37.86           N  
ATOM   1056  N   GLY    26      10.075  28.064   5.079  1.00 25.59           N  
ATOM   1057  CA  GLY    26      10.796  28.004   3.821  1.00 23.90           C  
ATOM   1058  C   GLY    26      10.994  26.543   3.532  1.00 23.83           C  
ATOM   1059  O   GLY    26      10.037  25.826   3.368  1.00 29.46           O  
ATOM   1060  N   ASP    27      12.237  26.085   3.513  1.00 22.49           N  
ATOM   1061  CA  ASP    27      12.539  24.669   3.273  1.00 22.69           C  
ATOM   1062  C   ASP    27      12.805  23.898   4.568  1.00 21.00           C  
ATOM   1063  O   ASP    27      13.177  22.727   4.517  1.00 24.02           O  
ATOM   1064  CB  ASP    27      13.781  24.512   2.394  1.00 24.13           C  
ATOM   1065  CG  ASP    27      13.602  25.149   1.027  1.00 30.59           C  
ATOM   1066  OD1 ASP    27      12.553  24.885   0.428  1.00 31.77           O  
ATOM   1067  OD2 ASP    27      14.481  25.941   0.607  1.00 33.51           O  
ATOM   1068  N   PHE    28      12.600  24.525   5.707  1.00 21.28           N  
ATOM   1069  CA  PHE    28      12.906  23.855   6.983  1.00 22.11           C  
ATOM   1070  C   PHE    28      11.702  23.418   7.803  1.00 22.96           C  
ATOM   1071  O   PHE    28      10.787  24.216   8.046  1.00 23.25           O  
ATOM   1072  CB  PHE    28      13.754  24.751   7.846  1.00 23.03           C  
ATOM   1073  CG  PHE    28      15.086  25.078   7.262  1.00 25.86           C  
ATOM   1074  CD1 PHE    28      15.219  26.114   6.350  1.00 34.83           C  
ATOM   1075  CD2 PHE    28      16.209  24.349   7.629  1.00 30.51           C  
ATOM   1076  CE1 PHE    28      16.476  26.420   5.792  1.00 39.60           C  
ATOM   1077  CE2 PHE    28      17.463  24.648   7.085  1.00 34.80           C  
ATOM   1078  CZ  PHE    28      17.589  25.682   6.163  1.00 29.20           C  
ATOM   1079  N   PRO    29      11.722  22.150   8.281  1.00 20.87           N  
ATOM   1080  CA  PRO    29      10.654  21.756   9.179  1.00 20.13           C  
ATOM   1081  C   PRO    29      10.976  22.270  10.602  1.00 21.65           C  
ATOM   1082  O   PRO    29      12.148  22.428  10.977  1.00 22.71           O  
ATOM   1083  CB  PRO    29      10.703  20.218   9.105  1.00 16.93           C  
ATOM   1084  CG  PRO    29      12.087  19.904   8.813  1.00 20.39           C  
ATOM   1085  CD  PRO    29      12.558  20.996   7.887  1.00 21.93           C  
ATOM   1086  N   HIS    30       9.961  22.603  11.346  1.00 19.86           N  
ATOM   1087  CA  HIS    30      10.142  22.931  12.750  1.00 22.55           C  
ATOM   1088  C   HIS    30       9.177  22.051  13.519  1.00 23.86           C  
ATOM   1089  O   HIS    30       7.988  22.074  13.260  1.00 24.48           O  
ATOM   1090  CB  HIS    30       9.832  24.397  13.043  1.00 24.99           C  
ATOM   1091  CG  HIS    30      10.830  25.351  12.464  1.00 27.13           C  
ATOM   1092  ND1 HIS    30      11.991  25.684  13.116  1.00 42.31           N  
ATOM   1093  CD2 HIS    30      10.853  26.020  11.291  1.00 31.98           C  
ATOM   1094  CE1 HIS    30      12.685  26.527  12.372  1.00 43.97           C  
ATOM   1095  NE2 HIS    30      12.020  26.743  11.257  1.00 28.39           N  
ATOM   1096  N   ALA    31       9.683  21.241  14.440  1.00 21.62           N  
ATOM   1097  CA  ALA    31       8.786  20.420  15.239  1.00 21.19           C  
ATOM   1098  C   ALA    31       8.839  20.930  16.666  1.00 21.06           C  
ATOM   1099  O   ALA    31       9.911  21.187  17.197  1.00 22.76           O  
ATOM   1100  CB  ALA    31       9.184  18.935  15.190  1.00 17.98           C  
ATOM   1101  N   ARG    32       7.673  21.039  17.283  1.00 20.86           N  
ATOM   1102  CA  ARG    32       7.581  21.478  18.655  1.00 21.12           C  
ATOM   1103  C   ARG    32       6.466  20.776  19.402  1.00 22.95           C  
ATOM   1104  O   ARG    32       5.437  20.471  18.843  1.00 23.49           O  
ATOM   1105  CB  ARG    32       7.306  22.983  18.737  1.00 23.47           C  
ATOM   1106  CG  ARG    32       8.254  23.852  17.944  1.00 21.69           C  
ATOM   1107  CD  ARG    32       7.801  25.288  17.980  1.00 19.58           C  
ATOM   1108  NE  ARG    32       8.721  26.221  17.303  1.00 23.67           N  
ATOM   1109  CZ  ARG    32       8.622  26.605  16.033  1.00 28.15           C  
ATOM   1110  NH1 ARG    32       7.690  26.096  15.274  1.00 29.28           N  
ATOM   1111  NH2 ARG    32       9.488  27.463  15.518  1.00 25.35           N  
ATOM   1112  N   TYR    33       6.708  20.544  20.682  1.00 22.45           N  
ATOM   1113  CA  TYR    33       5.709  19.972  21.562  1.00 23.41           C  
ATOM   1114  C   TYR    33       4.845  21.101  22.066  1.00 24.86           C  
ATOM   1115  O   TYR    33       5.324  22.195  22.365  1.00 26.66           O  
ATOM   1116  CB  TYR    33       6.294  19.265  22.764  1.00 24.67           C  
ATOM   1117  CG  TYR    33       6.775  17.885  22.478  1.00 18.01           C  
ATOM   1118  CD1 TYR    33       5.897  16.844  22.358  1.00 24.93           C  
ATOM   1119  CD2 TYR    33       8.121  17.628  22.269  1.00 29.92           C  
ATOM   1120  CE1 TYR    33       6.339  15.580  22.088  1.00 23.33           C  
ATOM   1121  CE2 TYR    33       8.564  16.343  21.966  1.00 26.70           C  
ATOM   1122  CZ  TYR    33       7.689  15.350  21.891  1.00 21.77           C  
ATOM   1123  OH  TYR    33       8.099  14.072  21.576  1.00 21.78           O  
ATOM   1124  N   MET    34       3.550  20.874  22.097  1.00 21.95           N  
ATOM   1125  CA  MET    34       2.677  21.872  22.668  1.00 24.11           C  
ATOM   1126  C   MET    34       1.288  21.323  23.023  1.00 23.90           C  
ATOM   1127  O   MET    34       0.948  20.168  22.750  1.00 25.87           O  
ATOM   1128  CB  MET    34       2.552  23.094  21.756  1.00 23.16           C  
ATOM   1129  CG  MET    34       1.890  22.735  20.406  1.00 18.26           C  
ATOM   1130  SD  MET    34       1.980  24.104  19.065  0.75 21.15          SE  
ATOM   1131  CE  MET    34       3.937  23.951  18.781  1.00 25.84           C  
ATOM   1132  N   THR    35       0.525  22.189  23.673  1.00 25.59           N  
ATOM   1133  CA  THR    35      -0.821  21.872  24.155  1.00 26.45           C  
ATOM   1134  C   THR    35      -1.811  22.152  23.054  1.00 26.17           C  
ATOM   1135  O   THR    35      -1.737  23.199  22.356  1.00 25.36           O  
ATOM   1136  CB  THR    35      -1.160  22.672  25.429  1.00 30.86           C  
ATOM   1137  OG1 THR    35      -0.173  22.356  26.389  1.00 34.72           O  
ATOM   1138  CG2 THR    35      -2.567  22.327  26.032  1.00 27.33           C  
ATOM   1139  N   PHE    36      -2.667  21.146  22.879  1.00 24.61           N  
ATOM   1140  CA  PHE    36      -3.783  21.159  21.969  1.00 25.96           C  
ATOM   1141  C   PHE    36      -5.107  20.968  22.689  1.00 27.48           C  
ATOM   1142  O   PHE    36      -5.284  19.984  23.402  1.00 28.94           O  
ATOM   1143  CB  PHE    36      -3.651  20.045  20.937  1.00 23.70           C  
ATOM   1144  CG  PHE    36      -2.489  20.239  19.986  1.00 23.74           C  
ATOM   1145  CD1 PHE    36      -2.632  21.007  18.820  1.00 34.82           C  
ATOM   1146  CD2 PHE    36      -1.248  19.754  20.291  1.00 22.32           C  
ATOM   1147  CE1 PHE    36      -1.569  21.202  17.959  1.00 21.88           C  
ATOM   1148  CE2 PHE    36      -0.168  19.980  19.438  1.00 29.50           C  
ATOM   1149  CZ  PHE    36      -0.334  20.705  18.280  1.00 23.07           C  
ATOM   1150  N   LEU    37      -6.034  21.899  22.457  1.00 26.29           N  
ATOM   1151  CA  LEU    37      -7.442  21.729  22.836  1.00 22.58           C  
ATOM   1152  C   LEU    37      -8.156  21.293  21.549  1.00 23.58           C  
ATOM   1153  O   LEU    37      -7.637  21.463  20.425  1.00 24.31           O  
ATOM   1154  CB  LEU    37      -8.045  23.063  23.352  1.00 24.30           C  
ATOM   1155  CG  LEU    37      -7.245  23.618  24.548  1.00 28.99           C  
ATOM   1156  CD1 LEU    37      -7.872  24.797  25.259  1.00 27.85           C  
ATOM   1157  CD2 LEU    37      -7.115  22.530  25.554  1.00 36.86           C  
ATOM   1158  N   HIS    38      -9.339  20.709  21.658  1.00 24.95           N  
ATOM   1159  CA  HIS    38     -10.100  20.399  20.459  1.00 23.71           C  
ATOM   1160  C   HIS    38     -11.578  20.629  20.709  1.00 24.00           C  
ATOM   1161  O   HIS    38     -12.065  20.669  21.820  1.00 24.63           O  
ATOM   1162  CB  HIS    38      -9.889  18.943  20.045  1.00 25.67           C  
ATOM   1163  CG  HIS    38     -10.516  17.992  20.996  1.00 25.92           C  
ATOM   1164  ND1 HIS    38     -11.709  17.354  20.727  1.00 25.93           N  
ATOM   1165  CD2 HIS    38     -10.209  17.703  22.283  1.00 24.95           C  
ATOM   1166  CE1 HIS    38     -12.066  16.652  21.785  1.00 19.50           C  
ATOM   1167  NE2 HIS    38     -11.174  16.850  22.741  1.00 25.82           N  
ATOM   1168  N   ASP    39     -12.244  20.838  19.614  1.00 25.95           N  
ATOM   1169  CA  ASP    39     -13.651  21.013  19.521  1.00 25.74           C  
ATOM   1170  C   ASP    39     -14.006  20.108  18.373  1.00 26.80           C  
ATOM   1171  O   ASP    39     -13.857  20.450  17.179  1.00 26.30           O  
ATOM   1172  CB  ASP    39     -14.024  22.444  19.162  1.00 28.09           C  
ATOM   1173  CG  ASP    39     -15.538  22.586  18.914  1.00 35.59           C  
ATOM   1174  OD1 ASP    39     -16.277  21.857  19.572  1.00 33.68           O  
ATOM   1175  OD2 ASP    39     -15.973  23.377  18.063  1.00 41.29           O  
ATOM   1176  N   GLY    40     -14.462  18.922  18.699  1.00 27.82           N  
ATOM   1177  CA  GLY    40     -14.707  17.978  17.626  1.00 26.02           C  
ATOM   1178  C   GLY    40     -13.332  17.656  17.087  1.00 24.93           C  
ATOM   1179  O   GLY    40     -12.367  17.531  17.856  1.00 26.42           O  
ATOM   1180  N   LEU    41     -13.228  17.562  15.770  1.00 26.12           N  
ATOM   1181  CA  LEU    41     -11.943  17.249  15.136  1.00 27.21           C  
ATOM   1182  C   LEU    41     -11.118  18.512  14.833  1.00 27.41           C  
ATOM   1183  O   LEU    41      -9.995  18.428  14.292  1.00 27.79           O  
ATOM   1184  CB  LEU    41     -12.119  16.397  13.884  1.00 27.92           C  
ATOM   1185  CG  LEU    41     -12.854  15.056  14.020  1.00 32.57           C  
ATOM   1186  CD1 LEU    41     -12.713  14.341  12.703  1.00 32.75           C  
ATOM   1187  CD2 LEU    41     -12.344  14.206  15.165  1.00 27.90           C  
ATOM   1188  N   THR    42     -11.642  19.670  15.221  1.00 25.69           N  
ATOM   1189  CA  THR    42     -10.858  20.931  15.103  1.00 26.21           C  
ATOM   1190  C   THR    42      -9.897  21.110  16.299  1.00 26.36           C  
ATOM   1191  O   THR    42     -10.278  20.980  17.457  1.00 23.32           O  
ATOM   1192  CB  THR    42     -11.750  22.165  14.903  1.00 27.45           C  
ATOM   1193  OG1 THR    42     -12.414  22.058  13.636  1.00 30.71           O  
ATOM   1194  CG2 THR    42     -10.934  23.468  14.887  1.00 23.38           C  
ATOM   1195  N   LEU    43      -8.637  21.391  15.997  1.00 25.60           N  
ATOM   1196  CA  LEU    43      -7.637  21.600  17.028  1.00 23.92           C  
ATOM   1197  C   LEU    43      -7.300  23.088  17.192  1.00 24.50           C  
ATOM   1198  O   LEU    43      -7.443  23.909  16.257  1.00 23.65           O  
ATOM   1199  CB  LEU    43      -6.365  20.838  16.719  1.00 25.35           C  
ATOM   1200  CG  LEU    43      -6.368  19.308  16.630  1.00 27.97           C  
ATOM   1201  CD1 LEU    43      -4.941  18.829  16.496  1.00 30.50           C  
ATOM   1202  CD2 LEU    43      -6.977  18.611  17.785  1.00 33.23           C  
ATOM   1203  N   TYR    44      -6.934  23.433  18.416  1.00 22.63           N  
ATOM   1204  CA  TYR    44      -6.574  24.808  18.781  1.00 22.01           C  
ATOM   1205  C   TYR    44      -5.328  24.710  19.636  1.00 23.89           C  
ATOM   1206  O   TYR    44      -5.169  23.812  20.464  1.00 24.22           O  
ATOM   1207  CB  TYR    44      -7.687  25.526  19.565  1.00 24.73           C  
ATOM   1208  CG  TYR    44      -8.986  25.737  18.807  1.00 25.85           C  
ATOM   1209  CD1 TYR    44      -9.126  26.776  17.889  1.00 25.94           C  
ATOM   1210  CD2 TYR    44     -10.081  24.960  19.064  1.00 24.88           C  
ATOM   1211  CE1 TYR    44     -10.321  26.984  17.200  1.00 25.39           C  
ATOM   1212  CE2 TYR    44     -11.281  25.159  18.395  1.00 27.64           C  
ATOM   1213  CZ  TYR    44     -11.391  26.166  17.461  1.00 31.16           C  
ATOM   1214  OH  TYR    44     -12.548  26.332  16.774  1.00 33.25           O  
ATOM   1215  N   THR    45      -4.361  25.558  19.345  1.00 25.20           N  
ATOM   1216  CA  THR    45      -3.194  25.598  20.178  1.00 22.70           C  
ATOM   1217  C   THR    45      -2.822  27.101  20.418  1.00 25.43           C  
ATOM   1218  O   THR    45      -2.835  27.931  19.464  1.00 24.36           O  
ATOM   1219  CB  THR    45      -2.035  24.745  19.559  1.00 25.94           C  
ATOM   1220  OG1 THR    45      -0.976  24.643  20.495  1.00 26.71           O  
ATOM   1221  CG2 THR    45      -1.516  25.362  18.277  1.00 21.15           C  
ATOM   1222  N   PRO    46      -2.461  27.438  21.675  1.00 24.87           N  
ATOM   1223  CA  PRO    46      -2.083  28.799  22.061  1.00 26.94           C  
ATOM   1224  C   PRO    46      -0.775  29.250  21.502  1.00 27.27           C  
ATOM   1225  O   PRO    46       0.128  28.456  21.243  1.00 24.64           O  
ATOM   1226  CB  PRO    46      -2.052  28.760  23.605  1.00 27.69           C  
ATOM   1227  CG  PRO    46      -1.982  27.336  23.958  1.00 29.16           C  
ATOM   1228  CD  PRO    46      -2.376  26.491  22.796  1.00 26.04           C  
ATOM   1229  N   SER    47      -0.676  30.552  21.273  1.00 26.18           N  
ATOM   1230  CA  SER    47       0.591  31.101  20.790  1.00 26.44           C  
ATOM   1231  C   SER    47       0.672  32.592  21.108  1.00 26.07           C  
ATOM   1232  O   SER    47      -0.242  33.145  21.709  1.00 24.99           O  
ATOM   1233  CB  SER    47       0.738  30.807  19.309  1.00 28.27           C  
ATOM   1234  OG  SER    47       2.027  31.146  18.849  1.00 28.45           O  
ATOM   1235  N   GLY    48       1.784  33.227  20.761  1.00 26.43           N  
ATOM   1236  CA  GLY    48       1.962  34.661  20.935  1.00 25.49           C  
ATOM   1237  C   GLY    48       2.080  35.273  19.554  1.00 26.23           C  
ATOM   1238  O   GLY    48       2.554  34.624  18.624  1.00 24.88           O  
ATOM   1239  N   LYS    49       1.653  36.523  19.419  1.00 25.40           N  
ATOM   1240  CA  LYS    49       1.669  37.221  18.122  1.00 25.22           C  
ATOM   1241  C   LYS    49       3.022  37.259  17.461  1.00 26.54           C  
ATOM   1242  O   LYS    49       3.136  37.280  16.218  1.00 24.69           O  
ATOM   1243  CB  LYS    49       1.261  38.694  18.248  1.00 26.01           C  
ATOM   1244  CG  LYS    49      -0.194  38.964  18.407  1.00 35.93           C  
ATOM   1245  CD  LYS    49      -0.443  40.448  18.576  1.00 31.61           C  
ATOM   1246  CE  LYS    49      -1.828  40.643  19.141  1.00 34.42           C  
ATOM   1247  NZ  LYS    49      -2.097  42.069  19.406  1.00 29.95           N  
ATOM   1248  N   GLU    50       4.044  37.365  18.295  1.00 25.56           N  
ATOM   1249  CA  GLU    50       5.423  37.467  17.823  1.00 27.69           C  
ATOM   1250  C   GLU    50       6.224  36.186  17.832  1.00 27.68           C  
ATOM   1251  O   GLU    50       7.396  36.221  17.515  1.00 30.11           O  
ATOM   1252  CB  GLU    50       6.206  38.526  18.617  1.00 31.57           C  
ATOM   1253  CG  GLU    50       5.977  39.969  18.152  1.00 34.74           C  
ATOM   1254  CD  GLU    50       4.504  40.442  18.202  1.00 40.91           C  
ATOM   1255  OE1 GLU    50       3.918  40.488  19.303  1.00 34.03           O  
ATOM   1256  OE2 GLU    50       3.970  40.816  17.133  1.00 38.96           O  
ATOM   1257  N   LEU    51       5.624  35.065  18.206  1.00 24.38           N  
ATOM   1258  CA  LEU    51       6.381  33.815  18.241  1.00 24.29           C  
ATOM   1259  C   LEU    51       6.632  33.296  16.847  1.00 22.99           C  
ATOM   1260  O   LEU    51       5.835  33.524  15.985  1.00 23.76           O  
ATOM   1261  CB  LEU    51       5.653  32.773  19.042  1.00 23.68           C  
ATOM   1262  CG  LEU    51       5.603  33.114  20.548  1.00 29.25           C  
ATOM   1263  CD1 LEU    51       5.133  31.931  21.370  1.00 28.43           C  
ATOM   1264  CD2 LEU    51       6.967  33.558  20.995  1.00 30.25           C  
ATOM   1265  N   PRO    52       7.765  32.635  16.627  1.00 26.51           N  
ATOM   1266  CA  PRO    52       8.087  32.039  15.344  1.00 28.12           C  
ATOM   1267  C   PRO    52       6.981  31.096  14.817  1.00 26.60           C  
ATOM   1268  O   PRO    52       6.684  31.160  13.645  1.00 26.82           O  
ATOM   1269  CB  PRO    52       9.380  31.267  15.623  1.00 29.45           C  
ATOM   1270  CG  PRO    52      10.041  32.043  16.726  1.00 31.64           C  
ATOM   1271  CD  PRO    52       8.938  32.680  17.530  1.00 29.04           C  
ATOM   1272  N   LYS    53       6.369  30.267  15.651  1.00 26.62           N  
ATOM   1273  CA  LYS    53       5.366  29.332  15.131  1.00 25.94           C  
ATOM   1274  C   LYS    53       4.159  30.063  14.575  1.00 24.77           C  
ATOM   1275  O   LYS    53       3.563  29.635  13.608  1.00 22.68           O  
ATOM   1276  CB  LYS    53       4.940  28.277  16.141  1.00 30.60           C  
ATOM   1277  CG  LYS    53       4.206  28.801  17.354  1.00 31.49           C  
ATOM   1278  CD  LYS    53       3.825  27.659  18.280  1.00 34.33           C  
ATOM   1279  CE  LYS    53       3.118  28.193  19.502  1.00 38.11           C  
ATOM   1280  NZ  LYS    53       3.200  27.292  20.687  1.00 36.28           N  
ATOM   1281  N   THR    54       3.840  31.223  15.143  1.00 23.00           N  
ATOM   1282  CA  THR    54       2.766  32.034  14.633  1.00 22.98           C  
ATOM   1283  C   THR    54       3.084  32.599  13.258  1.00 22.46           C  
ATOM   1284  O   THR    54       2.229  32.601  12.378  1.00 23.60           O  
ATOM   1285  CB  THR    54       2.482  33.233  15.557  1.00 22.98           C  
ATOM   1286  OG1 THR    54       2.117  32.729  16.844  1.00 26.67           O  
ATOM   1287  CG2 THR    54       1.381  34.128  14.957  1.00 23.40           C  
ATOM   1288  N   GLU    55       4.297  33.117  13.080  1.00 22.50           N  
ATOM   1289  CA  GLU    55       4.715  33.635  11.779  1.00 24.13           C  
ATOM   1290  C   GLU    55       4.850  32.528  10.741  1.00 22.32           C  
ATOM   1291  O   GLU    55       4.596  32.735   9.542  1.00 22.91           O  
ATOM   1292  CB  GLU    55       6.011  34.464  11.877  1.00 21.81           C  
ATOM   1293  CG  GLU    55       6.418  35.134  10.550  1.00 33.77           C  
ATOM   1294  CD  GLU    55       5.396  36.146  10.043  1.00 34.42           C  
ATOM   1295  OE1 GLU    55       4.571  36.618  10.845  1.00 35.03           O  
ATOM   1296  OE2 GLU    55       5.434  36.465   8.838  1.00 40.57           O  
ATOM   1297  N   GLU    56       5.274  31.348  11.180  1.00 20.37           N  
ATOM   1298  CA  GLU    56       5.386  30.236  10.262  1.00 20.68           C  
ATOM   1299  C   GLU    56       4.025  29.921   9.630  1.00 25.11           C  
ATOM   1300  O   GLU    56       3.897  29.785   8.402  1.00 24.63           O  
ATOM   1301  CB  GLU    56       5.968  29.013  10.965  1.00 21.89           C  
ATOM   1302  CG  GLU    56       7.447  29.156  11.199  1.00 19.68           C  
ATOM   1303  CD  GLU    56       7.953  28.258  12.308  1.00 22.26           C  
ATOM   1304  OE1 GLU    56       7.260  27.304  12.613  1.00 22.14           O  
ATOM   1305  OE2 GLU    56       9.021  28.526  12.905  1.00 20.23           O  
ATOM   1306  N   VAL    57       3.017  29.800  10.497  1.00 23.86           N  
ATOM   1307  CA  VAL    57       1.615  29.525  10.102  1.00 24.91           C  
ATOM   1308  C   VAL    57       1.011  30.607   9.176  1.00 26.11           C  
ATOM   1309  O   VAL    57       0.280  30.282   8.240  1.00 25.99           O  
ATOM   1310  CB  VAL    57       0.751  29.308  11.384  1.00 24.87           C  
ATOM   1311  CG1 VAL    57      -0.696  29.476  11.111  1.00 25.59           C  
ATOM   1312  CG2 VAL    57       1.072  27.896  11.952  1.00 31.46           C  
ATOM   1313  N   ARG    58       1.321  31.885   9.446  1.00 24.58           N  
ATOM   1314  CA  ARG    58       0.847  32.967   8.645  1.00 24.69           C  
ATOM   1315  C   ARG    58       1.342  32.817   7.244  1.00 24.06           C  
ATOM   1316  O   ARG    58       0.627  33.111   6.333  1.00 26.23           O  
ATOM   1317  CB  ARG    58       1.343  34.342   9.130  1.00 25.86           C  
ATOM   1318  CG  ARG    58       0.753  34.779  10.472  1.00 34.18           C  
ATOM   1319  CD  ARG    58       0.919  36.296  10.728  1.00 33.97           C  
ATOM   1320  NE  ARG    58       0.531  36.633  12.105  1.00 33.53           N  
ATOM   1321  CZ  ARG    58       1.397  36.802  13.111  1.00 46.70           C  
ATOM   1322  NH1 ARG    58       2.712  36.714  12.897  1.00 46.58           N  
ATOM   1323  NH2 ARG    58       0.960  37.099  14.330  1.00 47.99           N  
ATOM   1324  N   ARG    59       2.580  32.353   7.086  1.00 20.98           N  
ATOM   1325  CA  ARG    59       3.226  32.273   5.785  1.00 21.14           C  
ATOM   1326  C   ARG    59       3.054  30.921   5.083  1.00 22.65           C  
ATOM   1327  O   ARG    59       3.206  30.825   3.861  1.00 25.19           O  
ATOM   1328  CB  ARG    59       4.718  32.597   5.919  1.00 24.78           C  
ATOM   1329  CG  ARG    59       4.958  34.017   6.372  1.00 32.59           C  
ATOM   1330  CD  ARG    59       6.280  34.236   7.067  1.00 49.16           C  
ATOM   1331  NE  ARG    59       7.328  34.743   6.198  1.00 64.75           N  
ATOM   1332  CZ  ARG    59       8.292  35.556   6.621  1.00 69.91           C  
ATOM   1333  NH1 ARG    59       8.294  35.984   7.880  1.00 73.25           N  
ATOM   1334  NH2 ARG    59       9.221  35.981   5.781  1.00 76.88           N  
ATOM   1335  N   ASN    60       2.806  29.879   5.858  1.00 21.58           N  
ATOM   1336  CA  ASN    60       2.549  28.535   5.278  1.00 23.00           C  
ATOM   1337  C   ASN    60       1.564  27.813   6.208  1.00 22.00           C  
ATOM   1338  O   ASN    60       1.943  27.443   7.311  1.00 23.03           O  
ATOM   1339  CB  ASN    60       3.854  27.751   5.103  1.00 25.44           C  
ATOM   1340  CG  ASN    60       3.659  26.376   4.458  1.00 23.96           C  
ATOM   1341  OD1 ASN    60       2.574  25.828   4.479  1.00 24.04           O  
ATOM   1342  ND2 ASN    60       4.718  25.830   3.884  1.00 20.04           N  
ATOM   1343  N   PRO    61       0.288  27.655   5.777  1.00 19.63           N  
ATOM   1344  CA  PRO    61      -0.748  27.060   6.618  1.00 22.26           C  
ATOM   1345  C   PRO    61      -0.676  25.528   6.797  1.00 23.66           C  
ATOM   1346  O   PRO    61      -1.383  24.953   7.619  1.00 21.03           O  
ATOM   1347  CB  PRO    61      -2.037  27.444   5.889  1.00 22.62           C  
ATOM   1348  CG  PRO    61      -1.624  27.401   4.427  1.00 22.15           C  
ATOM   1349  CD  PRO    61      -0.241  28.056   4.454  1.00 23.16           C  
ATOM   1350  N   HIS    62       0.216  24.889   6.062  1.00 19.44           N  
ATOM   1351  CA  HIS    62       0.300  23.436   6.075  1.00 18.08           C  
ATOM   1352  C   HIS    62       1.075  22.959   7.306  1.00 21.54           C  
ATOM   1353  O   HIS    62       2.283  23.242   7.473  1.00 21.88           O  
ATOM   1354  CB  HIS    62       0.967  22.916   4.845  1.00 19.49           C  
ATOM   1355  CG  HIS    62       0.406  23.470   3.581  1.00 21.80           C  
ATOM   1356  ND1 HIS    62       1.031  24.474   2.869  1.00 26.45           N  
ATOM   1357  CD2 HIS    62      -0.754  23.222   2.938  1.00 25.89           C  
ATOM   1358  CE1 HIS    62       0.303  24.783   1.811  1.00 26.72           C  
ATOM   1359  NE2 HIS    62      -0.787  24.046   1.834  1.00 27.18           N  
ATOM   1360  N   VAL    63       0.354  22.226   8.135  1.00 22.49           N  
ATOM   1361  CA  VAL    63       0.906  21.672   9.372  1.00 24.28           C  
ATOM   1362  C   VAL    63       0.599  20.203   9.478  1.00 23.23           C  
ATOM   1363  O   VAL    63      -0.341  19.704   8.864  1.00 25.47           O  
ATOM   1364  CB  VAL    63       0.430  22.427  10.618  1.00 24.21           C  
ATOM   1365  CG1 VAL    63       0.884  23.921  10.555  1.00 19.99           C  
ATOM   1366  CG2 VAL    63      -1.103  22.346  10.789  1.00 25.94           C  
ATOM   1367  N   CYS    64       1.459  19.511  10.206  1.00 21.97           N  
ATOM   1368  CA  CYS    64       1.253  18.134  10.512  1.00 22.35           C  
ATOM   1369  C   CYS    64       1.274  17.986  12.048  1.00 23.22           C  
ATOM   1370  O   CYS    64       2.241  18.414  12.686  1.00 22.53           O  
ATOM   1371  CB  CYS    64       2.374  17.290   9.890  1.00 23.04           C  
ATOM   1372  SG  CYS    64       2.156  15.484  10.259  1.00 29.36           S  
ATOM   1373  N   VAL    65       0.239  17.373  12.639  1.00 20.75           N  
ATOM   1374  CA  VAL    65       0.222  17.102  14.107  1.00 20.19           C  
ATOM   1375  C   VAL    65       0.265  15.598  14.419  1.00 20.91           C  
ATOM   1376  O   VAL    65      -0.418  14.808  13.787  1.00 23.06           O  
ATOM   1377  CB  VAL    65      -1.028  17.705  14.784  1.00 21.89           C  
ATOM   1378  CG1 VAL    65      -1.017  17.461  16.324  1.00 21.39           C  
ATOM   1379  CG2 VAL    65      -1.095  19.192  14.486  1.00 17.51           C  
ATOM   1380  N   LEU    66       1.128  15.241  15.350  1.00 21.00           N  
ATOM   1381  CA  LEU    66       1.207  13.906  15.886  1.00 22.83           C  
ATOM   1382  C   LEU    66       0.757  14.046  17.330  1.00 24.37           C  
ATOM   1383  O   LEU    66       1.253  14.899  18.086  1.00 22.34           O  
ATOM   1384  CB  LEU    66       2.616  13.317  15.864  1.00 23.54           C  
ATOM   1385  CG  LEU    66       3.253  13.028  14.493  1.00 22.50           C  
ATOM   1386  CD1 LEU    66       4.619  12.383  14.706  1.00 21.40           C  
ATOM   1387  CD2 LEU    66       2.365  12.090  13.805  1.00 24.83           C  
ATOM   1388  N   ILE    67      -0.204  13.207  17.677  1.00 24.16           N  
ATOM   1389  CA  ILE    67      -0.792  13.227  18.998  1.00 23.41           C  
ATOM   1390  C   ILE    67      -1.282  11.877  19.400  1.00 22.23           C  
ATOM   1391  O   ILE    67      -1.861  11.139  18.618  1.00 22.20           O  
ATOM   1392  CB  ILE    67      -1.921  14.345  19.144  1.00 27.64           C  
ATOM   1393  CG1 ILE    67      -2.524  14.393  20.584  1.00 27.72           C  
ATOM   1394  CG2 ILE    67      -3.065  14.147  18.145  1.00 23.71           C  
ATOM   1395  CD1 ILE    67      -3.050  15.759  20.941  1.00 30.36           C  
ATOM   1396  N   GLY    68      -0.964  11.511  20.647  1.00 23.63           N  
ATOM   1397  CA  GLY    68      -1.483  10.287  21.237  1.00 19.56           C  
ATOM   1398  C   GLY    68      -0.487   9.177  21.520  1.00 20.94           C  
ATOM   1399  O   GLY    68      -0.838   8.188  22.125  1.00 24.34           O  
ATOM   1400  N   TYR    69       0.774   9.400  21.175  1.00 23.18           N  
ATOM   1401  CA  TYR    69       1.815   8.409  21.363  1.00 25.41           C  
ATOM   1402  C   TYR    69       2.320   8.402  22.833  1.00 27.83           C  
ATOM   1403  O   TYR    69       3.092   9.253  23.249  1.00 31.88           O  
ATOM   1404  CB  TYR    69       2.925   8.617  20.327  1.00 21.24           C  
ATOM   1405  CG  TYR    69       4.025   7.605  20.393  1.00 24.82           C  
ATOM   1406  CD1 TYR    69       4.062   6.538  19.521  1.00 33.89           C  
ATOM   1407  CD2 TYR    69       4.992   7.673  21.406  1.00 37.24           C  
ATOM   1408  CE1 TYR    69       5.034   5.568  19.615  1.00 33.53           C  
ATOM   1409  CE2 TYR    69       5.980   6.706  21.515  1.00 40.44           C  
ATOM   1410  CZ  TYR    69       5.990   5.657  20.603  1.00 37.40           C  
ATOM   1411  OH  TYR    69       6.971   4.713  20.683  1.00 39.63           O  
ATOM   1412  N   ASP    70       1.854   7.424  23.600  1.00 27.00           N  
ATOM   1413  CA  ASP    70       2.182   7.269  25.029  1.00 29.39           C  
ATOM   1414  C   ASP    70       3.343   6.293  25.247  1.00 32.01           C  
ATOM   1415  O   ASP    70       4.220   6.510  26.084  1.00 30.28           O  
ATOM   1416  CB  ASP    70       0.970   6.717  25.779  1.00 31.09           C  
ATOM   1417  CG  ASP    70      -0.187   7.662  25.768  1.00 29.31           C  
ATOM   1418  OD1 ASP    70       0.083   8.852  25.824  1.00 34.31           O  
ATOM   1419  OD2 ASP    70      -1.347   7.220  25.687  1.00 41.91           O  
ATOM   1420  N   SER    71       3.312   5.230  24.451  1.00 32.18           N  
ATOM   1421  CA  SER    71       4.289   4.158  24.456  1.00 34.11           C  
ATOM   1422  C   SER    71       4.369   3.491  23.077  1.00 33.71           C  
ATOM   1423  O   SER    71       3.578   3.788  22.171  1.00 28.55           O  
ATOM   1424  CB  SER    71       3.901   3.096  25.475  1.00 35.35           C  
ATOM   1425  OG  SER    71       2.619   2.591  25.154  1.00 40.59           O  
ATOM   1426  N   PRO    72       5.341   2.589  22.909  1.00 33.67           N  
ATOM   1427  CA  PRO    72       5.466   1.972  21.585  1.00 35.80           C  
ATOM   1428  C   PRO    72       4.197   1.263  21.069  1.00 33.94           C  
ATOM   1429  O   PRO    72       4.069   1.103  19.876  1.00 32.67           O  
ATOM   1430  CB  PRO    72       6.640   0.992  21.758  1.00 35.26           C  
ATOM   1431  CG  PRO    72       7.411   1.530  22.898  1.00 36.46           C  
ATOM   1432  CD  PRO    72       6.400   2.141  23.828  1.00 34.30           C  
ATOM   1433  N   GLY    73       3.278   0.877  21.958  1.00 33.86           N  
ATOM   1434  CA  GLY    73       2.038   0.193  21.562  1.00 34.31           C  
ATOM   1435  C   GLY    73       0.785   1.063  21.418  1.00 34.45           C  
ATOM   1436  O   GLY    73      -0.265   0.574  21.057  1.00 32.11           O  
ATOM   1437  N   SER    74       0.907   2.349  21.733  1.00 32.57           N  
ATOM   1438  CA  SER    74      -0.194   3.311  21.624  1.00 31.98           C  
ATOM   1439  C   SER    74      -0.667   3.494  20.185  1.00 29.05           C  
ATOM   1440  O   SER    74       0.158   3.613  19.299  1.00 26.36           O  
ATOM   1441  CB  SER    74       0.290   4.708  22.041  1.00 32.27           C  
ATOM   1442  OG  SER    74       0.662   4.823  23.389  1.00 33.26           O  
ATOM   1443  N   ALA    75      -1.989   3.482  19.968  1.00 27.09           N  
ATOM   1444  CA  ALA    75      -2.547   3.897  18.676  1.00 24.35           C  
ATOM   1445  C   ALA    75      -2.503   5.426  18.810  1.00 26.03           C  
ATOM   1446  O   ALA    75      -2.787   5.990  19.881  1.00 25.85           O  
ATOM   1447  CB  ALA    75      -3.962   3.453  18.501  1.00 20.83           C  
ATOM   1448  N   PHE    76      -2.119   6.101  17.743  1.00 23.70           N  
ATOM   1449  CA  PHE    76      -2.009   7.547  17.775  1.00 21.58           C  
ATOM   1450  C   PHE    76      -2.453   8.126  16.461  1.00 22.33           C  
ATOM   1451  O   PHE    76      -2.805   7.397  15.541  1.00 22.48           O  
ATOM   1452  CB  PHE    76      -0.605   8.013  18.165  1.00 22.85           C  
ATOM   1453  CG  PHE    76       0.452   7.599  17.222  1.00 24.24           C  
ATOM   1454  CD1 PHE    76       1.010   6.332  17.313  1.00 22.01           C  
ATOM   1455  CD2 PHE    76       0.880   8.464  16.212  1.00 25.18           C  
ATOM   1456  CE1 PHE    76       1.977   5.930  16.408  1.00 31.42           C  
ATOM   1457  CE2 PHE    76       1.832   8.059  15.312  1.00 27.57           C  
ATOM   1458  CZ  PHE    76       2.393   6.794  15.419  1.00 27.59           C  
ATOM   1459  N   LEU    77      -2.452   9.448  16.398  1.00 24.31           N  
ATOM   1460  CA  LEU    77      -2.928  10.147  15.245  1.00 25.21           C  
ATOM   1461  C   LEU    77      -1.869  10.935  14.528  1.00 25.16           C  
ATOM   1462  O   LEU    77      -1.011  11.581  15.142  1.00 25.35           O  
ATOM   1463  CB  LEU    77      -4.039  11.154  15.657  1.00 23.45           C  
ATOM   1464  CG  LEU    77      -5.301  10.609  16.331  1.00 24.02           C  
ATOM   1465  CD1 LEU    77      -6.185  11.821  16.871  1.00 17.16           C  
ATOM   1466  CD2 LEU    77      -6.008   9.686  15.358  1.00 21.47           C  
ATOM   1467  N   GLU    78      -1.970  10.856  13.203  1.00 26.24           N  
ATOM   1468  CA  GLU    78      -1.228  11.736  12.320  1.00 25.21           C  
ATOM   1469  C   GLU    78      -2.282  12.603  11.616  1.00 23.10           C  
ATOM   1470  O   GLU    78      -3.155  12.109  10.906  1.00 24.75           O  
ATOM   1471  CB  GLU    78      -0.369  10.957  11.324  1.00 25.77           C  
ATOM   1472  CG  GLU    78       0.164  11.887  10.315  1.00 26.30           C  
ATOM   1473  CD  GLU    78       0.948  11.238   9.178  1.00 37.12           C  
ATOM   1474  OE1 GLU    78       1.284  10.043   9.212  1.00 29.49           O  
ATOM   1475  OE2 GLU    78       1.230  11.973   8.224  1.00 44.31           O  
ATOM   1476  N   ILE    79      -2.227  13.902  11.861  1.00 24.16           N  
ATOM   1477  CA  ILE    79      -3.181  14.865  11.334  1.00 22.67           C  
ATOM   1478  C   ILE    79      -2.497  15.905  10.408  1.00 25.34           C  
ATOM   1479  O   ILE    79      -1.618  16.641  10.834  1.00 25.31           O  
ATOM   1480  CB  ILE    79      -3.814  15.646  12.500  1.00 26.46           C  
ATOM   1481  CG1 ILE    79      -4.534  14.700  13.456  1.00 25.76           C  
ATOM   1482  CG2 ILE    79      -4.761  16.741  11.988  1.00 23.69           C  
ATOM   1483  CD1 ILE    79      -5.059  15.317  14.723  1.00 26.35           C  
ATOM   1484  N   ASN    80      -2.909  15.971   9.144  1.00 22.02           N  
ATOM   1485  CA  ASN    80      -2.364  16.967   8.199  1.00 21.97           C  
ATOM   1486  C   ASN    80      -3.489  17.910   8.003  1.00 23.64           C  
ATOM   1487  O   ASN    80      -4.624  17.496   7.736  1.00 22.91           O  
ATOM   1488  CB  ASN    80      -1.924  16.321   6.896  1.00 25.78           C  
ATOM   1489  CG  ASN    80      -0.768  15.321   7.109  1.00 24.67           C  
ATOM   1490  OD1 ASN    80      -0.979  14.113   7.097  1.00 42.52           O  
ATOM   1491  ND2 ASN    80       0.409  15.824   7.385  1.00 28.75           N  
ATOM   1492  N   GLY    81      -3.191  19.185   8.240  1.00 23.95           N  
ATOM   1493  CA  GLY    81      -4.218  20.202   8.228  1.00 23.64           C  
ATOM   1494  C   GLY    81      -3.752  21.580   7.849  1.00 20.09           C  
ATOM   1495  O   GLY    81      -2.612  21.794   7.519  1.00 21.52           O  
ATOM   1496  N   LEU    82      -4.704  22.479   7.870  1.00 23.69           N  
ATOM   1497  CA  LEU    82      -4.500  23.837   7.529  1.00 24.40           C  
ATOM   1498  C   LEU    82      -4.692  24.684   8.764  1.00 23.40           C  
ATOM   1499  O   LEU    82      -5.772  24.669   9.399  1.00 24.27           O  
ATOM   1500  CB  LEU    82      -5.481  24.226   6.407  1.00 24.89           C  
ATOM   1501  CG  LEU    82      -5.183  23.658   5.021  1.00 23.88           C  
ATOM   1502  CD1 LEU    82      -6.313  24.043   3.998  1.00 27.80           C  
ATOM   1503  CD2 LEU    82      -3.813  24.196   4.550  1.00 23.17           C  
ATOM   1504  N   ALA    83      -3.631  25.430   9.081  1.00 23.61           N  
ATOM   1505  CA  ALA    83      -3.572  26.262  10.267  1.00 24.02           C  
ATOM   1506  C   ALA    83      -3.760  27.717   9.900  1.00 22.11           C  
ATOM   1507  O   ALA    83      -3.321  28.180   8.836  1.00 22.50           O  
ATOM   1508  CB  ALA    83      -2.234  26.000  11.097  1.00 20.76           C  
ATOM   1509  N   SER    84      -4.459  28.391  10.811  1.00 24.74           N  
ATOM   1510  CA  SER    84      -4.812  29.809  10.729  1.00 24.69           C  
ATOM   1511  C   SER    84      -4.955  30.390  12.105  1.00 26.64           C  
ATOM   1512  O   SER    84      -5.035  29.680  13.109  1.00 23.99           O  
ATOM   1513  CB  SER    84      -6.087  30.011   9.888  1.00 24.39           C  
ATOM   1514  OG  SER    84      -7.217  29.490  10.540  1.00 26.80           O  
ATOM   1515  N   LEU    85      -4.918  31.708  12.172  1.00 25.96           N  
ATOM   1516  CA  LEU    85      -5.075  32.387  13.441  1.00 26.62           C  
ATOM   1517  C   LEU    85      -6.569  32.621  13.633  1.00 27.62           C  
ATOM   1518  O   LEU    85      -7.254  33.172  12.746  1.00 27.66           O  
ATOM   1519  CB  LEU    85      -4.256  33.687  13.473  1.00 30.04           C  
ATOM   1520  CG  LEU    85      -2.725  33.472  13.267  1.00 33.75           C  
ATOM   1521  CD1 LEU    85      -1.919  34.769  13.407  1.00 38.74           C  
ATOM   1522  CD2 LEU    85      -2.241  32.411  14.255  1.00 40.61           C  
ATOM   1523  N   GLU    86      -7.063  32.156  14.777  1.00 24.82           N  
ATOM   1524  CA  GLU    86      -8.472  32.274  15.156  1.00 24.15           C  
ATOM   1525  C   GLU    86      -8.813  33.721  15.315  1.00 21.95           C  
ATOM   1526  O   GLU    86      -8.141  34.434  16.035  1.00 25.74           O  
ATOM   1527  CB  GLU    86      -8.756  31.543  16.476  1.00 25.21           C  
ATOM   1528  CG  GLU    86     -10.209  31.635  16.921  1.00 27.45           C  
ATOM   1529  CD  GLU    86     -11.154  31.123  15.880  1.00 28.50           C  
ATOM   1530  OE1 GLU    86     -10.988  29.962  15.475  1.00 29.45           O  
ATOM   1531  OE2 GLU    86     -12.072  31.868  15.455  1.00 28.58           O  
ATOM   1532  N   GLU    87      -9.889  34.129  14.666  1.00 26.80           N  
ATOM   1533  CA  GLU    87     -10.319  35.541  14.658  1.00 28.88           C  
ATOM   1534  C   GLU    87     -11.535  35.799  15.502  1.00 28.11           C  
ATOM   1535  O   GLU    87     -11.872  36.940  15.774  1.00 25.77           O  
ATOM   1536  CB  GLU    87     -10.568  36.012  13.203  1.00 32.23           C  
ATOM   1537  CG  GLU    87      -9.275  36.095  12.334  1.00 38.23           C  
ATOM   1538  CD  GLU    87      -9.539  36.477  10.874  1.00 44.95           C  
ATOM   1539  OE1 GLU    87     -10.672  36.852  10.513  1.00 45.22           O  
ATOM   1540  OE2 GLU    87      -8.598  36.388  10.068  1.00 54.19           O  
ATOM   1541  N   ASP    88     -12.200  34.736  15.926  1.00 27.79           N  
ATOM   1542  CA  ASP    88     -13.409  34.877  16.766  1.00 27.66           C  
ATOM   1543  C   ASP    88     -12.946  35.104  18.198  1.00 24.62           C  
ATOM   1544  O   ASP    88     -12.305  34.262  18.811  1.00 22.62           O  
ATOM   1545  CB  ASP    88     -14.313  33.633  16.653  1.00 24.91           C  
ATOM   1546  CG  ASP    88     -15.606  33.733  17.458  1.00 24.99           C  
ATOM   1547  OD1 ASP    88     -15.621  34.014  18.689  1.00 25.75           O  
ATOM   1548  OD2 ASP    88     -16.637  33.406  16.875  1.00 26.56           O  
ATOM   1549  N   GLU    89     -13.260  36.292  18.670  1.00 24.47           N  
ATOM   1550  CA  GLU    89     -12.838  36.752  19.960  1.00 25.52           C  
ATOM   1551  C   GLU    89     -13.418  35.937  21.087  1.00 24.61           C  
ATOM   1552  O   GLU    89     -12.798  35.821  22.132  1.00 25.80           O  
ATOM   1553  CB  GLU    89     -13.190  38.217  20.139  1.00 26.20           C  
ATOM   1554  CG  GLU    89     -12.303  39.171  19.369  1.00 32.76           C  
ATOM   1555  CD  GLU    89     -10.903  39.266  19.935  1.00 45.69           C  
ATOM   1556  OE1 GLU    89     -10.691  38.911  21.134  1.00 48.75           O  
ATOM   1557  OE2 GLU    89     -10.024  39.743  19.181  1.00 50.86           O  
ATOM   1558  N   SER    90     -14.631  35.431  20.911  1.00 22.42           N  
ATOM   1559  CA  SER    90     -15.218  34.598  21.960  1.00 22.95           C  
ATOM   1560  C   SER    90     -14.452  33.258  22.052  1.00 24.76           C  
ATOM   1561  O   SER    90     -14.289  32.703  23.124  1.00 23.81           O  
ATOM   1562  CB  SER    90     -16.708  34.340  21.718  1.00 23.56           C  
ATOM   1563  OG  SER    90     -16.931  33.453  20.656  1.00 22.93           O  
ATOM   1564  N   ILE    91     -13.970  32.753  20.923  1.00 24.44           N  
ATOM   1565  CA  ILE    91     -13.220  31.478  20.922  1.00 25.61           C  
ATOM   1566  C   ILE    91     -11.841  31.727  21.536  1.00 26.70           C  
ATOM   1567  O   ILE    91     -11.346  30.941  22.345  1.00 25.04           O  
ATOM   1568  CB  ILE    91     -13.073  30.861  19.503  1.00 26.67           C  
ATOM   1569  CG1 ILE    91     -14.419  30.371  18.976  1.00 27.27           C  
ATOM   1570  CG2 ILE    91     -12.095  29.697  19.556  1.00 20.52           C  
ATOM   1571  CD1 ILE    91     -14.391  29.842  17.482  1.00 24.64           C  
ATOM   1572  N   LYS    92     -11.248  32.865  21.205  1.00 25.93           N  
ATOM   1573  CA  LYS    92      -9.946  33.192  21.769  1.00 28.64           C  
ATOM   1574  C   LYS    92      -9.999  33.309  23.288  1.00 27.15           C  
ATOM   1575  O   LYS    92      -9.083  32.861  23.959  1.00 24.46           O  
ATOM   1576  CB  LYS    92      -9.405  34.507  21.205  1.00 29.23           C  
ATOM   1577  CG  LYS    92      -9.036  34.421  19.709  1.00 35.47           C  
ATOM   1578  CD  LYS    92      -8.701  35.790  19.154  1.00 38.72           C  
ATOM   1579  CE  LYS    92      -7.547  36.408  19.888  1.00 42.97           C  
ATOM   1580  NZ  LYS    92      -7.442  37.843  19.536  1.00 46.31           N  
ATOM   1581  N   GLU    93     -11.045  33.961  23.788  1.00 24.10           N  
ATOM   1582  CA  GLU    93     -11.230  34.225  25.241  1.00 26.65           C  
ATOM   1583  C   GLU    93     -11.531  32.950  25.979  1.00 27.21           C  
ATOM   1584  O   GLU    93     -11.050  32.720  27.093  1.00 25.60           O  
ATOM   1585  CB  GLU    93     -12.369  35.215  25.486  1.00 25.01           C  
ATOM   1586  CG  GLU    93     -12.699  35.458  26.991  1.00 34.20           C  
ATOM   1587  CD  GLU    93     -11.556  36.095  27.747  1.00 35.65           C  
ATOM   1588  OE1 GLU    93     -10.778  36.797  27.093  1.00 46.70           O  
ATOM   1589  OE2 GLU    93     -11.423  35.895  28.984  1.00 35.98           O  
ATOM   1590  N   ARG    94     -12.316  32.097  25.343  1.00 27.12           N  
ATOM   1591  CA  ARG    94     -12.613  30.813  25.924  1.00 28.00           C  
ATOM   1592  C   ARG    94     -11.344  29.946  26.088  1.00 27.43           C  
ATOM   1593  O   ARG    94     -11.137  29.361  27.110  1.00 26.23           O  
ATOM   1594  CB  ARG    94     -13.656  30.092  25.082  1.00 29.52           C  
ATOM   1595  CG  ARG    94     -14.022  28.737  25.634  1.00 33.03           C  
ATOM   1596  CD  ARG    94     -14.433  28.837  27.081  1.00 36.10           C  
ATOM   1597  NE  ARG    94     -15.662  29.619  27.286  1.00 44.98           N  
ATOM   1598  CZ  ARG    94     -16.887  29.097  27.200  1.00 45.17           C  
ATOM   1599  NH1 ARG    94     -17.047  27.805  26.913  1.00 47.64           N  
ATOM   1600  NH2 ARG    94     -17.945  29.857  27.389  1.00 43.33           N  
ATOM   1601  N   ILE    95     -10.552  29.823  25.035  1.00 24.35           N  
ATOM   1602  CA  ILE    95      -9.319  29.105  25.060  1.00 24.04           C  
ATOM   1603  C   ILE    95      -8.389  29.742  26.129  1.00 24.16           C  
ATOM   1604  O   ILE    95      -7.738  29.034  26.896  1.00 24.92           O  
ATOM   1605  CB  ILE    95      -8.642  29.115  23.698  1.00 26.27           C  
ATOM   1606  CG1 ILE    95      -9.469  28.344  22.605  1.00 28.97           C  
ATOM   1607  CG2 ILE    95      -7.198  28.616  23.796  1.00 24.84           C  
ATOM   1608  CD1 ILE    95      -9.740  26.942  22.940  1.00 34.68           C  
ATOM   1609  N   TRP    96      -8.326  31.078  26.170  1.00 23.39           N  
ATOM   1610  CA  TRP    96      -7.495  31.785  27.144  1.00 21.32           C  
ATOM   1611  C   TRP    96      -7.867  31.360  28.565  1.00 24.82           C  
ATOM   1612  O   TRP    96      -7.014  31.040  29.399  1.00 22.90           O  
ATOM   1613  CB  TRP    96      -7.580  33.326  26.943  1.00 24.68           C  
ATOM   1614  CG  TRP    96      -6.959  34.140  28.049  1.00 26.84           C  
ATOM   1615  CD1 TRP    96      -7.623  34.949  28.944  1.00 30.90           C  
ATOM   1616  CD2 TRP    96      -5.560  34.192  28.439  1.00 28.62           C  
ATOM   1617  NE1 TRP    96      -6.729  35.515  29.824  1.00 35.51           N  
ATOM   1618  CE2 TRP    96      -5.465  35.057  29.548  1.00 25.02           C  
ATOM   1619  CE3 TRP    96      -4.392  33.618  27.949  1.00 27.30           C  
ATOM   1620  CZ2 TRP    96      -4.249  35.350  30.159  1.00 33.32           C  
ATOM   1621  CZ3 TRP    96      -3.187  33.904  28.592  1.00 31.13           C  
ATOM   1622  CH2 TRP    96      -3.131  34.743  29.668  1.00 30.56           C  
ATOM   1623  N   GLU    97      -9.161  31.333  28.834  1.00 26.97           N  
ATOM   1624  CA  GLU    97      -9.683  30.993  30.144  1.00 26.44           C  
ATOM   1625  C   GLU    97      -9.417  29.537  30.489  1.00 28.96           C  
ATOM   1626  O   GLU    97      -9.176  29.195  31.645  1.00 29.19           O  
ATOM   1627  CB  GLU    97     -11.196  31.323  30.213  1.00 29.88           C  
ATOM   1628  CG  GLU    97     -11.445  32.800  30.285  1.00 26.25           C  
ATOM   1629  CD  GLU    97     -12.896  33.194  30.164  1.00 33.38           C  
ATOM   1630  OE1 GLU    97     -13.775  32.312  30.248  1.00 45.27           O  
ATOM   1631  OE2 GLU    97     -13.139  34.387  29.937  1.00 31.96           O  
ATOM   1632  N   ASN    98      -9.446  28.669  29.491  0.50 29.09           N  
ATOM   1634  CA  ASN    98      -9.162  27.258  29.746  0.50 30.24           C  
ATOM   1636  C   ASN    98      -7.669  27.057  30.039  0.50 28.65           C  
ATOM   1638  O   ASN    98      -7.285  26.398  30.998  0.50 26.77           O  
ATOM   1640  CB  ASN    98      -9.605  26.390  28.584  0.50 29.92           C  
ATOM   1642  CG  ASN    98      -9.313  24.934  28.817  0.50 30.69           C  
ATOM   1644  OD1 ASN    98      -8.186  24.551  29.165  0.50 29.64           O  
ATOM   1646  ND2 ASN    98     -10.319  24.104  28.618  0.50 29.51           N  
ATOM   1648  N   ILE    99      -6.835  27.696  29.239  1.00 30.14           N  
ATOM   1649  CA  ILE    99      -5.385  27.606  29.431  1.00 30.55           C  
ATOM   1650  C   ILE    99      -4.894  28.183  30.779  1.00 31.12           C  
ATOM   1651  O   ILE    99      -4.009  27.611  31.412  1.00 33.81           O  
ATOM   1652  CB  ILE    99      -4.653  28.367  28.289  1.00 33.41           C  
ATOM   1653  CG1 ILE    99      -4.812  27.621  26.978  1.00 44.69           C  
ATOM   1654  CG2 ILE    99      -3.184  28.505  28.554  1.00 46.54           C  
ATOM   1655  CD1 ILE    99      -4.328  26.221  27.021  1.00 42.35           C  
ATOM   1656  N   SER   100      -5.451  29.326  31.193  1.00 27.06           N  
ATOM   1657  CA  SER   100      -4.987  30.084  32.374  1.00 25.77           C  
ATOM   1658  C   SER   100      -5.831  29.855  33.609  1.00 25.58           C  
ATOM   1659  O   SER   100      -5.760  30.622  34.594  1.00 23.46           O  
ATOM   1660  CB  SER   100      -5.019  31.595  32.054  1.00 20.90           C  
ATOM   1661  OG  SER   100      -6.356  32.059  31.869  1.00 23.13           O  
ATOM   1662  N   LYS   101      -6.631  28.795  33.577  1.00 27.27           N  
ATOM   1663  CA  LYS   101      -7.634  28.612  34.625  1.00 28.29           C  
ATOM   1664  C   LYS   101      -7.018  28.550  36.030  1.00 24.38           C  
ATOM   1665  O   LYS   101      -7.606  29.052  36.962  1.00 27.83           O  
ATOM   1666  CB  LYS   101      -8.543  27.414  34.370  1.00 30.29           C  
ATOM   1667  CG  LYS   101      -7.852  26.054  34.473  1.00 41.68           C  
ATOM   1668  CD  LYS   101      -8.890  24.917  34.512  1.00 46.81           C  
ATOM   1669  CE  LYS   101      -9.525  24.628  33.162  1.00 52.12           C  
ATOM   1670  NZ  LYS   101      -8.577  23.986  32.222  1.00 49.92           N  
ATOM   1671  N   ASP   102      -5.851  27.931  36.172  1.00 26.17           N  
ATOM   1672  CA  ASP   102      -5.208  27.819  37.486  1.00 24.93           C  
ATOM   1673  C   ASP   102      -4.880  29.191  38.122  1.00 24.36           C  
ATOM   1674  O   ASP   102      -4.769  29.287  39.354  1.00 29.92           O  
ATOM   1675  CB  ASP   102      -3.934  26.979  37.433  1.00 26.36           C  
ATOM   1676  CG  ASP   102      -4.203  25.480  37.373  1.00 32.59           C  
ATOM   1677  OD1 ASP   102      -5.388  25.048  37.427  1.00 33.69           O  
ATOM   1678  OD2 ASP   102      -3.191  24.743  37.318  1.00 36.93           O  
ATOM   1679  N   TRP   103      -4.765  30.242  37.301  1.00 24.60           N  
ATOM   1680  CA  TRP   103      -4.408  31.601  37.785  1.00 25.17           C  
ATOM   1681  C   TRP   103      -5.244  32.747  37.219  1.00 30.11           C  
ATOM   1682  O   TRP   103      -5.149  33.901  37.673  1.00 32.70           O  
ATOM   1683  CB  TRP   103      -2.919  31.898  37.502  1.00 28.09           C  
ATOM   1684  CG  TRP   103      -2.571  32.126  36.025  1.00 34.30           C  
ATOM   1685  CD1 TRP   103      -2.581  33.339  35.324  1.00 31.98           C  
ATOM   1686  CD2 TRP   103      -2.187  31.139  35.086  1.00 29.27           C  
ATOM   1687  NE1 TRP   103      -2.232  33.121  34.021  1.00 35.26           N  
ATOM   1688  CE2 TRP   103      -1.966  31.786  33.859  1.00 30.28           C  
ATOM   1689  CE3 TRP   103      -2.001  29.769  35.163  1.00 18.77           C  
ATOM   1690  CZ2 TRP   103      -1.606  31.115  32.754  1.00 37.18           C  
ATOM   1691  CZ3 TRP   103      -1.634  29.113  34.060  1.00 34.12           C  
ATOM   1692  CH2 TRP   103      -1.435  29.773  32.870  1.00 37.95           C  
ATOM   1693  N   PHE   104      -6.117  32.439  36.276  1.00 34.00           N  
ATOM   1694  CA  PHE   104      -6.934  33.459  35.617  1.00 35.95           C  
ATOM   1695  C   PHE   104      -7.833  34.206  36.572  1.00 35.24           C  
ATOM   1696  O   PHE   104      -8.594  33.594  37.319  1.00 34.16           O  
ATOM   1697  CB  PHE   104      -7.760  32.840  34.464  1.00 39.24           C  
ATOM   1698  CG  PHE   104      -8.773  33.787  33.844  1.00 38.94           C  
ATOM   1699  CD1 PHE   104      -8.411  34.636  32.817  1.00 36.50           C  
ATOM   1700  CD2 PHE   104     -10.091  33.796  34.272  1.00 40.95           C  
ATOM   1701  CE1 PHE   104      -9.340  35.505  32.243  1.00 40.74           C  
ATOM   1702  CE2 PHE   104     -11.026  34.660  33.703  1.00 41.12           C  
ATOM   1703  CZ  PHE   104     -10.641  35.510  32.685  1.00 42.71           C  
ATOM   1704  N   GLN   105      -7.717  35.531  36.573  1.00 34.79           N  
ATOM   1705  CA  GLN   105      -8.607  36.363  37.377  1.00 36.45           C  
ATOM   1706  C   GLN   105      -9.143  37.570  36.594  1.00 40.48           C  
ATOM   1707  O   GLN   105      -9.411  38.645  37.147  1.00 36.61           O  
ATOM   1708  CB  GLN   105      -8.006  36.755  38.757  1.00 36.06           C  
ATOM   1709  CG  GLN   105      -6.693  37.524  38.730  1.00 38.74           C  
ATOM   1710  CD  GLN   105      -6.259  38.008  40.108  1.00 27.15           C  
ATOM   1711  OE1 GLN   105      -5.901  37.207  40.992  1.00 23.55           O  
ATOM   1712  NE2 GLN   105      -6.251  39.339  40.291  1.00 33.92           N  
ATOM   1713  N   GLY   106      -9.331  37.367  35.291  1.00 43.39           N  
ATOM   1714  CA  GLY   106      -9.904  38.411  34.438  1.00 44.55           C  
ATOM   1715  C   GLY   106      -8.948  39.241  33.599  1.00 46.11           C  
ATOM   1716  O   GLY   106      -9.380  40.052  32.794  1.00 48.44           O  
ATOM   1717  N   GLU   107      -7.658  39.073  33.772  1.00 46.72           N  
ATOM   1718  CA  GLU   107      -6.717  39.761  32.944  1.00 48.03           C  
ATOM   1719  C   GLU   107      -6.746  39.219  31.524  1.00 49.31           C  
ATOM   1720  O   GLU   107      -7.100  38.105  31.283  1.00 50.37           O  
ATOM   1721  CB  GLU   107      -5.328  39.660  33.540  1.00 47.53           C  
ATOM   1722  N   ASP   108      -6.396  40.027  30.570  1.00 49.32           N  
ATOM   1723  CA  ASP   108      -6.167  39.478  29.265  1.00 50.51           C  
ATOM   1724  C   ASP   108      -4.826  39.877  28.771  1.00 47.60           C  
ATOM   1725  O   ASP   108      -4.200  40.720  29.313  1.00 48.55           O  
ATOM   1726  CB  ASP   108      -7.237  39.890  28.266  1.00 51.81           C  
ATOM   1727  CG  ASP   108      -7.812  38.721  27.513  1.00 59.75           C  
ATOM   1728  OD1 ASP   108      -7.216  38.269  26.500  1.00 69.25           O  
ATOM   1729  OD2 ASP   108      -8.866  38.247  27.943  1.00 60.83           O  
ATOM   1730  N   SER   109      -4.409  39.248  27.712  1.00 42.70           N  
ATOM   1731  CA  SER   109      -3.057  39.292  27.328  1.00 39.53           C  
ATOM   1732  C   SER   109      -3.109  39.706  25.889  1.00 37.93           C  
ATOM   1733  O   SER   109      -3.668  39.013  25.099  1.00 36.08           O  
ATOM   1734  CB  SER   109      -2.482  37.908  27.485  1.00 35.74           C  
ATOM   1735  OG  SER   109      -1.260  37.836  26.853  1.00 50.86           O  
ATOM   1736  N   PRO   110      -2.574  40.862  25.560  1.00 36.20           N  
ATOM   1737  CA  PRO   110      -2.735  41.388  24.200  1.00 34.17           C  
ATOM   1738  C   PRO   110      -1.943  40.604  23.149  1.00 28.51           C  
ATOM   1739  O   PRO   110      -2.276  40.602  21.977  1.00 30.62           O  
ATOM   1740  CB  PRO   110      -2.205  42.817  24.327  1.00 34.50           C  
ATOM   1741  CG  PRO   110      -1.144  42.732  25.361  1.00 38.99           C  
ATOM   1742  CD  PRO   110      -1.625  41.662  26.357  1.00 39.07           C  
ATOM   1743  N   SER   111      -0.931  39.896  23.588  1.00 26.60           N  
ATOM   1744  CA  SER   111      -0.087  39.204  22.652  1.00 27.88           C  
ATOM   1745  C   SER   111      -0.596  37.777  22.434  1.00 25.75           C  
ATOM   1746  O   SER   111      -0.098  37.091  21.603  1.00 24.21           O  
ATOM   1747  CB  SER   111       1.350  39.192  23.138  1.00 31.27           C  
ATOM   1748  OG  SER   111       1.500  38.284  24.205  1.00 36.14           O  
ATOM   1749  N   PHE   112      -1.644  37.389  23.154  1.00 28.87           N  
ATOM   1750  CA  PHE   112      -2.218  36.046  23.067  1.00 29.00           C  
ATOM   1751  C   PHE   112      -2.961  35.817  21.734  1.00 27.15           C  
ATOM   1752  O   PHE   112      -3.736  36.632  21.248  1.00 25.88           O  
ATOM   1753  CB  PHE   112      -3.128  35.738  24.247  1.00 30.08           C  
ATOM   1754  CG  PHE   112      -3.621  34.301  24.280  1.00 28.08           C  
ATOM   1755  CD1 PHE   112      -2.787  33.296  24.662  1.00 27.96           C  
ATOM   1756  CD2 PHE   112      -4.919  33.988  23.964  1.00 28.83           C  
ATOM   1757  CE1 PHE   112      -3.233  31.980  24.714  1.00 32.87           C  
ATOM   1758  CE2 PHE   112      -5.384  32.714  24.033  1.00 26.31           C  
ATOM   1759  CZ  PHE   112      -4.549  31.693  24.416  1.00 28.17           C  
ATOM   1760  N   VAL   113      -2.684  34.672  21.142  0.50 24.30           N  
ATOM   1762  CA  VAL   113      -3.327  34.302  19.901  0.50 23.77           C  
ATOM   1764  C   VAL   113      -3.588  32.822  19.960  0.50 24.04           C  
ATOM   1766  O   VAL   113      -3.043  32.104  20.808  0.50 21.68           O  
ATOM   1768  CB  VAL   113      -2.475  34.643  18.671  0.50 22.73           C  
ATOM   1770  CG1 VAL   113      -2.213  36.135  18.620  0.50 24.82           C  
ATOM   1772  CG2 VAL   113      -1.179  33.824  18.669  0.50 22.09           C  
ATOM   1774  N   VAL   114      -4.469  32.391  19.070  1.00 23.44           N  
ATOM   1775  CA  VAL   114      -4.847  31.005  18.988  1.00 22.58           C  
ATOM   1776  C   VAL   114      -4.680  30.527  17.543  1.00 22.66           C  
ATOM   1777  O   VAL   114      -5.131  31.199  16.604  1.00 20.35           O  
ATOM   1778  CB  VAL   114      -6.294  30.776  19.501  1.00 23.21           C  
ATOM   1779  CG1 VAL   114      -6.808  29.290  19.211  1.00 21.96           C  
ATOM   1780  CG2 VAL   114      -6.424  31.169  21.022  1.00 21.87           C  
ATOM   1781  N   ILE   115      -3.940  29.431  17.411  1.00 23.01           N  
ATOM   1782  CA  ILE   115      -3.781  28.710  16.168  1.00 26.40           C  
ATOM   1783  C   ILE   115      -4.855  27.650  16.069  1.00 25.68           C  
ATOM   1784  O   ILE   115      -4.964  26.714  16.887  1.00 21.88           O  
ATOM   1785  CB  ILE   115      -2.385  28.102  15.995  1.00 27.41           C  
ATOM   1786  CG1 ILE   115      -1.353  29.231  16.088  1.00 25.65           C  
ATOM   1787  CG2 ILE   115      -2.310  27.350  14.623  1.00 21.73           C  
ATOM   1788  CD1 ILE   115       0.119  28.811  16.281  1.00 23.90           C  
ATOM   1789  N   LYS   116      -5.675  27.829  15.037  1.00 24.59           N  
ATOM   1790  CA  LYS   116      -6.770  26.916  14.730  1.00 24.48           C  
ATOM   1791  C   LYS   116      -6.264  25.974  13.693  1.00 24.99           C  
ATOM   1792  O   LYS   116      -5.629  26.398  12.725  1.00 22.82           O  
ATOM   1793  CB  LYS   116      -7.972  27.677  14.165  1.00 24.07           C  
ATOM   1794  CG  LYS   116      -9.158  26.781  13.740  1.00 29.98           C  
ATOM   1795  CD  LYS   116     -10.210  27.567  12.898  1.00 26.90           C  
ATOM   1796  CE  LYS   116     -11.451  26.766  12.786  1.00 39.03           C  
ATOM   1797  NZ  LYS   116     -12.534  27.439  11.993  1.00 36.98           N  
ATOM   1798  N   ILE   117      -6.501  24.689  13.894  1.00 23.12           N  
ATOM   1799  CA  ILE   117      -6.088  23.710  12.889  1.00 24.67           C  
ATOM   1800  C   ILE   117      -7.274  22.911  12.408  1.00 22.63           C  
ATOM   1801  O   ILE   117      -7.896  22.146  13.175  1.00 23.51           O  
ATOM   1802  CB  ILE   117      -4.971  22.769  13.398  1.00 24.32           C  
ATOM   1803  CG1 ILE   117      -3.739  23.593  13.802  1.00 23.43           C  
ATOM   1804  CG2 ILE   117      -4.647  21.690  12.353  1.00 22.46           C  
ATOM   1805  CD1 ILE   117      -2.857  22.926  14.780  1.00 29.93           C  
ATOM   1806  N   VAL   118      -7.541  23.056  11.109  1.00 22.92           N  
ATOM   1807  CA  VAL   118      -8.609  22.333  10.418  1.00 24.35           C  
ATOM   1808  C   VAL   118      -8.024  21.095   9.739  1.00 22.53           C  
ATOM   1809  O   VAL   118      -7.231  21.177   8.816  1.00 25.36           O  
ATOM   1810  CB  VAL   118      -9.412  23.261   9.409  1.00 25.46           C  
ATOM   1811  CG1 VAL   118     -10.457  22.460   8.588  1.00 22.00           C  
ATOM   1812  CG2 VAL   118     -10.093  24.366  10.166  1.00 23.69           C  
ATOM   1813  N   PRO   119      -8.399  19.907  10.196  1.00 26.30           N  
ATOM   1814  CA  PRO   119      -7.805  18.708   9.598  1.00 23.16           C  
ATOM   1815  C   PRO   119      -8.249  18.413   8.191  1.00 23.39           C  
ATOM   1816  O   PRO   119      -9.413  18.576   7.884  1.00 21.45           O  
ATOM   1817  CB  PRO   119      -8.350  17.590  10.492  1.00 26.11           C  
ATOM   1818  CG  PRO   119      -8.743  18.279  11.769  1.00 35.28           C  
ATOM   1819  CD  PRO   119      -9.305  19.557  11.300  1.00 27.67           C  
ATOM   1820  N   GLU   120      -7.330  17.947   7.351  1.00 22.68           N  
ATOM   1821  CA  GLU   120      -7.670  17.614   5.964  1.00 21.99           C  
ATOM   1822  C   GLU   120      -7.601  16.102   5.818  1.00 22.64           C  
ATOM   1823  O   GLU   120      -8.355  15.469   5.064  1.00 24.80           O  
ATOM   1824  CB  GLU   120      -6.736  18.335   4.969  1.00 22.70           C  
ATOM   1825  CG  GLU   120      -6.900  19.845   5.001  1.00 20.40           C  
ATOM   1826  CD  GLU   120      -8.306  20.290   4.534  1.00 34.03           C  
ATOM   1827  OE1 GLU   120      -8.966  19.534   3.783  1.00 30.66           O  
ATOM   1828  OE2 GLU   120      -8.712  21.408   4.885  1.00 30.18           O  
ATOM   1829  N   GLN   121      -6.709  15.527   6.594  1.00 24.66           N  
ATOM   1830  CA  GLN   121      -6.496  14.081   6.638  1.00 23.73           C  
ATOM   1831  C   GLN   121      -6.116  13.668   8.034  1.00 24.77           C  
ATOM   1832  O   GLN   121      -5.267  14.305   8.654  1.00 23.86           O  
ATOM   1833  CB  GLN   121      -5.373  13.753   5.682  1.00 25.65           C  
ATOM   1834  CG  GLN   121      -5.802  14.075   4.254  1.00 40.52           C  
ATOM   1835  CD  GLN   121      -4.797  14.893   3.417  1.00 54.09           C  
ATOM   1836  OE1 GLN   121      -3.747  15.361   3.914  1.00 52.65           O  
ATOM   1837  NE2 GLN   121      -5.164  15.122   2.141  1.00 48.47           N  
ATOM   1838  N   ILE   122      -6.731  12.593   8.524  1.00 21.91           N  
ATOM   1839  CA  ILE   122      -6.380  12.019   9.821  1.00 24.16           C  
ATOM   1840  C   ILE   122      -6.192  10.559   9.697  1.00 25.57           C  
ATOM   1841  O   ILE   122      -7.104   9.882   9.250  1.00 24.21           O  
ATOM   1842  CB  ILE   122      -7.443  12.235  10.907  1.00 20.31           C  
ATOM   1843  CG1 ILE   122      -7.883  13.710  10.977  1.00 23.42           C  
ATOM   1844  CG2 ILE   122      -6.879  11.770  12.208  1.00 22.36           C  
ATOM   1845  CD1 ILE   122      -8.873  14.009  12.042  1.00 30.33           C  
ATOM   1846  N   ARG   123      -4.984  10.091  10.057  1.00 23.37           N  
ATOM   1847  CA  ARG   123      -4.657   8.692  10.024  1.00 26.13           C  
ATOM   1848  C   ARG   123      -4.416   8.207  11.435  1.00 26.76           C  
ATOM   1849  O   ARG   123      -3.755   8.905  12.241  1.00 24.02           O  
ATOM   1850  CB  ARG   123      -3.386   8.451   9.252  1.00 28.72           C  
ATOM   1851  CG  ARG   123      -3.494   8.665   7.788  1.00 40.48           C  
ATOM   1852  CD  ARG   123      -2.445   7.803   7.120  1.00 48.20           C  
ATOM   1853  NE  ARG   123      -1.123   8.352   7.326  1.00 50.46           N  
ATOM   1854  CZ  ARG   123      -0.001   7.660   7.174  1.00 49.84           C  
ATOM   1855  NH1 ARG   123      -0.052   6.365   6.840  1.00 45.51           N  
ATOM   1856  NH2 ARG   123       1.170   8.264   7.381  1.00 39.62           N  
ATOM   1857  N   ILE   124      -5.011   7.063  11.760  1.00 22.50           N  
ATOM   1858  CA  ILE   124      -4.734   6.415  13.038  1.00 24.45           C  
ATOM   1859  C   ILE   124      -3.657   5.435  12.717  1.00 24.58           C  
ATOM   1860  O   ILE   124      -3.829   4.523  11.892  1.00 20.24           O  
ATOM   1861  CB  ILE   124      -5.901   5.643  13.688  1.00 24.08           C  
ATOM   1862  CG1 ILE   124      -7.099   6.516  13.996  1.00 30.86           C  
ATOM   1863  CG2 ILE   124      -5.500   5.102  15.081  1.00 30.84           C  
ATOM   1864  CD1 ILE   124      -8.273   5.660  14.599  1.00 33.77           C  
ATOM   1865  N   LEU   125      -2.550   5.620  13.404  1.00 24.22           N  
ATOM   1866  CA  LEU   125      -1.399   4.785  13.257  1.00 26.90           C  
ATOM   1867  C   LEU   125      -1.216   3.896  14.470  1.00 28.39           C  
ATOM   1868  O   LEU   125      -1.678   4.229  15.576  1.00 24.33           O  
ATOM   1869  CB  LEU   125      -0.177   5.688  13.040  1.00 27.04           C  
ATOM   1870  CG  LEU   125      -0.197   6.589  11.806  1.00 29.37           C  
ATOM   1871  CD1 LEU   125       1.070   7.462  11.763  1.00 36.63           C  
ATOM   1872  CD2 LEU   125      -0.356   5.782  10.517  1.00 32.33           C  
ATOM   1873  N   ASN   126      -0.555   2.754  14.231  1.00 29.72           N  
ATOM   1874  CA  ASN   126      -0.239   1.761  15.256  1.00 30.16           C  
ATOM   1875  C   ASN   126      -1.513   1.250  15.937  1.00 30.72           C  
ATOM   1876  O   ASN   126      -1.550   0.994  17.153  1.00 28.12           O  
ATOM   1877  CB  ASN   126       0.769   2.326  16.280  1.00 31.62           C  
ATOM   1878  CG  ASN   126       1.511   1.238  17.057  1.00 29.72           C  
ATOM   1879  OD1 ASN   126       1.805   0.173  16.523  1.00 30.95           O  
ATOM   1880  ND2 ASN   126       1.842   1.515  18.310  1.00 31.08           N  
ATOM   1881  N   SER   127      -2.581   1.127  15.154  1.00 27.81           N  
ATOM   1882  CA  SER   127      -3.838   0.639  15.724  1.00 30.83           C  
ATOM   1883  C   SER   127      -3.832  -0.864  15.874  1.00 27.77           C  
ATOM   1884  O   SER   127      -4.618  -1.369  16.648  1.00 29.89           O  
ATOM   1885  CB  SER   127      -5.074   1.089  14.920  1.00 30.64           C  
ATOM   1886  OG  SER   127      -4.993   0.621  13.602  1.00 34.66           O  
ATOM   1887  OXT SER   127      -3.051  -1.593  15.260  1.00 27.95           O  
END
