
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  113 (  869),  selected  113 , name 2ns1_B
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 2ns1_B.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      K       3           -
LGA    S     0_B      R       4          3.892
LGA    M     1_B      A       5          0.430
LGA    K     2_B      N       6          0.743
LGA    L     3_B      K       7          0.598
LGA    V     4_B      L       8          0.821
LGA    T     5_B      V       9          0.869
LGA    V     6_B      I      10          0.701
LGA    I     7_B      V      11          0.535
LGA    I     8_B      T      12          0.516
LGA    K     9_B      E      13          0.687
LGA    P    10_B      K      14          0.652
LGA    F    11_B      V      15          0.965
LGA    K    12_B      L      16          0.817
LGA    L    13_B      L      17          1.156
LGA    E    14_B      K      18          0.908
LGA    D    15_B      K      19          0.917
LGA    V    16_B      V      20          0.812
LGA    R    17_B      A      21          1.117
LGA    E    18_B      K      22          1.024
LGA    A    19_B      I      23          1.262
LGA    L    20_B      I      24          1.525
LGA    S    21_B      E      25          1.450
LGA    S    22_B      E      26          1.368
LGA    I    23_B      A      27          1.743
LGA    G    24_B      G      28          1.147
LGA    I    25_B      A      29          1.621
LGA    Q    26_B      T      30          4.971
LGA    G    27_B      G      31          1.241
LGA    L    28_B      Y      32          0.669
LGA    T    29_B      T      33          0.581
LGA    V    30_B      V      34          0.603
LGA    T    31_B      V      35          0.599
LGA    E    32_B      D      36          0.502
LGA    V    33_B      T      37          0.391
LGA    K    34_B      G      38          0.165
LGA    G    35_B      G      39          1.522
LGA    F    36_B      -       -           -
LGA    G    37_B      -       -           -
LGA    R    38_B      -       -           -
LGA    Q    39_B      -       -           -
LGA    K    40_B      -       -           -
LGA    G    41_B      -       -           -
LGA    H    42_B      -       -           -
LGA    A    43_B      -       -           -
LGA    E    44_B      -       -           -
LGA    L    45_B      -       -           -
LGA    Y    46_B      -       -           -
LGA    R    47_B      -       -           -
LGA    G    48_B      -       -           -
LGA    A    49_B      -       -           -
LGA    E    50_B      -       -           -
LGA    F    51_B      -       -           -
LGA    S    52_B      -       -           -
LGA    V    53_B      -       -           -
LGA    N    54_B      -       -           -
LGA    F    55_B      -       -           -
LGA    L    56_B      -       -           -
LGA    P    57_B      S      58          0.792
LGA    K    58_B      N      59          0.399
LGA    V    59_B      V      60          0.291
LGA    K    60_B      K      61          0.447
LGA    I    61_B      F      62          0.479
LGA    D    62_B      E      63          0.763
LGA    V    63_B      V      64          0.788
LGA    A    64_B      L      65          0.761
LGA    I    65_B      T      66          0.753
LGA    A    66_B      E      67          2.203
LGA    D    67_B      N      68          2.627
LGA    D    68_B      R      69          3.508
LGA    -       -      E      70           -
LGA    Q    69_B      M      71          1.597
LGA    L    70_B      A      72          2.097
LGA    D    71_B      E      73          1.802
LGA    E    72_B      K      74          1.031
LGA    V    73_B      I      75          1.911
LGA    I    74_B      A      76          1.480
LGA    D    75_B      D      77          1.058
LGA    I    76_B      Q      78          1.928
LGA    V    77_B      V      79          2.363
LGA    S    78_B      A      80          1.645
LGA    K    79_B      I      81          3.134
LGA    A    80_B      K      82          4.181
LGA    A    81_B      F      83          3.607
LGA    Y    82_B      F      84          2.881
LGA    T    83_B      -       -           -
LGA    G    84_B      T      85          2.173
LGA    K    85_B      D      86          3.734
LGA    I    86_B      Y      87          5.937
LGA    G    87_B      -       -           -
LGA    D    88_B      A      88          1.332
LGA    G    89_B      G      89          0.749
LGA    K    90_B      I      90          0.098
LGA    I    91_B      I      91          0.537
LGA    F    92_B      Y      92          1.508
LGA    V    93_B      I      93          0.607
LGA    A    94_B      C      94          0.465
LGA    E    95_B      E      95          0.222
LGA    L    96_B      A      96          0.501
LGA    Q    97_B      E      97          1.697
LGA    R    98_B      V      98          2.125
LGA    V    99_B      L      99          4.072
LGA    I   100_B      Y     100          1.148
LGA    R   101_B      G     101          1.801
LGA    I   102_B      -       -           -
LGA    R   103_B      -       -           -
LGA    T   104_B      -       -           -
LGA    G   105_B      -       -           -
LGA    E   106_B      -       -           -
LGA    A   107_B      -       -           -
LGA    D   108_B      -       -           -
LGA    E   109_B      -       -           -
LGA    A   110_B      -       -           -
LGA    A   111_B      -       -           -
LGA    L   112_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  113   83    5.0     79    1.84    18.99     87.297     4.073

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.483987 * X  +  -0.074310 * Y  +   0.871915 * Z  + -172.033936
  Y_new =   0.054569 * X  +   0.997012 * Y  +   0.054681 * Z  +   8.395245
  Z_new =  -0.873372 * X  +   0.021114 * Y  +   0.486595 * Z  + -76.719658 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.043365   -3.098228  [ DEG:     2.4846   -177.5154 ]
  Theta =   1.062084    2.079509  [ DEG:    60.8529    119.1471 ]
  Phi   =   0.112274   -3.029319  [ DEG:     6.4328   -173.5672 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ns1_B                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ns1_B.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  113   83   5.0   79   1.84   18.99  87.297
REMARK  ---------------------------------------------------------- 
MOLECULE 2ns1_B
HEADER    TRANSPORT PROTEIN/SIGNALING PROTEIN     02-NOV-06   2NS1              
TITLE     CRYSTAL STRUCTURE OF THE E. COLI AMMONIA CHANNEL AMTB                 
TITLE    2 COMPLEXED WITH THE SIGNAL TRANSDUCTION PROTEIN GLNK                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: AMMONIA CHANNEL;                                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 23-428;                                           
COMPND   5 SYNONYM: AMMONIA TRANSPORTER;                                        
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: NITROGEN REGULATORY PROTEIN P-II 2;                        
COMPND   9 CHAIN: B;                                                            
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: K12;                                                         
SOURCE   5 GENE: AMTB;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: C43;                                       
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET29B;                                   
SOURCE  11 MOL_ID: 2;                                                           
SOURCE  12 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE  13 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  14 STRAIN: K12;                                                         
SOURCE  15 GENE: GLNK;                                                          
SOURCE  16 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  17 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  18 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  19 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  20 EXPRESSION_SYSTEM_PLASMID: PET47B                                    
KEYWDS    PROTEIN-PROTEIN COMPLEX, MEMBRANE PROTEIN, AMMONIA, CHANNEL,          
KEYWDS   2 REGULATORY, INHIBITOR, SIGNAL PROTEIN, ADP, BOG, STRUCTURAL          
KEYWDS   3 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, CENTER FOR            
KEYWDS   4 STRUCTURES OF MEMBRANE PROTEINS, CSMP                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.GRUSWITZ,J.O'CONNELL III,R.M.STROUD,CENTER FOR STRUCTURES           
AUTHOR   2 OF MEMBRANE PROTEINS (CSMP)                                          
REVDAT   3   16-JAN-07 2NS1    1       HEADER                                   
REVDAT   2   09-JAN-07 2NS1    1       DBREF                                    
REVDAT   1   26-DEC-06 2NS1    0                                                
JRNL        AUTH   F.GRUSWITZ,J.O'CONNELL III,R.M.STROUD                        
JRNL        TITL   INHIBITORY COMPLEX OF THE TRANSMEMBRANE AMMONIA              
JRNL        TITL 2 CHANNEL, AMTB, AND THE CYTOSOLIC REGULATORY                  
JRNL        TITL 3 PROTEIN, GLNK, AT 1.96                                       
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V. 104    42 2007              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 1.96 ANGSTROMS.                                          
DBREF  2NS1 A    1   406  UNP    P69681   AMTB_ECOLI      23    428             
DBREF  2NS1 B    1   112  UNP    P0AC55   GLNK_ECOLI       1    112             
SEQRES   1 A  412  ALA PRO ALA VAL ALA ASP LYS ALA ASP ASN ALA PHE MET          
SEQRES   2 A  412  MET ILE CYS THR ALA LEU VAL LEU PHE MET THR ILE PRO          
SEQRES   3 A  412  GLY ILE ALA LEU PHE TYR GLY GLY LEU ILE ARG GLY LYS          
SEQRES   4 A  412  ASN VAL LEU SER MET LEU THR GLN VAL THR VAL THR PHE          
SEQRES   5 A  412  ALA LEU VAL CYS ILE LEU TRP VAL VAL TYR GLY TYR SER          
SEQRES   6 A  412  LEU ALA PHE GLY GLU GLY ASN ASN PHE PHE GLY ASN ILE          
SEQRES   7 A  412  ASN TRP LEU MET LEU LYS ASN ILE GLU LEU THR ALA VAL          
SEQRES   8 A  412  MET GLY SER ILE TYR GLN TYR ILE HIS VAL ALA PHE GLN          
SEQRES   9 A  412  GLY SER PHE ALA CYS ILE THR VAL GLY LEU ILE VAL GLY          
SEQRES  10 A  412  ALA LEU ALA GLU ARG ILE ARG PHE SER ALA VAL LEU ILE          
SEQRES  11 A  412  PHE VAL VAL VAL TRP LEU THR LEU SER TYR ILE PRO ILE          
SEQRES  12 A  412  ALA HIS MET VAL TRP GLY GLY GLY LEU LEU ALA SER HIS          
SEQRES  13 A  412  GLY ALA LEU ASP PHE ALA GLY GLY THR VAL VAL HIS ILE          
SEQRES  14 A  412  ASN ALA ALA ILE ALA GLY LEU VAL GLY ALA TYR LEU ILE          
SEQRES  15 A  412  GLY LYS ARG VAL GLY PHE GLY LYS GLU ALA PHE LYS PRO          
SEQRES  16 A  412  HIS ASN LEU PRO MET VAL PHE THR GLY THR ALA ILE LEU          
SEQRES  17 A  412  TYR ILE GLY TRP PHE GLY PHE ASN ALA GLY SER ALA GLY          
SEQRES  18 A  412  THR ALA ASN GLU ILE ALA ALA LEU ALA PHE VAL ASN THR          
SEQRES  19 A  412  VAL VAL ALA THR ALA ALA ALA ILE LEU GLY TRP ILE PHE          
SEQRES  20 A  412  GLY GLU TRP ALA LEU ARG GLY LYS PRO SER LEU LEU GLY          
SEQRES  21 A  412  ALA CYS SER GLY ALA ILE ALA GLY LEU VAL GLY VAL THR          
SEQRES  22 A  412  PRO ALA CYS GLY TYR ILE GLY VAL GLY GLY ALA LEU ILE          
SEQRES  23 A  412  ILE GLY VAL VAL ALA GLY LEU ALA GLY LEU TRP GLY VAL          
SEQRES  24 A  412  THR MET LEU LYS ARG LEU LEU ARG VAL ASP ASP PRO CYS          
SEQRES  25 A  412  ASP VAL PHE GLY VAL HIS GLY VAL CYS GLY ILE VAL GLY          
SEQRES  26 A  412  CYS ILE MET THR GLY ILE PHE ALA ALA SER SER LEU GLY          
SEQRES  27 A  412  GLY VAL GLY PHE ALA GLU GLY VAL THR MET GLY HIS GLN          
SEQRES  28 A  412  LEU LEU VAL GLN LEU GLU SER ILE ALA ILE THR ILE VAL          
SEQRES  29 A  412  TRP SER GLY VAL VAL ALA PHE ILE GLY TYR LYS LEU ALA          
SEQRES  30 A  412  ASP LEU THR VAL GLY LEU ARG VAL PRO GLU GLU GLN GLU          
SEQRES  31 A  412  ARG GLU GLY LEU ASP VAL ASN SER HIS GLY GLU ASN ALA          
SEQRES  32 A  412  TYR ASN ALA GLY THR LEU VAL PRO ARG                          
SEQRES   1 B  116  GLY PRO GLY SER MET LYS LEU VAL THR VAL ILE ILE LYS          
SEQRES   2 B  116  PRO PHE LYS LEU GLU ASP VAL ARG GLU ALA LEU SER SER          
SEQRES   3 B  116  ILE GLY ILE GLN GLY LEU THR VAL THR GLU VAL LYS GLY          
SEQRES   4 B  116  PHE GLY ARG GLN LYS GLY HIS ALA GLU LEU TYR ARG GLY          
SEQRES   5 B  116  ALA GLU PHE SER VAL ASN PHE LEU PRO LYS VAL LYS ILE          
SEQRES   6 B  116  ASP VAL ALA ILE ALA ASP ASP GLN LEU ASP GLU VAL ILE          
SEQRES   7 B  116  ASP ILE VAL SER LYS ALA ALA TYR THR GLY LYS ILE GLY          
SEQRES   8 B  116  ASP GLY LYS ILE PHE VAL ALA GLU LEU GLN ARG VAL ILE          
SEQRES   9 B  116  ARG ILE ARG THR GLY GLU ALA ASP GLU ALA ALA LEU              
HET    BOG    601      20                                                       
HET    BOG    602      20                                                       
HET    BOG    603      20                                                       
HET    BOG    604      20                                                       
HET    BOG    605      20                                                       
HET    BOG    606      20                                                       
HET    BOG    607      20                                                       
HET    BOG    608      20                                                       
HET    ADP  B 200      27                                                       
HET    TRS    701       8                                                       
HET    TRS    702       8                                                       
HETNAM     BOG B-OCTYLGLUCOSIDE                                                 
HETNAM     ADP ADENOSINE-5'-DIPHOSPHATE                                         
HETNAM     TRS 2-AMINO-2-HYDROXYMETHYL-PROPANE-1,3-DIOL                         
HETSYN     TRS TRIS BUFFER                                                      
FORMUL   3  BOG    8(C14 H28 O6)                                                
FORMUL  11  ADP    C10 H15 N5 O10 P2                                            
FORMUL  12  TRS    2(C4 H12 N O3 1+)                                            
FORMUL  14  HOH   *498(H2 O)                                                    
CRYST1  102.032  102.032  363.849  90.00  90.00 120.00 H 3 2        18          
ATOM   3024  N   SER B   0     -44.497   7.040  -8.658  1.00 67.14           N  
ATOM   3025  CA  SER B   0     -44.169   6.077  -9.752  1.00 64.86           C  
ATOM   3026  C   SER B   0     -45.411   5.529 -10.473  1.00 61.47           C  
ATOM   3027  O   SER B   0     -45.281   4.704 -11.378  1.00 65.84           O  
ATOM   3028  CB  SER B   0     -43.331   4.914  -9.215  1.00 64.12           C  
ATOM   3029  OG  SER B   0     -44.154   3.843  -8.772  1.00 70.68           O  
ATOM   3030  N   MET B   1     -46.603   5.949 -10.045  1.00 52.88           N  
ATOM   3031  CA  MET B   1     -47.812   5.808 -10.861  1.00 49.58           C  
ATOM   3032  C   MET B   1     -48.074   7.196 -11.487  1.00 46.02           C  
ATOM   3033  O   MET B   1     -47.836   8.225 -10.855  1.00 38.21           O  
ATOM   3034  CB  MET B   1     -49.016   5.361 -10.017  1.00 53.73           C  
ATOM   3035  CG  MET B   1     -48.898   3.987  -9.342  1.00 50.05           C  
ATOM   3036  SD  MET B   1     -48.405   2.652 -10.470  1.00 58.45           S  
ATOM   3037  CE  MET B   1     -49.937   2.404 -11.392  1.00 53.98           C  
ATOM   3038  N   LYS B   2     -48.522   7.214 -12.741  1.00 42.20           N  
ATOM   3039  CA  LYS B   2     -48.847   8.464 -13.434  1.00 41.46           C  
ATOM   3040  C   LYS B   2     -50.288   8.421 -13.947  1.00 38.88           C  
ATOM   3041  O   LYS B   2     -50.795   7.365 -14.347  1.00 36.23           O  
ATOM   3042  CB  LYS B   2     -47.909   8.683 -14.623  1.00 42.92           C  
ATOM   3043  CG  LYS B   2     -46.436   8.642 -14.272  1.00 43.02           C  
ATOM   3044  CD  LYS B   2     -46.010   9.840 -13.453  1.00 45.26           C  
ATOM   3045  CE  LYS B   2     -44.484   9.907 -13.377  1.00 47.19           C  
ATOM   3046  NZ  LYS B   2     -44.033  10.265 -12.013  1.00 50.17           N  
ATOM   3047  N   LEU B   3     -50.940   9.575 -13.936  1.00 40.32           N  
ATOM   3048  CA  LEU B   3     -52.175   9.739 -14.675  1.00 37.74           C  
ATOM   3049  C   LEU B   3     -51.839  10.504 -15.945  1.00 31.75           C  
ATOM   3050  O   LEU B   3     -51.371  11.638 -15.881  1.00 38.72           O  
ATOM   3051  CB  LEU B   3     -53.218  10.523 -13.872  1.00 40.51           C  
ATOM   3052  CG  LEU B   3     -54.591  10.628 -14.558  1.00 36.77           C  
ATOM   3053  CD1 LEU B   3     -55.207   9.213 -14.638  1.00 42.34           C  
ATOM   3054  CD2 LEU B   3     -55.496  11.587 -13.778  1.00 40.79           C  
ATOM   3055  N   VAL B   4     -52.097   9.872 -17.085  1.00 31.86           N  
ATOM   3056  CA  VAL B   4     -51.937  10.504 -18.370  1.00 34.26           C  
ATOM   3057  C   VAL B   4     -53.309  10.925 -18.868  1.00 36.71           C  
ATOM   3058  O   VAL B   4     -54.207  10.094 -18.965  1.00 36.84           O  
ATOM   3059  CB  VAL B   4     -51.263   9.556 -19.355  1.00 33.28           C  
ATOM   3060  CG1 VAL B   4     -51.160  10.204 -20.762  1.00 36.37           C  
ATOM   3061  CG2 VAL B   4     -49.887   9.178 -18.826  1.00 35.06           C  
ATOM   3062  N   THR B   5     -53.458  12.219 -19.159  1.00 35.33           N  
ATOM   3063  CA  THR B   5     -54.671  12.775 -19.745  1.00 32.88           C  
ATOM   3064  C   THR B   5     -54.369  13.163 -21.171  1.00 34.94           C  
ATOM   3065  O   THR B   5     -53.361  13.819 -21.434  1.00 39.11           O  
ATOM   3066  CB  THR B   5     -55.120  14.057 -19.002  1.00 40.27           C  
ATOM   3067  OG1 THR B   5     -55.370  13.741 -17.643  1.00 39.43           O  
ATOM   3068  CG2 THR B   5     -56.379  14.666 -19.627  1.00 39.16           C  
ATOM   3069  N   VAL B   6     -55.251  12.770 -22.085  1.00 32.94           N  
ATOM   3070  CA  VAL B   6     -55.101  13.068 -23.499  1.00 37.97           C  
ATOM   3071  C   VAL B   6     -56.389  13.709 -24.006  1.00 38.69           C  
ATOM   3072  O   VAL B   6     -57.460  13.145 -23.851  1.00 37.07           O  
ATOM   3073  CB  VAL B   6     -54.827  11.772 -24.303  1.00 42.04           C  
ATOM   3074  CG1 VAL B   6     -54.423  12.112 -25.725  1.00 50.32           C  
ATOM   3075  CG2 VAL B   6     -53.741  10.951 -23.651  1.00 41.34           C  
ATOM   3076  N   ILE B   7     -56.277  14.878 -24.615  1.00 36.48           N  
ATOM   3077  CA  ILE B   7     -57.419  15.571 -25.207  1.00 36.88           C  
ATOM   3078  C   ILE B   7     -57.234  15.509 -26.715  1.00 41.72           C  
ATOM   3079  O   ILE B   7     -56.256  16.032 -27.243  1.00 36.90           O  
ATOM   3080  CB  ILE B   7     -57.503  17.012 -24.734  1.00 36.49           C  
ATOM   3081  CG1 ILE B   7     -57.719  17.038 -23.218  1.00 40.96           C  
ATOM   3082  CG2 ILE B   7     -58.636  17.743 -25.441  1.00 40.50           C  
ATOM   3083  CD1 ILE B   7     -57.364  18.370 -22.581  1.00 47.17           C  
ATOM   3084  N   ILE B   8     -58.158  14.846 -27.401  1.00 35.53           N  
ATOM   3085  CA  ILE B   8     -57.968  14.541 -28.817  1.00 39.04           C  
ATOM   3086  C   ILE B   8     -59.233  14.791 -29.602  1.00 42.71           C  
ATOM   3087  O   ILE B   8     -60.306  15.020 -29.039  1.00 39.42           O  
ATOM   3088  CB  ILE B   8     -57.522  13.064 -29.038  1.00 40.95           C  
ATOM   3089  CG1 ILE B   8     -58.456  12.093 -28.297  1.00 45.04           C  
ATOM   3090  CG2 ILE B   8     -56.105  12.877 -28.596  1.00 44.57           C  
ATOM   3091  CD1 ILE B   8     -58.465  10.657 -28.837  1.00 47.13           C  
ATOM   3092  N   LYS B   9     -59.085  14.754 -30.921  1.00 43.01           N  
ATOM   3093  CA  LYS B   9     -60.227  14.771 -31.816  1.00 40.40           C  
ATOM   3094  C   LYS B   9     -61.012  13.461 -31.617  1.00 39.82           C  
ATOM   3095  O   LYS B   9     -60.421  12.381 -31.509  1.00 38.32           O  
ATOM   3096  CB  LYS B   9     -59.746  14.945 -33.266  1.00 44.69           C  
ATOM   3097  CG  LYS B   9     -59.450  16.404 -33.609  1.00 49.92           C  
ATOM   3098  CD  LYS B   9     -58.594  16.584 -34.881  1.00 50.15           C  
ATOM   3099  CE  LYS B   9     -58.193  18.059 -35.081  1.00 47.83           C  
ATOM   3100  NZ  LYS B   9     -57.080  18.234 -36.066  1.00 52.91           N  
ATOM   3101  N   PRO B  10     -62.341  13.557 -31.509  1.00 37.81           N  
ATOM   3102  CA  PRO B  10     -63.085  12.344 -31.181  1.00 49.17           C  
ATOM   3103  C   PRO B  10     -62.876  11.149 -32.132  1.00 51.42           C  
ATOM   3104  O   PRO B  10     -62.902  10.011 -31.668  1.00 50.41           O  
ATOM   3105  CB  PRO B  10     -64.537  12.812 -31.180  1.00 43.76           C  
ATOM   3106  CG  PRO B  10     -64.461  14.281 -30.944  1.00 47.52           C  
ATOM   3107  CD  PRO B  10     -63.221  14.731 -31.617  1.00 46.66           C  
ATOM   3108  N   PHE B  11     -62.638  11.401 -33.422  1.00 51.46           N  
ATOM   3109  CA  PHE B  11     -62.426  10.316 -34.383  1.00 54.04           C  
ATOM   3110  C   PHE B  11     -61.087   9.605 -34.210  1.00 59.85           C  
ATOM   3111  O   PHE B  11     -60.889   8.522 -34.775  1.00 60.62           O  
ATOM   3112  CB  PHE B  11     -62.648  10.758 -35.848  1.00 62.14           C  
ATOM   3113  CG  PHE B  11     -61.767  11.897 -36.319  1.00 60.87           C  
ATOM   3114  CD1 PHE B  11     -62.261  13.188 -36.387  1.00 64.28           C  
ATOM   3115  CD2 PHE B  11     -60.473  11.664 -36.747  1.00 64.44           C  
ATOM   3116  CE1 PHE B  11     -61.470  14.242 -36.834  1.00 65.79           C  
ATOM   3117  CE2 PHE B  11     -59.675  12.706 -37.199  1.00 64.73           C  
ATOM   3118  CZ  PHE B  11     -60.180  13.999 -37.243  1.00 66.23           C  
ATOM   3119  N   LYS B  12     -60.179  10.174 -33.415  1.00 47.37           N  
ATOM   3120  CA  LYS B  12     -58.917   9.493 -33.145  1.00 46.19           C  
ATOM   3121  C   LYS B  12     -58.991   8.552 -31.968  1.00 37.58           C  
ATOM   3122  O   LYS B  12     -58.019   7.865 -31.674  1.00 50.40           O  
ATOM   3123  CB  LYS B  12     -57.778  10.493 -32.941  1.00 43.30           C  
ATOM   3124  CG  LYS B  12     -57.613  11.505 -34.076  1.00 54.01           C  
ATOM   3125  CD  LYS B  12     -57.436  10.867 -35.456  1.00 55.55           C  
ATOM   3126  CE  LYS B  12     -56.184  10.035 -35.555  1.00 56.77           C  
ATOM   3127  NZ  LYS B  12     -55.815   9.748 -36.976  1.00 57.07           N  
ATOM   3128  N   LEU B  13     -60.141   8.487 -31.298  1.00 47.75           N  
ATOM   3129  CA  LEU B  13     -60.265   7.668 -30.086  1.00 46.32           C  
ATOM   3130  C   LEU B  13     -59.967   6.189 -30.313  1.00 36.66           C  
ATOM   3131  O   LEU B  13     -59.247   5.571 -29.523  1.00 46.86           O  
ATOM   3132  CB  LEU B  13     -61.664   7.817 -29.465  1.00 47.25           C  
ATOM   3133  CG  LEU B  13     -61.947   6.950 -28.220  1.00 48.53           C  
ATOM   3134  CD1 LEU B  13     -60.863   7.092 -27.164  1.00 45.10           C  
ATOM   3135  CD2 LEU B  13     -63.307   7.293 -27.618  1.00 49.59           C  
ATOM   3136  N   GLU B  14     -60.530   5.613 -31.371  1.00 54.85           N  
ATOM   3137  CA  GLU B  14     -60.327   4.189 -31.655  1.00 54.66           C  
ATOM   3138  C   GLU B  14     -58.848   3.908 -31.931  1.00 55.05           C  
ATOM   3139  O   GLU B  14     -58.261   3.008 -31.337  1.00 56.56           O  
ATOM   3140  CB  GLU B  14     -61.204   3.734 -32.830  1.00 66.35           C  
ATOM   3141  CG  GLU B  14     -61.096   2.236 -33.182  1.00 71.23           C  
ATOM   3142  CD  GLU B  14     -61.900   1.344 -32.255  1.00 80.31           C  
ATOM   3143  OE1 GLU B  14     -61.937   1.627 -31.038  1.00 82.74           O  
ATOM   3144  OE2 GLU B  14     -62.497   0.355 -32.748  1.00 84.64           O  
ATOM   3145  N   ASP B  15     -58.246   4.709 -32.805  1.00 56.77           N  
ATOM   3146  CA  ASP B  15     -56.821   4.594 -33.078  1.00 52.06           C  
ATOM   3147  C   ASP B  15     -56.001   4.681 -31.799  1.00 50.82           C  
ATOM   3148  O   ASP B  15     -55.094   3.879 -31.585  1.00 47.77           O  
ATOM   3149  CB  ASP B  15     -56.373   5.677 -34.060  1.00 53.42           C  
ATOM   3150  CG  ASP B  15     -56.886   5.435 -35.479  1.00 60.18           C  
ATOM   3151  OD1 ASP B  15     -57.347   4.306 -35.773  1.00 67.27           O  
ATOM   3152  OD2 ASP B  15     -56.815   6.375 -36.298  1.00 60.43           O  
ATOM   3153  N   VAL B  16     -56.321   5.638 -30.932  1.00 49.46           N  
ATOM   3154  CA  VAL B  16     -55.572   5.767 -29.684  1.00 46.91           C  
ATOM   3155  C   VAL B  16     -55.766   4.532 -28.774  1.00 45.02           C  
ATOM   3156  O   VAL B  16     -54.808   4.036 -28.173  1.00 48.72           O  
ATOM   3157  CB  VAL B  16     -55.922   7.071 -28.954  1.00 48.77           C  
ATOM   3158  CG1 VAL B  16     -55.231   7.127 -27.599  1.00 36.60           C  
ATOM   3159  CG2 VAL B  16     -55.536   8.274 -29.824  1.00 38.66           C  
ATOM   3160  N   ARG B  17     -56.991   4.022 -28.710  1.00 53.34           N  
ATOM   3161  CA  ARG B  17     -57.296   2.830 -27.918  0.50 55.09           C  
ATOM   3163  C   ARG B  17     -56.525   1.605 -28.418  1.00 49.32           C  
ATOM   3164  O   ARG B  17     -55.947   0.851 -27.628  1.00 47.89           O  
ATOM   3165  CB  ARG B  17     -58.801   2.534 -27.956  0.50 58.83           C  
ATOM   3167  CG  ARG B  17     -59.285   1.695 -26.783  0.50 59.20           C  
ATOM   3169  CD  ARG B  17     -60.469   0.798 -27.133  0.50 62.54           C  
ATOM   3171  NE  ARG B  17     -60.044  -0.566 -27.467  0.50 65.65           N  
ATOM   3173  CZ  ARG B  17     -59.911  -1.064 -28.698  0.50 63.20           C  
ATOM   3175  NH1 ARG B  17     -60.175  -0.332 -29.775  0.50 61.64           N  
ATOM   3177  NH2 ARG B  17     -59.514  -2.318 -28.848  0.50 65.41           N  
ATOM   3179  N   GLU B  18     -56.531   1.407 -29.732  1.00 58.19           N  
ATOM   3180  CA  GLU B  18     -55.832   0.266 -30.332  1.00 59.22           C  
ATOM   3181  C   GLU B  18     -54.329   0.353 -30.080  1.00 56.36           C  
ATOM   3182  O   GLU B  18     -53.701  -0.640 -29.713  1.00 56.87           O  
ATOM   3183  CB  GLU B  18     -56.156   0.146 -31.822  1.00 67.35           C  
ATOM   3184  CG  GLU B  18     -57.615  -0.248 -32.062  1.00 77.42           C  
ATOM   3185  CD  GLU B  18     -57.816  -1.162 -33.260  1.00 80.84           C  
ATOM   3186  OE1 GLU B  18     -57.050  -1.042 -34.243  1.00 92.19           O  
ATOM   3187  OE2 GLU B  18     -58.748  -2.000 -33.215  1.00 86.10           O  
ATOM   3188  N   ALA B  19     -53.761   1.551 -30.228  1.00 54.59           N  
ATOM   3189  CA  ALA B  19     -52.355   1.773 -29.905  1.00 50.90           C  
ATOM   3190  C   ALA B  19     -52.054   1.449 -28.452  1.00 52.20           C  
ATOM   3191  O   ALA B  19     -51.028   0.832 -28.148  1.00 53.53           O  
ATOM   3192  CB  ALA B  19     -51.954   3.213 -30.220  1.00 52.21           C  
ATOM   3193  N   LEU B  20     -52.933   1.859 -27.540  1.00 51.77           N  
ATOM   3194  CA  LEU B  20     -52.717   1.546 -26.119  1.00 51.23           C  
ATOM   3195  C   LEU B  20     -52.845   0.044 -25.833  1.00 43.64           C  
ATOM   3196  O   LEU B  20     -52.044  -0.529 -25.094  1.00 46.51           O  
ATOM   3197  CB  LEU B  20     -53.675   2.361 -25.241  1.00 49.87           C  
ATOM   3198  CG  LEU B  20     -53.374   3.868 -25.216  1.00 42.38           C  
ATOM   3199  CD1 LEU B  20     -54.535   4.644 -24.585  1.00 42.94           C  
ATOM   3200  CD2 LEU B  20     -52.072   4.139 -24.504  1.00 46.40           C  
ATOM   3201  N   SER B  21     -53.845  -0.599 -26.416  1.00 53.20           N  
ATOM   3202  CA  SER B  21     -54.031  -2.035 -26.195  1.00 61.57           C  
ATOM   3203  C   SER B  21     -52.824  -2.806 -26.714  1.00 62.20           C  
ATOM   3204  O   SER B  21     -52.382  -3.746 -26.060  1.00 57.81           O  
ATOM   3205  CB  SER B  21     -55.323  -2.550 -26.833  1.00 60.76           C  
ATOM   3206  OG  SER B  21     -55.679  -1.755 -27.938  1.00 69.79           O  
ATOM   3207  N   SER B  22     -52.262  -2.353 -27.839  1.00 62.24           N  
ATOM   3208  CA  SER B  22     -51.063  -2.966 -28.429  1.00 62.84           C  
ATOM   3209  C   SER B  22     -49.853  -3.026 -27.489  1.00 65.67           C  
ATOM   3210  O   SER B  22     -48.968  -3.851 -27.698  1.00 75.24           O  
ATOM   3211  CB  SER B  22     -50.650  -2.233 -29.707  1.00 64.75           C  
ATOM   3212  OG  SER B  22     -49.807  -1.127 -29.407  1.00 66.75           O  
ATOM   3213  N   ILE B  23     -49.792  -2.158 -26.477  1.00 57.81           N  
ATOM   3214  CA  ILE B  23     -48.701  -2.213 -25.496  1.00 57.32           C  
ATOM   3215  C   ILE B  23     -49.174  -2.686 -24.114  1.00 56.60           C  
ATOM   3216  O   ILE B  23     -48.505  -2.457 -23.094  1.00 61.78           O  
ATOM   3217  CB  ILE B  23     -47.933  -0.864 -25.419  1.00 59.91           C  
ATOM   3218  CG1 ILE B  23     -48.795   0.254 -24.818  1.00 63.21           C  
ATOM   3219  CG2 ILE B  23     -47.472  -0.462 -26.822  1.00 63.12           C  
ATOM   3220  CD1 ILE B  23     -48.023   1.524 -24.494  1.00 58.63           C  
ATOM   3221  N   GLY B  24     -50.317  -3.372 -24.090  1.00 56.79           N  
ATOM   3222  CA  GLY B  24     -50.849  -3.968 -22.865  1.00 58.86           C  
ATOM   3223  C   GLY B  24     -51.670  -3.026 -21.992  1.00 59.11           C  
ATOM   3224  O   GLY B  24     -51.770  -3.245 -20.779  1.00 57.42           O  
ATOM   3225  N   ILE B  25     -52.257  -1.992 -22.603  1.00 55.41           N  
ATOM   3226  CA  ILE B  25     -53.110  -1.036 -21.879  1.00 55.03           C  
ATOM   3227  C   ILE B  25     -54.502  -1.004 -22.509  1.00 51.45           C  
ATOM   3228  O   ILE B  25     -54.733  -0.348 -23.534  1.00 57.11           O  
ATOM   3229  CB  ILE B  25     -52.501   0.400 -21.822  1.00 53.29           C  
ATOM   3230  CG1 ILE B  25     -51.052   0.369 -21.341  1.00 51.29           C  
ATOM   3231  CG2 ILE B  25     -53.304   1.282 -20.865  1.00 49.46           C  
ATOM   3232  CD1 ILE B  25     -50.382   1.744 -21.285  1.00 47.57           C  
ATOM   3233  N   GLN B  26     -55.429  -1.732 -21.891  1.00 53.26           N  
ATOM   3234  CA  GLN B  26     -56.826  -1.770 -22.345  1.00 62.81           C  
ATOM   3235  C   GLN B  26     -57.803  -1.048 -21.405  1.00 56.33           C  
ATOM   3236  O   GLN B  26     -58.952  -0.772 -21.778  1.00 57.96           O  
ATOM   3237  CB  GLN B  26     -57.264  -3.221 -22.507  1.00 72.63           C  
ATOM   3238  CG  GLN B  26     -56.313  -4.039 -23.368  1.00 78.42           C  
ATOM   3239  CD  GLN B  26     -57.004  -5.216 -24.008  1.00 80.71           C  
ATOM   3240  OE1 GLN B  26     -57.300  -6.212 -23.343  1.00 86.57           O  
ATOM   3241  NE2 GLN B  26     -57.281  -5.106 -25.308  1.00 89.35           N  
ATOM   3242  N   GLY B  27     -57.350  -0.755 -20.193  1.00 43.73           N  
ATOM   3243  CA  GLY B  27     -58.201  -0.120 -19.198  1.00 44.89           C  
ATOM   3244  C   GLY B  27     -58.032   1.381 -19.269  1.00 40.19           C  
ATOM   3245  O   GLY B  27     -56.909   1.885 -19.223  1.00 40.65           O  
ATOM   3246  N   LEU B  28     -59.144   2.097 -19.399  1.00 38.72           N  
ATOM   3247  CA  LEU B  28     -59.104   3.566 -19.398  1.00 37.28           C  
ATOM   3248  C   LEU B  28     -60.483   4.191 -19.316  1.00 35.55           C  
ATOM   3249  O   LEU B  28     -61.500   3.510 -19.469  1.00 33.30           O  
ATOM   3250  CB  LEU B  28     -58.396   4.079 -20.637  1.00 38.47           C  
ATOM   3251  CG  LEU B  28     -58.888   3.591 -21.986  1.00 43.81           C  
ATOM   3252  CD1 LEU B  28     -59.939   4.519 -22.506  1.00 43.01           C  
ATOM   3253  CD2 LEU B  28     -57.703   3.545 -22.945  1.00 49.76           C  
ATOM   3254  N   THR B  29     -60.498   5.503 -19.102  1.00 33.67           N  
ATOM   3255  CA  THR B  29     -61.743   6.238 -18.903  1.00 31.54           C  
ATOM   3256  C   THR B  29     -61.802   7.416 -19.860  1.00 34.95           C  
ATOM   3257  O   THR B  29     -60.815   8.139 -20.040  1.00 36.11           O  
ATOM   3258  CB  THR B  29     -61.831   6.737 -17.463  1.00 35.56           C  
ATOM   3259  OG1 THR B  29     -61.801   5.618 -16.564  1.00 38.71           O  
ATOM   3260  CG2 THR B  29     -63.125   7.529 -17.260  1.00 31.63           C  
ATOM   3261  N   VAL B  30     -62.960   7.598 -20.472  1.00 32.20           N  
ATOM   3262  CA  VAL B  30     -63.152   8.596 -21.511  1.00 29.24           C  
ATOM   3263  C   VAL B  30     -64.250   9.569 -21.122  1.00 32.83           C  
ATOM   3264  O   VAL B  30     -65.285   9.161 -20.607  1.00 33.38           O  
ATOM   3265  CB  VAL B  30     -63.515   7.900 -22.823  1.00 32.92           C  
ATOM   3266  CG1 VAL B  30     -63.941   8.919 -23.863  1.00 39.43           C  
ATOM   3267  CG2 VAL B  30     -62.332   7.066 -23.319  1.00 38.94           C  
ATOM   3268  N   THR B  31     -64.018  10.857 -21.375  1.00 35.54           N  
ATOM   3269  CA  THR B  31     -64.996  11.904 -21.084  1.00 32.94           C  
ATOM   3270  C   THR B  31     -65.199  12.751 -22.332  1.00 33.20           C  
ATOM   3271  O   THR B  31     -64.241  13.090 -23.027  1.00 32.08           O  
ATOM   3272  CB  THR B  31     -64.524  12.816 -19.922  1.00 33.20           C  
ATOM   3273  OG1 THR B  31     -64.076  12.007 -18.830  1.00 42.22           O  
ATOM   3274  CG2 THR B  31     -65.672  13.763 -19.451  1.00 32.11           C  
ATOM   3275  N   GLU B  32     -66.447  13.095 -22.617  1.00 30.68           N  
ATOM   3276  CA  GLU B  32     -66.769  14.076 -23.658  1.00 32.62           C  
ATOM   3277  C   GLU B  32     -66.524  15.449 -23.090  1.00 32.37           C  
ATOM   3278  O   GLU B  32     -67.058  15.787 -22.029  1.00 36.95           O  
ATOM   3279  CB  GLU B  32     -68.251  14.003 -24.042  1.00 42.20           C  
ATOM   3280  CG  GLU B  32     -68.663  12.724 -24.765  1.00 52.66           C  
ATOM   3281  CD  GLU B  32     -70.167  12.691 -25.053  1.00 59.27           C  
ATOM   3282  OE1 GLU B  32     -70.886  11.894 -24.403  1.00 74.40           O  
ATOM   3283  OE2 GLU B  32     -70.635  13.477 -25.914  1.00 65.90           O  
ATOM   3284  N   VAL B  33     -65.709  16.244 -23.775  1.00 30.69           N  
ATOM   3285  CA  VAL B  33     -65.379  17.594 -23.298  1.00 33.17           C  
ATOM   3286  C   VAL B  33     -65.526  18.576 -24.459  1.00 37.18           C  
ATOM   3287  O   VAL B  33     -65.733  18.149 -25.588  1.00 32.39           O  
ATOM   3288  CB  VAL B  33     -63.958  17.667 -22.679  1.00 31.22           C  
ATOM   3289  CG1 VAL B  33     -63.866  16.765 -21.419  1.00 35.95           C  
ATOM   3290  CG2 VAL B  33     -62.894  17.279 -23.684  1.00 35.59           C  
ATOM   3291  N   LYS B  34     -65.473  19.872 -24.159  1.00 31.25           N  
ATOM   3292  CA  LYS B  34     -65.557  20.916 -25.160  1.00 33.03           C  
ATOM   3293  C   LYS B  34     -64.233  21.662 -25.120  1.00 33.57           C  
ATOM   3294  O   LYS B  34     -63.737  22.046 -24.041  1.00 34.73           O  
ATOM   3295  CB  LYS B  34     -66.724  21.881 -24.912  1.00 44.28           C  
ATOM   3296  CG  LYS B  34     -68.049  21.238 -24.474  1.00 55.44           C  
ATOM   3297  CD  LYS B  34     -68.590  20.198 -25.472  1.00 62.76           C  
ATOM   3298  CE  LYS B  34     -69.895  19.513 -24.975  1.00 66.30           C  
ATOM   3299  NZ  LYS B  34     -69.706  18.605 -23.779  1.00 68.61           N  
ATOM   3300  N   GLY B  35     -63.653  21.863 -26.291  1.00 34.35           N  
ATOM   3301  CA  GLY B  35     -62.325  22.481 -26.404  1.00 41.81           C  
ATOM   3302  C   GLY B  35     -62.340  23.856 -27.061  1.00 41.99           C  
ATOM   3303  O   GLY B  35     -63.110  24.122 -28.000  1.00 45.88           O  
ATOM   3304  N   PHE B  36     -61.501  24.737 -26.532  1.00 39.62           N  
ATOM   3305  CA  PHE B  36     -61.255  26.072 -27.077  1.00 44.56           C  
ATOM   3306  C   PHE B  36     -59.737  26.190 -27.250  1.00 39.38           C  
ATOM   3307  O   PHE B  36     -58.986  25.769 -26.378  1.00 34.71           O  
ATOM   3308  CB  PHE B  36     -61.686  27.157 -26.072  1.00 56.60           C  
ATOM   3309  CG  PHE B  36     -63.156  27.131 -25.697  1.00 59.57           C  
ATOM   3310  CD1 PHE B  36     -64.048  28.039 -26.263  1.00 59.29           C  
ATOM   3311  CD2 PHE B  36     -63.644  26.219 -24.752  1.00 59.71           C  
ATOM   3312  CE1 PHE B  36     -65.398  28.023 -25.911  1.00 58.07           C  
ATOM   3313  CE2 PHE B  36     -64.998  26.204 -24.401  1.00 54.84           C  
ATOM   3314  CZ  PHE B  36     -65.870  27.109 -24.983  1.00 58.70           C  
ATOM   3315  N   GLY B  37     -59.276  26.748 -28.361  1.00 47.44           N  
ATOM   3316  CA  GLY B  37     -57.845  27.022 -28.512  1.00 46.72           C  
ATOM   3317  C   GLY B  37     -57.538  27.670 -29.849  1.00 49.34           C  
ATOM   3318  O   GLY B  37     -58.294  28.510 -30.323  1.00 42.10           O  
ATOM   3319  N   ARG B  38     -56.426  27.266 -30.455  1.00 46.12           N  
ATOM   3320  CA  ARG B  38     -56.049  27.749 -31.782  1.00 57.13           C  
ATOM   3321  C   ARG B  38     -57.125  27.372 -32.796  1.00 53.64           C  
ATOM   3322  O   ARG B  38     -57.537  28.191 -33.614  1.00 57.35           O  
ATOM   3323  CB  ARG B  38     -54.681  27.174 -32.184  1.00 60.66           C  
ATOM   3324  CG  ARG B  38     -53.562  27.622 -31.248  1.00 66.90           C  
ATOM   3325  CD  ARG B  38     -52.199  27.047 -31.609  1.00 72.33           C  
ATOM   3326  NE  ARG B  38     -51.136  27.683 -30.824  1.00 73.34           N  
ATOM   3327  CZ  ARG B  38     -49.830  27.424 -30.947  1.00 78.47           C  
ATOM   3328  NH1 ARG B  38     -49.385  26.530 -31.830  1.00 74.75           N  
ATOM   3329  NH2 ARG B  38     -48.960  28.069 -30.174  1.00 78.20           N  
ATOM   3330  N   GLN B  39     -57.570  26.123 -32.735  1.00 50.91           N  
ATOM   3331  CA  GLN B  39     -58.717  25.681 -33.504  1.00 53.70           C  
ATOM   3332  C   GLN B  39     -60.008  26.204 -32.830  1.00 60.38           C  
ATOM   3333  O   GLN B  39     -60.271  25.956 -31.627  1.00 57.13           O  
ATOM   3334  CB  GLN B  39     -58.731  24.156 -33.591  1.00 47.97           C  
ATOM   3335  CG  GLN B  39     -59.539  23.583 -34.760  1.00 54.25           C  
ATOM   3336  CD  GLN B  39     -60.030  22.161 -34.508  1.00 56.77           C  
ATOM   3337  OE1 GLN B  39     -59.964  21.652 -33.385  1.00 58.67           O  
ATOM   3338  NE2 GLN B  39     -60.535  21.521 -35.553  1.00 61.62           N  
ATOM   3339  N   LYS B  40     -60.806  26.931 -33.608  1.00 57.36           N  
ATOM   3340  CA  LYS B  40     -62.057  27.524 -33.124  1.00 64.53           C  
ATOM   3341  C   LYS B  40     -63.272  27.118 -33.982  1.00 64.44           C  
ATOM   3342  O   LYS B  40     -63.141  26.831 -35.181  1.00 60.14           O  
ATOM   3343  CB  LYS B  40     -61.925  29.055 -33.082  1.00 70.98           C  
ATOM   3344  CG  LYS B  40     -60.578  29.536 -32.536  1.00 73.39           C  
ATOM   3345  CD  LYS B  40     -60.620  30.987 -32.084  1.00 73.99           C  
ATOM   3346  CE  LYS B  40     -59.247  31.448 -31.592  1.00 77.14           C  
ATOM   3347  NZ  LYS B  40     -59.330  32.700 -30.787  1.00 79.44           N  
ATOM   3348  N   GLY B  41     -64.447  27.098 -33.349  1.00 61.96           N  
ATOM   3349  CA  GLY B  41     -65.689  26.686 -34.000  1.00 59.67           C  
ATOM   3350  C   GLY B  41     -66.163  27.664 -35.070  1.00 62.10           C  
ATOM   3351  O   GLY B  41     -65.909  28.874 -34.986  1.00 56.15           O  
ATOM   3352  N   HIS B  42     -66.850  27.140 -36.085  1.00 56.12           N  
ATOM   3353  CA  HIS B  42     -67.472  27.990 -37.103  1.00 47.69           C  
ATOM   3354  C   HIS B  42     -68.492  28.877 -36.398  1.00 46.90           C  
ATOM   3355  O   HIS B  42     -68.950  28.535 -35.309  1.00 52.51           O  
ATOM   3356  CB  HIS B  42     -68.204  27.143 -38.156  1.00 54.18           C  
ATOM   3357  CG  HIS B  42     -67.306  26.343 -39.049  1.00 64.18           C  
ATOM   3358  ND1 HIS B  42     -66.499  25.328 -38.583  1.00 72.04           N  
ATOM   3359  CD2 HIS B  42     -67.133  26.371 -40.392  1.00 69.52           C  
ATOM   3360  CE1 HIS B  42     -65.843  24.786 -39.595  1.00 68.99           C  
ATOM   3361  NE2 HIS B  42     -66.209  25.399 -40.706  1.00 68.56           N  
ATOM   3362  N   ALA B  43     -68.867  29.997 -37.018  1.00 39.95           N  
ATOM   3363  CA  ALA B  43     -69.982  30.803 -36.536  1.00 34.49           C  
ATOM   3364  C   ALA B  43     -71.277  29.992 -36.698  1.00 36.02           C  
ATOM   3365  O   ALA B  43     -71.384  29.136 -37.583  1.00 36.10           O  
ATOM   3366  CB  ALA B  43     -70.100  32.103 -37.310  1.00 42.17           C  
ATOM   3367  N   GLU B  44     -72.239  30.267 -35.835  1.00 37.69           N  
ATOM   3368  CA  GLU B  44     -73.566  29.658 -35.925  1.00 31.53           C  
ATOM   3369  C   GLU B  44     -74.577  30.787 -35.933  1.00 35.51           C  
ATOM   3370  O   GLU B  44     -74.377  31.818 -35.296  1.00 37.37           O  
ATOM   3371  CB  GLU B  44     -73.810  28.752 -34.733  1.00 30.06           C  
ATOM   3372  CG  GLU B  44     -72.912  27.536 -34.680  1.00 30.24           C  
ATOM   3373  CD  GLU B  44     -73.054  26.725 -33.394  1.00 37.84           C  
ATOM   3374  OE1 GLU B  44     -74.026  26.937 -32.620  1.00 37.93           O  
ATOM   3375  OE2 GLU B  44     -72.168  25.867 -33.157  1.00 41.58           O  
ATOM   3376  N   LEU B  45     -75.664  30.591 -36.656  1.00 33.21           N  
ATOM   3377  CA  LEU B  45     -76.712  31.584 -36.745  1.00 27.54           C  
ATOM   3378  C   LEU B  45     -78.046  30.940 -36.522  1.00 29.99           C  
ATOM   3379  O   LEU B  45     -78.318  29.898 -37.106  1.00 29.22           O  
ATOM   3380  CB  LEU B  45     -76.722  32.204 -38.129  1.00 40.02           C  
ATOM   3381  CG  LEU B  45     -75.564  33.075 -38.556  1.00 50.79           C  
ATOM   3382  CD1 LEU B  45     -75.919  33.682 -39.906  1.00 56.92           C  
ATOM   3383  CD2 LEU B  45     -75.327  34.156 -37.536  1.00 60.83           C  
ATOM   3384  N   TYR B  46     -78.863  31.562 -35.679  1.00 29.20           N  
ATOM   3385  CA  TYR B  46     -80.197  31.075 -35.374  1.00 29.03           C  
ATOM   3386  C   TYR B  46     -81.144  32.256 -35.487  1.00 28.04           C  
ATOM   3387  O   TYR B  46     -81.147  33.152 -34.621  1.00 32.94           O  
ATOM   3388  CB  TYR B  46     -80.215  30.495 -33.962  1.00 30.64           C  
ATOM   3389  CG  TYR B  46     -79.227  29.375 -33.771  1.00 27.11           C  
ATOM   3390  CD1 TYR B  46     -79.539  28.066 -34.145  1.00 32.46           C  
ATOM   3391  CD2 TYR B  46     -77.969  29.616 -33.230  1.00 29.65           C  
ATOM   3392  CE1 TYR B  46     -78.638  27.041 -33.953  1.00 28.51           C  
ATOM   3393  CE2 TYR B  46     -77.055  28.592 -33.053  1.00 32.54           C  
ATOM   3394  CZ  TYR B  46     -77.399  27.306 -33.420  1.00 32.84           C  
ATOM   3395  OH  TYR B  46     -76.486  26.292 -33.280  1.00 29.12           O  
ATOM   3396  N   ARG B  47     -81.887  32.312 -36.588  1.00 29.34           N  
ATOM   3397  CA  ARG B  47     -82.703  33.498 -36.895  1.00 29.27           C  
ATOM   3398  C   ARG B  47     -81.829  34.765 -36.745  1.00 27.84           C  
ATOM   3399  O   ARG B  47     -80.758  34.842 -37.363  1.00 32.95           O  
ATOM   3400  CB  ARG B  47     -83.958  33.493 -36.028  1.00 33.22           C  
ATOM   3401  CG  ARG B  47     -84.969  32.395 -36.452  1.00 32.11           C  
ATOM   3402  CD  ARG B  47     -86.055  32.212 -35.407  1.00 31.09           C  
ATOM   3403  NE  ARG B  47     -87.253  31.623 -35.987  1.00 35.25           N  
ATOM   3404  CZ  ARG B  47     -88.400  31.483 -35.338  1.00 34.38           C  
ATOM   3405  NH1 ARG B  47     -88.513  31.882 -34.089  1.00 36.78           N  
ATOM   3406  NH2 ARG B  47     -89.451  30.928 -35.943  1.00 39.52           N  
ATOM   3407  N   GLY B  48     -82.232  35.729 -35.929  1.00 31.28           N  
ATOM   3408  CA  GLY B  48     -81.443  36.951 -35.764  1.00 39.88           C  
ATOM   3409  C   GLY B  48     -80.180  36.825 -34.932  1.00 45.29           C  
ATOM   3410  O   GLY B  48     -79.372  37.751 -34.912  1.00 55.47           O  
ATOM   3411  N   ALA B  49     -80.005  35.701 -34.241  1.00 40.25           N  
ATOM   3412  CA  ALA B  49     -78.898  35.532 -33.278  1.00 42.56           C  
ATOM   3413  C   ALA B  49     -77.668  34.955 -33.945  1.00 39.68           C  
ATOM   3414  O   ALA B  49     -77.738  33.931 -34.617  1.00 40.92           O  
ATOM   3415  CB  ALA B  49     -79.321  34.645 -32.097  1.00 37.12           C  
ATOM   3416  N   GLU B  50     -76.529  35.617 -33.739  1.00 38.49           N  
ATOM   3417  CA  GLU B  50     -75.260  35.231 -34.341  1.00 42.68           C  
ATOM   3418  C   GLU B  50     -74.322  34.833 -33.215  1.00 42.68           C  
ATOM   3419  O   GLU B  50     -74.283  35.512 -32.182  1.00 36.94           O  
ATOM   3420  CB  GLU B  50     -74.708  36.417 -35.122  1.00 50.30           C  
ATOM   3421  CG  GLU B  50     -73.355  36.223 -35.759  1.00 60.68           C  
ATOM   3422  CD  GLU B  50     -73.012  37.372 -36.711  1.00 68.97           C  
ATOM   3423  OE1 GLU B  50     -73.073  38.547 -36.273  1.00 77.34           O  
ATOM   3424  OE2 GLU B  50     -72.697  37.097 -37.894  1.00 78.03           O  
ATOM   3425  N   PHE B  51     -73.613  33.717 -33.387  1.00 36.61           N  
ATOM   3426  CA  PHE B  51     -72.662  33.226 -32.374  1.00 41.50           C  
ATOM   3427  C   PHE B  51     -71.348  32.954 -33.062  1.00 44.15           C  
ATOM   3428  O   PHE B  51     -71.228  32.011 -33.843  1.00 41.84           O  
ATOM   3429  CB  PHE B  51     -73.169  31.964 -31.680  1.00 38.76           C  
ATOM   3430  CG  PHE B  51     -74.460  32.162 -30.975  1.00 40.04           C  
ATOM   3431  CD1 PHE B  51     -74.484  32.564 -29.656  1.00 46.21           C  
ATOM   3432  CD2 PHE B  51     -75.659  32.018 -31.642  1.00 39.83           C  
ATOM   3433  CE1 PHE B  51     -75.678  32.800 -29.027  1.00 43.73           C  
ATOM   3434  CE2 PHE B  51     -76.855  32.251 -31.003  1.00 40.76           C  
ATOM   3435  CZ  PHE B  51     -76.862  32.634 -29.695  1.00 41.09           C  
ATOM   3436  N   SER B  52     -70.361  33.796 -32.785  1.00 49.84           N  
ATOM   3437  CA  SER B  52     -69.099  33.750 -33.508  1.00 57.07           C  
ATOM   3438  C   SER B  52     -68.053  32.997 -32.707  1.00 59.20           C  
ATOM   3439  O   SER B  52     -67.009  32.635 -33.239  1.00 62.61           O  
ATOM   3440  CB  SER B  52     -68.619  35.170 -33.816  1.00 61.42           C  
ATOM   3441  OG  SER B  52     -68.486  35.914 -32.622  1.00 69.49           O  
ATOM   3442  N   VAL B  53     -68.334  32.775 -31.423  1.00 63.53           N  
ATOM   3443  CA  VAL B  53     -67.437  32.029 -30.542  1.00 64.51           C  
ATOM   3444  C   VAL B  53     -68.129  30.725 -30.207  1.00 64.98           C  
ATOM   3445  O   VAL B  53     -69.186  30.749 -29.576  1.00 64.26           O  
ATOM   3446  CB  VAL B  53     -67.129  32.802 -29.215  1.00 67.93           C  
ATOM   3447  CG1 VAL B  53     -66.177  32.003 -28.326  1.00 62.39           C  
ATOM   3448  CG2 VAL B  53     -66.558  34.192 -29.503  1.00 66.24           C  
ATOM   3449  N   ASN B  54     -67.556  29.600 -30.648  1.00 61.33           N  
ATOM   3450  CA  ASN B  54     -68.104  28.284 -30.336  1.00 55.94           C  
ATOM   3451  C   ASN B  54     -67.010  27.279 -29.968  1.00 56.85           C  
ATOM   3452  O   ASN B  54     -65.907  27.314 -30.524  1.00 48.18           O  
ATOM   3453  CB  ASN B  54     -68.963  27.776 -31.508  1.00 51.43           C  
ATOM   3454  CG  ASN B  54     -70.166  28.674 -31.773  1.00 50.15           C  
ATOM   3455  OD1 ASN B  54     -70.953  28.964 -30.867  1.00 50.22           O  
ATOM   3456  ND2 ASN B  54     -70.288  29.144 -32.992  1.00 50.41           N  
ATOM   3457  N   PHE B  55     -67.320  26.398 -29.012  1.00 48.93           N  
ATOM   3458  CA  PHE B  55     -66.402  25.316 -28.608  1.00 55.23           C  
ATOM   3459  C   PHE B  55     -66.274  24.278 -29.721  1.00 50.87           C  
ATOM   3460  O   PHE B  55     -67.116  24.232 -30.615  1.00 50.83           O  
ATOM   3461  CB  PHE B  55     -66.948  24.608 -27.364  1.00 66.99           C  
ATOM   3462  CG  PHE B  55     -68.199  23.765 -27.637  1.00 75.64           C  
ATOM   3463  CD1 PHE B  55     -69.460  24.214 -27.247  1.00 79.65           C  
ATOM   3464  CD2 PHE B  55     -68.116  22.528 -28.288  1.00 76.38           C  
ATOM   3465  CE1 PHE B  55     -70.617  23.448 -27.499  1.00 77.00           C  
ATOM   3466  CE2 PHE B  55     -69.269  21.758 -28.546  1.00 75.91           C  
ATOM   3467  CZ  PHE B  55     -70.518  22.225 -28.149  1.00 75.80           C  
ATOM   3468  N   LEU B  56     -65.257  23.418 -29.642  1.00 48.72           N  
ATOM   3469  CA  LEU B  56     -65.225  22.176 -30.426  1.00 45.61           C  
ATOM   3470  C   LEU B  56     -65.346  20.930 -29.533  1.00 50.06           C  
ATOM   3471  O   LEU B  56     -64.717  20.877 -28.481  1.00 41.89           O  
ATOM   3472  CB  LEU B  56     -63.925  22.081 -31.213  1.00 44.13           C  
ATOM   3473  CG  LEU B  56     -63.788  23.102 -32.339  1.00 48.72           C  
ATOM   3474  CD1 LEU B  56     -62.329  23.266 -32.691  1.00 46.32           C  
ATOM   3475  CD2 LEU B  56     -64.623  22.698 -33.556  1.00 43.49           C  
ATOM   3476  N   PRO B  57     -66.129  19.918 -29.965  1.00 42.19           N  
ATOM   3477  CA  PRO B  57     -66.174  18.679 -29.202  1.00 39.54           C  
ATOM   3478  C   PRO B  57     -64.801  18.016 -29.215  1.00 37.36           C  
ATOM   3479  O   PRO B  57     -64.118  18.026 -30.231  1.00 33.83           O  
ATOM   3480  CB  PRO B  57     -67.174  17.823 -29.976  1.00 47.43           C  
ATOM   3481  CG  PRO B  57     -67.125  18.362 -31.374  1.00 52.39           C  
ATOM   3482  CD  PRO B  57     -66.961  19.840 -31.177  1.00 48.45           C  
ATOM   3483  N   LYS B  58     -64.386  17.497 -28.070  1.00 36.15           N  
ATOM   3484  CA  LYS B  58     -63.156  16.745 -27.956  1.00 32.27           C  
ATOM   3485  C   LYS B  58     -63.439  15.575 -27.058  1.00 32.19           C  
ATOM   3486  O   LYS B  58     -64.473  15.528 -26.396  1.00 33.24           O  
ATOM   3487  CB  LYS B  58     -62.030  17.586 -27.329  1.00 40.37           C  
ATOM   3488  CG  LYS B  58     -61.657  18.828 -28.111  1.00 43.35           C  
ATOM   3489  CD  LYS B  58     -60.980  18.532 -29.439  1.00 41.56           C  
ATOM   3490  CE  LYS B  58     -60.611  19.844 -30.152  1.00 42.94           C  
ATOM   3491  NZ  LYS B  58     -60.006  19.633 -31.491  1.00 47.65           N  
ATOM   3492  N   VAL B  59     -62.519  14.626 -27.059  1.00 29.36           N  
ATOM   3493  CA  VAL B  59     -62.542  13.474 -26.173  0.50 32.07           C  
ATOM   3495  C   VAL B  59     -61.347  13.576 -25.240  1.00 34.65           C  
ATOM   3496  O   VAL B  59     -60.252  13.883 -25.690  1.00 35.65           O  
ATOM   3497  CB  VAL B  59     -62.448  12.155 -26.978  0.50 35.45           C  
ATOM   3499  CG1 VAL B  59     -61.849  11.038 -26.136  0.50 34.91           C  
ATOM   3501  CG2 VAL B  59     -63.812  11.753 -27.498  0.50 36.41           C  
ATOM   3503  N   LYS B  60     -61.562  13.317 -23.962  1.00 34.07           N  
ATOM   3504  CA  LYS B  60     -60.508  13.305 -22.992  1.00 33.02           C  
ATOM   3505  C   LYS B  60     -60.371  11.888 -22.472  1.00 35.93           C  
ATOM   3506  O   LYS B  60     -61.328  11.325 -21.937  1.00 38.26           O  
ATOM   3507  CB  LYS B  60     -60.867  14.256 -21.862  1.00 34.11           C  
ATOM   3508  CG  LYS B  60     -59.964  14.181 -20.654  1.00 39.92           C  
ATOM   3509  CD  LYS B  60     -60.281  15.345 -19.723  1.00 44.97           C  
ATOM   3510  CE  LYS B  60     -60.202  14.954 -18.266  1.00 56.11           C  
ATOM   3511  NZ  LYS B  60     -60.317  16.175 -17.389  1.00 64.71           N  
ATOM   3512  N   ILE B  61     -59.176  11.333 -22.621  1.00 30.36           N  
ATOM   3513  CA  ILE B  61     -58.836  10.021 -22.117  1.00 33.96           C  
ATOM   3514  C   ILE B  61     -58.038  10.241 -20.855  1.00 35.19           C  
ATOM   3515  O   ILE B  61     -57.135  11.060 -20.829  1.00 36.72           O  
ATOM   3516  CB  ILE B  61     -57.965   9.272 -23.132  1.00 38.87           C  
ATOM   3517  CG1 ILE B  61     -58.669   9.221 -24.491  1.00 37.15           C  
ATOM   3518  CG2 ILE B  61     -57.624   7.871 -22.642  1.00 34.71           C  
ATOM   3519  CD1 ILE B  61     -57.793   8.642 -25.587  1.00 44.41           C  
ATOM   3520  N   ASP B  62     -58.407   9.549 -19.789  1.00 36.32           N  
ATOM   3521  CA  ASP B  62     -57.609   9.507 -18.580  1.00 34.41           C  
ATOM   3522  C   ASP B  62     -57.165   8.043 -18.457  1.00 39.54           C  
ATOM   3523  O   ASP B  62     -57.990   7.130 -18.493  1.00 36.20           O  
ATOM   3524  CB  ASP B  62     -58.433   9.937 -17.357  1.00 37.46           C  
ATOM   3525  CG  ASP B  62     -58.683  11.451 -17.313  1.00 47.68           C  
ATOM   3526  OD1 ASP B  62     -57.699  12.220 -17.223  1.00 52.41           O  
ATOM   3527  OD2 ASP B  62     -59.868  11.879 -17.351  1.00 61.36           O  
ATOM   3528  N   VAL B  63     -55.860   7.815 -18.374  1.00 37.93           N  
ATOM   3529  CA  VAL B  63     -55.341   6.472 -18.170  1.00 40.00           C  
ATOM   3530  C   VAL B  63     -54.231   6.485 -17.112  1.00 34.38           C  
ATOM   3531  O   VAL B  63     -53.252   7.235 -17.212  1.00 37.38           O  
ATOM   3532  CB  VAL B  63     -54.872   5.825 -19.498  1.00 44.03           C  
ATOM   3533  CG1 VAL B  63     -53.815   6.649 -20.162  1.00 39.01           C  
ATOM   3534  CG2 VAL B  63     -54.377   4.388 -19.253  1.00 45.52           C  
ATOM   3535  N   ALA B  64     -54.432   5.694 -16.072  1.00 35.56           N  
ATOM   3536  CA  ALA B  64     -53.422   5.498 -15.047  1.00 37.39           C  
ATOM   3537  C   ALA B  64     -52.452   4.411 -15.525  1.00 37.63           C  
ATOM   3538  O   ALA B  64     -52.871   3.363 -16.016  1.00 36.02           O  
ATOM   3539  CB  ALA B  64     -54.063   5.098 -13.742  1.00 36.99           C  
ATOM   3540  N   ILE B  65     -51.165   4.677 -15.375  1.00 38.59           N  
ATOM   3541  CA  ILE B  65     -50.108   3.782 -15.833  1.00 41.98           C  
ATOM   3542  C   ILE B  65     -48.953   3.784 -14.826  1.00 44.59           C  
ATOM   3543  O   ILE B  65     -48.898   4.626 -13.922  1.00 39.99           O  
ATOM   3544  CB  ILE B  65     -49.549   4.228 -17.207  1.00 39.94           C  
ATOM   3545  CG1 ILE B  65     -48.879   5.611 -17.100  1.00 40.51           C  
ATOM   3546  CG2 ILE B  65     -50.653   4.215 -18.266  1.00 38.42           C  
ATOM   3547  CD1 ILE B  65     -48.169   6.051 -18.358  1.00 39.75           C  
ATOM   3548  N   ALA B  66     -48.031   2.838 -14.987  1.00 46.86           N  
ATOM   3549  CA  ALA B  66     -46.773   2.865 -14.240  1.00 44.10           C  
ATOM   3550  C   ALA B  66     -45.802   3.822 -14.915  1.00 38.83           C  
ATOM   3551  O   ALA B  66     -45.869   4.033 -16.126  1.00 43.29           O  
ATOM   3552  CB  ALA B  66     -46.171   1.462 -14.147  1.00 47.14           C  
ATOM   3553  N   ASP B  67     -44.892   4.385 -14.127  1.00 39.59           N  
ATOM   3554  CA  ASP B  67     -43.876   5.313 -14.614  1.00 44.81           C  
ATOM   3555  C   ASP B  67     -43.034   4.727 -15.764  1.00 51.47           C  
ATOM   3556  O   ASP B  67     -42.602   5.471 -16.654  1.00 48.71           O  
ATOM   3557  CB  ASP B  67     -42.949   5.723 -13.476  1.00 51.09           C  
ATOM   3558  CG  ASP B  67     -42.113   6.948 -13.806  1.00 58.93           C  
ATOM   3559  OD1 ASP B  67     -42.419   7.678 -14.776  1.00 69.62           O  
ATOM   3560  OD2 ASP B  67     -41.141   7.196 -13.070  1.00 77.54           O  
ATOM   3561  N   ASP B  68     -42.834   3.407 -15.758  1.00 48.92           N  
ATOM   3562  CA  ASP B  68     -42.025   2.724 -16.783  0.50 49.04           C  
ATOM   3564  C   ASP B  68     -42.693   2.678 -18.154  1.00 54.20           C  
ATOM   3565  O   ASP B  68     -42.031   2.384 -19.157  1.00 50.05           O  
ATOM   3566  CB  ASP B  68     -41.679   1.293 -16.345  0.50 51.35           C  
ATOM   3568  CG  ASP B  68     -42.859   0.334 -16.468  0.50 53.91           C  
ATOM   3570  OD1 ASP B  68     -42.723  -0.715 -17.127  0.50 58.24           O  
ATOM   3572  OD2 ASP B  68     -43.928   0.631 -15.907  0.50 61.10           O  
ATOM   3574  N   GLN B  69     -44.000   2.951 -18.200  1.00 46.37           N  
ATOM   3575  CA  GLN B  69     -44.758   2.926 -19.446  1.00 46.02           C  
ATOM   3576  C   GLN B  69     -44.900   4.310 -20.074  1.00 36.65           C  
ATOM   3577  O   GLN B  69     -45.321   4.437 -21.234  1.00 43.44           O  
ATOM   3578  CB  GLN B  69     -46.162   2.354 -19.203  1.00 51.17           C  
ATOM   3579  CG  GLN B  69     -46.233   0.946 -18.590  1.00 53.70           C  
ATOM   3580  CD  GLN B  69     -47.660   0.566 -18.143  1.00 55.76           C  
ATOM   3581  OE1 GLN B  69     -48.077   0.838 -17.010  1.00 50.71           O  
ATOM   3582  NE2 GLN B  69     -48.401  -0.077 -19.036  1.00 58.33           N  
ATOM   3583  N   LEU B  70     -44.532   5.341 -19.322  1.00 40.25           N  
ATOM   3584  CA  LEU B  70     -44.862   6.733 -19.681  1.00 43.33           C  
ATOM   3585  C   LEU B  70     -44.349   7.169 -21.048  1.00 45.64           C  
ATOM   3586  O   LEU B  70     -45.118   7.631 -21.900  1.00 42.27           O  
ATOM   3587  CB  LEU B  70     -44.352   7.673 -18.594  1.00 42.85           C  
ATOM   3588  CG  LEU B  70     -44.552   9.157 -18.881  1.00 38.96           C  
ATOM   3589  CD1 LEU B  70     -46.003   9.490 -19.247  1.00 30.90           C  
ATOM   3590  CD2 LEU B  70     -44.067   9.976 -17.712  1.00 40.11           C  
ATOM   3591  N   ASP B  71     -43.054   6.983 -21.282  1.00 44.70           N  
ATOM   3592  CA  ASP B  71     -42.451   7.442 -22.527  1.00 43.18           C  
ATOM   3593  C   ASP B  71     -43.046   6.772 -23.745  1.00 40.79           C  
ATOM   3594  O   ASP B  71     -43.315   7.426 -24.750  1.00 44.34           O  
ATOM   3595  CB  ASP B  71     -40.943   7.210 -22.491  1.00 50.44           C  
ATOM   3596  CG  ASP B  71     -40.237   8.193 -21.606  1.00 59.64           C  
ATOM   3597  OD1 ASP B  71     -40.699   9.354 -21.548  1.00 62.71           O  
ATOM   3598  OD2 ASP B  71     -39.216   7.813 -20.989  1.00 61.56           O  
ATOM   3599  N   GLU B  72     -43.256   5.462 -23.638  1.00 38.32           N  
ATOM   3600  CA  GLU B  72     -43.881   4.680 -24.692  1.00 42.27           C  
ATOM   3601  C   GLU B  72     -45.334   5.095 -24.927  1.00 43.87           C  
ATOM   3602  O   GLU B  72     -45.777   5.169 -26.071  1.00 40.60           O  
ATOM   3603  CB  GLU B  72     -43.815   3.186 -24.335  1.00 41.78           C  
ATOM   3604  CG  GLU B  72     -44.392   2.247 -25.402  1.00 48.10           C  
ATOM   3605  CD  GLU B  72     -44.164   0.767 -25.093  1.00 53.65           C  
ATOM   3606  OE1 GLU B  72     -43.915   0.411 -23.921  1.00 59.80           O  
ATOM   3607  OE2 GLU B  72     -44.239  -0.045 -26.042  1.00 69.40           O  
ATOM   3608  N   VAL B  73     -46.072   5.343 -23.843  1.00 43.32           N  
ATOM   3609  CA  VAL B  73     -47.470   5.781 -23.934  1.00 38.66           C  
ATOM   3610  C   VAL B  73     -47.520   7.083 -24.709  1.00 32.97           C  
ATOM   3611  O   VAL B  73     -48.243   7.184 -25.701  1.00 41.27           O  
ATOM   3612  CB  VAL B  73     -48.111   5.944 -22.523  1.00 40.31           C  
ATOM   3613  CG1 VAL B  73     -49.466   6.674 -22.608  1.00 37.64           C  
ATOM   3614  CG2 VAL B  73     -48.315   4.589 -21.898  1.00 38.36           C  
ATOM   3615  N   ILE B  74     -46.704   8.046 -24.279  1.00 39.79           N  
ATOM   3616  CA  ILE B  74     -46.621   9.353 -24.922  1.00 43.06           C  
ATOM   3617  C   ILE B  74     -46.368   9.198 -26.422  1.00 46.19           C  
ATOM   3618  O   ILE B  74     -47.093   9.764 -27.248  1.00 46.67           O  
ATOM   3619  CB  ILE B  74     -45.541  10.232 -24.253  1.00 43.25           C  
ATOM   3620  CG1 ILE B  74     -46.007  10.636 -22.852  1.00 44.77           C  
ATOM   3621  CG2 ILE B  74     -45.283  11.485 -25.075  1.00 45.08           C  
ATOM   3622  CD1 ILE B  74     -44.964  11.256 -21.985  1.00 43.77           C  
ATOM   3623  N   ASP B  75     -45.369   8.392 -26.771  1.00 45.59           N  
ATOM   3624  CA  ASP B  75     -45.025   8.166 -28.172  1.00 45.34           C  
ATOM   3625  C   ASP B  75     -46.138   7.490 -28.957  1.00 45.02           C  
ATOM   3626  O   ASP B  75     -46.512   7.967 -30.032  1.00 45.56           O  
ATOM   3627  CB  ASP B  75     -43.740   7.338 -28.276  1.00 50.75           C  
ATOM   3628  CG  ASP B  75     -42.514   8.129 -27.865  1.00 58.32           C  
ATOM   3629  OD1 ASP B  75     -42.614   9.377 -27.818  1.00 52.06           O  
ATOM   3630  OD2 ASP B  75     -41.454   7.509 -27.595  1.00 59.36           O  
ATOM   3631  N   ILE B  76     -46.678   6.401 -28.416  1.00 45.17           N  
ATOM   3632  CA  ILE B  76     -47.743   5.636 -29.082  0.50 50.08           C  
ATOM   3634  C   ILE B  76     -49.030   6.451 -29.221  1.00 49.35           C  
ATOM   3635  O   ILE B  76     -49.747   6.363 -30.224  1.00 43.70           O  
ATOM   3636  CB  ILE B  76     -48.038   4.306 -28.315  0.50 53.79           C  
ATOM   3638  CG1 ILE B  76     -47.241   3.145 -28.919  0.50 55.79           C  
ATOM   3640  CG2 ILE B  76     -49.526   3.973 -28.328  0.50 58.58           C  
ATOM   3642  CD1 ILE B  76     -47.733   2.694 -30.291  0.50 58.33           C  
ATOM   3644  N   VAL B  77     -49.339   7.245 -28.204  1.00 48.40           N  
ATOM   3645  CA  VAL B  77     -50.548   8.069 -28.266  1.00 46.49           C  
ATOM   3646  C   VAL B  77     -50.364   9.222 -29.264  1.00 42.36           C  
ATOM   3647  O   VAL B  77     -51.246   9.493 -30.079  1.00 43.81           O  
ATOM   3648  CB  VAL B  77     -50.951   8.574 -26.865  1.00 48.61           C  
ATOM   3649  CG1 VAL B  77     -52.022   9.643 -26.958  1.00 45.27           C  
ATOM   3650  CG2 VAL B  77     -51.413   7.386 -26.021  1.00 38.87           C  
ATOM   3651  N   SER B  78     -49.215   9.887 -29.210  1.00 46.15           N  
ATOM   3652  CA  SER B  78     -48.927  10.997 -30.126  1.00 44.55           C  
ATOM   3653  C   SER B  78     -49.080  10.594 -31.596  1.00 46.88           C  
ATOM   3654  O   SER B  78     -49.717  11.303 -32.372  1.00 47.43           O  
ATOM   3655  CB  SER B  78     -47.516  11.524 -29.886  1.00 45.01           C  
ATOM   3656  OG  SER B  78     -47.401  12.061 -28.579  1.00 43.72           O  
ATOM   3657  N   LYS B  79     -48.485   9.464 -31.966  1.00 46.62           N  
ATOM   3658  CA  LYS B  79     -48.597   8.925 -33.326  0.50 52.02           C  
ATOM   3660  C   LYS B  79     -50.047   8.664 -33.708  1.00 51.32           C  
ATOM   3661  O   LYS B  79     -50.508   9.076 -34.779  1.00 49.10           O  
ATOM   3662  CB  LYS B  79     -47.832   7.600 -33.447  0.50 56.97           C  
ATOM   3664  CG  LYS B  79     -46.327   7.727 -33.579  0.50 61.70           C  
ATOM   3666  CD  LYS B  79     -45.698   6.368 -33.865  0.50 59.97           C  
ATOM   3668  CE  LYS B  79     -44.283   6.498 -34.387  0.50 62.46           C  
ATOM   3670  NZ  LYS B  79     -43.757   5.185 -34.859  0.50 65.57           N  
ATOM   3672  N   ALA B  80     -50.757   7.961 -32.824  1.00 48.37           N  
ATOM   3673  CA  ALA B  80     -52.135   7.532 -33.091  1.00 48.52           C  
ATOM   3674  C   ALA B  80     -53.124   8.679 -33.171  1.00 49.53           C  
ATOM   3675  O   ALA B  80     -54.087   8.598 -33.933  1.00 44.92           O  
ATOM   3676  CB  ALA B  80     -52.593   6.519 -32.036  1.00 48.30           C  
ATOM   3677  N   ALA B  81     -52.894   9.738 -32.388  1.00 43.55           N  
ATOM   3678  CA  ALA B  81     -53.791  10.907 -32.348  1.00 45.84           C  
ATOM   3679  C   ALA B  81     -53.452  11.946 -33.420  1.00 47.59           C  
ATOM   3680  O   ALA B  81     -54.220  12.882 -33.660  1.00 43.75           O  
ATOM   3681  CB  ALA B  81     -53.724  11.558 -30.977  1.00 43.43           C  
ATOM   3682  N   TYR B  82     -52.291  11.789 -34.052  1.00 47.21           N  
ATOM   3683  CA  TYR B  82     -51.769  12.800 -34.956  1.00 48.77           C  
ATOM   3684  C   TYR B  82     -52.568  12.874 -36.249  1.00 47.83           C  
ATOM   3685  O   TYR B  82     -52.895  11.843 -36.835  1.00 51.82           O  
ATOM   3686  CB  TYR B  82     -50.296  12.505 -35.277  1.00 55.16           C  
ATOM   3687  CG  TYR B  82     -49.666  13.445 -36.274  1.00 54.04           C  
ATOM   3688  CD1 TYR B  82     -49.080  14.640 -35.863  1.00 53.93           C  
ATOM   3689  CD2 TYR B  82     -49.647  13.137 -37.633  1.00 59.89           C  
ATOM   3690  CE1 TYR B  82     -48.502  15.505 -36.781  1.00 59.71           C  
ATOM   3691  CE2 TYR B  82     -49.058  13.997 -38.561  1.00 61.79           C  
ATOM   3692  CZ  TYR B  82     -48.491  15.173 -38.127  1.00 60.66           C  
ATOM   3693  OH  TYR B  82     -47.916  16.022 -39.033  1.00 63.03           O  
ATOM   3694  N   THR B  83     -52.889  14.102 -36.660  1.00 55.26           N  
ATOM   3695  CA  THR B  83     -53.347  14.404 -38.027  1.00 59.38           C  
ATOM   3696  C   THR B  83     -52.525  15.529 -38.687  1.00 63.21           C  
ATOM   3697  O   THR B  83     -52.542  15.673 -39.904  1.00 62.81           O  
ATOM   3698  CB  THR B  83     -54.841  14.813 -38.076  1.00 59.07           C  
ATOM   3699  OG1 THR B  83     -54.990  16.180 -37.664  1.00 58.12           O  
ATOM   3700  CG2 THR B  83     -55.710  13.885 -37.208  1.00 50.94           C  
ATOM   3701  N   GLY B  84     -51.831  16.336 -37.885  1.00 66.23           N  
ATOM   3702  CA  GLY B  84     -51.030  17.438 -38.406  1.00 64.68           C  
ATOM   3703  C   GLY B  84     -51.794  18.745 -38.538  1.00 64.29           C  
ATOM   3704  O   GLY B  84     -51.173  19.797 -38.705  1.00 60.28           O  
ATOM   3705  N   LYS B  85     -53.127  18.687 -38.475  1.00 62.62           N  
ATOM   3706  CA  LYS B  85     -53.964  19.886 -38.524  1.00 60.99           C  
ATOM   3707  C   LYS B  85     -54.166  20.453 -37.118  1.00 64.13           C  
ATOM   3708  O   LYS B  85     -54.126  19.713 -36.122  1.00 59.52           O  
ATOM   3709  CB  LYS B  85     -55.317  19.574 -39.164  1.00 65.08           C  
ATOM   3710  CG  LYS B  85     -55.206  19.004 -40.572  1.00 73.08           C  
ATOM   3711  CD  LYS B  85     -56.549  18.977 -41.303  1.00 75.17           C  
ATOM   3712  CE  LYS B  85     -56.994  20.368 -41.742  1.00 81.64           C  
ATOM   3713  NZ  LYS B  85     -58.033  20.314 -42.825  1.00 81.41           N  
ATOM   3714  N   ILE B  86     -54.392  21.762 -37.036  1.00 55.75           N  
ATOM   3715  CA  ILE B  86     -54.532  22.426 -35.741  1.00 60.72           C  
ATOM   3716  C   ILE B  86     -55.705  21.789 -35.000  1.00 57.32           C  
ATOM   3717  O   ILE B  86     -56.742  21.507 -35.604  1.00 56.22           O  
ATOM   3718  CB  ILE B  86     -54.784  23.945 -35.858  1.00 60.93           C  
ATOM   3719  CG1 ILE B  86     -53.705  24.632 -36.698  1.00 67.94           C  
ATOM   3720  CG2 ILE B  86     -54.836  24.588 -34.470  1.00 61.48           C  
ATOM   3721  CD1 ILE B  86     -52.308  24.537 -36.121  1.00 70.11           C  
ATOM   3722  N   GLY B  87     -55.519  21.533 -33.706  1.00 56.22           N  
ATOM   3723  CA  GLY B  87     -56.589  20.993 -32.860  1.00 55.32           C  
ATOM   3724  C   GLY B  87     -56.389  19.558 -32.427  1.00 48.76           C  
ATOM   3725  O   GLY B  87     -57.256  19.011 -31.748  1.00 47.64           O  
ATOM   3726  N   ASP B  88     -55.285  18.933 -32.858  1.00 43.86           N  
ATOM   3727  CA  ASP B  88     -54.960  17.546 -32.490  1.00 49.51           C  
ATOM   3728  C   ASP B  88     -54.896  17.291 -30.983  1.00 45.90           C  
ATOM   3729  O   ASP B  88     -55.174  16.191 -30.530  1.00 49.56           O  
ATOM   3730  CB  ASP B  88     -53.628  17.124 -33.106  1.00 49.59           C  
ATOM   3731  CG  ASP B  88     -53.751  16.767 -34.567  1.00 54.05           C  
ATOM   3732  OD1 ASP B  88     -54.843  16.960 -35.157  1.00 56.93           O  
ATOM   3733  OD2 ASP B  88     -52.745  16.278 -35.117  1.00 47.76           O  
ATOM   3734  N   GLY B  89     -54.502  18.303 -30.224  1.00 43.38           N  
ATOM   3735  CA  GLY B  89     -54.655  18.281 -28.780  1.00 41.31           C  
ATOM   3736  C   GLY B  89     -53.381  18.091 -28.001  1.00 44.30           C  
ATOM   3737  O   GLY B  89     -52.267  18.277 -28.515  1.00 40.70           O  
ATOM   3738  N   LYS B  90     -53.562  17.688 -26.745  1.00 34.64           N  
ATOM   3739  CA  LYS B  90     -52.521  17.770 -25.762  1.00 34.71           C  
ATOM   3740  C   LYS B  90     -52.417  16.481 -24.995  1.00 35.12           C  
ATOM   3741  O   LYS B  90     -53.407  15.751 -24.839  1.00 36.17           O  
ATOM   3742  CB  LYS B  90     -52.815  18.875 -24.736  1.00 42.60           C  
ATOM   3743  CG  LYS B  90     -53.310  20.192 -25.284  1.00 42.80           C  
ATOM   3744  CD  LYS B  90     -52.227  20.985 -25.956  1.00 48.94           C  
ATOM   3745  CE  LYS B  90     -52.793  22.332 -26.403  1.00 52.01           C  
ATOM   3746  NZ  LYS B  90     -51.955  22.994 -27.415  1.00 45.31           N  
ATOM   3747  N   ILE B  91     -51.220  16.230 -24.490  1.00 32.31           N  
ATOM   3748  CA  ILE B  91     -51.021  15.225 -23.433  1.00 35.87           C  
ATOM   3749  C   ILE B  91     -50.600  15.943 -22.157  1.00 37.16           C  
ATOM   3750  O   ILE B  91     -49.743  16.828 -22.202  1.00 39.60           O  
ATOM   3751  CB  ILE B  91     -49.961  14.163 -23.835  1.00 35.48           C  
ATOM   3752  CG1 ILE B  91     -50.383  13.449 -25.124  1.00 39.03           C  
ATOM   3753  CG2 ILE B  91     -49.780  13.158 -22.736  1.00 34.53           C  
ATOM   3754  CD1 ILE B  91     -49.330  12.523 -25.665  1.00 44.18           C  
ATOM   3755  N   PHE B  92     -51.243  15.597 -21.041  1.00 34.40           N  
ATOM   3756  CA  PHE B  92     -50.860  16.055 -19.706  1.00 34.28           C  
ATOM   3757  C   PHE B  92     -50.458  14.846 -18.856  1.00 34.21           C  
ATOM   3758  O   PHE B  92     -51.048  13.772 -18.969  1.00 33.54           O  
ATOM   3759  CB  PHE B  92     -52.009  16.758 -18.983  1.00 40.88           C  
ATOM   3760  CG  PHE B  92     -52.645  17.861 -19.775  1.00 40.33           C  
ATOM   3761  CD1 PHE B  92     -51.875  18.837 -20.377  1.00 47.83           C  
ATOM   3762  CD2 PHE B  92     -54.009  17.948 -19.883  1.00 53.42           C  
ATOM   3763  CE1 PHE B  92     -52.460  19.861 -21.110  1.00 43.45           C  
ATOM   3764  CE2 PHE B  92     -54.594  18.974 -20.614  1.00 55.32           C  
ATOM   3765  CZ  PHE B  92     -53.805  19.928 -21.226  1.00 46.63           C  
ATOM   3766  N   VAL B  93     -49.457  15.030 -18.002  1.00 34.63           N  
ATOM   3767  CA  VAL B  93     -49.016  13.979 -17.110  1.00 32.71           C  
ATOM   3768  C   VAL B  93     -48.918  14.533 -15.705  1.00 33.27           C  
ATOM   3769  O   VAL B  93     -48.358  15.600 -15.495  1.00 36.93           O  
ATOM   3770  CB  VAL B  93     -47.668  13.389 -17.532  1.00 37.82           C  
ATOM   3771  CG1 VAL B  93     -47.326  12.192 -16.651  1.00 34.49           C  
ATOM   3772  CG2 VAL B  93     -47.717  12.986 -18.997  1.00 36.42           C  
ATOM   3773  N   ALA B  94     -49.486  13.796 -14.756  1.00 34.94           N  
ATOM   3774  CA  ALA B  94     -49.451  14.152 -13.353  1.00 38.39           C  
ATOM   3775  C   ALA B  94     -49.117  12.904 -12.558  1.00 42.32           C  
ATOM   3776  O   ALA B  94     -49.308  11.795 -13.048  1.00 38.49           O  
ATOM   3777  CB  ALA B  94     -50.808  14.689 -12.932  1.00 40.16           C  
ATOM   3778  N   GLU B  95     -48.616  13.092 -11.342  1.00 42.45           N  
ATOM   3779  CA  GLU B  95     -48.352  11.976 -10.430  1.00 49.98           C  
ATOM   3780  C   GLU B  95     -49.629  11.481  -9.782  1.00 44.55           C  
ATOM   3781  O   GLU B  95     -50.489  12.282  -9.428  1.00 43.18           O  
ATOM   3782  CB  GLU B  95     -47.410  12.406  -9.291  1.00 58.02           C  
ATOM   3783  CG  GLU B  95     -45.959  12.592  -9.696  1.00 68.05           C  
ATOM   3784  CD  GLU B  95     -44.964  12.097  -8.640  1.00 71.44           C  
ATOM   3785  OE1 GLU B  95     -45.306  12.075  -7.433  1.00 78.72           O  
ATOM   3786  OE2 GLU B  95     -43.833  11.725  -9.029  1.00 78.57           O  
ATOM   3787  N   LEU B  96     -49.744  10.166  -9.614  1.00 40.89           N  
ATOM   3788  CA  LEU B  96     -50.782   9.586  -8.772  1.00 47.81           C  
ATOM   3789  C   LEU B  96     -50.115   9.066  -7.525  1.00 51.94           C  
ATOM   3790  O   LEU B  96     -49.190   8.265  -7.614  1.00 51.00           O  
ATOM   3791  CB  LEU B  96     -51.483   8.418  -9.457  1.00 46.83           C  
ATOM   3792  CG  LEU B  96     -52.539   8.773 -10.491  1.00 49.08           C  
ATOM   3793  CD1 LEU B  96     -53.155   7.487 -10.993  1.00 50.85           C  
ATOM   3794  CD2 LEU B  96     -53.595   9.745  -9.909  1.00 45.31           C  
ATOM   3795  N   GLN B  97     -50.584   9.521  -6.371  1.00 44.96           N  
ATOM   3796  CA  GLN B  97     -50.060   9.051  -5.099  1.00 48.93           C  
ATOM   3797  C   GLN B  97     -50.549   7.651  -4.803  1.00 45.31           C  
ATOM   3798  O   GLN B  97     -49.805   6.844  -4.255  1.00 50.44           O  
ATOM   3799  CB  GLN B  97     -50.442   9.999  -3.977  1.00 49.58           C  
ATOM   3800  CG  GLN B  97     -49.835  11.371  -4.147  1.00 57.16           C  
ATOM   3801  CD  GLN B  97     -49.735  12.125  -2.834  1.00 62.71           C  
ATOM   3802  OE1 GLN B  97     -50.687  12.154  -2.050  1.00 71.85           O  
ATOM   3803  NE2 GLN B  97     -48.577  12.737  -2.585  1.00 68.19           N  
ATOM   3804  N   ARG B  98     -51.784   7.361  -5.192  1.00 42.64           N  
ATOM   3805  CA  ARG B  98     -52.378   6.051  -4.981  1.00 45.35           C  
ATOM   3806  C   ARG B  98     -53.376   5.701  -6.067  1.00 43.82           C  
ATOM   3807  O   ARG B  98     -54.070   6.573  -6.612  1.00 38.74           O  
ATOM   3808  CB  ARG B  98     -53.045   5.989  -3.600  1.00 46.93           C  
ATOM   3809  CG  ARG B  98     -52.072   5.616  -2.487  1.00 61.52           C  
ATOM   3810  CD  ARG B  98     -52.101   6.560  -1.310  1.00 70.06           C  
ATOM   3811  NE  ARG B  98     -53.075   6.131  -0.315  1.00 75.06           N  
ATOM   3812  CZ  ARG B  98     -53.002   6.390   0.991  1.00 74.51           C  
ATOM   3813  NH1 ARG B  98     -51.994   7.088   1.506  1.00 75.14           N  
ATOM   3814  NH2 ARG B  98     -53.952   5.943   1.795  1.00 71.95           N  
ATOM   3815  N   VAL B  99     -53.400   4.413  -6.391  1.00 40.28           N  
ATOM   3816  CA  VAL B  99     -54.348   3.826  -7.315  1.00 43.60           C  
ATOM   3817  C   VAL B  99     -54.834   2.547  -6.653  1.00 44.07           C  
ATOM   3818  O   VAL B  99     -54.013   1.684  -6.321  1.00 42.32           O  
ATOM   3819  CB  VAL B  99     -53.681   3.487  -8.653  1.00 44.49           C  
ATOM   3820  CG1 VAL B  99     -54.677   2.797  -9.576  1.00 47.72           C  
ATOM   3821  CG2 VAL B  99     -53.102   4.753  -9.287  1.00 50.26           C  
ATOM   3822  N   ILE B 100     -56.140   2.442  -6.413  1.00 42.70           N  
ATOM   3823  CA  ILE B 100     -56.716   1.269  -5.746  1.00 41.34           C  
ATOM   3824  C   ILE B 100     -57.816   0.645  -6.588  1.00 49.11           C  
ATOM   3825  O   ILE B 100     -58.635   1.359  -7.162  1.00 47.45           O  
ATOM   3826  CB  ILE B 100     -57.320   1.631  -4.391  1.00 48.51           C  
ATOM   3827  CG1 ILE B 100     -56.250   2.216  -3.467  1.00 49.89           C  
ATOM   3828  CG2 ILE B 100     -57.979   0.402  -3.735  1.00 41.33           C  
ATOM   3829  CD1 ILE B 100     -56.810   3.003  -2.337  1.00 49.09           C  
ATOM   3830  N   ARG B 101     -57.827  -0.686  -6.662  1.00 40.12           N  
ATOM   3831  CA  ARG B 101     -58.910  -1.430  -7.288  1.00 41.03           C  
ATOM   3832  C   ARG B 101     -59.917  -1.722  -6.194  1.00 41.97           C  
ATOM   3833  O   ARG B 101     -59.612  -2.460  -5.264  1.00 48.60           O  
ATOM   3834  CB  ARG B 101     -58.410  -2.742  -7.918  1.00 42.63           C  
ATOM   3835  CG  ARG B 101     -59.430  -3.336  -8.892  1.00 49.07           C  
ATOM   3836  CD  ARG B 101     -59.215  -4.800  -9.194  1.00 50.16           C  
ATOM   3837  NE  ARG B 101     -57.855  -5.060  -9.633  1.00 55.53           N  
ATOM   3838  CZ  ARG B 101     -57.406  -4.896 -10.872  1.00 50.83           C  
ATOM   3839  NH1 ARG B 101     -58.193  -4.450 -11.841  1.00 49.89           N  
ATOM   3840  NH2 ARG B 101     -56.148  -5.172 -11.134  1.00 54.71           N  
ATOM   3841  N   ILE B 102     -61.106  -1.128  -6.295  1.00 44.30           N  
ATOM   3842  CA  ILE B 102     -62.108  -1.172  -5.223  1.00 45.66           C  
ATOM   3843  C   ILE B 102     -62.482  -2.611  -4.838  1.00 51.61           C  
ATOM   3844  O   ILE B 102     -62.629  -2.941  -3.661  1.00 63.88           O  
ATOM   3845  CB  ILE B 102     -63.415  -0.419  -5.639  1.00 45.45           C  
ATOM   3846  CG1 ILE B 102     -63.199   1.101  -5.702  1.00 39.46           C  
ATOM   3847  CG2 ILE B 102     -64.561  -0.704  -4.649  1.00 42.54           C  
ATOM   3848  CD1 ILE B 102     -64.279   1.842  -6.541  1.00 37.92           C  
ATOM   3849  N   ARG B 103     -62.655  -3.439  -5.862  1.00 54.65           N  
ATOM   3850  CA  ARG B 103     -63.115  -4.816  -5.729  1.00 58.13           C  
ATOM   3851  C   ARG B 103     -62.186  -5.684  -4.880  1.00 59.67           C  
ATOM   3852  O   ARG B 103     -62.644  -6.417  -4.010  1.00 62.92           O  
ATOM   3853  CB  ARG B 103     -63.245  -5.409  -7.133  1.00 54.46           C  
ATOM   3854  CG  ARG B 103     -63.562  -6.872  -7.176  1.00 65.20           C  
ATOM   3855  CD  ARG B 103     -64.136  -7.255  -8.532  1.00 66.89           C  
ATOM   3856  NE  ARG B 103     -63.302  -6.817  -9.655  1.00 66.09           N  
ATOM   3857  CZ  ARG B 103     -62.160  -7.394 -10.029  1.00 70.04           C  
ATOM   3858  NH1 ARG B 103     -61.662  -8.438  -9.366  1.00 72.76           N  
ATOM   3859  NH2 ARG B 103     -61.502  -6.925 -11.075  1.00 69.55           N  
ATOM   3860  N   THR B 104     -60.884  -5.584  -5.146  1.00 59.58           N  
ATOM   3861  CA  THR B 104     -59.864  -6.451  -4.532  1.00 55.79           C  
ATOM   3862  C   THR B 104     -58.970  -5.764  -3.507  1.00 54.86           C  
ATOM   3863  O   THR B 104     -58.292  -6.442  -2.741  1.00 60.20           O  
ATOM   3864  CB  THR B 104     -58.906  -6.969  -5.593  1.00 54.95           C  
ATOM   3865  OG1 THR B 104     -58.223  -5.854  -6.180  1.00 52.69           O  
ATOM   3866  CG2 THR B 104     -59.657  -7.740  -6.673  1.00 55.31           C  
ATOM   3867  N   GLY B 105     -58.920  -4.434  -3.525  1.00 50.33           N  
ATOM   3868  CA  GLY B 105     -57.999  -3.682  -2.686  1.00 46.29           C  
ATOM   3869  C   GLY B 105     -56.555  -3.669  -3.182  1.00 43.22           C  
ATOM   3870  O   GLY B 105     -55.689  -3.105  -2.537  1.00 43.78           O  
ATOM   3871  N   GLU B 106     -56.292  -4.256  -4.341  1.00 45.17           N  
ATOM   3872  CA  GLU B 106     -54.952  -4.201  -4.903  1.00 49.17           C  
ATOM   3873  C   GLU B 106     -54.574  -2.748  -5.126  1.00 49.83           C  
ATOM   3874  O   GLU B 106     -55.449  -1.906  -5.364  1.00 48.11           O  
ATOM   3875  CB  GLU B 106     -54.897  -4.953  -6.216  1.00 50.48           C  
ATOM   3876  CG  GLU B 106     -55.017  -6.463  -6.058  1.00 58.95           C  
ATOM   3877  CD  GLU B 106     -55.370  -7.148  -7.368  1.00 60.23           C  
ATOM   3878  OE1 GLU B 106     -56.560  -7.111  -7.761  1.00 65.11           O  
ATOM   3879  OE2 GLU B 106     -54.458  -7.727  -7.996  1.00 66.68           O  
ATOM   3880  N   ALA B 107     -53.277  -2.471  -5.061  1.00 43.47           N  
ATOM   3881  CA  ALA B 107     -52.752  -1.124  -5.208  1.00 46.91           C  
ATOM   3882  C   ALA B 107     -51.750  -1.023  -6.374  1.00 54.71           C  
ATOM   3883  O   ALA B 107     -51.200  -2.031  -6.842  1.00 49.03           O  
ATOM   3884  CB  ALA B 107     -52.110  -0.681  -3.908  1.00 51.70           C  
ATOM   3885  N   ASP B 108     -51.558   0.206  -6.855  1.00 50.75           N  
ATOM   3886  CA  ASP B 108     -50.557   0.523  -7.865  1.00 53.71           C  
ATOM   3887  C   ASP B 108     -50.646  -0.400  -9.069  1.00 55.19           C  
ATOM   3888  O   ASP B 108     -51.739  -0.599  -9.598  1.00 47.87           O  
ATOM   3889  CB  ASP B 108     -49.175   0.515  -7.224  1.00 60.39           C  
ATOM   3890  CG  ASP B 108     -49.127   1.354  -5.979  1.00 65.42           C  
ATOM   3891  OD1 ASP B 108     -49.894   2.335  -5.907  1.00 72.33           O  
ATOM   3892  OD2 ASP B 108     -48.344   1.029  -5.064  1.00 77.72           O  
ATOM   3893  N   GLU B 109     -49.521  -0.970  -9.508  1.00 53.29           N  
ATOM   3894  CA  GLU B 109     -49.501  -1.734 -10.750  1.00 54.22           C  
ATOM   3895  C   GLU B 109     -50.537  -2.851 -10.712  1.00 45.96           C  
ATOM   3896  O   GLU B 109     -51.188  -3.149 -11.720  1.00 52.46           O  
ATOM   3897  CB  GLU B 109     -48.099  -2.305 -11.030  1.00 66.59           C  
ATOM   3898  CG  GLU B 109     -47.014  -1.247 -11.308  1.00 68.81           C  
ATOM   3899  CD  GLU B 109     -46.348  -0.689 -10.046  1.00 72.38           C  
ATOM   3900  OE1 GLU B 109     -46.774  -1.036  -8.918  1.00 68.96           O  
ATOM   3901  OE2 GLU B 109     -45.390   0.106 -10.187  1.00 74.15           O  
ATOM   3902  N   ALA B 110     -50.719  -3.438  -9.532  1.00 48.49           N  
ATOM   3903  CA  ALA B 110     -51.682  -4.523  -9.345  1.00 48.92           C  
ATOM   3904  C   ALA B 110     -53.142  -4.074  -9.405  1.00 49.54           C  
ATOM   3905  O   ALA B 110     -54.016  -4.919  -9.494  1.00 49.43           O  
ATOM   3906  CB  ALA B 110     -51.420  -5.240  -8.019  1.00 52.29           C  
ATOM   3907  N   ALA B 111     -53.406  -2.765  -9.327  1.00 49.00           N  
ATOM   3908  CA  ALA B 111     -54.782  -2.234  -9.425  1.00 44.79           C  
ATOM   3909  C   ALA B 111     -55.252  -1.988 -10.862  1.00 47.24           C  
ATOM   3910  O   ALA B 111     -56.405  -1.606 -11.073  1.00 47.23           O  
ATOM   3911  CB  ALA B 111     -54.893  -0.940  -8.641  1.00 43.84           C  
ATOM   3912  N   LEU B 112     -54.374  -2.197 -11.841  1.00 49.54           N  
ATOM   3913  CA  LEU B 112     -54.664  -1.856 -13.235  1.00 56.14           C  
ATOM   3914  C   LEU B 112     -54.887  -3.108 -14.098  1.00 64.05           C  
ATOM   3915  O   LEU B 112     -54.805  -4.248 -13.644  1.00 63.75           O  
ATOM   3916  CB  LEU B 112     -53.512  -1.028 -13.812  1.00 61.13           C  
ATOM   3917  CG  LEU B 112     -53.045   0.153 -12.962  1.00 63.71           C  
ATOM   3918  CD1 LEU B 112     -51.782   0.765 -13.538  1.00 65.54           C  
ATOM   3919  CD2 LEU B 112     -54.157   1.186 -12.848  1.00 68.46           C  
ATOM   3920  OXT LEU B 112     -55.165  -3.021 -15.297  1.00 66.53           O  
TER    3921      LEU B 112                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
