
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  150 ( 1211),  selected  150 , name 2p1a_B
# Molecule2: number of CA atoms  150 ( 1146),  selected  150 , name T0406.pdb
# PARAMETERS: 2p1a_B.T0406.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      Y       2           -
LGA    -       -      Q       3           -
LGA    G     0_B      T       4          3.962
LGA    X     1_B      I       5           #
LGA    F     2_B      E       6          4.634
LGA    V     3_B      -       -           -
LGA    Q     4_B      -       -           -
LGA    S     5_B      G       7          2.955
LGA    A     6_B      F       8          1.997
LGA    L     7_B      L       9          2.442
LGA    H     8_B      Q      10          3.260
LGA    Q     9_B      S      11          2.648
LGA    L    10_B      W      12          2.521
LGA    K    11_B      T      13          2.973
LGA    V    12_B      Y      14          2.460
LGA    A    13_B      E      15          2.538
LGA    V    14_B      T      16          2.428
LGA    D    15_B      E      17          2.434
LGA    T    16_B      S      18          2.354
LGA    S    17_B      T      19          2.415
LGA    I    18_B      Q      20          2.487
LGA    Q    19_B      K      21          2.082
LGA    X    20_B      M      22          1.851
LGA    L    21_B      L      23          2.657
LGA    D    22_B      D      24          3.174
LGA    Q    23_B      V      25          2.733
LGA    Y    24_B      L      26          3.085
LGA    T    25_B      T      27          1.128
LGA    E    26_B      D      28          0.783
LGA    I    27_B      E      29          1.038
LGA    D    28_B      S      30          2.003
LGA    L    29_B      L      31          2.093
LGA    K    30_B      S      32          1.025
LGA    I    31_B      Q      33          4.280
LGA    A    32_B      E      34          4.728
LGA    P    33_B      I      35           #
LGA    I    34_B      A      36          3.868
LGA    Q    35_B      P      37          4.200
LGA    S    36_B      G      38           #
LGA    K    37_B      H      39          1.423
LGA    R    38_B      W      40          1.179
LGA    S    39_B      T      41          0.626
LGA    L    40_B      L      42          0.593
LGA    F    41_B      G      43          0.946
LGA    E    42_B      R      44          1.152
LGA    X    43_B      V      45          0.930
LGA    Y    44_B      A      46          0.831
LGA    A    45_B      W      47          1.229
LGA    H    46_B      H      48          1.048
LGA    L    47_B      I      49          1.298
LGA    S    48_B      V      50          1.565
LGA    L    49_B      T      51          1.515
LGA    I    50_B      A      52          2.008
LGA    C    51_B      I      53          1.709
LGA    H    52_B      P      54          2.213
LGA    A    53_B      V      55          2.019
LGA    D    54_B      I      56          1.728
LGA    L    55_B      L      57          2.154
LGA    L    56_B      S      58          2.075
LGA    I    57_B      G      59          3.611
LGA    L    58_B      T      60          2.676
LGA    N    59_B      G      61          2.311
LGA    G    60_B      L      62           -
LGA    S    61_B      K      63           -
LGA    T    62_B      F      64           -
LGA    E    63_B      E      65           -
LGA    K    64_B      G      66           -
LGA    E    65_B      -       -           -
LGA    L    66_B      -       -           -
LGA    H    67_B      -       -           -
LGA    T    68_B      -       -           -
LGA    F    69_B      E      67           #
LGA    -       -      T      68           -
LGA    Y    70_B      K      69          0.837
LGA    K    71_B      D      70           #
LGA    E    72_B      Y      71           #
LGA    Q    73_B      P      72           #
LGA    T    74_B      V      73          4.841
LGA    P    75_B      P      74          3.611
LGA    E    76_B      T      75          3.762
LGA    T    77_B      S      76          2.265
LGA    I    78_B      A      77          1.642
LGA    A    79_B      K      78          1.856
LGA    Q    80_B      T      79          1.950
LGA    X    81_B      I      80          1.319
LGA    Q    82_B      A      81          1.961
LGA    K    83_B      D      82          2.239
LGA    T    84_B      G      83          1.778
LGA    X    85_B      Y      84          1.113
LGA    I    86_B      R      85          1.701
LGA    Q    87_B      K      86          2.209
LGA    G    88_B      V      87          1.862
LGA    Y    89_B      N      88          1.351
LGA    D    90_B      T      89          1.845
LGA    L    91_B      A      90          2.478
LGA    L    92_B      F      91          2.190
LGA    S    93_B      V      92          1.565
LGA    K    94_B      E      93          2.241
LGA    T    95_B      A      94          2.654
LGA    F    96_B      L      95          2.422
LGA    L    97_B      Q      96          2.276
LGA    S    98_B      S      97          3.471
LGA    -       -      E      98           -
LGA    Y    99_B      W      99          1.192
LGA    S   100_B      T     100          2.605
LGA    N   101_B      D     101          3.008
LGA    E   102_B      K     102          2.856
LGA    Q   103_B      D     103          1.727
LGA    L   104_B      L     104          1.551
LGA    A   105_B      T     105          0.637
LGA    E   106_B      T     106          0.404
LGA    X   107_B      I     107          0.235
LGA    K   108_B      N     108          0.271
LGA    T   109_B      D     109          0.508
LGA    A   110_B      F     110          1.856
LGA    Y   111_B      F     111          2.795
LGA    W   112_B      -       -           -
LGA    G   113_B      G     112          0.862
LGA    I   114_B      R     113          1.488
LGA    S   115_B      P     114          1.866
LGA    Y   116_B      M     115          1.521
LGA    S   117_B      P     116          0.744
LGA    R   118_B      N     117          0.923
LGA    F   119_B      S     118          1.551
LGA    E   120_B      I     119          1.839
LGA    W   121_B      F     120          1.150
LGA    L   122_B      L     121          0.974
LGA    L   123_B      M     122          1.296
LGA    E   124_B      T     123          1.065
LGA    I   125_B      L     124          0.761
LGA    V   126_B      I     125          1.013
LGA    A   127_B      N     126          0.922
LGA    H   128_B      H     127          1.116
LGA    F   129_B      Q     128          1.026
LGA    Y   130_B      N     129          0.962
LGA    H   131_B      H     130          1.189
LGA    H   132_B      H     131          1.161
LGA    R   133_B      R     132          0.767
LGA    G   134_B      G     133          0.861
LGA    Q   135_B      Q     134          1.372
LGA    I   136_B      M     135          1.082
LGA    H   137_B      T     136          1.154
LGA    I   138_B      V     137          2.176
LGA    L   139_B      L     138          2.526
LGA    L   140_B      M     139          2.242
LGA    C   141_B      R     140          2.693
LGA    E   142_B      Q     141          4.216
LGA    H   143_B      A     142          4.937
LGA    X   144_B      G     143          3.152
LGA    K   145_B      L     144          3.407
LGA    D   146_B      T     145          4.042
LGA    P   147_B      V     146          1.006
LGA    N   148_B      P     147          1.447
LGA    I   149_B      G     148          2.401
LGA    -       -      V     149           -
LGA    -       -      Y     150           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  150  150    5.0    131    2.25    15.27     61.693     5.566

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.792223 * X  +  -0.081488 * Y  +  -0.604766 * Z  +  87.879753
  Y_new =  -0.321497 * X  +  -0.786614 * Y  +   0.527141 * Z  +  16.005320
  Z_new =  -0.518674 * X  +   0.612044 * Y  +   0.596975 * Z  + -14.283018 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.797861   -2.343732  [ DEG:    45.7141   -134.2859 ]
  Theta =   0.545299    2.596294  [ DEG:    31.2433    148.7567 ]
  Phi   =  -2.756082    0.385510  [ DEG:  -157.9119     22.0881 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p1a_B                                        
REMARK     2: T0406.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p1a_B.T0406.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  150  150   5.0  131   2.25   15.27  61.693
REMARK  ---------------------------------------------------------- 
MOLECULE 2p1a_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   02-MAR-07   2P1A              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE DNA-BINDING PROTEIN FROM                
TITLE    2 BACILLUS CEREUS ATCC 10987 AT 2.10 A RESOLUTION                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS CEREUS ATCC 10987;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_978475.1, BCE_2162;                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_978475.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI-2                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   20-MAR-07 2P1A    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (NP_978475.1) FROM BACILLUS CEREUS ATCC 10987 AT             
JRNL        TITL 3 2.10 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2P1A A    1   153  UNP    Q739H9   Q739H9_BACC1     1    153             
DBREF  2P1A B    1   153  UNP    Q739H9   Q739H9_BACC1     1    153             
SEQRES   1 A  154  GLY MSE PHE VAL GLN SER ALA LEU HIS GLN LEU LYS VAL          
SEQRES   2 A  154  ALA VAL ASP THR SER ILE GLN MSE LEU ASP GLN TYR THR          
SEQRES   3 A  154  GLU ILE ASP LEU LYS ILE ALA PRO ILE GLN SER LYS ARG          
SEQRES   4 A  154  SER LEU PHE GLU MSE TYR ALA HIS LEU SER LEU ILE CYS          
SEQRES   5 A  154  HIS ALA ASP LEU LEU ILE LEU ASN GLY SER THR GLU LYS          
SEQRES   6 A  154  GLU LEU HIS THR PHE TYR LYS GLU GLN THR PRO GLU THR          
SEQRES   7 A  154  ILE ALA GLN MSE GLN LYS THR MSE ILE GLN GLY TYR ASP          
SEQRES   8 A  154  LEU LEU SER LYS THR PHE LEU SER TYR SER ASN GLU GLN          
SEQRES   9 A  154  LEU ALA GLU MSE LYS THR ALA TYR TRP GLY ILE SER TYR          
SEQRES  10 A  154  SER ARG PHE GLU TRP LEU LEU GLU ILE VAL ALA HIS PHE          
SEQRES  11 A  154  TYR HIS HIS ARG GLY GLN ILE HIS ILE LEU LEU CYS GLU          
SEQRES  12 A  154  HIS MSE LYS ASP PRO ASN ILE PRO LEU PHE GLN                  
SEQRES   1 B  154  GLY MSE PHE VAL GLN SER ALA LEU HIS GLN LEU LYS VAL          
SEQRES   2 B  154  ALA VAL ASP THR SER ILE GLN MSE LEU ASP GLN TYR THR          
SEQRES   3 B  154  GLU ILE ASP LEU LYS ILE ALA PRO ILE GLN SER LYS ARG          
SEQRES   4 B  154  SER LEU PHE GLU MSE TYR ALA HIS LEU SER LEU ILE CYS          
SEQRES   5 B  154  HIS ALA ASP LEU LEU ILE LEU ASN GLY SER THR GLU LYS          
SEQRES   6 B  154  GLU LEU HIS THR PHE TYR LYS GLU GLN THR PRO GLU THR          
SEQRES   7 B  154  ILE ALA GLN MSE GLN LYS THR MSE ILE GLN GLY TYR ASP          
SEQRES   8 B  154  LEU LEU SER LYS THR PHE LEU SER TYR SER ASN GLU GLN          
SEQRES   9 B  154  LEU ALA GLU MSE LYS THR ALA TYR TRP GLY ILE SER TYR          
SEQRES  10 B  154  SER ARG PHE GLU TRP LEU LEU GLU ILE VAL ALA HIS PHE          
SEQRES  11 B  154  TYR HIS HIS ARG GLY GLN ILE HIS ILE LEU LEU CYS GLU          
SEQRES  12 B  154  HIS MSE LYS ASP PRO ASN ILE PRO LEU PHE GLN                  
HET    MSE  A   1       8                                                       
HET    MSE  A  20       8                                                       
HET    MSE  A  43       8                                                       
HET    MSE  A  81       8                                                       
HET    MSE  A  85       8                                                       
HET    MSE  A 107       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  20       8                                                       
HET    MSE  B  43       8                                                       
HET    MSE  B  81       8                                                       
HET    MSE  B  85       8                                                       
HET    MSE  B 107       8                                                       
HET    MSE  B 144       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    13(C5 H11 N O2 SE)                                           
FORMUL   3  HOH   *98(H2 O)                                                     
CRYST1   45.470   77.820   87.070  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1183  N   GLY B   0       2.024  10.063  25.878  1.00 69.09           N  
ATOM   1184  CA  GLY B   0       1.929  11.135  26.927  1.00 68.84           C  
ATOM   1185  C   GLY B   0       2.810  10.776  28.108  1.00 67.81           C  
ATOM   1186  O   GLY B   0       3.894  11.335  28.283  1.00 66.86           O  
HETATM 1187  N   MSE B   1       2.316   9.853  28.926  1.00 66.94           N  
HETATM 1188  CA  MSE B   1       3.081   9.284  30.041  1.00 68.35           C  
HETATM 1189  C   MSE B   1       4.176   8.357  29.485  1.00 58.70           C  
HETATM 1190  O   MSE B   1       5.269   8.282  30.031  1.00 57.11           O  
HETATM 1191  CB  MSE B   1       2.165   8.437  30.921  1.00 68.56           C  
HETATM 1192  CG  MSE B   1       2.805   7.890  32.207  1.00 76.84           C  
HETATM 1193 SE   MSE B   1       2.489   5.955  32.393  1.00 88.78          SE  
HETATM 1194  CE  MSE B   1       3.775   5.329  31.059  1.00 88.13           C  
ATOM   1195  N   PHE B   2       3.857   7.652  28.404  1.00 52.49           N  
ATOM   1196  CA  PHE B   2       4.765   6.705  27.763  1.00 48.04           C  
ATOM   1197  C   PHE B   2       5.870   7.446  26.994  1.00 45.80           C  
ATOM   1198  O   PHE B   2       7.029   7.030  27.012  1.00 45.38           O  
ATOM   1199  CB  PHE B   2       3.989   5.760  26.833  1.00 48.36           C  
ATOM   1200  CG  PHE B   2       2.872   5.012  27.521  1.00 48.73           C  
ATOM   1201  CD1 PHE B   2       3.114   3.807  28.173  1.00 50.16           C  
ATOM   1202  CD2 PHE B   2       1.568   5.522  27.522  1.00 51.84           C  
ATOM   1203  CE1 PHE B   2       2.080   3.117  28.830  1.00 51.36           C  
ATOM   1204  CE2 PHE B   2       0.521   4.844  28.162  1.00 50.59           C  
ATOM   1205  CZ  PHE B   2       0.780   3.635  28.820  1.00 54.16           C  
ATOM   1206  N   VAL B   3       5.493   8.526  26.304  1.00 43.07           N  
ATOM   1207  CA  VAL B   3       6.431   9.388  25.577  1.00 38.80           C  
ATOM   1208  C   VAL B   3       7.364  10.111  26.544  1.00 36.30           C  
ATOM   1209  O   VAL B   3       8.575  10.125  26.322  1.00 35.31           O  
ATOM   1210  CB  VAL B   3       5.688  10.386  24.612  1.00 39.18           C  
ATOM   1211  CG1 VAL B   3       6.599  11.523  24.132  1.00 34.31           C  
ATOM   1212  CG2 VAL B   3       5.101   9.627  23.424  1.00 33.61           C  
ATOM   1213  N   GLN B   4       6.818  10.700  27.610  1.00 35.58           N  
ATOM   1214  CA  GLN B   4       7.652  11.369  28.618  1.00 35.31           C  
ATOM   1215  C   GLN B   4       8.651  10.406  29.273  1.00 34.86           C  
ATOM   1216  O   GLN B   4       9.776  10.799  29.554  1.00 33.70           O  
ATOM   1217  CB  GLN B   4       6.812  12.103  29.687  1.00 36.45           C  
ATOM   1218  CG  GLN B   4       6.177  13.406  29.174  1.00 42.78           C  
ATOM   1219  N   SER B   5       8.238   9.152  29.495  1.00 35.86           N  
ATOM   1220  CA  SER B   5       9.104   8.111  30.063  1.00 35.61           C  
ATOM   1221  C   SER B   5      10.292   7.829  29.119  1.00 34.72           C  
ATOM   1222  O   SER B   5      11.442   7.798  29.570  1.00 33.76           O  
ATOM   1223  CB  SER B   5       8.310   6.818  30.346  1.00 36.50           C  
ATOM   1224  OG  SER B   5       7.315   7.000  31.354  1.00 40.04           O  
ATOM   1225  N   ALA B   6       9.995   7.661  27.826  1.00 35.51           N  
ATOM   1226  CA  ALA B   6      11.020   7.427  26.781  1.00 35.81           C  
ATOM   1227  C   ALA B   6      12.001   8.603  26.611  1.00 38.60           C  
ATOM   1228  O   ALA B   6      13.221   8.392  26.447  1.00 38.74           O  
ATOM   1229  CB  ALA B   6      10.367   7.100  25.453  1.00 34.61           C  
ATOM   1230  N   LEU B   7      11.471   9.831  26.627  1.00 39.94           N  
ATOM   1231  CA  LEU B   7      12.298  11.043  26.530  1.00 39.65           C  
ATOM   1232  C   LEU B   7      13.153  11.251  27.769  1.00 39.86           C  
ATOM   1233  O   LEU B   7      14.260  11.764  27.651  1.00 41.60           O  
ATOM   1234  CB  LEU B   7      11.448  12.303  26.242  1.00 39.50           C  
ATOM   1235  CG  LEU B   7      10.803  12.337  24.853  1.00 38.53           C  
ATOM   1236  CD1 LEU B   7       9.735  13.408  24.744  1.00 33.11           C  
ATOM   1237  CD2 LEU B   7      11.853  12.496  23.745  1.00 33.58           C  
ATOM   1238  N   HIS B   8      12.650  10.864  28.943  1.00 39.93           N  
ATOM   1239  CA  HIS B   8      13.398  10.996  30.194  1.00 40.39           C  
ATOM   1240  C   HIS B   8      14.598  10.050  30.223  1.00 39.44           C  
ATOM   1241  O   HIS B   8      15.658  10.426  30.690  1.00 39.55           O  
ATOM   1242  CB  HIS B   8      12.502  10.758  31.414  1.00 41.58           C  
ATOM   1243  CG  HIS B   8      13.194  11.038  32.710  1.00 47.22           C  
ATOM   1244  ND1 HIS B   8      13.675  10.047  33.537  1.00 45.35           N  
ATOM   1245  CD2 HIS B   8      13.539  12.212  33.288  1.00 54.77           C  
ATOM   1246  CE1 HIS B   8      14.262  10.602  34.583  1.00 52.49           C  
ATOM   1247  NE2 HIS B   8      14.192  11.914  34.457  1.00 55.18           N  
ATOM   1248  N   GLN B   9      14.416   8.823  29.745  1.00 40.71           N  
ATOM   1249  CA  GLN B   9      15.524   7.860  29.630  1.00 40.73           C  
ATOM   1250  C   GLN B   9      16.586   8.384  28.662  1.00 41.56           C  
ATOM   1251  O   GLN B   9      17.780   8.233  28.927  1.00 41.46           O  
ATOM   1252  CB  GLN B   9      15.036   6.444  29.227  1.00 40.54           C  
ATOM   1253  CG  GLN B   9      14.284   5.691  30.354  1.00 44.37           C  
ATOM   1254  CD  GLN B   9      15.150   5.388  31.582  1.00 43.69           C  
ATOM   1255  OE1 GLN B   9      14.792   5.708  32.733  1.00 42.49           O  
ATOM   1256  NE2 GLN B   9      16.306   4.812  31.336  1.00 42.63           N  
ATOM   1257  N   LEU B  10      16.144   9.012  27.566  1.00 42.76           N  
ATOM   1258  CA  LEU B  10      17.047   9.617  26.597  1.00 44.34           C  
ATOM   1259  C   LEU B  10      17.833  10.764  27.250  1.00 43.15           C  
ATOM   1260  O   LEU B  10      19.061  10.807  27.132  1.00 41.73           O  
ATOM   1261  CB  LEU B  10      16.288  10.114  25.359  1.00 44.96           C  
ATOM   1262  CG  LEU B  10      17.163  10.617  24.199  1.00 46.72           C  
ATOM   1263  CD1 LEU B  10      18.077   9.516  23.653  1.00 49.27           C  
ATOM   1264  CD2 LEU B  10      16.276  11.176  23.107  1.00 46.22           C  
ATOM   1265  N   LYS B  11      17.110  11.653  27.935  1.00 41.08           N  
ATOM   1266  CA  LYS B  11      17.676  12.788  28.672  1.00 41.51           C  
ATOM   1267  C   LYS B  11      18.661  12.347  29.764  1.00 41.42           C  
ATOM   1268  O   LYS B  11      19.663  13.013  29.966  1.00 42.83           O  
ATOM   1269  CB  LYS B  11      16.552  13.636  29.287  1.00 42.62           C  
ATOM   1270  CG  LYS B  11      16.960  14.946  30.006  1.00 44.98           C  
ATOM   1271  CD  LYS B  11      17.722  15.905  29.111  1.00 53.78           C  
ATOM   1272  CE  LYS B  11      17.919  17.271  29.764  1.00 56.75           C  
ATOM   1273  NZ  LYS B  11      18.815  18.133  28.925  1.00 62.49           N  
ATOM   1274  N   VAL B  12      18.380  11.241  30.458  1.00 40.32           N  
ATOM   1275  CA  VAL B  12      19.314  10.701  31.445  1.00 39.65           C  
ATOM   1276  C   VAL B  12      20.625  10.357  30.752  1.00 40.23           C  
ATOM   1277  O   VAL B  12      21.685  10.657  31.292  1.00 40.55           O  
ATOM   1278  CB  VAL B  12      18.766   9.461  32.194  1.00 40.28           C  
ATOM   1279  CG1 VAL B  12      19.878   8.758  32.985  1.00 37.07           C  
ATOM   1280  CG2 VAL B  12      17.642   9.875  33.132  1.00 39.62           C  
ATOM   1281  N   ALA B  13      20.533   9.740  29.566  1.00 39.34           N  
ATOM   1282  CA  ALA B  13      21.697   9.387  28.755  1.00 39.68           C  
ATOM   1283  C   ALA B  13      22.457  10.634  28.301  1.00 40.63           C  
ATOM   1284  O   ALA B  13      23.686  10.640  28.370  1.00 41.10           O  
ATOM   1285  CB  ALA B  13      21.288   8.531  27.546  1.00 39.35           C  
ATOM   1286  N   VAL B  14      21.723  11.676  27.881  1.00 41.63           N  
ATOM   1287  CA  VAL B  14      22.298  12.965  27.437  1.00 42.24           C  
ATOM   1288  C   VAL B  14      23.042  13.653  28.570  1.00 43.62           C  
ATOM   1289  O   VAL B  14      24.230  13.951  28.440  1.00 43.16           O  
ATOM   1290  CB  VAL B  14      21.209  13.932  26.866  1.00 41.96           C  
ATOM   1291  CG1 VAL B  14      21.725  15.377  26.724  1.00 40.47           C  
ATOM   1292  CG2 VAL B  14      20.695  13.419  25.530  1.00 43.40           C  
ATOM   1293  N   ASP B  15      22.342  13.878  29.682  1.00 45.48           N  
ATOM   1294  CA  ASP B  15      22.917  14.537  30.855  1.00 45.84           C  
ATOM   1295  C   ASP B  15      24.151  13.815  31.383  1.00 46.46           C  
ATOM   1296  O   ASP B  15      25.151  14.465  31.654  1.00 47.07           O  
ATOM   1297  CB  ASP B  15      21.878  14.691  31.983  1.00 46.46           C  
ATOM   1298  CG  ASP B  15      20.750  15.653  31.628  1.00 46.77           C  
ATOM   1299  OD1 ASP B  15      20.808  16.338  30.583  1.00 49.25           O  
ATOM   1300  OD2 ASP B  15      19.786  15.721  32.411  1.00 56.27           O  
ATOM   1301  N   THR B  16      24.077  12.487  31.505  1.00 46.72           N  
ATOM   1302  CA  THR B  16      25.211  11.686  31.986  1.00 46.80           C  
ATOM   1303  C   THR B  16      26.385  11.702  30.996  1.00 48.30           C  
ATOM   1304  O   THR B  16      27.540  11.711  31.423  1.00 50.25           O  
ATOM   1305  CB  THR B  16      24.828  10.230  32.301  1.00 46.64           C  
ATOM   1306  OG1 THR B  16      24.214   9.632  31.151  1.00 49.88           O  
ATOM   1307  CG2 THR B  16      23.895  10.160  33.501  1.00 40.71           C  
ATOM   1308  N   SER B  17      26.098  11.696  29.692  1.00 48.48           N  
ATOM   1309  CA  SER B  17      27.154  11.808  28.666  1.00 48.13           C  
ATOM   1310  C   SER B  17      27.858  13.162  28.726  1.00 49.32           C  
ATOM   1311  O   SER B  17      29.037  13.234  28.445  1.00 50.12           O  
ATOM   1312  CB  SER B  17      26.595  11.604  27.267  1.00 47.44           C  
ATOM   1313  OG  SER B  17      26.172  10.276  27.102  1.00 46.27           O  
ATOM   1314  N   ILE B  18      27.117  14.218  29.063  1.00 51.00           N  
ATOM   1315  CA  ILE B  18      27.650  15.583  29.220  1.00 52.18           C  
ATOM   1316  C   ILE B  18      28.541  15.694  30.458  1.00 53.52           C  
ATOM   1317  O   ILE B  18      29.570  16.365  30.412  1.00 54.93           O  
ATOM   1318  CB  ILE B  18      26.494  16.641  29.220  1.00 52.30           C  
ATOM   1319  CG1 ILE B  18      25.930  16.771  27.796  1.00 52.28           C  
ATOM   1320  CG2 ILE B  18      26.968  18.016  29.691  1.00 52.56           C  
ATOM   1321  CD1 ILE B  18      24.696  17.638  27.675  1.00 51.94           C  
ATOM   1322  N   GLN B  19      28.130  15.052  31.550  1.00 54.56           N  
ATOM   1323  CA  GLN B  19      28.914  15.000  32.783  1.00 57.06           C  
ATOM   1324  C   GLN B  19      30.164  14.140  32.608  1.00 57.91           C  
ATOM   1325  O   GLN B  19      31.232  14.490  33.119  1.00 58.79           O  
ATOM   1326  CB  GLN B  19      28.079  14.440  33.933  1.00 57.31           C  
ATOM   1327  CG  GLN B  19      26.947  15.364  34.371  1.00 61.03           C  
ATOM   1328  CD  GLN B  19      25.918  14.695  35.279  1.00 61.15           C  
ATOM   1329  OE1 GLN B  19      25.978  13.487  35.563  1.00 65.76           O  
ATOM   1330  NE2 GLN B  19      24.949  15.486  35.726  1.00 70.73           N  
HETATM 1331  N   MSE B  20      30.011  13.004  31.927  1.00 58.93           N  
HETATM 1332  CA  MSE B  20      31.125  12.094  31.609  1.00 59.71           C  
HETATM 1333  C   MSE B  20      32.166  12.806  30.716  1.00 59.03           C  
HETATM 1334  O   MSE B  20      33.373  12.641  30.912  1.00 59.48           O  
HETATM 1335  CB  MSE B  20      30.586  10.801  30.955  1.00 58.88           C  
HETATM 1336  CG  MSE B  20      31.637   9.759  30.549  1.00 60.64           C  
HETATM 1337 SE   MSE B  20      30.925   8.029  29.874  0.75 64.34          SE  
HETATM 1338  CE  MSE B  20      29.636   8.640  28.530  1.00 55.87           C  
ATOM   1339  N   LEU B  21      31.681  13.615  29.773  1.00 59.21           N  
ATOM   1340  CA  LEU B  21      32.520  14.390  28.841  1.00 59.48           C  
ATOM   1341  C   LEU B  21      33.371  15.470  29.543  1.00 61.08           C  
ATOM   1342  O   LEU B  21      34.467  15.780  29.068  1.00 62.40           O  
ATOM   1343  CB  LEU B  21      31.641  14.999  27.736  1.00 59.14           C  
ATOM   1344  CG  LEU B  21      32.206  15.629  26.471  1.00 59.55           C  
ATOM   1345  CD1 LEU B  21      33.138  14.679  25.724  1.00 53.64           C  
ATOM   1346  CD2 LEU B  21      31.038  16.060  25.577  1.00 57.38           C  
ATOM   1347  N   ASP B  22      32.874  16.029  30.655  1.00 60.66           N  
ATOM   1348  CA  ASP B  22      33.639  17.003  31.463  1.00 60.79           C  
ATOM   1349  C   ASP B  22      34.840  16.401  32.218  1.00 60.39           C  
ATOM   1350  O   ASP B  22      35.757  17.137  32.583  1.00 60.81           O  
ATOM   1351  CB  ASP B  22      32.731  17.743  32.462  1.00 60.92           C  
ATOM   1352  CG  ASP B  22      31.759  18.700  31.792  1.00 61.69           C  
ATOM   1353  OD1 ASP B  22      31.910  19.022  30.592  1.00 60.15           O  
ATOM   1354  OD2 ASP B  22      30.834  19.156  32.498  1.00 64.74           O  
ATOM   1355  N   GLN B  23      34.852  15.083  32.433  1.00 59.45           N  
ATOM   1356  CA  GLN B  23      35.985  14.407  33.092  1.00 59.81           C  
ATOM   1357  C   GLN B  23      37.208  14.209  32.173  1.00 58.28           C  
ATOM   1358  O   GLN B  23      38.238  13.703  32.637  1.00 57.45           O  
ATOM   1359  CB  GLN B  23      35.563  13.042  33.670  1.00 61.42           C  
ATOM   1360  CG  GLN B  23      34.279  13.048  34.523  1.00 67.41           C  
ATOM   1361  CD  GLN B  23      34.230  14.185  35.544  1.00 76.11           C  
ATOM   1362  OE1 GLN B  23      35.152  14.361  36.348  1.00 81.33           O  
ATOM   1363  NE2 GLN B  23      33.146  14.964  35.510  1.00 82.24           N  
ATOM   1364  N   TYR B  24      37.101  14.593  30.893  1.00 56.97           N  
ATOM   1365  CA  TYR B  24      38.185  14.480  29.910  1.00 56.69           C  
ATOM   1366  C   TYR B  24      38.331  15.787  29.155  1.00 55.60           C  
ATOM   1367  O   TYR B  24      37.432  16.627  29.176  1.00 55.46           O  
ATOM   1368  CB  TYR B  24      37.899  13.330  28.936  1.00 57.18           C  
ATOM   1369  CG  TYR B  24      37.582  12.052  29.669  1.00 60.35           C  
ATOM   1370  CD1 TYR B  24      38.601  11.208  30.130  1.00 61.97           C  
ATOM   1371  CD2 TYR B  24      36.259  11.720  29.976  1.00 61.23           C  
ATOM   1372  CE1 TYR B  24      38.302  10.042  30.853  1.00 60.55           C  
ATOM   1373  CE2 TYR B  24      35.947  10.564  30.701  1.00 60.39           C  
ATOM   1374  CZ  TYR B  24      36.975   9.733  31.131  1.00 59.09           C  
ATOM   1375  OH  TYR B  24      36.680   8.604  31.833  1.00 62.67           O  
ATOM   1376  N   THR B  25      39.487  15.961  28.528  1.00 55.00           N  
ATOM   1377  CA  THR B  25      39.798  17.128  27.710  1.00 55.41           C  
ATOM   1378  C   THR B  25      39.859  16.668  26.267  1.00 56.09           C  
ATOM   1379  O   THR B  25      39.917  15.469  25.990  1.00 54.42           O  
ATOM   1380  CB  THR B  25      41.157  17.746  28.083  1.00 55.78           C  
ATOM   1381  OG1 THR B  25      42.201  16.793  27.845  1.00 55.46           O  
ATOM   1382  CG2 THR B  25      41.187  18.171  29.546  1.00 55.78           C  
ATOM   1383  N   GLU B  26      39.858  17.635  25.353  1.00 58.25           N  
ATOM   1384  CA  GLU B  26      39.957  17.372  23.913  1.00 60.71           C  
ATOM   1385  C   GLU B  26      41.184  16.491  23.596  1.00 59.44           C  
ATOM   1386  O   GLU B  26      41.081  15.548  22.815  1.00 58.57           O  
ATOM   1387  CB  GLU B  26      39.976  18.709  23.141  1.00 60.71           C  
ATOM   1388  CG  GLU B  26      40.237  18.601  21.635  1.00 67.11           C  
ATOM   1389  CD  GLU B  26      40.035  19.908  20.865  1.00 67.59           C  
ATOM   1390  OE1 GLU B  26      39.147  20.723  21.229  1.00 79.29           O  
ATOM   1391  OE2 GLU B  26      40.753  20.095  19.858  1.00 76.43           O  
ATOM   1392  N   ILE B  27      42.313  16.776  24.254  1.00 59.10           N  
ATOM   1393  CA  ILE B  27      43.558  16.016  24.072  1.00 58.13           C  
ATOM   1394  C   ILE B  27      43.413  14.558  24.560  1.00 56.70           C  
ATOM   1395  O   ILE B  27      43.821  13.644  23.848  1.00 55.71           O  
ATOM   1396  CB  ILE B  27      44.808  16.736  24.721  1.00 59.20           C  
ATOM   1397  CG1 ILE B  27      45.274  17.945  23.886  1.00 60.36           C  
ATOM   1398  CG2 ILE B  27      46.016  15.788  24.822  1.00 56.23           C  
ATOM   1399  CD1 ILE B  27      44.323  19.117  23.802  1.00 64.18           C  
ATOM   1400  N   ASP B  28      42.825  14.349  25.744  1.00 55.29           N  
ATOM   1401  CA  ASP B  28      42.581  12.992  26.284  1.00 55.00           C  
ATOM   1402  C   ASP B  28      41.814  12.086  25.303  1.00 55.28           C  
ATOM   1403  O   ASP B  28      42.178  10.927  25.105  1.00 56.28           O  
ATOM   1404  CB  ASP B  28      41.757  13.018  27.591  1.00 55.68           C  
ATOM   1405  CG  ASP B  28      42.486  13.632  28.779  1.00 55.45           C  
ATOM   1406  OD1 ASP B  28      43.737  13.658  28.801  1.00 56.58           O  
ATOM   1407  OD2 ASP B  28      41.777  14.053  29.728  1.00 56.97           O  
ATOM   1408  N   LEU B  29      40.765  12.633  24.693  1.00 55.05           N  
ATOM   1409  CA  LEU B  29      39.899  11.880  23.768  1.00 54.91           C  
ATOM   1410  C   LEU B  29      40.564  11.594  22.407  1.00 55.25           C  
ATOM   1411  O   LEU B  29      40.421  10.493  21.869  1.00 54.14           O  
ATOM   1412  CB  LEU B  29      38.573  12.626  23.567  1.00 54.03           C  
ATOM   1413  CG  LEU B  29      37.746  12.920  24.819  1.00 51.12           C  
ATOM   1414  CD1 LEU B  29      36.578  13.822  24.443  1.00 50.39           C  
ATOM   1415  CD2 LEU B  29      37.284  11.631  25.503  1.00 46.03           C  
ATOM   1416  N   LYS B  30      41.263  12.594  21.868  1.00 56.60           N  
ATOM   1417  CA  LYS B  30      41.982  12.478  20.593  1.00 58.74           C  
ATOM   1418  C   LYS B  30      43.207  11.556  20.680  1.00 61.95           C  
ATOM   1419  O   LYS B  30      43.432  10.741  19.780  1.00 61.75           O  
ATOM   1420  CB  LYS B  30      42.408  13.860  20.071  1.00 58.05           C  
ATOM   1421  CG  LYS B  30      41.257  14.705  19.551  1.00 58.28           C  
ATOM   1422  CD  LYS B  30      41.734  16.061  19.048  1.00 57.38           C  
ATOM   1423  CE  LYS B  30      40.614  16.861  18.402  1.00 56.46           C  
ATOM   1424  NZ  LYS B  30      41.085  18.191  17.926  1.00 54.07           N  
ATOM   1425  N   ILE B  31      43.973  11.693  21.765  1.00 65.85           N  
ATOM   1426  CA  ILE B  31      45.202  10.906  22.009  1.00 69.57           C  
ATOM   1427  C   ILE B  31      45.010   9.452  22.501  1.00 70.61           C  
ATOM   1428  O   ILE B  31      45.890   8.626  22.238  1.00 70.96           O  
ATOM   1429  CB  ILE B  31      46.265  11.752  22.862  1.00 69.70           C  
ATOM   1430  CG1 ILE B  31      47.367  12.325  21.939  1.00 72.09           C  
ATOM   1431  CG2 ILE B  31      46.933  10.937  23.979  1.00 69.76           C  
ATOM   1432  CD1 ILE B  31      46.889  13.240  20.771  1.00 74.68           C  
ATOM   1433  N   ALA B  32      43.883   9.127  23.156  1.00 72.44           N  
ATOM   1434  CA  ALA B  32      43.610   7.755  23.681  1.00 73.78           C  
ATOM   1435  C   ALA B  32      43.865   6.656  22.616  1.00 75.64           C  
ATOM   1436  O   ALA B  32      43.414   6.828  21.480  1.00 76.66           O  
ATOM   1437  CB  ALA B  32      42.190   7.648  24.224  1.00 72.63           C  
ATOM   1438  N   PRO B  33      44.607   5.559  22.964  1.00 77.12           N  
ATOM   1439  CA  PRO B  33      45.015   4.510  21.983  1.00 78.34           C  
ATOM   1440  C   PRO B  33      43.895   3.764  21.215  1.00 81.10           C  
ATOM   1441  O   PRO B  33      43.948   3.676  19.979  1.00 82.40           O  
ATOM   1442  CB  PRO B  33      45.857   3.541  22.832  1.00 79.18           C  
ATOM   1443  CG  PRO B  33      45.458   3.799  24.235  1.00 77.56           C  
ATOM   1444  CD  PRO B  33      45.124   5.245  24.312  1.00 76.65           C  
ATOM   1445  N   ILE B  34      42.940   3.202  21.957  1.00 82.73           N  
ATOM   1446  CA  ILE B  34      41.739   2.519  21.411  1.00 83.57           C  
ATOM   1447  C   ILE B  34      41.959   1.176  20.664  1.00 84.01           C  
ATOM   1448  O   ILE B  34      41.694   0.113  21.241  1.00 83.86           O  
ATOM   1449  CB  ILE B  34      40.834   3.515  20.557  1.00 83.06           C  
ATOM   1450  CG1 ILE B  34      40.567   4.820  21.318  1.00 82.41           C  
ATOM   1451  CG2 ILE B  34      39.505   2.882  20.164  1.00 83.53           C  
ATOM   1452  CD1 ILE B  34      40.079   4.636  22.751  1.00 80.63           C  
ATOM   1453  N   GLN B  35      42.434   1.252  19.415  1.00 84.45           N  
ATOM   1454  CA  GLN B  35      42.618   0.115  18.470  1.00 85.00           C  
ATOM   1455  C   GLN B  35      41.644   0.277  17.289  1.00 85.68           C  
ATOM   1456  O   GLN B  35      42.028   0.036  16.139  1.00 86.86           O  
ATOM   1457  CB  GLN B  35      42.469  -1.290  19.088  1.00 85.24           C  
ATOM   1458  N   SER B  36      40.401   0.679  17.572  1.00 85.29           N  
ATOM   1459  CA  SER B  36      39.371   0.922  16.532  1.00 85.21           C  
ATOM   1460  C   SER B  36      39.717   2.062  15.539  1.00 84.87           C  
ATOM   1461  O   SER B  36      40.567   2.919  15.832  1.00 84.78           O  
ATOM   1462  CB  SER B  36      38.006   1.180  17.188  1.00 86.34           C  
ATOM   1463  OG  SER B  36      37.647   0.086  18.027  1.00 89.01           O  
ATOM   1464  N   LYS B  37      39.040   2.050  14.379  1.00 83.63           N  
ATOM   1465  CA  LYS B  37      39.273   3.008  13.253  1.00 82.15           C  
ATOM   1466  C   LYS B  37      39.167   4.519  13.551  1.00 78.60           C  
ATOM   1467  O   LYS B  37      39.786   5.318  12.827  1.00 80.16           O  
ATOM   1468  CB  LYS B  37      38.348   2.687  12.062  1.00 81.43           C  
ATOM   1469  N   ARG B  38      38.384   4.882  14.583  1.00 73.73           N  
ATOM   1470  CA  ARG B  38      38.164   6.278  14.994  0.50 70.99           C  
ATOM   1472  C   ARG B  38      38.487   6.484  16.479  1.00 68.27           C  
ATOM   1473  O   ARG B  38      38.405   5.543  17.278  1.00 68.16           O  
ATOM   1474  CB  ARG B  38      36.713   6.694  14.705  0.50 71.53           C  
ATOM   1476  CG  ARG B  38      36.368   6.840  13.215  0.50 71.84           C  
ATOM   1478  CD  ARG B  38      34.933   7.331  13.011  0.50 70.03           C  
ATOM   1480  NE  ARG B  38      34.640   7.624  11.602  0.50 68.21           N  
ATOM   1482  CZ  ARG B  38      34.953   8.750  10.944  0.50 66.54           C  
ATOM   1484  NH1 ARG B  38      35.608   9.755  11.533  0.50 65.56           N  
ATOM   1486  NH2 ARG B  38      34.614   8.871   9.659  0.50 65.34           N  
ATOM   1488  N   SER B  39      38.841   7.723  16.832  1.00 62.79           N  
ATOM   1489  CA  SER B  39      39.193   8.096  18.205  1.00 57.95           C  
ATOM   1490  C   SER B  39      37.976   8.275  19.106  1.00 55.24           C  
ATOM   1491  O   SER B  39      36.856   8.391  18.618  1.00 54.00           O  
ATOM   1492  CB  SER B  39      40.012   9.399  18.199  1.00 57.54           C  
ATOM   1493  OG  SER B  39      39.315  10.463  17.571  1.00 50.64           O  
ATOM   1494  N   LEU B  40      38.213   8.307  20.424  1.00 52.24           N  
ATOM   1495  CA  LEU B  40      37.149   8.584  21.416  1.00 51.35           C  
ATOM   1496  C   LEU B  40      36.502   9.945  21.188  1.00 50.73           C  
ATOM   1497  O   LEU B  40      35.345  10.126  21.526  1.00 52.83           O  
ATOM   1498  CB  LEU B  40      37.635   8.486  22.876  1.00 50.30           C  
ATOM   1499  CG  LEU B  40      37.713   7.088  23.492  1.00 51.90           C  
ATOM   1500  CD1 LEU B  40      38.477   7.109  24.819  1.00 50.59           C  
ATOM   1501  CD2 LEU B  40      36.321   6.464  23.679  1.00 52.34           C  
ATOM   1502  N   PHE B  41      37.265  10.888  20.642  1.00 49.42           N  
ATOM   1503  CA  PHE B  41      36.770  12.207  20.273  1.00 48.20           C  
ATOM   1504  C   PHE B  41      35.735  12.064  19.155  1.00 47.89           C  
ATOM   1505  O   PHE B  41      34.627  12.563  19.289  1.00 45.50           O  
ATOM   1506  CB  PHE B  41      37.936  13.106  19.811  1.00 48.24           C  
ATOM   1507  CG  PHE B  41      37.542  14.523  19.598  1.00 46.43           C  
ATOM   1508  CD1 PHE B  41      37.532  15.410  20.670  1.00 46.27           C  
ATOM   1509  CD2 PHE B  41      37.151  14.977  18.335  1.00 47.36           C  
ATOM   1510  CE1 PHE B  41      37.151  16.733  20.493  1.00 46.73           C  
ATOM   1511  CE2 PHE B  41      36.760  16.304  18.147  1.00 46.83           C  
ATOM   1512  CZ  PHE B  41      36.764  17.183  19.234  1.00 46.04           C  
ATOM   1513  N   GLU B  42      36.110  11.372  18.074  1.00 47.39           N  
ATOM   1514  CA  GLU B  42      35.229  11.127  16.911  1.00 48.75           C  
ATOM   1515  C   GLU B  42      33.935  10.380  17.259  1.00 47.62           C  
ATOM   1516  O   GLU B  42      32.867  10.688  16.712  1.00 48.15           O  
ATOM   1517  CB  GLU B  42      35.992  10.397  15.795  1.00 48.49           C  
ATOM   1518  CG  GLU B  42      37.033  11.300  15.123  1.00 52.14           C  
ATOM   1519  CD  GLU B  42      37.911  10.574  14.117  1.00 54.32           C  
ATOM   1520  OE1 GLU B  42      38.499   9.522  14.470  1.00 61.40           O  
ATOM   1521  OE2 GLU B  42      38.046  11.087  12.982  1.00 62.33           O  
HETATM 1522  N   MSE B  43      34.047   9.416  18.171  1.00 46.56           N  
HETATM 1523  CA  MSE B  43      32.900   8.650  18.667  1.00 46.66           C  
HETATM 1524  C   MSE B  43      31.963   9.485  19.549  1.00 43.92           C  
HETATM 1525  O   MSE B  43      30.752   9.239  19.569  1.00 43.20           O  
HETATM 1526  CB  MSE B  43      33.372   7.434  19.455  1.00 45.20           C  
HETATM 1527  CG  MSE B  43      34.085   6.433  18.597  1.00 50.36           C  
HETATM 1528 SE   MSE B  43      34.700   5.003  19.680  0.75 55.07          SE  
HETATM 1529  CE  MSE B  43      32.982   4.143  20.086  1.00 52.00           C  
ATOM   1530  N   TYR B  44      32.533  10.446  20.275  1.00 42.72           N  
ATOM   1531  CA  TYR B  44      31.764  11.327  21.156  1.00 42.43           C  
ATOM   1532  C   TYR B  44      31.068  12.375  20.278  1.00 40.88           C  
ATOM   1533  O   TYR B  44      29.924  12.751  20.558  1.00 41.49           O  
ATOM   1534  CB  TYR B  44      32.655  11.995  22.215  1.00 43.10           C  
ATOM   1535  CG  TYR B  44      32.161  11.800  23.620  1.00 44.57           C  
ATOM   1536  CD1 TYR B  44      31.024  12.466  24.086  1.00 51.43           C  
ATOM   1537  CD2 TYR B  44      32.834  10.944  24.505  1.00 49.45           C  
ATOM   1538  CE1 TYR B  44      30.563  12.276  25.402  1.00 50.00           C  
ATOM   1539  CE2 TYR B  44      32.382  10.752  25.828  1.00 50.64           C  
ATOM   1540  CZ  TYR B  44      31.249  11.419  26.260  1.00 44.05           C  
ATOM   1541  OH  TYR B  44      30.811  11.239  27.542  1.00 47.91           O  
ATOM   1542  N   ALA B  45      31.766  12.850  19.242  1.00 38.65           N  
ATOM   1543  CA  ALA B  45      31.193  13.774  18.264  1.00 39.15           C  
ATOM   1544  C   ALA B  45      29.979  13.117  17.573  1.00 39.77           C  
ATOM   1545  O   ALA B  45      28.933  13.785  17.436  1.00 37.52           O  
ATOM   1546  CB  ALA B  45      32.236  14.247  17.254  1.00 38.75           C  
ATOM   1547  N   HIS B  46      30.116  11.833  17.176  1.00 38.71           N  
ATOM   1548  CA  HIS B  46      29.015  11.008  16.587  0.50 39.15           C  
ATOM   1550  C   HIS B  46      27.844  10.892  17.576  1.00 39.72           C  
ATOM   1551  O   HIS B  46      26.673  11.050  17.204  1.00 39.35           O  
ATOM   1552  CB  HIS B  46      29.531   9.590  16.211  0.50 38.77           C  
ATOM   1554  CG  HIS B  46      28.482   8.639  15.682  0.50 39.39           C  
ATOM   1556  ND1 HIS B  46      28.192   8.515  14.339  0.50 42.92           N  
ATOM   1558  CD2 HIS B  46      27.705   7.724  16.315  0.50 38.44           C  
ATOM   1560  CE1 HIS B  46      27.261   7.591  14.170  0.50 37.17           C  
ATOM   1562  NE2 HIS B  46      26.948   7.094  15.353  0.50 33.59           N  
ATOM   1564  N   LEU B  47      28.175  10.603  18.840  1.00 38.91           N  
ATOM   1565  CA  LEU B  47      27.168  10.456  19.905  1.00 38.61           C  
ATOM   1566  C   LEU B  47      26.336  11.734  20.027  1.00 38.46           C  
ATOM   1567  O   LEU B  47      25.119  11.670  20.167  1.00 40.07           O  
ATOM   1568  CB  LEU B  47      27.817  10.137  21.264  1.00 39.24           C  
ATOM   1569  CG  LEU B  47      26.904   9.759  22.452  1.00 37.33           C  
ATOM   1570  CD1 LEU B  47      26.387   8.340  22.292  1.00 33.62           C  
ATOM   1571  CD2 LEU B  47      27.623   9.905  23.772  1.00 36.71           C  
ATOM   1572  N   SER B  48      26.993  12.887  19.924  1.00 39.21           N  
ATOM   1573  CA  SER B  48      26.311  14.178  20.046  1.00 40.10           C  
ATOM   1574  C   SER B  48      25.322  14.484  18.907  1.00 39.15           C  
ATOM   1575  O   SER B  48      24.389  15.312  19.088  1.00 37.86           O  
ATOM   1576  CB  SER B  48      27.328  15.324  20.187  1.00 41.94           C  
ATOM   1577  OG  SER B  48      27.882  15.675  18.932  1.00 40.39           O  
ATOM   1578  N   LEU B  49      25.522  13.825  17.763  1.00 36.28           N  
ATOM   1579  CA  LEU B  49      24.658  13.971  16.589  1.00 36.77           C  
ATOM   1580  C   LEU B  49      23.474  12.998  16.499  1.00 36.67           C  
ATOM   1581  O   LEU B  49      22.628  13.180  15.609  1.00 38.41           O  
ATOM   1582  CB  LEU B  49      25.486  13.862  15.296  1.00 36.77           C  
ATOM   1583  CG  LEU B  49      26.478  14.962  14.933  1.00 35.88           C  
ATOM   1584  CD1 LEU B  49      27.083  14.622  13.551  1.00 31.97           C  
ATOM   1585  CD2 LEU B  49      25.800  16.320  14.899  1.00 35.05           C  
ATOM   1586  N   ILE B  50      23.391  12.012  17.409  1.00 34.33           N  
ATOM   1587  CA  ILE B  50      22.327  10.984  17.378  1.00 31.85           C  
ATOM   1588  C   ILE B  50      20.912  11.576  17.418  1.00 32.07           C  
ATOM   1589  O   ILE B  50      20.087  11.259  16.574  1.00 28.81           O  
ATOM   1590  CB  ILE B  50      22.513   9.932  18.511  1.00 32.44           C  
ATOM   1591  CG1 ILE B  50      23.748   9.057  18.206  1.00 29.44           C  
ATOM   1592  CG2 ILE B  50      21.277   9.048  18.666  1.00 29.25           C  
ATOM   1593  CD1 ILE B  50      24.083   8.067  19.300  1.00 28.21           C  
ATOM   1594  N   CYS B  51      20.636  12.456  18.375  1.00 32.69           N  
ATOM   1595  CA  CYS B  51      19.292  13.027  18.447  1.00 31.06           C  
ATOM   1596  C   CYS B  51      18.873  13.749  17.168  1.00 30.17           C  
ATOM   1597  O   CYS B  51      17.779  13.499  16.681  1.00 32.06           O  
ATOM   1598  CB  CYS B  51      19.140  13.899  19.670  1.00 32.46           C  
ATOM   1599  SG  CYS B  51      19.141  12.888  21.121  1.00 37.42           S  
ATOM   1600  N   HIS B  52      19.758  14.582  16.609  1.00 30.15           N  
ATOM   1601  CA  HIS B  52      19.479  15.313  15.359  1.00 30.17           C  
ATOM   1602  C   HIS B  52      19.322  14.371  14.154  1.00 30.87           C  
ATOM   1603  O   HIS B  52      18.351  14.465  13.420  1.00 32.01           O  
ATOM   1604  CB  HIS B  52      20.611  16.289  15.002  1.00 32.31           C  
ATOM   1605  CG  HIS B  52      20.530  17.636  15.652  1.00 34.85           C  
ATOM   1606  ND1 HIS B  52      21.360  18.020  16.684  1.00 39.00           N  
ATOM   1607  CD2 HIS B  52      19.792  18.728  15.337  1.00 37.87           C  
ATOM   1608  CE1 HIS B  52      21.108  19.279  17.000  1.00 41.60           C  
ATOM   1609  NE2 HIS B  52      20.159  19.731  16.200  1.00 39.66           N  
ATOM   1610  N   ALA B  53      20.308  13.493  13.959  1.00 29.41           N  
ATOM   1611  CA  ALA B  53      20.359  12.547  12.814  1.00 27.89           C  
ATOM   1612  C   ALA B  53      19.145  11.625  12.760  1.00 26.16           C  
ATOM   1613  O   ALA B  53      18.407  11.563  11.776  1.00 27.76           O  
ATOM   1614  CB  ALA B  53      21.638  11.703  12.911  1.00 24.20           C  
ATOM   1615  N   ASP B  54      18.919  10.925  13.850  1.00 28.12           N  
ATOM   1616  CA  ASP B  54      17.786  10.026  13.939  1.00 30.23           C  
ATOM   1617  C   ASP B  54      16.433  10.754  13.787  1.00 29.97           C  
ATOM   1618  O   ASP B  54      15.488  10.168  13.258  1.00 30.34           O  
ATOM   1619  CB  ASP B  54      17.849   9.196  15.224  1.00 32.60           C  
ATOM   1620  CG  ASP B  54      19.030   8.196  15.269  1.00 34.39           C  
ATOM   1621  OD1 ASP B  54      19.840   8.101  14.313  1.00 43.97           O  
ATOM   1622  OD2 ASP B  54      19.140   7.479  16.294  1.00 38.88           O  
ATOM   1623  N   LEU B  55      16.341  12.025  14.194  1.00 31.87           N  
ATOM   1624  CA  LEU B  55      15.107  12.834  13.930  1.00 32.15           C  
ATOM   1625  C   LEU B  55      14.967  13.140  12.428  1.00 33.26           C  
ATOM   1626  O   LEU B  55      13.851  13.145  11.902  1.00 32.82           O  
ATOM   1627  CB  LEU B  55      15.082  14.156  14.695  1.00 31.70           C  
ATOM   1628  CG  LEU B  55      13.797  14.998  14.507  1.00 32.55           C  
ATOM   1629  CD1 LEU B  55      12.554  14.224  14.861  1.00 30.24           C  
ATOM   1630  CD2 LEU B  55      13.892  16.238  15.318  1.00 27.88           C  
ATOM   1631  N   LEU B  56      16.084  13.462  11.767  1.00 33.50           N  
ATOM   1632  CA  LEU B  56      16.087  13.690  10.315  0.50 32.21           C  
ATOM   1634  C   LEU B  56      15.636  12.397   9.610  1.00 33.62           C  
ATOM   1635  O   LEU B  56      14.793  12.429   8.721  1.00 34.25           O  
ATOM   1636  CB  LEU B  56      17.465  14.154   9.821  0.50 31.58           C  
ATOM   1638  CG  LEU B  56      17.969  15.556  10.190  0.50 21.43           C  
ATOM   1640  CD1 LEU B  56      19.485  15.628  10.165  0.50  9.43           C  
ATOM   1642  CD2 LEU B  56      17.393  16.622   9.285  0.50  9.29           C  
ATOM   1644  N   ILE B  57      16.176  11.253  10.040  1.00 35.78           N  
ATOM   1645  CA  ILE B  57      15.797   9.929   9.472  1.00 34.02           C  
ATOM   1646  C   ILE B  57      14.282   9.682   9.570  1.00 35.57           C  
ATOM   1647  O   ILE B  57      13.642   9.314   8.583  1.00 35.85           O  
ATOM   1648  CB  ILE B  57      16.578   8.773  10.145  1.00 34.51           C  
ATOM   1649  CG1 ILE B  57      18.039   8.775   9.653  1.00 35.07           C  
ATOM   1650  CG2 ILE B  57      15.966   7.429   9.797  1.00 36.13           C  
ATOM   1651  CD1 ILE B  57      18.969   7.809  10.362  1.00 28.19           C  
ATOM   1652  N   LEU B  58      13.737   9.910  10.762  1.00 36.20           N  
ATOM   1653  CA  LEU B  58      12.294   9.809  11.039  1.00 36.57           C  
ATOM   1654  C   LEU B  58      11.451  10.714  10.125  1.00 37.86           C  
ATOM   1655  O   LEU B  58      10.357  10.327   9.691  1.00 39.01           O  
ATOM   1656  CB  LEU B  58      12.027  10.205  12.507  1.00 36.43           C  
ATOM   1657  CG  LEU B  58      10.598  10.201  13.066  1.00 36.44           C  
ATOM   1658  CD1 LEU B  58       9.936   8.832  12.893  1.00 37.84           C  
ATOM   1659  CD2 LEU B  58      10.646  10.632  14.518  1.00 35.01           C  
ATOM   1660  N   ASN B  59      11.976  11.912   9.851  1.00 38.89           N  
ATOM   1661  CA  ASN B  59      11.340  12.911   8.982  1.00 38.51           C  
ATOM   1662  C   ASN B  59      11.685  12.816   7.493  1.00 40.39           C  
ATOM   1663  O   ASN B  59      11.652  13.827   6.792  1.00 43.54           O  
ATOM   1664  CB  ASN B  59      11.603  14.322   9.550  1.00 38.85           C  
ATOM   1665  CG  ASN B  59      10.875  14.554  10.853  1.00 33.05           C  
ATOM   1666  OD1 ASN B  59       9.820  13.974  11.088  1.00 33.63           O  
ATOM   1667  ND2 ASN B  59      11.409  15.427  11.690  1.00 34.30           N  
ATOM   1668  N   GLY B  60      12.000  11.605   7.026  1.00 38.08           N  
ATOM   1669  CA  GLY B  60      12.207  11.322   5.625  1.00 39.62           C  
ATOM   1670  C   GLY B  60      13.492  11.735   4.963  1.00 41.40           C  
ATOM   1671  O   GLY B  60      13.548  11.748   3.731  1.00 43.77           O  
ATOM   1672  N   SER B  61      14.533  12.042   5.736  1.00 41.88           N  
ATOM   1673  CA  SER B  61      15.799  12.455   5.138  1.00 41.63           C  
ATOM   1674  C   SER B  61      16.440  11.316   4.357  1.00 43.40           C  
ATOM   1675  O   SER B  61      16.344  10.150   4.759  1.00 42.20           O  
ATOM   1676  CB  SER B  61      16.763  13.026   6.170  1.00 43.50           C  
ATOM   1677  OG  SER B  61      16.306  14.302   6.574  1.00 36.46           O  
ATOM   1678  N   THR B  62      17.045  11.669   3.222  1.00 44.41           N  
ATOM   1679  CA  THR B  62      17.720  10.705   2.357  1.00 45.39           C  
ATOM   1680  C   THR B  62      19.070  10.353   2.950  1.00 46.04           C  
ATOM   1681  O   THR B  62      19.568  11.065   3.834  1.00 46.85           O  
ATOM   1682  CB  THR B  62      17.970  11.267   0.925  1.00 44.90           C  
ATOM   1683  OG1 THR B  62      18.837  12.405   0.996  1.00 44.60           O  
ATOM   1684  CG2 THR B  62      16.660  11.655   0.234  1.00 39.91           C  
ATOM   1685  N   GLU B  63      19.639   9.254   2.450  1.00 46.77           N  
ATOM   1686  CA  GLU B  63      20.981   8.796   2.819  1.00 47.96           C  
ATOM   1687  C   GLU B  63      21.980   9.917   2.555  1.00 46.99           C  
ATOM   1688  O   GLU B  63      22.718  10.312   3.464  1.00 46.96           O  
ATOM   1689  CB  GLU B  63      21.372   7.551   2.013  1.00 47.82           C  
ATOM   1690  CG  GLU B  63      22.727   6.941   2.411  1.00 52.31           C  
ATOM   1691  CD  GLU B  63      22.964   5.544   1.839  1.00 52.76           C  
ATOM   1692  OE1 GLU B  63      22.337   5.184   0.818  1.00 56.57           O  
ATOM   1693  OE2 GLU B  63      23.788   4.805   2.422  1.00 60.91           O  
ATOM   1694  N   LYS B  64      21.955  10.434   1.317  1.00 46.61           N  
ATOM   1695  CA  LYS B  64      22.805  11.550   0.849  1.00 46.01           C  
ATOM   1696  C   LYS B  64      22.816  12.716   1.831  1.00 44.41           C  
ATOM   1697  O   LYS B  64      23.880  13.248   2.164  1.00 44.85           O  
ATOM   1698  CB  LYS B  64      22.296  12.035  -0.522  1.00 47.08           C  
ATOM   1699  CG  LYS B  64      23.012  13.252  -1.164  1.00 47.97           C  
ATOM   1700  CD  LYS B  64      22.284  13.671  -2.446  1.00 48.89           C  
ATOM   1701  CE  LYS B  64      22.681  15.075  -2.906  1.00 54.81           C  
ATOM   1702  NZ  LYS B  64      21.827  15.524  -4.048  1.00 60.79           N  
ATOM   1703  N   GLU B  65      21.623  13.106   2.278  1.00 43.96           N  
ATOM   1704  CA  GLU B  65      21.481  14.194   3.259  1.00 43.41           C  
ATOM   1705  C   GLU B  65      22.151  13.859   4.600  1.00 42.74           C  
ATOM   1706  O   GLU B  65      22.780  14.737   5.184  1.00 45.21           O  
ATOM   1707  CB  GLU B  65      20.017  14.594   3.461  1.00 42.44           C  
ATOM   1708  CG  GLU B  65      19.860  15.673   4.552  1.00 45.09           C  
ATOM   1709  CD  GLU B  65      18.490  16.266   4.651  1.00 44.71           C  
ATOM   1710  OE1 GLU B  65      17.484  15.571   4.416  1.00 47.35           O  
ATOM   1711  OE2 GLU B  65      18.433  17.436   5.037  1.00 52.80           O  
ATOM   1712  N   LEU B  66      21.975  12.625   5.089  1.00 43.14           N  
ATOM   1713  CA  LEU B  66      22.633  12.172   6.328  1.00 43.19           C  
ATOM   1714  C   LEU B  66      24.152  12.161   6.165  1.00 43.90           C  
ATOM   1715  O   LEU B  66      24.867  12.624   7.048  1.00 42.64           O  
ATOM   1716  CB  LEU B  66      22.107  10.815   6.841  1.00 43.40           C  
ATOM   1717  CG  LEU B  66      20.870  10.801   7.775  1.00 43.10           C  
ATOM   1718  CD1 LEU B  66      21.213  11.443   9.122  1.00 35.98           C  
ATOM   1719  CD2 LEU B  66      19.595  11.439   7.160  1.00 37.96           C  
ATOM   1720  N   HIS B  67      24.635  11.670   5.021  1.00 46.92           N  
ATOM   1721  CA  HIS B  67      26.085  11.675   4.713  1.00 47.25           C  
ATOM   1722  C   HIS B  67      26.658  13.095   4.682  1.00 46.70           C  
ATOM   1723  O   HIS B  67      27.715  13.346   5.274  1.00 47.58           O  
ATOM   1724  CB  HIS B  67      26.371  10.900   3.422  1.00 49.00           C  
ATOM   1725  CG  HIS B  67      26.325   9.417   3.609  1.00 53.16           C  
ATOM   1726  ND1 HIS B  67      27.357   8.589   3.227  1.00 63.43           N  
ATOM   1727  CD2 HIS B  67      25.409   8.621   4.212  1.00 61.68           C  
ATOM   1728  CE1 HIS B  67      27.053   7.340   3.538  1.00 67.92           C  
ATOM   1729  NE2 HIS B  67      25.878   7.334   4.144  1.00 62.69           N  
ATOM   1730  N   THR B  68      25.940  14.016   4.035  1.00 45.86           N  
ATOM   1731  CA  THR B  68      26.312  15.442   4.044  1.00 45.32           C  
ATOM   1732  C   THR B  68      26.220  16.012   5.463  1.00 45.11           C  
ATOM   1733  O   THR B  68      27.102  16.774   5.866  1.00 45.92           O  
ATOM   1734  CB  THR B  68      25.408  16.282   3.126  1.00 44.14           C  
ATOM   1735  OG1 THR B  68      25.416  15.723   1.808  1.00 51.03           O  
ATOM   1736  CG2 THR B  68      25.872  17.742   3.072  1.00 44.55           C  
ATOM   1737  N   PHE B  69      25.164  15.631   6.206  1.00 44.93           N  
ATOM   1738  CA  PHE B  69      24.931  16.106   7.594  1.00 43.56           C  
ATOM   1739  C   PHE B  69      26.105  15.739   8.491  1.00 44.27           C  
ATOM   1740  O   PHE B  69      26.677  16.613   9.137  1.00 43.33           O  
ATOM   1741  CB  PHE B  69      23.603  15.581   8.152  1.00 41.14           C  
ATOM   1742  CG  PHE B  69      23.342  15.964   9.597  1.00 39.10           C  
ATOM   1743  CD1 PHE B  69      22.910  17.240   9.923  1.00 43.97           C  
ATOM   1744  CD2 PHE B  69      23.514  15.031  10.631  1.00 34.25           C  
ATOM   1745  CE1 PHE B  69      22.654  17.595  11.279  1.00 41.38           C  
ATOM   1746  CE2 PHE B  69      23.273  15.365  11.966  1.00 37.43           C  
ATOM   1747  CZ  PHE B  69      22.837  16.642  12.290  1.00 36.47           C  
ATOM   1748  N   TYR B  70      26.478  14.459   8.491  1.00 47.50           N  
ATOM   1749  CA  TYR B  70      27.656  13.984   9.252  1.00 49.47           C  
ATOM   1750  C   TYR B  70      28.967  14.619   8.749  1.00 51.72           C  
ATOM   1751  O   TYR B  70      29.805  15.015   9.564  1.00 51.63           O  
ATOM   1752  CB  TYR B  70      27.752  12.444   9.282  1.00 50.58           C  
ATOM   1753  CG  TYR B  70      26.832  11.808  10.314  1.00 51.02           C  
ATOM   1754  CD1 TYR B  70      27.189  11.807  11.663  1.00 49.12           C  
ATOM   1755  CD2 TYR B  70      25.616  11.206   9.955  1.00 49.96           C  
ATOM   1756  CE1 TYR B  70      26.365  11.239  12.647  1.00 46.38           C  
ATOM   1757  CE2 TYR B  70      24.781  10.622  10.935  1.00 50.57           C  
ATOM   1758  CZ  TYR B  70      25.167  10.654  12.278  1.00 48.21           C  
ATOM   1759  OH  TYR B  70      24.372  10.101  13.252  1.00 55.44           O  
ATOM   1760  N   LYS B  71      29.120  14.739   7.422  1.00 54.29           N  
ATOM   1761  CA  LYS B  71      30.303  15.388   6.809  1.00 54.95           C  
ATOM   1762  C   LYS B  71      30.489  16.833   7.287  1.00 54.87           C  
ATOM   1763  O   LYS B  71      31.553  17.172   7.792  1.00 56.26           O  
ATOM   1764  CB  LYS B  71      30.236  15.374   5.270  1.00 54.36           C  
ATOM   1765  N   GLU B  72      29.437  17.646   7.199  1.00 54.65           N  
ATOM   1766  CA  GLU B  72      29.532  19.070   7.543  1.00 55.73           C  
ATOM   1767  C   GLU B  72      29.148  19.515   8.965  1.00 54.00           C  
ATOM   1768  O   GLU B  72      29.435  20.658   9.312  1.00 54.83           O  
ATOM   1769  CB  GLU B  72      28.739  19.900   6.510  1.00 56.81           C  
ATOM   1770  CG  GLU B  72      27.228  20.037   6.749  1.00 61.34           C  
ATOM   1771  CD  GLU B  72      26.451  20.620   5.563  1.00 62.85           C  
ATOM   1772  OE1 GLU B  72      27.064  21.157   4.596  1.00 65.54           O  
ATOM   1773  OE2 GLU B  72      25.197  20.528   5.622  1.00 75.87           O  
ATOM   1774  N   GLN B  73      28.515  18.663   9.780  1.00 52.91           N  
ATOM   1775  CA  GLN B  73      28.035  19.093  11.129  1.00 51.47           C  
ATOM   1776  C   GLN B  73      28.599  18.412  12.371  1.00 48.42           C  
ATOM   1777  O   GLN B  73      28.264  18.821  13.490  1.00 45.45           O  
ATOM   1778  CB  GLN B  73      26.507  19.106  11.157  1.00 51.66           C  
ATOM   1779  CG  GLN B  73      25.933  19.944  10.008  1.00 56.25           C  
ATOM   1780  CD  GLN B  73      24.494  20.366  10.190  1.00 63.59           C  
ATOM   1781  OE1 GLN B  73      24.031  20.639  11.305  1.00 67.14           O  
ATOM   1782  NE2 GLN B  73      23.780  20.457   9.077  1.00 67.81           N  
ATOM   1783  N   THR B  74      29.476  17.421  12.188  1.00 47.35           N  
ATOM   1784  CA  THR B  74      30.122  16.719  13.301  1.00 47.70           C  
ATOM   1785  C   THR B  74      30.961  17.707  14.092  1.00 50.31           C  
ATOM   1786  O   THR B  74      31.819  18.363  13.498  1.00 51.08           O  
ATOM   1787  CB  THR B  74      31.051  15.593  12.812  1.00 48.21           C  
ATOM   1788  OG1 THR B  74      30.275  14.614  12.109  1.00 47.33           O  
ATOM   1789  CG2 THR B  74      31.762  14.914  13.977  1.00 45.73           C  
ATOM   1790  N   PRO B  75      30.670  17.880  15.406  1.00 53.17           N  
ATOM   1791  CA  PRO B  75      31.444  18.770  16.276  1.00 54.62           C  
ATOM   1792  C   PRO B  75      32.961  18.599  16.227  1.00 56.89           C  
ATOM   1793  O   PRO B  75      33.455  17.472  16.067  1.00 58.60           O  
ATOM   1794  CB  PRO B  75      30.938  18.386  17.663  1.00 54.27           C  
ATOM   1795  CG  PRO B  75      29.537  18.160  17.426  1.00 53.56           C  
ATOM   1796  CD  PRO B  75      29.539  17.320  16.171  1.00 53.18           C  
ATOM   1797  N   GLU B  76      33.662  19.727  16.312  1.00 57.75           N  
ATOM   1798  CA  GLU B  76      35.122  19.793  16.337  1.00 58.96           C  
ATOM   1799  C   GLU B  76      35.663  20.247  17.714  1.00 57.24           C  
ATOM   1800  O   GLU B  76      36.877  20.377  17.869  1.00 58.77           O  
ATOM   1801  CB  GLU B  76      35.618  20.662  15.171  1.00 59.67           C  
ATOM   1802  CG  GLU B  76      35.357  19.993  13.785  1.00 62.18           C  
ATOM   1803  CD  GLU B  76      35.745  20.848  12.573  1.00 61.95           C  
ATOM   1804  OE1 GLU B  76      36.053  22.050  12.727  1.00 72.64           O  
ATOM   1805  OE2 GLU B  76      35.724  20.308  11.447  1.00 69.49           O  
ATOM   1806  N   THR B  77      34.763  20.458  18.691  1.00 55.01           N  
ATOM   1807  CA  THR B  77      35.105  20.846  20.063  0.50 54.36           C  
ATOM   1809  C   THR B  77      34.124  20.196  21.054  1.00 54.13           C  
ATOM   1810  O   THR B  77      32.994  19.891  20.688  1.00 54.31           O  
ATOM   1811  CB  THR B  77      35.055  22.386  20.257  0.50 54.02           C  
ATOM   1813  OG1 THR B  77      33.720  22.868  20.066  0.50 52.18           O  
ATOM   1815  CG2 THR B  77      35.982  23.098  19.282  0.50 52.31           C  
ATOM   1817  N   ILE B  78      34.561  20.010  22.300  1.00 53.18           N  
ATOM   1818  CA  ILE B  78      33.719  19.452  23.377  1.00 51.64           C  
ATOM   1819  C   ILE B  78      32.552  20.388  23.725  1.00 52.54           C  
ATOM   1820  O   ILE B  78      31.497  19.920  24.150  1.00 51.73           O  
ATOM   1821  CB  ILE B  78      34.571  19.109  24.646  1.00 51.45           C  
ATOM   1822  CG1 ILE B  78      35.449  17.890  24.359  1.00 48.87           C  
ATOM   1823  CG2 ILE B  78      33.707  18.845  25.882  1.00 48.34           C  
ATOM   1824  CD1 ILE B  78      36.317  17.471  25.519  1.00 48.95           C  
ATOM   1825  N   ALA B  79      32.746  21.697  23.535  1.00 53.95           N  
ATOM   1826  CA  ALA B  79      31.694  22.693  23.791  1.00 53.65           C  
ATOM   1827  C   ALA B  79      30.557  22.518  22.794  1.00 52.62           C  
ATOM   1828  O   ALA B  79      29.409  22.398  23.211  1.00 51.75           O  
ATOM   1829  CB  ALA B  79      32.245  24.108  23.725  1.00 53.43           C  
ATOM   1830  N   GLN B  80      30.893  22.444  21.496  1.00 52.56           N  
ATOM   1831  CA  GLN B  80      29.880  22.284  20.439  1.00 53.53           C  
ATOM   1832  C   GLN B  80      29.272  20.873  20.417  1.00 51.91           C  
ATOM   1833  O   GLN B  80      28.175  20.706  19.891  1.00 53.77           O  
ATOM   1834  CB  GLN B  80      30.345  22.801  19.063  1.00 53.49           C  
ATOM   1835  CG  GLN B  80      31.188  21.902  18.194  1.00 57.70           C  
ATOM   1836  CD  GLN B  80      31.896  22.675  17.055  1.00 58.02           C  
ATOM   1837  OE1 GLN B  80      32.762  23.511  17.304  1.00 70.16           O  
ATOM   1838  NE2 GLN B  80      31.545  22.364  15.808  1.00 65.22           N  
HETATM 1839  N   MSE B  81      29.967  19.883  20.992  1.00 49.00           N  
HETATM 1840  CA  MSE B  81      29.389  18.553  21.217  1.00 46.90           C  
HETATM 1841  C   MSE B  81      28.261  18.659  22.228  1.00 45.37           C  
HETATM 1842  O   MSE B  81      27.191  18.124  22.003  1.00 43.91           O  
HETATM 1843  CB  MSE B  81      30.401  17.558  21.779  1.00 46.61           C  
HETATM 1844  CG  MSE B  81      31.377  17.000  20.798  1.00 45.48           C  
HETATM 1845 SE   MSE B  81      32.595  15.865  21.786  0.75 46.78          SE  
HETATM 1846  CE  MSE B  81      33.682  15.351  20.227  1.00 39.17           C  
ATOM   1847  N   GLN B  82      28.530  19.340  23.340  1.00 46.20           N  
ATOM   1848  CA  GLN B  82      27.533  19.534  24.402  1.00 47.56           C  
ATOM   1849  C   GLN B  82      26.353  20.384  23.942  1.00 46.39           C  
ATOM   1850  O   GLN B  82      25.208  20.049  24.232  1.00 46.15           O  
ATOM   1851  CB  GLN B  82      28.177  20.099  25.673  1.00 47.43           C  
ATOM   1852  CG  GLN B  82      29.137  19.099  26.323  1.00 50.28           C  
ATOM   1853  CD  GLN B  82      29.707  19.583  27.629  1.00 49.97           C  
ATOM   1854  OE1 GLN B  82      28.971  20.042  28.494  1.00 58.16           O  
ATOM   1855  NE2 GLN B  82      31.012  19.438  27.802  1.00 56.13           N  
ATOM   1856  N   LYS B  83      26.648  21.460  23.214  1.00 46.58           N  
ATOM   1857  CA  LYS B  83      25.624  22.344  22.660  1.00 46.60           C  
ATOM   1858  C   LYS B  83      24.735  21.600  21.662  1.00 43.95           C  
ATOM   1859  O   LYS B  83      23.514  21.709  21.742  1.00 42.68           O  
ATOM   1860  CB  LYS B  83      26.243  23.610  22.014  1.00 46.76           C  
ATOM   1861  CG  LYS B  83      26.885  24.575  23.032  1.00 52.15           C  
ATOM   1862  CD  LYS B  83      27.121  26.014  22.499  1.00 51.21           C  
ATOM   1863  CE  LYS B  83      28.117  26.111  21.356  1.00 54.55           C  
ATOM   1864  NZ  LYS B  83      28.449  27.548  21.052  1.00 49.67           N  
ATOM   1865  N   THR B  84      25.355  20.835  20.754  1.00 40.25           N  
ATOM   1866  CA  THR B  84      24.633  20.069  19.738  1.00 39.01           C  
ATOM   1867  C   THR B  84      23.720  18.981  20.330  1.00 39.45           C  
ATOM   1868  O   THR B  84      22.566  18.847  19.924  1.00 40.70           O  
ATOM   1869  CB  THR B  84      25.623  19.402  18.754  1.00 39.98           C  
ATOM   1870  OG1 THR B  84      26.335  20.426  18.046  1.00 42.32           O  
ATOM   1871  CG2 THR B  84      24.909  18.492  17.755  1.00 37.70           C  
HETATM 1872  N   MSE B  85      24.253  18.219  21.279  1.00 38.68           N  
HETATM 1873  CA  MSE B  85      23.528  17.135  21.939  1.00 39.62           C  
HETATM 1874  C   MSE B  85      22.293  17.663  22.694  1.00 38.40           C  
HETATM 1875  O   MSE B  85      21.231  17.026  22.638  1.00 35.80           O  
HETATM 1876  CB  MSE B  85      24.463  16.395  22.884  1.00 39.07           C  
HETATM 1877  CG  MSE B  85      24.059  14.999  23.233  1.00 43.17           C  
HETATM 1878 SE   MSE B  85      25.368  14.225  24.442  0.75 49.26          SE  
HETATM 1879  CE  MSE B  85      26.988  14.303  23.385  1.00 59.03           C  
ATOM   1880  N   ILE B  86      22.420  18.822  23.365  1.00 39.41           N  
ATOM   1881  CA  ILE B  86      21.266  19.454  24.075  1.00 38.99           C  
ATOM   1882  C   ILE B  86      20.219  19.963  23.088  1.00 38.85           C  
ATOM   1883  O   ILE B  86      19.027  19.768  23.298  1.00 40.77           O  
ATOM   1884  CB  ILE B  86      21.690  20.619  25.020  1.00 40.47           C  
ATOM   1885  CG1 ILE B  86      22.482  20.094  26.226  1.00 43.58           C  
ATOM   1886  CG2 ILE B  86      20.464  21.376  25.587  1.00 39.75           C  
ATOM   1887  CD1 ILE B  86      21.678  19.198  27.196  1.00 46.69           C  
ATOM   1888  N   GLN B  87      20.669  20.629  22.030  1.00 39.33           N  
ATOM   1889  CA  GLN B  87      19.777  21.134  20.983  1.00 39.40           C  
ATOM   1890  C   GLN B  87      19.034  20.024  20.257  1.00 37.49           C  
ATOM   1891  O   GLN B  87      17.881  20.205  19.885  1.00 36.19           O  
ATOM   1892  CB  GLN B  87      20.549  21.963  19.965  1.00 41.05           C  
ATOM   1893  CG  GLN B  87      20.988  23.326  20.489  1.00 46.45           C  
ATOM   1894  CD  GLN B  87      22.072  23.959  19.641  1.00 56.45           C  
ATOM   1895  OE1 GLN B  87      22.337  23.539  18.500  1.00 60.20           O  
ATOM   1896  NE2 GLN B  87      22.724  24.972  20.203  1.00 62.44           N  
ATOM   1897  N   GLY B  88      19.717  18.909  20.015  1.00 37.80           N  
ATOM   1898  CA  GLY B  88      19.117  17.741  19.376  1.00 36.90           C  
ATOM   1899  C   GLY B  88      18.051  17.113  20.259  1.00 35.30           C  
ATOM   1900  O   GLY B  88      16.987  16.714  19.761  1.00 34.09           O  
ATOM   1901  N   TYR B  89      18.345  17.011  21.556  1.00 35.66           N  
ATOM   1902  CA  TYR B  89      17.382  16.510  22.518  1.00 35.87           C  
ATOM   1903  C   TYR B  89      16.145  17.414  22.544  1.00 36.29           C  
ATOM   1904  O   TYR B  89      15.020  16.903  22.512  1.00 38.63           O  
ATOM   1905  CB  TYR B  89      17.962  16.335  23.942  1.00 35.18           C  
ATOM   1906  CG  TYR B  89      16.862  15.962  24.903  1.00 35.23           C  
ATOM   1907  CD1 TYR B  89      16.378  14.660  24.957  1.00 32.47           C  
ATOM   1908  CD2 TYR B  89      16.217  16.943  25.678  1.00 37.44           C  
ATOM   1909  CE1 TYR B  89      15.318  14.317  25.792  1.00 36.26           C  
ATOM   1910  CE2 TYR B  89      15.142  16.615  26.517  1.00 34.32           C  
ATOM   1911  CZ  TYR B  89      14.698  15.300  26.568  1.00 38.46           C  
ATOM   1912  OH  TYR B  89      13.661  14.954  27.404  1.00 41.58           O  
ATOM   1913  N   ASP B  90      16.350  18.729  22.632  1.00 36.16           N  
ATOM   1914  CA  ASP B  90      15.227  19.688  22.637  1.00 36.66           C  
ATOM   1915  C   ASP B  90      14.365  19.536  21.395  1.00 35.40           C  
ATOM   1916  O   ASP B  90      13.162  19.481  21.516  1.00 32.32           O  
ATOM   1917  CB  ASP B  90      15.697  21.143  22.717  1.00 38.39           C  
ATOM   1918  CG  ASP B  90      16.268  21.515  24.063  1.00 45.92           C  
ATOM   1919  OD1 ASP B  90      16.490  20.636  24.946  1.00 49.68           O  
ATOM   1920  OD2 ASP B  90      16.516  22.730  24.227  1.00 58.31           O  
ATOM   1921  N   LEU B  91      14.980  19.406  20.214  1.00 34.20           N  
ATOM   1922  CA  LEU B  91      14.208  19.270  18.976  1.00 35.45           C  
ATOM   1923  C   LEU B  91      13.440  17.934  18.947  1.00 36.67           C  
ATOM   1924  O   LEU B  91      12.271  17.887  18.556  1.00 38.82           O  
ATOM   1925  CB  LEU B  91      15.117  19.432  17.739  1.00 36.68           C  
ATOM   1926  CG  LEU B  91      14.486  19.562  16.344  1.00 36.17           C  
ATOM   1927  CD1 LEU B  91      13.495  20.717  16.265  1.00 39.36           C  
ATOM   1928  CD2 LEU B  91      15.581  19.687  15.243  1.00 35.92           C  
ATOM   1929  N   LEU B  92      14.095  16.863  19.390  1.00 36.40           N  
ATOM   1930  CA  LEU B  92      13.480  15.545  19.436  1.00 35.29           C  
ATOM   1931  C   LEU B  92      12.328  15.487  20.428  1.00 34.39           C  
ATOM   1932  O   LEU B  92      11.274  14.950  20.103  1.00 35.01           O  
ATOM   1933  CB  LEU B  92      14.523  14.475  19.792  1.00 35.38           C  
ATOM   1934  CG  LEU B  92      14.113  13.004  19.744  1.00 31.29           C  
ATOM   1935  CD1 LEU B  92      13.603  12.650  18.373  1.00 31.96           C  
ATOM   1936  CD2 LEU B  92      15.298  12.147  20.098  1.00 34.01           C  
ATOM   1937  N   SER B  93      12.525  16.035  21.625  1.00 35.54           N  
ATOM   1938  CA  SER B  93      11.459  16.014  22.654  1.00 37.64           C  
ATOM   1939  C   SER B  93      10.281  16.887  22.253  1.00 36.35           C  
ATOM   1940  O   SER B  93       9.143  16.426  22.276  1.00 38.84           O  
ATOM   1941  CB  SER B  93      11.983  16.388  24.043  1.00 35.37           C  
ATOM   1942  OG  SER B  93      12.662  17.614  24.010  1.00 47.07           O  
ATOM   1943  N   LYS B  94      10.555  18.123  21.837  1.00 36.54           N  
ATOM   1944  CA  LYS B  94       9.489  19.049  21.396  1.00 35.09           C  
ATOM   1945  C   LYS B  94       8.646  18.426  20.294  1.00 33.57           C  
ATOM   1946  O   LYS B  94       7.423  18.538  20.302  1.00 29.04           O  
ATOM   1947  CB  LYS B  94      10.045  20.417  20.969  1.00 35.43           C  
ATOM   1948  CG  LYS B  94      10.661  21.246  22.109  1.00 37.25           C  
ATOM   1949  CD  LYS B  94       9.661  21.646  23.237  1.00 44.33           C  
ATOM   1950  CE  LYS B  94      10.334  22.538  24.312  1.00 48.01           C  
ATOM   1951  NZ  LYS B  94      10.904  23.874  23.817  1.00 47.02           N  
ATOM   1952  N   THR B  95       9.313  17.716  19.383  1.00 30.79           N  
ATOM   1953  CA  THR B  95       8.643  17.009  18.324  1.00 28.24           C  
ATOM   1954  C   THR B  95       7.775  15.889  18.867  1.00 28.96           C  
ATOM   1955  O   THR B  95       6.587  15.846  18.563  1.00 31.70           O  
ATOM   1956  CB  THR B  95       9.671  16.379  17.322  1.00 28.74           C  
ATOM   1957  OG1 THR B  95      10.391  17.428  16.650  1.00 28.93           O  
ATOM   1958  CG2 THR B  95       8.953  15.504  16.318  1.00 18.71           C  
ATOM   1959  N   PHE B  96       8.361  14.983  19.654  1.00 30.17           N  
ATOM   1960  CA  PHE B  96       7.591  13.841  20.194  1.00 31.28           C  
ATOM   1961  C   PHE B  96       6.440  14.225  21.119  1.00 32.72           C  
ATOM   1962  O   PHE B  96       5.420  13.545  21.132  1.00 34.07           O  
ATOM   1963  CB  PHE B  96       8.484  12.734  20.778  1.00 32.08           C  
ATOM   1964  CG  PHE B  96       8.871  11.704  19.749  1.00 32.82           C  
ATOM   1965  CD1 PHE B  96      10.000  11.875  18.954  1.00 31.40           C  
ATOM   1966  CD2 PHE B  96       8.028  10.620  19.509  1.00 28.95           C  
ATOM   1967  CE1 PHE B  96      10.330  10.918  17.957  1.00 34.48           C  
ATOM   1968  CE2 PHE B  96       8.316   9.689  18.535  1.00 31.02           C  
ATOM   1969  CZ  PHE B  96       9.484   9.821  17.751  1.00 32.51           C  
ATOM   1970  N   LEU B  97       6.610  15.320  21.849  1.00 34.26           N  
ATOM   1971  CA  LEU B  97       5.554  15.873  22.717  1.00 36.70           C  
ATOM   1972  C   LEU B  97       4.430  16.553  21.926  1.00 39.27           C  
ATOM   1973  O   LEU B  97       3.361  16.824  22.500  1.00 43.05           O  
ATOM   1974  CB  LEU B  97       6.147  16.877  23.722  1.00 36.13           C  
ATOM   1975  CG  LEU B  97       7.033  16.369  24.849  1.00 34.18           C  
ATOM   1976  CD1 LEU B  97       7.578  17.555  25.628  1.00 39.08           C  
ATOM   1977  CD2 LEU B  97       6.249  15.420  25.761  1.00 37.25           C  
ATOM   1978  N   SER B  98       4.688  16.878  20.652  1.00 40.71           N  
ATOM   1979  CA  SER B  98       3.686  17.464  19.760  1.00 39.84           C  
ATOM   1980  C   SER B  98       2.777  16.390  19.148  1.00 40.91           C  
ATOM   1981  O   SER B  98       1.700  16.728  18.648  1.00 40.90           O  
ATOM   1982  CB  SER B  98       4.344  18.294  18.633  1.00 41.46           C  
ATOM   1983  OG  SER B  98       4.931  17.495  17.598  1.00 35.07           O  
ATOM   1984  N   TYR B  99       3.197  15.119  19.180  1.00 41.05           N  
ATOM   1985  CA  TYR B  99       2.442  14.047  18.545  1.00 40.95           C  
ATOM   1986  C   TYR B  99       1.248  13.522  19.348  1.00 44.24           C  
ATOM   1987  O   TYR B  99       1.342  13.284  20.554  1.00 45.11           O  
ATOM   1988  CB  TYR B  99       3.322  12.838  18.204  1.00 39.20           C  
ATOM   1989  CG  TYR B  99       4.438  13.041  17.185  1.00 37.13           C  
ATOM   1990  CD1 TYR B  99       4.234  13.765  15.993  1.00 32.73           C  
ATOM   1991  CD2 TYR B  99       5.674  12.414  17.364  1.00 33.55           C  
ATOM   1992  CE1 TYR B  99       5.260  13.910  15.046  1.00 39.34           C  
ATOM   1993  CE2 TYR B  99       6.705  12.547  16.427  1.00 35.50           C  
ATOM   1994  CZ  TYR B  99       6.493  13.289  15.267  1.00 36.95           C  
ATOM   1995  OH  TYR B  99       7.505  13.411  14.348  1.00 41.35           O  
ATOM   1996  N   SER B 100       0.136  13.320  18.636  1.00 46.02           N  
ATOM   1997  CA  SER B 100      -1.060  12.660  19.156  1.00 45.87           C  
ATOM   1998  C   SER B 100      -0.765  11.156  19.188  1.00 45.92           C  
ATOM   1999  O   SER B 100       0.226  10.708  18.600  1.00 45.38           O  
ATOM   2000  CB  SER B 100      -2.246  12.898  18.204  1.00 46.09           C  
ATOM   2001  OG  SER B 100      -2.045  12.252  16.937  1.00 43.03           O  
ATOM   2002  N   ASN B 101      -1.634  10.374  19.835  1.00 47.08           N  
ATOM   2003  CA  ASN B 101      -1.497   8.891  19.825  1.00 47.90           C  
ATOM   2004  C   ASN B 101      -1.505   8.310  18.412  1.00 46.46           C  
ATOM   2005  O   ASN B 101      -0.789   7.338  18.132  1.00 47.40           O  
ATOM   2006  CB  ASN B 101      -2.582   8.179  20.671  1.00 49.37           C  
ATOM   2007  CG  ASN B 101      -2.173   7.977  22.136  1.00 55.29           C  
ATOM   2008  OD1 ASN B 101      -2.431   6.911  22.711  1.00 66.32           O  
ATOM   2009  ND2 ASN B 101      -1.518   8.971  22.730  1.00 57.93           N  
ATOM   2010  N   GLU B 102      -2.297   8.936  17.541  1.00 45.19           N  
ATOM   2011  CA  GLU B 102      -2.453   8.542  16.137  1.00 45.19           C  
ATOM   2012  C   GLU B 102      -1.139   8.792  15.423  1.00 42.73           C  
ATOM   2013  O   GLU B 102      -0.679   7.952  14.645  1.00 43.78           O  
ATOM   2014  CB  GLU B 102      -3.618   9.296  15.458  1.00 46.82           C  
ATOM   2015  CG  GLU B 102      -5.036   8.919  15.958  1.00 49.36           C  
ATOM   2016  CD  GLU B 102      -5.321   9.288  17.434  1.00 55.92           C  
ATOM   2017  OE1 GLU B 102      -4.823  10.338  17.925  1.00 46.58           O  
ATOM   2018  OE2 GLU B 102      -6.031   8.505  18.111  1.00 62.65           O  
ATOM   2019  N   GLN B 103      -0.532   9.940  15.723  1.00 41.31           N  
ATOM   2020  CA  GLN B 103       0.793  10.294  15.203  1.00 40.63           C  
ATOM   2021  C   GLN B 103       1.890   9.375  15.743  1.00 40.69           C  
ATOM   2022  O   GLN B 103       2.793   8.986  14.997  1.00 42.13           O  
ATOM   2023  CB  GLN B 103       1.095  11.762  15.473  1.00 40.53           C  
ATOM   2024  CG  GLN B 103       0.248  12.654  14.605  1.00 39.76           C  
ATOM   2025  CD  GLN B 103       0.457  14.106  14.847  1.00 34.30           C  
ATOM   2026  OE1 GLN B 103       0.380  14.580  15.969  1.00 36.95           O  
ATOM   2027  NE2 GLN B 103       0.693  14.838  13.785  1.00 42.93           N  
ATOM   2028  N   LEU B 104       1.797   9.010  17.025  1.00 39.68           N  
ATOM   2029  CA  LEU B 104       2.724   8.035  17.618  1.00 38.78           C  
ATOM   2030  C   LEU B 104       2.634   6.652  16.977  1.00 38.30           C  
ATOM   2031  O   LEU B 104       3.624   5.934  16.973  1.00 38.60           O  
ATOM   2032  CB  LEU B 104       2.514   7.904  19.129  1.00 37.99           C  
ATOM   2033  CG  LEU B 104       2.917   9.142  19.916  1.00 36.62           C  
ATOM   2034  CD1 LEU B 104       2.419   9.027  21.340  1.00 32.72           C  
ATOM   2035  CD2 LEU B 104       4.428   9.356  19.850  1.00 24.32           C  
ATOM   2036  N   ALA B 105       1.453   6.290  16.468  1.00 38.63           N  
ATOM   2037  CA  ALA B 105       1.225   5.009  15.796  1.00 39.04           C  
ATOM   2038  C   ALA B 105       1.572   5.039  14.311  1.00 40.80           C  
ATOM   2039  O   ALA B 105       1.680   3.981  13.706  1.00 42.62           O  
ATOM   2040  CB  ALA B 105      -0.236   4.568  15.976  1.00 37.14           C  
ATOM   2041  N   GLU B 106       1.722   6.236  13.727  1.00 42.17           N  
ATOM   2042  CA  GLU B 106       1.985   6.404  12.296  1.00 42.33           C  
ATOM   2043  C   GLU B 106       3.280   5.734  11.893  1.00 41.60           C  
ATOM   2044  O   GLU B 106       4.271   5.853  12.586  1.00 42.82           O  
ATOM   2045  CB  GLU B 106       2.052   7.883  11.907  1.00 41.83           C  
ATOM   2046  CG  GLU B 106       2.161   8.152  10.383  1.00 48.64           C  
ATOM   2047  CD  GLU B 106       0.864   7.954   9.619  1.00 49.83           C  
ATOM   2048  OE1 GLU B 106      -0.160   7.531  10.207  1.00 57.24           O  
ATOM   2049  OE2 GLU B 106       0.867   8.253   8.408  1.00 51.78           O  
HETATM 2050  N   MSE B 107       3.254   5.084  10.739  1.00 42.86           N  
HETATM 2051  CA  MSE B 107       4.385   4.324  10.218  1.00 43.19           C  
HETATM 2052  C   MSE B 107       5.219   5.196   9.309  1.00 44.15           C  
HETATM 2053  O   MSE B 107       4.667   5.841   8.408  1.00 45.57           O  
HETATM 2054  CB  MSE B 107       3.876   3.125   9.426  1.00 43.67           C  
HETATM 2055  CG  MSE B 107       3.022   2.220  10.245  1.00 44.59           C  
HETATM 2056 SE   MSE B 107       4.055   1.276  11.560  0.75 56.42          SE  
HETATM 2057  CE  MSE B 107       2.708   1.159  12.980  1.00 48.89           C  
ATOM   2058  N   LYS B 108       6.533   5.217   9.552  1.00 43.33           N  
ATOM   2059  CA  LYS B 108       7.487   5.969   8.742  1.00 42.84           C  
ATOM   2060  C   LYS B 108       8.575   5.002   8.307  1.00 44.25           C  
ATOM   2061  O   LYS B 108       8.997   4.142   9.097  1.00 43.03           O  
ATOM   2062  CB  LYS B 108       8.112   7.137   9.515  1.00 41.65           C  
ATOM   2063  CG  LYS B 108       7.145   8.062  10.282  1.00 41.15           C  
ATOM   2064  CD  LYS B 108       6.016   8.704   9.464  1.00 43.06           C  
ATOM   2065  CE  LYS B 108       6.454   9.680   8.415  1.00 46.00           C  
ATOM   2066  NZ  LYS B 108       5.238  10.196   7.728  1.00 42.93           N  
ATOM   2067  N   THR B 109       9.023   5.155   7.059  1.00 45.09           N  
ATOM   2068  CA  THR B 109      10.076   4.316   6.485  1.00 47.64           C  
ATOM   2069  C   THR B 109      11.402   5.085   6.496  1.00 47.38           C  
ATOM   2070  O   THR B 109      11.487   6.217   5.966  1.00 47.59           O  
ATOM   2071  CB  THR B 109       9.739   3.921   5.034  1.00 48.53           C  
ATOM   2072  OG1 THR B 109       8.451   3.308   5.015  1.00 52.01           O  
ATOM   2073  CG2 THR B 109      10.770   2.945   4.467  1.00 46.89           C  
ATOM   2074  N   ALA B 110      12.419   4.478   7.122  1.00 45.80           N  
ATOM   2075  CA  ALA B 110      13.783   5.030   7.117  1.00 45.28           C  
ATOM   2076  C   ALA B 110      14.303   4.878   5.692  1.00 43.42           C  
ATOM   2077  O   ALA B 110      13.819   4.018   4.952  1.00 43.08           O  
ATOM   2078  CB  ALA B 110      14.686   4.292   8.104  1.00 44.27           C  
ATOM   2079  N   TYR B 111      15.273   5.707   5.310  1.00 44.27           N  
ATOM   2080  CA  TYR B 111      15.810   5.700   3.928  1.00 45.23           C  
ATOM   2081  C   TYR B 111      16.227   4.315   3.423  1.00 46.41           C  
ATOM   2082  O   TYR B 111      16.065   4.018   2.242  1.00 48.52           O  
ATOM   2083  CB  TYR B 111      16.938   6.732   3.735  1.00 44.96           C  
ATOM   2084  CG  TYR B 111      18.239   6.493   4.482  1.00 44.18           C  
ATOM   2085  CD1 TYR B 111      19.177   5.545   4.025  1.00 39.87           C  
ATOM   2086  CD2 TYR B 111      18.570   7.253   5.608  1.00 40.74           C  
ATOM   2087  CE1 TYR B 111      20.391   5.340   4.686  1.00 43.27           C  
ATOM   2088  CE2 TYR B 111      19.788   7.059   6.289  1.00 45.17           C  
ATOM   2089  CZ  TYR B 111      20.700   6.101   5.820  1.00 44.92           C  
ATOM   2090  OH  TYR B 111      21.887   5.888   6.492  1.00 40.40           O  
ATOM   2091  N   TRP B 112      16.722   3.481   4.346  1.00 47.83           N  
ATOM   2092  CA  TRP B 112      17.113   2.082   4.090  1.00 47.83           C  
ATOM   2093  C   TRP B 112      15.937   1.074   4.016  1.00 49.28           C  
ATOM   2094  O   TRP B 112      16.163  -0.139   4.060  1.00 49.78           O  
ATOM   2095  CB  TRP B 112      18.192   1.618   5.095  1.00 47.07           C  
ATOM   2096  CG  TRP B 112      17.777   1.543   6.528  1.00 46.43           C  
ATOM   2097  CD1 TRP B 112      17.212   0.481   7.157  1.00 46.55           C  
ATOM   2098  CD2 TRP B 112      17.923   2.570   7.522  1.00 46.56           C  
ATOM   2099  NE1 TRP B 112      16.990   0.773   8.483  1.00 45.18           N  
ATOM   2100  CE2 TRP B 112      17.422   2.051   8.735  1.00 48.47           C  
ATOM   2101  CE3 TRP B 112      18.429   3.877   7.502  1.00 43.39           C  
ATOM   2102  CZ2 TRP B 112      17.400   2.812   9.929  1.00 47.66           C  
ATOM   2103  CZ3 TRP B 112      18.414   4.625   8.667  1.00 45.60           C  
ATOM   2104  CH2 TRP B 112      17.902   4.091   9.870  1.00 45.32           C  
ATOM   2105  N   GLY B 113      14.695   1.560   3.950  1.00 49.57           N  
ATOM   2106  CA  GLY B 113      13.533   0.713   3.705  1.00 50.60           C  
ATOM   2107  C   GLY B 113      12.877  -0.065   4.822  1.00 50.35           C  
ATOM   2108  O   GLY B 113      11.903  -0.766   4.563  1.00 50.95           O  
ATOM   2109  N   ILE B 114      13.407   0.007   6.041  1.00 50.73           N  
ATOM   2110  CA  ILE B 114      12.782  -0.660   7.195  1.00 50.04           C  
ATOM   2111  C   ILE B 114      11.811   0.379   7.756  1.00 49.43           C  
ATOM   2112  O   ILE B 114      12.126   1.579   7.754  1.00 51.41           O  
ATOM   2113  CB  ILE B 114      13.831  -1.154   8.234  1.00 49.83           C  
ATOM   2114  CG1 ILE B 114      14.823  -2.151   7.584  1.00 49.24           C  
ATOM   2115  CG2 ILE B 114      13.152  -1.787   9.444  1.00 48.67           C  
ATOM   2116  CD1 ILE B 114      14.212  -3.388   6.941  1.00 45.44           C  
ATOM   2117  N   SER B 115      10.628  -0.074   8.184  1.00 48.85           N  
ATOM   2118  CA  SER B 115       9.579   0.801   8.731  1.00 46.83           C  
ATOM   2119  C   SER B 115       9.313   0.533  10.208  1.00 46.83           C  
ATOM   2120  O   SER B 115       9.462  -0.602  10.686  1.00 47.02           O  
ATOM   2121  CB  SER B 115       8.292   0.684   7.926  1.00 45.70           C  
ATOM   2122  OG  SER B 115       8.480   1.238   6.641  1.00 47.94           O  
ATOM   2123  N   TYR B 116       8.951   1.612  10.915  1.00 47.06           N  
ATOM   2124  CA  TYR B 116       8.667   1.624  12.363  1.00 47.05           C  
ATOM   2125  C   TYR B 116       7.525   2.600  12.607  1.00 44.39           C  
ATOM   2126  O   TYR B 116       7.296   3.504  11.793  1.00 43.11           O  
ATOM   2127  CB  TYR B 116       9.874   2.170  13.175  1.00 49.60           C  
ATOM   2128  CG  TYR B 116      11.243   1.691  12.734  1.00 52.36           C  
ATOM   2129  CD1 TYR B 116      11.870   2.255  11.604  1.00 55.12           C  
ATOM   2130  CD2 TYR B 116      11.928   0.695  13.445  1.00 52.61           C  
ATOM   2131  CE1 TYR B 116      13.133   1.812  11.167  1.00 57.73           C  
ATOM   2132  CE2 TYR B 116      13.203   0.248  13.030  1.00 56.41           C  
ATOM   2133  CZ  TYR B 116      13.800   0.809  11.884  1.00 58.59           C  
ATOM   2134  OH  TYR B 116      15.058   0.388  11.461  1.00 61.58           O  
ATOM   2135  N   SER B 117       6.828   2.429  13.732  1.00 41.75           N  
ATOM   2136  CA  SER B 117       5.869   3.433  14.179  1.00 40.46           C  
ATOM   2137  C   SER B 117       6.725   4.569  14.745  1.00 40.23           C  
ATOM   2138  O   SER B 117       7.904   4.371  15.051  1.00 41.86           O  
ATOM   2139  CB  SER B 117       4.905   2.900  15.249  1.00 40.29           C  
ATOM   2140  OG  SER B 117       5.531   2.642  16.488  1.00 39.55           O  
ATOM   2141  N   ARG B 118       6.165   5.757  14.904  1.00 39.86           N  
ATOM   2142  CA  ARG B 118       6.951   6.846  15.484  1.00 38.22           C  
ATOM   2143  C   ARG B 118       7.405   6.511  16.901  1.00 36.70           C  
ATOM   2144  O   ARG B 118       8.552   6.802  17.239  1.00 38.05           O  
ATOM   2145  CB  ARG B 118       6.227   8.175  15.442  1.00 38.68           C  
ATOM   2146  CG  ARG B 118       6.006   8.677  14.034  1.00 41.09           C  
ATOM   2147  CD  ARG B 118       6.212  10.153  14.013  1.00 45.19           C  
ATOM   2148  NE  ARG B 118       5.940  10.742  12.714  1.00 45.22           N  
ATOM   2149  CZ  ARG B 118       4.800  11.323  12.349  1.00 43.23           C  
ATOM   2150  NH1 ARG B 118       3.745  11.382  13.155  1.00 43.74           N  
ATOM   2151  NH2 ARG B 118       4.720  11.834  11.129  1.00 46.19           N  
ATOM   2152  N   PHE B 119       6.540   5.874  17.699  1.00 36.42           N  
ATOM   2153  CA  PHE B 119       6.915   5.461  19.056  1.00 36.79           C  
ATOM   2154  C   PHE B 119       8.027   4.407  19.042  1.00 36.34           C  
ATOM   2155  O   PHE B 119       8.979   4.515  19.804  1.00 35.44           O  
ATOM   2156  CB  PHE B 119       5.744   4.946  19.877  1.00 36.51           C  
ATOM   2157  CG  PHE B 119       6.105   4.714  21.314  1.00 36.48           C  
ATOM   2158  CD1 PHE B 119       6.126   5.784  22.217  1.00 37.81           C  
ATOM   2159  CD2 PHE B 119       6.462   3.438  21.770  1.00 36.17           C  
ATOM   2160  CE1 PHE B 119       6.482   5.587  23.557  1.00 32.89           C  
ATOM   2161  CE2 PHE B 119       6.819   3.225  23.108  1.00 33.50           C  
ATOM   2162  CZ  PHE B 119       6.824   4.304  24.013  1.00 36.75           C  
ATOM   2163  N   GLU B 120       7.885   3.396  18.190  1.00 38.37           N  
ATOM   2164  CA  GLU B 120       8.932   2.378  18.004  1.00 40.90           C  
ATOM   2165  C   GLU B 120      10.271   3.009  17.649  1.00 39.42           C  
ATOM   2166  O   GLU B 120      11.296   2.607  18.188  1.00 41.70           O  
ATOM   2167  CB  GLU B 120       8.541   1.365  16.917  1.00 41.29           C  
ATOM   2168  CG  GLU B 120       7.491   0.360  17.374  1.00 46.21           C  
ATOM   2169  CD  GLU B 120       6.828  -0.402  16.243  1.00 45.26           C  
ATOM   2170  OE1 GLU B 120       7.312  -0.364  15.088  1.00 56.08           O  
ATOM   2171  OE2 GLU B 120       5.792  -1.043  16.524  1.00 60.27           O  
ATOM   2172  N   TRP B 121      10.254   3.996  16.751  1.00 39.06           N  
ATOM   2173  CA  TRP B 121      11.483   4.685  16.354  1.00 38.85           C  
ATOM   2174  C   TRP B 121      12.095   5.478  17.540  1.00 35.28           C  
ATOM   2175  O   TRP B 121      13.314   5.515  17.682  1.00 32.76           O  
ATOM   2176  CB  TRP B 121      11.284   5.537  15.078  1.00 42.77           C  
ATOM   2177  CG  TRP B 121      12.558   6.143  14.640  1.00 46.10           C  
ATOM   2178  CD1 TRP B 121      12.927   7.442  14.790  1.00 49.07           C  
ATOM   2179  CD2 TRP B 121      13.696   5.458  14.091  1.00 50.05           C  
ATOM   2180  NE1 TRP B 121      14.202   7.633  14.324  1.00 49.53           N  
ATOM   2181  CE2 TRP B 121      14.710   6.435  13.895  1.00 49.42           C  
ATOM   2182  CE3 TRP B 121      13.950   4.126  13.717  1.00 49.07           C  
ATOM   2183  CZ2 TRP B 121      15.970   6.126  13.347  1.00 46.50           C  
ATOM   2184  CZ3 TRP B 121      15.221   3.810  13.167  1.00 49.51           C  
ATOM   2185  CH2 TRP B 121      16.207   4.814  12.990  1.00 49.17           C  
ATOM   2186  N   LEU B 122      11.265   6.060  18.407  1.00 30.67           N  
ATOM   2187  CA  LEU B 122      11.777   6.744  19.590  1.00 29.72           C  
ATOM   2188  C   LEU B 122      12.549   5.758  20.472  1.00 29.99           C  
ATOM   2189  O   LEU B 122      13.601   6.112  21.006  1.00 33.37           O  
ATOM   2190  CB  LEU B 122      10.661   7.413  20.414  1.00 30.01           C  
ATOM   2191  CG  LEU B 122      11.030   8.169  21.701  1.00 30.16           C  
ATOM   2192  CD1 LEU B 122      12.015   9.317  21.471  1.00 29.81           C  
ATOM   2193  CD2 LEU B 122       9.718   8.663  22.397  1.00 23.90           C  
ATOM   2194  N   LEU B 123      12.026   4.540  20.618  1.00 30.11           N  
ATOM   2195  CA  LEU B 123      12.692   3.491  21.402  1.00 31.40           C  
ATOM   2196  C   LEU B 123      14.008   3.045  20.733  1.00 32.06           C  
ATOM   2197  O   LEU B 123      14.950   2.670  21.421  1.00 32.45           O  
ATOM   2198  CB  LEU B 123      11.753   2.303  21.639  1.00 31.94           C  
ATOM   2199  CG  LEU B 123      10.446   2.607  22.396  1.00 31.88           C  
ATOM   2200  CD1 LEU B 123       9.687   1.299  22.623  1.00 31.65           C  
ATOM   2201  CD2 LEU B 123      10.688   3.370  23.715  1.00 31.91           C  
ATOM   2202  N   GLU B 124      14.047   3.084  19.403  1.00 32.67           N  
ATOM   2203  CA  GLU B 124      15.303   2.821  18.640  1.00 35.09           C  
ATOM   2204  C   GLU B 124      16.330   3.920  18.879  1.00 34.63           C  
ATOM   2205  O   GLU B 124      17.500   3.606  18.887  1.00 34.02           O  
ATOM   2206  CB  GLU B 124      15.057   2.669  17.141  1.00 32.28           C  
ATOM   2207  CG  GLU B 124      14.371   1.373  16.756  1.00 39.93           C  
ATOM   2208  CD  GLU B 124      15.296   0.167  16.711  1.00 47.28           C  
ATOM   2209  OE1 GLU B 124      16.389   0.268  16.119  1.00 46.55           O  
ATOM   2210  OE2 GLU B 124      14.901  -0.899  17.226  1.00 57.83           O  
ATOM   2211  N   ILE B 125      15.896   5.180  19.084  1.00 36.15           N  
ATOM   2212  CA  ILE B 125      16.827   6.302  19.388  1.00 36.43           C  
ATOM   2213  C   ILE B 125      17.446   6.046  20.749  1.00 35.41           C  
ATOM   2214  O   ILE B 125      18.648   6.197  20.921  1.00 35.61           O  
ATOM   2215  CB  ILE B 125      16.183   7.762  19.465  1.00 36.31           C  
ATOM   2216  CG1 ILE B 125      15.268   8.123  18.292  1.00 39.08           C  
ATOM   2217  CG2 ILE B 125      17.265   8.808  19.602  1.00 35.75           C  
ATOM   2218  CD1 ILE B 125      15.730   7.630  17.028  1.00 47.26           C  
ATOM   2219  N   VAL B 126      16.595   5.702  21.715  1.00 35.32           N  
ATOM   2220  CA  VAL B 126      17.031   5.367  23.062  1.00 34.84           C  
ATOM   2221  C   VAL B 126      18.062   4.212  23.027  1.00 34.31           C  
ATOM   2222  O   VAL B 126      19.120   4.322  23.608  1.00 33.59           O  
ATOM   2223  CB  VAL B 126      15.826   5.004  23.979  1.00 35.48           C  
ATOM   2224  CG1 VAL B 126      16.309   4.479  25.337  1.00 36.91           C  
ATOM   2225  CG2 VAL B 126      14.892   6.228  24.153  1.00 31.37           C  
ATOM   2226  N   ALA B 127      17.743   3.131  22.329  1.00 34.43           N  
ATOM   2227  CA  ALA B 127      18.658   1.987  22.205  1.00 35.75           C  
ATOM   2228  C   ALA B 127      20.004   2.382  21.535  1.00 37.65           C  
ATOM   2229  O   ALA B 127      21.075   2.003  22.018  1.00 39.50           O  
ATOM   2230  CB  ALA B 127      17.974   0.850  21.440  1.00 34.13           C  
ATOM   2231  N   HIS B 128      19.912   3.146  20.437  1.00 38.44           N  
ATOM   2232  CA  HIS B 128      21.052   3.687  19.650  1.00 37.39           C  
ATOM   2233  C   HIS B 128      21.980   4.497  20.556  1.00 34.55           C  
ATOM   2234  O   HIS B 128      23.196   4.276  20.573  1.00 32.46           O  
ATOM   2235  CB  HIS B 128      20.492   4.616  18.536  1.00 40.88           C  
ATOM   2236  CG  HIS B 128      21.469   5.076  17.486  1.00 46.78           C  
ATOM   2237  ND1 HIS B 128      21.056   5.360  16.202  1.00 57.51           N  
ATOM   2238  CD2 HIS B 128      22.809   5.296  17.501  1.00 53.60           C  
ATOM   2239  CE1 HIS B 128      22.092   5.755  15.481  1.00 60.51           C  
ATOM   2240  NE2 HIS B 128      23.169   5.721  16.243  1.00 53.57           N  
ATOM   2241  N   PHE B 129      21.399   5.416  21.321  1.00 28.03           N  
ATOM   2242  CA  PHE B 129      22.159   6.296  22.191  1.00 26.28           C  
ATOM   2243  C   PHE B 129      22.843   5.530  23.315  1.00 26.15           C  
ATOM   2244  O   PHE B 129      24.014   5.770  23.572  1.00 30.86           O  
ATOM   2245  CB  PHE B 129      21.257   7.411  22.779  1.00 27.03           C  
ATOM   2246  CG  PHE B 129      22.022   8.597  23.308  1.00 24.88           C  
ATOM   2247  CD1 PHE B 129      22.704   8.536  24.525  1.00 28.24           C  
ATOM   2248  CD2 PHE B 129      22.043   9.796  22.597  1.00 33.55           C  
ATOM   2249  CE1 PHE B 129      23.406   9.632  25.003  1.00 28.95           C  
ATOM   2250  CE2 PHE B 129      22.753  10.909  23.072  1.00 30.05           C  
ATOM   2251  CZ  PHE B 129      23.432  10.827  24.265  1.00 26.30           C  
ATOM   2252  N   TYR B 130      22.121   4.645  24.005  1.00 25.47           N  
ATOM   2253  CA  TYR B 130      22.714   3.836  25.066  1.00 25.40           C  
ATOM   2254  C   TYR B 130      23.766   2.843  24.493  1.00 29.30           C  
ATOM   2255  O   TYR B 130      24.791   2.604  25.133  1.00 29.47           O  
ATOM   2256  CB  TYR B 130      21.645   3.112  25.896  1.00 28.65           C  
ATOM   2257  CG  TYR B 130      20.994   4.009  26.961  1.00 24.12           C  
ATOM   2258  CD1 TYR B 130      21.554   4.106  28.226  1.00 27.47           C  
ATOM   2259  CD2 TYR B 130      19.838   4.750  26.700  1.00 33.02           C  
ATOM   2260  CE1 TYR B 130      20.986   4.943  29.237  1.00 36.53           C  
ATOM   2261  CE2 TYR B 130      19.242   5.582  27.705  1.00 28.21           C  
ATOM   2262  CZ  TYR B 130      19.838   5.671  28.962  1.00 28.39           C  
ATOM   2263  OH  TYR B 130      19.292   6.463  29.963  1.00 37.89           O  
ATOM   2264  N   HIS B 131      23.522   2.293  23.305  1.00 27.40           N  
ATOM   2265  CA  HIS B 131      24.485   1.360  22.690  1.00 31.43           C  
ATOM   2266  C   HIS B 131      25.778   2.122  22.508  1.00 30.74           C  
ATOM   2267  O   HIS B 131      26.761   1.773  23.123  1.00 34.19           O  
ATOM   2268  CB  HIS B 131      23.969   0.813  21.360  1.00 30.39           C  
ATOM   2269  CG  HIS B 131      24.876  -0.184  20.713  1.00 37.79           C  
ATOM   2270  ND1 HIS B 131      24.767  -1.540  20.939  1.00 43.29           N  
ATOM   2271  CD2 HIS B 131      25.882  -0.025  19.819  1.00 36.56           C  
ATOM   2272  CE1 HIS B 131      25.678  -2.172  20.217  1.00 47.42           C  
ATOM   2273  NE2 HIS B 131      26.369  -1.277  19.532  1.00 43.02           N  
ATOM   2274  N   HIS B 132      25.722   3.226  21.775  1.00 33.15           N  
ATOM   2275  CA  HIS B 132      26.894   4.056  21.499  1.00 36.23           C  
ATOM   2276  C   HIS B 132      27.554   4.669  22.733  1.00 35.17           C  
ATOM   2277  O   HIS B 132      28.769   4.761  22.779  1.00 31.84           O  
ATOM   2278  CB  HIS B 132      26.572   5.097  20.407  1.00 40.05           C  
ATOM   2279  CG  HIS B 132      26.451   4.494  19.033  1.00 47.70           C  
ATOM   2280  ND1 HIS B 132      25.495   3.550  18.720  1.00 53.61           N  
ATOM   2281  CD2 HIS B 132      27.172   4.681  17.903  1.00 57.00           C  
ATOM   2282  CE1 HIS B 132      25.631   3.188  17.457  1.00 54.26           C  
ATOM   2283  NE2 HIS B 132      26.639   3.862  16.938  1.00 53.99           N  
ATOM   2284  N   ARG B 133      26.759   5.077  23.725  1.00 37.24           N  
ATOM   2285  CA  ARG B 133      27.289   5.587  24.999  1.00 37.31           C  
ATOM   2286  C   ARG B 133      28.033   4.472  25.743  1.00 35.84           C  
ATOM   2287  O   ARG B 133      29.018   4.752  26.419  1.00 37.88           O  
ATOM   2288  CB  ARG B 133      26.161   6.215  25.852  1.00 38.19           C  
ATOM   2289  CG  ARG B 133      26.474   6.602  27.306  1.00 39.96           C  
ATOM   2290  CD  ARG B 133      25.186   7.159  27.968  1.00 45.80           C  
ATOM   2291  NE  ARG B 133      25.227   7.269  29.437  1.00 54.53           N  
ATOM   2292  CZ  ARG B 133      24.735   6.382  30.317  1.00 63.36           C  
ATOM   2293  NH1 ARG B 133      24.151   5.240  29.938  1.00 69.41           N  
ATOM   2294  NH2 ARG B 133      24.837   6.628  31.629  1.00 71.37           N  
ATOM   2295  N   GLY B 134      27.561   3.225  25.614  1.00 33.81           N  
ATOM   2296  CA  GLY B 134      28.203   2.065  26.200  1.00 33.06           C  
ATOM   2297  C   GLY B 134      29.537   1.721  25.538  1.00 33.53           C  
ATOM   2298  O   GLY B 134      30.468   1.318  26.219  1.00 34.94           O  
ATOM   2299  N   GLN B 135      29.624   1.857  24.220  1.00 34.20           N  
ATOM   2300  CA  GLN B 135      30.894   1.644  23.471  1.00 35.01           C  
ATOM   2301  C   GLN B 135      31.975   2.608  23.976  1.00 37.89           C  
ATOM   2302  O   GLN B 135      33.099   2.200  24.278  1.00 37.03           O  
ATOM   2303  CB  GLN B 135      30.687   1.884  21.967  1.00 34.00           C  
ATOM   2304  CG  GLN B 135      29.862   0.818  21.249  1.00 33.23           C  
ATOM   2305  CD  GLN B 135      29.654   1.099  19.760  1.00 32.17           C  
ATOM   2306  OE1 GLN B 135      30.030   2.138  19.236  1.00 39.69           O  
ATOM   2307  NE2 GLN B 135      29.021   0.169  19.086  1.00 44.62           N  
ATOM   2308  N   ILE B 136      31.596   3.884  24.073  1.00 41.22           N  
ATOM   2309  CA  ILE B 136      32.460   4.949  24.575  1.00 43.49           C  
ATOM   2310  C   ILE B 136      32.859   4.680  26.031  1.00 45.67           C  
ATOM   2311  O   ILE B 136      34.041   4.712  26.353  1.00 47.17           O  
ATOM   2312  CB  ILE B 136      31.777   6.362  24.465  1.00 43.48           C  
ATOM   2313  CG1 ILE B 136      31.608   6.774  22.997  1.00 40.37           C  
ATOM   2314  CG2 ILE B 136      32.593   7.440  25.204  1.00 40.35           C  
ATOM   2315  CD1 ILE B 136      30.771   8.032  22.791  1.00 42.54           C  
ATOM   2316  N   HIS B 137      31.874   4.391  26.881  1.00 47.74           N  
ATOM   2317  CA  HIS B 137      32.096   4.144  28.315  1.00 48.91           C  
ATOM   2318  C   HIS B 137      33.164   3.085  28.632  1.00 49.55           C  
ATOM   2319  O   HIS B 137      34.002   3.310  29.503  1.00 51.02           O  
ATOM   2320  CB  HIS B 137      30.780   3.779  29.011  1.00 49.82           C  
ATOM   2321  CG  HIS B 137      30.935   3.466  30.469  1.00 53.38           C  
ATOM   2322  ND1 HIS B 137      31.152   2.187  30.934  1.00 54.62           N  
ATOM   2323  CD2 HIS B 137      30.935   4.268  31.558  1.00 54.76           C  
ATOM   2324  CE1 HIS B 137      31.256   2.212  32.249  1.00 55.69           C  
ATOM   2325  NE2 HIS B 137      31.130   3.464  32.653  1.00 54.25           N  
ATOM   2326  N   ILE B 138      33.124   1.952  27.936  1.00 49.62           N  
ATOM   2327  CA  ILE B 138      34.092   0.871  28.164  1.00 49.06           C  
ATOM   2328  C   ILE B 138      35.480   1.226  27.607  1.00 49.90           C  
ATOM   2329  O   ILE B 138      36.481   0.819  28.188  1.00 51.60           O  
ATOM   2330  CB  ILE B 138      33.579  -0.491  27.614  1.00 48.83           C  
ATOM   2331  CG1 ILE B 138      34.301  -1.680  28.265  1.00 47.83           C  
ATOM   2332  CG2 ILE B 138      33.627  -0.550  26.093  1.00 45.23           C  
ATOM   2333  CD1 ILE B 138      33.931  -1.888  29.716  1.00 46.10           C  
ATOM   2334  N   LEU B 139      35.539   1.952  26.486  1.00 50.29           N  
ATOM   2335  CA  LEU B 139      36.821   2.414  25.921  1.00 50.44           C  
ATOM   2336  C   LEU B 139      37.478   3.395  26.892  1.00 50.59           C  
ATOM   2337  O   LEU B 139      38.702   3.403  27.000  1.00 49.64           O  
ATOM   2338  CB  LEU B 139      36.668   3.061  24.526  1.00 51.00           C  
ATOM   2339  CG  LEU B 139      36.303   2.203  23.308  1.00 49.49           C  
ATOM   2340  CD2 LEU B 139      37.298   1.065  23.105  1.00 48.27           C  
ATOM   2341  N   LEU B 140      36.667   4.198  27.595  1.00 51.39           N  
ATOM   2342  CA  LEU B 140      37.160   5.133  28.624  1.00 52.42           C  
ATOM   2343  C   LEU B 140      37.745   4.380  29.825  1.00 54.01           C  
ATOM   2344  O   LEU B 140      38.850   4.685  30.240  1.00 56.83           O  
ATOM   2345  CB  LEU B 140      36.070   6.127  29.078  1.00 51.47           C  
ATOM   2346  CG  LEU B 140      35.620   7.190  28.064  1.00 50.65           C  
ATOM   2347  CD1 LEU B 140      34.440   7.988  28.607  1.00 48.77           C  
ATOM   2348  CD2 LEU B 140      36.770   8.120  27.679  1.00 52.02           C  
ATOM   2349  N   CYS B 141      37.022   3.400  30.365  1.00 54.95           N  
ATOM   2350  CA  CYS B 141      37.533   2.563  31.471  1.00 55.97           C  
ATOM   2351  C   CYS B 141      38.795   1.751  31.107  1.00 58.28           C  
ATOM   2352  O   CYS B 141      39.630   1.487  31.974  1.00 59.16           O  
ATOM   2353  CB  CYS B 141      36.472   1.569  31.927  1.00 55.37           C  
ATOM   2354  SG  CYS B 141      34.963   2.301  32.474  1.00 57.89           S  
ATOM   2355  N   GLU B 142      38.912   1.367  29.835  1.00 60.61           N  
ATOM   2356  CA  GLU B 142      40.031   0.552  29.323  1.00 62.78           C  
ATOM   2357  C   GLU B 142      41.337   1.305  29.022  1.00 64.75           C  
ATOM   2358  O   GLU B 142      42.417   0.784  29.321  1.00 64.87           O  
ATOM   2359  CB  GLU B 142      39.582  -0.240  28.070  1.00 63.17           C  
ATOM   2360  CG  GLU B 142      38.719  -1.487  28.376  1.00 64.66           C  
ATOM   2361  CD  GLU B 142      39.544  -2.692  28.838  1.00 64.38           C  
ATOM   2362  OE1 GLU B 142      40.525  -3.043  28.153  1.00 66.21           O  
ATOM   2363  OE2 GLU B 142      39.205  -3.307  29.868  1.00 65.58           O  
ATOM   2364  N   HIS B 143      41.234   2.501  28.432  1.00 66.66           N  
ATOM   2365  CA  HIS B 143      42.402   3.312  27.989  1.00 67.38           C  
ATOM   2366  C   HIS B 143      42.597   4.695  28.651  1.00 68.89           C  
ATOM   2367  O   HIS B 143      43.559   5.399  28.335  1.00 68.42           O  
ATOM   2368  CB  HIS B 143      42.302   3.506  26.475  1.00 66.83           C  
ATOM   2369  CG  HIS B 143      42.033   2.240  25.726  1.00 66.59           C  
ATOM   2370  ND1 HIS B 143      40.762   1.847  25.373  1.00 70.80           N  
ATOM   2371  CD2 HIS B 143      42.861   1.262  25.290  1.00 71.15           C  
ATOM   2372  CE1 HIS B 143      40.820   0.690  24.737  1.00 71.90           C  
ATOM   2373  NE2 HIS B 143      42.083   0.313  24.673  1.00 67.20           N  
HETATM 2374  N   MSE B 144      41.691   5.070  29.548  1.00 71.38           N  
HETATM 2375  CA  MSE B 144      41.704   6.356  30.251  1.00 73.57           C  
HETATM 2376  C   MSE B 144      41.283   6.132  31.713  1.00 74.38           C  
HETATM 2377  O   MSE B 144      41.246   4.987  32.172  1.00 74.68           O  
HETATM 2378  CB  MSE B 144      40.740   7.316  29.517  1.00 75.16           C  
HETATM 2379  CG  MSE B 144      41.257   7.916  28.228  1.00 79.43           C  
HETATM 2380 SE   MSE B 144      42.844   9.030  28.513  0.75103.50          SE  
HETATM 2381  CE  MSE B 144      42.288  10.163  30.024  1.00 88.54           C  
ATOM   2382  N   LYS B 145      41.028   7.210  32.456  1.00 76.02           N  
ATOM   2383  CA  LYS B 145      40.481   7.097  33.812  1.00 77.96           C  
ATOM   2384  C   LYS B 145      39.004   6.632  33.739  1.00 78.98           C  
ATOM   2385  O   LYS B 145      38.298   6.911  32.765  1.00 78.17           O  
ATOM   2386  CB  LYS B 145      40.584   8.431  34.566  1.00 78.17           C  
ATOM   2387  N   ASP B 146      38.569   5.909  34.767  1.00 79.57           N  
ATOM   2388  CA  ASP B 146      37.193   5.418  34.887  1.00 80.60           C  
ATOM   2389  C   ASP B 146      36.318   6.639  35.284  1.00 81.49           C  
ATOM   2390  O   ASP B 146      36.632   7.307  36.271  1.00 81.99           O  
ATOM   2391  CB  ASP B 146      37.165   4.318  35.972  1.00 79.91           C  
ATOM   2392  CG  ASP B 146      35.856   3.533  36.033  1.00 78.49           C  
ATOM   2393  OD1 ASP B 146      34.756   4.093  35.842  1.00 77.20           O  
ATOM   2394  OD2 ASP B 146      35.938   2.323  36.331  1.00 72.20           O  
ATOM   2395  N   PRO B 147      35.235   6.950  34.523  1.00 82.57           N  
ATOM   2396  CA  PRO B 147      34.339   8.078  34.879  1.00 83.67           C  
ATOM   2397  C   PRO B 147      33.290   7.659  35.938  1.00 85.28           C  
ATOM   2398  O   PRO B 147      33.473   6.627  36.591  1.00 85.73           O  
ATOM   2399  CB  PRO B 147      33.688   8.409  33.537  1.00 83.68           C  
ATOM   2400  CG  PRO B 147      33.562   7.080  32.875  1.00 82.80           C  
ATOM   2401  CD  PRO B 147      34.774   6.283  33.289  1.00 82.32           C  
ATOM   2402  N   ASN B 148      32.246   8.474  36.159  1.00 86.83           N  
ATOM   2403  CA  ASN B 148      31.131   8.135  37.086  1.00 86.97           C  
ATOM   2404  C   ASN B 148      29.734   8.518  36.545  1.00 87.01           C  
ATOM   2405  O   ASN B 148      29.499   9.690  36.217  1.00 86.83           O  
ATOM   2406  CB  ASN B 148      31.330   8.772  38.474  1.00 87.87           C  
ATOM   2407  CG  ASN B 148      32.422   8.085  39.294  1.00 90.67           C  
ATOM   2408  OD1 ASN B 148      32.129   7.397  40.276  1.00 94.03           O  
ATOM   2409  ND2 ASN B 148      33.676   8.253  38.887  1.00 91.89           N  
ATOM   2410  N   ILE B 149      28.836   7.522  36.460  1.00 86.24           N  
ATOM   2411  CA  ILE B 149      27.426   7.702  36.044  1.00 86.05           C  
ATOM   2412  C   ILE B 149      26.565   7.925  37.298  1.00 84.88           C  
ATOM   2413  O   ILE B 149      27.029   8.457  38.310  1.00 82.42           O  
ATOM   2414  CB  ILE B 149      26.877   6.467  35.228  1.00 86.61           C  
ATOM   2415  CG1 ILE B 149      27.653   6.295  33.909  1.00 87.11           C  
ATOM   2416  CG2 ILE B 149      25.354   6.591  34.942  1.00 85.06           C  
ATOM   2417  CD1 ILE B 149      27.248   5.063  33.081  1.00 85.32           C  
TER    2418      ILE B 149                                                      
END
MOLECULE T0406.pdb
ATOM      1  N   MET     1       7.297  -1.140  21.855  1.00 67.48           N  
ATOM      2  CA  MET     1       6.466   0.089  21.680  1.00 67.38           C  
ATOM      3  C   MET     1       6.624   1.036  22.879  1.00 67.17           C  
ATOM      4  O   MET     1       7.261   0.680  23.880  1.00 67.51           O  
ATOM      5  CB  MET     1       4.991  -0.288  21.493  1.00 67.14           C  
ATOM      6  N   TYR     2       6.087   2.252  22.731  1.00 66.54           N  
ATOM      7  CA  TYR     2       5.887   3.206  23.831  1.00 65.82           C  
ATOM      8  C   TYR     2       4.455   3.692  23.727  1.00 64.83           C  
ATOM      9  O   TYR     2       4.090   4.306  22.724  1.00 65.23           O  
ATOM     10  CB  TYR     2       6.815   4.425  23.724  1.00 66.09           C  
ATOM     11  CG  TYR     2       8.272   4.144  23.994  1.00 66.72           C  
ATOM     12  CD1 TYR     2       9.114   3.721  22.966  1.00 67.06           C  
ATOM     13  CD2 TYR     2       8.819   4.310  25.272  1.00 66.81           C  
ATOM     14  CE1 TYR     2      10.460   3.462  23.197  1.00 67.20           C  
ATOM     15  CE2 TYR     2      10.181   4.049  25.515  1.00 66.68           C  
ATOM     16  CZ  TYR     2      10.987   3.627  24.464  1.00 66.65           C  
ATOM     17  OH  TYR     2      12.319   3.352  24.649  1.00 67.31           O  
ATOM     18  N   GLN     3       3.643   3.428  24.747  1.00 63.41           N  
ATOM     19  CA  GLN     3       2.236   3.824  24.719  1.00 62.14           C  
ATOM     20  C   GLN     3       2.079   5.346  24.698  1.00 60.68           C  
ATOM     21  O   GLN     3       1.188   5.860  24.035  1.00 60.60           O  
ATOM     22  CB  GLN     3       1.478   3.230  25.914  1.00 62.10           C  
ATOM     23  N   THR     4       2.957   6.064  25.395  1.00 59.24           N  
ATOM     24  CA  THR     4       2.775   7.504  25.588  1.00 57.91           C  
ATOM     25  C   THR     4       4.038   8.348  25.382  1.00 56.62           C  
ATOM     26  O   THR     4       5.159   7.870  25.551  1.00 56.20           O  
ATOM     27  CB  THR     4       2.215   7.788  27.012  1.00 58.17           C  
ATOM     28  OG1 THR     4       2.177   9.207  27.252  1.00 59.26           O  
ATOM     29  CG2 THR     4       3.069   7.108  28.092  1.00 57.72           C  
ATOM     30  N   ILE     5       3.824   9.617  25.047  1.00 55.05           N  
ATOM     31  CA  ILE     5       4.896  10.604  24.947  1.00 54.14           C  
ATOM     32  C   ILE     5       5.613  10.811  26.281  1.00 53.68           C  
ATOM     33  O   ILE     5       6.835  10.814  26.328  1.00 53.74           O  
ATOM     34  CB  ILE     5       4.373  11.978  24.469  1.00 53.85           C  
ATOM     35  CG1 ILE     5       3.799  11.886  23.058  1.00 53.39           C  
ATOM     36  CG2 ILE     5       5.488  13.034  24.513  1.00 54.49           C  
ATOM     37  CD1 ILE     5       4.763  11.369  22.022  1.00 53.23           C  
ATOM     38  N   GLU     6       4.863  10.994  27.366  1.00 52.98           N  
ATOM     39  CA  GLU     6       5.484  11.191  28.676  1.00 52.29           C  
ATOM     40  C   GLU     6       6.222   9.939  29.121  1.00 50.67           C  
ATOM     41  O   GLU     6       7.255  10.034  29.758  1.00 51.06           O  
ATOM     42  CB  GLU     6       4.453  11.603  29.741  1.00 52.96           C  
ATOM     43  CG  GLU     6       3.816  12.982  29.509  1.00 55.77           C  
ATOM     44  CD  GLU     6       4.832  14.097  29.249  1.00 59.09           C  
ATOM     45  OE1 GLU     6       5.838  14.193  30.007  1.00 61.36           O  
ATOM     46  OE2 GLU     6       4.607  14.883  28.288  1.00 60.81           O  
ATOM     47  N   GLY     7       5.707   8.772  28.767  1.00 48.43           N  
ATOM     48  CA  GLY     7       6.382   7.523  29.073  1.00 47.15           C  
ATOM     49  C   GLY     7       7.752   7.447  28.424  1.00 46.15           C  
ATOM     50  O   GLY     7       8.710   6.970  29.040  1.00 45.59           O  
ATOM     51  N   PHE     8       7.846   7.915  27.178  1.00 44.90           N  
ATOM     52  CA  PHE     8       9.119   7.948  26.461  1.00 43.84           C  
ATOM     53  C   PHE     8      10.069   8.942  27.100  1.00 43.34           C  
ATOM     54  O   PHE     8      11.256   8.666  27.213  1.00 43.35           O  
ATOM     55  CB  PHE     8       8.948   8.285  24.972  1.00 43.21           C  
ATOM     56  CG  PHE     8      10.256   8.601  24.277  1.00 43.07           C  
ATOM     57  CD1 PHE     8      11.165   7.598  23.993  1.00 42.55           C  
ATOM     58  CD2 PHE     8      10.587   9.903  23.942  1.00 41.66           C  
ATOM     59  CE1 PHE     8      12.376   7.888  23.385  1.00 42.21           C  
ATOM     60  CE2 PHE     8      11.798  10.194  23.342  1.00 41.83           C  
ATOM     61  CZ  PHE     8      12.690   9.176  23.063  1.00 41.14           C  
ATOM     62  N   LEU     9       9.551  10.098  27.512  1.00 43.00           N  
ATOM     63  CA  LEU     9      10.393  11.163  28.053  1.00 42.69           C  
ATOM     64  C   LEU     9      10.978  10.813  29.428  1.00 42.59           C  
ATOM     65  O   LEU     9      12.059  11.278  29.773  1.00 42.28           O  
ATOM     66  CB  LEU     9       9.636  12.499  28.078  1.00 42.45           C  
ATOM     67  CG  LEU     9       9.320  13.024  26.671  1.00 41.60           C  
ATOM     68  CD1 LEU     9       8.392  14.227  26.690  1.00 40.52           C  
ATOM     69  CD2 LEU     9      10.596  13.343  25.926  1.00 42.49           C  
ATOM     70  N   GLN    10      10.282   9.969  30.191  1.00 42.38           N  
ATOM     71  CA  GLN    10      10.823   9.446  31.457  1.00 41.96           C  
ATOM     72  C   GLN    10      12.030   8.536  31.190  1.00 41.70           C  
ATOM     73  O   GLN    10      13.037   8.608  31.896  1.00 41.65           O  
ATOM     74  CB  GLN    10       9.747   8.703  32.267  1.00 41.95           C  
ATOM     75  N   SER    11      11.925   7.681  30.174  1.00 41.31           N  
ATOM     76  CA  SER    11      13.063   6.887  29.716  1.00 41.21           C  
ATOM     77  C   SER    11      14.146   7.795  29.103  1.00 40.77           C  
ATOM     78  O   SER    11      15.311   7.716  29.479  1.00 40.67           O  
ATOM     79  CB  SER    11      12.602   5.835  28.696  1.00 41.13           C  
ATOM     80  N   TRP    12      13.750   8.667  28.183  1.00 40.55           N  
ATOM     81  CA  TRP    12      14.686   9.549  27.479  1.00 40.77           C  
ATOM     82  C   TRP    12      15.453  10.500  28.402  1.00 41.18           C  
ATOM     83  O   TRP    12      16.632  10.774  28.176  1.00 41.09           O  
ATOM     84  CB  TRP    12      13.942  10.362  26.406  1.00 40.37           C  
ATOM     85  CG  TRP    12      14.840  11.191  25.536  1.00 39.72           C  
ATOM     86  CD1 TRP    12      14.843  12.546  25.427  1.00 38.90           C  
ATOM     87  CD2 TRP    12      15.869  10.710  24.662  1.00 37.40           C  
ATOM     88  NE1 TRP    12      15.822  12.941  24.537  1.00 39.94           N  
ATOM     89  CE2 TRP    12      16.457  11.832  24.052  1.00 36.37           C  
ATOM     90  CE3 TRP    12      16.354   9.434  24.345  1.00 38.39           C  
ATOM     91  CZ2 TRP    12      17.512  11.727  23.155  1.00 39.00           C  
ATOM     92  CZ3 TRP    12      17.408   9.325  23.448  1.00 39.08           C  
ATOM     93  CH2 TRP    12      17.968  10.471  22.855  1.00 39.11           C  
ATOM     94  N   THR    13      14.788  11.006  29.437  1.00 41.85           N  
ATOM     95  CA  THR    13      15.415  11.922  30.398  1.00 41.85           C  
ATOM     96  C   THR    13      16.573  11.248  31.140  1.00 42.11           C  
ATOM     97  O   THR    13      17.616  11.854  31.303  1.00 41.71           O  
ATOM     98  CB  THR    13      14.371  12.488  31.404  1.00 42.21           C  
ATOM     99  OG1 THR    13      13.365  13.207  30.682  1.00 42.84           O  
ATOM    100  CG2 THR    13      15.012  13.441  32.434  1.00 41.66           C  
ATOM    101  N   TYR    14      16.398   9.995  31.567  1.00 42.84           N  
ATOM    102  CA  TYR    14      17.488   9.241  32.209  1.00 43.23           C  
ATOM    103  C   TYR    14      18.650   9.016  31.226  1.00 42.43           C  
ATOM    104  O   TYR    14      19.816   9.103  31.603  1.00 42.22           O  
ATOM    105  CB  TYR    14      16.999   7.884  32.757  1.00 44.38           C  
ATOM    106  CG  TYR    14      18.107   7.055  33.401  1.00 45.95           C  
ATOM    107  CD1 TYR    14      18.950   6.246  32.622  1.00 47.52           C  
ATOM    108  CD2 TYR    14      18.330   7.091  34.785  1.00 47.51           C  
ATOM    109  CE1 TYR    14      19.987   5.494  33.202  1.00 47.80           C  
ATOM    110  CE2 TYR    14      19.367   6.339  35.375  1.00 47.55           C  
ATOM    111  CZ  TYR    14      20.189   5.546  34.574  1.00 47.61           C  
ATOM    112  OH  TYR    14      21.210   4.803  35.136  1.00 47.57           O  
ATOM    113  N   GLU    15      18.328   8.702  29.976  1.00 41.66           N  
ATOM    114  CA  GLU    15      19.349   8.445  28.956  1.00 41.25           C  
ATOM    115  C   GLU    15      20.147   9.701  28.626  1.00 40.71           C  
ATOM    116  O   GLU    15      21.375   9.657  28.545  1.00 41.46           O  
ATOM    117  CB  GLU    15      18.713   7.888  27.685  1.00 41.21           C  
ATOM    118  CG  GLU    15      18.068   6.507  27.849  1.00 40.06           C  
ATOM    119  CD  GLU    15      19.015   5.466  28.398  1.00 40.80           C  
ATOM    120  OE1 GLU    15      20.183   5.434  27.981  1.00 43.05           O  
ATOM    121  OE2 GLU    15      18.606   4.655  29.244  1.00 40.70           O  
ATOM    122  N   THR    16      19.460  10.818  28.437  1.00 40.48           N  
ATOM    123  CA  THR    16      20.137  12.067  28.086  1.00 40.67           C  
ATOM    124  C   THR    16      20.956  12.631  29.241  1.00 40.57           C  
ATOM    125  O   THR    16      22.086  13.087  29.021  1.00 40.78           O  
ATOM    126  CB  THR    16      19.166  13.156  27.586  1.00 40.47           C  
ATOM    127  OG1 THR    16      18.230  13.485  28.611  1.00 43.09           O  
ATOM    128  CG2 THR    16      18.414  12.697  26.352  1.00 40.12           C  
ATOM    129  N   GLU    17      20.400  12.609  30.460  1.00 39.86           N  
ATOM    130  CA  GLU    17      21.137  13.073  31.639  1.00 39.51           C  
ATOM    131  C   GLU    17      22.447  12.300  31.772  1.00 39.87           C  
ATOM    132  O   GLU    17      23.517  12.891  31.948  1.00 39.64           O  
ATOM    133  CB  GLU    17      20.291  12.941  32.938  1.00 39.19           C  
ATOM    134  CG  GLU    17      19.182  14.019  33.096  1.00 40.37           C  
ATOM    135  CD  GLU    17      18.399  13.942  34.433  1.00 38.16           C  
ATOM    136  N   SER    18      22.346  10.977  31.677  1.00 40.25           N  
ATOM    137  CA  SER    18      23.503  10.084  31.744  1.00 40.99           C  
ATOM    138  C   SER    18      24.538  10.358  30.638  1.00 40.55           C  
ATOM    139  O   SER    18      25.725  10.377  30.893  1.00 41.38           O  
ATOM    140  CB  SER    18      23.028   8.621  31.691  1.00 41.43           C  
ATOM    141  OG  SER    18      24.085   7.743  31.306  1.00 44.83           O  
ATOM    142  N   THR    19      24.083  10.581  29.413  1.00 40.09           N  
ATOM    143  CA  THR    19      24.981  10.822  28.294  1.00 39.40           C  
ATOM    144  C   THR    19      25.668  12.169  28.440  1.00 40.16           C  
ATOM    145  O   THR    19      26.867  12.277  28.222  1.00 39.94           O  
ATOM    146  CB  THR    19      24.226  10.716  26.941  1.00 39.05           C  
ATOM    147  OG1 THR    19      23.608   9.429  26.875  1.00 38.12           O  
ATOM    148  CG2 THR    19      25.167  10.872  25.755  1.00 38.05           C  
ATOM    149  N   GLN    20      24.900  13.179  28.839  1.00 40.47           N  
ATOM    150  CA  GLN    20      25.405  14.537  28.995  1.00 40.77           C  
ATOM    151  C   GLN    20      26.471  14.626  30.083  1.00 41.36           C  
ATOM    152  O   GLN    20      27.433  15.382  29.931  1.00 41.53           O  
ATOM    153  CB  GLN    20      24.249  15.489  29.312  1.00 40.66           C  
ATOM    154  CG  GLN    20      24.633  16.965  29.386  1.00 40.31           C  
ATOM    155  CD  GLN    20      24.916  17.559  28.025  1.00 40.59           C  
ATOM    156  OE1 GLN    20      24.019  17.678  27.197  1.00 39.78           O  
ATOM    157  NE2 GLN    20      26.159  17.973  27.799  1.00 40.39           N  
ATOM    158  N   LYS    21      26.294  13.871  31.170  1.00 41.97           N  
ATOM    159  CA  LYS    21      27.275  13.825  32.266  1.00 42.84           C  
ATOM    160  C   LYS    21      28.624  13.299  31.779  1.00 42.30           C  
ATOM    161  O   LYS    21      29.674  13.815  32.154  1.00 41.33           O  
ATOM    162  CB  LYS    21      26.799  12.926  33.412  1.00 42.87           C  
ATOM    163  CG  LYS    21      25.691  13.497  34.281  1.00 44.80           C  
ATOM    164  CD  LYS    21      25.392  12.603  35.518  1.00 45.52           C  
ATOM    165  CE  LYS    21      25.198  11.125  35.110  1.00 47.96           C  
ATOM    166  NZ  LYS    21      24.594  10.313  36.197  1.00 50.07           N  
ATOM    167  N   MET    22      28.582  12.250  30.957  1.00 41.83           N  
ATOM    168  CA  MET    22      29.792  11.702  30.386  1.00 42.13           C  
ATOM    169  C   MET    22      30.464  12.678  29.418  1.00 41.34           C  
ATOM    170  O   MET    22      31.661  12.951  29.532  1.00 41.70           O  
ATOM    171  CB  MET    22      29.499  10.357  29.752  1.00 41.41           C  
ATOM    172  CG  MET    22      29.212   9.331  30.816  1.00 41.76           C  
ATOM    173  SD  MET    22      29.053   7.714  29.928  0.75 46.00          SE  
ATOM    174  CE  MET    22      28.062   6.697  31.258  1.00 42.97           C  
ATOM    175  N   LEU    23      29.683  13.257  28.525  1.00 41.06           N  
ATOM    176  CA  LEU    23      30.180  14.268  27.589  1.00 40.50           C  
ATOM    177  C   LEU    23      30.793  15.430  28.306  1.00 40.38           C  
ATOM    178  O   LEU    23      31.763  15.992  27.827  1.00 40.99           O  
ATOM    179  CB  LEU    23      29.057  14.765  26.647  1.00 40.12           C  
ATOM    180  CG  LEU    23      28.669  13.786  25.523  1.00 38.27           C  
ATOM    181  CD1 LEU    23      27.561  14.345  24.656  1.00 35.14           C  
ATOM    182  CD2 LEU    23      29.861  13.455  24.660  1.00 36.73           C  
ATOM    183  N   ASP    24      30.232  15.791  29.461  1.00 40.31           N  
ATOM    184  CA  ASP    24      30.712  16.941  30.237  1.00 40.03           C  
ATOM    185  C   ASP    24      32.090  16.701  30.870  1.00 39.37           C  
ATOM    186  O   ASP    24      32.787  17.655  31.197  1.00 38.85           O  
ATOM    187  CB  ASP    24      29.687  17.346  31.325  1.00 40.24           C  
ATOM    188  CG  ASP    24      28.461  18.090  30.757  1.00 40.77           C  
ATOM    189  OD1 ASP    24      28.486  18.507  29.579  1.00 42.10           O  
ATOM    190  OD2 ASP    24      27.463  18.268  31.498  1.00 43.46           O  
ATOM    191  N   VAL    25      32.480  15.438  31.027  1.00 38.26           N  
ATOM    192  CA  VAL    25      33.777  15.086  31.632  1.00 38.17           C  
ATOM    193  C   VAL    25      34.928  15.046  30.614  1.00 37.59           C  
ATOM    194  O   VAL    25      36.101  15.050  30.988  1.00 36.68           O  
ATOM    195  CB  VAL    25      33.684  13.702  32.309  1.00 38.15           C  
ATOM    196  CG1 VAL    25      35.032  13.258  32.835  1.00 38.34           C  
ATOM    197  CG2 VAL    25      32.656  13.739  33.431  1.00 39.21           C  
ATOM    198  N   LEU    26      34.587  14.997  29.328  1.00 37.24           N  
ATOM    199  CA  LEU    26      35.586  14.778  28.276  1.00 37.75           C  
ATOM    200  C   LEU    26      36.463  16.017  28.180  1.00 37.41           C  
ATOM    201  O   LEU    26      36.004  17.143  28.403  1.00 37.48           O  
ATOM    202  CB  LEU    26      34.914  14.437  26.920  1.00 37.39           C  
ATOM    203  CG  LEU    26      34.684  12.958  26.533  1.00 38.57           C  
ATOM    204  CD1 LEU    26      34.222  12.049  27.652  1.00 41.47           C  
ATOM    205  CD2 LEU    26      33.704  12.858  25.355  1.00 38.55           C  
ATOM    206  N   THR    27      37.741  15.788  27.904  1.00 37.39           N  
ATOM    207  CA  THR    27      38.704  16.852  27.689  1.00 36.78           C  
ATOM    208  C   THR    27      39.095  16.792  26.227  1.00 36.71           C  
ATOM    209  O   THR    27      38.852  15.779  25.560  1.00 36.22           O  
ATOM    210  CB  THR    27      39.959  16.643  28.545  1.00 36.70           C  
ATOM    211  OG1 THR    27      40.584  15.407  28.170  1.00 35.79           O  
ATOM    212  CG2 THR    27      39.596  16.593  30.025  1.00 36.04           C  
ATOM    213  N   ASP    28      39.698  17.876  25.746  1.00 36.48           N  
ATOM    214  CA  ASP    28      40.181  17.965  24.373  1.00 36.48           C  
ATOM    215  C   ASP    28      41.176  16.861  24.059  1.00 36.24           C  
ATOM    216  O   ASP    28      41.126  16.267  22.986  1.00 35.36           O  
ATOM    217  CB  ASP    28      40.835  19.318  24.122  1.00 36.48           C  
ATOM    218  CG  ASP    28      39.838  20.462  24.108  1.00 36.42           C  
ATOM    219  OD1 ASP    28      38.623  20.221  24.269  1.00 37.35           O  
ATOM    220  OD2 ASP    28      40.270  21.616  23.927  1.00 37.41           O  
ATOM    221  N   GLU    29      42.050  16.575  25.013  1.00 36.42           N  
ATOM    222  CA  GLU    29      43.073  15.539  24.856  1.00 36.73           C  
ATOM    223  C   GLU    29      42.464  14.161  24.700  1.00 36.58           C  
ATOM    224  O   GLU    29      42.914  13.376  23.859  1.00 36.92           O  
ATOM    225  CB  GLU    29      44.019  15.533  26.067  1.00 36.94           C  
ATOM    226  CG  GLU    29      45.252  14.631  25.896  1.00 37.22           C  
ATOM    227  N   SER    30      41.444  13.873  25.515  1.00 36.43           N  
ATOM    228  CA  SER    30      40.774  12.551  25.541  1.00 36.31           C  
ATOM    229  C   SER    30      40.136  12.169  24.224  1.00 36.16           C  
ATOM    230  O   SER    30      40.007  10.982  23.911  1.00 37.55           O  
ATOM    231  CB  SER    30      39.707  12.495  26.643  1.00 36.25           C  
ATOM    232  OG  SER    30      38.616  13.360  26.369  1.00 36.58           O  
ATOM    233  N   LEU    31      39.752  13.170  23.451  1.00 35.91           N  
ATOM    234  CA  LEU    31      39.124  12.969  22.157  1.00 35.90           C  
ATOM    235  C   LEU    31      39.992  12.163  21.201  1.00 35.76           C  
ATOM    236  O   LEU    31      39.459  11.472  20.327  1.00 36.37           O  
ATOM    237  CB  LEU    31      38.772  14.326  21.516  1.00 35.53           C  
ATOM    238  CG  LEU    31      37.787  15.200  22.289  1.00 35.42           C  
ATOM    239  CD1 LEU    31      37.398  16.345  21.392  1.00 34.66           C  
ATOM    240  CD2 LEU    31      36.543  14.418  22.807  1.00 36.79           C  
ATOM    241  N   SER    32      41.316  12.224  21.368  1.00 35.50           N  
ATOM    242  CA  SER    32      42.212  11.485  20.484  1.00 35.38           C  
ATOM    243  C   SER    32      42.359  10.021  20.909  1.00 35.55           C  
ATOM    244  O   SER    32      42.958   9.244  20.192  1.00 35.03           O  
ATOM    245  CB  SER    32      43.575  12.170  20.369  1.00 35.21           C  
ATOM    246  OG  SER    32      44.276  12.175  21.595  1.00 36.76           O  
ATOM    247  N   GLN    33      41.741   9.642  22.008  1.00 35.94           N  
ATOM    248  CA  GLN    33      41.856   8.283  22.500  1.00 36.42           C  
ATOM    249  C   GLN    33      41.259   7.240  21.573  1.00 37.94           C  
ATOM    250  O   GLN    33      40.153   7.338  21.218  1.00 37.84           O  
ATOM    251  CB  GLN    33      41.266   8.168  23.896  1.00 36.12           C  
ATOM    252  CG  GLN    33      41.620   6.877  24.606  1.00 34.98           C  
ATOM    253  CD  GLN    33      43.026   6.863  25.196  1.00 34.24           C  
ATOM    254  OE1 GLN    33      43.564   7.870  25.593  1.00 31.29           O  
ATOM    255  NE2 GLN    33      43.602   5.718  25.234  1.00 29.63           N  
ATOM    256  N   GLU    34      41.998   6.210  21.231  1.00 40.01           N  
ATOM    257  CA  GLU    34      41.603   5.337  20.148  1.00 41.29           C  
ATOM    258  C   GLU    34      41.154   3.975  20.575  1.00 41.72           C  
ATOM    259  O   GLU    34      41.708   3.386  21.435  1.00 42.17           O  
ATOM    260  CB  GLU    34      42.736   5.204  19.131  1.00 41.31           C  
ATOM    261  N   ILE    35      40.178   3.436  19.902  1.00 42.30           N  
ATOM    262  CA  ILE    35      39.851   2.039  20.071  1.00 42.71           C  
ATOM    263  C   ILE    35      40.975   1.099  19.779  1.00 43.11           C  
ATOM    264  O   ILE    35      41.143   0.149  20.462  1.00 44.11           O  
ATOM    265  CB  ILE    35      38.723   1.629  19.221  1.00 42.57           C  
ATOM    266  CG1 ILE    35      37.485   2.371  19.608  1.00 43.35           C  
ATOM    267  CG2 ILE    35      38.571   0.141  19.222  1.00 42.92           C  
ATOM    268  CD1 ILE    35      36.345   2.021  18.840  1.00 46.42           C  
ATOM    269  N   ALA    36      41.701   1.355  18.711  1.00 42.78           N  
ATOM    270  CA  ALA    36      42.827   0.550  18.264  1.00 42.55           C  
ATOM    271  C   ALA    36      43.504   1.282  17.104  1.00 42.14           C  
ATOM    272  O   ALA    36      42.954   2.237  16.560  1.00 42.00           O  
ATOM    273  CB  ALA    36      42.359  -0.839  17.829  1.00 42.64           C  
ATOM    274  N   PRO    37      44.724   0.879  16.751  1.00 42.20           N  
ATOM    275  CA  PRO    37      45.335   1.512  15.588  1.00 41.84           C  
ATOM    276  C   PRO    37      44.471   1.331  14.347  1.00 41.06           C  
ATOM    277  O   PRO    37      44.054   0.212  14.037  1.00 41.34           O  
ATOM    278  CB  PRO    37      46.663   0.783  15.470  1.00 42.16           C  
ATOM    279  CG  PRO    37      46.938   0.351  16.879  1.00 42.26           C  
ATOM    280  CD  PRO    37      45.628  -0.105  17.364  1.00 41.99           C  
ATOM    281  N   GLY    38      44.156   2.436  13.681  1.00 40.27           N  
ATOM    282  CA  GLY    38      43.343   2.382  12.469  1.00 39.62           C  
ATOM    283  C   GLY    38      41.853   2.425  12.730  1.00 39.24           C  
ATOM    284  O   GLY    38      41.060   2.278  11.805  1.00 38.25           O  
ATOM    285  N   HIS    39      41.470   2.652  13.987  1.00 38.72           N  
ATOM    286  CA  HIS    39      40.072   2.666  14.380  1.00 38.82           C  
ATOM    287  C   HIS    39      39.623   4.045  14.866  1.00 38.20           C  
ATOM    288  O   HIS    39      40.415   4.973  15.001  1.00 38.13           O  
ATOM    289  CB  HIS    39      39.827   1.611  15.462  1.00 39.68           C  
ATOM    290  CG  HIS    39      39.769   0.215  14.936  1.00 40.52           C  
ATOM    291  ND1 HIS    39      40.868  -0.614  14.897  1.00 43.17           N  
ATOM    292  CD2 HIS    39      38.738  -0.495  14.420  1.00 42.67           C  
ATOM    293  CE1 HIS    39      40.521  -1.776  14.373  1.00 44.25           C  
ATOM    294  NE2 HIS    39      39.233  -1.730  14.074  1.00 44.78           N  
ATOM    295  N   TRP    40      38.334   4.163  15.134  1.00 38.25           N  
ATOM    296  CA  TRP    40      37.750   5.394  15.655  1.00 37.81           C  
ATOM    297  C   TRP    40      38.341   5.859  16.983  1.00 36.50           C  
ATOM    298  O   TRP    40      38.780   5.054  17.798  1.00 35.36           O  
ATOM    299  CB  TRP    40      36.252   5.207  15.873  1.00 39.04           C  
ATOM    300  CG  TRP    40      35.405   5.473  14.689  1.00 39.44           C  
ATOM    301  CD1 TRP    40      35.781   5.484  13.367  1.00 39.64           C  
ATOM    302  CD2 TRP    40      34.006   5.731  14.715  1.00 40.61           C  
ATOM    303  NE1 TRP    40      34.677   5.738  12.573  1.00 40.54           N  
ATOM    304  CE2 TRP    40      33.580   5.900  13.380  1.00 40.48           C  
ATOM    305  CE3 TRP    40      33.064   5.835  15.740  1.00 40.53           C  
ATOM    306  CZ2 TRP    40      32.248   6.176  13.053  1.00 41.21           C  
ATOM    307  CZ3 TRP    40      31.741   6.103  15.413  1.00 40.49           C  
ATOM    308  CH2 TRP    40      31.348   6.276  14.084  1.00 40.47           C  
ATOM    309  N   THR    41      38.336   7.182  17.158  1.00 35.70           N  
ATOM    310  CA  THR    41      38.672   7.816  18.409  1.00 35.60           C  
ATOM    311  C   THR    41      37.418   8.109  19.248  1.00 35.89           C  
ATOM    312  O   THR    41      36.267   8.033  18.774  1.00 35.61           O  
ATOM    313  CB  THR    41      39.425   9.146  18.198  1.00 35.61           C  
ATOM    314  OG1 THR    41      38.543  10.090  17.607  1.00 36.06           O  
ATOM    315  CG2 THR    41      40.640   8.968  17.296  1.00 35.36           C  
ATOM    316  N   LEU    42      37.667   8.442  20.506  1.00 36.16           N  
ATOM    317  CA  LEU    42      36.612   8.834  21.451  1.00 36.54           C  
ATOM    318  C   LEU    42      35.827  10.047  20.984  1.00 37.06           C  
ATOM    319  O   LEU    42      34.606  10.095  21.148  1.00 38.12           O  
ATOM    320  CB  LEU    42      37.238   9.078  22.829  1.00 35.87           C  
ATOM    321  CG  LEU    42      36.388   9.581  24.000  1.00 36.67           C  
ATOM    322  CD1 LEU    42      35.058   8.861  24.109  1.00 34.62           C  
ATOM    323  CD2 LEU    42      37.232   9.459  25.299  1.00 35.25           C  
ATOM    324  N   GLY    43      36.539  11.019  20.418  1.00 37.44           N  
ATOM    325  CA  GLY    43      35.949  12.194  19.804  1.00 37.53           C  
ATOM    326  C   GLY    43      34.952  11.844  18.715  1.00 38.35           C  
ATOM    327  O   GLY    43      33.885  12.465  18.640  1.00 38.03           O  
ATOM    328  N   ARG    44      35.263  10.832  17.897  1.00 38.28           N  
ATOM    329  CA  ARG    44      34.332  10.408  16.841  1.00 37.97           C  
ATOM    330  C   ARG    44      33.141   9.619  17.383  1.00 37.69           C  
ATOM    331  O   ARG    44      32.031   9.812  16.929  1.00 36.92           O  
ATOM    332  CB  ARG    44      35.015   9.586  15.748  1.00 38.16           C  
ATOM    333  CG  ARG    44      34.049   9.332  14.580  1.00 41.71           C  
ATOM    334  CD  ARG    44      34.689   9.418  13.191  1.00 45.92           C  
ATOM    335  NE  ARG    44      33.666   9.473  12.141  1.00 46.95           N  
ATOM    336  CZ  ARG    44      33.845   9.080  10.882  1.00 47.95           C  
ATOM    337  NH1 ARG    44      35.001   8.556  10.479  1.00 49.31           N  
ATOM    338  NH2 ARG    44      32.846   9.191  10.017  1.00 47.85           N  
ATOM    339  N   VAL    45      33.379   8.700  18.320  1.00 38.02           N  
ATOM    340  CA  VAL    45      32.286   8.059  19.038  1.00 38.22           C  
ATOM    341  C   VAL    45      31.309   9.088  19.607  1.00 39.42           C  
ATOM    342  O   VAL    45      30.098   8.946  19.408  1.00 41.06           O  
ATOM    343  CB  VAL    45      32.786   7.065  20.129  1.00 38.71           C  
ATOM    344  CG1 VAL    45      31.578   6.411  20.878  1.00 37.23           C  
ATOM    345  CG2 VAL    45      33.651   6.016  19.498  1.00 35.38           C  
ATOM    346  N   ALA    46      31.824  10.160  20.224  1.00 39.15           N  
ATOM    347  CA  ALA    46      30.990  11.162  20.902  1.00 38.95           C  
ATOM    348  C   ALA    46      30.202  12.044  19.919  1.00 38.71           C  
ATOM    349  O   ALA    46      29.030  12.365  20.134  1.00 37.60           O  
ATOM    350  CB  ALA    46      31.858  12.048  21.800  1.00 38.55           C  
ATOM    351  N   TRP    47      30.862  12.484  18.863  1.00 38.76           N  
ATOM    352  CA  TRP    47      30.171  13.244  17.833  1.00 38.83           C  
ATOM    353  C   TRP    47      29.138  12.385  17.064  1.00 38.47           C  
ATOM    354  O   TRP    47      28.131  12.884  16.634  1.00 38.14           O  
ATOM    355  CB  TRP    47      31.189  13.859  16.887  1.00 38.98           C  
ATOM    356  CG  TRP    47      30.676  14.933  16.005  1.00 38.62           C  
ATOM    357  CD1 TRP    47      30.772  14.970  14.660  1.00 38.41           C  
ATOM    358  CD2 TRP    47      30.038  16.160  16.403  1.00 38.34           C  
ATOM    359  NE1 TRP    47      30.228  16.143  14.177  1.00 39.87           N  
ATOM    360  CE2 TRP    47      29.762  16.883  15.229  1.00 37.93           C  
ATOM    361  CE3 TRP    47      29.671  16.712  17.638  1.00 39.22           C  
ATOM    362  CZ2 TRP    47      29.136  18.125  15.244  1.00 39.28           C  
ATOM    363  CZ3 TRP    47      29.052  17.932  17.659  1.00 38.88           C  
ATOM    364  CH2 TRP    47      28.785  18.638  16.466  1.00 39.61           C  
ATOM    365  N   HIS    48      29.393  11.087  16.917  1.00 37.89           N  
ATOM    366  CA  HIS    48      28.448  10.186  16.269  1.00 37.24           C  
ATOM    367  C   HIS    48      27.122  10.134  17.067  1.00 37.41           C  
ATOM    368  O   HIS    48      26.037  10.100  16.486  1.00 36.57           O  
ATOM    369  CB  HIS    48      29.104   8.795  16.145  1.00 37.50           C  
ATOM    370  CG  HIS    48      28.246   7.750  15.500  1.00 37.08           C  
ATOM    371  ND1 HIS    48      27.851   7.817  14.184  1.00 37.73           N  
ATOM    372  CD2 HIS    48      27.805   6.556  15.962  1.00 38.81           C  
ATOM    373  CE1 HIS    48      27.150   6.737  13.881  1.00 38.77           C  
ATOM    374  NE2 HIS    48      27.102   5.956  14.944  1.00 37.37           N  
ATOM    375  N   ILE    49      27.220  10.172  18.395  1.00 36.74           N  
ATOM    376  CA  ILE    49      26.046  10.202  19.304  1.00 36.60           C  
ATOM    377  C   ILE    49      25.247  11.479  19.139  1.00 36.58           C  
ATOM    378  O   ILE    49      24.000  11.486  19.074  1.00 37.69           O  
ATOM    379  CB  ILE    49      26.522  10.076  20.780  1.00 36.62           C  
ATOM    380  CG1 ILE    49      26.917   8.633  21.055  1.00 35.34           C  
ATOM    381  CG2 ILE    49      25.416  10.507  21.821  1.00 36.42           C  
ATOM    382  CD1 ILE    49      27.867   8.474  22.217  1.00 34.26           C  
ATOM    383  N   VAL    50      25.968  12.571  19.059  1.00 36.48           N  
ATOM    384  CA  VAL    50      25.336  13.842  18.869  1.00 35.50           C  
ATOM    385  C   VAL    50      24.554  13.869  17.553  1.00 35.98           C  
ATOM    386  O   VAL    50      23.355  14.204  17.533  1.00 34.52           O  
ATOM    387  CB  VAL    50      26.370  14.959  18.949  1.00 36.20           C  
ATOM    388  CG1 VAL    50      25.698  16.298  18.728  1.00 33.19           C  
ATOM    389  CG2 VAL    50      27.100  14.929  20.338  1.00 33.82           C  
ATOM    390  N   THR    51      25.223  13.474  16.466  1.00 37.01           N  
ATOM    391  CA  THR    51      24.664  13.566  15.129  1.00 37.55           C  
ATOM    392  C   THR    51      23.593  12.530  14.882  1.00 38.58           C  
ATOM    393  O   THR    51      22.703  12.759  14.043  1.00 38.83           O  
ATOM    394  CB  THR    51      25.741  13.435  14.009  1.00 38.09           C  
ATOM    395  OG1 THR    51      26.371  12.143  14.073  1.00 37.78           O  
ATOM    396  CG2 THR    51      26.774  14.468  14.152  1.00 35.80           C  
ATOM    397  N   ALA    52      23.663  11.406  15.611  1.00 39.48           N  
ATOM    398  CA  ALA    52      22.683  10.339  15.510  1.00 39.44           C  
ATOM    399  C   ALA    52      21.254  10.764  15.832  1.00 40.87           C  
ATOM    400  O   ALA    52      20.318  10.121  15.351  1.00 39.51           O  
ATOM    401  CB  ALA    52      23.100   9.112  16.376  1.00 40.12           C  
ATOM    402  N   ILE    53      21.062  11.888  16.559  1.00 41.91           N  
ATOM    403  CA  ILE    53      19.704  12.284  16.963  1.00 42.87           C  
ATOM    404  C   ILE    53      18.884  12.714  15.724  1.00 43.37           C  
ATOM    405  O   ILE    53      17.848  12.093  15.434  1.00 42.52           O  
ATOM    406  CB  ILE    53      19.686  13.334  18.129  1.00 43.00           C  
ATOM    407  CG1 ILE    53      20.106  12.664  19.441  1.00 44.60           C  
ATOM    408  CG2 ILE    53      18.311  13.920  18.328  1.00 43.32           C  
ATOM    409  CD1 ILE    53      20.584  13.644  20.534  1.00 42.31           C  
ATOM    410  N   PRO    54      19.330  13.763  14.994  1.00 43.64           N  
ATOM    411  CA  PRO    54      18.670  14.065  13.720  1.00 43.62           C  
ATOM    412  C   PRO    54      18.713  12.972  12.637  1.00 44.27           C  
ATOM    413  O   PRO    54      17.808  12.945  11.816  1.00 44.52           O  
ATOM    414  CB  PRO    54      19.353  15.357  13.247  1.00 44.47           C  
ATOM    415  CG  PRO    54      20.619  15.465  14.045  1.00 43.73           C  
ATOM    416  CD  PRO    54      20.382  14.742  15.328  1.00 43.31           C  
ATOM    417  N   VAL    55      19.687  12.054  12.647  1.00 43.45           N  
ATOM    418  CA  VAL    55      19.785  11.057  11.578  1.00 43.07           C  
ATOM    419  C   VAL    55      18.745   9.948  11.775  1.00 42.92           C  
ATOM    420  O   VAL    55      18.032   9.547  10.840  1.00 42.72           O  
ATOM    421  CB  VAL    55      21.217  10.481  11.471  1.00 43.39           C  
ATOM    422  CG1 VAL    55      21.263   9.270  10.506  1.00 43.13           C  
ATOM    423  CG2 VAL    55      22.195  11.597  11.039  1.00 41.78           C  
ATOM    424  N   ILE    56      18.646   9.455  13.000  1.00 42.45           N  
ATOM    425  CA  ILE    56      17.669   8.426  13.298  1.00 42.54           C  
ATOM    426  C   ILE    56      16.236   9.016  13.196  1.00 42.86           C  
ATOM    427  O   ILE    56      15.333   8.365  12.701  1.00 43.17           O  
ATOM    428  CB  ILE    56      17.972   7.749  14.665  1.00 42.17           C  
ATOM    429  CG1 ILE    56      19.186   6.815  14.532  1.00 41.57           C  
ATOM    430  CG2 ILE    56      16.740   7.055  15.210  1.00 40.86           C  
ATOM    431  CD1 ILE    56      19.632   6.168  15.866  1.00 40.57           C  
ATOM    432  N   LEU    57      16.016  10.263  13.599  1.00 42.81           N  
ATOM    433  CA  LEU    57      14.644  10.757  13.596  1.00 42.59           C  
ATOM    434  C   LEU    57      14.171  11.323  12.230  1.00 43.44           C  
ATOM    435  O   LEU    57      12.980  11.681  12.073  1.00 42.65           O  
ATOM    436  CB  LEU    57      14.435  11.746  14.755  1.00 43.42           C  
ATOM    437  CG  LEU    57      14.682  11.079  16.128  1.00 42.68           C  
ATOM    438  CD1 LEU    57      14.283  11.922  17.199  1.00 42.04           C  
ATOM    439  CD2 LEU    57      13.925   9.749  16.268  1.00 45.34           C  
ATOM    440  N   SER    58      15.066  11.369  11.237  1.00 43.29           N  
ATOM    441  CA  SER    58      14.771  12.116  10.003  1.00 43.78           C  
ATOM    442  C   SER    58      13.557  11.583   9.256  1.00 43.27           C  
ATOM    443  O   SER    58      12.747  12.355   8.762  1.00 43.22           O  
ATOM    444  CB  SER    58      15.989  12.175   9.065  1.00 44.30           C  
ATOM    445  OG  SER    58      16.311  10.897   8.546  1.00 44.43           O  
ATOM    446  N   GLY    59      13.431  10.262   9.205  1.00 42.77           N  
ATOM    447  CA  GLY    59      12.336   9.607   8.495  1.00 43.05           C  
ATOM    448  C   GLY    59      10.983   9.740   9.166  1.00 42.87           C  
ATOM    449  O   GLY    59       9.965   9.439   8.558  1.00 42.27           O  
ATOM    450  N   THR    60      10.963  10.171  10.425  1.00 43.30           N  
ATOM    451  CA  THR    60       9.695  10.439  11.129  1.00 43.91           C  
ATOM    452  C   THR    60       9.060  11.764  10.654  1.00 44.53           C  
ATOM    453  O   THR    60       7.873  12.014  10.863  1.00 44.89           O  
ATOM    454  CB  THR    60       9.878  10.557  12.660  1.00 43.17           C  
ATOM    455  OG1 THR    60      10.446  11.834  12.957  1.00 41.99           O  
ATOM    456  CG2 THR    60      10.755   9.449  13.213  1.00 44.70           C  
ATOM    457  N   GLY    61       9.863  12.633  10.064  1.00 45.44           N  
ATOM    458  CA  GLY    61       9.346  13.908   9.591  1.00 45.80           C  
ATOM    459  C   GLY    61       9.321  14.978  10.671  1.00 46.83           C  
ATOM    460  O   GLY    61       9.039  16.143  10.380  1.00 46.08           O  
ATOM    461  N   LEU    62       9.626  14.594  11.912  1.00 47.33           N  
ATOM    462  CA  LEU    62       9.760  15.550  13.015  1.00 48.30           C  
ATOM    463  C   LEU    62      11.003  16.407  12.778  1.00 48.48           C  
ATOM    464  O   LEU    62      12.118  15.913  12.828  1.00 49.91           O  
ATOM    465  CB  LEU    62       9.879  14.777  14.327  1.00 48.16           C  
ATOM    466  CG  LEU    62       9.823  15.488  15.671  1.00 48.99           C  
ATOM    467  CD1 LEU    62       8.480  16.168  15.895  1.00 47.52           C  
ATOM    468  CD2 LEU    62      10.100  14.436  16.754  1.00 48.02           C  
ATOM    469  N   LYS    63      10.818  17.693  12.517  1.00 48.89           N  
ATOM    470  CA  LYS    63      11.905  18.530  12.028  1.00 48.59           C  
ATOM    471  C   LYS    63      12.464  19.441  13.137  1.00 48.24           C  
ATOM    472  O   LYS    63      11.704  20.076  13.879  1.00 48.07           O  
ATOM    473  CB  LYS    63      11.418  19.342  10.814  1.00 49.26           C  
ATOM    474  CG  LYS    63      10.922  18.449   9.641  1.00 48.40           C  
ATOM    475  N   PHE    64      13.792  19.478  13.259  1.00 47.14           N  
ATOM    476  CA  PHE    64      14.447  20.338  14.243  1.00 46.77           C  
ATOM    477  C   PHE    64      15.926  20.524  13.913  1.00 47.14           C  
ATOM    478  O   PHE    64      16.523  19.708  13.222  1.00 46.93           O  
ATOM    479  CB  PHE    64      14.293  19.750  15.646  1.00 45.79           C  
ATOM    480  CG  PHE    64      14.836  18.351  15.780  1.00 43.79           C  
ATOM    481  CD1 PHE    64      16.161  18.132  16.138  1.00 40.87           C  
ATOM    482  CD2 PHE    64      14.030  17.265  15.520  1.00 42.88           C  
ATOM    483  CE1 PHE    64      16.660  16.848  16.251  1.00 42.93           C  
ATOM    484  CE2 PHE    64      14.518  15.994  15.641  1.00 41.21           C  
ATOM    485  CZ  PHE    64      15.847  15.787  16.000  1.00 42.35           C  
ATOM    486  N   GLU    65      16.508  21.596  14.427  1.00 47.28           N  
ATOM    487  CA  GLU    65      17.889  21.962  14.106  1.00 47.91           C  
ATOM    488  C   GLU    65      18.893  20.968  14.727  1.00 47.50           C  
ATOM    489  O   GLU    65      18.722  20.540  15.871  1.00 47.17           O  
ATOM    490  CB  GLU    65      18.162  23.386  14.584  1.00 47.85           C  
ATOM    491  CG  GLU    65      19.431  24.043  14.032  1.00 49.87           C  
ATOM    492  N   GLY    66      19.917  20.599  13.953  1.00 46.99           N  
ATOM    493  CA  GLY    66      20.978  19.708  14.426  1.00 46.66           C  
ATOM    494  C   GLY    66      21.882  19.204  13.317  1.00 46.16           C  
ATOM    495  O   GLY    66      21.399  18.713  12.295  1.00 46.83           O  
ATOM    496  N   GLU    67      23.193  19.306  13.526  1.00 45.14           N  
ATOM    497  CA  GLU    67      24.190  18.735  12.609  1.00 44.58           C  
ATOM    498  C   GLU    67      23.947  17.241  12.433  1.00 43.64           C  
ATOM    499  O   GLU    67      23.686  16.576  13.408  1.00 43.39           O  
ATOM    500  CB  GLU    67      25.602  18.935  13.171  1.00 44.62           C  
ATOM    501  CG  GLU    67      26.722  18.414  12.286  1.00 45.82           C  
ATOM    502  CD  GLU    67      26.649  18.981  10.883  1.00 48.02           C  
ATOM    503  OE1 GLU    67      26.896  20.205  10.749  1.00 49.57           O  
ATOM    504  OE2 GLU    67      26.331  18.211   9.936  1.00 47.88           O  
ATOM    505  N   THR    68      24.057  16.754  11.196  1.00 43.40           N  
ATOM    506  CA  THR    68      23.815  15.353  10.828  1.00 43.81           C  
ATOM    507  C   THR    68      25.062  14.608  10.292  1.00 43.32           C  
ATOM    508  O   THR    68      25.062  13.375  10.193  1.00 43.61           O  
ATOM    509  CB  THR    68      22.682  15.260   9.760  1.00 44.60           C  
ATOM    510  OG1 THR    68      23.040  16.030   8.608  1.00 44.60           O  
ATOM    511  CG2 THR    68      21.339  15.782  10.317  1.00 44.27           C  
ATOM    512  N   LYS    69      26.113  15.346   9.937  1.00 42.95           N  
ATOM    513  CA  LYS    69      27.360  14.748   9.426  1.00 42.71           C  
ATOM    514  C   LYS    69      28.367  14.499  10.552  1.00 42.24           C  
ATOM    515  O   LYS    69      28.805  15.432  11.222  1.00 41.49           O  
ATOM    516  CB  LYS    69      27.982  15.665   8.365  1.00 43.12           C  
ATOM    517  N   ASP    70      28.754  13.242  10.751  1.00 42.33           N  
ATOM    518  CA  ASP    70      29.666  12.900  11.844  1.00 42.59           C  
ATOM    519  C   ASP    70      31.152  13.014  11.461  1.00 42.55           C  
ATOM    520  O   ASP    70      32.018  12.600  12.225  1.00 42.47           O  
ATOM    521  CB  ASP    70      29.300  11.531  12.500  1.00 42.89           C  
ATOM    522  CG  ASP    70      29.642  10.330  11.638  1.00 44.57           C  
ATOM    523  OD1 ASP    70      30.098  10.523  10.493  1.00 47.83           O  
ATOM    524  OD2 ASP    70      29.440   9.183  12.099  1.00 44.97           O  
ATOM    525  N   TYR    71      31.428  13.594  10.290  1.00 42.85           N  
ATOM    526  CA  TYR    71      32.783  13.917   9.856  1.00 42.91           C  
ATOM    527  C   TYR    71      32.710  15.258   9.139  1.00 42.56           C  
ATOM    528  O   TYR    71      31.804  15.477   8.342  1.00 43.39           O  
ATOM    529  CB  TYR    71      33.366  12.843   8.914  1.00 43.24           C  
ATOM    530  CG  TYR    71      34.905  12.846   8.805  1.00 42.94           C  
ATOM    531  CD1 TYR    71      35.697  12.097   9.698  1.00 43.93           C  
ATOM    532  CD2 TYR    71      35.557  13.579   7.817  1.00 42.74           C  
ATOM    533  CE1 TYR    71      37.104  12.091   9.606  1.00 43.63           C  
ATOM    534  CE2 TYR    71      36.954  13.576   7.706  1.00 43.03           C  
ATOM    535  CZ  TYR    71      37.730  12.831   8.600  1.00 44.06           C  
ATOM    536  OH  TYR    71      39.125  12.835   8.488  1.00 43.45           O  
ATOM    537  N   PRO    72      33.625  16.189   9.455  1.00 41.60           N  
ATOM    538  CA  PRO    72      34.725  16.088  10.394  1.00 40.90           C  
ATOM    539  C   PRO    72      34.244  16.180  11.843  1.00 40.00           C  
ATOM    540  O   PRO    72      33.101  16.563  12.113  1.00 39.44           O  
ATOM    541  CB  PRO    72      35.598  17.290  10.021  1.00 40.75           C  
ATOM    542  CG  PRO    72      34.642  18.284   9.584  1.00 41.25           C  
ATOM    543  CD  PRO    72      33.563  17.535   8.860  1.00 41.61           C  
ATOM    544  N   VAL    73      35.116  15.796  12.758  1.00 39.25           N  
ATOM    545  CA  VAL    73      34.790  15.771  14.166  1.00 38.70           C  
ATOM    546  C   VAL    73      35.314  17.074  14.791  1.00 38.13           C  
ATOM    547  O   VAL    73      36.446  17.478  14.519  1.00 38.73           O  
ATOM    548  CB  VAL    73      35.452  14.569  14.854  1.00 38.74           C  
ATOM    549  CG1 VAL    73      35.151  14.567  16.354  1.00 38.20           C  
ATOM    550  CG2 VAL    73      35.013  13.269  14.191  1.00 39.08           C  
ATOM    551  N   PRO    74      34.517  17.727  15.655  1.00 37.44           N  
ATOM    552  CA  PRO    74      35.051  18.883  16.382  1.00 36.76           C  
ATOM    553  C   PRO    74      36.312  18.587  17.184  1.00 36.56           C  
ATOM    554  O   PRO    74      36.464  17.485  17.707  1.00 35.92           O  
ATOM    555  CB  PRO    74      33.907  19.239  17.334  1.00 36.40           C  
ATOM    556  CG  PRO    74      32.712  18.794  16.639  1.00 35.99           C  
ATOM    557  CD  PRO    74      33.106  17.491  16.010  1.00 37.63           C  
ATOM    558  N   THR    75      37.197  19.577  17.308  1.00 37.11           N  
ATOM    559  CA  THR    75      38.420  19.400  18.104  1.00 37.55           C  
ATOM    560  C   THR    75      38.298  19.809  19.582  1.00 38.15           C  
ATOM    561  O   THR    75      39.186  19.506  20.388  1.00 37.83           O  
ATOM    562  CB  THR    75      39.637  20.078  17.456  1.00 37.85           C  
ATOM    563  OG1 THR    75      39.406  21.479  17.284  1.00 36.14           O  
ATOM    564  CG2 THR    75      39.914  19.428  16.094  1.00 38.81           C  
ATOM    565  N   SER    76      37.189  20.449  19.949  1.00 37.93           N  
ATOM    566  CA  SER    76      36.993  20.911  21.313  1.00 37.91           C  
ATOM    567  C   SER    76      35.887  20.136  21.959  1.00 37.58           C  
ATOM    568  O   SER    76      34.809  20.014  21.382  1.00 37.85           O  
ATOM    569  CB  SER    76      36.635  22.399  21.320  1.00 38.14           C  
ATOM    570  OG  SER    76      35.824  22.693  22.444  1.00 39.20           O  
ATOM    571  N   ALA    77      36.133  19.606  23.156  1.00 37.95           N  
ATOM    572  CA  ALA    77      35.137  18.753  23.821  1.00 38.33           C  
ATOM    573  C   ALA    77      33.931  19.597  24.265  1.00 38.87           C  
ATOM    574  O   ALA    77      32.819  19.078  24.436  1.00 38.94           O  
ATOM    575  CB  ALA    77      35.742  17.988  24.990  1.00 38.12           C  
ATOM    576  N   LYS    78      34.130  20.907  24.370  1.00 39.08           N  
ATOM    577  CA  LYS    78      33.032  21.806  24.723  1.00 39.75           C  
ATOM    578  C   LYS    78      32.038  21.915  23.581  1.00 39.51           C  
ATOM    579  O   LYS    78      30.839  21.982  23.819  1.00 40.22           O  
ATOM    580  CB  LYS    78      33.523  23.197  25.118  1.00 39.29           C  
ATOM    581  CG  LYS    78      32.574  23.869  26.098  1.00 40.21           C  
ATOM    582  CD  LYS    78      33.048  25.265  26.529  1.00 40.61           C  
ATOM    583  CE  LYS    78      32.139  26.352  25.985  1.00 42.02           C  
ATOM    584  NZ  LYS    78      30.808  26.307  26.638  1.00 42.42           N  
ATOM    585  N   THR    79      32.529  21.930  22.345  1.00 39.41           N  
ATOM    586  CA  THR    79      31.637  21.886  21.184  1.00 39.10           C  
ATOM    587  C   THR    79      30.776  20.638  21.160  1.00 38.89           C  
ATOM    588  O   THR    79      29.597  20.711  20.832  1.00 40.76           O  
ATOM    589  CB  THR    79      32.399  22.005  19.859  1.00 38.85           C  
ATOM    590  OG1 THR    79      33.154  23.214  19.869  1.00 38.67           O  
ATOM    591  CG2 THR    79      31.429  22.065  18.683  1.00 39.84           C  
ATOM    592  N   ILE    80      31.358  19.496  21.500  1.00 37.87           N  
ATOM    593  CA  ILE    80      30.642  18.224  21.465  1.00 37.23           C  
ATOM    594  C   ILE    80      29.556  18.137  22.544  1.00 36.97           C  
ATOM    595  O   ILE    80      28.392  17.854  22.253  1.00 37.19           O  
ATOM    596  CB  ILE    80      31.627  17.027  21.568  1.00 36.96           C  
ATOM    597  CG1 ILE    80      32.624  17.060  20.379  1.00 36.88           C  
ATOM    598  CG2 ILE    80      30.864  15.675  21.647  1.00 35.26           C  
ATOM    599  CD1 ILE    80      33.641  15.932  20.348  1.00 37.46           C  
ATOM    600  N   ALA    81      29.937  18.377  23.789  1.00 36.74           N  
ATOM    601  CA  ALA    81      29.006  18.343  24.910  1.00 36.66           C  
ATOM    602  C   ALA    81      27.873  19.378  24.744  1.00 37.19           C  
ATOM    603  O   ALA    81      26.700  19.092  25.046  1.00 36.55           O  
ATOM    604  CB  ALA    81      29.777  18.567  26.224  1.00 37.06           C  
ATOM    605  N   ASP    82      28.219  20.572  24.259  1.00 37.79           N  
ATOM    606  CA  ASP    82      27.231  21.625  24.043  1.00 38.43           C  
ATOM    607  C   ASP    82      26.311  21.309  22.875  1.00 38.88           C  
ATOM    608  O   ASP    82      25.102  21.470  22.976  1.00 38.28           O  
ATOM    609  CB  ASP    82      27.900  22.979  23.835  1.00 38.51           C  
ATOM    610  CG  ASP    82      28.488  23.539  25.127  1.00 40.46           C  
ATOM    611  OD1 ASP    82      28.625  22.771  26.119  1.00 42.63           O  
ATOM    612  OD2 ASP    82      28.834  24.734  25.154  1.00 33.97           O  
ATOM    613  N   GLY    83      26.895  20.847  21.772  1.00 40.13           N  
ATOM    614  CA  GLY    83      26.137  20.242  20.672  1.00 40.53           C  
ATOM    615  C   GLY    83      25.089  19.235  21.105  1.00 40.91           C  
ATOM    616  O   GLY    83      23.944  19.333  20.687  1.00 41.21           O  
ATOM    617  N   TYR    84      25.469  18.265  21.928  1.00 41.63           N  
ATOM    618  CA  TYR    84      24.503  17.292  22.452  1.00 41.56           C  
ATOM    619  C   TYR    84      23.374  17.990  23.233  1.00 42.71           C  
ATOM    620  O   TYR    84      22.211  17.671  23.042  1.00 42.92           O  
ATOM    621  CB  TYR    84      25.180  16.286  23.363  1.00 41.30           C  
ATOM    622  CG  TYR    84      24.276  15.137  23.762  1.00 40.64           C  
ATOM    623  CD1 TYR    84      23.985  14.118  22.877  1.00 41.04           C  
ATOM    624  CD2 TYR    84      23.696  15.092  25.018  1.00 40.97           C  
ATOM    625  CE1 TYR    84      23.169  13.065  23.241  1.00 40.97           C  
ATOM    626  CE2 TYR    84      22.863  14.073  25.382  1.00 39.98           C  
ATOM    627  CZ  TYR    84      22.604  13.057  24.499  1.00 40.99           C  
ATOM    628  OH  TYR    84      21.786  12.029  24.880  1.00 40.71           O  
ATOM    629  N   ARG    85      23.725  18.935  24.101  1.00 43.13           N  
ATOM    630  CA  ARG    85      22.735  19.630  24.915  1.00 44.43           C  
ATOM    631  C   ARG    85      21.742  20.346  24.009  1.00 44.49           C  
ATOM    632  O   ARG    85      20.531  20.215  24.184  1.00 45.40           O  
ATOM    633  CB  ARG    85      23.402  20.640  25.857  1.00 44.20           C  
ATOM    634  CG  ARG    85      22.413  21.416  26.727  1.00 45.42           C  
ATOM    635  CD  ARG    85      23.081  22.302  27.766  1.00 46.23           C  
ATOM    636  NE  ARG    85      23.894  21.513  28.691  1.00 47.92           N  
ATOM    637  CZ  ARG    85      25.228  21.473  28.711  1.00 49.12           C  
ATOM    638  NH1 ARG    85      25.963  22.210  27.870  1.00 49.26           N  
ATOM    639  NH2 ARG    85      25.838  20.690  29.603  1.00 49.86           N  
ATOM    640  N   LYS    86      22.285  21.078  23.038  1.00 44.41           N  
ATOM    641  CA  LYS    86      21.524  21.907  22.092  1.00 44.22           C  
ATOM    642  C   LYS    86      20.519  21.090  21.292  1.00 44.21           C  
ATOM    643  O   LYS    86      19.328  21.437  21.238  1.00 44.20           O  
ATOM    644  CB  LYS    86      22.497  22.582  21.113  1.00 44.43           C  
ATOM    645  CG  LYS    86      22.184  24.005  20.742  1.00 44.56           C  
ATOM    646  CD  LYS    86      23.377  24.630  20.012  1.00 44.07           C  
ATOM    647  N   VAL    87      20.999  20.014  20.670  1.00 43.34           N  
ATOM    648  CA  VAL    87      20.168  19.228  19.768  1.00 43.89           C  
ATOM    649  C   VAL    87      19.150  18.360  20.517  1.00 43.64           C  
ATOM    650  O   VAL    87      18.048  18.135  20.023  1.00 43.37           O  
ATOM    651  CB  VAL    87      21.004  18.366  18.782  1.00 43.25           C  
ATOM    652  CG1 VAL    87      21.605  17.148  19.465  1.00 44.08           C  
ATOM    653  CG2 VAL    87      20.137  17.958  17.625  1.00 44.87           C  
ATOM    654  N   ASN    88      19.508  17.892  21.712  1.00 43.54           N  
ATOM    655  CA  ASN    88      18.537  17.209  22.557  1.00 43.84           C  
ATOM    656  C   ASN    88      17.379  18.147  22.921  1.00 42.62           C  
ATOM    657  O   ASN    88      16.228  17.764  22.876  1.00 42.64           O  
ATOM    658  CB  ASN    88      19.175  16.635  23.827  1.00 44.30           C  
ATOM    659  CG  ASN    88      18.201  15.759  24.605  1.00 46.95           C  
ATOM    660  OD1 ASN    88      17.648  14.805  24.059  1.00 53.28           O  
ATOM    661  ND2 ASN    88      17.948  16.106  25.857  1.00 48.55           N  
ATOM    662  N   THR    89      17.692  19.388  23.261  1.00 41.84           N  
ATOM    663  CA  THR    89      16.667  20.354  23.578  1.00 40.67           C  
ATOM    664  C   THR    89      15.751  20.638  22.388  1.00 39.96           C  
ATOM    665  O   THR    89      14.524  20.697  22.544  1.00 39.37           O  
ATOM    666  CB  THR    89      17.290  21.647  24.091  1.00 40.97           C  
ATOM    667  OG1 THR    89      17.883  21.385  25.363  1.00 41.62           O  
ATOM    668  CG2 THR    89      16.244  22.742  24.251  1.00 40.72           C  
ATOM    669  N   ALA    90      16.338  20.816  21.208  1.00 38.61           N  
ATOM    670  CA  ALA    90      15.552  21.081  20.004  1.00 37.69           C  
ATOM    671  C   ALA    90      14.692  19.851  19.685  1.00 36.75           C  
ATOM    672  O   ALA    90      13.558  19.938  19.240  1.00 35.66           O  
ATOM    673  CB  ALA    90      16.476  21.405  18.846  1.00 37.51           C  
ATOM    674  N   PHE    91      15.236  18.688  19.940  1.00 36.98           N  
ATOM    675  CA  PHE    91      14.496  17.474  19.649  1.00 36.00           C  
ATOM    676  C   PHE    91      13.246  17.372  20.529  1.00 36.57           C  
ATOM    677  O   PHE    91      12.120  17.292  20.032  1.00 34.89           O  
ATOM    678  CB  PHE    91      15.387  16.256  19.855  1.00 36.99           C  
ATOM    679  CG  PHE    91      14.620  14.973  19.985  1.00 35.67           C  
ATOM    680  CD1 PHE    91      13.551  14.704  19.143  1.00 38.06           C  
ATOM    681  CD2 PHE    91      14.934  14.059  20.977  1.00 36.48           C  
ATOM    682  CE1 PHE    91      12.827  13.483  19.261  1.00 36.10           C  
ATOM    683  CE2 PHE    91      14.205  12.875  21.113  1.00 37.37           C  
ATOM    684  CZ  PHE    91      13.151  12.607  20.255  1.00 36.55           C  
ATOM    685  N   VAL    92      13.476  17.404  21.841  1.00 37.94           N  
ATOM    686  CA  VAL    92      12.452  17.205  22.863  1.00 38.72           C  
ATOM    687  C   VAL    92      11.400  18.314  22.786  1.00 40.34           C  
ATOM    688  O   VAL    92      10.218  18.099  23.079  1.00 40.64           O  
ATOM    689  CB  VAL    92      13.129  17.126  24.261  1.00 38.71           C  
ATOM    690  CG1 VAL    92      12.144  17.330  25.406  1.00 38.25           C  
ATOM    691  CG2 VAL    92      13.867  15.772  24.400  1.00 38.04           C  
ATOM    692  N   GLU    93      11.837  19.492  22.366  1.00 41.44           N  
ATOM    693  CA  GLU    93      10.924  20.605  22.132  1.00 42.47           C  
ATOM    694  C   GLU    93      10.005  20.329  20.947  1.00 42.47           C  
ATOM    695  O   GLU    93       8.831  20.693  20.976  1.00 42.48           O  
ATOM    696  CB  GLU    93      11.703  21.891  21.919  1.00 42.35           C  
ATOM    697  CG  GLU    93      12.082  22.588  23.222  1.00 43.35           C  
ATOM    698  CD  GLU    93      12.877  23.865  22.983  1.00 44.62           C  
ATOM    699  OE1 GLU    93      13.485  23.974  21.886  1.00 48.71           O  
ATOM    700  OE2 GLU    93      12.904  24.749  23.879  1.00 44.16           O  
ATOM    701  N   ALA    94      10.529  19.659  19.923  1.00 42.55           N  
ATOM    702  CA  ALA    94       9.744  19.392  18.716  1.00 42.83           C  
ATOM    703  C   ALA    94       8.751  18.265  18.979  1.00 42.87           C  
ATOM    704  O   ALA    94       7.604  18.324  18.549  1.00 42.78           O  
ATOM    705  CB  ALA    94      10.647  19.072  17.533  1.00 42.51           C  
ATOM    706  N   LEU    95       9.197  17.259  19.719  1.00 43.07           N  
ATOM    707  CA  LEU    95       8.347  16.140  20.101  1.00 43.63           C  
ATOM    708  C   LEU    95       7.153  16.647  20.912  1.00 44.22           C  
ATOM    709  O   LEU    95       6.023  16.252  20.655  1.00 44.02           O  
ATOM    710  CB  LEU    95       9.150  15.113  20.916  1.00 43.35           C  
ATOM    711  CG  LEU    95       8.613  13.678  20.961  1.00 44.47           C  
ATOM    712  CD1 LEU    95       9.029  12.945  19.715  1.00 44.85           C  
ATOM    713  CD2 LEU    95       9.125  12.934  22.177  1.00 44.58           C  
ATOM    714  N   GLN    96       7.405  17.523  21.884  1.00 44.66           N  
ATOM    715  CA  GLN    96       6.337  18.010  22.767  1.00 45.73           C  
ATOM    716  C   GLN    96       5.367  18.947  22.041  1.00 45.50           C  
ATOM    717  O   GLN    96       4.181  18.988  22.371  1.00 44.91           O  
ATOM    718  CB  GLN    96       6.910  18.696  24.018  1.00 45.79           C  
ATOM    719  CG  GLN    96       7.446  17.716  25.079  1.00 47.48           C  
ATOM    720  CD  GLN    96       8.238  18.399  26.191  1.00 47.89           C  
ATOM    721  OE1 GLN    96       9.012  17.752  26.904  1.00 52.61           O  
ATOM    722  NE2 GLN    96       8.066  19.708  26.330  1.00 50.79           N  
ATOM    723  N   SER    97       5.879  19.689  21.058  1.00 45.59           N  
ATOM    724  CA  SER    97       5.062  20.610  20.267  1.00 45.39           C  
ATOM    725  C   SER    97       4.186  19.882  19.268  1.00 44.94           C  
ATOM    726  O   SER    97       2.999  20.197  19.144  1.00 44.29           O  
ATOM    727  CB  SER    97       5.946  21.573  19.489  1.00 45.21           C  
ATOM    728  OG  SER    97       6.738  22.327  20.376  1.00 47.85           O  
ATOM    729  N   GLU    98       4.770  18.909  18.563  1.00 44.39           N  
ATOM    730  CA  GLU    98       4.132  18.339  17.376  1.00 44.11           C  
ATOM    731  C   GLU    98       3.443  16.988  17.566  1.00 44.04           C  
ATOM    732  O   GLU    98       2.494  16.690  16.845  1.00 44.30           O  
ATOM    733  CB  GLU    98       5.128  18.292  16.212  1.00 43.90           C  
ATOM    734  CG  GLU    98       5.685  19.691  15.814  1.00 44.83           C  
ATOM    735  CD  GLU    98       4.638  20.610  15.166  1.00 43.08           C  
ATOM    736  N   TRP    99       3.888  16.174  18.519  1.00 43.90           N  
ATOM    737  CA  TRP    99       3.322  14.836  18.696  1.00 43.46           C  
ATOM    738  C   TRP    99       2.442  14.735  19.934  1.00 42.97           C  
ATOM    739  O   TRP    99       2.682  15.429  20.933  1.00 42.89           O  
ATOM    740  CB  TRP    99       4.432  13.775  18.781  1.00 44.11           C  
ATOM    741  CG  TRP    99       5.109  13.464  17.469  1.00 44.44           C  
ATOM    742  CD1 TRP    99       4.946  14.119  16.279  1.00 45.11           C  
ATOM    743  CD2 TRP    99       6.097  12.448  17.233  1.00 44.70           C  
ATOM    744  NE1 TRP    99       5.755  13.557  15.316  1.00 45.68           N  
ATOM    745  CE2 TRP    99       6.474  12.536  15.876  1.00 44.29           C  
ATOM    746  CE3 TRP    99       6.698  11.480  18.034  1.00 43.74           C  
ATOM    747  CZ2 TRP    99       7.421  11.695  15.306  1.00 44.86           C  
ATOM    748  CZ3 TRP    99       7.644  10.629  17.460  1.00 45.39           C  
ATOM    749  CH2 TRP    99       7.989  10.741  16.109  1.00 44.90           C  
ATOM    750  N   THR   100       1.425  13.871  19.839  1.00 41.65           N  
ATOM    751  CA  THR   100       0.652  13.383  20.981  1.00 41.00           C  
ATOM    752  C   THR   100       0.813  11.852  20.992  1.00 40.50           C  
ATOM    753  O   THR   100       1.514  11.314  20.141  1.00 40.72           O  
ATOM    754  CB  THR   100      -0.846  13.812  20.897  1.00 40.77           C  
ATOM    755  OG1 THR   100      -1.404  13.441  19.629  1.00 40.49           O  
ATOM    756  CG2 THR   100      -0.992  15.327  21.057  1.00 40.81           C  
ATOM    757  N   ASP   101       0.187  11.146  21.929  1.00 39.96           N  
ATOM    758  CA  ASP   101       0.385   9.675  22.036  1.00 40.12           C  
ATOM    759  C   ASP   101       0.125   8.875  20.757  1.00 39.90           C  
ATOM    760  O   ASP   101       0.769   7.839  20.539  1.00 39.45           O  
ATOM    761  CB  ASP   101      -0.492   9.063  23.133  1.00 40.35           C  
ATOM    762  CG  ASP   101      -0.235   9.655  24.507  1.00 41.58           C  
ATOM    763  OD1 ASP   101       0.874  10.173  24.753  1.00 43.38           O  
ATOM    764  OD2 ASP   101      -1.165   9.602  25.344  1.00 43.32           O  
ATOM    765  N   LYS   102      -0.849   9.317  19.950  1.00 39.81           N  
ATOM    766  CA  LYS   102      -1.244   8.609  18.724  1.00 39.58           C  
ATOM    767  C   LYS   102      -0.172   8.589  17.628  1.00 39.56           C  
ATOM    768  O   LYS   102      -0.036   7.594  16.897  1.00 40.62           O  
ATOM    769  CB  LYS   102      -2.572   9.146  18.167  1.00 39.80           C  
ATOM    770  CG  LYS   102      -2.571  10.528  17.525  1.00 39.75           C  
ATOM    771  CD  LYS   102      -4.014  10.963  17.217  1.00 40.05           C  
ATOM    772  CE  LYS   102      -4.091  12.418  16.750  1.00 41.68           C  
ATOM    773  NZ  LYS   102      -5.506  12.928  16.619  1.00 42.03           N  
ATOM    774  N   ASP   103       0.599   9.667  17.552  1.00 39.64           N  
ATOM    775  CA  ASP   103       1.687   9.806  16.598  1.00 39.19           C  
ATOM    776  C   ASP   103       2.753   8.704  16.736  1.00 38.64           C  
ATOM    777  O   ASP   103       3.510   8.433  15.799  1.00 38.48           O  
ATOM    778  CB  ASP   103       2.345  11.167  16.772  1.00 39.27           C  
ATOM    779  CG  ASP   103       1.439  12.312  16.386  1.00 39.58           C  
ATOM    780  OD1 ASP   103       1.247  12.555  15.174  1.00 40.37           O  
ATOM    781  OD2 ASP   103       0.932  13.000  17.297  1.00 40.06           O  
ATOM    782  N   LEU   104       2.825   8.086  17.909  1.00 37.92           N  
ATOM    783  CA  LEU   104       3.742   6.980  18.125  1.00 37.58           C  
ATOM    784  C   LEU   104       3.402   5.768  17.262  1.00 36.67           C  
ATOM    785  O   LEU   104       4.255   4.897  17.073  1.00 37.21           O  
ATOM    786  CB  LEU   104       3.771   6.579  19.598  1.00 37.60           C  
ATOM    787  CG  LEU   104       4.409   7.599  20.533  1.00 38.72           C  
ATOM    788  CD1 LEU   104       4.135   7.239  21.987  1.00 38.99           C  
ATOM    789  CD2 LEU   104       5.902   7.686  20.264  1.00 38.50           C  
ATOM    790  N   THR   105       2.158   5.698  16.767  1.00 35.51           N  
ATOM    791  CA  THR   105       1.721   4.617  15.876  1.00 34.57           C  
ATOM    792  C   THR   105       1.897   4.923  14.386  1.00 33.86           C  
ATOM    793  O   THR   105       1.828   4.030  13.565  1.00 32.73           O  
ATOM    794  CB  THR   105       0.226   4.240  16.105  1.00 34.44           C  
ATOM    795  OG1 THR   105      -0.630   5.312  15.676  1.00 34.26           O  
ATOM    796  CG2 THR   105      -0.032   3.932  17.572  1.00 35.11           C  
ATOM    797  N   THR   106       2.078   6.184  14.009  1.00 33.40           N  
ATOM    798  CA  THR   106       2.235   6.511  12.594  1.00 33.85           C  
ATOM    799  C   THR   106       3.410   5.787  11.976  1.00 35.81           C  
ATOM    800  O   THR   106       4.544   5.879  12.469  1.00 36.15           O  
ATOM    801  CB  THR   106       2.433   8.013  12.428  1.00 34.10           C  
ATOM    802  OG1 THR   106       1.414   8.638  13.188  1.00 31.30           O  
ATOM    803  CG2 THR   106       2.327   8.420  10.959  1.00 34.03           C  
ATOM    804  N   ILE   107       3.132   5.025  10.920  1.00 38.13           N  
ATOM    805  CA  ILE   107       4.158   4.261  10.213  1.00 39.30           C  
ATOM    806  C   ILE   107       4.981   5.173   9.307  1.00 40.57           C  
ATOM    807  O   ILE   107       4.429   5.895   8.477  1.00 40.68           O  
ATOM    808  CB  ILE   107       3.529   3.114   9.412  1.00 39.46           C  
ATOM    809  CG1 ILE   107       3.043   2.027  10.371  1.00 39.21           C  
ATOM    810  CG2 ILE   107       4.549   2.512   8.452  1.00 41.13           C  
ATOM    811  CD1 ILE   107       2.244   0.962   9.685  1.00 38.98           C  
ATOM    812  N   ASN   108       6.302   5.183   9.514  1.00 41.61           N  
ATOM    813  CA  ASN   108       7.226   5.941   8.673  1.00 42.13           C  
ATOM    814  C   ASN   108       8.345   5.016   8.148  1.00 43.07           C  
ATOM    815  O   ASN   108       8.456   3.821   8.511  1.00 43.07           O  
ATOM    816  CB  ASN   108       7.791   7.132   9.443  1.00 42.42           C  
ATOM    817  CG  ASN   108       6.890   8.360   9.402  1.00 43.28           C  
ATOM    818  OD1 ASN   108       6.703   8.971   8.351  1.00 42.03           O  
ATOM    819  ND2 ASN   108       6.370   8.759  10.563  1.00 45.25           N  
ATOM    820  N   ASP   109       9.155   5.564   7.259  1.00 44.42           N  
ATOM    821  CA  ASP   109      10.191   4.796   6.604  1.00 45.61           C  
ATOM    822  C   ASP   109      11.493   4.922   7.361  1.00 45.73           C  
ATOM    823  O   ASP   109      12.034   6.025   7.476  1.00 44.24           O  
ATOM    824  CB  ASP   109      10.394   5.295   5.178  1.00 46.20           C  
ATOM    825  CG  ASP   109      11.490   4.541   4.457  1.00 48.35           C  
ATOM    826  OD1 ASP   109      11.393   3.292   4.368  1.00 54.39           O  
ATOM    827  OD2 ASP   109      12.451   5.188   3.989  1.00 51.03           O  
ATOM    828  N   PHE   110      12.011   3.805   7.872  1.00 46.52           N  
ATOM    829  CA  PHE   110      13.354   3.834   8.470  1.00 47.64           C  
ATOM    830  C   PHE   110      14.370   3.250   7.512  1.00 48.40           C  
ATOM    831  O   PHE   110      14.465   2.031   7.360  1.00 46.87           O  
ATOM    832  CB  PHE   110      13.432   3.133   9.827  1.00 48.31           C  
ATOM    833  CG  PHE   110      14.798   3.279  10.495  1.00 49.63           C  
ATOM    834  CD1 PHE   110      15.256   4.535  10.910  1.00 49.78           C  
ATOM    835  CD2 PHE   110      15.640   2.190  10.660  1.00 51.36           C  
ATOM    836  CE1 PHE   110      16.530   4.685  11.507  1.00 50.52           C  
ATOM    837  CE2 PHE   110      16.911   2.336  11.254  1.00 50.54           C  
ATOM    838  CZ  PHE   110      17.346   3.587  11.685  1.00 51.58           C  
ATOM    839  N   PHE   111      15.103   4.133   6.839  1.00 49.53           N  
ATOM    840  CA  PHE   111      16.111   3.712   5.870  1.00 51.07           C  
ATOM    841  C   PHE   111      15.669   2.458   5.100  1.00 51.26           C  
ATOM    842  O   PHE   111      16.360   1.437   5.113  1.00 51.68           O  
ATOM    843  CB  PHE   111      17.452   3.440   6.570  1.00 51.89           C  
ATOM    844  CG  PHE   111      17.985   4.614   7.351  1.00 52.62           C  
ATOM    845  CD1 PHE   111      18.174   5.854   6.733  1.00 54.80           C  
ATOM    846  CD2 PHE   111      18.287   4.487   8.692  1.00 52.93           C  
ATOM    847  CE1 PHE   111      18.658   6.948   7.451  1.00 53.82           C  
ATOM    848  CE2 PHE   111      18.773   5.575   9.419  1.00 54.61           C  
ATOM    849  CZ  PHE   111      18.955   6.808   8.787  1.00 53.77           C  
ATOM    850  N   GLY   112      14.504   2.524   4.466  1.00 51.34           N  
ATOM    851  CA  GLY   112      14.030   1.412   3.625  1.00 51.36           C  
ATOM    852  C   GLY   112      12.917   0.541   4.188  1.00 51.10           C  
ATOM    853  O   GLY   112      12.110   0.033   3.426  1.00 51.41           O  
ATOM    854  N   ARG   113      12.864   0.349   5.506  1.00 50.84           N  
ATOM    855  CA  ARG   113      11.790  -0.462   6.103  1.00 50.80           C  
ATOM    856  C   ARG   113      10.723   0.413   6.788  1.00 49.66           C  
ATOM    857  O   ARG   113      11.048   1.428   7.389  1.00 49.62           O  
ATOM    858  CB  ARG   113      12.348  -1.553   7.040  1.00 51.29           C  
ATOM    859  CG  ARG   113      13.239  -1.084   8.214  1.00 52.28           C  
ATOM    860  CD  ARG   113      14.124  -2.262   8.714  1.00 52.16           C  
ATOM    861  N   PRO   114       9.435   0.047   6.649  1.00 48.76           N  
ATOM    862  CA  PRO   114       8.375   0.810   7.306  1.00 47.97           C  
ATOM    863  C   PRO   114       8.189   0.360   8.759  1.00 46.80           C  
ATOM    864  O   PRO   114       8.054  -0.825   9.027  1.00 47.46           O  
ATOM    865  CB  PRO   114       7.140   0.506   6.449  1.00 47.96           C  
ATOM    866  CG  PRO   114       7.379  -0.877   5.941  1.00 48.86           C  
ATOM    867  CD  PRO   114       8.887  -1.082   5.872  1.00 49.07           C  
ATOM    868  N   MET   115       8.177   1.318   9.678  0.50 46.47           N  
ATOM    870  CA  MET   115       8.056   1.030  11.103  0.50 45.86           C  
ATOM    872  C   MET   115       7.291   2.168  11.788  0.50 44.88           C  
ATOM    874  O   MET   115       7.359   3.309  11.343  0.50 44.01           O  
ATOM    876  CB  MET   115       9.451   0.898  11.739  0.50 46.26           C  
ATOM    878  CG  MET   115      10.313  -0.248  11.193  0.50 47.41           C  
ATOM    880  SD  MET   115       9.615  -1.997  11.588  0.38 50.15          SE  
ATOM    882  CE  MET   115      10.573  -2.363  13.234  0.50 47.61           C  
ATOM    884  N   PRO   116       6.549   1.854  12.864  1.00 43.99           N  
ATOM    885  CA  PRO   116       5.908   2.915  13.646  1.00 43.79           C  
ATOM    886  C   PRO   116       6.908   3.920  14.251  1.00 43.02           C  
ATOM    887  O   PRO   116       8.073   3.608  14.453  1.00 43.43           O  
ATOM    888  CB  PRO   116       5.140   2.150  14.737  1.00 43.24           C  
ATOM    889  CG  PRO   116       5.546   0.747  14.654  1.00 43.88           C  
ATOM    890  CD  PRO   116       6.238   0.505  13.371  1.00 43.91           C  
ATOM    891  N   ASN   117       6.469   5.128  14.529  1.00 43.16           N  
ATOM    892  CA  ASN   117       7.364   6.096  15.140  1.00 42.24           C  
ATOM    893  C   ASN   117       8.000   5.609  16.448  1.00 42.64           C  
ATOM    894  O   ASN   117       9.145   5.941  16.721  1.00 41.88           O  
ATOM    895  CB  ASN   117       6.677   7.436  15.340  1.00 42.23           C  
ATOM    896  CG  ASN   117       6.544   8.202  14.055  1.00 40.47           C  
ATOM    897  OD1 ASN   117       7.400   8.099  13.181  1.00 38.78           O  
ATOM    898  ND2 ASN   117       5.470   8.955  13.918  1.00 38.60           N  
ATOM    899  N   SER   118       7.285   4.802  17.231  1.00 42.46           N  
ATOM    900  CA  SER   118       7.817   4.322  18.514  1.00 42.93           C  
ATOM    901  C   SER   118       9.114   3.502  18.368  1.00 43.27           C  
ATOM    902  O   SER   118       9.988   3.534  19.238  1.00 43.99           O  
ATOM    903  CB  SER   118       6.773   3.497  19.258  1.00 42.42           C  
ATOM    904  OG  SER   118       6.295   2.479  18.432  1.00 41.62           O  
ATOM    905  N   ILE   119       9.237   2.797  17.258  1.00 43.05           N  
ATOM    906  CA  ILE   119      10.407   1.994  16.975  1.00 42.90           C  
ATOM    907  C   ILE   119      11.566   2.922  16.605  1.00 41.18           C  
ATOM    908  O   ILE   119      12.708   2.727  17.031  1.00 40.63           O  
ATOM    909  CB  ILE   119      10.119   0.981  15.854  1.00 42.76           C  
ATOM    910  CG1 ILE   119       9.021  -0.010  16.269  1.00 44.12           C  
ATOM    911  CG2 ILE   119      11.356   0.189  15.505  1.00 44.93           C  
ATOM    912  CD1 ILE   119       9.352  -0.890  17.475  1.00 45.27           C  
ATOM    913  N   PHE   120      11.295   3.973  15.853  1.00 40.62           N  
ATOM    914  CA  PHE   120      12.348   4.973  15.652  1.00 39.21           C  
ATOM    915  C   PHE   120      12.948   5.328  17.000  1.00 39.52           C  
ATOM    916  O   PHE   120      14.185   5.420  17.164  1.00 37.20           O  
ATOM    917  CB  PHE   120      11.821   6.234  15.001  1.00 39.58           C  
ATOM    918  CG  PHE   120      11.571   6.107  13.531  1.00 39.72           C  
ATOM    919  CD1 PHE   120      10.412   5.516  13.048  1.00 39.04           C  
ATOM    920  CD2 PHE   120      12.487   6.596  12.623  1.00 38.89           C  
ATOM    921  CE1 PHE   120      10.182   5.415  11.703  1.00 37.81           C  
ATOM    922  CE2 PHE   120      12.241   6.509  11.278  1.00 39.88           C  
ATOM    923  CZ  PHE   120      11.099   5.880  10.817  1.00 38.14           C  
ATOM    924  N   LEU   121      12.060   5.568  17.965  1.00 40.36           N  
ATOM    925  CA  LEU   121      12.462   6.141  19.252  1.00 40.88           C  
ATOM    926  C   LEU   121      13.201   5.076  20.060  1.00 41.08           C  
ATOM    927  O   LEU   121      14.167   5.373  20.736  1.00 41.03           O  
ATOM    928  CB  LEU   121      11.251   6.666  20.044  1.00 39.89           C  
ATOM    929  CG  LEU   121      10.589   7.958  19.555  1.00 40.55           C  
ATOM    930  CD1 LEU   121       9.500   8.383  20.498  1.00 36.76           C  
ATOM    931  CD2 LEU   121      11.587   9.034  19.411  1.00 37.03           C  
ATOM    932  N   MET   122      12.732   3.839  19.983  1.00 42.59           N  
ATOM    933  CA  MET   122      13.398   2.724  20.632  1.00 44.24           C  
ATOM    934  C   MET   122      14.806   2.595  20.071  1.00 43.62           C  
ATOM    935  O   MET   122      15.748   2.275  20.792  1.00 43.80           O  
ATOM    936  CB  MET   122      12.626   1.429  20.368  1.00 44.26           C  
ATOM    937  CG  MET   122      13.187   0.214  21.018  1.00 45.86           C  
ATOM    938  SD  MET   122      12.557  -1.437  20.132  0.75 51.63          SE  
ATOM    939  CE  MET   122      13.554  -1.285  18.357  1.00 45.57           C  
ATOM    940  N   THR   123      14.928   2.831  18.769  1.00 43.14           N  
ATOM    941  CA  THR   123      16.176   2.644  18.056  1.00 42.91           C  
ATOM    942  C   THR   123      17.158   3.733  18.461  1.00 42.21           C  
ATOM    943  O   THR   123      18.335   3.460  18.652  1.00 41.89           O  
ATOM    944  CB  THR   123      15.935   2.539  16.496  1.00 43.39           C  
ATOM    945  OG1 THR   123      15.197   1.332  16.211  1.00 42.69           O  
ATOM    946  CG2 THR   123      17.277   2.521  15.712  1.00 43.20           C  
ATOM    947  N   LEU   124      16.659   4.957  18.632  1.00 41.77           N  
ATOM    948  CA  LEU   124      17.475   6.046  19.083  1.00 41.19           C  
ATOM    949  C   LEU   124      18.160   5.732  20.419  1.00 40.75           C  
ATOM    950  O   LEU   124      19.355   5.996  20.581  1.00 41.36           O  
ATOM    951  CB  LEU   124      16.623   7.307  19.230  1.00 40.93           C  
ATOM    952  CG  LEU   124      17.272   8.604  19.668  1.00 42.46           C  
ATOM    953  CD1 LEU   124      18.157   9.190  18.567  1.00 43.77           C  
ATOM    954  CD2 LEU   124      16.209   9.596  20.074  1.00 40.62           C  
ATOM    955  N   ILE   125      17.390   5.216  21.370  1.00 39.88           N  
ATOM    956  CA  ILE   125      17.882   4.938  22.718  1.00 39.12           C  
ATOM    957  C   ILE   125      18.893   3.817  22.712  1.00 38.38           C  
ATOM    958  O   ILE   125      19.932   3.928  23.361  1.00 37.70           O  
ATOM    959  CB  ILE   125      16.723   4.572  23.708  1.00 39.09           C  
ATOM    960  CG1 ILE   125      15.852   5.792  23.978  1.00 39.79           C  
ATOM    961  CG2 ILE   125      17.271   4.080  25.043  1.00 38.31           C  
ATOM    962  CD1 ILE   125      14.656   5.520  24.864  1.00 39.65           C  
ATOM    963  N   ASN   126      18.573   2.744  21.993  1.00 37.52           N  
ATOM    964  CA  ASN   126      19.421   1.576  21.890  1.00 37.33           C  
ATOM    965  C   ASN   126      20.784   1.868  21.247  1.00 37.26           C  
ATOM    966  O   ASN   126      21.834   1.440  21.754  1.00 34.80           O  
ATOM    967  CB  ASN   126      18.731   0.501  21.061  1.00 38.33           C  
ATOM    968  CG  ASN   126      17.650  -0.227  21.809  1.00 40.70           C  
ATOM    969  OD1 ASN   126      17.448  -0.023  23.011  1.00 44.17           O  
ATOM    970  ND2 ASN   126      16.942  -1.105  21.098  1.00 40.57           N  
ATOM    971  N   HIS   127      20.745   2.631  20.149  1.00 37.71           N  
ATOM    972  CA  HIS   127      21.946   3.060  19.420  1.00 37.67           C  
ATOM    973  C   HIS   127      22.850   3.873  20.342  1.00 38.98           C  
ATOM    974  O   HIS   127      24.033   3.565  20.464  1.00 39.22           O  
ATOM    975  CB  HIS   127      21.545   3.859  18.163  1.00 37.87           C  
ATOM    976  CG  HIS   127      22.698   4.444  17.394  1.00 35.17           C  
ATOM    977  ND1 HIS   127      23.003   5.788  17.416  1.00 36.73           N  
ATOM    978  CD2 HIS   127      23.596   3.870  16.561  1.00 31.82           C  
ATOM    979  CE1 HIS   127      24.052   6.011  16.635  1.00 36.20           C  
ATOM    980  NE2 HIS   127      24.431   4.859  16.110  1.00 36.17           N  
ATOM    981  N   GLN   128      22.284   4.910  20.959  1.00 39.54           N  
ATOM    982  CA  GLN   128      22.991   5.785  21.878  1.00 39.52           C  
ATOM    983  C   GLN   128      23.639   5.025  23.041  1.00 40.57           C  
ATOM    984  O   GLN   128      24.742   5.354  23.454  1.00 40.88           O  
ATOM    985  CB  GLN   128      22.031   6.804  22.432  1.00 39.57           C  
ATOM    986  CG  GLN   128      22.707   7.895  23.259  1.00 39.96           C  
ATOM    987  CD  GLN   128      21.758   8.933  23.719  1.00 41.12           C  
ATOM    988  OE1 GLN   128      21.881  10.106  23.351  1.00 40.43           O  
ATOM    989  NE2 GLN   128      20.781   8.525  24.537  1.00 40.41           N  
ATOM    990  N   ASN   129      22.938   4.011  23.545  1.00 39.82           N  
ATOM    991  CA  ASN   129      23.372   3.238  24.700  1.00 40.21           C  
ATOM    992  C   ASN   129      24.546   2.321  24.330  1.00 39.31           C  
ATOM    993  O   ASN   129      25.484   2.146  25.103  1.00 37.84           O  
ATOM    994  CB  ASN   129      22.177   2.428  25.230  1.00 40.29           C  
ATOM    995  CG  ASN   129      22.493   1.635  26.501  1.00 43.51           C  
ATOM    996  OD1 ASN   129      23.480   1.893  27.194  1.00 47.46           O  
ATOM    997  ND2 ASN   129      21.635   0.670  26.813  1.00 42.77           N  
ATOM    998  N   HIS   130      24.484   1.738  23.139  1.00 39.10           N  
ATOM    999  CA  HIS   130      25.593   0.936  22.613  1.00 39.02           C  
ATOM   1000  C   HIS   130      26.897   1.733  22.570  1.00 38.12           C  
ATOM   1001  O   HIS   130      27.934   1.271  23.066  1.00 38.39           O  
ATOM   1002  CB  HIS   130      25.256   0.453  21.204  1.00 39.29           C  
ATOM   1003  CG  HIS   130      26.436  -0.046  20.435  1.00 39.26           C  
ATOM   1004  ND1 HIS   130      27.062  -1.242  20.720  1.00 38.14           N  
ATOM   1005  CD2 HIS   130      27.077   0.472  19.358  1.00 38.78           C  
ATOM   1006  CE1 HIS   130      28.049  -1.429  19.861  1.00 39.64           C  
ATOM   1007  NE2 HIS   130      28.076  -0.408  19.022  1.00 37.62           N  
ATOM   1008  N   HIS   131      26.827   2.903  21.955  1.00 37.71           N  
ATOM   1009  CA  HIS   131      27.988   3.785  21.779  1.00 37.24           C  
ATOM   1010  C   HIS   131      28.470   4.463  23.054  1.00 36.58           C  
ATOM   1011  O   HIS   131      29.678   4.713  23.234  1.00 35.94           O  
ATOM   1012  CB  HIS   131      27.678   4.853  20.735  1.00 36.93           C  
ATOM   1013  CG  HIS   131      27.717   4.354  19.332  1.00 37.60           C  
ATOM   1014  ND1 HIS   131      28.868   3.884  18.747  1.00 36.87           N  
ATOM   1015  CD2 HIS   131      26.747   4.253  18.390  1.00 37.91           C  
ATOM   1016  CE1 HIS   131      28.609   3.523  17.505  1.00 37.78           C  
ATOM   1017  NE2 HIS   131      27.336   3.754  17.261  1.00 34.19           N  
ATOM   1018  N   ARG   132      27.543   4.804  23.941  1.00 35.76           N  
ATOM   1019  CA  ARG   132      27.938   5.285  25.276  1.00 34.80           C  
ATOM   1020  C   ARG   132      28.688   4.161  26.034  1.00 33.64           C  
ATOM   1021  O   ARG   132      29.653   4.410  26.732  1.00 34.61           O  
ATOM   1022  CB  ARG   132      26.708   5.777  26.034  1.00 34.99           C  
ATOM   1023  CG  ARG   132      26.991   6.320  27.405  1.00 35.58           C  
ATOM   1024  CD  ARG   132      25.714   6.783  28.055  1.00 36.45           C  
ATOM   1025  NE  ARG   132      24.850   5.641  28.286  1.00 37.68           N  
ATOM   1026  CZ  ARG   132      23.521   5.686  28.360  1.00 38.30           C  
ATOM   1027  NH1 ARG   132      22.846   6.823  28.219  1.00 39.14           N  
ATOM   1028  NH2 ARG   132      22.870   4.562  28.571  1.00 39.80           N  
ATOM   1029  N   GLY   133      28.280   2.922  25.844  1.00 32.34           N  
ATOM   1030  CA  GLY   133      28.989   1.783  26.409  1.00 31.59           C  
ATOM   1031  C   GLY   133      30.444   1.793  25.950  1.00 32.06           C  
ATOM   1032  O   GLY   133      31.351   1.540  26.737  1.00 30.70           O  
ATOM   1033  N   GLN   134      30.653   2.096  24.657  1.00 31.73           N  
ATOM   1034  CA  GLN   134      31.993   2.201  24.073  1.00 31.14           C  
ATOM   1035  C   GLN   134      32.742   3.366  24.677  1.00 31.57           C  
ATOM   1036  O   GLN   134      33.901   3.248  25.057  1.00 31.15           O  
ATOM   1037  CB  GLN   134      31.891   2.422  22.556  1.00 31.55           C  
ATOM   1038  CG  GLN   134      31.237   1.280  21.816  1.00 30.22           C  
ATOM   1039  CD  GLN   134      31.205   1.457  20.280  1.00 30.87           C  
ATOM   1040  OE1 GLN   134      31.000   2.551  19.773  1.00 31.06           O  
ATOM   1041  NE2 GLN   134      31.352   0.342  19.553  1.00 30.25           N  
ATOM   1042  N   MET   135      32.076   4.505  24.775  1.00 32.32           N  
ATOM   1043  CA  MET   135      32.726   5.670  25.337  1.00 32.89           C  
ATOM   1044  C   MET   135      33.338   5.397  26.707  1.00 33.44           C  
ATOM   1045  O   MET   135      34.440   5.908  27.011  1.00 35.37           O  
ATOM   1046  CB  MET   135      31.764   6.835  25.458  1.00 32.64           C  
ATOM   1047  CG  MET   135      31.184   7.333  24.230  1.00 32.39           C  
ATOM   1048  SD  MET   135      30.930   9.293  24.527  0.75 35.42          SE  
ATOM   1049  CE  MET   135      29.463   9.275  25.594  1.00 34.05           C  
ATOM   1050  N   THR   136      32.638   4.614  27.540  1.00 33.67           N  
ATOM   1051  CA  THR   136      33.069   4.336  28.906  1.00 33.46           C  
ATOM   1052  C   THR   136      34.411   3.620  28.966  1.00 33.57           C  
ATOM   1053  O   THR   136      35.226   3.956  29.827  1.00 33.18           O  
ATOM   1054  CB  THR   136      31.974   3.629  29.797  1.00 34.12           C  
ATOM   1055  OG1 THR   136      31.679   2.298  29.339  1.00 33.45           O  
ATOM   1056  CG2 THR   136      30.694   4.480  29.887  1.00 34.20           C  
ATOM   1057  N   VAL   137      34.650   2.652  28.073  1.00 33.16           N  
ATOM   1058  CA  VAL   137      35.947   1.999  28.004  1.00 31.90           C  
ATOM   1059  C   VAL   137      37.024   3.017  27.608  1.00 32.75           C  
ATOM   1060  O   VAL   137      38.055   3.151  28.290  1.00 32.42           O  
ATOM   1061  CB  VAL   137      35.924   0.763  27.088  1.00 32.54           C  
ATOM   1062  CG1 VAL   137      37.310   0.088  27.014  1.00 30.39           C  
ATOM   1063  CG2 VAL   137      34.897  -0.219  27.585  1.00 30.37           C  
ATOM   1064  N   LEU   138      36.754   3.790  26.567  1.00 32.99           N  
ATOM   1065  CA  LEU   138      37.733   4.764  26.071  1.00 33.03           C  
ATOM   1066  C   LEU   138      38.023   5.878  27.082  1.00 33.16           C  
ATOM   1067  O   LEU   138      39.178   6.293  27.240  1.00 33.13           O  
ATOM   1068  CB  LEU   138      37.270   5.365  24.730  1.00 33.09           C  
ATOM   1069  CG  LEU   138      37.161   4.361  23.591  1.00 31.63           C  
ATOM   1070  CD1 LEU   138      36.442   4.958  22.359  1.00 31.53           C  
ATOM   1071  CD2 LEU   138      38.529   3.851  23.223  1.00 28.96           C  
ATOM   1072  N   MET   139      36.987   6.357  27.760  1.00 33.22           N  
ATOM   1073  CA  MET   139      37.166   7.366  28.827  1.00 32.98           C  
ATOM   1074  C   MET   139      38.103   6.866  29.938  1.00 33.25           C  
ATOM   1075  O   MET   139      39.005   7.570  30.356  1.00 32.78           O  
ATOM   1076  CB  MET   139      35.820   7.780  29.415  1.00 33.36           C  
ATOM   1077  CG  MET   139      34.918   8.630  28.492  1.00 32.73           C  
ATOM   1078  SD  MET   139      33.085   8.665  29.128  0.75 30.52          SE  
ATOM   1079  CE  MET   139      32.541   7.010  28.489  1.00 37.70           C  
ATOM   1080  N   ARG   140      37.892   5.632  30.376  1.00 33.99           N  
ATOM   1081  CA  ARG   140      38.755   4.960  31.357  1.00 34.31           C  
ATOM   1082  C   ARG   140      40.199   4.928  30.866  1.00 34.39           C  
ATOM   1083  O   ARG   140      41.151   5.218  31.601  1.00 34.22           O  
ATOM   1084  CB  ARG   140      38.296   3.497  31.528  1.00 35.08           C  
ATOM   1085  CG  ARG   140      37.921   3.085  32.923  1.00 36.93           C  
ATOM   1086  CD  ARG   140      36.405   3.172  33.147  1.00 39.40           C  
ATOM   1087  N   GLN   141      40.353   4.543  29.606  1.00 34.09           N  
ATOM   1088  CA  GLN   141      41.661   4.424  28.977  1.00 33.28           C  
ATOM   1089  C   GLN   141      42.325   5.785  28.806  1.00 33.33           C  
ATOM   1090  O   GLN   141      43.552   5.878  28.835  1.00 33.32           O  
ATOM   1091  CB  GLN   141      41.520   3.683  27.657  1.00 32.82           C  
ATOM   1092  CG  GLN   141      41.363   2.197  27.917  1.00 31.72           C  
ATOM   1093  CD  GLN   141      40.902   1.407  26.735  1.00 29.68           C  
ATOM   1094  OE1 GLN   141      40.531   1.974  25.712  1.00 30.80           O  
ATOM   1095  NE2 GLN   141      40.907   0.076  26.868  1.00 24.28           N  
ATOM   1096  N   ALA   142      41.527   6.837  28.693  1.00 32.84           N  
ATOM   1097  CA  ALA   142      42.065   8.191  28.666  1.00 33.41           C  
ATOM   1098  C   ALA   142      42.404   8.762  30.041  1.00 34.75           C  
ATOM   1099  O   ALA   142      42.844   9.900  30.119  1.00 35.04           O  
ATOM   1100  CB  ALA   142      41.107   9.111  27.974  1.00 33.31           C  
ATOM   1101  N   GLY   143      42.182   7.997  31.107  1.00 35.67           N  
ATOM   1102  CA  GLY   143      42.444   8.465  32.473  1.00 36.87           C  
ATOM   1103  C   GLY   143      41.377   9.378  33.058  1.00 37.96           C  
ATOM   1104  O   GLY   143      41.661  10.162  33.986  1.00 37.88           O  
ATOM   1105  N   LEU   144      40.153   9.293  32.531  1.00 38.67           N  
ATOM   1106  CA  LEU   144      39.039  10.087  33.046  1.00 39.74           C  
ATOM   1107  C   LEU   144      38.243   9.266  34.055  1.00 41.04           C  
ATOM   1108  O   LEU   144      38.272   8.033  34.042  1.00 41.16           O  
ATOM   1109  CB  LEU   144      38.115  10.554  31.904  1.00 39.79           C  
ATOM   1110  CG  LEU   144      38.750  11.388  30.784  1.00 39.05           C  
ATOM   1111  CD1 LEU   144      37.741  11.652  29.658  1.00 37.45           C  
ATOM   1112  CD2 LEU   144      39.326  12.691  31.324  1.00 37.24           C  
ATOM   1113  N   THR   145      37.532   9.955  34.939  1.00 42.81           N  
ATOM   1114  CA  THR   145      36.675   9.292  35.916  1.00 43.91           C  
ATOM   1115  C   THR   145      35.292   9.190  35.292  1.00 44.95           C  
ATOM   1116  O   THR   145      34.691  10.213  34.976  1.00 45.22           O  
ATOM   1117  CB  THR   145      36.637  10.071  37.272  1.00 43.99           C  
ATOM   1118  N   VAL   146      34.804   7.967  35.078  1.00 46.59           N  
ATOM   1119  CA  VAL   146      33.513   7.753  34.406  1.00 47.92           C  
ATOM   1120  C   VAL   146      32.374   7.775  35.425  1.00 49.33           C  
ATOM   1121  O   VAL   146      32.372   6.954  36.348  1.00 49.23           O  
ATOM   1122  CB  VAL   146      33.440   6.392  33.644  1.00 47.94           C  
ATOM   1123  CG1 VAL   146      32.086   6.219  32.986  1.00 47.64           C  
ATOM   1124  CG2 VAL   146      34.524   6.286  32.608  1.00 47.28           C  
ATOM   1125  N   PRO   147      31.418   8.721  35.280  1.00 50.94           N  
ATOM   1126  CA  PRO   147      30.191   8.590  36.084  1.00 52.30           C  
ATOM   1127  C   PRO   147      29.379   7.337  35.681  1.00 53.55           C  
ATOM   1128  O   PRO   147      29.364   6.959  34.504  1.00 54.31           O  
ATOM   1129  CB  PRO   147      29.432   9.895  35.801  1.00 52.10           C  
ATOM   1130  CG  PRO   147      30.019  10.431  34.537  1.00 51.92           C  
ATOM   1131  CD  PRO   147      31.418   9.940  34.447  1.00 50.72           C  
ATOM   1132  N   GLY   148      28.741   6.691  36.653  1.00 54.81           N  
ATOM   1133  CA  GLY   148      28.048   5.415  36.423  1.00 55.64           C  
ATOM   1134  C   GLY   148      26.796   5.497  35.556  1.00 56.25           C  
ATOM   1135  O   GLY   148      26.265   6.585  35.318  1.00 56.77           O  
ATOM   1136  N   VAL   149      26.355   4.333  35.066  1.00 56.83           N  
ATOM   1137  CA  VAL   149      25.069   4.165  34.366  1.00 57.00           C  
ATOM   1138  C   VAL   149      24.507   2.753  34.644  1.00 57.36           C  
ATOM   1139  O   VAL   149      25.260   1.768  34.683  1.00 57.45           O  
ATOM   1140  CB  VAL   149      25.194   4.411  32.825  1.00 56.97           C  
ATOM   1141  CG1 VAL   149      25.952   3.287  32.158  1.00 56.88           C  
ATOM   1142  CG2 VAL   149      23.807   4.585  32.169  1.00 56.07           C  
ATOM   1143  N   TYR   150      23.187   2.668  34.834  1.00 57.52           N  
ATOM   1144  CA  TYR   150      22.495   1.406  35.158  1.00 57.45           C  
ATOM   1145  C   TYR   150      23.080   0.739  36.395  1.00 57.47           C  
ATOM   1146  O   TYR   150      23.301   1.402  37.405  1.00 57.84           O  
ATOM   1147  CB  TYR   150      22.503   0.438  33.960  1.00 57.31           C  
ATOM   1148  CG  TYR   150      21.973   1.059  32.682  1.00 57.19           C  
ATOM   1149  CD1 TYR   150      20.797   1.825  32.692  1.00 57.44           C  
ATOM   1150  CD2 TYR   150      22.638   0.897  31.466  1.00 57.06           C  
ATOM   1151  CE1 TYR   150      20.301   2.411  31.534  1.00 56.37           C  
ATOM   1152  CE2 TYR   150      22.142   1.491  30.290  1.00 56.34           C  
ATOM   1153  CZ  TYR   150      20.975   2.243  30.345  1.00 56.39           C  
ATOM   1154  OH  TYR   150      20.455   2.825  29.223  1.00 56.70           O  
END
