
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  152 ( 2300),  selected  152 , name 1wic_A
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 1wic_A.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E     267           -
LGA    S     2_A      D     268           -
LGA    S     3_A      L     269           -
LGA    G     4_A      L     270           -
LGA    S     5_A      R     271           -
LGA    S     6_A      P     272           -
LGA    G     7_A      F     273           -
LGA    K     8_A      F     274           -
LGA    K     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    L    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    V    13_A      -       -           -
LGA    F    14_A      -       -           -
LGA    K    15_A      E     275          5.317
LGA    G    16_A      K     276          2.812
LGA    P    17_A      -       -           -
LGA    L    18_A      C     277          2.337
LGA    L    19_A      V     278          2.656
LGA    H    20_A      K     279          2.839
LGA    I    21_A      I     280          2.413
LGA    S    22_A      E     281          2.349
LGA    P    23_A      E     282          3.201
LGA    A    24_A      V     283           -
LGA    E    25_A      -       -           -
LGA    E    26_A      -       -           -
LGA    L    27_A      -       -           -
LGA    Y    28_A      S     284           #
LGA    F    29_A      R     285          4.036
LGA    G    30_A      N     286          1.276
LGA    S    31_A      -       -           -
LGA    I    32_A      -       -           -
LGA    E    33_A      -       -           -
LGA    S    34_A      -       -           -
LGA    G    35_A      -       -           -
LGA    E    36_A      E     287           #
LGA    K    37_A      Q     288          2.649
LGA    K    38_A      G     289          2.561
LGA    T    39_A      V     290          1.134
LGA    L    40_A      T     291          1.292
LGA    I    41_A      L     292          1.847
LGA    V    42_A      S     293          1.687
LGA    L    43_A      I     294          1.412
LGA    T    44_A      T     295          0.818
LGA    N    45_A      N     296          0.666
LGA    V    46_A      V     297          1.386
LGA    T    47_A      T     298          1.600
LGA    K    48_A      D     299          0.511
LGA    N    49_A      L     300          1.581
LGA    I    50_A      V     301          0.708
LGA    V    51_A      L     302          0.659
LGA    A    52_A      K     303          0.757
LGA    F    53_A      L     304          2.174
LGA    K    54_A      K     305          3.376
LGA    V    55_A      K     306          4.425
LGA    R    56_A      T     307          4.907
LGA    T    57_A      A     308           #
LGA    T    58_A      H     309          3.237
LGA    A    59_A      D     310          0.962
LGA    P    60_A      T     311          2.319
LGA    E    61_A      -       -           -
LGA    K    62_A      L     312          1.451
LGA    Y    63_A      L     313          2.347
LGA    R    64_A      V     314          1.961
LGA    V    65_A      Y     315          0.899
LGA    K    66_A      F     316          2.802
LGA    P    67_A      -       -           -
LGA    S    68_A      R     317          3.097
LGA    N    69_A      D     318          0.671
LGA    S    70_A      M     319          1.277
LGA    S    71_A      T     320          0.532
LGA    C    72_A      L     321          0.826
LGA    D    73_A      K     322          0.459
LGA    P    74_A      P     323          0.290
LGA    G    75_A      H     324          0.233
LGA    A    76_A      T     325          0.070
LGA    S    77_A      R     326          1.242
LGA    I    78_A      Y     327          1.466
LGA    D    79_A      T     328          2.023
LGA    I    80_A      V     329          1.734
LGA    I    81_A      R     330          1.156
LGA    V    82_A      I     331          1.157
LGA    S    83_A      G     332          1.382
LGA    P    84_A      F     333          2.024
LGA    H    85_A      K     334          2.378
LGA    G    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    L    88_A      Q     335          1.735
LGA    T    89_A      G     336          1.282
LGA    V    90_A      I     337          2.076
LGA    S    91_A      K     338          3.941
LGA    A    92_A      -       -           -
LGA    Q    93_A      -       -           -
LGA    D    94_A      G     339          4.950
LGA    R    95_A      G     340          2.140
LGA    F    96_A      D     341          1.706
LGA    L    97_A      V     342          2.701
LGA    I    98_A      N     343          4.568
LGA    M    99_A      F     344          3.874
LGA    A   100_A      E     345           #
LGA    A   101_A      V     346          3.528
LGA    E   102_A      -       -           -
LGA    M   103_A      -       -           -
LGA    E   104_A      -       -           -
LGA    Q   105_A      -       -           -
LGA    S   106_A      -       -           -
LGA    S   107_A      -       -           -
LGA    G   108_A      -       -           -
LGA    T   109_A      -       -           -
LGA    G   110_A      -       -           -
LGA    P   111_A      -       -           -
LGA    A   112_A      -       -           -
LGA    E   113_A      -       -           -
LGA    L   114_A      -       -           -
LGA    S   115_A      -       -           -
LGA    Q   116_A      -       -           -
LGA    F   117_A      -       -           -
LGA    W   118_A      T     347          2.944
LGA    K   119_A      -       -           -
LGA    E   120_A      N     348           #
LGA    V   121_A      F     349          4.149
LGA    P   122_A      I     350          2.420
LGA    R   123_A      V     351          4.177
LGA    N   124_A      A     352           #
LGA    -       -      P     353           -
LGA    -       -      D     354           -
LGA    -       -      K     355           -
LGA    K   125_A      G     356          5.613
LGA    V   126_A      L     357          1.572
LGA    M   127_A      K     358          5.220
LGA    E   128_A      Y     359          1.055
LGA    H   129_A      T     360          2.895
LGA    R   130_A      I     361          3.028
LGA    L   131_A      S     362          1.022
LGA    R   132_A      L     363          2.806
LGA    C   133_A      -       -           -
LGA    H   134_A      -       -           -
LGA    T   135_A      -       -           -
LGA    V   136_A      -       -           -
LGA    E   137_A      -       -           -
LGA    S   138_A      -       -           -
LGA    S   139_A      -       -           -
LGA    K   140_A      -       -           -
LGA    P   141_A      -       -           -
LGA    N   142_A      -       -           -
LGA    S   143_A      -       -           -
LGA    L   144_A      -       -           -
LGA    M   145_A      -       -           -
LGA    L   146_A      -       -           -
LGA    S   147_A      -       -           -
LGA    G   148_A      -       -           -
LGA    P   149_A      -       -           -
LGA    S   150_A      -       -           -
LGA    S   151_A      -       -           -
LGA    G   152_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  152   97    5.0     79    2.56     8.86     57.213     2.975

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.211161 * X  +  -0.775683 * Y  +   0.594749 * Z  +  22.668806
  Y_new =  -0.718211 * X  +   0.289600 * Y  +   0.632697 * Z  +  61.255688
  Z_new =  -0.663012 * X  +  -0.560756 * Y  +  -0.495952 * Z  +  25.878887 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.294945    0.846648  [ DEG:  -131.4907     48.5093 ]
  Theta =   0.724835    2.416758  [ DEG:    41.5300    138.4700 ]
  Phi   =  -1.284845    1.856748  [ DEG:   -73.6162    106.3838 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wic_A                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wic_A.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  152   97   5.0   79   2.56    8.86  57.213
REMARK  ---------------------------------------------------------- 
MOLECULE 1wic_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   28-MAY-04   1WIC              
TITLE     SOLUTION STRUCTURE OF THE MSP DOMAIN OF RIKEN CDNA                    
TITLE    2 6030424E15                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN RIKEN CDNA 6030424E15;                
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: RIKEN CDNA 6030424E15;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P031215-09;                               
SOURCE   7 OTHER_DETAILS: CELL FREE SYNTHESIS                                   
KEYWDS    BETA SANDWICH FOLD, STRUCTURAL GENOMICS, RIKEN STRUCTURAL             
KEYWDS   2 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.ENDO,K.ASAKURA,N.NEMOTO,K.TAKASUGI,K.IZUMIE,M.YOSHIDA,              
AUTHOR   2 F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
AUTHOR   3 INITIATIVE (RSGI)                                                    
REVDAT   1   28-NOV-04 1WIC    0                                                
JRNL        AUTH   H.ENDO,K.ASAKURA,N.NEMOTO,K.TAKASUGI,K.IZUMIE,               
JRNL        AUTH 2 M.YOSHIDA,F.HAYASHI,S.YOKOYAMA                               
JRNL        TITL   SOLUTION STRUCTURE OF THE MSP DOMAIN OF RIKEN CDNA           
JRNL        TITL 2 6030424E15                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WIC A    8   146  UNP    Q9CWP6   MSPD2_MOUSE    317    455             
SEQRES   1 A  152  GLY SER SER GLY SER SER GLY LYS LYS PRO LEU SER VAL          
SEQRES   2 A  152  PHE LYS GLY PRO LEU LEU HIS ILE SER PRO ALA GLU GLU          
SEQRES   3 A  152  LEU TYR PHE GLY SER ILE GLU SER GLY GLU LYS LYS THR          
SEQRES   4 A  152  LEU ILE VAL LEU THR ASN VAL THR LYS ASN ILE VAL ALA          
SEQRES   5 A  152  PHE LYS VAL ARG THR THR ALA PRO GLU LYS TYR ARG VAL          
SEQRES   6 A  152  LYS PRO SER ASN SER SER CYS ASP PRO GLY ALA SER ILE          
SEQRES   7 A  152  ASP ILE ILE VAL SER PRO HIS GLY GLY LEU THR VAL SER          
SEQRES   8 A  152  ALA GLN ASP ARG PHE LEU ILE MET ALA ALA GLU MET GLU          
SEQRES   9 A  152  GLN SER SER GLY THR GLY PRO ALA GLU LEU SER GLN PHE          
SEQRES  10 A  152  TRP LYS GLU VAL PRO ARG ASN LYS VAL MET GLU HIS ARG          
SEQRES  11 A  152  LEU ARG CYS HIS THR VAL GLU SER SER LYS PRO ASN SER          
SEQRES  12 A  152  LEU MET LEU SER GLY PRO SER SER GLY                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1     -17.312  68.866  33.457  1.00  0.00           N  
ATOM      2  CA  GLY A   1     -16.954  67.459  33.422  1.00  0.00           C  
ATOM      3  C   GLY A   1     -15.587  67.225  34.068  1.00  0.00           C  
ATOM      4  O   GLY A   1     -15.208  67.933  35.000  1.00  0.00           O  
ATOM      5  HA2 GLY A   1     -17.711  66.874  33.945  1.00  0.00           H  
ATOM      6  HA3 GLY A   1     -16.937  67.108  32.391  1.00  0.00           H  
ATOM      7  H1  GLY A   1     -16.566  69.498  33.246  1.00  0.00           H  
ATOM      8  N   SER A   2     -14.884  66.229  33.548  1.00  0.00           N  
ATOM      9  CA  SER A   2     -13.567  65.894  34.062  1.00  0.00           C  
ATOM     10  C   SER A   2     -12.501  66.195  33.006  1.00  0.00           C  
ATOM     11  O   SER A   2     -12.654  65.828  31.842  1.00  0.00           O  
ATOM     12  CB  SER A   2     -13.498  64.425  34.482  1.00  0.00           C  
ATOM     13  OG  SER A   2     -12.232  64.088  35.042  1.00  0.00           O  
ATOM     14  H   SER A   2     -15.200  65.659  32.790  1.00  0.00           H  
ATOM     15  HA  SER A   2     -13.429  66.529  34.937  1.00  0.00           H  
ATOM     16  HB2 SER A   2     -14.282  64.218  35.210  1.00  0.00           H  
ATOM     17  HB3 SER A   2     -13.692  63.790  33.617  1.00  0.00           H  
ATOM     18  HG  SER A   2     -12.281  64.116  36.041  1.00  0.00           H  
ATOM     19  N   SER A   3     -11.445  66.859  33.451  1.00  0.00           N  
ATOM     20  CA  SER A   3     -10.353  67.212  32.559  1.00  0.00           C  
ATOM     21  C   SER A   3      -9.104  67.557  33.371  1.00  0.00           C  
ATOM     22  O   SER A   3      -9.183  67.762  34.582  1.00  0.00           O  
ATOM     23  CB  SER A   3     -10.739  68.385  31.656  1.00  0.00           C  
ATOM     24  OG  SER A   3     -11.625  67.989  30.613  1.00  0.00           O  
ATOM     25  H   SER A   3     -11.328  67.153  34.399  1.00  0.00           H  
ATOM     26  HA  SER A   3     -10.181  66.326  31.948  1.00  0.00           H  
ATOM     27  HB2 SER A   3     -11.210  69.165  32.255  1.00  0.00           H  
ATOM     28  HB3 SER A   3      -9.838  68.819  31.221  1.00  0.00           H  
ATOM     29  HG  SER A   3     -12.065  68.793  30.213  1.00  0.00           H  
ATOM     30  N   GLY A   4      -7.978  67.608  32.674  1.00  0.00           N  
ATOM     31  CA  GLY A   4      -6.714  67.924  33.317  1.00  0.00           C  
ATOM     32  C   GLY A   4      -5.678  68.386  32.289  1.00  0.00           C  
ATOM     33  O   GLY A   4      -6.004  69.126  31.363  1.00  0.00           O  
ATOM     34  H   GLY A   4      -7.922  67.439  31.690  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      -6.865  68.704  34.061  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      -6.341  67.047  33.844  1.00  0.00           H  
ATOM     37  N   SER A   5      -4.450  67.929  32.488  1.00  0.00           N  
ATOM     38  CA  SER A   5      -3.365  68.286  31.590  1.00  0.00           C  
ATOM     39  C   SER A   5      -2.088  67.545  31.993  1.00  0.00           C  
ATOM     40  O   SER A   5      -1.894  67.225  33.165  1.00  0.00           O  
ATOM     41  CB  SER A   5      -3.124  69.797  31.591  1.00  0.00           C  
ATOM     42  OG  SER A   5      -2.818  70.289  32.893  1.00  0.00           O  
ATOM     43  H   SER A   5      -4.194  67.326  33.243  1.00  0.00           H  
ATOM     44  HA  SER A   5      -3.693  67.971  30.600  1.00  0.00           H  
ATOM     45  HB2 SER A   5      -2.304  70.034  30.913  1.00  0.00           H  
ATOM     46  HB3 SER A   5      -4.009  70.306  31.210  1.00  0.00           H  
ATOM     47  HG  SER A   5      -1.830  70.394  32.995  1.00  0.00           H  
ATOM     48  N   SER A   6      -1.249  67.294  30.999  1.00  0.00           N  
ATOM     49  CA  SER A   6       0.004  66.597  31.235  1.00  0.00           C  
ATOM     50  C   SER A   6      -0.273  65.157  31.676  1.00  0.00           C  
ATOM     51  O   SER A   6      -1.399  64.822  32.039  1.00  0.00           O  
ATOM     52  CB  SER A   6       0.847  67.320  32.286  1.00  0.00           C  
ATOM     53  OG  SER A   6       2.005  67.926  31.717  1.00  0.00           O  
ATOM     54  H   SER A   6      -1.414  67.557  30.049  1.00  0.00           H  
ATOM     55  HA  SER A   6       0.526  66.610  30.279  1.00  0.00           H  
ATOM     56  HB2 SER A   6       0.241  68.083  32.774  1.00  0.00           H  
ATOM     57  HB3 SER A   6       1.151  66.612  33.057  1.00  0.00           H  
ATOM     58  HG  SER A   6       1.739  68.540  30.975  1.00  0.00           H  
ATOM     59  N   GLY A   7       0.773  64.345  31.626  1.00  0.00           N  
ATOM     60  CA  GLY A   7       0.657  62.950  32.016  1.00  0.00           C  
ATOM     61  C   GLY A   7       1.863  62.512  32.848  1.00  0.00           C  
ATOM     62  O   GLY A   7       2.172  63.123  33.869  1.00  0.00           O  
ATOM     63  H   GLY A   7       1.685  64.627  31.328  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      -0.259  62.805  32.589  1.00  0.00           H  
ATOM     65  HA3 GLY A   7       0.578  62.326  31.125  1.00  0.00           H  
ATOM     66  N   LYS A   8       2.511  61.455  32.380  1.00  0.00           N  
ATOM     67  CA  LYS A   8       3.676  60.926  33.069  1.00  0.00           C  
ATOM     68  C   LYS A   8       4.328  59.845  32.203  1.00  0.00           C  
ATOM     69  O   LYS A   8       3.701  59.318  31.286  1.00  0.00           O  
ATOM     70  CB  LYS A   8       3.298  60.447  34.471  1.00  0.00           C  
ATOM     71  CG  LYS A   8       4.266  60.998  35.520  1.00  0.00           C  
ATOM     72  CD  LYS A   8       3.572  62.019  36.424  1.00  0.00           C  
ATOM     73  CE  LYS A   8       4.446  63.257  36.625  1.00  0.00           C  
ATOM     74  NZ  LYS A   8       4.491  64.067  35.386  1.00  0.00           N  
ATOM     75  H   LYS A   8       2.253  60.964  31.548  1.00  0.00           H  
ATOM     76  HA  LYS A   8       4.384  61.746  33.189  1.00  0.00           H  
ATOM     77  HB2 LYS A   8       2.282  60.763  34.707  1.00  0.00           H  
ATOM     78  HB3 LYS A   8       3.306  59.356  34.501  1.00  0.00           H  
ATOM     79  HG2 LYS A   8       4.659  60.179  36.123  1.00  0.00           H  
ATOM     80  HG3 LYS A   8       5.116  61.465  35.024  1.00  0.00           H  
ATOM     81  HD2 LYS A   8       2.618  62.310  35.984  1.00  0.00           H  
ATOM     82  HD3 LYS A   8       3.352  61.563  37.390  1.00  0.00           H  
ATOM     83  HE2 LYS A   8       4.054  63.858  37.445  1.00  0.00           H  
ATOM     84  HE3 LYS A   8       5.456  62.956  36.905  1.00  0.00           H  
ATOM     85  HZ1 LYS A   8       3.558  64.243  35.069  1.00  0.00           H  
ATOM     86  HZ2 LYS A   8       4.949  64.937  35.573  1.00  0.00           H  
ATOM     87  HZ3 LYS A   8       4.995  63.570  34.681  1.00  0.00           H  
ATOM     88  N   LYS A   9       5.578  59.548  32.526  1.00  0.00           N  
ATOM     89  CA  LYS A   9       6.321  58.540  31.791  1.00  0.00           C  
ATOM     90  C   LYS A   9       7.507  58.068  32.635  1.00  0.00           C  
ATOM     91  O   LYS A   9       8.087  58.850  33.387  1.00  0.00           O  
ATOM     92  CB  LYS A   9       6.720  59.069  30.411  1.00  0.00           C  
ATOM     93  CG  LYS A   9       7.855  60.090  30.523  1.00  0.00           C  
ATOM     94  CD  LYS A   9       7.602  61.292  29.611  1.00  0.00           C  
ATOM     95  CE  LYS A   9       7.928  62.603  30.329  1.00  0.00           C  
ATOM     96  NZ  LYS A   9       7.731  63.754  29.421  1.00  0.00           N  
ATOM     97  H   LYS A   9       6.081  59.982  33.274  1.00  0.00           H  
ATOM     98  HA  LYS A   9       5.653  57.694  31.630  1.00  0.00           H  
ATOM     99  HB2 LYS A   9       7.033  58.240  29.776  1.00  0.00           H  
ATOM    100  HB3 LYS A   9       5.858  59.530  29.931  1.00  0.00           H  
ATOM    101  HG2 LYS A   9       7.947  60.425  31.556  1.00  0.00           H  
ATOM    102  HG3 LYS A   9       8.801  59.619  30.255  1.00  0.00           H  
ATOM    103  HD2 LYS A   9       8.211  61.206  28.711  1.00  0.00           H  
ATOM    104  HD3 LYS A   9       6.560  61.297  29.291  1.00  0.00           H  
ATOM    105  HE2 LYS A   9       7.290  62.712  31.207  1.00  0.00           H  
ATOM    106  HE3 LYS A   9       8.958  62.584  30.685  1.00  0.00           H  
ATOM    107  HZ1 LYS A   9       8.577  63.927  28.916  1.00  0.00           H  
ATOM    108  HZ2 LYS A   9       6.993  63.550  28.778  1.00  0.00           H  
ATOM    109  HZ3 LYS A   9       7.492  64.565  29.957  1.00  0.00           H  
ATOM    110  N   PRO A  10       7.840  56.759  32.478  1.00  0.00           N  
ATOM    111  CA  PRO A  10       8.946  56.175  33.217  1.00  0.00           C  
ATOM    112  C   PRO A  10      10.290  56.623  32.638  1.00  0.00           C  
ATOM    113  O   PRO A  10      10.360  57.059  31.491  1.00  0.00           O  
ATOM    114  CB  PRO A  10       8.730  54.673  33.126  1.00  0.00           C  
ATOM    115  CG  PRO A  10       7.782  54.459  31.958  1.00  0.00           C  
ATOM    116  CD  PRO A  10       7.176  55.804  31.596  1.00  0.00           C  
ATOM    117  HA  PRO A  10       8.937  56.494  34.165  1.00  0.00           H  
ATOM    118  HB2 PRO A  10       9.674  54.152  32.964  1.00  0.00           H  
ATOM    119  HB3 PRO A  10       8.305  54.282  34.051  1.00  0.00           H  
ATOM    120  HG2 PRO A  10       8.317  54.039  31.104  1.00  0.00           H  
ATOM    121  HG3 PRO A  10       7.001  53.747  32.225  1.00  0.00           H  
ATOM    122  HD2 PRO A  10       7.347  56.048  30.548  1.00  0.00           H  
ATOM    123  HD3 PRO A  10       6.097  55.807  31.751  1.00  0.00           H  
ATOM    124  N   LEU A  11      11.323  56.497  33.459  1.00  0.00           N  
ATOM    125  CA  LEU A  11      12.660  56.883  33.043  1.00  0.00           C  
ATOM    126  C   LEU A  11      13.583  55.664  33.113  1.00  0.00           C  
ATOM    127  O   LEU A  11      13.769  55.083  34.182  1.00  0.00           O  
ATOM    128  CB  LEU A  11      13.153  58.076  33.864  1.00  0.00           C  
ATOM    129  CG  LEU A  11      13.241  59.411  33.120  1.00  0.00           C  
ATOM    130  CD1 LEU A  11      12.901  60.578  34.049  1.00  0.00           C  
ATOM    131  CD2 LEU A  11      14.611  59.583  32.463  1.00  0.00           C  
ATOM    132  H   LEU A  11      11.256  56.141  34.391  1.00  0.00           H  
ATOM    133  HA  LEU A  11      12.598  57.209  32.005  1.00  0.00           H  
ATOM    134  HB2 LEU A  11      12.490  58.203  34.719  1.00  0.00           H  
ATOM    135  HB3 LEU A  11      14.141  57.837  34.258  1.00  0.00           H  
ATOM    136  HG  LEU A  11      12.499  59.408  32.323  1.00  0.00           H  
ATOM    137 HD11 LEU A  11      11.961  60.372  34.562  1.00  0.00           H  
ATOM    138 HD12 LEU A  11      13.696  60.702  34.784  1.00  0.00           H  
ATOM    139 HD13 LEU A  11      12.802  61.492  33.463  1.00  0.00           H  
ATOM    140 HD21 LEU A  11      14.849  58.692  31.880  1.00  0.00           H  
ATOM    141 HD22 LEU A  11      14.592  60.452  31.804  1.00  0.00           H  
ATOM    142 HD23 LEU A  11      15.368  59.727  33.232  1.00  0.00           H  
ATOM    143  N   SER A  12      14.136  55.314  31.962  1.00  0.00           N  
ATOM    144  CA  SER A  12      15.034  54.174  31.880  1.00  0.00           C  
ATOM    145  C   SER A  12      16.375  54.608  31.282  1.00  0.00           C  
ATOM    146  O   SER A  12      16.434  55.560  30.506  1.00  0.00           O  
ATOM    147  CB  SER A  12      14.422  53.048  31.045  1.00  0.00           C  
ATOM    148  OG  SER A  12      13.413  52.341  31.762  1.00  0.00           O  
ATOM    149  H   SER A  12      13.979  55.791  31.097  1.00  0.00           H  
ATOM    150  HA  SER A  12      15.165  53.836  32.907  1.00  0.00           H  
ATOM    151  HB2 SER A  12      13.994  53.464  30.133  1.00  0.00           H  
ATOM    152  HB3 SER A  12      15.205  52.354  30.742  1.00  0.00           H  
ATOM    153  HG  SER A  12      12.715  52.979  32.090  1.00  0.00           H  
ATOM    154  N   VAL A  13      17.418  53.889  31.668  1.00  0.00           N  
ATOM    155  CA  VAL A  13      18.755  54.186  31.180  1.00  0.00           C  
ATOM    156  C   VAL A  13      19.406  52.899  30.672  1.00  0.00           C  
ATOM    157  O   VAL A  13      19.141  51.817  31.194  1.00  0.00           O  
ATOM    158  CB  VAL A  13      19.569  54.877  32.276  1.00  0.00           C  
ATOM    159  CG1 VAL A  13      18.654  55.604  33.264  1.00  0.00           C  
ATOM    160  CG2 VAL A  13      20.473  53.877  33.000  1.00  0.00           C  
ATOM    161  H   VAL A  13      17.362  53.115  32.300  1.00  0.00           H  
ATOM    162  HA  VAL A  13      18.652  54.881  30.347  1.00  0.00           H  
ATOM    163  HB  VAL A  13      20.207  55.621  31.801  1.00  0.00           H  
ATOM    164 HG11 VAL A  13      18.149  54.873  33.896  1.00  0.00           H  
ATOM    165 HG12 VAL A  13      19.250  56.272  33.887  1.00  0.00           H  
ATOM    166 HG13 VAL A  13      17.914  56.184  32.714  1.00  0.00           H  
ATOM    167 HG21 VAL A  13      19.973  52.909  33.055  1.00  0.00           H  
ATOM    168 HG22 VAL A  13      21.410  53.772  32.452  1.00  0.00           H  
ATOM    169 HG23 VAL A  13      20.679  54.236  34.008  1.00  0.00           H  
ATOM    170  N   PHE A  14      20.246  53.059  29.659  1.00  0.00           N  
ATOM    171  CA  PHE A  14      20.937  51.922  29.075  1.00  0.00           C  
ATOM    172  C   PHE A  14      22.065  51.438  29.988  1.00  0.00           C  
ATOM    173  O   PHE A  14      23.173  51.969  29.947  1.00  0.00           O  
ATOM    174  CB  PHE A  14      21.538  52.398  27.751  1.00  0.00           C  
ATOM    175  CG  PHE A  14      22.655  51.499  27.215  1.00  0.00           C  
ATOM    176  CD1 PHE A  14      22.351  50.303  26.644  1.00  0.00           C  
ATOM    177  CD2 PHE A  14      23.952  51.896  27.313  1.00  0.00           C  
ATOM    178  CE1 PHE A  14      23.387  49.469  26.147  1.00  0.00           C  
ATOM    179  CE2 PHE A  14      24.988  51.062  26.817  1.00  0.00           C  
ATOM    180  CZ  PHE A  14      24.685  49.867  26.244  1.00  0.00           C  
ATOM    181  H   PHE A  14      20.456  53.942  29.241  1.00  0.00           H  
ATOM    182  HA  PHE A  14      20.204  51.126  28.952  1.00  0.00           H  
ATOM    183  HB2 PHE A  14      20.745  52.458  27.005  1.00  0.00           H  
ATOM    184  HB3 PHE A  14      21.929  53.407  27.881  1.00  0.00           H  
ATOM    185  HD1 PHE A  14      21.311  49.986  26.566  1.00  0.00           H  
ATOM    186  HD2 PHE A  14      24.196  52.854  27.771  1.00  0.00           H  
ATOM    187  HE1 PHE A  14      23.144  48.511  25.688  1.00  0.00           H  
ATOM    188  HE2 PHE A  14      26.028  51.380  26.894  1.00  0.00           H  
ATOM    189  HZ  PHE A  14      25.481  49.226  25.863  1.00  0.00           H  
ATOM    190  N   LYS A  15      21.744  50.433  30.790  1.00  0.00           N  
ATOM    191  CA  LYS A  15      22.716  49.871  31.712  1.00  0.00           C  
ATOM    192  C   LYS A  15      23.928  49.369  30.925  1.00  0.00           C  
ATOM    193  O   LYS A  15      23.943  48.230  30.461  1.00  0.00           O  
ATOM    194  CB  LYS A  15      22.066  48.801  32.589  1.00  0.00           C  
ATOM    195  CG  LYS A  15      21.684  49.369  33.958  1.00  0.00           C  
ATOM    196  CD  LYS A  15      20.513  50.347  33.837  1.00  0.00           C  
ATOM    197  CE  LYS A  15      20.600  51.438  34.906  1.00  0.00           C  
ATOM    198  NZ  LYS A  15      20.758  50.838  36.249  1.00  0.00           N  
ATOM    199  H   LYS A  15      20.840  50.007  30.818  1.00  0.00           H  
ATOM    200  HA  LYS A  15      23.043  50.674  32.373  1.00  0.00           H  
ATOM    201  HB2 LYS A  15      21.178  48.408  32.094  1.00  0.00           H  
ATOM    202  HB3 LYS A  15      22.754  47.964  32.718  1.00  0.00           H  
ATOM    203  HG2 LYS A  15      21.415  48.555  34.632  1.00  0.00           H  
ATOM    204  HG3 LYS A  15      22.544  49.876  34.397  1.00  0.00           H  
ATOM    205  HD2 LYS A  15      20.514  50.801  32.847  1.00  0.00           H  
ATOM    206  HD3 LYS A  15      19.573  49.806  33.939  1.00  0.00           H  
ATOM    207  HE2 LYS A  15      21.442  52.097  34.694  1.00  0.00           H  
ATOM    208  HE3 LYS A  15      19.700  52.053  34.879  1.00  0.00           H  
ATOM    209  HZ1 LYS A  15      21.297  51.450  36.827  1.00  0.00           H  
ATOM    210  HZ2 LYS A  15      19.857  50.700  36.661  1.00  0.00           H  
ATOM    211  HZ3 LYS A  15      21.226  49.959  36.168  1.00  0.00           H  
ATOM    212  N   GLY A  16      24.915  50.244  30.797  1.00  0.00           N  
ATOM    213  CA  GLY A  16      26.128  49.904  30.074  1.00  0.00           C  
ATOM    214  C   GLY A  16      27.109  49.148  30.973  1.00  0.00           C  
ATOM    215  O   GLY A  16      27.090  49.310  32.191  1.00  0.00           O  
ATOM    216  H   GLY A  16      24.895  51.169  31.178  1.00  0.00           H  
ATOM    217  HA2 GLY A  16      25.879  49.292  29.206  1.00  0.00           H  
ATOM    218  HA3 GLY A  16      26.599  50.812  29.698  1.00  0.00           H  
ATOM    219  N   PRO A  17      27.963  48.316  30.319  1.00  0.00           N  
ATOM    220  CA  PRO A  17      28.949  47.534  31.046  1.00  0.00           C  
ATOM    221  C   PRO A  17      30.109  48.414  31.514  1.00  0.00           C  
ATOM    222  O   PRO A  17      30.866  48.029  32.405  1.00  0.00           O  
ATOM    223  CB  PRO A  17      29.382  46.447  30.075  1.00  0.00           C  
ATOM    224  CG  PRO A  17      28.974  46.934  28.694  1.00  0.00           C  
ATOM    225  CD  PRO A  17      28.013  48.098  28.877  1.00  0.00           C  
ATOM    226  HA  PRO A  17      28.545  47.150  31.876  1.00  0.00           H  
ATOM    227  HB2 PRO A  17      30.459  46.283  30.129  1.00  0.00           H  
ATOM    228  HB3 PRO A  17      28.902  45.498  30.313  1.00  0.00           H  
ATOM    229  HG2 PRO A  17      29.848  47.246  28.125  1.00  0.00           H  
ATOM    230  HG3 PRO A  17      28.497  46.130  28.132  1.00  0.00           H  
ATOM    231  HD2 PRO A  17      28.365  48.987  28.353  1.00  0.00           H  
ATOM    232  HD3 PRO A  17      27.026  47.864  28.477  1.00  0.00           H  
ATOM    233  N   LEU A  18      30.215  49.580  30.893  1.00  0.00           N  
ATOM    234  CA  LEU A  18      31.270  50.518  31.235  1.00  0.00           C  
ATOM    235  C   LEU A  18      30.645  51.831  31.710  1.00  0.00           C  
ATOM    236  O   LEU A  18      30.627  52.117  32.906  1.00  0.00           O  
ATOM    237  CB  LEU A  18      32.239  50.687  30.062  1.00  0.00           C  
ATOM    238  CG  LEU A  18      32.531  49.424  29.248  1.00  0.00           C  
ATOM    239  CD1 LEU A  18      33.317  49.761  27.979  1.00  0.00           C  
ATOM    240  CD2 LEU A  18      33.245  48.375  30.103  1.00  0.00           C  
ATOM    241  H   LEU A  18      29.596  49.886  30.170  1.00  0.00           H  
ATOM    242  HA  LEU A  18      31.836  50.087  32.061  1.00  0.00           H  
ATOM    243  HB2 LEU A  18      31.835  51.443  29.389  1.00  0.00           H  
ATOM    244  HB3 LEU A  18      33.181  51.074  30.448  1.00  0.00           H  
ATOM    245  HG  LEU A  18      31.582  48.993  28.934  1.00  0.00           H  
ATOM    246 HD11 LEU A  18      32.888  50.646  27.510  1.00  0.00           H  
ATOM    247 HD12 LEU A  18      34.358  49.955  28.237  1.00  0.00           H  
ATOM    248 HD13 LEU A  18      33.264  48.921  27.286  1.00  0.00           H  
ATOM    249 HD21 LEU A  18      34.313  48.591  30.126  1.00  0.00           H  
ATOM    250 HD22 LEU A  18      32.847  48.400  31.118  1.00  0.00           H  
ATOM    251 HD23 LEU A  18      33.084  47.386  29.673  1.00  0.00           H  
ATOM    252  N   LEU A  19      30.149  52.596  30.748  1.00  0.00           N  
ATOM    253  CA  LEU A  19      29.525  53.872  31.053  1.00  0.00           C  
ATOM    254  C   LEU A  19      28.024  53.781  30.769  1.00  0.00           C  
ATOM    255  O   LEU A  19      27.616  53.293  29.716  1.00  0.00           O  
ATOM    256  CB  LEU A  19      30.226  55.005  30.300  1.00  0.00           C  
ATOM    257  CG  LEU A  19      30.246  56.364  31.002  1.00  0.00           C  
ATOM    258  CD1 LEU A  19      29.037  56.524  31.924  1.00  0.00           C  
ATOM    259  CD2 LEU A  19      31.567  56.577  31.744  1.00  0.00           C  
ATOM    260  H   LEU A  19      30.169  52.356  29.777  1.00  0.00           H  
ATOM    261  HA  LEU A  19      29.665  54.058  32.117  1.00  0.00           H  
ATOM    262  HB2 LEU A  19      31.255  54.703  30.106  1.00  0.00           H  
ATOM    263  HB3 LEU A  19      29.741  55.125  29.331  1.00  0.00           H  
ATOM    264  HG  LEU A  19      30.176  57.141  30.241  1.00  0.00           H  
ATOM    265 HD11 LEU A  19      29.116  55.818  32.752  1.00  0.00           H  
ATOM    266 HD12 LEU A  19      29.009  57.540  32.315  1.00  0.00           H  
ATOM    267 HD13 LEU A  19      28.123  56.324  31.364  1.00  0.00           H  
ATOM    268 HD21 LEU A  19      31.972  55.612  32.050  1.00  0.00           H  
ATOM    269 HD22 LEU A  19      32.277  57.079  31.087  1.00  0.00           H  
ATOM    270 HD23 LEU A  19      31.392  57.193  32.627  1.00  0.00           H  
ATOM    271  N   HIS A  20      27.243  54.260  31.727  1.00  0.00           N  
ATOM    272  CA  HIS A  20      25.797  54.239  31.594  1.00  0.00           C  
ATOM    273  C   HIS A  20      25.346  55.409  30.718  1.00  0.00           C  
ATOM    274  O   HIS A  20      26.045  56.415  30.610  1.00  0.00           O  
ATOM    275  CB  HIS A  20      25.124  54.233  32.968  1.00  0.00           C  
ATOM    276  CG  HIS A  20      25.003  52.861  33.587  1.00  0.00           C  
ATOM    277  ND1 HIS A  20      24.132  52.580  34.625  1.00  0.00           N  
ATOM    278  CD2 HIS A  20      25.649  51.694  33.301  1.00  0.00           C  
ATOM    279  CE1 HIS A  20      24.259  51.301  34.943  1.00  0.00           C  
ATOM    280  NE2 HIS A  20      25.200  50.753  34.122  1.00  0.00           N  
ATOM    281  H   HIS A  20      27.584  54.655  32.581  1.00  0.00           H  
ATOM    282  HA  HIS A  20      25.543  53.303  31.095  1.00  0.00           H  
ATOM    283  HB2 HIS A  20      25.692  54.874  33.641  1.00  0.00           H  
ATOM    284  HB3 HIS A  20      24.129  54.668  32.876  1.00  0.00           H  
ATOM    285  HD1 HIS A  20      23.513  53.234  35.061  1.00  0.00           H  
ATOM    286  HD2 HIS A  20      26.408  51.558  32.529  1.00  0.00           H  
ATOM    287  HE1 HIS A  20      23.707  50.777  35.724  1.00  0.00           H  
ATOM    288  N   ILE A  21      24.178  55.240  30.114  1.00  0.00           N  
ATOM    289  CA  ILE A  21      23.625  56.269  29.252  1.00  0.00           C  
ATOM    290  C   ILE A  21      22.211  56.618  29.722  1.00  0.00           C  
ATOM    291  O   ILE A  21      21.367  55.736  29.870  1.00  0.00           O  
ATOM    292  CB  ILE A  21      23.696  55.835  27.787  1.00  0.00           C  
ATOM    293  CG1 ILE A  21      25.039  55.173  27.475  1.00  0.00           C  
ATOM    294  CG2 ILE A  21      23.406  57.012  26.851  1.00  0.00           C  
ATOM    295  CD1 ILE A  21      26.053  56.201  26.967  1.00  0.00           C  
ATOM    296  H   ILE A  21      23.615  54.419  30.208  1.00  0.00           H  
ATOM    297  HA  ILE A  21      24.253  57.155  29.356  1.00  0.00           H  
ATOM    298  HB  ILE A  21      22.921  55.089  27.614  1.00  0.00           H  
ATOM    299 HG12 ILE A  21      25.426  54.688  28.371  1.00  0.00           H  
ATOM    300 HG13 ILE A  21      24.899  54.394  26.726  1.00  0.00           H  
ATOM    301 HG21 ILE A  21      23.968  56.887  25.926  1.00  0.00           H  
ATOM    302 HG22 ILE A  21      22.339  57.044  26.628  1.00  0.00           H  
ATOM    303 HG23 ILE A  21      23.704  57.942  27.335  1.00  0.00           H  
ATOM    304 HD11 ILE A  21      27.051  55.928  27.311  1.00  0.00           H  
ATOM    305 HD12 ILE A  21      26.036  56.219  25.878  1.00  0.00           H  
ATOM    306 HD13 ILE A  21      25.794  57.188  27.352  1.00  0.00           H  
ATOM    307  N   SER A  22      21.996  57.907  29.944  1.00  0.00           N  
ATOM    308  CA  SER A  22      20.701  58.383  30.395  1.00  0.00           C  
ATOM    309  C   SER A  22      20.285  59.613  29.586  1.00  0.00           C  
ATOM    310  O   SER A  22      21.031  60.586  29.502  1.00  0.00           O  
ATOM    311  CB  SER A  22      20.724  58.713  31.889  1.00  0.00           C  
ATOM    312  OG  SER A  22      21.970  58.374  32.491  1.00  0.00           O  
ATOM    313  H   SER A  22      22.689  58.618  29.821  1.00  0.00           H  
ATOM    314  HA  SER A  22      20.012  57.557  30.217  1.00  0.00           H  
ATOM    315  HB2 SER A  22      20.531  59.777  32.027  1.00  0.00           H  
ATOM    316  HB3 SER A  22      19.920  58.176  32.392  1.00  0.00           H  
ATOM    317  HG  SER A  22      21.858  58.283  33.481  1.00  0.00           H  
ATOM    318  N   PRO A  23      19.062  59.526  28.995  1.00  0.00           N  
ATOM    319  CA  PRO A  23      18.242  58.337  29.145  1.00  0.00           C  
ATOM    320  C   PRO A  23      18.776  57.189  28.286  1.00  0.00           C  
ATOM    321  O   PRO A  23      19.842  57.305  27.684  1.00  0.00           O  
ATOM    322  CB  PRO A  23      16.841  58.772  28.749  1.00  0.00           C  
ATOM    323  CG  PRO A  23      17.013  60.054  27.951  1.00  0.00           C  
ATOM    324  CD  PRO A  23      18.432  60.553  28.173  1.00  0.00           C  
ATOM    325  HA  PRO A  23      18.275  58.009  30.090  1.00  0.00           H  
ATOM    326  HB2 PRO A  23      16.347  58.005  28.153  1.00  0.00           H  
ATOM    327  HB3 PRO A  23      16.219  58.940  29.629  1.00  0.00           H  
ATOM    328  HG2 PRO A  23      16.833  59.872  26.891  1.00  0.00           H  
ATOM    329  HG3 PRO A  23      16.290  60.803  28.272  1.00  0.00           H  
ATOM    330  HD2 PRO A  23      18.958  60.683  27.227  1.00  0.00           H  
ATOM    331  HD3 PRO A  23      18.436  61.521  28.675  1.00  0.00           H  
ATOM    332  N   ALA A  24      18.011  56.108  28.256  1.00  0.00           N  
ATOM    333  CA  ALA A  24      18.395  54.941  27.481  1.00  0.00           C  
ATOM    334  C   ALA A  24      18.405  55.302  25.995  1.00  0.00           C  
ATOM    335  O   ALA A  24      19.460  55.588  25.429  1.00  0.00           O  
ATOM    336  CB  ALA A  24      17.442  53.784  27.793  1.00  0.00           C  
ATOM    337  H   ALA A  24      17.146  56.022  28.749  1.00  0.00           H  
ATOM    338  HA  ALA A  24      19.402  54.657  27.785  1.00  0.00           H  
ATOM    339  HB1 ALA A  24      16.932  53.477  26.880  1.00  0.00           H  
ATOM    340  HB2 ALA A  24      18.011  52.943  28.192  1.00  0.00           H  
ATOM    341  HB3 ALA A  24      16.707  54.108  28.530  1.00  0.00           H  
ATOM    342  N   GLU A  25      17.220  55.278  25.403  1.00  0.00           N  
ATOM    343  CA  GLU A  25      17.079  55.600  23.994  1.00  0.00           C  
ATOM    344  C   GLU A  25      15.776  56.364  23.751  1.00  0.00           C  
ATOM    345  O   GLU A  25      14.884  55.875  23.060  1.00  0.00           O  
ATOM    346  CB  GLU A  25      17.141  54.336  23.133  1.00  0.00           C  
ATOM    347  CG  GLU A  25      18.590  53.967  22.805  1.00  0.00           C  
ATOM    348  CD  GLU A  25      18.648  52.884  21.726  1.00  0.00           C  
ATOM    349  OE1 GLU A  25      18.117  53.148  20.627  1.00  0.00           O  
ATOM    350  OE2 GLU A  25      19.222  51.814  22.027  1.00  0.00           O  
ATOM    351  H   GLU A  25      16.367  55.044  25.871  1.00  0.00           H  
ATOM    352  HA  GLU A  25      17.931  56.237  23.756  1.00  0.00           H  
ATOM    353  HB2 GLU A  25      16.663  53.510  23.660  1.00  0.00           H  
ATOM    354  HB3 GLU A  25      16.583  54.492  22.211  1.00  0.00           H  
ATOM    355  HG2 GLU A  25      19.125  54.853  22.464  1.00  0.00           H  
ATOM    356  HG3 GLU A  25      19.093  53.617  23.706  1.00  0.00           H  
ATOM    357  N   GLU A  26      15.707  57.553  24.334  1.00  0.00           N  
ATOM    358  CA  GLU A  26      14.529  58.389  24.190  1.00  0.00           C  
ATOM    359  C   GLU A  26      14.853  59.834  24.573  1.00  0.00           C  
ATOM    360  O   GLU A  26      14.977  60.154  25.754  1.00  0.00           O  
ATOM    361  CB  GLU A  26      13.366  57.848  25.025  1.00  0.00           C  
ATOM    362  CG  GLU A  26      13.734  57.800  26.510  1.00  0.00           C  
ATOM    363  CD  GLU A  26      12.907  58.806  27.312  1.00  0.00           C  
ATOM    364  OE1 GLU A  26      11.666  58.755  27.179  1.00  0.00           O  
ATOM    365  OE2 GLU A  26      13.535  59.603  28.042  1.00  0.00           O  
ATOM    366  H   GLU A  26      16.437  57.944  24.895  1.00  0.00           H  
ATOM    367  HA  GLU A  26      14.264  58.337  23.134  1.00  0.00           H  
ATOM    368  HB2 GLU A  26      12.488  58.478  24.885  1.00  0.00           H  
ATOM    369  HB3 GLU A  26      13.100  56.849  24.681  1.00  0.00           H  
ATOM    370  HG2 GLU A  26      13.567  56.794  26.897  1.00  0.00           H  
ATOM    371  HG3 GLU A  26      14.795  58.016  26.632  1.00  0.00           H  
ATOM    372  N   LEU A  27      14.981  60.670  23.552  1.00  0.00           N  
ATOM    373  CA  LEU A  27      15.289  62.073  23.767  1.00  0.00           C  
ATOM    374  C   LEU A  27      14.017  62.903  23.588  1.00  0.00           C  
ATOM    375  O   LEU A  27      13.260  62.689  22.642  1.00  0.00           O  
ATOM    376  CB  LEU A  27      16.443  62.513  22.864  1.00  0.00           C  
ATOM    377  CG  LEU A  27      17.846  62.109  23.323  1.00  0.00           C  
ATOM    378  CD1 LEU A  27      18.902  62.541  22.304  1.00  0.00           C  
ATOM    379  CD2 LEU A  27      18.143  62.655  24.721  1.00  0.00           C  
ATOM    380  H   LEU A  27      14.879  60.401  22.594  1.00  0.00           H  
ATOM    381  HA  LEU A  27      15.629  62.179  24.798  1.00  0.00           H  
ATOM    382  HB2 LEU A  27      16.276  62.102  21.869  1.00  0.00           H  
ATOM    383  HB3 LEU A  27      16.411  63.598  22.770  1.00  0.00           H  
ATOM    384  HG  LEU A  27      17.885  61.022  23.387  1.00  0.00           H  
ATOM    385 HD11 LEU A  27      19.891  62.481  22.757  1.00  0.00           H  
ATOM    386 HD12 LEU A  27      18.859  61.882  21.436  1.00  0.00           H  
ATOM    387 HD13 LEU A  27      18.707  63.567  21.991  1.00  0.00           H  
ATOM    388 HD21 LEU A  27      19.106  63.165  24.715  1.00  0.00           H  
ATOM    389 HD22 LEU A  27      17.362  63.358  25.011  1.00  0.00           H  
ATOM    390 HD23 LEU A  27      18.172  61.831  25.434  1.00  0.00           H  
ATOM    391  N   TYR A  28      13.821  63.834  24.511  1.00  0.00           N  
ATOM    392  CA  TYR A  28      12.653  64.697  24.466  1.00  0.00           C  
ATOM    393  C   TYR A  28      13.052  66.166  24.611  1.00  0.00           C  
ATOM    394  O   TYR A  28      13.173  66.674  25.725  1.00  0.00           O  
ATOM    395  CB  TYR A  28      11.786  64.296  25.662  1.00  0.00           C  
ATOM    396  CG  TYR A  28      10.637  63.349  25.308  1.00  0.00           C  
ATOM    397  CD1 TYR A  28       9.736  63.697  24.322  1.00  0.00           C  
ATOM    398  CD2 TYR A  28      10.501  62.149  25.975  1.00  0.00           C  
ATOM    399  CE1 TYR A  28       8.654  62.807  23.990  1.00  0.00           C  
ATOM    400  CE2 TYR A  28       9.420  61.258  25.643  1.00  0.00           C  
ATOM    401  CZ  TYR A  28       8.550  61.631  24.666  1.00  0.00           C  
ATOM    402  OH  TYR A  28       7.528  60.790  24.351  1.00  0.00           O  
ATOM    403  H   TYR A  28      14.441  64.001  25.277  1.00  0.00           H  
ATOM    404  HA  TYR A  28      12.164  64.554  23.502  1.00  0.00           H  
ATOM    405  HB2 TYR A  28      12.418  63.819  26.412  1.00  0.00           H  
ATOM    406  HB3 TYR A  28      11.375  65.196  26.117  1.00  0.00           H  
ATOM    407  HD1 TYR A  28       9.842  64.645  23.796  1.00  0.00           H  
ATOM    408  HD2 TYR A  28      11.214  61.875  26.754  1.00  0.00           H  
ATOM    409  HE1 TYR A  28       7.935  63.068  23.214  1.00  0.00           H  
ATOM    410  HE2 TYR A  28       9.301  60.308  26.161  1.00  0.00           H  
ATOM    411  HH  TYR A  28       6.878  61.253  23.749  1.00  0.00           H  
ATOM    412  N   PHE A  29      13.244  66.810  23.468  1.00  0.00           N  
ATOM    413  CA  PHE A  29      13.627  68.211  23.454  1.00  0.00           C  
ATOM    414  C   PHE A  29      12.430  69.109  23.772  1.00  0.00           C  
ATOM    415  O   PHE A  29      11.767  69.612  22.866  1.00  0.00           O  
ATOM    416  CB  PHE A  29      14.122  68.525  22.040  1.00  0.00           C  
ATOM    417  CG  PHE A  29      15.524  67.990  21.740  1.00  0.00           C  
ATOM    418  CD1 PHE A  29      15.693  66.690  21.377  1.00  0.00           C  
ATOM    419  CD2 PHE A  29      16.602  68.815  21.837  1.00  0.00           C  
ATOM    420  CE1 PHE A  29      16.994  66.194  21.098  1.00  0.00           C  
ATOM    421  CE2 PHE A  29      17.902  68.319  21.557  1.00  0.00           C  
ATOM    422  CZ  PHE A  29      18.071  67.019  21.194  1.00  0.00           C  
ATOM    423  H   PHE A  29      13.142  66.390  22.567  1.00  0.00           H  
ATOM    424  HA  PHE A  29      14.393  68.346  24.217  1.00  0.00           H  
ATOM    425  HB2 PHE A  29      13.422  68.104  21.319  1.00  0.00           H  
ATOM    426  HB3 PHE A  29      14.119  69.605  21.897  1.00  0.00           H  
ATOM    427  HD1 PHE A  29      14.830  66.030  21.300  1.00  0.00           H  
ATOM    428  HD2 PHE A  29      16.467  69.856  22.128  1.00  0.00           H  
ATOM    429  HE1 PHE A  29      17.129  65.153  20.807  1.00  0.00           H  
ATOM    430  HE2 PHE A  29      18.766  68.979  21.635  1.00  0.00           H  
ATOM    431  HZ  PHE A  29      19.070  66.637  20.980  1.00  0.00           H  
ATOM    432  N   GLY A  30      12.190  69.286  25.063  1.00  0.00           N  
ATOM    433  CA  GLY A  30      11.085  70.115  25.513  1.00  0.00           C  
ATOM    434  C   GLY A  30      10.729  69.811  26.969  1.00  0.00           C  
ATOM    435  O   GLY A  30      10.172  68.756  27.270  1.00  0.00           O  
ATOM    436  H   GLY A  30      12.734  68.874  25.794  1.00  0.00           H  
ATOM    437  HA2 GLY A  30      11.350  71.167  25.412  1.00  0.00           H  
ATOM    438  HA3 GLY A  30      10.215  69.943  24.878  1.00  0.00           H  
ATOM    439  N   SER A  31      11.064  70.755  27.837  1.00  0.00           N  
ATOM    440  CA  SER A  31      10.787  70.602  29.255  1.00  0.00           C  
ATOM    441  C   SER A  31       9.470  71.295  29.608  1.00  0.00           C  
ATOM    442  O   SER A  31       8.978  72.126  28.847  1.00  0.00           O  
ATOM    443  CB  SER A  31      11.928  71.166  30.103  1.00  0.00           C  
ATOM    444  OG  SER A  31      12.437  70.203  31.022  1.00  0.00           O  
ATOM    445  H   SER A  31      11.517  71.611  27.585  1.00  0.00           H  
ATOM    446  HA  SER A  31      10.710  69.527  29.419  1.00  0.00           H  
ATOM    447  HB2 SER A  31      12.732  71.504  29.451  1.00  0.00           H  
ATOM    448  HB3 SER A  31      11.574  72.039  30.652  1.00  0.00           H  
ATOM    449  HG  SER A  31      11.988  70.308  31.911  1.00  0.00           H  
ATOM    450  N   ILE A  32       8.936  70.927  30.764  1.00  0.00           N  
ATOM    451  CA  ILE A  32       7.685  71.503  31.228  1.00  0.00           C  
ATOM    452  C   ILE A  32       7.802  73.028  31.233  1.00  0.00           C  
ATOM    453  O   ILE A  32       6.814  73.731  31.026  1.00  0.00           O  
ATOM    454  CB  ILE A  32       7.292  70.912  32.583  1.00  0.00           C  
ATOM    455  CG1 ILE A  32       5.781  71.002  32.804  1.00  0.00           C  
ATOM    456  CG2 ILE A  32       8.078  71.573  33.718  1.00  0.00           C  
ATOM    457  CD1 ILE A  32       5.350  70.150  33.999  1.00  0.00           C  
ATOM    458  H   ILE A  32       9.342  70.251  31.377  1.00  0.00           H  
ATOM    459  HA  ILE A  32       6.910  71.218  30.516  1.00  0.00           H  
ATOM    460  HB  ILE A  32       7.556  69.855  32.583  1.00  0.00           H  
ATOM    461 HG12 ILE A  32       5.496  72.040  32.970  1.00  0.00           H  
ATOM    462 HG13 ILE A  32       5.258  70.667  31.908  1.00  0.00           H  
ATOM    463 HG21 ILE A  32       7.438  72.290  34.231  1.00  0.00           H  
ATOM    464 HG22 ILE A  32       8.408  70.810  34.423  1.00  0.00           H  
ATOM    465 HG23 ILE A  32       8.946  72.088  33.306  1.00  0.00           H  
ATOM    466 HD11 ILE A  32       6.215  69.621  34.399  1.00  0.00           H  
ATOM    467 HD12 ILE A  32       4.930  70.795  34.771  1.00  0.00           H  
ATOM    468 HD13 ILE A  32       4.598  69.429  33.680  1.00  0.00           H  
ATOM    469  N   GLU A  33       9.018  73.496  31.472  1.00  0.00           N  
ATOM    470  CA  GLU A  33       9.277  74.926  31.507  1.00  0.00           C  
ATOM    471  C   GLU A  33       9.193  75.515  30.097  1.00  0.00           C  
ATOM    472  O   GLU A  33       9.489  74.833  29.116  1.00  0.00           O  
ATOM    473  CB  GLU A  33      10.636  75.221  32.144  1.00  0.00           C  
ATOM    474  CG  GLU A  33      10.528  75.263  33.670  1.00  0.00           C  
ATOM    475  CD  GLU A  33      10.482  76.706  34.177  1.00  0.00           C  
ATOM    476  OE1 GLU A  33       9.462  77.373  33.901  1.00  0.00           O  
ATOM    477  OE2 GLU A  33      11.471  77.110  34.829  1.00  0.00           O  
ATOM    478  H   GLU A  33       9.817  72.918  31.639  1.00  0.00           H  
ATOM    479  HA  GLU A  33       8.490  75.347  32.131  1.00  0.00           H  
ATOM    480  HB2 GLU A  33      11.355  74.458  31.848  1.00  0.00           H  
ATOM    481  HB3 GLU A  33      11.015  76.175  31.777  1.00  0.00           H  
ATOM    482  HG2 GLU A  33       9.632  74.733  33.989  1.00  0.00           H  
ATOM    483  HG3 GLU A  33      11.379  74.745  34.112  1.00  0.00           H  
ATOM    484  N   SER A  34       8.788  76.775  30.040  1.00  0.00           N  
ATOM    485  CA  SER A  34       8.661  77.463  28.767  1.00  0.00           C  
ATOM    486  C   SER A  34       9.958  78.209  28.444  1.00  0.00           C  
ATOM    487  O   SER A  34       9.932  79.250  27.788  1.00  0.00           O  
ATOM    488  CB  SER A  34       7.480  78.435  28.782  1.00  0.00           C  
ATOM    489  OG  SER A  34       6.272  77.800  29.193  1.00  0.00           O  
ATOM    490  H   SER A  34       8.549  77.322  30.842  1.00  0.00           H  
ATOM    491  HA  SER A  34       8.477  76.680  28.032  1.00  0.00           H  
ATOM    492  HB2 SER A  34       7.700  79.264  29.454  1.00  0.00           H  
ATOM    493  HB3 SER A  34       7.346  78.859  27.786  1.00  0.00           H  
ATOM    494  HG  SER A  34       6.450  77.192  29.966  1.00  0.00           H  
ATOM    495  N   GLY A  35      11.060  77.648  28.919  1.00  0.00           N  
ATOM    496  CA  GLY A  35      12.364  78.247  28.688  1.00  0.00           C  
ATOM    497  C   GLY A  35      13.015  77.673  27.430  1.00  0.00           C  
ATOM    498  O   GLY A  35      12.582  77.961  26.315  1.00  0.00           O  
ATOM    499  H   GLY A  35      11.072  76.801  29.450  1.00  0.00           H  
ATOM    500  HA2 GLY A  35      12.259  79.328  28.588  1.00  0.00           H  
ATOM    501  HA3 GLY A  35      13.007  78.068  29.550  1.00  0.00           H  
ATOM    502  N   GLU A  36      14.048  76.871  27.649  1.00  0.00           N  
ATOM    503  CA  GLU A  36      14.764  76.255  26.546  1.00  0.00           C  
ATOM    504  C   GLU A  36      14.314  74.803  26.366  1.00  0.00           C  
ATOM    505  O   GLU A  36      13.792  74.192  27.296  1.00  0.00           O  
ATOM    506  CB  GLU A  36      16.277  76.338  26.760  1.00  0.00           C  
ATOM    507  CG  GLU A  36      16.807  77.727  26.400  1.00  0.00           C  
ATOM    508  CD  GLU A  36      17.367  78.436  27.633  1.00  0.00           C  
ATOM    509  OE1 GLU A  36      16.571  79.135  28.297  1.00  0.00           O  
ATOM    510  OE2 GLU A  36      18.580  78.266  27.884  1.00  0.00           O  
ATOM    511  H   GLU A  36      14.394  76.643  28.558  1.00  0.00           H  
ATOM    512  HA  GLU A  36      14.496  76.837  25.664  1.00  0.00           H  
ATOM    513  HB2 GLU A  36      16.513  76.113  27.800  1.00  0.00           H  
ATOM    514  HB3 GLU A  36      16.776  75.585  26.149  1.00  0.00           H  
ATOM    515  HG2 GLU A  36      17.585  77.638  25.641  1.00  0.00           H  
ATOM    516  HG3 GLU A  36      16.005  78.324  25.965  1.00  0.00           H  
ATOM    517  N   LYS A  37      14.534  74.294  25.162  1.00  0.00           N  
ATOM    518  CA  LYS A  37      14.158  72.926  24.849  1.00  0.00           C  
ATOM    519  C   LYS A  37      15.417  72.112  24.545  1.00  0.00           C  
ATOM    520  O   LYS A  37      15.590  71.623  23.430  1.00  0.00           O  
ATOM    521  CB  LYS A  37      13.121  72.900  23.723  1.00  0.00           C  
ATOM    522  CG  LYS A  37      12.092  74.017  23.900  1.00  0.00           C  
ATOM    523  CD  LYS A  37      10.874  73.789  23.001  1.00  0.00           C  
ATOM    524  CE  LYS A  37      10.802  74.846  21.898  1.00  0.00           C  
ATOM    525  NZ  LYS A  37       9.841  74.434  20.849  1.00  0.00           N  
ATOM    526  H   LYS A  37      14.959  74.798  24.411  1.00  0.00           H  
ATOM    527  HA  LYS A  37      13.682  72.507  25.735  1.00  0.00           H  
ATOM    528  HB2 LYS A  37      13.622  73.010  22.761  1.00  0.00           H  
ATOM    529  HB3 LYS A  37      12.617  71.934  23.711  1.00  0.00           H  
ATOM    530  HG2 LYS A  37      11.776  74.064  24.942  1.00  0.00           H  
ATOM    531  HG3 LYS A  37      12.548  74.979  23.662  1.00  0.00           H  
ATOM    532  HD2 LYS A  37      10.929  72.796  22.556  1.00  0.00           H  
ATOM    533  HD3 LYS A  37       9.965  73.820  23.601  1.00  0.00           H  
ATOM    534  HE2 LYS A  37      10.497  75.803  22.322  1.00  0.00           H  
ATOM    535  HE3 LYS A  37      11.788  74.991  21.459  1.00  0.00           H  
ATOM    536  HZ1 LYS A  37       9.842  73.437  20.770  1.00  0.00           H  
ATOM    537  HZ2 LYS A  37       8.925  74.749  21.094  1.00  0.00           H  
ATOM    538  HZ3 LYS A  37      10.110  74.838  19.975  1.00  0.00           H  
ATOM    539  N   LYS A  38      16.265  71.993  25.556  1.00  0.00           N  
ATOM    540  CA  LYS A  38      17.504  71.247  25.410  1.00  0.00           C  
ATOM    541  C   LYS A  38      17.466  70.022  26.326  1.00  0.00           C  
ATOM    542  O   LYS A  38      16.939  70.087  27.436  1.00  0.00           O  
ATOM    543  CB  LYS A  38      18.709  72.158  25.651  1.00  0.00           C  
ATOM    544  CG  LYS A  38      18.766  72.618  27.109  1.00  0.00           C  
ATOM    545  CD  LYS A  38      19.727  71.747  27.921  1.00  0.00           C  
ATOM    546  CE  LYS A  38      20.657  72.608  28.778  1.00  0.00           C  
ATOM    547  NZ  LYS A  38      19.918  73.188  29.921  1.00  0.00           N  
ATOM    548  H   LYS A  38      16.117  72.394  26.460  1.00  0.00           H  
ATOM    549  HA  LYS A  38      17.559  70.904  24.377  1.00  0.00           H  
ATOM    550  HB2 LYS A  38      19.627  71.628  25.396  1.00  0.00           H  
ATOM    551  HB3 LYS A  38      18.650  73.026  24.994  1.00  0.00           H  
ATOM    552  HG2 LYS A  38      19.088  73.658  27.152  1.00  0.00           H  
ATOM    553  HG3 LYS A  38      17.770  72.574  27.547  1.00  0.00           H  
ATOM    554  HD2 LYS A  38      19.158  71.071  28.561  1.00  0.00           H  
ATOM    555  HD3 LYS A  38      20.317  71.126  27.248  1.00  0.00           H  
ATOM    556  HE2 LYS A  38      21.487  72.004  29.143  1.00  0.00           H  
ATOM    557  HE3 LYS A  38      21.084  73.406  28.172  1.00  0.00           H  
ATOM    558  HZ1 LYS A  38      19.832  74.177  29.796  1.00  0.00           H  
ATOM    559  HZ2 LYS A  38      19.007  72.778  29.973  1.00  0.00           H  
ATOM    560  HZ3 LYS A  38      20.415  73.002  30.769  1.00  0.00           H  
ATOM    561  N   THR A  39      18.032  68.933  25.828  1.00  0.00           N  
ATOM    562  CA  THR A  39      18.070  67.695  26.587  1.00  0.00           C  
ATOM    563  C   THR A  39      19.446  67.505  27.229  1.00  0.00           C  
ATOM    564  O   THR A  39      20.465  67.860  26.638  1.00  0.00           O  
ATOM    565  CB  THR A  39      17.675  66.552  25.649  1.00  0.00           C  
ATOM    566  OG1 THR A  39      17.583  65.416  26.505  1.00  0.00           O  
ATOM    567  CG2 THR A  39      18.790  66.189  24.666  1.00  0.00           C  
ATOM    568  H   THR A  39      18.458  68.887  24.924  1.00  0.00           H  
ATOM    569  HA  THR A  39      17.346  67.766  27.398  1.00  0.00           H  
ATOM    570  HB  THR A  39      16.750  66.784  25.121  1.00  0.00           H  
ATOM    571  HG1 THR A  39      18.442  65.291  27.001  1.00  0.00           H  
ATOM    572 HG21 THR A  39      18.537  65.259  24.157  1.00  0.00           H  
ATOM    573 HG22 THR A  39      18.900  66.987  23.931  1.00  0.00           H  
ATOM    574 HG23 THR A  39      19.727  66.063  25.209  1.00  0.00           H  
ATOM    575  N   LEU A  40      19.431  66.945  28.429  1.00  0.00           N  
ATOM    576  CA  LEU A  40      20.665  66.704  29.159  1.00  0.00           C  
ATOM    577  C   LEU A  40      20.841  65.200  29.371  1.00  0.00           C  
ATOM    578  O   LEU A  40      19.997  64.554  29.991  1.00  0.00           O  
ATOM    579  CB  LEU A  40      20.688  67.516  30.456  1.00  0.00           C  
ATOM    580  CG  LEU A  40      22.016  67.526  31.216  1.00  0.00           C  
ATOM    581  CD1 LEU A  40      23.186  67.226  30.279  1.00  0.00           C  
ATOM    582  CD2 LEU A  40      22.207  68.845  31.968  1.00  0.00           C  
ATOM    583  H   LEU A  40      18.598  66.660  28.903  1.00  0.00           H  
ATOM    584  HA  LEU A  40      21.486  67.064  28.539  1.00  0.00           H  
ATOM    585  HB2 LEU A  40      20.418  68.546  30.221  1.00  0.00           H  
ATOM    586  HB3 LEU A  40      19.915  67.126  31.118  1.00  0.00           H  
ATOM    587  HG  LEU A  40      21.988  66.732  31.962  1.00  0.00           H  
ATOM    588 HD11 LEU A  40      23.151  66.179  29.976  1.00  0.00           H  
ATOM    589 HD12 LEU A  40      23.119  67.862  29.396  1.00  0.00           H  
ATOM    590 HD13 LEU A  40      24.126  67.423  30.796  1.00  0.00           H  
ATOM    591 HD21 LEU A  40      21.365  69.003  32.643  1.00  0.00           H  
ATOM    592 HD22 LEU A  40      23.131  68.805  32.544  1.00  0.00           H  
ATOM    593 HD23 LEU A  40      22.259  69.667  31.254  1.00  0.00           H  
ATOM    594  N   ILE A  41      21.943  64.685  28.845  1.00  0.00           N  
ATOM    595  CA  ILE A  41      22.241  63.268  28.969  1.00  0.00           C  
ATOM    596  C   ILE A  41      23.067  63.034  30.236  1.00  0.00           C  
ATOM    597  O   ILE A  41      23.855  63.890  30.634  1.00  0.00           O  
ATOM    598  CB  ILE A  41      22.907  62.747  27.696  1.00  0.00           C  
ATOM    599  CG1 ILE A  41      22.199  63.280  26.449  1.00  0.00           C  
ATOM    600  CG2 ILE A  41      22.983  61.219  27.702  1.00  0.00           C  
ATOM    601  CD1 ILE A  41      23.056  63.067  25.198  1.00  0.00           C  
ATOM    602  H   ILE A  41      22.624  65.217  28.343  1.00  0.00           H  
ATOM    603  HA  ILE A  41      21.290  62.743  29.075  1.00  0.00           H  
ATOM    604  HB  ILE A  41      23.931  63.120  27.669  1.00  0.00           H  
ATOM    605 HG12 ILE A  41      21.241  62.776  26.326  1.00  0.00           H  
ATOM    606 HG13 ILE A  41      21.988  64.342  26.572  1.00  0.00           H  
ATOM    607 HG21 ILE A  41      23.217  60.871  28.708  1.00  0.00           H  
ATOM    608 HG22 ILE A  41      22.024  60.807  27.388  1.00  0.00           H  
ATOM    609 HG23 ILE A  41      23.763  60.891  27.014  1.00  0.00           H  
ATOM    610 HD11 ILE A  41      22.497  62.479  24.471  1.00  0.00           H  
ATOM    611 HD12 ILE A  41      23.312  64.034  24.764  1.00  0.00           H  
ATOM    612 HD13 ILE A  41      23.970  62.538  25.470  1.00  0.00           H  
ATOM    613  N   VAL A  42      22.857  61.871  30.835  1.00  0.00           N  
ATOM    614  CA  VAL A  42      23.572  61.513  32.047  1.00  0.00           C  
ATOM    615  C   VAL A  42      24.371  60.231  31.805  1.00  0.00           C  
ATOM    616  O   VAL A  42      23.839  59.255  31.277  1.00  0.00           O  
ATOM    617  CB  VAL A  42      22.593  61.396  33.217  1.00  0.00           C  
ATOM    618  CG1 VAL A  42      23.339  61.306  34.550  1.00  0.00           C  
ATOM    619  CG2 VAL A  42      21.601  62.561  33.221  1.00  0.00           C  
ATOM    620  H   VAL A  42      22.213  61.180  30.505  1.00  0.00           H  
ATOM    621  HA  VAL A  42      24.268  62.323  32.270  1.00  0.00           H  
ATOM    622  HB  VAL A  42      22.027  60.474  33.088  1.00  0.00           H  
ATOM    623 HG11 VAL A  42      23.567  60.263  34.770  1.00  0.00           H  
ATOM    624 HG12 VAL A  42      24.267  61.875  34.486  1.00  0.00           H  
ATOM    625 HG13 VAL A  42      22.715  61.717  35.344  1.00  0.00           H  
ATOM    626 HG21 VAL A  42      20.708  62.279  32.663  1.00  0.00           H  
ATOM    627 HG22 VAL A  42      21.328  62.802  34.248  1.00  0.00           H  
ATOM    628 HG23 VAL A  42      22.061  63.431  32.754  1.00  0.00           H  
ATOM    629  N   LEU A  43      25.634  60.274  32.202  1.00  0.00           N  
ATOM    630  CA  LEU A  43      26.511  59.127  32.034  1.00  0.00           C  
ATOM    631  C   LEU A  43      27.044  58.695  33.401  1.00  0.00           C  
ATOM    632  O   LEU A  43      27.845  59.401  34.011  1.00  0.00           O  
ATOM    633  CB  LEU A  43      27.609  59.437  31.015  1.00  0.00           C  
ATOM    634  CG  LEU A  43      27.139  59.999  29.672  1.00  0.00           C  
ATOM    635  CD1 LEU A  43      28.306  60.613  28.895  1.00  0.00           C  
ATOM    636  CD2 LEU A  43      26.406  58.931  28.857  1.00  0.00           C  
ATOM    637  H   LEU A  43      26.058  61.071  32.630  1.00  0.00           H  
ATOM    638  HA  LEU A  43      25.911  58.314  31.624  1.00  0.00           H  
ATOM    639  HB2 LEU A  43      28.301  60.151  31.462  1.00  0.00           H  
ATOM    640  HB3 LEU A  43      28.171  58.523  30.827  1.00  0.00           H  
ATOM    641  HG  LEU A  43      26.425  60.800  29.867  1.00  0.00           H  
ATOM    642 HD11 LEU A  43      28.014  60.758  27.855  1.00  0.00           H  
ATOM    643 HD12 LEU A  43      28.570  61.575  29.336  1.00  0.00           H  
ATOM    644 HD13 LEU A  43      29.164  59.944  28.942  1.00  0.00           H  
ATOM    645 HD21 LEU A  43      26.295  59.272  27.828  1.00  0.00           H  
ATOM    646 HD22 LEU A  43      26.982  58.005  28.872  1.00  0.00           H  
ATOM    647 HD23 LEU A  43      25.422  58.755  29.289  1.00  0.00           H  
ATOM    648  N   THR A  44      26.579  57.534  33.842  1.00  0.00           N  
ATOM    649  CA  THR A  44      27.000  56.999  35.125  1.00  0.00           C  
ATOM    650  C   THR A  44      28.061  55.915  34.929  1.00  0.00           C  
ATOM    651  O   THR A  44      27.754  54.819  34.462  1.00  0.00           O  
ATOM    652  CB  THR A  44      25.754  56.503  35.862  1.00  0.00           C  
ATOM    653  OG1 THR A  44      25.157  57.692  36.375  1.00  0.00           O  
ATOM    654  CG2 THR A  44      26.096  55.689  37.111  1.00  0.00           C  
ATOM    655  H   THR A  44      25.928  56.966  33.339  1.00  0.00           H  
ATOM    656  HA  THR A  44      27.465  57.802  35.697  1.00  0.00           H  
ATOM    657  HB  THR A  44      25.105  55.937  35.193  1.00  0.00           H  
ATOM    658  HG1 THR A  44      24.658  58.166  35.650  1.00  0.00           H  
ATOM    659 HG21 THR A  44      25.738  54.667  36.988  1.00  0.00           H  
ATOM    660 HG22 THR A  44      27.177  55.679  37.253  1.00  0.00           H  
ATOM    661 HG23 THR A  44      25.619  56.140  37.980  1.00  0.00           H  
ATOM    662  N   ASN A  45      29.287  56.259  35.296  1.00  0.00           N  
ATOM    663  CA  ASN A  45      30.395  55.329  35.166  1.00  0.00           C  
ATOM    664  C   ASN A  45      30.310  54.283  36.279  1.00  0.00           C  
ATOM    665  O   ASN A  45      30.745  54.531  37.403  1.00  0.00           O  
ATOM    666  CB  ASN A  45      31.738  56.050  35.295  1.00  0.00           C  
ATOM    667  CG  ASN A  45      32.872  55.207  34.709  1.00  0.00           C  
ATOM    668  OD1 ASN A  45      32.663  54.299  33.922  1.00  0.00           O  
ATOM    669  ND2 ASN A  45      34.082  55.555  35.138  1.00  0.00           N  
ATOM    670  H   ASN A  45      29.527  57.152  35.675  1.00  0.00           H  
ATOM    671  HA  ASN A  45      30.286  54.891  34.173  1.00  0.00           H  
ATOM    672  HB2 ASN A  45      31.690  57.009  34.780  1.00  0.00           H  
ATOM    673  HB3 ASN A  45      31.941  56.261  36.345  1.00  0.00           H  
ATOM    674 HD21 ASN A  45      34.185  56.311  35.786  1.00  0.00           H  
ATOM    675 HD22 ASN A  45      34.890  55.063  34.811  1.00  0.00           H  
ATOM    676  N   VAL A  46      29.749  53.135  35.929  1.00  0.00           N  
ATOM    677  CA  VAL A  46      29.602  52.051  36.885  1.00  0.00           C  
ATOM    678  C   VAL A  46      30.983  51.482  37.220  1.00  0.00           C  
ATOM    679  O   VAL A  46      31.284  51.220  38.383  1.00  0.00           O  
ATOM    680  CB  VAL A  46      28.638  50.997  36.336  1.00  0.00           C  
ATOM    681  CG1 VAL A  46      27.233  51.577  36.162  1.00  0.00           C  
ATOM    682  CG2 VAL A  46      29.156  50.410  35.022  1.00  0.00           C  
ATOM    683  H   VAL A  46      29.398  52.941  35.012  1.00  0.00           H  
ATOM    684  HA  VAL A  46      29.165  52.469  37.792  1.00  0.00           H  
ATOM    685  HB  VAL A  46      28.578  50.187  37.064  1.00  0.00           H  
ATOM    686 HG11 VAL A  46      26.497  50.776  36.242  1.00  0.00           H  
ATOM    687 HG12 VAL A  46      27.048  52.320  36.938  1.00  0.00           H  
ATOM    688 HG13 VAL A  46      27.153  52.047  35.182  1.00  0.00           H  
ATOM    689 HG21 VAL A  46      29.161  51.185  34.256  1.00  0.00           H  
ATOM    690 HG22 VAL A  46      30.170  50.035  35.166  1.00  0.00           H  
ATOM    691 HG23 VAL A  46      28.508  49.593  34.708  1.00  0.00           H  
ATOM    692  N   THR A  47      31.783  51.307  36.179  1.00  0.00           N  
ATOM    693  CA  THR A  47      33.125  50.773  36.348  1.00  0.00           C  
ATOM    694  C   THR A  47      33.858  51.519  37.465  1.00  0.00           C  
ATOM    695  O   THR A  47      33.446  52.607  37.864  1.00  0.00           O  
ATOM    696  CB  THR A  47      33.837  50.849  34.997  1.00  0.00           C  
ATOM    697  OG1 THR A  47      33.491  52.136  34.493  1.00  0.00           O  
ATOM    698  CG2 THR A  47      33.252  49.877  33.971  1.00  0.00           C  
ATOM    699  H   THR A  47      31.530  51.522  35.236  1.00  0.00           H  
ATOM    700  HA  THR A  47      33.044  49.733  36.660  1.00  0.00           H  
ATOM    701  HB  THR A  47      34.910  50.692  35.114  1.00  0.00           H  
ATOM    702  HG1 THR A  47      34.319  52.668  34.316  1.00  0.00           H  
ATOM    703 HG21 THR A  47      32.163  49.922  34.009  1.00  0.00           H  
ATOM    704 HG22 THR A  47      33.593  50.153  32.973  1.00  0.00           H  
ATOM    705 HG23 THR A  47      33.582  48.864  34.201  1.00  0.00           H  
ATOM    706  N   LYS A  48      34.932  50.904  37.937  1.00  0.00           N  
ATOM    707  CA  LYS A  48      35.727  51.496  39.000  1.00  0.00           C  
ATOM    708  C   LYS A  48      36.966  52.159  38.396  1.00  0.00           C  
ATOM    709  O   LYS A  48      37.913  52.482  39.111  1.00  0.00           O  
ATOM    710  CB  LYS A  48      36.049  50.454  40.073  1.00  0.00           C  
ATOM    711  CG  LYS A  48      35.720  50.985  41.470  1.00  0.00           C  
ATOM    712  CD  LYS A  48      36.881  50.741  42.436  1.00  0.00           C  
ATOM    713  CE  LYS A  48      36.462  49.805  43.571  1.00  0.00           C  
ATOM    714  NZ  LYS A  48      36.702  50.444  44.885  1.00  0.00           N  
ATOM    715  H   LYS A  48      35.260  50.019  37.608  1.00  0.00           H  
ATOM    716  HA  LYS A  48      35.117  52.268  39.473  1.00  0.00           H  
ATOM    717  HB2 LYS A  48      35.481  49.543  39.883  1.00  0.00           H  
ATOM    718  HB3 LYS A  48      37.105  50.187  40.020  1.00  0.00           H  
ATOM    719  HG2 LYS A  48      35.506  52.053  41.416  1.00  0.00           H  
ATOM    720  HG3 LYS A  48      34.821  50.498  41.846  1.00  0.00           H  
ATOM    721  HD2 LYS A  48      37.724  50.308  41.896  1.00  0.00           H  
ATOM    722  HD3 LYS A  48      37.221  51.691  42.849  1.00  0.00           H  
ATOM    723  HE2 LYS A  48      35.407  49.552  43.472  1.00  0.00           H  
ATOM    724  HE3 LYS A  48      37.021  48.872  43.507  1.00  0.00           H  
ATOM    725  HZ1 LYS A  48      37.046  49.761  45.529  1.00  0.00           H  
ATOM    726  HZ2 LYS A  48      37.376  51.175  44.782  1.00  0.00           H  
ATOM    727  HZ3 LYS A  48      35.846  50.827  45.231  1.00  0.00           H  
ATOM    728  N   ASN A  49      36.919  52.343  37.084  1.00  0.00           N  
ATOM    729  CA  ASN A  49      38.026  52.962  36.375  1.00  0.00           C  
ATOM    730  C   ASN A  49      37.490  54.080  35.479  1.00  0.00           C  
ATOM    731  O   ASN A  49      36.299  54.119  35.173  1.00  0.00           O  
ATOM    732  CB  ASN A  49      38.746  51.947  35.485  1.00  0.00           C  
ATOM    733  CG  ASN A  49      39.502  50.919  36.328  1.00  0.00           C  
ATOM    734  OD1 ASN A  49      40.291  51.249  37.197  1.00  0.00           O  
ATOM    735  ND2 ASN A  49      39.217  49.655  36.023  1.00  0.00           N  
ATOM    736  H   ASN A  49      36.144  52.077  36.510  1.00  0.00           H  
ATOM    737  HA  ASN A  49      38.692  53.334  37.153  1.00  0.00           H  
ATOM    738  HB2 ASN A  49      38.022  51.440  34.847  1.00  0.00           H  
ATOM    739  HB3 ASN A  49      39.443  52.467  34.826  1.00  0.00           H  
ATOM    740 HD21 ASN A  49      38.559  49.453  35.299  1.00  0.00           H  
ATOM    741 HD22 ASN A  49      39.660  48.909  36.519  1.00  0.00           H  
ATOM    742  N   ILE A  50      38.395  54.964  35.085  1.00  0.00           N  
ATOM    743  CA  ILE A  50      38.029  56.080  34.230  1.00  0.00           C  
ATOM    744  C   ILE A  50      37.491  55.545  32.902  1.00  0.00           C  
ATOM    745  O   ILE A  50      37.950  54.515  32.411  1.00  0.00           O  
ATOM    746  CB  ILE A  50      39.207  57.044  34.072  1.00  0.00           C  
ATOM    747  CG1 ILE A  50      39.768  57.452  35.436  1.00  0.00           C  
ATOM    748  CG2 ILE A  50      38.813  58.258  33.228  1.00  0.00           C  
ATOM    749  CD1 ILE A  50      40.683  58.671  35.310  1.00  0.00           C  
ATOM    750  H   ILE A  50      39.362  54.926  35.338  1.00  0.00           H  
ATOM    751  HA  ILE A  50      37.230  56.627  34.731  1.00  0.00           H  
ATOM    752  HB  ILE A  50      40.003  56.526  33.539  1.00  0.00           H  
ATOM    753 HG12 ILE A  50      38.948  57.676  36.118  1.00  0.00           H  
ATOM    754 HG13 ILE A  50      40.323  56.619  35.868  1.00  0.00           H  
ATOM    755 HG21 ILE A  50      39.702  58.675  32.756  1.00  0.00           H  
ATOM    756 HG22 ILE A  50      38.103  57.951  32.460  1.00  0.00           H  
ATOM    757 HG23 ILE A  50      38.353  59.011  33.868  1.00  0.00           H  
ATOM    758 HD11 ILE A  50      40.119  59.507  34.895  1.00  0.00           H  
ATOM    759 HD12 ILE A  50      41.063  58.943  36.295  1.00  0.00           H  
ATOM    760 HD13 ILE A  50      41.517  58.433  34.651  1.00  0.00           H  
ATOM    761  N   VAL A  51      36.523  56.268  32.356  1.00  0.00           N  
ATOM    762  CA  VAL A  51      35.918  55.879  31.095  1.00  0.00           C  
ATOM    763  C   VAL A  51      35.786  57.110  30.196  1.00  0.00           C  
ATOM    764  O   VAL A  51      35.090  58.064  30.541  1.00  0.00           O  
ATOM    765  CB  VAL A  51      34.581  55.179  31.350  1.00  0.00           C  
ATOM    766  CG1 VAL A  51      33.859  54.879  30.035  1.00  0.00           C  
ATOM    767  CG2 VAL A  51      34.778  53.904  32.170  1.00  0.00           C  
ATOM    768  H   VAL A  51      36.155  57.105  32.762  1.00  0.00           H  
ATOM    769  HA  VAL A  51      36.587  55.165  30.615  1.00  0.00           H  
ATOM    770  HB  VAL A  51      33.954  55.857  31.929  1.00  0.00           H  
ATOM    771 HG11 VAL A  51      33.457  53.866  30.063  1.00  0.00           H  
ATOM    772 HG12 VAL A  51      33.045  55.590  29.897  1.00  0.00           H  
ATOM    773 HG13 VAL A  51      34.562  54.967  29.206  1.00  0.00           H  
ATOM    774 HG21 VAL A  51      35.473  53.241  31.652  1.00  0.00           H  
ATOM    775 HG22 VAL A  51      35.183  54.160  33.149  1.00  0.00           H  
ATOM    776 HG23 VAL A  51      33.819  53.399  32.294  1.00  0.00           H  
ATOM    777  N   ALA A  52      36.466  57.050  29.060  1.00  0.00           N  
ATOM    778  CA  ALA A  52      36.434  58.148  28.109  1.00  0.00           C  
ATOM    779  C   ALA A  52      35.189  58.016  27.228  1.00  0.00           C  
ATOM    780  O   ALA A  52      35.057  57.054  26.473  1.00  0.00           O  
ATOM    781  CB  ALA A  52      37.728  58.155  27.293  1.00  0.00           C  
ATOM    782  H   ALA A  52      37.029  56.270  28.787  1.00  0.00           H  
ATOM    783  HA  ALA A  52      36.371  59.076  28.676  1.00  0.00           H  
ATOM    784  HB1 ALA A  52      38.478  57.546  27.797  1.00  0.00           H  
ATOM    785  HB2 ALA A  52      37.535  57.745  26.302  1.00  0.00           H  
ATOM    786  HB3 ALA A  52      38.092  59.177  27.199  1.00  0.00           H  
ATOM    787  N   PHE A  53      34.309  58.999  27.352  1.00  0.00           N  
ATOM    788  CA  PHE A  53      33.080  59.005  26.577  1.00  0.00           C  
ATOM    789  C   PHE A  53      33.095  60.127  25.536  1.00  0.00           C  
ATOM    790  O   PHE A  53      33.767  61.140  25.720  1.00  0.00           O  
ATOM    791  CB  PHE A  53      31.933  59.252  27.558  1.00  0.00           C  
ATOM    792  CG  PHE A  53      31.851  60.690  28.072  1.00  0.00           C  
ATOM    793  CD1 PHE A  53      32.538  61.054  29.188  1.00  0.00           C  
ATOM    794  CD2 PHE A  53      31.092  61.606  27.412  1.00  0.00           C  
ATOM    795  CE1 PHE A  53      32.463  62.390  29.664  1.00  0.00           C  
ATOM    796  CE2 PHE A  53      31.017  62.941  27.888  1.00  0.00           C  
ATOM    797  CZ  PHE A  53      31.703  63.306  29.005  1.00  0.00           C  
ATOM    798  H   PHE A  53      34.423  59.777  27.969  1.00  0.00           H  
ATOM    799  HA  PHE A  53      33.012  58.043  26.070  1.00  0.00           H  
ATOM    800  HB2 PHE A  53      30.991  58.996  27.072  1.00  0.00           H  
ATOM    801  HB3 PHE A  53      32.045  58.579  28.409  1.00  0.00           H  
ATOM    802  HD1 PHE A  53      33.146  60.321  29.717  1.00  0.00           H  
ATOM    803  HD2 PHE A  53      30.542  61.314  26.517  1.00  0.00           H  
ATOM    804  HE1 PHE A  53      33.013  62.682  30.559  1.00  0.00           H  
ATOM    805  HE2 PHE A  53      30.408  63.675  27.360  1.00  0.00           H  
ATOM    806  HZ  PHE A  53      31.645  64.331  29.370  1.00  0.00           H  
ATOM    807  N   LYS A  54      32.346  59.907  24.465  1.00  0.00           N  
ATOM    808  CA  LYS A  54      32.265  60.886  23.396  1.00  0.00           C  
ATOM    809  C   LYS A  54      30.846  60.891  22.821  1.00  0.00           C  
ATOM    810  O   LYS A  54      30.245  59.835  22.633  1.00  0.00           O  
ATOM    811  CB  LYS A  54      33.350  60.628  22.349  1.00  0.00           C  
ATOM    812  CG  LYS A  54      34.743  60.893  22.926  1.00  0.00           C  
ATOM    813  CD  LYS A  54      35.809  60.843  21.831  1.00  0.00           C  
ATOM    814  CE  LYS A  54      36.807  61.993  21.984  1.00  0.00           C  
ATOM    815  NZ  LYS A  54      37.001  62.689  20.692  1.00  0.00           N  
ATOM    816  H   LYS A  54      31.803  59.080  24.323  1.00  0.00           H  
ATOM    817  HA  LYS A  54      32.464  61.865  23.832  1.00  0.00           H  
ATOM    818  HB2 LYS A  54      33.288  59.597  22.000  1.00  0.00           H  
ATOM    819  HB3 LYS A  54      33.184  61.267  21.482  1.00  0.00           H  
ATOM    820  HG2 LYS A  54      34.759  61.870  23.411  1.00  0.00           H  
ATOM    821  HG3 LYS A  54      34.969  60.153  23.693  1.00  0.00           H  
ATOM    822  HD2 LYS A  54      36.337  59.891  21.873  1.00  0.00           H  
ATOM    823  HD3 LYS A  54      35.333  60.900  20.851  1.00  0.00           H  
ATOM    824  HE2 LYS A  54      36.445  62.699  22.732  1.00  0.00           H  
ATOM    825  HE3 LYS A  54      37.761  61.608  22.345  1.00  0.00           H  
ATOM    826  HZ1 LYS A  54      36.323  62.362  20.033  1.00  0.00           H  
ATOM    827  HZ2 LYS A  54      36.891  63.673  20.824  1.00  0.00           H  
ATOM    828  HZ3 LYS A  54      37.920  62.499  20.347  1.00  0.00           H  
ATOM    829  N   VAL A  55      30.353  62.092  22.559  1.00  0.00           N  
ATOM    830  CA  VAL A  55      29.016  62.249  22.011  1.00  0.00           C  
ATOM    831  C   VAL A  55      29.118  62.620  20.529  1.00  0.00           C  
ATOM    832  O   VAL A  55      29.857  63.532  20.164  1.00  0.00           O  
ATOM    833  CB  VAL A  55      28.231  63.274  22.830  1.00  0.00           C  
ATOM    834  CG1 VAL A  55      26.832  63.486  22.249  1.00  0.00           C  
ATOM    835  CG2 VAL A  55      28.155  62.859  24.301  1.00  0.00           C  
ATOM    836  H   VAL A  55      30.848  62.947  22.715  1.00  0.00           H  
ATOM    837  HA  VAL A  55      28.511  61.288  22.098  1.00  0.00           H  
ATOM    838  HB  VAL A  55      28.763  64.224  22.777  1.00  0.00           H  
ATOM    839 HG11 VAL A  55      26.219  62.606  22.446  1.00  0.00           H  
ATOM    840 HG12 VAL A  55      26.373  64.360  22.713  1.00  0.00           H  
ATOM    841 HG13 VAL A  55      26.905  63.643  21.173  1.00  0.00           H  
ATOM    842 HG21 VAL A  55      28.847  63.467  24.886  1.00  0.00           H  
ATOM    843 HG22 VAL A  55      27.140  63.006  24.669  1.00  0.00           H  
ATOM    844 HG23 VAL A  55      28.428  61.808  24.396  1.00  0.00           H  
ATOM    845  N   ARG A  56      28.364  61.893  19.718  1.00  0.00           N  
ATOM    846  CA  ARG A  56      28.360  62.134  18.285  1.00  0.00           C  
ATOM    847  C   ARG A  56      26.924  62.198  17.761  1.00  0.00           C  
ATOM    848  O   ARG A  56      25.979  61.918  18.496  1.00  0.00           O  
ATOM    849  CB  ARG A  56      29.119  61.034  17.539  1.00  0.00           C  
ATOM    850  CG  ARG A  56      30.608  61.371  17.430  1.00  0.00           C  
ATOM    851  CD  ARG A  56      31.472  60.191  17.876  1.00  0.00           C  
ATOM    852  NE  ARG A  56      32.905  60.535  17.743  1.00  0.00           N  
ATOM    853  CZ  ARG A  56      33.892  59.630  17.684  1.00  0.00           C  
ATOM    854  NH1 ARG A  56      33.607  58.322  17.744  1.00  0.00           N  
ATOM    855  NH2 ARG A  56      35.164  60.033  17.564  1.00  0.00           N  
ATOM    856  H   ARG A  56      27.766  61.152  20.023  1.00  0.00           H  
ATOM    857  HA  ARG A  56      28.866  63.091  18.161  1.00  0.00           H  
ATOM    858  HB2 ARG A  56      28.995  60.084  18.060  1.00  0.00           H  
ATOM    859  HB3 ARG A  56      28.697  60.908  16.542  1.00  0.00           H  
ATOM    860  HG2 ARG A  56      30.850  61.636  16.401  1.00  0.00           H  
ATOM    861  HG3 ARG A  56      30.832  62.244  18.045  1.00  0.00           H  
ATOM    862  HD2 ARG A  56      31.245  59.933  18.910  1.00  0.00           H  
ATOM    863  HD3 ARG A  56      31.243  59.313  17.272  1.00  0.00           H  
ATOM    864  HE  ARG A  56      33.154  61.502  17.696  1.00  0.00           H  
ATOM    865 HH11 ARG A  56      32.658  58.021  17.834  1.00  0.00           H  
ATOM    866 HH12 ARG A  56      34.344  57.647  17.700  1.00  0.00           H  
ATOM    867 HH21 ARG A  56      35.378  61.009  17.518  1.00  0.00           H  
ATOM    868 HH22 ARG A  56      35.901  59.358  17.520  1.00  0.00           H  
ATOM    869  N   THR A  57      26.806  62.568  16.495  1.00  0.00           N  
ATOM    870  CA  THR A  57      25.501  62.672  15.864  1.00  0.00           C  
ATOM    871  C   THR A  57      25.652  62.843  14.351  1.00  0.00           C  
ATOM    872  O   THR A  57      26.720  63.212  13.868  1.00  0.00           O  
ATOM    873  CB  THR A  57      24.743  63.821  16.533  1.00  0.00           C  
ATOM    874  OG1 THR A  57      23.629  64.049  15.673  1.00  0.00           O  
ATOM    875  CG2 THR A  57      25.522  65.138  16.490  1.00  0.00           C  
ATOM    876  H   THR A  57      27.580  62.794  15.903  1.00  0.00           H  
ATOM    877  HA  THR A  57      24.964  61.738  16.029  1.00  0.00           H  
ATOM    878  HB  THR A  57      24.469  63.564  17.555  1.00  0.00           H  
ATOM    879  HG1 THR A  57      22.791  63.715  16.106  1.00  0.00           H  
ATOM    880 HG21 THR A  57      26.404  65.059  17.125  1.00  0.00           H  
ATOM    881 HG22 THR A  57      25.829  65.346  15.465  1.00  0.00           H  
ATOM    882 HG23 THR A  57      24.886  65.947  16.852  1.00  0.00           H  
ATOM    883  N   THR A  58      24.565  62.564  13.645  1.00  0.00           N  
ATOM    884  CA  THR A  58      24.563  62.682  12.197  1.00  0.00           C  
ATOM    885  C   THR A  58      24.570  64.154  11.782  1.00  0.00           C  
ATOM    886  O   THR A  58      24.739  64.470  10.605  1.00  0.00           O  
ATOM    887  CB  THR A  58      23.359  61.904  11.662  1.00  0.00           C  
ATOM    888  OG1 THR A  58      22.249  62.760  11.923  1.00  0.00           O  
ATOM    889  CG2 THR A  58      23.060  60.649  12.482  1.00  0.00           C  
ATOM    890  H   THR A  58      23.700  62.263  14.047  1.00  0.00           H  
ATOM    891  HA  THR A  58      25.481  62.238  11.815  1.00  0.00           H  
ATOM    892  HB  THR A  58      23.490  61.660  10.608  1.00  0.00           H  
ATOM    893  HG1 THR A  58      22.212  62.984  12.896  1.00  0.00           H  
ATOM    894 HG21 THR A  58      23.968  60.323  12.991  1.00  0.00           H  
ATOM    895 HG22 THR A  58      22.290  60.870  13.220  1.00  0.00           H  
ATOM    896 HG23 THR A  58      22.711  59.856  11.819  1.00  0.00           H  
ATOM    897  N   ALA A  59      24.384  65.016  12.771  1.00  0.00           N  
ATOM    898  CA  ALA A  59      24.366  66.447  12.523  1.00  0.00           C  
ATOM    899  C   ALA A  59      24.890  67.181  13.759  1.00  0.00           C  
ATOM    900  O   ALA A  59      24.116  67.782  14.502  1.00  0.00           O  
ATOM    901  CB  ALA A  59      22.949  66.882  12.143  1.00  0.00           C  
ATOM    902  H   ALA A  59      24.246  64.751  13.725  1.00  0.00           H  
ATOM    903  HA  ALA A  59      25.032  66.647  11.683  1.00  0.00           H  
ATOM    904  HB1 ALA A  59      22.563  67.565  12.901  1.00  0.00           H  
ATOM    905  HB2 ALA A  59      22.970  67.387  11.177  1.00  0.00           H  
ATOM    906  HB3 ALA A  59      22.304  66.007  12.081  1.00  0.00           H  
ATOM    907  N   PRO A  60      26.235  67.106  13.945  1.00  0.00           N  
ATOM    908  CA  PRO A  60      26.872  67.756  15.078  1.00  0.00           C  
ATOM    909  C   PRO A  60      26.950  69.270  14.869  1.00  0.00           C  
ATOM    910  O   PRO A  60      27.132  70.023  15.824  1.00  0.00           O  
ATOM    911  CB  PRO A  60      28.238  67.101  15.191  1.00  0.00           C  
ATOM    912  CG  PRO A  60      28.497  66.444  13.846  1.00  0.00           C  
ATOM    913  CD  PRO A  60      27.183  66.403  13.084  1.00  0.00           C  
ATOM    914  HA  PRO A  60      26.327  67.623  15.906  1.00  0.00           H  
ATOM    915  HB2 PRO A  60      29.006  67.838  15.420  1.00  0.00           H  
ATOM    916  HB3 PRO A  60      28.252  66.364  15.995  1.00  0.00           H  
ATOM    917  HG2 PRO A  60      29.246  67.004  13.285  1.00  0.00           H  
ATOM    918  HG3 PRO A  60      28.890  65.436  13.982  1.00  0.00           H  
ATOM    919  HD2 PRO A  60      27.272  66.891  12.113  1.00  0.00           H  
ATOM    920  HD3 PRO A  60      26.863  65.378  12.899  1.00  0.00           H  
ATOM    921  N   GLU A  61      26.808  69.670  13.614  1.00  0.00           N  
ATOM    922  CA  GLU A  61      26.860  71.080  13.267  1.00  0.00           C  
ATOM    923  C   GLU A  61      25.467  71.705  13.375  1.00  0.00           C  
ATOM    924  O   GLU A  61      25.250  72.827  12.921  1.00  0.00           O  
ATOM    925  CB  GLU A  61      27.444  71.279  11.867  1.00  0.00           C  
ATOM    926  CG  GLU A  61      26.551  70.636  10.805  1.00  0.00           C  
ATOM    927  CD  GLU A  61      27.043  70.976   9.396  1.00  0.00           C  
ATOM    928  OE1 GLU A  61      27.883  70.203   8.886  1.00  0.00           O  
ATOM    929  OE2 GLU A  61      26.567  72.001   8.861  1.00  0.00           O  
ATOM    930  H   GLU A  61      26.659  69.051  12.843  1.00  0.00           H  
ATOM    931  HA  GLU A  61      27.527  71.533  14.000  1.00  0.00           H  
ATOM    932  HB2 GLU A  61      27.550  72.344  11.662  1.00  0.00           H  
ATOM    933  HB3 GLU A  61      28.442  70.845  11.820  1.00  0.00           H  
ATOM    934  HG2 GLU A  61      26.541  69.554  10.939  1.00  0.00           H  
ATOM    935  HG3 GLU A  61      25.525  70.982  10.928  1.00  0.00           H  
ATOM    936  N   LYS A  62      24.561  70.951  13.979  1.00  0.00           N  
ATOM    937  CA  LYS A  62      23.195  71.417  14.152  1.00  0.00           C  
ATOM    938  C   LYS A  62      22.834  71.384  15.639  1.00  0.00           C  
ATOM    939  O   LYS A  62      22.221  72.318  16.153  1.00  0.00           O  
ATOM    940  CB  LYS A  62      22.239  70.614  13.268  1.00  0.00           C  
ATOM    941  CG  LYS A  62      22.508  70.880  11.786  1.00  0.00           C  
ATOM    942  CD  LYS A  62      21.994  69.728  10.920  1.00  0.00           C  
ATOM    943  CE  LYS A  62      20.880  70.201   9.984  1.00  0.00           C  
ATOM    944  NZ  LYS A  62      21.247  71.487   9.349  1.00  0.00           N  
ATOM    945  H   LYS A  62      24.746  70.040  14.346  1.00  0.00           H  
ATOM    946  HA  LYS A  62      23.157  72.452  13.811  1.00  0.00           H  
ATOM    947  HB2 LYS A  62      22.351  69.551  13.477  1.00  0.00           H  
ATOM    948  HB3 LYS A  62      21.208  70.878  13.507  1.00  0.00           H  
ATOM    949  HG2 LYS A  62      22.024  71.809  11.485  1.00  0.00           H  
ATOM    950  HG3 LYS A  62      23.578  71.012  11.625  1.00  0.00           H  
ATOM    951  HD2 LYS A  62      22.815  69.315  10.335  1.00  0.00           H  
ATOM    952  HD3 LYS A  62      21.622  68.927  11.558  1.00  0.00           H  
ATOM    953  HE2 LYS A  62      20.698  69.449   9.216  1.00  0.00           H  
ATOM    954  HE3 LYS A  62      19.951  70.317  10.542  1.00  0.00           H  
ATOM    955  HZ1 LYS A  62      22.243  71.571   9.318  1.00  0.00           H  
ATOM    956  HZ2 LYS A  62      20.881  71.517   8.420  1.00  0.00           H  
ATOM    957  HZ3 LYS A  62      20.866  72.243   9.883  1.00  0.00           H  
ATOM    958  N   TYR A  63      23.229  70.298  16.286  1.00  0.00           N  
ATOM    959  CA  TYR A  63      22.955  70.131  17.703  1.00  0.00           C  
ATOM    960  C   TYR A  63      24.204  70.411  18.541  1.00  0.00           C  
ATOM    961  O   TYR A  63      25.279  69.884  18.256  1.00  0.00           O  
ATOM    962  CB  TYR A  63      22.553  68.665  17.885  1.00  0.00           C  
ATOM    963  CG  TYR A  63      21.286  68.269  17.124  1.00  0.00           C  
ATOM    964  CD1 TYR A  63      20.064  68.787  17.502  1.00  0.00           C  
ATOM    965  CD2 TYR A  63      21.365  67.393  16.059  1.00  0.00           C  
ATOM    966  CE1 TYR A  63      18.871  68.413  16.787  1.00  0.00           C  
ATOM    967  CE2 TYR A  63      20.173  67.021  15.344  1.00  0.00           C  
ATOM    968  CZ  TYR A  63      18.985  67.548  15.743  1.00  0.00           C  
ATOM    969  OH  TYR A  63      17.858  67.197  15.067  1.00  0.00           O  
ATOM    970  H   TYR A  63      23.728  69.543  15.861  1.00  0.00           H  
ATOM    971  HA  TYR A  63      22.174  70.838  17.981  1.00  0.00           H  
ATOM    972  HB2 TYR A  63      23.376  68.031  17.555  1.00  0.00           H  
ATOM    973  HB3 TYR A  63      22.404  68.469  18.946  1.00  0.00           H  
ATOM    974  HD1 TYR A  63      20.001  69.478  18.343  1.00  0.00           H  
ATOM    975  HD2 TYR A  63      22.331  66.985  15.761  1.00  0.00           H  
ATOM    976  HE1 TYR A  63      17.900  68.814  17.075  1.00  0.00           H  
ATOM    977  HE2 TYR A  63      20.222  66.330  14.501  1.00  0.00           H  
ATOM    978  HH  TYR A  63      17.731  67.797  14.278  1.00  0.00           H  
ATOM    979  N   ARG A  64      24.021  71.241  19.558  1.00  0.00           N  
ATOM    980  CA  ARG A  64      25.120  71.599  20.438  1.00  0.00           C  
ATOM    981  C   ARG A  64      25.282  70.548  21.538  1.00  0.00           C  
ATOM    982  O   ARG A  64      24.522  70.534  22.505  1.00  0.00           O  
ATOM    983  CB  ARG A  64      24.888  72.968  21.081  1.00  0.00           C  
ATOM    984  CG  ARG A  64      26.200  73.559  21.600  1.00  0.00           C  
ATOM    985  CD  ARG A  64      26.673  74.711  20.710  1.00  0.00           C  
ATOM    986  NE  ARG A  64      27.899  75.316  21.276  1.00  0.00           N  
ATOM    987  CZ  ARG A  64      27.904  76.206  22.277  1.00  0.00           C  
ATOM    988  NH1 ARG A  64      26.748  76.598  22.831  1.00  0.00           N  
ATOM    989  NH2 ARG A  64      29.065  76.703  22.727  1.00  0.00           N  
ATOM    990  H   ARG A  64      23.144  71.665  19.783  1.00  0.00           H  
ATOM    991  HA  ARG A  64      25.997  71.628  19.792  1.00  0.00           H  
ATOM    992  HB2 ARG A  64      24.443  73.645  20.352  1.00  0.00           H  
ATOM    993  HB3 ARG A  64      24.178  72.873  21.902  1.00  0.00           H  
ATOM    994  HG2 ARG A  64      26.063  73.916  22.620  1.00  0.00           H  
ATOM    995  HG3 ARG A  64      26.965  72.784  21.634  1.00  0.00           H  
ATOM    996  HD2 ARG A  64      26.870  74.344  19.702  1.00  0.00           H  
ATOM    997  HD3 ARG A  64      25.889  75.464  20.628  1.00  0.00           H  
ATOM    998  HE  ARG A  64      28.779  75.046  20.885  1.00  0.00           H  
ATOM    999 HH11 ARG A  64      25.882  76.227  22.496  1.00  0.00           H  
ATOM   1000 HH12 ARG A  64      26.752  77.262  23.579  1.00  0.00           H  
ATOM   1001 HH21 ARG A  64      29.927  76.410  22.314  1.00  0.00           H  
ATOM   1002 HH22 ARG A  64      29.068  77.367  23.475  1.00  0.00           H  
ATOM   1003  N   VAL A  65      26.277  69.693  21.354  1.00  0.00           N  
ATOM   1004  CA  VAL A  65      26.548  68.640  22.319  1.00  0.00           C  
ATOM   1005  C   VAL A  65      27.833  68.972  23.081  1.00  0.00           C  
ATOM   1006  O   VAL A  65      28.902  69.085  22.484  1.00  0.00           O  
ATOM   1007  CB  VAL A  65      26.606  67.284  21.613  1.00  0.00           C  
ATOM   1008  CG1 VAL A  65      25.876  67.335  20.269  1.00  0.00           C  
ATOM   1009  CG2 VAL A  65      28.054  66.822  21.433  1.00  0.00           C  
ATOM   1010  H   VAL A  65      26.890  69.711  20.565  1.00  0.00           H  
ATOM   1011  HA  VAL A  65      25.718  68.619  23.024  1.00  0.00           H  
ATOM   1012  HB  VAL A  65      26.098  66.556  22.243  1.00  0.00           H  
ATOM   1013 HG11 VAL A  65      25.964  66.370  19.770  1.00  0.00           H  
ATOM   1014 HG12 VAL A  65      24.823  67.563  20.436  1.00  0.00           H  
ATOM   1015 HG13 VAL A  65      26.320  68.108  19.643  1.00  0.00           H  
ATOM   1016 HG21 VAL A  65      28.622  67.596  20.920  1.00  0.00           H  
ATOM   1017 HG22 VAL A  65      28.497  66.631  22.410  1.00  0.00           H  
ATOM   1018 HG23 VAL A  65      28.071  65.906  20.841  1.00  0.00           H  
ATOM   1019  N   LYS A  66      27.685  69.121  24.390  1.00  0.00           N  
ATOM   1020  CA  LYS A  66      28.820  69.437  25.241  1.00  0.00           C  
ATOM   1021  C   LYS A  66      28.500  69.035  26.681  1.00  0.00           C  
ATOM   1022  O   LYS A  66      27.420  69.338  27.188  1.00  0.00           O  
ATOM   1023  CB  LYS A  66      29.212  70.907  25.084  1.00  0.00           C  
ATOM   1024  CG  LYS A  66      30.298  71.295  26.091  1.00  0.00           C  
ATOM   1025  CD  LYS A  66      30.043  72.691  26.661  1.00  0.00           C  
ATOM   1026  CE  LYS A  66      29.532  72.610  28.101  1.00  0.00           C  
ATOM   1027  NZ  LYS A  66      29.782  73.883  28.813  1.00  0.00           N  
ATOM   1028  H   LYS A  66      26.812  69.027  24.868  1.00  0.00           H  
ATOM   1029  HA  LYS A  66      29.664  68.840  24.895  1.00  0.00           H  
ATOM   1030  HB2 LYS A  66      29.570  71.087  24.071  1.00  0.00           H  
ATOM   1031  HB3 LYS A  66      28.336  71.539  25.229  1.00  0.00           H  
ATOM   1032  HG2 LYS A  66      30.324  70.566  26.901  1.00  0.00           H  
ATOM   1033  HG3 LYS A  66      31.274  71.268  25.606  1.00  0.00           H  
ATOM   1034  HD2 LYS A  66      30.964  73.275  26.631  1.00  0.00           H  
ATOM   1035  HD3 LYS A  66      29.315  73.214  26.041  1.00  0.00           H  
ATOM   1036  HE2 LYS A  66      28.464  72.390  28.102  1.00  0.00           H  
ATOM   1037  HE3 LYS A  66      30.027  71.792  28.623  1.00  0.00           H  
ATOM   1038  HZ1 LYS A  66      30.051  73.691  29.756  1.00  0.00           H  
ATOM   1039  HZ2 LYS A  66      30.516  74.384  28.353  1.00  0.00           H  
ATOM   1040  HZ3 LYS A  66      28.949  74.437  28.808  1.00  0.00           H  
ATOM   1041  N   PRO A  67      29.482  68.343  27.317  1.00  0.00           N  
ATOM   1042  CA  PRO A  67      30.730  68.025  26.644  1.00  0.00           C  
ATOM   1043  C   PRO A  67      30.536  66.893  25.634  1.00  0.00           C  
ATOM   1044  O   PRO A  67      29.731  65.990  25.856  1.00  0.00           O  
ATOM   1045  CB  PRO A  67      31.699  67.669  27.759  1.00  0.00           C  
ATOM   1046  CG  PRO A  67      30.840  67.347  28.971  1.00  0.00           C  
ATOM   1047  CD  PRO A  67      29.431  67.844  28.689  1.00  0.00           C  
ATOM   1048  HA  PRO A  67      31.048  68.813  26.114  1.00  0.00           H  
ATOM   1049  HB2 PRO A  67      32.317  66.815  27.481  1.00  0.00           H  
ATOM   1050  HB3 PRO A  67      32.375  68.496  27.968  1.00  0.00           H  
ATOM   1051  HG2 PRO A  67      30.835  66.275  29.162  1.00  0.00           H  
ATOM   1052  HG3 PRO A  67      31.242  67.828  29.862  1.00  0.00           H  
ATOM   1053  HD2 PRO A  67      28.700  67.042  28.791  1.00  0.00           H  
ATOM   1054  HD3 PRO A  67      29.141  68.631  29.385  1.00  0.00           H  
ATOM   1055  N   SER A  68      31.288  66.977  24.547  1.00  0.00           N  
ATOM   1056  CA  SER A  68      31.209  65.970  23.503  1.00  0.00           C  
ATOM   1057  C   SER A  68      32.510  65.165  23.453  1.00  0.00           C  
ATOM   1058  O   SER A  68      32.600  64.167  22.738  1.00  0.00           O  
ATOM   1059  CB  SER A  68      30.929  66.608  22.141  1.00  0.00           C  
ATOM   1060  OG  SER A  68      32.126  67.027  21.491  1.00  0.00           O  
ATOM   1061  H   SER A  68      31.942  67.714  24.375  1.00  0.00           H  
ATOM   1062  HA  SER A  68      30.373  65.328  23.782  1.00  0.00           H  
ATOM   1063  HB2 SER A  68      30.403  65.895  21.507  1.00  0.00           H  
ATOM   1064  HB3 SER A  68      30.269  67.466  22.272  1.00  0.00           H  
ATOM   1065  HG  SER A  68      32.595  66.238  21.095  1.00  0.00           H  
ATOM   1066  N   ASN A  69      33.484  65.626  24.223  1.00  0.00           N  
ATOM   1067  CA  ASN A  69      34.775  64.961  24.275  1.00  0.00           C  
ATOM   1068  C   ASN A  69      35.363  65.110  25.680  1.00  0.00           C  
ATOM   1069  O   ASN A  69      35.947  66.142  26.006  1.00  0.00           O  
ATOM   1070  CB  ASN A  69      35.758  65.586  23.283  1.00  0.00           C  
ATOM   1071  CG  ASN A  69      35.228  65.486  21.851  1.00  0.00           C  
ATOM   1072  OD1 ASN A  69      34.719  64.465  21.420  1.00  0.00           O  
ATOM   1073  ND2 ASN A  69      35.377  66.601  21.140  1.00  0.00           N  
ATOM   1074  H   ASN A  69      33.403  66.438  24.801  1.00  0.00           H  
ATOM   1075  HA  ASN A  69      34.573  63.922  24.016  1.00  0.00           H  
ATOM   1076  HB2 ASN A  69      35.924  66.632  23.541  1.00  0.00           H  
ATOM   1077  HB3 ASN A  69      36.721  65.082  23.354  1.00  0.00           H  
ATOM   1078 HD21 ASN A  69      35.803  67.405  21.554  1.00  0.00           H  
ATOM   1079 HD22 ASN A  69      35.060  66.635  20.192  1.00  0.00           H  
ATOM   1080  N   SER A  70      35.189  64.063  26.473  1.00  0.00           N  
ATOM   1081  CA  SER A  70      35.695  64.064  27.836  1.00  0.00           C  
ATOM   1082  C   SER A  70      35.568  62.667  28.442  1.00  0.00           C  
ATOM   1083  O   SER A  70      35.247  61.707  27.741  1.00  0.00           O  
ATOM   1084  CB  SER A  70      34.953  65.087  28.698  1.00  0.00           C  
ATOM   1085  OG  SER A  70      35.796  66.168  29.088  1.00  0.00           O  
ATOM   1086  H   SER A  70      34.712  63.227  26.200  1.00  0.00           H  
ATOM   1087  HA  SER A  70      36.743  64.352  27.754  1.00  0.00           H  
ATOM   1088  HB2 SER A  70      34.098  65.475  28.145  1.00  0.00           H  
ATOM   1089  HB3 SER A  70      34.561  64.595  29.588  1.00  0.00           H  
ATOM   1090  HG  SER A  70      36.721  65.835  29.266  1.00  0.00           H  
ATOM   1091  N   SER A  71      35.825  62.593  29.740  1.00  0.00           N  
ATOM   1092  CA  SER A  71      35.744  61.328  30.449  1.00  0.00           C  
ATOM   1093  C   SER A  71      34.903  61.492  31.717  1.00  0.00           C  
ATOM   1094  O   SER A  71      34.552  62.609  32.093  1.00  0.00           O  
ATOM   1095  CB  SER A  71      37.137  60.802  30.800  1.00  0.00           C  
ATOM   1096  OG  SER A  71      37.088  59.788  31.802  1.00  0.00           O  
ATOM   1097  H   SER A  71      36.086  63.377  30.303  1.00  0.00           H  
ATOM   1098  HA  SER A  71      35.261  60.639  29.756  1.00  0.00           H  
ATOM   1099  HB2 SER A  71      37.611  60.404  29.903  1.00  0.00           H  
ATOM   1100  HB3 SER A  71      37.758  61.627  31.150  1.00  0.00           H  
ATOM   1101  HG  SER A  71      36.694  58.952  31.422  1.00  0.00           H  
ATOM   1102  N   CYS A  72      34.604  60.362  32.341  1.00  0.00           N  
ATOM   1103  CA  CYS A  72      33.810  60.366  33.558  1.00  0.00           C  
ATOM   1104  C   CYS A  72      34.477  59.431  34.569  1.00  0.00           C  
ATOM   1105  O   CYS A  72      34.554  58.224  34.346  1.00  0.00           O  
ATOM   1106  CB  CYS A  72      32.357  59.972  33.288  1.00  0.00           C  
ATOM   1107  SG  CYS A  72      31.396  60.016  34.844  1.00  0.00           S  
ATOM   1108  H   CYS A  72      34.892  59.457  32.028  1.00  0.00           H  
ATOM   1109  HA  CYS A  72      33.806  61.392  33.925  1.00  0.00           H  
ATOM   1110  HB2 CYS A  72      31.917  60.651  32.559  1.00  0.00           H  
ATOM   1111  HB3 CYS A  72      32.318  58.972  32.855  1.00  0.00           H  
ATOM   1112  HG  CYS A  72      32.444  59.911  35.657  1.00  0.00           H  
ATOM   1113  N   ASP A  73      34.943  60.025  35.658  1.00  0.00           N  
ATOM   1114  CA  ASP A  73      35.600  59.259  36.704  1.00  0.00           C  
ATOM   1115  C   ASP A  73      34.685  58.116  37.146  1.00  0.00           C  
ATOM   1116  O   ASP A  73      33.478  58.156  36.912  1.00  0.00           O  
ATOM   1117  CB  ASP A  73      35.888  60.133  37.926  1.00  0.00           C  
ATOM   1118  CG  ASP A  73      37.045  61.121  37.757  1.00  0.00           C  
ATOM   1119  OD1 ASP A  73      37.217  61.603  36.616  1.00  0.00           O  
ATOM   1120  OD2 ASP A  73      37.729  61.373  38.772  1.00  0.00           O  
ATOM   1121  H   ASP A  73      34.876  61.007  35.831  1.00  0.00           H  
ATOM   1122  HA  ASP A  73      36.528  58.903  36.258  1.00  0.00           H  
ATOM   1123  HB2 ASP A  73      34.987  60.691  38.176  1.00  0.00           H  
ATOM   1124  HB3 ASP A  73      36.107  59.484  38.774  1.00  0.00           H  
ATOM   1125  N   PRO A  74      35.311  57.096  37.794  1.00  0.00           N  
ATOM   1126  CA  PRO A  74      34.565  55.944  38.271  1.00  0.00           C  
ATOM   1127  C   PRO A  74      33.759  56.291  39.523  1.00  0.00           C  
ATOM   1128  O   PRO A  74      34.315  56.773  40.510  1.00  0.00           O  
ATOM   1129  CB  PRO A  74      35.615  54.872  38.517  1.00  0.00           C  
ATOM   1130  CG  PRO A  74      36.943  55.605  38.616  1.00  0.00           C  
ATOM   1131  CD  PRO A  74      36.738  57.015  38.089  1.00  0.00           C  
ATOM   1132  HA  PRO A  74      33.896  55.656  37.586  1.00  0.00           H  
ATOM   1133  HB2 PRO A  74      35.403  54.322  39.435  1.00  0.00           H  
ATOM   1134  HB3 PRO A  74      35.628  54.145  37.706  1.00  0.00           H  
ATOM   1135  HG2 PRO A  74      37.290  55.630  39.649  1.00  0.00           H  
ATOM   1136  HG3 PRO A  74      37.708  55.087  38.035  1.00  0.00           H  
ATOM   1137  HD2 PRO A  74      37.033  57.761  38.827  1.00  0.00           H  
ATOM   1138  HD3 PRO A  74      37.337  57.195  37.196  1.00  0.00           H  
ATOM   1139  N   GLY A  75      32.462  56.035  39.444  1.00  0.00           N  
ATOM   1140  CA  GLY A  75      31.573  56.314  40.559  1.00  0.00           C  
ATOM   1141  C   GLY A  75      31.087  57.765  40.522  1.00  0.00           C  
ATOM   1142  O   GLY A  75      30.801  58.354  41.563  1.00  0.00           O  
ATOM   1143  H   GLY A  75      32.018  55.643  38.637  1.00  0.00           H  
ATOM   1144  HA2 GLY A  75      30.719  55.640  40.526  1.00  0.00           H  
ATOM   1145  HA3 GLY A  75      32.093  56.126  41.499  1.00  0.00           H  
ATOM   1146  N   ALA A  76      31.009  58.298  39.312  1.00  0.00           N  
ATOM   1147  CA  ALA A  76      30.561  59.668  39.126  1.00  0.00           C  
ATOM   1148  C   ALA A  76      29.700  59.751  37.864  1.00  0.00           C  
ATOM   1149  O   ALA A  76      29.853  58.944  36.949  1.00  0.00           O  
ATOM   1150  CB  ALA A  76      31.776  60.597  39.065  1.00  0.00           C  
ATOM   1151  H   ALA A  76      31.244  57.812  38.470  1.00  0.00           H  
ATOM   1152  HA  ALA A  76      29.954  59.939  39.988  1.00  0.00           H  
ATOM   1153  HB1 ALA A  76      32.284  60.469  38.110  1.00  0.00           H  
ATOM   1154  HB2 ALA A  76      31.445  61.632  39.165  1.00  0.00           H  
ATOM   1155  HB3 ALA A  76      32.460  60.354  39.878  1.00  0.00           H  
ATOM   1156  N   SER A  77      28.814  60.736  37.854  1.00  0.00           N  
ATOM   1157  CA  SER A  77      27.929  60.935  36.720  1.00  0.00           C  
ATOM   1158  C   SER A  77      28.248  62.265  36.034  1.00  0.00           C  
ATOM   1159  O   SER A  77      28.498  63.268  36.702  1.00  0.00           O  
ATOM   1160  CB  SER A  77      26.461  60.901  37.154  1.00  0.00           C  
ATOM   1161  OG  SER A  77      26.261  61.538  38.412  1.00  0.00           O  
ATOM   1162  H   SER A  77      28.696  61.389  38.602  1.00  0.00           H  
ATOM   1163  HA  SER A  77      28.128  60.101  36.048  1.00  0.00           H  
ATOM   1164  HB2 SER A  77      25.848  61.391  36.397  1.00  0.00           H  
ATOM   1165  HB3 SER A  77      26.126  59.866  37.214  1.00  0.00           H  
ATOM   1166  HG  SER A  77      25.348  61.329  38.760  1.00  0.00           H  
ATOM   1167  N   ILE A  78      28.228  62.231  34.710  1.00  0.00           N  
ATOM   1168  CA  ILE A  78      28.513  63.421  33.927  1.00  0.00           C  
ATOM   1169  C   ILE A  78      27.207  63.974  33.353  1.00  0.00           C  
ATOM   1170  O   ILE A  78      26.162  63.331  33.448  1.00  0.00           O  
ATOM   1171  CB  ILE A  78      29.573  63.122  32.864  1.00  0.00           C  
ATOM   1172  CG1 ILE A  78      30.363  64.384  32.507  1.00  0.00           C  
ATOM   1173  CG2 ILE A  78      28.943  62.472  31.630  1.00  0.00           C  
ATOM   1174  CD1 ILE A  78      31.862  64.088  32.428  1.00  0.00           C  
ATOM   1175  H   ILE A  78      28.025  61.412  34.174  1.00  0.00           H  
ATOM   1176  HA  ILE A  78      28.936  64.165  34.603  1.00  0.00           H  
ATOM   1177  HB  ILE A  78      30.281  62.406  33.280  1.00  0.00           H  
ATOM   1178 HG12 ILE A  78      30.014  64.777  31.552  1.00  0.00           H  
ATOM   1179 HG13 ILE A  78      30.179  65.155  33.254  1.00  0.00           H  
ATOM   1180 HG21 ILE A  78      27.958  62.084  31.887  1.00  0.00           H  
ATOM   1181 HG22 ILE A  78      28.848  63.214  30.837  1.00  0.00           H  
ATOM   1182 HG23 ILE A  78      29.578  61.654  31.287  1.00  0.00           H  
ATOM   1183 HD11 ILE A  78      32.376  64.596  33.244  1.00  0.00           H  
ATOM   1184 HD12 ILE A  78      32.025  63.013  32.508  1.00  0.00           H  
ATOM   1185 HD13 ILE A  78      32.252  64.444  31.474  1.00  0.00           H  
ATOM   1186  N   ASP A  79      27.308  65.161  32.773  1.00  0.00           N  
ATOM   1187  CA  ASP A  79      26.147  65.808  32.185  1.00  0.00           C  
ATOM   1188  C   ASP A  79      26.496  66.289  30.776  1.00  0.00           C  
ATOM   1189  O   ASP A  79      27.452  67.041  30.591  1.00  0.00           O  
ATOM   1190  CB  ASP A  79      25.719  67.024  33.008  1.00  0.00           C  
ATOM   1191  CG  ASP A  79      24.626  66.753  34.044  1.00  0.00           C  
ATOM   1192  OD1 ASP A  79      23.879  65.771  33.837  1.00  0.00           O  
ATOM   1193  OD2 ASP A  79      24.562  67.532  35.019  1.00  0.00           O  
ATOM   1194  H   ASP A  79      28.160  65.677  32.701  1.00  0.00           H  
ATOM   1195  HA  ASP A  79      25.365  65.047  32.185  1.00  0.00           H  
ATOM   1196  HB2 ASP A  79      26.594  67.423  33.520  1.00  0.00           H  
ATOM   1197  HB3 ASP A  79      25.368  67.800  32.327  1.00  0.00           H  
ATOM   1198  N   ILE A  80      25.702  65.835  29.817  1.00  0.00           N  
ATOM   1199  CA  ILE A  80      25.915  66.210  28.428  1.00  0.00           C  
ATOM   1200  C   ILE A  80      24.685  66.958  27.912  1.00  0.00           C  
ATOM   1201  O   ILE A  80      23.617  66.369  27.756  1.00  0.00           O  
ATOM   1202  CB  ILE A  80      26.284  64.983  27.593  1.00  0.00           C  
ATOM   1203  CG1 ILE A  80      27.148  64.010  28.399  1.00  0.00           C  
ATOM   1204  CG2 ILE A  80      26.955  65.394  26.281  1.00  0.00           C  
ATOM   1205  CD1 ILE A  80      28.489  64.646  28.769  1.00  0.00           C  
ATOM   1206  H   ILE A  80      24.927  65.223  29.974  1.00  0.00           H  
ATOM   1207  HA  ILE A  80      26.769  66.887  28.401  1.00  0.00           H  
ATOM   1208  HB  ILE A  80      25.365  64.457  27.333  1.00  0.00           H  
ATOM   1209 HG12 ILE A  80      26.619  63.713  29.304  1.00  0.00           H  
ATOM   1210 HG13 ILE A  80      27.319  63.103  27.817  1.00  0.00           H  
ATOM   1211 HG21 ILE A  80      27.638  66.223  26.467  1.00  0.00           H  
ATOM   1212 HG22 ILE A  80      27.512  64.549  25.877  1.00  0.00           H  
ATOM   1213 HG23 ILE A  80      26.195  65.704  25.565  1.00  0.00           H  
ATOM   1214 HD11 ILE A  80      28.851  65.246  27.934  1.00  0.00           H  
ATOM   1215 HD12 ILE A  80      28.360  65.282  29.645  1.00  0.00           H  
ATOM   1216 HD13 ILE A  80      29.213  63.862  28.994  1.00  0.00           H  
ATOM   1217  N   ILE A  81      24.876  68.245  27.662  1.00  0.00           N  
ATOM   1218  CA  ILE A  81      23.796  69.080  27.166  1.00  0.00           C  
ATOM   1219  C   ILE A  81      23.673  68.904  25.652  1.00  0.00           C  
ATOM   1220  O   ILE A  81      24.675  68.715  24.962  1.00  0.00           O  
ATOM   1221  CB  ILE A  81      23.998  70.533  27.602  1.00  0.00           C  
ATOM   1222  CG1 ILE A  81      23.579  70.732  29.060  1.00  0.00           C  
ATOM   1223  CG2 ILE A  81      23.270  71.495  26.660  1.00  0.00           C  
ATOM   1224  CD1 ILE A  81      24.615  70.132  30.014  1.00  0.00           C  
ATOM   1225  H   ILE A  81      25.749  68.716  27.792  1.00  0.00           H  
ATOM   1226  HA  ILE A  81      22.873  68.730  27.630  1.00  0.00           H  
ATOM   1227  HB  ILE A  81      25.062  70.763  27.538  1.00  0.00           H  
ATOM   1228 HG12 ILE A  81      23.462  71.795  29.267  1.00  0.00           H  
ATOM   1229 HG13 ILE A  81      22.610  70.264  29.231  1.00  0.00           H  
ATOM   1230 HG21 ILE A  81      23.015  72.406  27.200  1.00  0.00           H  
ATOM   1231 HG22 ILE A  81      23.918  71.738  25.818  1.00  0.00           H  
ATOM   1232 HG23 ILE A  81      22.358  71.022  26.293  1.00  0.00           H  
ATOM   1233 HD11 ILE A  81      25.407  69.654  29.437  1.00  0.00           H  
ATOM   1234 HD12 ILE A  81      25.043  70.924  30.631  1.00  0.00           H  
ATOM   1235 HD13 ILE A  81      24.134  69.393  30.655  1.00  0.00           H  
ATOM   1236  N   VAL A  82      22.439  68.971  25.178  1.00  0.00           N  
ATOM   1237  CA  VAL A  82      22.173  68.820  23.757  1.00  0.00           C  
ATOM   1238  C   VAL A  82      21.102  69.828  23.334  1.00  0.00           C  
ATOM   1239  O   VAL A  82      19.910  69.585  23.513  1.00  0.00           O  
ATOM   1240  CB  VAL A  82      21.787  67.373  23.447  1.00  0.00           C  
ATOM   1241  CG1 VAL A  82      21.481  67.194  21.959  1.00  0.00           C  
ATOM   1242  CG2 VAL A  82      22.881  66.405  23.903  1.00  0.00           C  
ATOM   1243  H   VAL A  82      21.629  69.124  25.745  1.00  0.00           H  
ATOM   1244  HA  VAL A  82      23.096  69.045  23.224  1.00  0.00           H  
ATOM   1245  HB  VAL A  82      20.881  67.141  24.005  1.00  0.00           H  
ATOM   1246 HG11 VAL A  82      20.970  66.244  21.805  1.00  0.00           H  
ATOM   1247 HG12 VAL A  82      20.842  68.009  21.618  1.00  0.00           H  
ATOM   1248 HG13 VAL A  82      22.412  67.201  21.392  1.00  0.00           H  
ATOM   1249 HG21 VAL A  82      22.810  65.481  23.329  1.00  0.00           H  
ATOM   1250 HG22 VAL A  82      23.858  66.859  23.741  1.00  0.00           H  
ATOM   1251 HG23 VAL A  82      22.753  66.184  24.962  1.00  0.00           H  
ATOM   1252  N   SER A  83      21.566  70.939  22.781  1.00  0.00           N  
ATOM   1253  CA  SER A  83      20.663  71.984  22.330  1.00  0.00           C  
ATOM   1254  C   SER A  83      20.811  72.190  20.821  1.00  0.00           C  
ATOM   1255  O   SER A  83      21.924  72.329  20.316  1.00  0.00           O  
ATOM   1256  CB  SER A  83      20.925  73.296  23.072  1.00  0.00           C  
ATOM   1257  OG  SER A  83      20.611  74.434  22.274  1.00  0.00           O  
ATOM   1258  H   SER A  83      22.537  71.129  22.638  1.00  0.00           H  
ATOM   1259  HA  SER A  83      19.662  71.625  22.571  1.00  0.00           H  
ATOM   1260  HB2 SER A  83      20.331  73.320  23.987  1.00  0.00           H  
ATOM   1261  HB3 SER A  83      21.972  73.340  23.372  1.00  0.00           H  
ATOM   1262  HG  SER A  83      19.659  74.701  22.418  1.00  0.00           H  
ATOM   1263  N   PRO A  84      19.643  72.202  20.125  1.00  0.00           N  
ATOM   1264  CA  PRO A  84      19.632  72.389  18.684  1.00  0.00           C  
ATOM   1265  C   PRO A  84      19.906  73.849  18.318  1.00  0.00           C  
ATOM   1266  O   PRO A  84      19.918  74.719  19.187  1.00  0.00           O  
ATOM   1267  CB  PRO A  84      18.260  71.911  18.237  1.00  0.00           C  
ATOM   1268  CG  PRO A  84      17.391  71.913  19.483  1.00  0.00           C  
ATOM   1269  CD  PRO A  84      18.307  72.040  20.689  1.00  0.00           C  
ATOM   1270  HA  PRO A  84      20.366  71.858  18.260  1.00  0.00           H  
ATOM   1271  HB2 PRO A  84      17.848  72.570  17.472  1.00  0.00           H  
ATOM   1272  HB3 PRO A  84      18.317  70.914  17.800  1.00  0.00           H  
ATOM   1273  HG2 PRO A  84      16.681  72.739  19.452  1.00  0.00           H  
ATOM   1274  HG3 PRO A  84      16.807  70.995  19.542  1.00  0.00           H  
ATOM   1275  HD2 PRO A  84      18.031  72.896  21.306  1.00  0.00           H  
ATOM   1276  HD3 PRO A  84      18.249  71.156  21.325  1.00  0.00           H  
ATOM   1277  N   HIS A  85      20.120  74.072  17.030  1.00  0.00           N  
ATOM   1278  CA  HIS A  85      20.393  75.412  16.537  1.00  0.00           C  
ATOM   1279  C   HIS A  85      19.248  76.346  16.931  1.00  0.00           C  
ATOM   1280  O   HIS A  85      18.121  75.900  17.142  1.00  0.00           O  
ATOM   1281  CB  HIS A  85      20.653  75.394  15.030  1.00  0.00           C  
ATOM   1282  CG  HIS A  85      21.979  75.994  14.627  1.00  0.00           C  
ATOM   1283  ND1 HIS A  85      22.334  77.297  14.929  1.00  0.00           N  
ATOM   1284  CD2 HIS A  85      23.030  75.456  13.947  1.00  0.00           C  
ATOM   1285  CE1 HIS A  85      23.547  77.523  14.445  1.00  0.00           C  
ATOM   1286  NE2 HIS A  85      23.977  76.381  13.836  1.00  0.00           N  
ATOM   1287  H   HIS A  85      20.109  73.358  16.329  1.00  0.00           H  
ATOM   1288  HA  HIS A  85      21.308  75.744  17.028  1.00  0.00           H  
ATOM   1289  HB2 HIS A  85      20.609  74.364  14.676  1.00  0.00           H  
ATOM   1290  HB3 HIS A  85      19.852  75.938  14.528  1.00  0.00           H  
ATOM   1291  HD1 HIS A  85      21.771  77.957  15.427  1.00  0.00           H  
ATOM   1292  HD2 HIS A  85      23.084  74.439  13.559  1.00  0.00           H  
ATOM   1293  HE1 HIS A  85      24.103  78.456  14.520  1.00  0.00           H  
ATOM   1294  N   GLY A  86      19.576  77.628  17.020  1.00  0.00           N  
ATOM   1295  CA  GLY A  86      18.589  78.628  17.385  1.00  0.00           C  
ATOM   1296  C   GLY A  86      17.840  79.135  16.151  1.00  0.00           C  
ATOM   1297  O   GLY A  86      17.638  80.339  15.992  1.00  0.00           O  
ATOM   1298  H   GLY A  86      20.495  77.982  16.847  1.00  0.00           H  
ATOM   1299  HA2 GLY A  86      17.881  78.205  18.096  1.00  0.00           H  
ATOM   1300  HA3 GLY A  86      19.081  79.464  17.883  1.00  0.00           H  
ATOM   1301  N   GLY A  87      17.447  78.191  15.308  1.00  0.00           N  
ATOM   1302  CA  GLY A  87      16.724  78.526  14.093  1.00  0.00           C  
ATOM   1303  C   GLY A  87      15.860  77.353  13.628  1.00  0.00           C  
ATOM   1304  O   GLY A  87      14.659  77.507  13.411  1.00  0.00           O  
ATOM   1305  H   GLY A  87      17.614  77.215  15.444  1.00  0.00           H  
ATOM   1306  HA2 GLY A  87      16.093  79.398  14.269  1.00  0.00           H  
ATOM   1307  HA3 GLY A  87      17.429  78.796  13.308  1.00  0.00           H  
ATOM   1308  N   LEU A  88      16.505  76.204  13.486  1.00  0.00           N  
ATOM   1309  CA  LEU A  88      15.811  75.004  13.051  1.00  0.00           C  
ATOM   1310  C   LEU A  88      15.060  74.396  14.237  1.00  0.00           C  
ATOM   1311  O   LEU A  88      14.875  75.050  15.261  1.00  0.00           O  
ATOM   1312  CB  LEU A  88      16.787  74.036  12.379  1.00  0.00           C  
ATOM   1313  CG  LEU A  88      17.929  73.517  13.254  1.00  0.00           C  
ATOM   1314  CD1 LEU A  88      17.483  72.307  14.077  1.00  0.00           C  
ATOM   1315  CD2 LEU A  88      19.171  73.213  12.414  1.00  0.00           C  
ATOM   1316  H   LEU A  88      17.482  76.086  13.665  1.00  0.00           H  
ATOM   1317  HA  LEU A  88      15.083  75.303  12.297  1.00  0.00           H  
ATOM   1318  HB2 LEU A  88      16.221  73.180  12.010  1.00  0.00           H  
ATOM   1319  HB3 LEU A  88      17.218  74.531  11.509  1.00  0.00           H  
ATOM   1320  HG  LEU A  88      18.202  74.302  13.960  1.00  0.00           H  
ATOM   1321 HD11 LEU A  88      16.804  71.695  13.484  1.00  0.00           H  
ATOM   1322 HD12 LEU A  88      18.355  71.716  14.356  1.00  0.00           H  
ATOM   1323 HD13 LEU A  88      16.972  72.648  14.978  1.00  0.00           H  
ATOM   1324 HD21 LEU A  88      20.036  73.712  12.850  1.00  0.00           H  
ATOM   1325 HD22 LEU A  88      19.342  72.137  12.396  1.00  0.00           H  
ATOM   1326 HD23 LEU A  88      19.017  73.574  11.397  1.00  0.00           H  
ATOM   1327  N   THR A  89      14.646  73.150  14.057  1.00  0.00           N  
ATOM   1328  CA  THR A  89      13.918  72.445  15.099  1.00  0.00           C  
ATOM   1329  C   THR A  89      14.363  70.983  15.166  1.00  0.00           C  
ATOM   1330  O   THR A  89      15.108  70.518  14.304  1.00  0.00           O  
ATOM   1331  CB  THR A  89      12.423  72.614  14.828  1.00  0.00           C  
ATOM   1332  OG1 THR A  89      11.808  71.617  15.640  1.00  0.00           O  
ATOM   1333  CG2 THR A  89      12.038  72.220  13.400  1.00  0.00           C  
ATOM   1334  H   THR A  89      14.800  72.624  13.221  1.00  0.00           H  
ATOM   1335  HA  THR A  89      14.168  72.899  16.058  1.00  0.00           H  
ATOM   1336  HB  THR A  89      12.098  73.630  15.052  1.00  0.00           H  
ATOM   1337  HG1 THR A  89      10.825  71.788  15.706  1.00  0.00           H  
ATOM   1338 HG21 THR A  89      12.802  72.572  12.708  1.00  0.00           H  
ATOM   1339 HG22 THR A  89      11.958  71.135  13.332  1.00  0.00           H  
ATOM   1340 HG23 THR A  89      11.079  72.672  13.144  1.00  0.00           H  
ATOM   1341  N   VAL A  90      13.888  70.298  16.196  1.00  0.00           N  
ATOM   1342  CA  VAL A  90      14.226  68.898  16.385  1.00  0.00           C  
ATOM   1343  C   VAL A  90      13.599  68.070  15.263  1.00  0.00           C  
ATOM   1344  O   VAL A  90      12.382  68.087  15.081  1.00  0.00           O  
ATOM   1345  CB  VAL A  90      13.797  68.441  17.780  1.00  0.00           C  
ATOM   1346  CG1 VAL A  90      14.267  67.011  18.056  1.00  0.00           C  
ATOM   1347  CG2 VAL A  90      14.305  69.403  18.854  1.00  0.00           C  
ATOM   1348  H   VAL A  90      13.283  70.685  16.892  1.00  0.00           H  
ATOM   1349  HA  VAL A  90      15.311  68.811  16.321  1.00  0.00           H  
ATOM   1350  HB  VAL A  90      12.707  68.447  17.814  1.00  0.00           H  
ATOM   1351 HG11 VAL A  90      13.624  66.556  18.810  1.00  0.00           H  
ATOM   1352 HG12 VAL A  90      14.218  66.428  17.137  1.00  0.00           H  
ATOM   1353 HG13 VAL A  90      15.295  67.030  18.420  1.00  0.00           H  
ATOM   1354 HG21 VAL A  90      15.201  68.989  19.319  1.00  0.00           H  
ATOM   1355 HG22 VAL A  90      14.543  70.364  18.399  1.00  0.00           H  
ATOM   1356 HG23 VAL A  90      13.535  69.542  19.612  1.00  0.00           H  
ATOM   1357  N   SER A  91      14.456  67.365  14.540  1.00  0.00           N  
ATOM   1358  CA  SER A  91      14.000  66.531  13.442  1.00  0.00           C  
ATOM   1359  C   SER A  91      13.642  65.136  13.957  1.00  0.00           C  
ATOM   1360  O   SER A  91      13.452  64.943  15.156  1.00  0.00           O  
ATOM   1361  CB  SER A  91      15.063  66.434  12.345  1.00  0.00           C  
ATOM   1362  OG  SER A  91      14.489  66.463  11.041  1.00  0.00           O  
ATOM   1363  H   SER A  91      15.445  67.356  14.695  1.00  0.00           H  
ATOM   1364  HA  SER A  91      13.117  67.032  13.046  1.00  0.00           H  
ATOM   1365  HB2 SER A  91      15.768  67.260  12.450  1.00  0.00           H  
ATOM   1366  HB3 SER A  91      15.632  65.513  12.471  1.00  0.00           H  
ATOM   1367  HG  SER A  91      14.835  67.253  10.533  1.00  0.00           H  
ATOM   1368  N   ALA A  92      13.559  64.198  13.024  1.00  0.00           N  
ATOM   1369  CA  ALA A  92      13.227  62.826  13.368  1.00  0.00           C  
ATOM   1370  C   ALA A  92      14.376  61.907  12.949  1.00  0.00           C  
ATOM   1371  O   ALA A  92      14.746  60.994  13.687  1.00  0.00           O  
ATOM   1372  CB  ALA A  92      11.901  62.441  12.709  1.00  0.00           C  
ATOM   1373  H   ALA A  92      13.715  64.363  12.050  1.00  0.00           H  
ATOM   1374  HA  ALA A  92      13.108  62.776  14.452  1.00  0.00           H  
ATOM   1375  HB1 ALA A  92      12.061  61.598  12.036  1.00  0.00           H  
ATOM   1376  HB2 ALA A  92      11.181  62.161  13.478  1.00  0.00           H  
ATOM   1377  HB3 ALA A  92      11.516  63.290  12.144  1.00  0.00           H  
ATOM   1378  N   GLN A  93      14.907  62.179  11.767  1.00  0.00           N  
ATOM   1379  CA  GLN A  93      16.007  61.387  11.241  1.00  0.00           C  
ATOM   1380  C   GLN A  93      17.278  61.636  12.056  1.00  0.00           C  
ATOM   1381  O   GLN A  93      18.242  60.879  11.956  1.00  0.00           O  
ATOM   1382  CB  GLN A  93      16.238  61.688   9.758  1.00  0.00           C  
ATOM   1383  CG  GLN A  93      16.437  63.186   9.527  1.00  0.00           C  
ATOM   1384  CD  GLN A  93      17.042  63.453   8.147  1.00  0.00           C  
ATOM   1385  OE1 GLN A  93      17.541  62.563   7.477  1.00  0.00           O  
ATOM   1386  NE2 GLN A  93      16.971  64.723   7.761  1.00  0.00           N  
ATOM   1387  H   GLN A  93      14.601  62.924  11.174  1.00  0.00           H  
ATOM   1388  HA  GLN A  93      15.695  60.349  11.350  1.00  0.00           H  
ATOM   1389  HB2 GLN A  93      17.113  61.142   9.406  1.00  0.00           H  
ATOM   1390  HB3 GLN A  93      15.387  61.336   9.176  1.00  0.00           H  
ATOM   1391  HG2 GLN A  93      15.481  63.702   9.615  1.00  0.00           H  
ATOM   1392  HG3 GLN A  93      17.091  63.594  10.299  1.00  0.00           H  
ATOM   1393 HE21 GLN A  93      16.549  65.404   8.359  1.00  0.00           H  
ATOM   1394 HE22 GLN A  93      17.339  64.997   6.872  1.00  0.00           H  
ATOM   1395  N   ASP A  94      17.238  62.701  12.843  1.00  0.00           N  
ATOM   1396  CA  ASP A  94      18.374  63.060  13.675  1.00  0.00           C  
ATOM   1397  C   ASP A  94      18.617  61.954  14.704  1.00  0.00           C  
ATOM   1398  O   ASP A  94      17.685  61.508  15.371  1.00  0.00           O  
ATOM   1399  CB  ASP A  94      18.115  64.363  14.432  1.00  0.00           C  
ATOM   1400  CG  ASP A  94      16.851  64.367  15.295  1.00  0.00           C  
ATOM   1401  OD1 ASP A  94      15.838  63.809  14.820  1.00  0.00           O  
ATOM   1402  OD2 ASP A  94      16.925  64.928  16.409  1.00  0.00           O  
ATOM   1403  H   ASP A  94      16.451  63.312  12.918  1.00  0.00           H  
ATOM   1404  HA  ASP A  94      19.210  63.176  12.984  1.00  0.00           H  
ATOM   1405  HB2 ASP A  94      18.973  64.572  15.071  1.00  0.00           H  
ATOM   1406  HB3 ASP A  94      18.047  65.178  13.712  1.00  0.00           H  
ATOM   1407  N   ARG A  95      19.873  61.544  14.800  1.00  0.00           N  
ATOM   1408  CA  ARG A  95      20.250  60.499  15.738  1.00  0.00           C  
ATOM   1409  C   ARG A  95      21.531  60.888  16.479  1.00  0.00           C  
ATOM   1410  O   ARG A  95      22.429  61.494  15.898  1.00  0.00           O  
ATOM   1411  CB  ARG A  95      20.469  59.167  15.017  1.00  0.00           C  
ATOM   1412  CG  ARG A  95      20.735  58.041  16.019  1.00  0.00           C  
ATOM   1413  CD  ARG A  95      19.525  57.111  16.131  1.00  0.00           C  
ATOM   1414  NE  ARG A  95      19.428  56.258  14.925  1.00  0.00           N  
ATOM   1415  CZ  ARG A  95      18.308  55.633  14.536  1.00  0.00           C  
ATOM   1416  NH1 ARG A  95      17.184  55.761  15.254  1.00  0.00           N  
ATOM   1417  NH2 ARG A  95      18.312  54.881  13.427  1.00  0.00           N  
ATOM   1418  H   ARG A  95      20.626  61.913  14.254  1.00  0.00           H  
ATOM   1419  HA  ARG A  95      19.407  60.424  16.424  1.00  0.00           H  
ATOM   1420  HB2 ARG A  95      19.592  58.925  14.417  1.00  0.00           H  
ATOM   1421  HB3 ARG A  95      21.311  59.254  14.331  1.00  0.00           H  
ATOM   1422  HG2 ARG A  95      21.609  57.470  15.706  1.00  0.00           H  
ATOM   1423  HG3 ARG A  95      20.965  58.465  16.997  1.00  0.00           H  
ATOM   1424  HD2 ARG A  95      19.618  56.487  17.020  1.00  0.00           H  
ATOM   1425  HD3 ARG A  95      18.615  57.697  16.248  1.00  0.00           H  
ATOM   1426  HE  ARG A  95      20.249  56.142  14.366  1.00  0.00           H  
ATOM   1427 HH11 ARG A  95      17.181  56.324  16.082  1.00  0.00           H  
ATOM   1428 HH12 ARG A  95      16.349  55.296  14.964  1.00  0.00           H  
ATOM   1429 HH21 ARG A  95      19.151  54.785  12.890  1.00  0.00           H  
ATOM   1430 HH22 ARG A  95      17.477  54.415  13.135  1.00  0.00           H  
ATOM   1431  N   PHE A  96      21.573  60.522  17.752  1.00  0.00           N  
ATOM   1432  CA  PHE A  96      22.729  60.824  18.579  1.00  0.00           C  
ATOM   1433  C   PHE A  96      23.495  59.549  18.938  1.00  0.00           C  
ATOM   1434  O   PHE A  96      22.910  58.470  19.011  1.00  0.00           O  
ATOM   1435  CB  PHE A  96      22.204  61.468  19.864  1.00  0.00           C  
ATOM   1436  CG  PHE A  96      21.853  62.950  19.719  1.00  0.00           C  
ATOM   1437  CD1 PHE A  96      22.819  63.896  19.873  1.00  0.00           C  
ATOM   1438  CD2 PHE A  96      20.576  63.323  19.435  1.00  0.00           C  
ATOM   1439  CE1 PHE A  96      22.494  65.271  19.739  1.00  0.00           C  
ATOM   1440  CE2 PHE A  96      20.251  64.699  19.301  1.00  0.00           C  
ATOM   1441  CZ  PHE A  96      21.217  65.643  19.455  1.00  0.00           C  
ATOM   1442  H   PHE A  96      20.838  60.029  18.217  1.00  0.00           H  
ATOM   1443  HA  PHE A  96      23.376  61.484  18.001  1.00  0.00           H  
ATOM   1444  HB2 PHE A  96      21.317  60.926  20.194  1.00  0.00           H  
ATOM   1445  HB3 PHE A  96      22.954  61.358  20.647  1.00  0.00           H  
ATOM   1446  HD1 PHE A  96      23.842  63.597  20.101  1.00  0.00           H  
ATOM   1447  HD2 PHE A  96      19.803  62.565  19.311  1.00  0.00           H  
ATOM   1448  HE1 PHE A  96      23.267  66.029  19.862  1.00  0.00           H  
ATOM   1449  HE2 PHE A  96      19.227  64.996  19.073  1.00  0.00           H  
ATOM   1450  HZ  PHE A  96      20.967  66.700  19.352  1.00  0.00           H  
ATOM   1451  N   LEU A  97      24.792  59.717  19.151  1.00  0.00           N  
ATOM   1452  CA  LEU A  97      25.644  58.593  19.501  1.00  0.00           C  
ATOM   1453  C   LEU A  97      26.499  58.964  20.714  1.00  0.00           C  
ATOM   1454  O   LEU A  97      26.910  60.115  20.859  1.00  0.00           O  
ATOM   1455  CB  LEU A  97      26.460  58.142  18.288  1.00  0.00           C  
ATOM   1456  CG  LEU A  97      27.572  57.129  18.566  1.00  0.00           C  
ATOM   1457  CD1 LEU A  97      27.009  55.862  19.215  1.00  0.00           C  
ATOM   1458  CD2 LEU A  97      28.363  56.819  17.294  1.00  0.00           C  
ATOM   1459  H   LEU A  97      25.260  60.598  19.089  1.00  0.00           H  
ATOM   1460  HA  LEU A  97      24.993  57.764  19.778  1.00  0.00           H  
ATOM   1461  HB2 LEU A  97      25.778  57.711  17.555  1.00  0.00           H  
ATOM   1462  HB3 LEU A  97      26.907  59.024  17.827  1.00  0.00           H  
ATOM   1463  HG  LEU A  97      28.268  57.572  19.279  1.00  0.00           H  
ATOM   1464 HD11 LEU A  97      26.817  55.115  18.445  1.00  0.00           H  
ATOM   1465 HD12 LEU A  97      27.731  55.468  19.931  1.00  0.00           H  
ATOM   1466 HD13 LEU A  97      26.079  56.101  19.730  1.00  0.00           H  
ATOM   1467 HD21 LEU A  97      29.007  57.664  17.052  1.00  0.00           H  
ATOM   1468 HD22 LEU A  97      28.974  55.930  17.454  1.00  0.00           H  
ATOM   1469 HD23 LEU A  97      27.671  56.640  16.471  1.00  0.00           H  
ATOM   1470  N   ILE A  98      26.742  57.969  21.554  1.00  0.00           N  
ATOM   1471  CA  ILE A  98      27.540  58.176  22.750  1.00  0.00           C  
ATOM   1472  C   ILE A  98      28.549  57.035  22.890  1.00  0.00           C  
ATOM   1473  O   ILE A  98      28.168  55.865  22.925  1.00  0.00           O  
ATOM   1474  CB  ILE A  98      26.638  58.352  23.973  1.00  0.00           C  
ATOM   1475  CG1 ILE A  98      25.923  59.704  23.937  1.00  0.00           C  
ATOM   1476  CG2 ILE A  98      27.426  58.155  25.269  1.00  0.00           C  
ATOM   1477  CD1 ILE A  98      24.408  59.527  24.057  1.00  0.00           C  
ATOM   1478  H   ILE A  98      26.403  57.036  21.428  1.00  0.00           H  
ATOM   1479  HA  ILE A  98      28.090  59.109  22.618  1.00  0.00           H  
ATOM   1480  HB  ILE A  98      25.869  57.581  23.944  1.00  0.00           H  
ATOM   1481 HG12 ILE A  98      26.284  60.333  24.751  1.00  0.00           H  
ATOM   1482 HG13 ILE A  98      26.160  60.221  23.006  1.00  0.00           H  
ATOM   1483 HG21 ILE A  98      26.791  58.398  26.121  1.00  0.00           H  
ATOM   1484 HG22 ILE A  98      27.752  57.118  25.342  1.00  0.00           H  
ATOM   1485 HG23 ILE A  98      28.298  58.810  25.267  1.00  0.00           H  
ATOM   1486 HD11 ILE A  98      24.062  58.826  23.297  1.00  0.00           H  
ATOM   1487 HD12 ILE A  98      24.165  59.140  25.046  1.00  0.00           H  
ATOM   1488 HD13 ILE A  98      23.917  60.490  23.913  1.00  0.00           H  
ATOM   1489  N   MET A  99      29.816  57.413  22.964  1.00  0.00           N  
ATOM   1490  CA  MET A  99      30.882  56.435  23.098  1.00  0.00           C  
ATOM   1491  C   MET A  99      31.320  56.299  24.559  1.00  0.00           C  
ATOM   1492  O   MET A  99      31.137  57.219  25.354  1.00  0.00           O  
ATOM   1493  CB  MET A  99      32.078  56.863  22.245  1.00  0.00           C  
ATOM   1494  CG  MET A  99      31.805  56.622  20.759  1.00  0.00           C  
ATOM   1495  SD  MET A  99      33.343  56.381  19.886  1.00  0.00           S  
ATOM   1496  CE  MET A  99      34.331  57.661  20.641  1.00  0.00           C  
ATOM   1497  H   MET A  99      30.118  58.367  22.935  1.00  0.00           H  
ATOM   1498  HA  MET A  99      30.461  55.493  22.748  1.00  0.00           H  
ATOM   1499  HB2 MET A  99      32.290  57.919  22.412  1.00  0.00           H  
ATOM   1500  HB3 MET A  99      32.965  56.308  22.550  1.00  0.00           H  
ATOM   1501  HG2 MET A  99      31.167  55.746  20.635  1.00  0.00           H  
ATOM   1502  HG3 MET A  99      31.267  57.470  20.337  1.00  0.00           H  
ATOM   1503  HE1 MET A  99      35.360  57.581  20.291  1.00  0.00           H  
ATOM   1504  HE2 MET A  99      33.930  58.638  20.369  1.00  0.00           H  
ATOM   1505  HE3 MET A  99      34.307  57.548  21.725  1.00  0.00           H  
ATOM   1506  N   ALA A 100      31.891  55.143  24.866  1.00  0.00           N  
ATOM   1507  CA  ALA A 100      32.356  54.875  26.216  1.00  0.00           C  
ATOM   1508  C   ALA A 100      33.335  53.699  26.189  1.00  0.00           C  
ATOM   1509  O   ALA A 100      32.965  52.587  25.814  1.00  0.00           O  
ATOM   1510  CB  ALA A 100      31.156  54.612  27.127  1.00  0.00           C  
ATOM   1511  H   ALA A 100      32.035  54.400  24.213  1.00  0.00           H  
ATOM   1512  HA  ALA A 100      32.878  55.763  26.570  1.00  0.00           H  
ATOM   1513  HB1 ALA A 100      31.259  53.632  27.591  1.00  0.00           H  
ATOM   1514  HB2 ALA A 100      31.113  55.378  27.902  1.00  0.00           H  
ATOM   1515  HB3 ALA A 100      30.239  54.640  26.538  1.00  0.00           H  
ATOM   1516  N   ALA A 101      34.565  53.985  26.590  1.00  0.00           N  
ATOM   1517  CA  ALA A 101      35.600  52.966  26.617  1.00  0.00           C  
ATOM   1518  C   ALA A 101      36.386  53.077  27.925  1.00  0.00           C  
ATOM   1519  O   ALA A 101      36.778  54.172  28.326  1.00  0.00           O  
ATOM   1520  CB  ALA A 101      36.494  53.114  25.384  1.00  0.00           C  
ATOM   1521  H   ALA A 101      34.857  54.893  26.893  1.00  0.00           H  
ATOM   1522  HA  ALA A 101      35.109  51.993  26.579  1.00  0.00           H  
ATOM   1523  HB1 ALA A 101      35.872  53.206  24.493  1.00  0.00           H  
ATOM   1524  HB2 ALA A 101      37.112  54.005  25.489  1.00  0.00           H  
ATOM   1525  HB3 ALA A 101      37.134  52.237  25.292  1.00  0.00           H  
ATOM   1526  N   GLU A 102      36.593  51.929  28.552  1.00  0.00           N  
ATOM   1527  CA  GLU A 102      37.326  51.884  29.806  1.00  0.00           C  
ATOM   1528  C   GLU A 102      38.813  52.151  29.563  1.00  0.00           C  
ATOM   1529  O   GLU A 102      39.436  51.495  28.730  1.00  0.00           O  
ATOM   1530  CB  GLU A 102      37.119  50.543  30.514  1.00  0.00           C  
ATOM   1531  CG  GLU A 102      36.649  50.751  31.955  1.00  0.00           C  
ATOM   1532  CD  GLU A 102      37.423  51.888  32.626  1.00  0.00           C  
ATOM   1533  OE1 GLU A 102      38.650  51.954  32.395  1.00  0.00           O  
ATOM   1534  OE2 GLU A 102      36.770  52.667  33.354  1.00  0.00           O  
ATOM   1535  H   GLU A 102      36.271  51.043  28.219  1.00  0.00           H  
ATOM   1536  HA  GLU A 102      36.902  52.680  30.419  1.00  0.00           H  
ATOM   1537  HB2 GLU A 102      36.384  49.950  29.970  1.00  0.00           H  
ATOM   1538  HB3 GLU A 102      38.050  49.978  30.509  1.00  0.00           H  
ATOM   1539  HG2 GLU A 102      35.583  50.976  31.966  1.00  0.00           H  
ATOM   1540  HG3 GLU A 102      36.786  49.830  32.523  1.00  0.00           H  
ATOM   1541  N   MET A 103      39.337  53.117  30.304  1.00  0.00           N  
ATOM   1542  CA  MET A 103      40.738  53.478  30.180  1.00  0.00           C  
ATOM   1543  C   MET A 103      41.610  52.624  31.101  1.00  0.00           C  
ATOM   1544  O   MET A 103      41.095  51.870  31.925  1.00  0.00           O  
ATOM   1545  CB  MET A 103      40.918  54.956  30.534  1.00  0.00           C  
ATOM   1546  CG  MET A 103      40.302  55.855  29.460  1.00  0.00           C  
ATOM   1547  SD  MET A 103      40.020  57.489  30.120  1.00  0.00           S  
ATOM   1548  CE  MET A 103      41.451  58.337  29.475  1.00  0.00           C  
ATOM   1549  H   MET A 103      38.822  53.645  30.980  1.00  0.00           H  
ATOM   1550  HA  MET A 103      40.998  53.285  29.138  1.00  0.00           H  
ATOM   1551  HB2 MET A 103      40.451  55.162  31.497  1.00  0.00           H  
ATOM   1552  HB3 MET A 103      41.978  55.183  30.639  1.00  0.00           H  
ATOM   1553  HG2 MET A 103      40.967  55.914  28.597  1.00  0.00           H  
ATOM   1554  HG3 MET A 103      39.363  55.428  29.109  1.00  0.00           H  
ATOM   1555  HE1 MET A 103      42.279  57.634  29.383  1.00  0.00           H  
ATOM   1556  HE2 MET A 103      41.218  58.753  28.496  1.00  0.00           H  
ATOM   1557  HE3 MET A 103      41.733  59.143  30.153  1.00  0.00           H  
ATOM   1558  N   GLU A 104      42.916  52.768  30.930  1.00  0.00           N  
ATOM   1559  CA  GLU A 104      43.864  52.018  31.735  1.00  0.00           C  
ATOM   1560  C   GLU A 104      43.692  52.363  33.216  1.00  0.00           C  
ATOM   1561  O   GLU A 104      42.569  52.518  33.694  1.00  0.00           O  
ATOM   1562  CB  GLU A 104      45.300  52.278  31.276  1.00  0.00           C  
ATOM   1563  CG  GLU A 104      45.399  52.264  29.750  1.00  0.00           C  
ATOM   1564  CD  GLU A 104      46.701  51.606  29.290  1.00  0.00           C  
ATOM   1565  OE1 GLU A 104      47.715  52.334  29.233  1.00  0.00           O  
ATOM   1566  OE2 GLU A 104      46.653  50.389  29.007  1.00  0.00           O  
ATOM   1567  H   GLU A 104      43.327  53.383  30.257  1.00  0.00           H  
ATOM   1568  HA  GLU A 104      43.619  50.969  31.569  1.00  0.00           H  
ATOM   1569  HB2 GLU A 104      45.639  53.241  31.658  1.00  0.00           H  
ATOM   1570  HB3 GLU A 104      45.963  51.520  31.694  1.00  0.00           H  
ATOM   1571  HG2 GLU A 104      44.547  51.726  29.332  1.00  0.00           H  
ATOM   1572  HG3 GLU A 104      45.348  53.284  29.369  1.00  0.00           H  
ATOM   1573  N   GLN A 105      44.821  52.472  33.901  1.00  0.00           N  
ATOM   1574  CA  GLN A 105      44.808  52.796  35.319  1.00  0.00           C  
ATOM   1575  C   GLN A 105      44.620  54.301  35.517  1.00  0.00           C  
ATOM   1576  O   GLN A 105      43.493  54.779  35.643  1.00  0.00           O  
ATOM   1577  CB  GLN A 105      46.086  52.307  36.004  1.00  0.00           C  
ATOM   1578  CG  GLN A 105      46.142  50.778  36.032  1.00  0.00           C  
ATOM   1579  CD  GLN A 105      47.370  50.289  36.804  1.00  0.00           C  
ATOM   1580  OE1 GLN A 105      47.495  50.474  38.003  1.00  0.00           O  
ATOM   1581  NE2 GLN A 105      48.265  49.658  36.050  1.00  0.00           N  
ATOM   1582  H   GLN A 105      45.729  52.345  33.505  1.00  0.00           H  
ATOM   1583  HA  GLN A 105      43.954  52.259  35.730  1.00  0.00           H  
ATOM   1584  HB2 GLN A 105      46.956  52.697  35.477  1.00  0.00           H  
ATOM   1585  HB3 GLN A 105      46.128  52.696  37.021  1.00  0.00           H  
ATOM   1586  HG2 GLN A 105      45.237  50.386  36.496  1.00  0.00           H  
ATOM   1587  HG3 GLN A 105      46.171  50.393  35.013  1.00  0.00           H  
ATOM   1588 HE21 GLN A 105      48.102  49.540  35.071  1.00  0.00           H  
ATOM   1589 HE22 GLN A 105      49.103  49.301  36.464  1.00  0.00           H  
ATOM   1590  N   SER A 106      45.741  55.007  35.539  1.00  0.00           N  
ATOM   1591  CA  SER A 106      45.714  56.449  35.721  1.00  0.00           C  
ATOM   1592  C   SER A 106      45.850  57.149  34.368  1.00  0.00           C  
ATOM   1593  O   SER A 106      46.938  57.195  33.795  1.00  0.00           O  
ATOM   1594  CB  SER A 106      46.825  56.905  36.669  1.00  0.00           C  
ATOM   1595  OG  SER A 106      46.528  56.594  38.028  1.00  0.00           O  
ATOM   1596  H   SER A 106      46.653  54.611  35.436  1.00  0.00           H  
ATOM   1597  HA  SER A 106      44.744  56.665  36.167  1.00  0.00           H  
ATOM   1598  HB2 SER A 106      47.763  56.428  36.384  1.00  0.00           H  
ATOM   1599  HB3 SER A 106      46.971  57.981  36.566  1.00  0.00           H  
ATOM   1600  HG  SER A 106      46.835  57.337  38.623  1.00  0.00           H  
ATOM   1601  N   SER A 107      44.731  57.679  33.896  1.00  0.00           N  
ATOM   1602  CA  SER A 107      44.711  58.374  32.621  1.00  0.00           C  
ATOM   1603  C   SER A 107      43.932  59.685  32.752  1.00  0.00           C  
ATOM   1604  O   SER A 107      42.802  59.693  33.237  1.00  0.00           O  
ATOM   1605  CB  SER A 107      44.098  57.500  31.525  1.00  0.00           C  
ATOM   1606  OG  SER A 107      44.926  57.439  30.366  1.00  0.00           O  
ATOM   1607  H   SER A 107      43.851  57.637  34.368  1.00  0.00           H  
ATOM   1608  HA  SER A 107      45.757  58.573  32.384  1.00  0.00           H  
ATOM   1609  HB2 SER A 107      43.940  56.493  31.911  1.00  0.00           H  
ATOM   1610  HB3 SER A 107      43.120  57.894  31.251  1.00  0.00           H  
ATOM   1611  HG  SER A 107      45.811  57.036  30.599  1.00  0.00           H  
ATOM   1612  N   GLY A 108      44.567  60.760  32.310  1.00  0.00           N  
ATOM   1613  CA  GLY A 108      43.947  62.074  32.371  1.00  0.00           C  
ATOM   1614  C   GLY A 108      42.646  62.104  31.569  1.00  0.00           C  
ATOM   1615  O   GLY A 108      42.174  61.066  31.105  1.00  0.00           O  
ATOM   1616  H   GLY A 108      45.486  60.746  31.916  1.00  0.00           H  
ATOM   1617  HA2 GLY A 108      43.745  62.335  33.410  1.00  0.00           H  
ATOM   1618  HA3 GLY A 108      44.636  62.824  31.982  1.00  0.00           H  
ATOM   1619  N   THR A 109      42.101  63.303  31.429  1.00  0.00           N  
ATOM   1620  CA  THR A 109      40.862  63.483  30.691  1.00  0.00           C  
ATOM   1621  C   THR A 109      40.905  64.783  29.886  1.00  0.00           C  
ATOM   1622  O   THR A 109      40.007  65.617  29.998  1.00  0.00           O  
ATOM   1623  CB  THR A 109      39.704  63.422  31.687  1.00  0.00           C  
ATOM   1624  OG1 THR A 109      39.983  64.475  32.607  1.00  0.00           O  
ATOM   1625  CG2 THR A 109      39.737  62.158  32.549  1.00  0.00           C  
ATOM   1626  H   THR A 109      42.491  64.142  31.810  1.00  0.00           H  
ATOM   1627  HA  THR A 109      40.769  62.666  29.974  1.00  0.00           H  
ATOM   1628  HB  THR A 109      38.746  63.521  31.178  1.00  0.00           H  
ATOM   1629  HG1 THR A 109      40.858  64.309  33.063  1.00  0.00           H  
ATOM   1630 HG21 THR A 109      40.705  62.080  33.043  1.00  0.00           H  
ATOM   1631 HG22 THR A 109      38.949  62.208  33.299  1.00  0.00           H  
ATOM   1632 HG23 THR A 109      39.581  61.284  31.916  1.00  0.00           H  
ATOM   1633  N   GLY A 110      41.957  64.916  29.092  1.00  0.00           N  
ATOM   1634  CA  GLY A 110      42.128  66.102  28.269  1.00  0.00           C  
ATOM   1635  C   GLY A 110      41.969  65.765  26.785  1.00  0.00           C  
ATOM   1636  O   GLY A 110      41.593  64.648  26.434  1.00  0.00           O  
ATOM   1637  H   GLY A 110      42.683  64.234  29.006  1.00  0.00           H  
ATOM   1638  HA2 GLY A 110      41.396  66.856  28.555  1.00  0.00           H  
ATOM   1639  HA3 GLY A 110      43.114  66.531  28.445  1.00  0.00           H  
ATOM   1640  N   PRO A 111      42.272  66.780  25.930  1.00  0.00           N  
ATOM   1641  CA  PRO A 111      42.167  66.603  24.491  1.00  0.00           C  
ATOM   1642  C   PRO A 111      43.325  65.759  23.957  1.00  0.00           C  
ATOM   1643  O   PRO A 111      43.279  65.279  22.825  1.00  0.00           O  
ATOM   1644  CB  PRO A 111      42.146  68.012  23.923  1.00  0.00           C  
ATOM   1645  CG  PRO A 111      42.706  68.910  25.014  1.00  0.00           C  
ATOM   1646  CD  PRO A 111      42.722  68.115  26.310  1.00  0.00           C  
ATOM   1647  HA  PRO A 111      41.334  66.098  24.264  1.00  0.00           H  
ATOM   1648  HB2 PRO A 111      42.748  68.076  23.017  1.00  0.00           H  
ATOM   1649  HB3 PRO A 111      41.132  68.310  23.653  1.00  0.00           H  
ATOM   1650  HG2 PRO A 111      43.712  69.242  24.757  1.00  0.00           H  
ATOM   1651  HG3 PRO A 111      42.093  69.806  25.123  1.00  0.00           H  
ATOM   1652  HD2 PRO A 111      43.720  68.089  26.745  1.00  0.00           H  
ATOM   1653  HD3 PRO A 111      42.061  68.559  27.054  1.00  0.00           H  
ATOM   1654  N   ALA A 112      44.340  65.604  24.796  1.00  0.00           N  
ATOM   1655  CA  ALA A 112      45.509  64.826  24.421  1.00  0.00           C  
ATOM   1656  C   ALA A 112      45.321  63.378  24.879  1.00  0.00           C  
ATOM   1657  O   ALA A 112      45.093  62.489  24.059  1.00  0.00           O  
ATOM   1658  CB  ALA A 112      46.762  65.468  25.019  1.00  0.00           C  
ATOM   1659  H   ALA A 112      44.370  65.997  25.715  1.00  0.00           H  
ATOM   1660  HA  ALA A 112      45.587  64.849  23.334  1.00  0.00           H  
ATOM   1661  HB1 ALA A 112      46.717  66.549  24.882  1.00  0.00           H  
ATOM   1662  HB2 ALA A 112      46.815  65.239  26.083  1.00  0.00           H  
ATOM   1663  HB3 ALA A 112      47.646  65.075  24.517  1.00  0.00           H  
ATOM   1664  N   GLU A 113      45.423  63.185  26.185  1.00  0.00           N  
ATOM   1665  CA  GLU A 113      45.267  61.861  26.760  1.00  0.00           C  
ATOM   1666  C   GLU A 113      44.166  61.091  26.030  1.00  0.00           C  
ATOM   1667  O   GLU A 113      44.343  59.923  25.684  1.00  0.00           O  
ATOM   1668  CB  GLU A 113      44.974  61.946  28.260  1.00  0.00           C  
ATOM   1669  CG  GLU A 113      46.251  62.235  29.052  1.00  0.00           C  
ATOM   1670  CD  GLU A 113      46.724  60.990  29.804  1.00  0.00           C  
ATOM   1671  OE1 GLU A 113      46.473  59.882  29.283  1.00  0.00           O  
ATOM   1672  OE2 GLU A 113      47.326  61.173  30.885  1.00  0.00           O  
ATOM   1673  H   GLU A 113      45.608  63.914  26.845  1.00  0.00           H  
ATOM   1674  HA  GLU A 113      46.226  61.365  26.611  1.00  0.00           H  
ATOM   1675  HB2 GLU A 113      44.240  62.728  28.448  1.00  0.00           H  
ATOM   1676  HB3 GLU A 113      44.535  61.008  28.602  1.00  0.00           H  
ATOM   1677  HG2 GLU A 113      47.034  62.575  28.374  1.00  0.00           H  
ATOM   1678  HG3 GLU A 113      46.068  63.044  29.759  1.00  0.00           H  
ATOM   1679  N   LEU A 114      43.051  61.775  25.814  1.00  0.00           N  
ATOM   1680  CA  LEU A 114      41.921  61.170  25.131  1.00  0.00           C  
ATOM   1681  C   LEU A 114      42.353  60.733  23.730  1.00  0.00           C  
ATOM   1682  O   LEU A 114      42.379  59.540  23.428  1.00  0.00           O  
ATOM   1683  CB  LEU A 114      40.721  62.118  25.137  1.00  0.00           C  
ATOM   1684  CG  LEU A 114      40.086  62.388  26.503  1.00  0.00           C  
ATOM   1685  CD1 LEU A 114      39.047  63.508  26.413  1.00  0.00           C  
ATOM   1686  CD2 LEU A 114      39.499  61.107  27.097  1.00  0.00           C  
ATOM   1687  H   LEU A 114      42.914  62.724  26.098  1.00  0.00           H  
ATOM   1688  HA  LEU A 114      41.634  60.283  25.696  1.00  0.00           H  
ATOM   1689  HB2 LEU A 114      41.033  63.071  24.709  1.00  0.00           H  
ATOM   1690  HB3 LEU A 114      39.956  61.709  24.477  1.00  0.00           H  
ATOM   1691  HG  LEU A 114      40.868  62.729  27.182  1.00  0.00           H  
ATOM   1692 HD11 LEU A 114      38.088  63.089  26.106  1.00  0.00           H  
ATOM   1693 HD12 LEU A 114      38.940  63.984  27.388  1.00  0.00           H  
ATOM   1694 HD13 LEU A 114      39.372  64.248  25.681  1.00  0.00           H  
ATOM   1695 HD21 LEU A 114      39.818  60.251  26.503  1.00  0.00           H  
ATOM   1696 HD22 LEU A 114      39.849  60.988  28.123  1.00  0.00           H  
ATOM   1697 HD23 LEU A 114      38.411  61.169  27.090  1.00  0.00           H  
ATOM   1698  N   SER A 115      42.681  61.722  22.912  1.00  0.00           N  
ATOM   1699  CA  SER A 115      43.110  61.455  21.549  1.00  0.00           C  
ATOM   1700  C   SER A 115      44.022  60.227  21.519  1.00  0.00           C  
ATOM   1701  O   SER A 115      44.068  59.508  20.522  1.00  0.00           O  
ATOM   1702  CB  SER A 115      43.829  62.665  20.951  1.00  0.00           C  
ATOM   1703  OG  SER A 115      43.566  62.808  19.557  1.00  0.00           O  
ATOM   1704  H   SER A 115      42.657  62.689  23.164  1.00  0.00           H  
ATOM   1705  HA  SER A 115      42.194  61.265  20.990  1.00  0.00           H  
ATOM   1706  HB2 SER A 115      43.515  63.569  21.474  1.00  0.00           H  
ATOM   1707  HB3 SER A 115      44.903  62.563  21.108  1.00  0.00           H  
ATOM   1708  HG  SER A 115      43.641  63.769  19.292  1.00  0.00           H  
ATOM   1709  N   GLN A 116      44.726  60.025  22.623  1.00  0.00           N  
ATOM   1710  CA  GLN A 116      45.633  58.896  22.736  1.00  0.00           C  
ATOM   1711  C   GLN A 116      44.857  57.622  23.073  1.00  0.00           C  
ATOM   1712  O   GLN A 116      44.987  56.612  22.383  1.00  0.00           O  
ATOM   1713  CB  GLN A 116      46.720  59.168  23.779  1.00  0.00           C  
ATOM   1714  CG  GLN A 116      47.536  60.407  23.409  1.00  0.00           C  
ATOM   1715  CD  GLN A 116      48.956  60.023  22.988  1.00  0.00           C  
ATOM   1716  OE1 GLN A 116      49.207  59.601  21.870  1.00  0.00           O  
ATOM   1717  NE2 GLN A 116      49.868  60.189  23.941  1.00  0.00           N  
ATOM   1718  H   GLN A 116      44.683  60.615  23.429  1.00  0.00           H  
ATOM   1719  HA  GLN A 116      46.097  58.799  21.755  1.00  0.00           H  
ATOM   1720  HB2 GLN A 116      46.261  59.309  24.758  1.00  0.00           H  
ATOM   1721  HB3 GLN A 116      47.378  58.304  23.857  1.00  0.00           H  
ATOM   1722  HG2 GLN A 116      47.044  60.943  22.597  1.00  0.00           H  
ATOM   1723  HG3 GLN A 116      47.578  61.087  24.260  1.00  0.00           H  
ATOM   1724 HE21 GLN A 116      49.596  60.539  24.837  1.00  0.00           H  
ATOM   1725 HE22 GLN A 116      50.826  59.965  23.762  1.00  0.00           H  
ATOM   1726  N   PHE A 117      44.068  57.710  24.132  1.00  0.00           N  
ATOM   1727  CA  PHE A 117      43.270  56.576  24.568  1.00  0.00           C  
ATOM   1728  C   PHE A 117      42.345  56.094  23.449  1.00  0.00           C  
ATOM   1729  O   PHE A 117      42.117  54.894  23.301  1.00  0.00           O  
ATOM   1730  CB  PHE A 117      42.419  57.055  25.747  1.00  0.00           C  
ATOM   1731  CG  PHE A 117      41.357  56.049  26.197  1.00  0.00           C  
ATOM   1732  CD1 PHE A 117      41.710  54.764  26.466  1.00  0.00           C  
ATOM   1733  CD2 PHE A 117      40.061  56.440  26.325  1.00  0.00           C  
ATOM   1734  CE1 PHE A 117      40.725  53.830  26.884  1.00  0.00           C  
ATOM   1735  CE2 PHE A 117      39.077  55.506  26.743  1.00  0.00           C  
ATOM   1736  CZ  PHE A 117      39.429  54.221  27.013  1.00  0.00           C  
ATOM   1737  H   PHE A 117      43.968  58.535  24.688  1.00  0.00           H  
ATOM   1738  HA  PHE A 117      43.962  55.778  24.836  1.00  0.00           H  
ATOM   1739  HB2 PHE A 117      43.074  57.277  26.588  1.00  0.00           H  
ATOM   1740  HB3 PHE A 117      41.926  57.987  25.470  1.00  0.00           H  
ATOM   1741  HD1 PHE A 117      42.749  54.450  26.362  1.00  0.00           H  
ATOM   1742  HD2 PHE A 117      39.779  57.470  26.109  1.00  0.00           H  
ATOM   1743  HE1 PHE A 117      41.008  52.799  27.100  1.00  0.00           H  
ATOM   1744  HE2 PHE A 117      38.038  55.820  26.848  1.00  0.00           H  
ATOM   1745  HZ  PHE A 117      38.673  53.504  27.334  1.00  0.00           H  
ATOM   1746  N   TRP A 118      41.837  57.053  22.689  1.00  0.00           N  
ATOM   1747  CA  TRP A 118      40.942  56.740  21.588  1.00  0.00           C  
ATOM   1748  C   TRP A 118      41.780  56.152  20.450  1.00  0.00           C  
ATOM   1749  O   TRP A 118      41.235  55.648  19.470  1.00  0.00           O  
ATOM   1750  CB  TRP A 118      40.142  57.973  21.165  1.00  0.00           C  
ATOM   1751  CG  TRP A 118      39.043  58.371  22.153  1.00  0.00           C  
ATOM   1752  CD1 TRP A 118      38.901  59.531  22.807  1.00  0.00           C  
ATOM   1753  CD2 TRP A 118      37.929  57.554  22.572  1.00  0.00           C  
ATOM   1754  NE1 TRP A 118      37.783  59.523  23.615  1.00  0.00           N  
ATOM   1755  CE2 TRP A 118      37.172  58.283  23.468  1.00  0.00           C  
ATOM   1756  CE3 TRP A 118      37.572  56.245  22.208  1.00  0.00           C  
ATOM   1757  CZ2 TRP A 118      36.012  57.786  24.074  1.00  0.00           C  
ATOM   1758  CZ3 TRP A 118      36.410  55.762  22.822  1.00  0.00           C  
ATOM   1759  CH2 TRP A 118      35.638  56.483  23.726  1.00  0.00           C  
ATOM   1760  H   TRP A 118      42.027  58.026  22.816  1.00  0.00           H  
ATOM   1761  HA  TRP A 118      40.224  56.001  21.942  1.00  0.00           H  
ATOM   1762  HB2 TRP A 118      40.826  58.814  21.042  1.00  0.00           H  
ATOM   1763  HB3 TRP A 118      39.690  57.785  20.191  1.00  0.00           H  
ATOM   1764  HD1 TRP A 118      39.584  60.376  22.713  1.00  0.00           H  
ATOM   1765  HE1 TRP A 118      37.441  60.340  24.252  1.00  0.00           H  
ATOM   1766  HE3 TRP A 118      38.153  55.648  21.504  1.00  0.00           H  
ATOM   1767  HZ2 TRP A 118      35.432  58.381  24.779  1.00  0.00           H  
ATOM   1768  HZ3 TRP A 118      36.089  54.750  22.575  1.00  0.00           H  
ATOM   1769  HH2 TRP A 118      34.745  56.035  24.162  1.00  0.00           H  
ATOM   1770  N   LYS A 119      43.092  56.237  20.619  1.00  0.00           N  
ATOM   1771  CA  LYS A 119      44.010  55.719  19.619  1.00  0.00           C  
ATOM   1772  C   LYS A 119      44.478  54.324  20.036  1.00  0.00           C  
ATOM   1773  O   LYS A 119      44.825  53.503  19.189  1.00  0.00           O  
ATOM   1774  CB  LYS A 119      45.154  56.707  19.381  1.00  0.00           C  
ATOM   1775  CG  LYS A 119      46.475  55.970  19.154  1.00  0.00           C  
ATOM   1776  CD  LYS A 119      47.108  55.555  20.485  1.00  0.00           C  
ATOM   1777  CE  LYS A 119      48.632  55.485  20.369  1.00  0.00           C  
ATOM   1778  NZ  LYS A 119      49.180  54.503  21.332  1.00  0.00           N  
ATOM   1779  H   LYS A 119      43.527  56.649  21.420  1.00  0.00           H  
ATOM   1780  HA  LYS A 119      43.458  55.633  18.683  1.00  0.00           H  
ATOM   1781  HB2 LYS A 119      44.928  57.330  18.515  1.00  0.00           H  
ATOM   1782  HB3 LYS A 119      45.248  57.374  20.237  1.00  0.00           H  
ATOM   1783  HG2 LYS A 119      46.303  55.086  18.539  1.00  0.00           H  
ATOM   1784  HG3 LYS A 119      47.165  56.611  18.605  1.00  0.00           H  
ATOM   1785  HD2 LYS A 119      46.831  56.269  21.261  1.00  0.00           H  
ATOM   1786  HD3 LYS A 119      46.717  54.586  20.791  1.00  0.00           H  
ATOM   1787  HE2 LYS A 119      48.913  55.204  19.354  1.00  0.00           H  
ATOM   1788  HE3 LYS A 119      49.062  56.468  20.559  1.00  0.00           H  
ATOM   1789  HZ1 LYS A 119      48.960  54.792  22.263  1.00  0.00           H  
ATOM   1790  HZ2 LYS A 119      48.777  53.605  21.156  1.00  0.00           H  
ATOM   1791  HZ3 LYS A 119      50.172  54.450  21.225  1.00  0.00           H  
ATOM   1792  N   GLU A 120      44.472  54.099  21.342  1.00  0.00           N  
ATOM   1793  CA  GLU A 120      44.893  52.817  21.881  1.00  0.00           C  
ATOM   1794  C   GLU A 120      43.692  51.879  22.017  1.00  0.00           C  
ATOM   1795  O   GLU A 120      43.786  50.695  21.700  1.00  0.00           O  
ATOM   1796  CB  GLU A 120      45.604  52.994  23.224  1.00  0.00           C  
ATOM   1797  CG  GLU A 120      44.700  52.572  24.384  1.00  0.00           C  
ATOM   1798  CD  GLU A 120      45.405  52.765  25.728  1.00  0.00           C  
ATOM   1799  OE1 GLU A 120      46.316  51.958  26.012  1.00  0.00           O  
ATOM   1800  OE2 GLU A 120      45.018  53.716  26.440  1.00  0.00           O  
ATOM   1801  H   GLU A 120      44.188  54.772  22.025  1.00  0.00           H  
ATOM   1802  HA  GLU A 120      45.597  52.413  21.154  1.00  0.00           H  
ATOM   1803  HB2 GLU A 120      46.519  52.400  23.237  1.00  0.00           H  
ATOM   1804  HB3 GLU A 120      45.899  54.037  23.350  1.00  0.00           H  
ATOM   1805  HG2 GLU A 120      43.780  53.156  24.365  1.00  0.00           H  
ATOM   1806  HG3 GLU A 120      44.416  51.526  24.266  1.00  0.00           H  
ATOM   1807  N   VAL A 121      42.590  52.444  22.489  1.00  0.00           N  
ATOM   1808  CA  VAL A 121      41.372  51.673  22.671  1.00  0.00           C  
ATOM   1809  C   VAL A 121      40.805  51.293  21.301  1.00  0.00           C  
ATOM   1810  O   VAL A 121      40.523  52.164  20.479  1.00  0.00           O  
ATOM   1811  CB  VAL A 121      40.379  52.456  23.532  1.00  0.00           C  
ATOM   1812  CG1 VAL A 121      39.819  53.658  22.768  1.00  0.00           C  
ATOM   1813  CG2 VAL A 121      39.253  51.550  24.032  1.00  0.00           C  
ATOM   1814  H   VAL A 121      42.522  53.408  22.745  1.00  0.00           H  
ATOM   1815  HA  VAL A 121      41.636  50.761  23.206  1.00  0.00           H  
ATOM   1816  HB  VAL A 121      40.917  52.834  24.402  1.00  0.00           H  
ATOM   1817 HG11 VAL A 121      38.831  53.413  22.380  1.00  0.00           H  
ATOM   1818 HG12 VAL A 121      39.746  54.513  23.440  1.00  0.00           H  
ATOM   1819 HG13 VAL A 121      40.484  53.903  21.939  1.00  0.00           H  
ATOM   1820 HG21 VAL A 121      39.064  51.753  25.086  1.00  0.00           H  
ATOM   1821 HG22 VAL A 121      38.347  51.747  23.457  1.00  0.00           H  
ATOM   1822 HG23 VAL A 121      39.543  50.507  23.907  1.00  0.00           H  
ATOM   1823  N   PRO A 122      40.651  49.958  21.092  1.00  0.00           N  
ATOM   1824  CA  PRO A 122      40.123  49.453  19.836  1.00  0.00           C  
ATOM   1825  C   PRO A 122      38.612  49.677  19.748  1.00  0.00           C  
ATOM   1826  O   PRO A 122      37.910  49.606  20.755  1.00  0.00           O  
ATOM   1827  CB  PRO A 122      40.509  47.983  19.811  1.00  0.00           C  
ATOM   1828  CG  PRO A 122      40.828  47.611  21.249  1.00  0.00           C  
ATOM   1829  CD  PRO A 122      40.974  48.898  22.043  1.00  0.00           C  
ATOM   1830  HA  PRO A 122      40.519  49.954  19.067  1.00  0.00           H  
ATOM   1831  HB2 PRO A 122      39.694  47.373  19.420  1.00  0.00           H  
ATOM   1832  HB3 PRO A 122      41.370  47.817  19.164  1.00  0.00           H  
ATOM   1833  HG2 PRO A 122      40.033  46.992  21.668  1.00  0.00           H  
ATOM   1834  HG3 PRO A 122      41.746  47.026  21.298  1.00  0.00           H  
ATOM   1835  HD2 PRO A 122      40.300  48.915  22.899  1.00  0.00           H  
ATOM   1836  HD3 PRO A 122      41.987  49.010  22.432  1.00  0.00           H  
ATOM   1837  N   ARG A 123      38.155  49.941  18.533  1.00  0.00           N  
ATOM   1838  CA  ARG A 123      36.741  50.175  18.299  1.00  0.00           C  
ATOM   1839  C   ARG A 123      35.907  49.051  18.918  1.00  0.00           C  
ATOM   1840  O   ARG A 123      34.741  49.252  19.256  1.00  0.00           O  
ATOM   1841  CB  ARG A 123      36.436  50.261  16.801  1.00  0.00           C  
ATOM   1842  CG  ARG A 123      37.239  49.220  16.019  1.00  0.00           C  
ATOM   1843  CD  ARG A 123      38.483  49.849  15.387  1.00  0.00           C  
ATOM   1844  NE  ARG A 123      38.327  49.914  13.917  1.00  0.00           N  
ATOM   1845  CZ  ARG A 123      39.301  50.281  13.074  1.00  0.00           C  
ATOM   1846  NH1 ARG A 123      40.506  50.619  13.550  1.00  0.00           N  
ATOM   1847  NH2 ARG A 123      39.069  50.310  11.754  1.00  0.00           N  
ATOM   1848  H   ARG A 123      38.733  49.997  17.718  1.00  0.00           H  
ATOM   1849  HA  ARG A 123      36.532  51.130  18.783  1.00  0.00           H  
ATOM   1850  HB2 ARG A 123      35.371  50.105  16.634  1.00  0.00           H  
ATOM   1851  HB3 ARG A 123      36.673  51.260  16.436  1.00  0.00           H  
ATOM   1852  HG2 ARG A 123      37.535  48.409  16.683  1.00  0.00           H  
ATOM   1853  HG3 ARG A 123      36.613  48.784  15.241  1.00  0.00           H  
ATOM   1854  HD2 ARG A 123      38.638  50.850  15.789  1.00  0.00           H  
ATOM   1855  HD3 ARG A 123      39.365  49.263  15.642  1.00  0.00           H  
ATOM   1856  HE  ARG A 123      37.439  49.667  13.529  1.00  0.00           H  
ATOM   1857 HH11 ARG A 123      40.680  50.598  14.535  1.00  0.00           H  
ATOM   1858 HH12 ARG A 123      41.234  50.894  12.920  1.00  0.00           H  
ATOM   1859 HH21 ARG A 123      38.169  50.057  11.399  1.00  0.00           H  
ATOM   1860 HH22 ARG A 123      39.796  50.584  11.125  1.00  0.00           H  
ATOM   1861  N   ASN A 124      36.538  47.893  19.048  1.00  0.00           N  
ATOM   1862  CA  ASN A 124      35.869  46.737  19.620  1.00  0.00           C  
ATOM   1863  C   ASN A 124      35.606  46.990  21.106  1.00  0.00           C  
ATOM   1864  O   ASN A 124      34.653  46.454  21.672  1.00  0.00           O  
ATOM   1865  CB  ASN A 124      36.738  45.483  19.502  1.00  0.00           C  
ATOM   1866  CG  ASN A 124      35.895  44.268  19.113  1.00  0.00           C  
ATOM   1867  OD1 ASN A 124      35.115  44.294  18.175  1.00  0.00           O  
ATOM   1868  ND2 ASN A 124      36.094  43.202  19.883  1.00  0.00           N  
ATOM   1869  H   ASN A 124      37.486  47.739  18.770  1.00  0.00           H  
ATOM   1870  HA  ASN A 124      34.949  46.625  19.047  1.00  0.00           H  
ATOM   1871  HB2 ASN A 124      37.516  45.645  18.755  1.00  0.00           H  
ATOM   1872  HB3 ASN A 124      37.240  45.293  20.449  1.00  0.00           H  
ATOM   1873 HD21 ASN A 124      36.750  43.246  20.637  1.00  0.00           H  
ATOM   1874 HD22 ASN A 124      35.590  42.357  19.708  1.00  0.00           H  
ATOM   1875  N   LYS A 125      36.464  47.808  21.697  1.00  0.00           N  
ATOM   1876  CA  LYS A 125      36.336  48.138  23.105  1.00  0.00           C  
ATOM   1877  C   LYS A 125      35.507  49.416  23.252  1.00  0.00           C  
ATOM   1878  O   LYS A 125      34.965  49.690  24.321  1.00  0.00           O  
ATOM   1879  CB  LYS A 125      37.714  48.221  23.765  1.00  0.00           C  
ATOM   1880  CG  LYS A 125      38.518  46.942  23.518  1.00  0.00           C  
ATOM   1881  CD  LYS A 125      38.189  45.878  24.566  1.00  0.00           C  
ATOM   1882  CE  LYS A 125      39.366  44.920  24.762  1.00  0.00           C  
ATOM   1883  NZ  LYS A 125      38.977  43.795  25.641  1.00  0.00           N  
ATOM   1884  H   LYS A 125      37.235  48.241  21.229  1.00  0.00           H  
ATOM   1885  HA  LYS A 125      35.799  47.321  23.585  1.00  0.00           H  
ATOM   1886  HB2 LYS A 125      38.260  49.079  23.370  1.00  0.00           H  
ATOM   1887  HB3 LYS A 125      37.600  48.383  24.836  1.00  0.00           H  
ATOM   1888  HG2 LYS A 125      38.298  46.558  22.522  1.00  0.00           H  
ATOM   1889  HG3 LYS A 125      39.584  47.169  23.544  1.00  0.00           H  
ATOM   1890  HD2 LYS A 125      37.945  46.359  25.513  1.00  0.00           H  
ATOM   1891  HD3 LYS A 125      37.307  45.318  24.256  1.00  0.00           H  
ATOM   1892  HE2 LYS A 125      39.695  44.538  23.796  1.00  0.00           H  
ATOM   1893  HE3 LYS A 125      40.209  45.455  25.198  1.00  0.00           H  
ATOM   1894  HZ1 LYS A 125      39.641  43.053  25.547  1.00  0.00           H  
ATOM   1895  HZ2 LYS A 125      38.956  44.106  26.591  1.00  0.00           H  
ATOM   1896  HZ3 LYS A 125      38.070  43.465  25.378  1.00  0.00           H  
ATOM   1897  N   VAL A 126      35.434  50.164  22.160  1.00  0.00           N  
ATOM   1898  CA  VAL A 126      34.679  51.406  22.154  1.00  0.00           C  
ATOM   1899  C   VAL A 126      33.184  51.090  22.106  1.00  0.00           C  
ATOM   1900  O   VAL A 126      32.682  50.595  21.097  1.00  0.00           O  
ATOM   1901  CB  VAL A 126      35.141  52.292  20.994  1.00  0.00           C  
ATOM   1902  CG1 VAL A 126      34.186  53.470  20.791  1.00  0.00           C  
ATOM   1903  CG2 VAL A 126      36.574  52.780  21.212  1.00  0.00           C  
ATOM   1904  H   VAL A 126      35.877  49.935  21.294  1.00  0.00           H  
ATOM   1905  HA  VAL A 126      34.899  51.928  23.085  1.00  0.00           H  
ATOM   1906  HB  VAL A 126      35.127  51.689  20.087  1.00  0.00           H  
ATOM   1907 HG11 VAL A 126      34.160  54.076  21.696  1.00  0.00           H  
ATOM   1908 HG12 VAL A 126      34.533  54.079  19.956  1.00  0.00           H  
ATOM   1909 HG13 VAL A 126      33.186  53.094  20.576  1.00  0.00           H  
ATOM   1910 HG21 VAL A 126      37.259  52.171  20.622  1.00  0.00           H  
ATOM   1911 HG22 VAL A 126      36.655  53.822  20.904  1.00  0.00           H  
ATOM   1912 HG23 VAL A 126      36.831  52.693  22.268  1.00  0.00           H  
ATOM   1913  N   MET A 127      32.513  51.387  23.210  1.00  0.00           N  
ATOM   1914  CA  MET A 127      31.085  51.140  23.306  1.00  0.00           C  
ATOM   1915  C   MET A 127      30.285  52.330  22.771  1.00  0.00           C  
ATOM   1916  O   MET A 127      30.316  53.414  23.351  1.00  0.00           O  
ATOM   1917  CB  MET A 127      30.707  50.887  24.768  1.00  0.00           C  
ATOM   1918  CG  MET A 127      29.202  50.656  24.913  1.00  0.00           C  
ATOM   1919  SD  MET A 127      28.723  50.815  26.625  1.00  0.00           S  
ATOM   1920  CE  MET A 127      28.392  52.569  26.691  1.00  0.00           C  
ATOM   1921  H   MET A 127      32.929  51.789  24.025  1.00  0.00           H  
ATOM   1922  HA  MET A 127      30.898  50.260  22.690  1.00  0.00           H  
ATOM   1923  HB2 MET A 127      31.251  50.020  25.142  1.00  0.00           H  
ATOM   1924  HB3 MET A 127      31.009  51.739  25.377  1.00  0.00           H  
ATOM   1925  HG2 MET A 127      28.655  51.374  24.304  1.00  0.00           H  
ATOM   1926  HG3 MET A 127      28.942  49.662  24.546  1.00  0.00           H  
ATOM   1927  HE1 MET A 127      29.208  53.073  27.209  1.00  0.00           H  
ATOM   1928  HE2 MET A 127      28.307  52.960  25.677  1.00  0.00           H  
ATOM   1929  HE3 MET A 127      27.459  52.742  27.227  1.00  0.00           H  
ATOM   1930  N   GLU A 128      29.588  52.086  21.671  1.00  0.00           N  
ATOM   1931  CA  GLU A 128      28.781  53.124  21.051  1.00  0.00           C  
ATOM   1932  C   GLU A 128      27.304  52.922  21.391  1.00  0.00           C  
ATOM   1933  O   GLU A 128      26.789  51.808  21.299  1.00  0.00           O  
ATOM   1934  CB  GLU A 128      28.997  53.155  19.536  1.00  0.00           C  
ATOM   1935  CG  GLU A 128      30.332  53.814  19.186  1.00  0.00           C  
ATOM   1936  CD  GLU A 128      30.882  53.272  17.865  1.00  0.00           C  
ATOM   1937  OE1 GLU A 128      30.067  53.128  16.928  1.00  0.00           O  
ATOM   1938  OE2 GLU A 128      32.104  53.014  17.822  1.00  0.00           O  
ATOM   1939  H   GLU A 128      29.569  51.201  21.205  1.00  0.00           H  
ATOM   1940  HA  GLU A 128      29.135  54.061  21.481  1.00  0.00           H  
ATOM   1941  HB2 GLU A 128      28.975  52.139  19.142  1.00  0.00           H  
ATOM   1942  HB3 GLU A 128      28.181  53.699  19.061  1.00  0.00           H  
ATOM   1943  HG2 GLU A 128      30.199  54.895  19.112  1.00  0.00           H  
ATOM   1944  HG3 GLU A 128      31.051  53.635  19.985  1.00  0.00           H  
ATOM   1945  N   HIS A 129      26.663  54.015  21.776  1.00  0.00           N  
ATOM   1946  CA  HIS A 129      25.254  53.972  22.129  1.00  0.00           C  
ATOM   1947  C   HIS A 129      24.500  55.067  21.373  1.00  0.00           C  
ATOM   1948  O   HIS A 129      24.700  56.254  21.629  1.00  0.00           O  
ATOM   1949  CB  HIS A 129      25.071  54.067  23.646  1.00  0.00           C  
ATOM   1950  CG  HIS A 129      23.721  53.598  24.132  1.00  0.00           C  
ATOM   1951  ND1 HIS A 129      23.193  52.362  23.804  1.00  0.00           N  
ATOM   1952  CD2 HIS A 129      22.796  54.214  24.925  1.00  0.00           C  
ATOM   1953  CE1 HIS A 129      22.004  52.249  24.379  1.00  0.00           C  
ATOM   1954  NE2 HIS A 129      21.760  53.398  25.072  1.00  0.00           N  
ATOM   1955  H   HIS A 129      27.089  54.917  21.847  1.00  0.00           H  
ATOM   1956  HA  HIS A 129      24.881  52.999  21.810  1.00  0.00           H  
ATOM   1957  HB2 HIS A 129      25.847  53.474  24.132  1.00  0.00           H  
ATOM   1958  HB3 HIS A 129      25.219  55.101  23.955  1.00  0.00           H  
ATOM   1959  HD1 HIS A 129      23.634  51.671  23.231  1.00  0.00           H  
ATOM   1960  HD2 HIS A 129      22.893  55.207  25.362  1.00  0.00           H  
ATOM   1961  HE1 HIS A 129      21.338  51.389  24.309  1.00  0.00           H  
ATOM   1962  N   ARG A 130      23.652  54.630  20.454  1.00  0.00           N  
ATOM   1963  CA  ARG A 130      22.867  55.559  19.658  1.00  0.00           C  
ATOM   1964  C   ARG A 130      21.550  55.883  20.365  1.00  0.00           C  
ATOM   1965  O   ARG A 130      20.845  54.982  20.817  1.00  0.00           O  
ATOM   1966  CB  ARG A 130      22.566  54.980  18.274  1.00  0.00           C  
ATOM   1967  CG  ARG A 130      23.736  55.213  17.316  1.00  0.00           C  
ATOM   1968  CD  ARG A 130      24.145  53.911  16.622  1.00  0.00           C  
ATOM   1969  NE  ARG A 130      25.037  53.126  17.505  1.00  0.00           N  
ATOM   1970  CZ  ARG A 130      25.260  51.812  17.369  1.00  0.00           C  
ATOM   1971  NH1 ARG A 130      24.659  51.128  16.386  1.00  0.00           N  
ATOM   1972  NH2 ARG A 130      26.086  51.182  18.215  1.00  0.00           N  
ATOM   1973  H   ARG A 130      23.495  53.664  20.252  1.00  0.00           H  
ATOM   1974  HA  ARG A 130      23.493  56.447  19.568  1.00  0.00           H  
ATOM   1975  HB2 ARG A 130      22.368  53.911  18.358  1.00  0.00           H  
ATOM   1976  HB3 ARG A 130      21.664  55.440  17.871  1.00  0.00           H  
ATOM   1977  HG2 ARG A 130      23.456  55.955  16.569  1.00  0.00           H  
ATOM   1978  HG3 ARG A 130      24.585  55.618  17.866  1.00  0.00           H  
ATOM   1979  HD2 ARG A 130      23.258  53.327  16.376  1.00  0.00           H  
ATOM   1980  HD3 ARG A 130      24.651  54.133  15.683  1.00  0.00           H  
ATOM   1981  HE  ARG A 130      25.501  53.607  18.248  1.00  0.00           H  
ATOM   1982 HH11 ARG A 130      24.043  51.598  15.754  1.00  0.00           H  
ATOM   1983 HH12 ARG A 130      24.826  50.147  16.284  1.00  0.00           H  
ATOM   1984 HH21 ARG A 130      26.535  51.692  18.948  1.00  0.00           H  
ATOM   1985 HH22 ARG A 130      26.253  50.201  18.113  1.00  0.00           H  
ATOM   1986  N   LEU A 131      21.256  57.173  20.437  1.00  0.00           N  
ATOM   1987  CA  LEU A 131      20.036  57.628  21.082  1.00  0.00           C  
ATOM   1988  C   LEU A 131      19.016  58.022  20.012  1.00  0.00           C  
ATOM   1989  O   LEU A 131      19.374  58.226  18.853  1.00  0.00           O  
ATOM   1990  CB  LEU A 131      20.341  58.745  22.081  1.00  0.00           C  
ATOM   1991  CG  LEU A 131      20.322  58.347  23.558  1.00  0.00           C  
ATOM   1992  CD1 LEU A 131      21.343  59.159  24.358  1.00  0.00           C  
ATOM   1993  CD2 LEU A 131      18.913  58.466  24.141  1.00  0.00           C  
ATOM   1994  H   LEU A 131      21.834  57.900  20.067  1.00  0.00           H  
ATOM   1995  HA  LEU A 131      19.634  56.788  21.649  1.00  0.00           H  
ATOM   1996  HB2 LEU A 131      21.324  59.155  21.848  1.00  0.00           H  
ATOM   1997  HB3 LEU A 131      19.618  59.546  21.933  1.00  0.00           H  
ATOM   1998  HG  LEU A 131      20.615  57.300  23.634  1.00  0.00           H  
ATOM   1999 HD11 LEU A 131      20.849  59.627  25.210  1.00  0.00           H  
ATOM   2000 HD12 LEU A 131      22.135  58.499  24.714  1.00  0.00           H  
ATOM   2001 HD13 LEU A 131      21.774  59.931  23.720  1.00  0.00           H  
ATOM   2002 HD21 LEU A 131      18.798  57.756  24.961  1.00  0.00           H  
ATOM   2003 HD22 LEU A 131      18.757  59.478  24.512  1.00  0.00           H  
ATOM   2004 HD23 LEU A 131      18.180  58.246  23.365  1.00  0.00           H  
ATOM   2005  N   ARG A 132      17.765  58.118  20.439  1.00  0.00           N  
ATOM   2006  CA  ARG A 132      16.690  58.485  19.532  1.00  0.00           C  
ATOM   2007  C   ARG A 132      15.956  59.722  20.051  1.00  0.00           C  
ATOM   2008  O   ARG A 132      15.996  60.016  21.245  1.00  0.00           O  
ATOM   2009  CB  ARG A 132      15.691  57.337  19.369  1.00  0.00           C  
ATOM   2010  CG  ARG A 132      15.051  56.975  20.710  1.00  0.00           C  
ATOM   2011  CD  ARG A 132      13.581  57.400  20.748  1.00  0.00           C  
ATOM   2012  NE  ARG A 132      12.771  56.363  21.427  1.00  0.00           N  
ATOM   2013  CZ  ARG A 132      12.438  55.189  20.872  1.00  0.00           C  
ATOM   2014  NH1 ARG A 132      12.841  54.897  19.628  1.00  0.00           N  
ATOM   2015  NH2 ARG A 132      11.700  54.309  21.561  1.00  0.00           N  
ATOM   2016  H   ARG A 132      17.482  57.951  21.383  1.00  0.00           H  
ATOM   2017  HA  ARG A 132      17.186  58.692  18.583  1.00  0.00           H  
ATOM   2018  HB2 ARG A 132      14.917  57.622  18.657  1.00  0.00           H  
ATOM   2019  HB3 ARG A 132      16.197  56.465  18.957  1.00  0.00           H  
ATOM   2020  HG2 ARG A 132      15.126  55.900  20.875  1.00  0.00           H  
ATOM   2021  HG3 ARG A 132      15.594  57.460  21.521  1.00  0.00           H  
ATOM   2022  HD2 ARG A 132      13.483  58.350  21.273  1.00  0.00           H  
ATOM   2023  HD3 ARG A 132      13.212  57.556  19.735  1.00  0.00           H  
ATOM   2024  HE  ARG A 132      12.453  56.549  22.355  1.00  0.00           H  
ATOM   2025 HH11 ARG A 132      13.392  55.553  19.114  1.00  0.00           H  
ATOM   2026 HH12 ARG A 132      12.593  54.021  19.214  1.00  0.00           H  
ATOM   2027 HH21 ARG A 132      11.398  54.527  22.489  1.00  0.00           H  
ATOM   2028 HH22 ARG A 132      11.450  53.433  21.148  1.00  0.00           H  
ATOM   2029  N   CYS A 133      15.303  60.413  19.129  1.00  0.00           N  
ATOM   2030  CA  CYS A 133      14.560  61.612  19.479  1.00  0.00           C  
ATOM   2031  C   CYS A 133      13.066  61.302  19.368  1.00  0.00           C  
ATOM   2032  O   CYS A 133      12.598  60.855  18.323  1.00  0.00           O  
ATOM   2033  CB  CYS A 133      14.962  62.802  18.606  1.00  0.00           C  
ATOM   2034  SG  CYS A 133      16.783  62.990  18.603  1.00  0.00           S  
ATOM   2035  H   CYS A 133      15.275  60.167  18.160  1.00  0.00           H  
ATOM   2036  HA  CYS A 133      14.829  61.858  20.506  1.00  0.00           H  
ATOM   2037  HB2 CYS A 133      14.602  62.654  17.587  1.00  0.00           H  
ATOM   2038  HB3 CYS A 133      14.495  63.713  18.980  1.00  0.00           H  
ATOM   2039  HG  CYS A 133      16.989  62.350  19.750  1.00  0.00           H  
ATOM   2040  N   HIS A 134      12.359  61.552  20.460  1.00  0.00           N  
ATOM   2041  CA  HIS A 134      10.928  61.304  20.499  1.00  0.00           C  
ATOM   2042  C   HIS A 134      10.176  62.577  20.104  1.00  0.00           C  
ATOM   2043  O   HIS A 134       9.531  63.205  20.940  1.00  0.00           O  
ATOM   2044  CB  HIS A 134      10.506  60.768  21.869  1.00  0.00           C  
ATOM   2045  CG  HIS A 134       9.687  59.501  21.805  1.00  0.00           C  
ATOM   2046  ND1 HIS A 134      10.254  58.247  21.657  1.00  0.00           N  
ATOM   2047  CD2 HIS A 134       8.338  59.307  21.874  1.00  0.00           C  
ATOM   2048  CE1 HIS A 134       9.282  57.348  21.636  1.00  0.00           C  
ATOM   2049  NE2 HIS A 134       8.095  58.006  21.771  1.00  0.00           N  
ATOM   2050  H   HIS A 134      12.748  61.916  21.307  1.00  0.00           H  
ATOM   2051  HA  HIS A 134      10.725  60.528  19.761  1.00  0.00           H  
ATOM   2052  HB2 HIS A 134      11.399  60.582  22.465  1.00  0.00           H  
ATOM   2053  HB3 HIS A 134       9.931  61.535  22.386  1.00  0.00           H  
ATOM   2054  HD1 HIS A 134      11.233  58.054  21.577  1.00  0.00           H  
ATOM   2055  HD2 HIS A 134       7.588  60.088  21.993  1.00  0.00           H  
ATOM   2056  HE1 HIS A 134       9.408  56.270  21.531  1.00  0.00           H  
ATOM   2057  N   THR A 135      10.286  62.918  18.828  1.00  0.00           N  
ATOM   2058  CA  THR A 135       9.625  64.105  18.312  1.00  0.00           C  
ATOM   2059  C   THR A 135       8.243  64.264  18.947  1.00  0.00           C  
ATOM   2060  O   THR A 135       7.425  63.346  18.900  1.00  0.00           O  
ATOM   2061  CB  THR A 135       9.585  63.997  16.787  1.00  0.00           C  
ATOM   2062  OG1 THR A 135       8.858  62.796  16.542  1.00  0.00           O  
ATOM   2063  CG2 THR A 135      10.964  63.727  16.181  1.00  0.00           C  
ATOM   2064  H   THR A 135      10.815  62.402  18.155  1.00  0.00           H  
ATOM   2065  HA  THR A 135      10.212  64.977  18.600  1.00  0.00           H  
ATOM   2066  HB  THR A 135       9.133  64.885  16.345  1.00  0.00           H  
ATOM   2067  HG1 THR A 135       9.388  62.007  16.852  1.00  0.00           H  
ATOM   2068 HG21 THR A 135      11.098  62.654  16.045  1.00  0.00           H  
ATOM   2069 HG22 THR A 135      11.042  64.229  15.216  1.00  0.00           H  
ATOM   2070 HG23 THR A 135      11.736  64.107  16.851  1.00  0.00           H  
ATOM   2071  N   VAL A 136       8.024  65.435  19.526  1.00  0.00           N  
ATOM   2072  CA  VAL A 136       6.754  65.726  20.169  1.00  0.00           C  
ATOM   2073  C   VAL A 136       5.768  66.255  19.126  1.00  0.00           C  
ATOM   2074  O   VAL A 136       6.100  67.148  18.349  1.00  0.00           O  
ATOM   2075  CB  VAL A 136       6.968  66.695  21.335  1.00  0.00           C  
ATOM   2076  CG1 VAL A 136       7.898  66.090  22.388  1.00  0.00           C  
ATOM   2077  CG2 VAL A 136       7.503  68.040  20.838  1.00  0.00           C  
ATOM   2078  H   VAL A 136       8.695  66.176  19.560  1.00  0.00           H  
ATOM   2079  HA  VAL A 136       6.369  64.791  20.576  1.00  0.00           H  
ATOM   2080  HB  VAL A 136       6.001  66.873  21.805  1.00  0.00           H  
ATOM   2081 HG11 VAL A 136       7.755  65.010  22.422  1.00  0.00           H  
ATOM   2082 HG12 VAL A 136       8.934  66.310  22.129  1.00  0.00           H  
ATOM   2083 HG13 VAL A 136       7.669  66.517  23.364  1.00  0.00           H  
ATOM   2084 HG21 VAL A 136       7.645  67.998  19.759  1.00  0.00           H  
ATOM   2085 HG22 VAL A 136       6.790  68.827  21.081  1.00  0.00           H  
ATOM   2086 HG23 VAL A 136       8.457  68.252  21.323  1.00  0.00           H  
ATOM   2087  N   GLU A 137       4.574  65.679  19.143  1.00  0.00           N  
ATOM   2088  CA  GLU A 137       3.537  66.081  18.208  1.00  0.00           C  
ATOM   2089  C   GLU A 137       2.160  65.673  18.736  1.00  0.00           C  
ATOM   2090  O   GLU A 137       2.002  64.588  19.293  1.00  0.00           O  
ATOM   2091  CB  GLU A 137       3.791  65.490  16.820  1.00  0.00           C  
ATOM   2092  CG  GLU A 137       4.058  63.985  16.906  1.00  0.00           C  
ATOM   2093  CD  GLU A 137       3.197  63.217  15.901  1.00  0.00           C  
ATOM   2094  OE1 GLU A 137       2.052  63.665  15.677  1.00  0.00           O  
ATOM   2095  OE2 GLU A 137       3.704  62.201  15.379  1.00  0.00           O  
ATOM   2096  H   GLU A 137       4.311  64.954  19.779  1.00  0.00           H  
ATOM   2097  HA  GLU A 137       3.604  67.168  18.151  1.00  0.00           H  
ATOM   2098  HB2 GLU A 137       2.929  65.673  16.180  1.00  0.00           H  
ATOM   2099  HB3 GLU A 137       4.643  65.988  16.359  1.00  0.00           H  
ATOM   2100  HG2 GLU A 137       5.112  63.788  16.713  1.00  0.00           H  
ATOM   2101  HG3 GLU A 137       3.847  63.632  17.915  1.00  0.00           H  
ATOM   2102  N   SER A 138       1.199  66.563  18.539  1.00  0.00           N  
ATOM   2103  CA  SER A 138      -0.159  66.309  18.988  1.00  0.00           C  
ATOM   2104  C   SER A 138      -0.143  65.728  20.403  1.00  0.00           C  
ATOM   2105  O   SER A 138      -0.356  64.531  20.589  1.00  0.00           O  
ATOM   2106  CB  SER A 138      -0.887  65.359  18.033  1.00  0.00           C  
ATOM   2107  OG  SER A 138      -1.893  66.028  17.278  1.00  0.00           O  
ATOM   2108  H   SER A 138       1.336  67.443  18.085  1.00  0.00           H  
ATOM   2109  HA  SER A 138      -0.654  67.281  18.979  1.00  0.00           H  
ATOM   2110  HB2 SER A 138      -0.164  64.907  17.353  1.00  0.00           H  
ATOM   2111  HB3 SER A 138      -1.339  64.548  18.603  1.00  0.00           H  
ATOM   2112  HG  SER A 138      -2.708  66.165  17.842  1.00  0.00           H  
ATOM   2113  N   SER A 139       0.111  66.603  21.365  1.00  0.00           N  
ATOM   2114  CA  SER A 139       0.158  66.192  22.757  1.00  0.00           C  
ATOM   2115  C   SER A 139      -1.262  65.989  23.292  1.00  0.00           C  
ATOM   2116  O   SER A 139      -1.965  66.956  23.578  1.00  0.00           O  
ATOM   2117  CB  SER A 139       0.904  67.220  23.611  1.00  0.00           C  
ATOM   2118  OG  SER A 139       2.304  66.964  23.653  1.00  0.00           O  
ATOM   2119  H   SER A 139       0.283  67.575  21.205  1.00  0.00           H  
ATOM   2120  HA  SER A 139       0.707  65.250  22.762  1.00  0.00           H  
ATOM   2121  HB2 SER A 139       0.729  68.219  23.209  1.00  0.00           H  
ATOM   2122  HB3 SER A 139       0.502  67.210  24.624  1.00  0.00           H  
ATOM   2123  HG  SER A 139       2.809  67.772  23.349  1.00  0.00           H  
ATOM   2124  N   LYS A 140      -1.639  64.724  23.409  1.00  0.00           N  
ATOM   2125  CA  LYS A 140      -2.962  64.382  23.903  1.00  0.00           C  
ATOM   2126  C   LYS A 140      -3.130  62.861  23.887  1.00  0.00           C  
ATOM   2127  O   LYS A 140      -2.551  62.178  23.044  1.00  0.00           O  
ATOM   2128  CB  LYS A 140      -4.040  65.127  23.112  1.00  0.00           C  
ATOM   2129  CG  LYS A 140      -4.588  66.310  23.914  1.00  0.00           C  
ATOM   2130  CD  LYS A 140      -4.884  67.502  23.001  1.00  0.00           C  
ATOM   2131  CE  LYS A 140      -6.028  68.350  23.561  1.00  0.00           C  
ATOM   2132  NZ  LYS A 140      -6.474  69.343  22.558  1.00  0.00           N  
ATOM   2133  H   LYS A 140      -1.061  63.943  23.173  1.00  0.00           H  
ATOM   2134  HA  LYS A 140      -3.025  64.725  24.935  1.00  0.00           H  
ATOM   2135  HB2 LYS A 140      -3.623  65.485  22.170  1.00  0.00           H  
ATOM   2136  HB3 LYS A 140      -4.852  64.445  22.863  1.00  0.00           H  
ATOM   2137  HG2 LYS A 140      -5.498  66.010  24.433  1.00  0.00           H  
ATOM   2138  HG3 LYS A 140      -3.866  66.603  24.678  1.00  0.00           H  
ATOM   2139  HD2 LYS A 140      -3.989  68.114  22.896  1.00  0.00           H  
ATOM   2140  HD3 LYS A 140      -5.145  67.145  22.004  1.00  0.00           H  
ATOM   2141  HE2 LYS A 140      -6.862  67.707  23.841  1.00  0.00           H  
ATOM   2142  HE3 LYS A 140      -5.700  68.861  24.466  1.00  0.00           H  
ATOM   2143  HZ1 LYS A 140      -7.426  69.160  22.309  1.00  0.00           H  
ATOM   2144  HZ2 LYS A 140      -6.402  70.262  22.945  1.00  0.00           H  
ATOM   2145  HZ3 LYS A 140      -5.897  69.278  21.744  1.00  0.00           H  
ATOM   2146  N   PRO A 141      -3.948  62.363  24.853  1.00  0.00           N  
ATOM   2147  CA  PRO A 141      -4.199  60.935  24.957  1.00  0.00           C  
ATOM   2148  C   PRO A 141      -5.154  60.465  23.859  1.00  0.00           C  
ATOM   2149  O   PRO A 141      -6.240  59.966  24.147  1.00  0.00           O  
ATOM   2150  CB  PRO A 141      -4.759  60.736  26.356  1.00  0.00           C  
ATOM   2151  CG  PRO A 141      -5.235  62.105  26.814  1.00  0.00           C  
ATOM   2152  CD  PRO A 141      -4.651  63.142  25.867  1.00  0.00           C  
ATOM   2153  HA  PRO A 141      -3.351  60.423  24.821  1.00  0.00           H  
ATOM   2154  HB2 PRO A 141      -5.580  60.020  26.350  1.00  0.00           H  
ATOM   2155  HB3 PRO A 141      -3.997  60.343  27.029  1.00  0.00           H  
ATOM   2156  HG2 PRO A 141      -6.323  62.153  26.807  1.00  0.00           H  
ATOM   2157  HG3 PRO A 141      -4.913  62.299  27.837  1.00  0.00           H  
ATOM   2158  HD2 PRO A 141      -5.434  63.757  25.422  1.00  0.00           H  
ATOM   2159  HD3 PRO A 141      -3.973  63.818  26.389  1.00  0.00           H  
ATOM   2160  N   ASN A 142      -4.713  60.640  22.621  1.00  0.00           N  
ATOM   2161  CA  ASN A 142      -5.515  60.240  21.478  1.00  0.00           C  
ATOM   2162  C   ASN A 142      -6.914  60.847  21.603  1.00  0.00           C  
ATOM   2163  O   ASN A 142      -7.807  60.243  22.196  1.00  0.00           O  
ATOM   2164  CB  ASN A 142      -5.664  58.719  21.415  1.00  0.00           C  
ATOM   2165  CG  ASN A 142      -5.658  58.226  19.967  1.00  0.00           C  
ATOM   2166  OD1 ASN A 142      -5.259  58.923  19.048  1.00  0.00           O  
ATOM   2167  ND2 ASN A 142      -6.123  56.989  19.813  1.00  0.00           N  
ATOM   2168  H   ASN A 142      -3.828  61.047  22.395  1.00  0.00           H  
ATOM   2169  HA  ASN A 142      -4.976  60.610  20.606  1.00  0.00           H  
ATOM   2170  HB2 ASN A 142      -4.850  58.247  21.966  1.00  0.00           H  
ATOM   2171  HB3 ASN A 142      -6.594  58.420  21.901  1.00  0.00           H  
ATOM   2172 HD21 ASN A 142      -6.437  56.471  20.609  1.00  0.00           H  
ATOM   2173 HD22 ASN A 142      -6.160  56.578  18.903  1.00  0.00           H  
ATOM   2174  N   SER A 143      -7.062  62.035  21.036  1.00  0.00           N  
ATOM   2175  CA  SER A 143      -8.337  62.731  21.077  1.00  0.00           C  
ATOM   2176  C   SER A 143      -8.719  63.038  22.526  1.00  0.00           C  
ATOM   2177  O   SER A 143      -8.481  62.227  23.420  1.00  0.00           O  
ATOM   2178  CB  SER A 143      -9.435  61.908  20.402  1.00  0.00           C  
ATOM   2179  OG  SER A 143     -10.644  62.649  20.253  1.00  0.00           O  
ATOM   2180  H   SER A 143      -6.331  62.520  20.555  1.00  0.00           H  
ATOM   2181  HA  SER A 143      -8.180  63.653  20.519  1.00  0.00           H  
ATOM   2182  HB2 SER A 143      -9.091  61.576  19.422  1.00  0.00           H  
ATOM   2183  HB3 SER A 143      -9.630  61.011  20.990  1.00  0.00           H  
ATOM   2184  HG  SER A 143     -10.784  62.886  19.293  1.00  0.00           H  
ATOM   2185  N   LEU A 144      -9.303  64.212  22.714  1.00  0.00           N  
ATOM   2186  CA  LEU A 144      -9.720  64.637  24.040  1.00  0.00           C  
ATOM   2187  C   LEU A 144      -8.555  64.463  25.016  1.00  0.00           C  
ATOM   2188  O   LEU A 144      -7.461  64.069  24.617  1.00  0.00           O  
ATOM   2189  CB  LEU A 144     -10.993  63.900  24.462  1.00  0.00           C  
ATOM   2190  CG  LEU A 144     -12.050  64.744  25.178  1.00  0.00           C  
ATOM   2191  CD1 LEU A 144     -12.865  65.566  24.178  1.00  0.00           C  
ATOM   2192  CD2 LEU A 144     -12.941  63.871  26.063  1.00  0.00           C  
ATOM   2193  H   LEU A 144      -9.493  64.866  21.982  1.00  0.00           H  
ATOM   2194  HA  LEU A 144      -9.966  65.697  23.981  1.00  0.00           H  
ATOM   2195  HB2 LEU A 144     -11.447  63.461  23.574  1.00  0.00           H  
ATOM   2196  HB3 LEU A 144     -10.711  63.076  25.117  1.00  0.00           H  
ATOM   2197  HG  LEU A 144     -11.539  65.449  25.833  1.00  0.00           H  
ATOM   2198 HD11 LEU A 144     -13.768  65.018  23.909  1.00  0.00           H  
ATOM   2199 HD12 LEU A 144     -13.139  66.520  24.629  1.00  0.00           H  
ATOM   2200 HD13 LEU A 144     -12.268  65.745  23.283  1.00  0.00           H  
ATOM   2201 HD21 LEU A 144     -12.319  63.206  26.662  1.00  0.00           H  
ATOM   2202 HD22 LEU A 144     -13.533  64.506  26.723  1.00  0.00           H  
ATOM   2203 HD23 LEU A 144     -13.607  63.278  25.436  1.00  0.00           H  
ATOM   2204  N   MET A 145      -8.831  64.766  26.276  1.00  0.00           N  
ATOM   2205  CA  MET A 145      -7.820  64.648  27.313  1.00  0.00           C  
ATOM   2206  C   MET A 145      -8.339  63.825  28.494  1.00  0.00           C  
ATOM   2207  O   MET A 145      -9.531  63.850  28.795  1.00  0.00           O  
ATOM   2208  CB  MET A 145      -7.420  66.042  27.797  1.00  0.00           C  
ATOM   2209  CG  MET A 145      -5.901  66.222  27.759  1.00  0.00           C  
ATOM   2210  SD  MET A 145      -5.477  67.628  26.746  1.00  0.00           S  
ATOM   2211  CE  MET A 145      -3.720  67.711  27.048  1.00  0.00           C  
ATOM   2212  H   MET A 145      -9.725  65.085  26.592  1.00  0.00           H  
ATOM   2213  HA  MET A 145      -6.980  64.133  26.845  1.00  0.00           H  
ATOM   2214  HB2 MET A 145      -7.895  66.799  27.172  1.00  0.00           H  
ATOM   2215  HB3 MET A 145      -7.782  66.196  28.813  1.00  0.00           H  
ATOM   2216  HG2 MET A 145      -5.518  66.363  28.769  1.00  0.00           H  
ATOM   2217  HG3 MET A 145      -5.430  65.322  27.361  1.00  0.00           H  
ATOM   2218  HE1 MET A 145      -3.198  67.896  26.109  1.00  0.00           H  
ATOM   2219  HE2 MET A 145      -3.508  68.519  27.747  1.00  0.00           H  
ATOM   2220  HE3 MET A 145      -3.380  66.765  27.471  1.00  0.00           H  
ATOM   2221  N   LEU A 146      -7.418  63.118  29.132  1.00  0.00           N  
ATOM   2222  CA  LEU A 146      -7.767  62.290  30.274  1.00  0.00           C  
ATOM   2223  C   LEU A 146      -6.489  61.844  30.985  1.00  0.00           C  
ATOM   2224  O   LEU A 146      -5.743  61.013  30.467  1.00  0.00           O  
ATOM   2225  CB  LEU A 146      -8.667  61.131  29.840  1.00  0.00           C  
ATOM   2226  CG  LEU A 146     -10.135  61.230  30.257  1.00  0.00           C  
ATOM   2227  CD1 LEU A 146     -11.038  60.491  29.266  1.00  0.00           C  
ATOM   2228  CD2 LEU A 146     -10.333  60.733  31.691  1.00  0.00           C  
ATOM   2229  H   LEU A 146      -6.450  63.104  28.880  1.00  0.00           H  
ATOM   2230  HA  LEU A 146      -8.346  62.908  30.960  1.00  0.00           H  
ATOM   2231  HB2 LEU A 146      -8.623  61.050  28.754  1.00  0.00           H  
ATOM   2232  HB3 LEU A 146      -8.256  60.207  30.246  1.00  0.00           H  
ATOM   2233  HG  LEU A 146     -10.427  62.280  30.236  1.00  0.00           H  
ATOM   2234 HD11 LEU A 146     -11.160  61.096  28.367  1.00  0.00           H  
ATOM   2235 HD12 LEU A 146     -10.583  59.536  29.003  1.00  0.00           H  
ATOM   2236 HD13 LEU A 146     -12.012  60.316  29.723  1.00  0.00           H  
ATOM   2237 HD21 LEU A 146     -10.301  61.580  32.376  1.00  0.00           H  
ATOM   2238 HD22 LEU A 146     -11.299  60.235  31.773  1.00  0.00           H  
ATOM   2239 HD23 LEU A 146      -9.539  60.031  31.945  1.00  0.00           H  
ATOM   2240  N   SER A 147      -6.274  62.415  32.161  1.00  0.00           N  
ATOM   2241  CA  SER A 147      -5.098  62.085  32.949  1.00  0.00           C  
ATOM   2242  C   SER A 147      -5.149  62.811  34.295  1.00  0.00           C  
ATOM   2243  O   SER A 147      -5.352  64.023  34.342  1.00  0.00           O  
ATOM   2244  CB  SER A 147      -3.814  62.446  32.199  1.00  0.00           C  
ATOM   2245  OG  SER A 147      -2.831  61.419  32.298  1.00  0.00           O  
ATOM   2246  H   SER A 147      -6.885  63.088  32.576  1.00  0.00           H  
ATOM   2247  HA  SER A 147      -5.141  61.006  33.095  1.00  0.00           H  
ATOM   2248  HB2 SER A 147      -4.046  62.628  31.149  1.00  0.00           H  
ATOM   2249  HB3 SER A 147      -3.409  63.376  32.601  1.00  0.00           H  
ATOM   2250  HG  SER A 147      -3.142  60.601  31.815  1.00  0.00           H  
ATOM   2251  N   GLY A 148      -4.962  62.039  35.355  1.00  0.00           N  
ATOM   2252  CA  GLY A 148      -4.985  62.594  36.698  1.00  0.00           C  
ATOM   2253  C   GLY A 148      -4.264  61.672  37.684  1.00  0.00           C  
ATOM   2254  O   GLY A 148      -4.861  60.740  38.218  1.00  0.00           O  
ATOM   2255  H   GLY A 148      -4.798  61.054  35.307  1.00  0.00           H  
ATOM   2256  HA2 GLY A 148      -4.510  63.575  36.698  1.00  0.00           H  
ATOM   2257  HA3 GLY A 148      -6.017  62.739  37.018  1.00  0.00           H  
ATOM   2258  N   PRO A 149      -2.955  61.975  37.901  1.00  0.00           N  
ATOM   2259  CA  PRO A 149      -2.146  61.185  38.813  1.00  0.00           C  
ATOM   2260  C   PRO A 149      -2.496  61.498  40.269  1.00  0.00           C  
ATOM   2261  O   PRO A 149      -3.394  62.295  40.537  1.00  0.00           O  
ATOM   2262  CB  PRO A 149      -0.707  61.527  38.461  1.00  0.00           C  
ATOM   2263  CG  PRO A 149      -0.768  62.834  37.688  1.00  0.00           C  
ATOM   2264  CD  PRO A 149      -2.214  63.072  37.286  1.00  0.00           C  
ATOM   2265  HA  PRO A 149      -2.336  60.210  38.690  1.00  0.00           H  
ATOM   2266  HB2 PRO A 149      -0.100  61.632  39.359  1.00  0.00           H  
ATOM   2267  HB3 PRO A 149      -0.254  60.738  37.860  1.00  0.00           H  
ATOM   2268  HG2 PRO A 149      -0.402  63.657  38.302  1.00  0.00           H  
ATOM   2269  HG3 PRO A 149      -0.129  62.786  36.806  1.00  0.00           H  
ATOM   2270  HD2 PRO A 149      -2.571  64.039  37.641  1.00  0.00           H  
ATOM   2271  HD3 PRO A 149      -2.330  63.069  36.201  1.00  0.00           H  
ATOM   2272  N   SER A 150      -1.768  60.857  41.170  1.00  0.00           N  
ATOM   2273  CA  SER A 150      -1.990  61.058  42.592  1.00  0.00           C  
ATOM   2274  C   SER A 150      -1.505  62.448  43.007  1.00  0.00           C  
ATOM   2275  O   SER A 150      -0.307  62.664  43.188  1.00  0.00           O  
ATOM   2276  CB  SER A 150      -1.283  59.981  43.418  1.00  0.00           C  
ATOM   2277  OG  SER A 150      -1.827  59.871  44.730  1.00  0.00           O  
ATOM   2278  H   SER A 150      -1.039  60.211  40.944  1.00  0.00           H  
ATOM   2279  HA  SER A 150      -3.067  60.972  42.731  1.00  0.00           H  
ATOM   2280  HB2 SER A 150      -1.367  59.021  42.909  1.00  0.00           H  
ATOM   2281  HB3 SER A 150      -0.220  60.216  43.485  1.00  0.00           H  
ATOM   2282  HG  SER A 150      -2.345  59.021  44.816  1.00  0.00           H  
ATOM   2283  N   SER A 151      -2.460  63.357  43.144  1.00  0.00           N  
ATOM   2284  CA  SER A 151      -2.144  64.721  43.533  1.00  0.00           C  
ATOM   2285  C   SER A 151      -2.680  65.002  44.939  1.00  0.00           C  
ATOM   2286  O   SER A 151      -3.426  64.196  45.494  1.00  0.00           O  
ATOM   2287  CB  SER A 151      -2.722  65.726  42.534  1.00  0.00           C  
ATOM   2288  OG  SER A 151      -1.699  66.413  41.817  1.00  0.00           O  
ATOM   2289  H   SER A 151      -3.431  63.174  42.995  1.00  0.00           H  
ATOM   2290  HA  SER A 151      -1.056  64.781  43.520  1.00  0.00           H  
ATOM   2291  HB2 SER A 151      -3.370  65.205  41.830  1.00  0.00           H  
ATOM   2292  HB3 SER A 151      -3.341  66.448  43.065  1.00  0.00           H  
ATOM   2293  HG  SER A 151      -0.903  65.819  41.702  1.00  0.00           H  
ATOM   2294  N   GLY A 152      -2.281  66.146  45.472  1.00  0.00           N  
ATOM   2295  CA  GLY A 152      -2.712  66.543  46.801  1.00  0.00           C  
ATOM   2296  C   GLY A 152      -1.522  66.990  47.653  1.00  0.00           C  
ATOM   2297  O   GLY A 152      -0.371  66.809  47.261  1.00  0.00           O  
ATOM   2298  H   GLY A 152      -1.674  66.796  45.012  1.00  0.00           H  
ATOM   2299  HA2 GLY A 152      -3.435  67.356  46.726  1.00  0.00           H  
ATOM   2300  HA3 GLY A 152      -3.218  65.709  47.287  1.00  0.00           H  
TER    2301      GLY A 152                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
