
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  118 (  906),  selected  118 , name 1s1h_L
# Molecule2: number of CA atoms  103 (  801),  selected  103 , name T0409.pdb
# PARAMETERS: 1s1h_L.T0409.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N    28_L      Y       1           -
LGA    Y    29_L      R       2           -
LGA    K    30_L      G       3           -
LGA    K    31_L      P       4           -
LGA    R    32_L      E       5           -
LGA    L    33_L      A       6           -
LGA    L    34_L      F       7           -
LGA    G    35_L      L       8           -
LGA    T    36_L      K       9           -
LGA    A    37_L      L      10           -
LGA    F    38_L      P      11           -
LGA    K    39_L      K      12           -
LGA    S    40_L      D      13           -
LGA    S    41_L      L      14           -
LGA    P    42_L      K      15           -
LGA    F    43_L      D      16           -
LGA    G    44_L      R      17           -
LGA    G    45_L      E      18           -
LGA    S    46_L      A      19           -
LGA    -       -      L      20           -
LGA    -       -      Q      21           -
LGA    -       -      D      22           -
LGA    -       -      I      23           -
LGA    -       -      M      24           -
LGA    -       -      Q      25           -
LGA    -       -      D      26           -
LGA    -       -      I      27           -
LGA    -       -      G      28           -
LGA    -       -      N      29           -
LGA    -       -      S      30           -
LGA    S    47_L      D      31          4.643
LGA    -       -      D      32           -
LGA    H    48_L      I      33          2.851
LGA    A    49_L      L      34          2.065
LGA    K    50_L      A      35          1.197
LGA    G    51_L      A      36          1.080
LGA    I    52_L      V      37          0.360
LGA    V    53_L      V      38          0.322
LGA    L    54_L      L      39          0.149
LGA    E    55_L      S      40          0.307
LGA    K    56_L      A      41          0.192
LGA    L    57_L      T      42          3.018
LGA    G    58_L      -       -           -
LGA    I    59_L      -       -           -
LGA    E    60_L      -       -           -
LGA    S    61_L      -       -           -
LGA    K    62_L      -       -           -
LGA    Q    63_L      -       -           -
LGA    P    64_L      -       -           -
LGA    N    65_L      -       -           -
LGA    S    66_L      -       -           -
LGA    A    67_L      -       -           -
LGA    I    68_L      P      43          5.520
LGA    R    69_L      G      44          2.885
LGA    K    70_L      -       -           -
LGA    C    71_L      A      45          2.017
LGA    V    72_L      V      46          0.872
LGA    R    73_L      E      47          0.628
LGA    V    74_L      A      48          0.732
LGA    Q    75_L      F      49          0.631
LGA    L    76_L      R      50          0.582
LGA    I    77_L      K      51          0.581
LGA    K    78_L      N      52          2.074
LGA    N    79_L      -       -           -
LGA    G    80_L      G      53          0.640
LGA    K    81_L      E      54          0.736
LGA    K    82_L      T      55          0.844
LGA    V    83_L      I      56          1.000
LGA    T    84_L      R      57          0.684
LGA    A    85_L      I      58          1.637
LGA    F    86_L      T      59          3.354
LGA    -       -      G      60           -
LGA    -       -      D      61           -
LGA    -       -      G      62           -
LGA    V    87_L      L      63          1.761
LGA    P    88_L      K      64          1.887
LGA    N    89_L      A      65          3.000
LGA    D    90_L      A      66           #
LGA    G    91_L      H      67          2.624
LGA    C    92_L      R      68          2.203
LGA    L    93_L      F      69          4.532
LGA    N    94_L      L      70          2.897
LGA    -       -      S      71           -
LGA    -       -      N      72           -
LGA    -       -      D      73           -
LGA    -       -      P      74           -
LGA    -       -      K      75           -
LGA    -       -      I      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      K      79           -
LGA    F    95_L      R      80          3.012
LGA    V    96_L      I      81          0.981
LGA    D    97_L      R      82          1.328
LGA    E    98_L      P      83          1.087
LGA    N    99_L      G      84          0.745
LGA    D   100_L      A      85          0.743
LGA    E   101_L      L      86          0.849
LGA    V   102_L      I      87          1.195
LGA    L   103_L      R      88          1.339
LGA    L   104_L      V      89          1.277
LGA    A   105_L      K      90          0.786
LGA    G   106_L      K      91          0.911
LGA    F   107_L      T      92          3.163
LGA    G   108_L      -       -           -
LGA    R   109_L      E      93          1.227
LGA    K   110_L      K      94          2.436
LGA    G   111_L      G      95          4.137
LGA    K   112_L      -       -           -
LGA    A   113_L      -       -           -
LGA    K   114_L      -       -           -
LGA    G   115_L      -       -           -
LGA    D   116_L      -       -           -
LGA    I   117_L      -       -           -
LGA    P   118_L      -       -           -
LGA    G   119_L      -       -           -
LGA    V   120_L      -       -           -
LGA    R   121_L      S      96          2.701
LGA    F   122_L      W      97          0.644
LGA    K   123_L      Q      98          0.802
LGA    V   124_L      I      99          1.056
LGA    V   125_L      V     100          0.713
LGA    K   126_L      -       -           -
LGA    V   127_L      -       -           -
LGA    S   128_L      -       -           -
LGA    G   129_L      Q     101          3.405
LGA    V   130_L      L     102          3.723
LGA    S   131_L      P     103           -
LGA    L   132_L      -       -           -
LGA    L   133_L      -       -           -
LGA    A   134_L      -       -           -
LGA    L   135_L      -       -           -
LGA    W   136_L      -       -           -
LGA    K   137_L      -       -           -
LGA    E   138_L      -       -           -
LGA    K   139_L      -       -           -
LGA    K   140_L      -       -           -
LGA    E   141_L      -       -           -
LGA    K   142_L      -       -           -
LGA    P   143_L      -       -           -
LGA    R   144_L      -       -           -
LGA    S   145_L      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  118  103    5.0     58    2.12    12.07     42.708     2.614

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.928805 * X  +  -0.318933 * Y  +  -0.188688 * Z  + -13.604949
  Y_new =  -0.060040 * X  +  -0.372939 * Y  +   0.925911 * Z  +  36.403797
  Z_new =  -0.365672 * X  +   0.871320 * Y  +   0.327239 * Z  + -34.152760 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.211528   -1.930064  [ DEG:    69.4155   -110.5845 ]
  Theta =   0.374355    2.767237  [ DEG:    21.4490    158.5510 ]
  Phi   =  -3.077040    0.064552  [ DEG:  -176.3014      3.6986 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1s1h_L                                        
REMARK     2: T0409.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1s1h_L.T0409.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  118  103   5.0   58   2.12   12.07  42.708
REMARK  ---------------------------------------------------------- 
MOLECULE 1s1h_L
HEADER    RIBOSOME                                06-JAN-04   1S1H              
TITLE     STRUCTURE OF THE RIBOSOMAL 80S-EEF2-SORDARIN COMPLEX FROM             
TITLE    2 YEAST OBTAINED BY DOCKING ATOMIC MODELS FOR RNA AND                  
TITLE    3 PROTEIN COMPONENTS INTO A 11.7 A CRYO-EM MAP. THIS FILE,             
TITLE    4 1S1H, CONTAINS 40S SUBUNIT. THE 60S RIBOSOMAL SUBUNIT IS             
TITLE    5 IN FILE 1S1I.                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 18S RIBOSOMAL RNA;                                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 OTHER_DETAILS: MODELLED AS ANALOGOUS MOLECULE OF T.                  
COMPND   5 THERMOPHILUS TAKEN FROM PDB ENTRY 1FJF;                              
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: ELONGATION FACTOR 2;                                       
COMPND   8 CHAIN: T;                                                            
COMPND   9 SYNONYM: EF-2;                                                       
COMPND  10 MOL_ID: 3;                                                           
COMPND  11 MOLECULE: 40S RIBOSOMAL PROTEIN S0-A;                                
COMPND  12 CHAIN: B;                                                            
COMPND  13 SYNONYM: NUCLEIC ACID-BINDING PROTEIN NAB1A;                         
COMPND  14 MOL_ID: 4;                                                           
COMPND  15 MOLECULE: 40S RIBOSOMAL PROTEIN S3;                                  
COMPND  16 CHAIN: C;                                                            
COMPND  17 SYNONYM: YS3, RP13;                                                  
COMPND  18 MOL_ID: 5;                                                           
COMPND  19 MOLECULE: 40S RIBOSOMAL PROTEIN S9-A;                                
COMPND  20 CHAIN: D;                                                            
COMPND  21 SYNONYM: S13, YS11, RP21, YP28;                                      
COMPND  22 MOL_ID: 6;                                                           
COMPND  23 MOLECULE: 40S RIBOSOMAL PROTEIN S2;                                  
COMPND  24 CHAIN: E;                                                            
COMPND  25 SYNONYM: S4, YS5, RP12, OMNIPOTENT SUPPRESSOR PROTEIN                
COMPND  26 SUP44;                                                               
COMPND  27 MOL_ID: 7;                                                           
COMPND  28 MOLECULE: 40S RIBOSOMAL PROTEIN S5;                                  
COMPND  29 CHAIN: G;                                                            
COMPND  30 SYNONYM: S2, YS8, RP14;                                              
COMPND  31 MOL_ID: 8;                                                           
COMPND  32 MOLECULE: 40S RIBOSOMAL PROTEIN S22;                                 
COMPND  33 CHAIN: H;                                                            
COMPND  34 SYNONYM: S24, YS22, RP50, YP58;                                      
COMPND  35 MOL_ID: 9;                                                           
COMPND  36 MOLECULE: 40S RIBOSOMAL PROTEIN S16;                                 
COMPND  37 CHAIN: I;                                                            
COMPND  38 SYNONYM: RP61R;                                                      
COMPND  39 MOL_ID: 10;                                                          
COMPND  40 MOLECULE: 40S RIBOSOMAL PROTEIN S20;                                 
COMPND  41 CHAIN: J;                                                            
COMPND  42 MOL_ID: 11;                                                          
COMPND  43 MOLECULE: 40S RIBOSOMAL PROTEIN S14-A;                               
COMPND  44 CHAIN: K;                                                            
COMPND  45 SYNONYM: RP59A;                                                      
COMPND  46 MOL_ID: 12;                                                          
COMPND  47 MOLECULE: 40S RIBOSOMAL PROTEIN S23;                                 
COMPND  48 CHAIN: L;                                                            
COMPND  49 SYNONYM: S28, YS14, RP37;                                            
COMPND  50 MOL_ID: 13;                                                          
COMPND  51 MOLECULE: 40S RIBOSOMAL PROTEIN S18;                                 
COMPND  52 CHAIN: M;                                                            
COMPND  53 MOL_ID: 14;                                                          
COMPND  54 MOLECULE: 40S RIBOSOMAL PROTEIN S29-B;                               
COMPND  55 CHAIN: N;                                                            
COMPND  56 SYNONYM: S36, YS29;                                                  
COMPND  57 MOL_ID: 15;                                                          
COMPND  58 MOLECULE: 40S RIBOSOMAL PROTEIN S13;                                 
COMPND  59 CHAIN: O;                                                            
COMPND  60 SYNONYM: S27A, YS15;                                                 
COMPND  61 MOL_ID: 16;                                                          
COMPND  62 MOLECULE: 40S RIBOSOMAL PROTEIN S11;                                 
COMPND  63 CHAIN: Q;                                                            
COMPND  64 SYNONYM: S18, YS12, RP41;                                            
COMPND  65 MOL_ID: 17;                                                          
COMPND  66 MOLECULE: 40S RIBOSOMAL PROTEIN S15;                                 
COMPND  67 CHAIN: S;                                                            
COMPND  68 SYNONYM: S21, YS21, RP52, RIG PROTEIN                                
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 MOL_ID: 2;                                                           
SOURCE   5 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   6 ORGANISM_COMMON: YEAST;                                              
SOURCE   7 MOL_ID: 3;                                                           
SOURCE   8 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   9 ORGANISM_COMMON: YEAST;                                              
SOURCE  10 MOL_ID: 4;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  12 ORGANISM_COMMON: YEAST;                                              
SOURCE  13 MOL_ID: 5;                                                           
SOURCE  14 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  15 ORGANISM_COMMON: YEAST;                                              
SOURCE  16 MOL_ID: 6;                                                           
SOURCE  17 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  18 ORGANISM_COMMON: YEAST;                                              
SOURCE  19 MOL_ID: 7;                                                           
SOURCE  20 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  21 ORGANISM_COMMON: YEAST;                                              
SOURCE  22 MOL_ID: 8;                                                           
SOURCE  23 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  24 ORGANISM_COMMON: YEAST;                                              
SOURCE  25 MOL_ID: 9;                                                           
SOURCE  26 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  27 ORGANISM_COMMON: YEAST;                                              
SOURCE  28 MOL_ID: 10;                                                          
SOURCE  29 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  30 ORGANISM_COMMON: YEAST;                                              
SOURCE  31 MOL_ID: 11;                                                          
SOURCE  32 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  33 ORGANISM_COMMON: YEAST;                                              
SOURCE  34 MOL_ID: 12;                                                          
SOURCE  35 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  36 ORGANISM_COMMON: YEAST;                                              
SOURCE  37 MOL_ID: 13;                                                          
SOURCE  38 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  39 ORGANISM_COMMON: YEAST;                                              
SOURCE  40 MOL_ID: 14;                                                          
SOURCE  41 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  42 ORGANISM_COMMON: YEAST;                                              
SOURCE  43 MOL_ID: 15;                                                          
SOURCE  44 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  45 ORGANISM_COMMON: YEAST;                                              
SOURCE  46 MOL_ID: 16;                                                          
SOURCE  47 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  48 ORGANISM_COMMON: YEAST;                                              
SOURCE  49 MOL_ID: 17;                                                          
SOURCE  50 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE  51 ORGANISM_COMMON: YEAST                                               
KEYWDS    80S RIBOSOME, 40S RIBOSOMAL SUBUNIT, EEF2, TRNA                       
KEYWDS   2 TRANSLOCATION, SORDARIN, CRYO-EM                                     
EXPDTA    CRYO-ELECTRON MICROSCOPY                                              
AUTHOR    C.M.SPAHN,M.G.GOMEZ-LORENZO,R.A.GRASSUCCI,R.JORGENSEN,                
AUTHOR   2 G.R.ANDERSEN,R.BECKMANN,P.A.PENCZEK,J.P.G.BALLESTA,J.FRANK           
REVDAT   1   25-MAY-04 1S1H    0                                                
JRNL        AUTH   C.M.SPAHN,M.G.GOMEZ-LORENZO,R.A.GRASSUCCI,                   
JRNL        AUTH 2 R.JORGENSEN,G.R.ANDERSEN,R.BECKMANN,P.A.PENCZEK,             
JRNL        AUTH 3 J.P.BALLESTA,J.FRANK                                         
JRNL        TITL   DOMAIN MOVEMENTS OF ELONGATION FACTOR EEF2 AND THE           
JRNL        TITL 2 EUKARYOTIC 80S RIBOSOME FACILITATE TRNA                      
JRNL        TITL 3 TRANSLOCATION.                                               
JRNL        REF    EMBO J.                       V.  23  1008 2004              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION.11.70 ANGSTROMS.                                          
DBREF  1S1H A    5  1511  GB     155076   M26923         651   2157             
DBREF  1S1H T    1   842  UNP    P32324   EF2_YEAST        1    842             
DBREF  1S1H B   13   197  UNP    P32905   RS0A_YEAST      13    197             
DBREF  1S1H C    1   192  UNP    P05750   RS3_YEAST        1    192             
DBREF  1S1H D   19   197  UNP    O13516   RS9A_YEAST      18    196             
DBREF  1S1H E   74   222  UNP    P25443   RS2_YEAST       74    222             
DBREF  1S1H G   75   224  UNP    P26783   RS5_YEAST       75    224             
DBREF  1S1H H    1   129  UNP    P04648   RS22_YEAST       1    129             
DBREF  1S1H I    1   142  UNP    P40213   RS16_YEAST       1    142             
DBREF  1S1H J   21   120  UNP    P38701   RS20_YEAST      21    121             
DBREF  1S1H K    1   136  UNP    P06367   R141_YEAST       1    136             
DBREF  1S1H L   28   145  UNP    P32827   RS23_YEAST      28    145             
DBREF  1S1H M   15   146  UNP    P35271   RS18_YEAST      15    146             
DBREF  1S1H N   20    55  UNP    P41058   R29B_YEAST      20     55             
DBREF  1S1H O   65   129  UNP    P05756   RS13_YEAST      65    129             
DBREF  1S1H Q   68   143  UNP    P26781   RS11_YEAST      68    143             
DBREF  1S1H S   47   126  UNP    Q01855   RS15_YEAST      47    126             
SEQRES   1 A 1507    U   G   G   A   G   A   G   U   U   U   G   A   U          
SEQRES   2 A 1507    C   C   U   G   G   C   U   C   A   G   G   G   U          
SEQRES   3 A 1507    G   A   A   C   G   C   U   G   G   C   G   G   C          
SEQRES   4 A 1507    G   U   G   C   C   U   A   A   G   A   C   A   U          
SEQRES   5 A 1507    G   C   A   A   G   U   C   G   U   G   C   G   G          
SEQRES   6 A 1507    G   C   C   G   C   G   G   G   G   U   U   U   U          
SEQRES   7 A 1507    A   C   U   C   C   G   U   G   G   U   C   A   G          
SEQRES   8 A 1507    C   G   G   C   G   G   A   C   G   G   G   U   G          
SEQRES   9 A 1507    A   G   U   A   A   C   G   C   G   U   G   G   G          
SEQRES  10 A 1507    U   G   A   C   C   U   A   C   C   C   G   G   A          
SEQRES  11 A 1507    A   G   A   G   G   G   G   G   A   C   A   A   C          
SEQRES  12 A 1507    C   C   G   G   G   G   A   A   A   C   U   C   G          
SEQRES  13 A 1507    G   G   C   U   A   A   U   C   C   C   C   C   A          
SEQRES  14 A 1507    U   G   U   G   G   A   C   C   C   G   C   C   C          
SEQRES  15 A 1507    C   U   U   G   G   G   G   U   G   U   G   U   C          
SEQRES  16 A 1507    C   A   A   A   G   G   G   C   U   U   U   G   C          
SEQRES  17 A 1507    C   C   G   C   U   U   C   C   G   G   A   U   G          
SEQRES  18 A 1507    G   G   C   C   C   G   C   G   U   C   C   C   A          
SEQRES  19 A 1507    U   C   A   G   C   U   A   G   U   U   G   G   U          
SEQRES  20 A 1507    G   G   G   G   U   A   A   U   G   G   C   C   C          
SEQRES  21 A 1507    A   C   C   A   A   G   G   C   G   A   C   G   A          
SEQRES  22 A 1507    C   G   G   G   U   A   G   C   C   G   G   U   C          
SEQRES  23 A 1507    U   G   A   G   A   G   G   A   U   G   G   C   C          
SEQRES  24 A 1507    G   G   C   C   A   C   A   G   G   G   G   C   A          
SEQRES  25 A 1507    C   U   G   A   G   A   C   A   C   G   G   G   C          
SEQRES  26 A 1507    C   C   C   A   C   U   C   C   U   A   C   G   G          
SEQRES  27 A 1507    G   A   G   G   C   A   G   C   A   G   U   U   A          
SEQRES  28 A 1507    G   G   A   A   U   C   U   U   C   C   G   C   A          
SEQRES  29 A 1507    A   U   G   G   G   C   G   C   A   A   G   C   C          
SEQRES  30 A 1507    U   G   A   C   G   G   A   G   C   G   A   C   G          
SEQRES  31 A 1507    C   C   G   C   U   U   G   G   A   G   G   A   A          
SEQRES  32 A 1507    G   A   A   G   C   C   C   U   U   C   G   G   G          
SEQRES  33 A 1507    G   U   G   U   A   A   A   C   U   C   C   U   G          
SEQRES  34 A 1507    A   A   C   C   C   G   G   G   A   C   G   A   A          
SEQRES  35 A 1507    A   C   C   C   C   C   G   A   C   G   A   G   G          
SEQRES  36 A 1507    G   G   A   C   U   G   A   C   G   G   U   A   C          
SEQRES  37 A 1507    C   G   G   G   G   U   A   A   U   A   G   C   G          
SEQRES  38 A 1507    C   C   G   G   C   C   A   A   C   U   C   C   G          
SEQRES  39 A 1507    U   G   C   C   A   G   C   A   G   C   C   G   C          
SEQRES  40 A 1507    G   G   U   A   A   U   A   C   G   G   A   G   G          
SEQRES  41 A 1507    G   C   G   C   G   A   G   C   G   U   U   A   C          
SEQRES  42 A 1507    C   C   G   G   A   U   U   C   A   C   U   G   G          
SEQRES  43 A 1507    G   C   G   U   A   A   A   G   G   G   C   G   U          
SEQRES  44 A 1507    G   U   A   G   G   C   G   G   C   C   U   G   G          
SEQRES  45 A 1507    G   G   C   G   U   C   C   C   A   U   G   U   G          
SEQRES  46 A 1507    A   A   A   G   A   C   C   A   C   G   G   C   U          
SEQRES  47 A 1507    C   A   A   C   C   G   U   G   G   G   G   G   A          
SEQRES  48 A 1507    G   C   G   U   G   G   G   A   U   A   C   G   C          
SEQRES  49 A 1507    U   C   A   G   G   C   U   A   G   A   C   G   G          
SEQRES  50 A 1507    U   G   G   G   A   G   A   G   G   G   U   G   G          
SEQRES  51 A 1507    U   G   G   A   A   U   U   C   C   C   G   G   A          
SEQRES  52 A 1507    G   U   A   G   C   G   G   U   G   A   A   A   U          
SEQRES  53 A 1507    G   C   G   C   A   G   A   U   A   C   C   G   G          
SEQRES  54 A 1507    G   A   G   G   A   A   C   G   C   C   G   A   U          
SEQRES  55 A 1507    G   G   C   G   A   A   G   G   C   A   G   C   C          
SEQRES  56 A 1507    A   C   C   U   G   G   U   C   C   A   C   C   C          
SEQRES  57 A 1507    G   U   G   A   C   G   C   U   G   A   G   G   C          
SEQRES  58 A 1507    G   C   G   A   A   A   G   C   G   U   G   G   G          
SEQRES  59 A 1507    G   A   G   C   A   A   A   C   C   G   G   A   U          
SEQRES  60 A 1507    U   A   G   A   U   A   C   C   C   G   G   G   U          
SEQRES  61 A 1507    A   G   U   C   C   A   C   G   C   C   C   U   A          
SEQRES  62 A 1507    A   A   C   G   A   U   G   C   G   C   G   C   U          
SEQRES  63 A 1507    A   G   G   U   C   U   C   U   G   G   G   U   C          
SEQRES  64 A 1507    U   C   C   U   G   G   G   G   G   C   C   G   A          
SEQRES  65 A 1507    A   G   C   U   A   A   C   G   C   G   U   U   A          
SEQRES  66 A 1507    A   G   C   G   C   G   C   C   G   C   C   U   G          
SEQRES  67 A 1507    G   G   G   A   G   U   A   C   G   G   C   C   G          
SEQRES  68 A 1507    C   A   A   G   G   C   U   G   A   A   A   C   U          
SEQRES  69 A 1507    C   A   A   A   G   G   A   A   U   U   G   A   C          
SEQRES  70 A 1507    G   G   G   G   G   C   C   C   G   C   A   C   A          
SEQRES  71 A 1507    A   G   C   G   G   U   G   G   A   G   C   A   U          
SEQRES  72 A 1507    G   U   G   G   U   U   U   A   A   U   U   C   G          
SEQRES  73 A 1507    A   A   G   C   A   A   C   G   C   G   A   A   G          
SEQRES  74 A 1507    A   A   C   C   U   U   A   C   C   A   G   G   C          
SEQRES  75 A 1507    C   U   U   G   A   C   A   U   G   C   U   A   G          
SEQRES  76 A 1507    G   G   A   A   C   C   C   G   G   G   U   G   A          
SEQRES  77 A 1507    A   A   G   C   C   U   G   G   G   G   U   G   C          
SEQRES  78 A 1507    C   C   C   G   C   G   A   G   G   G   G   A   G          
SEQRES  79 A 1507    C   C   C   U   A   G   C   A   C   A   G   G   U          
SEQRES  80 A 1507    G   C   U   G   C   A   U   G   G   C   C   G   U          
SEQRES  81 A 1507    C   G   U   C   A   G   C   U   C   G   U   G   C          
SEQRES  82 A 1507    C   G   U   G   A   G   G   U   G   U   U   G   G          
SEQRES  83 A 1507    G   U   U   A   A   G   U   C   C   C   G   C   A          
SEQRES  84 A 1507    A   C   G   A   G   C   G   C   A   A   C   C   C          
SEQRES  85 A 1507    C   C   G   C   C   G   U   U   A   G   U   U   G          
SEQRES  86 A 1507    C   C   A   G   C   G   G   U   U   C   G   G   C          
SEQRES  87 A 1507    C   G   G   G   C   A   C   U   C   U   A   A   C          
SEQRES  88 A 1507    G   G   G   A   C   U   G   C   C   C   G   C   G          
SEQRES  89 A 1507    A   A   A   G   C   G   G   G   A   G   G   A   A          
SEQRES  90 A 1507    G   G   A   G   G   G   G   A   C   G   A   C   G          
SEQRES  91 A 1507    U   C   U   G   G   U   C   A   G   C   A   U   G          
SEQRES  92 A 1507    G   C   C   C   U   U   A   C   G   G   C   C   U          
SEQRES  93 A 1507    G   G   G   C   G   A   C   A   C   A   C   G   U          
SEQRES  94 A 1507    G   C   U   A   C   A   A   U   G   C   C   C   A          
SEQRES  95 A 1507    C   U   A   C   A   A   A   G   C   G   A   U   G          
SEQRES  96 A 1507    C   C   A   C   C   C   G   G   C   A   A   C   G          
SEQRES  97 A 1507    G   G   G   A   G   C   U   A   A   U   C   G   C          
SEQRES  98 A 1507    A   A   A   A   A   G   G   U   G   G   G   C   C          
SEQRES  99 A 1507    C   A   G   U   U   C   G   G   A   U   U   G   G          
SEQRES  10 A 1507    G   G   U   C   U   G   C   A   A   C   C   C   G          
SEQRES  10 A 1507    A   C   C   C   C   A   U   G   A   A   G   C   C          
SEQRES  10 A 1507    G   G   A   A   U   C   G   C   U   A   G   U   A          
SEQRES  10 A 1507    A   U   C   G   C   G   G   A   U   C   A   G   C          
SEQRES  10 A 1507    C   A   U   G   C   C   G   C   G   G   U   G   A          
SEQRES  10 A 1507    A   U   A   C   G   U   U   C   C   C   G   G   G          
SEQRES  10 A 1507    C   C   U   U   G   U   A   C   A   C   A   C   C          
SEQRES  10 A 1507    G   C   C   C   G   U   C   A   C   G   C   C   A          
SEQRES  10 A 1507    U   G   G   G   A   G   C   G   G   G   C   U   C          
SEQRES  10 A 1507    U   A   C   C   C   G   A   A   G   U   C   G   C          
SEQRES  11 A 1507    C   G   G   G   A   G   C   C   U   A   C   G   G          
SEQRES  11 A 1507    G   C   A   G   G   C   G   C   C   G   A   G   G          
SEQRES  11 A 1507    G   U   A   G   G   G   C   C   C   G   U   G   A          
SEQRES  11 A 1507    C   U   G   G   G   G   C   G   A   A   G   U   C          
SEQRES  11 A 1507    G   U   A   A   C   A   A   G   G   U   A   G   C          
SEQRES  11 A 1507    U   G   U   A   C   C   G   G   A   A   G   G   U          
SEQRES  11 A 1507    G   C   G   G   C   U   G   G   A   U   C   A              
SEQRES   1 T  842  MET VAL ALA PHE THR VAL ASP GLN MET ARG SER LEU MET          
SEQRES   2 T  842  ASP LYS VAL THR ASN VAL ARG ASN MET SER VAL ILE ALA          
SEQRES   3 T  842  HIS VAL ASP HIS GLY LYS SER THR LEU THR ASP SER LEU          
SEQRES   4 T  842  VAL GLN ARG ALA GLY ILE ILE SER ALA ALA LYS ALA GLY          
SEQRES   5 T  842  GLU ALA ARG PHE THR ASP THR ARG LYS ASP GLU GLN GLU          
SEQRES   6 T  842  ARG GLY ILE THR ILE LYS SER THR ALA ILE SER LEU TYR          
SEQRES   7 T  842  SER GLU MET SER ASP GLU ASP VAL LYS GLU ILE LYS GLN          
SEQRES   8 T  842  LYS THR ASP GLY ASN SER PHE LEU ILE ASN LEU ILE ASP          
SEQRES   9 T  842  SER PRO GLY HIS VAL ASP PHE SER SER GLU VAL THR ALA          
SEQRES  10 T  842  ALA LEU ARG VAL THR ASP GLY ALA LEU VAL VAL VAL ASP          
SEQRES  11 T  842  THR ILE GLU GLY VAL CYS VAL GLN THR GLU THR VAL LEU          
SEQRES  12 T  842  ARG GLN ALA LEU GLY GLU ARG ILE LYS PRO VAL VAL VAL          
SEQRES  13 T  842  ILE ASN LYS VAL ASP ARG ALA LEU LEU GLU LEU GLN VAL          
SEQRES  14 T  842  SER LYS GLU ASP LEU TYR GLN THR PHE ALA ARG THR VAL          
SEQRES  15 T  842  GLU SER VAL ASN VAL ILE VAL SER THR TYR ALA ASP GLU          
SEQRES  16 T  842  VAL LEU GLY ASP VAL GLN VAL TYR PRO ALA ARG GLY THR          
SEQRES  17 T  842  VAL ALA PHE GLY SER GLY LEU HIS GLY TRP ALA PHE THR          
SEQRES  18 T  842  ILE ARG GLN PHE ALA THR ARG TYR ALA LYS LYS PHE GLY          
SEQRES  19 T  842  VAL ASP LYS ALA LYS MET MET ASP ARG LEU TRP GLY ASP          
SEQRES  20 T  842  SER PHE PHE ASN PRO LYS THR LYS LYS TRP THR ASN LYS          
SEQRES  21 T  842  ASP THR ASP ALA GLU GLY LYS PRO LEU GLU ARG ALA PHE          
SEQRES  22 T  842  ASN MET PHE ILE LEU ASP PRO ILE PHE ARG LEU PHE THR          
SEQRES  23 T  842  ALA ILE MET ASN PHE LYS LYS ASP GLU ILE PRO VAL LEU          
SEQRES  24 T  842  LEU GLU LYS LEU GLU ILE VAL LEU LYS GLY ASP GLU LYS          
SEQRES  25 T  842  ASP LEU GLU GLY LYS ALA LEU LEU LYS VAL VAL MET ARG          
SEQRES  26 T  842  LYS PHE LEU PRO ALA ALA ASP ALA LEU LEU GLU MET ILE          
SEQRES  27 T  842  VAL LEU HIS LEU PRO SER PRO VAL THR ALA GLN ALA TYR          
SEQRES  28 T  842  ARG ALA GLU GLN LEU TYR GLU GLY PRO ALA ASP ASP ALA          
SEQRES  29 T  842  ASN CYS ILE ALA ILE LYS ASN CYS ASP PRO LYS ALA ASP          
SEQRES  30 T  842  LEU MET LEU TYR VAL SER LYS MET VAL PRO THR SER ASP          
SEQRES  31 T  842  LYS GLY ARG PHE TYR ALA PHE GLY ARG VAL PHE ALA GLY          
SEQRES  32 T  842  THR VAL LYS SER GLY GLN LYS VAL ARG ILE GLN GLY PRO          
SEQRES  33 T  842  ASN TYR VAL PRO GLY LYS LYS ASP ASP LEU PHE ILE LYS          
SEQRES  34 T  842  ALA ILE GLN ARG VAL VAL LEU MET MET GLY ARG PHE VAL          
SEQRES  35 T  842  GLU PRO ILE ASP ASP CYS PRO ALA GLY ASN ILE ILE GLY          
SEQRES  36 T  842  LEU VAL GLY ILE ASP GLN PHE LEU LEU LYS THR GLY THR          
SEQRES  37 T  842  LEU THR THR SER GLU THR ALA HIS ASN MET LYS VAL MET          
SEQRES  38 T  842  LYS PHE SER VAL SER PRO VAL VAL GLN VAL ALA VAL GLU          
SEQRES  39 T  842  VAL LYS ASN ALA ASN ASP LEU PRO LYS LEU VAL GLU GLY          
SEQRES  40 T  842  LEU LYS ARG LEU SER LYS SER ASP PRO CYS VAL LEU THR          
SEQRES  41 T  842  TYR MET SER GLU SER GLY GLU HIS ILE VAL ALA GLY THR          
SEQRES  42 T  842  GLY GLU LEU HIS LEU GLU ILE CYS LEU GLN ASP LEU GLU          
SEQRES  43 T  842  HIS ASP HIS ALA GLY VAL PRO LEU LYS ILE SER PRO PRO          
SEQRES  44 T  842  VAL VAL ALA TYR ARG GLU THR VAL GLU SER GLU SER SER          
SEQRES  45 T  842  GLN THR ALA LEU SER LYS SER PRO ASN LYS HIS ASN ARG          
SEQRES  46 T  842  ILE TYR LEU LYS ALA GLU PRO ILE ASP GLU GLU VAL SER          
SEQRES  47 T  842  LEU ALA ILE GLU ASN GLY ILE ILE ASN PRO ARG ASP ASP          
SEQRES  48 T  842  PHE LYS ALA ARG ALA ARG ILE MET ALA ASP ASP TYR GLY          
SEQRES  49 T  842  TRP ASP VAL THR ASP ALA ARG LYS ILE TRP CYS PHE GLY          
SEQRES  50 T  842  PRO ASP GLY ASN GLY PRO ASN LEU VAL ILE ASP GLN THR          
SEQRES  51 T  842  LYS ALA VAL GLN TYR LEU HIS GLU ILE LYS ASP SER VAL          
SEQRES  52 T  842  VAL ALA ALA PHE GLN TRP ALA THR LYS GLU GLY PRO ILE          
SEQRES  53 T  842  PHE GLY GLU GLU MET ARG SER VAL ARG VAL ASN ILE LEU          
SEQRES  54 T  842  ASP VAL THR LEU HIS ALA ASP ALA ILE HIS ARG GLY GLY          
SEQRES  55 T  842  GLY GLN ILE ILE PRO THR MET ARG ARG ALA THR TYR ALA          
SEQRES  56 T  842  GLY PHE LEU LEU ALA ASP PRO LYS ILE GLN GLU PRO VAL          
SEQRES  57 T  842  PHE LEU VAL GLU ILE GLN CYS PRO GLU GLN ALA VAL GLY          
SEQRES  58 T  842  GLY ILE TYR SER VAL LEU ASN LYS LYS ARG GLY GLN VAL          
SEQRES  59 T  842  VAL SER GLU GLU GLN ARG PRO GLY THR PRO LEU PHE THR          
SEQRES  60 T  842  VAL LYS ALA TYR LEU PRO VAL ASN GLU SER PHE GLY PHE          
SEQRES  61 T  842  THR GLY GLU LEU ARG GLN ALA THR GLY GLY GLN ALA PHE          
SEQRES  62 T  842  PRO GLN MET VAL PHE ASP HIS TRP SER THR LEU GLY SER          
SEQRES  63 T  842  ASP PRO LEU ASP PRO THR SER LYS ALA GLY GLU ILE VAL          
SEQRES  64 T  842  LEU ALA ALA ARG LYS ARG HIS GLY MET LYS GLU GLU VAL          
SEQRES  65 T  842  PRO GLY TRP GLN GLU TYR TYR ASP LYS LEU                      
SEQRES   1 B  185  ALA GLN LEU LEU LEU ALA ALA ASN THR HIS LEU GLY ALA          
SEQRES   2 B  185  ARG ASN VAL GLN VAL HIS GLN GLU PRO TYR VAL PHE ASN          
SEQRES   3 B  185  ALA ARG PRO ASP GLY VAL HIS VAL ILE ASN VAL GLY LYS          
SEQRES   4 B  185  THR TRP GLU LYS LEU VAL LEU ALA ALA ARG ILE ILE ALA          
SEQRES   5 B  185  ALA ILE PRO ASN PRO GLU ASP VAL VAL ALA ILE SER SER          
SEQRES   6 B  185  ARG THR PHE GLY GLN ARG ALA VAL LEU LYS PHE ALA ALA          
SEQRES   7 B  185  HIS THR GLY ALA THR PRO ILE ALA GLY ARG PHE THR PRO          
SEQRES   8 B  185  GLY SER PHE THR ASN TYR ILE THR ARG SER PHE LYS GLU          
SEQRES   9 B  185  PRO ARG LEU VAL ILE VAL THR ASP PRO ARG SER ASP ALA          
SEQRES  10 B  185  GLN ALA ILE LYS GLU ALA SER TYR VAL ASN ILE PRO VAL          
SEQRES  11 B  185  ILE ALA LEU THR ASP LEU ASP SER PRO SER GLU PHE VAL          
SEQRES  12 B  185  ASP VAL ALA ILE PRO CYS ASN ASN ARG GLY LYS HIS SER          
SEQRES  13 B  185  ILE GLY LEU ILE TRP TYR LEU LEU ALA ARG GLU VAL LEU          
SEQRES  14 B  185  ARG LEU ARG GLY ALA LEU VAL ASP ARG THR GLN PRO TRP          
SEQRES  15 B  185  SER ILE MET                                                  
SEQRES   1 C  192  VAL ALA LEU ILE SER LYS LYS ARG LYS LEU VAL ALA ASP          
SEQRES   2 C  192  GLY VAL PHE TYR ALA GLU LEU ASN GLU PHE PHE THR ARG          
SEQRES   3 C  192  GLU LEU ALA GLU GLU GLY TYR SER GLY VAL GLU VAL ARG          
SEQRES   4 C  192  VAL THR PRO THR LYS THR GLU VAL ILE ILE ARG ALA THR          
SEQRES   5 C  192  ARG THR GLN ASP VAL LEU GLY GLU ASN GLY ARG ARG ILE          
SEQRES   6 C  192  ASN GLU LEU THR LEU LEU VAL GLN LYS ARG PHE LYS TYR          
SEQRES   7 C  192  ALA PRO GLY THR ILE VAL LEU TYR ALA GLU ARG VAL GLN          
SEQRES   8 C  192  ASP ARG GLY LEU SER ALA VAL ALA GLN ALA GLU SER MET          
SEQRES   9 C  192  LYS PHE LYS LEU LEU ASN GLY LEU ALA ILE ARG ARG ALA          
SEQRES  10 C  192  ALA TYR GLY VAL VAL ARG TYR VAL MET GLU SER GLY ALA          
SEQRES  11 C  192  LYS GLY CYS GLU VAL VAL VAL SER GLY LYS LEU ARG ALA          
SEQRES  12 C  192  ALA ARG ALA LYS ALA MET LYS PHE ALA ASP GLY PHE LEU          
SEQRES  13 C  192  ILE HIS SER GLY GLN PRO VAL ASN ASP PHE ILE ASP THR          
SEQRES  14 C  192  ALA THR ARG HIS VAL LEU MET ARG GLN GLY VAL LEU GLY          
SEQRES  15 C  192  ILE LYS VAL LYS ILE MET ARG ASP PRO ALA                      
SEQRES   1 D  179  TYR GLU SER SER ARG LEU ASP ALA GLU LEU LYS LEU ALA          
SEQRES   2 D  179  GLY GLU PHE GLY LEU LYS ASN LYS LYS GLU ILE TYR ARG          
SEQRES   3 D  179  ILE SER PHE GLN LEU SER LYS ILE ARG ARG ALA ALA ARG          
SEQRES   4 D  179  ASP LEU LEU THR ARG ASP GLU LYS ASP PRO LYS ARG LEU          
SEQRES   5 D  179  PHE GLU GLY ASN ALA LEU ILE ARG ARG LEU VAL ARG VAL          
SEQRES   6 D  179  GLY VAL LEU SER GLU ASP LYS LYS LYS LEU ASP TYR VAL          
SEQRES   7 D  179  LEU ALA LEU LYS VAL GLU ASP PHE LEU GLU ARG ARG LEU          
SEQRES   8 D  179  GLN THR GLN VAL TYR LYS LEU GLY LEU ALA LYS SER VAL          
SEQRES   9 D  179  HIS HIS ALA ARG VAL LEU ILE THR GLN ARG HIS ILE ALA          
SEQRES  10 D  179  VAL GLY LYS GLN ILE VAL ASN ILE PRO SER PHE MET VAL          
SEQRES  11 D  179  ARG LEU ASP SER GLU LYS HIS ILE ASP PHE ALA PRO THR          
SEQRES  12 D  179  SER PRO PHE GLY GLY ALA ARG PRO GLY ARG VAL ALA ARG          
SEQRES  13 D  179  ARG ASN ALA ALA ARG LYS ALA GLU ALA SER GLY GLU ALA          
SEQRES  14 D  179  ALA ASP GLU ALA ASP GLU ALA ASP GLU GLU                      
SEQRES   1 E  149  GLY LEU GLN ASP GLU VAL MET ASN ILE LYS PRO VAL GLN          
SEQRES   2 E  149  LYS GLN THR ARG ALA GLY GLN ARG THR ARG PHE LYS ALA          
SEQRES   3 E  149  VAL VAL VAL VAL GLY ASP SER ASN GLY HIS VAL GLY LEU          
SEQRES   4 E  149  GLY ILE LYS THR ALA LYS GLU VAL ALA GLY ALA ILE ARG          
SEQRES   5 E  149  ALA GLY ILE ILE ILE ALA LYS LEU SER VAL ILE PRO ILE          
SEQRES   6 E  149  ARG ARG GLY TYR TRP GLY THR ASN LEU GLY GLN PRO HIS          
SEQRES   7 E  149  SER LEU ALA THR LYS THR THR GLY LYS CYS GLY SER VAL          
SEQRES   8 E  149  THR VAL ARG LEU ILE PRO ALA PRO ARG GLY SER GLY ILE          
SEQRES   9 E  149  VAL ALA SER PRO ALA VAL LYS LYS LEU LEU GLN LEU ALA          
SEQRES  10 E  149  GLY VAL GLU ASP VAL TYR THR GLN SER ASN GLY LYS THR          
SEQRES  11 E  149  ARG THR LEU GLU ASN THR LEU LYS ALA ALA PHE VAL ALA          
SEQRES  12 E  149  ILE GLY ASN THR TYR GLY                                      
SEQRES   1 G  150  ARG TYR ALA ASN LYS ARG PHE ARG LYS ALA GLN CYS PRO          
SEQRES   2 G  150  ILE ILE GLU ARG LEU THR ASN SER LEU MET MET ASN GLY          
SEQRES   3 G  150  ARG ASN ASN GLY LYS LYS LEU LYS ALA VAL ARG ILE ILE          
SEQRES   4 G  150  LYS HIS THR LEU ASP ILE ILE ASN VAL LEU THR ASP GLN          
SEQRES   5 G  150  ASN PRO ILE GLN VAL VAL VAL ASP ALA ILE THR ASN THR          
SEQRES   6 G  150  GLY PRO ARG GLU ASP THR THR ARG VAL GLY GLY GLY GLY          
SEQRES   7 G  150  ALA ALA ARG ARG GLN ALA VAL ASP VAL SER PRO LEU ARG          
SEQRES   8 G  150  ARG VAL ASN GLN ALA ILE ALA LEU LEU THR ILE GLY ALA          
SEQRES   9 G  150  ARG GLU ALA ALA PHE ARG ASN ILE LYS THR ILE ALA GLU          
SEQRES  10 G  150  THR LEU ALA GLU GLU LEU ILE ASN ALA ALA LYS GLY SER          
SEQRES  11 G  150  SER THR SER TYR ALA ILE LYS LYS LYS ASP GLU LEU GLU          
SEQRES  12 G  150  ARG VAL ALA LYS SER ASN ARG                                  
SEQRES   1 H  129  THR ARG SER SER VAL LEU ALA ASP ALA LEU ASN ALA ILE          
SEQRES   2 H  129  ASN ASN ALA GLU LYS THR GLY LYS ARG GLN VAL LEU ILE          
SEQRES   3 H  129  ARG PRO SER SER LYS VAL ILE ILE LYS PHE LEU GLN VAL          
SEQRES   4 H  129  MET GLN LYS HIS GLY TYR ILE GLY GLU PHE GLU TYR ILE          
SEQRES   5 H  129  ASP ASP HIS ARG SER GLY LYS ILE VAL VAL GLN LEU ASN          
SEQRES   6 H  129  GLY ARG LEU ASN LYS CYS GLY VAL ILE SER PRO ARG PHE          
SEQRES   7 H  129  ASN VAL LYS ILE GLY ASP ILE GLU LYS TRP THR ALA ASN          
SEQRES   8 H  129  LEU LEU PRO ALA ARG GLN PHE GLY TYR VAL ILE LEU THR          
SEQRES   9 H  129  THR SER ALA GLY ILE MET ASP HIS GLU GLU ALA ARG ARG          
SEQRES  10 H  129  LYS HIS VAL SER GLY LYS ILE LEU GLY PHE VAL TYR              
SEQRES   1 I  142  SER ALA VAL PRO SER VAL GLN THR PHE GLY LYS LYS LYS          
SEQRES   2 I  142  SER ALA THR ALA VAL ALA HIS VAL LYS ALA GLY LYS GLY          
SEQRES   3 I  142  LEU ILE LYS VAL ASN GLY SER PRO ILE THR LEU VAL GLU          
SEQRES   4 I  142  PRO GLU ILE LEU ARG PHE LYS VAL TYR GLU PRO LEU LEU          
SEQRES   5 I  142  LEU VAL GLY LEU ASP LYS PHE SER ASN ILE ASP ILE ARG          
SEQRES   6 I  142  VAL ARG VAL THR GLY GLY GLY HIS VAL SER GLN VAL TYR          
SEQRES   7 I  142  ALA ILE ARG GLN ALA ILE ALA LYS GLY LEU VAL ALA TYR          
SEQRES   8 I  142  HIS GLN LYS TYR VAL ASP GLU GLN SER LYS ASN GLU LEU          
SEQRES   9 I  142  LYS LYS ALA PHE THR SER TYR ASP ARG THR LEU LEU ILE          
SEQRES  10 I  142  ALA ASP SER ARG ARG PRO GLU PRO LYS LYS PHE GLY GLY          
SEQRES  11 I  142  LYS GLY ALA ARG SER ARG PHE GLN LYS SER TYR ARG              
SEQRES   1 J  100  LYS ILE ARG ILE THR LEU THR SER THR LYS VAL LYS GLN          
SEQRES   2 J  100  LEU GLU ASN VAL SER SER ASN ILE VAL LYS ASN ALA GLU          
SEQRES   3 J  100  GLN HIS ASN LEU VAL LYS LYS GLY PRO VAL ARG LEU PRO          
SEQRES   4 J  100  THR LYS VAL LEU LYS ILE SER THR ARG LYS THR PRO ASN          
SEQRES   5 J  100  GLY GLU GLY SER LYS THR TRP GLU THR TYR GLU MET ARG          
SEQRES   6 J  100  ILE HIS LYS ARG TYR ILE ASP LEU GLU ALA PRO VAL GLN          
SEQRES   7 J  100  ILE VAL LYS ARG ILE THR GLN ILE THR ILE GLU PRO GLY          
SEQRES   8 J  100  VAL ASP VAL GLU VAL VAL ALA SER ASN                          
SEQRES   1 K  136  SER ASN VAL VAL GLN ALA ARG ASP ASN SER GLN VAL PHE          
SEQRES   2 K  136  GLY VAL ALA ARG ILE TYR ALA SER PHE ASN ASP THR PHE          
SEQRES   3 K  136  VAL HIS VAL THR ASP LEU SER GLY LYS GLU THR ILE ALA          
SEQRES   4 K  136  ARG VAL THR GLY GLY MET LYS VAL LYS ALA ASP ARG ASP          
SEQRES   5 K  136  GLU SER SER PRO TYR ALA ALA MET LEU ALA ALA GLN ASP          
SEQRES   6 K  136  VAL ALA ALA LYS CYS ARG GLU VAL GLY ILE THR ALA VAL          
SEQRES   7 K  136  HIS VAL LYS ILE ARG ALA THR GLY GLY THR ARG THR LYS          
SEQRES   8 K  136  THR PRO GLY PRO GLY GLY GLN ALA ALA LEU ARG ALA LEU          
SEQRES   9 K  136  ALA ARG SER GLY LEU ARG ILE GLY ARG ILE GLU ASP VAL          
SEQRES  10 K  136  THR PRO VAL PRO SER ASP SER THR ARG LYS LYS GLY GLY          
SEQRES  11 K  136  ARG ARG GLY ARG ARG LEU                                      
SEQRES   1 L  118  ASN TYR LYS LYS ARG LEU LEU GLY THR ALA PHE LYS SER          
SEQRES   2 L  118  SER PRO PHE GLY GLY SER SER HIS ALA LYS GLY ILE VAL          
SEQRES   3 L  118  LEU GLU LYS LEU GLY ILE GLU SER LYS GLN PRO ASN SER          
SEQRES   4 L  118  ALA ILE ARG LYS CYS VAL ARG VAL GLN LEU ILE LYS ASN          
SEQRES   5 L  118  GLY LYS LYS VAL THR ALA PHE VAL PRO ASN ASP GLY CYS          
SEQRES   6 L  118  LEU ASN PHE VAL ASP GLU ASN ASP GLU VAL LEU LEU ALA          
SEQRES   7 L  118  GLY PHE GLY ARG LYS GLY LYS ALA LYS GLY ASP ILE PRO          
SEQRES   8 L  118  GLY VAL ARG PHE LYS VAL VAL LYS VAL SER GLY VAL SER          
SEQRES   9 L  118  LEU LEU ALA LEU TRP LYS GLU LYS LYS GLU LYS PRO ARG          
SEQRES  10 L  118  SER                                                          
SEQRES   1 M  132  LEU ARG LEU LEU ASN THR ASN VAL ASP GLY ASN ILE LYS          
SEQRES   2 M  132  ILE VAL TYR ALA LEU THR THR ILE LYS GLY VAL GLY ARG          
SEQRES   3 M  132  ARG TYR SER ASN LEU VAL CYS LYS LYS ALA ASP VAL ASP          
SEQRES   4 M  132  LEU HIS LYS ARG ALA GLY GLU LEU THR GLN GLU GLU LEU          
SEQRES   5 M  132  GLU ARG ILE VAL GLN ILE MET GLN ASN PRO THR HIS TYR          
SEQRES   6 M  132  LYS ILE PRO ALA TRP PHE LEU ASN ARG GLN ASN ASP ILE          
SEQRES   7 M  132  THR ASP GLY LYS ASP TYR HIS THR LEU ALA ASN ASN VAL          
SEQRES   8 M  132  GLU SER LYS LEU ARG ASP ASP LEU GLU ARG LEU LYS LYS          
SEQRES   9 M  132  ILE ARG ALA HIS ARG GLY ILE ARG HIS PHE TRP GLY LEU          
SEQRES  10 M  132  ARG VAL ARG GLY GLN HIS THR LYS THR THR GLY ARG ARG          
SEQRES  11 M  132  ARG ALA                                                      
SEQRES   1 N   36  CYS ARG VAL CYS SER SER HIS THR GLY LEU VAL ARG LYS          
SEQRES   2 N   36  TYR ASP LEU ASN ILE CYS ARG GLN CYS PHE ARG GLU LYS          
SEQRES   3 N   36  ALA ASN ASP ILE GLY PHE HIS LYS TYR ARG                      
SEQRES   1 O   65  ILE THR GLY ASN LYS ILE MET ARG ILE LEU LYS SER ASN          
SEQRES   2 O   65  GLY LEU ALA PRO GLU ILE PRO GLU ASP LEU TYR TYR LEU          
SEQRES   3 O   65  ILE LYS LYS ALA VAL SER VAL ARG LYS HIS LEU GLU ARG          
SEQRES   4 O   65  ASN ARG LYS ASP LYS ASP ALA LYS PHE ARG LEU ILE LEU          
SEQRES   5 O   65  ILE GLU SER ARG ILE HIS ARG LEU ALA ARG TYR TYR ARG          
SEQRES   1 Q   76  LYS ILE LEU THR GLY THR VAL VAL SER THR LYS MET HIS          
SEQRES   2 Q   76  ARG THR ILE VAL ILE ARG ARG ALA TYR LEU HIS TYR ILE          
SEQRES   3 Q   76  PRO LYS TYR ASN ARG TYR GLU LYS ARG HIS LYS ASN VAL          
SEQRES   4 Q   76  PRO VAL HIS VAL SER PRO ALA PHE ARG VAL GLN VAL GLY          
SEQRES   5 Q   76  ASP ILE VAL THR VAL GLY GLN CYS ARG PRO ILE SER LYS          
SEQRES   6 Q   76  THR VAL ARG PHE ASN VAL VAL LYS VAL SER ALA                  
SEQRES   1 S   80  ARG GLY MET THR SER LYS PRO ALA GLY PHE MET LYS LYS          
SEQRES   2 S   80  LEU ARG ALA ALA LYS LEU ALA ALA PRO GLU ASN GLU LYS          
SEQRES   3 S   80  PRO ALA PRO VAL ARG THR HIS MET ARG ASN MET ILE ILE          
SEQRES   4 S   80  VAL PRO GLU MET ILE GLY SER VAL VAL GLY ILE TYR ASN          
SEQRES   5 S   80  GLY LYS ALA PHE ASN GLN VAL GLU ILE ARG PRO GLU MET          
SEQRES   6 S   80  LEU GLY HIS TYR LEU GLY GLU PHE SER ILE THR TYR THR          
SEQRES   7 S   80  PRO VAL                                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
ATOM  48285  N   ASN L  28     -13.216  34.018  27.136  1.00 54.49           N  
ATOM  48286  CA  ASN L  28     -13.246  33.443  28.501  1.00 54.49           C  
ATOM  48287  C   ASN L  28     -13.127  34.583  29.456  1.00 54.49           C  
ATOM  48288  O   ASN L  28     -13.090  35.742  29.048  1.00 54.49           O  
ATOM  48289  CB  ASN L  28     -12.050  32.485  28.686  1.00 54.49           C  
ATOM  48290  CG  ASN L  28     -12.318  31.505  29.824  1.00 54.49           C  
ATOM  48291  OD1 ASN L  28     -13.210  31.684  30.652  1.00 54.49           O  
ATOM  48292  ND2 ASN L  28     -11.512  30.411  29.864  1.00 54.49           N  
ATOM  48293  N   TYR L  29     -13.078  34.290  30.768  1.00 92.79           N  
ATOM  48294  CA  TYR L  29     -12.964  35.361  31.705  1.00 92.79           C  
ATOM  48295  C   TYR L  29     -11.649  36.007  31.420  1.00 92.79           C  
ATOM  48296  O   TYR L  29     -11.542  37.225  31.285  1.00 92.79           O  
ATOM  48297  CB  TYR L  29     -12.867  34.880  33.161  1.00 92.79           C  
ATOM  48298  CG  TYR L  29     -14.036  34.018  33.502  1.00 92.79           C  
ATOM  48299  CD1 TYR L  29     -13.971  32.662  33.279  1.00 92.79           C  
ATOM  48300  CD2 TYR L  29     -15.186  34.549  34.036  1.00 92.79           C  
ATOM  48301  CE1 TYR L  29     -15.030  31.844  33.594  1.00 92.79           C  
ATOM  48302  CE2 TYR L  29     -16.250  33.736  34.353  1.00 92.79           C  
ATOM  48303  CZ  TYR L  29     -16.172  32.382  34.128  1.00 92.79           C  
ATOM  48304  OH  TYR L  29     -17.262  31.545  34.452  1.00 92.79           O  
ATOM  48305  N   LYS L  30     -10.602  35.175  31.302  1.00 69.59           N  
ATOM  48306  CA  LYS L  30      -9.297  35.683  31.023  1.00 69.59           C  
ATOM  48307  C   LYS L  30      -8.818  34.917  29.843  1.00 69.59           C  
ATOM  48308  O   LYS L  30      -9.342  33.846  29.541  1.00 69.59           O  
ATOM  48309  CB  LYS L  30      -8.304  35.465  32.180  1.00 69.59           C  
ATOM  48310  CG  LYS L  30      -8.639  36.299  33.420  1.00 69.59           C  
ATOM  48311  CD  LYS L  30      -9.970  35.912  34.071  1.00 69.59           C  
ATOM  48312  CE  LYS L  30     -10.380  36.824  35.228  1.00 69.59           C  
ATOM  48313  NZ  LYS L  30     -11.771  36.527  35.643  1.00 69.59           N  
ATOM  48314  N   LYS L  31      -7.828  35.459  29.117  1.00 69.88           N  
ATOM  48315  CA  LYS L  31      -7.348  34.744  27.973  1.00 69.88           C  
ATOM  48316  C   LYS L  31      -6.612  33.552  28.477  1.00 69.88           C  
ATOM  48317  O   LYS L  31      -5.980  33.595  29.532  1.00 69.88           O  
ATOM  48318  CB  LYS L  31      -6.377  35.542  27.086  1.00 69.88           C  
ATOM  48319  CG  LYS L  31      -7.016  36.724  26.354  1.00 69.88           C  
ATOM  48320  CD  LYS L  31      -7.411  37.881  27.270  1.00 69.88           C  
ATOM  48321  CE  LYS L  31      -7.965  39.092  26.516  1.00 69.88           C  
ATOM  48322  NZ  LYS L  31      -8.337  40.166  27.469  1.00 69.88           N  
ATOM  48323  N   ARG L  32      -6.693  32.433  27.730  1.00157.08           N  
ATOM  48324  CA  ARG L  32      -6.015  31.244  28.143  1.00157.08           C  
ATOM  48325  C   ARG L  32      -4.761  31.155  27.340  1.00157.08           C  
ATOM  48326  O   ARG L  32      -4.787  31.264  26.115  1.00157.08           O  
ATOM  48327  CB  ARG L  32      -6.816  29.960  27.874  1.00157.08           C  
ATOM  48328  CG  ARG L  32      -8.114  29.864  28.676  1.00157.08           C  
ATOM  48329  CD  ARG L  32      -7.891  29.668  30.178  1.00157.08           C  
ATOM  48330  NE  ARG L  32      -7.112  28.411  30.361  1.00157.08           N  
ATOM  48331  CZ  ARG L  32      -6.874  27.932  31.619  1.00157.08           C  
ATOM  48332  NH1 ARG L  32      -7.368  28.595  32.707  1.00157.08           N  
ATOM  48333  NH2 ARG L  32      -6.131  26.801  31.795  1.00157.08           N  
ATOM  48334  N   LEU L  33      -3.621  30.982  28.029  1.00 77.66           N  
ATOM  48335  CA  LEU L  33      -2.360  30.876  27.353  1.00 77.66           C  
ATOM  48336  C   LEU L  33      -2.113  29.441  27.012  1.00 77.66           C  
ATOM  48337  O   LEU L  33      -2.722  28.537  27.584  1.00 77.66           O  
ATOM  48338  CB  LEU L  33      -1.171  31.395  28.173  1.00 77.66           C  
ATOM  48339  CG  LEU L  33      -1.241  32.915  28.414  1.00 77.66           C  
ATOM  48340  CD1 LEU L  33      -1.113  33.685  27.092  1.00 77.66           C  
ATOM  48341  CD2 LEU L  33      -2.500  33.297  29.208  1.00 77.66           C  
ATOM  48342  N   LEU L  34      -1.206  29.208  26.041  1.00 95.64           N  
ATOM  48343  CA  LEU L  34      -0.884  27.887  25.590  1.00 95.64           C  
ATOM  48344  C   LEU L  34      -0.102  27.250  26.702  1.00 95.64           C  
ATOM  48345  O   LEU L  34       0.741  27.893  27.322  1.00 95.64           O  
ATOM  48346  CB  LEU L  34      -0.015  27.929  24.315  1.00 95.64           C  
ATOM  48347  CG  LEU L  34       0.091  26.629  23.486  1.00 95.64           C  
ATOM  48348  CD1 LEU L  34       1.089  26.801  22.332  1.00 95.64           C  
ATOM  48349  CD2 LEU L  34       0.368  25.384  24.330  1.00 95.64           C  
ATOM  48350  N   GLY L  35      -0.369  25.961  26.994  1.00 24.70           N  
ATOM  48351  CA  GLY L  35       0.292  25.304  28.087  1.00 24.70           C  
ATOM  48352  C   GLY L  35       1.508  24.607  27.578  1.00 24.70           C  
ATOM  48353  O   GLY L  35       1.982  24.858  26.473  1.00 24.70           O  
ATOM  48354  N   THR L  36       2.067  23.701  28.402  1.00 89.40           N  
ATOM  48355  CA  THR L  36       3.229  22.981  27.979  1.00 89.40           C  
ATOM  48356  C   THR L  36       2.776  21.855  27.116  1.00 89.40           C  
ATOM  48357  O   THR L  36       1.668  21.343  27.268  1.00 89.40           O  
ATOM  48358  CB  THR L  36       4.026  22.406  29.111  1.00 89.40           C  
ATOM  48359  OG1 THR L  36       3.223  21.509  29.867  1.00 89.40           O  
ATOM  48360  CG2 THR L  36       4.527  23.559  29.994  1.00 89.40           C  
ATOM  48361  N   ALA L  37       3.631  21.452  26.161  1.00 28.87           N  
ATOM  48362  CA  ALA L  37       3.270  20.376  25.297  1.00 28.87           C  
ATOM  48363  C   ALA L  37       4.269  19.289  25.511  1.00 28.87           C  
ATOM  48364  O   ALA L  37       5.433  19.549  25.810  1.00 28.87           O  
ATOM  48365  CB  ALA L  37       3.309  20.751  23.805  1.00 28.87           C  
ATOM  48366  N   PHE L  38       3.823  18.025  25.382  1.00112.88           N  
ATOM  48367  CA  PHE L  38       4.727  16.932  25.569  1.00112.88           C  
ATOM  48368  C   PHE L  38       5.662  16.918  24.408  1.00112.88           C  
ATOM  48369  O   PHE L  38       5.318  17.346  23.307  1.00112.88           O  
ATOM  48370  CB  PHE L  38       4.037  15.567  25.711  1.00112.88           C  
ATOM  48371  CG  PHE L  38       3.323  15.633  27.018  1.00112.88           C  
ATOM  48372  CD1 PHE L  38       3.962  15.265  28.182  1.00112.88           C  
ATOM  48373  CD2 PHE L  38       2.026  16.086  27.082  1.00112.88           C  
ATOM  48374  CE1 PHE L  38       3.308  15.335  29.389  1.00112.88           C  
ATOM  48375  CE2 PHE L  38       1.370  16.156  28.289  1.00112.88           C  
ATOM  48376  CZ  PHE L  38       2.008  15.780  29.444  1.00112.88           C  
ATOM  48377  N   LYS L  39       6.909  16.496  24.678  1.00113.91           N  
ATOM  48378  CA  LYS L  39       7.965  16.481  23.708  1.00113.91           C  
ATOM  48379  C   LYS L  39       7.727  15.433  22.671  1.00113.91           C  
ATOM  48380  O   LYS L  39       8.017  15.634  21.491  1.00113.91           O  
ATOM  48381  CB  LYS L  39       9.343  16.235  24.347  1.00113.91           C  
ATOM  48382  CG  LYS L  39       9.704  17.311  25.374  1.00113.91           C  
ATOM  48383  CD  LYS L  39       9.716  18.735  24.802  1.00113.91           C  
ATOM  48384  CE  LYS L  39       9.844  19.822  25.869  1.00113.91           C  
ATOM  48385  NZ  LYS L  39       9.730  21.157  25.241  1.00113.91           N  
ATOM  48386  N   SER L  40       7.216  14.261  23.077  1.00 79.15           N  
ATOM  48387  CA  SER L  40       7.021  13.257  22.077  1.00 79.15           C  
ATOM  48388  C   SER L  40       5.630  12.784  22.226  1.00 79.15           C  
ATOM  48389  O   SER L  40       5.243  12.421  23.329  1.00 79.15           O  
ATOM  48390  CB  SER L  40       7.931  12.034  22.265  1.00 79.15           C  
ATOM  48391  OG  SER L  40       9.293  12.410  22.103  1.00 79.15           O  
ATOM  48392  N   SER L  41       4.854  12.799  21.123  1.00127.23           N  
ATOM  48393  CA  SER L  41       3.534  12.271  21.208  1.00127.23           C  
ATOM  48394  C   SER L  41       3.575  10.976  20.481  1.00127.23           C  
ATOM  48395  O   SER L  41       3.073  10.840  19.366  1.00127.23           O  
ATOM  48396  CB  SER L  41       2.474  13.161  20.533  1.00127.23           C  
ATOM  48397  OG  SER L  41       2.376  14.393  21.233  1.00127.23           O  
ATOM  48398  N   PRO L  42       4.156   9.994  21.127  1.00173.30           N  
ATOM  48399  CA  PRO L  42       4.234   8.660  20.615  1.00173.30           C  
ATOM  48400  C   PRO L  42       2.849   8.104  20.813  1.00173.30           C  
ATOM  48401  O   PRO L  42       2.667   6.908  20.605  1.00173.30           O  
ATOM  48402  CB  PRO L  42       5.187   7.946  21.556  1.00173.30           C  
ATOM  48403  CG  PRO L  42       4.816   8.555  22.919  1.00173.30           C  
ATOM  48404  CD  PRO L  42       4.282   9.957  22.575  1.00173.30           C  
ATOM  48405  N   PHE L  43       1.905   8.929  21.314  1.00172.71           N  
ATOM  48406  CA  PHE L  43       0.559   8.612  21.620  1.00172.71           C  
ATOM  48407  C   PHE L  43       0.595   7.599  22.710  1.00172.71           C  
ATOM  48408  O   PHE L  43       1.558   6.851  22.876  1.00172.71           O  
ATOM  48409  CB  PHE L  43      -0.262   8.088  20.430  1.00172.71           C  
ATOM  48410  CG  PHE L  43      -1.696   8.212  20.818  1.00172.71           C  
ATOM  48411  CD1 PHE L  43      -2.327   7.228  21.541  1.00172.71           C  
ATOM  48412  CD2 PHE L  43      -2.406   9.331  20.446  1.00172.71           C  
ATOM  48413  CE1 PHE L  43      -3.648   7.360  21.898  1.00172.71           C  
ATOM  48414  CE2 PHE L  43      -3.727   9.470  20.799  1.00172.71           C  
ATOM  48415  CZ  PHE L  43      -4.351   8.482  21.524  1.00172.71           C  
ATOM  48416  N   GLY L  44      -0.414   7.632  23.583  1.00 36.67           N  
ATOM  48417  CA  GLY L  44      -0.478   6.643  24.611  1.00 36.67           C  
ATOM  48418  C   GLY L  44       0.605   6.907  25.609  1.00 36.67           C  
ATOM  48419  O   GLY L  44       0.705   6.193  26.606  1.00 36.67           O  
ATOM  48420  N   GLY L  45       1.452   7.929  25.364  1.00 27.90           N  
ATOM  48421  CA  GLY L  45       2.512   8.220  26.281  1.00 27.90           C  
ATOM  48422  C   GLY L  45       3.316   6.967  26.392  1.00 27.90           C  
ATOM  48423  O   GLY L  45       3.899   6.677  27.436  1.00 27.90           O  
ATOM  48424  N   SER L  46       3.349   6.177  25.299  1.00 79.93           N  
ATOM  48425  CA  SER L  46       4.038   4.916  25.337  1.00 79.93           C  
ATOM  48426  C   SER L  46       5.513   5.130  25.269  1.00 79.93           C  
ATOM  48427  O   SER L  46       6.004   6.195  24.893  1.00 79.93           O  
ATOM  48428  CB  SER L  46       3.662   3.964  24.189  1.00 79.93           C  
ATOM  48429  OG  SER L  46       4.390   2.748  24.299  1.00 79.93           O  
ATOM  48430  N   SER L  47       6.256   4.094  25.708  1.00 76.32           N  
ATOM  48431  CA  SER L  47       7.686   4.103  25.682  1.00 76.32           C  
ATOM  48432  C   SER L  47       8.147   4.004  24.262  1.00 76.32           C  
ATOM  48433  O   SER L  47       9.098   4.680  23.872  1.00 76.32           O  
ATOM  48434  CB  SER L  47       8.313   2.930  26.457  1.00 76.32           C  
ATOM  48435  OG  SER L  47       9.730   3.004  26.378  1.00 76.32           O  
ATOM  48436  N   HIS L  48       7.490   3.151  23.447  1.00 89.74           N  
ATOM  48437  CA  HIS L  48       7.894   2.990  22.074  1.00 89.74           C  
ATOM  48438  C   HIS L  48       6.682   2.820  21.219  1.00 89.74           C  
ATOM  48439  O   HIS L  48       5.603   2.468  21.696  1.00 89.74           O  
ATOM  48440  CB  HIS L  48       8.760   1.741  21.798  1.00 89.74           C  
ATOM  48441  CG  HIS L  48      10.233   1.941  21.984  1.00 89.74           C  
ATOM  48442  ND1 HIS L  48      10.864   2.082  23.200  1.00 89.74           N  
ATOM  48443  CD2 HIS L  48      11.218   2.011  21.048  1.00 89.74           C  
ATOM  48444  CE1 HIS L  48      12.186   2.229  22.942  1.00 89.74           C  
ATOM  48445  NE2 HIS L  48      12.451   2.192  21.646  1.00 89.74           N  
ATOM  48446  N   ALA L  49       6.845   3.097  19.909  1.00 48.85           N  
ATOM  48447  CA  ALA L  49       5.794   2.918  18.955  1.00 48.85           C  
ATOM  48448  C   ALA L  49       6.430   2.399  17.703  1.00 48.85           C  
ATOM  48449  O   ALA L  49       7.555   2.773  17.378  1.00 48.85           O  
ATOM  48450  CB  ALA L  49       5.078   4.230  18.584  1.00 48.85           C  
ATOM  48451  N   LYS L  50       5.709   1.529  16.963  1.00 70.52           N  
ATOM  48452  CA  LYS L  50       6.249   0.947  15.768  1.00 70.52           C  
ATOM  48453  C   LYS L  50       5.536   1.548  14.597  1.00 70.52           C  
ATOM  48454  O   LYS L  50       4.342   1.833  14.659  1.00 70.52           O  
ATOM  48455  CB  LYS L  50       6.041  -0.572  15.696  1.00 70.52           C  
ATOM  48456  CG  LYS L  50       4.562  -0.971  15.638  1.00 70.52           C  
ATOM  48457  CD  LYS L  50       4.333  -2.423  15.220  1.00 70.52           C  
ATOM  48458  CE  LYS L  50       2.855  -2.795  15.073  1.00 70.52           C  
ATOM  48459  NZ  LYS L  50       2.738  -4.218  14.676  1.00 70.52           N  
ATOM  48460  N   GLY L  51       6.259   1.760  13.481  1.00 25.67           N  
ATOM  48461  CA  GLY L  51       5.636   2.346  12.330  1.00 25.67           C  
ATOM  48462  C   GLY L  51       6.263   1.744  11.114  1.00 25.67           C  
ATOM  48463  O   GLY L  51       7.135   0.882  11.219  1.00 25.67           O  
ATOM  48464  N   ILE L  52       5.823   2.193   9.919  1.00132.86           N  
ATOM  48465  CA  ILE L  52       6.360   1.687   8.687  1.00132.86           C  
ATOM  48466  C   ILE L  52       7.052   2.817   7.992  1.00132.86           C  
ATOM  48467  O   ILE L  52       6.591   3.957   8.027  1.00132.86           O  
ATOM  48468  CB  ILE L  52       5.314   1.097   7.770  1.00132.86           C  
ATOM  48469  CG1 ILE L  52       4.249   2.134   7.353  1.00132.86           C  
ATOM  48470  CG2 ILE L  52       4.727  -0.130   8.487  1.00132.86           C  
ATOM  48471  CD1 ILE L  52       4.687   3.107   6.255  1.00132.86           C  
ATOM  48472  N   VAL L  53       8.209   2.536   7.359  1.00 66.56           N  
ATOM  48473  CA  VAL L  53       8.937   3.593   6.713  1.00 66.56           C  
ATOM  48474  C   VAL L  53       8.236   3.974   5.445  1.00 66.56           C  
ATOM  48475  O   VAL L  53       7.696   3.117   4.758  1.00 66.56           O  
ATOM  48476  CB  VAL L  53      10.352   3.227   6.361  1.00 66.56           C  
ATOM  48477  CG1 VAL L  53      10.991   4.410   5.609  1.00 66.56           C  
ATOM  48478  CG2 VAL L  53      11.095   2.834   7.651  1.00 66.56           C  
ATOM  48479  N   LEU L  54       8.040   5.295   5.218  1.00134.21           N  
ATOM  48480  CA  LEU L  54       7.600   5.803   3.947  1.00134.21           C  
ATOM  48481  C   LEU L  54       8.752   6.040   3.019  1.00134.21           C  
ATOM  48482  O   LEU L  54       8.749   5.604   1.868  1.00134.21           O  
ATOM  48483  CB  LEU L  54       6.829   7.136   4.039  1.00134.21           C  
ATOM  48484  CG  LEU L  54       5.429   7.022   4.667  1.00134.21           C  
ATOM  48485  CD1 LEU L  54       4.726   8.391   4.698  1.00134.21           C  
ATOM  48486  CD2 LEU L  54       4.588   5.942   3.970  1.00134.21           C  
ATOM  48487  N   GLU L  55       9.784   6.756   3.522  1.00115.93           N  
ATOM  48488  CA  GLU L  55      10.878   7.121   2.671  1.00115.93           C  
ATOM  48489  C   GLU L  55      12.120   7.275   3.488  1.00115.93           C  
ATOM  48490  O   GLU L  55      12.094   7.774   4.615  1.00115.93           O  
ATOM  48491  CB  GLU L  55      10.627   8.423   1.888  1.00115.93           C  
ATOM  48492  CG  GLU L  55      10.376   9.653   2.765  1.00115.93           C  
ATOM  48493  CD  GLU L  55      10.044  10.807   1.828  1.00115.93           C  
ATOM  48494  OE1 GLU L  55      10.130  10.606   0.586  1.00115.93           O  
ATOM  48495  OE2 GLU L  55       9.691  11.905   2.337  1.00115.93           O  
ATOM  48496  N   LYS L  56      13.253   6.825   2.914  1.00206.88           N  
ATOM  48497  CA  LYS L  56      14.527   6.901   3.560  1.00206.88           C  
ATOM  48498  C   LYS L  56      15.248   8.073   2.967  1.00206.88           C  
ATOM  48499  O   LYS L  56      16.142   7.903   2.141  1.00206.88           O  
ATOM  48500  CB  LYS L  56      15.391   5.667   3.250  1.00206.88           C  
ATOM  48501  CG  LYS L  56      16.776   5.689   3.890  1.00206.88           C  
ATOM  48502  CD  LYS L  56      17.557   4.389   3.676  1.00206.88           C  
ATOM  48503  CE  LYS L  56      17.907   4.125   2.209  1.00206.88           C  
ATOM  48504  NZ  LYS L  56      18.586   2.815   2.063  1.00206.88           N  
ATOM  48505  N   LEU L  57      14.900   9.285   3.426  1.00 83.55           N  
ATOM  48506  CA  LEU L  57      15.423  10.532   2.943  1.00 83.55           C  
ATOM  48507  C   LEU L  57      16.755  10.760   3.581  1.00 83.55           C  
ATOM  48508  O   LEU L  57      17.267   9.909   4.302  1.00 83.55           O  
ATOM  48509  CB  LEU L  57      14.561  11.737   3.352  1.00 83.55           C  
ATOM  48510  CG  LEU L  57      13.109  11.705   2.848  1.00 83.55           C  
ATOM  48511  CD1 LEU L  57      12.343  12.962   3.294  1.00 83.55           C  
ATOM  48512  CD2 LEU L  57      13.045  11.472   1.333  1.00 83.55           C  
ATOM  48513  N   GLY L  58      17.378  11.911   3.258  1.00 44.94           N  
ATOM  48514  CA  GLY L  58      18.608  12.313   3.884  1.00 44.94           C  
ATOM  48515  C   GLY L  58      18.532  13.803   4.025  1.00 44.94           C  
ATOM  48516  O   GLY L  58      18.390  14.530   3.042  1.00 44.94           O  
ATOM  48517  N   ILE L  59      18.684  14.316   5.257  1.00103.31           N  
ATOM  48518  CA  ILE L  59      18.524  15.730   5.437  1.00103.31           C  
ATOM  48519  C   ILE L  59      19.844  16.293   5.838  1.00103.31           C  
ATOM  48520  O   ILE L  59      20.732  15.562   6.276  1.00103.31           O  
ATOM  48521  CB  ILE L  59      17.532  16.091   6.502  1.00103.31           C  
ATOM  48522  CG1 ILE L  59      18.002  15.589   7.876  1.00103.31           C  
ATOM  48523  CG2 ILE L  59      16.165  15.528   6.086  1.00103.31           C  
ATOM  48524  CD1 ILE L  59      17.155  16.125   9.025  1.00103.31           C  
ATOM  48525  N   GLU L  60      20.032  17.611   5.626  1.00 91.08           N  
ATOM  48526  CA  GLU L  60      21.282  18.211   5.993  1.00 91.08           C  
ATOM  48527  C   GLU L  60      21.114  18.896   7.308  1.00 91.08           C  
ATOM  48528  O   GLU L  60      20.001  19.177   7.747  1.00 91.08           O  
ATOM  48529  CB  GLU L  60      21.845  19.242   4.993  1.00 91.08           C  
ATOM  48530  CG  GLU L  60      20.994  20.497   4.788  1.00 91.08           C  
ATOM  48531  CD  GLU L  60      21.771  21.404   3.840  1.00 91.08           C  
ATOM  48532  OE1 GLU L  60      23.018  21.245   3.764  1.00 91.08           O  
ATOM  48533  OE2 GLU L  60      21.133  22.264   3.177  1.00 91.08           O  
ATOM  48534  N   SER L  61      22.246  19.171   7.980  1.00 96.40           N  
ATOM  48535  CA  SER L  61      22.212  19.742   9.295  1.00 96.40           C  
ATOM  48536  C   SER L  61      21.922  21.211   9.212  1.00 96.40           C  
ATOM  48537  O   SER L  61      21.659  21.752   8.143  1.00 96.40           O  
ATOM  48538  CB  SER L  61      23.507  19.518  10.097  1.00 96.40           C  
ATOM  48539  OG  SER L  61      23.302  19.886  11.452  1.00 96.40           O  
ATOM  48540  N   LYS L  62      21.911  21.883  10.385  1.00126.20           N  
ATOM  48541  CA  LYS L  62      21.618  23.285  10.478  1.00126.20           C  
ATOM  48542  C   LYS L  62      22.792  23.942  11.121  1.00126.20           C  
ATOM  48543  O   LYS L  62      23.739  23.271  11.523  1.00126.20           O  
ATOM  48544  CB  LYS L  62      20.365  23.604  11.324  1.00126.20           C  
ATOM  48545  CG  LYS L  62      19.993  25.096  11.397  1.00126.20           C  
ATOM  48546  CD  LYS L  62      18.566  25.359  11.881  1.00126.20           C  
ATOM  48547  CE  LYS L  62      18.331  24.997  13.348  1.00126.20           C  
ATOM  48548  NZ  LYS L  62      18.721  26.132  14.217  1.00126.20           N  
ATOM  48549  N   GLN L  63      22.789  25.290  11.202  1.00140.07           N  
ATOM  48550  CA  GLN L  63      23.911  25.891  11.842  1.00140.07           C  
ATOM  48551  C   GLN L  63      25.076  25.578  10.954  1.00140.07           C  
ATOM  48552  O   GLN L  63      24.894  25.381   9.755  1.00140.07           O  
ATOM  48553  CB  GLN L  63      24.117  25.346  13.275  1.00140.07           C  
ATOM  48554  CG  GLN L  63      23.059  25.825  14.271  1.00140.07           C  
ATOM  48555  CD  GLN L  63      23.244  27.329  14.428  1.00140.07           C  
ATOM  48556  OE1 GLN L  63      22.604  28.114  13.733  1.00140.07           O  
ATOM  48557  NE2 GLN L  63      24.151  27.741  15.351  1.00140.07           N  
ATOM  48558  N   PRO L  64      26.269  25.607  11.467  1.00183.83           N  
ATOM  48559  CA  PRO L  64      27.374  25.231  10.632  1.00183.83           C  
ATOM  48560  C   PRO L  64      27.547  23.783  10.274  1.00183.83           C  
ATOM  48561  O   PRO L  64      28.078  23.522   9.197  1.00183.83           O  
ATOM  48562  CB  PRO L  64      28.621  25.828  11.283  1.00183.83           C  
ATOM  48563  CG  PRO L  64      28.083  27.064  12.011  1.00183.83           C  
ATOM  48564  CD  PRO L  64      26.640  26.693  12.364  1.00183.83           C  
ATOM  48565  N   ASN L  65      27.116  22.811  11.105  1.00145.73           N  
ATOM  48566  CA  ASN L  65      27.492  21.473  10.735  1.00145.73           C  
ATOM  48567  C   ASN L  65      26.804  21.038   9.479  1.00145.73           C  
ATOM  48568  O   ASN L  65      25.688  21.458   9.179  1.00145.73           O  
ATOM  48569  CB  ASN L  65      27.373  20.411  11.858  1.00145.73           C  
ATOM  48570  CG  ASN L  65      25.959  20.283  12.393  1.00145.73           C  
ATOM  48571  OD1 ASN L  65      25.499  19.159  12.582  1.00145.73           O  
ATOM  48572  ND2 ASN L  65      25.280  21.426  12.681  1.00145.73           N  
ATOM  48573  N   SER L  66      27.509  20.209   8.677  1.00 37.51           N  
ATOM  48574  CA  SER L  66      26.967  19.731   7.435  1.00 37.51           C  
ATOM  48575  C   SER L  66      27.314  18.283   7.293  1.00 37.51           C  
ATOM  48576  O   SER L  66      28.339  17.821   7.788  1.00 37.51           O  
ATOM  48577  CB  SER L  66      27.524  20.459   6.202  1.00 37.51           C  
ATOM  48578  OG  SER L  66      26.952  19.927   5.016  1.00 37.51           O  
ATOM  48579  N   ALA L  67      26.425  17.526   6.615  1.00 48.21           N  
ATOM  48580  CA  ALA L  67      26.610  16.123   6.380  1.00 48.21           C  
ATOM  48581  C   ALA L  67      25.291  15.606   5.917  1.00 48.21           C  
ATOM  48582  O   ALA L  67      24.341  16.373   5.772  1.00 48.21           O  
ATOM  48583  CB  ALA L  67      27.008  15.324   7.633  1.00 48.21           C  
ATOM  48584  N   ILE L  68      25.206  14.290   5.634  1.00109.45           N  
ATOM  48585  CA  ILE L  68      23.950  13.737   5.218  1.00109.45           C  
ATOM  48586  C   ILE L  68      23.396  12.893   6.324  1.00109.45           C  
ATOM  48587  O   ILE L  68      23.730  11.721   6.472  1.00109.45           O  
ATOM  48588  CB  ILE L  68      24.059  12.894   3.976  1.00109.45           C  
ATOM  48589  CG1 ILE L  68      22.681  12.332   3.587  1.00109.45           C  
ATOM  48590  CG2 ILE L  68      25.179  11.854   4.158  1.00109.45           C  
ATOM  48591  CD1 ILE L  68      22.679  11.606   2.242  1.00109.45           C  
ATOM  48592  N   ARG L  69      22.489  13.472   7.133  1.00152.75           N  
ATOM  48593  CA  ARG L  69      21.938  12.703   8.211  1.00152.75           C  
ATOM  48594  C   ARG L  69      20.893  11.817   7.626  1.00152.75           C  
ATOM  48595  O   ARG L  69      20.102  12.242   6.785  1.00152.75           O  
ATOM  48596  CB  ARG L  69      21.328  13.571   9.326  1.00152.75           C  
ATOM  48597  CG  ARG L  69      22.374  14.515   9.921  1.00152.75           C  
ATOM  48598  CD  ARG L  69      23.653  13.801  10.380  1.00152.75           C  
ATOM  48599  NE  ARG L  69      24.769  14.793  10.348  1.00152.75           N  
ATOM  48600  CZ  ARG L  69      25.111  15.520  11.450  1.00152.75           C  
ATOM  48601  NH1 ARG L  69      24.489  15.292  12.640  1.00152.75           N  
ATOM  48602  NH2 ARG L  69      26.085  16.472  11.362  1.00152.75           N  
ATOM  48603  N   LYS L  70      20.863  10.540   8.049  1.00107.14           N  
ATOM  48604  CA  LYS L  70      19.920   9.630   7.474  1.00107.14           C  
ATOM  48605  C   LYS L  70      18.673   9.674   8.292  1.00107.14           C  
ATOM  48606  O   LYS L  70      18.713   9.505   9.512  1.00107.14           O  
ATOM  48607  CB  LYS L  70      20.425   8.177   7.435  1.00107.14           C  
ATOM  48608  CG  LYS L  70      21.582   7.965   6.454  1.00107.14           C  
ATOM  48609  CD  LYS L  70      22.855   8.724   6.836  1.00107.14           C  
ATOM  48610  CE  LYS L  70      24.027   8.481   5.885  1.00107.14           C  
ATOM  48611  NZ  LYS L  70      23.864   9.301   4.665  1.00107.14           N  
ATOM  48612  N   CYS L  71      17.522   9.904   7.628  1.00 90.70           N  
ATOM  48613  CA  CYS L  71      16.283  10.003   8.344  1.00 90.70           C  
ATOM  48614  C   CYS L  71      15.253   9.158   7.650  1.00 90.70           C  
ATOM  48615  O   CYS L  71      15.514   8.612   6.579  1.00 90.70           O  
ATOM  48616  CB  CYS L  71      15.738  11.438   8.415  1.00 90.70           C  
ATOM  48617  SG  CYS L  71      15.319  12.115   6.778  1.00 90.70           S  
ATOM  48618  N   VAL L  72      14.062   8.986   8.270  1.00117.52           N  
ATOM  48619  CA  VAL L  72      13.031   8.222   7.617  1.00117.52           C  
ATOM  48620  C   VAL L  72      11.674   8.658   8.083  1.00117.52           C  
ATOM  48621  O   VAL L  72      11.430   8.850   9.273  1.00117.52           O  
ATOM  48622  CB  VAL L  72      13.110   6.749   7.886  1.00117.52           C  
ATOM  48623  CG1 VAL L  72      14.412   6.202   7.283  1.00117.52           C  
ATOM  48624  CG2 VAL L  72      12.988   6.529   9.402  1.00117.52           C  
ATOM  48625  N   ARG L  73      10.736   8.810   7.126  1.00123.44           N  
ATOM  48626  CA  ARG L  73       9.392   9.144   7.483  1.00123.44           C  
ATOM  48627  C   ARG L  73       8.752   7.862   7.899  1.00123.44           C  
ATOM  48628  O   ARG L  73       8.983   6.823   7.285  1.00123.44           O  
ATOM  48629  CB  ARG L  73       8.575   9.753   6.329  1.00123.44           C  
ATOM  48630  CG  ARG L  73       8.984  11.194   6.012  1.00123.44           C  
ATOM  48631  CD  ARG L  73       8.562  12.174   7.112  1.00123.44           C  
ATOM  48632  NE  ARG L  73       9.173  13.502   6.824  1.00123.44           N  
ATOM  48633  CZ  ARG L  73       8.532  14.401   6.020  1.00123.44           C  
ATOM  48634  NH1 ARG L  73       7.342  14.076   5.437  1.00123.44           N  
ATOM  48635  NH2 ARG L  73       9.080  15.634   5.809  1.00123.44           N  
ATOM  48636  N   VAL L  74       7.947   7.894   8.975  1.00121.24           N  
ATOM  48637  CA  VAL L  74       7.328   6.693   9.451  1.00121.24           C  
ATOM  48638  C   VAL L  74       5.886   6.918   9.732  1.00121.24           C  
ATOM  48639  O   VAL L  74       5.470   7.975  10.209  1.00121.24           O  
ATOM  48640  CB  VAL L  74       7.939   6.141  10.702  1.00121.24           C  
ATOM  48641  CG1 VAL L  74       9.252   5.444  10.347  1.00121.24           C  
ATOM  48642  CG2 VAL L  74       8.159   7.313  11.670  1.00121.24           C  
ATOM  48643  N   GLN L  75       5.078   5.887   9.428  1.00 55.54           N  
ATOM  48644  CA  GLN L  75       3.679   5.953   9.702  1.00 55.54           C  
ATOM  48645  C   GLN L  75       3.475   5.125  10.930  1.00 55.54           C  
ATOM  48646  O   GLN L  75       3.567   3.899  10.889  1.00 55.54           O  
ATOM  48647  CB  GLN L  75       2.816   5.365   8.573  1.00 55.54           C  
ATOM  48648  CG  GLN L  75       1.314   5.440   8.841  1.00 55.54           C  
ATOM  48649  CD  GLN L  75       0.600   4.829   7.642  1.00 55.54           C  
ATOM  48650  OE1 GLN L  75      -0.616   4.941   7.499  1.00 55.54           O  
ATOM  48651  NE2 GLN L  75       1.380   4.169   6.745  1.00 55.54           N  
ATOM  48652  N   LEU L  76       3.209   5.797  12.070  1.00103.27           N  
ATOM  48653  CA  LEU L  76       3.055   5.097  13.316  1.00103.27           C  
ATOM  48654  C   LEU L  76       1.670   4.553  13.401  1.00103.27           C  
ATOM  48655  O   LEU L  76       0.736   5.108  12.823  1.00103.27           O  
ATOM  48656  CB  LEU L  76       3.265   5.970  14.568  1.00103.27           C  
ATOM  48657  CG  LEU L  76       4.644   6.653  14.634  1.00103.27           C  
ATOM  48658  CD1 LEU L  76       5.792   5.630  14.606  1.00103.27           C  
ATOM  48659  CD2 LEU L  76       4.779   7.743  13.560  1.00103.27           C  
ATOM  48660  N   ILE L  77       1.511   3.395  14.067  1.00167.00           N  
ATOM  48661  CA  ILE L  77       0.193   2.865  14.235  1.00167.00           C  
ATOM  48662  C   ILE L  77      -0.568   3.655  15.259  1.00167.00           C  
ATOM  48663  O   ILE L  77      -1.716   4.037  15.053  1.00167.00           O  
ATOM  48664  CB  ILE L  77       0.149   1.415  14.661  1.00167.00           C  
ATOM  48665  CG1 ILE L  77       0.694   1.207  16.081  1.00167.00           C  
ATOM  48666  CG2 ILE L  77       0.882   0.589  13.592  1.00167.00           C  
ATOM  48667  CD1 ILE L  77       2.128   1.693  16.282  1.00167.00           C  
ATOM  48668  N   LYS L  78       0.081   3.936  16.403  1.00162.98           N  
ATOM  48669  CA  LYS L  78      -0.581   4.491  17.550  1.00162.98           C  
ATOM  48670  C   LYS L  78      -1.182   5.819  17.280  1.00162.98           C  
ATOM  48671  O   LYS L  78      -2.401   5.984  17.287  1.00162.98           O  
ATOM  48672  CB  LYS L  78       0.415   4.730  18.699  1.00162.98           C  
ATOM  48673  CG  LYS L  78       0.915   3.466  19.399  1.00162.98           C  
ATOM  48674  CD  LYS L  78      -0.154   2.813  20.269  1.00162.98           C  
ATOM  48675  CE  LYS L  78      -0.514   3.673  21.481  1.00162.98           C  
ATOM  48676  NZ  LYS L  78      -1.505   2.968  22.326  1.00162.98           N  
ATOM  48677  N   ASN L  79      -0.342   6.821  16.995  1.00 79.33           N  
ATOM  48678  CA  ASN L  79      -0.938   8.099  16.801  1.00 79.33           C  
ATOM  48679  C   ASN L  79      -1.689   7.990  15.529  1.00 79.33           C  
ATOM  48680  O   ASN L  79      -2.776   8.543  15.362  1.00 79.33           O  
ATOM  48681  CB  ASN L  79       0.078   9.241  16.657  1.00 79.33           C  
ATOM  48682  CG  ASN L  79      -0.646  10.550  16.955  1.00 79.33           C  
ATOM  48683  OD1 ASN L  79      -0.004  11.563  17.229  1.00 79.33           O  
ATOM  48684  ND2 ASN L  79      -2.004  10.539  16.926  1.00 79.33           N  
ATOM  48685  N   GLY L  80      -1.116   7.207  14.603  1.00 34.85           N  
ATOM  48686  CA  GLY L  80      -1.652   7.180  13.291  1.00 34.85           C  
ATOM  48687  C   GLY L  80      -0.989   8.364  12.688  1.00 34.85           C  
ATOM  48688  O   GLY L  80      -1.323   8.803  11.590  1.00 34.85           O  
ATOM  48689  N   LYS L  81      -0.026   8.929  13.452  1.00134.36           N  
ATOM  48690  CA  LYS L  81       0.671  10.088  13.007  1.00134.36           C  
ATOM  48691  C   LYS L  81       1.854   9.670  12.210  1.00134.36           C  
ATOM  48692  O   LYS L  81       2.397   8.580  12.390  1.00134.36           O  
ATOM  48693  CB  LYS L  81       1.132  11.041  14.122  1.00134.36           C  
ATOM  48694  CG  LYS L  81       1.731  12.336  13.566  1.00134.36           C  
ATOM  48695  CD  LYS L  81       1.744  13.494  14.567  1.00134.36           C  
ATOM  48696  CE  LYS L  81       0.409  14.246  14.631  1.00134.36           C  
ATOM  48697  NZ  LYS L  81       0.228  15.074  13.416  1.00134.36           N  
ATOM  48698  N   LYS L  82       2.257  10.549  11.276  1.00 79.54           N  
ATOM  48699  CA  LYS L  82       3.392  10.313  10.437  1.00 79.54           C  
ATOM  48700  C   LYS L  82       4.488  11.146  11.012  1.00 79.54           C  
ATOM  48701  O   LYS L  82       4.285  12.328  11.284  1.00 79.54           O  
ATOM  48702  CB  LYS L  82       3.179  10.812   8.998  1.00 79.54           C  
ATOM  48703  CG  LYS L  82       2.075  10.075   8.232  1.00 79.54           C  
ATOM  48704  CD  LYS L  82       1.586  10.854   7.008  1.00 79.54           C  
ATOM  48705  CE  LYS L  82       2.710  11.455   6.162  1.00 79.54           C  
ATOM  48706  NZ  LYS L  82       2.129  12.273   5.078  1.00 79.54           N  
ATOM  48707  N   VAL L  83       5.685  10.561  11.210  1.00 44.75           N  
ATOM  48708  CA  VAL L  83       6.734  11.335  11.813  1.00 44.75           C  
ATOM  48709  C   VAL L  83       8.034  11.041  11.126  1.00 44.75           C  
ATOM  48710  O   VAL L  83       8.128  10.135  10.304  1.00 44.75           O  
ATOM  48711  CB  VAL L  83       6.921  11.043  13.271  1.00 44.75           C  
ATOM  48712  CG1 VAL L  83       5.633  11.442  14.014  1.00 44.75           C  
ATOM  48713  CG2 VAL L  83       7.305   9.562  13.433  1.00 44.75           C  
ATOM  48714  N   THR L  84       9.073  11.847  11.445  1.00 48.56           N  
ATOM  48715  CA  THR L  84      10.390  11.682  10.898  1.00 48.56           C  
ATOM  48716  C   THR L  84      11.256  11.206  12.019  1.00 48.56           C  
ATOM  48717  O   THR L  84      11.136  11.689  13.145  1.00 48.56           O  
ATOM  48718  CB  THR L  84      10.991  12.968  10.407  1.00 48.56           C  
ATOM  48719  OG1 THR L  84      10.193  13.522   9.371  1.00 48.56           O  
ATOM  48720  CG2 THR L  84      12.418  12.701   9.901  1.00 48.56           C  
ATOM  48721  N   ALA L  85      12.151  10.230  11.749  1.00 47.56           N  
ATOM  48722  CA  ALA L  85      12.957   9.724  12.824  1.00 47.56           C  
ATOM  48723  C   ALA L  85      14.374   9.550  12.373  1.00 47.56           C  
ATOM  48724  O   ALA L  85      14.642   9.239  11.214  1.00 47.56           O  
ATOM  48725  CB  ALA L  85      12.482   8.365  13.358  1.00 47.56           C  
ATOM  48726  N   PHE L  86      15.324   9.736  13.312  1.00 73.84           N  
ATOM  48727  CA  PHE L  86      16.735   9.645  13.040  1.00 73.84           C  
ATOM  48728  C   PHE L  86      17.131   8.200  13.033  1.00 73.84           C  
ATOM  48729  O   PHE L  86      16.557   7.387  13.756  1.00 73.84           O  
ATOM  48730  CB  PHE L  86      17.568  10.366  14.120  1.00 73.84           C  
ATOM  48731  CG  PHE L  86      19.020  10.350  13.778  1.00 73.84           C  
ATOM  48732  CD1 PHE L  86      19.548  11.265  12.896  1.00 73.84           C  
ATOM  48733  CD2 PHE L  86      19.862   9.431  14.363  1.00 73.84           C  
ATOM  48734  CE1 PHE L  86      20.889  11.252  12.592  1.00 73.84           C  
ATOM  48735  CE2 PHE L  86      21.205   9.415  14.063  1.00 73.84           C  
ATOM  48736  CZ  PHE L  86      21.723  10.327  13.172  1.00 73.84           C  
ATOM  48737  N   VAL L  87      18.108   7.825  12.175  1.00125.98           N  
ATOM  48738  CA  VAL L  87      18.580   6.466  12.169  1.00125.98           C  
ATOM  48739  C   VAL L  87      20.023   6.482  12.577  1.00125.98           C  
ATOM  48740  O   VAL L  87      20.918   6.845  11.816  1.00125.98           O  
ATOM  48741  CB  VAL L  87      18.444   5.792  10.831  1.00125.98           C  
ATOM  48742  CG1 VAL L  87      16.946   5.585  10.550  1.00125.98           C  
ATOM  48743  CG2 VAL L  87      19.136   6.645   9.751  1.00125.98           C  
ATOM  48744  N   PRO L  88      20.254   6.062  13.785  1.00114.58           N  
ATOM  48745  CA  PRO L  88      21.544   6.078  14.422  1.00114.58           C  
ATOM  48746  C   PRO L  88      22.481   5.065  13.844  1.00114.58           C  
ATOM  48747  O   PRO L  88      22.021   4.100  13.237  1.00114.58           O  
ATOM  48748  CB  PRO L  88      21.262   5.783  15.895  1.00114.58           C  
ATOM  48749  CG  PRO L  88      19.956   4.969  15.864  1.00114.58           C  
ATOM  48750  CD  PRO L  88      19.209   5.536  14.645  1.00114.58           C  
ATOM  48751  N   ASN L  89      23.801   5.303  14.016  1.00208.90           N  
ATOM  48752  CA  ASN L  89      24.844   4.391  13.649  1.00208.90           C  
ATOM  48753  C   ASN L  89      25.333   4.718  12.289  1.00208.90           C  
ATOM  48754  O   ASN L  89      24.601   5.266  11.465  1.00208.90           O  
ATOM  48755  CB  ASN L  89      24.444   2.911  13.705  1.00208.90           C  
ATOM  48756  CG  ASN L  89      24.195   2.599  15.172  1.00208.90           C  
ATOM  48757  OD1 ASN L  89      24.490   3.418  16.041  1.00208.90           O  
ATOM  48758  ND2 ASN L  89      23.642   1.392  15.458  1.00208.90           N  
ATOM  48759  N   ASP L  90      26.613   4.395  12.026  1.00 65.67           N  
ATOM  48760  CA  ASP L  90      27.121   4.649  10.718  1.00 65.67           C  
ATOM  48761  C   ASP L  90      26.268   3.825   9.826  1.00 65.67           C  
ATOM  48762  O   ASP L  90      25.827   4.273   8.771  1.00 65.67           O  
ATOM  48763  CB  ASP L  90      28.580   4.204  10.525  1.00 65.67           C  
ATOM  48764  CG  ASP L  90      29.481   5.180  11.269  1.00 65.67           C  
ATOM  48765  OD1 ASP L  90      28.935   6.111  11.920  1.00 65.67           O  
ATOM  48766  OD2 ASP L  90      30.726   5.014  11.189  1.00 65.67           O  
ATOM  48767  N   GLY L  91      26.007   2.584  10.265  1.00 62.92           N  
ATOM  48768  CA  GLY L  91      25.176   1.714   9.496  1.00 62.92           C  
ATOM  48769  C   GLY L  91      26.010   1.293   8.349  1.00 62.92           C  
ATOM  48770  O   GLY L  91      27.113   1.800   8.166  1.00 62.92           O  
ATOM  48771  N   CYS L  92      25.515   0.344   7.538  1.00 89.50           N  
ATOM  48772  CA  CYS L  92      26.245   0.042   6.349  1.00 89.50           C  
ATOM  48773  C   CYS L  92      25.741   1.111   5.462  1.00 89.50           C  
ATOM  48774  O   CYS L  92      26.017   2.287   5.699  1.00 89.50           O  
ATOM  48775  CB  CYS L  92      25.882  -1.310   5.709  1.00 89.50           C  
ATOM  48776  SG  CYS L  92      26.836  -1.645   4.195  1.00 89.50           S  
ATOM  48777  N   LEU L  93      25.003   0.741   4.404  1.00 87.69           N  
ATOM  48778  CA  LEU L  93      24.341   1.805   3.719  1.00 87.69           C  
ATOM  48779  C   LEU L  93      23.433   2.314   4.791  1.00 87.69           C  
ATOM  48780  O   LEU L  93      23.279   3.512   5.014  1.00 87.69           O  
ATOM  48781  CB  LEU L  93      23.444   1.313   2.570  1.00 87.69           C  
ATOM  48782  CG  LEU L  93      24.180   0.582   1.430  1.00 87.69           C  
ATOM  48783  CD1 LEU L  93      25.172   1.514   0.713  1.00 87.69           C  
ATOM  48784  CD2 LEU L  93      24.811  -0.734   1.911  1.00 87.69           C  
ATOM  48785  N   ASN L  94      22.828   1.334   5.487  1.00173.63           N  
ATOM  48786  CA  ASN L  94      21.921   1.432   6.582  1.00173.63           C  
ATOM  48787  C   ASN L  94      20.963   0.354   6.234  1.00173.63           C  
ATOM  48788  O   ASN L  94      20.930  -0.069   5.079  1.00173.63           O  
ATOM  48789  CB  ASN L  94      21.167   2.770   6.662  1.00173.63           C  
ATOM  48790  CG  ASN L  94      20.203   2.876   5.493  1.00173.63           C  
ATOM  48791  OD1 ASN L  94      19.083   3.335   5.693  1.00173.63           O  
ATOM  48792  ND2 ASN L  94      20.622   2.448   4.271  1.00173.63           N  
ATOM  48793  N   PHE L  95      20.171  -0.166   7.180  1.00210.77           N  
ATOM  48794  CA  PHE L  95      19.346  -1.216   6.670  1.00210.77           C  
ATOM  48795  C   PHE L  95      17.933  -0.751   6.752  1.00210.77           C  
ATOM  48796  O   PHE L  95      17.123  -1.353   7.447  1.00210.77           O  
ATOM  48797  CB  PHE L  95      19.451  -2.499   7.512  1.00210.77           C  
ATOM  48798  CG  PHE L  95      18.864  -3.616   6.721  1.00210.77           C  
ATOM  48799  CD1 PHE L  95      19.625  -4.246   5.763  1.00210.77           C  
ATOM  48800  CD2 PHE L  95      17.575  -4.046   6.933  1.00210.77           C  
ATOM  48801  CE1 PHE L  95      19.113  -5.282   5.018  1.00210.77           C  
ATOM  48802  CE2 PHE L  95      17.060  -5.081   6.190  1.00210.77           C  
ATOM  48803  CZ  PHE L  95      17.823  -5.704   5.233  1.00210.77           C  
ATOM  48804  N   VAL L  96      17.580   0.316   6.017  1.00 60.67           N  
ATOM  48805  CA  VAL L  96      16.220   0.763   6.083  1.00 60.67           C  
ATOM  48806  C   VAL L  96      15.762   0.952   4.680  1.00 60.67           C  
ATOM  48807  O   VAL L  96      16.447   1.595   3.886  1.00 60.67           O  
ATOM  48808  CB  VAL L  96      16.076   2.093   6.756  1.00 60.67           C  
ATOM  48809  CG1 VAL L  96      14.605   2.531   6.683  1.00 60.67           C  
ATOM  48810  CG2 VAL L  96      16.628   1.983   8.188  1.00 60.67           C  
ATOM  48811  N   ASP L  97      14.587   0.399   4.324  1.00117.45           N  
ATOM  48812  CA  ASP L  97      14.163   0.576   2.967  1.00117.45           C  
ATOM  48813  C   ASP L  97      12.819   1.217   2.927  1.00117.45           C  
ATOM  48814  O   ASP L  97      12.360   1.797   3.911  1.00117.45           O  
ATOM  48815  CB  ASP L  97      14.163  -0.711   2.112  1.00117.45           C  
ATOM  48816  CG  ASP L  97      13.161  -1.756   2.590  1.00117.45           C  
ATOM  48817  OD1 ASP L  97      12.229  -1.418   3.367  1.00117.45           O  
ATOM  48818  OD2 ASP L  97      13.328  -2.925   2.156  1.00117.45           O  
ATOM  48819  N   GLU L  98      12.159   1.110   1.755  1.00110.82           N  
ATOM  48820  CA  GLU L  98      10.910   1.763   1.510  1.00110.82           C  
ATOM  48821  C   GLU L  98       9.854   1.327   2.455  1.00110.82           C  
ATOM  48822  O   GLU L  98       9.149   2.190   2.955  1.00110.82           O  
ATOM  48823  CB  GLU L  98      10.376   1.572   0.078  1.00110.82           C  
ATOM  48824  CG  GLU L  98      11.012   2.545  -0.910  1.00110.82           C  
ATOM  48825  CD  GLU L  98      10.544   3.943  -0.510  1.00110.82           C  
ATOM  48826  OE1 GLU L  98       9.306   4.184  -0.531  1.00110.82           O  
ATOM  48827  OE2 GLU L  98      11.417   4.780  -0.163  1.00110.82           O  
ATOM  48828  N   ASN L  99       9.660   0.028   2.739  1.00136.73           N  
ATOM  48829  CA  ASN L  99       8.611  -0.195   3.691  1.00136.73           C  
ATOM  48830  C   ASN L  99       9.060  -1.152   4.750  1.00136.73           C  
ATOM  48831  O   ASN L  99       8.479  -2.224   4.913  1.00136.73           O  
ATOM  48832  CB  ASN L  99       7.309  -0.725   3.068  1.00136.73           C  
ATOM  48833  CG  ASN L  99       6.644   0.444   2.347  1.00136.73           C  
ATOM  48834  OD1 ASN L  99       6.260   1.434   2.969  1.00136.73           O  
ATOM  48835  ND2 ASN L  99       6.512   0.339   0.997  1.00136.73           N  
ATOM  48836  N   ASP L 100      10.086  -0.781   5.537  1.00 65.48           N  
ATOM  48837  CA  ASP L 100      10.484  -1.670   6.584  1.00 65.48           C  
ATOM  48838  C   ASP L 100       9.825  -1.243   7.852  1.00 65.48           C  
ATOM  48839  O   ASP L 100       9.599  -0.057   8.088  1.00 65.48           O  
ATOM  48840  CB  ASP L 100      11.999  -1.739   6.842  1.00 65.48           C  
ATOM  48841  CG  ASP L 100      12.609  -2.643   5.782  1.00 65.48           C  
ATOM  48842  OD1 ASP L 100      11.849  -3.471   5.212  1.00 65.48           O  
ATOM  48843  OD2 ASP L 100      13.838  -2.528   5.533  1.00 65.48           O  
ATOM  48844  N   GLU L 101       9.491  -2.231   8.701  1.00 72.75           N  
ATOM  48845  CA  GLU L 101       8.886  -1.978   9.977  1.00 72.75           C  
ATOM  48846  C   GLU L 101       9.955  -1.458  10.886  1.00 72.75           C  
ATOM  48847  O   GLU L 101      11.103  -1.895  10.812  1.00 72.75           O  
ATOM  48848  CB  GLU L 101       8.329  -3.250  10.635  1.00 72.75           C  
ATOM  48849  CG  GLU L 101       7.090  -3.818   9.946  1.00 72.75           C  
ATOM  48850  CD  GLU L 101       5.919  -2.900  10.264  1.00 72.75           C  
ATOM  48851  OE1 GLU L 101       6.165  -1.802  10.832  1.00 72.75           O  
ATOM  48852  OE2 GLU L 101       4.764  -3.289   9.946  1.00 72.75           O  
ATOM  48853  N   VAL L 102       9.607  -0.508  11.780  1.00108.55           N  
ATOM  48854  CA  VAL L 102      10.612   0.042  12.644  1.00108.55           C  
ATOM  48855  C   VAL L 102       9.992   0.387  13.965  1.00108.55           C  
ATOM  48856  O   VAL L 102       8.771   0.455  14.094  1.00108.55           O  
ATOM  48857  CB  VAL L 102      11.210   1.303  12.083  1.00108.55           C  
ATOM  48858  CG1 VAL L 102      10.090   2.346  11.962  1.00108.55           C  
ATOM  48859  CG2 VAL L 102      12.373   1.773  12.968  1.00108.55           C  
ATOM  48860  N   LEU L 103      10.839   0.572  15.006  1.00124.94           N  
ATOM  48861  CA  LEU L 103      10.365   0.991  16.301  1.00124.94           C  
ATOM  48862  C   LEU L 103      10.956   2.331  16.598  1.00124.94           C  
ATOM  48863  O   LEU L 103      12.148   2.555  16.386  1.00124.94           O  
ATOM  48864  CB  LEU L 103      10.774   0.097  17.486  1.00124.94           C  
ATOM  48865  CG  LEU L 103      10.057  -1.256  17.555  1.00124.94           C  
ATOM  48866  CD1 LEU L 103      10.433  -2.137  16.359  1.00124.94           C  
ATOM  48867  CD2 LEU L 103      10.294  -1.940  18.911  1.00124.94           C  
ATOM  48868  N   LEU L 104      10.135   3.270  17.111  1.00127.18           N  
ATOM  48869  CA  LEU L 104      10.641   4.578  17.420  1.00127.18           C  
ATOM  48870  C   LEU L 104      10.710   4.745  18.905  1.00127.18           C  
ATOM  48871  O   LEU L 104       9.718   4.599  19.613  1.00127.18           O  
ATOM  48872  CB  LEU L 104       9.796   5.728  16.848  1.00127.18           C  
ATOM  48873  CG  LEU L 104       9.854   5.789  15.312  1.00127.18           C  
ATOM  48874  CD1 LEU L 104       9.266   4.520  14.677  1.00127.18           C  
ATOM  48875  CD2 LEU L 104       9.194   7.074  14.789  1.00127.18           C  
ATOM  48876  N   ALA L 105      11.941   4.962  19.401  1.00 85.05           N  
ATOM  48877  CA  ALA L 105      12.281   5.175  20.779  1.00 85.05           C  
ATOM  48878  C   ALA L 105      11.941   6.541  21.285  1.00 85.05           C  
ATOM  48879  O   ALA L 105      11.615   6.713  22.457  1.00 85.05           O  
ATOM  48880  CB  ALA L 105      13.780   4.971  21.043  1.00 85.05           C  
ATOM  48881  N   GLY L 106      12.069   7.576  20.436  1.00110.31           N  
ATOM  48882  CA  GLY L 106      12.049   8.872  21.036  1.00110.31           C  
ATOM  48883  C   GLY L 106      13.322   8.824  21.832  1.00110.31           C  
ATOM  48884  O   GLY L 106      13.461   9.470  22.866  1.00110.31           O  
ATOM  48885  N   PHE L 107      14.312   8.041  21.336  1.00282.23           N  
ATOM  48886  CA  PHE L 107      15.488   7.766  22.103  1.00282.23           C  
ATOM  48887  C   PHE L 107      16.151   9.067  22.397  1.00282.23           C  
ATOM  48888  O   PHE L 107      16.370   9.881  21.505  1.00282.23           O  
ATOM  48889  CB  PHE L 107      16.472   6.831  21.376  1.00282.23           C  
ATOM  48890  CG  PHE L 107      17.383   6.264  22.406  1.00282.23           C  
ATOM  48891  CD1 PHE L 107      18.542   6.904  22.781  1.00282.23           C  
ATOM  48892  CD2 PHE L 107      17.062   5.070  23.009  1.00282.23           C  
ATOM  48893  CE1 PHE L 107      19.371   6.363  23.735  1.00282.23           C  
ATOM  48894  CE2 PHE L 107      17.887   4.522  23.964  1.00282.23           C  
ATOM  48895  CZ  PHE L 107      19.044   5.168  24.329  1.00282.23           C  
ATOM  48896  N   GLY L 108      16.521   9.262  23.672  1.00 96.28           N  
ATOM  48897  CA  GLY L 108      17.006  10.532  24.121  1.00 96.28           C  
ATOM  48898  C   GLY L 108      15.856  11.067  24.903  1.00 96.28           C  
ATOM  48899  O   GLY L 108      14.799  10.439  24.923  1.00 96.28           O  
ATOM  48900  N   ARG L 109      16.022  12.216  25.587  1.00100.97           N  
ATOM  48901  CA  ARG L 109      14.911  12.688  26.360  1.00100.97           C  
ATOM  48902  C   ARG L 109      13.771  12.922  25.420  1.00100.97           C  
ATOM  48903  O   ARG L 109      12.719  12.298  25.537  1.00100.97           O  
ATOM  48904  CB  ARG L 109      15.198  14.036  27.048  1.00100.97           C  
ATOM  48905  CG  ARG L 109      16.375  14.018  28.030  1.00100.97           C  
ATOM  48906  CD  ARG L 109      16.613  15.355  28.742  1.00100.97           C  
ATOM  48907  NE  ARG L 109      16.948  16.384  27.713  1.00100.97           N  
ATOM  48908  CZ  ARG L 109      17.362  17.629  28.096  1.00100.97           C  
ATOM  48909  NH1 ARG L 109      17.550  17.914  29.418  1.00100.97           N  
ATOM  48910  NH2 ARG L 109      17.586  18.595  27.158  1.00100.97           N  
ATOM  48911  N   LYS L 110      13.976  13.832  24.452  1.00 63.74           N  
ATOM  48912  CA  LYS L 110      12.982  14.117  23.463  1.00 63.74           C  
ATOM  48913  C   LYS L 110      12.974  13.058  22.404  1.00 63.74           C  
ATOM  48914  O   LYS L 110      11.921  12.658  21.910  1.00 63.74           O  
ATOM  48915  CB  LYS L 110      13.184  15.496  22.823  1.00 63.74           C  
ATOM  48916  CG  LYS L 110      12.956  16.612  23.849  1.00 63.74           C  
ATOM  48917  CD  LYS L 110      13.469  17.984  23.414  1.00 63.74           C  
ATOM  48918  CE  LYS L 110      13.196  19.088  24.442  1.00 63.74           C  
ATOM  48919  NZ  LYS L 110      13.613  20.402  23.895  1.00 63.74           N  
ATOM  48920  N   GLY L 111      14.173  12.556  22.049  1.00 72.52           N  
ATOM  48921  CA  GLY L 111      14.353  11.643  20.968  1.00 72.52           C  
ATOM  48922  C   GLY L 111      14.653  12.479  19.760  1.00 72.52           C  
ATOM  48923  O   GLY L 111      14.854  11.963  18.664  1.00 72.52           O  
ATOM  48924  N   LYS L 112      14.689  13.813  19.949  1.00 69.88           N  
ATOM  48925  CA  LYS L 112      14.900  14.732  18.863  1.00 69.88           C  
ATOM  48926  C   LYS L 112      16.366  15.011  18.718  1.00 69.88           C  
ATOM  48927  O   LYS L 112      17.134  14.826  19.658  1.00 69.88           O  
ATOM  48928  CB  LYS L 112      14.244  16.101  19.109  1.00 69.88           C  
ATOM  48929  CG  LYS L 112      12.739  16.058  19.378  1.00 69.88           C  
ATOM  48930  CD  LYS L 112      12.199  17.381  19.925  1.00 69.88           C  
ATOM  48931  CE  LYS L 112      10.709  17.363  20.271  1.00 69.88           C  
ATOM  48932  NZ  LYS L 112      10.293  18.683  20.799  1.00 69.88           N  
ATOM  48933  N   ALA L 113      16.798  15.419  17.502  1.00 64.98           N  
ATOM  48934  CA  ALA L 113      18.146  15.885  17.318  1.00 64.98           C  
ATOM  48935  C   ALA L 113      17.995  17.344  17.005  1.00 64.98           C  
ATOM  48936  O   ALA L 113      17.909  17.740  15.843  1.00 64.98           O  
ATOM  48937  CB  ALA L 113      18.860  15.236  16.118  1.00 64.98           C  
ATOM  48938  N   LYS L 114      17.960  18.197  18.045  1.00145.33           N  
ATOM  48939  CA  LYS L 114      17.702  19.591  17.832  1.00145.33           C  
ATOM  48940  C   LYS L 114      18.833  20.280  17.167  1.00145.33           C  
ATOM  48941  O   LYS L 114      18.646  21.003  16.189  1.00145.33           O  
ATOM  48942  CB  LYS L 114      17.424  20.338  19.145  1.00145.33           C  
ATOM  48943  CG  LYS L 114      16.953  21.779  18.952  1.00145.33           C  
ATOM  48944  CD  LYS L 114      15.565  21.881  18.317  1.00145.33           C  
ATOM  48945  CE  LYS L 114      15.062  23.320  18.209  1.00145.33           C  
ATOM  48946  NZ  LYS L 114      14.745  23.845  19.558  1.00145.33           N  
ATOM  48947  N   GLY L 115      20.049  20.070  17.691  1.00 86.70           N  
ATOM  48948  CA  GLY L 115      21.123  20.807  17.119  1.00 86.70           C  
ATOM  48949  C   GLY L 115      21.260  20.377  15.706  1.00 86.70           C  
ATOM  48950  O   GLY L 115      21.343  21.208  14.803  1.00 86.70           O  
ATOM  48951  N   ASP L 116      21.284  19.056  15.467  1.00120.94           N  
ATOM  48952  CA  ASP L 116      21.490  18.696  14.099  1.00120.94           C  
ATOM  48953  C   ASP L 116      20.298  18.942  13.230  1.00120.94           C  
ATOM  48954  O   ASP L 116      20.340  19.794  12.348  1.00120.94           O  
ATOM  48955  CB  ASP L 116      21.879  17.222  13.924  1.00120.94           C  
ATOM  48956  CG  ASP L 116      23.260  17.048  14.535  1.00120.94           C  
ATOM  48957  OD1 ASP L 116      24.122  17.946  14.338  1.00120.94           O  
ATOM  48958  OD2 ASP L 116      23.473  16.000  15.199  1.00120.94           O  
ATOM  48959  N   ILE L 117      19.165  18.250  13.489  1.00130.57           N  
ATOM  48960  CA  ILE L 117      18.118  18.365  12.513  1.00130.57           C  
ATOM  48961  C   ILE L 117      16.793  18.641  13.131  1.00130.57           C  
ATOM  48962  O   ILE L 117      16.255  17.873  13.930  1.00130.57           O  
ATOM  48963  CB  ILE L 117      18.048  17.152  11.636  1.00130.57           C  
ATOM  48964  CG1 ILE L 117      17.839  15.886  12.480  1.00130.57           C  
ATOM  48965  CG2 ILE L 117      19.328  17.118  10.790  1.00130.57           C  
ATOM  48966  CD1 ILE L 117      17.529  14.635  11.660  1.00130.57           C  
ATOM  48967  N   PRO L 118      16.247  19.748  12.721  1.00 68.25           N  
ATOM  48968  CA  PRO L 118      14.960  20.119  13.222  1.00 68.25           C  
ATOM  48969  C   PRO L 118      13.926  19.259  12.578  1.00 68.25           C  
ATOM  48970  O   PRO L 118      14.117  18.851  11.435  1.00 68.25           O  
ATOM  48971  CB  PRO L 118      14.798  21.603  12.911  1.00 68.25           C  
ATOM  48972  CG  PRO L 118      16.244  22.126  12.874  1.00 68.25           C  
ATOM  48973  CD  PRO L 118      17.074  20.911  12.433  1.00 68.25           C  
ATOM  48974  N   GLY L 119      12.818  18.978  13.289  1.00 32.45           N  
ATOM  48975  CA  GLY L 119      11.762  18.211  12.707  1.00 32.45           C  
ATOM  48976  C   GLY L 119      11.912  16.762  13.053  1.00 32.45           C  
ATOM  48977  O   GLY L 119      11.010  15.976  12.766  1.00 32.45           O  
ATOM  48978  N   VAL L 120      13.040  16.345  13.664  1.00133.37           N  
ATOM  48979  CA  VAL L 120      13.096  14.946  14.003  1.00133.37           C  
ATOM  48980  C   VAL L 120      12.962  14.797  15.486  1.00133.37           C  
ATOM  48981  O   VAL L 120      13.862  15.139  16.254  1.00133.37           O  
ATOM  48982  CB  VAL L 120      14.350  14.243  13.566  1.00133.37           C  
ATOM  48983  CG1 VAL L 120      14.337  14.153  12.037  1.00133.37           C  
ATOM  48984  CG2 VAL L 120      15.562  15.003  14.116  1.00133.37           C  
ATOM  48985  N   ARG L 121      11.772  14.333  15.902  1.00147.60           N  
ATOM  48986  CA  ARG L 121      11.353  14.087  17.251  1.00147.60           C  
ATOM  48987  C   ARG L 121      11.857  12.791  17.832  1.00147.60           C  
ATOM  48988  O   ARG L 121      12.010  12.682  19.047  1.00147.60           O  
ATOM  48989  CB  ARG L 121       9.822  14.091  17.374  1.00147.60           C  
ATOM  48990  CG  ARG L 121       9.211  15.421  16.927  1.00147.60           C  
ATOM  48991  CD  ARG L 121       9.012  16.430  18.057  1.00147.60           C  
ATOM  48992  NE  ARG L 121       8.673  17.740  17.431  1.00147.60           N  
ATOM  48993  CZ  ARG L 121       7.955  18.655  18.142  1.00147.60           C  
ATOM  48994  NH1 ARG L 121       7.530  18.348  19.400  1.00147.60           N  
ATOM  48995  NH2 ARG L 121       7.667  19.876  17.603  1.00147.60           N  
ATOM  48996  N   PHE L 122      12.075  11.745  17.004  1.00 85.17           N  
ATOM  48997  CA  PHE L 122      12.371  10.470  17.608  1.00 85.17           C  
ATOM  48998  C   PHE L 122      13.552   9.844  16.931  1.00 85.17           C  
ATOM  48999  O   PHE L 122      13.954  10.234  15.837  1.00 85.17           O  
ATOM  49000  CB  PHE L 122      11.253   9.442  17.384  1.00 85.17           C  
ATOM  49001  CG  PHE L 122       9.950  10.046  17.769  1.00 85.17           C  
ATOM  49002  CD1 PHE L 122       9.274  10.831  16.862  1.00 85.17           C  
ATOM  49003  CD2 PHE L 122       9.400   9.826  19.009  1.00 85.17           C  
ATOM  49004  CE1 PHE L 122       8.064  11.395  17.187  1.00 85.17           C  
ATOM  49005  CE2 PHE L 122       8.191  10.389  19.337  1.00 85.17           C  
ATOM  49006  CZ  PHE L 122       7.523  11.174  18.427  1.00 85.17           C  
ATOM  49007  N   LYS L 123      14.143   8.825  17.596  1.00 47.00           N  
ATOM  49008  CA  LYS L 123      15.228   8.076  17.028  1.00 47.00           C  
ATOM  49009  C   LYS L 123      14.686   6.713  16.732  1.00 47.00           C  
ATOM  49010  O   LYS L 123      13.736   6.261  17.368  1.00 47.00           O  
ATOM  49011  CB  LYS L 123      16.413   7.839  17.981  1.00 47.00           C  
ATOM  49012  CG  LYS L 123      17.191   9.096  18.376  1.00 47.00           C  
ATOM  49013  CD  LYS L 123      18.185   8.847  19.516  1.00 47.00           C  
ATOM  49014  CE  LYS L 123      19.007  10.071  19.925  1.00 47.00           C  
ATOM  49015  NZ  LYS L 123      19.912   9.722  21.047  1.00 47.00           N  
ATOM  49016  N   VAL L 124      15.257   6.025  15.725  1.00103.44           N  
ATOM  49017  CA  VAL L 124      14.793   4.698  15.448  1.00103.44           C  
ATOM  49018  C   VAL L 124      15.640   3.760  16.242  1.00103.44           C  
ATOM  49019  O   VAL L 124      16.856   3.929  16.336  1.00103.44           O  
ATOM  49020  CB  VAL L 124      14.884   4.321  14.002  1.00103.44           C  
ATOM  49021  CG1 VAL L 124      13.962   5.264  13.207  1.00103.44           C  
ATOM  49022  CG2 VAL L 124      16.361   4.364  13.569  1.00103.44           C  
ATOM  49023  N   VAL L 125      15.020   2.731  16.846  1.00127.78           N  
ATOM  49024  CA  VAL L 125      15.845   1.869  17.631  1.00127.78           C  
ATOM  49025  C   VAL L 125      16.281   0.726  16.787  1.00127.78           C  
ATOM  49026  O   VAL L 125      15.480  -0.092  16.330  1.00127.78           O  
ATOM  49027  CB  VAL L 125      15.191   1.351  18.887  1.00127.78           C  
ATOM  49028  CG1 VAL L 125      13.955   0.504  18.528  1.00127.78           C  
ATOM  49029  CG2 VAL L 125      16.250   0.587  19.699  1.00127.78           C  
ATOM  49030  N   LYS L 126      17.595   0.663  16.526  1.00207.40           N  
ATOM  49031  CA  LYS L 126      18.113  -0.438  15.782  1.00207.40           C  
ATOM  49032  C   LYS L 126      19.045  -1.142  16.697  1.00207.40           C  
ATOM  49033  O   LYS L 126      19.482  -2.259  16.426  1.00207.40           O  
ATOM  49034  CB  LYS L 126      18.858  -0.020  14.503  1.00207.40           C  
ATOM  49035  CG  LYS L 126      20.041   0.924  14.717  1.00207.40           C  
ATOM  49036  CD  LYS L 126      20.900   1.072  13.459  1.00207.40           C  
ATOM  49037  CE  LYS L 126      20.089   1.472  12.221  1.00207.40           C  
ATOM  49038  NZ  LYS L 126      20.968   1.539  11.033  1.00207.40           N  
ATOM  49039  N   VAL L 127      19.344  -0.504  17.840  1.00 94.02           N  
ATOM  49040  CA  VAL L 127      20.172  -1.148  18.805  1.00 94.02           C  
ATOM  49041  C   VAL L 127      19.406  -2.354  19.202  1.00 94.02           C  
ATOM  49042  O   VAL L 127      19.940  -3.457  19.294  1.00 94.02           O  
ATOM  49043  CB  VAL L 127      20.361  -0.330  20.043  1.00 94.02           C  
ATOM  49044  CG1 VAL L 127      21.089  -1.208  21.066  1.00 94.02           C  
ATOM  49045  CG2 VAL L 127      21.108   0.963  19.677  1.00 94.02           C  
ATOM  49046  N   SER L 128      18.095  -2.159  19.410  1.00 25.80           N  
ATOM  49047  CA  SER L 128      17.257  -3.257  19.768  1.00 25.80           C  
ATOM  49048  C   SER L 128      17.350  -4.212  18.633  1.00 25.80           C  
ATOM  49049  O   SER L 128      17.296  -5.428  18.823  1.00 25.80           O  
ATOM  49050  CB  SER L 128      15.780  -2.852  19.911  1.00 25.80           C  
ATOM  49051  OG  SER L 128      15.265  -2.420  18.659  1.00 25.80           O  
ATOM  49052  N   GLY L 129      17.510  -3.672  17.408  1.00 34.55           N  
ATOM  49053  CA  GLY L 129      17.612  -4.548  16.286  1.00 34.55           C  
ATOM  49054  C   GLY L 129      16.264  -5.152  16.145  1.00 34.55           C  
ATOM  49055  O   GLY L 129      16.116  -6.285  15.688  1.00 34.55           O  
ATOM  49056  N   VAL L 130      15.233  -4.397  16.560  1.00 69.78           N  
ATOM  49057  CA  VAL L 130      13.913  -4.933  16.485  1.00 69.78           C  
ATOM  49058  C   VAL L 130      13.342  -4.569  15.167  1.00 69.78           C  
ATOM  49059  O   VAL L 130      13.598  -3.488  14.629  1.00 69.78           O  
ATOM  49060  CB  VAL L 130      12.977  -4.423  17.541  1.00 69.78           C  
ATOM  49061  CG1 VAL L 130      11.576  -4.998  17.259  1.00 69.78           C  
ATOM  49062  CG2 VAL L 130      13.533  -4.806  18.922  1.00 69.78           C  
ATOM  49063  N   SER L 131      12.583  -5.509  14.583  1.00132.76           N  
ATOM  49064  CA  SER L 131      11.947  -5.217  13.345  1.00132.76           C  
ATOM  49065  C   SER L 131      12.982  -5.238  12.274  1.00132.76           C  
ATOM  49066  O   SER L 131      14.000  -5.919  12.387  1.00132.76           O  
ATOM  49067  CB  SER L 131      11.206  -3.865  13.334  1.00132.76           C  
ATOM  49068  OG  SER L 131      10.104  -3.909  14.228  1.00132.76           O  
ATOM  49069  N   LEU L 132      12.709  -4.506  11.178  1.00107.51           N  
ATOM  49070  CA  LEU L 132      13.567  -4.456  10.031  1.00107.51           C  
ATOM  49071  C   LEU L 132      14.875  -3.802  10.343  1.00107.51           C  
ATOM  49072  O   LEU L 132      15.897  -4.195   9.784  1.00107.51           O  
ATOM  49073  CB  LEU L 132      12.941  -3.720   8.836  1.00107.51           C  
ATOM  49074  CG  LEU L 132      11.789  -4.504   8.184  1.00107.51           C  
ATOM  49075  CD1 LEU L 132      12.294  -5.795   7.514  1.00107.51           C  
ATOM  49076  CD2 LEU L 132      10.653  -4.762   9.186  1.00107.51           C  
ATOM  49077  N   LEU L 133      14.893  -2.780  11.220  1.00 70.50           N  
ATOM  49078  CA  LEU L 133      16.138  -2.099  11.460  1.00 70.50           C  
ATOM  49079  C   LEU L 133      17.122  -3.062  12.035  1.00 70.50           C  
ATOM  49080  O   LEU L 133      16.951  -3.557  13.147  1.00 70.50           O  
ATOM  49081  CB  LEU L 133      16.037  -0.954  12.480  1.00 70.50           C  
ATOM  49082  CG  LEU L 133      15.188   0.240  12.026  1.00 70.50           C  
ATOM  49083  CD1 LEU L 133      15.286   1.391  13.042  1.00 70.50           C  
ATOM  49084  CD2 LEU L 133      15.564   0.682  10.607  1.00 70.50           C  
ATOM  49085  N   ALA L 134      18.198  -3.337  11.277  1.00 47.02           N  
ATOM  49086  CA  ALA L 134      19.230  -4.204  11.753  1.00 47.02           C  
ATOM  49087  C   ALA L 134      20.206  -3.360  12.508  1.00 47.02           C  
ATOM  49088  O   ALA L 134      20.222  -2.140  12.361  1.00 47.02           O  
ATOM  49089  CB  ALA L 134      19.994  -4.926  10.632  1.00 47.02           C  
ATOM  49090  N   LEU L 135      21.018  -3.990  13.379  1.00149.78           N  
ATOM  49091  CA  LEU L 135      22.020  -3.264  14.099  1.00149.78           C  
ATOM  49092  C   LEU L 135      23.208  -3.133  13.205  1.00149.78           C  
ATOM  49093  O   LEU L 135      23.388  -3.922  12.282  1.00149.78           O  
ATOM  49094  CB  LEU L 135      22.523  -3.984  15.364  1.00149.78           C  
ATOM  49095  CG  LEU L 135      23.684  -3.255  16.077  1.00149.78           C  
ATOM  49096  CD1 LEU L 135      23.230  -1.928  16.705  1.00149.78           C  
ATOM  49097  CD2 LEU L 135      24.405  -4.174  17.071  1.00149.78           C  
ATOM  49098  N   TRP L 136      24.040  -2.094  13.429  1.00179.90           N  
ATOM  49099  CA  TRP L 136      25.260  -2.058  12.679  1.00179.90           C  
ATOM  49100  C   TRP L 136      26.080  -3.172  13.228  1.00179.90           C  
ATOM  49101  O   TRP L 136      26.196  -3.331  14.441  1.00179.90           O  
ATOM  49102  CB  TRP L 136      26.076  -0.756  12.796  1.00179.90           C  
ATOM  49103  CG  TRP L 136      27.514  -0.907  12.337  1.00179.90           C  
ATOM  49104  CD1 TRP L 136      28.626  -1.012  13.119  1.00179.90           C  
ATOM  49105  CD2 TRP L 136      27.966  -1.023  10.976  1.00179.90           C  
ATOM  49106  NE1 TRP L 136      29.742  -1.170  12.337  1.00179.90           N  
ATOM  49107  CE2 TRP L 136      29.352  -1.184  11.013  1.00179.90           C  
ATOM  49108  CE3 TRP L 136      27.286  -1.006   9.792  1.00179.90           C  
ATOM  49109  CZ2 TRP L 136      30.081  -1.329   9.870  1.00179.90           C  
ATOM  49110  CZ3 TRP L 136      28.028  -1.145   8.639  1.00179.90           C  
ATOM  49111  CH2 TRP L 136      29.397  -1.304   8.674  1.00179.90           C  
ATOM  49112  N   LYS L 137      26.668  -3.986  12.340  1.00107.23           N  
ATOM  49113  CA  LYS L 137      27.366  -5.129  12.838  1.00107.23           C  
ATOM  49114  C   LYS L 137      28.755  -4.757  13.225  1.00107.23           C  
ATOM  49115  O   LYS L 137      29.333  -3.799  12.711  1.00107.23           O  
ATOM  49116  CB  LYS L 137      27.469  -6.297  11.841  1.00107.23           C  
ATOM  49117  CG  LYS L 137      28.393  -6.012  10.658  1.00107.23           C  
ATOM  49118  CD  LYS L 137      28.809  -7.279   9.908  1.00107.23           C  
ATOM  49119  CE  LYS L 137      29.821  -7.028   8.792  1.00107.23           C  
ATOM  49120  NZ  LYS L 137      30.348  -8.316   8.300  1.00107.23           N  
ATOM  49121  N   GLU L 138      29.300  -5.527  14.187  1.00 75.68           N  
ATOM  49122  CA  GLU L 138      30.653  -5.419  14.637  1.00 75.68           C  
ATOM  49123  C   GLU L 138      30.989  -4.005  14.970  1.00 75.68           C  
ATOM  49124  O   GLU L 138      32.020  -3.495  14.533  1.00 75.68           O  
ATOM  49125  CB  GLU L 138      31.665  -5.939  13.604  1.00 75.68           C  
ATOM  49126  CG  GLU L 138      31.517  -7.436  13.323  1.00 75.68           C  
ATOM  49127  CD  GLU L 138      32.526  -7.812  12.250  1.00 75.68           C  
ATOM  49128  OE1 GLU L 138      33.681  -7.302  12.317  1.00 75.68           O  
ATOM  49129  OE2 GLU L 138      32.163  -8.617  11.357  1.00 75.68           O  
ATOM  49130  N   LYS L 139      30.139  -3.321  15.755  1.00121.52           N  
ATOM  49131  CA  LYS L 139      30.547  -1.997  16.107  1.00121.52           C  
ATOM  49132  C   LYS L 139      31.341  -2.142  17.369  1.00121.52           C  
ATOM  49133  O   LYS L 139      30.829  -2.579  18.396  1.00121.52           O  
ATOM  49134  CB  LYS L 139      29.393  -1.010  16.347  1.00121.52           C  
ATOM  49135  CG  LYS L 139      29.876   0.442  16.310  1.00121.52           C  
ATOM  49136  CD  LYS L 139      30.418   0.835  14.933  1.00121.52           C  
ATOM  49137  CE  LYS L 139      31.061   2.223  14.884  1.00121.52           C  
ATOM  49138  NZ  LYS L 139      31.755   2.401  13.590  1.00121.52           N  
ATOM  49139  N   LYS L 140      32.634  -1.780  17.306  1.00130.77           N  
ATOM  49140  CA  LYS L 140      33.546  -1.941  18.402  1.00130.77           C  
ATOM  49141  C   LYS L 140      33.124  -1.083  19.543  1.00130.77           C  
ATOM  49142  O   LYS L 140      33.174  -1.494  20.703  1.00130.77           O  
ATOM  49143  CB  LYS L 140      34.971  -1.496  18.034  1.00130.77           C  
ATOM  49144  CG  LYS L 140      36.001  -1.646  19.157  1.00130.77           C  
ATOM  49145  CD  LYS L 140      37.439  -1.422  18.682  1.00130.77           C  
ATOM  49146  CE  LYS L 140      38.450  -1.241  19.818  1.00130.77           C  
ATOM  49147  NZ  LYS L 140      38.239   0.065  20.480  1.00130.77           N  
ATOM  49148  N   GLU L 141      32.680   0.147  19.237  1.00228.82           N  
ATOM  49149  CA  GLU L 141      32.394   1.065  20.291  1.00228.82           C  
ATOM  49150  C   GLU L 141      31.169   0.668  21.041  1.00228.82           C  
ATOM  49151  O   GLU L 141      30.305  -0.061  20.558  1.00228.82           O  
ATOM  49152  CB  GLU L 141      32.289   2.532  19.836  1.00228.82           C  
ATOM  49153  CG  GLU L 141      31.245   2.806  18.756  1.00228.82           C  
ATOM  49154  CD  GLU L 141      31.495   4.226  18.266  1.00228.82           C  
ATOM  49155  OE1 GLU L 141      32.694   4.598  18.137  1.00228.82           O  
ATOM  49156  OE2 GLU L 141      30.501   4.957  18.020  1.00228.82           O  
ATOM  49157  N   LYS L 142      31.123   1.168  22.288  1.00183.81           N  
ATOM  49158  CA  LYS L 142      30.132   0.983  23.303  1.00183.81           C  
ATOM  49159  C   LYS L 142      28.801   1.544  22.894  1.00183.81           C  
ATOM  49160  O   LYS L 142      27.799   1.076  23.426  1.00183.81           O  
ATOM  49161  CB  LYS L 142      30.536   1.625  24.646  1.00183.81           C  
ATOM  49162  CG  LYS L 142      30.462   3.154  24.706  1.00183.81           C  
ATOM  49163  CD  LYS L 142      29.042   3.708  24.862  1.00183.81           C  
ATOM  49164  CE  LYS L 142      28.997   5.201  25.186  1.00183.81           C  
ATOM  49165  NZ  LYS L 142      27.603   5.616  25.467  1.00183.81           N  
ATOM  49166  N   PRO L 143      28.669   2.500  22.000  1.00 93.85           N  
ATOM  49167  CA  PRO L 143      27.351   2.992  21.723  1.00 93.85           C  
ATOM  49168  C   PRO L 143      26.421   1.945  21.215  1.00 93.85           C  
ATOM  49169  O   PRO L 143      25.243   2.246  21.038  1.00 93.85           O  
ATOM  49170  CB  PRO L 143      27.529   4.208  20.806  1.00 93.85           C  
ATOM  49171  CG  PRO L 143      29.052   4.366  20.637  1.00 93.85           C  
ATOM  49172  CD  PRO L 143      29.631   3.580  21.822  1.00 93.85           C  
ATOM  49173  N   ARG L 144      26.907   0.713  20.985  1.00 93.98           N  
ATOM  49174  CA  ARG L 144      26.040  -0.323  20.514  1.00 93.98           C  
ATOM  49175  C   ARG L 144      24.914  -0.441  21.491  1.00 93.98           C  
ATOM  49176  O   ARG L 144      23.762  -0.598  21.090  1.00 93.98           O  
ATOM  49177  CB  ARG L 144      26.706  -1.704  20.491  1.00 93.98           C  
ATOM  49178  CG  ARG L 144      27.841  -1.848  19.483  1.00 93.98           C  
ATOM  49179  CD  ARG L 144      28.402  -3.267  19.462  1.00 93.98           C  
ATOM  49180  NE  ARG L 144      27.333  -4.157  18.930  1.00 93.98           N  
ATOM  49181  CZ  ARG L 144      27.277  -5.461  19.327  1.00 93.98           C  
ATOM  49182  NH1 ARG L 144      28.193  -5.945  20.215  1.00 93.98           N  
ATOM  49183  NH2 ARG L 144      26.298  -6.276  18.842  1.00 93.98           N  
ATOM  49184  N   SER L 145      25.235  -0.357  22.799  1.00 61.75           N  
ATOM  49185  CA  SER L 145      24.266  -0.459  23.852  1.00 61.75           C  
ATOM  49186  C   SER L 145      23.052   0.408  23.528  1.00 61.75           C  
ATOM  49187  O   SER L 145      21.930  -0.159  23.463  1.00 61.75           O  
ATOM  49188  CB  SER L 145      24.797   0.027  25.214  1.00 61.75           C  
ATOM  49189  OG  SER L 145      25.868  -0.797  25.648  1.00 61.75           O  
ATOM  49190  OXT SER L 145      23.228   1.646  23.354  1.00 61.75           O  
TER   49191      SER L 145                                                      
END
MOLECULE T0409.pdb
ATOM     14  N   TYR     1     -12.138  -6.437  34.342  1.00 26.71           N  
ATOM     15  CA  TYR     1     -10.769  -6.327  34.864  1.00 25.90           C  
ATOM     16  C   TYR     1     -10.498  -7.542  35.724  1.00 24.98           C  
ATOM     17  O   TYR     1     -11.355  -7.916  36.501  1.00 26.34           O  
ATOM     18  CB  TYR     1     -10.618  -5.047  35.686  1.00 24.63           C  
ATOM     19  CG  TYR     1      -9.168  -4.728  36.029  1.00 22.28           C  
ATOM     20  CD1 TYR     1      -8.285  -4.357  35.005  1.00 22.31           C  
ATOM     21  CD2 TYR     1      -8.664  -4.878  37.313  1.00 23.91           C  
ATOM     22  CE1 TYR     1      -6.951  -4.068  35.280  1.00 18.52           C  
ATOM     23  CE2 TYR     1      -7.324  -4.598  37.613  1.00 21.53           C  
ATOM     24  CZ  TYR     1      -6.480  -4.192  36.581  1.00 19.19           C  
ATOM     25  OH  TYR     1      -5.185  -3.925  36.888  1.00 18.14           O  
ATOM     26  N   ARG     2      -9.329  -8.164  35.541  1.00 24.27           N  
ATOM     27  CA  ARG     2      -8.922  -9.381  36.228  1.00 24.78           C  
ATOM     28  C   ARG     2      -7.920  -9.194  37.353  1.00 24.52           C  
ATOM     29  O   ARG     2      -7.621 -10.122  38.085  1.00 27.44           O  
ATOM     30  CB  ARG     2      -8.346 -10.374  35.215  1.00 23.92           C  
ATOM     31  CG  ARG     2      -9.347 -10.845  34.134  1.00 25.70           C  
ATOM     32  CD  ARG     2      -8.657 -11.765  33.135  1.00 25.52           C  
ATOM     33  NE  ARG     2      -7.696 -11.068  32.290  1.00 27.24           N  
ATOM     34  CZ  ARG     2      -8.028 -10.316  31.245  1.00 25.99           C  
ATOM     35  NH1 ARG     2      -7.092  -9.705  30.558  1.00 26.10           N  
ATOM     36  NH2 ARG     2      -9.305 -10.178  30.888  1.00 30.15           N  
ATOM     37  N   GLY     3      -7.404  -7.992  37.483  1.00 23.54           N  
ATOM     38  CA  GLY     3      -6.475  -7.700  38.540  1.00 21.96           C  
ATOM     39  C   GLY     3      -5.048  -7.714  38.006  1.00 20.01           C  
ATOM     40  O   GLY     3      -4.763  -8.208  36.927  1.00 19.98           O  
ATOM     41  N   PRO     4      -4.121  -7.183  38.794  1.00 18.75           N  
ATOM     42  CA  PRO     4      -2.718  -7.124  38.362  1.00 17.90           C  
ATOM     43  C   PRO     4      -2.069  -8.474  38.133  1.00 17.43           C  
ATOM     44  O   PRO     4      -2.332  -9.438  38.886  1.00 17.86           O  
ATOM     45  CB  PRO     4      -1.998  -6.462  39.555  1.00 17.83           C  
ATOM     46  CG  PRO     4      -3.078  -5.804  40.295  1.00 17.56           C  
ATOM     47  CD  PRO     4      -4.293  -6.604  40.137  1.00 20.04           C  
ATOM     48  N   GLU     5      -1.198  -8.523  37.136  1.00 16.41           N  
ATOM     49  CA  GLU     5      -0.494  -9.734  36.776  1.00 16.74           C  
ATOM     50  C   GLU     5       0.555 -10.210  37.794  1.00 15.28           C  
ATOM     51  O   GLU     5       0.894 -11.399  37.821  1.00 14.56           O  
ATOM     52  CB  GLU     5       0.179  -9.574  35.415  1.00 18.28           C  
ATOM     53  CG  GLU     5       1.357  -8.668  35.384  1.00 18.86           C  
ATOM     54  CD  GLU     5       1.641  -8.109  33.976  1.00 21.65           C  
ATOM     55  OE1 GLU     5       0.838  -7.287  33.462  1.00 19.17           O  
ATOM     56  OE2 GLU     5       2.690  -8.452  33.404  1.00 20.12           O  
ATOM     57  N   ALA     6       1.090  -9.262  38.551  1.00 14.75           N  
ATOM     58  CA  ALA     6       2.230  -9.503  39.408  1.00 12.91           C  
ATOM     59  C   ALA     6       2.286  -8.383  40.423  1.00 13.86           C  
ATOM     60  O   ALA     6       1.662  -7.340  40.252  1.00 14.07           O  
ATOM     61  CB  ALA     6       3.557  -9.555  38.607  1.00 14.41           C  
ATOM     62  N   PHE     7       3.056  -8.616  41.463  1.00 12.90           N  
ATOM     63  CA  PHE     7       3.312  -7.619  42.514  1.00 12.74           C  
ATOM     64  C   PHE     7       4.803  -7.561  42.789  1.00 14.31           C  
ATOM     65  O   PHE     7       5.426  -8.577  43.064  1.00 16.10           O  
ATOM     66  CB  PHE     7       2.558  -7.975  43.774  1.00 12.84           C  
ATOM     67  CG  PHE     7       1.061  -7.980  43.588  1.00 13.25           C  
ATOM     68  CD1 PHE     7       0.432  -9.083  43.089  1.00 12.42           C  
ATOM     69  CD2 PHE     7       0.284  -6.851  43.907  1.00 13.57           C  
ATOM     70  CE1 PHE     7      -0.949  -9.101  42.892  1.00 15.56           C  
ATOM     71  CE2 PHE     7      -1.084  -6.875  43.732  1.00 14.79           C  
ATOM     72  CZ  PHE     7      -1.682  -7.984  43.198  1.00 14.93           C  
ATOM     73  N   LEU     8       5.379  -6.378  42.730  1.00 13.78           N  
ATOM     74  CA  LEU     8       6.799  -6.166  43.031  1.00 14.87           C  
ATOM     75  C   LEU     8       6.959  -5.587  44.431  1.00 17.18           C  
ATOM     76  O   LEU     8       6.012  -5.033  45.021  1.00 18.46           O  
ATOM     77  CB  LEU     8       7.409  -5.253  41.997  1.00 14.89           C  
ATOM     78  CG  LEU     8       7.096  -5.514  40.532  1.00 15.32           C  
ATOM     79  CD1 LEU     8       7.647  -4.518  39.513  1.00 16.20           C  
ATOM     80  CD2 LEU     8       7.592  -6.945  40.214  1.00 16.59           C  
ATOM     81  N   LYS     9       8.127  -5.818  45.005  1.00 17.65           N  
ATOM     82  CA  LYS     9       8.421  -5.348  46.361  1.00 19.07           C  
ATOM     83  C   LYS     9       9.052  -3.955  46.263  1.00 17.92           C  
ATOM     84  O   LYS     9      10.150  -3.798  45.727  1.00 18.25           O  
ATOM     85  CB  LYS     9       9.373  -6.314  47.042  1.00 19.67           C  
ATOM     86  CG  LYS     9       9.591  -5.980  48.493  1.00 23.14           C  
ATOM     87  CD  LYS     9      10.639  -6.886  49.072  1.00 24.83           C  
ATOM     88  CE  LYS     9      10.121  -8.265  49.428  1.00 32.25           C  
ATOM     89  NZ  LYS     9      10.917  -8.817  50.575  1.00 34.79           N  
ATOM     90  N   LEU    10       8.369  -2.926  46.749  1.00 18.72           N  
ATOM     91  CA  LEU    10       8.826  -1.580  46.551  1.00 18.81           C  
ATOM     92  C   LEU    10       9.942  -1.228  47.554  1.00 19.68           C  
ATOM     93  O   LEU    10      10.009  -1.815  48.647  1.00 20.89           O  
ATOM     94  CB  LEU    10       7.717  -0.560  46.770  1.00 20.05           C  
ATOM     95  CG  LEU    10       6.533  -0.547  45.822  1.00 19.19           C  
ATOM     96  CD1 LEU    10       5.473   0.394  46.436  1.00 24.82           C  
ATOM     97  CD2 LEU    10       6.945  -0.115  44.440  1.00 21.53           C  
ATOM     98  N   PRO    11      10.774  -0.268  47.163  1.00 20.13           N  
ATOM     99  CA  PRO    11      11.661   0.375  48.167  1.00 21.78           C  
ATOM    100  C   PRO    11      10.838   1.323  49.071  1.00 22.52           C  
ATOM    101  O   PRO    11       9.740   1.732  48.679  1.00 23.44           O  
ATOM    102  CB  PRO    11      12.607   1.193  47.285  1.00 20.85           C  
ATOM    103  CG  PRO    11      11.779   1.545  46.072  1.00 22.93           C  
ATOM    104  CD  PRO    11      10.970   0.307  45.828  1.00 19.70           C  
ATOM    105  N   LYS    12      11.406   1.739  50.229  1.00 25.61           N  
ATOM    106  CA  LYS    12      10.808   2.820  51.069  1.00 26.86           C  
ATOM    107  C   LYS    12      10.655   4.134  50.323  1.00 28.24           C  
ATOM    108  O   LYS    12       9.621   4.815  50.414  1.00 30.07           O  
ATOM    109  CB  LYS    12      11.725   3.141  52.244  1.00 27.78           C  
ATOM    110  CG  LYS    12      11.297   2.660  53.597  1.00 29.19           C  
ATOM    111  CD  LYS    12      12.113   3.300  54.688  1.00 28.24           C  
ATOM    112  CE  LYS    12      11.543   4.613  55.215  1.00 28.46           C  
ATOM    113  NZ  LYS    12      12.177   4.939  56.553  1.00 29.49           N  
ATOM    114  N   ASP    13      11.716   4.525  49.615  1.00 29.01           N  
ATOM    115  CA  ASP    13      11.746   5.788  48.876  1.00 29.32           C  
ATOM    116  C   ASP    13      11.132   5.663  47.484  1.00 30.39           C  
ATOM    117  O   ASP    13      11.712   5.127  46.535  1.00 29.19           O  
ATOM    118  CB  ASP    13      13.189   6.371  48.893  1.00 29.16           C  
ATOM    119  CG  ASP    13      13.347   7.664  48.082  1.00 30.92           C  
ATOM    120  OD1 ASP    13      12.344   8.274  47.628  1.00 34.61           O  
ATOM    121  OD2 ASP    13      14.529   8.080  47.888  1.00 32.69           O  
ATOM    122  N   LEU    14       9.920   6.195  47.363  1.00 30.90           N  
ATOM    123  CA  LEU    14       9.172   6.157  46.124  1.00 30.71           C  
ATOM    124  C   LEU    14       9.608   7.149  45.049  1.00 30.84           C  
ATOM    125  O   LEU    14       9.020   7.178  43.964  1.00 31.55           O  
ATOM    126  CB  LEU    14       7.678   6.329  46.424  1.00 30.89           C  
ATOM    127  CG  LEU    14       7.124   5.332  47.440  1.00 30.54           C  
ATOM    128  CD1 LEU    14       5.711   5.725  47.765  1.00 33.63           C  
ATOM    129  CD2 LEU    14       7.169   3.889  46.924  1.00 35.44           C  
ATOM    130  N   LYS    15      10.614   7.983  45.348  1.00 30.72           N  
ATOM    131  CA  LYS    15      11.255   8.810  44.324  1.00 30.73           C  
ATOM    132  C   LYS    15      12.623   8.265  43.901  1.00 29.76           C  
ATOM    133  O   LYS    15      13.272   8.865  43.053  1.00 30.87           O  
ATOM    134  CB  LYS    15      11.408  10.266  44.806  1.00 32.76           C  
ATOM    135  CG  LYS    15      10.232  11.196  44.418  1.00 35.47           C  
ATOM    136  CD  LYS    15       9.079  11.039  45.367  1.00 37.91           C  
ATOM    137  CE  LYS    15       9.288  11.906  46.603  1.00 39.30           C  
ATOM    138  NZ  LYS    15       8.302  11.581  47.681  1.00 39.71           N  
ATOM    139  N   ASP    16      13.046   7.133  44.481  1.00 27.99           N  
ATOM    140  CA  ASP    16      14.328   6.493  44.094  1.00 26.78           C  
ATOM    141  C   ASP    16      14.118   5.763  42.782  1.00 25.11           C  
ATOM    142  O   ASP    16      13.741   4.600  42.764  1.00 24.88           O  
ATOM    143  CB  ASP    16      14.802   5.533  45.171  1.00 25.55           C  
ATOM    144  CG  ASP    16      16.217   4.970  44.893  1.00 26.06           C  
ATOM    145  OD1 ASP    16      16.650   5.014  43.729  1.00 25.61           O  
ATOM    146  OD2 ASP    16      16.861   4.472  45.830  1.00 25.02           O  
ATOM    147  N   ARG    17      14.360   6.449  41.680  1.00 25.11           N  
ATOM    148  CA  ARG    17      14.118   5.904  40.359  1.00 24.25           C  
ATOM    149  C   ARG    17      14.973   4.689  40.041  1.00 23.79           C  
ATOM    150  O   ARG    17      14.497   3.729  39.431  1.00 22.80           O  
ATOM    151  CB  ARG    17      14.276   6.978  39.293  1.00 26.64           C  
ATOM    152  CG  ARG    17      13.323   8.136  39.528  1.00 30.06           C  
ATOM    153  CD  ARG    17      12.985   8.820  38.245  1.00 37.41           C  
ATOM    154  NE  ARG    17      14.129   9.542  37.706  1.00 40.97           N  
ATOM    155  CZ  ARG    17      14.150  10.097  36.499  1.00 43.91           C  
ATOM    156  NH1 ARG    17      13.094   9.997  35.685  1.00 45.45           N  
ATOM    157  NH2 ARG    17      15.241  10.749  36.096  1.00 45.78           N  
ATOM    158  N   GLU    18      16.227   4.705  40.494  1.00 22.85           N  
ATOM    159  CA  GLU    18      17.123   3.549  40.277  1.00 22.70           C  
ATOM    160  C   GLU    18      16.572   2.269  40.913  1.00 20.63           C  
ATOM    161  O   GLU    18      16.555   1.211  40.278  1.00 19.78           O  
ATOM    162  CB  GLU    18      18.500   3.848  40.866  1.00 23.30           C  
ATOM    163  CG  GLU    18      19.549   2.754  40.681  1.00 24.01           C  
ATOM    164  CD  GLU    18      20.941   3.182  41.148  1.00 26.13           C  
ATOM    165  OE1 GLU    18      21.200   3.135  42.381  1.00 31.97           O  
ATOM    166  OE2 GLU    18      21.761   3.558  40.278  1.00 30.80           O  
ATOM    167  N   ALA    19      16.146   2.364  42.159  1.00 18.69           N  
ATOM    168  CA  ALA    19      15.569   1.237  42.865  1.00 18.72           C  
ATOM    169  C   ALA    19      14.286   0.741  42.184  1.00 18.42           C  
ATOM    170  O   ALA    19      14.079  -0.477  42.073  1.00 18.40           O  
ATOM    171  CB  ALA    19      15.248   1.627  44.285  1.00 19.53           C  
ATOM    172  N   LEU    20      13.438   1.683  41.764  1.00 18.86           N  
ATOM    173  CA  LEU    20      12.198   1.346  41.088  1.00 18.10           C  
ATOM    174  C   LEU    20      12.479   0.694  39.747  1.00 18.59           C  
ATOM    175  O   LEU    20      11.826  -0.289  39.383  1.00 18.02           O  
ATOM    176  CB  LEU    20      11.269   2.570  40.902  1.00 19.62           C  
ATOM    177  CG  LEU    20      10.779   3.123  42.243  1.00 19.47           C  
ATOM    178  CD1 LEU    20      10.171   4.490  42.063  1.00 25.48           C  
ATOM    179  CD2 LEU    20       9.776   2.141  42.919  1.00 20.59           C  
ATOM    180  N   GLN    21      13.439   1.212  38.971  1.00 17.08           N  
ATOM    181  CA  GLN    21      13.818   0.563  37.701  0.60 17.52           C  
ATOM    183  C   GLN    21      14.339  -0.838  37.961  1.00 17.89           C  
ATOM    184  O   GLN    21      14.076  -1.788  37.220  1.00 17.69           O  
ATOM    185  CB  GLN    21      14.943   1.338  36.986  0.60 18.21           C  
ATOM    187  CG  GLN    21      14.503   2.626  36.329  0.60 18.89           C  
ATOM    189  CD  GLN    21      13.515   2.472  35.158  0.60 20.48           C  
ATOM    191  OE1 GLN    21      13.254   1.364  34.619  0.60 23.97           O  
ATOM    193  NE2 GLN    21      12.980   3.610  34.738  0.60 22.78           N  
ATOM    195  N   ASP    22      15.104  -0.995  39.034  1.00 16.55           N  
ATOM    196  CA  ASP    22      15.680  -2.315  39.349  1.00 17.02           C  
ATOM    197  C   ASP    22      14.611  -3.356  39.634  1.00 16.63           C  
ATOM    198  O   ASP    22      14.714  -4.505  39.156  1.00 16.75           O  
ATOM    199  CB  ASP    22      16.632  -2.228  40.544  1.00 17.24           C  
ATOM    200  CG  ASP    22      18.015  -1.694  40.162  1.00 19.16           C  
ATOM    201  OD1 ASP    22      18.327  -1.439  38.960  1.00 22.10           O  
ATOM    202  OD2 ASP    22      18.789  -1.547  41.118  1.00 23.09           O  
ATOM    203  N   ILE    23      13.551  -2.982  40.363  1.00 15.22           N  
ATOM    204  CA  ILE    23      12.501  -4.017  40.667  1.00 15.44           C  
ATOM    205  C   ILE    23      11.696  -4.359  39.393  1.00 15.80           C  
ATOM    206  O   ILE    23      11.130  -5.448  39.328  1.00 16.91           O  
ATOM    207  CB  ILE    23      11.538  -3.666  41.812  1.00 14.93           C  
ATOM    208  CG1 ILE    23      10.715  -2.400  41.496  1.00 16.08           C  
ATOM    209  CG2 ILE    23      12.349  -3.420  43.109  1.00 16.92           C  
ATOM    210  CD1 ILE    23       9.662  -2.083  42.539  1.00 18.45           C  
ATOM    211  N   MET    24      11.693  -3.454  38.407  1.00 16.35           N  
ATOM    212  CA  MET    24      11.001  -3.635  37.136  1.00 16.51           C  
ATOM    213  C   MET    24      11.870  -4.256  36.047  1.00 16.28           C  
ATOM    214  O   MET    24      11.426  -4.374  34.907  1.00 16.01           O  
ATOM    215  CB  MET    24      10.471  -2.276  36.650  1.00 16.46           C  
ATOM    216  CG  MET    24       9.476  -1.622  37.540  1.00 17.64           C  
ATOM    217  SD  MET    24       8.685  -0.053  36.632  0.80 26.05          SE  
ATOM    218  CE  MET    24       7.421  -0.860  35.445  1.00 24.41           C  
ATOM    219  N   GLN    25      13.092  -4.631  36.388  1.00 16.67           N  
ATOM    220  CA  GLN    25      14.070  -4.998  35.365  1.00 17.43           C  
ATOM    221  C   GLN    25      13.592  -6.036  34.353  1.00 16.67           C  
ATOM    222  O   GLN    25      14.004  -5.969  33.198  1.00 17.33           O  
ATOM    223  CB  GLN    25      15.374  -5.433  36.005  1.00 18.09           C  
ATOM    224  CG  GLN    25      15.329  -6.698  36.777  1.00 20.57           C  
ATOM    225  CD  GLN    25      16.656  -7.030  37.461  1.00 24.40           C  
ATOM    226  OE1 GLN    25      17.683  -6.382  37.193  1.00 30.15           O  
ATOM    227  NE2 GLN    25      16.631  -8.020  38.370  1.00 29.33           N  
ATOM    228  N   ASP    26      12.790  -7.013  34.797  1.00 15.34           N  
ATOM    229  CA  ASP    26      12.390  -8.124  33.918  1.00 15.72           C  
ATOM    230  C   ASP    26      11.142  -7.834  33.073  1.00 16.03           C  
ATOM    231  O   ASP    26      10.876  -8.602  32.131  1.00 16.34           O  
ATOM    232  CB  ASP    26      12.120  -9.391  34.723  1.00 15.05           C  
ATOM    233  CG  ASP    26      13.409 -10.027  35.326  1.00 18.38           C  
ATOM    234  OD1 ASP    26      14.527  -9.715  34.833  1.00 21.09           O  
ATOM    235  OD2 ASP    26      13.261 -10.859  36.262  1.00 21.86           O  
ATOM    236  N   ILE    27      10.434  -6.762  33.392  1.00 16.05           N  
ATOM    237  CA  ILE    27       9.093  -6.467  32.882  0.60 17.18           C  
ATOM    239  C   ILE    27       9.116  -5.228  31.989  1.00 17.24           C  
ATOM    240  O   ILE    27       9.908  -4.318  32.214  1.00 16.86           O  
ATOM    241  CB  ILE    27       8.122  -6.210  34.080  0.60 17.87           C  
ATOM    243  CG1 ILE    27       8.158  -7.384  35.052  0.60 18.38           C  
ATOM    245  CG2 ILE    27       6.684  -5.914  33.601  0.60 18.73           C  
ATOM    247  CD1 ILE    27       7.986  -8.690  34.409  0.60 20.09           C  
ATOM    249  N   GLY    28       8.241  -5.184  31.003  1.00 17.82           N  
ATOM    250  CA  GLY    28       8.066  -3.945  30.257  1.00 18.09           C  
ATOM    251  C   GLY    28       9.221  -3.577  29.353  1.00 18.07           C  
ATOM    252  O   GLY    28       9.365  -2.424  28.950  1.00 18.91           O  
ATOM    253  N   ASN    29      10.036  -4.547  28.983  1.00 18.26           N  
ATOM    254  CA  ASN    29      11.290  -4.211  28.309  1.00 18.83           C  
ATOM    255  C   ASN    29      11.112  -3.765  26.859  1.00 19.92           C  
ATOM    256  O   ASN    29      12.054  -3.163  26.287  1.00 23.13           O  
ATOM    257  CB  ASN    29      12.315  -5.308  28.491  1.00 19.12           C  
ATOM    258  CG  ASN    29      12.920  -5.252  29.901  1.00 18.82           C  
ATOM    259  OD1 ASN    29      13.210  -4.141  30.417  1.00 20.59           O  
ATOM    260  ND2 ASN    29      13.068  -6.410  30.534  1.00 20.14           N  
ATOM    261  N   SER    30       9.940  -3.996  26.289  1.00 19.51           N  
ATOM    262  CA  SER    30       9.638  -3.436  24.946  1.00 19.62           C  
ATOM    263  C   SER    30       8.833  -2.162  25.064  1.00 19.59           C  
ATOM    264  O   SER    30       8.467  -1.576  24.052  1.00 20.08           O  
ATOM    265  CB  SER    30       8.915  -4.467  24.077  1.00 20.71           C  
ATOM    266  OG  SER    30       7.714  -4.851  24.696  1.00 25.23           O  
ATOM    267  N   ASP    31       8.554  -1.688  26.286  1.00 19.24           N  
ATOM    268  CA  ASP    31       7.719  -0.480  26.428  1.00 19.48           C  
ATOM    269  C   ASP    31       8.399   0.728  25.751  1.00 19.11           C  
ATOM    270  O   ASP    31       9.607   0.921  25.855  1.00 18.28           O  
ATOM    271  CB  ASP    31       7.472  -0.170  27.903  1.00 19.32           C  
ATOM    272  CG  ASP    31       6.382  -1.059  28.540  1.00 20.97           C  
ATOM    273  OD1 ASP    31       5.838  -1.957  27.861  1.00 20.12           O  
ATOM    274  OD2 ASP    31       6.130  -0.786  29.749  1.00 20.60           O  
ATOM    275  N   ASP    32       7.573   1.496  25.059  1.00 19.06           N  
ATOM    276  CA  ASP    32       7.966   2.731  24.373  1.00 20.14           C  
ATOM    277  C   ASP    32       8.776   2.490  23.102  1.00 19.79           C  
ATOM    278  O   ASP    32       9.198   3.461  22.447  1.00 19.91           O  
ATOM    279  CB  ASP    32       8.712   3.674  25.293  1.00 20.73           C  
ATOM    280  CG  ASP    32       7.963   3.948  26.635  1.00 23.39           C  
ATOM    281  OD1 ASP    32       6.803   4.403  26.542  1.00 25.24           O  
ATOM    282  OD2 ASP    32       8.564   3.719  27.723  1.00 25.94           O  
ATOM    283  N   ILE    33       8.996   1.235  22.770  1.00 19.89           N  
ATOM    284  CA  ILE    33       9.673   0.832  21.522  1.00 20.20           C  
ATOM    285  C   ILE    33       8.565   0.449  20.573  1.00 20.72           C  
ATOM    286  O   ILE    33       7.960  -0.632  20.700  1.00 22.37           O  
ATOM    287  CB  ILE    33      10.677  -0.334  21.711  1.00 19.45           C  
ATOM    288  CG1 ILE    33      11.758   0.114  22.689  1.00 21.44           C  
ATOM    289  CG2 ILE    33      11.304  -0.710  20.329  1.00 20.56           C  
ATOM    290  CD1 ILE    33      12.772  -0.956  23.051  1.00 22.94           C  
ATOM    291  N   LEU    34       8.299   1.342  19.626  1.00 19.25           N  
ATOM    292  CA  LEU    34       7.087   1.314  18.818  1.00 17.77           C  
ATOM    293  C   LEU    34       7.338   0.882  17.390  1.00 18.40           C  
ATOM    294  O   LEU    34       8.388   1.119  16.839  1.00 18.47           O  
ATOM    295  CB  LEU    34       6.469   2.701  18.781  1.00 18.47           C  
ATOM    296  CG  LEU    34       6.267   3.371  20.125  1.00 19.72           C  
ATOM    297  CD1 LEU    34       5.545   4.684  19.944  1.00 22.67           C  
ATOM    298  CD2 LEU    34       5.548   2.434  21.132  1.00 21.13           C  
ATOM    299  N   ALA    35       6.348   0.240  16.797  1.00 18.57           N  
ATOM    300  CA  ALA    35       6.435  -0.175  15.394  1.00 17.19           C  
ATOM    301  C   ALA    35       6.217   1.030  14.494  1.00 17.33           C  
ATOM    302  O   ALA    35       5.387   1.913  14.741  1.00 18.24           O  
ATOM    303  CB  ALA    35       5.390  -1.293  15.057  1.00 19.13           C  
ATOM    304  N   ALA    36       6.928   1.044  13.360  1.00 17.01           N  
ATOM    305  CA  ALA    36       6.674   2.049  12.357  1.00 15.71           C  
ATOM    306  C   ALA    36       7.034   1.462  10.990  1.00 16.78           C  
ATOM    307  O   ALA    36       7.901   0.604  10.879  1.00 18.10           O  
ATOM    308  CB  ALA    36       7.457   3.343  12.596  1.00 17.58           C  
ATOM    309  N   VAL    37       6.370   1.955   9.975  1.00 15.62           N  
ATOM    310  CA  VAL    37       6.682   1.549   8.602  0.50 15.71           C  
ATOM    312  C   VAL    37       7.312   2.714   7.873  1.00 14.23           C  
ATOM    313  O   VAL    37       6.779   3.823   7.872  1.00 15.68           O  
ATOM    314  CB  VAL    37       5.451   1.037   7.797  0.50 15.29           C  
ATOM    316  CG1 VAL    37       4.346   2.086   7.714  0.50 16.13           C  
ATOM    318  CG2 VAL    37       5.858   0.619   6.389  0.50 16.06           C  
ATOM    320  N   VAL    38       8.435   2.456   7.238  1.00 14.86           N  
ATOM    321  CA  VAL    38       9.172   3.493   6.517  1.00 14.41           C  
ATOM    322  C   VAL    38       8.438   3.924   5.239  1.00 15.45           C  
ATOM    323  O   VAL    38       7.986   3.077   4.449  1.00 14.72           O  
ATOM    324  CB  VAL    38      10.630   3.065   6.225  1.00 15.18           C  
ATOM    325  CG1 VAL    38      11.345   4.116   5.259  1.00 14.75           C  
ATOM    326  CG2 VAL    38      11.387   2.893   7.574  1.00 15.41           C  
ATOM    327  N   LEU    39       8.293   5.236   5.093  1.00 14.89           N  
ATOM    328  CA  LEU    39       7.728   5.844   3.883  1.00 15.30           C  
ATOM    329  C   LEU    39       8.802   6.367   2.923  1.00 16.16           C  
ATOM    330  O   LEU    39       8.618   6.337   1.717  1.00 17.32           O  
ATOM    331  CB  LEU    39       6.793   7.008   4.266  1.00 16.91           C  
ATOM    332  CG  LEU    39       5.696   6.599   5.252  1.00 17.60           C  
ATOM    333  CD1 LEU    39       4.796   7.809   5.545  1.00 21.11           C  
ATOM    334  CD2 LEU    39       4.876   5.379   4.818  1.00 20.56           C  
ATOM    335  N   SER    40       9.878   6.946   3.451  1.00 16.45           N  
ATOM    336  CA  SER    40      10.967   7.414   2.684  1.00 16.91           C  
ATOM    337  C   SER    40      12.241   7.291   3.490  1.00 16.85           C  
ATOM    338  O   SER    40      12.195   7.364   4.707  1.00 15.68           O  
ATOM    339  CB  SER    40      10.726   8.848   2.271  1.00 18.60           C  
ATOM    340  OG  SER    40      10.878   9.725   3.348  1.00 19.69           O  
ATOM    341  N   ALA    41      13.376   7.151   2.802  1.00 16.13           N  
ATOM    342  CA  ALA    41      14.666   7.013   3.492  1.00 16.24           C  
ATOM    343  C   ALA    41      15.808   7.516   2.678  1.00 17.06           C  
ATOM    344  O   ALA    41      15.937   7.212   1.489  1.00 17.44           O  
ATOM    345  CB  ALA    41      14.932   5.590   3.873  1.00 16.02           C  
ATOM    346  N   THR    42      16.603   8.346   3.317  1.00 17.62           N  
ATOM    347  CA  THR    42      17.909   8.824   2.826  1.00 18.26           C  
ATOM    348  C   THR    42      18.903   8.767   3.996  1.00 18.56           C  
ATOM    349  O   THR    42      18.496   8.630   5.155  1.00 16.63           O  
ATOM    350  CB  THR    42      17.820  10.268   2.317  1.00 18.38           C  
ATOM    351  OG1 THR    42      17.681  11.157   3.433  1.00 21.26           O  
ATOM    352  CG2 THR    42      16.634  10.457   1.330  1.00 21.04           C  
ATOM    353  N   PRO    43      20.207   8.983   3.741  1.00 18.87           N  
ATOM    354  CA  PRO    43      21.125   9.006   4.879  1.00 18.55           C  
ATOM    355  C   PRO    43      20.851  10.148   5.880  1.00 18.56           C  
ATOM    356  O   PRO    43      21.326  10.095   7.044  1.00 20.67           O  
ATOM    357  CB  PRO    43      22.499   9.197   4.201  1.00 19.88           C  
ATOM    358  CG  PRO    43      22.329   8.653   2.885  1.00 19.28           C  
ATOM    359  CD  PRO    43      20.938   9.070   2.467  1.00 20.45           C  
ATOM    360  N   GLY    44      20.139  11.170   5.431  1.00 16.96           N  
ATOM    361  CA  GLY    44      19.835  12.346   6.269  1.00 17.33           C  
ATOM    362  C   GLY    44      18.471  12.343   6.932  1.00 16.12           C  
ATOM    363  O   GLY    44      18.259  13.110   7.843  1.00 16.70           O  
ATOM    364  N   ALA    45      17.521  11.522   6.465  1.00 15.44           N  
ATOM    365  CA  ALA    45      16.194  11.546   7.049  1.00 16.18           C  
ATOM    366  C   ALA    45      15.409  10.293   6.680  1.00 16.57           C  
ATOM    367  O   ALA    45      15.433   9.862   5.536  1.00 16.49           O  
ATOM    368  CB  ALA    45      15.445  12.726   6.525  1.00 16.54           C  
ATOM    369  N   VAL    46      14.702   9.747   7.648  1.00 16.15           N  
ATOM    370  CA  VAL    46      13.752   8.676   7.432  1.00 15.46           C  
ATOM    371  C   VAL    46      12.395   9.193   7.901  1.00 16.21           C  
ATOM    372  O   VAL    46      12.272   9.685   9.044  1.00 15.82           O  
ATOM    373  CB  VAL    46      14.173   7.440   8.255  1.00 14.79           C  
ATOM    374  CG1 VAL    46      13.059   6.405   8.283  1.00 16.16           C  
ATOM    375  CG2 VAL    46      15.520   6.906   7.736  1.00 15.90           C  
ATOM    376  N   GLU    47      11.375   9.063   7.045  1.00 16.26           N  
ATOM    377  CA  GLU    47       9.987   9.338   7.431  1.00 17.37           C  
ATOM    378  C   GLU    47       9.318   7.985   7.648  1.00 17.25           C  
ATOM    379  O   GLU    47       9.447   7.094   6.805  1.00 16.35           O  
ATOM    380  CB  GLU    47       9.240  10.078   6.308  1.00 18.76           C  
ATOM    381  CG  GLU    47       9.768  11.459   6.058  1.00 22.56           C  
ATOM    382  CD  GLU    47       8.728  12.493   5.613  1.00 27.08           C  
ATOM    383  OE1 GLU    47       7.596  12.140   5.191  1.00 32.70           O  
ATOM    384  OE2 GLU    47       9.093  13.699   5.695  1.00 39.15           O  
ATOM    385  N   ALA    48       8.608   7.831   8.751  1.00 15.79           N  
ATOM    386  CA  ALA    48       7.954   6.581   9.088  1.00 16.62           C  
ATOM    387  C   ALA    48       6.568   6.823   9.690  1.00 16.84           C  
ATOM    388  O   ALA    48       6.358   7.839  10.370  1.00 19.46           O  
ATOM    389  CB  ALA    48       8.843   5.735  10.026  1.00 17.11           C  
ATOM    390  N   PHE    49       5.635   5.922   9.429  1.00 16.37           N  
ATOM    391  CA  PHE    49       4.267   5.991   9.929  1.00 17.59           C  
ATOM    392  C   PHE    49       4.122   5.056  11.129  1.00 18.32           C  
ATOM    393  O   PHE    49       4.501   3.899  11.058  1.00 17.79           O  
ATOM    394  CB  PHE    49       3.296   5.544   8.820  1.00 17.85           C  
ATOM    395  CG  PHE    49       1.842   5.641   9.191  1.00 18.30           C  
ATOM    396  CD1 PHE    49       1.144   6.802   8.933  1.00 21.76           C  
ATOM    397  CD2 PHE    49       1.164   4.553   9.695  1.00 20.75           C  
ATOM    398  CE1 PHE    49      -0.227   6.916   9.249  1.00 20.36           C  
ATOM    399  CE2 PHE    49      -0.206   4.656  10.047  1.00 19.72           C  
ATOM    400  CZ  PHE    49      -0.881   5.839   9.796  1.00 22.60           C  
ATOM    401  N   ARG    50       3.636   5.563  12.253  1.00 19.08           N  
ATOM    402  CA  ARG    50       3.464   4.703  13.441  1.00 20.23           C  
ATOM    403  C   ARG    50       1.972   4.382  13.686  1.00 21.07           C  
ATOM    404  O   ARG    50       1.117   4.995  13.106  1.00 20.64           O  
ATOM    405  CB  ARG    50       4.134   5.305  14.688  1.00 22.94           C  
ATOM    406  CG  ARG    50       3.763   6.662  15.046  1.00 23.31           C  
ATOM    407  CD  ARG    50       4.729   7.128  16.134  1.00 22.13           C  
ATOM    408  NE  ARG    50       4.369   8.344  16.762  1.00 24.32           N  
ATOM    409  CZ  ARG    50       3.791   8.440  17.969  1.00 23.15           C  
ATOM    410  NH1 ARG    50       3.443   7.362  18.655  1.00 26.13           N  
ATOM    411  NH2 ARG    50       3.534   9.622  18.479  1.00 24.48           N  
ATOM    412  N   LYS    51       1.701   3.437  14.570  1.00 21.95           N  
ATOM    413  CA  LYS    51       0.329   2.957  14.793  1.00 22.96           C  
ATOM    414  C   LYS    51      -0.644   4.022  15.207  1.00 23.88           C  
ATOM    415  O   LYS    51      -1.836   3.907  14.899  1.00 27.15           O  
ATOM    416  CB  LYS    51       0.344   1.884  15.880  1.00 24.30           C  
ATOM    417  CG  LYS    51       0.928   0.570  15.440  1.00 26.87           C  
ATOM    418  CD  LYS    51      -0.058  -0.226  14.582  1.00 29.44           C  
ATOM    419  CE  LYS    51      -1.205  -0.890  15.358  1.00 30.13           C  
ATOM    420  NZ  LYS    51      -1.944  -1.954  14.526  1.00 28.19           N  
ATOM    421  N   ASN    52      -0.193   5.045  15.923  1.00 23.72           N  
ATOM    422  CA  ASN    52      -1.125   6.100  16.359  1.00 24.26           C  
ATOM    423  C   ASN    52      -1.538   7.030  15.207  1.00 24.17           C  
ATOM    424  O   ASN    52      -2.323   7.978  15.409  1.00 25.42           O  
ATOM    425  CB  ASN    52      -0.554   6.871  17.558  1.00 25.03           C  
ATOM    426  CG  ASN    52       0.317   8.020  17.160  1.00 24.42           C  
ATOM    427  OD1 ASN    52       0.962   7.983  16.114  1.00 25.79           O  
ATOM    428  ND2 ASN    52       0.299   9.079  17.951  1.00 26.65           N  
ATOM    429  N   GLY    53      -1.017   6.768  14.005  1.00 23.35           N  
ATOM    430  CA  GLY    53      -1.366   7.494  12.812  1.00 23.25           C  
ATOM    431  C   GLY    53      -0.460   8.670  12.473  1.00 22.61           C  
ATOM    432  O   GLY    53      -0.703   9.373  11.499  1.00 24.10           O  
ATOM    433  N   GLU    54       0.538   8.935  13.311  1.00 22.55           N  
ATOM    434  CA  GLU    54       1.405  10.054  13.034  0.50 22.38           C  
ATOM    436  C   GLU    54       2.587   9.612  12.165  1.00 21.93           C  
ATOM    437  O   GLU    54       3.020   8.453  12.207  1.00 20.56           O  
ATOM    438  CB  GLU    54       1.816  10.735  14.347  0.50 22.86           C  
ATOM    440  CG  GLU    54       0.597  11.429  14.982  0.50 23.21           C  
ATOM    442  CD  GLU    54       0.817  12.068  16.340  0.50 25.13           C  
ATOM    444  OE1 GLU    54       1.708  11.658  17.107  0.50 26.68           O  
ATOM    446  OE2 GLU    54       0.037  12.995  16.648  0.50 28.52           O  
ATOM    448  N   THR    55       3.045  10.538  11.335  1.00 21.52           N  
ATOM    449  CA  THR    55       4.233  10.331  10.508  1.00 21.28           C  
ATOM    450  C   THR    55       5.336  11.097  11.229  1.00 21.26           C  
ATOM    451  O   THR    55       5.202  12.280  11.575  1.00 24.07           O  
ATOM    452  CB  THR    55       4.059  10.775   9.067  1.00 22.75           C  
ATOM    453  OG1 THR    55       3.020   9.997   8.430  1.00 23.47           O  
ATOM    454  CG2 THR    55       5.373  10.586   8.283  1.00 23.69           C  
ATOM    455  N   ILE    56       6.388  10.377  11.530  1.00 18.81           N  
ATOM    456  CA  ILE    56       7.560  10.946  12.221  1.00 17.71           C  
ATOM    457  C   ILE    56       8.734  11.049  11.242  1.00 16.62           C  
ATOM    458  O   ILE    56       8.769  10.351  10.240  1.00 15.72           O  
ATOM    459  CB  ILE    56       7.998  10.101  13.463  1.00 16.48           C  
ATOM    460  CG1 ILE    56       8.324   8.643  13.102  1.00 18.49           C  
ATOM    461  CG2 ILE    56       6.891  10.128  14.560  1.00 20.69           C  
ATOM    462  CD1 ILE    56       8.915   7.805  14.252  1.00 18.71           C  
ATOM    463  N   ARG    57       9.641  11.970  11.557  1.00 17.01           N  
ATOM    464  CA  ARG    57      10.857  12.170  10.790  1.00 16.90           C  
ATOM    465  C   ARG    57      12.059  11.961  11.712  1.00 18.52           C  
ATOM    466  O   ARG    57      12.203  12.700  12.712  1.00 18.30           O  
ATOM    467  CB  ARG    57      10.877  13.578  10.175  1.00 18.21           C  
ATOM    468  CG  ARG    57      11.843  13.767   9.044  1.00 22.16           C  
ATOM    469  CD  ARG    57      11.482  15.091   8.275  1.00 22.79           C  
ATOM    470  NE  ARG    57      12.260  15.266   7.076  1.00 30.28           N  
ATOM    471  CZ  ARG    57      13.426  15.885   7.007  1.00 29.98           C  
ATOM    472  NH1 ARG    57      14.012  16.421   8.094  1.00 33.28           N  
ATOM    473  NH2 ARG    57      14.032  15.957   5.829  1.00 32.68           N  
ATOM    474  N   ILE    58      12.936  11.028  11.349  1.00 15.91           N  
ATOM    475  CA  ILE    58      14.128  10.653  12.155  1.00 15.94           C  
ATOM    476  C   ILE    58      15.335  11.194  11.407  1.00 16.27           C  
ATOM    477  O   ILE    58      15.485  10.933  10.213  1.00 14.90           O  
ATOM    478  CB  ILE    58      14.242   9.140  12.377  1.00 16.25           C  
ATOM    479  CG1 ILE    58      12.926   8.623  13.001  1.00 20.10           C  
ATOM    480  CG2 ILE    58      15.455   8.775  13.294  1.00 16.57           C  
ATOM    481  CD1 ILE    58      12.483   7.265  12.468  1.00 23.93           C  
ATOM    482  N   THR    59      16.197  11.910  12.141  1.00 14.89           N  
ATOM    483  CA  THR    59      17.358  12.593  11.568  1.00 14.15           C  
ATOM    484  C   THR    59      18.504  12.573  12.586  1.00 14.35           C  
ATOM    485  O   THR    59      18.307  12.162  13.715  1.00 14.11           O  
ATOM    486  CB  THR    59      17.069  14.081  11.229  1.00 14.81           C  
ATOM    487  OG1 THR    59      16.779  14.818  12.442  1.00 13.82           O  
ATOM    488  CG2 THR    59      15.872  14.174  10.256  1.00 14.18           C  
ATOM    489  N   GLY    60      19.662  13.078  12.202  1.00 13.00           N  
ATOM    490  CA  GLY    60      20.785  13.294  13.142  1.00 14.55           C  
ATOM    491  C   GLY    60      21.076  12.078  14.032  1.00 15.23           C  
ATOM    492  O   GLY    60      21.268  10.956  13.557  1.00 15.55           O  
ATOM    493  N   ASP    61      21.107  12.333  15.323  1.00 14.66           N  
ATOM    494  CA  ASP    61      21.464  11.288  16.310  1.00 15.90           C  
ATOM    495  C   ASP    61      20.544  10.072  16.200  1.00 16.16           C  
ATOM    496  O   ASP    61      20.988   8.929  16.399  1.00 16.88           O  
ATOM    497  CB  ASP    61      21.390  11.842  17.714  1.00 16.78           C  
ATOM    498  CG  ASP    61      22.453  12.862  18.020  1.00 19.80           C  
ATOM    499  OD1 ASP    61      23.417  13.063  17.234  1.00 23.93           O  
ATOM    500  OD2 ASP    61      22.320  13.459  19.136  1.00 27.40           O  
ATOM    501  N   GLY    62      19.269  10.299  15.862  1.00 13.92           N  
ATOM    502  CA  GLY    62      18.296   9.222  15.746  1.00 15.21           C  
ATOM    503  C   GLY    62      18.607   8.184  14.692  1.00 15.36           C  
ATOM    504  O   GLY    62      18.053   7.093  14.739  1.00 16.47           O  
ATOM    505  N   LEU    63      19.447   8.530  13.705  1.00 15.12           N  
ATOM    506  CA  LEU    63      19.813   7.633  12.637  1.00 14.66           C  
ATOM    507  C   LEU    63      21.161   6.929  12.860  1.00 16.62           C  
ATOM    508  O   LEU    63      21.553   6.092  12.067  1.00 17.65           O  
ATOM    509  CB  LEU    63      19.895   8.412  11.307  1.00 14.91           C  
ATOM    510  CG  LEU    63      18.610   9.028  10.816  1.00 14.93           C  
ATOM    511  CD1 LEU    63      18.872   9.730   9.475  1.00 16.30           C  
ATOM    512  CD2 LEU    63      17.484   7.995  10.686  1.00 15.68           C  
ATOM    513  N   LYS    64      21.879   7.292  13.912  1.00 15.36           N  
ATOM    514  CA  LYS    64      23.251   6.825  14.127  0.50 17.84           C  
ATOM    516  C   LYS    64      23.350   5.313  14.202  1.00 17.93           C  
ATOM    517  O   LYS    64      24.201   4.683  13.539  1.00 18.87           O  
ATOM    518  CB  LYS    64      23.803   7.419  15.421  0.50 18.24           C  
ATOM    520  CG  LYS    64      24.118   8.919  15.346  0.50 18.90           C  
ATOM    522  CD  LYS    64      24.682   9.481  16.677  0.50 21.52           C  
ATOM    524  CE  LYS    64      26.140   9.169  16.864  0.50 25.23           C  
ATOM    526  NZ  LYS    64      26.990   9.892  15.880  0.50 27.58           N  
ATOM    528  N   ALA    65      22.489   4.723  15.032  1.00 19.45           N  
ATOM    529  CA  ALA    65      22.573   3.266  15.255  1.00 19.45           C  
ATOM    530  C   ALA    65      22.318   2.519  13.970  1.00 20.13           C  
ATOM    531  O   ALA    65      22.956   1.506  13.706  1.00 21.80           O  
ATOM    532  CB  ALA    65      21.609   2.832  16.300  1.00 20.20           C  
ATOM    533  N   ALA    66      21.444   3.053  13.127  1.00 19.24           N  
ATOM    534  CA  ALA    66      21.020   2.427  11.875  1.00 20.12           C  
ATOM    535  C   ALA    66      21.899   2.739  10.641  1.00 20.14           C  
ATOM    536  O   ALA    66      21.545   2.431   9.497  1.00 19.93           O  
ATOM    537  CB  ALA    66      19.537   2.784  11.608  1.00 19.17           C  
ATOM    538  N   HIS    67      23.032   3.414  10.876  1.00 20.96           N  
ATOM    539  CA  HIS    67      23.874   3.973   9.798  1.00 22.50           C  
ATOM    540  C   HIS    67      24.131   3.057   8.595  1.00 22.69           C  
ATOM    541  O   HIS    67      23.989   3.483   7.437  1.00 23.41           O  
ATOM    542  CB  HIS    67      25.197   4.541  10.372  1.00 23.45           C  
ATOM    543  CG  HIS    67      26.126   3.542  11.028  1.00 26.82           C  
ATOM    544  ND1 HIS    67      25.899   2.978  12.266  1.00 32.13           N  
ATOM    545  CD2 HIS    67      27.348   3.080  10.635  1.00 30.02           C  
ATOM    546  CE1 HIS    67      26.898   2.169  12.582  1.00 33.51           C  
ATOM    547  NE2 HIS    67      27.792   2.218  11.610  1.00 33.86           N  
ATOM    548  N   ARG    68      24.408   1.803   8.879  1.00 23.67           N  
ATOM    549  CA  ARG    68      24.853   0.871   7.842  1.00 25.02           C  
ATOM    550  C   ARG    68      23.705   0.512   6.938  1.00 22.30           C  
ATOM    551  O   ARG    68      23.901   0.185   5.787  1.00 22.56           O  
ATOM    552  CB  ARG    68      25.434  -0.344   8.498  1.00 24.82           C  
ATOM    553  CG  ARG    68      26.707   0.042   9.249  1.00 30.85           C  
ATOM    554  CD  ARG    68      27.251  -1.030  10.152  1.00 31.45           C  
ATOM    555  NE  ARG    68      27.030  -2.400   9.701  1.00 37.79           N  
ATOM    556  CZ  ARG    68      27.584  -2.962   8.632  1.00 38.95           C  
ATOM    557  NH1 ARG    68      28.387  -2.272   7.823  1.00 41.74           N  
ATOM    558  NH2 ARG    68      27.322  -4.240   8.369  1.00 39.77           N  
ATOM    559  N   PHE    69      22.504   0.595   7.497  1.00 19.79           N  
ATOM    560  CA  PHE    69      21.286   0.350   6.733  1.00 19.43           C  
ATOM    561  C   PHE    69      20.734   1.541   5.979  1.00 19.65           C  
ATOM    562  O   PHE    69      19.701   1.423   5.340  1.00 19.12           O  
ATOM    563  CB  PHE    69      20.253  -0.281   7.668  1.00 18.19           C  
ATOM    564  CG  PHE    69      20.676  -1.645   8.125  1.00 18.08           C  
ATOM    565  CD1 PHE    69      21.572  -1.808   9.173  1.00 20.24           C  
ATOM    566  CD2 PHE    69      20.239  -2.769   7.441  1.00 18.30           C  
ATOM    567  CE1 PHE    69      21.988  -3.089   9.532  1.00 18.89           C  
ATOM    568  CE2 PHE    69      20.661  -4.045   7.806  1.00 20.19           C  
ATOM    569  CZ  PHE    69      21.524  -4.186   8.845  1.00 19.83           C  
ATOM    570  N   LEU    70      21.457   2.669   6.005  1.00 20.27           N  
ATOM    571  CA  LEU    70      21.095   3.866   5.245  1.00 22.90           C  
ATOM    572  C   LEU    70      22.208   4.335   4.308  1.00 25.29           C  
ATOM    573  O   LEU    70      22.002   5.257   3.520  1.00 26.73           O  
ATOM    574  CB  LEU    70      20.781   5.012   6.233  1.00 23.31           C  
ATOM    575  CG  LEU    70      19.562   4.755   7.119  1.00 21.31           C  
ATOM    576  CD1 LEU    70      19.661   5.653   8.378  1.00 24.18           C  
ATOM    577  CD2 LEU    70      18.328   5.018   6.305  1.00 20.23           C  
ATOM    578  N   SER    71      23.353   3.653   4.356  1.00 26.45           N  
ATOM    579  CA  SER    71      24.587   4.095   3.688  1.00 27.55           C  
ATOM    580  C   SER    71      24.781   3.559   2.280  1.00 28.74           C  
ATOM    581  O   SER    71      25.758   3.970   1.601  1.00 29.80           O  
ATOM    582  CB  SER    71      25.772   3.565   4.472  1.00 28.48           C  
ATOM    583  OG  SER    71      25.814   2.132   4.350  1.00 29.58           O  
ATOM    584  N   ASN    72      23.919   2.637   1.840  1.00 27.09           N  
ATOM    585  CA  ASN    72      24.109   1.939   0.546  0.50 27.05           C  
ATOM    587  C   ASN    72      25.380   1.091   0.533  1.00 26.48           C  
ATOM    588  O   ASN    72      25.998   0.890  -0.495  1.00 25.99           O  
ATOM    589  CB  ASN    72      24.106   2.893  -0.675  0.50 27.83           C  
ATOM    591  CG  ASN    72      22.703   3.159  -1.234  0.50 28.59           C  
ATOM    593  OD1 ASN    72      21.791   2.300  -1.198  0.50 32.27           O  
ATOM    595  ND2 ASN    72      22.528   4.359  -1.773  0.50 29.54           N  
ATOM    597  N   ASP    73      25.749   0.542   1.686  1.00 25.43           N  
ATOM    598  CA  ASP    73      26.875  -0.421   1.798  1.00 24.74           C  
ATOM    599  C   ASP    73      26.488  -1.639   0.942  1.00 23.75           C  
ATOM    600  O   ASP    73      25.420  -2.208   1.157  1.00 20.54           O  
ATOM    601  CB  ASP    73      27.027  -0.835   3.265  1.00 25.17           C  
ATOM    602  CG  ASP    73      28.020  -1.980   3.495  1.00 26.12           C  
ATOM    603  OD1 ASP    73      28.691  -2.475   2.569  1.00 30.99           O  
ATOM    604  OD2 ASP    73      28.101  -2.401   4.667  1.00 35.81           O  
ATOM    605  N   PRO    74      27.323  -2.022  -0.030  1.00 23.57           N  
ATOM    606  CA  PRO    74      26.905  -3.122  -0.921  1.00 24.30           C  
ATOM    607  C   PRO    74      26.670  -4.459  -0.231  1.00 24.84           C  
ATOM    608  O   PRO    74      25.870  -5.256  -0.709  1.00 26.45           O  
ATOM    609  CB  PRO    74      28.062  -3.203  -1.942  1.00 23.95           C  
ATOM    610  CG  PRO    74      28.658  -1.821  -1.905  1.00 24.58           C  
ATOM    611  CD  PRO    74      28.629  -1.482  -0.450  1.00 24.00           C  
ATOM    612  N   LYS    75      27.332  -4.708   0.891  1.00 25.11           N  
ATOM    613  CA  LYS    75      27.130  -5.948   1.623  1.00 26.59           C  
ATOM    614  C   LYS    75      25.736  -6.045   2.221  1.00 25.93           C  
ATOM    615  O   LYS    75      25.200  -7.135   2.361  1.00 27.46           O  
ATOM    616  CB  LYS    75      28.133  -6.079   2.757  1.00 27.40           C  
ATOM    617  CG  LYS    75      29.571  -6.266   2.291  1.00 30.20           C  
ATOM    618  CD  LYS    75      30.541  -6.071   3.457  1.00 30.42           C  
ATOM    619  CE  LYS    75      31.984  -6.045   2.995  1.00 33.03           C  
ATOM    620  NZ  LYS    75      32.892  -6.078   4.194  1.00 35.70           N  
ATOM    621  N   ILE    76      25.166  -4.913   2.601  1.00 23.73           N  
ATOM    622  CA  ILE    76      23.809  -4.916   3.141  1.00 23.46           C  
ATOM    623  C   ILE    76      22.796  -5.053   1.994  1.00 22.14           C  
ATOM    624  O   ILE    76      21.798  -5.755   2.127  1.00 20.70           O  
ATOM    625  CB  ILE    76      23.584  -3.686   4.022  1.00 24.00           C  
ATOM    626  CG1 ILE    76      24.357  -3.908   5.328  1.00 27.47           C  
ATOM    627  CG2 ILE    76      22.078  -3.476   4.336  1.00 23.08           C  
ATOM    628  CD1 ILE    76      24.772  -2.697   5.964  1.00 30.61           C  
ATOM    629  N   GLY    77      23.054  -4.389   0.872  1.00 21.67           N  
ATOM    630  CA  GLY    77      22.162  -4.511  -0.299  1.00 23.17           C  
ATOM    631  C   GLY    77      20.722  -4.151   0.019  1.00 23.16           C  
ATOM    632  O   GLY    77      20.499  -3.202   0.757  1.00 21.68           O  
ATOM    633  N   GLU    78      19.732  -4.918  -0.484  1.00 23.84           N  
ATOM    634  CA  GLU    78      18.312  -4.590  -0.222  1.00 24.68           C  
ATOM    635  C   GLU    78      17.813  -4.974   1.181  1.00 24.33           C  
ATOM    636  O   GLU    78      16.629  -4.789   1.473  1.00 25.22           O  
ATOM    637  CB  GLU    78      17.364  -5.168  -1.302  1.00 26.64           C  
ATOM    638  CG  GLU    78      17.418  -4.480  -2.675  1.00 29.65           C  
ATOM    639  CD  GLU    78      16.578  -3.175  -2.782  1.00 33.89           C  
ATOM    640  OE1 GLU    78      15.333  -3.239  -3.075  1.00 31.41           O  
ATOM    641  OE2 GLU    78      17.177  -2.079  -2.589  1.00 40.88           O  
ATOM    642  N   LYS    79      18.700  -5.410   2.079  1.00 22.93           N  
ATOM    643  CA  LYS    79      18.361  -5.427   3.493  1.00 23.03           C  
ATOM    644  C   LYS    79      18.274  -4.017   4.070  1.00 20.63           C  
ATOM    645  O   LYS    79      17.859  -3.837   5.206  1.00 20.01           O  
ATOM    646  CB  LYS    79      19.393  -6.225   4.292  1.00 23.69           C  
ATOM    647  CG  LYS    79      19.299  -7.709   3.999  1.00 26.92           C  
ATOM    648  CD  LYS    79      20.379  -8.489   4.748  1.00 28.53           C  
ATOM    649  CE  LYS    79      20.377  -9.959   4.320  1.00 31.81           C  
ATOM    650  NZ  LYS    79      21.343 -10.239   3.217  1.00 34.09           N  
ATOM    651  N   ARG    80      18.704  -3.024   3.298  1.00 21.12           N  
ATOM    652  CA  ARG    80      18.705  -1.639   3.757  1.00 20.87           C  
ATOM    653  C   ARG    80      17.293  -1.138   4.068  1.00 19.89           C  
ATOM    654  O   ARG    80      16.315  -1.671   3.561  1.00 20.87           O  
ATOM    655  CB  ARG    80      19.366  -0.719   2.751  1.00 21.02           C  
ATOM    656  CG  ARG    80      18.562  -0.475   1.551  1.00 22.63           C  
ATOM    657  CD  ARG    80      19.314   0.371   0.508  1.00 25.39           C  
ATOM    658  NE  ARG    80      18.437   0.440  -0.642  1.00 29.73           N  
ATOM    659  CZ  ARG    80      17.483   1.357  -0.864  1.00 32.12           C  
ATOM    660  NH1 ARG    80      17.229   2.386  -0.014  1.00 34.12           N  
ATOM    661  NH2 ARG    80      16.751   1.230  -1.965  1.00 29.96           N  
ATOM    662  N   ILE    81      17.237  -0.105   4.874  1.00 18.86           N  
ATOM    663  CA  ILE    81      15.997   0.629   5.137  1.00 18.98           C  
ATOM    664  C   ILE    81      15.544   1.319   3.844  1.00 19.21           C  
ATOM    665  O   ILE    81      16.338   2.004   3.173  1.00 21.40           O  
ATOM    666  CB  ILE    81      16.197   1.625   6.256  1.00 19.16           C  
ATOM    667  CG1 ILE    81      16.408   0.857   7.574  1.00 18.53           C  
ATOM    668  CG2 ILE    81      15.006   2.601   6.364  1.00 19.73           C  
ATOM    669  CD1 ILE    81      17.055   1.628   8.701  1.00 20.65           C  
ATOM    670  N   ARG    82      14.274   1.128   3.504  1.00 18.22           N  
ATOM    671  CA  ARG    82      13.688   1.557   2.209  0.50 17.65           C  
ATOM    673  C   ARG    82      12.182   1.643   2.425  1.00 17.73           C  
ATOM    674  O   ARG    82      11.660   1.090   3.399  1.00 16.98           O  
ATOM    675  CB  ARG    82      14.008   0.561   1.075  0.50 18.23           C  
ATOM    677  CG  ARG    82      13.015  -0.649   0.888  0.50 16.80           C  
ATOM    679  CD  ARG    82      13.220  -1.403  -0.465  0.50 17.15           C  
ATOM    681  NE  ARG    82      12.162  -2.396  -0.723  0.50 17.23           N  
ATOM    683  CZ  ARG    82      12.274  -3.709  -0.531  0.50 15.45           C  
ATOM    685  NH1 ARG    82      13.430  -4.257  -0.164  0.50 15.77           N  
ATOM    687  NH2 ARG    82      11.228  -4.497  -0.780  0.50 15.69           N  
ATOM    689  N   PRO    83      11.445   2.300   1.510  1.00 17.33           N  
ATOM    690  CA  PRO    83      10.002   2.307   1.757  1.00 16.91           C  
ATOM    691  C   PRO    83       9.361   0.934   1.945  1.00 16.61           C  
ATOM    692  O   PRO    83       9.564   0.019   1.119  1.00 17.77           O  
ATOM    693  CB  PRO    83       9.439   3.036   0.539  1.00 17.58           C  
ATOM    694  CG  PRO    83      10.548   3.837   0.051  1.00 16.41           C  
ATOM    695  CD  PRO    83      11.804   3.087   0.325  1.00 17.89           C  
ATOM    696  N   GLY    84       8.588   0.809   3.007  1.00 14.86           N  
ATOM    697  CA  GLY    84       7.959  -0.434   3.420  1.00 15.67           C  
ATOM    698  C   GLY    84       8.674  -1.152   4.541  1.00 15.52           C  
ATOM    699  O   GLY    84       8.121  -2.067   5.126  1.00 17.23           O  
ATOM    700  N   ALA    85       9.898  -0.737   4.843  1.00 15.34           N  
ATOM    701  CA  ALA    85      10.636  -1.389   5.913  1.00 15.80           C  
ATOM    702  C   ALA    85       9.875  -1.233   7.211  1.00 15.88           C  
ATOM    703  O   ALA    85       9.489  -0.137   7.570  1.00 16.97           O  
ATOM    704  CB  ALA    85      12.004  -0.790   6.026  1.00 15.08           C  
ATOM    705  N   LEU    86       9.720  -2.344   7.924  1.00 18.25           N  
ATOM    706  CA  LEU    86       9.190  -2.359   9.282  1.00 17.93           C  
ATOM    707  C   LEU    86      10.353  -2.152  10.253  1.00 18.43           C  
ATOM    708  O   LEU    86      11.299  -2.955  10.332  1.00 18.46           O  
ATOM    709  CB  LEU    86       8.472  -3.697   9.575  1.00 18.48           C  
ATOM    710  CG  LEU    86       7.905  -3.859  10.985  1.00 20.15           C  
ATOM    711  CD1 LEU    86       6.882  -2.777  11.316  1.00 23.23           C  
ATOM    712  CD2 LEU    86       7.327  -5.271  11.129  1.00 20.48           C  
ATOM    713  N   ILE    87      10.281  -1.045  10.979  1.00 17.40           N  
ATOM    714  CA  ILE    87      11.304  -0.664  11.971  1.00 17.79           C  
ATOM    715  C   ILE    87      10.691  -0.466  13.315  1.00 16.97           C  
ATOM    716  O   ILE    87       9.466  -0.472  13.474  1.00 18.03           O  
ATOM    717  CB  ILE    87      12.079   0.611  11.522  1.00 16.69           C  
ATOM    718  CG1 ILE    87      11.141   1.799  11.307  1.00 17.19           C  
ATOM    719  CG2 ILE    87      12.872   0.270  10.190  1.00 18.98           C  
ATOM    720  CD1 ILE    87      11.823   3.133  11.188  1.00 18.86           C  
ATOM    721  N   ARG    88      11.546  -0.259  14.292  1.00 16.37           N  
ATOM    722  CA  ARG    88      11.104   0.101  15.626  1.00 15.89           C  
ATOM    723  C   ARG    88      11.725   1.441  15.956  1.00 16.06           C  
ATOM    724  O   ARG    88      12.890   1.704  15.645  1.00 15.92           O  
ATOM    725  CB  ARG    88      11.551  -0.950  16.656  1.00 16.91           C  
ATOM    726  CG  ARG    88      11.052  -2.363  16.313  1.00 19.48           C  
ATOM    727  CD  ARG    88       9.563  -2.596  16.597  1.00 22.43           C  
ATOM    728  NE  ARG    88       9.195  -3.877  16.014  1.00 25.15           N  
ATOM    729  CZ  ARG    88       8.005  -4.465  16.140  1.00 24.03           C  
ATOM    730  NH1 ARG    88       7.064  -3.921  16.884  1.00 22.87           N  
ATOM    731  NH2 ARG    88       7.794  -5.626  15.506  1.00 26.11           N  
ATOM    732  N   VAL    89      10.947   2.244  16.646  1.00 16.11           N  
ATOM    733  CA  VAL    89      11.362   3.602  17.021  1.00 15.28           C  
ATOM    734  C   VAL    89      11.067   3.919  18.472  1.00 16.66           C  
ATOM    735  O   VAL    89      10.122   3.363  19.062  1.00 17.18           O  
ATOM    736  CB  VAL    89      10.672   4.637  16.105  1.00 15.17           C  
ATOM    737  CG1 VAL    89      11.089   4.396  14.673  1.00 16.98           C  
ATOM    738  CG2 VAL    89       9.155   4.521  16.206  1.00 17.06           C  
ATOM    739  N   LYS    90      11.848   4.847  19.017  1.00 16.96           N  
ATOM    740  CA  LYS    90      11.616   5.305  20.380  1.00 17.78           C  
ATOM    741  C   LYS    90      11.880   6.822  20.433  1.00 18.76           C  
ATOM    742  O   LYS    90      12.876   7.285  19.874  1.00 18.51           O  
ATOM    743  CB  LYS    90      12.577   4.566  21.301  1.00 18.95           C  
ATOM    744  CG  LYS    90      12.395   4.805  22.797  1.00 19.52           C  
ATOM    745  CD  LYS    90      13.376   3.969  23.591  1.00 22.77           C  
ATOM    746  CE  LYS    90      13.408   4.296  25.059  1.00 29.12           C  
ATOM    747  NZ  LYS    90      12.162   4.691  25.679  1.00 35.66           N  
ATOM    748  N   LYS    91      11.107   7.510  21.260  1.00 18.93           N  
ATOM    749  CA  LYS    91      11.228   8.949  21.424  1.00 19.03           C  
ATOM    750  C   LYS    91      12.187   9.212  22.587  1.00 19.84           C  
ATOM    751  O   LYS    91      11.983   8.683  23.701  1.00 20.14           O  
ATOM    752  CB  LYS    91       9.854   9.552  21.671  1.00 19.81           C  
ATOM    753  CG  LYS    91       9.830  11.072  21.577  1.00 20.93           C  
ATOM    754  CD  LYS    91       8.439  11.593  21.854  1.00 23.85           C  
ATOM    755  CE  LYS    91       8.249  13.016  21.413  1.00 30.64           C  
ATOM    756  NZ  LYS    91       6.944  13.499  21.917  1.00 34.58           N  
ATOM    757  N   THR    92      13.230   9.996  22.360  1.00 19.44           N  
ATOM    758  CA  THR    92      14.153  10.312  23.424  1.00 19.60           C  
ATOM    759  C   THR    92      13.562  11.349  24.389  1.00 18.84           C  
ATOM    760  O   THR    92      12.549  11.999  24.103  1.00 18.25           O  
ATOM    761  CB  THR    92      15.444  10.856  22.895  1.00 19.73           C  
ATOM    762  OG1 THR    92      15.176  12.183  22.388  1.00 21.01           O  
ATOM    763  CG2 THR    92      16.053   9.941  21.791  1.00 19.35           C  
ATOM    764  N   GLU    93      14.205  11.539  25.548  0.50 20.13           N  
ATOM    766  CA  GLU    93      13.705  12.522  26.511  0.50 20.76           C  
ATOM    768  C   GLU    93      13.826  13.956  25.987  0.50 19.67           C  
ATOM    770  O   GLU    93      13.197  14.874  26.521  0.50 19.80           O  
ATOM    772  CB  GLU    93      14.469  12.430  27.835  0.50 21.32           C  
ATOM    774  CG  GLU    93      14.239  11.166  28.623  0.50 23.98           C  
ATOM    776  CD  GLU    93      15.125  11.081  29.854  0.50 24.53           C  
ATOM    778  OE1 GLU    93      15.518   9.957  30.231  0.50 30.98           O  
ATOM    780  OE2 GLU    93      15.430  12.143  30.451  0.50 29.16           O  
ATOM    782  N   LYS    94      14.686  14.166  25.000  1.00 19.01           N  
ATOM    783  CA  LYS    94      14.783  15.473  24.385  1.00 18.39           C  
ATOM    784  C   LYS    94      13.725  15.668  23.293  1.00 16.81           C  
ATOM    785  O   LYS    94      13.533  16.802  22.866  1.00 18.00           O  
ATOM    786  CB  LYS    94      16.183  15.730  23.832  1.00 19.18           C  
ATOM    787  CG  LYS    94      17.248  15.787  24.880  1.00 21.72           C  
ATOM    788  CD  LYS    94      18.600  15.805  24.281  1.00 23.57           C  
ATOM    789  CE  LYS    94      19.662  15.916  25.368  1.00 26.08           C  
ATOM    790  NZ  LYS    94      21.041  15.663  24.797  1.00 29.86           N  
ATOM    791  N   GLY    95      13.022  14.605  22.914  1.00 16.22           N  
ATOM    792  CA  GLY    95      11.841  14.750  22.040  1.00 16.18           C  
ATOM    793  C   GLY    95      11.987  14.255  20.618  1.00 16.84           C  
ATOM    794  O   GLY    95      11.006  14.237  19.886  1.00 17.83           O  
ATOM    795  N   SER    96      13.182  13.851  20.222  1.00 16.29           N  
ATOM    796  CA  SER    96      13.410  13.388  18.856  1.00 15.32           C  
ATOM    797  C   SER    96      13.264  11.874  18.837  1.00 16.22           C  
ATOM    798  O   SER    96      13.576  11.174  19.825  1.00 15.94           O  
ATOM    799  CB  SER    96      14.825  13.781  18.368  1.00 15.41           C  
ATOM    800  OG  SER    96      15.042  15.172  18.223  1.00 17.04           O  
ATOM    801  N   TRP    97      12.799  11.328  17.709  1.00 15.27           N  
ATOM    802  CA  TRP    97      12.673   9.906  17.534  1.00 15.15           C  
ATOM    803  C   TRP    97      13.984   9.306  17.090  1.00 15.23           C  
ATOM    804  O   TRP    97      14.751   9.940  16.370  1.00 15.34           O  
ATOM    805  CB  TRP    97      11.574   9.586  16.500  1.00 16.75           C  
ATOM    806  CG  TRP    97      10.188   9.910  17.049  1.00 17.02           C  
ATOM    807  CD1 TRP    97       9.539  11.094  16.962  1.00 19.56           C  
ATOM    808  CD2 TRP    97       9.317   9.038  17.788  1.00 17.19           C  
ATOM    809  NE1 TRP    97       8.330  11.038  17.621  1.00 18.92           N  
ATOM    810  CE2 TRP    97       8.159   9.773  18.106  1.00 19.29           C  
ATOM    811  CE3 TRP    97       9.412   7.721  18.226  1.00 18.37           C  
ATOM    812  CZ2 TRP    97       7.109   9.234  18.854  1.00 20.16           C  
ATOM    813  CZ3 TRP    97       8.337   7.178  18.931  1.00 17.75           C  
ATOM    814  CH2 TRP    97       7.222   7.945  19.254  1.00 19.63           C  
ATOM    815  N   GLN    98      14.221   8.054  17.494  1.00 15.53           N  
ATOM    816  CA  GLN    98      15.374   7.289  17.078  0.50 15.84           C  
ATOM    818  C   GLN    98      14.962   5.908  16.599  1.00 15.82           C  
ATOM    819  O   GLN    98      13.994   5.322  17.111  1.00 16.55           O  
ATOM    820  CB  GLN    98      16.352   7.171  18.259  0.50 16.46           C  
ATOM    822  CG  GLN    98      15.755   6.389  19.416  0.50 17.45           C  
ATOM    824  CD  GLN    98      16.493   6.471  20.731  0.50 18.58           C  
ATOM    826  OE1 GLN    98      15.872   6.257  21.781  0.50 19.21           O  
ATOM    828  NE2 GLN    98      17.791   6.726  20.694  0.50 20.26           N  
ATOM    830  N   ILE    99      15.703   5.374  15.626  1.00 15.21           N  
ATOM    831  CA  ILE    99      15.526   3.998  15.150  1.00 15.51           C  
ATOM    832  C   ILE    99      16.314   3.078  16.081  1.00 16.61           C  
ATOM    833  O   ILE    99      17.548   3.215  16.279  1.00 16.58           O  
ATOM    834  CB  ILE    99      15.998   3.819  13.727  1.00 16.25           C  
ATOM    835  CG1 ILE    99      15.225   4.730  12.764  1.00 16.91           C  
ATOM    836  CG2 ILE    99      15.907   2.332  13.370  1.00 18.24           C  
ATOM    837  CD1 ILE    99      15.645   4.639  11.292  1.00 16.52           C  
ATOM    838  N   VAL   100      15.562   2.173  16.680  1.00 17.39           N  
ATOM    839  CA  VAL   100      16.095   1.202  17.630  1.00 18.63           C  
ATOM    840  C   VAL   100      15.672  -0.230  17.234  1.00 19.15           C  
ATOM    841  O   VAL   100      15.194  -0.468  16.147  1.00 17.97           O  
ATOM    842  CB  VAL   100      15.581   1.541  19.043  1.00 18.73           C  
ATOM    843  CG1 VAL   100      16.085   2.916  19.465  1.00 18.33           C  
ATOM    844  CG2 VAL   100      14.053   1.456  19.153  1.00 21.54           C  
ATOM    845  N   GLN   101      15.841  -1.182  18.141  1.00 21.54           N  
ATOM    846  CA  GLN   101      15.350  -2.538  17.848  1.00 22.47           C  
ATOM    847  C   GLN   101      14.877  -3.189  19.126  1.00 23.43           C  
ATOM    848  O   GLN   101      15.243  -2.736  20.207  1.00 23.82           O  
ATOM    849  CB  GLN   101      16.395  -3.345  17.139  1.00 23.76           C  
ATOM    850  CG  GLN   101      17.643  -3.604  17.930  1.00 23.42           C  
ATOM    851  CD  GLN   101      18.756  -4.193  17.109  1.00 24.69           C  
ATOM    852  OE1 GLN   101      18.587  -4.586  15.951  1.00 25.77           O  
ATOM    853  NE2 GLN   101      19.941  -4.248  17.713  1.00 30.47           N  
ATOM    854  N   LEU   102      14.003  -4.177  19.000  1.00 25.80           N  
ATOM    855  CA  LEU   102      13.433  -4.833  20.175  1.00 29.29           C  
ATOM    856  C   LEU   102      14.548  -5.593  20.875  1.00 30.90           C  
ATOM    857  O   LEU   102      15.441  -6.127  20.212  1.00 30.78           O  
ATOM    858  CB  LEU   102      12.266  -5.755  19.791  1.00 29.31           C  
ATOM    859  CG  LEU   102      10.972  -5.020  19.413  1.00 30.58           C  
ATOM    860  CD1 LEU   102       9.988  -5.946  18.738  1.00 31.16           C  
ATOM    861  CD2 LEU   102      10.360  -4.260  20.587  1.00 31.70           C  
ATOM    862  N   PRO   103      14.502  -5.653  22.228  1.00 32.79           N  
ATOM    863  CA  PRO   103      15.587  -6.344  22.947  1.00 33.77           C  
ATOM    864  C   PRO   103      15.589  -7.835  22.604  1.00 35.69           C  
ATOM    865  O   PRO   103      14.522  -8.422  22.400  1.00 36.77           O  
ATOM    866  CB  PRO   103      15.235  -6.128  24.423  1.00 34.74           C  
ATOM    867  CG  PRO   103      13.758  -5.776  24.444  1.00 34.13           C  
ATOM    868  CD  PRO   103      13.465  -5.114  23.135  1.00 33.44           C  
ATOM    869  OXT PRO   103      16.642  -8.473  22.459  1.00 37.09           O  
END
