
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  109 (  880),  selected  109 , name 2cwp_A
# Molecule2: number of CA atoms  103 (  801),  selected  103 , name T0409.pdb
# PARAMETERS: 2cwp_A.T0409.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     4_A      Y       1           -
LGA    E     5_A      R       2           -
LGA    -       -      G       3           -
LGA    -       -      P       4           -
LGA    -       -      E       5           -
LGA    -       -      A       6           -
LGA    -       -      F       7           -
LGA    -       -      L       8           -
LGA    -       -      K       9           -
LGA    -       -      L      10           -
LGA    -       -      P      11           -
LGA    -       -      K      12           -
LGA    -       -      D      13           -
LGA    -       -      L      14           -
LGA    -       -      K      15           -
LGA    -       -      D      16           -
LGA    -       -      R      17           -
LGA    -       -      E      18           -
LGA    L     6_A      A      19           #
LGA    -       -      L      20           -
LGA    -       -      Q      21           -
LGA    Y     7_A      D      22          2.652
LGA    D     8_A      I      23          3.089
LGA    V     9_A      M      24          2.935
LGA    -       -      Q      25           -
LGA    -       -      D      26           -
LGA    D    10_A      I      27          5.209
LGA    E    11_A      G      28           #
LGA    F    12_A      -       -           -
LGA    W    13_A      N      29          5.352
LGA    K    14_A      S      30           -
LGA    F    15_A      D      31          4.306
LGA    Q    16_A      D      32          0.478
LGA    M    17_A      I      33          0.921
LGA    K    18_A      L      34          1.067
LGA    V    19_A      A      35          0.782
LGA    G    20_A      A      36          0.516
LGA    L    21_A      V      37          0.438
LGA    V    22_A      V      38          0.920
LGA    K    23_A      L      39          0.745
LGA    K    24_A      S      40          0.885
LGA    A    25_A      A      41          1.100
LGA    E    26_A      T      42          1.262
LGA    K    27_A      P      43          1.980
LGA    I    28_A      G      44          2.302
LGA    K    29_A      -       -           -
LGA    R    30_A      -       -           -
LGA    T    31_A      -       -           -
LGA    K    32_A      -       -           -
LGA    K    33_A      -       -           -
LGA    L    34_A      -       -           -
LGA    I    35_A      -       -           -
LGA    K    36_A      A      45          1.505
LGA    L    37_A      V      46          1.122
LGA    I    38_A      E      47          0.846
LGA    V    39_A      A      48          1.086
LGA    D    40_A      F      49          0.245
LGA    F    41_A      R      50          0.291
LGA    G    42_A      K      51          2.925
LGA    N    43_A      N      52          2.405
LGA    -       -      G      53           -
LGA    E    44_A      E      54          1.126
LGA    E    45_A      T      55          1.325
LGA    R    46_A      I      56          1.055
LGA    T    47_A      R      57          1.353
LGA    I    48_A      I      58          1.537
LGA    V    49_A      T      59          2.739
LGA    -       -      G      60           -
LGA    -       -      D      61           -
LGA    -       -      G      62           -
LGA    T    50_A      L      63          0.544
LGA    G    51_A      K      64          1.869
LGA    -       -      A      65           -
LGA    I    52_A      A      66          3.827
LGA    A    53_A      H      67          3.275
LGA    D    54_A      R      68          4.979
LGA    Q    55_A      F      69           #
LGA    I    56_A      L      70          4.157
LGA    P    57_A      S      71          2.744
LGA    P    58_A      N      72           #
LGA    -       -      D      73           -
LGA    -       -      P      74           -
LGA    -       -      K      75           -
LGA    -       -      I      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    E    59_A      K      79           #
LGA    E    60_A      R      80          1.585
LGA    L    61_A      I      81          0.806
LGA    E    62_A      R      82          1.629
LGA    G    63_A      P      83          2.251
LGA    -       -      G      84           -
LGA    K    64_A      A      85          0.495
LGA    K    65_A      L      86          0.517
LGA    F    66_A      I      87          1.161
LGA    I    67_A      R      88          1.502
LGA    F    68_A      V      89          1.345
LGA    V    69_A      K      90          1.625
LGA    V    70_A      K      91          3.203
LGA    N    71_A      -       -           -
LGA    L    72_A      T      92          2.277
LGA    K    73_A      E      93          1.724
LGA    P    74_A      K      94          3.242
LGA    K    75_A      G      95          5.367
LGA    K    76_A      -       -           -
LGA    F    77_A      -       -           -
LGA    S    78_A      -       -           -
LGA    G    79_A      -       -           -
LGA    V    80_A      -       -           -
LGA    E    81_A      -       -           -
LGA    S    82_A      -       -           -
LGA    Q    83_A      S      96          2.625
LGA    G    84_A      W      97          1.574
LGA    M    85_A      Q      98          1.483
LGA    L    86_A      I      99          1.003
LGA    I    87_A      V     100          1.361
LGA    L    88_A      Q     101          4.138
LGA    A    89_A      -       -           -
LGA    E    90_A      -       -           -
LGA    T    91_A      -       -           -
LGA    E    92_A      -       -           -
LGA    D    93_A      -       -           -
LGA    G    94_A      -       -           -
LGA    K    95_A      -       -           -
LGA    V    96_A      -       -           -
LGA    Y    97_A      -       -           -
LGA    L    98_A      -       -           -
LGA    I    99_A      -       -           -
LGA    P   100_A      -       -           -
LGA    V   101_A      -       -           -
LGA    P   102_A      -       -           -
LGA    E   103_A      -       -           -
LGA    E   104_A      -       -           -
LGA    V   105_A      -       -           -
LGA    P   106_A      -       -           -
LGA    V   107_A      -       -           -
LGA    G   108_A      -       -           -
LGA    A   109_A      -       -           -
LGA    R   110_A      -       -           -
LGA    V   111_A      -       -           -
LGA    W   112_A      L     102           #
LGA    -       -      P     103           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  109  103    5.0     61    2.36     8.20     43.912     2.478

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.192144 * X  +   0.979447 * Y  +   0.061352 * Z  +   7.944829
  Y_new =  -0.843999 * X  +   0.133026 * Y  +   0.519586 * Z  +  10.177995
  Z_new =   0.500746 * X  +  -0.151616 * Y  +   0.852213 * Z  +  -2.225001 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.176067    2.965526  [ DEG:   -10.0879    169.9121 ]
  Theta =  -0.524460   -2.617133  [ DEG:   -30.0493   -149.9507 ]
  Phi   =  -1.346952    1.794641  [ DEG:   -77.1747    102.8253 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cwp_A                                        
REMARK     2: T0409.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cwp_A.T0409.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  109  103   5.0   61   2.36    8.20  43.912
REMARK  ---------------------------------------------------------- 
MOLECULE 2cwp_A
HEADER    LIGASE                                  23-JUN-05   2CWP              
TITLE     CRYSTAL STRUCTURE OF METRS RELATED PROTEIN FROM PYROCOCCUS            
TITLE    2 HORIKOSHII                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: METRS RELATED PROTEIN;                                     
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    METRS RELATED PROTEIN, PYROCOCCUS HORIKOSHII, STRUCTURAL              
KEYWDS   2 GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   3 RSGI, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND             
KEYWDS   4 FUNCTIONAL ANALYSES                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.MURAYAMA,M.KATO-MURAYAMA,M.SHIROUZU,S.YOKOYAMA,RIKEN                
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   23-DEC-05 2CWP    0                                                
JRNL        AUTH   K.MURAYAMA,M.KATO-MURAYAMA,M.SHIROUZU,S.YOKOYAMA             
JRNL        TITL   CRYSTAL STRUCTURE OF METRS RELATED PROTEIN FROM              
JRNL        TITL 2 PYROCOCCUS HORIKOSHII                                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
SEQRES   1 A  112  MET ASN TYR MET GLU LEU TYR ASP VAL ASP GLU PHE TRP          
SEQRES   2 A  112  LYS PHE GLN MET LYS VAL GLY LEU VAL LYS LYS ALA GLU          
SEQRES   3 A  112  LYS ILE LYS ARG THR LYS LYS LEU ILE LYS LEU ILE VAL          
SEQRES   4 A  112  ASP PHE GLY ASN GLU GLU ARG THR ILE VAL THR GLY ILE          
SEQRES   5 A  112  ALA ASP GLN ILE PRO PRO GLU GLU LEU GLU GLY LYS LYS          
SEQRES   6 A  112  PHE ILE PHE VAL VAL ASN LEU LYS PRO LYS LYS PHE SER          
SEQRES   7 A  112  GLY VAL GLU SER GLN GLY MET LEU ILE LEU ALA GLU THR          
SEQRES   8 A  112  GLU ASP GLY LYS VAL TYR LEU ILE PRO VAL PRO GLU GLU          
SEQRES   9 A  112  VAL PRO VAL GLY ALA ARG VAL TRP                              
FORMUL   2  HOH   *47(H2 O)                                                     
CRYST1   49.841   50.354   44.078  90.00  90.00  90.00 P 21 21 2     4          
ATOM      1  N   MET A   4      25.603  -7.570  38.148  1.00 64.78           N  
ATOM      2  CA  MET A   4      25.847  -6.152  37.757  1.00 71.18           C  
ATOM      3  C   MET A   4      24.540  -5.421  37.417  1.00 72.11           C  
ATOM      4  O   MET A   4      24.049  -5.487  36.288  1.00 74.87           O  
ATOM      5  CB  MET A   4      26.818  -6.099  36.567  1.00 72.98           C  
ATOM      6  CG  MET A   4      26.308  -6.751  35.285  1.00 79.30           C  
ATOM      7  SD  MET A   4      25.789  -8.477  35.489  1.00 91.15           S  
ATOM      8  CE  MET A   4      27.367  -9.358  35.152  1.00 81.41           C  
ATOM      9  N   GLU A   5      23.987  -4.729  38.411  1.00 68.45           N  
ATOM     10  CA  GLU A   5      22.741  -3.971  38.266  1.00 64.07           C  
ATOM     11  C   GLU A   5      21.591  -4.706  37.585  1.00 59.31           C  
ATOM     12  O   GLU A   5      21.623  -4.954  36.380  1.00 59.62           O  
ATOM     13  CB  GLU A   5      22.988  -2.655  37.510  1.00 64.94           C  
ATOM     14  CG  GLU A   5      23.703  -1.572  38.305  1.00 62.93           C  
ATOM     15  CD  GLU A   5      22.947  -1.153  39.553  1.00 60.02           C  
ATOM     16  OE1 GLU A   5      21.801  -0.660  39.437  1.00 53.67           O  
ATOM     17  OE2 GLU A   5      23.509  -1.320  40.655  1.00 55.62           O  
ATOM     18  N   LEU A   6      20.571  -5.040  38.368  1.00 49.99           N  
ATOM     19  CA  LEU A   6      19.385  -5.704  37.846  1.00 47.72           C  
ATOM     20  C   LEU A   6      18.198  -4.783  38.069  1.00 45.97           C  
ATOM     21  O   LEU A   6      18.029  -4.231  39.153  1.00 47.47           O  
ATOM     22  CB  LEU A   6      19.164  -7.041  38.546  1.00 42.89           C  
ATOM     23  CG  LEU A   6      20.195  -8.086  38.131  1.00 38.74           C  
ATOM     24  CD1 LEU A   6      19.929  -9.392  38.854  1.00 41.51           C  
ATOM     25  CD2 LEU A   6      20.136  -8.275  36.619  1.00 36.37           C  
ATOM     26  N   TYR A   7      17.381  -4.599  37.041  1.00 47.67           N  
ATOM     27  CA  TYR A   7      16.234  -3.710  37.162  1.00 44.79           C  
ATOM     28  C   TYR A   7      14.899  -4.426  37.195  1.00 45.35           C  
ATOM     29  O   TYR A   7      14.811  -5.627  36.956  1.00 44.35           O  
ATOM     30  CB  TYR A   7      16.245  -2.681  36.034  1.00 48.01           C  
ATOM     31  CG  TYR A   7      17.469  -1.797  36.044  1.00 53.87           C  
ATOM     32  CD1 TYR A   7      18.733  -2.312  35.738  1.00 56.22           C  
ATOM     33  CD2 TYR A   7      17.373  -0.454  36.394  1.00 55.59           C  
ATOM     34  CE1 TYR A   7      19.870  -1.509  35.783  1.00 58.86           C  
ATOM     35  CE2 TYR A   7      18.501   0.357  36.444  1.00 61.35           C  
ATOM     36  CZ  TYR A   7      19.747  -0.174  36.137  1.00 62.01           C  
ATOM     37  OH  TYR A   7      20.862   0.630  36.195  1.00 67.34           O  
ATOM     38  N   ASP A   8      13.855  -3.672  37.504  1.00 44.25           N  
ATOM     39  CA  ASP A   8      12.525  -4.225  37.585  1.00 48.49           C  
ATOM     40  C   ASP A   8      11.783  -4.023  36.265  1.00 48.52           C  
ATOM     41  O   ASP A   8      11.941  -3.001  35.601  1.00 41.66           O  
ATOM     42  CB  ASP A   8      11.775  -3.562  38.737  1.00 57.05           C  
ATOM     43  CG  ASP A   8      10.418  -4.177  38.971  1.00 68.63           C  
ATOM     44  OD1 ASP A   8       9.506  -3.949  38.145  1.00 72.27           O  
ATOM     45  OD2 ASP A   8      10.267  -4.902  39.979  1.00 75.64           O  
ATOM     46  N   VAL A   9      10.973  -5.015  35.903  1.00 49.70           N  
ATOM     47  CA  VAL A   9      10.198  -5.002  34.666  1.00 51.52           C  
ATOM     48  C   VAL A   9       9.368  -3.741  34.473  1.00 51.66           C  
ATOM     49  O   VAL A   9       9.319  -3.188  33.378  1.00 51.28           O  
ATOM     50  CB  VAL A   9       9.239  -6.203  34.609  1.00 52.48           C  
ATOM     51  CG1 VAL A   9       8.549  -6.252  33.267  1.00 53.36           C  
ATOM     52  CG2 VAL A   9       9.996  -7.481  34.858  1.00 58.45           C  
ATOM     53  N   ASP A  10       8.702  -3.288  35.531  1.00 54.79           N  
ATOM     54  CA  ASP A  10       7.867  -2.092  35.430  1.00 51.77           C  
ATOM     55  C   ASP A  10       8.714  -0.901  35.004  1.00 49.23           C  
ATOM     56  O   ASP A  10       8.235   0.009  34.322  1.00 47.69           O  
ATOM     57  CB  ASP A  10       7.175  -1.798  36.761  1.00 49.63           C  
ATOM     58  CG  ASP A  10       6.381  -2.984  37.279  1.00 56.97           C  
ATOM     59  OD1 ASP A  10       6.984  -3.895  37.898  1.00 57.29           O  
ATOM     60  OD2 ASP A  10       5.151  -3.014  37.060  1.00 61.43           O  
ATOM     61  N   GLU A  11       9.981  -0.914  35.402  1.00 44.68           N  
ATOM     62  CA  GLU A  11      10.878   0.164  35.033  1.00 46.28           C  
ATOM     63  C   GLU A  11      11.102   0.097  33.515  1.00 44.29           C  
ATOM     64  O   GLU A  11      11.124   1.121  32.840  1.00 46.96           O  
ATOM     65  CB  GLU A  11      12.206   0.018  35.769  1.00 49.60           C  
ATOM     66  CG  GLU A  11      13.086   1.245  35.684  1.00 60.60           C  
ATOM     67  CD  GLU A  11      12.607   2.377  36.578  1.00 62.18           C  
ATOM     68  OE1 GLU A  11      11.563   2.213  37.249  1.00 63.00           O  
ATOM     69  OE2 GLU A  11      13.282   3.431  36.613  1.00 62.90           O  
ATOM     70  N   PHE A  12      11.263  -1.112  32.983  1.00 40.58           N  
ATOM     71  CA  PHE A  12      11.469  -1.298  31.538  1.00 35.51           C  
ATOM     72  C   PHE A  12      10.210  -0.837  30.809  1.00 36.22           C  
ATOM     73  O   PHE A  12      10.283  -0.060  29.848  1.00 28.68           O  
ATOM     74  CB  PHE A  12      11.735  -2.784  31.235  1.00 36.24           C  
ATOM     75  CG  PHE A  12      11.966  -3.100  29.770  1.00 29.55           C  
ATOM     76  CD1 PHE A  12      13.003  -2.501  29.058  1.00 32.27           C  
ATOM     77  CD2 PHE A  12      11.168  -4.039  29.118  1.00 32.19           C  
ATOM     78  CE1 PHE A  12      13.245  -2.840  27.713  1.00 34.96           C  
ATOM     79  CE2 PHE A  12      11.396  -4.386  27.778  1.00 28.79           C  
ATOM     80  CZ  PHE A  12      12.435  -3.784  27.078  1.00 28.47           C  
ATOM     81  N   TRP A  13       9.065  -1.313  31.304  1.00 29.28           N  
ATOM     82  CA  TRP A  13       7.751  -1.018  30.744  1.00 36.93           C  
ATOM     83  C   TRP A  13       7.435   0.465  30.560  1.00 37.21           C  
ATOM     84  O   TRP A  13       6.522   0.809  29.815  1.00 37.09           O  
ATOM     85  CB  TRP A  13       6.645  -1.624  31.620  1.00 44.91           C  
ATOM     86  CG  TRP A  13       6.494  -3.133  31.613  1.00 48.67           C  
ATOM     87  CD1 TRP A  13       5.840  -3.888  32.553  1.00 52.55           C  
ATOM     88  CD2 TRP A  13       6.933  -4.051  30.607  1.00 49.12           C  
ATOM     89  NE1 TRP A  13       5.842  -5.210  32.194  1.00 43.98           N  
ATOM     90  CE2 TRP A  13       6.504  -5.340  31.003  1.00 49.68           C  
ATOM     91  CE3 TRP A  13       7.641  -3.914  29.410  1.00 52.17           C  
ATOM     92  CZ2 TRP A  13       6.761  -6.481  30.244  1.00 49.05           C  
ATOM     93  CZ3 TRP A  13       7.894  -5.050  28.656  1.00 54.63           C  
ATOM     94  CH2 TRP A  13       7.453  -6.316  29.077  1.00 54.28           C  
ATOM     95  N   LYS A  14       8.153   1.350  31.244  1.00 36.75           N  
ATOM     96  CA  LYS A  14       7.851   2.767  31.079  1.00 38.26           C  
ATOM     97  C   LYS A  14       8.322   3.267  29.714  1.00 36.84           C  
ATOM     98  O   LYS A  14       7.787   4.236  29.191  1.00 37.11           O  
ATOM     99  CB  LYS A  14       8.471   3.603  32.207  1.00 40.52           C  
ATOM    100  CG  LYS A  14       9.978   3.587  32.259  1.00 41.98           C  
ATOM    101  CD  LYS A  14      10.475   4.375  33.454  1.00 51.64           C  
ATOM    102  CE  LYS A  14      11.989   4.373  33.508  1.00 63.07           C  
ATOM    103  NZ  LYS A  14      12.522   5.350  34.497  1.00 66.63           N  
ATOM    104  N   PHE A  15       9.332   2.616  29.143  1.00 32.65           N  
ATOM    105  CA  PHE A  15       9.804   3.018  27.828  1.00 30.18           C  
ATOM    106  C   PHE A  15       8.847   2.428  26.800  1.00 35.72           C  
ATOM    107  O   PHE A  15       8.332   1.312  26.974  1.00 27.80           O  
ATOM    108  CB  PHE A  15      11.231   2.534  27.588  1.00 28.36           C  
ATOM    109  CG  PHE A  15      12.243   3.234  28.444  1.00 37.06           C  
ATOM    110  CD1 PHE A  15      12.420   2.868  29.775  1.00 43.87           C  
ATOM    111  CD2 PHE A  15      12.964   4.314  27.943  1.00 36.43           C  
ATOM    112  CE1 PHE A  15      13.297   3.571  30.594  1.00 42.02           C  
ATOM    113  CE2 PHE A  15      13.839   5.020  28.750  1.00 37.54           C  
ATOM    114  CZ  PHE A  15      14.006   4.649  30.079  1.00 43.20           C  
ATOM    115  N   GLN A  16       8.583   3.182  25.742  1.00 27.70           N  
ATOM    116  CA  GLN A  16       7.655   2.705  24.735  1.00 32.36           C  
ATOM    117  C   GLN A  16       8.276   2.474  23.387  1.00 29.28           C  
ATOM    118  O   GLN A  16       8.776   3.402  22.753  1.00 25.49           O  
ATOM    119  CB  GLN A  16       6.496   3.680  24.569  1.00 33.80           C  
ATOM    120  CG  GLN A  16       5.492   3.614  25.687  1.00 39.60           C  
ATOM    121  CD  GLN A  16       4.242   4.365  25.334  1.00 47.49           C  
ATOM    122  OE1 GLN A  16       4.244   5.596  25.258  1.00 52.37           O  
ATOM    123  NE2 GLN A  16       3.164   3.631  25.092  1.00 54.61           N  
ATOM    124  N   MET A  17       8.236   1.222  22.957  1.00 28.49           N  
ATOM    125  CA  MET A  17       8.762   0.850  21.654  1.00 25.69           C  
ATOM    126  C   MET A  17       7.552   0.426  20.833  1.00 24.19           C  
ATOM    127  O   MET A  17       6.672  -0.267  21.327  1.00 22.05           O  
ATOM    128  CB  MET A  17       9.760  -0.304  21.780  1.00 20.51           C  
ATOM    129  CG  MET A  17      10.980   0.043  22.606  1.00 25.51           C  
ATOM    130  SD  MET A  17      12.306  -1.181  22.531  1.00 23.64           S  
ATOM    131  CE  MET A  17      11.781  -2.357  23.836  1.00 21.07           C  
ATOM    132  N   LYS A  18       7.492   0.873  19.587  1.00 22.73           N  
ATOM    133  CA  LYS A  18       6.384   0.516  18.734  1.00 21.26           C  
ATOM    134  C   LYS A  18       6.908   0.180  17.353  1.00 20.88           C  
ATOM    135  O   LYS A  18       8.003   0.587  16.971  1.00 21.42           O  
ATOM    136  CB  LYS A  18       5.390   1.674  18.612  1.00 25.08           C  
ATOM    137  CG  LYS A  18       4.822   2.162  19.921  1.00 31.33           C  
ATOM    138  CD  LYS A  18       3.676   3.137  19.674  1.00 35.99           C  
ATOM    139  CE  LYS A  18       2.933   3.444  20.966  1.00 43.75           C  
ATOM    140  NZ  LYS A  18       1.645   4.167  20.696  1.00 47.49           N  
ATOM    141  N   VAL A  19       6.113  -0.571  16.609  1.00 16.75           N  
ATOM    142  CA  VAL A  19       6.475  -0.946  15.267  1.00 18.39           C  
ATOM    143  C   VAL A  19       6.193   0.257  14.389  1.00 23.28           C  
ATOM    144  O   VAL A  19       5.111   0.851  14.485  1.00 22.64           O  
ATOM    145  CB  VAL A  19       5.632  -2.121  14.817  1.00 19.80           C  
ATOM    146  CG1 VAL A  19       5.816  -2.362  13.343  1.00 18.29           C  
ATOM    147  CG2 VAL A  19       6.021  -3.357  15.643  1.00 23.62           C  
ATOM    148  N   GLY A  20       7.159   0.622  13.549  1.00 20.88           N  
ATOM    149  CA  GLY A  20       6.973   1.765  12.668  1.00 19.93           C  
ATOM    150  C   GLY A  20       7.376   1.456  11.245  1.00 22.73           C  
ATOM    151  O   GLY A  20       8.337   0.717  11.030  1.00 27.26           O  
ATOM    152  N   LEU A  21       6.646   2.006  10.270  1.00 25.07           N  
ATOM    153  CA  LEU A  21       6.952   1.785   8.853  1.00 24.82           C  
ATOM    154  C   LEU A  21       7.748   2.955   8.303  1.00 21.80           C  
ATOM    155  O   LEU A  21       7.314   4.098   8.387  1.00 23.78           O  
ATOM    156  CB  LEU A  21       5.660   1.622   8.034  1.00 25.89           C  
ATOM    157  CG  LEU A  21       5.802   1.739   6.503  1.00 29.47           C  
ATOM    158  CD1 LEU A  21       6.740   0.648   5.997  1.00 24.24           C  
ATOM    159  CD2 LEU A  21       4.407   1.619   5.832  1.00 24.52           C  
ATOM    160  N   VAL A  22       8.917   2.675   7.745  1.00 24.37           N  
ATOM    161  CA  VAL A  22       9.754   3.733   7.188  1.00 23.18           C  
ATOM    162  C   VAL A  22       9.202   4.180   5.832  1.00 24.48           C  
ATOM    163  O   VAL A  22       9.363   3.489   4.830  1.00 31.36           O  
ATOM    164  CB  VAL A  22      11.211   3.252   7.022  1.00 25.79           C  
ATOM    165  CG1 VAL A  22      12.061   4.355   6.379  1.00 19.16           C  
ATOM    166  CG2 VAL A  22      11.774   2.860   8.385  1.00 21.47           C  
ATOM    167  N   LYS A  23       8.534   5.327   5.818  1.00 26.28           N  
ATOM    168  CA  LYS A  23       7.950   5.866   4.594  1.00 32.35           C  
ATOM    169  C   LYS A  23       9.050   6.399   3.682  1.00 31.10           C  
ATOM    170  O   LYS A  23       9.045   6.155   2.479  1.00 30.78           O  
ATOM    171  CB  LYS A  23       6.974   6.987   4.923  1.00 27.98           C  
ATOM    172  CG  LYS A  23       5.700   6.522   5.601  1.00 36.60           C  
ATOM    173  CD  LYS A  23       4.866   5.686   4.649  1.00 45.11           C  
ATOM    174  CE  LYS A  23       3.380   5.890   4.903  1.00 48.76           C  
ATOM    175  NZ  LYS A  23       2.562   5.119   3.923  1.00 48.10           N  
ATOM    176  N   LYS A  24       9.994   7.118   4.271  1.00 34.65           N  
ATOM    177  CA  LYS A  24      11.103   7.674   3.519  1.00 37.95           C  
ATOM    178  C   LYS A  24      12.357   7.723   4.379  1.00 39.55           C  
ATOM    179  O   LYS A  24      12.287   7.863   5.607  1.00 39.71           O  
ATOM    180  CB  LYS A  24      10.764   9.081   3.020  1.00 36.94           C  
ATOM    181  CG  LYS A  24      11.952   9.764   2.365  1.00 51.66           C  
ATOM    182  CD  LYS A  24      11.560  10.966   1.539  1.00 52.18           C  
ATOM    183  CE  LYS A  24      12.702  11.331   0.618  1.00 55.33           C  
ATOM    184  NZ  LYS A  24      12.198  11.837  -0.678  1.00 56.32           N  
ATOM    185  N   ALA A  25      13.502   7.617   3.719  1.00 35.98           N  
ATOM    186  CA  ALA A  25      14.792   7.638   4.388  1.00 36.21           C  
ATOM    187  C   ALA A  25      15.828   8.279   3.471  1.00 32.98           C  
ATOM    188  O   ALA A  25      16.006   7.848   2.328  1.00 31.81           O  
ATOM    189  CB  ALA A  25      15.209   6.208   4.734  1.00 34.51           C  
ATOM    190  N   GLU A  26      16.501   9.312   3.960  1.00 27.74           N  
ATOM    191  CA  GLU A  26      17.524   9.979   3.160  1.00 31.86           C  
ATOM    192  C   GLU A  26      18.646  10.509   4.028  1.00 31.16           C  
ATOM    193  O   GLU A  26      18.415  10.995   5.134  1.00 31.12           O  
ATOM    194  CB  GLU A  26      16.921  11.130   2.342  1.00 34.35           C  
ATOM    195  CG  GLU A  26      16.037  12.076   3.146  1.00 44.80           C  
ATOM    196  CD  GLU A  26      15.755  13.383   2.415  1.00 49.24           C  
ATOM    197  OE1 GLU A  26      15.507  13.335   1.187  1.00 46.20           O  
ATOM    198  OE2 GLU A  26      15.777  14.453   3.075  1.00 44.80           O  
ATOM    199  N   LYS A  27      19.869  10.417   3.517  1.00 33.55           N  
ATOM    200  CA  LYS A  27      21.023  10.884   4.261  1.00 37.43           C  
ATOM    201  C   LYS A  27      20.828  12.354   4.595  1.00 35.90           C  
ATOM    202  O   LYS A  27      20.211  13.087   3.827  1.00 34.85           O  
ATOM    203  CB  LYS A  27      22.307  10.709   3.437  1.00 39.19           C  
ATOM    204  CG  LYS A  27      22.607   9.278   3.004  1.00 32.09           C  
ATOM    205  CD  LYS A  27      24.067   9.132   2.553  1.00 38.67           C  
ATOM    206  CE  LYS A  27      25.020   9.515   3.688  1.00 40.10           C  
ATOM    207  NZ  LYS A  27      26.421   9.085   3.475  1.00 37.50           N  
ATOM    208  N   ILE A  28      21.328  12.772   5.752  1.00 38.36           N  
ATOM    209  CA  ILE A  28      21.234  14.171   6.161  1.00 39.10           C  
ATOM    210  C   ILE A  28      22.446  14.868   5.542  1.00 38.90           C  
ATOM    211  O   ILE A  28      23.565  14.362   5.612  1.00 29.76           O  
ATOM    212  CB  ILE A  28      21.269  14.325   7.709  1.00 39.70           C  
ATOM    213  CG1 ILE A  28      19.986  13.753   8.316  1.00 33.62           C  
ATOM    214  CG2 ILE A  28      21.435  15.795   8.093  1.00 36.41           C  
ATOM    215  CD1 ILE A  28      19.859  13.976   9.813  1.00 36.87           C  
ATOM    216  N   LYS A  29      22.203  16.024   4.927  1.00 46.63           N  
ATOM    217  CA  LYS A  29      23.244  16.804   4.251  1.00 45.75           C  
ATOM    218  C   LYS A  29      24.447  17.118   5.135  1.00 42.83           C  
ATOM    219  O   LYS A  29      24.295  17.496   6.297  1.00 42.77           O  
ATOM    220  CB  LYS A  29      22.649  18.114   3.737  1.00 47.56           C  
ATOM    221  CG  LYS A  29      23.198  18.563   2.400  1.00 57.72           C  
ATOM    222  CD  LYS A  29      22.803  20.005   2.099  1.00 58.71           C  
ATOM    223  CE  LYS A  29      23.580  20.985   2.974  1.00 59.66           C  
ATOM    224  NZ  LYS A  29      23.284  22.408   2.651  1.00 61.36           N  
ATOM    225  N   ARG A  30      25.640  16.971   4.570  1.00 48.00           N  
ATOM    226  CA  ARG A  30      26.883  17.248   5.286  1.00 52.31           C  
ATOM    227  C   ARG A  30      27.177  16.296   6.434  1.00 50.06           C  
ATOM    228  O   ARG A  30      27.783  16.684   7.431  1.00 51.95           O  
ATOM    229  CB  ARG A  30      26.889  18.693   5.799  1.00 56.69           C  
ATOM    230  CG  ARG A  30      27.196  19.707   4.711  1.00 64.73           C  
ATOM    231  CD  ARG A  30      27.040  21.140   5.190  1.00 70.21           C  
ATOM    232  NE  ARG A  30      25.654  21.451   5.519  1.00 71.95           N  
ATOM    233  CZ  ARG A  30      25.108  22.658   5.398  1.00 72.03           C  
ATOM    234  NH1 ARG A  30      25.832  23.676   4.953  1.00 72.55           N  
ATOM    235  NH2 ARG A  30      23.831  22.842   5.713  1.00 71.50           N  
ATOM    236  N   THR A  31      26.735  15.050   6.290  1.00 47.67           N  
ATOM    237  CA  THR A  31      26.978  14.031   7.301  1.00 45.97           C  
ATOM    238  C   THR A  31      27.332  12.764   6.553  1.00 40.92           C  
ATOM    239  O   THR A  31      26.939  12.585   5.401  1.00 39.33           O  
ATOM    240  CB  THR A  31      25.727  13.752   8.165  1.00 47.68           C  
ATOM    241  OG1 THR A  31      24.851  12.860   7.464  1.00 41.88           O  
ATOM    242  CG2 THR A  31      24.986  15.049   8.459  1.00 48.70           C  
ATOM    243  N   LYS A  32      28.070  11.883   7.212  1.00 43.68           N  
ATOM    244  CA  LYS A  32      28.473  10.632   6.589  1.00 42.04           C  
ATOM    245  C   LYS A  32      27.709   9.449   7.157  1.00 39.85           C  
ATOM    246  O   LYS A  32      27.551   8.427   6.494  1.00 39.92           O  
ATOM    247  CB  LYS A  32      29.974  10.412   6.782  1.00 44.75           C  
ATOM    248  CG  LYS A  32      30.834  11.488   6.132  1.00 51.79           C  
ATOM    249  CD  LYS A  32      32.291  11.069   6.105  1.00 62.53           C  
ATOM    250  CE  LYS A  32      33.155  12.116   5.421  1.00 67.34           C  
ATOM    251  NZ  LYS A  32      34.576  11.684   5.323  1.00 68.40           N  
ATOM    252  N   LYS A  33      27.214   9.599   8.380  1.00 39.62           N  
ATOM    253  CA  LYS A  33      26.493   8.519   9.048  1.00 39.23           C  
ATOM    254  C   LYS A  33      25.008   8.757   9.307  1.00 36.14           C  
ATOM    255  O   LYS A  33      24.269   7.807   9.548  1.00 35.71           O  
ATOM    256  CB  LYS A  33      27.144   8.222  10.396  1.00 36.58           C  
ATOM    257  CG  LYS A  33      28.587   7.795  10.344  1.00 43.55           C  
ATOM    258  CD  LYS A  33      29.046   7.454  11.741  1.00 43.61           C  
ATOM    259  CE  LYS A  33      30.249   6.529  11.718  1.00 53.37           C  
ATOM    260  NZ  LYS A  33      30.558   6.045  13.097  1.00 51.53           N  
ATOM    261  N   LEU A  34      24.566  10.011   9.257  1.00 32.48           N  
ATOM    262  CA  LEU A  34      23.178  10.304   9.571  1.00 28.15           C  
ATOM    263  C   LEU A  34      22.153  10.081   8.482  1.00 28.86           C  
ATOM    264  O   LEU A  34      22.376  10.408   7.326  1.00 35.25           O  
ATOM    265  CB  LEU A  34      23.037  11.742  10.092  1.00 28.84           C  
ATOM    266  CG  LEU A  34      23.787  12.132  11.369  1.00 33.62           C  
ATOM    267  CD1 LEU A  34      23.202  13.446  11.884  1.00 39.43           C  
ATOM    268  CD2 LEU A  34      23.646  11.068  12.430  1.00 32.08           C  
ATOM    269  N   ILE A  35      21.020   9.511   8.877  1.00 30.74           N  
ATOM    270  CA  ILE A  35      19.908   9.273   7.964  1.00 24.64           C  
ATOM    271  C   ILE A  35      18.622   9.756   8.634  1.00 28.87           C  
ATOM    272  O   ILE A  35      18.349   9.432   9.801  1.00 23.87           O  
ATOM    273  CB  ILE A  35      19.729   7.773   7.626  1.00 26.78           C  
ATOM    274  CG1 ILE A  35      20.982   7.223   6.953  1.00 26.63           C  
ATOM    275  CG2 ILE A  35      18.523   7.591   6.720  1.00 25.56           C  
ATOM    276  CD1 ILE A  35      20.862   5.791   6.545  1.00 25.59           C  
ATOM    277  N   LYS A  36      17.841  10.540   7.899  1.00 30.51           N  
ATOM    278  CA  LYS A  36      16.574  11.039   8.415  1.00 33.19           C  
ATOM    279  C   LYS A  36      15.483  10.097   7.942  1.00 34.57           C  
ATOM    280  O   LYS A  36      15.429   9.744   6.763  1.00 31.18           O  
ATOM    281  CB  LYS A  36      16.278  12.446   7.894  1.00 37.59           C  
ATOM    282  CG  LYS A  36      15.069  13.100   8.563  1.00 39.67           C  
ATOM    283  CD  LYS A  36      14.909  14.556   8.132  1.00 46.54           C  
ATOM    284  CE  LYS A  36      13.950  14.701   6.961  1.00 49.09           C  
ATOM    285  NZ  LYS A  36      12.545  14.441   7.373  1.00 51.40           N  
ATOM    286  N   LEU A  37      14.629   9.675   8.867  1.00 30.51           N  
ATOM    287  CA  LEU A  37      13.543   8.773   8.530  1.00 33.18           C  
ATOM    288  C   LEU A  37      12.201   9.416   8.828  1.00 31.17           C  
ATOM    289  O   LEU A  37      12.057  10.156   9.799  1.00 37.74           O  
ATOM    290  CB  LEU A  37      13.639   7.489   9.358  1.00 34.97           C  
ATOM    291  CG  LEU A  37      14.949   6.701   9.393  1.00 40.31           C  
ATOM    292  CD1 LEU A  37      14.938   5.742  10.596  1.00 26.85           C  
ATOM    293  CD2 LEU A  37      15.127   5.959   8.080  1.00 32.00           C  
ATOM    294  N   ILE A  38      11.217   9.134   7.987  1.00 30.55           N  
ATOM    295  CA  ILE A  38       9.870   9.628   8.217  1.00 30.41           C  
ATOM    296  C   ILE A  38       9.160   8.308   8.471  1.00 28.82           C  
ATOM    297  O   ILE A  38       9.000   7.480   7.560  1.00 29.07           O  
ATOM    298  CB  ILE A  38       9.283  10.321   6.984  1.00 35.43           C  
ATOM    299  CG1 ILE A  38      10.123  11.554   6.647  1.00 38.16           C  
ATOM    300  CG2 ILE A  38       7.824  10.697   7.251  1.00 31.78           C  
ATOM    301  CD1 ILE A  38       9.704  12.254   5.368  1.00 47.56           C  
ATOM    302  N   VAL A  39       8.749   8.110   9.716  1.00 25.73           N  
ATOM    303  CA  VAL A  39       8.131   6.855  10.124  1.00 21.35           C  
ATOM    304  C   VAL A  39       6.662   6.959  10.471  1.00 21.49           C  
ATOM    305  O   VAL A  39       6.251   7.825  11.249  1.00 25.96           O  
ATOM    306  CB  VAL A  39       8.909   6.299  11.321  1.00 23.37           C  
ATOM    307  CG1 VAL A  39       8.431   4.904  11.684  1.00 22.39           C  
ATOM    308  CG2 VAL A  39      10.394   6.329  10.986  1.00 22.58           C  
ATOM    309  N   ASP A  40       5.882   6.055   9.889  1.00 20.84           N  
ATOM    310  CA  ASP A  40       4.443   5.984  10.099  1.00 25.09           C  
ATOM    311  C   ASP A  40       4.134   4.960  11.192  1.00 25.08           C  
ATOM    312  O   ASP A  40       4.381   3.774  10.996  1.00 27.17           O  
ATOM    313  CB  ASP A  40       3.768   5.554   8.787  1.00 36.70           C  
ATOM    314  CG  ASP A  40       2.249   5.441   8.905  1.00 37.83           C  
ATOM    315  OD1 ASP A  40       1.747   4.669   9.744  1.00 47.50           O  
ATOM    316  OD2 ASP A  40       1.548   6.127   8.143  1.00 53.78           O  
ATOM    317  N   PHE A  41       3.617   5.415  12.332  1.00 24.11           N  
ATOM    318  CA  PHE A  41       3.237   4.520  13.441  1.00 28.85           C  
ATOM    319  C   PHE A  41       1.724   4.293  13.498  1.00 32.16           C  
ATOM    320  O   PHE A  41       1.183   3.912  14.542  1.00 32.48           O  
ATOM    321  CB  PHE A  41       3.685   5.078  14.794  1.00 20.25           C  
ATOM    322  CG  PHE A  41       5.167   5.139  14.958  1.00 25.22           C  
ATOM    323  CD1 PHE A  41       5.868   6.297  14.655  1.00 24.10           C  
ATOM    324  CD2 PHE A  41       5.873   4.028  15.394  1.00 27.08           C  
ATOM    325  CE1 PHE A  41       7.246   6.351  14.785  1.00 24.61           C  
ATOM    326  CE2 PHE A  41       7.249   4.068  15.527  1.00 25.30           C  
ATOM    327  CZ  PHE A  41       7.941   5.236  15.220  1.00 25.30           C  
ATOM    328  N   GLY A  42       1.047   4.546  12.382  1.00 33.78           N  
ATOM    329  CA  GLY A  42      -0.393   4.360  12.330  1.00 38.43           C  
ATOM    330  C   GLY A  42      -1.183   5.618  12.631  1.00 41.22           C  
ATOM    331  O   GLY A  42      -1.713   6.257  11.725  1.00 40.47           O  
ATOM    332  N   ASN A  43      -1.249   5.975  13.912  1.00 47.13           N  
ATOM    333  CA  ASN A  43      -1.986   7.155  14.376  1.00 51.83           C  
ATOM    334  C   ASN A  43      -1.172   8.433  14.211  1.00 52.48           C  
ATOM    335  O   ASN A  43      -1.709   9.544  14.273  1.00 53.97           O  
ATOM    336  CB  ASN A  43      -2.329   7.006  15.859  1.00 54.43           C  
ATOM    337  CG  ASN A  43      -1.089   6.991  16.739  1.00 60.16           C  
ATOM    338  OD1 ASN A  43      -0.219   6.122  16.595  1.00 64.38           O  
ATOM    339  ND2 ASN A  43      -0.996   7.956  17.650  1.00 60.35           N  
ATOM    340  N   GLU A  44       0.130   8.276  14.023  1.00 45.95           N  
ATOM    341  CA  GLU A  44       0.993   9.430  13.876  1.00 43.99           C  
ATOM    342  C   GLU A  44       2.193   9.105  13.017  1.00 41.94           C  
ATOM    343  O   GLU A  44       2.495   7.941  12.747  1.00 35.19           O  
ATOM    344  CB  GLU A  44       1.480   9.909  15.245  1.00 43.64           C  
ATOM    345  CG  GLU A  44       2.369   8.903  15.950  1.00 47.37           C  
ATOM    346  CD  GLU A  44       2.949   9.429  17.252  1.00 55.88           C  
ATOM    347  OE1 GLU A  44       3.632   8.649  17.959  1.00 62.62           O  
ATOM    348  OE2 GLU A  44       2.727  10.619  17.568  1.00 56.67           O  
ATOM    349  N   GLU A  45       2.872  10.162  12.605  1.00 37.27           N  
ATOM    350  CA  GLU A  45       4.063  10.063  11.795  1.00 38.96           C  
ATOM    351  C   GLU A  45       5.139  10.750  12.617  1.00 37.00           C  
ATOM    352  O   GLU A  45       4.852  11.687  13.363  1.00 38.21           O  
ATOM    353  CB  GLU A  45       3.855  10.805  10.476  1.00 42.63           C  
ATOM    354  CG  GLU A  45       4.590  10.189   9.317  1.00 49.83           C  
ATOM    355  CD  GLU A  45       4.495  11.017   8.054  1.00 49.51           C  
ATOM    356  OE1 GLU A  45       4.967  12.183   8.068  1.00 44.17           O  
ATOM    357  OE2 GLU A  45       3.955  10.491   7.056  1.00 41.20           O  
ATOM    358  N   ARG A  46       6.374  10.282  12.509  1.00 35.01           N  
ATOM    359  CA  ARG A  46       7.454  10.895  13.269  1.00 31.58           C  
ATOM    360  C   ARG A  46       8.744  10.946  12.471  1.00 30.10           C  
ATOM    361  O   ARG A  46       8.970  10.136  11.571  1.00 33.72           O  
ATOM    362  CB  ARG A  46       7.678  10.127  14.566  1.00 33.80           C  
ATOM    363  CG  ARG A  46       6.389   9.701  15.210  1.00 42.89           C  
ATOM    364  CD  ARG A  46       6.583   9.305  16.649  1.00 52.43           C  
ATOM    365  NE  ARG A  46       7.040  10.432  17.450  1.00 58.14           N  
ATOM    366  CZ  ARG A  46       7.068  10.424  18.774  1.00 60.54           C  
ATOM    367  NH1 ARG A  46       6.659   9.345  19.428  1.00 62.88           N  
ATOM    368  NH2 ARG A  46       7.504  11.486  19.440  1.00 62.34           N  
ATOM    369  N   THR A  47       9.582  11.916  12.801  1.00 27.82           N  
ATOM    370  CA  THR A  47      10.860  12.080  12.140  1.00 31.50           C  
ATOM    371  C   THR A  47      11.888  11.500  13.072  1.00 31.49           C  
ATOM    372  O   THR A  47      12.002  11.918  14.227  1.00 28.46           O  
ATOM    373  CB  THR A  47      11.168  13.564  11.879  1.00 36.35           C  
ATOM    374  OG1 THR A  47      10.181  14.089  10.982  1.00 36.43           O  
ATOM    375  CG2 THR A  47      12.557  13.735  11.259  1.00 31.51           C  
ATOM    376  N   ILE A  48      12.634  10.523  12.571  1.00 32.44           N  
ATOM    377  CA  ILE A  48      13.639   9.864  13.380  1.00 30.86           C  
ATOM    378  C   ILE A  48      14.986   9.785  12.689  1.00 33.71           C  
ATOM    379  O   ILE A  48      15.091   9.334  11.548  1.00 34.73           O  
ATOM    380  CB  ILE A  48      13.170   8.438  13.760  1.00 32.78           C  
ATOM    381  CG1 ILE A  48      11.987   8.543  14.731  1.00 35.50           C  
ATOM    382  CG2 ILE A  48      14.332   7.634  14.355  1.00 32.22           C  
ATOM    383  CD1 ILE A  48      11.340   7.225  15.089  1.00 20.97           C  
ATOM    384  N   VAL A  49      16.018  10.221  13.402  1.00 31.20           N  
ATOM    385  CA  VAL A  49      17.373  10.191  12.884  1.00 30.51           C  
ATOM    386  C   VAL A  49      18.141   8.973  13.422  1.00 28.48           C  
ATOM    387  O   VAL A  49      18.035   8.629  14.600  1.00 26.99           O  
ATOM    388  CB  VAL A  49      18.124  11.491  13.272  1.00 32.11           C  
ATOM    389  CG1 VAL A  49      19.550  11.456  12.740  1.00 27.43           C  
ATOM    390  CG2 VAL A  49      17.373  12.706  12.727  1.00 27.45           C  
ATOM    391  N   THR A  50      18.893   8.319  12.542  1.00 28.86           N  
ATOM    392  CA  THR A  50      19.723   7.168  12.905  1.00 27.81           C  
ATOM    393  C   THR A  50      21.085   7.413  12.245  1.00 27.29           C  
ATOM    394  O   THR A  50      21.147   7.957  11.146  1.00 32.91           O  
ATOM    395  CB  THR A  50      19.113   5.832  12.389  1.00 28.13           C  
ATOM    396  OG1 THR A  50      19.944   4.737  12.787  1.00 24.63           O  
ATOM    397  CG2 THR A  50      19.000   5.847  10.872  1.00 24.89           C  
ATOM    398  N   GLY A  51      22.175   7.028  12.902  1.00 25.83           N  
ATOM    399  CA  GLY A  51      23.489   7.272  12.328  1.00 25.63           C  
ATOM    400  C   GLY A  51      24.225   6.022  11.884  1.00 27.95           C  
ATOM    401  O   GLY A  51      25.339   5.765  12.323  1.00 33.43           O  
ATOM    402  N   ILE A  52      23.624   5.263  10.978  1.00 28.06           N  
ATOM    403  CA  ILE A  52      24.222   4.020  10.514  1.00 24.60           C  
ATOM    404  C   ILE A  52      24.614   4.040   9.042  1.00 29.96           C  
ATOM    405  O   ILE A  52      25.091   3.028   8.526  1.00 28.99           O  
ATOM    406  CB  ILE A  52      23.229   2.845  10.746  1.00 26.28           C  
ATOM    407  CG1 ILE A  52      21.939   3.101   9.956  1.00 25.07           C  
ATOM    408  CG2 ILE A  52      22.912   2.719  12.235  1.00 21.91           C  
ATOM    409  CD1 ILE A  52      20.758   2.189  10.314  1.00 28.21           C  
ATOM    410  N   ALA A  53      24.441   5.192   8.383  1.00 28.99           N  
ATOM    411  CA  ALA A  53      24.720   5.345   6.947  1.00 30.17           C  
ATOM    412  C   ALA A  53      26.082   4.874   6.441  1.00 28.83           C  
ATOM    413  O   ALA A  53      26.257   4.660   5.254  1.00 33.15           O  
ATOM    414  CB  ALA A  53      24.484   6.803   6.523  1.00 28.98           C  
ATOM    415  N   ASP A  54      27.052   4.725   7.324  1.00 30.82           N  
ATOM    416  CA  ASP A  54      28.366   4.271   6.899  1.00 34.56           C  
ATOM    417  C   ASP A  54      28.349   2.750   6.738  1.00 35.74           C  
ATOM    418  O   ASP A  54      29.236   2.174   6.102  1.00 30.41           O  
ATOM    419  CB  ASP A  54      29.404   4.666   7.944  1.00 43.61           C  
ATOM    420  CG  ASP A  54      29.052   4.139   9.312  1.00 46.12           C  
ATOM    421  OD1 ASP A  54      27.841   4.140   9.632  1.00 46.00           O  
ATOM    422  OD2 ASP A  54      29.969   3.729  10.058  1.00 49.28           O  
ATOM    423  N   GLN A  55      27.335   2.110   7.324  1.00 29.21           N  
ATOM    424  CA  GLN A  55      27.194   0.661   7.259  1.00 26.26           C  
ATOM    425  C   GLN A  55      25.912   0.212   6.577  1.00 27.21           C  
ATOM    426  O   GLN A  55      25.894  -0.815   5.919  1.00 27.43           O  
ATOM    427  CB  GLN A  55      27.209   0.060   8.660  1.00 23.04           C  
ATOM    428  CG  GLN A  55      28.515   0.218   9.399  1.00 29.47           C  
ATOM    429  CD  GLN A  55      28.553  -0.660  10.630  1.00 31.01           C  
ATOM    430  OE1 GLN A  55      28.326  -1.869  10.538  1.00 22.41           O  
ATOM    431  NE2 GLN A  55      28.826  -0.059  11.792  1.00 21.40           N  
ATOM    432  N   ILE A  56      24.842   0.983   6.749  1.00 28.63           N  
ATOM    433  CA  ILE A  56      23.538   0.637   6.187  1.00 30.93           C  
ATOM    434  C   ILE A  56      22.976   1.748   5.308  1.00 30.57           C  
ATOM    435  O   ILE A  56      22.578   2.796   5.808  1.00 37.63           O  
ATOM    436  CB  ILE A  56      22.507   0.369   7.317  1.00 27.86           C  
ATOM    437  CG1 ILE A  56      23.029  -0.698   8.287  1.00 28.21           C  
ATOM    438  CG2 ILE A  56      21.178  -0.042   6.711  1.00 23.72           C  
ATOM    439  CD1 ILE A  56      23.130  -2.099   7.686  1.00 40.88           C  
ATOM    440  N   PRO A  57      22.910   1.529   3.987  1.00 30.12           N  
ATOM    441  CA  PRO A  57      22.376   2.576   3.113  1.00 26.97           C  
ATOM    442  C   PRO A  57      20.879   2.813   3.327  1.00 26.89           C  
ATOM    443  O   PRO A  57      20.145   1.909   3.718  1.00 31.58           O  
ATOM    444  CB  PRO A  57      22.694   2.051   1.713  1.00 27.57           C  
ATOM    445  CG  PRO A  57      22.556   0.574   1.892  1.00 31.18           C  
ATOM    446  CD  PRO A  57      23.284   0.336   3.210  1.00 28.79           C  
ATOM    447  N   PRO A  58      20.414   4.041   3.056  1.00 26.64           N  
ATOM    448  CA  PRO A  58      19.020   4.481   3.196  1.00 27.59           C  
ATOM    449  C   PRO A  58      17.988   3.585   2.513  1.00 28.71           C  
ATOM    450  O   PRO A  58      16.916   3.333   3.073  1.00 28.04           O  
ATOM    451  CB  PRO A  58      19.036   5.887   2.593  1.00 26.89           C  
ATOM    452  CG  PRO A  58      20.426   6.350   2.848  1.00 30.49           C  
ATOM    453  CD  PRO A  58      21.257   5.136   2.537  1.00 27.64           C  
ATOM    454  N   GLU A  59      18.308   3.104   1.315  1.00 24.02           N  
ATOM    455  CA  GLU A  59      17.382   2.257   0.583  1.00 30.43           C  
ATOM    456  C   GLU A  59      17.130   0.901   1.248  1.00 31.35           C  
ATOM    457  O   GLU A  59      16.196   0.184   0.883  1.00 30.15           O  
ATOM    458  CB  GLU A  59      17.840   2.069  -0.884  1.00 33.34           C  
ATOM    459  CG  GLU A  59      19.124   1.281  -1.111  1.00 33.16           C  
ATOM    460  CD  GLU A  59      20.396   2.143  -1.075  1.00 35.06           C  
ATOM    461  OE1 GLU A  59      21.469   1.611  -1.450  1.00 26.06           O  
ATOM    462  OE2 GLU A  59      20.327   3.333  -0.676  1.00 32.35           O  
ATOM    463  N   GLU A  60      17.950   0.538   2.228  1.00 28.32           N  
ATOM    464  CA  GLU A  60      17.724  -0.723   2.915  1.00 25.32           C  
ATOM    465  C   GLU A  60      16.693  -0.567   4.047  1.00 29.16           C  
ATOM    466  O   GLU A  60      16.260  -1.556   4.645  1.00 33.09           O  
ATOM    467  CB  GLU A  60      19.051  -1.276   3.447  1.00 28.36           C  
ATOM    468  CG  GLU A  60      19.811  -2.073   2.394  1.00 33.33           C  
ATOM    469  CD  GLU A  60      21.212  -2.453   2.824  1.00 41.12           C  
ATOM    470  OE1 GLU A  60      21.452  -2.556   4.046  1.00 45.96           O  
ATOM    471  OE2 GLU A  60      22.073  -2.662   1.937  1.00 45.91           O  
ATOM    472  N   LEU A  61      16.272   0.669   4.320  1.00 26.98           N  
ATOM    473  CA  LEU A  61      15.290   0.927   5.383  1.00 27.76           C  
ATOM    474  C   LEU A  61      13.918   1.288   4.825  1.00 26.59           C  
ATOM    475  O   LEU A  61      12.896   0.896   5.369  1.00 30.88           O  
ATOM    476  CB  LEU A  61      15.779   2.054   6.289  1.00 19.06           C  
ATOM    477  CG  LEU A  61      17.088   1.777   7.035  1.00 28.23           C  
ATOM    478  CD1 LEU A  61      18.021   2.962   6.895  1.00 28.95           C  
ATOM    479  CD2 LEU A  61      16.796   1.497   8.486  1.00 27.75           C  
ATOM    480  N   GLU A  62      13.906   2.043   3.735  1.00 30.98           N  
ATOM    481  CA  GLU A  62      12.663   2.455   3.102  1.00 30.50           C  
ATOM    482  C   GLU A  62      11.764   1.296   2.756  1.00 26.06           C  
ATOM    483  O   GLU A  62      12.201   0.326   2.158  1.00 28.88           O  
ATOM    484  CB  GLU A  62      12.933   3.230   1.818  1.00 34.45           C  
ATOM    485  CG  GLU A  62      13.315   4.657   2.038  1.00 44.78           C  
ATOM    486  CD  GLU A  62      12.832   5.559   0.919  1.00 36.50           C  
ATOM    487  OE1 GLU A  62      13.177   6.752   0.950  1.00 49.18           O  
ATOM    488  OE2 GLU A  62      12.116   5.081   0.019  1.00 40.07           O  
ATOM    489  N   GLY A  63      10.495   1.424   3.126  1.00 25.96           N  
ATOM    490  CA  GLY A  63       9.528   0.391   2.839  1.00 23.98           C  
ATOM    491  C   GLY A  63       9.417  -0.682   3.904  1.00 27.02           C  
ATOM    492  O   GLY A  63       8.488  -1.486   3.864  1.00 27.77           O  
ATOM    493  N   LYS A  64      10.344  -0.709   4.859  1.00 26.15           N  
ATOM    494  CA  LYS A  64      10.292  -1.744   5.899  1.00 24.21           C  
ATOM    495  C   LYS A  64       9.783  -1.255   7.256  1.00 23.76           C  
ATOM    496  O   LYS A  64       9.737  -0.054   7.523  1.00 24.43           O  
ATOM    497  CB  LYS A  64      11.678  -2.354   6.118  1.00 21.76           C  
ATOM    498  CG  LYS A  64      12.482  -2.644   4.863  1.00 34.60           C  
ATOM    499  CD  LYS A  64      11.829  -3.657   3.960  1.00 36.84           C  
ATOM    500  CE  LYS A  64      12.857  -4.696   3.514  1.00 42.38           C  
ATOM    501  NZ  LYS A  64      14.136  -4.064   3.088  1.00 41.84           N  
ATOM    502  N   LYS A  65       9.415  -2.213   8.107  1.00 23.59           N  
ATOM    503  CA  LYS A  65       8.957  -1.934   9.461  1.00 22.62           C  
ATOM    504  C   LYS A  65      10.091  -2.283  10.425  1.00 22.05           C  
ATOM    505  O   LYS A  65      10.803  -3.273  10.211  1.00 18.81           O  
ATOM    506  CB  LYS A  65       7.733  -2.787   9.805  1.00 21.73           C  
ATOM    507  CG  LYS A  65       6.517  -2.461   8.960  1.00 22.49           C  
ATOM    508  CD  LYS A  65       5.295  -3.246   9.404  1.00 26.79           C  
ATOM    509  CE  LYS A  65       4.133  -2.953   8.474  1.00 18.06           C  
ATOM    510  NZ  LYS A  65       2.924  -3.728   8.840  1.00 27.74           N  
ATOM    511  N   PHE A  66      10.239  -1.482  11.479  1.00 17.79           N  
ATOM    512  CA  PHE A  66      11.267  -1.701  12.492  1.00 19.65           C  
ATOM    513  C   PHE A  66      10.743  -1.292  13.868  1.00 24.87           C  
ATOM    514  O   PHE A  66       9.666  -0.697  13.989  1.00 16.32           O  
ATOM    515  CB  PHE A  66      12.520  -0.865  12.216  1.00 18.28           C  
ATOM    516  CG  PHE A  66      13.157  -1.143  10.899  1.00 22.79           C  
ATOM    517  CD1 PHE A  66      12.862  -0.351   9.792  1.00 24.15           C  
ATOM    518  CD2 PHE A  66      14.032  -2.210  10.751  1.00 19.22           C  
ATOM    519  CE1 PHE A  66      13.437  -0.624   8.542  1.00 31.53           C  
ATOM    520  CE2 PHE A  66      14.611  -2.492   9.508  1.00 25.49           C  
ATOM    521  CZ  PHE A  66      14.312  -1.697   8.403  1.00 25.04           C  
ATOM    522  N   ILE A  67      11.533  -1.606  14.890  1.00 17.20           N  
ATOM    523  CA  ILE A  67      11.203  -1.258  16.257  1.00 18.15           C  
ATOM    524  C   ILE A  67      11.784   0.122  16.523  1.00 16.98           C  
ATOM    525  O   ILE A  67      12.927   0.394  16.165  1.00 21.92           O  
ATOM    526  CB  ILE A  67      11.855  -2.208  17.229  1.00 15.86           C  
ATOM    527  CG1 ILE A  67      11.464  -3.646  16.884  1.00 15.26           C  
ATOM    528  CG2 ILE A  67      11.485  -1.805  18.646  1.00 14.97           C  
ATOM    529  CD1 ILE A  67      12.342  -4.688  17.588  1.00 14.81           C  
ATOM    530  N   PHE A  68      11.007   0.987  17.152  1.00 19.61           N  
ATOM    531  CA  PHE A  68      11.467   2.338  17.469  1.00 18.90           C  
ATOM    532  C   PHE A  68      11.059   2.693  18.899  1.00 22.91           C  
ATOM    533  O   PHE A  68       9.937   2.372  19.317  1.00 24.63           O  
ATOM    534  CB  PHE A  68      10.810   3.386  16.545  1.00 21.62           C  
ATOM    535  CG  PHE A  68      11.169   3.261  15.086  1.00 21.70           C  
ATOM    536  CD1 PHE A  68      10.468   2.395  14.252  1.00 19.06           C  
ATOM    537  CD2 PHE A  68      12.170   4.065  14.535  1.00 18.14           C  
ATOM    538  CE1 PHE A  68      10.749   2.328  12.872  1.00 14.15           C  
ATOM    539  CE2 PHE A  68      12.463   4.012  13.170  1.00 22.13           C  
ATOM    540  CZ  PHE A  68      11.748   3.142  12.333  1.00 21.49           C  
ATOM    541  N   VAL A  69      11.960   3.333  19.648  1.00 22.76           N  
ATOM    542  CA  VAL A  69      11.635   3.802  20.998  1.00 23.97           C  
ATOM    543  C   VAL A  69      11.025   5.177  20.704  1.00 25.49           C  
ATOM    544  O   VAL A  69      11.711   6.024  20.133  1.00 24.04           O  
ATOM    545  CB  VAL A  69      12.880   4.052  21.860  1.00 25.40           C  
ATOM    546  CG1 VAL A  69      12.446   4.345  23.277  1.00 22.57           C  
ATOM    547  CG2 VAL A  69      13.802   2.878  21.826  1.00 30.87           C  
ATOM    548  N   VAL A  70       9.773   5.405  21.107  1.00 27.17           N  
ATOM    549  CA  VAL A  70       9.076   6.659  20.807  1.00 29.54           C  
ATOM    550  C   VAL A  70       8.732   7.653  21.932  1.00 36.81           C  
ATOM    551  O   VAL A  70       8.148   8.712  21.658  1.00 33.17           O  
ATOM    552  CB  VAL A  70       7.756   6.374  20.051  1.00 27.05           C  
ATOM    553  CG1 VAL A  70       8.044   5.582  18.777  1.00 31.94           C  
ATOM    554  CG2 VAL A  70       6.786   5.611  20.955  1.00 24.85           C  
ATOM    555  N   ASN A  71       9.068   7.338  23.179  1.00 34.32           N  
ATOM    556  CA  ASN A  71       8.760   8.266  24.265  1.00 35.93           C  
ATOM    557  C   ASN A  71      10.025   8.813  24.907  1.00 35.32           C  
ATOM    558  O   ASN A  71      10.097   8.963  26.123  1.00 38.30           O  
ATOM    559  CB  ASN A  71       7.849   7.605  25.327  1.00 37.77           C  
ATOM    560  CG  ASN A  71       8.559   6.529  26.151  1.00 38.50           C  
ATOM    561  OD1 ASN A  71       9.471   5.850  25.675  1.00 38.27           O  
ATOM    562  ND2 ASN A  71       8.115   6.357  27.392  1.00 39.29           N  
ATOM    563  N   LEU A  72      11.018   9.111  24.075  1.00 33.55           N  
ATOM    564  CA  LEU A  72      12.280   9.665  24.546  1.00 37.65           C  
ATOM    565  C   LEU A  72      12.268  11.185  24.392  1.00 43.03           C  
ATOM    566  O   LEU A  72      11.433  11.743  23.678  1.00 38.31           O  
ATOM    567  CB  LEU A  72      13.461   9.100  23.751  1.00 33.32           C  
ATOM    568  CG  LEU A  72      13.783   7.604  23.815  1.00 33.70           C  
ATOM    569  CD1 LEU A  72      15.123   7.364  23.141  1.00 27.82           C  
ATOM    570  CD2 LEU A  72      13.824   7.130  25.246  1.00 27.95           C  
ATOM    571  N   LYS A  73      13.207  11.844  25.066  1.00 47.27           N  
ATOM    572  CA  LYS A  73      13.340  13.296  25.014  1.00 53.09           C  
ATOM    573  C   LYS A  73      13.766  13.667  23.588  1.00 55.42           C  
ATOM    574  O   LYS A  73      14.780  13.164  23.088  1.00 48.24           O  
ATOM    575  CB  LYS A  73      14.413  13.747  26.012  1.00 58.43           C  
ATOM    576  CG  LYS A  73      14.351  15.217  26.393  1.00 67.27           C  
ATOM    577  CD  LYS A  73      13.433  15.445  27.592  1.00 69.40           C  
ATOM    578  CE  LYS A  73      14.149  15.165  28.916  1.00 70.03           C  
ATOM    579  NZ  LYS A  73      14.799  13.822  28.950  1.00 72.17           N  
ATOM    580  N   PRO A  74      12.995  14.547  22.912  1.00 56.93           N  
ATOM    581  CA  PRO A  74      13.314  14.969  21.539  1.00 57.37           C  
ATOM    582  C   PRO A  74      14.758  15.444  21.441  1.00 57.66           C  
ATOM    583  O   PRO A  74      15.317  15.944  22.418  1.00 54.11           O  
ATOM    584  CB  PRO A  74      12.319  16.097  21.280  1.00 55.63           C  
ATOM    585  CG  PRO A  74      11.146  15.715  22.125  1.00 60.13           C  
ATOM    586  CD  PRO A  74      11.806  15.259  23.412  1.00 57.60           C  
ATOM    587  N   LYS A  75      15.363  15.287  20.270  1.00 56.75           N  
ATOM    588  CA  LYS A  75      16.746  15.702  20.080  1.00 60.72           C  
ATOM    589  C   LYS A  75      17.044  16.100  18.642  1.00 62.61           C  
ATOM    590  O   LYS A  75      16.591  15.455  17.699  1.00 66.52           O  
ATOM    591  CB  LYS A  75      17.695  14.585  20.528  1.00 60.73           C  
ATOM    592  CG  LYS A  75      17.897  14.526  22.029  1.00 61.34           C  
ATOM    593  CD  LYS A  75      18.660  15.755  22.510  1.00 67.88           C  
ATOM    594  CE  LYS A  75      18.673  15.877  24.026  1.00 70.83           C  
ATOM    595  NZ  LYS A  75      17.320  16.177  24.580  1.00 70.92           N  
ATOM    596  N   LYS A  76      17.807  17.175  18.486  1.00 64.75           N  
ATOM    597  CA  LYS A  76      18.173  17.687  17.171  1.00 64.14           C  
ATOM    598  C   LYS A  76      19.588  17.278  16.773  1.00 61.55           C  
ATOM    599  O   LYS A  76      20.546  17.528  17.501  1.00 60.36           O  
ATOM    600  CB  LYS A  76      18.063  19.213  17.163  1.00 70.46           C  
ATOM    601  CG  LYS A  76      18.580  19.863  18.447  1.00 75.83           C  
ATOM    602  CD  LYS A  76      19.026  21.303  18.230  1.00 78.59           C  
ATOM    603  CE  LYS A  76      20.306  21.365  17.401  1.00 78.72           C  
ATOM    604  NZ  LYS A  76      20.762  22.765  17.172  1.00 77.31           N  
ATOM    605  N   PHE A  77      19.714  16.639  15.618  1.00 58.03           N  
ATOM    606  CA  PHE A  77      21.016  16.215  15.127  1.00 55.22           C  
ATOM    607  C   PHE A  77      21.257  16.964  13.837  1.00 55.23           C  
ATOM    608  O   PHE A  77      20.490  16.828  12.881  1.00 50.37           O  
ATOM    609  CB  PHE A  77      21.047  14.705  14.861  1.00 54.79           C  
ATOM    610  CG  PHE A  77      20.759  13.868  16.076  1.00 53.28           C  
ATOM    611  CD1 PHE A  77      19.461  13.742  16.560  1.00 51.02           C  
ATOM    612  CD2 PHE A  77      21.788  13.215  16.744  1.00 54.59           C  
ATOM    613  CE1 PHE A  77      19.190  12.977  17.691  1.00 49.68           C  
ATOM    614  CE2 PHE A  77      21.530  12.445  17.880  1.00 55.72           C  
ATOM    615  CZ  PHE A  77      20.225  12.327  18.355  1.00 51.87           C  
ATOM    616  N   SER A  78      22.318  17.766  13.810  1.00 56.05           N  
ATOM    617  CA  SER A  78      22.634  18.547  12.624  1.00 56.23           C  
ATOM    618  C   SER A  78      21.387  19.337  12.228  1.00 56.87           C  
ATOM    619  O   SER A  78      20.988  19.365  11.062  1.00 58.22           O  
ATOM    620  CB  SER A  78      23.064  17.624  11.478  1.00 56.41           C  
ATOM    621  OG  SER A  78      24.172  16.823  11.855  1.00 52.01           O  
ATOM    622  N   GLY A  79      20.764  19.955  13.229  1.00 58.63           N  
ATOM    623  CA  GLY A  79      19.578  20.755  12.998  1.00 57.78           C  
ATOM    624  C   GLY A  79      18.311  19.978  12.700  1.00 58.94           C  
ATOM    625  O   GLY A  79      17.301  20.577  12.326  1.00 61.21           O  
ATOM    626  N   VAL A  80      18.351  18.656  12.852  1.00 55.75           N  
ATOM    627  CA  VAL A  80      17.169  17.837  12.586  1.00 51.58           C  
ATOM    628  C   VAL A  80      16.556  17.305  13.878  1.00 49.93           C  
ATOM    629  O   VAL A  80      17.230  16.676  14.695  1.00 46.69           O  
ATOM    630  CB  VAL A  80      17.493  16.644  11.669  1.00 49.68           C  
ATOM    631  CG1 VAL A  80      16.210  15.926  11.298  1.00 49.54           C  
ATOM    632  CG2 VAL A  80      18.212  17.119  10.429  1.00 45.70           C  
ATOM    633  N   GLU A  81      15.267  17.568  14.048  1.00 50.77           N  
ATOM    634  CA  GLU A  81      14.538  17.139  15.231  1.00 49.55           C  
ATOM    635  C   GLU A  81      14.201  15.656  15.136  1.00 45.91           C  
ATOM    636  O   GLU A  81      13.428  15.244  14.277  1.00 45.79           O  
ATOM    637  CB  GLU A  81      13.252  17.970  15.364  1.00 53.57           C  
ATOM    638  CG  GLU A  81      12.347  17.632  16.550  1.00 59.72           C  
ATOM    639  CD  GLU A  81      12.883  18.141  17.880  1.00 64.32           C  
ATOM    640  OE1 GLU A  81      13.960  17.671  18.301  1.00 69.15           O  
ATOM    641  OE2 GLU A  81      12.230  19.013  18.504  1.00 58.61           O  
ATOM    642  N   SER A  82      14.800  14.856  16.013  1.00 43.35           N  
ATOM    643  CA  SER A  82      14.545  13.422  16.048  1.00 38.11           C  
ATOM    644  C   SER A  82      13.517  13.137  17.149  1.00 38.54           C  
ATOM    645  O   SER A  82      13.749  13.438  18.316  1.00 39.17           O  
ATOM    646  CB  SER A  82      15.843  12.666  16.332  1.00 35.44           C  
ATOM    647  OG  SER A  82      15.589  11.283  16.498  1.00 36.84           O  
ATOM    648  N   GLN A  83      12.386  12.550  16.776  1.00 35.15           N  
ATOM    649  CA  GLN A  83      11.324  12.251  17.739  1.00 35.61           C  
ATOM    650  C   GLN A  83      11.248  10.762  18.114  1.00 35.25           C  
ATOM    651  O   GLN A  83      10.161  10.237  18.369  1.00 36.06           O  
ATOM    652  CB  GLN A  83       9.971  12.675  17.161  1.00 35.93           C  
ATOM    653  CG  GLN A  83       9.923  14.075  16.568  1.00 38.59           C  
ATOM    654  CD  GLN A  83       8.633  14.322  15.811  1.00 42.61           C  
ATOM    655  OE1 GLN A  83       8.384  13.718  14.768  1.00 34.80           O  
ATOM    656  NE2 GLN A  83       7.798  15.206  16.340  1.00 50.08           N  
ATOM    657  N   GLY A  84      12.390  10.090  18.140  1.00 32.49           N  
ATOM    658  CA  GLY A  84      12.406   8.681  18.485  1.00 31.29           C  
ATOM    659  C   GLY A  84      13.749   8.065  18.177  1.00 28.00           C  
ATOM    660  O   GLY A  84      14.718   8.770  17.917  1.00 29.00           O  
ATOM    661  N   MET A  85      13.820   6.741  18.185  1.00 27.05           N  
ATOM    662  CA  MET A  85      15.084   6.097  17.910  1.00 23.75           C  
ATOM    663  C   MET A  85      14.940   4.673  17.379  1.00 22.74           C  
ATOM    664  O   MET A  85      14.258   3.842  17.978  1.00 24.29           O  
ATOM    665  CB  MET A  85      15.925   6.112  19.178  1.00 24.56           C  
ATOM    666  CG  MET A  85      17.298   5.545  19.018  1.00 33.72           C  
ATOM    667  SD  MET A  85      18.251   5.828  20.525  1.00 40.68           S  
ATOM    668  CE  MET A  85      17.455   4.639  21.630  1.00 37.05           C  
ATOM    669  N   LEU A  86      15.598   4.414  16.253  1.00 20.82           N  
ATOM    670  CA  LEU A  86      15.585   3.107  15.607  1.00 22.82           C  
ATOM    671  C   LEU A  86      16.378   2.075  16.413  1.00 18.83           C  
ATOM    672  O   LEU A  86      17.547   2.291  16.721  1.00 23.18           O  
ATOM    673  CB  LEU A  86      16.195   3.215  14.206  1.00 21.55           C  
ATOM    674  CG  LEU A  86      16.389   1.901  13.424  1.00 19.86           C  
ATOM    675  CD1 LEU A  86      15.044   1.254  13.169  1.00 16.85           C  
ATOM    676  CD2 LEU A  86      17.113   2.168  12.096  1.00 21.23           C  
ATOM    677  N   ILE A  87      15.741   0.964  16.747  1.00 16.92           N  
ATOM    678  CA  ILE A  87      16.406  -0.115  17.485  1.00 20.00           C  
ATOM    679  C   ILE A  87      17.053  -1.112  16.503  1.00 22.54           C  
ATOM    680  O   ILE A  87      16.429  -1.529  15.528  1.00 21.29           O  
ATOM    681  CB  ILE A  87      15.407  -0.902  18.365  1.00 16.55           C  
ATOM    682  CG1 ILE A  87      14.800   0.022  19.426  1.00 19.86           C  
ATOM    683  CG2 ILE A  87      16.113  -2.102  19.011  1.00 14.87           C  
ATOM    684  CD1 ILE A  87      15.833   0.723  20.306  1.00 17.78           C  
ATOM    685  N   LEU A  88      18.300  -1.482  16.769  1.00 21.90           N  
ATOM    686  CA  LEU A  88      19.020  -2.436  15.939  1.00 19.60           C  
ATOM    687  C   LEU A  88      19.969  -3.277  16.767  1.00 22.79           C  
ATOM    688  O   LEU A  88      20.108  -3.051  17.977  1.00 19.45           O  
ATOM    689  CB  LEU A  88      19.805  -1.712  14.850  1.00 30.39           C  
ATOM    690  CG  LEU A  88      20.555  -0.431  15.200  1.00 28.26           C  
ATOM    691  CD1 LEU A  88      21.760  -0.711  16.077  1.00 33.51           C  
ATOM    692  CD2 LEU A  88      20.975   0.212  13.893  1.00 37.76           C  
ATOM    693  N   ALA A  89      20.599  -4.263  16.124  1.00 14.97           N  
ATOM    694  CA  ALA A  89      21.565  -5.128  16.798  1.00 17.91           C  
ATOM    695  C   ALA A  89      22.949  -4.596  16.469  1.00 22.15           C  
ATOM    696  O   ALA A  89      23.162  -4.041  15.395  1.00 20.89           O  
ATOM    697  CB  ALA A  89      21.438  -6.571  16.308  1.00 15.22           C  
ATOM    698  N   GLU A  90      23.889  -4.758  17.393  1.00 23.83           N  
ATOM    699  CA  GLU A  90      25.248  -4.295  17.168  1.00 25.61           C  
ATOM    700  C   GLU A  90      26.219  -5.156  17.946  1.00 26.34           C  
ATOM    701  O   GLU A  90      26.083  -5.293  19.156  1.00 27.13           O  
ATOM    702  CB  GLU A  90      25.408  -2.836  17.607  1.00 25.37           C  
ATOM    703  CG  GLU A  90      26.815  -2.299  17.382  1.00 34.83           C  
ATOM    704  CD  GLU A  90      27.005  -0.858  17.862  1.00 36.90           C  
ATOM    705  OE1 GLU A  90      28.156  -0.373  17.823  1.00 42.00           O  
ATOM    706  OE2 GLU A  90      26.019  -0.216  18.270  1.00 36.84           O  
ATOM    707  N   THR A  91      27.179  -5.757  17.252  1.00 26.79           N  
ATOM    708  CA  THR A  91      28.170  -6.583  17.925  1.00 27.41           C  
ATOM    709  C   THR A  91      29.287  -5.706  18.477  1.00 29.70           C  
ATOM    710  O   THR A  91      29.468  -4.555  18.071  1.00 28.85           O  
ATOM    711  CB  THR A  91      28.780  -7.647  16.982  1.00 31.40           C  
ATOM    712  OG1 THR A  91      29.134  -7.039  15.733  1.00 34.87           O  
ATOM    713  CG2 THR A  91      27.797  -8.774  16.748  1.00 28.42           C  
ATOM    714  N   GLU A  92      30.021  -6.274  19.421  1.00 36.49           N  
ATOM    715  CA  GLU A  92      31.118  -5.611  20.109  1.00 42.12           C  
ATOM    716  C   GLU A  92      32.138  -4.990  19.164  1.00 38.48           C  
ATOM    717  O   GLU A  92      32.790  -4.016  19.521  1.00 41.89           O  
ATOM    718  CB  GLU A  92      31.801  -6.616  21.042  1.00 50.64           C  
ATOM    719  CG  GLU A  92      30.827  -7.622  21.684  1.00 55.30           C  
ATOM    720  CD  GLU A  92      30.120  -8.512  20.646  1.00 58.62           C  
ATOM    721  OE1 GLU A  92      30.822  -9.092  19.785  1.00 64.69           O  
ATOM    722  OE2 GLU A  92      28.871  -8.633  20.687  1.00 48.64           O  
ATOM    723  N   ASP A  93      32.262  -5.542  17.959  1.00 39.80           N  
ATOM    724  CA  ASP A  93      33.205  -5.018  16.979  1.00 39.19           C  
ATOM    725  C   ASP A  93      32.647  -3.795  16.250  1.00 41.17           C  
ATOM    726  O   ASP A  93      33.271  -3.299  15.311  1.00 42.36           O  
ATOM    727  CB  ASP A  93      33.560  -6.087  15.946  1.00 46.04           C  
ATOM    728  CG  ASP A  93      32.595  -6.104  14.765  1.00 52.14           C  
ATOM    729  OD1 ASP A  93      31.394  -6.391  14.971  1.00 50.83           O  
ATOM    730  OD2 ASP A  93      33.044  -5.818  13.629  1.00 53.66           O  
ATOM    731  N   GLY A  94      31.477  -3.315  16.671  1.00 41.55           N  
ATOM    732  CA  GLY A  94      30.880  -2.145  16.035  1.00 36.50           C  
ATOM    733  C   GLY A  94      30.003  -2.413  14.810  1.00 36.16           C  
ATOM    734  O   GLY A  94      29.408  -1.486  14.246  1.00 29.80           O  
ATOM    735  N   LYS A  95      29.911  -3.666  14.378  1.00 29.46           N  
ATOM    736  CA  LYS A  95      29.080  -3.951  13.216  1.00 27.01           C  
ATOM    737  C   LYS A  95      27.593  -3.855  13.580  1.00 25.23           C  
ATOM    738  O   LYS A  95      27.134  -4.443  14.561  1.00 23.71           O  
ATOM    739  CB  LYS A  95      29.401  -5.341  12.649  1.00 27.84           C  
ATOM    740  CG  LYS A  95      28.558  -5.714  11.437  1.00 30.69           C  
ATOM    741  CD  LYS A  95      29.094  -6.957  10.723  1.00 34.96           C  
ATOM    742  CE  LYS A  95      28.265  -7.281   9.480  1.00 33.34           C  
ATOM    743  NZ  LYS A  95      28.276  -6.180   8.465  1.00 33.64           N  
ATOM    744  N   VAL A  96      26.847  -3.097  12.786  1.00 24.98           N  
ATOM    745  CA  VAL A  96      25.414  -2.905  13.003  1.00 26.65           C  
ATOM    746  C   VAL A  96      24.573  -3.774  12.061  1.00 28.39           C  
ATOM    747  O   VAL A  96      24.946  -3.983  10.914  1.00 30.38           O  
ATOM    748  CB  VAL A  96      25.045  -1.410  12.795  1.00 27.33           C  
ATOM    749  CG1 VAL A  96      23.613  -1.270  12.368  1.00 36.21           C  
ATOM    750  CG2 VAL A  96      25.260  -0.645  14.087  1.00 25.83           C  
ATOM    751  N   TYR A  97      23.437  -4.269  12.553  1.00 30.99           N  
ATOM    752  CA  TYR A  97      22.527  -5.102  11.754  1.00 26.78           C  
ATOM    753  C   TYR A  97      21.070  -4.651  11.934  1.00 28.06           C  
ATOM    754  O   TYR A  97      20.615  -4.425  13.059  1.00 25.30           O  
ATOM    755  CB  TYR A  97      22.570  -6.570  12.180  1.00 26.20           C  
ATOM    756  CG  TYR A  97      23.908  -7.263  12.131  1.00 29.64           C  
ATOM    757  CD1 TYR A  97      24.809  -7.163  13.192  1.00 24.51           C  
ATOM    758  CD2 TYR A  97      24.247  -8.076  11.052  1.00 26.40           C  
ATOM    759  CE1 TYR A  97      26.011  -7.867  13.186  1.00 27.56           C  
ATOM    760  CE2 TYR A  97      25.461  -8.784  11.034  1.00 29.57           C  
ATOM    761  CZ  TYR A  97      26.328  -8.672  12.105  1.00 24.43           C  
ATOM    762  OH  TYR A  97      27.513  -9.360  12.086  1.00 36.98           O  
ATOM    763  N   LEU A  98      20.324  -4.542  10.845  1.00 19.16           N  
ATOM    764  CA  LEU A  98      18.927  -4.156  10.988  1.00 23.63           C  
ATOM    765  C   LEU A  98      18.149  -5.326  11.575  1.00 20.89           C  
ATOM    766  O   LEU A  98      18.528  -6.487  11.411  1.00 18.29           O  
ATOM    767  CB  LEU A  98      18.302  -3.798   9.633  1.00 21.92           C  
ATOM    768  CG  LEU A  98      18.803  -2.522   8.963  1.00 27.20           C  
ATOM    769  CD1 LEU A  98      18.024  -2.301   7.677  1.00 19.83           C  
ATOM    770  CD2 LEU A  98      18.635  -1.338   9.917  1.00 19.94           C  
ATOM    771  N   ILE A  99      17.073  -5.001  12.280  1.00 19.50           N  
ATOM    772  CA  ILE A  99      16.183  -6.005  12.846  1.00 16.19           C  
ATOM    773  C   ILE A  99      14.807  -5.625  12.307  1.00 21.25           C  
ATOM    774  O   ILE A  99      14.057  -4.858  12.934  1.00 15.72           O  
ATOM    775  CB  ILE A  99      16.128  -5.964  14.405  1.00 18.97           C  
ATOM    776  CG1 ILE A  99      17.507  -6.277  15.000  1.00 17.76           C  
ATOM    777  CG2 ILE A  99      15.092  -6.986  14.917  1.00 18.62           C  
ATOM    778  CD1 ILE A  99      17.558  -6.118  16.525  1.00 18.10           C  
ATOM    779  N   PRO A 100      14.471  -6.115  11.108  1.00 18.04           N  
ATOM    780  CA  PRO A 100      13.143  -5.755  10.602  1.00 18.31           C  
ATOM    781  C   PRO A 100      12.043  -6.515  11.358  1.00 17.94           C  
ATOM    782  O   PRO A 100      12.271  -7.606  11.871  1.00 17.97           O  
ATOM    783  CB  PRO A 100      13.210  -6.155   9.121  1.00 15.34           C  
ATOM    784  CG  PRO A 100      14.166  -7.351   9.133  1.00 19.59           C  
ATOM    785  CD  PRO A 100      15.254  -6.859  10.101  1.00 21.54           C  
ATOM    786  N   VAL A 101      10.861  -5.912  11.432  1.00 18.05           N  
ATOM    787  CA  VAL A 101       9.698  -6.526  12.067  1.00 17.29           C  
ATOM    788  C   VAL A 101       8.962  -7.267  10.927  1.00 18.80           C  
ATOM    789  O   VAL A 101       8.946  -6.783   9.796  1.00 22.70           O  
ATOM    790  CB  VAL A 101       8.792  -5.409  12.656  1.00 19.14           C  
ATOM    791  CG1 VAL A 101       7.476  -5.967  13.142  1.00 16.27           C  
ATOM    792  CG2 VAL A 101       9.546  -4.688  13.782  1.00 13.87           C  
ATOM    793  N   PRO A 102       8.374  -8.454  11.188  1.00 21.98           N  
ATOM    794  CA  PRO A 102       7.669  -9.151  10.090  1.00 26.67           C  
ATOM    795  C   PRO A 102       6.626  -8.222   9.435  1.00 22.84           C  
ATOM    796  O   PRO A 102       6.034  -7.369  10.100  1.00 25.49           O  
ATOM    797  CB  PRO A 102       7.012 -10.337  10.792  1.00 22.69           C  
ATOM    798  CG  PRO A 102       7.924 -10.598  11.938  1.00 21.10           C  
ATOM    799  CD  PRO A 102       8.262  -9.214  12.439  1.00 18.78           C  
ATOM    800  N   GLU A 103       6.394  -8.397   8.141  1.00 27.11           N  
ATOM    801  CA  GLU A 103       5.451  -7.540   7.419  1.00 28.41           C  
ATOM    802  C   GLU A 103       4.029  -7.583   7.989  1.00 24.30           C  
ATOM    803  O   GLU A 103       3.300  -6.589   7.927  1.00 26.70           O  
ATOM    804  CB  GLU A 103       5.426  -7.917   5.937  1.00 26.51           C  
ATOM    805  CG  GLU A 103       5.338  -6.732   5.010  1.00 45.11           C  
ATOM    806  CD  GLU A 103       6.681  -6.058   4.806  1.00 49.47           C  
ATOM    807  OE1 GLU A 103       7.260  -5.541   5.789  1.00 53.19           O  
ATOM    808  OE2 GLU A 103       7.160  -6.051   3.651  1.00 55.16           O  
ATOM    809  N   GLU A 104       3.658  -8.723   8.567  1.00 21.17           N  
ATOM    810  CA  GLU A 104       2.339  -8.927   9.155  1.00 22.07           C  
ATOM    811  C   GLU A 104       2.009  -8.017  10.342  1.00 30.00           C  
ATOM    812  O   GLU A 104       0.846  -7.664  10.550  1.00 27.25           O  
ATOM    813  CB  GLU A 104       2.190 -10.373   9.643  1.00 33.42           C  
ATOM    814  CG  GLU A 104       2.162 -11.461   8.584  1.00 41.72           C  
ATOM    815  CD  GLU A 104       3.473 -11.593   7.815  1.00 48.12           C  
ATOM    816  OE1 GLU A 104       4.538 -11.238   8.374  1.00 44.49           O  
ATOM    817  OE2 GLU A 104       3.434 -12.066   6.652  1.00 45.77           O  
ATOM    818  N   VAL A 105       3.012  -7.647  11.138  1.00 24.00           N  
ATOM    819  CA  VAL A 105       2.741  -6.823  12.317  1.00 21.62           C  
ATOM    820  C   VAL A 105       2.235  -5.418  11.999  1.00 20.97           C  
ATOM    821  O   VAL A 105       2.918  -4.623  11.362  1.00 20.86           O  
ATOM    822  CB  VAL A 105       3.990  -6.710  13.221  1.00 18.67           C  
ATOM    823  CG1 VAL A 105       3.667  -5.863  14.441  1.00 24.81           C  
ATOM    824  CG2 VAL A 105       4.451  -8.097  13.640  1.00 23.10           C  
ATOM    825  N   PRO A 106       1.025  -5.085  12.460  1.00 19.97           N  
ATOM    826  CA  PRO A 106       0.474  -3.749  12.189  1.00 20.19           C  
ATOM    827  C   PRO A 106       1.334  -2.617  12.783  1.00 22.29           C  
ATOM    828  O   PRO A 106       1.849  -2.746  13.902  1.00 24.52           O  
ATOM    829  CB  PRO A 106      -0.913  -3.809  12.845  1.00 25.24           C  
ATOM    830  CG  PRO A 106      -1.275  -5.275  12.765  1.00 25.08           C  
ATOM    831  CD  PRO A 106       0.043  -5.930  13.160  1.00 23.22           C  
ATOM    832  N   VAL A 107       1.483  -1.518  12.043  1.00 15.86           N  
ATOM    833  CA  VAL A 107       2.246  -0.381  12.523  1.00 17.06           C  
ATOM    834  C   VAL A 107       1.564   0.092  13.816  1.00 23.65           C  
ATOM    835  O   VAL A 107       0.342   0.003  13.946  1.00 22.23           O  
ATOM    836  CB  VAL A 107       2.278   0.793  11.477  1.00 22.50           C  
ATOM    837  CG1 VAL A 107       2.996   0.347  10.185  1.00 22.54           C  
ATOM    838  CG2 VAL A 107       0.864   1.243  11.146  1.00 23.26           C  
ATOM    839  N   GLY A 108       2.347   0.565  14.778  1.00 19.81           N  
ATOM    840  CA  GLY A 108       1.747   1.013  16.022  1.00 20.75           C  
ATOM    841  C   GLY A 108       1.730  -0.073  17.093  1.00 22.61           C  
ATOM    842  O   GLY A 108       1.534   0.233  18.268  1.00 23.13           O  
ATOM    843  N   ALA A 109       1.918  -1.335  16.709  1.00 23.74           N  
ATOM    844  CA  ALA A 109       1.937  -2.420  17.699  1.00 20.97           C  
ATOM    845  C   ALA A 109       2.996  -2.123  18.755  1.00 24.56           C  
ATOM    846  O   ALA A 109       4.064  -1.587  18.439  1.00 20.26           O  
ATOM    847  CB  ALA A 109       2.256  -3.727  17.038  1.00 14.26           C  
ATOM    848  N   ARG A 110       2.726  -2.467  20.008  1.00 23.23           N  
ATOM    849  CA  ARG A 110       3.738  -2.206  21.021  1.00 25.10           C  
ATOM    850  C   ARG A 110       4.771  -3.327  21.051  1.00 21.36           C  
ATOM    851  O   ARG A 110       4.434  -4.499  20.886  1.00 21.41           O  
ATOM    852  CB  ARG A 110       3.140  -2.053  22.417  1.00 27.49           C  
ATOM    853  CG  ARG A 110       4.202  -1.477  23.334  1.00 30.41           C  
ATOM    854  CD  ARG A 110       3.750  -1.181  24.730  1.00 41.07           C  
ATOM    855  NE  ARG A 110       4.890  -0.701  25.514  1.00 40.90           N  
ATOM    856  CZ  ARG A 110       4.858  -0.499  26.827  1.00 44.02           C  
ATOM    857  NH1 ARG A 110       3.738  -0.732  27.501  1.00 44.37           N  
ATOM    858  NH2 ARG A 110       5.947  -0.085  27.465  1.00 40.32           N  
ATOM    859  N   VAL A 111       6.031  -2.962  21.259  1.00 17.83           N  
ATOM    860  CA  VAL A 111       7.102  -3.952  21.316  1.00 20.40           C  
ATOM    861  C   VAL A 111       7.615  -3.962  22.751  1.00 24.10           C  
ATOM    862  O   VAL A 111       8.157  -2.957  23.219  1.00 28.73           O  
ATOM    863  CB  VAL A 111       8.234  -3.586  20.328  1.00 19.82           C  
ATOM    864  CG1 VAL A 111       9.447  -4.473  20.545  1.00 19.79           C  
ATOM    865  CG2 VAL A 111       7.719  -3.742  18.890  1.00 15.65           C  
ATOM    866  N   TRP A 112       7.450  -5.095  23.436  1.00 21.86           N  
ATOM    867  CA  TRP A 112       7.859  -5.204  24.837  1.00 24.21           C  
ATOM    868  C   TRP A 112       7.828  -6.647  25.344  1.00 26.93           C  
ATOM    869  O   TRP A 112       7.539  -7.560  24.540  1.00 30.15           O  
ATOM    870  CB  TRP A 112       6.917  -4.348  25.682  1.00 20.48           C  
ATOM    871  CG  TRP A 112       5.492  -4.852  25.651  1.00 30.05           C  
ATOM    872  CD1 TRP A 112       4.911  -5.626  24.680  1.00 30.83           C  
ATOM    873  CD2 TRP A 112       4.465  -4.581  26.610  1.00 36.21           C  
ATOM    874  NE1 TRP A 112       3.589  -5.851  24.976  1.00 36.03           N  
ATOM    875  CE2 TRP A 112       3.285  -5.222  26.154  1.00 36.02           C  
ATOM    876  CE3 TRP A 112       4.423  -3.858  27.811  1.00 37.03           C  
ATOM    877  CZ2 TRP A 112       2.077  -5.162  26.857  1.00 42.59           C  
ATOM    878  CZ3 TRP A 112       3.218  -3.796  28.513  1.00 44.95           C  
ATOM    879  CH2 TRP A 112       2.061  -4.446  28.032  1.00 44.18           C  
ATOM    880  OXT TRP A 112       8.084  -6.859  26.548  1.00 29.39           O  
TER     881      TRP A 112                                                      
END
MOLECULE T0409.pdb
ATOM     14  N   TYR     1     -12.138  -6.437  34.342  1.00 26.71           N  
ATOM     15  CA  TYR     1     -10.769  -6.327  34.864  1.00 25.90           C  
ATOM     16  C   TYR     1     -10.498  -7.542  35.724  1.00 24.98           C  
ATOM     17  O   TYR     1     -11.355  -7.916  36.501  1.00 26.34           O  
ATOM     18  CB  TYR     1     -10.618  -5.047  35.686  1.00 24.63           C  
ATOM     19  CG  TYR     1      -9.168  -4.728  36.029  1.00 22.28           C  
ATOM     20  CD1 TYR     1      -8.285  -4.357  35.005  1.00 22.31           C  
ATOM     21  CD2 TYR     1      -8.664  -4.878  37.313  1.00 23.91           C  
ATOM     22  CE1 TYR     1      -6.951  -4.068  35.280  1.00 18.52           C  
ATOM     23  CE2 TYR     1      -7.324  -4.598  37.613  1.00 21.53           C  
ATOM     24  CZ  TYR     1      -6.480  -4.192  36.581  1.00 19.19           C  
ATOM     25  OH  TYR     1      -5.185  -3.925  36.888  1.00 18.14           O  
ATOM     26  N   ARG     2      -9.329  -8.164  35.541  1.00 24.27           N  
ATOM     27  CA  ARG     2      -8.922  -9.381  36.228  1.00 24.78           C  
ATOM     28  C   ARG     2      -7.920  -9.194  37.353  1.00 24.52           C  
ATOM     29  O   ARG     2      -7.621 -10.122  38.085  1.00 27.44           O  
ATOM     30  CB  ARG     2      -8.346 -10.374  35.215  1.00 23.92           C  
ATOM     31  CG  ARG     2      -9.347 -10.845  34.134  1.00 25.70           C  
ATOM     32  CD  ARG     2      -8.657 -11.765  33.135  1.00 25.52           C  
ATOM     33  NE  ARG     2      -7.696 -11.068  32.290  1.00 27.24           N  
ATOM     34  CZ  ARG     2      -8.028 -10.316  31.245  1.00 25.99           C  
ATOM     35  NH1 ARG     2      -7.092  -9.705  30.558  1.00 26.10           N  
ATOM     36  NH2 ARG     2      -9.305 -10.178  30.888  1.00 30.15           N  
ATOM     37  N   GLY     3      -7.404  -7.992  37.483  1.00 23.54           N  
ATOM     38  CA  GLY     3      -6.475  -7.700  38.540  1.00 21.96           C  
ATOM     39  C   GLY     3      -5.048  -7.714  38.006  1.00 20.01           C  
ATOM     40  O   GLY     3      -4.763  -8.208  36.927  1.00 19.98           O  
ATOM     41  N   PRO     4      -4.121  -7.183  38.794  1.00 18.75           N  
ATOM     42  CA  PRO     4      -2.718  -7.124  38.362  1.00 17.90           C  
ATOM     43  C   PRO     4      -2.069  -8.474  38.133  1.00 17.43           C  
ATOM     44  O   PRO     4      -2.332  -9.438  38.886  1.00 17.86           O  
ATOM     45  CB  PRO     4      -1.998  -6.462  39.555  1.00 17.83           C  
ATOM     46  CG  PRO     4      -3.078  -5.804  40.295  1.00 17.56           C  
ATOM     47  CD  PRO     4      -4.293  -6.604  40.137  1.00 20.04           C  
ATOM     48  N   GLU     5      -1.198  -8.523  37.136  1.00 16.41           N  
ATOM     49  CA  GLU     5      -0.494  -9.734  36.776  1.00 16.74           C  
ATOM     50  C   GLU     5       0.555 -10.210  37.794  1.00 15.28           C  
ATOM     51  O   GLU     5       0.894 -11.399  37.821  1.00 14.56           O  
ATOM     52  CB  GLU     5       0.179  -9.574  35.415  1.00 18.28           C  
ATOM     53  CG  GLU     5       1.357  -8.668  35.384  1.00 18.86           C  
ATOM     54  CD  GLU     5       1.641  -8.109  33.976  1.00 21.65           C  
ATOM     55  OE1 GLU     5       0.838  -7.287  33.462  1.00 19.17           O  
ATOM     56  OE2 GLU     5       2.690  -8.452  33.404  1.00 20.12           O  
ATOM     57  N   ALA     6       1.090  -9.262  38.551  1.00 14.75           N  
ATOM     58  CA  ALA     6       2.230  -9.503  39.408  1.00 12.91           C  
ATOM     59  C   ALA     6       2.286  -8.383  40.423  1.00 13.86           C  
ATOM     60  O   ALA     6       1.662  -7.340  40.252  1.00 14.07           O  
ATOM     61  CB  ALA     6       3.557  -9.555  38.607  1.00 14.41           C  
ATOM     62  N   PHE     7       3.056  -8.616  41.463  1.00 12.90           N  
ATOM     63  CA  PHE     7       3.312  -7.619  42.514  1.00 12.74           C  
ATOM     64  C   PHE     7       4.803  -7.561  42.789  1.00 14.31           C  
ATOM     65  O   PHE     7       5.426  -8.577  43.064  1.00 16.10           O  
ATOM     66  CB  PHE     7       2.558  -7.975  43.774  1.00 12.84           C  
ATOM     67  CG  PHE     7       1.061  -7.980  43.588  1.00 13.25           C  
ATOM     68  CD1 PHE     7       0.432  -9.083  43.089  1.00 12.42           C  
ATOM     69  CD2 PHE     7       0.284  -6.851  43.907  1.00 13.57           C  
ATOM     70  CE1 PHE     7      -0.949  -9.101  42.892  1.00 15.56           C  
ATOM     71  CE2 PHE     7      -1.084  -6.875  43.732  1.00 14.79           C  
ATOM     72  CZ  PHE     7      -1.682  -7.984  43.198  1.00 14.93           C  
ATOM     73  N   LEU     8       5.379  -6.378  42.730  1.00 13.78           N  
ATOM     74  CA  LEU     8       6.799  -6.166  43.031  1.00 14.87           C  
ATOM     75  C   LEU     8       6.959  -5.587  44.431  1.00 17.18           C  
ATOM     76  O   LEU     8       6.012  -5.033  45.021  1.00 18.46           O  
ATOM     77  CB  LEU     8       7.409  -5.253  41.997  1.00 14.89           C  
ATOM     78  CG  LEU     8       7.096  -5.514  40.532  1.00 15.32           C  
ATOM     79  CD1 LEU     8       7.647  -4.518  39.513  1.00 16.20           C  
ATOM     80  CD2 LEU     8       7.592  -6.945  40.214  1.00 16.59           C  
ATOM     81  N   LYS     9       8.127  -5.818  45.005  1.00 17.65           N  
ATOM     82  CA  LYS     9       8.421  -5.348  46.361  1.00 19.07           C  
ATOM     83  C   LYS     9       9.052  -3.955  46.263  1.00 17.92           C  
ATOM     84  O   LYS     9      10.150  -3.798  45.727  1.00 18.25           O  
ATOM     85  CB  LYS     9       9.373  -6.314  47.042  1.00 19.67           C  
ATOM     86  CG  LYS     9       9.591  -5.980  48.493  1.00 23.14           C  
ATOM     87  CD  LYS     9      10.639  -6.886  49.072  1.00 24.83           C  
ATOM     88  CE  LYS     9      10.121  -8.265  49.428  1.00 32.25           C  
ATOM     89  NZ  LYS     9      10.917  -8.817  50.575  1.00 34.79           N  
ATOM     90  N   LEU    10       8.369  -2.926  46.749  1.00 18.72           N  
ATOM     91  CA  LEU    10       8.826  -1.580  46.551  1.00 18.81           C  
ATOM     92  C   LEU    10       9.942  -1.228  47.554  1.00 19.68           C  
ATOM     93  O   LEU    10      10.009  -1.815  48.647  1.00 20.89           O  
ATOM     94  CB  LEU    10       7.717  -0.560  46.770  1.00 20.05           C  
ATOM     95  CG  LEU    10       6.533  -0.547  45.822  1.00 19.19           C  
ATOM     96  CD1 LEU    10       5.473   0.394  46.436  1.00 24.82           C  
ATOM     97  CD2 LEU    10       6.945  -0.115  44.440  1.00 21.53           C  
ATOM     98  N   PRO    11      10.774  -0.268  47.163  1.00 20.13           N  
ATOM     99  CA  PRO    11      11.661   0.375  48.167  1.00 21.78           C  
ATOM    100  C   PRO    11      10.838   1.323  49.071  1.00 22.52           C  
ATOM    101  O   PRO    11       9.740   1.732  48.679  1.00 23.44           O  
ATOM    102  CB  PRO    11      12.607   1.193  47.285  1.00 20.85           C  
ATOM    103  CG  PRO    11      11.779   1.545  46.072  1.00 22.93           C  
ATOM    104  CD  PRO    11      10.970   0.307  45.828  1.00 19.70           C  
ATOM    105  N   LYS    12      11.406   1.739  50.229  1.00 25.61           N  
ATOM    106  CA  LYS    12      10.808   2.820  51.069  1.00 26.86           C  
ATOM    107  C   LYS    12      10.655   4.134  50.323  1.00 28.24           C  
ATOM    108  O   LYS    12       9.621   4.815  50.414  1.00 30.07           O  
ATOM    109  CB  LYS    12      11.725   3.141  52.244  1.00 27.78           C  
ATOM    110  CG  LYS    12      11.297   2.660  53.597  1.00 29.19           C  
ATOM    111  CD  LYS    12      12.113   3.300  54.688  1.00 28.24           C  
ATOM    112  CE  LYS    12      11.543   4.613  55.215  1.00 28.46           C  
ATOM    113  NZ  LYS    12      12.177   4.939  56.553  1.00 29.49           N  
ATOM    114  N   ASP    13      11.716   4.525  49.615  1.00 29.01           N  
ATOM    115  CA  ASP    13      11.746   5.788  48.876  1.00 29.32           C  
ATOM    116  C   ASP    13      11.132   5.663  47.484  1.00 30.39           C  
ATOM    117  O   ASP    13      11.712   5.127  46.535  1.00 29.19           O  
ATOM    118  CB  ASP    13      13.189   6.371  48.893  1.00 29.16           C  
ATOM    119  CG  ASP    13      13.347   7.664  48.082  1.00 30.92           C  
ATOM    120  OD1 ASP    13      12.344   8.274  47.628  1.00 34.61           O  
ATOM    121  OD2 ASP    13      14.529   8.080  47.888  1.00 32.69           O  
ATOM    122  N   LEU    14       9.920   6.195  47.363  1.00 30.90           N  
ATOM    123  CA  LEU    14       9.172   6.157  46.124  1.00 30.71           C  
ATOM    124  C   LEU    14       9.608   7.149  45.049  1.00 30.84           C  
ATOM    125  O   LEU    14       9.020   7.178  43.964  1.00 31.55           O  
ATOM    126  CB  LEU    14       7.678   6.329  46.424  1.00 30.89           C  
ATOM    127  CG  LEU    14       7.124   5.332  47.440  1.00 30.54           C  
ATOM    128  CD1 LEU    14       5.711   5.725  47.765  1.00 33.63           C  
ATOM    129  CD2 LEU    14       7.169   3.889  46.924  1.00 35.44           C  
ATOM    130  N   LYS    15      10.614   7.983  45.348  1.00 30.72           N  
ATOM    131  CA  LYS    15      11.255   8.810  44.324  1.00 30.73           C  
ATOM    132  C   LYS    15      12.623   8.265  43.901  1.00 29.76           C  
ATOM    133  O   LYS    15      13.272   8.865  43.053  1.00 30.87           O  
ATOM    134  CB  LYS    15      11.408  10.266  44.806  1.00 32.76           C  
ATOM    135  CG  LYS    15      10.232  11.196  44.418  1.00 35.47           C  
ATOM    136  CD  LYS    15       9.079  11.039  45.367  1.00 37.91           C  
ATOM    137  CE  LYS    15       9.288  11.906  46.603  1.00 39.30           C  
ATOM    138  NZ  LYS    15       8.302  11.581  47.681  1.00 39.71           N  
ATOM    139  N   ASP    16      13.046   7.133  44.481  1.00 27.99           N  
ATOM    140  CA  ASP    16      14.328   6.493  44.094  1.00 26.78           C  
ATOM    141  C   ASP    16      14.118   5.763  42.782  1.00 25.11           C  
ATOM    142  O   ASP    16      13.741   4.600  42.764  1.00 24.88           O  
ATOM    143  CB  ASP    16      14.802   5.533  45.171  1.00 25.55           C  
ATOM    144  CG  ASP    16      16.217   4.970  44.893  1.00 26.06           C  
ATOM    145  OD1 ASP    16      16.650   5.014  43.729  1.00 25.61           O  
ATOM    146  OD2 ASP    16      16.861   4.472  45.830  1.00 25.02           O  
ATOM    147  N   ARG    17      14.360   6.449  41.680  1.00 25.11           N  
ATOM    148  CA  ARG    17      14.118   5.904  40.359  1.00 24.25           C  
ATOM    149  C   ARG    17      14.973   4.689  40.041  1.00 23.79           C  
ATOM    150  O   ARG    17      14.497   3.729  39.431  1.00 22.80           O  
ATOM    151  CB  ARG    17      14.276   6.978  39.293  1.00 26.64           C  
ATOM    152  CG  ARG    17      13.323   8.136  39.528  1.00 30.06           C  
ATOM    153  CD  ARG    17      12.985   8.820  38.245  1.00 37.41           C  
ATOM    154  NE  ARG    17      14.129   9.542  37.706  1.00 40.97           N  
ATOM    155  CZ  ARG    17      14.150  10.097  36.499  1.00 43.91           C  
ATOM    156  NH1 ARG    17      13.094   9.997  35.685  1.00 45.45           N  
ATOM    157  NH2 ARG    17      15.241  10.749  36.096  1.00 45.78           N  
ATOM    158  N   GLU    18      16.227   4.705  40.494  1.00 22.85           N  
ATOM    159  CA  GLU    18      17.123   3.549  40.277  1.00 22.70           C  
ATOM    160  C   GLU    18      16.572   2.269  40.913  1.00 20.63           C  
ATOM    161  O   GLU    18      16.555   1.211  40.278  1.00 19.78           O  
ATOM    162  CB  GLU    18      18.500   3.848  40.866  1.00 23.30           C  
ATOM    163  CG  GLU    18      19.549   2.754  40.681  1.00 24.01           C  
ATOM    164  CD  GLU    18      20.941   3.182  41.148  1.00 26.13           C  
ATOM    165  OE1 GLU    18      21.200   3.135  42.381  1.00 31.97           O  
ATOM    166  OE2 GLU    18      21.761   3.558  40.278  1.00 30.80           O  
ATOM    167  N   ALA    19      16.146   2.364  42.159  1.00 18.69           N  
ATOM    168  CA  ALA    19      15.569   1.237  42.865  1.00 18.72           C  
ATOM    169  C   ALA    19      14.286   0.741  42.184  1.00 18.42           C  
ATOM    170  O   ALA    19      14.079  -0.477  42.073  1.00 18.40           O  
ATOM    171  CB  ALA    19      15.248   1.627  44.285  1.00 19.53           C  
ATOM    172  N   LEU    20      13.438   1.683  41.764  1.00 18.86           N  
ATOM    173  CA  LEU    20      12.198   1.346  41.088  1.00 18.10           C  
ATOM    174  C   LEU    20      12.479   0.694  39.747  1.00 18.59           C  
ATOM    175  O   LEU    20      11.826  -0.289  39.383  1.00 18.02           O  
ATOM    176  CB  LEU    20      11.269   2.570  40.902  1.00 19.62           C  
ATOM    177  CG  LEU    20      10.779   3.123  42.243  1.00 19.47           C  
ATOM    178  CD1 LEU    20      10.171   4.490  42.063  1.00 25.48           C  
ATOM    179  CD2 LEU    20       9.776   2.141  42.919  1.00 20.59           C  
ATOM    180  N   GLN    21      13.439   1.212  38.971  1.00 17.08           N  
ATOM    181  CA  GLN    21      13.818   0.563  37.701  0.60 17.52           C  
ATOM    183  C   GLN    21      14.339  -0.838  37.961  1.00 17.89           C  
ATOM    184  O   GLN    21      14.076  -1.788  37.220  1.00 17.69           O  
ATOM    185  CB  GLN    21      14.943   1.338  36.986  0.60 18.21           C  
ATOM    187  CG  GLN    21      14.503   2.626  36.329  0.60 18.89           C  
ATOM    189  CD  GLN    21      13.515   2.472  35.158  0.60 20.48           C  
ATOM    191  OE1 GLN    21      13.254   1.364  34.619  0.60 23.97           O  
ATOM    193  NE2 GLN    21      12.980   3.610  34.738  0.60 22.78           N  
ATOM    195  N   ASP    22      15.104  -0.995  39.034  1.00 16.55           N  
ATOM    196  CA  ASP    22      15.680  -2.315  39.349  1.00 17.02           C  
ATOM    197  C   ASP    22      14.611  -3.356  39.634  1.00 16.63           C  
ATOM    198  O   ASP    22      14.714  -4.505  39.156  1.00 16.75           O  
ATOM    199  CB  ASP    22      16.632  -2.228  40.544  1.00 17.24           C  
ATOM    200  CG  ASP    22      18.015  -1.694  40.162  1.00 19.16           C  
ATOM    201  OD1 ASP    22      18.327  -1.439  38.960  1.00 22.10           O  
ATOM    202  OD2 ASP    22      18.789  -1.547  41.118  1.00 23.09           O  
ATOM    203  N   ILE    23      13.551  -2.982  40.363  1.00 15.22           N  
ATOM    204  CA  ILE    23      12.501  -4.017  40.667  1.00 15.44           C  
ATOM    205  C   ILE    23      11.696  -4.359  39.393  1.00 15.80           C  
ATOM    206  O   ILE    23      11.130  -5.448  39.328  1.00 16.91           O  
ATOM    207  CB  ILE    23      11.538  -3.666  41.812  1.00 14.93           C  
ATOM    208  CG1 ILE    23      10.715  -2.400  41.496  1.00 16.08           C  
ATOM    209  CG2 ILE    23      12.349  -3.420  43.109  1.00 16.92           C  
ATOM    210  CD1 ILE    23       9.662  -2.083  42.539  1.00 18.45           C  
ATOM    211  N   MET    24      11.693  -3.454  38.407  1.00 16.35           N  
ATOM    212  CA  MET    24      11.001  -3.635  37.136  1.00 16.51           C  
ATOM    213  C   MET    24      11.870  -4.256  36.047  1.00 16.28           C  
ATOM    214  O   MET    24      11.426  -4.374  34.907  1.00 16.01           O  
ATOM    215  CB  MET    24      10.471  -2.276  36.650  1.00 16.46           C  
ATOM    216  CG  MET    24       9.476  -1.622  37.540  1.00 17.64           C  
ATOM    217  SD  MET    24       8.685  -0.053  36.632  0.80 26.05          SE  
ATOM    218  CE  MET    24       7.421  -0.860  35.445  1.00 24.41           C  
ATOM    219  N   GLN    25      13.092  -4.631  36.388  1.00 16.67           N  
ATOM    220  CA  GLN    25      14.070  -4.998  35.365  1.00 17.43           C  
ATOM    221  C   GLN    25      13.592  -6.036  34.353  1.00 16.67           C  
ATOM    222  O   GLN    25      14.004  -5.969  33.198  1.00 17.33           O  
ATOM    223  CB  GLN    25      15.374  -5.433  36.005  1.00 18.09           C  
ATOM    224  CG  GLN    25      15.329  -6.698  36.777  1.00 20.57           C  
ATOM    225  CD  GLN    25      16.656  -7.030  37.461  1.00 24.40           C  
ATOM    226  OE1 GLN    25      17.683  -6.382  37.193  1.00 30.15           O  
ATOM    227  NE2 GLN    25      16.631  -8.020  38.370  1.00 29.33           N  
ATOM    228  N   ASP    26      12.790  -7.013  34.797  1.00 15.34           N  
ATOM    229  CA  ASP    26      12.390  -8.124  33.918  1.00 15.72           C  
ATOM    230  C   ASP    26      11.142  -7.834  33.073  1.00 16.03           C  
ATOM    231  O   ASP    26      10.876  -8.602  32.131  1.00 16.34           O  
ATOM    232  CB  ASP    26      12.120  -9.391  34.723  1.00 15.05           C  
ATOM    233  CG  ASP    26      13.409 -10.027  35.326  1.00 18.38           C  
ATOM    234  OD1 ASP    26      14.527  -9.715  34.833  1.00 21.09           O  
ATOM    235  OD2 ASP    26      13.261 -10.859  36.262  1.00 21.86           O  
ATOM    236  N   ILE    27      10.434  -6.762  33.392  1.00 16.05           N  
ATOM    237  CA  ILE    27       9.093  -6.467  32.882  0.60 17.18           C  
ATOM    239  C   ILE    27       9.116  -5.228  31.989  1.00 17.24           C  
ATOM    240  O   ILE    27       9.908  -4.318  32.214  1.00 16.86           O  
ATOM    241  CB  ILE    27       8.122  -6.210  34.080  0.60 17.87           C  
ATOM    243  CG1 ILE    27       8.158  -7.384  35.052  0.60 18.38           C  
ATOM    245  CG2 ILE    27       6.684  -5.914  33.601  0.60 18.73           C  
ATOM    247  CD1 ILE    27       7.986  -8.690  34.409  0.60 20.09           C  
ATOM    249  N   GLY    28       8.241  -5.184  31.003  1.00 17.82           N  
ATOM    250  CA  GLY    28       8.066  -3.945  30.257  1.00 18.09           C  
ATOM    251  C   GLY    28       9.221  -3.577  29.353  1.00 18.07           C  
ATOM    252  O   GLY    28       9.365  -2.424  28.950  1.00 18.91           O  
ATOM    253  N   ASN    29      10.036  -4.547  28.983  1.00 18.26           N  
ATOM    254  CA  ASN    29      11.290  -4.211  28.309  1.00 18.83           C  
ATOM    255  C   ASN    29      11.112  -3.765  26.859  1.00 19.92           C  
ATOM    256  O   ASN    29      12.054  -3.163  26.287  1.00 23.13           O  
ATOM    257  CB  ASN    29      12.315  -5.308  28.491  1.00 19.12           C  
ATOM    258  CG  ASN    29      12.920  -5.252  29.901  1.00 18.82           C  
ATOM    259  OD1 ASN    29      13.210  -4.141  30.417  1.00 20.59           O  
ATOM    260  ND2 ASN    29      13.068  -6.410  30.534  1.00 20.14           N  
ATOM    261  N   SER    30       9.940  -3.996  26.289  1.00 19.51           N  
ATOM    262  CA  SER    30       9.638  -3.436  24.946  1.00 19.62           C  
ATOM    263  C   SER    30       8.833  -2.162  25.064  1.00 19.59           C  
ATOM    264  O   SER    30       8.467  -1.576  24.052  1.00 20.08           O  
ATOM    265  CB  SER    30       8.915  -4.467  24.077  1.00 20.71           C  
ATOM    266  OG  SER    30       7.714  -4.851  24.696  1.00 25.23           O  
ATOM    267  N   ASP    31       8.554  -1.688  26.286  1.00 19.24           N  
ATOM    268  CA  ASP    31       7.719  -0.480  26.428  1.00 19.48           C  
ATOM    269  C   ASP    31       8.399   0.728  25.751  1.00 19.11           C  
ATOM    270  O   ASP    31       9.607   0.921  25.855  1.00 18.28           O  
ATOM    271  CB  ASP    31       7.472  -0.170  27.903  1.00 19.32           C  
ATOM    272  CG  ASP    31       6.382  -1.059  28.540  1.00 20.97           C  
ATOM    273  OD1 ASP    31       5.838  -1.957  27.861  1.00 20.12           O  
ATOM    274  OD2 ASP    31       6.130  -0.786  29.749  1.00 20.60           O  
ATOM    275  N   ASP    32       7.573   1.496  25.059  1.00 19.06           N  
ATOM    276  CA  ASP    32       7.966   2.731  24.373  1.00 20.14           C  
ATOM    277  C   ASP    32       8.776   2.490  23.102  1.00 19.79           C  
ATOM    278  O   ASP    32       9.198   3.461  22.447  1.00 19.91           O  
ATOM    279  CB  ASP    32       8.712   3.674  25.293  1.00 20.73           C  
ATOM    280  CG  ASP    32       7.963   3.948  26.635  1.00 23.39           C  
ATOM    281  OD1 ASP    32       6.803   4.403  26.542  1.00 25.24           O  
ATOM    282  OD2 ASP    32       8.564   3.719  27.723  1.00 25.94           O  
ATOM    283  N   ILE    33       8.996   1.235  22.770  1.00 19.89           N  
ATOM    284  CA  ILE    33       9.673   0.832  21.522  1.00 20.20           C  
ATOM    285  C   ILE    33       8.565   0.449  20.573  1.00 20.72           C  
ATOM    286  O   ILE    33       7.960  -0.632  20.700  1.00 22.37           O  
ATOM    287  CB  ILE    33      10.677  -0.334  21.711  1.00 19.45           C  
ATOM    288  CG1 ILE    33      11.758   0.114  22.689  1.00 21.44           C  
ATOM    289  CG2 ILE    33      11.304  -0.710  20.329  1.00 20.56           C  
ATOM    290  CD1 ILE    33      12.772  -0.956  23.051  1.00 22.94           C  
ATOM    291  N   LEU    34       8.299   1.342  19.626  1.00 19.25           N  
ATOM    292  CA  LEU    34       7.087   1.314  18.818  1.00 17.77           C  
ATOM    293  C   LEU    34       7.338   0.882  17.390  1.00 18.40           C  
ATOM    294  O   LEU    34       8.388   1.119  16.839  1.00 18.47           O  
ATOM    295  CB  LEU    34       6.469   2.701  18.781  1.00 18.47           C  
ATOM    296  CG  LEU    34       6.267   3.371  20.125  1.00 19.72           C  
ATOM    297  CD1 LEU    34       5.545   4.684  19.944  1.00 22.67           C  
ATOM    298  CD2 LEU    34       5.548   2.434  21.132  1.00 21.13           C  
ATOM    299  N   ALA    35       6.348   0.240  16.797  1.00 18.57           N  
ATOM    300  CA  ALA    35       6.435  -0.175  15.394  1.00 17.19           C  
ATOM    301  C   ALA    35       6.217   1.030  14.494  1.00 17.33           C  
ATOM    302  O   ALA    35       5.387   1.913  14.741  1.00 18.24           O  
ATOM    303  CB  ALA    35       5.390  -1.293  15.057  1.00 19.13           C  
ATOM    304  N   ALA    36       6.928   1.044  13.360  1.00 17.01           N  
ATOM    305  CA  ALA    36       6.674   2.049  12.357  1.00 15.71           C  
ATOM    306  C   ALA    36       7.034   1.462  10.990  1.00 16.78           C  
ATOM    307  O   ALA    36       7.901   0.604  10.879  1.00 18.10           O  
ATOM    308  CB  ALA    36       7.457   3.343  12.596  1.00 17.58           C  
ATOM    309  N   VAL    37       6.370   1.955   9.975  1.00 15.62           N  
ATOM    310  CA  VAL    37       6.682   1.549   8.602  0.50 15.71           C  
ATOM    312  C   VAL    37       7.312   2.714   7.873  1.00 14.23           C  
ATOM    313  O   VAL    37       6.779   3.823   7.872  1.00 15.68           O  
ATOM    314  CB  VAL    37       5.451   1.037   7.797  0.50 15.29           C  
ATOM    316  CG1 VAL    37       4.346   2.086   7.714  0.50 16.13           C  
ATOM    318  CG2 VAL    37       5.858   0.619   6.389  0.50 16.06           C  
ATOM    320  N   VAL    38       8.435   2.456   7.238  1.00 14.86           N  
ATOM    321  CA  VAL    38       9.172   3.493   6.517  1.00 14.41           C  
ATOM    322  C   VAL    38       8.438   3.924   5.239  1.00 15.45           C  
ATOM    323  O   VAL    38       7.986   3.077   4.449  1.00 14.72           O  
ATOM    324  CB  VAL    38      10.630   3.065   6.225  1.00 15.18           C  
ATOM    325  CG1 VAL    38      11.345   4.116   5.259  1.00 14.75           C  
ATOM    326  CG2 VAL    38      11.387   2.893   7.574  1.00 15.41           C  
ATOM    327  N   LEU    39       8.293   5.236   5.093  1.00 14.89           N  
ATOM    328  CA  LEU    39       7.728   5.844   3.883  1.00 15.30           C  
ATOM    329  C   LEU    39       8.802   6.367   2.923  1.00 16.16           C  
ATOM    330  O   LEU    39       8.618   6.337   1.717  1.00 17.32           O  
ATOM    331  CB  LEU    39       6.793   7.008   4.266  1.00 16.91           C  
ATOM    332  CG  LEU    39       5.696   6.599   5.252  1.00 17.60           C  
ATOM    333  CD1 LEU    39       4.796   7.809   5.545  1.00 21.11           C  
ATOM    334  CD2 LEU    39       4.876   5.379   4.818  1.00 20.56           C  
ATOM    335  N   SER    40       9.878   6.946   3.451  1.00 16.45           N  
ATOM    336  CA  SER    40      10.967   7.414   2.684  1.00 16.91           C  
ATOM    337  C   SER    40      12.241   7.291   3.490  1.00 16.85           C  
ATOM    338  O   SER    40      12.195   7.364   4.707  1.00 15.68           O  
ATOM    339  CB  SER    40      10.726   8.848   2.271  1.00 18.60           C  
ATOM    340  OG  SER    40      10.878   9.725   3.348  1.00 19.69           O  
ATOM    341  N   ALA    41      13.376   7.151   2.802  1.00 16.13           N  
ATOM    342  CA  ALA    41      14.666   7.013   3.492  1.00 16.24           C  
ATOM    343  C   ALA    41      15.808   7.516   2.678  1.00 17.06           C  
ATOM    344  O   ALA    41      15.937   7.212   1.489  1.00 17.44           O  
ATOM    345  CB  ALA    41      14.932   5.590   3.873  1.00 16.02           C  
ATOM    346  N   THR    42      16.603   8.346   3.317  1.00 17.62           N  
ATOM    347  CA  THR    42      17.909   8.824   2.826  1.00 18.26           C  
ATOM    348  C   THR    42      18.903   8.767   3.996  1.00 18.56           C  
ATOM    349  O   THR    42      18.496   8.630   5.155  1.00 16.63           O  
ATOM    350  CB  THR    42      17.820  10.268   2.317  1.00 18.38           C  
ATOM    351  OG1 THR    42      17.681  11.157   3.433  1.00 21.26           O  
ATOM    352  CG2 THR    42      16.634  10.457   1.330  1.00 21.04           C  
ATOM    353  N   PRO    43      20.207   8.983   3.741  1.00 18.87           N  
ATOM    354  CA  PRO    43      21.125   9.006   4.879  1.00 18.55           C  
ATOM    355  C   PRO    43      20.851  10.148   5.880  1.00 18.56           C  
ATOM    356  O   PRO    43      21.326  10.095   7.044  1.00 20.67           O  
ATOM    357  CB  PRO    43      22.499   9.197   4.201  1.00 19.88           C  
ATOM    358  CG  PRO    43      22.329   8.653   2.885  1.00 19.28           C  
ATOM    359  CD  PRO    43      20.938   9.070   2.467  1.00 20.45           C  
ATOM    360  N   GLY    44      20.139  11.170   5.431  1.00 16.96           N  
ATOM    361  CA  GLY    44      19.835  12.346   6.269  1.00 17.33           C  
ATOM    362  C   GLY    44      18.471  12.343   6.932  1.00 16.12           C  
ATOM    363  O   GLY    44      18.259  13.110   7.843  1.00 16.70           O  
ATOM    364  N   ALA    45      17.521  11.522   6.465  1.00 15.44           N  
ATOM    365  CA  ALA    45      16.194  11.546   7.049  1.00 16.18           C  
ATOM    366  C   ALA    45      15.409  10.293   6.680  1.00 16.57           C  
ATOM    367  O   ALA    45      15.433   9.862   5.536  1.00 16.49           O  
ATOM    368  CB  ALA    45      15.445  12.726   6.525  1.00 16.54           C  
ATOM    369  N   VAL    46      14.702   9.747   7.648  1.00 16.15           N  
ATOM    370  CA  VAL    46      13.752   8.676   7.432  1.00 15.46           C  
ATOM    371  C   VAL    46      12.395   9.193   7.901  1.00 16.21           C  
ATOM    372  O   VAL    46      12.272   9.685   9.044  1.00 15.82           O  
ATOM    373  CB  VAL    46      14.173   7.440   8.255  1.00 14.79           C  
ATOM    374  CG1 VAL    46      13.059   6.405   8.283  1.00 16.16           C  
ATOM    375  CG2 VAL    46      15.520   6.906   7.736  1.00 15.90           C  
ATOM    376  N   GLU    47      11.375   9.063   7.045  1.00 16.26           N  
ATOM    377  CA  GLU    47       9.987   9.338   7.431  1.00 17.37           C  
ATOM    378  C   GLU    47       9.318   7.985   7.648  1.00 17.25           C  
ATOM    379  O   GLU    47       9.447   7.094   6.805  1.00 16.35           O  
ATOM    380  CB  GLU    47       9.240  10.078   6.308  1.00 18.76           C  
ATOM    381  CG  GLU    47       9.768  11.459   6.058  1.00 22.56           C  
ATOM    382  CD  GLU    47       8.728  12.493   5.613  1.00 27.08           C  
ATOM    383  OE1 GLU    47       7.596  12.140   5.191  1.00 32.70           O  
ATOM    384  OE2 GLU    47       9.093  13.699   5.695  1.00 39.15           O  
ATOM    385  N   ALA    48       8.608   7.831   8.751  1.00 15.79           N  
ATOM    386  CA  ALA    48       7.954   6.581   9.088  1.00 16.62           C  
ATOM    387  C   ALA    48       6.568   6.823   9.690  1.00 16.84           C  
ATOM    388  O   ALA    48       6.358   7.839  10.370  1.00 19.46           O  
ATOM    389  CB  ALA    48       8.843   5.735  10.026  1.00 17.11           C  
ATOM    390  N   PHE    49       5.635   5.922   9.429  1.00 16.37           N  
ATOM    391  CA  PHE    49       4.267   5.991   9.929  1.00 17.59           C  
ATOM    392  C   PHE    49       4.122   5.056  11.129  1.00 18.32           C  
ATOM    393  O   PHE    49       4.501   3.899  11.058  1.00 17.79           O  
ATOM    394  CB  PHE    49       3.296   5.544   8.820  1.00 17.85           C  
ATOM    395  CG  PHE    49       1.842   5.641   9.191  1.00 18.30           C  
ATOM    396  CD1 PHE    49       1.144   6.802   8.933  1.00 21.76           C  
ATOM    397  CD2 PHE    49       1.164   4.553   9.695  1.00 20.75           C  
ATOM    398  CE1 PHE    49      -0.227   6.916   9.249  1.00 20.36           C  
ATOM    399  CE2 PHE    49      -0.206   4.656  10.047  1.00 19.72           C  
ATOM    400  CZ  PHE    49      -0.881   5.839   9.796  1.00 22.60           C  
ATOM    401  N   ARG    50       3.636   5.563  12.253  1.00 19.08           N  
ATOM    402  CA  ARG    50       3.464   4.703  13.441  1.00 20.23           C  
ATOM    403  C   ARG    50       1.972   4.382  13.686  1.00 21.07           C  
ATOM    404  O   ARG    50       1.117   4.995  13.106  1.00 20.64           O  
ATOM    405  CB  ARG    50       4.134   5.305  14.688  1.00 22.94           C  
ATOM    406  CG  ARG    50       3.763   6.662  15.046  1.00 23.31           C  
ATOM    407  CD  ARG    50       4.729   7.128  16.134  1.00 22.13           C  
ATOM    408  NE  ARG    50       4.369   8.344  16.762  1.00 24.32           N  
ATOM    409  CZ  ARG    50       3.791   8.440  17.969  1.00 23.15           C  
ATOM    410  NH1 ARG    50       3.443   7.362  18.655  1.00 26.13           N  
ATOM    411  NH2 ARG    50       3.534   9.622  18.479  1.00 24.48           N  
ATOM    412  N   LYS    51       1.701   3.437  14.570  1.00 21.95           N  
ATOM    413  CA  LYS    51       0.329   2.957  14.793  1.00 22.96           C  
ATOM    414  C   LYS    51      -0.644   4.022  15.207  1.00 23.88           C  
ATOM    415  O   LYS    51      -1.836   3.907  14.899  1.00 27.15           O  
ATOM    416  CB  LYS    51       0.344   1.884  15.880  1.00 24.30           C  
ATOM    417  CG  LYS    51       0.928   0.570  15.440  1.00 26.87           C  
ATOM    418  CD  LYS    51      -0.058  -0.226  14.582  1.00 29.44           C  
ATOM    419  CE  LYS    51      -1.205  -0.890  15.358  1.00 30.13           C  
ATOM    420  NZ  LYS    51      -1.944  -1.954  14.526  1.00 28.19           N  
ATOM    421  N   ASN    52      -0.193   5.045  15.923  1.00 23.72           N  
ATOM    422  CA  ASN    52      -1.125   6.100  16.359  1.00 24.26           C  
ATOM    423  C   ASN    52      -1.538   7.030  15.207  1.00 24.17           C  
ATOM    424  O   ASN    52      -2.323   7.978  15.409  1.00 25.42           O  
ATOM    425  CB  ASN    52      -0.554   6.871  17.558  1.00 25.03           C  
ATOM    426  CG  ASN    52       0.317   8.020  17.160  1.00 24.42           C  
ATOM    427  OD1 ASN    52       0.962   7.983  16.114  1.00 25.79           O  
ATOM    428  ND2 ASN    52       0.299   9.079  17.951  1.00 26.65           N  
ATOM    429  N   GLY    53      -1.017   6.768  14.005  1.00 23.35           N  
ATOM    430  CA  GLY    53      -1.366   7.494  12.812  1.00 23.25           C  
ATOM    431  C   GLY    53      -0.460   8.670  12.473  1.00 22.61           C  
ATOM    432  O   GLY    53      -0.703   9.373  11.499  1.00 24.10           O  
ATOM    433  N   GLU    54       0.538   8.935  13.311  1.00 22.55           N  
ATOM    434  CA  GLU    54       1.405  10.054  13.034  0.50 22.38           C  
ATOM    436  C   GLU    54       2.587   9.612  12.165  1.00 21.93           C  
ATOM    437  O   GLU    54       3.020   8.453  12.207  1.00 20.56           O  
ATOM    438  CB  GLU    54       1.816  10.735  14.347  0.50 22.86           C  
ATOM    440  CG  GLU    54       0.597  11.429  14.982  0.50 23.21           C  
ATOM    442  CD  GLU    54       0.817  12.068  16.340  0.50 25.13           C  
ATOM    444  OE1 GLU    54       1.708  11.658  17.107  0.50 26.68           O  
ATOM    446  OE2 GLU    54       0.037  12.995  16.648  0.50 28.52           O  
ATOM    448  N   THR    55       3.045  10.538  11.335  1.00 21.52           N  
ATOM    449  CA  THR    55       4.233  10.331  10.508  1.00 21.28           C  
ATOM    450  C   THR    55       5.336  11.097  11.229  1.00 21.26           C  
ATOM    451  O   THR    55       5.202  12.280  11.575  1.00 24.07           O  
ATOM    452  CB  THR    55       4.059  10.775   9.067  1.00 22.75           C  
ATOM    453  OG1 THR    55       3.020   9.997   8.430  1.00 23.47           O  
ATOM    454  CG2 THR    55       5.373  10.586   8.283  1.00 23.69           C  
ATOM    455  N   ILE    56       6.388  10.377  11.530  1.00 18.81           N  
ATOM    456  CA  ILE    56       7.560  10.946  12.221  1.00 17.71           C  
ATOM    457  C   ILE    56       8.734  11.049  11.242  1.00 16.62           C  
ATOM    458  O   ILE    56       8.769  10.351  10.240  1.00 15.72           O  
ATOM    459  CB  ILE    56       7.998  10.101  13.463  1.00 16.48           C  
ATOM    460  CG1 ILE    56       8.324   8.643  13.102  1.00 18.49           C  
ATOM    461  CG2 ILE    56       6.891  10.128  14.560  1.00 20.69           C  
ATOM    462  CD1 ILE    56       8.915   7.805  14.252  1.00 18.71           C  
ATOM    463  N   ARG    57       9.641  11.970  11.557  1.00 17.01           N  
ATOM    464  CA  ARG    57      10.857  12.170  10.790  1.00 16.90           C  
ATOM    465  C   ARG    57      12.059  11.961  11.712  1.00 18.52           C  
ATOM    466  O   ARG    57      12.203  12.700  12.712  1.00 18.30           O  
ATOM    467  CB  ARG    57      10.877  13.578  10.175  1.00 18.21           C  
ATOM    468  CG  ARG    57      11.843  13.767   9.044  1.00 22.16           C  
ATOM    469  CD  ARG    57      11.482  15.091   8.275  1.00 22.79           C  
ATOM    470  NE  ARG    57      12.260  15.266   7.076  1.00 30.28           N  
ATOM    471  CZ  ARG    57      13.426  15.885   7.007  1.00 29.98           C  
ATOM    472  NH1 ARG    57      14.012  16.421   8.094  1.00 33.28           N  
ATOM    473  NH2 ARG    57      14.032  15.957   5.829  1.00 32.68           N  
ATOM    474  N   ILE    58      12.936  11.028  11.349  1.00 15.91           N  
ATOM    475  CA  ILE    58      14.128  10.653  12.155  1.00 15.94           C  
ATOM    476  C   ILE    58      15.335  11.194  11.407  1.00 16.27           C  
ATOM    477  O   ILE    58      15.485  10.933  10.213  1.00 14.90           O  
ATOM    478  CB  ILE    58      14.242   9.140  12.377  1.00 16.25           C  
ATOM    479  CG1 ILE    58      12.926   8.623  13.001  1.00 20.10           C  
ATOM    480  CG2 ILE    58      15.455   8.775  13.294  1.00 16.57           C  
ATOM    481  CD1 ILE    58      12.483   7.265  12.468  1.00 23.93           C  
ATOM    482  N   THR    59      16.197  11.910  12.141  1.00 14.89           N  
ATOM    483  CA  THR    59      17.358  12.593  11.568  1.00 14.15           C  
ATOM    484  C   THR    59      18.504  12.573  12.586  1.00 14.35           C  
ATOM    485  O   THR    59      18.307  12.162  13.715  1.00 14.11           O  
ATOM    486  CB  THR    59      17.069  14.081  11.229  1.00 14.81           C  
ATOM    487  OG1 THR    59      16.779  14.818  12.442  1.00 13.82           O  
ATOM    488  CG2 THR    59      15.872  14.174  10.256  1.00 14.18           C  
ATOM    489  N   GLY    60      19.662  13.078  12.202  1.00 13.00           N  
ATOM    490  CA  GLY    60      20.785  13.294  13.142  1.00 14.55           C  
ATOM    491  C   GLY    60      21.076  12.078  14.032  1.00 15.23           C  
ATOM    492  O   GLY    60      21.268  10.956  13.557  1.00 15.55           O  
ATOM    493  N   ASP    61      21.107  12.333  15.323  1.00 14.66           N  
ATOM    494  CA  ASP    61      21.464  11.288  16.310  1.00 15.90           C  
ATOM    495  C   ASP    61      20.544  10.072  16.200  1.00 16.16           C  
ATOM    496  O   ASP    61      20.988   8.929  16.399  1.00 16.88           O  
ATOM    497  CB  ASP    61      21.390  11.842  17.714  1.00 16.78           C  
ATOM    498  CG  ASP    61      22.453  12.862  18.020  1.00 19.80           C  
ATOM    499  OD1 ASP    61      23.417  13.063  17.234  1.00 23.93           O  
ATOM    500  OD2 ASP    61      22.320  13.459  19.136  1.00 27.40           O  
ATOM    501  N   GLY    62      19.269  10.299  15.862  1.00 13.92           N  
ATOM    502  CA  GLY    62      18.296   9.222  15.746  1.00 15.21           C  
ATOM    503  C   GLY    62      18.607   8.184  14.692  1.00 15.36           C  
ATOM    504  O   GLY    62      18.053   7.093  14.739  1.00 16.47           O  
ATOM    505  N   LEU    63      19.447   8.530  13.705  1.00 15.12           N  
ATOM    506  CA  LEU    63      19.813   7.633  12.637  1.00 14.66           C  
ATOM    507  C   LEU    63      21.161   6.929  12.860  1.00 16.62           C  
ATOM    508  O   LEU    63      21.553   6.092  12.067  1.00 17.65           O  
ATOM    509  CB  LEU    63      19.895   8.412  11.307  1.00 14.91           C  
ATOM    510  CG  LEU    63      18.610   9.028  10.816  1.00 14.93           C  
ATOM    511  CD1 LEU    63      18.872   9.730   9.475  1.00 16.30           C  
ATOM    512  CD2 LEU    63      17.484   7.995  10.686  1.00 15.68           C  
ATOM    513  N   LYS    64      21.879   7.292  13.912  1.00 15.36           N  
ATOM    514  CA  LYS    64      23.251   6.825  14.127  0.50 17.84           C  
ATOM    516  C   LYS    64      23.350   5.313  14.202  1.00 17.93           C  
ATOM    517  O   LYS    64      24.201   4.683  13.539  1.00 18.87           O  
ATOM    518  CB  LYS    64      23.803   7.419  15.421  0.50 18.24           C  
ATOM    520  CG  LYS    64      24.118   8.919  15.346  0.50 18.90           C  
ATOM    522  CD  LYS    64      24.682   9.481  16.677  0.50 21.52           C  
ATOM    524  CE  LYS    64      26.140   9.169  16.864  0.50 25.23           C  
ATOM    526  NZ  LYS    64      26.990   9.892  15.880  0.50 27.58           N  
ATOM    528  N   ALA    65      22.489   4.723  15.032  1.00 19.45           N  
ATOM    529  CA  ALA    65      22.573   3.266  15.255  1.00 19.45           C  
ATOM    530  C   ALA    65      22.318   2.519  13.970  1.00 20.13           C  
ATOM    531  O   ALA    65      22.956   1.506  13.706  1.00 21.80           O  
ATOM    532  CB  ALA    65      21.609   2.832  16.300  1.00 20.20           C  
ATOM    533  N   ALA    66      21.444   3.053  13.127  1.00 19.24           N  
ATOM    534  CA  ALA    66      21.020   2.427  11.875  1.00 20.12           C  
ATOM    535  C   ALA    66      21.899   2.739  10.641  1.00 20.14           C  
ATOM    536  O   ALA    66      21.545   2.431   9.497  1.00 19.93           O  
ATOM    537  CB  ALA    66      19.537   2.784  11.608  1.00 19.17           C  
ATOM    538  N   HIS    67      23.032   3.414  10.876  1.00 20.96           N  
ATOM    539  CA  HIS    67      23.874   3.973   9.798  1.00 22.50           C  
ATOM    540  C   HIS    67      24.131   3.057   8.595  1.00 22.69           C  
ATOM    541  O   HIS    67      23.989   3.483   7.437  1.00 23.41           O  
ATOM    542  CB  HIS    67      25.197   4.541  10.372  1.00 23.45           C  
ATOM    543  CG  HIS    67      26.126   3.542  11.028  1.00 26.82           C  
ATOM    544  ND1 HIS    67      25.899   2.978  12.266  1.00 32.13           N  
ATOM    545  CD2 HIS    67      27.348   3.080  10.635  1.00 30.02           C  
ATOM    546  CE1 HIS    67      26.898   2.169  12.582  1.00 33.51           C  
ATOM    547  NE2 HIS    67      27.792   2.218  11.610  1.00 33.86           N  
ATOM    548  N   ARG    68      24.408   1.803   8.879  1.00 23.67           N  
ATOM    549  CA  ARG    68      24.853   0.871   7.842  1.00 25.02           C  
ATOM    550  C   ARG    68      23.705   0.512   6.938  1.00 22.30           C  
ATOM    551  O   ARG    68      23.901   0.185   5.787  1.00 22.56           O  
ATOM    552  CB  ARG    68      25.434  -0.344   8.498  1.00 24.82           C  
ATOM    553  CG  ARG    68      26.707   0.042   9.249  1.00 30.85           C  
ATOM    554  CD  ARG    68      27.251  -1.030  10.152  1.00 31.45           C  
ATOM    555  NE  ARG    68      27.030  -2.400   9.701  1.00 37.79           N  
ATOM    556  CZ  ARG    68      27.584  -2.962   8.632  1.00 38.95           C  
ATOM    557  NH1 ARG    68      28.387  -2.272   7.823  1.00 41.74           N  
ATOM    558  NH2 ARG    68      27.322  -4.240   8.369  1.00 39.77           N  
ATOM    559  N   PHE    69      22.504   0.595   7.497  1.00 19.79           N  
ATOM    560  CA  PHE    69      21.286   0.350   6.733  1.00 19.43           C  
ATOM    561  C   PHE    69      20.734   1.541   5.979  1.00 19.65           C  
ATOM    562  O   PHE    69      19.701   1.423   5.340  1.00 19.12           O  
ATOM    563  CB  PHE    69      20.253  -0.281   7.668  1.00 18.19           C  
ATOM    564  CG  PHE    69      20.676  -1.645   8.125  1.00 18.08           C  
ATOM    565  CD1 PHE    69      21.572  -1.808   9.173  1.00 20.24           C  
ATOM    566  CD2 PHE    69      20.239  -2.769   7.441  1.00 18.30           C  
ATOM    567  CE1 PHE    69      21.988  -3.089   9.532  1.00 18.89           C  
ATOM    568  CE2 PHE    69      20.661  -4.045   7.806  1.00 20.19           C  
ATOM    569  CZ  PHE    69      21.524  -4.186   8.845  1.00 19.83           C  
ATOM    570  N   LEU    70      21.457   2.669   6.005  1.00 20.27           N  
ATOM    571  CA  LEU    70      21.095   3.866   5.245  1.00 22.90           C  
ATOM    572  C   LEU    70      22.208   4.335   4.308  1.00 25.29           C  
ATOM    573  O   LEU    70      22.002   5.257   3.520  1.00 26.73           O  
ATOM    574  CB  LEU    70      20.781   5.012   6.233  1.00 23.31           C  
ATOM    575  CG  LEU    70      19.562   4.755   7.119  1.00 21.31           C  
ATOM    576  CD1 LEU    70      19.661   5.653   8.378  1.00 24.18           C  
ATOM    577  CD2 LEU    70      18.328   5.018   6.305  1.00 20.23           C  
ATOM    578  N   SER    71      23.353   3.653   4.356  1.00 26.45           N  
ATOM    579  CA  SER    71      24.587   4.095   3.688  1.00 27.55           C  
ATOM    580  C   SER    71      24.781   3.559   2.280  1.00 28.74           C  
ATOM    581  O   SER    71      25.758   3.970   1.601  1.00 29.80           O  
ATOM    582  CB  SER    71      25.772   3.565   4.472  1.00 28.48           C  
ATOM    583  OG  SER    71      25.814   2.132   4.350  1.00 29.58           O  
ATOM    584  N   ASN    72      23.919   2.637   1.840  1.00 27.09           N  
ATOM    585  CA  ASN    72      24.109   1.939   0.546  0.50 27.05           C  
ATOM    587  C   ASN    72      25.380   1.091   0.533  1.00 26.48           C  
ATOM    588  O   ASN    72      25.998   0.890  -0.495  1.00 25.99           O  
ATOM    589  CB  ASN    72      24.106   2.893  -0.675  0.50 27.83           C  
ATOM    591  CG  ASN    72      22.703   3.159  -1.234  0.50 28.59           C  
ATOM    593  OD1 ASN    72      21.791   2.300  -1.198  0.50 32.27           O  
ATOM    595  ND2 ASN    72      22.528   4.359  -1.773  0.50 29.54           N  
ATOM    597  N   ASP    73      25.749   0.542   1.686  1.00 25.43           N  
ATOM    598  CA  ASP    73      26.875  -0.421   1.798  1.00 24.74           C  
ATOM    599  C   ASP    73      26.488  -1.639   0.942  1.00 23.75           C  
ATOM    600  O   ASP    73      25.420  -2.208   1.157  1.00 20.54           O  
ATOM    601  CB  ASP    73      27.027  -0.835   3.265  1.00 25.17           C  
ATOM    602  CG  ASP    73      28.020  -1.980   3.495  1.00 26.12           C  
ATOM    603  OD1 ASP    73      28.691  -2.475   2.569  1.00 30.99           O  
ATOM    604  OD2 ASP    73      28.101  -2.401   4.667  1.00 35.81           O  
ATOM    605  N   PRO    74      27.323  -2.022  -0.030  1.00 23.57           N  
ATOM    606  CA  PRO    74      26.905  -3.122  -0.921  1.00 24.30           C  
ATOM    607  C   PRO    74      26.670  -4.459  -0.231  1.00 24.84           C  
ATOM    608  O   PRO    74      25.870  -5.256  -0.709  1.00 26.45           O  
ATOM    609  CB  PRO    74      28.062  -3.203  -1.942  1.00 23.95           C  
ATOM    610  CG  PRO    74      28.658  -1.821  -1.905  1.00 24.58           C  
ATOM    611  CD  PRO    74      28.629  -1.482  -0.450  1.00 24.00           C  
ATOM    612  N   LYS    75      27.332  -4.708   0.891  1.00 25.11           N  
ATOM    613  CA  LYS    75      27.130  -5.948   1.623  1.00 26.59           C  
ATOM    614  C   LYS    75      25.736  -6.045   2.221  1.00 25.93           C  
ATOM    615  O   LYS    75      25.200  -7.135   2.361  1.00 27.46           O  
ATOM    616  CB  LYS    75      28.133  -6.079   2.757  1.00 27.40           C  
ATOM    617  CG  LYS    75      29.571  -6.266   2.291  1.00 30.20           C  
ATOM    618  CD  LYS    75      30.541  -6.071   3.457  1.00 30.42           C  
ATOM    619  CE  LYS    75      31.984  -6.045   2.995  1.00 33.03           C  
ATOM    620  NZ  LYS    75      32.892  -6.078   4.194  1.00 35.70           N  
ATOM    621  N   ILE    76      25.166  -4.913   2.601  1.00 23.73           N  
ATOM    622  CA  ILE    76      23.809  -4.916   3.141  1.00 23.46           C  
ATOM    623  C   ILE    76      22.796  -5.053   1.994  1.00 22.14           C  
ATOM    624  O   ILE    76      21.798  -5.755   2.127  1.00 20.70           O  
ATOM    625  CB  ILE    76      23.584  -3.686   4.022  1.00 24.00           C  
ATOM    626  CG1 ILE    76      24.357  -3.908   5.328  1.00 27.47           C  
ATOM    627  CG2 ILE    76      22.078  -3.476   4.336  1.00 23.08           C  
ATOM    628  CD1 ILE    76      24.772  -2.697   5.964  1.00 30.61           C  
ATOM    629  N   GLY    77      23.054  -4.389   0.872  1.00 21.67           N  
ATOM    630  CA  GLY    77      22.162  -4.511  -0.299  1.00 23.17           C  
ATOM    631  C   GLY    77      20.722  -4.151   0.019  1.00 23.16           C  
ATOM    632  O   GLY    77      20.499  -3.202   0.757  1.00 21.68           O  
ATOM    633  N   GLU    78      19.732  -4.918  -0.484  1.00 23.84           N  
ATOM    634  CA  GLU    78      18.312  -4.590  -0.222  1.00 24.68           C  
ATOM    635  C   GLU    78      17.813  -4.974   1.181  1.00 24.33           C  
ATOM    636  O   GLU    78      16.629  -4.789   1.473  1.00 25.22           O  
ATOM    637  CB  GLU    78      17.364  -5.168  -1.302  1.00 26.64           C  
ATOM    638  CG  GLU    78      17.418  -4.480  -2.675  1.00 29.65           C  
ATOM    639  CD  GLU    78      16.578  -3.175  -2.782  1.00 33.89           C  
ATOM    640  OE1 GLU    78      15.333  -3.239  -3.075  1.00 31.41           O  
ATOM    641  OE2 GLU    78      17.177  -2.079  -2.589  1.00 40.88           O  
ATOM    642  N   LYS    79      18.700  -5.410   2.079  1.00 22.93           N  
ATOM    643  CA  LYS    79      18.361  -5.427   3.493  1.00 23.03           C  
ATOM    644  C   LYS    79      18.274  -4.017   4.070  1.00 20.63           C  
ATOM    645  O   LYS    79      17.859  -3.837   5.206  1.00 20.01           O  
ATOM    646  CB  LYS    79      19.393  -6.225   4.292  1.00 23.69           C  
ATOM    647  CG  LYS    79      19.299  -7.709   3.999  1.00 26.92           C  
ATOM    648  CD  LYS    79      20.379  -8.489   4.748  1.00 28.53           C  
ATOM    649  CE  LYS    79      20.377  -9.959   4.320  1.00 31.81           C  
ATOM    650  NZ  LYS    79      21.343 -10.239   3.217  1.00 34.09           N  
ATOM    651  N   ARG    80      18.704  -3.024   3.298  1.00 21.12           N  
ATOM    652  CA  ARG    80      18.705  -1.639   3.757  1.00 20.87           C  
ATOM    653  C   ARG    80      17.293  -1.138   4.068  1.00 19.89           C  
ATOM    654  O   ARG    80      16.315  -1.671   3.561  1.00 20.87           O  
ATOM    655  CB  ARG    80      19.366  -0.719   2.751  1.00 21.02           C  
ATOM    656  CG  ARG    80      18.562  -0.475   1.551  1.00 22.63           C  
ATOM    657  CD  ARG    80      19.314   0.371   0.508  1.00 25.39           C  
ATOM    658  NE  ARG    80      18.437   0.440  -0.642  1.00 29.73           N  
ATOM    659  CZ  ARG    80      17.483   1.357  -0.864  1.00 32.12           C  
ATOM    660  NH1 ARG    80      17.229   2.386  -0.014  1.00 34.12           N  
ATOM    661  NH2 ARG    80      16.751   1.230  -1.965  1.00 29.96           N  
ATOM    662  N   ILE    81      17.237  -0.105   4.874  1.00 18.86           N  
ATOM    663  CA  ILE    81      15.997   0.629   5.137  1.00 18.98           C  
ATOM    664  C   ILE    81      15.544   1.319   3.844  1.00 19.21           C  
ATOM    665  O   ILE    81      16.338   2.004   3.173  1.00 21.40           O  
ATOM    666  CB  ILE    81      16.197   1.625   6.256  1.00 19.16           C  
ATOM    667  CG1 ILE    81      16.408   0.857   7.574  1.00 18.53           C  
ATOM    668  CG2 ILE    81      15.006   2.601   6.364  1.00 19.73           C  
ATOM    669  CD1 ILE    81      17.055   1.628   8.701  1.00 20.65           C  
ATOM    670  N   ARG    82      14.274   1.128   3.504  1.00 18.22           N  
ATOM    671  CA  ARG    82      13.688   1.557   2.209  0.50 17.65           C  
ATOM    673  C   ARG    82      12.182   1.643   2.425  1.00 17.73           C  
ATOM    674  O   ARG    82      11.660   1.090   3.399  1.00 16.98           O  
ATOM    675  CB  ARG    82      14.008   0.561   1.075  0.50 18.23           C  
ATOM    677  CG  ARG    82      13.015  -0.649   0.888  0.50 16.80           C  
ATOM    679  CD  ARG    82      13.220  -1.403  -0.465  0.50 17.15           C  
ATOM    681  NE  ARG    82      12.162  -2.396  -0.723  0.50 17.23           N  
ATOM    683  CZ  ARG    82      12.274  -3.709  -0.531  0.50 15.45           C  
ATOM    685  NH1 ARG    82      13.430  -4.257  -0.164  0.50 15.77           N  
ATOM    687  NH2 ARG    82      11.228  -4.497  -0.780  0.50 15.69           N  
ATOM    689  N   PRO    83      11.445   2.300   1.510  1.00 17.33           N  
ATOM    690  CA  PRO    83      10.002   2.307   1.757  1.00 16.91           C  
ATOM    691  C   PRO    83       9.361   0.934   1.945  1.00 16.61           C  
ATOM    692  O   PRO    83       9.564   0.019   1.119  1.00 17.77           O  
ATOM    693  CB  PRO    83       9.439   3.036   0.539  1.00 17.58           C  
ATOM    694  CG  PRO    83      10.548   3.837   0.051  1.00 16.41           C  
ATOM    695  CD  PRO    83      11.804   3.087   0.325  1.00 17.89           C  
ATOM    696  N   GLY    84       8.588   0.809   3.007  1.00 14.86           N  
ATOM    697  CA  GLY    84       7.959  -0.434   3.420  1.00 15.67           C  
ATOM    698  C   GLY    84       8.674  -1.152   4.541  1.00 15.52           C  
ATOM    699  O   GLY    84       8.121  -2.067   5.126  1.00 17.23           O  
ATOM    700  N   ALA    85       9.898  -0.737   4.843  1.00 15.34           N  
ATOM    701  CA  ALA    85      10.636  -1.389   5.913  1.00 15.80           C  
ATOM    702  C   ALA    85       9.875  -1.233   7.211  1.00 15.88           C  
ATOM    703  O   ALA    85       9.489  -0.137   7.570  1.00 16.97           O  
ATOM    704  CB  ALA    85      12.004  -0.790   6.026  1.00 15.08           C  
ATOM    705  N   LEU    86       9.720  -2.344   7.924  1.00 18.25           N  
ATOM    706  CA  LEU    86       9.190  -2.359   9.282  1.00 17.93           C  
ATOM    707  C   LEU    86      10.353  -2.152  10.253  1.00 18.43           C  
ATOM    708  O   LEU    86      11.299  -2.955  10.332  1.00 18.46           O  
ATOM    709  CB  LEU    86       8.472  -3.697   9.575  1.00 18.48           C  
ATOM    710  CG  LEU    86       7.905  -3.859  10.985  1.00 20.15           C  
ATOM    711  CD1 LEU    86       6.882  -2.777  11.316  1.00 23.23           C  
ATOM    712  CD2 LEU    86       7.327  -5.271  11.129  1.00 20.48           C  
ATOM    713  N   ILE    87      10.281  -1.045  10.979  1.00 17.40           N  
ATOM    714  CA  ILE    87      11.304  -0.664  11.971  1.00 17.79           C  
ATOM    715  C   ILE    87      10.691  -0.466  13.315  1.00 16.97           C  
ATOM    716  O   ILE    87       9.466  -0.472  13.474  1.00 18.03           O  
ATOM    717  CB  ILE    87      12.079   0.611  11.522  1.00 16.69           C  
ATOM    718  CG1 ILE    87      11.141   1.799  11.307  1.00 17.19           C  
ATOM    719  CG2 ILE    87      12.872   0.270  10.190  1.00 18.98           C  
ATOM    720  CD1 ILE    87      11.823   3.133  11.188  1.00 18.86           C  
ATOM    721  N   ARG    88      11.546  -0.259  14.292  1.00 16.37           N  
ATOM    722  CA  ARG    88      11.104   0.101  15.626  1.00 15.89           C  
ATOM    723  C   ARG    88      11.725   1.441  15.956  1.00 16.06           C  
ATOM    724  O   ARG    88      12.890   1.704  15.645  1.00 15.92           O  
ATOM    725  CB  ARG    88      11.551  -0.950  16.656  1.00 16.91           C  
ATOM    726  CG  ARG    88      11.052  -2.363  16.313  1.00 19.48           C  
ATOM    727  CD  ARG    88       9.563  -2.596  16.597  1.00 22.43           C  
ATOM    728  NE  ARG    88       9.195  -3.877  16.014  1.00 25.15           N  
ATOM    729  CZ  ARG    88       8.005  -4.465  16.140  1.00 24.03           C  
ATOM    730  NH1 ARG    88       7.064  -3.921  16.884  1.00 22.87           N  
ATOM    731  NH2 ARG    88       7.794  -5.626  15.506  1.00 26.11           N  
ATOM    732  N   VAL    89      10.947   2.244  16.646  1.00 16.11           N  
ATOM    733  CA  VAL    89      11.362   3.602  17.021  1.00 15.28           C  
ATOM    734  C   VAL    89      11.067   3.919  18.472  1.00 16.66           C  
ATOM    735  O   VAL    89      10.122   3.363  19.062  1.00 17.18           O  
ATOM    736  CB  VAL    89      10.672   4.637  16.105  1.00 15.17           C  
ATOM    737  CG1 VAL    89      11.089   4.396  14.673  1.00 16.98           C  
ATOM    738  CG2 VAL    89       9.155   4.521  16.206  1.00 17.06           C  
ATOM    739  N   LYS    90      11.848   4.847  19.017  1.00 16.96           N  
ATOM    740  CA  LYS    90      11.616   5.305  20.380  1.00 17.78           C  
ATOM    741  C   LYS    90      11.880   6.822  20.433  1.00 18.76           C  
ATOM    742  O   LYS    90      12.876   7.285  19.874  1.00 18.51           O  
ATOM    743  CB  LYS    90      12.577   4.566  21.301  1.00 18.95           C  
ATOM    744  CG  LYS    90      12.395   4.805  22.797  1.00 19.52           C  
ATOM    745  CD  LYS    90      13.376   3.969  23.591  1.00 22.77           C  
ATOM    746  CE  LYS    90      13.408   4.296  25.059  1.00 29.12           C  
ATOM    747  NZ  LYS    90      12.162   4.691  25.679  1.00 35.66           N  
ATOM    748  N   LYS    91      11.107   7.510  21.260  1.00 18.93           N  
ATOM    749  CA  LYS    91      11.228   8.949  21.424  1.00 19.03           C  
ATOM    750  C   LYS    91      12.187   9.212  22.587  1.00 19.84           C  
ATOM    751  O   LYS    91      11.983   8.683  23.701  1.00 20.14           O  
ATOM    752  CB  LYS    91       9.854   9.552  21.671  1.00 19.81           C  
ATOM    753  CG  LYS    91       9.830  11.072  21.577  1.00 20.93           C  
ATOM    754  CD  LYS    91       8.439  11.593  21.854  1.00 23.85           C  
ATOM    755  CE  LYS    91       8.249  13.016  21.413  1.00 30.64           C  
ATOM    756  NZ  LYS    91       6.944  13.499  21.917  1.00 34.58           N  
ATOM    757  N   THR    92      13.230   9.996  22.360  1.00 19.44           N  
ATOM    758  CA  THR    92      14.153  10.312  23.424  1.00 19.60           C  
ATOM    759  C   THR    92      13.562  11.349  24.389  1.00 18.84           C  
ATOM    760  O   THR    92      12.549  11.999  24.103  1.00 18.25           O  
ATOM    761  CB  THR    92      15.444  10.856  22.895  1.00 19.73           C  
ATOM    762  OG1 THR    92      15.176  12.183  22.388  1.00 21.01           O  
ATOM    763  CG2 THR    92      16.053   9.941  21.791  1.00 19.35           C  
ATOM    764  N   GLU    93      14.205  11.539  25.548  0.50 20.13           N  
ATOM    766  CA  GLU    93      13.705  12.522  26.511  0.50 20.76           C  
ATOM    768  C   GLU    93      13.826  13.956  25.987  0.50 19.67           C  
ATOM    770  O   GLU    93      13.197  14.874  26.521  0.50 19.80           O  
ATOM    772  CB  GLU    93      14.469  12.430  27.835  0.50 21.32           C  
ATOM    774  CG  GLU    93      14.239  11.166  28.623  0.50 23.98           C  
ATOM    776  CD  GLU    93      15.125  11.081  29.854  0.50 24.53           C  
ATOM    778  OE1 GLU    93      15.518   9.957  30.231  0.50 30.98           O  
ATOM    780  OE2 GLU    93      15.430  12.143  30.451  0.50 29.16           O  
ATOM    782  N   LYS    94      14.686  14.166  25.000  1.00 19.01           N  
ATOM    783  CA  LYS    94      14.783  15.473  24.385  1.00 18.39           C  
ATOM    784  C   LYS    94      13.725  15.668  23.293  1.00 16.81           C  
ATOM    785  O   LYS    94      13.533  16.802  22.866  1.00 18.00           O  
ATOM    786  CB  LYS    94      16.183  15.730  23.832  1.00 19.18           C  
ATOM    787  CG  LYS    94      17.248  15.787  24.880  1.00 21.72           C  
ATOM    788  CD  LYS    94      18.600  15.805  24.281  1.00 23.57           C  
ATOM    789  CE  LYS    94      19.662  15.916  25.368  1.00 26.08           C  
ATOM    790  NZ  LYS    94      21.041  15.663  24.797  1.00 29.86           N  
ATOM    791  N   GLY    95      13.022  14.605  22.914  1.00 16.22           N  
ATOM    792  CA  GLY    95      11.841  14.750  22.040  1.00 16.18           C  
ATOM    793  C   GLY    95      11.987  14.255  20.618  1.00 16.84           C  
ATOM    794  O   GLY    95      11.006  14.237  19.886  1.00 17.83           O  
ATOM    795  N   SER    96      13.182  13.851  20.222  1.00 16.29           N  
ATOM    796  CA  SER    96      13.410  13.388  18.856  1.00 15.32           C  
ATOM    797  C   SER    96      13.264  11.874  18.837  1.00 16.22           C  
ATOM    798  O   SER    96      13.576  11.174  19.825  1.00 15.94           O  
ATOM    799  CB  SER    96      14.825  13.781  18.368  1.00 15.41           C  
ATOM    800  OG  SER    96      15.042  15.172  18.223  1.00 17.04           O  
ATOM    801  N   TRP    97      12.799  11.328  17.709  1.00 15.27           N  
ATOM    802  CA  TRP    97      12.673   9.906  17.534  1.00 15.15           C  
ATOM    803  C   TRP    97      13.984   9.306  17.090  1.00 15.23           C  
ATOM    804  O   TRP    97      14.751   9.940  16.370  1.00 15.34           O  
ATOM    805  CB  TRP    97      11.574   9.586  16.500  1.00 16.75           C  
ATOM    806  CG  TRP    97      10.188   9.910  17.049  1.00 17.02           C  
ATOM    807  CD1 TRP    97       9.539  11.094  16.962  1.00 19.56           C  
ATOM    808  CD2 TRP    97       9.317   9.038  17.788  1.00 17.19           C  
ATOM    809  NE1 TRP    97       8.330  11.038  17.621  1.00 18.92           N  
ATOM    810  CE2 TRP    97       8.159   9.773  18.106  1.00 19.29           C  
ATOM    811  CE3 TRP    97       9.412   7.721  18.226  1.00 18.37           C  
ATOM    812  CZ2 TRP    97       7.109   9.234  18.854  1.00 20.16           C  
ATOM    813  CZ3 TRP    97       8.337   7.178  18.931  1.00 17.75           C  
ATOM    814  CH2 TRP    97       7.222   7.945  19.254  1.00 19.63           C  
ATOM    815  N   GLN    98      14.221   8.054  17.494  1.00 15.53           N  
ATOM    816  CA  GLN    98      15.374   7.289  17.078  0.50 15.84           C  
ATOM    818  C   GLN    98      14.962   5.908  16.599  1.00 15.82           C  
ATOM    819  O   GLN    98      13.994   5.322  17.111  1.00 16.55           O  
ATOM    820  CB  GLN    98      16.352   7.171  18.259  0.50 16.46           C  
ATOM    822  CG  GLN    98      15.755   6.389  19.416  0.50 17.45           C  
ATOM    824  CD  GLN    98      16.493   6.471  20.731  0.50 18.58           C  
ATOM    826  OE1 GLN    98      15.872   6.257  21.781  0.50 19.21           O  
ATOM    828  NE2 GLN    98      17.791   6.726  20.694  0.50 20.26           N  
ATOM    830  N   ILE    99      15.703   5.374  15.626  1.00 15.21           N  
ATOM    831  CA  ILE    99      15.526   3.998  15.150  1.00 15.51           C  
ATOM    832  C   ILE    99      16.314   3.078  16.081  1.00 16.61           C  
ATOM    833  O   ILE    99      17.548   3.215  16.279  1.00 16.58           O  
ATOM    834  CB  ILE    99      15.998   3.819  13.727  1.00 16.25           C  
ATOM    835  CG1 ILE    99      15.225   4.730  12.764  1.00 16.91           C  
ATOM    836  CG2 ILE    99      15.907   2.332  13.370  1.00 18.24           C  
ATOM    837  CD1 ILE    99      15.645   4.639  11.292  1.00 16.52           C  
ATOM    838  N   VAL   100      15.562   2.173  16.680  1.00 17.39           N  
ATOM    839  CA  VAL   100      16.095   1.202  17.630  1.00 18.63           C  
ATOM    840  C   VAL   100      15.672  -0.230  17.234  1.00 19.15           C  
ATOM    841  O   VAL   100      15.194  -0.468  16.147  1.00 17.97           O  
ATOM    842  CB  VAL   100      15.581   1.541  19.043  1.00 18.73           C  
ATOM    843  CG1 VAL   100      16.085   2.916  19.465  1.00 18.33           C  
ATOM    844  CG2 VAL   100      14.053   1.456  19.153  1.00 21.54           C  
ATOM    845  N   GLN   101      15.841  -1.182  18.141  1.00 21.54           N  
ATOM    846  CA  GLN   101      15.350  -2.538  17.848  1.00 22.47           C  
ATOM    847  C   GLN   101      14.877  -3.189  19.126  1.00 23.43           C  
ATOM    848  O   GLN   101      15.243  -2.736  20.207  1.00 23.82           O  
ATOM    849  CB  GLN   101      16.395  -3.345  17.139  1.00 23.76           C  
ATOM    850  CG  GLN   101      17.643  -3.604  17.930  1.00 23.42           C  
ATOM    851  CD  GLN   101      18.756  -4.193  17.109  1.00 24.69           C  
ATOM    852  OE1 GLN   101      18.587  -4.586  15.951  1.00 25.77           O  
ATOM    853  NE2 GLN   101      19.941  -4.248  17.713  1.00 30.47           N  
ATOM    854  N   LEU   102      14.003  -4.177  19.000  1.00 25.80           N  
ATOM    855  CA  LEU   102      13.433  -4.833  20.175  1.00 29.29           C  
ATOM    856  C   LEU   102      14.548  -5.593  20.875  1.00 30.90           C  
ATOM    857  O   LEU   102      15.441  -6.127  20.212  1.00 30.78           O  
ATOM    858  CB  LEU   102      12.266  -5.755  19.791  1.00 29.31           C  
ATOM    859  CG  LEU   102      10.972  -5.020  19.413  1.00 30.58           C  
ATOM    860  CD1 LEU   102       9.988  -5.946  18.738  1.00 31.16           C  
ATOM    861  CD2 LEU   102      10.360  -4.260  20.587  1.00 31.70           C  
ATOM    862  N   PRO   103      14.502  -5.653  22.228  1.00 32.79           N  
ATOM    863  CA  PRO   103      15.587  -6.344  22.947  1.00 33.77           C  
ATOM    864  C   PRO   103      15.589  -7.835  22.604  1.00 35.69           C  
ATOM    865  O   PRO   103      14.522  -8.422  22.400  1.00 36.77           O  
ATOM    866  CB  PRO   103      15.235  -6.128  24.423  1.00 34.74           C  
ATOM    867  CG  PRO   103      13.758  -5.776  24.444  1.00 34.13           C  
ATOM    868  CD  PRO   103      13.465  -5.114  23.135  1.00 33.44           C  
ATOM    869  OXT PRO   103      16.642  -8.473  22.459  1.00 37.09           O  
END
