
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  118 (  890),  selected  118 , name 2q2h_A
# Molecule2: number of CA atoms  103 (  801),  selected  103 , name T0409.pdb
# PARAMETERS: 2q2h_A.T0409.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Q    -6_A      Y       1           -
LGA    P    -5_A      R       2           -
LGA    T    -4_A      G       3           -
LGA    A    -3_A      P       4           -
LGA    A    -2_A      E       5           -
LGA    N    -1_A      A       6           -
LGA    S     2_A      F       7           -
LGA    G     3_A      L       8           -
LGA    E     4_A      K       9           -
LGA    -       -      L      10           -
LGA    -       -      P      11           -
LGA    -       -      K      12           -
LGA    -       -      D      13           -
LGA    -       -      L      14           -
LGA    -       -      K      15           -
LGA    -       -      D      16           -
LGA    -       -      R      17           -
LGA    -       -      E      18           -
LGA    -       -      A      19           -
LGA    -       -      L      20           -
LGA    -       -      Q      21           -
LGA    I     5_A      D      22          3.896
LGA    -       -      I      23           -
LGA    S     6_A      M      24          1.124
LGA    -       -      Q      25           -
LGA    -       -      D      26           -
LGA    Y     7_A      I      27          2.393
LGA    A     8_A      G      28          5.589
LGA    D     9_A      -       -           -
LGA    F    10_A      N      29          3.324
LGA    E    11_A      S      30           #
LGA    K    12_A      -       -           -
LGA    V    13_A      D      31          3.832
LGA    D    14_A      D      32          0.334
LGA    I    15_A      I      33          0.771
LGA    R    16_A      L      34          0.797
LGA    V    17_A      A      35          0.731
LGA    G    18_A      A      36          0.824
LGA    T    19_A      V      37          0.148
LGA    I    20_A      V      38          0.321
LGA    V    21_A      L      39          0.492
LGA    E    22_A      S      40          0.957
LGA    A    23_A      A      41          0.483
LGA    V    24_A      T      42          1.235
LGA    P    25_A      P      43          2.361
LGA    F    26_A      G      44          2.543
LGA    P    27_A      -       -           -
LGA    E    28_A      -       -           -
LGA    A    29_A      -       -           -
LGA    R    30_A      -       -           -
LGA    K    31_A      -       -           -
LGA    P    32_A      -       -           -
LGA    A    33_A      -       -           -
LGA    I    34_A      -       -           -
LGA    K    35_A      A      45          2.348
LGA    V    36_A      V      46          0.607
LGA    K    37_A      E      47          0.942
LGA    I    38_A      A      48          1.005
LGA    D    39_A      F      49          0.401
LGA    F    40_A      R      50          0.356
LGA    G    41_A      K      51          2.789
LGA    P    42_A      N      52          3.844
LGA    E    43_A      G      53          4.147
LGA    I    44_A      -       -           -
LGA    G    45_A      E      54          0.669
LGA    I    46_A      T      55          1.057
LGA    K    47_A      I      56          1.191
LGA    K    48_A      R      57          1.787
LGA    S    49_A      I      58          1.819
LGA    -       -      T      59           -
LGA    -       -      G      60           -
LGA    -       -      D      61           -
LGA    -       -      G      62           -
LGA    S    50_A      L      63          2.108
LGA    -       -      K      64           -
LGA    -       -      A      65           -
LGA    A    51_A      A      66          2.625
LGA    Q    52_A      H      67          0.781
LGA    I    53_A      R      68          2.579
LGA    T    54_A      F      69          3.737
LGA    -       -      L      70           -
LGA    -       -      S      71           -
LGA    -       -      N      72           -
LGA    V    55_A      D      73          3.075
LGA    -       -      P      74           -
LGA    -       -      K      75           -
LGA    H    56_A      I      76          1.814
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    Y    57_A      K      79          4.383
LGA    T    58_A      R      80          4.397
LGA    P    59_A      -       -           -
LGA    E    60_A      -       -           -
LGA    S    61_A      I      81           #
LGA    L    62_A      R      82          1.152
LGA    V    63_A      P      83          0.589
LGA    G    64_A      G      84          0.390
LGA    R    65_A      A      85          0.787
LGA    Q    66_A      L      86          0.639
LGA    V    67_A      I      87          0.372
LGA    L    68_A      R      88          1.020
LGA    G    69_A      V      89          1.354
LGA    V    70_A      K      90          1.460
LGA    V    71_A      K      91          3.136
LGA    N    72_A      -       -           -
LGA    F    73_A      T      92          1.611
LGA    P    74_A      E      93          2.688
LGA    P    75_A      K      94          3.854
LGA    R    76_A      G      95           #
LGA    Q    77_A      -       -           -
LGA    I    78_A      -       -           -
LGA    G    79_A      -       -           -
LGA    P    80_A      -       -           -
LGA    F    81_A      -       -           -
LGA    R    82_A      -       -           -
LGA    S    83_A      -       -           -
LGA    E    84_A      S      96          2.376
LGA    V    85_A      W      97          1.619
LGA    L    86_A      Q      98          1.777
LGA    T    87_A      I      99          0.932
LGA    L    88_A      V     100          1.705
LGA    G    89_A      Q     101          4.414
LGA    F    90_A      -       -           -
LGA    A    91_A      -       -           -
LGA    D    92_A      -       -           -
LGA    A    93_A      -       -           -
LGA    N    94_A      -       -           -
LGA    G    95_A      -       -           -
LGA    D    96_A      -       -           -
LGA    I    97_A      -       -           -
LGA    V    98_A      -       -           -
LGA    L    99_A      -       -           -
LGA    A   100_A      -       -           -
LGA    A   101_A      L     102           #
LGA    V   102_A      P     103           -
LGA    E   103_A      -       -           -
LGA    R   104_A      -       -           -
LGA    P   105_A      -       -           -
LGA    V   106_A      -       -           -
LGA    P   107_A      -       -           -
LGA    N   108_A      -       -           -
LGA    G   109_A      -       -           -
LGA    E   110_A      -       -           -
LGA    K   111_A      -       -           -
LGA    M   112_A      -       -           -
LGA    C   113_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  118  103    5.0     61    2.27    11.48     43.734     2.571

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.890383 * X  +   0.439728 * Y  +  -0.117717 * Z  +   3.123320
  Y_new =   0.451476 * X  +   0.819976 * Y  +  -0.351865 * Z  +  26.687717
  Z_new =  -0.058200 * X  +  -0.366441 * Y  +  -0.928619 * Z  +  14.894275 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.765743    0.375850  [ DEG:  -158.4654     21.5346 ]
  Theta =   0.058233    3.083360  [ DEG:     3.3365    176.6635 ]
  Phi   =   2.672314   -0.469278  [ DEG:   153.1123    -26.8877 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2q2h_A                                        
REMARK     2: T0409.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2q2h_A.T0409.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  118  103   5.0   61   2.27   11.48  43.734
REMARK  ---------------------------------------------------------- 
MOLECULE 2q2h_A
HEADER    CHAPERONE                               28-MAY-07   2Q2H              
TITLE     CRYSTAL STRUCTURE OF A PROTEIN / PEPTIDE COMPLEX FROM                 
TITLE    2 AGROBACTERIUM TUMEFACIENS                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SECRETION CHAPERONE, PHAGE-DISPLAY DERIVED                 
COMPND   3 PEPTIDE;                                                             
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 FRAGMENT: FUSION PROTEIN OF A PHAGE-DISPLAY DERIVED                  
COMPND   6 PEPTIDE AND SECRETION CHAPERONE PROTEIN;                             
COMPND   7 SYNONYM: AGR_C_4014P;                                                
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C58/ATCC 33970;                                              
SOURCE   5 GENE: CSAA;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28A                                    
KEYWDS    BETA BARREL, OB FOLD, HOMODIMER, CHAPERONE, PROTEIN                   
KEYWDS   2 SECRETION                                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.R.FELDMAN,Y.A.SHAPOVA,M.PAETZEL                                     
REVDAT   1   01-APR-08 2Q2H    0                                                
JRNL        AUTH   A.R.FELDMAN,Y.A.SHAPOVA,M.PAETZEL                            
JRNL        TITL   CRYSTALLOGRAPHIC ANALYSIS OF ATCSAA                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.65 ANGSTROMS.                                          
DBREF  2Q2H A    2   113  UNP    Q8UDB9   Q8UDB9_AGRT5     2    113             
DBREF  2Q2H B    2   113  UNP    Q8UDB9   Q8UDB9_AGRT5     2    113             
SEQRES   1 A  131  GLY SER HIS MET VAL PRO GLY GLN LYS GLN HIS TYR VAL          
SEQRES   2 A  131  GLN PRO THR ALA ALA ASN SER GLY GLU ILE SER TYR ALA          
SEQRES   3 A  131  ASP PHE GLU LYS VAL ASP ILE ARG VAL GLY THR ILE VAL          
SEQRES   4 A  131  GLU ALA VAL PRO PHE PRO GLU ALA ARG LYS PRO ALA ILE          
SEQRES   5 A  131  LYS VAL LYS ILE ASP PHE GLY PRO GLU ILE GLY ILE LYS          
SEQRES   6 A  131  LYS SER SER ALA GLN ILE THR VAL HIS TYR THR PRO GLU          
SEQRES   7 A  131  SER LEU VAL GLY ARG GLN VAL LEU GLY VAL VAL ASN PHE          
SEQRES   8 A  131  PRO PRO ARG GLN ILE GLY PRO PHE ARG SER GLU VAL LEU          
SEQRES   9 A  131  THR LEU GLY PHE ALA ASP ALA ASN GLY ASP ILE VAL LEU          
SEQRES  10 A  131  ALA ALA VAL GLU ARG PRO VAL PRO ASN GLY GLU LYS MET          
SEQRES  11 A  131  CYS                                                          
SEQRES   1 B  131  GLY SER HIS MET VAL PRO GLY GLN LYS GLN HIS TYR VAL          
SEQRES   2 B  131  GLN PRO THR ALA ALA ASN SER GLY GLU ILE SER TYR ALA          
SEQRES   3 B  131  ASP PHE GLU LYS VAL ASP ILE ARG VAL GLY THR ILE VAL          
SEQRES   4 B  131  GLU ALA VAL PRO PHE PRO GLU ALA ARG LYS PRO ALA ILE          
SEQRES   5 B  131  LYS VAL LYS ILE ASP PHE GLY PRO GLU ILE GLY ILE LYS          
SEQRES   6 B  131  LYS SER SER ALA GLN ILE THR VAL HIS TYR THR PRO GLU          
SEQRES   7 B  131  SER LEU VAL GLY ARG GLN VAL LEU GLY VAL VAL ASN PHE          
SEQRES   8 B  131  PRO PRO ARG GLN ILE GLY PRO PHE ARG SER GLU VAL LEU          
SEQRES   9 B  131  THR LEU GLY PHE ALA ASP ALA ASN GLY ASP ILE VAL LEU          
SEQRES  10 B  131  ALA ALA VAL GLU ARG PRO VAL PRO ASN GLY GLU LYS MET          
SEQRES  11 B  131  CYS                                                          
HET    ACT  B 501       4                                                       
HET    ACT  B 502       4                                                       
HET    CIT  A 601      13                                                       
HETNAM     ACT ACETATE ION                                                      
HETNAM     CIT CITRIC ACID                                                      
FORMUL   3  ACT    2(C2 H3 O2 1-)                                               
FORMUL   5  CIT    C6 H8 O7                                                     
FORMUL   6  HOH   *307(H2 O)                                                    
CRYST1   60.528   60.528  115.247  90.00  90.00 120.00 P 61         12          
ATOM      1  N   GLN A  -6      38.424 -18.004  44.509  1.00  9.65           N  
ATOM      2  CA  GLN A  -6      36.956 -18.225  44.641  1.00  8.58           C  
ATOM      3  C   GLN A  -6      36.157 -17.005  44.191  1.00  8.73           C  
ATOM      4  O   GLN A  -6      36.558 -15.857  44.433  1.00  9.02           O  
ATOM      5  CB  GLN A  -6      36.576 -18.660  46.064  1.00  8.34           C  
ATOM      6  CG  GLN A  -6      37.202 -20.002  46.471  1.00  7.01           C  
ATOM      7  CD  GLN A  -6      36.603 -21.167  45.706  1.00  8.67           C  
ATOM      8  OE1 GLN A  -6      35.481 -21.069  45.206  1.00  9.86           O  
ATOM      9  NE2 GLN A  -6      37.342 -22.269  45.603  1.00  6.22           N  
ATOM     10  N   PRO A  -5      35.047 -17.250  43.486  1.00  8.48           N  
ATOM     11  CA  PRO A  -5      34.280 -16.159  42.888  1.00  7.41           C  
ATOM     12  C   PRO A  -5      33.756 -15.107  43.863  1.00  7.18           C  
ATOM     13  O   PRO A  -5      33.390 -15.413  44.993  1.00  7.18           O  
ATOM     14  CB  PRO A  -5      33.108 -16.889  42.220  1.00  7.89           C  
ATOM     15  CG  PRO A  -5      33.658 -18.234  41.916  1.00  8.19           C  
ATOM     16  CD  PRO A  -5      34.479 -18.566  43.123  1.00  8.39           C  
ATOM     17  N   THR A  -4      33.733 -13.871  43.386  1.00  6.60           N  
ATOM     18  CA  THR A  -4      33.015 -12.786  44.040  1.00  6.26           C  
ATOM     19  C   THR A  -4      32.117 -12.174  42.976  1.00  6.16           C  
ATOM     20  O   THR A  -4      32.300 -12.422  41.787  1.00  5.92           O  
ATOM     21  CB  THR A  -4      33.973 -11.710  44.581  1.00  6.44           C  
ATOM     22  OG1 THR A  -4      34.783 -11.209  43.508  1.00  6.92           O  
ATOM     23  CG2 THR A  -4      34.875 -12.302  45.676  1.00  6.18           C  
ATOM     24  N   ALA A  -3      31.139 -11.380  43.389  1.00  6.08           N  
ATOM     25  CA  ALA A  -3      30.170 -10.857  42.427  1.00  6.09           C  
ATOM     26  C   ALA A  -3      29.624  -9.527  42.869  1.00  6.24           C  
ATOM     27  O   ALA A  -3      29.610  -9.223  44.056  1.00  6.89           O  
ATOM     28  CB  ALA A  -3      29.014 -11.847  42.222  1.00  6.51           C  
ATOM     29  N   ALA A  -2      29.173  -8.759  41.884  1.00  6.62           N  
ATOM     30  CA  ALA A  -2      28.537  -7.470  42.091  1.00  6.35           C  
ATOM     31  C   ALA A  -2      27.030  -7.666  42.214  1.00  6.47           C  
ATOM     32  O   ALA A  -2      26.533  -8.801  42.213  1.00  6.49           O  
ATOM     33  CB  ALA A  -2      28.857  -6.531  40.910  1.00  7.10           C  
ATOM     34  N   ASN A  -1      26.306  -6.559  42.319  1.00  6.23           N  
ATOM     35  CA  ASN A  -1      24.861  -6.607  42.467  1.00  6.40           C  
ATOM     36  C   ASN A  -1      24.151  -7.166  41.236  1.00  5.98           C  
ATOM     37  O   ASN A  -1      24.721  -7.234  40.145  1.00  6.71           O  
ATOM     38  CB  ASN A  -1      24.301  -5.220  42.794  1.00  5.91           C  
ATOM     39  CG  ASN A  -1      24.609  -4.199  41.712  1.00  6.94           C  
ATOM     40  OD1 ASN A  -1      25.703  -3.646  41.663  1.00  5.87           O  
ATOM     41  ND2 ASN A  -1      23.646  -3.964  40.826  1.00  6.57           N  
ATOM     42  N   SER A   2      22.908  -7.575  41.447  1.00  5.62           N  
ATOM     43  CA  SER A   2      22.014  -7.968  40.366  1.00  5.04           C  
ATOM     44  C   SER A   2      21.753  -6.827  39.374  1.00  5.11           C  
ATOM     45  O   SER A   2      21.567  -5.678  39.771  1.00  4.93           O  
ATOM     46  CB  SER A   2      20.683  -8.416  40.968  1.00  5.46           C  
ATOM     47  OG  SER A   2      19.783  -8.811  39.955  1.00  5.65           O  
ATOM     48  N   GLY A   3      21.741  -7.164  38.086  1.00  4.75           N  
ATOM     49  CA  GLY A   3      21.382  -6.210  37.032  1.00  4.69           C  
ATOM     50  C   GLY A   3      19.911  -6.318  36.647  1.00  4.89           C  
ATOM     51  O   GLY A   3      19.505  -5.814  35.603  1.00  5.15           O  
ATOM     52  N   GLU A   4      19.111  -6.959  37.498  1.00  4.87           N  
ATOM     53  CA  GLU A   4      17.702  -7.203  37.174  1.00  5.02           C  
ATOM     54  C   GLU A   4      16.816  -5.972  37.315  1.00  5.17           C  
ATOM     55  O   GLU A   4      17.150  -5.022  38.037  1.00  5.50           O  
ATOM     56  CB  GLU A   4      17.135  -8.383  37.973  1.00  4.87           C  
ATOM     57  CG  GLU A   4      17.754  -9.694  37.539  1.00  5.00           C  
ATOM     58  CD  GLU A   4      17.398 -10.883  38.416  1.00  6.42           C  
ATOM     59  OE1 GLU A   4      17.617 -12.018  37.953  1.00  6.45           O  
ATOM     60  OE2 GLU A   4      16.890 -10.699  39.539  1.00  6.48           O  
ATOM     61  N   ILE A   5      15.699  -6.001  36.589  1.00  4.85           N  
ATOM     62  CA  ILE A   5      14.732  -4.918  36.610  1.00  4.62           C  
ATOM     63  C   ILE A   5      13.312  -5.417  36.877  1.00  4.51           C  
ATOM     64  O   ILE A   5      13.019  -6.613  36.772  1.00  4.89           O  
ATOM     65  CB  ILE A   5      14.746  -4.105  35.279  1.00  4.88           C  
ATOM     66  CG1 ILE A   5      14.449  -5.013  34.081  1.00  4.78           C  
ATOM     67  CG2 ILE A   5      16.100  -3.407  35.096  1.00  3.47           C  
ATOM     68  CD1 ILE A   5      14.146  -4.237  32.776  1.00  5.13           C  
ATOM     69  N   SER A   6      12.447  -4.479  37.237  1.00  4.21           N  
ATOM     70  CA  SER A   6      11.016  -4.737  37.360  1.00  3.73           C  
ATOM     71  C   SER A   6      10.345  -4.677  35.992  1.00  4.10           C  
ATOM     72  O   SER A   6      10.875  -4.102  35.047  1.00  3.83           O  
ATOM     73  CB  SER A   6      10.390  -3.634  38.212  1.00  4.10           C  
ATOM     74  OG  SER A   6      10.556  -2.378  37.553  1.00  2.86           O  
ATOM     75  N   TYR A   7       9.139  -5.223  35.908  1.00  3.99           N  
ATOM     76  CA  TYR A   7       8.357  -5.091  34.697  1.00  4.18           C  
ATOM     77  C   TYR A   7       8.097  -3.606  34.370  1.00  4.15           C  
ATOM     78  O   TYR A   7       8.175  -3.206  33.213  1.00  4.13           O  
ATOM     79  CB  TYR A   7       7.048  -5.886  34.809  1.00  4.27           C  
ATOM     80  CG  TYR A   7       6.071  -5.542  33.716  1.00  5.72           C  
ATOM     81  CD1 TYR A   7       5.072  -4.592  33.932  1.00  7.32           C  
ATOM     82  CD2 TYR A   7       6.154  -6.146  32.467  1.00  6.71           C  
ATOM     83  CE1 TYR A   7       4.176  -4.254  32.934  1.00  8.36           C  
ATOM     84  CE2 TYR A   7       5.260  -5.814  31.458  1.00  6.46           C  
ATOM     85  CZ  TYR A   7       4.276  -4.864  31.705  1.00  7.74           C  
ATOM     86  OH  TYR A   7       3.373  -4.518  30.737  1.00  8.83           O  
ATOM     87  N   ALA A   8       7.801  -2.798  35.392  1.00  4.74           N  
ATOM     88  CA  ALA A   8       7.545  -1.360  35.185  1.00  4.66           C  
ATOM     89  C   ALA A   8       8.691  -0.667  34.448  1.00  4.96           C  
ATOM     90  O   ALA A   8       8.467   0.195  33.596  1.00  5.28           O  
ATOM     91  CB  ALA A   8       7.277  -0.659  36.520  1.00  4.49           C  
ATOM     92  N   ASP A   9       9.921  -1.033  34.797  1.00  5.43           N  
ATOM     93  CA  ASP A   9      11.095  -0.394  34.212  1.00  5.29           C  
ATOM     94  C   ASP A   9      11.347  -0.846  32.777  1.00  5.50           C  
ATOM     95  O   ASP A   9      12.027  -0.157  32.021  1.00  6.08           O  
ATOM     96  CB  ASP A   9      12.326  -0.583  35.105  1.00  5.28           C  
ATOM     97  CG  ASP A   9      12.354   0.398  36.275  1.00  5.82           C  
ATOM     98  OD1 ASP A   9      13.195   0.212  37.174  1.00  5.13           O  
ATOM     99  OD2 ASP A   9      11.563   1.372  36.292  1.00  5.16           O  
ATOM    100  N   PHE A  10      10.787  -1.993  32.416  1.00  5.02           N  
ATOM    101  CA  PHE A  10      10.668  -2.380  31.013  1.00  5.49           C  
ATOM    102  C   PHE A  10       9.508  -1.652  30.312  1.00  6.18           C  
ATOM    103  O   PHE A  10       9.674  -1.108  29.226  1.00  5.88           O  
ATOM    104  CB  PHE A  10      10.465  -3.895  30.897  1.00  5.63           C  
ATOM    105  CG  PHE A  10       9.943  -4.334  29.550  1.00  4.62           C  
ATOM    106  CD1 PHE A  10      10.775  -4.327  28.432  1.00  5.24           C  
ATOM    107  CD2 PHE A  10       8.630  -4.774  29.411  1.00  3.67           C  
ATOM    108  CE1 PHE A  10      10.295  -4.731  27.191  1.00  4.52           C  
ATOM    109  CE2 PHE A  10       8.141  -5.181  28.177  1.00  3.76           C  
ATOM    110  CZ  PHE A  10       8.973  -5.160  27.065  1.00  4.21           C  
ATOM    111  N   GLU A  11       8.327  -1.678  30.924  1.00  6.02           N  
ATOM    112  CA  GLU A  11       7.115  -1.188  30.263  1.00  6.37           C  
ATOM    113  C   GLU A  11       7.230   0.295  29.937  1.00  5.96           C  
ATOM    114  O   GLU A  11       6.686   0.758  28.935  1.00  6.09           O  
ATOM    115  CB  GLU A  11       5.876  -1.469  31.126  1.00  7.08           C  
ATOM    116  CG  GLU A  11       4.524  -1.219  30.427  1.00  8.62           C  
ATOM    117  CD  GLU A  11       4.137   0.264  30.356  1.00 11.97           C  
ATOM    118  OE1 GLU A  11       4.676   1.073  31.153  1.00 12.00           O  
ATOM    119  OE2 GLU A  11       3.289   0.619  29.501  1.00 12.15           O  
ATOM    120  N   LYS A  12       7.951   1.037  30.776  1.00  5.26           N  
ATOM    121  CA  LYS A  12       8.020   2.488  30.606  1.00  4.77           C  
ATOM    122  C   LYS A  12       8.767   2.906  29.339  1.00  4.27           C  
ATOM    123  O   LYS A  12       8.628   4.040  28.894  1.00  3.52           O  
ATOM    124  CB  LYS A  12       8.629   3.171  31.828  1.00  5.26           C  
ATOM    125  CG  LYS A  12      10.117   2.899  32.026  1.00  6.04           C  
ATOM    126  CD  LYS A  12      10.755   3.896  32.999  1.00  8.25           C  
ATOM    127  CE  LYS A  12      10.396   3.640  34.434  1.00 10.06           C  
ATOM    128  NZ  LYS A  12      11.417   4.266  35.352  1.00  9.90           N  
ATOM    129  N   VAL A  13       9.562   1.987  28.791  1.00  4.11           N  
ATOM    130  CA  VAL A  13      10.244   2.191  27.513  1.00  4.27           C  
ATOM    131  C   VAL A  13       9.219   1.897  26.420  1.00  4.55           C  
ATOM    132  O   VAL A  13       8.745   0.771  26.301  1.00  5.29           O  
ATOM    133  CB  VAL A  13      11.455   1.237  27.359  1.00  4.00           C  
ATOM    134  CG1 VAL A  13      12.106   1.419  25.979  1.00  4.76           C  
ATOM    135  CG2 VAL A  13      12.478   1.459  28.478  1.00  4.07           C  
ATOM    136  N   ASP A  14       8.868   2.910  25.633  1.00  4.23           N  
ATOM    137  CA  ASP A  14       7.799   2.745  24.662  1.00  3.57           C  
ATOM    138  C   ASP A  14       8.383   2.401  23.305  1.00  3.79           C  
ATOM    139  O   ASP A  14       8.769   3.284  22.565  1.00  3.34           O  
ATOM    140  CB  ASP A  14       6.942   4.016  24.576  1.00  3.79           C  
ATOM    141  CG  ASP A  14       5.593   3.769  23.925  1.00  4.31           C  
ATOM    142  OD1 ASP A  14       5.402   2.696  23.328  1.00  5.32           O  
ATOM    143  OD2 ASP A  14       4.716   4.645  24.011  1.00  4.15           O  
ATOM    144  N   ILE A  15       8.408   1.110  22.980  1.00  2.92           N  
ATOM    145  CA  ILE A  15       8.944   0.657  21.701  1.00  2.93           C  
ATOM    146  C   ILE A  15       7.769   0.294  20.794  1.00  3.36           C  
ATOM    147  O   ILE A  15       6.932  -0.506  21.171  1.00  3.78           O  
ATOM    148  CB  ILE A  15       9.922  -0.535  21.895  1.00  2.69           C  
ATOM    149  CG1 ILE A  15      11.225  -0.025  22.548  1.00  2.51           C  
ATOM    150  CG2 ILE A  15      10.246  -1.194  20.550  1.00  2.52           C  
ATOM    151  CD1 ILE A  15      12.131  -1.117  23.056  1.00  3.24           C  
ATOM    152  N   ARG A  16       7.726   0.893  19.609  1.00  3.25           N  
ATOM    153  CA  ARG A  16       6.629   0.681  18.660  1.00  2.60           C  
ATOM    154  C   ARG A  16       7.159   0.184  17.343  1.00  2.77           C  
ATOM    155  O   ARG A  16       8.314   0.402  17.023  1.00  2.13           O  
ATOM    156  CB  ARG A  16       5.869   1.983  18.379  1.00  3.09           C  
ATOM    157  CG  ARG A  16       5.287   2.658  19.617  1.00  2.00           C  
ATOM    158  CD  ARG A  16       4.018   1.973  20.105  1.00  2.55           C  
ATOM    159  NE  ARG A  16       3.612   2.435  21.440  1.00  3.26           N  
ATOM    160  CZ  ARG A  16       2.352   2.490  21.853  1.00  5.30           C  
ATOM    161  NH1 ARG A  16       1.368   2.125  21.035  1.00  6.98           N  
ATOM    162  NH2 ARG A  16       2.071   2.911  23.087  1.00  6.64           N  
ATOM    163  N   VAL A  17       6.290  -0.478  16.584  1.00  2.17           N  
ATOM    164  CA  VAL A  17       6.607  -0.862  15.212  1.00  2.11           C  
ATOM    165  C   VAL A  17       5.952   0.169  14.285  1.00  2.61           C  
ATOM    166  O   VAL A  17       4.859   0.635  14.552  1.00  2.11           O  
ATOM    167  CB  VAL A  17       6.132  -2.305  14.913  1.00  2.45           C  
ATOM    168  CG1 VAL A  17       4.643  -2.431  15.130  1.00  2.27           C  
ATOM    169  CG2 VAL A  17       6.513  -2.748  13.495  1.00  2.00           C  
ATOM    170  N   GLY A  18       6.668   0.569  13.238  1.00  2.00           N  
ATOM    171  CA  GLY A  18       6.104   1.467  12.232  1.00  2.79           C  
ATOM    172  C   GLY A  18       6.746   1.228  10.884  1.00  2.77           C  
ATOM    173  O   GLY A  18       7.761   0.547  10.786  1.00  3.33           O  
ATOM    174  N   THR A  19       6.156   1.800   9.844  1.00  2.78           N  
ATOM    175  CA  THR A  19       6.603   1.547   8.477  1.00  2.53           C  
ATOM    176  C   THR A  19       7.353   2.756   7.918  1.00  3.00           C  
ATOM    177  O   THR A  19       6.847   3.871   7.957  1.00  2.90           O  
ATOM    178  CB  THR A  19       5.393   1.251   7.555  1.00  2.50           C  
ATOM    179  OG1 THR A  19       4.649   0.130   8.063  1.00  2.22           O  
ATOM    180  CG2 THR A  19       5.864   0.924   6.137  1.00  3.40           C  
ATOM    181  N   ILE A  20       8.550   2.523   7.395  1.00  2.99           N  
ATOM    182  CA  ILE A  20       9.335   3.582   6.779  1.00  2.46           C  
ATOM    183  C   ILE A  20       8.594   4.080   5.542  1.00  2.91           C  
ATOM    184  O   ILE A  20       8.254   3.291   4.669  1.00  3.14           O  
ATOM    185  CB  ILE A  20      10.736   3.078   6.400  1.00  2.00           C  
ATOM    186  CG1 ILE A  20      11.532   2.782   7.677  1.00  2.26           C  
ATOM    187  CG2 ILE A  20      11.476   4.130   5.561  1.00  2.41           C  
ATOM    188  CD1 ILE A  20      12.895   2.208   7.428  1.00  2.00           C  
ATOM    189  N   VAL A  21       8.347   5.388   5.492  1.00  2.75           N  
ATOM    190  CA  VAL A  21       7.677   6.013   4.343  1.00  2.81           C  
ATOM    191  C   VAL A  21       8.602   6.893   3.498  1.00  2.67           C  
ATOM    192  O   VAL A  21       8.299   7.171   2.348  1.00  3.06           O  
ATOM    193  CB  VAL A  21       6.399   6.783   4.755  1.00  2.43           C  
ATOM    194  CG1 VAL A  21       5.342   5.804   5.278  1.00  3.19           C  
ATOM    195  CG2 VAL A  21       6.687   7.824   5.813  1.00  2.42           C  
ATOM    196  N   GLU A  22       9.714   7.338   4.078  1.00  2.68           N  
ATOM    197  CA  GLU A  22      10.721   8.083   3.322  1.00  2.64           C  
ATOM    198  C   GLU A  22      12.102   7.698   3.820  1.00  2.49           C  
ATOM    199  O   GLU A  22      12.262   7.401   4.990  1.00  2.00           O  
ATOM    200  CB  GLU A  22      10.531   9.584   3.506  1.00  2.83           C  
ATOM    201  CG  GLU A  22      11.464  10.417   2.640  1.00  4.47           C  
ATOM    202  CD  GLU A  22      11.447  11.877   3.019  1.00  7.63           C  
ATOM    203  OE1 GLU A  22      12.509  12.358   3.474  1.00  5.32           O  
ATOM    204  OE2 GLU A  22      10.371  12.518   2.878  1.00  6.10           O  
ATOM    205  N   ALA A  23      13.091   7.714   2.929  1.00  2.27           N  
ATOM    206  CA  ALA A  23      14.478   7.414   3.300  1.00  2.40           C  
ATOM    207  C   ALA A  23      15.404   8.172   2.354  1.00  2.56           C  
ATOM    208  O   ALA A  23      15.212   8.119   1.150  1.00  2.30           O  
ATOM    209  CB  ALA A  23      14.741   5.890   3.243  1.00  2.58           C  
ATOM    210  N   VAL A  24      16.381   8.898   2.904  1.00  2.89           N  
ATOM    211  CA  VAL A  24      17.346   9.646   2.096  1.00  3.13           C  
ATOM    212  C   VAL A  24      18.716   9.582   2.774  1.00  3.55           C  
ATOM    213  O   VAL A  24      18.798   9.299   3.964  1.00  3.62           O  
ATOM    214  CB  VAL A  24      16.961  11.152   1.922  1.00  2.90           C  
ATOM    215  CG1 VAL A  24      15.636  11.325   1.168  1.00  2.72           C  
ATOM    216  CG2 VAL A  24      16.940  11.871   3.256  1.00  3.37           C  
ATOM    217  N   PRO A  25      19.801   9.841   2.024  1.00  4.18           N  
ATOM    218  CA  PRO A  25      21.113   9.883   2.687  1.00  4.60           C  
ATOM    219  C   PRO A  25      21.195  10.951   3.784  1.00  5.25           C  
ATOM    220  O   PRO A  25      20.447  11.931   3.748  1.00  5.54           O  
ATOM    221  CB  PRO A  25      22.078  10.205   1.539  1.00  4.89           C  
ATOM    222  CG  PRO A  25      21.370   9.763   0.305  1.00  4.09           C  
ATOM    223  CD  PRO A  25      19.910  10.053   0.566  1.00  4.00           C  
ATOM    224  N   PHE A  26      22.084  10.751   4.754  1.00  5.64           N  
ATOM    225  CA  PHE A  26      22.259  11.703   5.849  1.00  6.05           C  
ATOM    226  C   PHE A  26      23.646  12.335   5.698  1.00  6.54           C  
ATOM    227  O   PHE A  26      24.620  11.870   6.291  1.00  7.31           O  
ATOM    228  CB  PHE A  26      22.107  10.986   7.195  1.00  5.97           C  
ATOM    229  CG  PHE A  26      22.105  11.901   8.391  1.00  5.89           C  
ATOM    230  CD1 PHE A  26      22.335  13.276   8.256  1.00  5.92           C  
ATOM    231  CD2 PHE A  26      21.895  11.373   9.667  1.00  5.86           C  
ATOM    232  CE1 PHE A  26      22.336  14.112   9.373  1.00  5.67           C  
ATOM    233  CE2 PHE A  26      21.907  12.197  10.793  1.00  4.27           C  
ATOM    234  CZ  PHE A  26      22.126  13.579  10.639  1.00  5.64           C  
ATOM    235  N   PRO A  27      23.729  13.420   4.907  1.00  6.84           N  
ATOM    236  CA  PRO A  27      25.024  13.899   4.400  1.00  6.12           C  
ATOM    237  C   PRO A  27      26.057  14.241   5.477  1.00  5.71           C  
ATOM    238  O   PRO A  27      27.258  14.045   5.271  1.00  5.77           O  
ATOM    239  CB  PRO A  27      24.644  15.163   3.609  1.00  6.36           C  
ATOM    240  CG  PRO A  27      23.212  14.975   3.257  1.00  7.36           C  
ATOM    241  CD  PRO A  27      22.603  14.240   4.413  1.00  6.96           C  
ATOM    242  N   GLU A  28      25.583  14.724   6.620  1.00  5.28           N  
ATOM    243  CA  GLU A  28      26.468  15.265   7.654  1.00  5.12           C  
ATOM    244  C   GLU A  28      26.919  14.208   8.653  1.00  4.64           C  
ATOM    245  O   GLU A  28      27.773  14.479   9.509  1.00  4.64           O  
ATOM    246  CB  GLU A  28      25.772  16.414   8.386  1.00  5.08           C  
ATOM    247  CG  GLU A  28      25.328  17.560   7.462  1.00  5.45           C  
ATOM    248  CD  GLU A  28      23.934  17.357   6.867  1.00  6.41           C  
ATOM    249  OE1 GLU A  28      23.473  18.256   6.128  1.00  5.44           O  
ATOM    250  OE2 GLU A  28      23.298  16.310   7.132  1.00  7.51           O  
ATOM    251  N   ALA A  29      26.350  13.008   8.544  1.00  4.37           N  
ATOM    252  CA  ALA A  29      26.670  11.924   9.482  1.00  4.24           C  
ATOM    253  C   ALA A  29      28.159  11.591   9.488  1.00  4.17           C  
ATOM    254  O   ALA A  29      28.802  11.589   8.448  1.00  4.61           O  
ATOM    255  CB  ALA A  29      25.849  10.692   9.164  1.00  4.60           C  
ATOM    256  N   ARG A  30      28.703  11.326  10.670  1.00  3.67           N  
ATOM    257  CA  ARG A  30      30.129  11.032  10.790  1.00  3.62           C  
ATOM    258  C   ARG A  30      30.466   9.713  10.116  1.00  3.86           C  
ATOM    259  O   ARG A  30      31.466   9.602   9.405  1.00  3.89           O  
ATOM    260  CB  ARG A  30      30.549  10.982  12.258  1.00  3.48           C  
ATOM    261  CG  ARG A  30      32.030  10.680  12.434  1.00  3.68           C  
ATOM    262  CD  ARG A  30      32.502  10.959  13.843  1.00  5.15           C  
ATOM    263  NE  ARG A  30      33.938  10.706  13.977  1.00  6.67           N  
ATOM    264  CZ  ARG A  30      34.482   9.503  14.161  1.00  8.15           C  
ATOM    265  NH1 ARG A  30      33.715   8.420  14.247  1.00  8.62           N  
ATOM    266  NH2 ARG A  30      35.800   9.382  14.260  1.00  7.68           N  
ATOM    267  N   LYS A  31      29.633   8.715  10.393  1.00  3.99           N  
ATOM    268  CA  LYS A  31      29.683   7.424   9.721  1.00  3.99           C  
ATOM    269  C   LYS A  31      28.438   7.339   8.841  1.00  3.84           C  
ATOM    270  O   LYS A  31      27.404   7.912   9.185  1.00  3.77           O  
ATOM    271  CB  LYS A  31      29.698   6.280  10.738  1.00  3.87           C  
ATOM    272  CG  LYS A  31      30.982   6.190  11.547  1.00  5.82           C  
ATOM    273  CD  LYS A  31      30.873   5.097  12.584  1.00  8.34           C  
ATOM    274  CE  LYS A  31      32.156   4.957  13.377  1.00  9.73           C  
ATOM    275  NZ  LYS A  31      31.898   4.123  14.600  1.00 10.75           N  
ATOM    276  N   PRO A  32      28.531   6.660   7.687  1.00  3.76           N  
ATOM    277  CA  PRO A  32      27.394   6.687   6.755  1.00  3.73           C  
ATOM    278  C   PRO A  32      26.048   6.355   7.411  1.00  3.53           C  
ATOM    279  O   PRO A  32      25.954   5.432   8.215  1.00  3.26           O  
ATOM    280  CB  PRO A  32      27.782   5.642   5.710  1.00  3.67           C  
ATOM    281  CG  PRO A  32      29.279   5.678   5.708  1.00  4.25           C  
ATOM    282  CD  PRO A  32      29.663   5.880   7.150  1.00  3.72           C  
ATOM    283  N   ALA A  33      25.026   7.133   7.081  1.00  3.40           N  
ATOM    284  CA  ALA A  33      23.711   6.943   7.663  1.00  3.22           C  
ATOM    285  C   ALA A  33      22.618   7.364   6.705  1.00  3.21           C  
ATOM    286  O   ALA A  33      22.857   8.048   5.705  1.00  3.60           O  
ATOM    287  CB  ALA A  33      23.576   7.718   8.975  1.00  3.54           C  
ATOM    288  N   ILE A  34      21.415   6.935   7.050  1.00  2.40           N  
ATOM    289  CA  ILE A  34      20.220   7.227   6.287  1.00  2.70           C  
ATOM    290  C   ILE A  34      19.217   7.867   7.234  1.00  2.48           C  
ATOM    291  O   ILE A  34      19.020   7.368   8.344  1.00  2.85           O  
ATOM    292  CB  ILE A  34      19.621   5.948   5.651  1.00  2.52           C  
ATOM    293  CG1 ILE A  34      20.599   5.347   4.624  1.00  2.21           C  
ATOM    294  CG2 ILE A  34      18.222   6.260   5.045  1.00  2.29           C  
ATOM    295  CD1 ILE A  34      20.135   4.041   4.014  1.00  2.99           C  
ATOM    296  N   LYS A  35      18.609   8.969   6.790  1.00  2.00           N  
ATOM    297  CA  LYS A  35      17.508   9.653   7.502  1.00  2.19           C  
ATOM    298  C   LYS A  35      16.190   9.078   7.001  1.00  2.00           C  
ATOM    299  O   LYS A  35      16.001   8.920   5.803  1.00  2.00           O  
ATOM    300  CB  LYS A  35      17.512  11.159   7.228  1.00  2.24           C  
ATOM    301  CG  LYS A  35      18.693  11.891   7.846  1.00  3.07           C  
ATOM    302  CD  LYS A  35      18.550  13.393   7.757  1.00  4.42           C  
ATOM    303  CE  LYS A  35      18.671  13.911   6.354  1.00  4.84           C  
ATOM    304  NZ  LYS A  35      18.519  15.398   6.359  1.00  3.78           N  
ATOM    305  N   VAL A  36      15.293   8.766   7.921  1.00  2.00           N  
ATOM    306  CA  VAL A  36      14.021   8.150   7.571  1.00  2.00           C  
ATOM    307  C   VAL A  36      12.850   8.894   8.193  1.00  2.00           C  
ATOM    308  O   VAL A  36      12.999   9.572   9.197  1.00  2.00           O  
ATOM    309  CB  VAL A  36      13.940   6.649   8.012  1.00  2.00           C  
ATOM    310  CG1 VAL A  36      14.947   5.789   7.239  1.00  2.37           C  
ATOM    311  CG2 VAL A  36      14.118   6.485   9.523  1.00  2.00           C  
ATOM    312  N   LYS A  37      11.683   8.749   7.584  1.00  2.00           N  
ATOM    313  CA  LYS A  37      10.433   9.113   8.230  1.00  2.09           C  
ATOM    314  C   LYS A  37       9.659   7.818   8.392  1.00  2.75           C  
ATOM    315  O   LYS A  37       9.555   7.059   7.447  1.00  2.17           O  
ATOM    316  CB  LYS A  37       9.651  10.103   7.371  1.00  2.14           C  
ATOM    317  CG  LYS A  37      10.298  11.479   7.319  1.00  2.05           C  
ATOM    318  CD  LYS A  37       9.553  12.435   6.412  1.00  3.21           C  
ATOM    319  CE  LYS A  37      10.355  13.721   6.268  1.00  4.43           C  
ATOM    320  NZ  LYS A  37       9.843  14.584   5.163  1.00  6.32           N  
ATOM    321  N   ILE A  38       9.148   7.568   9.592  1.00  2.91           N  
ATOM    322  CA  ILE A  38       8.467   6.312   9.909  1.00  2.94           C  
ATOM    323  C   ILE A  38       7.000   6.559  10.302  1.00  3.18           C  
ATOM    324  O   ILE A  38       6.728   7.354  11.194  1.00  2.74           O  
ATOM    325  CB  ILE A  38       9.157   5.593  11.091  1.00  3.07           C  
ATOM    326  CG1 ILE A  38      10.665   5.421  10.825  1.00  2.55           C  
ATOM    327  CG2 ILE A  38       8.484   4.251  11.361  1.00  3.49           C  
ATOM    328  CD1 ILE A  38      11.490   5.252  12.091  1.00  3.42           C  
ATOM    329  N   ASP A  39       6.070   5.851   9.664  1.00  2.63           N  
ATOM    330  CA  ASP A  39       4.663   6.007   9.994  1.00  2.55           C  
ATOM    331  C   ASP A  39       4.335   5.060  11.132  1.00  3.04           C  
ATOM    332  O   ASP A  39       4.246   3.854  10.928  1.00  3.31           O  
ATOM    333  CB  ASP A  39       3.789   5.674   8.779  1.00  2.08           C  
ATOM    334  CG  ASP A  39       2.304   5.862   9.043  1.00  2.79           C  
ATOM    335  OD1 ASP A  39       1.908   6.153  10.197  1.00  3.19           O  
ATOM    336  OD2 ASP A  39       1.517   5.700   8.087  1.00  2.61           O  
ATOM    337  N   PHE A  40       4.159   5.617  12.328  1.00  3.07           N  
ATOM    338  CA  PHE A  40       3.804   4.801  13.483  1.00  3.38           C  
ATOM    339  C   PHE A  40       2.291   4.698  13.696  1.00  3.57           C  
ATOM    340  O   PHE A  40       1.824   4.396  14.796  1.00  3.56           O  
ATOM    341  CB  PHE A  40       4.504   5.310  14.736  1.00  3.15           C  
ATOM    342  CG  PHE A  40       5.963   4.967  14.796  1.00  2.57           C  
ATOM    343  CD1 PHE A  40       6.925   5.936  14.551  1.00  3.00           C  
ATOM    344  CD2 PHE A  40       6.376   3.684  15.115  1.00  2.46           C  
ATOM    345  CE1 PHE A  40       8.282   5.632  14.618  1.00  2.91           C  
ATOM    346  CE2 PHE A  40       7.728   3.368  15.186  1.00  2.57           C  
ATOM    347  CZ  PHE A  40       8.679   4.340  14.941  1.00  3.15           C  
ATOM    348  N   GLY A  41       1.525   4.927  12.635  1.00  3.76           N  
ATOM    349  CA  GLY A  41       0.074   4.802  12.717  1.00  4.15           C  
ATOM    350  C   GLY A  41      -0.634   6.110  13.022  1.00  4.70           C  
ATOM    351  O   GLY A  41      -0.002   7.122  13.289  1.00  4.14           O  
ATOM    352  N   PRO A  42      -1.968   6.088  12.981  1.00  5.33           N  
ATOM    353  CA  PRO A  42      -2.750   7.315  13.095  1.00  5.78           C  
ATOM    354  C   PRO A  42      -2.633   8.068  14.423  1.00  6.35           C  
ATOM    355  O   PRO A  42      -2.791   9.296  14.428  1.00  6.92           O  
ATOM    356  CB  PRO A  42      -4.190   6.852  12.852  1.00  5.94           C  
ATOM    357  CG  PRO A  42      -4.183   5.369  13.020  1.00  5.91           C  
ATOM    358  CD  PRO A  42      -2.803   4.893  12.744  1.00  5.49           C  
ATOM    359  N   GLU A  43      -2.370   7.369  15.530  1.00  6.07           N  
ATOM    360  CA  GLU A  43      -2.246   8.052  16.826  1.00  6.02           C  
ATOM    361  C   GLU A  43      -0.884   8.733  16.969  1.00  6.01           C  
ATOM    362  O   GLU A  43      -0.804   9.943  17.205  1.00  5.84           O  
ATOM    363  CB  GLU A  43      -2.511   7.089  17.992  1.00  6.16           C  
ATOM    364  N   ILE A  44       0.183   7.959  16.796  1.00  5.53           N  
ATOM    365  CA  ILE A  44       1.535   8.484  16.955  1.00  5.81           C  
ATOM    366  C   ILE A  44       1.948   9.372  15.780  1.00  5.82           C  
ATOM    367  O   ILE A  44       2.571  10.418  15.971  1.00  6.09           O  
ATOM    368  CB  ILE A  44       2.559   7.349  17.194  1.00  5.80           C  
ATOM    369  CG1 ILE A  44       2.254   6.654  18.528  1.00  6.64           C  
ATOM    370  CG2 ILE A  44       3.996   7.902  17.162  1.00  5.80           C  
ATOM    371  CD1 ILE A  44       2.832   5.251  18.650  1.00  9.33           C  
ATOM    372  N   GLY A  45       1.579   8.961  14.574  1.00  5.65           N  
ATOM    373  CA  GLY A  45       1.882   9.735  13.378  1.00  5.01           C  
ATOM    374  C   GLY A  45       3.253   9.437  12.824  1.00  4.97           C  
ATOM    375  O   GLY A  45       3.874   8.440  13.178  1.00  4.80           O  
ATOM    376  N   ILE A  46       3.716  10.317  11.944  1.00  4.35           N  
ATOM    377  CA  ILE A  46       4.962  10.096  11.236  1.00  4.70           C  
ATOM    378  C   ILE A  46       6.086  10.774  12.003  1.00  5.10           C  
ATOM    379  O   ILE A  46       5.962  11.941  12.393  1.00  5.62           O  
ATOM    380  CB  ILE A  46       4.871  10.589   9.772  1.00  4.94           C  
ATOM    381  CG1 ILE A  46       3.833   9.743   9.008  1.00  4.97           C  
ATOM    382  CG2 ILE A  46       6.256  10.550   9.103  1.00  3.55           C  
ATOM    383  CD1 ILE A  46       3.426  10.298   7.646  1.00  4.67           C  
ATOM    384  N   LYS A  47       7.167  10.025  12.219  1.00  4.90           N  
ATOM    385  CA  LYS A  47       8.276  10.484  13.053  1.00  4.65           C  
ATOM    386  C   LYS A  47       9.602  10.378  12.324  1.00  4.60           C  
ATOM    387  O   LYS A  47       9.807   9.459  11.532  1.00  4.69           O  
ATOM    388  CB  LYS A  47       8.368   9.657  14.334  1.00  5.24           C  
ATOM    389  CG  LYS A  47       7.172   9.779  15.262  1.00  5.10           C  
ATOM    390  CD  LYS A  47       7.035  11.188  15.840  1.00  6.64           C  
ATOM    391  CE  LYS A  47       5.789  11.304  16.730  1.00  7.83           C  
ATOM    392  NZ  LYS A  47       5.626  12.693  17.264  1.00  7.79           N  
ATOM    393  N   LYS A  48      10.508  11.305  12.631  1.00  4.39           N  
ATOM    394  CA  LYS A  48      11.838  11.326  12.023  1.00  3.90           C  
ATOM    395  C   LYS A  48      12.864  10.500  12.800  1.00  4.08           C  
ATOM    396  O   LYS A  48      12.890  10.523  14.032  1.00  4.09           O  
ATOM    397  CB  LYS A  48      12.354  12.764  11.949  1.00  4.12           C  
ATOM    398  CG  LYS A  48      11.587  13.683  10.992  1.00  3.59           C  
ATOM    399  CD  LYS A  48      12.251  15.054  10.946  1.00  7.89           C  
ATOM    400  CE  LYS A  48      11.840  15.846  12.152  1.00  9.55           C  
ATOM    401  NZ  LYS A  48      12.623  17.119  12.310  1.00  9.99           N  
ATOM    402  N   SER A  49      13.751   9.815  12.080  1.00  3.53           N  
ATOM    403  CA  SER A  49      14.837   9.080  12.729  1.00  3.73           C  
ATOM    404  C   SER A  49      15.990   8.936  11.747  1.00  3.58           C  
ATOM    405  O   SER A  49      15.894   9.373  10.597  1.00  3.42           O  
ATOM    406  CB  SER A  49      14.346   7.698  13.212  1.00  3.21           C  
ATOM    407  OG  SER A  49      15.342   6.990  13.947  1.00  3.46           O  
ATOM    408  N   SER A  50      17.094   8.356  12.210  1.00  3.75           N  
ATOM    409  CA  SER A  50      18.212   8.048  11.330  1.00  4.12           C  
ATOM    410  C   SER A  50      18.856   6.757  11.807  1.00  4.70           C  
ATOM    411  O   SER A  50      18.687   6.355  12.959  1.00  4.74           O  
ATOM    412  CB  SER A  50      19.249   9.176  11.326  1.00  4.11           C  
ATOM    413  OG  SER A  50      19.828   9.354  12.607  1.00  4.29           O  
ATOM    414  N   ALA A  51      19.602   6.110  10.928  1.00  4.45           N  
ATOM    415  CA  ALA A  51      20.282   4.888  11.335  1.00  4.93           C  
ATOM    416  C   ALA A  51      21.520   4.623  10.503  1.00  5.06           C  
ATOM    417  O   ALA A  51      21.605   5.021   9.343  1.00  4.92           O  
ATOM    418  CB  ALA A  51      19.328   3.703  11.293  1.00  5.43           C  
ATOM    419  N   GLN A  52      22.475   3.936  11.118  1.00  4.77           N  
ATOM    420  CA  GLN A  52      23.750   3.632  10.489  1.00  4.37           C  
ATOM    421  C   GLN A  52      23.587   2.335   9.692  1.00  4.42           C  
ATOM    422  O   GLN A  52      24.159   1.298  10.045  1.00  4.00           O  
ATOM    423  CB  GLN A  52      24.794   3.480  11.581  1.00  4.96           C  
ATOM    424  CG  GLN A  52      26.215   3.336  11.108  1.00  4.96           C  
ATOM    425  CD  GLN A  52      27.170   3.581  12.247  1.00  5.06           C  
ATOM    426  OE1 GLN A  52      27.278   4.707  12.734  1.00  4.61           O  
ATOM    427  NE2 GLN A  52      27.846   2.520  12.709  1.00  7.61           N  
ATOM    428  N   ILE A  53      22.808   2.408   8.614  1.00  3.80           N  
ATOM    429  CA  ILE A  53      22.297   1.195   7.961  1.00  4.27           C  
ATOM    430  C   ILE A  53      22.532   1.160   6.446  1.00  4.33           C  
ATOM    431  O   ILE A  53      21.742   0.583   5.697  1.00  4.58           O  
ATOM    432  CB  ILE A  53      20.788   0.960   8.301  1.00  3.95           C  
ATOM    433  CG1 ILE A  53      19.930   2.188   7.927  1.00  4.13           C  
ATOM    434  CG2 ILE A  53      20.614   0.538   9.775  1.00  4.90           C  
ATOM    435  CD1 ILE A  53      18.411   1.943   8.010  1.00  4.28           C  
ATOM    436  N   THR A  54      23.643   1.754   6.003  1.00  4.17           N  
ATOM    437  CA  THR A  54      23.941   1.839   4.565  1.00  4.62           C  
ATOM    438  C   THR A  54      24.565   0.564   3.996  1.00  4.64           C  
ATOM    439  O   THR A  54      24.648   0.402   2.773  1.00  5.21           O  
ATOM    440  CB  THR A  54      24.899   3.013   4.233  1.00  4.63           C  
ATOM    441  OG1 THR A  54      26.183   2.770   4.824  1.00  5.17           O  
ATOM    442  CG2 THR A  54      24.327   4.351   4.706  1.00  5.09           C  
ATOM    443  N   VAL A  55      25.036  -0.328   4.871  1.00  4.92           N  
ATOM    444  CA  VAL A  55      25.706  -1.545   4.411  1.00  4.90           C  
ATOM    445  C   VAL A  55      24.708  -2.559   3.837  1.00  4.65           C  
ATOM    446  O   VAL A  55      24.868  -3.004   2.692  1.00  5.27           O  
ATOM    447  CB  VAL A  55      26.606  -2.172   5.509  1.00  5.05           C  
ATOM    448  CG1 VAL A  55      27.122  -3.556   5.077  1.00  4.82           C  
ATOM    449  CG2 VAL A  55      27.771  -1.246   5.814  1.00  4.79           C  
ATOM    450  N   HIS A  56      23.689  -2.916   4.619  1.00  4.79           N  
ATOM    451  CA  HIS A  56      22.707  -3.916   4.178  1.00  4.82           C  
ATOM    452  C   HIS A  56      21.453  -3.336   3.508  1.00  5.02           C  
ATOM    453  O   HIS A  56      20.669  -4.088   2.924  1.00  5.89           O  
ATOM    454  CB  HIS A  56      22.262  -4.817   5.346  1.00  4.75           C  
ATOM    455  CG  HIS A  56      23.385  -5.528   6.037  1.00  4.91           C  
ATOM    456  ND1 HIS A  56      24.338  -6.265   5.363  1.00  4.06           N  
ATOM    457  CD2 HIS A  56      23.686  -5.638   7.353  1.00  4.25           C  
ATOM    458  CE1 HIS A  56      25.186  -6.784   6.235  1.00  4.87           C  
ATOM    459  NE2 HIS A  56      24.811  -6.418   7.449  1.00  3.80           N  
ATOM    460  N   TYR A  57      21.252  -2.023   3.620  1.00  4.68           N  
ATOM    461  CA  TYR A  57      20.009  -1.379   3.162  1.00  4.69           C  
ATOM    462  C   TYR A  57      20.290  -0.191   2.245  1.00  4.77           C  
ATOM    463  O   TYR A  57      21.418   0.319   2.196  1.00  5.24           O  
ATOM    464  CB  TYR A  57      19.120  -0.949   4.354  1.00  4.78           C  
ATOM    465  CG  TYR A  57      19.009  -2.029   5.412  1.00  3.58           C  
ATOM    466  CD1 TYR A  57      19.904  -2.072   6.482  1.00  3.39           C  
ATOM    467  CD2 TYR A  57      18.049  -3.046   5.315  1.00  3.78           C  
ATOM    468  CE1 TYR A  57      19.826  -3.076   7.447  1.00  2.04           C  
ATOM    469  CE2 TYR A  57      17.958  -4.055   6.279  1.00  2.13           C  
ATOM    470  CZ  TYR A  57      18.861  -4.076   7.332  1.00  2.19           C  
ATOM    471  OH  TYR A  57      18.786  -5.074   8.283  1.00  2.16           O  
ATOM    472  N   THR A  58      19.255   0.223   1.513  1.00  4.71           N  
ATOM    473  CA  THR A  58      19.312   1.396   0.634  1.00  5.02           C  
ATOM    474  C   THR A  58      18.053   2.230   0.853  1.00  5.15           C  
ATOM    475  O   THR A  58      17.026   1.689   1.279  1.00  5.21           O  
ATOM    476  CB  THR A  58      19.339   1.004  -0.860  1.00  5.75           C  
ATOM    477  OG1 THR A  58      18.060   0.472  -1.235  1.00  6.33           O  
ATOM    478  CG2 THR A  58      20.419  -0.012  -1.137  1.00  5.62           C  
ATOM    479  N   PRO A  59      18.119   3.544   0.565  1.00  4.58           N  
ATOM    480  CA  PRO A  59      16.899   4.354   0.613  1.00  4.67           C  
ATOM    481  C   PRO A  59      15.750   3.783  -0.232  1.00  4.66           C  
ATOM    482  O   PRO A  59      14.585   3.942   0.132  1.00  4.98           O  
ATOM    483  CB  PRO A  59      17.357   5.715   0.066  1.00  4.70           C  
ATOM    484  CG  PRO A  59      18.823   5.777   0.429  1.00  4.18           C  
ATOM    485  CD  PRO A  59      19.307   4.355   0.224  1.00  5.05           C  
ATOM    486  N   GLU A  60      16.074   3.115  -1.340  1.00  4.26           N  
ATOM    487  CA  GLU A  60      15.047   2.593  -2.238  1.00  4.03           C  
ATOM    488  C   GLU A  60      14.338   1.360  -1.681  1.00  4.23           C  
ATOM    489  O   GLU A  60      13.125   1.193  -1.898  1.00  4.17           O  
ATOM    490  CB  GLU A  60      15.656   2.280  -3.603  1.00  4.30           C  
ATOM    491  CG  GLU A  60      16.179   3.513  -4.323  1.00  4.47           C  
ATOM    492  CD  GLU A  60      17.496   4.051  -3.753  1.00  6.10           C  
ATOM    493  OE1 GLU A  60      18.358   3.243  -3.338  1.00  4.61           O  
ATOM    494  OE2 GLU A  60      17.672   5.293  -3.736  1.00  7.70           O  
ATOM    495  N   SER A  61      15.107   0.526  -0.971  1.00  3.83           N  
ATOM    496  CA  SER A  61      14.640  -0.755  -0.401  1.00  4.36           C  
ATOM    497  C   SER A  61      14.023  -0.583   0.982  1.00  3.82           C  
ATOM    498  O   SER A  61      13.288  -1.455   1.449  1.00  3.37           O  
ATOM    499  CB  SER A  61      15.811  -1.771  -0.314  1.00  4.44           C  
ATOM    500  OG  SER A  61      16.633  -1.512   0.827  1.00  8.52           O  
ATOM    501  N   LEU A  62      14.337   0.528   1.646  1.00  2.96           N  
ATOM    502  CA  LEU A  62      13.851   0.751   3.016  1.00  2.82           C  
ATOM    503  C   LEU A  62      12.377   1.161   3.080  1.00  2.81           C  
ATOM    504  O   LEU A  62      11.677   0.866   4.066  1.00  3.09           O  
ATOM    505  CB  LEU A  62      14.708   1.799   3.719  1.00  2.41           C  
ATOM    506  CG  LEU A  62      16.047   1.281   4.243  1.00  2.25           C  
ATOM    507  CD1 LEU A  62      16.905   2.477   4.659  1.00  3.04           C  
ATOM    508  CD2 LEU A  62      15.861   0.312   5.417  1.00  2.17           C  
ATOM    509  N   VAL A  63      11.907   1.855   2.051  1.00  3.00           N  
ATOM    510  CA  VAL A  63      10.516   2.292   2.043  1.00  3.06           C  
ATOM    511  C   VAL A  63       9.622   1.050   2.094  1.00  3.39           C  
ATOM    512  O   VAL A  63       9.781   0.110   1.296  1.00  3.18           O  
ATOM    513  CB  VAL A  63      10.186   3.208   0.836  1.00  3.58           C  
ATOM    514  CG1 VAL A  63       8.696   3.539   0.800  1.00  4.07           C  
ATOM    515  CG2 VAL A  63      11.014   4.487   0.914  1.00  4.15           C  
ATOM    516  N   GLY A  64       8.724   1.024   3.071  1.00  3.24           N  
ATOM    517  CA  GLY A  64       7.821  -0.116   3.241  1.00  2.88           C  
ATOM    518  C   GLY A  64       8.268  -1.109   4.301  1.00  3.27           C  
ATOM    519  O   GLY A  64       7.500  -1.994   4.675  1.00  3.55           O  
ATOM    520  N   ARG A  65       9.516  -0.994   4.765  1.00  3.37           N  
ATOM    521  CA  ARG A  65      10.016  -1.868   5.840  1.00  3.66           C  
ATOM    522  C   ARG A  65       9.462  -1.410   7.187  1.00  3.46           C  
ATOM    523  O   ARG A  65       9.441  -0.207   7.471  1.00  4.40           O  
ATOM    524  CB  ARG A  65      11.551  -1.860   5.873  1.00  3.70           C  
ATOM    525  CG  ARG A  65      12.157  -2.495   7.127  1.00  4.63           C  
ATOM    526  CD  ARG A  65      13.615  -2.906   6.893  1.00  4.73           C  
ATOM    527  NE  ARG A  65      13.688  -4.007   5.927  1.00  6.26           N  
ATOM    528  CZ  ARG A  65      13.418  -5.282   6.214  1.00  6.44           C  
ATOM    529  NH1 ARG A  65      13.108  -5.665   7.458  1.00  5.84           N  
ATOM    530  NH2 ARG A  65      13.479  -6.189   5.254  1.00  6.68           N  
ATOM    531  N   GLN A  66       8.994  -2.361   8.000  1.00  3.53           N  
ATOM    532  CA  GLN A  66       8.635  -2.058   9.379  1.00  3.20           C  
ATOM    533  C   GLN A  66       9.863  -2.151  10.270  1.00  3.57           C  
ATOM    534  O   GLN A  66      10.599  -3.146  10.245  1.00  3.34           O  
ATOM    535  CB  GLN A  66       7.523  -2.968   9.894  1.00  3.66           C  
ATOM    536  CG  GLN A  66       6.157  -2.629   9.299  1.00  2.79           C  
ATOM    537  CD  GLN A  66       5.032  -3.340   9.994  1.00  4.49           C  
ATOM    538  OE1 GLN A  66       5.013  -4.571  10.066  1.00  4.01           O  
ATOM    539  NE2 GLN A  66       4.065  -2.570  10.501  1.00  2.00           N  
ATOM    540  N   VAL A  67      10.090  -1.084  11.026  1.00  2.65           N  
ATOM    541  CA  VAL A  67      11.194  -1.019  11.969  1.00  2.21           C  
ATOM    542  C   VAL A  67      10.638  -0.842  13.370  1.00  2.22           C  
ATOM    543  O   VAL A  67       9.462  -0.486  13.547  1.00  2.00           O  
ATOM    544  CB  VAL A  67      12.184   0.140  11.631  1.00  2.23           C  
ATOM    545  CG1 VAL A  67      12.852  -0.136  10.289  1.00  2.56           C  
ATOM    546  CG2 VAL A  67      11.471   1.493  11.663  1.00  2.36           C  
ATOM    547  N   LEU A  68      11.484  -1.110  14.358  1.00  2.19           N  
ATOM    548  CA  LEU A  68      11.111  -0.912  15.749  1.00  2.32           C  
ATOM    549  C   LEU A  68      11.838   0.316  16.255  1.00  2.77           C  
ATOM    550  O   LEU A  68      13.033   0.464  16.010  1.00  3.06           O  
ATOM    551  CB  LEU A  68      11.514  -2.120  16.594  1.00  2.66           C  
ATOM    552  CG  LEU A  68      11.091  -3.522  16.131  1.00  3.58           C  
ATOM    553  CD1 LEU A  68      11.229  -4.495  17.286  1.00  2.77           C  
ATOM    554  CD2 LEU A  68       9.688  -3.561  15.566  1.00  4.69           C  
ATOM    555  N   GLY A  69      11.131   1.174  16.980  1.00  2.61           N  
ATOM    556  CA  GLY A  69      11.752   2.396  17.500  1.00  3.09           C  
ATOM    557  C   GLY A  69      11.282   2.764  18.889  1.00  3.47           C  
ATOM    558  O   GLY A  69      10.136   2.490  19.246  1.00  3.54           O  
ATOM    559  N   VAL A  70      12.176   3.370  19.675  1.00  3.31           N  
ATOM    560  CA  VAL A  70      11.801   3.974  20.950  1.00  3.37           C  
ATOM    561  C   VAL A  70      11.204   5.340  20.643  1.00  3.92           C  
ATOM    562  O   VAL A  70      11.870   6.198  20.036  1.00  3.98           O  
ATOM    563  CB  VAL A  70      13.003   4.165  21.908  1.00  3.48           C  
ATOM    564  CG1 VAL A  70      12.506   4.698  23.252  1.00  2.86           C  
ATOM    565  CG2 VAL A  70      13.760   2.862  22.102  1.00  4.19           C  
ATOM    566  N   VAL A  71       9.946   5.522  21.050  1.00  3.85           N  
ATOM    567  CA  VAL A  71       9.173   6.707  20.659  1.00  4.18           C  
ATOM    568  C   VAL A  71       9.023   7.741  21.764  1.00  3.92           C  
ATOM    569  O   VAL A  71       8.512   8.831  21.506  1.00  4.11           O  
ATOM    570  CB  VAL A  71       7.764   6.346  20.062  1.00  4.26           C  
ATOM    571  CG1 VAL A  71       7.905   5.459  18.830  1.00  3.67           C  
ATOM    572  CG2 VAL A  71       6.847   5.693  21.110  1.00  4.63           C  
ATOM    573  N   ASN A  72       9.480   7.409  22.976  1.00  4.19           N  
ATOM    574  CA  ASN A  72       9.346   8.330  24.111  1.00  4.06           C  
ATOM    575  C   ASN A  72      10.653   8.886  24.693  1.00  4.29           C  
ATOM    576  O   ASN A  72      10.722   9.200  25.889  1.00  4.71           O  
ATOM    577  CB  ASN A  72       8.418   7.763  25.203  1.00  4.11           C  
ATOM    578  CG  ASN A  72       8.966   6.509  25.871  1.00  3.46           C  
ATOM    579  OD1 ASN A  72       9.694   5.718  25.264  1.00  4.07           O  
ATOM    580  ND2 ASN A  72       8.578   6.310  27.127  1.00  2.73           N  
ATOM    581  N   PHE A  73      11.679   9.014  23.853  1.00  4.39           N  
ATOM    582  CA  PHE A  73      12.837   9.830  24.218  1.00  4.29           C  
ATOM    583  C   PHE A  73      12.517  11.291  23.908  1.00  4.40           C  
ATOM    584  O   PHE A  73      11.693  11.586  23.029  1.00  4.61           O  
ATOM    585  CB  PHE A  73      14.088   9.448  23.412  1.00  4.20           C  
ATOM    586  CG  PHE A  73      14.710   8.125  23.794  1.00  4.52           C  
ATOM    587  CD1 PHE A  73      15.146   7.250  22.806  1.00  4.58           C  
ATOM    588  CD2 PHE A  73      14.904   7.779  25.128  1.00  4.99           C  
ATOM    589  CE1 PHE A  73      15.741   6.042  23.133  1.00  4.96           C  
ATOM    590  CE2 PHE A  73      15.493   6.568  25.467  1.00  5.83           C  
ATOM    591  CZ  PHE A  73      15.916   5.696  24.469  1.00  4.38           C  
ATOM    592  N   PRO A  74      13.181  12.223  24.609  1.00  3.88           N  
ATOM    593  CA  PRO A  74      13.106  13.598  24.122  1.00  3.80           C  
ATOM    594  C   PRO A  74      13.807  13.696  22.756  1.00  3.41           C  
ATOM    595  O   PRO A  74      14.677  12.860  22.459  1.00  3.14           O  
ATOM    596  CB  PRO A  74      13.861  14.406  25.183  1.00  4.22           C  
ATOM    597  CG  PRO A  74      14.650  13.415  25.961  1.00  4.92           C  
ATOM    598  CD  PRO A  74      13.976  12.084  25.842  1.00  4.61           C  
ATOM    599  N   PRO A  75      13.433  14.687  21.922  1.00  3.33           N  
ATOM    600  CA  PRO A  75      14.125  14.850  20.639  1.00  3.05           C  
ATOM    601  C   PRO A  75      15.638  14.974  20.801  1.00  2.90           C  
ATOM    602  O   PRO A  75      16.121  15.563  21.788  1.00  2.90           O  
ATOM    603  CB  PRO A  75      13.531  16.148  20.074  1.00  3.25           C  
ATOM    604  CG  PRO A  75      12.187  16.226  20.686  1.00  4.01           C  
ATOM    605  CD  PRO A  75      12.369  15.695  22.091  1.00  3.48           C  
ATOM    606  N   ARG A  76      16.373  14.407  19.846  1.00  2.90           N  
ATOM    607  CA  ARG A  76      17.835  14.457  19.869  1.00  3.49           C  
ATOM    608  C   ARG A  76      18.378  15.212  18.663  1.00  3.21           C  
ATOM    609  O   ARG A  76      18.113  14.846  17.518  1.00  3.21           O  
ATOM    610  CB  ARG A  76      18.455  13.051  19.930  1.00  3.41           C  
ATOM    611  CG  ARG A  76      19.992  13.082  19.960  1.00  4.46           C  
ATOM    612  CD  ARG A  76      20.610  11.773  20.412  1.00  6.49           C  
ATOM    613  NE  ARG A  76      20.653  10.737  19.381  1.00  6.96           N  
ATOM    614  CZ  ARG A  76      21.671  10.535  18.543  1.00  8.33           C  
ATOM    615  NH1 ARG A  76      21.612   9.536  17.670  1.00  6.31           N  
ATOM    616  NH2 ARG A  76      22.744  11.328  18.562  1.00  8.02           N  
ATOM    617  N   GLN A  77      19.151  16.255  18.935  1.00  2.79           N  
ATOM    618  CA  GLN A  77      19.772  17.029  17.875  1.00  2.67           C  
ATOM    619  C   GLN A  77      21.078  16.365  17.423  1.00  2.31           C  
ATOM    620  O   GLN A  77      22.055  16.280  18.182  1.00  2.61           O  
ATOM    621  CB  GLN A  77      19.997  18.477  18.316  1.00  2.35           C  
ATOM    622  CG  GLN A  77      20.383  19.406  17.150  1.00  3.61           C  
ATOM    623  CD  GLN A  77      19.210  19.720  16.228  1.00  2.94           C  
ATOM    624  OE1 GLN A  77      18.062  19.846  16.681  1.00  2.87           O  
ATOM    625  NE2 GLN A  77      19.498  19.869  14.930  1.00  3.12           N  
ATOM    626  N   ILE A  78      21.064  15.899  16.176  1.00  2.05           N  
ATOM    627  CA  ILE A  78      22.166  15.143  15.569  1.00  2.23           C  
ATOM    628  C   ILE A  78      22.702  16.007  14.433  1.00  2.37           C  
ATOM    629  O   ILE A  78      22.185  15.962  13.308  1.00  2.00           O  
ATOM    630  CB  ILE A  78      21.689  13.761  15.006  1.00  2.05           C  
ATOM    631  CG1 ILE A  78      20.852  12.989  16.034  1.00  2.97           C  
ATOM    632  CG2 ILE A  78      22.883  12.904  14.585  1.00  2.00           C  
ATOM    633  CD1 ILE A  78      20.280  11.687  15.490  1.00  2.38           C  
ATOM    634  N   GLY A  79      23.720  16.818  14.720  1.00  2.46           N  
ATOM    635  CA  GLY A  79      24.126  17.849  13.766  1.00  2.67           C  
ATOM    636  C   GLY A  79      22.891  18.699  13.470  1.00  2.84           C  
ATOM    637  O   GLY A  79      22.195  19.105  14.401  1.00  3.16           O  
ATOM    638  N   PRO A  80      22.589  18.941  12.178  1.00  2.92           N  
ATOM    639  CA  PRO A  80      21.458  19.797  11.803  1.00  3.29           C  
ATOM    640  C   PRO A  80      20.106  19.083  11.831  1.00  3.12           C  
ATOM    641  O   PRO A  80      19.075  19.721  11.625  1.00  3.78           O  
ATOM    642  CB  PRO A  80      21.802  20.207  10.366  1.00  2.88           C  
ATOM    643  CG  PRO A  80      22.516  19.008   9.826  1.00  3.27           C  
ATOM    644  CD  PRO A  80      23.301  18.427  10.988  1.00  3.32           C  
ATOM    645  N   PHE A  81      20.115  17.776  12.100  1.00  2.69           N  
ATOM    646  CA  PHE A  81      18.908  16.939  12.064  1.00  2.70           C  
ATOM    647  C   PHE A  81      18.335  16.700  13.459  1.00  3.03           C  
ATOM    648  O   PHE A  81      19.048  16.244  14.352  1.00  3.23           O  
ATOM    649  CB  PHE A  81      19.278  15.600  11.429  1.00  2.58           C  
ATOM    650  CG  PHE A  81      18.166  14.592  11.394  1.00  2.69           C  
ATOM    651  CD1 PHE A  81      17.031  14.819  10.618  1.00  2.80           C  
ATOM    652  CD2 PHE A  81      18.284  13.387  12.098  1.00  2.86           C  
ATOM    653  CE1 PHE A  81      15.999  13.868  10.562  1.00  3.55           C  
ATOM    654  CE2 PHE A  81      17.269  12.424  12.050  1.00  3.93           C  
ATOM    655  CZ  PHE A  81      16.116  12.664  11.273  1.00  3.56           C  
ATOM    656  N   ARG A  82      17.048  16.994  13.641  1.00  3.07           N  
ATOM    657  CA  ARG A  82      16.408  16.763  14.931  1.00  3.29           C  
ATOM    658  C   ARG A  82      15.595  15.469  14.899  1.00  3.67           C  
ATOM    659  O   ARG A  82      14.475  15.423  14.358  1.00  4.33           O  
ATOM    660  CB  ARG A  82      15.550  17.967  15.366  1.00  2.98           C  
ATOM    661  CG  ARG A  82      15.238  17.985  16.867  1.00  3.08           C  
ATOM    662  CD  ARG A  82      14.586  19.290  17.298  1.00  4.75           C  
ATOM    663  NE  ARG A  82      14.397  19.357  18.751  1.00  6.70           N  
ATOM    664  CZ  ARG A  82      15.353  19.662  19.634  1.00  7.32           C  
ATOM    665  NH1 ARG A  82      16.597  19.939  19.227  1.00  7.24           N  
ATOM    666  NH2 ARG A  82      15.065  19.699  20.938  1.00  7.13           N  
ATOM    667  N   SER A  83      16.185  14.426  15.478  1.00  3.14           N  
ATOM    668  CA  SER A  83      15.612  13.081  15.501  1.00  3.49           C  
ATOM    669  C   SER A  83      14.533  12.961  16.575  1.00  3.38           C  
ATOM    670  O   SER A  83      14.686  13.501  17.678  1.00  3.38           O  
ATOM    671  CB  SER A  83      16.723  12.057  15.762  1.00  3.71           C  
ATOM    672  OG  SER A  83      16.225  10.732  15.795  1.00  4.61           O  
ATOM    673  N   GLU A  84      13.454  12.241  16.257  1.00  2.48           N  
ATOM    674  CA  GLU A  84      12.332  12.074  17.196  1.00  2.51           C  
ATOM    675  C   GLU A  84      12.244  10.664  17.788  1.00  2.74           C  
ATOM    676  O   GLU A  84      11.584  10.448  18.824  1.00  3.15           O  
ATOM    677  CB  GLU A  84      11.005  12.407  16.502  1.00  2.21           C  
ATOM    678  CG  GLU A  84      10.898  13.868  16.065  1.00  2.92           C  
ATOM    679  CD  GLU A  84       9.659  14.133  15.215  1.00  4.59           C  
ATOM    680  OE1 GLU A  84       9.525  13.477  14.169  1.00  3.88           O  
ATOM    681  OE2 GLU A  84       8.825  14.998  15.580  1.00  5.06           O  
ATOM    682  N   VAL A  85      12.888   9.706  17.120  1.00  2.31           N  
ATOM    683  CA  VAL A  85      12.780   8.292  17.474  1.00  2.60           C  
ATOM    684  C   VAL A  85      14.141   7.621  17.325  1.00  2.72           C  
ATOM    685  O   VAL A  85      14.913   7.967  16.419  1.00  3.25           O  
ATOM    686  CB  VAL A  85      11.748   7.590  16.532  1.00  2.74           C  
ATOM    687  CG1 VAL A  85      11.880   6.047  16.588  1.00  3.77           C  
ATOM    688  CG2 VAL A  85      10.324   8.058  16.862  1.00  3.09           C  
ATOM    689  N   LEU A  86      14.433   6.668  18.211  1.00  2.12           N  
ATOM    690  CA  LEU A  86      15.645   5.862  18.103  1.00  2.36           C  
ATOM    691  C   LEU A  86      15.259   4.567  17.388  1.00  2.54           C  
ATOM    692  O   LEU A  86      14.420   3.820  17.878  1.00  2.00           O  
ATOM    693  CB  LEU A  86      16.240   5.566  19.494  1.00  2.15           C  
ATOM    694  CG  LEU A  86      17.563   4.783  19.477  1.00  3.73           C  
ATOM    695  CD1 LEU A  86      18.478   5.255  20.595  1.00  7.17           C  
ATOM    696  CD2 LEU A  86      17.334   3.275  19.602  1.00  5.01           C  
ATOM    697  N   THR A  87      15.860   4.319  16.224  1.00  2.58           N  
ATOM    698  CA  THR A  87      15.595   3.116  15.442  1.00  2.80           C  
ATOM    699  C   THR A  87      16.504   1.975  15.899  1.00  2.98           C  
ATOM    700  O   THR A  87      17.723   2.142  15.991  1.00  3.80           O  
ATOM    701  CB  THR A  87      15.746   3.397  13.921  1.00  2.91           C  
ATOM    702  OG1 THR A  87      14.785   4.385  13.525  1.00  2.07           O  
ATOM    703  CG2 THR A  87      15.514   2.125  13.098  1.00  3.17           C  
ATOM    704  N   LEU A  88      15.901   0.820  16.179  1.00  2.75           N  
ATOM    705  CA  LEU A  88      16.590  -0.257  16.899  1.00  2.74           C  
ATOM    706  C   LEU A  88      17.219  -1.304  15.983  1.00  2.63           C  
ATOM    707  O   LEU A  88      16.638  -1.699  14.973  1.00  2.83           O  
ATOM    708  CB  LEU A  88      15.627  -0.918  17.895  1.00  3.05           C  
ATOM    709  CG  LEU A  88      15.167  -0.012  19.047  1.00  3.31           C  
ATOM    710  CD1 LEU A  88      13.861  -0.522  19.640  1.00  3.20           C  
ATOM    711  CD2 LEU A  88      16.239   0.058  20.136  1.00  4.26           C  
ATOM    712  N   GLY A  89      18.408  -1.758  16.356  1.00  2.77           N  
ATOM    713  CA  GLY A  89      19.123  -2.752  15.567  1.00  2.82           C  
ATOM    714  C   GLY A  89      20.166  -3.507  16.363  1.00  3.05           C  
ATOM    715  O   GLY A  89      20.272  -3.365  17.583  1.00  2.38           O  
ATOM    716  N   PHE A  90      20.941  -4.310  15.643  1.00  3.59           N  
ATOM    717  CA  PHE A  90      21.923  -5.223  16.231  1.00  4.17           C  
ATOM    718  C   PHE A  90      23.164  -5.225  15.367  1.00  4.59           C  
ATOM    719  O   PHE A  90      23.068  -5.128  14.148  1.00  4.97           O  
ATOM    720  CB  PHE A  90      21.389  -6.658  16.249  1.00  4.31           C  
ATOM    721  CG  PHE A  90      20.190  -6.857  17.133  1.00  3.76           C  
ATOM    722  CD1 PHE A  90      18.908  -6.539  16.673  1.00  4.27           C  
ATOM    723  CD2 PHE A  90      20.338  -7.384  18.415  1.00  4.72           C  
ATOM    724  CE1 PHE A  90      17.794  -6.723  17.478  1.00  4.96           C  
ATOM    725  CE2 PHE A  90      19.219  -7.587  19.237  1.00  4.66           C  
ATOM    726  CZ  PHE A  90      17.946  -7.247  18.763  1.00  4.11           C  
ATOM    727  N   ALA A  91      24.326  -5.371  15.991  1.00  4.30           N  
ATOM    728  CA  ALA A  91      25.563  -5.526  15.240  1.00  4.10           C  
ATOM    729  C   ALA A  91      25.654  -6.961  14.732  1.00  4.14           C  
ATOM    730  O   ALA A  91      25.457  -7.909  15.498  1.00  4.14           O  
ATOM    731  CB  ALA A  91      26.761  -5.188  16.112  1.00  4.63           C  
ATOM    732  N   ASP A  92      25.927  -7.129  13.441  1.00  4.33           N  
ATOM    733  CA  ASP A  92      26.170  -8.477  12.922  1.00  4.34           C  
ATOM    734  C   ASP A  92      27.601  -8.929  13.218  1.00  4.62           C  
ATOM    735  O   ASP A  92      28.340  -8.235  13.929  1.00  4.35           O  
ATOM    736  CB  ASP A  92      25.782  -8.609  11.437  1.00  4.71           C  
ATOM    737  CG  ASP A  92      26.723  -7.867  10.491  1.00  4.66           C  
ATOM    738  OD1 ASP A  92      27.823  -7.441  10.909  1.00  3.63           O  
ATOM    739  OD2 ASP A  92      26.340  -7.715   9.310  1.00  4.59           O  
ATOM    740  N   ALA A  93      27.988 -10.088  12.682  1.00  4.65           N  
ATOM    741  CA  ALA A  93      29.318 -10.652  12.934  1.00  4.99           C  
ATOM    742  C   ALA A  93      30.456  -9.704  12.552  1.00  5.08           C  
ATOM    743  O   ALA A  93      31.561  -9.808  13.091  1.00  5.81           O  
ATOM    744  CB  ALA A  93      29.471 -12.001  12.226  1.00  4.75           C  
ATOM    745  N   ASN A  94      30.174  -8.778  11.632  1.00  5.43           N  
ATOM    746  CA  ASN A  94      31.164  -7.813  11.139  1.00  6.16           C  
ATOM    747  C   ASN A  94      31.023  -6.412  11.745  1.00  6.04           C  
ATOM    748  O   ASN A  94      31.785  -5.507  11.401  1.00  6.37           O  
ATOM    749  CB  ASN A  94      31.096  -7.712   9.609  1.00  6.57           C  
ATOM    750  CG  ASN A  94      31.331  -9.047   8.921  1.00  7.72           C  
ATOM    751  OD1 ASN A  94      32.275  -9.772   9.240  1.00  9.92           O  
ATOM    752  ND2 ASN A  94      30.465  -9.379   7.973  1.00  9.79           N  
ATOM    753  N   GLY A  95      30.045  -6.230  12.630  1.00  5.52           N  
ATOM    754  CA  GLY A  95      29.807  -4.920  13.234  1.00  5.24           C  
ATOM    755  C   GLY A  95      28.860  -4.028  12.439  1.00  5.49           C  
ATOM    756  O   GLY A  95      28.626  -2.881  12.817  1.00  5.83           O  
ATOM    757  N   ASP A  96      28.341  -4.545  11.328  1.00  4.78           N  
ATOM    758  CA  ASP A  96      27.385  -3.798  10.504  1.00  5.11           C  
ATOM    759  C   ASP A  96      25.982  -3.954  11.064  1.00  5.07           C  
ATOM    760  O   ASP A  96      25.658  -4.978  11.663  1.00  5.71           O  
ATOM    761  CB  ASP A  96      27.462  -4.256   9.044  1.00  5.06           C  
ATOM    762  CG  ASP A  96      28.853  -4.056   8.448  1.00  5.89           C  
ATOM    763  OD1 ASP A  96      29.375  -4.984   7.779  1.00  6.25           O  
ATOM    764  OD2 ASP A  96      29.449  -2.975   8.677  1.00  4.76           O  
ATOM    765  N   ILE A  97      25.155  -2.935  10.872  1.00  4.77           N  
ATOM    766  CA  ILE A  97      23.882  -2.876  11.587  1.00  4.90           C  
ATOM    767  C   ILE A  97      22.771  -3.627  10.850  1.00  5.12           C  
ATOM    768  O   ILE A  97      22.530  -3.412   9.661  1.00  5.03           O  
ATOM    769  CB  ILE A  97      23.451  -1.419  11.921  1.00  4.86           C  
ATOM    770  CG1 ILE A  97      24.550  -0.695  12.708  1.00  5.91           C  
ATOM    771  CG2 ILE A  97      22.133  -1.421  12.704  1.00  5.68           C  
ATOM    772  CD1 ILE A  97      25.148  -1.489  13.875  1.00  7.23           C  
ATOM    773  N   VAL A  98      22.114  -4.512  11.591  1.00  5.29           N  
ATOM    774  CA  VAL A  98      20.963  -5.268  11.121  1.00  5.18           C  
ATOM    775  C   VAL A  98      19.751  -4.746  11.878  1.00  5.27           C  
ATOM    776  O   VAL A  98      19.779  -4.632  13.117  1.00  4.88           O  
ATOM    777  CB  VAL A  98      21.146  -6.771  11.390  1.00  5.53           C  
ATOM    778  CG1 VAL A  98      19.861  -7.553  11.066  1.00  6.10           C  
ATOM    779  CG2 VAL A  98      22.330  -7.296  10.597  1.00  5.74           C  
ATOM    780  N   LEU A  99      18.692  -4.408  11.146  1.00  4.72           N  
ATOM    781  CA  LEU A  99      17.509  -3.839  11.799  1.00  4.60           C  
ATOM    782  C   LEU A  99      16.726  -4.883  12.589  1.00  4.33           C  
ATOM    783  O   LEU A  99      16.551  -6.022  12.142  1.00  4.81           O  
ATOM    784  CB  LEU A  99      16.589  -3.142  10.781  1.00  4.79           C  
ATOM    785  CG  LEU A  99      17.134  -1.823  10.200  1.00  3.98           C  
ATOM    786  CD1 LEU A  99      16.375  -1.409   8.950  1.00  5.47           C  
ATOM    787  CD2 LEU A  99      17.108  -0.695  11.249  1.00  4.31           C  
ATOM    788  N   ALA A 100      16.232  -4.475  13.757  1.00  4.01           N  
ATOM    789  CA  ALA A 100      15.155  -5.215  14.413  1.00  3.86           C  
ATOM    790  C   ALA A 100      13.922  -5.221  13.499  1.00  4.09           C  
ATOM    791  O   ALA A 100      13.704  -4.298  12.695  1.00  4.25           O  
ATOM    792  CB  ALA A 100      14.814  -4.599  15.774  1.00  4.00           C  
ATOM    793  N   ALA A 101      13.136  -6.285  13.599  1.00  3.75           N  
ATOM    794  CA  ALA A 101      12.030  -6.483  12.668  1.00  3.83           C  
ATOM    795  C   ALA A 101      10.863  -7.219  13.314  1.00  4.17           C  
ATOM    796  O   ALA A 101      10.888  -7.530  14.508  1.00  4.34           O  
ATOM    797  CB  ALA A 101      12.518  -7.257  11.434  1.00  3.92           C  
ATOM    798  N   VAL A 102       9.829  -7.464  12.515  1.00  4.30           N  
ATOM    799  CA  VAL A 102       8.745  -8.354  12.918  1.00  4.39           C  
ATOM    800  C   VAL A 102       8.685  -9.520  11.934  1.00  4.52           C  
ATOM    801  O   VAL A 102       8.965  -9.348  10.733  1.00  4.93           O  
ATOM    802  CB  VAL A 102       7.379  -7.614  13.022  1.00  4.91           C  
ATOM    803  CG1 VAL A 102       7.372  -6.702  14.260  1.00  5.15           C  
ATOM    804  CG2 VAL A 102       7.067  -6.820  11.748  1.00  5.10           C  
ATOM    805  N   GLU A 103       8.319 -10.697  12.445  1.00  4.39           N  
ATOM    806  CA  GLU A 103       8.284 -11.931  11.649  1.00  4.58           C  
ATOM    807  C   GLU A 103       7.281 -11.862  10.488  1.00  4.70           C  
ATOM    808  O   GLU A 103       7.486 -12.478   9.437  1.00  4.55           O  
ATOM    809  CB  GLU A 103       8.007 -13.120  12.567  1.00  4.47           C  
ATOM    810  CG  GLU A 103       7.939 -14.474  11.882  1.00  5.52           C  
ATOM    811  CD  GLU A 103       6.554 -14.821  11.362  1.00  7.31           C  
ATOM    812  OE1 GLU A 103       6.462 -15.665  10.442  1.00  7.73           O  
ATOM    813  OE2 GLU A 103       5.557 -14.256  11.863  1.00  8.10           O  
ATOM    814  N   ARG A 104       6.198 -11.112  10.682  1.00  4.67           N  
ATOM    815  CA  ARG A 104       5.282 -10.769   9.589  1.00  4.57           C  
ATOM    816  C   ARG A 104       4.701  -9.401   9.931  1.00  4.84           C  
ATOM    817  O   ARG A 104       4.761  -8.989  11.091  1.00  5.41           O  
ATOM    818  CB  ARG A 104       4.179 -11.827   9.433  1.00  4.38           C  
ATOM    819  CG  ARG A 104       3.174 -11.839  10.588  1.00  4.16           C  
ATOM    820  CD  ARG A 104       2.281 -13.070  10.543  1.00  4.15           C  
ATOM    821  NE  ARG A 104       3.075 -14.289  10.699  1.00  4.75           N  
ATOM    822  CZ  ARG A 104       2.637 -15.514  10.423  1.00  6.30           C  
ATOM    823  NH1 ARG A 104       1.401 -15.694   9.980  1.00  6.94           N  
ATOM    824  NH2 ARG A 104       3.432 -16.564  10.594  1.00  6.56           N  
ATOM    825  N   PRO A 105       4.169  -8.673   8.932  1.00  5.46           N  
ATOM    826  CA  PRO A 105       3.654  -7.327   9.232  1.00  5.45           C  
ATOM    827  C   PRO A 105       2.522  -7.301  10.251  1.00  5.53           C  
ATOM    828  O   PRO A 105       1.670  -8.216  10.300  1.00  5.60           O  
ATOM    829  CB  PRO A 105       3.166  -6.810   7.873  1.00  5.87           C  
ATOM    830  CG  PRO A 105       3.903  -7.632   6.874  1.00  5.43           C  
ATOM    831  CD  PRO A 105       4.061  -8.989   7.496  1.00  5.61           C  
ATOM    832  N   VAL A 106       2.544  -6.252  11.065  1.00  5.27           N  
ATOM    833  CA  VAL A 106       1.525  -6.005  12.085  1.00  4.93           C  
ATOM    834  C   VAL A 106       1.053  -4.548  11.957  1.00  4.75           C  
ATOM    835  O   VAL A 106       1.667  -3.759  11.219  1.00  4.27           O  
ATOM    836  CB  VAL A 106       2.081  -6.278  13.503  1.00  5.38           C  
ATOM    837  CG1 VAL A 106       2.471  -7.751  13.646  1.00  6.11           C  
ATOM    838  CG2 VAL A 106       3.277  -5.382  13.789  1.00  5.78           C  
ATOM    839  N   PRO A 107      -0.051  -4.189  12.638  1.00  4.36           N  
ATOM    840  CA  PRO A 107      -0.514  -2.798  12.555  1.00  4.48           C  
ATOM    841  C   PRO A 107       0.551  -1.793  13.000  1.00  4.68           C  
ATOM    842  O   PRO A 107       1.252  -2.016  13.999  1.00  4.60           O  
ATOM    843  CB  PRO A 107      -1.708  -2.770  13.518  1.00  4.48           C  
ATOM    844  CG  PRO A 107      -2.198  -4.178  13.537  1.00  4.75           C  
ATOM    845  CD  PRO A 107      -0.951  -5.013  13.468  1.00  4.99           C  
ATOM    846  N   ASN A 108       0.696  -0.707  12.245  1.00  4.63           N  
ATOM    847  CA  ASN A 108       1.592   0.355  12.656  1.00  4.63           C  
ATOM    848  C   ASN A 108       1.137   0.935  13.988  1.00  4.58           C  
ATOM    849  O   ASN A 108      -0.061   1.168  14.196  1.00  4.82           O  
ATOM    850  CB  ASN A 108       1.674   1.436  11.582  1.00  4.85           C  
ATOM    851  CG  ASN A 108       2.304   0.923  10.309  1.00  5.10           C  
ATOM    852  OD1 ASN A 108       3.386   0.341  10.341  1.00  4.81           O  
ATOM    853  ND2 ASN A 108       1.617   1.113   9.180  1.00  5.69           N  
ATOM    854  N   GLY A 109       2.093   1.130  14.893  1.00  4.35           N  
ATOM    855  CA  GLY A 109       1.811   1.709  16.199  1.00  4.10           C  
ATOM    856  C   GLY A 109       1.650   0.709  17.324  1.00  4.40           C  
ATOM    857  O   GLY A 109       1.423   1.101  18.472  1.00  4.75           O  
ATOM    858  N   GLU A 110       1.758  -0.577  17.012  1.00  4.82           N  
ATOM    859  CA  GLU A 110       1.671  -1.589  18.065  1.00  4.89           C  
ATOM    860  C   GLU A 110       2.891  -1.507  18.977  1.00  5.29           C  
ATOM    861  O   GLU A 110       4.005  -1.234  18.514  1.00  4.53           O  
ATOM    862  CB  GLU A 110       1.528  -3.001  17.490  1.00  4.91           C  
ATOM    863  CG  GLU A 110       0.114  -3.328  16.980  1.00  5.73           C  
ATOM    864  CD  GLU A 110      -0.953  -3.374  18.078  1.00  7.05           C  
ATOM    865  OE1 GLU A 110      -0.624  -3.654  19.252  1.00  7.42           O  
ATOM    866  OE2 GLU A 110      -2.142  -3.135  17.759  1.00  9.56           O  
ATOM    867  N   LYS A 111       2.661  -1.719  20.271  1.00  5.48           N  
ATOM    868  CA  LYS A 111       3.718  -1.667  21.281  1.00  5.89           C  
ATOM    869  C   LYS A 111       4.349  -3.052  21.445  1.00  5.71           C  
ATOM    870  O   LYS A 111       3.652  -4.078  21.403  1.00  6.61           O  
ATOM    871  CB  LYS A 111       3.155  -1.196  22.627  1.00  5.95           C  
ATOM    872  CG  LYS A 111       4.228  -0.823  23.667  1.00  6.76           C  
ATOM    873  CD  LYS A 111       3.612  -0.237  24.935  1.00  7.25           C  
ATOM    874  CE  LYS A 111       4.668   0.461  25.798  1.00  8.64           C  
ATOM    875  NZ  LYS A 111       5.627  -0.492  26.418  1.00  8.87           N  
ATOM    876  N   MET A 112       5.666  -3.072  21.626  1.00  5.47           N  
ATOM    877  CA  MET A 112       6.384  -4.314  21.852  1.00  5.21           C  
ATOM    878  C   MET A 112       6.107  -4.773  23.277  1.00  5.50           C  
ATOM    879  O   MET A 112       6.197  -3.979  24.219  1.00  5.43           O  
ATOM    880  CB  MET A 112       7.886  -4.106  21.641  1.00  5.16           C  
ATOM    881  CG  MET A 112       8.688  -5.404  21.598  1.00  5.19           C  
ATOM    882  SD  MET A 112      10.450  -5.124  21.358  1.00  6.66           S  
ATOM    883  CE  MET A 112      10.881  -4.483  22.964  1.00  8.33           C  
ATOM    884  N   CYS A 113       5.789  -6.058  23.441  1.00  5.07           N  
ATOM    885  CA  CYS A 113       5.437  -6.591  24.761  1.00  5.94           C  
ATOM    886  C   CYS A 113       5.754  -8.074  24.870  1.00  5.39           C  
ATOM    887  O   CYS A 113       6.274  -8.671  23.929  1.00  5.29           O  
ATOM    888  CB  CYS A 113       3.955  -6.349  25.057  1.00  6.42           C  
ATOM    889  SG  CYS A 113       2.863  -7.097  23.835  1.00 10.34           S  
ATOM    890  OXT CYS A 113       5.484  -8.707  25.898  1.00  5.38           O  
TER     891      CYS A 113                                                      
END
MOLECULE T0409.pdb
ATOM     14  N   TYR     1     -12.138  -6.437  34.342  1.00 26.71           N  
ATOM     15  CA  TYR     1     -10.769  -6.327  34.864  1.00 25.90           C  
ATOM     16  C   TYR     1     -10.498  -7.542  35.724  1.00 24.98           C  
ATOM     17  O   TYR     1     -11.355  -7.916  36.501  1.00 26.34           O  
ATOM     18  CB  TYR     1     -10.618  -5.047  35.686  1.00 24.63           C  
ATOM     19  CG  TYR     1      -9.168  -4.728  36.029  1.00 22.28           C  
ATOM     20  CD1 TYR     1      -8.285  -4.357  35.005  1.00 22.31           C  
ATOM     21  CD2 TYR     1      -8.664  -4.878  37.313  1.00 23.91           C  
ATOM     22  CE1 TYR     1      -6.951  -4.068  35.280  1.00 18.52           C  
ATOM     23  CE2 TYR     1      -7.324  -4.598  37.613  1.00 21.53           C  
ATOM     24  CZ  TYR     1      -6.480  -4.192  36.581  1.00 19.19           C  
ATOM     25  OH  TYR     1      -5.185  -3.925  36.888  1.00 18.14           O  
ATOM     26  N   ARG     2      -9.329  -8.164  35.541  1.00 24.27           N  
ATOM     27  CA  ARG     2      -8.922  -9.381  36.228  1.00 24.78           C  
ATOM     28  C   ARG     2      -7.920  -9.194  37.353  1.00 24.52           C  
ATOM     29  O   ARG     2      -7.621 -10.122  38.085  1.00 27.44           O  
ATOM     30  CB  ARG     2      -8.346 -10.374  35.215  1.00 23.92           C  
ATOM     31  CG  ARG     2      -9.347 -10.845  34.134  1.00 25.70           C  
ATOM     32  CD  ARG     2      -8.657 -11.765  33.135  1.00 25.52           C  
ATOM     33  NE  ARG     2      -7.696 -11.068  32.290  1.00 27.24           N  
ATOM     34  CZ  ARG     2      -8.028 -10.316  31.245  1.00 25.99           C  
ATOM     35  NH1 ARG     2      -7.092  -9.705  30.558  1.00 26.10           N  
ATOM     36  NH2 ARG     2      -9.305 -10.178  30.888  1.00 30.15           N  
ATOM     37  N   GLY     3      -7.404  -7.992  37.483  1.00 23.54           N  
ATOM     38  CA  GLY     3      -6.475  -7.700  38.540  1.00 21.96           C  
ATOM     39  C   GLY     3      -5.048  -7.714  38.006  1.00 20.01           C  
ATOM     40  O   GLY     3      -4.763  -8.208  36.927  1.00 19.98           O  
ATOM     41  N   PRO     4      -4.121  -7.183  38.794  1.00 18.75           N  
ATOM     42  CA  PRO     4      -2.718  -7.124  38.362  1.00 17.90           C  
ATOM     43  C   PRO     4      -2.069  -8.474  38.133  1.00 17.43           C  
ATOM     44  O   PRO     4      -2.332  -9.438  38.886  1.00 17.86           O  
ATOM     45  CB  PRO     4      -1.998  -6.462  39.555  1.00 17.83           C  
ATOM     46  CG  PRO     4      -3.078  -5.804  40.295  1.00 17.56           C  
ATOM     47  CD  PRO     4      -4.293  -6.604  40.137  1.00 20.04           C  
ATOM     48  N   GLU     5      -1.198  -8.523  37.136  1.00 16.41           N  
ATOM     49  CA  GLU     5      -0.494  -9.734  36.776  1.00 16.74           C  
ATOM     50  C   GLU     5       0.555 -10.210  37.794  1.00 15.28           C  
ATOM     51  O   GLU     5       0.894 -11.399  37.821  1.00 14.56           O  
ATOM     52  CB  GLU     5       0.179  -9.574  35.415  1.00 18.28           C  
ATOM     53  CG  GLU     5       1.357  -8.668  35.384  1.00 18.86           C  
ATOM     54  CD  GLU     5       1.641  -8.109  33.976  1.00 21.65           C  
ATOM     55  OE1 GLU     5       0.838  -7.287  33.462  1.00 19.17           O  
ATOM     56  OE2 GLU     5       2.690  -8.452  33.404  1.00 20.12           O  
ATOM     57  N   ALA     6       1.090  -9.262  38.551  1.00 14.75           N  
ATOM     58  CA  ALA     6       2.230  -9.503  39.408  1.00 12.91           C  
ATOM     59  C   ALA     6       2.286  -8.383  40.423  1.00 13.86           C  
ATOM     60  O   ALA     6       1.662  -7.340  40.252  1.00 14.07           O  
ATOM     61  CB  ALA     6       3.557  -9.555  38.607  1.00 14.41           C  
ATOM     62  N   PHE     7       3.056  -8.616  41.463  1.00 12.90           N  
ATOM     63  CA  PHE     7       3.312  -7.619  42.514  1.00 12.74           C  
ATOM     64  C   PHE     7       4.803  -7.561  42.789  1.00 14.31           C  
ATOM     65  O   PHE     7       5.426  -8.577  43.064  1.00 16.10           O  
ATOM     66  CB  PHE     7       2.558  -7.975  43.774  1.00 12.84           C  
ATOM     67  CG  PHE     7       1.061  -7.980  43.588  1.00 13.25           C  
ATOM     68  CD1 PHE     7       0.432  -9.083  43.089  1.00 12.42           C  
ATOM     69  CD2 PHE     7       0.284  -6.851  43.907  1.00 13.57           C  
ATOM     70  CE1 PHE     7      -0.949  -9.101  42.892  1.00 15.56           C  
ATOM     71  CE2 PHE     7      -1.084  -6.875  43.732  1.00 14.79           C  
ATOM     72  CZ  PHE     7      -1.682  -7.984  43.198  1.00 14.93           C  
ATOM     73  N   LEU     8       5.379  -6.378  42.730  1.00 13.78           N  
ATOM     74  CA  LEU     8       6.799  -6.166  43.031  1.00 14.87           C  
ATOM     75  C   LEU     8       6.959  -5.587  44.431  1.00 17.18           C  
ATOM     76  O   LEU     8       6.012  -5.033  45.021  1.00 18.46           O  
ATOM     77  CB  LEU     8       7.409  -5.253  41.997  1.00 14.89           C  
ATOM     78  CG  LEU     8       7.096  -5.514  40.532  1.00 15.32           C  
ATOM     79  CD1 LEU     8       7.647  -4.518  39.513  1.00 16.20           C  
ATOM     80  CD2 LEU     8       7.592  -6.945  40.214  1.00 16.59           C  
ATOM     81  N   LYS     9       8.127  -5.818  45.005  1.00 17.65           N  
ATOM     82  CA  LYS     9       8.421  -5.348  46.361  1.00 19.07           C  
ATOM     83  C   LYS     9       9.052  -3.955  46.263  1.00 17.92           C  
ATOM     84  O   LYS     9      10.150  -3.798  45.727  1.00 18.25           O  
ATOM     85  CB  LYS     9       9.373  -6.314  47.042  1.00 19.67           C  
ATOM     86  CG  LYS     9       9.591  -5.980  48.493  1.00 23.14           C  
ATOM     87  CD  LYS     9      10.639  -6.886  49.072  1.00 24.83           C  
ATOM     88  CE  LYS     9      10.121  -8.265  49.428  1.00 32.25           C  
ATOM     89  NZ  LYS     9      10.917  -8.817  50.575  1.00 34.79           N  
ATOM     90  N   LEU    10       8.369  -2.926  46.749  1.00 18.72           N  
ATOM     91  CA  LEU    10       8.826  -1.580  46.551  1.00 18.81           C  
ATOM     92  C   LEU    10       9.942  -1.228  47.554  1.00 19.68           C  
ATOM     93  O   LEU    10      10.009  -1.815  48.647  1.00 20.89           O  
ATOM     94  CB  LEU    10       7.717  -0.560  46.770  1.00 20.05           C  
ATOM     95  CG  LEU    10       6.533  -0.547  45.822  1.00 19.19           C  
ATOM     96  CD1 LEU    10       5.473   0.394  46.436  1.00 24.82           C  
ATOM     97  CD2 LEU    10       6.945  -0.115  44.440  1.00 21.53           C  
ATOM     98  N   PRO    11      10.774  -0.268  47.163  1.00 20.13           N  
ATOM     99  CA  PRO    11      11.661   0.375  48.167  1.00 21.78           C  
ATOM    100  C   PRO    11      10.838   1.323  49.071  1.00 22.52           C  
ATOM    101  O   PRO    11       9.740   1.732  48.679  1.00 23.44           O  
ATOM    102  CB  PRO    11      12.607   1.193  47.285  1.00 20.85           C  
ATOM    103  CG  PRO    11      11.779   1.545  46.072  1.00 22.93           C  
ATOM    104  CD  PRO    11      10.970   0.307  45.828  1.00 19.70           C  
ATOM    105  N   LYS    12      11.406   1.739  50.229  1.00 25.61           N  
ATOM    106  CA  LYS    12      10.808   2.820  51.069  1.00 26.86           C  
ATOM    107  C   LYS    12      10.655   4.134  50.323  1.00 28.24           C  
ATOM    108  O   LYS    12       9.621   4.815  50.414  1.00 30.07           O  
ATOM    109  CB  LYS    12      11.725   3.141  52.244  1.00 27.78           C  
ATOM    110  CG  LYS    12      11.297   2.660  53.597  1.00 29.19           C  
ATOM    111  CD  LYS    12      12.113   3.300  54.688  1.00 28.24           C  
ATOM    112  CE  LYS    12      11.543   4.613  55.215  1.00 28.46           C  
ATOM    113  NZ  LYS    12      12.177   4.939  56.553  1.00 29.49           N  
ATOM    114  N   ASP    13      11.716   4.525  49.615  1.00 29.01           N  
ATOM    115  CA  ASP    13      11.746   5.788  48.876  1.00 29.32           C  
ATOM    116  C   ASP    13      11.132   5.663  47.484  1.00 30.39           C  
ATOM    117  O   ASP    13      11.712   5.127  46.535  1.00 29.19           O  
ATOM    118  CB  ASP    13      13.189   6.371  48.893  1.00 29.16           C  
ATOM    119  CG  ASP    13      13.347   7.664  48.082  1.00 30.92           C  
ATOM    120  OD1 ASP    13      12.344   8.274  47.628  1.00 34.61           O  
ATOM    121  OD2 ASP    13      14.529   8.080  47.888  1.00 32.69           O  
ATOM    122  N   LEU    14       9.920   6.195  47.363  1.00 30.90           N  
ATOM    123  CA  LEU    14       9.172   6.157  46.124  1.00 30.71           C  
ATOM    124  C   LEU    14       9.608   7.149  45.049  1.00 30.84           C  
ATOM    125  O   LEU    14       9.020   7.178  43.964  1.00 31.55           O  
ATOM    126  CB  LEU    14       7.678   6.329  46.424  1.00 30.89           C  
ATOM    127  CG  LEU    14       7.124   5.332  47.440  1.00 30.54           C  
ATOM    128  CD1 LEU    14       5.711   5.725  47.765  1.00 33.63           C  
ATOM    129  CD2 LEU    14       7.169   3.889  46.924  1.00 35.44           C  
ATOM    130  N   LYS    15      10.614   7.983  45.348  1.00 30.72           N  
ATOM    131  CA  LYS    15      11.255   8.810  44.324  1.00 30.73           C  
ATOM    132  C   LYS    15      12.623   8.265  43.901  1.00 29.76           C  
ATOM    133  O   LYS    15      13.272   8.865  43.053  1.00 30.87           O  
ATOM    134  CB  LYS    15      11.408  10.266  44.806  1.00 32.76           C  
ATOM    135  CG  LYS    15      10.232  11.196  44.418  1.00 35.47           C  
ATOM    136  CD  LYS    15       9.079  11.039  45.367  1.00 37.91           C  
ATOM    137  CE  LYS    15       9.288  11.906  46.603  1.00 39.30           C  
ATOM    138  NZ  LYS    15       8.302  11.581  47.681  1.00 39.71           N  
ATOM    139  N   ASP    16      13.046   7.133  44.481  1.00 27.99           N  
ATOM    140  CA  ASP    16      14.328   6.493  44.094  1.00 26.78           C  
ATOM    141  C   ASP    16      14.118   5.763  42.782  1.00 25.11           C  
ATOM    142  O   ASP    16      13.741   4.600  42.764  1.00 24.88           O  
ATOM    143  CB  ASP    16      14.802   5.533  45.171  1.00 25.55           C  
ATOM    144  CG  ASP    16      16.217   4.970  44.893  1.00 26.06           C  
ATOM    145  OD1 ASP    16      16.650   5.014  43.729  1.00 25.61           O  
ATOM    146  OD2 ASP    16      16.861   4.472  45.830  1.00 25.02           O  
ATOM    147  N   ARG    17      14.360   6.449  41.680  1.00 25.11           N  
ATOM    148  CA  ARG    17      14.118   5.904  40.359  1.00 24.25           C  
ATOM    149  C   ARG    17      14.973   4.689  40.041  1.00 23.79           C  
ATOM    150  O   ARG    17      14.497   3.729  39.431  1.00 22.80           O  
ATOM    151  CB  ARG    17      14.276   6.978  39.293  1.00 26.64           C  
ATOM    152  CG  ARG    17      13.323   8.136  39.528  1.00 30.06           C  
ATOM    153  CD  ARG    17      12.985   8.820  38.245  1.00 37.41           C  
ATOM    154  NE  ARG    17      14.129   9.542  37.706  1.00 40.97           N  
ATOM    155  CZ  ARG    17      14.150  10.097  36.499  1.00 43.91           C  
ATOM    156  NH1 ARG    17      13.094   9.997  35.685  1.00 45.45           N  
ATOM    157  NH2 ARG    17      15.241  10.749  36.096  1.00 45.78           N  
ATOM    158  N   GLU    18      16.227   4.705  40.494  1.00 22.85           N  
ATOM    159  CA  GLU    18      17.123   3.549  40.277  1.00 22.70           C  
ATOM    160  C   GLU    18      16.572   2.269  40.913  1.00 20.63           C  
ATOM    161  O   GLU    18      16.555   1.211  40.278  1.00 19.78           O  
ATOM    162  CB  GLU    18      18.500   3.848  40.866  1.00 23.30           C  
ATOM    163  CG  GLU    18      19.549   2.754  40.681  1.00 24.01           C  
ATOM    164  CD  GLU    18      20.941   3.182  41.148  1.00 26.13           C  
ATOM    165  OE1 GLU    18      21.200   3.135  42.381  1.00 31.97           O  
ATOM    166  OE2 GLU    18      21.761   3.558  40.278  1.00 30.80           O  
ATOM    167  N   ALA    19      16.146   2.364  42.159  1.00 18.69           N  
ATOM    168  CA  ALA    19      15.569   1.237  42.865  1.00 18.72           C  
ATOM    169  C   ALA    19      14.286   0.741  42.184  1.00 18.42           C  
ATOM    170  O   ALA    19      14.079  -0.477  42.073  1.00 18.40           O  
ATOM    171  CB  ALA    19      15.248   1.627  44.285  1.00 19.53           C  
ATOM    172  N   LEU    20      13.438   1.683  41.764  1.00 18.86           N  
ATOM    173  CA  LEU    20      12.198   1.346  41.088  1.00 18.10           C  
ATOM    174  C   LEU    20      12.479   0.694  39.747  1.00 18.59           C  
ATOM    175  O   LEU    20      11.826  -0.289  39.383  1.00 18.02           O  
ATOM    176  CB  LEU    20      11.269   2.570  40.902  1.00 19.62           C  
ATOM    177  CG  LEU    20      10.779   3.123  42.243  1.00 19.47           C  
ATOM    178  CD1 LEU    20      10.171   4.490  42.063  1.00 25.48           C  
ATOM    179  CD2 LEU    20       9.776   2.141  42.919  1.00 20.59           C  
ATOM    180  N   GLN    21      13.439   1.212  38.971  1.00 17.08           N  
ATOM    181  CA  GLN    21      13.818   0.563  37.701  0.60 17.52           C  
ATOM    183  C   GLN    21      14.339  -0.838  37.961  1.00 17.89           C  
ATOM    184  O   GLN    21      14.076  -1.788  37.220  1.00 17.69           O  
ATOM    185  CB  GLN    21      14.943   1.338  36.986  0.60 18.21           C  
ATOM    187  CG  GLN    21      14.503   2.626  36.329  0.60 18.89           C  
ATOM    189  CD  GLN    21      13.515   2.472  35.158  0.60 20.48           C  
ATOM    191  OE1 GLN    21      13.254   1.364  34.619  0.60 23.97           O  
ATOM    193  NE2 GLN    21      12.980   3.610  34.738  0.60 22.78           N  
ATOM    195  N   ASP    22      15.104  -0.995  39.034  1.00 16.55           N  
ATOM    196  CA  ASP    22      15.680  -2.315  39.349  1.00 17.02           C  
ATOM    197  C   ASP    22      14.611  -3.356  39.634  1.00 16.63           C  
ATOM    198  O   ASP    22      14.714  -4.505  39.156  1.00 16.75           O  
ATOM    199  CB  ASP    22      16.632  -2.228  40.544  1.00 17.24           C  
ATOM    200  CG  ASP    22      18.015  -1.694  40.162  1.00 19.16           C  
ATOM    201  OD1 ASP    22      18.327  -1.439  38.960  1.00 22.10           O  
ATOM    202  OD2 ASP    22      18.789  -1.547  41.118  1.00 23.09           O  
ATOM    203  N   ILE    23      13.551  -2.982  40.363  1.00 15.22           N  
ATOM    204  CA  ILE    23      12.501  -4.017  40.667  1.00 15.44           C  
ATOM    205  C   ILE    23      11.696  -4.359  39.393  1.00 15.80           C  
ATOM    206  O   ILE    23      11.130  -5.448  39.328  1.00 16.91           O  
ATOM    207  CB  ILE    23      11.538  -3.666  41.812  1.00 14.93           C  
ATOM    208  CG1 ILE    23      10.715  -2.400  41.496  1.00 16.08           C  
ATOM    209  CG2 ILE    23      12.349  -3.420  43.109  1.00 16.92           C  
ATOM    210  CD1 ILE    23       9.662  -2.083  42.539  1.00 18.45           C  
ATOM    211  N   MET    24      11.693  -3.454  38.407  1.00 16.35           N  
ATOM    212  CA  MET    24      11.001  -3.635  37.136  1.00 16.51           C  
ATOM    213  C   MET    24      11.870  -4.256  36.047  1.00 16.28           C  
ATOM    214  O   MET    24      11.426  -4.374  34.907  1.00 16.01           O  
ATOM    215  CB  MET    24      10.471  -2.276  36.650  1.00 16.46           C  
ATOM    216  CG  MET    24       9.476  -1.622  37.540  1.00 17.64           C  
ATOM    217  SD  MET    24       8.685  -0.053  36.632  0.80 26.05          SE  
ATOM    218  CE  MET    24       7.421  -0.860  35.445  1.00 24.41           C  
ATOM    219  N   GLN    25      13.092  -4.631  36.388  1.00 16.67           N  
ATOM    220  CA  GLN    25      14.070  -4.998  35.365  1.00 17.43           C  
ATOM    221  C   GLN    25      13.592  -6.036  34.353  1.00 16.67           C  
ATOM    222  O   GLN    25      14.004  -5.969  33.198  1.00 17.33           O  
ATOM    223  CB  GLN    25      15.374  -5.433  36.005  1.00 18.09           C  
ATOM    224  CG  GLN    25      15.329  -6.698  36.777  1.00 20.57           C  
ATOM    225  CD  GLN    25      16.656  -7.030  37.461  1.00 24.40           C  
ATOM    226  OE1 GLN    25      17.683  -6.382  37.193  1.00 30.15           O  
ATOM    227  NE2 GLN    25      16.631  -8.020  38.370  1.00 29.33           N  
ATOM    228  N   ASP    26      12.790  -7.013  34.797  1.00 15.34           N  
ATOM    229  CA  ASP    26      12.390  -8.124  33.918  1.00 15.72           C  
ATOM    230  C   ASP    26      11.142  -7.834  33.073  1.00 16.03           C  
ATOM    231  O   ASP    26      10.876  -8.602  32.131  1.00 16.34           O  
ATOM    232  CB  ASP    26      12.120  -9.391  34.723  1.00 15.05           C  
ATOM    233  CG  ASP    26      13.409 -10.027  35.326  1.00 18.38           C  
ATOM    234  OD1 ASP    26      14.527  -9.715  34.833  1.00 21.09           O  
ATOM    235  OD2 ASP    26      13.261 -10.859  36.262  1.00 21.86           O  
ATOM    236  N   ILE    27      10.434  -6.762  33.392  1.00 16.05           N  
ATOM    237  CA  ILE    27       9.093  -6.467  32.882  0.60 17.18           C  
ATOM    239  C   ILE    27       9.116  -5.228  31.989  1.00 17.24           C  
ATOM    240  O   ILE    27       9.908  -4.318  32.214  1.00 16.86           O  
ATOM    241  CB  ILE    27       8.122  -6.210  34.080  0.60 17.87           C  
ATOM    243  CG1 ILE    27       8.158  -7.384  35.052  0.60 18.38           C  
ATOM    245  CG2 ILE    27       6.684  -5.914  33.601  0.60 18.73           C  
ATOM    247  CD1 ILE    27       7.986  -8.690  34.409  0.60 20.09           C  
ATOM    249  N   GLY    28       8.241  -5.184  31.003  1.00 17.82           N  
ATOM    250  CA  GLY    28       8.066  -3.945  30.257  1.00 18.09           C  
ATOM    251  C   GLY    28       9.221  -3.577  29.353  1.00 18.07           C  
ATOM    252  O   GLY    28       9.365  -2.424  28.950  1.00 18.91           O  
ATOM    253  N   ASN    29      10.036  -4.547  28.983  1.00 18.26           N  
ATOM    254  CA  ASN    29      11.290  -4.211  28.309  1.00 18.83           C  
ATOM    255  C   ASN    29      11.112  -3.765  26.859  1.00 19.92           C  
ATOM    256  O   ASN    29      12.054  -3.163  26.287  1.00 23.13           O  
ATOM    257  CB  ASN    29      12.315  -5.308  28.491  1.00 19.12           C  
ATOM    258  CG  ASN    29      12.920  -5.252  29.901  1.00 18.82           C  
ATOM    259  OD1 ASN    29      13.210  -4.141  30.417  1.00 20.59           O  
ATOM    260  ND2 ASN    29      13.068  -6.410  30.534  1.00 20.14           N  
ATOM    261  N   SER    30       9.940  -3.996  26.289  1.00 19.51           N  
ATOM    262  CA  SER    30       9.638  -3.436  24.946  1.00 19.62           C  
ATOM    263  C   SER    30       8.833  -2.162  25.064  1.00 19.59           C  
ATOM    264  O   SER    30       8.467  -1.576  24.052  1.00 20.08           O  
ATOM    265  CB  SER    30       8.915  -4.467  24.077  1.00 20.71           C  
ATOM    266  OG  SER    30       7.714  -4.851  24.696  1.00 25.23           O  
ATOM    267  N   ASP    31       8.554  -1.688  26.286  1.00 19.24           N  
ATOM    268  CA  ASP    31       7.719  -0.480  26.428  1.00 19.48           C  
ATOM    269  C   ASP    31       8.399   0.728  25.751  1.00 19.11           C  
ATOM    270  O   ASP    31       9.607   0.921  25.855  1.00 18.28           O  
ATOM    271  CB  ASP    31       7.472  -0.170  27.903  1.00 19.32           C  
ATOM    272  CG  ASP    31       6.382  -1.059  28.540  1.00 20.97           C  
ATOM    273  OD1 ASP    31       5.838  -1.957  27.861  1.00 20.12           O  
ATOM    274  OD2 ASP    31       6.130  -0.786  29.749  1.00 20.60           O  
ATOM    275  N   ASP    32       7.573   1.496  25.059  1.00 19.06           N  
ATOM    276  CA  ASP    32       7.966   2.731  24.373  1.00 20.14           C  
ATOM    277  C   ASP    32       8.776   2.490  23.102  1.00 19.79           C  
ATOM    278  O   ASP    32       9.198   3.461  22.447  1.00 19.91           O  
ATOM    279  CB  ASP    32       8.712   3.674  25.293  1.00 20.73           C  
ATOM    280  CG  ASP    32       7.963   3.948  26.635  1.00 23.39           C  
ATOM    281  OD1 ASP    32       6.803   4.403  26.542  1.00 25.24           O  
ATOM    282  OD2 ASP    32       8.564   3.719  27.723  1.00 25.94           O  
ATOM    283  N   ILE    33       8.996   1.235  22.770  1.00 19.89           N  
ATOM    284  CA  ILE    33       9.673   0.832  21.522  1.00 20.20           C  
ATOM    285  C   ILE    33       8.565   0.449  20.573  1.00 20.72           C  
ATOM    286  O   ILE    33       7.960  -0.632  20.700  1.00 22.37           O  
ATOM    287  CB  ILE    33      10.677  -0.334  21.711  1.00 19.45           C  
ATOM    288  CG1 ILE    33      11.758   0.114  22.689  1.00 21.44           C  
ATOM    289  CG2 ILE    33      11.304  -0.710  20.329  1.00 20.56           C  
ATOM    290  CD1 ILE    33      12.772  -0.956  23.051  1.00 22.94           C  
ATOM    291  N   LEU    34       8.299   1.342  19.626  1.00 19.25           N  
ATOM    292  CA  LEU    34       7.087   1.314  18.818  1.00 17.77           C  
ATOM    293  C   LEU    34       7.338   0.882  17.390  1.00 18.40           C  
ATOM    294  O   LEU    34       8.388   1.119  16.839  1.00 18.47           O  
ATOM    295  CB  LEU    34       6.469   2.701  18.781  1.00 18.47           C  
ATOM    296  CG  LEU    34       6.267   3.371  20.125  1.00 19.72           C  
ATOM    297  CD1 LEU    34       5.545   4.684  19.944  1.00 22.67           C  
ATOM    298  CD2 LEU    34       5.548   2.434  21.132  1.00 21.13           C  
ATOM    299  N   ALA    35       6.348   0.240  16.797  1.00 18.57           N  
ATOM    300  CA  ALA    35       6.435  -0.175  15.394  1.00 17.19           C  
ATOM    301  C   ALA    35       6.217   1.030  14.494  1.00 17.33           C  
ATOM    302  O   ALA    35       5.387   1.913  14.741  1.00 18.24           O  
ATOM    303  CB  ALA    35       5.390  -1.293  15.057  1.00 19.13           C  
ATOM    304  N   ALA    36       6.928   1.044  13.360  1.00 17.01           N  
ATOM    305  CA  ALA    36       6.674   2.049  12.357  1.00 15.71           C  
ATOM    306  C   ALA    36       7.034   1.462  10.990  1.00 16.78           C  
ATOM    307  O   ALA    36       7.901   0.604  10.879  1.00 18.10           O  
ATOM    308  CB  ALA    36       7.457   3.343  12.596  1.00 17.58           C  
ATOM    309  N   VAL    37       6.370   1.955   9.975  1.00 15.62           N  
ATOM    310  CA  VAL    37       6.682   1.549   8.602  0.50 15.71           C  
ATOM    312  C   VAL    37       7.312   2.714   7.873  1.00 14.23           C  
ATOM    313  O   VAL    37       6.779   3.823   7.872  1.00 15.68           O  
ATOM    314  CB  VAL    37       5.451   1.037   7.797  0.50 15.29           C  
ATOM    316  CG1 VAL    37       4.346   2.086   7.714  0.50 16.13           C  
ATOM    318  CG2 VAL    37       5.858   0.619   6.389  0.50 16.06           C  
ATOM    320  N   VAL    38       8.435   2.456   7.238  1.00 14.86           N  
ATOM    321  CA  VAL    38       9.172   3.493   6.517  1.00 14.41           C  
ATOM    322  C   VAL    38       8.438   3.924   5.239  1.00 15.45           C  
ATOM    323  O   VAL    38       7.986   3.077   4.449  1.00 14.72           O  
ATOM    324  CB  VAL    38      10.630   3.065   6.225  1.00 15.18           C  
ATOM    325  CG1 VAL    38      11.345   4.116   5.259  1.00 14.75           C  
ATOM    326  CG2 VAL    38      11.387   2.893   7.574  1.00 15.41           C  
ATOM    327  N   LEU    39       8.293   5.236   5.093  1.00 14.89           N  
ATOM    328  CA  LEU    39       7.728   5.844   3.883  1.00 15.30           C  
ATOM    329  C   LEU    39       8.802   6.367   2.923  1.00 16.16           C  
ATOM    330  O   LEU    39       8.618   6.337   1.717  1.00 17.32           O  
ATOM    331  CB  LEU    39       6.793   7.008   4.266  1.00 16.91           C  
ATOM    332  CG  LEU    39       5.696   6.599   5.252  1.00 17.60           C  
ATOM    333  CD1 LEU    39       4.796   7.809   5.545  1.00 21.11           C  
ATOM    334  CD2 LEU    39       4.876   5.379   4.818  1.00 20.56           C  
ATOM    335  N   SER    40       9.878   6.946   3.451  1.00 16.45           N  
ATOM    336  CA  SER    40      10.967   7.414   2.684  1.00 16.91           C  
ATOM    337  C   SER    40      12.241   7.291   3.490  1.00 16.85           C  
ATOM    338  O   SER    40      12.195   7.364   4.707  1.00 15.68           O  
ATOM    339  CB  SER    40      10.726   8.848   2.271  1.00 18.60           C  
ATOM    340  OG  SER    40      10.878   9.725   3.348  1.00 19.69           O  
ATOM    341  N   ALA    41      13.376   7.151   2.802  1.00 16.13           N  
ATOM    342  CA  ALA    41      14.666   7.013   3.492  1.00 16.24           C  
ATOM    343  C   ALA    41      15.808   7.516   2.678  1.00 17.06           C  
ATOM    344  O   ALA    41      15.937   7.212   1.489  1.00 17.44           O  
ATOM    345  CB  ALA    41      14.932   5.590   3.873  1.00 16.02           C  
ATOM    346  N   THR    42      16.603   8.346   3.317  1.00 17.62           N  
ATOM    347  CA  THR    42      17.909   8.824   2.826  1.00 18.26           C  
ATOM    348  C   THR    42      18.903   8.767   3.996  1.00 18.56           C  
ATOM    349  O   THR    42      18.496   8.630   5.155  1.00 16.63           O  
ATOM    350  CB  THR    42      17.820  10.268   2.317  1.00 18.38           C  
ATOM    351  OG1 THR    42      17.681  11.157   3.433  1.00 21.26           O  
ATOM    352  CG2 THR    42      16.634  10.457   1.330  1.00 21.04           C  
ATOM    353  N   PRO    43      20.207   8.983   3.741  1.00 18.87           N  
ATOM    354  CA  PRO    43      21.125   9.006   4.879  1.00 18.55           C  
ATOM    355  C   PRO    43      20.851  10.148   5.880  1.00 18.56           C  
ATOM    356  O   PRO    43      21.326  10.095   7.044  1.00 20.67           O  
ATOM    357  CB  PRO    43      22.499   9.197   4.201  1.00 19.88           C  
ATOM    358  CG  PRO    43      22.329   8.653   2.885  1.00 19.28           C  
ATOM    359  CD  PRO    43      20.938   9.070   2.467  1.00 20.45           C  
ATOM    360  N   GLY    44      20.139  11.170   5.431  1.00 16.96           N  
ATOM    361  CA  GLY    44      19.835  12.346   6.269  1.00 17.33           C  
ATOM    362  C   GLY    44      18.471  12.343   6.932  1.00 16.12           C  
ATOM    363  O   GLY    44      18.259  13.110   7.843  1.00 16.70           O  
ATOM    364  N   ALA    45      17.521  11.522   6.465  1.00 15.44           N  
ATOM    365  CA  ALA    45      16.194  11.546   7.049  1.00 16.18           C  
ATOM    366  C   ALA    45      15.409  10.293   6.680  1.00 16.57           C  
ATOM    367  O   ALA    45      15.433   9.862   5.536  1.00 16.49           O  
ATOM    368  CB  ALA    45      15.445  12.726   6.525  1.00 16.54           C  
ATOM    369  N   VAL    46      14.702   9.747   7.648  1.00 16.15           N  
ATOM    370  CA  VAL    46      13.752   8.676   7.432  1.00 15.46           C  
ATOM    371  C   VAL    46      12.395   9.193   7.901  1.00 16.21           C  
ATOM    372  O   VAL    46      12.272   9.685   9.044  1.00 15.82           O  
ATOM    373  CB  VAL    46      14.173   7.440   8.255  1.00 14.79           C  
ATOM    374  CG1 VAL    46      13.059   6.405   8.283  1.00 16.16           C  
ATOM    375  CG2 VAL    46      15.520   6.906   7.736  1.00 15.90           C  
ATOM    376  N   GLU    47      11.375   9.063   7.045  1.00 16.26           N  
ATOM    377  CA  GLU    47       9.987   9.338   7.431  1.00 17.37           C  
ATOM    378  C   GLU    47       9.318   7.985   7.648  1.00 17.25           C  
ATOM    379  O   GLU    47       9.447   7.094   6.805  1.00 16.35           O  
ATOM    380  CB  GLU    47       9.240  10.078   6.308  1.00 18.76           C  
ATOM    381  CG  GLU    47       9.768  11.459   6.058  1.00 22.56           C  
ATOM    382  CD  GLU    47       8.728  12.493   5.613  1.00 27.08           C  
ATOM    383  OE1 GLU    47       7.596  12.140   5.191  1.00 32.70           O  
ATOM    384  OE2 GLU    47       9.093  13.699   5.695  1.00 39.15           O  
ATOM    385  N   ALA    48       8.608   7.831   8.751  1.00 15.79           N  
ATOM    386  CA  ALA    48       7.954   6.581   9.088  1.00 16.62           C  
ATOM    387  C   ALA    48       6.568   6.823   9.690  1.00 16.84           C  
ATOM    388  O   ALA    48       6.358   7.839  10.370  1.00 19.46           O  
ATOM    389  CB  ALA    48       8.843   5.735  10.026  1.00 17.11           C  
ATOM    390  N   PHE    49       5.635   5.922   9.429  1.00 16.37           N  
ATOM    391  CA  PHE    49       4.267   5.991   9.929  1.00 17.59           C  
ATOM    392  C   PHE    49       4.122   5.056  11.129  1.00 18.32           C  
ATOM    393  O   PHE    49       4.501   3.899  11.058  1.00 17.79           O  
ATOM    394  CB  PHE    49       3.296   5.544   8.820  1.00 17.85           C  
ATOM    395  CG  PHE    49       1.842   5.641   9.191  1.00 18.30           C  
ATOM    396  CD1 PHE    49       1.144   6.802   8.933  1.00 21.76           C  
ATOM    397  CD2 PHE    49       1.164   4.553   9.695  1.00 20.75           C  
ATOM    398  CE1 PHE    49      -0.227   6.916   9.249  1.00 20.36           C  
ATOM    399  CE2 PHE    49      -0.206   4.656  10.047  1.00 19.72           C  
ATOM    400  CZ  PHE    49      -0.881   5.839   9.796  1.00 22.60           C  
ATOM    401  N   ARG    50       3.636   5.563  12.253  1.00 19.08           N  
ATOM    402  CA  ARG    50       3.464   4.703  13.441  1.00 20.23           C  
ATOM    403  C   ARG    50       1.972   4.382  13.686  1.00 21.07           C  
ATOM    404  O   ARG    50       1.117   4.995  13.106  1.00 20.64           O  
ATOM    405  CB  ARG    50       4.134   5.305  14.688  1.00 22.94           C  
ATOM    406  CG  ARG    50       3.763   6.662  15.046  1.00 23.31           C  
ATOM    407  CD  ARG    50       4.729   7.128  16.134  1.00 22.13           C  
ATOM    408  NE  ARG    50       4.369   8.344  16.762  1.00 24.32           N  
ATOM    409  CZ  ARG    50       3.791   8.440  17.969  1.00 23.15           C  
ATOM    410  NH1 ARG    50       3.443   7.362  18.655  1.00 26.13           N  
ATOM    411  NH2 ARG    50       3.534   9.622  18.479  1.00 24.48           N  
ATOM    412  N   LYS    51       1.701   3.437  14.570  1.00 21.95           N  
ATOM    413  CA  LYS    51       0.329   2.957  14.793  1.00 22.96           C  
ATOM    414  C   LYS    51      -0.644   4.022  15.207  1.00 23.88           C  
ATOM    415  O   LYS    51      -1.836   3.907  14.899  1.00 27.15           O  
ATOM    416  CB  LYS    51       0.344   1.884  15.880  1.00 24.30           C  
ATOM    417  CG  LYS    51       0.928   0.570  15.440  1.00 26.87           C  
ATOM    418  CD  LYS    51      -0.058  -0.226  14.582  1.00 29.44           C  
ATOM    419  CE  LYS    51      -1.205  -0.890  15.358  1.00 30.13           C  
ATOM    420  NZ  LYS    51      -1.944  -1.954  14.526  1.00 28.19           N  
ATOM    421  N   ASN    52      -0.193   5.045  15.923  1.00 23.72           N  
ATOM    422  CA  ASN    52      -1.125   6.100  16.359  1.00 24.26           C  
ATOM    423  C   ASN    52      -1.538   7.030  15.207  1.00 24.17           C  
ATOM    424  O   ASN    52      -2.323   7.978  15.409  1.00 25.42           O  
ATOM    425  CB  ASN    52      -0.554   6.871  17.558  1.00 25.03           C  
ATOM    426  CG  ASN    52       0.317   8.020  17.160  1.00 24.42           C  
ATOM    427  OD1 ASN    52       0.962   7.983  16.114  1.00 25.79           O  
ATOM    428  ND2 ASN    52       0.299   9.079  17.951  1.00 26.65           N  
ATOM    429  N   GLY    53      -1.017   6.768  14.005  1.00 23.35           N  
ATOM    430  CA  GLY    53      -1.366   7.494  12.812  1.00 23.25           C  
ATOM    431  C   GLY    53      -0.460   8.670  12.473  1.00 22.61           C  
ATOM    432  O   GLY    53      -0.703   9.373  11.499  1.00 24.10           O  
ATOM    433  N   GLU    54       0.538   8.935  13.311  1.00 22.55           N  
ATOM    434  CA  GLU    54       1.405  10.054  13.034  0.50 22.38           C  
ATOM    436  C   GLU    54       2.587   9.612  12.165  1.00 21.93           C  
ATOM    437  O   GLU    54       3.020   8.453  12.207  1.00 20.56           O  
ATOM    438  CB  GLU    54       1.816  10.735  14.347  0.50 22.86           C  
ATOM    440  CG  GLU    54       0.597  11.429  14.982  0.50 23.21           C  
ATOM    442  CD  GLU    54       0.817  12.068  16.340  0.50 25.13           C  
ATOM    444  OE1 GLU    54       1.708  11.658  17.107  0.50 26.68           O  
ATOM    446  OE2 GLU    54       0.037  12.995  16.648  0.50 28.52           O  
ATOM    448  N   THR    55       3.045  10.538  11.335  1.00 21.52           N  
ATOM    449  CA  THR    55       4.233  10.331  10.508  1.00 21.28           C  
ATOM    450  C   THR    55       5.336  11.097  11.229  1.00 21.26           C  
ATOM    451  O   THR    55       5.202  12.280  11.575  1.00 24.07           O  
ATOM    452  CB  THR    55       4.059  10.775   9.067  1.00 22.75           C  
ATOM    453  OG1 THR    55       3.020   9.997   8.430  1.00 23.47           O  
ATOM    454  CG2 THR    55       5.373  10.586   8.283  1.00 23.69           C  
ATOM    455  N   ILE    56       6.388  10.377  11.530  1.00 18.81           N  
ATOM    456  CA  ILE    56       7.560  10.946  12.221  1.00 17.71           C  
ATOM    457  C   ILE    56       8.734  11.049  11.242  1.00 16.62           C  
ATOM    458  O   ILE    56       8.769  10.351  10.240  1.00 15.72           O  
ATOM    459  CB  ILE    56       7.998  10.101  13.463  1.00 16.48           C  
ATOM    460  CG1 ILE    56       8.324   8.643  13.102  1.00 18.49           C  
ATOM    461  CG2 ILE    56       6.891  10.128  14.560  1.00 20.69           C  
ATOM    462  CD1 ILE    56       8.915   7.805  14.252  1.00 18.71           C  
ATOM    463  N   ARG    57       9.641  11.970  11.557  1.00 17.01           N  
ATOM    464  CA  ARG    57      10.857  12.170  10.790  1.00 16.90           C  
ATOM    465  C   ARG    57      12.059  11.961  11.712  1.00 18.52           C  
ATOM    466  O   ARG    57      12.203  12.700  12.712  1.00 18.30           O  
ATOM    467  CB  ARG    57      10.877  13.578  10.175  1.00 18.21           C  
ATOM    468  CG  ARG    57      11.843  13.767   9.044  1.00 22.16           C  
ATOM    469  CD  ARG    57      11.482  15.091   8.275  1.00 22.79           C  
ATOM    470  NE  ARG    57      12.260  15.266   7.076  1.00 30.28           N  
ATOM    471  CZ  ARG    57      13.426  15.885   7.007  1.00 29.98           C  
ATOM    472  NH1 ARG    57      14.012  16.421   8.094  1.00 33.28           N  
ATOM    473  NH2 ARG    57      14.032  15.957   5.829  1.00 32.68           N  
ATOM    474  N   ILE    58      12.936  11.028  11.349  1.00 15.91           N  
ATOM    475  CA  ILE    58      14.128  10.653  12.155  1.00 15.94           C  
ATOM    476  C   ILE    58      15.335  11.194  11.407  1.00 16.27           C  
ATOM    477  O   ILE    58      15.485  10.933  10.213  1.00 14.90           O  
ATOM    478  CB  ILE    58      14.242   9.140  12.377  1.00 16.25           C  
ATOM    479  CG1 ILE    58      12.926   8.623  13.001  1.00 20.10           C  
ATOM    480  CG2 ILE    58      15.455   8.775  13.294  1.00 16.57           C  
ATOM    481  CD1 ILE    58      12.483   7.265  12.468  1.00 23.93           C  
ATOM    482  N   THR    59      16.197  11.910  12.141  1.00 14.89           N  
ATOM    483  CA  THR    59      17.358  12.593  11.568  1.00 14.15           C  
ATOM    484  C   THR    59      18.504  12.573  12.586  1.00 14.35           C  
ATOM    485  O   THR    59      18.307  12.162  13.715  1.00 14.11           O  
ATOM    486  CB  THR    59      17.069  14.081  11.229  1.00 14.81           C  
ATOM    487  OG1 THR    59      16.779  14.818  12.442  1.00 13.82           O  
ATOM    488  CG2 THR    59      15.872  14.174  10.256  1.00 14.18           C  
ATOM    489  N   GLY    60      19.662  13.078  12.202  1.00 13.00           N  
ATOM    490  CA  GLY    60      20.785  13.294  13.142  1.00 14.55           C  
ATOM    491  C   GLY    60      21.076  12.078  14.032  1.00 15.23           C  
ATOM    492  O   GLY    60      21.268  10.956  13.557  1.00 15.55           O  
ATOM    493  N   ASP    61      21.107  12.333  15.323  1.00 14.66           N  
ATOM    494  CA  ASP    61      21.464  11.288  16.310  1.00 15.90           C  
ATOM    495  C   ASP    61      20.544  10.072  16.200  1.00 16.16           C  
ATOM    496  O   ASP    61      20.988   8.929  16.399  1.00 16.88           O  
ATOM    497  CB  ASP    61      21.390  11.842  17.714  1.00 16.78           C  
ATOM    498  CG  ASP    61      22.453  12.862  18.020  1.00 19.80           C  
ATOM    499  OD1 ASP    61      23.417  13.063  17.234  1.00 23.93           O  
ATOM    500  OD2 ASP    61      22.320  13.459  19.136  1.00 27.40           O  
ATOM    501  N   GLY    62      19.269  10.299  15.862  1.00 13.92           N  
ATOM    502  CA  GLY    62      18.296   9.222  15.746  1.00 15.21           C  
ATOM    503  C   GLY    62      18.607   8.184  14.692  1.00 15.36           C  
ATOM    504  O   GLY    62      18.053   7.093  14.739  1.00 16.47           O  
ATOM    505  N   LEU    63      19.447   8.530  13.705  1.00 15.12           N  
ATOM    506  CA  LEU    63      19.813   7.633  12.637  1.00 14.66           C  
ATOM    507  C   LEU    63      21.161   6.929  12.860  1.00 16.62           C  
ATOM    508  O   LEU    63      21.553   6.092  12.067  1.00 17.65           O  
ATOM    509  CB  LEU    63      19.895   8.412  11.307  1.00 14.91           C  
ATOM    510  CG  LEU    63      18.610   9.028  10.816  1.00 14.93           C  
ATOM    511  CD1 LEU    63      18.872   9.730   9.475  1.00 16.30           C  
ATOM    512  CD2 LEU    63      17.484   7.995  10.686  1.00 15.68           C  
ATOM    513  N   LYS    64      21.879   7.292  13.912  1.00 15.36           N  
ATOM    514  CA  LYS    64      23.251   6.825  14.127  0.50 17.84           C  
ATOM    516  C   LYS    64      23.350   5.313  14.202  1.00 17.93           C  
ATOM    517  O   LYS    64      24.201   4.683  13.539  1.00 18.87           O  
ATOM    518  CB  LYS    64      23.803   7.419  15.421  0.50 18.24           C  
ATOM    520  CG  LYS    64      24.118   8.919  15.346  0.50 18.90           C  
ATOM    522  CD  LYS    64      24.682   9.481  16.677  0.50 21.52           C  
ATOM    524  CE  LYS    64      26.140   9.169  16.864  0.50 25.23           C  
ATOM    526  NZ  LYS    64      26.990   9.892  15.880  0.50 27.58           N  
ATOM    528  N   ALA    65      22.489   4.723  15.032  1.00 19.45           N  
ATOM    529  CA  ALA    65      22.573   3.266  15.255  1.00 19.45           C  
ATOM    530  C   ALA    65      22.318   2.519  13.970  1.00 20.13           C  
ATOM    531  O   ALA    65      22.956   1.506  13.706  1.00 21.80           O  
ATOM    532  CB  ALA    65      21.609   2.832  16.300  1.00 20.20           C  
ATOM    533  N   ALA    66      21.444   3.053  13.127  1.00 19.24           N  
ATOM    534  CA  ALA    66      21.020   2.427  11.875  1.00 20.12           C  
ATOM    535  C   ALA    66      21.899   2.739  10.641  1.00 20.14           C  
ATOM    536  O   ALA    66      21.545   2.431   9.497  1.00 19.93           O  
ATOM    537  CB  ALA    66      19.537   2.784  11.608  1.00 19.17           C  
ATOM    538  N   HIS    67      23.032   3.414  10.876  1.00 20.96           N  
ATOM    539  CA  HIS    67      23.874   3.973   9.798  1.00 22.50           C  
ATOM    540  C   HIS    67      24.131   3.057   8.595  1.00 22.69           C  
ATOM    541  O   HIS    67      23.989   3.483   7.437  1.00 23.41           O  
ATOM    542  CB  HIS    67      25.197   4.541  10.372  1.00 23.45           C  
ATOM    543  CG  HIS    67      26.126   3.542  11.028  1.00 26.82           C  
ATOM    544  ND1 HIS    67      25.899   2.978  12.266  1.00 32.13           N  
ATOM    545  CD2 HIS    67      27.348   3.080  10.635  1.00 30.02           C  
ATOM    546  CE1 HIS    67      26.898   2.169  12.582  1.00 33.51           C  
ATOM    547  NE2 HIS    67      27.792   2.218  11.610  1.00 33.86           N  
ATOM    548  N   ARG    68      24.408   1.803   8.879  1.00 23.67           N  
ATOM    549  CA  ARG    68      24.853   0.871   7.842  1.00 25.02           C  
ATOM    550  C   ARG    68      23.705   0.512   6.938  1.00 22.30           C  
ATOM    551  O   ARG    68      23.901   0.185   5.787  1.00 22.56           O  
ATOM    552  CB  ARG    68      25.434  -0.344   8.498  1.00 24.82           C  
ATOM    553  CG  ARG    68      26.707   0.042   9.249  1.00 30.85           C  
ATOM    554  CD  ARG    68      27.251  -1.030  10.152  1.00 31.45           C  
ATOM    555  NE  ARG    68      27.030  -2.400   9.701  1.00 37.79           N  
ATOM    556  CZ  ARG    68      27.584  -2.962   8.632  1.00 38.95           C  
ATOM    557  NH1 ARG    68      28.387  -2.272   7.823  1.00 41.74           N  
ATOM    558  NH2 ARG    68      27.322  -4.240   8.369  1.00 39.77           N  
ATOM    559  N   PHE    69      22.504   0.595   7.497  1.00 19.79           N  
ATOM    560  CA  PHE    69      21.286   0.350   6.733  1.00 19.43           C  
ATOM    561  C   PHE    69      20.734   1.541   5.979  1.00 19.65           C  
ATOM    562  O   PHE    69      19.701   1.423   5.340  1.00 19.12           O  
ATOM    563  CB  PHE    69      20.253  -0.281   7.668  1.00 18.19           C  
ATOM    564  CG  PHE    69      20.676  -1.645   8.125  1.00 18.08           C  
ATOM    565  CD1 PHE    69      21.572  -1.808   9.173  1.00 20.24           C  
ATOM    566  CD2 PHE    69      20.239  -2.769   7.441  1.00 18.30           C  
ATOM    567  CE1 PHE    69      21.988  -3.089   9.532  1.00 18.89           C  
ATOM    568  CE2 PHE    69      20.661  -4.045   7.806  1.00 20.19           C  
ATOM    569  CZ  PHE    69      21.524  -4.186   8.845  1.00 19.83           C  
ATOM    570  N   LEU    70      21.457   2.669   6.005  1.00 20.27           N  
ATOM    571  CA  LEU    70      21.095   3.866   5.245  1.00 22.90           C  
ATOM    572  C   LEU    70      22.208   4.335   4.308  1.00 25.29           C  
ATOM    573  O   LEU    70      22.002   5.257   3.520  1.00 26.73           O  
ATOM    574  CB  LEU    70      20.781   5.012   6.233  1.00 23.31           C  
ATOM    575  CG  LEU    70      19.562   4.755   7.119  1.00 21.31           C  
ATOM    576  CD1 LEU    70      19.661   5.653   8.378  1.00 24.18           C  
ATOM    577  CD2 LEU    70      18.328   5.018   6.305  1.00 20.23           C  
ATOM    578  N   SER    71      23.353   3.653   4.356  1.00 26.45           N  
ATOM    579  CA  SER    71      24.587   4.095   3.688  1.00 27.55           C  
ATOM    580  C   SER    71      24.781   3.559   2.280  1.00 28.74           C  
ATOM    581  O   SER    71      25.758   3.970   1.601  1.00 29.80           O  
ATOM    582  CB  SER    71      25.772   3.565   4.472  1.00 28.48           C  
ATOM    583  OG  SER    71      25.814   2.132   4.350  1.00 29.58           O  
ATOM    584  N   ASN    72      23.919   2.637   1.840  1.00 27.09           N  
ATOM    585  CA  ASN    72      24.109   1.939   0.546  0.50 27.05           C  
ATOM    587  C   ASN    72      25.380   1.091   0.533  1.00 26.48           C  
ATOM    588  O   ASN    72      25.998   0.890  -0.495  1.00 25.99           O  
ATOM    589  CB  ASN    72      24.106   2.893  -0.675  0.50 27.83           C  
ATOM    591  CG  ASN    72      22.703   3.159  -1.234  0.50 28.59           C  
ATOM    593  OD1 ASN    72      21.791   2.300  -1.198  0.50 32.27           O  
ATOM    595  ND2 ASN    72      22.528   4.359  -1.773  0.50 29.54           N  
ATOM    597  N   ASP    73      25.749   0.542   1.686  1.00 25.43           N  
ATOM    598  CA  ASP    73      26.875  -0.421   1.798  1.00 24.74           C  
ATOM    599  C   ASP    73      26.488  -1.639   0.942  1.00 23.75           C  
ATOM    600  O   ASP    73      25.420  -2.208   1.157  1.00 20.54           O  
ATOM    601  CB  ASP    73      27.027  -0.835   3.265  1.00 25.17           C  
ATOM    602  CG  ASP    73      28.020  -1.980   3.495  1.00 26.12           C  
ATOM    603  OD1 ASP    73      28.691  -2.475   2.569  1.00 30.99           O  
ATOM    604  OD2 ASP    73      28.101  -2.401   4.667  1.00 35.81           O  
ATOM    605  N   PRO    74      27.323  -2.022  -0.030  1.00 23.57           N  
ATOM    606  CA  PRO    74      26.905  -3.122  -0.921  1.00 24.30           C  
ATOM    607  C   PRO    74      26.670  -4.459  -0.231  1.00 24.84           C  
ATOM    608  O   PRO    74      25.870  -5.256  -0.709  1.00 26.45           O  
ATOM    609  CB  PRO    74      28.062  -3.203  -1.942  1.00 23.95           C  
ATOM    610  CG  PRO    74      28.658  -1.821  -1.905  1.00 24.58           C  
ATOM    611  CD  PRO    74      28.629  -1.482  -0.450  1.00 24.00           C  
ATOM    612  N   LYS    75      27.332  -4.708   0.891  1.00 25.11           N  
ATOM    613  CA  LYS    75      27.130  -5.948   1.623  1.00 26.59           C  
ATOM    614  C   LYS    75      25.736  -6.045   2.221  1.00 25.93           C  
ATOM    615  O   LYS    75      25.200  -7.135   2.361  1.00 27.46           O  
ATOM    616  CB  LYS    75      28.133  -6.079   2.757  1.00 27.40           C  
ATOM    617  CG  LYS    75      29.571  -6.266   2.291  1.00 30.20           C  
ATOM    618  CD  LYS    75      30.541  -6.071   3.457  1.00 30.42           C  
ATOM    619  CE  LYS    75      31.984  -6.045   2.995  1.00 33.03           C  
ATOM    620  NZ  LYS    75      32.892  -6.078   4.194  1.00 35.70           N  
ATOM    621  N   ILE    76      25.166  -4.913   2.601  1.00 23.73           N  
ATOM    622  CA  ILE    76      23.809  -4.916   3.141  1.00 23.46           C  
ATOM    623  C   ILE    76      22.796  -5.053   1.994  1.00 22.14           C  
ATOM    624  O   ILE    76      21.798  -5.755   2.127  1.00 20.70           O  
ATOM    625  CB  ILE    76      23.584  -3.686   4.022  1.00 24.00           C  
ATOM    626  CG1 ILE    76      24.357  -3.908   5.328  1.00 27.47           C  
ATOM    627  CG2 ILE    76      22.078  -3.476   4.336  1.00 23.08           C  
ATOM    628  CD1 ILE    76      24.772  -2.697   5.964  1.00 30.61           C  
ATOM    629  N   GLY    77      23.054  -4.389   0.872  1.00 21.67           N  
ATOM    630  CA  GLY    77      22.162  -4.511  -0.299  1.00 23.17           C  
ATOM    631  C   GLY    77      20.722  -4.151   0.019  1.00 23.16           C  
ATOM    632  O   GLY    77      20.499  -3.202   0.757  1.00 21.68           O  
ATOM    633  N   GLU    78      19.732  -4.918  -0.484  1.00 23.84           N  
ATOM    634  CA  GLU    78      18.312  -4.590  -0.222  1.00 24.68           C  
ATOM    635  C   GLU    78      17.813  -4.974   1.181  1.00 24.33           C  
ATOM    636  O   GLU    78      16.629  -4.789   1.473  1.00 25.22           O  
ATOM    637  CB  GLU    78      17.364  -5.168  -1.302  1.00 26.64           C  
ATOM    638  CG  GLU    78      17.418  -4.480  -2.675  1.00 29.65           C  
ATOM    639  CD  GLU    78      16.578  -3.175  -2.782  1.00 33.89           C  
ATOM    640  OE1 GLU    78      15.333  -3.239  -3.075  1.00 31.41           O  
ATOM    641  OE2 GLU    78      17.177  -2.079  -2.589  1.00 40.88           O  
ATOM    642  N   LYS    79      18.700  -5.410   2.079  1.00 22.93           N  
ATOM    643  CA  LYS    79      18.361  -5.427   3.493  1.00 23.03           C  
ATOM    644  C   LYS    79      18.274  -4.017   4.070  1.00 20.63           C  
ATOM    645  O   LYS    79      17.859  -3.837   5.206  1.00 20.01           O  
ATOM    646  CB  LYS    79      19.393  -6.225   4.292  1.00 23.69           C  
ATOM    647  CG  LYS    79      19.299  -7.709   3.999  1.00 26.92           C  
ATOM    648  CD  LYS    79      20.379  -8.489   4.748  1.00 28.53           C  
ATOM    649  CE  LYS    79      20.377  -9.959   4.320  1.00 31.81           C  
ATOM    650  NZ  LYS    79      21.343 -10.239   3.217  1.00 34.09           N  
ATOM    651  N   ARG    80      18.704  -3.024   3.298  1.00 21.12           N  
ATOM    652  CA  ARG    80      18.705  -1.639   3.757  1.00 20.87           C  
ATOM    653  C   ARG    80      17.293  -1.138   4.068  1.00 19.89           C  
ATOM    654  O   ARG    80      16.315  -1.671   3.561  1.00 20.87           O  
ATOM    655  CB  ARG    80      19.366  -0.719   2.751  1.00 21.02           C  
ATOM    656  CG  ARG    80      18.562  -0.475   1.551  1.00 22.63           C  
ATOM    657  CD  ARG    80      19.314   0.371   0.508  1.00 25.39           C  
ATOM    658  NE  ARG    80      18.437   0.440  -0.642  1.00 29.73           N  
ATOM    659  CZ  ARG    80      17.483   1.357  -0.864  1.00 32.12           C  
ATOM    660  NH1 ARG    80      17.229   2.386  -0.014  1.00 34.12           N  
ATOM    661  NH2 ARG    80      16.751   1.230  -1.965  1.00 29.96           N  
ATOM    662  N   ILE    81      17.237  -0.105   4.874  1.00 18.86           N  
ATOM    663  CA  ILE    81      15.997   0.629   5.137  1.00 18.98           C  
ATOM    664  C   ILE    81      15.544   1.319   3.844  1.00 19.21           C  
ATOM    665  O   ILE    81      16.338   2.004   3.173  1.00 21.40           O  
ATOM    666  CB  ILE    81      16.197   1.625   6.256  1.00 19.16           C  
ATOM    667  CG1 ILE    81      16.408   0.857   7.574  1.00 18.53           C  
ATOM    668  CG2 ILE    81      15.006   2.601   6.364  1.00 19.73           C  
ATOM    669  CD1 ILE    81      17.055   1.628   8.701  1.00 20.65           C  
ATOM    670  N   ARG    82      14.274   1.128   3.504  1.00 18.22           N  
ATOM    671  CA  ARG    82      13.688   1.557   2.209  0.50 17.65           C  
ATOM    673  C   ARG    82      12.182   1.643   2.425  1.00 17.73           C  
ATOM    674  O   ARG    82      11.660   1.090   3.399  1.00 16.98           O  
ATOM    675  CB  ARG    82      14.008   0.561   1.075  0.50 18.23           C  
ATOM    677  CG  ARG    82      13.015  -0.649   0.888  0.50 16.80           C  
ATOM    679  CD  ARG    82      13.220  -1.403  -0.465  0.50 17.15           C  
ATOM    681  NE  ARG    82      12.162  -2.396  -0.723  0.50 17.23           N  
ATOM    683  CZ  ARG    82      12.274  -3.709  -0.531  0.50 15.45           C  
ATOM    685  NH1 ARG    82      13.430  -4.257  -0.164  0.50 15.77           N  
ATOM    687  NH2 ARG    82      11.228  -4.497  -0.780  0.50 15.69           N  
ATOM    689  N   PRO    83      11.445   2.300   1.510  1.00 17.33           N  
ATOM    690  CA  PRO    83      10.002   2.307   1.757  1.00 16.91           C  
ATOM    691  C   PRO    83       9.361   0.934   1.945  1.00 16.61           C  
ATOM    692  O   PRO    83       9.564   0.019   1.119  1.00 17.77           O  
ATOM    693  CB  PRO    83       9.439   3.036   0.539  1.00 17.58           C  
ATOM    694  CG  PRO    83      10.548   3.837   0.051  1.00 16.41           C  
ATOM    695  CD  PRO    83      11.804   3.087   0.325  1.00 17.89           C  
ATOM    696  N   GLY    84       8.588   0.809   3.007  1.00 14.86           N  
ATOM    697  CA  GLY    84       7.959  -0.434   3.420  1.00 15.67           C  
ATOM    698  C   GLY    84       8.674  -1.152   4.541  1.00 15.52           C  
ATOM    699  O   GLY    84       8.121  -2.067   5.126  1.00 17.23           O  
ATOM    700  N   ALA    85       9.898  -0.737   4.843  1.00 15.34           N  
ATOM    701  CA  ALA    85      10.636  -1.389   5.913  1.00 15.80           C  
ATOM    702  C   ALA    85       9.875  -1.233   7.211  1.00 15.88           C  
ATOM    703  O   ALA    85       9.489  -0.137   7.570  1.00 16.97           O  
ATOM    704  CB  ALA    85      12.004  -0.790   6.026  1.00 15.08           C  
ATOM    705  N   LEU    86       9.720  -2.344   7.924  1.00 18.25           N  
ATOM    706  CA  LEU    86       9.190  -2.359   9.282  1.00 17.93           C  
ATOM    707  C   LEU    86      10.353  -2.152  10.253  1.00 18.43           C  
ATOM    708  O   LEU    86      11.299  -2.955  10.332  1.00 18.46           O  
ATOM    709  CB  LEU    86       8.472  -3.697   9.575  1.00 18.48           C  
ATOM    710  CG  LEU    86       7.905  -3.859  10.985  1.00 20.15           C  
ATOM    711  CD1 LEU    86       6.882  -2.777  11.316  1.00 23.23           C  
ATOM    712  CD2 LEU    86       7.327  -5.271  11.129  1.00 20.48           C  
ATOM    713  N   ILE    87      10.281  -1.045  10.979  1.00 17.40           N  
ATOM    714  CA  ILE    87      11.304  -0.664  11.971  1.00 17.79           C  
ATOM    715  C   ILE    87      10.691  -0.466  13.315  1.00 16.97           C  
ATOM    716  O   ILE    87       9.466  -0.472  13.474  1.00 18.03           O  
ATOM    717  CB  ILE    87      12.079   0.611  11.522  1.00 16.69           C  
ATOM    718  CG1 ILE    87      11.141   1.799  11.307  1.00 17.19           C  
ATOM    719  CG2 ILE    87      12.872   0.270  10.190  1.00 18.98           C  
ATOM    720  CD1 ILE    87      11.823   3.133  11.188  1.00 18.86           C  
ATOM    721  N   ARG    88      11.546  -0.259  14.292  1.00 16.37           N  
ATOM    722  CA  ARG    88      11.104   0.101  15.626  1.00 15.89           C  
ATOM    723  C   ARG    88      11.725   1.441  15.956  1.00 16.06           C  
ATOM    724  O   ARG    88      12.890   1.704  15.645  1.00 15.92           O  
ATOM    725  CB  ARG    88      11.551  -0.950  16.656  1.00 16.91           C  
ATOM    726  CG  ARG    88      11.052  -2.363  16.313  1.00 19.48           C  
ATOM    727  CD  ARG    88       9.563  -2.596  16.597  1.00 22.43           C  
ATOM    728  NE  ARG    88       9.195  -3.877  16.014  1.00 25.15           N  
ATOM    729  CZ  ARG    88       8.005  -4.465  16.140  1.00 24.03           C  
ATOM    730  NH1 ARG    88       7.064  -3.921  16.884  1.00 22.87           N  
ATOM    731  NH2 ARG    88       7.794  -5.626  15.506  1.00 26.11           N  
ATOM    732  N   VAL    89      10.947   2.244  16.646  1.00 16.11           N  
ATOM    733  CA  VAL    89      11.362   3.602  17.021  1.00 15.28           C  
ATOM    734  C   VAL    89      11.067   3.919  18.472  1.00 16.66           C  
ATOM    735  O   VAL    89      10.122   3.363  19.062  1.00 17.18           O  
ATOM    736  CB  VAL    89      10.672   4.637  16.105  1.00 15.17           C  
ATOM    737  CG1 VAL    89      11.089   4.396  14.673  1.00 16.98           C  
ATOM    738  CG2 VAL    89       9.155   4.521  16.206  1.00 17.06           C  
ATOM    739  N   LYS    90      11.848   4.847  19.017  1.00 16.96           N  
ATOM    740  CA  LYS    90      11.616   5.305  20.380  1.00 17.78           C  
ATOM    741  C   LYS    90      11.880   6.822  20.433  1.00 18.76           C  
ATOM    742  O   LYS    90      12.876   7.285  19.874  1.00 18.51           O  
ATOM    743  CB  LYS    90      12.577   4.566  21.301  1.00 18.95           C  
ATOM    744  CG  LYS    90      12.395   4.805  22.797  1.00 19.52           C  
ATOM    745  CD  LYS    90      13.376   3.969  23.591  1.00 22.77           C  
ATOM    746  CE  LYS    90      13.408   4.296  25.059  1.00 29.12           C  
ATOM    747  NZ  LYS    90      12.162   4.691  25.679  1.00 35.66           N  
ATOM    748  N   LYS    91      11.107   7.510  21.260  1.00 18.93           N  
ATOM    749  CA  LYS    91      11.228   8.949  21.424  1.00 19.03           C  
ATOM    750  C   LYS    91      12.187   9.212  22.587  1.00 19.84           C  
ATOM    751  O   LYS    91      11.983   8.683  23.701  1.00 20.14           O  
ATOM    752  CB  LYS    91       9.854   9.552  21.671  1.00 19.81           C  
ATOM    753  CG  LYS    91       9.830  11.072  21.577  1.00 20.93           C  
ATOM    754  CD  LYS    91       8.439  11.593  21.854  1.00 23.85           C  
ATOM    755  CE  LYS    91       8.249  13.016  21.413  1.00 30.64           C  
ATOM    756  NZ  LYS    91       6.944  13.499  21.917  1.00 34.58           N  
ATOM    757  N   THR    92      13.230   9.996  22.360  1.00 19.44           N  
ATOM    758  CA  THR    92      14.153  10.312  23.424  1.00 19.60           C  
ATOM    759  C   THR    92      13.562  11.349  24.389  1.00 18.84           C  
ATOM    760  O   THR    92      12.549  11.999  24.103  1.00 18.25           O  
ATOM    761  CB  THR    92      15.444  10.856  22.895  1.00 19.73           C  
ATOM    762  OG1 THR    92      15.176  12.183  22.388  1.00 21.01           O  
ATOM    763  CG2 THR    92      16.053   9.941  21.791  1.00 19.35           C  
ATOM    764  N   GLU    93      14.205  11.539  25.548  0.50 20.13           N  
ATOM    766  CA  GLU    93      13.705  12.522  26.511  0.50 20.76           C  
ATOM    768  C   GLU    93      13.826  13.956  25.987  0.50 19.67           C  
ATOM    770  O   GLU    93      13.197  14.874  26.521  0.50 19.80           O  
ATOM    772  CB  GLU    93      14.469  12.430  27.835  0.50 21.32           C  
ATOM    774  CG  GLU    93      14.239  11.166  28.623  0.50 23.98           C  
ATOM    776  CD  GLU    93      15.125  11.081  29.854  0.50 24.53           C  
ATOM    778  OE1 GLU    93      15.518   9.957  30.231  0.50 30.98           O  
ATOM    780  OE2 GLU    93      15.430  12.143  30.451  0.50 29.16           O  
ATOM    782  N   LYS    94      14.686  14.166  25.000  1.00 19.01           N  
ATOM    783  CA  LYS    94      14.783  15.473  24.385  1.00 18.39           C  
ATOM    784  C   LYS    94      13.725  15.668  23.293  1.00 16.81           C  
ATOM    785  O   LYS    94      13.533  16.802  22.866  1.00 18.00           O  
ATOM    786  CB  LYS    94      16.183  15.730  23.832  1.00 19.18           C  
ATOM    787  CG  LYS    94      17.248  15.787  24.880  1.00 21.72           C  
ATOM    788  CD  LYS    94      18.600  15.805  24.281  1.00 23.57           C  
ATOM    789  CE  LYS    94      19.662  15.916  25.368  1.00 26.08           C  
ATOM    790  NZ  LYS    94      21.041  15.663  24.797  1.00 29.86           N  
ATOM    791  N   GLY    95      13.022  14.605  22.914  1.00 16.22           N  
ATOM    792  CA  GLY    95      11.841  14.750  22.040  1.00 16.18           C  
ATOM    793  C   GLY    95      11.987  14.255  20.618  1.00 16.84           C  
ATOM    794  O   GLY    95      11.006  14.237  19.886  1.00 17.83           O  
ATOM    795  N   SER    96      13.182  13.851  20.222  1.00 16.29           N  
ATOM    796  CA  SER    96      13.410  13.388  18.856  1.00 15.32           C  
ATOM    797  C   SER    96      13.264  11.874  18.837  1.00 16.22           C  
ATOM    798  O   SER    96      13.576  11.174  19.825  1.00 15.94           O  
ATOM    799  CB  SER    96      14.825  13.781  18.368  1.00 15.41           C  
ATOM    800  OG  SER    96      15.042  15.172  18.223  1.00 17.04           O  
ATOM    801  N   TRP    97      12.799  11.328  17.709  1.00 15.27           N  
ATOM    802  CA  TRP    97      12.673   9.906  17.534  1.00 15.15           C  
ATOM    803  C   TRP    97      13.984   9.306  17.090  1.00 15.23           C  
ATOM    804  O   TRP    97      14.751   9.940  16.370  1.00 15.34           O  
ATOM    805  CB  TRP    97      11.574   9.586  16.500  1.00 16.75           C  
ATOM    806  CG  TRP    97      10.188   9.910  17.049  1.00 17.02           C  
ATOM    807  CD1 TRP    97       9.539  11.094  16.962  1.00 19.56           C  
ATOM    808  CD2 TRP    97       9.317   9.038  17.788  1.00 17.19           C  
ATOM    809  NE1 TRP    97       8.330  11.038  17.621  1.00 18.92           N  
ATOM    810  CE2 TRP    97       8.159   9.773  18.106  1.00 19.29           C  
ATOM    811  CE3 TRP    97       9.412   7.721  18.226  1.00 18.37           C  
ATOM    812  CZ2 TRP    97       7.109   9.234  18.854  1.00 20.16           C  
ATOM    813  CZ3 TRP    97       8.337   7.178  18.931  1.00 17.75           C  
ATOM    814  CH2 TRP    97       7.222   7.945  19.254  1.00 19.63           C  
ATOM    815  N   GLN    98      14.221   8.054  17.494  1.00 15.53           N  
ATOM    816  CA  GLN    98      15.374   7.289  17.078  0.50 15.84           C  
ATOM    818  C   GLN    98      14.962   5.908  16.599  1.00 15.82           C  
ATOM    819  O   GLN    98      13.994   5.322  17.111  1.00 16.55           O  
ATOM    820  CB  GLN    98      16.352   7.171  18.259  0.50 16.46           C  
ATOM    822  CG  GLN    98      15.755   6.389  19.416  0.50 17.45           C  
ATOM    824  CD  GLN    98      16.493   6.471  20.731  0.50 18.58           C  
ATOM    826  OE1 GLN    98      15.872   6.257  21.781  0.50 19.21           O  
ATOM    828  NE2 GLN    98      17.791   6.726  20.694  0.50 20.26           N  
ATOM    830  N   ILE    99      15.703   5.374  15.626  1.00 15.21           N  
ATOM    831  CA  ILE    99      15.526   3.998  15.150  1.00 15.51           C  
ATOM    832  C   ILE    99      16.314   3.078  16.081  1.00 16.61           C  
ATOM    833  O   ILE    99      17.548   3.215  16.279  1.00 16.58           O  
ATOM    834  CB  ILE    99      15.998   3.819  13.727  1.00 16.25           C  
ATOM    835  CG1 ILE    99      15.225   4.730  12.764  1.00 16.91           C  
ATOM    836  CG2 ILE    99      15.907   2.332  13.370  1.00 18.24           C  
ATOM    837  CD1 ILE    99      15.645   4.639  11.292  1.00 16.52           C  
ATOM    838  N   VAL   100      15.562   2.173  16.680  1.00 17.39           N  
ATOM    839  CA  VAL   100      16.095   1.202  17.630  1.00 18.63           C  
ATOM    840  C   VAL   100      15.672  -0.230  17.234  1.00 19.15           C  
ATOM    841  O   VAL   100      15.194  -0.468  16.147  1.00 17.97           O  
ATOM    842  CB  VAL   100      15.581   1.541  19.043  1.00 18.73           C  
ATOM    843  CG1 VAL   100      16.085   2.916  19.465  1.00 18.33           C  
ATOM    844  CG2 VAL   100      14.053   1.456  19.153  1.00 21.54           C  
ATOM    845  N   GLN   101      15.841  -1.182  18.141  1.00 21.54           N  
ATOM    846  CA  GLN   101      15.350  -2.538  17.848  1.00 22.47           C  
ATOM    847  C   GLN   101      14.877  -3.189  19.126  1.00 23.43           C  
ATOM    848  O   GLN   101      15.243  -2.736  20.207  1.00 23.82           O  
ATOM    849  CB  GLN   101      16.395  -3.345  17.139  1.00 23.76           C  
ATOM    850  CG  GLN   101      17.643  -3.604  17.930  1.00 23.42           C  
ATOM    851  CD  GLN   101      18.756  -4.193  17.109  1.00 24.69           C  
ATOM    852  OE1 GLN   101      18.587  -4.586  15.951  1.00 25.77           O  
ATOM    853  NE2 GLN   101      19.941  -4.248  17.713  1.00 30.47           N  
ATOM    854  N   LEU   102      14.003  -4.177  19.000  1.00 25.80           N  
ATOM    855  CA  LEU   102      13.433  -4.833  20.175  1.00 29.29           C  
ATOM    856  C   LEU   102      14.548  -5.593  20.875  1.00 30.90           C  
ATOM    857  O   LEU   102      15.441  -6.127  20.212  1.00 30.78           O  
ATOM    858  CB  LEU   102      12.266  -5.755  19.791  1.00 29.31           C  
ATOM    859  CG  LEU   102      10.972  -5.020  19.413  1.00 30.58           C  
ATOM    860  CD1 LEU   102       9.988  -5.946  18.738  1.00 31.16           C  
ATOM    861  CD2 LEU   102      10.360  -4.260  20.587  1.00 31.70           C  
ATOM    862  N   PRO   103      14.502  -5.653  22.228  1.00 32.79           N  
ATOM    863  CA  PRO   103      15.587  -6.344  22.947  1.00 33.77           C  
ATOM    864  C   PRO   103      15.589  -7.835  22.604  1.00 35.69           C  
ATOM    865  O   PRO   103      14.522  -8.422  22.400  1.00 36.77           O  
ATOM    866  CB  PRO   103      15.235  -6.128  24.423  1.00 34.74           C  
ATOM    867  CG  PRO   103      13.758  -5.776  24.444  1.00 34.13           C  
ATOM    868  CD  PRO   103      13.465  -5.114  23.135  1.00 33.44           C  
ATOM    869  OXT PRO   103      16.642  -8.473  22.459  1.00 37.09           O  
END
