
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  132 (  998),  selected  132 , name 2hhg_A
# Molecule2: number of CA atoms  120 (  935),  selected  120 , name T0411.pdb
# PARAMETERS: 2hhg_A.T0411.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    P     2_A      -       -           -
LGA    Q     3_A      -       -           -
LGA    T     4_A      -       -           -
LGA    I     5_A      -       -           -
LGA    T     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    G     8_A      -       -           -
LGA    I     9_A      -       -           -
LGA    K    10_A      -       -           -
LGA    A    11_A      -       -           -
LGA    X    12_A      -       -           -
LGA    L    13_A      -       -           -
LGA    D    14_A      -       -           -
LGA    E    15_A      -       -           -
LGA    A    16_A      -       -           -
LGA    N    17_A      -       -           -
LGA    S    18_A      -       -           -
LGA    S    19_A      S      20           #
LGA    -       -      N      21           -
LGA    I    20_A      I      22          2.568
LGA    E    21_A      Q      23          2.193
LGA    T    22_A      S      24          1.941
LGA    L    23_A      Y      25          1.709
LGA    T    24_A      S      26          1.684
LGA    T    25_A      F      27          2.088
LGA    A    26_A      E      28          1.515
LGA    D    27_A      D      29          0.575
LGA    A    28_A      M      30          1.360
LGA    I    29_A      K      31          1.604
LGA    A    30_A      R      32          0.941
LGA    L    31_A      I      33          0.424
LGA    H    32_A      V      34          0.413
LGA    K    33_A      G      35          0.926
LGA    S    34_A      K      36          1.346
LGA    G    35_A      H      37          1.204
LGA    A    36_A      D      38          2.873
LGA    S    37_A      P      39          3.088
LGA    D    38_A      N      40          0.928
LGA    V    39_A      V      41          0.257
LGA    V    40_A      V      42          0.673
LGA    I    41_A      L      43          0.520
LGA    V    42_A      V      44          1.075
LGA    D    43_A      D      45          1.146
LGA    I    44_A      V      46          0.668
LGA    R    45_A      R      47          0.526
LGA    D    46_A      E      48          0.720
LGA    P    47_A      P      49          1.268
LGA    R    48_A      S      50          1.639
LGA    E    49_A      E      51          1.353
LGA    I    50_A      Y      52          1.787
LGA    E    51_A      S      53          2.583
LGA    R    52_A      I      54          2.980
LGA    D    53_A      -       -           -
LGA    G    54_A      V      55          0.593
LGA    K    55_A      H      56          0.401
LGA    I    56_A      I      57          0.512
LGA    P    57_A      P      58          0.421
LGA    G    58_A      A      59          0.648
LGA    S    59_A      S      60          0.683
LGA    F    60_A      I      61          0.803
LGA    S    61_A      N      62          1.059
LGA    C    62_A      V      63          0.956
LGA    T    63_A      P      64          0.756
LGA    R    64_A      Y      65          1.202
LGA    -       -      R      66           -
LGA    G    65_A      S      67          3.907
LGA    X    66_A      H      68          2.157
LGA    -       -      P      69           -
LGA    -       -      D      70           -
LGA    L    67_A      A      71          1.841
LGA    E    68_A      F      72          2.951
LGA    F    69_A      A      73          5.007
LGA    W    70_A      L      74          4.442
LGA    I    71_A      -       -           -
LGA    D    72_A      D      75          2.809
LGA    P    73_A      P      76          3.348
LGA    Q    74_A      -       -           -
LGA    S    75_A      -       -           -
LGA    P    76_A      L      77          4.629
LGA    Y    77_A      E      78          1.401
LGA    A    78_A      F      79          2.620
LGA    K    79_A      E      80          3.883
LGA    -       -      K      81           -
LGA    -       -      Q      82           -
LGA    -       -      I      83           -
LGA    -       -      G      84           -
LGA    -       -      I      85           -
LGA    P    80_A      P      86          3.927
LGA    I    81_A      K      87          3.691
LGA    F    82_A      P      88          1.872
LGA    Q    83_A      D      89          2.744
LGA    E    84_A      S      90          4.673
LGA    D    85_A      A      91          2.162
LGA    K    86_A      K      92          0.910
LGA    K    87_A      E      93          0.373
LGA    F    88_A      L      94          0.439
LGA    V    89_A      I      95          0.724
LGA    F    90_A      F      96          1.221
LGA    Y    91_A      Y      97          1.417
LGA    C    92_A      C      98          0.307
LGA    A    93_A      A      99          0.411
LGA    G    94_A      S     100          0.872
LGA    G    95_A      G     101          1.245
LGA    L    96_A      K     102          1.377
LGA    R    97_A      R     103          0.863
LGA    S    98_A      G     104          0.367
LGA    A    99_A      G     105          0.955
LGA    L   100_A      E     106          1.221
LGA    A   101_A      A     107          0.824
LGA    A   102_A      Q     108          0.634
LGA    K   103_A      K     109          1.389
LGA    T   104_A      V     110          1.403
LGA    A   105_A      A     111          0.644
LGA    Q   106_A      S     112          0.375
LGA    D   107_A      S     113          1.113
LGA    X   108_A      H     114          1.170
LGA    G   109_A      G     115          1.832
LGA    L   110_A      Y     116          0.680
LGA    K   111_A      S     117          1.897
LGA    P   112_A      N     118          0.337
LGA    V   113_A      T     119          0.497
LGA    A   114_A      S     120          0.919
LGA    H   115_A      L     121          1.540
LGA    I   116_A      Y     122          0.607
LGA    E   117_A      P     123          1.965
LGA    G   118_A      G     124          1.091
LGA    G   119_A      S     125          0.647
LGA    F   120_A      M     126          0.304
LGA    G   121_A      N     127          0.663
LGA    A   122_A      D     128          0.290
LGA    W   123_A      W     129          0.741
LGA    R   124_A      V     130          1.035
LGA    D   125_A      S     131          1.271
LGA    A   126_A      H     132          1.466
LGA    G   127_A      G     133          1.691
LGA    G   128_A      G     134          1.528
LGA    P   129_A      D     135          4.228
LGA    I   130_A      K     136           #
LGA    E   131_A      L     137           -
LGA    -       -      D     138           -
LGA    -       -      L     139           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  132  120    5.0    106    1.86    28.30     80.022     5.406

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.388742 * X  +  -0.518500 * Y  +   0.761602 * Z  +   9.334343
  Y_new =  -0.459160 * X  +  -0.825680 * Y  +  -0.327757 * Z  +  29.099262
  Z_new =   0.798782 * X  +  -0.222284 * Y  +  -0.559050 * Z  +  15.790737 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.763148    0.378445  [ DEG:  -158.3167     21.6833 ]
  Theta =  -0.925268   -2.216325  [ DEG:   -53.0139   -126.9861 ]
  Phi   =  -0.868258    2.273335  [ DEG:   -49.7475    130.2525 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hhg_A                                        
REMARK     2: T0411.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hhg_A.T0411.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  132  120   5.0  106   1.86   28.30  80.022
REMARK  ---------------------------------------------------------- 
MOLECULE 2hhg_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   28-JUN-06   2HHG              
TITLE     STRUCTURE OF PROTEIN OF UNKNOWN FUNCTION RPA3614, POSSIBLE            
TITLE    2 TYROSINE PHOSPHATASE, FROM RHODOPSEUDOMONAS PALUSTRIS                
TITLE    3 CGA009                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN RPA3614;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHODOPSEUDOMONAS PALUSTRIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: CGA009;                                                      
SOURCE   5 GENE: RPA3614;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    MCSG, STRUCTURAL GENOMICS, HYPOTHETICAL PROTEIN,                      
KEYWDS   2 ROHOPSEUDOMONAS PALUSTRIS, PSI-2, PROTEIN STRUCTURE                  
KEYWDS   3 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.A.BINKOWSKI,E.EVDOKIMOVA,A.SACHECKO,A.EDWARDS,                      
AUTHOR   2 A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   1   25-JUL-06 2HHG    0                                                
JRNL        AUTH   T.A.BINKOWSKI,E.EVDOKIMOVA,A.SACHECKO,A.EDWARDS,             
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   HYPOTHETICAL PROTEIN RPA3614 FROM RHODOPSEUDOMONAS           
JRNL        TITL 2 PALUSTRIS CGA009                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.20 ANGSTROMS.                                          
DBREF  2HHG A    1   138  UNP    Q6N3S9   Q6N3S9_RHOPA     1    138             
SEQRES   1 A  139  GLY MSE PRO GLN THR ILE THR ARG GLY ILE LYS ALA MSE          
SEQRES   2 A  139  LEU ASP GLU ALA ASN SER SER ILE GLU THR LEU THR THR          
SEQRES   3 A  139  ALA ASP ALA ILE ALA LEU HIS LYS SER GLY ALA SER ASP          
SEQRES   4 A  139  VAL VAL ILE VAL ASP ILE ARG ASP PRO ARG GLU ILE GLU          
SEQRES   5 A  139  ARG ASP GLY LYS ILE PRO GLY SER PHE SER CYS THR ARG          
SEQRES   6 A  139  GLY MSE LEU GLU PHE TRP ILE ASP PRO GLN SER PRO TYR          
SEQRES   7 A  139  ALA LYS PRO ILE PHE GLN GLU ASP LYS LYS PHE VAL PHE          
SEQRES   8 A  139  TYR CYS ALA GLY GLY LEU ARG SER ALA LEU ALA ALA LYS          
SEQRES   9 A  139  THR ALA GLN ASP MSE GLY LEU LYS PRO VAL ALA HIS ILE          
SEQRES  10 A  139  GLU GLY GLY PHE GLY ALA TRP ARG ASP ALA GLY GLY PRO          
SEQRES  11 A  139  ILE GLU ALA TRP ALA PRO LYS LYS LYS                          
HET    MSE  A   1       8                                                       
HET    MSE  A  12       8                                                       
HET    MSE  A  66       8                                                       
HET    MSE  A 108       8                                                       
HET    PO4   4285       5                                                       
HET     NA      1       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM      NA SODIUM ION                                                       
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2  PO4    O4 P 3-                                                      
FORMUL   3   NA    NA 1+                                                        
FORMUL   4  HOH   *168(H2 O)                                                    
CRYST1   66.118   42.505   42.251  90.00 105.19  90.00 C 1 2 1       4          
ATOM      1  N   GLY A   0     -15.236  30.345  -7.375  1.00 17.18           N  
ATOM      2  CA  GLY A   0     -14.784  31.177  -6.292  1.00 16.20           C  
ATOM      3  C   GLY A   0     -13.249  31.106  -6.192  1.00 15.55           C  
ATOM      4  O   GLY A   0     -12.645  30.367  -6.890  1.00 15.17           O  
HETATM    5  N   MSE A   1     -12.656  31.944  -5.363  1.00 20.00           N  
HETATM    6  CA  MSE A   1     -11.196  31.972  -5.250  1.00 20.00           C  
HETATM    7  C   MSE A   1     -10.753  30.745  -4.498  1.00 20.00           C  
HETATM    8  O   MSE A   1     -11.334  30.404  -3.507  1.00 14.81           O  
HETATM    9  CB  MSE A   1     -10.724  33.194  -4.438  1.00 20.00           C  
HETATM   10  CG  MSE A   1     -11.040  34.586  -5.098  1.00 20.00           C  
HETATM   11 SE   MSE A   1      -9.831  34.786  -6.604  1.00 20.00          SE  
HETATM   12  CE  MSE A   1      -8.116  34.905  -5.636  1.00 20.00           C  
ATOM     13  N   PRO A   2      -9.685  30.113  -4.923  1.00 13.32           N  
ATOM     14  CA  PRO A   2      -9.259  28.868  -4.300  1.00 13.32           C  
ATOM     15  C   PRO A   2      -8.562  29.177  -2.973  1.00 12.80           C  
ATOM     16  O   PRO A   2      -8.222  30.292  -2.672  1.00 13.23           O  
ATOM     17  CB  PRO A   2      -8.326  28.303  -5.307  1.00 13.61           C  
ATOM     18  CG  PRO A   2      -7.709  29.475  -5.976  1.00 13.13           C  
ATOM     19  CD  PRO A   2      -8.850  30.470  -6.069  1.00 13.23           C  
ATOM     20  N   GLN A   3      -8.391  28.127  -2.200  1.00 12.03           N  
ATOM     21  CA  GLN A   3      -7.585  28.209  -1.002  1.00 11.20           C  
ATOM     22  C   GLN A   3      -6.156  28.512  -1.395  1.00 11.33           C  
ATOM     23  O   GLN A   3      -5.678  28.031  -2.429  1.00 12.34           O  
ATOM     24  CB  GLN A   3      -7.631  26.876  -0.266  1.00 10.58           C  
ATOM     25  CG  GLN A   3      -8.999  26.538   0.292  1.00  9.35           C  
ATOM     26  CD  GLN A   3      -9.316  27.316   1.560  1.00  8.87           C  
ATOM     27  OE1 GLN A   3      -8.419  27.778   2.275  1.00  9.31           O  
ATOM     28  NE2 GLN A   3     -10.598  27.448   1.851  1.00 10.09           N  
ATOM     29  N   THR A   4      -5.475  29.302  -0.574  1.00 11.52           N  
ATOM     30  CA  THR A   4      -4.090  29.634  -0.848  0.50 12.25           C  
ATOM     32  C   THR A   4      -3.172  28.995   0.191  1.00 12.05           C  
ATOM     33  O   THR A   4      -3.146  29.376   1.363  1.00 12.29           O  
ATOM     34  CB  THR A   4      -3.888  31.164  -1.038  0.50 12.62           C  
ATOM     36  OG1 THR A   4      -2.503  31.512  -0.922  0.50 13.06           O  
ATOM     38  CG2 THR A   4      -4.710  31.945  -0.039  0.50 13.89           C  
ATOM     40  N   ILE A   5      -2.442  27.991  -0.260  1.00 11.63           N  
ATOM     41  CA  ILE A   5      -1.546  27.278   0.608  1.00 11.92           C  
ATOM     42  C   ILE A   5      -0.196  27.972   0.523  1.00 11.71           C  
ATOM     43  O   ILE A   5       0.383  28.131  -0.560  1.00 12.56           O  
ATOM     44  CB  ILE A   5      -1.486  25.771   0.255  1.00 12.06           C  
ATOM     45  CG1 ILE A   5      -2.883  25.132   0.405  1.00 12.03           C  
ATOM     46  CG2 ILE A   5      -0.424  25.052   1.083  1.00 12.64           C  
ATOM     47  CD1 ILE A   5      -3.581  25.377   1.750  1.00 11.88           C  
ATOM     48  N   THR A   6       0.272  28.420   1.679  1.00 11.26           N  
ATOM     49  CA  THR A   6       1.518  29.163   1.780  1.00 11.66           C  
ATOM     50  C   THR A   6       2.640  28.367   2.450  1.00 11.89           C  
ATOM     51  O   THR A   6       3.803  28.764   2.387  1.00 12.78           O  
ATOM     52  CB  THR A   6       1.281  30.492   2.497  1.00 11.52           C  
ATOM     53  OG1 THR A   6       0.463  30.264   3.652  1.00 12.09           O  
ATOM     54  CG2 THR A   6       0.559  31.460   1.557  1.00 12.53           C  
ATOM     55  N   ARG A   7       2.289  27.245   3.077  1.00 11.51           N  
ATOM     56  CA  ARG A   7       3.262  26.308   3.637  1.00 11.73           C  
ATOM     57  C   ARG A   7       2.812  24.912   3.249  1.00 11.53           C  
ATOM     58  O   ARG A   7       1.791  24.414   3.734  1.00 11.65           O  
ATOM     59  CB  ARG A   7       3.356  26.450   5.155  1.00 12.18           C  
ATOM     60  CG  ARG A   7       4.233  25.406   5.838  1.00 13.69           C  
ATOM     61  CD  ARG A   7       4.326  25.679   7.331  1.00 15.41           C  
ATOM     62  NE  ARG A   7       4.927  24.566   8.064  1.00 16.07           N  
ATOM     63  CZ  ARG A   7       6.235  24.345   8.164  1.00 16.23           C  
ATOM     64  NH1 ARG A   7       7.105  25.153   7.568  1.00 16.42           N  
ATOM     65  NH2 ARG A   7       6.676  23.304   8.861  1.00 17.69           N  
ATOM     66  N   GLY A   8       3.559  24.298   2.343  1.00 10.92           N  
ATOM     67  CA  GLY A   8       3.185  23.003   1.806  1.00 11.28           C  
ATOM     68  C   GLY A   8       4.131  21.901   2.224  1.00 10.65           C  
ATOM     69  O   GLY A   8       5.028  22.099   3.059  1.00 11.18           O  
ATOM     70  N   ILE A   9       3.939  20.727   1.634  1.00 10.45           N  
ATOM     71  CA  ILE A   9       4.756  19.576   2.000  1.00 10.13           C  
ATOM     72  C   ILE A   9       6.230  19.761   1.649  1.00 10.09           C  
ATOM     73  O   ILE A   9       7.092  19.223   2.344  1.00  9.74           O  
ATOM     74  CB  ILE A   9       4.210  18.233   1.443  1.00 10.06           C  
ATOM     75  CG1 ILE A   9       4.287  18.192  -0.087  1.00 11.06           C  
ATOM     76  CG2 ILE A   9       2.793  17.960   1.970  1.00 11.08           C  
ATOM     77  CD1 ILE A   9       4.082  16.801  -0.684  1.00 12.78           C  
ATOM     78  N   LYS A  10       6.527  20.536   0.608  1.00 10.25           N  
ATOM     79  CA  LYS A  10       7.923  20.777   0.253  1.00 11.47           C  
ATOM     80  C   LYS A  10       8.690  21.401   1.425  1.00 11.51           C  
ATOM     81  O   LYS A  10       9.758  20.912   1.798  1.00 11.74           O  
ATOM     82  CB  LYS A  10       8.022  21.644  -1.001  1.00 11.96           C  
ATOM     83  CG  LYS A  10       9.444  21.830  -1.501  1.00 14.86           C  
ATOM     84  CD  LYS A  10       9.479  22.631  -2.793  1.00 18.39           C  
ATOM     85  CE  LYS A  10      10.858  22.600  -3.425  1.00 19.52           C  
ATOM     86  NZ  LYS A  10      11.891  23.112  -2.491  1.00 22.02           N  
ATOM     87  N   ALA A  11       8.130  22.456   2.014  1.00 11.50           N  
ATOM     88  CA  ALA A  11       8.743  23.110   3.170  1.00 11.53           C  
ATOM     89  C   ALA A  11       8.840  22.168   4.364  1.00 11.31           C  
ATOM     90  O   ALA A  11       9.874  22.099   5.025  1.00 11.36           O  
ATOM     91  CB  ALA A  11       7.971  24.363   3.552  1.00 12.15           C  
HETATM   92  N   MSE A  12       7.761  21.444   4.633  1.00 10.68           N  
HETATM   93  CA  MSE A  12       7.727  20.526   5.771  1.00 10.30           C  
HETATM   94  C   MSE A  12       8.737  19.400   5.638  1.00 10.19           C  
HETATM   95  O   MSE A  12       9.396  19.035   6.615  1.00 10.35           O  
HETATM   96  CB  MSE A  12       6.339  19.931   5.956  1.00 10.75           C  
HETATM   97  CG  MSE A  12       5.269  20.947   6.262  1.00 12.26           C  
HETATM   98 SE   MSE A  12       3.570  20.053   6.217  1.00 21.50          SE  
HETATM   99  CE  MSE A  12       2.466  21.614   5.960  1.00 20.25           C  
ATOM    100  N   LEU A  13       8.845  18.850   4.432  1.00  9.82           N  
ATOM    101  CA  LEU A  13       9.754  17.744   4.163  1.00 10.36           C  
ATOM    102  C   LEU A  13      11.215  18.176   4.215  1.00 11.59           C  
ATOM    103  O   LEU A  13      12.062  17.434   4.722  1.00 11.68           O  
ATOM    104  CB  LEU A  13       9.416  17.079   2.829  1.00 10.41           C  
ATOM    105  CG  LEU A  13       8.132  16.243   2.837  1.00  9.94           C  
ATOM    106  CD1 LEU A  13       7.684  15.936   1.421  1.00 10.80           C  
ATOM    107  CD2 LEU A  13       8.303  14.955   3.646  1.00 10.46           C  
ATOM    108  N   ASP A  14      11.506  19.376   3.710  1.00 12.45           N  
ATOM    109  CA  ASP A  14      12.856  19.927   3.778  0.50 13.15           C  
ATOM    111  C   ASP A  14      13.299  20.048   5.231  1.00 13.13           C  
ATOM    112  O   ASP A  14      14.398  19.609   5.595  1.00 13.78           O  
ATOM    113  CB  ASP A  14      12.927  21.296   3.096  0.50 13.68           C  
ATOM    115  CG  ASP A  14      14.270  21.978   3.302  0.50 14.78           C  
ATOM    117  OD1 ASP A  14      15.304  21.377   2.945  0.50 15.96           O  
ATOM    119  OD2 ASP A  14      14.291  23.107   3.832  0.50 16.77           O  
ATOM    121  N   GLU A  15      12.436  20.636   6.059  1.00 12.91           N  
ATOM    122  CA  GLU A  15      12.708  20.803   7.485  1.00 12.85           C  
ATOM    123  C   GLU A  15      12.934  19.462   8.178  1.00 12.16           C  
ATOM    124  O   GLU A  15      13.838  19.329   9.007  1.00 12.49           O  
ATOM    125  CB  GLU A  15      11.554  21.530   8.176  1.00 13.46           C  
ATOM    126  CG  GLU A  15      11.447  23.015   7.870  1.00 15.78           C  
ATOM    127  CD  GLU A  15      10.174  23.644   8.424  1.00 17.93           C  
ATOM    128  OE1 GLU A  15       9.514  23.031   9.290  1.00 19.12           O  
ATOM    129  OE2 GLU A  15       9.829  24.759   7.986  1.00 20.80           O  
ATOM    130  N   ALA A  16      12.104  18.478   7.841  1.00 11.24           N  
ATOM    131  CA  ALA A  16      12.216  17.153   8.430  1.00 11.05           C  
ATOM    132  C   ALA A  16      13.490  16.448   7.975  1.00 11.43           C  
ATOM    133  O   ALA A  16      14.290  16.007   8.807  1.00 10.77           O  
ATOM    134  CB  ALA A  16      10.989  16.321   8.096  1.00 10.70           C  
ATOM    135  N   ASN A  17      13.676  16.357   6.659  1.00 12.36           N  
ATOM    136  CA  ASN A  17      14.826  15.656   6.090  1.00 13.50           C  
ATOM    137  C   ASN A  17      16.166  16.123   6.636  1.00 13.66           C  
ATOM    138  O   ASN A  17      17.042  15.298   6.919  1.00 14.14           O  
ATOM    139  CB  ASN A  17      14.825  15.751   4.567  1.00 14.05           C  
ATOM    140  CG  ASN A  17      13.801  14.846   3.929  1.00 16.49           C  
ATOM    141  OD1 ASN A  17      13.523  13.754   4.424  1.00 20.85           O  
ATOM    142  ND2 ASN A  17      13.242  15.288   2.810  1.00 17.24           N  
ATOM    143  N   SER A  18      16.326  17.430   6.800  1.00 13.71           N  
ATOM    144  CA  SER A  18      17.604  17.990   7.233  1.00 13.79           C  
ATOM    145  C   SER A  18      17.860  17.841   8.734  1.00 13.01           C  
ATOM    146  O   SER A  18      18.953  18.145   9.216  1.00 13.01           O  
ATOM    147  CB  SER A  18      17.709  19.457   6.817  1.00 15.03           C  
ATOM    148  OG  SER A  18      16.765  20.237   7.516  1.00 16.75           O  
ATOM    149  N   SER A  19      16.851  17.366   9.462  1.00 11.68           N  
ATOM    150  CA  SER A  19      16.916  17.215  10.913  1.00 11.34           C  
ATOM    151  C   SER A  19      16.973  15.753  11.358  1.00 10.01           C  
ATOM    152  O   SER A  19      17.257  15.482  12.524  1.00  9.65           O  
ATOM    153  CB  SER A  19      15.694  17.879  11.562  1.00 12.23           C  
ATOM    154  OG  SER A  19      15.731  19.291  11.432  1.00 16.07           O  
ATOM    155  N   ILE A  20      16.676  14.824  10.450  1.00  9.18           N  
ATOM    156  CA  ILE A  20      16.546  13.416  10.817  1.00  8.71           C  
ATOM    157  C   ILE A  20      17.485  12.495  10.046  1.00  9.01           C  
ATOM    158  O   ILE A  20      17.995  12.853   8.988  1.00  9.11           O  
ATOM    159  CB  ILE A  20      15.086  12.911  10.629  1.00  8.55           C  
ATOM    160  CG1 ILE A  20      14.740  12.827   9.133  1.00  9.83           C  
ATOM    161  CG2 ILE A  20      14.103  13.784  11.414  1.00  8.97           C  
ATOM    162  CD1 ILE A  20      13.325  12.348   8.840  1.00  9.93           C  
ATOM    163  N   GLU A  21      17.686  11.302  10.594  1.00  8.83           N  
ATOM    164  CA  GLU A  21      18.385  10.236   9.896  1.00  9.25           C  
ATOM    165  C   GLU A  21      17.486   9.605   8.844  1.00  8.98           C  
ATOM    166  O   GLU A  21      16.425   9.046   9.170  1.00  8.71           O  
ATOM    167  CB  GLU A  21      18.844   9.164  10.884  1.00  9.37           C  
ATOM    168  CG  GLU A  21      19.468   7.952  10.189  1.00  8.92           C  
ATOM    169  CD  GLU A  21      19.901   6.837  11.127  1.00  9.67           C  
ATOM    170  OE1 GLU A  21      19.824   7.001  12.359  1.00 11.02           O  
ATOM    171  OE2 GLU A  21      20.335   5.788  10.611  1.00 11.24           O  
ATOM    172  N   THR A  22      17.914   9.680   7.588  1.00  9.43           N  
ATOM    173  CA  THR A  22      17.300   8.891   6.535  1.00 10.79           C  
ATOM    174  C   THR A  22      18.155   7.653   6.348  1.00 10.45           C  
ATOM    175  O   THR A  22      19.308   7.711   5.891  1.00 10.49           O  
ATOM    176  CB  THR A  22      17.141   9.664   5.214  1.00 11.30           C  
ATOM    177  OG1 THR A  22      16.255  10.767   5.424  1.00 14.04           O  
ATOM    178  CG2 THR A  22      16.537   8.768   4.137  1.00 13.37           C  
ATOM    179  N   LEU A  23      17.583   6.533   6.746  1.00 10.61           N  
ATOM    180  CA  LEU A  23      18.239   5.256   6.664  1.00 11.26           C  
ATOM    181  C   LEU A  23      17.994   4.710   5.261  1.00 10.98           C  
ATOM    182  O   LEU A  23      16.846   4.633   4.825  1.00 11.28           O  
ATOM    183  CB  LEU A  23      17.613   4.366   7.735  1.00 11.87           C  
ATOM    184  CG  LEU A  23      18.116   2.974   8.058  1.00 12.69           C  
ATOM    185  CD1 LEU A  23      19.570   2.989   8.501  1.00 11.46           C  
ATOM    186  CD2 LEU A  23      17.225   2.396   9.147  1.00 13.68           C  
ATOM    187  N   THR A  24      19.057   4.349   4.537  1.00 11.22           N  
ATOM    188  CA  THR A  24      18.868   3.787   3.193  1.00 11.39           C  
ATOM    189  C   THR A  24      18.066   2.494   3.276  1.00 10.95           C  
ATOM    190  O   THR A  24      18.071   1.808   4.303  1.00 10.05           O  
ATOM    191  CB  THR A  24      20.188   3.494   2.446  1.00 11.90           C  
ATOM    192  OG1 THR A  24      20.880   2.418   3.085  1.00 12.08           O  
ATOM    193  CG2 THR A  24      21.080   4.727   2.378  1.00 13.12           C  
ATOM    194  N   THR A  25      17.370   2.169   2.197  1.00 10.89           N  
ATOM    195  CA  THR A  25      16.579   0.954   2.162  1.00 11.57           C  
ATOM    196  C   THR A  25      17.456  -0.262   2.464  1.00 10.92           C  
ATOM    197  O   THR A  25      17.073  -1.121   3.262  1.00 10.67           O  
ATOM    198  CB  THR A  25      15.874   0.800   0.812  1.00 11.80           C  
ATOM    199  OG1 THR A  25      15.359   2.074   0.402  1.00 13.36           O  
ATOM    200  CG2 THR A  25      14.742  -0.192   0.921  1.00 13.18           C  
ATOM    201  N   ALA A  26      18.650  -0.306   1.870  1.00 11.00           N  
ATOM    202  CA  ALA A  26      19.557  -1.433   2.056  1.00 10.98           C  
ATOM    203  C   ALA A  26      20.028  -1.542   3.506  1.00 10.52           C  
ATOM    204  O   ALA A  26      20.095  -2.637   4.061  1.00 10.45           O  
ATOM    205  CB  ALA A  26      20.744  -1.334   1.111  1.00 11.58           C  
ATOM    206  N   ASP A  27      20.340  -0.406   4.125  1.00 10.01           N  
ATOM    207  CA  ASP A  27      20.750  -0.413   5.524  1.00  9.94           C  
ATOM    208  C   ASP A  27      19.617  -0.854   6.454  1.00  8.91           C  
ATOM    209  O   ASP A  27      19.844  -1.582   7.416  1.00  8.96           O  
ATOM    210  CB  ASP A  27      21.271   0.958   5.954  1.00 10.26           C  
ATOM    211  CG  ASP A  27      22.625   1.286   5.361  1.00 12.28           C  
ATOM    212  OD1 ASP A  27      23.268   0.391   4.771  1.00 15.40           O  
ATOM    213  OD2 ASP A  27      23.047   2.454   5.489  1.00 13.25           O  
ATOM    214  N   ALA A  28      18.398  -0.409   6.158  1.00  8.40           N  
ATOM    215  CA  ALA A  28      17.233  -0.809   6.945  1.00  7.94           C  
ATOM    216  C   ALA A  28      16.962  -2.315   6.834  1.00  8.01           C  
ATOM    217  O   ALA A  28      16.654  -2.976   7.826  1.00  7.70           O  
ATOM    218  CB  ALA A  28      16.015  -0.005   6.527  1.00  8.23           C  
ATOM    219  N   ILE A  29      17.091  -2.848   5.622  1.00  8.56           N  
ATOM    220  CA  ILE A  29      16.930  -4.280   5.402  1.00  8.83           C  
ATOM    221  C   ILE A  29      18.002  -5.064   6.177  1.00  8.63           C  
ATOM    222  O   ILE A  29      17.691  -6.053   6.855  1.00  8.44           O  
ATOM    223  CB  ILE A  29      16.918  -4.620   3.892  1.00  8.68           C  
ATOM    224  CG1 ILE A  29      15.627  -4.080   3.261  1.00  9.21           C  
ATOM    225  CG2 ILE A  29      17.057  -6.129   3.664  1.00  9.03           C  
ATOM    226  CD1 ILE A  29      15.589  -4.142   1.748  1.00 10.52           C  
ATOM    227  N   ALA A  30      19.251  -4.606   6.104  1.00  8.95           N  
ATOM    228  CA  ALA A  30      20.338  -5.265   6.831  1.00  9.46           C  
ATOM    229  C   ALA A  30      20.103  -5.214   8.336  1.00  9.31           C  
ATOM    230  O   ALA A  30      20.332  -6.195   9.036  1.00  9.46           O  
ATOM    231  CB  ALA A  30      21.688  -4.656   6.480  1.00 10.35           C  
ATOM    232  N   LEU A  31      19.624  -4.068   8.826  1.00  9.44           N  
ATOM    233  CA  LEU A  31      19.285  -3.907  10.238  1.00  9.59           C  
ATOM    234  C   LEU A  31      18.227  -4.925  10.668  1.00  9.03           C  
ATOM    235  O   LEU A  31      18.338  -5.558  11.717  1.00  9.27           O  
ATOM    236  CB  LEU A  31      18.793  -2.479  10.508  1.00 10.43           C  
ATOM    237  CG  LEU A  31      18.408  -2.124  11.949  1.00 11.35           C  
ATOM    238  CD1 LEU A  31      19.608  -2.260  12.879  1.00 13.29           C  
ATOM    239  CD2 LEU A  31      17.834  -0.715  12.017  1.00 12.80           C  
ATOM    240  N   HIS A  32      17.185  -5.063   9.858  1.00  8.43           N  
ATOM    241  CA  HIS A  32      16.121  -6.012  10.139  1.00  8.68           C  
ATOM    242  C   HIS A  32      16.645  -7.450  10.185  1.00  8.58           C  
ATOM    243  O   HIS A  32      16.313  -8.205  11.093  1.00  8.66           O  
ATOM    244  CB  HIS A  32      15.024  -5.873   9.092  1.00  8.59           C  
ATOM    245  CG  HIS A  32      13.813  -6.699   9.374  1.00  8.41           C  
ATOM    246  ND1 HIS A  32      13.698  -8.010   8.965  1.00  9.68           N  
ATOM    247  CD2 HIS A  32      12.660  -6.395  10.012  1.00 10.28           C  
ATOM    248  CE1 HIS A  32      12.523  -8.480   9.345  1.00 10.19           C  
ATOM    249  NE2 HIS A  32      11.871  -7.520   9.978  1.00 10.02           N  
ATOM    250  N   LYS A  33      17.466  -7.818   9.207  1.00  8.53           N  
ATOM    251  CA  LYS A  33      18.032  -9.165   9.151  1.00  9.71           C  
ATOM    252  C   LYS A  33      18.949  -9.487  10.332  1.00 10.30           C  
ATOM    253  O   LYS A  33      19.083 -10.651  10.718  1.00 10.15           O  
ATOM    254  CB  LYS A  33      18.756  -9.398   7.828  1.00  9.80           C  
ATOM    255  CG  LYS A  33      17.811  -9.447   6.643  1.00 10.17           C  
ATOM    256  CD  LYS A  33      18.580  -9.526   5.345  1.00 10.81           C  
ATOM    257  CE  LYS A  33      17.650  -9.618   4.154  1.00 11.69           C  
ATOM    258  NZ  LYS A  33      18.411  -9.602   2.877  1.00 12.48           N  
ATOM    259  N   SER A  34      19.559  -8.457  10.913  1.00 10.90           N  
ATOM    260  CA  SER A  34      20.453  -8.639  12.055  1.00 12.33           C  
ATOM    261  C   SER A  34      19.680  -8.966  13.336  1.00 13.44           C  
ATOM    262  O   SER A  34      20.281  -9.353  14.344  1.00 14.51           O  
ATOM    263  CB  SER A  34      21.336  -7.398  12.260  1.00 12.75           C  
ATOM    264  OG  SER A  34      20.607  -6.339  12.852  1.00 13.33           O  
ATOM    265  N   GLY A  35      18.359  -8.796  13.290  1.00 14.46           N  
ATOM    266  CA  GLY A  35      17.490  -9.015  14.445  1.00 15.94           C  
ATOM    267  C   GLY A  35      16.945  -7.716  15.015  1.00 17.10           C  
ATOM    268  O   GLY A  35      16.130  -7.734  15.942  1.00 17.79           O  
ATOM    269  N   ALA A  36      17.400  -6.591  14.457  1.00 18.15           N  
ATOM    270  CA  ALA A  36      16.987  -5.245  14.881  1.00 18.91           C  
ATOM    271  C   ALA A  36      17.014  -5.048  16.405  1.00 19.35           C  
ATOM    272  O   ALA A  36      16.058  -4.531  17.001  1.00 19.80           O  
ATOM    273  CB  ALA A  36      15.615  -4.887  14.293  1.00 19.13           C  
ATOM    274  N   SER A  37      18.120  -5.460  17.025  1.00 19.83           N  
ATOM    275  CA  SER A  37      18.306  -5.311  18.464  1.00 20.10           C  
ATOM    276  C   SER A  37      18.333  -3.836  18.850  1.00 19.52           C  
ATOM    277  O   SER A  37      18.996  -3.021  18.199  1.00 19.91           O  
ATOM    278  CB  SER A  37      19.580  -6.014  18.936  1.00 20.46           C  
ATOM    279  OG  SER A  37      19.446  -7.423  18.844  1.00 22.31           O  
ATOM    280  N   ASP A  38      17.592  -3.508  19.903  1.00 18.93           N  
ATOM    281  CA  ASP A  38      17.425  -2.125  20.366  1.00 18.12           C  
ATOM    282  C   ASP A  38      16.870  -1.193  19.277  1.00 16.72           C  
ATOM    283  O   ASP A  38      17.241  -0.017  19.198  1.00 16.03           O  
ATOM    284  CB  ASP A  38      18.732  -1.571  20.963  1.00 19.07           C  
ATOM    285  CG  ASP A  38      19.175  -2.322  22.211  1.00 20.92           C  
ATOM    286  OD1 ASP A  38      18.312  -2.690  23.039  1.00 22.92           O  
ATOM    287  OD2 ASP A  38      20.395  -2.539  22.362  1.00 24.31           O  
ATOM    288  N   VAL A  39      15.996  -1.739  18.434  1.00 15.00           N  
ATOM    289  CA  VAL A  39      15.303  -0.973  17.399  1.00 14.03           C  
ATOM    290  C   VAL A  39      13.824  -1.347  17.438  1.00 12.85           C  
ATOM    291  O   VAL A  39      13.477  -2.513  17.653  1.00 12.81           O  
ATOM    292  CB  VAL A  39      15.897  -1.247  15.977  1.00 14.62           C  
ATOM    293  CG1 VAL A  39      15.035  -0.625  14.877  1.00 15.13           C  
ATOM    294  CG2 VAL A  39      17.333  -0.731  15.874  1.00 15.77           C  
ATOM    295  N   VAL A  40      12.965  -0.344  17.267  1.00 11.31           N  
ATOM    296  CA  VAL A  40      11.544  -0.563  17.043  1.00 10.70           C  
ATOM    297  C   VAL A  40      11.229   0.029  15.675  1.00  9.83           C  
ATOM    298  O   VAL A  40      11.457   1.226  15.440  1.00  9.52           O  
ATOM    299  CB  VAL A  40      10.669   0.112  18.127  1.00 10.77           C  
ATOM    300  CG1 VAL A  40       9.185  -0.081  17.818  1.00 11.52           C  
ATOM    301  CG2 VAL A  40      11.000  -0.429  19.511  1.00 12.39           C  
ATOM    302  N   ILE A  41      10.730  -0.813  14.775  1.00  9.22           N  
ATOM    303  CA  ILE A  41      10.321  -0.368  13.451  1.00  9.01           C  
ATOM    304  C   ILE A  41       8.829  -0.082  13.505  1.00  8.78           C  
ATOM    305  O   ILE A  41       8.040  -0.959  13.836  1.00  9.17           O  
ATOM    306  CB  ILE A  41      10.681  -1.405  12.362  1.00  9.04           C  
ATOM    307  CG1 ILE A  41      12.202  -1.659  12.349  1.00  9.58           C  
ATOM    308  CG2 ILE A  41      10.213  -0.927  10.999  1.00  9.93           C  
ATOM    309  CD1 ILE A  41      12.670  -2.763  11.407  1.00 12.40           C  
ATOM    310  N   VAL A  42       8.469   1.159  13.201  1.00  7.97           N  
ATOM    311  CA  VAL A  42       7.104   1.654  13.358  1.00  7.63           C  
ATOM    312  C   VAL A  42       6.478   1.918  11.992  1.00  7.32           C  
ATOM    313  O   VAL A  42       6.950   2.767  11.243  1.00  7.39           O  
ATOM    314  CB  VAL A  42       7.060   2.950  14.205  1.00  7.71           C  
ATOM    315  CG1 VAL A  42       5.626   3.432  14.373  1.00  8.27           C  
ATOM    316  CG2 VAL A  42       7.721   2.724  15.570  1.00  8.95           C  
ATOM    317  N   ASP A  43       5.424   1.168  11.682  1.00  6.95           N  
ATOM    318  CA  ASP A  43       4.663   1.321  10.448  1.00  7.07           C  
ATOM    319  C   ASP A  43       3.564   2.345  10.682  1.00  6.90           C  
ATOM    320  O   ASP A  43       2.675   2.113  11.489  1.00  6.73           O  
ATOM    321  CB  ASP A  43       4.043  -0.038  10.117  1.00  7.27           C  
ATOM    322  CG  ASP A  43       3.400  -0.108   8.739  1.00  7.64           C  
ATOM    323  OD1 ASP A  43       3.049   0.928   8.142  1.00  7.68           O  
ATOM    324  OD2 ASP A  43       3.227  -1.257   8.270  1.00  8.74           O  
ATOM    325  N   ILE A  44       3.624   3.466   9.976  1.00  6.72           N  
ATOM    326  CA  ILE A  44       2.663   4.545  10.200  1.00  6.87           C  
ATOM    327  C   ILE A  44       1.554   4.608   9.146  1.00  6.55           C  
ATOM    328  O   ILE A  44       0.753   5.551   9.140  1.00  7.14           O  
ATOM    329  CB  ILE A  44       3.360   5.909  10.340  1.00  7.02           C  
ATOM    330  CG1 ILE A  44       3.960   6.357   9.000  1.00  7.83           C  
ATOM    331  CG2 ILE A  44       4.388   5.858  11.468  1.00  7.94           C  
ATOM    332  CD1 ILE A  44       4.584   7.730   9.024  1.00  9.00           C  
ATOM    333  N   ARG A  45       1.490   3.596   8.282  1.00  6.81           N  
ATOM    334  CA  ARG A  45       0.498   3.558   7.207  1.00  7.10           C  
ATOM    335  C   ARG A  45      -0.926   3.328   7.697  1.00  7.42           C  
ATOM    336  O   ARG A  45      -1.160   2.811   8.785  1.00  7.32           O  
ATOM    337  CB  ARG A  45       0.859   2.475   6.192  1.00  7.52           C  
ATOM    338  CG  ARG A  45       2.131   2.783   5.410  1.00  7.93           C  
ATOM    339  CD  ARG A  45       2.505   1.646   4.496  1.00  9.07           C  
ATOM    340  NE  ARG A  45       2.797   0.451   5.273  1.00  8.63           N  
ATOM    341  CZ  ARG A  45       2.798  -0.787   4.792  1.00  8.85           C  
ATOM    342  NH1 ARG A  45       2.541  -1.010   3.511  1.00 10.25           N  
ATOM    343  NH2 ARG A  45       3.074  -1.796   5.600  1.00  8.96           N  
ATOM    344  N   ASP A  46      -1.877   3.725   6.860  1.00  7.88           N  
ATOM    345  CA  ASP A  46      -3.269   3.384   7.062  1.00  8.32           C  
ATOM    346  C   ASP A  46      -3.396   1.850   6.980  1.00  8.17           C  
ATOM    347  O   ASP A  46      -2.706   1.210   6.174  1.00  8.23           O  
ATOM    348  CB  ASP A  46      -4.099   4.081   5.981  1.00  9.24           C  
ATOM    349  CG  ASP A  46      -5.586   3.832   6.117  1.00 10.82           C  
ATOM    350  OD1 ASP A  46      -6.053   2.731   5.768  1.00  9.20           O  
ATOM    351  OD2 ASP A  46      -6.308   4.753   6.554  1.00 12.80           O  
ATOM    352  N   PRO A  47      -4.262   1.244   7.814  1.00  8.48           N  
ATOM    353  CA  PRO A  47      -4.401  -0.218   7.806  1.00  9.06           C  
ATOM    354  C   PRO A  47      -4.791  -0.800   6.443  1.00  8.95           C  
ATOM    355  O   PRO A  47      -4.486  -1.963   6.159  1.00  9.76           O  
ATOM    356  CB  PRO A  47      -5.515  -0.468   8.836  1.00  9.25           C  
ATOM    357  CG  PRO A  47      -6.246   0.832   8.931  1.00  9.51           C  
ATOM    358  CD  PRO A  47      -5.174   1.858   8.796  1.00  9.05           C  
ATOM    359  N   ARG A  48      -5.443  -0.007   5.600  1.00  8.71           N  
ATOM    360  CA  ARG A  48      -5.847  -0.476   4.278  1.00  9.26           C  
ATOM    361  C   ARG A  48      -4.653  -0.587   3.324  1.00  9.71           C  
ATOM    362  O   ARG A  48      -4.622  -1.453   2.447  1.00 10.19           O  
ATOM    363  CB  ARG A  48      -6.942   0.427   3.714  1.00  9.14           C  
ATOM    364  CG  ARG A  48      -8.234   0.376   4.515  1.00  9.68           C  
ATOM    365  CD  ARG A  48      -9.187   1.507   4.164  1.00 10.14           C  
ATOM    366  NE  ARG A  48      -8.686   2.793   4.641  1.00  8.75           N  
ATOM    367  CZ  ARG A  48      -9.366   3.934   4.591  1.00  9.50           C  
ATOM    368  NH1 ARG A  48     -10.598   3.964   4.092  1.00  9.08           N  
ATOM    369  NH2 ARG A  48      -8.816   5.043   5.062  1.00  9.95           N  
ATOM    370  N   GLU A  49      -3.656   0.268   3.513  1.00  9.30           N  
ATOM    371  CA  GLU A  49      -2.379   0.132   2.813  1.00  9.51           C  
ATOM    372  C   GLU A  49      -1.666  -1.150   3.249  1.00 10.07           C  
ATOM    373  O   GLU A  49      -1.113  -1.892   2.423  1.00 10.29           O  
ATOM    374  CB  GLU A  49      -1.471   1.322   3.113  1.00  9.04           C  
ATOM    375  CG  GLU A  49      -1.951   2.660   2.621  1.00  9.68           C  
ATOM    376  CD  GLU A  49      -1.016   3.767   3.042  1.00 10.06           C  
ATOM    377  OE1 GLU A  49      -1.166   4.296   4.161  1.00  9.16           O  
ATOM    378  OE2 GLU A  49      -0.120   4.108   2.257  1.00 11.42           O  
ATOM    379  N   ILE A  50      -1.656  -1.394   4.556  1.00 10.50           N  
ATOM    380  CA  ILE A  50      -0.990  -2.565   5.128  1.00 11.75           C  
ATOM    381  C   ILE A  50      -1.653  -3.852   4.631  1.00 12.75           C  
ATOM    382  O   ILE A  50      -0.967  -4.803   4.229  1.00 13.31           O  
ATOM    383  CB  ILE A  50      -0.985  -2.509   6.676  1.00 11.34           C  
ATOM    384  CG1 ILE A  50      -0.305  -1.224   7.174  1.00 11.89           C  
ATOM    385  CG2 ILE A  50      -0.308  -3.755   7.264  1.00 12.19           C  
ATOM    386  CD1 ILE A  50      -0.390  -1.001   8.676  1.00 12.79           C  
ATOM    387  N   GLU A  51      -2.983  -3.872   4.629  1.00 13.54           N  
ATOM    388  CA  GLU A  51      -3.711  -5.040   4.135  1.00 15.10           C  
ATOM    389  C   GLU A  51      -3.370  -5.347   2.676  1.00 15.39           C  
ATOM    390  O   GLU A  51      -3.153  -6.512   2.320  1.00 15.86           O  
ATOM    391  CB  GLU A  51      -5.222  -4.875   4.322  1.00 15.54           C  
ATOM    392  CG  GLU A  51      -6.024  -6.090   3.835  1.00 18.32           C  
ATOM    393  CD  GLU A  51      -7.498  -6.021   4.180  1.00 21.65           C  
ATOM    394  OE1 GLU A  51      -7.955  -4.986   4.708  1.00 23.54           O  
ATOM    395  OE2 GLU A  51      -8.202  -7.021   3.923  1.00 23.99           O  
ATOM    396  N   ARG A  52      -3.293  -4.308   1.849  1.00 15.76           N  
ATOM    397  CA  ARG A  52      -3.029  -4.470   0.422  1.00 16.10           C  
ATOM    398  C   ARG A  52      -1.606  -4.948   0.127  1.00 15.66           C  
ATOM    399  O   ARG A  52      -1.404  -5.874  -0.667  1.00 16.13           O  
ATOM    400  CB  ARG A  52      -3.312  -3.153  -0.312  1.00 16.56           C  
ATOM    401  CG  ARG A  52      -3.121  -3.208  -1.827  1.00 18.24           C  
ATOM    402  CD  ARG A  52      -3.173  -1.825  -2.465  1.00 21.72           C  
ATOM    403  NE  ARG A  52      -2.167  -0.921  -1.908  1.00 24.34           N  
ATOM    404  CZ  ARG A  52      -2.435   0.145  -1.157  1.00 25.11           C  
ATOM    405  NH1 ARG A  52      -3.688   0.478  -0.864  1.00 26.38           N  
ATOM    406  NH2 ARG A  52      -1.438   0.887  -0.699  1.00 23.89           N  
ATOM    407  N   ASP A  53      -0.630  -4.329   0.786  1.00 15.01           N  
ATOM    408  CA  ASP A  53       0.771  -4.469   0.393  1.00 14.93           C  
ATOM    409  C   ASP A  53       1.625  -5.341   1.312  1.00 14.31           C  
ATOM    410  O   ASP A  53       2.742  -5.717   0.945  1.00 14.74           O  
ATOM    411  CB  ASP A  53       1.408  -3.081   0.258  1.00 15.06           C  
ATOM    412  CG  ASP A  53       0.815  -2.271  -0.884  1.00 16.42           C  
ATOM    413  OD1 ASP A  53       0.498  -2.861  -1.940  1.00 18.27           O  
ATOM    414  OD2 ASP A  53       0.675  -1.040  -0.727  1.00 16.85           O  
ATOM    415  N   GLY A  54       1.109  -5.663   2.492  1.00 13.12           N  
ATOM    416  CA  GLY A  54       1.902  -6.343   3.512  1.00 12.39           C  
ATOM    417  C   GLY A  54       2.712  -5.352   4.329  1.00 11.05           C  
ATOM    418  O   GLY A  54       2.539  -4.133   4.195  1.00 10.99           O  
ATOM    419  N   LYS A  55       3.608  -5.875   5.165  1.00 10.66           N  
ATOM    420  CA  LYS A  55       4.355  -5.063   6.120  1.00 10.54           C  
ATOM    421  C   LYS A  55       5.735  -5.648   6.416  1.00 10.17           C  
ATOM    422  O   LYS A  55       6.049  -6.795   6.055  1.00 10.22           O  
ATOM    423  CB  LYS A  55       3.560  -4.935   7.424  1.00 10.86           C  
ATOM    424  CG  LYS A  55       3.359  -6.248   8.169  1.00 12.50           C  
ATOM    425  CD  LYS A  55       2.512  -6.030   9.402  1.00 15.24           C  
ATOM    426  CE  LYS A  55       2.088  -7.352  10.006  1.00 17.94           C  
ATOM    427  NZ  LYS A  55       1.273  -7.157  11.232  1.00 20.05           N  
ATOM    428  N   ILE A  56       6.562  -4.856   7.086  1.00  9.47           N  
ATOM    429  CA  ILE A  56       7.848  -5.327   7.562  1.00  9.25           C  
ATOM    430  C   ILE A  56       7.598  -6.233   8.774  1.00  9.23           C  
ATOM    431  O   ILE A  56       6.920  -5.830   9.715  1.00  9.08           O  
ATOM    432  CB  ILE A  56       8.759  -4.136   7.912  1.00  8.91           C  
ATOM    433  CG1 ILE A  56       9.081  -3.349   6.635  1.00  9.49           C  
ATOM    434  CG2 ILE A  56      10.029  -4.615   8.592  1.00  9.87           C  
ATOM    435  CD1 ILE A  56       9.902  -2.084   6.850  1.00  9.88           C  
ATOM    436  N   PRO A  57       8.107  -7.480   8.738  1.00  9.71           N  
ATOM    437  CA  PRO A  57       7.857  -8.396   9.848  1.00  9.82           C  
ATOM    438  C   PRO A  57       8.296  -7.830  11.189  1.00 10.00           C  
ATOM    439  O   PRO A  57       9.376  -7.251  11.309  1.00 10.02           O  
ATOM    440  CB  PRO A  57       8.681  -9.635   9.472  1.00  9.95           C  
ATOM    441  CG  PRO A  57       8.772  -9.585   7.988  1.00 10.55           C  
ATOM    442  CD  PRO A  57       8.894  -8.124   7.671  1.00  9.94           C  
ATOM    443  N   GLY A  58       7.434  -7.976  12.183  1.00 10.59           N  
ATOM    444  CA  GLY A  58       7.760  -7.544  13.528  1.00 11.02           C  
ATOM    445  C   GLY A  58       7.579  -6.053  13.761  1.00 10.60           C  
ATOM    446  O   GLY A  58       7.850  -5.569  14.857  1.00 12.28           O  
ATOM    447  N   SER A  59       7.125  -5.319  12.744  1.00 10.36           N  
ATOM    448  CA  SER A  59       6.893  -3.882  12.907  1.00  9.94           C  
ATOM    449  C   SER A  59       5.698  -3.606  13.815  1.00  9.57           C  
ATOM    450  O   SER A  59       4.793  -4.432  13.942  1.00 10.01           O  
ATOM    451  CB  SER A  59       6.709  -3.201  11.551  1.00 10.71           C  
ATOM    452  OG  SER A  59       5.578  -3.708  10.883  1.00 12.76           O  
ATOM    453  N   PHE A  60       5.721  -2.435  14.441  1.00  9.10           N  
ATOM    454  CA  PHE A  60       4.653  -1.982  15.311  1.00  8.85           C  
ATOM    455  C   PHE A  60       3.806  -0.960  14.557  1.00  8.63           C  
ATOM    456  O   PHE A  60       4.333   0.024  14.029  1.00  8.48           O  
ATOM    457  CB  PHE A  60       5.253  -1.368  16.581  1.00  9.64           C  
ATOM    458  CG  PHE A  60       4.225  -0.866  17.556  1.00 10.53           C  
ATOM    459  CD1 PHE A  60       3.519  -1.758  18.355  1.00 11.57           C  
ATOM    460  CD2 PHE A  60       3.957   0.497  17.674  1.00 11.64           C  
ATOM    461  CE1 PHE A  60       2.554  -1.300  19.252  1.00 13.28           C  
ATOM    462  CE2 PHE A  60       2.992   0.961  18.578  1.00 12.11           C  
ATOM    463  CZ  PHE A  60       2.293   0.060  19.361  1.00 13.38           C  
ATOM    464  N   SER A  61       2.497  -1.192  14.494  1.00  8.18           N  
ATOM    465  CA  SER A  61       1.600  -0.298  13.765  1.00  8.38           C  
ATOM    466  C   SER A  61       1.103   0.833  14.643  1.00  8.07           C  
ATOM    467  O   SER A  61       0.441   0.604  15.651  1.00  8.85           O  
ATOM    468  CB  SER A  61       0.402  -1.067  13.190  1.00  8.58           C  
ATOM    469  OG  SER A  61      -0.615  -0.187  12.717  1.00 10.03           O  
ATOM    470  N   CYS A  62       1.421   2.054  14.237  1.00  7.49           N  
ATOM    471  CA  CYS A  62       0.834   3.241  14.837  1.00  7.97           C  
ATOM    472  C   CYS A  62       0.612   4.223  13.711  1.00  7.44           C  
ATOM    473  O   CYS A  62       1.566   4.740  13.134  1.00  7.48           O  
ATOM    474  CB  CYS A  62       1.741   3.872  15.900  1.00  8.56           C  
ATOM    475  SG  CYS A  62       1.027   5.381  16.621  1.00 10.83           S  
ATOM    476  N   THR A  63      -0.648   4.459  13.366  1.00  7.44           N  
ATOM    477  CA  THR A  63      -0.927   5.372  12.258  1.00  7.84           C  
ATOM    478  C   THR A  63      -0.365   6.760  12.569  1.00  7.16           C  
ATOM    479  O   THR A  63      -0.302   7.182  13.729  1.00  7.36           O  
ATOM    480  CB  THR A  63      -2.423   5.456  11.908  1.00  8.32           C  
ATOM    481  OG1 THR A  63      -3.148   6.011  13.012  1.00  9.97           O  
ATOM    482  CG2 THR A  63      -2.989   4.082  11.550  1.00  9.17           C  
ATOM    483  N   ARG A  64       0.069   7.464  11.531  1.00  7.17           N  
ATOM    484  CA  ARG A  64       0.731   8.737  11.740  1.00  7.66           C  
ATOM    485  C   ARG A  64      -0.140   9.696  12.549  1.00  7.41           C  
ATOM    486  O   ARG A  64       0.360  10.411  13.419  1.00  7.69           O  
ATOM    487  CB  ARG A  64       1.158   9.367  10.415  1.00  7.60           C  
ATOM    488  CG  ARG A  64       1.763  10.746  10.597  1.00  7.73           C  
ATOM    489  CD  ARG A  64       2.426  11.322   9.340  1.00  7.51           C  
ATOM    490  NE  ARG A  64       2.764  12.717   9.633  1.00  7.22           N  
ATOM    491  CZ  ARG A  64       2.145  13.786   9.139  1.00  6.88           C  
ATOM    492  NH1 ARG A  64       1.217  13.672   8.198  1.00  8.04           N  
ATOM    493  NH2 ARG A  64       2.493  14.994   9.560  1.00  7.96           N  
ATOM    494  N   GLY A  65      -1.445   9.678  12.288  1.00  7.19           N  
ATOM    495  CA  GLY A  65      -2.363  10.598  12.942  1.00  7.82           C  
ATOM    496  C   GLY A  65      -2.561  10.368  14.427  1.00  7.73           C  
ATOM    497  O   GLY A  65      -3.106  11.237  15.110  1.00  8.08           O  
HETATM  498  N   MSE A  66      -2.116   9.214  14.925  1.00  7.87           N  
HETATM  499  CA  MSE A  66      -2.198   8.875  16.350  1.00  8.49           C  
HETATM  500  C   MSE A  66      -0.872   9.009  17.085  1.00  7.83           C  
HETATM  501  O   MSE A  66      -0.820   8.843  18.312  1.00  7.95           O  
HETATM  502  CB  MSE A  66      -2.669   7.434  16.503  1.00  9.76           C  
HETATM  503  CG  MSE A  66      -4.103   7.256  16.122  1.00 12.97           C  
HETATM  504 SE   MSE A  66      -4.739   5.504  16.514  1.00 21.80          SE  
HETATM  505  CE  MSE A  66      -6.437   5.652  15.575  1.00 19.16           C  
ATOM    506  N   LEU A  67       0.195   9.303  16.349  1.00  7.97           N  
ATOM    507  CA  LEU A  67       1.554   9.172  16.871  1.00  8.45           C  
ATOM    508  C   LEU A  67       1.786   9.900  18.189  1.00  8.04           C  
ATOM    509  O   LEU A  67       2.274   9.308  19.158  1.00  8.37           O  
ATOM    510  CB  LEU A  67       2.555   9.653  15.824  1.00  9.17           C  
ATOM    511  CG  LEU A  67       4.031   9.360  16.073  1.00 12.75           C  
ATOM    512  CD1 LEU A  67       4.286   7.851  16.083  1.00 15.90           C  
ATOM    513  CD2 LEU A  67       4.887  10.058  15.026  1.00 15.48           C  
ATOM    514  N   GLU A  68       1.427  11.179  18.233  1.00  7.81           N  
ATOM    515  CA  GLU A  68       1.699  11.990  19.420  1.00  7.81           C  
ATOM    516  C   GLU A  68       0.987  11.439  20.645  1.00  7.59           C  
ATOM    517  O   GLU A  68       1.523  11.469  21.755  1.00  7.80           O  
ATOM    518  CB  GLU A  68       1.294  13.449  19.191  1.00  8.36           C  
ATOM    519  CG  GLU A  68       1.996  14.121  18.006  1.00  8.92           C  
ATOM    520  CD  GLU A  68       1.253  13.998  16.676  1.00  8.45           C  
ATOM    521  OE1 GLU A  68       0.490  13.034  16.480  1.00  8.91           O  
ATOM    522  OE2 GLU A  68       1.450  14.875  15.815  1.00  9.26           O  
ATOM    523  N   PHE A  69      -0.223  10.929  20.419  1.00  7.63           N  
ATOM    524  CA  PHE A  69      -1.079  10.399  21.472  1.00  8.16           C  
ATOM    525  C   PHE A  69      -0.600   9.071  22.024  1.00  8.08           C  
ATOM    526  O   PHE A  69      -0.905   8.733  23.169  1.00  8.98           O  
ATOM    527  CB  PHE A  69      -2.511  10.302  20.952  1.00  8.45           C  
ATOM    528  CG  PHE A  69      -3.065  11.633  20.591  1.00  8.81           C  
ATOM    529  CD1 PHE A  69      -3.666  12.423  21.558  1.00  9.76           C  
ATOM    530  CD2 PHE A  69      -2.900  12.141  19.313  1.00  9.09           C  
ATOM    531  CE1 PHE A  69      -4.125  13.692  21.247  1.00  9.93           C  
ATOM    532  CE2 PHE A  69      -3.354  13.407  18.996  1.00  9.94           C  
ATOM    533  CZ  PHE A  69      -3.975  14.179  19.958  1.00  9.90           C  
ATOM    534  N   TRP A  70       0.143   8.319  21.217  1.00  7.84           N  
ATOM    535  CA  TRP A  70       0.716   7.056  21.674  1.00  8.17           C  
ATOM    536  C   TRP A  70       2.128   7.240  22.227  1.00  7.99           C  
ATOM    537  O   TRP A  70       2.540   6.497  23.112  1.00  8.41           O  
ATOM    538  CB  TRP A  70       0.687   6.022  20.545  1.00  8.42           C  
ATOM    539  CG  TRP A  70      -0.690   5.487  20.233  1.00  8.74           C  
ATOM    540  CD1 TRP A  70      -1.900   6.037  20.574  1.00  9.09           C  
ATOM    541  CD2 TRP A  70      -0.986   4.301  19.496  1.00  9.57           C  
ATOM    542  NE1 TRP A  70      -2.930   5.251  20.108  1.00 10.47           N  
ATOM    543  CE2 TRP A  70      -2.392   4.184  19.438  1.00  9.16           C  
ATOM    544  CE3 TRP A  70      -0.200   3.312  18.893  1.00  9.61           C  
ATOM    545  CZ2 TRP A  70      -3.023   3.123  18.793  1.00 10.26           C  
ATOM    546  CZ3 TRP A  70      -0.832   2.264  18.245  1.00 10.37           C  
ATOM    547  CH2 TRP A  70      -2.230   2.177  18.207  1.00 10.33           C  
ATOM    548  N   ILE A  71       2.869   8.224  21.719  1.00  7.77           N  
ATOM    549  CA  ILE A  71       4.222   8.474  22.217  1.00  8.13           C  
ATOM    550  C   ILE A  71       4.235   9.082  23.623  1.00  8.10           C  
ATOM    551  O   ILE A  71       4.989   8.641  24.496  1.00  8.25           O  
ATOM    552  CB  ILE A  71       5.005   9.395  21.270  1.00  7.76           C  
ATOM    553  CG1 ILE A  71       5.375   8.645  19.986  1.00  8.52           C  
ATOM    554  CG2 ILE A  71       6.267   9.935  21.950  1.00  8.46           C  
ATOM    555  CD1 ILE A  71       6.052   9.503  18.940  1.00  9.63           C  
ATOM    556  N   ASP A  72       3.423  10.114  23.830  1.00  8.30           N  
ATOM    557  CA  ASP A  72       3.482  10.913  25.047  1.00  8.95           C  
ATOM    558  C   ASP A  72       3.024  10.102  26.254  1.00  9.28           C  
ATOM    559  O   ASP A  72       1.870   9.698  26.306  1.00  8.95           O  
ATOM    560  CB  ASP A  72       2.603  12.147  24.868  1.00  9.16           C  
ATOM    561  CG  ASP A  72       2.618  13.069  26.066  1.00  9.49           C  
ATOM    562  OD1 ASP A  72       3.318  12.801  27.068  1.00  9.86           O  
ATOM    563  OD2 ASP A  72       1.898  14.082  26.000  1.00 11.14           O  
ATOM    564  N   PRO A  73       3.922   9.869  27.236  1.00 10.35           N  
ATOM    565  CA  PRO A  73       3.505   9.063  28.386  1.00 11.50           C  
ATOM    566  C   PRO A  73       2.416   9.732  29.234  1.00 12.44           C  
ATOM    567  O   PRO A  73       1.751   9.055  30.024  1.00 13.51           O  
ATOM    568  CB  PRO A  73       4.802   8.892  29.187  1.00 11.50           C  
ATOM    569  CG  PRO A  73       5.647  10.044  28.803  1.00 11.40           C  
ATOM    570  CD  PRO A  73       5.325  10.309  27.355  1.00 10.14           C  
ATOM    571  N   GLN A  74       2.236  11.041  29.062  1.00 13.13           N  
ATOM    572  CA  GLN A  74       1.188  11.789  29.756  1.00 14.26           C  
ATOM    573  C   GLN A  74      -0.135  11.819  28.993  1.00 14.35           C  
ATOM    574  O   GLN A  74      -1.094  12.470  29.425  1.00 15.21           O  
ATOM    575  CB  GLN A  74       1.648  13.222  30.041  1.00 14.67           C  
ATOM    576  CG  GLN A  74       2.928  13.340  30.869  1.00 17.68           C  
ATOM    577  CD  GLN A  74       2.876  12.546  32.159  1.00 21.18           C  
ATOM    578  OE1 GLN A  74       1.858  12.533  32.854  1.00 22.18           O  
ATOM    579  NE2 GLN A  74       3.977  11.873  32.485  1.00 22.83           N  
ATOM    580  N   SER A  75      -0.177  11.144  27.847  1.00 13.94           N  
ATOM    581  CA  SER A  75      -1.414  10.981  27.102  1.00 13.85           C  
ATOM    582  C   SER A  75      -2.216   9.826  27.687  1.00 14.40           C  
ATOM    583  O   SER A  75      -1.642   8.807  28.065  1.00 14.12           O  
ATOM    584  CB  SER A  75      -1.123  10.703  25.627  1.00 13.40           C  
ATOM    585  OG  SER A  75      -2.283  10.220  24.960  1.00 12.85           O  
ATOM    586  N   PRO A  76      -3.552   9.976  27.750  1.00 15.16           N  
ATOM    587  CA  PRO A  76      -4.407   8.866  28.162  1.00 15.80           C  
ATOM    588  C   PRO A  76      -4.233   7.620  27.283  1.00 15.63           C  
ATOM    589  O   PRO A  76      -4.565   6.513  27.704  1.00 16.74           O  
ATOM    590  CB  PRO A  76      -5.822   9.439  28.002  1.00 16.06           C  
ATOM    591  CG  PRO A  76      -5.646  10.908  28.108  1.00 15.99           C  
ATOM    592  CD  PRO A  76      -4.333  11.190  27.455  1.00 15.52           C  
ATOM    593  N   TYR A  77      -3.680   7.806  26.085  1.00 14.84           N  
ATOM    594  CA  TYR A  77      -3.579   6.746  25.080  1.00 14.21           C  
ATOM    595  C   TYR A  77      -2.136   6.266  24.872  1.00 13.09           C  
ATOM    596  O   TYR A  77      -1.835   5.562  23.901  1.00 12.81           O  
ATOM    597  CB  TYR A  77      -4.227   7.234  23.773  1.00 14.79           C  
ATOM    598  CG  TYR A  77      -5.471   8.068  24.035  1.00 15.74           C  
ATOM    599  CD1 TYR A  77      -6.697   7.462  24.310  1.00 17.27           C  
ATOM    600  CD2 TYR A  77      -5.412   9.463  24.052  1.00 16.53           C  
ATOM    601  CE1 TYR A  77      -7.838   8.226  24.577  1.00 17.63           C  
ATOM    602  CE2 TYR A  77      -6.546  10.235  24.318  1.00 18.02           C  
ATOM    603  CZ  TYR A  77      -7.751   9.608  24.578  1.00 18.52           C  
ATOM    604  OH  TYR A  77      -8.871  10.369  24.837  1.00 19.44           O  
ATOM    605  N   ALA A  78      -1.262   6.635  25.811  1.00 12.35           N  
ATOM    606  CA  ALA A  78       0.159   6.287  25.772  1.00 12.14           C  
ATOM    607  C   ALA A  78       0.404   4.799  25.579  1.00 12.00           C  
ATOM    608  O   ALA A  78      -0.278   3.959  26.183  1.00 12.26           O  
ATOM    609  CB  ALA A  78       0.845   6.755  27.036  1.00 12.65           C  
ATOM    610  N   LYS A  79       1.390   4.472  24.751  1.00 11.41           N  
ATOM    611  CA  LYS A  79       1.796   3.088  24.554  1.00 11.09           C  
ATOM    612  C   LYS A  79       3.212   2.945  25.083  1.00 11.25           C  
ATOM    613  O   LYS A  79       4.105   3.697  24.677  1.00 11.12           O  
ATOM    614  CB  LYS A  79       1.728   2.704  23.080  1.00 11.49           C  
ATOM    615  CG  LYS A  79       0.352   2.868  22.466  1.00 12.06           C  
ATOM    616  CD  LYS A  79      -0.661   1.899  23.049  1.00 14.31           C  
ATOM    617  CE  LYS A  79      -2.008   2.071  22.358  1.00 14.93           C  
ATOM    618  NZ  LYS A  79      -2.809   3.187  22.909  1.00 17.98           N  
ATOM    619  N   PRO A  80       3.430   1.991  26.010  1.00 11.44           N  
ATOM    620  CA  PRO A  80       4.730   1.849  26.661  1.00 11.53           C  
ATOM    621  C   PRO A  80       5.895   1.542  25.736  1.00 10.58           C  
ATOM    622  O   PRO A  80       7.038   1.815  26.106  1.00 10.37           O  
ATOM    623  CB  PRO A  80       4.521   0.689  27.639  1.00 12.36           C  
ATOM    624  CG  PRO A  80       3.074   0.570  27.809  1.00 13.67           C  
ATOM    625  CD  PRO A  80       2.442   1.038  26.548  1.00 11.72           C  
ATOM    626  N   ILE A  81       5.625   0.981  24.557  1.00 10.48           N  
ATOM    627  CA  ILE A  81       6.689   0.710  23.588  1.00 10.24           C  
ATOM    628  C   ILE A  81       7.485   1.979  23.241  1.00  9.69           C  
ATOM    629  O   ILE A  81       8.691   1.913  23.020  1.00  9.39           O  
ATOM    630  CB  ILE A  81       6.153  -0.001  22.310  1.00 10.68           C  
ATOM    631  CG1 ILE A  81       7.307  -0.565  21.471  1.00 11.68           C  
ATOM    632  CG2 ILE A  81       5.251   0.923  21.474  1.00 10.90           C  
ATOM    633  CD1 ILE A  81       6.854  -1.535  20.393  1.00 14.23           C  
ATOM    634  N   PHE A  82       6.814   3.130  23.236  1.00  8.75           N  
ATOM    635  CA  PHE A  82       7.471   4.392  22.903  1.00  8.76           C  
ATOM    636  C   PHE A  82       8.319   4.962  24.037  1.00  8.95           C  
ATOM    637  O   PHE A  82       8.962   5.993  23.866  1.00  9.23           O  
ATOM    638  CB  PHE A  82       6.451   5.425  22.423  1.00  8.57           C  
ATOM    639  CG  PHE A  82       5.958   5.172  21.033  1.00  8.40           C  
ATOM    640  CD1 PHE A  82       6.843   5.191  19.952  1.00  8.98           C  
ATOM    641  CD2 PHE A  82       4.610   4.912  20.794  1.00  8.68           C  
ATOM    642  CE1 PHE A  82       6.390   4.959  18.659  1.00 10.22           C  
ATOM    643  CE2 PHE A  82       4.152   4.684  19.500  1.00 10.48           C  
ATOM    644  CZ  PHE A  82       5.044   4.700  18.437  1.00 11.91           C  
ATOM    645  N   GLN A  83       8.310   4.302  25.189  1.00  9.26           N  
ATOM    646  CA  GLN A  83       9.157   4.711  26.305  1.00 10.19           C  
ATOM    647  C   GLN A  83      10.465   3.922  26.348  1.00 10.58           C  
ATOM    648  O   GLN A  83      11.353   4.225  27.149  1.00 10.89           O  
ATOM    649  CB  GLN A  83       8.392   4.582  27.624  1.00 10.66           C  
ATOM    650  CG  GLN A  83       7.486   5.776  27.901  1.00 11.66           C  
ATOM    651  CD  GLN A  83       8.258   6.978  28.397  1.00 12.34           C  
ATOM    652  OE1 GLN A  83       8.461   7.952  27.668  1.00 13.62           O  
ATOM    653  NE2 GLN A  83       8.702   6.916  29.645  1.00 11.69           N  
ATOM    654  N   GLU A  84      10.593   2.928  25.475  1.00 10.84           N  
ATOM    655  CA  GLU A  84      11.759   2.045  25.472  1.00 11.89           C  
ATOM    656  C   GLU A  84      13.023   2.747  25.001  1.00 11.82           C  
ATOM    657  O   GLU A  84      12.979   3.643  24.157  1.00 10.89           O  
ATOM    658  CB  GLU A  84      11.488   0.797  24.634  1.00 12.21           C  
ATOM    659  CG  GLU A  84      10.422  -0.091  25.256  1.00 14.75           C  
ATOM    660  CD  GLU A  84      10.145  -1.357  24.478  1.00 18.28           C  
ATOM    661  OE1 GLU A  84      10.857  -1.642  23.494  1.00 19.81           O  
ATOM    662  OE2 GLU A  84       9.192  -2.068  24.858  1.00 18.97           O  
ATOM    663  N   ASP A  85      14.146   2.311  25.564  1.00 12.89           N  
ATOM    664  CA  ASP A  85      15.461   2.859  25.281  1.00 14.03           C  
ATOM    665  C   ASP A  85      16.008   2.242  23.989  1.00 13.84           C  
ATOM    666  O   ASP A  85      16.952   1.445  24.011  1.00 14.77           O  
ATOM    667  CB  ASP A  85      16.374   2.566  26.483  1.00 15.00           C  
ATOM    668  CG  ASP A  85      17.787   3.093  26.305  1.00 17.15           C  
ATOM    669  OD1 ASP A  85      17.956   4.186  25.725  1.00 19.97           O  
ATOM    670  OD2 ASP A  85      18.729   2.409  26.762  1.00 20.47           O  
ATOM    671  N   LYS A  86      15.400   2.620  22.865  1.00 13.23           N  
ATOM    672  CA  LYS A  86      15.687   2.028  21.559  1.00 12.87           C  
ATOM    673  C   LYS A  86      15.676   3.096  20.478  1.00 12.24           C  
ATOM    674  O   LYS A  86      15.206   4.209  20.709  1.00 12.29           O  
ATOM    675  CB  LYS A  86      14.650   0.944  21.240  1.00 12.97           C  
ATOM    676  CG  LYS A  86      14.775  -0.291  22.134  1.00 14.11           C  
ATOM    677  CD  LYS A  86      13.741  -1.342  21.813  1.00 16.26           C  
ATOM    678  CE  LYS A  86      13.991  -2.611  22.612  1.00 18.37           C  
ATOM    679  NZ  LYS A  86      12.919  -3.610  22.368  1.00 20.61           N  
ATOM    680  N   LYS A  87      16.199   2.751  19.304  1.00 11.62           N  
ATOM    681  CA  LYS A  87      16.062   3.588  18.120  1.00 11.25           C  
ATOM    682  C   LYS A  87      14.728   3.283  17.431  1.00 10.32           C  
ATOM    683  O   LYS A  87      14.390   2.121  17.205  1.00 11.08           O  
ATOM    684  CB  LYS A  87      17.234   3.378  17.150  1.00 11.56           C  
ATOM    685  CG  LYS A  87      17.112   4.209  15.866  1.00 12.04           C  
ATOM    686  CD  LYS A  87      18.354   4.166  14.978  1.00 12.88           C  
ATOM    687  CE  LYS A  87      19.402   5.172  15.436  1.00 13.52           C  
ATOM    688  NZ  LYS A  87      20.494   5.362  14.439  1.00 12.31           N  
ATOM    689  N   PHE A  88      13.984   4.336  17.102  1.00  9.68           N  
ATOM    690  CA  PHE A  88      12.684   4.209  16.446  1.00  8.50           C  
ATOM    691  C   PHE A  88      12.812   4.553  14.980  1.00  8.36           C  
ATOM    692  O   PHE A  88      13.178   5.675  14.626  1.00  9.01           O  
ATOM    693  CB  PHE A  88      11.639   5.080  17.145  1.00  8.28           C  
ATOM    694  CG  PHE A  88      11.307   4.593  18.514  1.00  8.97           C  
ATOM    695  CD1 PHE A  88      10.224   3.754  18.724  1.00  9.38           C  
ATOM    696  CD2 PHE A  88      12.117   4.922  19.598  1.00  9.60           C  
ATOM    697  CE1 PHE A  88       9.938   3.269  19.991  1.00 10.06           C  
ATOM    698  CE2 PHE A  88      11.837   4.446  20.871  1.00 10.26           C  
ATOM    699  CZ  PHE A  88      10.742   3.612  21.064  1.00 10.27           C  
ATOM    700  N   VAL A  89      12.543   3.561  14.138  1.00  7.83           N  
ATOM    701  CA  VAL A  89      12.653   3.690  12.699  1.00  7.72           C  
ATOM    702  C   VAL A  89      11.244   3.683  12.114  1.00  7.45           C  
ATOM    703  O   VAL A  89      10.564   2.656  12.138  1.00  8.01           O  
ATOM    704  CB  VAL A  89      13.491   2.535  12.112  1.00  7.91           C  
ATOM    705  CG1 VAL A  89      13.544   2.620  10.588  1.00  9.32           C  
ATOM    706  CG2 VAL A  89      14.884   2.523  12.717  1.00  9.14           C  
ATOM    707  N   PHE A  90      10.811   4.825  11.583  1.00  7.38           N  
ATOM    708  CA  PHE A  90       9.454   4.973  11.062  1.00  7.11           C  
ATOM    709  C   PHE A  90       9.427   4.677   9.582  1.00  7.18           C  
ATOM    710  O   PHE A  90      10.370   5.004   8.868  1.00  7.79           O  
ATOM    711  CB  PHE A  90       8.946   6.397  11.317  1.00  7.69           C  
ATOM    712  CG  PHE A  90       8.837   6.742  12.773  1.00  7.23           C  
ATOM    713  CD1 PHE A  90       7.666   6.480  13.476  1.00  7.80           C  
ATOM    714  CD2 PHE A  90       9.915   7.307  13.456  1.00  8.25           C  
ATOM    715  CE1 PHE A  90       7.568   6.778  14.830  1.00  8.21           C  
ATOM    716  CE2 PHE A  90       9.823   7.607  14.807  1.00  8.06           C  
ATOM    717  CZ  PHE A  90       8.645   7.344  15.494  1.00  8.50           C  
ATOM    718  N   TYR A  91       8.351   4.059   9.112  1.00  7.04           N  
ATOM    719  CA  TYR A  91       8.191   3.886   7.669  1.00  7.33           C  
ATOM    720  C   TYR A  91       6.754   4.037   7.212  1.00  7.62           C  
ATOM    721  O   TYR A  91       5.813   3.763   7.951  1.00  7.74           O  
ATOM    722  CB  TYR A  91       8.797   2.569   7.166  1.00  7.60           C  
ATOM    723  CG  TYR A  91       7.971   1.329   7.410  1.00  8.02           C  
ATOM    724  CD1 TYR A  91       7.165   0.799   6.406  1.00  7.87           C  
ATOM    725  CD2 TYR A  91       8.032   0.660   8.627  1.00  8.38           C  
ATOM    726  CE1 TYR A  91       6.413  -0.356   6.622  1.00  8.08           C  
ATOM    727  CE2 TYR A  91       7.290  -0.500   8.848  1.00  8.05           C  
ATOM    728  CZ  TYR A  91       6.496  -1.003   7.837  1.00  8.03           C  
ATOM    729  OH  TYR A  91       5.771  -2.158   8.049  1.00  8.61           O  
ATOM    730  N   CYS A  92       6.614   4.492   5.975  1.00  7.65           N  
ATOM    731  CA  CYS A  92       5.316   4.642   5.342  1.00  8.53           C  
ATOM    732  C   CYS A  92       5.417   4.002   3.957  1.00  8.60           C  
ATOM    733  O   CYS A  92       6.298   3.170   3.733  1.00  9.53           O  
ATOM    734  CB  CYS A  92       4.913   6.122   5.270  1.00  8.70           C  
ATOM    735  SG  CYS A  92       6.079   7.190   4.362  1.00  9.76           S  
ATOM    736  N   ALA A  93       4.535   4.365   3.027  1.00  8.96           N  
ATOM    737  CA  ALA A  93       4.569   3.761   1.692  1.00  9.93           C  
ATOM    738  C   ALA A  93       5.717   4.248   0.806  1.00 10.56           C  
ATOM    739  O   ALA A  93       6.302   3.454   0.058  1.00 10.80           O  
ATOM    740  CB  ALA A  93       3.228   3.947   0.978  1.00 10.76           C  
ATOM    741  N   GLY A  94       6.048   5.531   0.884  1.00 10.86           N  
ATOM    742  CA  GLY A  94       7.023   6.126  -0.030  1.00 11.35           C  
ATOM    743  C   GLY A  94       8.108   6.975   0.601  1.00 11.20           C  
ATOM    744  O   GLY A  94       8.954   7.523  -0.107  1.00 12.01           O  
ATOM    745  N   GLY A  95       8.095   7.086   1.925  1.00 10.83           N  
ATOM    746  CA  GLY A  95       9.141   7.807   2.646  1.00 10.95           C  
ATOM    747  C   GLY A  95       8.791   9.212   3.109  1.00 11.01           C  
ATOM    748  O   GLY A  95       9.520   9.802   3.908  1.00 12.55           O  
ATOM    749  N   LEU A  96       7.669   9.757   2.642  1.00 10.07           N  
ATOM    750  CA  LEU A  96       7.349  11.159   2.919  1.00  9.81           C  
ATOM    751  C   LEU A  96       6.671  11.363   4.270  1.00  9.37           C  
ATOM    752  O   LEU A  96       7.187  12.105   5.105  1.00  9.09           O  
ATOM    753  CB  LEU A  96       6.552  11.793   1.772  1.00 10.48           C  
ATOM    754  CG  LEU A  96       7.181  11.682   0.375  1.00 11.85           C  
ATOM    755  CD1 LEU A  96       6.384  12.481  -0.643  1.00 12.76           C  
ATOM    756  CD2 LEU A  96       8.649  12.110   0.349  1.00 13.43           C  
ATOM    757  N   ARG A  97       5.535  10.702   4.498  1.00  8.59           N  
ATOM    758  CA  ARG A  97       4.860  10.767   5.798  1.00  8.51           C  
ATOM    759  C   ARG A  97       5.817  10.397   6.917  1.00  7.84           C  
ATOM    760  O   ARG A  97       5.782  10.982   7.998  1.00  7.40           O  
ATOM    761  CB  ARG A  97       3.648   9.830   5.853  1.00  8.72           C  
ATOM    762  CG  ARG A  97       2.379  10.371   5.230  1.00  9.39           C  
ATOM    763  CD  ARG A  97       1.322   9.279   5.135  1.00  9.14           C  
ATOM    764  NE  ARG A  97       1.694   8.281   4.136  1.00  9.51           N  
ATOM    765  CZ  ARG A  97       1.142   7.079   3.992  1.00  9.06           C  
ATOM    766  NH1 ARG A  97       0.194   6.654   4.819  1.00  9.46           N  
ATOM    767  NH2 ARG A  97       1.571   6.281   3.021  1.00  9.71           N  
ATOM    768  N   SER A  98       6.664   9.402   6.664  1.00  8.04           N  
ATOM    769  CA  SER A  98       7.568   8.933   7.711  1.00  8.26           C  
ATOM    770  C   SER A  98       8.663   9.933   8.056  1.00  7.66           C  
ATOM    771  O   SER A  98       9.138   9.952   9.190  1.00  7.26           O  
ATOM    772  CB  SER A  98       8.154   7.563   7.377  1.00  9.16           C  
ATOM    773  OG  SER A  98       8.806   7.577   6.130  1.00 10.97           O  
ATOM    774  N   ALA A  99       9.066  10.765   7.095  1.00  7.52           N  
ATOM    775  CA  ALA A  99       9.988  11.860   7.407  1.00  7.74           C  
ATOM    776  C   ALA A  99       9.307  12.836   8.363  1.00  7.26           C  
ATOM    777  O   ALA A  99       9.895  13.263   9.362  1.00  7.56           O  
ATOM    778  CB  ALA A  99      10.447  12.571   6.147  1.00  8.53           C  
ATOM    779  N   LEU A 100       8.059  13.188   8.066  1.00  7.30           N  
ATOM    780  CA  LEU A 100       7.316  14.090   8.945  1.00  7.45           C  
ATOM    781  C   LEU A 100       7.100  13.466  10.315  1.00  7.43           C  
ATOM    782  O   LEU A 100       7.246  14.134  11.330  1.00  7.16           O  
ATOM    783  CB  LEU A 100       5.977  14.503   8.330  1.00  7.83           C  
ATOM    784  CG  LEU A 100       6.021  15.201   6.970  1.00  7.82           C  
ATOM    785  CD1 LEU A 100       4.635  15.710   6.637  1.00  9.84           C  
ATOM    786  CD2 LEU A 100       7.043  16.341   6.934  1.00  9.34           C  
ATOM    787  N   ALA A 101       6.779  12.174  10.345  1.00  7.39           N  
ATOM    788  CA  ALA A 101       6.532  11.470  11.605  1.00  7.69           C  
ATOM    789  C   ALA A 101       7.786  11.405  12.471  1.00  7.73           C  
ATOM    790  O   ALA A 101       7.730  11.652  13.672  1.00  7.60           O  
ATOM    791  CB  ALA A 101       6.005  10.075  11.347  1.00  7.81           C  
ATOM    792  N   ALA A 102       8.922  11.068  11.861  1.00  7.62           N  
ATOM    793  CA  ALA A 102      10.193  11.033  12.584  1.00  7.87           C  
ATOM    794  C   ALA A 102      10.535  12.405  13.156  1.00  7.51           C  
ATOM    795  O   ALA A 102      10.963  12.514  14.303  1.00  7.39           O  
ATOM    796  CB  ALA A 102      11.309  10.530  11.681  1.00  7.84           C  
ATOM    797  N   LYS A 103      10.318  13.449  12.364  1.00  7.55           N  
ATOM    798  CA  LYS A 103      10.565  14.805  12.831  1.00  7.75           C  
ATOM    799  C   LYS A 103       9.643  15.177  14.001  1.00  7.30           C  
ATOM    800  O   LYS A 103      10.100  15.751  14.990  1.00  7.64           O  
ATOM    801  CB  LYS A 103      10.427  15.789  11.671  1.00  7.69           C  
ATOM    802  CG  LYS A 103      10.662  17.258  12.035  1.00  8.91           C  
ATOM    803  CD  LYS A 103      12.055  17.517  12.600  1.00 10.61           C  
ATOM    804  CE  LYS A 103      12.401  18.999  12.578  1.00 11.91           C  
ATOM    805  NZ  LYS A 103      11.415  19.860  13.275  1.00 12.93           N  
ATOM    806  N   THR A 104       8.359  14.845  13.899  1.00  7.35           N  
ATOM    807  CA  THR A 104       7.433  15.076  15.006  1.00  7.62           C  
ATOM    808  C   THR A 104       7.906  14.373  16.281  1.00  7.56           C  
ATOM    809  O   THR A 104       7.962  14.974  17.355  1.00  7.82           O  
ATOM    810  CB  THR A 104       6.032  14.587  14.641  1.00  7.92           C  
ATOM    811  OG1 THR A 104       5.540  15.364  13.543  1.00  8.18           O  
ATOM    812  CG2 THR A 104       5.074  14.702  15.824  1.00  9.40           C  
ATOM    813  N   ALA A 105       8.254  13.099  16.151  1.00  7.76           N  
ATOM    814  CA  ALA A 105       8.696  12.320  17.301  1.00  7.67           C  
ATOM    815  C   ALA A 105       9.956  12.937  17.912  1.00  8.30           C  
ATOM    816  O   ALA A 105      10.063  13.089  19.129  1.00  8.18           O  
ATOM    817  CB  ALA A 105       8.937  10.883  16.896  1.00  7.80           C  
ATOM    818  N   GLN A 106      10.891  13.333  17.059  1.00  8.23           N  
ATOM    819  CA  GLN A 106      12.122  13.953  17.530  1.00  8.97           C  
ATOM    820  C   GLN A 106      11.846  15.285  18.240  1.00  9.00           C  
ATOM    821  O   GLN A 106      12.445  15.564  19.290  1.00  9.38           O  
ATOM    822  CB  GLN A 106      13.066  14.156  16.356  1.00  9.18           C  
ATOM    823  CG  GLN A 106      14.478  14.530  16.757  1.00  9.88           C  
ATOM    824  CD  GLN A 106      15.389  14.572  15.565  1.00  9.46           C  
ATOM    825  OE1 GLN A 106      15.460  15.580  14.853  1.00 11.96           O  
ATOM    826  NE2 GLN A 106      16.083  13.484  15.327  1.00  8.21           N  
ATOM    827  N   ASP A 107      10.939  16.090  17.676  1.00  9.35           N  
ATOM    828  CA  ASP A 107      10.507  17.349  18.283  1.00 10.30           C  
ATOM    829  C   ASP A 107       9.928  17.146  19.683  1.00  9.63           C  
ATOM    830  O   ASP A 107      10.034  18.021  20.536  1.00 10.78           O  
ATOM    831  CB  ASP A 107       9.447  18.044  17.419  1.00 10.62           C  
ATOM    832  CG  ASP A 107      10.011  18.660  16.151  1.00 12.24           C  
ATOM    833  OD1 ASP A 107      11.242  18.754  16.000  1.00 12.87           O  
ATOM    834  OD2 ASP A 107       9.190  19.057  15.295  1.00 14.06           O  
HETATM  835  N   MSE A 108       9.295  15.999  19.908  1.00  9.25           N  
HETATM  836  CA  MSE A 108       8.703  15.682  21.205  1.00  9.14           C  
HETATM  837  C   MSE A 108       9.749  15.274  22.225  1.00  8.85           C  
HETATM  838  O   MSE A 108       9.496  15.327  23.428  1.00  8.98           O  
HETATM  839  CB  MSE A 108       7.678  14.558  21.066  1.00  9.18           C  
HETATM  840  CG  MSE A 108       6.486  14.945  20.238  1.00  9.94           C  
HETATM  841 SE   MSE A 108       5.253  13.477  20.032  1.00 13.82          SE  
HETATM  842  CE  MSE A 108       4.591  13.405  21.859  1.00 11.62           C  
ATOM    843  N   GLY A 109      10.907  14.837  21.736  1.00  8.93           N  
ATOM    844  CA  GLY A 109      11.970  14.328  22.602  1.00  9.32           C  
ATOM    845  C   GLY A 109      12.331  12.862  22.398  1.00  8.92           C  
ATOM    846  O   GLY A 109      13.277  12.374  23.017  1.00  9.76           O  
ATOM    847  N   LEU A 110      11.602  12.146  21.539  1.00  8.71           N  
ATOM    848  CA  LEU A 110      11.951  10.753  21.238  1.00  8.82           C  
ATOM    849  C   LEU A 110      13.319  10.725  20.555  1.00  9.11           C  
ATOM    850  O   LEU A 110      13.564  11.510  19.643  1.00  9.50           O  
ATOM    851  CB  LEU A 110      10.900  10.096  20.343  1.00  8.55           C  
ATOM    852  CG  LEU A 110      10.830   8.562  20.383  1.00  8.61           C  
ATOM    853  CD1 LEU A 110      10.247   8.082  21.695  1.00  9.31           C  
ATOM    854  CD2 LEU A 110      10.006   8.005  19.230  1.00  8.66           C  
ATOM    855  N   LYS A 111      14.199   9.833  20.999  1.00 10.27           N  
ATOM    856  CA  LYS A 111      15.588   9.804  20.516  1.00 11.31           C  
ATOM    857  C   LYS A 111      16.172   8.415  20.709  1.00 10.68           C  
ATOM    858  O   LYS A 111      15.958   7.813  21.754  1.00 10.42           O  
ATOM    859  CB  LYS A 111      16.471  10.757  21.334  1.00 12.98           C  
ATOM    860  CG  LYS A 111      16.285  12.236  21.147  1.00 17.00           C  
ATOM    861  CD  LYS A 111      17.253  12.984  22.059  1.00 21.01           C  
ATOM    862  CE  LYS A 111      16.913  14.457  22.189  1.00 22.51           C  
ATOM    863  NZ  LYS A 111      15.589  14.672  22.829  1.00 24.05           N  
ATOM    864  N   PRO A 112      16.950   7.913  19.735  1.00 10.28           N  
ATOM    865  CA  PRO A 112      17.156   8.425  18.388  1.00 10.02           C  
ATOM    866  C   PRO A 112      16.058   7.939  17.444  1.00  9.53           C  
ATOM    867  O   PRO A 112      15.473   6.879  17.681  1.00  9.62           O  
ATOM    868  CB  PRO A 112      18.508   7.824  18.001  1.00 10.25           C  
ATOM    869  CG  PRO A 112      18.564   6.536  18.739  1.00 10.79           C  
ATOM    870  CD  PRO A 112      17.756   6.704  19.992  1.00 10.45           C  
ATOM    871  N   VAL A 113      15.783   8.707  16.395  1.00  8.88           N  
ATOM    872  CA  VAL A 113      14.775   8.315  15.420  1.00  8.99           C  
ATOM    873  C   VAL A 113      15.354   8.327  14.016  1.00  8.54           C  
ATOM    874  O   VAL A 113      16.370   8.989  13.746  1.00  8.61           O  
ATOM    875  CB  VAL A 113      13.498   9.209  15.459  1.00  8.90           C  
ATOM    876  CG1 VAL A 113      12.902   9.272  16.859  1.00  9.70           C  
ATOM    877  CG2 VAL A 113      13.783  10.604  14.959  1.00  9.09           C  
ATOM    878  N   ALA A 114      14.688   7.607  13.120  1.00  8.25           N  
ATOM    879  CA  ALA A 114      15.059   7.583  11.721  1.00  8.35           C  
ATOM    880  C   ALA A 114      13.837   7.228  10.904  1.00  8.45           C  
ATOM    881  O   ALA A 114      12.803   6.842  11.449  1.00  8.61           O  
ATOM    882  CB  ALA A 114      16.170   6.573  11.486  1.00  8.58           C  
ATOM    883  N   HIS A 115      13.949   7.356   9.592  1.00  8.57           N  
ATOM    884  CA  HIS A 115      12.933   6.808   8.713  1.00  8.85           C  
ATOM    885  C   HIS A 115      13.605   6.093   7.545  1.00  8.67           C  
ATOM    886  O   HIS A 115      14.804   6.269   7.312  1.00  9.11           O  
ATOM    887  CB  HIS A 115      11.912   7.871   8.282  1.00  9.21           C  
ATOM    888  CG  HIS A 115      12.308   8.659   7.077  1.00  9.69           C  
ATOM    889  ND1 HIS A 115      13.480   9.380   6.988  1.00 11.28           N  
ATOM    890  CD2 HIS A 115      11.656   8.853   5.910  1.00  9.25           C  
ATOM    891  CE1 HIS A 115      13.539   9.970   5.807  1.00 10.87           C  
ATOM    892  NE2 HIS A 115      12.445   9.664   5.135  1.00 13.25           N  
ATOM    893  N   ILE A 116      12.840   5.257   6.849  1.00  8.76           N  
ATOM    894  CA  ILE A 116      13.383   4.437   5.771  1.00  9.53           C  
ATOM    895  C   ILE A 116      13.224   5.141   4.425  1.00  9.90           C  
ATOM    896  O   ILE A 116      12.110   5.414   3.976  1.00  9.33           O  
ATOM    897  CB  ILE A 116      12.713   3.042   5.723  1.00  9.43           C  
ATOM    898  CG1 ILE A 116      12.859   2.324   7.072  1.00  9.86           C  
ATOM    899  CG2 ILE A 116      13.304   2.196   4.581  1.00 10.24           C  
ATOM    900  CD1 ILE A 116      12.258   0.922   7.132  1.00  9.76           C  
ATOM    901  N   GLU A 117      14.353   5.420   3.778  1.00 11.03           N  
ATOM    902  CA  GLU A 117      14.343   6.033   2.457  1.00 12.19           C  
ATOM    903  C   GLU A 117      13.470   5.242   1.486  1.00 11.83           C  
ATOM    904  O   GLU A 117      13.610   4.027   1.357  1.00 11.79           O  
ATOM    905  CB  GLU A 117      15.767   6.149   1.912  1.00 13.18           C  
ATOM    906  CG  GLU A 117      15.893   7.052   0.682  1.00 16.24           C  
ATOM    907  CD  GLU A 117      17.334   7.414   0.349  1.00 20.00           C  
ATOM    908  OE1 GLU A 117      18.253   6.676   0.765  1.00 22.84           O  
ATOM    909  OE2 GLU A 117      17.545   8.437  -0.341  1.00 23.02           O  
ATOM    910  N   GLY A 118      12.553   5.948   0.831  1.00 11.42           N  
ATOM    911  CA  GLY A 118      11.677   5.358  -0.169  1.00 11.21           C  
ATOM    912  C   GLY A 118      10.550   4.497   0.372  1.00 10.73           C  
ATOM    913  O   GLY A 118       9.766   3.954  -0.395  1.00 11.00           O  
ATOM    914  N   GLY A 119      10.468   4.354   1.693  1.00 10.52           N  
ATOM    915  CA  GLY A 119       9.356   3.646   2.320  1.00  9.92           C  
ATOM    916  C   GLY A 119       9.253   2.169   1.986  1.00  9.84           C  
ATOM    917  O   GLY A 119      10.217   1.540   1.522  1.00 10.26           O  
ATOM    918  N   PHE A 120       8.068   1.623   2.222  1.00  9.66           N  
ATOM    919  CA  PHE A 120       7.805   0.224   1.966  1.00 10.46           C  
ATOM    920  C   PHE A 120       7.883  -0.106   0.477  1.00 10.43           C  
ATOM    921  O   PHE A 120       8.234  -1.225   0.112  1.00 10.47           O  
ATOM    922  CB  PHE A 120       6.445  -0.178   2.536  1.00 10.66           C  
ATOM    923  CG  PHE A 120       6.237  -1.659   2.594  1.00 11.52           C  
ATOM    924  CD1 PHE A 120       7.015  -2.451   3.436  1.00 13.27           C  
ATOM    925  CD2 PHE A 120       5.273  -2.270   1.806  1.00 13.21           C  
ATOM    926  CE1 PHE A 120       6.827  -3.836   3.490  1.00 13.98           C  
ATOM    927  CE2 PHE A 120       5.082  -3.649   1.858  1.00 14.90           C  
ATOM    928  CZ  PHE A 120       5.855  -4.427   2.703  1.00 14.35           C  
ATOM    929  N   GLY A 121       7.566   0.864  -0.380  1.00 10.38           N  
ATOM    930  CA  GLY A 121       7.697   0.681  -1.828  1.00 11.30           C  
ATOM    931  C   GLY A 121       9.119   0.314  -2.228  1.00 11.33           C  
ATOM    932  O   GLY A 121       9.340  -0.656  -2.968  1.00 11.61           O  
ATOM    933  N   ALA A 122      10.090   1.072  -1.726  1.00 11.55           N  
ATOM    934  CA  ALA A 122      11.504   0.787  -1.983  1.00 11.88           C  
ATOM    935  C   ALA A 122      11.967  -0.516  -1.325  1.00 11.69           C  
ATOM    936  O   ALA A 122      12.767  -1.263  -1.898  1.00 12.69           O  
ATOM    937  CB  ALA A 122      12.366   1.944  -1.524  1.00 11.73           C  
ATOM    938  N   TRP A 123      11.464  -0.772  -0.117  1.00 11.26           N  
ATOM    939  CA  TRP A 123      11.727  -2.017   0.609  1.00 11.05           C  
ATOM    940  C   TRP A 123      11.296  -3.225  -0.223  1.00 11.62           C  
ATOM    941  O   TRP A 123      12.069  -4.169  -0.412  1.00 11.93           O  
ATOM    942  CB  TRP A 123      10.973  -1.984   1.938  1.00  9.91           C  
ATOM    943  CG  TRP A 123      11.172  -3.160   2.847  1.00  9.08           C  
ATOM    944  CD1 TRP A 123      10.549  -4.369   2.769  1.00  9.41           C  
ATOM    945  CD2 TRP A 123      11.988  -3.200   4.020  1.00  7.92           C  
ATOM    946  NE1 TRP A 123      10.956  -5.178   3.801  1.00  9.16           N  
ATOM    947  CE2 TRP A 123      11.840  -4.484   4.583  1.00  8.28           C  
ATOM    948  CE3 TRP A 123      12.845  -2.281   4.641  1.00  8.76           C  
ATOM    949  CZ2 TRP A 123      12.503  -4.867   5.746  1.00  8.71           C  
ATOM    950  CZ3 TRP A 123      13.500  -2.661   5.795  1.00  8.85           C  
ATOM    951  CH2 TRP A 123      13.329  -3.944   6.333  1.00  8.61           C  
ATOM    952  N   ARG A 124      10.059  -3.191  -0.710  1.00 12.80           N  
ATOM    953  CA  ARG A 124       9.525  -4.236  -1.583  1.00 14.57           C  
ATOM    954  C   ARG A 124      10.323  -4.391  -2.880  1.00 14.87           C  
ATOM    955  O   ARG A 124      10.624  -5.519  -3.299  1.00 15.29           O  
ATOM    956  CB  ARG A 124       8.059  -3.945  -1.892  1.00 15.00           C  
ATOM    957  CG  ARG A 124       7.379  -4.982  -2.771  1.00 17.66           C  
ATOM    958  CD  ARG A 124       5.893  -4.703  -2.893  1.00 21.46           C  
ATOM    959  NE  ARG A 124       5.630  -3.383  -3.463  1.00 24.03           N  
ATOM    960  CZ  ARG A 124       4.442  -2.784  -3.462  1.00 25.27           C  
ATOM    961  NH1 ARG A 124       3.385  -3.382  -2.922  1.00 25.46           N  
ATOM    962  NH2 ARG A 124       4.307  -1.582  -4.006  1.00 26.23           N  
ATOM    963  N   ASP A 125      10.666  -3.269  -3.508  1.00 15.49           N  
ATOM    964  CA  ASP A 125      11.431  -3.291  -4.757  1.00 16.30           C  
ATOM    965  C   ASP A 125      12.794  -3.961  -4.582  1.00 16.18           C  
ATOM    966  O   ASP A 125      13.286  -4.622  -5.497  1.00 16.37           O  
ATOM    967  CB  ASP A 125      11.609  -1.877  -5.314  1.00 17.05           C  
ATOM    968  CG  ASP A 125      10.321  -1.294  -5.878  1.00 19.20           C  
ATOM    969  OD1 ASP A 125       9.361  -2.055  -6.135  1.00 22.10           O  
ATOM    970  OD2 ASP A 125      10.273  -0.060  -6.058  1.00 22.96           O  
ATOM    971  N   ALA A 126      13.388  -3.797  -3.401  1.00 15.78           N  
ATOM    972  CA  ALA A 126      14.689  -4.379  -3.082  1.00 15.68           C  
ATOM    973  C   ALA A 126      14.595  -5.842  -2.638  1.00 15.40           C  
ATOM    974  O   ALA A 126      15.618  -6.489  -2.395  1.00 15.94           O  
ATOM    975  CB  ALA A 126      15.383  -3.543  -2.017  1.00 15.89           C  
ATOM    976  N   GLY A 127      13.372  -6.354  -2.539  1.00 14.68           N  
ATOM    977  CA  GLY A 127      13.128  -7.728  -2.112  1.00 14.20           C  
ATOM    978  C   GLY A 127      13.284  -7.935  -0.617  1.00 13.53           C  
ATOM    979  O   GLY A 127      13.604  -9.036  -0.171  1.00 13.75           O  
ATOM    980  N   GLY A 128      13.036  -6.885   0.168  1.00 12.66           N  
ATOM    981  CA  GLY A 128      13.116  -6.977   1.627  1.00 12.09           C  
ATOM    982  C   GLY A 128      12.100  -7.932   2.233  1.00 11.67           C  
ATOM    983  O   GLY A 128      11.102  -8.262   1.593  1.00 12.38           O  
ATOM    984  N   PRO A 129      12.358  -8.398   3.469  1.00 11.18           N  
ATOM    985  CA  PRO A 129      11.418  -9.274   4.176  1.00 11.42           C  
ATOM    986  C   PRO A 129      10.010  -8.679   4.243  1.00 11.53           C  
ATOM    987  O   PRO A 129       9.845  -7.510   4.612  1.00 11.08           O  
ATOM    988  CB  PRO A 129      12.027  -9.376   5.579  1.00 11.43           C  
ATOM    989  CG  PRO A 129      13.488  -9.164   5.360  1.00 11.52           C  
ATOM    990  CD  PRO A 129      13.573  -8.142   4.263  1.00 11.01           C  
ATOM    991  N   ILE A 130       9.006  -9.469   3.874  1.00 12.12           N  
ATOM    992  CA  ILE A 130       7.617  -9.012   3.892  1.00 13.49           C  
ATOM    993  C   ILE A 130       6.719 -10.046   4.555  1.00 13.78           C  
ATOM    994  O   ILE A 130       6.835 -11.253   4.296  1.00 13.93           O  
ATOM    995  CB  ILE A 130       7.083  -8.684   2.471  1.00 13.93           C  
ATOM    996  CG1 ILE A 130       7.806  -7.468   1.883  1.00 15.61           C  
ATOM    997  CG2 ILE A 130       5.571  -8.415   2.499  1.00 14.44           C  
ATOM    998  CD1 ILE A 130       7.477  -7.202   0.423  1.00 18.60           C  
ATOM    999  N   GLU A 131       5.834  -9.559   5.417  1.00 14.11           N  
ATOM   1000  CA  GLU A 131       4.753 -10.357   5.974  1.00 15.01           C  
ATOM   1001  C   GLU A 131       3.437  -9.903   5.354  1.00 15.17           C  
ATOM   1002  O   GLU A 131       3.127  -8.707   5.333  1.00 15.24           O  
ATOM   1003  CB  GLU A 131       4.703 -10.203   7.492  1.00 15.49           C  
ATOM   1004  CG  GLU A 131       3.498 -10.875   8.142  1.00 17.36           C  
ATOM   1005  CD  GLU A 131       3.411 -10.616   9.629  1.00 20.83           C  
ATOM   1006  OE1 GLU A 131       4.419 -10.180  10.219  1.00 21.03           O  
ATOM   1007  OE2 GLU A 131       2.331 -10.853  10.207  1.00 22.89           O  
TER    1008      GLU A 131                                                      
END
MOLECULE T0411.pdb
ATOM      1  N   SER    20      23.383  16.708  14.252  0.80 17.27           N  
ATOM      2  CA  SER    20      23.666  15.746  13.160  0.80 15.92           C  
ATOM      3  C   SER    20      22.476  15.495  12.278  0.80 13.44           C  
ATOM      4  O   SER    20      21.317  15.511  12.700  0.80 15.60           O  
ATOM      5  CB  SER    20      24.215  14.417  13.698  0.80 17.48           C  
ATOM      6  OG  SER    20      23.257  13.716  14.438  0.80 22.08           O  
ATOM      7  N   ASN    21      22.790  15.226  11.033  0.80 11.57           N  
ATOM      8  CA  ASN    21      21.799  14.886  10.050  0.80 10.66           C  
ATOM      9  C   ASN    21      21.016  13.672  10.572  0.80 10.50           C  
ATOM     10  O   ASN    21      21.625  12.772  11.156  0.80 12.22           O  
ATOM     11  CB  ASN    21      22.527  14.565   8.733  0.80 10.39           C  
ATOM     12  CG  ASN    21      21.644  14.679   7.510  0.80 10.55           C  
ATOM     13  OD1 ASN    21      21.440  15.758   7.041  0.80 12.42           O  
ATOM     14  ND2 ASN    21      21.075  13.574   7.057  0.80 13.97           N  
ATOM     15  N   ILE    22      19.702  13.612  10.337  1.00 10.95           N  
ATOM     16  CA  ILE    22      18.928  12.460  10.733  1.00 11.03           C  
ATOM     17  C   ILE    22      19.511  11.260   9.987  1.00  9.32           C  
ATOM     18  O   ILE    22      19.727  11.303   8.764  1.00 10.99           O  
ATOM     19  CB  ILE    22      17.457  12.632  10.369  1.00 11.59           C  
ATOM     20  CG1 ILE    22      16.804  13.845  11.054  1.00 13.57           C  
ATOM     21  CG2 ILE    22      16.692  11.323  10.585  1.00 11.49           C  
ATOM     22  CD1 ILE    22      15.526  14.302  10.345  1.00 14.59           C  
ATOM     23  N   GLN    23      19.722  10.205  10.701  1.00 10.03           N  
ATOM     24  CA  GLN    23      20.202   9.026  10.107  1.00  7.97           C  
ATOM     25  C   GLN    23      19.164   8.505   9.136  1.00  6.39           C  
ATOM     26  O   GLN    23      17.996   8.376   9.487  1.00  8.10           O  
ATOM     27  CB  GLN    23      20.434   7.978  11.189  1.00 10.93           C  
ATOM     28  CG  GLN    23      20.924   6.641  10.664  1.00 14.01           C  
ATOM     29  CD  GLN    23      22.276   6.695   9.980  1.00 17.14           C  
ATOM     30  OE1 GLN    23      22.415   6.425   8.780  1.00 22.09           O  
ATOM     31  NE2 GLN    23      23.286   7.076  10.734  1.00 21.70           N  
ATOM     32  N   SER    24      19.580   8.181   7.926  1.00  6.02           N  
ATOM     33  CA  SER    24      18.730   7.632   6.909  0.50  5.38           C  
ATOM     35  C   SER    24      19.314   6.309   6.403  1.00  5.20           C  
ATOM     36  O   SER    24      20.540   6.139   6.354  1.00  6.34           O  
ATOM     37  CB  SER    24      18.620   8.604   5.752  0.50  6.73           C  
ATOM     39  OG  SER    24      19.903   8.982   5.331  0.50  6.31           O  
ATOM     41  N   TYR    25      18.430   5.409   5.975  1.00  4.90           N  
ATOM     42  CA  TYR    25      18.808   4.061   5.582  1.00  4.36           C  
ATOM     43  C   TYR    25      18.307   3.735   4.175  1.00  4.30           C  
ATOM     44  O   TYR    25      17.151   4.018   3.830  1.00  4.70           O  
ATOM     45  CB  TYR    25      18.244   3.055   6.559  1.00  4.48           C  
ATOM     46  CG  TYR    25      18.793   3.226   7.967  1.00  4.25           C  
ATOM     47  CD1 TYR    25      20.157   3.141   8.226  1.00  4.90           C  
ATOM     48  CD2 TYR    25      17.959   3.440   9.028  1.00  5.20           C  
ATOM     49  CE1 TYR    25      20.662   3.254   9.519  1.00  5.78           C  
ATOM     50  CE2 TYR    25      18.462   3.530  10.349  1.00  5.38           C  
ATOM     51  CZ  TYR    25      19.818   3.453  10.577  1.00  5.83           C  
ATOM     52  OH  TYR    25      20.352   3.513  11.834  1.00  7.58           O  
ATOM     53  N   SER    26      19.164   3.101   3.384  1.00  4.64           N  
ATOM     54  CA  SER    26      18.810   2.501   2.107  1.00  4.76           C  
ATOM     55  C   SER    26      18.144   1.145   2.296  1.00  4.12           C  
ATOM     56  O   SER    26      18.123   0.572   3.389  1.00  4.46           O  
ATOM     57  CB  SER    26      20.068   2.275   1.296  1.00  5.25           C  
ATOM     58  OG  SER    26      20.846   1.281   1.938  1.00  5.71           O  
ATOM     59  N   PHE    27      17.684   0.566   1.199  1.00  4.20           N  
ATOM     60  CA  PHE    27      17.183  -0.814   1.228  1.00  4.85           C  
ATOM     61  C   PHE    27      18.203  -1.781   1.840  1.00  4.15           C  
ATOM     62  O   PHE    27      17.863  -2.567   2.715  1.00  4.54           O  
ATOM     63  CB  PHE    27      16.840  -1.289  -0.187  1.00  4.65           C  
ATOM     64  CG  PHE    27      16.405  -2.720  -0.195  1.00  4.75           C  
ATOM     65  CD1 PHE    27      15.200  -3.108   0.378  1.00  5.63           C  
ATOM     66  CD2 PHE    27      17.199  -3.718  -0.775  1.00  5.22           C  
ATOM     67  CE1 PHE    27      14.812  -4.423   0.418  1.00  6.31           C  
ATOM     68  CE2 PHE    27      16.798  -5.031  -0.764  1.00  6.95           C  
ATOM     69  CZ  PHE    27      15.581  -5.385  -0.175  1.00  6.90           C  
ATOM     70  N   GLU    28      19.449  -1.741   1.365  1.00  4.46           N  
ATOM     71  CA  GLU    28      20.433  -2.657   1.884  1.00  4.55           C  
ATOM     72  C   GLU    28      20.686  -2.438   3.365  1.00  4.97           C  
ATOM     73  O   GLU    28      20.864  -3.396   4.146  1.00  5.45           O  
ATOM     74  CB  GLU    28      21.728  -2.584   1.075  1.00  5.35           C  
ATOM     75  CG  GLU    28      21.576  -3.230  -0.271  1.00  8.61           C  
ATOM     76  CD  GLU    28      21.516  -4.793  -0.207  1.00  7.80           C  
ATOM     77  OE1 GLU    28      22.246  -5.318   0.605  1.00 10.36           O  
ATOM     78  OE2 GLU    28      20.795  -5.361  -1.051  1.00 10.99           O  
ATOM     79  N   ASP    29      20.690  -1.170   3.804  1.00  4.63           N  
ATOM     80  CA  ASP    29      20.816  -0.894   5.215  1.00  5.09           C  
ATOM     81  C   ASP    29      19.659  -1.511   6.021  1.00  4.66           C  
ATOM     82  O   ASP    29      19.885  -2.069   7.101  1.00  5.52           O  
ATOM     83  CB  ASP    29      20.792   0.610   5.459  1.00  5.73           C  
ATOM     84  CG  ASP    29      21.998   1.390   4.943  1.00  5.96           C  
ATOM     85  OD1 ASP    29      23.097   0.801   4.810  1.00  9.45           O  
ATOM     86  OD2 ASP    29      21.791   2.606   4.675  1.00  6.58           O  
ATOM     87  N   MET    30      18.438  -1.378   5.486  1.00  4.52           N  
ATOM     88  CA  MET    30      17.275  -1.926   6.170  1.00  4.57           C  
ATOM     89  C   MET    30      17.290  -3.442   6.216  1.00  4.62           C  
ATOM     90  O   MET    30      16.909  -4.031   7.218  1.00  5.57           O  
ATOM     91  CB  MET    30      15.990  -1.409   5.534  1.00  4.62           C  
ATOM     92  CG  MET    30      15.744   0.062   5.760  1.00  4.73           C  
ATOM     93  SD  MET    30      15.580   0.571   7.603  0.90  5.90          SE  
ATOM     94  CE  MET    30      13.979  -0.293   7.946  1.00 10.68           C  
ATOM     95  N   LYS    31      17.771  -4.079   5.165  0.50  4.72           N  
ATOM     97  CA  LYS    31      17.941  -5.503   5.166  0.25  5.00           C  
ATOM    100  C   LYS    31      18.911  -5.892   6.320  0.50  4.65           C  
ATOM    102  O   LYS    31      18.659  -6.843   7.086  0.50  5.54           O  
ATOM    104  CB  LYS    31      18.436  -5.931   3.780  0.25  5.09           C  
ATOM    107  CG  LYS    31      18.633  -7.408   3.587  0.25  4.45           C  
ATOM    110  CD  LYS    31      19.621  -7.678   2.406  0.25  5.89           C  
ATOM    113  CE  LYS    31      18.982  -7.379   1.062  0.25  5.98           C  
ATOM    116  NZ  LYS    31      19.966  -7.513  -0.063  0.25  4.92           N  
ATOM    119  N   ARG    32      20.016  -5.189   6.457  0.80  5.55           N  
ATOM    121  CA  ARG    32      20.906  -5.475   7.551  0.80  7.17           C  
ATOM    123  C   ARG    32      20.232  -5.309   8.893  0.80  6.23           C  
ATOM    125  O   ARG    32      20.276  -6.181   9.765  0.80  7.14           O  
ATOM    127  CB  ARG    32      22.169  -4.635   7.440  0.80  8.36           C  
ATOM    129  CG  ARG    32      23.095  -5.165   6.360  0.80 11.35           C  
ATOM    131  CD  ARG    32      24.391  -4.363   6.278  0.80 15.69           C  
ATOM    133  NE  ARG    32      24.132  -3.113   5.578  0.80 22.23           N  
ATOM    135  CZ  ARG    32      24.689  -2.712   4.435  0.80 21.88           C  
ATOM    137  NH1 ARG    32      24.317  -1.537   3.898  0.80 19.62           N  
ATOM    139  NH2 ARG    32      25.626  -3.443   3.842  0.80 24.64           N  
ATOM    141  N   ILE    33      19.520  -4.204   9.045  1.00  5.62           N  
ATOM    142  CA  ILE    33      18.872  -3.915  10.333  1.00  5.84           C  
ATOM    143  C   ILE    33      17.838  -4.978  10.666  1.00  5.82           C  
ATOM    144  O   ILE    33      17.810  -5.485  11.796  1.00  6.61           O  
ATOM    145  CB  ILE    33      18.279  -2.507  10.301  1.00  6.44           C  
ATOM    146  CG1 ILE    33      19.414  -1.505  10.308  1.00  7.28           C  
ATOM    147  CG2 ILE    33      17.317  -2.274  11.453  1.00  8.16           C  
ATOM    148  CD1 ILE    33      18.996  -0.081   9.899  1.00  8.84           C  
ATOM    149  N   VAL    34      16.990  -5.341   9.707  1.00  5.88           N  
ATOM    150  CA  VAL    34      16.002  -6.368   9.967  1.00  6.66           C  
ATOM    151  C   VAL    34      16.670  -7.668  10.385  1.00  6.17           C  
ATOM    152  O   VAL    34      16.259  -8.310  11.351  1.00  7.34           O  
ATOM    153  CB  VAL    34      15.074  -6.537   8.746  1.00  7.43           C  
ATOM    154  CG1 VAL    34      14.163  -7.763   8.914  1.00  9.58           C  
ATOM    155  CG2 VAL    34      14.239  -5.264   8.563  1.00  8.70           C  
ATOM    156  N   GLY    35      17.738  -8.033   9.671  1.00  6.43           N  
ATOM    157  CA  GLY    35      18.439  -9.261   9.977  1.00  6.66           C  
ATOM    158  C   GLY    35      19.162  -9.306  11.311  1.00  6.57           C  
ATOM    159  O   GLY    35      19.486 -10.374  11.803  1.00  8.37           O  
ATOM    160  N   LYS    36      19.460  -8.140  11.881  1.00  6.29           N  
ATOM    161  CA  LYS    36      20.074  -8.045  13.201  0.25  6.74           C  
ATOM    164  C   LYS    36      19.111  -8.321  14.326  1.00  7.11           C  
ATOM    165  O   LYS    36      19.523  -8.692  15.430  1.00  8.42           O  
ATOM    166  CB  LYS    36      20.649  -6.659  13.450  0.25  7.30           C  
ATOM    169  CG  LYS    36      21.870  -6.372  12.639  0.25  7.35           C  
ATOM    172  CD  LYS    36      22.234  -4.913  12.683  0.25  7.90           C  
ATOM    175  CE  LYS    36      22.881  -4.526  14.003  0.25  6.97           C  
ATOM    178  NZ  LYS    36      23.143  -3.054  13.963  0.25  7.30           N  
ATOM    181  N   HIS    37      17.826  -8.110  14.096  1.00  7.61           N  
ATOM    182  CA  HIS    37      16.828  -8.314  15.165  1.00  8.62           C  
ATOM    183  C   HIS    37      17.270  -7.588  16.434  1.00  7.84           C  
ATOM    184  O   HIS    37      17.249  -8.164  17.524  1.00  8.43           O  
ATOM    185  CB  HIS    37      16.586  -9.818  15.436  1.00 10.04           C  
ATOM    186  CG  HIS    37      16.065 -10.524  14.232  1.00 11.70           C  
ATOM    187  ND1 HIS    37      14.752 -10.435  13.832  1.00 17.45           N  
ATOM    188  CD2 HIS    37      16.693 -11.224  13.259  1.00 12.70           C  
ATOM    189  CE1 HIS    37      14.590 -11.111  12.703  1.00 17.15           C  
ATOM    190  NE2 HIS    37      15.756 -11.604  12.337  1.00 14.42           N  
ATOM    191  N   ASP    38      17.670  -6.339  16.335  1.00  8.59           N  
ATOM    192  CA  ASP    38      18.203  -5.607  17.459  1.00  8.40           C  
ATOM    193  C   ASP    38      17.066  -5.247  18.402  1.00  8.57           C  
ATOM    194  O   ASP    38      16.109  -4.578  18.000  1.00  8.80           O  
ATOM    195  CB  ASP    38      18.850  -4.368  16.870  1.00 11.30           C  
ATOM    196  CG  ASP    38      19.619  -3.582  17.830  1.00 14.90           C  
ATOM    197  OD1 ASP    38      19.305  -3.575  19.031  1.00 13.89           O  
ATOM    198  OD2 ASP    38      20.525  -2.882  17.308  1.00 20.42           O  
ATOM    199  N   PRO    39      17.161  -5.670  19.671  1.00  9.42           N  
ATOM    200  CA  PRO    39      16.081  -5.410  20.604  1.00 10.88           C  
ATOM    201  C   PRO    39      15.866  -3.959  20.898  1.00 10.52           C  
ATOM    202  O   PRO    39      14.815  -3.569  21.460  1.00 13.03           O  
ATOM    203  CB  PRO    39      16.529  -6.159  21.854  1.00 11.33           C  
ATOM    204  CG  PRO    39      17.990  -6.224  21.786  1.00 12.34           C  
ATOM    205  CD  PRO    39      18.248  -6.420  20.316  1.00 11.01           C  
ATOM    206  N   ASN    40      16.849  -3.128  20.572  1.00  9.50           N  
ATOM    207  CA  ASN    40      16.758  -1.718  20.866  0.70  9.40           C  
ATOM    209  C   ASN    40      16.493  -0.844  19.622  1.00  8.33           C  
ATOM    210  O   ASN    40      16.728   0.358  19.653  1.00  8.99           O  
ATOM    211  CB  ASN    40      17.923  -1.351  21.740  0.70 11.15           C  
ATOM    213  CG  ASN    40      17.781  -1.941  23.175  0.70 12.91           C  
ATOM    215  OD1 ASN    40      16.695  -1.927  23.785  0.70 16.59           O  
ATOM    217  ND2 ASN    40      18.874  -2.447  23.692  0.70 19.60           N  
ATOM    219  N   VAL    41      15.951  -1.474  18.588  1.00  6.99           N  
ATOM    220  CA  VAL    41      15.496  -0.806  17.374  1.00  7.02           C  
ATOM    221  C   VAL    41      14.005  -1.096  17.203  1.00  5.94           C  
ATOM    222  O   VAL    41      13.545  -2.232  17.442  1.00  8.12           O  
ATOM    223  CB  VAL    41      16.280  -1.295  16.174  1.00  8.84           C  
ATOM    224  CG1 VAL    41      15.632  -0.818  14.857  1.00 11.68           C  
ATOM    225  CG2 VAL    41      17.745  -0.854  16.309  1.00 11.84           C  
ATOM    226  N   VAL    42      13.245  -0.066  16.842  1.00  5.37           N  
ATOM    227  CA  VAL    42      11.829  -0.165  16.581  1.00  5.48           C  
ATOM    228  C   VAL    42      11.588   0.308  15.157  1.00  4.86           C  
ATOM    229  O   VAL    42      12.012   1.394  14.793  1.00  5.55           O  
ATOM    230  CB  VAL    42      11.003   0.700  17.548  1.00  6.60           C  
ATOM    231  CG1 VAL    42       9.512   0.573  17.290  1.00  8.10           C  
ATOM    232  CG2 VAL    42      11.329   0.348  19.012  1.00  8.91           C  
ATOM    233  N   LEU    43      10.860  -0.510  14.397  0.50  4.63           N  
ATOM    235  CA  LEU    43      10.520  -0.219  12.994  0.50  4.37           C  
ATOM    237  C   LEU    43       9.110   0.354  12.991  0.50  3.98           C  
ATOM    239  O   LEU    43       8.134  -0.360  13.243  0.50  5.19           O  
ATOM    241  CB  LEU    43      10.568  -1.505  12.162  0.50  4.41           C  
ATOM    243  CG  LEU    43      11.927  -2.221  12.180  0.50  5.41           C  
ATOM    245  CD1 LEU    43      11.875  -3.496  11.343  0.50  8.93           C  
ATOM    247  CD2 LEU    43      13.037  -1.314  11.712  0.50  8.67           C  
ATOM    249  N   VAL    44       9.000   1.652  12.736  1.00  4.06           N  
ATOM    250  CA  VAL    44       7.740   2.378  12.881  1.00  4.25           C  
ATOM    251  C   VAL    44       7.147   2.669  11.506  1.00  3.95           C  
ATOM    252  O   VAL    44       7.555   3.581  10.806  1.00  4.41           O  
ATOM    253  CB  VAL    44       7.902   3.677  13.657  1.00  4.88           C  
ATOM    254  CG1 VAL    44       6.529   4.262  13.921  1.00  5.95           C  
ATOM    255  CG2 VAL    44       8.673   3.463  14.990  1.00  6.06           C  
ATOM    256  N   ASP    45       6.151   1.846  11.156  1.00  3.90           N  
ATOM    257  CA  ASP    45       5.442   1.950   9.890  1.00  3.71           C  
ATOM    258  C   ASP    45       4.191   2.777  10.142  1.00  3.91           C  
ATOM    259  O   ASP    45       3.299   2.388  10.900  1.00  4.37           O  
ATOM    260  CB  ASP    45       5.090   0.528   9.423  1.00  3.86           C  
ATOM    261  CG  ASP    45       4.448   0.448   8.065  1.00  4.16           C  
ATOM    262  OD1 ASP    45       3.766   1.386   7.622  1.00  4.52           O  
ATOM    263  OD2 ASP    45       4.619  -0.635   7.445  1.00  5.13           O  
ATOM    264  N   VAL    46       4.143   3.959   9.534  1.00  3.64           N  
ATOM    265  CA  VAL    46       3.064   4.909   9.809  1.00  3.77           C  
ATOM    266  C   VAL    46       2.029   4.957   8.685  1.00  4.00           C  
ATOM    267  O   VAL    46       1.222   5.882   8.626  1.00  4.07           O  
ATOM    268  CB  VAL    46       3.598   6.308  10.187  1.00  4.06           C  
ATOM    269  CG1 VAL    46       4.585   6.189  11.327  1.00  4.83           C  
ATOM    270  CG2 VAL    46       4.204   7.057   9.036  1.00  4.55           C  
ATOM    271  N   ARG    47       2.003   3.935   7.839  1.00  3.76           N  
ATOM    272  CA  ARG    47       0.884   3.772   6.921  1.00  3.93           C  
ATOM    273  C   ARG    47      -0.412   3.481   7.693  1.00  3.94           C  
ATOM    274  O   ARG    47      -0.403   3.207   8.893  1.00  4.15           O  
ATOM    275  CB  ARG    47       1.188   2.654   5.923  1.00  4.16           C  
ATOM    276  CG  ARG    47       2.367   2.950   5.015  1.00  4.41           C  
ATOM    277  CD  ARG    47       2.700   1.812   4.070  1.00  4.36           C  
ATOM    278  NE  ARG    47       3.029   0.614   4.852  1.00  4.91           N  
ATOM    279  CZ  ARG    47       2.867  -0.628   4.472  1.00  4.68           C  
ATOM    280  NH1 ARG    47       2.440  -0.932   3.273  1.00  6.72           N  
ATOM    281  NH2 ARG    47       3.136  -1.589   5.344  1.00  5.67           N  
ATOM    282  N   GLU    48      -1.532   3.555   6.981  1.00  4.09           N  
ATOM    283  CA  GLU    48      -2.806   3.203   7.583  1.00  4.53           C  
ATOM    284  C   GLU    48      -2.890   1.692   7.786  1.00  4.44           C  
ATOM    285  O   GLU    48      -2.183   0.927   7.132  1.00  4.87           O  
ATOM    286  CB  GLU    48      -3.978   3.702   6.752  1.00  4.95           C  
ATOM    287  CG  GLU    48      -4.072   5.230   6.741  1.00  5.30           C  
ATOM    288  CD  GLU    48      -4.203   5.796   8.148  1.00  5.46           C  
ATOM    289  OE1 GLU    48      -5.176   5.400   8.836  1.00  7.30           O  
ATOM    290  OE2 GLU    48      -3.321   6.546   8.603  1.00  5.88           O  
ATOM    291  N   PRO    49      -3.765   1.230   8.667  1.00  5.07           N  
ATOM    292  CA  PRO    49      -3.842  -0.216   8.944  1.00  5.88           C  
ATOM    293  C   PRO    49      -4.113  -1.065   7.703  1.00  5.59           C  
ATOM    294  O   PRO    49      -3.590  -2.164   7.577  1.00  6.38           O  
ATOM    295  CB  PRO    49      -4.937  -0.303  10.007  1.00  7.08           C  
ATOM    296  CG  PRO    49      -4.851   1.011  10.738  1.00  6.97           C  
ATOM    297  CD  PRO    49      -4.612   1.988   9.621  1.00  6.19           C  
ATOM    298  N   SER    50      -4.936  -0.567   6.778  1.00  6.07           N  
ATOM    299  CA  SER    50      -5.245  -1.286   5.570  1.00  6.89           C  
ATOM    300  C   SER    50      -4.005  -1.467   4.730  1.00  8.82           C  
ATOM    301  O   SER    50      -3.692  -2.647   4.387  1.00 11.66           O  
ATOM    302  CB  SER    50      -6.402  -0.583   4.864  1.00  8.18           C  
ATOM    303  OG  SER    50      -6.141   0.781   4.672  1.00  9.85           O  
ATOM    304  N   GLU    51      -3.183  -0.409   4.608  1.00  6.34           N  
ATOM    305  CA  GLU    51      -1.884  -0.514   3.894  1.00  6.38           C  
ATOM    306  C   GLU    51      -0.938  -1.517   4.559  1.00  6.84           C  
ATOM    307  O   GLU    51      -0.271  -2.363   3.937  1.00  9.87           O  
ATOM    308  CB  GLU    51      -1.187   0.833   3.816  1.00  6.45           C  
ATOM    309  CG  GLU    51      -1.825   1.884   2.936  1.00  6.93           C  
ATOM    310  CD  GLU    51      -1.213   3.265   3.116  1.00  6.09           C  
ATOM    311  OE1 GLU    51      -1.500   3.925   4.126  1.00  5.52           O  
ATOM    312  OE2 GLU    51      -0.401   3.683   2.254  1.00  7.55           O  
ATOM    313  N   TYR    52      -0.916  -1.495   5.874  0.50  6.32           N  
ATOM    315  CA  TYR    52      -0.057  -2.406   6.644  0.50  6.07           C  
ATOM    317  C   TYR    52      -0.470  -3.849   6.476  0.50  5.86           C  
ATOM    319  O   TYR    52       0.366  -4.768   6.534  0.50  7.51           O  
ATOM    321  CB  TYR    52      -0.144  -1.997   8.110  0.50  6.62           C  
ATOM    323  CG  TYR    52       0.892  -2.603   8.989  0.50  5.83           C  
ATOM    325  CD1 TYR    52       2.105  -1.968   9.173  0.50  6.83           C  
ATOM    327  CD2 TYR    52       0.642  -3.786   9.673  0.50  7.08           C  
ATOM    329  CE1 TYR    52       3.067  -2.478  10.005  0.50  5.81           C  
ATOM    331  CE2 TYR    52       1.565  -4.306  10.531  0.50  6.54           C  
ATOM    333  CZ  TYR    52       2.800  -3.670  10.674  0.50  5.84           C  
ATOM    335  OH  TYR    52       3.723  -4.245  11.535  0.50  7.40           O  
ATOM    337  N   SER    53      -1.764  -4.079   6.330  0.50  5.43           N  
ATOM    339  CA  SER    53      -2.219  -5.414   6.209  0.50  6.90           C  
ATOM    341  C   SER    53      -1.818  -5.969   4.833  0.50  6.17           C  
ATOM    343  O   SER    53      -1.635  -7.185   4.723  0.50  7.67           O  
ATOM    345  CB  SER    53      -3.697  -5.499   6.487  0.50  7.43           C  
ATOM    347  OG  SER    53      -4.418  -4.913   5.460  0.50 13.76           O  
ATOM    349  N   ILE    54      -1.678  -5.142   3.794  0.50  5.58           N  
ATOM    351  CA  ILE    54      -1.227  -5.645   2.484  0.50  5.83           C  
ATOM    353  C   ILE    54       0.166  -6.287   2.599  0.50  5.76           C  
ATOM    355  O   ILE    54       0.397  -7.379   2.078  0.50  6.45           O  
ATOM    357  CB  ILE    54      -1.212  -4.535   1.411  0.50  5.60           C  
ATOM    359  CG1 ILE    54      -2.635  -4.115   1.094  0.50  6.79           C  
ATOM    361  CG2 ILE    54      -0.463  -4.984   0.154  0.50  6.39           C  
ATOM    363  CD1 ILE    54      -2.804  -3.180   1.890  0.50  7.99           C  
ATOM    365  N   VAL    55       1.106  -5.554   3.200  0.50  5.87           N  
ATOM    367  CA  VAL    55       2.442  -6.139   3.379  0.50  7.15           C  
ATOM    369  C   VAL    55       3.172  -5.287   4.420  0.50  5.98           C  
ATOM    371  O   VAL    55       2.966  -4.089   4.462  0.50  7.84           O  
ATOM    373  CB  VAL    55       3.232  -6.295   2.008  0.50  7.51           C  
ATOM    375  CG1 VAL    55       4.737  -6.182   2.192  0.50  7.32           C  
ATOM    377  CG2 VAL    55       2.873  -7.584   1.140  0.50  6.68           C  
ATOM    379  N   HIS    56       4.011  -5.884   5.273  1.00  6.64           N  
ATOM    380  CA  HIS    56       4.737  -5.075   6.240  1.00  5.79           C  
ATOM    381  C   HIS    56       6.027  -5.801   6.574  1.00  6.24           C  
ATOM    382  O   HIS    56       6.199  -6.985   6.280  1.00  9.13           O  
ATOM    383  CB  HIS    56       3.907  -4.718   7.445  1.00  7.71           C  
ATOM    384  CG  HIS    56       3.388  -5.867   8.177  1.00  9.52           C  
ATOM    385  ND1 HIS    56       2.078  -6.258   8.044  1.00 11.75           N  
ATOM    386  CD2 HIS    56       3.958  -6.701   9.075  1.00 12.20           C  
ATOM    387  CE1 HIS    56       1.856  -7.287   8.843  1.00 15.12           C  
ATOM    388  NE2 HIS    56       2.981  -7.576   9.477  1.00 15.99           N  
ATOM    389  N   ILE    57       6.973  -5.068   7.148  1.00  6.13           N  
ATOM    390  CA  ILE    57       8.204  -5.694   7.595  1.00  6.83           C  
ATOM    391  C   ILE    57       7.907  -6.485   8.874  1.00  7.02           C  
ATOM    392  O   ILE    57       7.323  -5.947   9.816  1.00  6.76           O  
ATOM    393  CB  ILE    57       9.320  -4.677   7.801  1.00  7.12           C  
ATOM    394  CG1 ILE    57       9.588  -3.954   6.492  1.00  8.15           C  
ATOM    395  CG2 ILE    57      10.571  -5.370   8.357  1.00  8.78           C  
ATOM    396  CD1 ILE    57      10.670  -2.906   6.578  1.00  9.39           C  
ATOM    397  N   PRO    58       8.313  -7.760   8.977  1.00  9.09           N  
ATOM    398  CA  PRO    58       8.059  -8.494  10.204  1.00 10.43           C  
ATOM    399  C   PRO    58       8.647  -7.782  11.415  1.00 10.46           C  
ATOM    400  O   PRO    58       9.742  -7.269  11.374  1.00 10.73           O  
ATOM    401  CB  PRO    58       8.731  -9.853   9.936  1.00 12.37           C  
ATOM    402  CG  PRO    58       8.691 -10.013   8.501  1.00 13.37           C  
ATOM    403  CD  PRO    58       8.935  -8.605   7.965  1.00 10.81           C  
ATOM    404  N   ALA    59       7.887  -7.805  12.482  1.00 11.11           N  
ATOM    405  CA  ALA    59       8.284  -7.244  13.763  1.00 11.14           C  
ATOM    406  C   ALA    59       8.200  -5.727  13.826  1.00  9.23           C  
ATOM    407  O   ALA    59       8.397  -5.138  14.872  1.00 10.44           O  
ATOM    408  CB  ALA    59       9.698  -7.747  14.216  1.00 13.99           C  
ATOM    409  N   SER    60       7.815  -5.081  12.729  1.00  7.06           N  
ATOM    410  CA  SER    60       7.530  -3.662  12.795  1.00  6.07           C  
ATOM    411  C   SER    60       6.259  -3.429  13.583  1.00  6.01           C  
ATOM    412  O   SER    60       5.460  -4.349  13.789  1.00  8.98           O  
ATOM    413  CB  SER    60       7.393  -3.089  11.398  1.00  5.31           C  
ATOM    414  OG  SER    60       6.289  -3.649  10.675  1.00  5.74           O  
ATOM    415  N   ILE    61       6.068  -2.177  13.976  1.00  5.05           N  
ATOM    416  CA  ILE    61       4.824  -1.719  14.572  1.00  5.46           C  
ATOM    417  C   ILE    61       4.122  -0.783  13.606  1.00  5.12           C  
ATOM    418  O   ILE    61       4.739  -0.193  12.726  1.00  5.56           O  
ATOM    419  CB  ILE    61       5.039  -1.052  15.946  1.00  5.64           C  
ATOM    420  CG1 ILE    61       5.807   0.283  15.839  1.00  5.75           C  
ATOM    421  CG2 ILE    61       5.709  -2.048  16.890  1.00  7.78           C  
ATOM    422  CD1 ILE    61       5.872   1.051  17.154  1.00  6.86           C  
ATOM    423  N   ASN    62       2.803  -0.677  13.767  1.00  4.89           N  
ATOM    424  CA  ASN    62       2.000   0.213  12.928  1.00  4.46           C  
ATOM    425  C   ASN    62       1.446   1.326  13.813  1.00  4.77           C  
ATOM    426  O   ASN    62       0.697   1.089  14.746  1.00  5.91           O  
ATOM    427  CB  ASN    62       0.864  -0.577  12.297  1.00  5.06           C  
ATOM    428  CG  ASN    62       0.015   0.234  11.314  1.00  4.91           C  
ATOM    429  OD1 ASN    62      -1.194  -0.010  11.168  1.00  6.38           O  
ATOM    430  ND2 ASN    62       0.628   1.127  10.556  1.00  5.05           N  
ATOM    431  N   VAL    63       1.838   2.569  13.496  1.00  4.55           N  
ATOM    432  CA  VAL    63       1.373   3.747  14.230  1.00  4.66           C  
ATOM    433  C   VAL    63       0.883   4.753  13.178  1.00  4.33           C  
ATOM    434  O   VAL    63       1.630   5.624  12.737  1.00  4.71           O  
ATOM    435  CB  VAL    63       2.446   4.362  15.135  1.00  5.22           C  
ATOM    436  CG1 VAL    63       1.808   5.465  15.979  1.00  5.91           C  
ATOM    437  CG2 VAL    63       3.073   3.283  16.038  1.00  6.23           C  
ATOM    438  N   PRO    64      -0.344   4.573  12.704  1.00  4.83           N  
ATOM    439  CA  PRO    64      -0.790   5.313  11.517  1.00  4.78           C  
ATOM    440  C   PRO    64      -0.709   6.830  11.660  1.00  4.83           C  
ATOM    441  O   PRO    64      -1.275   7.421  12.588  1.00  6.06           O  
ATOM    442  CB  PRO    64      -2.251   4.860  11.361  1.00  5.14           C  
ATOM    443  CG  PRO    64      -2.277   3.459  11.971  1.00  5.58           C  
ATOM    444  CD  PRO    64      -1.339   3.569  13.143  1.00  5.10           C  
ATOM    445  N   TYR    65      -0.076   7.491  10.670  1.00  5.06           N  
ATOM    446  CA  TYR    65       0.092   8.927  10.739  1.00  5.19           C  
ATOM    447  C   TYR    65      -1.185   9.675  10.355  1.00  5.36           C  
ATOM    448  O   TYR    65      -1.579  10.595  11.046  1.00  7.60           O  
ATOM    449  CB  TYR    65       1.281   9.392   9.895  1.00  5.62           C  
ATOM    450  CG  TYR    65       1.492  10.869  10.029  1.00  6.04           C  
ATOM    451  CD1 TYR    65       2.015  11.401  11.191  1.00  7.21           C  
ATOM    452  CD2 TYR    65       1.139  11.743   9.009  1.00  8.62           C  
ATOM    453  CE1 TYR    65       2.153  12.796  11.360  1.00  9.84           C  
ATOM    454  CE2 TYR    65       1.266  13.094   9.180  1.00 11.40           C  
ATOM    455  CZ  TYR    65       1.774  13.607  10.349  1.00 11.36           C  
ATOM    456  OH  TYR    65       1.900  14.974  10.486  1.00 14.93           O  
ATOM    457  N   ARG    66      -1.813   9.271   9.256  1.00  5.70           N  
ATOM    458  CA  ARG    66      -3.018   9.939   8.772  1.00  5.86           C  
ATOM    459  C   ARG    66      -4.132   9.955   9.817  1.00  6.43           C  
ATOM    460  O   ARG    66      -4.778  10.980  10.033  1.00  7.67           O  
ATOM    461  CB  ARG    66      -3.515   9.278   7.485  1.00  7.66           C  
ATOM    462  CG  ARG    66      -2.882   9.831   6.219  1.00  9.54           C  
ATOM    463  CD  ARG    66      -3.332   9.054   4.992  0.80 10.84           C  
ATOM    464  NE  ARG    66      -4.733   9.306   4.668  0.80 12.36           N  
ATOM    465  CZ  ARG    66      -5.181  10.427   4.111  0.80 14.16           C  
ATOM    466  NH1 ARG    66      -4.337  11.405   3.812  0.80 15.06           N  
ATOM    467  NH2 ARG    66      -6.474  10.570   3.851  0.80 13.94           N  
ATOM    468  N   SER    67      -4.354   8.812  10.457  1.00  5.24           N  
ATOM    469  CA  SER    67      -5.410   8.673  11.435  1.00  6.08           C  
ATOM    470  C   SER    67      -4.985   8.938  12.877  1.00  5.88           C  
ATOM    471  O   SER    67      -5.865   9.124  13.718  1.00  7.16           O  
ATOM    472  CB  SER    67      -6.131   7.357  11.271  1.00  7.36           C  
ATOM    473  OG  SER    67      -5.238   6.289  11.344  1.00  7.49           O  
ATOM    474  N   HIS    68      -3.683   9.001  13.146  1.00  5.81           N  
ATOM    475  CA  HIS    68      -3.166   9.301  14.470  1.00  5.91           C  
ATOM    476  C   HIS    68      -1.916  10.180  14.349  1.00  6.23           C  
ATOM    477  O   HIS    68      -0.826   9.782  14.789  1.00  6.38           O  
ATOM    478  CB  HIS    68      -2.854   8.020  15.266  1.00  6.58           C  
ATOM    479  CG  HIS    68      -4.033   7.179  15.481  1.00  7.46           C  
ATOM    480  ND1 HIS    68      -4.919   7.414  16.510  1.00  9.92           N  
ATOM    481  CD2 HIS    68      -4.511   6.113  14.809  1.00  9.74           C  
ATOM    482  CE1 HIS    68      -5.871   6.505  16.481  1.00 11.96           C  
ATOM    483  NE2 HIS    68      -5.663   5.721  15.446  1.00 12.70           N  
ATOM    484  N   PRO    69      -2.026  11.385  13.790  1.00  6.13           N  
ATOM    485  CA  PRO    69      -0.813  12.188  13.545  1.00  7.07           C  
ATOM    486  C   PRO    69      -0.095  12.626  14.799  1.00  7.79           C  
ATOM    487  O   PRO    69       1.109  12.919  14.777  1.00  8.93           O  
ATOM    488  CB  PRO    69      -1.340  13.372  12.727  1.00  8.41           C  
ATOM    489  CG  PRO    69      -2.792  13.472  13.133  1.00  8.62           C  
ATOM    490  CD  PRO    69      -3.242  12.017  13.256  1.00  6.77           C  
ATOM    491  N   ASP    70      -0.849  12.745  15.889  1.00  7.90           N  
ATOM    492  CA  ASP    70      -0.346  13.087  17.215  1.00  8.22           C  
ATOM    493  C   ASP    70       0.132  11.927  18.035  1.00  7.09           C  
ATOM    494  O   ASP    70       0.483  12.131  19.181  1.00  7.91           O  
ATOM    495  CB  ASP    70      -1.478  13.778  18.044  1.00 10.32           C  
ATOM    496  CG  ASP    70      -2.756  12.887  18.175  1.00 12.66           C  
ATOM    497  OD1 ASP    70      -3.048  11.961  17.282  1.00 14.07           O  
ATOM    498  OD2 ASP    70      -3.526  13.205  19.139  1.00 16.93           O  
ATOM    499  N   ALA    71       0.154  10.710  17.485  1.00  6.89           N  
ATOM    500  CA  ALA    71       0.447   9.557  18.291  1.00  6.32           C  
ATOM    501  C   ALA    71       1.741   9.730  19.085  1.00  6.32           C  
ATOM    502  O   ALA    71       1.769   9.444  20.275  1.00  7.16           O  
ATOM    503  CB  ALA    71       0.578   8.305  17.425  1.00  6.74           C  
ATOM    504  N   PHE    72       2.802  10.196  18.434  1.00  6.20           N  
ATOM    505  CA  PHE    72       4.073  10.262  19.117  1.00  7.02           C  
ATOM    506  C   PHE    72       4.212  11.418  20.090  1.00  7.74           C  
ATOM    507  O   PHE    72       5.256  11.532  20.740  1.00 10.61           O  
ATOM    508  CB  PHE    72       5.243  10.170  18.140  1.00  7.43           C  
ATOM    509  CG  PHE    72       5.489   8.744  17.714  1.00  6.23           C  
ATOM    510  CD1 PHE    72       6.156   7.881  18.577  1.00  7.50           C  
ATOM    511  CD2 PHE    72       4.989   8.235  16.536  1.00  6.47           C  
ATOM    512  CE1 PHE    72       6.307   6.551  18.286  1.00  8.63           C  
ATOM    513  CE2 PHE    72       5.152   6.905  16.222  1.00  7.11           C  
ATOM    514  CZ  PHE    72       5.818   6.051  17.110  1.00  7.95           C  
ATOM    515  N   ALA    73       3.145  12.208  20.247  1.00  7.31           N  
ATOM    516  CA  ALA    73       3.045  13.231  21.275  1.00  7.83           C  
ATOM    517  C   ALA    73       2.231  12.763  22.470  1.00  8.56           C  
ATOM    518  O   ALA    73       2.118  13.492  23.459  1.00 10.70           O  
ATOM    519  CB  ALA    73       2.427  14.503  20.703  1.00  8.88           C  
ATOM    520  N   LEU    74       1.663  11.562  22.436  1.00  8.50           N  
ATOM    521  CA  LEU    74       0.816  11.092  23.525  1.00  8.80           C  
ATOM    522  C   LEU    74       1.620  10.491  24.656  1.00  9.91           C  
ATOM    523  O   LEU    74       2.640   9.858  24.443  1.00 10.83           O  
ATOM    524  CB  LEU    74      -0.150  10.018  22.995  1.00  8.41           C  
ATOM    525  CG  LEU    74      -1.070  10.473  21.874  1.00  8.90           C  
ATOM    526  CD1 LEU    74      -1.903   9.312  21.360  1.00  9.06           C  
ATOM    527  CD2 LEU    74      -1.951  11.640  22.293  1.00 11.36           C  
ATOM    528  N   ASP    75       1.115  10.654  25.867  1.00 11.38           N  
ATOM    529  CA  ASP    75       1.714   9.953  27.007  1.00 12.23           C  
ATOM    530  C   ASP    75       1.473   8.439  26.878  1.00 12.37           C  
ATOM    531  O   ASP    75       0.653   8.004  26.055  1.00 11.95           O  
ATOM    532  CB  ASP    75       1.199  10.509  28.320  1.00 13.44           C  
ATOM    533  CG  ASP    75      -0.207  10.092  28.612  1.00 14.52           C  
ATOM    534  OD1 ASP    75      -0.532   8.884  28.631  1.00 16.72           O  
ATOM    535  OD2 ASP    75      -1.035  10.981  28.899  1.00 19.77           O  
ATOM    536  N   PRO    76       2.218   7.611  27.630  1.00 12.93           N  
ATOM    537  CA  PRO    76       2.115   6.172  27.427  1.00 12.29           C  
ATOM    538  C   PRO    76       0.723   5.586  27.570  1.00 11.45           C  
ATOM    539  O   PRO    76       0.365   4.743  26.799  1.00 11.34           O  
ATOM    540  CB  PRO    76       3.095   5.570  28.451  1.00 14.68           C  
ATOM    541  CG  PRO    76       4.083   6.674  28.688  1.00 16.39           C  
ATOM    542  CD  PRO    76       3.253   7.942  28.619  1.00 14.93           C  
ATOM    543  N   LEU    77      -0.045   6.002  28.562  1.00 10.97           N  
ATOM    544  CA  LEU    77      -1.364   5.431  28.769  0.50 10.50           C  
ATOM    546  C   LEU    77      -2.304   5.801  27.614  1.00  9.42           C  
ATOM    547  O   LEU    77      -3.022   4.952  27.069  1.00 10.45           O  
ATOM    548  CB  LEU    77      -1.905   5.875  30.124  0.50 10.23           C  
ATOM    550  CG  LEU    77      -3.269   5.313  30.499  0.50 10.33           C  
ATOM    552  CD1 LEU    77      -3.195   3.841  30.874  0.50 14.10           C  
ATOM    554  CD2 LEU    77      -3.853   6.131  31.674  0.50 11.65           C  
ATOM    556  N   GLU    78      -2.276   7.058  27.222  1.00  9.30           N  
ATOM    557  CA  GLU    78      -3.131   7.528  26.153  1.00  8.89           C  
ATOM    558  C   GLU    78      -2.703   6.953  24.798  1.00  7.55           C  
ATOM    559  O   GLU    78      -3.558   6.630  23.968  1.00  8.67           O  
ATOM    560  CB  GLU    78      -3.136   9.070  26.108  1.00  9.48           C  
ATOM    561  CG  GLU    78      -4.079   9.689  25.083  1.00  9.79           C  
ATOM    562  CD  GLU    78      -5.572   9.520  25.386  1.00 10.38           C  
ATOM    563  OE1 GLU    78      -5.933   8.992  26.458  1.00 11.33           O  
ATOM    564  OE2 GLU    78      -6.367   9.941  24.556  1.00 13.54           O  
ATOM    565  N   PHE    79      -1.391   6.776  24.603  1.00  7.74           N  
ATOM    566  CA  PHE    79      -0.913   6.141  23.386  1.00  7.31           C  
ATOM    567  C   PHE    79      -1.551   4.750  23.236  1.00  7.50           C  
ATOM    568  O   PHE    79      -2.054   4.388  22.179  1.00  7.68           O  
ATOM    569  CB  PHE    79       0.607   6.044  23.434  1.00  7.67           C  
ATOM    570  CG  PHE    79       1.240   5.532  22.145  1.00  7.10           C  
ATOM    571  CD1 PHE    79       1.872   6.387  21.292  1.00  7.29           C  
ATOM    572  CD2 PHE    79       1.204   4.181  21.839  1.00  6.60           C  
ATOM    573  CE1 PHE    79       2.464   5.922  20.117  1.00  7.50           C  
ATOM    574  CE2 PHE    79       1.787   3.721  20.654  1.00  7.36           C  
ATOM    575  CZ  PHE    79       2.419   4.600  19.803  1.00  6.66           C  
ATOM    576  N   GLU    80      -1.492   3.937  24.285  0.90  8.14           N  
ATOM    578  CA  GLU    80      -2.037   2.611  24.153  0.90  8.94           C  
ATOM    580  C   GLU    80      -3.550   2.654  23.958  0.90  8.49           C  
ATOM    582  O   GLU    80      -4.090   1.869  23.167  0.90  9.26           O  
ATOM    584  CB  GLU    80      -1.626   1.736  25.323  0.90 10.94           C  
ATOM    586  CG  GLU    80      -1.923   0.274  25.125  0.90 12.87           C  
ATOM    588  CD  GLU    80      -3.316  -0.153  25.486  0.90 14.79           C  
ATOM    590  OE1 GLU    80      -4.032   0.611  26.163  0.90 15.76           O  
ATOM    592  OE2 GLU    80      -3.714  -1.266  25.086  0.90 19.69           O  
ATOM    594  N   LYS    81      -4.261   3.592  24.590  1.00  8.78           N  
ATOM    595  CA  LYS    81      -5.687   3.674  24.333  0.50  9.31           C  
ATOM    597  C   LYS    81      -5.995   4.025  22.884  1.00  8.87           C  
ATOM    598  O   LYS    81      -6.964   3.487  22.310  1.00 10.43           O  
ATOM    599  CB  LYS    81      -6.329   4.673  25.282  0.50  9.93           C  
ATOM    601  CG  LYS    81      -6.331   4.204  26.709  0.50 10.96           C  
ATOM    603  CD  LYS    81      -6.819   5.341  27.592  0.50 10.36           C  
ATOM    605  CE  LYS    81      -6.945   4.955  29.026  0.50 12.69           C  
ATOM    607  NZ  LYS    81      -7.100   6.159  29.871  0.50 14.18           N  
ATOM    609  N   GLN    82      -5.227   4.943  22.298  1.00  8.48           N  
ATOM    610  CA  GLN    82      -5.507   5.384  20.963  1.00  9.68           C  
ATOM    611  C   GLN    82      -5.016   4.414  19.894  1.00  9.17           C  
ATOM    612  O   GLN    82      -5.688   4.225  18.883  1.00 11.34           O  
ATOM    613  CB  GLN    82      -4.922   6.776  20.759  1.00  9.86           C  
ATOM    614  CG  GLN    82      -5.607   7.856  21.696  1.00 12.49           C  
ATOM    615  CD  GLN    82      -7.154   8.042  21.566  1.00 12.54           C  
ATOM    616  OE1 GLN    82      -7.666   7.875  20.483  1.00 15.24           O  
ATOM    617  NE2 GLN    82      -7.876   8.429  22.678  1.00 13.84           N  
ATOM    618  N   ILE    83      -3.822   3.860  20.083  1.00  8.72           N  
ATOM    619  CA  ILE    83      -3.164   3.062  19.059  1.00  9.26           C  
ATOM    620  C   ILE    83      -3.360   1.578  19.272  1.00  9.94           C  
ATOM    621  O   ILE    83      -3.348   0.837  18.311  1.00 13.92           O  
ATOM    622  CB  ILE    83      -1.645   3.402  19.021  1.00  9.41           C  
ATOM    623  CG1 ILE    83      -1.436   4.907  18.950  1.00  9.94           C  
ATOM    624  CG2 ILE    83      -0.943   2.713  17.844  1.00 11.05           C  
ATOM    625  CD1 ILE    83      -2.063   5.618  17.779  1.00 12.33           C  
ATOM    626  N   GLY    84      -3.539   1.147  20.507  1.00  9.29           N  
ATOM    627  CA  GLY    84      -3.753  -0.257  20.814  1.00  9.83           C  
ATOM    628  C   GLY    84      -2.526  -1.096  21.078  1.00  8.85           C  
ATOM    629  O   GLY    84      -2.663  -2.302  21.251  1.00 11.00           O  
ATOM    630  N   ILE    85      -1.352  -0.462  21.076  1.00  8.30           N  
ATOM    631  CA  ILE    85      -0.096  -1.089  21.387  1.00  8.21           C  
ATOM    632  C   ILE    85       0.649  -0.160  22.333  1.00  7.46           C  
ATOM    633  O   ILE    85       0.338   1.017  22.432  1.00  8.38           O  
ATOM    634  CB  ILE    85       0.740  -1.363  20.121  1.00  8.29           C  
ATOM    635  CG1 ILE    85       1.120  -0.054  19.416  1.00  9.73           C  
ATOM    636  CG2 ILE    85      -0.003  -2.340  19.247  1.00 10.74           C  
ATOM    637  CD1 ILE    85       2.112  -0.267  18.259  1.00  9.86           C  
ATOM    638  N   PRO    86       1.667  -0.664  23.035  1.00  8.01           N  
ATOM    639  CA  PRO    86       2.420   0.178  23.961  1.00  8.48           C  
ATOM    640  C   PRO    86       3.224   1.241  23.235  1.00  7.80           C  
ATOM    641  O   PRO    86       3.724   1.044  22.119  1.00  8.34           O  
ATOM    642  CB  PRO    86       3.371  -0.806  24.686  1.00  9.49           C  
ATOM    643  CG  PRO    86       2.688  -2.111  24.531  1.00 10.38           C  
ATOM    644  CD  PRO    86       2.083  -2.063  23.155  1.00  9.31           C  
ATOM    645  N   LYS    87       3.379   2.362  23.912  1.00  7.88           N  
ATOM    646  CA  LYS    87       4.205   3.432  23.386  0.80  7.54           C  
ATOM    648  C   LYS    87       5.662   2.981  23.347  1.00  7.42           C  
ATOM    649  O   LYS    87       6.183   2.482  24.333  1.00  9.42           O  
ATOM    650  CB  LYS    87       4.082   4.659  24.274  0.80  8.13           C  
ATOM    652  CG  LYS    87       4.787   5.864  23.700  0.80  8.63           C  
ATOM    654  CD  LYS    87       4.604   7.123  24.546  0.80  9.77           C  
ATOM    656  CE  LYS    87       5.343   8.336  23.983  0.80 10.65           C  
ATOM    658  NZ  LYS    87       5.318   9.490  24.914  0.80 11.03           N  
ATOM    660  N   PRO    88       6.331   3.144  22.204  1.00  7.30           N  
ATOM    661  CA  PRO    88       7.716   2.702  22.136  1.00  7.45           C  
ATOM    662  C   PRO    88       8.601   3.365  23.170  1.00  7.42           C  
ATOM    663  O   PRO    88       8.466   4.563  23.469  1.00  7.76           O  
ATOM    664  CB  PRO    88       8.143   3.094  20.709  1.00  7.68           C  
ATOM    665  CG  PRO    88       6.881   3.004  19.944  1.00  7.88           C  
ATOM    666  CD  PRO    88       5.839   3.552  20.883  1.00  7.34           C  
ATOM    667  N   ASP    89       9.566   2.605  23.642  1.00  7.78           N  
ATOM    668  CA  ASP    89      10.569   3.092  24.598  1.00  8.01           C  
ATOM    669  C   ASP    89      11.435   4.166  23.945  1.00  8.28           C  
ATOM    670  O   ASP    89      12.072   3.906  22.923  1.00  8.32           O  
ATOM    671  CB  ASP    89      11.394   1.859  24.977  1.00  8.92           C  
ATOM    672  CG  ASP    89      12.533   2.113  25.924  1.00 10.72           C  
ATOM    673  OD1 ASP    89      12.864   3.262  26.257  1.00 11.95           O  
ATOM    674  OD2 ASP    89      13.097   1.085  26.356  1.00 14.30           O  
ATOM    675  N   SER    90      11.500   5.358  24.568  1.00  9.48           N  
ATOM    676  CA  SER    90      12.265   6.445  23.983  1.00 10.63           C  
ATOM    677  C   SER    90      13.765   6.240  23.999  1.00  9.42           C  
ATOM    678  O   SER    90      14.475   6.999  23.351  1.00 11.63           O  
ATOM    679  CB  SER    90      11.887   7.770  24.542  1.00 12.89           C  
ATOM    680  OG  SER    90      12.243   7.774  25.888  1.00 16.17           O  
ATOM    681  N   ALA    91      14.256   5.246  24.718  1.00  8.51           N  
ATOM    682  CA  ALA    91      15.673   4.933  24.711  1.00  9.11           C  
ATOM    683  C   ALA    91      16.074   4.196  23.446  1.00  9.07           C  
ATOM    684  O   ALA    91      17.265   4.072  23.186  1.00 11.24           O  
ATOM    685  CB  ALA    91      16.038   4.059  25.935  1.00 11.22           C  
ATOM    686  N   LYS    92      15.119   3.662  22.690  1.00  7.03           N  
ATOM    687  CA  LYS    92      15.414   2.895  21.501  0.80  6.87           C  
ATOM    689  C   LYS    92      15.581   3.804  20.298  1.00  6.20           C  
ATOM    690  O   LYS    92      15.169   4.952  20.297  1.00  7.57           O  
ATOM    691  CB  LYS    92      14.282   1.913  21.255  0.80  6.68           C  
ATOM    693  CG  LYS    92      14.211   0.818  22.325  0.80  7.06           C  
ATOM    695  CD  LYS    92      13.161  -0.217  21.984  0.80  8.08           C  
ATOM    697  CE  LYS    92      12.977  -1.320  23.013  0.80  8.53           C  
ATOM    699  NZ  LYS    92      11.985  -2.316  22.548  0.80 11.35           N  
ATOM    701  N   GLU    93      16.183   3.243  19.247  1.00  5.90           N  
ATOM    702  CA  GLU    93      16.205   3.883  17.943  1.00  5.79           C  
ATOM    703  C   GLU    93      14.889   3.566  17.219  1.00  5.43           C  
ATOM    704  O   GLU    93      14.588   2.397  16.996  1.00  7.19           O  
ATOM    705  CB  GLU    93      17.352   3.361  17.083  1.00  6.18           C  
ATOM    706  CG  GLU    93      17.389   3.990  15.724  1.00  6.50           C  
ATOM    707  CD  GLU    93      18.444   3.443  14.778  1.00  6.24           C  
ATOM    708  OE1 GLU    93      19.138   2.477  15.111  1.00  9.44           O  
ATOM    709  OE2 GLU    93      18.548   3.999  13.660  1.00  8.01           O  
ATOM    710  N   LEU    94      14.129   4.590  16.868  1.00  5.30           N  
ATOM    711  CA  LEU    94      12.891   4.411  16.116  1.00  4.81           C  
ATOM    712  C   LEU    94      13.163   4.809  14.664  1.00  4.73           C  
ATOM    713  O   LEU    94      13.650   5.920  14.412  1.00  5.65           O  
ATOM    714  CB  LEU    94      11.770   5.294  16.661  1.00  5.24           C  
ATOM    715  CG  LEU    94      10.963   4.701  17.820  1.00  5.62           C  
ATOM    716  CD1 LEU    94      11.836   4.382  19.069  1.00  7.25           C  
ATOM    717  CD2 LEU    94       9.819   5.638  18.164  1.00  6.54           C  
ATOM    718  N   ILE    95      12.858   3.911  13.738  1.00  4.22           N  
ATOM    719  CA  ILE    95      13.091   4.118  12.314  1.00  4.07           C  
ATOM    720  C   ILE    95      11.732   4.295  11.644  1.00  3.87           C  
ATOM    721  O   ILE    95      10.928   3.375  11.649  1.00  4.97           O  
ATOM    722  CB  ILE    95      13.833   2.949  11.678  1.00  4.36           C  
ATOM    723  CG1 ILE    95      15.110   2.625  12.432  1.00  5.35           C  
ATOM    724  CG2 ILE    95      14.112   3.267  10.202  1.00  5.16           C  
ATOM    725  CD1 ILE    95      15.873   1.393  11.877  1.00  6.26           C  
ATOM    726  N   PHE    96      11.484   5.473  11.080  1.00  4.13           N  
ATOM    727  CA  PHE    96      10.177   5.827  10.575  1.00  4.04           C  
ATOM    728  C   PHE    96      10.083   5.688   9.061  1.00  4.15           C  
ATOM    729  O   PHE    96      11.003   6.076   8.322  1.00  4.70           O  
ATOM    730  CB  PHE    96       9.885   7.294  10.893  1.00  4.72           C  
ATOM    731  CG  PHE    96       9.654   7.529  12.339  1.00  5.07           C  
ATOM    732  CD1 PHE    96       8.369   7.496  12.872  1.00  6.51           C  
ATOM    733  CD2 PHE    96      10.724   7.742  13.206  1.00  5.56           C  
ATOM    734  CE1 PHE    96       8.177   7.695  14.230  1.00  7.88           C  
ATOM    735  CE2 PHE    96      10.517   7.917  14.571  1.00  6.93           C  
ATOM    736  CZ  PHE    96       9.247   7.863  15.061  1.00  7.62           C  
ATOM    737  N   TYR    97       8.931   5.210   8.592  1.00  3.99           N  
ATOM    738  CA  TYR    97       8.671   5.113   7.146  1.00  3.91           C  
ATOM    739  C   TYR    97       7.169   4.947   6.933  1.00  3.74           C  
ATOM    740  O   TYR    97       6.413   4.602   7.837  1.00  3.98           O  
ATOM    741  CB  TYR    97       9.448   3.952   6.517  1.00  4.23           C  
ATOM    742  CG  TYR    97       9.224   2.625   7.182  1.00  4.19           C  
ATOM    743  CD1 TYR    97       8.214   1.771   6.749  1.00  4.31           C  
ATOM    744  CD2 TYR    97      10.004   2.192   8.242  1.00  4.31           C  
ATOM    745  CE1 TYR    97       7.995   0.562   7.342  1.00  4.59           C  
ATOM    746  CE2 TYR    97       9.792   0.986   8.870  1.00  4.85           C  
ATOM    747  CZ  TYR    97       8.791   0.143   8.414  1.00  4.56           C  
ATOM    748  OH  TYR    97       8.607  -1.063   9.024  1.00  5.52           O  
ATOM    749  N   CYS    98       6.783   5.140   5.676  1.00  3.72           N  
ATOM    750  CA  CYS    98       5.397   4.924   5.250  1.00  3.59           C  
ATOM    751  C   CYS    98       5.423   4.123   3.933  1.00  3.45           C  
ATOM    752  O   CYS    98       5.981   3.034   3.901  1.00  3.84           O  
ATOM    753  CB  CYS    98       4.589   6.248   5.230  1.00  4.07           C  
ATOM    754  SG  CYS    98       5.270   7.526   4.165  1.00  4.60           S  
ATOM    755  N   ALA    99       4.783   4.671   2.880  1.00  3.83           N  
ATOM    756  CA  ALA    99       4.796   4.067   1.537  1.00  3.72           C  
ATOM    757  C   ALA    99       5.854   4.781   0.691  1.00  3.81           C  
ATOM    758  O   ALA    99       6.824   4.156   0.284  1.00  4.15           O  
ATOM    759  CB  ALA    99       3.424   4.128   0.902  1.00  5.74           C  
ATOM    760  N   SER   100       5.676   6.088   0.457  1.00  4.26           N  
ATOM    761  CA  SER   100       6.620   6.835  -0.338  1.00  4.84           C  
ATOM    762  C   SER   100       7.540   7.758   0.462  1.00  4.52           C  
ATOM    763  O   SER   100       8.467   8.328  -0.107  1.00  5.77           O  
ATOM    764  CB  SER   100       5.938   7.644  -1.446  1.00  6.55           C  
ATOM    765  OG  SER   100       5.015   8.529  -0.959  1.00  8.80           O  
ATOM    766  N   GLY   101       7.314   7.906   1.771  1.00  4.88           N  
ATOM    767  CA  GLY   101       8.192   8.612   2.672  1.00  5.06           C  
ATOM    768  C   GLY   101       7.637   9.843   3.357  1.00  4.71           C  
ATOM    769  O   GLY   101       8.158  10.230   4.392  1.00  5.18           O  
ATOM    770  N   LYS   102       6.632  10.512   2.802  1.00  5.31           N  
ATOM    771  CA  LYS   102       6.226  11.814   3.373  1.00  6.25           C  
ATOM    772  C   LYS   102       5.700  11.667   4.789  1.00  5.42           C  
ATOM    773  O   LYS   102       6.060  12.433   5.699  1.00  6.42           O  
ATOM    774  CB  LYS   102       5.200  12.508   2.515  1.00  8.24           C  
ATOM    775  CG  LYS   102       4.808  13.881   3.067  1.00 10.22           C  
ATOM    776  CD  LYS   102       3.960  14.679   2.127  0.50 10.43           C  
ATOM    777  CE  LYS   102       3.301  15.880   2.790  0.50 13.54           C  
ATOM    778  NZ  LYS   102       2.750  16.816   1.809  0.50 16.32           N  
ATOM    779  N   ARG   103       4.762  10.724   4.983  1.00  4.79           N  
ATOM    780  CA  ARG   103       4.191  10.545   6.297  1.00  4.54           C  
ATOM    781  C   ARG   103       5.241  10.072   7.294  1.00  4.28           C  
ATOM    782  O   ARG   103       5.224  10.482   8.458  1.00  5.11           O  
ATOM    783  CB  ARG   103       3.024   9.571   6.249  1.00  4.67           C  
ATOM    784  CG  ARG   103       1.852  10.087   5.414  1.00  5.46           C  
ATOM    785  CD  ARG   103       0.837   9.001   5.183  1.00  5.48           C  
ATOM    786  NE  ARG   103       1.316   7.999   4.254  1.00  5.57           N  
ATOM    787  CZ  ARG   103       0.726   6.850   3.969  1.00  5.15           C  
ATOM    788  NH1 ARG   103      -0.286   6.420   4.709  1.00  4.82           N  
ATOM    789  NH2 ARG   103       1.152   6.098   2.963  1.00  6.22           N  
ATOM    790  N   GLY   104       6.137   9.177   6.867  1.00  4.65           N  
ATOM    791  CA  GLY   104       7.238   8.775   7.731  1.00  4.55           C  
ATOM    792  C   GLY   104       8.055   9.972   8.228  1.00  4.53           C  
ATOM    793  O   GLY   104       8.400  10.055   9.396  1.00  5.29           O  
ATOM    794  N   GLY   105       8.347  10.892   7.330  1.00  4.88           N  
ATOM    795  CA  GLY   105       9.103  12.061   7.706  1.00  5.31           C  
ATOM    796  C   GLY   105       8.352  12.934   8.699  1.00  5.73           C  
ATOM    797  O   GLY   105       8.940  13.479   9.652  1.00  6.59           O  
ATOM    798  N   GLU   106       7.047  13.085   8.492  1.00  5.79           N  
ATOM    799  CA  GLU   106       6.205  13.877   9.404  0.50  5.78           C  
ATOM    801  C   GLU   106       6.175  13.251  10.786  1.00  6.15           C  
ATOM    802  O   GLU   106       6.249  13.937  11.814  1.00  6.87           O  
ATOM    803  CB  GLU   106       4.765  13.993   8.877  0.50  6.72           C  
ATOM    805  CG  GLU   106       4.634  14.891   7.660  0.50  8.74           C  
ATOM    807  CD  GLU   106       5.250  16.297   7.896  0.50 14.10           C  
ATOM    809  OE1 GLU   106       4.916  16.926   8.912  0.50 16.14           O  
ATOM    811  OE2 GLU   106       6.111  16.740   7.110  0.50 19.81           O  
ATOM    813  N   ALA   107       5.983  11.939  10.825  1.00  5.63           N  
ATOM    814  CA  ALA   107       5.923  11.239  12.109  1.00  5.97           C  
ATOM    815  C   ALA   107       7.241  11.310  12.844  1.00  5.28           C  
ATOM    816  O   ALA   107       7.269  11.486  14.078  1.00  6.07           O  
ATOM    817  CB  ALA   107       5.495   9.790  11.883  1.00  5.83           C  
ATOM    818  N   GLN   108       8.352  11.222  12.129  1.00  5.35           N  
ATOM    819  CA  GLN   108       9.671  11.355  12.746  0.70  5.95           C  
ATOM    821  C   GLN   108       9.785  12.708  13.434  1.00  6.34           C  
ATOM    822  O   GLN   108      10.346  12.803  14.531  1.00  7.57           O  
ATOM    823  CB  GLN   108      10.782  11.166  11.705  0.70  5.79           C  
ATOM    825  CG  GLN   108      12.180  11.200  12.277  0.70  6.62           C  
ATOM    827  CD  GLN   108      12.804  12.599  12.514  0.70  7.05           C  
ATOM    829  OE1 GLN   108      13.714  12.746  13.386  0.70  9.86           O  
ATOM    831  NE2 GLN   108      12.353  13.592  11.818  0.70  6.57           N  
ATOM    833  N   LYS   109       9.268  13.749  12.815  1.00  6.66           N  
ATOM    834  CA  LYS   109       9.332  15.086  13.406  1.00  7.47           C  
ATOM    835  C   LYS   109       8.516  15.163  14.677  1.00  6.95           C  
ATOM    836  O   LYS   109       8.923  15.820  15.652  1.00  8.43           O  
ATOM    837  CB  LYS   109       8.865  16.128  12.410  1.00  8.40           C  
ATOM    838  CG  LYS   109       9.899  16.414  11.334  1.00 11.98           C  
ATOM    839  CD  LYS   109       9.420  17.302  10.199  1.00 13.99           C  
ATOM    840  CE  LYS   109      10.580  17.684   9.279  0.80 14.86           C  
ATOM    841  NZ  LYS   109      10.223  18.249   7.939  0.80 18.08           N  
ATOM    842  N   VAL   110       7.334  14.526  14.696  1.00  6.46           N  
ATOM    843  CA  VAL   110       6.543  14.498  15.923  1.00  7.30           C  
ATOM    844  C   VAL   110       7.335  13.809  17.030  1.00  6.59           C  
ATOM    845  O   VAL   110       7.450  14.315  18.141  1.00  7.66           O  
ATOM    846  CB  VAL   110       5.179  13.805  15.707  1.00  6.81           C  
ATOM    847  CG1 VAL   110       4.413  13.739  17.034  1.00  7.86           C  
ATOM    848  CG2 VAL   110       4.360  14.519  14.638  1.00  8.53           C  
ATOM    849  N   ALA   111       7.878  12.634  16.736  1.00  6.25           N  
ATOM    850  CA  ALA   111       8.587  11.898  17.775  1.00  6.44           C  
ATOM    851  C   ALA   111       9.813  12.662  18.294  1.00  6.55           C  
ATOM    852  O   ALA   111      10.037  12.764  19.497  1.00  7.23           O  
ATOM    853  CB  ALA   111       9.000  10.502  17.233  1.00  6.91           C  
ATOM    854  N   SER   112      10.597  13.198  17.371  1.00  6.91           N  
ATOM    855  CA  SER   112      11.838  13.856  17.755  0.50  7.97           C  
ATOM    857  C   SER   112      11.569  15.119  18.578  1.00  8.71           C  
ATOM    858  O   SER   112      12.402  15.486  19.385  1.00 11.07           O  
ATOM    859  CB  SER   112      12.717  14.152  16.530  0.50  8.49           C  
ATOM    861  OG  SER   112      12.096  15.095  15.671  0.50  9.64           O  
ATOM    863  N   SER   113      10.403  15.745  18.391  1.00  8.30           N  
ATOM    864  CA  SER   113       9.935  16.916  19.134  0.50  9.12           C  
ATOM    866  C   SER   113       9.259  16.563  20.456  1.00  8.56           C  
ATOM    867  O   SER   113       8.882  17.467  21.204  1.00  9.94           O  
ATOM    868  CB  SER   113       8.898  17.677  18.288  0.50 10.45           C  
ATOM    870  OG  SER   113       9.490  18.283  17.156  0.50 15.37           O  
ATOM    872  N   HIS   114       9.023  15.281  20.705  1.00  7.79           N  
ATOM    873  CA  HIS   114       8.324  14.809  21.885  1.00  7.83           C  
ATOM    874  C   HIS   114       9.069  13.713  22.609  1.00  8.28           C  
ATOM    875  O   HIS   114       8.496  12.745  23.090  1.00  9.87           O  
ATOM    876  CB  HIS   114       6.869  14.400  21.562  1.00  8.35           C  
ATOM    877  CG  HIS   114       6.066  15.538  21.049  1.00  8.39           C  
ATOM    878  ND1 HIS   114       5.234  16.370  21.762  1.00 12.03           N  
ATOM    879  CD2 HIS   114       6.042  15.973  19.773  1.00  7.75           C  
ATOM    880  CE1 HIS   114       4.721  17.262  20.921  1.00 10.24           C  
ATOM    881  NE2 HIS   114       5.197  17.037  19.714  1.00 13.52           N  
ATOM    882  N   GLY   115      10.379  13.904  22.750  1.00  8.04           N  
ATOM    883  CA  GLY   115      11.136  13.101  23.678  1.00  8.92           C  
ATOM    884  C   GLY   115      11.885  11.910  23.143  1.00  8.53           C  
ATOM    885  O   GLY   115      12.534  11.202  23.936  1.00 10.87           O  
ATOM    886  N   TYR   116      11.865  11.699  21.818  1.00  7.42           N  
ATOM    887  CA  TYR   116      12.617  10.613  21.237  1.00  7.88           C  
ATOM    888  C   TYR   116      13.886  11.204  20.645  1.00  8.36           C  
ATOM    889  O   TYR   116      13.867  11.829  19.596  1.00  9.94           O  
ATOM    890  CB  TYR   116      11.822   9.904  20.128  1.00  7.27           C  
ATOM    891  CG  TYR   116      10.689   9.086  20.672  1.00  7.06           C  
ATOM    892  CD1 TYR   116      10.880   7.750  20.961  1.00  7.23           C  
ATOM    893  CD2 TYR   116       9.420   9.641  20.909  1.00  7.09           C  
ATOM    894  CE1 TYR   116       9.852   6.944  21.464  1.00  7.42           C  
ATOM    895  CE2 TYR   116       8.399   8.858  21.410  1.00  7.13           C  
ATOM    896  CZ  TYR   116       8.609   7.514  21.683  1.00  7.28           C  
ATOM    897  OH  TYR   116       7.548   6.756  22.143  1.00  8.85           O  
ATOM    898  N   SER   117      15.012  10.963  21.308  1.00  9.24           N  
ATOM    899  CA  SER   117      16.310  11.508  20.932  0.50  9.26           C  
ATOM    901  C   SER   117      17.024  10.669  19.883  1.00  9.18           C  
ATOM    902  O   SER   117      18.034  11.122  19.359  1.00 10.73           O  
ATOM    903  CB  SER   117      17.222  11.640  22.154  0.50 10.04           C  
ATOM    905  OG  SER   117      17.610  10.398  22.671  0.50 12.56           O  
ATOM    907  N   ASN   118      16.547   9.429  19.632  1.00  7.59           N  
ATOM    908  CA  ASN   118      17.230   8.515  18.705  1.00  7.19           C  
ATOM    909  C   ASN   118      16.214   8.080  17.660  1.00  6.53           C  
ATOM    910  O   ASN   118      15.453   7.130  17.866  1.00  7.15           O  
ATOM    911  CB  ASN   118      17.828   7.313  19.399  1.00  8.35           C  
ATOM    912  CG  ASN   118      18.776   6.576  18.487  1.00  9.59           C  
ATOM    913  OD1 ASN   118      18.841   6.865  17.290  1.00 12.34           O  
ATOM    914  ND2 ASN   118      19.470   5.588  18.999  1.00 12.25           N  
ATOM    915  N   THR   119      16.127   8.854  16.591  1.00  6.94           N  
ATOM    916  CA  THR   119      15.179   8.577  15.541  1.00  6.53           C  
ATOM    917  C   THR   119      15.901   8.628  14.190  1.00  6.38           C  
ATOM    918  O   THR   119      16.911   9.327  14.010  1.00  7.96           O  
ATOM    919  CB  THR   119      14.000   9.574  15.490  1.00  7.22           C  
ATOM    920  OG1 THR   119      14.473  10.889  15.205  1.00  9.42           O  
ATOM    921  CG2 THR   119      13.226   9.594  16.807  1.00  8.55           C  
ATOM    922  N   SER   120      15.368   7.863  13.253  1.00  5.51           N  
ATOM    923  CA  SER   120      15.944   7.677  11.949  1.00  5.29           C  
ATOM    924  C   SER   120      14.853   7.551  10.920  1.00  4.26           C  
ATOM    925  O   SER   120      13.678   7.376  11.252  1.00  4.97           O  
ATOM    926  CB  SER   120      16.805   6.411  11.921  1.00  6.20           C  
ATOM    927  OG  SER   120      17.765   6.453  12.944  1.00  7.62           O  
ATOM    928  N   LEU   121      15.250   7.606   9.645  1.00  4.46           N  
ATOM    929  CA  LEU   121      14.317   7.455   8.521  0.80  4.26           C  
ATOM    931  C   LEU   121      14.733   6.291   7.643  1.00  4.09           C  
ATOM    932  O   LEU   121      15.920   6.048   7.412  1.00  5.18           O  
ATOM    933  CB  LEU   121      14.326   8.671   7.606  0.80  5.48           C  
ATOM    935  CG  LEU   121      13.854   9.969   8.202  0.80  5.51           C  
ATOM    937  CD1 LEU   121      14.135  11.139   7.266  0.80  8.67           C  
ATOM    939  CD2 LEU   121      12.370   9.905   8.512  0.80  6.72           C  
ATOM    941  N   TYR   122      13.726   5.629   7.100  1.00  3.94           N  
ATOM    942  CA  TYR   122      13.872   4.763   5.921  1.00  3.85           C  
ATOM    943  C   TYR   122      13.156   5.523   4.806  1.00  3.66           C  
ATOM    944  O   TYR   122      11.966   5.342   4.588  1.00  4.17           O  
ATOM    945  CB  TYR   122      13.247   3.394   6.157  1.00  3.95           C  
ATOM    946  CG  TYR   122      13.202   2.471   4.976  1.00  3.68           C  
ATOM    947  CD1 TYR   122      12.279   1.443   4.940  1.00  4.04           C  
ATOM    948  CD2 TYR   122      14.062   2.599   3.885  1.00  4.06           C  
ATOM    949  CE1 TYR   122      12.268   0.524   3.918  1.00  4.09           C  
ATOM    950  CE2 TYR   122      14.050   1.692   2.831  1.00  3.91           C  
ATOM    951  CZ  TYR   122      13.129   0.649   2.841  1.00  4.07           C  
ATOM    952  OH  TYR   122      13.077  -0.285   1.855  1.00  4.47           O  
ATOM    953  N   PRO   123      13.849   6.463   4.142  1.00  4.14           N  
ATOM    954  CA  PRO   123      13.138   7.375   3.237  1.00  4.65           C  
ATOM    955  C   PRO   123      12.396   6.651   2.119  1.00  4.10           C  
ATOM    956  O   PRO   123      11.326   7.076   1.718  1.00  5.12           O  
ATOM    957  CB  PRO   123      14.255   8.307   2.719  1.00  6.56           C  
ATOM    958  CG  PRO   123      15.395   7.915   3.287  1.00 10.08           C  
ATOM    959  CD  PRO   123      15.273   6.827   4.251  1.00  4.12           C  
ATOM    960  N   GLY   124      13.015   5.604   1.575  1.00  4.01           N  
ATOM    961  CA  GLY   124      12.403   4.887   0.494  1.00  4.35           C  
ATOM    962  C   GLY   124      11.110   4.194   0.879  1.00  3.60           C  
ATOM    963  O   GLY   124      10.226   3.980   0.046  1.00  3.88           O  
ATOM    964  N   SER   125      11.007   3.833   2.160  1.00  3.30           N  
ATOM    965  CA  SER   125       9.769   3.381   2.742  1.00  3.33           C  
ATOM    966  C   SER   125       9.300   2.067   2.099  1.00  3.27           C  
ATOM    967  O   SER   125      10.076   1.348   1.484  1.00  3.48           O  
ATOM    968  CB  SER   125       8.736   4.510   2.729  1.00  4.01           C  
ATOM    969  OG  SER   125       9.097   5.537   3.667  1.00  4.43           O  
ATOM    970  N   MET   126       8.020   1.709   2.316  1.00  3.33           N  
ATOM    971  CA  MET   126       7.588   0.395   1.839  0.80  3.44           C  
ATOM    973  C   MET   126       7.575   0.294   0.330  1.00  3.61           C  
ATOM    974  O   MET   126       7.699  -0.811  -0.213  1.00  4.24           O  
ATOM    975  CB  MET   126       6.249   0.002   2.467  0.80  4.02           C  
ATOM    977  CG  MET   126       6.343  -0.301   3.941  0.80  4.27           C  
ATOM    979  SD  MET   126       7.499  -1.795   4.379  0.80  5.51          SE  
ATOM    981  CE  MET   126       6.491  -3.168   3.482  0.80  6.80           C  
ATOM    983  N   ASN   127       7.471   1.417  -0.400  1.00  3.55           N  
ATOM    984  CA  ASN   127       7.586   1.335  -1.845  1.00  3.71           C  
ATOM    985  C   ASN   127       8.975   0.824  -2.210  1.00  3.64           C  
ATOM    986  O   ASN   127       9.127  -0.021  -3.093  1.00  4.42           O  
ATOM    987  CB  ASN   127       7.349   2.703  -2.504  1.00  4.44           C  
ATOM    988  CG  ASN   127       5.915   3.143  -2.465  1.00  4.85           C  
ATOM    989  OD1 ASN   127       5.029   2.508  -1.890  1.00  5.85           O  
ATOM    990  ND2 ASN   127       5.677   4.330  -3.077  1.00  6.65           N  
ATOM    991  N   ASP   128       9.999   1.360  -1.545  1.00  3.44           N  
ATOM    992  CA  ASP   128      11.362   0.913  -1.764  1.00  3.90           C  
ATOM    993  C   ASP   128      11.535  -0.552  -1.367  1.00  3.51           C  
ATOM    994  O   ASP   128      12.152  -1.352  -2.094  1.00  4.13           O  
ATOM    995  CB  ASP   128      12.301   1.824  -0.996  1.00  4.05           C  
ATOM    996  CG  ASP   128      13.769   1.443  -1.119  1.00  4.04           C  
ATOM    997  OD1 ASP   128      14.484   2.115  -1.899  1.00  5.33           O  
ATOM    998  OD2 ASP   128      14.185   0.505  -0.411  1.00  4.84           O  
ATOM    999  N   TRP   129      10.978  -0.923  -0.224  1.00  3.58           N  
ATOM   1000  CA  TRP   129      11.118  -2.279   0.279  1.00  3.68           C  
ATOM   1001  C   TRP   129      10.575  -3.272  -0.747  1.00  3.61           C  
ATOM   1002  O   TRP   129      11.252  -4.235  -1.148  1.00  4.41           O  
ATOM   1003  CB  TRP   129      10.394  -2.398   1.619  1.00  4.11           C  
ATOM   1004  CG  TRP   129      10.558  -3.726   2.308  1.00  3.84           C  
ATOM   1005  CD1 TRP   129       9.614  -4.693   2.432  1.00  4.29           C  
ATOM   1006  CD2 TRP   129      11.708  -4.178   3.064  1.00  4.09           C  
ATOM   1007  NE1 TRP   129      10.093  -5.730   3.205  1.00  4.47           N  
ATOM   1008  CE2 TRP   129      11.373  -5.436   3.599  1.00  4.27           C  
ATOM   1009  CE3 TRP   129      12.972  -3.633   3.353  1.00  4.65           C  
ATOM   1010  CZ2 TRP   129      12.278  -6.175   4.380  1.00  5.21           C  
ATOM   1011  CZ3 TRP   129      13.864  -4.361   4.102  1.00  5.69           C  
ATOM   1012  CH2 TRP   129      13.501  -5.624   4.611  1.00  5.59           C  
ATOM   1013  N   VAL   130       9.339  -3.042  -1.194  1.00  3.61           N  
ATOM   1014  CA  VAL   130       8.708  -3.942  -2.145  1.00  3.83           C  
ATOM   1015  C   VAL   130       9.390  -3.851  -3.511  1.00  4.04           C  
ATOM   1016  O   VAL   130       9.563  -4.874  -4.197  1.00  4.86           O  
ATOM   1017  CB  VAL   130       7.210  -3.665  -2.222  1.00  4.37           C  
ATOM   1018  CG1 VAL   130       6.529  -4.415  -3.377  1.00  5.73           C  
ATOM   1019  CG2 VAL   130       6.574  -4.015  -0.888  1.00  5.44           C  
ATOM   1020  N   SER   131       9.816  -2.682  -3.959  1.00  4.33           N  
ATOM   1021  CA  SER   131      10.509  -2.554  -5.230  0.50  4.63           C  
ATOM   1024  C   SER   131      11.725  -3.462  -5.309  1.00  4.94           C  
ATOM   1025  O   SER   131      12.048  -3.979  -6.379  1.00  7.00           O  
ATOM   1026  CB  SER   131      10.977  -1.105  -5.462  0.50  5.09           C  
ATOM   1029  OG  SER   131       9.891  -0.247  -5.776  0.50  4.79           O  
ATOM   1032  N   HIS   132      12.434  -3.601  -4.190  1.00  4.09           N  
ATOM   1033  CA  HIS   132      13.653  -4.387  -4.120  1.00  5.00           C  
ATOM   1034  C   HIS   132      13.407  -5.825  -3.700  1.00  5.16           C  
ATOM   1035  O   HIS   132      14.366  -6.579  -3.546  1.00  6.97           O  
ATOM   1036  CB  HIS   132      14.651  -3.741  -3.159  1.00  6.29           C  
ATOM   1037  CG  HIS   132      15.173  -2.425  -3.605  1.00  7.34           C  
ATOM   1038  ND1 HIS   132      14.569  -1.247  -3.294  1.00  8.04           N  
ATOM   1039  CD2 HIS   132      16.276  -2.083  -4.305  1.00 12.11           C  
ATOM   1040  CE1 HIS   132      15.249  -0.241  -3.804  1.00 10.56           C  
ATOM   1041  NE2 HIS   132      16.280  -0.718  -4.447  1.00 13.22           N  
ATOM   1042  N   GLY   133      12.154  -6.207  -3.489  1.00  5.03           N  
ATOM   1043  CA  GLY   133      11.806  -7.578  -3.156  1.00  5.84           C  
ATOM   1044  C   GLY   133      11.894  -7.915  -1.668  1.00  5.32           C  
ATOM   1045  O   GLY   133      11.886  -9.110  -1.321  1.00  5.03           O  
ATOM   1046  N   GLY   134      11.909  -6.905  -0.802  1.00  5.00           N  
ATOM   1047  CA  GLY   134      11.989  -7.156   0.610  1.00  5.55           C  
ATOM   1048  C   GLY   134      10.906  -8.023   1.172  1.00  4.95           C  
ATOM   1049  O   GLY   134      11.122  -8.750   2.153  1.00  5.96           O  
ATOM   1050  N   ASP   135       9.725  -7.953   0.591  1.00  5.67           N  
ATOM   1051  CA  ASP   135       8.617  -8.770   1.049  1.00  6.29           C  
ATOM   1052  C   ASP   135       8.818 -10.273   0.822  1.00  5.75           C  
ATOM   1053  O   ASP   135       8.085 -11.067   1.405  1.00  7.57           O  
ATOM   1054  CB  ASP   135       7.307  -8.294   0.391  1.00  7.45           C  
ATOM   1055  CG  ASP   135       7.385  -8.341  -1.120  1.00  8.12           C  
ATOM   1056  OD1 ASP   135       8.281  -7.699  -1.702  1.00  7.76           O  
ATOM   1057  OD2 ASP   135       6.580  -9.093  -1.739  1.00 13.52           O  
ATOM   1058  N   LYS   136       9.807 -10.636  -0.010  1.00  4.79           N  
ATOM   1059  CA  LYS   136      10.115 -12.031  -0.256  0.50  4.79           C  
ATOM   1061  C   LYS   136      11.260 -12.555   0.618  1.00  5.02           C  
ATOM   1062  O   LYS   136      11.670 -13.713   0.474  1.00  5.04           O  
ATOM   1063  CB  LYS   136      10.482 -12.246  -1.718  0.50  4.93           C  
ATOM   1065  CG  LYS   136       9.422 -11.816  -2.688  0.50  4.76           C  
ATOM   1067  CD  LYS   136       8.058 -12.371  -2.399  0.50  5.14           C  
ATOM   1069  CE  LYS   136       7.081 -12.233  -3.537  0.50  6.88           C  
ATOM   1071  NZ  LYS   136       7.051 -10.800  -4.022  0.50  7.26           N  
ATOM   1073  N   LEU   137      11.803 -11.706   1.487  1.00  5.59           N  
ATOM   1074  CA  LEU   137      12.840 -12.118   2.406  1.00  5.41           C  
ATOM   1075  C   LEU   137      12.245 -12.825   3.617  1.00  6.68           C  
ATOM   1076  O   LEU   137      11.058 -12.684   3.923  1.00  8.80           O  
ATOM   1077  CB  LEU   137      13.636 -10.911   2.889  1.00  5.66           C  
ATOM   1078  CG  LEU   137      14.328 -10.125   1.761  1.00  5.65           C  
ATOM   1079  CD1 LEU   137      14.925  -8.864   2.331  1.00  7.54           C  
ATOM   1080  CD2 LEU   137      15.411 -10.949   1.085  1.00  7.87           C  
ATOM   1081  N   ASP   138      13.096 -13.562   4.315  1.00  6.41           N  
ATOM   1082  CA  ASP   138      12.745 -14.216   5.555  1.00  7.90           C  
ATOM   1083  C   ASP   138      13.943 -14.092   6.510  1.00  8.72           C  
ATOM   1084  O   ASP   138      14.589 -15.076   6.851  1.00 12.84           O  
ATOM   1085  CB  ASP   138      12.391 -15.698   5.280  1.00  9.13           C  
ATOM   1086  CG  ASP   138      11.835 -16.421   6.470  1.00 11.58           C  
ATOM   1087  OD1 ASP   138      11.324 -15.777   7.390  1.00 15.42           O  
ATOM   1088  OD2 ASP   138      11.913 -17.655   6.525  1.00 14.90           O  
ATOM   1089  N   LEU   139      14.265 -12.876   6.930  1.00 11.14           N  
ATOM   1090  CA  LEU   139      15.484 -12.587   7.712  1.00 12.59           C  
ATOM   1091  C   LEU   139      15.303 -12.694   9.201  1.00 15.51           C  
ATOM   1092  O   LEU   139      14.166 -12.670   9.679  1.00 16.67           O  
ATOM   1093  CB  LEU   139      15.978 -11.192   7.404  1.00 14.21           C  
ATOM   1094  CG  LEU   139      16.279 -10.807   5.972  1.00 15.95           C  
ATOM   1095  CD1 LEU   139      16.667  -9.342   5.909  1.00 18.14           C  
ATOM   1096  CD2 LEU   139      17.346 -11.740   5.432  1.00 19.85           C  
ATOM   1097  OXT LEU   139      16.299 -12.751   9.943  1.00 18.29           O  
END
