
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  162 ( 1240),  selected  162 , name 3bjn_A
# Molecule2: number of CA atoms  176 ( 1390),  selected  176 , name T0412.pdb
# PARAMETERS: 3bjn_A.T0412.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    79_A      S       1           -
LGA    Y    80_A      N       2           -
LGA    E    81_A      -       -           -
LGA    T    82_A      -       -           -
LGA    S    83_A      -       -           -
LGA    Q    84_A      A       3           #
LGA    H    85_A      L       4          5.664
LGA    -       -      F       5           -
LGA    N    86_A      S       6          3.344
LGA    L    87_A      S       7          2.513
LGA    D    88_A      R       8          1.824
LGA    A    89_A      D       9          2.105
LGA    V    90_A      I      10          2.050
LGA    E    91_A      L      11          1.310
LGA    A    92_A      E      12          0.829
LGA    V    93_A      V      13          1.143
LGA    L    94_A      L      14          0.867
LGA    S    95_A      Q      15          0.397
LGA    R    96_A      D      16          0.425
LGA    L    97_A      I      17          0.764
LGA    Q    98_A      H      18          1.196
LGA    K    99_A      M      19          1.632
LGA    Q   100_A      E      20          2.169
LGA    T   101_A      T      21          2.038
LGA    G   102_A      G      22          2.653
LGA    E   103_A      E      23          1.648
LGA    X   104_A      T      24          1.760
LGA    A   105_A      V      25          0.792
LGA    A   106_A      A      26          0.523
LGA    Y   107_A      I      27          0.445
LGA    X   108_A      A      28          0.672
LGA    V   109_A      T      29          0.913
LGA    P   110_A      K      30          0.612
LGA    V   111_A      N      31          0.778
LGA    G   112_A      D      32          1.241
LGA    Y   113_A      I      33          1.963
LGA    R   114_A      Y      34          1.048
LGA    A   115_A      L      35          0.722
LGA    L   116_A      Q      36          1.154
LGA    C   117_A      Y      37          1.336
LGA    V   118_A      I      38          1.109
LGA    S   119_A      Q      39          0.625
LGA    Q   120_A      I      40          1.153
LGA    R   121_A      I      41          1.328
LGA    E   122_A      E      42          0.733
LGA    S   123_A      S      43          0.975
LGA    X   124_A      V      44          0.687
LGA    Q   125_A      H      45          1.281
LGA    A   126_A      A      46          2.576
LGA    L   127_A      L      47          3.650
LGA    R   128_A      R      48          4.187
LGA    C   129_A      F      49          2.490
LGA    S   130_A      H      50          5.334
LGA    F   131_A      V      51          2.518
LGA    V   132_A      D      52          4.116
LGA    Q   133_A      -       -           -
LGA    G   134_A      E      53          4.834
LGA    Q   135_A      N      54          4.566
LGA    S   136_A      A      55          5.121
LGA    Q   137_A      I      56          3.833
LGA    P   138_A      R      57          1.810
LGA    -       -      P      58           -
LGA    L   139_A      L      59          1.526
LGA    L   140_A      T      60          1.549
LGA    R   141_A      M      61          1.002
LGA    G   142_A      S      62          1.672
LGA    A   143_A      S      63          1.001
LGA    S   144_A      N      64          0.628
LGA    S   145_A      G      65          0.762
LGA    K   146_A      W      66          1.054
LGA    V   147_A      M      67          0.805
LGA    X   148_A      L      68          0.814
LGA    L   149_A      M      69          1.153
LGA    A   150_A      S      70          1.484
LGA    Y   151_A      T      71          2.217
LGA    X   152_A      M      72          2.653
LGA    P   153_A      N      73          2.914
LGA    A   154_A      D      74          2.672
LGA    A   155_A      K      75          2.922
LGA    R   156_A      A      76          2.714
LGA    C   157_A      I      77          2.312
LGA    E   158_A      D      78          2.323
LGA    K   159_A      N      79          2.199
LGA    I   160_A      T      80          1.737
LGA    L   161_A      V      81          1.243
LGA    R   162_A      R      82          1.330
LGA    Y   163_A      R      83          0.744
LGA    F   164_A      A      84          1.597
LGA    G   165_A      N      85          2.291
LGA    -       -      T      86           -
LGA    -       -      I      87           -
LGA    -       -      T      88           -
LGA    -       -      Q      89           -
LGA    -       -      K      90           -
LGA    -       -      D      91           -
LGA    -       -      G      92           -
LGA    -       -      I      93           -
LGA    E   166_A      R      94          5.724
LGA    D   167_A      F      95           #
LGA    P   168_A      E      96           #
LGA    T   169_A      V      97          4.335
LGA    L   170_A      D      98          0.808
LGA    D   171_A      D      99          3.405
LGA    K   172_A      -       -           -
LGA    W   173_A      M     100          1.452
LGA    Q   174_A      M     101          2.478
LGA    S   175_A      A     102          2.121
LGA    E   176_A      R     103          0.824
LGA    F   177_A      I     104          1.510
LGA    E   178_A      R     105          2.194
LGA    K   179_A      Q     106          1.639
LGA    I   180_A      V     107          0.876
LGA    R   181_A      R     108          1.686
LGA    R   182_A      E     109          1.914
LGA    H   183_A      Q     110          1.119
LGA    G   184_A      G     111          0.292
LGA    Y   185_A      Y     112          0.426
LGA    A   186_A      A     113          0.578
LGA    V   187_A      S     114          0.731
LGA    S   188_A      A     115          0.264
LGA    T   189_A      E     116          0.738
LGA    S   190_A      H     117          0.996
LGA    E   191_A      I     118          1.098
LGA    I   192_A      P     119          1.570
LGA    D   193_A      F     120          2.013
LGA    P   194_A      V     121          1.620
LGA    G   195_A      G     122          0.868
LGA    V   196_A      G     123          1.068
LGA    S   197_A      G     124          0.449
LGA    G   198_A      T     125          0.604
LGA    I   199_A      I     126          0.185
LGA    S   200_A      C     127          0.637
LGA    A   201_A      V     128          0.658
LGA    P   202_A      L     129          1.024
LGA    V   203_A      L     130          1.748
LGA    X   204_A      P     131          3.388
LGA    K   205_A      M     132          3.015
LGA    G   206_A      T     133           -
LGA    S   207_A      I     134           -
LGA    K   208_A      Q     135           -
LGA    L   209_A      G     136           #
LGA    I   210_A      Q     137          3.674
LGA    -       -      P     138           -
LGA    G   211_A      V     139          0.996
LGA    A   212_A      T     140          0.485
LGA    I   213_A      M     141          0.323
LGA    S   214_A      G     142          0.499
LGA    V   215_A      L     143          0.462
LGA    X   216_A      G     144          0.265
LGA    A   217_A      G     145          1.438
LGA    P   218_A      A     146          0.913
LGA    A   219_A      L     147          0.873
LGA    H   220_A      D     148          1.509
LGA    R   221_A      R     149          0.660
LGA    V   222_A      I     150          1.151
LGA    E   223_A      K     151          1.729
LGA    S   224_A      Q     152          1.202
LGA    N   225_A      N     153          0.583
LGA    K   226_A      Y     154          0.486
LGA    Q   227_A      D     155          0.554
LGA    R   228_A      R     156          0.604
LGA    I   229_A      Y     157          0.769
LGA    I   230_A      L     158          0.923
LGA    L   231_A      E     159          1.102
LGA    H   232_A      L     160          0.918
LGA    V   233_A      L     161          1.354
LGA    L   234_A      L     162          1.717
LGA    Q   235_A      N     163          1.953
LGA    A   236_A      G     164          2.073
LGA    A   237_A      V     165          3.276
LGA    R   238_A      Q     166          3.854
LGA    A   239_A      Q     167          3.194
LGA    L   240_A      L     168          3.464
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      S     171           -
LGA    -       -      D     172           -
LGA    -       -      S     173           -
LGA    -       -      F     174           -
LGA    -       -      H     175           -
LGA    -       -      Q     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  162  176    5.0    148    2.04    16.89     63.681     6.904

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.950121 * X  +   0.305506 * Y  +   0.062741 * Z  +  31.263254
  Y_new =   0.180409 * X  +   0.702460 * Y  +  -0.688478 * Z  +  50.047062
  Z_new =  -0.254407 * X  +  -0.642818 * Y  +  -0.722538 * Z  + 126.861290 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.414516    0.727077  [ DEG:  -138.3416     41.6584 ]
  Theta =   0.257235    2.884358  [ DEG:    14.7385    165.2616 ]
  Phi   =   2.953946   -0.187646  [ DEG:   169.2487    -10.7513 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bjn_A                                        
REMARK     2: T0412.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bjn_A.T0412.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  162  176   5.0  148   2.04   16.89  63.681
REMARK  ---------------------------------------------------------- 
MOLECULE 3bjn_A
HEADER    TRANSCRIPTION REGULATOR                 04-DEC-07   3BJN              
TITLE     CRYSTAL STRUCTURE OF C-TERMINAL DOMAIN OF PUTATIVE                    
TITLE    2 TRANSCRIPTIONAL REGULATOR FROM VIBRIO CHOLERAE, TARGETED             
TITLE    3 DOMAIN 79-240                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR, PUTATIVE;                       
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: C-TERMINAL DOMAIN: RESIDUES 79-240;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: VIBRIO CHOLERAE O1 BIOVAR ELTOR STR.            
SOURCE   3 N16961;                                                              
SOURCE   4 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   5 STRAIN: EL TOR INABA N16961 / SEROTYPE O1;                           
SOURCE   6 ATCC: 39315;                                                         
SOURCE   7 GENE: VC_A0029;                                                      
SOURCE   8 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) DERIVATIVE;                      
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    PUTATIVE TRANSCRIPTIONAL REGULATOR ICLR, VIBRIO CHOLERAE,             
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG, TRANSCRIPTION          
KEYWDS   4 REGULATOR                                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.CHANG,L.VOLKART,S.CLANCY,A.JOACHIMIAK,MIDWEST CENTER FOR            
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   11-DEC-07 3BJN    0                                                
JRNL        AUTH   C.CHANG,L.VOLKART,S.CLANCY,A.JOACHIMIAK                      
JRNL        TITL   CRYSTAL STRUCTURE OF C-TERMINAL DOMAIN OF PUTATIVE           
JRNL        TITL 2 TRANSCRIPTIONAL REGULATOR FROM VIBRIO CHOLERAE.              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.65 ANGSTROMS.                                          
DBREF  3BJN A   79   240  UNP    Q9KND6   Q9KND6_VIBCH    79    240             
SEQRES   1 A  165  SER ASN ALA SER TYR GLU THR SER GLN HIS ASN LEU ASP          
SEQRES   2 A  165  ALA VAL GLU ALA VAL LEU SER ARG LEU GLN LYS GLN THR          
SEQRES   3 A  165  GLY GLU MSE ALA ALA TYR MSE VAL PRO VAL GLY TYR ARG          
SEQRES   4 A  165  ALA LEU CYS VAL SER GLN ARG GLU SER MSE GLN ALA LEU          
SEQRES   5 A  165  ARG CYS SER PHE VAL GLN GLY GLN SER GLN PRO LEU LEU          
SEQRES   6 A  165  ARG GLY ALA SER SER LYS VAL MSE LEU ALA TYR MSE PRO          
SEQRES   7 A  165  ALA ALA ARG CYS GLU LYS ILE LEU ARG TYR PHE GLY GLU          
SEQRES   8 A  165  ASP PRO THR LEU ASP LYS TRP GLN SER GLU PHE GLU LYS          
SEQRES   9 A  165  ILE ARG ARG HIS GLY TYR ALA VAL SER THR SER GLU ILE          
SEQRES  10 A  165  ASP PRO GLY VAL SER GLY ILE SER ALA PRO VAL MSE LYS          
SEQRES  11 A  165  GLY SER LYS LEU ILE GLY ALA ILE SER VAL MSE ALA PRO          
SEQRES  12 A  165  ALA HIS ARG VAL GLU SER ASN LYS GLN ARG ILE ILE LEU          
SEQRES  13 A  165  HIS VAL LEU GLN ALA ALA ARG ALA LEU                          
HET    MSE  A 104      13                                                       
HET    MSE  A 108       8                                                       
HET    MSE  A 124       8                                                       
HET    MSE  A 148       8                                                       
HET    MSE  A 152       8                                                       
HET    MSE  A 204       8                                                       
HET    MSE  A 216       8                                                       
HET     CL  A 251       1                                                       
HET     CL  A 252       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
FORMUL   1  MSE    7(C5 H11 N O2 SE)                                            
FORMUL   2   CL    2(CL 1-)                                                     
FORMUL   4  HOH   *200(H2 O)                                                    
CRYST1   54.313   54.313  142.608  90.00  90.00  90.00 P 43 21 2     8          
ATOM      1  N   SER A  79      14.295  27.763  74.520  1.00 36.64           N  
ATOM      2  CA  SER A  79      14.493  28.820  75.562  1.00 36.38           C  
ATOM      3  C   SER A  79      15.551  28.392  76.581  1.00 35.95           C  
ATOM      4  O   SER A  79      15.798  27.181  76.788  1.00 35.36           O  
ATOM      5  CB  SER A  79      13.170  29.146  76.268  1.00 36.16           C  
ATOM      6  N   TYR A  80      16.180  29.393  77.194  1.00 35.16           N  
ATOM      7  CA  TYR A  80      17.137  29.168  78.264  1.00 34.70           C  
ATOM      8  C   TYR A  80      16.536  29.609  79.591  1.00 35.47           C  
ATOM      9  O   TYR A  80      17.255  29.810  80.573  1.00 36.11           O  
ATOM     10  CB  TYR A  80      18.468  29.876  77.965  1.00 33.41           C  
ATOM     11  CG  TYR A  80      19.055  29.464  76.636  1.00 31.58           C  
ATOM     12  CD1 TYR A  80      19.310  28.121  76.354  1.00 30.17           C  
ATOM     13  CD2 TYR A  80      19.351  30.422  75.652  1.00 31.00           C  
ATOM     14  CE1 TYR A  80      19.836  27.741  75.130  1.00 30.52           C  
ATOM     15  CE2 TYR A  80      19.889  30.051  74.423  1.00 30.70           C  
ATOM     16  CZ  TYR A  80      20.130  28.708  74.173  1.00 30.41           C  
ATOM     17  OH  TYR A  80      20.644  28.301  72.966  1.00 30.30           O  
ATOM     18  N   GLU A  81      15.207  29.749  79.609  1.00 36.24           N  
ATOM     19  CA  GLU A  81      14.466  30.089  80.826  1.00 36.55           C  
ATOM     20  C   GLU A  81      14.704  29.094  81.982  1.00 36.39           C  
ATOM     21  O   GLU A  81      14.927  29.513  83.121  1.00 36.79           O  
ATOM     22  CB  GLU A  81      12.964  30.226  80.520  1.00 36.63           C  
ATOM     23  N   THR A  82      14.669  27.793  81.692  1.00 36.24           N  
ATOM     24  CA  THR A  82      14.802  26.771  82.745  1.00 35.66           C  
ATOM     25  C   THR A  82      16.222  26.204  82.906  1.00 35.60           C  
ATOM     26  O   THR A  82      16.477  25.394  83.812  1.00 35.68           O  
ATOM     27  CB  THR A  82      13.786  25.584  82.568  1.00 36.23           C  
ATOM     28  OG1 THR A  82      14.146  24.770  81.438  1.00 34.89           O  
ATOM     29  CG2 THR A  82      12.353  26.101  82.413  1.00 35.92           C  
ATOM     30  N   SER A  83      17.141  26.614  82.029  1.00 34.52           N  
ATOM     31  CA  SER A  83      18.499  26.063  82.030  1.00 33.81           C  
ATOM     32  C   SER A  83      19.566  27.085  82.408  1.00 34.02           C  
ATOM     33  O   SER A  83      20.660  26.723  82.882  1.00 33.42           O  
ATOM     34  CB  SER A  83      18.832  25.477  80.663  1.00 33.55           C  
ATOM     35  OG  SER A  83      18.648  26.430  79.639  1.00 31.50           O  
ATOM     36  N   GLN A  84      19.252  28.351  82.147  1.00 34.09           N  
ATOM     37  CA  GLN A  84      20.066  29.475  82.598  1.00 34.57           C  
ATOM     38  C   GLN A  84      19.439  30.082  83.847  1.00 34.82           C  
ATOM     39  O   GLN A  84      18.501  30.901  83.760  1.00 35.12           O  
ATOM     40  CB  GLN A  84      20.210  30.525  81.499  1.00 34.41           C  
ATOM     41  CG  GLN A  84      21.311  31.550  81.805  1.00 35.98           C  
ATOM     42  CD  GLN A  84      22.685  30.898  81.873  1.00 36.72           C  
ATOM     43  OE1 GLN A  84      23.058  30.150  80.975  1.00 37.32           O  
ATOM     44  NE2 GLN A  84      23.432  31.164  82.945  1.00 37.25           N  
ATOM     45  N   HIS A  85      19.963  29.679  85.008  1.00 34.95           N  
ATOM     46  CA  HIS A  85      19.387  30.058  86.309  1.00 34.66           C  
ATOM     47  C   HIS A  85      19.172  31.559  86.476  1.00 34.34           C  
ATOM     48  O   HIS A  85      18.141  31.983  87.010  1.00 35.07           O  
ATOM     49  CB  HIS A  85      20.230  29.493  87.479  1.00 34.96           C  
ATOM     50  N   ASN A  86      20.121  32.362  85.987  1.00 32.68           N  
ATOM     51  CA  ASN A  86      20.085  33.785  86.263  1.00 30.66           C  
ATOM     52  C   ASN A  86      19.865  34.657  85.031  1.00 28.65           C  
ATOM     53  O   ASN A  86      20.392  35.771  84.967  1.00 26.27           O  
ATOM     54  CB  ASN A  86      21.383  34.209  86.952  1.00 31.80           C  
ATOM     55  CG  ASN A  86      22.595  34.095  86.034  1.00 33.46           C  
ATOM     56  OD1 ASN A  86      22.600  33.343  85.029  1.00 34.93           O  
ATOM     57  ND2 ASN A  86      23.629  34.856  86.358  1.00 35.41           N  
ATOM     58  N   LEU A  87      19.084  34.161  84.073  1.00 26.09           N  
ATOM     59  CA  LEU A  87      18.801  34.926  82.847  1.00 24.87           C  
ATOM     60  C   LEU A  87      18.196  36.313  83.096  1.00 23.09           C  
ATOM     61  O   LEU A  87      18.554  37.269  82.403  1.00 22.23           O  
ATOM     62  CB  LEU A  87      17.905  34.120  81.906  1.00 24.87           C  
ATOM     63  CG  LEU A  87      17.725  34.578  80.462  1.00 26.17           C  
ATOM     64  CD1 LEU A  87      19.062  34.632  79.683  1.00 24.26           C  
ATOM     65  CD2 LEU A  87      16.737  33.628  79.785  1.00 26.35           C  
ATOM     66  N   ASP A  88      17.300  36.457  84.069  1.00 21.88           N  
ATOM     67  CA  ASP A  88      16.771  37.805  84.357  1.00 21.58           C  
ATOM     68  C   ASP A  88      17.900  38.783  84.703  1.00 20.05           C  
ATOM     69  O   ASP A  88      17.934  39.922  84.203  1.00 20.02           O  
ATOM     70  CB  ASP A  88      15.757  37.789  85.509  1.00 22.21           C  
ATOM     71  CG  ASP A  88      14.461  37.056  85.156  1.00 26.28           C  
ATOM     72  OD1 ASP A  88      14.254  36.688  83.981  1.00 31.05           O  
ATOM     73  OD2 ASP A  88      13.641  36.835  86.076  1.00 30.25           O  
ATOM     74  N   ALA A  89      18.834  38.315  85.532  1.00 18.91           N  
ATOM     75  CA  ALA A  89      19.952  39.155  85.979  1.00 18.53           C  
ATOM     76  C   ALA A  89      20.875  39.457  84.785  1.00 17.28           C  
ATOM     77  O   ALA A  89      21.344  40.603  84.593  1.00 17.31           O  
ATOM     78  CB  ALA A  89      20.726  38.458  87.100  1.00 19.49           C  
ATOM     79  N   VAL A  90      21.127  38.423  83.996  1.00 16.44           N  
ATOM     80  CA  VAL A  90      21.931  38.590  82.768  1.00 15.64           C  
ATOM     81  C   VAL A  90      21.302  39.622  81.820  1.00 15.43           C  
ATOM     82  O   VAL A  90      21.991  40.512  81.307  1.00 14.52           O  
ATOM     83  CB  VAL A  90      22.114  37.230  82.028  1.00 15.62           C  
ATOM     84  CG1 VAL A  90      22.719  37.447  80.644  1.00 16.52           C  
ATOM     85  CG2 VAL A  90      22.962  36.272  82.851  1.00 16.80           C  
ATOM     86  N   GLU A  91      19.995  39.488  81.576  1.00 14.95           N  
ATOM     87  CA  GLU A  91      19.307  40.451  80.692  1.00 14.90           C  
ATOM     88  C   GLU A  91      19.448  41.895  81.167  1.00 15.09           C  
ATOM     89  O   GLU A  91      19.685  42.790  80.361  1.00 15.26           O  
ATOM     90  CB  GLU A  91      17.835  40.058  80.493  1.00 16.01           C  
ATOM     91  CG  GLU A  91      17.698  38.799  79.658  1.00 18.00           C  
ATOM     92  CD  GLU A  91      16.283  38.296  79.521  1.00 22.63           C  
ATOM     93  OE1 GLU A  91      15.372  38.806  80.210  1.00 25.23           O  
ATOM     94  OE2 GLU A  91      16.079  37.346  78.732  1.00 24.17           O  
ATOM     95  N   ALA A  92      19.302  42.122  82.465  1.00 14.83           N  
ATOM     96  CA  ALA A  92      19.441  43.462  83.055  1.00 14.58           C  
ATOM     97  C   ALA A  92      20.853  44.019  82.865  1.00 15.37           C  
ATOM     98  O   ALA A  92      21.018  45.176  82.493  1.00 15.39           O  
ATOM     99  CB  ALA A  92      19.070  43.425  84.548  1.00 15.30           C  
ATOM    100  N   VAL A  93      21.869  43.177  83.104  1.00 15.52           N  
ATOM    101  CA  VAL A  93      23.259  43.582  82.923  1.00 15.41           C  
ATOM    102  C   VAL A  93      23.553  43.915  81.444  1.00 14.96           C  
ATOM    103  O   VAL A  93      24.222  44.923  81.132  1.00 13.76           O  
ATOM    104  CB  VAL A  93      24.210  42.486  83.477  1.00 16.58           C  
ATOM    105  CG1 VAL A  93      25.579  42.593  82.865  1.00 19.54           C  
ATOM    106  CG2 VAL A  93      24.236  42.550  85.039  1.00 16.85           C  
ATOM    107  N   LEU A  94      23.028  43.112  80.516  1.00 13.98           N  
ATOM    108  CA  LEU A  94      23.298  43.383  79.086  1.00 13.10           C  
ATOM    109  C   LEU A  94      22.572  44.625  78.599  1.00 12.97           C  
ATOM    110  O   LEU A  94      23.083  45.396  77.771  1.00 12.89           O  
ATOM    111  CB  LEU A  94      22.886  42.197  78.221  1.00 13.43           C  
ATOM    112  CG  LEU A  94      23.716  40.934  78.438  1.00 11.42           C  
ATOM    113  CD1 LEU A  94      23.059  39.841  77.594  1.00 13.94           C  
ATOM    114  CD2 LEU A  94      25.187  41.141  78.044  1.00 14.71           C  
ATOM    115  N   SER A  95      21.354  44.825  79.102  1.00 13.21           N  
ATOM    116  CA  SER A  95      20.609  46.047  78.762  1.00 14.33           C  
ATOM    117  C   SER A  95      21.400  47.299  79.161  1.00 13.51           C  
ATOM    118  O   SER A  95      21.614  48.225  78.361  1.00 14.20           O  
ATOM    119  CB  SER A  95      19.277  46.022  79.477  1.00 14.30           C  
ATOM    120  OG  SER A  95      18.570  47.243  79.295  1.00 18.10           O  
ATOM    121  N   ARG A  96      21.858  47.329  80.414  1.00 13.62           N  
ATOM    122  CA  ARG A  96      22.652  48.476  80.881  1.00 13.16           C  
ATOM    123  C   ARG A  96      23.936  48.645  80.064  1.00 13.52           C  
ATOM    124  O   ARG A  96      24.312  49.760  79.703  1.00 13.53           O  
ATOM    125  CB  ARG A  96      23.000  48.310  82.367  1.00 13.92           C  
ATOM    126  CG  ARG A  96      23.818  49.492  82.872  1.00 15.98           C  
ATOM    127  CD  ARG A  96      23.975  49.440  84.387  1.00 19.11           C  
ATOM    128  NE  ARG A  96      24.845  48.322  84.739  1.00 25.37           N  
ATOM    129  CZ  ARG A  96      25.580  48.240  85.851  1.00 26.62           C  
ATOM    130  NH1 ARG A  96      25.570  49.235  86.737  1.00 28.31           N  
ATOM    131  NH2 ARG A  96      26.322  47.158  86.074  1.00 28.22           N  
ATOM    132  N   LEU A  97      24.614  47.526  79.802  1.00 13.11           N  
ATOM    133  CA  LEU A  97      25.898  47.560  79.110  1.00 12.57           C  
ATOM    134  C   LEU A  97      25.732  48.197  77.733  1.00 12.65           C  
ATOM    135  O   LEU A  97      26.543  49.047  77.335  1.00 12.97           O  
ATOM    136  CB  LEU A  97      26.417  46.139  78.977  1.00 13.03           C  
ATOM    137  CG  LEU A  97      27.724  46.011  78.221  1.00 11.08           C  
ATOM    138  CD1 LEU A  97      28.863  46.929  78.744  1.00 14.28           C  
ATOM    139  CD2 LEU A  97      28.114  44.530  78.377  1.00 14.86           C  
ATOM    140  N   GLN A  98      24.677  47.811  77.001  1.00 12.65           N  
ATOM    141  CA  GLN A  98      24.447  48.464  75.697  1.00 13.53           C  
ATOM    142  C   GLN A  98      24.116  49.944  75.827  1.00 13.42           C  
ATOM    143  O   GLN A  98      24.548  50.753  75.009  1.00 14.00           O  
ATOM    144  CB  GLN A  98      23.340  47.764  74.918  1.00 14.17           C  
ATOM    145  CG  GLN A  98      22.940  48.497  73.629  1.00 13.32           C  
ATOM    146  CD  GLN A  98      21.959  47.649  72.816  1.00 14.27           C  
ATOM    147  OE1 GLN A  98      20.896  47.267  73.315  1.00 15.74           O  
ATOM    148  NE2 GLN A  98      22.288  47.390  71.574  1.00 15.43           N  
ATOM    149  N   LYS A  99      23.356  50.310  76.861  1.00 13.16           N  
ATOM    150  CA  LYS A  99      23.025  51.738  77.073  1.00 12.65           C  
ATOM    151  C   LYS A  99      24.240  52.588  77.528  1.00 12.92           C  
ATOM    152  O   LYS A  99      24.192  53.817  77.377  1.00 14.00           O  
ATOM    153  CB  LYS A  99      21.879  51.834  78.071  1.00 12.83           C  
ATOM    154  CG  LYS A  99      20.577  51.325  77.480  1.00 14.95           C  
ATOM    155  CD  LYS A  99      19.515  51.495  78.532  1.00 19.67           C  
ATOM    156  CE  LYS A  99      18.351  50.591  78.278  1.00 24.52           C  
ATOM    157  NZ  LYS A  99      17.312  50.934  79.302  1.00 28.14           N  
ATOM    158  N   GLN A 100      25.284  51.932  78.066  1.00 11.86           N  
ATOM    159  CA  GLN A 100      26.521  52.600  78.512  1.00 11.93           C  
ATOM    160  C   GLN A 100      27.526  52.751  77.379  1.00 13.08           C  
ATOM    161  O   GLN A 100      28.312  53.705  77.346  1.00 13.31           O  
ATOM    162  CB  GLN A 100      27.171  51.774  79.616  1.00 13.78           C  
ATOM    163  CG  GLN A 100      26.455  51.869  80.976  1.00 11.69           C  
ATOM    164  CD  GLN A 100      27.050  50.923  81.967  1.00 14.77           C  
ATOM    165  OE1 GLN A 100      27.449  49.810  81.622  1.00 14.69           O  
ATOM    166  NE2 GLN A 100      27.129  51.357  83.216  1.00 16.39           N  
ATOM    167  N   THR A 101      27.529  51.776  76.461  1.00 12.55           N  
ATOM    168  CA  THR A 101      28.535  51.758  75.395  1.00 12.92           C  
ATOM    169  C   THR A 101      28.020  52.103  74.015  1.00 13.19           C  
ATOM    170  O   THR A 101      28.821  52.394  73.094  1.00 12.95           O  
ATOM    171  CB  THR A 101      29.180  50.340  75.276  1.00 12.73           C  
ATOM    172  OG1 THR A 101      28.149  49.385  74.978  1.00 12.72           O  
ATOM    173  CG2 THR A 101      29.892  49.932  76.561  1.00 14.18           C  
ATOM    174  N   GLY A 102      26.710  51.962  73.811  1.00 11.96           N  
ATOM    175  CA  GLY A 102      26.138  52.112  72.460  1.00 12.94           C  
ATOM    176  C   GLY A 102      26.552  50.969  71.550  1.00 13.61           C  
ATOM    177  O   GLY A 102      26.691  51.162  70.334  1.00 14.27           O  
ATOM    178  N   GLU A 103      26.774  49.799  72.134  1.00 13.64           N  
ATOM    179  CA  GLU A 103      27.176  48.617  71.341  1.00 13.25           C  
ATOM    180  C   GLU A 103      26.364  47.377  71.705  1.00 14.45           C  
ATOM    181  O   GLU A 103      25.767  47.285  72.797  1.00 13.91           O  
ATOM    182  CB  GLU A 103      28.660  48.295  71.613  1.00 13.44           C  
ATOM    183  CG  GLU A 103      29.629  49.450  71.305  1.00 13.64           C  
ATOM    184  CD  GLU A 103      29.706  49.865  69.823  1.00 15.69           C  
ATOM    185  OE1 GLU A 103      29.197  49.158  68.920  1.00 15.58           O  
ATOM    186  OE2 GLU A 103      30.288  50.950  69.552  1.00 16.83           O  
HETATM  187  N   MSE A 104      26.372  46.419  70.781  1.00 14.82           N  
HETATM  188  CA  MSE A 104      25.848  45.066  70.996  0.50 18.76           C  
HETATM  190  C   MSE A 104      26.595  44.406  72.133  1.00 16.61           C  
HETATM  191  O   MSE A 104      27.819  44.590  72.247  1.00 15.73           O  
HETATM  192  CB  MSE A 104      26.150  44.192  69.781  0.50 18.01           C  
HETATM  194  CG  MSE A 104      25.530  44.568  68.501  0.50 21.12           C  
HETATM  196 SE   MSE A 104      25.692  42.948  67.411  0.50 31.51          SE  
HETATM  198  CE  MSE A 104      24.261  42.049  68.172  0.50 16.69           C  
ATOM    200  N   ALA A 105      25.890  43.620  72.947  1.00 16.42           N  
ATOM    201  CA  ALA A 105      26.529  42.919  74.066  1.00 15.64           C  
ATOM    202  C   ALA A 105      25.894  41.549  74.181  1.00 15.61           C  
ATOM    203  O   ALA A 105      24.707  41.375  73.862  1.00 15.74           O  
ATOM    204  CB  ALA A 105      26.334  43.696  75.368  1.00 17.85           C  
ATOM    205  N   ALA A 106      26.678  40.576  74.622  1.00 13.98           N  
ATOM    206  CA  ALA A 106      26.151  39.216  74.740  1.00 14.34           C  
ATOM    207  C   ALA A 106      26.692  38.507  75.973  1.00 14.57           C  
ATOM    208  O   ALA A 106      27.744  38.875  76.502  1.00 14.48           O  
ATOM    209  CB  ALA A 106      26.513  38.412  73.520  1.00 14.92           C  
ATOM    210  N   TYR A 107      25.942  37.489  76.408  1.00 14.20           N  
ATOM    211  CA  TYR A 107      26.382  36.553  77.434  1.00 14.31           C  
ATOM    212  C   TYR A 107      26.571  35.211  76.766  1.00 15.22           C  
ATOM    213  O   TYR A 107      25.640  34.674  76.143  1.00 13.99           O  
ATOM    214  CB  TYR A 107      25.300  36.432  78.493  1.00 15.29           C  
ATOM    215  CG  TYR A 107      25.614  35.471  79.599  1.00 16.30           C  
ATOM    216  CD1 TYR A 107      26.706  35.678  80.426  1.00 19.24           C  
ATOM    217  CD2 TYR A 107      24.810  34.360  79.809  1.00 18.70           C  
ATOM    218  CE1 TYR A 107      26.977  34.775  81.483  1.00 20.94           C  
ATOM    219  CE2 TYR A 107      25.067  33.467  80.844  1.00 21.95           C  
ATOM    220  CZ  TYR A 107      26.159  33.675  81.651  1.00 20.79           C  
ATOM    221  OH  TYR A 107      26.391  32.792  82.688  1.00 23.27           O  
HETATM  222  N   MSE A 108      27.788  34.730  76.901  1.00 15.38           N  
HETATM  223  CA  MSE A 108      28.243  33.483  76.271  1.00 16.13           C  
HETATM  224  C   MSE A 108      28.522  32.437  77.330  1.00 15.63           C  
HETATM  225  O   MSE A 108      28.974  32.774  78.429  1.00 14.98           O  
HETATM  226  CB  MSE A 108      29.551  33.755  75.522  1.00 17.95           C  
HETATM  227  CG  MSE A 108      29.613  35.124  74.820  1.00 21.41           C  
HETATM  228 SE   MSE A 108      28.550  34.900  73.182  1.00 34.90          SE  
HETATM  229  CE  MSE A 108      29.918  33.875  72.403  1.00 26.08           C  
ATOM    230  N   VAL A 109      28.294  31.165  77.006  1.00 14.25           N  
ATOM    231  CA  VAL A 109      28.686  30.104  77.939  0.50 13.89           C  
ATOM    233  C   VAL A 109      29.404  29.014  77.181  1.00 14.20           C  
ATOM    234  O   VAL A 109      29.147  28.787  75.988  1.00 15.45           O  
ATOM    235  CB  VAL A 109      27.533  29.494  78.770  0.50 13.91           C  
ATOM    237  CG1 VAL A 109      26.878  30.557  79.653  0.50 14.21           C  
ATOM    239  CG2 VAL A 109      26.537  28.764  77.880  0.50 12.11           C  
ATOM    241  N   PRO A 110      30.364  28.363  77.855  1.00 13.81           N  
ATOM    242  CA  PRO A 110      31.093  27.291  77.173  1.00 13.68           C  
ATOM    243  C   PRO A 110      30.283  26.002  77.174  1.00 13.92           C  
ATOM    244  O   PRO A 110      29.712  25.640  78.212  1.00 16.11           O  
ATOM    245  CB  PRO A 110      32.373  27.169  78.001  1.00 14.54           C  
ATOM    246  CG  PRO A 110      32.019  27.649  79.387  1.00 14.82           C  
ATOM    247  CD  PRO A 110      30.852  28.603  79.243  1.00 14.35           C  
ATOM    248  N   VAL A 111      30.202  25.338  76.021  1.00 12.37           N  
ATOM    249  CA  VAL A 111      29.474  24.073  75.925  1.00 13.91           C  
ATOM    250  C   VAL A 111      30.336  23.177  75.056  1.00 13.18           C  
ATOM    251  O   VAL A 111      30.386  23.329  73.824  1.00 14.10           O  
ATOM    252  CB  VAL A 111      28.075  24.252  75.271  1.00 14.11           C  
ATOM    253  CG1 VAL A 111      27.322  22.921  75.240  1.00 15.88           C  
ATOM    254  CG2 VAL A 111      27.261  25.328  76.043  1.00 16.44           C  
ATOM    255  N   GLY A 112      31.038  22.271  75.715  1.00 12.89           N  
ATOM    256  CA  GLY A 112      31.898  21.335  74.993  1.00 12.59           C  
ATOM    257  C   GLY A 112      32.986  22.084  74.254  1.00 13.20           C  
ATOM    258  O   GLY A 112      33.820  22.799  74.875  1.00 13.34           O  
ATOM    259  N   TYR A 113      32.992  21.922  72.926  1.00 11.98           N  
ATOM    260  CA  TYR A 113      34.011  22.556  72.105  1.00 12.29           C  
ATOM    261  C   TYR A 113      33.607  23.960  71.630  1.00 12.96           C  
ATOM    262  O   TYR A 113      34.331  24.559  70.807  1.00 13.57           O  
ATOM    263  CB  TYR A 113      34.283  21.692  70.874  1.00 12.34           C  
ATOM    264  CG  TYR A 113      34.947  20.379  71.144  1.00 10.70           C  
ATOM    265  CD1 TYR A 113      36.025  20.266  72.034  1.00 10.34           C  
ATOM    266  CD2 TYR A 113      34.550  19.225  70.458  1.00 11.12           C  
ATOM    267  CE1 TYR A 113      36.671  19.049  72.240  1.00 11.69           C  
ATOM    268  CE2 TYR A 113      35.171  18.020  70.648  1.00 10.38           C  
ATOM    269  CZ  TYR A 113      36.248  17.912  71.533  1.00 10.66           C  
ATOM    270  OH  TYR A 113      36.843  16.678  71.668  1.00 10.36           O  
ATOM    271  N   ARG A 114      32.438  24.453  72.081  1.00 13.28           N  
ATOM    272  CA  ARG A 114      31.840  25.669  71.465  1.00 13.68           C  
ATOM    273  C   ARG A 114      31.409  26.693  72.487  1.00 15.06           C  
ATOM    274  O   ARG A 114      31.270  26.380  73.661  1.00 15.06           O  
ATOM    275  CB  ARG A 114      30.655  25.312  70.540  1.00 14.34           C  
ATOM    276  CG  ARG A 114      31.029  24.198  69.543  1.00 14.98           C  
ATOM    277  CD  ARG A 114      29.887  23.861  68.629  1.00 16.14           C  
ATOM    278  NE  ARG A 114      29.585  24.924  67.684  1.00 16.21           N  
ATOM    279  CZ  ARG A 114      30.184  25.095  66.502  1.00 18.62           C  
ATOM    280  NH1 ARG A 114      31.178  24.289  66.101  1.00 17.31           N  
ATOM    281  NH2 ARG A 114      29.802  26.119  65.720  1.00 19.59           N  
ATOM    282  N   ALA A 115      31.274  27.930  72.014  1.00 15.36           N  
ATOM    283  CA  ALA A 115      30.823  29.068  72.827  1.00 16.92           C  
ATOM    284  C   ALA A 115      29.392  29.336  72.378  1.00 16.36           C  
ATOM    285  O   ALA A 115      29.152  29.677  71.221  1.00 16.94           O  
ATOM    286  CB  ALA A 115      31.707  30.277  72.569  1.00 18.78           C  
ATOM    287  N   LEU A 116      28.447  29.156  73.290  1.00 16.11           N  
ATOM    288  CA  LEU A 116      27.044  29.377  72.969  1.00 15.81           C  
ATOM    289  C   LEU A 116      26.618  30.809  73.339  1.00 16.27           C  
ATOM    290  O   LEU A 116      26.862  31.261  74.453  1.00 16.14           O  
ATOM    291  CB  LEU A 116      26.178  28.368  73.729  1.00 16.67           C  
ATOM    292  CG  LEU A 116      24.676  28.595  73.612  1.00 17.64           C  
ATOM    293  CD1 LEU A 116      24.175  28.285  72.194  1.00 19.97           C  
ATOM    294  CD2 LEU A 116      23.932  27.738  74.625  1.00 20.68           C  
ATOM    295  N   CYS A 117      25.966  31.500  72.417  1.00 16.07           N  
ATOM    296  CA  CYS A 117      25.429  32.814  72.753  1.00 15.64           C  
ATOM    297  C   CYS A 117      24.056  32.638  73.412  1.00 16.67           C  
ATOM    298  O   CYS A 117      23.077  32.293  72.742  1.00 17.50           O  
ATOM    299  CB  CYS A 117      25.345  33.666  71.507  1.00 17.34           C  
ATOM    300  SG  CYS A 117      24.721  35.314  71.890  1.00 20.45           S  
ATOM    301  N   VAL A 118      23.992  32.835  74.723  1.00 15.48           N  
ATOM    302  CA  VAL A 118      22.766  32.562  75.468  1.00 16.19           C  
ATOM    303  C   VAL A 118      21.799  33.751  75.468  1.00 16.17           C  
ATOM    304  O   VAL A 118      20.565  33.586  75.412  1.00 16.90           O  
ATOM    305  CB  VAL A 118      23.094  32.140  76.916  1.00 16.07           C  
ATOM    306  CG1 VAL A 118      21.847  32.071  77.788  1.00 17.74           C  
ATOM    307  CG2 VAL A 118      23.789  30.768  76.902  1.00 17.30           C  
ATOM    308  N   SER A 119      22.359  34.955  75.511  1.00 16.30           N  
ATOM    309  CA  SER A 119      21.535  36.152  75.513  1.00 15.58           C  
ATOM    310  C   SER A 119      22.295  37.246  74.779  1.00 16.56           C  
ATOM    311  O   SER A 119      23.499  37.377  74.947  1.00 15.94           O  
ATOM    312  CB  SER A 119      21.222  36.589  76.938  1.00 15.68           C  
ATOM    313  OG  SER A 119      20.329  37.722  76.941  1.00 18.41           O  
ATOM    314  N   GLN A 120      21.586  38.003  73.942  1.00 18.30           N  
ATOM    315  CA  GLN A 120      22.241  39.022  73.133  1.00 19.08           C  
ATOM    316  C   GLN A 120      21.341  40.228  72.958  1.00 20.39           C  
ATOM    317  O   GLN A 120      20.133  40.065  72.730  1.00 20.03           O  
ATOM    318  CB  GLN A 120      22.551  38.447  71.765  1.00 20.60           C  
ATOM    319  CG  GLN A 120      23.343  39.366  70.842  1.00 25.35           C  
ATOM    320  CD  GLN A 120      23.539  38.726  69.499  1.00 29.99           C  
ATOM    321  OE1 GLN A 120      22.564  38.432  68.803  1.00 34.70           O  
ATOM    322  NE2 GLN A 120      24.777  38.453  69.142  1.00 33.36           N  
ATOM    323  N   ARG A 121      21.927  41.417  73.022  0.50 20.41           N  
ATOM    325  CA  ARG A 121      21.155  42.653  72.863  0.50 21.22           C  
ATOM    327  C   ARG A 121      20.765  42.983  71.413  0.50 21.46           C  
ATOM    329  O   ARG A 121      19.717  43.564  71.155  0.50 22.91           O  
ATOM    331  CB  ARG A 121      21.869  43.830  73.553  1.00 21.77           C  
ATOM    332  CG  ARG A 121      21.930  43.702  74.981  1.00 22.45           C  
ATOM    333  CD  ARG A 121      20.611  43.770  75.539  1.00 23.71           C  
ATOM    334  NE  ARG A 121      19.959  45.009  75.160  1.00 28.45           N  
ATOM    335  CZ  ARG A 121      18.753  45.334  75.585  1.00 31.38           C  
ATOM    336  NH1 ARG A 121      18.114  44.501  76.382  1.00 28.97           N  
ATOM    337  NH2 ARG A 121      18.194  46.488  75.228  1.00 32.88           N  
ATOM    338  N   GLU A 122      21.577  42.620  70.445  0.50 21.04           N  
ATOM    340  CA  GLU A 122      21.244  43.086  69.124  0.50 21.08           C  
ATOM    342  C   GLU A 122      21.546  44.556  68.901  0.50 19.99           C  
ATOM    344  O   GLU A 122      21.225  45.467  69.687  0.50 18.99           O  
ATOM    346  CB  GLU A 122      19.781  42.770  68.746  0.50 20.81           C  
ATOM    348  CG  GLU A 122      18.732  43.900  68.972  0.50 24.54           C  
ATOM    350  CD  GLU A 122      17.640  43.911  67.899  0.50 27.97           C  
ATOM    352  OE1 GLU A 122      16.735  44.782  67.952  0.50 30.78           O  
ATOM    354  OE2 GLU A 122      17.679  43.043  66.990  0.50 30.45           O  
ATOM    356  N   SER A 123      22.108  44.738  67.729  1.00 19.52           N  
ATOM    357  CA  SER A 123      22.707  45.983  67.246  1.00 18.54           C  
ATOM    358  C   SER A 123      21.608  46.942  66.860  1.00 18.55           C  
ATOM    359  O   SER A 123      20.645  46.579  66.155  1.00 18.19           O  
ATOM    360  CB  SER A 123      23.565  45.680  66.006  1.00 17.95           C  
ATOM    361  OG  SER A 123      24.014  46.884  65.380  1.00 16.75           O  
HETATM  362  N   MSE A 124      21.779  48.188  67.299  1.00 18.23           N  
HETATM  363  CA  MSE A 124      20.889  49.279  66.907  1.00 19.71           C  
HETATM  364  C   MSE A 124      21.524  50.015  65.749  1.00 18.66           C  
HETATM  365  O   MSE A 124      21.036  51.044  65.250  1.00 20.33           O  
HETATM  366  CB  MSE A 124      20.691  50.234  68.066  1.00 19.97           C  
HETATM  367  CG  MSE A 124      19.879  49.649  69.183  1.00 24.83           C  
HETATM  368 SE   MSE A 124      18.068  49.352  68.611  1.00 44.96          SE  
HETATM  369  CE  MSE A 124      18.046  47.511  68.748  1.00 28.12           C  
ATOM    370  N   GLN A 125      22.643  49.497  65.313  1.00 18.51           N  
ATOM    371  CA  GLN A 125      23.198  50.025  64.148  1.00 18.06           C  
ATOM    372  C   GLN A 125      22.740  48.981  63.137  1.00 20.64           C  
ATOM    373  O   GLN A 125      21.537  48.600  63.148  1.00 22.31           O  
ATOM    374  CB  GLN A 125      24.697  50.357  64.369  1.00 17.90           C  
ATOM    375  CG  GLN A 125      24.930  51.499  65.450  1.00 14.86           C  
ATOM    376  CD  GLN A 125      25.174  51.005  66.906  1.00 13.29           C  
ATOM    377  OE1 GLN A 125      24.837  49.861  67.281  1.00 14.33           O  
ATOM    378  NE2 GLN A 125      25.732  51.878  67.736  1.00 12.79           N  
ATOM    379  N   ALA A 126      23.634  48.528  62.289  1.00 16.65           N  
ATOM    380  CA  ALA A 126      23.297  47.587  61.237  1.00 15.70           C  
ATOM    381  C   ALA A 126      24.379  46.523  61.262  1.00 14.78           C  
ATOM    382  O   ALA A 126      24.756  45.977  60.233  1.00 14.87           O  
ATOM    383  CB  ALA A 126      23.269  48.314  59.904  1.00 15.00           C  
ATOM    384  N   LEU A 127      24.886  46.218  62.447  1.00 14.92           N  
ATOM    385  CA  LEU A 127      25.993  45.259  62.525  1.00 15.47           C  
ATOM    386  C   LEU A 127      25.520  43.837  62.381  1.00 17.64           C  
ATOM    387  O   LEU A 127      24.663  43.385  63.146  1.00 19.47           O  
ATOM    388  CB  LEU A 127      26.805  45.440  63.804  1.00 16.03           C  
ATOM    389  CG  LEU A 127      28.109  44.623  63.913  1.00 15.67           C  
ATOM    390  CD1 LEU A 127      29.145  45.233  62.952  1.00 18.44           C  
ATOM    391  N   ARG A 128      26.117  43.092  61.444  0.50 17.95           N  
ATOM    393  CA  ARG A 128      25.732  41.682  61.211  0.50 19.20           C  
ATOM    395  C   ARG A 128      26.840  40.662  61.395  0.50 19.49           C  
ATOM    397  O   ARG A 128      27.283  40.013  60.441  0.50 18.94           O  
ATOM    399  CB  ARG A 128      25.151  41.494  59.812  1.00 20.02           C  
ATOM    400  CG  ARG A 128      23.862  42.292  59.601  1.00 22.46           C  
ATOM    401  CD  ARG A 128      22.831  41.596  58.755  1.00 28.52           C  
ATOM    402  NE  ARG A 128      21.604  42.394  58.670  1.00 32.79           N  
ATOM    403  CZ  ARG A 128      20.568  42.134  57.868  1.00 33.70           C  
ATOM    404  NH1 ARG A 128      20.568  41.087  57.054  1.00 34.40           N  
ATOM    405  NH2 ARG A 128      19.514  42.936  57.891  1.00 36.12           N  
ATOM    406  N   CYS A 129      27.260  40.479  62.628  0.50 20.04           N  
ATOM    408  CA  CYS A 129      28.391  39.605  62.881  0.50 21.08           C  
ATOM    410  C   CYS A 129      28.019  38.135  63.155  0.50 21.01           C  
ATOM    412  O   CYS A 129      26.843  37.750  63.067  1.00 20.78           O  
ATOM    413  CB  CYS A 129      29.247  40.211  63.982  1.00 21.69           C  
ATOM    414  SG  CYS A 129      28.593  40.007  65.656  1.00 25.86           S  
ATOM    415  N   SER A 130      29.028  37.312  63.435  1.00 20.06           N  
ATOM    416  CA  SER A 130      28.834  35.874  63.510  1.00 20.58           C  
ATOM    417  C   SER A 130      28.129  35.392  64.773  1.00 20.99           C  
ATOM    418  O   SER A 130      27.688  34.248  64.813  1.00 22.59           O  
ATOM    419  CB  SER A 130      30.155  35.127  63.320  1.00 20.97           C  
ATOM    420  OG  SER A 130      30.612  35.243  61.986  1.00 19.98           O  
ATOM    421  N   PHE A 131      28.023  36.256  65.775  1.00 21.18           N  
ATOM    422  CA  PHE A 131      27.401  35.913  67.050  1.00 21.64           C  
ATOM    423  C   PHE A 131      25.899  36.140  66.984  1.00 21.70           C  
ATOM    424  O   PHE A 131      25.440  37.255  66.744  1.00 22.46           O  
ATOM    425  CB  PHE A 131      28.041  36.742  68.157  1.00 22.22           C  
ATOM    426  CG  PHE A 131      29.473  36.388  68.392  1.00 23.10           C  
ATOM    427  CD1 PHE A 131      29.807  35.220  69.080  1.00 23.81           C  
ATOM    428  CD2 PHE A 131      30.494  37.186  67.889  1.00 20.86           C  
ATOM    429  CE1 PHE A 131      31.126  34.861  69.290  1.00 24.82           C  
ATOM    430  CE2 PHE A 131      31.819  36.837  68.096  1.00 23.27           C  
ATOM    431  CZ  PHE A 131      32.141  35.664  68.815  1.00 23.33           C  
ATOM    432  N   VAL A 132      25.151  35.061  67.206  1.00 20.53           N  
ATOM    433  CA  VAL A 132      23.691  35.078  67.084  1.00 19.29           C  
ATOM    434  C   VAL A 132      23.125  34.336  68.300  1.00 18.38           C  
ATOM    435  O   VAL A 132      23.560  33.229  68.606  1.00 18.25           O  
ATOM    436  CB  VAL A 132      23.242  34.365  65.781  1.00 20.18           C  
ATOM    437  CG1 VAL A 132      21.702  34.193  65.726  1.00 21.38           C  
ATOM    438  CG2 VAL A 132      23.712  35.160  64.547  1.00 20.92           C  
ATOM    439  N   GLN A 133      22.160  34.947  68.981  0.50 18.18           N  
ATOM    441  CA  GLN A 133      21.512  34.292  70.111  0.50 17.16           C  
ATOM    443  C   GLN A 133      21.006  32.896  69.741  0.50 17.27           C  
ATOM    445  O   GLN A 133      20.354  32.710  68.702  0.50 17.22           O  
ATOM    447  CB  GLN A 133      20.356  35.143  70.640  0.50 17.25           C  
ATOM    449  CG  GLN A 133      19.879  34.673  71.989  0.50 15.48           C  
ATOM    451  CD  GLN A 133      18.872  35.611  72.616  0.50 14.45           C  
ATOM    453  OE1 GLN A 133      19.153  36.786  72.867  0.50 12.88           O  
ATOM    455  NE2 GLN A 133      17.695  35.085  72.904  0.50 17.32           N  
ATOM    457  N   GLY A 134      21.320  31.922  70.593  1.00 16.60           N  
ATOM    458  CA  GLY A 134      20.893  30.527  70.374  1.00 17.55           C  
ATOM    459  C   GLY A 134      21.800  29.730  69.457  1.00 17.54           C  
ATOM    460  O   GLY A 134      21.562  28.532  69.226  1.00 18.62           O  
ATOM    461  N   GLN A 135      22.819  30.390  68.922  1.00 17.46           N  
ATOM    462  CA  GLN A 135      23.823  29.714  68.087  1.00 18.10           C  
ATOM    463  C   GLN A 135      25.198  29.746  68.763  1.00 17.62           C  
ATOM    464  O   GLN A 135      25.473  30.598  69.604  1.00 16.56           O  
ATOM    465  CB  GLN A 135      23.886  30.333  66.684  1.00 19.53           C  
ATOM    466  CG  GLN A 135      22.550  30.259  65.890  1.00 23.94           C  
ATOM    467  CD  GLN A 135      21.983  28.841  65.728  1.00 28.42           C  
ATOM    468  OE1 GLN A 135      22.704  27.886  65.372  1.00 30.30           O  
ATOM    469  NE2 GLN A 135      20.675  28.702  65.958  1.00 30.11           N  
ATOM    470  N   SER A 136      26.046  28.790  68.370  1.00 17.45           N  
ATOM    471  CA  SER A 136      27.380  28.669  68.934  1.00 17.43           C  
ATOM    472  C   SER A 136      28.482  28.750  67.874  1.00 18.74           C  
ATOM    473  O   SER A 136      28.235  28.565  66.671  1.00 19.75           O  
ATOM    474  CB  SER A 136      27.523  27.356  69.693  1.00 17.58           C  
ATOM    475  OG  SER A 136      27.339  26.280  68.805  1.00 15.42           O  
ATOM    476  N   GLN A 137      29.684  29.070  68.337  1.00 19.19           N  
ATOM    477  CA  GLN A 137      30.897  29.197  67.527  0.50 19.56           C  
ATOM    479  C   GLN A 137      31.979  28.322  68.155  1.00 19.43           C  
ATOM    480  O   GLN A 137      31.979  28.151  69.359  1.00 18.74           O  
ATOM    481  CB  GLN A 137      31.391  30.651  67.565  0.50 20.91           C  
ATOM    483  CG  GLN A 137      30.552  31.645  66.740  0.50 21.56           C  
ATOM    485  CD  GLN A 137      30.794  31.510  65.237  0.50 25.01           C  
ATOM    487  OE1 GLN A 137      31.939  31.525  64.768  0.50 26.76           O  
ATOM    489  NE2 GLN A 137      29.712  31.377  64.477  0.50 25.24           N  
ATOM    491  N   PRO A 138      32.960  27.862  67.369  1.00 19.12           N  
ATOM    492  CA  PRO A 138      34.040  27.122  68.027  1.00 19.14           C  
ATOM    493  C   PRO A 138      34.738  27.945  69.115  1.00 19.35           C  
ATOM    494  O   PRO A 138      34.945  29.160  68.963  1.00 19.16           O  
ATOM    495  CB  PRO A 138      35.016  26.828  66.868  1.00 19.93           C  
ATOM    496  CG  PRO A 138      34.173  26.905  65.633  1.00 21.40           C  
ATOM    497  CD  PRO A 138      33.161  27.971  65.912  1.00 19.99           C  
ATOM    498  N   LEU A 139      35.099  27.272  70.204  1.00 19.41           N  
ATOM    499  CA  LEU A 139      35.786  27.876  71.328  1.00 21.49           C  
ATOM    500  C   LEU A 139      37.270  27.915  71.002  1.00 21.18           C  
ATOM    501  O   LEU A 139      38.052  27.008  71.366  1.00 21.84           O  
ATOM    502  CB  LEU A 139      35.482  27.040  72.581  1.00 22.42           C  
ATOM    503  CG  LEU A 139      35.340  27.622  73.977  1.00 25.13           C  
ATOM    504  CD1 LEU A 139      34.692  28.930  74.028  1.00 27.72           C  
ATOM    505  CD2 LEU A 139      34.663  26.569  74.916  1.00 24.39           C  
ATOM    506  N   LEU A 140      37.663  28.966  70.267  1.00 20.73           N  
ATOM    507  CA  LEU A 140      39.011  29.013  69.695  1.00 21.68           C  
ATOM    508  C   LEU A 140      39.433  30.435  69.370  1.00 22.44           C  
ATOM    509  O   LEU A 140      40.493  30.871  69.824  1.00 23.65           O  
ATOM    510  CB  LEU A 140      39.101  28.140  68.435  1.00 21.70           C  
ATOM    511  CG  LEU A 140      40.384  28.147  67.577  1.00 22.19           C  
ATOM    512  CD1 LEU A 140      41.493  27.506  68.400  1.00 23.93           C  
ATOM    513  CD2 LEU A 140      40.187  27.398  66.275  1.00 23.46           C  
ATOM    514  N   ARG A 141      38.624  31.134  68.574  1.00 20.51           N  
ATOM    515  CA  ARG A 141      38.925  32.498  68.150  1.00 20.10           C  
ATOM    516  C   ARG A 141      38.082  33.522  68.909  1.00 19.47           C  
ATOM    517  O   ARG A 141      36.969  33.223  69.341  1.00 19.70           O  
ATOM    518  CB  ARG A 141      38.686  32.667  66.650  1.00 21.31           C  
ATOM    519  CG  ARG A 141      39.478  31.703  65.747  1.00 24.08           C  
ATOM    520  CD  ARG A 141      40.969  31.759  66.008  1.00 31.91           C  
ATOM    521  NE  ARG A 141      41.697  30.807  65.163  1.00 37.88           N  
ATOM    522  CZ  ARG A 141      42.939  30.370  65.396  1.00 40.17           C  
ATOM    523  NH1 ARG A 141      43.622  30.789  66.458  1.00 40.44           N  
ATOM    524  NH2 ARG A 141      43.493  29.502  64.562  1.00 40.89           N  
ATOM    525  N   GLY A 142      38.630  34.728  69.044  1.00 17.41           N  
ATOM    526  CA  GLY A 142      37.868  35.855  69.592  1.00 17.76           C  
ATOM    527  C   GLY A 142      38.031  36.005  71.092  1.00 17.06           C  
ATOM    528  O   GLY A 142      38.316  35.037  71.800  1.00 16.86           O  
ATOM    529  N   ALA A 143      37.795  37.229  71.566  1.00 16.36           N  
ATOM    530  CA  ALA A 143      37.931  37.555  72.992  1.00 16.20           C  
ATOM    531  C   ALA A 143      37.109  36.656  73.912  1.00 16.07           C  
ATOM    532  O   ALA A 143      37.606  36.266  74.947  1.00 16.80           O  
ATOM    533  CB  ALA A 143      37.576  39.018  73.223  1.00 16.49           C  
ATOM    534  N   SER A 144      35.872  36.323  73.531  1.00 17.27           N  
ATOM    535  CA  SER A 144      34.998  35.523  74.396  1.00 17.96           C  
ATOM    536  C   SER A 144      35.592  34.125  74.591  1.00 18.19           C  
ATOM    537  O   SER A 144      35.666  33.623  75.722  1.00 18.29           O  
ATOM    538  CB  SER A 144      33.614  35.351  73.748  1.00 18.87           C  
ATOM    539  OG  SER A 144      32.977  36.589  73.533  1.00 24.48           O  
ATOM    540  N   SER A 145      36.002  33.506  73.482  1.00 17.85           N  
ATOM    541  CA  SER A 145      36.634  32.167  73.538  1.00 18.58           C  
ATOM    542  C   SER A 145      37.901  32.215  74.386  1.00 17.62           C  
ATOM    543  O   SER A 145      38.116  31.340  75.235  1.00 18.74           O  
ATOM    544  CB  SER A 145      37.010  31.647  72.144  1.00 19.01           C  
ATOM    545  OG  SER A 145      35.843  31.414  71.391  1.00 22.56           O  
ATOM    546  N   LYS A 146      38.719  33.245  74.193  0.50 17.18           N  
ATOM    548  CA  LYS A 146      40.011  33.313  74.883  0.50 17.56           C  
ATOM    550  C   LYS A 146      39.876  33.572  76.393  0.50 17.86           C  
ATOM    552  O   LYS A 146      40.679  33.079  77.177  0.50 17.76           O  
ATOM    554  CB  LYS A 146      40.917  34.353  74.231  0.50 17.68           C  
ATOM    556  CG  LYS A 146      41.415  33.965  72.855  0.50 17.88           C  
ATOM    558  CD  LYS A 146      42.360  35.049  72.388  0.50 20.07           C  
ATOM    560  CE  LYS A 146      42.502  35.090  70.898  0.50 22.99           C  
ATOM    562  NZ  LYS A 146      43.150  36.381  70.528  0.50 21.64           N  
ATOM    564  N   VAL A 147      38.872  34.356  76.796  1.00 17.64           N  
ATOM    565  CA  VAL A 147      38.561  34.541  78.222  1.00 19.26           C  
ATOM    566  C   VAL A 147      38.123  33.227  78.873  1.00 19.62           C  
ATOM    567  O   VAL A 147      38.597  32.866  79.965  1.00 19.24           O  
ATOM    568  CB  VAL A 147      37.444  35.586  78.392  1.00 19.36           C  
ATOM    569  CG1 VAL A 147      36.763  35.437  79.752  1.00 23.59           C  
ATOM    570  CG2 VAL A 147      38.050  36.922  78.222  1.00 21.79           C  
HETATM  571  N   MSE A 148      37.263  32.486  78.183  1.00 19.02           N  
HETATM  572  CA  MSE A 148      36.740  31.251  78.743  1.00 21.01           C  
HETATM  573  C   MSE A 148      37.848  30.209  78.824  1.00 19.59           C  
HETATM  574  O   MSE A 148      38.003  29.541  79.857  1.00 19.81           O  
HETATM  575  CB  MSE A 148      35.515  30.776  77.962  1.00 20.37           C  
HETATM  576  CG  MSE A 148      34.350  31.754  78.201  1.00 20.01           C  
HETATM  577 SE   MSE A 148      32.673  31.191  77.412  1.00 33.01          SE  
HETATM  578  CE  MSE A 148      33.233  30.853  75.705  1.00 26.53           C  
ATOM    579  N   LEU A 149      38.649  30.110  77.761  1.00 17.58           N  
ATOM    580  CA  LEU A 149      39.813  29.189  77.767  1.00 17.94           C  
ATOM    581  C   LEU A 149      40.813  29.540  78.884  1.00 17.67           C  
ATOM    582  O   LEU A 149      41.362  28.638  79.540  1.00 19.48           O  
ATOM    583  CB  LEU A 149      40.516  29.177  76.416  1.00 18.06           C  
ATOM    584  CG  LEU A 149      39.707  28.507  75.300  1.00 18.99           C  
ATOM    585  CD1 LEU A 149      40.336  28.911  73.928  1.00 20.89           C  
ATOM    586  CD2 LEU A 149      39.683  26.972  75.492  1.00 21.34           C  
ATOM    587  N   ALA A 150      41.045  30.832  79.104  1.00 17.13           N  
ATOM    588  CA  ALA A 150      42.007  31.263  80.144  1.00 17.78           C  
ATOM    589  C   ALA A 150      41.539  30.934  81.567  1.00 18.19           C  
ATOM    590  O   ALA A 150      42.366  30.666  82.456  1.00 19.04           O  
ATOM    591  CB  ALA A 150      42.307  32.751  80.039  1.00 17.06           C  
ATOM    592  N   TYR A 151      40.226  30.973  81.784  1.00 18.00           N  
ATOM    593  CA  TYR A 151      39.671  30.864  83.147  1.00 18.30           C  
ATOM    594  C   TYR A 151      39.098  29.506  83.534  1.00 18.82           C  
ATOM    595  O   TYR A 151      38.902  29.243  84.732  1.00 19.57           O  
ATOM    596  CB  TYR A 151      38.632  31.965  83.414  1.00 17.95           C  
ATOM    597  CG  TYR A 151      39.245  33.296  83.760  1.00 18.33           C  
ATOM    598  CD1 TYR A 151      39.599  34.204  82.772  1.00 17.43           C  
ATOM    599  CD2 TYR A 151      39.491  33.641  85.094  1.00 18.69           C  
ATOM    600  CE1 TYR A 151      40.178  35.454  83.102  1.00 19.12           C  
ATOM    601  CE2 TYR A 151      40.055  34.865  85.430  1.00 20.69           C  
ATOM    602  CZ  TYR A 151      40.389  35.768  84.438  1.00 20.29           C  
ATOM    603  OH  TYR A 151      40.946  36.975  84.827  1.00 21.81           O  
HETATM  604  N   MSE A 152      38.801  28.662  82.545  1.00 19.13           N  
HETATM  605  CA  MSE A 152      38.408  27.276  82.831  1.00 20.79           C  
HETATM  606  C   MSE A 152      39.621  26.459  83.336  1.00 19.97           C  
HETATM  607  O   MSE A 152      40.762  26.909  83.243  1.00 19.16           O  
HETATM  608  CB  MSE A 152      37.800  26.622  81.583  1.00 20.45           C  
HETATM  609  CG  MSE A 152      38.793  26.411  80.487  1.00 21.39           C  
HETATM  610 SE   MSE A 152      37.950  25.462  78.983  1.00 27.10          SE  
HETATM  611  CE  MSE A 152      36.456  26.685  78.638  1.00 23.20           C  
ATOM    612  N   PRO A 153      39.377  25.248  83.879  1.00 20.20           N  
ATOM    613  CA  PRO A 153      40.485  24.383  84.288  1.00 20.21           C  
ATOM    614  C   PRO A 153      41.420  24.079  83.126  1.00 20.52           C  
ATOM    615  O   PRO A 153      40.967  23.892  81.983  1.00 20.63           O  
ATOM    616  CB  PRO A 153      39.769  23.113  84.742  1.00 20.15           C  
ATOM    617  CG  PRO A 153      38.445  23.631  85.252  1.00 20.34           C  
ATOM    618  CD  PRO A 153      38.076  24.617  84.166  1.00 20.60           C  
ATOM    619  N   ALA A 154      42.715  24.047  83.422  1.00 20.98           N  
ATOM    620  CA  ALA A 154      43.730  23.768  82.405  1.00 20.95           C  
ATOM    621  C   ALA A 154      43.442  22.532  81.563  1.00 20.91           C  
ATOM    622  O   ALA A 154      43.584  22.578  80.335  1.00 20.67           O  
ATOM    623  CB  ALA A 154      45.097  23.650  83.051  1.00 21.63           C  
ATOM    624  N   ALA A 155      43.072  21.428  82.217  1.00 19.78           N  
ATOM    625  CA  ALA A 155      42.835  20.154  81.533  1.00 19.90           C  
ATOM    626  C   ALA A 155      41.748  20.280  80.478  1.00 19.91           C  
ATOM    627  O   ALA A 155      41.863  19.706  79.390  1.00 20.41           O  
ATOM    628  CB  ALA A 155      42.464  19.092  82.528  1.00 20.09           C  
ATOM    629  N   ARG A 156      40.699  21.025  80.828  0.50 19.52           N  
ATOM    631  CA  ARG A 156      39.560  21.257  79.953  0.50 19.24           C  
ATOM    633  C   ARG A 156      40.031  22.071  78.746  0.50 19.40           C  
ATOM    635  O   ARG A 156      39.801  21.699  77.588  0.50 19.43           O  
ATOM    637  CB  ARG A 156      38.468  22.007  80.717  0.50 18.97           C  
ATOM    639  CG  ARG A 156      37.143  22.133  79.985  0.50 19.44           C  
ATOM    641  CD  ARG A 156      36.134  22.993  80.781  0.50 18.89           C  
ATOM    643  NE  ARG A 156      34.884  23.173  80.037  0.50 19.66           N  
ATOM    645  CZ  ARG A 156      33.790  23.803  80.471  0.50 17.54           C  
ATOM    647  NH1 ARG A 156      33.729  24.350  81.689  0.50 20.25           N  
ATOM    649  NH2 ARG A 156      32.731  23.877  79.671  0.50 17.24           N  
ATOM    651  N   CYS A 157      40.699  23.186  79.037  1.00 19.77           N  
ATOM    652  CA  CYS A 157      41.250  24.062  78.013  1.00 19.42           C  
ATOM    653  C   CYS A 157      42.152  23.269  77.033  1.00 19.47           C  
ATOM    654  O   CYS A 157      42.040  23.426  75.818  1.00 18.67           O  
ATOM    655  CB  CYS A 157      42.021  25.224  78.658  1.00 19.69           C  
ATOM    656  SG  CYS A 157      43.002  26.170  77.479  1.00 21.47           S  
ATOM    657  N   GLU A 158      43.002  22.395  77.569  1.00 20.02           N  
ATOM    658  CA  GLU A 158      43.907  21.598  76.731  1.00 20.82           C  
ATOM    659  C   GLU A 158      43.157  20.672  75.771  1.00 20.80           C  
ATOM    660  O   GLU A 158      43.505  20.585  74.576  1.00 20.92           O  
ATOM    661  CB  GLU A 158      44.912  20.816  77.600  1.00 21.28           C  
ATOM    662  CG  GLU A 158      45.845  21.758  78.362  1.00 26.43           C  
ATOM    663  CD  GLU A 158      46.567  21.065  79.514  1.00 30.48           C  
ATOM    664  OE1 GLU A 158      46.397  19.835  79.708  1.00 37.25           O  
ATOM    665  OE2 GLU A 158      47.314  21.759  80.225  1.00 35.16           O  
ATOM    666  N   LYS A 159      42.106  20.018  76.266  1.00 19.55           N  
ATOM    667  CA  LYS A 159      41.285  19.114  75.440  1.00 20.19           C  
ATOM    668  C   LYS A 159      40.664  19.856  74.268  1.00 19.34           C  
ATOM    669  O   LYS A 159      40.583  19.344  73.135  1.00 19.68           O  
ATOM    670  CB  LYS A 159      40.157  18.485  76.277  1.00 19.86           C  
ATOM    671  CG  LYS A 159      40.591  17.390  77.223  1.00 23.23           C  
ATOM    672  CD  LYS A 159      39.367  16.847  77.928  1.00 25.85           C  
ATOM    673  CE  LYS A 159      39.742  15.720  78.859  1.00 26.45           C  
ATOM    674  NZ  LYS A 159      38.587  15.395  79.731  1.00 28.76           N  
ATOM    675  N   ILE A 160      40.197  21.073  74.544  1.00 17.68           N  
ATOM    676  CA  ILE A 160      39.534  21.852  73.528  1.00 18.26           C  
ATOM    677  C   ILE A 160      40.549  22.291  72.472  1.00 17.88           C  
ATOM    678  O   ILE A 160      40.334  22.110  71.291  1.00 17.92           O  
ATOM    679  CB  ILE A 160      38.801  23.078  74.152  1.00 17.82           C  
ATOM    680  CG1 ILE A 160      37.632  22.573  75.000  1.00 18.73           C  
ATOM    681  CG2 ILE A 160      38.295  24.001  73.068  1.00 20.49           C  
ATOM    682  CD1 ILE A 160      37.026  23.643  75.926  1.00 19.27           C  
ATOM    683  N   LEU A 161      41.675  22.844  72.907  1.00 18.29           N  
ATOM    684  CA  LEU A 161      42.663  23.359  71.947  1.00 18.50           C  
ATOM    685  C   LEU A 161      43.200  22.189  71.100  1.00 18.65           C  
ATOM    686  O   LEU A 161      43.405  22.347  69.889  1.00 18.90           O  
ATOM    687  CB  LEU A 161      43.801  24.081  72.669  1.00 19.06           C  
ATOM    688  CG  LEU A 161      43.431  25.489  73.169  1.00 21.34           C  
ATOM    689  CD1 LEU A 161      44.675  26.138  73.733  1.00 25.12           C  
ATOM    690  CD2 LEU A 161      42.850  26.339  72.069  1.00 25.37           C  
ATOM    691  N   ARG A 162      43.435  21.034  71.738  1.00 18.11           N  
ATOM    692  CA  ARG A 162      43.939  19.864  70.980  1.00 17.88           C  
ATOM    693  C   ARG A 162      42.930  19.381  69.924  1.00 18.00           C  
ATOM    694  O   ARG A 162      43.291  18.935  68.812  1.00 18.18           O  
ATOM    695  CB  ARG A 162      44.383  18.722  71.899  1.00 18.23           C  
ATOM    696  CG  ARG A 162      45.622  19.104  72.732  1.00 19.44           C  
ATOM    697  CD  ARG A 162      46.426  17.940  73.251  1.00 21.89           C  
ATOM    698  NE  ARG A 162      47.730  18.429  73.723  1.00 25.28           N  
ATOM    699  CZ  ARG A 162      48.041  18.660  74.997  1.00 26.82           C  
ATOM    700  NH1 ARG A 162      47.149  18.437  75.964  1.00 26.29           N  
ATOM    701  NH2 ARG A 162      49.251  19.119  75.304  1.00 26.18           N  
ATOM    702  N   TYR A 163      41.649  19.428  70.264  1.00 17.18           N  
ATOM    703  CA  TYR A 163      40.641  19.082  69.268  1.00 16.73           C  
ATOM    704  C   TYR A 163      40.748  19.972  68.035  1.00 16.69           C  
ATOM    705  O   TYR A 163      40.643  19.506  66.919  1.00 17.45           O  
ATOM    706  CB  TYR A 163      39.260  19.240  69.875  1.00 16.86           C  
ATOM    707  CG  TYR A 163      38.151  19.094  68.874  1.00 15.11           C  
ATOM    708  CD1 TYR A 163      37.922  17.866  68.241  1.00 14.97           C  
ATOM    709  CD2 TYR A 163      37.319  20.167  68.555  1.00 16.22           C  
ATOM    710  CE1 TYR A 163      36.860  17.702  67.323  1.00 14.92           C  
ATOM    711  CE2 TYR A 163      36.265  20.029  67.632  1.00 15.51           C  
ATOM    712  CZ  TYR A 163      36.046  18.779  67.026  1.00 14.70           C  
ATOM    713  OH  TYR A 163      34.996  18.660  66.122  1.00 17.22           O  
ATOM    714  N   PHE A 164      40.985  21.267  68.242  1.00 16.49           N  
ATOM    715  CA  PHE A 164      41.087  22.188  67.122  1.00 17.02           C  
ATOM    716  C   PHE A 164      42.490  22.234  66.509  1.00 17.61           C  
ATOM    717  O   PHE A 164      42.771  23.105  65.677  1.00 19.58           O  
ATOM    718  CB  PHE A 164      40.655  23.577  67.576  1.00 18.07           C  
ATOM    719  CG  PHE A 164      39.178  23.690  67.807  1.00 15.99           C  
ATOM    720  CD1 PHE A 164      38.265  23.419  66.768  1.00 18.81           C  
ATOM    721  CD2 PHE A 164      38.680  24.042  69.073  1.00 17.68           C  
ATOM    722  CE1 PHE A 164      36.875  23.494  66.981  1.00 19.48           C  
ATOM    723  CE2 PHE A 164      37.281  24.158  69.278  1.00 15.84           C  
ATOM    724  CZ  PHE A 164      36.387  23.866  68.245  1.00 17.67           C  
ATOM    725  N   GLY A 165      43.378  21.340  66.937  1.00 17.13           N  
ATOM    726  CA  GLY A 165      44.696  21.205  66.305  1.00 17.95           C  
ATOM    727  C   GLY A 165      45.730  22.225  66.774  1.00 17.47           C  
ATOM    728  O   GLY A 165      46.769  22.413  66.144  1.00 19.68           O  
ATOM    729  N   GLU A 166      45.460  22.843  67.914  1.00 18.90           N  
ATOM    730  CA  GLU A 166      46.382  23.773  68.540  1.00 20.31           C  
ATOM    731  C   GLU A 166      47.183  23.047  69.598  1.00 21.18           C  
ATOM    732  O   GLU A 166      46.714  22.062  70.181  1.00 20.94           O  
ATOM    733  CB  GLU A 166      45.621  24.932  69.185  1.00 19.83           C  
ATOM    734  CG  GLU A 166      44.843  25.805  68.200  1.00 21.37           C  
ATOM    735  CD  GLU A 166      45.747  26.621  67.246  1.00 26.56           C  
ATOM    736  OE1 GLU A 166      46.805  27.142  67.675  1.00 26.98           O  
ATOM    737  OE2 GLU A 166      45.375  26.749  66.060  1.00 28.90           O  
ATOM    738  N   ASP A 167      48.410  23.524  69.809  1.00 22.30           N  
ATOM    739  CA  ASP A 167      49.297  22.989  70.835  1.00 23.19           C  
ATOM    740  C   ASP A 167      49.233  23.950  72.013  1.00 23.88           C  
ATOM    741  O   ASP A 167      49.817  25.033  71.957  1.00 23.00           O  
ATOM    742  CB  ASP A 167      50.727  22.852  70.293  1.00 23.65           C  
ATOM    743  CG  ASP A 167      51.732  22.369  71.350  1.00 25.02           C  
ATOM    744  OD1 ASP A 167      51.356  22.194  72.530  1.00 25.45           O  
ATOM    745  OD2 ASP A 167      52.914  22.155  70.986  1.00 26.52           O  
ATOM    746  N   PRO A 168      48.528  23.550  73.087  1.00 24.49           N  
ATOM    747  CA  PRO A 168      48.298  24.479  74.207  1.00 25.54           C  
ATOM    748  C   PRO A 168      49.581  24.873  74.959  1.00 26.33           C  
ATOM    749  O   PRO A 168      49.588  25.883  75.667  1.00 26.47           O  
ATOM    750  CB  PRO A 168      47.346  23.700  75.122  1.00 26.45           C  
ATOM    751  CG  PRO A 168      47.585  22.259  74.799  1.00 25.60           C  
ATOM    752  CD  PRO A 168      47.891  22.235  73.317  1.00 25.42           C  
ATOM    753  N   THR A 169      50.633  24.073  74.806  1.00 26.88           N  
ATOM    754  CA  THR A 169      51.891  24.299  75.529  1.00 27.44           C  
ATOM    755  C   THR A 169      52.751  25.393  74.900  1.00 27.77           C  
ATOM    756  O   THR A 169      53.760  25.794  75.488  1.00 28.39           O  
ATOM    757  CB  THR A 169      52.738  23.011  75.659  1.00 27.16           C  
ATOM    758  OG1 THR A 169      53.291  22.672  74.384  1.00 28.28           O  
ATOM    759  CG2 THR A 169      51.915  21.835  76.207  1.00 27.81           C  
ATOM    760  N   LEU A 170      52.361  25.891  73.725  1.00 27.92           N  
ATOM    761  CA  LEU A 170      53.155  26.931  73.062  1.00 28.36           C  
ATOM    762  C   LEU A 170      53.005  28.276  73.756  1.00 28.84           C  
ATOM    763  O   LEU A 170      51.948  28.586  74.327  1.00 28.02           O  
ATOM    764  CB  LEU A 170      52.790  27.069  71.583  1.00 28.49           C  
ATOM    765  CG  LEU A 170      53.008  25.867  70.670  1.00 28.19           C  
ATOM    766  CD1 LEU A 170      52.478  26.198  69.295  1.00 28.56           C  
ATOM    767  CD2 LEU A 170      54.492  25.468  70.591  1.00 28.50           C  
ATOM    768  N   ASP A 171      54.069  29.076  73.686  1.00 29.87           N  
ATOM    769  CA  ASP A 171      54.073  30.406  74.274  1.00 30.82           C  
ATOM    770  C   ASP A 171      52.969  31.303  73.751  1.00 31.16           C  
ATOM    771  O   ASP A 171      52.431  32.105  74.509  1.00 32.05           O  
ATOM    772  CB  ASP A 171      55.429  31.084  74.071  1.00 31.64           C  
ATOM    773  CG  ASP A 171      56.496  30.563  75.017  1.00 33.51           C  
ATOM    774  OD1 ASP A 171      56.473  29.360  75.367  1.00 37.06           O  
ATOM    775  OD2 ASP A 171      57.384  31.363  75.399  1.00 37.43           O  
ATOM    776  N   LYS A 172      52.618  31.193  72.471  1.00 30.95           N  
ATOM    777  CA  LYS A 172      51.577  32.077  71.920  1.00 31.14           C  
ATOM    778  C   LYS A 172      50.204  31.884  72.584  1.00 30.38           C  
ATOM    779  O   LYS A 172      49.405  32.833  72.671  1.00 31.13           O  
ATOM    780  CB  LYS A 172      51.486  31.988  70.391  1.00 31.62           C  
ATOM    781  CG  LYS A 172      50.880  30.724  69.830  1.00 34.00           C  
ATOM    782  CD  LYS A 172      51.090  30.703  68.331  1.00 37.59           C  
ATOM    783  CE  LYS A 172      50.277  29.608  67.672  1.00 40.03           C  
ATOM    784  NZ  LYS A 172      50.507  29.621  66.192  1.00 41.95           N  
ATOM    785  N   TRP A 173      49.944  30.665  73.061  1.00 28.75           N  
ATOM    786  CA  TRP A 173      48.765  30.400  73.881  1.00 27.14           C  
ATOM    787  C   TRP A 173      48.997  30.749  75.356  1.00 26.98           C  
ATOM    788  O   TRP A 173      48.217  31.493  75.957  1.00 26.30           O  
ATOM    789  CB  TRP A 173      48.302  28.935  73.709  1.00 27.04           C  
ATOM    790  CG  TRP A 173      47.568  28.729  72.421  1.00 25.61           C  
ATOM    791  CD1 TRP A 173      48.007  28.040  71.324  1.00 25.21           C  
ATOM    792  CD2 TRP A 173      46.292  29.283  72.069  1.00 25.12           C  
ATOM    793  NE1 TRP A 173      47.065  28.109  70.322  1.00 24.98           N  
ATOM    794  CE2 TRP A 173      46.009  28.871  70.747  1.00 24.96           C  
ATOM    795  CE3 TRP A 173      45.358  30.069  72.746  1.00 24.70           C  
ATOM    796  CZ2 TRP A 173      44.817  29.205  70.096  1.00 25.55           C  
ATOM    797  CZ3 TRP A 173      44.175  30.406  72.098  1.00 26.36           C  
ATOM    798  CH2 TRP A 173      43.915  29.974  70.786  1.00 26.12           C  
ATOM    799  N   GLN A 174      50.074  30.229  75.940  1.00 26.20           N  
ATOM    800  CA  GLN A 174      50.322  30.415  77.363  1.00 26.50           C  
ATOM    801  C   GLN A 174      50.506  31.888  77.731  1.00 26.29           C  
ATOM    802  O   GLN A 174      49.950  32.348  78.732  1.00 26.73           O  
ATOM    803  CB  GLN A 174      51.499  29.556  77.843  1.00 26.41           C  
ATOM    804  CG  GLN A 174      51.139  28.048  77.909  1.00 28.62           C  
ATOM    805  CD  GLN A 174      49.834  27.814  78.664  1.00 29.40           C  
ATOM    806  OE1 GLN A 174      49.610  28.406  79.720  1.00 32.95           O  
ATOM    807  NE2 GLN A 174      48.955  26.983  78.109  1.00 29.52           N  
ATOM    808  N   SER A 175      51.232  32.630  76.895  1.00 25.88           N  
ATOM    809  CA  SER A 175      51.410  34.070  77.119  1.00 26.10           C  
ATOM    810  C   SER A 175      50.080  34.830  77.048  1.00 25.62           C  
ATOM    811  O   SER A 175      49.877  35.763  77.831  1.00 25.20           O  
ATOM    812  CB  SER A 175      52.436  34.686  76.156  1.00 26.62           C  
ATOM    813  OG  SER A 175      51.952  34.643  74.822  1.00 29.52           O  
ATOM    814  N   GLU A 176      49.189  34.431  76.131  1.00 25.07           N  
ATOM    815  CA  GLU A 176      47.883  35.087  76.001  1.00 24.13           C  
ATOM    816  C   GLU A 176      47.057  34.825  77.252  1.00 23.37           C  
ATOM    817  O   GLU A 176      46.456  35.753  77.792  1.00 22.21           O  
ATOM    818  CB  GLU A 176      47.121  34.646  74.726  1.00 24.87           C  
ATOM    819  CG  GLU A 176      45.703  35.281  74.517  1.00 27.26           C  
ATOM    820  CD  GLU A 176      45.656  36.828  74.323  1.00 30.62           C  
ATOM    821  OE1 GLU A 176      46.694  37.466  74.014  1.00 32.26           O  
ATOM    822  OE2 GLU A 176      44.552  37.424  74.474  1.00 30.38           O  
ATOM    823  N   PHE A 177      47.027  33.572  77.720  1.00 22.24           N  
ATOM    824  CA  PHE A 177      46.229  33.258  78.908  1.00 21.83           C  
ATOM    825  C   PHE A 177      46.728  33.974  80.154  1.00 22.40           C  
ATOM    826  O   PHE A 177      45.921  34.465  80.945  1.00 22.58           O  
ATOM    827  CB  PHE A 177      46.148  31.763  79.172  1.00 22.37           C  
ATOM    828  CG  PHE A 177      45.499  30.978  78.068  1.00 20.54           C  
ATOM    829  CD1 PHE A 177      44.458  31.522  77.303  1.00 19.56           C  
ATOM    830  CD2 PHE A 177      45.909  29.676  77.819  1.00 23.63           C  
ATOM    831  CE1 PHE A 177      43.852  30.771  76.273  1.00 22.32           C  
ATOM    832  CE2 PHE A 177      45.315  28.931  76.814  1.00 23.57           C  
ATOM    833  CZ  PHE A 177      44.276  29.470  76.048  1.00 23.40           C  
ATOM    834  N   GLU A 178      48.048  34.045  80.320  1.00 22.32           N  
ATOM    835  CA  GLU A 178      48.630  34.774  81.460  1.00 23.16           C  
ATOM    836  C   GLU A 178      48.276  36.259  81.396  1.00 22.63           C  
ATOM    837  O   GLU A 178      47.900  36.868  82.411  1.00 22.85           O  
ATOM    838  CB  GLU A 178      50.146  34.585  81.528  1.00 23.60           C  
ATOM    839  CG  GLU A 178      50.573  33.178  81.970  1.00 26.57           C  
ATOM    840  CD  GLU A 178      51.998  32.843  81.557  1.00 30.19           C  
ATOM    841  OE1 GLU A 178      52.773  33.769  81.249  1.00 32.41           O  
ATOM    842  OE2 GLU A 178      52.348  31.642  81.529  1.00 32.97           O  
ATOM    843  N   LYS A 179      48.380  36.848  80.203  1.00 22.18           N  
ATOM    844  CA  LYS A 179      48.004  38.252  80.003  1.00 21.69           C  
ATOM    845  C   LYS A 179      46.536  38.478  80.363  1.00 20.81           C  
ATOM    846  O   LYS A 179      46.186  39.424  81.063  1.00 20.27           O  
ATOM    847  CB  LYS A 179      48.260  38.652  78.554  1.00 22.73           C  
ATOM    848  CG  LYS A 179      47.893  40.085  78.216  1.00 25.16           C  
ATOM    849  CD  LYS A 179      47.742  40.259  76.705  1.00 30.01           C  
ATOM    850  CE  LYS A 179      47.691  41.743  76.341  1.00 32.91           C  
ATOM    851  NZ  LYS A 179      47.817  41.993  74.871  1.00 34.74           N  
ATOM    852  N   ILE A 180      45.673  37.589  79.877  1.00 19.88           N  
ATOM    853  CA  ILE A 180      44.256  37.702  80.178  1.00 19.38           C  
ATOM    854  C   ILE A 180      43.967  37.630  81.684  1.00 20.08           C  
ATOM    855  O   ILE A 180      43.225  38.461  82.214  1.00 20.17           O  
ATOM    856  CB  ILE A 180      43.450  36.635  79.401  1.00 19.32           C  
ATOM    857  CG1 ILE A 180      43.524  36.944  77.903  1.00 18.81           C  
ATOM    858  CG2 ILE A 180      42.008  36.572  79.915  1.00 18.54           C  
ATOM    859  CD1 ILE A 180      42.997  35.825  77.031  1.00 19.89           C  
ATOM    860  N   ARG A 181      44.574  36.662  82.376  1.00 20.12           N  
ATOM    861  CA  ARG A 181      44.357  36.514  83.818  1.00 20.51           C  
ATOM    862  C   ARG A 181      44.903  37.698  84.625  1.00 21.00           C  
ATOM    863  O   ARG A 181      44.329  38.071  85.651  1.00 22.11           O  
ATOM    864  CB  ARG A 181      44.917  35.168  84.311  1.00 20.91           C  
ATOM    865  CG  ARG A 181      44.087  34.009  83.774  1.00 21.06           C  
ATOM    866  CD  ARG A 181      44.478  32.697  84.378  1.00 26.03           C  
ATOM    867  NE  ARG A 181      45.831  32.320  83.997  1.00 29.19           N  
ATOM    868  CZ  ARG A 181      46.150  31.326  83.166  1.00 30.21           C  
ATOM    869  NH1 ARG A 181      45.221  30.568  82.596  1.00 30.85           N  
ATOM    870  NH2 ARG A 181      47.430  31.080  82.915  1.00 31.22           N  
ATOM    871  N   ARG A 182      45.964  38.322  84.124  1.00 21.03           N  
ATOM    872  CA  ARG A 182      46.549  39.529  84.732  1.00 22.33           C  
ATOM    873  C   ARG A 182      45.581  40.714  84.584  1.00 21.31           C  
ATOM    874  O   ARG A 182      45.366  41.491  85.526  1.00 21.64           O  
ATOM    875  CB  ARG A 182      47.886  39.832  84.034  1.00 22.13           C  
ATOM    876  CG  ARG A 182      48.608  41.129  84.394  1.00 25.20           C  
ATOM    877  CD  ARG A 182      49.760  41.374  83.405  1.00 25.76           C  
ATOM    878  NE  ARG A 182      50.446  40.122  83.068  1.00 31.23           N  
ATOM    879  CZ  ARG A 182      50.871  39.787  81.847  1.00 32.37           C  
ATOM    880  NH1 ARG A 182      51.470  38.622  81.652  1.00 30.72           N  
ATOM    881  NH2 ARG A 182      50.706  40.611  80.819  1.00 33.60           N  
ATOM    882  N   HIS A 183      44.979  40.846  83.410  1.00 20.70           N  
ATOM    883  CA  HIS A 183      44.100  42.000  83.132  1.00 20.10           C  
ATOM    884  C   HIS A 183      42.647  41.815  83.590  1.00 19.23           C  
ATOM    885  O   HIS A 183      41.949  42.793  83.919  1.00 18.40           O  
ATOM    886  CB  HIS A 183      44.137  42.319  81.636  1.00 21.09           C  
ATOM    887  CG  HIS A 183      45.395  42.998  81.205  1.00 25.62           C  
ATOM    888  ND1 HIS A 183      46.400  42.344  80.528  1.00 29.45           N  
ATOM    889  CD2 HIS A 183      45.830  44.264  81.391  1.00 29.44           C  
ATOM    890  CE1 HIS A 183      47.390  43.184  80.292  1.00 29.63           C  
ATOM    891  NE2 HIS A 183      47.072  44.355  80.809  1.00 32.02           N  
ATOM    892  N   GLY A 184      42.191  40.558  83.567  1.00 18.37           N  
ATOM    893  CA  GLY A 184      40.807  40.195  83.872  1.00 18.11           C  
ATOM    894  C   GLY A 184      39.844  40.285  82.692  1.00 17.89           C  
ATOM    895  O   GLY A 184      38.620  40.153  82.845  1.00 18.40           O  
ATOM    896  N   TYR A 185      40.392  40.487  81.492  1.00 16.66           N  
ATOM    897  CA  TYR A 185      39.579  40.548  80.266  1.00 17.39           C  
ATOM    898  C   TYR A 185      40.453  40.246  79.055  1.00 17.54           C  
ATOM    899  O   TYR A 185      41.680  40.272  79.152  1.00 17.16           O  
ATOM    900  CB  TYR A 185      38.967  41.953  80.106  1.00 17.56           C  
ATOM    901  CG  TYR A 185      40.018  43.050  79.929  1.00 17.57           C  
ATOM    902  CD1 TYR A 185      40.465  43.410  78.658  1.00 19.18           C  
ATOM    903  CD2 TYR A 185      40.567  43.693  81.033  1.00 17.83           C  
ATOM    904  CE1 TYR A 185      41.458  44.403  78.489  1.00 20.24           C  
ATOM    905  CE2 TYR A 185      41.525  44.676  80.885  1.00 18.52           C  
ATOM    906  CZ  TYR A 185      41.972  45.017  79.614  1.00 20.02           C  
ATOM    907  OH  TYR A 185      42.937  45.986  79.468  1.00 22.21           O  
ATOM    908  N   ALA A 186      39.809  39.997  77.911  1.00 17.55           N  
ATOM    909  CA  ALA A 186      40.520  39.817  76.648  1.00 18.29           C  
ATOM    910  C   ALA A 186      40.001  40.802  75.616  1.00 18.10           C  
ATOM    911  O   ALA A 186      38.832  41.202  75.660  1.00 18.37           O  
ATOM    912  CB  ALA A 186      40.326  38.412  76.136  1.00 18.60           C  
ATOM    913  N   VAL A 187      40.864  41.145  74.662  1.00 18.80           N  
ATOM    914  CA  VAL A 187      40.479  41.998  73.532  1.00 19.75           C  
ATOM    915  C   VAL A 187      40.917  41.253  72.297  1.00 18.62           C  
ATOM    916  O   VAL A 187      42.029  40.647  72.275  1.00 19.95           O  
ATOM    917  CB  VAL A 187      41.178  43.389  73.576  1.00 20.65           C  
ATOM    918  CG1 VAL A 187      40.766  44.253  72.382  1.00 23.58           C  
ATOM    919  CG2 VAL A 187      40.866  44.116  74.880  1.00 23.33           C  
ATOM    920  N   SER A 188      40.074  41.263  71.260  1.00 17.85           N  
ATOM    921  CA  SER A 188      40.440  40.658  69.959  1.00 18.79           C  
ATOM    922  C   SER A 188      39.978  41.570  68.807  1.00 19.40           C  
ATOM    923  O   SER A 188      39.023  42.339  68.947  1.00 18.11           O  
ATOM    924  CB  SER A 188      39.793  39.293  69.798  1.00 19.11           C  
ATOM    925  OG  SER A 188      38.377  39.430  69.886  1.00 19.66           O  
ATOM    926  N   THR A 189      40.651  41.460  67.663  1.00 19.75           N  
ATOM    927  CA  THR A 189      40.271  42.243  66.487  1.00 21.86           C  
ATOM    928  C   THR A 189      40.293  41.377  65.230  1.00 20.00           C  
ATOM    929  O   THR A 189      41.337  40.773  64.900  1.00 19.74           O  
ATOM    930  CB  THR A 189      41.228  43.452  66.271  1.00 23.29           C  
ATOM    931  OG1 THR A 189      42.583  42.988  66.192  1.00 27.97           O  
ATOM    932  CG2 THR A 189      41.100  44.455  67.411  1.00 26.00           C  
ATOM    933  N   SER A 190      39.143  41.302  64.548  1.00 19.19           N  
ATOM    934  CA  SER A 190      39.026  40.661  63.254  1.00 19.93           C  
ATOM    935  C   SER A 190      39.398  39.164  63.245  1.00 20.24           C  
ATOM    936  O   SER A 190      39.801  38.647  62.202  1.00 21.60           O  
ATOM    937  CB  SER A 190      39.842  41.427  62.197  1.00 20.21           C  
ATOM    938  OG  SER A 190      39.313  42.732  61.979  1.00 21.14           O  
ATOM    939  N   GLU A 191      39.263  38.480  64.385  1.00 20.90           N  
ATOM    940  CA  GLU A 191      39.607  37.038  64.420  1.00 21.91           C  
ATOM    941  C   GLU A 191      38.473  36.201  63.876  1.00 22.32           C  
ATOM    942  O   GLU A 191      38.695  35.059  63.431  1.00 23.29           O  
ATOM    943  CB  GLU A 191      39.960  36.561  65.830  1.00 22.71           C  
ATOM    944  CG  GLU A 191      41.194  37.225  66.420  1.00 24.33           C  
ATOM    945  CD  GLU A 191      41.595  36.643  67.748  1.00 26.57           C  
ATOM    946  OE1 GLU A 191      41.061  35.563  68.108  1.00 27.17           O  
ATOM    947  OE2 GLU A 191      42.456  37.252  68.432  1.00 27.40           O  
ATOM    948  N   ILE A 192      37.265  36.760  63.939  1.00 21.40           N  
ATOM    949  CA  ILE A 192      36.046  36.068  63.509  1.00 21.09           C  
ATOM    950  C   ILE A 192      35.414  36.728  62.278  1.00 20.72           C  
ATOM    951  O   ILE A 192      35.206  36.065  61.265  1.00 21.43           O  
ATOM    952  CB  ILE A 192      35.039  35.932  64.670  1.00 21.76           C  
ATOM    953  CG1 ILE A 192      35.666  35.081  65.783  1.00 22.83           C  
ATOM    954  CG2 ILE A 192      33.751  35.240  64.197  1.00 22.13           C  
ATOM    955  CD1 ILE A 192      34.911  35.117  67.083  1.00 24.23           C  
ATOM    956  N   ASP A 193      35.141  38.039  62.384  1.00 18.92           N  
ATOM    957  CA  ASP A 193      34.501  38.814  61.320  1.00 18.49           C  
ATOM    958  C   ASP A 193      35.446  39.980  61.047  1.00 17.46           C  
ATOM    959  O   ASP A 193      35.787  40.720  61.977  1.00 17.04           O  
ATOM    960  CB  ASP A 193      33.149  39.382  61.817  1.00 19.25           C  
ATOM    961  CG  ASP A 193      32.150  38.307  62.154  1.00 19.94           C  
ATOM    962  OD1 ASP A 193      31.884  37.471  61.263  1.00 22.12           O  
ATOM    963  OD2 ASP A 193      31.606  38.319  63.280  1.00 20.10           O  
ATOM    964  N   PRO A 194      35.859  40.160  59.774  1.00 17.92           N  
ATOM    965  CA  PRO A 194      36.752  41.258  59.446  1.00 17.51           C  
ATOM    966  C   PRO A 194      36.141  42.589  59.866  1.00 17.60           C  
ATOM    967  O   PRO A 194      34.962  42.846  59.588  1.00 18.79           O  
ATOM    968  CB  PRO A 194      36.844  41.183  57.899  1.00 17.34           C  
ATOM    969  CG  PRO A 194      36.629  39.747  57.593  1.00 21.02           C  
ATOM    970  CD  PRO A 194      35.533  39.353  58.587  1.00 18.22           C  
ATOM    971  N   GLY A 195      36.926  43.427  60.545  1.00 16.58           N  
ATOM    972  CA  GLY A 195      36.458  44.778  60.897  1.00 16.19           C  
ATOM    973  C   GLY A 195      35.645  44.855  62.179  1.00 17.37           C  
ATOM    974  O   GLY A 195      35.198  45.944  62.544  1.00 16.62           O  
ATOM    975  N   VAL A 196      35.455  43.705  62.832  1.00 15.90           N  
ATOM    976  CA  VAL A 196      34.710  43.642  64.113  1.00 16.55           C  
ATOM    977  C   VAL A 196      35.673  43.191  65.198  1.00 16.79           C  
ATOM    978  O   VAL A 196      36.491  42.266  64.966  1.00 17.35           O  
ATOM    979  CB  VAL A 196      33.507  42.663  64.035  1.00 15.94           C  
ATOM    980  CG1 VAL A 196      32.630  42.774  65.323  1.00 17.26           C  
ATOM    981  CG2 VAL A 196      32.639  42.934  62.816  1.00 18.15           C  
ATOM    982  N   SER A 197      35.585  43.863  66.356  1.00 17.41           N  
ATOM    983  CA  SER A 197      36.436  43.555  67.525  1.00 18.09           C  
ATOM    984  C   SER A 197      35.583  42.955  68.636  1.00 18.90           C  
ATOM    985  O   SER A 197      34.340  43.110  68.627  1.00 19.99           O  
ATOM    986  CB  SER A 197      37.128  44.837  68.003  1.00 19.78           C  
ATOM    987  OG  SER A 197      38.025  45.321  67.011  1.00 20.45           O  
ATOM    988  N   GLY A 198      36.219  42.247  69.562  1.00 18.00           N  
ATOM    989  CA  GLY A 198      35.557  41.745  70.757  1.00 18.14           C  
ATOM    990  C   GLY A 198      36.276  42.168  72.019  1.00 17.98           C  
ATOM    991  O   GLY A 198      37.509  42.225  72.047  1.00 17.67           O  
ATOM    992  N   ILE A 199      35.500  42.464  73.064  1.00 17.29           N  
ATOM    993  CA  ILE A 199      36.064  42.742  74.402  1.00 17.50           C  
ATOM    994  C   ILE A 199      35.243  41.926  75.391  1.00 16.51           C  
ATOM    995  O   ILE A 199      34.013  42.008  75.388  1.00 17.19           O  
ATOM    996  CB  ILE A 199      36.042  44.266  74.759  1.00 17.37           C  
ATOM    997  CG1 ILE A 199      37.008  44.998  73.819  1.00 20.13           C  
ATOM    998  CG2 ILE A 199      36.464  44.454  76.218  1.00 17.85           C  
ATOM    999  CD1 ILE A 199      36.952  46.558  73.821  1.00 20.28           C  
ATOM   1000  N   SER A 200      35.895  41.096  76.204  1.00 16.81           N  
ATOM   1001  CA  SER A 200      35.144  40.134  77.015  0.50 17.30           C  
ATOM   1003  C   SER A 200      35.755  39.931  78.386  1.00 17.23           C  
ATOM   1004  O   SER A 200      36.973  40.048  78.559  1.00 17.79           O  
ATOM   1005  CB  SER A 200      35.025  38.782  76.303  0.50 18.05           C  
ATOM   1007  OG  SER A 200      34.649  38.950  74.952  0.50 20.36           O  
ATOM   1009  N   ALA A 201      34.888  39.649  79.358  1.00 16.09           N  
ATOM   1010  CA  ALA A 201      35.342  39.370  80.721  1.00 15.79           C  
ATOM   1011  C   ALA A 201      34.609  38.148  81.271  1.00 16.20           C  
ATOM   1012  O   ALA A 201      33.477  37.910  80.888  1.00 16.58           O  
ATOM   1013  CB  ALA A 201      35.132  40.600  81.619  1.00 15.71           C  
ATOM   1014  N   PRO A 202      35.258  37.380  82.157  1.00 16.17           N  
ATOM   1015  CA  PRO A 202      34.658  36.119  82.620  1.00 17.00           C  
ATOM   1016  C   PRO A 202      33.582  36.359  83.675  1.00 17.62           C  
ATOM   1017  O   PRO A 202      33.680  37.308  84.474  1.00 18.27           O  
ATOM   1018  CB  PRO A 202      35.836  35.393  83.280  1.00 17.23           C  
ATOM   1019  CG  PRO A 202      36.716  36.532  83.816  1.00 16.97           C  
ATOM   1020  CD  PRO A 202      36.580  37.631  82.803  1.00 16.65           C  
ATOM   1021  N   VAL A 203      32.580  35.486  83.674  1.00 18.77           N  
ATOM   1022  CA  VAL A 203      31.585  35.462  84.749  1.00 19.20           C  
ATOM   1023  C   VAL A 203      31.909  34.225  85.551  1.00 20.15           C  
ATOM   1024  O   VAL A 203      31.940  33.120  85.012  1.00 19.77           O  
ATOM   1025  CB  VAL A 203      30.157  35.399  84.193  1.00 19.42           C  
ATOM   1026  CG1 VAL A 203      29.144  35.204  85.301  1.00 19.52           C  
ATOM   1027  CG2 VAL A 203      29.841  36.672  83.403  1.00 19.05           C  
HETATM 1028  N   MSE A 204      32.175  34.448  86.834  1.00 21.23           N  
HETATM 1029  CA  MSE A 204      32.651  33.430  87.750  1.00 22.65           C  
HETATM 1030  C   MSE A 204      31.628  33.203  88.849  1.00 23.20           C  
HETATM 1031  O   MSE A 204      31.018  34.162  89.332  1.00 22.78           O  
HETATM 1032  CB  MSE A 204      33.967  33.882  88.421  1.00 23.50           C  
HETATM 1033  CG  MSE A 204      35.058  34.394  87.493  1.00 25.62           C  
HETATM 1034 SE   MSE A 204      35.818  32.893  86.510  1.00 34.75          SE  
HETATM 1035  CE  MSE A 204      36.624  31.830  87.960  1.00 29.44           C  
ATOM   1036  N   LYS A 205      31.468  31.943  89.251  1.00 23.93           N  
ATOM   1037  CA  LYS A 205      30.757  31.603  90.485  1.00 25.30           C  
ATOM   1038  C   LYS A 205      31.800  30.928  91.342  1.00 25.12           C  
ATOM   1039  O   LYS A 205      32.165  29.776  91.100  1.00 24.26           O  
ATOM   1040  CB  LYS A 205      29.562  30.681  90.227  1.00 24.97           C  
ATOM   1041  CG  LYS A 205      28.750  30.333  91.503  1.00 27.68           C  
ATOM   1042  CD  LYS A 205      27.652  29.335  91.175  1.00 27.59           C  
ATOM   1043  CE  LYS A 205      27.127  28.613  92.414  1.00 32.00           C  
ATOM   1044  NZ  LYS A 205      26.444  27.341  92.009  1.00 32.90           N  
ATOM   1045  N   GLY A 206      32.313  31.685  92.307  1.00 26.02           N  
ATOM   1046  CA  GLY A 206      33.472  31.275  93.080  1.00 27.19           C  
ATOM   1047  C   GLY A 206      34.671  31.124  92.163  1.00 27.19           C  
ATOM   1048  O   GLY A 206      34.995  32.033  91.398  1.00 27.98           O  
ATOM   1049  N   SER A 207      35.320  29.964  92.240  1.00 27.29           N  
ATOM   1050  CA  SER A 207      36.460  29.678  91.371  1.00 27.66           C  
ATOM   1051  C   SER A 207      36.059  29.022  90.037  1.00 27.20           C  
ATOM   1052  O   SER A 207      36.927  28.679  89.227  1.00 27.70           O  
ATOM   1053  CB  SER A 207      37.504  28.822  92.104  1.00 27.65           C  
ATOM   1054  OG  SER A 207      36.985  27.539  92.400  1.00 29.05           O  
ATOM   1055  N   LYS A 208      34.754  28.853  89.804  1.00 26.28           N  
ATOM   1056  CA  LYS A 208      34.292  28.205  88.574  1.00 24.48           C  
ATOM   1057  C   LYS A 208      33.895  29.207  87.515  1.00 22.84           C  
ATOM   1058  O   LYS A 208      33.094  30.110  87.762  1.00 21.83           O  
ATOM   1059  CB  LYS A 208      33.108  27.279  88.830  1.00 24.44           C  
ATOM   1060  CG  LYS A 208      32.571  26.640  87.571  1.00 27.16           C  
ATOM   1061  CD  LYS A 208      31.494  25.595  87.849  1.00 32.16           C  
ATOM   1062  CE  LYS A 208      30.629  25.398  86.601  1.00 36.30           C  
ATOM   1063  NZ  LYS A 208      29.588  24.356  86.809  1.00 36.49           N  
ATOM   1064  N   LEU A 209      34.441  29.021  86.320  1.00 21.12           N  
ATOM   1065  CA  LEU A 209      34.026  29.815  85.180  1.00 20.61           C  
ATOM   1066  C   LEU A 209      32.663  29.328  84.710  1.00 20.54           C  
ATOM   1067  O   LEU A 209      32.487  28.134  84.393  1.00 21.32           O  
ATOM   1068  CB  LEU A 209      35.022  29.663  84.024  1.00 20.59           C  
ATOM   1069  CG  LEU A 209      34.446  30.360  82.775  1.00 20.48           C  
ATOM   1070  CD1 LEU A 209      34.785  31.853  82.756  1.00 18.47           C  
ATOM   1071  CD2 LEU A 209      34.836  29.650  81.514  1.00 17.71           C  
ATOM   1072  N   ILE A 210      31.703  30.244  84.640  1.00 19.76           N  
ATOM   1073  CA  ILE A 210      30.380  29.877  84.158  1.00 20.73           C  
ATOM   1074  C   ILE A 210      30.014  30.482  82.797  1.00 19.14           C  
ATOM   1075  O   ILE A 210      29.215  29.914  82.062  1.00 19.79           O  
ATOM   1076  CB  ILE A 210      29.261  30.083  85.217  1.00 21.12           C  
ATOM   1077  CG1 ILE A 210      29.115  31.541  85.590  1.00 23.14           C  
ATOM   1078  CG2 ILE A 210      29.471  29.103  86.455  1.00 22.79           C  
ATOM   1079  CD1 ILE A 210      28.023  31.858  86.629  1.00 23.76           C  
ATOM   1080  N   GLY A 211      30.628  31.605  82.453  1.00 17.43           N  
ATOM   1081  CA  GLY A 211      30.339  32.241  81.176  1.00 16.85           C  
ATOM   1082  C   GLY A 211      31.207  33.455  80.936  1.00 16.47           C  
ATOM   1083  O   GLY A 211      32.267  33.627  81.560  1.00 16.79           O  
ATOM   1084  N   ALA A 212      30.776  34.294  80.004  1.00 15.93           N  
ATOM   1085  CA  ALA A 212      31.519  35.529  79.725  1.00 16.47           C  
ATOM   1086  C   ALA A 212      30.557  36.580  79.260  1.00 16.75           C  
ATOM   1087  O   ALA A 212      29.586  36.254  78.587  1.00 18.21           O  
ATOM   1088  CB  ALA A 212      32.585  35.314  78.688  1.00 16.71           C  
ATOM   1089  N   ILE A 213      30.850  37.846  79.581  1.00 16.81           N  
ATOM   1090  CA  ILE A 213      30.107  38.976  78.992  1.00 17.08           C  
ATOM   1091  C   ILE A 213      30.993  39.571  77.939  1.00 17.48           C  
ATOM   1092  O   ILE A 213      32.201  39.724  78.162  1.00 16.69           O  
ATOM   1093  CB  ILE A 213      29.800  40.078  80.062  1.00 17.15           C  
ATOM   1094  CG1 ILE A 213      28.769  39.557  81.076  1.00 19.75           C  
ATOM   1095  CG2 ILE A 213      29.370  41.418  79.368  1.00 18.28           C  
ATOM   1096  CD1 ILE A 213      27.355  39.396  80.514  1.00 23.60           C  
ATOM   1097  N   SER A 214      30.420  39.922  76.794  1.00 17.87           N  
ATOM   1098  CA  SER A 214      31.200  40.413  75.673  0.50 17.94           C  
ATOM   1100  C   SER A 214      30.505  41.580  74.988  1.00 18.77           C  
ATOM   1101  O   SER A 214      29.273  41.621  74.951  1.00 18.69           O  
ATOM   1102  CB  SER A 214      31.388  39.287  74.663  0.50 18.41           C  
ATOM   1104  OG  SER A 214      32.002  38.149  75.263  0.50 16.98           O  
ATOM   1106  N   VAL A 215      31.303  42.508  74.477  1.00 18.34           N  
ATOM   1107  CA  VAL A 215      30.826  43.495  73.508  1.00 18.55           C  
ATOM   1108  C   VAL A 215      31.491  43.154  72.186  1.00 18.54           C  
ATOM   1109  O   VAL A 215      32.705  42.861  72.132  1.00 18.30           O  
ATOM   1110  CB  VAL A 215      31.159  44.924  73.946  1.00 18.28           C  
ATOM   1111  CG1 VAL A 215      31.150  45.927  72.745  1.00 20.45           C  
ATOM   1112  CG2 VAL A 215      30.183  45.354  75.074  1.00 18.17           C  
HETATM 1113  N   MSE A 216      30.680  43.154  71.130  1.00 19.50           N  
HETATM 1114  CA  MSE A 216      31.127  42.935  69.742  1.00 21.45           C  
HETATM 1115  C   MSE A 216      30.816  44.223  69.008  1.00 20.42           C  
HETATM 1116  O   MSE A 216      29.660  44.657  68.997  1.00 19.46           O  
HETATM 1117  CB  MSE A 216      30.341  41.779  69.111  1.00 22.69           C  
HETATM 1118  CG  MSE A 216      30.610  40.433  69.749  1.00 29.38           C  
HETATM 1119 SE   MSE A 216      29.394  40.168  71.271  1.00 49.16          SE  
HETATM 1120  CE  MSE A 216      28.281  38.808  70.425  1.00 42.40           C  
ATOM   1121  N   ALA A 217      31.831  44.855  68.418  1.00 18.74           N  
ATOM   1122  CA  ALA A 217      31.674  46.205  67.930  1.00 18.29           C  
ATOM   1123  C   ALA A 217      32.665  46.471  66.783  1.00 17.62           C  
ATOM   1124  O   ALA A 217      33.748  45.876  66.752  1.00 17.54           O  
ATOM   1125  CB  ALA A 217      31.919  47.188  69.077  1.00 19.50           C  
ATOM   1126  N   PRO A 218      32.289  47.357  65.836  1.00 17.74           N  
ATOM   1127  CA  PRO A 218      33.175  47.656  64.710  1.00 17.16           C  
ATOM   1128  C   PRO A 218      34.500  48.224  65.232  1.00 17.69           C  
ATOM   1129  O   PRO A 218      34.497  49.069  66.137  1.00 17.89           O  
ATOM   1130  CB  PRO A 218      32.408  48.739  63.915  1.00 17.63           C  
ATOM   1131  CG  PRO A 218      31.367  49.256  64.854  1.00 20.26           C  
ATOM   1132  CD  PRO A 218      31.047  48.146  65.822  1.00 18.47           C  
ATOM   1133  N   ALA A 219      35.619  47.790  64.656  1.00 18.73           N  
ATOM   1134  CA  ALA A 219      36.898  48.352  65.038  1.00 19.62           C  
ATOM   1135  C   ALA A 219      36.867  49.892  64.954  1.00 19.85           C  
ATOM   1136  O   ALA A 219      37.527  50.566  65.747  1.00 21.32           O  
ATOM   1137  CB  ALA A 219      38.004  47.771  64.170  1.00 19.80           C  
ATOM   1138  N   HIS A 220      36.084  50.438  64.017  1.00 19.53           N  
ATOM   1139  CA  HIS A 220      36.006  51.906  63.804  1.00 20.79           C  
ATOM   1140  C   HIS A 220      35.601  52.602  65.119  1.00 21.02           C  
ATOM   1141  O   HIS A 220      36.142  53.680  65.470  1.00 23.00           O  
ATOM   1142  CB  HIS A 220      34.995  52.247  62.701  1.00 20.38           C  
ATOM   1143  CG  HIS A 220      34.874  53.712  62.464  1.00 22.12           C  
ATOM   1144  ND1 HIS A 220      35.844  54.436  61.805  1.00 25.06           N  
ATOM   1145  CD2 HIS A 220      33.917  54.597  62.826  1.00 23.96           C  
ATOM   1146  CE1 HIS A 220      35.479  55.707  61.760  1.00 22.15           C  
ATOM   1147  NE2 HIS A 220      34.321  55.830  62.388  1.00 24.11           N  
ATOM   1148  N   ARG A 221      34.664  51.986  65.841  1.00 20.11           N  
ATOM   1149  CA  ARG A 221      34.192  52.553  67.110  1.00 20.11           C  
ATOM   1150  C   ARG A 221      35.003  52.121  68.316  1.00 20.90           C  
ATOM   1151  O   ARG A 221      35.144  52.892  69.276  1.00 21.78           O  
ATOM   1152  CB  ARG A 221      32.703  52.261  67.330  1.00 19.38           C  
ATOM   1153  CG  ARG A 221      31.851  52.940  66.284  1.00 19.76           C  
ATOM   1154  CD  ARG A 221      30.416  53.108  66.712  1.00 20.87           C  
ATOM   1155  NE  ARG A 221      29.742  51.845  66.975  1.00 21.71           N  
ATOM   1156  CZ  ARG A 221      28.991  51.196  66.087  1.00 20.92           C  
ATOM   1157  NH1 ARG A 221      28.403  50.060  66.443  1.00 21.24           N  
ATOM   1158  NH2 ARG A 221      28.850  51.667  64.850  1.00 19.25           N  
ATOM   1159  N   VAL A 222      35.522  50.896  68.298  1.00 20.11           N  
ATOM   1160  CA  VAL A 222      36.324  50.412  69.425  1.00 21.64           C  
ATOM   1161  C   VAL A 222      37.596  51.233  69.562  1.00 22.43           C  
ATOM   1162  O   VAL A 222      38.024  51.518  70.683  1.00 22.17           O  
ATOM   1163  CB  VAL A 222      36.646  48.907  69.309  1.00 21.39           C  
ATOM   1164  CG1 VAL A 222      37.593  48.468  70.434  1.00 23.50           C  
ATOM   1165  CG2 VAL A 222      35.337  48.093  69.367  1.00 20.22           C  
ATOM   1166  N   GLU A 223      38.174  51.640  68.430  1.00 22.97           N  
ATOM   1167  CA  GLU A 223      39.377  52.474  68.432  1.00 25.08           C  
ATOM   1168  C   GLU A 223      39.208  53.797  69.172  1.00 25.33           C  
ATOM   1169  O   GLU A 223      40.180  54.356  69.680  1.00 26.98           O  
ATOM   1170  CB  GLU A 223      39.853  52.716  66.999  1.00 26.01           C  
ATOM   1171  CG  GLU A 223      40.481  51.478  66.427  1.00 30.29           C  
ATOM   1172  CD  GLU A 223      40.803  51.588  64.948  1.00 35.52           C  
ATOM   1173  OE1 GLU A 223      40.691  52.700  64.363  1.00 38.08           O  
ATOM   1174  OE2 GLU A 223      41.174  50.539  64.372  1.00 37.03           O  
ATOM   1175  N   SER A 224      37.979  54.286  69.263  1.00 22.42           N  
ATOM   1176  CA  SER A 224      37.716  55.558  69.923  1.00 22.62           C  
ATOM   1177  C   SER A 224      37.191  55.351  71.348  1.00 21.16           C  
ATOM   1178  O   SER A 224      37.018  56.342  72.103  1.00 20.85           O  
ATOM   1179  CB  SER A 224      36.646  56.329  69.128  1.00 23.41           C  
ATOM   1180  OG  SER A 224      37.168  56.756  67.871  1.00 26.85           O  
ATOM   1181  N   ASN A 225      36.904  54.102  71.703  1.00 19.20           N  
ATOM   1182  CA  ASN A 225      36.160  53.830  72.962  1.00 18.29           C  
ATOM   1183  C   ASN A 225      36.688  52.631  73.729  1.00 18.41           C  
ATOM   1184  O   ASN A 225      35.956  52.006  74.521  1.00 17.42           O  
ATOM   1185  CB  ASN A 225      34.667  53.625  72.677  1.00 18.76           C  
ATOM   1186  CG  ASN A 225      34.003  54.875  72.181  1.00 18.22           C  
ATOM   1187  OD1 ASN A 225      33.682  55.756  72.968  1.00 19.75           O  
ATOM   1188  ND2 ASN A 225      33.825  54.981  70.856  1.00 20.05           N  
ATOM   1189  N   LYS A 226      37.958  52.291  73.503  1.00 18.89           N  
ATOM   1190  CA  LYS A 226      38.453  51.018  74.036  1.00 19.60           C  
ATOM   1191  C   LYS A 226      38.402  50.916  75.572  1.00 19.12           C  
ATOM   1192  O   LYS A 226      37.845  49.933  76.122  1.00 18.61           O  
ATOM   1193  CB  LYS A 226      39.864  50.765  73.499  1.00 20.75           C  
ATOM   1194  CG  LYS A 226      40.324  49.359  73.767  1.00 22.62           C  
ATOM   1195  CD  LYS A 226      41.705  49.128  73.175  1.00 25.88           C  
ATOM   1196  CE  LYS A 226      42.204  47.757  73.550  1.00 30.82           C  
ATOM   1197  NZ  LYS A 226      43.649  47.631  73.178  1.00 34.02           N  
ATOM   1198  N   GLN A 227      38.943  51.923  76.272  1.00 19.35           N  
ATOM   1199  CA  GLN A 227      38.974  51.878  77.736  1.00 19.17           C  
ATOM   1200  C   GLN A 227      37.547  51.911  78.297  1.00 17.59           C  
ATOM   1201  O   GLN A 227      37.245  51.209  79.271  1.00 17.57           O  
ATOM   1202  CB  GLN A 227      39.814  53.040  78.292  1.00 20.32           C  
ATOM   1203  CG  GLN A 227      39.750  53.201  79.827  1.00 24.38           C  
ATOM   1204  CD  GLN A 227      40.602  52.201  80.607  1.00 31.76           C  
ATOM   1205  OE1 GLN A 227      40.864  51.080  80.158  1.00 33.86           O  
ATOM   1206  NE2 GLN A 227      41.018  52.610  81.808  1.00 33.72           N  
ATOM   1207  N   ARG A 228      36.681  52.705  77.672  1.00 16.66           N  
ATOM   1208  CA  ARG A 228      35.276  52.763  78.082  1.00 15.80           C  
ATOM   1209  C   ARG A 228      34.612  51.392  77.985  1.00 17.31           C  
ATOM   1210  O   ARG A 228      33.955  50.948  78.917  1.00 16.96           O  
ATOM   1211  CB  ARG A 228      34.539  53.751  77.166  1.00 16.58           C  
ATOM   1212  CG  ARG A 228      33.018  53.769  77.277  1.00 17.13           C  
ATOM   1213  CD  ARG A 228      32.488  54.639  76.159  1.00 17.11           C  
ATOM   1214  NE  ARG A 228      31.046  54.924  76.241  1.00 17.22           N  
ATOM   1215  CZ  ARG A 228      30.384  55.616  75.322  1.00 20.55           C  
ATOM   1216  NH1 ARG A 228      29.088  55.868  75.503  1.00 19.46           N  
ATOM   1217  NH2 ARG A 228      31.006  56.077  74.238  1.00 19.48           N  
ATOM   1218  N   ILE A 229      34.780  50.720  76.860  1.00 16.52           N  
ATOM   1219  CA  ILE A 229      34.183  49.387  76.696  1.00 17.05           C  
ATOM   1220  C   ILE A 229      34.767  48.382  77.673  1.00 16.96           C  
ATOM   1221  O   ILE A 229      34.028  47.640  78.312  1.00 17.35           O  
ATOM   1222  CB  ILE A 229      34.294  48.929  75.241  1.00 16.43           C  
ATOM   1223  CG1 ILE A 229      33.444  49.888  74.371  1.00 17.40           C  
ATOM   1224  CG2 ILE A 229      33.833  47.454  75.110  1.00 18.61           C  
ATOM   1225  CD1 ILE A 229      33.731  49.745  72.850  1.00 18.35           C  
ATOM   1226  N   ILE A 230      36.099  48.358  77.791  1.00 16.42           N  
ATOM   1227  CA  ILE A 230      36.744  47.455  78.784  1.00 17.08           C  
ATOM   1228  C   ILE A 230      36.148  47.655  80.196  1.00 16.59           C  
ATOM   1229  O   ILE A 230      35.720  46.710  80.839  1.00 16.20           O  
ATOM   1230  CB  ILE A 230      38.264  47.698  78.779  1.00 17.62           C  
ATOM   1231  CG1 ILE A 230      38.866  47.203  77.457  1.00 18.52           C  
ATOM   1232  CG2 ILE A 230      38.947  47.054  80.039  1.00 18.01           C  
ATOM   1233  CD1 ILE A 230      40.303  47.688  77.238  1.00 21.13           C  
ATOM   1234  N   LEU A 231      36.096  48.903  80.664  1.00 16.30           N  
ATOM   1235  CA  LEU A 231      35.600  49.144  82.026  1.00 16.48           C  
ATOM   1236  C   LEU A 231      34.138  48.689  82.168  1.00 16.23           C  
ATOM   1237  O   LEU A 231      33.779  48.037  83.154  1.00 15.36           O  
ATOM   1238  CB  LEU A 231      35.800  50.602  82.448  1.00 15.73           C  
ATOM   1239  CG  LEU A 231      37.282  50.943  82.670  1.00 16.73           C  
ATOM   1240  CD1 LEU A 231      37.364  52.441  82.890  1.00 18.59           C  
ATOM   1241  CD2 LEU A 231      37.938  50.174  83.850  1.00 19.09           C  
ATOM   1242  N   HIS A 232      33.288  48.995  81.182  1.00 16.82           N  
ATOM   1243  CA  HIS A 232      31.890  48.617  81.296  1.00 16.59           C  
ATOM   1244  C   HIS A 232      31.673  47.095  81.192  1.00 16.53           C  
ATOM   1245  O   HIS A 232      30.797  46.530  81.861  1.00 16.46           O  
ATOM   1246  CB  HIS A 232      31.042  49.348  80.237  1.00 16.57           C  
ATOM   1247  CG  HIS A 232      30.769  50.790  80.560  1.00 15.62           C  
ATOM   1248  ND1 HIS A 232      30.320  51.213  81.801  1.00 16.53           N  
ATOM   1249  CD2 HIS A 232      30.845  51.897  79.782  1.00 17.21           C  
ATOM   1250  CE1 HIS A 232      30.152  52.536  81.767  1.00 16.38           C  
ATOM   1251  NE2 HIS A 232      30.423  52.961  80.544  1.00 14.88           N  
ATOM   1252  N   VAL A 233      32.505  46.433  80.399  1.00 16.11           N  
ATOM   1253  CA  VAL A 233      32.429  44.965  80.273  1.00 17.37           C  
ATOM   1254  C   VAL A 233      32.862  44.297  81.581  1.00 17.33           C  
ATOM   1255  O   VAL A 233      32.193  43.396  82.086  1.00 17.78           O  
ATOM   1256  CB  VAL A 233      33.270  44.503  79.052  1.00 16.35           C  
ATOM   1257  CG1 VAL A 233      33.584  42.986  79.095  1.00 17.78           C  
ATOM   1258  CG2 VAL A 233      32.537  44.861  77.763  1.00 16.89           C  
ATOM   1259  N   LEU A 234      33.971  44.770  82.157  1.00 16.36           N  
ATOM   1260  CA  LEU A 234      34.383  44.299  83.473  1.00 17.39           C  
ATOM   1261  C   LEU A 234      33.266  44.520  84.512  1.00 17.14           C  
ATOM   1262  O   LEU A 234      32.951  43.640  85.307  1.00 17.59           O  
ATOM   1263  CB  LEU A 234      35.669  45.011  83.887  1.00 17.17           C  
ATOM   1264  CG  LEU A 234      36.946  44.537  83.185  1.00 18.67           C  
ATOM   1265  CD1 LEU A 234      38.077  45.538  83.346  1.00 17.77           C  
ATOM   1266  CD2 LEU A 234      37.355  43.121  83.716  1.00 17.20           C  
ATOM   1267  N   GLN A 235      32.671  45.708  84.482  1.00 16.58           N  
ATOM   1268  CA  GLN A 235      31.611  46.094  85.405  1.00 16.45           C  
ATOM   1269  C   GLN A 235      30.405  45.155  85.270  1.00 17.15           C  
ATOM   1270  O   GLN A 235      29.849  44.700  86.273  1.00 16.64           O  
ATOM   1271  CB  GLN A 235      31.216  47.548  85.067  1.00 16.62           C  
ATOM   1272  CG  GLN A 235      30.103  48.097  85.904  1.00 16.91           C  
ATOM   1273  CD  GLN A 235      29.768  49.524  85.519  1.00 18.60           C  
ATOM   1274  OE1 GLN A 235      30.048  49.967  84.396  1.00 18.13           O  
ATOM   1275  NE2 GLN A 235      29.134  50.238  86.433  1.00 19.42           N  
ATOM   1276  N   ALA A 236      30.035  44.861  84.023  1.00 17.32           N  
ATOM   1277  CA  ALA A 236      28.922  43.954  83.743  1.00 17.39           C  
ATOM   1278  C   ALA A 236      29.173  42.550  84.287  1.00 17.87           C  
ATOM   1279  O   ALA A 236      28.331  41.987  84.969  1.00 17.61           O  
ATOM   1280  CB  ALA A 236      28.646  43.908  82.225  1.00 18.29           C  
ATOM   1281  N   ALA A 237      30.346  42.002  83.976  1.00 17.33           N  
ATOM   1282  CA  ALA A 237      30.714  40.651  84.408  1.00 18.19           C  
ATOM   1283  C   ALA A 237      30.774  40.541  85.939  1.00 18.58           C  
ATOM   1284  O   ALA A 237      30.295  39.564  86.535  1.00 20.46           O  
ATOM   1285  CB  ALA A 237      32.034  40.284  83.789  1.00 18.14           C  
ATOM   1286  N   ARG A 238      31.351  41.558  86.584  1.00 18.84           N  
ATOM   1287  CA  ARG A 238      31.455  41.554  88.051  1.00 20.24           C  
ATOM   1288  C   ARG A 238      30.085  41.590  88.744  1.00 20.52           C  
ATOM   1289  O   ARG A 238      29.922  41.101  89.867  1.00 20.96           O  
ATOM   1290  CB  ARG A 238      32.341  42.706  88.498  1.00 20.28           C  
ATOM   1291  CG  ARG A 238      32.630  42.737  89.977  1.00 23.84           C  
ATOM   1292  CD  ARG A 238      33.913  43.467  90.249  1.00 27.89           C  
ATOM   1293  NE  ARG A 238      34.269  43.414  91.665  1.00 30.24           N  
ATOM   1294  CZ  ARG A 238      35.346  44.004  92.174  1.00 32.38           C  
ATOM   1295  NH1 ARG A 238      36.179  44.661  91.375  1.00 32.73           N  
ATOM   1296  NH2 ARG A 238      35.609  43.909  93.463  1.00 34.24           N  
ATOM   1297  N   ALA A 239      29.100  42.165  88.069  1.00 21.38           N  
ATOM   1298  CA  ALA A 239      27.761  42.318  88.609  1.00 22.65           C  
ATOM   1299  C   ALA A 239      26.992  41.005  88.601  1.00 24.11           C  
ATOM   1300  O   ALA A 239      25.951  40.905  89.255  1.00 24.64           O  
ATOM   1301  CB  ALA A 239      27.006  43.360  87.850  1.00 22.55           C  
ATOM   1302  N   LEU A 240      27.536  40.004  87.896  1.00 25.26           N  
ATOM   1303  CA  LEU A 240      26.943  38.666  87.798  1.00 25.99           C  
ATOM   1304  C   LEU A 240      27.720  37.592  88.568  1.00 27.67           C  
ATOM   1305  O   LEU A 240      27.222  36.467  88.704  1.00 29.12           O  
ATOM   1306  CB  LEU A 240      26.843  38.245  86.321  1.00 25.82           C  
ATOM   1307  CG  LEU A 240      25.881  38.999  85.412  1.00 24.63           C  
ATOM   1308  CD1 LEU A 240      26.124  38.594  83.933  1.00 25.86           C  
ATOM   1309  CD2 LEU A 240      24.422  38.789  85.822  1.00 23.35           C  
ATOM   1310  OXT LEU A 240      28.848  37.766  89.050  1.00 27.94           O  
TER    1311      LEU A 240                                                      
END
MOLECULE T0412.pdb
ATOM      1  N   SER     1      17.559  26.951  92.213  1.00 54.32           N  
ATOM      2  CA  SER     1      16.245  27.299  92.853  1.00 53.09           C  
ATOM      3  C   SER     1      16.043  28.831  93.060  1.00 52.29           C  
ATOM      4  O   SER     1      15.077  29.281  93.761  1.00 50.93           O  
ATOM      5  CB  SER     1      16.073  26.547  94.152  1.00 52.87           C  
ATOM      6  OG  SER     1      14.779  26.777  94.666  1.00 52.80           O  
ATOM      7  N   ASN     2      16.948  29.599  92.427  1.00 50.24           N  
ATOM      8  CA  ASN     2      16.884  31.054  92.474  1.00 48.93           C  
ATOM      9  C   ASN     2      17.383  31.628  91.189  1.00 47.18           C  
ATOM     10  O   ASN     2      17.733  32.795  91.079  1.00 47.53           O  
ATOM     11  CB  ASN     2      17.619  31.623  93.683  1.00 49.45           C  
ATOM     12  CG  ASN     2      17.125  33.004  94.040  1.00 49.02           C  
ATOM     13  OD1 ASN     2      17.498  33.973  93.384  1.00 51.47           O  
ATOM     14  ND2 ASN     2      16.253  33.099  95.026  1.00 44.65           N  
ATOM     15  N   ALA     3      17.385  30.732  90.212  1.00 45.59           N  
ATOM     16  CA  ALA     3      17.756  30.926  88.865  1.00 42.81           C  
ATOM     17  C   ALA     3      17.150  32.162  88.216  1.00 42.42           C  
ATOM     18  O   ALA     3      17.817  32.797  87.411  1.00 43.10           O  
ATOM     19  CB  ALA     3      17.328  29.686  88.100  1.00 42.78           C  
ATOM     20  N   LEU     4      15.891  32.474  88.499  1.00 40.84           N  
ATOM     21  CA  LEU     4      15.175  33.549  87.776  1.00 41.08           C  
ATOM     22  C   LEU     4      15.595  34.992  88.193  1.00 41.73           C  
ATOM     23  O   LEU     4      15.795  35.891  87.336  1.00 40.99           O  
ATOM     24  CB  LEU     4      13.630  33.366  87.879  1.00 40.15           C  
ATOM     25  CG  LEU     4      13.042  32.123  87.172  1.00 39.13           C  
ATOM     26  CD1 LEU     4      11.515  32.115  87.181  1.00 37.64           C  
ATOM     27  CD2 LEU     4      13.561  32.029  85.757  1.00 33.72           C  
ATOM     28  N   PHE     5      15.747  35.183  89.503  1.00 42.10           N  
ATOM     29  CA  PHE     5      16.276  36.410  90.043  1.00 43.47           C  
ATOM     30  C   PHE     5      17.723  36.613  89.583  1.00 45.53           C  
ATOM     31  O   PHE     5      18.087  37.717  89.179  1.00 45.52           O  
ATOM     32  CB  PHE     5      16.153  36.419  91.539  1.00 41.53           C  
ATOM     33  CG  PHE     5      14.758  36.708  92.026  1.00 42.02           C  
ATOM     34  CD1 PHE     5      14.162  37.953  91.794  1.00 40.73           C  
ATOM     35  CD2 PHE     5      14.057  35.762  92.772  1.00 38.83           C  
ATOM     36  CE1 PHE     5      12.860  38.232  92.300  1.00 39.71           C  
ATOM     37  CE2 PHE     5      12.788  36.019  93.254  1.00 37.43           C  
ATOM     38  CZ  PHE     5      12.175  37.252  93.015  1.00 38.76           C  
ATOM     39  N   SER     6      18.539  35.567  89.550  1.00 47.47           N  
ATOM     40  CA  SER     6      19.873  35.786  88.935  1.00 50.67           C  
ATOM     41  C   SER     6      19.841  36.120  87.464  1.00 51.41           C  
ATOM     42  O   SER     6      20.662  36.934  87.018  1.00 52.33           O  
ATOM     43  CB  SER     6      20.860  34.630  89.193  1.00 50.07           C  
ATOM     44  OG  SER     6      20.888  34.394  90.613  1.00 55.00           O  
ATOM     45  N   SER     7      18.951  35.474  86.693  1.00 52.62           N  
ATOM     46  CA  SER     7      18.913  35.704  85.234  1.00 53.39           C  
ATOM     47  C   SER     7      18.502  37.146  85.049  1.00 53.99           C  
ATOM     48  O   SER     7      19.066  37.871  84.231  1.00 54.98           O  
ATOM     49  CB  SER     7      17.939  34.768  84.510  1.00 53.69           C  
ATOM     50  OG  SER     7      18.384  33.413  84.592  1.00 54.34           O  
ATOM     51  N   ARG     8      17.565  37.583  85.866  1.00 53.65           N  
ATOM     52  CA  ARG     8      17.066  38.939  85.755  1.00 54.53           C  
ATOM     53  C   ARG     8      18.164  39.964  86.086  1.00 54.58           C  
ATOM     54  O   ARG     8      18.327  40.920  85.341  1.00 55.96           O  
ATOM     55  CB  ARG     8      15.819  39.113  86.650  1.00 54.60           C  
ATOM     56  CG  ARG     8      15.233  40.467  86.595  1.00 56.13           C  
ATOM     57  CD  ARG     8      15.106  40.985  88.004  1.00 57.96           C  
ATOM     58  NE  ARG     8      13.696  41.145  88.342  1.00 62.03           N  
ATOM     59  CZ  ARG     8      13.204  41.195  89.577  1.00 61.99           C  
ATOM     60  NH1 ARG     8      11.897  41.360  89.749  1.00 61.14           N  
ATOM     61  NH2 ARG     8      14.011  41.073  90.627  1.00 62.55           N  
ATOM     62  N   ASP     9      18.908  39.772  87.183  1.00 54.12           N  
ATOM     63  CA  ASP     9      20.074  40.595  87.510  1.00 54.08           C  
ATOM     64  C   ASP     9      21.019  40.705  86.305  1.00 54.67           C  
ATOM     65  O   ASP     9      21.399  41.806  85.927  1.00 55.78           O  
ATOM     66  CB  ASP     9      20.870  39.989  88.667  1.00 53.61           C  
ATOM     67  CG  ASP     9      20.139  40.045  90.007  1.00 55.37           C  
ATOM     68  OD1 ASP     9      19.080  40.719  90.144  1.00 57.24           O  
ATOM     69  OD2 ASP     9      20.634  39.387  90.952  1.00 56.96           O  
ATOM     70  N   ILE    10      21.384  39.573  85.702  1.00 54.19           N  
ATOM     71  CA  ILE    10      22.284  39.552  84.544  1.00 54.42           C  
ATOM     72  C   ILE    10      21.722  40.293  83.315  1.00 55.29           C  
ATOM     73  O   ILE    10      22.394  41.116  82.712  1.00 55.62           O  
ATOM     74  CB  ILE    10      22.666  38.098  84.163  1.00 53.93           C  
ATOM     75  CG1 ILE    10      23.447  37.454  85.291  1.00 53.01           C  
ATOM     76  CG2 ILE    10      23.465  38.026  82.840  1.00 53.06           C  
ATOM     77  CD1 ILE    10      23.566  35.934  85.160  1.00 52.08           C  
ATOM     78  N   LEU    11      20.489  39.975  82.942  1.00 56.18           N  
ATOM     79  CA  LEU    11      19.816  40.679  81.877  1.00 56.38           C  
ATOM     80  C   LEU    11      19.798  42.184  82.141  1.00 57.20           C  
ATOM     81  O   LEU    11      20.038  42.959  81.229  1.00 58.40           O  
ATOM     82  CB  LEU    11      18.403  40.149  81.688  1.00 55.51           C  
ATOM     83  CG  LEU    11      17.694  40.821  80.522  1.00 55.16           C  
ATOM     84  CD1 LEU    11      18.433  40.553  79.200  1.00 52.86           C  
ATOM     85  CD2 LEU    11      16.261  40.337  80.481  1.00 49.81           C  
ATOM     86  N   GLU    12      19.507  42.620  83.360  1.00 57.38           N  
ATOM     87  CA  GLU    12      19.500  44.064  83.621  1.00 58.36           C  
ATOM     88  C   GLU    12      20.894  44.699  83.355  1.00 57.39           C  
ATOM     89  O   GLU    12      20.998  45.782  82.776  1.00 57.72           O  
ATOM     90  CB  GLU    12      19.034  44.374  85.047  1.00 57.74           C  
ATOM     91  CG  GLU    12      17.531  44.332  85.205  1.00 60.40           C  
ATOM     92  CD  GLU    12      17.043  44.331  86.701  1.00 61.88           C  
ATOM     93  OE1 GLU    12      17.873  44.459  87.671  1.00 62.94           O  
ATOM     94  OE2 GLU    12      15.796  44.191  86.887  1.00 66.26           O  
ATOM     95  N   VAL    13      21.957  44.040  83.792  1.00 55.98           N  
ATOM     96  CA  VAL    13      23.286  44.551  83.529  1.00 55.60           C  
ATOM     97  C   VAL    13      23.614  44.556  82.022  1.00 55.56           C  
ATOM     98  O   VAL    13      24.168  45.541  81.501  1.00 55.72           O  
ATOM     99  CB  VAL    13      24.357  43.769  84.292  1.00 55.14           C  
ATOM    100  CG1 VAL    13      25.722  44.167  83.806  1.00 54.07           C  
ATOM    101  CG2 VAL    13      24.239  44.064  85.750  1.00 54.66           C  
ATOM    102  N   LEU    14      23.268  43.472  81.339  1.00 55.24           N  
ATOM    103  CA  LEU    14      23.531  43.338  79.920  1.00 56.29           C  
ATOM    104  C   LEU    14      22.733  44.390  79.113  1.00 56.68           C  
ATOM    105  O   LEU    14      23.240  44.984  78.188  1.00 55.03           O  
ATOM    106  CB  LEU    14      23.190  41.918  79.489  1.00 56.15           C  
ATOM    107  CG  LEU    14      23.420  41.464  78.039  1.00 58.26           C  
ATOM    108  CD1 LEU    14      24.902  41.336  77.676  1.00 56.32           C  
ATOM    109  CD2 LEU    14      22.662  40.132  77.744  1.00 56.95           C  
ATOM    110  N   GLN    15      21.476  44.617  79.488  1.00 57.39           N  
ATOM    111  CA  GLN    15      20.712  45.698  78.920  1.00 58.53           C  
ATOM    112  C   GLN    15      21.356  47.067  79.131  1.00 58.92           C  
ATOM    113  O   GLN    15      21.273  47.906  78.234  1.00 59.03           O  
ATOM    114  CB  GLN    15      19.262  45.682  79.394  1.00 57.53           C  
ATOM    115  CG  GLN    15      18.490  44.721  78.582  1.00 60.66           C  
ATOM    116  CD  GLN    15      17.050  44.549  79.011  1.00 67.03           C  
ATOM    117  OE1 GLN    15      16.699  44.686  80.206  1.00 70.49           O  
ATOM    118  NE2 GLN    15      16.197  44.222  78.046  1.00 66.34           N  
ATOM    119  N   ASP    16      21.993  47.297  80.274  1.00 59.06           N  
ATOM    120  CA  ASP    16      22.670  48.569  80.467  1.00 61.14           C  
ATOM    121  C   ASP    16      23.854  48.786  79.522  1.00 60.80           C  
ATOM    122  O   ASP    16      24.084  49.885  79.037  1.00 62.19           O  
ATOM    123  CB  ASP    16      23.144  48.748  81.898  1.00 61.68           C  
ATOM    124  CG  ASP    16      22.232  49.623  82.672  1.00 68.11           C  
ATOM    125  OD1 ASP    16      21.178  49.073  83.077  1.00 74.84           O  
ATOM    126  OD2 ASP    16      22.526  50.864  82.858  1.00 74.19           O  
ATOM    127  N   ILE    17      24.610  47.746  79.266  1.00 59.31           N  
ATOM    128  CA  ILE    17      25.768  47.894  78.435  1.00 58.61           C  
ATOM    129  C   ILE    17      25.329  48.077  76.973  1.00 58.36           C  
ATOM    130  O   ILE    17      25.962  48.806  76.173  1.00 58.26           O  
ATOM    131  CB  ILE    17      26.776  46.737  78.709  1.00 58.41           C  
ATOM    132  CG1 ILE    17      27.396  47.016  80.102  1.00 59.02           C  
ATOM    133  CG2 ILE    17      27.855  46.699  77.673  1.00 55.26           C  
ATOM    134  CD1 ILE    17      27.730  45.783  80.928  1.00 58.25           C  
ATOM    135  N   HIS    18      24.204  47.478  76.654  1.00 57.90           N  
ATOM    136  CA  HIS    18      23.629  47.664  75.351  1.00 58.94           C  
ATOM    137  C   HIS    18      23.112  49.113  75.217  1.00 59.57           C  
ATOM    138  O   HIS    18      23.374  49.768  74.222  1.00 60.69           O  
ATOM    139  CB  HIS    18      22.526  46.645  75.090  1.00 57.67           C  
ATOM    140  CG  HIS    18      21.918  46.772  73.737  1.00 57.96           C  
ATOM    141  ND1 HIS    18      20.628  47.214  73.539  1.00 58.77           N  
ATOM    142  CD2 HIS    18      22.425  46.528  72.505  1.00 58.94           C  
ATOM    143  CE1 HIS    18      20.359  47.219  72.245  1.00 60.89           C  
ATOM    144  NE2 HIS    18      21.434  46.803  71.595  1.00 61.68           N  
ATOM    145  N   MET    19      22.406  49.635  76.201  1.00 60.21           N  
ATOM    146  CA  MET    19      21.950  51.024  76.073  1.00 61.55           C  
ATOM    147  C   MET    19      23.110  51.997  75.938  1.00 61.25           C  
ATOM    148  O   MET    19      23.060  52.863  75.066  1.00 61.91           O  
ATOM    149  CB  MET    19      21.069  51.463  77.232  1.00 62.10           C  
ATOM    150  CG  MET    19      19.700  50.779  77.275  1.00 67.35           C  
ATOM    151  SD  MET    19      18.646  50.737  75.611  0.70 78.76          SE  
ATOM    152  CE  MET    19      17.526  52.242  75.897  1.00 73.10           C  
ATOM    153  N   GLU    20      24.145  51.856  76.772  1.00 60.29           N  
ATOM    154  CA  GLU    20      25.248  52.795  76.767  1.00 60.15           C  
ATOM    155  C   GLU    20      26.152  52.649  75.538  1.00 60.05           C  
ATOM    156  O   GLU    20      26.716  53.622  75.082  1.00 61.14           O  
ATOM    157  CB  GLU    20      26.110  52.629  78.003  1.00 60.63           C  
ATOM    158  CG  GLU    20      25.379  52.438  79.286  1.00 63.50           C  
ATOM    159  CD  GLU    20      25.814  53.410  80.356  1.00 68.04           C  
ATOM    160  OE1 GLU    20      26.697  54.260  80.104  1.00 70.18           O  
ATOM    161  OE2 GLU    20      25.245  53.346  81.463  1.00 72.19           O  
ATOM    162  N   THR    21      26.292  51.453  74.989  1.00 58.97           N  
ATOM    163  CA  THR    21      27.239  51.263  73.902  1.00 58.25           C  
ATOM    164  C   THR    21      26.625  51.052  72.532  1.00 58.63           C  
ATOM    165  O   THR    21      27.294  51.276  71.547  1.00 59.56           O  
ATOM    166  CB  THR    21      28.229  50.062  74.160  1.00 57.95           C  
ATOM    167  OG1 THR    21      27.559  48.822  73.928  1.00 53.65           O  
ATOM    168  CG2 THR    21      28.813  50.091  75.593  1.00 57.31           C  
ATOM    169  N   GLY    22      25.388  50.561  72.458  1.00 59.40           N  
ATOM    170  CA  GLY    22      24.713  50.279  71.177  1.00 58.70           C  
ATOM    171  C   GLY    22      25.251  49.067  70.445  1.00 59.54           C  
ATOM    172  O   GLY    22      24.683  48.653  69.426  1.00 59.78           O  
ATOM    173  N   GLU    23      26.327  48.469  70.976  1.00 59.24           N  
ATOM    174  CA  GLU    23      26.980  47.302  70.367  1.00 58.58           C  
ATOM    175  C   GLU    23      26.200  45.998  70.555  1.00 58.88           C  
ATOM    176  O   GLU    23      25.259  45.959  71.333  1.00 58.65           O  
ATOM    177  CB  GLU    23      28.390  47.164  70.925  1.00 57.76           C  
ATOM    178  CG  GLU    23      29.214  48.414  70.770  1.00 58.46           C  
ATOM    179  CD  GLU    23      29.610  48.755  69.295  1.00 59.54           C  
ATOM    180  OE1 GLU    23      29.386  47.923  68.411  1.00 54.46           O  
ATOM    181  OE2 GLU    23      30.168  49.866  69.047  1.00 60.23           O  
ATOM    182  N   THR    24      26.562  44.942  69.806  1.00 59.29           N  
ATOM    183  CA  THR    24      26.049  43.581  70.074  1.00 59.56           C  
ATOM    184  C   THR    24      26.676  43.137  71.355  1.00 59.12           C  
ATOM    185  O   THR    24      27.906  43.220  71.551  1.00 59.04           O  
ATOM    186  CB  THR    24      26.459  42.569  68.998  1.00 59.44           C  
ATOM    187  OG1 THR    24      26.050  43.044  67.721  1.00 62.46           O  
ATOM    188  CG2 THR    24      25.755  41.242  69.199  1.00 60.40           C  
ATOM    189  N   VAL    25      25.836  42.700  72.267  1.00 58.81           N  
ATOM    190  CA  VAL    25      26.314  42.319  73.595  1.00 57.45           C  
ATOM    191  C   VAL    25      25.838  40.880  73.800  1.00 57.93           C  
ATOM    192  O   VAL    25      24.808  40.483  73.197  1.00 57.90           O  
ATOM    193  CB  VAL    25      25.819  43.293  74.708  1.00 57.29           C  
ATOM    194  CG1 VAL    25      26.282  44.692  74.424  1.00 57.65           C  
ATOM    195  CG2 VAL    25      24.329  43.310  74.816  1.00 58.67           C  
ATOM    196  N   ALA    26      26.564  40.088  74.618  1.00 57.17           N  
ATOM    197  CA  ALA    26      26.181  38.702  74.836  1.00 55.78           C  
ATOM    198  C   ALA    26      26.677  38.156  76.173  1.00 56.21           C  
ATOM    199  O   ALA    26      27.692  38.660  76.718  1.00 56.85           O  
ATOM    200  CB  ALA    26      26.707  37.843  73.700  1.00 55.84           C  
ATOM    201  N   ILE    27      25.957  37.134  76.666  1.00 54.82           N  
ATOM    202  CA  ILE    27      26.373  36.215  77.724  1.00 54.97           C  
ATOM    203  C   ILE    27      26.665  34.880  77.036  1.00 55.40           C  
ATOM    204  O   ILE    27      25.875  34.388  76.208  1.00 55.50           O  
ATOM    205  CB  ILE    27      25.204  35.998  78.727  1.00 54.89           C  
ATOM    206  CG1 ILE    27      24.675  37.364  79.201  1.00 58.42           C  
ATOM    207  CG2 ILE    27      25.620  35.224  79.941  1.00 54.79           C  
ATOM    208  CD1 ILE    27      25.763  38.300  79.861  1.00 56.11           C  
ATOM    209  N   ALA    28      27.814  34.304  77.343  1.00 56.24           N  
ATOM    210  CA  ALA    28      28.220  33.025  76.762  1.00 57.33           C  
ATOM    211  C   ALA    28      28.899  32.114  77.789  1.00 58.02           C  
ATOM    212  O   ALA    28      29.500  32.581  78.756  1.00 59.65           O  
ATOM    213  CB  ALA    28      29.165  33.270  75.595  1.00 57.05           C  
ATOM    214  N   THR    29      28.831  30.815  77.549  1.00 58.45           N  
ATOM    215  CA  THR    29      29.438  29.821  78.373  1.00 59.29           C  
ATOM    216  C   THR    29      30.122  28.796  77.461  1.00 60.09           C  
ATOM    217  O   THR    29      30.062  28.945  76.238  1.00 60.75           O  
ATOM    218  CB  THR    29      28.366  29.129  79.253  1.00 59.14           C  
ATOM    219  OG1 THR    29      29.027  28.212  80.107  1.00 62.44           O  
ATOM    220  CG2 THR    29      27.313  28.329  78.420  1.00 59.03           C  
ATOM    221  N   LYS    30      30.752  27.746  78.017  1.00 60.10           N  
ATOM    222  CA  LYS    30      31.294  26.714  77.138  1.00 60.17           C  
ATOM    223  C   LYS    30      30.503  25.423  77.045  1.00 60.24           C  
ATOM    224  O   LYS    30      29.848  24.988  77.989  1.00 60.38           O  
ATOM    225  CB  LYS    30      32.766  26.424  77.403  1.00 59.87           C  
ATOM    226  CG  LYS    30      33.091  25.799  78.698  1.00 58.67           C  
ATOM    227  CD  LYS    30      34.590  25.975  78.926  1.00 56.57           C  
ATOM    228  CE  LYS    30      34.916  25.743  80.373  1.00 62.17           C  
ATOM    229  NZ  LYS    30      34.346  24.439  80.917  1.00 61.02           N  
ATOM    230  N   ASN    31      30.566  24.829  75.867  1.00 60.09           N  
ATOM    231  CA  ASN    31      29.974  23.554  75.632  1.00 60.15           C  
ATOM    232  C   ASN    31      31.129  22.711  75.064  1.00 60.85           C  
ATOM    233  O   ASN    31      31.450  22.809  73.874  1.00 60.33           O  
ATOM    234  CB  ASN    31      28.809  23.697  74.659  1.00 59.81           C  
ATOM    235  CG  ASN    31      28.273  22.369  74.202  1.00 60.90           C  
ATOM    236  OD1 ASN    31      28.415  21.365  74.897  1.00 62.42           O  
ATOM    237  ND2 ASN    31      27.650  22.343  73.028  1.00 62.72           N  
ATOM    238  N   ASP    32      31.768  21.920  75.944  1.00 60.79           N  
ATOM    239  CA  ASP    32      32.969  21.138  75.588  1.00 60.54           C  
ATOM    240  C   ASP    32      34.075  22.119  75.089  1.00 59.98           C  
ATOM    241  O   ASP    32      34.582  22.895  75.888  1.00 61.62           O  
ATOM    242  CB  ASP    32      32.586  20.014  74.598  1.00 60.03           C  
ATOM    243  CG  ASP    32      33.770  19.211  74.127  1.00 61.08           C  
ATOM    244  OD1 ASP    32      34.747  19.094  74.899  1.00 61.78           O  
ATOM    245  OD2 ASP    32      33.727  18.690  72.982  1.00 60.46           O  
ATOM    246  N   ILE    33      34.429  22.136  73.811  1.00 58.31           N  
ATOM    247  CA  ILE    33      35.454  23.066  73.335  1.00 57.06           C  
ATOM    248  C   ILE    33      34.847  24.188  72.442  1.00 58.02           C  
ATOM    249  O   ILE    33      35.556  24.857  71.665  1.00 57.54           O  
ATOM    250  CB  ILE    33      36.537  22.325  72.532  1.00 56.55           C  
ATOM    251  CG1 ILE    33      35.932  21.627  71.325  1.00 53.36           C  
ATOM    252  CG2 ILE    33      37.325  21.324  73.397  1.00 55.34           C  
ATOM    253  CD1 ILE    33      36.969  21.338  70.290  1.00 56.07           C  
ATOM    254  N   TYR    34      33.531  24.347  72.532  1.00 58.02           N  
ATOM    255  CA  TYR    34      32.789  25.305  71.721  1.00 59.60           C  
ATOM    256  C   TYR    34      32.153  26.416  72.587  1.00 60.55           C  
ATOM    257  O   TYR    34      31.805  26.201  73.766  1.00 60.57           O  
ATOM    258  CB  TYR    34      31.702  24.615  70.881  1.00 58.70           C  
ATOM    259  CG  TYR    34      32.255  23.504  70.077  1.00 59.51           C  
ATOM    260  CD1 TYR    34      32.919  23.749  68.863  1.00 62.22           C  
ATOM    261  CD2 TYR    34      32.182  22.198  70.539  1.00 56.56           C  
ATOM    262  CE1 TYR    34      33.483  22.679  68.123  1.00 61.17           C  
ATOM    263  CE2 TYR    34      32.717  21.160  69.832  1.00 56.81           C  
ATOM    264  CZ  TYR    34      33.370  21.398  68.642  1.00 59.90           C  
ATOM    265  OH  TYR    34      33.887  20.328  67.971  1.00 62.06           O  
ATOM    266  N   LEU    35      31.982  27.581  71.980  1.00 60.82           N  
ATOM    267  CA  LEU    35      31.425  28.696  72.682  1.00 62.79           C  
ATOM    268  C   LEU    35      29.913  28.510  72.508  1.00 62.91           C  
ATOM    269  O   LEU    35      29.501  28.106  71.419  1.00 64.79           O  
ATOM    270  CB  LEU    35      31.945  30.022  72.105  1.00 62.74           C  
ATOM    271  CG  LEU    35      31.470  31.295  72.849  1.00 64.45           C  
ATOM    272  CD1 LEU    35      32.360  31.531  74.025  1.00 60.26           C  
ATOM    273  CD2 LEU    35      31.499  32.507  71.931  1.00 64.70           C  
ATOM    274  N   GLN    36      29.144  28.723  73.586  0.70 62.01           N  
ATOM    276  CA  GLN    36      27.698  28.652  73.584  0.70 61.91           C  
ATOM    278  C   GLN    36      27.186  30.009  74.064  0.70 62.05           C  
ATOM    280  O   GLN    36      27.602  30.512  75.114  0.70 60.93           O  
ATOM    282  CB  GLN    36      27.220  27.558  74.527  0.70 61.83           C  
ATOM    284  CG  GLN    36      25.819  27.041  74.247  0.70 63.49           C  
ATOM    286  CD  GLN    36      25.239  26.247  75.415  0.70 63.28           C  
ATOM    288  OE1 GLN    36      25.812  25.265  75.837  0.70 68.16           O  
ATOM    290  NE2 GLN    36      24.103  26.691  75.946  0.70 65.60           N  
ATOM    292  N   TYR    37      26.295  30.613  73.278  1.00 61.85           N  
ATOM    293  CA  TYR    37      25.624  31.862  73.670  1.00 61.15           C  
ATOM    294  C   TYR    37      24.399  31.593  74.494  1.00 59.84           C  
ATOM    295  O   TYR    37      23.619  30.759  74.123  1.00 60.44           O  
ATOM    296  CB  TYR    37      25.248  32.676  72.430  1.00 61.54           C  
ATOM    297  CG  TYR    37      26.466  33.251  71.790  1.00 62.86           C  
ATOM    298  CD1 TYR    37      27.216  34.220  72.442  1.00 60.43           C  
ATOM    299  CD2 TYR    37      26.901  32.809  70.537  1.00 65.34           C  
ATOM    300  CE1 TYR    37      28.366  34.738  71.876  1.00 60.87           C  
ATOM    301  CE2 TYR    37      28.061  33.346  69.965  1.00 62.90           C  
ATOM    302  CZ  TYR    37      28.768  34.301  70.635  1.00 63.13           C  
ATOM    303  OH  TYR    37      29.918  34.831  70.071  1.00 67.04           O  
ATOM    304  N   ILE    38      24.230  32.289  75.610  1.00 59.21           N  
ATOM    305  CA  ILE    38      23.013  32.139  76.463  1.00 58.20           C  
ATOM    306  C   ILE    38      21.998  33.234  76.094  1.00 57.77           C  
ATOM    307  O   ILE    38      20.779  33.008  76.118  1.00 58.35           O  
ATOM    308  CB  ILE    38      23.383  32.227  77.946  1.00 58.32           C  
ATOM    309  CG1 ILE    38      24.010  30.910  78.398  1.00 58.97           C  
ATOM    310  CG2 ILE    38      22.166  32.562  78.833  1.00 58.69           C  
ATOM    311  CD1 ILE    38      24.888  31.011  79.594  1.00 57.72           C  
ATOM    312  N   GLN    39      22.504  34.415  75.721  1.00 55.55           N  
ATOM    313  CA  GLN    39      21.666  35.556  75.381  1.00 54.01           C  
ATOM    314  C   GLN    39      22.493  36.510  74.615  1.00 53.04           C  
ATOM    315  O   GLN    39      23.646  36.769  74.994  1.00 54.10           O  
ATOM    316  CB  GLN    39      21.143  36.318  76.610  1.00 53.35           C  
ATOM    317  CG  GLN    39      20.273  37.518  76.256  1.00 51.78           C  
ATOM    318  CD  GLN    39      18.924  37.104  75.683  1.00 53.58           C  
ATOM    319  OE1 GLN    39      18.125  36.427  76.351  1.00 54.79           O  
ATOM    320  NE2 GLN    39      18.642  37.543  74.460  1.00 51.38           N  
ATOM    321  N   ILE    40      21.872  37.048  73.576  1.00 53.01           N  
ATOM    322  CA  ILE    40      22.460  37.999  72.648  1.00 54.32           C  
ATOM    323  C   ILE    40      21.443  39.089  72.532  1.00 54.45           C  
ATOM    324  O   ILE    40      20.241  38.802  72.387  1.00 53.13           O  
ATOM    325  CB  ILE    40      22.644  37.356  71.237  1.00 54.92           C  
ATOM    326  CG1 ILE    40      23.673  36.232  71.341  1.00 56.91           C  
ATOM    327  CG2 ILE    40      23.088  38.411  70.174  1.00 53.95           C  
ATOM    328  CD1 ILE    40      23.497  35.220  70.200  1.00 62.70           C  
ATOM    329  N   ILE    41      21.916  40.324  72.646  1.00 54.89           N  
ATOM    330  CA  ILE    41      21.146  41.479  72.242  1.00 56.47           C  
ATOM    331  C   ILE    41      21.851  42.189  71.064  1.00 57.24           C  
ATOM    332  O   ILE    41      23.010  42.600  71.162  1.00 56.09           O  
ATOM    333  CB  ILE    41      20.922  42.413  73.437  1.00 57.58           C  
ATOM    334  CG1 ILE    41      20.309  41.618  74.606  1.00 56.84           C  
ATOM    335  CG2 ILE    41      20.059  43.630  73.025  1.00 56.15           C  
ATOM    336  CD1 ILE    41      20.249  42.418  75.898  1.00 57.64           C  
ATOM    337  N   GLU    42      21.150  42.275  69.930  0.50 58.60           N  
ATOM    339  CA  GLU    42      21.737  42.779  68.677  0.50 59.91           C  
ATOM    341  C   GLU    42      21.887  44.290  68.699  0.50 59.38           C  
ATOM    343  O   GLU    42      21.031  45.008  69.225  0.50 60.09           O  
ATOM    345  CB  GLU    42      20.937  42.327  67.437  0.50 59.70           C  
ATOM    347  CG  GLU    42      21.709  42.516  66.084  0.50 61.58           C  
ATOM    349  CD  GLU    42      21.014  41.884  64.855  0.50 62.17           C  
ATOM    351  OE1 GLU    42      21.072  40.629  64.699  0.50 64.45           O  
ATOM    353  OE2 GLU    42      20.432  42.649  64.041  0.50 60.87           O  
ATOM    355  N   SER    43      23.002  44.740  68.141  1.00 59.25           N  
ATOM    356  CA  SER    43      23.355  46.133  67.959  1.00 58.50           C  
ATOM    357  C   SER    43      22.298  46.897  67.185  1.00 58.46           C  
ATOM    358  O   SER    43      21.519  46.314  66.445  1.00 59.01           O  
ATOM    359  CB  SER    43      24.674  46.202  67.167  1.00 57.90           C  
ATOM    360  OG  SER    43      25.051  47.555  66.994  1.00 59.25           O  
ATOM    361  N   VAL    44      22.286  48.217  67.359  1.00 58.06           N  
ATOM    362  CA  VAL    44      21.468  49.108  66.579  1.00 57.11           C  
ATOM    363  C   VAL    44      22.321  49.846  65.533  1.00 56.38           C  
ATOM    364  O   VAL    44      21.790  50.674  64.814  1.00 55.77           O  
ATOM    365  CB  VAL    44      20.806  50.149  67.484  1.00 57.90           C  
ATOM    366  CG1 VAL    44      19.692  49.471  68.322  1.00 59.20           C  
ATOM    367  CG2 VAL    44      21.886  50.864  68.405  1.00 56.67           C  
ATOM    368  N   HIS    45      23.625  49.575  65.457  1.00 54.20           N  
ATOM    369  CA  HIS    45      24.435  50.225  64.413  1.00 54.33           C  
ATOM    370  C   HIS    45      24.166  49.611  63.037  1.00 54.09           C  
ATOM    371  O   HIS    45      23.789  48.445  62.908  1.00 54.12           O  
ATOM    372  CB  HIS    45      25.929  50.109  64.736  1.00 53.49           C  
ATOM    373  CG  HIS    45      26.285  50.704  66.062  1.00 55.56           C  
ATOM    374  ND1 HIS    45      26.153  52.056  66.339  1.00 52.55           N  
ATOM    375  CD2 HIS    45      26.731  50.123  67.205  1.00 55.86           C  
ATOM    376  CE1 HIS    45      26.518  52.280  67.589  1.00 55.53           C  
ATOM    377  NE2 HIS    45      26.884  51.125  68.132  1.00 58.42           N  
ATOM    378  N   ALA    46      24.391  50.392  62.015  1.00 54.07           N  
ATOM    379  CA  ALA    46      24.227  49.917  60.652  1.00 55.35           C  
ATOM    380  C   ALA    46      25.188  48.734  60.377  1.00 55.86           C  
ATOM    381  O   ALA    46      24.779  47.633  59.972  1.00 55.11           O  
ATOM    382  CB  ALA    46      24.506  51.069  59.699  1.00 54.46           C  
ATOM    383  N   LEU    47      26.467  48.962  60.621  1.00 55.28           N  
ATOM    384  CA  LEU    47      27.377  47.918  60.442  1.00 56.25           C  
ATOM    385  C   LEU    47      27.511  47.148  61.767  1.00 57.03           C  
ATOM    386  O   LEU    47      28.034  47.672  62.734  1.00 57.57           O  
ATOM    387  CB  LEU    47      28.693  48.504  59.974  1.00 55.59           C  
ATOM    388  CG  LEU    47      29.831  47.494  59.835  1.00 57.97           C  
ATOM    389  CD1 LEU    47      29.449  46.359  58.803  1.00 54.62           C  
ATOM    390  CD2 LEU    47      31.099  48.273  59.426  1.00 55.91           C  
ATOM    391  N   ARG    48      27.074  45.897  61.817  1.00 58.29           N  
ATOM    392  CA  ARG    48      27.158  45.153  63.069  1.00 59.99           C  
ATOM    393  C   ARG    48      27.398  43.654  62.958  1.00 61.56           C  
ATOM    394  O   ARG    48      27.378  43.087  61.867  1.00 61.63           O  
ATOM    395  CB  ARG    48      25.875  45.345  63.836  1.00 60.62           C  
ATOM    396  CG  ARG    48      24.702  44.576  63.294  1.00 58.36           C  
ATOM    397  CD  ARG    48      23.538  45.335  63.769  1.00 62.40           C  
ATOM    398  NE  ARG    48      22.270  44.850  63.280  1.00 64.49           N  
ATOM    399  CZ  ARG    48      21.233  45.649  63.067  1.00 64.30           C  
ATOM    400  NH1 ARG    48      21.351  46.959  63.281  1.00 63.31           N  
ATOM    401  NH2 ARG    48      20.094  45.141  62.613  1.00 63.51           N  
ATOM    402  N   PHE    49      27.599  43.027  64.115  1.00 63.14           N  
ATOM    403  CA  PHE    49      27.646  41.567  64.221  1.00 65.24           C  
ATOM    404  C   PHE    49      26.239  41.014  64.215  1.00 65.96           C  
ATOM    405  O   PHE    49      25.409  41.464  65.015  1.00 66.23           O  
ATOM    406  CB  PHE    49      28.359  41.136  65.513  1.00 66.03           C  
ATOM    407  CG  PHE    49      29.859  41.075  65.381  1.00 68.58           C  
ATOM    408  CD1 PHE    49      30.680  41.662  66.330  1.00 70.90           C  
ATOM    409  CD2 PHE    49      30.452  40.445  64.290  1.00 70.05           C  
ATOM    410  CE1 PHE    49      32.091  41.589  66.235  1.00 72.91           C  
ATOM    411  CE2 PHE    49      31.845  40.399  64.170  1.00 73.92           C  
ATOM    412  CZ  PHE    49      32.672  40.974  65.173  1.00 70.09           C  
ATOM    413  N   HIS    50      25.962  40.103  63.284  1.00 66.85           N  
ATOM    414  CA  HIS    50      24.758  39.309  63.317  1.00 68.69           C  
ATOM    415  C   HIS    50      25.208  37.896  63.694  1.00 70.93           C  
ATOM    416  O   HIS    50      25.696  37.140  62.841  1.00 72.02           O  
ATOM    417  CB  HIS    50      24.075  39.262  61.959  1.00 68.34           C  
ATOM    418  CG  HIS    50      23.636  40.593  61.434  1.00 66.68           C  
ATOM    419  ND1 HIS    50      24.521  41.613  61.145  1.00 67.30           N  
ATOM    420  CD2 HIS    50      22.408  41.048  61.085  1.00 66.59           C  
ATOM    421  CE1 HIS    50      23.850  42.645  60.650  1.00 69.25           C  
ATOM    422  NE2 HIS    50      22.565  42.327  60.598  1.00 67.09           N  
ATOM    423  N   VAL    51      25.074  37.542  64.969  1.00 72.80           N  
ATOM    424  CA  VAL    51      25.490  36.225  65.440  1.00 74.54           C  
ATOM    425  C   VAL    51      24.566  35.166  64.884  1.00 76.64           C  
ATOM    426  O   VAL    51      23.370  35.197  65.174  1.00 78.19           O  
ATOM    427  CB  VAL    51      25.536  36.112  67.004  1.00 74.55           C  
ATOM    428  CG1 VAL    51      26.104  34.706  67.433  1.00 74.48           C  
ATOM    429  CG2 VAL    51      26.337  37.271  67.630  1.00 70.10           C  
ATOM    430  N   ASP    52      25.115  34.279  64.049  1.00 78.72           N  
ATOM    431  CA  ASP    52      24.439  33.061  63.575  1.00 81.20           C  
ATOM    432  C   ASP    52      24.609  31.950  64.617  1.00 82.80           C  
ATOM    433  O   ASP    52      25.737  31.513  64.892  1.00 83.06           O  
ATOM    434  CB  ASP    52      25.040  32.609  62.241  1.00 81.03           C  
ATOM    435  CG  ASP    52      24.673  31.184  61.876  1.00 83.02           C  
ATOM    436  OD1 ASP    52      23.734  30.577  62.458  1.00 84.81           O  
ATOM    437  OD2 ASP    52      25.347  30.655  60.982  1.00 84.60           O  
ATOM    438  N   GLU    53      23.492  31.484  65.176  1.00 84.68           N  
ATOM    439  CA  GLU    53      23.530  30.555  66.322  1.00 85.92           C  
ATOM    440  C   GLU    53      23.834  29.109  65.886  1.00 85.79           C  
ATOM    441  O   GLU    53      24.435  28.337  66.633  1.00 85.94           O  
ATOM    442  CB  GLU    53      22.220  30.629  67.119  1.00 86.63           C  
ATOM    443  CG  GLU    53      22.102  31.862  68.024  0.60 87.28           C  
ATOM    444  CD  GLU    53      20.726  32.513  67.933  0.60 89.75           C  
ATOM    445  OE1 GLU    53      19.709  31.792  67.794  0.60 90.02           O  
ATOM    446  OE2 GLU    53      20.658  33.760  68.016  0.60 91.66           O  
ATOM    447  N   ASN    54      23.439  28.755  64.670  1.00 85.26           N  
ATOM    448  CA  ASN    54      23.786  27.446  64.124  1.00 84.59           C  
ATOM    449  C   ASN    54      25.318  27.277  63.940  1.00 83.75           C  
ATOM    450  O   ASN    54      25.804  26.162  63.726  1.00 83.96           O  
ATOM    451  CB  ASN    54      23.039  27.208  62.800  0.60 84.69           C  
ATOM    452  CG  ASN    54      22.767  25.720  62.520  0.60 86.08           C  
ATOM    453  OD1 ASN    54      23.307  24.824  63.184  0.60 86.21           O  
ATOM    454  ND2 ASN    54      21.925  25.459  61.519  0.60 86.49           N  
ATOM    455  N   ALA    55      26.067  28.380  64.003  1.00 81.92           N  
ATOM    456  CA  ALA    55      27.524  28.342  63.826  1.00 80.70           C  
ATOM    457  C   ALA    55      28.178  27.586  64.984  1.00 79.23           C  
ATOM    458  O   ALA    55      27.803  27.762  66.133  1.00 79.82           O  
ATOM    459  CB  ALA    55      28.111  29.781  63.712  1.00 80.15           C  
ATOM    460  N   ILE    56      29.151  26.744  64.673  1.00 77.79           N  
ATOM    461  CA  ILE    56      29.908  25.989  65.678  1.00 75.90           C  
ATOM    462  C   ILE    56      31.181  26.767  65.873  1.00 74.50           C  
ATOM    463  O   ILE    56      31.910  26.976  64.913  1.00 74.29           O  
ATOM    464  CB  ILE    56      30.321  24.589  65.149  1.00 76.40           C  
ATOM    465  CG1 ILE    56      29.092  23.763  64.712  1.00 75.34           C  
ATOM    466  CG2 ILE    56      31.187  23.862  66.178  1.00 75.84           C  
ATOM    467  CD1 ILE    56      29.325  22.980  63.417  1.00 77.73           C  
ATOM    468  N   ARG    57      31.487  27.201  67.086  1.00 72.12           N  
ATOM    469  CA  ARG    57      32.693  27.987  67.183  1.00 69.90           C  
ATOM    470  C   ARG    57      33.635  27.565  68.274  1.00 66.50           C  
ATOM    471  O   ARG    57      33.315  27.693  69.445  1.00 66.81           O  
ATOM    472  CB  ARG    57      32.374  29.478  67.250  1.00 70.93           C  
ATOM    473  CG  ARG    57      31.240  29.833  68.125  1.00 76.49           C  
ATOM    474  CD  ARG    57      30.491  31.104  67.618  1.00 84.39           C  
ATOM    475  NE  ARG    57      29.043  30.863  67.752  1.00 89.80           N  
ATOM    476  CZ  ARG    57      28.082  31.417  67.016  1.00 91.00           C  
ATOM    477  NH1 ARG    57      28.343  32.318  66.062  1.00 89.27           N  
ATOM    478  NH2 ARG    57      26.837  31.055  67.262  1.00 94.92           N  
ATOM    479  N   PRO    58      34.812  27.064  67.894  1.00 63.24           N  
ATOM    480  CA  PRO    58      35.795  26.606  68.893  1.00 60.90           C  
ATOM    481  C   PRO    58      36.292  27.734  69.769  1.00 59.63           C  
ATOM    482  O   PRO    58      36.399  28.876  69.317  1.00 58.11           O  
ATOM    483  CB  PRO    58      36.936  26.041  68.045  1.00 60.40           C  
ATOM    484  CG  PRO    58      36.333  25.842  66.652  1.00 61.19           C  
ATOM    485  CD  PRO    58      35.270  26.871  66.507  1.00 62.00           C  
ATOM    486  N   LEU    59      36.609  27.414  71.019  1.00 59.37           N  
ATOM    487  CA  LEU    59      37.029  28.425  72.022  1.00 59.11           C  
ATOM    488  C   LEU    59      38.287  29.220  71.640  1.00 58.79           C  
ATOM    489  O   LEU    59      38.460  30.373  72.082  1.00 57.89           O  
ATOM    490  CB  LEU    59      37.198  27.794  73.415  1.00 58.49           C  
ATOM    491  CG  LEU    59      35.901  27.243  74.025  1.00 59.78           C  
ATOM    492  CD1 LEU    59      36.126  26.407  75.321  1.00 58.03           C  
ATOM    493  CD2 LEU    59      34.899  28.333  74.296  1.00 61.08           C  
ATOM    494  N   THR    60      39.165  28.627  70.834  1.00 58.42           N  
ATOM    495  CA  THR    60      40.355  29.358  70.385  1.00 59.36           C  
ATOM    496  C   THR    60      40.040  30.565  69.445  1.00 60.12           C  
ATOM    497  O   THR    60      40.906  31.385  69.165  1.00 60.01           O  
ATOM    498  CB  THR    60      41.361  28.430  69.673  1.00 59.36           C  
ATOM    499  OG1 THR    60      40.676  27.731  68.642  1.00 59.76           O  
ATOM    500  CG2 THR    60      42.023  27.433  70.630  1.00 56.72           C  
ATOM    501  N   MET    61      38.809  30.682  68.978  1.00 60.58           N  
ATOM    502  CA  MET    61      38.537  31.613  67.887  1.00 62.59           C  
ATOM    503  C   MET    61      37.882  32.922  68.305  1.00 62.66           C  
ATOM    504  O   MET    61      37.505  33.689  67.422  1.00 63.60           O  
ATOM    505  CB  MET    61      37.683  30.942  66.796  1.00 62.56           C  
ATOM    506  CG  MET    61      38.402  29.794  66.080  1.00 67.94           C  
ATOM    507  SD  MET    61      39.847  30.478  64.868  0.90 83.32          SE  
ATOM    508  CE  MET    61      38.659  31.285  63.505  1.00 77.45           C  
ATOM    509  N   SER    62      37.721  33.171  69.610  1.00 61.38           N  
ATOM    510  CA  SER    62      37.147  34.424  70.072  1.00 61.72           C  
ATOM    511  C   SER    62      37.695  34.811  71.425  1.00 62.10           C  
ATOM    512  O   SER    62      38.123  33.954  72.211  1.00 62.73           O  
ATOM    513  CB  SER    62      35.625  34.314  70.193  1.00 61.40           C  
ATOM    514  OG  SER    62      35.327  33.225  71.043  1.00 61.28           O  
ATOM    515  N   SER    63      37.680  36.107  71.713  1.00 62.25           N  
ATOM    516  CA  SER    63      38.120  36.572  73.022  1.00 61.90           C  
ATOM    517  C   SER    63      37.217  35.966  74.109  1.00 61.96           C  
ATOM    518  O   SER    63      37.692  35.658  75.202  1.00 62.43           O  
ATOM    519  CB  SER    63      38.114  38.099  73.078  1.00 61.78           C  
ATOM    520  OG  SER    63      36.778  38.581  72.922  1.00 63.32           O  
ATOM    521  N   ASN    64      35.928  35.765  73.825  1.00 62.05           N  
ATOM    522  CA  ASN    64      35.058  35.037  74.789  1.00 63.21           C  
ATOM    523  C   ASN    64      35.599  33.635  75.064  1.00 62.15           C  
ATOM    524  O   ASN    64      35.608  33.220  76.205  1.00 62.11           O  
ATOM    525  CB  ASN    64      33.632  34.858  74.260  1.00 65.22           C  
ATOM    526  CG  ASN    64      32.778  36.042  74.477  1.00 68.29           C  
ATOM    527  OD1 ASN    64      32.593  36.515  75.600  1.00 79.28           O  
ATOM    528  ND2 ASN    64      32.227  36.524  73.425  1.00 70.86           N  
ATOM    529  N   GLY    65      36.030  32.934  74.000  1.00 60.23           N  
ATOM    530  CA  GLY    65      36.699  31.675  74.116  1.00 60.81           C  
ATOM    531  C   GLY    65      37.903  31.664  75.057  1.00 60.68           C  
ATOM    532  O   GLY    65      37.973  30.840  75.976  1.00 60.10           O  
ATOM    533  N   TRP    66      38.835  32.588  74.856  1.00 60.85           N  
ATOM    534  CA  TRP    66      40.039  32.658  75.709  1.00 60.06           C  
ATOM    535  C   TRP    66      39.646  32.902  77.155  1.00 61.15           C  
ATOM    536  O   TRP    66      40.247  32.351  78.101  1.00 61.99           O  
ATOM    537  CB  TRP    66      40.997  33.752  75.215  1.00 59.30           C  
ATOM    538  CG  TRP    66      41.271  33.740  73.697  1.00 57.28           C  
ATOM    539  CD1 TRP    66      41.269  32.654  72.901  1.00 57.25           C  
ATOM    540  CD2 TRP    66      41.640  34.855  72.848  1.00 57.57           C  
ATOM    541  NE1 TRP    66      41.578  32.999  71.603  1.00 59.16           N  
ATOM    542  CE2 TRP    66      41.805  34.345  71.537  1.00 58.40           C  
ATOM    543  CE3 TRP    66      41.845  36.233  73.066  1.00 57.46           C  
ATOM    544  CZ2 TRP    66      42.141  35.160  70.434  1.00 58.20           C  
ATOM    545  CZ3 TRP    66      42.174  37.045  71.978  1.00 57.05           C  
ATOM    546  CH2 TRP    66      42.321  36.504  70.679  1.00 58.18           C  
ATOM    547  N   MET    67      38.620  33.721  77.354  1.00 61.67           N  
ATOM    548  CA  MET    67      38.196  34.034  78.730  1.00 61.56           C  
ATOM    549  C   MET    67      37.675  32.751  79.398  1.00 61.45           C  
ATOM    550  O   MET    67      38.030  32.471  80.533  1.00 60.34           O  
ATOM    551  CB  MET    67      37.128  35.144  78.733  1.00 62.34           C  
ATOM    552  CG  MET    67      36.847  35.786  80.055  1.00 62.83           C  
ATOM    553  SD  MET    67      38.278  37.022  80.632  0.85 76.26          SE  
ATOM    554  CE  MET    67      38.995  36.079  82.228  1.00 64.02           C  
ATOM    555  N   LEU    68      36.867  31.969  78.669  1.00 61.35           N  
ATOM    556  CA  LEU    68      36.327  30.715  79.196  1.00 61.71           C  
ATOM    557  C   LEU    68      37.367  29.609  79.436  1.00 62.43           C  
ATOM    558  O   LEU    68      37.310  28.891  80.449  1.00 62.05           O  
ATOM    559  CB  LEU    68      35.192  30.211  78.333  1.00 60.42           C  
ATOM    560  CG  LEU    68      34.014  31.190  78.339  1.00 59.67           C  
ATOM    561  CD1 LEU    68      33.203  31.009  77.111  1.00 53.38           C  
ATOM    562  CD2 LEU    68      33.125  31.045  79.587  1.00 56.87           C  
ATOM    563  N   MET    69      38.317  29.487  78.513  1.00 63.63           N  
ATOM    564  CA  MET    69      39.427  28.542  78.640  1.00 64.95           C  
ATOM    565  C   MET    69      40.298  28.887  79.821  1.00 63.85           C  
ATOM    566  O   MET    69      40.834  27.978  80.490  1.00 64.09           O  
ATOM    567  CB  MET    69      40.270  28.585  77.399  1.00 64.13           C  
ATOM    568  CG  MET    69      39.630  27.926  76.207  1.00 66.68           C  
ATOM    569  SD  MET    69      40.939  27.724  74.726  0.80 72.58          SE  
ATOM    570  CE  MET    69      40.747  29.457  73.987  1.00 62.11           C  
ATOM    571  N   SER    70      40.446  30.189  80.094  1.00 62.96           N  
ATOM    572  CA  SER    70      41.251  30.621  81.248  1.00 62.56           C  
ATOM    573  C   SER    70      40.745  30.049  82.590  1.00 61.84           C  
ATOM    574  O   SER    70      41.468  30.041  83.576  1.00 59.67           O  
ATOM    575  CB  SER    70      41.397  32.144  81.294  1.00 62.63           C  
ATOM    576  OG  SER    70      40.243  32.758  81.855  1.00 63.93           O  
ATOM    577  N   THR    71      39.523  29.517  82.591  1.00 62.19           N  
ATOM    578  CA  THR    71      38.983  28.859  83.794  1.00 63.14           C  
ATOM    579  C   THR    71      39.332  27.364  83.967  1.00 63.92           C  
ATOM    580  O   THR    71      39.199  26.839  85.071  1.00 62.99           O  
ATOM    581  CB  THR    71      37.458  29.064  83.955  1.00 62.41           C  
ATOM    582  OG1 THR    71      36.769  28.302  82.965  1.00 62.66           O  
ATOM    583  CG2 THR    71      37.098  30.522  83.810  1.00 61.93           C  
ATOM    584  N   MET    72      39.778  26.694  82.897  1.00 65.08           N  
ATOM    585  CA  MET    72      40.146  25.276  82.957  1.00 67.60           C  
ATOM    586  C   MET    72      41.548  25.007  83.593  1.00 66.23           C  
ATOM    587  O   MET    72      42.373  25.922  83.722  1.00 65.90           O  
ATOM    588  CB  MET    72      40.104  24.668  81.553  1.00 67.24           C  
ATOM    589  CG  MET    72      38.781  24.730  80.785  1.00 68.31           C  
ATOM    590  SD  MET    72      39.303  24.612  78.854  0.83 75.69          SE  
ATOM    591  CE  MET    72      37.549  24.486  78.022  1.00 70.38           C  
ATOM    592  N   ASN    73      41.822  23.756  83.975  1.00 65.62           N  
ATOM    593  CA  ASN    73      43.211  23.352  84.255  1.00 65.21           C  
ATOM    594  C   ASN    73      44.043  23.140  82.967  1.00 64.52           C  
ATOM    595  O   ASN    73      43.489  23.091  81.854  1.00 64.27           O  
ATOM    596  CB  ASN    73      43.283  22.131  85.181  1.00 65.82           C  
ATOM    597  CG  ASN    73      42.587  20.888  84.604  1.00 67.09           C  
ATOM    598  OD1 ASN    73      42.952  20.361  83.538  1.00 64.81           O  
ATOM    599  ND2 ASN    73      41.595  20.394  85.344  1.00 69.28           N  
ATOM    600  N   ASP    74      45.366  23.035  83.110  1.00 63.68           N  
ATOM    601  CA  ASP    74      46.261  23.053  81.935  1.00 63.28           C  
ATOM    602  C   ASP    74      46.104  21.827  81.067  1.00 62.96           C  
ATOM    603  O   ASP    74      46.128  21.926  79.841  1.00 62.13           O  
ATOM    604  CB  ASP    74      47.734  23.235  82.331  1.00 63.20           C  
ATOM    605  CG  ASP    74      48.018  24.603  82.948  1.00 62.80           C  
ATOM    606  OD1 ASP    74      47.344  25.614  82.582  1.00 57.50           O  
ATOM    607  OD2 ASP    74      48.943  24.654  83.805  1.00 63.27           O  
ATOM    608  N   LYS    75      45.951  20.669  81.716  1.00 63.12           N  
ATOM    609  CA  LYS    75      45.617  19.425  81.016  1.00 63.50           C  
ATOM    610  C   LYS    75      44.442  19.643  80.021  1.00 62.99           C  
ATOM    611  O   LYS    75      44.553  19.282  78.838  1.00 62.58           O  
ATOM    612  CB  LYS    75      45.302  18.311  82.018  1.00 64.00           C  
ATOM    613  CG  LYS    75      44.618  17.073  81.419  1.00 66.39           C  
ATOM    614  CD  LYS    75      45.609  16.170  80.682  1.00 68.66           C  
ATOM    615  CE  LYS    75      45.215  14.702  80.810  1.00 69.70           C  
ATOM    616  NZ  LYS    75      44.822  14.371  82.205  1.00 68.07           N  
ATOM    617  N   ALA    76      43.358  20.251  80.518  1.00 62.16           N  
ATOM    618  CA  ALA    76      42.173  20.555  79.738  1.00 61.81           C  
ATOM    619  C   ALA    76      42.404  21.654  78.702  1.00 61.74           C  
ATOM    620  O   ALA    76      41.778  21.620  77.655  1.00 62.13           O  
ATOM    621  CB  ALA    76      40.962  20.889  80.643  1.00 61.24           C  
ATOM    622  N   ILE    77      43.291  22.611  78.960  1.00 61.38           N  
ATOM    623  CA  ILE    77      43.527  23.668  77.966  1.00 61.49           C  
ATOM    624  C   ILE    77      44.270  23.122  76.741  1.00 61.52           C  
ATOM    625  O   ILE    77      43.900  23.431  75.582  1.00 61.15           O  
ATOM    626  CB  ILE    77      44.272  24.870  78.563  1.00 61.79           C  
ATOM    627  CG1 ILE    77      43.304  25.714  79.384  1.00 62.94           C  
ATOM    628  CG2 ILE    77      44.891  25.749  77.483  1.00 61.12           C  
ATOM    629  CD1 ILE    77      44.013  26.581  80.448  1.00 64.59           C  
ATOM    630  N   ASP    78      45.301  22.325  77.025  1.00 60.60           N  
ATOM    631  CA  ASP    78      46.123  21.617  76.035  1.00 60.87           C  
ATOM    632  C   ASP    78      45.265  20.716  75.162  1.00 60.02           C  
ATOM    633  O   ASP    78      45.365  20.782  73.944  1.00 60.82           O  
ATOM    634  CB  ASP    78      47.235  20.818  76.743  1.00 61.04           C  
ATOM    635  CG  ASP    78      48.164  20.069  75.768  1.00 63.40           C  
ATOM    636  OD1 ASP    78      49.198  20.665  75.346  1.00 64.85           O  
ATOM    637  OD2 ASP    78      47.897  18.863  75.476  1.00 63.02           O  
ATOM    638  N   ASN    79      44.386  19.920  75.764  1.00 58.88           N  
ATOM    639  CA  ASN    79      43.433  19.133  74.969  1.00 58.94           C  
ATOM    640  C   ASN    79      42.545  20.000  74.060  1.00 58.14           C  
ATOM    641  O   ASN    79      42.268  19.633  72.918  1.00 57.90           O  
ATOM    642  CB  ASN    79      42.566  18.223  75.848  1.00 59.09           C  
ATOM    643  CG  ASN    79      43.241  16.904  76.173  1.00 62.16           C  
ATOM    644  OD1 ASN    79      43.004  16.335  77.229  1.00 68.10           O  
ATOM    645  ND2 ASN    79      44.111  16.423  75.286  1.00 64.79           N  
ATOM    646  N   THR    80      42.128  21.144  74.586  1.00 56.98           N  
ATOM    647  CA  THR    80      41.215  22.041  73.923  1.00 56.94           C  
ATOM    648  C   THR    80      41.865  22.679  72.704  1.00 57.00           C  
ATOM    649  O   THR    80      41.270  22.741  71.660  1.00 56.26           O  
ATOM    650  CB  THR    80      40.747  23.142  74.904  1.00 56.98           C  
ATOM    651  OG1 THR    80      40.079  22.527  76.017  1.00 57.25           O  
ATOM    652  CG2 THR    80      39.822  24.144  74.210  1.00 54.70           C  
ATOM    653  N   VAL    81      43.106  23.121  72.845  1.00 57.77           N  
ATOM    654  CA  VAL    81      43.812  23.793  71.760  1.00 58.51           C  
ATOM    655  C   VAL    81      44.132  22.771  70.661  1.00 59.17           C  
ATOM    656  O   VAL    81      43.908  23.026  69.446  1.00 59.51           O  
ATOM    657  CB  VAL    81      45.077  24.485  72.298  1.00 58.47           C  
ATOM    658  CG1 VAL    81      45.956  25.012  71.173  1.00 59.77           C  
ATOM    659  CG2 VAL    81      44.667  25.627  73.229  1.00 58.29           C  
ATOM    660  N   ARG    82      44.650  21.625  71.097  1.00 58.86           N  
ATOM    661  CA  ARG    82      44.843  20.479  70.223  1.00 59.54           C  
ATOM    662  C   ARG    82      43.578  20.079  69.460  1.00 58.76           C  
ATOM    663  O   ARG    82      43.616  19.944  68.232  1.00 58.98           O  
ATOM    664  CB  ARG    82      45.336  19.280  71.016  1.00 59.66           C  
ATOM    665  CG  ARG    82      46.764  19.394  71.436  1.00 62.54           C  
ATOM    666  CD  ARG    82      47.353  18.008  71.689  1.00 68.17           C  
ATOM    667  NE  ARG    82      48.644  18.100  72.370  1.00 72.16           N  
ATOM    668  CZ  ARG    82      49.756  18.641  71.857  1.00 74.78           C  
ATOM    669  NH1 ARG    82      50.854  18.663  72.601  1.00 77.11           N  
ATOM    670  NH2 ARG    82      49.788  19.166  70.627  1.00 74.25           N  
ATOM    671  N   ARG    83      42.471  19.868  70.171  1.00 57.49           N  
ATOM    672  CA  ARG    83      41.263  19.414  69.504  1.00 56.42           C  
ATOM    673  C   ARG    83      40.747  20.521  68.593  1.00 57.09           C  
ATOM    674  O   ARG    83      40.403  20.291  67.422  1.00 57.36           O  
ATOM    675  CB  ARG    83      40.222  19.001  70.508  1.00 55.85           C  
ATOM    676  CG  ARG    83      40.414  17.634  71.086  1.00 52.71           C  
ATOM    677  CD  ARG    83      39.437  17.479  72.198  1.00 49.77           C  
ATOM    678  NE  ARG    83      38.088  17.644  71.693  1.00 50.59           N  
ATOM    679  CZ  ARG    83      36.995  17.770  72.437  1.00 51.09           C  
ATOM    680  NH1 ARG    83      35.796  17.947  71.861  1.00 52.66           N  
ATOM    681  NH2 ARG    83      37.089  17.758  73.743  1.00 48.77           N  
ATOM    682  N   ALA    84      40.759  21.740  69.114  1.00 56.57           N  
ATOM    683  CA  ALA    84      40.339  22.870  68.356  1.00 56.57           C  
ATOM    684  C   ALA    84      41.197  23.105  67.084  1.00 57.76           C  
ATOM    685  O   ALA    84      40.669  23.593  66.068  1.00 57.61           O  
ATOM    686  CB  ALA    84      40.286  24.127  69.264  1.00 55.96           C  
ATOM    687  N   ASN    85      42.490  22.782  67.118  1.00 58.24           N  
ATOM    688  CA  ASN    85      43.273  22.956  65.905  1.00 60.37           C  
ATOM    689  C   ASN    85      42.833  22.048  64.775  1.00 60.82           C  
ATOM    690  O   ASN    85      42.806  22.477  63.633  1.00 60.37           O  
ATOM    691  CB  ASN    85      44.775  22.831  66.141  1.00 60.47           C  
ATOM    692  CG  ASN    85      45.333  24.018  66.874  1.00 62.26           C  
ATOM    693  OD1 ASN    85      44.775  25.138  66.813  1.00 63.47           O  
ATOM    694  ND2 ASN    85      46.422  23.794  67.594  1.00 60.57           N  
ATOM    695  N   THR    86      42.459  20.806  65.091  1.00 61.75           N  
ATOM    696  CA  THR    86      42.035  19.873  64.035  1.00 62.30           C  
ATOM    697  C   THR    86      40.785  20.329  63.280  1.00 63.07           C  
ATOM    698  O   THR    86      40.472  19.804  62.212  1.00 63.65           O  
ATOM    699  CB  THR    86      41.828  18.456  64.559  1.00 62.23           C  
ATOM    700  OG1 THR    86      40.606  18.376  65.330  1.00 61.94           O  
ATOM    701  CG2 THR    86      43.042  18.049  65.370  1.00 60.63           C  
ATOM    702  N   ILE    87      40.077  21.290  63.854  1.00 63.43           N  
ATOM    703  CA  ILE    87      38.855  21.778  63.286  1.00 64.20           C  
ATOM    704  C   ILE    87      39.097  23.083  62.491  1.00 65.71           C  
ATOM    705  O   ILE    87      38.612  23.241  61.347  1.00 66.80           O  
ATOM    706  CB  ILE    87      37.839  22.037  64.409  1.00 64.04           C  
ATOM    707  CG1 ILE    87      37.428  20.720  65.060  1.00 64.25           C  
ATOM    708  CG2 ILE    87      36.622  22.825  63.896  1.00 61.32           C  
ATOM    709  CD1 ILE    87      36.579  20.902  66.315  1.00 64.40           C  
ATOM    710  N   THR    88      39.830  24.013  63.109  1.00 65.78           N  
ATOM    711  CA  THR    88      40.080  25.292  62.519  1.00 65.90           C  
ATOM    712  C   THR    88      41.104  25.172  61.410  1.00 67.94           C  
ATOM    713  O   THR    88      41.161  26.035  60.520  1.00 68.74           O  
ATOM    714  CB  THR    88      40.510  26.352  63.552  1.00 65.51           C  
ATOM    715  OG1 THR    88      41.762  26.000  64.153  1.00 62.03           O  
ATOM    716  CG2 THR    88      39.449  26.507  64.601  1.00 62.86           C  
ATOM    717  N   GLN    89      41.891  24.109  61.435  1.00 69.42           N  
ATOM    718  CA  GLN    89      42.896  23.928  60.401  1.00 72.17           C  
ATOM    719  C   GLN    89      42.322  23.397  59.095  1.00 73.16           C  
ATOM    720  O   GLN    89      43.009  23.403  58.065  1.00 73.16           O  
ATOM    721  CB  GLN    89      44.039  23.048  60.878  1.00 72.31           C  
ATOM    722  CG  GLN    89      43.839  21.604  60.590  1.00 74.64           C  
ATOM    723  CD  GLN    89      45.043  20.815  61.004  1.00 79.85           C  
ATOM    724  OE1 GLN    89      46.007  21.388  61.534  1.00 82.02           O  
ATOM    725  NE2 GLN    89      45.011  19.489  60.776  1.00 79.99           N  
ATOM    726  N   LYS    90      41.071  22.948  59.138  1.00 75.07           N  
ATOM    727  CA  LYS    90      40.334  22.613  57.916  1.00 76.91           C  
ATOM    728  C   LYS    90      40.078  23.899  57.120  1.00 77.20           C  
ATOM    729  O   LYS    90      39.646  23.844  55.972  1.00 77.61           O  
ATOM    730  CB  LYS    90      39.009  21.910  58.248  1.00 76.83           C  
ATOM    731  CG  LYS    90      39.163  20.447  58.696  1.00 78.58           C  
ATOM    732  CD  LYS    90      37.796  19.756  58.977  1.00 78.62           C  
ATOM    733  CE  LYS    90      37.079  20.337  60.220  1.00 80.18           C  
ATOM    734  NZ  LYS    90      36.280  19.307  60.970  1.00 78.76           N  
ATOM    735  N   ASP    91      40.348  25.045  57.747  1.00 77.44           N  
ATOM    736  CA  ASP    91      40.246  26.365  57.120  1.00 77.76           C  
ATOM    737  C   ASP    91      41.585  27.103  57.126  1.00 77.52           C  
ATOM    738  O   ASP    91      41.632  28.325  56.987  1.00 77.39           O  
ATOM    739  CB  ASP    91      39.208  27.222  57.867  1.00 78.38           C  
ATOM    740  CG  ASP    91      37.829  26.569  57.912  1.00 80.49           C  
ATOM    741  OD1 ASP    91      37.535  25.680  57.065  1.00 82.90           O  
ATOM    742  OD2 ASP    91      37.031  26.950  58.792  1.00 82.18           O  
ATOM    743  N   GLY    92      42.672  26.362  57.299  1.00 77.83           N  
ATOM    744  CA  GLY    92      44.023  26.940  57.329  1.00 78.14           C  
ATOM    745  C   GLY    92      44.409  27.771  58.555  1.00 78.53           C  
ATOM    746  O   GLY    92      45.425  28.465  58.523  1.00 79.06           O  
ATOM    747  N   ILE    93      43.619  27.708  59.627  1.00 78.12           N  
ATOM    748  CA  ILE    93      43.927  28.425  60.856  1.00 78.01           C  
ATOM    749  C   ILE    93      44.383  27.445  61.948  1.00 78.31           C  
ATOM    750  O   ILE    93      43.752  26.410  62.152  1.00 78.15           O  
ATOM    751  CB  ILE    93      42.682  29.204  61.341  1.00 78.66           C  
ATOM    752  CG1 ILE    93      42.101  30.093  60.211  1.00 78.35           C  
ATOM    753  CG2 ILE    93      42.945  29.921  62.713  1.00 76.93           C  
ATOM    754  CD1 ILE    93      43.079  31.140  59.608  1.00 81.98           C  
ATOM    755  N   ARG    94      45.467  27.756  62.653  1.00 78.39           N  
ATOM    756  CA  ARG    94      45.864  26.906  63.778  1.00 79.60           C  
ATOM    757  C   ARG    94      46.863  27.551  64.739  1.00 79.87           C  
ATOM    758  O   ARG    94      47.994  27.826  64.356  1.00 80.34           O  
ATOM    759  CB  ARG    94      46.404  25.546  63.289  1.00 79.45           C  
ATOM    760  CG  ARG    94      47.917  25.471  63.148  1.00 80.34           C  
ATOM    761  CD  ARG    94      48.417  24.130  62.626  1.00 80.98           C  
ATOM    762  NE  ARG    94      48.116  23.009  63.522  1.00 83.82           N  
ATOM    763  CZ  ARG    94      48.738  22.766  64.678  1.00 84.40           C  
ATOM    764  NH1 ARG    94      49.699  23.581  65.130  1.00 83.20           N  
ATOM    765  NH2 ARG    94      48.384  21.703  65.397  1.00 83.66           N  
ATOM    766  N   PHE    95      46.456  27.734  65.994  1.00 80.07           N  
ATOM    767  CA  PHE    95      47.285  28.366  67.031  1.00 80.20           C  
ATOM    768  C   PHE    95      48.290  27.422  67.702  1.00 80.50           C  
ATOM    769  O   PHE    95      47.963  26.281  68.021  1.00 80.42           O  
ATOM    770  CB  PHE    95      46.379  29.004  68.083  1.00 80.47           C  
ATOM    771  CG  PHE    95      45.260  29.821  67.488  1.00 80.99           C  
ATOM    772  CD1 PHE    95      45.473  31.141  67.111  1.00 81.79           C  
ATOM    773  CD2 PHE    95      44.012  29.254  67.261  1.00 80.65           C  
ATOM    774  CE1 PHE    95      44.448  31.894  66.533  1.00 83.00           C  
ATOM    775  CE2 PHE    95      42.980  29.995  66.685  1.00 82.25           C  
ATOM    776  CZ  PHE    95      43.192  31.318  66.327  1.00 82.26           C  
ATOM    777  N   GLU    96      49.522  27.882  67.905  1.00 80.58           N  
ATOM    778  CA  GLU    96      50.494  27.020  68.550  1.00 81.30           C  
ATOM    779  C   GLU    96      50.231  26.970  70.046  1.00 80.62           C  
ATOM    780  O   GLU    96      50.088  28.001  70.710  1.00 80.58           O  
ATOM    781  CB  GLU    96      51.942  27.422  68.240  1.00 82.00           C  
ATOM    782  CG  GLU    96      52.438  27.100  66.785  1.00 85.70           C  
ATOM    783  CD  GLU    96      52.380  25.603  66.391  1.00 88.37           C  
ATOM    784  OE1 GLU    96      53.160  24.794  66.957  1.00 87.64           O  
ATOM    785  OE2 GLU    96      51.555  25.257  65.500  1.00 89.69           O  
ATOM    786  N   VAL    97      50.152  25.751  70.559  1.00 80.00           N  
ATOM    787  CA  VAL    97      49.779  25.512  71.943  1.00 79.52           C  
ATOM    788  C   VAL    97      50.508  26.506  72.853  1.00 79.00           C  
ATOM    789  O   VAL    97      49.884  27.239  73.624  1.00 79.10           O  
ATOM    790  CB  VAL    97      50.003  24.009  72.319  1.00 79.44           C  
ATOM    791  CG1 VAL    97      51.460  23.558  72.020  1.00 81.14           C  
ATOM    792  CG2 VAL    97      49.593  23.714  73.766  1.00 78.94           C  
ATOM    793  N   ASP    98      51.826  26.549  72.704  1.00 78.35           N  
ATOM    794  CA  ASP    98      52.696  27.550  73.308  1.00 77.56           C  
ATOM    795  C   ASP    98      52.109  28.969  73.485  1.00 76.70           C  
ATOM    796  O   ASP    98      51.942  29.435  74.613  1.00 76.47           O  
ATOM    797  CB  ASP    98      53.966  27.631  72.460  0.60 77.75           C  
ATOM    798  CG  ASP    98      55.156  28.053  73.258  0.60 78.16           C  
ATOM    799  OD1 ASP    98      55.026  28.992  74.072  0.60 78.47           O  
ATOM    800  OD2 ASP    98      56.226  27.440  73.072  0.60 79.39           O  
ATOM    801  N   ASP    99      51.786  29.611  72.368  0.60 76.19           N  
ATOM    803  CA  ASP    99      51.334  30.997  72.340  0.60 75.94           C  
ATOM    805  C   ASP    99      49.880  31.178  72.794  0.60 75.52           C  
ATOM    807  O   ASP    99      49.511  32.196  73.385  0.60 75.43           O  
ATOM    809  CB  ASP    99      51.500  31.548  70.923  0.60 76.07           C  
ATOM    811  CG  ASP    99      52.906  31.364  70.386  0.60 76.52           C  
ATOM    813  OD1 ASP    99      53.090  31.409  69.148  0.60 77.25           O  
ATOM    815  OD2 ASP    99      53.830  31.168  71.201  0.60 77.63           O  
ATOM    817  N   MET   100      49.047  30.200  72.489  1.00 75.00           N  
ATOM    818  CA  MET   100      47.674  30.236  72.938  1.00 74.50           C  
ATOM    819  C   MET   100      47.674  30.109  74.478  1.00 73.72           C  
ATOM    820  O   MET   100      47.061  30.907  75.168  1.00 73.25           O  
ATOM    821  CB  MET   100      46.866  29.138  72.262  1.00 74.34           C  
ATOM    822  CG  MET   100      45.425  29.075  72.717  1.00 75.88           C  
ATOM    823  SD  MET   100      44.372  30.641  72.207  0.85 76.98          SE  
ATOM    824  CE  MET   100      44.151  31.437  73.926  1.00 75.18           C  
ATOM    825  N   MET   101      48.427  29.135  74.992  1.00 72.91           N  
ATOM    826  CA  MET   101      48.593  28.908  76.424  1.00 72.12           C  
ATOM    827  C   MET   101      49.163  30.128  77.135  1.00 71.11           C  
ATOM    828  O   MET   101      48.882  30.349  78.288  1.00 70.87           O  
ATOM    829  CB  MET   101      49.515  27.710  76.631  1.00 72.60           C  
ATOM    830  CG  MET   101      49.809  27.395  78.061  1.00 73.93           C  
ATOM    831  SD  MET   101      48.149  26.866  78.967  0.60 77.64          SE  
ATOM    832  CE  MET   101      48.324  24.912  78.642  1.00 75.16           C  
ATOM    833  N   ALA   102      49.978  30.897  76.422  1.00 70.44           N  
ATOM    834  CA  ALA   102      50.494  32.171  76.882  1.00 69.35           C  
ATOM    835  C   ALA   102      49.409  33.231  76.908  1.00 68.45           C  
ATOM    836  O   ALA   102      49.242  33.887  77.920  1.00 68.65           O  
ATOM    837  CB  ALA   102      51.652  32.613  76.008  1.00 69.18           C  
ATOM    838  N   ARG   103      48.670  33.396  75.810  1.00 68.30           N  
ATOM    839  CA  ARG   103      47.555  34.377  75.743  1.00 67.14           C  
ATOM    840  C   ARG   103      46.513  34.122  76.825  1.00 65.74           C  
ATOM    841  O   ARG   103      46.047  35.029  77.483  1.00 65.11           O  
ATOM    842  CB  ARG   103      46.894  34.389  74.352  1.00 67.51           C  
ATOM    843  CG  ARG   103      45.843  35.526  74.092  1.00 69.99           C  
ATOM    844  CD  ARG   103      46.368  36.997  74.358  1.00 77.43           C  
ATOM    845  NE  ARG   103      46.236  37.886  73.177  1.00 81.71           N  
ATOM    846  CZ  ARG   103      45.219  38.730  72.955  1.00 85.14           C  
ATOM    847  NH1 ARG   103      44.228  38.831  73.838  1.00 87.71           N  
ATOM    848  NH2 ARG   103      45.170  39.478  71.844  1.00 85.06           N  
ATOM    849  N   ILE   104      46.155  32.866  77.003  1.00 65.17           N  
ATOM    850  CA  ILE   104      45.250  32.469  78.072  1.00 64.96           C  
ATOM    851  C   ILE   104      45.767  32.813  79.462  1.00 64.64           C  
ATOM    852  O   ILE   104      45.010  33.294  80.291  1.00 64.83           O  
ATOM    853  CB  ILE   104      44.872  30.974  77.981  1.00 64.89           C  
ATOM    854  CG1 ILE   104      43.935  30.769  76.796  1.00 66.45           C  
ATOM    855  CG2 ILE   104      44.174  30.506  79.264  1.00 64.73           C  
ATOM    856  CD1 ILE   104      43.932  29.348  76.238  1.00 70.32           C  
ATOM    857  N   ARG   105      47.046  32.581  79.719  0.60 64.58           N  
ATOM    859  CA  ARG   105      47.571  32.898  81.044  0.60 64.64           C  
ATOM    861  C   ARG   105      47.507  34.418  81.296  0.60 65.04           C  
ATOM    863  O   ARG   105      47.146  34.856  82.401  0.60 65.11           O  
ATOM    865  CB  ARG   105      48.959  32.268  81.268  0.60 64.15           C  
ATOM    867  CG  ARG   105      49.019  30.745  80.916  0.60 62.26           C  
ATOM    869  CD  ARG   105      49.908  29.930  81.861  0.60 59.20           C  
ATOM    871  NE  ARG   105      50.733  28.913  81.192  0.60 56.19           N  
ATOM    873  CZ  ARG   105      50.648  27.599  81.405  0.60 53.93           C  
ATOM    875  NH1 ARG   105      51.453  26.771  80.766  0.60 52.55           N  
ATOM    877  NH2 ARG   105      49.757  27.107  82.249  0.60 52.59           N  
ATOM    879  N   GLN   106      47.782  35.202  80.250  1.00 65.19           N  
ATOM    880  CA  GLN   106      47.661  36.674  80.283  1.00 66.44           C  
ATOM    881  C   GLN   106      46.219  37.148  80.563  1.00 66.11           C  
ATOM    882  O   GLN   106      45.987  38.039  81.370  1.00 65.91           O  
ATOM    883  CB  GLN   106      48.139  37.258  78.936  1.00 66.21           C  
ATOM    884  CG  GLN   106      48.160  38.781  78.873  1.00 68.89           C  
ATOM    885  CD  GLN   106      48.161  39.330  77.451  1.00 69.30           C  
ATOM    886  OE1 GLN   106      47.230  39.099  76.691  1.00 78.30           O  
ATOM    887  NE2 GLN   106      49.198  40.075  77.094  1.00 73.54           N  
ATOM    888  N   VAL   107      45.251  36.538  79.892  1.00 66.18           N  
ATOM    889  CA  VAL   107      43.862  36.931  80.045  1.00 66.70           C  
ATOM    890  C   VAL   107      43.368  36.703  81.494  1.00 67.44           C  
ATOM    891  O   VAL   107      42.708  37.561  82.099  1.00 66.39           O  
ATOM    892  CB  VAL   107      43.007  36.198  79.002  1.00 66.50           C  
ATOM    893  CG1 VAL   107      41.573  35.994  79.503  1.00 66.31           C  
ATOM    894  CG2 VAL   107      43.053  36.959  77.686  1.00 64.13           C  
ATOM    895  N   ARG   108      43.711  35.531  82.025  1.00 68.65           N  
ATOM    896  CA  ARG   108      43.437  35.162  83.410  1.00 69.82           C  
ATOM    897  C   ARG   108      44.035  36.222  84.356  1.00 71.05           C  
ATOM    898  O   ARG   108      43.384  36.638  85.340  1.00 70.77           O  
ATOM    899  CB  ARG   108      43.991  33.751  83.721  1.00 69.62           C  
ATOM    900  CG  ARG   108      43.597  33.210  85.119  1.00 69.62           C  
ATOM    901  CD  ARG   108      44.401  31.981  85.533  1.00 68.90           C  
ATOM    902  NE  ARG   108      44.109  30.834  84.678  1.00 67.11           N  
ATOM    903  CZ  ARG   108      45.010  29.969  84.222  1.00 65.78           C  
ATOM    904  NH1 ARG   108      44.619  28.965  83.441  1.00 62.37           N  
ATOM    905  NH2 ARG   108      46.297  30.107  84.545  1.00 67.13           N  
ATOM    906  N   GLU   109      45.259  36.661  84.034  1.00 72.13           N  
ATOM    907  CA  GLU   109      45.939  37.716  84.794  1.00 73.60           C  
ATOM    908  C   GLU   109      45.204  39.061  84.741  1.00 73.35           C  
ATOM    909  O   GLU   109      44.693  39.530  85.763  1.00 73.58           O  
ATOM    910  CB  GLU   109      47.385  37.880  84.320  1.00 73.60           C  
ATOM    911  CG  GLU   109      48.345  38.293  85.440  1.00 74.84           C  
ATOM    912  CD  GLU   109      49.683  38.819  84.920  1.00 75.40           C  
ATOM    913  OE1 GLU   109      49.694  39.511  83.867  1.00 78.84           O  
ATOM    914  OE2 GLU   109      50.721  38.555  85.572  1.00 75.88           O  
ATOM    915  N   GLN   110      45.117  39.652  83.547  1.00 73.36           N  
ATOM    916  CA  GLN   110      44.529  40.995  83.375  1.00 72.79           C  
ATOM    917  C   GLN   110      43.013  41.152  83.647  1.00 71.55           C  
ATOM    918  O   GLN   110      42.564  42.291  83.828  1.00 71.83           O  
ATOM    919  CB  GLN   110      44.899  41.578  82.006  1.00 72.97           C  
ATOM    920  CG  GLN   110      44.154  40.900  80.880  1.00 74.32           C  
ATOM    921  CD  GLN   110      44.831  41.080  79.538  1.00 75.81           C  
ATOM    922  OE1 GLN   110      46.072  41.145  79.455  1.00 74.48           O  
ATOM    923  NE2 GLN   110      44.016  41.145  78.467  1.00 73.00           N  
ATOM    924  N   GLY   111      42.251  40.048  83.693  1.00 70.23           N  
ATOM    925  CA  GLY   111      40.821  40.054  84.127  1.00 68.74           C  
ATOM    926  C   GLY   111      39.765  40.105  83.019  1.00 68.41           C  
ATOM    927  O   GLY   111      38.535  40.009  83.267  1.00 67.72           O  
ATOM    928  N   TYR   112      40.237  40.245  81.785  1.00 67.60           N  
ATOM    929  CA  TYR   112      39.367  40.447  80.621  1.00 67.38           C  
ATOM    930  C   TYR   112      40.115  40.034  79.362  1.00 66.21           C  
ATOM    931  O   TYR   112      41.348  39.829  79.414  1.00 66.31           O  
ATOM    932  CB  TYR   112      39.012  41.939  80.477  1.00 68.34           C  
ATOM    933  CG  TYR   112      40.254  42.789  80.427  1.00 70.12           C  
ATOM    934  CD1 TYR   112      40.904  43.058  79.212  1.00 72.48           C  
ATOM    935  CD2 TYR   112      40.811  43.296  81.603  1.00 70.44           C  
ATOM    936  CE1 TYR   112      42.092  43.844  79.176  1.00 72.21           C  
ATOM    937  CE2 TYR   112      41.962  44.071  81.575  1.00 72.48           C  
ATOM    938  CZ  TYR   112      42.597  44.334  80.362  1.00 72.07           C  
ATOM    939  OH  TYR   112      43.740  45.103  80.381  1.00 73.81           O  
ATOM    940  N   ALA   113      39.396  39.973  78.232  1.00 63.62           N  
ATOM    941  CA  ALA   113      40.045  39.704  76.957  1.00 62.19           C  
ATOM    942  C   ALA   113      39.529  40.638  75.861  1.00 61.50           C  
ATOM    943  O   ALA   113      38.406  41.113  75.914  1.00 62.63           O  
ATOM    944  CB  ALA   113      39.874  38.221  76.557  1.00 61.70           C  
ATOM    945  N   SER   114      40.363  40.940  74.895  1.00 59.84           N  
ATOM    946  CA  SER   114      39.903  41.583  73.708  1.00 59.77           C  
ATOM    947  C   SER   114      40.680  41.049  72.491  1.00 59.17           C  
ATOM    948  O   SER   114      41.711  40.411  72.631  1.00 58.24           O  
ATOM    949  CB  SER   114      40.004  43.083  73.840  1.00 59.57           C  
ATOM    950  OG  SER   114      41.356  43.445  74.060  1.00 62.96           O  
ATOM    951  N   ALA   115      40.152  41.309  71.306  1.00 59.12           N  
ATOM    952  CA  ALA   115      40.660  40.719  70.093  1.00 59.65           C  
ATOM    953  C   ALA   115      40.253  41.616  68.966  1.00 60.51           C  
ATOM    954  O   ALA   115      39.161  42.214  68.986  1.00 60.26           O  
ATOM    955  CB  ALA   115      40.033  39.339  69.879  1.00 59.03           C  
ATOM    956  N   GLU   116      41.131  41.683  67.979  1.00 61.40           N  
ATOM    957  CA  GLU   116      40.941  42.411  66.748  1.00 62.48           C  
ATOM    958  C   GLU   116      40.932  41.386  65.627  1.00 61.94           C  
ATOM    959  O   GLU   116      41.831  40.534  65.562  1.00 61.71           O  
ATOM    960  CB  GLU   116      42.178  43.242  66.470  1.00 62.91           C  
ATOM    961  CG  GLU   116      42.362  44.501  67.253  1.00 64.87           C  
ATOM    962  CD  GLU   116      43.608  45.273  66.759  1.00 66.94           C  
ATOM    963  OE1 GLU   116      44.407  44.722  65.917  1.00 68.23           O  
ATOM    964  OE2 GLU   116      43.771  46.437  67.224  1.00 72.76           O  
ATOM    965  N   HIS   117      39.970  41.495  64.716  1.00 60.74           N  
ATOM    966  CA  HIS   117      39.988  40.687  63.512  1.00 60.71           C  
ATOM    967  C   HIS   117      39.903  39.218  63.820  1.00 60.41           C  
ATOM    968  O   HIS   117      40.269  38.431  62.958  1.00 60.05           O  
ATOM    969  CB  HIS   117      41.242  40.943  62.639  1.00 60.33           C  
ATOM    970  CG  HIS   117      41.425  42.375  62.226  1.00 62.23           C  
ATOM    971  ND1 HIS   117      40.464  43.092  61.535  1.00 61.62           N  
ATOM    972  CD2 HIS   117      42.476  43.214  62.375  1.00 62.71           C  
ATOM    973  CE1 HIS   117      40.911  44.310  61.292  1.00 62.55           C  
ATOM    974  NE2 HIS   117      42.131  44.410  61.787  1.00 63.71           N  
ATOM    975  N   ILE   118      39.426  38.847  65.023  1.00 60.21           N  
ATOM    976  CA  ILE   118      39.269  37.410  65.396  1.00 59.96           C  
ATOM    977  C   ILE   118      37.957  37.150  66.138  1.00 59.73           C  
ATOM    978  O   ILE   118      37.735  37.670  67.213  1.00 59.45           O  
ATOM    979  CB  ILE   118      40.476  36.841  66.252  1.00 60.60           C  
ATOM    980  CG1 ILE   118      41.818  37.029  65.538  1.00 59.99           C  
ATOM    981  CG2 ILE   118      40.294  35.302  66.526  1.00 60.37           C  
ATOM    982  CD1 ILE   118      43.051  36.832  66.477  1.00 59.96           C  
ATOM    983  N   PRO   119      37.076  36.328  65.576  1.00 59.63           N  
ATOM    984  CA  PRO   119      37.199  35.472  64.393  1.00 60.42           C  
ATOM    985  C   PRO   119      37.065  36.229  63.055  1.00 61.73           C  
ATOM    986  O   PRO   119      37.340  35.635  62.013  1.00 62.71           O  
ATOM    987  CB  PRO   119      36.018  34.497  64.547  1.00 59.89           C  
ATOM    988  CG  PRO   119      34.937  35.379  65.254  1.00 58.78           C  
ATOM    989  CD  PRO   119      35.720  36.306  66.159  1.00 59.32           C  
ATOM    990  N   PHE   120      36.657  37.504  63.051  1.00 61.12           N  
ATOM    991  CA  PHE   120      36.338  38.119  61.762  1.00 61.12           C  
ATOM    992  C   PHE   120      37.054  39.400  61.460  1.00 59.48           C  
ATOM    993  O   PHE   120      37.082  40.301  62.261  1.00 58.42           O  
ATOM    994  CB  PHE   120      34.828  38.341  61.622  1.00 62.74           C  
ATOM    995  CG  PHE   120      34.035  37.086  61.735  1.00 64.36           C  
ATOM    996  CD1 PHE   120      34.295  36.006  60.866  1.00 70.01           C  
ATOM    997  CD2 PHE   120      33.064  36.952  62.726  1.00 65.69           C  
ATOM    998  CE1 PHE   120      33.561  34.780  60.953  1.00 69.09           C  
ATOM    999  CE2 PHE   120      32.304  35.779  62.819  1.00 66.11           C  
ATOM   1000  CZ  PHE   120      32.553  34.681  61.937  1.00 66.98           C  
ATOM   1001  N   VAL   121      37.599  39.469  60.256  1.00 58.64           N  
ATOM   1002  CA  VAL   121      38.232  40.683  59.767  1.00 58.37           C  
ATOM   1003  C   VAL   121      37.274  41.873  59.847  1.00 56.99           C  
ATOM   1004  O   VAL   121      36.136  41.809  59.367  1.00 55.51           O  
ATOM   1005  CB  VAL   121      38.725  40.438  58.336  1.00 59.00           C  
ATOM   1006  CG1 VAL   121      39.244  41.673  57.723  1.00 59.59           C  
ATOM   1007  CG2 VAL   121      39.812  39.386  58.387  1.00 60.30           C  
ATOM   1008  N   GLY   122      37.746  42.924  60.514  1.00 56.40           N  
ATOM   1009  CA  GLY   122      37.050  44.197  60.644  1.00 55.08           C  
ATOM   1010  C   GLY   122      36.289  44.261  61.944  1.00 55.39           C  
ATOM   1011  O   GLY   122      35.644  45.275  62.246  1.00 54.99           O  
ATOM   1012  N   GLY   123      36.351  43.178  62.720  1.00 55.30           N  
ATOM   1013  CA  GLY   123      35.632  43.117  63.990  1.00 56.21           C  
ATOM   1014  C   GLY   123      36.539  43.368  65.186  1.00 57.60           C  
ATOM   1015  O   GLY   123      37.764  43.195  65.105  1.00 58.87           O  
ATOM   1016  N   GLY   124      35.937  43.769  66.299  1.00 57.60           N  
ATOM   1017  CA  GLY   124      36.615  43.964  67.568  1.00 56.76           C  
ATOM   1018  C   GLY   124      35.654  43.511  68.645  1.00 57.59           C  
ATOM   1019  O   GLY   124      34.438  43.674  68.502  1.00 58.68           O  
ATOM   1020  N   THR   125      36.195  42.917  69.702  1.00 57.57           N  
ATOM   1021  CA  THR   125      35.421  42.333  70.759  1.00 58.77           C  
ATOM   1022  C   THR   125      36.159  42.557  72.087  1.00 59.95           C  
ATOM   1023  O   THR   125      37.404  42.665  72.108  1.00 61.11           O  
ATOM   1024  CB  THR   125      35.226  40.815  70.555  1.00 58.50           C  
ATOM   1025  OG1 THR   125      36.504  40.198  70.631  1.00 60.10           O  
ATOM   1026  CG2 THR   125      34.581  40.477  69.179  1.00 57.20           C  
ATOM   1027  N   ILE   126      35.392  42.648  73.174  1.00 59.74           N  
ATOM   1028  CA  ILE   126      35.925  42.817  74.500  1.00 60.47           C  
ATOM   1029  C   ILE   126      35.014  42.026  75.389  1.00 60.96           C  
ATOM   1030  O   ILE   126      33.801  42.116  75.250  1.00 60.86           O  
ATOM   1031  CB  ILE   126      35.861  44.292  74.994  1.00 60.70           C  
ATOM   1032  CG1 ILE   126      36.457  45.265  73.965  1.00 60.18           C  
ATOM   1033  CG2 ILE   126      36.660  44.428  76.323  1.00 61.21           C  
ATOM   1034  CD1 ILE   126      36.173  46.739  74.252  1.00 60.30           C  
ATOM   1035  N   CYS   127      35.571  41.266  76.320  1.00 61.17           N  
ATOM   1036  CA  CYS   127      34.720  40.550  77.246  1.00 61.73           C  
ATOM   1037  C   CYS   127      35.336  40.353  78.631  1.00 60.76           C  
ATOM   1038  O   CYS   127      36.552  40.554  78.825  1.00 61.34           O  
ATOM   1039  CB  CYS   127      34.283  39.220  76.645  1.00 62.64           C  
ATOM   1040  SG  CYS   127      35.571  38.057  76.611  1.00 69.38           S  
ATOM   1041  N   VAL   128      34.479  39.997  79.585  1.00 58.72           N  
ATOM   1042  CA  VAL   128      34.880  39.777  80.954  1.00 57.06           C  
ATOM   1043  C   VAL   128      34.217  38.503  81.459  1.00 57.11           C  
ATOM   1044  O   VAL   128      33.236  38.000  80.900  1.00 56.65           O  
ATOM   1045  CB  VAL   128      34.464  40.968  81.850  1.00 57.55           C  
ATOM   1046  CG1 VAL   128      35.306  42.205  81.547  1.00 55.59           C  
ATOM   1047  CG2 VAL   128      32.963  41.291  81.663  1.00 56.91           C  
ATOM   1048  N   LEU   129      34.762  37.965  82.520  1.00 57.32           N  
ATOM   1049  CA  LEU   129      34.166  36.828  83.172  1.00 58.26           C  
ATOM   1050  C   LEU   129      33.140  37.298  84.224  1.00 58.72           C  
ATOM   1051  O   LEU   129      33.452  38.103  85.104  1.00 58.69           O  
ATOM   1052  CB  LEU   129      35.297  36.031  83.830  1.00 58.55           C  
ATOM   1053  CG  LEU   129      35.015  34.628  84.359  1.00 60.42           C  
ATOM   1054  CD1 LEU   129      34.662  33.655  83.226  1.00 57.69           C  
ATOM   1055  CD2 LEU   129      36.257  34.149  85.121  1.00 58.78           C  
ATOM   1056  N   LEU   130      31.924  36.779  84.156  1.00 59.63           N  
ATOM   1057  CA  LEU   130      30.970  37.026  85.231  1.00 61.00           C  
ATOM   1058  C   LEU   130      31.373  36.302  86.514  1.00 62.52           C  
ATOM   1059  O   LEU   130      32.068  35.286  86.451  1.00 63.24           O  
ATOM   1060  CB  LEU   130      29.555  36.661  84.806  1.00 60.61           C  
ATOM   1061  CG  LEU   130      29.064  37.484  83.618  1.00 58.70           C  
ATOM   1062  CD1 LEU   130      27.610  37.233  83.478  1.00 57.62           C  
ATOM   1063  CD2 LEU   130      29.312  38.951  83.901  1.00 58.50           C  
ATOM   1064  N   PRO   131      30.957  36.833  87.684  1.00 63.60           N  
ATOM   1065  CA  PRO   131      31.330  36.289  88.998  1.00 64.67           C  
ATOM   1066  C   PRO   131      30.677  34.948  89.331  1.00 65.20           C  
ATOM   1067  O   PRO   131      31.135  34.235  90.229  1.00 65.42           O  
ATOM   1068  CB  PRO   131      30.763  37.326  89.982  1.00 64.22           C  
ATOM   1069  CG  PRO   131      30.370  38.477  89.184  1.00 63.35           C  
ATOM   1070  CD  PRO   131      30.083  38.008  87.828  1.00 63.62           C  
ATOM   1071  N   MET   132      29.571  34.647  88.672  1.00 64.99           N  
ATOM   1072  CA  MET   132      28.877  33.427  88.993  1.00 65.15           C  
ATOM   1073  C   MET   132      28.979  32.403  87.850  1.00 64.14           C  
ATOM   1074  O   MET   132      29.414  32.717  86.758  1.00 64.03           O  
ATOM   1075  CB  MET   132      27.415  33.726  89.407  1.00 65.70           C  
ATOM   1076  CG  MET   132      26.390  33.794  88.263  1.00 67.04           C  
ATOM   1077  SD  MET   132      26.750  35.218  87.004  0.45 71.81          SE  
ATOM   1078  CE  MET   132      26.107  36.639  88.129  1.00 67.04           C  
ATOM   1079  N   THR   133      28.592  31.168  88.142  1.00 63.08           N  
ATOM   1080  CA  THR   133      28.539  30.109  87.173  1.00 61.87           C  
ATOM   1081  C   THR   133      27.079  29.821  86.836  1.00 62.29           C  
ATOM   1082  O   THR   133      26.172  30.146  87.590  1.00 62.69           O  
ATOM   1083  CB  THR   133      29.236  28.832  87.733  1.00 62.07           C  
ATOM   1084  OG1 THR   133      28.599  28.425  88.955  1.00 59.30           O  
ATOM   1085  CG2 THR   133      30.761  29.080  87.987  1.00 60.89           C  
ATOM   1086  N   ILE   134      26.850  29.216  85.690  1.00 63.11           N  
ATOM   1087  CA  ILE   134      25.523  28.799  85.289  1.00 64.44           C  
ATOM   1088  C   ILE   134      25.672  27.330  84.911  1.00 65.69           C  
ATOM   1089  O   ILE   134      26.460  26.969  84.044  1.00 66.09           O  
ATOM   1090  CB  ILE   134      24.963  29.704  84.146  1.00 64.14           C  
ATOM   1091  CG1 ILE   134      24.566  31.066  84.723  1.00 63.96           C  
ATOM   1092  CG2 ILE   134      23.773  29.071  83.433  1.00 64.15           C  
ATOM   1093  CD1 ILE   134      24.175  32.136  83.679  1.00 64.32           C  
ATOM   1094  N   GLN   135      24.961  26.482  85.641  1.00 67.44           N  
ATOM   1095  CA  GLN   135      25.018  25.030  85.464  1.00 68.27           C  
ATOM   1096  C   GLN   135      26.423  24.443  85.593  1.00 67.51           C  
ATOM   1097  O   GLN   135      26.840  23.603  84.787  1.00 67.63           O  
ATOM   1098  CB  GLN   135      24.338  24.630  84.142  1.00 69.11           C  
ATOM   1099  CG  GLN   135      22.813  24.426  84.322  1.00 72.21           C  
ATOM   1100  CD  GLN   135      22.075  24.392  83.000  1.00 75.06           C  
ATOM   1101  OE1 GLN   135      22.529  24.981  82.028  1.00 73.98           O  
ATOM   1102  NE2 GLN   135      20.923  23.708  82.961  1.00 76.23           N  
ATOM   1103  N   GLY   136      27.140  24.878  86.627  1.00 66.64           N  
ATOM   1104  CA  GLY   136      28.537  24.478  86.814  1.00 65.45           C  
ATOM   1105  C   GLY   136      29.529  25.084  85.834  1.00 64.78           C  
ATOM   1106  O   GLY   136      30.703  25.058  86.102  1.00 63.55           O  
ATOM   1107  N   GLN   137      29.053  25.633  84.708  1.00 65.31           N  
ATOM   1108  CA  GLN   137      29.912  26.263  83.691  1.00 65.72           C  
ATOM   1109  C   GLN   137      30.233  27.713  84.016  1.00 65.55           C  
ATOM   1110  O   GLN   137      29.358  28.463  84.439  1.00 65.69           O  
ATOM   1111  CB  GLN   137      29.245  26.244  82.302  1.00 66.04           C  
ATOM   1112  CG  GLN   137      29.320  24.909  81.507  1.00 68.78           C  
ATOM   1113  CD  GLN   137      30.440  23.996  82.042  1.00 73.24           C  
ATOM   1114  OE1 GLN   137      31.649  24.242  81.825  1.00 72.76           O  
ATOM   1115  NE2 GLN   137      30.031  22.931  82.759  1.00 73.95           N  
ATOM   1116  N   PRO   138      31.472  28.144  83.744  1.00 65.44           N  
ATOM   1117  CA  PRO   138      31.749  29.578  83.801  1.00 64.98           C  
ATOM   1118  C   PRO   138      31.014  30.351  82.669  1.00 64.36           C  
ATOM   1119  O   PRO   138      30.615  29.763  81.628  1.00 63.62           O  
ATOM   1120  CB  PRO   138      33.259  29.641  83.600  1.00 64.70           C  
ATOM   1121  CG  PRO   138      33.523  28.488  82.688  1.00 65.49           C  
ATOM   1122  CD  PRO   138      32.663  27.395  83.312  1.00 65.94           C  
ATOM   1123  N   VAL   139      30.836  31.652  82.906  1.00 63.46           N  
ATOM   1124  CA  VAL   139      30.024  32.527  82.076  1.00 63.27           C  
ATOM   1125  C   VAL   139      30.742  33.834  81.764  1.00 63.64           C  
ATOM   1126  O   VAL   139      31.472  34.407  82.580  1.00 63.82           O  
ATOM   1127  CB  VAL   139      28.685  32.877  82.751  1.00 63.26           C  
ATOM   1128  CG1 VAL   139      27.728  33.535  81.751  1.00 63.44           C  
ATOM   1129  CG2 VAL   139      28.037  31.626  83.319  1.00 63.48           C  
ATOM   1130  N   THR   140      30.473  34.346  80.581  1.00 63.49           N  
ATOM   1131  CA  THR   140      31.209  35.477  80.094  1.00 62.95           C  
ATOM   1132  C   THR   140      30.239  36.548  79.635  1.00 61.34           C  
ATOM   1133  O   THR   140      29.112  36.253  79.198  1.00 61.41           O  
ATOM   1134  CB  THR   140      32.197  34.962  78.979  1.00 64.09           C  
ATOM   1135  OG1 THR   140      33.315  35.835  78.864  1.00 68.35           O  
ATOM   1136  CG2 THR   140      31.527  34.750  77.625  1.00 61.92           C  
ATOM   1137  N   MET   141      30.651  37.795  79.749  1.00 59.52           N  
ATOM   1138  CA  MET   141      29.865  38.896  79.191  1.00 58.85           C  
ATOM   1139  C   MET   141      30.732  39.738  78.273  1.00 57.63           C  
ATOM   1140  O   MET   141      31.805  40.197  78.662  1.00 56.38           O  
ATOM   1141  CB  MET   141      29.254  39.781  80.295  1.00 58.22           C  
ATOM   1142  CG  MET   141      28.359  40.907  79.768  1.00 57.91           C  
ATOM   1143  SD  MET   141      27.439  41.893  81.189  0.70 63.01          SE  
ATOM   1144  CE  MET   141      29.033  42.290  82.338  1.00 57.79           C  
ATOM   1145  N   GLY   142      30.275  39.939  77.045  1.00 57.51           N  
ATOM   1146  CA  GLY   142      31.113  40.646  76.106  1.00 57.02           C  
ATOM   1147  C   GLY   142      30.376  41.500  75.131  1.00 57.66           C  
ATOM   1148  O   GLY   142      29.155  41.396  75.004  1.00 56.64           O  
ATOM   1149  N   LEU   143      31.124  42.363  74.442  1.00 58.30           N  
ATOM   1150  CA  LEU   143      30.546  43.151  73.380  1.00 58.79           C  
ATOM   1151  C   LEU   143      31.353  43.070  72.088  1.00 58.83           C  
ATOM   1152  O   LEU   143      32.559  42.905  72.119  1.00 58.80           O  
ATOM   1153  CB  LEU   143      30.325  44.594  73.858  1.00 58.35           C  
ATOM   1154  CG  LEU   143      31.521  45.419  74.287  1.00 60.18           C  
ATOM   1155  CD1 LEU   143      32.247  46.006  73.071  1.00 60.49           C  
ATOM   1156  CD2 LEU   143      31.061  46.519  75.206  1.00 59.31           C  
ATOM   1157  N   GLY   144      30.678  43.246  70.953  1.00 58.47           N  
ATOM   1158  CA  GLY   144      31.316  43.101  69.659  1.00 58.24           C  
ATOM   1159  C   GLY   144      30.811  44.138  68.683  1.00 57.94           C  
ATOM   1160  O   GLY   144      29.643  44.516  68.749  1.00 59.01           O  
ATOM   1161  N   GLY   145      31.667  44.613  67.784  1.00 56.39           N  
ATOM   1162  CA  GLY   145      31.205  45.540  66.745  1.00 55.65           C  
ATOM   1163  C   GLY   145      32.309  45.840  65.731  1.00 56.12           C  
ATOM   1164  O   GLY   145      33.329  45.104  65.659  1.00 56.23           O  
ATOM   1165  N   ALA   146      32.124  46.900  64.951  1.00 55.07           N  
ATOM   1166  CA  ALA   146      33.100  47.244  63.899  1.00 55.82           C  
ATOM   1167  C   ALA   146      34.349  47.728  64.624  1.00 56.96           C  
ATOM   1168  O   ALA   146      34.230  48.504  65.612  1.00 57.85           O  
ATOM   1169  CB  ALA   146      32.536  48.330  62.929  1.00 52.69           C  
ATOM   1170  N   LEU   147      35.522  47.281  64.155  1.00 57.64           N  
ATOM   1171  CA  LEU   147      36.793  47.504  64.859  1.00 58.41           C  
ATOM   1172  C   LEU   147      37.061  48.955  65.249  1.00 60.34           C  
ATOM   1173  O   LEU   147      37.500  49.227  66.372  1.00 61.03           O  
ATOM   1174  CB  LEU   147      37.975  46.973  64.060  1.00 58.18           C  
ATOM   1175  CG  LEU   147      39.327  46.949  64.806  1.00 58.18           C  
ATOM   1176  CD1 LEU   147      39.244  46.312  66.199  1.00 57.00           C  
ATOM   1177  CD2 LEU   147      40.342  46.197  64.003  1.00 56.44           C  
ATOM   1178  N   ASP   148      36.797  49.886  64.340  1.00 60.98           N  
ATOM   1179  CA  ASP   148      37.114  51.252  64.594  1.00 62.40           C  
ATOM   1180  C   ASP   148      36.348  51.837  65.779  1.00 62.77           C  
ATOM   1181  O   ASP   148      36.896  52.619  66.589  1.00 62.98           O  
ATOM   1182  CB  ASP   148      36.866  52.052  63.329  1.00 63.29           C  
ATOM   1183  CG  ASP   148      37.999  51.865  62.274  1.00 68.49           C  
ATOM   1184  OD1 ASP   148      39.067  51.262  62.588  1.00 73.90           O  
ATOM   1185  OD2 ASP   148      37.832  52.324  61.114  1.00 73.21           O  
ATOM   1186  N   ARG   149      35.081  51.456  65.871  1.00 62.83           N  
ATOM   1187  CA  ARG   149      34.149  51.928  66.902  1.00 62.86           C  
ATOM   1188  C   ARG   149      34.607  51.373  68.242  1.00 62.96           C  
ATOM   1189  O   ARG   149      34.489  52.006  69.274  1.00 63.58           O  
ATOM   1190  CB  ARG   149      32.755  51.373  66.561  1.00 63.17           C  
ATOM   1191  CG  ARG   149      31.541  52.118  67.062  1.00 62.50           C  
ATOM   1192  CD  ARG   149      30.276  51.705  66.243  1.00 62.20           C  
ATOM   1193  NE  ARG   149      29.948  50.271  66.331  1.00 61.59           N  
ATOM   1194  CZ  ARG   149      29.562  49.509  65.295  1.00 61.95           C  
ATOM   1195  NH1 ARG   149      29.438  50.037  64.069  1.00 61.84           N  
ATOM   1196  NH2 ARG   149      29.264  48.218  65.478  1.00 58.63           N  
ATOM   1197  N   ILE   150      35.138  50.168  68.190  1.00 62.84           N  
ATOM   1198  CA  ILE   150      35.667  49.472  69.337  1.00 62.99           C  
ATOM   1199  C   ILE   150      36.976  50.090  69.814  1.00 63.06           C  
ATOM   1200  O   ILE   150      37.093  50.383  70.996  1.00 63.45           O  
ATOM   1201  CB  ILE   150      35.841  47.972  68.975  1.00 62.89           C  
ATOM   1202  CG1 ILE   150      34.475  47.346  68.679  1.00 61.48           C  
ATOM   1203  CG2 ILE   150      36.605  47.214  70.033  1.00 63.63           C  
ATOM   1204  CD1 ILE   150      33.474  47.515  69.720  1.00 59.06           C  
ATOM   1205  N   LYS   151      37.934  50.291  68.898  1.00 63.12           N  
ATOM   1206  CA  LYS   151      39.214  50.921  69.175  1.00 63.61           C  
ATOM   1207  C   LYS   151      39.027  52.307  69.740  1.00 63.88           C  
ATOM   1208  O   LYS   151      39.786  52.735  70.630  1.00 63.74           O  
ATOM   1209  CB  LYS   151      40.053  51.086  67.903  1.00 64.07           C  
ATOM   1210  CG  LYS   151      40.913  49.913  67.566  1.00 65.79           C  
ATOM   1211  CD  LYS   151      41.621  50.162  66.241  1.00 70.75           C  
ATOM   1212  CE  LYS   151      42.944  49.392  66.164  1.00 71.73           C  
ATOM   1213  NZ  LYS   151      43.159  48.731  64.846  1.00 72.52           N  
ATOM   1214  N   GLN   152      38.044  53.040  69.233  1.00 63.75           N  
ATOM   1215  CA  GLN   152      37.961  54.403  69.698  1.00 64.40           C  
ATOM   1216  C   GLN   152      37.173  54.524  71.007  1.00 64.24           C  
ATOM   1217  O   GLN   152      37.196  55.571  71.640  1.00 64.77           O  
ATOM   1218  CB  GLN   152      37.532  55.387  68.592  1.00 64.61           C  
ATOM   1219  CG  GLN   152      36.062  55.680  68.472  1.00 66.54           C  
ATOM   1220  CD  GLN   152      35.799  57.155  68.274  1.00 69.16           C  
ATOM   1221  OE1 GLN   152      34.813  57.540  67.658  1.00 72.32           O  
ATOM   1222  NE2 GLN   152      36.667  57.994  68.821  1.00 71.10           N  
ATOM   1223  N   ASN   153      36.519  53.453  71.429  1.00 63.29           N  
ATOM   1224  CA  ASN   153      35.780  53.492  72.678  1.00 63.53           C  
ATOM   1225  C   ASN   153      36.295  52.514  73.708  1.00 63.79           C  
ATOM   1226  O   ASN   153      35.654  52.292  74.736  1.00 63.26           O  
ATOM   1227  CB  ASN   153      34.302  53.230  72.425  1.00 63.39           C  
ATOM   1228  CG  ASN   153      33.615  54.397  71.765  1.00 62.56           C  
ATOM   1229  OD1 ASN   153      33.481  55.477  72.343  1.00 61.47           O  
ATOM   1230  ND2 ASN   153      33.163  54.181  70.555  1.00 62.37           N  
ATOM   1231  N   TYR   154      37.468  51.959  73.424  1.00 64.35           N  
ATOM   1232  CA  TYR   154      38.021  50.830  74.154  1.00 64.87           C  
ATOM   1233  C   TYR   154      37.977  51.032  75.673  1.00 64.22           C  
ATOM   1234  O   TYR   154      37.372  50.243  76.398  1.00 65.11           O  
ATOM   1235  CB  TYR   154      39.449  50.536  73.666  1.00 65.57           C  
ATOM   1236  CG  TYR   154      40.047  49.273  74.243  1.00 67.42           C  
ATOM   1237  CD1 TYR   154      39.799  48.022  73.644  1.00 69.26           C  
ATOM   1238  CD2 TYR   154      40.871  49.312  75.385  1.00 67.48           C  
ATOM   1239  CE1 TYR   154      40.352  46.840  74.157  1.00 68.18           C  
ATOM   1240  CE2 TYR   154      41.416  48.131  75.928  1.00 67.78           C  
ATOM   1241  CZ  TYR   154      41.145  46.898  75.308  1.00 69.01           C  
ATOM   1242  OH  TYR   154      41.682  45.711  75.808  1.00 70.29           O  
ATOM   1243  N   ASP   155      38.599  52.082  76.167  1.00 63.00           N  
ATOM   1244  CA  ASP   155      38.617  52.284  77.612  1.00 62.08           C  
ATOM   1245  C   ASP   155      37.215  52.364  78.228  1.00 60.93           C  
ATOM   1246  O   ASP   155      36.955  51.704  79.230  1.00 61.07           O  
ATOM   1247  CB  ASP   155      39.532  53.449  78.004  1.00 62.11           C  
ATOM   1248  CG  ASP   155      41.007  53.150  77.710  1.00 63.68           C  
ATOM   1249  OD1 ASP   155      41.404  51.968  77.752  1.00 63.75           O  
ATOM   1250  OD2 ASP   155      41.782  54.096  77.444  1.00 66.92           O  
ATOM   1251  N   ARG   156      36.325  53.142  77.616  0.50 60.35           N  
ATOM   1253  CA  ARG   156      34.951  53.271  78.098  0.50 59.56           C  
ATOM   1255  C   ARG   156      34.210  51.922  78.085  0.50 59.33           C  
ATOM   1257  O   ARG   156      33.566  51.552  79.074  0.50 59.30           O  
ATOM   1259  CB  ARG   156      34.190  54.348  77.303  0.50 59.35           C  
ATOM   1261  CG  ARG   156      32.709  54.514  77.647  0.50 58.27           C  
ATOM   1263  CD  ARG   156      32.496  54.857  79.123  0.50 58.16           C  
ATOM   1265  NE  ARG   156      31.118  55.273  79.401  0.50 57.16           N  
ATOM   1267  CZ  ARG   156      30.603  55.439  80.621  0.50 53.83           C  
ATOM   1269  NH1 ARG   156      31.333  55.214  81.705  0.50 50.49           N  
ATOM   1271  NH2 ARG   156      29.342  55.825  80.748  0.50 53.96           N  
ATOM   1273  N   TYR   157      34.314  51.183  76.983  1.00 59.03           N  
ATOM   1274  CA  TYR   157      33.636  49.896  76.875  1.00 58.63           C  
ATOM   1275  C   TYR   157      34.152  48.951  77.942  1.00 58.96           C  
ATOM   1276  O   TYR   157      33.389  48.380  78.700  1.00 59.40           O  
ATOM   1277  CB  TYR   157      33.846  49.301  75.510  1.00 59.28           C  
ATOM   1278  CG  TYR   157      33.035  49.900  74.385  1.00 59.29           C  
ATOM   1279  CD1 TYR   157      32.203  51.014  74.566  1.00 57.89           C  
ATOM   1280  CD2 TYR   157      33.158  49.380  73.112  1.00 58.11           C  
ATOM   1281  CE1 TYR   157      31.473  51.549  73.483  1.00 57.38           C  
ATOM   1282  CE2 TYR   157      32.439  49.890  72.052  1.00 58.83           C  
ATOM   1283  CZ  TYR   157      31.606  50.972  72.234  1.00 59.78           C  
ATOM   1284  OH  TYR   157      30.926  51.438  71.110  1.00 62.74           O  
ATOM   1285  N   LEU   158      35.464  48.824  78.045  1.00 59.50           N  
ATOM   1286  CA  LEU   158      36.044  47.981  79.075  1.00 59.86           C  
ATOM   1287  C   LEU   158      35.524  48.348  80.462  1.00 60.16           C  
ATOM   1288  O   LEU   158      35.113  47.467  81.220  1.00 60.78           O  
ATOM   1289  CB  LEU   158      37.562  48.099  79.054  1.00 59.80           C  
ATOM   1290  CG  LEU   158      38.262  47.129  80.008  1.00 60.44           C  
ATOM   1291  CD1 LEU   158      37.858  45.663  79.707  1.00 56.36           C  
ATOM   1292  CD2 LEU   158      39.766  47.334  79.948  1.00 59.85           C  
ATOM   1293  N   GLU   159      35.562  49.641  80.781  1.00 59.61           N  
ATOM   1294  CA  GLU   159      35.161  50.153  82.078  1.00 59.73           C  
ATOM   1295  C   GLU   159      33.742  49.670  82.381  1.00 59.78           C  
ATOM   1296  O   GLU   159      33.489  49.106  83.453  1.00 59.87           O  
ATOM   1297  CB  GLU   159      35.214  51.679  82.056  1.00 59.34           C  
ATOM   1298  CG  GLU   159      35.126  52.335  83.418  1.00 61.40           C  
ATOM   1299  CD  GLU   159      34.879  53.857  83.357  0.70 60.72           C  
ATOM   1300  OE1 GLU   159      34.127  54.327  82.466  0.70 63.42           O  
ATOM   1301  OE2 GLU   159      35.421  54.578  84.219  0.70 58.79           O  
ATOM   1302  N   LEU   160      32.818  49.861  81.427  1.00 59.37           N  
ATOM   1303  CA  LEU   160      31.439  49.367  81.576  1.00 58.56           C  
ATOM   1304  C   LEU   160      31.356  47.856  81.818  1.00 58.29           C  
ATOM   1305  O   LEU   160      30.541  47.413  82.616  1.00 59.51           O  
ATOM   1306  CB  LEU   160      30.567  49.737  80.369  1.00 57.95           C  
ATOM   1307  CG  LEU   160      30.347  51.218  80.103  1.00 58.23           C  
ATOM   1308  CD1 LEU   160      29.702  51.460  78.758  1.00 55.29           C  
ATOM   1309  CD2 LEU   160      29.536  51.881  81.245  1.00 56.98           C  
ATOM   1310  N   LEU   161      32.179  47.053  81.159  1.00 56.85           N  
ATOM   1311  CA  LEU   161      32.064  45.623  81.399  1.00 56.27           C  
ATOM   1312  C   LEU   161      32.491  45.340  82.827  1.00 56.63           C  
ATOM   1313  O   LEU   161      31.767  44.702  83.568  1.00 56.98           O  
ATOM   1314  CB  LEU   161      32.873  44.788  80.391  1.00 55.23           C  
ATOM   1315  CG  LEU   161      32.396  44.835  78.945  1.00 53.59           C  
ATOM   1316  CD1 LEU   161      33.466  44.302  77.999  1.00 52.49           C  
ATOM   1317  CD2 LEU   161      31.076  44.077  78.777  1.00 50.92           C  
ATOM   1318  N   LEU   162      33.655  45.845  83.211  1.00 57.06           N  
ATOM   1319  CA  LEU   162      34.197  45.628  84.544  1.00 58.48           C  
ATOM   1320  C   LEU   162      33.282  46.096  85.667  1.00 59.61           C  
ATOM   1321  O   LEU   162      33.264  45.501  86.759  1.00 60.23           O  
ATOM   1322  CB  LEU   162      35.574  46.304  84.700  1.00 58.31           C  
ATOM   1323  CG  LEU   162      36.705  45.644  83.895  1.00 57.84           C  
ATOM   1324  CD1 LEU   162      37.997  46.389  84.102  1.00 58.59           C  
ATOM   1325  CD2 LEU   162      36.901  44.204  84.266  1.00 56.12           C  
ATOM   1326  N   ASN   163      32.542  47.169  85.410  1.00 60.54           N  
ATOM   1327  CA  ASN   163      31.690  47.749  86.439  1.00 62.01           C  
ATOM   1328  C   ASN   163      30.436  46.879  86.527  1.00 62.08           C  
ATOM   1329  O   ASN   163      29.830  46.747  87.593  1.00 61.71           O  
ATOM   1330  CB  ASN   163      31.438  49.239  86.125  1.00 62.45           C  
ATOM   1331  CG  ASN   163      30.150  49.787  86.734  1.00 65.09           C  
ATOM   1332  OD1 ASN   163      30.050  50.022  87.957  1.00 67.46           O  
ATOM   1333  ND2 ASN   163      29.168  50.061  85.862  1.00 65.90           N  
ATOM   1334  N   GLY   164      30.102  46.245  85.397  1.00 62.36           N  
ATOM   1335  CA  GLY   164      28.971  45.325  85.296  1.00 62.20           C  
ATOM   1336  C   GLY   164      29.216  44.094  86.143  1.00 62.33           C  
ATOM   1337  O   GLY   164      28.300  43.587  86.792  1.00 62.50           O  
ATOM   1338  N   VAL   165      30.462  43.636  86.155  1.00 61.66           N  
ATOM   1339  CA  VAL   165      30.900  42.586  87.044  1.00 61.93           C  
ATOM   1340  C   VAL   165      30.706  42.951  88.532  1.00 62.82           C  
ATOM   1341  O   VAL   165      30.158  42.160  89.306  1.00 63.03           O  
ATOM   1342  CB  VAL   165      32.356  42.271  86.742  1.00 61.88           C  
ATOM   1343  CG1 VAL   165      33.024  41.473  87.860  1.00 60.99           C  
ATOM   1344  CG2 VAL   165      32.431  41.557  85.416  1.00 62.26           C  
ATOM   1345  N   GLN   166      31.142  44.149  88.935  1.00 63.51           N  
ATOM   1346  CA  GLN   166      30.938  44.637  90.305  1.00 63.09           C  
ATOM   1347  C   GLN   166      29.471  44.671  90.704  1.00 63.81           C  
ATOM   1348  O   GLN   166      29.126  44.278  91.796  1.00 63.65           O  
ATOM   1349  CB  GLN   166      31.571  46.010  90.467  1.00 62.92           C  
ATOM   1350  CG  GLN   166      33.101  45.969  90.431  1.00 62.83           C  
ATOM   1351  CD  GLN   166      33.682  44.920  91.377  1.00 62.74           C  
ATOM   1352  OE1 GLN   166      34.438  44.038  90.958  1.00 62.14           O  
ATOM   1353  NE2 GLN   166      33.307  44.994  92.653  1.00 62.51           N  
ATOM   1354  N   GLN   167      28.601  45.105  89.800  1.00 64.97           N  
ATOM   1355  CA  GLN   167      27.177  45.100  90.066  1.00 66.64           C  
ATOM   1356  C   GLN   167      26.588  43.715  90.317  1.00 67.34           C  
ATOM   1357  O   GLN   167      25.554  43.602  90.948  1.00 67.90           O  
ATOM   1358  CB  GLN   167      26.417  45.751  88.924  1.00 66.61           C  
ATOM   1359  CG  GLN   167      26.627  47.230  88.784  1.00 68.71           C  
ATOM   1360  CD  GLN   167      25.849  47.782  87.591  1.00 73.66           C  
ATOM   1361  OE1 GLN   167      24.753  48.315  87.760  1.00 78.39           O  
ATOM   1362  NE2 GLN   167      26.397  47.636  86.379  1.00 73.07           N  
ATOM   1363  N   LEU   168      27.233  42.661  89.833  1.00 68.72           N  
ATOM   1364  CA  LEU   168      26.708  41.304  90.031  1.00 69.87           C  
ATOM   1365  C   LEU   168      27.356  40.466  91.131  1.00 71.95           C  
ATOM   1366  O   LEU   168      26.886  39.378  91.409  1.00 72.69           O  
ATOM   1367  CB  LEU   168      26.700  40.502  88.726  1.00 68.81           C  
ATOM   1368  CG  LEU   168      25.923  41.090  87.550  1.00 66.67           C  
ATOM   1369  CD1 LEU   168      26.472  40.555  86.247  1.00 64.39           C  
ATOM   1370  CD2 LEU   168      24.420  40.871  87.662  1.00 64.21           C  
ATOM   1371  N   LYS   169      28.415  40.929  91.769  1.00 74.46           N  
ATOM   1372  CA  LYS   169      28.913  40.198  92.949  1.00 77.56           C  
ATOM   1373  C   LYS   169      27.846  39.801  94.033  1.00 78.83           C  
ATOM   1374  O   LYS   169      28.141  38.998  94.938  1.00 79.44           O  
ATOM   1375  CB  LYS   169      30.106  40.933  93.577  1.00 77.52           C  
ATOM   1376  CG  LYS   169      31.403  40.740  92.790  1.00 78.50           C  
ATOM   1377  CD  LYS   169      32.633  41.233  93.555  1.00 78.42           C  
ATOM   1378  CE  LYS   169      33.945  40.723  92.918  1.00 80.07           C  
ATOM   1379  NZ  LYS   169      35.138  40.771  93.875  1.00 79.99           N  
ATOM   1380  N   LYS   170      26.634  40.359  93.952  0.50 79.57           N  
ATOM   1382  CA  LYS   170      25.538  39.973  94.871  0.50 80.11           C  
ATOM   1384  C   LYS   170      24.549  38.959  94.268  0.50 80.39           C  
ATOM   1386  O   LYS   170      23.591  38.551  94.934  0.50 80.15           O  
ATOM   1388  CB  LYS   170      24.781  41.207  95.387  0.50 80.17           C  
ATOM   1390  CG  LYS   170      25.323  41.807  96.689  0.50 80.36           C  
ATOM   1392  CD  LYS   170      25.130  43.323  96.702  0.50 80.64           C  
ATOM   1394  CE  LYS   170      26.132  43.993  95.748  0.50 81.04           C  
ATOM   1396  NZ  LYS   170      25.532  45.067  94.897  0.50 80.73           N  
ATOM   1398  N   SER   171      24.786  38.562  93.015  1.00 80.70           N  
ATOM   1399  CA  SER   171      23.954  37.549  92.335  1.00 81.42           C  
ATOM   1400  C   SER   171      24.465  36.097  92.432  1.00 81.92           C  
ATOM   1401  O   SER   171      25.649  35.814  92.203  1.00 82.04           O  
ATOM   1402  CB  SER   171      23.759  37.931  90.868  1.00 81.24           C  
ATOM   1403  OG  SER   171      23.207  39.226  90.791  1.00 81.58           O  
ATOM   1404  N   ASP   172      23.545  35.186  92.744  1.00 82.34           N  
ATOM   1405  CA  ASP   172      23.861  33.770  92.943  1.00 82.68           C  
ATOM   1406  C   ASP   172      24.277  33.041  91.674  1.00 82.52           C  
ATOM   1407  O   ASP   172      23.873  33.417  90.568  1.00 82.88           O  
ATOM   1408  CB  ASP   172      22.657  33.062  93.559  1.00 82.79           C  
ATOM   1409  CG  ASP   172      22.438  33.458  95.000  1.00 84.58           C  
ATOM   1410  OD1 ASP   172      23.450  33.670  95.718  1.00 85.73           O  
ATOM   1411  OD2 ASP   172      21.258  33.563  95.417  1.00 86.61           O  
ATOM   1412  N   SER   173      25.096  32.003  91.843  1.00 82.19           N  
ATOM   1413  CA  SER   173      25.301  31.003  90.800  1.00 81.94           C  
ATOM   1414  C   SER   173      24.071  30.069  90.794  1.00 81.85           C  
ATOM   1415  O   SER   173      23.403  29.904  91.826  1.00 81.43           O  
ATOM   1416  CB  SER   173      26.592  30.199  91.050  1.00 81.85           C  
ATOM   1417  OG  SER   173      27.686  31.033  91.420  1.00 81.39           O  
ATOM   1418  N   PHE   174      23.758  29.470  89.644  1.00 81.81           N  
ATOM   1419  CA  PHE   174      22.619  28.543  89.587  1.00 81.63           C  
ATOM   1420  C   PHE   174      22.810  27.343  88.654  1.00 81.91           C  
ATOM   1421  O   PHE   174      23.540  27.415  87.661  1.00 81.37           O  
ATOM   1422  CB  PHE   174      21.292  29.292  89.303  1.00 81.50           C  
ATOM   1423  CG  PHE   174      21.210  29.948  87.929  1.00 79.93           C  
ATOM   1424  CD1 PHE   174      20.686  29.252  86.839  1.00 78.93           C  
ATOM   1425  CD2 PHE   174      21.613  31.277  87.746  1.00 78.89           C  
ATOM   1426  CE1 PHE   174      20.590  29.866  85.571  1.00 79.10           C  
ATOM   1427  CE2 PHE   174      21.518  31.899  86.488  1.00 78.38           C  
ATOM   1428  CZ  PHE   174      21.009  31.192  85.402  1.00 79.22           C  
ATOM   1429  N   HIS   175      22.150  26.239  89.005  1.00 82.82           N  
ATOM   1430  CA  HIS   175      22.171  25.024  88.184  1.00 83.73           C  
ATOM   1431  C   HIS   175      20.784  24.647  87.647  1.00 83.73           C  
ATOM   1432  O   HIS   175      20.188  23.692  88.128  1.00 83.82           O  
ATOM   1433  CB  HIS   175      22.792  23.846  88.952  1.00 83.68           C  
ATOM   1434  CG  HIS   175      23.642  22.961  88.092  1.00 85.07           C  
ATOM   1435  ND1 HIS   175      25.007  22.846  88.258  1.00 86.20           N  
ATOM   1436  CD2 HIS   175      23.328  22.187  87.023  1.00 86.70           C  
ATOM   1437  CE1 HIS   175      25.491  22.015  87.347  1.00 86.84           C  
ATOM   1438  NE2 HIS   175      24.495  21.607  86.580  1.00 86.55           N  
ATOM   1439  N   GLN   176      20.311  25.384  86.631  1.00 84.15           N  
ATOM   1440  CA  GLN   176      18.948  25.260  86.075  1.00 83.95           C  
ATOM   1441  C   GLN   176      18.909  25.379  84.553  1.00 84.23           C  
ATOM   1442  O   GLN   176      17.994  24.871  83.896  1.00 84.64           O  
ATOM   1443  CB  GLN   176      18.045  26.337  86.670  1.00 83.77           C  
ATOM   1444  CG  GLN   176      16.990  25.824  87.634  1.00 83.19           C  
ATOM   1445  CD  GLN   176      17.544  25.260  88.942  1.00 82.37           C  
ATOM   1446  OE1 GLN   176      18.293  25.931  89.668  1.00 82.87           O  
ATOM   1447  NE2 GLN   176      17.149  24.024  89.261  1.00 80.86           N  
END
