
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  245 ( 1992),  selected  245 , name 2uz0_D
# Molecule2: number of CA atoms  293 ( 2289),  selected  293 , name T0413.pdb
# PARAMETERS: 2uz0_D.T0413.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    -4_D      K       5           -
LGA    A    -3_D      P       6           -
LGA    X    -2_D      A       7           -
LGA    D    -1_D      D       8           -
LGA    -       -      L       9           -
LGA    -       -      T      10           -
LGA    -       -      N      11           -
LGA    -       -      A      12           -
LGA    -       -      D      13           -
LGA    -       -      R      14           -
LGA    -       -      I      15           -
LGA    -       -      A      16           -
LGA    -       -      L      17           -
LGA    -       -      E      18           -
LGA    -       -      L      19           -
LGA    -       -      G      20           -
LGA    -       -      H      21           -
LGA    P     0_D      A      22           #
LGA    A     1_D      G      23          2.960
LGA    V     2_D      R      24          2.599
LGA    X     3_D      N      25          3.128
LGA    K     4_D      A      26          1.777
LGA    I     5_D      I      27          0.583
LGA    E     6_D      P      28          1.278
LGA    Y     7_D      Y      29          2.259
LGA    Y     8_D      L      30          2.087
LGA    S     9_D      D      31          2.291
LGA    Q    10_D      D      32          1.301
LGA    -       -      D      33           -
LGA    V    11_D      R      34          2.622
LGA    L    12_D      N      35          2.106
LGA    D    13_D      A      36          1.510
LGA    -       -      D      37           -
LGA    X    14_D      R      38          3.506
LGA    E    15_D      P      39          3.495
LGA    W    16_D      F      40          2.237
LGA    G    17_D      T      41          0.792
LGA    V    18_D      L      42          0.563
LGA    N    19_D      N      43          1.938
LGA    V    20_D      T      44          2.327
LGA    L    21_D      Y      45          2.307
LGA    Y    22_D      R      46          2.618
LGA    P    23_D      P      47          3.908
LGA    D    24_D      Y      48          3.140
LGA    -       -      G      49           -
LGA    -       -      Y      50           -
LGA    -       -      T      51           -
LGA    E    34_D      P      52          3.942
LGA    D    35_D      D      53          3.293
LGA    I    36_D      R      54          3.171
LGA    P    37_D      P      55          2.374
LGA    V    38_D      V      56          1.875
LGA    L    39_D      V      57          1.653
LGA    Y    40_D      V      58          1.169
LGA    L    41_D      V      59          0.813
LGA    L    42_D      Q      60          0.773
LGA    H    43_D      H      61          0.725
LGA    G    44_D      G      62          0.705
LGA    X    45_D      V      63          0.916
LGA    S    46_D      L      64          1.844
LGA    G    47_D      R      65          1.596
LGA    N    48_D      N      66          3.782
LGA    H    49_D      G      67          2.559
LGA    N    50_D      A      68          1.574
LGA    S    51_D      D      69          3.094
LGA    W    52_D      Y      70          0.481
LGA    L    53_D      R      71          3.162
LGA    K    54_D      D      72          5.090
LGA    R    55_D      -       -           -
LGA    T    56_D      -       -           -
LGA    N    57_D      F      73          3.461
LGA    V    58_D      W      74          1.455
LGA    E    59_D      I      75          0.896
LGA    R    60_D      P      76          1.785
LGA    L    61_D      A      77          2.069
LGA    L    62_D      A      78          1.302
LGA    R    63_D      D      79          1.119
LGA    G    64_D      R      80          3.387
LGA    T    65_D      H      81          1.601
LGA    N    66_D      K      82          3.299
LGA    L    67_D      L      83          2.480
LGA    I    68_D      L      84          2.000
LGA    V    69_D      I      85          1.937
LGA    V    70_D      V      86          1.536
LGA    X    71_D      A      87          0.675
LGA    P    72_D      P      88          0.691
LGA    N    73_D      T      89          1.897
LGA    T    74_D      F      90          3.235
LGA    S    75_D      S      91          3.584
LGA    -       -      D      92           -
LGA    -       -      E      93           -
LGA    -       -      I      94           -
LGA    -       -      W      95           -
LGA    -       -      P      96           -
LGA    -       -      G      97           -
LGA    N    76_D      V      98          4.786
LGA    -       -      E      99           -
LGA    -       -      S     100           -
LGA    G    77_D      Y     101          1.966
LGA    W    78_D      N     102          1.174
LGA    Y    79_D      N     103          5.226
LGA    T    80_D      G     104          0.375
LGA    D    81_D      R     105          1.903
LGA    T    82_D      A     106          4.874
LGA    Q    83_D      F     107          4.394
LGA    -       -      T     108           -
LGA    Y    84_D      A     109          5.083
LGA    -       -      A     110           -
LGA    -       -      G     111           -
LGA    -       -      N     112           -
LGA    -       -      P     113           -
LGA    G    85_D      R     114           #
LGA    F    86_D      H     115           -
LGA    D    87_D      V     116           -
LGA    -       -      D     117           -
LGA    -       -      G     118           -
LGA    Y    88_D      W     119          4.951
LGA    Y    89_D      T     120          1.864
LGA    T    90_D      Y     121           #
LGA    A    91_D      A     122          5.120
LGA    L    92_D      L     123          1.837
LGA    A    93_D      V     124          3.571
LGA    E    94_D      A     125          4.128
LGA    E    95_D      R     126          2.830
LGA    L    96_D      V     127          2.188
LGA    P    97_D      L     128          2.443
LGA    Q    98_D      A     129          2.816
LGA    V    99_D      N     130          2.922
LGA    L   100_D      I     131          2.699
LGA    K   101_D      R     132          2.516
LGA    R   102_D      A     133          2.379
LGA    F   103_D      A     134          2.320
LGA    F   104_D      E     135          3.363
LGA    P   105_D      I     136           #
LGA    N   106_D      A     137          3.064
LGA    X   107_D      D     138          2.745
LGA    T   108_D      C     139          1.889
LGA    S   109_D      E     140          4.180
LGA    K   110_D      -       -           -
LGA    R   111_D      -       -           -
LGA    E   112_D      -       -           -
LGA    K   113_D      Q     141          1.561
LGA    T   114_D      V     142          1.985
LGA    F   115_D      Y     143          1.623
LGA    I   116_D      L     144          0.724
LGA    A   117_D      F     145          0.788
LGA    G   118_D      G     146          0.671
LGA    L   119_D      H     147          0.361
LGA    S   120_D      S     148          0.718
LGA    X   121_D      A     149          1.077
LGA    G   122_D      G     150          0.935
LGA    G   123_D      G     151          0.897
LGA    Y   124_D      Q     152          1.625
LGA    G   125_D      F     153          1.289
LGA    C   126_D      V     154          1.294
LGA    F   127_D      H     155          1.628
LGA    K   128_D      R     156          1.968
LGA    L   129_D      L     157          1.952
LGA    A   130_D      M     158          2.677
LGA    L   131_D      S     159          3.577
LGA    T   132_D      S     160          2.902
LGA    T   133_D      Q     161          2.754
LGA    -       -      P     162           -
LGA    N   134_D      H     163          1.398
LGA    R   135_D      A     164          2.406
LGA    -       -      P     165           -
LGA    F   136_D      F     166          1.817
LGA    S   137_D      H     167          2.760
LGA    H   138_D      A     168          1.412
LGA    A   139_D      V     169          1.001
LGA    A   140_D      T     170          0.681
LGA    S   141_D      A     171          1.580
LGA    F   142_D      A     172          1.431
LGA    S   143_D      N     173          0.944
LGA    G   144_D      P     174          1.391
LGA    A   145_D      G     175          2.572
LGA    L   146_D      W     176          3.817
LGA    S   147_D      Y     177          2.399
LGA    -       -      T     178           -
LGA    F   148_D      L     179           #
LGA    Q   149_D      P     180           -
LGA    N   150_D      T     181           -
LGA    G   159_D      F     182           -
LGA    S   160_D      -       -           -
LGA    P   161_D      -       -           -
LGA    A   162_D      -       -           -
LGA    Y   163_D      -       -           -
LGA    W   164_D      -       -           -
LGA    R   165_D      -       -           -
LGA    G   166_D      -       -           -
LGA    V   167_D      -       -           -
LGA    F   168_D      -       -           -
LGA    G   169_D      -       -           -
LGA    E   170_D      -       -           -
LGA    I   171_D      -       -           -
LGA    R   172_D      -       -           -
LGA    D   173_D      -       -           -
LGA    W   174_D      -       -           -
LGA    T   175_D      E     183           #
LGA    T   176_D      H     184          1.964
LGA    S   177_D      R     185          1.951
LGA    P   178_D      F     186          3.308
LGA    Y   179_D      P     187          2.626
LGA    S   180_D      E     188          4.142
LGA    L   181_D      G     189           #
LGA    E   182_D      -       -           -
LGA    S   183_D      -       -           -
LGA    L   184_D      L     190          5.026
LGA    A   185_D      D     191           -
LGA    -       -      G     192           -
LGA    -       -      V     193           -
LGA    -       -      G     194           -
LGA    -       -      L     195           -
LGA    K   186_D      T     196           #
LGA    -       -      E     197           -
LGA    -       -      D     198           -
LGA    K   187_D      H     199          0.685
LGA    -       -      L     200           -
LGA    -       -      A     201           -
LGA    S   188_D      R     202          1.584
LGA    D   189_D      L     203           #
LGA    K   190_D      L     204          4.367
LGA    K   191_D      A     205          4.533
LGA    T   192_D      Y     206          2.425
LGA    K   193_D      P     207          1.368
LGA    L   194_D      M     208          1.217
LGA    W   195_D      T     209          1.044
LGA    A   196_D      I     210          1.840
LGA    W   197_D      L     211          2.128
LGA    C   198_D      A     212          1.680
LGA    G   199_D      G     213          2.296
LGA    E   200_D      D     214          2.473
LGA    Q   201_D      Q     215          3.093
LGA    D   202_D      D     216          1.674
LGA    -       -      I     217           -
LGA    -       -      A     218           -
LGA    -       -      T     219           -
LGA    -       -      P     222           -
LGA    -       -      N     223           -
LGA    -       -      L     224           -
LGA    -       -      P     225           -
LGA    -       -      S     226           -
LGA    -       -      E     227           -
LGA    -       -      P     228           -
LGA    -       -      A     229           -
LGA    -       -      A     230           -
LGA    -       -      L     231           -
LGA    -       -      R     232           -
LGA    -       -      Q     233           -
LGA    -       -      G     234           -
LGA    -       -      P     235           -
LGA    F   203_D      H     236          2.556
LGA    L   204_D      R     237          0.724
LGA    Y   205_D      Y     238          1.264
LGA    E   206_D      A     239          1.435
LGA    A   207_D      R     240          1.053
LGA    N   208_D      A     241          0.794
LGA    N   209_D      R     242          1.278
LGA    L   210_D      H     243          0.757
LGA    A   211_D      Y     244          0.464
LGA    V   212_D      Y     245          0.896
LGA    K   213_D      E     246          0.821
LGA    N   214_D      A     247          1.277
LGA    L   215_D      G     248          1.592
LGA    K   216_D      Q     249          2.459
LGA    K   217_D      R     250          2.767
LGA    L   218_D      A     251          3.215
LGA    G   219_D      A     252          3.631
LGA    -       -      A     253           -
LGA    -       -      Q     254           -
LGA    -       -      R     255           -
LGA    -       -      G     256           -
LGA    -       -      L     257           -
LGA    -       -      P     258           -
LGA    F   220_D      F     259          2.458
LGA    D   221_D      G     260          1.556
LGA    V   222_D      W     261          1.939
LGA    T   223_D      Q     262          1.987
LGA    Y   224_D      L     263          1.226
LGA    S   225_D      Q     264          2.284
LGA    H   226_D      V     265          2.164
LGA    -       -      V     266           -
LGA    S   227_D      P     267          2.146
LGA    A   228_D      G     268          2.480
LGA    G   229_D      I     269          2.898
LGA    T   230_D      G     270          2.207
LGA    H   231_D      H     271          1.522
LGA    E   232_D      D     272          2.312
LGA    W   233_D      G     273          3.194
LGA    Y   234_D      Q     274          4.605
LGA    Y   235_D      A     275          3.176
LGA    W   236_D      M     276          1.730
LGA    E   237_D      S     277          3.142
LGA    K   238_D      Q     278          3.605
LGA    Q   239_D      V     279          2.173
LGA    L   240_D      C     280          2.186
LGA    E   241_D      A     281          3.178
LGA    V   242_D      S     282          3.004
LGA    F   243_D      L     283          3.019
LGA    L   244_D      W     284          2.435
LGA    T   245_D      F     285          3.156
LGA    -       -      D     286           -
LGA    T   246_D      G     287          4.350
LGA    L   247_D      R     288           -
LGA    P   248_D      M     289           -
LGA    I   249_D      -       -           -
LGA    D   250_D      -       -           -
LGA    F   251_D      -       -           -
LGA    K   252_D      -       -           -
LGA    L   253_D      P     290           #
LGA    E   254_D      D     291           -
LGA    E   255_D      A     292           -
LGA    -       -      A     293           -
LGA    R   256_D      E     294           #
LGA    L   257_D      L     295           -
LGA    -       -      A     296           -
LGA    -       -      R     297           -
LGA    -       -      L     298           -
LGA    -       -      A     299           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  245  293    5.0    193    2.51    15.03     41.496     7.385

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.533882 * X  +   0.677209 * Y  +  -0.506318 * Z  +  18.865046
  Y_new =   0.844879 * X  +  -0.403228 * Y  +   0.351549 * Z  +  16.745243
  Z_new =   0.033911 * X  +  -0.615463 * Y  +  -0.787436 * Z  +  42.794147 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.478170    0.663423  [ DEG:  -141.9887     38.0113 ]
  Theta =  -0.033917   -3.107675  [ DEG:    -1.9433   -178.0567 ]
  Phi   =   1.007248   -2.134345  [ DEG:    57.7111   -122.2889 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2uz0_D                                        
REMARK     2: T0413.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2uz0_D.T0413.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  245  293   5.0  193   2.51   15.03  41.496
REMARK  ---------------------------------------------------------- 
MOLECULE 2uz0_D
HEADER    HYDROLASE                               23-APR-07   2UZ0              
TITLE     THE CRYSTAL CRYSTAL STRUCTURE OF THE ESTA PROTEIN, A                  
TITLE    2 VIRULENCE FACTOR ESTA PROTEIN FROM STREPTOCOCCUS PNEUMONIA           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRIBUTYRIN ESTERASE;                                       
COMPND   3 SYNONYM: ESTERASE;                                                   
COMPND   4 CHAIN: A, B, C, D;                                                   
COMPND   5 FRAGMENT: RESIDUES 2-259;                                            
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: B834;                                      
SOURCE   4 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PNEUMONIAE;                       
SOURCE   5 ATCC: BAA-255D                                                       
KEYWDS    ESTERASE, ALPHA/BETA HYDROLASE, HYDROLASE,                            
KEYWDS   2 A VIRULENCE FACTOR FOR LUNG INFECTION                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.H.KIM,B.S.KANG,K.J.KIM,T.K.OH                                       
REVDAT   1   23-OCT-07 2UZ0    0                                                
JRNL        AUTH   M.H.KIM,B.S.KANG,S.KIM,K.J.KIM,C.H.LEE,B.C.OH,               
JRNL        AUTH 2 S.C.PARK,T.K.OH                                              
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE ESTA PROTEIN, A                 
JRNL        TITL 2 VIRULENCE FACTOR FROM STREPTOCOCCUS PNEUMONIAE.              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.7  ANGSTROMS.                                          
DBREF  2UZ0 A   -4     0  PDB    2UZ0     2UZ0            -4      0             
DBREF  2UZ0 A    1   258  UNP    Q97S09   Q97S09_STRPN     2    259             
DBREF  2UZ0 B   -4     0  PDB    2UZ0     2UZ0            -4      0             
DBREF  2UZ0 B    1   258  UNP    Q97S09   Q97S09_STRPN     2    259             
DBREF  2UZ0 C   -4     0  PDB    2UZ0     2UZ0            -4      0             
DBREF  2UZ0 C    1   258  UNP    Q97S09   Q97S09_STRPN     2    259             
DBREF  2UZ0 D   -4     0  PDB    2UZ0     2UZ0            -4      0             
DBREF  2UZ0 D    1   258  UNP    Q97S09   Q97S09_STRPN     2    259             
SEQRES   1 A  263  GLY ALA MSE ASP PRO ALA VAL MSE LYS ILE GLU TYR TYR          
SEQRES   2 A  263  SER GLN VAL LEU ASP MSE GLU TRP GLY VAL ASN VAL LEU          
SEQRES   3 A  263  TYR PRO ASP ALA ASN ARG VAL GLU GLU PRO GLU CYS GLU          
SEQRES   4 A  263  ASP ILE PRO VAL LEU TYR LEU LEU HIS GLY MSE SER GLY          
SEQRES   5 A  263  ASN HIS ASN SER TRP LEU LYS ARG THR ASN VAL GLU ARG          
SEQRES   6 A  263  LEU LEU ARG GLY THR ASN LEU ILE VAL VAL MSE PRO ASN          
SEQRES   7 A  263  THR SER ASN GLY TRP TYR THR ASP THR GLN TYR GLY PHE          
SEQRES   8 A  263  ASP TYR TYR THR ALA LEU ALA GLU GLU LEU PRO GLN VAL          
SEQRES   9 A  263  LEU LYS ARG PHE PHE PRO ASN MSE THR SER LYS ARG GLU          
SEQRES  10 A  263  LYS THR PHE ILE ALA GLY LEU SER MSE GLY GLY TYR GLY          
SEQRES  11 A  263  CYS PHE LYS LEU ALA LEU THR THR ASN ARG PHE SER HIS          
SEQRES  12 A  263  ALA ALA SER PHE SER GLY ALA LEU SER PHE GLN ASN PHE          
SEQRES  13 A  263  SER PRO GLU SER GLN ASN LEU GLY SER PRO ALA TYR TRP          
SEQRES  14 A  263  ARG GLY VAL PHE GLY GLU ILE ARG ASP TRP THR THR SER          
SEQRES  15 A  263  PRO TYR SER LEU GLU SER LEU ALA LYS LYS SER ASP LYS          
SEQRES  16 A  263  LYS THR LYS LEU TRP ALA TRP CYS GLY GLU GLN ASP PHE          
SEQRES  17 A  263  LEU TYR GLU ALA ASN ASN LEU ALA VAL LYS ASN LEU LYS          
SEQRES  18 A  263  LYS LEU GLY PHE ASP VAL THR TYR SER HIS SER ALA GLY          
SEQRES  19 A  263  THR HIS GLU TRP TYR TYR TRP GLU LYS GLN LEU GLU VAL          
SEQRES  20 A  263  PHE LEU THR THR LEU PRO ILE ASP PHE LYS LEU GLU GLU          
SEQRES  21 A  263  ARG LEU THR                                                  
SEQRES   1 B  263  GLY ALA MSE ASP PRO ALA VAL MSE LYS ILE GLU TYR TYR          
SEQRES   2 B  263  SER GLN VAL LEU ASP MSE GLU TRP GLY VAL ASN VAL LEU          
SEQRES   3 B  263  TYR PRO ASP ALA ASN ARG VAL GLU GLU PRO GLU CYS GLU          
SEQRES   4 B  263  ASP ILE PRO VAL LEU TYR LEU LEU HIS GLY MSE SER GLY          
SEQRES   5 B  263  ASN HIS ASN SER TRP LEU LYS ARG THR ASN VAL GLU ARG          
SEQRES   6 B  263  LEU LEU ARG GLY THR ASN LEU ILE VAL VAL MSE PRO ASN          
SEQRES   7 B  263  THR SER ASN GLY TRP TYR THR ASP THR GLN TYR GLY PHE          
SEQRES   8 B  263  ASP TYR TYR THR ALA LEU ALA GLU GLU LEU PRO GLN VAL          
SEQRES   9 B  263  LEU LYS ARG PHE PHE PRO ASN MSE THR SER LYS ARG GLU          
SEQRES  10 B  263  LYS THR PHE ILE ALA GLY LEU SER MSE GLY GLY TYR GLY          
SEQRES  11 B  263  CYS PHE LYS LEU ALA LEU THR THR ASN ARG PHE SER HIS          
SEQRES  12 B  263  ALA ALA SER PHE SER GLY ALA LEU SER PHE GLN ASN PHE          
SEQRES  13 B  263  SER PRO GLU SER GLN ASN LEU GLY SER PRO ALA TYR TRP          
SEQRES  14 B  263  ARG GLY VAL PHE GLY GLU ILE ARG ASP TRP THR THR SER          
SEQRES  15 B  263  PRO TYR SER LEU GLU SER LEU ALA LYS LYS SER ASP LYS          
SEQRES  16 B  263  LYS THR LYS LEU TRP ALA TRP CYS GLY GLU GLN ASP PHE          
SEQRES  17 B  263  LEU TYR GLU ALA ASN ASN LEU ALA VAL LYS ASN LEU LYS          
SEQRES  18 B  263  LYS LEU GLY PHE ASP VAL THR TYR SER HIS SER ALA GLY          
SEQRES  19 B  263  THR HIS GLU TRP TYR TYR TRP GLU LYS GLN LEU GLU VAL          
SEQRES  20 B  263  PHE LEU THR THR LEU PRO ILE ASP PHE LYS LEU GLU GLU          
SEQRES  21 B  263  ARG LEU THR                                                  
SEQRES   1 C  263  GLY ALA MSE ASP PRO ALA VAL MSE LYS ILE GLU TYR TYR          
SEQRES   2 C  263  SER GLN VAL LEU ASP MSE GLU TRP GLY VAL ASN VAL LEU          
SEQRES   3 C  263  TYR PRO ASP ALA ASN ARG VAL GLU GLU PRO GLU CYS GLU          
SEQRES   4 C  263  ASP ILE PRO VAL LEU TYR LEU LEU HIS GLY MSE SER GLY          
SEQRES   5 C  263  ASN HIS ASN SER TRP LEU LYS ARG THR ASN VAL GLU ARG          
SEQRES   6 C  263  LEU LEU ARG GLY THR ASN LEU ILE VAL VAL MSE PRO ASN          
SEQRES   7 C  263  THR SER ASN GLY TRP TYR THR ASP THR GLN TYR GLY PHE          
SEQRES   8 C  263  ASP TYR TYR THR ALA LEU ALA GLU GLU LEU PRO GLN VAL          
SEQRES   9 C  263  LEU LYS ARG PHE PHE PRO ASN MSE THR SER LYS ARG GLU          
SEQRES  10 C  263  LYS THR PHE ILE ALA GLY LEU SER MSE GLY GLY TYR GLY          
SEQRES  11 C  263  CYS PHE LYS LEU ALA LEU THR THR ASN ARG PHE SER HIS          
SEQRES  12 C  263  ALA ALA SER PHE SER GLY ALA LEU SER PHE GLN ASN PHE          
SEQRES  13 C  263  SER PRO GLU SER GLN ASN LEU GLY SER PRO ALA TYR TRP          
SEQRES  14 C  263  ARG GLY VAL PHE GLY GLU ILE ARG ASP TRP THR THR SER          
SEQRES  15 C  263  PRO TYR SER LEU GLU SER LEU ALA LYS LYS SER ASP LYS          
SEQRES  16 C  263  LYS THR LYS LEU TRP ALA TRP CYS GLY GLU GLN ASP PHE          
SEQRES  17 C  263  LEU TYR GLU ALA ASN ASN LEU ALA VAL LYS ASN LEU LYS          
SEQRES  18 C  263  LYS LEU GLY PHE ASP VAL THR TYR SER HIS SER ALA GLY          
SEQRES  19 C  263  THR HIS GLU TRP TYR TYR TRP GLU LYS GLN LEU GLU VAL          
SEQRES  20 C  263  PHE LEU THR THR LEU PRO ILE ASP PHE LYS LEU GLU GLU          
SEQRES  21 C  263  ARG LEU THR                                                  
SEQRES   1 D  263  GLY ALA MSE ASP PRO ALA VAL MSE LYS ILE GLU TYR TYR          
SEQRES   2 D  263  SER GLN VAL LEU ASP MSE GLU TRP GLY VAL ASN VAL LEU          
SEQRES   3 D  263  TYR PRO ASP ALA ASN ARG VAL GLU GLU PRO GLU CYS GLU          
SEQRES   4 D  263  ASP ILE PRO VAL LEU TYR LEU LEU HIS GLY MSE SER GLY          
SEQRES   5 D  263  ASN HIS ASN SER TRP LEU LYS ARG THR ASN VAL GLU ARG          
SEQRES   6 D  263  LEU LEU ARG GLY THR ASN LEU ILE VAL VAL MSE PRO ASN          
SEQRES   7 D  263  THR SER ASN GLY TRP TYR THR ASP THR GLN TYR GLY PHE          
SEQRES   8 D  263  ASP TYR TYR THR ALA LEU ALA GLU GLU LEU PRO GLN VAL          
SEQRES   9 D  263  LEU LYS ARG PHE PHE PRO ASN MSE THR SER LYS ARG GLU          
SEQRES  10 D  263  LYS THR PHE ILE ALA GLY LEU SER MSE GLY GLY TYR GLY          
SEQRES  11 D  263  CYS PHE LYS LEU ALA LEU THR THR ASN ARG PHE SER HIS          
SEQRES  12 D  263  ALA ALA SER PHE SER GLY ALA LEU SER PHE GLN ASN PHE          
SEQRES  13 D  263  SER PRO GLU SER GLN ASN LEU GLY SER PRO ALA TYR TRP          
SEQRES  14 D  263  ARG GLY VAL PHE GLY GLU ILE ARG ASP TRP THR THR SER          
SEQRES  15 D  263  PRO TYR SER LEU GLU SER LEU ALA LYS LYS SER ASP LYS          
SEQRES  16 D  263  LYS THR LYS LEU TRP ALA TRP CYS GLY GLU GLN ASP PHE          
SEQRES  17 D  263  LEU TYR GLU ALA ASN ASN LEU ALA VAL LYS ASN LEU LYS          
SEQRES  18 D  263  LYS LEU GLY PHE ASP VAL THR TYR SER HIS SER ALA GLY          
SEQRES  19 D  263  THR HIS GLU TRP TYR TYR TRP GLU LYS GLN LEU GLU VAL          
SEQRES  20 D  263  PHE LEU THR THR LEU PRO ILE ASP PHE LYS LEU GLU GLU          
SEQRES  21 D  263  ARG LEU THR                                                  
HET    MSE  A  -2       8                                                       
HET    MSE  A   3      13                                                       
HET    MSE  A  14      13                                                       
HET    MSE  A  45       8                                                       
HET    MSE  A  71       8                                                       
HET    MSE  A 107       8                                                       
HET    MSE  A 121       8                                                       
HET    MSE  B  -2       8                                                       
HET    MSE  B   3      13                                                       
HET    MSE  B  14      13                                                       
HET    MSE  B  45       8                                                       
HET    MSE  B  71       8                                                       
HET    MSE  B 107       8                                                       
HET    MSE  B 121       8                                                       
HET    MSE  C  -2       8                                                       
HET    MSE  C   3      13                                                       
HET    MSE  C  14      13                                                       
HET    MSE  C  45       8                                                       
HET    MSE  C  71       8                                                       
HET    MSE  C 107       8                                                       
HET    MSE  C 121       8                                                       
HET    MSE  D  -2       8                                                       
HET    MSE  D   3      13                                                       
HET    MSE  D  14      13                                                       
HET    MSE  D  45       8                                                       
HET    MSE  D  71       8                                                       
HET    MSE  D 107       8                                                       
HET    MSE  D 121       8                                                       
HET     CA  A1258       1                                                       
HET     CA  B1258       1                                                       
HET    GOL  A1259       6                                                       
HET    GOL  A1260       6                                                       
HET    GOL  C1254       6                                                       
HET    GOL  D1258       6                                                       
HET    GOL  C1255       6                                                       
HET    GOL  D1259       6                                                       
HET    EDO  C1256       4                                                       
HET    EDO  A1261       4                                                       
HET    EDO  C1257       4                                                       
HET    EDO  B1259       4                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
HETNAM      CA CALCIUM ION                                                      
HETNAM     GOL GLYCEROL                                                         
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   5  EDO    4(C2 H6 O2)                                                  
FORMUL   6   CA    2(CA 2+)                                                     
FORMUL   7  GOL    6(C3 H8 O3)                                                  
FORMUL   8  MSE    28(C5 H11 N O2 SE)                                           
FORMUL   9  HOH   *563(H2 O1)                                                   
CRYST1   71.695   72.128  101.827  90.00  94.31  90.00 P 1 21 1      8          
ATOM   6150  N   GLY D  -4      -1.271  39.447  19.637  1.00 27.83           N  
ATOM   6151  CA  GLY D  -4      -2.617  40.055  19.440  1.00 27.89           C  
ATOM   6152  C   GLY D  -4      -2.999  41.069  20.499  1.00 27.93           C  
ATOM   6153  O   GLY D  -4      -2.233  41.342  21.430  1.00 27.72           O  
ATOM   6154  N   ALA D  -3      -4.198  41.631  20.346  1.00 28.16           N  
ATOM   6155  CA  ALA D  -3      -4.769  42.549  21.322  1.00 28.56           C  
ATOM   6156  C   ALA D  -3      -4.819  41.875  22.689  1.00 28.67           C  
ATOM   6157  O   ALA D  -3      -5.180  40.695  22.785  1.00 29.05           O  
ATOM   6158  CB  ALA D  -3      -6.173  42.971  20.889  1.00 28.77           C  
HETATM 6159  N   MSE D  -2      -4.446  42.622  23.726  1.00 28.73           N  
HETATM 6160  CA  MSE D  -2      -4.406  42.145  25.124  1.00 29.41           C  
HETATM 6161  C   MSE D  -2      -3.189  41.278  25.465  1.00 27.02           C  
HETATM 6162  O   MSE D  -2      -2.940  40.990  26.637  1.00 26.30           O  
HETATM 6163  CB  MSE D  -2      -5.701  41.428  25.529  1.00 29.77           C  
HETATM 6164  CG  MSE D  -2      -6.960  42.260  25.376  1.00 33.03           C  
HETATM 6165 SE   MSE D  -2      -8.543  41.266  25.938  1.00 41.47          SE  
HETATM 6166  CE  MSE D  -2      -8.474  39.750  24.715  1.00 37.88           C  
ATOM   6167  N   ASP D  -1      -2.440  40.857  24.452  1.00 25.31           N  
ATOM   6168  CA  ASP D  -1      -1.203  40.121  24.696  1.00 23.99           C  
ATOM   6169  C   ASP D  -1      -0.141  41.098  25.193  1.00 23.11           C  
ATOM   6170  O   ASP D  -1      -0.126  42.259  24.762  1.00 22.54           O  
ATOM   6171  CB  ASP D  -1      -0.724  39.406  23.430  1.00 24.15           C  
ATOM   6172  CG  ASP D  -1      -1.610  38.227  23.046  1.00 24.41           C  
ATOM   6173  OD1 ASP D  -1      -2.087  37.515  23.953  1.00 25.29           O  
ATOM   6174  OD2 ASP D  -1      -1.820  38.001  21.837  1.00 23.77           O  
ATOM   6175  N   PRO D   0       0.744  40.642  26.100  1.00 22.05           N  
ATOM   6176  CA  PRO D   0       1.806  41.533  26.574  1.00 21.36           C  
ATOM   6177  C   PRO D   0       2.828  41.863  25.486  1.00 20.58           C  
ATOM   6178  O   PRO D   0       3.128  41.030  24.623  1.00 20.31           O  
ATOM   6179  CB  PRO D   0       2.489  40.711  27.671  1.00 21.31           C  
ATOM   6180  CG  PRO D   0       2.201  39.277  27.310  1.00 21.56           C  
ATOM   6181  CD  PRO D   0       0.824  39.307  26.727  1.00 22.08           C  
ATOM   6182  N   ALA D   1       3.356  43.082  25.527  1.00 19.34           N  
ATOM   6183  CA  ALA D   1       4.517  43.424  24.717  1.00 19.01           C  
ATOM   6184  C   ALA D   1       5.700  42.685  25.302  1.00 19.10           C  
ATOM   6185  O   ALA D   1       5.731  42.387  26.499  1.00 19.02           O  
ATOM   6186  CB  ALA D   1       4.772  44.912  24.756  1.00 18.58           C  
ATOM   6187  N   VAL D   2       6.679  42.382  24.471  1.00 19.07           N  
ATOM   6188  CA  VAL D   2       7.876  41.735  24.974  1.00 20.23           C  
ATOM   6189  C   VAL D   2       9.067  42.621  24.685  1.00 21.75           C  
ATOM   6190  O   VAL D   2       9.279  43.054  23.558  1.00 19.92           O  
ATOM   6191  CB  VAL D   2       8.123  40.348  24.351  1.00 20.71           C  
ATOM   6192  CG1 VAL D   2       9.342  39.689  25.013  1.00 20.41           C  
ATOM   6193  CG2 VAL D   2       6.884  39.457  24.486  1.00 20.36           C  
HETATM 6194  N   MSE D   3       9.832  42.909  25.728  1.00 23.68           N  
HETATM 6195  C   MSE D   3      12.273  42.838  25.905  1.00 24.21           C  
HETATM 6196  O   MSE D   3      12.413  42.380  27.034  1.00 22.52           O  
HETATM 6197  CA  MSE D   3      11.070  43.734  25.745  0.50 26.82           C  
HETATM 6198  CB  MSE D   3      11.051  44.628  27.047  0.50 27.34           C  
HETATM 6199  CG  MSE D   3      11.569  46.110  26.977  0.50 33.41           C  
HETATM 6200 SE   MSE D   3      10.140  47.497  26.718  0.50 44.36          SE  
HETATM 6201  CE  MSE D   3       9.155  47.145  28.395  0.50 39.60           C  
ATOM   6207  N   LYS D   4      13.120  42.610  24.912  1.00 22.11           N  
ATOM   6208  CA  LYS D   4      14.338  41.846  25.117  1.00 21.18           C  
ATOM   6209  C   LYS D   4      15.420  42.889  25.336  1.00 19.79           C  
ATOM   6210  O   LYS D   4      15.720  43.659  24.416  1.00 18.79           O  
ATOM   6211  CB  LYS D   4      14.612  40.971  23.892  1.00 21.35           C  
ATOM   6212  CG  LYS D   4      13.609  39.796  23.798  1.00 22.83           C  
ATOM   6213  CD  LYS D   4      13.499  39.225  22.394  1.00 27.21           C  
ATOM   6214  CE  LYS D   4      12.776  37.859  22.390  1.00 27.87           C  
ATOM   6215  NZ  LYS D   4      11.795  37.715  23.484  1.00 33.46           N  
ATOM   6216  N   ILE D   5      15.952  42.941  26.562  1.00 19.30           N  
ATOM   6217  CA  ILE D   5      16.792  44.073  26.988  1.00 19.31           C  
ATOM   6218  C   ILE D   5      18.256  43.691  27.122  1.00 18.93           C  
ATOM   6219  O   ILE D   5      18.589  42.724  27.817  1.00 20.01           O  
ATOM   6220  CB  ILE D   5      16.293  44.712  28.329  1.00 19.15           C  
ATOM   6221  CG1 ILE D   5      14.813  45.094  28.211  1.00 19.57           C  
ATOM   6222  CG2 ILE D   5      17.163  45.923  28.688  1.00 20.47           C  
ATOM   6223  CD1 ILE D   5      14.203  45.680  29.475  1.00 20.95           C  
ATOM   6224  N   GLU D   6      19.107  44.453  26.440  1.00 18.49           N  
ATOM   6225  CA  GLU D   6      20.550  44.369  26.589  1.00 18.85           C  
ATOM   6226  C   GLU D   6      20.945  45.600  27.382  1.00 18.91           C  
ATOM   6227  O   GLU D   6      20.765  46.721  26.911  1.00 18.25           O  
ATOM   6228  CB  GLU D   6      21.237  44.412  25.221  1.00 19.26           C  
ATOM   6229  CG  GLU D   6      20.940  43.196  24.339  1.00 21.02           C  
ATOM   6230  CD  GLU D   6      21.227  43.445  22.857  1.00 23.07           C  
ATOM   6231  OE1 GLU D   6      22.292  44.001  22.505  1.00 24.69           O  
ATOM   6232  OE2 GLU D   6      20.374  43.067  22.028  1.00 28.61           O  
ATOM   6233  N   TYR D   7      21.477  45.406  28.584  1.00 18.31           N  
ATOM   6234  CA  TYR D   7      21.898  46.542  29.397  1.00 18.99           C  
ATOM   6235  C   TYR D   7      23.264  46.282  30.035  1.00 19.45           C  
ATOM   6236  O   TYR D   7      23.617  45.133  30.306  1.00 20.32           O  
ATOM   6237  CB  TYR D   7      20.834  46.838  30.472  1.00 19.34           C  
ATOM   6238  CG  TYR D   7      20.772  45.812  31.583  1.00 20.04           C  
ATOM   6239  CD1 TYR D   7      21.446  46.029  32.790  1.00 20.89           C  
ATOM   6240  CD2 TYR D   7      20.073  44.614  31.425  1.00 21.08           C  
ATOM   6241  CE1 TYR D   7      21.403  45.090  33.814  1.00 20.21           C  
ATOM   6242  CE2 TYR D   7      20.016  43.671  32.446  1.00 20.48           C  
ATOM   6243  CZ  TYR D   7      20.702  43.910  33.632  1.00 20.04           C  
ATOM   6244  OH  TYR D   7      20.664  42.972  34.637  1.00 19.80           O  
ATOM   6245  N   TYR D   8      24.020  47.346  30.285  1.00 18.90           N  
ATOM   6246  CA  TYR D   8      25.281  47.212  31.001  1.00 18.82           C  
ATOM   6247  C   TYR D   8      25.044  47.044  32.509  1.00 19.40           C  
ATOM   6248  O   TYR D   8      24.386  47.881  33.148  1.00 19.58           O  
ATOM   6249  CB  TYR D   8      26.190  48.413  30.734  1.00 18.68           C  
ATOM   6250  CG  TYR D   8      27.483  48.341  31.525  1.00 19.66           C  
ATOM   6251  CD1 TYR D   8      28.459  47.389  31.217  1.00 19.79           C  
ATOM   6252  CD2 TYR D   8      27.723  49.216  32.581  1.00 19.32           C  
ATOM   6253  CE1 TYR D   8      29.663  47.320  31.955  1.00 19.28           C  
ATOM   6254  CE2 TYR D   8      28.921  49.160  33.320  1.00 21.72           C  
ATOM   6255  CZ  TYR D   8      29.879  48.205  33.002  1.00 19.61           C  
ATOM   6256  OH  TYR D   8      31.056  48.160  33.739  1.00 22.28           O  
ATOM   6257  N   SER D   9      25.584  45.972  33.083  1.00 19.15           N  
ATOM   6258  CA  SER D   9      25.570  45.811  34.543  1.00 19.44           C  
ATOM   6259  C   SER D   9      26.875  46.345  35.105  1.00 19.71           C  
ATOM   6260  O   SER D   9      27.929  45.768  34.869  1.00 19.19           O  
ATOM   6261  CB  SER D   9      25.383  44.347  34.951  1.00 19.18           C  
ATOM   6262  OG  SER D   9      25.653  44.159  36.345  1.00 19.70           O  
ATOM   6263  N   GLN D  10      26.804  47.454  35.845  1.00 20.09           N  
ATOM   6264  CA  GLN D  10      27.989  47.979  36.505  1.00 21.21           C  
ATOM   6265  C   GLN D  10      28.443  47.005  37.612  1.00 20.77           C  
ATOM   6266  O   GLN D  10      29.640  46.783  37.815  1.00 20.93           O  
ATOM   6267  CB  GLN D  10      27.726  49.387  37.055  1.00 21.98           C  
ATOM   6268  CG  GLN D  10      28.902  50.016  37.778  1.00 26.28           C  
ATOM   6269  CD  GLN D  10      30.187  49.929  36.978  1.00 31.77           C  
ATOM   6270  OE1 GLN D  10      30.365  50.630  35.977  1.00 34.92           O  
ATOM   6271  NE2 GLN D  10      31.096  49.053  37.414  1.00 33.67           N  
ATOM   6272  N   VAL D  11      27.482  46.388  38.292  1.00 20.19           N  
ATOM   6273  CA  VAL D  11      27.785  45.437  39.363  1.00 20.06           C  
ATOM   6274  C   VAL D  11      28.611  44.244  38.855  1.00 20.54           C  
ATOM   6275  O   VAL D  11      29.589  43.829  39.499  1.00 19.95           O  
ATOM   6276  CB  VAL D  11      26.479  44.982  40.098  1.00 20.36           C  
ATOM   6277  CG1 VAL D  11      26.738  43.801  41.017  1.00 20.07           C  
ATOM   6278  CG2 VAL D  11      25.900  46.155  40.892  1.00 20.15           C  
ATOM   6279  N   LEU D  12      28.217  43.706  37.699  1.00 20.24           N  
ATOM   6280  CA  LEU D  12      28.886  42.549  37.102  1.00 20.94           C  
ATOM   6281  C   LEU D  12      30.010  42.928  36.125  1.00 21.75           C  
ATOM   6282  O   LEU D  12      30.727  42.045  35.622  1.00 22.07           O  
ATOM   6283  CB  LEU D  12      27.857  41.665  36.384  1.00 20.84           C  
ATOM   6284  CG  LEU D  12      26.769  40.976  37.213  1.00 21.17           C  
ATOM   6285  CD1 LEU D  12      25.790  40.272  36.293  1.00 21.19           C  
ATOM   6286  CD2 LEU D  12      27.367  39.989  38.220  1.00 21.73           C  
ATOM   6287  N   ASP D  13      30.152  44.230  35.855  1.00 21.90           N  
ATOM   6288  CA  ASP D  13      30.971  44.744  34.750  1.00 22.84           C  
ATOM   6289  C   ASP D  13      30.720  43.910  33.487  1.00 23.39           C  
ATOM   6290  O   ASP D  13      31.664  43.420  32.862  1.00 21.89           O  
ATOM   6291  CB  ASP D  13      32.471  44.803  35.103  1.00 23.28           C  
ATOM   6292  CG  ASP D  13      33.316  45.455  33.995  1.00 24.59           C  
ATOM   6293  OD1 ASP D  13      32.769  46.258  33.195  1.00 25.01           O  
ATOM   6294  OD2 ASP D  13      34.529  45.156  33.910  1.00 26.20           O  
HETATM 6295  N   MSE D  14      29.438  43.778  33.147  1.00 23.99           N  
HETATM 6296  C   MSE D  14      27.878  43.549  31.248  1.00 24.02           C  
HETATM 6297  O   MSE D  14      26.939  44.078  31.809  1.00 23.01           O  
HETATM 6298  CA  MSE D  14      29.119  43.064  31.930  0.50 24.47           C  
HETATM 6299  CB  MSE D  14      28.951  41.559  32.188  0.50 24.17           C  
HETATM 6300  CG  MSE D  14      30.190  40.820  32.553  0.50 26.30           C  
HETATM 6301 SE   MSE D  14      30.648  39.923  30.983  0.50 32.02          SE  
HETATM 6302  CE  MSE D  14      28.995  39.760  29.911  0.50 31.18           C  
ATOM   6308  N   GLU D  15      27.977  43.446  29.925  1.00 22.44           N  
ATOM   6309  CA  GLU D  15      26.795  43.667  29.121  1.00 21.79           C  
ATOM   6310  C   GLU D  15      25.943  42.446  29.466  1.00 21.28           C  
ATOM   6311  O   GLU D  15      26.425  41.308  29.372  1.00 21.82           O  
ATOM   6312  CB  GLU D  15      27.138  43.713  27.633  1.00 21.67           C  
ATOM   6313  CG  GLU D  15      27.594  45.100  27.138  1.00 23.83           C  
ATOM   6314  CD  GLU D  15      26.469  46.141  27.123  1.00 25.93           C  
ATOM   6315  OE1 GLU D  15      25.305  45.729  26.980  1.00 26.98           O  
ATOM   6316  OE2 GLU D  15      26.742  47.371  27.234  1.00 26.60           O  
ATOM   6317  N   TRP D  16      24.703  42.677  29.872  1.00 19.55           N  
ATOM   6318  CA  TRP D  16      23.890  41.639  30.503  1.00 19.50           C  
ATOM   6319  C   TRP D  16      22.510  41.685  29.873  1.00 19.52           C  
ATOM   6320  O   TRP D  16      22.265  42.513  29.003  1.00 19.40           O  
ATOM   6321  CB  TRP D  16      23.825  41.885  32.018  1.00 18.91           C  
ATOM   6322  CG  TRP D  16      23.556  40.652  32.847  1.00 18.69           C  
ATOM   6323  CD1 TRP D  16      22.480  40.425  33.661  1.00 19.60           C  
ATOM   6324  CD2 TRP D  16      24.376  39.483  32.925  1.00 19.12           C  
ATOM   6325  NE1 TRP D  16      22.587  39.180  34.254  1.00 19.50           N  
ATOM   6326  CE2 TRP D  16      23.740  38.581  33.815  1.00 18.88           C  
ATOM   6327  CE3 TRP D  16      25.589  39.106  32.337  1.00 18.41           C  
ATOM   6328  CZ2 TRP D  16      24.279  37.331  34.128  1.00 18.75           C  
ATOM   6329  CZ3 TRP D  16      26.123  37.858  32.663  1.00 21.15           C  
ATOM   6330  CH2 TRP D  16      25.467  36.989  33.552  1.00 19.16           C  
ATOM   6331  N   GLY D  17      21.624  40.791  30.292  1.00 19.91           N  
ATOM   6332  CA  GLY D  17      20.314  40.714  29.662  1.00 20.04           C  
ATOM   6333  C   GLY D  17      19.178  40.489  30.628  1.00 19.43           C  
ATOM   6334  O   GLY D  17      19.361  39.865  31.676  1.00 20.52           O  
ATOM   6335  N   VAL D  18      18.004  40.999  30.260  1.00 18.48           N  
ATOM   6336  CA  VAL D  18      16.750  40.708  30.958  1.00 18.20           C  
ATOM   6337  C   VAL D  18      15.641  40.741  29.925  1.00 18.42           C  
ATOM   6338  O   VAL D  18      15.772  41.431  28.914  1.00 18.29           O  
ATOM   6339  CB  VAL D  18      16.479  41.746  32.056  1.00 17.79           C  
ATOM   6340  N   ASN D  19      14.576  39.981  30.171  1.00 18.85           N  
ATOM   6341  CA  ASN D  19      13.350  40.086  29.380  1.00 18.30           C  
ATOM   6342  C   ASN D  19      12.221  40.654  30.222  1.00 18.63           C  
ATOM   6343  O   ASN D  19      12.088  40.320  31.407  1.00 18.82           O  
ATOM   6344  CB  ASN D  19      12.935  38.721  28.825  1.00 18.22           C  
ATOM   6345  CG  ASN D  19      13.944  38.164  27.854  1.00 18.24           C  
ATOM   6346  OD1 ASN D  19      14.449  38.882  26.979  1.00 19.81           O  
ATOM   6347  ND2 ASN D  19      14.254  36.888  27.998  1.00 19.90           N  
ATOM   6348  N   VAL D  20      11.398  41.492  29.597  1.00 18.50           N  
ATOM   6349  CA  VAL D  20      10.238  42.053  30.280  1.00 18.45           C  
ATOM   6350  C   VAL D  20       8.979  41.802  29.460  1.00 18.53           C  
ATOM   6351  O   VAL D  20       8.996  41.966  28.242  1.00 17.91           O  
ATOM   6352  CB  VAL D  20      10.421  43.569  30.572  1.00 18.54           C  
ATOM   6353  CG1 VAL D  20       9.137  44.179  31.162  1.00 18.46           C  
ATOM   6354  CG2 VAL D  20      11.611  43.795  31.558  1.00 18.70           C  
ATOM   6355  N   LEU D  21       7.915  41.372  30.131  1.00 18.33           N  
ATOM   6356  CA  LEU D  21       6.568  41.368  29.552  1.00 18.15           C  
ATOM   6357  C   LEU D  21       5.846  42.577  30.123  1.00 18.81           C  
ATOM   6358  O   LEU D  21       5.768  42.733  31.347  1.00 18.48           O  
ATOM   6359  CB  LEU D  21       5.809  40.079  29.887  1.00 18.38           C  
ATOM   6360  CG  LEU D  21       6.451  38.740  29.524  1.00 18.04           C  
ATOM   6361  CD1 LEU D  21       5.594  37.582  30.044  1.00 18.93           C  
ATOM   6362  CD2 LEU D  21       6.688  38.592  28.023  1.00 21.15           C  
ATOM   6363  N   TYR D  22       5.359  43.439  29.230  1.00 19.33           N  
ATOM   6364  CA  TYR D  22       4.663  44.670  29.611  1.00 19.99           C  
ATOM   6365  C   TYR D  22       3.203  44.620  29.160  1.00 20.53           C  
ATOM   6366  O   TYR D  22       2.928  44.416  27.967  1.00 20.01           O  
ATOM   6367  CB  TYR D  22       5.356  45.890  28.982  1.00 19.70           C  
ATOM   6368  CG  TYR D  22       5.195  47.154  29.801  1.00 20.03           C  
ATOM   6369  CD1 TYR D  22       6.224  47.602  30.623  1.00 19.52           C  
ATOM   6370  CD2 TYR D  22       4.008  47.889  29.767  1.00 18.69           C  
ATOM   6371  CE1 TYR D  22       6.082  48.765  31.399  1.00 20.40           C  
ATOM   6372  CE2 TYR D  22       3.857  49.055  30.532  1.00 18.76           C  
ATOM   6373  CZ  TYR D  22       4.894  49.483  31.348  1.00 19.81           C  
ATOM   6374  OH  TYR D  22       4.755  50.636  32.111  1.00 20.13           O  
ATOM   6375  N   PRO D  23       2.255  44.810  30.103  1.00 21.59           N  
ATOM   6376  CA  PRO D  23       0.846  44.663  29.740  1.00 23.28           C  
ATOM   6377  C   PRO D  23       0.340  45.704  28.744  1.00 24.97           C  
ATOM   6378  O   PRO D  23       0.848  46.831  28.707  1.00 25.45           O  
ATOM   6379  CB  PRO D  23       0.120  44.832  31.081  1.00 22.64           C  
ATOM   6380  CG  PRO D  23       1.054  45.620  31.928  1.00 22.09           C  
ATOM   6381  CD  PRO D  23       2.427  45.166  31.524  1.00 21.66           C  
ATOM   6382  N   ASP D  24      -0.625  45.287  27.924  1.00 27.23           N  
ATOM   6383  CA  ASP D  24      -1.565  46.173  27.203  1.00 29.47           C  
ATOM   6384  C   ASP D  24      -1.013  46.906  25.991  1.00 30.25           C  
ATOM   6385  O   ASP D  24      -1.778  47.275  25.092  1.00 31.05           O  
ATOM   6386  CB  ASP D  24      -2.232  47.180  28.153  1.00 30.14           C  
ATOM   6387  CG  ASP D  24      -2.696  46.549  29.451  1.00 33.26           C  
ATOM   6388  OD1 ASP D  24      -3.008  45.332  29.455  1.00 38.32           O  
ATOM   6389  OD2 ASP D  24      -2.757  47.274  30.472  1.00 37.47           O  
ATOM   6390  N   GLU D  34       0.734  54.803  36.920  1.00 31.11           N  
ATOM   6391  CA  GLU D  34      -0.145  53.668  36.664  1.00 30.88           C  
ATOM   6392  C   GLU D  34      -0.032  52.641  37.789  1.00 29.97           C  
ATOM   6393  O   GLU D  34      -0.970  51.876  38.032  1.00 31.06           O  
ATOM   6394  CB  GLU D  34       0.178  53.013  35.316  1.00 31.47           C  
ATOM   6395  CG  GLU D  34      -0.070  53.890  34.089  1.00 33.79           C  
ATOM   6396  CD  GLU D  34      -1.548  54.094  33.777  1.00 36.94           C  
ATOM   6397  OE1 GLU D  34      -2.381  53.235  34.157  1.00 38.54           O  
ATOM   6398  OE2 GLU D  34      -1.880  55.119  33.140  1.00 38.43           O  
ATOM   6399  N   ASP D  35       1.120  52.629  38.462  1.00 28.44           N  
ATOM   6400  CA  ASP D  35       1.373  51.753  39.608  1.00 26.87           C  
ATOM   6401  C   ASP D  35       1.128  50.286  39.229  1.00 25.56           C  
ATOM   6402  O   ASP D  35       0.357  49.577  39.877  1.00 25.09           O  
ATOM   6403  CB  ASP D  35       0.513  52.196  40.807  1.00 27.12           C  
ATOM   6404  CG  ASP D  35       0.896  51.510  42.112  1.00 27.90           C  
ATOM   6405  OD1 ASP D  35       2.074  51.140  42.285  1.00 27.85           O  
ATOM   6406  OD2 ASP D  35       0.003  51.366  42.982  1.00 29.32           O  
ATOM   6407  N   ILE D  36       1.785  49.843  38.156  1.00 23.77           N  
ATOM   6408  CA  ILE D  36       1.553  48.496  37.625  1.00 22.43           C  
ATOM   6409  C   ILE D  36       2.299  47.441  38.446  1.00 21.34           C  
ATOM   6410  O   ILE D  36       3.505  47.560  38.681  1.00 20.75           O  
ATOM   6411  CB  ILE D  36       1.932  48.385  36.122  1.00 22.33           C  
ATOM   6412  CG1 ILE D  36       1.248  49.493  35.311  1.00 22.67           C  
ATOM   6413  CG2 ILE D  36       1.572  47.001  35.585  1.00 22.42           C  
ATOM   6414  CD1 ILE D  36       1.831  49.734  33.927  1.00 23.48           C  
ATOM   6415  N   PRO D  37       1.576  46.397  38.894  1.00 20.52           N  
ATOM   6416  CA  PRO D  37       2.214  45.321  39.649  1.00 20.37           C  
ATOM   6417  C   PRO D  37       3.343  44.625  38.874  1.00 20.34           C  
ATOM   6418  O   PRO D  37       3.304  44.566  37.640  1.00 20.21           O  
ATOM   6419  CB  PRO D  37       1.059  44.343  39.890  1.00 20.15           C  
ATOM   6420  CG  PRO D  37      -0.166  45.213  39.856  1.00 20.34           C  
ATOM   6421  CD  PRO D  37       0.123  46.190  38.764  1.00 20.33           C  
ATOM   6422  N   VAL D  38       4.335  44.118  39.605  1.00 20.55           N  
ATOM   6423  CA  VAL D  38       5.476  43.421  38.997  1.00 21.13           C  
ATOM   6424  C   VAL D  38       5.701  42.034  39.607  1.00 21.05           C  
ATOM   6425  O   VAL D  38       5.662  41.869  40.841  1.00 20.95           O  
ATOM   6426  CB  VAL D  38       6.796  44.266  39.037  1.00 21.09           C  
ATOM   6427  CG1 VAL D  38       7.254  44.516  40.449  1.00 22.77           C  
ATOM   6428  CG2 VAL D  38       7.920  43.561  38.255  1.00 21.66           C  
ATOM   6429  N   LEU D  39       5.940  41.056  38.724  1.00 20.97           N  
ATOM   6430  CA  LEU D  39       6.393  39.728  39.103  1.00 20.95           C  
ATOM   6431  C   LEU D  39       7.801  39.478  38.566  1.00 21.11           C  
ATOM   6432  O   LEU D  39       8.028  39.534  37.354  1.00 21.19           O  
ATOM   6433  CB  LEU D  39       5.424  38.652  38.591  1.00 21.29           C  
ATOM   6434  CG  LEU D  39       5.831  37.172  38.708  1.00 21.27           C  
ATOM   6435  CD1 LEU D  39       5.839  36.679  40.157  1.00 22.11           C  
ATOM   6436  CD2 LEU D  39       4.917  36.297  37.862  1.00 21.94           C  
ATOM   6437  N   TYR D  40       8.737  39.200  39.467  1.00 20.89           N  
ATOM   6438  CA  TYR D  40      10.053  38.690  39.075  1.00 21.07           C  
ATOM   6439  C   TYR D  40       9.965  37.181  38.925  1.00 21.31           C  
ATOM   6440  O   TYR D  40       9.447  36.480  39.795  1.00 20.75           O  
ATOM   6441  CB  TYR D  40      11.133  39.087  40.088  1.00 21.55           C  
ATOM   6442  CG  TYR D  40      11.475  40.558  40.043  1.00 22.06           C  
ATOM   6443  CD1 TYR D  40      12.609  41.003  39.366  1.00 23.54           C  
ATOM   6444  CD2 TYR D  40      10.661  41.510  40.661  1.00 23.45           C  
ATOM   6445  CE1 TYR D  40      12.931  42.358  39.310  1.00 23.82           C  
ATOM   6446  CE2 TYR D  40      10.969  42.876  40.602  1.00 23.74           C  
ATOM   6447  CZ  TYR D  40      12.107  43.288  39.930  1.00 23.56           C  
ATOM   6448  OH  TYR D  40      12.424  44.629  39.869  1.00 23.16           O  
ATOM   6449  N   LEU D  41      10.458  36.685  37.801  1.00 21.16           N  
ATOM   6450  CA  LEU D  41      10.288  35.275  37.444  1.00 21.18           C  
ATOM   6451  C   LEU D  41      11.671  34.689  37.185  1.00 21.44           C  
ATOM   6452  O   LEU D  41      12.330  35.042  36.201  1.00 21.15           O  
ATOM   6453  CB  LEU D  41       9.373  35.166  36.217  1.00 21.77           C  
ATOM   6454  CG  LEU D  41       8.701  33.835  35.881  1.00 21.87           C  
ATOM   6455  CD1 LEU D  41       8.003  33.202  37.101  1.00 22.26           C  
ATOM   6456  CD2 LEU D  41       7.716  33.997  34.720  1.00 20.83           C  
ATOM   6457  N   LEU D  42      12.109  33.822  38.100  1.00 21.35           N  
ATOM   6458  CA  LEU D  42      13.501  33.357  38.159  1.00 21.28           C  
ATOM   6459  C   LEU D  42      13.723  31.967  37.562  1.00 21.05           C  
ATOM   6460  O   LEU D  42      12.982  31.022  37.871  1.00 20.08           O  
ATOM   6461  CB  LEU D  42      13.972  33.364  39.615  1.00 20.97           C  
ATOM   6462  CG  LEU D  42      14.516  34.685  40.164  1.00 22.79           C  
ATOM   6463  CD1 LEU D  42      13.572  35.865  39.974  1.00 23.71           C  
ATOM   6464  CD2 LEU D  42      14.881  34.508  41.624  1.00 21.66           C  
ATOM   6465  N   HIS D  43      14.759  31.855  36.728  1.00 21.04           N  
ATOM   6466  CA  HIS D  43      15.138  30.595  36.084  1.00 21.22           C  
ATOM   6467  C   HIS D  43      15.894  29.663  37.026  1.00 21.47           C  
ATOM   6468  O   HIS D  43      16.342  30.071  38.097  1.00 21.24           O  
ATOM   6469  CB  HIS D  43      15.989  30.854  34.832  1.00 21.37           C  
ATOM   6470  CG  HIS D  43      17.386  31.320  35.137  1.00 19.61           C  
ATOM   6471  ND1 HIS D  43      17.746  32.652  35.131  1.00 21.08           N  
ATOM   6472  CD2 HIS D  43      18.499  30.632  35.476  1.00 17.01           C  
ATOM   6473  CE1 HIS D  43      19.029  32.762  35.433  1.00 18.45           C  
ATOM   6474  NE2 HIS D  43      19.508  31.551  35.654  1.00 21.28           N  
ATOM   6475  N   GLY D  44      16.040  28.405  36.604  1.00 22.32           N  
ATOM   6476  CA  GLY D  44      16.798  27.419  37.360  1.00 22.76           C  
ATOM   6477  C   GLY D  44      18.162  27.170  36.742  1.00 23.42           C  
ATOM   6478  O   GLY D  44      18.558  27.841  35.782  1.00 23.05           O  
HETATM 6479  N   MSE D  45      18.891  26.211  37.305  1.00 23.88           N  
HETATM 6480  CA  MSE D  45      20.243  25.915  36.842  1.00 25.03           C  
HETATM 6481  C   MSE D  45      20.242  25.458  35.380  1.00 24.41           C  
HETATM 6482  O   MSE D  45      19.313  24.781  34.937  1.00 24.56           O  
HETATM 6483  CB  MSE D  45      20.885  24.865  37.744  1.00 25.45           C  
HETATM 6484  CG  MSE D  45      22.390  24.975  37.840  1.00 27.04           C  
HETATM 6485 SE   MSE D  45      23.095  23.645  39.055  1.00 31.00          SE  
HETATM 6486  CE  MSE D  45      24.743  23.267  38.073  1.00 28.34           C  
ATOM   6487  N   SER D  46      21.280  25.859  34.642  1.00 23.87           N  
ATOM   6488  CA  SER D  46      21.392  25.686  33.186  1.00 23.41           C  
ATOM   6489  C   SER D  46      20.555  26.691  32.379  1.00 22.66           C  
ATOM   6490  O   SER D  46      20.675  26.780  31.153  1.00 22.44           O  
ATOM   6491  CB  SER D  46      21.110  24.234  32.745  1.00 23.63           C  
ATOM   6492  OG  SER D  46      19.726  23.993  32.575  1.00 25.17           O  
ATOM   6493  N   GLY D  47      19.720  27.455  33.080  1.00 21.91           N  
ATOM   6494  CA  GLY D  47      18.858  28.431  32.428  1.00 20.84           C  
ATOM   6495  C   GLY D  47      19.412  29.843  32.389  1.00 20.64           C  
ATOM   6496  O   GLY D  47      20.553  30.107  32.793  1.00 20.62           O  
ATOM   6497  N   ASN D  48      18.587  30.751  31.889  1.00 20.27           N  
ATOM   6498  CA  ASN D  48      18.893  32.174  31.876  1.00 19.89           C  
ATOM   6499  C   ASN D  48      17.600  32.974  31.729  1.00 19.91           C  
ATOM   6500  O   ASN D  48      16.510  32.435  31.936  1.00 19.28           O  
ATOM   6501  CB  ASN D  48      19.944  32.513  30.787  1.00 20.82           C  
ATOM   6502  CG  ASN D  48      19.489  32.151  29.367  1.00 20.41           C  
ATOM   6503  OD1 ASN D  48      20.303  31.834  28.497  1.00 25.13           O  
ATOM   6504  ND2 ASN D  48      18.202  32.207  29.128  1.00 17.80           N  
ATOM   6505  N   HIS D  49      17.724  34.256  31.392  1.00 19.05           N  
ATOM   6506  CA  HIS D  49      16.572  35.145  31.274  1.00 19.54           C  
ATOM   6507  C   HIS D  49      15.543  34.709  30.220  1.00 18.50           C  
ATOM   6508  O   HIS D  49      14.371  35.067  30.312  1.00 19.20           O  
ATOM   6509  CB  HIS D  49      17.030  36.601  31.058  1.00 18.96           C  
ATOM   6510  CG  HIS D  49      17.944  36.804  29.892  1.00 21.40           C  
ATOM   6511  ND1 HIS D  49      19.169  36.175  29.772  1.00 21.97           N  
ATOM   6512  CD2 HIS D  49      17.807  37.574  28.785  1.00 23.17           C  
ATOM   6513  CE1 HIS D  49      19.742  36.543  28.640  1.00 22.98           C  
ATOM   6514  NE2 HIS D  49      18.939  37.396  28.025  1.00 23.27           N  
ATOM   6515  N   ASN D  50      15.980  33.919  29.236  1.00 18.74           N  
ATOM   6516  CA  ASN D  50      15.082  33.391  28.218  1.00 18.97           C  
ATOM   6517  C   ASN D  50      14.320  32.137  28.642  1.00 19.05           C  
ATOM   6518  O   ASN D  50      13.436  31.711  27.912  1.00 20.03           O  
ATOM   6519  CB  ASN D  50      15.849  33.074  26.932  1.00 18.98           C  
ATOM   6520  CG  ASN D  50      16.553  34.285  26.373  1.00 20.54           C  
ATOM   6521  OD1 ASN D  50      15.996  35.371  26.338  1.00 22.72           O  
ATOM   6522  ND2 ASN D  50      17.781  34.102  25.948  1.00 22.86           N  
ATOM   6523  N   SER D  51      14.678  31.543  29.781  1.00 19.28           N  
ATOM   6524  CA  SER D  51      14.115  30.235  30.163  1.00 18.94           C  
ATOM   6525  C   SER D  51      12.587  30.201  30.190  1.00 19.15           C  
ATOM   6526  O   SER D  51      11.981  29.351  29.530  1.00 18.78           O  
ATOM   6527  CB  SER D  51      14.721  29.691  31.478  1.00 19.54           C  
ATOM   6528  OG  SER D  51      16.088  29.327  31.279  1.00 19.51           O  
ATOM   6529  N   TRP D  52      11.951  31.112  30.921  1.00 19.06           N  
ATOM   6530  CA  TRP D  52      10.485  31.061  31.033  1.00 19.24           C  
ATOM   6531  C   TRP D  52       9.790  31.280  29.681  1.00 18.90           C  
ATOM   6532  O   TRP D  52       8.747  30.668  29.403  1.00 19.20           O  
ATOM   6533  CB  TRP D  52       9.976  32.011  32.120  1.00 18.92           C  
ATOM   6534  CG  TRP D  52      10.179  31.456  33.522  1.00 18.63           C  
ATOM   6535  CD1 TRP D  52      11.265  31.634  34.325  1.00 18.37           C  
ATOM   6536  CD2 TRP D  52       9.264  30.617  34.260  1.00 19.69           C  
ATOM   6537  NE1 TRP D  52      11.079  30.979  35.531  1.00 18.72           N  
ATOM   6538  CE2 TRP D  52       9.867  30.336  35.506  1.00 19.13           C  
ATOM   6539  CE3 TRP D  52       7.998  30.073  33.980  1.00 20.65           C  
ATOM   6540  CZ2 TRP D  52       9.240  29.534  36.482  1.00 19.10           C  
ATOM   6541  CZ3 TRP D  52       7.376  29.279  34.946  1.00 19.43           C  
ATOM   6542  CH2 TRP D  52       8.001  29.016  36.181  1.00 18.98           C  
ATOM   6543  N   LEU D  53      10.398  32.106  28.828  1.00 19.42           N  
ATOM   6544  CA  LEU D  53       9.898  32.303  27.466  1.00 18.91           C  
ATOM   6545  C   LEU D  53      10.103  31.056  26.601  1.00 18.98           C  
ATOM   6546  O   LEU D  53       9.219  30.700  25.816  1.00 19.37           O  
ATOM   6547  CB  LEU D  53      10.552  33.526  26.803  1.00 18.85           C  
ATOM   6548  CG  LEU D  53      10.234  34.905  27.392  1.00 18.81           C  
ATOM   6549  CD1 LEU D  53      10.993  35.954  26.606  1.00 19.94           C  
ATOM   6550  CD2 LEU D  53       8.742  35.217  27.331  1.00 21.12           C  
ATOM   6551  N   LYS D  54      11.233  30.375  26.758  1.00 18.22           N  
ATOM   6552  CA  LYS D  54      11.534  29.204  25.911  1.00 18.19           C  
ATOM   6553  C   LYS D  54      10.783  27.946  26.324  1.00 18.13           C  
ATOM   6554  O   LYS D  54      10.481  27.100  25.480  1.00 18.64           O  
ATOM   6555  CB  LYS D  54      13.028  28.912  25.927  1.00 18.09           C  
ATOM   6556  CG  LYS D  54      13.839  29.911  25.127  1.00 19.39           C  
ATOM   6557  CD  LYS D  54      15.317  29.815  25.470  1.00 21.47           C  
ATOM   6558  CE  LYS D  54      15.988  28.559  24.921  1.00 22.12           C  
ATOM   6559  NZ  LYS D  54      16.060  28.494  23.426  1.00 19.97           N  
ATOM   6560  N   ARG D  55      10.457  27.865  27.616  1.00 18.02           N  
ATOM   6561  CA  ARG D  55      10.059  26.604  28.245  1.00 18.40           C  
ATOM   6562  C   ARG D  55       8.606  26.560  28.715  1.00 18.33           C  
ATOM   6563  O   ARG D  55       8.148  25.515  29.185  1.00 19.20           O  
ATOM   6564  CB  ARG D  55      10.987  26.312  29.426  1.00 18.56           C  
ATOM   6565  CG  ARG D  55      12.472  26.181  29.075  1.00 19.75           C  
ATOM   6566  CD  ARG D  55      12.793  24.990  28.194  1.00 22.78           C  
ATOM   6567  NE  ARG D  55      14.157  25.124  27.679  1.00 24.84           N  
ATOM   6568  CZ  ARG D  55      14.541  24.801  26.444  1.00 25.75           C  
ATOM   6569  NH1 ARG D  55      13.674  24.297  25.572  1.00 25.98           N  
ATOM   6570  NH2 ARG D  55      15.809  24.973  26.081  1.00 26.81           N  
ATOM   6571  N   THR D  56       7.904  27.693  28.627  1.00 18.20           N  
ATOM   6572  CA  THR D  56       6.500  27.761  29.057  1.00 18.12           C  
ATOM   6573  C   THR D  56       5.678  28.679  28.173  1.00 18.21           C  
ATOM   6574  O   THR D  56       6.232  29.471  27.394  1.00 18.02           O  
ATOM   6575  CB  THR D  56       6.328  28.318  30.499  1.00 17.22           C  
ATOM   6576  OG1 THR D  56       6.514  29.750  30.499  1.00 17.46           O  
ATOM   6577  CG2 THR D  56       7.262  27.650  31.472  1.00 18.24           C  
ATOM   6578  N   ASN D  57       4.356  28.602  28.350  1.00 18.28           N  
ATOM   6579  CA  ASN D  57       3.411  29.557  27.768  1.00 18.69           C  
ATOM   6580  C   ASN D  57       3.126  30.793  28.639  1.00 18.92           C  
ATOM   6581  O   ASN D  57       2.013  31.320  28.623  1.00 18.11           O  
ATOM   6582  CB  ASN D  57       2.094  28.862  27.396  1.00 19.02           C  
ATOM   6583  CG  ASN D  57       2.155  28.169  26.040  1.00 19.37           C  
ATOM   6584  OD1 ASN D  57       2.631  28.744  25.059  1.00 19.28           O  
ATOM   6585  ND2 ASN D  57       1.639  26.941  25.976  1.00 18.30           N  
ATOM   6586  N   VAL D  58       4.130  31.269  29.369  1.00 19.29           N  
ATOM   6587  CA  VAL D  58       3.959  32.477  30.189  1.00 20.01           C  
ATOM   6588  C   VAL D  58       3.363  33.645  29.369  1.00 20.51           C  
ATOM   6589  O   VAL D  58       2.517  34.379  29.887  1.00 20.43           O  
ATOM   6590  CB  VAL D  58       5.270  32.879  30.948  1.00 20.43           C  
ATOM   6591  CG1 VAL D  58       6.399  33.286  29.979  1.00 20.01           C  
ATOM   6592  CG2 VAL D  58       5.000  33.987  31.999  1.00 20.42           C  
ATOM   6593  N   GLU D  59       3.772  33.806  28.102  1.00 20.45           N  
ATOM   6594  CA  GLU D  59       3.215  34.887  27.265  1.00 21.02           C  
ATOM   6595  C   GLU D  59       1.703  34.780  27.121  1.00 21.69           C  
ATOM   6596  O   GLU D  59       0.986  35.770  27.281  1.00 22.03           O  
ATOM   6597  CB  GLU D  59       3.849  34.967  25.868  1.00 21.54           C  
ATOM   6598  CG  GLU D  59       5.165  35.661  25.839  1.00 21.16           C  
ATOM   6599  CD  GLU D  59       5.658  35.962  24.434  1.00 21.72           C  
ATOM   6600  OE1 GLU D  59       4.969  36.690  23.677  1.00 20.75           O  
ATOM   6601  OE2 GLU D  59       6.763  35.497  24.106  1.00 21.09           O  
ATOM   6602  N   ARG D  60       1.217  33.573  26.825  1.00 22.13           N  
ATOM   6603  CA  ARG D  60      -0.218  33.341  26.680  1.00 23.07           C  
ATOM   6604  C   ARG D  60      -0.912  33.531  28.024  1.00 22.97           C  
ATOM   6605  O   ARG D  60      -2.004  34.107  28.115  1.00 22.87           O  
ATOM   6606  CB  ARG D  60      -0.464  31.928  26.149  1.00 23.27           C  
ATOM   6607  CG  ARG D  60      -1.481  31.872  25.038  1.00 25.38           C  
ATOM   6608  CD  ARG D  60      -1.414  30.552  24.303  1.00 23.05           C  
ATOM   6609  NE  ARG D  60      -1.810  29.426  25.143  1.00 22.20           N  
ATOM   6610  CZ  ARG D  60      -1.511  28.153  24.894  1.00 21.49           C  
ATOM   6611  NH1 ARG D  60      -0.783  27.837  23.829  1.00 21.42           N  
ATOM   6612  NH2 ARG D  60      -1.932  27.195  25.718  1.00 18.82           N  
ATOM   6613  N   LEU D  61      -0.249  33.058  29.072  1.00 23.27           N  
ATOM   6614  CA  LEU D  61      -0.779  33.111  30.426  1.00 23.66           C  
ATOM   6615  C   LEU D  61      -1.026  34.552  30.877  1.00 23.95           C  
ATOM   6616  O   LEU D  61      -1.976  34.821  31.610  1.00 24.26           O  
ATOM   6617  CB  LEU D  61       0.204  32.414  31.367  1.00 23.44           C  
ATOM   6618  CG  LEU D  61      -0.222  31.959  32.749  1.00 24.68           C  
ATOM   6619  CD1 LEU D  61      -1.404  31.005  32.645  1.00 22.73           C  
ATOM   6620  CD2 LEU D  61       0.978  31.292  33.422  1.00 24.04           C  
ATOM   6621  N   LEU D  62      -0.185  35.473  30.411  1.00 23.46           N  
ATOM   6622  CA  LEU D  62      -0.287  36.889  30.786  1.00 23.92           C  
ATOM   6623  C   LEU D  62      -1.274  37.713  29.940  1.00 23.71           C  
ATOM   6624  O   LEU D  62      -1.461  38.903  30.190  1.00 23.01           O  
ATOM   6625  CB  LEU D  62       1.103  37.542  30.788  1.00 24.50           C  
ATOM   6626  CG  LEU D  62       1.885  37.605  32.116  1.00 25.20           C  
ATOM   6627  CD1 LEU D  62       1.286  38.670  33.038  1.00 25.74           C  
ATOM   6628  CD2 LEU D  62       1.998  36.244  32.833  1.00 24.51           C  
ATOM   6629  N   ARG D  63      -1.904  37.090  28.943  1.00 23.46           N  
ATOM   6630  CA  ARG D  63      -2.919  37.782  28.140  1.00 23.44           C  
ATOM   6631  C   ARG D  63      -3.984  38.433  29.036  1.00 23.31           C  
ATOM   6632  O   ARG D  63      -4.510  37.800  29.954  1.00 23.39           O  
ATOM   6633  CB  ARG D  63      -3.552  36.817  27.137  1.00 23.56           C  
ATOM   6634  CG  ARG D  63      -4.533  37.424  26.156  1.00 25.12           C  
ATOM   6635  CD  ARG D  63      -5.063  36.303  25.280  1.00 29.26           C  
ATOM   6636  NE  ARG D  63      -6.211  36.693  24.473  1.00 31.77           N  
ATOM   6637  CZ  ARG D  63      -6.127  37.361  23.328  1.00 34.07           C  
ATOM   6638  NH1 ARG D  63      -4.945  37.740  22.846  1.00 33.85           N  
ATOM   6639  NH2 ARG D  63      -7.236  37.660  22.661  1.00 35.13           N  
ATOM   6640  N   GLY D  64      -4.263  39.712  28.779  1.00 23.33           N  
ATOM   6641  CA  GLY D  64      -5.301  40.465  29.492  1.00 23.26           C  
ATOM   6642  C   GLY D  64      -5.041  40.737  30.966  1.00 23.46           C  
ATOM   6643  O   GLY D  64      -5.953  41.163  31.683  1.00 23.83           O  
ATOM   6644  N   THR D  65      -3.805  40.515  31.411  1.00 23.08           N  
ATOM   6645  CA  THR D  65      -3.454  40.612  32.832  1.00 23.19           C  
ATOM   6646  C   THR D  65      -2.579  41.835  33.083  1.00 22.84           C  
ATOM   6647  O   THR D  65      -1.534  41.987  32.452  1.00 22.51           O  
ATOM   6648  CB  THR D  65      -2.720  39.331  33.306  1.00 23.32           C  
ATOM   6649  OG1 THR D  65      -3.522  38.181  33.001  1.00 25.76           O  
ATOM   6650  CG2 THR D  65      -2.450  39.371  34.800  1.00 23.24           C  
ATOM   6651  N   ASN D  66      -3.013  42.704  33.997  1.00 22.27           N  
ATOM   6652  CA  ASN D  66      -2.235  43.899  34.329  1.00 22.04           C  
ATOM   6653  C   ASN D  66      -1.102  43.573  35.303  1.00 21.31           C  
ATOM   6654  O   ASN D  66      -1.223  43.771  36.520  1.00 21.29           O  
ATOM   6655  CB  ASN D  66      -3.133  45.016  34.873  1.00 22.66           C  
ATOM   6656  CG  ASN D  66      -2.371  46.316  35.113  1.00 23.86           C  
ATOM   6657  OD1 ASN D  66      -1.599  46.767  34.273  1.00 27.34           O  
ATOM   6658  ND2 ASN D  66      -2.590  46.919  36.279  1.00 27.30           N  
ATOM   6659  N   LEU D  67      -0.006  43.069  34.740  1.00 20.37           N  
ATOM   6660  CA  LEU D  67       1.157  42.628  35.498  1.00 20.02           C  
ATOM   6661  C   LEU D  67       2.388  42.686  34.600  1.00 19.98           C  
ATOM   6662  O   LEU D  67       2.374  42.152  33.480  1.00 19.83           O  
ATOM   6663  CB  LEU D  67       0.956  41.178  35.975  1.00 19.42           C  
ATOM   6664  CG  LEU D  67       2.088  40.455  36.719  1.00 19.38           C  
ATOM   6665  CD1 LEU D  67       2.396  41.077  38.102  1.00 20.05           C  
ATOM   6666  CD2 LEU D  67       1.744  38.981  36.869  1.00 20.38           C  
ATOM   6667  N   ILE D  68       3.435  43.334  35.098  1.00 19.69           N  
ATOM   6668  CA  ILE D  68       4.744  43.356  34.436  1.00 19.83           C  
ATOM   6669  C   ILE D  68       5.497  42.120  34.906  1.00 20.17           C  
ATOM   6670  O   ILE D  68       5.496  41.813  36.097  1.00 20.41           O  
ATOM   6671  CB  ILE D  68       5.530  44.640  34.803  1.00 19.70           C  
ATOM   6672  CG1 ILE D  68       4.875  45.862  34.150  1.00 19.09           C  
ATOM   6673  CG2 ILE D  68       7.023  44.534  34.396  1.00 18.99           C  
ATOM   6674  CD1 ILE D  68       5.424  47.209  34.669  1.00 20.34           C  
ATOM   6675  N   VAL D  69       6.114  41.393  33.980  1.00 20.08           N  
ATOM   6676  CA  VAL D  69       6.926  40.245  34.358  1.00 19.86           C  
ATOM   6677  C   VAL D  69       8.381  40.532  34.003  1.00 20.44           C  
ATOM   6678  O   VAL D  69       8.693  40.874  32.859  1.00 20.35           O  
ATOM   6679  CB  VAL D  69       6.448  38.929  33.688  1.00 20.44           C  
ATOM   6680  CG1 VAL D  69       7.283  37.754  34.161  1.00 19.70           C  
ATOM   6681  CG2 VAL D  69       4.963  38.685  33.976  1.00 19.67           C  
ATOM   6682  N   VAL D  70       9.259  40.390  34.989  1.00 20.03           N  
ATOM   6683  CA  VAL D  70      10.696  40.600  34.787  1.00 20.16           C  
ATOM   6684  C   VAL D  70      11.462  39.282  34.928  1.00 20.14           C  
ATOM   6685  O   VAL D  70      11.384  38.611  35.962  1.00 20.08           O  
ATOM   6686  CB  VAL D  70      11.246  41.644  35.787  1.00 20.11           C  
ATOM   6687  CG1 VAL D  70      12.776  41.784  35.647  1.00 19.43           C  
ATOM   6688  CG2 VAL D  70      10.559  42.980  35.584  1.00 20.46           C  
HETATM 6689  N   MSE D  71      12.195  38.912  33.879  1.00 19.93           N  
HETATM 6690  CA  MSE D  71      13.015  37.708  33.898  1.00 20.89           C  
HETATM 6691  C   MSE D  71      14.511  38.058  33.904  1.00 20.77           C  
HETATM 6692  O   MSE D  71      15.054  38.482  32.874  1.00 21.26           O  
HETATM 6693  CB  MSE D  71      12.655  36.808  32.701  1.00 21.01           C  
HETATM 6694  CG  MSE D  71      11.294  36.114  32.848  1.00 20.83           C  
HETATM 6695 SE   MSE D  71      10.457  35.763  31.099  1.00 26.48          SE  
HETATM 6696  CE  MSE D  71       9.836  37.582  30.718  1.00 22.01           C  
ATOM   6697  N   PRO D  72      15.173  37.916  35.065  1.00 21.04           N  
ATOM   6698  CA  PRO D  72      16.611  38.166  35.171  1.00 20.87           C  
ATOM   6699  C   PRO D  72      17.455  36.952  34.759  1.00 20.65           C  
ATOM   6700  O   PRO D  72      16.915  35.852  34.535  1.00 19.90           O  
ATOM   6701  CB  PRO D  72      16.784  38.425  36.666  1.00 21.15           C  
ATOM   6702  CG  PRO D  72      15.796  37.496  37.290  1.00 20.94           C  
ATOM   6703  CD  PRO D  72      14.588  37.548  36.370  1.00 21.08           C  
ATOM   6704  N   ASN D  73      18.771  37.168  34.666  1.00 20.10           N  
ATOM   6705  CA  ASN D  73      19.745  36.103  34.411  1.00 20.26           C  
ATOM   6706  C   ASN D  73      20.766  36.047  35.555  1.00 20.71           C  
ATOM   6707  O   ASN D  73      21.377  37.072  35.865  1.00 21.22           O  
ATOM   6708  CB  ASN D  73      20.480  36.341  33.073  1.00 20.26           C  
ATOM   6709  CG  ASN D  73      21.414  35.190  32.681  1.00 20.76           C  
ATOM   6710  OD1 ASN D  73      21.343  34.093  33.243  1.00 22.09           O  
ATOM   6711  ND2 ASN D  73      22.281  35.439  31.693  1.00 21.35           N  
ATOM   6712  N   THR D  74      20.933  34.873  36.162  1.00 20.34           N  
ATOM   6713  CA  THR D  74      22.007  34.653  37.150  1.00 20.28           C  
ATOM   6714  C   THR D  74      23.099  33.664  36.690  1.00 20.32           C  
ATOM   6715  O   THR D  74      24.043  33.397  37.442  1.00 20.31           O  
ATOM   6716  CB  THR D  74      21.464  34.258  38.551  1.00 20.60           C  
ATOM   6717  OG1 THR D  74      22.522  34.355  39.517  1.00 21.09           O  
ATOM   6718  CG2 THR D  74      20.910  32.838  38.549  1.00 20.11           C  
ATOM   6719  N   SER D  75      22.953  33.119  35.476  1.00 19.78           N  
ATOM   6720  CA  SER D  75      24.012  32.330  34.800  1.00 20.64           C  
ATOM   6721  C   SER D  75      24.762  31.300  35.685  1.00 20.75           C  
ATOM   6722  O   SER D  75      26.005  31.318  35.790  1.00 21.01           O  
ATOM   6723  CB  SER D  75      25.001  33.267  34.091  1.00 21.53           C  
ATOM   6724  OG  SER D  75      25.737  32.581  33.075  1.00 22.46           O  
ATOM   6725  N   ASN D  76      23.992  30.399  36.286  1.00 20.40           N  
ATOM   6726  CA  ASN D  76      24.513  29.315  37.150  1.00 20.53           C  
ATOM   6727  C   ASN D  76      25.213  29.817  38.409  1.00 20.54           C  
ATOM   6728  O   ASN D  76      25.968  29.070  39.045  1.00 20.42           O  
ATOM   6729  CB  ASN D  76      25.399  28.320  36.374  1.00 20.88           C  
ATOM   6730  CG  ASN D  76      24.587  27.231  35.683  1.00 21.82           C  
ATOM   6731  OD1 ASN D  76      23.360  27.294  35.644  1.00 23.49           O  
ATOM   6732  ND2 ASN D  76      25.273  26.245  35.112  1.00 23.57           N  
ATOM   6733  N   GLY D  77      24.958  31.076  38.764  1.00 20.48           N  
ATOM   6734  CA  GLY D  77      25.542  31.681  39.970  1.00 20.74           C  
ATOM   6735  C   GLY D  77      24.648  31.695  41.206  1.00 20.81           C  
ATOM   6736  O   GLY D  77      24.955  32.367  42.196  1.00 20.96           O  
ATOM   6737  N   TRP D  78      23.533  30.967  41.155  1.00 21.62           N  
ATOM   6738  CA  TRP D  78      22.682  30.734  42.327  1.00 21.80           C  
ATOM   6739  C   TRP D  78      22.164  31.994  43.041  1.00 21.82           C  
ATOM   6740  O   TRP D  78      21.944  31.977  44.253  1.00 22.12           O  
ATOM   6741  CB  TRP D  78      23.383  29.768  43.304  1.00 21.90           C  
ATOM   6742  CG  TRP D  78      23.256  28.385  42.810  1.00 22.21           C  
ATOM   6743  CD1 TRP D  78      24.013  27.781  41.846  1.00 23.37           C  
ATOM   6744  CD2 TRP D  78      22.255  27.443  43.186  1.00 23.37           C  
ATOM   6745  NE1 TRP D  78      23.551  26.508  41.611  1.00 23.36           N  
ATOM   6746  CE2 TRP D  78      22.473  26.276  42.423  1.00 23.17           C  
ATOM   6747  CE3 TRP D  78      21.199  27.464  44.111  1.00 23.69           C  
ATOM   6748  CZ2 TRP D  78      21.668  25.141  42.548  1.00 22.27           C  
ATOM   6749  CZ3 TRP D  78      20.403  26.343  44.232  1.00 22.91           C  
ATOM   6750  CH2 TRP D  78      20.643  25.194  43.454  1.00 22.42           C  
ATOM   6751  N   TYR D  79      21.974  33.089  42.294  1.00 21.60           N  
ATOM   6752  CA  TYR D  79      21.447  34.332  42.886  1.00 21.49           C  
ATOM   6753  C   TYR D  79      22.266  34.720  44.117  1.00 20.99           C  
ATOM   6754  O   TYR D  79      21.730  35.202  45.121  1.00 21.10           O  
ATOM   6755  CB  TYR D  79      19.943  34.182  43.218  1.00 21.54           C  
ATOM   6756  CG  TYR D  79      19.156  33.769  41.997  1.00 21.55           C  
ATOM   6757  CD1 TYR D  79      18.787  34.711  41.047  1.00 20.53           C  
ATOM   6758  CD2 TYR D  79      18.818  32.427  41.770  1.00 20.75           C  
ATOM   6759  CE1 TYR D  79      18.091  34.344  39.890  1.00 22.94           C  
ATOM   6760  CE2 TYR D  79      18.117  32.048  40.622  1.00 21.69           C  
ATOM   6761  CZ  TYR D  79      17.751  33.010  39.694  1.00 21.69           C  
ATOM   6762  OH  TYR D  79      17.069  32.654  38.550  1.00 23.62           O  
ATOM   6763  N   THR D  80      23.579  34.518  44.007  1.00 20.76           N  
ATOM   6764  CA  THR D  80      24.513  34.679  45.122  1.00 20.93           C  
ATOM   6765  C   THR D  80      25.709  35.531  44.694  1.00 21.05           C  
ATOM   6766  O   THR D  80      26.179  35.433  43.561  1.00 20.90           O  
ATOM   6767  CB  THR D  80      24.989  33.285  45.629  1.00 20.88           C  
ATOM   6768  OG1 THR D  80      23.848  32.532  46.059  1.00 21.01           O  
ATOM   6769  CG2 THR D  80      25.980  33.399  46.799  1.00 22.23           C  
ATOM   6770  N   ASP D  81      26.172  36.392  45.592  1.00 20.80           N  
ATOM   6771  CA  ASP D  81      27.456  37.046  45.382  1.00 21.20           C  
ATOM   6772  C   ASP D  81      28.540  35.993  45.626  1.00 21.23           C  
ATOM   6773  O   ASP D  81      28.830  35.630  46.777  1.00 21.56           O  
ATOM   6774  CB  ASP D  81      27.623  38.257  46.305  1.00 21.10           C  
ATOM   6775  CG  ASP D  81      26.791  39.459  45.873  1.00 21.66           C  
ATOM   6776  OD1 ASP D  81      26.064  39.404  44.849  1.00 19.39           O  
ATOM   6777  OD2 ASP D  81      26.879  40.493  46.566  1.00 21.76           O  
ATOM   6778  N   THR D  82      29.127  35.519  44.524  1.00 21.13           N  
ATOM   6779  CA  THR D  82      29.966  34.312  44.487  1.00 21.29           C  
ATOM   6780  C   THR D  82      31.380  34.514  45.035  1.00 21.03           C  
ATOM   6781  O   THR D  82      31.822  35.645  45.228  1.00 21.45           O  
ATOM   6782  CB  THR D  82      30.101  33.775  43.047  1.00 21.41           C  
ATOM   6783  OG1 THR D  82      30.905  34.672  42.269  1.00 22.28           O  
ATOM   6784  CG2 THR D  82      28.732  33.613  42.380  1.00 20.74           C  
ATOM   6785  N   GLN D  83      32.092  33.409  45.234  1.00 20.97           N  
ATOM   6786  CA  GLN D  83      33.474  33.438  45.732  1.00 20.72           C  
ATOM   6787  C   GLN D  83      34.462  33.876  44.657  1.00 20.67           C  
ATOM   6788  O   GLN D  83      35.622  34.151  44.950  1.00 20.72           O  
ATOM   6789  CB  GLN D  83      33.890  32.059  46.252  1.00 21.29           C  
ATOM   6790  CG  GLN D  83      33.067  31.548  47.423  1.00 21.48           C  
ATOM   6791  CD  GLN D  83      33.301  32.336  48.691  1.00 24.48           C  
ATOM   6792  OE1 GLN D  83      32.391  32.993  49.201  1.00 25.61           O  
ATOM   6793  NE2 GLN D  83      34.525  32.286  49.207  1.00 24.67           N  
ATOM   6794  N   TYR D  84      33.994  33.928  43.415  1.00 20.28           N  
ATOM   6795  CA  TYR D  84      34.870  34.219  42.294  1.00 20.09           C  
ATOM   6796  C   TYR D  84      34.647  35.612  41.681  1.00 20.07           C  
ATOM   6797  O   TYR D  84      35.034  35.870  40.546  1.00 19.78           O  
ATOM   6798  CB  TYR D  84      34.787  33.098  41.245  1.00 20.09           C  
ATOM   6799  CG  TYR D  84      33.405  32.832  40.692  1.00 19.60           C  
ATOM   6800  CD1 TYR D  84      32.937  33.526  39.578  1.00 19.91           C  
ATOM   6801  CD2 TYR D  84      32.576  31.859  41.258  1.00 19.93           C  
ATOM   6802  CE1 TYR D  84      31.670  33.285  39.053  1.00 17.58           C  
ATOM   6803  CE2 TYR D  84      31.300  31.600  40.726  1.00 20.07           C  
ATOM   6804  CZ  TYR D  84      30.859  32.322  39.628  1.00 19.64           C  
ATOM   6805  OH  TYR D  84      29.607  32.090  39.093  1.00 18.95           O  
ATOM   6806  N   GLY D  85      34.028  36.508  42.452  1.00 20.36           N  
ATOM   6807  CA  GLY D  85      33.955  37.921  42.076  1.00 20.34           C  
ATOM   6808  C   GLY D  85      32.776  38.367  41.223  1.00 20.49           C  
ATOM   6809  O   GLY D  85      32.777  39.493  40.716  1.00 20.65           O  
ATOM   6810  N   PHE D  86      31.776  37.500  41.070  1.00 20.27           N  
ATOM   6811  CA  PHE D  86      30.559  37.835  40.325  1.00 20.10           C  
ATOM   6812  C   PHE D  86      29.424  38.069  41.308  1.00 20.22           C  
ATOM   6813  O   PHE D  86      28.923  37.121  41.911  1.00 20.39           O  
ATOM   6814  CB  PHE D  86      30.165  36.705  39.360  1.00 20.12           C  
ATOM   6815  CG  PHE D  86      30.983  36.658  38.096  1.00 19.80           C  
ATOM   6816  CD1 PHE D  86      30.389  36.876  36.856  1.00 20.73           C  
ATOM   6817  CD2 PHE D  86      32.351  36.371  38.144  1.00 19.32           C  
ATOM   6818  CE1 PHE D  86      31.148  36.810  35.681  1.00 21.50           C  
ATOM   6819  CE2 PHE D  86      33.106  36.301  36.990  1.00 20.67           C  
ATOM   6820  CZ  PHE D  86      32.505  36.523  35.751  1.00 21.26           C  
ATOM   6821  N   ASP D  87      29.022  39.330  41.467  1.00 20.30           N  
ATOM   6822  CA  ASP D  87      28.024  39.697  42.472  1.00 20.68           C  
ATOM   6823  C   ASP D  87      26.598  39.581  41.941  1.00 20.29           C  
ATOM   6824  O   ASP D  87      25.907  40.578  41.752  1.00 20.00           O  
ATOM   6825  CB  ASP D  87      28.287  41.102  43.011  1.00 20.95           C  
ATOM   6826  CG  ASP D  87      29.534  41.170  43.861  1.00 22.71           C  
ATOM   6827  OD1 ASP D  87      29.870  40.156  44.506  1.00 24.07           O  
ATOM   6828  OD2 ASP D  87      30.166  42.244  43.885  1.00 24.01           O  
ATOM   6829  N   TYR D  88      26.159  38.341  41.747  1.00 20.13           N  
ATOM   6830  CA  TYR D  88      24.855  38.076  41.163  1.00 20.11           C  
ATOM   6831  C   TYR D  88      23.697  38.487  42.066  1.00 20.24           C  
ATOM   6832  O   TYR D  88      22.666  38.950  41.566  1.00 20.87           O  
ATOM   6833  CB  TYR D  88      24.727  36.599  40.797  1.00 19.68           C  
ATOM   6834  CG  TYR D  88      25.527  36.176  39.590  1.00 19.47           C  
ATOM   6835  CD1 TYR D  88      25.265  36.716  38.324  1.00 19.04           C  
ATOM   6836  CD2 TYR D  88      26.509  35.191  39.698  1.00 19.16           C  
ATOM   6837  CE1 TYR D  88      25.999  36.306  37.204  1.00 18.85           C  
ATOM   6838  CE2 TYR D  88      27.231  34.769  38.587  1.00 18.63           C  
ATOM   6839  CZ  TYR D  88      26.972  35.331  37.349  1.00 18.86           C  
ATOM   6840  OH  TYR D  88      27.679  34.910  36.255  1.00 19.27           O  
ATOM   6841  N   TYR D  89      23.851  38.320  43.381  1.00 20.53           N  
ATOM   6842  CA  TYR D  89      22.771  38.707  44.279  1.00 20.72           C  
ATOM   6843  C   TYR D  89      22.576  40.217  44.187  1.00 20.57           C  
ATOM   6844  O   TYR D  89      21.460  40.691  43.981  1.00 21.45           O  
ATOM   6845  CB  TYR D  89      23.011  38.284  45.735  1.00 21.13           C  
ATOM   6846  CG  TYR D  89      21.977  38.900  46.653  1.00 22.62           C  
ATOM   6847  CD1 TYR D  89      20.722  38.305  46.821  1.00 24.32           C  
ATOM   6848  CD2 TYR D  89      22.228  40.106  47.307  1.00 24.26           C  
ATOM   6849  CE1 TYR D  89      19.763  38.880  47.649  1.00 24.39           C  
ATOM   6850  CE2 TYR D  89      21.279  40.688  48.130  1.00 25.29           C  
ATOM   6851  CZ  TYR D  89      20.052  40.069  48.295  1.00 24.85           C  
ATOM   6852  OH  TYR D  89      19.113  40.657  49.105  1.00 25.86           O  
ATOM   6853  N   THR D  90      23.667  40.961  44.326  1.00 19.57           N  
ATOM   6854  CA  THR D  90      23.625  42.424  44.288  1.00 19.29           C  
ATOM   6855  C   THR D  90      23.077  42.904  42.932  1.00 19.43           C  
ATOM   6856  O   THR D  90      22.252  43.820  42.877  1.00 19.28           O  
ATOM   6857  CB  THR D  90      25.025  43.022  44.562  1.00 18.88           C  
ATOM   6858  OG1 THR D  90      25.467  42.629  45.880  1.00 18.66           O  
ATOM   6859  CG2 THR D  90      24.996  44.551  44.477  1.00 19.37           C  
ATOM   6860  N   ALA D  91      23.534  42.275  41.848  1.00 19.27           N  
ATOM   6861  CA  ALA D  91      23.121  42.670  40.501  1.00 20.03           C  
ATOM   6862  C   ALA D  91      21.610  42.532  40.325  1.00 20.40           C  
ATOM   6863  O   ALA D  91      20.980  43.320  39.609  1.00 20.45           O  
ATOM   6864  CB  ALA D  91      23.837  41.827  39.451  1.00 19.77           C  
ATOM   6865  N   LEU D  92      21.033  41.511  40.946  1.00 21.24           N  
ATOM   6866  CA  LEU D  92      19.632  41.196  40.690  1.00 22.47           C  
ATOM   6867  C   LEU D  92      18.672  41.732  41.774  1.00 23.02           C  
ATOM   6868  O   LEU D  92      17.550  42.143  41.470  1.00 23.42           O  
ATOM   6869  CB  LEU D  92      19.465  39.689  40.400  1.00 22.95           C  
ATOM   6870  CG  LEU D  92      20.276  39.134  39.196  1.00 24.03           C  
ATOM   6871  CD1 LEU D  92      20.114  37.629  39.023  1.00 25.53           C  
ATOM   6872  CD2 LEU D  92      20.007  39.847  37.858  1.00 24.80           C  
ATOM   6873  N   ALA D  93      19.116  41.754  43.029  1.00 22.94           N  
ATOM   6874  CA  ALA D  93      18.290  42.289  44.119  1.00 23.32           C  
ATOM   6875  C   ALA D  93      18.289  43.814  44.168  1.00 23.32           C  
ATOM   6876  O   ALA D  93      17.291  44.420  44.567  1.00 23.67           O  
ATOM   6877  CB  ALA D  93      18.733  41.717  45.461  1.00 23.28           C  
ATOM   6878  N   GLU D  94      19.406  44.429  43.770  1.00 23.49           N  
ATOM   6879  CA  GLU D  94      19.596  45.871  43.920  1.00 23.96           C  
ATOM   6880  C   GLU D  94      19.629  46.595  42.583  1.00 23.38           C  
ATOM   6881  O   GLU D  94      18.820  47.497  42.339  1.00 22.83           O  
ATOM   6882  CB  GLU D  94      20.883  46.186  44.700  1.00 24.66           C  
ATOM   6883  CG  GLU D  94      20.993  45.554  46.099  1.00 28.45           C  
ATOM   6884  CD  GLU D  94      19.928  46.034  47.070  1.00 33.08           C  
ATOM   6885  OE1 GLU D  94      19.586  47.238  47.051  1.00 35.31           O  
ATOM   6886  OE2 GLU D  94      19.438  45.204  47.868  1.00 35.16           O  
ATOM   6887  N   GLU D  95      20.549  46.184  41.712  1.00 22.26           N  
ATOM   6888  CA  GLU D  95      20.787  46.907  40.465  1.00 22.27           C  
ATOM   6889  C   GLU D  95      19.654  46.773  39.440  1.00 21.63           C  
ATOM   6890  O   GLU D  95      19.192  47.776  38.883  1.00 21.07           O  
ATOM   6891  CB  GLU D  95      22.129  46.495  39.851  1.00 22.12           C  
ATOM   6892  CG  GLU D  95      22.459  47.192  38.538  1.00 23.05           C  
ATOM   6893  CD  GLU D  95      23.718  46.649  37.895  1.00 22.98           C  
ATOM   6894  OE1 GLU D  95      24.724  47.386  37.841  1.00 24.07           O  
ATOM   6895  OE2 GLU D  95      23.706  45.477  37.478  1.00 22.29           O  
ATOM   6896  N   LEU D  96      19.207  45.548  39.177  1.00 21.42           N  
ATOM   6897  CA  LEU D  96      18.163  45.366  38.159  1.00 21.43           C  
ATOM   6898  C   LEU D  96      16.874  46.185  38.402  1.00 21.36           C  
ATOM   6899  O   LEU D  96      16.393  46.869  37.479  1.00 20.74           O  
ATOM   6900  CB  LEU D  96      17.863  43.878  37.931  1.00 21.49           C  
ATOM   6901  CG  LEU D  96      16.888  43.608  36.783  1.00 21.82           C  
ATOM   6902  CD1 LEU D  96      17.419  44.087  35.417  1.00 21.26           C  
ATOM   6903  CD2 LEU D  96      16.551  42.132  36.745  1.00 22.62           C  
ATOM   6904  N   PRO D  97      16.319  46.145  39.636  1.00 21.78           N  
ATOM   6905  CA  PRO D  97      15.151  46.979  39.946  1.00 21.52           C  
ATOM   6906  C   PRO D  97      15.395  48.469  39.670  1.00 21.52           C  
ATOM   6907  O   PRO D  97      14.499  49.148  39.180  1.00 21.40           O  
ATOM   6908  CB  PRO D  97      14.909  46.720  41.441  1.00 21.84           C  
ATOM   6909  CG  PRO D  97      15.513  45.398  41.703  1.00 22.51           C  
ATOM   6910  CD  PRO D  97      16.711  45.315  40.794  1.00 21.52           C  
ATOM   6911  N   GLN D  98      16.595  48.962  39.970  1.00 21.36           N  
ATOM   6912  CA  GLN D  98      16.931  50.370  39.737  1.00 22.28           C  
ATOM   6913  C   GLN D  98      16.976  50.658  38.238  1.00 21.47           C  
ATOM   6914  O   GLN D  98      16.455  51.672  37.769  1.00 21.30           O  
ATOM   6915  CB  GLN D  98      18.272  50.713  40.378  1.00 22.40           C  
ATOM   6916  CG  GLN D  98      18.313  50.472  41.877  1.00 25.39           C  
ATOM   6917  CD  GLN D  98      19.722  50.565  42.462  1.00 26.98           C  
ATOM   6918  OE1 GLN D  98      20.713  50.690  41.728  1.00 31.42           O  
ATOM   6919  NE2 GLN D  98      19.815  50.484  43.781  1.00 30.38           N  
ATOM   6920  N   VAL D  99      17.619  49.763  37.496  1.00 21.14           N  
ATOM   6921  CA  VAL D  99      17.710  49.887  36.042  1.00 21.37           C  
ATOM   6922  C   VAL D  99      16.315  49.909  35.421  1.00 21.51           C  
ATOM   6923  O   VAL D  99      15.994  50.793  34.625  1.00 21.57           O  
ATOM   6924  CB  VAL D  99      18.570  48.752  35.442  1.00 21.44           C  
ATOM   6925  CG1 VAL D  99      18.378  48.632  33.915  1.00 21.34           C  
ATOM   6926  CG2 VAL D  99      20.021  48.955  35.780  1.00 21.41           C  
ATOM   6927  N   LEU D 100      15.483  48.953  35.805  1.00 21.56           N  
ATOM   6928  CA  LEU D 100      14.139  48.862  35.229  1.00 22.16           C  
ATOM   6929  C   LEU D 100      13.207  50.014  35.598  1.00 22.24           C  
ATOM   6930  O   LEU D 100      12.424  50.457  34.762  1.00 22.70           O  
ATOM   6931  CB  LEU D 100      13.513  47.499  35.543  1.00 22.07           C  
ATOM   6932  CG  LEU D 100      14.287  46.322  34.945  1.00 23.03           C  
ATOM   6933  CD1 LEU D 100      13.679  45.035  35.436  1.00 24.87           C  
ATOM   6934  CD2 LEU D 100      14.321  46.366  33.425  1.00 23.35           C  
ATOM   6935  N   LYS D 101      13.291  50.494  36.840  1.00 22.64           N  
ATOM   6936  CA  LYS D 101      12.459  51.615  37.281  1.00 23.07           C  
ATOM   6937  C   LYS D 101      12.811  52.882  36.513  1.00 22.61           C  
ATOM   6938  O   LYS D 101      11.945  53.718  36.244  1.00 22.49           O  
ATOM   6939  CB  LYS D 101      12.591  51.847  38.791  1.00 23.31           C  
ATOM   6940  CG  LYS D 101      11.560  52.818  39.388  1.00 25.27           C  
ATOM   6941  CD  LYS D 101      10.104  52.348  39.169  1.00 27.81           C  
ATOM   6942  CE  LYS D 101       9.108  53.171  40.010  1.00 27.94           C  
ATOM   6943  NZ  LYS D 101       9.186  54.637  39.730  1.00 29.51           N  
ATOM   6944  N   ARG D 102      14.083  53.017  36.150  1.00 22.30           N  
ATOM   6945  CA  ARG D 102      14.511  54.114  35.294  1.00 22.02           C  
ATOM   6946  C   ARG D 102      13.883  54.038  33.894  1.00 21.17           C  
ATOM   6947  O   ARG D 102      13.402  55.041  33.391  1.00 21.25           O  
ATOM   6948  CB  ARG D 102      16.037  54.197  35.228  1.00 22.46           C  
ATOM   6949  CG  ARG D 102      16.511  55.439  34.548  1.00 24.19           C  
ATOM   6950  CD  ARG D 102      18.003  55.631  34.632  1.00 27.41           C  
ATOM   6951  NE  ARG D 102      18.374  56.553  33.567  1.00 29.22           N  
ATOM   6952  CZ  ARG D 102      18.698  56.171  32.336  1.00 30.48           C  
ATOM   6953  NH1 ARG D 102      18.730  54.878  32.027  1.00 29.88           N  
ATOM   6954  NH2 ARG D 102      18.993  57.079  31.416  1.00 31.63           N  
ATOM   6955  N   PHE D 103      13.866  52.855  33.281  1.00 20.38           N  
ATOM   6956  CA  PHE D 103      13.173  52.673  32.000  1.00 19.89           C  
ATOM   6957  C   PHE D 103      11.659  52.812  32.139  1.00 19.62           C  
ATOM   6958  O   PHE D 103      11.009  53.431  31.301  1.00 18.86           O  
ATOM   6959  CB  PHE D 103      13.448  51.291  31.388  1.00 20.17           C  
ATOM   6960  CG  PHE D 103      14.903  51.006  31.089  1.00 20.45           C  
ATOM   6961  CD1 PHE D 103      15.778  52.017  30.695  1.00 22.54           C  
ATOM   6962  CD2 PHE D 103      15.377  49.698  31.157  1.00 21.78           C  
ATOM   6963  CE1 PHE D 103      17.120  51.732  30.420  1.00 22.26           C  
ATOM   6964  CE2 PHE D 103      16.722  49.400  30.878  1.00 21.75           C  
ATOM   6965  CZ  PHE D 103      17.586  50.415  30.504  1.00 20.93           C  
ATOM   6966  N   PHE D 104      11.110  52.210  33.190  1.00 19.76           N  
ATOM   6967  CA  PHE D 104       9.671  52.020  33.307  1.00 20.13           C  
ATOM   6968  C   PHE D 104       9.142  52.605  34.614  1.00 20.32           C  
ATOM   6969  O   PHE D 104       8.825  51.845  35.539  1.00 20.62           O  
ATOM   6970  CB  PHE D 104       9.312  50.525  33.244  1.00 19.93           C  
ATOM   6971  CG  PHE D 104       9.917  49.798  32.078  1.00 20.97           C  
ATOM   6972  CD1 PHE D 104       9.590  50.153  30.772  1.00 20.65           C  
ATOM   6973  CD2 PHE D 104      10.806  48.741  32.289  1.00 22.74           C  
ATOM   6974  CE1 PHE D 104      10.160  49.491  29.690  1.00 22.70           C  
ATOM   6975  CE2 PHE D 104      11.375  48.057  31.214  1.00 22.84           C  
ATOM   6976  CZ  PHE D 104      11.056  48.436  29.911  1.00 21.81           C  
ATOM   6977  N   PRO D 105       9.046  53.949  34.698  1.00 20.80           N  
ATOM   6978  CA  PRO D 105       8.535  54.617  35.904  1.00 21.14           C  
ATOM   6979  C   PRO D 105       7.120  54.204  36.327  1.00 21.54           C  
ATOM   6980  O   PRO D 105       6.762  54.401  37.487  1.00 21.79           O  
ATOM   6981  CB  PRO D 105       8.549  56.103  35.520  1.00 21.31           C  
ATOM   6982  CG  PRO D 105       9.541  56.210  34.442  1.00 22.11           C  
ATOM   6983  CD  PRO D 105       9.470  54.927  33.676  1.00 21.02           C  
ATOM   6984  N   ASN D 106       6.324  53.640  35.418  1.00 21.65           N  
ATOM   6985  CA  ASN D 106       4.958  53.232  35.782  1.00 22.21           C  
ATOM   6986  C   ASN D 106       4.891  51.892  36.512  1.00 22.70           C  
ATOM   6987  O   ASN D 106       3.818  51.481  36.980  1.00 21.91           O  
ATOM   6988  CB  ASN D 106       4.022  53.225  34.573  1.00 22.11           C  
ATOM   6989  CG  ASN D 106       3.656  54.622  34.100  1.00 22.94           C  
ATOM   6990  OD1 ASN D 106       3.731  55.594  34.851  1.00 22.42           O  
ATOM   6991  ND2 ASN D 106       3.255  54.723  32.840  1.00 25.38           N  
HETATM 6992  N   MSE D 107       6.032  51.213  36.603  1.00 23.32           N  
HETATM 6993  CA  MSE D 107       6.136  49.999  37.398  1.00 25.74           C  
HETATM 6994  C   MSE D 107       5.990  50.387  38.861  1.00 24.43           C  
HETATM 6995  O   MSE D 107       6.515  51.417  39.285  1.00 23.81           O  
HETATM 6996  CB  MSE D 107       7.491  49.329  37.183  1.00 26.17           C  
HETATM 6997  CG  MSE D 107       7.521  47.850  37.549  1.00 28.43           C  
HETATM 6998 SE   MSE D 107       9.301  47.039  37.419  1.00 39.55          SE  
HETATM 6999  CE  MSE D 107      10.219  48.449  36.516  1.00 14.50           C  
ATOM   7000  N   THR D 108       5.273  49.565  39.622  1.00 24.39           N  
ATOM   7001  CA  THR D 108       5.042  49.833  41.040  1.00 24.13           C  
ATOM   7002  C   THR D 108       6.337  49.855  41.849  1.00 24.44           C  
ATOM   7003  O   THR D 108       7.300  49.171  41.514  1.00 24.48           O  
ATOM   7004  CB  THR D 108       4.072  48.797  41.671  1.00 24.21           C  
ATOM   7005  OG1 THR D 108       3.643  49.264  42.962  1.00 24.22           O  
ATOM   7006  CG2 THR D 108       4.737  47.436  41.818  1.00 22.78           C  
ATOM   7007  N   SER D 109       6.354  50.651  42.912  1.00 24.98           N  
ATOM   7008  CA  SER D 109       7.430  50.570  43.892  1.00 25.32           C  
ATOM   7009  C   SER D 109       6.876  50.113  45.248  1.00 25.17           C  
ATOM   7010  O   SER D 109       7.539  50.251  46.278  1.00 25.58           O  
ATOM   7011  CB  SER D 109       8.170  51.904  44.007  1.00 25.57           C  
ATOM   7012  OG  SER D 109       7.270  52.964  44.244  1.00 26.56           O  
ATOM   7013  N   LYS D 110       5.665  49.553  45.221  1.00 24.67           N  
ATOM   7014  CA  LYS D 110       4.965  49.115  46.433  1.00 24.69           C  
ATOM   7015  C   LYS D 110       5.109  47.611  46.661  1.00 24.22           C  
ATOM   7016  O   LYS D 110       4.907  46.818  45.744  1.00 24.35           O  
ATOM   7017  CB  LYS D 110       3.482  49.481  46.359  1.00 24.85           C  
ATOM   7018  CG  LYS D 110       3.202  50.968  46.305  1.00 25.64           C  
ATOM   7019  CD  LYS D 110       1.724  51.222  46.087  1.00 27.19           C  
ATOM   7020  CE  LYS D 110       1.466  52.662  45.713  1.00 28.27           C  
ATOM   7021  NZ  LYS D 110       0.018  52.844  45.428  1.00 30.13           N  
ATOM   7022  N   ARG D 111       5.449  47.245  47.899  1.00 23.80           N  
ATOM   7023  CA  ARG D 111       5.632  45.844  48.304  1.00 23.24           C  
ATOM   7024  C   ARG D 111       4.400  44.985  48.042  1.00 22.97           C  
ATOM   7025  O   ARG D 111       4.523  43.835  47.628  1.00 22.34           O  
ATOM   7026  CB  ARG D 111       5.995  45.773  49.790  1.00 23.55           C  
ATOM   7027  CG  ARG D 111       6.297  44.365  50.294  1.00 23.79           C  
ATOM   7028  CD  ARG D 111       6.670  44.379  51.755  1.00 23.72           C  
ATOM   7029  NE  ARG D 111       7.186  43.090  52.203  1.00 23.31           N  
ATOM   7030  CZ  ARG D 111       7.682  42.870  53.418  1.00 24.52           C  
ATOM   7031  NH1 ARG D 111       7.737  43.856  54.310  1.00 21.91           N  
ATOM   7032  NH2 ARG D 111       8.133  41.668  53.739  1.00 24.77           N  
ATOM   7033  N   GLU D 112       3.216  45.548  48.296  1.00 22.94           N  
ATOM   7034  CA  GLU D 112       1.947  44.830  48.150  1.00 23.46           C  
ATOM   7035  C   GLU D 112       1.585  44.518  46.699  1.00 23.12           C  
ATOM   7036  O   GLU D 112       0.652  43.737  46.438  1.00 23.36           O  
ATOM   7037  CB  GLU D 112       0.799  45.589  48.832  1.00 24.00           C  
ATOM   7038  CG  GLU D 112       0.985  47.096  48.910  1.00 26.19           C  
ATOM   7039  CD  GLU D 112       2.019  47.509  49.948  1.00 28.14           C  
ATOM   7040  OE1 GLU D 112       1.967  47.012  51.097  1.00 31.40           O  
ATOM   7041  OE2 GLU D 112       2.887  48.333  49.612  1.00 28.98           O  
ATOM   7042  N   LYS D 113       2.324  45.122  45.766  1.00 22.67           N  
ATOM   7043  CA  LYS D 113       2.142  44.875  44.330  1.00 22.28           C  
ATOM   7044  C   LYS D 113       3.401  44.288  43.664  1.00 21.91           C  
ATOM   7045  O   LYS D 113       3.483  44.189  42.434  1.00 21.40           O  
ATOM   7046  CB  LYS D 113       1.706  46.163  43.627  1.00 22.56           C  
ATOM   7047  CG  LYS D 113       0.312  46.642  44.004  1.00 23.52           C  
ATOM   7048  CD  LYS D 113      -0.006  47.979  43.348  1.00 25.63           C  
ATOM   7049  CE  LYS D 113      -1.478  48.321  43.485  1.00 28.11           C  
ATOM   7050  NZ  LYS D 113      -1.848  49.476  42.615  1.00 30.70           N  
ATOM   7051  N   THR D 114       4.367  43.889  44.490  1.00 21.50           N  
ATOM   7052  CA  THR D 114       5.636  43.318  44.027  1.00 21.37           C  
ATOM   7053  C   THR D 114       5.790  41.841  44.419  1.00 21.31           C  
ATOM   7054  O   THR D 114       5.800  41.484  45.608  1.00 21.28           O  
ATOM   7055  CB  THR D 114       6.831  44.160  44.520  1.00 21.11           C  
ATOM   7056  OG1 THR D 114       6.642  45.522  44.113  1.00 21.12           O  
ATOM   7057  CG2 THR D 114       8.148  43.655  43.930  1.00 21.40           C  
ATOM   7058  N   PHE D 115       5.898  40.982  43.407  1.00 21.05           N  
ATOM   7059  CA  PHE D 115       5.882  39.532  43.621  1.00 21.03           C  
ATOM   7060  C   PHE D 115       7.107  38.844  43.021  1.00 20.92           C  
ATOM   7061  O   PHE D 115       7.807  39.416  42.182  1.00 20.23           O  
ATOM   7062  CB  PHE D 115       4.608  38.915  43.039  1.00 20.93           C  
ATOM   7063  CG  PHE D 115       3.396  39.801  43.136  1.00 21.25           C  
ATOM   7064  CD1 PHE D 115       2.891  40.183  44.384  1.00 21.25           C  
ATOM   7065  CD2 PHE D 115       2.751  40.240  41.981  1.00 20.59           C  
ATOM   7066  CE1 PHE D 115       1.778  41.005  44.476  1.00 22.11           C  
ATOM   7067  CE2 PHE D 115       1.627  41.061  42.062  1.00 21.03           C  
ATOM   7068  CZ  PHE D 115       1.137  41.440  43.314  1.00 21.86           C  
ATOM   7069  N   ILE D 116       7.361  37.616  43.462  1.00 20.69           N  
ATOM   7070  CA  ILE D 116       8.498  36.847  42.961  1.00 20.86           C  
ATOM   7071  C   ILE D 116       8.171  35.353  42.896  1.00 20.74           C  
ATOM   7072  O   ILE D 116       7.403  34.843  43.706  1.00 21.21           O  
ATOM   7073  CB  ILE D 116       9.807  37.165  43.761  1.00 20.99           C  
ATOM   7074  CG1 ILE D 116      11.046  36.544  43.095  1.00 21.25           C  
ATOM   7075  CG2 ILE D 116       9.663  36.809  45.241  1.00 20.87           C  
ATOM   7076  CD1 ILE D 116      12.359  37.224  43.449  1.00 21.53           C  
ATOM   7077  N   ALA D 117       8.714  34.679  41.883  1.00 20.95           N  
ATOM   7078  CA  ALA D 117       8.554  33.226  41.733  1.00 20.77           C  
ATOM   7079  C   ALA D 117       9.758  32.653  41.007  1.00 20.66           C  
ATOM   7080  O   ALA D 117      10.378  33.331  40.181  1.00 19.94           O  
ATOM   7081  CB  ALA D 117       7.271  32.882  40.967  1.00 21.24           C  
ATOM   7082  N   GLY D 118      10.091  31.406  41.309  1.00 20.26           N  
ATOM   7083  CA  GLY D 118      11.174  30.730  40.601  1.00 20.96           C  
ATOM   7084  C   GLY D 118      11.065  29.223  40.704  1.00 21.41           C  
ATOM   7085  O   GLY D 118      10.444  28.705  41.635  1.00 21.81           O  
ATOM   7086  N   LEU D 119      11.686  28.524  39.758  1.00 21.49           N  
ATOM   7087  CA  LEU D 119      11.750  27.056  39.813  1.00 22.18           C  
ATOM   7088  C   LEU D 119      13.167  26.560  40.147  1.00 22.85           C  
ATOM   7089  O   LEU D 119      14.154  27.145  39.686  1.00 22.56           O  
ATOM   7090  CB  LEU D 119      11.219  26.437  38.505  1.00 22.18           C  
ATOM   7091  CG  LEU D 119      11.979  26.476  37.165  1.00 22.03           C  
ATOM   7092  CD1 LEU D 119      12.511  27.875  36.835  1.00 22.12           C  
ATOM   7093  CD2 LEU D 119      13.111  25.466  37.115  1.00 22.52           C  
ATOM   7094  N   SER D 120      13.257  25.490  40.947  1.00 23.63           N  
ATOM   7095  CA  SER D 120      14.539  24.814  41.264  1.00 24.30           C  
ATOM   7096  C   SER D 120      15.569  25.752  41.930  1.00 24.12           C  
ATOM   7097  O   SER D 120      15.319  26.255  43.025  1.00 24.07           O  
ATOM   7098  CB  SER D 120      15.094  24.145  39.998  1.00 24.48           C  
ATOM   7099  OG  SER D 120      15.840  22.981  40.307  1.00 27.33           O  
HETATM 7100  N   MSE D 121      16.705  25.992  41.273  1.00 23.83           N  
HETATM 7101  CA  MSE D 121      17.646  27.039  41.706  1.00 23.71           C  
HETATM 7102  C   MSE D 121      16.936  28.384  41.880  1.00 22.86           C  
HETATM 7103  O   MSE D 121      17.230  29.144  42.820  1.00 23.22           O  
HETATM 7104  CB  MSE D 121      18.805  27.182  40.705  1.00 23.59           C  
HETATM 7105  CG  MSE D 121      19.781  28.319  41.029  1.00 24.49           C  
HETATM 7106 SE   MSE D 121      21.220  28.522  39.704  1.00 26.14          SE  
HETATM 7107  CE  MSE D 121      20.174  29.350  38.304  1.00 25.00           C  
ATOM   7108  N   GLY D 122      16.009  28.679  40.967  1.00 21.77           N  
ATOM   7109  CA  GLY D 122      15.170  29.870  41.058  1.00 21.72           C  
ATOM   7110  C   GLY D 122      14.229  29.877  42.255  1.00 21.68           C  
ATOM   7111  O   GLY D 122      13.822  30.939  42.717  1.00 21.33           O  
ATOM   7112  N   GLY D 123      13.878  28.692  42.755  1.00 21.34           N  
ATOM   7113  CA  GLY D 123      13.064  28.577  43.963  1.00 21.61           C  
ATOM   7114  C   GLY D 123      13.854  29.030  45.173  1.00 21.76           C  
ATOM   7115  O   GLY D 123      13.347  29.783  45.998  1.00 22.02           O  
ATOM   7116  N   TYR D 124      15.102  28.578  45.264  1.00 21.97           N  
ATOM   7117  CA  TYR D 124      16.017  29.053  46.303  1.00 22.13           C  
ATOM   7118  C   TYR D 124      16.232  30.571  46.196  1.00 22.19           C  
ATOM   7119  O   TYR D 124      16.073  31.299  47.186  1.00 21.90           O  
ATOM   7120  CB  TYR D 124      17.353  28.301  46.225  1.00 22.34           C  
ATOM   7121  CG  TYR D 124      18.447  28.898  47.085  1.00 22.41           C  
ATOM   7122  CD1 TYR D 124      18.527  28.607  48.452  1.00 22.98           C  
ATOM   7123  CD2 TYR D 124      19.411  29.746  46.528  1.00 21.73           C  
ATOM   7124  CE1 TYR D 124      19.532  29.157  49.248  1.00 22.83           C  
ATOM   7125  CE2 TYR D 124      20.414  30.299  47.304  1.00 21.54           C  
ATOM   7126  CZ  TYR D 124      20.469  29.998  48.664  1.00 22.30           C  
ATOM   7127  OH  TYR D 124      21.459  30.545  49.434  1.00 21.95           O  
ATOM   7128  N   GLY D 125      16.584  31.037  44.999  1.00 21.78           N  
ATOM   7129  CA  GLY D 125      16.816  32.463  44.746  1.00 21.59           C  
ATOM   7130  C   GLY D 125      15.611  33.318  45.098  1.00 21.41           C  
ATOM   7131  O   GLY D 125      15.747  34.384  45.711  1.00 21.46           O  
ATOM   7132  N   CYS D 126      14.425  32.831  44.733  1.00 21.43           N  
ATOM   7133  CA  CYS D 126      13.177  33.524  45.029  1.00 21.75           C  
ATOM   7134  C   CYS D 126      12.973  33.718  46.531  1.00 21.52           C  
ATOM   7135  O   CYS D 126      12.690  34.827  46.986  1.00 21.12           O  
ATOM   7136  CB  CYS D 126      11.985  32.762  44.457  1.00 21.62           C  
ATOM   7137  SG  CYS D 126      10.402  33.364  45.072  1.00 22.76           S  
ATOM   7138  N   PHE D 127      13.103  32.636  47.289  1.00 21.74           N  
ATOM   7139  CA  PHE D 127      12.936  32.713  48.742  1.00 22.47           C  
ATOM   7140  C   PHE D 127      14.037  33.558  49.383  1.00 22.73           C  
ATOM   7141  O   PHE D 127      13.758  34.367  50.260  1.00 22.91           O  
ATOM   7142  CB  PHE D 127      12.847  31.311  49.355  1.00 22.13           C  
ATOM   7143  CG  PHE D 127      11.456  30.718  49.330  1.00 23.31           C  
ATOM   7144  CD1 PHE D 127      11.105  29.709  50.224  1.00 23.66           C  
ATOM   7145  CD2 PHE D 127      10.495  31.177  48.429  1.00 23.58           C  
ATOM   7146  CE1 PHE D 127       9.822  29.154  50.210  1.00 23.66           C  
ATOM   7147  CE2 PHE D 127       9.211  30.634  48.412  1.00 24.80           C  
ATOM   7148  CZ  PHE D 127       8.873  29.621  49.301  1.00 24.04           C  
ATOM   7149  N   LYS D 128      15.273  33.403  48.909  1.00 23.29           N  
ATOM   7150  CA  LYS D 128      16.387  34.217  49.382  1.00 23.78           C  
ATOM   7151  C   LYS D 128      16.117  35.713  49.224  1.00 24.08           C  
ATOM   7152  O   LYS D 128      16.270  36.477  50.179  1.00 24.51           O  
ATOM   7153  CB  LYS D 128      17.688  33.842  48.669  1.00 23.84           C  
ATOM   7154  CG  LYS D 128      18.859  34.740  49.068  1.00 23.55           C  
ATOM   7155  CD  LYS D 128      20.128  34.382  48.339  1.00 24.76           C  
ATOM   7156  CE  LYS D 128      21.256  35.277  48.813  1.00 25.23           C  
ATOM   7157  NZ  LYS D 128      22.451  35.073  47.981  1.00 26.83           N  
ATOM   7158  N   LEU D 129      15.724  36.129  48.019  1.00 24.25           N  
ATOM   7159  CA  LEU D 129      15.413  37.538  47.770  1.00 24.14           C  
ATOM   7160  C   LEU D 129      14.213  38.013  48.601  1.00 24.12           C  
ATOM   7161  O   LEU D 129      14.214  39.132  49.108  1.00 23.56           O  
ATOM   7162  CB  LEU D 129      15.230  37.815  46.267  1.00 24.63           C  
ATOM   7163  CG  LEU D 129      16.514  38.284  45.558  1.00 25.03           C  
ATOM   7164  CD1 LEU D 129      17.491  37.131  45.346  1.00 26.12           C  
ATOM   7165  CD2 LEU D 129      16.193  38.950  44.224  1.00 27.76           C  
ATOM   7166  N   ALA D 130      13.210  37.154  48.757  1.00 23.79           N  
ATOM   7167  CA  ALA D 130      12.030  37.486  49.558  1.00 24.38           C  
ATOM   7168  C   ALA D 130      12.398  37.744  51.020  1.00 24.73           C  
ATOM   7169  O   ALA D 130      11.936  38.717  51.620  1.00 25.28           O  
ATOM   7170  CB  ALA D 130      10.992  36.381  49.464  1.00 23.82           C  
ATOM   7171  N   LEU D 131      13.231  36.866  51.572  1.00 25.02           N  
ATOM   7172  CA  LEU D 131      13.637  36.931  52.977  1.00 25.41           C  
ATOM   7173  C   LEU D 131      14.627  38.057  53.280  1.00 25.70           C  
ATOM   7174  O   LEU D 131      14.576  38.646  54.364  1.00 25.57           O  
ATOM   7175  CB  LEU D 131      14.225  35.590  53.429  1.00 25.43           C  
ATOM   7176  CG  LEU D 131      13.295  34.369  53.449  1.00 25.39           C  
ATOM   7177  CD1 LEU D 131      14.090  33.101  53.696  1.00 25.71           C  
ATOM   7178  CD2 LEU D 131      12.181  34.517  54.472  1.00 26.12           C  
ATOM   7179  N   THR D 132      15.521  38.346  52.334  1.00 26.06           N  
ATOM   7180  CA  THR D 132      16.593  39.326  52.557  1.00 26.20           C  
ATOM   7181  C   THR D 132      16.210  40.772  52.229  1.00 26.21           C  
ATOM   7182  O   THR D 132      16.756  41.705  52.821  1.00 26.53           O  
ATOM   7183  CB  THR D 132      17.879  38.983  51.754  1.00 26.16           C  
ATOM   7184  OG1 THR D 132      17.584  38.993  50.355  1.00 27.71           O  
ATOM   7185  CG2 THR D 132      18.434  37.620  52.129  1.00 26.45           C  
ATOM   7186  N   THR D 133      15.296  40.968  51.278  1.00 26.04           N  
ATOM   7187  CA  THR D 133      14.971  42.331  50.831  1.00 25.99           C  
ATOM   7188  C   THR D 133      13.795  42.954  51.575  1.00 25.80           C  
ATOM   7189  O   THR D 133      13.762  44.173  51.777  1.00 25.90           O  
ATOM   7190  CB  THR D 133      14.656  42.412  49.317  1.00 25.77           C  
ATOM   7191  OG1 THR D 133      13.511  41.604  49.018  1.00 25.63           O  
ATOM   7192  CG2 THR D 133      15.849  41.964  48.469  1.00 26.11           C  
ATOM   7193  N   ASN D 134      12.827  42.120  51.955  1.00 25.57           N  
ATOM   7194  CA  ASN D 134      11.536  42.582  52.487  1.00 25.65           C  
ATOM   7195  C   ASN D 134      10.799  43.537  51.535  1.00 25.67           C  
ATOM   7196  O   ASN D 134      10.054  44.422  51.971  1.00 25.54           O  
ATOM   7197  CB  ASN D 134      11.705  43.204  53.884  1.00 25.83           C  
ATOM   7198  CG  ASN D 134      12.312  42.233  54.878  1.00 26.35           C  
ATOM   7199  OD1 ASN D 134      11.785  41.143  55.100  1.00 26.28           O  
ATOM   7200  ND2 ASN D 134      13.422  42.629  55.486  1.00 27.50           N  
ATOM   7201  N   ARG D 135      11.019  43.344  50.233  1.00 25.30           N  
ATOM   7202  CA  ARG D 135      10.420  44.180  49.192  1.00 25.32           C  
ATOM   7203  C   ARG D 135       9.313  43.472  48.404  1.00 24.77           C  
ATOM   7204  O   ARG D 135       8.718  44.063  47.500  1.00 24.55           O  
ATOM   7205  CB  ARG D 135      11.500  44.702  48.236  1.00 25.35           C  
ATOM   7206  CG  ARG D 135      12.438  45.727  48.862  1.00 26.64           C  
ATOM   7207  CD  ARG D 135      13.614  46.042  47.940  1.00 29.02           C  
ATOM   7208  NE  ARG D 135      14.839  46.208  48.719  1.00 33.51           N  
ATOM   7209  CZ  ARG D 135      16.055  45.873  48.296  1.00 35.76           C  
ATOM   7210  NH1 ARG D 135      17.102  46.054  49.093  1.00 37.54           N  
ATOM   7211  NH2 ARG D 135      16.227  45.355  47.084  1.00 37.40           N  
ATOM   7212  N   PHE D 136       9.045  42.213  48.757  1.00 23.97           N  
ATOM   7213  CA  PHE D 136       8.012  41.403  48.108  1.00 23.76           C  
ATOM   7214  C   PHE D 136       6.882  41.027  49.077  1.00 23.41           C  
ATOM   7215  O   PHE D 136       7.129  40.812  50.271  1.00 23.86           O  
ATOM   7216  CB  PHE D 136       8.622  40.122  47.518  1.00 23.84           C  
ATOM   7217  CG  PHE D 136       9.745  40.368  46.535  1.00 23.55           C  
ATOM   7218  CD1 PHE D 136       9.477  40.538  45.179  1.00 23.09           C  
ATOM   7219  CD2 PHE D 136      11.069  40.417  46.970  1.00 24.12           C  
ATOM   7220  CE1 PHE D 136      10.511  40.758  44.278  1.00 23.40           C  
ATOM   7221  CE2 PHE D 136      12.106  40.641  46.077  1.00 24.89           C  
ATOM   7222  CZ  PHE D 136      11.828  40.811  44.726  1.00 24.12           C  
ATOM   7223  N   SER D 137       5.655  40.944  48.561  1.00 23.03           N  
ATOM   7224  CA  SER D 137       4.491  40.522  49.363  1.00 22.84           C  
ATOM   7225  C   SER D 137       4.156  39.045  49.177  1.00 22.81           C  
ATOM   7226  O   SER D 137       3.618  38.403  50.078  1.00 23.01           O  
ATOM   7227  CB  SER D 137       3.261  41.374  49.040  1.00 22.83           C  
ATOM   7228  OG  SER D 137       2.991  41.381  47.646  1.00 22.46           O  
ATOM   7229  N   HIS D 138       4.470  38.518  47.995  1.00 22.52           N  
ATOM   7230  CA  HIS D 138       4.207  37.123  47.671  1.00 22.29           C  
ATOM   7231  C   HIS D 138       5.441  36.539  46.993  1.00 22.41           C  
ATOM   7232  O   HIS D 138       6.077  37.213  46.186  1.00 21.69           O  
ATOM   7233  CB  HIS D 138       3.004  37.010  46.738  1.00 22.64           C  
ATOM   7234  CG  HIS D 138       1.727  37.511  47.331  1.00 22.97           C  
ATOM   7235  ND1 HIS D 138       0.779  36.672  47.875  1.00 24.65           N  
ATOM   7236  CD2 HIS D 138       1.234  38.766  47.457  1.00 24.08           C  
ATOM   7237  CE1 HIS D 138      -0.242  37.387  48.313  1.00 24.67           C  
ATOM   7238  NE2 HIS D 138       0.012  38.661  48.076  1.00 24.72           N  
ATOM   7239  N   ALA D 139       5.778  35.300  47.341  1.00 22.18           N  
ATOM   7240  CA  ALA D 139       6.975  34.644  46.820  1.00 22.25           C  
ATOM   7241  C   ALA D 139       6.695  33.164  46.640  1.00 22.50           C  
ATOM   7242  O   ALA D 139       6.288  32.492  47.593  1.00 22.00           O  
ATOM   7243  CB  ALA D 139       8.148  34.851  47.767  1.00 22.78           C  
ATOM   7244  N   ALA D 140       6.918  32.662  45.425  1.00 22.34           N  
ATOM   7245  CA  ALA D 140       6.597  31.267  45.097  1.00 22.50           C  
ATOM   7246  C   ALA D 140       7.798  30.465  44.620  1.00 22.42           C  
ATOM   7247  O   ALA D 140       8.616  30.942  43.827  1.00 22.42           O  
ATOM   7248  CB  ALA D 140       5.491  31.198  44.072  1.00 22.51           C  
ATOM   7249  N   SER D 141       7.882  29.230  45.106  1.00 22.21           N  
ATOM   7250  CA  SER D 141       8.937  28.311  44.716  1.00 22.22           C  
ATOM   7251  C   SER D 141       8.293  27.075  44.087  1.00 21.85           C  
ATOM   7252  O   SER D 141       7.356  26.509  44.647  1.00 21.22           O  
ATOM   7253  CB  SER D 141       9.770  27.948  45.953  1.00 22.54           C  
ATOM   7254  OG  SER D 141      10.651  26.864  45.709  1.00 23.68           O  
ATOM   7255  N   PHE D 142       8.766  26.700  42.896  1.00 21.68           N  
ATOM   7256  CA  PHE D 142       8.306  25.493  42.227  1.00 21.98           C  
ATOM   7257  C   PHE D 142       9.460  24.498  42.197  1.00 22.27           C  
ATOM   7258  O   PHE D 142      10.474  24.744  41.541  1.00 21.30           O  
ATOM   7259  CB  PHE D 142       7.809  25.797  40.800  1.00 22.31           C  
ATOM   7260  CG  PHE D 142       6.999  27.069  40.684  1.00 22.70           C  
ATOM   7261  CD1 PHE D 142       5.799  27.222  41.390  1.00 24.41           C  
ATOM   7262  CD2 PHE D 142       7.424  28.101  39.857  1.00 22.74           C  
ATOM   7263  CE1 PHE D 142       5.049  28.399  41.284  1.00 24.47           C  
ATOM   7264  CE2 PHE D 142       6.684  29.270  39.733  1.00 23.20           C  
ATOM   7265  CZ  PHE D 142       5.493  29.421  40.450  1.00 23.58           C  
ATOM   7266  N   SER D 143       9.312  23.388  42.928  1.00 21.96           N  
ATOM   7267  CA  SER D 143      10.365  22.360  43.052  1.00 22.63           C  
ATOM   7268  C   SER D 143      11.729  22.990  43.377  1.00 23.20           C  
ATOM   7269  O   SER D 143      12.754  22.684  42.747  1.00 23.71           O  
ATOM   7270  CB  SER D 143      10.440  21.499  41.783  1.00 22.17           C  
ATOM   7271  OG  SER D 143       9.146  21.106  41.357  1.00 21.63           O  
ATOM   7272  N   GLY D 144      11.722  23.883  44.360  1.00 23.65           N  
ATOM   7273  CA  GLY D 144      12.903  24.654  44.718  1.00 24.05           C  
ATOM   7274  C   GLY D 144      13.985  23.849  45.404  1.00 24.22           C  
ATOM   7275  O   GLY D 144      13.703  22.875  46.121  1.00 24.47           O  
ATOM   7276  N   ALA D 145      15.230  24.262  45.177  1.00 24.71           N  
ATOM   7277  CA  ALA D 145      16.382  23.695  45.870  1.00 25.32           C  
ATOM   7278  C   ALA D 145      16.486  24.372  47.235  1.00 25.57           C  
ATOM   7279  O   ALA D 145      17.385  25.172  47.486  1.00 25.59           O  
ATOM   7280  CB  ALA D 145      17.646  23.910  45.055  1.00 25.24           C  
ATOM   7281  N   LEU D 146      15.552  24.033  48.120  1.00 25.86           N  
ATOM   7282  CA  LEU D 146      15.320  24.833  49.324  1.00 26.16           C  
ATOM   7283  C   LEU D 146      16.207  24.467  50.511  1.00 26.61           C  
ATOM   7284  O   LEU D 146      16.263  25.212  51.493  1.00 26.55           O  
ATOM   7285  CB  LEU D 146      13.832  24.813  49.705  1.00 26.29           C  
ATOM   7286  CG  LEU D 146      12.808  25.363  48.699  1.00 26.37           C  
ATOM   7287  CD1 LEU D 146      11.459  25.519  49.383  1.00 26.92           C  
ATOM   7288  CD2 LEU D 146      13.241  26.695  48.070  1.00 26.18           C  
ATOM   7289  N   SER D 147      16.894  23.330  50.418  1.00 27.03           N  
ATOM   7290  CA  SER D 147      17.865  22.918  51.430  1.00 27.79           C  
ATOM   7291  C   SER D 147      18.890  21.964  50.831  1.00 28.18           C  
ATOM   7292  O   SER D 147      18.546  21.128  49.993  1.00 28.68           O  
ATOM   7293  CB  SER D 147      17.165  22.245  52.616  1.00 27.57           C  
ATOM   7294  OG  SER D 147      18.103  21.902  53.619  1.00 27.74           O  
ATOM   7295  N   PHE D 148      20.141  22.104  51.253  1.00 28.52           N  
ATOM   7296  CA  PHE D 148      21.200  21.163  50.894  1.00 29.26           C  
ATOM   7297  C   PHE D 148      21.622  20.318  52.099  1.00 29.84           C  
ATOM   7298  O   PHE D 148      22.661  19.653  52.069  1.00 30.01           O  
ATOM   7299  CB  PHE D 148      22.421  21.903  50.332  1.00 29.17           C  
ATOM   7300  CG  PHE D 148      22.224  22.442  48.941  1.00 29.40           C  
ATOM   7301  CD1 PHE D 148      22.300  21.606  47.830  1.00 30.46           C  
ATOM   7302  CD2 PHE D 148      21.974  23.797  48.740  1.00 30.02           C  
ATOM   7303  CE1 PHE D 148      22.125  22.116  46.539  1.00 30.16           C  
ATOM   7304  CE2 PHE D 148      21.795  24.311  47.453  1.00 29.46           C  
ATOM   7305  CZ  PHE D 148      21.870  23.469  46.358  1.00 29.48           C  
ATOM   7306  N   GLN D 149      20.814  20.347  53.157  1.00 30.33           N  
ATOM   7307  CA  GLN D 149      21.158  19.646  54.399  1.00 31.29           C  
ATOM   7308  C   GLN D 149      21.154  18.130  54.202  1.00 31.90           C  
ATOM   7309  O   GLN D 149      21.949  17.419  54.824  1.00 32.27           O  
ATOM   7310  CB  GLN D 149      20.215  20.047  55.541  1.00 31.00           C  
ATOM   7311  CG  GLN D 149      20.668  19.575  56.936  1.00 31.40           C  
ATOM   7312  CD  GLN D 149      22.089  20.007  57.278  1.00 31.81           C  
ATOM   7313  OE1 GLN D 149      22.457  21.176  57.131  1.00 32.09           O  
ATOM   7314  NE2 GLN D 149      22.897  19.057  57.728  1.00 32.09           N  
ATOM   7315  N   ASN D 150      20.272  17.656  53.327  1.00 32.57           N  
ATOM   7316  CA  ASN D 150      20.067  16.225  53.112  1.00 33.40           C  
ATOM   7317  C   ASN D 150      20.287  15.795  51.665  1.00 33.64           C  
ATOM   7318  O   ASN D 150      20.501  16.626  50.777  1.00 34.11           O  
ATOM   7319  CB  ASN D 150      18.662  15.814  53.586  1.00 33.77           C  
ATOM   7320  CG  ASN D 150      17.549  16.680  52.981  1.00 34.81           C  
ATOM   7321  OD1 ASN D 150      17.808  17.700  52.329  1.00 36.46           O  
ATOM   7322  ND2 ASN D 150      16.303  16.275  53.204  1.00 35.74           N  
ATOM   7323  N   GLY D 159      26.977  19.036  39.416  1.00 32.34           N  
ATOM   7324  CA  GLY D 159      27.981  20.096  39.313  1.00 31.74           C  
ATOM   7325  C   GLY D 159      29.393  19.548  39.386  1.00 31.30           C  
ATOM   7326  O   GLY D 159      29.734  18.618  38.653  1.00 32.02           O  
ATOM   7327  N   SER D 160      30.210  20.149  40.255  1.00 30.35           N  
ATOM   7328  CA  SER D 160      31.561  19.679  40.594  1.00 29.21           C  
ATOM   7329  C   SER D 160      31.985  20.344  41.914  1.00 28.26           C  
ATOM   7330  O   SER D 160      31.454  21.406  42.256  1.00 28.15           O  
ATOM   7331  CB  SER D 160      32.568  19.992  39.472  1.00 29.28           C  
ATOM   7332  OG  SER D 160      33.046  21.333  39.525  1.00 29.09           O  
ATOM   7333  N   PRO D 161      32.911  19.718  42.681  1.00 27.49           N  
ATOM   7334  CA  PRO D 161      33.392  20.383  43.899  1.00 26.80           C  
ATOM   7335  C   PRO D 161      33.882  21.825  43.690  1.00 26.10           C  
ATOM   7336  O   PRO D 161      33.500  22.706  44.461  1.00 25.99           O  
ATOM   7337  CB  PRO D 161      34.526  19.467  44.373  1.00 27.06           C  
ATOM   7338  CG  PRO D 161      34.117  18.114  43.878  1.00 27.41           C  
ATOM   7339  CD  PRO D 161      33.507  18.376  42.525  1.00 27.28           C  
ATOM   7340  N   ALA D 162      34.687  22.069  42.653  1.00 25.37           N  
ATOM   7341  CA  ALA D 162      35.136  23.432  42.339  1.00 24.58           C  
ATOM   7342  C   ALA D 162      33.951  24.358  42.060  1.00 23.96           C  
ATOM   7343  O   ALA D 162      33.939  25.506  42.516  1.00 23.60           O  
ATOM   7344  CB  ALA D 162      36.115  23.438  41.170  1.00 24.70           C  
ATOM   7345  N   TYR D 163      32.948  23.853  41.337  1.00 23.42           N  
ATOM   7346  CA  TYR D 163      31.751  24.649  41.027  1.00 22.42           C  
ATOM   7347  C   TYR D 163      30.992  25.053  42.298  1.00 22.23           C  
ATOM   7348  O   TYR D 163      30.694  26.231  42.503  1.00 21.57           O  
ATOM   7349  CB  TYR D 163      30.819  23.921  40.038  1.00 22.49           C  
ATOM   7350  CG  TYR D 163      29.458  24.584  39.895  1.00 21.78           C  
ATOM   7351  CD1 TYR D 163      29.312  25.770  39.175  1.00 21.43           C  
ATOM   7352  CD2 TYR D 163      28.320  24.034  40.498  1.00 21.68           C  
ATOM   7353  CE1 TYR D 163      28.079  26.392  39.050  1.00 20.87           C  
ATOM   7354  CE2 TYR D 163      27.073  24.649  40.381  1.00 20.80           C  
ATOM   7355  CZ  TYR D 163      26.964  25.833  39.655  1.00 21.62           C  
ATOM   7356  OH  TYR D 163      25.750  26.460  39.514  1.00 21.71           O  
ATOM   7357  N   TRP D 164      30.697  24.080  43.158  1.00 21.95           N  
ATOM   7358  CA  TRP D 164      29.931  24.372  44.372  1.00 22.02           C  
ATOM   7359  C   TRP D 164      30.682  25.292  45.329  1.00 21.77           C  
ATOM   7360  O   TRP D 164      30.071  26.145  45.971  1.00 21.49           O  
ATOM   7361  CB  TRP D 164      29.431  23.082  45.043  1.00 22.12           C  
ATOM   7362  CG  TRP D 164      28.382  22.416  44.207  1.00 22.66           C  
ATOM   7363  CD1 TRP D 164      28.509  21.248  43.510  1.00 22.81           C  
ATOM   7364  CD2 TRP D 164      27.067  22.918  43.916  1.00 23.18           C  
ATOM   7365  NE1 TRP D 164      27.349  20.980  42.823  1.00 23.42           N  
ATOM   7366  CE2 TRP D 164      26.452  21.992  43.047  1.00 22.92           C  
ATOM   7367  CE3 TRP D 164      26.348  24.058  44.313  1.00 23.47           C  
ATOM   7368  CZ2 TRP D 164      25.144  22.155  42.586  1.00 22.67           C  
ATOM   7369  CZ3 TRP D 164      25.046  24.227  43.840  1.00 23.00           C  
ATOM   7370  CH2 TRP D 164      24.457  23.272  42.991  1.00 23.60           C  
ATOM   7371  N   ARG D 165      32.005  25.128  45.399  1.00 21.99           N  
ATOM   7372  CA  ARG D 165      32.879  26.006  46.188  1.00 22.18           C  
ATOM   7373  C   ARG D 165      32.829  27.444  45.664  1.00 21.83           C  
ATOM   7374  O   ARG D 165      32.856  28.399  46.444  1.00 21.50           O  
ATOM   7375  CB  ARG D 165      34.327  25.507  46.164  1.00 22.36           C  
ATOM   7376  CG  ARG D 165      34.613  24.296  47.045  1.00 24.23           C  
ATOM   7377  CD  ARG D 165      36.121  24.087  47.250  1.00 26.47           C  
ATOM   7378  NE  ARG D 165      36.820  23.661  46.035  1.00 30.48           N  
ATOM   7379  CZ  ARG D 165      37.055  22.396  45.697  1.00 31.72           C  
ATOM   7380  NH1 ARG D 165      36.647  21.399  46.472  1.00 33.94           N  
ATOM   7381  NH2 ARG D 165      37.698  22.126  44.571  1.00 33.40           N  
ATOM   7382  N   GLY D 166      32.752  27.584  44.340  1.00 21.34           N  
ATOM   7383  CA  GLY D 166      32.649  28.893  43.690  1.00 21.37           C  
ATOM   7384  C   GLY D 166      31.399  29.633  44.123  1.00 21.16           C  
ATOM   7385  O   GLY D 166      31.412  30.853  44.266  1.00 20.84           O  
ATOM   7386  N   VAL D 167      30.317  28.889  44.346  1.00 21.10           N  
ATOM   7387  CA  VAL D 167      29.060  29.477  44.792  1.00 21.38           C  
ATOM   7388  C   VAL D 167      29.059  29.772  46.300  1.00 22.33           C  
ATOM   7389  O   VAL D 167      28.872  30.926  46.714  1.00 22.58           O  
ATOM   7390  CB  VAL D 167      27.838  28.588  44.412  1.00 21.13           C  
ATOM   7391  CG1 VAL D 167      26.551  29.212  44.908  1.00 21.61           C  
ATOM   7392  CG2 VAL D 167      27.766  28.351  42.893  1.00 21.24           C  
ATOM   7393  N   PHE D 168      29.287  28.730  47.101  1.00 22.77           N  
ATOM   7394  CA  PHE D 168      29.040  28.757  48.548  1.00 23.63           C  
ATOM   7395  C   PHE D 168      30.294  28.699  49.430  1.00 24.39           C  
ATOM   7396  O   PHE D 168      30.193  28.781  50.665  1.00 24.72           O  
ATOM   7397  CB  PHE D 168      28.134  27.583  48.942  1.00 23.49           C  
ATOM   7398  CG  PHE D 168      26.774  27.604  48.307  1.00 23.48           C  
ATOM   7399  CD1 PHE D 168      25.876  28.636  48.566  1.00 23.36           C  
ATOM   7400  CD2 PHE D 168      26.376  26.565  47.469  1.00 23.49           C  
ATOM   7401  CE1 PHE D 168      24.608  28.640  47.979  1.00 24.48           C  
ATOM   7402  CE2 PHE D 168      25.108  26.559  46.893  1.00 23.92           C  
ATOM   7403  CZ  PHE D 168      24.228  27.599  47.144  1.00 23.31           C  
ATOM   7404  N   GLY D 169      31.465  28.548  48.815  1.00 25.11           N  
ATOM   7405  CA  GLY D 169      32.705  28.304  49.559  1.00 26.63           C  
ATOM   7406  C   GLY D 169      32.693  26.914  50.181  1.00 27.68           C  
ATOM   7407  O   GLY D 169      31.944  26.040  49.739  1.00 27.84           O  
ATOM   7408  N   GLU D 170      33.522  26.707  51.202  1.00 28.90           N  
ATOM   7409  CA  GLU D 170      33.506  25.457  51.955  1.00 30.29           C  
ATOM   7410  C   GLU D 170      32.327  25.457  52.925  1.00 30.71           C  
ATOM   7411  O   GLU D 170      32.178  26.386  53.724  1.00 31.05           O  
ATOM   7412  CB  GLU D 170      34.821  25.255  52.726  1.00 30.52           C  
ATOM   7413  CG  GLU D 170      36.107  25.379  51.892  1.00 32.51           C  
ATOM   7414  CD  GLU D 170      36.342  24.222  50.913  1.00 34.70           C  
ATOM   7415  OE1 GLU D 170      37.334  24.298  50.156  1.00 35.87           O  
ATOM   7416  OE2 GLU D 170      35.557  23.244  50.891  1.00 35.77           O  
ATOM   7417  N   ILE D 171      31.491  24.424  52.840  1.00 31.51           N  
ATOM   7418  CA  ILE D 171      30.322  24.290  53.720  1.00 31.98           C  
ATOM   7419  C   ILE D 171      30.452  23.076  54.655  1.00 32.16           C  
ATOM   7420  O   ILE D 171      30.645  21.945  54.207  1.00 32.35           O  
ATOM   7421  CB  ILE D 171      28.990  24.211  52.907  1.00 32.13           C  
ATOM   7422  CG1 ILE D 171      28.781  25.471  52.053  1.00 32.07           C  
ATOM   7423  CG2 ILE D 171      27.784  23.944  53.832  1.00 32.73           C  
ATOM   7424  CD1 ILE D 171      28.272  26.701  52.809  1.00 31.85           C  
ATOM   7425  N   ARG D 172      30.353  23.326  55.958  1.00 32.24           N  
ATOM   7426  CA  ARG D 172      30.361  22.252  56.947  1.00 32.42           C  
ATOM   7427  C   ARG D 172      28.931  21.764  57.150  1.00 32.41           C  
ATOM   7428  O   ARG D 172      28.599  20.617  56.829  1.00 32.99           O  
ATOM   7429  CB  ARG D 172      31.196  22.364  58.153  0.00 33.33           C  
ATOM   7430  CG  ARG D 172      30.517  21.771  59.377  0.00 29.96           C  
ATOM   7431  CD  ARG D 172      31.427  21.053  60.341  0.00 32.22           C  
ATOM   7432  NE  ARG D 172      31.454  21.727  61.659  0.00 33.77           N  
ATOM   7433  CZ  ARG D 172      30.637  21.537  62.704  0.00 34.84           C  
ATOM   7434  NH1 ARG D 172      29.676  20.610  62.642  0.00 35.34           N  
ATOM   7435  NH2 ARG D 172      30.783  22.274  63.808  0.00 35.16           N  
ATOM   7436  N   ASP D 173      28.094  22.648  57.681  1.00 32.04           N  
ATOM   7437  CA  ASP D 173      26.678  22.376  57.879  1.00 31.30           C  
ATOM   7438  C   ASP D 173      25.872  23.400  57.088  1.00 30.59           C  
ATOM   7439  O   ASP D 173      25.991  24.607  57.326  1.00 30.09           O  
ATOM   7440  CB  ASP D 173      26.335  22.451  59.368  1.00 31.61           C  
ATOM   7441  CG  ASP D 173      24.910  22.019  59.667  1.00 32.32           C  
ATOM   7442  OD1 ASP D 173      24.645  20.798  59.660  1.00 33.85           O  
ATOM   7443  OD2 ASP D 173      24.062  22.901  59.928  1.00 32.52           O  
ATOM   7444  N   TRP D 174      25.063  22.918  56.146  1.00 29.93           N  
ATOM   7445  CA  TRP D 174      24.264  23.800  55.299  1.00 29.24           C  
ATOM   7446  C   TRP D 174      23.342  24.704  56.111  1.00 29.01           C  
ATOM   7447  O   TRP D 174      23.367  25.928  55.950  1.00 28.69           O  
ATOM   7448  CB  TRP D 174      23.442  23.005  54.279  1.00 29.10           C  
ATOM   7449  CG  TRP D 174      22.421  23.860  53.575  1.00 28.62           C  
ATOM   7450  CD1 TRP D 174      21.075  23.907  53.818  1.00 28.25           C  
ATOM   7451  CD2 TRP D 174      22.673  24.814  52.535  1.00 28.05           C  
ATOM   7452  NE1 TRP D 174      20.473  24.823  52.985  1.00 28.29           N  
ATOM   7453  CE2 TRP D 174      21.433  25.393  52.189  1.00 28.44           C  
ATOM   7454  CE3 TRP D 174      23.827  25.231  51.861  1.00 27.59           C  
ATOM   7455  CZ2 TRP D 174      21.313  26.368  51.193  1.00 28.28           C  
ATOM   7456  CZ3 TRP D 174      23.706  26.198  50.869  1.00 28.24           C  
ATOM   7457  CH2 TRP D 174      22.457  26.756  50.548  1.00 28.12           C  
ATOM   7458  N   THR D 175      22.545  24.090  56.989  1.00 28.38           N  
ATOM   7459  CA  THR D 175      21.472  24.780  57.711  1.00 27.99           C  
ATOM   7460  C   THR D 175      21.981  25.914  58.605  1.00 27.73           C  
ATOM   7461  O   THR D 175      21.343  26.964  58.706  1.00 27.42           O  
ATOM   7462  CB  THR D 175      20.603  23.774  58.509  1.00 28.07           C  
ATOM   7463  OG1 THR D 175      20.071  22.794  57.605  1.00 27.98           O  
ATOM   7464  CG2 THR D 175      19.438  24.473  59.214  1.00 28.01           C  
ATOM   7465  N   THR D 176      23.138  25.703  59.219  1.00 27.47           N  
ATOM   7466  CA  THR D 176      23.738  26.706  60.096  1.00 27.23           C  
ATOM   7467  C   THR D 176      24.660  27.692  59.366  1.00 26.97           C  
ATOM   7468  O   THR D 176      25.124  28.667  59.961  1.00 26.85           O  
ATOM   7469  CB  THR D 176      24.477  26.049  61.284  1.00 27.36           C  
ATOM   7470  OG1 THR D 176      25.436  25.106  60.790  1.00 28.18           O  
ATOM   7471  CG2 THR D 176      23.482  25.334  62.197  1.00 27.06           C  
ATOM   7472  N   SER D 177      24.923  27.447  58.083  1.00 26.72           N  
ATOM   7473  CA  SER D 177      25.697  28.387  57.258  1.00 26.53           C  
ATOM   7474  C   SER D 177      24.829  29.593  56.883  1.00 26.29           C  
ATOM   7475  O   SER D 177      23.603  29.486  56.874  1.00 26.52           O  
ATOM   7476  CB  SER D 177      26.224  27.700  55.994  1.00 26.51           C  
ATOM   7477  OG  SER D 177      25.218  27.622  54.999  1.00 25.91           O  
ATOM   7478  N   PRO D 178      25.458  30.746  56.563  1.00 26.18           N  
ATOM   7479  CA  PRO D 178      24.680  31.943  56.221  1.00 25.84           C  
ATOM   7480  C   PRO D 178      23.887  31.819  54.915  1.00 25.31           C  
ATOM   7481  O   PRO D 178      23.084  32.698  54.600  1.00 24.90           O  
ATOM   7482  CB  PRO D 178      25.756  33.030  56.090  1.00 26.08           C  
ATOM   7483  CG  PRO D 178      26.994  32.289  55.738  1.00 26.49           C  
ATOM   7484  CD  PRO D 178      26.909  31.012  56.520  1.00 26.22           C  
ATOM   7485  N   TYR D 179      24.105  30.727  54.183  1.00 24.68           N  
ATOM   7486  CA  TYR D 179      23.502  30.511  52.868  1.00 24.37           C  
ATOM   7487  C   TYR D 179      22.143  29.815  52.916  1.00 23.83           C  
ATOM   7488  O   TYR D 179      21.387  29.858  51.943  1.00 22.97           O  
ATOM   7489  CB  TYR D 179      24.448  29.699  51.985  1.00 24.66           C  
ATOM   7490  CG  TYR D 179      25.753  30.394  51.680  1.00 24.80           C  
ATOM   7491  CD1 TYR D 179      25.820  31.394  50.710  1.00 25.10           C  
ATOM   7492  CD2 TYR D 179      26.921  30.046  52.352  1.00 25.07           C  
ATOM   7493  CE1 TYR D 179      27.020  32.035  50.425  1.00 26.48           C  
ATOM   7494  CE2 TYR D 179      28.121  30.679  52.076  1.00 25.56           C  
ATOM   7495  CZ  TYR D 179      28.164  31.673  51.108  1.00 26.00           C  
ATOM   7496  OH  TYR D 179      29.355  32.305  50.823  1.00 25.91           O  
ATOM   7497  N   SER D 180      21.830  29.178  54.040  1.00 23.16           N  
ATOM   7498  CA  SER D 180      20.557  28.468  54.161  1.00 22.85           C  
ATOM   7499  C   SER D 180      19.416  29.472  54.237  1.00 22.59           C  
ATOM   7500  O   SER D 180      19.610  30.590  54.699  1.00 22.57           O  
ATOM   7501  CB  SER D 180      20.544  27.565  55.401  1.00 22.59           C  
ATOM   7502  OG  SER D 180      20.546  28.330  56.599  1.00 22.92           O  
ATOM   7503  N   LEU D 181      18.231  29.066  53.786  1.00 22.88           N  
ATOM   7504  CA  LEU D 181      17.036  29.903  53.907  1.00 22.84           C  
ATOM   7505  C   LEU D 181      16.666  30.138  55.367  1.00 23.01           C  
ATOM   7506  O   LEU D 181      16.155  31.203  55.721  1.00 22.64           O  
ATOM   7507  CB  LEU D 181      15.860  29.300  53.130  1.00 22.73           C  
ATOM   7508  CG  LEU D 181      16.034  29.232  51.597  1.00 22.52           C  
ATOM   7509  CD1 LEU D 181      14.874  28.509  50.952  1.00 22.98           C  
ATOM   7510  CD2 LEU D 181      16.232  30.622  50.954  1.00 23.28           C  
ATOM   7511  N   GLU D 182      16.944  29.139  56.204  1.00 23.26           N  
ATOM   7512  CA  GLU D 182      16.759  29.237  57.652  1.00 23.81           C  
ATOM   7513  C   GLU D 182      17.580  30.386  58.255  1.00 24.07           C  
ATOM   7514  O   GLU D 182      17.085  31.135  59.095  1.00 23.78           O  
ATOM   7515  CB  GLU D 182      17.115  27.912  58.334  1.00 23.71           C  
ATOM   7516  CG  GLU D 182      16.189  26.732  57.990  1.00 24.72           C  
ATOM   7517  CD  GLU D 182      16.618  25.937  56.757  1.00 26.50           C  
ATOM   7518  OE1 GLU D 182      17.498  26.407  55.998  1.00 26.93           O  
ATOM   7519  OE2 GLU D 182      16.062  24.833  56.539  1.00 27.18           O  
ATOM   7520  N   SER D 183      18.829  30.517  57.815  1.00 24.33           N  
ATOM   7521  CA  SER D 183      19.707  31.584  58.290  1.00 24.93           C  
ATOM   7522  C   SER D 183      19.342  32.932  57.675  1.00 25.32           C  
ATOM   7523  O   SER D 183      19.390  33.962  58.353  1.00 25.46           O  
ATOM   7524  CB  SER D 183      21.172  31.241  58.013  1.00 24.73           C  
ATOM   7525  OG  SER D 183      21.564  30.069  58.710  1.00 25.41           O  
ATOM   7526  N   LEU D 184      18.980  32.922  56.393  1.00 25.32           N  
ATOM   7527  CA  LEU D 184      18.567  34.145  55.699  1.00 25.60           C  
ATOM   7528  C   LEU D 184      17.257  34.705  56.266  1.00 25.75           C  
ATOM   7529  O   LEU D 184      17.045  35.918  56.284  1.00 26.02           O  
ATOM   7530  CB  LEU D 184      18.453  33.893  54.190  1.00 25.51           C  
ATOM   7531  CG  LEU D 184      19.786  33.598  53.490  1.00 24.98           C  
ATOM   7532  CD1 LEU D 184      19.579  32.861  52.173  1.00 23.68           C  
ATOM   7533  CD2 LEU D 184      20.601  34.869  53.285  1.00 24.52           C  
ATOM   7534  N   ALA D 185      16.400  33.812  56.754  1.00 25.92           N  
ATOM   7535  CA  ALA D 185      15.110  34.182  57.334  1.00 26.23           C  
ATOM   7536  C   ALA D 185      15.235  35.188  58.486  1.00 26.82           C  
ATOM   7537  O   ALA D 185      14.277  35.900  58.805  1.00 26.82           O  
ATOM   7538  CB  ALA D 185      14.370  32.926  57.791  1.00 26.35           C  
ATOM   7539  N   LYS D 186      16.417  35.241  59.099  1.00 27.13           N  
ATOM   7540  CA  LYS D 186      16.705  36.188  60.186  1.00 27.63           C  
ATOM   7541  C   LYS D 186      16.619  37.638  59.714  1.00 27.77           C  
ATOM   7542  O   LYS D 186      16.370  38.541  60.511  1.00 27.59           O  
ATOM   7543  CB  LYS D 186      18.092  35.927  60.768  1.00 27.89           C  
ATOM   7544  CG  LYS D 186      18.223  34.605  61.502  1.00 28.39           C  
ATOM   7545  CD  LYS D 186      19.627  34.413  62.057  1.00 29.63           C  
ATOM   7546  CE  LYS D 186      19.665  33.304  63.099  1.00 30.60           C  
ATOM   7547  NZ  LYS D 186      19.148  31.996  62.588  1.00 31.07           N  
ATOM   7548  N   LYS D 187      16.829  37.845  58.415  1.00 27.76           N  
ATOM   7549  CA  LYS D 187      16.761  39.173  57.818  1.00 28.15           C  
ATOM   7550  C   LYS D 187      15.322  39.602  57.517  1.00 27.81           C  
ATOM   7551  O   LYS D 187      15.073  40.770  57.208  1.00 27.90           O  
ATOM   7552  CB  LYS D 187      17.607  39.227  56.546  1.00 28.35           C  
ATOM   7553  CG  LYS D 187      19.106  39.091  56.780  1.00 30.09           C  
ATOM   7554  CD  LYS D 187      19.849  38.950  55.456  1.00 32.02           C  
ATOM   7555  CE  LYS D 187      21.359  38.968  55.642  1.00 32.92           C  
ATOM   7556  NZ  LYS D 187      21.856  37.694  56.227  1.00 33.98           N  
ATOM   7557  N   SER D 188      14.386  38.662  57.634  1.00 27.54           N  
ATOM   7558  CA  SER D 188      12.996  38.890  57.247  1.00 27.40           C  
ATOM   7559  C   SER D 188      12.124  39.457  58.356  1.00 27.35           C  
ATOM   7560  O   SER D 188      12.229  39.049  59.522  1.00 27.25           O  
ATOM   7561  CB  SER D 188      12.376  37.595  56.706  1.00 27.48           C  
ATOM   7562  OG  SER D 188      11.036  37.791  56.283  1.00 27.35           O  
ATOM   7563  N   ASP D 189      11.256  40.394  57.976  1.00 27.35           N  
ATOM   7564  CA  ASP D 189      10.209  40.912  58.861  1.00 27.33           C  
ATOM   7565  C   ASP D 189       9.003  39.973  58.925  1.00 27.41           C  
ATOM   7566  O   ASP D 189       8.000  40.284  59.571  1.00 27.57           O  
ATOM   7567  CB  ASP D 189       9.779  42.333  58.456  1.00 27.34           C  
ATOM   7568  CG  ASP D 189       9.160  42.408  57.059  1.00 27.35           C  
ATOM   7569  OD1 ASP D 189       8.745  41.370  56.492  1.00 27.09           O  
ATOM   7570  OD2 ASP D 189       9.081  43.533  56.526  1.00 27.75           O  
ATOM   7571  N   LYS D 190       9.109  38.836  58.234  1.00 27.45           N  
ATOM   7572  CA  LYS D 190       8.079  37.787  58.208  1.00 27.68           C  
ATOM   7573  C   LYS D 190       6.744  38.241  57.595  1.00 27.40           C  
ATOM   7574  O   LYS D 190       5.726  37.568  57.758  1.00 27.62           O  
ATOM   7575  CB  LYS D 190       7.866  37.175  59.613  1.00 27.83           C  
ATOM   7576  CG  LYS D 190       9.155  36.712  60.287  1.00 28.51           C  
ATOM   7577  CD  LYS D 190       8.908  35.978  61.583  1.00 29.57           C  
ATOM   7578  CE  LYS D 190      10.226  35.700  62.282  1.00 30.39           C  
ATOM   7579  NZ  LYS D 190      10.019  35.041  63.585  1.00 32.22           N  
ATOM   7580  N   LYS D 191       6.758  39.363  56.874  1.00 27.10           N  
ATOM   7581  CA  LYS D 191       5.534  39.912  56.279  1.00 26.76           C  
ATOM   7582  C   LYS D 191       5.345  39.511  54.811  1.00 26.75           C  
ATOM   7583  O   LYS D 191       4.445  40.014  54.127  1.00 26.94           O  
ATOM   7584  CB  LYS D 191       5.474  41.439  56.459  1.00 26.64           C  
ATOM   7585  CG  LYS D 191       5.354  41.877  57.927  1.00 27.06           C  
ATOM   7586  CD  LYS D 191       5.093  43.370  58.083  1.00 27.75           C  
ATOM   7587  CE  LYS D 191       5.364  43.802  59.521  1.00 29.11           C  
ATOM   7588  NZ  LYS D 191       4.580  45.001  59.953  1.00 30.39           N  
ATOM   7589  N   THR D 192       6.192  38.600  54.337  1.00 26.24           N  
ATOM   7590  CA  THR D 192       6.067  38.057  52.982  1.00 25.63           C  
ATOM   7591  C   THR D 192       5.330  36.724  53.016  1.00 25.42           C  
ATOM   7592  O   THR D 192       5.680  35.827  53.792  1.00 25.42           O  
ATOM   7593  CB  THR D 192       7.442  37.872  52.306  1.00 25.78           C  
ATOM   7594  OG1 THR D 192       8.197  39.084  52.412  1.00 26.51           O  
ATOM   7595  CG2 THR D 192       7.278  37.504  50.820  1.00 25.48           C  
ATOM   7596  N   LYS D 193       4.290  36.612  52.196  1.00 25.04           N  
ATOM   7597  CA  LYS D 193       3.581  35.349  52.030  1.00 24.65           C  
ATOM   7598  C   LYS D 193       4.452  34.426  51.175  1.00 24.54           C  
ATOM   7599  O   LYS D 193       4.858  34.795  50.064  1.00 24.39           O  
ATOM   7600  CB  LYS D 193       2.214  35.572  51.372  1.00 24.50           C  
ATOM   7601  CG  LYS D 193       1.177  36.235  52.272  1.00 25.53           C  
ATOM   7602  CD  LYS D 193      -0.163  36.315  51.751  0.00 27.23           C  
ATOM   7603  CE  LYS D 193      -1.105  37.126  52.631  0.00 29.29           C  
ATOM   7604  NZ  LYS D 193      -2.307  37.570  51.868  0.00 30.80           N  
ATOM   7605  N   LEU D 194       4.771  33.251  51.710  1.00 24.23           N  
ATOM   7606  CA  LEU D 194       5.564  32.260  50.979  1.00 24.12           C  
ATOM   7607  C   LEU D 194       4.692  31.113  50.488  1.00 24.15           C  
ATOM   7608  O   LEU D 194       3.849  30.591  51.220  1.00 23.99           O  
ATOM   7609  CB  LEU D 194       6.710  31.713  51.830  1.00 24.15           C  
ATOM   7610  CG  LEU D 194       7.712  32.686  52.447  1.00 24.40           C  
ATOM   7611  CD1 LEU D 194       8.660  31.934  53.372  1.00 25.73           C  
ATOM   7612  CD2 LEU D 194       8.484  33.450  51.381  1.00 25.09           C  
ATOM   7613  N   TRP D 195       4.924  30.728  49.239  1.00 24.05           N  
ATOM   7614  CA  TRP D 195       4.128  29.727  48.561  1.00 24.23           C  
ATOM   7615  C   TRP D 195       5.093  28.731  47.932  1.00 24.31           C  
ATOM   7616  O   TRP D 195       6.053  29.122  47.266  1.00 24.33           O  
ATOM   7617  CB  TRP D 195       3.278  30.421  47.495  1.00 24.22           C  
ATOM   7618  CG  TRP D 195       2.190  29.612  46.884  1.00 24.83           C  
ATOM   7619  CD1 TRP D 195       0.856  29.676  47.183  1.00 26.18           C  
ATOM   7620  CD2 TRP D 195       2.320  28.638  45.838  1.00 25.28           C  
ATOM   7621  NE1 TRP D 195       0.150  28.795  46.398  1.00 26.23           N  
ATOM   7622  CE2 TRP D 195       1.024  28.145  45.563  1.00 25.84           C  
ATOM   7623  CE3 TRP D 195       3.408  28.129  45.109  1.00 25.72           C  
ATOM   7624  CZ2 TRP D 195       0.784  27.164  44.589  1.00 25.12           C  
ATOM   7625  CZ3 TRP D 195       3.169  27.155  44.145  1.00 25.38           C  
ATOM   7626  CH2 TRP D 195       1.864  26.679  43.898  1.00 25.41           C  
ATOM   7627  N   ALA D 196       4.856  27.441  48.160  1.00 24.16           N  
ATOM   7628  CA  ALA D 196       5.713  26.409  47.585  1.00 24.52           C  
ATOM   7629  C   ALA D 196       4.931  25.205  47.076  1.00 24.68           C  
ATOM   7630  O   ALA D 196       3.958  24.779  47.690  1.00 24.78           O  
ATOM   7631  CB  ALA D 196       6.782  25.970  48.576  1.00 24.23           C  
ATOM   7632  N   TRP D 197       5.363  24.685  45.933  1.00 24.90           N  
ATOM   7633  CA  TRP D 197       4.923  23.381  45.450  1.00 25.12           C  
ATOM   7634  C   TRP D 197       6.141  22.515  45.170  1.00 24.88           C  
ATOM   7635  O   TRP D 197       7.194  23.016  44.767  1.00 24.51           O  
ATOM   7636  CB  TRP D 197       4.071  23.499  44.180  1.00 25.38           C  
ATOM   7637  CG  TRP D 197       3.655  22.148  43.607  1.00 25.65           C  
ATOM   7638  CD1 TRP D 197       2.552  21.409  43.954  1.00 25.73           C  
ATOM   7639  CD2 TRP D 197       4.346  21.383  42.603  1.00 25.81           C  
ATOM   7640  NE1 TRP D 197       2.516  20.241  43.230  1.00 26.12           N  
ATOM   7641  CE2 TRP D 197       3.601  20.198  42.392  1.00 26.27           C  
ATOM   7642  CE3 TRP D 197       5.520  21.588  41.861  1.00 25.00           C  
ATOM   7643  CZ2 TRP D 197       3.991  19.220  41.469  1.00 24.92           C  
ATOM   7644  CZ3 TRP D 197       5.910  20.613  40.947  1.00 25.41           C  
ATOM   7645  CH2 TRP D 197       5.147  19.445  40.757  1.00 25.92           C  
ATOM   7646  N   CYS D 198       5.997  21.217  45.413  1.00 24.78           N  
ATOM   7647  CA  CYS D 198       6.962  20.232  44.942  1.00 25.04           C  
ATOM   7648  C   CYS D 198       6.263  18.940  44.526  1.00 25.16           C  
ATOM   7649  O   CYS D 198       5.283  18.518  45.154  1.00 25.37           O  
ATOM   7650  CB  CYS D 198       8.043  19.945  45.986  1.00 25.00           C  
ATOM   7651  SG  CYS D 198       9.440  19.013  45.300  1.00 25.61           S  
ATOM   7652  N   GLY D 199       6.772  18.321  43.465  1.00 25.01           N  
ATOM   7653  CA  GLY D 199       6.299  17.009  43.027  1.00 25.49           C  
ATOM   7654  C   GLY D 199       6.715  15.932  44.009  1.00 25.95           C  
ATOM   7655  O   GLY D 199       7.824  15.969  44.549  1.00 25.53           O  
ATOM   7656  N   GLU D 200       5.819  14.976  44.246  1.00 26.43           N  
ATOM   7657  CA  GLU D 200       6.074  13.904  45.206  1.00 27.16           C  
ATOM   7658  C   GLU D 200       7.051  12.860  44.666  1.00 27.66           C  
ATOM   7659  O   GLU D 200       7.572  12.039  45.422  1.00 27.93           O  
ATOM   7660  CB  GLU D 200       4.761  13.254  45.641  1.00 27.09           C  
ATOM   7661  CG  GLU D 200       3.880  14.171  46.479  1.00 27.36           C  
ATOM   7662  CD  GLU D 200       2.473  13.644  46.677  1.00 28.55           C  
ATOM   7663  OE1 GLU D 200       2.172  12.522  46.207  1.00 28.89           O  
ATOM   7664  OE2 GLU D 200       1.664  14.360  47.301  1.00 27.89           O  
ATOM   7665  N   GLN D 201       7.296  12.901  43.358  1.00 28.36           N  
ATOM   7666  CA  GLN D 201       8.302  12.056  42.725  1.00 28.81           C  
ATOM   7667  C   GLN D 201       9.530  12.871  42.293  1.00 29.18           C  
ATOM   7668  O   GLN D 201      10.290  12.455  41.413  1.00 29.74           O  
ATOM   7669  CB  GLN D 201       7.696  11.307  41.533  1.00 29.00           C  
ATOM   7670  CG  GLN D 201       6.705  10.204  41.923  1.00 29.95           C  
ATOM   7671  CD  GLN D 201       5.338  10.744  42.326  1.00 31.10           C  
ATOM   7672  OE1 GLN D 201       4.786  11.631  41.671  1.00 32.49           O  
ATOM   7673  NE2 GLN D 201       4.783  10.200  43.400  1.00 31.82           N  
ATOM   7674  N   ASP D 202       9.715  14.034  42.913  1.00 29.18           N  
ATOM   7675  CA  ASP D 202      10.865  14.897  42.635  1.00 29.30           C  
ATOM   7676  C   ASP D 202      11.992  14.564  43.601  1.00 29.70           C  
ATOM   7677  O   ASP D 202      11.748  14.328  44.786  1.00 29.49           O  
ATOM   7678  CB  ASP D 202      10.469  16.368  42.790  1.00 28.67           C  
ATOM   7679  CG  ASP D 202      11.487  17.332  42.182  1.00 28.70           C  
ATOM   7680  OD1 ASP D 202      12.683  17.301  42.543  1.00 28.08           O  
ATOM   7681  OD2 ASP D 202      11.063  18.156  41.361  1.00 27.28           O  
ATOM   7682  N   PHE D 203      13.229  14.568  43.101  1.00 30.28           N  
ATOM   7683  CA  PHE D 203      14.395  14.302  43.954  1.00 30.92           C  
ATOM   7684  C   PHE D 203      14.584  15.346  45.062  1.00 30.62           C  
ATOM   7685  O   PHE D 203      15.338  15.113  46.007  1.00 30.99           O  
ATOM   7686  CB  PHE D 203      15.683  14.122  43.127  1.00 31.42           C  
ATOM   7687  CG  PHE D 203      15.887  15.169  42.056  1.00 32.91           C  
ATOM   7688  CD1 PHE D 203      16.398  16.423  42.379  1.00 34.02           C  
ATOM   7689  CD2 PHE D 203      15.589  14.888  40.723  1.00 34.30           C  
ATOM   7690  CE1 PHE D 203      16.592  17.390  41.397  1.00 34.55           C  
ATOM   7691  CE2 PHE D 203      15.785  15.851  39.729  1.00 34.06           C  
ATOM   7692  CZ  PHE D 203      16.287  17.105  40.068  1.00 34.71           C  
ATOM   7693  N   LEU D 204      13.886  16.478  44.945  1.00 30.12           N  
ATOM   7694  CA  LEU D 204      13.954  17.559  45.935  1.00 29.71           C  
ATOM   7695  C   LEU D 204      12.747  17.584  46.879  1.00 29.31           C  
ATOM   7696  O   LEU D 204      12.590  18.519  47.672  1.00 29.09           O  
ATOM   7697  CB  LEU D 204      14.099  18.924  45.241  1.00 29.51           C  
ATOM   7698  CG  LEU D 204      15.392  19.268  44.494  1.00 29.45           C  
ATOM   7699  CD1 LEU D 204      15.200  20.552  43.709  1.00 29.07           C  
ATOM   7700  CD2 LEU D 204      16.590  19.389  45.435  1.00 29.46           C  
ATOM   7701  N   TYR D 205      11.901  16.558  46.808  1.00 28.99           N  
ATOM   7702  CA  TYR D 205      10.711  16.501  47.650  1.00 28.73           C  
ATOM   7703  C   TYR D 205      11.058  16.576  49.137  1.00 28.72           C  
ATOM   7704  O   TYR D 205      10.405  17.307  49.887  1.00 28.54           O  
ATOM   7705  CB  TYR D 205       9.873  15.254  47.336  1.00 28.44           C  
ATOM   7706  CG  TYR D 205       8.581  15.146  48.128  1.00 28.39           C  
ATOM   7707  CD1 TYR D 205       7.639  16.175  48.107  1.00 27.65           C  
ATOM   7708  CD2 TYR D 205       8.296  14.006  48.876  1.00 27.36           C  
ATOM   7709  CE1 TYR D 205       6.454  16.081  48.818  1.00 27.48           C  
ATOM   7710  CE2 TYR D 205       7.107  13.900  49.598  1.00 27.71           C  
ATOM   7711  CZ  TYR D 205       6.190  14.939  49.561  1.00 28.00           C  
ATOM   7712  OH  TYR D 205       5.015  14.851  50.270  1.00 28.00           O  
ATOM   7713  N   GLU D 206      12.094  15.847  49.547  1.00 28.81           N  
ATOM   7714  CA  GLU D 206      12.489  15.794  50.958  1.00 29.22           C  
ATOM   7715  C   GLU D 206      13.167  17.076  51.420  1.00 28.86           C  
ATOM   7716  O   GLU D 206      13.038  17.465  52.585  1.00 28.83           O  
ATOM   7717  CB  GLU D 206      13.382  14.584  51.239  1.00 29.46           C  
ATOM   7718  CG  GLU D 206      13.034  13.881  52.534  1.00 31.47           C  
ATOM   7719  CD  GLU D 206      11.575  13.443  52.579  1.00 34.01           C  
ATOM   7720  OE1 GLU D 206      10.857  13.873  53.511  1.00 34.61           O  
ATOM   7721  OE2 GLU D 206      11.146  12.689  51.673  1.00 35.35           O  
ATOM   7722  N   ALA D 207      13.889  17.726  50.508  1.00 28.55           N  
ATOM   7723  CA  ALA D 207      14.500  19.029  50.787  1.00 28.22           C  
ATOM   7724  C   ALA D 207      13.429  20.101  50.998  1.00 28.02           C  
ATOM   7725  O   ALA D 207      13.559  20.953  51.882  1.00 27.97           O  
ATOM   7726  CB  ALA D 207      15.449  19.429  49.673  1.00 28.18           C  
ATOM   7727  N   ASN D 208      12.374  20.050  50.187  1.00 27.62           N  
ATOM   7728  CA  ASN D 208      11.219  20.927  50.365  1.00 27.24           C  
ATOM   7729  C   ASN D 208      10.471  20.683  51.671  1.00 27.23           C  
ATOM   7730  O   ASN D 208      10.041  21.626  52.330  1.00 27.24           O  
ATOM   7731  CB  ASN D 208      10.262  20.821  49.181  1.00 26.74           C  
ATOM   7732  CG  ASN D 208      10.635  21.764  48.059  1.00 26.35           C  
ATOM   7733  OD1 ASN D 208      10.074  22.852  47.944  1.00 24.27           O  
ATOM   7734  ND2 ASN D 208      11.604  21.367  47.247  1.00 25.28           N  
ATOM   7735  N   ASN D 209      10.320  19.412  52.039  1.00 27.37           N  
ATOM   7736  CA  ASN D 209       9.683  19.056  53.308  1.00 27.60           C  
ATOM   7737  C   ASN D 209      10.421  19.651  54.502  1.00 27.82           C  
ATOM   7738  O   ASN D 209       9.803  20.265  55.373  1.00 28.11           O  
ATOM   7739  CB  ASN D 209       9.541  17.536  53.436  1.00 27.58           C  
ATOM   7740  CG  ASN D 209       8.610  16.951  52.391  1.00 27.54           C  
ATOM   7741  OD1 ASN D 209       7.735  17.643  51.866  1.00 27.16           O  
ATOM   7742  ND2 ASN D 209       8.795  15.671  52.078  1.00 27.03           N  
ATOM   7743  N   LEU D 210      11.742  19.499  54.511  1.00 28.14           N  
ATOM   7744  CA  LEU D 210      12.589  20.018  55.584  1.00 28.37           C  
ATOM   7745  C   LEU D 210      12.581  21.549  55.670  1.00 28.61           C  
ATOM   7746  O   LEU D 210      12.450  22.106  56.758  1.00 28.64           O  
ATOM   7747  CB  LEU D 210      14.022  19.499  55.420  1.00 28.58           C  
ATOM   7748  CG  LEU D 210      15.116  19.963  56.387  1.00 28.61           C  
ATOM   7749  CD1 LEU D 210      14.882  19.432  57.806  1.00 28.25           C  
ATOM   7750  CD2 LEU D 210      16.480  19.535  55.869  1.00 28.43           C  
ATOM   7751  N   ALA D 211      12.716  22.222  54.526  1.00 28.83           N  
ATOM   7752  CA  ALA D 211      12.766  23.685  54.494  1.00 28.97           C  
ATOM   7753  C   ALA D 211      11.443  24.334  54.910  1.00 29.18           C  
ATOM   7754  O   ALA D 211      11.439  25.299  55.672  1.00 29.32           O  
ATOM   7755  CB  ALA D 211      13.201  24.179  53.119  1.00 29.02           C  
ATOM   7756  N   VAL D 212      10.332  23.797  54.407  1.00 29.53           N  
ATOM   7757  CA  VAL D 212       8.984  24.285  54.730  1.00 30.01           C  
ATOM   7758  C   VAL D 212       8.703  24.151  56.232  1.00 30.36           C  
ATOM   7759  O   VAL D 212       8.240  25.099  56.881  1.00 30.28           O  
ATOM   7760  CB  VAL D 212       7.888  23.536  53.898  1.00 30.04           C  
ATOM   7761  CG1 VAL D 212       6.505  23.677  54.525  1.00 30.04           C  
ATOM   7762  CG2 VAL D 212       7.867  24.029  52.458  1.00 30.11           C  
ATOM   7763  N   LYS D 213       9.004  22.970  56.765  1.00 30.70           N  
ATOM   7764  CA  LYS D 213       8.823  22.654  58.182  1.00 31.61           C  
ATOM   7765  C   LYS D 213       9.602  23.642  59.047  1.00 31.85           C  
ATOM   7766  O   LYS D 213       9.083  24.145  60.044  1.00 32.18           O  
ATOM   7767  CB  LYS D 213       9.280  21.218  58.442  1.00 31.37           C  
ATOM   7768  CG  LYS D 213       8.913  20.642  59.802  1.00 32.19           C  
ATOM   7769  CD  LYS D 213       9.149  19.129  59.854  1.00 32.96           C  
ATOM   7770  CE  LYS D 213      10.594  18.742  59.516  1.00 34.53           C  
ATOM   7771  NZ  LYS D 213      11.589  19.273  60.492  1.00 36.04           N  
ATOM   7772  N   ASN D 214      10.838  23.929  58.644  1.00 32.37           N  
ATOM   7773  CA  ASN D 214      11.678  24.905  59.338  1.00 32.86           C  
ATOM   7774  C   ASN D 214      11.127  26.328  59.285  1.00 33.21           C  
ATOM   7775  O   ASN D 214      11.064  27.005  60.311  1.00 33.55           O  
ATOM   7776  CB  ASN D 214      13.112  24.861  58.806  1.00 32.57           C  
ATOM   7777  CG  ASN D 214      13.865  23.621  59.252  1.00 32.74           C  
ATOM   7778  OD1 ASN D 214      13.398  22.868  60.108  1.00 32.40           O  
ATOM   7779  ND2 ASN D 214      15.038  23.405  58.677  1.00 32.39           N  
ATOM   7780  N   LEU D 215      10.721  26.770  58.095  1.00 33.78           N  
ATOM   7781  CA  LEU D 215      10.226  28.136  57.909  1.00 34.14           C  
ATOM   7782  C   LEU D 215       8.906  28.391  58.653  1.00 34.61           C  
ATOM   7783  O   LEU D 215       8.679  29.487  59.171  1.00 34.76           O  
ATOM   7784  CB  LEU D 215      10.123  28.480  56.418  1.00 34.03           C  
ATOM   7785  CG  LEU D 215      11.459  28.590  55.668  1.00 33.54           C  
ATOM   7786  CD1 LEU D 215      11.236  28.622  54.164  1.00 32.53           C  
ATOM   7787  CD2 LEU D 215      12.281  29.809  56.126  1.00 32.95           C  
ATOM   7788  N   LYS D 216       8.057  27.367  58.728  1.00 34.87           N  
ATOM   7789  CA  LYS D 216       6.821  27.432  59.511  1.00 35.03           C  
ATOM   7790  C   LYS D 216       7.106  27.573  61.009  1.00 35.23           C  
ATOM   7791  O   LYS D 216       6.455  28.364  61.698  1.00 35.29           O  
ATOM   7792  CB  LYS D 216       5.953  26.198  59.249  1.00 34.90           C  
ATOM   7793  CG  LYS D 216       5.157  26.243  57.950  1.00 34.75           C  
ATOM   7794  CD  LYS D 216       4.527  24.887  57.668  1.00 34.42           C  
ATOM   7795  CE  LYS D 216       3.666  24.899  56.418  1.00 33.97           C  
ATOM   7796  NZ  LYS D 216       2.416  25.681  56.574  1.00 34.06           N  
ATOM   7797  N   LYS D 217       8.084  26.809  61.496  1.00 35.44           N  
ATOM   7798  CA  LYS D 217       8.527  26.877  62.892  1.00 35.71           C  
ATOM   7799  C   LYS D 217       9.118  28.238  63.257  1.00 35.76           C  
ATOM   7800  O   LYS D 217       8.938  28.721  64.377  1.00 35.77           O  
ATOM   7801  CB  LYS D 217       9.561  25.786  63.180  1.00 35.86           C  
ATOM   7802  CG  LYS D 217       8.958  24.445  63.546  1.00 36.58           C  
ATOM   7803  CD  LYS D 217       9.995  23.344  63.464  1.00 37.29           C  
ATOM   7804  CE  LYS D 217       9.357  21.985  63.658  1.00 37.37           C  
ATOM   7805  NZ  LYS D 217      10.159  20.917  63.003  1.00 37.63           N  
ATOM   7806  N   LEU D 218       9.829  28.839  62.306  1.00 35.75           N  
ATOM   7807  CA  LEU D 218      10.450  30.148  62.488  1.00 35.81           C  
ATOM   7808  C   LEU D 218       9.415  31.277  62.452  1.00 35.71           C  
ATOM   7809  O   LEU D 218       9.751  32.442  62.672  1.00 35.91           O  
ATOM   7810  CB  LEU D 218      11.535  30.371  61.421  1.00 35.94           C  
ATOM   7811  CG  LEU D 218      12.995  29.938  61.650  1.00 36.15           C  
ATOM   7812  CD1 LEU D 218      13.160  28.499  62.134  1.00 36.80           C  
ATOM   7813  CD2 LEU D 218      13.796  30.149  60.383  1.00 36.15           C  
ATOM   7814  N   GLY D 219       8.162  30.925  62.166  1.00 35.52           N  
ATOM   7815  CA  GLY D 219       7.044  31.863  62.229  1.00 35.23           C  
ATOM   7816  C   GLY D 219       6.629  32.493  60.915  1.00 34.95           C  
ATOM   7817  O   GLY D 219       6.024  33.569  60.902  1.00 34.92           O  
ATOM   7818  N   PHE D 220       6.944  31.823  59.808  1.00 34.80           N  
ATOM   7819  CA  PHE D 220       6.636  32.338  58.481  1.00 34.42           C  
ATOM   7820  C   PHE D 220       5.326  31.787  57.929  1.00 34.19           C  
ATOM   7821  O   PHE D 220       4.946  30.644  58.209  1.00 33.80           O  
ATOM   7822  CB  PHE D 220       7.800  32.071  57.509  1.00 34.72           C  
ATOM   7823  CG  PHE D 220       9.045  32.847  57.840  1.00 34.88           C  
ATOM   7824  CD1 PHE D 220       9.328  34.034  57.182  1.00 35.45           C  
ATOM   7825  CD2 PHE D 220       9.919  32.402  58.835  1.00 35.55           C  
ATOM   7826  CE1 PHE D 220      10.467  34.766  57.498  1.00 35.49           C  
ATOM   7827  CE2 PHE D 220      11.061  33.129  59.159  1.00 35.80           C  
ATOM   7828  CZ  PHE D 220      11.336  34.315  58.487  1.00 35.74           C  
ATOM   7829  N   ASP D 221       4.640  32.631  57.164  1.00 33.67           N  
ATOM   7830  CA  ASP D 221       3.418  32.272  56.456  1.00 33.29           C  
ATOM   7831  C   ASP D 221       3.793  31.493  55.191  1.00 32.66           C  
ATOM   7832  O   ASP D 221       4.147  32.096  54.174  1.00 32.55           O  
ATOM   7833  CB  ASP D 221       2.650  33.556  56.100  1.00 33.60           C  
ATOM   7834  CG  ASP D 221       1.291  33.291  55.465  1.00 34.71           C  
ATOM   7835  OD1 ASP D 221       0.891  32.116  55.292  1.00 35.80           O  
ATOM   7836  OD2 ASP D 221       0.611  34.287  55.141  1.00 36.58           O  
ATOM   7837  N   VAL D 222       3.715  30.160  55.270  1.00 31.80           N  
ATOM   7838  CA  VAL D 222       4.122  29.277  54.166  1.00 30.86           C  
ATOM   7839  C   VAL D 222       2.986  28.364  53.694  1.00 30.29           C  
ATOM   7840  O   VAL D 222       2.551  27.468  54.424  1.00 30.23           O  
ATOM   7841  CB  VAL D 222       5.365  28.411  54.531  1.00 30.99           C  
ATOM   7842  CG1 VAL D 222       5.829  27.579  53.331  1.00 30.33           C  
ATOM   7843  CG2 VAL D 222       6.507  29.283  55.030  1.00 30.75           C  
ATOM   7844  N   THR D 223       2.516  28.597  52.472  1.00 29.34           N  
ATOM   7845  CA  THR D 223       1.490  27.756  51.855  1.00 28.62           C  
ATOM   7846  C   THR D 223       2.164  26.699  50.983  1.00 28.27           C  
ATOM   7847  O   THR D 223       2.602  26.986  49.863  1.00 27.57           O  
ATOM   7848  CB  THR D 223       0.489  28.604  51.032  1.00 28.72           C  
ATOM   7849  OG1 THR D 223      -0.186  29.522  51.902  1.00 28.61           O  
ATOM   7850  CG2 THR D 223      -0.539  27.723  50.332  1.00 28.97           C  
ATOM   7851  N   TYR D 224       2.248  25.479  51.505  1.00 27.74           N  
ATOM   7852  CA  TYR D 224       2.948  24.393  50.826  1.00 27.42           C  
ATOM   7853  C   TYR D 224       1.991  23.344  50.272  1.00 27.46           C  
ATOM   7854  O   TYR D 224       1.161  22.794  51.001  1.00 26.95           O  
ATOM   7855  CB  TYR D 224       3.984  23.761  51.765  1.00 27.52           C  
ATOM   7856  CG  TYR D 224       4.775  22.595  51.198  1.00 27.76           C  
ATOM   7857  CD1 TYR D 224       5.446  22.698  49.979  1.00 27.76           C  
ATOM   7858  CD2 TYR D 224       4.883  21.394  51.908  1.00 28.28           C  
ATOM   7859  CE1 TYR D 224       6.182  21.636  49.469  1.00 27.31           C  
ATOM   7860  CE2 TYR D 224       5.620  20.320  51.404  1.00 28.42           C  
ATOM   7861  CZ  TYR D 224       6.270  20.453  50.184  1.00 28.42           C  
ATOM   7862  OH  TYR D 224       7.002  19.406  49.676  1.00 28.35           O  
ATOM   7863  N   SER D 225       2.102  23.100  48.968  1.00 27.18           N  
ATOM   7864  CA  SER D 225       1.333  22.055  48.306  1.00 27.42           C  
ATOM   7865  C   SER D 225       2.262  21.024  47.679  1.00 27.25           C  
ATOM   7866  O   SER D 225       3.434  21.304  47.425  1.00 26.69           O  
ATOM   7867  CB  SER D 225       0.395  22.648  47.253  1.00 27.32           C  
ATOM   7868  OG  SER D 225       1.102  23.493  46.362  1.00 28.42           O  
ATOM   7869  N   HIS D 226       1.735  19.820  47.469  1.00 27.43           N  
ATOM   7870  CA  HIS D 226       2.466  18.758  46.788  1.00 27.62           C  
ATOM   7871  C   HIS D 226       1.512  17.733  46.190  1.00 27.71           C  
ATOM   7872  O   HIS D 226       0.475  17.412  46.776  1.00 27.93           O  
ATOM   7873  CB  HIS D 226       3.505  18.093  47.708  1.00 27.68           C  
ATOM   7874  CG  HIS D 226       2.942  17.584  49.002  1.00 28.26           C  
ATOM   7875  ND1 HIS D 226       2.925  18.338  50.156  1.00 29.37           N  
ATOM   7876  CD2 HIS D 226       2.387  16.391  49.324  1.00 28.74           C  
ATOM   7877  CE1 HIS D 226       2.378  17.634  51.132  1.00 28.85           C  
ATOM   7878  NE2 HIS D 226       2.044  16.449  50.653  1.00 29.07           N  
ATOM   7879  N   SER D 227       1.867  17.238  45.009  1.00 27.99           N  
ATOM   7880  CA  SER D 227       1.053  16.275  44.273  1.00 27.85           C  
ATOM   7881  C   SER D 227       1.947  15.414  43.391  1.00 27.79           C  
ATOM   7882  O   SER D 227       3.175  15.557  43.416  1.00 27.81           O  
ATOM   7883  CB  SER D 227       0.000  16.997  43.420  1.00 28.05           C  
ATOM   7884  OG  SER D 227       0.596  17.994  42.601  1.00 28.60           O  
ATOM   7885  N   ALA D 228       1.332  14.515  42.622  1.00 27.42           N  
ATOM   7886  CA  ALA D 228       2.048  13.713  41.634  1.00 27.05           C  
ATOM   7887  C   ALA D 228       2.783  14.614  40.651  1.00 26.96           C  
ATOM   7888  O   ALA D 228       2.223  15.593  40.141  1.00 26.89           O  
ATOM   7889  CB  ALA D 228       1.089  12.803  40.896  1.00 27.41           C  
ATOM   7890  N   GLY D 229       4.042  14.281  40.391  1.00 26.34           N  
ATOM   7891  CA  GLY D 229       4.851  15.075  39.484  1.00 25.58           C  
ATOM   7892  C   GLY D 229       6.337  14.910  39.705  1.00 25.23           C  
ATOM   7893  O   GLY D 229       6.776  14.468  40.770  1.00 24.53           O  
ATOM   7894  N   THR D 230       7.104  15.281  38.685  1.00 24.54           N  
ATOM   7895  CA  THR D 230       8.557  15.154  38.698  1.00 24.42           C  
ATOM   7896  C   THR D 230       9.205  16.521  38.419  1.00 23.98           C  
ATOM   7897  O   THR D 230       8.513  17.541  38.366  1.00 23.60           O  
ATOM   7898  CB  THR D 230       9.037  14.100  37.671  1.00 24.43           C  
ATOM   7899  OG1 THR D 230       8.506  14.412  36.374  1.00 26.05           O  
ATOM   7900  CG2 THR D 230       8.595  12.681  38.088  1.00 24.91           C  
ATOM   7901  N   HIS D 231      10.525  16.531  38.248  1.00 23.71           N  
ATOM   7902  CA  HIS D 231      11.285  17.770  38.060  1.00 24.14           C  
ATOM   7903  C   HIS D 231      11.245  18.217  36.595  1.00 23.97           C  
ATOM   7904  O   HIS D 231      12.252  18.136  35.886  1.00 24.16           O  
ATOM   7905  CB  HIS D 231      12.731  17.547  38.522  1.00 24.38           C  
ATOM   7906  CG  HIS D 231      13.430  18.797  38.953  1.00 24.02           C  
ATOM   7907  ND1 HIS D 231      13.179  19.411  40.161  1.00 25.21           N  
ATOM   7908  CD2 HIS D 231      14.380  19.545  38.341  1.00 25.29           C  
ATOM   7909  CE1 HIS D 231      13.935  20.489  40.270  1.00 24.40           C  
ATOM   7910  NE2 HIS D 231      14.674  20.591  39.180  1.00 25.09           N  
ATOM   7911  N   GLU D 232      10.071  18.673  36.145  1.00 24.02           N  
ATOM   7912  CA  GLU D 232       9.858  19.012  34.735  1.00 24.29           C  
ATOM   7913  C   GLU D 232       9.044  20.291  34.544  1.00 23.88           C  
ATOM   7914  O   GLU D 232       8.196  20.622  35.371  1.00 23.61           O  
ATOM   7915  CB  GLU D 232       9.169  17.853  33.994  1.00 24.75           C  
ATOM   7916  CG  GLU D 232       9.879  16.496  34.079  1.00 26.81           C  
ATOM   7917  CD  GLU D 232      11.147  16.391  33.231  1.00 29.33           C  
ATOM   7918  OE1 GLU D 232      11.427  17.298  32.414  1.00 30.46           O  
ATOM   7919  OE2 GLU D 232      11.867  15.377  33.379  1.00 30.80           O  
ATOM   7920  N   TRP D 233       9.299  20.983  33.432  1.00 23.15           N  
ATOM   7921  CA  TRP D 233       8.642  22.252  33.102  1.00 23.01           C  
ATOM   7922  C   TRP D 233       7.107  22.227  33.050  1.00 22.72           C  
ATOM   7923  O   TRP D 233       6.461  23.197  33.447  1.00 22.73           O  
ATOM   7924  CB  TRP D 233       9.199  22.805  31.790  1.00 22.92           C  
ATOM   7925  CG  TRP D 233      10.481  23.565  31.949  1.00 22.50           C  
ATOM   7926  CD1 TRP D 233      11.731  23.154  31.596  1.00 23.07           C  
ATOM   7927  CD2 TRP D 233      10.628  24.869  32.507  1.00 22.57           C  
ATOM   7928  NE1 TRP D 233      12.653  24.131  31.892  1.00 22.46           N  
ATOM   7929  CE2 TRP D 233      12.003  25.198  32.448  1.00 23.37           C  
ATOM   7930  CE3 TRP D 233       9.731  25.803  33.027  1.00 22.41           C  
ATOM   7931  CZ2 TRP D 233      12.499  26.431  32.899  1.00 23.18           C  
ATOM   7932  CZ3 TRP D 233      10.228  27.030  33.485  1.00 22.99           C  
ATOM   7933  CH2 TRP D 233      11.601  27.325  33.417  1.00 23.44           C  
ATOM   7934  N   TYR D 234       6.524  21.127  32.577  1.00 22.79           N  
ATOM   7935  CA  TYR D 234       5.063  20.990  32.567  1.00 22.84           C  
ATOM   7936  C   TYR D 234       4.443  21.354  33.928  1.00 22.62           C  
ATOM   7937  O   TYR D 234       3.460  22.092  33.994  1.00 22.18           O  
ATOM   7938  CB  TYR D 234       4.658  19.564  32.171  1.00 23.33           C  
ATOM   7939  CG  TYR D 234       3.184  19.275  32.375  1.00 24.09           C  
ATOM   7940  CD1 TYR D 234       2.234  19.737  31.463  1.00 25.10           C  
ATOM   7941  CD2 TYR D 234       2.740  18.544  33.483  1.00 25.63           C  
ATOM   7942  CE1 TYR D 234       0.879  19.480  31.643  1.00 26.21           C  
ATOM   7943  CE2 TYR D 234       1.381  18.281  33.676  1.00 25.19           C  
ATOM   7944  CZ  TYR D 234       0.462  18.754  32.750  1.00 26.05           C  
ATOM   7945  OH  TYR D 234      -0.880  18.500  32.922  1.00 26.41           O  
ATOM   7946  N   TYR D 235       5.034  20.837  35.002  1.00 22.69           N  
ATOM   7947  CA  TYR D 235       4.512  21.039  36.359  1.00 22.62           C  
ATOM   7948  C   TYR D 235       4.769  22.454  36.881  1.00 22.88           C  
ATOM   7949  O   TYR D 235       3.920  23.039  37.546  1.00 22.70           O  
ATOM   7950  CB  TYR D 235       5.093  19.992  37.317  1.00 22.78           C  
ATOM   7951  CG  TYR D 235       4.870  18.576  36.841  1.00 23.51           C  
ATOM   7952  CD1 TYR D 235       3.647  17.938  37.047  1.00 23.92           C  
ATOM   7953  CD2 TYR D 235       5.873  17.883  36.157  1.00 24.07           C  
ATOM   7954  CE1 TYR D 235       3.433  16.641  36.590  1.00 24.90           C  
ATOM   7955  CE2 TYR D 235       5.670  16.588  35.699  1.00 25.08           C  
ATOM   7956  CZ  TYR D 235       4.451  15.974  35.924  1.00 24.30           C  
ATOM   7957  OH  TYR D 235       4.245  14.690  35.473  1.00 26.13           O  
ATOM   7958  N   TRP D 236       5.937  23.001  36.562  1.00 22.52           N  
ATOM   7959  CA  TRP D 236       6.284  24.347  37.003  1.00 22.59           C  
ATOM   7960  C   TRP D 236       5.364  25.397  36.394  1.00 22.66           C  
ATOM   7961  O   TRP D 236       4.942  26.323  37.085  1.00 23.04           O  
ATOM   7962  CB  TRP D 236       7.753  24.646  36.721  1.00 22.76           C  
ATOM   7963  CG  TRP D 236       8.658  23.631  37.342  1.00 22.70           C  
ATOM   7964  CD1 TRP D 236       8.469  22.988  38.533  1.00 23.26           C  
ATOM   7965  CD2 TRP D 236       9.898  23.145  36.814  1.00 23.34           C  
ATOM   7966  NE1 TRP D 236       9.507  22.126  38.771  1.00 24.19           N  
ATOM   7967  CE2 TRP D 236      10.403  22.210  37.737  1.00 22.82           C  
ATOM   7968  CE3 TRP D 236      10.631  23.412  35.646  1.00 23.20           C  
ATOM   7969  CZ2 TRP D 236      11.607  21.528  37.530  1.00 23.72           C  
ATOM   7970  CZ3 TRP D 236      11.827  22.732  35.437  1.00 22.89           C  
ATOM   7971  CH2 TRP D 236      12.307  21.809  36.379  1.00 23.33           C  
ATOM   7972  N   GLU D 237       5.021  25.222  35.118  1.00 22.56           N  
ATOM   7973  CA  GLU D 237       4.063  26.096  34.439  1.00 23.16           C  
ATOM   7974  C   GLU D 237       2.657  25.971  35.033  1.00 23.35           C  
ATOM   7975  O   GLU D 237       1.967  26.978  35.248  1.00 23.35           O  
ATOM   7976  CB  GLU D 237       4.048  25.795  32.936  1.00 22.79           C  
ATOM   7977  CG  GLU D 237       2.921  26.485  32.178  1.00 23.76           C  
ATOM   7978  CD  GLU D 237       3.116  26.472  30.673  1.00 24.26           C  
ATOM   7979  OE1 GLU D 237       3.994  25.746  30.165  1.00 25.11           O  
ATOM   7980  OE2 GLU D 237       2.378  27.205  29.992  1.00 26.79           O  
ATOM   7981  N   LYS D 238       2.240  24.736  35.292  1.00 23.39           N  
ATOM   7982  CA  LYS D 238       0.955  24.480  35.939  1.00 24.59           C  
ATOM   7983  C   LYS D 238       0.859  25.173  37.291  1.00 24.11           C  
ATOM   7984  O   LYS D 238      -0.183  25.729  37.637  1.00 24.69           O  
ATOM   7985  CB  LYS D 238       0.711  22.981  36.093  1.00 25.04           C  
ATOM   7986  CG  LYS D 238       0.263  22.308  34.804  1.00 27.62           C  
ATOM   7987  CD  LYS D 238      -0.860  23.098  34.123  1.00 31.48           C  
ATOM   7988  CE  LYS D 238      -1.123  22.604  32.710  1.00 32.87           C  
ATOM   7989  NZ  LYS D 238      -1.197  23.765  31.778  1.00 34.03           N  
ATOM   7990  N   GLN D 239       1.954  25.151  38.041  1.00 23.92           N  
ATOM   7991  CA  GLN D 239       1.966  25.735  39.375  1.00 23.67           C  
ATOM   7992  C   GLN D 239       2.074  27.257  39.347  1.00 23.92           C  
ATOM   7993  O   GLN D 239       1.581  27.917  40.256  1.00 23.83           O  
ATOM   7994  CB  GLN D 239       3.054  25.108  40.239  1.00 23.69           C  
ATOM   7995  CG  GLN D 239       2.832  23.613  40.502  1.00 23.16           C  
ATOM   7996  CD  GLN D 239       1.474  23.288  41.142  1.00 25.36           C  
ATOM   7997  OE1 GLN D 239       0.839  22.289  40.795  1.00 27.01           O  
ATOM   7998  NE2 GLN D 239       1.031  24.128  42.073  1.00 23.14           N  
ATOM   7999  N   LEU D 240       2.707  27.809  38.306  1.00 23.85           N  
ATOM   8000  CA  LEU D 240       2.656  29.260  38.091  1.00 23.86           C  
ATOM   8001  C   LEU D 240       1.205  29.717  37.890  1.00 24.30           C  
ATOM   8002  O   LEU D 240       0.796  30.757  38.417  1.00 24.54           O  
ATOM   8003  CB  LEU D 240       3.532  29.705  36.910  1.00 24.02           C  
ATOM   8004  CG  LEU D 240       3.539  31.215  36.631  1.00 23.49           C  
ATOM   8005  CD1 LEU D 240       4.090  32.018  37.819  1.00 23.03           C  
ATOM   8006  CD2 LEU D 240       4.333  31.532  35.364  1.00 23.36           C  
ATOM   8007  N   GLU D 241       0.441  28.931  37.131  1.00 24.88           N  
ATOM   8008  CA  GLU D 241      -0.976  29.193  36.895  1.00 25.63           C  
ATOM   8009  C   GLU D 241      -1.732  29.274  38.218  1.00 25.43           C  
ATOM   8010  O   GLU D 241      -2.532  30.197  38.419  1.00 25.65           O  
ATOM   8011  CB  GLU D 241      -1.596  28.124  35.991  1.00 25.69           C  
ATOM   8012  CG  GLU D 241      -1.027  28.117  34.568  1.00 26.90           C  
ATOM   8013  CD  GLU D 241      -1.614  27.033  33.676  1.00 28.00           C  
ATOM   8014  OE1 GLU D 241      -2.491  26.266  34.133  1.00 29.64           O  
ATOM   8015  OE2 GLU D 241      -1.191  26.943  32.504  1.00 30.61           O  
ATOM   8016  N   VAL D 242      -1.446  28.330  39.117  1.00 24.85           N  
ATOM   8017  CA  VAL D 242      -2.065  28.305  40.456  1.00 24.70           C  
ATOM   8018  C   VAL D 242      -1.602  29.491  41.306  1.00 24.65           C  
ATOM   8019  O   VAL D 242      -2.416  30.131  41.973  1.00 24.04           O  
ATOM   8020  CB  VAL D 242      -1.786  26.977  41.204  1.00 24.75           C  
ATOM   8021  CG1 VAL D 242      -2.429  26.991  42.586  1.00 25.00           C  
ATOM   8022  CG2 VAL D 242      -2.315  25.807  40.405  1.00 24.50           C  
ATOM   8023  N   PHE D 243      -0.302  29.791  41.266  1.00 24.57           N  
ATOM   8024  CA  PHE D 243       0.244  30.892  42.066  1.00 24.62           C  
ATOM   8025  C   PHE D 243      -0.369  32.236  41.678  1.00 25.24           C  
ATOM   8026  O   PHE D 243      -0.672  33.057  42.554  1.00 25.08           O  
ATOM   8027  CB  PHE D 243       1.781  30.962  41.975  1.00 24.34           C  
ATOM   8028  CG  PHE D 243       2.384  32.150  42.700  1.00 23.52           C  
ATOM   8029  CD1 PHE D 243       2.169  32.340  44.068  1.00 22.73           C  
ATOM   8030  CD2 PHE D 243       3.182  33.078  42.010  1.00 23.04           C  
ATOM   8031  CE1 PHE D 243       2.725  33.434  44.740  1.00 22.14           C  
ATOM   8032  CE2 PHE D 243       3.744  34.167  42.673  1.00 22.36           C  
ATOM   8033  CZ  PHE D 243       3.509  34.353  44.041  1.00 22.43           C  
ATOM   8034  N   LEU D 244      -0.569  32.442  40.376  1.00 25.64           N  
ATOM   8035  CA  LEU D 244      -1.145  33.687  39.857  1.00 26.01           C  
ATOM   8036  C   LEU D 244      -2.543  33.981  40.405  1.00 26.14           C  
ATOM   8037  O   LEU D 244      -2.914  35.143  40.565  1.00 25.90           O  
ATOM   8038  CB  LEU D 244      -1.163  33.690  38.322  1.00 26.10           C  
ATOM   8039  CG  LEU D 244       0.167  33.838  37.567  1.00 26.06           C  
ATOM   8040  CD1 LEU D 244      -0.052  33.643  36.075  1.00 27.98           C  
ATOM   8041  CD2 LEU D 244       0.846  35.181  37.832  1.00 26.16           C  
ATOM   8042  N   THR D 245      -3.307  32.927  40.691  1.00 26.43           N  
ATOM   8043  CA  THR D 245      -4.653  33.063  41.265  1.00 26.88           C  
ATOM   8044  C   THR D 245      -4.644  33.558  42.716  1.00 27.18           C  
ATOM   8045  O   THR D 245      -5.673  34.013  43.224  1.00 27.66           O  
ATOM   8046  CB  THR D 245      -5.462  31.734  41.199  1.00 26.86           C  
ATOM   8047  OG1 THR D 245      -4.884  30.760  42.081  1.00 27.06           O  
ATOM   8048  CG2 THR D 245      -5.504  31.185  39.776  1.00 26.66           C  
ATOM   8049  N   THR D 246      -3.490  33.458  43.380  1.00 27.21           N  
ATOM   8050  CA  THR D 246      -3.345  33.909  44.765  1.00 27.06           C  
ATOM   8051  C   THR D 246      -2.971  35.388  44.856  1.00 27.27           C  
ATOM   8052  O   THR D 246      -2.967  35.968  45.950  1.00 27.05           O  
ATOM   8053  CB  THR D 246      -2.288  33.093  45.550  1.00 27.25           C  
ATOM   8054  OG1 THR D 246      -0.971  33.481  45.139  1.00 26.68           O  
ATOM   8055  CG2 THR D 246      -2.486  31.578  45.366  1.00 26.89           C  
ATOM   8056  N   LEU D 247      -2.661  35.986  43.709  1.00 27.19           N  
ATOM   8057  CA  LEU D 247      -2.196  37.368  43.657  1.00 27.63           C  
ATOM   8058  C   LEU D 247      -3.351  38.367  43.506  1.00 28.53           C  
ATOM   8059  O   LEU D 247      -4.399  38.027  42.938  1.00 28.41           O  
ATOM   8060  CB  LEU D 247      -1.172  37.540  42.524  1.00 27.01           C  
ATOM   8061  CG  LEU D 247       0.092  36.679  42.622  1.00 26.12           C  
ATOM   8062  CD1 LEU D 247       0.987  36.891  41.401  1.00 24.56           C  
ATOM   8063  CD2 LEU D 247       0.865  36.948  43.913  1.00 24.63           C  
ATOM   8064  N   PRO D 248      -3.174  39.597  44.026  1.00 29.49           N  
ATOM   8065  CA  PRO D 248      -4.206  40.626  43.890  1.00 30.25           C  
ATOM   8066  C   PRO D 248      -4.157  41.305  42.515  1.00 30.95           C  
ATOM   8067  O   PRO D 248      -3.881  42.506  42.417  1.00 31.28           O  
ATOM   8068  CB  PRO D 248      -3.865  41.607  45.015  1.00 30.31           C  
ATOM   8069  CG  PRO D 248      -2.389  41.479  45.195  1.00 30.10           C  
ATOM   8070  CD  PRO D 248      -2.004  40.082  44.791  1.00 29.35           C  
ATOM   8071  N   ILE D 249      -4.434  40.529  41.469  1.00 31.70           N  
ATOM   8072  CA  ILE D 249      -4.255  40.973  40.082  1.00 32.42           C  
ATOM   8073  C   ILE D 249      -5.419  40.573  39.162  1.00 33.11           C  
ATOM   8074  O   ILE D 249      -5.393  40.862  37.958  1.00 33.72           O  
ATOM   8075  CB  ILE D 249      -2.907  40.460  39.477  1.00 32.25           C  
ATOM   8076  CG1 ILE D 249      -2.866  38.922  39.420  1.00 32.30           C  
ATOM   8077  CG2 ILE D 249      -1.711  41.030  40.240  1.00 31.88           C  
ATOM   8078  CD1 ILE D 249      -1.812  38.349  38.481  1.00 31.78           C  
ATOM   8079  N   ASP D 250      -6.422  39.906  39.733  1.00 33.59           N  
ATOM   8080  CA  ASP D 250      -7.629  39.474  39.002  1.00 34.06           C  
ATOM   8081  C   ASP D 250      -7.315  38.644  37.748  1.00 34.24           C  
ATOM   8082  O   ASP D 250      -7.846  38.897  36.659  1.00 34.65           O  
ATOM   8083  CB  ASP D 250      -8.524  40.674  38.660  1.00 34.21           C  
ATOM   8084  CG  ASP D 250      -9.126  41.249  39.840  0.00 32.85           C  
ATOM   8085  OD1 ASP D 250      -9.160  40.642  40.929  0.00 34.05           O  
ATOM   8086  OD2 ASP D 250      -9.603  42.392  39.679  0.00 34.90           O  
ATOM   8087  N   PHE D 251      -6.448  37.649  37.921  1.00 33.92           N  
ATOM   8088  CA  PHE D 251      -6.008  36.781  36.834  1.00 33.55           C  
ATOM   8089  C   PHE D 251      -7.140  35.862  36.363  1.00 33.46           C  
ATOM   8090  O   PHE D 251      -7.968  35.441  37.161  1.00 33.07           O  
ATOM   8091  CB  PHE D 251      -4.810  35.953  37.307  1.00 33.46           C  
ATOM   8092  CG  PHE D 251      -4.393  34.879  36.346  1.00 33.62           C  
ATOM   8093  CD1 PHE D 251      -3.685  35.197  35.193  1.00 32.57           C  
ATOM   8094  CD2 PHE D 251      -4.709  33.547  36.596  1.00 32.84           C  
ATOM   8095  CE1 PHE D 251      -3.302  34.205  34.303  1.00 33.03           C  
ATOM   8096  CE2 PHE D 251      -4.329  32.550  35.714  1.00 33.50           C  
ATOM   8097  CZ  PHE D 251      -3.628  32.879  34.564  1.00 33.31           C  
ATOM   8098  N   LYS D 252      -7.164  35.561  35.065  1.00 33.40           N  
ATOM   8099  CA  LYS D 252      -8.085  34.569  34.511  1.00 33.42           C  
ATOM   8100  C   LYS D 252      -7.368  33.659  33.521  1.00 33.35           C  
ATOM   8101  O   LYS D 252      -6.677  34.127  32.613  1.00 33.59           O  
ATOM   8102  CB  LYS D 252      -9.292  35.240  33.844  1.00 33.52           C  
ATOM   8103  CG  LYS D 252     -10.184  36.002  34.906  0.00 31.31           C  
ATOM   8104  CD  LYS D 252     -11.503  36.415  34.269  0.00 32.38           C  
ATOM   8105  CE  LYS D 252     -12.340  37.227  35.249  0.00 33.03           C  
ATOM   8106  NZ  LYS D 252     -13.778  37.286  34.861  0.00 34.24           N  
ATOM   8107  N   LEU D 253      -7.534  32.355  33.720  1.00 33.10           N  
ATOM   8108  CA  LEU D 253      -6.947  31.337  32.855  1.00 32.68           C  
ATOM   8109  C   LEU D 253      -7.737  31.231  31.551  1.00 32.21           C  
ATOM   8110  O   LEU D 253      -8.958  31.421  31.534  1.00 32.27           O  
ATOM   8111  CB  LEU D 253      -6.930  29.984  33.582  1.00 32.68           C  
ATOM   8112  CG  LEU D 253      -6.104  28.827  33.007  1.00 33.22           C  
ATOM   8113  CD1 LEU D 253      -4.606  29.083  33.140  1.00 33.17           C  
ATOM   8114  CD2 LEU D 253      -6.488  27.505  33.676  1.00 32.93           C  
ATOM   8115  N   GLU D 254      -7.034  30.925  30.461  1.00 31.35           N  
ATOM   8116  CA  GLU D 254      -7.666  30.714  29.157  1.00 30.69           C  
ATOM   8117  C   GLU D 254      -8.711  29.596  29.198  1.00 30.72           C  
ATOM   8118  O   GLU D 254      -8.621  28.672  30.015  1.00 30.22           O  
ATOM   8119  CB  GLU D 254      -6.606  30.395  28.093  1.00 30.64           C  
ATOM   8120  CG  GLU D 254      -5.822  29.114  28.350  1.00 29.55           C  
ATOM   8121  CD  GLU D 254      -4.582  28.980  27.476  1.00 29.29           C  
ATOM   8122  OE1 GLU D 254      -3.852  27.983  27.663  1.00 27.88           O  
ATOM   8123  OE2 GLU D 254      -4.338  29.862  26.618  1.00 26.34           O  
ATOM   8124  N   GLU D 255      -9.696  29.688  28.309  1.00 30.99           N  
ATOM   8125  CA  GLU D 255     -10.687  28.628  28.165  1.00 31.19           C  
ATOM   8126  C   GLU D 255     -10.014  27.373  27.616  1.00 31.08           C  
ATOM   8127  O   GLU D 255      -9.214  27.443  26.674  1.00 30.85           O  
ATOM   8128  CB  GLU D 255     -11.842  29.064  27.260  1.00 31.32           C  
ATOM   8129  CG  GLU D 255     -13.052  28.128  27.319  1.00 32.14           C  
ATOM   8130  CD  GLU D 255     -14.264  28.660  26.576  1.00 32.81           C  
ATOM   8131  OE1 GLU D 255     -14.107  29.194  25.459  1.00 33.98           O  
ATOM   8132  OE2 GLU D 255     -15.383  28.534  27.117  1.00 34.00           O  
ATOM   8133  N   ARG D 256     -10.330  26.235  28.228  1.00 31.05           N  
ATOM   8134  CA  ARG D 256      -9.760  24.952  27.839  1.00 31.01           C  
ATOM   8135  C   ARG D 256     -10.860  23.892  27.803  1.00 31.13           C  
ATOM   8136  O   ARG D 256     -11.047  23.138  28.762  1.00 31.17           O  
ATOM   8137  CB  ARG D 256      -8.623  24.549  28.789  1.00 31.03           C  
ATOM   8138  CG  ARG D 256      -7.399  25.467  28.735  1.00 30.90           C  
ATOM   8139  CD  ARG D 256      -6.377  25.133  29.808  1.00 31.02           C  
ATOM   8140  NE  ARG D 256      -5.151  25.913  29.629  1.00 30.55           N  
ATOM   8141  CZ  ARG D 256      -4.158  25.983  30.510  1.00 31.78           C  
ATOM   8142  NH1 ARG D 256      -4.225  25.315  31.659  1.00 30.89           N  
ATOM   8143  NH2 ARG D 256      -3.090  26.728  30.247  1.00 31.26           N  
ATOM   8144  N   LEU D 257     -11.589  23.851  26.692  1.00 31.22           N  
ATOM   8145  CA  LEU D 257     -12.667  22.880  26.498  1.00 31.41           C  
ATOM   8146  C   LEU D 257     -12.121  21.476  26.272  1.00 31.53           C  
ATOM   8147  O   LEU D 257     -12.726  20.494  26.711  1.00 32.00           O  
ATOM   8148  CB  LEU D 257     -13.578  23.294  25.336  1.00 31.47           C  
ATOM   8149  CG  LEU D 257     -14.474  24.525  25.524  1.00 32.01           C  
ATOM   8150  CD1 LEU D 257     -15.027  25.007  24.189  1.00 32.20           C  
ATOM   8151  CD2 LEU D 257     -15.613  24.251  26.508  1.00 32.07           C  
TER    8152      LEU D 257                                                      
END
MOLECULE T0413.pdb
ATOM   2291  N   LYS     5      26.289  57.145  21.095  1.00 43.62           N  
ATOM   2292  CA  LYS     5      26.326  55.676  20.790  1.00 43.79           C  
ATOM   2293  C   LYS     5      25.345  54.878  21.643  1.00 43.40           C  
ATOM   2294  O   LYS     5      25.201  55.145  22.849  1.00 43.53           O  
ATOM   2295  CB  LYS     5      27.727  55.084  20.995  1.00 43.92           C  
ATOM   2296  CG  LYS     5      28.751  55.502  19.955  1.00 46.00           C  
ATOM   2297  CD  LYS     5      30.116  54.935  20.296  1.00 48.20           C  
ATOM   2298  CE  LYS     5      31.214  55.680  19.530  1.00 49.38           C  
ATOM   2299  NZ  LYS     5      32.524  55.597  20.248  1.00 48.77           N  
ATOM   2300  N   PRO     6      24.682  53.876  21.027  1.00 42.65           N  
ATOM   2301  CA  PRO     6      23.768  53.009  21.772  1.00 42.06           C  
ATOM   2302  C   PRO     6      24.352  52.523  23.103  1.00 41.24           C  
ATOM   2303  O   PRO     6      23.665  52.611  24.106  1.00 41.03           O  
ATOM   2304  CB  PRO     6      23.498  51.857  20.788  1.00 41.79           C  
ATOM   2305  CG  PRO     6      23.582  52.520  19.457  1.00 41.70           C  
ATOM   2306  CD  PRO     6      24.727  53.506  19.596  1.00 42.88           C  
ATOM   2307  N   ALA     7      25.618  52.086  23.117  1.00 41.03           N  
ATOM   2308  CA  ALA     7      26.294  51.608  24.350  1.00 39.85           C  
ATOM   2309  C   ALA     7      26.199  52.576  25.532  1.00 39.10           C  
ATOM   2310  O   ALA     7      26.132  52.140  26.688  1.00 39.32           O  
ATOM   2311  CB  ALA     7      27.758  51.268  24.074  1.00 40.44           C  
ATOM   2312  N   ASP     8      26.169  53.873  25.223  1.00 37.29           N  
ATOM   2313  CA  ASP     8      26.052  54.954  26.208  1.00 36.35           C  
ATOM   2314  C   ASP     8      24.663  55.150  26.849  1.00 34.38           C  
ATOM   2315  O   ASP     8      24.550  55.864  27.838  1.00 33.75           O  
ATOM   2316  CB  ASP     8      26.457  56.283  25.561  1.00 37.03           C  
ATOM   2317  CG  ASP     8      27.969  56.425  25.396  1.00 40.30           C  
ATOM   2318  OD1 ASP     8      28.725  55.945  26.288  1.00 44.42           O  
ATOM   2319  OD2 ASP     8      28.392  57.030  24.384  1.00 42.87           O  
ATOM   2320  N   LEU     9      23.622  54.563  26.262  1.00 31.86           N  
ATOM   2321  CA  LEU     9      22.297  54.539  26.863  1.00 29.97           C  
ATOM   2322  C   LEU     9      22.339  53.938  28.278  1.00 28.39           C  
ATOM   2323  O   LEU     9      22.923  52.866  28.504  1.00 28.55           O  
ATOM   2324  CB  LEU     9      21.341  53.725  25.996  1.00 30.40           C  
ATOM   2325  CG  LEU     9      20.859  54.280  24.656  1.00 31.04           C  
ATOM   2326  CD1 LEU     9      20.153  53.198  23.876  1.00 29.54           C  
ATOM   2327  CD2 LEU     9      19.942  55.461  24.879  1.00 32.63           C  
ATOM   2328  N   THR    10      21.728  54.631  29.236  1.00 25.85           N  
ATOM   2329  CA  THR    10      21.585  54.067  30.592  1.00 23.39           C  
ATOM   2330  C   THR    10      20.615  52.867  30.572  1.00 22.21           C  
ATOM   2331  O   THR    10      19.844  52.695  29.617  1.00 21.08           O  
ATOM   2332  CB  THR    10      21.002  55.085  31.588  1.00 23.27           C  
ATOM   2333  OG1 THR    10      19.617  55.314  31.268  1.00 21.98           O  
ATOM   2334  CG2 THR    10      21.792  56.413  31.546  1.00 22.96           C  
ATOM   2335  N   ASN    11      20.651  52.071  31.637  1.00 20.64           N  
ATOM   2336  CA  ASN    11      19.662  50.997  31.819  1.00 21.22           C  
ATOM   2337  C   ASN    11      18.210  51.528  31.775  1.00 20.59           C  
ATOM   2338  O   ASN    11      17.365  50.977  31.075  1.00 20.13           O  
ATOM   2339  CB  ASN    11      19.894  50.237  33.110  1.00 21.84           C  
ATOM   2340  CG  ASN    11      21.172  49.391  33.104  1.00 24.41           C  
ATOM   2341  OD1 ASN    11      21.907  49.378  34.101  1.00 25.21           O  
ATOM   2342  ND2 ASN    11      21.419  48.667  32.037  1.00 22.15           N  
ATOM   2343  N   ALA    12      17.934  52.621  32.482  1.00 20.21           N  
ATOM   2344  CA  ALA    12      16.605  53.217  32.424  1.00 21.02           C  
ATOM   2345  C   ALA    12      16.190  53.693  31.007  1.00 21.13           C  
ATOM   2346  O   ALA    12      15.004  53.592  30.653  1.00 20.41           O  
ATOM   2347  CB  ALA    12      16.500  54.378  33.436  1.00 20.91           C  
ATOM   2348  N   ASP    13      17.134  54.268  30.228  1.00 21.50           N  
ATOM   2349  CA  ASP    13      16.872  54.677  28.833  1.00 22.87           C  
ATOM   2350  C   ASP    13      16.572  53.471  27.978  1.00 22.25           C  
ATOM   2351  O   ASP    13      15.644  53.476  27.183  1.00 22.49           O  
ATOM   2352  CB  ASP    13      18.083  55.377  28.226  1.00 24.20           C  
ATOM   2353  CG  ASP    13      18.035  56.875  28.457  1.00 31.72           C  
ATOM   2354  OD1 ASP    13      17.708  57.284  29.589  1.00 39.47           O  
ATOM   2355  OD2 ASP    13      18.289  57.666  27.516  1.00 41.59           O  
ATOM   2356  N   ARG    14      17.369  52.428  28.156  1.00 22.46           N  
ATOM   2357  CA  ARG    14      17.178  51.223  27.357  1.00 22.47           C  
ATOM   2358  C   ARG    14      15.831  50.573  27.640  1.00 21.91           C  
ATOM   2359  O   ARG    14      15.088  50.177  26.708  1.00 22.30           O  
ATOM   2360  CB  ARG    14      18.309  50.243  27.613  1.00 24.10           C  
ATOM   2361  CG  ARG    14      19.377  50.317  26.566  1.00 28.92           C  
ATOM   2362  CD  ARG    14      20.450  49.269  26.736  1.00 36.76           C  
ATOM   2363  NE  ARG    14      21.572  49.838  27.458  1.00 41.35           N  
ATOM   2364  CZ  ARG    14      21.891  49.474  28.689  1.00 47.53           C  
ATOM   2365  NH1 ARG    14      21.178  48.517  29.291  1.00 48.27           N  
ATOM   2366  NH2 ARG    14      22.911  50.059  29.321  1.00 48.84           N  
ATOM   2367  N   ILE    15      15.505  50.454  28.926  1.00 19.06           N  
ATOM   2368  CA  ILE    15      14.210  49.921  29.322  1.00 18.78           C  
ATOM   2369  C   ILE    15      13.009  50.724  28.804  1.00 18.88           C  
ATOM   2370  O   ILE    15      12.017  50.158  28.325  1.00 19.23           O  
ATOM   2371  CB  ILE    15      14.168  49.724  30.851  1.00 19.10           C  
ATOM   2372  CG1 ILE    15      15.161  48.620  31.193  1.00 19.31           C  
ATOM   2373  CG2 ILE    15      12.731  49.298  31.351  1.00 17.25           C  
ATOM   2374  CD1 ILE    15      15.477  48.493  32.683  1.00 16.65           C  
ATOM   2375  N   ALA    16      13.101  52.046  28.890  1.00 18.69           N  
ATOM   2376  CA  ALA    16      12.039  52.900  28.392  1.00 20.67           C  
ATOM   2377  C   ALA    16      11.805  52.680  26.888  1.00 22.77           C  
ATOM   2378  O   ALA    16      10.648  52.672  26.439  1.00 24.48           O  
ATOM   2379  CB  ALA    16      12.347  54.357  28.687  1.00 20.43           C  
ATOM   2380  N   LEU    17      12.889  52.518  26.130  1.00 23.00           N  
ATOM   2381  CA  LEU    17      12.800  52.265  24.706  1.00 24.92           C  
ATOM   2382  C   LEU    17      12.306  50.853  24.405  1.00 24.93           C  
ATOM   2383  O   LEU    17      11.359  50.688  23.609  1.00 26.41           O  
ATOM   2384  CB  LEU    17      14.145  52.518  24.024  1.00 25.02           C  
ATOM   2385  CG  LEU    17      14.629  53.979  24.084  1.00 29.47           C  
ATOM   2386  CD1 LEU    17      16.072  54.111  23.586  1.00 29.75           C  
ATOM   2387  CD2 LEU    17      13.697  54.961  23.359  1.00 30.93           C  
ATOM   2388  N   GLU    18      12.874  49.851  25.056  0.50 23.70           N  
ATOM   2390  CA  GLU    18      12.605  48.488  24.632  0.50 23.32           C  
ATOM   2392  C   GLU    18      11.373  47.838  25.266  0.50 23.79           C  
ATOM   2394  O   GLU    18      10.794  46.894  24.709  0.50 23.26           O  
ATOM   2396  CB  GLU    18      13.864  47.644  24.772  0.50 23.15           C  
ATOM   2398  CG  GLU    18      14.961  48.128  23.812  0.50 22.79           C  
ATOM   2400  CD  GLU    18      14.578  47.908  22.362  0.50 21.37           C  
ATOM   2402  OE1 GLU    18      14.651  46.758  21.895  0.50 20.79           O  
ATOM   2404  OE2 GLU    18      14.176  48.882  21.705  0.50 22.81           O  
ATOM   2406  N   LEU    19      10.937  48.381  26.394  1.00 23.60           N  
ATOM   2407  CA  LEU    19       9.791  47.832  27.071  1.00 24.02           C  
ATOM   2408  C   LEU    19       8.539  48.661  26.837  1.00 23.50           C  
ATOM   2409  O   LEU    19       7.519  48.444  27.503  1.00 24.92           O  
ATOM   2410  CB  LEU    19      10.062  47.647  28.573  1.00 23.34           C  
ATOM   2411  CG  LEU    19      10.357  46.276  29.127  1.00 26.16           C  
ATOM   2412  CD1 LEU    19      10.194  46.316  30.628  1.00 22.50           C  
ATOM   2413  CD2 LEU    19       9.497  45.163  28.473  1.00 24.00           C  
ATOM   2414  N   GLY    20       8.597  49.591  25.895  1.00 23.68           N  
ATOM   2415  CA  GLY    20       7.507  50.519  25.695  1.00 25.05           C  
ATOM   2416  C   GLY    20       6.375  49.952  24.847  1.00 26.33           C  
ATOM   2417  O   GLY    20       5.236  50.420  24.922  1.00 27.12           O  
ATOM   2418  N   HIS    21       6.692  48.953  24.027  1.00 25.44           N  
ATOM   2419  CA  HIS    21       5.728  48.381  23.100  1.00 26.18           C  
ATOM   2420  C   HIS    21       5.503  46.913  23.408  1.00 23.74           C  
ATOM   2421  O   HIS    21       6.384  46.246  23.951  1.00 22.01           O  
ATOM   2422  CB  HIS    21       6.222  48.510  21.672  1.00 26.74           C  
ATOM   2423  CG  HIS    21       6.392  49.932  21.246  1.00 34.20           C  
ATOM   2424  ND1 HIS    21       7.627  50.544  21.183  1.00 38.65           N  
ATOM   2425  CD2 HIS    21       5.480  50.880  20.907  1.00 38.60           C  
ATOM   2426  CE1 HIS    21       7.472  51.803  20.800  1.00 42.38           C  
ATOM   2427  NE2 HIS    21       6.180  52.033  20.627  1.00 43.56           N  
ATOM   2428  N   ALA    22       4.317  46.437  23.065  1.00 22.78           N  
ATOM   2429  CA  ALA    22       3.951  45.023  23.277  1.00 21.70           C  
ATOM   2430  C   ALA    22       4.857  44.045  22.575  1.00 22.46           C  
ATOM   2431  O   ALA    22       5.342  44.299  21.444  1.00 23.40           O  
ATOM   2432  CB  ALA    22       2.490  44.765  22.807  1.00 22.07           C  
ATOM   2433  N   GLY    23       5.010  42.877  23.203  1.00 21.31           N  
ATOM   2434  CA  GLY    23       5.644  41.700  22.591  1.00 20.70           C  
ATOM   2435  C   GLY    23       6.824  41.203  23.418  1.00 19.94           C  
ATOM   2436  O   GLY    23       6.991  41.607  24.577  1.00 18.91           O  
ATOM   2437  N   ARG    24       7.614  40.305  22.838  1.00 20.00           N  
ATOM   2438  CA  ARG    24       8.770  39.783  23.509  1.00 21.94           C  
ATOM   2439  C   ARG    24       9.935  40.701  23.247  1.00 21.74           C  
ATOM   2440  O   ARG    24       9.977  41.373  22.214  1.00 23.30           O  
ATOM   2441  CB  ARG    24       9.108  38.383  23.032  1.00 21.90           C  
ATOM   2442  CG  ARG    24       7.935  37.495  23.017  1.00 25.32           C  
ATOM   2443  CD  ARG    24       8.342  36.133  23.306  1.00 32.91           C  
ATOM   2444  NE  ARG    24       8.739  35.446  22.107  1.00 38.05           N  
ATOM   2445  CZ  ARG    24       8.082  34.418  21.588  1.00 44.07           C  
ATOM   2446  NH1 ARG    24       6.967  33.942  22.177  1.00 42.70           N  
ATOM   2447  NH2 ARG    24       8.546  33.870  20.459  1.00 45.28           N  
ATOM   2448  N   ASN    25      10.895  40.725  24.167  1.00 21.49           N  
ATOM   2449  CA  ASN    25      12.148  41.416  23.942  1.00 22.19           C  
ATOM   2450  C   ASN    25      13.279  40.757  24.734  1.00 22.73           C  
ATOM   2451  O   ASN    25      13.014  39.916  25.629  1.00 21.85           O  
ATOM   2452  CB  ASN    25      12.013  42.934  24.202  1.00 22.64           C  
ATOM   2453  CG  ASN    25      12.798  43.753  23.170  1.00 26.88           C  
ATOM   2454  OD1 ASN    25      13.753  43.235  22.568  1.00 28.47           O  
ATOM   2455  ND2 ASN    25      12.428  45.001  22.984  1.00 30.76           N  
ATOM   2456  N   ALA    26      14.523  41.037  24.336  1.00 21.43           N  
ATOM   2457  CA  ALA    26      15.709  40.717  25.108  1.00 21.49           C  
ATOM   2458  C   ALA    26      16.466  42.041  25.280  1.00 21.80           C  
ATOM   2459  O   ALA    26      16.889  42.659  24.285  1.00 22.20           O  
ATOM   2460  CB  ALA    26      16.571  39.689  24.411  1.00 21.44           C  
ATOM   2461  N   ILE    27      16.624  42.478  26.528  1.00 20.13           N  
ATOM   2462  CA  ILE    27      17.249  43.752  26.821  1.00 21.30           C  
ATOM   2463  C   ILE    27      18.574  43.540  27.567  1.00 21.53           C  
ATOM   2464  O   ILE    27      18.592  43.058  28.700  1.00 21.36           O  
ATOM   2465  CB  ILE    27      16.291  44.646  27.671  1.00 20.92           C  
ATOM   2466  CG1 ILE    27      14.860  44.610  27.095  1.00 19.93           C  
ATOM   2467  CG2 ILE    27      16.885  46.122  27.878  1.00 20.84           C  
ATOM   2468  CD1 ILE    27      13.821  45.431  27.960  1.00 21.99           C  
ATOM   2469  N   PRO    28      19.701  43.874  26.924  1.00 22.24           N  
ATOM   2470  CA  PRO    28      20.988  43.743  27.613  1.00 21.87           C  
ATOM   2471  C   PRO    28      21.022  44.739  28.780  1.00 22.14           C  
ATOM   2472  O   PRO    28      20.562  45.897  28.653  1.00 21.65           O  
ATOM   2473  CB  PRO    28      22.009  44.106  26.531  1.00 22.33           C  
ATOM   2474  CG  PRO    28      21.290  43.872  25.249  1.00 23.40           C  
ATOM   2475  CD  PRO    28      19.857  44.303  25.527  1.00 22.73           C  
ATOM   2476  N   TYR    29      21.582  44.304  29.898  1.00 22.59           N  
ATOM   2477  CA  TYR    29      21.569  45.099  31.103  1.00 23.62           C  
ATOM   2478  C   TYR    29      22.967  45.064  31.671  1.00 24.34           C  
ATOM   2479  O   TYR    29      23.603  44.024  31.723  1.00 23.24           O  
ATOM   2480  CB  TYR    29      20.577  44.483  32.111  1.00 23.34           C  
ATOM   2481  CG  TYR    29      20.313  45.322  33.347  1.00 24.20           C  
ATOM   2482  CD1 TYR    29      19.114  46.040  33.482  1.00 22.79           C  
ATOM   2483  CD2 TYR    29      21.246  45.413  34.373  1.00 24.97           C  
ATOM   2484  CE1 TYR    29      18.855  46.857  34.605  1.00 23.92           C  
ATOM   2485  CE2 TYR    29      20.998  46.222  35.507  1.00 24.72           C  
ATOM   2486  CZ  TYR    29      19.781  46.913  35.616  1.00 24.68           C  
ATOM   2487  OH  TYR    29      19.527  47.671  36.723  1.00 24.65           O  
ATOM   2488  N   LEU    30      23.416  46.212  32.130  0.50 25.99           N  
ATOM   2490  CA  LEU    30      24.706  46.278  32.776  0.50 28.59           C  
ATOM   2492  C   LEU    30      24.605  46.993  34.110  0.50 29.35           C  
ATOM   2494  O   LEU    30      24.173  48.131  34.175  0.50 29.81           O  
ATOM   2496  CB  LEU    30      25.732  46.938  31.843  0.50 28.70           C  
ATOM   2498  CG  LEU    30      25.254  47.864  30.709  0.50 30.20           C  
ATOM   2500  CD1 LEU    30      24.754  49.205  31.253  0.50 29.22           C  
ATOM   2502  CD2 LEU    30      26.362  48.088  29.668  0.50 29.23           C  
ATOM   2504  N   ASP    31      24.981  46.311  35.180  1.00 30.77           N  
ATOM   2505  CA  ASP    31      25.128  46.979  36.464  1.00 33.90           C  
ATOM   2506  C   ASP    31      26.606  47.388  36.582  1.00 36.00           C  
ATOM   2507  O   ASP    31      27.475  46.614  37.059  1.00 35.64           O  
ATOM   2508  CB  ASP    31      24.691  46.097  37.647  1.00 34.56           C  
ATOM   2509  CG  ASP    31      25.144  46.671  38.993  1.00 38.38           C  
ATOM   2510  OD1 ASP    31      25.166  47.916  39.132  1.00 45.81           O  
ATOM   2511  OD2 ASP    31      25.532  45.898  39.890  1.00 41.40           O  
ATOM   2512  N   ASP    32      26.863  48.604  36.127  1.00 37.68           N  
ATOM   2513  CA  ASP    32      28.192  49.209  36.132  1.00 40.44           C  
ATOM   2514  C   ASP    32      28.782  49.407  37.544  1.00 40.00           C  
ATOM   2515  O   ASP    32      30.011  49.419  37.738  1.00 40.64           O  
ATOM   2516  CB  ASP    32      28.093  50.574  35.441  1.00 41.43           C  
ATOM   2517  CG  ASP    32      29.336  50.915  34.644  1.00 46.56           C  
ATOM   2518  OD1 ASP    32      29.596  50.204  33.627  1.00 51.02           O  
ATOM   2519  OD2 ASP    32      30.039  51.898  35.026  1.00 49.92           O  
ATOM   2520  N   ASP    33      27.893  49.590  38.511  1.00 39.69           N  
ATOM   2521  CA  ASP    33      28.275  49.826  39.894  1.00 39.44           C  
ATOM   2522  C   ASP    33      28.950  48.601  40.564  1.00 38.76           C  
ATOM   2523  O   ASP    33      30.156  48.603  40.776  1.00 38.67           O  
ATOM   2524  CB  ASP    33      27.043  50.307  40.682  1.00 39.88           C  
ATOM   2525  CG  ASP    33      27.337  50.517  42.161  1.00 41.57           C  
ATOM   2526  OD1 ASP    33      28.388  51.110  42.494  1.00 41.49           O  
ATOM   2527  OD2 ASP    33      26.511  50.081  42.987  1.00 43.79           O  
ATOM   2528  N   ARG    34      28.182  47.561  40.890  1.00 37.53           N  
ATOM   2529  CA  ARG    34      28.740  46.406  41.604  1.00 37.03           C  
ATOM   2530  C   ARG    34      28.990  45.151  40.735  1.00 35.76           C  
ATOM   2531  O   ARG    34      29.484  44.138  41.232  1.00 35.51           O  
ATOM   2532  CB  ARG    34      27.876  46.059  42.841  1.00 37.02           C  
ATOM   2533  CG  ARG    34      28.105  47.033  44.008  1.00 38.47           C  
ATOM   2534  CD  ARG    34      27.372  46.645  45.249  1.00 39.74           C  
ATOM   2535  NE  ARG    34      27.591  47.616  46.321  1.00 39.29           N  
ATOM   2536  CZ  ARG    34      28.484  47.492  47.306  1.00 39.30           C  
ATOM   2537  NH1 ARG    34      29.287  46.425  47.383  1.00 37.64           N  
ATOM   2538  NH2 ARG    34      28.564  48.449  48.235  1.00 37.48           N  
ATOM   2539  N   ASN    35      28.674  45.222  39.450  1.00 34.34           N  
ATOM   2540  CA  ASN    35      28.826  44.038  38.590  1.00 33.48           C  
ATOM   2541  C   ASN    35      29.285  44.417  37.185  1.00 33.63           C  
ATOM   2542  O   ASN    35      28.774  43.861  36.202  1.00 32.27           O  
ATOM   2543  CB  ASN    35      27.514  43.239  38.531  1.00 33.21           C  
ATOM   2544  CG  ASN    35      27.135  42.615  39.882  1.00 31.35           C  
ATOM   2545  OD1 ASN    35      27.652  41.554  40.272  1.00 33.21           O  
ATOM   2546  ND2 ASN    35      26.235  43.271  40.598  1.00 27.61           N  
ATOM   2547  N   ALA    36      30.245  45.356  37.094  1.00 33.38           N  
ATOM   2548  CA  ALA    36      30.776  45.822  35.789  1.00 33.88           C  
ATOM   2549  C   ALA    36      31.379  44.676  34.998  1.00 33.73           C  
ATOM   2550  O   ALA    36      31.306  44.654  33.773  1.00 35.00           O  
ATOM   2551  CB  ALA    36      31.827  46.940  35.965  1.00 34.37           C  
ATOM   2552  N   ASP    37      31.945  43.696  35.692  1.00 32.87           N  
ATOM   2553  CA  ASP    37      32.533  42.577  34.991  1.00 31.80           C  
ATOM   2554  C   ASP    37      31.469  41.626  34.426  1.00 29.62           C  
ATOM   2555  O   ASP    37      31.822  40.731  33.656  1.00 30.41           O  
ATOM   2556  CB  ASP    37      33.548  41.832  35.910  1.00 33.03           C  
ATOM   2557  CG  ASP    37      34.396  40.738  35.156  1.00 36.33           C  
ATOM   2558  OD1 ASP    37      34.937  41.025  34.037  1.00 38.28           O  
ATOM   2559  OD2 ASP    37      34.550  39.606  35.693  1.00 33.76           O  
ATOM   2560  N   ARG    38      30.187  41.822  34.790  0.60 28.36           N  
ATOM   2562  CA  ARG    38      29.158  40.784  34.594  0.60 25.98           C  
ATOM   2564  C   ARG    38      27.828  41.270  33.989  0.60 25.67           C  
ATOM   2566  O   ARG    38      26.822  41.433  34.690  0.60 25.96           O  
ATOM   2568  CB  ARG    38      28.877  40.065  35.917  0.60 25.98           C  
ATOM   2570  CG  ARG    38      29.998  39.191  36.418  0.60 22.67           C  
ATOM   2572  CD  ARG    38      29.705  38.699  37.818  0.60 23.18           C  
ATOM   2574  NE  ARG    38      29.684  39.797  38.784  0.60 21.00           N  
ATOM   2576  CZ  ARG    38      30.765  40.381  39.296  0.60 21.22           C  
ATOM   2578  NH1 ARG    38      31.984  39.995  38.930  0.60 16.57           N  
ATOM   2580  NH2 ARG    38      30.620  41.386  40.160  0.60 20.40           N  
ATOM   2582  N   PRO    39      27.813  41.503  32.686  1.00 25.01           N  
ATOM   2583  CA  PRO    39      26.535  41.832  32.084  1.00 24.18           C  
ATOM   2584  C   PRO    39      25.507  40.689  32.155  1.00 22.35           C  
ATOM   2585  O   PRO    39      25.869  39.506  32.408  1.00 20.73           O  
ATOM   2586  CB  PRO    39      26.900  42.121  30.627  1.00 25.00           C  
ATOM   2587  CG  PRO    39      28.225  41.433  30.407  1.00 26.65           C  
ATOM   2588  CD  PRO    39      28.931  41.535  31.717  1.00 24.63           C  
ATOM   2589  N   PHE    40      24.233  41.044  31.944  1.00 20.31           N  
ATOM   2590  CA  PHE    40      23.178  40.008  31.858  1.00 19.79           C  
ATOM   2591  C   PHE    40      22.042  40.542  31.013  1.00 19.16           C  
ATOM   2592  O   PHE    40      22.140  41.650  30.491  1.00 20.14           O  
ATOM   2593  CB  PHE    40      22.746  39.521  33.245  1.00 18.50           C  
ATOM   2594  CG  PHE    40      22.105  40.584  34.117  1.00 16.18           C  
ATOM   2595  CD1 PHE    40      20.692  40.644  34.234  1.00 20.77           C  
ATOM   2596  CD2 PHE    40      22.882  41.435  34.881  1.00 18.45           C  
ATOM   2597  CE1 PHE    40      20.058  41.585  35.059  1.00 19.48           C  
ATOM   2598  CE2 PHE    40      22.297  42.399  35.731  1.00 18.92           C  
ATOM   2599  CZ  PHE    40      20.889  42.485  35.842  1.00 18.59           C  
ATOM   2600  N   THR    41      21.003  39.745  30.837  1.00 18.95           N  
ATOM   2601  CA  THR    41      19.950  40.040  29.862  1.00 19.34           C  
ATOM   2602  C   THR    41      18.575  40.027  30.556  1.00 18.58           C  
ATOM   2603  O   THR    41      18.316  39.163  31.367  1.00 19.96           O  
ATOM   2604  CB  THR    41      19.935  38.958  28.751  1.00 19.88           C  
ATOM   2605  OG1 THR    41      21.190  39.015  28.084  1.00 21.90           O  
ATOM   2606  CG2 THR    41      18.856  39.270  27.752  1.00 21.30           C  
ATOM   2607  N   LEU    42      17.707  40.974  30.227  1.00 16.68           N  
ATOM   2608  CA  LEU    42      16.299  40.849  30.653  1.00 16.60           C  
ATOM   2609  C   LEU    42      15.523  40.283  29.491  1.00 16.78           C  
ATOM   2610  O   LEU    42      15.412  40.953  28.457  1.00 17.46           O  
ATOM   2611  CB  LEU    42      15.715  42.217  31.006  1.00 16.21           C  
ATOM   2612  CG  LEU    42      16.527  42.992  32.047  1.00 18.44           C  
ATOM   2613  CD1 LEU    42      15.920  44.391  32.298  1.00 18.50           C  
ATOM   2614  CD2 LEU    42      16.697  42.185  33.375  1.00 19.33           C  
ATOM   2615  N   ASN    43      15.038  39.059  29.616  1.00 16.18           N  
ATOM   2616  CA  ASN    43      14.135  38.492  28.607  1.00 16.88           C  
ATOM   2617  C   ASN    43      12.712  38.863  29.065  1.00 17.34           C  
ATOM   2618  O   ASN    43      12.293  38.485  30.180  1.00 18.01           O  
ATOM   2619  CB  ASN    43      14.330  36.976  28.493  1.00 17.74           C  
ATOM   2620  CG  ASN    43      15.586  36.638  27.716  1.00 19.39           C  
ATOM   2621  OD1 ASN    43      15.652  36.922  26.538  1.00 18.35           O  
ATOM   2622  ND2 ASN    43      16.609  36.098  28.384  1.00 18.58           N  
ATOM   2623  N   THR    44      12.022  39.705  28.282  1.00 16.52           N  
ATOM   2624  CA  THR    44      10.792  40.370  28.772  1.00 17.04           C  
ATOM   2625  C   THR    44       9.595  40.029  27.915  1.00 18.02           C  
ATOM   2626  O   THR    44       9.753  39.603  26.759  1.00 18.12           O  
ATOM   2627  CB  THR    44      10.974  41.917  28.760  1.00 19.27           C  
ATOM   2628  OG1 THR    44      11.236  42.358  27.415  1.00 19.42           O  
ATOM   2629  CG2 THR    44      12.182  42.303  29.671  1.00 18.65           C  
ATOM   2630  N   TYR    45       8.393  40.219  28.476  1.00 16.02           N  
ATOM   2631  CA  TYR    45       7.183  40.214  27.651  1.00 16.24           C  
ATOM   2632  C   TYR    45       6.256  41.308  28.124  1.00 15.80           C  
ATOM   2633  O   TYR    45       5.955  41.355  29.306  1.00 17.28           O  
ATOM   2634  CB  TYR    45       6.439  38.885  27.748  1.00 15.20           C  
ATOM   2635  CG  TYR    45       5.204  38.865  26.886  1.00 15.96           C  
ATOM   2636  CD1 TYR    45       5.307  38.726  25.482  1.00 15.35           C  
ATOM   2637  CD2 TYR    45       3.933  38.953  27.457  1.00 16.43           C  
ATOM   2638  CE1 TYR    45       4.168  38.677  24.688  1.00 17.80           C  
ATOM   2639  CE2 TYR    45       2.764  38.924  26.654  1.00 15.04           C  
ATOM   2640  CZ  TYR    45       2.903  38.773  25.287  1.00 17.45           C  
ATOM   2641  OH  TYR    45       1.797  38.711  24.486  1.00 18.81           O  
ATOM   2642  N   ARG    46       5.782  42.140  27.201  1.00 16.52           N  
ATOM   2643  CA  ARG    46       4.799  43.156  27.479  1.00 16.96           C  
ATOM   2644  C   ARG    46       3.522  42.848  26.683  1.00 17.14           C  
ATOM   2645  O   ARG    46       3.577  42.719  25.462  1.00 17.11           O  
ATOM   2646  CB  ARG    46       5.338  44.542  27.135  1.00 17.13           C  
ATOM   2647  CG  ARG    46       4.316  45.613  27.398  1.00 20.23           C  
ATOM   2648  CD  ARG    46       4.797  46.958  26.903  1.00 23.15           C  
ATOM   2649  NE  ARG    46       3.721  47.906  27.098  1.00 23.90           N  
ATOM   2650  CZ  ARG    46       3.823  49.013  27.805  1.00 26.23           C  
ATOM   2651  NH1 ARG    46       2.751  49.783  27.923  1.00 27.03           N  
ATOM   2652  NH2 ARG    46       4.996  49.360  28.366  1.00 23.30           N  
ATOM   2653  N   PRO    47       2.394  42.615  27.388  1.00 17.81           N  
ATOM   2654  CA  PRO    47       1.150  42.256  26.677  1.00 17.24           C  
ATOM   2655  C   PRO    47       0.558  43.515  26.034  1.00 18.56           C  
ATOM   2656  O   PRO    47       0.915  44.640  26.420  1.00 17.98           O  
ATOM   2657  CB  PRO    47       0.228  41.717  27.788  1.00 17.46           C  
ATOM   2658  CG  PRO    47       0.658  42.432  29.034  1.00 17.40           C  
ATOM   2659  CD  PRO    47       2.227  42.639  28.858  1.00 17.10           C  
ATOM   2660  N   TYR    48      -0.311  43.336  25.038  1.00 19.61           N  
ATOM   2661  CA  TYR    48      -1.134  44.467  24.602  1.00 21.83           C  
ATOM   2662  C   TYR    48      -2.029  44.900  25.748  1.00 22.45           C  
ATOM   2663  O   TYR    48      -2.466  44.078  26.556  1.00 24.16           O  
ATOM   2664  CB  TYR    48      -1.965  44.099  23.351  1.00 23.83           C  
ATOM   2665  CG  TYR    48      -1.104  44.038  22.092  1.00 24.69           C  
ATOM   2666  CD1 TYR    48      -0.858  45.185  21.337  1.00 26.78           C  
ATOM   2667  CD2 TYR    48      -0.519  42.837  21.682  1.00 27.74           C  
ATOM   2668  CE1 TYR    48      -0.050  45.148  20.192  1.00 27.29           C  
ATOM   2669  CE2 TYR    48       0.297  42.792  20.523  1.00 28.56           C  
ATOM   2670  CZ  TYR    48       0.509  43.946  19.792  1.00 28.24           C  
ATOM   2671  OH  TYR    48       1.292  43.914  18.647  1.00 31.40           O  
ATOM   2672  N   GLY    49      -2.232  46.204  25.834  1.00 24.53           N  
ATOM   2673  CA  GLY    49      -3.101  46.821  26.822  1.00 24.50           C  
ATOM   2674  C   GLY    49      -2.441  46.942  28.181  1.00 24.71           C  
ATOM   2675  O   GLY    49      -3.133  47.162  29.168  1.00 25.49           O  
ATOM   2676  N   TYR    50      -1.119  46.754  28.256  1.00 23.11           N  
ATOM   2677  CA  TYR    50      -0.412  46.949  29.529  1.00 21.00           C  
ATOM   2678  C   TYR    50      -0.404  48.415  29.937  1.00 21.16           C  
ATOM   2679  O   TYR    50      -0.195  49.327  29.088  1.00 20.23           O  
ATOM   2680  CB  TYR    50       1.021  46.401  29.494  1.00 20.04           C  
ATOM   2681  CG  TYR    50       1.662  46.461  30.850  1.00 19.12           C  
ATOM   2682  CD1 TYR    50       2.537  47.509  31.164  1.00 18.03           C  
ATOM   2683  CD2 TYR    50       1.325  45.511  31.863  1.00 17.68           C  
ATOM   2684  CE1 TYR    50       3.119  47.611  32.459  1.00 16.15           C  
ATOM   2685  CE2 TYR    50       1.899  45.572  33.153  1.00 16.48           C  
ATOM   2686  CZ  TYR    50       2.807  46.643  33.429  1.00 18.46           C  
ATOM   2687  OH  TYR    50       3.350  46.735  34.675  1.00 19.84           O  
ATOM   2688  N   THR    51      -0.671  48.656  31.224  1.00 20.97           N  
ATOM   2689  CA  THR    51      -0.587  49.993  31.789  1.00 22.14           C  
ATOM   2690  C   THR    51       0.258  49.956  33.081  1.00 21.72           C  
ATOM   2691  O   THR    51       0.384  48.884  33.704  1.00 22.20           O  
ATOM   2692  CB  THR    51      -1.969  50.591  32.052  1.00 22.56           C  
ATOM   2693  OG1 THR    51      -2.659  49.740  32.960  1.00 26.49           O  
ATOM   2694  CG2 THR    51      -2.794  50.740  30.746  1.00 24.66           C  
ATOM   2695  N   PRO    52       0.876  51.104  33.455  1.00 22.91           N  
ATOM   2696  CA  PRO    52       1.904  51.066  34.526  1.00 23.26           C  
ATOM   2697  C   PRO    52       1.390  50.658  35.919  1.00 23.32           C  
ATOM   2698  O   PRO    52       2.199  50.302  36.765  1.00 24.57           O  
ATOM   2699  CB  PRO    52       2.533  52.474  34.507  1.00 23.84           C  
ATOM   2700  CG  PRO    52       1.655  53.326  33.649  1.00 25.14           C  
ATOM   2701  CD  PRO    52       0.763  52.435  32.815  1.00 23.05           C  
ATOM   2702  N   ASP    53       0.066  50.653  36.133  1.00 22.64           N  
ATOM   2703  CA  ASP    53      -0.516  50.190  37.410  1.00 23.17           C  
ATOM   2704  C   ASP    53      -0.626  48.668  37.502  1.00 21.87           C  
ATOM   2705  O   ASP    53      -0.927  48.113  38.567  1.00 22.14           O  
ATOM   2706  CB  ASP    53      -1.916  50.748  37.561  1.00 25.50           C  
ATOM   2707  CG  ASP    53      -2.808  50.356  36.395  1.00 30.49           C  
ATOM   2708  OD1 ASP    53      -2.653  50.927  35.282  1.00 34.89           O  
ATOM   2709  OD2 ASP    53      -3.631  49.431  36.578  1.00 36.91           O  
ATOM   2710  N   ARG    54      -0.427  47.986  36.394  1.00 20.43           N  
ATOM   2711  CA  ARG    54      -0.595  46.524  36.379  1.00 19.14           C  
ATOM   2712  C   ARG    54       0.603  45.733  36.962  1.00 18.90           C  
ATOM   2713  O   ARG    54       1.680  46.246  37.076  1.00 18.75           O  
ATOM   2714  CB  ARG    54      -0.935  46.051  34.968  1.00 19.33           C  
ATOM   2715  CG  ARG    54      -2.239  46.588  34.349  1.00 23.10           C  
ATOM   2716  CD  ARG    54      -3.549  45.892  34.802  1.00 31.02           C  
ATOM   2717  NE  ARG    54      -3.517  44.424  35.035  1.00 36.19           N  
ATOM   2718  CZ  ARG    54      -3.985  43.823  36.150  1.00 40.69           C  
ATOM   2719  NH1 ARG    54      -4.486  44.543  37.172  1.00 42.88           N  
ATOM   2720  NH2 ARG    54      -3.945  42.498  36.285  1.00 37.76           N  
ATOM   2721  N   PRO    55       0.402  44.456  37.341  1.00 18.75           N  
ATOM   2722  CA  PRO    55       1.494  43.748  38.024  1.00 17.61           C  
ATOM   2723  C   PRO    55       2.727  43.505  37.165  1.00 16.37           C  
ATOM   2724  O   PRO    55       2.670  43.486  35.929  1.00 18.84           O  
ATOM   2725  CB  PRO    55       0.875  42.399  38.406  1.00 17.55           C  
ATOM   2726  CG  PRO    55      -0.629  42.645  38.377  1.00 20.27           C  
ATOM   2727  CD  PRO    55      -0.817  43.649  37.267  1.00 18.13           C  
ATOM   2728  N   VAL    56       3.835  43.296  37.847  1.00 16.22           N  
ATOM   2729  CA  VAL    56       5.101  42.957  37.220  1.00 15.16           C  
ATOM   2730  C   VAL    56       5.457  41.605  37.843  1.00 16.45           C  
ATOM   2731  O   VAL    56       5.360  41.431  39.077  1.00 16.61           O  
ATOM   2732  CB  VAL    56       6.147  44.025  37.572  1.00 14.91           C  
ATOM   2733  CG1 VAL    56       7.546  43.615  37.022  1.00 15.55           C  
ATOM   2734  CG2 VAL    56       5.650  45.422  37.028  1.00 16.93           C  
ATOM   2735  N   VAL    57       5.809  40.639  36.996  1.00 14.65           N  
ATOM   2736  CA  VAL    57       6.232  39.313  37.511  1.00 14.93           C  
ATOM   2737  C   VAL    57       7.723  39.140  37.177  1.00 15.55           C  
ATOM   2738  O   VAL    57       8.091  39.202  36.017  1.00 16.94           O  
ATOM   2739  CB  VAL    57       5.435  38.209  36.884  1.00 15.43           C  
ATOM   2740  CG1 VAL    57       5.903  36.867  37.517  1.00 13.58           C  
ATOM   2741  CG2 VAL    57       3.970  38.408  37.147  1.00 14.36           C  
ATOM   2742  N   VAL    58       8.580  38.959  38.183  1.00 15.63           N  
ATOM   2743  CA  VAL    58      10.016  38.703  37.907  1.00 13.89           C  
ATOM   2744  C   VAL    58      10.102  37.164  37.941  1.00 14.12           C  
ATOM   2745  O   VAL    58       9.666  36.559  38.929  1.00 15.57           O  
ATOM   2746  CB  VAL    58      10.909  39.298  38.956  1.00 12.84           C  
ATOM   2747  CG1 VAL    58      12.430  38.924  38.771  1.00 15.19           C  
ATOM   2748  CG2 VAL    58      10.751  40.908  38.935  1.00 13.60           C  
ATOM   2749  N   VAL    59      10.678  36.571  36.900  1.00 14.48           N  
ATOM   2750  CA  VAL    59      10.725  35.124  36.776  1.00 13.90           C  
ATOM   2751  C   VAL    59      12.200  34.680  36.692  1.00 16.04           C  
ATOM   2752  O   VAL    59      12.947  35.119  35.789  1.00 15.42           O  
ATOM   2753  CB  VAL    59       9.972  34.708  35.464  1.00 17.19           C  
ATOM   2754  CG1 VAL    59      10.162  33.202  35.173  1.00 16.26           C  
ATOM   2755  CG2 VAL    59       8.452  35.144  35.549  1.00 14.90           C  
ATOM   2756  N   GLN    60      12.601  33.734  37.551  1.00 15.50           N  
ATOM   2757  CA  GLN    60      14.016  33.309  37.585  1.00 14.51           C  
ATOM   2758  C   GLN    60      14.112  31.864  37.103  1.00 15.15           C  
ATOM   2759  O   GLN    60      13.489  30.965  37.661  1.00 14.42           O  
ATOM   2760  CB  GLN    60      14.583  33.408  39.021  1.00 14.77           C  
ATOM   2761  CG  GLN    60      14.740  34.848  39.478  1.00 15.98           C  
ATOM   2762  CD  GLN    60      15.711  35.599  38.564  1.00 19.95           C  
ATOM   2763  OE1 GLN    60      16.579  34.969  37.899  1.00 22.02           O  
ATOM   2764  NE2 GLN    60      15.545  36.909  38.468  1.00 15.99           N  
ATOM   2765  N   HIS    61      14.921  31.692  36.064  1.00 15.71           N  
ATOM   2766  CA  HIS    61      15.141  30.437  35.376  1.00 16.01           C  
ATOM   2767  C   HIS    61      15.866  29.431  36.313  1.00 15.08           C  
ATOM   2768  O   HIS    61      16.454  29.839  37.326  1.00 15.11           O  
ATOM   2769  CB  HIS    61      16.009  30.782  34.127  1.00 16.44           C  
ATOM   2770  CG  HIS    61      17.353  31.378  34.469  1.00 16.22           C  
ATOM   2771  ND1 HIS    61      17.776  32.632  34.038  1.00 19.50           N  
ATOM   2772  CD2 HIS    61      18.384  30.867  35.184  1.00 13.35           C  
ATOM   2773  CE1 HIS    61      18.999  32.873  34.495  1.00 12.65           C  
ATOM   2774  NE2 HIS    61      19.381  31.825  35.209  1.00 19.45           N  
ATOM   2775  N   GLY    62      15.849  28.131  35.974  1.00 16.45           N  
ATOM   2776  CA  GLY    62      16.681  27.196  36.701  1.00 16.61           C  
ATOM   2777  C   GLY    62      18.093  27.035  36.118  1.00 17.96           C  
ATOM   2778  O   GLY    62      18.658  27.938  35.555  1.00 15.36           O  
ATOM   2779  N   VAL    63      18.620  25.834  36.240  1.00 16.79           N  
ATOM   2780  CA  VAL    63      20.063  25.579  36.009  1.00 19.91           C  
ATOM   2781  C   VAL    63      20.503  25.731  34.519  1.00 19.47           C  
ATOM   2782  O   VAL    63      21.690  25.960  34.206  1.00 21.25           O  
ATOM   2783  CB  VAL    63      20.432  24.184  36.611  1.00 19.53           C  
ATOM   2784  CG1 VAL    63      19.921  23.065  35.724  1.00 21.79           C  
ATOM   2785  CG2 VAL    63      21.972  24.060  36.824  1.00 24.34           C  
ATOM   2786  N   LEU    64      19.553  25.617  33.592  1.00 18.32           N  
ATOM   2787  CA  LEU    64      19.856  25.767  32.169  1.00 19.32           C  
ATOM   2788  C   LEU    64      20.053  27.238  31.760  1.00 18.07           C  
ATOM   2789  O   LEU    64      20.511  27.490  30.638  1.00 19.15           O  
ATOM   2790  CB  LEU    64      18.735  25.159  31.293  1.00 18.81           C  
ATOM   2791  CG  LEU    64      18.411  23.672  31.539  1.00 23.89           C  
ATOM   2792  CD1 LEU    64      17.393  23.197  30.502  1.00 26.94           C  
ATOM   2793  CD2 LEU    64      19.641  22.825  31.466  1.00 27.65           C  
ATOM   2794  N   ARG    65      19.726  28.188  32.648  1.00 17.17           N  
ATOM   2795  CA  ARG    65      19.910  29.631  32.395  1.00 16.65           C  
ATOM   2796  C   ARG    65      19.025  30.046  31.190  1.00 17.27           C  
ATOM   2797  O   ARG    65      19.366  30.943  30.406  1.00 16.36           O  
ATOM   2798  CB  ARG    65      21.424  30.014  32.180  1.00 17.33           C  
ATOM   2799  CG  ARG    65      22.410  29.363  33.177  1.00 16.02           C  
ATOM   2800  CD  ARG    65      22.074  29.708  34.632  1.00 15.99           C  
ATOM   2801  NE  ARG    65      23.110  29.285  35.590  1.00 17.61           N  
ATOM   2802  CZ  ARG    65      24.257  29.938  35.836  1.00 16.67           C  
ATOM   2803  NH1 ARG    65      24.512  31.116  35.266  1.00 15.11           N  
ATOM   2804  NH2 ARG    65      25.122  29.464  36.741  1.00 14.12           N  
ATOM   2805  N   ASN    66      17.898  29.346  31.040  1.00 16.10           N  
ATOM   2806  CA  ASN    66      17.044  29.551  29.875  1.00 17.17           C  
ATOM   2807  C   ASN    66      15.942  30.572  30.207  1.00 17.31           C  
ATOM   2808  O   ASN    66      14.752  30.269  30.280  1.00 18.31           O  
ATOM   2809  CB  ASN    66      16.540  28.182  29.369  1.00 17.33           C  
ATOM   2810  CG  ASN    66      15.780  27.426  30.440  1.00 19.91           C  
ATOM   2811  OD1 ASN    66      16.009  27.627  31.641  1.00 21.16           O  
ATOM   2812  ND2 ASN    66      14.839  26.568  30.008  1.00 19.69           N  
ATOM   2813  N   GLY    67      16.376  31.824  30.421  1.00 16.98           N  
ATOM   2814  CA  GLY    67      15.460  32.907  30.725  1.00 18.01           C  
ATOM   2815  C   GLY    67      14.422  33.185  29.636  1.00 17.64           C  
ATOM   2816  O   GLY    67      13.263  33.500  29.956  1.00 18.01           O  
ATOM   2817  N   ALA    68      14.801  33.060  28.362  1.00 18.35           N  
ATOM   2818  CA  ALA    68      13.830  33.308  27.268  1.00 17.87           C  
ATOM   2819  C   ALA    68      12.718  32.249  27.339  1.00 18.35           C  
ATOM   2820  O   ALA    68      11.538  32.561  27.091  1.00 17.88           O  
ATOM   2821  CB  ALA    68      14.512  33.297  25.881  1.00 19.34           C  
ATOM   2822  N   ASP    69      13.097  31.016  27.689  1.00 16.64           N  
ATOM   2823  CA  ASP    69      12.149  29.927  27.795  1.00 18.09           C  
ATOM   2824  C   ASP    69      11.213  30.213  28.960  1.00 16.91           C  
ATOM   2825  O   ASP    69       9.988  30.074  28.811  1.00 15.63           O  
ATOM   2826  CB  ASP    69      12.864  28.613  28.079  1.00 19.45           C  
ATOM   2827  CG  ASP    69      13.362  27.875  26.843  1.00 25.06           C  
ATOM   2828  OD1 ASP    69      13.112  28.276  25.673  1.00 29.81           O  
ATOM   2829  OD2 ASP    69      14.003  26.826  27.082  1.00 26.91           O  
ATOM   2830  N   TYR    70      11.752  30.673  30.110  1.00 15.60           N  
ATOM   2831  CA  TYR    70      10.889  30.937  31.263  1.00 17.01           C  
ATOM   2832  C   TYR    70       9.955  32.114  30.991  1.00 15.77           C  
ATOM   2833  O   TYR    70       8.783  32.121  31.408  1.00 16.16           O  
ATOM   2834  CB  TYR    70      11.727  31.209  32.545  1.00 18.12           C  
ATOM   2835  CG  TYR    70      11.947  29.894  33.254  1.00 18.64           C  
ATOM   2836  CD1 TYR    70      11.016  29.425  34.196  1.00 20.53           C  
ATOM   2837  CD2 TYR    70      13.002  29.067  32.889  1.00 16.48           C  
ATOM   2838  CE1 TYR    70      11.177  28.191  34.800  1.00 19.92           C  
ATOM   2839  CE2 TYR    70      13.175  27.787  33.494  1.00 18.31           C  
ATOM   2840  CZ  TYR    70      12.263  27.392  34.479  1.00 18.78           C  
ATOM   2841  OH  TYR    70      12.412  26.137  35.075  1.00 21.36           O  
ATOM   2842  N   ARG    71      10.483  33.121  30.299  1.00 16.52           N  
ATOM   2843  CA  ARG    71       9.655  34.289  29.914  1.00 16.51           C  
ATOM   2844  C   ARG    71       8.445  33.784  29.078  1.00 17.88           C  
ATOM   2845  O   ARG    71       7.289  34.202  29.297  1.00 18.00           O  
ATOM   2846  CB  ARG    71      10.512  35.256  29.103  1.00 16.36           C  
ATOM   2847  CG  ARG    71       9.741  36.498  28.548  1.00 18.68           C  
ATOM   2848  CD  ARG    71       9.093  36.274  27.177  1.00 18.23           C  
ATOM   2849  NE  ARG    71       9.972  35.521  26.261  1.00 20.94           N  
ATOM   2850  CZ  ARG    71      11.059  36.011  25.658  1.00 20.61           C  
ATOM   2851  NH1 ARG    71      11.422  37.284  25.789  1.00 17.18           N  
ATOM   2852  NH2 ARG    71      11.777  35.230  24.867  1.00 19.42           N  
ATOM   2853  N   ASP    72       8.729  32.896  28.131  1.00 17.41           N  
ATOM   2854  CA  ASP    72       7.699  32.263  27.268  1.00 18.22           C  
ATOM   2855  C   ASP    72       6.646  31.482  28.063  1.00 19.08           C  
ATOM   2856  O   ASP    72       5.459  31.524  27.699  1.00 17.08           O  
ATOM   2857  CB  ASP    72       8.326  31.281  26.273  1.00 19.47           C  
ATOM   2858  CG  ASP    72       9.105  31.953  25.133  1.00 20.39           C  
ATOM   2859  OD1 ASP    72       9.129  33.208  24.978  1.00 21.32           O  
ATOM   2860  OD2 ASP    72       9.696  31.170  24.321  1.00 22.20           O  
ATOM   2861  N   PHE    73       7.058  30.761  29.122  1.00 17.67           N  
ATOM   2862  CA  PHE    73       6.054  30.058  29.945  1.00 17.90           C  
ATOM   2863  C   PHE    73       4.972  30.938  30.524  1.00 16.82           C  
ATOM   2864  O   PHE    73       3.828  30.470  30.732  1.00 16.33           O  
ATOM   2865  CB  PHE    73       6.683  29.298  31.118  1.00 17.40           C  
ATOM   2866  CG  PHE    73       7.762  28.311  30.714  1.00 17.41           C  
ATOM   2867  CD1 PHE    73       7.790  27.697  29.417  1.00 18.45           C  
ATOM   2868  CD2 PHE    73       8.751  27.984  31.659  1.00 15.31           C  
ATOM   2869  CE1 PHE    73       8.861  26.737  29.079  1.00 19.92           C  
ATOM   2870  CE2 PHE    73       9.809  27.072  31.329  1.00 20.57           C  
ATOM   2871  CZ  PHE    73       9.865  26.455  30.027  1.00 17.58           C  
ATOM   2872  N   TRP    74       5.327  32.193  30.793  1.00 15.79           N  
ATOM   2873  CA  TRP    74       4.402  33.143  31.405  1.00 16.77           C  
ATOM   2874  C   TRP    74       3.564  33.973  30.421  1.00 17.08           C  
ATOM   2875  O   TRP    74       2.787  34.817  30.869  1.00 16.14           O  
ATOM   2876  CB  TRP    74       5.198  34.098  32.282  1.00 17.02           C  
ATOM   2877  CG  TRP    74       5.552  33.401  33.578  1.00 16.37           C  
ATOM   2878  CD1 TRP    74       6.584  32.528  33.779  1.00 16.34           C  
ATOM   2879  CD2 TRP    74       4.828  33.476  34.823  1.00 17.38           C  
ATOM   2880  NE1 TRP    74       6.572  32.081  35.096  1.00 17.21           N  
ATOM   2881  CE2 TRP    74       5.491  32.631  35.745  1.00 18.05           C  
ATOM   2882  CE3 TRP    74       3.665  34.166  35.245  1.00 20.40           C  
ATOM   2883  CZ2 TRP    74       5.056  32.484  37.106  1.00 18.40           C  
ATOM   2884  CZ3 TRP    74       3.207  34.007  36.611  1.00 18.46           C  
ATOM   2885  CH2 TRP    74       3.916  33.174  37.511  1.00 16.10           C  
ATOM   2886  N   ILE    75       3.776  33.790  29.118  1.00 16.46           N  
ATOM   2887  CA  ILE    75       3.044  34.632  28.107  1.00 16.70           C  
ATOM   2888  C   ILE    75       1.498  34.450  28.215  1.00 16.98           C  
ATOM   2889  O   ILE    75       0.754  35.435  28.206  1.00 16.83           O  
ATOM   2890  CB  ILE    75       3.599  34.439  26.655  1.00 14.96           C  
ATOM   2891  CG1 ILE    75       4.979  35.104  26.535  1.00 16.22           C  
ATOM   2892  CG2 ILE    75       2.608  34.935  25.568  1.00 16.86           C  
ATOM   2893  CD1 ILE    75       5.707  34.878  25.232  1.00 18.52           C  
ATOM   2894  N   PRO    76       1.014  33.193  28.294  1.00 16.67           N  
ATOM   2895  CA  PRO    76      -0.437  33.056  28.428  1.00 17.84           C  
ATOM   2896  C   PRO    76      -1.048  33.764  29.642  1.00 17.60           C  
ATOM   2897  O   PRO    76      -2.130  34.374  29.499  1.00 17.55           O  
ATOM   2898  CB  PRO    76      -0.673  31.529  28.460  1.00 18.12           C  
ATOM   2899  CG  PRO    76       0.561  30.965  27.767  1.00 19.00           C  
ATOM   2900  CD  PRO    76       1.691  31.890  28.127  1.00 17.94           C  
ATOM   2901  N   ALA    77      -0.393  33.709  30.806  1.00 16.67           N  
ATOM   2902  CA  ALA    77      -0.886  34.457  31.993  1.00 15.26           C  
ATOM   2903  C   ALA    77      -0.751  35.939  31.735  1.00 14.04           C  
ATOM   2904  O   ALA    77      -1.619  36.689  32.153  1.00 16.40           O  
ATOM   2905  CB  ALA    77      -0.078  34.139  33.265  1.00 15.58           C  
ATOM   2906  N   ALA    78       0.360  36.359  31.123  1.00 14.30           N  
ATOM   2907  CA  ALA    78       0.630  37.802  30.930  1.00 14.87           C  
ATOM   2908  C   ALA    78      -0.450  38.415  30.020  1.00 15.08           C  
ATOM   2909  O   ALA    78      -0.909  39.564  30.203  1.00 15.32           O  
ATOM   2910  CB  ALA    78       2.013  37.976  30.282  1.00 15.33           C  
ATOM   2911  N   ASP    79      -0.817  37.664  29.007  1.00 15.14           N  
ATOM   2912  CA  ASP    79      -1.848  38.088  28.038  1.00 16.10           C  
ATOM   2913  C   ASP    79      -3.215  38.189  28.708  1.00 16.65           C  
ATOM   2914  O   ASP    79      -3.947  39.200  28.558  1.00 16.59           O  
ATOM   2915  CB  ASP    79      -1.917  37.083  26.911  1.00 16.97           C  
ATOM   2916  CG  ASP    79      -0.840  37.311  25.848  1.00 17.79           C  
ATOM   2917  OD1 ASP    79      -0.321  38.442  25.757  1.00 20.70           O  
ATOM   2918  OD2 ASP    79      -0.574  36.334  25.125  1.00 18.48           O  
ATOM   2919  N   ARG    80      -3.564  37.166  29.479  0.50 16.28           N  
ATOM   2921  CA  ARG    80      -4.868  37.166  30.129  0.50 17.29           C  
ATOM   2923  C   ARG    80      -4.952  38.242  31.226  0.50 17.48           C  
ATOM   2925  O   ARG    80      -5.913  39.019  31.287  0.50 16.90           O  
ATOM   2927  CB  ARG    80      -5.198  35.772  30.664  0.50 17.21           C  
ATOM   2929  CG  ARG    80      -6.217  35.753  31.779  0.50 17.63           C  
ATOM   2931  CD  ARG    80      -7.664  35.938  31.311  0.50 19.88           C  
ATOM   2933  NE  ARG    80      -8.537  35.846  32.490  0.50 16.73           N  
ATOM   2935  CZ  ARG    80      -8.977  36.898  33.165  0.50 16.33           C  
ATOM   2937  NH1 ARG    80      -8.677  38.140  32.754  0.50 16.36           N  
ATOM   2939  NH2 ARG    80      -9.721  36.717  34.248  0.50  9.84           N  
ATOM   2941  N   HIS    81      -3.918  38.310  32.062  1.00 17.88           N  
ATOM   2942  CA  HIS    81      -3.986  39.164  33.261  1.00 17.71           C  
ATOM   2943  C   HIS    81      -3.289  40.505  33.127  1.00 19.23           C  
ATOM   2944  O   HIS    81      -3.349  41.309  34.079  1.00 19.12           O  
ATOM   2945  CB  HIS    81      -3.508  38.394  34.495  1.00 17.43           C  
ATOM   2946  CG  HIS    81      -4.358  37.198  34.827  1.00 16.17           C  
ATOM   2947  ND1 HIS    81      -3.921  35.905  34.659  1.00 23.55           N  
ATOM   2948  CD2 HIS    81      -5.635  37.109  35.261  1.00 15.40           C  
ATOM   2949  CE1 HIS    81      -4.876  35.065  35.025  1.00 16.11           C  
ATOM   2950  NE2 HIS    81      -5.928  35.770  35.386  1.00 22.16           N  
ATOM   2951  N   LYS    82      -2.738  40.778  31.929  1.00 18.34           N  
ATOM   2952  CA  LYS    82      -1.977  42.023  31.628  1.00 18.91           C  
ATOM   2953  C   LYS    82      -0.810  42.188  32.612  1.00 17.91           C  
ATOM   2954  O   LYS    82      -0.740  43.190  33.339  1.00 19.71           O  
ATOM   2955  CB  LYS    82      -2.864  43.280  31.600  1.00 18.67           C  
ATOM   2956  CG  LYS    82      -4.086  43.183  30.717  1.00 24.91           C  
ATOM   2957  CD  LYS    82      -3.699  43.242  29.274  1.00 28.38           C  
ATOM   2958  CE  LYS    82      -4.842  43.734  28.343  1.00 33.19           C  
ATOM   2959  NZ  LYS    82      -6.237  43.349  28.773  1.00 39.18           N  
ATOM   2960  N   LEU    83       0.087  41.213  32.601  1.00 16.87           N  
ATOM   2961  CA  LEU    83       1.271  41.183  33.486  1.00 16.96           C  
ATOM   2962  C   LEU    83       2.451  41.584  32.622  1.00 17.28           C  
ATOM   2963  O   LEU    83       2.571  41.107  31.501  1.00 17.35           O  
ATOM   2964  CB  LEU    83       1.521  39.737  34.012  1.00 17.36           C  
ATOM   2965  CG  LEU    83       0.246  39.085  34.604  1.00 15.99           C  
ATOM   2966  CD1 LEU    83       0.465  37.638  34.983  1.00 18.64           C  
ATOM   2967  CD2 LEU    83      -0.275  39.995  35.784  1.00 16.72           C  
ATOM   2968  N   LEU    84       3.334  42.401  33.169  1.00 15.02           N  
ATOM   2969  CA  LEU    84       4.656  42.609  32.583  1.00 16.17           C  
ATOM   2970  C   LEU    84       5.608  41.503  33.070  1.00 16.43           C  
ATOM   2971  O   LEU    84       5.804  41.367  34.294  1.00 18.70           O  
ATOM   2972  CB  LEU    84       5.204  43.960  33.059  1.00 15.29           C  
ATOM   2973  CG  LEU    84       6.538  44.354  32.406  1.00 16.99           C  
ATOM   2974  CD1 LEU    84       6.287  44.657  30.928  1.00 20.70           C  
ATOM   2975  CD2 LEU    84       7.127  45.606  33.098  1.00 16.00           C  
ATOM   2976  N   ILE    85       6.178  40.722  32.156  1.00 14.81           N  
ATOM   2977  CA  ILE    85       7.076  39.631  32.527  1.00 15.65           C  
ATOM   2978  C   ILE    85       8.514  40.067  32.348  1.00 14.97           C  
ATOM   2979  O   ILE    85       8.886  40.563  31.257  1.00 15.08           O  
ATOM   2980  CB  ILE    85       6.812  38.324  31.702  1.00 14.41           C  
ATOM   2981  CG1 ILE    85       5.327  37.891  31.788  1.00 16.01           C  
ATOM   2982  CG2 ILE    85       7.704  37.171  32.191  1.00 15.76           C  
ATOM   2983  CD1 ILE    85       4.716  37.848  33.172  1.00 13.61           C  
ATOM   2984  N   VAL    86       9.321  39.879  33.392  1.00 15.00           N  
ATOM   2985  CA  VAL    86      10.740  40.197  33.306  1.00 15.66           C  
ATOM   2986  C   VAL    86      11.504  39.003  33.831  1.00 16.45           C  
ATOM   2987  O   VAL    86      11.335  38.620  35.018  1.00 16.58           O  
ATOM   2988  CB  VAL    86      11.102  41.445  34.178  1.00 14.98           C  
ATOM   2989  CG1 VAL    86      12.628  41.775  34.121  1.00 15.55           C  
ATOM   2990  CG2 VAL    86      10.259  42.656  33.740  1.00 19.10           C  
ATOM   2991  N   ALA    87      12.354  38.411  32.984  1.00 16.71           N  
ATOM   2992  CA  ALA    87      13.168  37.277  33.401  1.00 17.30           C  
ATOM   2993  C   ALA    87      14.653  37.660  33.311  1.00 17.70           C  
ATOM   2994  O   ALA    87      15.242  37.575  32.214  1.00 18.09           O  
ATOM   2995  CB  ALA    87      12.869  36.042  32.512  1.00 16.45           C  
ATOM   2996  N   PRO    88      15.237  38.109  34.440  1.00 17.51           N  
ATOM   2997  CA  PRO    88      16.661  38.414  34.528  1.00 17.16           C  
ATOM   2998  C   PRO    88      17.415  37.085  34.289  1.00 17.69           C  
ATOM   2999  O   PRO    88      17.211  36.084  35.030  1.00 17.49           O  
ATOM   3000  CB  PRO    88      16.807  38.954  35.981  1.00 17.74           C  
ATOM   3001  CG  PRO    88      15.420  39.389  36.344  1.00 18.26           C  
ATOM   3002  CD  PRO    88      14.574  38.324  35.736  1.00 15.57           C  
ATOM   3003  N   THR    89      18.266  37.091  33.243  1.00 15.93           N  
ATOM   3004  CA  THR    89      18.892  35.902  32.729  1.00 17.28           C  
ATOM   3005  C   THR    89      20.414  35.982  32.833  1.00 15.25           C  
ATOM   3006  O   THR    89      21.028  36.886  32.236  1.00 15.41           O  
ATOM   3007  CB  THR    89      18.480  35.688  31.261  1.00 15.76           C  
ATOM   3008  OG1 THR    89      17.043  35.643  31.196  1.00 19.00           O  
ATOM   3009  CG2 THR    89      19.108  34.396  30.696  1.00 17.47           C  
ATOM   3010  N   PHE    90      20.977  35.043  33.590  1.00 16.51           N  
ATOM   3011  CA  PHE    90      22.400  35.042  33.963  1.00 17.12           C  
ATOM   3012  C   PHE    90      23.063  33.889  33.204  1.00 17.46           C  
ATOM   3013  O   PHE    90      22.840  32.732  33.525  1.00 16.64           O  
ATOM   3014  CB  PHE    90      22.509  34.875  35.509  1.00 17.08           C  
ATOM   3015  CG  PHE    90      21.893  36.026  36.254  1.00 18.21           C  
ATOM   3016  CD1 PHE    90      22.636  37.182  36.500  1.00 17.26           C  
ATOM   3017  CD2 PHE    90      20.528  35.976  36.677  1.00 18.36           C  
ATOM   3018  CE1 PHE    90      22.053  38.293  37.145  1.00 18.01           C  
ATOM   3019  CE2 PHE    90      19.943  37.054  37.355  1.00 18.89           C  
ATOM   3020  CZ  PHE    90      20.720  38.250  37.574  1.00 17.11           C  
ATOM   3021  N   SER    91      23.868  34.207  32.194  1.00 17.80           N  
ATOM   3022  CA  SER    91      24.464  33.170  31.345  1.00 17.82           C  
ATOM   3023  C   SER    91      25.546  32.347  32.071  1.00 18.15           C  
ATOM   3024  O   SER    91      26.158  32.810  33.043  1.00 17.04           O  
ATOM   3025  CB  SER    91      25.018  33.798  30.061  1.00 17.61           C  
ATOM   3026  OG  SER    91      26.202  34.490  30.345  1.00 19.18           O  
ATOM   3027  N   ASP    92      25.728  31.101  31.622  1.00 19.41           N  
ATOM   3028  CA  ASP    92      26.783  30.231  32.151  1.00 20.31           C  
ATOM   3029  C   ASP    92      28.165  30.860  31.913  1.00 20.25           C  
ATOM   3030  O   ASP    92      29.020  30.747  32.783  1.00 19.65           O  
ATOM   3031  CB  ASP    92      26.773  28.829  31.526  1.00 21.31           C  
ATOM   3032  CG  ASP    92      25.707  27.908  32.110  1.00 25.15           C  
ATOM   3033  OD1 ASP    92      25.067  27.192  31.315  1.00 26.08           O  
ATOM   3034  OD2 ASP    92      25.520  27.870  33.346  1.00 26.08           O  
ATOM   3035  N   GLU    93      28.350  31.496  30.746  0.50 20.42           N  
ATOM   3037  CA  GLU    93      29.631  32.140  30.353  0.50 21.63           C  
ATOM   3039  C   GLU    93      30.048  33.166  31.386  0.50 20.51           C  
ATOM   3041  O   GLU    93      31.190  33.173  31.849  0.50 21.13           O  
ATOM   3043  CB  GLU    93      29.563  32.848  28.959  0.50 21.80           C  
ATOM   3045  CG  GLU    93      28.136  33.271  28.480  0.50 23.50           C  
ATOM   3047  CD  GLU    93      27.956  34.619  27.714  0.50 24.07           C  
ATOM   3049  OE1 GLU    93      28.860  35.089  26.966  0.50 26.86           O  
ATOM   3051  OE2 GLU    93      26.836  35.173  27.843  0.50 20.92           O  
ATOM   3053  N   ILE    94      29.103  34.023  31.745  1.00 19.22           N  
ATOM   3054  CA  ILE    94      29.385  35.233  32.529  1.00 17.12           C  
ATOM   3055  C   ILE    94      29.193  35.042  34.045  1.00 16.82           C  
ATOM   3056  O   ILE    94      29.883  35.675  34.867  1.00 16.37           O  
ATOM   3057  CB  ILE    94      28.560  36.436  32.017  1.00 17.25           C  
ATOM   3058  CG1 ILE    94      28.802  36.707  30.507  1.00 17.34           C  
ATOM   3059  CG2 ILE    94      28.828  37.716  32.870  1.00 15.64           C  
ATOM   3060  CD1 ILE    94      30.240  37.148  30.190  1.00 24.76           C  
ATOM   3061  N   TRP    95      28.257  34.176  34.404  1.00 15.36           N  
ATOM   3062  CA  TRP    95      27.875  33.940  35.814  1.00 14.41           C  
ATOM   3063  C   TRP    95      28.015  32.396  36.035  1.00 14.61           C  
ATOM   3064  O   TRP    95      26.972  31.705  36.254  1.00 15.13           O  
ATOM   3065  CB  TRP    95      26.416  34.355  36.045  1.00 14.04           C  
ATOM   3066  CG  TRP    95      26.195  35.862  35.899  1.00 13.43           C  
ATOM   3067  CD1 TRP    95      25.962  36.534  34.744  1.00 16.12           C  
ATOM   3068  CD2 TRP    95      26.228  36.845  36.945  1.00 14.60           C  
ATOM   3069  NE1 TRP    95      25.829  37.880  35.000  1.00 15.94           N  
ATOM   3070  CE2 TRP    95      25.952  38.087  36.354  1.00 15.93           C  
ATOM   3071  CE3 TRP    95      26.372  36.770  38.346  1.00 16.06           C  
ATOM   3072  CZ2 TRP    95      25.886  39.278  37.110  1.00 16.30           C  
ATOM   3073  CZ3 TRP    95      26.324  37.921  39.105  1.00 17.23           C  
ATOM   3074  CH2 TRP    95      26.072  39.179  38.487  1.00 15.56           C  
ATOM   3075  N   PRO    96      29.264  31.856  35.962  1.00 14.15           N  
ATOM   3076  CA  PRO    96      29.406  30.390  35.995  1.00 15.25           C  
ATOM   3077  C   PRO    96      29.076  29.756  37.335  1.00 15.68           C  
ATOM   3078  O   PRO    96      29.438  30.281  38.406  1.00 14.18           O  
ATOM   3079  CB  PRO    96      30.901  30.166  35.673  1.00 16.21           C  
ATOM   3080  CG  PRO    96      31.578  31.376  36.144  1.00 14.84           C  
ATOM   3081  CD  PRO    96      30.594  32.498  35.803  1.00 15.69           C  
ATOM   3082  N   GLY    97      28.414  28.610  37.260  1.00 15.84           N  
ATOM   3083  CA  GLY    97      28.310  27.748  38.402  1.00 16.10           C  
ATOM   3084  C   GLY    97      27.195  28.149  39.359  1.00 15.71           C  
ATOM   3085  O   GLY    97      26.654  29.267  39.301  1.00 16.50           O  
ATOM   3086  N   VAL    98      26.945  27.281  40.317  1.00 14.86           N  
ATOM   3087  CA  VAL    98      25.956  27.574  41.368  1.00 16.93           C  
ATOM   3088  C   VAL    98      26.482  28.714  42.253  1.00 16.50           C  
ATOM   3089  O   VAL    98      25.715  29.396  42.920  1.00 16.48           O  
ATOM   3090  CB  VAL    98      25.594  26.322  42.244  1.00 17.03           C  
ATOM   3091  CG1 VAL    98      24.986  25.204  41.365  1.00 20.29           C  
ATOM   3092  CG2 VAL    98      26.799  25.801  43.079  1.00 18.18           C  
ATOM   3093  N   GLU    99      27.810  28.886  42.297  1.00 15.53           N  
ATOM   3094  CA  GLU    99      28.374  29.935  43.173  1.00 14.69           C  
ATOM   3095  C   GLU    99      27.948  31.324  42.682  1.00 15.90           C  
ATOM   3096  O   GLU    99      27.752  32.226  43.512  1.00 16.58           O  
ATOM   3097  CB  GLU    99      29.924  29.843  43.202  1.00 15.73           C  
ATOM   3098  CG  GLU    99      30.492  28.548  43.802  1.00 18.84           C  
ATOM   3099  CD  GLU    99      30.497  27.303  42.877  1.00 21.07           C  
ATOM   3100  OE1 GLU    99      30.107  27.342  41.684  1.00 19.08           O  
ATOM   3101  OE2 GLU    99      30.967  26.252  43.376  1.00 20.58           O  
ATOM   3102  N   SER   100      27.791  31.516  41.363  1.00 14.92           N  
ATOM   3103  CA  SER   100      27.411  32.870  40.834  1.00 15.17           C  
ATOM   3104  C   SER   100      25.910  33.161  40.753  1.00 14.98           C  
ATOM   3105  O   SER   100      25.511  34.337  40.763  1.00 15.85           O  
ATOM   3106  CB  SER   100      27.997  33.119  39.409  1.00 15.94           C  
ATOM   3107  OG  SER   100      29.405  32.824  39.344  1.00 19.19           O  
ATOM   3108  N   TYR   101      25.125  32.116  40.511  1.00 13.91           N  
ATOM   3109  CA  TYR   101      23.700  32.273  40.321  1.00 13.87           C  
ATOM   3110  C   TYR   101      22.958  31.798  41.588  1.00 14.64           C  
ATOM   3111  O   TYR   101      22.568  32.631  42.386  1.00 15.53           O  
ATOM   3112  CB  TYR   101      23.247  31.513  39.060  1.00 12.54           C  
ATOM   3113  CG  TYR   101      21.746  31.628  38.843  1.00 17.07           C  
ATOM   3114  CD1 TYR   101      21.153  32.876  38.734  1.00 14.11           C  
ATOM   3115  CD2 TYR   101      20.928  30.480  38.722  1.00 14.06           C  
ATOM   3116  CE1 TYR   101      19.747  33.028  38.556  1.00 15.34           C  
ATOM   3117  CE2 TYR   101      19.486  30.618  38.533  1.00 14.28           C  
ATOM   3118  CZ  TYR   101      18.930  31.915  38.478  1.00 15.46           C  
ATOM   3119  OH  TYR   101      17.561  32.105  38.261  1.00 15.43           O  
ATOM   3120  N   ASN   102      22.800  30.469  41.787  1.00 13.49           N  
ATOM   3121  CA  ASN   102      22.074  29.967  42.974  1.00 14.29           C  
ATOM   3122  C   ASN   102      22.509  30.622  44.298  1.00 15.56           C  
ATOM   3123  O   ASN   102      21.645  30.941  45.147  1.00 15.74           O  
ATOM   3124  CB  ASN   102      22.247  28.427  43.152  1.00 15.50           C  
ATOM   3125  CG  ASN   102      22.142  27.625  41.849  1.00 15.88           C  
ATOM   3126  OD1 ASN   102      22.439  28.107  40.756  1.00 16.30           O  
ATOM   3127  ND2 ASN   102      21.735  26.350  41.975  1.00 16.16           N  
ATOM   3128  N   ASN   103      23.830  30.727  44.500  1.00 14.96           N  
ATOM   3129  CA  ASN   103      24.446  31.161  45.761  1.00 14.94           C  
ATOM   3130  C   ASN   103      24.728  32.671  45.822  1.00 13.78           C  
ATOM   3131  O   ASN   103      25.314  33.167  46.813  1.00 14.48           O  
ATOM   3132  CB  ASN   103      25.760  30.427  46.005  1.00 14.71           C  
ATOM   3133  CG  ASN   103      25.578  28.880  46.138  1.00 15.38           C  
ATOM   3134  OD1 ASN   103      26.553  28.140  46.393  1.00 21.81           O  
ATOM   3135  ND2 ASN   103      24.363  28.399  45.932  1.00 13.77           N  
ATOM   3136  N   GLY   104      24.352  33.380  44.767  1.00 13.19           N  
ATOM   3137  CA  GLY   104      24.408  34.846  44.803  1.00 14.63           C  
ATOM   3138  C   GLY   104      25.764  35.525  44.942  1.00 14.64           C  
ATOM   3139  O   GLY   104      25.798  36.747  45.221  1.00 14.53           O  
ATOM   3140  N   ARG   105      26.860  34.829  44.625  1.00 16.64           N  
ATOM   3141  CA  ARG   105      28.227  35.393  44.840  1.00 18.86           C  
ATOM   3142  C   ARG   105      28.393  36.031  46.228  1.00 19.24           C  
ATOM   3143  O   ARG   105      28.917  37.164  46.360  1.00 19.63           O  
ATOM   3144  CB  ARG   105      28.588  36.444  43.788  1.00 19.26           C  
ATOM   3145  CG  ARG   105      28.608  35.925  42.361  1.00 22.06           C  
ATOM   3146  CD  ARG   105      28.951  37.059  41.327  1.00 21.62           C  
ATOM   3147  NE  ARG   105      30.351  37.453  41.481  1.00 24.57           N  
ATOM   3148  CZ  ARG   105      30.730  38.639  41.964  1.00 26.02           C  
ATOM   3149  NH1 ARG   105      29.816  39.528  42.307  1.00 27.24           N  
ATOM   3150  NH2 ARG   105      32.023  38.935  42.127  1.00 24.31           N  
ATOM   3151  N   ALA   106      27.873  35.322  47.223  1.00 20.55           N  
ATOM   3152  CA  ALA   106      27.850  35.740  48.639  1.00 20.55           C  
ATOM   3153  C   ALA   106      29.269  35.969  49.233  1.00 21.56           C  
ATOM   3154  O   ALA   106      29.442  36.786  50.153  1.00 21.17           O  
ATOM   3155  CB  ALA   106      27.124  34.694  49.468  1.00 21.04           C  
ATOM   3156  N   PHE   107      30.244  35.225  48.736  1.00 21.89           N  
ATOM   3157  CA  PHE   107      31.629  35.358  49.228  1.00 22.03           C  
ATOM   3158  C   PHE   107      32.574  36.023  48.250  1.00 23.24           C  
ATOM   3159  O   PHE   107      32.455  35.862  47.023  1.00 23.71           O  
ATOM   3160  CB  PHE   107      32.179  33.986  49.523  1.00 21.25           C  
ATOM   3161  CG  PHE   107      31.398  33.236  50.538  1.00 21.90           C  
ATOM   3162  CD1 PHE   107      30.494  32.254  50.138  1.00 23.38           C  
ATOM   3163  CD2 PHE   107      31.566  33.495  51.896  1.00 22.66           C  
ATOM   3164  CE1 PHE   107      29.782  31.527  51.076  1.00 24.04           C  
ATOM   3165  CE2 PHE   107      30.842  32.764  52.861  1.00 25.76           C  
ATOM   3166  CZ  PHE   107      29.950  31.782  52.449  1.00 25.39           C  
ATOM   3167  N   THR   108      33.573  36.707  48.799  1.00 22.98           N  
ATOM   3168  CA  THR   108      34.714  37.144  48.020  1.00 23.14           C  
ATOM   3169  C   THR   108      35.603  35.954  47.760  1.00 23.27           C  
ATOM   3170  O   THR   108      35.458  34.913  48.389  1.00 21.29           O  
ATOM   3171  CB  THR   108      35.595  38.151  48.792  1.00 23.92           C  
ATOM   3172  OG1 THR   108      36.249  37.471  49.889  1.00 21.70           O  
ATOM   3173  CG2 THR   108      34.782  39.357  49.229  1.00 24.65           C  
ATOM   3174  N   ALA   109      36.572  36.141  46.868  1.00 24.08           N  
ATOM   3175  CA  ALA   109      37.518  35.101  46.542  1.00 24.49           C  
ATOM   3176  C   ALA   109      38.215  34.572  47.785  1.00 24.43           C  
ATOM   3177  O   ALA   109      38.450  33.359  47.907  1.00 23.88           O  
ATOM   3178  CB  ALA   109      38.542  35.623  45.559  1.00 25.04           C  
ATOM   3179  N   ALA   110      38.583  35.474  48.705  1.00 23.47           N  
ATOM   3180  CA  ALA   110      39.286  35.048  49.903  1.00 22.72           C  
ATOM   3181  C   ALA   110      38.332  34.394  50.926  1.00 23.20           C  
ATOM   3182  O   ALA   110      38.777  33.922  51.997  1.00 23.39           O  
ATOM   3183  CB  ALA   110      40.010  36.209  50.508  1.00 22.29           C  
ATOM   3184  N   GLY   111      37.043  34.346  50.582  1.00 22.19           N  
ATOM   3185  CA  GLY   111      36.073  33.620  51.414  1.00 22.54           C  
ATOM   3186  C   GLY   111      35.486  34.491  52.507  1.00 21.64           C  
ATOM   3187  O   GLY   111      34.897  33.978  53.458  1.00 21.96           O  
ATOM   3188  N   ASN   112      35.635  35.815  52.370  1.00 21.40           N  
ATOM   3189  CA  ASN   112      34.979  36.745  53.293  1.00 21.75           C  
ATOM   3190  C   ASN   112      33.598  37.151  52.770  1.00 22.47           C  
ATOM   3191  O   ASN   112      33.321  36.996  51.584  1.00 21.61           O  
ATOM   3192  CB  ASN   112      35.830  37.967  53.509  1.00 22.45           C  
ATOM   3193  CG  ASN   112      37.177  37.621  54.070  1.00 22.77           C  
ATOM   3194  OD1 ASN   112      38.217  38.004  53.515  1.00 25.02           O  
ATOM   3195  ND2 ASN   112      37.171  36.817  55.127  1.00 22.68           N  
ATOM   3196  N   PRO   113      32.729  37.671  53.656  1.00 22.53           N  
ATOM   3197  CA  PRO   113      31.400  38.006  53.141  1.00 22.51           C  
ATOM   3198  C   PRO   113      31.450  39.232  52.238  1.00 22.47           C  
ATOM   3199  O   PRO   113      32.031  40.256  52.625  1.00 20.99           O  
ATOM   3200  CB  PRO   113      30.585  38.366  54.411  1.00 22.53           C  
ATOM   3201  CG  PRO   113      31.419  37.910  55.592  1.00 22.48           C  
ATOM   3202  CD  PRO   113      32.859  37.913  55.112  1.00 23.34           C  
ATOM   3203  N   ARG   114      30.810  39.144  51.076  1.00 22.28           N  
ATOM   3204  CA  ARG   114      30.537  40.333  50.256  1.00 23.60           C  
ATOM   3205  C   ARG   114      29.365  41.137  50.860  1.00 22.17           C  
ATOM   3206  O   ARG   114      28.454  40.551  51.436  1.00 21.59           O  
ATOM   3207  CB  ARG   114      30.184  39.848  48.847  1.00 23.07           C  
ATOM   3208  CG  ARG   114      30.000  40.951  47.821  1.00 26.04           C  
ATOM   3209  CD  ARG   114      29.755  40.357  46.426  1.00 26.96           C  
ATOM   3210  NE  ARG   114      30.722  39.295  46.173  1.00 32.68           N  
ATOM   3211  CZ  ARG   114      31.893  39.488  45.613  1.00 32.43           C  
ATOM   3212  NH1 ARG   114      32.221  40.711  45.249  1.00 34.31           N  
ATOM   3213  NH2 ARG   114      32.716  38.462  45.410  1.00 34.40           N  
ATOM   3214  N   HIS   115      29.367  42.473  50.704  1.00 20.97           N  
ATOM   3215  CA  HIS   115      28.225  43.307  51.146  1.00 21.49           C  
ATOM   3216  C   HIS   115      26.949  42.802  50.438  1.00 21.07           C  
ATOM   3217  O   HIS   115      26.995  42.425  49.248  1.00 20.15           O  
ATOM   3218  CB  HIS   115      28.466  44.767  50.744  1.00 22.19           C  
ATOM   3219  CG  HIS   115      27.493  45.741  51.333  1.00 27.46           C  
ATOM   3220  ND1 HIS   115      26.161  45.779  50.980  1.00 29.94           N  
ATOM   3221  CD2 HIS   115      27.673  46.745  52.230  1.00 30.61           C  
ATOM   3222  CE1 HIS   115      25.552  46.734  51.663  1.00 34.27           C  
ATOM   3223  NE2 HIS   115      26.449  47.342  52.420  1.00 30.95           N  
ATOM   3224  N   VAL   116      25.818  42.787  51.133  1.00 20.66           N  
ATOM   3225  CA  VAL   116      24.613  42.116  50.544  1.00 19.77           C  
ATOM   3226  C   VAL   116      24.155  42.840  49.298  1.00 20.72           C  
ATOM   3227  O   VAL   116      23.566  42.220  48.436  1.00 19.35           O  
ATOM   3228  CB  VAL   116      23.395  41.984  51.561  1.00 20.93           C  
ATOM   3229  CG1 VAL   116      23.712  40.909  52.609  1.00 21.25           C  
ATOM   3230  CG2 VAL   116      23.058  43.322  52.196  1.00 21.82           C  
ATOM   3231  N   ASP   117      24.415  44.149  49.215  1.00 21.37           N  
ATOM   3232  CA  ASP   117      24.115  44.946  48.004  1.00 23.55           C  
ATOM   3233  C   ASP   117      24.825  44.443  46.773  1.00 21.81           C  
ATOM   3234  O   ASP   117      24.432  44.801  45.668  1.00 22.51           O  
ATOM   3235  CB  ASP   117      24.538  46.428  48.182  1.00 25.55           C  
ATOM   3236  CG  ASP   117      23.679  47.153  49.174  1.00 29.35           C  
ATOM   3237  OD1 ASP   117      22.776  46.470  49.719  1.00 32.93           O  
ATOM   3238  OD2 ASP   117      23.907  48.396  49.411  1.00 35.58           O  
ATOM   3239  N   GLY   118      25.907  43.679  46.967  1.00 20.71           N  
ATOM   3240  CA  GLY   118      26.735  43.195  45.850  1.00 19.35           C  
ATOM   3241  C   GLY   118      26.400  41.754  45.429  1.00 18.88           C  
ATOM   3242  O   GLY   118      26.949  41.227  44.454  1.00 17.51           O  
ATOM   3243  N   TRP   119      25.515  41.109  46.175  1.00 17.33           N  
ATOM   3244  CA  TRP   119      25.117  39.725  45.825  1.00 15.84           C  
ATOM   3245  C   TRP   119      24.251  39.749  44.562  1.00 14.95           C  
ATOM   3246  O   TRP   119      23.615  40.759  44.237  1.00 14.33           O  
ATOM   3247  CB  TRP   119      24.348  39.064  46.955  1.00 17.02           C  
ATOM   3248  CG  TRP   119      25.095  38.893  48.230  1.00 18.06           C  
ATOM   3249  CD1 TRP   119      26.265  39.538  48.634  1.00 17.49           C  
ATOM   3250  CD2 TRP   119      24.690  38.060  49.317  1.00 16.19           C  
ATOM   3251  NE1 TRP   119      26.604  39.115  49.925  1.00 17.79           N  
ATOM   3252  CE2 TRP   119      25.650  38.226  50.361  1.00 16.49           C  
ATOM   3253  CE3 TRP   119      23.576  37.206  49.526  1.00 18.10           C  
ATOM   3254  CZ2 TRP   119      25.542  37.563  51.592  1.00 17.89           C  
ATOM   3255  CZ3 TRP   119      23.489  36.476  50.752  1.00 19.12           C  
ATOM   3256  CH2 TRP   119      24.462  36.677  51.761  1.00 19.54           C  
ATOM   3257  N   THR   120      24.269  38.645  43.807  1.00 14.50           N  
ATOM   3258  CA  THR   120      23.505  38.546  42.573  1.00 14.91           C  
ATOM   3259  C   THR   120      22.021  38.879  42.812  1.00 15.62           C  
ATOM   3260  O   THR   120      21.373  39.513  41.970  1.00 15.42           O  
ATOM   3261  CB  THR   120      23.623  37.121  42.001  1.00 16.56           C  
ATOM   3262  OG1 THR   120      24.996  36.754  42.077  1.00 16.46           O  
ATOM   3263  CG2 THR   120      23.168  37.082  40.522  1.00 14.63           C  
ATOM   3264  N   TYR   121      21.501  38.512  43.987  1.00 15.82           N  
ATOM   3265  CA  TYR   121      20.082  38.658  44.296  1.00 14.26           C  
ATOM   3266  C   TYR   121      19.667  40.151  44.346  1.00 14.38           C  
ATOM   3267  O   TYR   121      18.489  40.437  44.067  1.00 15.09           O  
ATOM   3268  CB  TYR   121      19.722  38.037  45.656  1.00 13.59           C  
ATOM   3269  CG  TYR   121      20.320  36.661  45.935  1.00 12.69           C  
ATOM   3270  CD1 TYR   121      20.885  36.375  47.187  1.00 13.59           C  
ATOM   3271  CD2 TYR   121      20.247  35.658  44.967  1.00 12.82           C  
ATOM   3272  CE1 TYR   121      21.421  35.126  47.482  1.00 13.68           C  
ATOM   3273  CE2 TYR   121      20.776  34.353  45.239  1.00 12.58           C  
ATOM   3274  CZ  TYR   121      21.361  34.123  46.514  1.00 13.55           C  
ATOM   3275  OH  TYR   121      21.834  32.848  46.768  1.00 13.20           O  
ATOM   3276  N   ALA   122      20.624  41.035  44.657  1.00 14.91           N  
ATOM   3277  CA  ALA   122      20.367  42.490  44.813  1.00 16.52           C  
ATOM   3278  C   ALA   122      20.024  43.112  43.451  1.00 16.98           C  
ATOM   3279  O   ALA   122      19.445  44.209  43.385  1.00 16.99           O  
ATOM   3280  CB  ALA   122      21.578  43.212  45.466  1.00 16.92           C  
ATOM   3281  N   LEU   123      20.352  42.405  42.357  1.00 15.28           N  
ATOM   3282  CA  LEU   123      20.128  42.935  41.015  1.00 16.15           C  
ATOM   3283  C   LEU   123      18.618  42.989  40.748  1.00 15.93           C  
ATOM   3284  O   LEU   123      18.171  43.792  39.953  1.00 15.39           O  
ATOM   3285  CB  LEU   123      20.820  42.059  39.947  1.00 16.20           C  
ATOM   3286  CG  LEU   123      22.353  42.274  39.948  1.00 16.03           C  
ATOM   3287  CD1 LEU   123      23.155  41.199  39.148  1.00 17.74           C  
ATOM   3288  CD2 LEU   123      22.721  43.720  39.525  1.00 18.30           C  
ATOM   3289  N   VAL   124      17.848  42.115  41.388  1.00 14.43           N  
ATOM   3290  CA  VAL   124      16.357  42.121  41.121  1.00 15.18           C  
ATOM   3291  C   VAL   124      15.799  43.535  41.441  1.00 15.97           C  
ATOM   3292  O   VAL   124      15.134  44.180  40.599  1.00 15.45           O  
ATOM   3293  CB  VAL   124      15.584  41.008  41.828  1.00 14.94           C  
ATOM   3294  CG1 VAL   124      14.011  41.134  41.533  1.00 15.00           C  
ATOM   3295  CG2 VAL   124      16.098  39.612  41.312  1.00 14.27           C  
ATOM   3296  N   ALA   125      16.012  43.984  42.676  1.00 16.29           N  
ATOM   3297  CA  ALA   125      15.594  45.342  43.058  1.00 16.79           C  
ATOM   3298  C   ALA   125      16.183  46.458  42.155  1.00 16.65           C  
ATOM   3299  O   ALA   125      15.527  47.511  41.953  1.00 15.61           O  
ATOM   3300  CB  ALA   125      15.923  45.599  44.515  1.00 17.80           C  
ATOM   3301  N   ARG   126      17.421  46.293  41.655  1.00 16.69           N  
ATOM   3302  CA  ARG   126      18.015  47.368  40.796  1.00 17.77           C  
ATOM   3303  C   ARG   126      17.270  47.400  39.481  1.00 16.21           C  
ATOM   3304  O   ARG   126      16.964  48.473  38.973  1.00 17.60           O  
ATOM   3305  CB  ARG   126      19.509  47.170  40.496  1.00 18.29           C  
ATOM   3306  CG  ARG   126      20.343  47.035  41.730  1.00 24.42           C  
ATOM   3307  CD  ARG   126      20.573  48.304  42.415  1.00 35.85           C  
ATOM   3308  NE  ARG   126      22.005  48.645  42.419  1.00 47.26           N  
ATOM   3309  CZ  ARG   126      22.942  48.159  43.258  1.00 50.01           C  
ATOM   3310  NH1 ARG   126      24.197  48.610  43.116  1.00 48.43           N  
ATOM   3311  NH2 ARG   126      22.652  47.233  44.222  1.00 47.98           N  
ATOM   3312  N   VAL   127      16.953  46.214  38.956  1.00 16.49           N  
ATOM   3313  CA  VAL   127      16.157  46.136  37.745  1.00 16.08           C  
ATOM   3314  C   VAL   127      14.787  46.805  37.953  1.00 15.61           C  
ATOM   3315  O   VAL   127      14.335  47.571  37.058  1.00 15.42           O  
ATOM   3316  CB  VAL   127      15.983  44.705  37.221  1.00 17.45           C  
ATOM   3317  CG1 VAL   127      14.948  44.657  36.112  1.00 17.50           C  
ATOM   3318  CG2 VAL   127      17.357  44.171  36.721  1.00 17.03           C  
ATOM   3319  N   LEU   128      14.130  46.497  39.100  1.00 13.43           N  
ATOM   3320  CA  LEU   128      12.786  47.055  39.336  1.00 14.67           C  
ATOM   3321  C   LEU   128      12.889  48.572  39.469  1.00 13.67           C  
ATOM   3322  O   LEU   128      12.044  49.277  38.945  1.00 15.03           O  
ATOM   3323  CB  LEU   128      12.160  46.459  40.569  1.00 14.50           C  
ATOM   3324  CG  LEU   128      11.822  44.955  40.376  1.00 14.59           C  
ATOM   3325  CD1 LEU   128      11.615  44.295  41.805  1.00 17.93           C  
ATOM   3326  CD2 LEU   128      10.593  44.748  39.377  1.00 13.65           C  
ATOM   3327  N   ALA   129      13.961  49.056  40.108  1.00 13.80           N  
ATOM   3328  CA  ALA   129      14.167  50.533  40.251  1.00 13.68           C  
ATOM   3329  C   ALA   129      14.270  51.192  38.867  1.00 15.54           C  
ATOM   3330  O   ALA   129      13.745  52.325  38.630  1.00 15.06           O  
ATOM   3331  CB  ALA   129      15.395  50.778  41.085  1.00 13.97           C  
ATOM   3332  N   ASN   130      14.919  50.496  37.927  1.00 14.74           N  
ATOM   3333  CA  ASN   130      15.059  51.004  36.555  1.00 15.32           C  
ATOM   3334  C   ASN   130      13.758  50.936  35.718  1.00 14.97           C  
ATOM   3335  O   ASN   130      13.480  51.810  34.890  1.00 15.38           O  
ATOM   3336  CB  ASN   130      16.263  50.373  35.848  1.00 15.40           C  
ATOM   3337  CG  ASN   130      17.551  51.071  36.204  1.00 18.61           C  
ATOM   3338  OD1 ASN   130      17.608  52.310  36.199  1.00 20.20           O  
ATOM   3339  ND2 ASN   130      18.580  50.300  36.561  1.00 21.85           N  
ATOM   3340  N   ILE   131      12.975  49.892  35.917  1.00 15.61           N  
ATOM   3341  CA  ILE   131      11.622  49.829  35.359  1.00 15.91           C  
ATOM   3342  C   ILE   131      10.792  51.011  35.873  1.00 16.87           C  
ATOM   3343  O   ILE   131      10.103  51.656  35.061  1.00 18.10           O  
ATOM   3344  CB  ILE   131      10.963  48.434  35.605  1.00 14.80           C  
ATOM   3345  CG1 ILE   131      11.753  47.368  34.836  1.00 18.55           C  
ATOM   3346  CG2 ILE   131       9.424  48.438  35.183  1.00 14.48           C  
ATOM   3347  CD1 ILE   131      11.352  45.939  35.175  1.00 16.52           C  
ATOM   3348  N   ARG   132      10.852  51.309  37.172  0.50 16.49           N  
ATOM   3350  CA  ARG   132      10.131  52.472  37.702  0.50 17.52           C  
ATOM   3352  C   ARG   132      10.680  53.755  37.094  0.50 16.42           C  
ATOM   3354  O   ARG   132       9.908  54.636  36.696  0.50 16.67           O  
ATOM   3356  CB  ARG   132      10.265  52.605  39.228  0.50 17.40           C  
ATOM   3358  CG  ARG   132       9.896  51.379  40.046  0.50 18.47           C  
ATOM   3360  CD  ARG   132       9.814  51.726  41.531  0.50 17.99           C  
ATOM   3362  NE  ARG   132       9.444  53.143  41.724  0.50 21.23           N  
ATOM   3364  CZ  ARG   132      10.117  54.010  42.491  0.50 20.61           C  
ATOM   3366  NH1 ARG   132      11.182  53.621  43.202  0.50 20.08           N  
ATOM   3368  NH2 ARG   132       9.693  55.262  42.569  0.50 20.27           N  
ATOM   3370  N   ALA   133      12.011  53.860  37.007  1.00 16.64           N  
ATOM   3371  CA  ALA   133      12.658  55.064  36.446  1.00 16.24           C  
ATOM   3372  C   ALA   133      12.226  55.266  34.996  1.00 16.83           C  
ATOM   3373  O   ALA   133      12.010  56.399  34.578  1.00 17.43           O  
ATOM   3374  CB  ALA   133      14.174  54.968  36.514  1.00 16.88           C  
ATOM   3375  N   ALA   134      12.096  54.163  34.248  1.00 17.37           N  
ATOM   3376  CA  ALA   134      11.699  54.249  32.854  1.00 17.87           C  
ATOM   3377  C   ALA   134      10.214  54.598  32.693  1.00 18.58           C  
ATOM   3378  O   ALA   134       9.770  54.780  31.578  1.00 17.52           O  
ATOM   3379  CB  ALA   134      12.067  53.017  32.111  1.00 17.31           C  
ATOM   3380  N   GLU   135       9.485  54.662  33.813  1.00 19.46           N  
ATOM   3381  CA  GLU   135       8.032  54.903  33.862  1.00 21.46           C  
ATOM   3382  C   GLU   135       7.253  53.813  33.099  1.00 20.50           C  
ATOM   3383  O   GLU   135       6.162  54.041  32.596  1.00 20.41           O  
ATOM   3384  CB  GLU   135       7.693  56.346  33.433  1.00 22.35           C  
ATOM   3385  CG  GLU   135       8.142  57.372  34.569  1.00 24.15           C  
ATOM   3386  CD  GLU   135       8.115  58.852  34.194  1.00 28.93           C  
ATOM   3387  OE1 GLU   135       7.683  59.195  33.061  1.00 39.13           O  
ATOM   3388  OE2 GLU   135       8.574  59.695  35.033  1.00 31.46           O  
ATOM   3389  N   ILE   136       7.832  52.612  33.036  1.00 18.80           N  
ATOM   3390  CA  ILE   136       7.174  51.492  32.389  1.00 18.23           C  
ATOM   3391  C   ILE   136       6.106  50.917  33.320  1.00 18.49           C  
ATOM   3392  O   ILE   136       5.020  50.560  32.871  1.00 18.92           O  
ATOM   3393  CB  ILE   136       8.226  50.443  31.915  1.00 17.49           C  
ATOM   3394  CG1 ILE   136       9.011  50.987  30.689  1.00 15.83           C  
ATOM   3395  CG2 ILE   136       7.577  49.050  31.571  1.00 19.96           C  
ATOM   3396  CD1 ILE   136       8.208  51.095  29.416  1.00 17.61           C  
ATOM   3397  N   ALA   137       6.423  50.810  34.605  1.00 17.99           N  
ATOM   3398  CA  ALA   137       5.553  50.230  35.642  1.00 19.50           C  
ATOM   3399  C   ALA   137       5.806  50.930  36.962  1.00 20.56           C  
ATOM   3400  O   ALA   137       6.985  51.192  37.298  1.00 20.14           O  
ATOM   3401  CB  ALA   137       5.817  48.700  35.843  1.00 18.59           C  
ATOM   3402  N   ASP   138       4.727  51.132  37.732  1.00 20.81           N  
ATOM   3403  CA  ASP   138       4.811  51.717  39.080  1.00 23.90           C  
ATOM   3404  C   ASP   138       5.560  50.730  40.010  1.00 23.03           C  
ATOM   3405  O   ASP   138       6.113  51.162  40.996  1.00 23.52           O  
ATOM   3406  CB  ASP   138       3.423  51.903  39.712  1.00 24.95           C  
ATOM   3407  CG  ASP   138       2.507  52.802  38.924  1.00 34.21           C  
ATOM   3408  OD1 ASP   138       2.980  53.712  38.145  1.00 38.94           O  
ATOM   3409  OD2 ASP   138       1.263  52.601  39.104  1.00 39.31           O  
ATOM   3410  N   CYS   139       5.528  49.422  39.726  1.00 22.78           N  
ATOM   3411  CA  CYS   139       6.188  48.409  40.567  1.00 22.98           C  
ATOM   3412  C   CYS   139       5.686  48.424  42.017  1.00 23.88           C  
ATOM   3413  O   CYS   139       6.452  48.157  42.945  1.00 23.55           O  
ATOM   3414  CB  CYS   139       7.740  48.529  40.526  1.00 22.89           C  
ATOM   3415  SG  CYS   139       8.406  48.167  38.896  1.00 24.01           S  
ATOM   3416  N   GLU   140       4.395  48.727  42.182  1.00 24.51           N  
ATOM   3417  CA  GLU   140       3.720  48.691  43.469  1.00 26.15           C  
ATOM   3418  C   GLU   140       3.262  47.256  43.773  1.00 25.78           C  
ATOM   3419  O   GLU   140       3.139  46.882  44.928  1.00 26.69           O  
ATOM   3420  CB  GLU   140       2.517  49.627  43.429  1.00 28.80           C  
ATOM   3421  CG  GLU   140       2.070  50.139  44.771  1.00 36.78           C  
ATOM   3422  CD  GLU   140       0.536  50.186  44.886  1.00 46.89           C  
ATOM   3423  OE1 GLU   140      -0.047  51.292  44.708  1.00 49.53           O  
ATOM   3424  OE2 GLU   140      -0.083  49.105  45.134  1.00 50.10           O  
ATOM   3425  N   GLN   141       3.063  46.461  42.736  1.00 23.57           N  
ATOM   3426  CA  GLN   141       2.543  45.114  42.840  1.00 24.33           C  
ATOM   3427  C   GLN   141       3.487  44.155  42.097  1.00 21.49           C  
ATOM   3428  O   GLN   141       3.223  43.781  40.960  1.00 21.70           O  
ATOM   3429  CB  GLN   141       1.138  45.092  42.237  1.00 24.61           C  
ATOM   3430  CG  GLN   141       0.421  43.813  42.527  1.00 35.09           C  
ATOM   3431  CD  GLN   141      -1.110  43.905  42.398  1.00 40.99           C  
ATOM   3432  OE1 GLN   141      -1.686  44.908  41.920  1.00 41.19           O  
ATOM   3433  NE2 GLN   141      -1.770  42.834  42.819  1.00 41.25           N  
ATOM   3434  N   VAL   142       4.586  43.778  42.741  1.00 19.67           N  
ATOM   3435  CA  VAL   142       5.603  42.962  42.075  1.00 17.96           C  
ATOM   3436  C   VAL   142       5.555  41.548  42.663  1.00 16.97           C  
ATOM   3437  O   VAL   142       5.584  41.345  43.892  1.00 15.75           O  
ATOM   3438  CB  VAL   142       7.019  43.530  42.214  1.00 18.71           C  
ATOM   3439  CG1 VAL   142       8.076  42.577  41.634  1.00 17.14           C  
ATOM   3440  CG2 VAL   142       7.103  44.987  41.598  1.00 18.15           C  
ATOM   3441  N   TYR   143       5.518  40.592  41.753  1.00 15.10           N  
ATOM   3442  CA  TYR   143       5.519  39.150  42.086  1.00 15.32           C  
ATOM   3443  C   TYR   143       6.862  38.523  41.701  1.00 16.46           C  
ATOM   3444  O   TYR   143       7.365  38.793  40.620  1.00 17.70           O  
ATOM   3445  CB  TYR   143       4.436  38.450  41.266  1.00 14.65           C  
ATOM   3446  CG  TYR   143       3.037  38.899  41.642  1.00 16.40           C  
ATOM   3447  CD1 TYR   143       2.570  40.174  41.274  1.00 15.26           C  
ATOM   3448  CD2 TYR   143       2.199  38.058  42.385  1.00 17.84           C  
ATOM   3449  CE1 TYR   143       1.244  40.588  41.640  1.00 15.27           C  
ATOM   3450  CE2 TYR   143       0.907  38.443  42.759  1.00 16.90           C  
ATOM   3451  CZ  TYR   143       0.451  39.728  42.387  1.00 18.96           C  
ATOM   3452  OH  TYR   143      -0.819  40.130  42.744  1.00 19.19           O  
ATOM   3453  N   LEU   144       7.405  37.653  42.563  1.00 15.90           N  
ATOM   3454  CA  LEU   144       8.729  37.056  42.307  1.00 14.04           C  
ATOM   3455  C   LEU   144       8.573  35.541  42.298  1.00 13.79           C  
ATOM   3456  O   LEU   144       8.088  34.964  43.292  1.00 15.27           O  
ATOM   3457  CB  LEU   144       9.724  37.514  43.406  1.00 14.12           C  
ATOM   3458  CG  LEU   144      11.153  36.912  43.409  1.00 15.68           C  
ATOM   3459  CD1 LEU   144      11.877  37.202  42.038  1.00 18.38           C  
ATOM   3460  CD2 LEU   144      12.015  37.457  44.543  1.00 15.78           C  
ATOM   3461  N   PHE   145       8.934  34.919  41.176  1.00 12.57           N  
ATOM   3462  CA  PHE   145       8.826  33.459  41.031  1.00 13.11           C  
ATOM   3463  C   PHE   145      10.166  32.901  40.593  1.00 13.94           C  
ATOM   3464  O   PHE   145      10.838  33.482  39.729  1.00 14.12           O  
ATOM   3465  CB  PHE   145       7.783  33.157  39.951  1.00 12.58           C  
ATOM   3466  CG  PHE   145       7.809  31.687  39.481  1.00 12.96           C  
ATOM   3467  CD1 PHE   145       7.070  30.750  40.141  1.00 17.33           C  
ATOM   3468  CD2 PHE   145       8.568  31.324  38.344  1.00 16.89           C  
ATOM   3469  CE1 PHE   145       7.071  29.338  39.656  1.00 17.18           C  
ATOM   3470  CE2 PHE   145       8.593  29.963  37.893  1.00 15.82           C  
ATOM   3471  CZ  PHE   145       7.849  29.018  38.550  1.00 14.60           C  
ATOM   3472  N   GLY   146      10.530  31.712  41.069  1.00 14.57           N  
ATOM   3473  CA  GLY   146      11.742  31.082  40.547  1.00 14.68           C  
ATOM   3474  C   GLY   146      11.493  29.573  40.602  1.00 15.34           C  
ATOM   3475  O   GLY   146      10.778  29.120  41.520  1.00 15.22           O  
ATOM   3476  N   HIS   147      12.006  28.832  39.624  1.00 14.39           N  
ATOM   3477  CA  HIS   147      11.894  27.345  39.651  1.00 15.83           C  
ATOM   3478  C   HIS   147      13.295  26.746  39.683  1.00 17.10           C  
ATOM   3479  O   HIS   147      14.206  27.200  38.946  1.00 15.08           O  
ATOM   3480  CB  HIS   147      11.134  26.830  38.427  1.00 16.33           C  
ATOM   3481  CG  HIS   147      10.976  25.324  38.381  1.00 15.93           C  
ATOM   3482  ND1 HIS   147      11.711  24.523  37.530  1.00 16.40           N  
ATOM   3483  CD2 HIS   147      10.147  24.488  39.065  1.00 18.06           C  
ATOM   3484  CE1 HIS   147      11.349  23.253  37.690  1.00 16.83           C  
ATOM   3485  NE2 HIS   147      10.399  23.201  38.616  1.00 17.18           N  
ATOM   3486  N   SER   148      13.443  25.689  40.495  1.00 17.14           N  
ATOM   3487  CA  SER   148      14.669  24.923  40.566  1.00 19.16           C  
ATOM   3488  C   SER   148      15.842  25.803  41.011  1.00 18.36           C  
ATOM   3489  O   SER   148      15.733  26.381  42.089  1.00 18.07           O  
ATOM   3490  CB  SER   148      14.907  24.135  39.269  1.00 21.44           C  
ATOM   3491  OG  SER   148      15.589  22.934  39.592  1.00 26.69           O  
ATOM   3492  N   ALA   149      16.936  25.942  40.249  1.00 15.92           N  
ATOM   3493  CA  ALA   149      18.018  26.851  40.712  1.00 15.11           C  
ATOM   3494  C   ALA   149      17.477  28.282  40.929  1.00 15.26           C  
ATOM   3495  O   ALA   149      17.962  28.992  41.813  1.00 16.03           O  
ATOM   3496  CB  ALA   149      19.250  26.861  39.738  1.00 13.69           C  
ATOM   3497  N   GLY   150      16.428  28.686  40.184  1.00 14.97           N  
ATOM   3498  CA  GLY   150      15.810  30.007  40.391  1.00 15.48           C  
ATOM   3499  C   GLY   150      14.943  30.015  41.666  1.00 14.37           C  
ATOM   3500  O   GLY   150      14.776  31.073  42.259  1.00 15.25           O  
ATOM   3501  N   GLY   151      14.467  28.856  42.131  1.00 14.42           N  
ATOM   3502  CA  GLY   151      13.746  28.762  43.411  1.00 14.32           C  
ATOM   3503  C   GLY   151      14.788  28.843  44.553  1.00 15.67           C  
ATOM   3504  O   GLY   151      14.493  29.369  45.625  1.00 15.14           O  
ATOM   3505  N   GLN   152      15.987  28.283  44.336  1.00 14.85           N  
ATOM   3506  CA  GLN   152      17.125  28.541  45.230  1.00 15.32           C  
ATOM   3507  C   GLN   152      17.400  30.056  45.326  1.00 14.97           C  
ATOM   3508  O   GLN   152      17.477  30.615  46.433  1.00 14.39           O  
ATOM   3509  CB  GLN   152      18.360  27.755  44.720  1.00 14.79           C  
ATOM   3510  CG  GLN   152      18.246  26.179  44.894  1.00 17.17           C  
ATOM   3511  CD  GLN   152      19.595  25.514  44.518  1.00 16.43           C  
ATOM   3512  OE1 GLN   152      20.605  25.953  44.980  1.00 18.10           O  
ATOM   3513  NE2 GLN   152      19.592  24.498  43.639  1.00 23.44           N  
ATOM   3514  N   PHE   153      17.560  30.691  44.167  1.00 14.85           N  
ATOM   3515  CA  PHE   153      17.843  32.110  44.052  1.00 15.92           C  
ATOM   3516  C   PHE   153      16.783  32.873  44.835  1.00 15.37           C  
ATOM   3517  O   PHE   153      17.134  33.739  45.645  1.00 16.67           O  
ATOM   3518  CB  PHE   153      17.845  32.487  42.589  1.00 16.10           C  
ATOM   3519  CG  PHE   153      18.246  33.914  42.278  1.00 16.83           C  
ATOM   3520  CD1 PHE   153      19.525  34.178  41.807  1.00 14.93           C  
ATOM   3521  CD2 PHE   153      17.314  34.934  42.341  1.00 15.28           C  
ATOM   3522  CE1 PHE   153      19.891  35.462  41.393  1.00 19.15           C  
ATOM   3523  CE2 PHE   153      17.673  36.261  41.960  1.00 16.29           C  
ATOM   3524  CZ  PHE   153      18.974  36.505  41.458  1.00 17.00           C  
ATOM   3525  N   VAL   154      15.506  32.614  44.548  1.00 14.38           N  
ATOM   3526  CA  VAL   154      14.453  33.390  45.200  1.00 15.95           C  
ATOM   3527  C   VAL   154      14.397  33.258  46.731  1.00 14.86           C  
ATOM   3528  O   VAL   154      14.263  34.272  47.411  1.00 14.70           O  
ATOM   3529  CB  VAL   154      13.095  33.110  44.546  1.00 15.87           C  
ATOM   3530  CG1 VAL   154      11.916  33.582  45.445  1.00 17.47           C  
ATOM   3531  CG2 VAL   154      13.088  33.719  43.121  1.00 17.40           C  
ATOM   3532  N   HIS   155      14.436  32.042  47.290  1.00 14.70           N  
ATOM   3533  CA  HIS   155      14.410  32.023  48.783  1.00 15.64           C  
ATOM   3534  C   HIS   155      15.650  32.618  49.429  1.00 14.97           C  
ATOM   3535  O   HIS   155      15.579  33.249  50.508  1.00 16.18           O  
ATOM   3536  CB  HIS   155      14.039  30.638  49.390  1.00 15.65           C  
ATOM   3537  CG  HIS   155      15.130  29.622  49.355  1.00 17.15           C  
ATOM   3538  ND1 HIS   155      15.958  29.366  50.439  1.00 19.62           N  
ATOM   3539  CD2 HIS   155      15.511  28.766  48.376  1.00 14.76           C  
ATOM   3540  CE1 HIS   155      16.816  28.417  50.116  1.00 15.03           C  
ATOM   3541  NE2 HIS   155      16.554  28.022  48.880  1.00 21.29           N  
ATOM   3542  N   ARG   156      16.793  32.537  48.734  1.00 13.53           N  
ATOM   3543  CA  ARG   156      18.013  33.112  49.305  1.00 13.61           C  
ATOM   3544  C   ARG   156      18.041  34.621  49.152  1.00 14.09           C  
ATOM   3545  O   ARG   156      18.571  35.310  49.980  1.00 14.28           O  
ATOM   3546  CB  ARG   156      19.235  32.505  48.675  1.00 13.37           C  
ATOM   3547  CG  ARG   156      19.338  30.983  49.050  1.00 14.67           C  
ATOM   3548  CD  ARG   156      20.509  30.353  48.313  1.00 16.23           C  
ATOM   3549  NE  ARG   156      20.581  28.937  48.745  1.00 14.43           N  
ATOM   3550  CZ  ARG   156      20.988  27.898  48.031  1.00 19.06           C  
ATOM   3551  NH1 ARG   156      21.406  27.991  46.762  1.00 14.91           N  
ATOM   3552  NH2 ARG   156      20.940  26.741  48.612  1.00 19.25           N  
ATOM   3553  N   LEU   157      17.389  35.099  48.097  1.00 15.36           N  
ATOM   3554  CA  LEU   157      17.088  36.550  47.947  1.00 14.20           C  
ATOM   3555  C   LEU   157      16.252  37.058  49.176  1.00 14.67           C  
ATOM   3556  O   LEU   157      16.604  38.069  49.847  1.00 14.89           O  
ATOM   3557  CB  LEU   157      16.300  36.771  46.644  1.00 14.29           C  
ATOM   3558  CG  LEU   157      16.040  38.286  46.324  1.00 14.84           C  
ATOM   3559  CD1 LEU   157      15.849  38.448  44.816  1.00 16.17           C  
ATOM   3560  CD2 LEU   157      14.812  38.808  47.060  1.00 18.72           C  
ATOM   3561  N   MET   158      15.205  36.295  49.506  1.00 17.58           N  
ATOM   3562  CA  MET   158      14.336  36.659  50.638  1.00 17.74           C  
ATOM   3563  C   MET   158      15.091  36.574  51.936  1.00 17.77           C  
ATOM   3564  O   MET   158      14.749  37.311  52.868  1.00 17.52           O  
ATOM   3565  CB  MET   158      13.002  35.901  50.618  1.00 17.61           C  
ATOM   3566  CG  MET   158      12.158  36.246  49.349  1.00 16.85           C  
ATOM   3567  SD  MET   158      11.782  38.115  49.150  0.70 24.91          SE  
ATOM   3568  CE  MET   158      10.290  38.164  50.419  1.00 20.29           C  
ATOM   3569  N   SER   159      16.120  35.707  51.990  1.00 17.38           N  
ATOM   3570  CA  SER   159      16.931  35.557  53.210  1.00 18.00           C  
ATOM   3571  C   SER   159      17.922  36.702  53.447  1.00 19.19           C  
ATOM   3572  O   SER   159      18.433  36.856  54.590  1.00 20.50           O  
ATOM   3573  CB  SER   159      17.703  34.227  53.224  1.00 17.10           C  
ATOM   3574  OG  SER   159      16.852  33.076  52.976  1.00 20.08           O  
ATOM   3575  N   SER   160      18.209  37.499  52.411  1.00 17.20           N  
ATOM   3576  CA  SER   160      19.347  38.414  52.471  1.00 17.68           C  
ATOM   3577  C   SER   160      19.031  39.843  52.061  1.00 17.89           C  
ATOM   3578  O   SER   160      19.847  40.708  52.328  1.00 19.54           O  
ATOM   3579  CB  SER   160      20.530  37.907  51.629  1.00 18.06           C  
ATOM   3580  OG  SER   160      20.145  37.767  50.243  1.00 18.45           O  
ATOM   3581  N   GLN   161      17.884  40.080  51.388  1.00 16.25           N  
ATOM   3582  CA  GLN   161      17.554  41.379  50.746  1.00 17.21           C  
ATOM   3583  C   GLN   161      16.312  42.037  51.358  1.00 17.35           C  
ATOM   3584  O   GLN   161      15.463  41.327  51.857  1.00 16.30           O  
ATOM   3585  CB  GLN   161      17.290  41.143  49.240  1.00 15.66           C  
ATOM   3586  CG  GLN   161      18.492  40.476  48.530  1.00 16.84           C  
ATOM   3587  CD  GLN   161      19.807  41.267  48.601  1.00 16.73           C  
ATOM   3588  OE1 GLN   161      19.803  42.519  48.429  1.00 17.33           O  
ATOM   3589  NE2 GLN   161      20.947  40.561  48.779  1.00 16.19           N  
ATOM   3590  N   PRO   162      16.202  43.402  51.316  1.00 17.90           N  
ATOM   3591  CA  PRO   162      14.971  44.037  51.733  1.00 17.16           C  
ATOM   3592  C   PRO   162      13.729  43.498  50.984  1.00 16.92           C  
ATOM   3593  O   PRO   162      13.776  43.168  49.761  1.00 17.79           O  
ATOM   3594  CB  PRO   162      15.215  45.538  51.402  1.00 17.41           C  
ATOM   3595  CG  PRO   162      16.714  45.675  51.576  1.00 19.81           C  
ATOM   3596  CD  PRO   162      17.232  44.403  50.933  1.00 18.31           C  
ATOM   3597  N   HIS   163      12.638  43.335  51.727  1.00 16.49           N  
ATOM   3598  CA  HIS   163      11.382  42.824  51.119  1.00 16.95           C  
ATOM   3599  C   HIS   163      10.473  43.860  50.546  1.00 17.45           C  
ATOM   3600  O   HIS   163       9.492  43.491  49.886  1.00 18.66           O  
ATOM   3601  CB  HIS   163      10.581  41.974  52.124  1.00 17.38           C  
ATOM   3602  CG  HIS   163      11.349  40.796  52.631  1.00 17.70           C  
ATOM   3603  ND1 HIS   163      10.965  40.079  53.747  1.00 18.85           N  
ATOM   3604  CD2 HIS   163      12.510  40.236  52.203  1.00 19.56           C  
ATOM   3605  CE1 HIS   163      11.854  39.121  53.977  1.00 17.45           C  
ATOM   3606  NE2 HIS   163      12.812  39.207  53.067  1.00 18.52           N  
ATOM   3607  N   ALA   164      10.769  45.135  50.807  1.00 17.26           N  
ATOM   3608  CA  ALA   164       9.875  46.206  50.369  1.00 19.42           C  
ATOM   3609  C   ALA   164       9.421  46.149  48.887  1.00 19.43           C  
ATOM   3610  O   ALA   164       8.239  46.414  48.616  1.00 19.14           O  
ATOM   3611  CB  ALA   164      10.433  47.560  50.709  1.00 19.17           C  
ATOM   3612  N   PRO   165      10.332  45.794  47.931  1.00 18.73           N  
ATOM   3613  CA  PRO   165       9.887  45.768  46.522  1.00 19.00           C  
ATOM   3614  C   PRO   165       8.858  44.691  46.169  1.00 20.31           C  
ATOM   3615  O   PRO   165       8.288  44.794  45.101  1.00 21.02           O  
ATOM   3616  CB  PRO   165      11.178  45.454  45.732  1.00 19.51           C  
ATOM   3617  CG  PRO   165      12.319  45.977  46.685  1.00 19.30           C  
ATOM   3618  CD  PRO   165      11.783  45.547  48.053  1.00 18.56           C  
ATOM   3619  N   PHE   166       8.665  43.678  47.028  1.00 18.14           N  
ATOM   3620  CA  PHE   166       7.951  42.463  46.633  1.00 18.39           C  
ATOM   3621  C   PHE   166       6.599  42.260  47.320  1.00 18.00           C  
ATOM   3622  O   PHE   166       6.529  42.204  48.548  1.00 20.87           O  
ATOM   3623  CB  PHE   166       8.845  41.263  46.908  1.00 17.02           C  
ATOM   3624  CG  PHE   166      10.207  41.394  46.287  1.00 17.45           C  
ATOM   3625  CD1 PHE   166      11.326  41.652  47.077  1.00 15.53           C  
ATOM   3626  CD2 PHE   166      10.339  41.279  44.897  1.00 16.89           C  
ATOM   3627  CE1 PHE   166      12.610  41.850  46.484  1.00 17.62           C  
ATOM   3628  CE2 PHE   166      11.576  41.436  44.306  1.00 17.21           C  
ATOM   3629  CZ  PHE   166      12.708  41.716  45.103  1.00 16.69           C  
ATOM   3630  N   HIS   167       5.548  42.161  46.524  1.00 18.51           N  
ATOM   3631  CA  HIS   167       4.187  41.919  47.002  1.00 18.59           C  
ATOM   3632  C   HIS   167       3.906  40.423  47.277  1.00 18.68           C  
ATOM   3633  O   HIS   167       3.201  40.082  48.247  1.00 18.79           O  
ATOM   3634  CB  HIS   167       3.174  42.468  45.990  1.00 19.77           C  
ATOM   3635  CG  HIS   167       1.787  41.962  46.231  1.00 24.03           C  
ATOM   3636  ND1 HIS   167       1.040  42.356  47.327  1.00 25.36           N  
ATOM   3637  CD2 HIS   167       1.064  40.999  45.606  1.00 25.21           C  
ATOM   3638  CE1 HIS   167      -0.116  41.708  47.323  1.00 28.77           C  
ATOM   3639  NE2 HIS   167      -0.121  40.871  46.299  1.00 24.63           N  
ATOM   3640  N   ALA   168       4.433  39.548  46.434  1.00 16.29           N  
ATOM   3641  CA  ALA   168       4.315  38.064  46.624  1.00 15.24           C  
ATOM   3642  C   ALA   168       5.520  37.361  46.091  1.00 16.70           C  
ATOM   3643  O   ALA   168       6.158  37.855  45.148  1.00 18.24           O  
ATOM   3644  CB  ALA   168       3.022  37.517  45.970  1.00 16.06           C  
ATOM   3645  N   VAL   169       5.862  36.197  46.676  1.00 16.81           N  
ATOM   3646  CA  VAL   169       7.106  35.491  46.303  1.00 15.77           C  
ATOM   3647  C   VAL   169       6.788  33.997  46.411  1.00 15.77           C  
ATOM   3648  O   VAL   169       6.249  33.530  47.409  1.00 16.09           O  
ATOM   3649  CB  VAL   169       8.224  35.825  47.305  1.00 17.37           C  
ATOM   3650  CG1 VAL   169       9.482  35.002  47.044  1.00 17.45           C  
ATOM   3651  CG2 VAL   169       8.530  37.343  47.320  1.00 16.80           C  
ATOM   3652  N   THR   170       7.155  33.270  45.369  1.00 14.81           N  
ATOM   3653  CA  THR   170       6.979  31.790  45.310  1.00 15.52           C  
ATOM   3654  C   THR   170       8.285  31.173  44.864  1.00 15.14           C  
ATOM   3655  O   THR   170       8.826  31.543  43.794  1.00 15.66           O  
ATOM   3656  CB  THR   170       5.878  31.420  44.338  1.00 15.09           C  
ATOM   3657  OG1 THR   170       4.636  31.869  44.926  1.00 17.04           O  
ATOM   3658  CG2 THR   170       5.798  29.904  44.176  1.00 17.70           C  
ATOM   3659  N   ALA   171       8.780  30.223  45.655  1.00 15.53           N  
ATOM   3660  CA  ALA   171       9.923  29.427  45.245  1.00 16.15           C  
ATOM   3661  C   ALA   171       9.418  28.000  44.901  1.00 16.04           C  
ATOM   3662  O   ALA   171       8.844  27.320  45.764  1.00 16.19           O  
ATOM   3663  CB  ALA   171      10.970  29.374  46.394  1.00 16.48           C  
ATOM   3664  N   ALA   172       9.636  27.605  43.655  1.00 16.04           N  
ATOM   3665  CA  ALA   172       9.062  26.357  43.081  1.00 15.63           C  
ATOM   3666  C   ALA   172      10.135  25.285  42.888  1.00 16.07           C  
ATOM   3667  O   ALA   172      11.130  25.529  42.211  1.00 15.42           O  
ATOM   3668  CB  ALA   172       8.331  26.641  41.759  1.00 15.30           C  
ATOM   3669  N   ASN   173       9.936  24.116  43.494  1.00 15.68           N  
ATOM   3670  CA  ASN   173      10.931  23.008  43.439  1.00 16.10           C  
ATOM   3671  C   ASN   173      12.403  23.372  43.543  1.00 15.48           C  
ATOM   3672  O   ASN   173      13.178  22.912  42.709  1.00 17.26           O  
ATOM   3673  CB  ASN   173      10.765  22.162  42.137  1.00 15.99           C  
ATOM   3674  CG  ASN   173       9.340  21.598  41.969  1.00 17.34           C  
ATOM   3675  OD1 ASN   173       8.713  21.200  42.939  1.00 20.35           O  
ATOM   3676  ND2 ASN   173       8.880  21.482  40.717  1.00 17.95           N  
ATOM   3677  N   PRO   174      12.825  24.203  44.526  1.00 15.36           N  
ATOM   3678  CA  PRO   174      14.268  24.389  44.686  1.00 14.75           C  
ATOM   3679  C   PRO   174      14.997  23.070  44.859  1.00 14.93           C  
ATOM   3680  O   PRO   174      14.452  22.204  45.515  1.00 14.02           O  
ATOM   3681  CB  PRO   174      14.384  25.115  46.046  1.00 15.75           C  
ATOM   3682  CG  PRO   174      13.053  25.933  46.114  1.00 16.51           C  
ATOM   3683  CD  PRO   174      12.026  25.002  45.469  1.00 15.73           C  
ATOM   3684  N   GLY   175      16.232  22.928  44.347  1.00 14.99           N  
ATOM   3685  CA  GLY   175      16.953  21.605  44.485  1.00 15.09           C  
ATOM   3686  C   GLY   175      17.402  21.357  45.928  1.00 16.79           C  
ATOM   3687  O   GLY   175      17.474  20.210  46.414  1.00 17.66           O  
ATOM   3688  N   TRP   176      17.715  22.432  46.633  1.00 14.93           N  
ATOM   3689  CA  TRP   176      17.964  22.368  48.098  1.00 16.04           C  
ATOM   3690  C   TRP   176      17.859  23.800  48.690  1.00 16.08           C  
ATOM   3691  O   TRP   176      17.673  24.787  47.954  1.00 15.82           O  
ATOM   3692  CB  TRP   176      19.337  21.689  48.354  1.00 16.30           C  
ATOM   3693  CG  TRP   176      20.555  22.534  48.085  1.00 20.37           C  
ATOM   3694  CD1 TRP   176      20.973  23.038  46.872  1.00 27.49           C  
ATOM   3695  CD2 TRP   176      21.527  22.979  49.046  1.00 21.40           C  
ATOM   3696  NE1 TRP   176      22.123  23.786  47.032  1.00 27.81           N  
ATOM   3697  CE2 TRP   176      22.506  23.731  48.346  1.00 25.65           C  
ATOM   3698  CE3 TRP   176      21.676  22.799  50.423  1.00 23.04           C  
ATOM   3699  CZ2 TRP   176      23.610  24.325  48.989  1.00 20.62           C  
ATOM   3700  CZ3 TRP   176      22.795  23.355  51.064  1.00 23.84           C  
ATOM   3701  CH2 TRP   176      23.735  24.126  50.350  1.00 24.07           C  
ATOM   3702  N   TYR   177      17.969  23.920  50.010  1.00 16.05           N  
ATOM   3703  CA  TYR   177      17.647  25.184  50.675  1.00 15.83           C  
ATOM   3704  C   TYR   177      18.718  25.693  51.617  1.00 16.11           C  
ATOM   3705  O   TYR   177      19.446  24.939  52.261  1.00 15.13           O  
ATOM   3706  CB  TYR   177      16.350  25.008  51.498  1.00 14.47           C  
ATOM   3707  CG  TYR   177      15.105  24.667  50.680  1.00 17.24           C  
ATOM   3708  CD1 TYR   177      14.184  25.684  50.300  1.00 16.26           C  
ATOM   3709  CD2 TYR   177      14.871  23.343  50.252  1.00 16.49           C  
ATOM   3710  CE1 TYR   177      13.053  25.361  49.571  1.00 13.42           C  
ATOM   3711  CE2 TYR   177      13.776  23.022  49.470  1.00 14.47           C  
ATOM   3712  CZ  TYR   177      12.856  24.039  49.174  1.00 15.87           C  
ATOM   3713  OH  TYR   177      11.765  23.720  48.424  1.00 17.94           O  
ATOM   3714  N   THR   178      18.815  27.021  51.711  1.00 14.78           N  
ATOM   3715  CA  THR   178      19.470  27.650  52.858  1.00 15.16           C  
ATOM   3716  C   THR   178      18.509  27.566  54.058  1.00 15.73           C  
ATOM   3717  O   THR   178      17.443  28.208  54.055  1.00 17.01           O  
ATOM   3718  CB  THR   178      19.738  29.138  52.528  1.00 15.27           C  
ATOM   3719  OG1 THR   178      20.701  29.153  51.474  1.00 18.00           O  
ATOM   3720  CG2 THR   178      20.365  29.866  53.724  1.00 18.14           C  
ATOM   3721  N   LEU   179      18.892  26.816  55.091  1.00 15.80           N  
ATOM   3722  CA  LEU   179      18.046  26.614  56.239  1.00 16.02           C  
ATOM   3723  C   LEU   179      17.997  27.851  57.110  1.00 16.44           C  
ATOM   3724  O   LEU   179      18.981  28.567  57.198  1.00 16.38           O  
ATOM   3725  CB  LEU   179      18.543  25.438  57.069  1.00 16.41           C  
ATOM   3726  CG  LEU   179      18.528  24.081  56.307  1.00 17.19           C  
ATOM   3727  CD1 LEU   179      19.297  23.013  57.089  1.00 22.65           C  
ATOM   3728  CD2 LEU   179      17.094  23.629  55.972  1.00 18.64           C  
ATOM   3729  N   PRO   180      16.847  28.090  57.754  1.00 16.99           N  
ATOM   3730  CA  PRO   180      16.646  29.357  58.570  1.00 17.70           C  
ATOM   3731  C   PRO   180      17.352  29.237  59.966  1.00 18.37           C  
ATOM   3732  O   PRO   180      16.705  29.094  61.032  1.00 19.27           O  
ATOM   3733  CB  PRO   180      15.117  29.474  58.650  1.00 18.35           C  
ATOM   3734  CG  PRO   180      14.642  27.979  58.616  1.00 17.22           C  
ATOM   3735  CD  PRO   180      15.648  27.217  57.712  1.00 16.31           C  
ATOM   3736  N   THR   181      18.676  29.218  59.929  1.00 18.40           N  
ATOM   3737  CA  THR   181      19.460  28.980  61.126  1.00 18.08           C  
ATOM   3738  C   THR   181      20.889  29.475  60.936  1.00 18.26           C  
ATOM   3739  O   THR   181      21.432  29.388  59.840  1.00 17.74           O  
ATOM   3740  CB  THR   181      19.502  27.456  61.513  1.00 19.05           C  
ATOM   3741  OG1 THR   181      20.314  27.280  62.691  1.00 17.53           O  
ATOM   3742  CG2 THR   181      20.081  26.593  60.363  1.00 19.95           C  
ATOM   3743  N   PHE   182      21.478  30.014  61.999  1.00 17.43           N  
ATOM   3744  CA  PHE   182      22.890  30.391  61.964  1.00 19.00           C  
ATOM   3745  C   PHE   182      23.852  29.253  62.352  1.00 19.69           C  
ATOM   3746  O   PHE   182      25.065  29.464  62.433  1.00 20.00           O  
ATOM   3747  CB  PHE   182      23.133  31.617  62.854  1.00 19.22           C  
ATOM   3748  CG  PHE   182      22.603  32.870  62.257  1.00 17.75           C  
ATOM   3749  CD1 PHE   182      21.270  33.239  62.460  1.00 19.31           C  
ATOM   3750  CD2 PHE   182      23.387  33.611  61.383  1.00 18.18           C  
ATOM   3751  CE1 PHE   182      20.727  34.389  61.844  1.00 19.54           C  
ATOM   3752  CE2 PHE   182      22.853  34.802  60.782  1.00 21.66           C  
ATOM   3753  CZ  PHE   182      21.527  35.167  61.008  1.00 21.87           C  
ATOM   3754  N   GLU   183      23.312  28.061  62.578  1.00 20.80           N  
ATOM   3755  CA  GLU   183      24.140  26.874  62.870  1.00 22.74           C  
ATOM   3756  C   GLU   183      25.103  26.488  61.742  1.00 23.03           C  
ATOM   3757  O   GLU   183      26.121  25.844  62.005  1.00 23.02           O  
ATOM   3758  CB  GLU   183      23.271  25.661  63.065  1.00 23.12           C  
ATOM   3759  CG  GLU   183      22.587  25.594  64.363  1.00 31.35           C  
ATOM   3760  CD  GLU   183      21.477  24.541  64.377  1.00 37.90           C  
ATOM   3761  OE1 GLU   183      20.411  24.743  63.678  1.00 36.71           O  
ATOM   3762  OE2 GLU   183      21.689  23.537  65.121  1.00 39.70           O  
ATOM   3763  N   HIS   184      24.754  26.833  60.495  1.00 21.97           N  
ATOM   3764  CA  HIS   184      25.537  26.441  59.353  1.00 21.43           C  
ATOM   3765  C   HIS   184      25.929  27.647  58.522  1.00 21.29           C  
ATOM   3766  O   HIS   184      25.181  28.612  58.453  1.00 20.04           O  
ATOM   3767  CB  HIS   184      24.738  25.483  58.486  1.00 22.54           C  
ATOM   3768  CG  HIS   184      24.024  24.425  59.265  1.00 24.69           C  
ATOM   3769  ND1 HIS   184      24.684  23.503  60.052  1.00 30.80           N  
ATOM   3770  CD2 HIS   184      22.706  24.122  59.355  1.00 29.03           C  
ATOM   3771  CE1 HIS   184      23.803  22.698  60.618  1.00 27.66           C  
ATOM   3772  NE2 HIS   184      22.597  23.047  60.207  1.00 29.10           N  
ATOM   3773  N   ARG   185      27.116  27.559  57.916  1.00 19.71           N  
ATOM   3774  CA  ARG   185      27.622  28.578  57.009  1.00 20.06           C  
ATOM   3775  C   ARG   185      26.773  28.546  55.733  1.00 18.66           C  
ATOM   3776  O   ARG   185      26.403  27.485  55.240  1.00 18.05           O  
ATOM   3777  CB  ARG   185      29.091  28.253  56.693  1.00 21.61           C  
ATOM   3778  CG  ARG   185      29.828  29.237  55.829  1.00 24.89           C  
ATOM   3779  CD  ARG   185      31.282  28.745  55.741  1.00 32.20           C  
ATOM   3780  NE  ARG   185      32.098  29.628  54.917  1.00 39.06           N  
ATOM   3781  CZ  ARG   185      32.632  30.781  55.338  1.00 41.95           C  
ATOM   3782  NH1 ARG   185      32.426  31.204  56.587  1.00 42.59           N  
ATOM   3783  NH2 ARG   185      33.372  31.519  54.497  1.00 41.90           N  
ATOM   3784  N   PHE   186      26.494  29.732  55.220  1.00 18.84           N  
ATOM   3785  CA  PHE   186      25.878  29.897  53.914  1.00 18.77           C  
ATOM   3786  C   PHE   186      26.707  29.140  52.837  1.00 19.21           C  
ATOM   3787  O   PHE   186      27.932  29.157  52.900  1.00 18.49           O  
ATOM   3788  CB  PHE   186      25.852  31.399  53.588  1.00 17.73           C  
ATOM   3789  CG  PHE   186      25.047  31.720  52.350  1.00 18.31           C  
ATOM   3790  CD1 PHE   186      23.678  31.867  52.448  1.00 17.05           C  
ATOM   3791  CD2 PHE   186      25.657  31.850  51.109  1.00 18.85           C  
ATOM   3792  CE1 PHE   186      22.883  32.131  51.327  1.00 20.49           C  
ATOM   3793  CE2 PHE   186      24.869  32.125  49.953  1.00 17.98           C  
ATOM   3794  CZ  PHE   186      23.482  32.285  50.088  1.00 20.05           C  
ATOM   3795  N   PRO   187      26.046  28.521  51.826  1.00 18.55           N  
ATOM   3796  CA  PRO   187      24.596  28.506  51.574  1.00 19.28           C  
ATOM   3797  C   PRO   187      23.784  27.451  52.373  1.00 18.69           C  
ATOM   3798  O   PRO   187      22.559  27.368  52.225  1.00 20.36           O  
ATOM   3799  CB  PRO   187      24.523  28.211  50.070  1.00 18.90           C  
ATOM   3800  CG  PRO   187      25.761  27.408  49.787  1.00 18.90           C  
ATOM   3801  CD  PRO   187      26.796  27.802  50.773  1.00 20.27           C  
ATOM   3802  N   GLU   188      24.430  26.611  53.195  1.00 17.29           N  
ATOM   3803  CA  GLU   188      23.585  25.648  53.966  1.00 17.37           C  
ATOM   3804  C   GLU   188      22.707  26.346  55.032  1.00 17.67           C  
ATOM   3805  O   GLU   188      21.553  25.927  55.312  1.00 17.33           O  
ATOM   3806  CB  GLU   188      24.427  24.550  54.637  1.00 16.24           C  
ATOM   3807  CG  GLU   188      23.523  23.538  55.402  1.00 15.53           C  
ATOM   3808  CD  GLU   188      24.258  22.353  56.016  1.00 19.95           C  
ATOM   3809  OE1 GLU   188      25.520  22.403  56.179  1.00 22.48           O  
ATOM   3810  OE2 GLU   188      23.569  21.364  56.358  1.00 21.10           O  
ATOM   3811  N   GLY   189      23.251  27.412  55.614  1.00 16.69           N  
ATOM   3812  CA  GLY   189      22.556  28.153  56.666  1.00 16.98           C  
ATOM   3813  C   GLY   189      22.863  29.632  56.455  1.00 17.33           C  
ATOM   3814  O   GLY   189      23.258  30.031  55.359  1.00 17.04           O  
ATOM   3815  N   LEU   190      22.686  30.421  57.507  1.00 17.60           N  
ATOM   3816  CA  LEU   190      22.708  31.869  57.413  1.00 17.16           C  
ATOM   3817  C   LEU   190      24.030  32.433  57.924  1.00 18.03           C  
ATOM   3818  O   LEU   190      24.244  33.642  57.872  1.00 16.67           O  
ATOM   3819  CB  LEU   190      21.544  32.463  58.185  1.00 18.22           C  
ATOM   3820  CG  LEU   190      20.154  32.196  57.591  1.00 19.06           C  
ATOM   3821  CD1 LEU   190      19.043  32.739  58.458  1.00 22.27           C  
ATOM   3822  CD2 LEU   190      20.036  32.677  56.082  1.00 16.42           C  
ATOM   3823  N   ASP   191      24.924  31.585  58.406  1.00 17.75           N  
ATOM   3824  CA  ASP   191      26.152  32.110  59.030  1.00 20.43           C  
ATOM   3825  C   ASP   191      27.256  32.446  58.027  1.00 20.27           C  
ATOM   3826  O   ASP   191      27.268  31.923  56.944  1.00 20.48           O  
ATOM   3827  CB  ASP   191      26.682  31.099  60.036  1.00 21.59           C  
ATOM   3828  CG  ASP   191      27.481  31.747  61.145  1.00 27.46           C  
ATOM   3829  OD1 ASP   191      28.458  31.096  61.584  1.00 32.13           O  
ATOM   3830  OD2 ASP   191      27.127  32.888  61.582  1.00 34.11           O  
ATOM   3831  N   GLY   192      28.183  33.325  58.407  1.00 20.89           N  
ATOM   3832  CA  GLY   192      29.417  33.524  57.651  1.00 20.16           C  
ATOM   3833  C   GLY   192      29.321  34.583  56.560  1.00 20.91           C  
ATOM   3834  O   GLY   192      30.291  34.767  55.785  1.00 21.63           O  
ATOM   3835  N   VAL   193      28.177  35.269  56.487  1.00 19.02           N  
ATOM   3836  CA  VAL   193      27.863  36.149  55.347  1.00 20.41           C  
ATOM   3837  C   VAL   193      27.375  37.548  55.731  1.00 20.68           C  
ATOM   3838  O   VAL   193      26.845  38.297  54.884  1.00 20.85           O  
ATOM   3839  CB  VAL   193      26.927  35.516  54.281  1.00 20.31           C  
ATOM   3840  CG1 VAL   193      27.684  34.396  53.511  1.00 20.96           C  
ATOM   3841  CG2 VAL   193      25.650  34.985  54.907  1.00 18.91           C  
ATOM   3842  N   GLY   194      27.543  37.895  57.000  1.00 20.27           N  
ATOM   3843  CA  GLY   194      27.125  39.200  57.501  1.00 22.14           C  
ATOM   3844  C   GLY   194      25.633  39.427  57.677  1.00 22.74           C  
ATOM   3845  O   GLY   194      25.158  40.576  57.654  1.00 23.42           O  
ATOM   3846  N   LEU   195      24.876  38.350  57.804  1.00 21.31           N  
ATOM   3847  CA  LEU   195      23.424  38.454  58.043  1.00 22.02           C  
ATOM   3848  C   LEU   195      23.119  38.436  59.550  1.00 22.81           C  
ATOM   3849  O   LEU   195      23.997  38.130  60.355  1.00 23.51           O  
ATOM   3850  CB  LEU   195      22.736  37.287  57.401  1.00 19.83           C  
ATOM   3851  CG  LEU   195      22.121  37.346  55.980  1.00 25.27           C  
ATOM   3852  CD1 LEU   195      22.455  38.553  55.065  1.00 22.38           C  
ATOM   3853  CD2 LEU   195      22.261  35.958  55.292  1.00 20.98           C  
ATOM   3854  N   THR   196      21.872  38.738  59.921  1.00 23.32           N  
ATOM   3855  CA  THR   196      21.501  39.011  61.304  1.00 23.82           C  
ATOM   3856  C   THR   196      20.199  38.369  61.691  1.00 23.34           C  
ATOM   3857  O   THR   196      19.442  37.881  60.842  1.00 21.05           O  
ATOM   3858  CB  THR   196      21.369  40.551  61.574  1.00 24.83           C  
ATOM   3859  OG1 THR   196      20.216  41.064  60.883  1.00 26.21           O  
ATOM   3860  CG2 THR   196      22.621  41.300  61.108  1.00 27.07           C  
ATOM   3861  N   GLU   197      19.927  38.360  62.998  1.00 22.14           N  
ATOM   3862  CA  GLU   197      18.661  37.831  63.465  1.00 23.25           C  
ATOM   3863  C   GLU   197      17.476  38.587  62.873  1.00 22.77           C  
ATOM   3864  O   GLU   197      16.423  37.978  62.595  1.00 21.26           O  
ATOM   3865  CB  GLU   197      18.621  37.680  64.989  1.00 22.83           C  
ATOM   3866  CG  GLU   197      19.362  36.394  65.474  1.00 24.23           C  
ATOM   3867  CD  GLU   197      18.509  35.102  65.342  1.00 25.31           C  
ATOM   3868  OE1 GLU   197      17.333  35.078  65.783  1.00 28.05           O  
ATOM   3869  OE2 GLU   197      18.995  34.101  64.793  1.00 26.47           O  
ATOM   3870  N   ASP   198      17.679  39.870  62.580  1.00 23.55           N  
ATOM   3871  CA  ASP   198      16.647  40.644  61.865  1.00 24.80           C  
ATOM   3872  C   ASP   198      16.324  40.117  60.476  1.00 23.24           C  
ATOM   3873  O   ASP   198      15.165  40.109  60.110  1.00 22.05           O  
ATOM   3874  CB  ASP   198      17.013  42.122  61.767  1.00 26.27           C  
ATOM   3875  CG  ASP   198      17.033  42.805  63.119  1.00 33.57           C  
ATOM   3876  OD1 ASP   198      16.191  42.458  64.007  1.00 38.36           O  
ATOM   3877  OD2 ASP   198      17.896  43.707  63.291  1.00 42.13           O  
ATOM   3878  N   HIS   199      17.345  39.711  59.710  1.00 21.78           N  
ATOM   3879  CA  HIS   199      17.128  39.120  58.394  1.00 20.79           C  
ATOM   3880  C   HIS   199      16.268  37.921  58.565  1.00 19.98           C  
ATOM   3881  O   HIS   199      15.304  37.739  57.808  1.00 18.83           O  
ATOM   3882  CB  HIS   199      18.440  38.724  57.661  1.00 21.80           C  
ATOM   3883  CG  HIS   199      19.238  39.906  57.182  1.00 25.53           C  
ATOM   3884  ND1 HIS   199      20.356  40.373  57.853  1.00 27.33           N  
ATOM   3885  CD2 HIS   199      19.056  40.744  56.124  1.00 26.40           C  
ATOM   3886  CE1 HIS   199      20.826  41.442  57.232  1.00 26.50           C  
ATOM   3887  NE2 HIS   199      20.045  41.699  56.193  1.00 26.95           N  
ATOM   3888  N   LEU   200      16.595  37.094  59.559  1.00 18.58           N  
ATOM   3889  CA  LEU   200      15.883  35.836  59.777  1.00 18.21           C  
ATOM   3890  C   LEU   200      14.405  36.088  60.185  1.00 18.72           C  
ATOM   3891  O   LEU   200      13.478  35.441  59.670  1.00 17.58           O  
ATOM   3892  CB  LEU   200      16.643  35.000  60.835  1.00 17.02           C  
ATOM   3893  CG  LEU   200      15.955  33.679  61.189  1.00 17.07           C  
ATOM   3894  CD1 LEU   200      15.558  32.852  59.969  1.00 19.23           C  
ATOM   3895  CD2 LEU   200      16.861  32.884  62.119  1.00 20.98           C  
ATOM   3896  N   ALA   201      14.183  37.033  61.103  1.00 18.86           N  
ATOM   3897  CA  ALA   201      12.820  37.370  61.504  1.00 18.76           C  
ATOM   3898  C   ALA   201      12.001  37.850  60.303  1.00 18.98           C  
ATOM   3899  O   ALA   201      10.844  37.458  60.147  1.00 18.94           O  
ATOM   3900  CB  ALA   201      12.797  38.442  62.651  1.00 18.87           C  
ATOM   3901  N   ARG   202      12.588  38.700  59.476  1.00 18.79           N  
ATOM   3902  CA  ARG   202      11.877  39.222  58.317  1.00 18.55           C  
ATOM   3903  C   ARG   202      11.574  38.103  57.338  1.00 17.07           C  
ATOM   3904  O   ARG   202      10.447  38.042  56.767  1.00 16.85           O  
ATOM   3905  CB  ARG   202      12.709  40.279  57.642  1.00 19.29           C  
ATOM   3906  CG  ARG   202      12.714  41.529  58.504  1.00 19.82           C  
ATOM   3907  CD  ARG   202      13.638  42.563  57.917  1.00 29.60           C  
ATOM   3908  NE  ARG   202      13.549  43.719  58.796  1.00 37.78           N  
ATOM   3909  CZ  ARG   202      14.551  44.209  59.512  1.00 43.28           C  
ATOM   3910  NH1 ARG   202      15.760  43.676  59.435  1.00 44.60           N  
ATOM   3911  NH2 ARG   202      14.329  45.259  60.306  1.00 48.05           N  
ATOM   3912  N   LEU   203      12.556  37.223  57.178  1.00 17.05           N  
ATOM   3913  CA  LEU   203      12.356  36.058  56.299  1.00 17.78           C  
ATOM   3914  C   LEU   203      11.164  35.241  56.755  1.00 18.26           C  
ATOM   3915  O   LEU   203      10.292  34.859  55.943  1.00 17.52           O  
ATOM   3916  CB  LEU   203      13.608  35.215  56.248  1.00 17.80           C  
ATOM   3917  CG  LEU   203      13.490  33.770  55.660  1.00 20.04           C  
ATOM   3918  CD1 LEU   203      13.136  33.785  54.152  1.00 15.91           C  
ATOM   3919  CD2 LEU   203      14.784  32.990  55.959  1.00 17.43           C  
ATOM   3920  N   LEU   204      11.182  34.861  58.045  1.00 17.60           N  
ATOM   3921  CA  LEU   204      10.157  33.968  58.615  1.00 17.49           C  
ATOM   3922  C   LEU   204       8.752  34.529  58.537  1.00 17.97           C  
ATOM   3923  O   LEU   204       7.808  33.773  58.337  1.00 18.05           O  
ATOM   3924  CB  LEU   204      10.483  33.586  60.072  1.00 17.07           C  
ATOM   3925  CG  LEU   204      11.709  32.647  60.204  1.00 16.22           C  
ATOM   3926  CD1 LEU   204      12.182  32.536  61.685  1.00 15.50           C  
ATOM   3927  CD2 LEU   204      11.430  31.178  59.680  1.00 16.53           C  
ATOM   3928  N   ALA   205       8.627  35.841  58.671  1.00 16.87           N  
ATOM   3929  CA  ALA   205       7.334  36.521  58.688  1.00 17.83           C  
ATOM   3930  C   ALA   205       6.702  36.621  57.303  1.00 16.37           C  
ATOM   3931  O   ALA   205       5.465  36.634  57.181  1.00 15.14           O  
ATOM   3932  CB  ALA   205       7.498  37.937  59.259  1.00 16.31           C  
ATOM   3933  N   TYR   206       7.536  36.681  56.260  1.00 17.70           N  
ATOM   3934  CA  TYR   206       7.038  36.948  54.907  1.00 17.10           C  
ATOM   3935  C   TYR   206       6.099  35.804  54.458  1.00 16.98           C  
ATOM   3936  O   TYR   206       6.420  34.650  54.720  1.00 17.85           O  
ATOM   3937  CB  TYR   206       8.223  37.143  53.925  1.00 18.33           C  
ATOM   3938  CG  TYR   206       7.733  37.765  52.670  1.00 17.14           C  
ATOM   3939  CD1 TYR   206       7.244  36.974  51.626  1.00 17.82           C  
ATOM   3940  CD2 TYR   206       7.698  39.177  52.538  1.00 17.29           C  
ATOM   3941  CE1 TYR   206       6.730  37.561  50.474  1.00 18.16           C  
ATOM   3942  CE2 TYR   206       7.217  39.766  51.345  1.00 17.75           C  
ATOM   3943  CZ  TYR   206       6.732  38.960  50.361  1.00 15.42           C  
ATOM   3944  OH  TYR   206       6.255  39.551  49.208  1.00 20.16           O  
ATOM   3945  N   PRO   207       4.964  36.117  53.777  1.00 17.67           N  
ATOM   3946  CA  PRO   207       4.033  35.065  53.289  1.00 17.92           C  
ATOM   3947  C   PRO   207       4.514  34.322  52.006  1.00 18.88           C  
ATOM   3948  O   PRO   207       3.813  34.270  50.975  1.00 18.28           O  
ATOM   3949  CB  PRO   207       2.738  35.829  53.030  1.00 18.94           C  
ATOM   3950  CG  PRO   207       3.158  37.210  52.616  1.00 18.26           C  
ATOM   3951  CD  PRO   207       4.434  37.473  53.516  1.00 17.11           C  
ATOM   3952  N   MET   208       5.724  33.789  52.077  1.00 18.11           N  
ATOM   3953  CA  MET   208       6.354  33.183  50.921  1.00 18.90           C  
ATOM   3954  C   MET   208       5.695  31.839  50.666  1.00 18.72           C  
ATOM   3955  O   MET   208       5.424  31.093  51.627  1.00 20.00           O  
ATOM   3956  CB  MET   208       7.861  32.953  51.215  1.00 18.05           C  
ATOM   3957  CG  MET   208       8.515  32.200  50.075  1.00 20.34           C  
ATOM   3958  SD  MET   208      10.485  32.192  50.323  0.80 26.45          SE  
ATOM   3959  CE  MET   208      10.754  33.903  51.155  1.00 34.55           C  
ATOM   3960  N   THR   209       5.420  31.507  49.402  1.00 17.14           N  
ATOM   3961  CA  THR   209       4.918  30.164  49.084  1.00 17.42           C  
ATOM   3962  C   THR   209       6.081  29.280  48.669  1.00 17.44           C  
ATOM   3963  O   THR   209       6.868  29.685  47.838  1.00 16.60           O  
ATOM   3964  CB  THR   209       3.896  30.226  47.887  1.00 19.36           C  
ATOM   3965  OG1 THR   209       2.786  31.063  48.241  1.00 20.23           O  
ATOM   3966  CG2 THR   209       3.356  28.819  47.528  1.00 17.89           C  
ATOM   3967  N   ILE   210       6.149  28.069  49.215  1.00 17.93           N  
ATOM   3968  CA  ILE   210       7.013  27.031  48.729  1.00 18.42           C  
ATOM   3969  C   ILE   210       6.106  26.131  47.893  1.00 17.87           C  
ATOM   3970  O   ILE   210       5.167  25.531  48.394  1.00 17.26           O  
ATOM   3971  CB  ILE   210       7.616  26.276  49.904  1.00 19.25           C  
ATOM   3972  CG1 ILE   210       8.323  27.285  50.835  1.00 21.19           C  
ATOM   3973  CG2 ILE   210       8.479  25.108  49.403  1.00 20.07           C  
ATOM   3974  CD1 ILE   210       8.272  26.745  52.342  1.00 22.24           C  
ATOM   3975  N   LEU   211       6.351  26.114  46.591  1.00 17.03           N  
ATOM   3976  CA  LEU   211       5.493  25.421  45.656  1.00 17.87           C  
ATOM   3977  C   LEU   211       6.221  24.150  45.235  1.00 17.76           C  
ATOM   3978  O   LEU   211       7.331  24.197  44.637  1.00 18.18           O  
ATOM   3979  CB  LEU   211       5.199  26.353  44.470  1.00 17.15           C  
ATOM   3980  CG  LEU   211       4.122  25.874  43.487  1.00 15.20           C  
ATOM   3981  CD1 LEU   211       2.763  25.901  44.205  1.00 17.82           C  
ATOM   3982  CD2 LEU   211       4.070  26.859  42.319  1.00 17.18           C  
ATOM   3983  N   ALA   212       5.620  23.005  45.541  1.00 17.38           N  
ATOM   3984  CA  ALA   212       6.348  21.725  45.407  1.00 17.86           C  
ATOM   3985  C   ALA   212       5.531  20.676  44.647  1.00 17.12           C  
ATOM   3986  O   ALA   212       4.478  20.271  45.121  1.00 17.74           O  
ATOM   3987  CB  ALA   212       6.779  21.176  46.785  1.00 16.50           C  
ATOM   3988  N   GLY   213       6.057  20.220  43.517  1.00 16.84           N  
ATOM   3989  CA  GLY   213       5.454  19.126  42.756  1.00 18.00           C  
ATOM   3990  C   GLY   213       5.661  17.807  43.462  1.00 18.80           C  
ATOM   3991  O   GLY   213       6.793  17.448  43.820  1.00 19.21           O  
ATOM   3992  N   ASP   214       4.578  17.058  43.706  1.00 19.73           N  
ATOM   3993  CA  ASP   214       4.714  15.826  44.449  1.00 19.39           C  
ATOM   3994  C   ASP   214       5.250  14.674  43.586  1.00 20.55           C  
ATOM   3995  O   ASP   214       5.466  13.537  44.071  1.00 19.88           O  
ATOM   3996  CB  ASP   214       3.407  15.488  45.190  1.00 20.36           C  
ATOM   3997  CG  ASP   214       2.304  14.895  44.281  1.00 23.41           C  
ATOM   3998  OD1 ASP   214       2.509  14.675  43.043  1.00 22.47           O  
ATOM   3999  OD2 ASP   214       1.191  14.651  44.849  1.00 25.10           O  
ATOM   4000  N   GLN   215       5.506  14.958  42.308  1.00 19.95           N  
ATOM   4001  CA  GLN   215       6.221  13.979  41.485  1.00 19.76           C  
ATOM   4002  C   GLN   215       7.699  14.358  41.309  1.00 19.23           C  
ATOM   4003  O   GLN   215       8.376  13.750  40.506  1.00 18.36           O  
ATOM   4004  CB  GLN   215       5.536  13.735  40.140  1.00 20.59           C  
ATOM   4005  CG  GLN   215       4.086  13.327  40.244  1.00 22.32           C  
ATOM   4006  CD  GLN   215       3.933  12.047  41.046  1.00 28.31           C  
ATOM   4007  OE1 GLN   215       4.483  11.000  40.691  1.00 27.97           O  
ATOM   4008  NE2 GLN   215       3.184  12.128  42.151  1.00 31.00           N  
ATOM   4009  N   ASP   216       8.188  15.353  42.063  1.00 18.74           N  
ATOM   4010  CA  ASP   216       9.608  15.759  41.944  1.00 19.60           C  
ATOM   4011  C   ASP   216      10.398  14.885  42.899  1.00 19.47           C  
ATOM   4012  O   ASP   216      10.855  15.318  43.946  1.00 18.74           O  
ATOM   4013  CB  ASP   216       9.776  17.272  42.234  1.00 20.11           C  
ATOM   4014  CG  ASP   216      11.050  17.860  41.632  1.00 21.50           C  
ATOM   4015  OD1 ASP   216      11.999  17.104  41.338  1.00 21.13           O  
ATOM   4016  OD2 ASP   216      11.117  19.096  41.490  1.00 21.91           O  
ATOM   4017  N   ILE   217      10.457  13.616  42.545  1.00 20.38           N  
ATOM   4018  CA  ILE   217      10.896  12.557  43.442  1.00 22.14           C  
ATOM   4019  C   ILE   217      11.996  11.666  42.891  1.00 23.62           C  
ATOM   4020  O   ILE   217      12.294  10.635  43.493  1.00 23.91           O  
ATOM   4021  CB  ILE   217       9.707  11.673  43.920  1.00 21.74           C  
ATOM   4022  CG1 ILE   217       9.054  10.912  42.740  1.00 20.25           C  
ATOM   4023  CG2 ILE   217       8.703  12.505  44.779  1.00 22.00           C  
ATOM   4024  CD1 ILE   217       7.722  10.313  43.069  1.00 22.96           C  
ATOM   4025  N   ALA   218      12.614  12.040  41.773  1.00 25.55           N  
ATOM   4026  CA  ALA   218      13.784  11.288  41.299  1.00 27.61           C  
ATOM   4027  C   ALA   218      14.944  11.481  42.290  1.00 29.37           C  
ATOM   4028  O   ALA   218      15.089  12.547  42.910  1.00 29.13           O  
ATOM   4029  CB  ALA   218      14.184  11.715  39.897  1.00 27.99           C  
ATOM   4030  N   THR   219      15.733  10.436  42.493  1.00 31.87           N  
ATOM   4031  CA  THR   219      16.842  10.499  43.458  1.00 34.21           C  
ATOM   4032  C   THR   219      18.155  10.414  42.671  1.00 34.97           C  
ATOM   4033  O   THR   219      19.246  10.537  43.240  1.00 35.95           O  
ATOM   4034  CB  THR   219      16.761   9.356  44.511  1.00 34.36           C  
ATOM   4035  OG1 THR   219      16.635   8.126  43.816  1.00 37.50           O  
ATOM   4036  CG2 THR   219      15.526   9.525  45.457  1.00 34.51           C  
ATOM   4037  N   PRO   222      21.170  13.248  38.162  1.00 41.76           N  
ATOM   4038  CA  PRO   222      22.448  13.754  37.657  1.00 41.56           C  
ATOM   4039  C   PRO   222      22.443  15.264  37.800  1.00 41.50           C  
ATOM   4040  O   PRO   222      23.490  15.867  38.091  1.00 41.17           O  
ATOM   4041  CB  PRO   222      22.444  13.362  36.169  1.00 41.84           C  
ATOM   4042  CG  PRO   222      21.413  12.291  36.046  1.00 41.73           C  
ATOM   4043  CD  PRO   222      20.403  12.515  37.137  1.00 42.58           C  
ATOM   4044  N   ASN   223      21.270  15.877  37.656  1.00 41.73           N  
ATOM   4045  CA  ASN   223      21.123  17.276  38.020  1.00 41.88           C  
ATOM   4046  C   ASN   223      20.499  17.542  39.399  1.00 40.80           C  
ATOM   4047  O   ASN   223      20.181  18.704  39.712  1.00 40.74           O  
ATOM   4048  CB  ASN   223      20.372  18.073  36.933  1.00 43.63           C  
ATOM   4049  CG  ASN   223      21.289  18.510  35.761  1.00 47.57           C  
ATOM   4050  OD1 ASN   223      21.905  19.602  35.783  1.00 50.29           O  
ATOM   4051  ND2 ASN   223      21.353  17.663  34.719  1.00 50.25           N  
ATOM   4052  N   LEU   224      20.308  16.509  40.220  1.00 38.63           N  
ATOM   4053  CA  LEU   224      19.858  16.746  41.598  1.00 37.19           C  
ATOM   4054  C   LEU   224      21.057  17.115  42.454  1.00 35.04           C  
ATOM   4055  O   LEU   224      22.049  16.396  42.429  1.00 33.78           O  
ATOM   4056  CB  LEU   224      19.151  15.525  42.212  1.00 37.46           C  
ATOM   4057  CG  LEU   224      18.625  15.699  43.668  1.00 38.77           C  
ATOM   4058  CD1 LEU   224      17.263  16.389  43.739  1.00 37.44           C  
ATOM   4059  CD2 LEU   224      18.613  14.374  44.538  1.00 37.11           C  
ATOM   4060  N   PRO   225      20.965  18.232  43.210  1.00 33.65           N  
ATOM   4061  CA  PRO   225      22.065  18.567  44.106  1.00 32.41           C  
ATOM   4062  C   PRO   225      22.354  17.396  45.015  1.00 31.43           C  
ATOM   4063  O   PRO   225      21.439  16.898  45.647  1.00 32.13           O  
ATOM   4064  CB  PRO   225      21.527  19.776  44.897  1.00 32.28           C  
ATOM   4065  CG  PRO   225      20.506  20.404  43.962  1.00 32.35           C  
ATOM   4066  CD  PRO   225      19.871  19.237  43.283  1.00 33.38           C  
ATOM   4067  N   SER   226      23.608  16.948  45.060  1.00 29.33           N  
ATOM   4068  CA  SER   226      23.944  15.739  45.784  1.00 28.29           C  
ATOM   4069  C   SER   226      25.118  15.909  46.728  1.00 26.55           C  
ATOM   4070  O   SER   226      25.698  14.935  47.204  1.00 25.95           O  
ATOM   4071  CB  SER   226      24.269  14.645  44.787  1.00 29.48           C  
ATOM   4072  OG  SER   226      25.408  15.034  44.039  1.00 31.24           O  
ATOM   4073  N   GLU   227      25.460  17.151  47.009  1.00 25.86           N  
ATOM   4074  CA  GLU   227      26.394  17.434  48.080  1.00 26.38           C  
ATOM   4075  C   GLU   227      25.765  17.075  49.431  1.00 23.03           C  
ATOM   4076  O   GLU   227      24.541  17.038  49.558  1.00 21.24           O  
ATOM   4077  CB  GLU   227      26.757  18.906  48.071  1.00 27.59           C  
ATOM   4078  CG  GLU   227      27.470  19.265  46.808  1.00 34.41           C  
ATOM   4079  CD  GLU   227      28.883  19.606  47.080  1.00 43.27           C  
ATOM   4080  OE1 GLU   227      29.085  20.793  47.464  1.00 46.05           O  
ATOM   4081  OE2 GLU   227      29.764  18.690  46.943  1.00 45.01           O  
ATOM   4082  N   PRO   228      26.608  16.756  50.412  1.00 22.07           N  
ATOM   4083  CA  PRO   228      26.073  16.344  51.716  1.00 20.93           C  
ATOM   4084  C   PRO   228      25.038  17.263  52.344  1.00 18.76           C  
ATOM   4085  O   PRO   228      24.061  16.790  52.867  1.00 17.14           O  
ATOM   4086  CB  PRO   228      27.322  16.220  52.592  1.00 20.47           C  
ATOM   4087  CG  PRO   228      28.371  15.811  51.612  1.00 23.30           C  
ATOM   4088  CD  PRO   228      28.077  16.604  50.348  1.00 20.83           C  
ATOM   4089  N   ALA   229      25.219  18.586  52.280  1.00 19.32           N  
ATOM   4090  CA  ALA   229      24.229  19.457  52.824  1.00 18.61           C  
ATOM   4091  C   ALA   229      22.867  19.292  52.172  1.00 17.34           C  
ATOM   4092  O   ALA   229      21.859  19.330  52.876  1.00 18.18           O  
ATOM   4093  CB  ALA   229      24.719  20.933  52.768  1.00 17.75           C  
ATOM   4094  N   ALA   230      22.820  19.078  50.855  1.00 17.90           N  
ATOM   4095  CA  ALA   230      21.558  18.830  50.165  1.00 18.18           C  
ATOM   4096  C   ALA   230      20.961  17.481  50.618  1.00 17.05           C  
ATOM   4097  O   ALA   230      19.774  17.369  50.892  1.00 17.69           O  
ATOM   4098  CB  ALA   230      21.751  18.795  48.608  1.00 19.21           C  
ATOM   4099  N   LEU   231      21.801  16.477  50.660  1.00 17.78           N  
ATOM   4100  CA  LEU   231      21.360  15.134  51.052  1.00 17.10           C  
ATOM   4101  C   LEU   231      20.790  15.135  52.499  1.00 16.85           C  
ATOM   4102  O   LEU   231      19.806  14.434  52.790  1.00 16.20           O  
ATOM   4103  CB  LEU   231      22.502  14.151  50.875  1.00 19.66           C  
ATOM   4104  CG  LEU   231      22.944  13.873  49.420  1.00 20.37           C  
ATOM   4105  CD1 LEU   231      24.246  13.082  49.410  1.00 23.15           C  
ATOM   4106  CD2 LEU   231      21.832  13.157  48.710  1.00 23.63           C  
ATOM   4107  N   ARG   232      21.337  15.976  53.385  1.00 16.86           N  
ATOM   4108  CA  ARG   232      20.785  16.081  54.751  1.00 16.31           C  
ATOM   4109  C   ARG   232      19.320  16.550  54.771  1.00 16.97           C  
ATOM   4110  O   ARG   232      18.589  16.323  55.751  1.00 17.68           O  
ATOM   4111  CB  ARG   232      21.646  17.007  55.623  1.00 16.64           C  
ATOM   4112  CG  ARG   232      22.983  16.372  55.992  1.00 15.91           C  
ATOM   4113  CD  ARG   232      23.720  17.173  57.071  1.00 19.79           C  
ATOM   4114  NE  ARG   232      24.352  18.393  56.570  1.00 23.02           N  
ATOM   4115  CZ  ARG   232      25.556  18.448  55.986  1.00 21.43           C  
ATOM   4116  NH1 ARG   232      26.259  17.357  55.778  1.00 19.90           N  
ATOM   4117  NH2 ARG   232      26.069  19.619  55.585  1.00 22.27           N  
ATOM   4118  N   GLN   233      18.872  17.197  53.692  1.00 16.78           N  
ATOM   4119  CA  GLN   233      17.515  17.772  53.654  1.00 16.70           C  
ATOM   4120  C   GLN   233      16.509  16.769  53.084  1.00 17.40           C  
ATOM   4121  O   GLN   233      15.302  16.987  53.175  1.00 17.53           O  
ATOM   4122  CB  GLN   233      17.544  19.086  52.865  1.00 16.26           C  
ATOM   4123  CG  GLN   233      18.484  20.089  53.532  1.00 18.25           C  
ATOM   4124  CD  GLN   233      18.564  21.390  52.741  1.00 16.52           C  
ATOM   4125  OE1 GLN   233      17.808  21.560  51.766  1.00 16.21           O  
ATOM   4126  NE2 GLN   233      19.449  22.330  53.164  1.00 17.95           N  
ATOM   4127  N   GLY   234      16.999  15.636  52.576  1.00 18.07           N  
ATOM   4128  CA  GLY   234      16.081  14.598  52.082  1.00 19.23           C  
ATOM   4129  C   GLY   234      16.537  14.015  50.739  1.00 20.20           C  
ATOM   4130  O   GLY   234      17.455  14.542  50.097  1.00 19.88           O  
ATOM   4131  N   PRO   235      15.882  12.928  50.300  1.00 19.79           N  
ATOM   4132  CA  PRO   235      16.357  12.178  49.138  1.00 19.94           C  
ATOM   4133  C   PRO   235      16.034  12.838  47.773  1.00 19.04           C  
ATOM   4134  O   PRO   235      16.710  12.546  46.777  1.00 18.70           O  
ATOM   4135  CB  PRO   235      15.624  10.842  49.286  1.00 20.89           C  
ATOM   4136  CG  PRO   235      14.297  11.224  49.910  1.00 20.96           C  
ATOM   4137  CD  PRO   235      14.661  12.343  50.892  1.00 20.52           C  
ATOM   4138  N   HIS   236      15.002  13.695  47.728  1.00 18.34           N  
ATOM   4139  CA  HIS   236      14.549  14.350  46.505  1.00 16.32           C  
ATOM   4140  C   HIS   236      13.955  15.723  46.776  1.00 16.53           C  
ATOM   4141  O   HIS   236      13.777  16.124  47.927  1.00 15.24           O  
ATOM   4142  CB  HIS   236      13.522  13.488  45.739  1.00 17.25           C  
ATOM   4143  CG  HIS   236      12.430  12.912  46.593  1.00 17.94           C  
ATOM   4144  ND1 HIS   236      11.535  13.682  47.301  1.00 16.85           N  
ATOM   4145  CD2 HIS   236      12.064  11.622  46.810  1.00 18.53           C  
ATOM   4146  CE1 HIS   236      10.669  12.899  47.921  1.00 17.14           C  
ATOM   4147  NE2 HIS   236      10.974  11.642  47.644  1.00 18.64           N  
ATOM   4148  N   ARG   237      13.647  16.456  45.710  1.00 15.58           N  
ATOM   4149  CA  ARG   237      13.294  17.854  45.887  1.00 14.98           C  
ATOM   4150  C   ARG   237      11.974  18.009  46.718  1.00 16.42           C  
ATOM   4151  O   ARG   237      11.827  18.954  47.480  1.00 16.16           O  
ATOM   4152  CB  ARG   237      13.141  18.522  44.547  1.00 14.36           C  
ATOM   4153  CG  ARG   237      14.451  18.618  43.757  1.00 13.17           C  
ATOM   4154  CD  ARG   237      14.304  19.568  42.566  1.00 18.44           C  
ATOM   4155  NE  ARG   237      15.515  19.582  41.726  1.00 16.78           N  
ATOM   4156  CZ  ARG   237      15.790  18.684  40.796  1.00 20.51           C  
ATOM   4157  NH1 ARG   237      14.939  17.681  40.577  1.00 17.61           N  
ATOM   4158  NH2 ARG   237      16.928  18.801  40.088  1.00 19.47           N  
ATOM   4159  N   TYR   238      11.027  17.117  46.484  1.00 15.77           N  
ATOM   4160  CA  TYR   238       9.744  17.140  47.145  1.00 17.21           C  
ATOM   4161  C   TYR   238       9.971  16.972  48.657  1.00 17.06           C  
ATOM   4162  O   TYR   238       9.396  17.713  49.428  1.00 16.81           O  
ATOM   4163  CB  TYR   238       8.798  16.084  46.542  1.00 18.92           C  
ATOM   4164  CG  TYR   238       7.457  16.045  47.209  1.00 19.30           C  
ATOM   4165  CD1 TYR   238       6.760  17.213  47.452  1.00 20.59           C  
ATOM   4166  CD2 TYR   238       6.907  14.837  47.657  1.00 22.40           C  
ATOM   4167  CE1 TYR   238       5.507  17.198  48.100  1.00 22.34           C  
ATOM   4168  CE2 TYR   238       5.620  14.809  48.308  1.00 21.95           C  
ATOM   4169  CZ  TYR   238       4.959  16.000  48.526  1.00 23.32           C  
ATOM   4170  OH  TYR   238       3.741  16.015  49.160  1.00 23.93           O  
ATOM   4171  N   ALA   239      10.827  16.032  49.076  1.00 15.72           N  
ATOM   4172  CA  ALA   239      11.125  15.907  50.527  1.00 16.87           C  
ATOM   4173  C   ALA   239      11.801  17.127  51.132  1.00 15.98           C  
ATOM   4174  O   ALA   239      11.479  17.539  52.257  1.00 16.83           O  
ATOM   4175  CB  ALA   239      11.906  14.639  50.843  1.00 15.76           C  
ATOM   4176  N   ARG   240      12.722  17.704  50.380  1.00 15.86           N  
ATOM   4177  CA  ARG   240      13.456  18.889  50.791  1.00 16.41           C  
ATOM   4178  C   ARG   240      12.537  20.074  51.016  1.00 15.88           C  
ATOM   4179  O   ARG   240      12.756  20.825  51.949  1.00 15.73           O  
ATOM   4180  CB  ARG   240      14.614  19.222  49.812  1.00 16.35           C  
ATOM   4181  CG  ARG   240      15.682  18.128  49.796  1.00 16.15           C  
ATOM   4182  CD  ARG   240      16.799  18.380  48.821  1.00 19.51           C  
ATOM   4183  NE  ARG   240      17.541  17.143  48.634  1.00 21.17           N  
ATOM   4184  CZ  ARG   240      18.513  16.959  47.725  1.00 30.62           C  
ATOM   4185  NH1 ARG   240      18.870  17.937  46.869  1.00 24.91           N  
ATOM   4186  NH2 ARG   240      19.174  15.792  47.673  1.00 24.61           N  
ATOM   4187  N   ALA   241      11.522  20.251  50.164  1.00 15.35           N  
ATOM   4188  CA  ALA   241      10.535  21.330  50.366  1.00 16.58           C  
ATOM   4189  C   ALA   241       9.795  21.186  51.709  1.00 17.54           C  
ATOM   4190  O   ALA   241       9.643  22.167  52.461  1.00 17.91           O  
ATOM   4191  CB  ALA   241       9.503  21.375  49.216  1.00 16.02           C  
ATOM   4192  N   ARG   242       9.322  19.988  52.042  0.50 18.15           N  
ATOM   4194  CA  ARG   242       8.663  19.824  53.351  0.50 18.26           C  
ATOM   4196  C   ARG   242       9.648  20.039  54.482  0.50 18.61           C  
ATOM   4198  O   ARG   242       9.278  20.617  55.518  0.50 18.57           O  
ATOM   4200  CB  ARG   242       8.018  18.450  53.533  0.50 19.13           C  
ATOM   4202  CG  ARG   242       6.759  18.262  52.755  0.50 21.80           C  
ATOM   4204  CD  ARG   242       5.977  17.038  53.263  0.50 25.23           C  
ATOM   4206  NE  ARG   242       4.900  16.776  52.323  0.50 28.81           N  
ATOM   4208  CZ  ARG   242       3.733  17.408  52.346  0.50 30.63           C  
ATOM   4210  NH1 ARG   242       3.481  18.320  53.274  0.50 31.56           N  
ATOM   4212  NH2 ARG   242       2.812  17.117  51.446  0.50 33.57           N  
ATOM   4214  N   HIS   243      10.879  19.542  54.308  1.00 18.81           N  
ATOM   4215  CA  HIS   243      11.951  19.694  55.337  1.00 17.94           C  
ATOM   4216  C   HIS   243      12.171  21.213  55.584  1.00 17.86           C  
ATOM   4217  O   HIS   243      12.281  21.663  56.720  1.00 17.25           O  
ATOM   4218  CB  HIS   243      13.260  19.043  54.834  1.00 17.91           C  
ATOM   4219  CG  HIS   243      14.436  19.179  55.754  1.00 21.33           C  
ATOM   4220  ND1 HIS   243      14.836  18.158  56.599  1.00 25.27           N  
ATOM   4221  CD2 HIS   243      15.339  20.185  55.924  1.00 20.89           C  
ATOM   4222  CE1 HIS   243      15.896  18.556  57.292  1.00 26.50           C  
ATOM   4223  NE2 HIS   243      16.228  19.775  56.893  1.00 25.24           N  
ATOM   4224  N   TYR   244      12.208  21.982  54.508  1.00 17.86           N  
ATOM   4225  CA  TYR   244      12.414  23.419  54.637  1.00 16.13           C  
ATOM   4226  C   TYR   244      11.256  24.121  55.368  1.00 15.54           C  
ATOM   4227  O   TYR   244      11.464  24.929  56.275  1.00 15.38           O  
ATOM   4228  CB  TYR   244      12.607  24.029  53.255  1.00 15.56           C  
ATOM   4229  CG  TYR   244      12.819  25.543  53.223  1.00 16.07           C  
ATOM   4230  CD1 TYR   244      13.964  26.128  53.796  1.00 15.03           C  
ATOM   4231  CD2 TYR   244      11.920  26.384  52.534  1.00 18.87           C  
ATOM   4232  CE1 TYR   244      14.213  27.543  53.695  1.00 17.13           C  
ATOM   4233  CE2 TYR   244      12.123  27.735  52.453  1.00 15.57           C  
ATOM   4234  CZ  TYR   244      13.303  28.311  53.027  1.00 17.78           C  
ATOM   4235  OH  TYR   244      13.563  29.658  52.939  1.00 18.09           O  
ATOM   4236  N   TYR   245      10.047  23.838  54.936  1.00 15.89           N  
ATOM   4237  CA  TYR   245       8.854  24.333  55.615  1.00 17.37           C  
ATOM   4238  C   TYR   245       8.874  24.018  57.104  1.00 17.57           C  
ATOM   4239  O   TYR   245       8.702  24.934  57.911  1.00 17.72           O  
ATOM   4240  CB  TYR   245       7.581  23.815  54.953  1.00 18.02           C  
ATOM   4241  CG  TYR   245       6.303  24.307  55.587  1.00 17.39           C  
ATOM   4242  CD1 TYR   245       5.844  25.618  55.376  1.00 19.89           C  
ATOM   4243  CD2 TYR   245       5.541  23.447  56.399  1.00 22.21           C  
ATOM   4244  CE1 TYR   245       4.648  26.067  55.980  1.00 20.10           C  
ATOM   4245  CE2 TYR   245       4.355  23.883  56.998  1.00 25.56           C  
ATOM   4246  CZ  TYR   245       3.922  25.201  56.778  1.00 23.46           C  
ATOM   4247  OH  TYR   245       2.745  25.636  57.363  1.00 22.98           O  
ATOM   4248  N   GLU   246       9.085  22.751  57.458  1.00 17.32           N  
ATOM   4249  CA  GLU   246       9.213  22.363  58.843  1.00 20.29           C  
ATOM   4250  C   GLU   246      10.308  23.122  59.583  1.00 18.49           C  
ATOM   4251  O   GLU   246      10.104  23.503  60.750  1.00 18.21           O  
ATOM   4252  CB  GLU   246       9.456  20.850  58.959  1.00 19.90           C  
ATOM   4253  CG  GLU   246       8.225  19.993  58.552  1.00 25.11           C  
ATOM   4254  CD  GLU   246       8.504  18.448  58.437  1.00 29.07           C  
ATOM   4255  OE1 GLU   246       9.605  17.981  58.828  1.00 38.06           O  
ATOM   4256  OE2 GLU   246       7.603  17.708  57.939  1.00 35.52           O  
ATOM   4257  N   ALA   247      11.479  23.315  58.934  1.00 15.82           N  
ATOM   4258  CA  ALA   247      12.572  24.020  59.562  1.00 17.29           C  
ATOM   4259  C   ALA   247      12.175  25.465  59.859  1.00 17.90           C  
ATOM   4260  O   ALA   247      12.547  26.007  60.918  1.00 17.77           O  
ATOM   4261  CB  ALA   247      13.846  23.982  58.638  1.00 16.01           C  
ATOM   4262  N   GLY   248      11.409  26.089  58.952  1.00 16.74           N  
ATOM   4263  CA  GLY   248      10.931  27.469  59.170  1.00 16.95           C  
ATOM   4264  C   GLY   248       9.949  27.536  60.344  1.00 17.73           C  
ATOM   4265  O   GLY   248      10.035  28.416  61.220  1.00 15.83           O  
ATOM   4266  N   GLN   249       9.009  26.598  60.388  1.00 18.37           N  
ATOM   4267  CA  GLN   249       8.014  26.560  61.476  1.00 18.83           C  
ATOM   4268  C   GLN   249       8.734  26.497  62.834  1.00 19.70           C  
ATOM   4269  O   GLN   249       8.415  27.244  63.773  1.00 19.09           O  
ATOM   4270  CB  GLN   249       7.189  25.290  61.367  1.00 19.80           C  
ATOM   4271  CG  GLN   249       6.137  25.240  60.335  1.00 24.51           C  
ATOM   4272  CD  GLN   249       5.318  23.977  60.539  1.00 31.75           C  
ATOM   4273  OE1 GLN   249       5.842  22.872  60.358  1.00 32.12           O  
ATOM   4274  NE2 GLN   249       4.060  24.124  60.993  1.00 32.25           N  
ATOM   4275  N   ARG   250       9.715  25.603  62.909  1.00 19.72           N  
ATOM   4276  CA  ARG   250      10.516  25.384  64.106  1.00 22.47           C  
ATOM   4277  C   ARG   250      11.353  26.626  64.488  1.00 20.28           C  
ATOM   4278  O   ARG   250      11.356  27.030  65.680  1.00 19.85           O  
ATOM   4279  CB  ARG   250      11.412  24.165  63.864  1.00 22.21           C  
ATOM   4280  CG  ARG   250      11.763  23.321  65.085  1.00 29.73           C  
ATOM   4281  CD  ARG   250      12.112  21.845  64.669  1.00 31.16           C  
ATOM   4282  NE  ARG   250      13.069  21.765  63.546  1.00 43.52           N  
ATOM   4283  CZ  ARG   250      12.829  21.165  62.369  1.00 45.43           C  
ATOM   4284  NH1 ARG   250      13.761  21.170  61.422  1.00 46.05           N  
ATOM   4285  NH2 ARG   250      11.668  20.547  62.142  1.00 47.86           N  
ATOM   4286  N   ALA   251      12.064  27.219  63.512  1.00 17.94           N  
ATOM   4287  CA  ALA   251      12.861  28.451  63.770  1.00 16.59           C  
ATOM   4288  C   ALA   251      11.976  29.582  64.307  1.00 16.67           C  
ATOM   4289  O   ALA   251      12.398  30.314  65.205  1.00 15.87           O  
ATOM   4290  CB  ALA   251      13.665  28.914  62.489  1.00 15.49           C  
ATOM   4291  N   ALA   252      10.783  29.777  63.722  1.00 15.46           N  
ATOM   4292  CA  ALA   252       9.862  30.773  64.243  1.00 16.55           C  
ATOM   4293  C   ALA   252       9.317  30.417  65.639  1.00 16.60           C  
ATOM   4294  O   ALA   252       9.270  31.287  66.510  1.00 16.76           O  
ATOM   4295  CB  ALA   252       8.703  31.076  63.212  1.00 15.36           C  
ATOM   4296  N   ALA   253       8.950  29.149  65.864  1.00 16.05           N  
ATOM   4297  CA  ALA   253       8.402  28.726  67.162  1.00 17.20           C  
ATOM   4298  C   ALA   253       9.442  28.897  68.251  1.00 17.71           C  
ATOM   4299  O   ALA   253       9.097  29.296  69.356  1.00 18.27           O  
ATOM   4300  CB  ALA   253       7.957  27.290  67.140  1.00 17.74           C  
ATOM   4301  N   GLN   254      10.709  28.611  67.953  1.00 17.60           N  
ATOM   4302  CA  GLN   254      11.696  28.688  69.021  1.00 18.87           C  
ATOM   4303  C   GLN   254      12.046  30.119  69.428  1.00 18.15           C  
ATOM   4304  O   GLN   254      12.581  30.348  70.544  1.00 18.76           O  
ATOM   4305  CB  GLN   254      12.915  27.772  68.787  1.00 18.72           C  
ATOM   4306  CG  GLN   254      13.684  27.968  67.577  1.00 24.64           C  
ATOM   4307  CD  GLN   254      14.321  26.625  67.066  1.00 24.52           C  
ATOM   4308  OE1 GLN   254      15.207  26.689  66.307  1.00 29.21           O  
ATOM   4309  NE2 GLN   254      13.817  25.458  67.480  1.00 30.44           N  
ATOM   4310  N   ARG   255      11.726  31.062  68.550  1.00 16.31           N  
ATOM   4311  CA  ARG   255      11.918  32.514  68.812  1.00 16.40           C  
ATOM   4312  C   ARG   255      10.649  33.279  69.175  1.00 17.67           C  
ATOM   4313  O   ARG   255      10.724  34.516  69.405  1.00 16.99           O  
ATOM   4314  CB  ARG   255      12.550  33.189  67.605  1.00 16.92           C  
ATOM   4315  CG  ARG   255      13.920  32.603  67.238  1.00 15.42           C  
ATOM   4316  CD  ARG   255      14.402  33.194  65.902  1.00 15.96           C  
ATOM   4317  NE  ARG   255      15.811  32.824  65.594  1.00 18.87           N  
ATOM   4318  CZ  ARG   255      16.217  31.607  65.242  1.00 16.47           C  
ATOM   4319  NH1 ARG   255      15.366  30.605  65.160  1.00 16.31           N  
ATOM   4320  NH2 ARG   255      17.514  31.396  64.961  1.00 18.75           N  
ATOM   4321  N   GLY   256       9.511  32.568  69.235  1.00 17.35           N  
ATOM   4322  CA  GLY   256       8.212  33.174  69.486  1.00 18.60           C  
ATOM   4323  C   GLY   256       7.821  34.164  68.397  1.00 19.60           C  
ATOM   4324  O   GLY   256       7.165  35.159  68.685  1.00 20.56           O  
ATOM   4325  N   LEU   257       8.253  33.927  67.157  1.00 19.54           N  
ATOM   4326  CA  LEU   257       8.070  34.912  66.053  1.00 20.52           C  
ATOM   4327  C   LEU   257       6.920  34.527  65.141  1.00 20.48           C  
ATOM   4328  O   LEU   257       6.599  33.345  65.057  1.00 21.09           O  
ATOM   4329  CB  LEU   257       9.332  35.000  65.170  1.00 20.75           C  
ATOM   4330  CG  LEU   257      10.569  35.722  65.654  1.00 22.41           C  
ATOM   4331  CD1 LEU   257      11.681  35.291  64.734  1.00 24.15           C  
ATOM   4332  CD2 LEU   257      10.377  37.262  65.695  1.00 26.74           C  
ATOM   4333  N   PRO   258       6.284  35.522  64.476  1.00 19.99           N  
ATOM   4334  CA  PRO   258       5.247  35.126  63.496  1.00 20.94           C  
ATOM   4335  C   PRO   258       5.840  34.395  62.281  1.00 20.22           C  
ATOM   4336  O   PRO   258       6.971  34.674  61.866  1.00 21.14           O  
ATOM   4337  CB  PRO   258       4.589  36.448  63.086  1.00 21.45           C  
ATOM   4338  CG  PRO   258       5.463  37.533  63.550  1.00 21.26           C  
ATOM   4339  CD  PRO   258       6.400  36.985  64.631  1.00 20.61           C  
ATOM   4340  N   PHE   259       5.090  33.438  61.750  1.00 19.24           N  
ATOM   4341  CA  PHE   259       5.532  32.562  60.666  1.00 18.75           C  
ATOM   4342  C   PHE   259       4.540  32.641  59.479  1.00 18.24           C  
ATOM   4343  O   PHE   259       3.390  32.229  59.612  1.00 17.86           O  
ATOM   4344  CB  PHE   259       5.614  31.132  61.167  1.00 18.38           C  
ATOM   4345  CG  PHE   259       6.050  30.146  60.140  1.00 18.90           C  
ATOM   4346  CD1 PHE   259       5.217  29.084  59.792  1.00 18.30           C  
ATOM   4347  CD2 PHE   259       7.340  30.215  59.565  1.00 17.54           C  
ATOM   4348  CE1 PHE   259       5.613  28.158  58.819  1.00 18.48           C  
ATOM   4349  CE2 PHE   259       7.754  29.266  58.585  1.00 19.91           C  
ATOM   4350  CZ  PHE   259       6.912  28.255  58.213  1.00 19.41           C  
ATOM   4351  N   GLY   260       4.999  33.145  58.343  1.00 18.00           N  
ATOM   4352  CA  GLY   260       4.095  33.443  57.224  1.00 19.58           C  
ATOM   4353  C   GLY   260       4.113  32.426  56.090  1.00 19.65           C  
ATOM   4354  O   GLY   260       3.228  32.470  55.210  1.00 19.72           O  
ATOM   4355  N   TRP   261       5.118  31.542  56.065  1.00 18.16           N  
ATOM   4356  CA  TRP   261       5.273  30.658  54.890  1.00 19.88           C  
ATOM   4357  C   TRP   261       4.097  29.723  54.696  1.00 20.84           C  
ATOM   4358  O   TRP   261       3.413  29.331  55.655  1.00 19.26           O  
ATOM   4359  CB  TRP   261       6.523  29.777  54.984  1.00 19.09           C  
ATOM   4360  CG  TRP   261       7.837  30.482  55.187  1.00 17.49           C  
ATOM   4361  CD1 TRP   261       8.083  31.861  55.201  1.00 14.58           C  
ATOM   4362  CD2 TRP   261       9.093  29.850  55.402  1.00 14.51           C  
ATOM   4363  NE1 TRP   261       9.436  32.089  55.434  1.00 16.98           N  
ATOM   4364  CE2 TRP   261      10.071  30.882  55.563  1.00 16.39           C  
ATOM   4365  CE3 TRP   261       9.506  28.495  55.502  1.00 15.10           C  
ATOM   4366  CZ2 TRP   261      11.419  30.603  55.804  1.00 17.44           C  
ATOM   4367  CZ3 TRP   261      10.881  28.236  55.718  1.00 15.52           C  
ATOM   4368  CH2 TRP   261      11.790  29.265  55.891  1.00 17.43           C  
ATOM   4369  N   GLN   262       3.889  29.344  53.441  1.00 21.54           N  
ATOM   4370  CA  GLN   262       2.924  28.314  53.113  1.00 23.33           C  
ATOM   4371  C   GLN   262       3.555  27.293  52.190  1.00 22.08           C  
ATOM   4372  O   GLN   262       4.241  27.654  51.221  1.00 22.36           O  
ATOM   4373  CB  GLN   262       1.719  28.934  52.429  1.00 25.55           C  
ATOM   4374  CG  GLN   262       1.312  30.264  53.098  1.00 32.79           C  
ATOM   4375  CD  GLN   262      -0.066  30.727  52.706  1.00 44.25           C  
ATOM   4376  OE1 GLN   262      -0.274  31.242  51.581  1.00 47.57           O  
ATOM   4377  NE2 GLN   262      -1.043  30.546  53.626  1.00 46.76           N  
ATOM   4378  N   LEU   263       3.302  26.030  52.496  1.00 20.61           N  
ATOM   4379  CA  LEU   263       3.675  24.926  51.657  1.00 19.73           C  
ATOM   4380  C   LEU   263       2.475  24.545  50.762  1.00 19.55           C  
ATOM   4381  O   LEU   263       1.449  24.130  51.260  1.00 19.63           O  
ATOM   4382  CB  LEU   263       4.095  23.727  52.522  1.00 19.16           C  
ATOM   4383  CG  LEU   263       4.544  22.532  51.686  1.00 21.56           C  
ATOM   4384  CD1 LEU   263       5.796  22.875  50.813  1.00 20.17           C  
ATOM   4385  CD2 LEU   263       4.813  21.361  52.553  1.00 24.30           C  
ATOM   4386  N   GLN   264       2.614  24.737  49.450  1.00 18.57           N  
ATOM   4387  CA  GLN   264       1.589  24.317  48.490  1.00 18.23           C  
ATOM   4388  C   GLN   264       2.095  23.177  47.634  1.00 18.10           C  
ATOM   4389  O   GLN   264       3.012  23.344  46.810  1.00 18.10           O  
ATOM   4390  CB  GLN   264       1.209  25.504  47.628  1.00 18.30           C  
ATOM   4391  CG  GLN   264       0.184  25.172  46.584  1.00 17.10           C  
ATOM   4392  CD  GLN   264      -1.145  24.908  47.189  1.00 24.27           C  
ATOM   4393  OE1 GLN   264      -1.829  25.852  47.602  1.00 23.29           O  
ATOM   4394  NE2 GLN   264      -1.559  23.621  47.232  1.00 24.34           N  
ATOM   4395  N   VAL   265       1.575  21.989  47.895  1.00 18.37           N  
ATOM   4396  CA  VAL   265       1.898  20.819  47.124  1.00 19.35           C  
ATOM   4397  C   VAL   265       1.046  20.817  45.868  1.00 19.58           C  
ATOM   4398  O   VAL   265      -0.193  21.103  45.902  1.00 18.78           O  
ATOM   4399  CB  VAL   265       1.638  19.522  47.957  1.00 19.65           C  
ATOM   4400  CG1 VAL   265       1.891  18.216  47.122  1.00 22.31           C  
ATOM   4401  CG2 VAL   265       2.460  19.552  49.250  1.00 19.92           C  
ATOM   4402  N   VAL   266       1.694  20.436  44.772  1.00 19.25           N  
ATOM   4403  CA  VAL   266       1.024  20.368  43.478  1.00 18.98           C  
ATOM   4404  C   VAL   266       0.911  18.903  43.067  1.00 20.77           C  
ATOM   4405  O   VAL   266       1.892  18.284  42.707  1.00 20.21           O  
ATOM   4406  CB  VAL   266       1.810  21.121  42.387  1.00 19.05           C  
ATOM   4407  CG1 VAL   266       0.976  21.158  41.082  1.00 17.85           C  
ATOM   4408  CG2 VAL   266       2.212  22.517  42.864  1.00 18.57           C  
ATOM   4409  N   PRO   267      -0.315  18.359  43.103  1.00 22.10           N  
ATOM   4410  CA  PRO   267      -0.465  16.913  42.897  1.00 22.93           C  
ATOM   4411  C   PRO   267      -0.215  16.529  41.427  1.00 23.21           C  
ATOM   4412  O   PRO   267      -0.681  17.224  40.527  1.00 23.86           O  
ATOM   4413  CB  PRO   267      -1.917  16.649  43.370  1.00 24.15           C  
ATOM   4414  CG  PRO   267      -2.646  17.994  43.120  1.00 24.08           C  
ATOM   4415  CD  PRO   267      -1.592  19.058  43.371  1.00 22.39           C  
ATOM   4416  N   GLY   268       0.525  15.441  41.201  1.00 24.16           N  
ATOM   4417  CA  GLY   268       0.776  14.906  39.871  1.00 23.27           C  
ATOM   4418  C   GLY   268       1.814  15.611  38.994  1.00 23.85           C  
ATOM   4419  O   GLY   268       2.058  15.168  37.877  1.00 24.20           O  
ATOM   4420  N   ILE   269       2.449  16.687  39.466  1.00 21.71           N  
ATOM   4421  CA  ILE   269       3.386  17.428  38.636  1.00 21.36           C  
ATOM   4422  C   ILE   269       4.768  17.201  39.229  1.00 21.44           C  
ATOM   4423  O   ILE   269       4.908  17.143  40.447  1.00 21.59           O  
ATOM   4424  CB  ILE   269       3.073  18.994  38.619  1.00 21.43           C  
ATOM   4425  CG1 ILE   269       1.696  19.318  37.967  1.00 22.02           C  
ATOM   4426  CG2 ILE   269       4.168  19.767  37.906  1.00 22.30           C  
ATOM   4427  CD1 ILE   269       1.655  19.090  36.385  1.00 18.14           C  
ATOM   4428  N   GLY   270       5.785  17.068  38.391  1.00 21.30           N  
ATOM   4429  CA  GLY   270       7.148  16.841  38.893  1.00 21.67           C  
ATOM   4430  C   GLY   270       8.033  18.038  38.617  1.00 21.68           C  
ATOM   4431  O   GLY   270       7.633  19.184  38.851  1.00 20.78           O  
ATOM   4432  N   HIS   271       9.228  17.774  38.087  1.00 22.25           N  
ATOM   4433  CA  HIS   271      10.216  18.844  37.922  1.00 22.02           C  
ATOM   4434  C   HIS   271      10.016  19.477  36.549  1.00 22.71           C  
ATOM   4435  O   HIS   271      10.759  19.163  35.612  1.00 23.35           O  
ATOM   4436  CB  HIS   271      11.625  18.303  38.057  1.00 21.35           C  
ATOM   4437  CG  HIS   271      12.648  19.356  38.323  1.00 21.39           C  
ATOM   4438  ND1 HIS   271      12.698  20.045  39.515  1.00 21.88           N  
ATOM   4439  CD2 HIS   271      13.648  19.852  37.554  1.00 23.34           C  
ATOM   4440  CE1 HIS   271      13.681  20.927  39.470  1.00 22.63           C  
ATOM   4441  NE2 HIS   271      14.279  20.825  38.296  1.00 20.26           N  
ATOM   4442  N   ASP   272       9.030  20.364  36.443  1.00 21.83           N  
ATOM   4443  CA  ASP   272       8.558  20.877  35.151  1.00 21.22           C  
ATOM   4444  C   ASP   272       8.283  22.372  35.336  1.00 20.47           C  
ATOM   4445  O   ASP   272       7.209  22.756  35.852  1.00 19.09           O  
ATOM   4446  CB  ASP   272       7.293  20.078  34.850  1.00 22.23           C  
ATOM   4447  CG  ASP   272       6.605  20.419  33.530  1.00 26.87           C  
ATOM   4448  OD1 ASP   272       5.784  19.544  33.123  1.00 35.17           O  
ATOM   4449  OD2 ASP   272       6.794  21.492  32.929  1.00 26.24           O  
ATOM   4450  N   GLY   273       9.249  23.201  34.924  1.00 18.53           N  
ATOM   4451  CA  GLY   273       9.231  24.643  35.136  1.00 18.73           C  
ATOM   4452  C   GLY   273       8.026  25.302  34.458  1.00 18.64           C  
ATOM   4453  O   GLY   273       7.472  26.302  34.972  1.00 18.10           O  
ATOM   4454  N   GLN   274       7.639  24.779  33.293  1.00 17.74           N  
ATOM   4455  CA  GLN   274       6.525  25.357  32.570  1.00 18.66           C  
ATOM   4456  C   GLN   274       5.221  25.115  33.320  1.00 17.89           C  
ATOM   4457  O   GLN   274       4.431  26.042  33.471  1.00 18.67           O  
ATOM   4458  CB  GLN   274       6.388  24.822  31.130  1.00 19.82           C  
ATOM   4459  CG  GLN   274       5.197  25.439  30.436  1.00 21.92           C  
ATOM   4460  CD  GLN   274       5.227  25.219  28.984  1.00 29.89           C  
ATOM   4461  OE1 GLN   274       5.995  24.395  28.507  1.00 30.96           O  
ATOM   4462  NE2 GLN   274       4.389  25.964  28.235  1.00 32.75           N  
ATOM   4463  N   ALA   275       4.993  23.866  33.737  1.00 16.59           N  
ATOM   4464  CA  ALA   275       3.790  23.501  34.487  1.00 16.47           C  
ATOM   4465  C   ALA   275       3.765  24.305  35.797  1.00 16.81           C  
ATOM   4466  O   ALA   275       2.733  24.897  36.172  1.00 16.84           O  
ATOM   4467  CB  ALA   275       3.801  21.957  34.752  1.00 16.58           C  
ATOM   4468  N   MET   276       4.903  24.397  36.475  1.00 14.32           N  
ATOM   4469  CA  MET   276       4.934  25.101  37.780  1.00 16.77           C  
ATOM   4470  C   MET   276       4.641  26.598  37.618  1.00 16.52           C  
ATOM   4471  O   MET   276       3.995  27.210  38.513  1.00 16.68           O  
ATOM   4472  CB  MET   276       6.282  24.908  38.478  1.00 16.00           C  
ATOM   4473  CG  MET   276       6.503  23.403  38.873  1.00 19.31           C  
ATOM   4474  SD  MET   276       5.244  22.585  40.225  0.85 31.00          SE  
ATOM   4475  CE  MET   276       5.865  23.661  41.695  1.00 21.87           C  
ATOM   4476  N   SER   277       5.137  27.161  36.507  1.00 14.94           N  
ATOM   4477  CA  SER   277       4.904  28.588  36.158  1.00 15.92           C  
ATOM   4478  C   SER   277       3.388  28.742  35.970  1.00 16.26           C  
ATOM   4479  O   SER   277       2.783  29.667  36.505  1.00 15.83           O  
ATOM   4480  CB  SER   277       5.640  28.963  34.840  1.00 16.52           C  
ATOM   4481  OG  SER   277       7.061  29.013  35.014  1.00 16.03           O  
ATOM   4482  N   GLN   278       2.749  27.790  35.278  1.00 15.04           N  
ATOM   4483  CA  GLN   278       1.339  27.943  35.014  1.00 15.53           C  
ATOM   4484  C   GLN   278       0.488  27.766  36.290  1.00 15.33           C  
ATOM   4485  O   GLN   278      -0.531  28.439  36.442  1.00 14.68           O  
ATOM   4486  CB  GLN   278       0.894  26.988  33.910  1.00 17.39           C  
ATOM   4487  CG  GLN   278       1.518  27.364  32.547  1.00 21.62           C  
ATOM   4488  CD  GLN   278       1.139  26.294  31.531  1.00 33.26           C  
ATOM   4489  OE1 GLN   278       0.181  26.449  30.779  1.00 38.10           O  
ATOM   4490  NE2 GLN   278       1.830  25.152  31.586  1.00 34.50           N  
ATOM   4491  N   VAL   279       0.888  26.830  37.146  1.00 14.82           N  
ATOM   4492  CA  VAL   279       0.233  26.643  38.430  1.00 16.81           C  
ATOM   4493  C   VAL   279       0.392  27.898  39.295  1.00 16.60           C  
ATOM   4494  O   VAL   279      -0.566  28.356  39.935  1.00 16.69           O  
ATOM   4495  CB  VAL   279       0.811  25.416  39.169  1.00 17.82           C  
ATOM   4496  CG1 VAL   279       0.367  25.415  40.639  1.00 19.21           C  
ATOM   4497  CG2 VAL   279       0.441  24.115  38.387  1.00 15.55           C  
ATOM   4498  N   CYS   280       1.601  28.457  39.323  1.00 17.19           N  
ATOM   4499  CA  CYS   280       1.856  29.665  40.085  1.00 17.19           C  
ATOM   4500  C   CYS   280       0.996  30.848  39.614  1.00 17.29           C  
ATOM   4501  O   CYS   280       0.412  31.558  40.446  1.00 17.66           O  
ATOM   4502  CB  CYS   280       3.341  30.038  40.037  1.00 17.06           C  
ATOM   4503  SG  CYS   280       3.712  31.314  41.250  1.00 20.50           S  
ATOM   4504  N   ALA   281       0.875  31.022  38.302  1.00 15.71           N  
ATOM   4505  CA  ALA   281       0.006  32.086  37.770  1.00 15.73           C  
ATOM   4506  C   ALA   281      -1.458  31.892  38.155  1.00 14.68           C  
ATOM   4507  O   ALA   281      -2.152  32.884  38.389  1.00 16.04           O  
ATOM   4508  CB  ALA   281       0.128  32.212  36.220  1.00 14.80           C  
ATOM   4509  N   SER   282      -1.927  30.639  38.126  1.00 14.48           N  
ATOM   4510  CA  SER   282      -3.268  30.285  38.544  1.00 17.21           C  
ATOM   4511  C   SER   282      -3.523  30.692  40.000  1.00 16.66           C  
ATOM   4512  O   SER   282      -4.562  31.304  40.321  1.00 17.67           O  
ATOM   4513  CB  SER   282      -3.525  28.769  38.327  1.00 15.72           C  
ATOM   4514  OG  SER   282      -4.894  28.436  38.606  1.00 18.69           O  
ATOM   4515  N   LEU   283      -2.602  30.308  40.891  1.00 16.30           N  
ATOM   4516  CA  LEU   283      -2.751  30.581  42.293  1.00 15.14           C  
ATOM   4517  C   LEU   283      -2.763  32.095  42.538  1.00 16.22           C  
ATOM   4518  O   LEU   283      -3.558  32.575  43.307  1.00 17.17           O  
ATOM   4519  CB  LEU   283      -1.592  29.915  43.074  1.00 15.02           C  
ATOM   4520  CG  LEU   283      -1.733  28.360  43.162  1.00 12.50           C  
ATOM   4521  CD1 LEU   283      -0.346  27.840  43.671  1.00 14.22           C  
ATOM   4522  CD2 LEU   283      -2.888  27.902  44.062  1.00 17.65           C  
ATOM   4523  N   TRP   284      -1.881  32.826  41.887  1.00 15.92           N  
ATOM   4524  CA  TRP   284      -1.746  34.273  42.143  1.00 15.83           C  
ATOM   4525  C   TRP   284      -2.861  35.083  41.468  1.00 16.40           C  
ATOM   4526  O   TRP   284      -3.366  36.050  42.030  1.00 16.45           O  
ATOM   4527  CB  TRP   284      -0.437  34.778  41.569  1.00 15.69           C  
ATOM   4528  CG  TRP   284       0.744  34.577  42.444  1.00 16.95           C  
ATOM   4529  CD1 TRP   284       0.759  34.350  43.820  1.00 15.86           C  
ATOM   4530  CD2 TRP   284       2.126  34.640  42.020  1.00 17.12           C  
ATOM   4531  NE1 TRP   284       2.089  34.257  44.248  1.00 17.51           N  
ATOM   4532  CE2 TRP   284       2.931  34.431  43.183  1.00 15.14           C  
ATOM   4533  CE3 TRP   284       2.756  34.863  40.776  1.00 17.57           C  
ATOM   4534  CZ2 TRP   284       4.338  34.450  43.142  1.00 16.55           C  
ATOM   4535  CZ3 TRP   284       4.177  34.848  40.723  1.00 18.62           C  
ATOM   4536  CH2 TRP   284       4.942  34.639  41.916  1.00 18.07           C  
ATOM   4537  N   PHE   285      -3.230  34.719  40.248  1.00 15.90           N  
ATOM   4538  CA  PHE   285      -4.110  35.603  39.473  1.00 16.74           C  
ATOM   4539  C   PHE   285      -5.492  35.084  39.265  1.00 19.07           C  
ATOM   4540  O   PHE   285      -6.356  35.874  38.949  1.00 20.01           O  
ATOM   4541  CB  PHE   285      -3.428  36.020  38.143  1.00 16.96           C  
ATOM   4542  CG  PHE   285      -2.105  36.726  38.398  1.00 17.60           C  
ATOM   4543  CD1 PHE   285      -2.085  37.925  39.097  1.00 14.59           C  
ATOM   4544  CD2 PHE   285      -0.899  36.118  38.065  1.00 18.19           C  
ATOM   4545  CE1 PHE   285      -0.881  38.533  39.412  1.00 16.28           C  
ATOM   4546  CE2 PHE   285       0.290  36.691  38.386  1.00 18.13           C  
ATOM   4547  CZ  PHE   285       0.321  37.899  39.037  1.00 15.43           C  
ATOM   4548  N   ASP   286      -5.673  33.762  39.338  1.00 19.79           N  
ATOM   4549  CA  ASP   286      -7.002  33.162  39.266  1.00 21.25           C  
ATOM   4550  C   ASP   286      -7.507  32.699  40.653  1.00 21.62           C  
ATOM   4551  O   ASP   286      -8.615  32.193  40.749  1.00 23.54           O  
ATOM   4552  CB  ASP   286      -7.025  31.972  38.303  1.00 22.47           C  
ATOM   4553  CG  ASP   286      -6.963  32.378  36.851  1.00 25.47           C  
ATOM   4554  OD1 ASP   286      -7.339  33.540  36.533  1.00 27.65           O  
ATOM   4555  OD2 ASP   286      -6.626  31.480  36.018  1.00 26.19           O  
ATOM   4556  N   GLY   287      -6.682  32.816  41.694  1.00 21.25           N  
ATOM   4557  CA  GLY   287      -7.070  32.459  43.049  1.00 20.57           C  
ATOM   4558  C   GLY   287      -7.384  30.984  43.188  1.00 20.82           C  
ATOM   4559  O   GLY   287      -8.246  30.611  43.987  1.00 20.75           O  
ATOM   4560  N   ARG   288      -6.751  30.141  42.380  1.00 18.82           N  
ATOM   4561  CA  ARG   288      -7.081  28.719  42.454  1.00 19.82           C  
ATOM   4562  C   ARG   288      -5.955  27.793  42.040  1.00 20.75           C  
ATOM   4563  O   ARG   288      -5.107  28.151  41.224  1.00 20.22           O  
ATOM   4564  CB  ARG   288      -8.326  28.408  41.604  1.00 20.16           C  
ATOM   4565  CG  ARG   288      -8.131  28.679  40.130  1.00 19.08           C  
ATOM   4566  CD  ARG   288      -9.454  28.727  39.388  1.00 20.63           C  
ATOM   4567  NE  ARG   288     -10.093  27.411  39.353  1.00 19.01           N  
ATOM   4568  CZ  ARG   288      -9.926  26.484  38.413  1.00 22.24           C  
ATOM   4569  NH1 ARG   288      -9.129  26.694  37.367  1.00 21.51           N  
ATOM   4570  NH2 ARG   288     -10.570  25.324  38.522  1.00 20.05           N  
ATOM   4571  N   MET   289      -5.985  26.581  42.591  1.00 22.14           N  
ATOM   4572  CA  MET   289      -5.220  25.458  42.054  1.00 24.77           C  
ATOM   4573  C   MET   289      -5.985  24.918  40.841  1.00 26.44           C  
ATOM   4574  O   MET   289      -7.220  24.760  40.904  1.00 27.16           O  
ATOM   4575  CB  MET   289      -5.070  24.397  43.140  1.00 24.65           C  
ATOM   4576  CG  MET   289      -4.390  23.121  42.712  1.00 30.28           C  
ATOM   4577  SD  MET   289      -2.396  23.387  42.481  0.85 41.99          SE  
ATOM   4578  CE  MET   289      -2.190  24.704  43.750  1.00 21.97           C  
ATOM   4579  N   PRO   290      -5.295  24.649  39.708  1.00 27.61           N  
ATOM   4580  CA  PRO   290      -6.063  24.044  38.604  1.00 29.06           C  
ATOM   4581  C   PRO   290      -6.669  22.674  38.965  1.00 31.38           C  
ATOM   4582  O   PRO   290      -6.206  22.029  39.912  1.00 31.31           O  
ATOM   4583  CB  PRO   290      -5.026  23.888  37.483  1.00 28.36           C  
ATOM   4584  CG  PRO   290      -3.940  24.820  37.816  1.00 27.94           C  
ATOM   4585  CD  PRO   290      -3.894  24.873  39.330  1.00 27.62           C  
ATOM   4586  N   ASP   291      -7.715  22.278  38.216  1.00 34.04           N  
ATOM   4587  CA  ASP   291      -8.363  20.947  38.249  1.00 36.26           C  
ATOM   4588  C   ASP   291      -7.370  19.827  38.137  1.00 36.35           C  
ATOM   4589  O   ASP   291      -6.327  20.002  37.507  1.00 36.06           O  
ATOM   4590  CB  ASP   291      -9.211  20.746  36.974  1.00 37.59           C  
ATOM   4591  CG  ASP   291     -10.616  21.234  37.109  1.00 41.99           C  
ATOM   4592  OD1 ASP   291     -11.535  20.385  37.030  1.00 46.72           O  
ATOM   4593  OD2 ASP   291     -10.804  22.464  37.259  1.00 46.76           O  
ATOM   4594  N   ALA   292      -7.761  18.639  38.611  1.00 36.56           N  
ATOM   4595  CA  ALA   292      -7.007  17.430  38.318  1.00 36.31           C  
ATOM   4596  C   ALA   292      -6.838  17.295  36.809  1.00 36.08           C  
ATOM   4597  O   ALA   292      -5.730  17.096  36.317  1.00 36.48           O  
ATOM   4598  CB  ALA   292      -7.700  16.185  38.924  1.00 36.91           C  
ATOM   4599  N   ALA   293      -7.932  17.462  36.072  1.00 36.30           N  
ATOM   4600  CA  ALA   293      -7.899  17.408  34.608  1.00 35.86           C  
ATOM   4601  C   ALA   293      -6.937  18.420  33.974  1.00 35.74           C  
ATOM   4602  O   ALA   293      -6.156  18.066  33.087  1.00 34.53           O  
ATOM   4603  CB  ALA   293      -9.318  17.574  34.048  1.00 36.27           C  
ATOM   4604  N   GLU   294      -7.013  19.675  34.438  1.00 36.23           N  
ATOM   4605  CA  GLU   294      -6.156  20.762  33.973  1.00 37.52           C  
ATOM   4606  C   GLU   294      -4.688  20.404  34.258  1.00 37.42           C  
ATOM   4607  O   GLU   294      -3.823  20.592  33.402  1.00 37.51           O  
ATOM   4608  CB  GLU   294      -6.542  22.105  34.638  1.00 37.09           C  
ATOM   4609  CG  GLU   294      -8.049  22.540  34.451  1.00 38.63           C  
ATOM   4610  CD  GLU   294      -8.426  23.909  35.131  1.00 39.49           C  
ATOM   4611  OE1 GLU   294      -8.894  24.835  34.430  1.00 41.64           O  
ATOM   4612  OE2 GLU   294      -8.284  24.061  36.360  1.00 40.20           O  
ATOM   4613  N   LEU   295      -4.435  19.877  35.458  1.00 37.78           N  
ATOM   4614  CA  LEU   295      -3.093  19.483  35.893  1.00 39.27           C  
ATOM   4615  C   LEU   295      -2.564  18.339  35.041  1.00 40.76           C  
ATOM   4616  O   LEU   295      -1.433  18.416  34.540  1.00 41.22           O  
ATOM   4617  CB  LEU   295      -3.060  19.115  37.391  1.00 38.74           C  
ATOM   4618  CG  LEU   295      -3.186  20.244  38.418  1.00 36.34           C  
ATOM   4619  CD1 LEU   295      -3.340  19.706  39.828  1.00 33.37           C  
ATOM   4620  CD2 LEU   295      -1.996  21.184  38.370  1.00 35.34           C  
ATOM   4621  N   ALA   296      -3.387  17.303  34.847  1.00 42.57           N  
ATOM   4622  CA  ALA   296      -3.052  16.208  33.925  1.00 44.42           C  
ATOM   4623  C   ALA   296      -2.591  16.734  32.557  1.00 46.06           C  
ATOM   4624  O   ALA   296      -1.605  16.238  32.001  1.00 46.62           O  
ATOM   4625  CB  ALA   296      -4.219  15.259  33.782  1.00 44.78           C  
ATOM   4626  N   ARG   297      -3.274  17.763  32.049  1.00 47.68           N  
ATOM   4627  CA  ARG   297      -2.892  18.426  30.797  1.00 49.66           C  
ATOM   4628  C   ARG   297      -1.522  19.075  30.849  1.00 50.66           C  
ATOM   4629  O   ARG   297      -0.733  18.877  29.920  1.00 51.26           O  
ATOM   4630  CB  ARG   297      -3.938  19.448  30.342  1.00 49.86           C  
ATOM   4631  CG  ARG   297      -5.264  18.817  29.995  1.00 52.61           C  
ATOM   4632  CD  ARG   297      -5.956  19.524  28.840  1.00 58.46           C  
ATOM   4633  NE  ARG   297      -7.046  18.694  28.311  1.00 62.25           N  
ATOM   4634  CZ  ARG   297      -6.949  17.876  27.257  1.00 64.16           C  
ATOM   4635  NH1 ARG   297      -5.802  17.767  26.575  1.00 64.59           N  
ATOM   4636  NH2 ARG   297      -8.010  17.163  26.880  1.00 64.19           N  
ATOM   4637  N   LEU   298      -1.245  19.858  31.908  1.00 51.24           N  
ATOM   4638  CA  LEU   298       0.059  20.536  32.075  1.00 51.64           C  
ATOM   4639  C   LEU   298       1.214  19.540  32.249  1.00 52.33           C  
ATOM   4640  O   LEU   298       2.362  19.849  31.900  1.00 53.01           O  
ATOM   4641  CB  LEU   298       0.057  21.487  33.278  1.00 51.25           C  
ATOM   4642  CG  LEU   298      -0.973  22.591  33.489  1.00 50.88           C  
ATOM   4643  CD1 LEU   298      -0.803  23.183  34.873  1.00 50.25           C  
ATOM   4644  CD2 LEU   298      -0.845  23.662  32.454  1.00 51.97           C  
ATOM   4645  N   ALA   299       0.910  18.368  32.807  1.00 52.88           N  
ATOM   4646  CA  ALA   299       1.887  17.301  33.016  1.00 53.52           C  
ATOM   4647  C   ALA   299       2.443  16.783  31.685  1.00 54.48           C  
ATOM   4648  O   ALA   299       3.175  17.491  30.977  1.00 55.19           O  
ATOM   4649  CB  ALA   299       1.258  16.159  33.799  1.00 53.01           C  
END
