
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   65 (  983),  selected   65 , name 1v66_A
# Molecule2: number of CA atoms   70 (  594),  selected   70 , name T0416_124_193.pdb
# PARAMETERS: 1v66_A.T0416_124_193.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      S     124           -
LGA    A     2_A      E     125           -
LGA    D     3_A      D     126          6.445
LGA    -       -      K     127           -
LGA    -       -      M     128           -
LGA    -       -      K     129           -
LGA    S     4_A      Q     130          1.264
LGA    -       -      V     131           -
LGA    A     5_A      K     132          2.752
LGA    E     6_A      L     133          1.364
LGA    L     7_A      K     134          0.674
LGA    K     8_A      L     135          1.796
LGA    Q     9_A      K     136          1.000
LGA    M    10_A      E     137          1.127
LGA    V    11_A      L     138          2.222
LGA    M    12_A      E     139          3.211
LGA    S    13_A      X     140          3.050
LGA    L    14_A      L     141          2.465
LGA    R    15_A      N     142          2.314
LGA    V    16_A      N     143          2.072
LGA    S    17_A      N     144          0.911
LGA    E    18_A      K     145          1.702
LGA    L    19_A      L     146          2.150
LGA    Q    20_A      X     147          1.863
LGA    V    21_A      E     148          1.666
LGA    L    22_A      Y     149          1.652
LGA    L    23_A      L     150          1.817
LGA    G    24_A      A     151          1.411
LGA    Y    25_A      S     152          0.952
LGA    A    26_A      F     153          0.917
LGA    G    27_A      D     154          3.354
LGA    R    28_A      K     155          3.012
LGA    N    29_A      E     156          3.146
LGA    -       -      S     157           -
LGA    K    30_A      A     158          1.272
LGA    -       -      K     159           -
LGA    -       -      D     160           -
LGA    H    31_A      I     161          2.023
LGA    G    32_A      X     162          2.720
LGA    -       -      P     163           -
LGA    -       -      N     164           -
LGA    R    33_A      N     165          0.465
LGA    K    34_A      R     166          0.840
LGA    H    35_A      K     167          1.116
LGA    E    36_A      R     168          1.315
LGA    L    37_A      V     169          0.816
LGA    L    38_A      L     170          1.171
LGA    T    39_A      R     171          1.267
LGA    K    40_A      A     172          1.149
LGA    A    41_A      I     173          0.803
LGA    L    42_A      E     174          0.839
LGA    H    43_A      Y     175          1.277
LGA    L    44_A      Y     176          1.269
LGA    L    45_A      L     177          1.340
LGA    K    46_A      K     178          1.918
LGA    A    47_A      T     179          2.265
LGA    G    48_A      K     180          1.455
LGA    C    49_A      K     181          5.958
LGA    S    50_A      L     182           -
LGA    P    51_A      L     183           -
LGA    A    52_A      S     184           -
LGA    V    53_A      S     185           -
LGA    Q    54_A      R     186           -
LGA    M    55_A      K     187           -
LGA    K    56_A      K     188           -
LGA    I    57_A      V     189           -
LGA    K    58_A      Q     190           -
LGA    E    59_A      Q     191           -
LGA    L    60_A      F     192           -
LGA    Y    61_A      T     193           -
LGA    R    62_A      -       -           -
LGA    R    63_A      -       -           -
LGA    R    64_A      -       -           -
LGA    F    65_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   65   70    5.0     47    2.20    14.89     59.046     2.041

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.521085 * X  +  -0.259857 * Y  +   0.812985 * Z  + -24.212784
  Y_new =  -0.737202 * X  +  -0.617052 * Y  +   0.275282 * Z  +  -4.870248
  Z_new =   0.430120 * X  +  -0.742779 * Y  +  -0.513104 * Z  +  17.084463 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.175313    0.966279  [ DEG:  -124.6363     55.3637 ]
  Theta =  -0.444626   -2.696967  [ DEG:   -25.4752   -154.5248 ]
  Phi   =  -0.955493    2.186100  [ DEG:   -54.7457    125.2543 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1v66_A                                        
REMARK     2: T0416_124_193.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1v66_A.T0416_124_193.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   65   70   5.0   47   2.20   14.89  59.046
REMARK  ---------------------------------------------------------- 
MOLECULE 1v66_A
HEADER    LIGASE                                  27-NOV-03   1V66              
TITLE     SOLUTION STRUCTURE OF HUMAN P53 BINDING DOMAIN OF PIAS-1              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN INHIBITOR OF ACTIVATED STAT PROTEIN 1;             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 1-65;                                             
COMPND   5 SYNONYM: PROTEIN INHIBITOR OF ACTIVATED STAT-1, PIAS-1, GU           
COMPND   6 BINDING PROTEIN, GBP, RNA HELICASE II BINDING PROTEIN,               
COMPND   7 DEAD/H BOX-BINDING PROTEIN 1;                                        
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28B                                    
KEYWDS    FOUR HELIX BUNDLE, RIKEN STRUCTURAL GENOMICS/PROTEOMICS               
KEYWDS   2 INITIATIVE, RSGI, STRUCTURAL GENOMICS                                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    S.OKUBO,F.HARA,Y.TSUCHIDA,S.SHIMOTAKAHARA,S.SUZUKI,                   
AUTHOR   2 H.HATANAKA,S.YOKOYAMA,H.TANAKA,H.YASUDA,H.SHINDO,RIKEN               
AUTHOR   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   07-DEC-04 1V66    0                                                
JRNL        AUTH   S.OKUBO,F.HARA,Y.TSUCHIDA,S.SHIMOTAKAHARA,S.SUZUKI,          
JRNL        AUTH 2 H.HATANAKA,S.YOKOYAMA,H.TANAKA,H.YASUDA,H.SHINDO             
JRNL        TITL   NMR STRUCTURE OF THE N-TERMINAL DOMAIN OF SUMO               
JRNL        TITL 2 LIGASE PIAS1 AND ITS INTERACTION WITH TUMOR                  
JRNL        TITL 3 SUPPRESSOR P53 AND A/T-RICH DNA OLIGOMERS                    
JRNL        REF    J.BIOL.CHEM.                  V. 279 31455 2004              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1V66 A    1    65  UNP    O75925   PIAS1_HUMAN      1     65             
SEQRES   1 A   65  MET ALA ASP SER ALA GLU LEU LYS GLN MET VAL MET SER          
SEQRES   2 A   65  LEU ARG VAL SER GLU LEU GLN VAL LEU LEU GLY TYR ALA          
SEQRES   3 A   65  GLY ARG ASN LYS HIS GLY ARG LYS HIS GLU LEU LEU THR          
SEQRES   4 A   65  LYS ALA LEU HIS LEU LEU LYS ALA GLY CYS SER PRO ALA          
SEQRES   5 A   65  VAL GLN MET LYS ILE LYS GLU LEU TYR ARG ARG ARG PHE          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1     -30.953  11.250  16.241  1.00  0.00           N  
ATOM      2  CA  MET A   1     -29.999  11.616  17.274  1.00  0.00           C  
ATOM      3  C   MET A   1     -29.663  10.415  18.160  1.00  0.00           C  
ATOM      4  O   MET A   1     -30.501   9.540  18.372  1.00  0.00           O  
ATOM      5  CB  MET A   1     -30.585  12.737  18.135  1.00  0.00           C  
ATOM      6  CG  MET A   1     -30.178  14.111  17.598  1.00  0.00           C  
ATOM      7  SD  MET A   1     -28.485  14.462  18.042  1.00  0.00           S  
ATOM      8  CE  MET A   1     -28.115  15.748  16.862  1.00  0.00           C  
ATOM      9  HA  MET A   1     -29.106  11.949  16.745  1.00  0.00           H  
ATOM     10  HB3 MET A   1     -30.242  12.628  19.164  1.00  0.00           H  
ATOM     11  HG3 MET A   1     -30.835  14.879  18.006  1.00  0.00           H  
ATOM     12  HE1 MET A   1     -27.142  15.557  16.409  1.00  0.00           H  
ATOM     13  HE2 MET A   1     -28.881  15.760  16.086  1.00  0.00           H  
ATOM     14  HE3 MET A   1     -28.096  16.712  17.369  1.00  0.00           H  
ATOM     15  H1  MET A   1     -31.705  10.667  16.547  1.00  0.00           H  
ATOM     16  N   ALA A   2     -28.433  10.411  18.653  1.00  0.00           N  
ATOM     17  CA  ALA A   2     -27.975   9.331  19.511  1.00  0.00           C  
ATOM     18  C   ALA A   2     -26.582   9.669  20.048  1.00  0.00           C  
ATOM     19  O   ALA A   2     -26.137  10.811  19.953  1.00  0.00           O  
ATOM     20  CB  ALA A   2     -27.995   8.015  18.731  1.00  0.00           C  
ATOM     21  H   ALA A   2     -27.757  11.126  18.476  1.00  0.00           H  
ATOM     22  HA  ALA A   2     -28.670   9.255  20.347  1.00  0.00           H  
ATOM     23  HB1 ALA A   2     -28.996   7.844  18.334  1.00  0.00           H  
ATOM     24  HB2 ALA A   2     -27.282   8.069  17.909  1.00  0.00           H  
ATOM     25  HB3 ALA A   2     -27.723   7.195  19.395  1.00  0.00           H  
ATOM     26  N   ASP A   3     -25.935   8.653  20.602  1.00  0.00           N  
ATOM     27  CA  ASP A   3     -24.603   8.828  21.155  1.00  0.00           C  
ATOM     28  C   ASP A   3     -23.799   7.542  20.955  1.00  0.00           C  
ATOM     29  O   ASP A   3     -24.314   6.562  20.420  1.00  0.00           O  
ATOM     30  CB  ASP A   3     -24.663   9.120  22.656  1.00  0.00           C  
ATOM     31  CG  ASP A   3     -23.442   9.846  23.223  1.00  0.00           C  
ATOM     32  OD1 ASP A   3     -22.495  10.065  22.436  1.00  0.00           O  
ATOM     33  OD2 ASP A   3     -23.482  10.167  24.431  1.00  0.00           O  
ATOM     34  H   ASP A   3     -26.305   7.728  20.676  1.00  0.00           H  
ATOM     35  HA  ASP A   3     -24.177   9.674  20.615  1.00  0.00           H  
ATOM     36  HB3 ASP A   3     -24.787   8.177  23.189  1.00  0.00           H  
ATOM     37  N   SER A   4     -22.550   7.587  21.395  1.00  0.00           N  
ATOM     38  CA  SER A   4     -21.671   6.437  21.271  1.00  0.00           C  
ATOM     39  C   SER A   4     -21.700   5.615  22.561  1.00  0.00           C  
ATOM     40  O   SER A   4     -20.696   5.014  22.941  1.00  0.00           O  
ATOM     41  CB  SER A   4     -20.240   6.870  20.949  1.00  0.00           C  
ATOM     42  OG  SER A   4     -19.337   5.767  20.940  1.00  0.00           O  
ATOM     43  H   SER A   4     -22.139   8.388  21.829  1.00  0.00           H  
ATOM     44  HA  SER A   4     -22.071   5.857  20.439  1.00  0.00           H  
ATOM     45  HB3 SER A   4     -19.909   7.604  21.684  1.00  0.00           H  
ATOM     46  HG  SER A   4     -18.514   5.995  21.461  1.00  0.00           H  
ATOM     47  N   ALA A   5     -22.861   5.615  23.200  1.00  0.00           N  
ATOM     48  CA  ALA A   5     -23.032   4.877  24.439  1.00  0.00           C  
ATOM     49  C   ALA A   5     -24.269   3.982  24.328  1.00  0.00           C  
ATOM     50  O   ALA A   5     -24.228   2.811  24.702  1.00  0.00           O  
ATOM     51  CB  ALA A   5     -23.127   5.858  25.609  1.00  0.00           C  
ATOM     52  H   ALA A   5     -23.672   6.107  22.885  1.00  0.00           H  
ATOM     53  HA  ALA A   5     -22.152   4.250  24.578  1.00  0.00           H  
ATOM     54  HB1 ALA A   5     -24.173   5.995  25.885  1.00  0.00           H  
ATOM     55  HB2 ALA A   5     -22.575   5.462  26.462  1.00  0.00           H  
ATOM     56  HB3 ALA A   5     -22.700   6.817  25.315  1.00  0.00           H  
ATOM     57  N   GLU A   6     -25.340   4.568  23.812  1.00  0.00           N  
ATOM     58  CA  GLU A   6     -26.585   3.839  23.647  1.00  0.00           C  
ATOM     59  C   GLU A   6     -26.399   2.686  22.657  1.00  0.00           C  
ATOM     60  O   GLU A   6     -26.943   1.601  22.852  1.00  0.00           O  
ATOM     61  CB  GLU A   6     -27.710   4.772  23.196  1.00  0.00           C  
ATOM     62  CG  GLU A   6     -28.838   3.985  22.524  1.00  0.00           C  
ATOM     63  CD  GLU A   6     -30.206   4.564  22.894  1.00  0.00           C  
ATOM     64  OE1 GLU A   6     -30.538   4.512  24.098  1.00  0.00           O  
ATOM     65  OE2 GLU A   6     -30.888   5.044  21.963  1.00  0.00           O  
ATOM     66  H   GLU A   6     -25.365   5.521  23.510  1.00  0.00           H  
ATOM     67  HA  GLU A   6     -26.823   3.443  24.634  1.00  0.00           H  
ATOM     68  HB3 GLU A   6     -27.318   5.514  22.501  1.00  0.00           H  
ATOM     69  HG3 GLU A   6     -28.788   2.939  22.828  1.00  0.00           H  
ATOM     70  N   LEU A   7     -25.626   2.962  21.616  1.00  0.00           N  
ATOM     71  CA  LEU A   7     -25.359   1.963  20.596  1.00  0.00           C  
ATOM     72  C   LEU A   7     -24.695   0.745  21.243  1.00  0.00           C  
ATOM     73  O   LEU A   7     -25.032  -0.395  20.922  1.00  0.00           O  
ATOM     74  CB  LEU A   7     -24.549   2.569  19.450  1.00  0.00           C  
ATOM     75  CG  LEU A   7     -25.103   3.861  18.846  1.00  0.00           C  
ATOM     76  CD1 LEU A   7     -23.982   4.713  18.247  1.00  0.00           C  
ATOM     77  CD2 LEU A   7     -26.202   3.562  17.825  1.00  0.00           C  
ATOM     78  H   LEU A   7     -25.185   3.847  21.466  1.00  0.00           H  
ATOM     79  HA  LEU A   7     -26.319   1.653  20.184  1.00  0.00           H  
ATOM     80  HB3 LEU A   7     -24.467   1.826  18.656  1.00  0.00           H  
ATOM     81  HG  LEU A   7     -25.559   4.444  19.647  1.00  0.00           H  
ATOM     82 HD11 LEU A   7     -23.122   4.706  18.919  1.00  0.00           H  
ATOM     83 HD12 LEU A   7     -23.691   4.303  17.281  1.00  0.00           H  
ATOM     84 HD13 LEU A   7     -24.333   5.736  18.118  1.00  0.00           H  
ATOM     85 HD21 LEU A   7     -26.400   2.489  17.808  1.00  0.00           H  
ATOM     86 HD22 LEU A   7     -27.112   4.094  18.103  1.00  0.00           H  
ATOM     87 HD23 LEU A   7     -25.878   3.888  16.836  1.00  0.00           H  
ATOM     88  N   LYS A   8     -23.763   1.027  22.140  1.00  0.00           N  
ATOM     89  CA  LYS A   8     -23.048  -0.031  22.835  1.00  0.00           C  
ATOM     90  C   LYS A   8     -24.036  -0.841  23.676  1.00  0.00           C  
ATOM     91  O   LYS A   8     -24.069  -2.068  23.591  1.00  0.00           O  
ATOM     92  CB  LYS A   8     -21.885   0.548  23.642  1.00  0.00           C  
ATOM     93  CG  LYS A   8     -20.595  -0.236  23.384  1.00  0.00           C  
ATOM     94  CD  LYS A   8     -19.376   0.689  23.416  1.00  0.00           C  
ATOM     95  CE  LYS A   8     -19.445   1.726  22.292  1.00  0.00           C  
ATOM     96  NZ  LYS A   8     -19.126   3.074  22.811  1.00  0.00           N  
ATOM     97  H   LYS A   8     -23.494   1.956  22.396  1.00  0.00           H  
ATOM     98  HA  LYS A   8     -22.620  -0.688  22.077  1.00  0.00           H  
ATOM     99  HB3 LYS A   8     -22.125   0.521  24.704  1.00  0.00           H  
ATOM    100  HG3 LYS A   8     -20.654  -0.732  22.416  1.00  0.00           H  
ATOM    101  HD3 LYS A   8     -18.465   0.099  23.316  1.00  0.00           H  
ATOM    102  HE3 LYS A   8     -20.442   1.726  21.849  1.00  0.00           H  
ATOM    103  HZ1 LYS A   8     -19.932   3.456  23.263  1.00  0.00           H  
ATOM    104  HZ2 LYS A   8     -18.375   3.010  23.468  1.00  0.00           H  
ATOM    105  HZ3 LYS A   8     -18.857   3.669  22.053  1.00  0.00           H  
ATOM    106  N   GLN A   9     -24.817  -0.124  24.469  1.00  0.00           N  
ATOM    107  CA  GLN A   9     -25.803  -0.760  25.325  1.00  0.00           C  
ATOM    108  C   GLN A   9     -26.805  -1.552  24.482  1.00  0.00           C  
ATOM    109  O   GLN A   9     -27.190  -2.661  24.850  1.00  0.00           O  
ATOM    110  CB  GLN A   9     -26.518   0.271  26.200  1.00  0.00           C  
ATOM    111  CG  GLN A   9     -25.793   0.454  27.535  1.00  0.00           C  
ATOM    112  CD  GLN A   9     -25.984  -0.768  28.434  1.00  0.00           C  
ATOM    113  OE1 GLN A   9     -25.937  -1.906  27.997  1.00  0.00           O  
ATOM    114  NE2 GLN A   9     -26.200  -0.472  29.712  1.00  0.00           N  
ATOM    115  H   GLN A   9     -24.784   0.874  24.532  1.00  0.00           H  
ATOM    116  HA  GLN A   9     -25.238  -1.439  25.963  1.00  0.00           H  
ATOM    117  HB3 GLN A   9     -27.545  -0.048  26.381  1.00  0.00           H  
ATOM    118  HG3 GLN A   9     -26.172   1.344  28.039  1.00  0.00           H  
ATOM    119 HE21 GLN A   9     -26.226   0.484  30.007  1.00  0.00           H  
ATOM    120 HE22 GLN A   9     -26.336  -1.204  30.380  1.00  0.00           H  
ATOM    121  N   MET A  10     -27.198  -0.952  23.369  1.00  0.00           N  
ATOM    122  CA  MET A  10     -28.147  -1.588  22.471  1.00  0.00           C  
ATOM    123  C   MET A  10     -27.551  -2.851  21.846  1.00  0.00           C  
ATOM    124  O   MET A  10     -28.202  -3.893  21.802  1.00  0.00           O  
ATOM    125  CB  MET A  10     -28.540  -0.607  21.364  1.00  0.00           C  
ATOM    126  CG  MET A  10     -29.470   0.483  21.901  1.00  0.00           C  
ATOM    127  SD  MET A  10     -29.727   1.735  20.655  1.00  0.00           S  
ATOM    128  CE  MET A  10     -30.439   0.737  19.357  1.00  0.00           C  
ATOM    129  H   MET A  10     -26.881  -0.050  23.077  1.00  0.00           H  
ATOM    130  HA  MET A  10     -29.006  -1.851  23.091  1.00  0.00           H  
ATOM    131  HB3 MET A  10     -29.033  -1.144  20.555  1.00  0.00           H  
ATOM    132  HG3 MET A  10     -29.039   0.932  22.797  1.00  0.00           H  
ATOM    133  HE1 MET A  10     -31.370   1.191  19.018  1.00  0.00           H  
ATOM    134  HE2 MET A  10     -29.740   0.675  18.522  1.00  0.00           H  
ATOM    135  HE3 MET A  10     -30.641  -0.264  19.737  1.00  0.00           H  
ATOM    136  N   VAL A  11     -26.318  -2.715  21.380  1.00  0.00           N  
ATOM    137  CA  VAL A  11     -25.626  -3.833  20.760  1.00  0.00           C  
ATOM    138  C   VAL A  11     -25.434  -4.945  21.793  1.00  0.00           C  
ATOM    139  O   VAL A  11     -25.521  -6.126  21.462  1.00  0.00           O  
ATOM    140  CB  VAL A  11     -24.310  -3.355  20.143  1.00  0.00           C  
ATOM    141  CG1 VAL A  11     -23.368  -4.533  19.881  1.00  0.00           C  
ATOM    142  CG2 VAL A  11     -24.561  -2.559  18.862  1.00  0.00           C  
ATOM    143  H   VAL A  11     -25.795  -1.864  21.420  1.00  0.00           H  
ATOM    144  HA  VAL A  11     -26.259  -4.207  19.955  1.00  0.00           H  
ATOM    145  HB  VAL A  11     -23.825  -2.692  20.860  1.00  0.00           H  
ATOM    146 HG11 VAL A  11     -23.819  -5.202  19.148  1.00  0.00           H  
ATOM    147 HG12 VAL A  11     -22.418  -4.159  19.497  1.00  0.00           H  
ATOM    148 HG13 VAL A  11     -23.197  -5.075  20.810  1.00  0.00           H  
ATOM    149 HG21 VAL A  11     -24.978  -3.218  18.100  1.00  0.00           H  
ATOM    150 HG22 VAL A  11     -25.265  -1.752  19.068  1.00  0.00           H  
ATOM    151 HG23 VAL A  11     -23.621  -2.138  18.504  1.00  0.00           H  
ATOM    152  N   MET A  12     -25.175  -4.527  23.023  1.00  0.00           N  
ATOM    153  CA  MET A  12     -24.969  -5.474  24.107  1.00  0.00           C  
ATOM    154  C   MET A  12     -26.237  -6.289  24.370  1.00  0.00           C  
ATOM    155  O   MET A  12     -26.203  -7.274  25.106  1.00  0.00           O  
ATOM    156  CB  MET A  12     -24.576  -4.717  25.378  1.00  0.00           C  
ATOM    157  CG  MET A  12     -23.063  -4.505  25.443  1.00  0.00           C  
ATOM    158  SD  MET A  12     -22.563  -4.183  27.126  1.00  0.00           S  
ATOM    159  CE  MET A  12     -21.093  -5.192  27.211  1.00  0.00           C  
ATOM    160  H   MET A  12     -25.105  -3.564  23.284  1.00  0.00           H  
ATOM    161  HA  MET A  12     -24.168  -6.132  23.772  1.00  0.00           H  
ATOM    162  HB3 MET A  12     -24.907  -5.274  26.254  1.00  0.00           H  
ATOM    163  HG3 MET A  12     -22.776  -3.668  24.804  1.00  0.00           H  
ATOM    164  HE1 MET A  12     -20.448  -4.828  28.011  1.00  0.00           H  
ATOM    165  HE2 MET A  12     -21.373  -6.226  27.411  1.00  0.00           H  
ATOM    166  HE3 MET A  12     -20.560  -5.138  26.262  1.00  0.00           H  
ATOM    167  N   SER A  13     -27.324  -5.849  23.754  1.00  0.00           N  
ATOM    168  CA  SER A  13     -28.599  -6.527  23.911  1.00  0.00           C  
ATOM    169  C   SER A  13     -28.892  -7.387  22.681  1.00  0.00           C  
ATOM    170  O   SER A  13     -29.965  -7.978  22.571  1.00  0.00           O  
ATOM    171  CB  SER A  13     -29.732  -5.523  24.138  1.00  0.00           C  
ATOM    172  OG  SER A  13     -30.957  -6.168  24.477  1.00  0.00           O  
ATOM    173  H   SER A  13     -27.342  -5.048  23.156  1.00  0.00           H  
ATOM    174  HA  SER A  13     -28.486  -7.153  24.797  1.00  0.00           H  
ATOM    175  HB3 SER A  13     -29.873  -4.926  23.237  1.00  0.00           H  
ATOM    176  HG  SER A  13     -30.773  -6.994  25.010  1.00  0.00           H  
ATOM    177  N   LEU A  14     -27.916  -7.431  21.784  1.00  0.00           N  
ATOM    178  CA  LEU A  14     -28.056  -8.209  20.565  1.00  0.00           C  
ATOM    179  C   LEU A  14     -27.560  -9.634  20.816  1.00  0.00           C  
ATOM    180  O   LEU A  14     -26.654  -9.848  21.619  1.00  0.00           O  
ATOM    181  CB  LEU A  14     -27.352  -7.510  19.400  1.00  0.00           C  
ATOM    182  CG  LEU A  14     -27.872  -6.115  19.042  1.00  0.00           C  
ATOM    183  CD1 LEU A  14     -27.005  -5.469  17.960  1.00  0.00           C  
ATOM    184  CD2 LEU A  14     -29.348  -6.166  18.641  1.00  0.00           C  
ATOM    185  H   LEU A  14     -27.046  -6.948  21.880  1.00  0.00           H  
ATOM    186  HA  LEU A  14     -29.117  -8.250  20.322  1.00  0.00           H  
ATOM    187  HB3 LEU A  14     -27.436  -8.144  18.517  1.00  0.00           H  
ATOM    188  HG  LEU A  14     -27.802  -5.487  19.929  1.00  0.00           H  
ATOM    189 HD11 LEU A  14     -27.009  -6.096  17.069  1.00  0.00           H  
ATOM    190 HD12 LEU A  14     -27.406  -4.485  17.714  1.00  0.00           H  
ATOM    191 HD13 LEU A  14     -25.984  -5.364  18.326  1.00  0.00           H  
ATOM    192 HD21 LEU A  14     -29.684  -5.167  18.367  1.00  0.00           H  
ATOM    193 HD22 LEU A  14     -29.469  -6.836  17.789  1.00  0.00           H  
ATOM    194 HD23 LEU A  14     -29.939  -6.534  19.479  1.00  0.00           H  
ATOM    195  N   ARG A  15     -28.178 -10.574  20.114  1.00  0.00           N  
ATOM    196  CA  ARG A  15     -27.810 -11.973  20.250  1.00  0.00           C  
ATOM    197  C   ARG A  15     -26.720 -12.336  19.241  1.00  0.00           C  
ATOM    198  O   ARG A  15     -26.395 -11.542  18.360  1.00  0.00           O  
ATOM    199  CB  ARG A  15     -29.020 -12.884  20.034  1.00  0.00           C  
ATOM    200  CG  ARG A  15     -29.497 -12.826  18.581  1.00  0.00           C  
ATOM    201  CD  ARG A  15     -30.958 -13.266  18.465  1.00  0.00           C  
ATOM    202  NE  ARG A  15     -31.078 -14.709  18.768  1.00  0.00           N  
ATOM    203  CZ  ARG A  15     -32.083 -15.486  18.338  1.00  0.00           C  
ATOM    204  NH1 ARG A  15     -33.060 -14.961  17.586  1.00  0.00           N  
ATOM    205  NH2 ARG A  15     -32.110 -16.785  18.662  1.00  0.00           N  
ATOM    206  H   ARG A  15     -28.914 -10.392  19.463  1.00  0.00           H  
ATOM    207  HA  ARG A  15     -27.445 -12.067  21.273  1.00  0.00           H  
ATOM    208  HB3 ARG A  15     -29.831 -12.582  20.697  1.00  0.00           H  
ATOM    209  HG3 ARG A  15     -28.870 -13.470  17.963  1.00  0.00           H  
ATOM    210  HD3 ARG A  15     -31.328 -13.064  17.460  1.00  0.00           H  
ATOM    211  HE  ARG A  15     -30.365 -15.131  19.327  1.00  0.00           H  
ATOM    212 HH11 ARG A  15     -33.040 -13.991  17.345  1.00  0.00           H  
ATOM    213 HH12 ARG A  15     -33.810 -15.541  17.267  1.00  0.00           H  
ATOM    214 HH21 ARG A  15     -31.380 -17.177  19.223  1.00  0.00           H  
ATOM    215 HH22 ARG A  15     -32.859 -17.365  18.341  1.00  0.00           H  
ATOM    216  N   VAL A  16     -26.185 -13.538  19.402  1.00  0.00           N  
ATOM    217  CA  VAL A  16     -25.139 -14.017  18.515  1.00  0.00           C  
ATOM    218  C   VAL A  16     -25.605 -13.884  17.064  1.00  0.00           C  
ATOM    219  O   VAL A  16     -24.860 -13.404  16.211  1.00  0.00           O  
ATOM    220  CB  VAL A  16     -24.750 -15.449  18.890  1.00  0.00           C  
ATOM    221  CG1 VAL A  16     -23.743 -16.022  17.891  1.00  0.00           C  
ATOM    222  CG2 VAL A  16     -24.205 -15.513  20.317  1.00  0.00           C  
ATOM    223  H   VAL A  16     -26.456 -14.178  20.121  1.00  0.00           H  
ATOM    224  HA  VAL A  16     -24.266 -13.381  18.663  1.00  0.00           H  
ATOM    225  HB  VAL A  16     -25.650 -16.062  18.847  1.00  0.00           H  
ATOM    226 HG11 VAL A  16     -22.768 -16.112  18.369  1.00  0.00           H  
ATOM    227 HG12 VAL A  16     -24.077 -17.007  17.562  1.00  0.00           H  
ATOM    228 HG13 VAL A  16     -23.666 -15.358  17.030  1.00  0.00           H  
ATOM    229 HG21 VAL A  16     -24.402 -14.569  20.824  1.00  0.00           H  
ATOM    230 HG22 VAL A  16     -24.693 -16.325  20.857  1.00  0.00           H  
ATOM    231 HG23 VAL A  16     -23.130 -15.692  20.288  1.00  0.00           H  
ATOM    232  N   SER A  17     -26.835 -14.317  16.829  1.00  0.00           N  
ATOM    233  CA  SER A  17     -27.409 -14.253  15.496  1.00  0.00           C  
ATOM    234  C   SER A  17     -27.411 -12.807  14.997  1.00  0.00           C  
ATOM    235  O   SER A  17     -27.090 -12.545  13.839  1.00  0.00           O  
ATOM    236  CB  SER A  17     -28.829 -14.822  15.480  1.00  0.00           C  
ATOM    237  OG  SER A  17     -28.925 -15.994  14.674  1.00  0.00           O  
ATOM    238  H   SER A  17     -27.433 -14.706  17.529  1.00  0.00           H  
ATOM    239  HA  SER A  17     -26.763 -14.871  14.874  1.00  0.00           H  
ATOM    240  HB3 SER A  17     -29.519 -14.066  15.104  1.00  0.00           H  
ATOM    241  HG  SER A  17     -29.331 -16.740  15.203  1.00  0.00           H  
ATOM    242  N   GLU A  18     -27.778 -11.905  15.896  1.00  0.00           N  
ATOM    243  CA  GLU A  18     -27.827 -10.492  15.562  1.00  0.00           C  
ATOM    244  C   GLU A  18     -26.420  -9.967  15.266  1.00  0.00           C  
ATOM    245  O   GLU A  18     -26.215  -9.243  14.293  1.00  0.00           O  
ATOM    246  CB  GLU A  18     -28.488  -9.685  16.681  1.00  0.00           C  
ATOM    247  CG  GLU A  18     -30.005  -9.618  16.485  1.00  0.00           C  
ATOM    248  CD  GLU A  18     -30.737  -9.801  17.816  1.00  0.00           C  
ATOM    249  OE1 GLU A  18     -30.087  -9.570  18.859  1.00  0.00           O  
ATOM    250  OE2 GLU A  18     -31.931 -10.167  17.761  1.00  0.00           O  
ATOM    251  H   GLU A  18     -28.038 -12.125  16.835  1.00  0.00           H  
ATOM    252  HA  GLU A  18     -28.441 -10.427  14.663  1.00  0.00           H  
ATOM    253  HB3 GLU A  18     -28.076  -8.677  16.700  1.00  0.00           H  
ATOM    254  HG3 GLU A  18     -30.319 -10.390  15.784  1.00  0.00           H  
ATOM    255  N   LEU A  19     -25.487 -10.353  16.124  1.00  0.00           N  
ATOM    256  CA  LEU A  19     -24.105  -9.931  15.967  1.00  0.00           C  
ATOM    257  C   LEU A  19     -23.604 -10.346  14.583  1.00  0.00           C  
ATOM    258  O   LEU A  19     -22.861  -9.606  13.940  1.00  0.00           O  
ATOM    259  CB  LEU A  19     -23.249 -10.464  17.117  1.00  0.00           C  
ATOM    260  CG  LEU A  19     -23.264  -9.637  18.404  1.00  0.00           C  
ATOM    261  CD1 LEU A  19     -22.805  -8.202  18.140  1.00  0.00           C  
ATOM    262  CD2 LEU A  19     -24.641  -9.685  19.069  1.00  0.00           C  
ATOM    263  H   LEU A  19     -25.662 -10.942  16.912  1.00  0.00           H  
ATOM    264  HA  LEU A  19     -24.087  -8.843  16.029  1.00  0.00           H  
ATOM    265  HB3 LEU A  19     -22.218 -10.541  16.770  1.00  0.00           H  
ATOM    266  HG  LEU A  19     -22.554 -10.080  19.103  1.00  0.00           H  
ATOM    267 HD11 LEU A  19     -22.636  -7.694  19.090  1.00  0.00           H  
ATOM    268 HD12 LEU A  19     -21.878  -8.217  17.566  1.00  0.00           H  
ATOM    269 HD13 LEU A  19     -23.572  -7.673  17.576  1.00  0.00           H  
ATOM    270 HD21 LEU A  19     -24.766 -10.640  19.579  1.00  0.00           H  
ATOM    271 HD22 LEU A  19     -24.724  -8.873  19.793  1.00  0.00           H  
ATOM    272 HD23 LEU A  19     -25.416  -9.574  18.310  1.00  0.00           H  
ATOM    273  N   GLN A  20     -24.029 -11.529  14.165  1.00  0.00           N  
ATOM    274  CA  GLN A  20     -23.632 -12.053  12.868  1.00  0.00           C  
ATOM    275  C   GLN A  20     -24.058 -11.093  11.756  1.00  0.00           C  
ATOM    276  O   GLN A  20     -23.363 -10.954  10.750  1.00  0.00           O  
ATOM    277  CB  GLN A  20     -24.213 -13.450  12.639  1.00  0.00           C  
ATOM    278  CG  GLN A  20     -23.574 -14.470  13.584  1.00  0.00           C  
ATOM    279  CD  GLN A  20     -23.154 -15.731  12.824  1.00  0.00           C  
ATOM    280  OE1 GLN A  20     -23.583 -15.989  11.712  1.00  0.00           O  
ATOM    281  NE2 GLN A  20     -22.294 -16.499  13.487  1.00  0.00           N  
ATOM    282  H   GLN A  20     -24.633 -12.126  14.694  1.00  0.00           H  
ATOM    283  HA  GLN A  20     -22.545 -12.119  12.904  1.00  0.00           H  
ATOM    284  HB3 GLN A  20     -24.046 -13.751  11.605  1.00  0.00           H  
ATOM    285  HG3 GLN A  20     -24.279 -14.734  14.371  1.00  0.00           H  
ATOM    286 HE21 GLN A  20     -21.981 -16.230  14.398  1.00  0.00           H  
ATOM    287 HE22 GLN A  20     -21.960 -17.346  13.074  1.00  0.00           H  
ATOM    288  N   VAL A  21     -25.200 -10.455  11.973  1.00  0.00           N  
ATOM    289  CA  VAL A  21     -25.726  -9.512  11.001  1.00  0.00           C  
ATOM    290  C   VAL A  21     -24.885  -8.234  11.028  1.00  0.00           C  
ATOM    291  O   VAL A  21     -24.554  -7.683   9.980  1.00  0.00           O  
ATOM    292  CB  VAL A  21     -27.211  -9.256  11.272  1.00  0.00           C  
ATOM    293  CG1 VAL A  21     -27.428  -7.860  11.858  1.00  0.00           C  
ATOM    294  CG2 VAL A  21     -28.041  -9.453  10.003  1.00  0.00           C  
ATOM    295  H   VAL A  21     -25.759 -10.573  12.793  1.00  0.00           H  
ATOM    296  HA  VAL A  21     -25.637  -9.970  10.016  1.00  0.00           H  
ATOM    297  HB  VAL A  21     -27.547  -9.985  12.008  1.00  0.00           H  
ATOM    298 HG11 VAL A  21     -26.996  -7.114  11.191  1.00  0.00           H  
ATOM    299 HG12 VAL A  21     -28.497  -7.674  11.968  1.00  0.00           H  
ATOM    300 HG13 VAL A  21     -26.946  -7.797  12.834  1.00  0.00           H  
ATOM    301 HG21 VAL A  21     -29.085  -9.222  10.212  1.00  0.00           H  
ATOM    302 HG22 VAL A  21     -27.672  -8.790   9.220  1.00  0.00           H  
ATOM    303 HG23 VAL A  21     -27.957 -10.488   9.670  1.00  0.00           H  
ATOM    304  N   LEU A  22     -24.563  -7.801  12.238  1.00  0.00           N  
ATOM    305  CA  LEU A  22     -23.767  -6.599  12.415  1.00  0.00           C  
ATOM    306  C   LEU A  22     -22.419  -6.777  11.715  1.00  0.00           C  
ATOM    307  O   LEU A  22     -21.969  -5.890  10.990  1.00  0.00           O  
ATOM    308  CB  LEU A  22     -23.647  -6.249  13.900  1.00  0.00           C  
ATOM    309  CG  LEU A  22     -24.952  -6.260  14.700  1.00  0.00           C  
ATOM    310  CD1 LEU A  22     -24.701  -5.895  16.163  1.00  0.00           C  
ATOM    311  CD2 LEU A  22     -25.998  -5.351  14.052  1.00  0.00           C  
ATOM    312  H   LEU A  22     -24.837  -8.255  13.086  1.00  0.00           H  
ATOM    313  HA  LEU A  22     -24.301  -5.779  11.934  1.00  0.00           H  
ATOM    314  HB3 LEU A  22     -23.201  -5.259  13.985  1.00  0.00           H  
ATOM    315  HG  LEU A  22     -25.352  -7.273  14.685  1.00  0.00           H  
ATOM    316 HD11 LEU A  22     -25.116  -6.670  16.808  1.00  0.00           H  
ATOM    317 HD12 LEU A  22     -23.628  -5.812  16.339  1.00  0.00           H  
ATOM    318 HD13 LEU A  22     -25.180  -4.941  16.387  1.00  0.00           H  
ATOM    319 HD21 LEU A  22     -26.694  -4.998  14.814  1.00  0.00           H  
ATOM    320 HD22 LEU A  22     -25.502  -4.497  13.591  1.00  0.00           H  
ATOM    321 HD23 LEU A  22     -26.545  -5.910  13.292  1.00  0.00           H  
ATOM    322  N   LEU A  23     -21.811  -7.930  11.956  1.00  0.00           N  
ATOM    323  CA  LEU A  23     -20.523  -8.236  11.356  1.00  0.00           C  
ATOM    324  C   LEU A  23     -20.723  -8.594   9.883  1.00  0.00           C  
ATOM    325  O   LEU A  23     -20.008  -8.093   9.016  1.00  0.00           O  
ATOM    326  CB  LEU A  23     -19.803  -9.321  12.161  1.00  0.00           C  
ATOM    327  CG  LEU A  23     -19.507  -8.986  13.623  1.00  0.00           C  
ATOM    328  CD1 LEU A  23     -18.231  -9.685  14.099  1.00  0.00           C  
ATOM    329  CD2 LEU A  23     -19.445  -7.473  13.839  1.00  0.00           C  
ATOM    330  H   LEU A  23     -22.183  -8.646  12.547  1.00  0.00           H  
ATOM    331  HA  LEU A  23     -19.914  -7.334  11.414  1.00  0.00           H  
ATOM    332  HB3 LEU A  23     -18.861  -9.549  11.663  1.00  0.00           H  
ATOM    333  HG  LEU A  23     -20.327  -9.365  14.234  1.00  0.00           H  
ATOM    334 HD11 LEU A  23     -18.188 -10.689  13.677  1.00  0.00           H  
ATOM    335 HD12 LEU A  23     -17.362  -9.115  13.770  1.00  0.00           H  
ATOM    336 HD13 LEU A  23     -18.234  -9.747  15.186  1.00  0.00           H  
ATOM    337 HD21 LEU A  23     -20.449  -7.054  13.760  1.00  0.00           H  
ATOM    338 HD22 LEU A  23     -19.041  -7.262  14.828  1.00  0.00           H  
ATOM    339 HD23 LEU A  23     -18.804  -7.024  13.081  1.00  0.00           H  
ATOM    340  N   GLY A  24     -21.699  -9.457   9.644  1.00  0.00           N  
ATOM    341  CA  GLY A  24     -22.002  -9.888   8.289  1.00  0.00           C  
ATOM    342  C   GLY A  24     -22.299  -8.688   7.386  1.00  0.00           C  
ATOM    343  O   GLY A  24     -21.818  -8.623   6.256  1.00  0.00           O  
ATOM    344  H   GLY A  24     -22.275  -9.860  10.354  1.00  0.00           H  
ATOM    345  HA2 GLY A  24     -21.161 -10.451   7.886  1.00  0.00           H  
ATOM    346  HA3 GLY A  24     -22.860 -10.560   8.300  1.00  0.00           H  
ATOM    347  N   TYR A  25     -23.091  -7.769   7.919  1.00  0.00           N  
ATOM    348  CA  TYR A  25     -23.458  -6.577   7.175  1.00  0.00           C  
ATOM    349  C   TYR A  25     -22.285  -5.598   7.094  1.00  0.00           C  
ATOM    350  O   TYR A  25     -22.303  -4.666   6.291  1.00  0.00           O  
ATOM    351  CB  TYR A  25     -24.598  -5.923   7.962  1.00  0.00           C  
ATOM    352  CG  TYR A  25     -25.099  -4.611   7.357  1.00  0.00           C  
ATOM    353  CD1 TYR A  25     -25.480  -4.564   6.030  1.00  0.00           C  
ATOM    354  CD2 TYR A  25     -25.171  -3.475   8.136  1.00  0.00           C  
ATOM    355  CE1 TYR A  25     -25.953  -3.329   5.460  1.00  0.00           C  
ATOM    356  CE2 TYR A  25     -25.643  -2.239   7.566  1.00  0.00           C  
ATOM    357  CZ  TYR A  25     -26.011  -2.227   6.256  1.00  0.00           C  
ATOM    358  OH  TYR A  25     -26.457  -1.060   5.718  1.00  0.00           O  
ATOM    359  H   TYR A  25     -23.478  -7.830   8.839  1.00  0.00           H  
ATOM    360  HA  TYR A  25     -23.738  -6.881   6.168  1.00  0.00           H  
ATOM    361  HB3 TYR A  25     -24.261  -5.736   8.981  1.00  0.00           H  
ATOM    362  HD1 TYR A  25     -25.423  -5.461   5.415  1.00  0.00           H  
ATOM    363  HD2 TYR A  25     -24.870  -3.512   9.182  1.00  0.00           H  
ATOM    364  HE1 TYR A  25     -26.256  -3.278   4.415  1.00  0.00           H  
ATOM    365  HE2 TYR A  25     -25.705  -1.335   8.171  1.00  0.00           H  
ATOM    366  HH  TYR A  25     -27.137  -0.643   6.322  1.00  0.00           H  
ATOM    367  N   ALA A  26     -21.293  -5.843   7.937  1.00  0.00           N  
ATOM    368  CA  ALA A  26     -20.113  -4.996   7.970  1.00  0.00           C  
ATOM    369  C   ALA A  26     -18.970  -5.690   7.228  1.00  0.00           C  
ATOM    370  O   ALA A  26     -17.948  -5.070   6.934  1.00  0.00           O  
ATOM    371  CB  ALA A  26     -19.755  -4.675   9.423  1.00  0.00           C  
ATOM    372  H   ALA A  26     -21.285  -6.603   8.587  1.00  0.00           H  
ATOM    373  HA  ALA A  26     -20.357  -4.066   7.455  1.00  0.00           H  
ATOM    374  HB1 ALA A  26     -18.749  -4.257   9.466  1.00  0.00           H  
ATOM    375  HB2 ALA A  26     -20.466  -3.953   9.822  1.00  0.00           H  
ATOM    376  HB3 ALA A  26     -19.794  -5.589  10.017  1.00  0.00           H  
ATOM    377  N   GLY A  27     -19.179  -6.968   6.946  1.00  0.00           N  
ATOM    378  CA  GLY A  27     -18.179  -7.753   6.244  1.00  0.00           C  
ATOM    379  C   GLY A  27     -17.300  -8.528   7.228  1.00  0.00           C  
ATOM    380  O   GLY A  27     -16.847  -9.631   6.926  1.00  0.00           O  
ATOM    381  H   GLY A  27     -20.012  -7.464   7.189  1.00  0.00           H  
ATOM    382  HA2 GLY A  27     -18.670  -8.450   5.564  1.00  0.00           H  
ATOM    383  HA3 GLY A  27     -17.559  -7.097   5.634  1.00  0.00           H  
ATOM    384  N   ARG A  28     -17.084  -7.919   8.385  1.00  0.00           N  
ATOM    385  CA  ARG A  28     -16.267  -8.537   9.415  1.00  0.00           C  
ATOM    386  C   ARG A  28     -16.643 -10.012   9.577  1.00  0.00           C  
ATOM    387  O   ARG A  28     -17.759 -10.411   9.247  1.00  0.00           O  
ATOM    388  CB  ARG A  28     -16.440  -7.823  10.757  1.00  0.00           C  
ATOM    389  CG  ARG A  28     -15.725  -6.470  10.755  1.00  0.00           C  
ATOM    390  CD  ARG A  28     -14.282  -6.612  11.243  1.00  0.00           C  
ATOM    391  NE  ARG A  28     -13.363  -6.692  10.085  1.00  0.00           N  
ATOM    392  CZ  ARG A  28     -12.033  -6.825  10.190  1.00  0.00           C  
ATOM    393  NH1 ARG A  28     -11.460  -6.893  11.399  1.00  0.00           N  
ATOM    394  NH2 ARG A  28     -11.278  -6.890   9.084  1.00  0.00           N  
ATOM    395  H   ARG A  28     -17.456  -7.021   8.622  1.00  0.00           H  
ATOM    396  HA  ARG A  28     -15.242  -8.430   9.059  1.00  0.00           H  
ATOM    397  HB3 ARG A  28     -16.043  -8.447  11.558  1.00  0.00           H  
ATOM    398  HG3 ARG A  28     -16.263  -5.771  11.395  1.00  0.00           H  
ATOM    399  HD3 ARG A  28     -14.183  -7.505  11.859  1.00  0.00           H  
ATOM    400  HE  ARG A  28     -13.758  -6.645   9.168  1.00  0.00           H  
ATOM    401 HH11 ARG A  28     -12.024  -6.844  12.224  1.00  0.00           H  
ATOM    402 HH12 ARG A  28     -10.468  -6.991  11.477  1.00  0.00           H  
ATOM    403 HH21 ARG A  28     -11.705  -6.839   8.182  1.00  0.00           H  
ATOM    404 HH22 ARG A  28     -10.285  -6.989   9.163  1.00  0.00           H  
ATOM    405  N   ASN A  29     -15.689 -10.780  10.083  1.00  0.00           N  
ATOM    406  CA  ASN A  29     -15.906 -12.201  10.292  1.00  0.00           C  
ATOM    407  C   ASN A  29     -16.730 -12.405  11.566  1.00  0.00           C  
ATOM    408  O   ASN A  29     -16.582 -11.658  12.532  1.00  0.00           O  
ATOM    409  CB  ASN A  29     -14.579 -12.942  10.465  1.00  0.00           C  
ATOM    410  CG  ASN A  29     -14.812 -14.426  10.753  1.00  0.00           C  
ATOM    411  OD1 ASN A  29     -14.867 -14.864  11.890  1.00  0.00           O  
ATOM    412  ND2 ASN A  29     -14.945 -15.174   9.661  1.00  0.00           N  
ATOM    413  H   ASN A  29     -14.785 -10.447  10.348  1.00  0.00           H  
ATOM    414  HA  ASN A  29     -16.427 -12.546   9.400  1.00  0.00           H  
ATOM    415  HB3 ASN A  29     -14.013 -12.495  11.282  1.00  0.00           H  
ATOM    416 HD21 ASN A  29     -14.891 -14.752   8.756  1.00  0.00           H  
ATOM    417 HD22 ASN A  29     -15.102 -16.158   9.745  1.00  0.00           H  
ATOM    418  N   LYS A  30     -17.581 -13.420  11.526  1.00  0.00           N  
ATOM    419  CA  LYS A  30     -18.429 -13.731  12.665  1.00  0.00           C  
ATOM    420  C   LYS A  30     -18.296 -15.217  13.003  1.00  0.00           C  
ATOM    421  O   LYS A  30     -18.725 -16.074  12.230  1.00  0.00           O  
ATOM    422  CB  LYS A  30     -19.868 -13.287  12.398  1.00  0.00           C  
ATOM    423  CG  LYS A  30     -20.504 -14.124  11.286  1.00  0.00           C  
ATOM    424  CD  LYS A  30     -21.173 -13.229  10.241  1.00  0.00           C  
ATOM    425  CE  LYS A  30     -22.077 -14.048   9.317  1.00  0.00           C  
ATOM    426  NZ  LYS A  30     -22.914 -13.154   8.485  1.00  0.00           N  
ATOM    427  H   LYS A  30     -17.696 -14.023  10.737  1.00  0.00           H  
ATOM    428  HA  LYS A  30     -18.063 -13.151  13.512  1.00  0.00           H  
ATOM    429  HB3 LYS A  30     -19.882 -12.234  12.118  1.00  0.00           H  
ATOM    430  HG3 LYS A  30     -21.240 -14.804  11.714  1.00  0.00           H  
ATOM    431  HD3 LYS A  30     -20.411 -12.719   9.652  1.00  0.00           H  
ATOM    432  HE3 LYS A  30     -22.713 -14.706   9.909  1.00  0.00           H  
ATOM    433  HZ1 LYS A  30     -23.403 -12.512   9.076  1.00  0.00           H  
ATOM    434  HZ2 LYS A  30     -22.331 -12.647   7.851  1.00  0.00           H  
ATOM    435  HZ3 LYS A  30     -23.572 -13.700   7.968  1.00  0.00           H  
ATOM    436  N   HIS A  31     -17.701 -15.479  14.157  1.00  0.00           N  
ATOM    437  CA  HIS A  31     -17.506 -16.847  14.606  1.00  0.00           C  
ATOM    438  C   HIS A  31     -16.947 -16.844  16.030  1.00  0.00           C  
ATOM    439  O   HIS A  31     -15.774 -16.540  16.240  1.00  0.00           O  
ATOM    440  CB  HIS A  31     -16.625 -17.621  13.623  1.00  0.00           C  
ATOM    441  CG  HIS A  31     -16.976 -19.085  13.506  1.00  0.00           C  
ATOM    442  ND1 HIS A  31     -16.372 -20.065  14.274  1.00  0.00           N  
ATOM    443  CD2 HIS A  31     -17.875 -19.724  12.703  1.00  0.00           C  
ATOM    444  CE1 HIS A  31     -16.891 -21.237  13.939  1.00  0.00           C  
ATOM    445  NE2 HIS A  31     -17.822 -21.024  12.966  1.00  0.00           N  
ATOM    446  H   HIS A  31     -17.354 -14.776  14.779  1.00  0.00           H  
ATOM    447  HA  HIS A  31     -18.489 -17.317  14.611  1.00  0.00           H  
ATOM    448  HB3 HIS A  31     -15.585 -17.531  13.937  1.00  0.00           H  
ATOM    449  HD1 HIS A  31     -15.664 -19.914  14.963  1.00  0.00           H  
ATOM    450  HD2 HIS A  31     -18.527 -19.247  11.971  1.00  0.00           H  
ATOM    451  HE1 HIS A  31     -16.621 -22.203  14.367  1.00  0.00           H  
ATOM    452  N   GLY A  32     -17.813 -17.188  16.971  1.00  0.00           N  
ATOM    453  CA  GLY A  32     -17.421 -17.230  18.370  1.00  0.00           C  
ATOM    454  C   GLY A  32     -18.627 -17.005  19.285  1.00  0.00           C  
ATOM    455  O   GLY A  32     -19.767 -17.006  18.826  1.00  0.00           O  
ATOM    456  H   GLY A  32     -18.766 -17.434  16.793  1.00  0.00           H  
ATOM    457  HA2 GLY A  32     -16.964 -18.194  18.594  1.00  0.00           H  
ATOM    458  HA3 GLY A  32     -16.667 -16.467  18.563  1.00  0.00           H  
ATOM    459  N   ARG A  33     -18.332 -16.817  20.563  1.00  0.00           N  
ATOM    460  CA  ARG A  33     -19.378 -16.592  21.547  1.00  0.00           C  
ATOM    461  C   ARG A  33     -19.940 -15.177  21.408  1.00  0.00           C  
ATOM    462  O   ARG A  33     -19.487 -14.404  20.565  1.00  0.00           O  
ATOM    463  CB  ARG A  33     -18.848 -16.786  22.969  1.00  0.00           C  
ATOM    464  CG  ARG A  33     -19.448 -18.038  23.611  1.00  0.00           C  
ATOM    465  CD  ARG A  33     -19.176 -18.064  25.117  1.00  0.00           C  
ATOM    466  NE  ARG A  33     -19.745 -19.295  25.713  1.00  0.00           N  
ATOM    467  CZ  ARG A  33     -21.035 -19.443  26.041  1.00  0.00           C  
ATOM    468  NH1 ARG A  33     -21.899 -18.439  25.835  1.00  0.00           N  
ATOM    469  NH2 ARG A  33     -21.463 -20.594  26.576  1.00  0.00           N  
ATOM    470  H   ARG A  33     -17.401 -16.818  20.929  1.00  0.00           H  
ATOM    471  HA  ARG A  33     -20.138 -17.341  21.321  1.00  0.00           H  
ATOM    472  HB3 ARG A  33     -19.089 -15.912  23.573  1.00  0.00           H  
ATOM    473  HG3 ARG A  33     -19.025 -18.929  23.147  1.00  0.00           H  
ATOM    474  HD3 ARG A  33     -19.616 -17.186  25.590  1.00  0.00           H  
ATOM    475  HE  ARG A  33     -19.128 -20.063  25.879  1.00  0.00           H  
ATOM    476 HH11 ARG A  33     -21.580 -17.579  25.435  1.00  0.00           H  
ATOM    477 HH12 ARG A  33     -22.862 -18.549  26.080  1.00  0.00           H  
ATOM    478 HH21 ARG A  33     -20.819 -21.344  26.731  1.00  0.00           H  
ATOM    479 HH22 ARG A  33     -22.426 -20.705  26.822  1.00  0.00           H  
ATOM    480  N   LYS A  34     -20.921 -14.878  22.248  1.00  0.00           N  
ATOM    481  CA  LYS A  34     -21.550 -13.569  22.230  1.00  0.00           C  
ATOM    482  C   LYS A  34     -20.534 -12.513  22.668  1.00  0.00           C  
ATOM    483  O   LYS A  34     -20.420 -11.459  22.044  1.00  0.00           O  
ATOM    484  CB  LYS A  34     -22.830 -13.578  23.068  1.00  0.00           C  
ATOM    485  CG  LYS A  34     -23.703 -12.362  22.751  1.00  0.00           C  
ATOM    486  CD  LYS A  34     -24.567 -11.979  23.953  1.00  0.00           C  
ATOM    487  CE  LYS A  34     -23.761 -11.177  24.976  1.00  0.00           C  
ATOM    488  NZ  LYS A  34     -24.608 -10.814  26.135  1.00  0.00           N  
ATOM    489  H   LYS A  34     -21.285 -15.513  22.930  1.00  0.00           H  
ATOM    490  HA  LYS A  34     -21.842 -13.362  21.200  1.00  0.00           H  
ATOM    491  HB3 LYS A  34     -22.574 -13.579  24.128  1.00  0.00           H  
ATOM    492  HG3 LYS A  34     -24.340 -12.581  21.895  1.00  0.00           H  
ATOM    493  HD3 LYS A  34     -24.964 -12.879  24.422  1.00  0.00           H  
ATOM    494  HE3 LYS A  34     -23.366 -10.273  24.509  1.00  0.00           H  
ATOM    495  HZ1 LYS A  34     -24.444  -9.859  26.381  1.00  0.00           H  
ATOM    496  HZ2 LYS A  34     -25.570 -10.936  25.895  1.00  0.00           H  
ATOM    497  HZ3 LYS A  34     -24.380 -11.403  26.910  1.00  0.00           H  
ATOM    498  N   HIS A  35     -19.821 -12.833  23.739  1.00  0.00           N  
ATOM    499  CA  HIS A  35     -18.818 -11.926  24.268  1.00  0.00           C  
ATOM    500  C   HIS A  35     -17.783 -11.616  23.185  1.00  0.00           C  
ATOM    501  O   HIS A  35     -17.390 -10.464  23.008  1.00  0.00           O  
ATOM    502  CB  HIS A  35     -18.190 -12.493  25.543  1.00  0.00           C  
ATOM    503  CG  HIS A  35     -17.324 -11.509  26.292  1.00  0.00           C  
ATOM    504  ND1 HIS A  35     -17.778 -10.790  27.384  1.00  0.00           N  
ATOM    505  CD2 HIS A  35     -16.028 -11.133  26.094  1.00  0.00           C  
ATOM    506  CE1 HIS A  35     -16.791 -10.019  27.816  1.00  0.00           C  
ATOM    507  NE2 HIS A  35     -15.708 -10.232  27.015  1.00  0.00           N  
ATOM    508  H   HIS A  35     -19.920 -13.693  24.240  1.00  0.00           H  
ATOM    509  HA  HIS A  35     -19.338 -11.006  24.535  1.00  0.00           H  
ATOM    510  HB3 HIS A  35     -17.590 -13.365  25.283  1.00  0.00           H  
ATOM    511  HD1 HIS A  35     -18.695 -10.844  27.779  1.00  0.00           H  
ATOM    512  HD2 HIS A  35     -15.367 -11.508  25.313  1.00  0.00           H  
ATOM    513  HE1 HIS A  35     -16.837  -9.333  28.663  1.00  0.00           H  
ATOM    514  N   GLU A  36     -17.371 -12.664  22.488  1.00  0.00           N  
ATOM    515  CA  GLU A  36     -16.389 -12.519  21.426  1.00  0.00           C  
ATOM    516  C   GLU A  36     -16.959 -11.669  20.289  1.00  0.00           C  
ATOM    517  O   GLU A  36     -16.277 -10.789  19.765  1.00  0.00           O  
ATOM    518  CB  GLU A  36     -15.931 -13.885  20.913  1.00  0.00           C  
ATOM    519  CG  GLU A  36     -15.253 -14.689  22.024  1.00  0.00           C  
ATOM    520  CD  GLU A  36     -14.325 -15.757  21.440  1.00  0.00           C  
ATOM    521  OE1 GLU A  36     -13.563 -15.402  20.515  1.00  0.00           O  
ATOM    522  OE2 GLU A  36     -14.398 -16.903  21.932  1.00  0.00           O  
ATOM    523  H   GLU A  36     -17.697 -13.598  22.637  1.00  0.00           H  
ATOM    524  HA  GLU A  36     -15.542 -12.007  21.883  1.00  0.00           H  
ATOM    525  HB3 GLU A  36     -15.239 -13.752  20.081  1.00  0.00           H  
ATOM    526  HG3 GLU A  36     -16.010 -15.164  22.649  1.00  0.00           H  
ATOM    527  N   LEU A  37     -18.203 -11.961  19.941  1.00  0.00           N  
ATOM    528  CA  LEU A  37     -18.873 -11.234  18.875  1.00  0.00           C  
ATOM    529  C   LEU A  37     -19.122  -9.792  19.325  1.00  0.00           C  
ATOM    530  O   LEU A  37     -18.897  -8.854  18.564  1.00  0.00           O  
ATOM    531  CB  LEU A  37     -20.141 -11.970  18.439  1.00  0.00           C  
ATOM    532  CG  LEU A  37     -19.933 -13.189  17.539  1.00  0.00           C  
ATOM    533  CD1 LEU A  37     -21.218 -14.012  17.424  1.00  0.00           C  
ATOM    534  CD2 LEU A  37     -19.395 -12.773  16.168  1.00  0.00           C  
ATOM    535  H   LEU A  37     -18.751 -12.677  20.372  1.00  0.00           H  
ATOM    536  HA  LEU A  37     -18.200 -11.217  18.019  1.00  0.00           H  
ATOM    537  HB3 LEU A  37     -20.786 -11.263  17.917  1.00  0.00           H  
ATOM    538  HG  LEU A  37     -19.181 -13.829  17.999  1.00  0.00           H  
ATOM    539 HD11 LEU A  37     -21.919 -13.501  16.763  1.00  0.00           H  
ATOM    540 HD12 LEU A  37     -20.984 -14.995  17.015  1.00  0.00           H  
ATOM    541 HD13 LEU A  37     -21.666 -14.126  18.411  1.00  0.00           H  
ATOM    542 HD21 LEU A  37     -18.359 -13.099  16.070  1.00  0.00           H  
ATOM    543 HD22 LEU A  37     -19.997 -13.236  15.386  1.00  0.00           H  
ATOM    544 HD23 LEU A  37     -19.445 -11.688  16.072  1.00  0.00           H  
ATOM    545  N   LEU A  38     -19.584  -9.664  20.561  1.00  0.00           N  
ATOM    546  CA  LEU A  38     -19.866  -8.354  21.121  1.00  0.00           C  
ATOM    547  C   LEU A  38     -18.592  -7.506  21.094  1.00  0.00           C  
ATOM    548  O   LEU A  38     -18.624  -6.344  20.696  1.00  0.00           O  
ATOM    549  CB  LEU A  38     -20.486  -8.488  22.513  1.00  0.00           C  
ATOM    550  CG  LEU A  38     -22.004  -8.318  22.591  1.00  0.00           C  
ATOM    551  CD1 LEU A  38     -22.408  -6.866  22.323  1.00  0.00           C  
ATOM    552  CD2 LEU A  38     -22.714  -9.293  21.651  1.00  0.00           C  
ATOM    553  H   LEU A  38     -19.764 -10.434  21.173  1.00  0.00           H  
ATOM    554  HA  LEU A  38     -20.610  -7.878  20.481  1.00  0.00           H  
ATOM    555  HB3 LEU A  38     -20.023  -7.749  23.168  1.00  0.00           H  
ATOM    556  HG  LEU A  38     -22.323  -8.558  23.605  1.00  0.00           H  
ATOM    557 HD11 LEU A  38     -22.254  -6.274  23.224  1.00  0.00           H  
ATOM    558 HD12 LEU A  38     -21.798  -6.464  21.513  1.00  0.00           H  
ATOM    559 HD13 LEU A  38     -23.459  -6.829  22.037  1.00  0.00           H  
ATOM    560 HD21 LEU A  38     -22.061 -10.141  21.445  1.00  0.00           H  
ATOM    561 HD22 LEU A  38     -23.633  -9.648  22.120  1.00  0.00           H  
ATOM    562 HD23 LEU A  38     -22.956  -8.788  20.716  1.00  0.00           H  
ATOM    563  N   THR A  39     -17.501  -8.124  21.522  1.00  0.00           N  
ATOM    564  CA  THR A  39     -16.219  -7.442  21.552  1.00  0.00           C  
ATOM    565  C   THR A  39     -15.832  -6.971  20.149  1.00  0.00           C  
ATOM    566  O   THR A  39     -15.257  -5.896  19.986  1.00  0.00           O  
ATOM    567  CB  THR A  39     -15.193  -8.389  22.179  1.00  0.00           C  
ATOM    568  OG1 THR A  39     -15.534  -8.401  23.563  1.00  0.00           O  
ATOM    569  CG2 THR A  39     -13.774  -7.818  22.148  1.00  0.00           C  
ATOM    570  H   THR A  39     -17.483  -9.070  21.844  1.00  0.00           H  
ATOM    571  HA  THR A  39     -16.317  -6.550  22.172  1.00  0.00           H  
ATOM    572  HB  THR A  39     -15.229  -9.369  21.706  1.00  0.00           H  
ATOM    573  HG1 THR A  39     -16.391  -8.896  23.701  1.00  0.00           H  
ATOM    574 HG21 THR A  39     -13.216  -8.188  23.009  1.00  0.00           H  
ATOM    575 HG22 THR A  39     -13.276  -8.131  21.231  1.00  0.00           H  
ATOM    576 HG23 THR A  39     -13.819  -6.730  22.185  1.00  0.00           H  
ATOM    577  N   LYS A  40     -16.162  -7.799  19.169  1.00  0.00           N  
ATOM    578  CA  LYS A  40     -15.857  -7.482  17.785  1.00  0.00           C  
ATOM    579  C   LYS A  40     -16.737  -6.317  17.327  1.00  0.00           C  
ATOM    580  O   LYS A  40     -16.265  -5.409  16.644  1.00  0.00           O  
ATOM    581  CB  LYS A  40     -15.984  -8.729  16.908  1.00  0.00           C  
ATOM    582  CG  LYS A  40     -14.608  -9.318  16.588  1.00  0.00           C  
ATOM    583  CD  LYS A  40     -14.739 -10.675  15.896  1.00  0.00           C  
ATOM    584  CE  LYS A  40     -15.027 -11.783  16.910  1.00  0.00           C  
ATOM    585  NZ  LYS A  40     -13.855 -12.000  17.788  1.00  0.00           N  
ATOM    586  H   LYS A  40     -16.630  -8.672  19.309  1.00  0.00           H  
ATOM    587  HA  LYS A  40     -14.815  -7.164  17.745  1.00  0.00           H  
ATOM    588  HB3 LYS A  40     -16.500  -8.476  15.981  1.00  0.00           H  
ATOM    589  HG3 LYS A  40     -14.034  -9.429  17.508  1.00  0.00           H  
ATOM    590  HD3 LYS A  40     -13.820 -10.902  15.355  1.00  0.00           H  
ATOM    591  HE3 LYS A  40     -15.273 -12.708  16.389  1.00  0.00           H  
ATOM    592  HZ1 LYS A  40     -13.720 -11.196  18.368  1.00  0.00           H  
ATOM    593  HZ2 LYS A  40     -14.012 -12.803  18.362  1.00  0.00           H  
ATOM    594  HZ3 LYS A  40     -13.041 -12.146  17.226  1.00  0.00           H  
ATOM    595  N   ALA A  41     -18.000  -6.381  17.722  1.00  0.00           N  
ATOM    596  CA  ALA A  41     -18.950  -5.342  17.361  1.00  0.00           C  
ATOM    597  C   ALA A  41     -18.578  -4.043  18.080  1.00  0.00           C  
ATOM    598  O   ALA A  41     -18.639  -2.965  17.492  1.00  0.00           O  
ATOM    599  CB  ALA A  41     -20.368  -5.808  17.697  1.00  0.00           C  
ATOM    600  H   ALA A  41     -18.375  -7.122  18.277  1.00  0.00           H  
ATOM    601  HA  ALA A  41     -18.878  -5.185  16.285  1.00  0.00           H  
ATOM    602  HB1 ALA A  41     -20.341  -6.846  18.027  1.00  0.00           H  
ATOM    603  HB2 ALA A  41     -20.777  -5.184  18.491  1.00  0.00           H  
ATOM    604  HB3 ALA A  41     -20.997  -5.725  16.811  1.00  0.00           H  
ATOM    605  N   LEU A  42     -18.199  -4.191  19.341  1.00  0.00           N  
ATOM    606  CA  LEU A  42     -17.817  -3.043  20.147  1.00  0.00           C  
ATOM    607  C   LEU A  42     -16.592  -2.373  19.523  1.00  0.00           C  
ATOM    608  O   LEU A  42     -16.555  -1.153  19.375  1.00  0.00           O  
ATOM    609  CB  LEU A  42     -17.616  -3.457  21.606  1.00  0.00           C  
ATOM    610  CG  LEU A  42     -18.872  -3.907  22.355  1.00  0.00           C  
ATOM    611  CD1 LEU A  42     -18.877  -3.373  23.789  1.00  0.00           C  
ATOM    612  CD2 LEU A  42     -20.137  -3.512  21.591  1.00  0.00           C  
ATOM    613  H   LEU A  42     -18.152  -5.072  19.812  1.00  0.00           H  
ATOM    614  HA  LEU A  42     -18.646  -2.337  20.123  1.00  0.00           H  
ATOM    615  HB3 LEU A  42     -17.179  -2.615  22.145  1.00  0.00           H  
ATOM    616  HG  LEU A  42     -18.860  -4.996  22.417  1.00  0.00           H  
ATOM    617 HD11 LEU A  42     -19.765  -3.734  24.307  1.00  0.00           H  
ATOM    618 HD12 LEU A  42     -17.985  -3.722  24.309  1.00  0.00           H  
ATOM    619 HD13 LEU A  42     -18.884  -2.283  23.770  1.00  0.00           H  
ATOM    620 HD21 LEU A  42     -21.015  -3.842  22.147  1.00  0.00           H  
ATOM    621 HD22 LEU A  42     -20.167  -2.428  21.474  1.00  0.00           H  
ATOM    622 HD23 LEU A  42     -20.130  -3.983  20.609  1.00  0.00           H  
ATOM    623  N   HIS A  43     -15.618  -3.202  19.173  1.00  0.00           N  
ATOM    624  CA  HIS A  43     -14.394  -2.704  18.568  1.00  0.00           C  
ATOM    625  C   HIS A  43     -14.726  -1.962  17.272  1.00  0.00           C  
ATOM    626  O   HIS A  43     -14.019  -1.034  16.885  1.00  0.00           O  
ATOM    627  CB  HIS A  43     -13.391  -3.841  18.360  1.00  0.00           C  
ATOM    628  CG  HIS A  43     -12.432  -4.032  19.511  1.00  0.00           C  
ATOM    629  ND1 HIS A  43     -11.203  -4.652  19.369  1.00  0.00           N  
ATOM    630  CD2 HIS A  43     -12.535  -3.678  20.824  1.00  0.00           C  
ATOM    631  CE1 HIS A  43     -10.603  -4.666  20.550  1.00  0.00           C  
ATOM    632  NE2 HIS A  43     -11.429  -4.063  21.450  1.00  0.00           N  
ATOM    633  H   HIS A  43     -15.656  -4.193  19.296  1.00  0.00           H  
ATOM    634  HA  HIS A  43     -13.958  -2.001  19.277  1.00  0.00           H  
ATOM    635  HB3 HIS A  43     -12.818  -3.645  17.453  1.00  0.00           H  
ATOM    636  HD1 HIS A  43     -10.832  -5.025  18.519  1.00  0.00           H  
ATOM    637  HD2 HIS A  43     -13.382  -3.167  21.283  1.00  0.00           H  
ATOM    638  HE1 HIS A  43      -9.619  -5.086  20.764  1.00  0.00           H  
ATOM    639  N   LEU A  44     -15.804  -2.400  16.637  1.00  0.00           N  
ATOM    640  CA  LEU A  44     -16.239  -1.790  15.392  1.00  0.00           C  
ATOM    641  C   LEU A  44     -16.708  -0.359  15.668  1.00  0.00           C  
ATOM    642  O   LEU A  44     -16.502   0.535  14.849  1.00  0.00           O  
ATOM    643  CB  LEU A  44     -17.292  -2.661  14.707  1.00  0.00           C  
ATOM    644  CG  LEU A  44     -16.828  -3.426  13.466  1.00  0.00           C  
ATOM    645  CD1 LEU A  44     -18.016  -4.034  12.719  1.00  0.00           C  
ATOM    646  CD2 LEU A  44     -15.977  -2.534  12.560  1.00  0.00           C  
ATOM    647  H   LEU A  44     -16.374  -3.156  16.959  1.00  0.00           H  
ATOM    648  HA  LEU A  44     -15.375  -1.748  14.730  1.00  0.00           H  
ATOM    649  HB3 LEU A  44     -18.133  -2.027  14.425  1.00  0.00           H  
ATOM    650  HG  LEU A  44     -16.195  -4.251  13.791  1.00  0.00           H  
ATOM    651 HD11 LEU A  44     -18.329  -4.951  13.219  1.00  0.00           H  
ATOM    652 HD12 LEU A  44     -18.843  -3.324  12.714  1.00  0.00           H  
ATOM    653 HD13 LEU A  44     -17.724  -4.260  11.694  1.00  0.00           H  
ATOM    654 HD21 LEU A  44     -16.120  -1.490  12.839  1.00  0.00           H  
ATOM    655 HD22 LEU A  44     -14.926  -2.798  12.673  1.00  0.00           H  
ATOM    656 HD23 LEU A  44     -16.279  -2.677  11.523  1.00  0.00           H  
ATOM    657  N   LEU A  45     -17.330  -0.187  16.826  1.00  0.00           N  
ATOM    658  CA  LEU A  45     -17.830   1.119  17.219  1.00  0.00           C  
ATOM    659  C   LEU A  45     -16.648   2.059  17.468  1.00  0.00           C  
ATOM    660  O   LEU A  45     -16.647   3.197  17.002  1.00  0.00           O  
ATOM    661  CB  LEU A  45     -18.777   0.992  18.414  1.00  0.00           C  
ATOM    662  CG  LEU A  45     -20.204   0.542  18.094  1.00  0.00           C  
ATOM    663  CD1 LEU A  45     -20.680  -0.519  19.089  1.00  0.00           C  
ATOM    664  CD2 LEU A  45     -21.155   1.739  18.033  1.00  0.00           C  
ATOM    665  H   LEU A  45     -17.493  -0.919  17.487  1.00  0.00           H  
ATOM    666  HA  LEU A  45     -18.413   1.510  16.386  1.00  0.00           H  
ATOM    667  HB3 LEU A  45     -18.826   1.957  18.917  1.00  0.00           H  
ATOM    668  HG  LEU A  45     -20.203   0.081  17.106  1.00  0.00           H  
ATOM    669 HD11 LEU A  45     -21.758  -0.647  18.995  1.00  0.00           H  
ATOM    670 HD12 LEU A  45     -20.182  -1.465  18.877  1.00  0.00           H  
ATOM    671 HD13 LEU A  45     -20.439  -0.200  20.103  1.00  0.00           H  
ATOM    672 HD21 LEU A  45     -22.041   1.469  17.458  1.00  0.00           H  
ATOM    673 HD22 LEU A  45     -21.450   2.021  19.043  1.00  0.00           H  
ATOM    674 HD23 LEU A  45     -20.653   2.579  17.552  1.00  0.00           H  
ATOM    675  N   LYS A  46     -15.671   1.547  18.201  1.00  0.00           N  
ATOM    676  CA  LYS A  46     -14.485   2.326  18.518  1.00  0.00           C  
ATOM    677  C   LYS A  46     -13.612   2.448  17.268  1.00  0.00           C  
ATOM    678  O   LYS A  46     -12.874   3.420  17.114  1.00  0.00           O  
ATOM    679  CB  LYS A  46     -13.756   1.728  19.722  1.00  0.00           C  
ATOM    680  CG  LYS A  46     -12.485   2.517  20.041  1.00  0.00           C  
ATOM    681  CD  LYS A  46     -11.235   1.708  19.690  1.00  0.00           C  
ATOM    682  CE  LYS A  46     -11.019   0.571  20.691  1.00  0.00           C  
ATOM    683  NZ  LYS A  46      -9.582   0.441  21.024  1.00  0.00           N  
ATOM    684  H   LYS A  46     -15.679   0.620  18.576  1.00  0.00           H  
ATOM    685  HA  LYS A  46     -14.818   3.324  18.805  1.00  0.00           H  
ATOM    686  HB3 LYS A  46     -13.502   0.688  19.517  1.00  0.00           H  
ATOM    687  HG3 LYS A  46     -12.470   2.776  21.099  1.00  0.00           H  
ATOM    688  HD3 LYS A  46     -10.363   2.362  19.683  1.00  0.00           H  
ATOM    689  HE3 LYS A  46     -11.388  -0.365  20.273  1.00  0.00           H  
ATOM    690  HZ1 LYS A  46      -9.312  -0.520  20.963  1.00  0.00           H  
ATOM    691  HZ2 LYS A  46      -9.041   0.981  20.381  1.00  0.00           H  
ATOM    692  HZ3 LYS A  46      -9.425   0.772  21.955  1.00  0.00           H  
ATOM    693  N   ALA A  47     -13.725   1.448  16.406  1.00  0.00           N  
ATOM    694  CA  ALA A  47     -12.953   1.430  15.175  1.00  0.00           C  
ATOM    695  C   ALA A  47     -13.658   2.293  14.126  1.00  0.00           C  
ATOM    696  O   ALA A  47     -13.135   2.493  13.030  1.00  0.00           O  
ATOM    697  CB  ALA A  47     -12.765  -0.015  14.710  1.00  0.00           C  
ATOM    698  H   ALA A  47     -14.326   0.661  16.539  1.00  0.00           H  
ATOM    699  HA  ALA A  47     -11.975   1.860  15.389  1.00  0.00           H  
ATOM    700  HB1 ALA A  47     -13.736  -0.454  14.483  1.00  0.00           H  
ATOM    701  HB2 ALA A  47     -12.140  -0.032  13.818  1.00  0.00           H  
ATOM    702  HB3 ALA A  47     -12.283  -0.592  15.501  1.00  0.00           H  
ATOM    703  N   GLY A  48     -14.833   2.779  14.497  1.00  0.00           N  
ATOM    704  CA  GLY A  48     -15.614   3.614  13.602  1.00  0.00           C  
ATOM    705  C   GLY A  48     -16.400   2.763  12.602  1.00  0.00           C  
ATOM    706  O   GLY A  48     -15.819   2.168  11.697  1.00  0.00           O  
ATOM    707  H   GLY A  48     -15.250   2.610  15.390  1.00  0.00           H  
ATOM    708  HA2 GLY A  48     -16.303   4.230  14.181  1.00  0.00           H  
ATOM    709  HA3 GLY A  48     -14.954   4.295  13.064  1.00  0.00           H  
ATOM    710  N   CYS A  49     -17.710   2.731  12.802  1.00  0.00           N  
ATOM    711  CA  CYS A  49     -18.581   1.962  11.930  1.00  0.00           C  
ATOM    712  C   CYS A  49     -19.690   2.886  11.423  1.00  0.00           C  
ATOM    713  O   CYS A  49     -20.372   3.536  12.215  1.00  0.00           O  
ATOM    714  CB  CYS A  49     -19.145   0.729  12.638  1.00  0.00           C  
ATOM    715  SG  CYS A  49     -18.975  -0.744  11.564  1.00  0.00           S  
ATOM    716  H   CYS A  49     -18.174   3.217  13.542  1.00  0.00           H  
ATOM    717  HA  CYS A  49     -17.964   1.608  11.104  1.00  0.00           H  
ATOM    718  HB3 CYS A  49     -20.194   0.888  12.886  1.00  0.00           H  
ATOM    719  HG  CYS A  49     -18.060  -1.356  12.311  1.00  0.00           H  
ATOM    720  N   SER A  50     -19.837   2.915  10.107  1.00  0.00           N  
ATOM    721  CA  SER A  50     -20.852   3.748   9.485  1.00  0.00           C  
ATOM    722  C   SER A  50     -22.161   3.652  10.271  1.00  0.00           C  
ATOM    723  O   SER A  50     -22.341   2.739  11.075  1.00  0.00           O  
ATOM    724  CB  SER A  50     -21.077   3.346   8.026  1.00  0.00           C  
ATOM    725  OG  SER A  50     -20.563   4.317   7.119  1.00  0.00           O  
ATOM    726  H   SER A  50     -19.279   2.383   9.470  1.00  0.00           H  
ATOM    727  HA  SER A  50     -20.456   4.762   9.525  1.00  0.00           H  
ATOM    728  HB3 SER A  50     -22.144   3.212   7.848  1.00  0.00           H  
ATOM    729  HG  SER A  50     -21.315   4.828   6.702  1.00  0.00           H  
ATOM    730  N   PRO A  51     -23.066   4.632  10.003  1.00  0.00           N  
ATOM    731  CA  PRO A  51     -24.353   4.666  10.675  1.00  0.00           C  
ATOM    732  C   PRO A  51     -25.293   3.597  10.115  1.00  0.00           C  
ATOM    733  O   PRO A  51     -26.395   3.405  10.625  1.00  0.00           O  
ATOM    734  CB  PRO A  51     -24.869   6.080  10.465  1.00  0.00           C  
ATOM    735  CG  PRO A  51     -24.077   6.644   9.297  1.00  0.00           C  
ATOM    736  CD  PRO A  51     -22.887   5.729   9.056  1.00  0.00           C  
ATOM    737  HA  PRO A  51     -24.244   4.452  11.645  1.00  0.00           H  
ATOM    738  HB3 PRO A  51     -24.728   6.685  11.361  1.00  0.00           H  
ATOM    739  HG3 PRO A  51     -23.739   7.657   9.517  1.00  0.00           H  
ATOM    740  HD3 PRO A  51     -21.945   6.250   9.226  1.00  0.00           H  
ATOM    741  N   ALA A  52     -24.823   2.930   9.071  1.00  0.00           N  
ATOM    742  CA  ALA A  52     -25.608   1.885   8.435  1.00  0.00           C  
ATOM    743  C   ALA A  52     -25.782   0.719   9.411  1.00  0.00           C  
ATOM    744  O   ALA A  52     -26.877   0.172   9.540  1.00  0.00           O  
ATOM    745  CB  ALA A  52     -24.929   1.458   7.132  1.00  0.00           C  
ATOM    746  H   ALA A  52     -23.926   3.092   8.661  1.00  0.00           H  
ATOM    747  HA  ALA A  52     -26.588   2.302   8.201  1.00  0.00           H  
ATOM    748  HB1 ALA A  52     -25.345   0.506   6.801  1.00  0.00           H  
ATOM    749  HB2 ALA A  52     -25.101   2.215   6.368  1.00  0.00           H  
ATOM    750  HB3 ALA A  52     -23.859   1.347   7.299  1.00  0.00           H  
ATOM    751  N   VAL A  53     -24.688   0.374  10.072  1.00  0.00           N  
ATOM    752  CA  VAL A  53     -24.707  -0.717  11.032  1.00  0.00           C  
ATOM    753  C   VAL A  53     -25.432  -0.262  12.300  1.00  0.00           C  
ATOM    754  O   VAL A  53     -26.118  -1.053  12.945  1.00  0.00           O  
ATOM    755  CB  VAL A  53     -23.281  -1.203  11.300  1.00  0.00           C  
ATOM    756  CG1 VAL A  53     -23.287  -2.521  12.076  1.00  0.00           C  
ATOM    757  CG2 VAL A  53     -22.493  -1.338   9.995  1.00  0.00           C  
ATOM    758  H   VAL A  53     -23.803   0.824   9.961  1.00  0.00           H  
ATOM    759  HA  VAL A  53     -25.264  -1.540  10.585  1.00  0.00           H  
ATOM    760  HB  VAL A  53     -22.782  -0.454  11.916  1.00  0.00           H  
ATOM    761 HG11 VAL A  53     -24.208  -2.598  12.655  1.00  0.00           H  
ATOM    762 HG12 VAL A  53     -23.228  -3.355  11.376  1.00  0.00           H  
ATOM    763 HG13 VAL A  53     -22.431  -2.550  12.750  1.00  0.00           H  
ATOM    764 HG21 VAL A  53     -22.172  -2.372   9.871  1.00  0.00           H  
ATOM    765 HG22 VAL A  53     -23.128  -1.051   9.157  1.00  0.00           H  
ATOM    766 HG23 VAL A  53     -21.619  -0.687  10.030  1.00  0.00           H  
ATOM    767  N   GLN A  54     -25.255   1.011  12.621  1.00  0.00           N  
ATOM    768  CA  GLN A  54     -25.884   1.582  13.800  1.00  0.00           C  
ATOM    769  C   GLN A  54     -27.406   1.461  13.700  1.00  0.00           C  
ATOM    770  O   GLN A  54     -28.084   1.268  14.707  1.00  0.00           O  
ATOM    771  CB  GLN A  54     -25.461   3.038  13.997  1.00  0.00           C  
ATOM    772  CG  GLN A  54     -23.979   3.133  14.367  1.00  0.00           C  
ATOM    773  CD  GLN A  54     -23.619   4.547  14.828  1.00  0.00           C  
ATOM    774  OE1 GLN A  54     -24.465   5.413  14.981  1.00  0.00           O  
ATOM    775  NE2 GLN A  54     -22.320   4.732  15.041  1.00  0.00           N  
ATOM    776  H   GLN A  54     -24.695   1.650  12.090  1.00  0.00           H  
ATOM    777  HA  GLN A  54     -25.520   0.986  14.638  1.00  0.00           H  
ATOM    778  HB3 GLN A  54     -26.065   3.493  14.782  1.00  0.00           H  
ATOM    779  HG3 GLN A  54     -23.368   2.861  13.507  1.00  0.00           H  
ATOM    780 HE21 GLN A  54     -21.677   3.978  14.897  1.00  0.00           H  
ATOM    781 HE22 GLN A  54     -21.984   5.623  15.345  1.00  0.00           H  
ATOM    782  N   MET A  55     -27.898   1.580  12.476  1.00  0.00           N  
ATOM    783  CA  MET A  55     -29.328   1.488  12.231  1.00  0.00           C  
ATOM    784  C   MET A  55     -29.830   0.060  12.454  1.00  0.00           C  
ATOM    785  O   MET A  55     -30.908  -0.143  13.011  1.00  0.00           O  
ATOM    786  CB  MET A  55     -29.629   1.918  10.794  1.00  0.00           C  
ATOM    787  CG  MET A  55     -29.355   3.410  10.600  1.00  0.00           C  
ATOM    788  SD  MET A  55     -30.795   4.360  11.058  1.00  0.00           S  
ATOM    789  CE  MET A  55     -31.514   4.631   9.447  1.00  0.00           C  
ATOM    790  H   MET A  55     -27.340   1.737  11.662  1.00  0.00           H  
ATOM    791  HA  MET A  55     -29.792   2.160  12.952  1.00  0.00           H  
ATOM    792  HB3 MET A  55     -30.670   1.701  10.558  1.00  0.00           H  
ATOM    793  HG3 MET A  55     -29.095   3.607   9.559  1.00  0.00           H  
ATOM    794  HE1 MET A  55     -32.554   4.307   9.454  1.00  0.00           H  
ATOM    795  HE2 MET A  55     -31.465   5.692   9.201  1.00  0.00           H  
ATOM    796  HE3 MET A  55     -30.961   4.059   8.702  1.00  0.00           H  
ATOM    797  N   LYS A  56     -29.025  -0.893  12.007  1.00  0.00           N  
ATOM    798  CA  LYS A  56     -29.375  -2.296  12.149  1.00  0.00           C  
ATOM    799  C   LYS A  56     -29.487  -2.641  13.636  1.00  0.00           C  
ATOM    800  O   LYS A  56     -30.282  -3.496  14.021  1.00  0.00           O  
ATOM    801  CB  LYS A  56     -28.382  -3.176  11.387  1.00  0.00           C  
ATOM    802  CG  LYS A  56     -28.985  -4.550  11.088  1.00  0.00           C  
ATOM    803  CD  LYS A  56     -29.708  -4.549   9.739  1.00  0.00           C  
ATOM    804  CE  LYS A  56     -28.768  -4.979   8.612  1.00  0.00           C  
ATOM    805  NZ  LYS A  56     -29.533  -5.586   7.501  1.00  0.00           N  
ATOM    806  H   LYS A  56     -28.150  -0.719  11.555  1.00  0.00           H  
ATOM    807  HA  LYS A  56     -30.352  -2.438  11.688  1.00  0.00           H  
ATOM    808  HB3 LYS A  56     -27.472  -3.295  11.975  1.00  0.00           H  
ATOM    809  HG3 LYS A  56     -29.684  -4.825  11.878  1.00  0.00           H  
ATOM    810  HD3 LYS A  56     -30.097  -3.552   9.531  1.00  0.00           H  
ATOM    811  HE3 LYS A  56     -28.039  -5.695   8.993  1.00  0.00           H  
ATOM    812  HZ1 LYS A  56     -29.304  -5.121   6.645  1.00  0.00           H  
ATOM    813  HZ2 LYS A  56     -29.300  -6.556   7.425  1.00  0.00           H  
ATOM    814  HZ3 LYS A  56     -30.513  -5.491   7.680  1.00  0.00           H  
ATOM    815  N   ILE A  57     -28.678  -1.956  14.432  1.00  0.00           N  
ATOM    816  CA  ILE A  57     -28.677  -2.179  15.868  1.00  0.00           C  
ATOM    817  C   ILE A  57     -30.010  -1.711  16.454  1.00  0.00           C  
ATOM    818  O   ILE A  57     -30.554  -2.349  17.354  1.00  0.00           O  
ATOM    819  CB  ILE A  57     -27.457  -1.517  16.512  1.00  0.00           C  
ATOM    820  CG1 ILE A  57     -26.157  -2.100  15.952  1.00  0.00           C  
ATOM    821  CG2 ILE A  57     -27.520  -1.616  18.036  1.00  0.00           C  
ATOM    822  CD1 ILE A  57     -24.948  -1.276  16.401  1.00  0.00           C  
ATOM    823  H   ILE A  57     -28.035  -1.261  14.111  1.00  0.00           H  
ATOM    824  HA  ILE A  57     -28.585  -3.252  16.032  1.00  0.00           H  
ATOM    825  HB  ILE A  57     -27.469  -0.456  16.257  1.00  0.00           H  
ATOM    826 HG13 ILE A  57     -26.203  -2.120  14.863  1.00  0.00           H  
ATOM    827 HG21 ILE A  57     -27.001  -2.518  18.364  1.00  0.00           H  
ATOM    828 HG22 ILE A  57     -27.040  -0.742  18.478  1.00  0.00           H  
ATOM    829 HG23 ILE A  57     -28.561  -1.659  18.356  1.00  0.00           H  
ATOM    830 HD11 ILE A  57     -24.704  -0.541  15.634  1.00  0.00           H  
ATOM    831 HD12 ILE A  57     -25.185  -0.761  17.333  1.00  0.00           H  
ATOM    832 HD13 ILE A  57     -24.096  -1.937  16.556  1.00  0.00           H  
ATOM    833  N   LYS A  58     -30.499  -0.601  15.919  1.00  0.00           N  
ATOM    834  CA  LYS A  58     -31.759  -0.041  16.378  1.00  0.00           C  
ATOM    835  C   LYS A  58     -32.906  -0.953  15.940  1.00  0.00           C  
ATOM    836  O   LYS A  58     -33.833  -1.204  16.709  1.00  0.00           O  
ATOM    837  CB  LYS A  58     -31.907   1.405  15.902  1.00  0.00           C  
ATOM    838  CG  LYS A  58     -30.727   2.259  16.369  1.00  0.00           C  
ATOM    839  CD  LYS A  58     -30.908   3.721  15.953  1.00  0.00           C  
ATOM    840  CE  LYS A  58     -29.661   4.543  16.281  1.00  0.00           C  
ATOM    841  NZ  LYS A  58     -30.039   5.907  16.714  1.00  0.00           N  
ATOM    842  H   LYS A  58     -30.050  -0.089  15.187  1.00  0.00           H  
ATOM    843  HA  LYS A  58     -31.730  -0.021  17.467  1.00  0.00           H  
ATOM    844  HB3 LYS A  58     -32.837   1.824  16.285  1.00  0.00           H  
ATOM    845  HG3 LYS A  58     -29.800   1.870  15.946  1.00  0.00           H  
ATOM    846  HD3 LYS A  58     -31.772   4.143  16.466  1.00  0.00           H  
ATOM    847  HE3 LYS A  58     -29.015   4.600  15.405  1.00  0.00           H  
ATOM    848  HZ1 LYS A  58     -29.790   6.564  16.003  1.00  0.00           H  
ATOM    849  HZ2 LYS A  58     -31.026   5.945  16.873  1.00  0.00           H  
ATOM    850  HZ3 LYS A  58     -29.556   6.133  17.561  1.00  0.00           H  
ATOM    851  N   GLU A  59     -32.808  -1.425  14.706  1.00  0.00           N  
ATOM    852  CA  GLU A  59     -33.826  -2.304  14.157  1.00  0.00           C  
ATOM    853  C   GLU A  59     -33.812  -3.651  14.880  1.00  0.00           C  
ATOM    854  O   GLU A  59     -34.864  -4.183  15.231  1.00  0.00           O  
ATOM    855  CB  GLU A  59     -33.636  -2.488  12.650  1.00  0.00           C  
ATOM    856  CG  GLU A  59     -33.337  -1.152  11.966  1.00  0.00           C  
ATOM    857  CD  GLU A  59     -34.288  -0.911  10.792  1.00  0.00           C  
ATOM    858  OE1 GLU A  59     -34.600  -1.905  10.101  1.00  0.00           O  
ATOM    859  OE2 GLU A  59     -34.683   0.261  10.613  1.00  0.00           O  
ATOM    860  H   GLU A  59     -32.051  -1.216  14.086  1.00  0.00           H  
ATOM    861  HA  GLU A  59     -34.775  -1.797  14.337  1.00  0.00           H  
ATOM    862  HB3 GLU A  59     -34.535  -2.929  12.217  1.00  0.00           H  
ATOM    863  HG3 GLU A  59     -32.306  -1.144  11.612  1.00  0.00           H  
ATOM    864  N   LEU A  60     -32.607  -4.165  15.083  1.00  0.00           N  
ATOM    865  CA  LEU A  60     -32.442  -5.440  15.759  1.00  0.00           C  
ATOM    866  C   LEU A  60     -33.005  -5.337  17.177  1.00  0.00           C  
ATOM    867  O   LEU A  60     -33.773  -6.197  17.608  1.00  0.00           O  
ATOM    868  CB  LEU A  60     -30.980  -5.888  15.708  1.00  0.00           C  
ATOM    869  CG  LEU A  60     -30.427  -6.222  14.320  1.00  0.00           C  
ATOM    870  CD1 LEU A  60     -28.923  -5.954  14.250  1.00  0.00           C  
ATOM    871  CD2 LEU A  60     -30.773  -7.658  13.923  1.00  0.00           C  
ATOM    872  H   LEU A  60     -31.757  -3.726  14.794  1.00  0.00           H  
ATOM    873  HA  LEU A  60     -33.024  -6.180  15.208  1.00  0.00           H  
ATOM    874  HB3 LEU A  60     -30.867  -6.767  16.343  1.00  0.00           H  
ATOM    875  HG  LEU A  60     -30.906  -5.563  13.595  1.00  0.00           H  
ATOM    876 HD11 LEU A  60     -28.743  -5.043  13.679  1.00  0.00           H  
ATOM    877 HD12 LEU A  60     -28.527  -5.834  15.259  1.00  0.00           H  
ATOM    878 HD13 LEU A  60     -28.427  -6.792  13.762  1.00  0.00           H  
ATOM    879 HD21 LEU A  60     -29.904  -8.297  14.080  1.00  0.00           H  
ATOM    880 HD22 LEU A  60     -31.601  -8.015  14.536  1.00  0.00           H  
ATOM    881 HD23 LEU A  60     -31.060  -7.686  12.873  1.00  0.00           H  
ATOM    882  N   TYR A  61     -32.601  -4.280  17.864  1.00  0.00           N  
ATOM    883  CA  TYR A  61     -33.056  -4.053  19.226  1.00  0.00           C  
ATOM    884  C   TYR A  61     -34.551  -3.733  19.258  1.00  0.00           C  
ATOM    885  O   TYR A  61     -35.269  -4.190  20.146  1.00  0.00           O  
ATOM    886  CB  TYR A  61     -32.275  -2.840  19.736  1.00  0.00           C  
ATOM    887  CG  TYR A  61     -32.516  -2.520  21.212  1.00  0.00           C  
ATOM    888  CD1 TYR A  61     -31.832  -3.215  22.189  1.00  0.00           C  
ATOM    889  CD2 TYR A  61     -33.417  -1.538  21.567  1.00  0.00           C  
ATOM    890  CE1 TYR A  61     -32.059  -2.913  23.578  1.00  0.00           C  
ATOM    891  CE2 TYR A  61     -33.644  -1.236  22.956  1.00  0.00           C  
ATOM    892  CZ  TYR A  61     -32.954  -1.939  23.893  1.00  0.00           C  
ATOM    893  OH  TYR A  61     -33.168  -1.654  25.206  1.00  0.00           O  
ATOM    894  H   TYR A  61     -31.977  -3.586  17.507  1.00  0.00           H  
ATOM    895  HA  TYR A  61     -32.875  -4.964  19.797  1.00  0.00           H  
ATOM    896  HB3 TYR A  61     -32.544  -1.970  19.137  1.00  0.00           H  
ATOM    897  HD1 TYR A  61     -31.120  -3.991  21.909  1.00  0.00           H  
ATOM    898  HD2 TYR A  61     -33.957  -0.989  20.795  1.00  0.00           H  
ATOM    899  HE1 TYR A  61     -31.526  -3.454  24.361  1.00  0.00           H  
ATOM    900  HE2 TYR A  61     -34.353  -0.462  23.250  1.00  0.00           H  
ATOM    901  HH  TYR A  61     -32.574  -2.219  25.780  1.00  0.00           H  
ATOM    902  N   ARG A  62     -34.977  -2.947  18.279  1.00  0.00           N  
ATOM    903  CA  ARG A  62     -36.374  -2.560  18.184  1.00  0.00           C  
ATOM    904  C   ARG A  62     -37.270  -3.800  18.169  1.00  0.00           C  
ATOM    905  O   ARG A  62     -38.133  -3.957  19.030  1.00  0.00           O  
ATOM    906  CB  ARG A  62     -36.633  -1.737  16.921  1.00  0.00           C  
ATOM    907  CG  ARG A  62     -36.671  -0.241  17.239  1.00  0.00           C  
ATOM    908  CD  ARG A  62     -37.711   0.477  16.377  1.00  0.00           C  
ATOM    909  NE  ARG A  62     -39.011   0.520  17.084  1.00  0.00           N  
ATOM    910  CZ  ARG A  62     -40.092   1.169  16.630  1.00  0.00           C  
ATOM    911  NH1 ARG A  62     -40.036   1.834  15.468  1.00  0.00           N  
ATOM    912  NH2 ARG A  62     -41.228   1.154  17.339  1.00  0.00           N  
ATOM    913  H   ARG A  62     -34.386  -2.579  17.561  1.00  0.00           H  
ATOM    914  HA  ARG A  62     -36.557  -1.955  19.073  1.00  0.00           H  
ATOM    915  HB3 ARG A  62     -37.579  -2.041  16.471  1.00  0.00           H  
ATOM    916  HG3 ARG A  62     -35.687   0.196  17.066  1.00  0.00           H  
ATOM    917  HD3 ARG A  62     -37.824  -0.039  15.423  1.00  0.00           H  
ATOM    918  HE  ARG A  62     -39.087   0.034  17.954  1.00  0.00           H  
ATOM    919 HH11 ARG A  62     -39.186   1.846  14.940  1.00  0.00           H  
ATOM    920 HH12 ARG A  62     -40.842   2.320  15.130  1.00  0.00           H  
ATOM    921 HH21 ARG A  62     -41.271   0.657  18.206  1.00  0.00           H  
ATOM    922 HH22 ARG A  62     -42.036   1.639  17.001  1.00  0.00           H  
ATOM    923  N   ARG A  63     -37.032  -4.651  17.181  1.00  0.00           N  
ATOM    924  CA  ARG A  63     -37.805  -5.873  17.042  1.00  0.00           C  
ATOM    925  C   ARG A  63     -37.782  -6.667  18.349  1.00  0.00           C  
ATOM    926  O   ARG A  63     -38.651  -7.504  18.587  1.00  0.00           O  
ATOM    927  CB  ARG A  63     -37.258  -6.746  15.912  1.00  0.00           C  
ATOM    928  CG  ARG A  63     -37.746  -6.250  14.550  1.00  0.00           C  
ATOM    929  CD  ARG A  63     -37.148  -7.086  13.416  1.00  0.00           C  
ATOM    930  NE  ARG A  63     -37.781  -8.422  13.384  1.00  0.00           N  
ATOM    931  CZ  ARG A  63     -37.398  -9.416  12.571  1.00  0.00           C  
ATOM    932  NH1 ARG A  63     -36.383  -9.229  11.717  1.00  0.00           N  
ATOM    933  NH2 ARG A  63     -38.031 -10.597  12.611  1.00  0.00           N  
ATOM    934  H   ARG A  63     -36.327  -4.515  16.485  1.00  0.00           H  
ATOM    935  HA  ARG A  63     -38.815  -5.537  16.806  1.00  0.00           H  
ATOM    936  HB3 ARG A  63     -37.572  -7.779  16.062  1.00  0.00           H  
ATOM    937  HG3 ARG A  63     -37.470  -5.204  14.420  1.00  0.00           H  
ATOM    938  HD3 ARG A  63     -36.072  -7.187  13.556  1.00  0.00           H  
ATOM    939  HE  ARG A  63     -38.543  -8.596  14.009  1.00  0.00           H  
ATOM    940 HH11 ARG A  63     -35.911  -8.348  11.687  1.00  0.00           H  
ATOM    941 HH12 ARG A  63     -36.097  -9.971  11.109  1.00  0.00           H  
ATOM    942 HH21 ARG A  63     -38.789 -10.737  13.249  1.00  0.00           H  
ATOM    943 HH22 ARG A  63     -37.745 -11.338  12.004  1.00  0.00           H  
ATOM    944  N   ARG A  64     -36.777  -6.377  19.164  1.00  0.00           N  
ATOM    945  CA  ARG A  64     -36.629  -7.053  20.440  1.00  0.00           C  
ATOM    946  C   ARG A  64     -37.053  -6.129  21.583  1.00  0.00           C  
ATOM    947  O   ARG A  64     -36.701  -6.363  22.739  1.00  0.00           O  
ATOM    948  CB  ARG A  64     -35.182  -7.497  20.663  1.00  0.00           C  
ATOM    949  CG  ARG A  64     -34.839  -8.709  19.794  1.00  0.00           C  
ATOM    950  CD  ARG A  64     -33.773  -9.580  20.463  1.00  0.00           C  
ATOM    951  NE  ARG A  64     -34.310 -10.935  20.714  1.00  0.00           N  
ATOM    952  CZ  ARG A  64     -33.580 -11.960  21.172  1.00  0.00           C  
ATOM    953  NH1 ARG A  64     -32.276 -11.791  21.431  1.00  0.00           N  
ATOM    954  NH2 ARG A  64     -34.153 -13.156  21.370  1.00  0.00           N  
ATOM    955  H   ARG A  64     -36.075  -5.694  18.963  1.00  0.00           H  
ATOM    956  HA  ARG A  64     -37.284  -7.921  20.374  1.00  0.00           H  
ATOM    957  HB3 ARG A  64     -35.031  -7.745  21.714  1.00  0.00           H  
ATOM    958  HG3 ARG A  64     -34.482  -8.373  18.821  1.00  0.00           H  
ATOM    959  HD3 ARG A  64     -33.457  -9.124  21.401  1.00  0.00           H  
ATOM    960  HE  ARG A  64     -35.281 -11.096  20.530  1.00  0.00           H  
ATOM    961 HH11 ARG A  64     -31.849 -10.899  21.283  1.00  0.00           H  
ATOM    962 HH12 ARG A  64     -31.731 -12.556  21.772  1.00  0.00           H  
ATOM    963 HH21 ARG A  64     -35.125 -13.282  21.176  1.00  0.00           H  
ATOM    964 HH22 ARG A  64     -33.607 -13.920  21.712  1.00  0.00           H  
ATOM    965  N   PHE A  65     -37.805  -5.100  21.221  1.00  0.00           N  
ATOM    966  CA  PHE A  65     -38.282  -4.140  22.203  1.00  0.00           C  
ATOM    967  C   PHE A  65     -38.652  -4.834  23.514  1.00  0.00           C  
ATOM    968  O   PHE A  65     -39.629  -5.579  23.572  1.00  0.00           O  
ATOM    969  CB  PHE A  65     -39.533  -3.484  21.615  1.00  0.00           C  
ATOM    970  CG  PHE A  65     -39.476  -1.955  21.579  1.00  0.00           C  
ATOM    971  CD1 PHE A  65     -38.879  -1.322  20.535  1.00  0.00           C  
ATOM    972  CD2 PHE A  65     -40.022  -1.231  22.592  1.00  0.00           C  
ATOM    973  CE1 PHE A  65     -38.826   0.097  20.501  1.00  0.00           C  
ATOM    974  CE2 PHE A  65     -39.970   0.188  22.559  1.00  0.00           C  
ATOM    975  CZ  PHE A  65     -39.373   0.822  21.514  1.00  0.00           C  
ATOM    976  H   PHE A  65     -38.087  -4.917  20.280  1.00  0.00           H  
ATOM    977  HA  PHE A  65     -37.472  -3.433  22.384  1.00  0.00           H  
ATOM    978  HB3 PHE A  65     -40.400  -3.791  22.200  1.00  0.00           H  
ATOM    979  HD1 PHE A  65     -38.441  -1.902  19.723  1.00  0.00           H  
ATOM    980  HD2 PHE A  65     -40.501  -1.739  23.429  1.00  0.00           H  
ATOM    981  HE1 PHE A  65     -38.348   0.605  19.665  1.00  0.00           H  
ATOM    982  HE2 PHE A  65     -40.409   0.769  23.370  1.00  0.00           H  
ATOM    983  HZ  PHE A  65     -39.332   1.910  21.488  1.00  0.00           H  
TER     984      PHE A  65                                                      
END
MOLECULE T0416_124_193.pdb
ATOM    896  N   SER   124     -12.938  10.075  20.918  1.00 66.91          
ATOM    897  CA  SER   124     -13.725  11.186  21.451  1.00 66.33          
ATOM    898  C   SER   124     -14.733  10.696  22.481  1.00 66.44          
ATOM    899  O   SER   124     -15.411   9.690  22.258  1.00 67.08          
ATOM    900  CB  SER   124     -14.486  11.890  20.336  1.00 66.30          
ATOM    901  OG  SER   124     -15.382  12.835  20.894  1.00 66.11          
ATOM    902  N   GLU   125     -14.860  11.418  23.594  1.00 65.67          
ATOM    903  CA  GLU   125     -15.791  11.024  24.660  1.00 64.85          
ATOM    904  C   GLU   125     -17.257  10.952  24.245  1.00 63.97          
ATOM    905  O   GLU   125     -18.090  10.378  24.961  1.00 62.77          
ATOM    906  CB  GLU   125     -15.630  11.952  25.861  1.00 66.19          
ATOM    907  CG  GLU   125     -14.374  11.659  26.668  1.00 68.20          
ATOM    908  CD  GLU   125     -14.374  10.258  27.268  1.00 69.32          
ATOM    909  OE1 GLU   125     -14.392   9.275  26.493  1.00 69.15          
ATOM    910  OE2 GLU   125     -14.363  10.143  28.516  1.00 70.12          
ATOM    911  N   ASP   126     -17.563  11.539  23.090  1.00 63.11          
ATOM    912  CA  ASP   126     -18.916  11.526  22.541  1.00 62.19          
ATOM    913  C   ASP   126     -19.249  10.114  22.054  1.00 61.82          
ATOM    914  O   ASP   126     -20.285   9.543  22.428  1.00 61.51          
ATOM    915  CB  ASP   126     -19.028  12.529  21.381  1.00 62.35          
ATOM    916  CG  ASP   126     -19.470  13.910  21.845  1.00 62.68          
ATOM    917  OD1 ASP   126     -19.466  14.856  21.011  1.00 61.69          
ATOM    918  OD2 ASP   126     -19.833  14.039  23.043  1.00 61.31          
ATOM    919  N   LYS   127     -18.366   9.566  21.214  1.00 61.23          
ATOM    920  CA  LYS   127     -18.529   8.212  20.676  1.00 60.42          
ATOM    921  C   LYS   127     -18.652   7.252  21.871  1.00 60.93          
ATOM    922  O   LYS   127     -19.325   6.230  21.793  1.00 60.62          
ATOM    923  CB  LYS   127     -17.318   7.827  19.788  1.00 58.45          
ATOM    924  CG  LYS   127     -17.678   7.169  18.429  1.00 54.27          
ATOM    925  CD  LYS   127     -18.348   8.164  17.472  1.00 52.50          
ATOM    926  CE  LYS   127     -19.339   7.499  16.496  1.00 51.01          
ATOM    927  NZ  LYS   127     -18.723   6.555  15.506  1.00 50.46          
ATOM    928  N   MET   128     -18.006   7.598  22.980  1.00 62.10          
ATOM    929  CA  MET   128     -18.078   6.778  24.177  1.00 64.35          
ATOM    930  C   MET   128     -19.524   6.532  24.569  1.00 64.88          
ATOM    931  O   MET   128     -19.874   5.440  25.016  1.00 64.79          
ATOM    932  CB  MET   128     -17.377   7.462  25.346  1.00 66.54          
ATOM    933  CG  MET   128     -16.099   6.770  25.765  1.00 68.80          
ATOM    934  SD  MET   128     -15.094   6.519  24.295  1.00 73.23          
ATOM    935  CE  MET   128     -14.439   4.808  24.542  1.00 72.49          
ATOM    936  N   LYS   129     -20.354   7.560  24.408  1.00 65.38          
ATOM    937  CA  LYS   129     -21.775   7.483  24.748  1.00 65.72          
ATOM    938  C   LYS   129     -22.542   6.782  23.635  1.00 64.99          
ATOM    939  O   LYS   129     -23.348   5.881  23.884  1.00 63.53          
ATOM    940  CB  LYS   129     -22.346   8.897  24.961  1.00 66.78          
ATOM    941  CG  LYS   129     -23.637   8.929  25.789  1.00 67.90          
ATOM    942  CD  LYS   129     -24.057  10.358  26.170  1.00 68.42          
ATOM    943  CE  LYS   129     -24.947  10.398  27.435  1.00 67.03          
ATOM    944  NZ  LYS   129     -26.205   9.579  27.368  1.00 65.58          
ATOM    945  N   GLN   130     -22.277   7.214  22.407  1.00 65.95          
ATOM    946  CA  GLN   130     -22.915   6.655  21.219  1.00 67.43          
ATOM    947  C   GLN   130     -22.660   5.152  21.171  1.00 67.39          
ATOM    948  O   GLN   130     -23.593   4.359  21.084  1.00 68.50          
ATOM    949  CB  GLN   130     -22.343   7.330  19.955  1.00 68.41          
ATOM    950  CG  GLN   130     -23.098   7.071  18.627  1.00 70.03          
ATOM    951  CD  GLN   130     -22.745   5.738  17.947  1.00 71.57          
ATOM    952  OE1 GLN   130     -23.244   4.668  18.325  1.00 71.57          
ATOM    953  NE2 GLN   130     -21.874   5.804  16.940  1.00 71.62          
ATOM    954  N   VAL   131     -21.387   4.772  21.238  1.00 66.58          
ATOM    955  CA  VAL   131     -20.986   3.371  21.187  1.00 65.35          
ATOM    956  C   VAL   131     -21.528   2.550  22.350  1.00 64.95          
ATOM    957  O   VAL   131     -22.039   1.442  22.158  1.00 64.35          
ATOM    958  CB  VAL   131     -19.446   3.241  21.165  1.00 64.76          
ATOM    959  CG1 VAL   131     -19.034   1.776  21.307  1.00 64.29          
ATOM    960  CG2 VAL   131     -18.904   3.828  19.865  1.00 64.25          
ATOM    961  N   LYS   132     -21.407   3.095  23.556  1.00 64.52          
ATOM    962  CA  LYS   132     -21.870   2.401  24.746  1.00 63.79          
ATOM    963  C   LYS   132     -23.382   2.301  24.683  1.00 63.41          
ATOM    964  O   LYS   132     -23.942   1.220  24.848  1.00 63.23          
ATOM    965  CB  LYS   132     -21.438   3.153  26.008  1.00 63.88          
ATOM    966  CG  LYS   132     -21.323   2.277  27.262  1.00 64.17          
ATOM    967  CD  LYS   132     -20.167   1.271  27.157  1.00 63.23          
ATOM    968  CE  LYS   132     -20.067   0.376  28.398  1.00 62.19          
ATOM    969  NZ  LYS   132     -18.860  -0.514  28.418  1.00 60.60          
ATOM    970  N   LEU   133     -24.043   3.424  24.426  1.00 62.79          
ATOM    971  CA  LEU   133     -25.494   3.416  24.348  1.00 63.16          
ATOM    972  C   LEU   133     -26.001   2.454  23.307  1.00 62.80          
ATOM    973  O   LEU   133     -26.953   1.720  23.553  1.00 63.48          
ATOM    974  CB  LEU   133     -26.022   4.804  24.034  1.00 63.78          
ATOM    975  CG  LEU   133     -26.133   5.667  25.284  1.00 65.67          
ATOM    976  CD1 LEU   133     -26.473   7.083  24.864  1.00 64.46          
ATOM    977  CD2 LEU   133     -27.193   5.083  26.236  1.00 64.65          
ATOM    978  N   LYS   134     -25.361   2.468  22.142  1.00 61.59          
ATOM    979  CA  LYS   134     -25.742   1.606  21.021  1.00 60.31          
ATOM    980  C   LYS   134     -25.495   0.142  21.353  1.00 59.60          
ATOM    981  O   LYS   134     -26.238  -0.731  20.908  1.00 58.91          
ATOM    982  CB  LYS   134     -24.942   2.006  19.775  1.00 60.50          
ATOM    983  CG  LYS   134     -25.653   1.758  18.452  1.00 61.88          
ATOM    984  CD  LYS   134     -25.627   0.298  18.029  1.00 62.39          
ATOM    985  CE  LYS   134     -26.546   0.069  16.831  1.00 62.91          
ATOM    986  NZ  LYS   134     -27.969   0.307  17.216  1.00 62.99          
ATOM    987  N   LEU   135     -24.442  -0.114  22.132  1.00 59.47          
ATOM    988  CA  LEU   135     -24.085  -1.468  22.544  1.00 58.89          
ATOM    989  C   LEU   135     -25.131  -1.964  23.534  1.00 59.68          
ATOM    990  O   LEU   135     -25.637  -3.080  23.414  1.00 59.25          
ATOM    991  CB  LEU   135     -22.691  -1.488  23.185  1.00 57.73          
ATOM    992  CG  LEU   135     -21.465  -1.476  22.262  1.00 57.72          
ATOM    993  CD1 LEU   135     -20.191  -1.394  23.096  1.00 57.25          
ATOM    994  CD2 LEU   135     -21.446  -2.738  21.399  1.00 56.28          
ATOM    995  N   LYS   136     -25.461  -1.126  24.509  1.00 60.31          
ATOM    996  CA  LYS   136     -26.461  -1.495  25.490  1.00 61.60          
ATOM    997  C   LYS   136     -27.795  -1.716  24.769  1.00 61.92          
ATOM    998  O   LYS   136     -28.665  -2.426  25.263  1.00 62.21          
ATOM    999  CB  LYS   136     -26.573  -0.407  26.568  1.00 62.13          
ATOM   1000  CG  LYS   136     -27.535  -0.733  27.702  1.00 63.76          
ATOM   1001  CD  LYS   136     -27.217   0.069  28.965  1.00 65.36          
ATOM   1002  CE  LYS   136     -25.957  -0.447  29.665  1.00 65.43          
ATOM   1003  NZ  LYS   136     -25.655   0.301  30.924  1.00 65.26          
ATOM   1004  N   GLU   137     -27.952  -1.115  23.596  1.00 63.20          
ATOM   1005  CA  GLU   137     -29.175  -1.285  22.819  1.00 64.86          
ATOM   1006  C   GLU   137     -29.031  -2.531  21.953  1.00 64.04          
ATOM   1007  O   GLU   137     -29.911  -2.855  21.153  1.00 64.65          
ATOM   1008  CB  GLU   137     -29.442  -0.053  21.935  1.00 67.36          
ATOM   1009  CG  GLU   137     -29.845   1.203  22.737  1.00 71.13          
ATOM   1010  CD  GLU   137     -29.947   2.483  21.908  1.00 72.63          
ATOM   1011  OE1 GLU   137     -30.418   3.507  22.464  1.00 71.79          
ATOM   1012  OE2 GLU   137     -29.557   2.467  20.714  1.00 74.83          
ATOM   1013  N   LEU   138     -27.909  -3.228  22.112  1.00 61.98          
ATOM   1014  CA  LEU   138     -27.677  -4.450  21.352  1.00 60.49          
ATOM   1015  C   LEU   138     -27.739  -5.654  22.255  1.00 59.84          
ATOM   1016  O   LEU   138     -27.642  -6.787  21.788  1.00 59.02          
ATOM   1017  CB  LEU   138     -26.326  -4.423  20.645  1.00 59.00          
ATOM   1018  CG  LEU   138     -26.149  -3.449  19.481  1.00 58.35          
ATOM   1019  CD1 LEU   138     -24.751  -3.638  18.933  1.00 56.68          
ATOM   1020  CD2 LEU   138     -27.195  -3.692  18.394  1.00 58.65          
ATOM   1021  N   GLU   139     -27.901  -5.400  23.552  1.00 60.28          
ATOM   1022  CA  GLU   139     -27.989  -6.477  24.538  1.00 60.44          
ATOM   1023  C   GLU   139     -29.263  -7.273  24.260  1.00 60.55          
ATOM   1024  O   GLU   139     -29.338  -8.461  24.561  1.00 61.56          
ATOM   1025  CB  GLU   139     -28.026  -5.911  25.961  1.00 60.09          
ATOM   1026  CG  GLU   139     -26.713  -5.281  26.456  1.00 61.26          
ATOM   1027  CD  GLU   139     -26.808  -4.755  27.899  1.00 63.03          
ATOM   1028  OE1 GLU   139     -27.646  -3.853  28.151  1.00 64.07          
ATOM   1029  OE2 GLU   139     -26.043  -5.232  28.781  1.00 61.60          
ATOM   1030  N   HSD   140     -30.260  -6.617  23.678  1.00 60.11          
ATOM   1031  CA  HSD   140     -31.498  -7.293  23.355  1.00 60.38          
ATOM   1032  C   HSD   140     -31.248  -8.421  22.352  1.00 59.48          
ATOM   1033  O   HSD   140     -31.603  -9.575  22.595  1.00 59.97          
ATOM   1034  CB  HSD   140     -32.510  -6.306  22.773  1.00 63.06          
ATOM   1035  CG  HSD   140     -33.297  -6.867  21.626  1.00 66.83          
ATOM   1036  ND1 HSD   140     -34.111  -7.975  21.750  1.00 68.19          
ATOM   1037  CD2 HSD   140     -33.341  -6.515  20.317  1.00 68.47          
ATOM   1038  CE1 HSD   140     -34.622  -8.282  20.569  1.00 69.31          
ATOM   1039  NE2 HSD   140     -34.170  -7.412  19.681  1.00 70.23          
ATOM   1040  N   LEU   141     -30.637  -8.073  21.224  1.00 58.24          
ATOM   1041  CA  LEU   141     -30.346  -9.026  20.159  1.00 56.59          
ATOM   1042  C   LEU   141     -29.839 -10.361  20.651  1.00 55.85          
ATOM   1043  O   LEU   141     -28.954 -10.441  21.515  1.00 55.05          
ATOM   1044  CB  LEU   141     -29.317  -8.447  19.178  1.00 57.37          
ATOM   1045  CG  LEU   141     -29.736  -7.591  17.978  1.00 56.87          
ATOM   1046  CD1 LEU   141     -30.409  -6.294  18.427  1.00 56.40          
ATOM   1047  CD2 LEU   141     -28.487  -7.293  17.159  1.00 57.87          
ATOM   1048  N   ASN   142     -30.395 -11.421  20.087  1.00 54.83          
ATOM   1049  CA  ASN   142     -29.975 -12.761  20.468  1.00 54.91          
ATOM   1050  C   ASN   142     -28.557 -12.992  19.970  1.00 54.03          
ATOM   1051  O   ASN   142     -27.953 -12.119  19.352  1.00 54.04          
ATOM   1052  CB  ASN   142     -30.907 -13.789  19.845  1.00 54.37          
ATOM   1053  CG  ASN   142     -30.951 -13.677  18.352  1.00 55.03          
ATOM   1054  OD1 ASN   142     -29.988 -14.020  17.664  1.00 55.17          
ATOM   1055  ND2 ASN   142     -32.070 -13.178  17.830  1.00 56.72          
ATOM   1056  N   ASN   143     -28.032 -14.178  20.235  1.00 52.54          
ATOM   1057  CA  ASN   143     -26.685 -14.503  19.807  1.00 51.10          
ATOM   1058  C   ASN   143     -26.477 -14.428  18.298  1.00 51.34          
ATOM   1059  O   ASN   143     -25.471 -13.893  17.835  1.00 51.95          
ATOM   1060  CB  ASN   143     -26.305 -15.889  20.303  1.00 50.75          
ATOM   1061  CG  ASN   143     -25.279 -15.844  21.399  1.00 47.63          
ATOM   1062  OD1 ASN   143     -25.025 -16.852  22.057  1.00 45.70          
ATOM   1063  ND2 ASN   143     -24.675 -14.678  21.601  1.00 44.14          
ATOM   1064  N   ASN   144     -27.424 -14.962  17.532  1.00 50.90          
ATOM   1065  CA  ASN   144     -27.316 -14.951  16.074  1.00 49.29          
ATOM   1066  C   ASN   144     -27.674 -13.609  15.436  1.00 48.08          
ATOM   1067  O   ASN   144     -27.034 -13.189  14.471  1.00 47.71          
ATOM   1068  CB  ASN   144     -28.176 -16.066  15.452  1.00 48.61          
ATOM   1069  CG  ASN   144     -27.388 -17.362  15.202  1.00 48.40          
ATOM   1070  OD1 ASN   144     -26.485 -17.412  14.356  1.00 47.47          
ATOM   1071  ND2 ASN   144     -27.736 -18.415  15.938  1.00 47.00          
ATOM   1072  N   LYS   145     -28.680 -12.925  15.964  1.00 46.74          
ATOM   1073  CA  LYS   145     -29.062 -11.648  15.380  1.00 46.60          
ATOM   1074  C   LYS   145     -27.904 -10.662  15.505  1.00 44.53          
ATOM   1075  O   LYS   145     -27.649  -9.881  14.592  1.00 43.30          
ATOM   1076  CB  LYS   145     -30.316 -11.097  16.061  1.00 48.77          
ATOM   1077  CG  LYS   145     -31.100 -10.094  15.213  1.00 53.74          
ATOM   1078  CD  LYS   145     -32.313  -9.533  15.985  1.00 57.32          
ATOM   1079  CE  LYS   145     -33.127  -8.522  15.167  1.00 56.95          
ATOM   1080  NZ  LYS   145     -34.137  -7.842  16.025  1.00 57.25          
ATOM   1081  N   LEU   146     -27.197 -10.719  16.629  1.00 43.66          
ATOM   1082  CA  LEU   146     -26.054  -9.841  16.871  1.00 43.08          
ATOM   1083  C   LEU   146     -24.883 -10.213  15.965  1.00 42.35          
ATOM   1084  O   LEU   146     -24.055  -9.366  15.621  1.00 41.00          
ATOM   1085  CB  LEU   146     -25.603  -9.936  18.326  1.00 42.52          
ATOM   1086  CG  LEU   146     -24.344  -9.137  18.676  1.00 41.77          
ATOM   1087  CD1 LEU   146     -24.676  -7.662  18.687  1.00 40.23          
ATOM   1088  CD2 LEU   146     -23.803  -9.568  20.037  1.00 41.41          
ATOM   1089  N   HSD   147     -24.817 -11.493  15.601  1.00 42.50          
ATOM   1090  CA  HSD   147     -23.765 -12.011  14.726  1.00 41.68          
ATOM   1091  C   HSD   147     -24.009 -11.518  13.309  1.00 42.48          
ATOM   1092  O   HSD   147     -23.067 -11.144  12.613  1.00 40.88          
ATOM   1093  CB  HSD   147     -23.767 -13.540  14.744  1.00 40.73          
ATOM   1094  CG  HSD   147     -22.597 -14.158  14.040  1.00 41.03          
ATOM   1095  ND1 HSD   147     -21.295 -13.969  14.451  1.00 40.48          
ATOM   1096  CD2 HSD   147     -22.535 -14.999  12.980  1.00 40.08          
ATOM   1097  CE1 HSD   147     -20.482 -14.669  13.682  1.00 39.24          
ATOM   1098  NE2 HSD   147     -21.210 -15.303  12.781  1.00 38.96          
ATOM   1099  N   GLU   148     -25.281 -11.538  12.893  1.00 44.54          
ATOM   1100  CA  GLU   148     -25.681 -11.082  11.557  1.00 46.10          
ATOM   1101  C   GLU   148     -25.210  -9.637  11.454  1.00 45.31          
ATOM   1102  O   GLU   148     -24.586  -9.239  10.472  1.00 45.45          
ATOM   1103  CB  GLU   148     -27.216 -11.087  11.362  1.00 48.95          
ATOM   1104  CG  GLU   148     -28.013 -12.385  11.682  1.00 53.59          
ATOM   1105  CD  GLU   148     -27.643 -13.609  10.839  1.00 55.67          
ATOM   1106  OE1 GLU   148     -28.321 -14.664  10.985  1.00 55.75          
ATOM   1107  OE2 GLU   148     -26.677 -13.526  10.042  1.00 56.38          
ATOM   1108  N   TYR   149     -25.530  -8.866  12.489  1.00 43.61          
ATOM   1109  CA  TYR   149     -25.166  -7.463  12.573  1.00 41.58          
ATOM   1110  C   TYR   149     -23.676  -7.282  12.381  1.00 40.76          
ATOM   1111  O   TYR   149     -23.240  -6.398  11.657  1.00 41.07          
ATOM   1112  CB  TYR   149     -25.575  -6.892  13.931  1.00 40.50          
ATOM   1113  CG  TYR   149     -25.172  -5.458  14.114  1.00 41.41          
ATOM   1114  CD1 TYR   149     -25.630  -4.477  13.243  1.00 42.25          
ATOM   1115  CD2 TYR   149     -24.317  -5.077  15.149  1.00 42.66          
ATOM   1116  CE1 TYR   149     -25.250  -3.147  13.390  1.00 45.05          
ATOM   1117  CE2 TYR   149     -23.929  -3.739  15.309  1.00 43.90          
ATOM   1118  CZ  TYR   149     -24.403  -2.782  14.422  1.00 44.94          
ATOM   1119  OH  TYR   149     -24.051  -1.455  14.556  1.00 46.88          
ATOM   1120  N   LEU   150     -22.887  -8.123  13.032  1.00 40.67          
ATOM   1121  CA  LEU   150     -21.441  -8.020  12.910  1.00 40.36          
ATOM   1122  C   LEU   150     -21.042  -8.327  11.466  1.00 42.74          
ATOM   1123  O   LEU   150     -20.262  -7.583  10.867  1.00 44.62          
ATOM   1124  CB  LEU   150     -20.766  -8.990  13.885  1.00 38.33          
ATOM   1125  CG  LEU   150     -19.309  -8.833  14.343  1.00 36.05          
ATOM   1126  CD1 LEU   150     -18.563 -10.129  14.042  1.00 33.03          
ATOM   1127  CD2 LEU   150     -18.628  -7.638  13.676  1.00 33.64          
ATOM   1128  N   ALA   151     -21.597  -9.403  10.901  1.00 43.61          
ATOM   1129  CA  ALA   151     -21.312  -9.817   9.518  1.00 43.09          
ATOM   1130  C   ALA   151     -21.413  -8.672   8.507  1.00 44.48          
ATOM   1131  O   ALA   151     -20.549  -8.511   7.642  1.00 45.40          
ATOM   1132  CB  ALA   151     -22.257 -10.941   9.113  1.00 41.14          
ATOM   1133  N   SER   152     -22.479  -7.888   8.620  1.00 43.95          
ATOM   1134  CA  SER   152     -22.709  -6.763   7.733  1.00 43.02          
ATOM   1135  C   SER   152     -21.483  -5.847   7.622  1.00 44.27          
ATOM   1136  O   SER   152     -21.253  -5.267   6.574  1.00 44.19          
ATOM   1137  CB  SER   152     -23.878  -5.940   8.241  1.00 41.09          
ATOM   1138  OG  SER   152     -23.456  -5.155   9.330  1.00 39.42          
ATOM   1139  N   PHE   153     -20.707  -5.704   8.695  1.00 46.29          
ATOM   1140  CA  PHE   153     -19.535  -4.837   8.665  1.00 46.52          
ATOM   1141  C   PHE   153     -18.287  -5.594   8.349  1.00 45.24          
ATOM   1142  O   PHE   153     -17.725  -5.466   7.274  1.00 46.68          
ATOM   1143  CB  PHE   153     -19.295  -4.147  10.007  1.00 50.92          
ATOM   1144  CG  PHE   153     -20.430  -3.324  10.473  1.00 55.72          
ATOM   1145  CD1 PHE   153     -21.059  -2.438   9.599  1.00 57.94          
ATOM   1146  CD2 PHE   153     -20.904  -3.453  11.778  1.00 57.22          
ATOM   1147  CE1 PHE   153     -22.166  -1.681  10.009  1.00 60.91          
ATOM   1148  CE2 PHE   153     -22.007  -2.706  12.205  1.00 60.66          
ATOM   1149  CZ  PHE   153     -22.648  -1.814  11.318  1.00 61.35          
ATOM   1150  N   ASP   154     -17.851  -6.389   9.307  1.00 44.46          
ATOM   1151  CA  ASP   154     -16.627  -7.145   9.155  1.00 44.03          
ATOM   1152  C   ASP   154     -16.916  -8.604   8.857  1.00 44.66          
ATOM   1153  O   ASP   154     -17.169  -9.400   9.760  1.00 46.30          
ATOM   1154  CB  ASP   154     -15.802  -6.991  10.432  1.00 40.35          
ATOM   1155  CG  ASP   154     -14.444  -7.596  10.315  1.00 38.26          
ATOM   1156  OD1 ASP   154     -13.612  -7.307  11.192  1.00 37.00          
ATOM   1157  OD2 ASP   154     -14.220  -8.365   9.357  1.00 36.25          
ATOM   1158  N   LYS   155     -16.882  -8.948   7.578  1.00 45.57          
ATOM   1159  CA  LYS   155     -17.166 -10.306   7.149  1.00 46.03          
ATOM   1160  C   LYS   155     -16.097 -11.261   7.670  1.00 46.09          
ATOM   1161  O   LYS   155     -16.402 -12.360   8.140  1.00 45.24          
ATOM   1162  CB  LYS   155     -17.235 -10.355   5.624  1.00 46.65          
ATOM   1163  CG  LYS   155     -17.992 -11.545   5.061  1.00 49.84          
ATOM   1164  CD  LYS   155     -19.483 -11.515   5.419  1.00 52.98          
ATOM   1165  CE  LYS   155     -20.240 -10.392   4.700  1.00 55.25          
ATOM   1166  NZ  LYS   155     -21.720 -10.560   4.836  1.00 54.84          
ATOM   1167  N   GLU   156     -14.843 -10.833   7.605  1.00 47.07          
ATOM   1168  CA  GLU   156     -13.743 -11.664   8.072  1.00 47.44          
ATOM   1169  C   GLU   156     -13.878 -12.051   9.547  1.00 46.57          
ATOM   1170  O   GLU   156     -13.627 -13.201   9.905  1.00 46.78          
ATOM   1171  CB  GLU   156     -12.414 -10.949   7.833  1.00 48.84          
ATOM   1172  CG  GLU   156     -11.222 -11.748   8.310  1.00 52.49          
ATOM   1173  CD  GLU   156      -9.988 -11.458   7.485  1.00 54.35          
ATOM   1174  OE1 GLU   156     -10.090 -11.532   6.245  1.00 58.09          
ATOM   1175  OE2 GLU   156      -8.920 -11.187   8.062  1.00 54.82          
ATOM   1176  N   SER   157     -14.277 -11.102  10.393  1.00 44.68          
ATOM   1177  CA  SER   157     -14.438 -11.379  11.821  1.00 44.35          
ATOM   1178  C   SER   157     -15.594 -12.334  12.114  1.00 45.30          
ATOM   1179  O   SER   157     -15.401 -13.388  12.728  1.00 44.77          
ATOM   1180  CB  SER   157     -14.652 -10.084  12.614  1.00 43.50          
ATOM   1181  OG  SER   157     -13.426  -9.587  13.163  1.00 41.65          
ATOM   1182  N   ALA   158     -16.799 -11.968  11.681  1.00 46.08          
ATOM   1183  CA  ALA   158     -17.972 -12.808  11.918  1.00 46.61          
ATOM   1184  C   ALA   158     -17.782 -14.182  11.285  1.00 46.98          
ATOM   1185  O   ALA   158     -18.441 -15.148  11.667  1.00 47.03          
ATOM   1186  CB  ALA   158     -19.222 -12.137  11.360  1.00 46.19          
ATOM   1187  N   LYS   159     -16.882 -14.265  10.314  1.00 47.17          
ATOM   1188  CA  LYS   159     -16.617 -15.532   9.659  1.00 47.95          
ATOM   1189  C   LYS   159     -16.084 -16.554  10.674  1.00 48.43          
ATOM   1190  O   LYS   159     -16.725 -17.562  10.935  1.00 47.95          
ATOM   1191  CB  LYS   159     -15.613 -15.349   8.515  1.00 48.84          
ATOM   1192  CG  LYS   159     -15.352 -16.607   7.692  1.00 49.96          
ATOM   1193  CD  LYS   159     -14.180 -16.419   6.731  1.00 51.69          
ATOM   1194  CE  LYS   159     -13.827 -17.718   6.003  1.00 52.69          
ATOM   1195  NZ  LYS   159     -12.638 -17.569   5.091  1.00 52.32          
ATOM   1196  N   ASP   160     -14.932 -16.295  11.271  1.00 48.98          
ATOM   1197  CA  ASP   160     -14.382 -17.248  12.228  1.00 51.03          
ATOM   1198  C   ASP   160     -15.009 -17.222  13.642  1.00 50.71          
ATOM   1199  O   ASP   160     -15.180 -18.277  14.262  1.00 53.86          
ATOM   1200  CB  ASP   160     -12.905 -17.021  12.370  1.00 54.40          
ATOM   1201  CG  ASP   160     -12.617 -15.636  12.792  1.00 58.23          
ATOM   1202  OD1 ASP   160     -12.361 -14.787  11.899  1.00 61.10          
ATOM   1203  OD2 ASP   160     -12.691 -15.392  14.021  1.00 59.34          
ATOM   1204  N   ILE   161     -15.315 -16.041  14.178  1.00 45.84          
ATOM   1205  CA  ILE   161     -15.927 -15.953  15.502  1.00 40.53          
ATOM   1206  C   ILE   161     -17.314 -16.633  15.504  1.00 39.65          
ATOM   1207  O   ILE   161     -18.226 -16.197  14.804  1.00 39.20          
ATOM   1208  CB  ILE   161     -16.062 -14.460  15.934  1.00 38.90          
ATOM   1209  CG1 ILE   161     -14.687 -13.825  16.044  1.00 35.98          
ATOM   1210  CG2 ILE   161     -16.772 -14.341  17.269  1.00 36.37          
ATOM   1211  CD  ILE   161     -14.720 -12.400  16.489  1.00 33.71          
ATOM   1212  N   HSD   162     -17.471 -17.709  16.271  1.00 38.17          
ATOM   1213  CA  HSD   162     -18.751 -18.414  16.314  1.00 38.14          
ATOM   1214  C   HSD   162     -19.801 -17.531  17.014  1.00 38.02          
ATOM   1215  O   HSD   162     -19.507 -16.872  18.008  1.00 37.83          
ATOM   1216  CB  HSD   162     -18.564 -19.744  17.038  1.00 40.06          
ATOM   1217  CG  HSD   162     -19.787 -20.607  17.055  1.00 42.92          
ATOM   1218  ND1 HSD   162     -20.884 -20.323  17.839  1.00 42.82          
ATOM   1219  CD2 HSD   162     -20.085 -21.750  16.389  1.00 43.64          
ATOM   1220  CE1 HSD   162     -21.805 -21.254  17.658  1.00 43.92          
ATOM   1221  NE2 HSD   162     -21.346 -22.131  16.783  1.00 44.29          
ATOM   1222  N   PRO   163     -21.044 -17.497  16.496  1.00 38.50          
ATOM   1223  CA  PRO   163     -22.101 -16.662  17.098  1.00 37.81          
ATOM   1224  C   PRO   163     -22.438 -16.846  18.579  1.00 38.11          
ATOM   1225  O   PRO   163     -23.148 -16.025  19.185  1.00 37.43          
ATOM   1226  CB  PRO   163     -23.311 -16.876  16.164  1.00 37.81          
ATOM   1227  CG  PRO   163     -23.024 -18.143  15.442  1.00 37.48          
ATOM   1228  CD  PRO   163     -21.523 -18.179  15.280  1.00 37.98          
ATOM   1229  N   ASN   164     -21.901 -17.902  19.175  1.00 38.11          
ATOM   1230  CA  ASN   164     -22.152 -18.172  20.583  1.00 37.10          
ATOM   1231  C   ASN   164     -21.058 -17.586  21.464  1.00 36.94          
ATOM   1232  O   ASN   164     -21.117 -17.680  22.693  1.00 38.67          
ATOM   1233  CB  ASN   164     -22.298 -19.684  20.822  1.00 37.14          
ATOM   1234  CG  ASN   164     -23.704 -20.193  20.496  1.00 37.37          
ATOM   1235  OD1 ASN   164     -23.986 -21.391  20.574  1.00 36.48          
ATOM   1236  ND2 ASN   164     -24.597 -19.270  20.143  1.00 37.37          
ATOM   1237  N   ASN   165     -20.063 -16.966  20.846  1.00 35.45          
ATOM   1238  CA  ASN   165     -18.992 -16.342  21.616  1.00 35.14          
ATOM   1239  C   ASN   165     -19.281 -14.845  21.670  1.00 34.41          
ATOM   1240  O   ASN   165     -18.479 -14.029  21.213  1.00 34.23          
ATOM   1241  CB  ASN   165     -17.648 -16.569  20.938  1.00 34.78          
ATOM   1242  CG  ASN   165     -16.496 -16.117  21.797  1.00 34.96          
ATOM   1243  OD1 ASN   165     -16.675 -15.306  22.709  1.00 37.78          
ATOM   1244  ND2 ASN   165     -15.311 -16.631  21.521  1.00 31.57          
ATOM   1245  N   ARG   166     -20.426 -14.496  22.245  1.00 33.71          
ATOM   1246  CA  ARG   166     -20.849 -13.113  22.309  1.00 32.41          
ATOM   1247  C   ARG   166     -19.733 -12.155  22.656  1.00 32.61          
ATOM   1248  O   ARG   166     -19.642 -11.074  22.076  1.00 32.21          
ATOM   1249  CB  ARG   166     -21.992 -12.942  23.297  1.00 30.27          
ATOM   1250  CG  ARG   166     -22.816 -11.708  23.021  1.00 29.21          
ATOM   1251  CD  ARG   166     -23.700 -11.362  24.197  1.00 30.19          
ATOM   1252  NE  ARG   166     -24.705 -10.336  23.902  1.00 31.36          
ATOM   1253  CZ  ARG   166     -25.688 -10.484  23.017  1.00 33.14          
ATOM   1254  NH1 ARG   166     -26.551  -9.500  22.828  1.00 35.67          
ATOM   1255  NH2 ARG   166     -25.800 -11.608  22.312  1.00 30.80          
ATOM   1256  N   LYS   167     -18.877 -12.542  23.589  1.00 33.69          
ATOM   1257  CA  LYS   167     -17.775 -11.661  23.971  1.00 36.30          
ATOM   1258  C   LYS   167     -16.971 -11.168  22.771  1.00 36.89          
ATOM   1259  O   LYS   167     -16.958  -9.971  22.465  1.00 37.20          
ATOM   1260  CB  LYS   167     -16.825 -12.363  24.929  1.00 34.08          
ATOM   1261  CG  LYS   167     -16.759 -11.698  26.264  1.00 34.45          
ATOM   1262  CD  LYS   167     -15.974 -10.417  26.243  1.00 33.65          
ATOM   1263  CE  LYS   167     -15.601 -10.054  27.685  1.00 33.89          
ATOM   1264  NZ  LYS   167     -14.855  -8.773  27.807  1.00 33.04          
ATOM   1265  N   ARG   168     -16.287 -12.087  22.097  1.00 37.07          
ATOM   1266  CA  ARG   168     -15.487 -11.682  20.963  1.00 38.08          
ATOM   1267  C   ARG   168     -16.281 -10.931  19.891  1.00 36.42          
ATOM   1268  O   ARG   168     -15.737 -10.044  19.235  1.00 36.69          
ATOM   1269  CB  ARG   168     -14.766 -12.879  20.357  1.00 41.03          
ATOM   1270  CG  ARG   168     -13.407 -13.128  20.990  1.00 45.62          
ATOM   1271  CD  ARG   168     -12.527 -13.985  20.078  1.00 50.99          
ATOM   1272  NE  ARG   168     -12.404 -13.415  18.727  1.00 53.70          
ATOM   1273  CZ  ARG   168     -11.631 -13.931  17.771  1.00 55.38          
ATOM   1274  NH1 ARG   168     -10.914 -15.028  18.016  1.00 57.21          
ATOM   1275  NH2 ARG   168     -11.565 -13.350  16.582  1.00 54.50          
ATOM   1276  N   VAL   169     -17.561 -11.265  19.729  1.00 33.11          
ATOM   1277  CA  VAL   169     -18.382 -10.597  18.739  1.00 30.14          
ATOM   1278  C   VAL   169     -18.615  -9.149  19.134  1.00 30.72          
ATOM   1279  O   VAL   169     -18.548  -8.250  18.286  1.00 29.71          
ATOM   1280  CB  VAL   169     -19.748 -11.304  18.540  1.00 29.95          
ATOM   1281  CG1 VAL   169     -20.608 -10.549  17.531  1.00 27.38          
ATOM   1282  CG2 VAL   169     -19.529 -12.726  18.044  1.00 31.20          
ATOM   1283  N   LEU   170     -18.890  -8.899  20.407  1.00 30.04          
ATOM   1284  CA  LEU   170     -19.100  -7.514  20.837  1.00 31.78          
ATOM   1285  C   LEU   170     -17.812  -6.713  20.679  1.00 32.26          
ATOM   1286  O   LEU   170     -17.832  -5.590  20.193  1.00 31.14          
ATOM   1287  CB  LEU   170     -19.562  -7.447  22.302  1.00 31.59          
ATOM   1288  CG  LEU   170     -21.026  -7.795  22.568  1.00 30.71          
ATOM   1289  CD1 LEU   170     -21.256  -7.893  24.080  1.00 28.84          
ATOM   1290  CD2 LEU   170     -21.933  -6.754  21.925  1.00 27.36          
ATOM   1291  N   ARG   171     -16.699  -7.302  21.092  1.00 34.25          
ATOM   1292  CA  ARG   171     -15.422  -6.640  20.979  1.00 36.98          
ATOM   1293  C   ARG   171     -15.210  -6.145  19.549  1.00 37.43          
ATOM   1294  O   ARG   171     -14.694  -5.052  19.332  1.00 39.16          
ATOM   1295  CB  ARG   171     -14.314  -7.601  21.361  1.00 39.39          
ATOM   1296  CG  ARG   171     -13.497  -7.113  22.520  1.00 42.67          
ATOM   1297  CD  ARG   171     -12.087  -6.785  22.073  1.00 45.67          
ATOM   1298  NE  ARG   171     -11.985  -5.647  21.143  1.00 47.47          
ATOM   1299  CZ  ARG   171     -12.293  -4.387  21.443  1.00 48.05          
ATOM   1300  NH1 ARG   171     -12.144  -3.441  20.530  1.00 47.11          
ATOM   1301  NH2 ARG   171     -12.760  -4.078  22.650  1.00 49.89          
ATOM   1302  N   ALA   172     -15.614  -6.953  18.577  1.00 35.61          
ATOM   1303  CA  ALA   172     -15.481  -6.576  17.187  1.00 35.25          
ATOM   1304  C   ALA   172     -16.477  -5.458  16.879  1.00 36.71          
ATOM   1305  O   ALA   172     -16.109  -4.415  16.338  1.00 37.48          
ATOM   1306  CB  ALA   172     -15.734  -7.777  16.289  1.00 32.85          
ATOM   1307  N   ILE   173     -17.743  -5.665  17.224  1.00 37.62          
ATOM   1308  CA  ILE   173     -18.765  -4.650  16.998  1.00 37.83          
ATOM   1309  C   ILE   173     -18.416  -3.367  17.753  1.00 39.58          
ATOM   1310  O   ILE   173     -18.625  -2.263  17.257  1.00 40.26          
ATOM   1311  CB  ILE   173     -20.130  -5.165  17.457  1.00 37.44          
ATOM   1312  CG1 ILE   173     -20.524  -6.347  16.579  1.00 36.68          
ATOM   1313  CG2 ILE   173     -21.168  -4.060  17.385  1.00 37.08          
ATOM   1314  CD  ILE   173     -21.665  -7.133  17.123  1.00 37.12          
ATOM   1315  N   GLU   174     -17.868  -3.521  18.950  1.00 41.38          
ATOM   1316  CA  GLU   174     -17.465  -2.384  19.767  1.00 43.55          
ATOM   1317  C   GLU   174     -16.356  -1.559  19.098  1.00 43.27          
ATOM   1318  O   GLU   174     -16.426  -0.329  19.050  1.00 43.09          
ATOM   1319  CB  GLU   174     -16.977  -2.889  21.119  1.00 46.69          
ATOM   1320  CG  GLU   174     -16.522  -1.807  22.067  1.00 50.53          
ATOM   1321  CD  GLU   174     -15.930  -2.361  23.351  1.00 52.28          
ATOM   1322  OE1 GLU   174     -15.548  -1.525  24.211  1.00 54.03          
ATOM   1323  OE2 GLU   174     -15.845  -3.613  23.493  1.00 50.47          
ATOM   1324  N   TYR   175     -15.334  -2.247  18.591  1.00 42.52          
ATOM   1325  CA  TYR   175     -14.191  -1.623  17.920  1.00 42.15          
ATOM   1326  C   TYR   175     -14.602  -0.815  16.688  1.00 42.82          
ATOM   1327  O   TYR   175     -14.178   0.328  16.509  1.00 41.65          
ATOM   1328  CB  TYR   175     -13.198  -2.705  17.504  1.00 40.87          
ATOM   1329  CG  TYR   175     -12.031  -2.175  16.728  1.00 39.46          
ATOM   1330  CD1 TYR   175     -10.944  -1.594  17.373  1.00 39.66          
ATOM   1331  CD2 TYR   175     -12.019  -2.240  15.347  1.00 38.81          
ATOM   1332  CE1 TYR   175      -9.868  -1.088  16.655  1.00 38.85          
ATOM   1333  CE2 TYR   175     -10.959  -1.745  14.621  1.00 39.34          
ATOM   1334  CZ  TYR   175      -9.883  -1.169  15.269  1.00 39.36          
ATOM   1335  OH  TYR   175      -8.833  -0.693  14.513  1.00 37.95          
ATOM   1336  N   TYR   176     -15.411  -1.442  15.836  1.00 44.41          
ATOM   1337  CA  TYR   176     -15.933  -0.832  14.618  1.00 45.49          
ATOM   1338  C   TYR   176     -16.674   0.460  14.945  1.00 45.53          
ATOM   1339  O   TYR   176     -16.310   1.530  14.477  1.00 44.38          
ATOM   1340  CB  TYR   176     -16.913  -1.791  13.932  1.00 47.64          
ATOM   1341  CG  TYR   176     -17.612  -1.165  12.752  1.00 49.86          
ATOM   1342  CD1 TYR   176     -16.874  -0.617  11.706  1.00 51.59          
ATOM   1343  CD2 TYR   176     -19.000  -1.081  12.692  1.00 49.62          
ATOM   1344  CE1 TYR   176     -17.494   0.002  10.629  1.00 52.80          
ATOM   1345  CE2 TYR   176     -19.636  -0.454  11.617  1.00 50.23          
ATOM   1346  CZ  TYR   176     -18.877   0.082  10.586  1.00 52.43          
ATOM   1347  OH  TYR   176     -19.465   0.693   9.497  1.00 52.70          
ATOM   1348  N   LEU   177     -17.729   0.334  15.748  1.00 46.39          
ATOM   1349  CA  LEU   177     -18.546   1.474  16.144  1.00 46.79          
ATOM   1350  C   LEU   177     -17.741   2.687  16.630  1.00 47.43          
ATOM   1351  O   LEU   177     -18.183   3.817  16.457  1.00 49.31          
ATOM   1352  CB  LEU   177     -19.551   1.073  17.231  1.00 46.21          
ATOM   1353  CG  LEU   177     -21.051   0.932  16.888  1.00 47.05          
ATOM   1354  CD1 LEU   177     -21.474   1.970  15.833  1.00 45.70          
ATOM   1355  CD2 LEU   177     -21.331  -0.467  16.390  1.00 47.61          
ATOM   1356  N   LYS   178     -16.575   2.456  17.233  1.00 46.93          
ATOM   1357  CA  LYS   178     -15.737   3.542  17.721  1.00 46.18          
ATOM   1358  C   LYS   178     -14.829   4.117  16.630  1.00 47.31          
ATOM   1359  O   LYS   178     -14.935   5.294  16.256  1.00 46.69          
ATOM   1360  CB  LYS   178     -14.875   3.072  18.894  1.00 45.63          
ATOM   1361  CG  LYS   178     -15.634   2.885  20.194  1.00 44.39          
ATOM   1362  CD  LYS   178     -14.745   2.358  21.320  1.00 42.00          
ATOM   1363  CE  LYS   178     -15.537   2.239  22.614  1.00 40.91          
ATOM   1364  NZ  LYS   178     -14.767   1.550  23.665  1.00 38.93          
ATOM   1365  N   THR   179     -13.933   3.282  16.119  1.00 48.41          
ATOM   1366  CA  THR   179     -12.997   3.693  15.082  1.00 48.89          
ATOM   1367  C   THR   179     -13.611   3.698  13.683  1.00 49.93          
ATOM   1368  O   THR   179     -13.017   4.223  12.739  1.00 49.90          
ATOM   1369  CB  THR   179     -11.799   2.770  15.036  1.00 47.98          
ATOM   1370  OG1 THR   179     -10.896   3.222  14.021  1.00 49.85          
ATOM   1371  CG2 THR   179     -12.242   1.364  14.711  1.00 47.02          
ATOM   1372  N   LYS   180     -14.789   3.101  13.544  1.00 50.53          
ATOM   1373  CA  LYS   180     -15.481   3.068  12.260  1.00 52.01          
ATOM   1374  C   LYS   180     -14.695   2.333  11.183  1.00 52.63          
ATOM   1375  O   LYS   180     -15.009   2.435   9.996  1.00 51.35          
ATOM   1376  CB  LYS   180     -15.767   4.495  11.783  1.00 52.99          
ATOM   1377  CG  LYS   180     -17.242   4.858  11.683  1.00 55.62          
ATOM   1378  CD  LYS   180     -17.938   4.141  10.526  1.00 55.90          
ATOM   1379  CE  LYS   180     -19.427   4.437  10.557  1.00 56.83          
ATOM   1380  NZ  LYS   180     -19.985   4.013  11.889  1.00 55.95          
ATOM   1381  N   LYS   181     -13.663   1.602  11.588  1.00 53.12          
ATOM   1382  CA  LYS   181     -12.873   0.866  10.619  1.00 53.60          
ATOM   1383  C   LYS   181     -12.718  -0.602  10.979  1.00 54.50          
ATOM   1384  O   LYS   181     -13.083  -1.051  12.076  1.00 52.93          
ATOM   1385  CB  LYS   181     -11.490   1.502  10.452  1.00 53.88          
ATOM   1386  CG  LYS   181     -10.592   1.401  11.675  1.00 54.05          
ATOM   1387  CD  LYS   181      -9.296   2.176  11.483  1.00 53.57          
ATOM   1388  CE  LYS   181      -8.442   2.143  12.735  1.00 53.67          
ATOM   1389  NZ  LYS   181      -7.189   2.931  12.598  1.00 54.79          
ATOM   1390  N   LEU   182     -12.168  -1.325  10.006  1.00 56.02          
ATOM   1391  CA  LEU   182     -11.884  -2.770  10.026  1.00 55.30          
ATOM   1392  C   LEU   182     -11.246  -3.287  11.343  1.00 53.62          
ATOM   1393  O   LEU   182     -10.195  -2.797  11.757  1.00 54.22          
ATOM   1394  CB  LEU   182     -10.968  -3.075   8.800  1.00 55.90          
ATOM   1395  CG  LEU   182     -10.380  -1.883   7.962  1.00 53.80          
ATOM   1396  CD1 LEU   182      -9.228  -2.316   7.042  1.00 52.37          
ATOM   1397  CD2 LEU   182     -11.499  -1.277   7.120  1.00 53.33          
ATOM   1398  N   LEU   183     -11.878  -4.266  11.995  1.00 50.52          
ATOM   1399  CA  LEU   183     -11.347  -4.828  13.252  1.00 48.28          
ATOM   1400  C   LEU   183     -10.448  -6.043  13.050  1.00 45.90          
ATOM   1401  O   LEU   183      -9.400  -6.193  13.681  1.00 44.30          
ATOM   1402  CB  LEU   183     -12.476  -5.236  14.197  1.00 49.28          
ATOM   1403  CG  LEU   183     -12.067  -6.074  15.444  1.00 51.03          
ATOM   1404  CD1 LEU   183     -12.009  -7.563  15.098  1.00 54.22          
ATOM   1405  CD2 LEU   183     -10.729  -5.601  16.002  1.00 49.85          
ATOM   1406  N   SER   184     -10.900  -6.928  12.185  1.00 44.43          
ATOM   1407  CA  SER   184     -10.159  -8.114  11.859  1.00 43.48          
ATOM   1408  C   SER   184      -8.853  -7.693  11.189  1.00 44.32          
ATOM   1409  O   SER   184      -7.937  -8.503  11.050  1.00 44.55          
ATOM   1410  CB  SER   184     -10.983  -8.953  10.902  1.00 41.59          
ATOM   1411  OG  SER   184     -11.456  -8.135   9.852  1.00 35.42          
ATOM   1412  N   SER   185      -8.773  -6.431  10.766  1.00 44.69          
ATOM   1413  CA  SER   185      -7.568  -5.914  10.113  1.00 45.69          
ATOM   1414  C   SER   185      -6.466  -5.590  11.110  1.00 46.49          
ATOM   1415  O   SER   185      -5.285  -5.817  10.829  1.00 45.51          
ATOM   1416  CB  SER   185      -7.876  -4.654   9.295  1.00 45.78          
ATOM   1417  OG  SER   185      -8.466  -4.969   8.044  1.00 45.88          
ATOM   1418  N   ARG   186      -6.851  -5.036  12.261  1.00 48.52          
ATOM   1419  CA  ARG   186      -5.885  -4.693  13.314  1.00 50.34          
ATOM   1420  C   ARG   186      -5.313  -6.035  13.754  1.00 51.51          
ATOM   1421  O   ARG   186      -4.119  -6.169  14.022  1.00 51.82          
ATOM   1422  CB  ARG   186      -6.570  -4.027  14.520  1.00 50.06          
ATOM   1423  CG  ARG   186      -5.606  -3.246  15.435  1.00 49.75          
ATOM   1424  CD  ARG   186      -6.227  -2.902  16.785  1.00 50.42          
ATOM   1425  NE  ARG   186      -6.215  -4.063  17.684  1.00 53.87          
ATOM   1426  CZ  ARG   186      -6.842  -4.133  18.859  1.00 54.08          
ATOM   1427  NH1 ARG   186      -7.557  -3.109  19.320  1.00 56.15          
ATOM   1428  NH2 ARG   186      -6.758  -5.240  19.575  1.00 52.45          
ATOM   1429  N   LYS   187      -6.193  -7.028  13.811  1.00 51.09          
ATOM   1430  CA  LYS   187      -5.797  -8.352  14.208  1.00 51.02          
ATOM   1431  C   LYS   187      -4.705  -8.818  13.272  1.00 50.36          
ATOM   1432  O   LYS   187      -3.631  -9.231  13.707  1.00 50.70          
ATOM   1433  CB  LYS   187      -6.988  -9.305  14.154  1.00 52.56          
ATOM   1434  CG  LYS   187      -6.678 -10.686  14.694  1.00 56.27          
ATOM   1435  CD  LYS   187      -7.886 -11.618  14.642  1.00 58.60          
ATOM   1436  CE  LYS   187      -7.492 -13.047  15.036  1.00 59.82          
ATOM   1437  NZ  LYS   187      -6.259 -13.499  14.301  1.00 61.02          
ATOM   1438  N   LYS   188      -4.967  -8.734  11.978  1.00 50.63          
ATOM   1439  CA  LYS   188      -3.984  -9.174  10.996  1.00 51.57          
ATOM   1440  C   LYS   188      -2.636  -8.466  11.131  1.00 51.32          
ATOM   1441  O   LYS   188      -1.620  -9.099  11.404  1.00 52.03          
ATOM   1442  CB  LYS   188      -4.521  -8.989   9.573  1.00 51.50          
ATOM   1443  CG  LYS   188      -5.007 -10.283   8.924  1.00 51.18          
ATOM   1444  CD  LYS   188      -3.861 -11.259   8.683  1.00 50.69          
ATOM   1445  CE  LYS   188      -4.299 -12.409   7.793  1.00 49.90          
ATOM   1446  NZ  LYS   188      -5.527 -13.098   8.272  1.00 50.64          
ATOM   1447  N   VAL   189      -2.622  -7.156  10.953  1.00 49.59          
ATOM   1448  CA  VAL   189      -1.374  -6.429  11.047  1.00 49.63          
ATOM   1449  C   VAL   189      -0.619  -6.638  12.363  1.00 49.29          
ATOM   1450  O   VAL   189       0.611  -6.750  12.376  1.00 48.30          
ATOM   1451  CB  VAL   189      -1.630  -4.972  10.843  1.00 49.75          
ATOM   1452  CG1 VAL   189      -2.176  -4.752   9.452  1.00 48.75          
ATOM   1453  CG2 VAL   189      -2.619  -4.503  11.882  1.00 52.17          
ATOM   1454  N   GLN   190      -1.342  -6.689  13.476  1.00 48.78          
ATOM   1455  CA  GLN   190      -0.677  -6.899  14.760  1.00 47.47          
ATOM   1456  C   GLN   190      -0.157  -8.323  14.842  1.00 47.16          
ATOM   1457  O   GLN   190       0.858  -8.592  15.484  1.00 47.10          
ATOM   1458  CB  GLN   190      -1.628  -6.620  15.922  1.00 46.09          
ATOM   1459  CG  GLN   190      -1.941  -5.146  16.098  1.00 45.76          
ATOM   1460  CD  GLN   190      -2.807  -4.889  17.309  1.00 46.83          
ATOM   1461  OE1 GLN   190      -3.590  -5.752  17.709  1.00 46.52          
ATOM   1462  NE2 GLN   190      -2.685  -3.699  17.896  1.00 47.75          
ATOM   1463  N   GLN   191      -0.842  -9.230  14.159  1.00 46.02          
ATOM   1464  CA  GLN   191      -0.458 -10.629  14.152  1.00 46.91          
ATOM   1465  C   GLN   191       0.782 -10.901  13.308  1.00 45.51          
ATOM   1466  O   GLN   191       1.509 -11.865  13.537  1.00 43.97          
ATOM   1467  CB  GLN   191      -1.621 -11.451  13.629  1.00 50.20          
ATOM   1468  CG  GLN   191      -1.363 -12.923  13.544  1.00 56.18          
ATOM   1469  CD  GLN   191      -2.434 -13.606  12.725  1.00 59.90          
ATOM   1470  OE1 GLN   191      -2.522 -13.397  11.506  1.00 61.10          
ATOM   1471  NE2 GLN   191      -3.274 -14.408  13.387  1.00 60.36          
ATOM   1472  N   PHE   192       1.034 -10.041  12.336  1.00 45.01          
ATOM   1473  CA  PHE   192       2.172 -10.246  11.465  1.00 45.77          
ATOM   1474  C   PHE   192       3.362  -9.368  11.781  1.00 44.99          
ATOM   1475  O   PHE   192       4.490  -9.724  11.443  1.00 43.59          
ATOM   1476  CB  PHE   192       1.748 -10.031  10.012  1.00 46.62          
ATOM   1477  CG  PHE   192       2.869 -10.179   9.017  1.00 47.97          
ATOM   1478  CD1 PHE   192       3.551 -11.386   8.886  1.00 48.19          
ATOM   1479  CD2 PHE   192       3.233  -9.107   8.198  1.00 47.46          
ATOM   1480  CE1 PHE   192       4.574 -11.522   7.958  1.00 47.15          
ATOM   1481  CE2 PHE   192       4.253  -9.234   7.269  1.00 45.13          
ATOM   1482  CZ  PHE   192       4.925 -10.443   7.149  1.00 46.16          
ATOM   1483  N   THR   193       3.115  -8.220  12.406  1.00 45.06          
ATOM   1484  CA  THR   193       4.200  -7.300  12.742  1.00 46.66          
ATOM   1485  C   THR   193       4.678  -7.492  14.160  1.00 47.05          
ATOM   1486  O   THR   193       5.434  -6.669  14.672  1.00 46.69          
ATOM   1487  CB  THR   193       3.797  -5.820  12.656  1.00 47.22          
ATOM   1488  OG1 THR   193       2.633  -5.665  11.841  1.00 48.99          
ATOM   1489  CG2 THR   193       4.931  -5.024  12.060  1.00 46.02          
END
