
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  171 ( 1315),  selected  171 , name 1yvo_B
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 1yvo_B.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_B      R      26          1.458
LGA    A     3_B      Y      27          1.195
LGA    S     4_B      H      28          1.259
LGA    I     5_B      L      29          1.219
LGA    R     6_B      R      30          1.631
LGA    D     7_B      P      31          1.975
LGA    A     8_B      P      32          1.657
LGA    G     9_B      R      33          1.723
LGA    V    10_B      R      34          2.423
LGA    A    11_B      N      35          3.244
LGA    D    12_B      D      36          2.314
LGA    L    13_B      G      37          2.190
LGA    P    14_B      A      38          2.125
LGA    G    15_B      A      39          1.650
LGA    I    16_B      I      40          0.729
LGA    L    17_B      H      41          1.121
LGA    A    18_B      Q      42          0.664
LGA    I    19_B      L      43          1.701
LGA    Y    20_B      V      44          2.459
LGA    N    21_B      S      45          2.792
LGA    D    22_B      E      46          3.269
LGA    A    23_B      C      47          4.234
LGA    V    24_B      -       -           -
LGA    G    25_B      -       -           -
LGA    N    26_B      P      48          2.650
LGA    T    27_B      P      49          0.513
LGA    T    28_B      -       -           -
LGA    A    29_B      L      50          3.230
LGA    I    30_B      D      51          2.834
LGA    W    31_B      L      52           #
LGA    N    32_B      -       -           -
LGA    E    33_B      -       -           -
LGA    T    34_B      -       -           -
LGA    P    35_B      N      53          4.756
LGA    V    36_B      S      54          1.613
LGA    D    37_B      L      55          2.523
LGA    L    38_B      -       -           -
LGA    A    39_B      Y      56          3.748
LGA    N    40_B      A      57          3.725
LGA    R    41_B      Y      58          2.275
LGA    Q    42_B      L      59          1.847
LGA    A    43_B      L      60          2.312
LGA    W    44_B      L      61          2.689
LGA    F    45_B      C      62          1.898
LGA    D    46_B      E      63          2.068
LGA    T    47_B      H      64          2.377
LGA    R    48_B      H      65          1.270
LGA    A    49_B      A      66          5.113
LGA    R    50_B      -       -           -
LGA    Q    51_B      -       -           -
LGA    G    52_B      -       -           -
LGA    Y    53_B      H      67          3.404
LGA    P    54_B      T      68          2.357
LGA    I    55_B      C      69          2.026
LGA    L    56_B      V      70          1.115
LGA    V    57_B      V      71          0.891
LGA    A    58_B      A      72          0.650
LGA    S    59_B      E      73          0.713
LGA    D    60_B      S      74          0.464
LGA    A    61_B      P      75          1.060
LGA    A    62_B      G      76          0.958
LGA    G    63_B      G      77          0.658
LGA    E    64_B      R      78          0.390
LGA    V    65_B      I      79          0.413
LGA    L    66_B      D      80          0.969
LGA    G    67_B      G      81          0.361
LGA    Y    68_B      F      82          1.096
LGA    A    69_B      V      83          1.484
LGA    S    70_B      S      84          2.991
LGA    Y    71_B      A      85          1.469
LGA    G    72_B      Y      86          1.452
LGA    D    73_B      L      87          3.814
LGA    W    74_B      L      88          3.803
LGA    R    75_B      -       -           -
LGA    P    76_B      P      89          4.865
LGA    F    77_B      T      90          2.970
LGA    E    78_B      -       -           -
LGA    G    79_B      -       -           -
LGA    F    80_B      R      91          1.315
LGA    R    81_B      P      92          1.923
LGA    G    82_B      D      93          1.455
LGA    T    83_B      V      94          1.255
LGA    V    84_B      L      95          2.081
LGA    E    85_B      F      96          0.400
LGA    H    86_B      V      97          1.292
LGA    S    87_B      W      98          3.372
LGA    -       -      Q      99           -
LGA    V    88_B      V     100          1.982
LGA    Y    89_B      A     101          1.410
LGA    V    90_B      V     102          0.906
LGA    R    91_B      H     103          1.501
LGA    D    92_B      S     104          2.879
LGA    D    93_B      R     105          2.647
LGA    Q    94_B      A     106          1.791
LGA    R    95_B      R     107          2.766
LGA    G    96_B      G     108          3.446
LGA    K    97_B      H     109          2.630
LGA    G    98_B      R     110          0.879
LGA    L    99_B      L     111          0.939
LGA    G   100_B      G     112          0.857
LGA    V   101_B      R     113          1.358
LGA    Q   102_B      A     114          0.925
LGA    L   103_B      M     115          0.695
LGA    L   104_B      L     116          1.170
LGA    Q   105_B      G     117          1.427
LGA    A   106_B      H     118          1.029
LGA    L   107_B      I     119          1.625
LGA    I   108_B      L     120          1.815
LGA    E   109_B      E     121          1.317
LGA    R   110_B      R     122          1.995
LGA    -       -      Q     123           -
LGA    A   111_B      E     124           #
LGA    R   112_B      C     125          4.075
LGA    A   113_B      R     126          2.779
LGA    Q   114_B      -       -           -
LGA    G   115_B      H     127          1.496
LGA    L   116_B      V     128          1.823
LGA    H   117_B      R     129          1.904
LGA    V   118_B      H     130          1.291
LGA    X   119_B      L     131          1.167
LGA    V   120_B      E     132          0.556
LGA    A   121_B      T     133          1.321
LGA    A   122_B      T     134          1.052
LGA    I   123_B      V     135          1.369
LGA    E   124_B      G     136          1.573
LGA    S   125_B      P     137          2.205
LGA    G   126_B      D     138          1.557
LGA    N   127_B      N     139          1.054
LGA    A   128_B      Q     140          1.114
LGA    A   129_B      A     141          1.254
LGA    S   130_B      S     142          0.490
LGA    I   131_B      R     143          0.904
LGA    G   132_B      R     144          1.235
LGA    L   133_B      T     145          1.194
LGA    H   134_B      F     146          0.952
LGA    R   135_B      A     147          1.009
LGA    R   136_B      G     148          1.492
LGA    L   137_B      L     149          1.364
LGA    G   138_B      A     150          1.041
LGA    -       -      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    -       -      A     155           -
LGA    F   139_B      H     156           #
LGA    E   140_B      V     157          0.887
LGA    I   141_B      S     158          2.430
LGA    S   142_B      E     159          2.939
LGA    G   143_B      Q     160          0.996
LGA    Q   144_B      P     161          2.399
LGA    X   145_B      F     162          3.506
LGA    -       -      F     163           -
LGA    P   146_B      D     164          3.856
LGA    Q   147_B      R     165          2.790
LGA    -       -      Q     166           -
LGA    V   148_B      A     167          3.791
LGA    G   149_B      F     168          3.660
LGA    -       -      G     169           -
LGA    Q   150_B      G     170           #
LGA    K   151_B      A     171          5.371
LGA    F   152_B      D     172          4.072
LGA    G   153_B      -       -           -
LGA    R   154_B      -       -           -
LGA    W   155_B      H     173          4.737
LGA    L   156_B      D     174          1.785
LGA    D   157_B      D     175          1.597
LGA    L   158_B      E     176          1.511
LGA    T   159_B      M     177          1.849
LGA    F   160_B      L     178          1.493
LGA    X   161_B      L     179          1.571
LGA    Q   162_B      R     180          1.823
LGA    L   163_B      I     181          2.168
LGA    N   164_B      G     182          2.016
LGA    -       -      P     183           -
LGA    L   165_B      F     184          2.360
LGA    D   166_B      -       -           -
LGA    P   167_B      -       -           -
LGA    T   168_B      -       -           -
LGA    R   169_B      -       -           -
LGA    S   170_B      -       -           -
LGA    A   171_B      -       -           -
LGA    P   172_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  171  159    5.0    144    2.22    16.67     66.558     6.208

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.957891 * X  +  -0.245624 * Y  +  -0.148709 * Z  +  64.711685
  Y_new =   0.239690 * X  +  -0.398862 * Y  +  -0.885131 * Z  +  47.458916
  Z_new =   0.158096 * X  +  -0.883503 * Y  +   0.440940 * Z  +  99.354088 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.107884    2.033709  [ DEG:   -63.4771    116.5229 ]
  Theta =  -0.158762   -2.982831  [ DEG:    -9.0964   -170.9036 ]
  Phi   =   2.896400   -0.245192  [ DEG:   165.9515    -14.0485 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yvo_B                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yvo_B.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  171  159   5.0  144   2.22   16.67  66.558
REMARK  ---------------------------------------------------------- 
MOLECULE 1yvo_B
HEADER    TRANSFERASE                             16-FEB-05   1YVO              
TITLE     HYPOTHETICAL ACETYLTRANSFERASE FROM P.AERUGINOSA PA01                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED HYPOTHETICAL PROTEIN;                            
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 2.3.-.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA PAO1;                    
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS, HYPOTHETICAL               
KEYWDS   2 ACETYLTRANSFERASE, PSI, PROTEIN STRUCTURE INITIATIVE,                
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.NOCEK,A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS           
AUTHOR   2 (MCSG)                                                               
REVDAT   1   29-MAR-05 1YVO    0                                                
JRNL        AUTH   B.NOCEK,X.XU,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK              
JRNL        TITL   CRYSTAL STRUCTURE OF A HYPOTHETICAL                          
JRNL        TITL 2 ACETYLTRANSFERASE FROM P.AERUGINOSA PA01                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1YVO A    1   172  UNP    Q9HUU7   Q9HUU7_PSEAE     1    172             
DBREF  1YVO B    1   172  UNP    Q9HUU7   Q9HUU7_PSEAE     1    172             
SEQRES   1 A  172  MSE SER ALA SER ILE ARG ASP ALA GLY VAL ALA ASP LEU          
SEQRES   2 A  172  PRO GLY ILE LEU ALA ILE TYR ASN ASP ALA VAL GLY ASN          
SEQRES   3 A  172  THR THR ALA ILE TRP ASN GLU THR PRO VAL ASP LEU ALA          
SEQRES   4 A  172  ASN ARG GLN ALA TRP PHE ASP THR ARG ALA ARG GLN GLY          
SEQRES   5 A  172  TYR PRO ILE LEU VAL ALA SER ASP ALA ALA GLY GLU VAL          
SEQRES   6 A  172  LEU GLY TYR ALA SER TYR GLY ASP TRP ARG PRO PHE GLU          
SEQRES   7 A  172  GLY PHE ARG GLY THR VAL GLU HIS SER VAL TYR VAL ARG          
SEQRES   8 A  172  ASP ASP GLN ARG GLY LYS GLY LEU GLY VAL GLN LEU LEU          
SEQRES   9 A  172  GLN ALA LEU ILE GLU ARG ALA ARG ALA GLN GLY LEU HIS          
SEQRES  10 A  172  VAL MSE VAL ALA ALA ILE GLU SER GLY ASN ALA ALA SER          
SEQRES  11 A  172  ILE GLY LEU HIS ARG ARG LEU GLY PHE GLU ILE SER GLY          
SEQRES  12 A  172  GLN MSE PRO GLN VAL GLY GLN LYS PHE GLY ARG TRP LEU          
SEQRES  13 A  172  ASP LEU THR PHE MSE GLN LEU ASN LEU ASP PRO THR ARG          
SEQRES  14 A  172  SER ALA PRO                                                  
SEQRES   1 B  172  MSE SER ALA SER ILE ARG ASP ALA GLY VAL ALA ASP LEU          
SEQRES   2 B  172  PRO GLY ILE LEU ALA ILE TYR ASN ASP ALA VAL GLY ASN          
SEQRES   3 B  172  THR THR ALA ILE TRP ASN GLU THR PRO VAL ASP LEU ALA          
SEQRES   4 B  172  ASN ARG GLN ALA TRP PHE ASP THR ARG ALA ARG GLN GLY          
SEQRES   5 B  172  TYR PRO ILE LEU VAL ALA SER ASP ALA ALA GLY GLU VAL          
SEQRES   6 B  172  LEU GLY TYR ALA SER TYR GLY ASP TRP ARG PRO PHE GLU          
SEQRES   7 B  172  GLY PHE ARG GLY THR VAL GLU HIS SER VAL TYR VAL ARG          
SEQRES   8 B  172  ASP ASP GLN ARG GLY LYS GLY LEU GLY VAL GLN LEU LEU          
SEQRES   9 B  172  GLN ALA LEU ILE GLU ARG ALA ARG ALA GLN GLY LEU HIS          
SEQRES  10 B  172  VAL MSE VAL ALA ALA ILE GLU SER GLY ASN ALA ALA SER          
SEQRES  11 B  172  ILE GLY LEU HIS ARG ARG LEU GLY PHE GLU ILE SER GLY          
SEQRES  12 B  172  GLN MSE PRO GLN VAL GLY GLN LYS PHE GLY ARG TRP LEU          
SEQRES  13 B  172  ASP LEU THR PHE MSE GLN LEU ASN LEU ASP PRO THR ARG          
SEQRES  14 B  172  SER ALA PRO                                                  
HET    MSE  A 119       8                                                       
HET    MSE  A 145       8                                                       
HET    MSE  A 161       8                                                       
HET    MSE  B 119       8                                                       
HET    MSE  B 145       8                                                       
HET    MSE  B 161       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *266(H2 O)                                                    
CRYST1   48.015   84.007   85.903  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1322  N   SER B   2      -5.632 -21.539  58.977  1.00 38.99           N  
ATOM   1323  CA  SER B   2      -6.682 -21.472  57.920  1.00 38.88           C  
ATOM   1324  C   SER B   2      -6.159 -20.712  56.697  1.00 38.23           C  
ATOM   1325  O   SER B   2      -6.198 -21.230  55.574  1.00 38.73           O  
ATOM   1326  CB  SER B   2      -7.957 -20.817  58.474  1.00 39.15           C  
ATOM   1327  OG  SER B   2      -8.972 -20.735  57.483  1.00 40.84           O  
ATOM   1328  N   ALA B   3      -5.645 -19.503  56.932  1.00 37.06           N  
ATOM   1329  CA  ALA B   3      -5.146 -18.618  55.867  1.00 35.44           C  
ATOM   1330  C   ALA B   3      -4.039 -19.252  55.020  1.00 34.10           C  
ATOM   1331  O   ALA B   3      -3.188 -19.982  55.543  1.00 34.26           O  
ATOM   1332  CB  ALA B   3      -4.663 -17.302  56.461  1.00 35.51           C  
ATOM   1333  N   SER B   4      -4.064 -18.971  53.717  1.00 32.01           N  
ATOM   1334  CA  SER B   4      -3.007 -19.423  52.806  1.00 29.95           C  
ATOM   1335  C   SER B   4      -2.065 -18.284  52.429  1.00 27.87           C  
ATOM   1336  O   SER B   4      -2.499 -17.142  52.288  1.00 27.66           O  
ATOM   1337  CB  SER B   4      -3.606 -20.021  51.536  1.00 30.23           C  
ATOM   1338  OG  SER B   4      -4.162 -19.012  50.712  1.00 31.33           O  
ATOM   1339  N   ILE B   5      -0.788 -18.612  52.257  1.00 25.48           N  
ATOM   1340  CA  ILE B   5       0.218 -17.658  51.779  1.00 23.33           C  
ATOM   1341  C   ILE B   5       0.432 -17.873  50.277  1.00 22.01           C  
ATOM   1342  O   ILE B   5       0.727 -18.985  49.847  1.00 21.76           O  
ATOM   1343  CB  ILE B   5       1.591 -17.815  52.518  1.00 23.44           C  
ATOM   1344  CG1 ILE B   5       1.428 -17.857  54.051  1.00 23.28           C  
ATOM   1345  CG2 ILE B   5       2.583 -16.725  52.078  1.00 22.84           C  
ATOM   1346  CD1 ILE B   5       0.924 -16.577  54.690  1.00 22.72           C  
ATOM   1347  N   ARG B   6       0.276 -16.813  49.492  1.00 20.04           N  
ATOM   1348  CA  ARG B   6       0.439 -16.890  48.040  1.00 19.15           C  
ATOM   1349  C   ARG B   6       0.985 -15.571  47.508  1.00 18.96           C  
ATOM   1350  O   ARG B   6       0.955 -14.560  48.211  1.00 18.51           O  
ATOM   1351  CB  ARG B   6      -0.903 -17.190  47.378  1.00 18.94           C  
ATOM   1352  CG  ARG B   6      -1.980 -16.187  47.731  1.00 18.07           C  
ATOM   1353  CD  ARG B   6      -3.218 -16.331  46.860  1.00 20.27           C  
ATOM   1354  NE  ARG B   6      -4.251 -15.384  47.280  1.00 21.53           N  
ATOM   1355  CZ  ARG B   6      -4.320 -14.108  46.906  1.00 22.25           C  
ATOM   1356  NH1 ARG B   6      -3.407 -13.587  46.086  1.00 22.43           N  
ATOM   1357  NH2 ARG B   6      -5.310 -13.348  47.365  1.00 22.46           N  
ATOM   1358  N   ASP B   7       1.455 -15.575  46.262  1.00 18.82           N  
ATOM   1359  CA  ASP B   7       1.913 -14.345  45.625  1.00 19.31           C  
ATOM   1360  C   ASP B   7       0.746 -13.401  45.414  1.00 18.93           C  
ATOM   1361  O   ASP B   7      -0.362 -13.836  45.072  1.00 18.90           O  
ATOM   1362  CB  ASP B   7       2.612 -14.624  44.299  1.00 19.88           C  
ATOM   1363  CG  ASP B   7       3.925 -15.344  44.479  1.00 22.85           C  
ATOM   1364  OD1 ASP B   7       4.980 -14.675  44.603  1.00 25.13           O  
ATOM   1365  OD2 ASP B   7       3.906 -16.593  44.507  1.00 27.42           O  
ATOM   1366  N   ALA B   8       1.000 -12.113  45.638  1.00 18.15           N  
ATOM   1367  CA  ALA B   8       0.022 -11.066  45.388  1.00 17.96           C  
ATOM   1368  C   ALA B   8      -0.232 -10.841  43.893  1.00 18.11           C  
ATOM   1369  O   ALA B   8       0.679 -10.970  43.062  1.00 17.92           O  
ATOM   1370  CB  ALA B   8       0.477  -9.763  46.030  1.00 17.41           C  
ATOM   1371  N   GLY B   9      -1.470 -10.490  43.566  1.00 17.94           N  
ATOM   1372  CA  GLY B   9      -1.790  -9.938  42.251  1.00 18.68           C  
ATOM   1373  C   GLY B   9      -2.314  -8.513  42.376  1.00 19.11           C  
ATOM   1374  O   GLY B   9      -2.515  -7.996  43.497  1.00 18.58           O  
ATOM   1375  N   VAL B  10      -2.546  -7.872  41.236  0.50 19.02           N  
ATOM   1377  CA  VAL B  10      -3.060  -6.497  41.228  0.50 18.96           C  
ATOM   1379  C   VAL B  10      -4.417  -6.380  41.932  0.50 18.84           C  
ATOM   1381  O   VAL B  10      -4.747  -5.325  42.469  0.50 18.79           O  
ATOM   1383  CB  VAL B  10      -3.112  -5.886  39.797  0.50 19.04           C  
ATOM   1385  CG1 VAL B  10      -1.696  -5.677  39.252  0.50 19.15           C  
ATOM   1387  CG2 VAL B  10      -3.939  -6.754  38.856  0.50 18.77           C  
ATOM   1389  N   ALA B  11      -5.185  -7.470  41.940  1.00 18.77           N  
ATOM   1390  CA  ALA B  11      -6.463  -7.515  42.657  1.00 18.76           C  
ATOM   1391  C   ALA B  11      -6.332  -7.538  44.187  1.00 18.49           C  
ATOM   1392  O   ALA B  11      -7.322  -7.346  44.901  1.00 18.05           O  
ATOM   1393  CB  ALA B  11      -7.298  -8.705  42.181  1.00 19.20           C  
ATOM   1394  N   ASP B  12      -5.124  -7.788  44.692  1.00 17.64           N  
ATOM   1395  CA  ASP B  12      -4.878  -7.731  46.138  1.00 17.23           C  
ATOM   1396  C   ASP B  12      -4.490  -6.338  46.591  1.00 16.38           C  
ATOM   1397  O   ASP B  12      -4.387  -6.084  47.786  1.00 15.17           O  
ATOM   1398  CB  ASP B  12      -3.776  -8.710  46.548  1.00 17.47           C  
ATOM   1399  CG  ASP B  12      -4.151 -10.155  46.284  1.00 19.95           C  
ATOM   1400  OD1 ASP B  12      -5.222 -10.592  46.767  1.00 22.06           O  
ATOM   1401  OD2 ASP B  12      -3.373 -10.853  45.593  1.00 21.90           O  
ATOM   1402  N   LEU B  13      -4.256  -5.440  45.637  1.00 15.96           N  
ATOM   1403  CA  LEU B  13      -3.762  -4.099  45.966  1.00 15.90           C  
ATOM   1404  C   LEU B  13      -4.721  -3.237  46.805  1.00 15.42           C  
ATOM   1405  O   LEU B  13      -4.253  -2.512  47.675  1.00 15.61           O  
ATOM   1406  CB  LEU B  13      -3.231  -3.343  44.731  1.00 16.16           C  
ATOM   1407  CG  LEU B  13      -1.891  -3.837  44.165  1.00 16.73           C  
ATOM   1408  CD1 LEU B  13      -1.589  -3.213  42.811  1.00 16.42           C  
ATOM   1409  CD2 LEU B  13      -0.728  -3.577  45.136  1.00 15.75           C  
ATOM   1410  N   PRO B  14      -6.051  -3.302  46.558  1.00 14.91           N  
ATOM   1411  CA  PRO B  14      -6.921  -2.571  47.496  1.00 14.30           C  
ATOM   1412  C   PRO B  14      -6.811  -3.053  48.954  1.00 13.54           C  
ATOM   1413  O   PRO B  14      -6.842  -2.223  49.867  1.00 13.64           O  
ATOM   1414  CB  PRO B  14      -8.330  -2.829  46.947  1.00 14.43           C  
ATOM   1415  CG  PRO B  14      -8.109  -3.127  45.477  1.00 14.95           C  
ATOM   1416  CD  PRO B  14      -6.837  -3.938  45.484  1.00 14.94           C  
ATOM   1417  N   GLY B  15      -6.680  -4.366  49.172  1.00 12.51           N  
ATOM   1418  CA  GLY B  15      -6.534  -4.919  50.534  1.00 11.81           C  
ATOM   1419  C   GLY B  15      -5.181  -4.576  51.140  1.00 11.26           C  
ATOM   1420  O   GLY B  15      -5.062  -4.253  52.330  1.00 10.30           O  
ATOM   1421  N   ILE B  16      -4.148  -4.643  50.311  1.00 11.14           N  
ATOM   1422  CA  ILE B  16      -2.815  -4.175  50.707  1.00 11.74           C  
ATOM   1423  C   ILE B  16      -2.814  -2.702  51.116  1.00 11.84           C  
ATOM   1424  O   ILE B  16      -2.268  -2.341  52.162  1.00 11.74           O  
ATOM   1425  CB  ILE B  16      -1.785  -4.447  49.576  1.00 10.95           C  
ATOM   1426  CG1 ILE B  16      -1.496  -5.946  49.506  1.00 11.89           C  
ATOM   1427  CG2 ILE B  16      -0.505  -3.657  49.793  1.00 12.06           C  
ATOM   1428  CD1 ILE B  16      -0.689  -6.378  48.250  1.00 12.00           C  
ATOM   1429  N   LEU B  17      -3.437  -1.867  50.286  1.00 12.55           N  
ATOM   1430  CA  LEU B  17      -3.550  -0.420  50.537  1.00 13.03           C  
ATOM   1431  C   LEU B  17      -4.237  -0.121  51.871  1.00 12.35           C  
ATOM   1432  O   LEU B  17      -3.775   0.738  52.640  1.00 12.02           O  
ATOM   1433  CB  LEU B  17      -4.315   0.270  49.391  1.00 12.79           C  
ATOM   1434  CG  LEU B  17      -4.531   1.795  49.433  1.00 13.66           C  
ATOM   1435  CD1 LEU B  17      -3.233   2.564  49.294  1.00 15.35           C  
ATOM   1436  CD2 LEU B  17      -5.488   2.192  48.331  1.00 15.02           C  
ATOM   1437  N   ALA B  18      -5.338  -0.820  52.141  1.00 12.28           N  
ATOM   1438  CA  ALA B  18      -6.067  -0.624  53.401  1.00 11.70           C  
ATOM   1439  C   ALA B  18      -5.182  -0.944  54.616  1.00 11.98           C  
ATOM   1440  O   ALA B  18      -5.189  -0.198  55.600  1.00 11.50           O  
ATOM   1441  CB  ALA B  18      -7.334  -1.443  53.431  1.00 11.69           C  
ATOM   1442  N   ILE B  19      -4.419  -2.033  54.549  1.00 11.74           N  
ATOM   1443  CA  ILE B  19      -3.465  -2.365  55.636  1.00 12.72           C  
ATOM   1444  C   ILE B  19      -2.356  -1.306  55.731  1.00 12.74           C  
ATOM   1445  O   ILE B  19      -2.019  -0.834  56.820  1.00 13.29           O  
ATOM   1446  CB  ILE B  19      -2.839  -3.778  55.461  1.00 12.88           C  
ATOM   1447  CG1 ILE B  19      -3.928  -4.849  55.575  1.00 13.63           C  
ATOM   1448  CG2 ILE B  19      -1.693  -4.015  56.497  1.00 12.76           C  
ATOM   1449  CD1 ILE B  19      -3.531  -6.200  55.009  1.00 14.95           C  
ATOM   1450  N   TYR B  20      -1.799  -0.930  54.590  1.00 13.07           N  
ATOM   1451  CA  TYR B  20      -0.737   0.073  54.568  1.00 13.45           C  
ATOM   1452  C   TYR B  20      -1.218   1.382  55.208  1.00 12.89           C  
ATOM   1453  O   TYR B  20      -0.547   1.931  56.084  1.00 12.45           O  
ATOM   1454  CB  TYR B  20      -0.240   0.301  53.139  1.00 14.30           C  
ATOM   1455  CG  TYR B  20       0.870   1.318  53.034  1.00 16.27           C  
ATOM   1456  CD1 TYR B  20       2.215   0.937  53.121  1.00 18.15           C  
ATOM   1457  CD2 TYR B  20       0.573   2.669  52.845  1.00 17.95           C  
ATOM   1458  CE1 TYR B  20       3.247   1.896  53.024  1.00 18.72           C  
ATOM   1459  CE2 TYR B  20       1.596   3.633  52.750  1.00 20.07           C  
ATOM   1460  CZ  TYR B  20       2.916   3.234  52.834  1.00 17.78           C  
ATOM   1461  OH  TYR B  20       3.890   4.195  52.731  1.00 20.75           O  
ATOM   1462  N   ASN B  21      -2.388   1.863  54.790  1.00 11.82           N  
ATOM   1463  CA  ASN B  21      -2.898   3.141  55.295  1.00 12.08           C  
ATOM   1464  C   ASN B  21      -3.301   3.108  56.779  1.00 12.06           C  
ATOM   1465  O   ASN B  21      -3.211   4.127  57.481  1.00 11.57           O  
ATOM   1466  CB  ASN B  21      -4.030   3.661  54.391  1.00 11.97           C  
ATOM   1467  CG  ASN B  21      -3.498   4.304  53.113  1.00 13.11           C  
ATOM   1468  OD1 ASN B  21      -2.355   4.761  53.076  1.00 15.00           O  
ATOM   1469  ND2 ASN B  21      -4.329   4.351  52.066  1.00 13.71           N  
ATOM   1470  N   ASP B  22      -3.740   1.942  57.251  1.00 12.05           N  
ATOM   1471  CA  ASP B  22      -4.057   1.760  58.668  1.00 13.33           C  
ATOM   1472  C   ASP B  22      -2.775   1.879  59.518  1.00 13.63           C  
ATOM   1473  O   ASP B  22      -2.786   2.526  60.561  1.00 13.68           O  
ATOM   1474  CB  ASP B  22      -4.749   0.407  58.903  1.00 13.98           C  
ATOM   1475  CG  ASP B  22      -5.394   0.301  60.288  1.00 17.16           C  
ATOM   1476  OD1 ASP B  22      -5.730   1.338  60.899  1.00 17.97           O  
ATOM   1477  OD2 ASP B  22      -5.585  -0.834  60.762  1.00 22.65           O  
ATOM   1478  N   ALA B  23      -1.677   1.272  59.056  1.00 13.52           N  
ATOM   1479  CA  ALA B  23      -0.394   1.367  59.770  1.00 14.44           C  
ATOM   1480  C   ALA B  23       0.141   2.797  59.744  1.00 14.72           C  
ATOM   1481  O   ALA B  23       0.653   3.298  60.754  1.00 15.27           O  
ATOM   1482  CB  ALA B  23       0.623   0.387  59.199  1.00 14.39           C  
ATOM   1483  N   VAL B  24       0.000   3.458  58.594  1.00 15.41           N  
ATOM   1484  CA  VAL B  24       0.302   4.887  58.461  1.00 15.62           C  
ATOM   1485  C   VAL B  24      -0.449   5.713  59.504  1.00 16.33           C  
ATOM   1486  O   VAL B  24       0.160   6.514  60.219  1.00 16.53           O  
ATOM   1487  CB  VAL B  24       0.006   5.393  57.021  1.00 15.79           C  
ATOM   1488  CG1 VAL B  24      -0.080   6.910  56.966  1.00 15.87           C  
ATOM   1489  CG2 VAL B  24       1.084   4.891  56.072  1.00 15.15           C  
ATOM   1490  N   GLY B  25      -1.762   5.509  59.606  1.00 16.75           N  
ATOM   1491  CA  GLY B  25      -2.568   6.294  60.538  1.00 17.75           C  
ATOM   1492  C   GLY B  25      -2.410   5.951  62.014  1.00 18.70           C  
ATOM   1493  O   GLY B  25      -2.523   6.835  62.878  1.00 19.11           O  
ATOM   1494  N   ASN B  26      -2.131   4.684  62.312  1.00 18.80           N  
ATOM   1495  CA  ASN B  26      -2.312   4.186  63.673  1.00 20.08           C  
ATOM   1496  C   ASN B  26      -1.102   3.618  64.398  1.00 20.45           C  
ATOM   1497  O   ASN B  26      -1.183   3.350  65.594  1.00 21.47           O  
ATOM   1498  CB  ASN B  26      -3.436   3.148  63.691  1.00 19.93           C  
ATOM   1499  CG  ASN B  26      -4.787   3.776  63.539  1.00 20.60           C  
ATOM   1500  OD1 ASN B  26      -5.222   4.531  64.404  1.00 22.87           O  
ATOM   1501  ND2 ASN B  26      -5.470   3.474  62.437  1.00 20.45           N  
ATOM   1502  N   THR B  27       0.009   3.418  63.694  1.00 20.37           N  
ATOM   1503  CA  THR B  27       1.113   2.665  64.278  1.00 20.71           C  
ATOM   1504  C   THR B  27       2.463   3.282  63.920  1.00 21.19           C  
ATOM   1505  O   THR B  27       2.537   4.193  63.073  1.00 20.92           O  
ATOM   1506  CB  THR B  27       1.129   1.187  63.789  1.00 20.46           C  
ATOM   1507  OG1 THR B  27       1.652   1.140  62.459  1.00 21.05           O  
ATOM   1508  CG2 THR B  27      -0.265   0.577  63.796  1.00 20.56           C  
ATOM   1509  N   THR B  28       3.520   2.750  64.554  1.00 21.76           N  
ATOM   1510  CA  THR B  28       4.901   3.079  64.227  1.00 22.03           C  
ATOM   1511  C   THR B  28       5.521   2.079  63.260  1.00 22.80           C  
ATOM   1512  O   THR B  28       6.735   2.064  63.090  1.00 23.21           O  
ATOM   1513  CB  THR B  28       5.783   3.128  65.492  1.00 22.28           C  
ATOM   1514  OG1 THR B  28       5.780   1.842  66.138  1.00 22.61           O  
ATOM   1515  CG2 THR B  28       5.293   4.210  66.453  1.00 21.14           C  
ATOM   1516  N   ALA B  29       4.706   1.239  62.627  1.00 22.81           N  
ATOM   1517  CA  ALA B  29       5.238   0.207  61.727  1.00 23.24           C  
ATOM   1518  C   ALA B  29       5.720   0.838  60.435  1.00 23.40           C  
ATOM   1519  O   ALA B  29       6.567   0.285  59.728  1.00 23.26           O  
ATOM   1520  CB  ALA B  29       4.182  -0.856  61.431  1.00 23.32           C  
ATOM   1521  N   ILE B  30       5.152   1.996  60.116  1.00 23.17           N  
ATOM   1522  CA  ILE B  30       5.575   2.750  58.955  1.00 23.10           C  
ATOM   1523  C   ILE B  30       5.721   4.226  59.340  1.00 22.42           C  
ATOM   1524  O   ILE B  30       4.793   4.832  59.873  1.00 21.87           O  
ATOM   1525  CB  ILE B  30       4.692   2.428  57.692  1.00 24.07           C  
ATOM   1526  CG1 ILE B  30       4.426   3.649  56.819  1.00 25.08           C  
ATOM   1527  CG2 ILE B  30       3.402   1.723  58.050  1.00 25.73           C  
ATOM   1528  CD1 ILE B  30       5.324   3.676  55.595  1.00 28.50           C  
ATOM   1529  N   TRP B  31       6.917   4.776  59.117  1.00 21.59           N  
ATOM   1530  CA  TRP B  31       7.229   6.139  59.558  1.00 21.87           C  
ATOM   1531  C   TRP B  31       6.867   7.164  58.479  1.00 22.48           C  
ATOM   1532  O   TRP B  31       7.701   7.951  58.016  1.00 22.79           O  
ATOM   1533  CB  TRP B  31       8.679   6.265  60.037  1.00 20.92           C  
ATOM   1534  CG  TRP B  31       8.970   5.426  61.287  1.00 21.65           C  
ATOM   1535  CD1 TRP B  31       8.139   4.522  61.885  1.00 20.35           C  
ATOM   1536  CD2 TRP B  31      10.189   5.410  62.052  1.00 20.65           C  
ATOM   1537  NE1 TRP B  31       8.759   3.947  62.979  1.00 20.78           N  
ATOM   1538  CE2 TRP B  31      10.016   4.476  63.103  1.00 20.44           C  
ATOM   1539  CE3 TRP B  31      11.399   6.102  61.960  1.00 20.42           C  
ATOM   1540  CZ2 TRP B  31      11.013   4.211  64.046  1.00 19.30           C  
ATOM   1541  CZ3 TRP B  31      12.399   5.830  62.903  1.00 19.74           C  
ATOM   1542  CH2 TRP B  31      12.194   4.902  63.928  1.00 20.29           C  
ATOM   1543  N   ASN B  32       5.618   7.073  58.034  0.50 22.38           N  
ATOM   1545  CA  ASN B  32       4.977   8.070  57.198  0.50 22.55           C  
ATOM   1547  C   ASN B  32       3.648   8.385  57.863  0.50 22.40           C  
ATOM   1549  O   ASN B  32       3.034   7.511  58.468  0.50 22.09           O  
ATOM   1551  CB  ASN B  32       4.717   7.534  55.783  0.50 22.64           C  
ATOM   1553  CG  ASN B  32       5.986   7.425  54.939  0.50 23.51           C  
ATOM   1555  OD1 ASN B  32       6.993   8.079  55.212  0.50 24.03           O  
ATOM   1557  ND2 ASN B  32       5.929   6.598  53.898  0.50 23.69           N  
ATOM   1559  N   GLU B  33       3.216   9.634  57.755  1.00 22.47           N  
ATOM   1560  CA  GLU B  33       1.941  10.066  58.320  1.00 23.10           C  
ATOM   1561  C   GLU B  33       0.902  10.315  57.232  1.00 22.31           C  
ATOM   1562  O   GLU B  33      -0.287  10.420  57.529  1.00 22.67           O  
ATOM   1563  CB  GLU B  33       2.125  11.334  59.157  1.00 23.18           C  
ATOM   1564  CG  GLU B  33       2.859  11.137  60.486  1.00 24.85           C  
ATOM   1565  CD  GLU B  33       3.040  12.448  61.243  1.00 25.76           C  
ATOM   1566  OE1 GLU B  33       2.657  13.518  60.698  1.00 29.80           O  
ATOM   1567  OE2 GLU B  33       3.564  12.415  62.380  1.00 28.66           O  
ATOM   1568  N   THR B  34       1.357  10.401  55.983  1.00 21.74           N  
ATOM   1569  CA  THR B  34       0.495  10.716  54.836  1.00 21.44           C  
ATOM   1570  C   THR B  34       0.017   9.434  54.151  1.00 20.37           C  
ATOM   1571  O   THR B  34       0.842   8.623  53.731  1.00 19.79           O  
ATOM   1572  CB  THR B  34       1.248  11.612  53.811  1.00 21.90           C  
ATOM   1573  OG1 THR B  34       1.681  12.816  54.460  1.00 23.45           O  
ATOM   1574  CG2 THR B  34       0.351  11.990  52.623  1.00 22.40           C  
ATOM   1575  N   PRO B  35      -1.315   9.250  54.019  1.00 19.74           N  
ATOM   1576  CA  PRO B  35      -1.802   8.040  53.357  1.00 19.38           C  
ATOM   1577  C   PRO B  35      -1.545   8.092  51.846  1.00 19.38           C  
ATOM   1578  O   PRO B  35      -1.339   9.169  51.286  1.00 19.08           O  
ATOM   1579  CB  PRO B  35      -3.307   8.066  53.645  1.00 19.31           C  
ATOM   1580  CG  PRO B  35      -3.626   9.506  53.777  1.00 19.39           C  
ATOM   1581  CD  PRO B  35      -2.428  10.128  54.435  1.00 19.42           C  
ATOM   1582  N   VAL B  36      -1.538   6.931  51.204  1.00 19.39           N  
ATOM   1583  CA  VAL B  36      -1.250   6.853  49.776  1.00 19.73           C  
ATOM   1584  C   VAL B  36      -2.463   6.331  49.036  1.00 19.64           C  
ATOM   1585  O   VAL B  36      -3.390   5.814  49.655  1.00 19.45           O  
ATOM   1586  CB  VAL B  36      -0.022   5.949  49.485  1.00 20.00           C  
ATOM   1587  CG1 VAL B  36       1.240   6.559  50.094  1.00 20.36           C  
ATOM   1588  CG2 VAL B  36      -0.255   4.540  49.996  1.00 19.54           C  
ATOM   1589  N   ASP B  37      -2.453   6.462  47.713  1.00 19.93           N  
ATOM   1590  CA  ASP B  37      -3.571   5.985  46.905  1.00 20.16           C  
ATOM   1591  C   ASP B  37      -3.205   4.701  46.183  1.00 19.52           C  
ATOM   1592  O   ASP B  37      -2.042   4.293  46.201  1.00 19.18           O  
ATOM   1593  CB  ASP B  37      -4.069   7.070  45.923  1.00 20.81           C  
ATOM   1594  CG  ASP B  37      -3.011   7.508  44.901  1.00 22.67           C  
ATOM   1595  OD1 ASP B  37      -1.948   6.865  44.739  1.00 23.22           O  
ATOM   1596  OD2 ASP B  37      -3.270   8.524  44.221  1.00 26.13           O  
ATOM   1597  N   LEU B  38      -4.202   4.083  45.554  1.00 19.14           N  
ATOM   1598  CA  LEU B  38      -4.039   2.827  44.838  1.00 19.30           C  
ATOM   1599  C   LEU B  38      -2.927   2.910  43.788  1.00 19.41           C  
ATOM   1600  O   LEU B  38      -2.146   1.970  43.635  1.00 19.35           O  
ATOM   1601  CB  LEU B  38      -5.372   2.400  44.206  1.00 19.18           C  
ATOM   1602  CG  LEU B  38      -5.514   0.966  43.666  1.00 19.93           C  
ATOM   1603  CD1 LEU B  38      -5.333  -0.081  44.788  1.00 21.35           C  
ATOM   1604  CD2 LEU B  38      -6.859   0.762  42.990  1.00 19.25           C  
ATOM   1605  N   ALA B  39      -2.849   4.046  43.091  1.00 19.55           N  
ATOM   1606  CA  ALA B  39      -1.815   4.263  42.065  1.00 19.73           C  
ATOM   1607  C   ALA B  39      -0.402   4.163  42.644  1.00 19.79           C  
ATOM   1608  O   ALA B  39       0.494   3.583  42.018  1.00 19.65           O  
ATOM   1609  CB  ALA B  39      -2.029   5.617  41.365  1.00 19.57           C  
ATOM   1610  N   ASN B  40      -0.216   4.723  43.843  1.00 19.40           N  
ATOM   1611  CA  ASN B  40       1.058   4.653  44.550  1.00 19.83           C  
ATOM   1612  C   ASN B  40       1.457   3.203  44.842  1.00 19.80           C  
ATOM   1613  O   ASN B  40       2.610   2.822  44.631  1.00 19.45           O  
ATOM   1614  CB  ASN B  40       1.013   5.482  45.843  1.00 20.44           C  
ATOM   1615  CG  ASN B  40       2.225   5.251  46.737  1.00 20.93           C  
ATOM   1616  OD1 ASN B  40       2.414   4.168  47.285  1.00 21.71           O  
ATOM   1617  ND2 ASN B  40       3.044   6.278  46.892  1.00 23.51           N  
ATOM   1618  N   ARG B  41       0.505   2.405  45.327  1.00 19.46           N  
ATOM   1619  CA  ARG B  41       0.768   0.990  45.614  1.00 19.32           C  
ATOM   1620  C   ARG B  41       0.935   0.178  44.334  1.00 19.27           C  
ATOM   1621  O   ARG B  41       1.706  -0.782  44.306  1.00 19.63           O  
ATOM   1622  CB  ARG B  41      -0.324   0.385  46.505  1.00 19.15           C  
ATOM   1623  CG  ARG B  41      -0.311   0.875  47.970  1.00 18.70           C  
ATOM   1624  CD  ARG B  41       1.004   0.571  48.707  1.00 18.57           C  
ATOM   1625  NE  ARG B  41       2.023   1.598  48.473  1.00 18.75           N  
ATOM   1626  CZ  ARG B  41       3.286   1.537  48.893  1.00 21.04           C  
ATOM   1627  NH1 ARG B  41       3.727   0.497  49.586  1.00 20.74           N  
ATOM   1628  NH2 ARG B  41       4.124   2.530  48.610  1.00 21.98           N  
ATOM   1629  N   GLN B  42       0.237   0.568  43.269  1.00 19.41           N  
ATOM   1630  CA  GLN B  42       0.489  -0.051  41.956  1.00 19.45           C  
ATOM   1631  C   GLN B  42       1.915   0.221  41.472  1.00 18.79           C  
ATOM   1632  O   GLN B  42       2.557  -0.667  40.902  1.00 19.02           O  
ATOM   1633  CB  GLN B  42      -0.547   0.376  40.909  1.00 19.92           C  
ATOM   1634  CG  GLN B  42      -0.324  -0.251  39.523  1.00 22.25           C  
ATOM   1635  CD  GLN B  42      -0.509  -1.763  39.514  1.00 24.96           C  
ATOM   1636  OE1 GLN B  42       0.461  -2.526  39.425  1.00 27.42           O  
ATOM   1637  NE2 GLN B  42      -1.752  -2.203  39.618  1.00 25.84           N  
ATOM   1638  N   ALA B  43       2.410   1.438  41.704  1.00 17.88           N  
ATOM   1639  CA  ALA B  43       3.795   1.791  41.366  1.00 17.70           C  
ATOM   1640  C   ALA B  43       4.808   0.991  42.183  1.00 17.16           C  
ATOM   1641  O   ALA B  43       5.871   0.615  41.670  1.00 17.15           O  
ATOM   1642  CB  ALA B  43       4.031   3.295  41.536  1.00 18.13           C  
ATOM   1643  N   TRP B  44       4.482   0.759  43.458  1.00 16.30           N  
ATOM   1644  CA  TRP B  44       5.286  -0.094  44.356  1.00 15.70           C  
ATOM   1645  C   TRP B  44       5.300  -1.557  43.871  1.00 15.21           C  
ATOM   1646  O   TRP B  44       6.355  -2.204  43.843  1.00 14.84           O  
ATOM   1647  CB  TRP B  44       4.745   0.016  45.792  1.00 15.55           C  
ATOM   1648  CG  TRP B  44       5.197  -1.069  46.765  1.00 15.80           C  
ATOM   1649  CD1 TRP B  44       6.401  -1.163  47.394  1.00 16.76           C  
ATOM   1650  CD2 TRP B  44       4.417  -2.185  47.216  1.00 16.27           C  
ATOM   1651  NE1 TRP B  44       6.433  -2.288  48.202  1.00 16.45           N  
ATOM   1652  CE2 TRP B  44       5.225  -2.929  48.109  1.00 16.58           C  
ATOM   1653  CE3 TRP B  44       3.111  -2.640  46.933  1.00 15.65           C  
ATOM   1654  CZ2 TRP B  44       4.765  -4.096  48.741  1.00 16.38           C  
ATOM   1655  CZ3 TRP B  44       2.654  -3.794  47.552  1.00 15.23           C  
ATOM   1656  CH2 TRP B  44       3.477  -4.508  48.450  1.00 16.11           C  
ATOM   1657  N   PHE B  45       4.122  -2.064  43.500  1.00 14.47           N  
ATOM   1658  CA  PHE B  45       3.961  -3.401  42.931  1.00 14.84           C  
ATOM   1659  C   PHE B  45       4.837  -3.536  41.672  1.00 14.97           C  
ATOM   1660  O   PHE B  45       5.573  -4.519  41.518  1.00 14.66           O  
ATOM   1661  CB  PHE B  45       2.468  -3.638  42.628  1.00 15.18           C  
ATOM   1662  CG  PHE B  45       2.124  -5.038  42.127  1.00 15.42           C  
ATOM   1663  CD1 PHE B  45       1.632  -5.999  43.000  1.00 16.12           C  
ATOM   1664  CD2 PHE B  45       2.237  -5.367  40.778  1.00 17.10           C  
ATOM   1665  CE1 PHE B  45       1.285  -7.272  42.545  1.00 17.19           C  
ATOM   1666  CE2 PHE B  45       1.898  -6.647  40.315  1.00 18.64           C  
ATOM   1667  CZ  PHE B  45       1.419  -7.596  41.204  1.00 16.72           C  
ATOM   1668  N   ASP B  46       4.776  -2.532  40.791  1.00 14.75           N  
ATOM   1669  CA  ASP B  46       5.569  -2.521  39.546  1.00 14.99           C  
ATOM   1670  C   ASP B  46       7.076  -2.511  39.838  1.00 14.75           C  
ATOM   1671  O   ASP B  46       7.857  -3.193  39.172  1.00 15.03           O  
ATOM   1672  CB  ASP B  46       5.217  -1.300  38.697  1.00 14.84           C  
ATOM   1673  CG  ASP B  46       3.785  -1.306  38.208  1.00 17.00           C  
ATOM   1674  OD1 ASP B  46       3.145  -2.392  38.160  1.00 19.64           O  
ATOM   1675  OD2 ASP B  46       3.294  -0.203  37.851  1.00 16.97           O  
ATOM   1676  N   THR B  47       7.479  -1.731  40.837  1.00 14.41           N  
ATOM   1677  CA  THR B  47       8.874  -1.688  41.262  1.00 14.59           C  
ATOM   1678  C   THR B  47       9.363  -3.087  41.654  1.00 13.63           C  
ATOM   1679  O   THR B  47      10.392  -3.550  41.153  1.00 13.20           O  
ATOM   1680  CB  THR B  47       9.078  -0.672  42.405  1.00 14.92           C  
ATOM   1681  OG1 THR B  47       8.731   0.634  41.924  1.00 17.07           O  
ATOM   1682  CG2 THR B  47      10.542  -0.659  42.888  1.00 15.42           C  
ATOM   1683  N   ARG B  48       8.620  -3.757  42.531  1.00 13.10           N  
ATOM   1684  CA  ARG B  48       8.961  -5.135  42.945  1.00 13.01           C  
ATOM   1685  C   ARG B  48       9.022  -6.097  41.745  1.00 12.44           C  
ATOM   1686  O   ARG B  48       9.907  -6.957  41.667  1.00 11.95           O  
ATOM   1687  CB  ARG B  48       7.953  -5.649  43.980  1.00 13.04           C  
ATOM   1688  CG  ARG B  48       7.991  -4.908  45.339  1.00 14.00           C  
ATOM   1689  CD  ARG B  48       9.305  -5.133  46.074  1.00 15.70           C  
ATOM   1690  NE  ARG B  48       9.322  -4.383  47.329  1.00 18.06           N  
ATOM   1691  CZ  ARG B  48       9.868  -3.178  47.467  1.00 19.57           C  
ATOM   1692  NH1 ARG B  48      10.455  -2.589  46.435  1.00 19.63           N  
ATOM   1693  NH2 ARG B  48       9.826  -2.561  48.647  1.00 19.29           N  
ATOM   1694  N   ALA B  49       8.087  -5.928  40.810  1.00 12.18           N  
ATOM   1695  CA  ALA B  49       8.074  -6.707  39.565  1.00 13.06           C  
ATOM   1696  C   ALA B  49       9.362  -6.511  38.760  1.00 13.55           C  
ATOM   1697  O   ALA B  49       9.962  -7.491  38.290  1.00 13.73           O  
ATOM   1698  CB  ALA B  49       6.855  -6.349  38.715  1.00 13.07           C  
ATOM   1699  N   ARG B  50       9.778  -5.251  38.603  1.00 14.01           N  
ATOM   1700  CA  ARG B  50      11.039  -4.920  37.908  1.00 14.49           C  
ATOM   1701  C   ARG B  50      12.246  -5.536  38.606  1.00 14.79           C  
ATOM   1702  O   ARG B  50      13.187  -6.001  37.952  1.00 14.76           O  
ATOM   1703  CB  ARG B  50      11.237  -3.404  37.816  1.00 14.28           C  
ATOM   1704  CG  ARG B  50      10.291  -2.706  36.857  1.00 14.67           C  
ATOM   1705  CD  ARG B  50      10.784  -1.312  36.453  1.00 14.53           C  
ATOM   1706  NE  ARG B  50      11.015  -0.437  37.599  1.00 15.64           N  
ATOM   1707  CZ  ARG B  50      10.080   0.273  38.232  1.00 16.54           C  
ATOM   1708  NH1 ARG B  50       8.800   0.229  37.860  1.00 15.65           N  
ATOM   1709  NH2 ARG B  50      10.429   1.029  39.270  1.00 16.85           N  
ATOM   1710  N   GLN B  51      12.216  -5.536  39.937  1.00 15.07           N  
ATOM   1711  CA  GLN B  51      13.324  -6.052  40.736  1.00 15.39           C  
ATOM   1712  C   GLN B  51      13.323  -7.577  40.786  1.00 15.24           C  
ATOM   1713  O   GLN B  51      14.344  -8.188  41.100  1.00 16.05           O  
ATOM   1714  CB  GLN B  51      13.249  -5.509  42.158  1.00 15.63           C  
ATOM   1715  CG  GLN B  51      13.454  -4.022  42.296  1.00 16.33           C  
ATOM   1716  CD  GLN B  51      13.009  -3.531  43.665  1.00 18.94           C  
ATOM   1717  OE1 GLN B  51      11.961  -3.947  44.183  1.00 18.49           O  
ATOM   1718  NE2 GLN B  51      13.798  -2.638  44.256  1.00 19.79           N  
ATOM   1719  N   GLY B  52      12.183  -8.180  40.462  1.00 14.97           N  
ATOM   1720  CA  GLY B  52      12.007  -9.625  40.574  1.00 15.59           C  
ATOM   1721  C   GLY B  52      11.856 -10.088  42.015  1.00 15.64           C  
ATOM   1722  O   GLY B  52      12.119 -11.252  42.333  1.00 16.15           O  
ATOM   1723  N   TYR B  53      11.439  -9.171  42.886  1.00 15.27           N  
ATOM   1724  CA  TYR B  53      11.233  -9.462  44.298  1.00 14.76           C  
ATOM   1725  C   TYR B  53       9.764  -9.781  44.570  1.00 14.37           C  
ATOM   1726  O   TYR B  53       8.870  -9.160  43.977  1.00 14.16           O  
ATOM   1727  CB  TYR B  53      11.647  -8.265  45.163  1.00 15.51           C  
ATOM   1728  CG  TYR B  53      13.129  -7.919  45.147  1.00 15.58           C  
ATOM   1729  CD1 TYR B  53      14.102  -8.895  44.936  1.00 15.56           C  
ATOM   1730  CD2 TYR B  53      13.548  -6.614  45.391  1.00 16.84           C  
ATOM   1731  CE1 TYR B  53      15.467  -8.561  44.935  1.00 17.50           C  
ATOM   1732  CE2 TYR B  53      14.901  -6.275  45.397  1.00 16.84           C  
ATOM   1733  CZ  TYR B  53      15.845  -7.247  45.175  1.00 16.67           C  
ATOM   1734  OH  TYR B  53      17.186  -6.902  45.185  1.00 19.04           O  
ATOM   1735  N   PRO B  54       9.509 -10.725  45.492  1.00 13.72           N  
ATOM   1736  CA  PRO B  54       8.143 -11.185  45.735  1.00 13.56           C  
ATOM   1737  C   PRO B  54       7.311 -10.212  46.554  1.00 12.97           C  
ATOM   1738  O   PRO B  54       7.848  -9.419  47.334  1.00 12.27           O  
ATOM   1739  CB  PRO B  54       8.365 -12.479  46.530  1.00 13.50           C  
ATOM   1740  CG  PRO B  54       9.611 -12.201  47.318  1.00 13.99           C  
ATOM   1741  CD  PRO B  54      10.477 -11.442  46.346  1.00 14.15           C  
ATOM   1742  N   ILE B  55       5.998 -10.267  46.362  1.00 12.80           N  
ATOM   1743  CA  ILE B  55       5.070  -9.699  47.331  1.00 13.00           C  
ATOM   1744  C   ILE B  55       4.132 -10.852  47.661  1.00 12.67           C  
ATOM   1745  O   ILE B  55       3.527 -11.444  46.762  1.00 12.45           O  
ATOM   1746  CB  ILE B  55       4.259  -8.492  46.756  1.00 12.89           C  
ATOM   1747  CG1 ILE B  55       5.185  -7.338  46.334  1.00 12.56           C  
ATOM   1748  CG2 ILE B  55       3.229  -8.016  47.768  1.00 12.22           C  
ATOM   1749  CD1 ILE B  55       4.534  -6.363  45.354  1.00 12.94           C  
ATOM   1750  N   LEU B  56       4.025 -11.187  48.939  1.00 12.44           N  
ATOM   1751  CA  LEU B  56       3.170 -12.290  49.351  1.00 12.68           C  
ATOM   1752  C   LEU B  56       2.007 -11.745  50.164  1.00 13.19           C  
ATOM   1753  O   LEU B  56       2.138 -10.720  50.854  1.00 12.39           O  
ATOM   1754  CB  LEU B  56       3.946 -13.317  50.186  1.00 12.58           C  
ATOM   1755  CG  LEU B  56       5.290 -13.818  49.665  1.00 12.28           C  
ATOM   1756  CD1 LEU B  56       5.953 -14.682  50.715  1.00 12.64           C  
ATOM   1757  CD2 LEU B  56       5.144 -14.605  48.336  1.00 11.13           C  
ATOM   1758  N   VAL B  57       0.867 -12.428  50.082  1.00 13.47           N  
ATOM   1759  CA  VAL B  57      -0.273 -12.080  50.910  1.00 14.62           C  
ATOM   1760  C   VAL B  57      -0.700 -13.298  51.719  1.00 15.76           C  
ATOM   1761  O   VAL B  57      -0.524 -14.450  51.279  1.00 16.44           O  
ATOM   1762  CB  VAL B  57      -1.487 -11.519  50.087  1.00 14.82           C  
ATOM   1763  CG1 VAL B  57      -1.174 -10.138  49.506  1.00 14.83           C  
ATOM   1764  CG2 VAL B  57      -1.907 -12.483  48.985  1.00 15.12           C  
ATOM   1765  N   ALA B  58      -1.237 -13.030  52.903  1.00 16.64           N  
ATOM   1766  CA  ALA B  58      -1.976 -14.010  53.687  1.00 18.33           C  
ATOM   1767  C   ALA B  58      -3.434 -13.762  53.349  1.00 19.75           C  
ATOM   1768  O   ALA B  58      -3.942 -12.661  53.547  1.00 19.40           O  
ATOM   1769  CB  ALA B  58      -1.722 -13.816  55.175  1.00 18.03           C  
ATOM   1770  N   SER B  59      -4.103 -14.777  52.812  1.00 21.90           N  
ATOM   1771  CA  SER B  59      -5.428 -14.570  52.241  1.00 24.08           C  
ATOM   1772  C   SER B  59      -6.421 -15.565  52.825  1.00 25.05           C  
ATOM   1773  O   SER B  59      -6.036 -16.655  53.262  1.00 25.28           O  
ATOM   1774  CB  SER B  59      -5.362 -14.682  50.712  1.00 24.44           C  
ATOM   1775  OG  SER B  59      -6.611 -14.423  50.101  1.00 26.25           O  
ATOM   1776  N   ASP B  60      -7.687 -15.165  52.877  1.00 26.30           N  
ATOM   1777  CA  ASP B  60      -8.753 -16.104  53.232  1.00 27.69           C  
ATOM   1778  C   ASP B  60      -9.556 -16.499  52.000  1.00 28.22           C  
ATOM   1779  O   ASP B  60      -9.244 -16.075  50.877  1.00 28.50           O  
ATOM   1780  CB  ASP B  60      -9.643 -15.563  54.363  1.00 27.61           C  
ATOM   1781  CG  ASP B  60     -10.443 -14.334  53.965  1.00 28.70           C  
ATOM   1782  OD1 ASP B  60     -10.554 -14.026  52.752  1.00 29.88           O  
ATOM   1783  OD2 ASP B  60     -10.983 -13.678  54.887  1.00 28.73           O  
ATOM   1784  N   ALA B  61     -10.583 -17.315  52.221  1.00 29.34           N  
ATOM   1785  CA  ALA B  61     -11.434 -17.849  51.158  1.00 29.59           C  
ATOM   1786  C   ALA B  61     -11.977 -16.766  50.217  1.00 29.92           C  
ATOM   1787  O   ALA B  61     -11.866 -16.885  48.994  1.00 30.02           O  
ATOM   1788  CB  ALA B  61     -12.571 -18.637  51.771  1.00 29.94           C  
ATOM   1789  N   ALA B  62     -12.551 -15.712  50.802  1.00 30.16           N  
ATOM   1790  CA  ALA B  62     -13.117 -14.580  50.052  1.00 30.16           C  
ATOM   1791  C   ALA B  62     -12.068 -13.734  49.314  1.00 30.08           C  
ATOM   1792  O   ALA B  62     -12.413 -12.836  48.536  1.00 30.33           O  
ATOM   1793  CB  ALA B  62     -13.957 -13.696  50.987  1.00 30.26           C  
ATOM   1794  N   GLY B  63     -10.792 -14.025  49.559  1.00 29.53           N  
ATOM   1795  CA  GLY B  63      -9.707 -13.275  48.952  1.00 28.72           C  
ATOM   1796  C   GLY B  63      -9.398 -11.989  49.695  1.00 27.88           C  
ATOM   1797  O   GLY B  63      -8.755 -11.093  49.136  1.00 28.45           O  
ATOM   1798  N   GLU B  64      -9.867 -11.889  50.940  1.00 26.10           N  
ATOM   1799  CA  GLU B  64      -9.500 -10.786  51.825  1.00 25.02           C  
ATOM   1800  C   GLU B  64      -8.006 -10.874  52.126  1.00 22.26           C  
ATOM   1801  O   GLU B  64      -7.489 -11.956  52.389  1.00 21.52           O  
ATOM   1802  CB  GLU B  64     -10.262 -10.865  53.154  1.00 25.45           C  
ATOM   1803  CG  GLU B  64     -11.709 -10.407  53.117  1.00 27.44           C  
ATOM   1804  CD  GLU B  64     -12.432 -10.666  54.438  1.00 27.97           C  
ATOM   1805  OE1 GLU B  64     -12.186  -9.917  55.426  1.00 31.40           O  
ATOM   1806  OE2 GLU B  64     -13.264 -11.613  54.476  1.00 31.50           O  
ATOM   1807  N   VAL B  65      -7.322  -9.736  52.075  1.00 19.64           N  
ATOM   1808  CA  VAL B  65      -5.908  -9.680  52.430  1.00 17.02           C  
ATOM   1809  C   VAL B  65      -5.837  -9.520  53.954  1.00 15.66           C  
ATOM   1810  O   VAL B  65      -6.252  -8.500  54.497  1.00 15.66           O  
ATOM   1811  CB  VAL B  65      -5.195  -8.506  51.712  1.00 16.76           C  
ATOM   1812  CG1 VAL B  65      -3.716  -8.436  52.116  1.00 15.66           C  
ATOM   1813  CG2 VAL B  65      -5.340  -8.641  50.189  1.00 17.01           C  
ATOM   1814  N   LEU B  66      -5.328 -10.540  54.633  1.00 14.16           N  
ATOM   1815  CA  LEU B  66      -5.193 -10.533  56.092  1.00 13.16           C  
ATOM   1816  C   LEU B  66      -3.820  -9.994  56.524  1.00 12.52           C  
ATOM   1817  O   LEU B  66      -3.635  -9.569  57.661  1.00 12.80           O  
ATOM   1818  CB  LEU B  66      -5.363 -11.948  56.636  1.00 12.90           C  
ATOM   1819  CG  LEU B  66      -6.629 -12.709  56.220  1.00 13.82           C  
ATOM   1820  CD1 LEU B  66      -6.551 -14.132  56.741  1.00 14.68           C  
ATOM   1821  CD2 LEU B  66      -7.855 -11.995  56.742  1.00 13.14           C  
ATOM   1822  N   GLY B  67      -2.860 -10.054  55.610  1.00 11.92           N  
ATOM   1823  CA  GLY B  67      -1.528  -9.515  55.853  1.00 11.00           C  
ATOM   1824  C   GLY B  67      -0.723  -9.603  54.577  1.00 11.07           C  
ATOM   1825  O   GLY B  67      -1.141 -10.263  53.621  1.00  9.86           O  
ATOM   1826  N   TYR B  68       0.424  -8.937  54.544  1.00 10.02           N  
ATOM   1827  CA  TYR B  68       1.306  -9.070  53.380  1.00 10.86           C  
ATOM   1828  C   TYR B  68       2.763  -8.863  53.757  1.00 10.46           C  
ATOM   1829  O   TYR B  68       3.059  -8.341  54.835  1.00 10.30           O  
ATOM   1830  CB  TYR B  68       0.891  -8.125  52.236  1.00 10.77           C  
ATOM   1831  CG  TYR B  68       1.230  -6.654  52.439  1.00 12.43           C  
ATOM   1832  CD1 TYR B  68       2.404  -6.109  51.906  1.00 13.07           C  
ATOM   1833  CD2 TYR B  68       0.356  -5.809  53.128  1.00 12.70           C  
ATOM   1834  CE1 TYR B  68       2.707  -4.760  52.073  1.00 14.32           C  
ATOM   1835  CE2 TYR B  68       0.638  -4.471  53.294  1.00 13.49           C  
ATOM   1836  CZ  TYR B  68       1.808  -3.948  52.766  1.00 13.03           C  
ATOM   1837  OH  TYR B  68       2.085  -2.620  52.936  1.00 14.81           O  
ATOM   1838  N   ALA B  69       3.658  -9.275  52.861  1.00 10.63           N  
ATOM   1839  CA  ALA B  69       5.093  -9.201  53.106  1.00 10.92           C  
ATOM   1840  C   ALA B  69       5.841  -9.029  51.799  1.00 10.93           C  
ATOM   1841  O   ALA B  69       5.439  -9.563  50.767  1.00 10.72           O  
ATOM   1842  CB  ALA B  69       5.590 -10.453  53.826  1.00 10.88           C  
ATOM   1843  N   SER B  70       6.927  -8.264  51.839  1.00  9.88           N  
ATOM   1844  CA  SER B  70       7.758  -8.121  50.653  1.00  9.86           C  
ATOM   1845  C   SER B  70       9.184  -7.814  51.098  1.00  9.97           C  
ATOM   1846  O   SER B  70       9.441  -7.579  52.285  1.00  9.70           O  
ATOM   1847  CB  SER B  70       7.216  -6.996  49.745  1.00 10.27           C  
ATOM   1848  OG  SER B  70       7.828  -7.046  48.459  1.00 11.12           O  
ATOM   1849  N   TYR B  71      10.105  -7.809  50.155  1.00  9.48           N  
ATOM   1850  CA  TYR B  71      11.412  -7.206  50.410  1.00 10.38           C  
ATOM   1851  C   TYR B  71      11.897  -6.419  49.220  1.00 10.91           C  
ATOM   1852  O   TYR B  71      11.470  -6.662  48.094  1.00 10.15           O  
ATOM   1853  CB  TYR B  71      12.460  -8.225  50.881  1.00  9.94           C  
ATOM   1854  CG  TYR B  71      12.651  -9.450  50.022  1.00 10.87           C  
ATOM   1855  CD1 TYR B  71      13.321  -9.392  48.798  1.00 11.18           C  
ATOM   1856  CD2 TYR B  71      12.198 -10.689  50.464  1.00 12.14           C  
ATOM   1857  CE1 TYR B  71      13.525 -10.550  48.028  1.00 11.40           C  
ATOM   1858  CE2 TYR B  71      12.383 -11.835  49.706  1.00 12.08           C  
ATOM   1859  CZ  TYR B  71      13.039 -11.762  48.492  1.00 11.46           C  
ATOM   1860  OH  TYR B  71      13.219 -12.920  47.755  1.00 12.56           O  
ATOM   1861  N   GLY B  72      12.756  -5.437  49.499  1.00 11.28           N  
ATOM   1862  CA  GLY B  72      13.371  -4.631  48.465  1.00 11.94           C  
ATOM   1863  C   GLY B  72      14.838  -4.438  48.773  1.00 12.58           C  
ATOM   1864  O   GLY B  72      15.392  -5.087  49.675  1.00 11.80           O  
ATOM   1865  N   ASP B  73      15.470  -3.531  48.040  1.00 13.73           N  
ATOM   1866  CA  ASP B  73      16.879  -3.239  48.282  1.00 15.13           C  
ATOM   1867  C   ASP B  73      17.014  -2.509  49.607  1.00 15.11           C  
ATOM   1868  O   ASP B  73      16.086  -1.801  50.050  1.00 15.42           O  
ATOM   1869  CB  ASP B  73      17.461  -2.412  47.145  1.00 15.96           C  
ATOM   1870  CG  ASP B  73      17.443  -3.147  45.841  1.00 17.79           C  
ATOM   1871  OD1 ASP B  73      17.720  -4.370  45.828  1.00 21.97           O  
ATOM   1872  OD2 ASP B  73      17.152  -2.494  44.825  1.00 24.52           O  
ATOM   1873  N   TRP B  74      18.157  -2.718  50.259  1.00 14.87           N  
ATOM   1874  CA  TRP B  74      18.418  -2.109  51.558  1.00 15.01           C  
ATOM   1875  C   TRP B  74      19.216  -0.809  51.397  1.00 15.95           C  
ATOM   1876  O   TRP B  74      18.828   0.228  51.938  1.00 16.59           O  
ATOM   1877  CB  TRP B  74      19.119  -3.113  52.482  1.00 14.96           C  
ATOM   1878  CG  TRP B  74      19.492  -2.549  53.821  1.00 14.45           C  
ATOM   1879  CD1 TRP B  74      18.659  -1.954  54.720  1.00 15.07           C  
ATOM   1880  CD2 TRP B  74      20.804  -2.510  54.401  1.00 13.92           C  
ATOM   1881  NE1 TRP B  74      19.366  -1.544  55.822  1.00 15.47           N  
ATOM   1882  CE2 TRP B  74      20.684  -1.879  55.658  1.00 14.48           C  
ATOM   1883  CE3 TRP B  74      22.068  -2.951  53.981  1.00 14.47           C  
ATOM   1884  CZ2 TRP B  74      21.776  -1.687  56.512  1.00 14.47           C  
ATOM   1885  CZ3 TRP B  74      23.159  -2.752  54.827  1.00 14.07           C  
ATOM   1886  CH2 TRP B  74      23.002  -2.119  56.076  1.00 14.46           C  
ATOM   1887  N   ARG B  75      20.318  -0.867  50.653  1.00 15.72           N  
ATOM   1888  CA  ARG B  75      21.089   0.314  50.302  1.00 16.83           C  
ATOM   1889  C   ARG B  75      21.309   0.317  48.782  1.00 18.52           C  
ATOM   1890  O   ARG B  75      21.542  -0.747  48.200  1.00 18.63           O  
ATOM   1891  CB  ARG B  75      22.419   0.348  51.059  1.00 16.36           C  
ATOM   1892  CG  ARG B  75      22.260   0.642  52.551  1.00 15.82           C  
ATOM   1893  CD  ARG B  75      23.584   0.584  53.308  1.00 16.10           C  
ATOM   1894  NE  ARG B  75      24.564   1.546  52.820  1.00 15.91           N  
ATOM   1895  CZ  ARG B  75      24.624   2.831  53.180  1.00 17.20           C  
ATOM   1896  NH1 ARG B  75      23.745   3.350  54.041  1.00 16.18           N  
ATOM   1897  NH2 ARG B  75      25.568   3.605  52.667  1.00 15.50           N  
ATOM   1898  N   PRO B  76      21.196   1.499  48.136  1.00 19.96           N  
ATOM   1899  CA  PRO B  76      21.288   1.642  46.675  1.00 20.99           C  
ATOM   1900  C   PRO B  76      22.703   1.673  46.108  1.00 21.47           C  
ATOM   1901  O   PRO B  76      23.091   2.662  45.471  1.00 22.41           O  
ATOM   1902  CB  PRO B  76      20.617   3.001  46.428  1.00 20.95           C  
ATOM   1903  CG  PRO B  76      21.009   3.799  47.637  1.00 21.08           C  
ATOM   1904  CD  PRO B  76      20.908   2.801  48.782  1.00 20.19           C  
ATOM   1905  N   PHE B  77      23.474   0.616  46.341  1.00 21.52           N  
ATOM   1906  CA  PHE B  77      24.798   0.467  45.746  1.00 21.35           C  
ATOM   1907  C   PHE B  77      24.969  -1.004  45.355  1.00 20.82           C  
ATOM   1908  O   PHE B  77      24.455  -1.906  46.044  1.00 19.85           O  
ATOM   1909  CB  PHE B  77      25.917   0.896  46.724  1.00 22.19           C  
ATOM   1910  CG  PHE B  77      25.775   2.306  47.255  1.00 23.22           C  
ATOM   1911  CD1 PHE B  77      26.437   3.366  46.638  1.00 25.00           C  
ATOM   1912  CD2 PHE B  77      24.976   2.573  48.372  1.00 23.91           C  
ATOM   1913  CE1 PHE B  77      26.301   4.676  47.122  1.00 25.80           C  
ATOM   1914  CE2 PHE B  77      24.828   3.879  48.864  1.00 25.32           C  
ATOM   1915  CZ  PHE B  77      25.498   4.932  48.240  1.00 24.52           C  
ATOM   1916  N   GLU B  78      25.694  -1.252  44.266  1.00 20.16           N  
ATOM   1917  CA  GLU B  78      25.866  -2.619  43.756  1.00 20.21           C  
ATOM   1918  C   GLU B  78      26.508  -3.583  44.774  1.00 18.88           C  
ATOM   1919  O   GLU B  78      26.222  -4.783  44.760  1.00 18.40           O  
ATOM   1920  CB  GLU B  78      26.631  -2.644  42.422  1.00 20.22           C  
ATOM   1921  CG  GLU B  78      28.100  -2.238  42.499  1.00 21.85           C  
ATOM   1922  CD  GLU B  78      28.850  -2.409  41.179  1.00 22.48           C  
ATOM   1923  OE1 GLU B  78      28.251  -2.168  40.095  1.00 25.75           O  
ATOM   1924  OE2 GLU B  78      30.053  -2.763  41.229  1.00 23.39           O  
ATOM   1925  N   GLY B  79      27.356  -3.054  45.657  1.00 17.61           N  
ATOM   1926  CA  GLY B  79      27.997  -3.876  46.689  1.00 16.39           C  
ATOM   1927  C   GLY B  79      27.027  -4.486  47.692  1.00 15.81           C  
ATOM   1928  O   GLY B  79      27.401  -5.382  48.452  1.00 15.65           O  
ATOM   1929  N   PHE B  80      25.785  -4.001  47.695  1.00 14.60           N  
ATOM   1930  CA  PHE B  80      24.750  -4.484  48.618  1.00 14.79           C  
ATOM   1931  C   PHE B  80      23.744  -5.464  47.988  1.00 14.69           C  
ATOM   1932  O   PHE B  80      22.744  -5.835  48.612  1.00 14.53           O  
ATOM   1933  CB  PHE B  80      24.024  -3.307  49.262  1.00 14.35           C  
ATOM   1934  CG  PHE B  80      24.897  -2.493  50.171  1.00 15.92           C  
ATOM   1935  CD1 PHE B  80      25.151  -2.913  51.473  1.00 16.50           C  
ATOM   1936  CD2 PHE B  80      25.494  -1.320  49.717  1.00 14.93           C  
ATOM   1937  CE1 PHE B  80      25.981  -2.164  52.308  1.00 17.25           C  
ATOM   1938  CE2 PHE B  80      26.316  -0.566  50.542  1.00 15.84           C  
ATOM   1939  CZ  PHE B  80      26.555  -0.984  51.843  1.00 16.50           C  
ATOM   1940  N   ARG B  81      24.045  -5.922  46.780  1.00 14.87           N  
ATOM   1941  CA  ARG B  81      23.140  -6.821  46.055  1.00 16.01           C  
ATOM   1942  C   ARG B  81      22.768  -8.140  46.778  1.00 15.89           C  
ATOM   1943  O   ARG B  81      21.737  -8.743  46.480  1.00 15.94           O  
ATOM   1944  CB  ARG B  81      23.663  -7.086  44.640  1.00 16.56           C  
ATOM   1945  CG  ARG B  81      25.025  -7.736  44.578  1.00 18.95           C  
ATOM   1946  CD  ARG B  81      25.566  -7.664  43.160  1.00 23.53           C  
ATOM   1947  NE  ARG B  81      26.859  -8.313  42.993  1.00 25.93           N  
ATOM   1948  CZ  ARG B  81      28.041  -7.726  43.184  1.00 28.06           C  
ATOM   1949  NH1 ARG B  81      28.114  -6.458  43.576  1.00 28.42           N  
ATOM   1950  NH2 ARG B  81      29.157  -8.414  42.983  1.00 27.92           N  
ATOM   1951  N   GLY B  82      23.581  -8.584  47.733  1.00 15.89           N  
ATOM   1952  CA  GLY B  82      23.199  -9.770  48.541  1.00 15.67           C  
ATOM   1953  C   GLY B  82      22.240  -9.521  49.710  1.00 14.75           C  
ATOM   1954  O   GLY B  82      21.826 -10.465  50.403  1.00 14.95           O  
ATOM   1955  N   THR B  83      21.879  -8.260  49.927  1.00 13.13           N  
ATOM   1956  CA  THR B  83      21.148  -7.850  51.119  1.00 11.93           C  
ATOM   1957  C   THR B  83      19.823  -7.217  50.717  1.00 11.07           C  
ATOM   1958  O   THR B  83      19.776  -6.376  49.820  1.00 11.38           O  
ATOM   1959  CB  THR B  83      22.000  -6.858  51.957  1.00 11.48           C  
ATOM   1960  OG1 THR B  83      23.287  -7.452  52.237  1.00 12.46           O  
ATOM   1961  CG2 THR B  83      21.333  -6.513  53.269  1.00 12.00           C  
ATOM   1962  N   VAL B  84      18.744  -7.641  51.368  1.00 10.72           N  
ATOM   1963  CA  VAL B  84      17.445  -7.031  51.129  1.00 10.04           C  
ATOM   1964  C   VAL B  84      16.854  -6.628  52.464  1.00 10.35           C  
ATOM   1965  O   VAL B  84      17.239  -7.184  53.514  1.00  9.77           O  
ATOM   1966  CB  VAL B  84      16.462  -7.974  50.384  1.00  9.71           C  
ATOM   1967  CG1 VAL B  84      16.921  -8.231  48.937  1.00 10.12           C  
ATOM   1968  CG2 VAL B  84      16.252  -9.297  51.149  1.00  8.69           C  
ATOM   1969  N   GLU B  85      15.920  -5.678  52.425  1.00 10.32           N  
ATOM   1970  CA  GLU B  85      15.206  -5.289  53.621  1.00 11.47           C  
ATOM   1971  C   GLU B  85      13.738  -5.634  53.430  1.00 11.61           C  
ATOM   1972  O   GLU B  85      13.126  -5.234  52.452  1.00 10.62           O  
ATOM   1973  CB  GLU B  85      15.374  -3.797  53.939  1.00 11.93           C  
ATOM   1974  CG  GLU B  85      14.430  -3.343  55.079  1.00 13.26           C  
ATOM   1975  CD  GLU B  85      14.469  -1.869  55.362  1.00 13.94           C  
ATOM   1976  OE1 GLU B  85      15.450  -1.191  54.988  1.00 17.66           O  
ATOM   1977  OE2 GLU B  85      13.490  -1.380  55.968  1.00 15.30           O  
ATOM   1978  N   HIS B  86      13.184  -6.383  54.373  1.00 10.87           N  
ATOM   1979  CA  HIS B  86      11.833  -6.860  54.221  1.00 12.19           C  
ATOM   1980  C   HIS B  86      10.857  -6.041  55.070  1.00 12.76           C  
ATOM   1981  O   HIS B  86      11.267  -5.273  55.972  1.00 12.46           O  
ATOM   1982  CB  HIS B  86      11.752  -8.349  54.566  1.00 12.08           C  
ATOM   1983  CG  HIS B  86      11.847  -8.628  56.036  1.00 14.30           C  
ATOM   1984  ND1 HIS B  86      13.053  -8.763  56.689  1.00 16.23           N  
ATOM   1985  CD2 HIS B  86      10.887  -8.759  56.983  1.00 14.43           C  
ATOM   1986  CE1 HIS B  86      12.831  -8.991  57.972  1.00 16.57           C  
ATOM   1987  NE2 HIS B  86      11.527  -8.967  58.181  1.00 16.50           N  
ATOM   1988  N   SER B  87       9.572  -6.187  54.767  1.00 12.72           N  
ATOM   1989  CA  SER B  87       8.514  -5.640  55.616  1.00 13.39           C  
ATOM   1990  C   SER B  87       7.369  -6.647  55.688  1.00 13.25           C  
ATOM   1991  O   SER B  87       7.095  -7.347  54.715  1.00 12.61           O  
ATOM   1992  CB  SER B  87       8.027  -4.293  55.081  1.00 15.03           C  
ATOM   1993  OG  SER B  87       7.440  -4.456  53.807  1.00 19.30           O  
ATOM   1994  N   VAL B  88       6.727  -6.741  56.846  1.00 12.20           N  
ATOM   1995  CA  VAL B  88       5.617  -7.681  57.049  1.00 12.74           C  
ATOM   1996  C   VAL B  88       4.541  -6.912  57.776  1.00 12.80           C  
ATOM   1997  O   VAL B  88       4.815  -6.321  58.815  1.00 11.94           O  
ATOM   1998  CB  VAL B  88       6.043  -8.933  57.902  1.00 12.35           C  
ATOM   1999  CG1 VAL B  88       4.855  -9.886  58.152  1.00 13.25           C  
ATOM   2000  CG2 VAL B  88       7.148  -9.702  57.224  1.00 15.55           C  
ATOM   2001  N   TYR B  89       3.325  -6.916  57.230  1.00 13.44           N  
ATOM   2002  CA  TYR B  89       2.191  -6.242  57.867  1.00 14.96           C  
ATOM   2003  C   TYR B  89       1.046  -7.223  58.049  1.00 14.47           C  
ATOM   2004  O   TYR B  89       0.711  -7.967  57.129  1.00 14.00           O  
ATOM   2005  CB  TYR B  89       1.730  -5.051  57.015  1.00 16.56           C  
ATOM   2006  CG  TYR B  89       2.863  -4.092  56.714  1.00 20.22           C  
ATOM   2007  CD1 TYR B  89       3.271  -3.160  57.660  1.00 24.11           C  
ATOM   2008  CD2 TYR B  89       3.552  -4.152  55.504  1.00 21.90           C  
ATOM   2009  CE1 TYR B  89       4.339  -2.303  57.406  1.00 26.37           C  
ATOM   2010  CE2 TYR B  89       4.603  -3.292  55.240  1.00 24.06           C  
ATOM   2011  CZ  TYR B  89       4.986  -2.372  56.198  1.00 22.60           C  
ATOM   2012  OH  TYR B  89       6.040  -1.518  55.956  1.00 26.36           O  
ATOM   2013  N   VAL B  90       0.475  -7.237  59.245  1.00 14.22           N  
ATOM   2014  CA  VAL B  90      -0.707  -8.037  59.543  1.00 14.45           C  
ATOM   2015  C   VAL B  90      -1.876  -7.094  59.834  1.00 14.84           C  
ATOM   2016  O   VAL B  90      -1.721  -6.113  60.568  1.00 14.71           O  
ATOM   2017  CB  VAL B  90      -0.427  -9.007  60.728  1.00 14.99           C  
ATOM   2018  CG1 VAL B  90      -1.686  -9.742  61.165  1.00 14.98           C  
ATOM   2019  CG2 VAL B  90       0.660 -10.021  60.325  1.00 14.86           C  
ATOM   2020  N   ARG B  91      -3.041  -7.374  59.248  1.00 15.19           N  
ATOM   2021  CA  ARG B  91      -4.225  -6.572  59.527  1.00 15.48           C  
ATOM   2022  C   ARG B  91      -4.487  -6.583  61.035  1.00 16.04           C  
ATOM   2023  O   ARG B  91      -4.384  -7.626  61.690  1.00 15.66           O  
ATOM   2024  CB  ARG B  91      -5.438  -7.113  58.763  1.00 16.15           C  
ATOM   2025  CG  ARG B  91      -6.492  -6.058  58.435  1.00 17.80           C  
ATOM   2026  CD  ARG B  91      -7.504  -6.605  57.420  1.00 19.89           C  
ATOM   2027  NE  ARG B  91      -8.375  -7.614  58.018  1.00 22.08           N  
ATOM   2028  CZ  ARG B  91      -9.374  -8.241  57.386  1.00 24.73           C  
ATOM   2029  NH1 ARG B  91      -9.640  -7.986  56.110  1.00 24.62           N  
ATOM   2030  NH2 ARG B  91     -10.104  -9.150  58.029  1.00 23.78           N  
ATOM   2031  N   ASP B  92      -4.797  -5.414  61.581  1.00 16.29           N  
ATOM   2032  CA  ASP B  92      -4.944  -5.251  63.025  1.00 17.29           C  
ATOM   2033  C   ASP B  92      -5.823  -6.335  63.712  1.00 17.22           C  
ATOM   2034  O   ASP B  92      -5.454  -6.873  64.765  1.00 17.52           O  
ATOM   2035  CB  ASP B  92      -5.470  -3.844  63.332  1.00 17.94           C  
ATOM   2036  CG  ASP B  92      -5.468  -3.541  64.814  1.00 18.94           C  
ATOM   2037  OD1 ASP B  92      -4.379  -3.532  65.393  1.00 22.26           O  
ATOM   2038  OD2 ASP B  92      -6.549  -3.329  65.391  1.00 21.68           O  
ATOM   2039  N   ASP B  93      -6.957  -6.671  63.110  1.00 17.70           N  
ATOM   2040  CA  ASP B  93      -7.872  -7.658  63.699  1.00 18.37           C  
ATOM   2041  C   ASP B  93      -7.349  -9.098  63.582  1.00 17.86           C  
ATOM   2042  O   ASP B  93      -7.903 -10.017  64.179  1.00 17.78           O  
ATOM   2043  CB  ASP B  93      -9.257  -7.562  63.062  1.00 19.21           C  
ATOM   2044  CG  ASP B  93      -9.266  -8.033  61.631  1.00 21.22           C  
ATOM   2045  OD1 ASP B  93      -8.590  -7.406  60.795  1.00 24.52           O  
ATOM   2046  OD2 ASP B  93      -9.946  -9.040  61.329  1.00 25.30           O  
ATOM   2047  N   GLN B  94      -6.281  -9.280  62.811  1.00 16.95           N  
ATOM   2048  CA  GLN B  94      -5.702 -10.600  62.589  1.00 16.68           C  
ATOM   2049  C   GLN B  94      -4.459 -10.841  63.437  1.00 15.58           C  
ATOM   2050  O   GLN B  94      -3.774 -11.850  63.274  1.00 16.02           O  
ATOM   2051  CB  GLN B  94      -5.396 -10.785  61.098  1.00 16.80           C  
ATOM   2052  CG  GLN B  94      -6.657 -10.820  60.227  1.00 18.25           C  
ATOM   2053  CD  GLN B  94      -7.555 -12.012  60.553  1.00 21.11           C  
ATOM   2054  OE1 GLN B  94      -7.080 -13.144  60.716  1.00 22.37           O  
ATOM   2055  NE2 GLN B  94      -8.857 -11.762  60.651  1.00 21.23           N  
ATOM   2056  N   ARG B  95      -4.165  -9.907  64.336  1.00 14.98           N  
ATOM   2057  CA  ARG B  95      -3.010 -10.046  65.222  1.00 14.71           C  
ATOM   2058  C   ARG B  95      -3.254 -11.176  66.218  1.00 14.80           C  
ATOM   2059  O   ARG B  95      -4.403 -11.471  66.559  1.00 14.80           O  
ATOM   2060  CB  ARG B  95      -2.736  -8.737  65.972  1.00 14.61           C  
ATOM   2061  CG  ARG B  95      -2.146  -7.638  65.098  1.00 14.14           C  
ATOM   2062  CD  ARG B  95      -2.066  -6.318  65.855  1.00 15.41           C  
ATOM   2063  NE  ARG B  95      -1.192  -6.402  67.022  1.00 15.19           N  
ATOM   2064  CZ  ARG B  95       0.115  -6.152  66.997  1.00 18.64           C  
ATOM   2065  NH1 ARG B  95       0.709  -5.798  65.862  1.00 18.12           N  
ATOM   2066  NH2 ARG B  95       0.833  -6.252  68.108  1.00 18.13           N  
ATOM   2067  N   GLY B  96      -2.168 -11.805  66.665  1.00 15.10           N  
ATOM   2068  CA  GLY B  96      -2.242 -12.862  67.680  1.00 15.24           C  
ATOM   2069  C   GLY B  96      -2.639 -14.218  67.134  1.00 15.24           C  
ATOM   2070  O   GLY B  96      -3.120 -15.079  67.881  1.00 15.44           O  
ATOM   2071  N   LYS B  97      -2.434 -14.415  65.836  1.00 14.66           N  
ATOM   2072  CA  LYS B  97      -2.824 -15.663  65.174  1.00 14.59           C  
ATOM   2073  C   LYS B  97      -1.639 -16.344  64.481  1.00 14.22           C  
ATOM   2074  O   LYS B  97      -1.814 -17.349  63.791  1.00 15.05           O  
ATOM   2075  CB  LYS B  97      -3.913 -15.386  64.142  1.00 14.56           C  
ATOM   2076  CG  LYS B  97      -5.251 -14.964  64.708  1.00 16.44           C  
ATOM   2077  CD  LYS B  97      -6.178 -14.600  63.574  1.00 19.61           C  
ATOM   2078  CE  LYS B  97      -7.499 -14.064  64.074  1.00 22.89           C  
ATOM   2079  NZ  LYS B  97      -8.569 -14.195  63.041  1.00 24.76           N  
ATOM   2080  N   GLY B  98      -0.442 -15.791  64.650  1.00 13.49           N  
ATOM   2081  CA  GLY B  98       0.757 -16.357  64.030  1.00 13.04           C  
ATOM   2082  C   GLY B  98       0.895 -16.088  62.535  1.00 13.29           C  
ATOM   2083  O   GLY B  98       1.711 -16.725  61.876  1.00 12.82           O  
ATOM   2084  N   LEU B  99       0.126 -15.138  61.998  1.00 12.75           N  
ATOM   2085  CA  LEU B  99       0.185 -14.833  60.557  1.00 13.65           C  
ATOM   2086  C   LEU B  99       1.501 -14.166  60.156  1.00 13.08           C  
ATOM   2087  O   LEU B  99       2.041 -14.441  59.095  1.00 12.69           O  
ATOM   2088  CB  LEU B  99      -0.996 -13.963  60.099  1.00 14.02           C  
ATOM   2089  CG  LEU B  99      -2.388 -14.611  60.135  1.00 17.02           C  
ATOM   2090  CD1 LEU B  99      -3.443 -13.597  59.738  1.00 18.45           C  
ATOM   2091  CD2 LEU B  99      -2.465 -15.830  59.231  1.00 19.64           C  
ATOM   2092  N   GLY B 100       2.007 -13.285  61.016  1.00 13.56           N  
ATOM   2093  CA  GLY B 100       3.313 -12.655  60.799  1.00 13.43           C  
ATOM   2094  C   GLY B 100       4.415 -13.683  60.651  1.00 14.16           C  
ATOM   2095  O   GLY B 100       5.280 -13.548  59.773  1.00 13.65           O  
ATOM   2096  N   VAL B 101       4.389 -14.712  61.498  1.00 13.84           N  
ATOM   2097  CA  VAL B 101       5.346 -15.824  61.387  1.00 14.71           C  
ATOM   2098  C   VAL B 101       5.219 -16.574  60.054  1.00 14.33           C  
ATOM   2099  O   VAL B 101       6.230 -16.848  59.392  1.00 14.43           O  
ATOM   2100  CB  VAL B 101       5.222 -16.838  62.560  1.00 15.03           C  
ATOM   2101  CG1 VAL B 101       6.210 -17.971  62.375  1.00 15.85           C  
ATOM   2102  CG2 VAL B 101       5.480 -16.155  63.889  1.00 15.65           C  
ATOM   2103  N   GLN B 102       3.987 -16.903  59.668  1.00 14.17           N  
ATOM   2104  CA  GLN B 102       3.739 -17.606  58.404  1.00 14.48           C  
ATOM   2105  C   GLN B 102       4.277 -16.809  57.232  1.00 13.69           C  
ATOM   2106  O   GLN B 102       4.937 -17.359  56.338  1.00 13.25           O  
ATOM   2107  CB  GLN B 102       2.247 -17.830  58.190  1.00 14.55           C  
ATOM   2108  CG  GLN B 102       1.662 -18.954  59.005  1.00 18.60           C  
ATOM   2109  CD  GLN B 102       0.256 -19.289  58.553  1.00 23.61           C  
ATOM   2110  OE1 GLN B 102       0.011 -19.540  57.366  1.00 26.29           O  
ATOM   2111  NE2 GLN B 102      -0.681 -19.293  59.497  1.00 27.14           N  
ATOM   2112  N   LEU B 103       3.994 -15.509  57.245  1.00 12.64           N  
ATOM   2113  CA  LEU B 103       4.417 -14.625  56.156  1.00 12.15           C  
ATOM   2114  C   LEU B 103       5.931 -14.547  56.064  1.00 12.41           C  
ATOM   2115  O   LEU B 103       6.507 -14.673  54.978  1.00 11.80           O  
ATOM   2116  CB  LEU B 103       3.801 -13.227  56.315  1.00 11.57           C  
ATOM   2117  CG  LEU B 103       2.359 -13.108  55.790  1.00 11.24           C  
ATOM   2118  CD1 LEU B 103       1.632 -11.914  56.409  1.00 12.49           C  
ATOM   2119  CD2 LEU B 103       2.301 -13.026  54.263  1.00 10.79           C  
ATOM   2120  N   LEU B 104       6.575 -14.341  57.209  1.00 12.30           N  
ATOM   2121  CA  LEU B 104       8.019 -14.166  57.236  1.00 12.97           C  
ATOM   2122  C   LEU B 104       8.731 -15.473  56.938  1.00 12.95           C  
ATOM   2123  O   LEU B 104       9.736 -15.471  56.239  1.00 13.00           O  
ATOM   2124  CB  LEU B 104       8.479 -13.565  58.572  1.00 13.03           C  
ATOM   2125  CG  LEU B 104       9.958 -13.194  58.741  1.00 14.26           C  
ATOM   2126  CD1 LEU B 104      10.553 -12.389  57.554  1.00 15.12           C  
ATOM   2127  CD2 LEU B 104      10.117 -12.426  60.039  1.00 14.00           C  
ATOM   2128  N   GLN B 105       8.218 -16.591  57.450  1.00 13.33           N  
ATOM   2129  CA  GLN B 105       8.780 -17.891  57.076  1.00 14.39           C  
ATOM   2130  C   GLN B 105       8.778 -18.068  55.559  1.00 13.89           C  
ATOM   2131  O   GLN B 105       9.765 -18.512  54.974  1.00 14.43           O  
ATOM   2132  CB  GLN B 105       7.995 -19.032  57.703  1.00 15.35           C  
ATOM   2133  CG  GLN B 105       8.278 -19.229  59.163  1.00 18.24           C  
ATOM   2134  CD  GLN B 105       7.480 -20.368  59.729  1.00 23.05           C  
ATOM   2135  OE1 GLN B 105       6.341 -20.629  59.299  1.00 25.00           O  
ATOM   2136  NE2 GLN B 105       8.057 -21.057  60.712  1.00 23.39           N  
ATOM   2137  N   ALA B 106       7.665 -17.719  54.928  1.00 13.59           N  
ATOM   2138  CA  ALA B 106       7.527 -17.864  53.479  1.00 13.77           C  
ATOM   2139  C   ALA B 106       8.491 -16.958  52.719  1.00 13.50           C  
ATOM   2140  O   ALA B 106       9.080 -17.367  51.712  1.00 13.55           O  
ATOM   2141  CB  ALA B 106       6.090 -17.582  53.058  1.00 13.72           C  
ATOM   2142  N   LEU B 107       8.655 -15.731  53.214  1.00 12.77           N  
ATOM   2143  CA  LEU B 107       9.523 -14.745  52.598  1.00 13.19           C  
ATOM   2144  C   LEU B 107      10.994 -15.178  52.677  1.00 12.96           C  
ATOM   2145  O   LEU B 107      11.742 -15.051  51.700  1.00 12.08           O  
ATOM   2146  CB  LEU B 107       9.307 -13.391  53.292  1.00 13.34           C  
ATOM   2147  CG  LEU B 107       9.605 -12.113  52.517  1.00 14.10           C  
ATOM   2148  CD1 LEU B 107       8.719 -11.968  51.243  1.00 12.47           C  
ATOM   2149  CD2 LEU B 107       9.444 -10.931  53.466  1.00 13.20           C  
ATOM   2150  N   ILE B 108      11.389 -15.719  53.830  1.00 13.40           N  
ATOM   2151  CA  ILE B 108      12.744 -16.269  54.019  1.00 14.18           C  
ATOM   2152  C   ILE B 108      13.039 -17.379  52.985  1.00 14.79           C  
ATOM   2153  O   ILE B 108      14.126 -17.435  52.401  1.00 15.26           O  
ATOM   2154  CB  ILE B 108      12.932 -16.804  55.468  1.00 14.21           C  
ATOM   2155  CG1 ILE B 108      12.959 -15.641  56.478  1.00 14.60           C  
ATOM   2156  CG2 ILE B 108      14.226 -17.600  55.591  1.00 13.52           C  
ATOM   2157  CD1 ILE B 108      12.766 -16.073  57.922  1.00 14.36           C  
ATOM   2158  N   GLU B 109      12.064 -18.251  52.762  1.00 15.60           N  
ATOM   2159  CA  GLU B 109      12.228 -19.349  51.821  1.00 17.14           C  
ATOM   2160  C   GLU B 109      12.391 -18.825  50.396  1.00 16.90           C  
ATOM   2161  O   GLU B 109      13.220 -19.342  49.654  1.00 16.62           O  
ATOM   2162  CB  GLU B 109      11.106 -20.387  51.950  1.00 17.87           C  
ATOM   2163  CG  GLU B 109      10.920 -20.851  53.396  1.00 22.36           C  
ATOM   2164  CD  GLU B 109      10.494 -22.302  53.560  1.00 30.03           C  
ATOM   2165  OE1 GLU B 109       9.345 -22.536  54.023  1.00 32.40           O  
ATOM   2166  OE2 GLU B 109      11.316 -23.206  53.265  1.00 32.71           O  
ATOM   2167  N   ARG B 110      11.641 -17.775  50.042  1.00 16.87           N  
ATOM   2168  CA  ARG B 110      11.799 -17.103  48.746  1.00 17.11           C  
ATOM   2169  C   ARG B 110      13.181 -16.478  48.612  1.00 16.85           C  
ATOM   2170  O   ARG B 110      13.830 -16.622  47.580  1.00 17.21           O  
ATOM   2171  CB  ARG B 110      10.730 -16.012  48.550  1.00 17.47           C  
ATOM   2172  CG  ARG B 110       9.300 -16.508  48.489  1.00 18.95           C  
ATOM   2173  CD  ARG B 110       9.114 -17.525  47.363  1.00 20.24           C  
ATOM   2174  NE  ARG B 110       7.696 -17.813  47.196  1.00 22.63           N  
ATOM   2175  CZ  ARG B 110       6.899 -17.182  46.336  1.00 22.39           C  
ATOM   2176  NH1 ARG B 110       7.386 -16.235  45.538  1.00 22.00           N  
ATOM   2177  NH2 ARG B 110       5.615 -17.509  46.272  1.00 23.55           N  
ATOM   2178  N   ALA B 111      13.626 -15.780  49.657  1.00 16.64           N  
ATOM   2179  CA  ALA B 111      14.923 -15.106  49.642  1.00 17.13           C  
ATOM   2180  C   ALA B 111      16.047 -16.122  49.428  1.00 17.76           C  
ATOM   2181  O   ALA B 111      16.970 -15.882  48.654  1.00 17.07           O  
ATOM   2182  CB  ALA B 111      15.140 -14.297  50.931  1.00 16.54           C  
ATOM   2183  N   ARG B 112      15.951 -17.261  50.113  1.00 19.04           N  
ATOM   2184  CA  ARG B 112      16.903 -18.362  49.919  1.00 20.47           C  
ATOM   2185  C   ARG B 112      16.899 -18.897  48.498  1.00 20.94           C  
ATOM   2186  O   ARG B 112      17.964 -19.064  47.893  1.00 21.45           O  
ATOM   2187  CB  ARG B 112      16.638 -19.500  50.896  1.00 20.80           C  
ATOM   2188  CG  ARG B 112      17.187 -19.206  52.254  1.00 22.63           C  
ATOM   2189  CD  ARG B 112      17.728 -20.457  52.927  1.00 25.78           C  
ATOM   2190  NE  ARG B 112      18.164 -20.133  54.283  1.00 26.12           N  
ATOM   2191  CZ  ARG B 112      17.364 -20.156  55.338  1.00 26.81           C  
ATOM   2192  NH1 ARG B 112      16.097 -20.519  55.198  1.00 27.80           N  
ATOM   2193  NH2 ARG B 112      17.836 -19.831  56.534  1.00 27.77           N  
ATOM   2194  N   ALA B 113      15.706 -19.147  47.962  1.00 21.28           N  
ATOM   2195  CA  ALA B 113      15.568 -19.640  46.586  1.00 21.35           C  
ATOM   2196  C   ALA B 113      16.157 -18.666  45.560  1.00 21.48           C  
ATOM   2197  O   ALA B 113      16.578 -19.080  44.473  1.00 21.90           O  
ATOM   2198  CB  ALA B 113      14.106 -19.940  46.272  1.00 21.16           C  
ATOM   2199  N   GLN B 114      16.204 -17.380  45.915  1.00 21.15           N  
ATOM   2200  CA  GLN B 114      16.764 -16.341  45.039  1.00 20.75           C  
ATOM   2201  C   GLN B 114      18.273 -16.160  45.183  1.00 20.18           C  
ATOM   2202  O   GLN B 114      18.873 -15.338  44.487  1.00 19.97           O  
ATOM   2203  CB  GLN B 114      16.042 -15.005  45.244  1.00 21.31           C  
ATOM   2204  CG  GLN B 114      14.587 -15.023  44.807  1.00 22.05           C  
ATOM   2205  CD  GLN B 114      14.046 -13.637  44.508  1.00 24.75           C  
ATOM   2206  OE1 GLN B 114      14.042 -12.753  45.366  1.00 20.56           O  
ATOM   2207  NE2 GLN B 114      13.578 -13.446  43.278  1.00 26.39           N  
ATOM   2208  N   GLY B 115      18.885 -16.931  46.082  1.00 19.57           N  
ATOM   2209  CA  GLY B 115      20.321 -16.840  46.323  1.00 18.66           C  
ATOM   2210  C   GLY B 115      20.769 -15.575  47.040  1.00 18.08           C  
ATOM   2211  O   GLY B 115      21.924 -15.180  46.929  1.00 18.13           O  
ATOM   2212  N   LEU B 116      19.864 -14.941  47.788  1.00 17.30           N  
ATOM   2213  CA  LEU B 116      20.213 -13.777  48.603  1.00 16.01           C  
ATOM   2214  C   LEU B 116      21.035 -14.184  49.833  1.00 15.45           C  
ATOM   2215  O   LEU B 116      21.023 -15.356  50.242  1.00 15.39           O  
ATOM   2216  CB  LEU B 116      18.944 -12.993  48.978  1.00 16.15           C  
ATOM   2217  CG  LEU B 116      18.155 -12.503  47.758  1.00 17.39           C  
ATOM   2218  CD1 LEU B 116      16.807 -11.889  48.166  1.00 17.53           C  
ATOM   2219  CD2 LEU B 116      18.969 -11.509  46.940  1.00 18.07           C  
ATOM   2220  N   HIS B 117      21.775 -13.230  50.399  1.00 14.16           N  
ATOM   2221  CA  HIS B 117      22.697 -13.504  51.497  1.00 13.70           C  
ATOM   2222  C   HIS B 117      22.205 -13.061  52.882  1.00 13.29           C  
ATOM   2223  O   HIS B 117      22.441 -13.756  53.882  1.00 12.70           O  
ATOM   2224  CB  HIS B 117      24.076 -12.879  51.205  1.00 13.66           C  
ATOM   2225  CG  HIS B 117      25.158 -13.320  52.140  1.00 14.69           C  
ATOM   2226  ND1 HIS B 117      25.991 -12.433  52.789  1.00 17.39           N  
ATOM   2227  CD2 HIS B 117      25.566 -14.557  52.510  1.00 14.64           C  
ATOM   2228  CE1 HIS B 117      26.845 -13.104  53.541  1.00 15.47           C  
ATOM   2229  NE2 HIS B 117      26.610 -14.393  53.388  1.00 18.65           N  
ATOM   2230  N   VAL B 118      21.563 -11.891  52.958  1.00 11.95           N  
ATOM   2231  CA  VAL B 118      21.187 -11.317  54.255  1.00 11.18           C  
ATOM   2232  C   VAL B 118      19.818 -10.639  54.138  1.00 11.05           C  
ATOM   2233  O   VAL B 118      19.553  -9.945  53.144  1.00 10.09           O  
ATOM   2234  CB  VAL B 118      22.256 -10.280  54.761  1.00 11.07           C  
ATOM   2235  CG1 VAL B 118      21.809  -9.606  56.072  1.00 10.72           C  
ATOM   2236  CG2 VAL B 118      23.639 -10.929  54.939  1.00 12.25           C  
HETATM 2237  N   MSE B 119      18.943 -10.864  55.118  1.00 10.72           N  
HETATM 2238  CA  MSE B 119      17.682 -10.104  55.210  1.00 11.05           C  
HETATM 2239  C   MSE B 119      17.800  -9.160  56.395  1.00 11.03           C  
HETATM 2240  O   MSE B 119      18.187  -9.588  57.480  1.00 10.30           O  
HETATM 2241  CB  MSE B 119      16.456 -11.037  55.384  1.00 10.82           C  
HETATM 2242  CG  MSE B 119      15.046 -10.394  55.140  1.00 11.62           C  
HETATM 2243 SE   MSE B 119      13.667 -11.626  55.006  1.00 14.58          SE  
HETATM 2244  CE  MSE B 119      14.697 -13.096  54.652  1.00  2.00           C  
ATOM   2245  N   VAL B 120      17.464  -7.888  56.182  1.00 11.12           N  
ATOM   2246  CA  VAL B 120      17.504  -6.872  57.224  1.00 11.48           C  
ATOM   2247  C   VAL B 120      16.072  -6.446  57.589  1.00 11.93           C  
ATOM   2248  O   VAL B 120      15.249  -6.216  56.706  1.00 12.16           O  
ATOM   2249  CB  VAL B 120      18.329  -5.627  56.776  1.00 11.60           C  
ATOM   2250  CG1 VAL B 120      18.276  -4.518  57.850  1.00 11.51           C  
ATOM   2251  CG2 VAL B 120      19.770  -6.008  56.488  1.00 12.56           C  
ATOM   2252  N   ALA B 121      15.787  -6.387  58.889  1.00 12.12           N  
ATOM   2253  CA  ALA B 121      14.547  -5.793  59.438  1.00 12.30           C  
ATOM   2254  C   ALA B 121      14.856  -4.467  60.124  1.00 12.59           C  
ATOM   2255  O   ALA B 121      15.847  -4.364  60.857  1.00 12.70           O  
ATOM   2256  CB  ALA B 121      13.928  -6.743  60.446  1.00 12.75           C  
ATOM   2257  N   ALA B 122      14.016  -3.460  59.882  1.00 12.05           N  
ATOM   2258  CA  ALA B 122      14.082  -2.183  60.599  1.00 11.38           C  
ATOM   2259  C   ALA B 122      12.806  -2.049  61.399  1.00 11.29           C  
ATOM   2260  O   ALA B 122      11.708  -1.985  60.833  1.00 10.91           O  
ATOM   2261  CB  ALA B 122      14.236  -1.020  59.632  1.00 11.89           C  
ATOM   2262  N   ILE B 123      12.943  -2.058  62.718  1.00 10.61           N  
ATOM   2263  CA  ILE B 123      11.793  -2.176  63.608  1.00 11.26           C  
ATOM   2264  C   ILE B 123      11.879  -1.030  64.604  1.00 11.55           C  
ATOM   2265  O   ILE B 123      12.945  -0.771  65.143  1.00 10.45           O  
ATOM   2266  CB  ILE B 123      11.848  -3.538  64.378  1.00 11.18           C  
ATOM   2267  CG1 ILE B 123      11.814  -4.711  63.391  1.00 11.60           C  
ATOM   2268  CG2 ILE B 123      10.692  -3.665  65.379  1.00 11.25           C  
ATOM   2269  CD1 ILE B 123      12.423  -6.022  63.962  1.00 12.79           C  
ATOM   2270  N   GLU B 124      10.762  -0.350  64.852  1.00 11.66           N  
ATOM   2271  CA  GLU B 124      10.732   0.656  65.894  1.00 12.04           C  
ATOM   2272  C   GLU B 124      11.077  -0.059  67.214  1.00 12.11           C  
ATOM   2273  O   GLU B 124      10.537  -1.115  67.494  1.00 11.35           O  
ATOM   2274  CB  GLU B 124       9.363   1.310  65.943  1.00 13.37           C  
ATOM   2275  CG  GLU B 124       9.317   2.504  66.867  1.00 15.07           C  
ATOM   2276  CD  GLU B 124       8.661   2.177  68.160  1.00 18.54           C  
ATOM   2277  OE1 GLU B 124       7.560   1.593  68.117  1.00 21.13           O  
ATOM   2278  OE2 GLU B 124       9.222   2.519  69.219  1.00 17.04           O  
ATOM   2279  N   SER B 125      11.993   0.510  67.990  1.00 10.98           N  
ATOM   2280  CA  SER B 125      12.608  -0.206  69.115  1.00 12.13           C  
ATOM   2281  C   SER B 125      11.630  -0.611  70.217  1.00 11.98           C  
ATOM   2282  O   SER B 125      11.880  -1.576  70.929  1.00 12.42           O  
ATOM   2283  CB  SER B 125      13.742   0.619  69.728  1.00 11.15           C  
ATOM   2284  OG  SER B 125      14.673   0.978  68.726  1.00 12.94           O  
ATOM   2285  N   GLY B 126      10.534   0.131  70.364  1.00 12.59           N  
ATOM   2286  CA  GLY B 126       9.503  -0.216  71.361  1.00 12.46           C  
ATOM   2287  C   GLY B 126       8.584  -1.371  70.957  1.00 12.95           C  
ATOM   2288  O   GLY B 126       7.783  -1.856  71.767  1.00 12.46           O  
ATOM   2289  N   ASN B 127       8.690  -1.818  69.709  1.00 12.39           N  
ATOM   2290  CA  ASN B 127       7.798  -2.852  69.208  1.00 12.48           C  
ATOM   2291  C   ASN B 127       8.333  -4.232  69.586  1.00 12.21           C  
ATOM   2292  O   ASN B 127       8.911  -4.946  68.749  1.00 11.99           O  
ATOM   2293  CB  ASN B 127       7.598  -2.690  67.702  1.00 12.56           C  
ATOM   2294  CG  ASN B 127       6.527  -3.624  67.130  1.00 14.58           C  
ATOM   2295  OD1 ASN B 127       6.104  -4.602  67.766  1.00 13.76           O  
ATOM   2296  ND2 ASN B 127       6.105  -3.335  65.903  1.00 15.36           N  
ATOM   2297  N   ALA B 128       8.128  -4.602  70.852  1.00 12.15           N  
ATOM   2298  CA  ALA B 128       8.639  -5.864  71.386  1.00 12.10           C  
ATOM   2299  C   ALA B 128       8.029  -7.066  70.671  1.00 12.17           C  
ATOM   2300  O   ALA B 128       8.707  -8.089  70.486  1.00 12.38           O  
ATOM   2301  CB  ALA B 128       8.399  -5.957  72.882  1.00 12.33           C  
ATOM   2302  N   ALA B 129       6.771  -6.938  70.240  1.00 11.50           N  
ATOM   2303  CA  ALA B 129       6.128  -8.025  69.518  1.00 11.45           C  
ATOM   2304  C   ALA B 129       6.915  -8.366  68.247  1.00 10.92           C  
ATOM   2305  O   ALA B 129       7.189  -9.549  67.970  1.00 10.75           O  
ATOM   2306  CB  ALA B 129       4.696  -7.678  69.178  1.00 11.51           C  
ATOM   2307  N   SER B 130       7.272  -7.335  67.478  1.00 10.56           N  
ATOM   2308  CA  SER B 130       8.002  -7.524  66.223  1.00 11.41           C  
ATOM   2309  C   SER B 130       9.423  -8.020  66.445  1.00 10.96           C  
ATOM   2310  O   SER B 130       9.892  -8.933  65.760  1.00 11.00           O  
ATOM   2311  CB  SER B 130       8.005  -6.256  65.377  1.00 11.26           C  
ATOM   2312  OG  SER B 130       8.692  -6.511  64.166  1.00 14.47           O  
ATOM   2313  N   ILE B 131      10.118  -7.406  67.386  1.00 11.66           N  
ATOM   2314  CA  ILE B 131      11.462  -7.898  67.773  1.00 13.16           C  
ATOM   2315  C   ILE B 131      11.457  -9.389  68.142  1.00 11.34           C  
ATOM   2316  O   ILE B 131      12.340 -10.146  67.712  1.00 10.95           O  
ATOM   2317  CB  ILE B 131      12.090  -7.041  68.910  1.00 12.36           C  
ATOM   2318  CG1 ILE B 131      12.290  -5.605  68.398  1.00 14.02           C  
ATOM   2319  CG2 ILE B 131      13.428  -7.655  69.372  1.00 13.24           C  
ATOM   2320  CD1 ILE B 131      12.855  -4.638  69.402  1.00 14.71           C  
ATOM   2321  N   GLY B 132      10.464  -9.816  68.921  1.00 11.61           N  
ATOM   2322  CA  GLY B 132      10.397 -11.215  69.379  1.00 11.18           C  
ATOM   2323  C   GLY B 132      10.081 -12.185  68.253  1.00 11.36           C  
ATOM   2324  O   GLY B 132      10.622 -13.299  68.191  1.00 10.86           O  
ATOM   2325  N   LEU B 133       9.211 -11.748  67.356  1.00 11.00           N  
ATOM   2326  CA  LEU B 133       8.856 -12.527  66.172  1.00 12.10           C  
ATOM   2327  C   LEU B 133      10.108 -12.816  65.331  1.00 10.94           C  
ATOM   2328  O   LEU B 133      10.347 -13.955  64.905  1.00 10.44           O  
ATOM   2329  CB  LEU B 133       7.820 -11.742  65.362  1.00 12.86           C  
ATOM   2330  CG  LEU B 133       7.195 -12.330  64.096  1.00 17.00           C  
ATOM   2331  CD1 LEU B 133       5.896 -11.587  63.819  1.00 20.93           C  
ATOM   2332  CD2 LEU B 133       8.121 -12.198  62.934  1.00 20.14           C  
ATOM   2333  N   HIS B 134      10.913 -11.777  65.127  1.00 10.27           N  
ATOM   2334  CA  HIS B 134      12.132 -11.881  64.339  1.00 10.27           C  
ATOM   2335  C   HIS B 134      13.188 -12.728  65.053  1.00 10.00           C  
ATOM   2336  O   HIS B 134      13.798 -13.606  64.438  1.00  9.39           O  
ATOM   2337  CB  HIS B 134      12.651 -10.482  63.995  1.00 10.32           C  
ATOM   2338  CG  HIS B 134      11.864  -9.820  62.909  1.00 11.27           C  
ATOM   2339  ND1 HIS B 134      10.656  -9.200  63.141  1.00 11.89           N  
ATOM   2340  CD2 HIS B 134      12.096  -9.713  61.581  1.00 13.12           C  
ATOM   2341  CE1 HIS B 134      10.176  -8.732  62.001  1.00 15.23           C  
ATOM   2342  NE2 HIS B 134      11.030  -9.032  61.037  1.00 14.67           N  
ATOM   2343  N   ARG B 135      13.391 -12.471  66.345  1.00  9.40           N  
ATOM   2344  CA  ARG B 135      14.336 -13.268  67.146  1.00 10.22           C  
ATOM   2345  C   ARG B 135      14.053 -14.759  67.011  1.00  9.83           C  
ATOM   2346  O   ARG B 135      14.976 -15.562  66.794  1.00  9.39           O  
ATOM   2347  CB  ARG B 135      14.306 -12.877  68.622  1.00 10.16           C  
ATOM   2348  CG  ARG B 135      15.115 -13.823  69.502  1.00 11.24           C  
ATOM   2349  CD  ARG B 135      15.177 -13.384  70.959  1.00 12.23           C  
ATOM   2350  NE  ARG B 135      13.866 -13.444  71.603  1.00 17.11           N  
ATOM   2351  CZ  ARG B 135      13.128 -12.379  71.906  1.00 18.35           C  
ATOM   2352  NH1 ARG B 135      13.567 -11.144  71.646  1.00 18.04           N  
ATOM   2353  NH2 ARG B 135      11.950 -12.555  72.484  1.00 18.66           N  
ATOM   2354  N   ARG B 136      12.779 -15.124  67.128  1.00  9.71           N  
ATOM   2355  CA  ARG B 136      12.375 -16.538  67.089  1.00 10.60           C  
ATOM   2356  C   ARG B 136      12.544 -17.186  65.714  1.00 11.22           C  
ATOM   2357  O   ARG B 136      12.506 -18.423  65.598  1.00 11.86           O  
ATOM   2358  CB  ARG B 136      10.953 -16.721  67.652  1.00  9.95           C  
ATOM   2359  CG  ARG B 136      10.906 -16.447  69.158  1.00 10.27           C  
ATOM   2360  CD  ARG B 136       9.557 -16.772  69.774  1.00  9.41           C  
ATOM   2361  NE  ARG B 136       8.485 -15.934  69.251  1.00 12.56           N  
ATOM   2362  CZ  ARG B 136       8.110 -14.763  69.764  1.00 13.39           C  
ATOM   2363  NH1 ARG B 136       8.719 -14.272  70.837  1.00 12.69           N  
ATOM   2364  NH2 ARG B 136       7.120 -14.081  69.190  1.00 14.31           N  
ATOM   2365  N   LEU B 137      12.738 -16.365  64.682  1.00 11.14           N  
ATOM   2366  CA  LEU B 137      13.051 -16.874  63.341  1.00 11.61           C  
ATOM   2367  C   LEU B 137      14.543 -16.733  62.958  1.00 12.04           C  
ATOM   2368  O   LEU B 137      14.911 -16.874  61.785  1.00 12.38           O  
ATOM   2369  CB  LEU B 137      12.139 -16.229  62.287  1.00 11.81           C  
ATOM   2370  CG  LEU B 137      10.684 -16.718  62.243  1.00 13.81           C  
ATOM   2371  CD1 LEU B 137       9.893 -16.032  61.147  1.00 16.21           C  
ATOM   2372  CD2 LEU B 137      10.568 -18.257  62.109  1.00 16.70           C  
ATOM   2373  N   GLY B 138      15.390 -16.461  63.950  1.00 11.79           N  
ATOM   2374  CA  GLY B 138      16.840 -16.472  63.748  1.00 11.19           C  
ATOM   2375  C   GLY B 138      17.486 -15.117  63.519  1.00 11.09           C  
ATOM   2376  O   GLY B 138      18.694 -15.050  63.279  1.00 10.33           O  
ATOM   2377  N   PHE B 139      16.699 -14.033  63.565  1.00 10.00           N  
ATOM   2378  CA  PHE B 139      17.266 -12.689  63.412  1.00 10.34           C  
ATOM   2379  C   PHE B 139      18.003 -12.265  64.670  1.00 10.63           C  
ATOM   2380  O   PHE B 139      17.588 -12.604  65.778  1.00 10.21           O  
ATOM   2381  CB  PHE B 139      16.181 -11.654  63.121  1.00  9.76           C  
ATOM   2382  CG  PHE B 139      15.664 -11.689  61.720  1.00 10.20           C  
ATOM   2383  CD1 PHE B 139      16.089 -10.734  60.795  1.00  9.63           C  
ATOM   2384  CD2 PHE B 139      14.728 -12.652  61.325  1.00 11.99           C  
ATOM   2385  CE1 PHE B 139      15.613 -10.755  59.481  1.00  9.20           C  
ATOM   2386  CE2 PHE B 139      14.237 -12.679  60.002  1.00 12.20           C  
ATOM   2387  CZ  PHE B 139      14.698 -11.721  59.080  1.00 11.01           C  
ATOM   2388  N   GLU B 140      19.096 -11.523  64.486  1.00 11.39           N  
ATOM   2389  CA  GLU B 140      19.877 -10.985  65.589  1.00 12.70           C  
ATOM   2390  C   GLU B 140      19.903  -9.442  65.563  1.00 11.55           C  
ATOM   2391  O   GLU B 140      19.936  -8.850  64.497  1.00 10.84           O  
ATOM   2392  CB  GLU B 140      21.313 -11.506  65.511  1.00 13.07           C  
ATOM   2393  CG  GLU B 140      21.466 -12.993  65.790  1.00 17.25           C  
ATOM   2394  CD  GLU B 140      22.917 -13.437  65.775  1.00 17.90           C  
ATOM   2395  OE1 GLU B 140      23.705 -12.939  66.601  1.00 25.38           O  
ATOM   2396  OE2 GLU B 140      23.266 -14.307  64.948  1.00 26.82           O  
ATOM   2397  N   ILE B 141      19.902  -8.805  66.740  1.00 10.80           N  
ATOM   2398  CA  ILE B 141      19.979  -7.357  66.814  1.00 10.98           C  
ATOM   2399  C   ILE B 141      21.365  -6.928  66.335  1.00 10.92           C  
ATOM   2400  O   ILE B 141      22.377  -7.474  66.780  1.00 10.48           O  
ATOM   2401  CB  ILE B 141      19.689  -6.820  68.231  1.00 10.96           C  
ATOM   2402  CG1 ILE B 141      18.250  -7.167  68.629  1.00 11.74           C  
ATOM   2403  CG2 ILE B 141      19.926  -5.281  68.302  1.00  9.64           C  
ATOM   2404  CD1 ILE B 141      17.897  -6.806  70.054  1.00 15.54           C  
ATOM   2405  N   SER B 142      21.384  -5.980  65.403  1.00 11.39           N  
ATOM   2406  CA  SER B 142      22.628  -5.478  64.813  1.00 12.70           C  
ATOM   2407  C   SER B 142      22.811  -3.999  65.073  1.00 12.65           C  
ATOM   2408  O   SER B 142      23.917  -3.491  64.972  1.00 12.63           O  
ATOM   2409  CB  SER B 142      22.640  -5.726  63.298  1.00 13.06           C  
ATOM   2410  OG  SER B 142      22.659  -7.110  63.046  1.00 18.41           O  
ATOM   2411  N   GLY B 143      21.727  -3.301  65.395  1.00 12.38           N  
ATOM   2412  CA  GLY B 143      21.822  -1.863  65.555  1.00 13.70           C  
ATOM   2413  C   GLY B 143      20.696  -1.313  66.382  1.00 14.16           C  
ATOM   2414  O   GLY B 143      19.595  -1.844  66.368  1.00 13.39           O  
ATOM   2415  N   GLN B 144      20.998  -0.246  67.114  1.00 15.05           N  
ATOM   2416  CA  GLN B 144      19.994   0.464  67.880  1.00 16.28           C  
ATOM   2417  C   GLN B 144      20.341   1.941  67.758  1.00 15.36           C  
ATOM   2418  O   GLN B 144      21.398   2.390  68.208  1.00 15.24           O  
ATOM   2419  CB  GLN B 144      19.927  -0.041  69.327  1.00 17.47           C  
ATOM   2420  CG  GLN B 144      18.787  -1.070  69.507  1.00 22.37           C  
ATOM   2421  CD  GLN B 144      18.707  -1.636  70.899  1.00 27.58           C  
ATOM   2422  OE1 GLN B 144      18.992  -0.948  71.883  1.00 31.63           O  
ATOM   2423  NE2 GLN B 144      18.297  -2.897  70.999  1.00 28.89           N  
HETATM 2424  N   MSE B 145      19.450   2.661  67.089  1.00 14.31           N  
HETATM 2425  CA  MSE B 145      19.731   3.995  66.593  1.00 13.98           C  
HETATM 2426  C   MSE B 145      18.697   4.976  67.161  1.00 13.31           C  
HETATM 2427  O   MSE B 145      17.563   5.014  66.696  1.00 13.51           O  
HETATM 2428  CB  MSE B 145      19.745   3.972  65.051  1.00 13.48           C  
HETATM 2429  CG  MSE B 145      20.677   2.869  64.485  1.00 14.89           C  
HETATM 2430 SE   MSE B 145      20.957   2.935  62.707  1.00 14.78          SE  
HETATM 2431  CE  MSE B 145      21.981   4.420  62.628  1.00 17.18           C  
ATOM   2432  N   PRO B 146      19.086   5.742  68.204  1.00 12.83           N  
ATOM   2433  CA  PRO B 146      18.172   6.674  68.897  1.00 12.31           C  
ATOM   2434  C   PRO B 146      17.804   7.917  68.103  1.00 11.48           C  
ATOM   2435  O   PRO B 146      18.675   8.544  67.489  1.00 10.91           O  
ATOM   2436  CB  PRO B 146      18.963   7.089  70.146  1.00 12.05           C  
ATOM   2437  CG  PRO B 146      20.421   6.891  69.744  1.00 13.53           C  
ATOM   2438  CD  PRO B 146      20.412   5.687  68.845  1.00 12.74           C  
ATOM   2439  N   GLN B 147      16.517   8.253  68.141  1.00 11.26           N  
ATOM   2440  CA  GLN B 147      15.978   9.527  67.659  1.00 11.69           C  
ATOM   2441  C   GLN B 147      16.213   9.794  66.165  1.00 11.62           C  
ATOM   2442  O   GLN B 147      16.263  10.951  65.728  1.00 11.76           O  
ATOM   2443  CB  GLN B 147      16.467  10.688  68.539  1.00 11.65           C  
ATOM   2444  CG  GLN B 147      16.134  10.511  70.027  1.00 12.26           C  
ATOM   2445  CD  GLN B 147      16.370  11.767  70.843  1.00 13.96           C  
ATOM   2446  OE1 GLN B 147      16.974  12.727  70.369  1.00 15.05           O  
ATOM   2447  NE2 GLN B 147      15.885  11.765  72.085  1.00 16.60           N  
ATOM   2448  N   VAL B 148      16.320   8.718  65.386  1.00 11.34           N  
ATOM   2449  CA  VAL B 148      16.494   8.829  63.942  1.00 11.29           C  
ATOM   2450  C   VAL B 148      15.174   9.061  63.218  1.00 12.06           C  
ATOM   2451  O   VAL B 148      15.167   9.449  62.048  1.00 12.31           O  
ATOM   2452  CB  VAL B 148      17.249   7.613  63.343  1.00 11.15           C  
ATOM   2453  CG1 VAL B 148      18.686   7.612  63.834  1.00 10.65           C  
ATOM   2454  CG2 VAL B 148      16.556   6.301  63.691  1.00 10.70           C  
ATOM   2455  N   GLY B 149      14.062   8.827  63.921  1.00 12.20           N  
ATOM   2456  CA  GLY B 149      12.735   9.015  63.344  1.00 12.90           C  
ATOM   2457  C   GLY B 149      11.865   9.891  64.205  1.00 12.72           C  
ATOM   2458  O   GLY B 149      12.214  10.202  65.345  1.00 11.46           O  
ATOM   2459  N   GLN B 150      10.732  10.301  63.635  1.00 13.66           N  
ATOM   2460  CA  GLN B 150       9.728  11.054  64.353  1.00 14.64           C  
ATOM   2461  C   GLN B 150       8.365  10.638  63.836  1.00 14.71           C  
ATOM   2462  O   GLN B 150       8.189  10.410  62.626  1.00 14.40           O  
ATOM   2463  CB  GLN B 150       9.909  12.568  64.163  1.00 14.70           C  
ATOM   2464  CG  GLN B 150      10.020  13.031  62.700  1.00 15.74           C  
ATOM   2465  CD  GLN B 150      10.403  14.480  62.573  1.00 16.80           C  
ATOM   2466  OE1 GLN B 150       9.563  15.357  62.709  1.00 18.99           O  
ATOM   2467  NE2 GLN B 150      11.682  14.742  62.313  1.00 17.87           N  
ATOM   2468  N   LYS B 151       7.415  10.529  64.756  1.00 14.50           N  
ATOM   2469  CA  LYS B 151       6.008  10.387  64.382  1.00 15.27           C  
ATOM   2470  C   LYS B 151       5.167  10.712  65.598  1.00 16.17           C  
ATOM   2471  O   LYS B 151       5.616  10.536  66.739  1.00 16.44           O  
ATOM   2472  CB  LYS B 151       5.694   8.980  63.851  1.00 14.49           C  
ATOM   2473  CG  LYS B 151       4.370   8.866  63.091  1.00 14.30           C  
ATOM   2474  CD  LYS B 151       4.229   7.493  62.421  1.00 14.44           C  
ATOM   2475  CE  LYS B 151       2.833   7.317  61.842  1.00 13.40           C  
ATOM   2476  NZ  LYS B 151       2.629   6.004  61.158  1.00 10.76           N  
ATOM   2477  N   PHE B 152       3.958  11.213  65.349  1.00 17.83           N  
ATOM   2478  CA  PHE B 152       3.048  11.611  66.425  1.00 18.85           C  
ATOM   2479  C   PHE B 152       3.711  12.631  67.356  1.00 19.38           C  
ATOM   2480  O   PHE B 152       3.509  12.599  68.576  1.00 19.56           O  
ATOM   2481  CB  PHE B 152       2.581  10.387  67.222  1.00 19.63           C  
ATOM   2482  CG  PHE B 152       2.079   9.241  66.359  1.00 20.99           C  
ATOM   2483  CD1 PHE B 152       2.723   8.007  66.379  1.00 21.48           C  
ATOM   2484  CD2 PHE B 152       0.970   9.405  65.530  1.00 22.23           C  
ATOM   2485  CE1 PHE B 152       2.260   6.941  65.588  1.00 22.97           C  
ATOM   2486  CE2 PHE B 152       0.502   8.347  64.734  1.00 22.74           C  
ATOM   2487  CZ  PHE B 152       1.150   7.116  64.770  1.00 21.53           C  
ATOM   2488  N   GLY B 153       4.512  13.527  66.778  1.00 19.26           N  
ATOM   2489  CA  GLY B 153       5.181  14.574  67.552  1.00 19.23           C  
ATOM   2490  C   GLY B 153       6.263  14.112  68.516  1.00 19.06           C  
ATOM   2491  O   GLY B 153       6.669  14.869  69.390  1.00 19.01           O  
ATOM   2492  N   ARG B 154       6.743  12.880  68.365  1.00 18.77           N  
ATOM   2493  CA  ARG B 154       7.793  12.364  69.251  1.00 18.77           C  
ATOM   2494  C   ARG B 154       8.957  11.710  68.484  1.00 17.30           C  
ATOM   2495  O   ARG B 154       8.779  11.251  67.360  1.00 16.33           O  
ATOM   2496  CB  ARG B 154       7.198  11.422  70.316  1.00 19.11           C  
ATOM   2497  CG  ARG B 154       6.880   9.990  69.858  1.00 20.95           C  
ATOM   2498  CD  ARG B 154       6.255   9.160  70.992  1.00 21.40           C  
ATOM   2499  NE  ARG B 154       6.070   7.755  70.618  1.00 27.25           N  
ATOM   2500  CZ  ARG B 154       4.939   7.231  70.142  1.00 29.26           C  
ATOM   2501  NH1 ARG B 154       3.852   7.985  69.970  1.00 31.06           N  
ATOM   2502  NH2 ARG B 154       4.892   5.938  69.832  1.00 31.08           N  
ATOM   2503  N   TRP B 155      10.145  11.694  69.096  1.00 16.34           N  
ATOM   2504  CA  TRP B 155      11.307  11.009  68.518  1.00 14.90           C  
ATOM   2505  C   TRP B 155      11.100   9.499  68.612  1.00 14.61           C  
ATOM   2506  O   TRP B 155      10.489   9.015  69.559  1.00 15.18           O  
ATOM   2507  CB  TRP B 155      12.605  11.408  69.241  1.00 14.88           C  
ATOM   2508  CG  TRP B 155      13.011  12.872  69.110  1.00 14.36           C  
ATOM   2509  CD1 TRP B 155      13.232  13.754  70.133  1.00 15.01           C  
ATOM   2510  CD2 TRP B 155      13.239  13.607  67.895  1.00 13.86           C  
ATOM   2511  NE1 TRP B 155      13.592  14.988  69.633  1.00 14.96           N  
ATOM   2512  CE2 TRP B 155      13.599  14.929  68.265  1.00 15.37           C  
ATOM   2513  CE3 TRP B 155      13.182  13.277  66.534  1.00 13.96           C  
ATOM   2514  CZ2 TRP B 155      13.894  15.926  67.318  1.00 14.99           C  
ATOM   2515  CZ3 TRP B 155      13.471  14.265  65.590  1.00 14.62           C  
ATOM   2516  CH2 TRP B 155      13.821  15.576  65.989  1.00 15.78           C  
ATOM   2517  N   LEU B 156      11.583   8.768  67.616  1.00 13.97           N  
ATOM   2518  CA  LEU B 156      11.481   7.305  67.580  1.00 13.33           C  
ATOM   2519  C   LEU B 156      12.859   6.710  67.380  1.00 13.10           C  
ATOM   2520  O   LEU B 156      13.687   7.283  66.652  1.00 12.51           O  
ATOM   2521  CB  LEU B 156      10.572   6.849  66.439  1.00 13.02           C  
ATOM   2522  CG  LEU B 156       9.087   7.242  66.455  1.00 15.71           C  
ATOM   2523  CD1 LEU B 156       8.398   6.744  65.176  1.00 17.63           C  
ATOM   2524  CD2 LEU B 156       8.389   6.698  67.703  1.00 17.12           C  
ATOM   2525  N   ASP B 157      13.103   5.561  68.017  1.00 12.44           N  
ATOM   2526  CA  ASP B 157      14.369   4.855  67.853  1.00 12.99           C  
ATOM   2527  C   ASP B 157      14.154   3.664  66.929  1.00 12.29           C  
ATOM   2528  O   ASP B 157      13.067   3.069  66.899  1.00 11.16           O  
ATOM   2529  CB  ASP B 157      14.941   4.367  69.192  1.00 13.23           C  
ATOM   2530  CG  ASP B 157      15.010   5.460  70.251  1.00 16.58           C  
ATOM   2531  OD1 ASP B 157      15.020   6.678  69.919  1.00 16.08           O  
ATOM   2532  OD2 ASP B 157      15.073   5.081  71.441  1.00 19.99           O  
ATOM   2533  N   LEU B 158      15.201   3.308  66.195  1.00 11.94           N  
ATOM   2534  CA  LEU B 158      15.131   2.225  65.235  1.00 12.20           C  
ATOM   2535  C   LEU B 158      16.073   1.093  65.627  1.00 12.46           C  
ATOM   2536  O   LEU B 158      17.223   1.324  66.012  1.00 13.02           O  
ATOM   2537  CB  LEU B 158      15.458   2.731  63.821  1.00 12.20           C  
ATOM   2538  CG  LEU B 158      15.150   1.807  62.635  1.00 12.48           C  
ATOM   2539  CD1 LEU B 158      13.658   1.424  62.585  1.00 14.27           C  
ATOM   2540  CD2 LEU B 158      15.551   2.451  61.300  1.00 12.67           C  
ATOM   2541  N   THR B 159      15.572  -0.127  65.540  1.00 12.38           N  
ATOM   2542  CA  THR B 159      16.400  -1.300  65.802  1.00 12.26           C  
ATOM   2543  C   THR B 159      16.582  -2.005  64.483  1.00 12.22           C  
ATOM   2544  O   THR B 159      15.605  -2.240  63.781  1.00 12.27           O  
ATOM   2545  CB  THR B 159      15.720  -2.210  66.819  1.00 12.52           C  
ATOM   2546  OG1 THR B 159      15.653  -1.523  68.071  1.00 12.88           O  
ATOM   2547  CG2 THR B 159      16.475  -3.546  66.988  1.00 12.94           C  
ATOM   2548  N   PHE B 160      17.833  -2.303  64.125  1.00 11.89           N  
ATOM   2549  CA  PHE B 160      18.102  -3.159  62.973  1.00 11.91           C  
ATOM   2550  C   PHE B 160      18.330  -4.595  63.454  1.00 11.37           C  
ATOM   2551  O   PHE B 160      19.056  -4.818  64.426  1.00 10.60           O  
ATOM   2552  CB  PHE B 160      19.346  -2.695  62.210  1.00 12.84           C  
ATOM   2553  CG  PHE B 160      19.089  -1.583  61.224  1.00 13.92           C  
ATOM   2554  CD1 PHE B 160      18.171  -1.738  60.200  1.00 17.57           C  
ATOM   2555  CD2 PHE B 160      19.806  -0.394  61.304  1.00 18.04           C  
ATOM   2556  CE1 PHE B 160      17.944  -0.714  59.277  1.00 18.60           C  
ATOM   2557  CE2 PHE B 160      19.590   0.646  60.379  1.00 20.05           C  
ATOM   2558  CZ  PHE B 160      18.653   0.475  59.364  1.00 17.65           C  
HETATM 2559  N   MSE B 161      17.722  -5.559  62.770  1.00 10.23           N  
HETATM 2560  CA  MSE B 161      18.028  -6.960  63.020  1.00  9.06           C  
HETATM 2561  C   MSE B 161      18.357  -7.608  61.672  1.00  9.70           C  
HETATM 2562  O   MSE B 161      17.891  -7.146  60.618  1.00 10.27           O  
HETATM 2563  CB  MSE B 161      16.831  -7.689  63.669  1.00  9.10           C  
HETATM 2564  CG  MSE B 161      16.366  -7.147  65.049  1.00  8.57           C  
HETATM 2565 SE   MSE B 161      14.925  -8.039  65.741  1.00  5.20          SE  
HETATM 2566  CE  MSE B 161      15.766  -9.524  66.336  1.00  7.66           C  
ATOM   2567  N   GLN B 162      19.158  -8.660  61.685  1.00  8.70           N  
ATOM   2568  CA  GLN B 162      19.485  -9.323  60.421  1.00  9.18           C  
ATOM   2569  C   GLN B 162      19.554 -10.837  60.533  1.00  9.29           C  
ATOM   2570  O   GLN B 162      19.803 -11.382  61.617  1.00  8.41           O  
ATOM   2571  CB  GLN B 162      20.784  -8.754  59.823  1.00  9.74           C  
ATOM   2572  CG  GLN B 162      22.053  -9.233  60.510  1.00 11.23           C  
ATOM   2573  CD  GLN B 162      23.276  -8.568  59.933  1.00 13.09           C  
ATOM   2574  OE1 GLN B 162      24.007  -9.158  59.136  1.00 15.23           O  
ATOM   2575  NE2 GLN B 162      23.499  -7.333  60.328  1.00 11.87           N  
ATOM   2576  N   LEU B 163      19.291 -11.492  59.401  1.00  9.49           N  
ATOM   2577  CA  LEU B 163      19.357 -12.937  59.279  1.00 11.00           C  
ATOM   2578  C   LEU B 163      20.283 -13.257  58.135  1.00 11.24           C  
ATOM   2579  O   LEU B 163      20.043 -12.817  57.012  1.00 11.29           O  
ATOM   2580  CB  LEU B 163      17.963 -13.513  58.983  1.00 10.02           C  
ATOM   2581  CG  LEU B 163      17.890 -15.034  58.770  1.00 10.83           C  
ATOM   2582  CD1 LEU B 163      18.423 -15.814  59.978  1.00  9.08           C  
ATOM   2583  CD2 LEU B 163      16.453 -15.459  58.431  1.00 12.06           C  
ATOM   2584  N   ASN B 164      21.357 -13.989  58.401  1.00 13.37           N  
ATOM   2585  CA  ASN B 164      22.198 -14.481  57.312  1.00 15.27           C  
ATOM   2586  C   ASN B 164      21.595 -15.774  56.788  1.00 16.61           C  
ATOM   2587  O   ASN B 164      21.452 -16.760  57.524  1.00 16.36           O  
ATOM   2588  CB  ASN B 164      23.665 -14.662  57.733  1.00 15.76           C  
ATOM   2589  CG  ASN B 164      24.597 -15.003  56.534  1.00 17.55           C  
ATOM   2590  OD1 ASN B 164      24.261 -15.808  55.663  1.00 16.72           O  
ATOM   2591  ND2 ASN B 164      25.780 -14.403  56.523  1.00 19.41           N  
ATOM   2592  N   LEU B 165      21.238 -15.750  55.509  1.00 17.82           N  
ATOM   2593  CA  LEU B 165      20.497 -16.826  54.875  1.00 19.38           C  
ATOM   2594  C   LEU B 165      21.368 -18.015  54.472  1.00 21.00           C  
ATOM   2595  O   LEU B 165      20.863 -19.117  54.272  1.00 21.45           O  
ATOM   2596  CB  LEU B 165      19.759 -16.285  53.653  1.00 18.98           C  
ATOM   2597  CG  LEU B 165      18.737 -15.178  53.933  1.00 19.97           C  
ATOM   2598  CD1 LEU B 165      18.424 -14.395  52.665  1.00 20.12           C  
ATOM   2599  CD2 LEU B 165      17.468 -15.740  54.571  1.00 21.09           C  
ATOM   2600  N   ASP B 166      22.672 -17.793  54.342  1.00 22.32           N  
ATOM   2601  CA  ASP B 166      23.583 -18.876  53.981  1.00 23.77           C  
ATOM   2602  C   ASP B 166      24.900 -18.690  54.711  1.00 24.11           C  
ATOM   2603  O   ASP B 166      25.899 -18.301  54.105  1.00 24.36           O  
ATOM   2604  CB  ASP B 166      23.791 -18.899  52.473  1.00 24.10           C  
ATOM   2605  CG  ASP B 166      24.536 -20.141  51.994  1.00 26.23           C  
ATOM   2606  OD1 ASP B 166      25.057 -20.930  52.828  1.00 28.09           O  
ATOM   2607  OD2 ASP B 166      24.603 -20.316  50.760  1.00 28.72           O  
ATOM   2608  N   PRO B 167      24.905 -18.959  56.030  1.00 24.95           N  
ATOM   2609  CA  PRO B 167      26.075 -18.665  56.849  1.00 25.60           C  
ATOM   2610  C   PRO B 167      27.330 -19.389  56.361  1.00 26.16           C  
ATOM   2611  O   PRO B 167      28.435 -18.879  56.565  1.00 26.19           O  
ATOM   2612  CB  PRO B 167      25.666 -19.150  58.244  1.00 25.76           C  
ATOM   2613  CG  PRO B 167      24.542 -20.090  58.015  1.00 25.69           C  
ATOM   2614  CD  PRO B 167      23.820 -19.557  56.827  1.00 24.98           C  
ATOM   2615  N   THR B 168      27.149 -20.530  55.688  1.00 26.61           N  
ATOM   2616  CA  THR B 168      28.279 -21.316  55.148  1.00 27.50           C  
ATOM   2617  C   THR B 168      28.957 -20.707  53.901  1.00 27.74           C  
ATOM   2618  O   THR B 168      30.075 -21.105  53.561  1.00 27.87           O  
ATOM   2619  CB  THR B 168      27.900 -22.803  54.857  1.00 27.30           C  
ATOM   2620  OG1 THR B 168      27.102 -22.894  53.667  1.00 27.58           O  
ATOM   2621  CG2 THR B 168      27.147 -23.413  56.030  1.00 27.80           C  
ATOM   2622  N   ARG B 169      28.287 -19.769  53.222  1.00 27.90           N  
ATOM   2623  CA  ARG B 169      28.847 -19.137  52.021  1.00 28.01           C  
ATOM   2624  C   ARG B 169      29.924 -18.121  52.402  1.00 27.85           C  
ATOM   2625  O   ARG B 169      29.654 -16.932  52.584  1.00 27.39           O  
ATOM   2626  CB  ARG B 169      27.756 -18.511  51.140  1.00 28.38           C  
ATOM   2627  CG  ARG B 169      28.280 -17.979  49.802  1.00 30.58           C  
ATOM   2628  CD  ARG B 169      27.261 -18.060  48.675  1.00 34.54           C  
ATOM   2629  NE  ARG B 169      26.350 -16.913  48.621  1.00 37.29           N  
ATOM   2630  CZ  ARG B 169      26.479 -15.871  47.796  1.00 37.97           C  
ATOM   2631  NH1 ARG B 169      27.496 -15.810  46.944  1.00 38.50           N  
ATOM   2632  NH2 ARG B 169      25.585 -14.884  47.823  1.00 37.30           N  
ATOM   2633  N   SER B 170      31.151 -18.619  52.515  1.00 27.81           N  
ATOM   2634  CA  SER B 170      32.274 -17.869  53.066  1.00 27.96           C  
ATOM   2635  C   SER B 170      32.706 -16.684  52.207  1.00 27.50           C  
ATOM   2636  O   SER B 170      33.308 -15.736  52.717  1.00 27.19           O  
ATOM   2637  CB  SER B 170      33.466 -18.805  53.287  1.00 28.23           C  
ATOM   2638  OG  SER B 170      33.182 -19.766  54.296  1.00 29.97           O  
ATOM   2639  N   ALA B 171      32.411 -16.756  50.909  1.00 27.16           N  
ATOM   2640  CA  ALA B 171      32.764 -15.695  49.965  1.00 27.08           C  
ATOM   2641  C   ALA B 171      31.661 -15.483  48.927  1.00 26.86           C  
ATOM   2642  O   ALA B 171      30.933 -16.425  48.593  1.00 26.56           O  
ATOM   2643  CB  ALA B 171      34.110 -16.009  49.287  1.00 27.16           C  
ATOM   2644  N   PRO B 172      31.517 -14.241  48.422  1.00 26.84           N  
ATOM   2645  CA  PRO B 172      30.470 -13.962  47.438  1.00 27.12           C  
ATOM   2646  C   PRO B 172      30.741 -14.636  46.094  1.00 27.55           C  
ATOM   2647  O   PRO B 172      29.828 -14.809  45.285  1.00 28.09           O  
ATOM   2648  CB  PRO B 172      30.506 -12.439  47.306  1.00 26.94           C  
ATOM   2649  CG  PRO B 172      31.874 -12.051  47.720  1.00 26.58           C  
ATOM   2650  CD  PRO B 172      32.302 -13.035  48.747  1.00 26.75           C  
ATOM   2651  OXT PRO B 172      31.869 -15.037  45.790  1.00 27.81           O  
TER    2652      PRO B 172                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
