
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  151 ( 1202),  selected  151 , name 2cnm_A
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 2cnm_A.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      R      26          3.560
LGA    N     2_A      Y      27          2.365
LGA    T     3_A      H      28          1.199
LGA    I     4_A      L      29          0.920
LGA    S     5_A      R      30          0.590
LGA    I     6_A      P      31          0.896
LGA    L     7_A      P      32          0.670
LGA    S     8_A      R      33          1.213
LGA    T     9_A      R      34          1.186
LGA    T    10_A      N      35          1.134
LGA    D    11_A      D      36          0.972
LGA    L    12_A      G      37          1.337
LGA    P    13_A      A      38          1.226
LGA    A    14_A      A      39          1.225
LGA    A    15_A      I      40          0.998
LGA    W    16_A      H      41          0.932
LGA    Q    17_A      Q      42          1.132
LGA    I    18_A      L      43          0.815
LGA    E    19_A      V      44          0.440
LGA    Q    20_A      S      45          0.555
LGA    R    21_A      E      46          0.915
LGA    A    22_A      C      47          1.024
LGA    H    23_A      P      48          2.685
LGA    A    24_A      P      49          1.645
LGA    F    25_A      L      50          4.518
LGA    P    26_A      D      51          2.443
LGA    W    27_A      L      52          2.329
LGA    S    28_A      N      53          2.475
LGA    E    29_A      S      54          1.433
LGA    K    30_A      L      55          4.673
LGA    T    31_A      -       -           -
LGA    F    32_A      Y      56          5.372
LGA    F    33_A      A      57          2.712
LGA    G    34_A      Y      58          5.221
LGA    N    35_A      L      59          6.293
LGA    Q    36_A      L      60          2.614
LGA    G    37_A      L      61           #
LGA    -       -      C      62           -
LGA    E    38_A      E      63           #
LGA    R    39_A      H      64          5.632
LGA    Y    40_A      H      65          1.624
LGA    -       -      A      66           -
LGA    -       -      H      67           -
LGA    L    41_A      T      68          1.907
LGA    N    42_A      C      69          1.852
LGA    L    43_A      V      70          1.115
LGA    K    44_A      V      71          0.663
LGA    L    45_A      A      72          1.066
LGA    T    46_A      E      73          1.151
LGA    A    47_A      S      74          2.543
LGA    D    48_A      P      75          2.076
LGA    D    49_A      G      76          1.780
LGA    -       -      G      77           -
LGA    R    50_A      R      78          1.955
LGA    M    51_A      I      79          1.277
LGA    A    52_A      D      80          1.634
LGA    A    53_A      G      81          0.512
LGA    F    54_A      F      82          0.723
LGA    A    55_A      V      83          0.867
LGA    I    56_A      S      84          0.847
LGA    T    57_A      A      85          1.040
LGA    Q    58_A      Y      86          1.165
LGA    V    59_A      L      87          1.500
LGA    V    60_A      L      88          3.201
LGA    -       -      P      89           -
LGA    -       -      T      90           -
LGA    -       -      R      91           -
LGA    L    61_A      P      92          1.908
LGA    D    62_A      D      93          1.834
LGA    E    63_A      V      94          1.566
LGA    A    64_A      L      95          1.586
LGA    T    65_A      F      96          0.907
LGA    L    66_A      V      97          0.932
LGA    F    67_A      W      98          1.087
LGA    N    68_A      Q      99          1.033
LGA    I    69_A      V     100          1.129
LGA    A    70_A      A     101          0.447
LGA    V    71_A      V     102          0.766
LGA    D    72_A      H     103          0.976
LGA    P    73_A      S     104          1.243
LGA    D    74_A      R     105          0.798
LGA    F    75_A      A     106          0.495
LGA    Q    76_A      R     107          1.941
LGA    R    77_A      G     108          2.973
LGA    R    78_A      H     109          1.978
LGA    G    79_A      R     110          1.243
LGA    L    80_A      L     111          1.351
LGA    G    81_A      G     112          1.442
LGA    R    82_A      R     113          1.175
LGA    M    83_A      A     114          0.781
LGA    L    84_A      M     115          0.813
LGA    L    85_A      L     116          1.132
LGA    E    86_A      G     117          1.040
LGA    H    87_A      H     118          0.735
LGA    L    88_A      I     119          1.231
LGA    I    89_A      L     120          1.510
LGA    D    90_A      E     121          1.226
LGA    E    91_A      R     122          1.679
LGA    -       -      Q     123           -
LGA    L    92_A      E     124          5.112
LGA    E    93_A      C     125          3.817
LGA    T    94_A      R     126          2.468
LGA    R    95_A      -       -           -
LGA    G    96_A      H     127          1.249
LGA    V    97_A      V     128          1.551
LGA    V    98_A      R     129          1.402
LGA    T    99_A      H     130          1.314
LGA    L   100_A      L     131          1.412
LGA    W   101_A      E     132          0.920
LGA    L   102_A      T     133          0.531
LGA    E   103_A      T     134          0.904
LGA    V   104_A      V     135          1.336
LGA    R   105_A      G     136          1.462
LGA    A   106_A      P     137          1.726
LGA    S   107_A      D     138          1.110
LGA    N   108_A      N     139          1.317
LGA    A   109_A      Q     140          1.624
LGA    A   110_A      A     141          1.383
LGA    A   111_A      S     142          0.883
LGA    I   112_A      R     143          1.244
LGA    A   113_A      R     144          1.377
LGA    L   114_A      T     145          1.252
LGA    Y   115_A      F     146          1.189
LGA    E   116_A      A     147          1.434
LGA    S   117_A      G     148          1.619
LGA    L   118_A      L     149          1.357
LGA    G   119_A      A     150          1.376
LGA    F   120_A      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    -       -      A     155           -
LGA    -       -      H     156           -
LGA    N   121_A      V     157          1.794
LGA    E   122_A      S     158          2.773
LGA    A   123_A      E     159          3.519
LGA    T   124_A      Q     160          1.488
LGA    I   125_A      P     161          1.213
LGA    R   126_A      F     162          2.470
LGA    -       -      F     163           -
LGA    R   127_A      D     164          2.341
LGA    N   128_A      R     165          3.221
LGA    -       -      Q     166           -
LGA    Y   129_A      A     167           #
LGA    Y   130_A      F     168           #
LGA    -       -      G     169           -
LGA    -       -      G     170           -
LGA    P   131_A      A     171           #
LGA    T   132_A      -       -           -
LGA    A   133_A      -       -           -
LGA    Q   134_A      -       -           -
LGA    G   135_A      D     172          3.934
LGA    H   136_A      H     173          3.717
LGA    E   137_A      D     174          1.742
LGA    D   138_A      D     175          1.942
LGA    A   139_A      E     176          1.159
LGA    I   140_A      M     177          1.733
LGA    I   141_A      L     178          0.673
LGA    M   142_A      L     179          0.902
LGA    A   143_A      R     180          1.275
LGA    L   144_A      I     181          1.916
LGA    P   145_A      G     182          1.748
LGA    -       -      P     183           -
LGA    I   146_A      F     184          2.650
LGA    S   147_A      -       -           -
LGA    M   148_A      -       -           -
LGA    K   149_A      -       -           -
LGA    L   150_A      -       -           -
LGA    H   151_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  151  159    5.0    135    2.03    15.56     68.278     6.339

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.299282 * X  +  -0.056091 * Y  +  -0.952515 * Z  +  52.307640
  Y_new =  -0.157338 * X  +  -0.987506 * Y  +   0.008716 * Z  + -36.544914
  Z_new =  -0.941103 * X  +   0.147258 * Y  +  -0.304368 * Z  +  76.119896 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.690975   -0.450618  [ DEG:   154.1815    -25.8185 ]
  Theta =   1.225878    1.915714  [ DEG:    70.2376    109.7624 ]
  Phi   =  -0.484011    2.657582  [ DEG:   -27.7318    152.2682 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cnm_A                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cnm_A.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  151  159   5.0  135   2.03   15.56  68.278
REMARK  ---------------------------------------------------------- 
MOLECULE 2cnm_A
HEADER    TRANSFERASE                             22-MAY-06   2CNM              
TITLE     RIMI- RIBOSOMAL S18 N-ALPHA-PROTEIN ACETYLTRANSFERASE IN              
TITLE    2 COMPLEX WITH A BISUBSTRATE INHIBITOR (CTERM-ARG-ARG-PHE-             
TITLE    3 TYR-ARG-ALA-N-ALPHA-ACETYL-S-COA).                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MODIFICATION OF 30S RIBOSOMAL SUBUNIT PROTEIN              
COMPND   3 S18;                                                                 
COMPND   4 CHAIN: A, B, C;                                                      
COMPND   5 SYNONYM: RIBOSOMAL-N-ALPHA-ACETYLTRANSFERASE;                        
COMPND   6 EC: 2.3.1.128;                                                       
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: CTERM-ARG-ARG-PHE-TYR-ARG-ALA-N-ALPHA-ACETYL;              
COMPND  10 CHAIN: D, E, F;                                                      
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SALMONELLA TYPHIMURIUM LT2;                     
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 MOL_ID: 2;                                                           
SOURCE   5 SYNTHETIC: YES                                                       
KEYWDS    N-ALPHA ACETYLATION, GCN5-N-ACETYLTRANSFERASE, RIBOSOMAL              
KEYWDS   2 PROTEIN, ACETYLTRANSFERASE, GNAT, TRANSFERASE,                       
KEYWDS   3 ACYLTRANSFERASE                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.W.VETTING,M.YU,D.C.BAREICH,J.S.BLANCHARD                            
REVDAT   1   22-MAY-07 2CNM    0                                                
JRNL        AUTH   M.W.VETTING,M.YU,D.C.BAREICH,J.S.BLANCHARD                   
JRNL        TITL   STRUCTURE OF RIMI FROM SALAMONELLA TYPHIMURIUM               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2CNM A    1   148  UNP    Q8ZJW4   Q8ZJW4_SALTY     1    148             
DBREF  2CNM A  149   160  PDB    2CNM     2CNM           149    160             
DBREF  2CNM B    1   148  UNP    Q8ZJW4   Q8ZJW4_SALTY     1    148             
DBREF  2CNM B  149   160  PDB    2CNM     2CNM           149    160             
DBREF  2CNM C    1   148  UNP    Q8ZJW4   Q8ZJW4_SALTY     1    148             
DBREF  2CNM C  149   160  PDB    2CNM     2CNM           149    160             
DBREF  2CNM D    1     7  PDB    2CNM     2CNM             1      7             
DBREF  2CNM E    1     7  PDB    2CNM     2CNM             1      7             
DBREF  2CNM F    1     7  PDB    2CNM     2CNM             1      7             
SEQRES   1 A  160  MET ASN THR ILE SER ILE LEU SER THR THR ASP LEU PRO          
SEQRES   2 A  160  ALA ALA TRP GLN ILE GLU GLN ARG ALA HIS ALA PHE PRO          
SEQRES   3 A  160  TRP SER GLU LYS THR PHE PHE GLY ASN GLN GLY GLU ARG          
SEQRES   4 A  160  TYR LEU ASN LEU LYS LEU THR ALA ASP ASP ARG MET ALA          
SEQRES   5 A  160  ALA PHE ALA ILE THR GLN VAL VAL LEU ASP GLU ALA THR          
SEQRES   6 A  160  LEU PHE ASN ILE ALA VAL ASP PRO ASP PHE GLN ARG ARG          
SEQRES   7 A  160  GLY LEU GLY ARG MET LEU LEU GLU HIS LEU ILE ASP GLU          
SEQRES   8 A  160  LEU GLU THR ARG GLY VAL VAL THR LEU TRP LEU GLU VAL          
SEQRES   9 A  160  ARG ALA SER ASN ALA ALA ALA ILE ALA LEU TYR GLU SER          
SEQRES  10 A  160  LEU GLY PHE ASN GLU ALA THR ILE ARG ARG ASN TYR TYR          
SEQRES  11 A  160  PRO THR ALA GLN GLY HIS GLU ASP ALA ILE ILE MET ALA          
SEQRES  12 A  160  LEU PRO ILE SER MET LYS LEU HIS HIS HIS HIS HIS HIS          
SEQRES  13 A  160  HIS HIS HIS HIS                                              
SEQRES   1 B  160  MET ASN THR ILE SER ILE LEU SER THR THR ASP LEU PRO          
SEQRES   2 B  160  ALA ALA TRP GLN ILE GLU GLN ARG ALA HIS ALA PHE PRO          
SEQRES   3 B  160  TRP SER GLU LYS THR PHE PHE GLY ASN GLN GLY GLU ARG          
SEQRES   4 B  160  TYR LEU ASN LEU LYS LEU THR ALA ASP ASP ARG MET ALA          
SEQRES   5 B  160  ALA PHE ALA ILE THR GLN VAL VAL LEU ASP GLU ALA THR          
SEQRES   6 B  160  LEU PHE ASN ILE ALA VAL ASP PRO ASP PHE GLN ARG ARG          
SEQRES   7 B  160  GLY LEU GLY ARG MET LEU LEU GLU HIS LEU ILE ASP GLU          
SEQRES   8 B  160  LEU GLU THR ARG GLY VAL VAL THR LEU TRP LEU GLU VAL          
SEQRES   9 B  160  ARG ALA SER ASN ALA ALA ALA ILE ALA LEU TYR GLU SER          
SEQRES  10 B  160  LEU GLY PHE ASN GLU ALA THR ILE ARG ARG ASN TYR TYR          
SEQRES  11 B  160  PRO THR ALA GLN GLY HIS GLU ASP ALA ILE ILE MET ALA          
SEQRES  12 B  160  LEU PRO ILE SER MET LYS LEU HIS HIS HIS HIS HIS HIS          
SEQRES  13 B  160  HIS HIS HIS HIS                                              
SEQRES   1 C  160  MET ASN THR ILE SER ILE LEU SER THR THR ASP LEU PRO          
SEQRES   2 C  160  ALA ALA TRP GLN ILE GLU GLN ARG ALA HIS ALA PHE PRO          
SEQRES   3 C  160  TRP SER GLU LYS THR PHE PHE GLY ASN GLN GLY GLU ARG          
SEQRES   4 C  160  TYR LEU ASN LEU LYS LEU THR ALA ASP ASP ARG MET ALA          
SEQRES   5 C  160  ALA PHE ALA ILE THR GLN VAL VAL LEU ASP GLU ALA THR          
SEQRES   6 C  160  LEU PHE ASN ILE ALA VAL ASP PRO ASP PHE GLN ARG ARG          
SEQRES   7 C  160  GLY LEU GLY ARG MET LEU LEU GLU HIS LEU ILE ASP GLU          
SEQRES   8 C  160  LEU GLU THR ARG GLY VAL VAL THR LEU TRP LEU GLU VAL          
SEQRES   9 C  160  ARG ALA SER ASN ALA ALA ALA ILE ALA LEU TYR GLU SER          
SEQRES  10 C  160  LEU GLY PHE ASN GLU ALA THR ILE ARG ARG ASN TYR TYR          
SEQRES  11 C  160  PRO THR ALA GLN GLY HIS GLU ASP ALA ILE ILE MET ALA          
SEQRES  12 C  160  LEU PRO ILE SER MET LYS LEU HIS HIS HIS HIS HIS HIS          
SEQRES  13 C  160  HIS HIS HIS HIS                                              
SEQRES   1 D    7  ACE ALA ARG TYR PHE ARG ARG                                  
SEQRES   1 E    7  ACE ALA ARG TYR PHE ARG ARG                                  
SEQRES   1 F    7  ACE ALA ARG TYR PHE ARG ARG                                  
HET    ACE  D   1       3                                                       
HET    ACE  E   1       3                                                       
HET    ACE  F   1       3                                                       
HET    COA  D   0      48                                                       
HET    COA  E   0      48                                                       
HET    COA  F   0      48                                                       
HETNAM     ACE ACETYL GROUP                                                     
HETNAM     COA COENZYME A                                                       
FORMUL   4  ACE    3(C2 H4 O)                                                   
FORMUL   7  COA    3(C21 H36 N7 O16 P3 S)                                       
FORMUL  10  HOH   *60(H2 O)                                                     
CRYST1  133.127  133.127  190.986  90.00  90.00 120.00 H 3 2        54          
ATOM      1  N   MET A   1      -7.971 -22.223  55.216  1.00 33.22           N  
ATOM      2  CA  MET A   1      -6.642 -22.438  54.575  1.00 34.44           C  
ATOM      3  C   MET A   1      -5.951 -21.121  54.277  1.00 32.22           C  
ATOM      4  O   MET A   1      -6.590 -20.092  54.050  1.00 31.88           O  
ATOM      5  CB  MET A   1      -6.786 -23.225  53.286  1.00 34.59           C  
ATOM      6  CG  MET A   1      -8.065 -22.869  52.580  1.00 36.69           C  
ATOM      7  SD  MET A   1      -7.799 -22.427  50.855  1.00 39.20           S  
ATOM      8  CE  MET A   1      -9.508 -21.951  50.411  1.00 38.48           C  
ATOM      9  N   ASN A   2      -4.632 -21.164  54.276  1.00 30.63           N  
ATOM     10  CA  ASN A   2      -3.872 -19.940  54.121  1.00 29.45           C  
ATOM     11  C   ASN A   2      -3.033 -19.997  52.860  1.00 28.57           C  
ATOM     12  O   ASN A   2      -2.422 -21.003  52.570  1.00 28.88           O  
ATOM     13  CB  ASN A   2      -3.030 -19.697  55.371  1.00 29.24           C  
ATOM     14  CG  ASN A   2      -3.856 -19.784  56.657  1.00 28.40           C  
ATOM     15  OD1 ASN A   2      -3.613 -20.635  57.507  1.00 28.07           O  
ATOM     16  ND2 ASN A   2      -4.838 -18.915  56.789  1.00 26.99           N  
ATOM     17  N   THR A   3      -3.026 -18.933  52.083  1.00 27.56           N  
ATOM     18  CA  THR A   3      -2.391 -19.012  50.780  1.00 27.06           C  
ATOM     19  C   THR A   3      -1.544 -17.768  50.576  1.00 26.79           C  
ATOM     20  O   THR A   3      -2.058 -16.624  50.591  1.00 26.77           O  
ATOM     21  CB  THR A   3      -3.438 -19.196  49.647  1.00 26.93           C  
ATOM     22  OG1 THR A   3      -4.121 -20.435  49.837  1.00 26.31           O  
ATOM     23  CG2 THR A   3      -2.771 -19.250  48.317  1.00 27.42           C  
ATOM     24  N   ILE A   4      -0.244 -18.002  50.432  1.00 25.48           N  
ATOM     25  CA  ILE A   4       0.689 -16.928  50.242  1.00 24.59           C  
ATOM     26  C   ILE A   4       0.864 -16.768  48.745  1.00 24.67           C  
ATOM     27  O   ILE A   4       1.123 -17.744  48.039  1.00 25.70           O  
ATOM     28  CB  ILE A   4       2.024 -17.201  50.964  1.00 24.59           C  
ATOM     29  CG1 ILE A   4       1.873 -16.928  52.462  1.00 23.40           C  
ATOM     30  CG2 ILE A   4       3.096 -16.276  50.446  1.00 22.40           C  
ATOM     31  CD1 ILE A   4       2.132 -18.081  53.280  1.00 24.26           C  
ATOM     32  N   SER A   5       0.678 -15.558  48.245  1.00 23.38           N  
ATOM     33  CA  SER A   5       0.904 -15.337  46.842  1.00 23.42           C  
ATOM     34  C   SER A   5       1.558 -13.993  46.638  1.00 23.63           C  
ATOM     35  O   SER A   5       1.726 -13.224  47.591  1.00 24.58           O  
ATOM     36  CB  SER A   5      -0.402 -15.444  46.053  1.00 23.11           C  
ATOM     37  OG  SER A   5      -1.405 -14.601  46.596  1.00 24.80           O  
ATOM     38  N   ILE A   6       1.957 -13.728  45.399  1.00 23.20           N  
ATOM     39  CA  ILE A   6       2.394 -12.409  44.995  1.00 22.63           C  
ATOM     40  C   ILE A   6       1.284 -11.371  45.179  1.00 22.66           C  
ATOM     41  O   ILE A   6       0.098 -11.672  44.962  1.00 22.60           O  
ATOM     42  CB  ILE A   6       2.917 -12.436  43.529  1.00 22.66           C  
ATOM     43  CG1 ILE A   6       4.266 -13.175  43.462  1.00 22.10           C  
ATOM     44  CG2 ILE A   6       3.115 -11.022  42.986  1.00 21.00           C  
ATOM     45  CD1 ILE A   6       5.400 -12.440  44.164  1.00 21.43           C  
ATOM     46  N   LEU A   7       1.696 -10.170  45.601  1.00 22.86           N  
ATOM     47  CA  LEU A   7       0.843  -8.979  45.739  1.00 23.20           C  
ATOM     48  C   LEU A   7       0.884  -8.171  44.457  1.00 23.55           C  
ATOM     49  O   LEU A   7       1.911  -7.593  44.081  1.00 24.04           O  
ATOM     50  CB  LEU A   7       1.336  -8.098  46.899  1.00 23.27           C  
ATOM     51  CG  LEU A   7       0.409  -6.949  47.328  1.00 24.07           C  
ATOM     52  CD1 LEU A   7      -0.697  -7.421  48.303  1.00 22.31           C  
ATOM     53  CD2 LEU A   7       1.199  -5.805  47.953  1.00 24.35           C  
ATOM     54  N   SER A   8      -0.235  -8.148  43.760  1.00 24.58           N  
ATOM     55  CA  SER A   8      -0.330  -7.516  42.441  1.00 24.69           C  
ATOM     56  C   SER A   8      -1.321  -6.371  42.481  1.00 24.25           C  
ATOM     57  O   SER A   8      -2.177  -6.329  43.358  1.00 23.85           O  
ATOM     58  CB  SER A   8      -0.842  -8.544  41.459  1.00 25.01           C  
ATOM     59  OG  SER A   8      -2.159  -8.940  41.856  1.00 27.37           O  
ATOM     60  N   THR A   9      -1.211  -5.477  41.505  1.00 24.10           N  
ATOM     61  CA  THR A   9      -2.096  -4.316  41.306  1.00 23.79           C  
ATOM     62  C   THR A   9      -3.516  -4.429  41.892  1.00 24.11           C  
ATOM     63  O   THR A   9      -3.955  -3.580  42.689  1.00 23.85           O  
ATOM     64  CB  THR A   9      -2.197  -4.033  39.795  1.00 24.13           C  
ATOM     65  OG1 THR A   9      -0.869  -3.952  39.256  1.00 23.77           O  
ATOM     66  CG2 THR A   9      -2.982  -2.737  39.500  1.00 22.58           C  
ATOM     67  N   THR A  10      -4.217  -5.487  41.497  1.00 24.15           N  
ATOM     68  CA  THR A  10      -5.584  -5.718  41.942  1.00 24.82           C  
ATOM     69  C   THR A  10      -5.715  -5.847  43.454  1.00 24.69           C  
ATOM     70  O   THR A  10      -6.786  -5.585  44.003  1.00 24.66           O  
ATOM     71  CB  THR A  10      -6.174  -6.983  41.263  1.00 25.38           C  
ATOM     72  OG1 THR A  10      -6.463  -6.703  39.884  1.00 26.05           O  
ATOM     73  CG2 THR A  10      -7.439  -7.425  41.943  1.00 24.52           C  
ATOM     74  N   ASP A  11      -4.616  -6.239  44.102  1.00 24.56           N  
ATOM     75  CA  ASP A  11      -4.570  -6.543  45.533  1.00 24.80           C  
ATOM     76  C   ASP A  11      -4.350  -5.307  46.369  1.00 24.56           C  
ATOM     77  O   ASP A  11      -4.459  -5.378  47.602  1.00 24.86           O  
ATOM     78  CB  ASP A  11      -3.365  -7.453  45.883  1.00 25.04           C  
ATOM     79  CG  ASP A  11      -3.491  -8.858  45.349  1.00 26.22           C  
ATOM     80  OD1 ASP A  11      -4.646  -9.388  45.312  1.00 28.73           O  
ATOM     81  OD2 ASP A  11      -2.424  -9.433  44.989  1.00 23.70           O  
ATOM     82  N   LEU A  12      -3.976  -4.194  45.743  1.00 23.95           N  
ATOM     83  CA  LEU A  12      -3.458  -3.077  46.546  1.00 23.73           C  
ATOM     84  C   LEU A  12      -4.495  -2.327  47.412  1.00 24.27           C  
ATOM     85  O   LEU A  12      -4.172  -1.992  48.558  1.00 24.37           O  
ATOM     86  CB  LEU A  12      -2.553  -2.150  45.739  1.00 22.99           C  
ATOM     87  CG  LEU A  12      -1.428  -2.868  44.983  1.00 21.83           C  
ATOM     88  CD1 LEU A  12      -0.763  -1.960  43.964  1.00 22.63           C  
ATOM     89  CD2 LEU A  12      -0.407  -3.479  45.904  1.00 18.18           C  
ATOM     90  N   PRO A  13      -5.726  -2.067  46.888  1.00 24.32           N  
ATOM     91  CA  PRO A  13      -6.758  -1.498  47.780  1.00 24.59           C  
ATOM     92  C   PRO A  13      -7.012  -2.307  49.071  1.00 25.48           C  
ATOM     93  O   PRO A  13      -7.034  -1.717  50.168  1.00 26.02           O  
ATOM     94  CB  PRO A  13      -8.001  -1.437  46.895  1.00 24.17           C  
ATOM     95  CG  PRO A  13      -7.450  -1.324  45.500  1.00 23.98           C  
ATOM     96  CD  PRO A  13      -6.214  -2.198  45.503  1.00 23.86           C  
ATOM     97  N   ALA A  14      -7.182  -3.626  48.974  1.00 25.41           N  
ATOM     98  CA  ALA A  14      -7.322  -4.426  50.193  1.00 25.71           C  
ATOM     99  C   ALA A  14      -6.119  -4.236  51.167  1.00 26.20           C  
ATOM    100  O   ALA A  14      -6.303  -4.069  52.383  1.00 26.59           O  
ATOM    101  CB  ALA A  14      -7.514  -5.860  49.846  1.00 25.59           C  
ATOM    102  N   ALA A  15      -4.902  -4.243  50.625  1.00 25.66           N  
ATOM    103  CA  ALA A  15      -3.686  -4.100  51.419  1.00 25.46           C  
ATOM    104  C   ALA A  15      -3.564  -2.702  52.013  1.00 25.80           C  
ATOM    105  O   ALA A  15      -3.079  -2.527  53.151  1.00 25.94           O  
ATOM    106  CB  ALA A  15      -2.462  -4.401  50.567  1.00 25.27           C  
ATOM    107  N   TRP A  16      -3.987  -1.703  51.240  1.00 25.49           N  
ATOM    108  CA  TRP A  16      -3.976  -0.327  51.720  1.00 25.14           C  
ATOM    109  C   TRP A  16      -4.864  -0.200  52.941  1.00 25.18           C  
ATOM    110  O   TRP A  16      -4.488   0.472  53.900  1.00 25.38           O  
ATOM    111  CB  TRP A  16      -4.308   0.693  50.611  1.00 24.32           C  
ATOM    112  CG  TRP A  16      -4.518   2.125  51.089  1.00 23.92           C  
ATOM    113  CD1 TRP A  16      -5.680   2.864  50.991  1.00 23.09           C  
ATOM    114  CD2 TRP A  16      -3.561   2.975  51.725  1.00 22.66           C  
ATOM    115  NE1 TRP A  16      -5.499   4.108  51.532  1.00 23.17           N  
ATOM    116  CE2 TRP A  16      -4.213   4.209  51.998  1.00 22.96           C  
ATOM    117  CE3 TRP A  16      -2.229   2.815  52.115  1.00 23.49           C  
ATOM    118  CZ2 TRP A  16      -3.571   5.285  52.635  1.00 21.43           C  
ATOM    119  CZ3 TRP A  16      -1.581   3.896  52.758  1.00 23.89           C  
ATOM    120  CH2 TRP A  16      -2.265   5.110  53.008  1.00 23.34           C  
ATOM    121  N   GLN A  17      -6.003  -0.893  52.930  1.00 25.84           N  
ATOM    122  CA  GLN A  17      -6.898  -0.957  54.110  1.00 26.43           C  
ATOM    123  C   GLN A  17      -6.183  -1.553  55.305  1.00 26.23           C  
ATOM    124  O   GLN A  17      -6.327  -1.042  56.423  1.00 26.80           O  
ATOM    125  CB  GLN A  17      -8.157  -1.788  53.833  1.00 26.56           C  
ATOM    126  CG  GLN A  17      -9.223  -1.030  53.148  1.00 29.30           C  
ATOM    127  CD  GLN A  17      -9.662   0.150  53.995  1.00 34.23           C  
ATOM    128  OE1 GLN A  17     -10.507   0.006  54.903  1.00 36.27           O  
ATOM    129  NE2 GLN A  17      -9.078   1.329  53.720  1.00 32.57           N  
ATOM    130  N   ILE A  18      -5.427  -2.632  55.058  1.00 25.40           N  
ATOM    131  CA  ILE A  18      -4.652  -3.297  56.095  1.00 24.78           C  
ATOM    132  C   ILE A  18      -3.540  -2.371  56.601  1.00 24.37           C  
ATOM    133  O   ILE A  18      -3.335  -2.243  57.817  1.00 24.27           O  
ATOM    134  CB  ILE A  18      -4.093  -4.679  55.626  1.00 25.32           C  
ATOM    135  CG1 ILE A  18      -5.258  -5.664  55.363  1.00 25.10           C  
ATOM    136  CG2 ILE A  18      -3.082  -5.259  56.661  1.00 24.83           C  
ATOM    137  CD1 ILE A  18      -4.836  -7.098  55.102  1.00 24.79           C  
ATOM    138  N   GLU A  19      -2.858  -1.697  55.681  1.00 23.43           N  
ATOM    139  CA  GLU A  19      -1.842  -0.727  56.070  1.00 23.33           C  
ATOM    140  C   GLU A  19      -2.366   0.331  57.068  1.00 23.93           C  
ATOM    141  O   GLU A  19      -1.707   0.657  58.060  1.00 24.08           O  
ATOM    142  CB  GLU A  19      -1.286  -0.056  54.830  1.00 22.78           C  
ATOM    143  CG  GLU A  19      -0.466   1.120  55.121  1.00 21.09           C  
ATOM    144  CD  GLU A  19       0.888   0.792  55.720  1.00 22.33           C  
ATOM    145  OE1 GLU A  19       1.270  -0.387  55.881  1.00 23.02           O  
ATOM    146  OE2 GLU A  19       1.607   1.752  56.026  1.00 23.29           O  
ATOM    147  N   GLN A  20      -3.570   0.835  56.813  1.00 23.96           N  
ATOM    148  CA  GLN A  20      -4.140   1.884  57.639  1.00 24.00           C  
ATOM    149  C   GLN A  20      -4.752   1.362  58.921  1.00 24.12           C  
ATOM    150  O   GLN A  20      -4.956   2.128  59.842  1.00 23.72           O  
ATOM    151  CB  GLN A  20      -5.202   2.644  56.877  1.00 23.82           C  
ATOM    152  CG  GLN A  20      -4.705   3.737  55.980  1.00 23.96           C  
ATOM    153  CD  GLN A  20      -5.814   4.172  55.034  1.00 25.73           C  
ATOM    154  OE1 GLN A  20      -6.294   3.363  54.234  1.00 25.29           O  
ATOM    155  NE2 GLN A  20      -6.244   5.444  55.133  1.00 23.78           N  
ATOM    156  N   ARG A  21      -5.046   0.064  58.978  1.00 24.53           N  
ATOM    157  CA  ARG A  21      -5.607  -0.536  60.193  1.00 24.47           C  
ATOM    158  C   ARG A  21      -4.560  -1.091  61.174  1.00 24.90           C  
ATOM    159  O   ARG A  21      -4.819  -1.154  62.365  1.00 24.73           O  
ATOM    160  CB  ARG A  21      -6.598  -1.638  59.830  1.00 24.33           C  
ATOM    161  CG  ARG A  21      -7.966  -1.119  59.411  1.00 23.75           C  
ATOM    162  CD  ARG A  21      -8.721  -2.101  58.528  1.00 22.85           C  
ATOM    163  NE  ARG A  21      -8.893  -3.415  59.140  1.00 22.50           N  
ATOM    164  CZ  ARG A  21      -9.784  -3.695  60.089  1.00 24.97           C  
ATOM    165  NH1 ARG A  21     -10.604  -2.745  60.547  1.00 26.49           N  
ATOM    166  NH2 ARG A  21      -9.868  -4.933  60.582  1.00 24.26           N  
ATOM    167  N   ALA A  22      -3.397  -1.508  60.680  1.00 25.42           N  
ATOM    168  CA  ALA A  22      -2.442  -2.244  61.502  1.00 26.11           C  
ATOM    169  C   ALA A  22      -1.286  -1.378  62.020  1.00 27.27           C  
ATOM    170  O   ALA A  22      -0.664  -1.701  63.046  1.00 27.61           O  
ATOM    171  CB  ALA A  22      -1.908  -3.387  60.732  1.00 26.06           C  
ATOM    172  N   HIS A  23      -1.011  -0.283  61.308  1.00 27.63           N  
ATOM    173  CA  HIS A  23       0.012   0.690  61.702  1.00 27.62           C  
ATOM    174  C   HIS A  23      -0.593   1.935  62.346  1.00 27.54           C  
ATOM    175  O   HIS A  23      -1.462   2.587  61.770  1.00 27.33           O  
ATOM    176  CB  HIS A  23       0.854   1.127  60.483  1.00 27.39           C  
ATOM    177  CG  HIS A  23       1.790   0.073  59.974  1.00 26.25           C  
ATOM    178  ND1 HIS A  23       2.751  -0.517  60.768  1.00 25.26           N  
ATOM    179  CD2 HIS A  23       1.930  -0.477  58.741  1.00 26.45           C  
ATOM    180  CE1 HIS A  23       3.430  -1.400  60.052  1.00 26.57           C  
ATOM    181  NE2 HIS A  23       2.948  -1.400  58.820  1.00 26.85           N  
ATOM    182  N   ALA A  24      -0.101   2.293  63.525  1.00 27.86           N  
ATOM    183  CA  ALA A  24      -0.529   3.546  64.143  1.00 27.73           C  
ATOM    184  C   ALA A  24      -0.090   4.742  63.262  1.00 27.82           C  
ATOM    185  O   ALA A  24      -0.846   5.706  63.087  1.00 28.01           O  
ATOM    186  CB  ALA A  24       0.014   3.654  65.547  1.00 27.52           C  
ATOM    187  N   PHE A  25       1.106   4.650  62.670  1.00 27.50           N  
ATOM    188  CA  PHE A  25       1.594   5.682  61.734  1.00 26.80           C  
ATOM    189  C   PHE A  25       1.875   5.084  60.356  1.00 26.07           C  
ATOM    190  O   PHE A  25       3.025   4.800  60.029  1.00 25.31           O  
ATOM    191  CB  PHE A  25       2.826   6.392  62.311  1.00 26.91           C  
ATOM    192  CG  PHE A  25       2.582   6.982  63.668  1.00 27.10           C  
ATOM    193  CD1 PHE A  25       2.034   8.276  63.794  1.00 25.36           C  
ATOM    194  CD2 PHE A  25       2.838   6.230  64.823  1.00 26.13           C  
ATOM    195  CE1 PHE A  25       1.766   8.831  65.042  1.00 24.70           C  
ATOM    196  CE2 PHE A  25       2.584   6.767  66.087  1.00 27.18           C  
ATOM    197  CZ  PHE A  25       2.035   8.082  66.197  1.00 27.02           C  
ATOM    198  N   PRO A  26       0.804   4.883  59.545  1.00 25.69           N  
ATOM    199  CA  PRO A  26       0.934   4.169  58.258  1.00 24.79           C  
ATOM    200  C   PRO A  26       1.753   5.002  57.292  1.00 24.53           C  
ATOM    201  O   PRO A  26       1.994   6.152  57.579  1.00 24.22           O  
ATOM    202  CB  PRO A  26      -0.514   4.082  57.778  1.00 25.21           C  
ATOM    203  CG  PRO A  26      -1.228   5.272  58.477  1.00 23.94           C  
ATOM    204  CD  PRO A  26      -0.591   5.333  59.806  1.00 24.79           C  
ATOM    205  N   TRP A  27       2.176   4.439  56.159  1.00 24.71           N  
ATOM    206  CA  TRP A  27       2.789   5.222  55.071  1.00 24.51           C  
ATOM    207  C   TRP A  27       1.740   6.172  54.500  1.00 24.58           C  
ATOM    208  O   TRP A  27       0.564   6.082  54.844  1.00 25.55           O  
ATOM    209  CB  TRP A  27       3.309   4.314  53.935  1.00 24.09           C  
ATOM    210  CG  TRP A  27       4.505   3.472  54.272  1.00 23.86           C  
ATOM    211  CD1 TRP A  27       5.364   3.662  55.306  1.00 23.25           C  
ATOM    212  CD2 TRP A  27       4.996   2.318  53.556  1.00 24.42           C  
ATOM    213  NE1 TRP A  27       6.336   2.703  55.299  1.00 22.66           N  
ATOM    214  CE2 TRP A  27       6.145   1.869  54.232  1.00 22.84           C  
ATOM    215  CE3 TRP A  27       4.573   1.617  52.412  1.00 25.10           C  
ATOM    216  CZ2 TRP A  27       6.883   0.756  53.810  1.00 23.17           C  
ATOM    217  CZ3 TRP A  27       5.304   0.494  51.998  1.00 22.70           C  
ATOM    218  CH2 TRP A  27       6.436   0.080  52.700  1.00 23.72           C  
ATOM    219  N   SER A  28       2.163   7.092  53.639  1.00 24.70           N  
ATOM    220  CA  SER A  28       1.226   7.856  52.819  1.00 24.12           C  
ATOM    221  C   SER A  28       0.778   6.976  51.647  1.00 24.29           C  
ATOM    222  O   SER A  28       1.533   6.131  51.148  1.00 24.55           O  
ATOM    223  CB  SER A  28       1.891   9.128  52.287  1.00 23.66           C  
ATOM    224  OG  SER A  28       2.985   8.829  51.440  1.00 22.67           O  
ATOM    225  N   GLU A  29      -0.442   7.206  51.199  1.00 24.00           N  
ATOM    226  CA  GLU A  29      -0.982   6.538  50.033  1.00 24.25           C  
ATOM    227  C   GLU A  29       0.014   6.494  48.874  1.00 24.58           C  
ATOM    228  O   GLU A  29       0.239   5.435  48.311  1.00 24.77           O  
ATOM    229  CB  GLU A  29      -2.297   7.223  49.620  1.00 24.05           C  
ATOM    230  CG  GLU A  29      -3.331   6.304  48.989  1.00 23.63           C  
ATOM    231  CD  GLU A  29      -4.663   7.014  48.637  1.00 24.22           C  
ATOM    232  OE1 GLU A  29      -5.234   7.757  49.490  1.00 22.87           O  
ATOM    233  OE2 GLU A  29      -5.145   6.808  47.495  1.00 23.20           O  
ATOM    234  N   LYS A  30       0.618   7.632  48.528  1.00 25.41           N  
ATOM    235  CA  LYS A  30       1.529   7.715  47.375  1.00 26.08           C  
ATOM    236  C   LYS A  30       2.728   6.819  47.597  1.00 25.76           C  
ATOM    237  O   LYS A  30       3.069   5.998  46.736  1.00 26.00           O  
ATOM    238  CB  LYS A  30       1.976   9.147  47.122  1.00 26.04           C  
ATOM    239  CG  LYS A  30       0.837  10.125  47.297  1.00 29.95           C  
ATOM    240  CD  LYS A  30       1.307  11.596  47.207  1.00 35.09           C  
ATOM    241  CE  LYS A  30       1.086  12.163  45.800  1.00 35.88           C  
ATOM    242  NZ  LYS A  30       0.643  13.560  45.878  1.00 35.43           N  
ATOM    243  N   THR A  31       3.340   6.952  48.769  1.00 25.27           N  
ATOM    244  CA  THR A  31       4.451   6.095  49.150  1.00 24.29           C  
ATOM    245  C   THR A  31       4.006   4.649  49.107  1.00 24.11           C  
ATOM    246  O   THR A  31       4.731   3.766  48.615  1.00 24.53           O  
ATOM    247  CB  THR A  31       4.974   6.466  50.535  1.00 23.98           C  
ATOM    248  OG1 THR A  31       5.722   7.677  50.416  1.00 25.26           O  
ATOM    249  CG2 THR A  31       5.867   5.395  51.083  1.00 21.96           C  
ATOM    250  N   PHE A  32       2.808   4.387  49.597  1.00 23.48           N  
ATOM    251  CA  PHE A  32       2.373   3.007  49.617  1.00 23.70           C  
ATOM    252  C   PHE A  32       2.180   2.447  48.211  1.00 23.35           C  
ATOM    253  O   PHE A  32       2.689   1.388  47.901  1.00 23.34           O  
ATOM    254  CB  PHE A  32       1.114   2.788  50.467  1.00 23.88           C  
ATOM    255  CG  PHE A  32       0.679   1.352  50.492  1.00 24.39           C  
ATOM    256  CD1 PHE A  32      -0.170   0.850  49.500  1.00 24.47           C  
ATOM    257  CD2 PHE A  32       1.154   0.490  51.475  1.00 22.48           C  
ATOM    258  CE1 PHE A  32      -0.535  -0.487  49.499  1.00 24.70           C  
ATOM    259  CE2 PHE A  32       0.778  -0.838  51.487  1.00 23.79           C  
ATOM    260  CZ  PHE A  32      -0.056  -1.331  50.488  1.00 24.09           C  
ATOM    261  N   PHE A  33       1.461   3.173  47.365  1.00 23.54           N  
ATOM    262  CA  PHE A  33       1.219   2.727  46.001  1.00 24.07           C  
ATOM    263  C   PHE A  33       2.453   2.773  45.113  1.00 24.87           C  
ATOM    264  O   PHE A  33       2.438   2.192  44.029  1.00 25.35           O  
ATOM    265  CB  PHE A  33       0.075   3.515  45.367  1.00 23.26           C  
ATOM    266  CG  PHE A  33      -1.261   2.968  45.707  1.00 22.83           C  
ATOM    267  CD1 PHE A  33      -1.905   3.352  46.900  1.00 22.36           C  
ATOM    268  CD2 PHE A  33      -1.866   2.024  44.869  1.00 20.42           C  
ATOM    269  CE1 PHE A  33      -3.149   2.817  47.246  1.00 21.74           C  
ATOM    270  CE2 PHE A  33      -3.099   1.497  45.182  1.00 19.83           C  
ATOM    271  CZ  PHE A  33      -3.755   1.886  46.383  1.00 22.31           C  
ATOM    272  N   GLY A  34       3.504   3.446  45.587  1.00 25.12           N  
ATOM    273  CA  GLY A  34       4.758   3.571  44.873  1.00 25.80           C  
ATOM    274  C   GLY A  34       5.726   2.444  45.159  1.00 26.79           C  
ATOM    275  O   GLY A  34       6.665   2.217  44.385  1.00 26.53           O  
ATOM    276  N   ASN A  35       5.516   1.715  46.255  1.00 27.21           N  
ATOM    277  CA  ASN A  35       6.441   0.613  46.567  1.00 27.80           C  
ATOM    278  C   ASN A  35       6.070  -0.733  45.925  1.00 27.98           C  
ATOM    279  O   ASN A  35       5.890  -1.757  46.597  1.00 28.17           O  
ATOM    280  CB  ASN A  35       6.699   0.495  48.077  1.00 27.78           C  
ATOM    281  CG  ASN A  35       7.691   1.541  48.582  1.00 28.48           C  
ATOM    282  OD1 ASN A  35       7.326   2.689  48.840  1.00 31.11           O  
ATOM    283  ND2 ASN A  35       8.942   1.144  48.737  1.00 27.28           N  
ATOM    284  N   GLN A  36       5.985  -0.717  44.605  1.00 28.26           N  
ATOM    285  CA  GLN A  36       5.642  -1.885  43.812  1.00 28.71           C  
ATOM    286  C   GLN A  36       6.525  -1.771  42.584  1.00 28.88           C  
ATOM    287  O   GLN A  36       7.124  -0.712  42.353  1.00 28.58           O  
ATOM    288  CB  GLN A  36       4.160  -1.839  43.371  1.00 28.26           C  
ATOM    289  CG  GLN A  36       3.116  -1.439  44.450  1.00 30.06           C  
ATOM    290  CD  GLN A  36       3.036  -2.420  45.661  1.00 33.92           C  
ATOM    291  OE1 GLN A  36       3.177  -3.647  45.517  1.00 34.77           O  
ATOM    292  NE2 GLN A  36       2.803  -1.867  46.854  1.00 32.91           N  
ATOM    293  N   GLY A  37       6.588  -2.839  41.789  1.00 29.44           N  
ATOM    294  CA  GLY A  37       7.302  -2.839  40.520  1.00 29.18           C  
ATOM    295  C   GLY A  37       8.698  -3.428  40.644  1.00 29.73           C  
ATOM    296  O   GLY A  37       8.929  -4.305  41.463  1.00 29.39           O  
ATOM    297  N   GLU A  38       9.631  -2.897  39.855  1.00 30.33           N  
ATOM    298  CA  GLU A  38      10.977  -3.451  39.699  1.00 30.80           C  
ATOM    299  C   GLU A  38      11.754  -3.661  40.978  1.00 30.19           C  
ATOM    300  O   GLU A  38      11.960  -2.721  41.759  1.00 30.66           O  
ATOM    301  CB  GLU A  38      11.806  -2.629  38.723  1.00 31.00           C  
ATOM    302  CG  GLU A  38      11.482  -2.999  37.264  1.00 33.85           C  
ATOM    303  CD  GLU A  38      12.210  -2.110  36.268  1.00 36.87           C  
ATOM    304  OE1 GLU A  38      13.144  -1.341  36.680  1.00 36.36           O  
ATOM    305  OE2 GLU A  38      11.839  -2.197  35.080  1.00 36.47           O  
ATOM    306  N   ARG A  39      12.183  -4.903  41.159  1.00 28.50           N  
ATOM    307  CA  ARG A  39      12.962  -5.311  42.306  1.00 27.95           C  
ATOM    308  C   ARG A  39      12.107  -5.549  43.572  1.00 27.73           C  
ATOM    309  O   ARG A  39      12.649  -5.883  44.637  1.00 28.02           O  
ATOM    310  CB  ARG A  39      14.202  -4.394  42.540  1.00 27.67           C  
ATOM    311  CG  ARG A  39      15.128  -4.314  41.308  1.00 26.57           C  
ATOM    312  CD  ARG A  39      16.440  -3.559  41.531  1.00 26.59           C  
ATOM    313  NE  ARG A  39      17.286  -3.646  40.337  1.00 24.76           N  
ATOM    314  CZ  ARG A  39      17.248  -2.777  39.315  1.00 22.92           C  
ATOM    315  NH1 ARG A  39      16.438  -1.743  39.355  1.00 19.35           N  
ATOM    316  NH2 ARG A  39      18.027  -2.939  38.251  1.00 17.61           N  
ATOM    317  N   TYR A  40      10.789  -5.403  43.464  1.00 26.51           N  
ATOM    318  CA  TYR A  40       9.919  -5.744  44.598  1.00 25.81           C  
ATOM    319  C   TYR A  40       9.402  -7.150  44.534  1.00 25.13           C  
ATOM    320  O   TYR A  40       8.841  -7.589  43.527  1.00 25.36           O  
ATOM    321  CB  TYR A  40       8.723  -4.816  44.711  1.00 25.87           C  
ATOM    322  CG  TYR A  40       9.094  -3.444  45.198  1.00 25.83           C  
ATOM    323  CD1 TYR A  40       9.137  -3.148  46.561  1.00 24.28           C  
ATOM    324  CD2 TYR A  40       9.370  -2.430  44.288  1.00 25.06           C  
ATOM    325  CE1 TYR A  40       9.472  -1.880  47.000  1.00 23.36           C  
ATOM    326  CE2 TYR A  40       9.714  -1.186  44.714  1.00 24.62           C  
ATOM    327  CZ  TYR A  40       9.764  -0.919  46.061  1.00 24.65           C  
ATOM    328  OH  TYR A  40      10.107   0.333  46.433  1.00 25.84           O  
ATOM    329  N   LEU A  41       9.580  -7.854  45.632  1.00 24.14           N  
ATOM    330  CA  LEU A  41       9.024  -9.171  45.777  1.00 23.98           C  
ATOM    331  C   LEU A  41       7.965  -8.997  46.851  1.00 24.43           C  
ATOM    332  O   LEU A  41       8.266  -9.102  48.053  1.00 26.06           O  
ATOM    333  CB  LEU A  41      10.105 -10.150  46.221  1.00 23.50           C  
ATOM    334  CG  LEU A  41       9.622 -11.565  46.483  1.00 22.56           C  
ATOM    335  CD1 LEU A  41       9.283 -12.257  45.186  1.00 18.87           C  
ATOM    336  CD2 LEU A  41      10.698 -12.322  47.243  1.00 21.02           C  
ATOM    337  N   ASN A  42       6.748  -8.681  46.427  1.00 23.47           N  
ATOM    338  CA  ASN A  42       5.705  -8.373  47.354  1.00 23.47           C  
ATOM    339  C   ASN A  42       4.718  -9.513  47.452  1.00 23.53           C  
ATOM    340  O   ASN A  42       4.266 -10.064  46.430  1.00 23.80           O  
ATOM    341  CB  ASN A  42       5.014  -7.050  46.988  1.00 23.81           C  
ATOM    342  CG  ASN A  42       5.903  -5.839  47.249  1.00 24.50           C  
ATOM    343  OD1 ASN A  42       6.898  -5.936  47.970  1.00 25.77           O  
ATOM    344  ND2 ASN A  42       5.541  -4.687  46.672  1.00 23.13           N  
ATOM    345  N   LEU A  43       4.377  -9.841  48.696  1.00 22.93           N  
ATOM    346  CA  LEU A  43       3.608 -11.029  49.016  1.00 22.50           C  
ATOM    347  C   LEU A  43       2.348 -10.689  49.810  1.00 22.56           C  
ATOM    348  O   LEU A  43       2.339  -9.708  50.574  1.00 22.04           O  
ATOM    349  CB  LEU A  43       4.472 -12.016  49.822  1.00 22.47           C  
ATOM    350  CG  LEU A  43       5.786 -12.511  49.202  1.00 22.69           C  
ATOM    351  CD1 LEU A  43       6.442 -13.518  50.111  1.00 23.34           C  
ATOM    352  CD2 LEU A  43       5.528 -13.157  47.867  1.00 26.24           C  
ATOM    353  N   LYS A  44       1.297 -11.504  49.623  1.00 21.89           N  
ATOM    354  CA  LYS A  44       0.109 -11.458  50.462  1.00 21.92           C  
ATOM    355  C   LYS A  44      -0.224 -12.833  51.049  1.00 22.59           C  
ATOM    356  O   LYS A  44       0.152 -13.888  50.491  1.00 22.13           O  
ATOM    357  CB  LYS A  44      -1.089 -10.909  49.677  1.00 22.06           C  
ATOM    358  CG  LYS A  44      -1.728 -11.864  48.626  1.00 21.95           C  
ATOM    359  CD  LYS A  44      -3.058 -11.263  48.072  1.00 21.61           C  
ATOM    360  CE  LYS A  44      -3.649 -12.065  46.920  1.00 20.94           C  
ATOM    361  NZ  LYS A  44      -2.670 -12.081  45.785  1.00 23.42           N  
ATOM    362  N   LEU A  45      -0.918 -12.826  52.188  1.00 23.26           N  
ATOM    363  CA  LEU A  45      -1.422 -14.075  52.760  1.00 23.70           C  
ATOM    364  C   LEU A  45      -2.915 -13.974  52.797  1.00 23.66           C  
ATOM    365  O   LEU A  45      -3.454 -13.036  53.336  1.00 23.22           O  
ATOM    366  CB  LEU A  45      -0.850 -14.382  54.151  1.00 23.47           C  
ATOM    367  CG  LEU A  45      -1.151 -15.750  54.777  1.00 23.32           C  
ATOM    368  CD1 LEU A  45      -0.078 -16.072  55.816  1.00 26.21           C  
ATOM    369  CD2 LEU A  45      -2.541 -15.796  55.415  1.00 22.78           C  
ATOM    370  N   THR A  46      -3.555 -14.963  52.201  1.00 24.83           N  
ATOM    371  CA  THR A  46      -4.988 -14.987  52.063  1.00 26.99           C  
ATOM    372  C   THR A  46      -5.512 -16.073  52.979  1.00 27.94           C  
ATOM    373  O   THR A  46      -5.089 -17.228  52.896  1.00 28.50           O  
ATOM    374  CB  THR A  46      -5.398 -15.243  50.578  1.00 27.08           C  
ATOM    375  OG1 THR A  46      -4.783 -14.247  49.747  1.00 28.10           O  
ATOM    376  CG2 THR A  46      -6.917 -15.185  50.386  1.00 25.82           C  
ATOM    377  N   ALA A  47      -6.407 -15.690  53.870  1.00 28.86           N  
ATOM    378  CA  ALA A  47      -7.087 -16.666  54.694  1.00 30.36           C  
ATOM    379  C   ALA A  47      -8.518 -16.811  54.211  1.00 31.25           C  
ATOM    380  O   ALA A  47      -9.360 -15.942  54.446  1.00 30.85           O  
ATOM    381  CB  ALA A  47      -7.037 -16.249  56.147  1.00 30.25           C  
ATOM    382  N   ASP A  48      -8.777 -17.908  53.511  1.00 32.97           N  
ATOM    383  CA  ASP A  48     -10.090 -18.172  52.913  1.00 34.79           C  
ATOM    384  C   ASP A  48     -10.450 -17.074  51.951  1.00 35.27           C  
ATOM    385  O   ASP A  48      -9.827 -16.927  50.913  1.00 35.91           O  
ATOM    386  CB  ASP A  48     -11.180 -18.262  53.979  1.00 35.16           C  
ATOM    387  CG  ASP A  48     -10.826 -19.223  55.074  1.00 37.51           C  
ATOM    388  OD1 ASP A  48     -10.734 -20.448  54.786  1.00 38.40           O  
ATOM    389  OD2 ASP A  48     -10.620 -18.736  56.215  1.00 39.48           O  
ATOM    390  N   ASP A  49     -11.459 -16.297  52.318  1.00 35.89           N  
ATOM    391  CA  ASP A  49     -11.877 -15.155  51.530  1.00 36.54           C  
ATOM    392  C   ASP A  49     -10.901 -14.028  51.598  1.00 36.26           C  
ATOM    393  O   ASP A  49     -10.488 -13.509  50.576  1.00 37.37           O  
ATOM    394  CB  ASP A  49     -13.220 -14.625  52.019  1.00 36.76           C  
ATOM    395  CG  ASP A  49     -14.332 -15.494  51.600  1.00 38.00           C  
ATOM    396  OD1 ASP A  49     -14.012 -16.557  51.020  1.00 39.08           O  
ATOM    397  OD2 ASP A  49     -15.508 -15.137  51.843  1.00 41.54           O  
ATOM    398  N   ARG A  50     -10.537 -13.642  52.807  1.00 35.41           N  
ATOM    399  CA  ARG A  50      -9.966 -12.341  52.985  1.00 34.57           C  
ATOM    400  C   ARG A  50      -8.474 -12.326  52.825  1.00 33.17           C  
ATOM    401  O   ARG A  50      -7.786 -13.302  53.118  1.00 33.32           O  
ATOM    402  CB  ARG A  50     -10.398 -11.763  54.327  1.00 34.91           C  
ATOM    403  CG  ARG A  50     -11.836 -11.268  54.299  1.00 37.57           C  
ATOM    404  CD  ARG A  50     -12.224 -10.555  55.597  1.00 41.34           C  
ATOM    405  NE  ARG A  50     -11.224  -9.576  56.041  1.00 41.61           N  
ATOM    406  CZ  ARG A  50     -11.281  -8.940  57.209  1.00 43.07           C  
ATOM    407  NH1 ARG A  50     -12.289  -9.184  58.039  1.00 44.28           N  
ATOM    408  NH2 ARG A  50     -10.343  -8.063  57.557  1.00 42.29           N  
ATOM    409  N   MET A  51      -7.973 -11.210  52.329  1.00 31.58           N  
ATOM    410  CA  MET A  51      -6.569 -10.947  52.477  1.00 30.27           C  
ATOM    411  C   MET A  51      -6.338 -10.674  53.956  1.00 29.06           C  
ATOM    412  O   MET A  51      -7.031  -9.885  54.544  1.00 28.04           O  
ATOM    413  CB  MET A  51      -6.126  -9.760  51.641  1.00 29.79           C  
ATOM    414  CG  MET A  51      -4.646  -9.468  51.877  1.00 31.26           C  
ATOM    415  SD  MET A  51      -4.168  -7.812  51.399  1.00 30.57           S  
ATOM    416  CE  MET A  51      -4.285  -8.035  49.606  1.00 30.55           C  
ATOM    417  N   ALA A  52      -5.369 -11.352  54.550  1.00 28.60           N  
ATOM    418  CA  ALA A  52      -5.116 -11.202  55.975  1.00 28.38           C  
ATOM    419  C   ALA A  52      -3.817 -10.464  56.254  1.00 28.26           C  
ATOM    420  O   ALA A  52      -3.685  -9.853  57.302  1.00 28.51           O  
ATOM    421  CB  ALA A  52      -5.117 -12.548  56.659  1.00 28.31           C  
ATOM    422  N   ALA A  53      -2.866 -10.510  55.322  1.00 27.94           N  
ATOM    423  CA  ALA A  53      -1.570  -9.861  55.523  1.00 27.69           C  
ATOM    424  C   ALA A  53      -0.819  -9.562  54.245  1.00 27.55           C  
ATOM    425  O   ALA A  53      -1.085 -10.139  53.188  1.00 27.66           O  
ATOM    426  CB  ALA A  53      -0.674 -10.709  56.440  1.00 27.98           C  
ATOM    427  N   PHE A  54       0.176  -8.697  54.361  1.00 26.74           N  
ATOM    428  CA  PHE A  54       1.027  -8.427  53.228  1.00 26.16           C  
ATOM    429  C   PHE A  54       2.429  -8.051  53.705  1.00 25.91           C  
ATOM    430  O   PHE A  54       2.627  -7.690  54.864  1.00 26.04           O  
ATOM    431  CB  PHE A  54       0.410  -7.319  52.377  1.00 25.93           C  
ATOM    432  CG  PHE A  54       0.563  -5.950  52.976  1.00 25.58           C  
ATOM    433  CD1 PHE A  54       1.725  -5.214  52.766  1.00 25.98           C  
ATOM    434  CD2 PHE A  54      -0.437  -5.408  53.766  1.00 25.19           C  
ATOM    435  CE1 PHE A  54       1.881  -3.940  53.309  1.00 26.33           C  
ATOM    436  CE2 PHE A  54      -0.288  -4.156  54.339  1.00 26.51           C  
ATOM    437  CZ  PHE A  54       0.866  -3.403  54.101  1.00 26.42           C  
ATOM    438  N   ALA A  55       3.397  -8.127  52.798  1.00 25.81           N  
ATOM    439  CA  ALA A  55       4.785  -7.805  53.097  1.00 25.45           C  
ATOM    440  C   ALA A  55       5.354  -7.215  51.847  1.00 26.16           C  
ATOM    441  O   ALA A  55       5.141  -7.777  50.744  1.00 26.15           O  
ATOM    442  CB  ALA A  55       5.558  -9.044  53.454  1.00 24.95           C  
ATOM    443  N   ILE A  56       6.057  -6.092  52.023  1.00 26.02           N  
ATOM    444  CA  ILE A  56       6.756  -5.401  50.951  1.00 26.80           C  
ATOM    445  C   ILE A  56       8.271  -5.585  51.096  1.00 27.60           C  
ATOM    446  O   ILE A  56       8.873  -5.131  52.102  1.00 27.50           O  
ATOM    447  CB  ILE A  56       6.476  -3.859  50.934  1.00 27.09           C  
ATOM    448  CG1 ILE A  56       4.978  -3.552  50.776  1.00 27.10           C  
ATOM    449  CG2 ILE A  56       7.315  -3.152  49.859  1.00 24.89           C  
ATOM    450  CD1 ILE A  56       4.291  -4.394  49.804  1.00 28.28           C  
ATOM    451  N   THR A  57       8.887  -6.199  50.079  1.00 27.12           N  
ATOM    452  CA  THR A  57      10.327  -6.425  50.108  1.00 26.68           C  
ATOM    453  C   THR A  57      11.008  -5.986  48.822  1.00 26.52           C  
ATOM    454  O   THR A  57      10.520  -6.226  47.725  1.00 25.52           O  
ATOM    455  CB  THR A  57      10.657  -7.914  50.393  1.00 26.72           C  
ATOM    456  OG1 THR A  57      10.019  -8.316  51.608  1.00 26.59           O  
ATOM    457  CG2 THR A  57      12.150  -8.160  50.492  1.00 24.09           C  
ATOM    458  N   GLN A  58      12.176  -5.384  48.982  1.00 26.67           N  
ATOM    459  CA  GLN A  58      13.015  -5.074  47.848  1.00 26.71           C  
ATOM    460  C   GLN A  58      14.347  -5.820  47.872  1.00 26.32           C  
ATOM    461  O   GLN A  58      15.032  -5.856  48.896  1.00 26.15           O  
ATOM    462  CB  GLN A  58      13.260  -3.585  47.769  1.00 26.79           C  
ATOM    463  CG  GLN A  58      13.895  -3.174  46.455  1.00 29.73           C  
ATOM    464  CD  GLN A  58      14.083  -1.679  46.358  1.00 31.94           C  
ATOM    465  OE1 GLN A  58      14.994  -1.108  46.980  1.00 29.66           O  
ATOM    466  NE2 GLN A  58      13.198  -1.024  45.588  1.00 32.26           N  
ATOM    467  N   VAL A  59      14.705  -6.382  46.714  1.00 26.16           N  
ATOM    468  CA  VAL A  59      15.911  -7.158  46.528  1.00 25.39           C  
ATOM    469  C   VAL A  59      16.903  -6.405  45.665  1.00 26.23           C  
ATOM    470  O   VAL A  59      16.605  -6.077  44.501  1.00 26.66           O  
ATOM    471  CB  VAL A  59      15.575  -8.474  45.848  1.00 25.62           C  
ATOM    472  CG1 VAL A  59      16.843  -9.285  45.529  1.00 23.25           C  
ATOM    473  CG2 VAL A  59      14.558  -9.272  46.710  1.00 25.71           C  
ATOM    474  N   VAL A  60      18.076  -6.129  46.246  1.00 26.40           N  
ATOM    475  CA  VAL A  60      19.202  -5.556  45.533  1.00 26.70           C  
ATOM    476  C   VAL A  60      20.392  -6.474  45.758  1.00 27.15           C  
ATOM    477  O   VAL A  60      20.773  -6.742  46.889  1.00 28.39           O  
ATOM    478  CB  VAL A  60      19.568  -4.082  45.999  1.00 26.89           C  
ATOM    479  CG1 VAL A  60      20.813  -3.545  45.253  1.00 24.45           C  
ATOM    480  CG2 VAL A  60      18.421  -3.111  45.779  1.00 26.82           C  
ATOM    481  N   LEU A  61      21.008  -6.923  44.674  1.00 27.34           N  
ATOM    482  CA  LEU A  61      22.133  -7.836  44.752  1.00 26.57           C  
ATOM    483  C   LEU A  61      21.727  -9.096  45.515  1.00 26.98           C  
ATOM    484  O   LEU A  61      20.867  -9.805  45.085  1.00 27.34           O  
ATOM    485  CB  LEU A  61      23.365  -7.157  45.360  1.00 25.52           C  
ATOM    486  CG  LEU A  61      23.906  -6.009  44.494  1.00 24.06           C  
ATOM    487  CD1 LEU A  61      25.050  -5.236  45.267  1.00 16.03           C  
ATOM    488  CD2 LEU A  61      24.278  -6.450  43.037  1.00 13.78           C  
ATOM    489  N   ASP A  62      22.336  -9.363  46.654  1.00 27.46           N  
ATOM    490  CA  ASP A  62      22.062 -10.592  47.362  1.00 27.63           C  
ATOM    491  C   ASP A  62      21.621 -10.236  48.780  1.00 28.69           C  
ATOM    492  O   ASP A  62      21.746 -11.051  49.703  1.00 28.95           O  
ATOM    493  CB  ASP A  62      23.300 -11.500  47.382  1.00 26.82           C  
ATOM    494  CG  ASP A  62      24.536 -10.806  47.970  1.00 25.88           C  
ATOM    495  OD1 ASP A  62      24.458  -9.619  48.341  1.00 26.24           O  
ATOM    496  OD2 ASP A  62      25.590 -11.442  48.047  1.00 23.19           O  
ATOM    497  N   GLU A  63      21.131  -9.007  48.937  1.00 28.88           N  
ATOM    498  CA  GLU A  63      20.498  -8.583  50.172  1.00 29.35           C  
ATOM    499  C   GLU A  63      19.066  -8.116  49.898  1.00 28.77           C  
ATOM    500  O   GLU A  63      18.728  -7.773  48.776  1.00 28.15           O  
ATOM    501  CB  GLU A  63      21.337  -7.494  50.847  1.00 29.34           C  
ATOM    502  CG  GLU A  63      22.692  -8.036  51.249  1.00 31.53           C  
ATOM    503  CD  GLU A  63      23.541  -7.052  52.025  1.00 33.69           C  
ATOM    504  OE1 GLU A  63      23.248  -6.758  53.204  1.00 32.77           O  
ATOM    505  OE2 GLU A  63      24.532  -6.582  51.447  1.00 36.15           O  
ATOM    506  N   ALA A  64      18.232  -8.108  50.930  1.00 28.29           N  
ATOM    507  CA  ALA A  64      16.871  -7.664  50.783  1.00 28.23           C  
ATOM    508  C   ALA A  64      16.498  -6.798  51.956  1.00 28.33           C  
ATOM    509  O   ALA A  64      17.018  -6.977  53.059  1.00 28.26           O  
ATOM    510  CB  ALA A  64      15.930  -8.857  50.688  1.00 28.09           C  
ATOM    511  N   THR A  65      15.578  -5.866  51.725  1.00 28.10           N  
ATOM    512  CA  THR A  65      15.001  -5.124  52.824  1.00 27.88           C  
ATOM    513  C   THR A  65      13.497  -5.314  52.874  1.00 27.49           C  
ATOM    514  O   THR A  65      12.789  -5.089  51.887  1.00 27.31           O  
ATOM    515  CB  THR A  65      15.416  -3.654  52.780  1.00 28.19           C  
ATOM    516  OG1 THR A  65      16.862  -3.577  52.702  1.00 29.65           O  
ATOM    517  CG2 THR A  65      14.956  -2.945  54.057  1.00 28.04           C  
ATOM    518  N   LEU A  66      13.021  -5.804  54.007  1.00 27.03           N  
ATOM    519  CA  LEU A  66      11.591  -5.861  54.246  1.00 26.84           C  
ATOM    520  C   LEU A  66      11.177  -4.487  54.716  1.00 26.40           C  
ATOM    521  O   LEU A  66      11.330  -4.167  55.877  1.00 26.82           O  
ATOM    522  CB  LEU A  66      11.234  -6.913  55.294  1.00 26.95           C  
ATOM    523  CG  LEU A  66       9.777  -6.962  55.787  1.00 28.38           C  
ATOM    524  CD1 LEU A  66       8.832  -7.704  54.824  1.00 27.13           C  
ATOM    525  CD2 LEU A  66       9.712  -7.598  57.176  1.00 27.07           C  
ATOM    526  N   PHE A  67      10.677  -3.675  53.789  1.00 26.10           N  
ATOM    527  CA  PHE A  67      10.133  -2.352  54.070  1.00 25.14           C  
ATOM    528  C   PHE A  67       8.876  -2.331  54.937  1.00 24.66           C  
ATOM    529  O   PHE A  67       8.597  -1.323  55.552  1.00 25.78           O  
ATOM    530  CB  PHE A  67       9.768  -1.644  52.766  1.00 25.05           C  
ATOM    531  CG  PHE A  67      10.928  -1.277  51.909  1.00 25.86           C  
ATOM    532  CD1 PHE A  67      12.206  -1.158  52.423  1.00 28.06           C  
ATOM    533  CD2 PHE A  67      10.723  -0.966  50.574  1.00 26.74           C  
ATOM    534  CE1 PHE A  67      13.272  -0.773  51.587  1.00 28.18           C  
ATOM    535  CE2 PHE A  67      11.771  -0.565  49.757  1.00 25.22           C  
ATOM    536  CZ  PHE A  67      13.035  -0.480  50.252  1.00 25.00           C  
ATOM    537  N   ASN A  68       8.091  -3.403  54.958  1.00 24.23           N  
ATOM    538  CA  ASN A  68       6.790  -3.383  55.619  1.00 23.62           C  
ATOM    539  C   ASN A  68       6.224  -4.781  55.748  1.00 23.53           C  
ATOM    540  O   ASN A  68       6.165  -5.517  54.767  1.00 24.03           O  
ATOM    541  CB  ASN A  68       5.799  -2.527  54.790  1.00 23.90           C  
ATOM    542  CG  ASN A  68       4.522  -2.097  55.572  1.00 23.21           C  
ATOM    543  OD1 ASN A  68       4.242  -2.557  56.684  1.00 25.20           O  
ATOM    544  ND2 ASN A  68       3.763  -1.184  54.979  1.00 21.51           N  
ATOM    545  N   ILE A  69       5.777  -5.144  56.945  1.00 23.39           N  
ATOM    546  CA  ILE A  69       4.898  -6.298  57.099  1.00 23.04           C  
ATOM    547  C   ILE A  69       3.679  -5.901  57.950  1.00 24.03           C  
ATOM    548  O   ILE A  69       3.803  -5.144  58.920  1.00 23.96           O  
ATOM    549  CB  ILE A  69       5.654  -7.562  57.629  1.00 23.34           C  
ATOM    550  CG1 ILE A  69       4.753  -8.809  57.537  1.00 21.89           C  
ATOM    551  CG2 ILE A  69       6.283  -7.339  59.045  1.00 21.46           C  
ATOM    552  CD1 ILE A  69       5.435 -10.087  57.955  1.00 21.55           C  
ATOM    553  N   ALA A  70       2.505  -6.413  57.581  1.00 24.31           N  
ATOM    554  CA  ALA A  70       1.248  -6.050  58.248  1.00 24.23           C  
ATOM    555  C   ALA A  70       0.227  -7.177  58.225  1.00 24.35           C  
ATOM    556  O   ALA A  70      -0.161  -7.661  57.155  1.00 24.64           O  
ATOM    557  CB  ALA A  70       0.644  -4.809  57.607  1.00 24.18           C  
ATOM    558  N   VAL A  71      -0.209  -7.579  59.408  1.00 24.11           N  
ATOM    559  CA  VAL A  71      -1.284  -8.515  59.541  1.00 24.34           C  
ATOM    560  C   VAL A  71      -2.435  -7.663  60.036  1.00 24.92           C  
ATOM    561  O   VAL A  71      -2.265  -6.862  60.967  1.00 24.74           O  
ATOM    562  CB  VAL A  71      -0.938  -9.604  60.577  1.00 24.88           C  
ATOM    563  CG1 VAL A  71      -2.124 -10.561  60.787  1.00 23.55           C  
ATOM    564  CG2 VAL A  71       0.346 -10.346  60.174  1.00 23.84           C  
ATOM    565  N   ASP A  72      -3.593  -7.812  59.407  1.00 24.65           N  
ATOM    566  CA  ASP A  72      -4.747  -7.030  59.776  1.00 24.76           C  
ATOM    567  C   ASP A  72      -5.121  -7.368  61.209  1.00 25.10           C  
ATOM    568  O   ASP A  72      -4.991  -8.517  61.605  1.00 25.58           O  
ATOM    569  CB  ASP A  72      -5.900  -7.329  58.824  1.00 24.64           C  
ATOM    570  CG  ASP A  72      -7.128  -6.533  59.145  1.00 24.11           C  
ATOM    571  OD1 ASP A  72      -7.886  -6.972  60.010  1.00 26.05           O  
ATOM    572  OD2 ASP A  72      -7.353  -5.473  58.545  1.00 24.16           O  
ATOM    573  N   PRO A  73      -5.564  -6.370  62.001  1.00 25.46           N  
ATOM    574  CA  PRO A  73      -5.937  -6.663  63.388  1.00 26.03           C  
ATOM    575  C   PRO A  73      -6.847  -7.889  63.572  1.00 26.38           C  
ATOM    576  O   PRO A  73      -6.617  -8.687  64.488  1.00 26.75           O  
ATOM    577  CB  PRO A  73      -6.635  -5.372  63.838  1.00 25.94           C  
ATOM    578  CG  PRO A  73      -5.906  -4.323  63.078  1.00 25.03           C  
ATOM    579  CD  PRO A  73      -5.718  -4.928  61.710  1.00 25.30           C  
ATOM    580  N   ASP A  74      -7.859  -8.039  62.716  1.00 26.24           N  
ATOM    581  CA  ASP A  74      -8.736  -9.214  62.743  1.00 25.84           C  
ATOM    582  C   ASP A  74      -7.986 -10.547  62.669  1.00 25.91           C  
ATOM    583  O   ASP A  74      -8.488 -11.563  63.133  1.00 25.64           O  
ATOM    584  CB  ASP A  74      -9.717  -9.149  61.580  1.00 25.87           C  
ATOM    585  CG  ASP A  74     -10.892  -8.216  61.843  1.00 26.82           C  
ATOM    586  OD1 ASP A  74     -10.867  -7.409  62.812  1.00 25.08           O  
ATOM    587  OD2 ASP A  74     -11.864  -8.316  61.060  1.00 27.49           O  
ATOM    588  N   PHE A  75      -6.786 -10.532  62.086  1.00 25.93           N  
ATOM    589  CA  PHE A  75      -6.042 -11.750  61.847  1.00 26.33           C  
ATOM    590  C   PHE A  75      -4.793 -11.973  62.708  1.00 26.55           C  
ATOM    591  O   PHE A  75      -4.110 -12.983  62.552  1.00 26.61           O  
ATOM    592  CB  PHE A  75      -5.729 -11.882  60.359  1.00 26.45           C  
ATOM    593  CG  PHE A  75      -6.899 -12.349  59.557  1.00 27.58           C  
ATOM    594  CD1 PHE A  75      -7.249 -13.692  59.541  1.00 28.09           C  
ATOM    595  CD2 PHE A  75      -7.675 -11.446  58.843  1.00 28.93           C  
ATOM    596  CE1 PHE A  75      -8.355 -14.141  58.812  1.00 28.55           C  
ATOM    597  CE2 PHE A  75      -8.785 -11.878  58.105  1.00 28.96           C  
ATOM    598  CZ  PHE A  75      -9.123 -13.226  58.087  1.00 28.47           C  
ATOM    599  N   GLN A  76      -4.507 -11.058  63.628  1.00 26.85           N  
ATOM    600  CA  GLN A  76      -3.271 -11.138  64.415  1.00 27.24           C  
ATOM    601  C   GLN A  76      -3.195 -12.245  65.466  1.00 28.01           C  
ATOM    602  O   GLN A  76      -4.177 -12.893  65.802  1.00 27.77           O  
ATOM    603  CB  GLN A  76      -2.942  -9.788  65.038  1.00 26.97           C  
ATOM    604  CG  GLN A  76      -2.284  -8.813  64.058  1.00 26.57           C  
ATOM    605  CD  GLN A  76      -2.382  -7.380  64.529  1.00 25.31           C  
ATOM    606  OE1 GLN A  76      -2.666  -7.116  65.691  1.00 27.20           O  
ATOM    607  NE2 GLN A  76      -2.140  -6.452  63.640  1.00 23.26           N  
ATOM    608  N   ARG A  77      -1.992 -12.445  65.977  1.00 29.47           N  
ATOM    609  CA  ARG A  77      -1.695 -13.483  66.954  1.00 31.70           C  
ATOM    610  C   ARG A  77      -2.320 -14.818  66.599  1.00 31.77           C  
ATOM    611  O   ARG A  77      -2.726 -15.561  67.480  1.00 31.99           O  
ATOM    612  CB  ARG A  77      -2.095 -13.051  68.371  1.00 31.71           C  
ATOM    613  CG  ARG A  77      -1.108 -12.061  69.028  1.00 33.80           C  
ATOM    614  CD  ARG A  77      -1.767 -11.280  70.185  1.00 33.74           C  
ATOM    615  NE  ARG A  77      -3.157 -10.985  69.826  1.00 37.96           N  
ATOM    616  CZ  ARG A  77      -4.147 -10.779  70.686  1.00 39.19           C  
ATOM    617  NH1 ARG A  77      -3.921 -10.811  72.002  1.00 40.10           N  
ATOM    618  NH2 ARG A  77      -5.369 -10.541  70.214  1.00 39.49           N  
ATOM    619  N   ARG A  78      -2.388 -15.128  65.309  1.00 32.32           N  
ATOM    620  CA  ARG A  78      -2.850 -16.450  64.875  1.00 32.23           C  
ATOM    621  C   ARG A  78      -1.760 -17.180  64.072  1.00 31.65           C  
ATOM    622  O   ARG A  78      -2.039 -18.194  63.431  1.00 31.31           O  
ATOM    623  CB  ARG A  78      -4.161 -16.353  64.071  1.00 32.95           C  
ATOM    624  CG  ARG A  78      -5.370 -15.746  64.816  1.00 34.80           C  
ATOM    625  CD  ARG A  78      -6.650 -16.449  64.390  1.00 40.14           C  
ATOM    626  NE  ARG A  78      -7.742 -15.554  63.985  1.00 44.03           N  
ATOM    627  CZ  ARG A  78      -8.660 -15.860  63.053  1.00 45.76           C  
ATOM    628  NH1 ARG A  78      -8.604 -17.032  62.411  1.00 45.19           N  
ATOM    629  NH2 ARG A  78      -9.629 -14.991  62.745  1.00 45.28           N  
ATOM    630  N   GLY A  79      -0.524 -16.663  64.114  1.00 30.67           N  
ATOM    631  CA  GLY A  79       0.619 -17.293  63.443  1.00 29.67           C  
ATOM    632  C   GLY A  79       0.780 -17.004  61.955  1.00 29.47           C  
ATOM    633  O   GLY A  79       1.583 -17.657  61.272  1.00 29.73           O  
ATOM    634  N   LEU A  80       0.022 -16.038  61.444  1.00 28.71           N  
ATOM    635  CA  LEU A  80       0.041 -15.725  60.022  1.00 28.22           C  
ATOM    636  C   LEU A  80       1.222 -14.847  59.693  1.00 28.11           C  
ATOM    637  O   LEU A  80       1.830 -15.002  58.637  1.00 28.64           O  
ATOM    638  CB  LEU A  80      -1.275 -15.085  59.582  1.00 27.79           C  
ATOM    639  CG  LEU A  80      -2.454 -16.021  59.862  1.00 28.63           C  
ATOM    640  CD1 LEU A  80      -3.761 -15.382  59.441  1.00 29.27           C  
ATOM    641  CD2 LEU A  80      -2.284 -17.412  59.199  1.00 26.20           C  
ATOM    642  N   GLY A  81       1.560 -13.951  60.614  1.00 27.41           N  
ATOM    643  CA  GLY A  81       2.732 -13.120  60.470  1.00 27.21           C  
ATOM    644  C   GLY A  81       3.975 -13.937  60.248  1.00 27.32           C  
ATOM    645  O   GLY A  81       4.662 -13.741  59.264  1.00 26.97           O  
ATOM    646  N   ARG A  82       4.235 -14.873  61.159  1.00 27.97           N  
ATOM    647  CA  ARG A  82       5.372 -15.767  61.069  1.00 28.28           C  
ATOM    648  C   ARG A  82       5.313 -16.572  59.796  1.00 28.42           C  
ATOM    649  O   ARG A  82       6.311 -16.706  59.089  1.00 29.62           O  
ATOM    650  CB  ARG A  82       5.383 -16.723  62.243  1.00 28.05           C  
ATOM    651  CG  ARG A  82       6.191 -17.994  62.011  1.00 28.61           C  
ATOM    652  CD  ARG A  82       6.216 -18.892  63.259  1.00 29.70           C  
ATOM    653  NE  ARG A  82       7.402 -18.589  64.067  1.00 34.51           N  
ATOM    654  CZ  ARG A  82       7.375 -17.933  65.224  1.00 34.50           C  
ATOM    655  NH1 ARG A  82       6.220 -17.533  65.744  1.00 35.74           N  
ATOM    656  NH2 ARG A  82       8.504 -17.684  65.864  1.00 33.46           N  
ATOM    657  N   MET A  83       4.147 -17.102  59.490  1.00 27.73           N  
ATOM    658  CA  MET A  83       4.041 -17.941  58.328  1.00 28.13           C  
ATOM    659  C   MET A  83       4.438 -17.159  57.071  1.00 28.16           C  
ATOM    660  O   MET A  83       5.185 -17.667  56.241  1.00 28.51           O  
ATOM    661  CB  MET A  83       2.627 -18.505  58.209  1.00 27.59           C  
ATOM    662  CG  MET A  83       2.442 -19.377  57.009  1.00 27.59           C  
ATOM    663  SD  MET A  83       0.721 -19.771  56.654  1.00 29.14           S  
ATOM    664  CE  MET A  83       0.197 -20.658  58.133  1.00 26.58           C  
ATOM    665  N   LEU A  84       3.931 -15.937  56.934  1.00 27.82           N  
ATOM    666  CA  LEU A  84       4.207 -15.132  55.761  1.00 28.28           C  
ATOM    667  C   LEU A  84       5.694 -14.850  55.688  1.00 28.74           C  
ATOM    668  O   LEU A  84       6.296 -14.943  54.611  1.00 28.38           O  
ATOM    669  CB  LEU A  84       3.417 -13.810  55.790  1.00 28.47           C  
ATOM    670  CG  LEU A  84       3.707 -12.741  54.733  1.00 27.71           C  
ATOM    671  CD1 LEU A  84       3.539 -13.328  53.350  1.00 27.56           C  
ATOM    672  CD2 LEU A  84       2.795 -11.525  54.907  1.00 27.83           C  
ATOM    673  N   LEU A  85       6.263 -14.489  56.842  1.00 29.00           N  
ATOM    674  CA  LEU A  85       7.680 -14.217  56.957  1.00 29.59           C  
ATOM    675  C   LEU A  85       8.489 -15.415  56.553  1.00 29.87           C  
ATOM    676  O   LEU A  85       9.465 -15.261  55.826  1.00 30.25           O  
ATOM    677  CB  LEU A  85       8.067 -13.776  58.367  1.00 29.98           C  
ATOM    678  CG  LEU A  85       8.448 -12.292  58.434  1.00 31.09           C  
ATOM    679  CD1 LEU A  85       8.446 -11.769  59.824  1.00 30.86           C  
ATOM    680  CD2 LEU A  85       9.819 -12.111  57.822  1.00 33.70           C  
ATOM    681  N   GLU A  86       8.073 -16.604  56.999  1.00 29.70           N  
ATOM    682  CA  GLU A  86       8.747 -17.857  56.635  1.00 29.64           C  
ATOM    683  C   GLU A  86       8.688 -18.119  55.123  1.00 29.61           C  
ATOM    684  O   GLU A  86       9.702 -18.513  54.517  1.00 30.03           O  
ATOM    685  CB  GLU A  86       8.223 -19.051  57.451  1.00 29.26           C  
ATOM    686  CG  GLU A  86       8.777 -19.103  58.889  1.00 29.62           C  
ATOM    687  CD  GLU A  86       8.061 -20.112  59.821  1.00 31.00           C  
ATOM    688  OE1 GLU A  86       7.026 -20.711  59.433  1.00 32.25           O  
ATOM    689  OE2 GLU A  86       8.530 -20.296  60.973  1.00 31.90           O  
ATOM    690  N   HIS A  87       7.538 -17.867  54.499  1.00 28.40           N  
ATOM    691  CA  HIS A  87       7.472 -18.069  53.073  1.00 28.15           C  
ATOM    692  C   HIS A  87       8.456 -17.129  52.336  1.00 28.16           C  
ATOM    693  O   HIS A  87       9.106 -17.507  51.338  1.00 28.21           O  
ATOM    694  CB  HIS A  87       6.036 -17.971  52.582  1.00 28.11           C  
ATOM    695  CG  HIS A  87       5.261 -19.249  52.749  1.00 29.78           C  
ATOM    696  ND1 HIS A  87       5.029 -19.828  53.981  1.00 29.78           N  
ATOM    697  CD2 HIS A  87       4.672 -20.065  51.843  1.00 29.63           C  
ATOM    698  CE1 HIS A  87       4.337 -20.944  53.827  1.00 27.86           C  
ATOM    699  NE2 HIS A  87       4.106 -21.111  52.540  1.00 28.34           N  
ATOM    700  N   LEU A  88       8.601 -15.919  52.864  1.00 27.43           N  
ATOM    701  CA  LEU A  88       9.409 -14.912  52.217  1.00 26.72           C  
ATOM    702  C   LEU A  88      10.879 -15.343  52.299  1.00 27.19           C  
ATOM    703  O   LEU A  88      11.637 -15.287  51.300  1.00 26.39           O  
ATOM    704  CB  LEU A  88       9.204 -13.558  52.898  1.00 26.08           C  
ATOM    705  CG  LEU A  88      10.209 -12.459  52.558  1.00 23.29           C  
ATOM    706  CD1 LEU A  88      10.248 -12.146  51.049  1.00 19.39           C  
ATOM    707  CD2 LEU A  88       9.876 -11.241  53.342  1.00 19.45           C  
ATOM    708  N   ILE A  89      11.266 -15.785  53.493  1.00 26.90           N  
ATOM    709  CA  ILE A  89      12.631 -16.225  53.717  1.00 26.75           C  
ATOM    710  C   ILE A  89      13.014 -17.356  52.766  1.00 26.82           C  
ATOM    711  O   ILE A  89      14.043 -17.264  52.127  1.00 25.97           O  
ATOM    712  CB  ILE A  89      12.900 -16.523  55.205  1.00 26.59           C  
ATOM    713  CG1 ILE A  89      12.837 -15.224  56.000  1.00 24.97           C  
ATOM    714  CG2 ILE A  89      14.248 -17.149  55.383  1.00 26.38           C  
ATOM    715  CD1 ILE A  89      12.414 -15.418  57.426  1.00 23.87           C  
ATOM    716  N   ASP A  90      12.156 -18.376  52.625  1.00 28.36           N  
ATOM    717  CA  ASP A  90      12.377 -19.486  51.665  1.00 29.73           C  
ATOM    718  C   ASP A  90      12.532 -18.933  50.279  1.00 29.58           C  
ATOM    719  O   ASP A  90      13.407 -19.353  49.530  1.00 29.88           O  
ATOM    720  CB  ASP A  90      11.200 -20.479  51.597  1.00 30.74           C  
ATOM    721  CG  ASP A  90      11.021 -21.293  52.864  1.00 34.69           C  
ATOM    722  OD1 ASP A  90      11.997 -21.402  53.673  1.00 38.29           O  
ATOM    723  OD2 ASP A  90       9.885 -21.823  53.054  1.00 37.37           O  
ATOM    724  N   GLU A  91      11.656 -17.997  49.933  1.00 29.38           N  
ATOM    725  CA  GLU A  91      11.680 -17.426  48.606  1.00 29.89           C  
ATOM    726  C   GLU A  91      12.982 -16.629  48.351  1.00 29.79           C  
ATOM    727  O   GLU A  91      13.614 -16.787  47.300  1.00 30.38           O  
ATOM    728  CB  GLU A  91      10.417 -16.601  48.358  1.00 29.72           C  
ATOM    729  CG  GLU A  91      10.443 -15.845  47.057  1.00 32.54           C  
ATOM    730  CD  GLU A  91      10.370 -16.740  45.818  1.00 37.21           C  
ATOM    731  OE1 GLU A  91       9.727 -17.837  45.871  1.00 38.05           O  
ATOM    732  OE2 GLU A  91      10.936 -16.314  44.782  1.00 37.18           O  
ATOM    733  N   LEU A  92      13.411 -15.817  49.312  1.00 28.93           N  
ATOM    734  CA  LEU A  92      14.696 -15.120  49.180  1.00 28.15           C  
ATOM    735  C   LEU A  92      15.902 -16.067  49.060  1.00 28.37           C  
ATOM    736  O   LEU A  92      16.851 -15.747  48.342  1.00 28.44           O  
ATOM    737  CB  LEU A  92      14.918 -14.159  50.351  1.00 28.01           C  
ATOM    738  CG  LEU A  92      13.942 -12.981  50.458  1.00 26.50           C  
ATOM    739  CD1 LEU A  92      14.017 -12.372  51.815  1.00 23.55           C  
ATOM    740  CD2 LEU A  92      14.190 -11.975  49.378  1.00 24.93           C  
ATOM    741  N   GLU A  93      15.878 -17.214  49.744  1.00 27.62           N  
ATOM    742  CA  GLU A  93      16.995 -18.170  49.676  1.00 27.44           C  
ATOM    743  C   GLU A  93      17.166 -18.771  48.267  1.00 27.92           C  
ATOM    744  O   GLU A  93      18.309 -18.878  47.748  1.00 27.82           O  
ATOM    745  CB  GLU A  93      16.855 -19.299  50.720  1.00 27.40           C  
ATOM    746  CG  GLU A  93      18.043 -20.276  50.811  1.00 25.99           C  
ATOM    747  CD  GLU A  93      18.151 -21.216  49.642  1.00 27.68           C  
ATOM    748  OE1 GLU A  93      17.104 -21.541  49.064  1.00 30.31           O  
ATOM    749  OE2 GLU A  93      19.279 -21.645  49.291  1.00 29.46           O  
ATOM    750  N   THR A  94      16.051 -19.204  47.675  1.00 27.49           N  
ATOM    751  CA  THR A  94      16.055 -19.633  46.277  1.00 27.76           C  
ATOM    752  C   THR A  94      16.555 -18.499  45.351  1.00 26.55           C  
ATOM    753  O   THR A  94      17.008 -18.751  44.249  1.00 27.03           O  
ATOM    754  CB  THR A  94      14.638 -20.069  45.776  1.00 28.14           C  
ATOM    755  OG1 THR A  94      13.753 -18.951  45.903  1.00 31.64           O  
ATOM    756  CG2 THR A  94      14.059 -21.280  46.575  1.00 27.77           C  
ATOM    757  N   ARG A  95      16.473 -17.256  45.790  1.00 25.33           N  
ATOM    758  CA  ARG A  95      16.883 -16.136  44.941  1.00 24.70           C  
ATOM    759  C   ARG A  95      18.322 -15.689  45.213  1.00 24.64           C  
ATOM    760  O   ARG A  95      18.807 -14.751  44.579  1.00 24.23           O  
ATOM    761  CB  ARG A  95      15.937 -14.948  45.116  1.00 24.80           C  
ATOM    762  CG  ARG A  95      14.659 -15.096  44.357  1.00 24.09           C  
ATOM    763  CD  ARG A  95      13.688 -14.042  44.704  1.00 21.30           C  
ATOM    764  NE  ARG A  95      12.523 -14.175  43.829  1.00 25.68           N  
ATOM    765  CZ  ARG A  95      12.421 -13.697  42.586  1.00 25.41           C  
ATOM    766  NH1 ARG A  95      13.421 -13.028  42.039  1.00 25.10           N  
ATOM    767  NH2 ARG A  95      11.302 -13.898  41.888  1.00 26.44           N  
ATOM    768  N   GLY A  96      18.993 -16.360  46.152  1.00 23.58           N  
ATOM    769  CA  GLY A  96      20.395 -16.113  46.397  1.00 22.81           C  
ATOM    770  C   GLY A  96      20.624 -14.978  47.383  1.00 22.84           C  
ATOM    771  O   GLY A  96      21.760 -14.477  47.512  1.00 22.07           O  
ATOM    772  N   VAL A  97      19.548 -14.580  48.067  1.00 22.10           N  
ATOM    773  CA  VAL A  97      19.598 -13.504  49.021  1.00 22.29           C  
ATOM    774  C   VAL A  97      20.169 -14.087  50.322  1.00 22.61           C  
ATOM    775  O   VAL A  97      19.702 -15.139  50.780  1.00 22.56           O  
ATOM    776  CB  VAL A  97      18.211 -12.900  49.261  1.00 22.09           C  
ATOM    777  CG1 VAL A  97      18.263 -11.800  50.320  1.00 23.11           C  
ATOM    778  CG2 VAL A  97      17.633 -12.347  47.988  1.00 21.99           C  
ATOM    779  N   VAL A  98      21.177 -13.408  50.891  1.00 21.86           N  
ATOM    780  CA  VAL A  98      21.898 -13.918  52.054  1.00 21.95           C  
ATOM    781  C   VAL A  98      21.622 -13.148  53.329  1.00 22.60           C  
ATOM    782  O   VAL A  98      21.955 -13.620  54.438  1.00 23.45           O  
ATOM    783  CB  VAL A  98      23.415 -13.987  51.833  1.00 21.49           C  
ATOM    784  CG1 VAL A  98      23.712 -14.691  50.520  1.00 21.06           C  
ATOM    785  CG2 VAL A  98      24.063 -12.580  51.900  1.00 20.70           C  
ATOM    786  N   THR A  99      21.013 -11.979  53.187  1.00 22.04           N  
ATOM    787  CA  THR A  99      20.725 -11.151  54.330  1.00 22.80           C  
ATOM    788  C   THR A  99      19.410 -10.440  54.113  1.00 23.77           C  
ATOM    789  O   THR A  99      19.212  -9.803  53.074  1.00 24.05           O  
ATOM    790  CB  THR A  99      21.855 -10.115  54.578  1.00 22.57           C  
ATOM    791  OG1 THR A  99      23.097 -10.811  54.717  1.00 23.88           O  
ATOM    792  CG2 THR A  99      21.613  -9.319  55.855  1.00 20.70           C  
ATOM    793  N   LEU A 100      18.498 -10.585  55.074  1.00 24.49           N  
ATOM    794  CA  LEU A 100      17.254  -9.803  55.077  1.00 24.65           C  
ATOM    795  C   LEU A 100      17.398  -8.739  56.154  1.00 24.86           C  
ATOM    796  O   LEU A 100      17.806  -9.052  57.287  1.00 25.54           O  
ATOM    797  CB  LEU A 100      16.039 -10.700  55.349  1.00 24.42           C  
ATOM    798  CG  LEU A 100      14.631 -10.099  55.341  1.00 24.17           C  
ATOM    799  CD1 LEU A 100      14.359  -9.371  54.049  1.00 23.86           C  
ATOM    800  CD2 LEU A 100      13.605 -11.209  55.526  1.00 24.18           C  
ATOM    801  N   TRP A 101      17.092  -7.494  55.798  1.00 24.35           N  
ATOM    802  CA  TRP A 101      17.159  -6.382  56.722  1.00 24.34           C  
ATOM    803  C   TRP A 101      15.765  -5.817  56.993  1.00 25.39           C  
ATOM    804  O   TRP A 101      14.838  -5.974  56.151  1.00 25.23           O  
ATOM    805  CB  TRP A 101      18.008  -5.262  56.125  1.00 24.71           C  
ATOM    806  CG  TRP A 101      19.509  -5.552  55.922  1.00 23.91           C  
ATOM    807  CD1 TRP A 101      20.091  -6.124  54.828  1.00 22.37           C  
ATOM    808  CD2 TRP A 101      20.572  -5.203  56.806  1.00 21.86           C  
ATOM    809  NE1 TRP A 101      21.447  -6.165  54.987  1.00 22.88           N  
ATOM    810  CE2 TRP A 101      21.776  -5.613  56.191  1.00 22.87           C  
ATOM    811  CE3 TRP A 101      20.629  -4.573  58.058  1.00 23.16           C  
ATOM    812  CZ2 TRP A 101      23.034  -5.435  56.788  1.00 23.52           C  
ATOM    813  CZ3 TRP A 101      21.898  -4.387  58.665  1.00 23.03           C  
ATOM    814  CH2 TRP A 101      23.075  -4.824  58.024  1.00 22.94           C  
ATOM    815  N   LEU A 102      15.622  -5.122  58.139  1.00 25.73           N  
ATOM    816  CA  LEU A 102      14.357  -4.437  58.499  1.00 25.83           C  
ATOM    817  C   LEU A 102      14.582  -3.408  59.598  1.00 26.32           C  
ATOM    818  O   LEU A 102      15.604  -3.447  60.276  1.00 27.52           O  
ATOM    819  CB  LEU A 102      13.261  -5.443  58.931  1.00 25.42           C  
ATOM    820  CG  LEU A 102      13.323  -6.289  60.213  1.00 25.04           C  
ATOM    821  CD1 LEU A 102      12.962  -5.529  61.476  1.00 26.24           C  
ATOM    822  CD2 LEU A 102      12.391  -7.432  60.088  1.00 25.53           C  
ATOM    823  N   GLU A 103      13.610  -2.507  59.768  1.00 26.36           N  
ATOM    824  CA  GLU A 103      13.549  -1.526  60.853  1.00 25.97           C  
ATOM    825  C   GLU A 103      12.311  -1.812  61.725  1.00 25.49           C  
ATOM    826  O   GLU A 103      11.211  -2.097  61.214  1.00 25.21           O  
ATOM    827  CB  GLU A 103      13.413  -0.092  60.301  1.00 25.95           C  
ATOM    828  CG  GLU A 103      14.572   0.479  59.535  1.00 28.13           C  
ATOM    829  CD  GLU A 103      14.582   0.082  58.057  1.00 34.32           C  
ATOM    830  OE1 GLU A 103      13.488  -0.139  57.447  1.00 35.36           O  
ATOM    831  OE2 GLU A 103      15.699   0.001  57.489  1.00 34.92           O  
ATOM    832  N   VAL A 104      12.459  -1.696  63.038  1.00 24.56           N  
ATOM    833  CA  VAL A 104      11.295  -1.848  63.899  1.00 23.54           C  
ATOM    834  C   VAL A 104      11.286  -0.847  65.062  1.00 23.63           C  
ATOM    835  O   VAL A 104      12.329  -0.507  65.617  1.00 22.83           O  
ATOM    836  CB  VAL A 104      11.097  -3.340  64.340  1.00 23.54           C  
ATOM    837  CG1 VAL A 104      12.324  -3.897  65.047  1.00 21.76           C  
ATOM    838  CG2 VAL A 104       9.852  -3.496  65.174  1.00 23.33           C  
ATOM    839  N   ARG A 105      10.100  -0.328  65.383  1.00 24.03           N  
ATOM    840  CA  ARG A 105       9.938   0.520  66.562  1.00 23.19           C  
ATOM    841  C   ARG A 105      10.510  -0.232  67.733  1.00 23.81           C  
ATOM    842  O   ARG A 105      10.257  -1.421  67.897  1.00 24.52           O  
ATOM    843  CB  ARG A 105       8.475   0.861  66.804  1.00 22.86           C  
ATOM    844  CG  ARG A 105       7.968   1.913  65.855  1.00 22.37           C  
ATOM    845  CD  ARG A 105       6.483   2.297  66.032  1.00 21.76           C  
ATOM    846  NE  ARG A 105       6.146   3.194  64.929  1.00 18.70           N  
ATOM    847  CZ  ARG A 105       6.150   4.524  64.988  1.00 18.99           C  
ATOM    848  NH1 ARG A 105       6.419   5.163  66.135  1.00 18.08           N  
ATOM    849  NH2 ARG A 105       5.881   5.224  63.887  1.00 18.78           N  
ATOM    850  N   ALA A 106      11.307   0.459  68.528  1.00 24.25           N  
ATOM    851  CA  ALA A 106      12.028  -0.157  69.616  1.00 24.59           C  
ATOM    852  C   ALA A 106      11.069  -0.737  70.627  1.00 24.86           C  
ATOM    853  O   ALA A 106      11.430  -1.692  71.292  1.00 25.77           O  
ATOM    854  CB  ALA A 106      12.981   0.856  70.281  1.00 24.82           C  
ATOM    855  N   SER A 107       9.858  -0.181  70.727  1.00 24.68           N  
ATOM    856  CA  SER A 107       8.838  -0.663  71.685  1.00 24.67           C  
ATOM    857  C   SER A 107       7.864  -1.723  71.161  1.00 25.08           C  
ATOM    858  O   SER A 107       6.924  -2.113  71.853  1.00 24.36           O  
ATOM    859  CB  SER A 107       8.001   0.502  72.230  1.00 24.46           C  
ATOM    860  OG  SER A 107       7.215   1.051  71.187  1.00 21.62           O  
ATOM    861  N   ASN A 108       8.050  -2.161  69.930  1.00 25.87           N  
ATOM    862  CA  ASN A 108       7.207  -3.215  69.410  1.00 26.70           C  
ATOM    863  C   ASN A 108       7.731  -4.576  69.906  1.00 27.44           C  
ATOM    864  O   ASN A 108       8.493  -5.254  69.217  1.00 27.79           O  
ATOM    865  CB  ASN A 108       7.187  -3.122  67.900  1.00 26.53           C  
ATOM    866  CG  ASN A 108       6.100  -3.941  67.289  1.00 27.92           C  
ATOM    867  OD1 ASN A 108       5.532  -4.843  67.932  1.00 30.69           O  
ATOM    868  ND2 ASN A 108       5.808  -3.665  66.026  1.00 25.83           N  
ATOM    869  N   ALA A 109       7.344  -4.941  71.130  1.00 28.03           N  
ATOM    870  CA  ALA A 109       7.824  -6.162  71.805  1.00 28.34           C  
ATOM    871  C   ALA A 109       7.408  -7.422  71.045  1.00 28.29           C  
ATOM    872  O   ALA A 109       8.183  -8.385  70.927  1.00 27.66           O  
ATOM    873  CB  ALA A 109       7.305  -6.214  73.243  1.00 27.88           C  
ATOM    874  N   ALA A 110       6.176  -7.380  70.534  1.00 28.25           N  
ATOM    875  CA  ALA A 110       5.660  -8.382  69.611  1.00 28.18           C  
ATOM    876  C   ALA A 110       6.582  -8.605  68.407  1.00 27.86           C  
ATOM    877  O   ALA A 110       7.079  -9.716  68.204  1.00 28.37           O  
ATOM    878  CB  ALA A 110       4.267  -8.004  69.136  1.00 27.98           C  
ATOM    879  N   ALA A 111       6.802  -7.570  67.606  1.00 26.70           N  
ATOM    880  CA  ALA A 111       7.458  -7.778  66.325  1.00 25.92           C  
ATOM    881  C   ALA A 111       8.871  -8.259  66.569  1.00 25.80           C  
ATOM    882  O   ALA A 111       9.312  -9.218  65.927  1.00 25.70           O  
ATOM    883  CB  ALA A 111       7.452  -6.530  65.498  1.00 25.41           C  
ATOM    884  N   ILE A 112       9.548  -7.607  67.521  1.00 25.37           N  
ATOM    885  CA  ILE A 112      10.922  -7.902  67.874  1.00 24.69           C  
ATOM    886  C   ILE A 112      11.065  -9.373  68.234  1.00 25.71           C  
ATOM    887  O   ILE A 112      11.961 -10.069  67.707  1.00 25.86           O  
ATOM    888  CB  ILE A 112      11.405  -7.027  69.054  1.00 24.64           C  
ATOM    889  CG1 ILE A 112      11.434  -5.559  68.639  1.00 24.33           C  
ATOM    890  CG2 ILE A 112      12.793  -7.469  69.567  1.00 21.77           C  
ATOM    891  CD1 ILE A 112      11.723  -4.604  69.827  1.00 24.29           C  
ATOM    892  N   ALA A 113      10.181  -9.849  69.116  1.00 25.87           N  
ATOM    893  CA  ALA A 113      10.221 -11.246  69.561  1.00 26.16           C  
ATOM    894  C   ALA A 113       9.996 -12.193  68.397  1.00 26.63           C  
ATOM    895  O   ALA A 113      10.639 -13.256  68.331  1.00 27.22           O  
ATOM    896  CB  ALA A 113       9.224 -11.516  70.666  1.00 25.88           C  
ATOM    897  N   LEU A 114       9.112 -11.814  67.466  1.00 26.55           N  
ATOM    898  CA  LEU A 114       8.897 -12.639  66.276  1.00 26.46           C  
ATOM    899  C   LEU A 114      10.213 -12.721  65.485  1.00 26.60           C  
ATOM    900  O   LEU A 114      10.731 -13.823  65.233  1.00 25.71           O  
ATOM    901  CB  LEU A 114       7.773 -12.085  65.408  1.00 26.39           C  
ATOM    902  CG  LEU A 114       7.718 -12.628  63.975  1.00 27.95           C  
ATOM    903  CD1 LEU A 114       7.245 -14.077  63.944  1.00 30.38           C  
ATOM    904  CD2 LEU A 114       6.842 -11.775  63.098  1.00 29.89           C  
ATOM    905  N   TYR A 115      10.758 -11.552  65.146  1.00 26.33           N  
ATOM    906  CA  TYR A 115      11.993 -11.481  64.392  1.00 27.15           C  
ATOM    907  C   TYR A 115      13.117 -12.216  65.085  1.00 27.40           C  
ATOM    908  O   TYR A 115      13.887 -12.905  64.429  1.00 27.40           O  
ATOM    909  CB  TYR A 115      12.403 -10.043  64.115  1.00 26.89           C  
ATOM    910  CG  TYR A 115      11.295  -9.220  63.530  1.00 27.30           C  
ATOM    911  CD1 TYR A 115      10.331  -9.782  62.669  1.00 27.51           C  
ATOM    912  CD2 TYR A 115      11.190  -7.880  63.839  1.00 27.78           C  
ATOM    913  CE1 TYR A 115       9.276  -9.002  62.134  1.00 26.49           C  
ATOM    914  CE2 TYR A 115      10.148  -7.098  63.314  1.00 29.58           C  
ATOM    915  CZ  TYR A 115       9.202  -7.665  62.471  1.00 27.92           C  
ATOM    916  OH  TYR A 115       8.206  -6.847  61.994  1.00 28.89           O  
ATOM    917  N   GLU A 116      13.202 -12.083  66.404  1.00 27.93           N  
ATOM    918  CA  GLU A 116      14.293 -12.711  67.139  1.00 28.44           C  
ATOM    919  C   GLU A 116      14.164 -14.207  67.005  1.00 27.84           C  
ATOM    920  O   GLU A 116      15.145 -14.885  66.749  1.00 28.21           O  
ATOM    921  CB  GLU A 116      14.323 -12.281  68.615  1.00 29.12           C  
ATOM    922  CG  GLU A 116      15.503 -11.349  68.949  1.00 32.30           C  
ATOM    923  CD  GLU A 116      15.221 -10.384  70.115  1.00 36.78           C  
ATOM    924  OE1 GLU A 116      14.559 -10.794  71.105  1.00 38.06           O  
ATOM    925  OE2 GLU A 116      15.682  -9.210  70.037  1.00 37.85           O  
ATOM    926  N   SER A 117      12.941 -14.713  67.123  1.00 27.28           N  
ATOM    927  CA  SER A 117      12.707 -16.152  67.030  1.00 26.64           C  
ATOM    928  C   SER A 117      12.903 -16.709  65.614  1.00 26.42           C  
ATOM    929  O   SER A 117      13.096 -17.916  65.452  1.00 26.95           O  
ATOM    930  CB  SER A 117      11.326 -16.530  67.564  1.00 26.34           C  
ATOM    931  OG  SER A 117      10.327 -16.188  66.639  1.00 27.04           O  
ATOM    932  N   LEU A 118      12.864 -15.842  64.606  1.00 25.50           N  
ATOM    933  CA  LEU A 118      13.168 -16.229  63.237  1.00 24.63           C  
ATOM    934  C   LEU A 118      14.657 -16.175  62.923  1.00 24.72           C  
ATOM    935  O   LEU A 118      15.077 -16.625  61.854  1.00 24.45           O  
ATOM    936  CB  LEU A 118      12.423 -15.330  62.258  1.00 24.39           C  
ATOM    937  CG  LEU A 118      10.942 -15.667  62.167  1.00 23.64           C  
ATOM    938  CD1 LEU A 118      10.220 -14.633  61.368  1.00 17.76           C  
ATOM    939  CD2 LEU A 118      10.752 -17.096  61.610  1.00 24.47           C  
ATOM    940  N   GLY A 119      15.452 -15.615  63.833  1.00 24.87           N  
ATOM    941  CA  GLY A 119      16.911 -15.535  63.638  1.00 25.13           C  
ATOM    942  C   GLY A 119      17.493 -14.153  63.339  1.00 25.43           C  
ATOM    943  O   GLY A 119      18.693 -14.027  63.066  1.00 25.34           O  
ATOM    944  N   PHE A 120      16.653 -13.117  63.381  1.00 25.35           N  
ATOM    945  CA  PHE A 120      17.118 -11.738  63.233  1.00 25.78           C  
ATOM    946  C   PHE A 120      17.996 -11.320  64.399  1.00 26.57           C  
ATOM    947  O   PHE A 120      17.736 -11.732  65.534  1.00 27.67           O  
ATOM    948  CB  PHE A 120      15.937 -10.768  63.168  1.00 25.16           C  
ATOM    949  CG  PHE A 120      15.281 -10.683  61.815  1.00 24.85           C  
ATOM    950  CD1 PHE A 120      14.235 -11.553  61.471  1.00 24.71           C  
ATOM    951  CD2 PHE A 120      15.669  -9.706  60.907  1.00 24.11           C  
ATOM    952  CE1 PHE A 120      13.620 -11.480  60.235  1.00 24.18           C  
ATOM    953  CE2 PHE A 120      15.060  -9.601  59.670  1.00 24.68           C  
ATOM    954  CZ  PHE A 120      14.025 -10.489  59.327  1.00 25.67           C  
ATOM    955  N   ASN A 121      19.014 -10.491  64.130  1.00 26.79           N  
ATOM    956  CA  ASN A 121      19.810  -9.840  65.187  1.00 26.28           C  
ATOM    957  C   ASN A 121      19.783  -8.334  65.065  1.00 25.86           C  
ATOM    958  O   ASN A 121      19.713  -7.801  63.956  1.00 26.39           O  
ATOM    959  CB  ASN A 121      21.273 -10.256  65.096  1.00 26.82           C  
ATOM    960  CG  ASN A 121      21.467 -11.758  65.153  1.00 27.60           C  
ATOM    961  OD1 ASN A 121      21.087 -12.408  66.125  1.00 28.22           O  
ATOM    962  ND2 ASN A 121      22.078 -12.315  64.110  1.00 28.28           N  
ATOM    963  N   GLU A 122      19.856  -7.642  66.196  1.00 24.82           N  
ATOM    964  CA  GLU A 122      20.064  -6.218  66.170  1.00 23.88           C  
ATOM    965  C   GLU A 122      21.418  -5.903  65.547  1.00 24.08           C  
ATOM    966  O   GLU A 122      22.426  -6.436  65.985  1.00 23.68           O  
ATOM    967  CB  GLU A 122      20.079  -5.700  67.572  1.00 23.59           C  
ATOM    968  CG  GLU A 122      20.618  -4.297  67.717  1.00 22.90           C  
ATOM    969  CD  GLU A 122      20.412  -3.813  69.113  1.00 24.37           C  
ATOM    970  OE1 GLU A 122      19.406  -4.257  69.704  1.00 25.80           O  
ATOM    971  OE2 GLU A 122      21.247  -3.042  69.644  1.00 25.61           O  
ATOM    972  N   ALA A 123      21.435  -5.049  64.527  1.00 24.16           N  
ATOM    973  CA  ALA A 123      22.687  -4.570  63.957  1.00 24.29           C  
ATOM    974  C   ALA A 123      23.027  -3.222  64.571  1.00 24.74           C  
ATOM    975  O   ALA A 123      24.108  -3.020  65.097  1.00 25.21           O  
ATOM    976  CB  ALA A 123      22.579  -4.455  62.439  1.00 23.64           C  
ATOM    977  N   THR A 124      22.090  -2.293  64.519  1.00 24.60           N  
ATOM    978  CA  THR A 124      22.407  -0.965  64.902  1.00 25.03           C  
ATOM    979  C   THR A 124      21.108  -0.328  65.339  1.00 24.91           C  
ATOM    980  O   THR A 124      20.040  -0.851  65.044  1.00 26.11           O  
ATOM    981  CB  THR A 124      23.126  -0.240  63.720  1.00 25.44           C  
ATOM    982  OG1 THR A 124      23.964   0.798  64.238  1.00 28.36           O  
ATOM    983  CG2 THR A 124      22.158   0.346  62.700  1.00 24.61           C  
ATOM    984  N   ILE A 125      21.184   0.764  66.076  1.00 24.50           N  
ATOM    985  CA  ILE A 125      19.991   1.508  66.470  1.00 24.28           C  
ATOM    986  C   ILE A 125      20.009   2.898  65.859  1.00 24.59           C  
ATOM    987  O   ILE A 125      21.059   3.530  65.817  1.00 25.38           O  
ATOM    988  CB  ILE A 125      19.923   1.615  67.990  1.00 24.32           C  
ATOM    989  CG1 ILE A 125      19.156   0.405  68.500  1.00 24.99           C  
ATOM    990  CG2 ILE A 125      19.243   2.914  68.446  1.00 21.46           C  
ATOM    991  CD1 ILE A 125      19.743  -0.160  69.719  1.00 25.77           C  
ATOM    992  N   ARG A 126      18.866   3.364  65.372  1.00 24.66           N  
ATOM    993  CA  ARG A 126      18.728   4.739  64.885  1.00 24.99           C  
ATOM    994  C   ARG A 126      17.881   5.510  65.854  1.00 24.53           C  
ATOM    995  O   ARG A 126      16.682   5.258  65.940  1.00 25.29           O  
ATOM    996  CB  ARG A 126      17.999   4.727  63.554  1.00 25.34           C  
ATOM    997  CG  ARG A 126      18.901   4.566  62.398  1.00 29.24           C  
ATOM    998  CD  ARG A 126      19.263   5.928  61.793  1.00 36.79           C  
ATOM    999  NE  ARG A 126      18.604   6.092  60.499  1.00 39.66           N  
ATOM   1000  CZ  ARG A 126      18.727   5.226  59.495  1.00 42.30           C  
ATOM   1001  NH1 ARG A 126      19.476   4.127  59.630  1.00 41.50           N  
ATOM   1002  NH2 ARG A 126      18.090   5.453  58.353  1.00 44.57           N  
ATOM   1003  N   ARG A 127      18.452   6.446  66.591  1.00 24.36           N  
ATOM   1004  CA  ARG A 127      17.635   7.199  67.552  1.00 24.49           C  
ATOM   1005  C   ARG A 127      16.650   8.100  66.854  1.00 25.15           C  
ATOM   1006  O   ARG A 127      16.955   8.641  65.792  1.00 24.82           O  
ATOM   1007  CB  ARG A 127      18.484   8.023  68.505  1.00 24.25           C  
ATOM   1008  CG  ARG A 127      19.005   7.232  69.656  1.00 23.00           C  
ATOM   1009  CD  ARG A 127      20.345   7.703  69.988  1.00 23.39           C  
ATOM   1010  NE  ARG A 127      20.297   8.893  70.814  1.00 25.78           N  
ATOM   1011  CZ  ARG A 127      21.357   9.487  71.343  1.00 26.30           C  
ATOM   1012  NH1 ARG A 127      22.573   9.031  71.119  1.00 25.68           N  
ATOM   1013  NH2 ARG A 127      21.194  10.552  72.107  1.00 29.29           N  
ATOM   1014  N   ASN A 128      15.463   8.216  67.454  1.00 25.98           N  
ATOM   1015  CA  ASN A 128      14.406   9.129  67.027  1.00 26.96           C  
ATOM   1016  C   ASN A 128      14.004   9.036  65.577  1.00 28.20           C  
ATOM   1017  O   ASN A 128      13.665  10.032  64.942  1.00 28.70           O  
ATOM   1018  CB  ASN A 128      14.784  10.539  67.363  1.00 26.57           C  
ATOM   1019  CG  ASN A 128      15.000  10.701  68.816  1.00 27.45           C  
ATOM   1020  OD1 ASN A 128      14.173  10.278  69.612  1.00 27.37           O  
ATOM   1021  ND2 ASN A 128      16.141  11.262  69.190  1.00 28.78           N  
ATOM   1022  N   TYR A 129      14.013   7.813  65.080  1.00 28.96           N  
ATOM   1023  CA  TYR A 129      13.751   7.543  63.705  1.00 29.97           C  
ATOM   1024  C   TYR A 129      12.265   7.564  63.374  1.00 30.22           C  
ATOM   1025  O   TYR A 129      11.897   7.964  62.275  1.00 30.87           O  
ATOM   1026  CB  TYR A 129      14.339   6.186  63.433  1.00 30.51           C  
ATOM   1027  CG  TYR A 129      14.131   5.623  62.065  1.00 31.67           C  
ATOM   1028  CD1 TYR A 129      14.959   6.007  61.001  1.00 31.79           C  
ATOM   1029  CD2 TYR A 129      13.155   4.644  61.845  1.00 30.96           C  
ATOM   1030  CE1 TYR A 129      14.800   5.443  59.732  1.00 32.63           C  
ATOM   1031  CE2 TYR A 129      12.990   4.070  60.591  1.00 33.21           C  
ATOM   1032  CZ  TYR A 129      13.818   4.470  59.532  1.00 32.82           C  
ATOM   1033  OH  TYR A 129      13.657   3.900  58.277  1.00 33.03           O  
ATOM   1034  N   TYR A 130      11.429   7.107  64.310  1.00 30.47           N  
ATOM   1035  CA  TYR A 130       9.962   7.079  64.161  1.00 30.35           C  
ATOM   1036  C   TYR A 130       9.237   8.214  64.936  1.00 30.65           C  
ATOM   1037  O   TYR A 130       9.609   8.532  66.075  1.00 30.28           O  
ATOM   1038  CB  TYR A 130       9.422   5.773  64.728  1.00 30.53           C  
ATOM   1039  CG  TYR A 130       9.789   4.491  64.016  1.00 30.74           C  
ATOM   1040  CD1 TYR A 130       9.080   4.073  62.885  1.00 29.97           C  
ATOM   1041  CD2 TYR A 130      10.806   3.667  64.503  1.00 29.40           C  
ATOM   1042  CE1 TYR A 130       9.383   2.896  62.248  1.00 29.24           C  
ATOM   1043  CE2 TYR A 130      11.115   2.484  63.876  1.00 28.93           C  
ATOM   1044  CZ  TYR A 130      10.402   2.105  62.750  1.00 30.99           C  
ATOM   1045  OH  TYR A 130      10.706   0.930  62.111  1.00 32.13           O  
ATOM   1046  N   PRO A 131       8.147   8.769  64.366  1.00 30.83           N  
ATOM   1047  CA  PRO A 131       7.359   9.703  65.174  1.00 30.94           C  
ATOM   1048  C   PRO A 131       6.461   8.928  66.128  1.00 30.97           C  
ATOM   1049  O   PRO A 131       6.145   7.764  65.865  1.00 30.85           O  
ATOM   1050  CB  PRO A 131       6.506  10.430  64.134  1.00 30.66           C  
ATOM   1051  CG  PRO A 131       6.282   9.396  63.071  1.00 31.19           C  
ATOM   1052  CD  PRO A 131       7.556   8.564  63.030  1.00 31.25           C  
ATOM   1053  N   THR A 132       6.084   9.556  67.232  1.00 31.03           N  
ATOM   1054  CA  THR A 132       5.040   9.011  68.094  1.00 31.81           C  
ATOM   1055  C   THR A 132       3.959  10.069  68.345  1.00 32.22           C  
ATOM   1056  O   THR A 132       4.092  11.228  67.927  1.00 31.88           O  
ATOM   1057  CB  THR A 132       5.582   8.435  69.444  1.00 31.77           C  
ATOM   1058  OG1 THR A 132       6.195   9.476  70.221  1.00 32.08           O  
ATOM   1059  CG2 THR A 132       6.575   7.295  69.207  1.00 31.26           C  
ATOM   1060  N   ALA A 133       2.876   9.676  69.007  1.00 32.59           N  
ATOM   1061  CA  ALA A 133       1.838  10.652  69.317  1.00 33.20           C  
ATOM   1062  C   ALA A 133       2.376  11.681  70.289  1.00 33.49           C  
ATOM   1063  O   ALA A 133       1.743  12.692  70.499  1.00 33.89           O  
ATOM   1064  CB  ALA A 133       0.589   9.981  69.882  1.00 32.93           C  
ATOM   1065  N   GLN A 134       3.534  11.425  70.896  1.00 34.14           N  
ATOM   1066  CA  GLN A 134       4.147  12.434  71.784  1.00 34.71           C  
ATOM   1067  C   GLN A 134       5.685  12.667  71.674  1.00 34.34           C  
ATOM   1068  O   GLN A 134       6.350  13.041  72.655  1.00 34.64           O  
ATOM   1069  CB  GLN A 134       3.644  12.317  73.253  1.00 35.17           C  
ATOM   1070  CG  GLN A 134       4.197  11.199  74.136  1.00 36.80           C  
ATOM   1071  CD  GLN A 134       3.333   9.953  74.090  1.00 39.02           C  
ATOM   1072  OE1 GLN A 134       3.488   9.117  73.190  1.00 39.99           O  
ATOM   1073  NE2 GLN A 134       2.416   9.819  75.063  1.00 37.80           N  
ATOM   1074  N   GLY A 135       6.228  12.470  70.469  1.00 33.60           N  
ATOM   1075  CA  GLY A 135       7.649  12.692  70.206  1.00 32.07           C  
ATOM   1076  C   GLY A 135       8.172  11.717  69.173  1.00 31.31           C  
ATOM   1077  O   GLY A 135       7.628  11.604  68.069  1.00 31.24           O  
ATOM   1078  N   HIS A 136       9.230  10.997  69.538  1.00 30.44           N  
ATOM   1079  CA  HIS A 136       9.921  10.113  68.601  1.00 29.48           C  
ATOM   1080  C   HIS A 136      10.229   8.808  69.261  1.00 28.57           C  
ATOM   1081  O   HIS A 136      10.222   8.736  70.480  1.00 28.99           O  
ATOM   1082  CB  HIS A 136      11.201  10.758  68.102  1.00 29.42           C  
ATOM   1083  CG  HIS A 136      10.959  11.925  67.201  1.00 31.38           C  
ATOM   1084  ND1 HIS A 136      10.602  11.778  65.871  1.00 32.75           N  
ATOM   1085  CD2 HIS A 136      10.982  13.259  67.443  1.00 30.61           C  
ATOM   1086  CE1 HIS A 136      10.438  12.971  65.331  1.00 33.16           C  
ATOM   1087  NE2 HIS A 136      10.668  13.886  66.260  1.00 32.63           N  
ATOM   1088  N   GLU A 137      10.470   7.773  68.464  1.00 27.09           N  
ATOM   1089  CA  GLU A 137      10.881   6.486  68.996  1.00 25.82           C  
ATOM   1090  C   GLU A 137      12.145   6.064  68.284  1.00 24.70           C  
ATOM   1091  O   GLU A 137      12.334   6.393  67.116  1.00 24.50           O  
ATOM   1092  CB  GLU A 137       9.812   5.447  68.713  1.00 26.02           C  
ATOM   1093  CG  GLU A 137       9.616   4.491  69.806  1.00 26.95           C  
ATOM   1094  CD  GLU A 137       8.595   3.421  69.462  1.00 29.61           C  
ATOM   1095  OE1 GLU A 137       7.518   3.740  68.875  1.00 27.32           O  
ATOM   1096  OE2 GLU A 137       8.894   2.247  69.806  1.00 31.25           O  
ATOM   1097  N   ASP A 138      12.993   5.317  68.976  1.00 23.31           N  
ATOM   1098  CA  ASP A 138      14.129   4.652  68.345  1.00 22.17           C  
ATOM   1099  C   ASP A 138      13.731   3.539  67.381  1.00 21.91           C  
ATOM   1100  O   ASP A 138      12.740   2.841  67.601  1.00 21.74           O  
ATOM   1101  CB  ASP A 138      14.982   4.012  69.416  1.00 21.85           C  
ATOM   1102  CG  ASP A 138      15.759   5.001  70.190  1.00 20.46           C  
ATOM   1103  OD1 ASP A 138      15.688   6.223  69.920  1.00 17.41           O  
ATOM   1104  OD2 ASP A 138      16.475   4.528  71.072  1.00 21.94           O  
ATOM   1105  N   ALA A 139      14.543   3.362  66.345  1.00 21.19           N  
ATOM   1106  CA  ALA A 139      14.430   2.247  65.418  1.00 20.79           C  
ATOM   1107  C   ALA A 139      15.548   1.238  65.698  1.00 21.66           C  
ATOM   1108  O   ALA A 139      16.716   1.621  65.863  1.00 22.32           O  
ATOM   1109  CB  ALA A 139      14.558   2.752  64.031  1.00 19.66           C  
ATOM   1110  N   ILE A 140      15.194  -0.041  65.756  1.00 21.83           N  
ATOM   1111  CA  ILE A 140      16.174  -1.104  65.801  1.00 22.13           C  
ATOM   1112  C   ILE A 140      16.342  -1.624  64.390  1.00 22.53           C  
ATOM   1113  O   ILE A 140      15.345  -2.025  63.742  1.00 22.93           O  
ATOM   1114  CB  ILE A 140      15.741  -2.241  66.754  1.00 22.01           C  
ATOM   1115  CG1 ILE A 140      15.706  -1.725  68.201  1.00 23.38           C  
ATOM   1116  CG2 ILE A 140      16.708  -3.404  66.685  1.00 21.00           C  
ATOM   1117  CD1 ILE A 140      15.049  -2.679  69.193  1.00 23.82           C  
ATOM   1118  N   ILE A 141      17.584  -1.610  63.903  1.00 22.24           N  
ATOM   1119  CA  ILE A 141      17.894  -2.159  62.579  1.00 22.52           C  
ATOM   1120  C   ILE A 141      18.371  -3.592  62.750  1.00 22.67           C  
ATOM   1121  O   ILE A 141      19.378  -3.827  63.417  1.00 23.18           O  
ATOM   1122  CB  ILE A 141      19.008  -1.330  61.901  1.00 23.04           C  
ATOM   1123  CG1 ILE A 141      18.675   0.178  61.937  1.00 22.71           C  
ATOM   1124  CG2 ILE A 141      19.288  -1.819  60.473  1.00 22.71           C  
ATOM   1125  CD1 ILE A 141      17.391   0.569  61.307  1.00 19.04           C  
ATOM   1126  N   MET A 142      17.654  -4.548  62.169  1.00 22.84           N  
ATOM   1127  CA  MET A 142      17.892  -5.970  62.442  1.00 23.69           C  
ATOM   1128  C   MET A 142      18.252  -6.724  61.190  1.00 23.75           C  
ATOM   1129  O   MET A 142      17.680  -6.489  60.150  1.00 24.42           O  
ATOM   1130  CB  MET A 142      16.655  -6.628  63.048  1.00 23.52           C  
ATOM   1131  CG  MET A 142      16.087  -5.915  64.254  1.00 24.47           C  
ATOM   1132  SD  MET A 142      14.884  -6.883  65.213  1.00 24.61           S  
ATOM   1133  CE  MET A 142      16.029  -8.095  65.893  1.00 21.92           C  
ATOM   1134  N   ALA A 143      19.195  -7.643  61.282  1.00 24.07           N  
ATOM   1135  CA  ALA A 143      19.641  -8.378  60.082  1.00 24.14           C  
ATOM   1136  C   ALA A 143      19.408  -9.855  60.324  1.00 24.12           C  
ATOM   1137  O   ALA A 143      19.748 -10.368  61.388  1.00 24.90           O  
ATOM   1138  CB  ALA A 143      21.107  -8.119  59.822  1.00 22.65           C  
ATOM   1139  N   LEU A 144      18.798 -10.519  59.362  1.00 24.12           N  
ATOM   1140  CA  LEU A 144      18.660 -11.970  59.394  1.00 24.42           C  
ATOM   1141  C   LEU A 144      19.591 -12.576  58.350  1.00 24.56           C  
ATOM   1142  O   LEU A 144      19.417 -12.283  57.156  1.00 25.64           O  
ATOM   1143  CB  LEU A 144      17.223 -12.394  59.068  1.00 24.22           C  
ATOM   1144  CG  LEU A 144      17.037 -13.902  58.812  1.00 24.48           C  
ATOM   1145  CD1 LEU A 144      17.305 -14.730  60.071  1.00 23.61           C  
ATOM   1146  CD2 LEU A 144      15.669 -14.273  58.224  1.00 23.72           C  
ATOM   1147  N   PRO A 145      20.592 -13.384  58.781  1.00 24.03           N  
ATOM   1148  CA  PRO A 145      21.362 -14.170  57.791  1.00 23.83           C  
ATOM   1149  C   PRO A 145      20.547 -15.368  57.297  1.00 23.89           C  
ATOM   1150  O   PRO A 145      19.968 -16.091  58.105  1.00 23.66           O  
ATOM   1151  CB  PRO A 145      22.582 -14.669  58.592  1.00 23.03           C  
ATOM   1152  CG  PRO A 145      22.148 -14.649  60.011  1.00 22.27           C  
ATOM   1153  CD  PRO A 145      21.090 -13.590  60.161  1.00 23.55           C  
ATOM   1154  N   ILE A 146      20.490 -15.547  55.982  1.00 24.06           N  
ATOM   1155  CA  ILE A 146      19.824 -16.693  55.392  1.00 24.08           C  
ATOM   1156  C   ILE A 146      20.878 -17.650  54.850  1.00 24.38           C  
ATOM   1157  O   ILE A 146      21.613 -17.306  53.931  1.00 24.87           O  
ATOM   1158  CB  ILE A 146      18.862 -16.263  54.259  1.00 24.80           C  
ATOM   1159  CG1 ILE A 146      17.984 -15.076  54.731  1.00 24.73           C  
ATOM   1160  CG2 ILE A 146      18.038 -17.483  53.761  1.00 22.38           C  
ATOM   1161  CD1 ILE A 146      17.132 -14.426  53.660  1.00 23.66           C  
ATOM   1162  N   SER A 147      20.967 -18.833  55.450  1.00 24.21           N  
ATOM   1163  CA  SER A 147      21.815 -19.914  54.948  1.00 23.67           C  
ATOM   1164  C   SER A 147      21.410 -20.391  53.595  1.00 23.78           C  
ATOM   1165  O   SER A 147      20.217 -20.513  53.292  1.00 24.07           O  
ATOM   1166  CB  SER A 147      21.775 -21.101  55.882  1.00 22.79           C  
ATOM   1167  OG  SER A 147      22.513 -20.752  57.019  1.00 24.39           O  
ATOM   1168  N   MET A 148      22.424 -20.670  52.790  1.00 23.90           N  
ATOM   1169  CA  MET A 148      22.230 -21.196  51.475  1.00 25.09           C  
ATOM   1170  C   MET A 148      21.929 -22.687  51.548  1.00 25.49           C  
ATOM   1171  O   MET A 148      22.550 -23.414  52.334  1.00 25.57           O  
ATOM   1172  CB  MET A 148      23.491 -20.959  50.654  1.00 25.19           C  
ATOM   1173  CG  MET A 148      23.714 -19.536  50.256  1.00 24.63           C  
ATOM   1174  SD  MET A 148      25.343 -19.346  49.488  1.00 26.05           S  
ATOM   1175  CE  MET A 148      25.080 -17.859  48.512  1.00 25.26           C  
ATOM   1176  N   LYS A 149      20.983 -23.139  50.722  1.00 26.12           N  
ATOM   1177  CA  LYS A 149      20.573 -24.560  50.692  1.00 26.70           C  
ATOM   1178  C   LYS A 149      20.971 -25.199  49.373  1.00 27.02           C  
ATOM   1179  O   LYS A 149      21.353 -24.486  48.434  1.00 27.17           O  
ATOM   1180  CB  LYS A 149      19.056 -24.653  50.870  1.00 26.55           C  
ATOM   1181  CG  LYS A 149      18.604 -24.318  52.295  1.00 28.36           C  
ATOM   1182  CD  LYS A 149      17.141 -23.904  52.419  1.00 32.36           C  
ATOM   1183  CE  LYS A 149      16.628 -24.228  53.840  1.00 36.79           C  
ATOM   1184  NZ  LYS A 149      15.131 -24.232  53.975  1.00 38.57           N  
ATOM   1185  N   LEU A 150      20.903 -26.531  49.295  1.00 27.74           N  
ATOM   1186  CA  LEU A 150      20.999 -27.232  48.013  1.00 28.12           C  
ATOM   1187  C   LEU A 150      19.694 -27.048  47.263  1.00 29.15           C  
ATOM   1188  O   LEU A 150      18.639 -26.965  47.894  1.00 29.68           O  
ATOM   1189  CB  LEU A 150      21.266 -28.710  48.219  1.00 27.96           C  
ATOM   1190  CG  LEU A 150      22.695 -29.081  48.615  1.00 27.76           C  
ATOM   1191  CD1 LEU A 150      22.720 -30.545  48.965  1.00 27.61           C  
ATOM   1192  CD2 LEU A 150      23.690 -28.800  47.522  1.00 26.47           C  
ATOM   1193  N   HIS A 151      19.743 -26.968  45.932  1.00 29.83           N  
ATOM   1194  CA  HIS A 151      18.523 -26.672  45.165  1.00 31.39           C  
ATOM   1195  C   HIS A 151      18.007 -27.787  44.240  1.00 31.25           C  
ATOM   1196  O   HIS A 151      18.652 -28.821  44.061  1.00 32.04           O  
ATOM   1197  CB  HIS A 151      18.681 -25.370  44.368  1.00 31.63           C  
ATOM   1198  CG  HIS A 151      18.765 -24.138  45.213  1.00 34.83           C  
ATOM   1199  ND1 HIS A 151      19.379 -22.981  44.778  1.00 36.69           N  
ATOM   1200  CD2 HIS A 151      18.320 -23.880  46.470  1.00 37.58           C  
ATOM   1201  CE1 HIS A 151      19.295 -22.060  45.725  1.00 37.76           C  
ATOM   1202  NE2 HIS A 151      18.667 -22.584  46.767  1.00 37.27           N  
TER    1203      HIS A 151                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
