
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  210 ( 1652),  selected  210 , name 2ah5_A
# Molecule2: number of CA atoms  210 ( 1658),  selected  210 , name T0418.pdb
# PARAMETERS: 2ah5_A.T0418.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      -       -           -
LGA    T     2_A      -       -           -
LGA    S     3_A      K       2          3.314
LGA    I     4_A      Y       3          1.454
LGA    T     5_A      T       4          1.242
LGA    A     6_A      V       5          0.785
LGA    I     7_A      Y       6          0.787
LGA    F     8_A      L       7          0.400
LGA    F     9_A      F       8          0.674
LGA    D    10_A      D       9          0.602
LGA    L    11_A      F      10          0.741
LGA    D    12_A      D      11          0.706
LGA    G    13_A      Y      12          0.588
LGA    T    14_A      T      13          0.234
LGA    L    15_A      L      14          0.520
LGA    V    16_A      A      15          0.378
LGA    D    17_A      D      16          0.241
LGA    S    18_A      S      17          0.154
LGA    S    19_A      S      18          0.561
LGA    I    20_A      R      19          0.503
LGA    G    21_A      G      20          0.212
LGA    I    22_A      I      21          0.054
LGA    H    23_A      V      22          0.346
LGA    N    24_A      T      23          0.101
LGA    A    25_A      C      24          0.304
LGA    F    26_A      F      25          0.784
LGA    T    27_A      R      26          0.846
LGA    Y    28_A      S      27          0.672
LGA    T    29_A      V      28          0.606
LGA    F    30_A      L      29          1.749
LGA    K    31_A      E      30          2.410
LGA    E    32_A      R      31          1.561
LGA    L    33_A      H      32          1.228
LGA    G    34_A      G      33          2.606
LGA    V    35_A      Y      34          2.268
LGA    P    36_A      T      35          0.663
LGA    S    37_A      G      36          4.326
LGA    P    38_A      I      37          0.571
LGA    D    39_A      T      38          0.819
LGA    A    40_A      D      39          1.593
LGA    K    41_A      D      40          1.387
LGA    T    42_A      M      41          0.680
LGA    I    43_A      I      42          1.225
LGA    R    44_A      K      43          1.230
LGA    G    45_A      R      44          0.808
LGA    F    46_A      T      45          1.734
LGA    X    47_A      I      46          0.805
LGA    G    48_A      G      47          1.428
LGA    P    49_A      K      48          1.525
LGA    P    50_A      T      49          1.707
LGA    L    51_A      L      50          1.544
LGA    E    52_A      E      51          1.263
LGA    S    53_A      E      52          1.570
LGA    S    54_A      S      53          1.804
LGA    F    55_A      F      54          1.188
LGA    A    56_A      S      55          1.275
LGA    T    57_A      I      56          2.283
LGA    C    58_A      L      57          3.085
LGA    L    59_A      T      58          2.307
LGA    -       -      G      59           -
LGA    S    60_A      I      60          3.341
LGA    K    61_A      T      61          3.347
LGA    -       -      D      62           -
LGA    -       -      A      63           -
LGA    D    62_A      D      64           #
LGA    Q    63_A      Q      65          3.569
LGA    I    64_A      L      66          2.459
LGA    S    65_A      E      67          2.633
LGA    E    66_A      S      68          2.354
LGA    A    67_A      F      69          1.817
LGA    V    68_A      R      70          1.714
LGA    Q    69_A      Q      71          1.695
LGA    I    70_A      E      72          1.228
LGA    Y    71_A      Y      73          1.103
LGA    R    72_A      S      74          1.165
LGA    S    73_A      K      75          0.971
LGA    Y    74_A      E      76          0.358
LGA    Y    75_A      A      77          0.748
LGA    K    76_A      D      78          1.868
LGA    A    77_A      I      79          2.246
LGA    K    78_A      Y      80          1.754
LGA    G    79_A      M      81          1.876
LGA    I    80_A      N      82          2.583
LGA    Y    81_A      A      83          1.827
LGA    E    82_A      N      84          0.746
LGA    A    83_A      T      85          0.432
LGA    Q    84_A      I      86          0.214
LGA    L    85_A      L      87          0.585
LGA    F    86_A      F      88          1.085
LGA    P    87_A      P      89          1.327
LGA    Q    88_A      D      90          1.894
LGA    I    89_A      T      91          1.420
LGA    I    90_A      L      92          1.164
LGA    D    91_A      P      93          1.235
LGA    L    92_A      T      94          0.949
LGA    L    93_A      L      95          1.119
LGA    E    94_A      T      96          1.112
LGA    E    95_A      H      97          0.896
LGA    L    96_A      L      98          1.174
LGA    S    97_A      K      99          1.425
LGA    S    98_A      K     100          0.908
LGA    S    99_A      Q     101          1.032
LGA    -       -      G     102           -
LGA    Y   100_A      I     103          0.689
LGA    P   101_A      R     104          1.166
LGA    L   102_A      I     105          0.707
LGA    Y   103_A      G     106          0.695
LGA    I   104_A      I     107          0.969
LGA    T   105_A      I     108          1.163
LGA    T   106_A      S     109          0.952
LGA    T   107_A      T     110          1.599
LGA    K   108_A      K     111          1.485
LGA    D   109_A      Y     112          1.924
LGA    T   110_A      R     113          1.997
LGA    S   111_A      F     114          1.587
LGA    T   112_A      R     115          1.669
LGA    A   113_A      I     116          1.899
LGA    Q   114_A      L     117          1.667
LGA    D   115_A      S     118          1.656
LGA    X   116_A      F     119          1.950
LGA    A   117_A      L     120          2.042
LGA    K   118_A      R     121          1.875
LGA    N   119_A      N     122          3.061
LGA    L   120_A      H     123          2.415
LGA    E   121_A      M     124          2.371
LGA    I   122_A      P     125          5.055
LGA    H   123_A      D     126          4.629
LGA    H   124_A      D     127          2.892
LGA    F   125_A      W     128          2.506
LGA    F   126_A      F     129          1.430
LGA    D   127_A      D     130          1.606
LGA    G   128_A      I     131          1.716
LGA    I   129_A      I     132          1.340
LGA    Y   130_A      I     133          1.444
LGA    G   131_A      G     134          1.322
LGA    S   132_A      G     135          2.411
LGA    S   133_A      E     136          3.161
LGA    P   134_A      D     137          5.290
LGA    E   135_A      V     138          4.176
LGA    A   136_A      T     139          4.937
LGA    P   137_A      H     140          2.824
LGA    H   138_A      H     141          1.850
LGA    K   139_A      K     142          3.162
LGA    -       -      P     143           -
LGA    -       -      D     144           -
LGA    A   140_A      P     145          1.047
LGA    D   141_A      E     146          0.958
LGA    V   142_A      G     147          1.003
LGA    I   143_A      L     148          0.844
LGA    H   144_A      L     149          0.882
LGA    Q   145_A      L     150          1.128
LGA    A   146_A      A     151          0.886
LGA    L   147_A      I     152          0.557
LGA    Q   148_A      D     153          0.615
LGA    T   149_A      R     154          0.643
LGA    H   150_A      L     155          0.931
LGA    Q   151_A      K     156          0.540
LGA    L   152_A      A     157          0.733
LGA    A   153_A      C     158          1.406
LGA    P   154_A      P     159          0.821
LGA    E   155_A      E     160          0.652
LGA    Q   156_A      E     161          1.123
LGA    A   157_A      V     162          0.388
LGA    I   158_A      L     163          0.505
LGA    I   159_A      Y     164          0.678
LGA    I   160_A      I     165          0.955
LGA    G   161_A      G     166          0.623
LGA    D   162_A      D     167          0.550
LGA    T   163_A      S     168          0.987
LGA    K   164_A      T     169          1.133
LGA    F   165_A      V     170          1.465
LGA    D   166_A      D     171          1.139
LGA    X   167_A      A     172          0.839
LGA    L   168_A      G     173          1.116
LGA    G   169_A      T     174          1.118
LGA    A   170_A      A     175          0.789
LGA    R   171_A      A     176          0.828
LGA    E   172_A      A     177          1.222
LGA    T   173_A      A     178          1.198
LGA    G   174_A      G     179          1.230
LGA    I   175_A      V     180          1.085
LGA    Q   176_A      S     181          0.666
LGA    K   177_A      F     182          0.330
LGA    L   178_A      T     183          0.504
LGA    A   179_A      G     184          0.426
LGA    I   180_A      V     185          0.249
LGA    T   181_A      T     186          0.509
LGA    W   182_A      S     187          1.746
LGA    G   183_A      G     188          2.212
LGA    F   184_A      M     189          3.467
LGA    G   185_A      T     190          2.750
LGA    E   186_A      T     191          3.028
LGA    Q   187_A      A     192          2.579
LGA    A   188_A      Q     193          2.296
LGA    D   189_A      E     194          2.018
LGA    L   190_A      F     195          1.680
LGA    L   191_A      Q     196          2.364
LGA    N   192_A      A     197          1.564
LGA    Y   193_A      Y     198          0.731
LGA    Q   194_A      P     199          2.354
LGA    P   195_A      Y     200          0.677
LGA    D   196_A      D     201          0.808
LGA    Y   197_A      R     202          1.414
LGA    I   198_A      I     203          1.586
LGA    A   199_A      I     204          0.858
LGA    H   200_A      S     205          0.264
LGA    K   201_A      T     206          1.670
LGA    P   202_A      L     207          2.107
LGA    L   203_A      G     208          1.821
LGA    E   204_A      Q     209          1.166
LGA    V   205_A      L     210          0.943
LGA    L   206_A      I     211          0.716
LGA    A   207_A      -       -           -
LGA    Y   208_A      -       -           -
LGA    F   209_A      -       -           -
LGA    Q   210_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  210  210    5.0    203    1.73    25.12     87.849    11.121

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.026489 * X  +   0.991619 * Y  +  -0.126455 * Z  + -32.794807
  Y_new =  -0.974627 * X  +  -0.002508 * Y  +  -0.223821 * Z  +  61.665947
  Z_new =  -0.222262 * X  +   0.129175 * Y  +   0.966392 * Z  +  65.168167 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.132879   -3.008713  [ DEG:     7.6134   -172.3866 ]
  Theta =   0.224134    2.917458  [ DEG:    12.8420    167.1581 ]
  Phi   =  -1.543625    1.597968  [ DEG:   -88.4432     91.5568 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ah5_A                                        
REMARK     2: T0418.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ah5_A.T0418.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  210  210   5.0  203   1.73   25.12  87.849
REMARK  ---------------------------------------------------------- 
MOLECULE 2ah5_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   27-JUL-05   2AH5              
TITLE     HYDROLASE, HALOACID DEHALOGENASE-LIKE FAMILY PROTEIN SP0104           
TITLE    2 FROM STREPTOCOCCUS PNEUMONIAE                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: COG0546: PREDICTED PHOSPHATASES;                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PNEUMONIAE;                       
SOURCE   3 STRAIN: TIGR4;                                                       
SOURCE   4 GENE: SP0104;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    MCSG, STRUCTURAL GENOMICS, STREPTOCOCCUS PNEUMONIAE,                  
KEYWDS   2 HYDROLASE, HALOACID DEHALOGENASE-LIKE, PSI, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.A.BINKOWSKI,M.ZHOU,J.ABDULLAH,F.COLLART,A.JOACHIMIAK,MCSG,          
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   27-SEP-05 2AH5    0                                                
JRNL        AUTH   T.A.BINKOWSKI,M.ZHOU,J.ABDULLAH,F.COLLART,                   
JRNL        AUTH 2 A.JOACHIMIAK,MCSG                                            
JRNL        TITL   HYDROLASE, HALOACID DEHALOGENASE-LIKE FAMILY                 
JRNL        TITL 2 PROTEIN SP0104 FROM STREPTOCOCCUS PNEUMONIAE                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.74 ANGSTROMS.                                          
DBREF  2AH5 A    1   210  UNP    Q97T51   Q97T51_STRPN     1    210             
SEQRES   1 A  210  MSE THR SER ILE THR ALA ILE PHE PHE ASP LEU ASP GLY          
SEQRES   2 A  210  THR LEU VAL ASP SER SER ILE GLY ILE HIS ASN ALA PHE          
SEQRES   3 A  210  THR TYR THR PHE LYS GLU LEU GLY VAL PRO SER PRO ASP          
SEQRES   4 A  210  ALA LYS THR ILE ARG GLY PHE MSE GLY PRO PRO LEU GLU          
SEQRES   5 A  210  SER SER PHE ALA THR CYS LEU SER LYS ASP GLN ILE SER          
SEQRES   6 A  210  GLU ALA VAL GLN ILE TYR ARG SER TYR TYR LYS ALA LYS          
SEQRES   7 A  210  GLY ILE TYR GLU ALA GLN LEU PHE PRO GLN ILE ILE ASP          
SEQRES   8 A  210  LEU LEU GLU GLU LEU SER SER SER TYR PRO LEU TYR ILE          
SEQRES   9 A  210  THR THR THR LYS ASP THR SER THR ALA GLN ASP MSE ALA          
SEQRES  10 A  210  LYS ASN LEU GLU ILE HIS HIS PHE PHE ASP GLY ILE TYR          
SEQRES  11 A  210  GLY SER SER PRO GLU ALA PRO HIS LYS ALA ASP VAL ILE          
SEQRES  12 A  210  HIS GLN ALA LEU GLN THR HIS GLN LEU ALA PRO GLU GLN          
SEQRES  13 A  210  ALA ILE ILE ILE GLY ASP THR LYS PHE ASP MSE LEU GLY          
SEQRES  14 A  210  ALA ARG GLU THR GLY ILE GLN LYS LEU ALA ILE THR TRP          
SEQRES  15 A  210  GLY PHE GLY GLU GLN ALA ASP LEU LEU ASN TYR GLN PRO          
SEQRES  16 A  210  ASP TYR ILE ALA HIS LYS PRO LEU GLU VAL LEU ALA TYR          
SEQRES  17 A  210  PHE GLN                                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  47       8                                                       
HET    MSE  A 116       8                                                       
HET    MSE  A 167       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *174(H2 O)                                                    
CRYST1   35.676   46.653  130.124  90.00  90.00  90.00 P 21 21 21    4          
HETATM    1  N   MSE A   1     -10.173  34.530  66.189  1.00 43.93           N  
HETATM    2  CA  MSE A   1     -10.063  35.918  66.726  1.00 45.40           C  
HETATM    3  C   MSE A   1     -11.413  36.437  67.210  1.00 41.74           C  
HETATM    4  O   MSE A   1     -11.514  36.960  68.312  1.00 41.45           O  
HETATM    5  CB  MSE A   1      -9.451  36.887  65.685  1.00 45.23           C  
HETATM    6  CG  MSE A   1      -9.963  38.364  65.723  1.00 44.64           C  
HETATM    7 SE   MSE A   1      -9.757  39.208  63.956  1.00 56.50          SE  
HETATM    8  CE  MSE A   1     -10.955  40.832  64.239  1.00 50.05           C  
ATOM      9  N   THR A   2     -12.442  36.284  66.379  1.00 38.92           N  
ATOM     10  CA  THR A   2     -13.700  37.018  66.567  1.00 35.97           C  
ATOM     11  C   THR A   2     -14.390  36.760  67.919  1.00 33.55           C  
ATOM     12  O   THR A   2     -15.020  37.656  68.470  1.00 33.55           O  
ATOM     13  CB  THR A   2     -14.673  36.828  65.366  1.00 36.16           C  
ATOM     14  OG1 THR A   2     -15.008  35.442  65.232  1.00 37.17           O  
ATOM     15  CG2 THR A   2     -14.015  37.307  64.057  1.00 35.58           C  
ATOM     16  N   SER A   3     -14.252  35.565  68.480  1.00 30.81           N  
ATOM     17  CA  SER A   3     -14.870  35.335  69.788  1.00 28.27           C  
ATOM     18  C   SER A   3     -14.030  35.892  70.950  1.00 25.48           C  
ATOM     19  O   SER A   3     -14.518  36.003  72.069  1.00 24.15           O  
ATOM     20  CB  SER A   3     -15.224  33.860  70.003  1.00 29.46           C  
ATOM     21  OG  SER A   3     -14.097  33.147  70.470  1.00 31.14           O  
ATOM     22  N   ILE A   4     -12.775  36.255  70.682  1.00 22.59           N  
ATOM     23  CA  ILE A   4     -11.921  36.813  71.746  1.00 20.25           C  
ATOM     24  C   ILE A   4     -12.454  38.191  72.132  1.00 18.93           C  
ATOM     25  O   ILE A   4     -12.701  39.047  71.265  1.00 18.20           O  
ATOM     26  CB  ILE A   4     -10.427  36.915  71.323  1.00 20.17           C  
ATOM     27  CG1 ILE A   4      -9.825  35.520  71.105  1.00 19.40           C  
ATOM     28  CG2 ILE A   4      -9.602  37.698  72.363  1.00 19.15           C  
ATOM     29  CD1 ILE A   4      -8.616  35.526  70.222  1.00 22.87           C  
ATOM     30  N   THR A   5     -12.659  38.387  73.433  1.00 17.87           N  
ATOM     31  CA  THR A   5     -13.018  39.700  73.985  1.00 17.90           C  
ATOM     32  C   THR A   5     -12.012  40.236  75.021  1.00 17.01           C  
ATOM     33  O   THR A   5     -12.134  41.380  75.473  1.00 18.06           O  
ATOM     34  CB  THR A   5     -14.416  39.716  74.645  1.00 18.44           C  
ATOM     35  OG1 THR A   5     -14.406  38.889  75.816  1.00 19.58           O  
ATOM     36  CG2 THR A   5     -15.509  39.230  73.685  1.00 20.42           C  
ATOM     37  N   ALA A   6     -11.027  39.417  75.384  1.00 15.76           N  
ATOM     38  CA  ALA A   6     -10.083  39.751  76.449  1.00 14.43           C  
ATOM     39  C   ALA A   6      -8.724  39.137  76.120  1.00 12.97           C  
ATOM     40  O   ALA A   6      -8.645  38.025  75.582  1.00 13.38           O  
ATOM     41  CB  ALA A   6     -10.581  39.232  77.768  1.00 14.27           C  
ATOM     42  N   ILE A   7      -7.672  39.879  76.419  1.00 12.78           N  
ATOM     43  CA  ILE A   7      -6.318  39.444  76.097  1.00 12.64           C  
ATOM     44  C   ILE A   7      -5.467  39.344  77.371  1.00 12.84           C  
ATOM     45  O   ILE A   7      -5.393  40.310  78.151  1.00 12.22           O  
ATOM     46  CB  ILE A   7      -5.639  40.384  75.073  1.00 12.17           C  
ATOM     47  CG1 ILE A   7      -6.493  40.530  73.793  1.00 11.46           C  
ATOM     48  CG2 ILE A   7      -4.237  39.868  74.763  1.00 14.09           C  
ATOM     49  CD1 ILE A   7      -5.839  41.415  72.698  1.00 13.45           C  
ATOM     50  N   PHE A   8      -4.875  38.159  77.598  1.00 11.76           N  
ATOM     51  CA  PHE A   8      -4.016  37.894  78.765  1.00 12.37           C  
ATOM     52  C   PHE A   8      -2.543  37.914  78.323  1.00 12.21           C  
ATOM     53  O   PHE A   8      -2.205  37.347  77.286  1.00 12.60           O  
ATOM     54  CB  PHE A   8      -4.296  36.501  79.369  1.00 12.29           C  
ATOM     55  CG  PHE A   8      -5.696  36.312  79.910  1.00 11.07           C  
ATOM     56  CD1 PHE A   8      -6.575  37.390  80.069  1.00 12.20           C  
ATOM     57  CD2 PHE A   8      -6.105  35.035  80.325  1.00 12.45           C  
ATOM     58  CE1 PHE A   8      -7.862  37.197  80.602  1.00 12.26           C  
ATOM     59  CE2 PHE A   8      -7.387  34.837  80.877  1.00 14.29           C  
ATOM     60  CZ  PHE A   8      -8.263  35.904  81.004  1.00 13.19           C  
ATOM     61  N   PHE A   9      -1.672  38.475  79.154  1.00 12.61           N  
ATOM     62  CA  PHE A   9      -0.254  38.537  78.846  1.00 12.51           C  
ATOM     63  C   PHE A   9       0.561  37.878  79.954  1.00 12.63           C  
ATOM     64  O   PHE A   9       0.274  38.109  81.135  1.00 12.60           O  
ATOM     65  CB  PHE A   9       0.181  39.982  78.788  1.00 13.52           C  
ATOM     66  CG  PHE A   9      -0.282  40.702  77.574  1.00 13.63           C  
ATOM     67  CD1 PHE A   9      -1.526  41.296  77.561  1.00 16.76           C  
ATOM     68  CD2 PHE A   9       0.538  40.795  76.467  1.00 16.01           C  
ATOM     69  CE1 PHE A   9      -1.955  41.990  76.434  1.00 17.49           C  
ATOM     70  CE2 PHE A   9       0.118  41.514  75.328  1.00 17.96           C  
ATOM     71  CZ  PHE A   9      -1.128  42.089  75.331  1.00 16.17           C  
ATOM     72  N   ASP A  10       1.556  37.063  79.595  1.00 12.79           N  
ATOM     73  CA  ASP A  10       2.640  36.727  80.546  1.00 14.00           C  
ATOM     74  C   ASP A  10       3.446  38.038  80.746  1.00 14.09           C  
ATOM     75  O   ASP A  10       3.342  38.953  79.938  1.00 14.02           O  
ATOM     76  CB  ASP A  10       3.557  35.602  79.997  1.00 14.06           C  
ATOM     77  CG  ASP A  10       4.337  34.860  81.113  1.00 18.18           C  
ATOM     78  OD1 ASP A  10       4.315  35.285  82.294  1.00 21.35           O  
ATOM     79  OD2 ASP A  10       4.986  33.828  80.808  1.00 23.03           O  
ATOM     80  N   LEU A  11       4.236  38.129  81.811  1.00 14.67           N  
ATOM     81  CA  LEU A  11       4.951  39.369  82.173  1.00 14.09           C  
ATOM     82  C   LEU A  11       6.402  39.214  81.773  1.00 15.07           C  
ATOM     83  O   LEU A  11       6.795  39.711  80.741  1.00 14.25           O  
ATOM     84  CB  LEU A  11       4.840  39.658  83.684  1.00 15.01           C  
ATOM     85  CG  LEU A  11       5.445  40.969  84.201  1.00 15.45           C  
ATOM     86  CD1 LEU A  11       4.906  42.182  83.440  1.00 16.51           C  
ATOM     87  CD2 LEU A  11       5.149  41.114  85.711  1.00 15.41           C  
ATOM     88  N   ASP A  12       7.188  38.518  82.598  1.00 14.68           N  
ATOM     89  CA  ASP A  12       8.590  38.221  82.292  1.00 15.90           C  
ATOM     90  C   ASP A  12       8.712  37.459  80.989  1.00 15.41           C  
ATOM     91  O   ASP A  12       7.970  36.519  80.756  1.00 17.36           O  
ATOM     92  CB  ASP A  12       9.206  37.351  83.386  1.00 16.48           C  
ATOM     93  CG  ASP A  12       9.139  37.991  84.714  1.00 20.29           C  
ATOM     94  OD1 ASP A  12      10.026  38.797  84.998  1.00 22.18           O  
ATOM     95  OD2 ASP A  12       8.176  37.721  85.469  1.00 26.06           O  
ATOM     96  N   GLY A  13       9.641  37.862  80.138  1.00 15.12           N  
ATOM     97  CA  GLY A  13       9.902  37.150  78.899  1.00 14.82           C  
ATOM     98  C   GLY A  13       8.927  37.445  77.783  1.00 14.36           C  
ATOM     99  O   GLY A  13       9.115  36.986  76.676  1.00 14.53           O  
ATOM    100  N   THR A  14       7.888  38.224  78.077  1.00 13.51           N  
ATOM    101  CA  THR A  14       6.894  38.585  77.071  1.00 13.13           C  
ATOM    102  C   THR A  14       6.788  40.118  76.966  1.00 13.16           C  
ATOM    103  O   THR A  14       7.184  40.711  75.956  1.00 13.68           O  
ATOM    104  CB  THR A  14       5.528  37.932  77.424  1.00 13.56           C  
ATOM    105  OG1 THR A  14       5.647  36.507  77.332  1.00 15.79           O  
ATOM    106  CG2 THR A  14       4.439  38.411  76.494  1.00 13.05           C  
ATOM    107  N   LEU A  15       6.293  40.759  78.023  1.00 12.13           N  
ATOM    108  CA  LEU A  15       6.256  42.220  78.090  1.00 11.50           C  
ATOM    109  C   LEU A  15       7.612  42.769  78.537  1.00 11.89           C  
ATOM    110  O   LEU A  15       8.089  43.798  78.027  1.00 12.15           O  
ATOM    111  CB  LEU A  15       5.156  42.684  79.061  1.00 11.45           C  
ATOM    112  CG  LEU A  15       3.737  42.235  78.710  1.00 11.19           C  
ATOM    113  CD1 LEU A  15       2.770  42.474  79.855  1.00 13.67           C  
ATOM    114  CD2 LEU A  15       3.259  42.938  77.442  1.00 13.82           C  
ATOM    115  N   VAL A  16       8.233  42.045  79.464  1.00 11.97           N  
ATOM    116  CA  VAL A  16       9.350  42.589  80.224  1.00 12.18           C  
ATOM    117  C   VAL A  16      10.591  41.752  80.007  1.00 12.23           C  
ATOM    118  O   VAL A  16      10.580  40.551  80.257  1.00 11.54           O  
ATOM    119  CB  VAL A  16       9.029  42.730  81.752  1.00 12.23           C  
ATOM    120  CG1 VAL A  16      10.261  43.253  82.478  1.00 11.95           C  
ATOM    121  CG2 VAL A  16       7.842  43.710  81.960  1.00 14.09           C  
ATOM    122  N   ASP A  17      11.652  42.396  79.523  1.00 12.76           N  
ATOM    123  CA  ASP A  17      12.959  41.781  79.512  1.00 12.37           C  
ATOM    124  C   ASP A  17      13.587  41.896  80.900  1.00 12.30           C  
ATOM    125  O   ASP A  17      14.365  42.826  81.188  1.00 12.48           O  
ATOM    126  CB  ASP A  17      13.885  42.382  78.429  1.00 13.21           C  
ATOM    127  CG  ASP A  17      15.198  41.636  78.331  1.00 16.00           C  
ATOM    128  OD1 ASP A  17      15.425  40.739  79.171  1.00 15.03           O  
ATOM    129  OD2 ASP A  17      16.001  41.932  77.427  1.00 18.31           O  
ATOM    130  N   SER A  18      13.264  40.922  81.740  1.00 12.22           N  
ATOM    131  CA  SER A  18      13.712  40.920  83.135  1.00 13.05           C  
ATOM    132  C   SER A  18      15.040  40.148  83.261  1.00 13.45           C  
ATOM    133  O   SER A  18      15.479  39.860  84.385  1.00 13.95           O  
ATOM    134  CB  SER A  18      12.636  40.276  84.008  1.00 13.47           C  
ATOM    135  OG  SER A  18      12.092  39.131  83.361  1.00 14.75           O  
ATOM    136  N   SER A  19      15.640  39.763  82.126  1.00 13.75           N  
ATOM    137  CA  SER A  19      16.770  38.790  82.141  1.00 14.54           C  
ATOM    138  C   SER A  19      17.983  39.225  82.965  1.00 15.44           C  
ATOM    139  O   SER A  19      18.550  38.393  83.657  1.00 15.80           O  
ATOM    140  CB  SER A  19      17.241  38.386  80.732  1.00 15.08           C  
ATOM    141  OG  SER A  19      17.729  39.510  80.019  1.00 16.38           O  
ATOM    142  N   ILE A  20      18.387  40.491  82.889  1.00 16.16           N  
ATOM    143  CA  ILE A  20      19.562  40.931  83.681  1.00 16.66           C  
ATOM    144  C   ILE A  20      19.346  40.704  85.192  1.00 16.04           C  
ATOM    145  O   ILE A  20      20.203  40.133  85.867  1.00 15.71           O  
ATOM    146  CB  ILE A  20      20.023  42.384  83.375  1.00 17.36           C  
ATOM    147  CG1 ILE A  20      20.401  42.526  81.889  1.00 17.98           C  
ATOM    148  CG2 ILE A  20      21.254  42.740  84.234  1.00 17.66           C  
ATOM    149  CD1 ILE A  20      20.491  43.931  81.402  1.00 19.17           C  
ATOM    150  N   GLY A  21      18.212  41.143  85.723  1.00 15.44           N  
ATOM    151  CA  GLY A  21      17.927  40.955  87.150  1.00 13.88           C  
ATOM    152  C   GLY A  21      17.739  39.501  87.576  1.00 13.44           C  
ATOM    153  O   GLY A  21      18.125  39.133  88.688  1.00 13.05           O  
ATOM    154  N   ILE A  22      17.119  38.667  86.730  1.00 12.39           N  
ATOM    155  CA  ILE A  22      16.962  37.240  87.044  1.00 12.94           C  
ATOM    156  C   ILE A  22      18.342  36.580  87.055  1.00 12.81           C  
ATOM    157  O   ILE A  22      18.700  35.897  88.017  1.00 12.50           O  
ATOM    158  CB  ILE A  22      16.004  36.543  86.033  1.00 12.04           C  
ATOM    159  CG1 ILE A  22      14.594  37.143  86.149  1.00 13.91           C  
ATOM    160  CG2 ILE A  22      15.943  35.016  86.268  1.00 13.65           C  
ATOM    161  CD1 ILE A  22      13.624  36.653  85.016  1.00 14.60           C  
ATOM    162  N   HIS A  23      19.119  36.846  86.005  1.00 12.95           N  
ATOM    163  CA  HIS A  23      20.480  36.321  85.915  1.00 12.95           C  
ATOM    164  C   HIS A  23      21.274  36.723  87.152  1.00 12.56           C  
ATOM    165  O   HIS A  23      21.924  35.880  87.760  1.00 13.15           O  
ATOM    166  CB  HIS A  23      21.181  36.838  84.659  1.00 13.44           C  
ATOM    167  CG  HIS A  23      22.531  36.236  84.420  1.00 14.24           C  
ATOM    168  ND1 HIS A  23      23.675  36.727  85.014  1.00 20.57           N  
ATOM    169  CD2 HIS A  23      22.924  35.191  83.654  1.00 17.73           C  
ATOM    170  CE1 HIS A  23      24.718  36.016  84.616  1.00 18.13           C  
ATOM    171  NE2 HIS A  23      24.290  35.085  83.782  1.00 18.95           N  
ATOM    172  N   ASN A  24      21.245  38.007  87.503  1.00 12.82           N  
ATOM    173  CA  ASN A  24      21.975  38.499  88.674  1.00 13.34           C  
ATOM    174  C   ASN A  24      21.518  37.872  89.995  1.00 12.61           C  
ATOM    175  O   ASN A  24      22.332  37.600  90.914  1.00 11.93           O  
ATOM    176  CB  ASN A  24      21.899  40.027  88.757  1.00 14.46           C  
ATOM    177  CG  ASN A  24      22.771  40.727  87.713  1.00 16.88           C  
ATOM    178  OD1 ASN A  24      23.575  40.098  87.021  1.00 20.77           O  
ATOM    179  ND2 ASN A  24      22.595  42.048  87.592  1.00 19.34           N  
ATOM    180  N   ALA A  25      20.218  37.677  90.136  1.00 11.41           N  
ATOM    181  CA  ALA A  25      19.715  36.982  91.317  1.00 11.84           C  
ATOM    182  C   ALA A  25      20.280  35.547  91.388  1.00 11.90           C  
ATOM    183  O   ALA A  25      20.689  35.103  92.472  1.00 11.03           O  
ATOM    184  CB  ALA A  25      18.192  36.985  91.334  1.00 11.73           C  
ATOM    185  N   PHE A  26      20.305  34.818  90.263  1.00 11.59           N  
ATOM    186  CA  PHE A  26      20.904  33.470  90.283  1.00 12.24           C  
ATOM    187  C   PHE A  26      22.388  33.482  90.662  1.00 12.73           C  
ATOM    188  O   PHE A  26      22.830  32.719  91.530  1.00 12.23           O  
ATOM    189  CB  PHE A  26      20.713  32.734  88.966  1.00 13.12           C  
ATOM    190  CG  PHE A  26      19.377  32.089  88.856  1.00 12.19           C  
ATOM    191  CD1 PHE A  26      18.459  32.561  87.935  1.00 12.68           C  
ATOM    192  CD2 PHE A  26      19.024  31.034  89.711  1.00 13.68           C  
ATOM    193  CE1 PHE A  26      17.204  31.981  87.828  1.00 12.84           C  
ATOM    194  CE2 PHE A  26      17.744  30.427  89.599  1.00 13.64           C  
ATOM    195  CZ  PHE A  26      16.840  30.925  88.670  1.00 12.88           C  
ATOM    196  N   THR A  27      23.133  34.376  90.039  1.00 12.46           N  
ATOM    197  CA  THR A  27      24.602  34.392  90.244  1.00 13.20           C  
ATOM    198  C   THR A  27      24.941  34.894  91.657  1.00 12.70           C  
ATOM    199  O   THR A  27      25.935  34.455  92.255  1.00 12.60           O  
ATOM    200  CB  THR A  27      25.353  35.196  89.152  1.00 13.02           C  
ATOM    201  OG1 THR A  27      24.906  36.547  89.165  1.00 11.61           O  
ATOM    202  CG2 THR A  27      25.106  34.589  87.723  1.00 14.62           C  
ATOM    203  N   TYR A  28      24.138  35.827  92.174  1.00 12.13           N  
ATOM    204  CA  TYR A  28      24.280  36.234  93.593  1.00 12.45           C  
ATOM    205  C   TYR A  28      24.116  35.029  94.503  1.00 11.90           C  
ATOM    206  O   TYR A  28      24.862  34.860  95.487  1.00 12.18           O  
ATOM    207  CB  TYR A  28      23.264  37.343  93.991  1.00 12.61           C  
ATOM    208  CG  TYR A  28      23.390  37.719  95.457  1.00 12.59           C  
ATOM    209  CD1 TYR A  28      24.484  38.464  95.902  1.00 15.50           C  
ATOM    210  CD2 TYR A  28      22.465  37.249  96.412  1.00 13.38           C  
ATOM    211  CE1 TYR A  28      24.628  38.803  97.259  1.00 14.55           C  
ATOM    212  CE2 TYR A  28      22.599  37.580  97.772  1.00 14.78           C  
ATOM    213  CZ  TYR A  28      23.691  38.343  98.179  1.00 15.56           C  
ATOM    214  OH  TYR A  28      23.869  38.653  99.511  1.00 14.75           O  
ATOM    215  N   THR A  29      23.121  34.192  94.194  1.00 11.79           N  
ATOM    216  CA  THR A  29      22.852  32.999  95.006  1.00 12.39           C  
ATOM    217  C   THR A  29      24.018  32.024  94.990  1.00 12.20           C  
ATOM    218  O   THR A  29      24.463  31.589  96.039  1.00 12.75           O  
ATOM    219  CB  THR A  29      21.528  32.315  94.603  1.00 12.97           C  
ATOM    220  OG1 THR A  29      20.478  33.287  94.685  1.00 12.12           O  
ATOM    221  CG2 THR A  29      21.192  31.133  95.573  1.00 13.22           C  
ATOM    222  N   PHE A  30      24.511  31.690  93.803  1.00 12.46           N  
ATOM    223  CA  PHE A  30      25.673  30.806  93.686  1.00 13.20           C  
ATOM    224  C   PHE A  30      26.931  31.382  94.352  1.00 13.75           C  
ATOM    225  O   PHE A  30      27.680  30.622  94.995  1.00 13.88           O  
ATOM    226  CB  PHE A  30      25.914  30.422  92.230  1.00 13.15           C  
ATOM    227  CG  PHE A  30      24.721  29.730  91.584  1.00 13.22           C  
ATOM    228  CD1 PHE A  30      24.152  28.598  92.168  1.00 16.36           C  
ATOM    229  CD2 PHE A  30      24.188  30.205  90.398  1.00 14.93           C  
ATOM    230  CE1 PHE A  30      23.041  27.945  91.567  1.00 18.19           C  
ATOM    231  CE2 PHE A  30      23.086  29.580  89.800  1.00 14.46           C  
ATOM    232  CZ  PHE A  30      22.510  28.446  90.395  1.00 14.83           C  
ATOM    233  N   LYS A  31      27.160  32.689  94.213  1.00 13.06           N  
ATOM    234  CA  LYS A  31      28.255  33.367  94.954  1.00 13.57           C  
ATOM    235  C   LYS A  31      28.104  33.140  96.481  1.00 13.84           C  
ATOM    236  O   LYS A  31      29.053  32.772  97.166  1.00 12.80           O  
ATOM    237  CB  LYS A  31      28.307  34.865  94.630  1.00 12.95           C  
ATOM    238  CG  LYS A  31      29.162  35.689  95.641  1.00 13.54           C  
ATOM    239  CD  LYS A  31      29.159  37.163  95.360  1.00 15.32           C  
ATOM    240  CE  LYS A  31      29.974  37.891  96.416  1.00 17.65           C  
ATOM    241  NZ  LYS A  31      30.276  39.308  96.038  1.00 21.78           N  
ATOM    242  N   GLU A  32      26.895  33.331  97.008  1.00 14.04           N  
ATOM    243  CA  GLU A  32      26.690  33.191  98.454  1.00 14.76           C  
ATOM    244  C   GLU A  32      26.839  31.760  98.924  1.00 15.35           C  
ATOM    245  O   GLU A  32      27.356  31.504 100.042  1.00 14.61           O  
ATOM    246  CB  GLU A  32      25.330  33.773  98.876  1.00 14.43           C  
ATOM    247  CG  GLU A  32      25.248  35.314  98.766  1.00 15.48           C  
ATOM    248  CD  GLU A  32      26.365  36.015  99.541  1.00 17.58           C  
ATOM    249  OE1 GLU A  32      26.472  35.781 100.754  1.00 19.50           O  
ATOM    250  OE2 GLU A  32      27.149  36.765  98.928  1.00 17.93           O  
ATOM    251  N   LEU A  33      26.414  30.822  98.075  1.00 16.20           N  
ATOM    252  CA  LEU A  33      26.519  29.394  98.392  1.00 17.71           C  
ATOM    253  C   LEU A  33      27.935  28.831  98.149  1.00 18.56           C  
ATOM    254  O   LEU A  33      28.249  27.701  98.552  1.00 19.15           O  
ATOM    255  CB  LEU A  33      25.464  28.601  97.625  1.00 17.81           C  
ATOM    256  CG  LEU A  33      24.003  28.916  97.987  1.00 18.32           C  
ATOM    257  CD1 LEU A  33      23.052  28.060  97.168  1.00 19.84           C  
ATOM    258  CD2 LEU A  33      23.694  28.781  99.484  1.00 21.45           C  
ATOM    259  N   GLY A  34      28.766  29.626  97.487  1.00 19.11           N  
ATOM    260  CA  GLY A  34      30.155  29.287  97.214  1.00 19.99           C  
ATOM    261  C   GLY A  34      30.310  28.208  96.159  1.00 20.97           C  
ATOM    262  O   GLY A  34      31.169  27.340  96.287  1.00 21.37           O  
ATOM    263  N   VAL A  35      29.459  28.255  95.137  1.00 20.85           N  
ATOM    264  CA  VAL A  35      29.426  27.253  94.059  1.00 21.38           C  
ATOM    265  C   VAL A  35      29.569  27.938  92.708  1.00 21.16           C  
ATOM    266  O   VAL A  35      29.134  29.079  92.549  1.00 20.13           O  
ATOM    267  CB  VAL A  35      28.111  26.422  94.057  1.00 21.80           C  
ATOM    268  CG1 VAL A  35      27.953  25.630  95.355  1.00 24.02           C  
ATOM    269  CG2 VAL A  35      26.919  27.305  93.827  1.00 22.67           C  
ATOM    270  N   PRO A  36      30.209  27.264  91.725  1.00 21.04           N  
ATOM    271  CA  PRO A  36      30.329  27.931  90.430  1.00 21.11           C  
ATOM    272  C   PRO A  36      28.962  28.225  89.822  1.00 21.32           C  
ATOM    273  O   PRO A  36      28.009  27.416  89.965  1.00 21.87           O  
ATOM    274  CB  PRO A  36      31.129  26.925  89.583  1.00 21.21           C  
ATOM    275  CG  PRO A  36      31.914  26.117  90.630  1.00 21.05           C  
ATOM    276  CD  PRO A  36      30.897  25.960  91.740  1.00 21.40           C  
ATOM    277  N   SER A  37      28.851  29.389  89.193  1.00 20.85           N  
ATOM    278  CA  SER A  37      27.658  29.717  88.440  1.00 21.56           C  
ATOM    279  C   SER A  37      27.615  28.910  87.138  1.00 21.55           C  
ATOM    280  O   SER A  37      28.637  28.780  86.455  1.00 20.71           O  
ATOM    281  CB  SER A  37      27.642  31.208  88.110  1.00 21.59           C  
ATOM    282  OG  SER A  37      26.500  31.523  87.329  1.00 26.67           O  
ATOM    283  N   PRO A  38      26.429  28.377  86.779  1.00 21.24           N  
ATOM    284  CA  PRO A  38      26.198  27.869  85.420  1.00 21.16           C  
ATOM    285  C   PRO A  38      26.383  28.960  84.355  1.00 21.10           C  
ATOM    286  O   PRO A  38      26.364  30.162  84.668  1.00 20.50           O  
ATOM    287  CB  PRO A  38      24.705  27.486  85.452  1.00 21.11           C  
ATOM    288  CG  PRO A  38      24.398  27.224  86.831  1.00 22.33           C  
ATOM    289  CD  PRO A  38      25.241  28.198  87.625  1.00 21.72           C  
ATOM    290  N   ASP A  39      26.535  28.554  83.098  1.00 21.58           N  
ATOM    291  CA  ASP A  39      26.710  29.531  82.022  1.00 22.88           C  
ATOM    292  C   ASP A  39      25.406  30.276  81.674  1.00 22.78           C  
ATOM    293  O   ASP A  39      24.319  29.915  82.153  1.00 22.95           O  
ATOM    294  CB  ASP A  39      27.389  28.890  80.786  1.00 23.49           C  
ATOM    295  CG  ASP A  39      26.559  27.768  80.145  1.00 26.03           C  
ATOM    296  OD1 ASP A  39      25.310  27.818  80.193  1.00 26.06           O  
ATOM    297  OD2 ASP A  39      27.165  26.835  79.558  1.00 30.47           O  
ATOM    298  N   ALA A  40      25.524  31.321  80.862  1.00 23.40           N  
ATOM    299  CA  ALA A  40      24.392  32.175  80.502  1.00 23.43           C  
ATOM    300  C   ALA A  40      23.256  31.411  79.824  1.00 24.15           C  
ATOM    301  O   ALA A  40      22.081  31.675  80.094  1.00 23.26           O  
ATOM    302  CB  ALA A  40      24.866  33.336  79.632  1.00 23.89           C  
ATOM    303  N   LYS A  41      23.600  30.453  78.955  1.00 24.82           N  
ATOM    304  CA  LYS A  41      22.557  29.649  78.303  1.00 25.58           C  
ATOM    305  C   LYS A  41      21.762  28.866  79.337  1.00 24.17           C  
ATOM    306  O   LYS A  41      20.538  28.927  79.330  1.00 24.77           O  
ATOM    307  CB  LYS A  41      23.114  28.723  77.218  1.00 25.64           C  
ATOM    308  CG  LYS A  41      22.035  28.329  76.196  1.00 27.84           C  
ATOM    309  CD  LYS A  41      22.587  27.460  75.046  1.00 28.80           C  
ATOM    310  CE  LYS A  41      23.970  27.951  74.522  1.00 34.18           C  
ATOM    311  NZ  LYS A  41      23.963  29.313  73.884  1.00 36.23           N  
ATOM    312  N   THR A  42      22.459  28.168  80.231  1.00 23.08           N  
ATOM    313  CA  THR A  42      21.821  27.429  81.333  1.00 22.01           C  
ATOM    314  C   THR A  42      20.900  28.335  82.145  1.00 20.74           C  
ATOM    315  O   THR A  42      19.741  27.985  82.378  1.00 20.54           O  
ATOM    316  CB  THR A  42      22.873  26.727  82.224  1.00 21.66           C  
ATOM    317  OG1 THR A  42      23.621  25.812  81.412  1.00 24.63           O  
ATOM    318  CG2 THR A  42      22.224  25.969  83.380  1.00 22.46           C  
ATOM    319  N   ILE A  43      21.389  29.514  82.541  1.00 19.73           N  
ATOM    320  CA  ILE A  43      20.560  30.449  83.335  1.00 18.95           C  
ATOM    321  C   ILE A  43      19.355  30.988  82.549  1.00 20.03           C  
ATOM    322  O   ILE A  43      18.269  31.182  83.121  1.00 19.78           O  
ATOM    323  CB  ILE A  43      21.404  31.574  84.031  1.00 18.67           C  
ATOM    324  CG1 ILE A  43      22.367  30.942  85.044  1.00 17.26           C  
ATOM    325  CG2 ILE A  43      20.491  32.619  84.728  1.00 18.57           C  
ATOM    326  CD1 ILE A  43      23.445  31.892  85.597  1.00 19.00           C  
ATOM    327  N   ARG A  44      19.520  31.173  81.234  1.00 20.57           N  
ATOM    328  CA  ARG A  44      18.382  31.499  80.359  1.00 22.36           C  
ATOM    329  C   ARG A  44      17.262  30.457  80.488  1.00 21.90           C  
ATOM    330  O   ARG A  44      16.060  30.795  80.478  1.00 21.81           O  
ATOM    331  CB  ARG A  44      18.841  31.615  78.890  1.00 21.57           C  
ATOM    332  CG  ARG A  44      19.443  32.975  78.561  1.00 25.79           C  
ATOM    333  CD  ARG A  44      19.498  33.270  77.050  1.00 26.23           C  
ATOM    334  NE  ARG A  44      20.621  32.628  76.353  1.00 30.90           N  
ATOM    335  CZ  ARG A  44      21.897  32.994  76.463  1.00 34.18           C  
ATOM    336  NH1 ARG A  44      22.244  33.988  77.267  1.00 36.62           N  
ATOM    337  NH2 ARG A  44      22.833  32.346  75.785  1.00 35.16           N  
ATOM    338  N   GLY A  45      17.673  29.199  80.638  1.00 22.31           N  
ATOM    339  CA  GLY A  45      16.778  28.068  80.775  1.00 21.90           C  
ATOM    340  C   GLY A  45      16.020  28.090  82.088  1.00 22.67           C  
ATOM    341  O   GLY A  45      14.975  27.459  82.204  1.00 22.98           O  
ATOM    342  N   PHE A  46      16.552  28.817  83.082  1.00 22.35           N  
ATOM    343  CA  PHE A  46      15.856  29.012  84.363  1.00 22.65           C  
ATOM    344  C   PHE A  46      14.777  30.126  84.351  1.00 23.13           C  
ATOM    345  O   PHE A  46      14.131  30.381  85.379  1.00 22.62           O  
ATOM    346  CB  PHE A  46      16.840  29.327  85.502  1.00 22.01           C  
ATOM    347  CG  PHE A  46      17.909  28.283  85.752  1.00 20.78           C  
ATOM    348  CD1 PHE A  46      17.819  26.986  85.244  1.00 22.07           C  
ATOM    349  CD2 PHE A  46      19.010  28.615  86.559  1.00 19.41           C  
ATOM    350  CE1 PHE A  46      18.833  26.043  85.505  1.00 23.00           C  
ATOM    351  CE2 PHE A  46      20.020  27.677  86.833  1.00 19.26           C  
ATOM    352  CZ  PHE A  46      19.934  26.400  86.302  1.00 22.79           C  
HETATM  353  N   MSE A  47      14.611  30.811  83.224  1.00 24.16           N  
HETATM  354  CA  MSE A  47      13.637  31.906  83.115  1.00 26.39           C  
HETATM  355  C   MSE A  47      12.284  31.383  82.626  1.00 26.04           C  
HETATM  356  O   MSE A  47      12.054  31.267  81.417  1.00 27.20           O  
HETATM  357  CB  MSE A  47      14.184  33.009  82.196  1.00 25.69           C  
HETATM  358  CG  MSE A  47      15.558  33.490  82.647  1.00 25.97           C  
HETATM  359 SE   MSE A  47      16.338  34.894  81.536  1.00 31.50          SE  
HETATM  360  CE  MSE A  47      18.142  35.125  82.589  1.00 25.31           C  
ATOM    361  N   GLY A  48      11.387  31.085  83.562  1.00 25.63           N  
ATOM    362  CA  GLY A  48      10.138  30.380  83.225  1.00 25.09           C  
ATOM    363  C   GLY A  48       9.757  29.261  84.179  1.00 24.52           C  
ATOM    364  O   GLY A  48       8.667  29.290  84.750  1.00 25.66           O  
ATOM    365  N   PRO A  49      10.636  28.251  84.359  1.00 23.66           N  
ATOM    366  CA  PRO A  49      10.336  27.183  85.311  1.00 23.29           C  
ATOM    367  C   PRO A  49      10.268  27.693  86.754  1.00 23.07           C  
ATOM    368  O   PRO A  49      10.814  28.777  87.041  1.00 22.76           O  
ATOM    369  CB  PRO A  49      11.512  26.203  85.130  1.00 23.36           C  
ATOM    370  CG  PRO A  49      12.121  26.558  83.847  1.00 22.12           C  
ATOM    371  CD  PRO A  49      11.926  28.022  83.686  1.00 23.66           C  
ATOM    372  N   PRO A  50       9.605  26.931  87.661  1.00 22.90           N  
ATOM    373  CA  PRO A  50       9.641  27.318  89.070  1.00 22.78           C  
ATOM    374  C   PRO A  50      11.092  27.397  89.585  1.00 22.24           C  
ATOM    375  O   PRO A  50      11.957  26.614  89.176  1.00 20.76           O  
ATOM    376  CB  PRO A  50       8.887  26.183  89.778  1.00 23.05           C  
ATOM    377  CG  PRO A  50       8.026  25.573  88.730  1.00 24.03           C  
ATOM    378  CD  PRO A  50       8.808  25.707  87.453  1.00 23.14           C  
ATOM    379  N   LEU A  51      11.335  28.359  90.464  1.00 22.81           N  
ATOM    380  CA  LEU A  51      12.647  28.571  91.068  1.00 23.69           C  
ATOM    381  C   LEU A  51      13.232  27.297  91.709  1.00 24.34           C  
ATOM    382  O   LEU A  51      14.408  26.938  91.480  1.00 23.56           O  
ATOM    383  CB  LEU A  51      12.526  29.694  92.104  1.00 23.88           C  
ATOM    384  CG  LEU A  51      13.746  30.544  92.410  1.00 24.58           C  
ATOM    385  CD1 LEU A  51      14.377  31.170  91.141  1.00 23.11           C  
ATOM    386  CD2 LEU A  51      13.358  31.626  93.424  1.00 23.47           C  
ATOM    387  N   GLU A  52      12.399  26.619  92.501  1.00 24.48           N  
ATOM    388  CA  GLU A  52      12.808  25.395  93.191  1.00 25.72           C  
ATOM    389  C   GLU A  52      13.261  24.328  92.198  1.00 25.32           C  
ATOM    390  O   GLU A  52      14.268  23.654  92.429  1.00 25.09           O  
ATOM    391  CB  GLU A  52      11.697  24.874  94.109  1.00 26.83           C  
ATOM    392  CG  GLU A  52      11.391  25.816  95.288  1.00 30.01           C  
ATOM    393  CD  GLU A  52      10.242  26.802  95.036  1.00 33.47           C  
ATOM    394  OE1 GLU A  52       9.955  27.179  93.859  1.00 34.15           O  
ATOM    395  OE2 GLU A  52       9.613  27.199  96.051  1.00 35.17           O  
ATOM    396  N   SER A  53      12.558  24.228  91.070  1.00 24.78           N  
ATOM    397  CA  SER A  53      12.921  23.273  90.026  1.00 24.62           C  
ATOM    398  C   SER A  53      14.285  23.563  89.394  1.00 23.58           C  
ATOM    399  O   SER A  53      15.092  22.648  89.187  1.00 23.21           O  
ATOM    400  CB  SER A  53      11.843  23.229  88.950  1.00 24.87           C  
ATOM    401  OG  SER A  53      12.071  22.118  88.096  1.00 28.56           O  
ATOM    402  N   SER A  54      14.536  24.834  89.082  1.00 22.13           N  
ATOM    403  CA  SER A  54      15.833  25.250  88.563  1.00 21.69           C  
ATOM    404  C   SER A  54      16.974  24.956  89.516  1.00 21.04           C  
ATOM    405  O   SER A  54      17.967  24.358  89.107  1.00 20.99           O  
ATOM    406  CB  SER A  54      15.822  26.729  88.184  1.00 21.12           C  
ATOM    407  OG  SER A  54      14.952  26.925  87.076  1.00 21.80           O  
ATOM    408  N   PHE A  55      16.846  25.387  90.771  1.00 21.09           N  
ATOM    409  CA  PHE A  55      17.889  25.125  91.768  1.00 21.70           C  
ATOM    410  C   PHE A  55      18.110  23.626  91.996  1.00 22.24           C  
ATOM    411  O   PHE A  55      19.226  23.194  92.276  1.00 22.41           O  
ATOM    412  CB  PHE A  55      17.579  25.815  93.099  1.00 20.90           C  
ATOM    413  CG  PHE A  55      17.918  27.296  93.123  1.00 19.03           C  
ATOM    414  CD1 PHE A  55      16.965  28.225  93.525  1.00 17.81           C  
ATOM    415  CD2 PHE A  55      19.197  27.749  92.785  1.00 17.74           C  
ATOM    416  CE1 PHE A  55      17.264  29.584  93.583  1.00 17.34           C  
ATOM    417  CE2 PHE A  55      19.505  29.114  92.829  1.00 18.20           C  
ATOM    418  CZ  PHE A  55      18.532  30.038  93.222  1.00 18.78           C  
ATOM    419  N   ALA A  56      17.050  22.837  91.882  1.00 23.47           N  
ATOM    420  CA  ALA A  56      17.207  21.376  91.971  1.00 24.49           C  
ATOM    421  C   ALA A  56      18.168  20.825  90.900  1.00 25.54           C  
ATOM    422  O   ALA A  56      18.871  19.846  91.141  1.00 25.94           O  
ATOM    423  CB  ALA A  56      15.852  20.672  91.923  1.00 24.60           C  
ATOM    424  N   THR A  57      18.247  21.467  89.737  1.00 26.50           N  
ATOM    425  CA  THR A  57      19.174  20.995  88.704  1.00 27.47           C  
ATOM    426  C   THR A  57      20.660  21.108  89.075  1.00 28.47           C  
ATOM    427  O   THR A  57      21.498  20.398  88.502  1.00 28.96           O  
ATOM    428  CB  THR A  57      18.911  21.622  87.312  1.00 27.63           C  
ATOM    429  OG1 THR A  57      19.236  23.015  87.328  1.00 27.96           O  
ATOM    430  CG2 THR A  57      17.447  21.415  86.884  1.00 26.93           C  
ATOM    431  N   CYS A  58      20.999  21.973  90.031  1.00 29.00           N  
ATOM    432  CA  CYS A  58      22.413  22.267  90.289  1.00 29.59           C  
ATOM    433  C   CYS A  58      22.839  22.324  91.755  1.00 29.35           C  
ATOM    434  O   CYS A  58      24.006  22.580  92.047  1.00 29.77           O  
ATOM    435  CB  CYS A  58      22.808  23.570  89.578  1.00 30.14           C  
ATOM    436  SG  CYS A  58      21.688  24.928  89.923  1.00 33.09           S  
ATOM    437  N   LEU A  59      21.895  22.122  92.672  1.00 28.83           N  
ATOM    438  CA  LEU A  59      22.181  22.147  94.100  1.00 28.48           C  
ATOM    439  C   LEU A  59      21.652  20.894  94.784  1.00 28.54           C  
ATOM    440  O   LEU A  59      20.733  20.248  94.291  1.00 28.11           O  
ATOM    441  CB  LEU A  59      21.552  23.380  94.762  1.00 27.53           C  
ATOM    442  CG  LEU A  59      22.018  24.776  94.372  1.00 26.79           C  
ATOM    443  CD1 LEU A  59      21.180  25.796  95.139  1.00 26.29           C  
ATOM    444  CD2 LEU A  59      23.510  24.979  94.632  1.00 27.63           C  
ATOM    445  N   SER A  60      22.217  20.565  95.943  1.00 29.56           N  
ATOM    446  CA  SER A  60      21.669  19.481  96.749  1.00 30.02           C  
ATOM    447  C   SER A  60      20.304  19.873  97.266  1.00 30.59           C  
ATOM    448  O   SER A  60      20.064  21.042  97.588  1.00 29.69           O  
ATOM    449  CB  SER A  60      22.601  19.122  97.907  1.00 30.45           C  
ATOM    450  OG  SER A  60      23.806  18.584  97.402  1.00 31.93           O  
ATOM    451  N   LYS A  61      19.418  18.883  97.340  1.00 31.03           N  
ATOM    452  CA  LYS A  61      18.029  19.076  97.764  1.00 31.99           C  
ATOM    453  C   LYS A  61      17.906  19.826  99.107  1.00 31.99           C  
ATOM    454  O   LYS A  61      17.048  20.711  99.258  1.00 32.07           O  
ATOM    455  CB  LYS A  61      17.311  17.714  97.787  1.00 32.11           C  
ATOM    456  CG  LYS A  61      15.833  17.724  98.186  1.00 33.37           C  
ATOM    457  CD  LYS A  61      15.331  16.303  98.437  1.00 33.21           C  
ATOM    458  CE  LYS A  61      16.020  15.681  99.684  1.00 35.16           C  
ATOM    459  NZ  LYS A  61      15.482  14.343 100.135  1.00 33.65           N  
ATOM    460  N   ASP A  62      18.784  19.491 100.055  1.00 31.39           N  
ATOM    461  CA  ASP A  62      18.838  20.157 101.363  1.00 31.23           C  
ATOM    462  C   ASP A  62      19.182  21.651 101.291  1.00 30.01           C  
ATOM    463  O   ASP A  62      18.994  22.372 102.272  1.00 29.90           O  
ATOM    464  CB  ASP A  62      19.863  19.468 102.263  1.00 31.94           C  
ATOM    465  CG  ASP A  62      21.194  19.267 101.564  1.00 35.04           C  
ATOM    466  OD1 ASP A  62      21.316  18.274 100.809  1.00 38.57           O  
ATOM    467  OD2 ASP A  62      22.111  20.105 101.749  1.00 38.34           O  
ATOM    468  N   GLN A  63      19.690  22.112 100.149  1.00 28.41           N  
ATOM    469  CA  GLN A  63      20.049  23.536  99.998  1.00 26.95           C  
ATOM    470  C   GLN A  63      19.037  24.400  99.216  1.00 25.10           C  
ATOM    471  O   GLN A  63      19.207  25.624  99.133  1.00 23.80           O  
ATOM    472  CB  GLN A  63      21.446  23.685  99.405  1.00 27.61           C  
ATOM    473  CG  GLN A  63      22.545  23.621 100.458  1.00 30.72           C  
ATOM    474  CD  GLN A  63      23.828  24.301 100.027  1.00 34.10           C  
ATOM    475  OE1 GLN A  63      24.385  24.000  98.963  1.00 35.33           O  
ATOM    476  NE2 GLN A  63      24.319  25.225 100.865  1.00 33.76           N  
ATOM    477  N   ILE A  64      17.994  23.773  98.667  1.00 23.43           N  
ATOM    478  CA  ILE A  64      17.061  24.491  97.770  1.00 21.63           C  
ATOM    479  C   ILE A  64      16.364  25.640  98.465  1.00 20.61           C  
ATOM    480  O   ILE A  64      16.287  26.743  97.909  1.00 19.74           O  
ATOM    481  CB  ILE A  64      15.977  23.557  97.120  1.00 22.53           C  
ATOM    482  CG1 ILE A  64      16.628  22.420  96.328  1.00 23.53           C  
ATOM    483  CG2 ILE A  64      15.019  24.358  96.233  1.00 21.46           C  
ATOM    484  CD1 ILE A  64      17.793  22.838  95.503  1.00 24.78           C  
ATOM    485  N   SER A  65      15.827  25.373  99.656  1.00 20.01           N  
ATOM    486  CA  SER A  65      15.091  26.372 100.436  1.00 19.82           C  
ATOM    487  C   SER A  65      15.965  27.588 100.743  1.00 18.47           C  
ATOM    488  O   SER A  65      15.526  28.732 100.595  1.00 18.46           O  
ATOM    489  CB  SER A  65      14.553  25.752 101.736  1.00 20.88           C  
ATOM    490  OG  SER A  65      13.784  26.699 102.454  1.00 25.34           O  
ATOM    491  N   GLU A  66      17.206  27.335 101.163  1.00 17.34           N  
ATOM    492  CA  GLU A  66      18.169  28.427 101.410  1.00 17.32           C  
ATOM    493  C   GLU A  66      18.438  29.215 100.122  1.00 15.85           C  
ATOM    494  O   GLU A  66      18.456  30.453 100.125  1.00 14.97           O  
ATOM    495  CB  GLU A  66      19.488  27.864 101.948  1.00 16.64           C  
ATOM    496  CG  GLU A  66      20.586  28.905 102.202  1.00 18.94           C  
ATOM    497  CD  GLU A  66      21.937  28.273 102.539  1.00 19.13           C  
ATOM    498  OE1 GLU A  66      22.054  27.038 102.513  1.00 25.68           O  
ATOM    499  OE2 GLU A  66      22.902  29.015 102.806  1.00 25.36           O  
ATOM    500  N   ALA A  67      18.680  28.482  99.037  1.00 15.40           N  
ATOM    501  CA  ALA A  67      18.887  29.103  97.713  1.00 15.62           C  
ATOM    502  C   ALA A  67      17.713  30.003  97.316  1.00 15.80           C  
ATOM    503  O   ALA A  67      17.926  31.135  96.902  1.00 15.07           O  
ATOM    504  CB  ALA A  67      19.142  28.053  96.645  1.00 15.50           C  
ATOM    505  N   VAL A  68      16.477  29.503  97.440  1.00 15.81           N  
ATOM    506  CA  VAL A  68      15.289  30.306  97.122  1.00 16.61           C  
ATOM    507  C   VAL A  68      15.205  31.570  97.974  1.00 15.55           C  
ATOM    508  O   VAL A  68      14.928  32.656  97.465  1.00 15.53           O  
ATOM    509  CB  VAL A  68      13.988  29.459  97.235  1.00 16.61           C  
ATOM    510  CG1 VAL A  68      12.730  30.337  97.084  1.00 19.48           C  
ATOM    511  CG2 VAL A  68      14.015  28.379  96.174  1.00 18.52           C  
ATOM    512  N   GLN A  69      15.459  31.431  99.270  1.00 15.34           N  
ATOM    513  CA  GLN A  69      15.495  32.592 100.149  1.00 15.59           C  
ATOM    514  C   GLN A  69      16.505  33.639  99.710  1.00 15.11           C  
ATOM    515  O   GLN A  69      16.166  34.823  99.630  1.00 15.19           O  
ATOM    516  CB  GLN A  69      15.741  32.178 101.600  1.00 15.54           C  
ATOM    517  CG  GLN A  69      15.789  33.363 102.572  1.00 16.15           C  
ATOM    518  CD  GLN A  69      16.082  32.918 104.005  1.00 18.11           C  
ATOM    519  OE1 GLN A  69      15.472  31.983 104.489  1.00 24.68           O  
ATOM    520  NE2 GLN A  69      17.009  33.595 104.678  1.00 16.49           N  
ATOM    521  N   ILE A  70      17.730  33.213  99.416  1.00 14.93           N  
ATOM    522  CA  ILE A  70      18.801  34.134  99.039  1.00 15.26           C  
ATOM    523  C   ILE A  70      18.439  34.817  97.697  1.00 15.14           C  
ATOM    524  O   ILE A  70      18.534  36.033  97.554  1.00 15.79           O  
ATOM    525  CB  ILE A  70      20.183  33.413  98.983  1.00 15.57           C  
ATOM    526  CG1 ILE A  70      20.646  32.990 100.391  1.00 14.53           C  
ATOM    527  CG2 ILE A  70      21.256  34.306  98.334  1.00 14.43           C  
ATOM    528  CD1 ILE A  70      21.740  31.900 100.376  1.00 15.91           C  
ATOM    529  N   TYR A  71      18.014  34.018  96.721  1.00 15.43           N  
ATOM    530  CA  TYR A  71      17.576  34.552  95.431  1.00 14.87           C  
ATOM    531  C   TYR A  71      16.570  35.694  95.592  1.00 16.05           C  
ATOM    532  O   TYR A  71      16.702  36.761  94.989  1.00 15.31           O  
ATOM    533  CB  TYR A  71      16.967  33.419  94.596  1.00 15.05           C  
ATOM    534  CG  TYR A  71      16.446  33.884  93.240  1.00 14.54           C  
ATOM    535  CD1 TYR A  71      17.172  33.669  92.083  1.00 13.22           C  
ATOM    536  CD2 TYR A  71      15.217  34.533  93.143  1.00 14.63           C  
ATOM    537  CE1 TYR A  71      16.681  34.087  90.838  1.00 12.97           C  
ATOM    538  CE2 TYR A  71      14.725  34.962  91.926  1.00 15.12           C  
ATOM    539  CZ  TYR A  71      15.453  34.741  90.781  1.00 14.29           C  
ATOM    540  OH  TYR A  71      14.935  35.187  89.567  1.00 19.01           O  
ATOM    541  N   ARG A  72      15.556  35.454  96.393  1.00 17.90           N  
ATOM    542  CA  ARG A  72      14.515  36.461  96.585  1.00 20.95           C  
ATOM    543  C   ARG A  72      15.053  37.711  97.279  1.00 21.56           C  
ATOM    544  O   ARG A  72      14.586  38.825  96.986  1.00 22.39           O  
ATOM    545  CB  ARG A  72      13.319  35.872  97.313  1.00 21.24           C  
ATOM    546  CG  ARG A  72      12.673  34.729  96.570  1.00 24.51           C  
ATOM    547  CD  ARG A  72      11.209  34.659  96.867  1.00 31.76           C  
ATOM    548  NE  ARG A  72      10.517  33.673  96.028  1.00 35.23           N  
ATOM    549  CZ  ARG A  72      10.296  33.801  94.714  1.00 37.72           C  
ATOM    550  NH1 ARG A  72      10.740  34.862  94.052  1.00 37.85           N  
ATOM    551  NH2 ARG A  72       9.650  32.842  94.051  1.00 39.11           N  
ATOM    552  N   SER A  73      16.061  37.528  98.142  1.00 22.10           N  
ATOM    553  CA  SER A  73      16.775  38.626  98.808  1.00 22.03           C  
ATOM    554  C   SER A  73      17.519  39.565  97.854  1.00 22.38           C  
ATOM    555  O   SER A  73      17.635  40.774  98.125  1.00 24.31           O  
ATOM    556  CB  SER A  73      17.751  38.095  99.891  1.00 21.70           C  
ATOM    557  OG  SER A  73      19.041  37.760  99.368  1.00 19.71           O  
ATOM    558  N   TYR A  74      18.053  39.030  96.759  1.00 21.62           N  
ATOM    559  CA  TYR A  74      18.606  39.881  95.731  1.00 20.45           C  
ATOM    560  C   TYR A  74      17.452  40.444  94.877  1.00 19.27           C  
ATOM    561  O   TYR A  74      17.409  41.646  94.579  1.00 18.51           O  
ATOM    562  CB  TYR A  74      19.624  39.129  94.864  1.00 20.52           C  
ATOM    563  CG  TYR A  74      20.246  40.005  93.804  1.00 21.76           C  
ATOM    564  CD1 TYR A  74      21.491  40.623  94.008  1.00 21.69           C  
ATOM    565  CD2 TYR A  74      19.577  40.252  92.612  1.00 20.01           C  
ATOM    566  CE1 TYR A  74      22.065  41.446  93.025  1.00 22.37           C  
ATOM    567  CE2 TYR A  74      20.132  41.080  91.632  1.00 21.74           C  
ATOM    568  CZ  TYR A  74      21.377  41.668  91.842  1.00 22.91           C  
ATOM    569  OH  TYR A  74      21.904  42.495  90.869  1.00 23.25           O  
ATOM    570  N   TYR A  75      16.505  39.586  94.510  1.00 18.82           N  
ATOM    571  CA  TYR A  75      15.517  39.977  93.493  1.00 18.70           C  
ATOM    572  C   TYR A  75      14.601  41.126  93.930  1.00 19.91           C  
ATOM    573  O   TYR A  75      14.376  42.086  93.173  1.00 18.92           O  
ATOM    574  CB  TYR A  75      14.704  38.774  92.997  1.00 17.42           C  
ATOM    575  CG  TYR A  75      14.051  39.119  91.685  1.00 16.23           C  
ATOM    576  CD1 TYR A  75      14.787  39.095  90.506  1.00 15.98           C  
ATOM    577  CD2 TYR A  75      12.726  39.536  91.636  1.00 17.25           C  
ATOM    578  CE1 TYR A  75      14.225  39.472  89.285  1.00 15.91           C  
ATOM    579  CE2 TYR A  75      12.142  39.930  90.412  1.00 14.78           C  
ATOM    580  CZ  TYR A  75      12.911  39.877  89.246  1.00 17.56           C  
ATOM    581  OH  TYR A  75      12.356  40.234  88.041  1.00 18.13           O  
ATOM    582  N   LYS A  76      14.075  41.027  95.148  1.00 21.66           N  
ATOM    583  CA  LYS A  76      13.164  42.056  95.682  1.00 23.01           C  
ATOM    584  C   LYS A  76      13.813  43.433  95.805  1.00 23.07           C  
ATOM    585  O   LYS A  76      13.199  44.459  95.462  1.00 23.62           O  
ATOM    586  CB  LYS A  76      12.573  41.601  97.033  1.00 24.00           C  
ATOM    587  CG  LYS A  76      11.574  40.445  96.909  1.00 24.85           C  
ATOM    588  CD  LYS A  76      10.279  40.879  96.162  1.00 30.30           C  
ATOM    589  CE  LYS A  76       9.073  40.981  97.091  1.00 28.95           C  
ATOM    590  NZ  LYS A  76       7.864  41.476  96.358  1.00 30.83           N  
ATOM    591  N   ALA A  77      15.058  43.459  96.257  1.00 22.86           N  
ATOM    592  CA  ALA A  77      15.781  44.705  96.505  1.00 22.92           C  
ATOM    593  C   ALA A  77      16.499  45.265  95.283  1.00 23.01           C  
ATOM    594  O   ALA A  77      16.703  46.478  95.192  1.00 22.85           O  
ATOM    595  CB  ALA A  77      16.786  44.520  97.660  1.00 23.13           C  
ATOM    596  N   LYS A  78      16.880  44.389  94.346  1.00 22.04           N  
ATOM    597  CA  LYS A  78      17.783  44.776  93.260  1.00 22.15           C  
ATOM    598  C   LYS A  78      17.355  44.234  91.893  1.00 20.42           C  
ATOM    599  O   LYS A  78      17.292  44.987  90.921  1.00 19.95           O  
ATOM    600  CB  LYS A  78      19.228  44.332  93.548  1.00 22.40           C  
ATOM    601  CG  LYS A  78      20.015  45.260  94.483  1.00 24.33           C  
ATOM    602  CD  LYS A  78      21.514  44.844  94.688  1.00 24.82           C  
ATOM    603  CE  LYS A  78      22.322  44.796  93.379  1.00 27.83           C  
ATOM    604  NZ  LYS A  78      22.496  46.139  92.743  1.00 30.13           N  
ATOM    605  N   GLY A  79      17.085  42.930  91.829  1.00 19.70           N  
ATOM    606  CA  GLY A  79      16.866  42.239  90.534  1.00 18.38           C  
ATOM    607  C   GLY A  79      15.661  42.769  89.783  1.00 17.80           C  
ATOM    608  O   GLY A  79      15.662  42.849  88.552  1.00 16.54           O  
ATOM    609  N   ILE A  80      14.628  43.109  90.541  1.00 17.50           N  
ATOM    610  CA  ILE A  80      13.353  43.555  89.993  1.00 17.78           C  
ATOM    611  C   ILE A  80      13.516  44.826  89.135  1.00 17.45           C  
ATOM    612  O   ILE A  80      12.755  45.023  88.178  1.00 17.77           O  
ATOM    613  CB  ILE A  80      12.308  43.774  91.130  1.00 18.02           C  
ATOM    614  CG1 ILE A  80      10.888  43.879  90.537  1.00 18.21           C  
ATOM    615  CG2 ILE A  80      12.738  44.954  92.036  1.00 18.72           C  
ATOM    616  CD1 ILE A  80       9.751  43.850  91.563  1.00 18.03           C  
ATOM    617  N   TYR A  81      14.490  45.671  89.498  1.00 17.33           N  
ATOM    618  CA  TYR A  81      14.806  46.937  88.787  1.00 18.05           C  
ATOM    619  C   TYR A  81      15.752  46.755  87.611  1.00 17.64           C  
ATOM    620  O   TYR A  81      15.942  47.671  86.789  1.00 17.32           O  
ATOM    621  CB  TYR A  81      15.415  47.963  89.764  1.00 18.35           C  
ATOM    622  CG  TYR A  81      14.569  48.186  90.959  1.00 19.13           C  
ATOM    623  CD1 TYR A  81      14.960  47.719  92.216  1.00 20.84           C  
ATOM    624  CD2 TYR A  81      13.322  48.822  90.841  1.00 21.24           C  
ATOM    625  CE1 TYR A  81      14.148  47.908  93.320  1.00 21.85           C  
ATOM    626  CE2 TYR A  81      12.508  49.003  91.935  1.00 22.36           C  
ATOM    627  CZ  TYR A  81      12.918  48.552  93.163  1.00 21.94           C  
ATOM    628  OH  TYR A  81      12.094  48.759  94.225  1.00 22.64           O  
ATOM    629  N   GLU A  82      16.385  45.595  87.552  1.00 16.89           N  
ATOM    630  CA  GLU A  82      17.267  45.255  86.447  1.00 17.43           C  
ATOM    631  C   GLU A  82      16.429  44.564  85.373  1.00 16.61           C  
ATOM    632  O   GLU A  82      16.541  43.344  85.130  1.00 16.69           O  
ATOM    633  CB  GLU A  82      18.415  44.376  86.945  1.00 17.75           C  
ATOM    634  CG  GLU A  82      19.202  45.101  88.057  1.00 20.41           C  
ATOM    635  CD  GLU A  82      20.358  44.304  88.614  1.00 25.15           C  
ATOM    636  OE1 GLU A  82      20.184  43.112  88.943  1.00 22.02           O  
ATOM    637  OE2 GLU A  82      21.457  44.897  88.726  1.00 27.60           O  
ATOM    638  N   ALA A  83      15.597  45.390  84.737  1.00 16.36           N  
ATOM    639  CA  ALA A  83      14.563  44.942  83.816  1.00 15.17           C  
ATOM    640  C   ALA A  83      14.159  46.128  82.937  1.00 15.61           C  
ATOM    641  O   ALA A  83      14.325  47.288  83.333  1.00 15.11           O  
ATOM    642  CB  ALA A  83      13.373  44.423  84.588  1.00 15.82           C  
ATOM    643  N   GLN A  84      13.663  45.827  81.743  1.00 14.36           N  
ATOM    644  CA  GLN A  84      13.294  46.840  80.775  1.00 15.07           C  
ATOM    645  C   GLN A  84      12.264  46.230  79.823  1.00 14.20           C  
ATOM    646  O   GLN A  84      12.279  45.016  79.564  1.00 15.09           O  
ATOM    647  CB  GLN A  84      14.539  47.324  80.027  1.00 15.33           C  
ATOM    648  CG  GLN A  84      15.165  46.285  79.099  1.00 15.55           C  
ATOM    649  CD  GLN A  84      16.560  46.683  78.602  1.00 18.16           C  
ATOM    650  OE1 GLN A  84      17.522  46.775  79.392  1.00 23.40           O  
ATOM    651  NE2 GLN A  84      16.680  46.902  77.301  1.00 21.39           N  
ATOM    652  N   LEU A  85      11.354  47.047  79.304  1.00 13.95           N  
ATOM    653  CA  LEU A  85      10.408  46.531  78.318  1.00 12.83           C  
ATOM    654  C   LEU A  85      11.144  46.040  77.087  1.00 13.80           C  
ATOM    655  O   LEU A  85      12.182  46.604  76.709  1.00 13.43           O  
ATOM    656  CB  LEU A  85       9.410  47.611  77.903  1.00 12.19           C  
ATOM    657  CG  LEU A  85       8.537  48.167  79.026  1.00 13.31           C  
ATOM    658  CD1 LEU A  85       7.618  49.243  78.452  1.00 17.35           C  
ATOM    659  CD2 LEU A  85       7.705  47.084  79.697  1.00 13.99           C  
ATOM    660  N   PHE A  86      10.609  45.008  76.446  1.00 13.51           N  
ATOM    661  CA  PHE A  86      11.104  44.642  75.119  1.00 15.16           C  
ATOM    662  C   PHE A  86      10.768  45.766  74.124  1.00 15.28           C  
ATOM    663  O   PHE A  86       9.849  46.550  74.359  1.00 14.93           O  
ATOM    664  CB  PHE A  86      10.485  43.309  74.648  1.00 15.69           C  
ATOM    665  CG  PHE A  86      11.105  42.106  75.278  1.00 16.10           C  
ATOM    666  CD1 PHE A  86      12.380  41.658  74.867  1.00 13.27           C  
ATOM    667  CD2 PHE A  86      10.436  41.403  76.279  1.00 14.73           C  
ATOM    668  CE1 PHE A  86      12.958  40.537  75.450  1.00 15.93           C  
ATOM    669  CE2 PHE A  86      11.036  40.264  76.876  1.00 14.03           C  
ATOM    670  CZ  PHE A  86      12.293  39.843  76.439  1.00 16.37           C  
ATOM    671  N   PRO A  87      11.524  45.858  73.014  1.00 16.64           N  
ATOM    672  CA  PRO A  87      11.224  46.917  72.027  1.00 16.84           C  
ATOM    673  C   PRO A  87       9.778  46.845  71.522  1.00 16.32           C  
ATOM    674  O   PRO A  87       9.255  45.753  71.427  1.00 16.65           O  
ATOM    675  CB  PRO A  87      12.193  46.599  70.896  1.00 17.07           C  
ATOM    676  CG  PRO A  87      13.362  45.886  71.593  1.00 18.08           C  
ATOM    677  CD  PRO A  87      12.692  45.034  72.631  1.00 16.69           C  
ATOM    678  N   GLN A  88       9.140  47.988  71.231  1.00 16.33           N  
ATOM    679  CA  GLN A  88       7.777  48.033  70.651  1.00 17.50           C  
ATOM    680  C   GLN A  88       6.626  47.542  71.575  1.00 15.94           C  
ATOM    681  O   GLN A  88       5.445  47.478  71.166  1.00 14.20           O  
ATOM    682  CB  GLN A  88       7.744  47.267  69.306  1.00 19.28           C  
ATOM    683  CG  GLN A  88       8.767  47.723  68.261  1.00 25.06           C  
ATOM    684  CD  GLN A  88       8.688  49.210  67.969  1.00 29.90           C  
ATOM    685  OE1 GLN A  88       9.616  49.966  68.276  1.00 33.52           O  
ATOM    686  NE2 GLN A  88       7.570  49.641  67.401  1.00 34.42           N  
ATOM    687  N   ILE A  89       6.942  47.188  72.820  1.00 14.14           N  
ATOM    688  CA  ILE A  89       5.882  46.726  73.727  1.00 13.35           C  
ATOM    689  C   ILE A  89       4.857  47.824  74.048  1.00 13.17           C  
ATOM    690  O   ILE A  89       3.653  47.567  74.048  1.00 13.15           O  
ATOM    691  CB  ILE A  89       6.445  46.084  75.044  1.00 13.54           C  
ATOM    692  CG1 ILE A  89       7.115  44.744  74.743  1.00 10.99           C  
ATOM    693  CG2 ILE A  89       5.322  45.883  76.069  1.00 13.18           C  
ATOM    694  CD1 ILE A  89       6.173  43.619  74.138  1.00 13.19           C  
ATOM    695  N   ILE A  90       5.325  49.044  74.325  1.00 13.08           N  
ATOM    696  CA  ILE A  90       4.403  50.176  74.542  1.00 13.80           C  
ATOM    697  C   ILE A  90       3.464  50.338  73.339  1.00 13.38           C  
ATOM    698  O   ILE A  90       2.248  50.472  73.520  1.00 12.88           O  
ATOM    699  CB  ILE A  90       5.129  51.519  74.867  1.00 14.46           C  
ATOM    700  CG1 ILE A  90       5.883  51.448  76.207  1.00 15.30           C  
ATOM    701  CG2 ILE A  90       4.128  52.679  74.931  1.00 15.03           C  
ATOM    702  CD1 ILE A  90       4.976  51.482  77.434  1.00 17.80           C  
ATOM    703  N   ASP A  91       4.031  50.319  72.125  1.00 12.83           N  
ATOM    704  CA  ASP A  91       3.214  50.382  70.886  1.00 13.33           C  
ATOM    705  C   ASP A  91       2.135  49.292  70.858  1.00 13.02           C  
ATOM    706  O   ASP A  91       0.960  49.575  70.581  1.00 13.37           O  
ATOM    707  CB  ASP A  91       4.082  50.308  69.634  1.00 13.05           C  
ATOM    708  CG  ASP A  91       3.376  50.870  68.389  1.00 14.59           C  
ATOM    709  OD1 ASP A  91       2.400  51.679  68.541  1.00 13.51           O  
ATOM    710  OD2 ASP A  91       3.822  50.500  67.278  1.00 12.59           O  
ATOM    711  N   LEU A  92       2.532  48.060  71.143  1.00 12.44           N  
ATOM    712  CA  LEU A  92       1.606  46.919  71.112  1.00 12.48           C  
ATOM    713  C   LEU A  92       0.490  47.117  72.120  1.00 12.85           C  
ATOM    714  O   LEU A  92      -0.696  46.907  71.815  1.00 11.64           O  
ATOM    715  CB  LEU A  92       2.362  45.625  71.459  1.00 13.16           C  
ATOM    716  CG  LEU A  92       1.474  44.394  71.606  1.00 13.73           C  
ATOM    717  CD1 LEU A  92       0.762  44.069  70.286  1.00 15.51           C  
ATOM    718  CD2 LEU A  92       2.357  43.240  72.074  1.00 14.41           C  
ATOM    719  N   LEU A  93       0.866  47.489  73.341  1.00 12.72           N  
ATOM    720  CA  LEU A  93      -0.151  47.723  74.376  1.00 13.27           C  
ATOM    721  C   LEU A  93      -1.126  48.873  74.067  1.00 14.33           C  
ATOM    722  O   LEU A  93      -2.332  48.712  74.238  1.00 14.61           O  
ATOM    723  CB  LEU A  93       0.514  47.960  75.725  1.00 13.62           C  
ATOM    724  CG  LEU A  93       1.293  46.762  76.262  1.00 13.37           C  
ATOM    725  CD1 LEU A  93       2.021  47.173  77.567  1.00 14.53           C  
ATOM    726  CD2 LEU A  93       0.338  45.561  76.467  1.00 14.68           C  
ATOM    727  N   GLU A  94      -0.605  50.019  73.641  1.00 14.74           N  
ATOM    728  CA  GLU A  94      -1.457  51.164  73.258  1.00 16.84           C  
ATOM    729  C   GLU A  94      -2.466  50.715  72.209  1.00 16.56           C  
ATOM    730  O   GLU A  94      -3.664  50.994  72.310  1.00 16.42           O  
ATOM    731  CB  GLU A  94      -0.609  52.323  72.686  1.00 16.46           C  
ATOM    732  CG  GLU A  94       0.312  53.029  73.633  1.00 20.70           C  
ATOM    733  CD  GLU A  94       1.212  54.052  72.916  1.00 21.00           C  
ATOM    734  OE1 GLU A  94       1.931  53.676  71.936  1.00 26.19           O  
ATOM    735  OE2 GLU A  94       1.235  55.231  73.355  1.00 27.18           O  
ATOM    736  N   GLU A  95      -1.994  49.968  71.211  1.00 16.83           N  
ATOM    737  CA  GLU A  95      -2.865  49.519  70.131  1.00 17.46           C  
ATOM    738  C   GLU A  95      -3.922  48.520  70.592  1.00 16.82           C  
ATOM    739  O   GLU A  95      -5.109  48.718  70.332  1.00 17.50           O  
ATOM    740  CB  GLU A  95      -2.032  48.943  68.985  1.00 17.74           C  
ATOM    741  CG  GLU A  95      -1.260  50.007  68.198  1.00 20.64           C  
ATOM    742  CD  GLU A  95      -2.201  51.058  67.603  1.00 26.99           C  
ATOM    743  OE1 GLU A  95      -3.093  50.665  66.825  1.00 27.27           O  
ATOM    744  OE2 GLU A  95      -2.063  52.255  67.939  1.00 27.54           O  
ATOM    745  N   LEU A  96      -3.512  47.473  71.307  1.00 15.51           N  
ATOM    746  CA  LEU A  96      -4.480  46.454  71.761  1.00 14.86           C  
ATOM    747  C   LEU A  96      -5.448  47.005  72.814  1.00 15.46           C  
ATOM    748  O   LEU A  96      -6.646  46.747  72.721  1.00 14.51           O  
ATOM    749  CB  LEU A  96      -3.779  45.195  72.290  1.00 15.08           C  
ATOM    750  CG  LEU A  96      -3.167  44.247  71.264  1.00 16.06           C  
ATOM    751  CD1 LEU A  96      -2.342  43.158  71.984  1.00 17.81           C  
ATOM    752  CD2 LEU A  96      -4.217  43.584  70.379  1.00 16.65           C  
ATOM    753  N   SER A  97      -4.931  47.795  73.759  1.00 16.97           N  
ATOM    754  CA  SER A  97      -5.753  48.345  74.860  1.00 18.95           C  
ATOM    755  C   SER A  97      -6.875  49.252  74.374  1.00 20.25           C  
ATOM    756  O   SER A  97      -7.897  49.402  75.064  1.00 20.31           O  
ATOM    757  CB  SER A  97      -4.883  49.091  75.865  1.00 19.41           C  
ATOM    758  OG  SER A  97      -4.407  50.286  75.288  1.00 22.05           O  
ATOM    759  N   SER A  98      -6.697  49.851  73.189  1.00 20.89           N  
ATOM    760  CA  SER A  98      -7.749  50.661  72.594  1.00 22.62           C  
ATOM    761  C   SER A  98      -8.918  49.838  72.025  1.00 22.14           C  
ATOM    762  O   SER A  98      -9.960  50.406  71.717  1.00 23.56           O  
ATOM    763  CB  SER A  98      -7.183  51.663  71.569  1.00 22.54           C  
ATOM    764  OG  SER A  98      -6.714  51.017  70.402  1.00 27.44           O  
ATOM    765  N   SER A  99      -8.771  48.511  71.923  1.00 20.75           N  
ATOM    766  CA  SER A  99      -9.839  47.643  71.414  1.00 19.99           C  
ATOM    767  C   SER A  99     -10.236  46.496  72.354  1.00 18.86           C  
ATOM    768  O   SER A  99     -11.279  45.859  72.166  1.00 18.75           O  
ATOM    769  CB  SER A  99      -9.439  47.035  70.055  1.00 20.92           C  
ATOM    770  OG  SER A  99      -9.190  48.053  69.094  1.00 23.14           O  
ATOM    771  N   TYR A 100      -9.397  46.215  73.351  1.00 16.09           N  
ATOM    772  CA  TYR A 100      -9.646  45.096  74.269  1.00 15.75           C  
ATOM    773  C   TYR A 100      -9.232  45.434  75.690  1.00 14.73           C  
ATOM    774  O   TYR A 100      -8.263  46.149  75.889  1.00 14.57           O  
ATOM    775  CB  TYR A 100      -8.779  43.882  73.877  1.00 15.84           C  
ATOM    776  CG  TYR A 100      -9.053  43.290  72.520  1.00 16.25           C  
ATOM    777  CD1 TYR A 100     -10.014  42.306  72.365  1.00 18.66           C  
ATOM    778  CD2 TYR A 100      -8.334  43.713  71.397  1.00 17.95           C  
ATOM    779  CE1 TYR A 100     -10.278  41.733  71.106  1.00 19.74           C  
ATOM    780  CE2 TYR A 100      -8.574  43.161  70.148  1.00 18.69           C  
ATOM    781  CZ  TYR A 100      -9.566  42.164  70.014  1.00 18.07           C  
ATOM    782  OH  TYR A 100      -9.837  41.596  68.782  1.00 20.59           O  
ATOM    783  N   PRO A 101      -9.938  44.855  76.684  1.00 14.35           N  
ATOM    784  CA  PRO A 101      -9.451  44.878  78.051  1.00 13.65           C  
ATOM    785  C   PRO A 101      -8.256  43.911  78.074  1.00 12.78           C  
ATOM    786  O   PRO A 101      -8.350  42.842  77.468  1.00 14.07           O  
ATOM    787  CB  PRO A 101     -10.636  44.323  78.859  1.00 13.78           C  
ATOM    788  CG  PRO A 101     -11.354  43.411  77.910  1.00 15.37           C  
ATOM    789  CD  PRO A 101     -11.192  44.082  76.541  1.00 14.54           C  
ATOM    790  N   LEU A 102      -7.160  44.319  78.705  1.00 11.96           N  
ATOM    791  CA  LEU A 102      -5.939  43.532  78.844  1.00 12.05           C  
ATOM    792  C   LEU A 102      -5.685  43.150  80.294  1.00 12.42           C  
ATOM    793  O   LEU A 102      -5.969  43.965  81.216  1.00 12.26           O  
ATOM    794  CB  LEU A 102      -4.737  44.352  78.393  1.00 11.70           C  
ATOM    795  CG  LEU A 102      -4.826  45.092  77.063  1.00 12.79           C  
ATOM    796  CD1 LEU A 102      -3.534  45.822  76.790  1.00 12.14           C  
ATOM    797  CD2 LEU A 102      -5.201  44.137  75.921  1.00 12.30           C  
ATOM    798  N   TYR A 103      -5.130  41.952  80.491  1.00 12.05           N  
ATOM    799  CA  TYR A 103      -4.825  41.435  81.838  1.00 12.07           C  
ATOM    800  C   TYR A 103      -3.438  40.835  81.849  1.00 13.10           C  
ATOM    801  O   TYR A 103      -2.988  40.232  80.845  1.00 13.91           O  
ATOM    802  CB  TYR A 103      -5.842  40.351  82.243  1.00 13.38           C  
ATOM    803  CG  TYR A 103      -7.243  40.883  82.186  1.00 13.31           C  
ATOM    804  CD1 TYR A 103      -7.760  41.607  83.259  1.00 13.04           C  
ATOM    805  CD2 TYR A 103      -8.011  40.753  81.022  1.00 13.93           C  
ATOM    806  CE1 TYR A 103      -9.037  42.144  83.208  1.00 14.53           C  
ATOM    807  CE2 TYR A 103      -9.321  41.272  80.967  1.00 13.55           C  
ATOM    808  CZ  TYR A 103      -9.807  41.970  82.066  1.00 15.11           C  
ATOM    809  OH  TYR A 103     -11.072  42.498  82.038  1.00 14.98           O  
ATOM    810  N   ILE A 104      -2.739  41.000  82.967  1.00 11.78           N  
ATOM    811  CA  ILE A 104      -1.564  40.174  83.164  1.00 12.17           C  
ATOM    812  C   ILE A 104      -1.939  38.897  83.931  1.00 12.28           C  
ATOM    813  O   ILE A 104      -2.652  38.951  84.957  1.00 11.91           O  
ATOM    814  CB  ILE A 104      -0.450  40.958  83.881  1.00 12.10           C  
ATOM    815  CG1 ILE A 104       0.136  41.985  82.911  1.00 14.43           C  
ATOM    816  CG2 ILE A 104       0.637  40.031  84.372  1.00 11.98           C  
ATOM    817  CD1 ILE A 104       0.867  43.120  83.600  1.00 14.19           C  
ATOM    818  N   THR A 105      -1.407  37.772  83.440  1.00 12.12           N  
ATOM    819  CA  THR A 105      -1.520  36.435  84.088  1.00 13.05           C  
ATOM    820  C   THR A 105      -0.122  35.807  84.207  1.00 13.91           C  
ATOM    821  O   THR A 105       0.432  35.316  83.224  1.00 13.13           O  
ATOM    822  CB  THR A 105      -2.442  35.488  83.305  1.00 13.69           C  
ATOM    823  OG1 THR A 105      -2.022  35.429  81.929  1.00 14.44           O  
ATOM    824  CG2 THR A 105      -3.845  35.940  83.379  1.00 11.69           C  
ATOM    825  N   THR A 106       0.469  35.890  85.400  1.00 14.18           N  
ATOM    826  CA  THR A 106       1.855  35.493  85.591  1.00 14.47           C  
ATOM    827  C   THR A 106       1.974  34.553  86.798  1.00 14.44           C  
ATOM    828  O   THR A 106       1.095  34.527  87.650  1.00 14.35           O  
ATOM    829  CB  THR A 106       2.767  36.743  85.825  1.00 13.96           C  
ATOM    830  OG1 THR A 106       4.140  36.324  85.960  1.00 14.39           O  
ATOM    831  CG2 THR A 106       2.312  37.548  87.086  1.00 15.25           C  
ATOM    832  N   THR A 107       3.067  33.792  86.874  1.00 15.13           N  
ATOM    833  CA  THR A 107       3.307  33.016  88.090  1.00 16.10           C  
ATOM    834  C   THR A 107       4.309  33.728  88.997  1.00 16.23           C  
ATOM    835  O   THR A 107       4.656  33.196  90.042  1.00 16.14           O  
ATOM    836  CB  THR A 107       3.746  31.575  87.819  1.00 17.10           C  
ATOM    837  OG1 THR A 107       4.850  31.591  86.916  1.00 18.62           O  
ATOM    838  CG2 THR A 107       2.596  30.758  87.234  1.00 18.60           C  
ATOM    839  N   LYS A 108       4.763  34.926  88.615  1.00 16.13           N  
ATOM    840  CA  LYS A 108       5.343  35.871  89.595  1.00 16.92           C  
ATOM    841  C   LYS A 108       4.266  36.167  90.652  1.00 15.75           C  
ATOM    842  O   LYS A 108       3.070  36.160  90.326  1.00 14.43           O  
ATOM    843  CB  LYS A 108       5.745  37.192  88.920  1.00 18.74           C  
ATOM    844  CG  LYS A 108       6.854  37.970  89.608  1.00 23.03           C  
ATOM    845  CD  LYS A 108       7.655  38.758  88.576  1.00 27.51           C  
ATOM    846  CE  LYS A 108       9.155  38.670  88.903  1.00 29.24           C  
ATOM    847  NZ  LYS A 108      10.027  38.709  87.698  1.00 29.72           N  
ATOM    848  N   ASP A 109       4.675  36.400  91.902  1.00 14.66           N  
ATOM    849  CA  ASP A 109       3.706  36.795  92.941  1.00 16.23           C  
ATOM    850  C   ASP A 109       2.948  38.042  92.483  1.00 14.66           C  
ATOM    851  O   ASP A 109       3.541  38.946  91.873  1.00 14.74           O  
ATOM    852  CB  ASP A 109       4.408  37.154  94.250  1.00 16.85           C  
ATOM    853  CG  ASP A 109       4.992  35.959  94.958  1.00 21.80           C  
ATOM    854  OD1 ASP A 109       4.930  34.836  94.419  1.00 27.71           O  
ATOM    855  OD2 ASP A 109       5.520  36.155  96.077  1.00 28.26           O  
ATOM    856  N   THR A 110       1.659  38.114  92.801  1.00 14.25           N  
ATOM    857  CA  THR A 110       0.845  39.258  92.407  1.00 13.65           C  
ATOM    858  C   THR A 110       1.513  40.602  92.739  1.00 13.73           C  
ATOM    859  O   THR A 110       1.610  41.483  91.896  1.00 13.07           O  
ATOM    860  CB  THR A 110      -0.535  39.198  93.049  1.00 13.20           C  
ATOM    861  OG1 THR A 110      -1.217  38.011  92.598  1.00 14.48           O  
ATOM    862  CG2 THR A 110      -1.343  40.433  92.676  1.00 13.94           C  
ATOM    863  N   SER A 111       1.976  40.760  93.967  1.00 14.36           N  
ATOM    864  CA  SER A 111       2.517  42.053  94.387  1.00 15.60           C  
ATOM    865  C   SER A 111       3.792  42.437  93.632  1.00 15.41           C  
ATOM    866  O   SER A 111       3.950  43.607  93.258  1.00 15.49           O  
ATOM    867  CB  SER A 111       2.754  42.080  95.897  1.00 16.02           C  
ATOM    868  OG  SER A 111       3.682  41.084  96.254  1.00 19.01           O  
ATOM    869  N   THR A 112       4.656  41.452  93.380  1.00 15.28           N  
ATOM    870  CA  THR A 112       5.860  41.652  92.558  1.00 15.50           C  
ATOM    871  C   THR A 112       5.486  42.074  91.116  1.00 15.34           C  
ATOM    872  O   THR A 112       6.063  43.022  90.566  1.00 14.69           O  
ATOM    873  CB  THR A 112       6.784  40.391  92.545  1.00 16.35           C  
ATOM    874  OG1 THR A 112       7.071  39.968  93.893  1.00 17.54           O  
ATOM    875  CG2 THR A 112       8.105  40.692  91.879  1.00 17.57           C  
ATOM    876  N   ALA A 113       4.501  41.395  90.525  1.00 14.48           N  
ATOM    877  CA  ALA A 113       4.021  41.727  89.180  1.00 14.58           C  
ATOM    878  C   ALA A 113       3.440  43.139  89.119  1.00 15.12           C  
ATOM    879  O   ALA A 113       3.714  43.915  88.176  1.00 14.90           O  
ATOM    880  CB  ALA A 113       2.990  40.687  88.710  1.00 15.22           C  
ATOM    881  N   GLN A 114       2.653  43.489  90.137  1.00 14.75           N  
ATOM    882  CA  GLN A 114       2.114  44.823  90.219  1.00 16.06           C  
ATOM    883  C   GLN A 114       3.214  45.860  90.333  1.00 15.77           C  
ATOM    884  O   GLN A 114       3.171  46.838  89.605  1.00 16.19           O  
ATOM    885  CB  GLN A 114       1.074  44.948  91.338  1.00 16.70           C  
ATOM    886  CG  GLN A 114      -0.129  44.066  91.030  1.00 18.63           C  
ATOM    887  CD  GLN A 114      -1.475  44.721  91.213  1.00 25.80           C  
ATOM    888  OE1 GLN A 114      -2.501  44.030  91.301  1.00 28.67           O  
ATOM    889  NE2 GLN A 114      -1.496  46.045  91.251  1.00 27.31           N  
ATOM    890  N   ASP A 115       4.210  45.609  91.181  1.00 16.09           N  
ATOM    891  CA  ASP A 115       5.349  46.503  91.351  1.00 16.97           C  
ATOM    892  C   ASP A 115       6.113  46.693  90.049  1.00 16.94           C  
ATOM    893  O   ASP A 115       6.420  47.838  89.657  1.00 16.64           O  
ATOM    894  CB  ASP A 115       6.309  45.987  92.429  1.00 17.04           C  
ATOM    895  CG  ASP A 115       5.766  46.150  93.843  1.00 21.91           C  
ATOM    896  OD1 ASP A 115       4.788  46.916  94.061  1.00 23.31           O  
ATOM    897  OD2 ASP A 115       6.341  45.490  94.743  1.00 24.30           O  
HETATM  898  N   MSE A 116       6.439  45.582  89.389  1.00 17.52           N  
HETATM  899  CA  MSE A 116       7.157  45.633  88.108  1.00 20.50           C  
HETATM  900  C   MSE A 116       6.366  46.411  87.038  1.00 17.85           C  
HETATM  901  O   MSE A 116       6.905  47.322  86.387  1.00 17.15           O  
HETATM  902  CB  MSE A 116       7.486  44.220  87.618  1.00 19.43           C  
HETATM  903  CG  MSE A 116       8.100  44.154  86.206  1.00 23.53           C  
HETATM  904 SE   MSE A 116       8.743  42.326  85.805  1.00 34.18          SE  
HETATM  905  CE  MSE A 116       9.506  41.987  87.644  1.00 28.34           C  
ATOM    906  N   ALA A 117       5.088  46.080  86.862  1.00 16.51           N  
ATOM    907  CA  ALA A 117       4.291  46.819  85.881  1.00 16.41           C  
ATOM    908  C   ALA A 117       4.273  48.321  86.175  1.00 16.65           C  
ATOM    909  O   ALA A 117       4.416  49.123  85.254  1.00 16.04           O  
ATOM    910  CB  ALA A 117       2.876  46.263  85.772  1.00 16.14           C  
ATOM    911  N   LYS A 118       4.099  48.713  87.446  1.00 17.37           N  
ATOM    912  CA  LYS A 118       4.148  50.151  87.790  1.00 18.25           C  
ATOM    913  C   LYS A 118       5.531  50.773  87.523  1.00 17.55           C  
ATOM    914  O   LYS A 118       5.626  51.867  86.943  1.00 16.80           O  
ATOM    915  CB  LYS A 118       3.699  50.394  89.238  1.00 19.10           C  
ATOM    916  CG  LYS A 118       3.175  51.792  89.486  1.00 23.49           C  
ATOM    917  CD  LYS A 118       2.021  51.802  90.512  1.00 28.03           C  
ATOM    918  CE  LYS A 118       0.944  52.835  90.112  1.00 29.79           C  
ATOM    919  NZ  LYS A 118      -0.380  52.718  90.841  1.00 30.19           N  
ATOM    920  N   ASN A 119       6.595  50.071  87.919  1.00 16.85           N  
ATOM    921  CA  ASN A 119       7.973  50.532  87.672  1.00 17.31           C  
ATOM    922  C   ASN A 119       8.298  50.812  86.190  1.00 17.33           C  
ATOM    923  O   ASN A 119       8.997  51.777  85.863  1.00 18.35           O  
ATOM    924  CB  ASN A 119       8.984  49.512  88.222  1.00 16.65           C  
ATOM    925  CG  ASN A 119       8.983  49.435  89.746  1.00 19.81           C  
ATOM    926  OD1 ASN A 119       8.323  50.237  90.432  1.00 19.49           O  
ATOM    927  ND2 ASN A 119       9.711  48.455  90.285  1.00 19.78           N  
ATOM    928  N   LEU A 120       7.783  49.969  85.305  1.00 16.24           N  
ATOM    929  CA  LEU A 120       8.090  50.050  83.881  1.00 15.90           C  
ATOM    930  C   LEU A 120       7.042  50.820  83.101  1.00 15.46           C  
ATOM    931  O   LEU A 120       7.115  50.907  81.862  1.00 14.95           O  
ATOM    932  CB  LEU A 120       8.306  48.651  83.306  1.00 16.79           C  
ATOM    933  CG  LEU A 120       9.577  47.983  83.860  1.00 17.29           C  
ATOM    934  CD1 LEU A 120       9.620  46.528  83.444  1.00 17.01           C  
ATOM    935  CD2 LEU A 120      10.896  48.689  83.471  1.00 21.45           C  
ATOM    936  N   GLU A 121       6.115  51.413  83.856  1.00 14.70           N  
ATOM    937  CA  GLU A 121       5.098  52.355  83.332  1.00 15.01           C  
ATOM    938  C   GLU A 121       4.036  51.709  82.440  1.00 14.41           C  
ATOM    939  O   GLU A 121       3.475  52.374  81.566  1.00 14.19           O  
ATOM    940  CB  GLU A 121       5.811  53.529  82.620  1.00 15.59           C  
ATOM    941  CG  GLU A 121       6.877  54.117  83.534  1.00 19.53           C  
ATOM    942  CD  GLU A 121       7.410  55.474  83.111  1.00 25.05           C  
ATOM    943  OE1 GLU A 121       7.245  55.871  81.939  1.00 25.75           O  
ATOM    944  OE2 GLU A 121       8.018  56.120  83.986  1.00 25.58           O  
ATOM    945  N   ILE A 122       3.740  50.430  82.691  1.00 12.78           N  
ATOM    946  CA  ILE A 122       2.757  49.690  81.875  1.00 13.16           C  
ATOM    947  C   ILE A 122       1.516  49.253  82.673  1.00 12.52           C  
ATOM    948  O   ILE A 122       0.547  48.767  82.089  1.00 13.89           O  
ATOM    949  CB  ILE A 122       3.382  48.488  81.106  1.00 12.39           C  
ATOM    950  CG1 ILE A 122       3.953  47.410  82.052  1.00 12.36           C  
ATOM    951  CG2 ILE A 122       4.435  49.004  80.066  1.00 13.05           C  
ATOM    952  CD1 ILE A 122       4.175  46.044  81.354  1.00 14.34           C  
ATOM    953  N   HIS A 123       1.533  49.487  83.980  1.00 13.63           N  
ATOM    954  CA  HIS A 123       0.436  49.073  84.871  1.00 14.03           C  
ATOM    955  C   HIS A 123      -0.889  49.623  84.327  1.00 14.05           C  
ATOM    956  O   HIS A 123      -1.934  48.951  84.330  1.00 14.23           O  
ATOM    957  CB  HIS A 123       0.708  49.580  86.317  1.00 14.46           C  
ATOM    958  CG  HIS A 123      -0.296  49.115  87.334  1.00 17.48           C  
ATOM    959  ND1 HIS A 123      -1.605  49.547  87.344  1.00 21.31           N  
ATOM    960  CD2 HIS A 123      -0.175  48.269  88.389  1.00 18.95           C  
ATOM    961  CE1 HIS A 123      -2.252  48.976  88.348  1.00 21.46           C  
ATOM    962  NE2 HIS A 123      -1.408  48.189  88.991  1.00 20.89           N  
ATOM    963  N   HIS A 124      -0.842  50.850  83.823  1.00 14.43           N  
ATOM    964  CA  HIS A 124      -2.069  51.521  83.437  1.00 14.38           C  
ATOM    965  C   HIS A 124      -2.806  50.948  82.200  1.00 13.80           C  
ATOM    966  O   HIS A 124      -3.986  51.291  81.945  1.00 15.99           O  
ATOM    967  CB  HIS A 124      -1.810  53.016  83.289  1.00 14.70           C  
ATOM    968  CG  HIS A 124      -1.023  53.381  82.068  1.00 13.06           C  
ATOM    969  ND1 HIS A 124       0.350  53.321  82.035  1.00 13.86           N  
ATOM    970  CD2 HIS A 124      -1.410  53.833  80.851  1.00 14.70           C  
ATOM    971  CE1 HIS A 124       0.778  53.707  80.847  1.00 16.04           C  
ATOM    972  NE2 HIS A 124      -0.268  54.009  80.103  1.00 15.30           N  
ATOM    973  N   PHE A 125      -2.142  50.086  81.438  1.00 12.25           N  
ATOM    974  CA  PHE A 125      -2.757  49.468  80.266  1.00 12.33           C  
ATOM    975  C   PHE A 125      -3.657  48.284  80.624  1.00 12.09           C  
ATOM    976  O   PHE A 125      -4.337  47.751  79.752  1.00 14.50           O  
ATOM    977  CB  PHE A 125      -1.693  48.950  79.308  1.00 11.76           C  
ATOM    978  CG  PHE A 125      -0.931  50.031  78.609  1.00 12.60           C  
ATOM    979  CD1 PHE A 125      -1.547  50.822  77.638  1.00 14.58           C  
ATOM    980  CD2 PHE A 125       0.386  50.269  78.931  1.00 14.19           C  
ATOM    981  CE1 PHE A 125      -0.836  51.818  76.978  1.00 15.26           C  
ATOM    982  CE2 PHE A 125       1.099  51.261  78.292  1.00 14.44           C  
ATOM    983  CZ  PHE A 125       0.505  52.027  77.312  1.00 11.78           C  
ATOM    984  N   PHE A 126      -3.589  47.837  81.878  1.00 12.26           N  
ATOM    985  CA  PHE A 126      -4.288  46.617  82.290  1.00 11.85           C  
ATOM    986  C   PHE A 126      -5.529  46.819  83.153  1.00 13.34           C  
ATOM    987  O   PHE A 126      -5.550  47.677  84.037  1.00 14.92           O  
ATOM    988  CB  PHE A 126      -3.280  45.641  82.954  1.00 11.91           C  
ATOM    989  CG  PHE A 126      -2.137  45.297  82.050  1.00 11.41           C  
ATOM    990  CD1 PHE A 126      -2.299  44.319  81.080  1.00 11.12           C  
ATOM    991  CD2 PHE A 126      -0.940  46.011  82.106  1.00 13.65           C  
ATOM    992  CE1 PHE A 126      -1.280  44.029  80.172  1.00  9.34           C  
ATOM    993  CE2 PHE A 126       0.099  45.714  81.238  1.00 11.10           C  
ATOM    994  CZ  PHE A 126      -0.079  44.717  80.250  1.00 11.85           C  
ATOM    995  N   ASP A 127      -6.546  45.987  82.927  1.00 14.50           N  
ATOM    996  CA  ASP A 127      -7.741  46.000  83.781  1.00 16.67           C  
ATOM    997  C   ASP A 127      -7.629  45.065  84.979  1.00 16.29           C  
ATOM    998  O   ASP A 127      -8.511  45.062  85.839  1.00 17.17           O  
ATOM    999  CB  ASP A 127      -8.978  45.639  82.989  1.00 17.29           C  
ATOM   1000  CG  ASP A 127      -9.413  46.751  82.039  1.00 21.89           C  
ATOM   1001  OD1 ASP A 127      -8.725  47.794  81.920  1.00 24.25           O  
ATOM   1002  OD2 ASP A 127     -10.468  46.556  81.408  1.00 27.94           O  
ATOM   1003  N   GLY A 128      -6.543  44.289  85.029  1.00 14.65           N  
ATOM   1004  CA  GLY A 128      -6.278  43.387  86.144  1.00 13.27           C  
ATOM   1005  C   GLY A 128      -4.887  42.822  86.009  1.00 13.00           C  
ATOM   1006  O   GLY A 128      -4.401  42.641  84.906  1.00 12.00           O  
ATOM   1007  N   ILE A 129      -4.250  42.568  87.141  1.00 13.17           N  
ATOM   1008  CA  ILE A 129      -2.961  41.929  87.171  1.00 12.90           C  
ATOM   1009  C   ILE A 129      -3.062  40.802  88.197  1.00 13.08           C  
ATOM   1010  O   ILE A 129      -3.329  41.045  89.390  1.00 11.67           O  
ATOM   1011  CB  ILE A 129      -1.828  42.916  87.550  1.00 13.46           C  
ATOM   1012  CG1 ILE A 129      -1.725  44.058  86.526  1.00 14.08           C  
ATOM   1013  CG2 ILE A 129      -0.466  42.139  87.740  1.00 14.16           C  
ATOM   1014  CD1 ILE A 129      -0.594  45.032  86.797  1.00 13.99           C  
ATOM   1015  N   TYR A 130      -2.848  39.584  87.709  1.00 12.52           N  
ATOM   1016  CA  TYR A 130      -3.023  38.340  88.478  1.00 13.83           C  
ATOM   1017  C   TYR A 130      -1.705  37.572  88.491  1.00 13.89           C  
ATOM   1018  O   TYR A 130      -1.157  37.267  87.429  1.00 12.93           O  
ATOM   1019  CB  TYR A 130      -4.154  37.510  87.860  1.00 14.48           C  
ATOM   1020  CG  TYR A 130      -5.461  38.290  87.902  1.00 14.97           C  
ATOM   1021  CD1 TYR A 130      -6.195  38.341  89.078  1.00 18.40           C  
ATOM   1022  CD2 TYR A 130      -5.913  39.024  86.801  1.00 16.70           C  
ATOM   1023  CE1 TYR A 130      -7.365  39.067  89.168  1.00 18.35           C  
ATOM   1024  CE2 TYR A 130      -7.119  39.781  86.876  1.00 16.34           C  
ATOM   1025  CZ  TYR A 130      -7.822  39.786  88.083  1.00 17.96           C  
ATOM   1026  OH  TYR A 130      -9.015  40.475  88.272  1.00 20.50           O  
ATOM   1027  N   GLY A 131      -1.195  37.289  89.685  1.00 14.13           N  
ATOM   1028  CA  GLY A 131       0.043  36.484  89.826  1.00 14.15           C  
ATOM   1029  C   GLY A 131      -0.216  35.297  90.755  1.00 14.73           C  
ATOM   1030  O   GLY A 131      -1.369  34.991  91.063  1.00 14.61           O  
ATOM   1031  N   SER A 132       0.851  34.630  91.182  1.00 14.79           N  
ATOM   1032  CA  SER A 132       0.714  33.429  91.986  1.00 16.69           C  
ATOM   1033  C   SER A 132       0.311  33.805  93.413  1.00 16.86           C  
ATOM   1034  O   SER A 132       0.662  34.883  93.901  1.00 16.02           O  
ATOM   1035  CB  SER A 132       2.010  32.635  92.006  1.00 16.65           C  
ATOM   1036  OG  SER A 132       3.034  33.407  92.576  1.00 21.70           O  
ATOM   1037  N   SER A 133      -0.371  32.864  94.063  1.00 18.56           N  
ATOM   1038  CA  SER A 133      -1.036  33.070  95.368  1.00 20.49           C  
ATOM   1039  C   SER A 133      -1.476  31.692  95.849  1.00 22.19           C  
ATOM   1040  O   SER A 133      -1.270  30.695  95.136  1.00 21.86           O  
ATOM   1041  CB  SER A 133      -2.272  33.958  95.199  1.00 20.67           C  
ATOM   1042  OG  SER A 133      -3.352  33.268  94.559  1.00 22.45           O  
ATOM   1043  N   PRO A 134      -2.036  31.606  97.074  1.00 23.06           N  
ATOM   1044  CA  PRO A 134      -2.605  30.328  97.513  1.00 23.73           C  
ATOM   1045  C   PRO A 134      -3.797  29.896  96.635  1.00 24.46           C  
ATOM   1046  O   PRO A 134      -3.946  28.710  96.334  1.00 24.13           O  
ATOM   1047  CB  PRO A 134      -3.075  30.632  98.953  1.00 23.73           C  
ATOM   1048  CG  PRO A 134      -2.213  31.796  99.399  1.00 24.57           C  
ATOM   1049  CD  PRO A 134      -2.107  32.637  98.130  1.00 23.23           C  
ATOM   1050  N   GLU A 135      -4.620  30.865  96.222  1.00 25.28           N  
ATOM   1051  CA  GLU A 135      -5.721  30.625  95.274  1.00 27.71           C  
ATOM   1052  C   GLU A 135      -5.239  30.090  93.905  1.00 27.02           C  
ATOM   1053  O   GLU A 135      -5.971  29.347  93.218  1.00 27.41           O  
ATOM   1054  CB  GLU A 135      -6.498  31.924  95.057  1.00 27.54           C  
ATOM   1055  CG  GLU A 135      -7.921  31.752  94.554  1.00 30.04           C  
ATOM   1056  CD  GLU A 135      -8.523  33.060  94.060  1.00 30.82           C  
ATOM   1057  OE1 GLU A 135      -7.997  34.138  94.422  1.00 32.54           O  
ATOM   1058  OE2 GLU A 135      -9.525  33.014  93.292  1.00 34.60           O  
ATOM   1059  N   ALA A 136      -4.017  30.476  93.525  1.00 26.33           N  
ATOM   1060  CA  ALA A 136      -3.484  30.205  92.190  1.00 24.60           C  
ATOM   1061  C   ALA A 136      -1.968  29.925  92.153  1.00 24.27           C  
ATOM   1062  O   ALA A 136      -1.160  30.807  91.857  1.00 23.75           O  
ATOM   1063  CB  ALA A 136      -3.867  31.334  91.254  1.00 25.09           C  
ATOM   1064  N   PRO A 137      -1.564  28.679  92.443  1.00 23.68           N  
ATOM   1065  CA  PRO A 137      -0.117  28.371  92.440  1.00 22.82           C  
ATOM   1066  C   PRO A 137       0.562  28.261  91.059  1.00 22.44           C  
ATOM   1067  O   PRO A 137       1.762  28.596  90.912  1.00 23.57           O  
ATOM   1068  CB  PRO A 137      -0.032  27.040  93.196  1.00 22.86           C  
ATOM   1069  CG  PRO A 137      -1.409  26.633  93.497  1.00 23.97           C  
ATOM   1070  CD  PRO A 137      -2.383  27.518  92.829  1.00 24.15           C  
ATOM   1071  N   HIS A 138      -0.167  27.807  90.050  1.00 20.35           N  
ATOM   1072  CA  HIS A 138       0.435  27.605  88.721  1.00 19.14           C  
ATOM   1073  C   HIS A 138      -0.298  28.384  87.655  1.00 16.90           C  
ATOM   1074  O   HIS A 138      -1.344  28.960  87.920  1.00 14.30           O  
ATOM   1075  CB  HIS A 138       0.448  26.123  88.336  1.00 19.44           C  
ATOM   1076  CG  HIS A 138       1.151  25.261  89.332  1.00 22.91           C  
ATOM   1077  ND1 HIS A 138       0.504  24.281  90.053  1.00 27.19           N  
ATOM   1078  CD2 HIS A 138       2.440  25.245  89.741  1.00 26.36           C  
ATOM   1079  CE1 HIS A 138       1.372  23.683  90.851  1.00 28.32           C  
ATOM   1080  NE2 HIS A 138       2.552  24.247  90.678  1.00 28.52           N  
ATOM   1081  N   LYS A 139       0.247  28.358  86.438  1.00 16.01           N  
ATOM   1082  CA  LYS A 139      -0.307  29.158  85.334  1.00 15.61           C  
ATOM   1083  C   LYS A 139      -1.799  28.919  85.094  1.00 14.70           C  
ATOM   1084  O   LYS A 139      -2.572  29.892  84.954  1.00 12.92           O  
ATOM   1085  CB  LYS A 139       0.527  28.965  84.042  1.00 16.89           C  
ATOM   1086  CG  LYS A 139       0.222  29.933  82.878  1.00 18.45           C  
ATOM   1087  CD  LYS A 139       0.250  31.418  83.277  1.00 21.41           C  
ATOM   1088  CE  LYS A 139       1.617  32.122  83.139  1.00 24.76           C  
ATOM   1089  NZ  LYS A 139       2.805  31.357  83.504  1.00 27.67           N  
ATOM   1090  N   ALA A 140      -2.230  27.653  85.058  1.00 14.25           N  
ATOM   1091  CA  ALA A 140      -3.662  27.370  84.843  1.00 14.70           C  
ATOM   1092  C   ALA A 140      -4.571  28.025  85.905  1.00 15.40           C  
ATOM   1093  O   ALA A 140      -5.631  28.562  85.578  1.00 13.89           O  
ATOM   1094  CB  ALA A 140      -3.925  25.838  84.772  1.00 15.35           C  
ATOM   1095  N   ASP A 141      -4.161  27.951  87.173  1.00 15.97           N  
ATOM   1096  CA  ASP A 141      -4.943  28.540  88.286  1.00 15.76           C  
ATOM   1097  C   ASP A 141      -5.072  30.068  88.150  1.00 14.24           C  
ATOM   1098  O   ASP A 141      -6.162  30.651  88.361  1.00 13.75           O  
ATOM   1099  CB  ASP A 141      -4.283  28.183  89.609  1.00 17.05           C  
ATOM   1100  CG  ASP A 141      -4.042  26.687  89.745  1.00 20.39           C  
ATOM   1101  OD1 ASP A 141      -5.023  25.923  89.676  1.00 23.51           O  
ATOM   1102  OD2 ASP A 141      -2.869  26.280  89.868  1.00 23.36           O  
ATOM   1103  N   VAL A 142      -3.980  30.703  87.733  1.00 13.18           N  
ATOM   1104  CA  VAL A 142      -3.969  32.151  87.520  1.00 13.61           C  
ATOM   1105  C   VAL A 142      -4.944  32.523  86.391  1.00 13.66           C  
ATOM   1106  O   VAL A 142      -5.758  33.445  86.517  1.00 13.32           O  
ATOM   1107  CB  VAL A 142      -2.515  32.649  87.228  1.00 14.04           C  
ATOM   1108  CG1 VAL A 142      -2.500  34.139  86.947  1.00 15.61           C  
ATOM   1109  CG2 VAL A 142      -1.588  32.326  88.418  1.00 13.97           C  
ATOM   1110  N   ILE A 143      -4.885  31.765  85.303  1.00 12.59           N  
ATOM   1111  CA  ILE A 143      -5.774  31.970  84.152  1.00 12.98           C  
ATOM   1112  C   ILE A 143      -7.240  31.769  84.590  1.00 13.57           C  
ATOM   1113  O   ILE A 143      -8.109  32.610  84.288  1.00 13.27           O  
ATOM   1114  CB  ILE A 143      -5.397  31.007  82.994  1.00 12.87           C  
ATOM   1115  CG1 ILE A 143      -4.027  31.378  82.398  1.00 11.74           C  
ATOM   1116  CG2 ILE A 143      -6.476  30.960  81.923  1.00 14.25           C  
ATOM   1117  CD1 ILE A 143      -3.482  30.458  81.315  1.00 12.13           C  
ATOM   1118  N   HIS A 144      -7.508  30.667  85.304  1.00 14.38           N  
ATOM   1119  CA  HIS A 144      -8.843  30.455  85.888  1.00 15.33           C  
ATOM   1120  C   HIS A 144      -9.322  31.661  86.695  1.00 14.93           C  
ATOM   1121  O   HIS A 144     -10.467  32.093  86.564  1.00 15.37           O  
ATOM   1122  CB  HIS A 144      -8.884  29.216  86.800  1.00 16.39           C  
ATOM   1123  CG  HIS A 144      -9.041  27.913  86.064  1.00 18.90           C  
ATOM   1124  ND1 HIS A 144     -10.012  27.697  85.104  1.00 22.13           N  
ATOM   1125  CD2 HIS A 144      -8.343  26.757  86.157  1.00 21.22           C  
ATOM   1126  CE1 HIS A 144      -9.898  26.467  84.634  1.00 21.64           C  
ATOM   1127  NE2 HIS A 144      -8.897  25.875  85.261  1.00 21.84           N  
ATOM   1128  N   GLN A 145      -8.458  32.170  87.561  1.00 14.87           N  
ATOM   1129  CA  GLN A 145      -8.816  33.316  88.380  1.00 15.10           C  
ATOM   1130  C   GLN A 145      -9.178  34.550  87.515  1.00 14.20           C  
ATOM   1131  O   GLN A 145     -10.203  35.215  87.766  1.00 14.44           O  
ATOM   1132  CB  GLN A 145      -7.691  33.638  89.347  1.00 15.81           C  
ATOM   1133  CG  GLN A 145      -8.057  34.805  90.251  1.00 18.49           C  
ATOM   1134  CD  GLN A 145      -7.021  35.122  91.291  1.00 23.50           C  
ATOM   1135  OE1 GLN A 145      -5.954  34.495  91.351  1.00 29.11           O  
ATOM   1136  NE2 GLN A 145      -7.341  36.102  92.151  1.00 22.74           N  
ATOM   1137  N   ALA A 146      -8.325  34.860  86.536  1.00 12.43           N  
ATOM   1138  CA  ALA A 146      -8.578  35.962  85.600  1.00 13.22           C  
ATOM   1139  C   ALA A 146      -9.932  35.798  84.894  1.00 14.06           C  
ATOM   1140  O   ALA A 146     -10.738  36.734  84.859  1.00 15.00           O  
ATOM   1141  CB  ALA A 146      -7.425  36.116  84.574  1.00 12.93           C  
ATOM   1142  N   LEU A 147     -10.193  34.607  84.359  1.00 14.16           N  
ATOM   1143  CA  LEU A 147     -11.430  34.351  83.617  1.00 14.44           C  
ATOM   1144  C   LEU A 147     -12.672  34.497  84.504  1.00 15.18           C  
ATOM   1145  O   LEU A 147     -13.606  35.254  84.170  1.00 15.38           O  
ATOM   1146  CB  LEU A 147     -11.416  32.957  82.992  1.00 14.93           C  
ATOM   1147  CG  LEU A 147     -10.507  32.626  81.800  1.00 13.69           C  
ATOM   1148  CD1 LEU A 147     -10.528  31.136  81.637  1.00 14.52           C  
ATOM   1149  CD2 LEU A 147     -11.014  33.319  80.539  1.00 16.36           C  
ATOM   1150  N   GLN A 148     -12.660  33.798  85.640  1.00 14.90           N  
ATOM   1151  CA  GLN A 148     -13.787  33.838  86.574  1.00 15.58           C  
ATOM   1152  C   GLN A 148     -14.055  35.230  87.155  1.00 15.76           C  
ATOM   1153  O   GLN A 148     -15.197  35.684  87.150  1.00 16.91           O  
ATOM   1154  CB  GLN A 148     -13.626  32.772  87.656  1.00 15.43           C  
ATOM   1155  CG  GLN A 148     -13.612  31.383  87.033  1.00 18.09           C  
ATOM   1156  CD  GLN A 148     -13.372  30.271  88.027  1.00 21.06           C  
ATOM   1157  OE1 GLN A 148     -13.521  30.450  89.242  1.00 23.00           O  
ATOM   1158  NE2 GLN A 148     -12.999  29.106  87.510  1.00 21.70           N  
ATOM   1159  N   THR A 149     -13.006  35.930  87.584  1.00 16.20           N  
ATOM   1160  CA  THR A 149     -13.187  37.258  88.167  1.00 16.55           C  
ATOM   1161  C   THR A 149     -13.822  38.231  87.166  1.00 15.64           C  
ATOM   1162  O   THR A 149     -14.594  39.098  87.567  1.00 15.17           O  
ATOM   1163  CB  THR A 149     -11.880  37.828  88.753  1.00 17.01           C  
ATOM   1164  OG1 THR A 149     -11.373  36.887  89.700  1.00 21.29           O  
ATOM   1165  CG2 THR A 149     -12.163  39.107  89.500  1.00 18.32           C  
ATOM   1166  N   HIS A 150     -13.536  38.034  85.876  1.00 15.10           N  
ATOM   1167  CA  HIS A 150     -14.026  38.930  84.829  1.00 15.94           C  
ATOM   1168  C   HIS A 150     -15.179  38.356  84.023  1.00 14.95           C  
ATOM   1169  O   HIS A 150     -15.568  38.913  82.981  1.00 15.59           O  
ATOM   1170  CB  HIS A 150     -12.871  39.475  83.978  1.00 16.23           C  
ATOM   1171  CG  HIS A 150     -11.973  40.360  84.768  1.00 17.73           C  
ATOM   1172  ND1 HIS A 150     -12.334  41.643  85.123  1.00 17.65           N  
ATOM   1173  CD2 HIS A 150     -10.807  40.102  85.407  1.00 19.13           C  
ATOM   1174  CE1 HIS A 150     -11.384  42.166  85.881  1.00 20.90           C  
ATOM   1175  NE2 HIS A 150     -10.449  41.247  86.074  1.00 19.91           N  
ATOM   1176  N   GLN A 151     -15.714  37.248  84.529  1.00 15.03           N  
ATOM   1177  CA  GLN A 151     -16.934  36.643  84.005  1.00 16.25           C  
ATOM   1178  C   GLN A 151     -16.758  36.306  82.528  1.00 16.80           C  
ATOM   1179  O   GLN A 151     -17.614  36.626  81.719  1.00 17.44           O  
ATOM   1180  CB  GLN A 151     -18.115  37.604  84.196  1.00 16.50           C  
ATOM   1181  CG  GLN A 151     -18.540  37.769  85.640  1.00 16.37           C  
ATOM   1182  CD  GLN A 151     -19.727  38.718  85.792  1.00 17.07           C  
ATOM   1183  OE1 GLN A 151     -20.745  38.598  85.104  1.00 17.46           O  
ATOM   1184  NE2 GLN A 151     -19.608  39.643  86.729  1.00 17.99           N  
ATOM   1185  N   LEU A 152     -15.617  35.686  82.212  1.00 15.91           N  
ATOM   1186  CA  LEU A 152     -15.278  35.272  80.853  1.00 16.76           C  
ATOM   1187  C   LEU A 152     -15.330  33.767  80.719  1.00 16.55           C  
ATOM   1188  O   LEU A 152     -14.817  33.039  81.587  1.00 17.49           O  
ATOM   1189  CB  LEU A 152     -13.846  35.726  80.505  1.00 16.73           C  
ATOM   1190  CG  LEU A 152     -13.532  37.217  80.470  1.00 16.80           C  
ATOM   1191  CD1 LEU A 152     -12.017  37.437  80.538  1.00 16.99           C  
ATOM   1192  CD2 LEU A 152     -14.112  37.806  79.165  1.00 17.36           C  
ATOM   1193  N   ALA A 153     -15.894  33.310  79.605  1.00 17.09           N  
ATOM   1194  CA  ALA A 153     -15.755  31.910  79.155  1.00 18.16           C  
ATOM   1195  C   ALA A 153     -14.390  31.753  78.497  1.00 17.68           C  
ATOM   1196  O   ALA A 153     -13.878  32.704  77.919  1.00 17.05           O  
ATOM   1197  CB  ALA A 153     -16.841  31.544  78.181  1.00 17.94           C  
ATOM   1198  N   PRO A 154     -13.784  30.565  78.613  1.00 18.89           N  
ATOM   1199  CA  PRO A 154     -12.417  30.409  78.101  1.00 19.39           C  
ATOM   1200  C   PRO A 154     -12.282  30.777  76.609  1.00 20.16           C  
ATOM   1201  O   PRO A 154     -11.257  31.309  76.178  1.00 20.38           O  
ATOM   1202  CB  PRO A 154     -12.142  28.927  78.315  1.00 19.09           C  
ATOM   1203  CG  PRO A 154     -13.043  28.519  79.403  1.00 20.37           C  
ATOM   1204  CD  PRO A 154     -14.285  29.322  79.217  1.00 19.24           C  
ATOM   1205  N   GLU A 155     -13.349  30.533  75.849  1.00 21.19           N  
ATOM   1206  CA  GLU A 155     -13.397  30.816  74.424  1.00 21.37           C  
ATOM   1207  C   GLU A 155     -13.178  32.306  74.101  1.00 20.21           C  
ATOM   1208  O   GLU A 155     -12.751  32.665  72.994  1.00 20.48           O  
ATOM   1209  CB  GLU A 155     -14.736  30.310  73.874  1.00 22.15           C  
ATOM   1210  CG  GLU A 155     -14.925  28.767  73.979  1.00 26.11           C  
ATOM   1211  CD  GLU A 155     -15.185  28.191  75.411  1.00 29.23           C  
ATOM   1212  OE1 GLU A 155     -15.749  28.847  76.302  1.00 27.79           O  
ATOM   1213  OE2 GLU A 155     -14.824  27.027  75.641  1.00 35.26           O  
ATOM   1214  N   GLN A 156     -13.435  33.168  75.086  1.00 18.20           N  
ATOM   1215  CA  GLN A 156     -13.322  34.603  74.912  1.00 17.03           C  
ATOM   1216  C   GLN A 156     -11.931  35.164  75.237  1.00 16.45           C  
ATOM   1217  O   GLN A 156     -11.736  36.381  75.126  1.00 15.88           O  
ATOM   1218  CB  GLN A 156     -14.307  35.352  75.810  1.00 17.83           C  
ATOM   1219  CG  GLN A 156     -15.777  35.149  75.554  1.00 20.14           C  
ATOM   1220  CD  GLN A 156     -16.561  35.890  76.632  1.00 22.85           C  
ATOM   1221  OE1 GLN A 156     -16.945  35.298  77.634  1.00 19.26           O  
ATOM   1222  NE2 GLN A 156     -16.703  37.205  76.475  1.00 22.69           N  
ATOM   1223  N   ALA A 157     -10.992  34.311  75.674  1.00 14.91           N  
ATOM   1224  CA  ALA A 157      -9.662  34.804  76.033  1.00 14.64           C  
ATOM   1225  C   ALA A 157      -8.536  34.176  75.183  1.00 14.87           C  
ATOM   1226  O   ALA A 157      -8.713  33.114  74.567  1.00 15.70           O  
ATOM   1227  CB  ALA A 157      -9.393  34.591  77.528  1.00 15.15           C  
ATOM   1228  N   ILE A 158      -7.389  34.848  75.172  1.00 13.67           N  
ATOM   1229  CA  ILE A 158      -6.173  34.327  74.550  1.00 13.46           C  
ATOM   1230  C   ILE A 158      -5.038  34.759  75.463  1.00 12.61           C  
ATOM   1231  O   ILE A 158      -5.101  35.835  76.062  1.00 12.83           O  
ATOM   1232  CB  ILE A 158      -5.998  34.851  73.077  1.00 13.44           C  
ATOM   1233  CG1 ILE A 158      -4.750  34.254  72.386  1.00 12.86           C  
ATOM   1234  CG2 ILE A 158      -5.988  36.376  72.988  1.00 14.10           C  
ATOM   1235  CD1 ILE A 158      -4.850  34.357  70.838  1.00 13.45           C  
ATOM   1236  N   ILE A 159      -4.027  33.912  75.617  1.00 12.75           N  
ATOM   1237  CA  ILE A 159      -2.808  34.320  76.343  1.00 12.71           C  
ATOM   1238  C   ILE A 159      -1.665  34.517  75.342  1.00 12.55           C  
ATOM   1239  O   ILE A 159      -1.467  33.701  74.404  1.00 12.61           O  
ATOM   1240  CB  ILE A 159      -2.434  33.330  77.474  1.00 12.69           C  
ATOM   1241  CG1 ILE A 159      -1.261  33.868  78.306  1.00 12.48           C  
ATOM   1242  CG2 ILE A 159      -2.160  31.901  76.894  1.00 12.02           C  
ATOM   1243  CD1 ILE A 159      -1.044  33.095  79.614  1.00 13.28           C  
ATOM   1244  N   ILE A 160      -0.956  35.632  75.517  1.00 11.51           N  
ATOM   1245  CA  ILE A 160       0.226  35.953  74.752  1.00 11.91           C  
ATOM   1246  C   ILE A 160       1.385  35.613  75.672  1.00 11.95           C  
ATOM   1247  O   ILE A 160       1.525  36.218  76.745  1.00 10.41           O  
ATOM   1248  CB  ILE A 160       0.214  37.473  74.379  1.00 12.08           C  
ATOM   1249  CG1 ILE A 160      -1.054  37.769  73.538  1.00 12.29           C  
ATOM   1250  CG2 ILE A 160       1.574  37.910  73.733  1.00 12.08           C  
ATOM   1251  CD1 ILE A 160      -1.173  39.174  72.902  1.00 13.32           C  
ATOM   1252  N   GLY A 161       2.186  34.623  75.282  1.00 11.64           N  
ATOM   1253  CA  GLY A 161       3.234  34.121  76.169  1.00 12.70           C  
ATOM   1254  C   GLY A 161       4.434  33.513  75.471  1.00 13.66           C  
ATOM   1255  O   GLY A 161       4.353  33.167  74.282  1.00 13.29           O  
ATOM   1256  N   ASP A 162       5.538  33.392  76.220  1.00 13.61           N  
ATOM   1257  CA  ASP A 162       6.817  32.955  75.681  1.00 14.68           C  
ATOM   1258  C   ASP A 162       7.294  31.568  76.121  1.00 14.56           C  
ATOM   1259  O   ASP A 162       8.352  31.149  75.677  1.00 15.06           O  
ATOM   1260  CB  ASP A 162       7.930  33.984  75.974  1.00 14.80           C  
ATOM   1261  CG  ASP A 162       8.266  34.083  77.461  1.00 15.99           C  
ATOM   1262  OD1 ASP A 162       7.334  34.224  78.275  1.00 18.59           O  
ATOM   1263  OD2 ASP A 162       9.467  33.981  77.809  1.00 19.50           O  
ATOM   1264  N   THR A 163       6.540  30.864  76.967  1.00 14.09           N  
ATOM   1265  CA  THR A 163       6.987  29.560  77.492  1.00 14.55           C  
ATOM   1266  C   THR A 163       5.996  28.404  77.344  1.00 14.51           C  
ATOM   1267  O   THR A 163       4.775  28.604  77.170  1.00 13.84           O  
ATOM   1268  CB  THR A 163       7.338  29.635  79.008  1.00 14.52           C  
ATOM   1269  OG1 THR A 163       6.132  29.754  79.770  1.00 15.41           O  
ATOM   1270  CG2 THR A 163       8.287  30.789  79.341  1.00 16.63           C  
ATOM   1271  N   LYS A 164       6.532  27.189  77.500  1.00 14.21           N  
ATOM   1272  CA  LYS A 164       5.723  25.976  77.531  1.00 15.56           C  
ATOM   1273  C   LYS A 164       4.677  26.041  78.644  1.00 14.66           C  
ATOM   1274  O   LYS A 164       3.584  25.486  78.512  1.00 15.24           O  
ATOM   1275  CB  LYS A 164       6.626  24.740  77.704  1.00 16.48           C  
ATOM   1276  CG  LYS A 164       7.451  24.766  78.968  1.00 19.44           C  
ATOM   1277  CD  LYS A 164       8.608  23.771  78.932  1.00 25.88           C  
ATOM   1278  CE  LYS A 164       8.137  22.384  79.317  1.00 30.08           C  
ATOM   1279  NZ  LYS A 164       9.248  21.560  79.927  1.00 33.42           N  
ATOM   1280  N   PHE A 165       5.005  26.714  79.747  1.00 14.67           N  
ATOM   1281  CA  PHE A 165       4.034  26.857  80.855  1.00 15.60           C  
ATOM   1282  C   PHE A 165       2.797  27.671  80.449  1.00 15.34           C  
ATOM   1283  O   PHE A 165       1.688  27.347  80.841  1.00 15.01           O  
ATOM   1284  CB  PHE A 165       4.723  27.439  82.091  1.00 16.77           C  
ATOM   1285  CG  PHE A 165       5.954  26.673  82.495  1.00 17.27           C  
ATOM   1286  CD1 PHE A 165       5.850  25.574  83.330  1.00 20.35           C  
ATOM   1287  CD2 PHE A 165       7.212  27.048  82.027  1.00 19.57           C  
ATOM   1288  CE1 PHE A 165       7.001  24.845  83.707  1.00 20.93           C  
ATOM   1289  CE2 PHE A 165       8.356  26.333  82.391  1.00 21.33           C  
ATOM   1290  CZ  PHE A 165       8.237  25.222  83.223  1.00 20.36           C  
ATOM   1291  N   ASP A 166       3.005  28.705  79.636  1.00 14.09           N  
ATOM   1292  CA  ASP A 166       1.903  29.499  79.081  1.00 13.91           C  
ATOM   1293  C   ASP A 166       1.085  28.640  78.123  1.00 14.01           C  
ATOM   1294  O   ASP A 166      -0.123  28.704  78.127  1.00 14.07           O  
ATOM   1295  CB  ASP A 166       2.459  30.696  78.287  1.00 12.63           C  
ATOM   1296  CG  ASP A 166       3.108  31.747  79.187  1.00 16.10           C  
ATOM   1297  OD1 ASP A 166       2.617  31.959  80.315  1.00 19.60           O  
ATOM   1298  OD2 ASP A 166       4.141  32.315  78.793  1.00 17.78           O  
HETATM 1299  N   MSE A 167       1.764  27.850  77.287  1.00 14.85           N  
HETATM 1300  CA  MSE A 167       1.058  27.048  76.282  1.00 16.34           C  
HETATM 1301  C   MSE A 167       0.219  25.971  76.972  1.00 16.71           C  
HETATM 1302  O   MSE A 167      -0.944  25.762  76.620  1.00 17.90           O  
HETATM 1303  CB  MSE A 167       2.043  26.377  75.309  1.00 16.76           C  
HETATM 1304  CG  MSE A 167       2.977  27.315  74.554  1.00 18.11           C  
HETATM 1305 SE   MSE A 167       2.032  28.542  73.332  1.00 28.75          SE  
HETATM 1306  CE  MSE A 167       1.766  30.151  74.557  1.00 22.59           C  
ATOM   1307  N   LEU A 168       0.806  25.297  77.958  1.00 18.14           N  
ATOM   1308  CA  LEU A 168       0.083  24.243  78.690  1.00 19.00           C  
ATOM   1309  C   LEU A 168      -1.048  24.838  79.531  1.00 19.05           C  
ATOM   1310  O   LEU A 168      -2.129  24.260  79.621  1.00 19.84           O  
ATOM   1311  CB  LEU A 168       1.026  23.457  79.595  1.00 20.84           C  
ATOM   1312  CG  LEU A 168       1.955  22.452  78.910  1.00 22.45           C  
ATOM   1313  CD1 LEU A 168       3.017  22.000  79.878  1.00 24.22           C  
ATOM   1314  CD2 LEU A 168       1.165  21.272  78.370  1.00 25.88           C  
ATOM   1315  N   GLY A 169      -0.790  25.984  80.159  1.00 18.60           N  
ATOM   1316  CA  GLY A 169      -1.840  26.715  80.876  1.00 17.57           C  
ATOM   1317  C   GLY A 169      -3.050  26.991  79.996  1.00 17.27           C  
ATOM   1318  O   GLY A 169      -4.203  26.814  80.428  1.00 16.91           O  
ATOM   1319  N   ALA A 170      -2.805  27.424  78.760  1.00 17.03           N  
ATOM   1320  CA  ALA A 170      -3.875  27.709  77.821  1.00 17.31           C  
ATOM   1321  C   ALA A 170      -4.649  26.442  77.495  1.00 18.45           C  
ATOM   1322  O   ALA A 170      -5.875  26.460  77.411  1.00 18.18           O  
ATOM   1323  CB  ALA A 170      -3.334  28.337  76.533  1.00 16.07           C  
ATOM   1324  N   ARG A 171      -3.924  25.340  77.327  1.00 19.00           N  
ATOM   1325  CA  ARG A 171      -4.582  24.104  76.905  1.00 21.39           C  
ATOM   1326  C   ARG A 171      -5.442  23.588  78.052  1.00 21.39           C  
ATOM   1327  O   ARG A 171      -6.586  23.162  77.854  1.00 22.18           O  
ATOM   1328  CB  ARG A 171      -3.557  23.049  76.473  1.00 21.69           C  
ATOM   1329  CG  ARG A 171      -4.205  21.677  76.340  1.00 26.97           C  
ATOM   1330  CD  ARG A 171      -3.297  20.609  75.780  1.00 31.35           C  
ATOM   1331  NE  ARG A 171      -4.010  19.333  75.831  1.00 37.00           N  
ATOM   1332  CZ  ARG A 171      -4.885  18.925  74.912  1.00 37.52           C  
ATOM   1333  NH1 ARG A 171      -5.133  19.666  73.838  1.00 37.72           N  
ATOM   1334  NH2 ARG A 171      -5.490  17.755  75.053  1.00 39.86           N  
ATOM   1335  N   GLU A 172      -4.887  23.622  79.258  1.00 21.62           N  
ATOM   1336  CA  GLU A 172      -5.622  23.192  80.463  1.00 22.04           C  
ATOM   1337  C   GLU A 172      -6.919  23.962  80.726  1.00 21.93           C  
ATOM   1338  O   GLU A 172      -7.889  23.401  81.237  1.00 22.08           O  
ATOM   1339  CB  GLU A 172      -4.719  23.279  81.683  1.00 22.47           C  
ATOM   1340  CG  GLU A 172      -3.817  22.057  81.823  1.00 25.32           C  
ATOM   1341  CD  GLU A 172      -2.487  22.347  82.490  1.00 31.45           C  
ATOM   1342  OE1 GLU A 172      -2.273  23.503  82.921  1.00 32.70           O  
ATOM   1343  OE2 GLU A 172      -1.635  21.417  82.564  1.00 34.33           O  
ATOM   1344  N   THR A 173      -6.944  25.237  80.364  1.00 20.19           N  
ATOM   1345  CA  THR A 173      -8.062  26.113  80.723  1.00 19.28           C  
ATOM   1346  C   THR A 173      -9.001  26.332  79.542  1.00 19.20           C  
ATOM   1347  O   THR A 173     -10.089  26.876  79.698  1.00 19.64           O  
ATOM   1348  CB  THR A 173      -7.550  27.491  81.194  1.00 18.87           C  
ATOM   1349  OG1 THR A 173      -6.670  28.022  80.203  1.00 16.22           O  
ATOM   1350  CG2 THR A 173      -6.816  27.378  82.512  1.00 19.28           C  
ATOM   1351  N   GLY A 174      -8.585  25.905  78.354  1.00 18.76           N  
ATOM   1352  CA  GLY A 174      -9.401  26.104  77.158  1.00 17.94           C  
ATOM   1353  C   GLY A 174      -9.329  27.474  76.476  1.00 17.36           C  
ATOM   1354  O   GLY A 174     -10.156  27.788  75.624  1.00 17.98           O  
ATOM   1355  N   ILE A 175      -8.347  28.300  76.828  1.00 16.32           N  
ATOM   1356  CA  ILE A 175      -8.237  29.605  76.140  1.00 14.39           C  
ATOM   1357  C   ILE A 175      -7.297  29.447  74.945  1.00 15.08           C  
ATOM   1358  O   ILE A 175      -6.552  28.461  74.853  1.00 15.01           O  
ATOM   1359  CB  ILE A 175      -7.733  30.748  77.073  1.00 13.86           C  
ATOM   1360  CG1 ILE A 175      -6.293  30.483  77.525  1.00 13.02           C  
ATOM   1361  CG2 ILE A 175      -8.661  30.917  78.318  1.00 13.37           C  
ATOM   1362  CD1 ILE A 175      -5.626  31.672  78.216  1.00 14.13           C  
ATOM   1363  N   GLN A 176      -7.314  30.405  74.028  1.00 14.88           N  
ATOM   1364  CA  GLN A 176      -6.400  30.327  72.898  1.00 14.59           C  
ATOM   1365  C   GLN A 176      -4.973  30.696  73.365  1.00 14.25           C  
ATOM   1366  O   GLN A 176      -4.789  31.265  74.443  1.00 13.20           O  
ATOM   1367  CB  GLN A 176      -6.848  31.250  71.788  1.00 14.70           C  
ATOM   1368  CG  GLN A 176      -8.053  30.731  70.964  1.00 18.50           C  
ATOM   1369  CD  GLN A 176      -8.352  31.640  69.813  1.00 22.33           C  
ATOM   1370  OE1 GLN A 176      -7.440  32.070  69.102  1.00 23.91           O  
ATOM   1371  NE2 GLN A 176      -9.628  31.972  69.628  1.00 23.04           N  
ATOM   1372  N   LYS A 177      -3.980  30.348  72.549  1.00 14.16           N  
ATOM   1373  CA  LYS A 177      -2.560  30.563  72.886  1.00 14.40           C  
ATOM   1374  C   LYS A 177      -1.855  31.188  71.702  1.00 14.42           C  
ATOM   1375  O   LYS A 177      -1.954  30.693  70.562  1.00 13.46           O  
ATOM   1376  CB  LYS A 177      -1.860  29.263  73.346  1.00 15.32           C  
ATOM   1377  CG  LYS A 177      -2.501  27.962  72.826  1.00 15.41           C  
ATOM   1378  CD  LYS A 177      -1.643  26.731  73.128  1.00 16.12           C  
ATOM   1379  CE  LYS A 177      -2.448  25.438  73.110  1.00 19.24           C  
ATOM   1380  NZ  LYS A 177      -2.940  25.059  71.734  1.00 19.85           N  
ATOM   1381  N   LEU A 178      -1.175  32.297  71.987  1.00 12.52           N  
ATOM   1382  CA  LEU A 178      -0.386  33.012  71.005  1.00 12.42           C  
ATOM   1383  C   LEU A 178       1.075  32.991  71.463  1.00 12.08           C  
ATOM   1384  O   LEU A 178       1.433  33.620  72.486  1.00 11.59           O  
ATOM   1385  CB  LEU A 178      -0.885  34.450  70.872  1.00 11.71           C  
ATOM   1386  CG  LEU A 178      -0.402  35.248  69.640  1.00 11.77           C  
ATOM   1387  CD1 LEU A 178      -1.354  36.395  69.376  1.00 12.60           C  
ATOM   1388  CD2 LEU A 178       1.036  35.737  69.743  1.00 10.92           C  
ATOM   1389  N   ALA A 179       1.906  32.247  70.731  1.00 11.88           N  
ATOM   1390  CA  ALA A 179       3.316  32.079  71.107  1.00 12.05           C  
ATOM   1391  C   ALA A 179       4.148  33.261  70.625  1.00 12.65           C  
ATOM   1392  O   ALA A 179       4.000  33.700  69.490  1.00 14.05           O  
ATOM   1393  CB  ALA A 179       3.904  30.764  70.519  1.00 12.85           C  
ATOM   1394  N   ILE A 180       5.051  33.738  71.476  1.00 12.27           N  
ATOM   1395  CA  ILE A 180       5.986  34.786  71.060  1.00 12.38           C  
ATOM   1396  C   ILE A 180       7.411  34.294  71.233  1.00 13.04           C  
ATOM   1397  O   ILE A 180       7.703  33.525  72.161  1.00 12.62           O  
ATOM   1398  CB  ILE A 180       5.728  36.145  71.769  1.00 11.63           C  
ATOM   1399  CG1 ILE A 180       6.149  36.120  73.265  1.00 13.93           C  
ATOM   1400  CG2 ILE A 180       4.259  36.603  71.486  1.00 11.87           C  
ATOM   1401  CD1 ILE A 180       7.642  36.504  73.506  1.00 16.41           C  
ATOM   1402  N   THR A 181       8.295  34.707  70.325  1.00 14.10           N  
ATOM   1403  CA  THR A 181       9.629  34.111  70.267  1.00 16.51           C  
ATOM   1404  C   THR A 181      10.759  35.113  70.513  1.00 17.02           C  
ATOM   1405  O   THR A 181      11.936  34.756  70.355  1.00 18.02           O  
ATOM   1406  CB  THR A 181       9.867  33.402  68.908  1.00 15.44           C  
ATOM   1407  OG1 THR A 181       9.818  34.379  67.868  1.00 16.24           O  
ATOM   1408  CG2 THR A 181       8.789  32.350  68.631  1.00 17.74           C  
ATOM   1409  N   TRP A 182      10.406  36.357  70.860  1.00 17.03           N  
ATOM   1410  CA  TRP A 182      11.399  37.398  71.199  1.00 18.13           C  
ATOM   1411  C   TRP A 182      11.858  37.272  72.655  1.00 19.11           C  
ATOM   1412  O   TRP A 182      12.706  38.055  73.125  1.00 19.69           O  
ATOM   1413  CB  TRP A 182      10.854  38.815  70.928  1.00 17.79           C  
ATOM   1414  CG  TRP A 182       9.717  39.245  71.816  1.00 16.16           C  
ATOM   1415  CD1 TRP A 182       9.788  39.594  73.144  1.00 15.79           C  
ATOM   1416  CD2 TRP A 182       8.345  39.404  71.433  1.00 15.80           C  
ATOM   1417  NE1 TRP A 182       8.539  39.953  73.607  1.00 15.88           N  
ATOM   1418  CE2 TRP A 182       7.633  39.833  72.584  1.00 15.40           C  
ATOM   1419  CE3 TRP A 182       7.643  39.211  70.236  1.00 16.03           C  
ATOM   1420  CZ2 TRP A 182       6.253  40.061  72.576  1.00 16.48           C  
ATOM   1421  CZ3 TRP A 182       6.263  39.441  70.229  1.00 15.63           C  
ATOM   1422  CH2 TRP A 182       5.584  39.866  71.386  1.00 16.77           C  
ATOM   1423  N   GLY A 183      11.289  36.301  73.366  1.00 19.19           N  
ATOM   1424  CA  GLY A 183      11.481  36.176  74.814  1.00 21.28           C  
ATOM   1425  C   GLY A 183      12.343  35.008  75.236  1.00 22.69           C  
ATOM   1426  O   GLY A 183      13.316  34.655  74.551  1.00 21.99           O  
ATOM   1427  N   PHE A 184      11.975  34.395  76.354  1.00 23.90           N  
ATOM   1428  CA  PHE A 184      12.882  33.465  77.027  1.00 25.30           C  
ATOM   1429  C   PHE A 184      12.725  32.013  76.587  1.00 26.48           C  
ATOM   1430  O   PHE A 184      13.716  31.284  76.540  1.00 27.17           O  
ATOM   1431  CB  PHE A 184      12.827  33.637  78.560  1.00 25.50           C  
ATOM   1432  CG  PHE A 184      13.080  35.058  79.021  1.00 24.02           C  
ATOM   1433  CD1 PHE A 184      13.914  35.910  78.290  1.00 24.53           C  
ATOM   1434  CD2 PHE A 184      12.509  35.529  80.197  1.00 25.30           C  
ATOM   1435  CE1 PHE A 184      14.149  37.221  78.709  1.00 24.56           C  
ATOM   1436  CE2 PHE A 184      12.749  36.834  80.634  1.00 23.89           C  
ATOM   1437  CZ  PHE A 184      13.553  37.685  79.877  1.00 22.25           C  
ATOM   1438  N   GLY A 185      11.506  31.613  76.223  1.00 26.47           N  
ATOM   1439  CA  GLY A 185      11.266  30.263  75.748  1.00 27.66           C  
ATOM   1440  C   GLY A 185      11.729  30.093  74.312  1.00 28.21           C  
ATOM   1441  O   GLY A 185      11.778  31.068  73.544  1.00 27.91           O  
ATOM   1442  N   GLU A 186      12.057  28.854  73.951  1.00 28.70           N  
ATOM   1443  CA  GLU A 186      12.552  28.527  72.610  1.00 29.52           C  
ATOM   1444  C   GLU A 186      11.394  28.163  71.670  1.00 29.04           C  
ATOM   1445  O   GLU A 186      10.477  27.448  72.065  1.00 28.52           O  
ATOM   1446  CB  GLU A 186      13.548  27.366  72.677  1.00 29.92           C  
ATOM   1447  CG  GLU A 186      14.636  27.511  73.754  1.00 33.19           C  
ATOM   1448  CD  GLU A 186      15.828  28.337  73.305  1.00 37.07           C  
ATOM   1449  OE1 GLU A 186      15.669  29.248  72.461  1.00 39.10           O  
ATOM   1450  OE2 GLU A 186      16.944  28.055  73.795  1.00 39.29           O  
ATOM   1451  N   GLN A 187      11.466  28.639  70.426  1.00 28.91           N  
ATOM   1452  CA  GLN A 187      10.392  28.457  69.439  1.00 29.34           C  
ATOM   1453  C   GLN A 187      10.031  26.987  69.214  1.00 28.52           C  
ATOM   1454  O   GLN A 187       8.857  26.652  69.082  1.00 27.82           O  
ATOM   1455  CB  GLN A 187      10.758  29.139  68.108  1.00 29.53           C  
ATOM   1456  CG  GLN A 187       9.682  29.069  67.023  1.00 30.99           C  
ATOM   1457  CD  GLN A 187       9.977  29.971  65.826  1.00 30.87           C  
ATOM   1458  OE1 GLN A 187      11.042  30.600  65.754  1.00 34.94           O  
ATOM   1459  NE2 GLN A 187       9.036  30.044  64.885  1.00 34.53           N  
ATOM   1460  N   ALA A 188      11.053  26.131  69.164  1.00 28.24           N  
ATOM   1461  CA  ALA A 188      10.885  24.684  68.988  1.00 28.08           C  
ATOM   1462  C   ALA A 188       9.928  24.086  70.016  1.00 27.66           C  
ATOM   1463  O   ALA A 188       9.038  23.304  69.651  1.00 28.57           O  
ATOM   1464  CB  ALA A 188      12.238  23.973  69.030  1.00 28.22           C  
ATOM   1465  N   ASP A 189      10.108  24.468  71.286  1.00 26.11           N  
ATOM   1466  CA  ASP A 189       9.234  24.040  72.379  1.00 24.52           C  
ATOM   1467  C   ASP A 189       7.806  24.560  72.161  1.00 22.60           C  
ATOM   1468  O   ASP A 189       6.833  23.792  72.220  1.00 22.21           O  
ATOM   1469  CB  ASP A 189       9.767  24.540  73.730  1.00 25.85           C  
ATOM   1470  CG  ASP A 189      11.019  23.805  74.194  1.00 28.42           C  
ATOM   1471  OD1 ASP A 189      10.962  22.561  74.358  1.00 32.35           O  
ATOM   1472  OD2 ASP A 189      12.057  24.473  74.429  1.00 32.03           O  
ATOM   1473  N   LEU A 190       7.681  25.853  71.880  1.00 19.49           N  
ATOM   1474  CA  LEU A 190       6.368  26.481  71.805  1.00 17.44           C  
ATOM   1475  C   LEU A 190       5.521  25.863  70.708  1.00 17.08           C  
ATOM   1476  O   LEU A 190       4.324  25.649  70.886  1.00 15.98           O  
ATOM   1477  CB  LEU A 190       6.491  27.980  71.587  1.00 16.74           C  
ATOM   1478  CG  LEU A 190       7.197  28.718  72.730  1.00 16.75           C  
ATOM   1479  CD1 LEU A 190       7.618  30.102  72.307  1.00 17.29           C  
ATOM   1480  CD2 LEU A 190       6.309  28.753  73.975  1.00 18.34           C  
ATOM   1481  N   LEU A 191       6.150  25.547  69.579  1.00 16.66           N  
ATOM   1482  CA  LEU A 191       5.385  24.982  68.469  1.00 16.77           C  
ATOM   1483  C   LEU A 191       4.871  23.559  68.758  1.00 16.68           C  
ATOM   1484  O   LEU A 191       3.878  23.151  68.175  1.00 17.07           O  
ATOM   1485  CB  LEU A 191       6.197  24.991  67.173  1.00 16.97           C  
ATOM   1486  CG  LEU A 191       6.533  26.314  66.487  1.00 17.66           C  
ATOM   1487  CD1 LEU A 191       7.561  26.087  65.393  1.00 22.41           C  
ATOM   1488  CD2 LEU A 191       5.280  26.934  65.905  1.00 20.18           C  
ATOM   1489  N   ASN A 192       5.530  22.823  69.655  1.00 16.59           N  
ATOM   1490  CA  ASN A 192       5.036  21.503  70.039  1.00 16.57           C  
ATOM   1491  C   ASN A 192       3.654  21.549  70.681  1.00 15.89           C  
ATOM   1492  O   ASN A 192       2.992  20.515  70.796  1.00 15.77           O  
ATOM   1493  CB  ASN A 192       6.010  20.806  70.979  1.00 17.31           C  
ATOM   1494  CG  ASN A 192       7.248  20.271  70.260  1.00 18.64           C  
ATOM   1495  OD1 ASN A 192       7.267  20.134  69.047  1.00 22.45           O  
ATOM   1496  ND2 ASN A 192       8.289  19.989  71.022  1.00 23.40           N  
ATOM   1497  N   TYR A 193       3.230  22.744  71.097  1.00 15.78           N  
ATOM   1498  CA  TYR A 193       1.907  22.945  71.700  1.00 16.28           C  
ATOM   1499  C   TYR A 193       0.839  23.531  70.761  1.00 15.63           C  
ATOM   1500  O   TYR A 193      -0.252  23.878  71.218  1.00 15.30           O  
ATOM   1501  CB  TYR A 193       2.023  23.768  72.982  1.00 16.55           C  
ATOM   1502  CG  TYR A 193       2.957  23.132  73.989  1.00 18.60           C  
ATOM   1503  CD1 TYR A 193       2.494  22.168  74.878  1.00 19.81           C  
ATOM   1504  CD2 TYR A 193       4.319  23.451  74.002  1.00 20.85           C  
ATOM   1505  CE1 TYR A 193       3.373  21.544  75.793  1.00 19.80           C  
ATOM   1506  CE2 TYR A 193       5.199  22.852  74.917  1.00 19.97           C  
ATOM   1507  CZ  TYR A 193       4.714  21.897  75.792  1.00 19.37           C  
ATOM   1508  OH  TYR A 193       5.562  21.311  76.698  1.00 22.13           O  
ATOM   1509  N   GLN A 194       1.128  23.601  69.459  1.00 15.33           N  
ATOM   1510  CA  GLN A 194       0.108  24.010  68.470  1.00 15.28           C  
ATOM   1511  C   GLN A 194      -0.547  25.378  68.821  1.00 14.55           C  
ATOM   1512  O   GLN A 194      -1.779  25.455  69.053  1.00 13.89           O  
ATOM   1513  CB  GLN A 194      -0.980  22.916  68.267  1.00 16.15           C  
ATOM   1514  CG  GLN A 194      -0.455  21.566  67.718  1.00 17.95           C  
ATOM   1515  CD  GLN A 194       0.419  20.822  68.713  1.00 19.54           C  
ATOM   1516  OE1 GLN A 194       0.018  20.568  69.856  1.00 19.05           O  
ATOM   1517  NE2 GLN A 194       1.625  20.450  68.270  1.00 19.83           N  
ATOM   1518  N   PRO A 195       0.271  26.455  68.893  1.00 14.28           N  
ATOM   1519  CA  PRO A 195      -0.339  27.760  69.160  1.00 14.10           C  
ATOM   1520  C   PRO A 195      -1.288  28.189  68.053  1.00 13.95           C  
ATOM   1521  O   PRO A 195      -1.143  27.791  66.888  1.00 14.70           O  
ATOM   1522  CB  PRO A 195       0.852  28.731  69.189  1.00 14.01           C  
ATOM   1523  CG  PRO A 195       1.948  28.026  68.482  1.00 14.35           C  
ATOM   1524  CD  PRO A 195       1.736  26.557  68.719  1.00 13.73           C  
ATOM   1525  N   ASP A 196      -2.200  29.072  68.400  1.00 14.12           N  
ATOM   1526  CA  ASP A 196      -3.176  29.594  67.453  1.00 14.90           C  
ATOM   1527  C   ASP A 196      -2.606  30.640  66.519  1.00 14.61           C  
ATOM   1528  O   ASP A 196      -3.135  30.879  65.437  1.00 15.34           O  
ATOM   1529  CB  ASP A 196      -4.383  30.132  68.211  1.00 15.53           C  
ATOM   1530  CG  ASP A 196      -5.096  29.037  68.980  1.00 18.09           C  
ATOM   1531  OD1 ASP A 196      -5.677  28.137  68.321  1.00 19.28           O  
ATOM   1532  OD2 ASP A 196      -5.012  29.020  70.223  1.00 17.67           O  
ATOM   1533  N   TYR A 197      -1.517  31.266  66.952  1.00 14.00           N  
ATOM   1534  CA  TYR A 197      -0.821  32.292  66.184  1.00 13.81           C  
ATOM   1535  C   TYR A 197       0.569  32.407  66.797  1.00 14.28           C  
ATOM   1536  O   TYR A 197       0.779  32.048  67.968  1.00 13.32           O  
ATOM   1537  CB  TYR A 197      -1.567  33.615  66.291  1.00 15.18           C  
ATOM   1538  CG  TYR A 197      -1.050  34.704  65.376  1.00 15.06           C  
ATOM   1539  CD1 TYR A 197      -1.526  34.833  64.050  1.00 19.55           C  
ATOM   1540  CD2 TYR A 197      -0.118  35.626  65.839  1.00 18.93           C  
ATOM   1541  CE1 TYR A 197      -1.059  35.858  63.214  1.00 18.05           C  
ATOM   1542  CE2 TYR A 197       0.358  36.647  65.018  1.00 20.40           C  
ATOM   1543  CZ  TYR A 197      -0.114  36.751  63.724  1.00 17.54           C  
ATOM   1544  OH  TYR A 197       0.400  37.766  62.952  1.00 22.78           O  
ATOM   1545  N   ILE A 198       1.529  32.890  66.007  1.00 13.56           N  
ATOM   1546  CA  ILE A 198       2.905  33.017  66.504  1.00 14.33           C  
ATOM   1547  C   ILE A 198       3.502  34.341  66.037  1.00 13.99           C  
ATOM   1548  O   ILE A 198       3.167  34.814  64.957  1.00 14.06           O  
ATOM   1549  CB  ILE A 198       3.805  31.797  66.103  1.00 13.89           C  
ATOM   1550  CG1 ILE A 198       5.187  31.874  66.776  1.00 16.59           C  
ATOM   1551  CG2 ILE A 198       3.920  31.675  64.614  1.00 16.66           C  
ATOM   1552  CD1 ILE A 198       5.839  30.473  67.034  1.00 16.11           C  
ATOM   1553  N   ALA A 199       4.361  34.943  66.854  1.00 13.57           N  
ATOM   1554  CA  ALA A 199       4.977  36.226  66.508  1.00 14.64           C  
ATOM   1555  C   ALA A 199       6.408  36.284  66.969  1.00 14.30           C  
ATOM   1556  O   ALA A 199       6.700  36.005  68.129  1.00 14.61           O  
ATOM   1557  CB  ALA A 199       4.214  37.404  67.127  1.00 14.00           C  
ATOM   1558  N   HIS A 200       7.294  36.729  66.088  1.00 15.43           N  
ATOM   1559  CA  HIS A 200       8.675  36.976  66.515  1.00 16.52           C  
ATOM   1560  C   HIS A 200       8.961  38.448  66.865  1.00 16.52           C  
ATOM   1561  O   HIS A 200      10.036  38.770  67.380  1.00 15.58           O  
ATOM   1562  CB  HIS A 200       9.711  36.401  65.514  1.00 17.39           C  
ATOM   1563  CG  HIS A 200       9.826  37.155  64.226  1.00 20.18           C  
ATOM   1564  ND1 HIS A 200       8.875  37.084  63.230  1.00 23.19           N  
ATOM   1565  CD2 HIS A 200      10.806  37.958  63.751  1.00 22.44           C  
ATOM   1566  CE1 HIS A 200       9.252  37.832  62.206  1.00 23.72           C  
ATOM   1567  NE2 HIS A 200      10.415  38.384  62.503  1.00 24.57           N  
ATOM   1568  N   LYS A 201       7.994  39.320  66.570  1.00 16.50           N  
ATOM   1569  CA  LYS A 201       8.083  40.739  66.846  1.00 17.22           C  
ATOM   1570  C   LYS A 201       6.748  41.234  67.395  1.00 15.97           C  
ATOM   1571  O   LYS A 201       5.692  40.812  66.909  1.00 15.52           O  
ATOM   1572  CB  LYS A 201       8.364  41.535  65.565  1.00 17.94           C  
ATOM   1573  CG  LYS A 201       9.779  41.444  65.023  1.00 22.18           C  
ATOM   1574  CD  LYS A 201       9.791  42.187  63.693  1.00 27.82           C  
ATOM   1575  CE  LYS A 201      11.092  42.959  63.463  1.00 32.98           C  
ATOM   1576  NZ  LYS A 201      11.043  43.701  62.158  1.00 34.21           N  
ATOM   1577  N   PRO A 202       6.782  42.149  68.374  1.00 16.24           N  
ATOM   1578  CA  PRO A 202       5.526  42.612  68.980  1.00 16.24           C  
ATOM   1579  C   PRO A 202       4.446  43.046  68.001  1.00 16.74           C  
ATOM   1580  O   PRO A 202       3.305  42.647  68.189  1.00 16.39           O  
ATOM   1581  CB  PRO A 202       5.978  43.772  69.874  1.00 16.48           C  
ATOM   1582  CG  PRO A 202       7.362  43.307  70.317  1.00 15.96           C  
ATOM   1583  CD  PRO A 202       7.945  42.779  69.031  1.00 16.23           C  
ATOM   1584  N   LEU A 203       4.767  43.831  66.964  1.00 17.55           N  
ATOM   1585  CA  LEU A 203       3.694  44.340  66.071  1.00 18.53           C  
ATOM   1586  C   LEU A 203       3.075  43.280  65.154  1.00 18.70           C  
ATOM   1587  O   LEU A 203       1.927  43.427  64.656  1.00 19.28           O  
ATOM   1588  CB  LEU A 203       4.090  45.633  65.319  1.00 18.62           C  
ATOM   1589  CG  LEU A 203       4.546  46.816  66.189  1.00 20.57           C  
ATOM   1590  CD1 LEU A 203       4.751  48.076  65.326  1.00 22.06           C  
ATOM   1591  CD2 LEU A 203       3.597  47.117  67.345  1.00 19.55           C  
ATOM   1592  N   GLU A 204       3.769  42.152  65.021  1.00 17.85           N  
ATOM   1593  CA  GLU A 204       3.198  41.008  64.323  1.00 17.97           C  
ATOM   1594  C   GLU A 204       1.925  40.453  65.077  1.00 18.35           C  
ATOM   1595  O   GLU A 204       1.006  39.896  64.477  1.00 16.74           O  
ATOM   1596  CB  GLU A 204       4.279  39.962  64.221  1.00 19.30           C  
ATOM   1597  CG  GLU A 204       3.994  38.871  63.264  1.00 20.44           C  
ATOM   1598  CD  GLU A 204       5.153  37.892  63.183  1.00 22.00           C  
ATOM   1599  OE1 GLU A 204       6.198  38.102  63.863  1.00 20.42           O  
ATOM   1600  OE2 GLU A 204       4.981  36.914  62.443  1.00 21.60           O  
ATOM   1601  N   VAL A 205       1.884  40.676  66.388  1.00 16.51           N  
ATOM   1602  CA  VAL A 205       0.768  40.206  67.230  1.00 16.85           C  
ATOM   1603  C   VAL A 205      -0.553  40.814  66.757  1.00 16.90           C  
ATOM   1604  O   VAL A 205      -1.616  40.201  66.821  1.00 16.51           O  
ATOM   1605  CB  VAL A 205       1.001  40.561  68.715  1.00 17.08           C  
ATOM   1606  CG1 VAL A 205      -0.250  40.271  69.536  1.00 18.45           C  
ATOM   1607  CG2 VAL A 205       2.177  39.755  69.301  1.00 19.14           C  
ATOM   1608  N   LEU A 206      -0.467  42.044  66.272  1.00 17.22           N  
ATOM   1609  CA  LEU A 206      -1.642  42.864  66.001  1.00 18.11           C  
ATOM   1610  C   LEU A 206      -2.471  42.299  64.871  1.00 18.43           C  
ATOM   1611  O   LEU A 206      -3.686  42.395  64.895  1.00 18.10           O  
ATOM   1612  CB  LEU A 206      -1.197  44.277  65.654  1.00 17.27           C  
ATOM   1613  CG  LEU A 206      -0.663  45.047  66.840  1.00 18.48           C  
ATOM   1614  CD1 LEU A 206      -0.029  46.337  66.320  1.00 21.68           C  
ATOM   1615  CD2 LEU A 206      -1.799  45.351  67.842  1.00 21.66           C  
ATOM   1616  N   ALA A 207      -1.793  41.693  63.896  1.00 19.89           N  
ATOM   1617  CA  ALA A 207      -2.430  41.121  62.705  1.00 20.84           C  
ATOM   1618  C   ALA A 207      -3.439  40.026  63.037  1.00 21.32           C  
ATOM   1619  O   ALA A 207      -4.428  39.847  62.321  1.00 21.85           O  
ATOM   1620  CB  ALA A 207      -1.354  40.583  61.739  1.00 20.85           C  
ATOM   1621  N   TYR A 208      -3.205  39.288  64.132  1.00 21.41           N  
ATOM   1622  CA  TYR A 208      -4.139  38.253  64.525  1.00 21.68           C  
ATOM   1623  C   TYR A 208      -5.508  38.827  64.800  1.00 22.06           C  
ATOM   1624  O   TYR A 208      -6.512  38.205  64.467  1.00 22.25           O  
ATOM   1625  CB  TYR A 208      -3.660  37.449  65.744  1.00 21.06           C  
ATOM   1626  CG  TYR A 208      -4.510  36.225  66.026  1.00 21.92           C  
ATOM   1627  CD1 TYR A 208      -4.661  35.220  65.063  1.00 21.83           C  
ATOM   1628  CD2 TYR A 208      -5.180  36.076  67.246  1.00 21.30           C  
ATOM   1629  CE1 TYR A 208      -5.429  34.090  65.316  1.00 22.97           C  
ATOM   1630  CE2 TYR A 208      -5.968  34.948  67.510  1.00 21.50           C  
ATOM   1631  CZ  TYR A 208      -6.085  33.961  66.539  1.00 22.89           C  
ATOM   1632  OH  TYR A 208      -6.840  32.825  66.762  1.00 24.26           O  
ATOM   1633  N   PHE A 209      -5.529  40.021  65.390  1.00 22.94           N  
ATOM   1634  CA  PHE A 209      -6.760  40.682  65.761  1.00 24.86           C  
ATOM   1635  C   PHE A 209      -7.318  41.585  64.638  1.00 26.54           C  
ATOM   1636  O   PHE A 209      -8.204  42.399  64.878  1.00 27.40           O  
ATOM   1637  CB  PHE A 209      -6.543  41.429  67.089  1.00 24.03           C  
ATOM   1638  CG  PHE A 209      -5.969  40.552  68.170  1.00 22.60           C  
ATOM   1639  CD1 PHE A 209      -6.809  39.821  69.014  1.00 21.29           C  
ATOM   1640  CD2 PHE A 209      -4.581  40.412  68.316  1.00 20.67           C  
ATOM   1641  CE1 PHE A 209      -6.283  38.987  70.012  1.00 20.32           C  
ATOM   1642  CE2 PHE A 209      -4.043  39.570  69.317  1.00 21.69           C  
ATOM   1643  CZ  PHE A 209      -4.907  38.846  70.158  1.00 20.85           C  
ATOM   1644  N   GLN A 210      -6.793  41.436  63.420  1.00 28.73           N  
ATOM   1645  CA  GLN A 210      -7.411  42.046  62.228  1.00 30.62           C  
ATOM   1646  C   GLN A 210      -7.808  40.971  61.210  1.00 31.68           C  
ATOM   1647  O   GLN A 210      -7.011  40.073  60.889  1.00 32.61           O  
ATOM   1648  CB  GLN A 210      -6.487  43.078  61.574  1.00 30.76           C  
ATOM   1649  CG  GLN A 210      -6.103  44.251  62.475  1.00 33.32           C  
ATOM   1650  CD  GLN A 210      -7.265  45.174  62.818  1.00 37.36           C  
ATOM   1651  OE1 GLN A 210      -7.384  45.631  63.961  1.00 39.29           O  
ATOM   1652  NE2 GLN A 210      -8.123  45.459  61.835  1.00 37.57           N  
TER    1653      GLN A 210                                                      
END
MOLECULE T0418.pdb
ATOM      1  N   LYS     2     -13.076  35.543  67.613  1.00 29.62           N
ATOM      2  CA  LYS     2     -12.478  36.834  68.052  0.50 29.11           C
ATOM      4  CB  LYS     2     -13.375  38.010  67.650  0.50 29.29           C
ATOM      6  CG  LYS     2     -12.641  39.346  67.502  0.50 28.70           C
ATOM      8  CD  LYS     2     -13.620  40.472  67.149  0.50 28.45           C
ATOM     10  CE  LYS     2     -14.745  40.631  68.215  0.50 27.78           C
ATOM     12  NZ  LYS     2     -14.212  40.910  69.618  0.50 23.90           N
ATOM     14  C   LYS     2     -12.217  36.842  69.559  1.00 29.22           C
ATOM     15  O   LYS     2     -13.013  36.324  70.358  1.00 29.48           O
ATOM     16  N   TYR     3     -11.081  37.413  69.934  1.00 28.23           N
ATOM     17  CA  TYR     3     -10.713  37.511  71.337  1.00 28.13           C
ATOM     18  CB  TYR     3      -9.228  37.205  71.499  1.00 27.69           C
ATOM     19  CG  TYR     3      -8.855  35.913  70.851  1.00 27.85           C
ATOM     20  CD1 TYR     3      -9.318  34.695  71.359  1.00 27.15           C
ATOM     21  CE1 TYR     3      -8.963  33.481  70.741  1.00 29.48           C
ATOM     22  CZ  TYR     3      -8.150  33.512  69.615  1.00 28.31           C
ATOM     23  OH  TYR     3      -7.781  32.362  68.998  1.00 29.71           O
ATOM     24  CE2 TYR     3      -7.689  34.704  69.099  1.00 28.68           C
ATOM     25  CD2 TYR     3      -8.054  35.901  69.711  1.00 28.20           C
ATOM     26  C   TYR     3     -11.028  38.898  71.895  1.00 27.71           C
ATOM     27  O   TYR     3     -10.756  39.901  71.237  1.00 28.58           O
ATOM     28  N   THR     4     -11.608  38.949  73.092  1.00 26.98           N
ATOM     29  CA  THR     4     -11.921  40.233  73.752  1.00 26.26           C
ATOM     30  CB  THR     4     -13.434  40.362  74.092  1.00 25.63           C
ATOM     31  OG1 THR     4     -13.795  39.364  75.050  1.00 24.05           O
ATOM     32  CG2 THR     4     -14.272  40.199  72.862  1.00 25.42           C
ATOM     33  C   THR     4     -11.088  40.424  75.028  1.00 26.20           C
ATOM     34  O   THR     4     -11.218  41.432  75.726  1.00 26.38           O
ATOM     35  N   VAL     5     -10.260  39.424  75.320  1.00 26.09           N
ATOM     36  CA  VAL     5      -9.387  39.390  76.487  1.00 25.98           C
ATOM     37  CB  VAL     5      -9.988  38.533  77.656  1.00 26.21           C
ATOM     38  CG1 VAL     5      -9.003  38.455  78.853  1.00 25.67           C
ATOM     39  CG2 VAL     5     -11.398  39.033  78.080  1.00 25.14           C
ATOM     40  C   VAL     5      -8.026  38.798  76.069  1.00 26.19           C
ATOM     41  O   VAL     5      -7.939  37.642  75.627  1.00 25.71           O
ATOM     42  N   TYR     6      -6.974  39.596  76.199  1.00 25.76           N
ATOM     43  CA  TYR     6      -5.616  39.122  75.949  1.00 25.47           C
ATOM     44  CB  TYR     6      -4.867  40.089  75.019  1.00 25.89           C
ATOM     45  CG  TYR     6      -5.233  40.042  73.546  1.00 26.06           C
ATOM     46  CD1 TYR     6      -6.573  40.059  73.118  1.00 27.09           C
ATOM     47  CE1 TYR     6      -6.905  40.033  71.753  1.00 27.02           C
ATOM     48  CZ  TYR     6      -5.886  40.001  70.813  1.00 26.83           C
ATOM     49  OH  TYR     6      -6.181  39.980  69.480  1.00 25.05           O
ATOM     50  CE2 TYR     6      -4.551  40.012  71.213  1.00 25.46           C
ATOM     51  CD2 TYR     6      -4.234  40.029  72.575  1.00 26.76           C
ATOM     52  C   TYR     6      -4.877  39.026  77.278  1.00 25.08           C
ATOM     53  O   TYR     6      -4.674  40.032  77.943  1.00 24.69           O
ATOM     54  N   LEU     7      -4.487  37.816  77.670  1.00 24.54           N
ATOM     55  CA  LEU     7      -3.771  37.624  78.929  1.00 24.14           C
ATOM     56  CB  LEU     7      -4.383  36.496  79.763  1.00 23.59           C
ATOM     57  CG  LEU     7      -5.870  36.734  80.138  1.00 24.16           C
ATOM     58  CD1 LEU     7      -6.521  35.534  80.774  1.00 20.62           C
ATOM     59  CD2 LEU     7      -6.014  37.958  81.059  1.00 22.12           C
ATOM     60  C   LEU     7      -2.323  37.335  78.582  1.00 24.96           C
ATOM     61  O   LEU     7      -2.027  36.555  77.668  1.00 24.77           O
ATOM     62  N   PHE     8      -1.430  38.000  79.300  1.00 25.46           N
ATOM     63  CA  PHE     8      -0.011  37.932  79.019  1.00 25.12           C
ATOM     64  CB  PHE     8       0.536  39.346  78.747  1.00 24.90           C
ATOM     65  CG  PHE     8      -0.072  40.030  77.537  1.00 23.20           C
ATOM     66  CD1 PHE     8       0.543  39.933  76.300  1.00 20.97           C
ATOM     67  CE1 PHE     8       0.002  40.554  75.184  1.00 23.26           C
ATOM     68  CZ  PHE     8      -1.183  41.317  75.319  1.00 23.30           C
ATOM     69  CE2 PHE     8      -1.795  41.414  76.551  1.00 22.61           C
ATOM     70  CD2 PHE     8      -1.243  40.770  77.646  1.00 23.59           C
ATOM     71  C   PHE     8       0.758  37.332  80.185  1.00 25.42           C
ATOM     72  O   PHE     8       0.489  37.647  81.349  1.00 24.56           O
ATOM     73  N   ASP     9       1.705  36.454  79.854  1.00 25.13           N
ATOM     74  CA  ASP     9       2.868  36.191  80.698  1.00 25.05           C
ATOM     75  CB  ASP     9       3.770  35.134  80.038  1.00 25.36           C
ATOM     76  CG  ASP     9       4.800  34.591  80.993  1.00 26.68           C
ATOM     77  OD1 ASP     9       4.592  34.704  82.202  1.00 34.85           O
ATOM     78  OD2 ASP     9       5.854  34.101  80.583  1.00 35.24           O
ATOM     79  C   ASP     9       3.678  37.487  80.915  1.00 24.97           C
ATOM     80  O   ASP     9       3.511  38.454  80.172  1.00 26.37           O
ATOM     81  N   PHE    10       4.517  37.529  81.947  1.00 23.63           N
ATOM     82  CA  PHE    10       5.322  38.732  82.245  1.00 23.16           C
ATOM     83  CB  PHE    10       5.224  39.137  83.733  1.00 22.29           C
ATOM     84  CG  PHE    10       5.966  40.422  84.054  1.00 22.99           C
ATOM     85  CD1 PHE    10       5.373  41.665  83.808  1.00 24.77           C
ATOM     86  CE1 PHE    10       6.080  42.878  84.084  1.00 24.55           C
ATOM     87  CZ  PHE    10       7.384  42.826  84.610  1.00 22.62           C
ATOM     88  CE2 PHE    10       7.982  41.589  84.874  1.00 24.73           C
ATOM     89  CD2 PHE    10       7.276  40.382  84.582  1.00 23.46           C
ATOM     90  C   PHE    10       6.773  38.604  81.815  1.00 22.66           C
ATOM     91  O   PHE    10       7.185  39.218  80.841  1.00 23.91           O
ATOM     92  N   ASP    11       7.552  37.779  82.507  1.00 23.43           N
ATOM     93  CA  ASP    11       8.986  37.643  82.204  1.00 23.44           C
ATOM     94  CB  ASP    11       9.664  36.690  83.184  1.00 23.10           C
ATOM     95  CG  ASP    11       9.732  37.232  84.591  1.00 24.03           C
ATOM     96  OD1 ASP    11      10.159  38.406  84.796  1.00 24.46           O
ATOM     97  OD2 ASP    11       9.374  36.443  85.514  1.00 23.52           O
ATOM     98  C   ASP    11       9.215  37.131  80.776  1.00 23.25           C
ATOM     99  O   ASP    11       8.635  36.114  80.385  1.00 23.39           O
ATOM    100  N   TYR    12      10.044  37.839  80.001  1.00 21.78           N
ATOM    101  CA  TYR    12      10.289  37.470  78.592  1.00 19.73           C
ATOM    102  CB  TYR    12      10.756  36.006  78.503  1.00 20.19           C
ATOM    103  CG  TYR    12      12.274  35.815  78.587  1.00 18.57           C
ATOM    104  CD1 TYR    12      13.161  36.790  78.106  1.00 19.37           C
ATOM    105  CE1 TYR    12      14.573  36.569  78.131  1.00 17.76           C
ATOM    106  CZ  TYR    12      15.053  35.376  78.655  1.00 20.36           C
ATOM    107  OH  TYR    12      16.419  35.108  78.707  1.00 20.14           O
ATOM    108  CE2 TYR    12      14.181  34.426  79.131  1.00 19.24           C
ATOM    109  CD2 TYR    12      12.810  34.625  79.069  1.00 19.14           C
ATOM    110  C   TYR    12       9.134  37.682  77.617  1.00 20.20           C
ATOM    111  O   TYR    12       9.239  37.335  76.430  1.00 18.25           O
ATOM    112  N   THR    13       8.026  38.225  78.105  1.00 19.18           N
ATOM    113  CA  THR    13       6.883  38.448  77.261  1.00 20.06           C
ATOM    114  CB  THR    13       5.674  37.608  77.705  1.00 19.89           C
ATOM    115  OG1 THR    13       5.969  36.211  77.494  1.00 21.97           O
ATOM    116  CG2 THR    13       4.465  37.998  76.843  1.00 19.00           C
ATOM    117  C   THR    13       6.536  39.943  77.240  1.00 19.72           C
ATOM    118  O   THR    13       6.575  40.562  76.173  1.00 19.50           O
ATOM    119  N   LEU    14       6.246  40.526  78.410  1.00 19.60           N
ATOM    120  CA  LEU    14       5.990  41.979  78.467  1.00 20.37           C
ATOM    121  CB  LEU    14       4.878  42.310  79.457  1.00 19.90           C
ATOM    122  CG  LEU    14       3.462  41.924  79.113  1.00 21.71           C
ATOM    123  CD1 LEU    14       2.570  42.180  80.336  1.00 22.39           C
ATOM    124  CD2 LEU    14       2.910  42.633  77.863  1.00 25.95           C
ATOM    125  C   LEU    14       7.227  42.813  78.792  1.00 20.70           C
ATOM    126  O   LEU    14       7.279  44.014  78.491  1.00 21.38           O
ATOM    127  N   ALA    15       8.195  42.183  79.445  1.00 20.70           N
ATOM    128  CA  ALA    15       9.386  42.843  79.946  1.00 21.53           C
ATOM    129  CB  ALA    15       9.167  43.257  81.419  1.00 22.22           C
ATOM    130  C   ALA    15      10.568  41.890  79.847  1.00 21.56           C
ATOM    131  O   ALA    15      10.417  40.686  80.082  1.00 20.75           O
ATOM    132  N   ASP    16      11.748  42.401  79.485  1.00 21.65           N
ATOM    133  CA  ASP    16      12.918  41.546  79.546  1.00 21.72           C
ATOM    134  CB  ASP    16      13.931  41.880  78.453  1.00 22.91           C
ATOM    135  CG  ASP    16      15.158  40.970  78.479  1.00 22.98           C
ATOM    136  OD1 ASP    16      15.256  40.068  79.357  1.00 22.97           O
ATOM    137  OD2 ASP    16      16.035  41.171  77.614  1.00 21.32           O
ATOM    138  C   ASP    16      13.533  41.709  80.935  1.00 22.65           C
ATOM    139  O   ASP    16      14.294  42.647  81.179  1.00 22.64           O
ATOM    140  N   SER    17      13.214  40.769  81.827  1.00 22.73           N
ATOM    141  CA  SER    17      13.740  40.776  83.181  1.00 24.42           C
ATOM    142  CB  SER    17      12.653  40.291  84.135  1.00 23.74           C
ATOM    143  OG  SER    17      12.089  39.109  83.579  1.00 28.12           O
ATOM    144  C   SER    17      14.977  39.871  83.334  1.00 25.00           C
ATOM    145  O   SER    17      15.425  39.655  84.452  1.00 25.03           O
ATOM    146  N   SER    18      15.512  39.351  82.219  1.00 24.93           N
ATOM    147  CA  SER    18      16.539  38.297  82.275  1.00 25.48           C
ATOM    148  CB  SER    18      16.815  37.713  80.860  1.00 24.70           C
ATOM    149  OG  SER    18      17.501  38.638  80.023  1.00 23.20           O
ATOM    150  C   SER    18      17.860  38.750  82.945  1.00 25.77           C
ATOM    151  O   SER    18      18.536  37.947  83.585  1.00 25.96           O
ATOM    152  N   ARG    19      18.228  40.019  82.802  1.00 25.80           N
ATOM    153  CA  ARG    19      19.454  40.500  83.446  0.50 26.04           C
ATOM    155  CB  ARG    19      19.863  41.870  82.902  0.50 26.63           C
ATOM    157  CG  ARG    19      20.266  41.792  81.431  0.50 28.42           C
ATOM    159  CD  ARG    19      20.814  43.097  80.908  0.50 33.31           C
ATOM    161  NE  ARG    19      22.100  43.450  81.509  0.50 36.36           N
ATOM    163  CZ  ARG    19      23.284  43.173  80.967  0.50 38.03           C
ATOM    165  NH1 ARG    19      23.360  42.527  79.802  0.50 37.79           N
ATOM    167  NH2 ARG    19      24.395  43.547  81.592  0.50 38.32           N
ATOM    169  C   ARG    19      19.328  40.492  84.970  1.00 26.05           C
ATOM    170  O   ARG    19      20.254  40.032  85.653  1.00 25.56           O
ATOM    171  N   GLY    20      18.185  40.978  85.489  1.00 25.65           N
ATOM    172  CA  GLY    20      17.898  40.939  86.941  1.00 25.86           C
ATOM    173  C   GLY    20      17.802  39.514  87.472  1.00 25.67           C
ATOM    174  O   GLY    20      18.340  39.205  88.531  1.00 25.83           O
ATOM    175  N   ILE    21      17.082  38.657  86.746  1.00 25.96           N
ATOM    176  CA  ILE    21      16.930  37.230  87.086  1.00 24.89           C
ATOM    177  CB  ILE    21      15.928  36.485  86.153  1.00 24.71           C
ATOM    178  CG1 ILE    21      14.468  37.000  86.334  1.00 22.97           C
ATOM    179  CD1 ILE    21      13.486  36.498  85.345  1.00 23.93           C
ATOM    180  CG2 ILE    21      15.993  34.939  86.382  1.00 24.75           C
ATOM    181  C   ILE    21      18.272  36.513  87.118  1.00 25.94           C
ATOM    182  O   ILE    21      18.568  35.813  88.092  1.00 28.04           O
ATOM    183  N   VAL    22      19.102  36.677  86.098  1.00 25.95           N
ATOM    184  CA  VAL    22      20.438  36.039  86.110  1.00 26.55           C
ATOM    185  CB  VAL    22      21.199  36.235  84.782  1.00 27.39           C
ATOM    186  CG1 VAL    22      22.753  35.940  84.948  1.00 26.72           C
ATOM    187  CG2 VAL    22      20.569  35.413  83.637  1.00 26.40           C
ATOM    188  C   VAL    22      21.314  36.546  87.267  1.00 26.76           C
ATOM    189  O   VAL    22      22.037  35.767  87.887  1.00 25.07           O
ATOM    190  N   THR    23      21.254  37.854  87.561  1.00 27.27           N
ATOM    191  CA  THR    23      22.043  38.424  88.674  1.00 27.43           C
ATOM    192  CB  THR    23      21.883  39.950  88.741  1.00 28.02           C
ATOM    193  OG1 THR    23      22.366  40.506  87.529  1.00 28.87           O
ATOM    194  CG2 THR    23      22.672  40.545  89.947  1.00 28.56           C
ATOM    195  C   THR    23      21.670  37.808  90.029  1.00 27.05           C
ATOM    196  O   THR    23      22.537  37.469  90.850  1.00 26.13           O
ATOM    197  N   CYS    24      20.369  37.652  90.254  1.00 26.85           N
ATOM    198  CA  CYS    24      19.873  37.136  91.525  1.00 26.73           C
ATOM    199  CB  CYS    24      18.362  37.448  91.682  1.00 25.40           C
ATOM    200  SG  CYS    24      18.046  39.289  91.751  1.00 25.35           S
ATOM    201  C   CYS    24      20.150  35.630  91.705  1.00 27.56           C
ATOM    202  O   CYS    24      20.584  35.192  92.794  1.00 27.03           O
ATOM    203  N   PHE    25      19.901  34.853  90.650  1.00 27.63           N
ATOM    204  CA  PHE    25      20.230  33.414  90.679  1.00 28.09           C
ATOM    205  CB  PHE    25      19.819  32.678  89.403  1.00 26.94           C
ATOM    206  CG  PHE    25      18.417  32.106  89.449  1.00 29.51           C
ATOM    207  CD1 PHE    25      17.426  32.624  88.629  1.00 27.94           C
ATOM    208  CE1 PHE    25      16.112  32.110  88.663  1.00 28.76           C
ATOM    209  CZ  PHE    25      15.799  31.079  89.552  1.00 27.62           C
ATOM    210  CE2 PHE    25      16.803  30.546  90.375  1.00 31.73           C
ATOM    211  CD2 PHE    25      18.097  31.047  90.314  1.00 28.80           C
ATOM    212  C   PHE    25      21.703  33.222  90.899  1.00 27.74           C
ATOM    213  O   PHE    25      22.097  32.354  91.684  1.00 29.15           O
ATOM    214  N   ARG    26      22.524  34.010  90.213  1.00 27.88           N
ATOM    215  CA  ARG    26      23.978  33.823  90.308  1.00 28.42           C
ATOM    216  CB  ARG    26      24.713  34.601  89.198  1.00 28.29           C
ATOM    217  CG  ARG    26      26.238  34.359  89.167  1.00 29.57           C
ATOM    218  CD  ARG    26      26.980  34.899  87.936  1.00 29.18           C
ATOM    219  NE  ARG    26      26.549  34.419  86.600  1.00 30.97           N
ATOM    220  CZ  ARG    26      26.561  33.155  86.165  1.00 30.81           C
ATOM    221  NH1 ARG    26      26.934  32.159  86.957  1.00 30.26           N
ATOM    222  NH2 ARG    26      26.155  32.877  84.929  1.00 27.64           N
ATOM    223  C   ARG    26      24.526  34.138  91.711  1.00 28.16           C
ATOM    224  O   ARG    26      25.384  33.418  92.226  1.00 27.54           O
ATOM    225  N   SER    27      24.056  35.235  92.319  1.00 27.95           N
ATOM    226  CA  SER    27      24.483  35.597  93.666  0.50 27.47           C
ATOM    228  CB  SER    27      23.739  36.840  94.141  0.50 27.42           C
ATOM    230  OG  SER    27      24.178  37.951  93.400  0.50 27.80           O
ATOM    232  C   SER    27      24.271  34.432  94.639  1.00 27.30           C
ATOM    233  O   SER    27      25.197  34.015  95.305  1.00 27.61           O
ATOM    234  N   VAL    28      23.052  33.905  94.686  1.00 26.45           N
ATOM    235  CA  VAL    28      22.674  32.755  95.531  1.00 26.89           C
ATOM    236  CB  VAL    28      21.135  32.478  95.479  1.00 27.16           C
ATOM    237  CG1 VAL    28      20.756  31.357  96.422  1.00 24.69           C
ATOM    238  CG2 VAL    28      20.357  33.764  95.817  1.00 26.07           C
ATOM    239  C   VAL    28      23.447  31.484  95.190  1.00 27.64           C
ATOM    240  O   VAL    28      24.032  30.875  96.082  1.00 28.22           O
ATOM    241  N   LEU    29      23.503  31.099  93.912  1.00 27.37           N
ATOM    242  CA  LEU    29      24.213  29.857  93.522  1.00 28.25           C
ATOM    243  CB  LEU    29      24.109  29.593  92.015  1.00 28.45           C
ATOM    244  CG  LEU    29      22.726  29.208  91.464  1.00 29.00           C
ATOM    245  CD1 LEU    29      22.666  29.470  89.947  1.00 26.59           C
ATOM    246  CD2 LEU    29      22.373  27.730  91.821  1.00 29.02           C
ATOM    247  C   LEU    29      25.678  29.901  93.916  1.00 28.97           C
ATOM    248  O   LEU    29      26.217  28.916  94.424  1.00 28.08           O
ATOM    249  N   GLU    30      26.300  31.069  93.709  1.00 28.53           N
ATOM    250  CA  GLU    30      27.712  31.226  93.990  1.00 29.77           C
ATOM    251  CB  GLU    30      28.324  32.327  93.104  1.00 29.25           C
ATOM    252  CG  GLU    30      28.123  31.934  91.613  1.00 32.11           C
ATOM    253  CD  GLU    30      28.977  32.698  90.590  1.00 33.14           C
ATOM    254  OE1 GLU    30      29.451  33.828  90.882  1.00 36.50           O
ATOM    255  OE2 GLU    30      29.133  32.147  89.461  1.00 36.09           O
ATOM    256  C   GLU    30      28.017  31.373  95.490  1.00 29.27           C
ATOM    257  O   GLU    30      29.077  30.947  95.931  1.00 28.69           O
ATOM    258  N   ARG    31      27.092  31.924  96.283  1.00 28.86           N
ATOM    259  CA  ARG    31      27.307  31.954  97.728  0.50 28.90           C
ATOM    261  CB  ARG    31      26.330  32.888  98.438  0.50 28.90           C
ATOM    263  CG  ARG    31      26.840  34.324  98.552  0.50 30.25           C
ATOM    265  CD  ARG    31      25.762  35.237  99.124  0.50 32.63           C
ATOM    267  NE  ARG    31      25.933  36.640  98.735  0.50 32.56           N
ATOM    269  CZ  ARG    31      25.025  37.587  98.954  0.50 32.41           C
ATOM    271  NH1 ARG    31      23.886  37.285  99.557  0.50 33.58           N
ATOM    273  NH2 ARG    31      25.247  38.835  98.564  0.50 32.58           N
ATOM    275  C   ARG    31      27.259  30.550  98.320  1.00 28.59           C
ATOM    276  O   ARG    31      27.828  30.299  99.380  1.00 28.07           O
ATOM    277  N   HIS    32      26.606  29.629  97.618  1.00 28.11           N
ATOM    278  CA  HIS    32      26.520  28.213  98.056  1.00 27.36           C
ATOM    279  CB  HIS    32      25.082  27.701  97.993  1.00 27.06           C
ATOM    280  CG  HIS    32      24.166  28.439  98.915  1.00 29.75           C
ATOM    281  ND1 HIS    32      23.935  28.037 100.210  1.00 29.90           N
ATOM    282  CE1 HIS    32      23.122  28.891 100.798  1.00 31.29           C
ATOM    283  NE2 HIS    32      22.823  29.844  99.931  1.00 33.43           N
ATOM    284  CD2 HIS    32      23.481  29.596  98.752  1.00 29.72           C
ATOM    285  C   HIS    32      27.458  27.267  97.335  1.00 26.95           C
ATOM    286  O   HIS    32      27.357  26.045  97.477  1.00 26.82           O
ATOM    287  N   GLY    33      28.396  27.823  96.585  1.00 27.08           N
ATOM    288  CA  GLY    33      29.522  27.029  96.079  1.00 27.82           C
ATOM    289  C   GLY    33      29.279  26.510  94.672  1.00 28.67           C
ATOM    290  O   GLY    33      30.111  25.775  94.150  1.00 29.18           O
ATOM    291  N   TYR    34      28.154  26.893  94.055  1.00 28.41           N
ATOM    292  CA  TYR    34      27.799  26.396  92.732  1.00 29.53           C
ATOM    293  CB  TYR    34      26.258  26.328  92.567  1.00 30.17           C
ATOM    294  CG  TYR    34      25.622  25.328  93.505  1.00 30.57           C
ATOM    295  CD1 TYR    34      25.627  23.965  93.200  1.00 30.85           C
ATOM    296  CE1 TYR    34      25.053  23.041  94.032  1.00 28.91           C
ATOM    297  CZ  TYR    34      24.477  23.460  95.208  1.00 28.86           C
ATOM    298  OH  TYR    34      23.926  22.531  96.026  1.00 29.07           O
ATOM    299  CE2 TYR    34      24.438  24.804  95.551  1.00 30.83           C
ATOM    300  CD2 TYR    34      25.026  25.733  94.694  1.00 31.63           C
ATOM    301  C   TYR    34      28.450  27.246  91.654  1.00 30.28           C
ATOM    302  O   TYR    34      28.035  28.383  91.420  1.00 32.50           O
ATOM    303  N   THR    35      29.473  26.706  91.004  1.00 30.34           N
ATOM    304  CA  THR    35      30.226  27.444  89.992  1.00 30.36           C
ATOM    305  CB  THR    35      31.744  27.439  90.295  1.00 30.15           C
ATOM    306  OG1 THR    35      32.207  26.087  90.373  1.00 31.03           O
ATOM    307  CG2 THR    35      32.043  28.122  91.593  1.00 30.29           C
ATOM    308  C   THR    35      30.011  26.858  88.601  1.00 30.09           C
ATOM    309  O   THR    35      29.478  25.759  88.459  1.00 29.73           O
ATOM    310  N   GLY    36      30.423  27.616  87.579  1.00 30.97           N
ATOM    311  CA  GLY    36      30.337  27.193  86.168  1.00 31.00           C
ATOM    312  C   GLY    36      28.913  26.995  85.649  1.00 31.00           C
ATOM    313  O   GLY    36      28.680  26.242  84.692  1.00 31.06           O
ATOM    314  N   ILE    37      27.957  27.645  86.303  1.00 30.10           N
ATOM    315  CA  ILE    37      26.598  27.671  85.777  1.00 29.29           C
ATOM    316  CB  ILE    37      25.566  27.724  86.897  1.00 29.00           C
ATOM    317  CG1 ILE    37      25.581  26.392  87.649  1.00 28.44           C
ATOM    318  CD1 ILE    37      24.913  26.451  88.976  1.00 28.07           C
ATOM    319  CG2 ILE    37      24.167  28.102  86.320  1.00 28.30           C
ATOM    320  C   ILE    37      26.493  28.882  84.880  1.00 28.98           C
ATOM    321  O   ILE    37      26.659  30.007  85.347  1.00 30.36           O
ATOM    322  N   THR    38      26.216  28.652  83.598  1.00 28.66           N
ATOM    323  CA  THR    38      26.144  29.711  82.585  1.00 28.14           C
ATOM    324  CB  THR    38      26.280  29.130  81.169  1.00 28.45           C
ATOM    325  OG1 THR    38      25.087  28.398  80.837  1.00 28.74           O
ATOM    326  CG2 THR    38      27.513  28.237  81.063  1.00 26.51           C
ATOM    327  C   THR    38      24.845  30.529  82.605  1.00 27.96           C
ATOM    328  O   THR    38      23.821  30.081  83.120  1.00 27.32           O
ATOM    329  N   ASP    39      24.897  31.739  82.034  1.00 27.46           N
ATOM    330  CA  ASP    39      23.714  32.551  81.894  1.00 27.38           C
ATOM    331  CB  ASP    39      24.037  33.817  81.100  1.00 27.60           C
ATOM    332  CG  ASP    39      24.785  34.880  81.927  1.00 31.78           C
ATOM    333  OD1 ASP    39      25.298  34.578  83.030  1.00 29.76           O
ATOM    334  OD2 ASP    39      24.860  36.041  81.445  1.00 36.82           O
ATOM    335  C   ASP    39      22.581  31.773  81.181  1.00 26.62           C
ATOM    336  O   ASP    39      21.426  31.826  81.579  1.00 24.83           O
ATOM    337  N   ASP    40      22.918  31.086  80.096  1.00 27.24           N
ATOM    338  CA  ASP    40      21.919  30.311  79.342  1.00 27.15           C
ATOM    339  CB  ASP    40      22.520  29.713  78.068  1.00 27.25           C
ATOM    340  CG  ASP    40      22.692  30.744  76.967  1.00 29.12           C
ATOM    341  OD1 ASP    40      22.169  31.883  77.079  1.00 31.87           O
ATOM    342  OD2 ASP    40      23.385  30.427  75.997  1.00 31.62           O
ATOM    343  C   ASP    40      21.226  29.238  80.146  1.00 26.69           C
ATOM    344  O   ASP    40      20.010  29.019  79.964  1.00 26.44           O
ATOM    345  N   MET    41      21.990  28.545  80.996  1.00 27.53           N
ATOM    346  CA  MET    41      21.426  27.505  81.881  1.00 27.55           C
ATOM    347  CB  MET    41      22.518  26.766  82.672  1.00 28.11           C
ATOM    348  CG  MET    41      23.386  25.824  81.832  1.00 27.79           C
ATOM    349  SD  MET    41      24.933  25.250  82.817  0.70 27.86          SE
ATOM    350  CE  MET    41      26.300  25.146  81.476  1.00 33.34           C
ATOM    351  C   MET    41      20.394  28.130  82.818  1.00 26.96           C
ATOM    352  O   MET    41      19.331  27.583  83.044  1.00 26.08           O
ATOM    353  N   ILE    42      20.699  29.311  83.318  1.00 26.33           N
ATOM    354  CA  ILE    42      19.756  30.031  84.158  1.00 25.61           C
ATOM    355  CB  ILE    42      20.467  31.166  84.926  1.00 26.25           C
ATOM    356  CG1 ILE    42      21.518  30.578  85.900  1.00 25.24           C
ATOM    357  CD1 ILE    42      22.476  31.678  86.549  1.00 26.44           C
ATOM    358  CG2 ILE    42      19.420  32.075  85.688  1.00 26.19           C
ATOM    359  C   ILE    42      18.535  30.514  83.347  1.00 25.25           C
ATOM    360  O   ILE    42      17.389  30.269  83.724  1.00 24.15           O
ATOM    361  N   LYS    43      18.796  31.173  82.222  1.00 25.38           N
ATOM    362  CA  LYS    43      17.745  31.762  81.378  1.00 25.62           C
ATOM    363  CB  LYS    43      18.346  32.551  80.214  1.00 26.03           C
ATOM    364  CG  LYS    43      19.143  33.810  80.616  1.00 26.23           C
ATOM    365  CD  LYS    43      19.957  34.262  79.388  1.00 24.38           C
ATOM    366  CE  LYS    43      20.240  35.735  79.486  1.00 27.35           C
ATOM    367  NZ  LYS    43      20.904  36.212  78.237  1.00 26.10           N
ATOM    368  C   LYS    43      16.764  30.710  80.868  1.00 25.85           C
ATOM    369  O   LYS    43      15.580  30.994  80.724  1.00 24.83           O
ATOM    370  N   ARG    44      17.245  29.490  80.614  1.00 26.35           N
ATOM    371  CA  ARG    44      16.340  28.422  80.197  1.00 26.97           C
ATOM    372  CB  ARG    44      17.104  27.195  79.656  1.00 26.69           C
ATOM    373  CG  ARG    44      17.754  27.390  78.281  1.00 30.37           C
ATOM    374  CD  ARG    44      16.801  27.313  77.108  1.00 35.96           C
ATOM    375  NE  ARG    44      16.393  25.938  76.823  1.00 40.15           N
ATOM    376  CZ  ARG    44      15.490  25.586  75.902  1.00 42.70           C
ATOM    377  NH1 ARG    44      14.886  26.506  75.145  1.00 41.39           N
ATOM    378  NH2 ARG    44      15.193  24.300  75.727  1.00 43.13           N
ATOM    379  C   ARG    44      15.321  28.009  81.277  1.00 27.28           C
ATOM    380  O   ARG    44      14.303  27.401  80.948  1.00 27.71           O
ATOM    381  N   THR    45      15.593  28.311  82.547  1.00 27.15           N
ATOM    382  CA  THR    45      14.644  28.019  83.619  1.00 27.61           C
ATOM    383  CB  THR    45      15.326  27.716  84.985  1.00 27.21           C
ATOM    384  OG1 THR    45      15.843  28.937  85.551  1.00 29.09           O
ATOM    385  CG2 THR    45      16.436  26.718  84.856  1.00 27.55           C
ATOM    386  C   THR    45      13.690  29.185  83.899  1.00 27.14           C
ATOM    387  O   THR    45      12.780  29.023  84.684  1.00 28.51           O
ATOM    388  N   ILE    46      13.924  30.360  83.309  1.00 26.38           N
ATOM    389  CA  ILE    46      13.058  31.514  83.513  1.00 24.81           C
ATOM    390  CB  ILE    46      13.543  32.775  82.746  1.00 24.83           C
ATOM    391  CG1 ILE    46      14.857  33.293  83.339  1.00 25.02           C
ATOM    392  CD1 ILE    46      15.489  34.510  82.591  1.00 22.94           C
ATOM    393  CG2 ILE    46      12.504  33.893  82.822  1.00 26.55           C
ATOM    394  C   ILE    46      11.598  31.192  83.185  1.00 24.69           C
ATOM    395  O   ILE    46      11.268  30.770  82.062  1.00 25.30           O
ATOM    396  N   GLY    47      10.732  31.392  84.180  1.00 24.91           N
ATOM    397  CA  GLY    47       9.279  31.139  84.076  1.00 23.33           C
ATOM    398  C   GLY    47       8.809  29.870  84.793  1.00 23.77           C
ATOM    399  O   GLY    47       7.591  29.536  84.791  1.00 23.52           O
ATOM    400  N   LYS    48       9.783  29.127  85.336  1.00 22.70           N
ATOM    401  CA  LYS    48       9.524  28.036  86.281  1.00 23.25           C
ATOM    402  CB  LYS    48      10.654  27.002  86.214  1.00 22.45           C
ATOM    403  CG  LYS    48      10.857  26.464  84.806  1.00 27.54           C
ATOM    404  CD  LYS    48      11.350  25.061  84.810  1.00 32.31           C
ATOM    405  CE  LYS    48      11.689  24.601  83.391  1.00 36.95           C
ATOM    406  NZ  LYS    48      10.491  23.938  82.814  1.00 36.79           N
ATOM    407  C   LYS    48       9.493  28.706  87.663  1.00 22.37           C
ATOM    408  O   LYS    48       9.928  29.880  87.789  1.00 21.60           O
ATOM    409  N   THR    49       8.989  28.002  88.676  1.00 21.17           N
ATOM    410  CA  THR    49       9.003  28.561  90.050  1.00 22.17           C
ATOM    411  CB  THR    49       8.244  27.708  91.077  1.00 20.87           C
ATOM    412  OG1 THR    49       8.903  26.437  91.242  1.00 23.38           O
ATOM    413  CG2 THR    49       6.760  27.488  90.620  1.00 20.40           C
ATOM    414  C   THR    49      10.457  28.665  90.522  1.00 23.46           C
ATOM    415  O   THR    49      11.310  27.913  90.059  1.00 22.38           O
ATOM    416  N   LEU    50      10.739  29.592  91.434  1.00 24.65           N
ATOM    417  CA  LEU    50      12.127  29.725  91.953  1.00 25.29           C
ATOM    418  CB  LEU    50      12.165  30.782  93.045  1.00 25.19           C
ATOM    419  CG  LEU    50      11.881  32.192  92.531  1.00 24.76           C
ATOM    420  CD1 LEU    50      11.707  33.216  93.678  1.00 24.83           C
ATOM    421  CD2 LEU    50      12.921  32.656  91.473  1.00 24.86           C
ATOM    422  C   LEU    50      12.635  28.392  92.498  1.00 25.72           C
ATOM    423  O   LEU    50      13.784  28.031  92.259  1.00 26.37           O
ATOM    424  N   GLU    51      11.762  27.644  93.193  1.00 26.27           N
ATOM    425  CA  GLU    51      12.133  26.327  93.712  1.00 26.53           C
ATOM    426  CB  GLU    51      11.067  25.753  94.662  1.00 26.95           C
ATOM    427  CG  GLU    51      10.799  26.612  95.935  1.00 27.91           C
ATOM    428  CD  GLU    51       9.631  27.616  95.747  1.00 30.98           C
ATOM    429  OE1 GLU    51       9.531  28.225  94.651  1.00 27.84           O
ATOM    430  OE2 GLU    51       8.818  27.796  96.697  1.00 29.30           O
ATOM    431  C   GLU    51      12.495  25.361  92.563  1.00 26.70           C
ATOM    432  O   GLU    51      13.543  24.693  92.622  1.00 26.65           O
ATOM    433  N   GLU    52      11.646  25.293  91.523  1.00 27.02           N
ATOM    434  CA  GLU    52      11.931  24.453  90.331  1.00 26.69           C
ATOM    435  CB  GLU    52      10.818  24.546  89.280  1.00 26.89           C
ATOM    436  CG  GLU    52       9.565  23.708  89.616  1.00 28.41           C
ATOM    437  CD  GLU    52       8.298  24.195  88.906  1.00 28.69           C
ATOM    438  OE1 GLU    52       8.320  25.246  88.220  1.00 31.19           O
ATOM    439  OE2 GLU    52       7.255  23.527  89.047  1.00 31.98           O
ATOM    440  C   GLU    52      13.278  24.832  89.707  1.00 26.26           C
ATOM    441  O   GLU    52      14.060  23.956  89.329  1.00 24.51           O
ATOM    442  N   SER    53      13.532  26.142  89.600  1.00 25.45           N
ATOM    443  CA  SER    53      14.754  26.635  88.976  1.00 26.02           C
ATOM    444  CB  SER    53      14.733  28.183  88.851  1.00 26.87           C
ATOM    445  OG  SER    53      13.863  28.622  87.824  1.00 26.36           O
ATOM    446  C   SER    53      15.994  26.192  89.745  1.00 25.31           C
ATOM    447  O   SER    53      16.960  25.740  89.144  1.00 26.23           O
ATOM    448  N   PHE    54      15.943  26.324  91.074  1.00 24.48           N
ATOM    449  CA  PHE    54      17.041  25.939  91.939  1.00 24.94           C
ATOM    450  CB  PHE    54      16.828  26.429  93.379  1.00 24.22           C
ATOM    451  CG  PHE    54      17.314  27.821  93.595  1.00 24.36           C
ATOM    452  CD1 PHE    54      18.692  28.100  93.537  1.00 25.21           C
ATOM    453  CE1 PHE    54      19.151  29.414  93.696  1.00 23.93           C
ATOM    454  CZ  PHE    54      18.245  30.469  93.922  1.00 22.16           C
ATOM    455  CE2 PHE    54      16.879  30.206  93.962  1.00 21.57           C
ATOM    456  CD2 PHE    54      16.424  28.860  93.808  1.00 24.28           C
ATOM    457  C   PHE    54      17.269  24.459  91.906  1.00 25.07           C
ATOM    458  O   PHE    54      18.403  24.013  91.957  1.00 25.61           O
ATOM    459  N   SER    55      16.185  23.697  91.814  1.00 25.58           N
ATOM    460  CA  SER    55      16.289  22.240  91.782  1.00 25.02           C
ATOM    461  CB  SER    55      14.885  21.632  91.952  1.00 25.86           C
ATOM    462  OG  SER    55      15.001  20.280  92.366  1.00 28.30           O
ATOM    463  C   SER    55      16.974  21.726  90.521  1.00 25.49           C
ATOM    464  O   SER    55      17.877  20.852  90.563  1.00 24.97           O
ATOM    465  N   ILE    56      16.567  22.276  89.382  1.00 25.10           N
ATOM    466  CA  ILE    56      17.206  21.977  88.089  1.00 24.88           C
ATOM    467  CB  ILE    56      16.501  22.738  86.958  1.00 23.93           C
ATOM    468  CG1 ILE    56      15.098  22.148  86.700  1.00 24.64           C
ATOM    469  CD1 ILE    56      14.219  23.069  85.849  1.00 26.32           C
ATOM    470  CG2 ILE    56      17.285  22.712  85.666  1.00 23.81           C
ATOM    471  C   ILE    56      18.725  22.286  88.101  1.00 25.96           C
ATOM    472  O   ILE    56      19.548  21.464  87.658  1.00 26.22           O
ATOM    473  N   LEU    57      19.077  23.437  88.643  1.00 25.28           N
ATOM    474  CA  LEU    57      20.452  23.926  88.580  1.00 26.41           C
ATOM    475  CB  LEU    57      20.476  25.473  88.677  1.00 26.10           C
ATOM    476  CG  LEU    57      19.797  26.281  87.549  1.00 25.31           C
ATOM    477  CD1 LEU    57      19.590  27.811  87.876  1.00 24.42           C
ATOM    478  CD2 LEU    57      20.549  26.150  86.258  1.00 23.96           C
ATOM    479  C   LEU    57      21.404  23.285  89.603  1.00 26.46           C
ATOM    480  O   LEU    57      22.597  23.162  89.332  1.00 27.03           O
ATOM    481  N   THR    58      20.890  22.907  90.779  1.00 26.54           N
ATOM    482  CA  THR    58      21.703  22.296  91.848  1.00 25.19           C
ATOM    483  CB  THR    58      21.407  22.960  93.218  1.00 24.76           C
ATOM    484  OG1 THR    58      20.040  22.701  93.558  1.00 22.88           O
ATOM    485  CG2 THR    58      21.592  24.487  93.148  1.00 23.07           C
ATOM    486  C   THR    58      21.414  20.794  92.006  1.00 25.76           C
ATOM    487  O   THR    58      22.217  20.058  92.544  1.00 27.33           O
ATOM    488  N   GLY    59      20.252  20.343  91.561  1.00 25.51           N
ATOM    489  CA  GLY    59      19.789  18.997  91.902  1.00 24.36           C
ATOM    490  C   GLY    59      19.194  18.863  93.306  1.00 24.11           C
ATOM    491  O   GLY    59      18.716  17.795  93.663  1.00 23.45           O
ATOM    492  N   ILE    60      19.181  19.933  94.109  1.00 24.01           N
ATOM    493  CA  ILE    60      18.608  19.829  95.456  0.60 24.03           C
ATOM    495  CB  ILE    60      18.996  21.031  96.372  0.60 24.36           C
ATOM    497  CG1 ILE    60      20.453  20.901  96.820  0.60 24.92           C
ATOM    499  CD1 ILE    60      21.041  22.199  97.316  0.60 25.59           C
ATOM    501  CG2 ILE    60      18.063  21.154  97.600  0.60 22.40           C
ATOM    503  C   ILE    60      17.097  19.657  95.359  1.00 23.93           C
ATOM    504  O   ILE    60      16.445  20.324  94.582  1.00 24.92           O
ATOM    505  N   THR    61      16.553  18.731  96.142  1.00 24.07           N
ATOM    506  CA  THR    61      15.102  18.557  96.226  1.00 24.63           C
ATOM    507  CB  THR    61      14.642  17.146  95.788  1.00 25.05           C
ATOM    508  OG1 THR    61      15.257  16.165  96.623  1.00 25.67           O
ATOM    509  CG2 THR    61      15.008  16.884  94.295  1.00 23.70           C
ATOM    510  C   THR    61      14.546  18.812  97.622  1.00 25.41           C
ATOM    511  O   THR    61      13.327  18.874  97.799  1.00 25.44           O
ATOM    512  N   ASP    62      15.414  18.953  98.616  1.00 25.97           N
ATOM    513  CA  ASP    62      14.940  19.168  99.975  1.00 26.85           C
ATOM    514  CB  ASP    62      16.123  19.263 100.924  1.00 27.34           C
ATOM    515  CG  ASP    62      15.686  19.493 102.364  1.00 27.87           C
ATOM    516  OD1 ASP    62      15.320  18.536 103.033  1.00 26.73           O
ATOM    517  OD2 ASP    62      15.681  20.648 102.808  1.00 29.98           O
ATOM    518  C   ASP    62      14.055  20.416 100.096  1.00 27.29           C
ATOM    519  O   ASP    62      14.498  21.513  99.759  1.00 27.17           O
ATOM    520  N   ALA    63      12.815  20.247 100.578  1.00 27.89           N
ATOM    521  CA  ALA    63      11.841  21.362 100.623  1.00 28.56           C
ATOM    522  CB  ALA    63      10.473  20.885 101.185  1.00 29.00           C
ATOM    523  C   ALA    63      12.365  22.574 101.413  1.00 28.72           C
ATOM    524  O   ALA    63      12.181  23.737 100.997  1.00 28.41           O
ATOM    525  N   ASP    64      13.062  22.286 102.519  1.00 28.89           N
ATOM    526  CA  ASP    64      13.636  23.318 103.381  1.00 29.22           C
ATOM    527  CB  ASP    64      14.104  22.745 104.727  1.00 29.26           C
ATOM    528  CG  ASP    64      12.955  22.355 105.612  1.00 31.48           C
ATOM    529  OD1 ASP    64      11.883  22.985 105.491  1.00 33.02           O
ATOM    530  OD2 ASP    64      13.117  21.425 106.436  1.00 32.85           O
ATOM    531  C   ASP    64      14.761  24.101 102.734  1.00 28.56           C
ATOM    532  O   ASP    64      14.778  25.332 102.821  1.00 27.54           O
ATOM    533  N   GLN    65      15.693  23.399 102.094  1.00 28.14           N
ATOM    534  CA  GLN    65      16.797  24.053 101.374  1.00 28.49           C
ATOM    535  CB  GLN    65      17.810  23.019 100.894  1.00 28.50           C
ATOM    536  CG  GLN    65      18.506  22.248 102.012  1.00 29.11           C
ATOM    537  CD  GLN    65      19.533  21.230 101.486  1.00 31.31           C
ATOM    538  OE1 GLN    65      19.302  20.014 101.549  1.00 36.90           O
ATOM    539  NE2 GLN    65      20.665  21.718 100.968  1.00 31.64           N
ATOM    540  C   GLN    65      16.294  24.925 100.207  1.00 27.91           C
ATOM    541  O   GLN    65      16.720  26.065 100.039  1.00 26.59           O
ATOM    542  N   LEU    66      15.354  24.399  99.424  1.00 27.56           N
ATOM    543  CA  LEU    66      14.760  25.168  98.315  1.00 27.18           C
ATOM    544  CB  LEU    66      13.828  24.262  97.500  1.00 26.84           C
ATOM    545  CG  LEU    66      14.384  23.094  96.659  1.00 25.18           C
ATOM    546  CD1 LEU    66      13.259  22.275  95.982  1.00 26.79           C
ATOM    547  CD2 LEU    66      15.394  23.586  95.617  1.00 26.21           C
ATOM    548  C   LEU    66      14.021  26.436  98.781  1.00 27.05           C
ATOM    549  O   LEU    66      14.030  27.475  98.112  1.00 27.94           O
ATOM    550  N   GLU    67      13.384  26.341  99.942  1.00 26.89           N
ATOM    551  CA  GLU    67      12.700  27.468 100.554  1.00 26.69           C
ATOM    552  CB  GLU    67      11.852  27.010 101.775  1.00 25.64           C
ATOM    553  CG  GLU    67      11.223  28.113 102.640  1.00 25.90           C
ATOM    554  CD  GLU    67      10.382  29.109 101.877  1.00 26.46           C
ATOM    555  OE1 GLU    67       9.834  28.789 100.804  1.00 28.66           O
ATOM    556  OE2 GLU    67      10.256  30.247 102.350  1.00 27.59           O
ATOM    557  C   GLU    67      13.737  28.504 100.941  1.00 26.18           C
ATOM    558  O   GLU    67      13.521  29.697 100.822  1.00 27.27           O
ATOM    559  N   SER    68      14.864  28.030 101.412  1.00 25.95           N
ATOM    560  CA  SER    68      15.911  28.898 101.879  1.00 26.31           C
ATOM    561  CB  SER    68      16.905  28.051 102.681  1.00 27.25           C
ATOM    562  OG  SER    68      17.994  28.784 103.157  1.00 29.24           O
ATOM    563  C   SER    68      16.535  29.651 100.699  1.00 26.07           C
ATOM    564  O   SER    68      16.763  30.856 100.805  1.00 25.00           O
ATOM    565  N   PHE    69      16.778  28.949  99.576  1.00 25.50           N
ATOM    566  CA  PHE    69      17.248  29.581  98.336  1.00 25.19           C
ATOM    567  CB  PHE    69      17.395  28.567  97.206  1.00 24.70           C
ATOM    568  CG  PHE    69      18.512  27.567  97.370  1.00 25.53           C
ATOM    569  CD1 PHE    69      19.702  27.887  98.035  1.00 26.70           C
ATOM    570  CE1 PHE    69      20.716  26.931  98.150  1.00 28.65           C
ATOM    571  CZ  PHE    69      20.562  25.651  97.571  1.00 27.03           C
ATOM    572  CE2 PHE    69      19.400  25.335  96.879  1.00 26.24           C
ATOM    573  CD2 PHE    69      18.379  26.292  96.790  1.00 24.38           C
ATOM    574  C   PHE    69      16.257  30.631  97.865  1.00 24.69           C
ATOM    575  O   PHE    69      16.655  31.729  97.486  1.00 25.89           O
ATOM    576  N   ARG    70      14.963  30.295  97.896  1.00 24.28           N
ATOM    577  CA  ARG    70      13.876  31.203  97.490  1.00 23.48           C
ATOM    578  CB  ARG    70      12.516  30.535  97.711  1.00 23.43           C
ATOM    579  CG  ARG    70      11.343  31.373  97.169  1.00 25.93           C
ATOM    580  CD  ARG    70      10.008  30.924  97.709  1.00 25.22           C
ATOM    581  NE  ARG    70       9.848  31.220  99.143  1.00 26.87           N
ATOM    582  CZ  ARG    70       9.657  32.446  99.638  1.00 27.45           C
ATOM    583  NH1 ARG    70       9.620  33.480  98.814  1.00 26.75           N
ATOM    584  NH2 ARG    70       9.495  32.643 100.949  1.00 28.49           N
ATOM    585  C   ARG    70      13.917  32.522  98.251  1.00 23.63           C
ATOM    586  O   ARG    70      13.823  33.591  97.647  1.00 22.87           O
ATOM    587  N   GLN    71      13.983  32.423  99.588  1.00 24.69           N
ATOM    588  CA  GLN    71      14.148  33.569 100.473  1.00 24.47           C
ATOM    589  CB  GLN    71      14.208  33.113 101.938  1.00 24.70           C
ATOM    590  CG  GLN    71      12.897  32.571 102.509  1.00 23.50           C
ATOM    591  CD  GLN    71      13.097  31.859 103.828  1.00 24.98           C
ATOM    592  OE1 GLN    71      14.166  31.958 104.450  1.00 26.69           O
ATOM    593  NE2 GLN    71      12.069  31.118 104.266  1.00 23.32           N
ATOM    594  C   GLN    71      15.412  34.369 100.148  1.00 24.87           C
ATOM    595  O   GLN    71      15.378  35.588 100.119  1.00 24.95           O
ATOM    596  N   GLU    72      16.542  33.690  99.980  1.00 24.71           N
ATOM    597  CA  GLU    72      17.777  34.399  99.663  1.00 25.66           C
ATOM    598  CB  GLU    72      18.938  33.406  99.674  1.00 25.45           C
ATOM    599  CG  GLU    72      19.357  32.975 101.071  1.00 26.54           C
ATOM    600  CD  GLU    72      20.359  31.818 101.078  1.00 28.99           C
ATOM    601  OE1 GLU    72      21.071  31.648 100.085  1.00 32.62           O
ATOM    602  OE2 GLU    72      20.431  31.065 102.092  1.00 33.57           O
ATOM    603  C   GLU    72      17.666  35.107  98.301  1.00 25.67           C
ATOM    604  O   GLU    72      18.076  36.264  98.131  1.00 24.17           O
ATOM    605  N   TYR    73      17.052  34.419  97.340  1.00 25.70           N
ATOM    606  CA  TYR    73      16.782  35.028  96.031  1.00 26.68           C
ATOM    607  CB  TYR    73      16.141  33.993  95.088  1.00 27.29           C
ATOM    608  CG  TYR    73      15.817  34.512  93.695  1.00 28.20           C
ATOM    609  CD1 TYR    73      16.590  34.132  92.591  1.00 31.03           C
ATOM    610  CE1 TYR    73      16.285  34.585  91.282  1.00 29.75           C
ATOM    611  CZ  TYR    73      15.199  35.431  91.091  1.00 29.58           C
ATOM    612  OH  TYR    73      14.893  35.862  89.827  1.00 32.21           O
ATOM    613  CE2 TYR    73      14.401  35.810  92.161  1.00 29.04           C
ATOM    614  CD2 TYR    73      14.705  35.338  93.469  1.00 28.75           C
ATOM    615  C   TYR    73      15.905  36.296  96.138  1.00 26.82           C
ATOM    616  O   TYR    73      16.250  37.340  95.564  1.00 26.25           O
ATOM    617  N   SER    74      14.783  36.199  96.862  0.50 26.64           N
ATOM    619  CA  SER    74      13.862  37.328  97.008  0.50 27.01           C
ATOM    621  CB  SER    74      12.685  36.962  97.910  0.50 27.18           C
ATOM    623  OG  SER    74      11.538  37.724  97.557  0.50 26.47           O
ATOM    625  C   SER    74      14.576  38.564  97.555  0.50 27.39           C
ATOM    627  O   SER    74      14.302  39.694  97.129  0.50 27.58           O
ATOM    629  N   LYS    75      15.496  38.332  98.487  1.00 27.15           N
ATOM    630  CA  LYS    75      16.264  39.395  99.111  1.00 28.12           C
ATOM    631  CB  LYS    75      17.103  38.764 100.231  1.00 28.56           C
ATOM    632  CG  LYS    75      17.802  39.682 101.185  1.00 32.79           C
ATOM    633  CD  LYS    75      18.493  38.854 102.259  1.00 38.68           C
ATOM    634  CE  LYS    75      19.947  39.309 102.517  1.00 38.87           C
ATOM    635  NZ  LYS    75      20.549  38.508 103.616  1.00 39.60           N
ATOM    636  C   LYS    75      17.132  40.113  98.068  1.00 27.74           C
ATOM    637  O   LYS    75      17.167  41.341  98.035  1.00 27.27           O
ATOM    638  N   GLU    76      17.836  39.358  97.232  1.00 27.05           N
ATOM    639  CA  GLU    76      18.574  39.934  96.084  1.00 27.52           C
ATOM    640  CB  GLU    76      19.272  38.825  95.298  1.00 28.38           C
ATOM    641  CG  GLU    76      20.420  38.166  96.041  1.00 32.40           C
ATOM    642  CD  GLU    76      21.373  39.177  96.643  1.00 37.32           C
ATOM    643  OE1 GLU    76      22.041  39.882  95.873  1.00 41.38           O
ATOM    644  OE2 GLU    76      21.445  39.279  97.891  1.00 42.83           O
ATOM    645  C   GLU    76      17.646  40.667  95.132  1.00 26.18           C
ATOM    646  O   GLU    76      17.940  41.796  94.680  1.00 25.71           O
ATOM    647  N   ALA    77      16.503  40.036  94.853  1.00 24.98           N
ATOM    648  CA  ALA    77      15.527  40.597  93.911  1.00 25.01           C
ATOM    649  CB  ALA    77      14.441  39.616  93.558  1.00 24.14           C
ATOM    650  C   ALA    77      14.968  41.921  94.385  1.00 25.02           C
ATOM    651  O   ALA    77      14.687  42.790  93.555  1.00 25.34           O
ATOM    652  N   ASP    78      14.808  42.089  95.700  1.00 24.54           N
ATOM    653  CA  ASP    78      14.370  43.367  96.242  1.00 26.20           C
ATOM    654  CB  ASP    78      14.339  43.313  97.762  1.00 26.67           C
ATOM    655  CG  ASP    78      13.163  42.508  98.284  1.00 27.47           C
ATOM    656  OD1 ASP    78      12.146  42.414  97.575  1.00 25.08           O
ATOM    657  OD2 ASP    78      13.260  41.999  99.413  1.00 30.35           O
ATOM    658  C   ASP    78      15.322  44.469  95.810  1.00 26.21           C
ATOM    659  O   ASP    78      14.900  45.567  95.596  1.00 27.41           O
ATOM    660  N   ILE    79      16.608  44.147  95.685  1.00 26.39           N
ATOM    661  CA  ILE    79      17.655  45.100  95.331  1.00 26.83           C
ATOM    662  CB  ILE    79      19.024  44.667  95.967  1.00 26.42           C
ATOM    663  CG1 ILE    79      18.905  44.596  97.489  1.00 28.17           C
ATOM    664  CD1 ILE    79      19.940  43.679  98.124  1.00 32.50           C
ATOM    665  CG2 ILE    79      20.171  45.656  95.620  1.00 26.87           C
ATOM    666  C   ILE    79      17.801  45.282  93.803  1.00 27.25           C
ATOM    667  O   ILE    79      17.844  46.412  93.298  1.00 27.67           O
ATOM    668  N   TYR    80      17.850  44.175  93.065  1.00 28.09           N
ATOM    669  CA  TYR    80      18.283  44.231  91.669  1.00 29.09           C
ATOM    670  CB  TYR    80      19.430  43.251  91.445  1.00 30.35           C
ATOM    671  CG  TYR    80      20.624  43.542  92.288  1.00 31.85           C
ATOM    672  CD1 TYR    80      21.417  44.656  92.027  1.00 33.38           C
ATOM    673  CE1 TYR    80      22.552  44.925  92.804  1.00 34.84           C
ATOM    674  CZ  TYR    80      22.891  44.051  93.829  1.00 34.31           C
ATOM    675  OH  TYR    80      24.003  44.316  94.596  1.00 37.11           O
ATOM    676  CE2 TYR    80      22.118  42.931  94.100  1.00 33.96           C
ATOM    677  CD2 TYR    80      20.994  42.679  93.330  1.00 33.10           C
ATOM    678  C   TYR    80      17.249  43.990  90.600  1.00 28.71           C
ATOM    679  O   TYR    80      17.465  44.332  89.439  1.00 29.24           O
ATOM    680  N   MET    81      16.145  43.358  90.959  1.00 29.54           N
ATOM    681  CA  MET    81      15.196  42.853  89.940  1.00 28.80           C
ATOM    682  CB  MET    81      14.077  42.026  90.588  1.00 28.41           C
ATOM    683  CG  MET    81      13.115  41.381  89.582  1.00 28.54           C
ATOM    684  SD  MET    81      14.037  40.229  88.311  0.70 27.31          SE
ATOM    685  CE  MET    81      14.470  38.788  89.533  1.00 30.27           C
ATOM    686  C   MET    81      14.613  43.911  89.010  1.00 29.54           C
ATOM    687  O   MET    81      14.888  43.911  87.811  1.00 29.33           O
ATOM    688  N   ASN    82      13.792  44.807  89.546  1.00 29.64           N
ATOM    689  CA  ASN    82      13.108  45.772  88.689  1.00 29.82           C
ATOM    690  CB  ASN    82      11.882  46.382  89.386  1.00 29.60           C
ATOM    691  CG  ASN    82      10.784  45.340  89.651  1.00 30.77           C
ATOM    692  OD1 ASN    82      10.740  44.270  89.017  1.00 27.12           O
ATOM    693  ND2 ASN    82       9.870  45.668  90.561  1.00 31.10           N
ATOM    694  C   ASN    82      14.039  46.813  88.082  1.00 29.59           C
ATOM    695  O   ASN    82      13.738  47.380  87.033  1.00 29.59           O
ATOM    696  N   ALA    83      15.190  47.031  88.711  1.00 29.49           N
ATOM    697  CA  ALA    83      16.180  47.968  88.163  1.00 29.25           C
ATOM    698  CB  ALA    83      17.229  48.309  89.216  1.00 28.99           C
ATOM    699  C   ALA    83      16.845  47.377  86.920  1.00 29.57           C
ATOM    700  O   ALA    83      17.412  48.104  86.104  1.00 29.19           O
ATOM    701  N   ASN    84      16.807  46.047  86.816  1.00 29.10           N
ATOM    702  CA  ASN    84      17.450  45.340  85.729  1.00 29.00           C
ATOM    703  CB  ASN    84      18.540  44.429  86.283  1.00 29.02           C
ATOM    704  CG  ASN    84      19.706  45.231  86.858  1.00 31.57           C
ATOM    705  OD1 ASN    84      20.535  45.742  86.100  1.00 33.11           O
ATOM    706  ND2 ASN    84      19.744  45.396  88.188  1.00 28.26           N
ATOM    707  C   ASN    84      16.402  44.576  84.944  1.00 28.17           C
ATOM    708  O   ASN    84      16.602  43.439  84.537  1.00 27.97           O
ATOM    709  N   THR    85      15.251  45.232  84.789  1.00 27.16           N
ATOM    710  CA  THR    85      14.185  44.777  83.944  1.00 25.13           C
ATOM    711  CB  THR    85      12.920  44.432  84.742  1.00 25.07           C
ATOM    712  OG1 THR    85      13.158  43.304  85.625  1.00 25.99           O
ATOM    713  CG2 THR    85      11.824  44.062  83.799  1.00 23.70           C
ATOM    714  C   THR    85      13.914  45.945  82.997  1.00 24.02           C
ATOM    715  O   THR    85      13.845  47.113  83.419  1.00 23.39           O
ATOM    716  N   ILE    86      13.762  45.639  81.713  1.00 23.54           N
ATOM    717  CA  ILE    86      13.426  46.681  80.718  1.00 22.56           C
ATOM    718  CB  ILE    86      14.574  46.876  79.682  1.00 23.19           C
ATOM    719  CG1 ILE    86      14.888  45.576  78.937  1.00 21.71           C
ATOM    720  CD1 ILE    86      15.941  45.757  77.811  1.00 21.68           C
ATOM    721  CG2 ILE    86      15.863  47.412  80.376  1.00 24.58           C
ATOM    722  C   ILE    86      12.104  46.310  80.016  1.00 22.41           C
ATOM    723  O   ILE    86      11.770  45.125  79.931  1.00 22.12           O
ATOM    724  N   LEU    87      11.383  47.301  79.495  1.00 20.46           N
ATOM    725  CA  LEU    87      10.271  47.047  78.556  1.00 21.06           C
ATOM    726  CB  LEU    87       9.527  48.370  78.228  1.00 20.51           C
ATOM    727  CG  LEU    87       8.794  49.100  79.348  1.00 20.09           C
ATOM    728  CD1 LEU    87       8.384  50.552  78.995  1.00 16.88           C
ATOM    729  CD2 LEU    87       7.596  48.304  79.781  1.00 18.68           C
ATOM    730  C   LEU    87      10.799  46.471  77.222  1.00 21.20           C
ATOM    731  O   LEU    87      11.927  46.754  76.831  1.00 21.66           O
ATOM    732  N   PHE    88       9.987  45.674  76.538  1.00 20.05           N
ATOM    733  CA  PHE    88      10.257  45.319  75.142  1.00 20.27           C
ATOM    734  CB  PHE    88       9.515  44.018  74.724  1.00 19.56           C
ATOM    735  CG  PHE    88      10.201  42.735  75.188  1.00 20.59           C
ATOM    736  CD1 PHE    88      11.463  42.382  74.702  1.00 23.45           C
ATOM    737  CE1 PHE    88      12.081  41.228  75.105  1.00 22.55           C
ATOM    738  CZ  PHE    88      11.481  40.419  76.026  1.00 20.15           C
ATOM    739  CE2 PHE    88      10.225  40.743  76.509  1.00 24.68           C
ATOM    740  CD2 PHE    88       9.595  41.893  76.090  1.00 21.23           C
ATOM    741  C   PHE    88       9.828  46.473  74.259  1.00 20.40           C
ATOM    742  O   PHE    88       8.905  47.226  74.628  1.00 21.31           O
ATOM    743  N   PRO    89      10.505  46.651  73.100  1.00 20.26           N
ATOM    744  CA  PRO    89      10.186  47.730  72.178  1.00 20.40           C
ATOM    745  CB  PRO    89      11.007  47.367  70.922  1.00 20.36           C
ATOM    746  CG  PRO    89      12.204  46.716  71.480  1.00 21.73           C
ATOM    747  CD  PRO    89      11.653  45.860  72.614  1.00 20.33           C
ATOM    748  C   PRO    89       8.712  47.879  71.828  1.00 20.08           C
ATOM    749  O   PRO    89       8.274  48.994  71.528  1.00 20.03           O
ATOM    750  N   ASP    90       7.968  46.772  71.838  1.00 20.35           N
ATOM    751  CA  ASP    90       6.579  46.769  71.395  1.00 20.75           C
ATOM    752  CB  ASP    90       6.297  45.545  70.510  1.00 21.27           C
ATOM    753  CG  ASP    90       7.023  45.583  69.186  1.00 22.79           C
ATOM    754  OD1 ASP    90       7.466  46.661  68.743  1.00 24.07           O
ATOM    755  OD2 ASP    90       7.119  44.521  68.561  1.00 25.29           O
ATOM    756  C   ASP    90       5.548  46.757  72.517  1.00 20.34           C
ATOM    757  O   ASP    90       4.351  46.681  72.247  1.00 20.78           O
ATOM    758  N   THR    91       5.989  46.807  73.765  1.00 20.54           N
ATOM    759  CA  THR    91       5.087  46.550  74.890  1.00 19.97           C
ATOM    760  CB  THR    91       5.857  46.390  76.213  1.00 19.95           C
ATOM    761  OG1 THR    91       6.664  45.219  76.137  1.00 22.13           O
ATOM    762  CG2 THR    91       4.911  46.239  77.384  1.00 20.27           C
ATOM    763  C   THR    91       4.029  47.633  75.011  1.00 19.15           C
ATOM    764  O   THR    91       2.838  47.342  75.001  1.00 18.57           O
ATOM    765  N   LEU    92       4.478  48.877  75.141  1.00 18.33           N
ATOM    766  CA  LEU    92       3.569  49.989  75.332  1.00 18.26           C
ATOM    767  CB  LEU    92       4.323  51.266  75.763  1.00 17.66           C
ATOM    768  CG  LEU    92       5.227  51.281  77.007  1.00 15.19           C
ATOM    769  CD1 LEU    92       5.965  52.631  77.097  1.00 11.30           C
ATOM    770  CD2 LEU    92       4.395  51.084  78.225  1.00 16.51           C
ATOM    771  C   LEU    92       2.692  50.262  74.103  1.00 18.76           C
ATOM    772  O   LEU    92       1.479  50.461  74.258  1.00 20.01           O
ATOM    773  N   PRO    93       3.285  50.318  72.885  1.00 18.59           N
ATOM    774  CA  PRO    93       2.364  50.587  71.758  1.00 18.67           C
ATOM    775  CB  PRO    93       3.292  50.693  70.536  1.00 18.83           C
ATOM    776  CG  PRO    93       4.698  50.769  71.074  1.00 18.40           C
ATOM    777  CD  PRO    93       4.685  50.178  72.449  1.00 18.35           C
ATOM    778  C   PRO    93       1.340  49.477  71.546  1.00 18.83           C
ATOM    779  O   PRO    93       0.227  49.749  71.129  1.00 18.94           O
ATOM    780  N   THR    94       1.708  48.232  71.826  1.00 19.04           N
ATOM    781  CA  THR    94       0.799  47.110  71.575  1.00 18.95           C
ATOM    782  CB  THR    94       1.516  45.739  71.710  1.00 19.65           C
ATOM    783  OG1 THR    94       2.523  45.622  70.690  1.00 19.01           O
ATOM    784  CG2 THR    94       0.513  44.590  71.527  1.00 18.15           C
ATOM    785  C   THR    94      -0.385  47.186  72.529  1.00 19.25           C
ATOM    786  O   THR    94      -1.541  47.153  72.113  1.00 19.28           O
ATOM    787  N   LEU    95      -0.073  47.296  73.816  1.00 19.96           N
ATOM    788  CA  LEU    95      -1.064  47.294  74.859  1.00 20.68           C
ATOM    789  CB  LEU    95      -0.380  47.224  76.227  1.00 21.67           C
ATOM    790  CG  LEU    95       0.341  45.925  76.619  1.00 22.31           C
ATOM    791  CD1 LEU    95       0.903  46.007  78.025  1.00 26.20           C
ATOM    792  CD2 LEU    95      -0.599  44.775  76.550  1.00 26.86           C
ATOM    793  C   LEU    95      -1.964  48.513  74.739  1.00 21.16           C
ATOM    794  O   LEU    95      -3.156  48.409  75.010  1.00 21.22           O
ATOM    795  N   THR    96      -1.408  49.655  74.304  1.00 21.25           N
ATOM    796  CA  THR    96      -2.213  50.844  74.008  1.00 21.22           C
ATOM    797  CB  THR    96      -1.338  52.040  73.563  1.00 21.29           C
ATOM    798  OG1 THR    96      -0.447  52.403  74.605  1.00 22.50           O
ATOM    799  CG2 THR    96      -2.194  53.256  73.207  1.00 21.56           C
ATOM    800  C   THR    96      -3.212  50.575  72.883  1.00 21.43           C
ATOM    801  O   THR    96      -4.374  50.993  72.946  1.00 20.99           O
ATOM    802  N   HIS    97      -2.737  49.910  71.833  1.00 21.94           N
ATOM    803  CA  HIS    97      -3.573  49.581  70.677  1.00 22.43           C
ATOM    804  CB  HIS    97      -2.729  48.978  69.553  1.00 22.64           C
ATOM    805  CG  HIS    97      -3.449  48.856  68.245  1.00 25.32           C
ATOM    806  ND1 HIS    97      -4.263  47.784  67.938  1.00 28.13           N
ATOM    807  CE1 HIS    97      -4.763  47.944  66.725  1.00 28.68           C
ATOM    808  NE2 HIS    97      -4.302  49.081  66.232  1.00 29.53           N
ATOM    809  CD2 HIS    97      -3.471  49.667  67.160  1.00 26.78           C
ATOM    810  C   HIS    97      -4.720  48.648  71.076  1.00 22.49           C
ATOM    811  O   HIS    97      -5.854  48.863  70.656  1.00 22.54           O
ATOM    812  N   LEU    98      -4.430  47.629  71.890  1.00 22.90           N
ATOM    813  CA  LEU    98      -5.458  46.702  72.362  1.00 23.05           C
ATOM    814  CB  LEU    98      -4.842  45.521  73.120  1.00 22.74           C
ATOM    815  CG  LEU    98      -3.923  44.586  72.326  1.00 20.64           C
ATOM    816  CD1 LEU    98      -3.169  43.591  73.244  1.00 19.50           C
ATOM    817  CD2 LEU    98      -4.696  43.869  71.205  1.00 15.85           C
ATOM    818  C   LEU    98      -6.521  47.403  73.206  1.00 24.50           C
ATOM    819  O   LEU    98      -7.726  47.184  73.018  1.00 24.67           O
ATOM    820  N   LYS    99      -6.088  48.277  74.109  1.00 25.44           N
ATOM    821  CA  LYS    99      -7.014  48.998  74.982  1.00 26.42           C
ATOM    822  CB  LYS    99      -6.260  49.699  76.127  1.00 26.77           C
ATOM    823  CG  LYS    99      -5.628  48.723  77.140  1.00 26.71           C
ATOM    824  CD  LYS    99      -4.999  49.441  78.340  1.00 26.66           C
ATOM    825  CE  LYS    99      -6.024  50.184  79.192  1.00 27.89           C
ATOM    826  NZ  LYS    99      -6.935  49.263  79.920  1.00 27.25           N
ATOM    827  C   LYS    99      -7.900  49.979  74.213  1.00 26.96           C
ATOM    828  O   LYS    99      -9.057  50.203  74.591  1.00 27.40           O
ATOM    829  N   LYS   100      -7.366  50.550  73.134  1.00 27.31           N
ATOM    830  CA  LYS   100      -8.170  51.373  72.221  1.00 27.99           C
ATOM    831  CB  LYS   100      -7.292  52.088  71.196  1.00 27.98           C
ATOM    832  CG  LYS   100      -6.720  53.359  71.726  1.00 28.10           C
ATOM    833  CD  LYS   100      -5.347  53.618  71.174  1.00 28.05           C
ATOM    834  CE  LYS   100      -4.886  55.015  71.598  1.00 27.96           C
ATOM    835  NZ  LYS   100      -3.640  55.417  70.892  1.00 27.88           N
ATOM    836  C   LYS   100      -9.232  50.545  71.508  1.00 28.41           C
ATOM    837  O   LYS   100     -10.315  51.042  71.219  1.00 28.22           O
ATOM    838  N   GLN   101      -8.914  49.284  71.229  1.00 28.51           N
ATOM    839  CA  GLN   101      -9.890  48.354  70.668  1.00 29.51           C
ATOM    840  CB  GLN   101      -9.191  47.086  70.149  1.00 29.23           C
ATOM    841  CG  GLN   101      -8.506  47.273  68.804  1.00 30.53           C
ATOM    842  CD  GLN   101      -7.812  46.019  68.316  1.00 31.28           C
ATOM    843  OE1 GLN   101      -6.947  45.463  68.993  1.00 33.95           O
ATOM    844  NE2 GLN   101      -8.189  45.565  67.126  1.00 33.53           N
ATOM    845  C   GLN   101     -10.974  47.988  71.693  1.00 28.92           C
ATOM    846  O   GLN   101     -12.006  47.445  71.332  1.00 29.19           O
ATOM    847  N   GLY   102     -10.732  48.279  72.970  1.00 28.44           N
ATOM    848  CA  GLY   102     -11.660  47.886  74.028  1.00 27.66           C
ATOM    849  C   GLY   102     -11.490  46.434  74.428  1.00 26.90           C
ATOM    850  O   GLY   102     -12.374  45.836  75.033  1.00 27.53           O
ATOM    851  N   ILE   103     -10.357  45.856  74.068  1.00 25.97           N
ATOM    852  CA  ILE   103      -9.954  44.571  74.592  1.00 25.15           C
ATOM    853  CB  ILE   103      -8.891  43.916  73.657  1.00 25.72           C
ATOM    854  CG1 ILE   103      -9.598  43.387  72.394  1.00 28.75           C
ATOM    855  CD1 ILE   103      -8.858  43.602  71.071  1.00 32.21           C
ATOM    856  CG2 ILE   103      -8.148  42.768  74.356  1.00 24.81           C
ATOM    857  C   ILE   103      -9.470  44.760  76.047  1.00 24.11           C
ATOM    858  O   ILE   103      -8.841  45.775  76.378  1.00 23.64           O
ATOM    859  N   ARG   104      -9.836  43.809  76.905  1.00 22.93           N
ATOM    860  CA  ARG   104      -9.393  43.739  78.295  1.00 22.38           C
ATOM    861  CB  ARG   104     -10.432  43.052  79.189  1.00 21.82           C
ATOM    862  CG  ARG   104     -11.639  43.963  79.511  1.00 22.99           C
ATOM    863  CD  ARG   104     -12.555  43.350  80.543  1.00 23.79           C
ATOM    864  NE  ARG   104     -13.217  42.158  80.016  1.00 26.02           N
ATOM    865  CZ  ARG   104     -13.959  41.322  80.739  1.00 26.04           C
ATOM    866  NH1 ARG   104     -14.138  41.542  82.034  1.00 25.71           N
ATOM    867  NH2 ARG   104     -14.514  40.259  80.165  1.00 24.78           N
ATOM    868  C   ARG   104      -8.044  43.011  78.368  1.00 22.15           C
ATOM    869  O   ARG   104      -7.842  41.976  77.722  1.00 22.69           O
ATOM    870  N   ILE   105      -7.113  43.562  79.132  1.00 21.37           N
ATOM    871  CA  ILE   105      -5.799  42.950  79.221  1.00 21.36           C
ATOM    872  CB  ILE   105      -4.685  43.845  78.615  1.00 21.45           C
ATOM    873  CG1 ILE   105      -4.622  45.208  79.317  1.00 21.21           C
ATOM    874  CD1 ILE   105      -3.372  46.006  78.973  1.00 20.99           C
ATOM    875  CG2 ILE   105      -4.901  44.025  77.098  1.00 22.71           C
ATOM    876  C   ILE   105      -5.508  42.545  80.651  1.00 21.31           C
ATOM    877  O   ILE   105      -6.029  43.114  81.590  1.00 21.58           O
ATOM    878  N   GLY   106      -4.696  41.517  80.814  1.00 21.48           N
ATOM    879  CA  GLY   106      -4.307  41.082  82.138  1.00 21.34           C
ATOM    880  C   GLY   106      -2.972  40.364  82.072  1.00 20.93           C
ATOM    881  O   GLY   106      -2.430  40.139  80.986  1.00 20.08           O
ATOM    882  N   ILE   107      -2.447  40.026  83.243  1.00 20.95           N
ATOM    883  CA  ILE   107      -1.160  39.319  83.378  1.00 20.93           C
ATOM    884  CB  ILE   107      -0.078  40.214  84.049  1.00 21.11           C
ATOM    885  CG1 ILE   107       0.325  41.388  83.152  1.00 20.55           C
ATOM    886  CD1 ILE   107       1.349  42.345  83.836  1.00 20.00           C
ATOM    887  CG2 ILE   107       1.203  39.438  84.401  1.00 20.89           C
ATOM    888  C   ILE   107      -1.370  38.055  84.222  1.00 21.98           C
ATOM    889  O   ILE   107      -1.968  38.122  85.302  1.00 21.96           O
ATOM    890  N   ILE   108      -0.906  36.905  83.738  1.00 23.06           N
ATOM    891  CA  ILE   108      -0.777  35.707  84.608  1.00 24.09           C
ATOM    892  CB  ILE   108      -1.797  34.550  84.282  1.00 25.43           C
ATOM    893  CG1 ILE   108      -3.226  34.916  84.748  1.00 27.07           C
ATOM    894  CD1 ILE   108      -4.015  35.716  83.788  1.00 27.73           C
ATOM    895  CG2 ILE   108      -1.415  33.269  85.006  1.00 23.92           C
ATOM    896  C   ILE   108       0.689  35.245  84.615  1.00 24.05           C
ATOM    897  O   ILE   108       1.273  34.891  83.595  1.00 24.50           O
ATOM    898  N   SER   109       1.303  35.319  85.788  1.00 24.00           N
ATOM    899  CA  SER   109       2.734  35.260  85.873  1.00 23.46           C
ATOM    900  CB  SER   109       3.332  36.695  85.913  1.00 23.91           C
ATOM    901  OG  SER   109       4.739  36.634  86.160  1.00 21.24           O
ATOM    902  C   SER   109       3.136  34.440  87.085  1.00 24.05           C
ATOM    903  O   SER   109       2.362  34.328  88.051  1.00 22.41           O
ATOM    904  N   THR   110       4.331  33.834  87.005  1.00 23.82           N
ATOM    905  CA  THR   110       4.900  33.138  88.158  1.00 24.02           C
ATOM    906  CB  THR   110       5.718  31.885  87.734  1.00 24.80           C
ATOM    907  OG1 THR   110       4.809  30.972  87.111  1.00 21.86           O
ATOM    908  CG2 THR   110       6.364  31.185  88.960  1.00 22.57           C
ATOM    909  C   THR   110       5.661  34.110  89.087  1.00 24.45           C
ATOM    910  O   THR   110       5.845  33.837  90.248  1.00 23.94           O
ATOM    911  N   LYS   111       6.066  35.266  88.559  1.00 24.80           N
ATOM    912  CA  LYS   111       6.752  36.269  89.351  1.00 24.75           C
ATOM    913  CB  LYS   111       7.350  37.371  88.435  1.00 24.57           C
ATOM    914  CG  LYS   111       7.970  38.551  89.191  1.00 26.03           C
ATOM    915  CD  LYS   111       8.796  39.506  88.308  1.00 25.47           C
ATOM    916  CE  LYS   111      10.151  38.911  87.993  1.00 27.08           C
ATOM    917  NZ  LYS   111      10.973  39.860  87.201  1.00 27.31           N
ATOM    918  C   LYS   111       5.720  36.811  90.357  1.00 24.52           C
ATOM    919  O   LYS   111       4.513  36.795  90.083  1.00 24.83           O
ATOM    920  N   TYR   112       6.184  37.252  91.525  1.00 24.03           N
ATOM    921  CA  TYR   112       5.295  37.800  92.532  1.00 23.93           C
ATOM    922  CB  TYR   112       6.074  38.171  93.792  1.00 24.91           C
ATOM    923  CG  TYR   112       6.854  36.992  94.369  1.00 27.15           C
ATOM    924  CD1 TYR   112       6.283  35.716  94.429  1.00 27.45           C
ATOM    925  CE1 TYR   112       7.013  34.611  94.923  1.00 31.08           C
ATOM    926  CZ  TYR   112       8.303  34.796  95.393  1.00 28.86           C
ATOM    927  OH  TYR   112       9.011  33.713  95.913  1.00 31.26           O
ATOM    928  CE2 TYR   112       8.893  36.058  95.356  1.00 28.90           C
ATOM    929  CD2 TYR   112       8.168  37.152  94.823  1.00 27.43           C
ATOM    930  C   TYR   112       4.610  39.032  91.989  1.00 23.41           C
ATOM    931  O   TYR   112       5.260  39.896  91.364  1.00 23.52           O
ATOM    932  N   ARG   113       3.305  39.103  92.232  1.00 21.97           N
ATOM    933  CA  ARG   113       2.489  40.236  91.833  1.00 21.75           C
ATOM    934  CB  ARG   113       1.031  40.019  92.239  1.00 21.73           C
ATOM    935  CG  ARG   113       0.186  41.140  91.722  1.00 23.08           C
ATOM    936  CD  ARG   113      -1.252  40.797  91.585  1.00 29.65           C
ATOM    937  NE  ARG   113      -1.761  40.257  92.820  1.00 30.40           N
ATOM    938  CZ  ARG   113      -2.146  41.000  93.831  1.00 33.13           C
ATOM    939  NH1 ARG   113      -2.106  42.325  93.727  1.00 34.65           N
ATOM    940  NH2 ARG   113      -2.572  40.409  94.936  1.00 35.49           N
ATOM    941  C   ARG   113       2.954  41.569  92.374  1.00 21.21           C
ATOM    942  O   ARG   113       2.925  42.564  91.658  1.00 21.65           O
ATOM    943  N   PHE   114       3.333  41.612  93.656  1.00 20.92           N
ATOM    944  CA  PHE   114       3.889  42.838  94.247  1.00 20.19           C
ATOM    945  CB  PHE   114       4.199  42.677  95.771  1.00 19.97           C
ATOM    946  CG  PHE   114       5.454  41.888  96.080  1.00 18.39           C
ATOM    947  CD1 PHE   114       6.715  42.526  96.088  1.00 19.63           C
ATOM    948  CE1 PHE   114       7.914  41.829  96.387  1.00 17.93           C
ATOM    949  CZ  PHE   114       7.839  40.450  96.701  1.00 20.29           C
ATOM    950  CE2 PHE   114       6.561  39.810  96.724  1.00 20.01           C
ATOM    951  CD2 PHE   114       5.385  40.531  96.404  1.00 18.78           C
ATOM    952  C   PHE   114       5.106  43.323  93.452  1.00 20.47           C
ATOM    953  O   PHE   114       5.327  44.516  93.314  1.00 20.52           O
ATOM    954  N   ARG   115       5.892  42.388  92.933  1.00 20.95           N
ATOM    955  CA  ARG   115       7.085  42.719  92.176  1.00 22.04           C
ATOM    956  CB  ARG   115       7.924  41.466  92.013  1.00 21.74           C
ATOM    957  CG  ARG   115       9.238  41.681  91.270  1.00 24.56           C
ATOM    958  CD  ARG   115      10.299  42.239  92.221  1.00 27.49           C
ATOM    959  NE  ARG   115      10.697  41.201  93.174  1.00 29.27           N
ATOM    960  CZ  ARG   115      11.068  41.414  94.437  1.00 29.39           C
ATOM    961  NH1 ARG   115      11.103  42.653  94.944  1.00 26.15           N
ATOM    962  NH2 ARG   115      11.415  40.371  95.193  1.00 26.91           N
ATOM    963  C   ARG   115       6.720  43.344  90.811  1.00 22.23           C
ATOM    964  O   ARG   115       7.290  44.373  90.398  1.00 21.97           O
ATOM    965  N   ILE   116       5.744  42.721  90.145  1.00 22.57           N
ATOM    966  CA  ILE   116       5.160  43.221  88.902  1.00 23.16           C
ATOM    967  CB  ILE   116       4.157  42.190  88.356  1.00 23.56           C
ATOM    968  CG1 ILE   116       4.920  40.914  87.940  1.00 21.53           C
ATOM    969  CD1 ILE   116       4.033  39.740  87.742  1.00 18.62           C
ATOM    970  CG2 ILE   116       3.257  42.759  87.229  1.00 24.81           C
ATOM    971  C   ILE   116       4.540  44.618  89.039  1.00 23.20           C
ATOM    972  O   ILE   116       4.736  45.471  88.178  1.00 23.95           O
ATOM    973  N   LEU   117       3.824  44.851  90.128  1.00 23.18           N
ATOM    974  CA  LEU   117       3.142  46.131  90.333  1.00 22.97           C
ATOM    975  CB  LEU   117       2.163  46.067  91.507  1.00 23.35           C
ATOM    976  CG  LEU   117       0.893  45.203  91.358  1.00 22.83           C
ATOM    977  CD1 LEU   117       0.263  45.068  92.731  1.00 23.77           C
ATOM    978  CD2 LEU   117      -0.134  45.791  90.389  1.00 25.25           C
ATOM    979  C   LEU   117       4.157  47.220  90.535  1.00 22.48           C
ATOM    980  O   LEU   117       4.011  48.312  90.031  1.00 22.68           O
ATOM    981  N   SER   118       5.225  46.896  91.239  1.00 22.82           N
ATOM    982  CA  SER   118       6.278  47.867  91.486  1.00 22.55           C
ATOM    983  CB  SER   118       7.256  47.318  92.508  1.00 22.73           C
ATOM    984  OG  SER   118       8.088  48.377  92.966  1.00 25.80           O
ATOM    985  C   SER   118       6.996  48.249  90.170  1.00 21.80           C
ATOM    986  O   SER   118       7.276  49.429  89.930  1.00 20.84           O
ATOM    987  N   PHE   119       7.255  47.248  89.322  1.00 20.76           N
ATOM    988  CA  PHE   119       7.778  47.477  87.980  1.00 20.24           C
ATOM    989  CB  PHE   119       8.059  46.173  87.223  1.00 18.77           C
ATOM    990  CG  PHE   119       8.569  46.403  85.826  1.00 19.44           C
ATOM    991  CD1 PHE   119       9.929  46.704  85.600  1.00 17.91           C
ATOM    992  CE1 PHE   119      10.385  46.994  84.313  1.00 18.19           C
ATOM    993  CZ  PHE   119       9.518  46.942  83.225  1.00 16.24           C
ATOM    994  CE2 PHE   119       8.161  46.658  83.439  1.00 18.27           C
ATOM    995  CD2 PHE   119       7.703  46.382  84.742  1.00 18.20           C
ATOM    996  C   PHE   119       6.840  48.380  87.183  1.00 20.65           C
ATOM    997  O   PHE   119       7.280  49.372  86.593  1.00 21.93           O
ATOM    998  N   LEU   120       5.556  48.053  87.202  1.00 20.45           N
ATOM    999  CA  LEU   120       4.536  48.767  86.441  1.00 20.84           C
ATOM   1000  CB  LEU   120       3.167  48.044  86.517  1.00 20.93           C
ATOM   1001  CG  LEU   120       3.052  46.558  86.041  1.00 19.24           C
ATOM   1002  CD1 LEU   120       1.658  45.978  86.237  1.00 18.53           C
ATOM   1003  CD2 LEU   120       3.431  46.440  84.584  1.00 20.96           C
ATOM   1004  C   LEU   120       4.380  50.189  86.866  1.00 21.73           C
ATOM   1005  O   LEU   120       4.173  51.072  86.033  1.00 21.80           O
ATOM   1006  N   ARG   121       4.476  50.431  88.166  1.00 22.60           N
ATOM   1007  CA  ARG   121       4.314  51.785  88.694  1.00 23.52           C
ATOM   1008  CB  ARG   121       4.536  51.804  90.209  1.00 23.94           C
ATOM   1009  CG  ARG   121       3.243  51.762  90.989  1.00 26.77           C
ATOM   1010  CD  ARG   121       3.460  52.148  92.462  1.00 32.77           C
ATOM   1011  NE  ARG   121       4.296  51.171  93.166  1.00 36.60           N
ATOM   1012  CZ  ARG   121       3.868  49.993  93.621  1.00 37.23           C
ATOM   1013  NH1 ARG   121       2.606  49.615  93.453  1.00 39.05           N
ATOM   1014  NH2 ARG   121       4.712  49.187  94.242  1.00 37.40           N
ATOM   1015  C   ARG   121       5.175  52.842  88.028  1.00 23.70           C
ATOM   1016  O   ARG   121       4.700  53.965  87.795  1.00 22.66           O
ATOM   1017  N   ASN   122       6.433  52.512  87.738  1.00 24.49           N
ATOM   1018  CA  ASN   122       7.322  53.455  87.040  1.00 25.95           C
ATOM   1019  CB  ASN   122       8.592  53.730  87.849  1.00 26.52           C
ATOM   1020  CG  ASN   122       9.381  52.471  88.149  1.00 27.72           C
ATOM   1021  OD1 ASN   122       8.830  51.376  88.204  1.00 27.80           O
ATOM   1022  ND2 ASN   122      10.678  52.627  88.355  1.00 28.40           N
ATOM   1023  C   ASN   122       7.650  53.134  85.563  1.00 26.81           C
ATOM   1024  O   ASN   122       8.660  53.617  85.024  1.00 25.03           O
ATOM   1025  N   HIS   123       6.782  52.336  84.928  1.00 28.90           N
ATOM   1026  CA  HIS   123       6.824  52.065  83.474  1.00 32.33           C
ATOM   1027  CB  HIS   123       7.437  50.688  83.175  1.00 32.18           C
ATOM   1028  CG  HIS   123       8.880  50.598  83.558  1.00 32.54           C
ATOM   1029  ND1 HIS   123       9.292  50.240  84.824  1.00 34.38           N
ATOM   1030  CE1 HIS   123      10.612  50.292  84.887  1.00 34.14           C
ATOM   1031  NE2 HIS   123      11.067  50.684  83.711  1.00 32.80           N
ATOM   1032  CD2 HIS   123      10.004  50.896  82.868  1.00 32.98           C
ATOM   1033  C   HIS   123       5.481  52.284  82.732  1.00 34.73           C
ATOM   1034  O   HIS   123       5.352  53.269  82.000  1.00 35.69           O
ATOM   1035  N   MET   124       4.488  51.397  82.910  1.00 37.36           N
ATOM   1036  CA  MET   124       3.182  51.538  82.200  1.00 40.60           C
ATOM   1037  CB  MET   124       2.354  50.232  82.186  1.00 40.22           C
ATOM   1038  CG  MET   124       3.145  49.006  82.256  1.00 42.29           C
ATOM   1039  SD  MET   124       3.035  47.774  80.747  1.00 48.28          SE
ATOM   1040  CE  MET   124       4.580  46.586  81.143  1.00 45.73           C
ATOM   1041  C   MET   124       2.350  52.657  82.824  1.00 40.03           C
ATOM   1042  O   MET   124       2.549  52.999  83.991  1.00 39.75           O
ATOM   1043  N   PRO   125       1.431  53.264  82.044  1.00 40.89           N
ATOM   1044  CA  PRO   125       0.446  54.102  82.734  1.00 40.98           C
ATOM   1045  CB  PRO   125      -0.462  54.605  81.603  1.00 41.37           C
ATOM   1046  CG  PRO   125       0.315  54.429  80.344  1.00 41.09           C
ATOM   1047  CD  PRO   125       1.246  53.269  80.576  1.00 40.96           C
ATOM   1048  C   PRO   125      -0.353  53.263  83.731  1.00 41.53           C
ATOM   1049  O   PRO   125      -0.658  52.088  83.461  1.00 41.29           O
ATOM   1050  N   ASP   126      -0.656  53.841  84.889  1.00 41.77           N
ATOM   1051  CA  ASP   126      -1.488  53.161  85.878  1.00 42.26           C
ATOM   1052  CB  ASP   126      -1.283  53.797  87.266  1.00 42.73           C
ATOM   1053  CG  ASP   126      -1.286  52.769  88.412  1.00 44.34           C
ATOM   1054  OD1 ASP   126      -1.670  51.593  88.183  1.00 45.63           O
ATOM   1055  OD2 ASP   126      -0.897  53.153  89.552  1.00 45.51           O
ATOM   1056  C   ASP   126      -2.927  53.356  85.389  1.00 41.58           C
ATOM   1057  O   ASP   126      -3.206  54.386  84.784  1.00 42.21           O
ATOM   1058  N   ASP   127      -3.827  52.389  85.556  1.00 40.52           N
ATOM   1059  CA  ASP   127      -3.526  50.998  85.880  1.00 39.96           C
ATOM   1060  CB  ASP   127      -4.189  50.550  87.197  1.00 40.94           C
ATOM   1061  CG  ASP   127      -5.660  50.984  87.315  1.00 41.90           C
ATOM   1062  OD1 ASP   127      -5.953  52.208  87.369  1.00 42.06           O
ATOM   1063  OD2 ASP   127      -6.518  50.079  87.382  1.00 43.64           O
ATOM   1064  C   ASP   127      -4.042  50.185  84.717  1.00 38.20           C
ATOM   1065  O   ASP   127      -5.256  50.109  84.494  1.00 37.67           O
ATOM   1066  N   TRP   128      -3.113  49.592  83.975  1.00 36.61           N
ATOM   1067  CA  TRP   128      -3.429  49.055  82.644  1.00 35.09           C
ATOM   1068  CB  TRP   128      -2.227  48.948  81.688  1.00 35.80           C
ATOM   1069  CG  TRP   128      -2.234  50.138  80.750  1.00 35.09           C
ATOM   1070  CD1 TRP   128      -3.104  51.208  80.783  1.00 35.72           C
ATOM   1071  NE1 TRP   128      -2.822  52.085  79.763  1.00 35.55           N
ATOM   1072  CE2 TRP   128      -1.742  51.607  79.063  1.00 35.42           C
ATOM   1073  CD2 TRP   128      -1.348  50.383  79.658  1.00 34.71           C
ATOM   1074  CE3 TRP   128      -0.265  49.688  79.118  1.00 33.51           C
ATOM   1075  CZ3 TRP   128       0.399  50.231  78.022  1.00 34.61           C
ATOM   1076  CH2 TRP   128      -0.003  51.446  77.455  1.00 35.73           C
ATOM   1077  CZ2 TRP   128      -1.074  52.152  77.957  1.00 36.45           C
ATOM   1078  C   TRP   128      -4.588  48.100  82.448  1.00 33.02           C
ATOM   1079  O   TRP   128      -5.180  48.096  81.379  1.00 32.97           O
ATOM   1080  N   PHE   129      -4.895  47.198  83.368  1.00 30.83           N
ATOM   1081  CA  PHE   129      -4.519  45.796  83.438  1.00 27.41           C
ATOM   1082  CB  PHE   129      -3.210  45.414  84.131  1.00 27.51           C
ATOM   1083  CG  PHE   129      -2.070  45.221  83.163  1.00 24.74           C
ATOM   1084  CD1 PHE   129      -2.191  44.352  82.086  1.00 22.45           C
ATOM   1085  CE1 PHE   129      -1.154  44.219  81.171  1.00 22.50           C
ATOM   1086  CZ  PHE   129       0.024  44.986  81.326  1.00 23.94           C
ATOM   1087  CE2 PHE   129       0.131  45.854  82.373  1.00 22.97           C
ATOM   1088  CD2 PHE   129      -0.908  45.982  83.279  1.00 22.98           C
ATOM   1089  C   PHE   129      -5.747  45.423  84.247  1.00 26.85           C
ATOM   1090  O   PHE   129      -5.857  45.755  85.438  1.00 26.52           O
ATOM   1091  N   ASP   130      -6.726  44.837  83.571  1.00 24.96           N
ATOM   1092  CA  ASP   130      -7.957  44.475  84.234  1.00 24.19           C
ATOM   1093  CB  ASP   130      -9.012  44.086  83.220  1.00 23.88           C
ATOM   1094  CG  ASP   130      -9.437  45.274  82.371  1.00 27.00           C
ATOM   1095  OD1 ASP   130     -10.486  45.869  82.696  1.00 29.29           O
ATOM   1096  OD2 ASP   130      -8.706  45.627  81.403  1.00 28.94           O
ATOM   1097  C   ASP   130      -7.741  43.441  85.330  1.00 22.92           C
ATOM   1098  O   ASP   130      -8.495  43.397  86.287  1.00 21.95           O
ATOM   1099  N   ILE   131      -6.677  42.649  85.206  1.00 22.22           N
ATOM   1100  CA  ILE   131      -6.307  41.674  86.234  1.00 21.82           C
ATOM   1101  CB  ILE   131      -7.161  40.373  86.146  1.00 21.76           C
ATOM   1102  CG1 ILE   131      -6.930  39.485  87.370  1.00 22.46           C
ATOM   1103  CD1 ILE   131      -8.071  38.538  87.621  1.00 24.67           C
ATOM   1104  CG2 ILE   131      -6.894  39.594  84.846  1.00 19.84           C
ATOM   1105  C   ILE   131      -4.825  41.292  86.164  1.00 21.81           C
ATOM   1106  O   ILE   131      -4.235  41.209  85.074  1.00 22.19           O
ATOM   1107  N   ILE   132      -4.244  41.065  87.334  1.00 20.67           N
ATOM   1108  CA  ILE   132      -2.877  40.621  87.448  1.00 21.67           C
ATOM   1109  CB  ILE   132      -1.857  41.769  87.836  1.00 21.11           C
ATOM   1110  CG1 ILE   132      -1.840  42.854  86.755  1.00 22.05           C
ATOM   1111  CD1 ILE   132      -1.142  44.103  87.131  1.00 20.96           C
ATOM   1112  CG2 ILE   132      -0.429  41.186  87.997  1.00 20.87           C
ATOM   1113  C   ILE   132      -2.934  39.561  88.520  1.00 21.42           C
ATOM   1114  O   ILE   132      -3.402  39.825  89.625  1.00 21.70           O
ATOM   1115  N   ILE   133      -2.490  38.372  88.137  1.00 21.45           N
ATOM   1116  CA  ILE   133      -2.309  37.194  88.992  1.00 21.23           C
ATOM   1117  CB  ILE   133      -3.092  35.998  88.411  1.00 20.64           C
ATOM   1118  CG1 ILE   133      -4.604  36.370  88.251  1.00 20.13           C
ATOM   1119  CD1 ILE   133      -5.347  36.639  89.520  1.00 22.28           C
ATOM   1120  CG2 ILE   133      -2.926  34.728  89.265  1.00 20.74           C
ATOM   1121  C   ILE   133      -0.808  36.909  88.984  1.00 21.77           C
ATOM   1122  O   ILE   133      -0.211  36.748  87.891  1.00 22.24           O
ATOM   1123  N   GLY   134      -0.192  36.907  90.173  1.00 21.68           N
ATOM   1124  CA  GLY   134       1.255  36.614  90.338  1.00 20.93           C
ATOM   1125  C   GLY   134       1.469  35.278  91.048  1.00 21.26           C
ATOM   1126  O   GLY   134       0.500  34.563  91.361  1.00 19.97           O
ATOM   1127  N   GLY   135       2.737  34.925  91.268  1.00 21.56           N
ATOM   1128  CA  GLY   135       3.112  33.682  91.980  1.00 22.36           C
ATOM   1129  C   GLY   135       2.520  33.486  93.377  1.00 23.17           C
ATOM   1130  O   GLY   135       2.158  32.354  93.770  1.00 23.27           O
ATOM   1131  N   GLU   136       2.383  34.563  94.140  1.00 22.75           N
ATOM   1132  CA  GLU   136       1.816  34.428  95.487  1.00 23.36           C
ATOM   1133  CB  GLU   136       2.345  35.554  96.403  1.00 23.73           C
ATOM   1134  CG  GLU   136       1.681  36.950  96.250  1.00 22.57           C
ATOM   1135  CD  GLU   136       2.182  37.801  95.055  1.00 25.96           C
ATOM   1136  OE1 GLU   136       2.283  37.277  93.905  1.00 23.49           O
ATOM   1137  OE2 GLU   136       2.415  39.034  95.256  1.00 24.73           O
ATOM   1138  C   GLU   136       0.247  34.280  95.490  1.00 23.83           C
ATOM   1139  O   GLU   136      -0.369  33.896  96.497  1.00 23.40           O
ATOM   1140  N   ASP   137      -0.387  34.529  94.351  1.00 24.09           N
ATOM   1141  CA  ASP   137      -1.859  34.442  94.272  1.00 25.55           C
ATOM   1142  CB  ASP   137      -2.367  35.311  93.131  1.00 25.10           C
ATOM   1143  CG  ASP   137      -2.097  36.779  93.352  1.00 25.54           C
ATOM   1144  OD1 ASP   137      -2.202  37.277  94.485  1.00 28.50           O
ATOM   1145  OD2 ASP   137      -1.772  37.440  92.373  1.00 26.95           O
ATOM   1146  C   ASP   137      -2.416  33.017  94.111  1.00 25.84           C
ATOM   1147  O   ASP   137      -3.638  32.812  94.093  1.00 26.18           O
ATOM   1148  N   VAL   138      -1.521  32.044  93.978  1.00 26.55           N
ATOM   1149  CA  VAL   138      -1.889  30.650  93.613  1.00 26.36           C
ATOM   1150  CB  VAL   138      -1.768  30.341  92.054  1.00 26.04           C
ATOM   1151  CG1 VAL   138      -2.696  31.284  91.225  1.00 26.27           C
ATOM   1152  CG2 VAL   138      -0.311  30.428  91.540  1.00 25.06           C
ATOM   1153  C   VAL   138      -1.035  29.671  94.398  1.00 26.57           C
ATOM   1154  O   VAL   138       0.097  29.981  94.766  1.00 25.71           O
ATOM   1155  N   THR   139      -1.596  28.497  94.651  1.00 27.30           N
ATOM   1156  CA  THR   139      -0.888  27.445  95.356  1.00 28.33           C
ATOM   1157  CB  THR   139      -1.882  26.536  96.095  1.00 28.71           C
ATOM   1158  OG1 THR   139      -2.459  27.267  97.177  1.00 26.46           O
ATOM   1159  CG2 THR   139      -1.208  25.266  96.628  1.00 30.40           C
ATOM   1160  C   THR   139      -0.005  26.648  94.386  1.00 29.17           C
ATOM   1161  O   THR   139       1.149  26.353  94.701  1.00 29.07           O
ATOM   1162  N   HIS   140      -0.571  26.318  93.219  1.00 29.49           N
ATOM   1163  CA  HIS   140       0.113  25.569  92.172  1.00 29.83           C
ATOM   1164  CB  HIS   140      -0.736  24.403  91.704  1.00 30.06           C
ATOM   1165  CG  HIS   140      -0.980  23.395  92.770  1.00 32.33           C
ATOM   1166  ND1 HIS   140      -2.093  23.429  93.583  1.00 35.12           N
ATOM   1167  CE1 HIS   140      -2.036  22.425  94.439  1.00 36.33           C
ATOM   1168  NE2 HIS   140      -0.925  21.748  94.213  1.00 37.23           N
ATOM   1169  CD2 HIS   140      -0.244  22.340  93.177  1.00 34.03           C
ATOM   1170  C   HIS   140       0.384  26.459  90.995  1.00 29.35           C
ATOM   1171  O   HIS   140      -0.478  27.252  90.580  1.00 28.72           O
ATOM   1172  N   HIS   141       1.574  26.307  90.439  1.00 27.98           N
ATOM   1173  CA  HIS   141       2.080  27.301  89.512  1.00 28.07           C
ATOM   1174  CB  HIS   141       3.463  27.750  90.003  1.00 28.04           C
ATOM   1175  CG  HIS   141       3.393  28.496  91.311  1.00 27.71           C
ATOM   1176  ND1 HIS   141       3.534  27.875  92.534  1.00 25.16           N
ATOM   1177  CE1 HIS   141       3.373  28.759  93.499  1.00 24.61           C
ATOM   1178  NE2 HIS   141       3.107  29.934  92.947  1.00 27.11           N
ATOM   1179  CD2 HIS   141       3.111  29.796  91.580  1.00 27.35           C
ATOM   1180  C   HIS   141       2.111  26.777  88.079  1.00 27.50           C
ATOM   1181  O   HIS   141       2.090  25.571  87.879  1.00 26.78           O
ATOM   1182  N   LYS   142       2.171  27.681  87.093  1.00 27.81           N
ATOM   1183  CA  LYS   142       2.224  27.291  85.662  1.00 28.04           C
ATOM   1184  CB  LYS   142       2.551  28.498  84.772  1.00 27.57           C
ATOM   1185  CG  LYS   142       1.552  29.656  84.827  1.00 28.67           C
ATOM   1186  CD  LYS   142       1.857  30.722  83.749  1.00 28.89           C
ATOM   1187  CE  LYS   142       2.936  31.661  84.217  1.00 28.95           C
ATOM   1188  NZ  LYS   142       3.314  32.608  83.107  1.00 28.98           N
ATOM   1189  C   LYS   142       3.255  26.198  85.486  1.00 27.87           C
ATOM   1190  O   LYS   142       4.327  26.282  86.090  1.00 29.23           O
ATOM   1191  N   PRO   143       2.977  25.166  84.663  1.00 28.29           N
ATOM   1192  CA  PRO   143       1.850  24.958  83.744  1.00 28.58           C
ATOM   1193  CB  PRO   143       2.368  23.876  82.765  1.00 28.89           C
ATOM   1194  CG  PRO   143       3.359  23.086  83.546  1.00 28.98           C
ATOM   1195  CD  PRO   143       3.934  24.034  84.621  1.00 28.62           C
ATOM   1196  C   PRO   143       0.482  24.611  84.362  1.00 28.32           C
ATOM   1197  O   PRO   143      -0.478  24.469  83.636  1.00 27.84           O
ATOM   1198  N   ASP   144       0.368  24.539  85.688  1.00 28.21           N
ATOM   1199  CA  ASP   144      -0.954  24.362  86.294  1.00 28.18           C
ATOM   1200  CB  ASP   144      -0.841  24.248  87.817  1.00 27.62           C
ATOM   1201  CG  ASP   144      -2.147  23.834  88.462  1.00 28.37           C
ATOM   1202  OD1 ASP   144      -2.221  22.711  88.967  1.00 26.19           O
ATOM   1203  OD2 ASP   144      -3.102  24.628  88.476  1.00 27.88           O
ATOM   1204  C   ASP   144      -1.830  25.560  85.908  1.00 27.55           C
ATOM   1205  O   ASP   144      -1.396  26.722  86.028  1.00 27.66           O
ATOM   1206  N   PRO   145      -3.062  25.287  85.416  1.00 28.58           N
ATOM   1207  CA  PRO   145      -3.950  26.371  84.963  1.00 27.87           C
ATOM   1208  CB  PRO   145      -4.988  25.617  84.115  1.00 28.13           C
ATOM   1209  CG  PRO   145      -5.068  24.268  84.760  1.00 28.65           C
ATOM   1210  CD  PRO   145      -3.678  23.948  85.218  1.00 27.05           C
ATOM   1211  C   PRO   145      -4.632  27.194  86.078  1.00 28.17           C
ATOM   1212  O   PRO   145      -5.499  28.029  85.778  1.00 28.46           O
ATOM   1213  N   GLU   146      -4.260  26.975  87.338  1.00 28.42           N
ATOM   1214  CA  GLU   146      -4.968  27.605  88.491  1.00 28.55           C
ATOM   1215  CB  GLU   146      -4.235  27.313  89.807  1.00 28.72           C
ATOM   1216  CG  GLU   146      -5.006  27.727  91.073  1.00 29.01           C
ATOM   1217  CD  GLU   146      -4.199  27.550  92.349  1.00 28.29           C
ATOM   1218  OE1 GLU   146      -3.457  26.547  92.459  1.00 29.73           O
ATOM   1219  OE2 GLU   146      -4.301  28.412  93.245  1.00 27.05           O
ATOM   1220  C   GLU   146      -5.100  29.119  88.339  1.00 28.92           C
ATOM   1221  O   GLU   146      -6.187  29.681  88.500  1.00 28.72           O
ATOM   1222  N   GLY   147      -3.982  29.778  88.050  1.00 29.01           N
ATOM   1223  CA  GLY   147      -3.970  31.229  87.917  1.00 29.73           C
ATOM   1224  C   GLY   147      -4.714  31.721  86.699  1.00 30.25           C
ATOM   1225  O   GLY   147      -5.460  32.706  86.778  1.00 30.55           O
ATOM   1226  N   LEU   148      -4.516  31.031  85.574  1.00 30.39           N
ATOM   1227  CA  LEU   148      -5.191  31.387  84.335  1.00 30.29           C
ATOM   1228  CB  LEU   148      -4.668  30.557  83.142  1.00 29.91           C
ATOM   1229  CG  LEU   148      -5.162  30.971  81.723  1.00 31.16           C
ATOM   1230  CD1 LEU   148      -5.102  32.485  81.462  1.00 30.38           C
ATOM   1231  CD2 LEU   148      -4.345  30.284  80.653  1.00 31.39           C
ATOM   1232  C   LEU   148      -6.712  31.250  84.509  1.00 29.93           C
ATOM   1233  O   LEU   148      -7.459  32.187  84.189  1.00 29.74           O
ATOM   1234  N   LEU   149      -7.156  30.093  85.017  1.00 29.50           N
ATOM   1235  CA  LEU   149      -8.573  29.865  85.290  1.00 29.44           C
ATOM   1236  CB  LEU   149      -8.819  28.417  85.759  1.00 29.53           C
ATOM   1237  CG  LEU   149      -8.523  27.271  84.787  1.00 26.91           C
ATOM   1238  CD1 LEU   149      -8.739  25.945  85.501  1.00 25.33           C
ATOM   1239  CD2 LEU   149      -9.358  27.402  83.497  1.00 24.96           C
ATOM   1240  C   LEU   149      -9.113  30.853  86.320  1.00 30.01           C
ATOM   1241  O   LEU   149     -10.254  31.298  86.206  1.00 30.21           O
ATOM   1242  N   LEU   150      -8.294  31.198  87.315  1.00 30.89           N
ATOM   1243  CA  LEU   150      -8.667  32.200  88.308  1.00 31.50           C
ATOM   1244  CB  LEU   150      -7.596  32.361  89.407  1.00 31.23           C
ATOM   1245  CG  LEU   150      -7.868  33.398  90.522  1.00 31.44           C
ATOM   1246  CD1 LEU   150      -9.066  33.029  91.413  1.00 30.04           C
ATOM   1247  CD2 LEU   150      -6.637  33.653  91.380  1.00 31.62           C
ATOM   1248  C   LEU   150      -8.980  33.552  87.647  1.00 32.69           C
ATOM   1249  O   LEU   150     -10.038  34.150  87.928  1.00 33.35           O
ATOM   1250  N   ALA   151      -8.077  34.021  86.780  1.00 32.59           N
ATOM   1251  CA  ALA   151      -8.261  35.279  86.067  1.00 33.62           C
ATOM   1252  CB  ALA   151      -7.054  35.584  85.235  1.00 33.37           C
ATOM   1253  C   ALA   151      -9.529  35.337  85.205  1.00 34.37           C
ATOM   1254  O   ALA   151     -10.314  36.307  85.307  1.00 34.50           O
ATOM   1255  N   ILE   152      -9.718  34.305  84.366  1.00 35.25           N
ATOM   1256  CA  ILE   152     -10.926  34.126  83.543  1.00 35.62           C
ATOM   1257  CB  ILE   152     -10.934  32.763  82.776  1.00 35.62           C
ATOM   1258  CG1 ILE   152      -9.708  32.606  81.876  1.00 34.67           C
ATOM   1259  CD1 ILE   152      -9.417  31.151  81.476  1.00 34.42           C
ATOM   1260  CG2 ILE   152     -12.206  32.625  81.915  1.00 36.65           C
ATOM   1261  C   ILE   152     -12.189  34.206  84.411  1.00 36.96           C
ATOM   1262  O   ILE   152     -13.165  34.867  84.043  1.00 36.65           O
ATOM   1263  N   ASP   153     -12.150  33.527  85.557  1.00 38.06           N
ATOM   1264  CA  ASP   153     -13.238  33.564  86.541  1.00 38.91           C
ATOM   1265  CB  ASP   153     -12.964  32.594  87.693  1.00 38.78           C
ATOM   1266  CG  ASP   153     -14.020  32.677  88.765  1.00 41.18           C
ATOM   1267  OD1 ASP   153     -15.192  32.354  88.469  1.00 38.13           O
ATOM   1268  OD2 ASP   153     -13.685  33.102  89.896  1.00 46.00           O
ATOM   1269  C   ASP   153     -13.527  34.964  87.090  1.00 39.10           C
ATOM   1270  O   ASP   153     -14.683  35.418  87.096  1.00 39.05           O
ATOM   1271  N   ARG   154     -12.478  35.640  87.550  1.00 39.66           N
ATOM   1272  CA  ARG   154     -12.604  36.995  88.098  1.00 40.18           C
ATOM   1273  CB  ARG   154     -11.289  37.457  88.738  1.00 40.91           C
ATOM   1274  CG  ARG   154     -10.921  36.683  89.989  1.00 42.64           C
ATOM   1275  CD  ARG   154     -10.260  37.574  91.020  1.00 45.63           C
ATOM   1276  NE  ARG   154      -9.328  36.801  91.833  1.00 47.12           N
ATOM   1277  CZ  ARG   154      -8.246  37.312  92.406  1.00 48.26           C
ATOM   1278  NH1 ARG   154      -7.970  38.611  92.256  1.00 47.61           N
ATOM   1279  NH2 ARG   154      -7.434  36.525  93.112  1.00 47.30           N
ATOM   1280  C   ARG   154     -13.095  38.035  87.083  1.00 39.58           C
ATOM   1281  O   ARG   154     -13.827  38.975  87.447  1.00 40.22           O
ATOM   1282  N   LEU   155     -12.690  37.865  85.826  1.00 38.30           N
ATOM   1283  CA  LEU   155     -13.117  38.749  84.739  1.00 37.14           C
ATOM   1284  CB  LEU   155     -12.063  38.749  83.609  1.00 36.73           C
ATOM   1285  CG  LEU   155     -10.662  39.400  83.769  1.00 34.97           C
ATOM   1286  CD1 LEU   155      -9.880  39.218  82.484  1.00 36.15           C
ATOM   1287  CD2 LEU   155     -10.715  40.861  84.079  1.00 34.72           C
ATOM   1288  C   LEU   155     -14.549  38.454  84.183  1.00 37.07           C
ATOM   1289  O   LEU   155     -15.064  39.218  83.354  1.00 36.32           O
ATOM   1290  N   LYS   156     -15.181  37.376  84.671  1.00 36.92           N
ATOM   1291  CA  LYS   156     -16.451  36.848  84.132  1.00 37.01           C
ATOM   1292  CB  LYS   156     -17.680  37.720  84.475  1.00 37.18           C
ATOM   1293  CG  LYS   156     -17.712  38.389  85.856  1.00 38.58           C
ATOM   1294  CD  LYS   156     -17.848  37.411  87.018  1.00 39.61           C
ATOM   1295  CE  LYS   156     -17.923  38.158  88.346  1.00 39.57           C
ATOM   1296  NZ  LYS   156     -19.301  38.673  88.683  1.00 40.82           N
ATOM   1297  C   LYS   156     -16.327  36.676  82.618  1.00 37.01           C
ATOM   1298  O   LYS   156     -17.227  37.042  81.846  1.00 36.54           O
ATOM   1299  N   ALA   157     -15.191  36.124  82.202  1.00 36.76           N
ATOM   1300  CA  ALA   157     -14.923  35.911  80.797  1.00 37.12           C
ATOM   1301  CB  ALA   157     -13.416  36.198  80.460  1.00 36.14           C
ATOM   1302  C   ALA   157     -15.338  34.509  80.356  1.00 37.35           C
ATOM   1303  O   ALA   157     -15.522  33.600  81.181  1.00 38.21           O
ATOM   1304  N   CYS   158     -15.552  34.391  79.050  1.00 37.47           N
ATOM   1305  CA  CYS   158     -15.746  33.106  78.417  0.50 37.00           C
ATOM   1307  CB  CYS   158     -16.872  33.168  77.395  0.50 37.04           C
ATOM   1309  SG  CYS   158     -18.511  32.998  78.148  0.50 36.19           S
ATOM   1311  C   CYS   158     -14.429  32.667  77.787  1.00 37.08           C
ATOM   1312  O   CYS   158     -13.785  33.425  77.050  1.00 37.37           O
ATOM   1313  N   PRO   159     -13.986  31.421  78.103  1.00 36.60           N
ATOM   1314  CA  PRO   159     -12.637  31.046  77.632  1.00 35.62           C
ATOM   1315  CB  PRO   159     -12.479  29.599  78.104  1.00 35.48           C
ATOM   1316  CG  PRO   159     -13.877  29.111  78.347  1.00 36.57           C
ATOM   1317  CD  PRO   159     -14.643  30.306  78.813  1.00 36.59           C
ATOM   1318  C   PRO   159     -12.480  31.161  76.108  1.00 35.34           C
ATOM   1319  O   PRO   159     -11.385  31.435  75.621  1.00 34.76           O
ATOM   1320  N   GLU   160     -13.581  31.008  75.371  1.00 34.46           N
ATOM   1321  CA  GLU   160     -13.572  31.187  73.918  1.00 34.88           C
ATOM   1322  CB  GLU   160     -14.945  30.864  73.301  1.00 35.84           C
ATOM   1323  CG  GLU   160     -15.293  29.376  73.320  1.00 39.68           C
ATOM   1324  CD  GLU   160     -15.699  28.846  74.709  1.00 43.90           C
ATOM   1325  OE1 GLU   160     -16.231  29.628  75.539  1.00 42.25           O
ATOM   1326  OE2 GLU   160     -15.485  27.629  74.959  1.00 47.49           O
ATOM   1327  C   GLU   160     -13.089  32.572  73.473  1.00 33.86           C
ATOM   1328  O   GLU   160     -12.526  32.703  72.382  1.00 34.28           O
ATOM   1329  N   GLU   161     -13.253  33.581  74.319  1.00 32.56           N
ATOM   1330  CA  GLU   161     -12.852  34.943  73.950  1.00 32.97           C
ATOM   1331  CB  GLU   161     -13.931  35.966  74.329  1.00 33.11           C
ATOM   1332  CG  GLU   161     -14.101  36.232  75.807  1.00 34.27           C
ATOM   1333  CD  GLU   161     -15.469  36.815  76.099  1.00 36.91           C
ATOM   1334  OE1 GLU   161     -16.134  37.214  75.109  1.00 37.88           O
ATOM   1335  OE2 GLU   161     -15.880  36.864  77.293  1.00 35.47           O
ATOM   1336  C   GLU   161     -11.490  35.365  74.503  1.00 32.61           C
ATOM   1337  O   GLU   161     -11.116  36.542  74.411  1.00 32.64           O
ATOM   1338  N   VAL   162     -10.762  34.387  75.044  1.00 31.89           N
ATOM   1339  CA  VAL   162      -9.492  34.613  75.742  1.00 31.91           C
ATOM   1340  CB  VAL   162      -9.493  33.968  77.159  1.00 32.49           C
ATOM   1341  CG1 VAL   162      -8.100  34.070  77.824  1.00 30.64           C
ATOM   1342  CG2 VAL   162     -10.614  34.582  78.046  1.00 30.78           C
ATOM   1343  C   VAL   162      -8.309  34.091  74.928  1.00 31.63           C
ATOM   1344  O   VAL   162      -8.291  32.936  74.492  1.00 30.72           O
ATOM   1345  N   LEU   163      -7.344  34.977  74.708  1.00 31.17           N
ATOM   1346  CA  LEU   163      -6.061  34.599  74.139  1.00 30.89           C
ATOM   1347  CB  LEU   163      -5.693  35.510  72.979  1.00 30.52           C
ATOM   1348  CG  LEU   163      -4.485  35.088  72.144  1.00 30.76           C
ATOM   1349  CD1 LEU   163      -4.643  33.648  71.634  1.00 29.87           C
ATOM   1350  CD2 LEU   163      -4.230  36.063  70.980  1.00 30.98           C
ATOM   1351  C   LEU   163      -4.992  34.696  75.218  1.00 30.75           C
ATOM   1352  O   LEU   163      -4.896  35.708  75.892  1.00 30.06           O
ATOM   1353  N   TYR   164      -4.220  33.626  75.400  1.00 30.91           N
ATOM   1354  CA  TYR   164      -3.047  33.689  76.276  1.00 31.55           C
ATOM   1355  CB  TYR   164      -2.973  32.470  77.203  1.00 31.30           C
ATOM   1356  CG  TYR   164      -1.902  32.618  78.276  1.00 33.40           C
ATOM   1357  CD1 TYR   164      -1.848  33.781  79.067  1.00 31.47           C
ATOM   1358  CE1 TYR   164      -0.887  33.944  80.053  1.00 31.32           C
ATOM   1359  CZ  TYR   164       0.062  32.967  80.262  1.00 33.71           C
ATOM   1360  OH  TYR   164       0.992  33.188  81.240  1.00 32.32           O
ATOM   1361  CE2 TYR   164       0.062  31.782  79.482  1.00 33.92           C
ATOM   1362  CD2 TYR   164      -0.937  31.621  78.489  1.00 31.66           C
ATOM   1363  C   TYR   164      -1.755  33.813  75.451  1.00 31.34           C
ATOM   1364  O   TYR   164      -1.534  33.038  74.515  1.00 32.53           O
ATOM   1365  N   ILE   165      -0.889  34.758  75.810  1.00 30.69           N
ATOM   1366  CA  ILE   165       0.335  35.049  75.040  1.00 29.49           C
ATOM   1367  CB  ILE   165       0.318  36.514  74.448  1.00 29.51           C
ATOM   1368  CG1 ILE   165      -0.932  36.778  73.604  1.00 30.79           C
ATOM   1369  CD1 ILE   165      -2.039  37.483  74.342  1.00 27.44           C
ATOM   1370  CG2 ILE   165       1.575  36.794  73.636  1.00 31.57           C
ATOM   1371  C   ILE   165       1.578  34.886  75.917  1.00 29.05           C
ATOM   1372  O   ILE   165       1.688  35.541  76.944  1.00 28.44           O
ATOM   1373  N   GLY   166       2.518  34.023  75.520  1.00 28.54           N
ATOM   1374  CA  GLY   166       3.679  33.738  76.376  1.00 27.39           C
ATOM   1375  C   GLY   166       4.878  33.445  75.510  1.00 28.08           C
ATOM   1376  O   GLY   166       4.733  33.328  74.274  1.00 26.75           O
ATOM   1377  N   ASP   167       6.054  33.333  76.146  1.00 27.57           N
ATOM   1378  CA  ASP   167       7.293  33.064  75.426  1.00 27.78           C
ATOM   1379  CB  ASP   167       8.381  34.005  75.922  1.00 27.52           C
ATOM   1380  CG  ASP   167       8.800  33.669  77.324  1.00 28.93           C
ATOM   1381  OD1 ASP   167       7.990  33.939  78.215  1.00 30.91           O
ATOM   1382  OD2 ASP   167       9.906  33.108  77.533  1.00 31.75           O
ATOM   1383  C   ASP   167       7.845  31.632  75.580  1.00 27.57           C
ATOM   1384  O   ASP   167       8.887  31.301  74.972  1.00 27.83           O
ATOM   1385  N   SER   168       7.202  30.825  76.429  1.00 27.47           N
ATOM   1386  CA  SER   168       7.723  29.516  76.835  1.00 26.64           C
ATOM   1387  CB  SER   168       8.025  29.498  78.332  1.00 26.94           C
ATOM   1388  OG  SER   168       6.799  29.549  79.034  1.00 29.70           O
ATOM   1389  C   SER   168       6.726  28.410  76.620  1.00 26.30           C
ATOM   1390  O   SER   168       5.504  28.656  76.474  1.00 26.45           O
ATOM   1391  N   THR   169       7.244  27.180  76.644  1.00 26.12           N
ATOM   1392  CA  THR   169       6.397  25.999  76.621  1.00 26.28           C
ATOM   1393  CB  THR   169       7.173  24.733  76.318  1.00 26.36           C
ATOM   1394  OG1 THR   169       8.277  24.663  77.212  1.00 26.70           O
ATOM   1395  CG2 THR   169       7.683  24.770  74.879  1.00 27.73           C
ATOM   1396  C   THR   169       5.599  25.815  77.893  1.00 25.69           C
ATOM   1397  O   THR   169       4.515  25.237  77.832  1.00 24.92           O
ATOM   1398  N   VAL   170       6.111  26.329  79.025  1.00 26.07           N
ATOM   1399  CA  VAL   170       5.317  26.449  80.275  1.00 25.83           C
ATOM   1400  CB  VAL   170       6.131  27.138  81.409  1.00 25.84           C
ATOM   1401  CG1 VAL   170       5.222  27.558  82.582  1.00 26.91           C
ATOM   1402  CG2 VAL   170       7.246  26.221  81.886  1.00 26.04           C
ATOM   1403  C   VAL   170       4.024  27.208  80.008  1.00 25.47           C
ATOM   1404  O   VAL   170       2.911  26.778  80.406  1.00 25.40           O
ATOM   1405  N   ASP   171       4.162  28.332  79.312  1.00 26.32           N
ATOM   1406  CA  ASP   171       2.985  29.153  78.990  1.00 26.34           C
ATOM   1407  CB  ASP   171       3.435  30.463  78.358  1.00 27.70           C
ATOM   1408  CG  ASP   171       4.084  31.399  79.350  1.00 27.98           C
ATOM   1409  OD1 ASP   171       3.752  31.363  80.551  1.00 28.13           O
ATOM   1410  OD2 ASP   171       4.947  32.188  78.932  1.00 32.79           O
ATOM   1411  C   ASP   171       2.065  28.413  78.038  1.00 26.85           C
ATOM   1412  O   ASP   171       0.828  28.439  78.209  1.00 26.61           O
ATOM   1413  N   ALA   172       2.649  27.764  77.024  1.00 25.61           N
ATOM   1414  CA  ALA   172       1.865  27.000  76.055  1.00 27.11           C
ATOM   1415  CB  ALA   172       2.741  26.409  74.899  1.00 26.48           C
ATOM   1416  C   ALA   172       1.104  25.888  76.751  1.00 27.31           C
ATOM   1417  O   ALA   172      -0.092  25.728  76.502  1.00 26.13           O
ATOM   1418  N   GLY   173       1.804  25.125  77.599  1.00 27.21           N
ATOM   1419  CA  GLY   173       1.167  24.118  78.457  1.00 28.14           C
ATOM   1420  C   GLY   173       0.059  24.691  79.333  1.00 28.11           C
ATOM   1421  O   GLY   173      -0.985  24.062  79.505  1.00 28.46           O
ATOM   1422  N   THR   174       0.263  25.898  79.858  1.00 29.04           N
ATOM   1423  CA  THR   174      -0.746  26.532  80.739  1.00 28.63           C
ATOM   1424  CB  THR   174      -0.239  27.845  81.422  1.00 29.14           C
ATOM   1425  OG1 THR   174       1.062  27.635  82.011  1.00 28.42           O
ATOM   1426  CG2 THR   174      -1.201  28.270  82.494  1.00 28.38           C
ATOM   1427  C   THR   174      -2.017  26.816  79.962  1.00 28.93           C
ATOM   1428  O   THR   174      -3.104  26.500  80.426  1.00 28.93           O
ATOM   1429  N   ALA   175      -1.891  27.400  78.777  1.00 29.27           N
ATOM   1430  CA  ALA   175      -3.101  27.700  77.976  1.00 30.09           C
ATOM   1431  CB  ALA   175      -2.757  28.491  76.732  1.00 29.49           C
ATOM   1432  C   ALA   175      -3.856  26.427  77.621  1.00 30.13           C
ATOM   1433  O   ALA   175      -5.083  26.372  77.793  1.00 31.05           O
ATOM   1434  N   ALA   176      -3.130  25.392  77.172  1.00 29.92           N
ATOM   1435  CA  ALA   176      -3.758  24.090  76.823  1.00 30.22           C
ATOM   1436  CB  ALA   176      -2.712  23.076  76.314  1.00 29.67           C
ATOM   1437  C   ALA   176      -4.493  23.521  78.016  1.00 30.43           C
ATOM   1438  O   ALA   176      -5.688  23.205  77.949  1.00 31.30           O
ATOM   1439  N   ALA   177      -3.789  23.413  79.136  1.00 30.95           N
ATOM   1440  CA  ALA   177      -4.426  22.959  80.380  1.00 30.86           C
ATOM   1441  CB  ALA   177      -3.414  22.929  81.542  1.00 29.64           C
ATOM   1442  C   ALA   177      -5.706  23.754  80.734  1.00 30.96           C
ATOM   1443  O   ALA   177      -6.680  23.173  81.213  1.00 30.26           O
ATOM   1444  N   ALA   178      -5.704  25.069  80.481  1.00 31.93           N
ATOM   1445  CA  ALA   178      -6.880  25.919  80.731  1.00 32.07           C
ATOM   1446  CB  ALA   178      -6.452  27.382  80.979  1.00 32.87           C
ATOM   1447  C   ALA   178      -7.969  25.844  79.648  1.00 32.72           C
ATOM   1448  O   ALA   178      -9.077  26.302  79.867  1.00 32.75           O
ATOM   1449  N   GLY   179      -7.658  25.254  78.492  1.00 33.13           N
ATOM   1450  CA  GLY   179      -8.605  25.194  77.382  1.00 32.75           C
ATOM   1451  C   GLY   179      -8.815  26.571  76.764  1.00 32.66           C
ATOM   1452  O   GLY   179      -9.944  26.923  76.399  1.00 32.34           O
ATOM   1453  N   VAL   180      -7.730  27.353  76.664  1.00 31.61           N
ATOM   1454  CA  VAL   180      -7.770  28.641  75.970  1.00 30.94           C
ATOM   1455  CB  VAL   180      -7.629  29.867  76.972  1.00 31.08           C
ATOM   1456  CG1 VAL   180      -8.695  29.789  78.112  1.00 29.39           C
ATOM   1457  CG2 VAL   180      -6.241  29.942  77.538  1.00 29.49           C
ATOM   1458  C   VAL   180      -6.735  28.739  74.816  1.00 31.18           C
ATOM   1459  O   VAL   180      -5.669  28.123  74.866  1.00 30.89           O
ATOM   1460  N   SER   181      -7.039  29.545  73.803  1.00 30.60           N
ATOM   1461  CA  SER   181      -6.119  29.762  72.685  1.00 30.70           C
ATOM   1462  CB  SER   181      -6.775  30.642  71.613  1.00 30.53           C
ATOM   1463  OG  SER   181      -7.894  29.988  70.999  1.00 29.90           O
ATOM   1464  C   SER   181      -4.772  30.355  73.106  1.00 30.60           C
ATOM   1465  O   SER   181      -4.698  31.208  74.007  1.00 30.11           O
ATOM   1466  N   PHE   182      -3.709  29.900  72.440  1.00 30.07           N
ATOM   1467  CA  PHE   182      -2.341  30.369  72.734  1.00 29.70           C
ATOM   1468  CB  PHE   182      -1.478  29.205  73.229  1.00 28.93           C
ATOM   1469  CG  PHE   182      -0.081  29.612  73.644  1.00 30.73           C
ATOM   1470  CD1 PHE   182       0.124  30.449  74.761  1.00 29.47           C
ATOM   1471  CE1 PHE   182       1.406  30.827  75.151  1.00 31.11           C
ATOM   1472  CZ  PHE   182       2.526  30.332  74.445  1.00 28.39           C
ATOM   1473  CE2 PHE   182       2.328  29.475  73.331  1.00 28.33           C
ATOM   1474  CD2 PHE   182       1.034  29.106  72.962  1.00 28.37           C
ATOM   1475  C   PHE   182      -1.633  31.041  71.564  1.00 29.02           C
ATOM   1476  O   PHE   182      -1.695  30.573  70.424  1.00 28.62           O
ATOM   1477  N   THR   183      -0.943  32.151  71.841  1.00 30.11           N
ATOM   1478  CA  THR   183      -0.018  32.699  70.860  1.00 28.82           C
ATOM   1479  CB  THR   183      -0.516  34.033  70.270  1.00 30.12           C
ATOM   1480  OG1 THR   183      -1.611  33.747  69.388  1.00 30.28           O
ATOM   1481  CG2 THR   183       0.621  34.771  69.486  1.00 27.41           C
ATOM   1482  C   THR   183       1.368  32.763  71.471  1.00 28.92           C
ATOM   1483  O   THR   183       1.591  33.421  72.491  1.00 27.48           O
ATOM   1484  N   GLY   184       2.284  32.020  70.873  1.00 28.36           N
ATOM   1485  CA  GLY   184       3.663  32.001  71.341  1.00 28.69           C
ATOM   1486  C   GLY   184       4.432  33.175  70.739  1.00 29.40           C
ATOM   1487  O   GLY   184       4.204  33.561  69.581  1.00 29.16           O
ATOM   1488  N   VAL   185       5.289  33.775  71.553  1.00 29.52           N
ATOM   1489  CA  VAL   185       6.227  34.823  71.108  0.50 29.57           C
ATOM   1491  CB  VAL   185       5.977  36.191  71.805  0.50 29.47           C
ATOM   1493  CG1 VAL   185       6.778  37.296  71.119  0.50 30.12           C
ATOM   1495  CG2 VAL   185       4.518  36.544  71.808  0.50 29.56           C
ATOM   1497  C   VAL   185       7.653  34.390  71.427  1.00 29.06           C
ATOM   1498  O   VAL   185       7.987  34.165  72.587  1.00 29.80           O
ATOM   1499  N   THR   186       8.501  34.296  70.412  1.00 29.30           N
ATOM   1500  CA  THR   186       9.882  33.835  70.612  1.00 28.58           C
ATOM   1501  CB  THR   186      10.460  33.142  69.334  1.00 28.68           C
ATOM   1502  OG1 THR   186      10.512  34.084  68.261  1.00 29.27           O
ATOM   1503  CG2 THR   186       9.609  31.926  68.898  1.00 27.42           C
ATOM   1504  C   THR   186      10.818  34.915  71.149  1.00 28.67           C
ATOM   1505  O   THR   186      11.954  35.027  70.700  1.00 28.42           O
ATOM   1506  N   SER   187      10.357  35.678  72.149  1.00 28.95           N
ATOM   1507  CA  SER   187      11.169  36.731  72.796  1.00 29.25           C
ATOM   1508  CB  SER   187      10.308  37.935  73.169  1.00 29.27           C
ATOM   1509  OG  SER   187       9.157  37.486  73.857  1.00 31.18           O
ATOM   1510  C   SER   187      11.890  36.215  74.052  1.00 29.26           C
ATOM   1511  O   SER   187      12.588  36.976  74.717  1.00 28.99           O
ATOM   1512  N   GLY   188      11.722  34.929  74.357  1.00 29.16           N
ATOM   1513  CA  GLY   188      12.452  34.291  75.446  1.00 29.38           C
ATOM   1514  C   GLY   188      13.575  33.397  74.951  1.00 29.82           C
ATOM   1515  O   GLY   188      14.352  33.786  74.080  1.00 30.49           O
ATOM   1516  N   MET   189      13.652  32.185  75.503  1.00 30.04           N
ATOM   1517  CA  MET   189      14.651  31.196  75.092  1.00 30.01           C
ATOM   1518  CB  MET   189      15.408  30.630  76.296  1.00 30.07           C
ATOM   1519  CG  MET   189      16.126  31.615  77.109  1.00 31.09           C
ATOM   1520  SD  MET   189      17.657  32.307  76.282  0.70 34.38          SE
ATOM   1521  CE  MET   189      18.750  30.708  76.149  1.00 34.13           C
ATOM   1522  C   MET   189      14.031  30.019  74.345  1.00 29.96           C
ATOM   1523  O   MET   189      14.740  29.062  74.018  1.00 29.46           O
ATOM   1524  N   THR   190      12.727  30.090  74.101  1.00 29.08           N
ATOM   1525  CA  THR   190      11.991  29.049  73.389  1.00 30.03           C
ATOM   1526  CB  THR   190      10.582  28.862  73.995  1.00 30.20           C
ATOM   1527  OG1 THR   190      10.719  28.608  75.384  1.00 34.60           O
ATOM   1528  CG2 THR   190       9.802  27.720  73.330  1.00 30.40           C
ATOM   1529  C   THR   190      11.851  29.425  71.916  1.00 29.62           C
ATOM   1530  O   THR   190      11.431  30.545  71.578  1.00 29.07           O
ATOM   1531  N   THR   191      12.216  28.473  71.061  1.00 29.44           N
ATOM   1532  CA  THR   191      12.183  28.624  69.607  1.00 29.39           C
ATOM   1533  CB  THR   191      13.310  27.793  68.957  1.00 30.38           C
ATOM   1534  OG1 THR   191      12.979  26.401  69.037  1.00 30.50           O
ATOM   1535  CG2 THR   191      14.646  28.058  69.660  1.00 28.76           C
ATOM   1536  C   THR   191      10.853  28.152  69.045  1.00 29.76           C
ATOM   1537  O   THR   191      10.117  27.432  69.739  1.00 29.53           O
ATOM   1538  N   ALA   192      10.544  28.548  67.793  1.00 29.58           N
ATOM   1539  CA  ALA   192       9.320  28.119  67.118  1.00 29.13           C
ATOM   1540  CB  ALA   192       9.172  28.791  65.722  1.00 29.19           C
ATOM   1541  C   ALA   192       9.223  26.577  67.008  1.00 29.09           C
ATOM   1542  O   ALA   192       8.128  26.005  67.122  1.00 28.85           O
ATOM   1543  N   GLN   193      10.355  25.922  66.777  1.00 28.17           N
ATOM   1544  CA  GLN   193      10.406  24.464  66.753  1.00 28.79           C
ATOM   1545  CB  GLN   193      11.809  23.956  66.399  1.00 28.22           C
ATOM   1546  CG  GLN   193      11.884  22.420  66.195  1.00 29.86           C
ATOM   1547  CD  GLN   193      12.031  21.593  67.516  1.00 33.91           C
ATOM   1548  OE1 GLN   193      12.375  22.130  68.580  1.00 36.29           O
ATOM   1549  NE2 GLN   193      11.770  20.281  67.433  1.00 31.80           N
ATOM   1550  C   GLN   193       9.957  23.869  68.077  1.00 28.83           C
ATOM   1551  O   GLN   193       9.182  22.911  68.082  1.00 29.61           O
ATOM   1552  N   GLU   194      10.404  24.455  69.195  1.00 27.92           N
ATOM   1553  CA  GLU   194      10.016  23.973  70.520  1.00 27.72           C
ATOM   1554  CB  GLU   194      10.903  24.578  71.604  1.00 28.41           C
ATOM   1555  CG  GLU   194      12.358  24.124  71.434  1.00 29.11           C
ATOM   1556  CD  GLU   194      13.352  24.946  72.264  1.00 33.55           C
ATOM   1557  OE1 GLU   194      13.063  26.101  72.631  1.00 31.87           O
ATOM   1558  OE2 GLU   194      14.468  24.438  72.505  1.00 36.61           O
ATOM   1559  C   GLU   194       8.539  24.118  70.849  1.00 28.13           C
ATOM   1560  O   GLU   194       7.996  23.286  71.576  1.00 28.95           O
ATOM   1561  N   PHE   195       7.876  25.134  70.291  1.00 27.78           N
ATOM   1562  CA  PHE   195       6.448  25.356  70.560  1.00 27.60           C
ATOM   1563  CB  PHE   195       5.999  26.722  70.031  1.00 27.04           C
ATOM   1564  CG  PHE   195       6.227  27.873  70.988  1.00 28.57           C
ATOM   1565  CD1 PHE   195       5.556  27.932  72.213  1.00 28.10           C
ATOM   1566  CE1 PHE   195       5.738  29.019  73.065  1.00 28.60           C
ATOM   1567  CZ  PHE   195       6.623  30.059  72.707  1.00 28.17           C
ATOM   1568  CE2 PHE   195       7.285  30.014  71.505  1.00 29.42           C
ATOM   1569  CD2 PHE   195       7.073  28.920  70.636  1.00 29.20           C
ATOM   1570  C   PHE   195       5.595  24.322  69.886  1.00 27.81           C
ATOM   1571  O   PHE   195       4.388  24.246  70.172  1.00 28.62           O
ATOM   1572  N   GLN   196       6.193  23.565  68.953  1.00 28.00           N
ATOM   1573  CA  GLN   196       5.415  22.654  68.060  1.00 28.03           C
ATOM   1574  CB  GLN   196       6.234  22.121  66.858  1.00 28.17           C
ATOM   1575  CG  GLN   196       6.634  23.160  65.824  1.00 29.26           C
ATOM   1576  CD  GLN   196       5.496  24.111  65.490  1.00 32.07           C
ATOM   1577  OE1 GLN   196       4.407  23.676  65.136  1.00 31.14           O
ATOM   1578  NE2 GLN   196       5.751  25.418  65.584  1.00 32.53           N
ATOM   1579  C   GLN   196       4.828  21.505  68.847  1.00 27.41           C
ATOM   1580  O   GLN   196       3.836  20.909  68.443  1.00 26.80           O
ATOM   1581  N   ALA   197       5.441  21.233  70.000  1.00 27.36           N
ATOM   1582  CA  ALA   197       4.963  20.211  70.916  1.00 27.34           C
ATOM   1583  CB  ALA   197       5.976  19.969  71.995  1.00 27.40           C
ATOM   1584  C   ALA   197       3.599  20.549  71.529  1.00 26.75           C
ATOM   1585  O   ALA   197       2.985  19.700  72.159  1.00 27.17           O
ATOM   1586  N   TYR   198       3.132  21.784  71.348  1.00 27.66           N
ATOM   1587  CA  TYR   198       1.888  22.273  71.987  1.00 27.71           C
ATOM   1588  CB  TYR   198       2.222  23.218  73.155  1.00 28.98           C
ATOM   1589  CG  TYR   198       3.075  22.606  74.241  1.00 31.68           C
ATOM   1590  CD1 TYR   198       2.493  22.084  75.418  1.00 31.00           C
ATOM   1591  CE1 TYR   198       3.317  21.526  76.432  1.00 33.40           C
ATOM   1592  CZ  TYR   198       4.701  21.471  76.220  1.00 31.87           C
ATOM   1593  OH  TYR   198       5.542  20.945  77.177  1.00 33.47           O
ATOM   1594  CE2 TYR   198       5.276  21.957  75.053  1.00 31.80           C
ATOM   1595  CD2 TYR   198       4.478  22.534  74.089  1.00 30.17           C
ATOM   1596  C   TYR   198       1.028  23.062  71.006  1.00 27.44           C
ATOM   1597  O   TYR   198       1.554  23.596  70.012  1.00 25.39           O
ATOM   1598  N   PRO   199      -0.291  23.188  71.307  1.00 26.95           N
ATOM   1599  CA  PRO   199      -1.191  23.937  70.432  1.00 27.37           C
ATOM   1600  CB  PRO   199      -2.607  23.578  70.968  1.00 27.67           C
ATOM   1601  CG  PRO   199      -2.415  22.459  71.974  1.00 26.62           C
ATOM   1602  CD  PRO   199      -0.996  22.613  72.470  1.00 27.05           C
ATOM   1603  C   PRO   199      -0.940  25.455  70.438  1.00 27.64           C
ATOM   1604  O   PRO   199      -0.574  26.036  71.464  1.00 28.07           O
ATOM   1605  N   TYR   200      -1.122  26.094  69.291  1.00 28.51           N
ATOM   1606  CA  TYR   200      -0.984  27.553  69.181  1.00 28.39           C
ATOM   1607  CB  TYR   200       0.483  27.956  68.937  1.00 28.12           C
ATOM   1608  CG  TYR   200       1.092  27.286  67.713  1.00 29.23           C
ATOM   1609  CD1 TYR   200       1.055  27.904  66.452  1.00 30.22           C
ATOM   1610  CE1 TYR   200       1.600  27.269  65.316  1.00 27.75           C
ATOM   1611  CZ  TYR   200       2.163  26.012  65.453  1.00 28.10           C
ATOM   1612  OH  TYR   200       2.700  25.386  64.349  1.00 28.06           O
ATOM   1613  CE2 TYR   200       2.194  25.374  66.692  1.00 26.81           C
ATOM   1614  CD2 TYR   200       1.675  26.006  67.805  1.00 29.53           C
ATOM   1615  C   TYR   200      -1.854  28.017  68.011  1.00 29.50           C
ATOM   1616  O   TYR   200      -2.206  27.214  67.120  1.00 28.52           O
ATOM   1617  N   ASP   201      -2.167  29.306  68.021  1.00 29.42           N
ATOM   1618  CA  ASP   201      -2.749  29.989  66.892  1.00 30.78           C
ATOM   1619  CB  ASP   201      -3.443  31.268  67.386  1.00 31.84           C
ATOM   1620  CG  ASP   201      -4.895  31.063  67.642  1.00 34.16           C
ATOM   1621  OD1 ASP   201      -5.302  29.885  67.776  1.00 35.12           O
ATOM   1622  OD2 ASP   201      -5.629  32.079  67.695  1.00 37.28           O
ATOM   1623  C   ASP   201      -1.698  30.412  65.906  1.00 30.46           C
ATOM   1624  O   ASP   201      -1.764  30.067  64.733  1.00 30.55           O
ATOM   1625  N   ARG   202      -0.770  31.219  66.409  1.00 30.69           N
ATOM   1626  CA  ARG   202       0.383  31.726  65.703  1.00 30.71           C
ATOM   1627  CB  ARG   202       0.173  33.219  65.357  1.00 30.87           C
ATOM   1628  CG  ARG   202      -0.615  33.475  64.109  1.00 32.31           C
ATOM   1629  CD  ARG   202      -0.559  34.954  63.773  1.00 35.48           C
ATOM   1630  NE  ARG   202      -1.190  35.768  64.806  1.00 37.62           N
ATOM   1631  CZ  ARG   202      -1.028  37.082  64.932  1.00 39.80           C
ATOM   1632  NH1 ARG   202      -0.239  37.745  64.091  1.00 42.12           N
ATOM   1633  NH2 ARG   202      -1.656  37.733  65.893  1.00 38.13           N
ATOM   1634  C   ARG   202       1.593  31.653  66.626  1.00 30.68           C
ATOM   1635  O   ARG   202       1.461  31.511  67.855  1.00 31.05           O
ATOM   1636  N   ILE   203       2.775  31.719  66.016  1.00 29.99           N
ATOM   1637  CA  ILE   203       4.021  31.914  66.733  0.50 29.91           C
ATOM   1639  CB  ILE   203       4.980  30.689  66.644  0.50 29.40           C
ATOM   1641  CG1 ILE   203       4.316  29.388  67.127  0.50 28.07           C
ATOM   1643  CD1 ILE   203       4.012  29.281  68.634  0.50 24.34           C
ATOM   1645  CG2 ILE   203       6.279  30.975  67.415  0.50 30.13           C
ATOM   1647  C   ILE   203       4.680  33.123  66.078  1.00 30.29           C
ATOM   1648  O   ILE   203       5.018  33.072  64.882  1.00 31.17           O
ATOM   1649  N   ILE   204       4.859  34.190  66.853  1.00 30.12           N
ATOM   1650  CA  ILE   204       5.346  35.470  66.342  1.00 30.67           C
ATOM   1651  CB  ILE   204       4.348  36.614  66.701  1.00 30.30           C
ATOM   1652  CG1 ILE   204       3.968  36.571  68.184  1.00 30.24           C
ATOM   1653  CD1 ILE   204       3.245  37.841  68.688  1.00 31.03           C
ATOM   1654  CG2 ILE   204       3.063  36.491  65.837  1.00 30.53           C
ATOM   1655  C   ILE   204       6.740  35.752  66.864  1.00 30.85           C
ATOM   1656  O   ILE   204       7.143  35.145  67.855  1.00 32.34           O
ATOM   1657  N   SER   205       7.479  36.657  66.223  1.00 30.89           N
ATOM   1658  CA  SER   205       8.802  37.060  66.731  1.00 31.63           C
ATOM   1659  CB  SER   205       9.761  37.523  65.616  1.00 31.53           C
ATOM   1660  OG  SER   205       9.422  36.957  64.387  1.00 34.62           O
ATOM   1661  C   SER   205       8.726  38.184  67.727  1.00 31.36           C
ATOM   1662  O   SER   205       9.549  38.262  68.636  1.00 31.48           O
ATOM   1663  N   THR   206       7.780  39.094  67.528  1.00 31.39           N
ATOM   1664  CA  THR   206       7.694  40.256  68.397  1.00 31.78           C
ATOM   1665  CB  THR   206       8.300  41.547  67.768  1.00 31.65           C
ATOM   1666  OG1 THR   206       7.678  41.831  66.496  1.00 29.92           O
ATOM   1667  CG2 THR   206       9.799  41.393  67.560  1.00 31.94           C
ATOM   1668  C   THR   206       6.249  40.468  68.768  1.00 32.33           C
ATOM   1669  O   THR   206       5.361  40.078  68.033  1.00 32.08           O
ATOM   1670  N   LEU   207       6.031  41.076  69.926  1.00 32.23           N
ATOM   1671  CA  LEU   207       4.695  41.333  70.432  1.00 32.50           C
ATOM   1672  CB  LEU   207       4.810  42.054  71.769  1.00 32.65           C
ATOM   1673  CG  LEU   207       3.731  41.888  72.812  1.00 32.55           C
ATOM   1674  CD1 LEU   207       3.511  40.409  73.119  1.00 31.90           C
ATOM   1675  CD2 LEU   207       4.156  42.696  74.074  1.00 32.43           C
ATOM   1676  C   LEU   207       3.883  42.193  69.491  1.00 32.69           C
ATOM   1677  O   LEU   207       2.659  42.042  69.420  1.00 31.97           O
ATOM   1678  N   GLY   208       4.566  43.099  68.785  1.00 33.30           N
ATOM   1679  CA  GLY   208       3.915  44.042  67.854  1.00 34.10           C
ATOM   1680  C   GLY   208       3.157  43.356  66.723  1.00 34.93           C
ATOM   1681  O   GLY   208       2.197  43.917  66.148  1.00 34.41           O
ATOM   1682  N   GLN   209       3.585  42.132  66.426  1.00 35.26           N
ATOM   1683  CA  GLN   209       2.970  41.301  65.428  1.00 37.01           C
ATOM   1684  CB  GLN   209       3.897  40.153  65.086  1.00 37.01           C
ATOM   1685  CG  GLN   209       4.944  40.551  64.079  1.00 39.42           C
ATOM   1686  CD  GLN   209       6.007  39.515  63.924  1.00 43.33           C
ATOM   1687  OE1 GLN   209       5.726  38.322  63.928  1.00 47.40           O
ATOM   1688  NE2 GLN   209       7.246  39.958  63.786  1.00 44.87           N
ATOM   1689  C   GLN   209       1.622  40.782  65.877  1.00 37.66           C
ATOM   1690  O   GLN   209       0.838  40.275  65.078  1.00 37.76           O
ATOM   1691  N   LEU   210       1.340  40.922  67.159  1.00 38.30           N
ATOM   1692  CA  LEU   210       0.026  40.564  67.689  1.00 39.49           C
ATOM   1693  CB  LEU   210       0.023  40.739  69.216  1.00 39.62           C
ATOM   1694  CG  LEU   210      -0.703  39.828  70.214  1.00 39.33           C
ATOM   1695  CD1 LEU   210      -0.693  38.331  69.883  1.00 36.10           C
ATOM   1696  CD2 LEU   210      -0.077  40.083  71.560  1.00 37.45           C
ATOM   1697  C   LEU   210      -1.054  41.400  67.016  1.00 40.60           C
ATOM   1698  O   LEU   210      -2.172  40.925  66.781  1.00 41.32           O
ATOM   1699  N   ILE   211      -0.697  42.640  66.685  1.00 41.56           N
ATOM   1700  CA  ILE   211      -1.547  43.572  65.950  1.00 41.96           C
ATOM   1701  CB  ILE   211      -1.172  45.062  66.259  1.00 42.21           C
ATOM   1702  CG1 ILE   211      -1.168  45.366  67.774  1.00 42.34           C
ATOM   1703  CD1 ILE   211      -2.480  45.107  68.511  1.00 41.30           C
ATOM   1704  CG2 ILE   211      -2.040  46.032  65.448  1.00 43.37           C
ATOM   1705  C   ILE   211      -1.374  43.340  64.456  1.00 41.85           C
ATOM   1706  O   ILE   211      -2.312  42.930  63.776  1.00 42.35           O
END
