
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  233 ( 1873),  selected  233 , name 2om6_A
# Molecule2: number of CA atoms  210 ( 1658),  selected  210 , name T0418.pdb
# PARAMETERS: 2om6_A.T0418.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      -       -           -
LGA    R     2_A      -       -           -
LGA    E     3_A      K       2          3.166
LGA    V     4_A      Y       3          1.661
LGA    K     5_A      T       4          1.540
LGA    L     6_A      V       5          0.750
LGA    V     7_A      Y       6          0.702
LGA    T     8_A      L       7          0.324
LGA    F     9_A      F       8          0.530
LGA    D    10_A      D       9          0.197
LGA    V    11_A      F      10          0.246
LGA    W    12_A      D      11          0.437
LGA    N    13_A      Y      12          0.626
LGA    T    14_A      T      13          0.220
LGA    L    15_A      L      14          0.819
LGA    L    16_A      A      15          1.295
LGA    D    17_A      D      16          1.298
LGA    L    18_A      S      17          3.316
LGA    N    19_A      S      18          1.867
LGA    I    20_A      R      19          1.252
LGA    X    21_A      G      20          1.780
LGA    L    22_A      I      21          1.386
LGA    D    23_A      V      22          2.410
LGA    E    24_A      T      23          3.010
LGA    F    25_A      C      24          1.927
LGA    S    26_A      F      25          3.914
LGA    H    27_A      R      26          5.678
LGA    Q    28_A      S      27          5.386
LGA    L    29_A      -       -           -
LGA    A    30_A      V      28          5.843
LGA    K    31_A      L      29           -
LGA    I    32_A      E      30           -
LGA    S    33_A      R      31          4.887
LGA    G    34_A      H      32           -
LGA    L    35_A      G      33           #
LGA    H    36_A      -       -           -
LGA    I    37_A      Y      34           #
LGA    K    38_A      T      35          4.416
LGA    D    39_A      G      36           #
LGA    V    40_A      I      37           #
LGA    A    41_A      -       -           -
LGA    N    42_A      T      38           #
LGA    A    43_A      D      39           -
LGA    V    44_A      D      40           -
LGA    -       -      M      41           -
LGA    I    45_A      I      42           #
LGA    E    46_A      K      43           -
LGA    -       -      R      44           -
LGA    -       -      T      45           -
LGA    -       -      I      46           -
LGA    -       -      G      47           -
LGA    -       -      K      48           -
LGA    -       -      T      49           -
LGA    -       -      L      50           -
LGA    -       -      E      51           -
LGA    -       -      E      52           -
LGA    V    47_A      S      53          2.929
LGA    R    48_A      F      54          4.640
LGA    N    49_A      S      55          5.956
LGA    E    50_A      -       -           -
LGA    I    51_A      I      56           #
LGA    K    52_A      L      57           -
LGA    K    53_A      T      58           -
LGA    X    54_A      G      59           -
LGA    R    55_A      I      60           -
LGA    A    56_A      T      61           -
LGA    Q    57_A      D      62           -
LGA    A    58_A      A      63           -
LGA    S    59_A      D      64           -
LGA    E    60_A      Q      65           -
LGA    D    61_A      -       -           -
LGA    P    62_A      -       -           -
LGA    R    63_A      -       -           -
LGA    K    64_A      -       -           -
LGA    V    65_A      -       -           -
LGA    L    66_A      -       -           -
LGA    T    67_A      L      66           #
LGA    G    68_A      E      67          3.037
LGA    S    69_A      -       -           -
LGA    Q    70_A      -       -           -
LGA    E    71_A      S      68          1.743
LGA    A    72_A      -       -           -
LGA    L    73_A      -       -           -
LGA    A    74_A      F      69          3.217
LGA    G    75_A      R      70           -
LGA    K    76_A      -       -           -
LGA    L    77_A      -       -           -
LGA    K    78_A      -       -           -
LGA    V    79_A      -       -           -
LGA    D    80_A      -       -           -
LGA    V    81_A      Q      71          4.681
LGA    E    82_A      -       -           -
LGA    L    83_A      E      72          4.483
LGA    V    84_A      Y      73          3.530
LGA    K    85_A      S      74          3.607
LGA    R    86_A      K      75          2.641
LGA    A    87_A      E      76          1.134
LGA    T    88_A      A      77          1.442
LGA    A    89_A      D      78          1.230
LGA    R    90_A      I      79          1.178
LGA    A    91_A      Y      80          0.787
LGA    I    92_A      M      81          3.184
LGA    L    93_A      N      82           #
LGA    N    94_A      A      83          3.979
LGA    V    95_A      N      84          2.480
LGA    D    96_A      T      85          5.395
LGA    E    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    L    99_A      I      86          1.493
LGA    V   100_A      L      87          1.217
LGA    L   101_A      F      88          1.668
LGA    E   102_A      P      89          1.979
LGA    G   103_A      D      90          0.701
LGA    T   104_A      T      91          1.019
LGA    K   105_A      L      92          1.028
LGA    E   106_A      P      93          1.233
LGA    A   107_A      T      94          1.436
LGA    L   108_A      L      95          1.083
LGA    Q   109_A      T      96          1.049
LGA    F   110_A      H      97          1.397
LGA    V   111_A      L      98          1.086
LGA    K   112_A      K      99          0.830
LGA    E   113_A      K     100          1.060
LGA    R   114_A      Q     101          0.967
LGA    G   115_A      G     102          0.547
LGA    L   116_A      I     103          0.793
LGA    K   117_A      R     104          0.669
LGA    T   118_A      I     105          0.826
LGA    A   119_A      G     106          0.733
LGA    V   120_A      I     107          0.362
LGA    I   121_A      I     108          0.177
LGA    G   122_A      S     109          0.577
LGA    N   123_A      T     110          1.200
LGA    V   124_A      K     111          3.313
LGA    X   125_A      -       -           -
LGA    F   126_A      -       -           -
LGA    W   127_A      -       -           -
LGA    P   128_A      Y     112          3.339
LGA    G   129_A      R     113          2.916
LGA    S   130_A      F     114          1.168
LGA    Y   131_A      R     115          1.408
LGA    T   132_A      I     116          2.431
LGA    R   133_A      L     117          2.175
LGA    L   134_A      S     118          0.926
LGA    L   135_A      F     119          0.922
LGA    L   136_A      L     120          2.338
LGA    E   137_A      R     121          2.328
LGA    R   138_A      N     122          1.961
LGA    F   139_A      H     123          1.450
LGA    G   140_A      M     124          1.747
LGA    L   141_A      P     125           #
LGA    X   142_A      D     126           #
LGA    E   143_A      D     127          3.618
LGA    F   144_A      W     128          2.447
LGA    I   145_A      F     129          1.487
LGA    D   146_A      D     130          1.733
LGA    K   147_A      I     131          1.285
LGA    T   148_A      I     132          0.493
LGA    F   149_A      I     133          0.691
LGA    F   150_A      G     134          1.189
LGA    A   151_A      G     135          2.567
LGA    D   152_A      E     136          1.112
LGA    E   153_A      D     137          1.971
LGA    V   154_A      V     138          3.485
LGA    L   155_A      T     139          3.183
LGA    S   156_A      H     140          3.738
LGA    Y   157_A      H     141          2.239
LGA    K   158_A      K     142          1.979
LGA    P   159_A      P     143          2.113
LGA    R   160_A      D     144          1.853
LGA    K   161_A      P     145          3.001
LGA    E   162_A      E     146          3.070
LGA    X   163_A      G     147          2.429
LGA    F   164_A      L     148          1.910
LGA    E   165_A      L     149          1.595
LGA    K   166_A      L     150          1.115
LGA    V   167_A      A     151          1.152
LGA    L   168_A      I     152          1.141
LGA    N   169_A      D     153          1.066
LGA    S   170_A      R     154          0.890
LGA    F   171_A      L     155          0.954
LGA    E   172_A      K     156          0.754
LGA    V   173_A      A     157          1.380
LGA    K   174_A      C     158          1.061
LGA    P   175_A      P     159          0.768
LGA    E   176_A      E     160          0.491
LGA    E   177_A      E     161          0.620
LGA    S   178_A      V     162          0.478
LGA    L   179_A      L     163          0.391
LGA    H   180_A      Y     164          0.487
LGA    I   181_A      I     165          0.266
LGA    G   182_A      G     166          0.568
LGA    D   183_A      D     167          0.993
LGA    T   184_A      S     168          1.409
LGA    Y   185_A      T     169          1.487
LGA    A   186_A      V     170          3.299
LGA    E   187_A      -       -           -
LGA    D   188_A      D     171          1.332
LGA    Y   189_A      A     172          1.422
LGA    Q   190_A      G     173          2.577
LGA    G   191_A      T     174          2.053
LGA    A   192_A      A     175          1.002
LGA    R   193_A      A     176          2.832
LGA    K   194_A      A     177          3.717
LGA    V   195_A      A     178          2.588
LGA    G   196_A      G     179          2.668
LGA    X   197_A      V     180          1.671
LGA    W   198_A      S     181          1.579
LGA    A   199_A      F     182          0.761
LGA    V   200_A      T     183          0.634
LGA    W   201_A      G     184          1.267
LGA    I   202_A      V     185          1.452
LGA    N   203_A      T     186          2.230
LGA    Q   204_A      S     187           #
LGA    -       -      G     188           -
LGA    -       -      M     189           -
LGA    -       -      T     190           -
LGA    E   205_A      T     191          4.093
LGA    G   206_A      A     192          4.707
LGA    D   207_A      Q     193           -
LGA    K   208_A      E     194           -
LGA    V   209_A      F     195           -
LGA    R   210_A      Q     196           -
LGA    K   211_A      A     197           -
LGA    -       -      Y     198           -
LGA    L   212_A      P     199          6.070
LGA    E   213_A      -       -           -
LGA    E   214_A      -       -           -
LGA    R   215_A      Y     200           #
LGA    G   216_A      D     201          2.629
LGA    F   217_A      R     202          2.064
LGA    E   218_A      I     203          1.194
LGA    I   219_A      I     204          1.208
LGA    P   220_A      S     205          1.464
LGA    S   221_A      T     206          2.242
LGA    I   222_A      L     207          1.310
LGA    A   223_A      G     208          1.795
LGA    N   224_A      Q     209          1.207
LGA    L   225_A      L     210          1.310
LGA    K   226_A      I     211          1.458
LGA    D   227_A      -       -           -
LGA    V   228_A      -       -           -
LGA    I   229_A      -       -           -
LGA    E   230_A      -       -           -
LGA    L   231_A      -       -           -
LGA    I   232_A      -       -           -
LGA    S   233_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  233  210    5.0    162    2.31    17.28     60.302     6.713

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.966551 * X  +  -0.255298 * Y  +   0.024542 * Z  + -10.155604
  Y_new =  -0.235111 * X  +  -0.920208 * Y  +  -0.312955 * Z  +  92.395653
  Z_new =   0.102481 * X  +   0.296717 * Y  +  -0.949451 * Z  + 129.796753 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.838695   -0.302898  [ DEG:   162.6452    -17.3548 ]
  Theta =  -0.102661   -3.038931  [ DEG:    -5.8821   -174.1180 ]
  Phi   =  -0.238613    2.902980  [ DEG:   -13.6715    166.3285 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2om6_A                                        
REMARK     2: T0418.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2om6_A.T0418.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  233  210   5.0  162   2.31   17.28  60.302
REMARK  ---------------------------------------------------------- 
MOLECULE 2om6_A
HEADER    HYDROLASE                               21-JAN-07   2OM6              
TITLE     HYPOTHETICAL PROTEIN (PROBABLE PHOSPHOSERINE PHOSPH                   
TITLE    2 (PH0253) FROM PYROCOCCUS HORIKOSHII OT3                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROBABLE PHOSPHOSERINE PHOSPHATASE;                        
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: HYPOTHETICAL PROTEIN PH0253;                                
COMPND   5 EC: 3.1.3.3;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 STRAIN: OT3;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)-RIL-X;                           
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-11A                                   
KEYWDS    ROSSMANN FOLD, B-HAIRPIN, FOUR-HELIX BUNDLE, STRUCTURAL               
KEYWDS   2 GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL             
KEYWDS   3 AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                            
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI, HYDROLASE                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.JEYAKANTHAN,S.VAIJAYANTHIMALA,D.GAYATHRI,D.VELMURUGAN,              
AUTHOR   2 S.BABA,A.EBIHARA,A.SHINKAI,S.KURAMITSU,Y.SHIRO,S.YOKOYAMA,           
AUTHOR   3 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   29-JAN-08 2OM6    0                                                
JRNL        AUTH   J.JEYAKANTHAN,S.VAIJAYANTHIMALA,D.GAYATHRI,                  
JRNL        AUTH 2 D.VELMURUGAN,S.BABA,A.EBIHARA,A.SHINKAI,                     
JRNL        AUTH 3 S.KURAMITSU,Y.SHIRO,S.YOKOYAMA                               
JRNL        TITL   HYPOTHETICAL PROTEIN (PROBABLE PHOSPHOSERINE                 
JRNL        TITL 2 PHOSPH (PH0253) FROM PYROCOCCUS HORIKOSHII OT3               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2OM6 A    1   235  UNP    O57991   O57991_PYRHO     1    235             
DBREF  2OM6 B    1   235  UNP    O57991   O57991_PYRHO     1    235             
SEQRES   1 A  235  MSE ARG GLU VAL LYS LEU VAL THR PHE ASP VAL TRP ASN          
SEQRES   2 A  235  THR LEU LEU ASP LEU ASN ILE MSE LEU ASP GLU PHE SER          
SEQRES   3 A  235  HIS GLN LEU ALA LYS ILE SER GLY LEU HIS ILE LYS ASP          
SEQRES   4 A  235  VAL ALA ASN ALA VAL ILE GLU VAL ARG ASN GLU ILE LYS          
SEQRES   5 A  235  LYS MSE ARG ALA GLN ALA SER GLU ASP PRO ARG LYS VAL          
SEQRES   6 A  235  LEU THR GLY SER GLN GLU ALA LEU ALA GLY LYS LEU LYS          
SEQRES   7 A  235  VAL ASP VAL GLU LEU VAL LYS ARG ALA THR ALA ARG ALA          
SEQRES   8 A  235  ILE LEU ASN VAL ASP GLU SER LEU VAL LEU GLU GLY THR          
SEQRES   9 A  235  LYS GLU ALA LEU GLN PHE VAL LYS GLU ARG GLY LEU LYS          
SEQRES  10 A  235  THR ALA VAL ILE GLY ASN VAL MSE PHE TRP PRO GLY SER          
SEQRES  11 A  235  TYR THR ARG LEU LEU LEU GLU ARG PHE GLY LEU MSE GLU          
SEQRES  12 A  235  PHE ILE ASP LYS THR PHE PHE ALA ASP GLU VAL LEU SER          
SEQRES  13 A  235  TYR LYS PRO ARG LYS GLU MSE PHE GLU LYS VAL LEU ASN          
SEQRES  14 A  235  SER PHE GLU VAL LYS PRO GLU GLU SER LEU HIS ILE GLY          
SEQRES  15 A  235  ASP THR TYR ALA GLU ASP TYR GLN GLY ALA ARG LYS VAL          
SEQRES  16 A  235  GLY MSE TRP ALA VAL TRP ILE ASN GLN GLU GLY ASP LYS          
SEQRES  17 A  235  VAL ARG LYS LEU GLU GLU ARG GLY PHE GLU ILE PRO SER          
SEQRES  18 A  235  ILE ALA ASN LEU LYS ASP VAL ILE GLU LEU ILE SER LYS          
SEQRES  19 A  235  THR                                                          
SEQRES   1 B  235  MSE ARG GLU VAL LYS LEU VAL THR PHE ASP VAL TRP ASN          
SEQRES   2 B  235  THR LEU LEU ASP LEU ASN ILE MSE LEU ASP GLU PHE SER          
SEQRES   3 B  235  HIS GLN LEU ALA LYS ILE SER GLY LEU HIS ILE LYS ASP          
SEQRES   4 B  235  VAL ALA ASN ALA VAL ILE GLU VAL ARG ASN GLU ILE LYS          
SEQRES   5 B  235  LYS MSE ARG ALA GLN ALA SER GLU ASP PRO ARG LYS VAL          
SEQRES   6 B  235  LEU THR GLY SER GLN GLU ALA LEU ALA GLY LYS LEU LYS          
SEQRES   7 B  235  VAL ASP VAL GLU LEU VAL LYS ARG ALA THR ALA ARG ALA          
SEQRES   8 B  235  ILE LEU ASN VAL ASP GLU SER LEU VAL LEU GLU GLY THR          
SEQRES   9 B  235  LYS GLU ALA LEU GLN PHE VAL LYS GLU ARG GLY LEU LYS          
SEQRES  10 B  235  THR ALA VAL ILE GLY ASN VAL MSE PHE TRP PRO GLY SER          
SEQRES  11 B  235  TYR THR ARG LEU LEU LEU GLU ARG PHE GLY LEU MSE GLU          
SEQRES  12 B  235  PHE ILE ASP LYS THR PHE PHE ALA ASP GLU VAL LEU SER          
SEQRES  13 B  235  TYR LYS PRO ARG LYS GLU MSE PHE GLU LYS VAL LEU ASN          
SEQRES  14 B  235  SER PHE GLU VAL LYS PRO GLU GLU SER LEU HIS ILE GLY          
SEQRES  15 B  235  ASP THR TYR ALA GLU ASP TYR GLN GLY ALA ARG LYS VAL          
SEQRES  16 B  235  GLY MSE TRP ALA VAL TRP ILE ASN GLN GLU GLY ASP LYS          
SEQRES  17 B  235  VAL ARG LYS LEU GLU GLU ARG GLY PHE GLU ILE PRO SER          
SEQRES  18 B  235  ILE ALA ASN LEU LYS ASP VAL ILE GLU LEU ILE SER LYS          
SEQRES  19 B  235  THR                                                          
HET    MSE  A   1       8                                                       
HET    MSE  A  21       8                                                       
HET    MSE  A  54       8                                                       
HET    MSE  A 125       8                                                       
HET    MSE  A 142       8                                                       
HET    MSE  A 163       8                                                       
HET    MSE  A 197       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  21       8                                                       
HET    MSE  B  54       8                                                       
HET    MSE  B 125       8                                                       
HET    MSE  B 142       8                                                       
HET    MSE  B 163       8                                                       
HET    MSE  B 197       8                                                       
HET    SO4  A1300       5                                                       
HET    SO4  A1301       5                                                       
HET    SO4  B1302       5                                                       
HET     MG  B1401       1                                                       
HET     CL  B1402       1                                                       
HET     CL  B1403       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM      MG MAGNESIUM ION                                                    
HETNAM      CL CHLORIDE ION                                                     
FORMUL   1  MSE    14(C5 H11 N O2 SE)                                           
FORMUL   3  SO4    3(O4 S 2-)                                                   
FORMUL   6   MG    MG 2+                                                        
FORMUL   7   CL    2(CL 1-)                                                     
FORMUL   9  HOH   *443(H2 O)                                                    
CRYST1   50.052   66.239   79.014  90.00 107.62  90.00 P 1 21 1      4          
HETATM    1  N   MSE A   1     -16.895  32.392  64.914  1.00 74.87           N  
HETATM    2  CA  MSE A   1     -16.119  32.311  66.181  1.00 67.51           C  
HETATM    3  C   MSE A   1     -16.417  33.532  67.035  1.00 66.18           C  
HETATM    4  O   MSE A   1     -16.447  34.652  66.530  1.00 70.80           O  
HETATM    5  CB  MSE A   1     -14.623  32.276  65.883  1.00 74.11           C  
HETATM    6  CG  MSE A   1     -14.232  31.348  64.753  1.00 73.20           C  
HETATM    7 SE   MSE A   1     -12.327  31.363  64.464  1.00 82.79          SE  
HETATM    8  CE  MSE A   1     -12.086  33.243  64.053  1.00 44.28           C  
ATOM      9  N   ARG A   2     -16.631  33.313  68.328  1.00 58.52           N  
ATOM     10  CA  ARG A   2     -16.917  34.406  69.247  1.00 50.29           C  
ATOM     11  C   ARG A   2     -15.775  35.415  69.248  1.00 43.37           C  
ATOM     12  O   ARG A   2     -14.617  35.054  69.045  1.00 42.80           O  
ATOM     13  CB  ARG A   2     -17.147  33.856  70.661  1.00 51.89           C  
ATOM     14  CG  ARG A   2     -18.550  33.318  70.878  1.00 59.06           C  
ATOM     15  CD  ARG A   2     -18.633  32.375  72.064  1.00 71.16           C  
ATOM     16  NE  ARG A   2     -20.020  32.033  72.369  1.00 87.03           N  
ATOM     17  CZ  ARG A   2     -20.391  31.001  73.121  1.00 99.58           C  
ATOM     18  NH1 ARG A   2     -19.477  30.198  73.650  1.00105.89           N  
ATOM     19  NH2 ARG A   2     -21.679  30.775  73.349  1.00101.36           N  
ATOM     20  N   GLU A   3     -16.115  36.680  69.474  1.00 35.67           N  
ATOM     21  CA  GLU A   3     -15.137  37.760  69.499  1.00 37.91           C  
ATOM     22  C   GLU A   3     -14.358  37.738  70.811  1.00 35.23           C  
ATOM     23  O   GLU A   3     -14.932  37.540  71.880  1.00 38.45           O  
ATOM     24  CB  GLU A   3     -15.854  39.105  69.341  1.00 50.53           C  
ATOM     25  CG  GLU A   3     -14.950  40.289  69.012  1.00 64.18           C  
ATOM     26  CD  GLU A   3     -14.264  40.146  67.661  1.00 67.14           C  
ATOM     27  OE1 GLU A   3     -14.949  39.788  66.678  1.00 59.84           O  
ATOM     28  OE2 GLU A   3     -13.043  40.402  67.579  1.00 64.07           O  
ATOM     29  N   VAL A   4     -13.049  37.940  70.727  1.00 31.17           N  
ATOM     30  CA  VAL A   4     -12.209  37.946  71.913  1.00 26.00           C  
ATOM     31  C   VAL A   4     -12.424  39.222  72.726  1.00 32.49           C  
ATOM     32  O   VAL A   4     -12.384  40.333  72.191  1.00 28.32           O  
ATOM     33  CB  VAL A   4     -10.717  37.827  71.534  1.00 26.85           C  
ATOM     34  CG1 VAL A   4      -9.855  37.842  72.779  1.00 25.41           C  
ATOM     35  CG2 VAL A   4     -10.488  36.551  70.761  1.00 22.47           C  
ATOM     36  N   LYS A   5     -12.663  39.042  74.023  1.00 27.23           N  
ATOM     37  CA  LYS A   5     -12.882  40.143  74.952  1.00 28.98           C  
ATOM     38  C   LYS A   5     -11.728  40.292  75.948  1.00 29.95           C  
ATOM     39  O   LYS A   5     -11.547  41.344  76.557  1.00 22.14           O  
ATOM     40  CB  LYS A   5     -14.171  39.913  75.739  1.00 30.97           C  
ATOM     41  CG  LYS A   5     -15.371  40.670  75.210  1.00 53.80           C  
ATOM     42  CD  LYS A   5     -16.334  39.775  74.465  1.00 62.78           C  
ATOM     43  CE  LYS A   5     -17.499  40.588  73.929  1.00 62.73           C  
ATOM     44  NZ  LYS A   5     -18.538  39.729  73.310  1.00 76.81           N  
ATOM     45  N   LEU A   6     -10.941  39.236  76.110  1.00 20.90           N  
ATOM     46  CA  LEU A   6      -9.850  39.276  77.065  1.00 23.38           C  
ATOM     47  C   LEU A   6      -8.520  38.741  76.555  1.00 27.87           C  
ATOM     48  O   LEU A   6      -8.451  37.677  75.946  1.00 23.63           O  
ATOM     49  CB  LEU A   6     -10.258  38.493  78.308  1.00 15.77           C  
ATOM     50  CG  LEU A   6      -9.166  38.079  79.285  1.00 18.79           C  
ATOM     51  CD1 LEU A   6      -8.625  39.299  80.023  1.00 19.54           C  
ATOM     52  CD2 LEU A   6      -9.749  37.057  80.255  1.00 11.25           C  
ATOM     53  N   VAL A   7      -7.461  39.491  76.809  1.00 27.63           N  
ATOM     54  CA  VAL A   7      -6.136  39.060  76.417  1.00 25.84           C  
ATOM     55  C   VAL A   7      -5.314  38.943  77.695  1.00 25.46           C  
ATOM     56  O   VAL A   7      -5.178  39.911  78.437  1.00 24.41           O  
ATOM     57  CB  VAL A   7      -5.467  40.063  75.458  1.00 21.67           C  
ATOM     58  CG1 VAL A   7      -4.025  39.655  75.212  1.00 14.67           C  
ATOM     59  CG2 VAL A   7      -6.222  40.101  74.141  1.00 15.67           C  
ATOM     60  N   THR A   8      -4.791  37.752  77.963  1.00 27.93           N  
ATOM     61  CA  THR A   8      -3.986  37.542  79.156  1.00 22.83           C  
ATOM     62  C   THR A   8      -2.508  37.512  78.787  1.00 27.08           C  
ATOM     63  O   THR A   8      -2.137  37.050  77.701  1.00 26.13           O  
ATOM     64  CB  THR A   8      -4.398  36.246  79.896  1.00 21.16           C  
ATOM     65  OG1 THR A   8      -4.243  35.117  79.030  1.00 26.14           O  
ATOM     66  CG2 THR A   8      -5.858  36.346  80.353  1.00 23.30           C  
ATOM     67  N   PHE A   9      -1.672  37.999  79.704  1.00 21.17           N  
ATOM     68  CA  PHE A   9      -0.238  38.103  79.466  1.00 21.15           C  
ATOM     69  C   PHE A   9       0.685  37.454  80.478  1.00 22.42           C  
ATOM     70  O   PHE A   9       0.516  37.603  81.685  1.00 24.81           O  
ATOM     71  CB  PHE A   9       0.169  39.581  79.383  1.00 23.01           C  
ATOM     72  CG  PHE A   9      -0.438  40.335  78.226  1.00 25.34           C  
ATOM     73  CD1 PHE A   9       0.228  40.420  77.008  1.00 17.85           C  
ATOM     74  CD2 PHE A   9      -1.657  40.982  78.366  1.00 23.44           C  
ATOM     75  CE1 PHE A   9      -0.312  41.142  75.952  1.00 30.98           C  
ATOM     76  CE2 PHE A   9      -2.207  41.707  77.310  1.00 30.97           C  
ATOM     77  CZ  PHE A   9      -1.534  41.788  76.103  1.00 27.43           C  
ATOM     78  N   ASP A  10       1.672  36.735  79.962  1.00 22.41           N  
ATOM     79  CA  ASP A  10       2.702  36.130  80.784  1.00 15.18           C  
ATOM     80  C   ASP A  10       3.602  37.355  80.996  1.00 21.16           C  
ATOM     81  O   ASP A  10       3.477  38.337  80.259  1.00 22.24           O  
ATOM     82  CB  ASP A  10       3.417  35.044  79.979  1.00 17.57           C  
ATOM     83  CG  ASP A  10       4.732  34.615  80.594  1.00 21.18           C  
ATOM     84  OD1 ASP A  10       4.769  34.332  81.807  1.00 22.36           O  
ATOM     85  OD2 ASP A  10       5.734  34.542  79.844  1.00 35.92           O  
ATOM     86  N   VAL A  11       4.484  37.333  81.989  1.00 22.36           N  
ATOM     87  CA  VAL A  11       5.350  38.490  82.208  1.00 17.76           C  
ATOM     88  C   VAL A  11       6.804  38.271  81.754  1.00 22.51           C  
ATOM     89  O   VAL A  11       7.251  38.827  80.746  1.00 21.79           O  
ATOM     90  CB  VAL A  11       5.360  38.929  83.700  1.00 17.61           C  
ATOM     91  CG1 VAL A  11       6.213  40.203  83.877  1.00  9.35           C  
ATOM     92  CG2 VAL A  11       3.950  39.179  84.175  1.00 20.44           C  
ATOM     93  N   TRP A  12       7.541  37.461  82.501  1.00 24.89           N  
ATOM     94  CA  TRP A  12       8.932  37.210  82.180  1.00 29.43           C  
ATOM     95  C   TRP A  12       9.175  36.525  80.828  1.00 28.54           C  
ATOM     96  O   TRP A  12       8.766  35.388  80.598  1.00 24.87           O  
ATOM     97  CB  TRP A  12       9.563  36.457  83.346  1.00 20.24           C  
ATOM     98  CG  TRP A  12       9.519  37.313  84.574  1.00 23.51           C  
ATOM     99  CD1 TRP A  12       8.652  37.202  85.633  1.00 17.52           C  
ATOM    100  CD2 TRP A  12      10.287  38.500  84.809  1.00 18.26           C  
ATOM    101  NE1 TRP A  12       8.834  38.253  86.504  1.00 13.58           N  
ATOM    102  CE2 TRP A  12       9.829  39.062  86.025  1.00 14.34           C  
ATOM    103  CE3 TRP A  12      11.317  39.147  84.108  1.00 22.88           C  
ATOM    104  CZ2 TRP A  12      10.368  40.238  86.556  1.00 17.50           C  
ATOM    105  CZ3 TRP A  12      11.854  40.321  84.635  1.00 14.76           C  
ATOM    106  CH2 TRP A  12      11.378  40.852  85.847  1.00 18.06           C  
ATOM    107  N   ASN A  13       9.849  37.262  79.945  1.00 25.50           N  
ATOM    108  CA  ASN A  13      10.177  36.854  78.577  1.00 30.51           C  
ATOM    109  C   ASN A  13       9.003  37.047  77.609  1.00 32.51           C  
ATOM    110  O   ASN A  13       8.958  36.450  76.531  1.00 26.20           O  
ATOM    111  CB  ASN A  13      10.698  35.412  78.512  1.00 21.61           C  
ATOM    112  CG  ASN A  13      12.118  35.277  79.055  1.00 31.07           C  
ATOM    113  OD1 ASN A  13      12.955  36.163  78.876  1.00 31.78           O  
ATOM    114  ND2 ASN A  13      12.396  34.157  79.703  1.00 25.07           N  
ATOM    115  N   THR A  14       8.055  37.887  78.014  1.00 23.18           N  
ATOM    116  CA  THR A  14       6.898  38.241  77.190  1.00 21.13           C  
ATOM    117  C   THR A  14       6.826  39.770  77.233  1.00 23.08           C  
ATOM    118  O   THR A  14       6.802  40.440  76.201  1.00 30.70           O  
ATOM    119  CB  THR A  14       5.551  37.674  77.742  1.00 17.15           C  
ATOM    120  OG1 THR A  14       5.500  36.251  77.571  1.00 21.36           O  
ATOM    121  CG2 THR A  14       4.369  38.301  77.003  1.00 13.43           C  
ATOM    122  N   LEU A  15       6.820  40.308  78.447  1.00 21.48           N  
ATOM    123  CA  LEU A  15       6.752  41.748  78.659  1.00 17.01           C  
ATOM    124  C   LEU A  15       8.099  42.273  79.135  1.00 16.59           C  
ATOM    125  O   LEU A  15       8.569  43.309  78.670  1.00 18.32           O  
ATOM    126  CB  LEU A  15       5.682  42.063  79.705  1.00 15.15           C  
ATOM    127  CG  LEU A  15       4.269  41.573  79.385  1.00 16.61           C  
ATOM    128  CD1 LEU A  15       3.359  41.780  80.594  1.00 25.57           C  
ATOM    129  CD2 LEU A  15       3.737  42.318  78.169  1.00 17.14           C  
ATOM    130  N   LEU A  16       8.713  41.541  80.061  1.00 13.93           N  
ATOM    131  CA  LEU A  16       9.993  41.920  80.622  1.00 16.44           C  
ATOM    132  C   LEU A  16      11.054  40.857  80.331  1.00 25.55           C  
ATOM    133  O   LEU A  16      10.747  39.680  80.168  1.00 26.15           O  
ATOM    134  CB  LEU A  16       9.854  42.131  82.133  1.00 18.22           C  
ATOM    135  CG  LEU A  16       8.916  43.249  82.597  1.00 22.55           C  
ATOM    136  CD1 LEU A  16       8.894  43.303  84.126  1.00 17.44           C  
ATOM    137  CD2 LEU A  16       9.386  44.582  82.027  1.00 22.98           C  
ATOM    138  N   ASP A  17      12.305  41.294  80.288  1.00 22.30           N  
ATOM    139  CA  ASP A  17      13.431  40.438  79.988  1.00 24.73           C  
ATOM    140  C   ASP A  17      13.917  39.694  81.228  1.00 33.45           C  
ATOM    141  O   ASP A  17      14.508  40.294  82.125  1.00 29.46           O  
ATOM    142  CB  ASP A  17      14.554  41.302  79.422  1.00 26.82           C  
ATOM    143  CG  ASP A  17      15.643  40.489  78.768  1.00 35.18           C  
ATOM    144  OD1 ASP A  17      16.034  39.457  79.352  1.00 22.85           O  
ATOM    145  OD2 ASP A  17      16.113  40.893  77.679  1.00 36.40           O  
ATOM    146  N   LEU A  18      13.694  38.384  81.261  1.00 27.69           N  
ATOM    147  CA  LEU A  18      14.095  37.571  82.406  1.00 25.86           C  
ATOM    148  C   LEU A  18      15.595  37.339  82.528  1.00 26.73           C  
ATOM    149  O   LEU A  18      16.105  37.173  83.636  1.00 29.84           O  
ATOM    150  CB  LEU A  18      13.370  36.218  82.393  1.00 31.75           C  
ATOM    151  CG  LEU A  18      13.673  35.316  83.593  1.00 24.27           C  
ATOM    152  CD1 LEU A  18      13.205  36.003  84.869  1.00 28.82           C  
ATOM    153  CD2 LEU A  18      12.982  33.988  83.433  1.00 28.72           C  
ATOM    154  N   ASN A  19      16.308  37.313  81.407  1.00 27.90           N  
ATOM    155  CA  ASN A  19      17.755  37.125  81.479  1.00 31.43           C  
ATOM    156  C   ASN A  19      18.393  38.275  82.247  1.00 25.49           C  
ATOM    157  O   ASN A  19      19.169  38.056  83.171  1.00 24.33           O  
ATOM    158  CB  ASN A  19      18.360  37.034  80.080  1.00 36.06           C  
ATOM    159  CG  ASN A  19      18.120  35.692  79.440  1.00 49.92           C  
ATOM    160  OD1 ASN A  19      18.562  34.663  79.953  1.00 48.99           O  
ATOM    161  ND2 ASN A  19      17.409  35.687  78.317  1.00 60.96           N  
ATOM    162  N   ILE A  20      18.047  39.503  81.877  1.00 29.62           N  
ATOM    163  CA  ILE A  20      18.589  40.672  82.557  1.00 26.48           C  
ATOM    164  C   ILE A  20      18.307  40.626  84.062  1.00 27.09           C  
ATOM    165  O   ILE A  20      19.179  40.943  84.863  1.00 26.09           O  
ATOM    166  CB  ILE A  20      18.011  41.972  81.961  1.00 21.14           C  
ATOM    167  CG1 ILE A  20      18.476  42.120  80.507  1.00 27.89           C  
ATOM    168  CG2 ILE A  20      18.467  43.172  82.775  1.00 22.96           C  
ATOM    169  CD1 ILE A  20      17.846  43.291  79.758  1.00 17.57           C  
HETATM  170  N   MSE A  21      17.097  40.215  84.442  1.00 29.58           N  
HETATM  171  CA  MSE A  21      16.733  40.139  85.859  1.00 27.40           C  
HETATM  172  C   MSE A  21      17.497  39.048  86.600  1.00 25.78           C  
HETATM  173  O   MSE A  21      18.091  39.304  87.643  1.00 23.27           O  
HETATM  174  CB  MSE A  21      15.227  39.888  86.028  1.00 22.49           C  
HETATM  175  CG  MSE A  21      14.433  41.091  86.517  1.00 47.96           C  
HETATM  176 SE   MSE A  21      14.871  41.655  88.311  1.00 44.19          SE  
HETATM  177  CE  MSE A  21      13.563  40.641  89.286  1.00 57.98           C  
ATOM    178  N   LEU A  22      17.469  37.827  86.070  1.00 21.72           N  
ATOM    179  CA  LEU A  22      18.166  36.724  86.714  1.00 20.73           C  
ATOM    180  C   LEU A  22      19.640  37.036  86.878  1.00 15.06           C  
ATOM    181  O   LEU A  22      20.260  36.635  87.862  1.00 27.37           O  
ATOM    182  CB  LEU A  22      18.002  35.437  85.912  1.00 20.77           C  
ATOM    183  CG  LEU A  22      16.594  34.843  85.949  1.00 35.98           C  
ATOM    184  CD1 LEU A  22      16.581  33.547  85.148  1.00 33.60           C  
ATOM    185  CD2 LEU A  22      16.170  34.592  87.403  1.00 14.23           C  
ATOM    186  N   ASP A  23      20.185  37.756  85.903  1.00 20.75           N  
ATOM    187  CA  ASP A  23      21.584  38.149  85.905  1.00 24.19           C  
ATOM    188  C   ASP A  23      21.837  39.210  86.960  1.00 27.38           C  
ATOM    189  O   ASP A  23      22.846  39.160  87.665  1.00 23.52           O  
ATOM    190  CB  ASP A  23      21.979  38.678  84.522  1.00 26.53           C  
ATOM    191  CG  ASP A  23      21.980  37.588  83.456  1.00 49.22           C  
ATOM    192  OD1 ASP A  23      21.224  36.593  83.602  1.00 42.68           O  
ATOM    193  OD2 ASP A  23      22.729  37.733  82.464  1.00 60.39           O  
ATOM    194  N   GLU A  24      20.924  40.172  87.075  1.00 23.83           N  
ATOM    195  CA  GLU A  24      21.092  41.216  88.077  1.00 19.80           C  
ATOM    196  C   GLU A  24      20.986  40.570  89.456  1.00 22.81           C  
ATOM    197  O   GLU A  24      21.779  40.860  90.357  1.00 25.44           O  
ATOM    198  CB  GLU A  24      20.030  42.302  87.903  1.00 17.51           C  
ATOM    199  CG  GLU A  24      20.165  43.467  88.884  1.00 26.49           C  
ATOM    200  CD  GLU A  24      21.538  44.111  88.841  1.00 33.12           C  
ATOM    201  OE1 GLU A  24      22.019  44.388  87.726  1.00 39.65           O  
ATOM    202  OE2 GLU A  24      22.136  44.344  89.915  1.00 31.00           O  
ATOM    203  N   PHE A  25      20.016  39.671  89.595  1.00 24.24           N  
ATOM    204  CA  PHE A  25      19.770  38.932  90.834  1.00 17.96           C  
ATOM    205  C   PHE A  25      20.967  38.052  91.234  1.00 25.35           C  
ATOM    206  O   PHE A  25      21.363  38.020  92.402  1.00 20.75           O  
ATOM    207  CB  PHE A  25      18.515  38.074  90.649  1.00 17.33           C  
ATOM    208  CG  PHE A  25      18.257  37.092  91.767  1.00 27.55           C  
ATOM    209  CD1 PHE A  25      18.147  37.519  93.087  1.00 29.98           C  
ATOM    210  CD2 PHE A  25      18.095  35.737  91.489  1.00 22.16           C  
ATOM    211  CE1 PHE A  25      17.876  36.607  94.117  1.00 25.81           C  
ATOM    212  CE2 PHE A  25      17.825  34.819  92.508  1.00 18.60           C  
ATOM    213  CZ  PHE A  25      17.714  35.256  93.822  1.00 23.03           C  
ATOM    214  N   SER A  26      21.531  37.331  90.267  1.00 22.13           N  
ATOM    215  CA  SER A  26      22.680  36.463  90.538  1.00 22.65           C  
ATOM    216  C   SER A  26      23.885  37.305  90.961  1.00 17.62           C  
ATOM    217  O   SER A  26      24.654  36.922  91.847  1.00 28.08           O  
ATOM    218  CB  SER A  26      23.034  35.639  89.292  1.00 16.99           C  
ATOM    219  OG  SER A  26      22.057  34.653  89.034  1.00 22.69           O  
ATOM    220  N   HIS A  27      24.046  38.451  90.309  1.00 17.52           N  
ATOM    221  CA  HIS A  27      25.129  39.374  90.627  1.00 19.10           C  
ATOM    222  C   HIS A  27      24.954  39.910  92.053  1.00 14.89           C  
ATOM    223  O   HIS A  27      25.897  39.906  92.853  1.00 21.37           O  
ATOM    224  CB  HIS A  27      25.138  40.522  89.606  1.00 26.75           C  
ATOM    225  CG  HIS A  27      25.752  41.785  90.118  1.00 32.54           C  
ATOM    226  ND1 HIS A  27      27.064  41.862  90.531  1.00 34.13           N  
ATOM    227  CD2 HIS A  27      25.222  43.015  90.319  1.00 30.05           C  
ATOM    228  CE1 HIS A  27      27.315  43.082  90.970  1.00 40.85           C  
ATOM    229  NE2 HIS A  27      26.213  43.802  90.852  1.00 40.74           N  
ATOM    230  N   GLN A  28      23.744  40.362  92.379  1.00 27.92           N  
ATOM    231  CA  GLN A  28      23.478  40.889  93.717  1.00 18.66           C  
ATOM    232  C   GLN A  28      23.630  39.805  94.786  1.00 23.67           C  
ATOM    233  O   GLN A  28      24.172  40.061  95.862  1.00 20.79           O  
ATOM    234  CB  GLN A  28      22.073  41.488  93.800  1.00 20.32           C  
ATOM    235  CG  GLN A  28      21.882  42.793  93.043  1.00 22.79           C  
ATOM    236  CD  GLN A  28      22.902  43.854  93.428  1.00 27.16           C  
ATOM    237  OE1 GLN A  28      23.325  43.939  94.578  1.00 27.70           O  
ATOM    238  NE2 GLN A  28      23.288  44.675  92.464  1.00 37.82           N  
ATOM    239  N   LEU A  29      23.146  38.599  94.496  1.00 21.29           N  
ATOM    240  CA  LEU A  29      23.257  37.506  95.452  1.00 23.24           C  
ATOM    241  C   LEU A  29      24.720  37.092  95.648  1.00 23.41           C  
ATOM    242  O   LEU A  29      25.144  36.827  96.771  1.00 27.27           O  
ATOM    243  CB  LEU A  29      22.417  36.306  94.999  1.00 29.24           C  
ATOM    244  CG  LEU A  29      22.413  35.092  95.939  1.00 33.49           C  
ATOM    245  CD1 LEU A  29      22.088  35.535  97.357  1.00 28.85           C  
ATOM    246  CD2 LEU A  29      21.398  34.071  95.453  1.00 39.05           C  
ATOM    247  N   ALA A  30      25.489  37.051  94.559  1.00 31.86           N  
ATOM    248  CA  ALA A  30      26.904  36.685  94.632  1.00 22.35           C  
ATOM    249  C   ALA A  30      27.658  37.769  95.388  1.00 31.24           C  
ATOM    250  O   ALA A  30      28.574  37.489  96.171  1.00 24.20           O  
ATOM    251  CB  ALA A  30      27.487  36.539  93.228  1.00 20.53           C  
ATOM    252  N   LYS A  31      27.263  39.012  95.147  1.00 24.41           N  
ATOM    253  CA  LYS A  31      27.890  40.149  95.799  1.00 29.08           C  
ATOM    254  C   LYS A  31      27.739  40.123  97.322  1.00 31.42           C  
ATOM    255  O   LYS A  31      28.740  40.178  98.041  1.00 24.39           O  
ATOM    256  CB  LYS A  31      27.316  41.451  95.235  1.00 26.33           C  
ATOM    257  CG  LYS A  31      27.887  42.714  95.854  1.00 24.87           C  
ATOM    258  CD  LYS A  31      27.441  43.946  95.069  1.00 36.64           C  
ATOM    259  CE  LYS A  31      27.992  45.231  95.666  1.00 48.14           C  
ATOM    260  NZ  LYS A  31      27.567  46.428  94.891  1.00 59.89           N  
ATOM    261  N   ILE A  32      26.508  40.028  97.825  1.00 19.87           N  
ATOM    262  CA  ILE A  32      26.323  40.018  99.277  1.00 25.31           C  
ATOM    263  C   ILE A  32      26.743  38.722  99.960  1.00 22.90           C  
ATOM    264  O   ILE A  32      26.892  38.695 101.173  1.00 20.26           O  
ATOM    265  CB  ILE A  32      24.862  40.296  99.695  1.00 29.51           C  
ATOM    266  CG1 ILE A  32      23.952  39.163  99.221  1.00 30.25           C  
ATOM    267  CG2 ILE A  32      24.415  41.635  99.156  1.00 34.91           C  
ATOM    268  CD1 ILE A  32      22.513  39.325  99.668  1.00 46.33           C  
ATOM    269  N   SER A  33      26.930  37.650  99.195  1.00 19.96           N  
ATOM    270  CA  SER A  33      27.325  36.383  99.793  1.00 20.33           C  
ATOM    271  C   SER A  33      28.832  36.174  99.798  1.00 19.55           C  
ATOM    272  O   SER A  33      29.345  35.400 100.593  1.00 31.64           O  
ATOM    273  CB  SER A  33      26.669  35.214  99.061  1.00 24.59           C  
ATOM    274  OG  SER A  33      27.209  35.078  97.765  1.00 38.96           O  
ATOM    275  N   GLY A  34      29.537  36.866  98.914  1.00 23.11           N  
ATOM    276  CA  GLY A  34      30.971  36.690  98.832  1.00 20.38           C  
ATOM    277  C   GLY A  34      31.299  35.468  97.981  1.00 26.77           C  
ATOM    278  O   GLY A  34      32.384  34.894  98.088  1.00 26.57           O  
ATOM    279  N   LEU A  35      30.348  35.061  97.141  1.00 23.52           N  
ATOM    280  CA  LEU A  35      30.527  33.918  96.250  1.00 21.53           C  
ATOM    281  C   LEU A  35      30.682  34.433  94.819  1.00 26.69           C  
ATOM    282  O   LEU A  35      30.328  35.581  94.519  1.00 23.35           O  
ATOM    283  CB  LEU A  35      29.311  32.982  96.311  1.00 16.77           C  
ATOM    284  CG  LEU A  35      28.872  32.417  97.664  1.00 33.28           C  
ATOM    285  CD1 LEU A  35      27.540  31.711  97.512  1.00 22.53           C  
ATOM    286  CD2 LEU A  35      29.927  31.467  98.198  1.00 24.27           C  
ATOM    287  N   HIS A  36      31.211  33.585  93.937  1.00 22.73           N  
ATOM    288  CA  HIS A  36      31.384  33.958  92.540  1.00 24.34           C  
ATOM    289  C   HIS A  36      30.022  33.877  91.840  1.00 24.26           C  
ATOM    290  O   HIS A  36      29.165  33.071  92.215  1.00 23.92           O  
ATOM    291  CB  HIS A  36      32.408  33.032  91.873  1.00 21.71           C  
ATOM    292  CG  HIS A  36      33.798  33.200  92.405  1.00 26.36           C  
ATOM    293  ND1 HIS A  36      34.581  34.294  92.104  1.00 31.75           N  
ATOM    294  CD2 HIS A  36      34.518  32.450  93.274  1.00 21.92           C  
ATOM    295  CE1 HIS A  36      35.721  34.212  92.767  1.00 28.36           C  
ATOM    296  NE2 HIS A  36      35.708  33.103  93.485  1.00 27.99           N  
ATOM    297  N   ILE A  37      29.817  34.727  90.841  1.00 17.71           N  
ATOM    298  CA  ILE A  37      28.558  34.767  90.113  1.00 22.96           C  
ATOM    299  C   ILE A  37      28.237  33.412  89.473  1.00 36.01           C  
ATOM    300  O   ILE A  37      27.076  32.999  89.424  1.00 42.33           O  
ATOM    301  CB  ILE A  37      28.587  35.893  89.043  1.00 24.73           C  
ATOM    302  CG1 ILE A  37      27.159  36.251  88.628  1.00 30.69           C  
ATOM    303  CG2 ILE A  37      29.386  35.437  87.821  1.00 35.15           C  
ATOM    304  CD1 ILE A  37      27.034  37.626  87.987  1.00 37.53           C  
ATOM    305  N   LYS A  38      29.274  32.719  89.005  1.00 40.47           N  
ATOM    306  CA  LYS A  38      29.125  31.406  88.382  1.00 31.75           C  
ATOM    307  C   LYS A  38      28.435  30.454  89.353  1.00 35.83           C  
ATOM    308  O   LYS A  38      27.473  29.775  88.986  1.00 27.07           O  
ATOM    309  CB  LYS A  38      30.498  30.843  87.994  1.00 41.21           C  
ATOM    310  CG  LYS A  38      30.447  29.546  87.187  1.00 42.52           C  
ATOM    311  CD  LYS A  38      29.644  29.738  85.911  1.00 45.77           C  
ATOM    312  CE  LYS A  38      29.915  28.643  84.899  1.00 43.08           C  
ATOM    313  NZ  LYS A  38      29.673  27.310  85.474  1.00 33.68           N  
ATOM    314  N   ASP A  39      28.932  30.404  90.588  1.00 29.78           N  
ATOM    315  CA  ASP A  39      28.343  29.549  91.623  1.00 34.17           C  
ATOM    316  C   ASP A  39      26.850  29.830  91.726  1.00 33.00           C  
ATOM    317  O   ASP A  39      26.024  28.923  91.652  1.00 30.61           O  
ATOM    318  CB  ASP A  39      28.982  29.837  92.986  1.00 40.09           C  
ATOM    319  CG  ASP A  39      30.188  28.973  93.265  1.00 45.58           C  
ATOM    320  OD1 ASP A  39      31.045  28.835  92.365  1.00 57.21           O  
ATOM    321  OD2 ASP A  39      30.278  28.440  94.393  1.00 46.98           O  
ATOM    322  N   VAL A  40      26.525  31.107  91.881  1.00 31.34           N  
ATOM    323  CA  VAL A  40      25.149  31.558  92.021  1.00 31.47           C  
ATOM    324  C   VAL A  40      24.287  31.310  90.794  1.00 30.41           C  
ATOM    325  O   VAL A  40      23.152  30.862  90.915  1.00 32.44           O  
ATOM    326  CB  VAL A  40      25.106  33.064  92.358  1.00 23.74           C  
ATOM    327  CG1 VAL A  40      23.670  33.503  92.592  1.00 17.94           C  
ATOM    328  CG2 VAL A  40      25.987  33.344  93.584  1.00 15.24           C  
ATOM    329  N   ALA A  41      24.814  31.607  89.612  1.00 34.60           N  
ATOM    330  CA  ALA A  41      24.043  31.404  88.390  1.00 35.66           C  
ATOM    331  C   ALA A  41      23.634  29.942  88.259  1.00 34.87           C  
ATOM    332  O   ALA A  41      22.497  29.637  87.884  1.00 35.36           O  
ATOM    333  CB  ALA A  41      24.852  31.837  87.167  1.00 29.49           C  
ATOM    334  N   ASN A  42      24.555  29.039  88.582  1.00 29.42           N  
ATOM    335  CA  ASN A  42      24.269  27.619  88.483  1.00 27.74           C  
ATOM    336  C   ASN A  42      23.187  27.184  89.452  1.00 35.40           C  
ATOM    337  O   ASN A  42      22.325  26.371  89.104  1.00 35.31           O  
ATOM    338  CB  ASN A  42      25.535  26.798  88.712  1.00 45.96           C  
ATOM    339  CG  ASN A  42      26.552  27.000  87.619  1.00 53.05           C  
ATOM    340  OD1 ASN A  42      26.202  27.086  86.440  1.00 51.85           O  
ATOM    341  ND2 ASN A  42      27.824  27.070  87.998  1.00 63.95           N  
ATOM    342  N   ALA A  43      23.230  27.719  90.670  1.00 30.41           N  
ATOM    343  CA  ALA A  43      22.224  27.372  91.662  1.00 29.98           C  
ATOM    344  C   ALA A  43      20.861  27.874  91.180  1.00 26.98           C  
ATOM    345  O   ALA A  43      19.847  27.198  91.350  1.00 27.49           O  
ATOM    346  CB  ALA A  43      22.573  27.988  93.000  1.00 22.57           C  
ATOM    347  N   VAL A  44      20.847  29.056  90.568  1.00 24.70           N  
ATOM    348  CA  VAL A  44      19.608  29.635  90.055  1.00 27.85           C  
ATOM    349  C   VAL A  44      19.070  28.710  88.974  1.00 30.09           C  
ATOM    350  O   VAL A  44      17.889  28.364  88.973  1.00 27.74           O  
ATOM    351  CB  VAL A  44      19.841  31.046  89.451  1.00 28.75           C  
ATOM    352  CG1 VAL A  44      18.579  31.537  88.753  1.00 23.24           C  
ATOM    353  CG2 VAL A  44      20.228  32.022  90.550  1.00 33.40           C  
ATOM    354  N   ILE A  45      19.954  28.306  88.064  1.00 33.16           N  
ATOM    355  CA  ILE A  45      19.586  27.404  86.978  1.00 35.49           C  
ATOM    356  C   ILE A  45      19.043  26.083  87.512  1.00 32.50           C  
ATOM    357  O   ILE A  45      18.016  25.585  87.049  1.00 30.13           O  
ATOM    358  CB  ILE A  45      20.798  27.118  86.071  1.00 36.46           C  
ATOM    359  CG1 ILE A  45      21.036  28.326  85.163  1.00 35.27           C  
ATOM    360  CG2 ILE A  45      20.577  25.826  85.275  1.00 25.97           C  
ATOM    361  CD1 ILE A  45      22.280  28.218  84.307  1.00 43.16           C  
ATOM    362  N   GLU A  46      19.736  25.519  88.490  1.00 36.14           N  
ATOM    363  CA  GLU A  46      19.306  24.262  89.077  1.00 37.83           C  
ATOM    364  C   GLU A  46      17.948  24.376  89.747  1.00 36.22           C  
ATOM    365  O   GLU A  46      17.108  23.497  89.582  1.00 40.26           O  
ATOM    366  CB  GLU A  46      20.348  23.764  90.075  1.00 42.25           C  
ATOM    367  CG  GLU A  46      21.579  23.167  89.405  1.00 40.78           C  
ATOM    368  CD  GLU A  46      22.668  22.821  90.396  1.00 41.85           C  
ATOM    369  OE1 GLU A  46      22.341  22.271  91.468  1.00 42.77           O  
ATOM    370  OE2 GLU A  46      23.850  23.094  90.101  1.00 39.89           O  
ATOM    371  N   VAL A  47      17.722  25.451  90.497  1.00 31.34           N  
ATOM    372  CA  VAL A  47      16.430  25.640  91.162  1.00 30.24           C  
ATOM    373  C   VAL A  47      15.337  25.913  90.128  1.00 35.01           C  
ATOM    374  O   VAL A  47      14.230  25.372  90.212  1.00 33.84           O  
ATOM    375  CB  VAL A  47      16.467  26.820  92.158  1.00 24.45           C  
ATOM    376  CG1 VAL A  47      15.072  27.073  92.711  1.00 27.20           C  
ATOM    377  CG2 VAL A  47      17.436  26.520  93.286  1.00 18.93           C  
ATOM    378  N   ARG A  48      15.666  26.755  89.152  1.00 36.44           N  
ATOM    379  CA  ARG A  48      14.740  27.121  88.088  1.00 41.78           C  
ATOM    380  C   ARG A  48      14.230  25.896  87.320  1.00 43.81           C  
ATOM    381  O   ARG A  48      13.033  25.773  87.051  1.00 41.13           O  
ATOM    382  CB  ARG A  48      15.423  28.092  87.122  1.00 44.55           C  
ATOM    383  CG  ARG A  48      14.540  28.554  85.985  1.00 41.92           C  
ATOM    384  CD  ARG A  48      15.320  29.388  84.974  1.00 52.94           C  
ATOM    385  NE  ARG A  48      14.513  29.680  83.791  1.00 50.38           N  
ATOM    386  CZ  ARG A  48      13.362  30.342  83.833  1.00 44.50           C  
ATOM    387  NH1 ARG A  48      12.906  30.775  84.998  1.00 41.77           N  
ATOM    388  NH2 ARG A  48      12.664  30.556  82.721  1.00 39.12           N  
ATOM    389  N   ASN A  49      15.135  24.988  86.972  1.00 33.19           N  
ATOM    390  CA  ASN A  49      14.734  23.789  86.245  1.00 44.87           C  
ATOM    391  C   ASN A  49      13.934  22.821  87.122  1.00 43.11           C  
ATOM    392  O   ASN A  49      12.888  22.320  86.710  1.00 36.10           O  
ATOM    393  CB  ASN A  49      15.963  23.079  85.669  1.00 51.07           C  
ATOM    394  CG  ASN A  49      16.656  23.894  84.586  1.00 55.67           C  
ATOM    395  OD1 ASN A  49      16.056  24.231  83.568  1.00 59.21           O  
ATOM    396  ND2 ASN A  49      17.926  24.210  84.802  1.00 65.14           N  
ATOM    397  N   GLU A  50      14.414  22.564  88.332  1.00 47.33           N  
ATOM    398  CA  GLU A  50      13.718  21.649  89.228  1.00 53.95           C  
ATOM    399  C   GLU A  50      12.301  22.136  89.524  1.00 54.70           C  
ATOM    400  O   GLU A  50      11.397  21.328  89.738  1.00 60.46           O  
ATOM    401  CB  GLU A  50      14.521  21.456  90.524  1.00 57.14           C  
ATOM    402  CG  GLU A  50      15.837  20.694  90.297  1.00 85.25           C  
ATOM    403  CD  GLU A  50      16.703  20.552  91.548  1.00 95.73           C  
ATOM    404  OE1 GLU A  50      17.087  21.584  92.142  1.00 97.56           O  
ATOM    405  OE2 GLU A  50      17.014  19.402  91.930  1.00 97.18           O  
ATOM    406  N   ILE A  51      12.098  23.451  89.525  1.00 49.46           N  
ATOM    407  CA  ILE A  51      10.769  23.997  89.776  1.00 40.80           C  
ATOM    408  C   ILE A  51       9.899  23.847  88.531  1.00 42.94           C  
ATOM    409  O   ILE A  51       8.711  23.545  88.628  1.00 42.43           O  
ATOM    410  CB  ILE A  51      10.831  25.483  90.160  1.00 42.62           C  
ATOM    411  CG1 ILE A  51      11.523  25.630  91.514  1.00 27.84           C  
ATOM    412  CG2 ILE A  51       9.417  26.080  90.182  1.00 30.66           C  
ATOM    413  CD1 ILE A  51      11.593  27.054  92.007  1.00 38.43           C  
ATOM    414  N   LYS A  52      10.493  24.066  87.363  1.00 36.76           N  
ATOM    415  CA  LYS A  52       9.764  23.929  86.112  1.00 44.32           C  
ATOM    416  C   LYS A  52       9.224  22.504  86.016  1.00 54.28           C  
ATOM    417  O   LYS A  52       8.058  22.289  85.678  1.00 57.80           O  
ATOM    418  CB  LYS A  52      10.690  24.207  84.926  1.00 48.12           C  
ATOM    419  CG  LYS A  52      11.057  25.671  84.729  1.00 45.15           C  
ATOM    420  CD  LYS A  52       9.898  26.449  84.137  1.00 55.21           C  
ATOM    421  CE  LYS A  52      10.321  27.847  83.725  1.00 47.05           C  
ATOM    422  NZ  LYS A  52       9.219  28.563  83.021  1.00 41.53           N  
ATOM    423  N   LYS A  53      10.076  21.531  86.326  1.00 53.47           N  
ATOM    424  CA  LYS A  53       9.683  20.132  86.270  1.00 51.77           C  
ATOM    425  C   LYS A  53       8.504  19.828  87.196  1.00 44.00           C  
ATOM    426  O   LYS A  53       7.542  19.195  86.782  1.00 41.17           O  
ATOM    427  CB  LYS A  53      10.876  19.238  86.618  1.00 62.56           C  
ATOM    428  CG  LYS A  53      11.099  18.093  85.635  1.00 73.63           C  
ATOM    429  CD  LYS A  53      12.460  17.429  85.842  1.00 87.32           C  
ATOM    430  CE  LYS A  53      12.746  16.389  84.757  1.00 92.82           C  
ATOM    431  NZ  LYS A  53      14.099  15.766  84.884  1.00 84.77           N  
HETATM  432  N   MSE A  54       8.565  20.286  88.441  1.00 43.24           N  
HETATM  433  CA  MSE A  54       7.469  20.026  89.371  1.00 50.20           C  
HETATM  434  C   MSE A  54       6.129  20.556  88.870  1.00 51.53           C  
HETATM  435  O   MSE A  54       5.083  19.995  89.187  1.00 53.67           O  
HETATM  436  CB  MSE A  54       7.776  20.613  90.753  1.00 54.34           C  
HETATM  437  CG  MSE A  54       8.924  19.911  91.478  1.00 71.95           C  
HETATM  438 SE   MSE A  54       8.698  17.979  91.619  1.00 79.15          SE  
HETATM  439  CE  MSE A  54       7.818  17.896  93.338  1.00 68.92           C  
ATOM    440  N   ARG A  55       6.160  21.635  88.092  1.00 54.90           N  
ATOM    441  CA  ARG A  55       4.940  22.220  87.538  1.00 51.36           C  
ATOM    442  C   ARG A  55       4.431  21.344  86.405  1.00 49.69           C  
ATOM    443  O   ARG A  55       3.226  21.209  86.201  1.00 51.41           O  
ATOM    444  CB  ARG A  55       5.215  23.617  87.000  1.00 49.40           C  
ATOM    445  CG  ARG A  55       5.639  24.616  88.049  1.00 46.43           C  
ATOM    446  CD  ARG A  55       6.129  25.873  87.366  1.00 51.00           C  
ATOM    447  NE  ARG A  55       6.377  26.961  88.300  1.00 45.16           N  
ATOM    448  CZ  ARG A  55       6.888  28.135  87.945  1.00 43.87           C  
ATOM    449  NH1 ARG A  55       7.212  28.374  86.676  1.00 36.21           N  
ATOM    450  NH2 ARG A  55       7.065  29.070  88.855  1.00 23.63           N  
ATOM    451  N   ALA A  56       5.363  20.762  85.660  1.00 48.42           N  
ATOM    452  CA  ALA A  56       5.016  19.872  84.563  1.00 47.87           C  
ATOM    453  C   ALA A  56       4.305  18.672  85.176  1.00 51.36           C  
ATOM    454  O   ALA A  56       3.379  18.108  84.590  1.00 56.83           O  
ATOM    455  CB  ALA A  56       6.279  19.421  83.838  1.00 43.79           C  
ATOM    456  N   GLN A  57       4.746  18.300  86.374  1.00 50.83           N  
ATOM    457  CA  GLN A  57       4.179  17.178  87.115  1.00 52.92           C  
ATOM    458  C   GLN A  57       2.892  17.551  87.848  1.00 55.52           C  
ATOM    459  O   GLN A  57       2.294  16.705  88.515  1.00 55.35           O  
ATOM    460  CB  GLN A  57       5.203  16.649  88.131  1.00 52.82           C  
ATOM    461  CG  GLN A  57       6.148  15.564  87.610  1.00 59.89           C  
ATOM    462  CD  GLN A  57       6.912  15.969  86.358  1.00 69.79           C  
ATOM    463  OE1 GLN A  57       8.147  15.982  86.343  1.00 71.47           O  
ATOM    464  NE2 GLN A  57       6.180  16.293  85.293  1.00 70.75           N  
ATOM    465  N   ALA A  58       2.468  18.808  87.723  1.00 50.71           N  
ATOM    466  CA  ALA A  58       1.259  19.286  88.393  1.00 51.80           C  
ATOM    467  C   ALA A  58       1.302  18.855  89.858  1.00 53.23           C  
ATOM    468  O   ALA A  58       0.277  18.559  90.474  1.00 51.82           O  
ATOM    469  CB  ALA A  58       0.016  18.717  87.710  1.00 51.49           C  
ATOM    470  N   SER A  59       2.508  18.825  90.409  1.00 52.25           N  
ATOM    471  CA  SER A  59       2.704  18.415  91.788  1.00 56.44           C  
ATOM    472  C   SER A  59       3.466  19.458  92.583  1.00 58.86           C  
ATOM    473  O   SER A  59       4.362  19.118  93.354  1.00 64.78           O  
ATOM    474  CB  SER A  59       3.469  17.091  91.829  1.00 65.55           C  
ATOM    475  OG  SER A  59       4.722  17.209  91.174  1.00 72.18           O  
ATOM    476  N   GLU A  60       3.119  20.727  92.393  1.00 55.67           N  
ATOM    477  CA  GLU A  60       3.783  21.799  93.117  1.00 52.49           C  
ATOM    478  C   GLU A  60       2.789  22.522  94.015  1.00 47.00           C  
ATOM    479  O   GLU A  60       1.625  22.694  93.663  1.00 38.46           O  
ATOM    480  CB  GLU A  60       4.426  22.786  92.143  1.00 64.78           C  
ATOM    481  CG  GLU A  60       5.431  23.720  92.802  1.00 79.23           C  
ATOM    482  CD  GLU A  60       6.260  24.497  91.795  1.00 85.80           C  
ATOM    483  OE1 GLU A  60       5.695  25.375  91.102  1.00 91.40           O  
ATOM    484  OE2 GLU A  60       7.479  24.224  91.696  1.00 72.69           O  
ATOM    485  N   ASP A  61       3.254  22.945  95.183  1.00 44.93           N  
ATOM    486  CA  ASP A  61       2.384  23.633  96.120  1.00 47.26           C  
ATOM    487  C   ASP A  61       2.443  25.140  95.920  1.00 44.71           C  
ATOM    488  O   ASP A  61       3.429  25.789  96.278  1.00 40.17           O  
ATOM    489  CB  ASP A  61       2.765  23.274  97.559  1.00 42.89           C  
ATOM    490  CG  ASP A  61       1.690  23.659  98.554  1.00 53.68           C  
ATOM    491  OD1 ASP A  61       0.629  24.153  98.113  1.00 55.96           O  
ATOM    492  OD2 ASP A  61       1.901  23.462  99.770  1.00 48.92           O  
ATOM    493  N   PRO A  62       1.373  25.713  95.345  1.00 50.51           N  
ATOM    494  CA  PRO A  62       1.221  27.144  95.057  1.00 45.38           C  
ATOM    495  C   PRO A  62       1.528  28.057  96.243  1.00 58.48           C  
ATOM    496  O   PRO A  62       1.960  29.201  96.064  1.00 58.63           O  
ATOM    497  CB  PRO A  62      -0.239  27.245  94.624  1.00 51.98           C  
ATOM    498  CG  PRO A  62      -0.483  25.923  93.969  1.00 50.61           C  
ATOM    499  CD  PRO A  62       0.168  24.969  94.931  1.00 44.07           C  
ATOM    500  N   ARG A  63       1.310  27.541  97.451  1.00 58.98           N  
ATOM    501  CA  ARG A  63       1.533  28.304  98.676  1.00 51.76           C  
ATOM    502  C   ARG A  63       2.967  28.239  99.205  1.00 44.93           C  
ATOM    503  O   ARG A  63       3.335  28.999 100.100  1.00 45.71           O  
ATOM    504  CB  ARG A  63       0.557  27.817  99.756  1.00 58.67           C  
ATOM    505  CG  ARG A  63       0.605  26.313  99.986  1.00 61.39           C  
ATOM    506  CD  ARG A  63      -0.594  25.809 100.774  1.00 70.97           C  
ATOM    507  NE  ARG A  63      -0.539  24.361 100.986  1.00 82.12           N  
ATOM    508  CZ  ARG A  63       0.259  23.752 101.861  1.00 79.05           C  
ATOM    509  NH1 ARG A  63       1.080  24.459 102.627  1.00 75.17           N  
ATOM    510  NH2 ARG A  63       0.243  22.429 101.959  1.00 74.10           N  
ATOM    511  N   LYS A  64       3.779  27.346  98.650  1.00 34.99           N  
ATOM    512  CA  LYS A  64       5.157  27.202  99.110  1.00 43.07           C  
ATOM    513  C   LYS A  64       6.177  27.511  98.033  1.00 40.39           C  
ATOM    514  O   LYS A  64       7.374  27.558  98.306  1.00 50.95           O  
ATOM    515  CB  LYS A  64       5.400  25.776  99.615  1.00 48.93           C  
ATOM    516  CG  LYS A  64       4.732  25.435 100.942  1.00 61.25           C  
ATOM    517  CD  LYS A  64       4.739  23.930 101.180  1.00 65.56           C  
ATOM    518  CE  LYS A  64       6.138  23.342 101.049  1.00 76.36           C  
ATOM    519  NZ  LYS A  64       6.119  21.854 101.044  1.00 75.65           N  
ATOM    520  N   VAL A  65       5.705  27.724  96.814  1.00 28.78           N  
ATOM    521  CA  VAL A  65       6.590  27.995  95.693  1.00 35.61           C  
ATOM    522  C   VAL A  65       7.688  29.034  95.982  1.00 45.54           C  
ATOM    523  O   VAL A  65       8.878  28.706  95.928  1.00 47.60           O  
ATOM    524  CB  VAL A  65       5.772  28.409  94.442  1.00 31.59           C  
ATOM    525  CG1 VAL A  65       5.169  29.796  94.628  1.00 22.75           C  
ATOM    526  CG2 VAL A  65       6.652  28.334  93.207  1.00 43.63           C  
ATOM    527  N   LEU A  66       7.303  30.271  96.294  1.00 37.32           N  
ATOM    528  CA  LEU A  66       8.282  31.321  96.581  1.00 31.56           C  
ATOM    529  C   LEU A  66       9.303  30.914  97.651  1.00 32.86           C  
ATOM    530  O   LEU A  66      10.506  30.898  97.389  1.00 36.04           O  
ATOM    531  CB  LEU A  66       7.574  32.614  97.014  1.00 21.31           C  
ATOM    532  CG  LEU A  66       8.474  33.767  97.472  1.00 24.55           C  
ATOM    533  CD1 LEU A  66       9.491  34.128  96.379  1.00 10.76           C  
ATOM    534  CD2 LEU A  66       7.602  34.962  97.831  1.00 23.59           C  
ATOM    535  N   THR A  67       8.829  30.589  98.852  1.00 25.15           N  
ATOM    536  CA  THR A  67       9.730  30.199  99.930  1.00 32.45           C  
ATOM    537  C   THR A  67      10.550  28.978  99.552  1.00 27.61           C  
ATOM    538  O   THR A  67      11.710  28.855  99.944  1.00 33.52           O  
ATOM    539  CB  THR A  67       8.976  29.886 101.242  1.00 38.28           C  
ATOM    540  OG1 THR A  67       7.956  28.911 100.991  1.00 53.15           O  
ATOM    541  CG2 THR A  67       8.356  31.144 101.810  1.00 30.75           C  
ATOM    542  N   GLY A  68       9.945  28.069  98.801  1.00 25.60           N  
ATOM    543  CA  GLY A  68      10.664  26.879  98.379  1.00 33.46           C  
ATOM    544  C   GLY A  68      11.871  27.231  97.521  1.00 29.51           C  
ATOM    545  O   GLY A  68      12.978  26.757  97.770  1.00 36.61           O  
ATOM    546  N   SER A  69      11.655  28.074  96.516  1.00 25.78           N  
ATOM    547  CA  SER A  69      12.720  28.492  95.603  1.00 25.73           C  
ATOM    548  C   SER A  69      13.815  29.246  96.326  1.00 27.57           C  
ATOM    549  O   SER A  69      14.980  29.139  95.968  1.00 39.56           O  
ATOM    550  CB  SER A  69      12.160  29.378  94.489  1.00 28.98           C  
ATOM    551  OG  SER A  69      11.783  30.650  94.990  1.00 26.95           O  
ATOM    552  N   GLN A  70      13.450  30.010  97.347  1.00 29.36           N  
ATOM    553  CA  GLN A  70      14.445  30.765  98.097  1.00 27.62           C  
ATOM    554  C   GLN A  70      15.236  29.863  99.043  1.00 30.44           C  
ATOM    555  O   GLN A  70      16.443  30.037  99.212  1.00 32.73           O  
ATOM    556  CB  GLN A  70      13.774  31.893  98.890  1.00 31.39           C  
ATOM    557  CG  GLN A  70      12.951  32.846  98.041  1.00 33.66           C  
ATOM    558  CD  GLN A  70      12.312  33.969  98.846  1.00 40.24           C  
ATOM    559  OE1 GLN A  70      11.651  33.730  99.856  1.00 37.98           O  
ATOM    560  NE2 GLN A  70      12.496  35.202  98.387  1.00 36.13           N  
ATOM    561  N   GLU A  71      14.557  28.902  99.659  1.00 29.72           N  
ATOM    562  CA  GLU A  71      15.202  27.975 100.582  1.00 33.98           C  
ATOM    563  C   GLU A  71      16.072  26.980  99.819  1.00 32.91           C  
ATOM    564  O   GLU A  71      17.107  26.535 100.318  1.00 30.06           O  
ATOM    565  CB  GLU A  71      14.144  27.231 101.401  1.00 37.77           C  
ATOM    566  CG  GLU A  71      13.585  28.022 102.580  1.00 54.80           C  
ATOM    567  CD  GLU A  71      12.097  27.781 102.811  1.00 62.13           C  
ATOM    568  OE1 GLU A  71      11.624  26.647 102.580  1.00 65.14           O  
ATOM    569  OE2 GLU A  71      11.397  28.727 103.236  1.00 72.63           O  
ATOM    570  N   ALA A  72      15.638  26.634  98.611  1.00 24.52           N  
ATOM    571  CA  ALA A  72      16.374  25.714  97.756  1.00 29.53           C  
ATOM    572  C   ALA A  72      17.685  26.359  97.284  1.00 36.99           C  
ATOM    573  O   ALA A  72      18.728  25.705  97.211  1.00 35.14           O  
ATOM    574  CB  ALA A  72      15.518  25.331  96.550  1.00 14.97           C  
ATOM    575  N   LEU A  73      17.618  27.650  96.973  1.00 35.25           N  
ATOM    576  CA  LEU A  73      18.784  28.397  96.501  1.00 34.78           C  
ATOM    577  C   LEU A  73      19.738  28.636  97.667  1.00 27.42           C  
ATOM    578  O   LEU A  73      20.948  28.469  97.537  1.00 30.70           O  
ATOM    579  CB  LEU A  73      18.332  29.732  95.896  1.00 35.26           C  
ATOM    580  CG  LEU A  73      19.263  30.522  94.975  1.00 36.73           C  
ATOM    581  CD1 LEU A  73      19.627  29.693  93.748  1.00 31.32           C  
ATOM    582  CD2 LEU A  73      18.558  31.803  94.550  1.00 36.26           C  
ATOM    583  N   ALA A  74      19.181  29.011  98.815  1.00 25.48           N  
ATOM    584  CA  ALA A  74      19.982  29.269 100.001  1.00 22.55           C  
ATOM    585  C   ALA A  74      20.738  28.008 100.425  1.00 31.04           C  
ATOM    586  O   ALA A  74      21.884  28.084 100.869  1.00 25.11           O  
ATOM    587  CB  ALA A  74      19.094  29.758 101.135  1.00 32.33           C  
ATOM    588  N   GLY A  75      20.088  26.852 100.285  1.00 28.04           N  
ATOM    589  CA  GLY A  75      20.718  25.590 100.643  1.00 31.86           C  
ATOM    590  C   GLY A  75      21.820  25.158  99.680  1.00 27.88           C  
ATOM    591  O   GLY A  75      22.830  24.586 100.094  1.00 25.80           O  
ATOM    592  N   LYS A  76      21.628  25.421  98.390  1.00 29.70           N  
ATOM    593  CA  LYS A  76      22.628  25.067  97.390  1.00 31.11           C  
ATOM    594  C   LYS A  76      23.896  25.886  97.594  1.00 35.88           C  
ATOM    595  O   LYS A  76      25.006  25.382  97.418  1.00 39.89           O  
ATOM    596  CB  LYS A  76      22.090  25.315  95.979  1.00 28.26           C  
ATOM    597  CG  LYS A  76      21.073  24.281  95.517  1.00 34.71           C  
ATOM    598  CD  LYS A  76      20.428  24.668  94.195  1.00 34.60           C  
ATOM    599  CE  LYS A  76      19.513  23.558  93.686  1.00 35.75           C  
ATOM    600  NZ  LYS A  76      20.276  22.296  93.444  1.00 27.28           N  
ATOM    601  N   LEU A  77      23.728  27.146  97.985  1.00 35.92           N  
ATOM    602  CA  LEU A  77      24.866  28.036  98.183  1.00 31.59           C  
ATOM    603  C   LEU A  77      25.394  28.056  99.612  1.00 20.39           C  
ATOM    604  O   LEU A  77      26.479  28.575  99.878  1.00 25.80           O  
ATOM    605  CB  LEU A  77      24.480  29.453  97.744  1.00 35.20           C  
ATOM    606  CG  LEU A  77      24.015  29.580  96.285  1.00 33.41           C  
ATOM    607  CD1 LEU A  77      23.568  31.006  96.005  1.00 32.15           C  
ATOM    608  CD2 LEU A  77      25.149  29.181  95.344  1.00 24.58           C  
ATOM    609  N   LYS A  78      24.622  27.480 100.525  1.00 27.95           N  
ATOM    610  CA  LYS A  78      24.984  27.440 101.934  1.00 28.67           C  
ATOM    611  C   LYS A  78      24.989  28.836 102.554  1.00 29.74           C  
ATOM    612  O   LYS A  78      25.919  29.207 103.282  1.00 28.82           O  
ATOM    613  CB  LYS A  78      26.349  26.765 102.123  1.00 32.38           C  
ATOM    614  CG  LYS A  78      26.303  25.256 101.910  1.00 38.60           C  
ATOM    615  CD  LYS A  78      27.612  24.578 102.286  1.00 52.63           C  
ATOM    616  CE  LYS A  78      27.524  23.062 102.118  1.00 57.66           C  
ATOM    617  NZ  LYS A  78      28.775  22.368 102.546  1.00 58.21           N  
ATOM    618  N   VAL A  79      23.947  29.612 102.257  1.00 32.50           N  
ATOM    619  CA  VAL A  79      23.816  30.961 102.809  1.00 28.54           C  
ATOM    620  C   VAL A  79      22.492  31.088 103.536  1.00 29.40           C  
ATOM    621  O   VAL A  79      21.582  30.281 103.346  1.00 25.69           O  
ATOM    622  CB  VAL A  79      23.839  32.058 101.716  1.00 25.00           C  
ATOM    623  CG1 VAL A  79      25.175  32.051 100.983  1.00 16.98           C  
ATOM    624  CG2 VAL A  79      22.684  31.854 100.753  1.00 25.56           C  
ATOM    625  N   ASP A  80      22.382  32.108 104.373  1.00 28.41           N  
ATOM    626  CA  ASP A  80      21.141  32.335 105.089  1.00 31.69           C  
ATOM    627  C   ASP A  80      20.118  32.757 104.027  1.00 28.26           C  
ATOM    628  O   ASP A  80      20.458  33.447 103.073  1.00 26.88           O  
ATOM    629  CB  ASP A  80      21.345  33.440 106.132  1.00 42.34           C  
ATOM    630  CG  ASP A  80      20.217  33.511 107.141  1.00 48.83           C  
ATOM    631  OD1 ASP A  80      19.060  33.765 106.738  1.00 54.89           O  
ATOM    632  OD2 ASP A  80      20.491  33.314 108.344  1.00 54.68           O  
ATOM    633  N   VAL A  81      18.871  32.320 104.177  1.00 30.28           N  
ATOM    634  CA  VAL A  81      17.831  32.660 103.215  1.00 33.47           C  
ATOM    635  C   VAL A  81      17.589  34.180 103.194  1.00 30.67           C  
ATOM    636  O   VAL A  81      16.960  34.707 102.280  1.00 35.04           O  
ATOM    637  CB  VAL A  81      16.517  31.896 103.542  1.00 31.23           C  
ATOM    638  CG1 VAL A  81      15.979  32.333 104.898  1.00 43.09           C  
ATOM    639  CG2 VAL A  81      15.495  32.105 102.443  1.00 31.02           C  
ATOM    640  N   GLU A  82      18.109  34.872 104.203  1.00 36.45           N  
ATOM    641  CA  GLU A  82      17.978  36.319 104.315  1.00 26.30           C  
ATOM    642  C   GLU A  82      18.789  36.977 103.191  1.00 23.56           C  
ATOM    643  O   GLU A  82      18.373  37.977 102.621  1.00 17.48           O  
ATOM    644  CB  GLU A  82      18.489  36.776 105.686  1.00 23.20           C  
ATOM    645  CG  GLU A  82      18.195  38.233 106.054  1.00 27.05           C  
ATOM    646  CD  GLU A  82      16.704  38.555 106.085  1.00 34.55           C  
ATOM    647  OE1 GLU A  82      15.911  37.722 106.585  1.00 23.92           O  
ATOM    648  OE2 GLU A  82      16.326  39.652 105.620  1.00 27.57           O  
ATOM    649  N   LEU A  83      19.947  36.412 102.867  1.00 26.36           N  
ATOM    650  CA  LEU A  83      20.760  36.975 101.800  1.00 19.83           C  
ATOM    651  C   LEU A  83      20.040  36.855 100.458  1.00 26.69           C  
ATOM    652  O   LEU A  83      20.200  37.707  99.578  1.00 29.68           O  
ATOM    653  CB  LEU A  83      22.116  36.282 101.749  1.00 29.50           C  
ATOM    654  CG  LEU A  83      23.232  36.993 102.523  1.00 29.20           C  
ATOM    655  CD1 LEU A  83      22.755  37.394 103.901  1.00 43.53           C  
ATOM    656  CD2 LEU A  83      24.438  36.077 102.613  1.00 25.96           C  
ATOM    657  N   VAL A  84      19.232  35.811 100.305  1.00 18.64           N  
ATOM    658  CA  VAL A  84      18.485  35.622  99.066  1.00 25.15           C  
ATOM    659  C   VAL A  84      17.401  36.688  98.932  1.00 17.94           C  
ATOM    660  O   VAL A  84      17.176  37.230  97.855  1.00 25.77           O  
ATOM    661  CB  VAL A  84      17.821  34.231  99.013  1.00 22.96           C  
ATOM    662  CG1 VAL A  84      16.836  34.166  97.846  1.00 18.36           C  
ATOM    663  CG2 VAL A  84      18.889  33.158  98.859  1.00 20.32           C  
ATOM    664  N   LYS A  85      16.728  36.977 100.038  1.00 26.72           N  
ATOM    665  CA  LYS A  85      15.677  37.979 100.056  1.00 22.24           C  
ATOM    666  C   LYS A  85      16.291  39.355  99.823  1.00 26.55           C  
ATOM    667  O   LYS A  85      15.745  40.146  99.063  1.00 27.02           O  
ATOM    668  CB  LYS A  85      14.935  37.943 101.398  1.00 20.55           C  
ATOM    669  CG  LYS A  85      14.011  36.732 101.584  1.00 17.28           C  
ATOM    670  CD  LYS A  85      13.911  36.357 103.053  1.00 26.31           C  
ATOM    671  CE  LYS A  85      12.890  35.249 103.321  1.00 40.20           C  
ATOM    672  NZ  LYS A  85      11.464  35.712 103.226  1.00 38.15           N  
ATOM    673  N   ARG A  86      17.422  39.644 100.473  1.00 13.69           N  
ATOM    674  CA  ARG A  86      18.064  40.938 100.275  1.00 22.13           C  
ATOM    675  C   ARG A  86      18.450  41.136  98.816  1.00 25.82           C  
ATOM    676  O   ARG A  86      18.260  42.218  98.259  1.00 29.42           O  
ATOM    677  CB  ARG A  86      19.322  41.076 101.131  1.00 23.44           C  
ATOM    678  CG  ARG A  86      19.068  41.293 102.603  1.00 28.21           C  
ATOM    679  CD  ARG A  86      20.360  41.669 103.327  1.00 29.61           C  
ATOM    680  NE  ARG A  86      20.898  42.942 102.849  1.00 27.36           N  
ATOM    681  CZ  ARG A  86      21.989  43.527 103.337  1.00 38.92           C  
ATOM    682  NH1 ARG A  86      22.671  42.954 104.321  1.00 42.62           N  
ATOM    683  NH2 ARG A  86      22.393  44.691 102.850  1.00 23.75           N  
ATOM    684  N   ALA A  87      18.994  40.089  98.201  1.00 23.44           N  
ATOM    685  CA  ALA A  87      19.416  40.161  96.808  1.00 20.76           C  
ATOM    686  C   ALA A  87      18.267  40.512  95.856  1.00 17.53           C  
ATOM    687  O   ALA A  87      18.481  41.219  94.864  1.00 21.62           O  
ATOM    688  CB  ALA A  87      20.098  38.830  96.384  1.00 14.82           C  
ATOM    689  N   THR A  88      17.055  40.031  96.141  1.00 16.77           N  
ATOM    690  CA  THR A  88      15.918  40.348  95.276  1.00 15.29           C  
ATOM    691  C   THR A  88      15.524  41.811  95.447  1.00 24.64           C  
ATOM    692  O   THR A  88      15.070  42.461  94.506  1.00 25.74           O  
ATOM    693  CB  THR A  88      14.679  39.477  95.579  1.00 24.67           C  
ATOM    694  OG1 THR A  88      14.110  39.865  96.833  1.00 18.12           O  
ATOM    695  CG2 THR A  88      15.058  38.002  95.627  1.00 23.19           C  
ATOM    696  N   ALA A  89      15.687  42.336  96.655  1.00 30.28           N  
ATOM    697  CA  ALA A  89      15.351  43.733  96.889  1.00 24.07           C  
ATOM    698  C   ALA A  89      16.409  44.587  96.192  1.00 25.53           C  
ATOM    699  O   ALA A  89      16.087  45.597  95.553  1.00 22.09           O  
ATOM    700  CB  ALA A  89      15.317  44.032  98.391  1.00 20.58           C  
ATOM    701  N   ARG A  90      17.671  44.167  96.292  1.00 21.96           N  
ATOM    702  CA  ARG A  90      18.768  44.913  95.668  1.00 28.34           C  
ATOM    703  C   ARG A  90      18.726  44.868  94.155  1.00 22.52           C  
ATOM    704  O   ARG A  90      19.073  45.846  93.493  1.00 26.13           O  
ATOM    705  CB  ARG A  90      20.124  44.402  96.157  1.00 15.67           C  
ATOM    706  CG  ARG A  90      20.372  44.699  97.628  1.00 20.11           C  
ATOM    707  CD  ARG A  90      21.648  44.061  98.156  1.00 27.35           C  
ATOM    708  NE  ARG A  90      22.845  44.733  97.669  1.00 32.27           N  
ATOM    709  CZ  ARG A  90      23.930  44.953  98.408  1.00 48.51           C  
ATOM    710  NH1 ARG A  90      23.973  44.555  99.674  1.00 35.99           N  
ATOM    711  NH2 ARG A  90      24.971  45.589  97.885  1.00 55.74           N  
ATOM    712  N   ALA A  91      18.299  43.740  93.601  1.00 19.13           N  
ATOM    713  CA  ALA A  91      18.219  43.612  92.150  1.00 23.60           C  
ATOM    714  C   ALA A  91      17.128  44.537  91.621  1.00 23.58           C  
ATOM    715  O   ALA A  91      17.322  45.260  90.631  1.00 23.46           O  
ATOM    716  CB  ALA A  91      17.915  42.173  91.757  1.00 17.19           C  
ATOM    717  N   ILE A  92      15.981  44.502  92.291  1.00 21.01           N  
ATOM    718  CA  ILE A  92      14.849  45.329  91.911  1.00 22.37           C  
ATOM    719  C   ILE A  92      15.281  46.788  91.913  1.00 16.37           C  
ATOM    720  O   ILE A  92      14.824  47.578  91.091  1.00 19.16           O  
ATOM    721  CB  ILE A  92      13.669  45.127  92.884  1.00 22.16           C  
ATOM    722  CG1 ILE A  92      13.115  43.712  92.721  1.00 21.54           C  
ATOM    723  CG2 ILE A  92      12.584  46.158  92.622  1.00 34.40           C  
ATOM    724  CD1 ILE A  92      12.703  43.380  91.310  1.00 26.13           C  
ATOM    725  N   LEU A  93      16.179  47.130  92.835  1.00 17.39           N  
ATOM    726  CA  LEU A  93      16.678  48.487  92.940  1.00 20.72           C  
ATOM    727  C   LEU A  93      17.771  48.813  91.912  1.00 31.61           C  
ATOM    728  O   LEU A  93      18.016  49.983  91.624  1.00 30.71           O  
ATOM    729  CB  LEU A  93      17.213  48.747  94.347  1.00 26.46           C  
ATOM    730  CG  LEU A  93      16.211  48.768  95.510  1.00 29.72           C  
ATOM    731  CD1 LEU A  93      16.960  48.972  96.812  1.00 28.32           C  
ATOM    732  CD2 LEU A  93      15.200  49.882  95.315  1.00 26.42           C  
ATOM    733  N   ASN A  94      18.417  47.797  91.349  1.00 20.00           N  
ATOM    734  CA  ASN A  94      19.477  48.063  90.388  1.00 30.48           C  
ATOM    735  C   ASN A  94      19.110  47.877  88.913  1.00 32.44           C  
ATOM    736  O   ASN A  94      19.953  48.084  88.046  1.00 38.18           O  
ATOM    737  CB  ASN A  94      20.717  47.223  90.721  1.00 29.66           C  
ATOM    738  CG  ASN A  94      22.002  47.869  90.229  1.00 42.47           C  
ATOM    739  OD1 ASN A  94      22.322  48.994  90.611  1.00 36.04           O  
ATOM    740  ND2 ASN A  94      22.743  47.164  89.379  1.00 37.76           N  
ATOM    741  N   VAL A  95      17.871  47.480  88.623  1.00 27.06           N  
ATOM    742  CA  VAL A  95      17.436  47.309  87.235  1.00 19.14           C  
ATOM    743  C   VAL A  95      16.752  48.578  86.735  1.00 26.24           C  
ATOM    744  O   VAL A  95      16.428  49.471  87.519  1.00 26.64           O  
ATOM    745  CB  VAL A  95      16.425  46.149  87.073  1.00 27.85           C  
ATOM    746  CG1 VAL A  95      17.125  44.810  87.200  1.00 20.65           C  
ATOM    747  CG2 VAL A  95      15.330  46.280  88.111  1.00 28.91           C  
ATOM    748  N   ASP A  96      16.542  48.662  85.426  1.00 24.05           N  
ATOM    749  CA  ASP A  96      15.876  49.819  84.850  1.00 24.69           C  
ATOM    750  C   ASP A  96      14.978  49.455  83.677  1.00 18.19           C  
ATOM    751  O   ASP A  96      14.655  48.289  83.461  1.00 19.88           O  
ATOM    752  CB  ASP A  96      16.888  50.906  84.427  1.00 23.31           C  
ATOM    753  CG  ASP A  96      17.963  50.393  83.493  1.00 24.40           C  
ATOM    754  OD1 ASP A  96      17.644  49.695  82.507  1.00 27.98           O  
ATOM    755  OD2 ASP A  96      19.142  50.703  83.743  1.00 38.43           O  
ATOM    756  N   GLU A  97      14.576  50.471  82.926  1.00 23.98           N  
ATOM    757  CA  GLU A  97      13.690  50.299  81.788  1.00 30.17           C  
ATOM    758  C   GLU A  97      14.207  49.369  80.699  1.00 29.34           C  
ATOM    759  O   GLU A  97      13.427  48.884  79.887  1.00 30.34           O  
ATOM    760  CB  GLU A  97      13.361  51.668  81.195  1.00 40.43           C  
ATOM    761  CG  GLU A  97      12.320  51.632  80.108  1.00 61.21           C  
ATOM    762  CD  GLU A  97      11.522  52.910  80.049  1.00 68.42           C  
ATOM    763  OE1 GLU A  97      12.143  53.986  79.920  1.00 77.84           O  
ATOM    764  OE2 GLU A  97      10.277  52.836  80.136  1.00 76.57           O  
ATOM    765  N   SER A  98      15.511  49.105  80.682  1.00 31.15           N  
ATOM    766  CA  SER A  98      16.078  48.212  79.671  1.00 32.15           C  
ATOM    767  C   SER A  98      15.487  46.818  79.853  1.00 35.80           C  
ATOM    768  O   SER A  98      15.746  45.911  79.069  1.00 28.61           O  
ATOM    769  CB  SER A  98      17.603  48.144  79.799  1.00 30.81           C  
ATOM    770  OG  SER A  98      17.996  47.571  81.038  1.00 25.28           O  
ATOM    771  N   LEU A  99      14.676  46.673  80.896  1.00 32.61           N  
ATOM    772  CA  LEU A  99      14.029  45.414  81.230  1.00 27.92           C  
ATOM    773  C   LEU A  99      12.778  45.205  80.377  1.00 28.10           C  
ATOM    774  O   LEU A  99      12.324  44.077  80.188  1.00 22.04           O  
ATOM    775  CB  LEU A  99      13.672  45.425  82.723  1.00 26.36           C  
ATOM    776  CG  LEU A  99      13.811  44.142  83.547  1.00 28.34           C  
ATOM    777  CD1 LEU A  99      15.110  43.428  83.227  1.00 22.45           C  
ATOM    778  CD2 LEU A  99      13.755  44.500  85.024  1.00 20.53           C  
ATOM    779  N   VAL A 100      12.223  46.296  79.856  1.00 34.04           N  
ATOM    780  CA  VAL A 100      11.024  46.213  79.023  1.00 26.61           C  
ATOM    781  C   VAL A 100      11.402  45.693  77.642  1.00 27.14           C  
ATOM    782  O   VAL A 100      12.280  46.247  76.987  1.00 22.47           O  
ATOM    783  CB  VAL A 100      10.352  47.595  78.858  1.00 29.98           C  
ATOM    784  CG1 VAL A 100       9.070  47.456  78.062  1.00 30.08           C  
ATOM    785  CG2 VAL A 100      10.060  48.201  80.211  1.00 28.18           C  
ATOM    786  N   LEU A 101      10.742  44.625  77.206  1.00 26.48           N  
ATOM    787  CA  LEU A 101      11.015  44.041  75.899  1.00 30.20           C  
ATOM    788  C   LEU A 101      10.457  44.915  74.779  1.00 30.49           C  
ATOM    789  O   LEU A 101       9.342  45.432  74.882  1.00 23.22           O  
ATOM    790  CB  LEU A 101      10.410  42.641  75.817  1.00 21.81           C  
ATOM    791  CG  LEU A 101      11.058  41.555  76.678  1.00 30.69           C  
ATOM    792  CD1 LEU A 101      10.180  40.308  76.665  1.00 23.98           C  
ATOM    793  CD2 LEU A 101      12.455  41.243  76.153  1.00 13.33           C  
ATOM    794  N   GLU A 102      11.223  45.055  73.698  1.00 32.28           N  
ATOM    795  CA  GLU A 102      10.811  45.895  72.575  1.00 31.88           C  
ATOM    796  C   GLU A 102       9.404  45.631  72.060  1.00 29.64           C  
ATOM    797  O   GLU A 102       9.049  44.496  71.742  1.00 25.99           O  
ATOM    798  CB  GLU A 102      11.782  45.761  71.403  1.00 39.70           C  
ATOM    799  CG  GLU A 102      11.859  47.036  70.579  1.00 57.63           C  
ATOM    800  CD  GLU A 102      12.032  46.771  69.107  1.00 73.45           C  
ATOM    801  OE1 GLU A 102      12.871  45.916  68.754  1.00 78.65           O  
ATOM    802  OE2 GLU A 102      11.333  47.425  68.302  1.00 81.41           O  
ATOM    803  N   GLY A 103       8.617  46.703  71.969  1.00 28.83           N  
ATOM    804  CA  GLY A 103       7.252  46.597  71.488  1.00 27.74           C  
ATOM    805  C   GLY A 103       6.221  46.273  72.555  1.00 28.90           C  
ATOM    806  O   GLY A 103       5.033  46.207  72.259  1.00 32.71           O  
ATOM    807  N   THR A 104       6.655  46.077  73.795  1.00 24.39           N  
ATOM    808  CA  THR A 104       5.708  45.743  74.852  1.00 21.62           C  
ATOM    809  C   THR A 104       4.649  46.821  75.087  1.00 21.84           C  
ATOM    810  O   THR A 104       3.456  46.526  75.092  1.00 21.57           O  
ATOM    811  CB  THR A 104       6.418  45.449  76.192  1.00 19.12           C  
ATOM    812  OG1 THR A 104       7.251  44.288  76.057  1.00 22.29           O  
ATOM    813  CG2 THR A 104       5.380  45.189  77.285  1.00 21.11           C  
ATOM    814  N   LYS A 105       5.073  48.067  75.274  1.00 19.53           N  
ATOM    815  CA  LYS A 105       4.117  49.139  75.519  1.00 30.06           C  
ATOM    816  C   LYS A 105       3.136  49.310  74.369  1.00 30.74           C  
ATOM    817  O   LYS A 105       1.931  49.433  74.592  1.00 30.07           O  
ATOM    818  CB  LYS A 105       4.829  50.465  75.792  1.00 27.08           C  
ATOM    819  CG  LYS A 105       3.850  51.607  76.051  1.00 44.02           C  
ATOM    820  CD  LYS A 105       4.490  52.775  76.785  1.00 45.26           C  
ATOM    821  CE  LYS A 105       4.963  52.348  78.169  1.00 60.44           C  
ATOM    822  NZ  LYS A 105       5.491  53.491  78.967  1.00 69.00           N  
ATOM    823  N   GLU A 106       3.655  49.318  73.144  1.00 28.75           N  
ATOM    824  CA  GLU A 106       2.815  49.458  71.959  1.00 33.74           C  
ATOM    825  C   GLU A 106       1.812  48.321  71.894  1.00 33.90           C  
ATOM    826  O   GLU A 106       0.624  48.544  71.655  1.00 30.48           O  
ATOM    827  CB  GLU A 106       3.656  49.422  70.684  1.00 44.09           C  
ATOM    828  CG  GLU A 106       4.558  50.611  70.464  1.00 52.15           C  
ATOM    829  CD  GLU A 106       5.335  50.489  69.169  1.00 60.07           C  
ATOM    830  OE1 GLU A 106       4.695  50.354  68.103  1.00 51.46           O  
ATOM    831  OE2 GLU A 106       6.584  50.520  69.221  1.00 66.69           O  
ATOM    832  N   ALA A 107       2.300  47.097  72.099  1.00 28.34           N  
ATOM    833  CA  ALA A 107       1.438  45.919  72.059  1.00 27.18           C  
ATOM    834  C   ALA A 107       0.307  46.071  73.066  1.00 26.65           C  
ATOM    835  O   ALA A 107      -0.860  45.852  72.741  1.00 24.11           O  
ATOM    836  CB  ALA A 107       2.249  44.650  72.362  1.00 21.84           C  
ATOM    837  N   LEU A 108       0.655  46.451  74.292  1.00 27.68           N  
ATOM    838  CA  LEU A 108      -0.352  46.625  75.327  1.00 25.98           C  
ATOM    839  C   LEU A 108      -1.316  47.728  74.903  1.00 28.64           C  
ATOM    840  O   LEU A 108      -2.534  47.540  74.940  1.00 34.58           O  
ATOM    841  CB  LEU A 108       0.315  46.965  76.664  1.00 23.91           C  
ATOM    842  CG  LEU A 108       1.213  45.860  77.235  1.00 19.38           C  
ATOM    843  CD1 LEU A 108       1.959  46.367  78.460  1.00 19.40           C  
ATOM    844  CD2 LEU A 108       0.370  44.641  77.587  1.00 22.54           C  
ATOM    845  N   GLN A 109      -0.772  48.865  74.469  1.00 40.56           N  
ATOM    846  CA  GLN A 109      -1.606  49.989  74.039  1.00 37.43           C  
ATOM    847  C   GLN A 109      -2.584  49.574  72.940  1.00 32.26           C  
ATOM    848  O   GLN A 109      -3.754  49.947  72.976  1.00 33.69           O  
ATOM    849  CB  GLN A 109      -0.736  51.152  73.546  1.00 38.10           C  
ATOM    850  CG  GLN A 109       0.115  51.818  74.633  1.00 48.93           C  
ATOM    851  CD  GLN A 109       0.902  53.018  74.117  1.00 44.82           C  
ATOM    852  OE1 GLN A 109       0.327  53.991  73.637  1.00 52.34           O  
ATOM    853  NE2 GLN A 109       2.222  52.949  74.217  1.00 45.12           N  
ATOM    854  N   PHE A 110      -2.106  48.797  71.971  1.00 30.47           N  
ATOM    855  CA  PHE A 110      -2.952  48.345  70.868  1.00 28.50           C  
ATOM    856  C   PHE A 110      -4.153  47.549  71.349  1.00 30.56           C  
ATOM    857  O   PHE A 110      -5.248  47.673  70.799  1.00 23.36           O  
ATOM    858  CB  PHE A 110      -2.176  47.455  69.895  1.00 29.34           C  
ATOM    859  CG  PHE A 110      -3.044  46.852  68.822  1.00 32.35           C  
ATOM    860  CD1 PHE A 110      -3.441  47.606  67.723  1.00 32.99           C  
ATOM    861  CD2 PHE A 110      -3.525  45.557  68.945  1.00 26.36           C  
ATOM    862  CE1 PHE A 110      -4.304  47.079  66.770  1.00 19.89           C  
ATOM    863  CE2 PHE A 110      -4.390  45.026  67.991  1.00 28.21           C  
ATOM    864  CZ  PHE A 110      -4.778  45.789  66.908  1.00 22.76           C  
ATOM    865  N   VAL A 111      -3.929  46.705  72.352  1.00 24.58           N  
ATOM    866  CA  VAL A 111      -4.992  45.878  72.896  1.00 27.89           C  
ATOM    867  C   VAL A 111      -5.980  46.736  73.658  1.00 29.73           C  
ATOM    868  O   VAL A 111      -7.183  46.530  73.558  1.00 29.31           O  
ATOM    869  CB  VAL A 111      -4.443  44.797  73.850  1.00 33.36           C  
ATOM    870  CG1 VAL A 111      -5.587  44.187  74.643  1.00 33.93           C  
ATOM    871  CG2 VAL A 111      -3.713  43.713  73.055  1.00 30.16           C  
ATOM    872  N   LYS A 112      -5.468  47.697  74.422  1.00 28.66           N  
ATOM    873  CA  LYS A 112      -6.333  48.577  75.197  1.00 32.31           C  
ATOM    874  C   LYS A 112      -7.154  49.481  74.295  1.00 36.27           C  
ATOM    875  O   LYS A 112      -8.371  49.582  74.448  1.00 43.84           O  
ATOM    876  CB  LYS A 112      -5.518  49.434  76.168  1.00 30.22           C  
ATOM    877  CG  LYS A 112      -4.884  48.663  77.311  1.00 34.22           C  
ATOM    878  CD  LYS A 112      -5.893  47.771  78.010  1.00 36.97           C  
ATOM    879  CE  LYS A 112      -7.085  48.556  78.511  1.00 29.98           C  
ATOM    880  NZ  LYS A 112      -8.045  47.669  79.209  1.00 35.19           N  
ATOM    881  N   GLU A 113      -6.492  50.141  73.354  1.00 41.02           N  
ATOM    882  CA  GLU A 113      -7.191  51.030  72.438  1.00 36.82           C  
ATOM    883  C   GLU A 113      -8.214  50.261  71.614  1.00 33.47           C  
ATOM    884  O   GLU A 113      -9.142  50.842  71.057  1.00 37.76           O  
ATOM    885  CB  GLU A 113      -6.186  51.740  71.535  1.00 43.62           C  
ATOM    886  CG  GLU A 113      -5.595  52.984  72.184  1.00 62.78           C  
ATOM    887  CD  GLU A 113      -4.250  53.374  71.609  1.00 63.18           C  
ATOM    888  OE1 GLU A 113      -4.114  53.382  70.366  1.00 61.23           O  
ATOM    889  OE2 GLU A 113      -3.333  53.680  72.405  1.00 61.95           O  
ATOM    890  N   ARG A 114      -8.043  48.947  71.546  1.00 26.02           N  
ATOM    891  CA  ARG A 114      -8.966  48.106  70.808  1.00 36.09           C  
ATOM    892  C   ARG A 114     -10.204  47.880  71.676  1.00 31.83           C  
ATOM    893  O   ARG A 114     -11.206  47.340  71.221  1.00 38.85           O  
ATOM    894  CB  ARG A 114      -8.296  46.779  70.463  1.00 40.24           C  
ATOM    895  CG  ARG A 114      -8.941  46.033  69.316  1.00 44.70           C  
ATOM    896  CD  ARG A 114      -8.101  44.823  68.951  1.00 45.34           C  
ATOM    897  NE  ARG A 114      -8.700  44.032  67.887  1.00 46.05           N  
ATOM    898  CZ  ARG A 114      -8.848  44.456  66.637  1.00 46.20           C  
ATOM    899  NH1 ARG A 114      -8.438  45.670  66.293  1.00 50.48           N  
ATOM    900  NH2 ARG A 114      -9.409  43.663  65.733  1.00 36.78           N  
ATOM    901  N   GLY A 115     -10.119  48.308  72.932  1.00 33.90           N  
ATOM    902  CA  GLY A 115     -11.238  48.183  73.847  1.00 26.23           C  
ATOM    903  C   GLY A 115     -11.370  46.839  74.526  1.00 32.19           C  
ATOM    904  O   GLY A 115     -12.464  46.455  74.943  1.00 39.82           O  
ATOM    905  N   LEU A 116     -10.260  46.123  74.650  1.00 34.54           N  
ATOM    906  CA  LEU A 116     -10.271  44.808  75.279  1.00 32.86           C  
ATOM    907  C   LEU A 116      -9.746  44.867  76.711  1.00 31.10           C  
ATOM    908  O   LEU A 116      -9.004  45.775  77.072  1.00 27.69           O  
ATOM    909  CB  LEU A 116      -9.405  43.837  74.465  1.00 30.97           C  
ATOM    910  CG  LEU A 116      -9.716  43.687  72.969  1.00 38.16           C  
ATOM    911  CD1 LEU A 116      -8.648  42.827  72.316  1.00 27.61           C  
ATOM    912  CD2 LEU A 116     -11.091  43.064  72.771  1.00 28.29           C  
ATOM    913  N   LYS A 117     -10.145  43.896  77.525  1.00 32.72           N  
ATOM    914  CA  LYS A 117      -9.671  43.818  78.898  1.00 28.25           C  
ATOM    915  C   LYS A 117      -8.343  43.076  78.871  1.00 30.13           C  
ATOM    916  O   LYS A 117      -8.099  42.254  77.987  1.00 19.62           O  
ATOM    917  CB  LYS A 117     -10.660  43.045  79.771  1.00 33.49           C  
ATOM    918  CG  LYS A 117     -11.896  43.834  80.172  1.00 42.65           C  
ATOM    919  CD  LYS A 117     -11.551  44.931  81.170  1.00 45.21           C  
ATOM    920  CE  LYS A 117     -12.806  45.642  81.673  1.00 59.04           C  
ATOM    921  NZ  LYS A 117     -12.496  46.747  82.630  1.00 54.37           N  
ATOM    922  N   THR A 118      -7.483  43.365  79.836  1.00 22.62           N  
ATOM    923  CA  THR A 118      -6.190  42.707  79.906  1.00 22.40           C  
ATOM    924  C   THR A 118      -5.907  42.222  81.315  1.00 28.19           C  
ATOM    925  O   THR A 118      -6.483  42.706  82.289  1.00 23.19           O  
ATOM    926  CB  THR A 118      -5.039  43.650  79.516  1.00 29.11           C  
ATOM    927  OG1 THR A 118      -5.134  44.845  80.295  1.00 23.40           O  
ATOM    928  CG2 THR A 118      -5.083  43.991  78.034  1.00 23.90           C  
ATOM    929  N   ALA A 119      -4.998  41.267  81.416  1.00 24.09           N  
ATOM    930  CA  ALA A 119      -4.612  40.724  82.700  1.00 29.24           C  
ATOM    931  C   ALA A 119      -3.254  40.070  82.554  1.00 23.54           C  
ATOM    932  O   ALA A 119      -2.845  39.683  81.461  1.00 29.31           O  
ATOM    933  CB  ALA A 119      -5.646  39.704  83.182  1.00 12.76           C  
ATOM    934  N   VAL A 120      -2.550  39.984  83.668  1.00 17.25           N  
ATOM    935  CA  VAL A 120      -1.252  39.351  83.727  1.00 17.18           C  
ATOM    936  C   VAL A 120      -1.417  38.022  84.479  1.00 30.22           C  
ATOM    937  O   VAL A 120      -2.042  37.978  85.544  1.00 26.46           O  
ATOM    938  CB  VAL A 120      -0.238  40.249  84.493  1.00 19.57           C  
ATOM    939  CG1 VAL A 120       0.846  39.404  85.111  1.00 27.76           C  
ATOM    940  CG2 VAL A 120       0.374  41.270  83.545  1.00 21.34           C  
ATOM    941  N   ILE A 121      -0.881  36.942  83.915  1.00 22.45           N  
ATOM    942  CA  ILE A 121      -0.931  35.633  84.563  1.00 25.12           C  
ATOM    943  C   ILE A 121       0.516  35.135  84.613  1.00 24.07           C  
ATOM    944  O   ILE A 121       1.084  34.742  83.593  1.00 26.36           O  
ATOM    945  CB  ILE A 121      -1.784  34.609  83.764  1.00 22.72           C  
ATOM    946  CG1 ILE A 121      -3.129  35.216  83.373  1.00 25.39           C  
ATOM    947  CG2 ILE A 121      -2.052  33.390  84.618  1.00 21.21           C  
ATOM    948  CD1 ILE A 121      -4.031  34.247  82.622  1.00 28.47           C  
ATOM    949  N   GLY A 122       1.123  35.171  85.792  1.00 25.47           N  
ATOM    950  CA  GLY A 122       2.502  34.732  85.892  1.00 27.12           C  
ATOM    951  C   GLY A 122       2.834  33.879  87.096  1.00 31.51           C  
ATOM    952  O   GLY A 122       2.215  34.003  88.160  1.00 28.90           O  
ATOM    953  N   ASN A 123       3.812  32.997  86.927  1.00 29.01           N  
ATOM    954  CA  ASN A 123       4.244  32.142  88.024  1.00 30.94           C  
ATOM    955  C   ASN A 123       5.289  32.932  88.803  1.00 24.01           C  
ATOM    956  O   ASN A 123       5.880  33.869  88.265  1.00 22.30           O  
ATOM    957  CB  ASN A 123       4.855  30.836  87.493  1.00 33.62           C  
ATOM    958  CG  ASN A 123       3.825  29.924  86.839  1.00 34.94           C  
ATOM    959  OD1 ASN A 123       2.693  29.826  87.302  1.00 30.57           O  
ATOM    960  ND2 ASN A 123       4.224  29.235  85.772  1.00 34.11           N  
ATOM    961  N   VAL A 124       5.519  32.583  90.066  1.00 22.60           N  
ATOM    962  CA  VAL A 124       6.517  33.314  90.829  1.00 30.40           C  
ATOM    963  C   VAL A 124       7.616  32.379  91.298  1.00 28.72           C  
ATOM    964  O   VAL A 124       7.368  31.215  91.610  1.00 22.99           O  
ATOM    965  CB  VAL A 124       5.908  34.060  92.060  1.00 29.66           C  
ATOM    966  CG1 VAL A 124       4.547  34.616  91.705  1.00 32.41           C  
ATOM    967  CG2 VAL A 124       5.833  33.152  93.260  1.00 36.82           C  
HETATM  968  N   MSE A 125       8.828  32.919  91.359  1.00 22.33           N  
HETATM  969  CA  MSE A 125      10.012  32.173  91.768  1.00 27.90           C  
HETATM  970  C   MSE A 125      11.096  33.186  92.170  1.00 24.01           C  
HETATM  971  O   MSE A 125      11.309  34.165  91.467  1.00 24.93           O  
HETATM  972  CB  MSE A 125      10.484  31.340  90.572  1.00 31.04           C  
HETATM  973  CG  MSE A 125      11.729  30.509  90.770  1.00 46.69           C  
HETATM  974 SE   MSE A 125      12.413  29.854  89.061  1.00 45.70          SE  
HETATM  975  CE  MSE A 125      10.809  28.995  88.389  1.00 30.79           C  
ATOM    976  N   PHE A 126      11.762  32.957  93.296  1.00 22.40           N  
ATOM    977  CA  PHE A 126      12.845  33.834  93.771  1.00 23.27           C  
ATOM    978  C   PHE A 126      12.399  35.172  94.384  1.00 29.00           C  
ATOM    979  O   PHE A 126      12.776  35.492  95.519  1.00 30.72           O  
ATOM    980  CB  PHE A 126      13.858  34.079  92.640  1.00 11.92           C  
ATOM    981  CG  PHE A 126      14.456  32.817  92.084  1.00 17.38           C  
ATOM    982  CD1 PHE A 126      14.864  31.794  92.938  1.00 20.11           C  
ATOM    983  CD2 PHE A 126      14.646  32.662  90.716  1.00 20.31           C  
ATOM    984  CE1 PHE A 126      15.457  30.634  92.440  1.00 28.32           C  
ATOM    985  CE2 PHE A 126      15.240  31.507  90.205  1.00 31.15           C  
ATOM    986  CZ  PHE A 126      15.648  30.488  91.071  1.00 18.73           C  
ATOM    987  N   TRP A 127      11.625  35.957  93.634  1.00 23.59           N  
ATOM    988  CA  TRP A 127      11.105  37.234  94.132  1.00 20.63           C  
ATOM    989  C   TRP A 127       9.590  37.148  94.051  1.00 26.61           C  
ATOM    990  O   TRP A 127       9.049  36.592  93.099  1.00 31.55           O  
ATOM    991  CB  TRP A 127      11.639  38.419  93.305  1.00 21.98           C  
ATOM    992  CG  TRP A 127      11.386  38.337  91.824  1.00 25.50           C  
ATOM    993  CD1 TRP A 127      10.247  38.700  91.161  1.00 26.67           C  
ATOM    994  CD2 TRP A 127      12.293  37.849  90.826  1.00 23.01           C  
ATOM    995  NE1 TRP A 127      10.389  38.472  89.812  1.00 22.91           N  
ATOM    996  CE2 TRP A 127      11.636  37.949  89.579  1.00 24.78           C  
ATOM    997  CE3 TRP A 127      13.599  37.335  90.865  1.00 23.88           C  
ATOM    998  CZ2 TRP A 127      12.243  37.555  88.378  1.00 15.15           C  
ATOM    999  CZ3 TRP A 127      14.204  36.943  89.673  1.00 19.16           C  
ATOM   1000  CH2 TRP A 127      13.522  37.058  88.445  1.00 20.21           C  
ATOM   1001  N   PRO A 128       8.884  37.692  95.056  1.00 25.39           N  
ATOM   1002  CA  PRO A 128       7.417  37.667  95.107  1.00 21.63           C  
ATOM   1003  C   PRO A 128       6.728  38.325  93.918  1.00 24.98           C  
ATOM   1004  O   PRO A 128       7.322  39.143  93.218  1.00 18.55           O  
ATOM   1005  CB  PRO A 128       7.109  38.375  96.424  1.00 24.46           C  
ATOM   1006  CG  PRO A 128       8.235  39.389  96.513  1.00 18.98           C  
ATOM   1007  CD  PRO A 128       9.436  38.558  96.113  1.00 20.34           C  
ATOM   1008  N   GLY A 129       5.473  37.948  93.692  1.00 19.90           N  
ATOM   1009  CA  GLY A 129       4.721  38.524  92.598  1.00 22.44           C  
ATOM   1010  C   GLY A 129       4.644  40.029  92.737  1.00 30.04           C  
ATOM   1011  O   GLY A 129       4.537  40.745  91.743  1.00 33.57           O  
ATOM   1012  N   SER A 130       4.712  40.510  93.975  1.00 26.99           N  
ATOM   1013  CA  SER A 130       4.642  41.945  94.246  1.00 31.20           C  
ATOM   1014  C   SER A 130       5.809  42.733  93.639  1.00 19.80           C  
ATOM   1015  O   SER A 130       5.616  43.851  93.173  1.00 22.93           O  
ATOM   1016  CB  SER A 130       4.578  42.197  95.755  1.00 19.52           C  
ATOM   1017  OG  SER A 130       5.768  41.776  96.393  1.00 17.02           O  
ATOM   1018  N   TYR A 131       7.014  42.168  93.659  1.00 18.52           N  
ATOM   1019  CA  TYR A 131       8.170  42.850  93.064  1.00 22.61           C  
ATOM   1020  C   TYR A 131       7.948  42.958  91.560  1.00 24.19           C  
ATOM   1021  O   TYR A 131       8.272  43.973  90.933  1.00 22.14           O  
ATOM   1022  CB  TYR A 131       9.465  42.085  93.350  1.00 18.02           C  
ATOM   1023  CG  TYR A 131      10.073  42.402  94.697  1.00 10.30           C  
ATOM   1024  CD1 TYR A 131       9.400  43.208  95.611  1.00  8.70           C  
ATOM   1025  CD2 TYR A 131      11.310  41.877  95.068  1.00 18.12           C  
ATOM   1026  CE1 TYR A 131       9.935  43.481  96.859  1.00 12.53           C  
ATOM   1027  CE2 TYR A 131      11.862  42.140  96.323  1.00 15.87           C  
ATOM   1028  CZ  TYR A 131      11.163  42.943  97.216  1.00 24.69           C  
ATOM   1029  OH  TYR A 131      11.658  43.182  98.476  1.00 13.74           O  
ATOM   1030  N   THR A 132       7.389  41.902  90.981  1.00 25.83           N  
ATOM   1031  CA  THR A 132       7.095  41.906  89.561  1.00 23.93           C  
ATOM   1032  C   THR A 132       6.085  43.017  89.277  1.00 13.00           C  
ATOM   1033  O   THR A 132       6.240  43.762  88.311  1.00 19.54           O  
ATOM   1034  CB  THR A 132       6.555  40.535  89.107  1.00 24.27           C  
ATOM   1035  OG1 THR A 132       7.629  39.585  89.137  1.00 26.65           O  
ATOM   1036  CG2 THR A 132       5.974  40.609  87.680  1.00 16.95           C  
ATOM   1037  N   ARG A 133       5.060  43.138  90.124  1.00 19.73           N  
ATOM   1038  CA  ARG A 133       4.051  44.191  89.960  1.00 20.19           C  
ATOM   1039  C   ARG A 133       4.692  45.583  90.068  1.00 21.56           C  
ATOM   1040  O   ARG A 133       4.328  46.505  89.336  1.00 25.04           O  
ATOM   1041  CB  ARG A 133       2.946  44.077  91.014  1.00 16.61           C  
ATOM   1042  CG  ARG A 133       1.955  45.231  90.931  1.00 31.19           C  
ATOM   1043  CD  ARG A 133       0.830  45.158  91.958  1.00 28.09           C  
ATOM   1044  NE  ARG A 133      -0.005  43.975  91.788  1.00 26.03           N  
ATOM   1045  CZ  ARG A 133       0.165  42.844  92.462  1.00 22.42           C  
ATOM   1046  NH1 ARG A 133       1.135  42.745  93.358  1.00 22.02           N  
ATOM   1047  NH2 ARG A 133      -0.628  41.812  92.234  1.00 16.58           N  
ATOM   1048  N   LEU A 134       5.650  45.720  90.984  1.00 18.01           N  
ATOM   1049  CA  LEU A 134       6.349  46.990  91.198  1.00 20.23           C  
ATOM   1050  C   LEU A 134       7.053  47.484  89.929  1.00 28.84           C  
ATOM   1051  O   LEU A 134       6.964  48.666  89.571  1.00 26.11           O  
ATOM   1052  CB  LEU A 134       7.390  46.834  92.309  1.00 23.04           C  
ATOM   1053  CG  LEU A 134       8.113  48.088  92.819  1.00 30.21           C  
ATOM   1054  CD1 LEU A 134       7.358  48.671  94.001  1.00 23.37           C  
ATOM   1055  CD2 LEU A 134       9.514  47.723  93.258  1.00 42.70           C  
ATOM   1056  N   LEU A 135       7.761  46.574  89.265  1.00 20.08           N  
ATOM   1057  CA  LEU A 135       8.493  46.898  88.046  1.00 19.78           C  
ATOM   1058  C   LEU A 135       7.556  47.267  86.904  1.00 20.83           C  
ATOM   1059  O   LEU A 135       7.814  48.228  86.178  1.00 28.11           O  
ATOM   1060  CB  LEU A 135       9.376  45.720  87.628  1.00 18.68           C  
ATOM   1061  CG  LEU A 135      10.502  45.341  88.592  1.00 21.84           C  
ATOM   1062  CD1 LEU A 135      11.240  44.139  88.038  1.00 24.64           C  
ATOM   1063  CD2 LEU A 135      11.457  46.517  88.776  1.00 18.63           C  
ATOM   1064  N   LEU A 136       6.472  46.505  86.746  1.00 20.09           N  
ATOM   1065  CA  LEU A 136       5.503  46.776  85.689  1.00 19.42           C  
ATOM   1066  C   LEU A 136       4.931  48.165  85.934  1.00 25.70           C  
ATOM   1067  O   LEU A 136       4.747  48.952  85.003  1.00 12.88           O  
ATOM   1068  CB  LEU A 136       4.372  45.740  85.701  1.00 13.47           C  
ATOM   1069  CG  LEU A 136       4.697  44.294  85.287  1.00 26.03           C  
ATOM   1070  CD1 LEU A 136       3.463  43.404  85.497  1.00 15.50           C  
ATOM   1071  CD2 LEU A 136       5.139  44.254  83.825  1.00 15.20           C  
ATOM   1072  N   GLU A 137       4.654  48.462  87.199  1.00 19.72           N  
ATOM   1073  CA  GLU A 137       4.117  49.763  87.557  1.00 22.97           C  
ATOM   1074  C   GLU A 137       5.167  50.830  87.241  1.00 14.06           C  
ATOM   1075  O   GLU A 137       4.888  51.800  86.540  1.00 18.51           O  
ATOM   1076  CB  GLU A 137       3.767  49.804  89.053  1.00 14.42           C  
ATOM   1077  CG  GLU A 137       3.123  51.118  89.503  1.00 22.47           C  
ATOM   1078  CD  GLU A 137       1.760  51.349  88.865  1.00 22.61           C  
ATOM   1079  OE1 GLU A 137       0.864  50.493  89.055  1.00 24.01           O  
ATOM   1080  OE2 GLU A 137       1.583  52.379  88.176  1.00 22.42           O  
ATOM   1081  N   ARG A 138       6.375  50.632  87.760  1.00 17.68           N  
ATOM   1082  CA  ARG A 138       7.476  51.568  87.554  1.00 18.73           C  
ATOM   1083  C   ARG A 138       7.766  51.893  86.090  1.00 25.05           C  
ATOM   1084  O   ARG A 138       8.150  53.015  85.756  1.00 29.29           O  
ATOM   1085  CB  ARG A 138       8.760  51.024  88.186  1.00 17.33           C  
ATOM   1086  CG  ARG A 138       9.947  51.937  87.993  1.00 10.95           C  
ATOM   1087  CD  ARG A 138      11.224  51.301  88.472  1.00 30.30           C  
ATOM   1088  NE  ARG A 138      12.381  52.069  88.031  1.00 23.12           N  
ATOM   1089  CZ  ARG A 138      13.633  51.632  88.093  1.00 23.13           C  
ATOM   1090  NH1 ARG A 138      13.895  50.429  88.580  1.00 30.86           N  
ATOM   1091  NH2 ARG A 138      14.622  52.393  87.649  1.00 26.85           N  
ATOM   1092  N   PHE A 139       7.591  50.911  85.214  1.00 26.62           N  
ATOM   1093  CA  PHE A 139       7.878  51.125  83.804  1.00 24.12           C  
ATOM   1094  C   PHE A 139       6.694  51.615  82.976  1.00 28.96           C  
ATOM   1095  O   PHE A 139       6.770  51.672  81.749  1.00 30.51           O  
ATOM   1096  CB  PHE A 139       8.474  49.843  83.211  1.00 21.29           C  
ATOM   1097  CG  PHE A 139       9.784  49.459  83.835  1.00 17.53           C  
ATOM   1098  CD1 PHE A 139      10.775  50.417  84.037  1.00 18.36           C  
ATOM   1099  CD2 PHE A 139      10.027  48.148  84.230  1.00 20.26           C  
ATOM   1100  CE1 PHE A 139      11.994  50.068  84.628  1.00 29.82           C  
ATOM   1101  CE2 PHE A 139      11.244  47.784  84.823  1.00 20.35           C  
ATOM   1102  CZ  PHE A 139      12.227  48.742  85.022  1.00 13.54           C  
ATOM   1103  N   GLY A 140       5.610  51.978  83.655  1.00 25.53           N  
ATOM   1104  CA  GLY A 140       4.436  52.483  82.965  1.00 24.32           C  
ATOM   1105  C   GLY A 140       3.549  51.455  82.287  1.00 22.19           C  
ATOM   1106  O   GLY A 140       2.650  51.835  81.543  1.00 30.55           O  
ATOM   1107  N   LEU A 141       3.774  50.168  82.541  1.00 28.13           N  
ATOM   1108  CA  LEU A 141       2.972  49.121  81.906  1.00 21.33           C  
ATOM   1109  C   LEU A 141       1.635  48.833  82.592  1.00 25.98           C  
ATOM   1110  O   LEU A 141       0.645  48.523  81.924  1.00 19.97           O  
ATOM   1111  CB  LEU A 141       3.788  47.827  81.792  1.00 18.18           C  
ATOM   1112  CG  LEU A 141       5.057  47.912  80.933  1.00 21.78           C  
ATOM   1113  CD1 LEU A 141       5.801  46.597  80.965  1.00 23.73           C  
ATOM   1114  CD2 LEU A 141       4.696  48.265  79.513  1.00 24.11           C  
HETATM 1115  N   MSE A 142       1.593  48.933  83.917  1.00 27.82           N  
HETATM 1116  CA  MSE A 142       0.342  48.674  84.639  1.00 32.99           C  
HETATM 1117  C   MSE A 142      -0.818  49.552  84.177  1.00 29.94           C  
HETATM 1118  O   MSE A 142      -1.972  49.291  84.514  1.00 31.79           O  
HETATM 1119  CB  MSE A 142       0.541  48.836  86.148  1.00 19.06           C  
HETATM 1120  CG  MSE A 142       1.308  47.689  86.773  1.00 31.49           C  
HETATM 1121 SE   MSE A 142       0.417  45.981  86.484  1.00 39.75          SE  
HETATM 1122  CE  MSE A 142       1.190  45.522  84.764  1.00 61.07           C  
ATOM   1123  N   GLU A 143      -0.512  50.590  83.403  1.00 34.00           N  
ATOM   1124  CA  GLU A 143      -1.548  51.481  82.889  1.00 33.32           C  
ATOM   1125  C   GLU A 143      -2.442  50.718  81.921  1.00 31.90           C  
ATOM   1126  O   GLU A 143      -3.602  51.067  81.732  1.00 35.26           O  
ATOM   1127  CB  GLU A 143      -0.921  52.668  82.152  1.00 36.31           C  
ATOM   1128  CG  GLU A 143      -1.948  53.642  81.576  1.00 49.15           C  
ATOM   1129  CD  GLU A 143      -1.329  54.703  80.682  1.00 54.00           C  
ATOM   1130  OE1 GLU A 143      -0.420  55.427  81.141  1.00 61.21           O  
ATOM   1131  OE2 GLU A 143      -1.758  54.820  79.517  1.00 63.01           O  
ATOM   1132  N   PHE A 144      -1.890  49.666  81.323  1.00 32.62           N  
ATOM   1133  CA  PHE A 144      -2.608  48.856  80.347  1.00 31.38           C  
ATOM   1134  C   PHE A 144      -2.994  47.460  80.839  1.00 29.49           C  
ATOM   1135  O   PHE A 144      -3.383  46.607  80.043  1.00 27.78           O  
ATOM   1136  CB  PHE A 144      -1.755  48.749  79.082  1.00 27.19           C  
ATOM   1137  CG  PHE A 144      -1.246  50.068  78.607  1.00 28.01           C  
ATOM   1138  CD1 PHE A 144      -2.125  51.013  78.082  1.00 34.33           C  
ATOM   1139  CD2 PHE A 144       0.096  50.404  78.757  1.00 32.51           C  
ATOM   1140  CE1 PHE A 144      -1.674  52.278  77.715  1.00 32.03           C  
ATOM   1141  CE2 PHE A 144       0.561  51.666  78.394  1.00 35.13           C  
ATOM   1142  CZ  PHE A 144      -0.326  52.605  77.874  1.00 43.83           C  
ATOM   1143  N   ILE A 145      -2.881  47.224  82.141  1.00 24.43           N  
ATOM   1144  CA  ILE A 145      -3.233  45.925  82.702  1.00 28.74           C  
ATOM   1145  C   ILE A 145      -4.340  46.100  83.731  1.00 31.72           C  
ATOM   1146  O   ILE A 145      -4.152  46.773  84.744  1.00 37.25           O  
ATOM   1147  CB  ILE A 145      -2.007  45.234  83.362  1.00 24.58           C  
ATOM   1148  CG1 ILE A 145      -1.078  44.661  82.288  1.00 41.87           C  
ATOM   1149  CG2 ILE A 145      -2.462  44.076  84.228  1.00 28.22           C  
ATOM   1150  CD1 ILE A 145      -0.473  45.673  81.364  1.00 47.69           C  
ATOM   1151  N   ASP A 146      -5.494  45.494  83.463  1.00 28.56           N  
ATOM   1152  CA  ASP A 146      -6.643  45.598  84.357  1.00 27.77           C  
ATOM   1153  C   ASP A 146      -6.547  44.772  85.633  1.00 31.39           C  
ATOM   1154  O   ASP A 146      -7.016  45.208  86.685  1.00 36.03           O  
ATOM   1155  CB  ASP A 146      -7.918  45.236  83.601  1.00 26.23           C  
ATOM   1156  CG  ASP A 146      -8.159  46.143  82.426  1.00 25.57           C  
ATOM   1157  OD1 ASP A 146      -8.283  47.367  82.651  1.00 48.22           O  
ATOM   1158  OD2 ASP A 146      -8.214  45.643  81.284  1.00 24.71           O  
ATOM   1159  N   LYS A 147      -5.964  43.581  85.552  1.00 28.20           N  
ATOM   1160  CA  LYS A 147      -5.816  42.749  86.740  1.00 31.76           C  
ATOM   1161  C   LYS A 147      -4.589  41.855  86.679  1.00 35.67           C  
ATOM   1162  O   LYS A 147      -4.108  41.523  85.597  1.00 35.90           O  
ATOM   1163  CB  LYS A 147      -7.062  41.888  86.970  1.00 37.44           C  
ATOM   1164  CG  LYS A 147      -8.265  42.674  87.469  1.00 53.51           C  
ATOM   1165  CD  LYS A 147      -9.313  41.776  88.116  1.00 63.68           C  
ATOM   1166  CE  LYS A 147      -8.765  41.083  89.359  1.00 72.45           C  
ATOM   1167  NZ  LYS A 147      -8.267  42.052  90.374  1.00 68.65           N  
ATOM   1168  N   THR A 148      -4.078  41.485  87.852  1.00 32.54           N  
ATOM   1169  CA  THR A 148      -2.915  40.618  87.940  1.00 29.36           C  
ATOM   1170  C   THR A 148      -3.236  39.377  88.756  1.00 32.42           C  
ATOM   1171  O   THR A 148      -3.907  39.437  89.793  1.00 24.19           O  
ATOM   1172  CB  THR A 148      -1.690  41.328  88.578  1.00 25.07           C  
ATOM   1173  OG1 THR A 148      -2.005  41.751  89.911  1.00 28.06           O  
ATOM   1174  CG2 THR A 148      -1.274  42.529  87.744  1.00 22.59           C  
ATOM   1175  N   PHE A 149      -2.748  38.245  88.271  1.00 26.84           N  
ATOM   1176  CA  PHE A 149      -2.961  36.972  88.933  1.00 29.83           C  
ATOM   1177  C   PHE A 149      -1.617  36.286  89.067  1.00 28.20           C  
ATOM   1178  O   PHE A 149      -1.172  35.608  88.145  1.00 37.15           O  
ATOM   1179  CB  PHE A 149      -3.901  36.108  88.098  1.00 21.61           C  
ATOM   1180  CG  PHE A 149      -5.288  36.672  87.966  1.00 29.75           C  
ATOM   1181  CD1 PHE A 149      -6.288  36.307  88.863  1.00 16.48           C  
ATOM   1182  CD2 PHE A 149      -5.599  37.555  86.936  1.00 21.32           C  
ATOM   1183  CE1 PHE A 149      -7.579  36.807  88.734  1.00 18.27           C  
ATOM   1184  CE2 PHE A 149      -6.885  38.062  86.799  1.00 27.00           C  
ATOM   1185  CZ  PHE A 149      -7.881  37.686  87.701  1.00 23.03           C  
ATOM   1186  N   PHE A 150      -0.964  36.477  90.208  1.00 24.27           N  
ATOM   1187  CA  PHE A 150       0.339  35.864  90.447  1.00 20.89           C  
ATOM   1188  C   PHE A 150       0.185  34.598  91.287  1.00 29.55           C  
ATOM   1189  O   PHE A 150      -0.666  34.533  92.168  1.00 22.23           O  
ATOM   1190  CB  PHE A 150       1.268  36.858  91.146  1.00 18.03           C  
ATOM   1191  CG  PHE A 150       1.709  38.002  90.268  1.00 31.63           C  
ATOM   1192  CD1 PHE A 150       2.599  37.787  89.216  1.00 28.38           C  
ATOM   1193  CD2 PHE A 150       1.243  39.294  90.495  1.00 24.64           C  
ATOM   1194  CE1 PHE A 150       3.020  38.838  88.408  1.00 27.83           C  
ATOM   1195  CE2 PHE A 150       1.661  40.356  89.689  1.00 26.83           C  
ATOM   1196  CZ  PHE A 150       2.551  40.128  88.645  1.00 27.46           C  
ATOM   1197  N   ALA A 151       1.016  33.599  91.010  1.00 23.09           N  
ATOM   1198  CA  ALA A 151       0.949  32.326  91.713  1.00 26.72           C  
ATOM   1199  C   ALA A 151       1.046  32.399  93.236  1.00 29.07           C  
ATOM   1200  O   ALA A 151       0.347  31.671  93.934  1.00 27.66           O  
ATOM   1201  CB  ALA A 151       2.015  31.383  91.177  1.00 30.03           C  
ATOM   1202  N   ASP A 152       1.903  33.273  93.753  1.00 23.47           N  
ATOM   1203  CA  ASP A 152       2.073  33.387  95.194  1.00 25.01           C  
ATOM   1204  C   ASP A 152       0.924  34.100  95.881  1.00 23.52           C  
ATOM   1205  O   ASP A 152       0.758  33.997  97.093  1.00 30.89           O  
ATOM   1206  CB  ASP A 152       3.397  34.097  95.516  1.00 26.80           C  
ATOM   1207  CG  ASP A 152       3.451  35.527  94.995  1.00 26.24           C  
ATOM   1208  OD1 ASP A 152       2.714  35.865  94.040  1.00 27.58           O  
ATOM   1209  OD2 ASP A 152       4.253  36.310  95.539  1.00 25.27           O  
ATOM   1210  N   GLU A 153       0.127  34.818  95.102  1.00 28.84           N  
ATOM   1211  CA  GLU A 153      -1.000  35.572  95.639  1.00 30.17           C  
ATOM   1212  C   GLU A 153      -2.337  34.869  95.430  1.00 27.29           C  
ATOM   1213  O   GLU A 153      -3.185  34.852  96.312  1.00 29.61           O  
ATOM   1214  CB  GLU A 153      -1.041  36.960  94.987  1.00 22.15           C  
ATOM   1215  CG  GLU A 153       0.040  37.909  95.484  1.00 20.41           C  
ATOM   1216  CD  GLU A 153       0.146  39.177  94.656  1.00 17.66           C  
ATOM   1217  OE1 GLU A 153      -0.862  39.593  94.046  1.00 26.89           O  
ATOM   1218  OE2 GLU A 153       1.242  39.768  94.627  1.00 24.99           O  
ATOM   1219  N   VAL A 154      -2.504  34.291  94.250  1.00 15.97           N  
ATOM   1220  CA  VAL A 154      -3.722  33.603  93.866  1.00 29.47           C  
ATOM   1221  C   VAL A 154      -3.745  32.123  94.268  1.00 32.03           C  
ATOM   1222  O   VAL A 154      -4.790  31.478  94.241  1.00 29.61           O  
ATOM   1223  CB  VAL A 154      -3.934  33.792  92.339  1.00 25.54           C  
ATOM   1224  CG1 VAL A 154      -4.332  32.505  91.673  1.00 37.52           C  
ATOM   1225  CG2 VAL A 154      -4.977  34.867  92.117  1.00 27.40           C  
ATOM   1226  N   LEU A 155      -2.587  31.599  94.651  1.00 37.84           N  
ATOM   1227  CA  LEU A 155      -2.446  30.207  95.079  1.00 36.04           C  
ATOM   1228  C   LEU A 155      -2.693  29.151  94.002  1.00 33.05           C  
ATOM   1229  O   LEU A 155      -3.378  28.159  94.235  1.00 38.01           O  
ATOM   1230  CB  LEU A 155      -3.344  29.933  96.292  1.00 38.94           C  
ATOM   1231  CG  LEU A 155      -3.078  30.804  97.529  1.00 41.55           C  
ATOM   1232  CD1 LEU A 155      -3.918  30.295  98.693  1.00 39.64           C  
ATOM   1233  CD2 LEU A 155      -1.598  30.769  97.892  1.00 29.47           C  
ATOM   1234  N   SER A 156      -2.130  29.380  92.823  1.00 37.28           N  
ATOM   1235  CA  SER A 156      -2.232  28.443  91.709  1.00 38.95           C  
ATOM   1236  C   SER A 156      -1.136  28.787  90.709  1.00 33.25           C  
ATOM   1237  O   SER A 156      -0.507  29.835  90.823  1.00 36.75           O  
ATOM   1238  CB  SER A 156      -3.600  28.520  91.041  1.00 41.58           C  
ATOM   1239  OG  SER A 156      -3.694  27.526  90.036  1.00 40.84           O  
ATOM   1240  N   TYR A 157      -0.898  27.922  89.729  1.00 31.90           N  
ATOM   1241  CA  TYR A 157       0.165  28.191  88.769  1.00 32.23           C  
ATOM   1242  C   TYR A 157      -0.056  27.543  87.417  1.00 25.55           C  
ATOM   1243  O   TYR A 157      -0.711  26.515  87.315  1.00 34.72           O  
ATOM   1244  CB  TYR A 157       1.502  27.722  89.348  1.00 37.96           C  
ATOM   1245  CG  TYR A 157       1.565  26.233  89.579  1.00 54.58           C  
ATOM   1246  CD1 TYR A 157       1.979  25.367  88.564  1.00 60.96           C  
ATOM   1247  CD2 TYR A 157       1.154  25.678  90.790  1.00 62.38           C  
ATOM   1248  CE1 TYR A 157       1.976  23.986  88.749  1.00 63.15           C  
ATOM   1249  CE2 TYR A 157       1.146  24.298  90.986  1.00 64.97           C  
ATOM   1250  CZ  TYR A 157       1.557  23.459  89.959  1.00 66.04           C  
ATOM   1251  OH  TYR A 157       1.532  22.095  90.137  1.00 67.98           O  
ATOM   1252  N   LYS A 158       0.489  28.172  86.382  1.00 28.29           N  
ATOM   1253  CA  LYS A 158       0.390  27.665  85.018  1.00 30.58           C  
ATOM   1254  C   LYS A 158       1.324  26.455  84.966  1.00 26.27           C  
ATOM   1255  O   LYS A 158       2.386  26.478  85.575  1.00 26.46           O  
ATOM   1256  CB  LYS A 158       0.856  28.737  84.018  1.00 29.99           C  
ATOM   1257  CG  LYS A 158       0.014  30.020  83.997  1.00 29.19           C  
ATOM   1258  CD  LYS A 158       0.608  31.082  83.075  1.00 20.60           C  
ATOM   1259  CE  LYS A 158       2.011  31.482  83.535  1.00 18.99           C  
ATOM   1260  NZ  LYS A 158       2.628  32.584  82.741  1.00 17.36           N  
ATOM   1261  N   PRO A 159       0.980  25.419  84.182  1.00 33.16           N  
ATOM   1262  CA  PRO A 159      -0.199  25.257  83.319  1.00 28.81           C  
ATOM   1263  C   PRO A 159      -1.488  24.757  83.945  1.00 29.98           C  
ATOM   1264  O   PRO A 159      -2.430  24.436  83.224  1.00 29.24           O  
ATOM   1265  CB  PRO A 159       0.302  24.282  82.261  1.00 28.68           C  
ATOM   1266  CG  PRO A 159       1.121  23.346  83.086  1.00 34.16           C  
ATOM   1267  CD  PRO A 159       1.919  24.299  83.979  1.00 34.72           C  
ATOM   1268  N   ARG A 160      -1.548  24.677  85.266  1.00 30.58           N  
ATOM   1269  CA  ARG A 160      -2.755  24.178  85.902  1.00 33.32           C  
ATOM   1270  C   ARG A 160      -4.017  24.888  85.424  1.00 36.71           C  
ATOM   1271  O   ARG A 160      -4.063  26.111  85.306  1.00 39.86           O  
ATOM   1272  CB  ARG A 160      -2.638  24.264  87.422  1.00 40.64           C  
ATOM   1273  CG  ARG A 160      -1.772  23.173  88.033  1.00 44.53           C  
ATOM   1274  CD  ARG A 160      -1.898  23.179  89.547  1.00 60.68           C  
ATOM   1275  NE  ARG A 160      -1.117  22.123  90.184  1.00 65.92           N  
ATOM   1276  CZ  ARG A 160      -1.116  21.887  91.495  1.00 70.58           C  
ATOM   1277  NH1 ARG A 160      -1.857  22.632  92.305  1.00 76.42           N  
ATOM   1278  NH2 ARG A 160      -0.371  20.911  91.997  1.00 70.05           N  
ATOM   1279  N   LYS A 161      -5.036  24.087  85.148  1.00 35.34           N  
ATOM   1280  CA  LYS A 161      -6.323  24.559  84.665  1.00 39.27           C  
ATOM   1281  C   LYS A 161      -7.050  25.579  85.554  1.00 39.26           C  
ATOM   1282  O   LYS A 161      -7.681  26.504  85.041  1.00 38.87           O  
ATOM   1283  CB  LYS A 161      -7.232  23.349  84.418  1.00 42.65           C  
ATOM   1284  CG  LYS A 161      -8.680  23.688  84.107  1.00 65.14           C  
ATOM   1285  CD  LYS A 161      -9.535  22.426  84.032  1.00 75.69           C  
ATOM   1286  CE  LYS A 161     -11.009  22.756  83.826  1.00 83.31           C  
ATOM   1287  NZ  LYS A 161     -11.864  21.533  83.795  1.00 84.45           N  
ATOM   1288  N   GLU A 162      -6.976  25.422  86.875  1.00 33.49           N  
ATOM   1289  CA  GLU A 162      -7.675  26.351  87.767  1.00 39.85           C  
ATOM   1290  C   GLU A 162      -7.104  27.771  87.700  1.00 38.12           C  
ATOM   1291  O   GLU A 162      -7.832  28.746  87.885  1.00 35.57           O  
ATOM   1292  CB  GLU A 162      -7.656  25.848  89.222  1.00 38.06           C  
ATOM   1293  CG  GLU A 162      -6.335  26.053  89.951  1.00 60.14           C  
ATOM   1294  CD  GLU A 162      -5.297  24.997  89.621  1.00 78.70           C  
ATOM   1295  OE1 GLU A 162      -5.240  24.559  88.452  1.00 90.72           O  
ATOM   1296  OE2 GLU A 162      -4.527  24.617  90.531  1.00 76.87           O  
HETATM 1297  N   MSE A 163      -5.805  27.886  87.436  1.00 33.76           N  
HETATM 1298  CA  MSE A 163      -5.164  29.195  87.337  1.00 33.20           C  
HETATM 1299  C   MSE A 163      -5.798  30.022  86.218  1.00 30.35           C  
HETATM 1300  O   MSE A 163      -6.142  31.184  86.412  1.00 27.32           O  
HETATM 1301  CB  MSE A 163      -3.658  29.042  87.073  1.00 35.50           C  
HETATM 1302  CG  MSE A 163      -2.942  30.360  86.761  1.00 33.14           C  
HETATM 1303 SE   MSE A 163      -3.116  31.731  88.154  1.00 44.52          SE  
HETATM 1304  CE  MSE A 163      -1.294  31.749  88.792  1.00 30.38           C  
ATOM   1305  N   PHE A 164      -5.953  29.414  85.048  1.00 24.02           N  
ATOM   1306  CA  PHE A 164      -6.544  30.105  83.919  1.00 24.30           C  
ATOM   1307  C   PHE A 164      -8.030  30.340  84.155  1.00 29.80           C  
ATOM   1308  O   PHE A 164      -8.568  31.378  83.773  1.00 31.79           O  
ATOM   1309  CB  PHE A 164      -6.324  29.297  82.641  1.00 20.85           C  
ATOM   1310  CG  PHE A 164      -4.886  29.249  82.201  1.00 28.85           C  
ATOM   1311  CD1 PHE A 164      -4.276  30.371  81.648  1.00 21.12           C  
ATOM   1312  CD2 PHE A 164      -4.134  28.089  82.352  1.00 32.54           C  
ATOM   1313  CE1 PHE A 164      -2.940  30.335  81.253  1.00 30.02           C  
ATOM   1314  CE2 PHE A 164      -2.792  28.044  81.960  1.00 30.43           C  
ATOM   1315  CZ  PHE A 164      -2.196  29.168  81.411  1.00 18.09           C  
ATOM   1316  N   GLU A 165      -8.689  29.379  84.795  1.00 31.93           N  
ATOM   1317  CA  GLU A 165     -10.111  29.501  85.077  1.00 36.69           C  
ATOM   1318  C   GLU A 165     -10.411  30.632  86.061  1.00 40.54           C  
ATOM   1319  O   GLU A 165     -11.469  31.266  85.976  1.00 24.83           O  
ATOM   1320  CB  GLU A 165     -10.665  28.174  85.607  1.00 45.86           C  
ATOM   1321  CG  GLU A 165     -10.801  27.099  84.539  1.00 52.19           C  
ATOM   1322  CD  GLU A 165     -11.320  25.780  85.084  1.00 55.06           C  
ATOM   1323  OE1 GLU A 165     -10.612  25.151  85.897  1.00 53.95           O  
ATOM   1324  OE2 GLU A 165     -12.436  25.371  84.698  1.00 55.16           O  
ATOM   1325  N   LYS A 166      -9.490  30.894  86.988  1.00 34.73           N  
ATOM   1326  CA  LYS A 166      -9.699  31.977  87.949  1.00 37.79           C  
ATOM   1327  C   LYS A 166      -9.849  33.270  87.175  1.00 32.69           C  
ATOM   1328  O   LYS A 166     -10.747  34.067  87.437  1.00 34.63           O  
ATOM   1329  CB  LYS A 166      -8.514  32.126  88.911  1.00 34.16           C  
ATOM   1330  CG  LYS A 166      -8.428  31.072  89.998  1.00 51.01           C  
ATOM   1331  CD  LYS A 166      -7.346  31.430  91.009  1.00 41.60           C  
ATOM   1332  CE  LYS A 166      -7.180  30.356  92.071  1.00 31.19           C  
ATOM   1333  NZ  LYS A 166      -8.428  30.114  92.846  1.00 50.76           N  
ATOM   1334  N   VAL A 167      -8.950  33.461  86.213  1.00 31.32           N  
ATOM   1335  CA  VAL A 167      -8.943  34.652  85.382  1.00 25.62           C  
ATOM   1336  C   VAL A 167     -10.197  34.730  84.520  1.00 23.40           C  
ATOM   1337  O   VAL A 167     -10.737  35.809  84.304  1.00 37.57           O  
ATOM   1338  CB  VAL A 167      -7.681  34.686  84.476  1.00 24.31           C  
ATOM   1339  CG1 VAL A 167      -7.593  36.017  83.757  1.00 12.95           C  
ATOM   1340  CG2 VAL A 167      -6.433  34.468  85.316  1.00 15.26           C  
ATOM   1341  N   LEU A 168     -10.656  33.590  84.019  1.00 27.55           N  
ATOM   1342  CA  LEU A 168     -11.858  33.565  83.198  1.00 30.72           C  
ATOM   1343  C   LEU A 168     -13.086  33.880  84.062  1.00 33.48           C  
ATOM   1344  O   LEU A 168     -13.989  34.612  83.643  1.00 22.43           O  
ATOM   1345  CB  LEU A 168     -12.020  32.189  82.535  1.00 26.88           C  
ATOM   1346  CG  LEU A 168     -11.014  31.867  81.428  1.00 27.50           C  
ATOM   1347  CD1 LEU A 168     -11.249  30.466  80.925  1.00 28.19           C  
ATOM   1348  CD2 LEU A 168     -11.175  32.874  80.291  1.00 21.45           C  
ATOM   1349  N   ASN A 169     -13.116  33.326  85.270  1.00 27.22           N  
ATOM   1350  CA  ASN A 169     -14.236  33.571  86.169  1.00 35.93           C  
ATOM   1351  C   ASN A 169     -14.214  35.003  86.680  1.00 31.32           C  
ATOM   1352  O   ASN A 169     -15.256  35.576  86.970  1.00 33.47           O  
ATOM   1353  CB  ASN A 169     -14.213  32.595  87.349  1.00 38.74           C  
ATOM   1354  CG  ASN A 169     -14.526  31.171  86.931  1.00 45.61           C  
ATOM   1355  OD1 ASN A 169     -15.475  30.931  86.182  1.00 52.24           O  
ATOM   1356  ND2 ASN A 169     -13.737  30.219  87.417  1.00 56.99           N  
ATOM   1357  N   SER A 170     -13.020  35.578  86.777  1.00 29.54           N  
ATOM   1358  CA  SER A 170     -12.870  36.945  87.250  1.00 21.64           C  
ATOM   1359  C   SER A 170     -13.437  37.933  86.230  1.00 24.90           C  
ATOM   1360  O   SER A 170     -14.191  38.837  86.581  1.00 27.68           O  
ATOM   1361  CB  SER A 170     -11.389  37.247  87.509  1.00 22.91           C  
ATOM   1362  OG  SER A 170     -11.222  38.540  88.056  1.00 24.92           O  
ATOM   1363  N   PHE A 171     -13.071  37.749  84.967  1.00 28.80           N  
ATOM   1364  CA  PHE A 171     -13.534  38.620  83.891  1.00 31.14           C  
ATOM   1365  C   PHE A 171     -14.859  38.104  83.347  1.00 35.04           C  
ATOM   1366  O   PHE A 171     -15.443  38.678  82.418  1.00 35.46           O  
ATOM   1367  CB  PHE A 171     -12.487  38.686  82.766  1.00 23.40           C  
ATOM   1368  CG  PHE A 171     -11.306  39.575  83.080  1.00 22.51           C  
ATOM   1369  CD1 PHE A 171     -11.363  40.944  82.838  1.00 24.90           C  
ATOM   1370  CD2 PHE A 171     -10.143  39.045  83.622  1.00 20.26           C  
ATOM   1371  CE1 PHE A 171     -10.270  41.777  83.133  1.00 23.05           C  
ATOM   1372  CE2 PHE A 171      -9.048  39.864  83.922  1.00 22.58           C  
ATOM   1373  CZ  PHE A 171      -9.114  41.235  83.675  1.00 20.36           C  
ATOM   1374  N   GLU A 172     -15.324  37.010  83.934  1.00 35.20           N  
ATOM   1375  CA  GLU A 172     -16.587  36.401  83.541  1.00 40.54           C  
ATOM   1376  C   GLU A 172     -16.753  36.273  82.030  1.00 42.38           C  
ATOM   1377  O   GLU A 172     -17.715  36.785  81.461  1.00 43.60           O  
ATOM   1378  CB  GLU A 172     -17.738  37.215  84.119  1.00 35.06           C  
ATOM   1379  CG  GLU A 172     -18.620  36.433  85.052  1.00 50.63           C  
ATOM   1380  CD  GLU A 172     -19.318  37.320  86.044  1.00 54.12           C  
ATOM   1381  OE1 GLU A 172     -18.665  37.745  87.022  1.00 49.42           O  
ATOM   1382  OE2 GLU A 172     -20.516  37.600  85.839  1.00 64.41           O  
ATOM   1383  N   VAL A 173     -15.812  35.592  81.385  1.00 34.28           N  
ATOM   1384  CA  VAL A 173     -15.876  35.394  79.943  1.00 29.28           C  
ATOM   1385  C   VAL A 173     -15.616  33.934  79.613  1.00 31.45           C  
ATOM   1386  O   VAL A 173     -15.012  33.206  80.402  1.00 27.03           O  
ATOM   1387  CB  VAL A 173     -14.830  36.251  79.198  1.00 39.01           C  
ATOM   1388  CG1 VAL A 173     -15.006  37.713  79.553  1.00 38.44           C  
ATOM   1389  CG2 VAL A 173     -13.424  35.778  79.542  1.00 42.86           C  
ATOM   1390  N   LYS A 174     -16.077  33.507  78.445  1.00 34.92           N  
ATOM   1391  CA  LYS A 174     -15.877  32.129  78.024  1.00 43.40           C  
ATOM   1392  C   LYS A 174     -14.465  31.962  77.471  1.00 40.76           C  
ATOM   1393  O   LYS A 174     -13.895  32.899  76.911  1.00 43.41           O  
ATOM   1394  CB  LYS A 174     -16.915  31.740  76.964  1.00 45.78           C  
ATOM   1395  CG  LYS A 174     -18.247  31.256  77.529  1.00 56.54           C  
ATOM   1396  CD  LYS A 174     -18.900  32.284  78.442  1.00 71.08           C  
ATOM   1397  CE  LYS A 174     -20.174  31.737  79.082  1.00 69.96           C  
ATOM   1398  NZ  LYS A 174     -20.706  32.657  80.131  1.00 63.28           N  
ATOM   1399  N   PRO A 175     -13.882  30.763  77.625  1.00 41.44           N  
ATOM   1400  CA  PRO A 175     -12.532  30.462  77.143  1.00 36.89           C  
ATOM   1401  C   PRO A 175     -12.326  30.936  75.710  1.00 40.84           C  
ATOM   1402  O   PRO A 175     -11.249  31.412  75.353  1.00 40.33           O  
ATOM   1403  CB  PRO A 175     -12.463  28.945  77.252  1.00 44.09           C  
ATOM   1404  CG  PRO A 175     -13.319  28.665  78.441  1.00 42.45           C  
ATOM   1405  CD  PRO A 175     -14.504  29.561  78.208  1.00 37.72           C  
ATOM   1406  N   GLU A 176     -13.372  30.806  74.900  1.00 29.50           N  
ATOM   1407  CA  GLU A 176     -13.311  31.208  73.503  1.00 37.18           C  
ATOM   1408  C   GLU A 176     -13.203  32.721  73.301  1.00 34.20           C  
ATOM   1409  O   GLU A 176     -12.847  33.178  72.220  1.00 27.24           O  
ATOM   1410  CB  GLU A 176     -14.533  30.671  72.763  1.00 50.57           C  
ATOM   1411  CG  GLU A 176     -14.632  29.159  72.777  1.00 70.40           C  
ATOM   1412  CD  GLU A 176     -15.866  28.651  72.056  1.00 84.93           C  
ATOM   1413  OE1 GLU A 176     -16.988  29.036  72.454  1.00 88.79           O  
ATOM   1414  OE2 GLU A 176     -15.714  27.866  71.093  1.00 87.90           O  
ATOM   1415  N   GLU A 177     -13.509  33.502  74.333  1.00 30.25           N  
ATOM   1416  CA  GLU A 177     -13.414  34.955  74.211  1.00 36.69           C  
ATOM   1417  C   GLU A 177     -12.111  35.436  74.852  1.00 30.06           C  
ATOM   1418  O   GLU A 177     -11.970  36.608  75.196  1.00 23.31           O  
ATOM   1419  CB  GLU A 177     -14.599  35.626  74.908  1.00 32.90           C  
ATOM   1420  CG  GLU A 177     -15.963  35.226  74.370  1.00 45.87           C  
ATOM   1421  CD  GLU A 177     -17.100  35.647  75.291  1.00 43.00           C  
ATOM   1422  OE1 GLU A 177     -17.184  35.114  76.419  1.00 44.37           O  
ATOM   1423  OE2 GLU A 177     -17.906  36.511  74.891  1.00 46.97           O  
ATOM   1424  N   SER A 178     -11.161  34.522  75.007  1.00 19.89           N  
ATOM   1425  CA  SER A 178      -9.891  34.855  75.640  1.00 22.92           C  
ATOM   1426  C   SER A 178      -8.678  34.375  74.854  1.00 30.92           C  
ATOM   1427  O   SER A 178      -8.705  33.322  74.207  1.00 24.22           O  
ATOM   1428  CB  SER A 178      -9.829  34.232  77.033  1.00 22.57           C  
ATOM   1429  OG  SER A 178     -11.049  34.403  77.720  1.00 36.45           O  
ATOM   1430  N   LEU A 179      -7.607  35.158  74.926  1.00 27.53           N  
ATOM   1431  CA  LEU A 179      -6.362  34.815  74.262  1.00 29.11           C  
ATOM   1432  C   LEU A 179      -5.256  35.020  75.277  1.00 26.53           C  
ATOM   1433  O   LEU A 179      -5.201  36.056  75.933  1.00 25.48           O  
ATOM   1434  CB  LEU A 179      -6.121  35.709  73.042  1.00 19.60           C  
ATOM   1435  CG  LEU A 179      -4.867  35.369  72.204  1.00 21.12           C  
ATOM   1436  CD1 LEU A 179      -5.032  35.916  70.791  1.00 23.77           C  
ATOM   1437  CD2 LEU A 179      -3.606  35.945  72.850  1.00 16.96           C  
ATOM   1438  N   HIS A 180      -4.404  34.013  75.435  1.00 22.73           N  
ATOM   1439  CA  HIS A 180      -3.283  34.105  76.363  1.00 25.79           C  
ATOM   1440  C   HIS A 180      -1.971  34.021  75.596  1.00 26.76           C  
ATOM   1441  O   HIS A 180      -1.804  33.160  74.734  1.00 26.64           O  
ATOM   1442  CB  HIS A 180      -3.327  32.978  77.394  1.00 20.78           C  
ATOM   1443  CG  HIS A 180      -2.141  32.966  78.307  1.00 27.25           C  
ATOM   1444  ND1 HIS A 180      -1.853  34.006  79.161  1.00 25.73           N  
ATOM   1445  CD2 HIS A 180      -1.138  32.068  78.455  1.00 14.02           C  
ATOM   1446  CE1 HIS A 180      -0.721  33.753  79.793  1.00 26.23           C  
ATOM   1447  NE2 HIS A 180      -0.267  32.582  79.382  1.00 13.47           N  
ATOM   1448  N   ILE A 181      -1.044  34.923  75.897  1.00 25.66           N  
ATOM   1449  CA  ILE A 181       0.248  34.894  75.238  1.00 22.66           C  
ATOM   1450  C   ILE A 181       1.366  34.756  76.263  1.00 25.97           C  
ATOM   1451  O   ILE A 181       1.369  35.427  77.296  1.00 24.07           O  
ATOM   1452  CB  ILE A 181       0.486  36.149  74.346  1.00 21.04           C  
ATOM   1453  CG1 ILE A 181       1.917  36.126  73.804  1.00 16.95           C  
ATOM   1454  CG2 ILE A 181       0.202  37.424  75.121  1.00 20.36           C  
ATOM   1455  CD1 ILE A 181       2.192  37.151  72.727  1.00 14.65           C  
ATOM   1456  N   GLY A 182       2.296  33.852  75.975  1.00 21.14           N  
ATOM   1457  CA  GLY A 182       3.419  33.613  76.865  1.00 22.74           C  
ATOM   1458  C   GLY A 182       4.556  32.964  76.098  1.00 25.62           C  
ATOM   1459  O   GLY A 182       4.352  32.477  74.979  1.00 21.92           O  
ATOM   1460  N   ASP A 183       5.747  32.928  76.690  1.00 30.45           N  
ATOM   1461  CA  ASP A 183       6.890  32.354  75.991  1.00 27.20           C  
ATOM   1462  C   ASP A 183       7.270  30.924  76.392  1.00 29.77           C  
ATOM   1463  O   ASP A 183       8.210  30.364  75.836  1.00 22.54           O  
ATOM   1464  CB  ASP A 183       8.098  33.300  76.109  1.00 26.96           C  
ATOM   1465  CG  ASP A 183       9.151  32.805  77.078  1.00 34.26           C  
ATOM   1466  OD1 ASP A 183       8.798  32.505  78.238  1.00 25.77           O  
ATOM   1467  OD2 ASP A 183      10.336  32.729  76.673  1.00 32.62           O  
ATOM   1468  N   THR A 184       6.542  30.332  77.341  1.00 27.45           N  
ATOM   1469  CA  THR A 184       6.824  28.957  77.765  1.00 24.97           C  
ATOM   1470  C   THR A 184       5.764  28.033  77.168  1.00 32.53           C  
ATOM   1471  O   THR A 184       4.578  28.134  77.482  1.00 35.32           O  
ATOM   1472  CB  THR A 184       6.817  28.802  79.302  1.00 36.09           C  
ATOM   1473  OG1 THR A 184       7.724  29.749  79.883  1.00 27.79           O  
ATOM   1474  CG2 THR A 184       7.267  27.391  79.696  1.00 19.96           C  
ATOM   1475  N   TYR A 185       6.208  27.134  76.298  1.00 32.84           N  
ATOM   1476  CA  TYR A 185       5.314  26.209  75.624  1.00 33.60           C  
ATOM   1477  C   TYR A 185       4.437  25.382  76.561  1.00 35.94           C  
ATOM   1478  O   TYR A 185       3.212  25.358  76.405  1.00 33.34           O  
ATOM   1479  CB  TYR A 185       6.122  25.273  74.717  1.00 36.23           C  
ATOM   1480  CG  TYR A 185       5.258  24.480  73.769  1.00 34.57           C  
ATOM   1481  CD1 TYR A 185       4.542  25.115  72.756  1.00 45.64           C  
ATOM   1482  CD2 TYR A 185       5.095  23.110  73.929  1.00 42.40           C  
ATOM   1483  CE1 TYR A 185       3.681  24.403  71.933  1.00 51.64           C  
ATOM   1484  CE2 TYR A 185       4.236  22.390  73.115  1.00 42.76           C  
ATOM   1485  CZ  TYR A 185       3.528  23.040  72.123  1.00 49.74           C  
ATOM   1486  OH  TYR A 185       2.641  22.329  71.349  1.00 59.06           O  
ATOM   1487  N   ALA A 186       5.058  24.714  77.530  1.00 30.00           N  
ATOM   1488  CA  ALA A 186       4.330  23.867  78.474  1.00 30.91           C  
ATOM   1489  C   ALA A 186       3.434  24.615  79.466  1.00 32.50           C  
ATOM   1490  O   ALA A 186       2.303  24.198  79.709  1.00 45.94           O  
ATOM   1491  CB  ALA A 186       5.314  22.967  79.241  1.00 29.11           C  
ATOM   1492  N   GLU A 187       3.926  25.706  80.045  1.00 28.22           N  
ATOM   1493  CA  GLU A 187       3.129  26.455  81.011  1.00 27.93           C  
ATOM   1494  C   GLU A 187       2.093  27.378  80.371  1.00 28.59           C  
ATOM   1495  O   GLU A 187       0.906  27.266  80.657  1.00 28.88           O  
ATOM   1496  CB  GLU A 187       4.033  27.283  81.926  1.00 24.72           C  
ATOM   1497  CG  GLU A 187       5.075  26.483  82.686  1.00 24.55           C  
ATOM   1498  CD  GLU A 187       6.028  27.383  83.439  1.00 31.59           C  
ATOM   1499  OE1 GLU A 187       6.063  28.595  83.132  1.00 36.62           O  
ATOM   1500  OE2 GLU A 187       6.749  26.884  84.326  1.00 42.79           O  
ATOM   1501  N   ASP A 188       2.549  28.286  79.512  1.00 28.10           N  
ATOM   1502  CA  ASP A 188       1.664  29.248  78.852  1.00 29.51           C  
ATOM   1503  C   ASP A 188       0.792  28.677  77.740  1.00 36.01           C  
ATOM   1504  O   ASP A 188      -0.437  28.668  77.843  1.00 30.97           O  
ATOM   1505  CB  ASP A 188       2.479  30.402  78.263  1.00 30.06           C  
ATOM   1506  CG  ASP A 188       3.249  31.174  79.312  1.00 33.41           C  
ATOM   1507  OD1 ASP A 188       2.606  31.761  80.210  1.00 30.99           O  
ATOM   1508  OD2 ASP A 188       4.492  31.193  79.229  1.00 28.97           O  
ATOM   1509  N   TYR A 189       1.439  28.212  76.676  1.00 28.64           N  
ATOM   1510  CA  TYR A 189       0.742  27.681  75.509  1.00 31.06           C  
ATOM   1511  C   TYR A 189      -0.172  26.473  75.739  1.00 29.83           C  
ATOM   1512  O   TYR A 189      -1.381  26.553  75.493  1.00 21.25           O  
ATOM   1513  CB  TYR A 189       1.753  27.345  74.404  1.00 29.04           C  
ATOM   1514  CG  TYR A 189       1.102  26.930  73.109  1.00 27.51           C  
ATOM   1515  CD1 TYR A 189       0.583  27.880  72.231  1.00 19.01           C  
ATOM   1516  CD2 TYR A 189       0.959  25.582  72.783  1.00 34.68           C  
ATOM   1517  CE1 TYR A 189      -0.062  27.498  71.065  1.00 19.63           C  
ATOM   1518  CE2 TYR A 189       0.317  25.187  71.620  1.00 27.30           C  
ATOM   1519  CZ  TYR A 189      -0.189  26.146  70.767  1.00 23.37           C  
ATOM   1520  OH  TYR A 189      -0.804  25.750  69.612  1.00 17.75           O  
ATOM   1521  N   GLN A 190       0.395  25.359  76.197  1.00 25.35           N  
ATOM   1522  CA  GLN A 190      -0.403  24.157  76.414  1.00 28.44           C  
ATOM   1523  C   GLN A 190      -1.420  24.305  77.540  1.00 34.30           C  
ATOM   1524  O   GLN A 190      -2.456  23.631  77.541  1.00 34.09           O  
ATOM   1525  CB  GLN A 190       0.501  22.951  76.682  1.00 23.25           C  
ATOM   1526  CG  GLN A 190       1.426  22.611  75.525  1.00 37.74           C  
ATOM   1527  CD  GLN A 190       2.081  21.264  75.694  1.00 47.20           C  
ATOM   1528  OE1 GLN A 190       2.623  20.951  76.754  1.00 48.50           O  
ATOM   1529  NE2 GLN A 190       2.039  20.453  74.647  1.00 54.01           N  
ATOM   1530  N   GLY A 191      -1.119  25.178  78.498  1.00 30.56           N  
ATOM   1531  CA  GLY A 191      -2.032  25.406  79.602  1.00 23.72           C  
ATOM   1532  C   GLY A 191      -3.218  26.221  79.112  1.00 32.26           C  
ATOM   1533  O   GLY A 191      -4.373  25.917  79.397  1.00 26.88           O  
ATOM   1534  N   ALA A 192      -2.938  27.266  78.348  1.00 22.07           N  
ATOM   1535  CA  ALA A 192      -4.015  28.090  77.841  1.00 30.31           C  
ATOM   1536  C   ALA A 192      -4.899  27.317  76.869  1.00 33.41           C  
ATOM   1537  O   ALA A 192      -6.128  27.401  76.931  1.00 36.57           O  
ATOM   1538  CB  ALA A 192      -3.454  29.329  77.167  1.00 23.65           C  
ATOM   1539  N   ARG A 193      -4.284  26.551  75.978  1.00 30.73           N  
ATOM   1540  CA  ARG A 193      -5.064  25.815  74.995  1.00 33.23           C  
ATOM   1541  C   ARG A 193      -5.926  24.693  75.572  1.00 29.98           C  
ATOM   1542  O   ARG A 193      -7.057  24.509  75.139  1.00 25.09           O  
ATOM   1543  CB  ARG A 193      -4.159  25.272  73.886  1.00 39.26           C  
ATOM   1544  CG  ARG A 193      -4.943  24.877  72.649  1.00 48.94           C  
ATOM   1545  CD  ARG A 193      -4.199  25.212  71.375  1.00 61.54           C  
ATOM   1546  NE  ARG A 193      -2.941  24.482  71.265  1.00 69.42           N  
ATOM   1547  CZ  ARG A 193      -2.837  23.159  71.332  1.00 77.90           C  
ATOM   1548  NH1 ARG A 193      -3.922  22.415  71.512  1.00 67.49           N  
ATOM   1549  NH2 ARG A 193      -1.649  22.577  71.208  1.00 78.90           N  
ATOM   1550  N   LYS A 194      -5.419  23.956  76.556  1.00 30.14           N  
ATOM   1551  CA  LYS A 194      -6.219  22.884  77.125  1.00 36.86           C  
ATOM   1552  C   LYS A 194      -7.442  23.436  77.849  1.00 45.43           C  
ATOM   1553  O   LYS A 194      -8.391  22.705  78.126  1.00 47.49           O  
ATOM   1554  CB  LYS A 194      -5.391  22.020  78.082  1.00 49.66           C  
ATOM   1555  CG  LYS A 194      -6.143  20.769  78.525  1.00 62.66           C  
ATOM   1556  CD  LYS A 194      -5.241  19.716  79.139  1.00 73.55           C  
ATOM   1557  CE  LYS A 194      -6.007  18.414  79.344  1.00 74.81           C  
ATOM   1558  NZ  LYS A 194      -5.147  17.335  79.897  1.00 81.13           N  
ATOM   1559  N   VAL A 195      -7.425  24.731  78.147  1.00 43.12           N  
ATOM   1560  CA  VAL A 195      -8.546  25.359  78.830  1.00 35.55           C  
ATOM   1561  C   VAL A 195      -9.569  25.891  77.825  1.00 35.51           C  
ATOM   1562  O   VAL A 195     -10.668  26.295  78.199  1.00 41.00           O  
ATOM   1563  CB  VAL A 195      -8.036  26.483  79.781  1.00 42.44           C  
ATOM   1564  CG1 VAL A 195      -9.025  27.625  79.875  1.00 41.57           C  
ATOM   1565  CG2 VAL A 195      -7.811  25.897  81.163  1.00 44.87           C  
ATOM   1566  N   GLY A 196      -9.210  25.876  76.544  1.00 32.12           N  
ATOM   1567  CA  GLY A 196     -10.124  26.344  75.515  1.00 27.35           C  
ATOM   1568  C   GLY A 196      -9.875  27.746  74.984  1.00 37.55           C  
ATOM   1569  O   GLY A 196     -10.530  28.181  74.033  1.00 34.92           O  
HETATM 1570  N   MSE A 197      -8.932  28.462  75.589  1.00 33.83           N  
HETATM 1571  CA  MSE A 197      -8.627  29.819  75.152  1.00 33.85           C  
HETATM 1572  C   MSE A 197      -7.762  29.806  73.897  1.00 23.83           C  
HETATM 1573  O   MSE A 197      -7.200  28.781  73.524  1.00 29.69           O  
HETATM 1574  CB  MSE A 197      -7.839  30.572  76.224  1.00 31.62           C  
HETATM 1575  CG  MSE A 197      -8.387  30.532  77.631  1.00 47.54           C  
HETATM 1576 SE   MSE A 197      -7.005  31.179  78.839  1.00 42.71          SE  
HETATM 1577  CE  MSE A 197      -6.217  29.496  79.274  1.00 70.56           C  
ATOM   1578  N   TRP A 198      -7.657  30.956  73.245  1.00 24.91           N  
ATOM   1579  CA  TRP A 198      -6.782  31.066  72.091  1.00 25.08           C  
ATOM   1580  C   TRP A 198      -5.411  31.125  72.746  1.00 29.42           C  
ATOM   1581  O   TRP A 198      -5.254  31.730  73.812  1.00 29.44           O  
ATOM   1582  CB  TRP A 198      -7.037  32.364  71.324  1.00 23.11           C  
ATOM   1583  CG  TRP A 198      -8.288  32.357  70.509  1.00 27.04           C  
ATOM   1584  CD1 TRP A 198      -9.532  32.763  70.901  1.00 32.60           C  
ATOM   1585  CD2 TRP A 198      -8.414  31.929  69.147  1.00 29.40           C  
ATOM   1586  NE1 TRP A 198     -10.430  32.617  69.861  1.00 28.41           N  
ATOM   1587  CE2 TRP A 198      -9.769  32.106  68.776  1.00 25.62           C  
ATOM   1588  CE3 TRP A 198      -7.513  31.413  68.203  1.00 30.82           C  
ATOM   1589  CZ2 TRP A 198     -10.243  31.785  67.496  1.00 26.79           C  
ATOM   1590  CZ3 TRP A 198      -7.982  31.095  66.932  1.00 27.37           C  
ATOM   1591  CH2 TRP A 198      -9.338  31.283  66.590  1.00 22.63           C  
ATOM   1592  N   ALA A 199      -4.419  30.488  72.140  1.00 28.94           N  
ATOM   1593  CA  ALA A 199      -3.090  30.504  72.725  1.00 21.39           C  
ATOM   1594  C   ALA A 199      -2.036  30.964  71.739  1.00 25.50           C  
ATOM   1595  O   ALA A 199      -2.034  30.545  70.585  1.00 23.88           O  
ATOM   1596  CB  ALA A 199      -2.734  29.132  73.252  1.00 18.68           C  
ATOM   1597  N   VAL A 200      -1.153  31.844  72.201  1.00 19.15           N  
ATOM   1598  CA  VAL A 200      -0.064  32.340  71.381  1.00 19.50           C  
ATOM   1599  C   VAL A 200       1.253  32.089  72.118  1.00 29.41           C  
ATOM   1600  O   VAL A 200       1.470  32.571  73.237  1.00 30.83           O  
ATOM   1601  CB  VAL A 200      -0.206  33.853  71.086  1.00 22.07           C  
ATOM   1602  CG1 VAL A 200       0.974  34.332  70.247  1.00 12.82           C  
ATOM   1603  CG2 VAL A 200      -1.519  34.125  70.353  1.00 25.84           C  
ATOM   1604  N   TRP A 201       2.120  31.305  71.495  1.00 23.93           N  
ATOM   1605  CA  TRP A 201       3.416  30.994  72.069  1.00 24.09           C  
ATOM   1606  C   TRP A 201       4.485  31.899  71.474  1.00 30.20           C  
ATOM   1607  O   TRP A 201       4.701  31.899  70.266  1.00 35.28           O  
ATOM   1608  CB  TRP A 201       3.778  29.536  71.790  1.00 25.17           C  
ATOM   1609  CG  TRP A 201       5.184  29.190  72.173  1.00 35.52           C  
ATOM   1610  CD1 TRP A 201       5.819  29.513  73.338  1.00 34.72           C  
ATOM   1611  CD2 TRP A 201       6.122  28.430  71.403  1.00 36.35           C  
ATOM   1612  NE1 TRP A 201       7.092  29.000  73.343  1.00 27.55           N  
ATOM   1613  CE2 TRP A 201       7.306  28.329  72.168  1.00 38.65           C  
ATOM   1614  CE3 TRP A 201       6.079  27.821  70.140  1.00 40.82           C  
ATOM   1615  CZ2 TRP A 201       8.437  27.642  71.713  1.00 36.31           C  
ATOM   1616  CZ3 TRP A 201       7.206  27.138  69.687  1.00 36.62           C  
ATOM   1617  CH2 TRP A 201       8.368  27.055  70.474  1.00 44.80           C  
ATOM   1618  N   ILE A 202       5.140  32.692  72.312  1.00 32.71           N  
ATOM   1619  CA  ILE A 202       6.200  33.554  71.813  1.00 29.35           C  
ATOM   1620  C   ILE A 202       7.442  32.688  71.661  1.00 33.78           C  
ATOM   1621  O   ILE A 202       7.925  32.118  72.635  1.00 29.90           O  
ATOM   1622  CB  ILE A 202       6.517  34.716  72.784  1.00 21.60           C  
ATOM   1623  CG1 ILE A 202       5.437  35.794  72.682  1.00 16.62           C  
ATOM   1624  CG2 ILE A 202       7.868  35.312  72.454  1.00 27.67           C  
ATOM   1625  CD1 ILE A 202       5.615  36.923  73.679  1.00 31.80           C  
ATOM   1626  N   ASN A 203       7.933  32.574  70.431  1.00 37.40           N  
ATOM   1627  CA  ASN A 203       9.129  31.790  70.139  1.00 34.15           C  
ATOM   1628  C   ASN A 203      10.126  32.714  69.456  1.00 35.68           C  
ATOM   1629  O   ASN A 203       9.975  33.044  68.282  1.00 38.43           O  
ATOM   1630  CB  ASN A 203       8.773  30.605  69.236  1.00 31.89           C  
ATOM   1631  CG  ASN A 203       9.995  29.875  68.710  1.00 43.21           C  
ATOM   1632  OD1 ASN A 203      11.033  29.805  69.369  1.00 37.24           O  
ATOM   1633  ND2 ASN A 203       9.869  29.309  67.517  1.00 40.71           N  
ATOM   1634  N   GLN A 204      11.134  33.143  70.210  1.00 42.15           N  
ATOM   1635  CA  GLN A 204      12.153  34.054  69.696  1.00 50.42           C  
ATOM   1636  C   GLN A 204      12.869  33.516  68.461  1.00 52.42           C  
ATOM   1637  O   GLN A 204      13.145  34.262  67.520  1.00 59.51           O  
ATOM   1638  CB  GLN A 204      13.195  34.365  70.781  1.00 39.48           C  
ATOM   1639  CG  GLN A 204      12.672  35.119  72.003  1.00 57.25           C  
ATOM   1640  CD  GLN A 204      11.839  34.249  72.937  1.00 64.82           C  
ATOM   1641  OE1 GLN A 204      12.212  33.118  73.251  1.00 69.79           O  
ATOM   1642  NE2 GLN A 204      10.715  34.785  73.399  1.00 64.84           N  
ATOM   1643  N   GLU A 205      13.171  32.222  68.469  1.00 52.47           N  
ATOM   1644  CA  GLU A 205      13.867  31.598  67.354  1.00 53.86           C  
ATOM   1645  C   GLU A 205      12.955  31.537  66.135  1.00 55.41           C  
ATOM   1646  O   GLU A 205      13.318  30.980  65.100  1.00 58.79           O  
ATOM   1647  CB  GLU A 205      14.338  30.196  67.760  1.00 57.23           C  
ATOM   1648  CG  GLU A 205      15.198  30.200  69.031  1.00 71.19           C  
ATOM   1649  CD  GLU A 205      15.700  28.819  69.431  1.00 79.98           C  
ATOM   1650  OE1 GLU A 205      14.868  27.902  69.593  1.00 84.65           O  
ATOM   1651  OE2 GLU A 205      16.930  28.655  69.595  1.00 77.53           O  
ATOM   1652  N   GLY A 206      11.772  32.134  66.271  1.00 53.05           N  
ATOM   1653  CA  GLY A 206      10.801  32.150  65.191  1.00 44.01           C  
ATOM   1654  C   GLY A 206      11.081  33.231  64.172  1.00 28.57           C  
ATOM   1655  O   GLY A 206      11.704  34.239  64.479  1.00 34.99           O  
ATOM   1656  N   ASP A 207      10.587  33.027  62.961  1.00 30.73           N  
ATOM   1657  CA  ASP A 207      10.802  33.955  61.863  1.00 38.95           C  
ATOM   1658  C   ASP A 207       9.558  34.735  61.430  1.00 35.67           C  
ATOM   1659  O   ASP A 207       9.666  35.860  60.944  1.00 32.24           O  
ATOM   1660  CB  ASP A 207      11.372  33.167  60.676  1.00 54.31           C  
ATOM   1661  CG  ASP A 207      11.441  33.985  59.408  1.00 72.66           C  
ATOM   1662  OD1 ASP A 207      12.054  35.073  59.432  1.00 86.15           O  
ATOM   1663  OD2 ASP A 207      10.889  33.531  58.381  1.00 78.70           O  
ATOM   1664  N   LYS A 208       8.378  34.149  61.622  1.00 33.79           N  
ATOM   1665  CA  LYS A 208       7.125  34.779  61.208  1.00 33.55           C  
ATOM   1666  C   LYS A 208       5.939  34.298  62.045  1.00 29.66           C  
ATOM   1667  O   LYS A 208       6.057  33.368  62.843  1.00 34.13           O  
ATOM   1668  CB  LYS A 208       6.854  34.424  59.740  1.00 40.94           C  
ATOM   1669  CG  LYS A 208       6.743  32.908  59.536  1.00 51.55           C  
ATOM   1670  CD  LYS A 208       6.530  32.471  58.094  1.00 50.39           C  
ATOM   1671  CE  LYS A 208       6.383  30.950  58.024  1.00 52.79           C  
ATOM   1672  NZ  LYS A 208       6.245  30.441  56.630  1.00 56.91           N  
ATOM   1673  N   VAL A 209       4.790  34.935  61.856  1.00 27.09           N  
ATOM   1674  CA  VAL A 209       3.586  34.520  62.560  1.00 30.63           C  
ATOM   1675  C   VAL A 209       3.215  33.181  61.929  1.00 31.13           C  
ATOM   1676  O   VAL A 209       3.243  33.048  60.712  1.00 32.20           O  
ATOM   1677  CB  VAL A 209       2.428  35.515  62.339  1.00 25.94           C  
ATOM   1678  CG1 VAL A 209       1.136  34.939  62.894  1.00 24.11           C  
ATOM   1679  CG2 VAL A 209       2.748  36.842  63.009  1.00 32.57           C  
ATOM   1680  N   ARG A 210       2.886  32.189  62.750  1.00 32.92           N  
ATOM   1681  CA  ARG A 210       2.516  30.873  62.236  1.00 32.99           C  
ATOM   1682  C   ARG A 210       1.357  30.271  62.999  1.00 37.27           C  
ATOM   1683  O   ARG A 210       1.336  30.276  64.233  1.00 36.47           O  
ATOM   1684  CB  ARG A 210       3.687  29.889  62.326  1.00 43.37           C  
ATOM   1685  CG  ARG A 210       4.770  30.048  61.273  1.00 56.92           C  
ATOM   1686  CD  ARG A 210       5.761  28.884  61.353  1.00 65.66           C  
ATOM   1687  NE  ARG A 210       5.092  27.588  61.221  1.00 67.75           N  
ATOM   1688  CZ  ARG A 210       5.019  26.675  62.187  1.00 63.32           C  
ATOM   1689  NH1 ARG A 210       5.578  26.903  63.369  1.00 67.20           N  
ATOM   1690  NH2 ARG A 210       4.373  25.534  61.977  1.00 56.04           N  
ATOM   1691  N   LYS A 211       0.388  29.750  62.259  1.00 32.34           N  
ATOM   1692  CA  LYS A 211      -0.749  29.102  62.883  1.00 25.58           C  
ATOM   1693  C   LYS A 211      -0.199  27.739  63.256  1.00 28.09           C  
ATOM   1694  O   LYS A 211       0.245  26.996  62.386  1.00 39.95           O  
ATOM   1695  CB  LYS A 211      -1.892  28.959  61.883  1.00 19.09           C  
ATOM   1696  CG  LYS A 211      -3.175  28.403  62.466  1.00 17.95           C  
ATOM   1697  CD  LYS A 211      -4.288  28.419  61.437  1.00 26.77           C  
ATOM   1698  CE  LYS A 211      -5.546  27.786  61.994  1.00 47.74           C  
ATOM   1699  NZ  LYS A 211      -5.974  28.460  63.250  1.00 53.00           N  
ATOM   1700  N   LEU A 212      -0.184  27.422  64.546  1.00 31.04           N  
ATOM   1701  CA  LEU A 212       0.329  26.127  64.979  1.00 37.37           C  
ATOM   1702  C   LEU A 212      -0.753  25.072  64.840  1.00 38.52           C  
ATOM   1703  O   LEU A 212      -0.471  23.922  64.505  1.00 40.67           O  
ATOM   1704  CB  LEU A 212       0.806  26.182  66.431  1.00 32.15           C  
ATOM   1705  CG  LEU A 212       2.088  26.942  66.768  1.00 41.34           C  
ATOM   1706  CD1 LEU A 212       2.389  26.724  68.240  1.00 35.91           C  
ATOM   1707  CD2 LEU A 212       3.255  26.449  65.916  1.00 35.44           C  
ATOM   1708  N   GLU A 213      -1.992  25.473  65.095  1.00 43.38           N  
ATOM   1709  CA  GLU A 213      -3.123  24.568  64.998  1.00 47.21           C  
ATOM   1710  C   GLU A 213      -4.410  25.301  65.334  1.00 48.66           C  
ATOM   1711  O   GLU A 213      -4.466  26.528  65.295  1.00 47.89           O  
ATOM   1712  CB  GLU A 213      -2.947  23.409  65.967  1.00 54.33           C  
ATOM   1713  CG  GLU A 213      -2.986  23.846  67.410  1.00 65.57           C  
ATOM   1714  CD  GLU A 213      -2.810  22.691  68.367  1.00 83.20           C  
ATOM   1715  OE1 GLU A 213      -1.684  22.150  68.453  1.00 88.84           O  
ATOM   1716  OE2 GLU A 213      -3.805  22.322  69.026  1.00 88.80           O  
ATOM   1717  N   GLU A 214      -5.444  24.538  65.669  1.00 52.92           N  
ATOM   1718  CA  GLU A 214      -6.723  25.128  66.022  1.00 52.23           C  
ATOM   1719  C   GLU A 214      -6.554  25.949  67.291  1.00 50.81           C  
ATOM   1720  O   GLU A 214      -6.261  25.399  68.355  1.00 51.67           O  
ATOM   1721  CB  GLU A 214      -7.769  24.045  66.273  1.00 58.85           C  
ATOM   1722  CG  GLU A 214      -9.141  24.616  66.588  1.00 69.39           C  
ATOM   1723  CD  GLU A 214     -10.003  23.672  67.398  1.00 71.62           C  
ATOM   1724  OE1 GLU A 214     -11.070  23.267  66.894  1.00 75.27           O  
ATOM   1725  OE2 GLU A 214      -9.616  23.341  68.540  1.00 73.21           O  
ATOM   1726  N   ARG A 215      -6.736  27.260  67.174  1.00 34.52           N  
ATOM   1727  CA  ARG A 215      -6.615  28.166  68.311  1.00 37.25           C  
ATOM   1728  C   ARG A 215      -5.184  28.291  68.833  1.00 34.45           C  
ATOM   1729  O   ARG A 215      -4.965  28.817  69.922  1.00 37.31           O  
ATOM   1730  CB  ARG A 215      -7.539  27.713  69.452  1.00 38.91           C  
ATOM   1731  CG  ARG A 215      -8.987  27.434  69.033  1.00 49.10           C  
ATOM   1732  CD  ARG A 215      -9.569  28.604  68.268  1.00 49.24           C  
ATOM   1733  NE  ARG A 215     -10.869  28.327  67.659  1.00 46.99           N  
ATOM   1734  CZ  ARG A 215     -12.037  28.569  68.246  1.00 57.77           C  
ATOM   1735  NH1 ARG A 215     -12.073  29.092  69.466  1.00 43.24           N  
ATOM   1736  NH2 ARG A 215     -13.170  28.308  67.605  1.00 51.41           N  
ATOM   1737  N   GLY A 216      -4.217  27.815  68.054  1.00 31.46           N  
ATOM   1738  CA  GLY A 216      -2.826  27.891  68.474  1.00 29.86           C  
ATOM   1739  C   GLY A 216      -1.944  28.642  67.485  1.00 31.24           C  
ATOM   1740  O   GLY A 216      -1.927  28.321  66.292  1.00 24.94           O  
ATOM   1741  N   PHE A 217      -1.208  29.634  67.986  1.00 14.26           N  
ATOM   1742  CA  PHE A 217      -0.327  30.451  67.164  1.00 17.20           C  
ATOM   1743  C   PHE A 217       1.061  30.561  67.778  1.00 20.23           C  
ATOM   1744  O   PHE A 217       1.239  30.407  68.987  1.00 27.07           O  
ATOM   1745  CB  PHE A 217      -0.866  31.883  67.018  1.00 15.62           C  
ATOM   1746  CG  PHE A 217      -2.103  32.005  66.183  1.00 21.11           C  
ATOM   1747  CD1 PHE A 217      -2.015  32.131  64.801  1.00 21.95           C  
ATOM   1748  CD2 PHE A 217      -3.356  32.014  66.781  1.00 29.59           C  
ATOM   1749  CE1 PHE A 217      -3.154  32.262  64.027  1.00 29.78           C  
ATOM   1750  CE2 PHE A 217      -4.507  32.145  66.016  1.00 22.56           C  
ATOM   1751  CZ  PHE A 217      -4.407  32.269  64.634  1.00 22.76           C  
ATOM   1752  N   GLU A 218       2.030  30.866  66.921  1.00 21.54           N  
ATOM   1753  CA  GLU A 218       3.421  31.049  67.297  1.00 23.71           C  
ATOM   1754  C   GLU A 218       3.895  32.347  66.667  1.00 19.47           C  
ATOM   1755  O   GLU A 218       3.664  32.583  65.479  1.00 30.18           O  
ATOM   1756  CB  GLU A 218       4.269  29.894  66.762  1.00 37.24           C  
ATOM   1757  CG  GLU A 218       5.734  30.249  66.543  1.00 33.75           C  
ATOM   1758  CD  GLU A 218       6.501  29.139  65.856  1.00 35.89           C  
ATOM   1759  OE1 GLU A 218       6.615  28.048  66.447  1.00 39.67           O  
ATOM   1760  OE2 GLU A 218       6.984  29.353  64.722  1.00 47.30           O  
ATOM   1761  N   ILE A 219       4.536  33.199  67.461  1.00 21.66           N  
ATOM   1762  CA  ILE A 219       5.056  34.469  66.954  1.00 18.51           C  
ATOM   1763  C   ILE A 219       6.417  34.714  67.598  1.00 28.56           C  
ATOM   1764  O   ILE A 219       6.689  34.215  68.698  1.00 21.45           O  
ATOM   1765  CB  ILE A 219       4.110  35.662  67.269  1.00 25.17           C  
ATOM   1766  CG1 ILE A 219       4.010  35.886  68.778  1.00 25.22           C  
ATOM   1767  CG2 ILE A 219       2.733  35.396  66.688  1.00 15.67           C  
ATOM   1768  CD1 ILE A 219       3.183  37.099  69.160  1.00 26.45           C  
ATOM   1769  N   PRO A 220       7.294  35.471  66.917  1.00 24.68           N  
ATOM   1770  CA  PRO A 220       8.639  35.779  67.421  1.00 34.39           C  
ATOM   1771  C   PRO A 220       8.736  36.737  68.609  1.00 40.56           C  
ATOM   1772  O   PRO A 220       9.700  36.676  69.374  1.00 37.17           O  
ATOM   1773  CB  PRO A 220       9.357  36.303  66.183  1.00 32.14           C  
ATOM   1774  CG  PRO A 220       8.252  36.939  65.403  1.00 42.31           C  
ATOM   1775  CD  PRO A 220       7.134  35.946  65.531  1.00 34.11           C  
ATOM   1776  N   SER A 221       7.759  37.627  68.756  1.00 32.01           N  
ATOM   1777  CA  SER A 221       7.748  38.568  69.873  1.00 31.68           C  
ATOM   1778  C   SER A 221       6.372  39.200  70.017  1.00 22.78           C  
ATOM   1779  O   SER A 221       5.532  39.096  69.124  1.00 32.22           O  
ATOM   1780  CB  SER A 221       8.800  39.668  69.689  1.00 26.82           C  
ATOM   1781  OG  SER A 221       8.329  40.708  68.849  1.00 38.85           O  
ATOM   1782  N   ILE A 222       6.153  39.864  71.144  1.00 28.07           N  
ATOM   1783  CA  ILE A 222       4.872  40.498  71.426  1.00 25.66           C  
ATOM   1784  C   ILE A 222       4.483  41.562  70.393  1.00 29.09           C  
ATOM   1785  O   ILE A 222       3.342  42.030  70.372  1.00 32.61           O  
ATOM   1786  CB  ILE A 222       4.889  41.113  72.836  1.00 26.48           C  
ATOM   1787  CG1 ILE A 222       3.468  41.242  73.365  1.00 25.47           C  
ATOM   1788  CG2 ILE A 222       5.560  42.466  72.804  1.00 27.13           C  
ATOM   1789  CD1 ILE A 222       3.416  41.444  74.851  1.00 33.02           C  
ATOM   1790  N   ALA A 223       5.426  41.931  69.530  1.00 25.78           N  
ATOM   1791  CA  ALA A 223       5.174  42.940  68.502  1.00 29.93           C  
ATOM   1792  C   ALA A 223       4.220  42.431  67.433  1.00 30.24           C  
ATOM   1793  O   ALA A 223       3.631  43.216  66.694  1.00 29.60           O  
ATOM   1794  CB  ALA A 223       6.502  43.389  67.849  1.00 24.57           C  
ATOM   1795  N   ASN A 224       4.066  41.116  67.344  1.00 30.33           N  
ATOM   1796  CA  ASN A 224       3.178  40.545  66.345  1.00 26.09           C  
ATOM   1797  C   ASN A 224       1.859  40.068  66.932  1.00 28.69           C  
ATOM   1798  O   ASN A 224       1.084  39.395  66.261  1.00 25.94           O  
ATOM   1799  CB  ASN A 224       3.877  39.393  65.631  1.00 22.82           C  
ATOM   1800  CG  ASN A 224       5.012  39.865  64.753  1.00 29.31           C  
ATOM   1801  OD1 ASN A 224       4.791  40.527  63.740  1.00 40.49           O  
ATOM   1802  ND2 ASN A 224       6.236  39.533  65.136  1.00 18.79           N  
ATOM   1803  N   LEU A 225       1.603  40.412  68.187  1.00 21.49           N  
ATOM   1804  CA  LEU A 225       0.363  40.004  68.825  1.00 18.98           C  
ATOM   1805  C   LEU A 225      -0.817  40.594  68.061  1.00 26.01           C  
ATOM   1806  O   LEU A 225      -1.811  39.913  67.796  1.00 28.54           O  
ATOM   1807  CB  LEU A 225       0.333  40.491  70.272  1.00 16.41           C  
ATOM   1808  CG  LEU A 225      -0.915  40.153  71.084  1.00 21.94           C  
ATOM   1809  CD1 LEU A 225      -1.186  38.658  71.053  1.00 28.32           C  
ATOM   1810  CD2 LEU A 225      -0.712  40.623  72.499  1.00 17.14           C  
ATOM   1811  N   LYS A 226      -0.691  41.863  67.691  1.00 25.52           N  
ATOM   1812  CA  LYS A 226      -1.751  42.553  66.973  1.00 34.12           C  
ATOM   1813  C   LYS A 226      -2.156  41.844  65.689  1.00 31.44           C  
ATOM   1814  O   LYS A 226      -3.321  41.902  65.290  1.00 29.65           O  
ATOM   1815  CB  LYS A 226      -1.334  43.997  66.668  1.00 42.70           C  
ATOM   1816  CG  LYS A 226      -0.002  44.130  65.947  1.00 38.21           C  
ATOM   1817  CD  LYS A 226       0.338  45.589  65.688  1.00 45.79           C  
ATOM   1818  CE  LYS A 226      -0.656  46.216  64.730  1.00 53.43           C  
ATOM   1819  NZ  LYS A 226      -0.309  47.630  64.431  1.00 59.03           N  
ATOM   1820  N   ASP A 227      -1.206  41.173  65.046  1.00 30.97           N  
ATOM   1821  CA  ASP A 227      -1.501  40.452  63.806  1.00 34.15           C  
ATOM   1822  C   ASP A 227      -2.473  39.319  64.083  1.00 31.39           C  
ATOM   1823  O   ASP A 227      -3.410  39.090  63.323  1.00 20.84           O  
ATOM   1824  CB  ASP A 227      -0.222  39.884  63.194  1.00 43.34           C  
ATOM   1825  CG  ASP A 227       0.777  40.964  62.841  1.00 42.51           C  
ATOM   1826  OD1 ASP A 227       0.422  41.859  62.047  1.00 45.17           O  
ATOM   1827  OD2 ASP A 227       1.909  40.916  63.363  1.00 52.77           O  
ATOM   1828  N   VAL A 228      -2.241  38.607  65.179  1.00 28.77           N  
ATOM   1829  CA  VAL A 228      -3.115  37.511  65.544  1.00 25.13           C  
ATOM   1830  C   VAL A 228      -4.442  38.109  65.959  1.00 16.05           C  
ATOM   1831  O   VAL A 228      -5.497  37.650  65.519  1.00 22.14           O  
ATOM   1832  CB  VAL A 228      -2.531  36.687  66.708  1.00 17.71           C  
ATOM   1833  CG1 VAL A 228      -3.465  35.541  67.072  1.00 26.56           C  
ATOM   1834  CG2 VAL A 228      -1.170  36.151  66.315  1.00 29.51           C  
ATOM   1835  N   ILE A 229      -4.389  39.149  66.788  1.00 26.74           N  
ATOM   1836  CA  ILE A 229      -5.610  39.795  67.260  1.00 24.71           C  
ATOM   1837  C   ILE A 229      -6.523  40.213  66.107  1.00 26.38           C  
ATOM   1838  O   ILE A 229      -7.726  39.933  66.118  1.00 20.95           O  
ATOM   1839  CB  ILE A 229      -5.318  41.055  68.089  1.00 22.53           C  
ATOM   1840  CG1 ILE A 229      -4.443  40.716  69.295  1.00 25.62           C  
ATOM   1841  CG2 ILE A 229      -6.635  41.665  68.558  1.00 25.77           C  
ATOM   1842  CD1 ILE A 229      -5.039  39.693  70.209  1.00 27.11           C  
ATOM   1843  N   GLU A 230      -5.965  40.894  65.117  1.00 29.10           N  
ATOM   1844  CA  GLU A 230      -6.784  41.331  63.999  1.00 34.32           C  
ATOM   1845  C   GLU A 230      -7.170  40.175  63.097  1.00 35.43           C  
ATOM   1846  O   GLU A 230      -8.204  40.224  62.434  1.00 23.45           O  
ATOM   1847  CB  GLU A 230      -6.077  42.428  63.205  1.00 39.78           C  
ATOM   1848  CG  GLU A 230      -6.139  43.767  63.910  1.00 51.59           C  
ATOM   1849  CD  GLU A 230      -5.665  44.912  63.051  1.00 65.17           C  
ATOM   1850  OE1 GLU A 230      -4.462  44.955  62.721  1.00 70.59           O  
ATOM   1851  OE2 GLU A 230      -6.503  45.771  62.706  1.00 78.36           O  
ATOM   1852  N   LEU A 231      -6.357  39.121  63.104  1.00 31.08           N  
ATOM   1853  CA  LEU A 231      -6.625  37.947  62.280  1.00 29.44           C  
ATOM   1854  C   LEU A 231      -7.900  37.213  62.690  1.00 26.32           C  
ATOM   1855  O   LEU A 231      -8.708  36.841  61.843  1.00 30.20           O  
ATOM   1856  CB  LEU A 231      -5.444  36.976  62.341  1.00 31.84           C  
ATOM   1857  CG  LEU A 231      -5.651  35.695  61.535  1.00 36.38           C  
ATOM   1858  CD1 LEU A 231      -5.892  36.054  60.068  1.00 33.78           C  
ATOM   1859  CD2 LEU A 231      -4.439  34.789  61.684  1.00 30.96           C  
ATOM   1860  N   ILE A 232      -8.085  37.010  63.989  1.00 29.10           N  
ATOM   1861  CA  ILE A 232      -9.258  36.299  64.484  1.00 33.09           C  
ATOM   1862  C   ILE A 232     -10.418  37.219  64.907  1.00 37.92           C  
ATOM   1863  O   ILE A 232     -11.370  36.787  65.563  1.00 41.99           O  
ATOM   1864  CB  ILE A 232      -8.857  35.365  65.656  1.00 31.60           C  
ATOM   1865  CG1 ILE A 232      -8.371  36.183  66.858  1.00 34.17           C  
ATOM   1866  CG2 ILE A 232      -7.736  34.434  65.199  1.00 26.30           C  
ATOM   1867  CD1 ILE A 232      -7.852  35.327  68.018  1.00 25.99           C  
ATOM   1868  N   SER A 233     -10.336  38.485  64.518  1.00 37.45           N  
ATOM   1869  CA  SER A 233     -11.373  39.458  64.836  1.00 41.92           C  
ATOM   1870  C   SER A 233     -12.239  39.738  63.605  1.00 41.73           C  
ATOM   1871  O   SER A 233     -12.137  40.847  63.043  1.00 48.86           O  
ATOM   1872  CB  SER A 233     -10.742  40.758  65.328  1.00 35.74           C  
ATOM   1873  OG  SER A 233     -11.739  41.734  65.547  1.00 48.41           O  
TER    1874      SER A 233                                                      
END
MOLECULE T0418.pdb
ATOM      1  N   LYS     2     -13.076  35.543  67.613  1.00 29.62           N
ATOM      2  CA  LYS     2     -12.478  36.834  68.052  0.50 29.11           C
ATOM      4  CB  LYS     2     -13.375  38.010  67.650  0.50 29.29           C
ATOM      6  CG  LYS     2     -12.641  39.346  67.502  0.50 28.70           C
ATOM      8  CD  LYS     2     -13.620  40.472  67.149  0.50 28.45           C
ATOM     10  CE  LYS     2     -14.745  40.631  68.215  0.50 27.78           C
ATOM     12  NZ  LYS     2     -14.212  40.910  69.618  0.50 23.90           N
ATOM     14  C   LYS     2     -12.217  36.842  69.559  1.00 29.22           C
ATOM     15  O   LYS     2     -13.013  36.324  70.358  1.00 29.48           O
ATOM     16  N   TYR     3     -11.081  37.413  69.934  1.00 28.23           N
ATOM     17  CA  TYR     3     -10.713  37.511  71.337  1.00 28.13           C
ATOM     18  CB  TYR     3      -9.228  37.205  71.499  1.00 27.69           C
ATOM     19  CG  TYR     3      -8.855  35.913  70.851  1.00 27.85           C
ATOM     20  CD1 TYR     3      -9.318  34.695  71.359  1.00 27.15           C
ATOM     21  CE1 TYR     3      -8.963  33.481  70.741  1.00 29.48           C
ATOM     22  CZ  TYR     3      -8.150  33.512  69.615  1.00 28.31           C
ATOM     23  OH  TYR     3      -7.781  32.362  68.998  1.00 29.71           O
ATOM     24  CE2 TYR     3      -7.689  34.704  69.099  1.00 28.68           C
ATOM     25  CD2 TYR     3      -8.054  35.901  69.711  1.00 28.20           C
ATOM     26  C   TYR     3     -11.028  38.898  71.895  1.00 27.71           C
ATOM     27  O   TYR     3     -10.756  39.901  71.237  1.00 28.58           O
ATOM     28  N   THR     4     -11.608  38.949  73.092  1.00 26.98           N
ATOM     29  CA  THR     4     -11.921  40.233  73.752  1.00 26.26           C
ATOM     30  CB  THR     4     -13.434  40.362  74.092  1.00 25.63           C
ATOM     31  OG1 THR     4     -13.795  39.364  75.050  1.00 24.05           O
ATOM     32  CG2 THR     4     -14.272  40.199  72.862  1.00 25.42           C
ATOM     33  C   THR     4     -11.088  40.424  75.028  1.00 26.20           C
ATOM     34  O   THR     4     -11.218  41.432  75.726  1.00 26.38           O
ATOM     35  N   VAL     5     -10.260  39.424  75.320  1.00 26.09           N
ATOM     36  CA  VAL     5      -9.387  39.390  76.487  1.00 25.98           C
ATOM     37  CB  VAL     5      -9.988  38.533  77.656  1.00 26.21           C
ATOM     38  CG1 VAL     5      -9.003  38.455  78.853  1.00 25.67           C
ATOM     39  CG2 VAL     5     -11.398  39.033  78.080  1.00 25.14           C
ATOM     40  C   VAL     5      -8.026  38.798  76.069  1.00 26.19           C
ATOM     41  O   VAL     5      -7.939  37.642  75.627  1.00 25.71           O
ATOM     42  N   TYR     6      -6.974  39.596  76.199  1.00 25.76           N
ATOM     43  CA  TYR     6      -5.616  39.122  75.949  1.00 25.47           C
ATOM     44  CB  TYR     6      -4.867  40.089  75.019  1.00 25.89           C
ATOM     45  CG  TYR     6      -5.233  40.042  73.546  1.00 26.06           C
ATOM     46  CD1 TYR     6      -6.573  40.059  73.118  1.00 27.09           C
ATOM     47  CE1 TYR     6      -6.905  40.033  71.753  1.00 27.02           C
ATOM     48  CZ  TYR     6      -5.886  40.001  70.813  1.00 26.83           C
ATOM     49  OH  TYR     6      -6.181  39.980  69.480  1.00 25.05           O
ATOM     50  CE2 TYR     6      -4.551  40.012  71.213  1.00 25.46           C
ATOM     51  CD2 TYR     6      -4.234  40.029  72.575  1.00 26.76           C
ATOM     52  C   TYR     6      -4.877  39.026  77.278  1.00 25.08           C
ATOM     53  O   TYR     6      -4.674  40.032  77.943  1.00 24.69           O
ATOM     54  N   LEU     7      -4.487  37.816  77.670  1.00 24.54           N
ATOM     55  CA  LEU     7      -3.771  37.624  78.929  1.00 24.14           C
ATOM     56  CB  LEU     7      -4.383  36.496  79.763  1.00 23.59           C
ATOM     57  CG  LEU     7      -5.870  36.734  80.138  1.00 24.16           C
ATOM     58  CD1 LEU     7      -6.521  35.534  80.774  1.00 20.62           C
ATOM     59  CD2 LEU     7      -6.014  37.958  81.059  1.00 22.12           C
ATOM     60  C   LEU     7      -2.323  37.335  78.582  1.00 24.96           C
ATOM     61  O   LEU     7      -2.027  36.555  77.668  1.00 24.77           O
ATOM     62  N   PHE     8      -1.430  38.000  79.300  1.00 25.46           N
ATOM     63  CA  PHE     8      -0.011  37.932  79.019  1.00 25.12           C
ATOM     64  CB  PHE     8       0.536  39.346  78.747  1.00 24.90           C
ATOM     65  CG  PHE     8      -0.072  40.030  77.537  1.00 23.20           C
ATOM     66  CD1 PHE     8       0.543  39.933  76.300  1.00 20.97           C
ATOM     67  CE1 PHE     8       0.002  40.554  75.184  1.00 23.26           C
ATOM     68  CZ  PHE     8      -1.183  41.317  75.319  1.00 23.30           C
ATOM     69  CE2 PHE     8      -1.795  41.414  76.551  1.00 22.61           C
ATOM     70  CD2 PHE     8      -1.243  40.770  77.646  1.00 23.59           C
ATOM     71  C   PHE     8       0.758  37.332  80.185  1.00 25.42           C
ATOM     72  O   PHE     8       0.489  37.647  81.349  1.00 24.56           O
ATOM     73  N   ASP     9       1.705  36.454  79.854  1.00 25.13           N
ATOM     74  CA  ASP     9       2.868  36.191  80.698  1.00 25.05           C
ATOM     75  CB  ASP     9       3.770  35.134  80.038  1.00 25.36           C
ATOM     76  CG  ASP     9       4.800  34.591  80.993  1.00 26.68           C
ATOM     77  OD1 ASP     9       4.592  34.704  82.202  1.00 34.85           O
ATOM     78  OD2 ASP     9       5.854  34.101  80.583  1.00 35.24           O
ATOM     79  C   ASP     9       3.678  37.487  80.915  1.00 24.97           C
ATOM     80  O   ASP     9       3.511  38.454  80.172  1.00 26.37           O
ATOM     81  N   PHE    10       4.517  37.529  81.947  1.00 23.63           N
ATOM     82  CA  PHE    10       5.322  38.732  82.245  1.00 23.16           C
ATOM     83  CB  PHE    10       5.224  39.137  83.733  1.00 22.29           C
ATOM     84  CG  PHE    10       5.966  40.422  84.054  1.00 22.99           C
ATOM     85  CD1 PHE    10       5.373  41.665  83.808  1.00 24.77           C
ATOM     86  CE1 PHE    10       6.080  42.878  84.084  1.00 24.55           C
ATOM     87  CZ  PHE    10       7.384  42.826  84.610  1.00 22.62           C
ATOM     88  CE2 PHE    10       7.982  41.589  84.874  1.00 24.73           C
ATOM     89  CD2 PHE    10       7.276  40.382  84.582  1.00 23.46           C
ATOM     90  C   PHE    10       6.773  38.604  81.815  1.00 22.66           C
ATOM     91  O   PHE    10       7.185  39.218  80.841  1.00 23.91           O
ATOM     92  N   ASP    11       7.552  37.779  82.507  1.00 23.43           N
ATOM     93  CA  ASP    11       8.986  37.643  82.204  1.00 23.44           C
ATOM     94  CB  ASP    11       9.664  36.690  83.184  1.00 23.10           C
ATOM     95  CG  ASP    11       9.732  37.232  84.591  1.00 24.03           C
ATOM     96  OD1 ASP    11      10.159  38.406  84.796  1.00 24.46           O
ATOM     97  OD2 ASP    11       9.374  36.443  85.514  1.00 23.52           O
ATOM     98  C   ASP    11       9.215  37.131  80.776  1.00 23.25           C
ATOM     99  O   ASP    11       8.635  36.114  80.385  1.00 23.39           O
ATOM    100  N   TYR    12      10.044  37.839  80.001  1.00 21.78           N
ATOM    101  CA  TYR    12      10.289  37.470  78.592  1.00 19.73           C
ATOM    102  CB  TYR    12      10.756  36.006  78.503  1.00 20.19           C
ATOM    103  CG  TYR    12      12.274  35.815  78.587  1.00 18.57           C
ATOM    104  CD1 TYR    12      13.161  36.790  78.106  1.00 19.37           C
ATOM    105  CE1 TYR    12      14.573  36.569  78.131  1.00 17.76           C
ATOM    106  CZ  TYR    12      15.053  35.376  78.655  1.00 20.36           C
ATOM    107  OH  TYR    12      16.419  35.108  78.707  1.00 20.14           O
ATOM    108  CE2 TYR    12      14.181  34.426  79.131  1.00 19.24           C
ATOM    109  CD2 TYR    12      12.810  34.625  79.069  1.00 19.14           C
ATOM    110  C   TYR    12       9.134  37.682  77.617  1.00 20.20           C
ATOM    111  O   TYR    12       9.239  37.335  76.430  1.00 18.25           O
ATOM    112  N   THR    13       8.026  38.225  78.105  1.00 19.18           N
ATOM    113  CA  THR    13       6.883  38.448  77.261  1.00 20.06           C
ATOM    114  CB  THR    13       5.674  37.608  77.705  1.00 19.89           C
ATOM    115  OG1 THR    13       5.969  36.211  77.494  1.00 21.97           O
ATOM    116  CG2 THR    13       4.465  37.998  76.843  1.00 19.00           C
ATOM    117  C   THR    13       6.536  39.943  77.240  1.00 19.72           C
ATOM    118  O   THR    13       6.575  40.562  76.173  1.00 19.50           O
ATOM    119  N   LEU    14       6.246  40.526  78.410  1.00 19.60           N
ATOM    120  CA  LEU    14       5.990  41.979  78.467  1.00 20.37           C
ATOM    121  CB  LEU    14       4.878  42.310  79.457  1.00 19.90           C
ATOM    122  CG  LEU    14       3.462  41.924  79.113  1.00 21.71           C
ATOM    123  CD1 LEU    14       2.570  42.180  80.336  1.00 22.39           C
ATOM    124  CD2 LEU    14       2.910  42.633  77.863  1.00 25.95           C
ATOM    125  C   LEU    14       7.227  42.813  78.792  1.00 20.70           C
ATOM    126  O   LEU    14       7.279  44.014  78.491  1.00 21.38           O
ATOM    127  N   ALA    15       8.195  42.183  79.445  1.00 20.70           N
ATOM    128  CA  ALA    15       9.386  42.843  79.946  1.00 21.53           C
ATOM    129  CB  ALA    15       9.167  43.257  81.419  1.00 22.22           C
ATOM    130  C   ALA    15      10.568  41.890  79.847  1.00 21.56           C
ATOM    131  O   ALA    15      10.417  40.686  80.082  1.00 20.75           O
ATOM    132  N   ASP    16      11.748  42.401  79.485  1.00 21.65           N
ATOM    133  CA  ASP    16      12.918  41.546  79.546  1.00 21.72           C
ATOM    134  CB  ASP    16      13.931  41.880  78.453  1.00 22.91           C
ATOM    135  CG  ASP    16      15.158  40.970  78.479  1.00 22.98           C
ATOM    136  OD1 ASP    16      15.256  40.068  79.357  1.00 22.97           O
ATOM    137  OD2 ASP    16      16.035  41.171  77.614  1.00 21.32           O
ATOM    138  C   ASP    16      13.533  41.709  80.935  1.00 22.65           C
ATOM    139  O   ASP    16      14.294  42.647  81.179  1.00 22.64           O
ATOM    140  N   SER    17      13.214  40.769  81.827  1.00 22.73           N
ATOM    141  CA  SER    17      13.740  40.776  83.181  1.00 24.42           C
ATOM    142  CB  SER    17      12.653  40.291  84.135  1.00 23.74           C
ATOM    143  OG  SER    17      12.089  39.109  83.579  1.00 28.12           O
ATOM    144  C   SER    17      14.977  39.871  83.334  1.00 25.00           C
ATOM    145  O   SER    17      15.425  39.655  84.452  1.00 25.03           O
ATOM    146  N   SER    18      15.512  39.351  82.219  1.00 24.93           N
ATOM    147  CA  SER    18      16.539  38.297  82.275  1.00 25.48           C
ATOM    148  CB  SER    18      16.815  37.713  80.860  1.00 24.70           C
ATOM    149  OG  SER    18      17.501  38.638  80.023  1.00 23.20           O
ATOM    150  C   SER    18      17.860  38.750  82.945  1.00 25.77           C
ATOM    151  O   SER    18      18.536  37.947  83.585  1.00 25.96           O
ATOM    152  N   ARG    19      18.228  40.019  82.802  1.00 25.80           N
ATOM    153  CA  ARG    19      19.454  40.500  83.446  0.50 26.04           C
ATOM    155  CB  ARG    19      19.863  41.870  82.902  0.50 26.63           C
ATOM    157  CG  ARG    19      20.266  41.792  81.431  0.50 28.42           C
ATOM    159  CD  ARG    19      20.814  43.097  80.908  0.50 33.31           C
ATOM    161  NE  ARG    19      22.100  43.450  81.509  0.50 36.36           N
ATOM    163  CZ  ARG    19      23.284  43.173  80.967  0.50 38.03           C
ATOM    165  NH1 ARG    19      23.360  42.527  79.802  0.50 37.79           N
ATOM    167  NH2 ARG    19      24.395  43.547  81.592  0.50 38.32           N
ATOM    169  C   ARG    19      19.328  40.492  84.970  1.00 26.05           C
ATOM    170  O   ARG    19      20.254  40.032  85.653  1.00 25.56           O
ATOM    171  N   GLY    20      18.185  40.978  85.489  1.00 25.65           N
ATOM    172  CA  GLY    20      17.898  40.939  86.941  1.00 25.86           C
ATOM    173  C   GLY    20      17.802  39.514  87.472  1.00 25.67           C
ATOM    174  O   GLY    20      18.340  39.205  88.531  1.00 25.83           O
ATOM    175  N   ILE    21      17.082  38.657  86.746  1.00 25.96           N
ATOM    176  CA  ILE    21      16.930  37.230  87.086  1.00 24.89           C
ATOM    177  CB  ILE    21      15.928  36.485  86.153  1.00 24.71           C
ATOM    178  CG1 ILE    21      14.468  37.000  86.334  1.00 22.97           C
ATOM    179  CD1 ILE    21      13.486  36.498  85.345  1.00 23.93           C
ATOM    180  CG2 ILE    21      15.993  34.939  86.382  1.00 24.75           C
ATOM    181  C   ILE    21      18.272  36.513  87.118  1.00 25.94           C
ATOM    182  O   ILE    21      18.568  35.813  88.092  1.00 28.04           O
ATOM    183  N   VAL    22      19.102  36.677  86.098  1.00 25.95           N
ATOM    184  CA  VAL    22      20.438  36.039  86.110  1.00 26.55           C
ATOM    185  CB  VAL    22      21.199  36.235  84.782  1.00 27.39           C
ATOM    186  CG1 VAL    22      22.753  35.940  84.948  1.00 26.72           C
ATOM    187  CG2 VAL    22      20.569  35.413  83.637  1.00 26.40           C
ATOM    188  C   VAL    22      21.314  36.546  87.267  1.00 26.76           C
ATOM    189  O   VAL    22      22.037  35.767  87.887  1.00 25.07           O
ATOM    190  N   THR    23      21.254  37.854  87.561  1.00 27.27           N
ATOM    191  CA  THR    23      22.043  38.424  88.674  1.00 27.43           C
ATOM    192  CB  THR    23      21.883  39.950  88.741  1.00 28.02           C
ATOM    193  OG1 THR    23      22.366  40.506  87.529  1.00 28.87           O
ATOM    194  CG2 THR    23      22.672  40.545  89.947  1.00 28.56           C
ATOM    195  C   THR    23      21.670  37.808  90.029  1.00 27.05           C
ATOM    196  O   THR    23      22.537  37.469  90.850  1.00 26.13           O
ATOM    197  N   CYS    24      20.369  37.652  90.254  1.00 26.85           N
ATOM    198  CA  CYS    24      19.873  37.136  91.525  1.00 26.73           C
ATOM    199  CB  CYS    24      18.362  37.448  91.682  1.00 25.40           C
ATOM    200  SG  CYS    24      18.046  39.289  91.751  1.00 25.35           S
ATOM    201  C   CYS    24      20.150  35.630  91.705  1.00 27.56           C
ATOM    202  O   CYS    24      20.584  35.192  92.794  1.00 27.03           O
ATOM    203  N   PHE    25      19.901  34.853  90.650  1.00 27.63           N
ATOM    204  CA  PHE    25      20.230  33.414  90.679  1.00 28.09           C
ATOM    205  CB  PHE    25      19.819  32.678  89.403  1.00 26.94           C
ATOM    206  CG  PHE    25      18.417  32.106  89.449  1.00 29.51           C
ATOM    207  CD1 PHE    25      17.426  32.624  88.629  1.00 27.94           C
ATOM    208  CE1 PHE    25      16.112  32.110  88.663  1.00 28.76           C
ATOM    209  CZ  PHE    25      15.799  31.079  89.552  1.00 27.62           C
ATOM    210  CE2 PHE    25      16.803  30.546  90.375  1.00 31.73           C
ATOM    211  CD2 PHE    25      18.097  31.047  90.314  1.00 28.80           C
ATOM    212  C   PHE    25      21.703  33.222  90.899  1.00 27.74           C
ATOM    213  O   PHE    25      22.097  32.354  91.684  1.00 29.15           O
ATOM    214  N   ARG    26      22.524  34.010  90.213  1.00 27.88           N
ATOM    215  CA  ARG    26      23.978  33.823  90.308  1.00 28.42           C
ATOM    216  CB  ARG    26      24.713  34.601  89.198  1.00 28.29           C
ATOM    217  CG  ARG    26      26.238  34.359  89.167  1.00 29.57           C
ATOM    218  CD  ARG    26      26.980  34.899  87.936  1.00 29.18           C
ATOM    219  NE  ARG    26      26.549  34.419  86.600  1.00 30.97           N
ATOM    220  CZ  ARG    26      26.561  33.155  86.165  1.00 30.81           C
ATOM    221  NH1 ARG    26      26.934  32.159  86.957  1.00 30.26           N
ATOM    222  NH2 ARG    26      26.155  32.877  84.929  1.00 27.64           N
ATOM    223  C   ARG    26      24.526  34.138  91.711  1.00 28.16           C
ATOM    224  O   ARG    26      25.384  33.418  92.226  1.00 27.54           O
ATOM    225  N   SER    27      24.056  35.235  92.319  1.00 27.95           N
ATOM    226  CA  SER    27      24.483  35.597  93.666  0.50 27.47           C
ATOM    228  CB  SER    27      23.739  36.840  94.141  0.50 27.42           C
ATOM    230  OG  SER    27      24.178  37.951  93.400  0.50 27.80           O
ATOM    232  C   SER    27      24.271  34.432  94.639  1.00 27.30           C
ATOM    233  O   SER    27      25.197  34.015  95.305  1.00 27.61           O
ATOM    234  N   VAL    28      23.052  33.905  94.686  1.00 26.45           N
ATOM    235  CA  VAL    28      22.674  32.755  95.531  1.00 26.89           C
ATOM    236  CB  VAL    28      21.135  32.478  95.479  1.00 27.16           C
ATOM    237  CG1 VAL    28      20.756  31.357  96.422  1.00 24.69           C
ATOM    238  CG2 VAL    28      20.357  33.764  95.817  1.00 26.07           C
ATOM    239  C   VAL    28      23.447  31.484  95.190  1.00 27.64           C
ATOM    240  O   VAL    28      24.032  30.875  96.082  1.00 28.22           O
ATOM    241  N   LEU    29      23.503  31.099  93.912  1.00 27.37           N
ATOM    242  CA  LEU    29      24.213  29.857  93.522  1.00 28.25           C
ATOM    243  CB  LEU    29      24.109  29.593  92.015  1.00 28.45           C
ATOM    244  CG  LEU    29      22.726  29.208  91.464  1.00 29.00           C
ATOM    245  CD1 LEU    29      22.666  29.470  89.947  1.00 26.59           C
ATOM    246  CD2 LEU    29      22.373  27.730  91.821  1.00 29.02           C
ATOM    247  C   LEU    29      25.678  29.901  93.916  1.00 28.97           C
ATOM    248  O   LEU    29      26.217  28.916  94.424  1.00 28.08           O
ATOM    249  N   GLU    30      26.300  31.069  93.709  1.00 28.53           N
ATOM    250  CA  GLU    30      27.712  31.226  93.990  1.00 29.77           C
ATOM    251  CB  GLU    30      28.324  32.327  93.104  1.00 29.25           C
ATOM    252  CG  GLU    30      28.123  31.934  91.613  1.00 32.11           C
ATOM    253  CD  GLU    30      28.977  32.698  90.590  1.00 33.14           C
ATOM    254  OE1 GLU    30      29.451  33.828  90.882  1.00 36.50           O
ATOM    255  OE2 GLU    30      29.133  32.147  89.461  1.00 36.09           O
ATOM    256  C   GLU    30      28.017  31.373  95.490  1.00 29.27           C
ATOM    257  O   GLU    30      29.077  30.947  95.931  1.00 28.69           O
ATOM    258  N   ARG    31      27.092  31.924  96.283  1.00 28.86           N
ATOM    259  CA  ARG    31      27.307  31.954  97.728  0.50 28.90           C
ATOM    261  CB  ARG    31      26.330  32.888  98.438  0.50 28.90           C
ATOM    263  CG  ARG    31      26.840  34.324  98.552  0.50 30.25           C
ATOM    265  CD  ARG    31      25.762  35.237  99.124  0.50 32.63           C
ATOM    267  NE  ARG    31      25.933  36.640  98.735  0.50 32.56           N
ATOM    269  CZ  ARG    31      25.025  37.587  98.954  0.50 32.41           C
ATOM    271  NH1 ARG    31      23.886  37.285  99.557  0.50 33.58           N
ATOM    273  NH2 ARG    31      25.247  38.835  98.564  0.50 32.58           N
ATOM    275  C   ARG    31      27.259  30.550  98.320  1.00 28.59           C
ATOM    276  O   ARG    31      27.828  30.299  99.380  1.00 28.07           O
ATOM    277  N   HIS    32      26.606  29.629  97.618  1.00 28.11           N
ATOM    278  CA  HIS    32      26.520  28.213  98.056  1.00 27.36           C
ATOM    279  CB  HIS    32      25.082  27.701  97.993  1.00 27.06           C
ATOM    280  CG  HIS    32      24.166  28.439  98.915  1.00 29.75           C
ATOM    281  ND1 HIS    32      23.935  28.037 100.210  1.00 29.90           N
ATOM    282  CE1 HIS    32      23.122  28.891 100.798  1.00 31.29           C
ATOM    283  NE2 HIS    32      22.823  29.844  99.931  1.00 33.43           N
ATOM    284  CD2 HIS    32      23.481  29.596  98.752  1.00 29.72           C
ATOM    285  C   HIS    32      27.458  27.267  97.335  1.00 26.95           C
ATOM    286  O   HIS    32      27.357  26.045  97.477  1.00 26.82           O
ATOM    287  N   GLY    33      28.396  27.823  96.585  1.00 27.08           N
ATOM    288  CA  GLY    33      29.522  27.029  96.079  1.00 27.82           C
ATOM    289  C   GLY    33      29.279  26.510  94.672  1.00 28.67           C
ATOM    290  O   GLY    33      30.111  25.775  94.150  1.00 29.18           O
ATOM    291  N   TYR    34      28.154  26.893  94.055  1.00 28.41           N
ATOM    292  CA  TYR    34      27.799  26.396  92.732  1.00 29.53           C
ATOM    293  CB  TYR    34      26.258  26.328  92.567  1.00 30.17           C
ATOM    294  CG  TYR    34      25.622  25.328  93.505  1.00 30.57           C
ATOM    295  CD1 TYR    34      25.627  23.965  93.200  1.00 30.85           C
ATOM    296  CE1 TYR    34      25.053  23.041  94.032  1.00 28.91           C
ATOM    297  CZ  TYR    34      24.477  23.460  95.208  1.00 28.86           C
ATOM    298  OH  TYR    34      23.926  22.531  96.026  1.00 29.07           O
ATOM    299  CE2 TYR    34      24.438  24.804  95.551  1.00 30.83           C
ATOM    300  CD2 TYR    34      25.026  25.733  94.694  1.00 31.63           C
ATOM    301  C   TYR    34      28.450  27.246  91.654  1.00 30.28           C
ATOM    302  O   TYR    34      28.035  28.383  91.420  1.00 32.50           O
ATOM    303  N   THR    35      29.473  26.706  91.004  1.00 30.34           N
ATOM    304  CA  THR    35      30.226  27.444  89.992  1.00 30.36           C
ATOM    305  CB  THR    35      31.744  27.439  90.295  1.00 30.15           C
ATOM    306  OG1 THR    35      32.207  26.087  90.373  1.00 31.03           O
ATOM    307  CG2 THR    35      32.043  28.122  91.593  1.00 30.29           C
ATOM    308  C   THR    35      30.011  26.858  88.601  1.00 30.09           C
ATOM    309  O   THR    35      29.478  25.759  88.459  1.00 29.73           O
ATOM    310  N   GLY    36      30.423  27.616  87.579  1.00 30.97           N
ATOM    311  CA  GLY    36      30.337  27.193  86.168  1.00 31.00           C
ATOM    312  C   GLY    36      28.913  26.995  85.649  1.00 31.00           C
ATOM    313  O   GLY    36      28.680  26.242  84.692  1.00 31.06           O
ATOM    314  N   ILE    37      27.957  27.645  86.303  1.00 30.10           N
ATOM    315  CA  ILE    37      26.598  27.671  85.777  1.00 29.29           C
ATOM    316  CB  ILE    37      25.566  27.724  86.897  1.00 29.00           C
ATOM    317  CG1 ILE    37      25.581  26.392  87.649  1.00 28.44           C
ATOM    318  CD1 ILE    37      24.913  26.451  88.976  1.00 28.07           C
ATOM    319  CG2 ILE    37      24.167  28.102  86.320  1.00 28.30           C
ATOM    320  C   ILE    37      26.493  28.882  84.880  1.00 28.98           C
ATOM    321  O   ILE    37      26.659  30.007  85.347  1.00 30.36           O
ATOM    322  N   THR    38      26.216  28.652  83.598  1.00 28.66           N
ATOM    323  CA  THR    38      26.144  29.711  82.585  1.00 28.14           C
ATOM    324  CB  THR    38      26.280  29.130  81.169  1.00 28.45           C
ATOM    325  OG1 THR    38      25.087  28.398  80.837  1.00 28.74           O
ATOM    326  CG2 THR    38      27.513  28.237  81.063  1.00 26.51           C
ATOM    327  C   THR    38      24.845  30.529  82.605  1.00 27.96           C
ATOM    328  O   THR    38      23.821  30.081  83.120  1.00 27.32           O
ATOM    329  N   ASP    39      24.897  31.739  82.034  1.00 27.46           N
ATOM    330  CA  ASP    39      23.714  32.551  81.894  1.00 27.38           C
ATOM    331  CB  ASP    39      24.037  33.817  81.100  1.00 27.60           C
ATOM    332  CG  ASP    39      24.785  34.880  81.927  1.00 31.78           C
ATOM    333  OD1 ASP    39      25.298  34.578  83.030  1.00 29.76           O
ATOM    334  OD2 ASP    39      24.860  36.041  81.445  1.00 36.82           O
ATOM    335  C   ASP    39      22.581  31.773  81.181  1.00 26.62           C
ATOM    336  O   ASP    39      21.426  31.826  81.579  1.00 24.83           O
ATOM    337  N   ASP    40      22.918  31.086  80.096  1.00 27.24           N
ATOM    338  CA  ASP    40      21.919  30.311  79.342  1.00 27.15           C
ATOM    339  CB  ASP    40      22.520  29.713  78.068  1.00 27.25           C
ATOM    340  CG  ASP    40      22.692  30.744  76.967  1.00 29.12           C
ATOM    341  OD1 ASP    40      22.169  31.883  77.079  1.00 31.87           O
ATOM    342  OD2 ASP    40      23.385  30.427  75.997  1.00 31.62           O
ATOM    343  C   ASP    40      21.226  29.238  80.146  1.00 26.69           C
ATOM    344  O   ASP    40      20.010  29.019  79.964  1.00 26.44           O
ATOM    345  N   MET    41      21.990  28.545  80.996  1.00 27.53           N
ATOM    346  CA  MET    41      21.426  27.505  81.881  1.00 27.55           C
ATOM    347  CB  MET    41      22.518  26.766  82.672  1.00 28.11           C
ATOM    348  CG  MET    41      23.386  25.824  81.832  1.00 27.79           C
ATOM    349  SD  MET    41      24.933  25.250  82.817  0.70 27.86          SE
ATOM    350  CE  MET    41      26.300  25.146  81.476  1.00 33.34           C
ATOM    351  C   MET    41      20.394  28.130  82.818  1.00 26.96           C
ATOM    352  O   MET    41      19.331  27.583  83.044  1.00 26.08           O
ATOM    353  N   ILE    42      20.699  29.311  83.318  1.00 26.33           N
ATOM    354  CA  ILE    42      19.756  30.031  84.158  1.00 25.61           C
ATOM    355  CB  ILE    42      20.467  31.166  84.926  1.00 26.25           C
ATOM    356  CG1 ILE    42      21.518  30.578  85.900  1.00 25.24           C
ATOM    357  CD1 ILE    42      22.476  31.678  86.549  1.00 26.44           C
ATOM    358  CG2 ILE    42      19.420  32.075  85.688  1.00 26.19           C
ATOM    359  C   ILE    42      18.535  30.514  83.347  1.00 25.25           C
ATOM    360  O   ILE    42      17.389  30.269  83.724  1.00 24.15           O
ATOM    361  N   LYS    43      18.796  31.173  82.222  1.00 25.38           N
ATOM    362  CA  LYS    43      17.745  31.762  81.378  1.00 25.62           C
ATOM    363  CB  LYS    43      18.346  32.551  80.214  1.00 26.03           C
ATOM    364  CG  LYS    43      19.143  33.810  80.616  1.00 26.23           C
ATOM    365  CD  LYS    43      19.957  34.262  79.388  1.00 24.38           C
ATOM    366  CE  LYS    43      20.240  35.735  79.486  1.00 27.35           C
ATOM    367  NZ  LYS    43      20.904  36.212  78.237  1.00 26.10           N
ATOM    368  C   LYS    43      16.764  30.710  80.868  1.00 25.85           C
ATOM    369  O   LYS    43      15.580  30.994  80.724  1.00 24.83           O
ATOM    370  N   ARG    44      17.245  29.490  80.614  1.00 26.35           N
ATOM    371  CA  ARG    44      16.340  28.422  80.197  1.00 26.97           C
ATOM    372  CB  ARG    44      17.104  27.195  79.656  1.00 26.69           C
ATOM    373  CG  ARG    44      17.754  27.390  78.281  1.00 30.37           C
ATOM    374  CD  ARG    44      16.801  27.313  77.108  1.00 35.96           C
ATOM    375  NE  ARG    44      16.393  25.938  76.823  1.00 40.15           N
ATOM    376  CZ  ARG    44      15.490  25.586  75.902  1.00 42.70           C
ATOM    377  NH1 ARG    44      14.886  26.506  75.145  1.00 41.39           N
ATOM    378  NH2 ARG    44      15.193  24.300  75.727  1.00 43.13           N
ATOM    379  C   ARG    44      15.321  28.009  81.277  1.00 27.28           C
ATOM    380  O   ARG    44      14.303  27.401  80.948  1.00 27.71           O
ATOM    381  N   THR    45      15.593  28.311  82.547  1.00 27.15           N
ATOM    382  CA  THR    45      14.644  28.019  83.619  1.00 27.61           C
ATOM    383  CB  THR    45      15.326  27.716  84.985  1.00 27.21           C
ATOM    384  OG1 THR    45      15.843  28.937  85.551  1.00 29.09           O
ATOM    385  CG2 THR    45      16.436  26.718  84.856  1.00 27.55           C
ATOM    386  C   THR    45      13.690  29.185  83.899  1.00 27.14           C
ATOM    387  O   THR    45      12.780  29.023  84.684  1.00 28.51           O
ATOM    388  N   ILE    46      13.924  30.360  83.309  1.00 26.38           N
ATOM    389  CA  ILE    46      13.058  31.514  83.513  1.00 24.81           C
ATOM    390  CB  ILE    46      13.543  32.775  82.746  1.00 24.83           C
ATOM    391  CG1 ILE    46      14.857  33.293  83.339  1.00 25.02           C
ATOM    392  CD1 ILE    46      15.489  34.510  82.591  1.00 22.94           C
ATOM    393  CG2 ILE    46      12.504  33.893  82.822  1.00 26.55           C
ATOM    394  C   ILE    46      11.598  31.192  83.185  1.00 24.69           C
ATOM    395  O   ILE    46      11.268  30.770  82.062  1.00 25.30           O
ATOM    396  N   GLY    47      10.732  31.392  84.180  1.00 24.91           N
ATOM    397  CA  GLY    47       9.279  31.139  84.076  1.00 23.33           C
ATOM    398  C   GLY    47       8.809  29.870  84.793  1.00 23.77           C
ATOM    399  O   GLY    47       7.591  29.536  84.791  1.00 23.52           O
ATOM    400  N   LYS    48       9.783  29.127  85.336  1.00 22.70           N
ATOM    401  CA  LYS    48       9.524  28.036  86.281  1.00 23.25           C
ATOM    402  CB  LYS    48      10.654  27.002  86.214  1.00 22.45           C
ATOM    403  CG  LYS    48      10.857  26.464  84.806  1.00 27.54           C
ATOM    404  CD  LYS    48      11.350  25.061  84.810  1.00 32.31           C
ATOM    405  CE  LYS    48      11.689  24.601  83.391  1.00 36.95           C
ATOM    406  NZ  LYS    48      10.491  23.938  82.814  1.00 36.79           N
ATOM    407  C   LYS    48       9.493  28.706  87.663  1.00 22.37           C
ATOM    408  O   LYS    48       9.928  29.880  87.789  1.00 21.60           O
ATOM    409  N   THR    49       8.989  28.002  88.676  1.00 21.17           N
ATOM    410  CA  THR    49       9.003  28.561  90.050  1.00 22.17           C
ATOM    411  CB  THR    49       8.244  27.708  91.077  1.00 20.87           C
ATOM    412  OG1 THR    49       8.903  26.437  91.242  1.00 23.38           O
ATOM    413  CG2 THR    49       6.760  27.488  90.620  1.00 20.40           C
ATOM    414  C   THR    49      10.457  28.665  90.522  1.00 23.46           C
ATOM    415  O   THR    49      11.310  27.913  90.059  1.00 22.38           O
ATOM    416  N   LEU    50      10.739  29.592  91.434  1.00 24.65           N
ATOM    417  CA  LEU    50      12.127  29.725  91.953  1.00 25.29           C
ATOM    418  CB  LEU    50      12.165  30.782  93.045  1.00 25.19           C
ATOM    419  CG  LEU    50      11.881  32.192  92.531  1.00 24.76           C
ATOM    420  CD1 LEU    50      11.707  33.216  93.678  1.00 24.83           C
ATOM    421  CD2 LEU    50      12.921  32.656  91.473  1.00 24.86           C
ATOM    422  C   LEU    50      12.635  28.392  92.498  1.00 25.72           C
ATOM    423  O   LEU    50      13.784  28.031  92.259  1.00 26.37           O
ATOM    424  N   GLU    51      11.762  27.644  93.193  1.00 26.27           N
ATOM    425  CA  GLU    51      12.133  26.327  93.712  1.00 26.53           C
ATOM    426  CB  GLU    51      11.067  25.753  94.662  1.00 26.95           C
ATOM    427  CG  GLU    51      10.799  26.612  95.935  1.00 27.91           C
ATOM    428  CD  GLU    51       9.631  27.616  95.747  1.00 30.98           C
ATOM    429  OE1 GLU    51       9.531  28.225  94.651  1.00 27.84           O
ATOM    430  OE2 GLU    51       8.818  27.796  96.697  1.00 29.30           O
ATOM    431  C   GLU    51      12.495  25.361  92.563  1.00 26.70           C
ATOM    432  O   GLU    51      13.543  24.693  92.622  1.00 26.65           O
ATOM    433  N   GLU    52      11.646  25.293  91.523  1.00 27.02           N
ATOM    434  CA  GLU    52      11.931  24.453  90.331  1.00 26.69           C
ATOM    435  CB  GLU    52      10.818  24.546  89.280  1.00 26.89           C
ATOM    436  CG  GLU    52       9.565  23.708  89.616  1.00 28.41           C
ATOM    437  CD  GLU    52       8.298  24.195  88.906  1.00 28.69           C
ATOM    438  OE1 GLU    52       8.320  25.246  88.220  1.00 31.19           O
ATOM    439  OE2 GLU    52       7.255  23.527  89.047  1.00 31.98           O
ATOM    440  C   GLU    52      13.278  24.832  89.707  1.00 26.26           C
ATOM    441  O   GLU    52      14.060  23.956  89.329  1.00 24.51           O
ATOM    442  N   SER    53      13.532  26.142  89.600  1.00 25.45           N
ATOM    443  CA  SER    53      14.754  26.635  88.976  1.00 26.02           C
ATOM    444  CB  SER    53      14.733  28.183  88.851  1.00 26.87           C
ATOM    445  OG  SER    53      13.863  28.622  87.824  1.00 26.36           O
ATOM    446  C   SER    53      15.994  26.192  89.745  1.00 25.31           C
ATOM    447  O   SER    53      16.960  25.740  89.144  1.00 26.23           O
ATOM    448  N   PHE    54      15.943  26.324  91.074  1.00 24.48           N
ATOM    449  CA  PHE    54      17.041  25.939  91.939  1.00 24.94           C
ATOM    450  CB  PHE    54      16.828  26.429  93.379  1.00 24.22           C
ATOM    451  CG  PHE    54      17.314  27.821  93.595  1.00 24.36           C
ATOM    452  CD1 PHE    54      18.692  28.100  93.537  1.00 25.21           C
ATOM    453  CE1 PHE    54      19.151  29.414  93.696  1.00 23.93           C
ATOM    454  CZ  PHE    54      18.245  30.469  93.922  1.00 22.16           C
ATOM    455  CE2 PHE    54      16.879  30.206  93.962  1.00 21.57           C
ATOM    456  CD2 PHE    54      16.424  28.860  93.808  1.00 24.28           C
ATOM    457  C   PHE    54      17.269  24.459  91.906  1.00 25.07           C
ATOM    458  O   PHE    54      18.403  24.013  91.957  1.00 25.61           O
ATOM    459  N   SER    55      16.185  23.697  91.814  1.00 25.58           N
ATOM    460  CA  SER    55      16.289  22.240  91.782  1.00 25.02           C
ATOM    461  CB  SER    55      14.885  21.632  91.952  1.00 25.86           C
ATOM    462  OG  SER    55      15.001  20.280  92.366  1.00 28.30           O
ATOM    463  C   SER    55      16.974  21.726  90.521  1.00 25.49           C
ATOM    464  O   SER    55      17.877  20.852  90.563  1.00 24.97           O
ATOM    465  N   ILE    56      16.567  22.276  89.382  1.00 25.10           N
ATOM    466  CA  ILE    56      17.206  21.977  88.089  1.00 24.88           C
ATOM    467  CB  ILE    56      16.501  22.738  86.958  1.00 23.93           C
ATOM    468  CG1 ILE    56      15.098  22.148  86.700  1.00 24.64           C
ATOM    469  CD1 ILE    56      14.219  23.069  85.849  1.00 26.32           C
ATOM    470  CG2 ILE    56      17.285  22.712  85.666  1.00 23.81           C
ATOM    471  C   ILE    56      18.725  22.286  88.101  1.00 25.96           C
ATOM    472  O   ILE    56      19.548  21.464  87.658  1.00 26.22           O
ATOM    473  N   LEU    57      19.077  23.437  88.643  1.00 25.28           N
ATOM    474  CA  LEU    57      20.452  23.926  88.580  1.00 26.41           C
ATOM    475  CB  LEU    57      20.476  25.473  88.677  1.00 26.10           C
ATOM    476  CG  LEU    57      19.797  26.281  87.549  1.00 25.31           C
ATOM    477  CD1 LEU    57      19.590  27.811  87.876  1.00 24.42           C
ATOM    478  CD2 LEU    57      20.549  26.150  86.258  1.00 23.96           C
ATOM    479  C   LEU    57      21.404  23.285  89.603  1.00 26.46           C
ATOM    480  O   LEU    57      22.597  23.162  89.332  1.00 27.03           O
ATOM    481  N   THR    58      20.890  22.907  90.779  1.00 26.54           N
ATOM    482  CA  THR    58      21.703  22.296  91.848  1.00 25.19           C
ATOM    483  CB  THR    58      21.407  22.960  93.218  1.00 24.76           C
ATOM    484  OG1 THR    58      20.040  22.701  93.558  1.00 22.88           O
ATOM    485  CG2 THR    58      21.592  24.487  93.148  1.00 23.07           C
ATOM    486  C   THR    58      21.414  20.794  92.006  1.00 25.76           C
ATOM    487  O   THR    58      22.217  20.058  92.544  1.00 27.33           O
ATOM    488  N   GLY    59      20.252  20.343  91.561  1.00 25.51           N
ATOM    489  CA  GLY    59      19.789  18.997  91.902  1.00 24.36           C
ATOM    490  C   GLY    59      19.194  18.863  93.306  1.00 24.11           C
ATOM    491  O   GLY    59      18.716  17.795  93.663  1.00 23.45           O
ATOM    492  N   ILE    60      19.181  19.933  94.109  1.00 24.01           N
ATOM    493  CA  ILE    60      18.608  19.829  95.456  0.60 24.03           C
ATOM    495  CB  ILE    60      18.996  21.031  96.372  0.60 24.36           C
ATOM    497  CG1 ILE    60      20.453  20.901  96.820  0.60 24.92           C
ATOM    499  CD1 ILE    60      21.041  22.199  97.316  0.60 25.59           C
ATOM    501  CG2 ILE    60      18.063  21.154  97.600  0.60 22.40           C
ATOM    503  C   ILE    60      17.097  19.657  95.359  1.00 23.93           C
ATOM    504  O   ILE    60      16.445  20.324  94.582  1.00 24.92           O
ATOM    505  N   THR    61      16.553  18.731  96.142  1.00 24.07           N
ATOM    506  CA  THR    61      15.102  18.557  96.226  1.00 24.63           C
ATOM    507  CB  THR    61      14.642  17.146  95.788  1.00 25.05           C
ATOM    508  OG1 THR    61      15.257  16.165  96.623  1.00 25.67           O
ATOM    509  CG2 THR    61      15.008  16.884  94.295  1.00 23.70           C
ATOM    510  C   THR    61      14.546  18.812  97.622  1.00 25.41           C
ATOM    511  O   THR    61      13.327  18.874  97.799  1.00 25.44           O
ATOM    512  N   ASP    62      15.414  18.953  98.616  1.00 25.97           N
ATOM    513  CA  ASP    62      14.940  19.168  99.975  1.00 26.85           C
ATOM    514  CB  ASP    62      16.123  19.263 100.924  1.00 27.34           C
ATOM    515  CG  ASP    62      15.686  19.493 102.364  1.00 27.87           C
ATOM    516  OD1 ASP    62      15.320  18.536 103.033  1.00 26.73           O
ATOM    517  OD2 ASP    62      15.681  20.648 102.808  1.00 29.98           O
ATOM    518  C   ASP    62      14.055  20.416 100.096  1.00 27.29           C
ATOM    519  O   ASP    62      14.498  21.513  99.759  1.00 27.17           O
ATOM    520  N   ALA    63      12.815  20.247 100.578  1.00 27.89           N
ATOM    521  CA  ALA    63      11.841  21.362 100.623  1.00 28.56           C
ATOM    522  CB  ALA    63      10.473  20.885 101.185  1.00 29.00           C
ATOM    523  C   ALA    63      12.365  22.574 101.413  1.00 28.72           C
ATOM    524  O   ALA    63      12.181  23.737 100.997  1.00 28.41           O
ATOM    525  N   ASP    64      13.062  22.286 102.519  1.00 28.89           N
ATOM    526  CA  ASP    64      13.636  23.318 103.381  1.00 29.22           C
ATOM    527  CB  ASP    64      14.104  22.745 104.727  1.00 29.26           C
ATOM    528  CG  ASP    64      12.955  22.355 105.612  1.00 31.48           C
ATOM    529  OD1 ASP    64      11.883  22.985 105.491  1.00 33.02           O
ATOM    530  OD2 ASP    64      13.117  21.425 106.436  1.00 32.85           O
ATOM    531  C   ASP    64      14.761  24.101 102.734  1.00 28.56           C
ATOM    532  O   ASP    64      14.778  25.332 102.821  1.00 27.54           O
ATOM    533  N   GLN    65      15.693  23.399 102.094  1.00 28.14           N
ATOM    534  CA  GLN    65      16.797  24.053 101.374  1.00 28.49           C
ATOM    535  CB  GLN    65      17.810  23.019 100.894  1.00 28.50           C
ATOM    536  CG  GLN    65      18.506  22.248 102.012  1.00 29.11           C
ATOM    537  CD  GLN    65      19.533  21.230 101.486  1.00 31.31           C
ATOM    538  OE1 GLN    65      19.302  20.014 101.549  1.00 36.90           O
ATOM    539  NE2 GLN    65      20.665  21.718 100.968  1.00 31.64           N
ATOM    540  C   GLN    65      16.294  24.925 100.207  1.00 27.91           C
ATOM    541  O   GLN    65      16.720  26.065 100.039  1.00 26.59           O
ATOM    542  N   LEU    66      15.354  24.399  99.424  1.00 27.56           N
ATOM    543  CA  LEU    66      14.760  25.168  98.315  1.00 27.18           C
ATOM    544  CB  LEU    66      13.828  24.262  97.500  1.00 26.84           C
ATOM    545  CG  LEU    66      14.384  23.094  96.659  1.00 25.18           C
ATOM    546  CD1 LEU    66      13.259  22.275  95.982  1.00 26.79           C
ATOM    547  CD2 LEU    66      15.394  23.586  95.617  1.00 26.21           C
ATOM    548  C   LEU    66      14.021  26.436  98.781  1.00 27.05           C
ATOM    549  O   LEU    66      14.030  27.475  98.112  1.00 27.94           O
ATOM    550  N   GLU    67      13.384  26.341  99.942  1.00 26.89           N
ATOM    551  CA  GLU    67      12.700  27.468 100.554  1.00 26.69           C
ATOM    552  CB  GLU    67      11.852  27.010 101.775  1.00 25.64           C
ATOM    553  CG  GLU    67      11.223  28.113 102.640  1.00 25.90           C
ATOM    554  CD  GLU    67      10.382  29.109 101.877  1.00 26.46           C
ATOM    555  OE1 GLU    67       9.834  28.789 100.804  1.00 28.66           O
ATOM    556  OE2 GLU    67      10.256  30.247 102.350  1.00 27.59           O
ATOM    557  C   GLU    67      13.737  28.504 100.941  1.00 26.18           C
ATOM    558  O   GLU    67      13.521  29.697 100.822  1.00 27.27           O
ATOM    559  N   SER    68      14.864  28.030 101.412  1.00 25.95           N
ATOM    560  CA  SER    68      15.911  28.898 101.879  1.00 26.31           C
ATOM    561  CB  SER    68      16.905  28.051 102.681  1.00 27.25           C
ATOM    562  OG  SER    68      17.994  28.784 103.157  1.00 29.24           O
ATOM    563  C   SER    68      16.535  29.651 100.699  1.00 26.07           C
ATOM    564  O   SER    68      16.763  30.856 100.805  1.00 25.00           O
ATOM    565  N   PHE    69      16.778  28.949  99.576  1.00 25.50           N
ATOM    566  CA  PHE    69      17.248  29.581  98.336  1.00 25.19           C
ATOM    567  CB  PHE    69      17.395  28.567  97.206  1.00 24.70           C
ATOM    568  CG  PHE    69      18.512  27.567  97.370  1.00 25.53           C
ATOM    569  CD1 PHE    69      19.702  27.887  98.035  1.00 26.70           C
ATOM    570  CE1 PHE    69      20.716  26.931  98.150  1.00 28.65           C
ATOM    571  CZ  PHE    69      20.562  25.651  97.571  1.00 27.03           C
ATOM    572  CE2 PHE    69      19.400  25.335  96.879  1.00 26.24           C
ATOM    573  CD2 PHE    69      18.379  26.292  96.790  1.00 24.38           C
ATOM    574  C   PHE    69      16.257  30.631  97.865  1.00 24.69           C
ATOM    575  O   PHE    69      16.655  31.729  97.486  1.00 25.89           O
ATOM    576  N   ARG    70      14.963  30.295  97.896  1.00 24.28           N
ATOM    577  CA  ARG    70      13.876  31.203  97.490  1.00 23.48           C
ATOM    578  CB  ARG    70      12.516  30.535  97.711  1.00 23.43           C
ATOM    579  CG  ARG    70      11.343  31.373  97.169  1.00 25.93           C
ATOM    580  CD  ARG    70      10.008  30.924  97.709  1.00 25.22           C
ATOM    581  NE  ARG    70       9.848  31.220  99.143  1.00 26.87           N
ATOM    582  CZ  ARG    70       9.657  32.446  99.638  1.00 27.45           C
ATOM    583  NH1 ARG    70       9.620  33.480  98.814  1.00 26.75           N
ATOM    584  NH2 ARG    70       9.495  32.643 100.949  1.00 28.49           N
ATOM    585  C   ARG    70      13.917  32.522  98.251  1.00 23.63           C
ATOM    586  O   ARG    70      13.823  33.591  97.647  1.00 22.87           O
ATOM    587  N   GLN    71      13.983  32.423  99.588  1.00 24.69           N
ATOM    588  CA  GLN    71      14.148  33.569 100.473  1.00 24.47           C
ATOM    589  CB  GLN    71      14.208  33.113 101.938  1.00 24.70           C
ATOM    590  CG  GLN    71      12.897  32.571 102.509  1.00 23.50           C
ATOM    591  CD  GLN    71      13.097  31.859 103.828  1.00 24.98           C
ATOM    592  OE1 GLN    71      14.166  31.958 104.450  1.00 26.69           O
ATOM    593  NE2 GLN    71      12.069  31.118 104.266  1.00 23.32           N
ATOM    594  C   GLN    71      15.412  34.369 100.148  1.00 24.87           C
ATOM    595  O   GLN    71      15.378  35.588 100.119  1.00 24.95           O
ATOM    596  N   GLU    72      16.542  33.690  99.980  1.00 24.71           N
ATOM    597  CA  GLU    72      17.777  34.399  99.663  1.00 25.66           C
ATOM    598  CB  GLU    72      18.938  33.406  99.674  1.00 25.45           C
ATOM    599  CG  GLU    72      19.357  32.975 101.071  1.00 26.54           C
ATOM    600  CD  GLU    72      20.359  31.818 101.078  1.00 28.99           C
ATOM    601  OE1 GLU    72      21.071  31.648 100.085  1.00 32.62           O
ATOM    602  OE2 GLU    72      20.431  31.065 102.092  1.00 33.57           O
ATOM    603  C   GLU    72      17.666  35.107  98.301  1.00 25.67           C
ATOM    604  O   GLU    72      18.076  36.264  98.131  1.00 24.17           O
ATOM    605  N   TYR    73      17.052  34.419  97.340  1.00 25.70           N
ATOM    606  CA  TYR    73      16.782  35.028  96.031  1.00 26.68           C
ATOM    607  CB  TYR    73      16.141  33.993  95.088  1.00 27.29           C
ATOM    608  CG  TYR    73      15.817  34.512  93.695  1.00 28.20           C
ATOM    609  CD1 TYR    73      16.590  34.132  92.591  1.00 31.03           C
ATOM    610  CE1 TYR    73      16.285  34.585  91.282  1.00 29.75           C
ATOM    611  CZ  TYR    73      15.199  35.431  91.091  1.00 29.58           C
ATOM    612  OH  TYR    73      14.893  35.862  89.827  1.00 32.21           O
ATOM    613  CE2 TYR    73      14.401  35.810  92.161  1.00 29.04           C
ATOM    614  CD2 TYR    73      14.705  35.338  93.469  1.00 28.75           C
ATOM    615  C   TYR    73      15.905  36.296  96.138  1.00 26.82           C
ATOM    616  O   TYR    73      16.250  37.340  95.564  1.00 26.25           O
ATOM    617  N   SER    74      14.783  36.199  96.862  0.50 26.64           N
ATOM    619  CA  SER    74      13.862  37.328  97.008  0.50 27.01           C
ATOM    621  CB  SER    74      12.685  36.962  97.910  0.50 27.18           C
ATOM    623  OG  SER    74      11.538  37.724  97.557  0.50 26.47           O
ATOM    625  C   SER    74      14.576  38.564  97.555  0.50 27.39           C
ATOM    627  O   SER    74      14.302  39.694  97.129  0.50 27.58           O
ATOM    629  N   LYS    75      15.496  38.332  98.487  1.00 27.15           N
ATOM    630  CA  LYS    75      16.264  39.395  99.111  1.00 28.12           C
ATOM    631  CB  LYS    75      17.103  38.764 100.231  1.00 28.56           C
ATOM    632  CG  LYS    75      17.802  39.682 101.185  1.00 32.79           C
ATOM    633  CD  LYS    75      18.493  38.854 102.259  1.00 38.68           C
ATOM    634  CE  LYS    75      19.947  39.309 102.517  1.00 38.87           C
ATOM    635  NZ  LYS    75      20.549  38.508 103.616  1.00 39.60           N
ATOM    636  C   LYS    75      17.132  40.113  98.068  1.00 27.74           C
ATOM    637  O   LYS    75      17.167  41.341  98.035  1.00 27.27           O
ATOM    638  N   GLU    76      17.836  39.358  97.232  1.00 27.05           N
ATOM    639  CA  GLU    76      18.574  39.934  96.084  1.00 27.52           C
ATOM    640  CB  GLU    76      19.272  38.825  95.298  1.00 28.38           C
ATOM    641  CG  GLU    76      20.420  38.166  96.041  1.00 32.40           C
ATOM    642  CD  GLU    76      21.373  39.177  96.643  1.00 37.32           C
ATOM    643  OE1 GLU    76      22.041  39.882  95.873  1.00 41.38           O
ATOM    644  OE2 GLU    76      21.445  39.279  97.891  1.00 42.83           O
ATOM    645  C   GLU    76      17.646  40.667  95.132  1.00 26.18           C
ATOM    646  O   GLU    76      17.940  41.796  94.680  1.00 25.71           O
ATOM    647  N   ALA    77      16.503  40.036  94.853  1.00 24.98           N
ATOM    648  CA  ALA    77      15.527  40.597  93.911  1.00 25.01           C
ATOM    649  CB  ALA    77      14.441  39.616  93.558  1.00 24.14           C
ATOM    650  C   ALA    77      14.968  41.921  94.385  1.00 25.02           C
ATOM    651  O   ALA    77      14.687  42.790  93.555  1.00 25.34           O
ATOM    652  N   ASP    78      14.808  42.089  95.700  1.00 24.54           N
ATOM    653  CA  ASP    78      14.370  43.367  96.242  1.00 26.20           C
ATOM    654  CB  ASP    78      14.339  43.313  97.762  1.00 26.67           C
ATOM    655  CG  ASP    78      13.163  42.508  98.284  1.00 27.47           C
ATOM    656  OD1 ASP    78      12.146  42.414  97.575  1.00 25.08           O
ATOM    657  OD2 ASP    78      13.260  41.999  99.413  1.00 30.35           O
ATOM    658  C   ASP    78      15.322  44.469  95.810  1.00 26.21           C
ATOM    659  O   ASP    78      14.900  45.567  95.596  1.00 27.41           O
ATOM    660  N   ILE    79      16.608  44.147  95.685  1.00 26.39           N
ATOM    661  CA  ILE    79      17.655  45.100  95.331  1.00 26.83           C
ATOM    662  CB  ILE    79      19.024  44.667  95.967  1.00 26.42           C
ATOM    663  CG1 ILE    79      18.905  44.596  97.489  1.00 28.17           C
ATOM    664  CD1 ILE    79      19.940  43.679  98.124  1.00 32.50           C
ATOM    665  CG2 ILE    79      20.171  45.656  95.620  1.00 26.87           C
ATOM    666  C   ILE    79      17.801  45.282  93.803  1.00 27.25           C
ATOM    667  O   ILE    79      17.844  46.412  93.298  1.00 27.67           O
ATOM    668  N   TYR    80      17.850  44.175  93.065  1.00 28.09           N
ATOM    669  CA  TYR    80      18.283  44.231  91.669  1.00 29.09           C
ATOM    670  CB  TYR    80      19.430  43.251  91.445  1.00 30.35           C
ATOM    671  CG  TYR    80      20.624  43.542  92.288  1.00 31.85           C
ATOM    672  CD1 TYR    80      21.417  44.656  92.027  1.00 33.38           C
ATOM    673  CE1 TYR    80      22.552  44.925  92.804  1.00 34.84           C
ATOM    674  CZ  TYR    80      22.891  44.051  93.829  1.00 34.31           C
ATOM    675  OH  TYR    80      24.003  44.316  94.596  1.00 37.11           O
ATOM    676  CE2 TYR    80      22.118  42.931  94.100  1.00 33.96           C
ATOM    677  CD2 TYR    80      20.994  42.679  93.330  1.00 33.10           C
ATOM    678  C   TYR    80      17.249  43.990  90.600  1.00 28.71           C
ATOM    679  O   TYR    80      17.465  44.332  89.439  1.00 29.24           O
ATOM    680  N   MET    81      16.145  43.358  90.959  1.00 29.54           N
ATOM    681  CA  MET    81      15.196  42.853  89.940  1.00 28.80           C
ATOM    682  CB  MET    81      14.077  42.026  90.588  1.00 28.41           C
ATOM    683  CG  MET    81      13.115  41.381  89.582  1.00 28.54           C
ATOM    684  SD  MET    81      14.037  40.229  88.311  0.70 27.31          SE
ATOM    685  CE  MET    81      14.470  38.788  89.533  1.00 30.27           C
ATOM    686  C   MET    81      14.613  43.911  89.010  1.00 29.54           C
ATOM    687  O   MET    81      14.888  43.911  87.811  1.00 29.33           O
ATOM    688  N   ASN    82      13.792  44.807  89.546  1.00 29.64           N
ATOM    689  CA  ASN    82      13.108  45.772  88.689  1.00 29.82           C
ATOM    690  CB  ASN    82      11.882  46.382  89.386  1.00 29.60           C
ATOM    691  CG  ASN    82      10.784  45.340  89.651  1.00 30.77           C
ATOM    692  OD1 ASN    82      10.740  44.270  89.017  1.00 27.12           O
ATOM    693  ND2 ASN    82       9.870  45.668  90.561  1.00 31.10           N
ATOM    694  C   ASN    82      14.039  46.813  88.082  1.00 29.59           C
ATOM    695  O   ASN    82      13.738  47.380  87.033  1.00 29.59           O
ATOM    696  N   ALA    83      15.190  47.031  88.711  1.00 29.49           N
ATOM    697  CA  ALA    83      16.180  47.968  88.163  1.00 29.25           C
ATOM    698  CB  ALA    83      17.229  48.309  89.216  1.00 28.99           C
ATOM    699  C   ALA    83      16.845  47.377  86.920  1.00 29.57           C
ATOM    700  O   ALA    83      17.412  48.104  86.104  1.00 29.19           O
ATOM    701  N   ASN    84      16.807  46.047  86.816  1.00 29.10           N
ATOM    702  CA  ASN    84      17.450  45.340  85.729  1.00 29.00           C
ATOM    703  CB  ASN    84      18.540  44.429  86.283  1.00 29.02           C
ATOM    704  CG  ASN    84      19.706  45.231  86.858  1.00 31.57           C
ATOM    705  OD1 ASN    84      20.535  45.742  86.100  1.00 33.11           O
ATOM    706  ND2 ASN    84      19.744  45.396  88.188  1.00 28.26           N
ATOM    707  C   ASN    84      16.402  44.576  84.944  1.00 28.17           C
ATOM    708  O   ASN    84      16.602  43.439  84.537  1.00 27.97           O
ATOM    709  N   THR    85      15.251  45.232  84.789  1.00 27.16           N
ATOM    710  CA  THR    85      14.185  44.777  83.944  1.00 25.13           C
ATOM    711  CB  THR    85      12.920  44.432  84.742  1.00 25.07           C
ATOM    712  OG1 THR    85      13.158  43.304  85.625  1.00 25.99           O
ATOM    713  CG2 THR    85      11.824  44.062  83.799  1.00 23.70           C
ATOM    714  C   THR    85      13.914  45.945  82.997  1.00 24.02           C
ATOM    715  O   THR    85      13.845  47.113  83.419  1.00 23.39           O
ATOM    716  N   ILE    86      13.762  45.639  81.713  1.00 23.54           N
ATOM    717  CA  ILE    86      13.426  46.681  80.718  1.00 22.56           C
ATOM    718  CB  ILE    86      14.574  46.876  79.682  1.00 23.19           C
ATOM    719  CG1 ILE    86      14.888  45.576  78.937  1.00 21.71           C
ATOM    720  CD1 ILE    86      15.941  45.757  77.811  1.00 21.68           C
ATOM    721  CG2 ILE    86      15.863  47.412  80.376  1.00 24.58           C
ATOM    722  C   ILE    86      12.104  46.310  80.016  1.00 22.41           C
ATOM    723  O   ILE    86      11.770  45.125  79.931  1.00 22.12           O
ATOM    724  N   LEU    87      11.383  47.301  79.495  1.00 20.46           N
ATOM    725  CA  LEU    87      10.271  47.047  78.556  1.00 21.06           C
ATOM    726  CB  LEU    87       9.527  48.370  78.228  1.00 20.51           C
ATOM    727  CG  LEU    87       8.794  49.100  79.348  1.00 20.09           C
ATOM    728  CD1 LEU    87       8.384  50.552  78.995  1.00 16.88           C
ATOM    729  CD2 LEU    87       7.596  48.304  79.781  1.00 18.68           C
ATOM    730  C   LEU    87      10.799  46.471  77.222  1.00 21.20           C
ATOM    731  O   LEU    87      11.927  46.754  76.831  1.00 21.66           O
ATOM    732  N   PHE    88       9.987  45.674  76.538  1.00 20.05           N
ATOM    733  CA  PHE    88      10.257  45.319  75.142  1.00 20.27           C
ATOM    734  CB  PHE    88       9.515  44.018  74.724  1.00 19.56           C
ATOM    735  CG  PHE    88      10.201  42.735  75.188  1.00 20.59           C
ATOM    736  CD1 PHE    88      11.463  42.382  74.702  1.00 23.45           C
ATOM    737  CE1 PHE    88      12.081  41.228  75.105  1.00 22.55           C
ATOM    738  CZ  PHE    88      11.481  40.419  76.026  1.00 20.15           C
ATOM    739  CE2 PHE    88      10.225  40.743  76.509  1.00 24.68           C
ATOM    740  CD2 PHE    88       9.595  41.893  76.090  1.00 21.23           C
ATOM    741  C   PHE    88       9.828  46.473  74.259  1.00 20.40           C
ATOM    742  O   PHE    88       8.905  47.226  74.628  1.00 21.31           O
ATOM    743  N   PRO    89      10.505  46.651  73.100  1.00 20.26           N
ATOM    744  CA  PRO    89      10.186  47.730  72.178  1.00 20.40           C
ATOM    745  CB  PRO    89      11.007  47.367  70.922  1.00 20.36           C
ATOM    746  CG  PRO    89      12.204  46.716  71.480  1.00 21.73           C
ATOM    747  CD  PRO    89      11.653  45.860  72.614  1.00 20.33           C
ATOM    748  C   PRO    89       8.712  47.879  71.828  1.00 20.08           C
ATOM    749  O   PRO    89       8.274  48.994  71.528  1.00 20.03           O
ATOM    750  N   ASP    90       7.968  46.772  71.838  1.00 20.35           N
ATOM    751  CA  ASP    90       6.579  46.769  71.395  1.00 20.75           C
ATOM    752  CB  ASP    90       6.297  45.545  70.510  1.00 21.27           C
ATOM    753  CG  ASP    90       7.023  45.583  69.186  1.00 22.79           C
ATOM    754  OD1 ASP    90       7.466  46.661  68.743  1.00 24.07           O
ATOM    755  OD2 ASP    90       7.119  44.521  68.561  1.00 25.29           O
ATOM    756  C   ASP    90       5.548  46.757  72.517  1.00 20.34           C
ATOM    757  O   ASP    90       4.351  46.681  72.247  1.00 20.78           O
ATOM    758  N   THR    91       5.989  46.807  73.765  1.00 20.54           N
ATOM    759  CA  THR    91       5.087  46.550  74.890  1.00 19.97           C
ATOM    760  CB  THR    91       5.857  46.390  76.213  1.00 19.95           C
ATOM    761  OG1 THR    91       6.664  45.219  76.137  1.00 22.13           O
ATOM    762  CG2 THR    91       4.911  46.239  77.384  1.00 20.27           C
ATOM    763  C   THR    91       4.029  47.633  75.011  1.00 19.15           C
ATOM    764  O   THR    91       2.838  47.342  75.001  1.00 18.57           O
ATOM    765  N   LEU    92       4.478  48.877  75.141  1.00 18.33           N
ATOM    766  CA  LEU    92       3.569  49.989  75.332  1.00 18.26           C
ATOM    767  CB  LEU    92       4.323  51.266  75.763  1.00 17.66           C
ATOM    768  CG  LEU    92       5.227  51.281  77.007  1.00 15.19           C
ATOM    769  CD1 LEU    92       5.965  52.631  77.097  1.00 11.30           C
ATOM    770  CD2 LEU    92       4.395  51.084  78.225  1.00 16.51           C
ATOM    771  C   LEU    92       2.692  50.262  74.103  1.00 18.76           C
ATOM    772  O   LEU    92       1.479  50.461  74.258  1.00 20.01           O
ATOM    773  N   PRO    93       3.285  50.318  72.885  1.00 18.59           N
ATOM    774  CA  PRO    93       2.364  50.587  71.758  1.00 18.67           C
ATOM    775  CB  PRO    93       3.292  50.693  70.536  1.00 18.83           C
ATOM    776  CG  PRO    93       4.698  50.769  71.074  1.00 18.40           C
ATOM    777  CD  PRO    93       4.685  50.178  72.449  1.00 18.35           C
ATOM    778  C   PRO    93       1.340  49.477  71.546  1.00 18.83           C
ATOM    779  O   PRO    93       0.227  49.749  71.129  1.00 18.94           O
ATOM    780  N   THR    94       1.708  48.232  71.826  1.00 19.04           N
ATOM    781  CA  THR    94       0.799  47.110  71.575  1.00 18.95           C
ATOM    782  CB  THR    94       1.516  45.739  71.710  1.00 19.65           C
ATOM    783  OG1 THR    94       2.523  45.622  70.690  1.00 19.01           O
ATOM    784  CG2 THR    94       0.513  44.590  71.527  1.00 18.15           C
ATOM    785  C   THR    94      -0.385  47.186  72.529  1.00 19.25           C
ATOM    786  O   THR    94      -1.541  47.153  72.113  1.00 19.28           O
ATOM    787  N   LEU    95      -0.073  47.296  73.816  1.00 19.96           N
ATOM    788  CA  LEU    95      -1.064  47.294  74.859  1.00 20.68           C
ATOM    789  CB  LEU    95      -0.380  47.224  76.227  1.00 21.67           C
ATOM    790  CG  LEU    95       0.341  45.925  76.619  1.00 22.31           C
ATOM    791  CD1 LEU    95       0.903  46.007  78.025  1.00 26.20           C
ATOM    792  CD2 LEU    95      -0.599  44.775  76.550  1.00 26.86           C
ATOM    793  C   LEU    95      -1.964  48.513  74.739  1.00 21.16           C
ATOM    794  O   LEU    95      -3.156  48.409  75.010  1.00 21.22           O
ATOM    795  N   THR    96      -1.408  49.655  74.304  1.00 21.25           N
ATOM    796  CA  THR    96      -2.213  50.844  74.008  1.00 21.22           C
ATOM    797  CB  THR    96      -1.338  52.040  73.563  1.00 21.29           C
ATOM    798  OG1 THR    96      -0.447  52.403  74.605  1.00 22.50           O
ATOM    799  CG2 THR    96      -2.194  53.256  73.207  1.00 21.56           C
ATOM    800  C   THR    96      -3.212  50.575  72.883  1.00 21.43           C
ATOM    801  O   THR    96      -4.374  50.993  72.946  1.00 20.99           O
ATOM    802  N   HIS    97      -2.737  49.910  71.833  1.00 21.94           N
ATOM    803  CA  HIS    97      -3.573  49.581  70.677  1.00 22.43           C
ATOM    804  CB  HIS    97      -2.729  48.978  69.553  1.00 22.64           C
ATOM    805  CG  HIS    97      -3.449  48.856  68.245  1.00 25.32           C
ATOM    806  ND1 HIS    97      -4.263  47.784  67.938  1.00 28.13           N
ATOM    807  CE1 HIS    97      -4.763  47.944  66.725  1.00 28.68           C
ATOM    808  NE2 HIS    97      -4.302  49.081  66.232  1.00 29.53           N
ATOM    809  CD2 HIS    97      -3.471  49.667  67.160  1.00 26.78           C
ATOM    810  C   HIS    97      -4.720  48.648  71.076  1.00 22.49           C
ATOM    811  O   HIS    97      -5.854  48.863  70.656  1.00 22.54           O
ATOM    812  N   LEU    98      -4.430  47.629  71.890  1.00 22.90           N
ATOM    813  CA  LEU    98      -5.458  46.702  72.362  1.00 23.05           C
ATOM    814  CB  LEU    98      -4.842  45.521  73.120  1.00 22.74           C
ATOM    815  CG  LEU    98      -3.923  44.586  72.326  1.00 20.64           C
ATOM    816  CD1 LEU    98      -3.169  43.591  73.244  1.00 19.50           C
ATOM    817  CD2 LEU    98      -4.696  43.869  71.205  1.00 15.85           C
ATOM    818  C   LEU    98      -6.521  47.403  73.206  1.00 24.50           C
ATOM    819  O   LEU    98      -7.726  47.184  73.018  1.00 24.67           O
ATOM    820  N   LYS    99      -6.088  48.277  74.109  1.00 25.44           N
ATOM    821  CA  LYS    99      -7.014  48.998  74.982  1.00 26.42           C
ATOM    822  CB  LYS    99      -6.260  49.699  76.127  1.00 26.77           C
ATOM    823  CG  LYS    99      -5.628  48.723  77.140  1.00 26.71           C
ATOM    824  CD  LYS    99      -4.999  49.441  78.340  1.00 26.66           C
ATOM    825  CE  LYS    99      -6.024  50.184  79.192  1.00 27.89           C
ATOM    826  NZ  LYS    99      -6.935  49.263  79.920  1.00 27.25           N
ATOM    827  C   LYS    99      -7.900  49.979  74.213  1.00 26.96           C
ATOM    828  O   LYS    99      -9.057  50.203  74.591  1.00 27.40           O
ATOM    829  N   LYS   100      -7.366  50.550  73.134  1.00 27.31           N
ATOM    830  CA  LYS   100      -8.170  51.373  72.221  1.00 27.99           C
ATOM    831  CB  LYS   100      -7.292  52.088  71.196  1.00 27.98           C
ATOM    832  CG  LYS   100      -6.720  53.359  71.726  1.00 28.10           C
ATOM    833  CD  LYS   100      -5.347  53.618  71.174  1.00 28.05           C
ATOM    834  CE  LYS   100      -4.886  55.015  71.598  1.00 27.96           C
ATOM    835  NZ  LYS   100      -3.640  55.417  70.892  1.00 27.88           N
ATOM    836  C   LYS   100      -9.232  50.545  71.508  1.00 28.41           C
ATOM    837  O   LYS   100     -10.315  51.042  71.219  1.00 28.22           O
ATOM    838  N   GLN   101      -8.914  49.284  71.229  1.00 28.51           N
ATOM    839  CA  GLN   101      -9.890  48.354  70.668  1.00 29.51           C
ATOM    840  CB  GLN   101      -9.191  47.086  70.149  1.00 29.23           C
ATOM    841  CG  GLN   101      -8.506  47.273  68.804  1.00 30.53           C
ATOM    842  CD  GLN   101      -7.812  46.019  68.316  1.00 31.28           C
ATOM    843  OE1 GLN   101      -6.947  45.463  68.993  1.00 33.95           O
ATOM    844  NE2 GLN   101      -8.189  45.565  67.126  1.00 33.53           N
ATOM    845  C   GLN   101     -10.974  47.988  71.693  1.00 28.92           C
ATOM    846  O   GLN   101     -12.006  47.445  71.332  1.00 29.19           O
ATOM    847  N   GLY   102     -10.732  48.279  72.970  1.00 28.44           N
ATOM    848  CA  GLY   102     -11.660  47.886  74.028  1.00 27.66           C
ATOM    849  C   GLY   102     -11.490  46.434  74.428  1.00 26.90           C
ATOM    850  O   GLY   102     -12.374  45.836  75.033  1.00 27.53           O
ATOM    851  N   ILE   103     -10.357  45.856  74.068  1.00 25.97           N
ATOM    852  CA  ILE   103      -9.954  44.571  74.592  1.00 25.15           C
ATOM    853  CB  ILE   103      -8.891  43.916  73.657  1.00 25.72           C
ATOM    854  CG1 ILE   103      -9.598  43.387  72.394  1.00 28.75           C
ATOM    855  CD1 ILE   103      -8.858  43.602  71.071  1.00 32.21           C
ATOM    856  CG2 ILE   103      -8.148  42.768  74.356  1.00 24.81           C
ATOM    857  C   ILE   103      -9.470  44.760  76.047  1.00 24.11           C
ATOM    858  O   ILE   103      -8.841  45.775  76.378  1.00 23.64           O
ATOM    859  N   ARG   104      -9.836  43.809  76.905  1.00 22.93           N
ATOM    860  CA  ARG   104      -9.393  43.739  78.295  1.00 22.38           C
ATOM    861  CB  ARG   104     -10.432  43.052  79.189  1.00 21.82           C
ATOM    862  CG  ARG   104     -11.639  43.963  79.511  1.00 22.99           C
ATOM    863  CD  ARG   104     -12.555  43.350  80.543  1.00 23.79           C
ATOM    864  NE  ARG   104     -13.217  42.158  80.016  1.00 26.02           N
ATOM    865  CZ  ARG   104     -13.959  41.322  80.739  1.00 26.04           C
ATOM    866  NH1 ARG   104     -14.138  41.542  82.034  1.00 25.71           N
ATOM    867  NH2 ARG   104     -14.514  40.259  80.165  1.00 24.78           N
ATOM    868  C   ARG   104      -8.044  43.011  78.368  1.00 22.15           C
ATOM    869  O   ARG   104      -7.842  41.976  77.722  1.00 22.69           O
ATOM    870  N   ILE   105      -7.113  43.562  79.132  1.00 21.37           N
ATOM    871  CA  ILE   105      -5.799  42.950  79.221  1.00 21.36           C
ATOM    872  CB  ILE   105      -4.685  43.845  78.615  1.00 21.45           C
ATOM    873  CG1 ILE   105      -4.622  45.208  79.317  1.00 21.21           C
ATOM    874  CD1 ILE   105      -3.372  46.006  78.973  1.00 20.99           C
ATOM    875  CG2 ILE   105      -4.901  44.025  77.098  1.00 22.71           C
ATOM    876  C   ILE   105      -5.508  42.545  80.651  1.00 21.31           C
ATOM    877  O   ILE   105      -6.029  43.114  81.590  1.00 21.58           O
ATOM    878  N   GLY   106      -4.696  41.517  80.814  1.00 21.48           N
ATOM    879  CA  GLY   106      -4.307  41.082  82.138  1.00 21.34           C
ATOM    880  C   GLY   106      -2.972  40.364  82.072  1.00 20.93           C
ATOM    881  O   GLY   106      -2.430  40.139  80.986  1.00 20.08           O
ATOM    882  N   ILE   107      -2.447  40.026  83.243  1.00 20.95           N
ATOM    883  CA  ILE   107      -1.160  39.319  83.378  1.00 20.93           C
ATOM    884  CB  ILE   107      -0.078  40.214  84.049  1.00 21.11           C
ATOM    885  CG1 ILE   107       0.325  41.388  83.152  1.00 20.55           C
ATOM    886  CD1 ILE   107       1.349  42.345  83.836  1.00 20.00           C
ATOM    887  CG2 ILE   107       1.203  39.438  84.401  1.00 20.89           C
ATOM    888  C   ILE   107      -1.370  38.055  84.222  1.00 21.98           C
ATOM    889  O   ILE   107      -1.968  38.122  85.302  1.00 21.96           O
ATOM    890  N   ILE   108      -0.906  36.905  83.738  1.00 23.06           N
ATOM    891  CA  ILE   108      -0.777  35.707  84.608  1.00 24.09           C
ATOM    892  CB  ILE   108      -1.797  34.550  84.282  1.00 25.43           C
ATOM    893  CG1 ILE   108      -3.226  34.916  84.748  1.00 27.07           C
ATOM    894  CD1 ILE   108      -4.015  35.716  83.788  1.00 27.73           C
ATOM    895  CG2 ILE   108      -1.415  33.269  85.006  1.00 23.92           C
ATOM    896  C   ILE   108       0.689  35.245  84.615  1.00 24.05           C
ATOM    897  O   ILE   108       1.273  34.891  83.595  1.00 24.50           O
ATOM    898  N   SER   109       1.303  35.319  85.788  1.00 24.00           N
ATOM    899  CA  SER   109       2.734  35.260  85.873  1.00 23.46           C
ATOM    900  CB  SER   109       3.332  36.695  85.913  1.00 23.91           C
ATOM    901  OG  SER   109       4.739  36.634  86.160  1.00 21.24           O
ATOM    902  C   SER   109       3.136  34.440  87.085  1.00 24.05           C
ATOM    903  O   SER   109       2.362  34.328  88.051  1.00 22.41           O
ATOM    904  N   THR   110       4.331  33.834  87.005  1.00 23.82           N
ATOM    905  CA  THR   110       4.900  33.138  88.158  1.00 24.02           C
ATOM    906  CB  THR   110       5.718  31.885  87.734  1.00 24.80           C
ATOM    907  OG1 THR   110       4.809  30.972  87.111  1.00 21.86           O
ATOM    908  CG2 THR   110       6.364  31.185  88.960  1.00 22.57           C
ATOM    909  C   THR   110       5.661  34.110  89.087  1.00 24.45           C
ATOM    910  O   THR   110       5.845  33.837  90.248  1.00 23.94           O
ATOM    911  N   LYS   111       6.066  35.266  88.559  1.00 24.80           N
ATOM    912  CA  LYS   111       6.752  36.269  89.351  1.00 24.75           C
ATOM    913  CB  LYS   111       7.350  37.371  88.435  1.00 24.57           C
ATOM    914  CG  LYS   111       7.970  38.551  89.191  1.00 26.03           C
ATOM    915  CD  LYS   111       8.796  39.506  88.308  1.00 25.47           C
ATOM    916  CE  LYS   111      10.151  38.911  87.993  1.00 27.08           C
ATOM    917  NZ  LYS   111      10.973  39.860  87.201  1.00 27.31           N
ATOM    918  C   LYS   111       5.720  36.811  90.357  1.00 24.52           C
ATOM    919  O   LYS   111       4.513  36.795  90.083  1.00 24.83           O
ATOM    920  N   TYR   112       6.184  37.252  91.525  1.00 24.03           N
ATOM    921  CA  TYR   112       5.295  37.800  92.532  1.00 23.93           C
ATOM    922  CB  TYR   112       6.074  38.171  93.792  1.00 24.91           C
ATOM    923  CG  TYR   112       6.854  36.992  94.369  1.00 27.15           C
ATOM    924  CD1 TYR   112       6.283  35.716  94.429  1.00 27.45           C
ATOM    925  CE1 TYR   112       7.013  34.611  94.923  1.00 31.08           C
ATOM    926  CZ  TYR   112       8.303  34.796  95.393  1.00 28.86           C
ATOM    927  OH  TYR   112       9.011  33.713  95.913  1.00 31.26           O
ATOM    928  CE2 TYR   112       8.893  36.058  95.356  1.00 28.90           C
ATOM    929  CD2 TYR   112       8.168  37.152  94.823  1.00 27.43           C
ATOM    930  C   TYR   112       4.610  39.032  91.989  1.00 23.41           C
ATOM    931  O   TYR   112       5.260  39.896  91.364  1.00 23.52           O
ATOM    932  N   ARG   113       3.305  39.103  92.232  1.00 21.97           N
ATOM    933  CA  ARG   113       2.489  40.236  91.833  1.00 21.75           C
ATOM    934  CB  ARG   113       1.031  40.019  92.239  1.00 21.73           C
ATOM    935  CG  ARG   113       0.186  41.140  91.722  1.00 23.08           C
ATOM    936  CD  ARG   113      -1.252  40.797  91.585  1.00 29.65           C
ATOM    937  NE  ARG   113      -1.761  40.257  92.820  1.00 30.40           N
ATOM    938  CZ  ARG   113      -2.146  41.000  93.831  1.00 33.13           C
ATOM    939  NH1 ARG   113      -2.106  42.325  93.727  1.00 34.65           N
ATOM    940  NH2 ARG   113      -2.572  40.409  94.936  1.00 35.49           N
ATOM    941  C   ARG   113       2.954  41.569  92.374  1.00 21.21           C
ATOM    942  O   ARG   113       2.925  42.564  91.658  1.00 21.65           O
ATOM    943  N   PHE   114       3.333  41.612  93.656  1.00 20.92           N
ATOM    944  CA  PHE   114       3.889  42.838  94.247  1.00 20.19           C
ATOM    945  CB  PHE   114       4.199  42.677  95.771  1.00 19.97           C
ATOM    946  CG  PHE   114       5.454  41.888  96.080  1.00 18.39           C
ATOM    947  CD1 PHE   114       6.715  42.526  96.088  1.00 19.63           C
ATOM    948  CE1 PHE   114       7.914  41.829  96.387  1.00 17.93           C
ATOM    949  CZ  PHE   114       7.839  40.450  96.701  1.00 20.29           C
ATOM    950  CE2 PHE   114       6.561  39.810  96.724  1.00 20.01           C
ATOM    951  CD2 PHE   114       5.385  40.531  96.404  1.00 18.78           C
ATOM    952  C   PHE   114       5.106  43.323  93.452  1.00 20.47           C
ATOM    953  O   PHE   114       5.327  44.516  93.314  1.00 20.52           O
ATOM    954  N   ARG   115       5.892  42.388  92.933  1.00 20.95           N
ATOM    955  CA  ARG   115       7.085  42.719  92.176  1.00 22.04           C
ATOM    956  CB  ARG   115       7.924  41.466  92.013  1.00 21.74           C
ATOM    957  CG  ARG   115       9.238  41.681  91.270  1.00 24.56           C
ATOM    958  CD  ARG   115      10.299  42.239  92.221  1.00 27.49           C
ATOM    959  NE  ARG   115      10.697  41.201  93.174  1.00 29.27           N
ATOM    960  CZ  ARG   115      11.068  41.414  94.437  1.00 29.39           C
ATOM    961  NH1 ARG   115      11.103  42.653  94.944  1.00 26.15           N
ATOM    962  NH2 ARG   115      11.415  40.371  95.193  1.00 26.91           N
ATOM    963  C   ARG   115       6.720  43.344  90.811  1.00 22.23           C
ATOM    964  O   ARG   115       7.290  44.373  90.398  1.00 21.97           O
ATOM    965  N   ILE   116       5.744  42.721  90.145  1.00 22.57           N
ATOM    966  CA  ILE   116       5.160  43.221  88.902  1.00 23.16           C
ATOM    967  CB  ILE   116       4.157  42.190  88.356  1.00 23.56           C
ATOM    968  CG1 ILE   116       4.920  40.914  87.940  1.00 21.53           C
ATOM    969  CD1 ILE   116       4.033  39.740  87.742  1.00 18.62           C
ATOM    970  CG2 ILE   116       3.257  42.759  87.229  1.00 24.81           C
ATOM    971  C   ILE   116       4.540  44.618  89.039  1.00 23.20           C
ATOM    972  O   ILE   116       4.736  45.471  88.178  1.00 23.95           O
ATOM    973  N   LEU   117       3.824  44.851  90.128  1.00 23.18           N
ATOM    974  CA  LEU   117       3.142  46.131  90.333  1.00 22.97           C
ATOM    975  CB  LEU   117       2.163  46.067  91.507  1.00 23.35           C
ATOM    976  CG  LEU   117       0.893  45.203  91.358  1.00 22.83           C
ATOM    977  CD1 LEU   117       0.263  45.068  92.731  1.00 23.77           C
ATOM    978  CD2 LEU   117      -0.134  45.791  90.389  1.00 25.25           C
ATOM    979  C   LEU   117       4.157  47.220  90.535  1.00 22.48           C
ATOM    980  O   LEU   117       4.011  48.312  90.031  1.00 22.68           O
ATOM    981  N   SER   118       5.225  46.896  91.239  1.00 22.82           N
ATOM    982  CA  SER   118       6.278  47.867  91.486  1.00 22.55           C
ATOM    983  CB  SER   118       7.256  47.318  92.508  1.00 22.73           C
ATOM    984  OG  SER   118       8.088  48.377  92.966  1.00 25.80           O
ATOM    985  C   SER   118       6.996  48.249  90.170  1.00 21.80           C
ATOM    986  O   SER   118       7.276  49.429  89.930  1.00 20.84           O
ATOM    987  N   PHE   119       7.255  47.248  89.322  1.00 20.76           N
ATOM    988  CA  PHE   119       7.778  47.477  87.980  1.00 20.24           C
ATOM    989  CB  PHE   119       8.059  46.173  87.223  1.00 18.77           C
ATOM    990  CG  PHE   119       8.569  46.403  85.826  1.00 19.44           C
ATOM    991  CD1 PHE   119       9.929  46.704  85.600  1.00 17.91           C
ATOM    992  CE1 PHE   119      10.385  46.994  84.313  1.00 18.19           C
ATOM    993  CZ  PHE   119       9.518  46.942  83.225  1.00 16.24           C
ATOM    994  CE2 PHE   119       8.161  46.658  83.439  1.00 18.27           C
ATOM    995  CD2 PHE   119       7.703  46.382  84.742  1.00 18.20           C
ATOM    996  C   PHE   119       6.840  48.380  87.183  1.00 20.65           C
ATOM    997  O   PHE   119       7.280  49.372  86.593  1.00 21.93           O
ATOM    998  N   LEU   120       5.556  48.053  87.202  1.00 20.45           N
ATOM    999  CA  LEU   120       4.536  48.767  86.441  1.00 20.84           C
ATOM   1000  CB  LEU   120       3.167  48.044  86.517  1.00 20.93           C
ATOM   1001  CG  LEU   120       3.052  46.558  86.041  1.00 19.24           C
ATOM   1002  CD1 LEU   120       1.658  45.978  86.237  1.00 18.53           C
ATOM   1003  CD2 LEU   120       3.431  46.440  84.584  1.00 20.96           C
ATOM   1004  C   LEU   120       4.380  50.189  86.866  1.00 21.73           C
ATOM   1005  O   LEU   120       4.173  51.072  86.033  1.00 21.80           O
ATOM   1006  N   ARG   121       4.476  50.431  88.166  1.00 22.60           N
ATOM   1007  CA  ARG   121       4.314  51.785  88.694  1.00 23.52           C
ATOM   1008  CB  ARG   121       4.536  51.804  90.209  1.00 23.94           C
ATOM   1009  CG  ARG   121       3.243  51.762  90.989  1.00 26.77           C
ATOM   1010  CD  ARG   121       3.460  52.148  92.462  1.00 32.77           C
ATOM   1011  NE  ARG   121       4.296  51.171  93.166  1.00 36.60           N
ATOM   1012  CZ  ARG   121       3.868  49.993  93.621  1.00 37.23           C
ATOM   1013  NH1 ARG   121       2.606  49.615  93.453  1.00 39.05           N
ATOM   1014  NH2 ARG   121       4.712  49.187  94.242  1.00 37.40           N
ATOM   1015  C   ARG   121       5.175  52.842  88.028  1.00 23.70           C
ATOM   1016  O   ARG   121       4.700  53.965  87.795  1.00 22.66           O
ATOM   1017  N   ASN   122       6.433  52.512  87.738  1.00 24.49           N
ATOM   1018  CA  ASN   122       7.322  53.455  87.040  1.00 25.95           C
ATOM   1019  CB  ASN   122       8.592  53.730  87.849  1.00 26.52           C
ATOM   1020  CG  ASN   122       9.381  52.471  88.149  1.00 27.72           C
ATOM   1021  OD1 ASN   122       8.830  51.376  88.204  1.00 27.80           O
ATOM   1022  ND2 ASN   122      10.678  52.627  88.355  1.00 28.40           N
ATOM   1023  C   ASN   122       7.650  53.134  85.563  1.00 26.81           C
ATOM   1024  O   ASN   122       8.660  53.617  85.024  1.00 25.03           O
ATOM   1025  N   HIS   123       6.782  52.336  84.928  1.00 28.90           N
ATOM   1026  CA  HIS   123       6.824  52.065  83.474  1.00 32.33           C
ATOM   1027  CB  HIS   123       7.437  50.688  83.175  1.00 32.18           C
ATOM   1028  CG  HIS   123       8.880  50.598  83.558  1.00 32.54           C
ATOM   1029  ND1 HIS   123       9.292  50.240  84.824  1.00 34.38           N
ATOM   1030  CE1 HIS   123      10.612  50.292  84.887  1.00 34.14           C
ATOM   1031  NE2 HIS   123      11.067  50.684  83.711  1.00 32.80           N
ATOM   1032  CD2 HIS   123      10.004  50.896  82.868  1.00 32.98           C
ATOM   1033  C   HIS   123       5.481  52.284  82.732  1.00 34.73           C
ATOM   1034  O   HIS   123       5.352  53.269  82.000  1.00 35.69           O
ATOM   1035  N   MET   124       4.488  51.397  82.910  1.00 37.36           N
ATOM   1036  CA  MET   124       3.182  51.538  82.200  1.00 40.60           C
ATOM   1037  CB  MET   124       2.354  50.232  82.186  1.00 40.22           C
ATOM   1038  CG  MET   124       3.145  49.006  82.256  1.00 42.29           C
ATOM   1039  SD  MET   124       3.035  47.774  80.747  1.00 48.28          SE
ATOM   1040  CE  MET   124       4.580  46.586  81.143  1.00 45.73           C
ATOM   1041  C   MET   124       2.350  52.657  82.824  1.00 40.03           C
ATOM   1042  O   MET   124       2.549  52.999  83.991  1.00 39.75           O
ATOM   1043  N   PRO   125       1.431  53.264  82.044  1.00 40.89           N
ATOM   1044  CA  PRO   125       0.446  54.102  82.734  1.00 40.98           C
ATOM   1045  CB  PRO   125      -0.462  54.605  81.603  1.00 41.37           C
ATOM   1046  CG  PRO   125       0.315  54.429  80.344  1.00 41.09           C
ATOM   1047  CD  PRO   125       1.246  53.269  80.576  1.00 40.96           C
ATOM   1048  C   PRO   125      -0.353  53.263  83.731  1.00 41.53           C
ATOM   1049  O   PRO   125      -0.658  52.088  83.461  1.00 41.29           O
ATOM   1050  N   ASP   126      -0.656  53.841  84.889  1.00 41.77           N
ATOM   1051  CA  ASP   126      -1.488  53.161  85.878  1.00 42.26           C
ATOM   1052  CB  ASP   126      -1.283  53.797  87.266  1.00 42.73           C
ATOM   1053  CG  ASP   126      -1.286  52.769  88.412  1.00 44.34           C
ATOM   1054  OD1 ASP   126      -1.670  51.593  88.183  1.00 45.63           O
ATOM   1055  OD2 ASP   126      -0.897  53.153  89.552  1.00 45.51           O
ATOM   1056  C   ASP   126      -2.927  53.356  85.389  1.00 41.58           C
ATOM   1057  O   ASP   126      -3.206  54.386  84.784  1.00 42.21           O
ATOM   1058  N   ASP   127      -3.827  52.389  85.556  1.00 40.52           N
ATOM   1059  CA  ASP   127      -3.526  50.998  85.880  1.00 39.96           C
ATOM   1060  CB  ASP   127      -4.189  50.550  87.197  1.00 40.94           C
ATOM   1061  CG  ASP   127      -5.660  50.984  87.315  1.00 41.90           C
ATOM   1062  OD1 ASP   127      -5.953  52.208  87.369  1.00 42.06           O
ATOM   1063  OD2 ASP   127      -6.518  50.079  87.382  1.00 43.64           O
ATOM   1064  C   ASP   127      -4.042  50.185  84.717  1.00 38.20           C
ATOM   1065  O   ASP   127      -5.256  50.109  84.494  1.00 37.67           O
ATOM   1066  N   TRP   128      -3.113  49.592  83.975  1.00 36.61           N
ATOM   1067  CA  TRP   128      -3.429  49.055  82.644  1.00 35.09           C
ATOM   1068  CB  TRP   128      -2.227  48.948  81.688  1.00 35.80           C
ATOM   1069  CG  TRP   128      -2.234  50.138  80.750  1.00 35.09           C
ATOM   1070  CD1 TRP   128      -3.104  51.208  80.783  1.00 35.72           C
ATOM   1071  NE1 TRP   128      -2.822  52.085  79.763  1.00 35.55           N
ATOM   1072  CE2 TRP   128      -1.742  51.607  79.063  1.00 35.42           C
ATOM   1073  CD2 TRP   128      -1.348  50.383  79.658  1.00 34.71           C
ATOM   1074  CE3 TRP   128      -0.265  49.688  79.118  1.00 33.51           C
ATOM   1075  CZ3 TRP   128       0.399  50.231  78.022  1.00 34.61           C
ATOM   1076  CH2 TRP   128      -0.003  51.446  77.455  1.00 35.73           C
ATOM   1077  CZ2 TRP   128      -1.074  52.152  77.957  1.00 36.45           C
ATOM   1078  C   TRP   128      -4.588  48.100  82.448  1.00 33.02           C
ATOM   1079  O   TRP   128      -5.180  48.096  81.379  1.00 32.97           O
ATOM   1080  N   PHE   129      -4.895  47.198  83.368  1.00 30.83           N
ATOM   1081  CA  PHE   129      -4.519  45.796  83.438  1.00 27.41           C
ATOM   1082  CB  PHE   129      -3.210  45.414  84.131  1.00 27.51           C
ATOM   1083  CG  PHE   129      -2.070  45.221  83.163  1.00 24.74           C
ATOM   1084  CD1 PHE   129      -2.191  44.352  82.086  1.00 22.45           C
ATOM   1085  CE1 PHE   129      -1.154  44.219  81.171  1.00 22.50           C
ATOM   1086  CZ  PHE   129       0.024  44.986  81.326  1.00 23.94           C
ATOM   1087  CE2 PHE   129       0.131  45.854  82.373  1.00 22.97           C
ATOM   1088  CD2 PHE   129      -0.908  45.982  83.279  1.00 22.98           C
ATOM   1089  C   PHE   129      -5.747  45.423  84.247  1.00 26.85           C
ATOM   1090  O   PHE   129      -5.857  45.755  85.438  1.00 26.52           O
ATOM   1091  N   ASP   130      -6.726  44.837  83.571  1.00 24.96           N
ATOM   1092  CA  ASP   130      -7.957  44.475  84.234  1.00 24.19           C
ATOM   1093  CB  ASP   130      -9.012  44.086  83.220  1.00 23.88           C
ATOM   1094  CG  ASP   130      -9.437  45.274  82.371  1.00 27.00           C
ATOM   1095  OD1 ASP   130     -10.486  45.869  82.696  1.00 29.29           O
ATOM   1096  OD2 ASP   130      -8.706  45.627  81.403  1.00 28.94           O
ATOM   1097  C   ASP   130      -7.741  43.441  85.330  1.00 22.92           C
ATOM   1098  O   ASP   130      -8.495  43.397  86.287  1.00 21.95           O
ATOM   1099  N   ILE   131      -6.677  42.649  85.206  1.00 22.22           N
ATOM   1100  CA  ILE   131      -6.307  41.674  86.234  1.00 21.82           C
ATOM   1101  CB  ILE   131      -7.161  40.373  86.146  1.00 21.76           C
ATOM   1102  CG1 ILE   131      -6.930  39.485  87.370  1.00 22.46           C
ATOM   1103  CD1 ILE   131      -8.071  38.538  87.621  1.00 24.67           C
ATOM   1104  CG2 ILE   131      -6.894  39.594  84.846  1.00 19.84           C
ATOM   1105  C   ILE   131      -4.825  41.292  86.164  1.00 21.81           C
ATOM   1106  O   ILE   131      -4.235  41.209  85.074  1.00 22.19           O
ATOM   1107  N   ILE   132      -4.244  41.065  87.334  1.00 20.67           N
ATOM   1108  CA  ILE   132      -2.877  40.621  87.448  1.00 21.67           C
ATOM   1109  CB  ILE   132      -1.857  41.769  87.836  1.00 21.11           C
ATOM   1110  CG1 ILE   132      -1.840  42.854  86.755  1.00 22.05           C
ATOM   1111  CD1 ILE   132      -1.142  44.103  87.131  1.00 20.96           C
ATOM   1112  CG2 ILE   132      -0.429  41.186  87.997  1.00 20.87           C
ATOM   1113  C   ILE   132      -2.934  39.561  88.520  1.00 21.42           C
ATOM   1114  O   ILE   132      -3.402  39.825  89.625  1.00 21.70           O
ATOM   1115  N   ILE   133      -2.490  38.372  88.137  1.00 21.45           N
ATOM   1116  CA  ILE   133      -2.309  37.194  88.992  1.00 21.23           C
ATOM   1117  CB  ILE   133      -3.092  35.998  88.411  1.00 20.64           C
ATOM   1118  CG1 ILE   133      -4.604  36.370  88.251  1.00 20.13           C
ATOM   1119  CD1 ILE   133      -5.347  36.639  89.520  1.00 22.28           C
ATOM   1120  CG2 ILE   133      -2.926  34.728  89.265  1.00 20.74           C
ATOM   1121  C   ILE   133      -0.808  36.909  88.984  1.00 21.77           C
ATOM   1122  O   ILE   133      -0.211  36.748  87.891  1.00 22.24           O
ATOM   1123  N   GLY   134      -0.192  36.907  90.173  1.00 21.68           N
ATOM   1124  CA  GLY   134       1.255  36.614  90.338  1.00 20.93           C
ATOM   1125  C   GLY   134       1.469  35.278  91.048  1.00 21.26           C
ATOM   1126  O   GLY   134       0.500  34.563  91.361  1.00 19.97           O
ATOM   1127  N   GLY   135       2.737  34.925  91.268  1.00 21.56           N
ATOM   1128  CA  GLY   135       3.112  33.682  91.980  1.00 22.36           C
ATOM   1129  C   GLY   135       2.520  33.486  93.377  1.00 23.17           C
ATOM   1130  O   GLY   135       2.158  32.354  93.770  1.00 23.27           O
ATOM   1131  N   GLU   136       2.383  34.563  94.140  1.00 22.75           N
ATOM   1132  CA  GLU   136       1.816  34.428  95.487  1.00 23.36           C
ATOM   1133  CB  GLU   136       2.345  35.554  96.403  1.00 23.73           C
ATOM   1134  CG  GLU   136       1.681  36.950  96.250  1.00 22.57           C
ATOM   1135  CD  GLU   136       2.182  37.801  95.055  1.00 25.96           C
ATOM   1136  OE1 GLU   136       2.283  37.277  93.905  1.00 23.49           O
ATOM   1137  OE2 GLU   136       2.415  39.034  95.256  1.00 24.73           O
ATOM   1138  C   GLU   136       0.247  34.280  95.490  1.00 23.83           C
ATOM   1139  O   GLU   136      -0.369  33.896  96.497  1.00 23.40           O
ATOM   1140  N   ASP   137      -0.387  34.529  94.351  1.00 24.09           N
ATOM   1141  CA  ASP   137      -1.859  34.442  94.272  1.00 25.55           C
ATOM   1142  CB  ASP   137      -2.367  35.311  93.131  1.00 25.10           C
ATOM   1143  CG  ASP   137      -2.097  36.779  93.352  1.00 25.54           C
ATOM   1144  OD1 ASP   137      -2.202  37.277  94.485  1.00 28.50           O
ATOM   1145  OD2 ASP   137      -1.772  37.440  92.373  1.00 26.95           O
ATOM   1146  C   ASP   137      -2.416  33.017  94.111  1.00 25.84           C
ATOM   1147  O   ASP   137      -3.638  32.812  94.093  1.00 26.18           O
ATOM   1148  N   VAL   138      -1.521  32.044  93.978  1.00 26.55           N
ATOM   1149  CA  VAL   138      -1.889  30.650  93.613  1.00 26.36           C
ATOM   1150  CB  VAL   138      -1.768  30.341  92.054  1.00 26.04           C
ATOM   1151  CG1 VAL   138      -2.696  31.284  91.225  1.00 26.27           C
ATOM   1152  CG2 VAL   138      -0.311  30.428  91.540  1.00 25.06           C
ATOM   1153  C   VAL   138      -1.035  29.671  94.398  1.00 26.57           C
ATOM   1154  O   VAL   138       0.097  29.981  94.766  1.00 25.71           O
ATOM   1155  N   THR   139      -1.596  28.497  94.651  1.00 27.30           N
ATOM   1156  CA  THR   139      -0.888  27.445  95.356  1.00 28.33           C
ATOM   1157  CB  THR   139      -1.882  26.536  96.095  1.00 28.71           C
ATOM   1158  OG1 THR   139      -2.459  27.267  97.177  1.00 26.46           O
ATOM   1159  CG2 THR   139      -1.208  25.266  96.628  1.00 30.40           C
ATOM   1160  C   THR   139      -0.005  26.648  94.386  1.00 29.17           C
ATOM   1161  O   THR   139       1.149  26.353  94.701  1.00 29.07           O
ATOM   1162  N   HIS   140      -0.571  26.318  93.219  1.00 29.49           N
ATOM   1163  CA  HIS   140       0.113  25.569  92.172  1.00 29.83           C
ATOM   1164  CB  HIS   140      -0.736  24.403  91.704  1.00 30.06           C
ATOM   1165  CG  HIS   140      -0.980  23.395  92.770  1.00 32.33           C
ATOM   1166  ND1 HIS   140      -2.093  23.429  93.583  1.00 35.12           N
ATOM   1167  CE1 HIS   140      -2.036  22.425  94.439  1.00 36.33           C
ATOM   1168  NE2 HIS   140      -0.925  21.748  94.213  1.00 37.23           N
ATOM   1169  CD2 HIS   140      -0.244  22.340  93.177  1.00 34.03           C
ATOM   1170  C   HIS   140       0.384  26.459  90.995  1.00 29.35           C
ATOM   1171  O   HIS   140      -0.478  27.252  90.580  1.00 28.72           O
ATOM   1172  N   HIS   141       1.574  26.307  90.439  1.00 27.98           N
ATOM   1173  CA  HIS   141       2.080  27.301  89.512  1.00 28.07           C
ATOM   1174  CB  HIS   141       3.463  27.750  90.003  1.00 28.04           C
ATOM   1175  CG  HIS   141       3.393  28.496  91.311  1.00 27.71           C
ATOM   1176  ND1 HIS   141       3.534  27.875  92.534  1.00 25.16           N
ATOM   1177  CE1 HIS   141       3.373  28.759  93.499  1.00 24.61           C
ATOM   1178  NE2 HIS   141       3.107  29.934  92.947  1.00 27.11           N
ATOM   1179  CD2 HIS   141       3.111  29.796  91.580  1.00 27.35           C
ATOM   1180  C   HIS   141       2.111  26.777  88.079  1.00 27.50           C
ATOM   1181  O   HIS   141       2.090  25.571  87.879  1.00 26.78           O
ATOM   1182  N   LYS   142       2.171  27.681  87.093  1.00 27.81           N
ATOM   1183  CA  LYS   142       2.224  27.291  85.662  1.00 28.04           C
ATOM   1184  CB  LYS   142       2.551  28.498  84.772  1.00 27.57           C
ATOM   1185  CG  LYS   142       1.552  29.656  84.827  1.00 28.67           C
ATOM   1186  CD  LYS   142       1.857  30.722  83.749  1.00 28.89           C
ATOM   1187  CE  LYS   142       2.936  31.661  84.217  1.00 28.95           C
ATOM   1188  NZ  LYS   142       3.314  32.608  83.107  1.00 28.98           N
ATOM   1189  C   LYS   142       3.255  26.198  85.486  1.00 27.87           C
ATOM   1190  O   LYS   142       4.327  26.282  86.090  1.00 29.23           O
ATOM   1191  N   PRO   143       2.977  25.166  84.663  1.00 28.29           N
ATOM   1192  CA  PRO   143       1.850  24.958  83.744  1.00 28.58           C
ATOM   1193  CB  PRO   143       2.368  23.876  82.765  1.00 28.89           C
ATOM   1194  CG  PRO   143       3.359  23.086  83.546  1.00 28.98           C
ATOM   1195  CD  PRO   143       3.934  24.034  84.621  1.00 28.62           C
ATOM   1196  C   PRO   143       0.482  24.611  84.362  1.00 28.32           C
ATOM   1197  O   PRO   143      -0.478  24.469  83.636  1.00 27.84           O
ATOM   1198  N   ASP   144       0.368  24.539  85.688  1.00 28.21           N
ATOM   1199  CA  ASP   144      -0.954  24.362  86.294  1.00 28.18           C
ATOM   1200  CB  ASP   144      -0.841  24.248  87.817  1.00 27.62           C
ATOM   1201  CG  ASP   144      -2.147  23.834  88.462  1.00 28.37           C
ATOM   1202  OD1 ASP   144      -2.221  22.711  88.967  1.00 26.19           O
ATOM   1203  OD2 ASP   144      -3.102  24.628  88.476  1.00 27.88           O
ATOM   1204  C   ASP   144      -1.830  25.560  85.908  1.00 27.55           C
ATOM   1205  O   ASP   144      -1.396  26.722  86.028  1.00 27.66           O
ATOM   1206  N   PRO   145      -3.062  25.287  85.416  1.00 28.58           N
ATOM   1207  CA  PRO   145      -3.950  26.371  84.963  1.00 27.87           C
ATOM   1208  CB  PRO   145      -4.988  25.617  84.115  1.00 28.13           C
ATOM   1209  CG  PRO   145      -5.068  24.268  84.760  1.00 28.65           C
ATOM   1210  CD  PRO   145      -3.678  23.948  85.218  1.00 27.05           C
ATOM   1211  C   PRO   145      -4.632  27.194  86.078  1.00 28.17           C
ATOM   1212  O   PRO   145      -5.499  28.029  85.778  1.00 28.46           O
ATOM   1213  N   GLU   146      -4.260  26.975  87.338  1.00 28.42           N
ATOM   1214  CA  GLU   146      -4.968  27.605  88.491  1.00 28.55           C
ATOM   1215  CB  GLU   146      -4.235  27.313  89.807  1.00 28.72           C
ATOM   1216  CG  GLU   146      -5.006  27.727  91.073  1.00 29.01           C
ATOM   1217  CD  GLU   146      -4.199  27.550  92.349  1.00 28.29           C
ATOM   1218  OE1 GLU   146      -3.457  26.547  92.459  1.00 29.73           O
ATOM   1219  OE2 GLU   146      -4.301  28.412  93.245  1.00 27.05           O
ATOM   1220  C   GLU   146      -5.100  29.119  88.339  1.00 28.92           C
ATOM   1221  O   GLU   146      -6.187  29.681  88.500  1.00 28.72           O
ATOM   1222  N   GLY   147      -3.982  29.778  88.050  1.00 29.01           N
ATOM   1223  CA  GLY   147      -3.970  31.229  87.917  1.00 29.73           C
ATOM   1224  C   GLY   147      -4.714  31.721  86.699  1.00 30.25           C
ATOM   1225  O   GLY   147      -5.460  32.706  86.778  1.00 30.55           O
ATOM   1226  N   LEU   148      -4.516  31.031  85.574  1.00 30.39           N
ATOM   1227  CA  LEU   148      -5.191  31.387  84.335  1.00 30.29           C
ATOM   1228  CB  LEU   148      -4.668  30.557  83.142  1.00 29.91           C
ATOM   1229  CG  LEU   148      -5.162  30.971  81.723  1.00 31.16           C
ATOM   1230  CD1 LEU   148      -5.102  32.485  81.462  1.00 30.38           C
ATOM   1231  CD2 LEU   148      -4.345  30.284  80.653  1.00 31.39           C
ATOM   1232  C   LEU   148      -6.712  31.250  84.509  1.00 29.93           C
ATOM   1233  O   LEU   148      -7.459  32.187  84.189  1.00 29.74           O
ATOM   1234  N   LEU   149      -7.156  30.093  85.017  1.00 29.50           N
ATOM   1235  CA  LEU   149      -8.573  29.865  85.290  1.00 29.44           C
ATOM   1236  CB  LEU   149      -8.819  28.417  85.759  1.00 29.53           C
ATOM   1237  CG  LEU   149      -8.523  27.271  84.787  1.00 26.91           C
ATOM   1238  CD1 LEU   149      -8.739  25.945  85.501  1.00 25.33           C
ATOM   1239  CD2 LEU   149      -9.358  27.402  83.497  1.00 24.96           C
ATOM   1240  C   LEU   149      -9.113  30.853  86.320  1.00 30.01           C
ATOM   1241  O   LEU   149     -10.254  31.298  86.206  1.00 30.21           O
ATOM   1242  N   LEU   150      -8.294  31.198  87.315  1.00 30.89           N
ATOM   1243  CA  LEU   150      -8.667  32.200  88.308  1.00 31.50           C
ATOM   1244  CB  LEU   150      -7.596  32.361  89.407  1.00 31.23           C
ATOM   1245  CG  LEU   150      -7.868  33.398  90.522  1.00 31.44           C
ATOM   1246  CD1 LEU   150      -9.066  33.029  91.413  1.00 30.04           C
ATOM   1247  CD2 LEU   150      -6.637  33.653  91.380  1.00 31.62           C
ATOM   1248  C   LEU   150      -8.980  33.552  87.647  1.00 32.69           C
ATOM   1249  O   LEU   150     -10.038  34.150  87.928  1.00 33.35           O
ATOM   1250  N   ALA   151      -8.077  34.021  86.780  1.00 32.59           N
ATOM   1251  CA  ALA   151      -8.261  35.279  86.067  1.00 33.62           C
ATOM   1252  CB  ALA   151      -7.054  35.584  85.235  1.00 33.37           C
ATOM   1253  C   ALA   151      -9.529  35.337  85.205  1.00 34.37           C
ATOM   1254  O   ALA   151     -10.314  36.307  85.307  1.00 34.50           O
ATOM   1255  N   ILE   152      -9.718  34.305  84.366  1.00 35.25           N
ATOM   1256  CA  ILE   152     -10.926  34.126  83.543  1.00 35.62           C
ATOM   1257  CB  ILE   152     -10.934  32.763  82.776  1.00 35.62           C
ATOM   1258  CG1 ILE   152      -9.708  32.606  81.876  1.00 34.67           C
ATOM   1259  CD1 ILE   152      -9.417  31.151  81.476  1.00 34.42           C
ATOM   1260  CG2 ILE   152     -12.206  32.625  81.915  1.00 36.65           C
ATOM   1261  C   ILE   152     -12.189  34.206  84.411  1.00 36.96           C
ATOM   1262  O   ILE   152     -13.165  34.867  84.043  1.00 36.65           O
ATOM   1263  N   ASP   153     -12.150  33.527  85.557  1.00 38.06           N
ATOM   1264  CA  ASP   153     -13.238  33.564  86.541  1.00 38.91           C
ATOM   1265  CB  ASP   153     -12.964  32.594  87.693  1.00 38.78           C
ATOM   1266  CG  ASP   153     -14.020  32.677  88.765  1.00 41.18           C
ATOM   1267  OD1 ASP   153     -15.192  32.354  88.469  1.00 38.13           O
ATOM   1268  OD2 ASP   153     -13.685  33.102  89.896  1.00 46.00           O
ATOM   1269  C   ASP   153     -13.527  34.964  87.090  1.00 39.10           C
ATOM   1270  O   ASP   153     -14.683  35.418  87.096  1.00 39.05           O
ATOM   1271  N   ARG   154     -12.478  35.640  87.550  1.00 39.66           N
ATOM   1272  CA  ARG   154     -12.604  36.995  88.098  1.00 40.18           C
ATOM   1273  CB  ARG   154     -11.289  37.457  88.738  1.00 40.91           C
ATOM   1274  CG  ARG   154     -10.921  36.683  89.989  1.00 42.64           C
ATOM   1275  CD  ARG   154     -10.260  37.574  91.020  1.00 45.63           C
ATOM   1276  NE  ARG   154      -9.328  36.801  91.833  1.00 47.12           N
ATOM   1277  CZ  ARG   154      -8.246  37.312  92.406  1.00 48.26           C
ATOM   1278  NH1 ARG   154      -7.970  38.611  92.256  1.00 47.61           N
ATOM   1279  NH2 ARG   154      -7.434  36.525  93.112  1.00 47.30           N
ATOM   1280  C   ARG   154     -13.095  38.035  87.083  1.00 39.58           C
ATOM   1281  O   ARG   154     -13.827  38.975  87.447  1.00 40.22           O
ATOM   1282  N   LEU   155     -12.690  37.865  85.826  1.00 38.30           N
ATOM   1283  CA  LEU   155     -13.117  38.749  84.739  1.00 37.14           C
ATOM   1284  CB  LEU   155     -12.063  38.749  83.609  1.00 36.73           C
ATOM   1285  CG  LEU   155     -10.662  39.400  83.769  1.00 34.97           C
ATOM   1286  CD1 LEU   155      -9.880  39.218  82.484  1.00 36.15           C
ATOM   1287  CD2 LEU   155     -10.715  40.861  84.079  1.00 34.72           C
ATOM   1288  C   LEU   155     -14.549  38.454  84.183  1.00 37.07           C
ATOM   1289  O   LEU   155     -15.064  39.218  83.354  1.00 36.32           O
ATOM   1290  N   LYS   156     -15.181  37.376  84.671  1.00 36.92           N
ATOM   1291  CA  LYS   156     -16.451  36.848  84.132  1.00 37.01           C
ATOM   1292  CB  LYS   156     -17.680  37.720  84.475  1.00 37.18           C
ATOM   1293  CG  LYS   156     -17.712  38.389  85.856  1.00 38.58           C
ATOM   1294  CD  LYS   156     -17.848  37.411  87.018  1.00 39.61           C
ATOM   1295  CE  LYS   156     -17.923  38.158  88.346  1.00 39.57           C
ATOM   1296  NZ  LYS   156     -19.301  38.673  88.683  1.00 40.82           N
ATOM   1297  C   LYS   156     -16.327  36.676  82.618  1.00 37.01           C
ATOM   1298  O   LYS   156     -17.227  37.042  81.846  1.00 36.54           O
ATOM   1299  N   ALA   157     -15.191  36.124  82.202  1.00 36.76           N
ATOM   1300  CA  ALA   157     -14.923  35.911  80.797  1.00 37.12           C
ATOM   1301  CB  ALA   157     -13.416  36.198  80.460  1.00 36.14           C
ATOM   1302  C   ALA   157     -15.338  34.509  80.356  1.00 37.35           C
ATOM   1303  O   ALA   157     -15.522  33.600  81.181  1.00 38.21           O
ATOM   1304  N   CYS   158     -15.552  34.391  79.050  1.00 37.47           N
ATOM   1305  CA  CYS   158     -15.746  33.106  78.417  0.50 37.00           C
ATOM   1307  CB  CYS   158     -16.872  33.168  77.395  0.50 37.04           C
ATOM   1309  SG  CYS   158     -18.511  32.998  78.148  0.50 36.19           S
ATOM   1311  C   CYS   158     -14.429  32.667  77.787  1.00 37.08           C
ATOM   1312  O   CYS   158     -13.785  33.425  77.050  1.00 37.37           O
ATOM   1313  N   PRO   159     -13.986  31.421  78.103  1.00 36.60           N
ATOM   1314  CA  PRO   159     -12.637  31.046  77.632  1.00 35.62           C
ATOM   1315  CB  PRO   159     -12.479  29.599  78.104  1.00 35.48           C
ATOM   1316  CG  PRO   159     -13.877  29.111  78.347  1.00 36.57           C
ATOM   1317  CD  PRO   159     -14.643  30.306  78.813  1.00 36.59           C
ATOM   1318  C   PRO   159     -12.480  31.161  76.108  1.00 35.34           C
ATOM   1319  O   PRO   159     -11.385  31.435  75.621  1.00 34.76           O
ATOM   1320  N   GLU   160     -13.581  31.008  75.371  1.00 34.46           N
ATOM   1321  CA  GLU   160     -13.572  31.187  73.918  1.00 34.88           C
ATOM   1322  CB  GLU   160     -14.945  30.864  73.301  1.00 35.84           C
ATOM   1323  CG  GLU   160     -15.293  29.376  73.320  1.00 39.68           C
ATOM   1324  CD  GLU   160     -15.699  28.846  74.709  1.00 43.90           C
ATOM   1325  OE1 GLU   160     -16.231  29.628  75.539  1.00 42.25           O
ATOM   1326  OE2 GLU   160     -15.485  27.629  74.959  1.00 47.49           O
ATOM   1327  C   GLU   160     -13.089  32.572  73.473  1.00 33.86           C
ATOM   1328  O   GLU   160     -12.526  32.703  72.382  1.00 34.28           O
ATOM   1329  N   GLU   161     -13.253  33.581  74.319  1.00 32.56           N
ATOM   1330  CA  GLU   161     -12.852  34.943  73.950  1.00 32.97           C
ATOM   1331  CB  GLU   161     -13.931  35.966  74.329  1.00 33.11           C
ATOM   1332  CG  GLU   161     -14.101  36.232  75.807  1.00 34.27           C
ATOM   1333  CD  GLU   161     -15.469  36.815  76.099  1.00 36.91           C
ATOM   1334  OE1 GLU   161     -16.134  37.214  75.109  1.00 37.88           O
ATOM   1335  OE2 GLU   161     -15.880  36.864  77.293  1.00 35.47           O
ATOM   1336  C   GLU   161     -11.490  35.365  74.503  1.00 32.61           C
ATOM   1337  O   GLU   161     -11.116  36.542  74.411  1.00 32.64           O
ATOM   1338  N   VAL   162     -10.762  34.387  75.044  1.00 31.89           N
ATOM   1339  CA  VAL   162      -9.492  34.613  75.742  1.00 31.91           C
ATOM   1340  CB  VAL   162      -9.493  33.968  77.159  1.00 32.49           C
ATOM   1341  CG1 VAL   162      -8.100  34.070  77.824  1.00 30.64           C
ATOM   1342  CG2 VAL   162     -10.614  34.582  78.046  1.00 30.78           C
ATOM   1343  C   VAL   162      -8.309  34.091  74.928  1.00 31.63           C
ATOM   1344  O   VAL   162      -8.291  32.936  74.492  1.00 30.72           O
ATOM   1345  N   LEU   163      -7.344  34.977  74.708  1.00 31.17           N
ATOM   1346  CA  LEU   163      -6.061  34.599  74.139  1.00 30.89           C
ATOM   1347  CB  LEU   163      -5.693  35.510  72.979  1.00 30.52           C
ATOM   1348  CG  LEU   163      -4.485  35.088  72.144  1.00 30.76           C
ATOM   1349  CD1 LEU   163      -4.643  33.648  71.634  1.00 29.87           C
ATOM   1350  CD2 LEU   163      -4.230  36.063  70.980  1.00 30.98           C
ATOM   1351  C   LEU   163      -4.992  34.696  75.218  1.00 30.75           C
ATOM   1352  O   LEU   163      -4.896  35.708  75.892  1.00 30.06           O
ATOM   1353  N   TYR   164      -4.220  33.626  75.400  1.00 30.91           N
ATOM   1354  CA  TYR   164      -3.047  33.689  76.276  1.00 31.55           C
ATOM   1355  CB  TYR   164      -2.973  32.470  77.203  1.00 31.30           C
ATOM   1356  CG  TYR   164      -1.902  32.618  78.276  1.00 33.40           C
ATOM   1357  CD1 TYR   164      -1.848  33.781  79.067  1.00 31.47           C
ATOM   1358  CE1 TYR   164      -0.887  33.944  80.053  1.00 31.32           C
ATOM   1359  CZ  TYR   164       0.062  32.967  80.262  1.00 33.71           C
ATOM   1360  OH  TYR   164       0.992  33.188  81.240  1.00 32.32           O
ATOM   1361  CE2 TYR   164       0.062  31.782  79.482  1.00 33.92           C
ATOM   1362  CD2 TYR   164      -0.937  31.621  78.489  1.00 31.66           C
ATOM   1363  C   TYR   164      -1.755  33.813  75.451  1.00 31.34           C
ATOM   1364  O   TYR   164      -1.534  33.038  74.515  1.00 32.53           O
ATOM   1365  N   ILE   165      -0.889  34.758  75.810  1.00 30.69           N
ATOM   1366  CA  ILE   165       0.335  35.049  75.040  1.00 29.49           C
ATOM   1367  CB  ILE   165       0.318  36.514  74.448  1.00 29.51           C
ATOM   1368  CG1 ILE   165      -0.932  36.778  73.604  1.00 30.79           C
ATOM   1369  CD1 ILE   165      -2.039  37.483  74.342  1.00 27.44           C
ATOM   1370  CG2 ILE   165       1.575  36.794  73.636  1.00 31.57           C
ATOM   1371  C   ILE   165       1.578  34.886  75.917  1.00 29.05           C
ATOM   1372  O   ILE   165       1.688  35.541  76.944  1.00 28.44           O
ATOM   1373  N   GLY   166       2.518  34.023  75.520  1.00 28.54           N
ATOM   1374  CA  GLY   166       3.679  33.738  76.376  1.00 27.39           C
ATOM   1375  C   GLY   166       4.878  33.445  75.510  1.00 28.08           C
ATOM   1376  O   GLY   166       4.733  33.328  74.274  1.00 26.75           O
ATOM   1377  N   ASP   167       6.054  33.333  76.146  1.00 27.57           N
ATOM   1378  CA  ASP   167       7.293  33.064  75.426  1.00 27.78           C
ATOM   1379  CB  ASP   167       8.381  34.005  75.922  1.00 27.52           C
ATOM   1380  CG  ASP   167       8.800  33.669  77.324  1.00 28.93           C
ATOM   1381  OD1 ASP   167       7.990  33.939  78.215  1.00 30.91           O
ATOM   1382  OD2 ASP   167       9.906  33.108  77.533  1.00 31.75           O
ATOM   1383  C   ASP   167       7.845  31.632  75.580  1.00 27.57           C
ATOM   1384  O   ASP   167       8.887  31.301  74.972  1.00 27.83           O
ATOM   1385  N   SER   168       7.202  30.825  76.429  1.00 27.47           N
ATOM   1386  CA  SER   168       7.723  29.516  76.835  1.00 26.64           C
ATOM   1387  CB  SER   168       8.025  29.498  78.332  1.00 26.94           C
ATOM   1388  OG  SER   168       6.799  29.549  79.034  1.00 29.70           O
ATOM   1389  C   SER   168       6.726  28.410  76.620  1.00 26.30           C
ATOM   1390  O   SER   168       5.504  28.656  76.474  1.00 26.45           O
ATOM   1391  N   THR   169       7.244  27.180  76.644  1.00 26.12           N
ATOM   1392  CA  THR   169       6.397  25.999  76.621  1.00 26.28           C
ATOM   1393  CB  THR   169       7.173  24.733  76.318  1.00 26.36           C
ATOM   1394  OG1 THR   169       8.277  24.663  77.212  1.00 26.70           O
ATOM   1395  CG2 THR   169       7.683  24.770  74.879  1.00 27.73           C
ATOM   1396  C   THR   169       5.599  25.815  77.893  1.00 25.69           C
ATOM   1397  O   THR   169       4.515  25.237  77.832  1.00 24.92           O
ATOM   1398  N   VAL   170       6.111  26.329  79.025  1.00 26.07           N
ATOM   1399  CA  VAL   170       5.317  26.449  80.275  1.00 25.83           C
ATOM   1400  CB  VAL   170       6.131  27.138  81.409  1.00 25.84           C
ATOM   1401  CG1 VAL   170       5.222  27.558  82.582  1.00 26.91           C
ATOM   1402  CG2 VAL   170       7.246  26.221  81.886  1.00 26.04           C
ATOM   1403  C   VAL   170       4.024  27.208  80.008  1.00 25.47           C
ATOM   1404  O   VAL   170       2.911  26.778  80.406  1.00 25.40           O
ATOM   1405  N   ASP   171       4.162  28.332  79.312  1.00 26.32           N
ATOM   1406  CA  ASP   171       2.985  29.153  78.990  1.00 26.34           C
ATOM   1407  CB  ASP   171       3.435  30.463  78.358  1.00 27.70           C
ATOM   1408  CG  ASP   171       4.084  31.399  79.350  1.00 27.98           C
ATOM   1409  OD1 ASP   171       3.752  31.363  80.551  1.00 28.13           O
ATOM   1410  OD2 ASP   171       4.947  32.188  78.932  1.00 32.79           O
ATOM   1411  C   ASP   171       2.065  28.413  78.038  1.00 26.85           C
ATOM   1412  O   ASP   171       0.828  28.439  78.209  1.00 26.61           O
ATOM   1413  N   ALA   172       2.649  27.764  77.024  1.00 25.61           N
ATOM   1414  CA  ALA   172       1.865  27.000  76.055  1.00 27.11           C
ATOM   1415  CB  ALA   172       2.741  26.409  74.899  1.00 26.48           C
ATOM   1416  C   ALA   172       1.104  25.888  76.751  1.00 27.31           C
ATOM   1417  O   ALA   172      -0.092  25.728  76.502  1.00 26.13           O
ATOM   1418  N   GLY   173       1.804  25.125  77.599  1.00 27.21           N
ATOM   1419  CA  GLY   173       1.167  24.118  78.457  1.00 28.14           C
ATOM   1420  C   GLY   173       0.059  24.691  79.333  1.00 28.11           C
ATOM   1421  O   GLY   173      -0.985  24.062  79.505  1.00 28.46           O
ATOM   1422  N   THR   174       0.263  25.898  79.858  1.00 29.04           N
ATOM   1423  CA  THR   174      -0.746  26.532  80.739  1.00 28.63           C
ATOM   1424  CB  THR   174      -0.239  27.845  81.422  1.00 29.14           C
ATOM   1425  OG1 THR   174       1.062  27.635  82.011  1.00 28.42           O
ATOM   1426  CG2 THR   174      -1.201  28.270  82.494  1.00 28.38           C
ATOM   1427  C   THR   174      -2.017  26.816  79.962  1.00 28.93           C
ATOM   1428  O   THR   174      -3.104  26.500  80.426  1.00 28.93           O
ATOM   1429  N   ALA   175      -1.891  27.400  78.777  1.00 29.27           N
ATOM   1430  CA  ALA   175      -3.101  27.700  77.976  1.00 30.09           C
ATOM   1431  CB  ALA   175      -2.757  28.491  76.732  1.00 29.49           C
ATOM   1432  C   ALA   175      -3.856  26.427  77.621  1.00 30.13           C
ATOM   1433  O   ALA   175      -5.083  26.372  77.793  1.00 31.05           O
ATOM   1434  N   ALA   176      -3.130  25.392  77.172  1.00 29.92           N
ATOM   1435  CA  ALA   176      -3.758  24.090  76.823  1.00 30.22           C
ATOM   1436  CB  ALA   176      -2.712  23.076  76.314  1.00 29.67           C
ATOM   1437  C   ALA   176      -4.493  23.521  78.016  1.00 30.43           C
ATOM   1438  O   ALA   176      -5.688  23.205  77.949  1.00 31.30           O
ATOM   1439  N   ALA   177      -3.789  23.413  79.136  1.00 30.95           N
ATOM   1440  CA  ALA   177      -4.426  22.959  80.380  1.00 30.86           C
ATOM   1441  CB  ALA   177      -3.414  22.929  81.542  1.00 29.64           C
ATOM   1442  C   ALA   177      -5.706  23.754  80.734  1.00 30.96           C
ATOM   1443  O   ALA   177      -6.680  23.173  81.213  1.00 30.26           O
ATOM   1444  N   ALA   178      -5.704  25.069  80.481  1.00 31.93           N
ATOM   1445  CA  ALA   178      -6.880  25.919  80.731  1.00 32.07           C
ATOM   1446  CB  ALA   178      -6.452  27.382  80.979  1.00 32.87           C
ATOM   1447  C   ALA   178      -7.969  25.844  79.648  1.00 32.72           C
ATOM   1448  O   ALA   178      -9.077  26.302  79.867  1.00 32.75           O
ATOM   1449  N   GLY   179      -7.658  25.254  78.492  1.00 33.13           N
ATOM   1450  CA  GLY   179      -8.605  25.194  77.382  1.00 32.75           C
ATOM   1451  C   GLY   179      -8.815  26.571  76.764  1.00 32.66           C
ATOM   1452  O   GLY   179      -9.944  26.923  76.399  1.00 32.34           O
ATOM   1453  N   VAL   180      -7.730  27.353  76.664  1.00 31.61           N
ATOM   1454  CA  VAL   180      -7.770  28.641  75.970  1.00 30.94           C
ATOM   1455  CB  VAL   180      -7.629  29.867  76.972  1.00 31.08           C
ATOM   1456  CG1 VAL   180      -8.695  29.789  78.112  1.00 29.39           C
ATOM   1457  CG2 VAL   180      -6.241  29.942  77.538  1.00 29.49           C
ATOM   1458  C   VAL   180      -6.735  28.739  74.816  1.00 31.18           C
ATOM   1459  O   VAL   180      -5.669  28.123  74.866  1.00 30.89           O
ATOM   1460  N   SER   181      -7.039  29.545  73.803  1.00 30.60           N
ATOM   1461  CA  SER   181      -6.119  29.762  72.685  1.00 30.70           C
ATOM   1462  CB  SER   181      -6.775  30.642  71.613  1.00 30.53           C
ATOM   1463  OG  SER   181      -7.894  29.988  70.999  1.00 29.90           O
ATOM   1464  C   SER   181      -4.772  30.355  73.106  1.00 30.60           C
ATOM   1465  O   SER   181      -4.698  31.208  74.007  1.00 30.11           O
ATOM   1466  N   PHE   182      -3.709  29.900  72.440  1.00 30.07           N
ATOM   1467  CA  PHE   182      -2.341  30.369  72.734  1.00 29.70           C
ATOM   1468  CB  PHE   182      -1.478  29.205  73.229  1.00 28.93           C
ATOM   1469  CG  PHE   182      -0.081  29.612  73.644  1.00 30.73           C
ATOM   1470  CD1 PHE   182       0.124  30.449  74.761  1.00 29.47           C
ATOM   1471  CE1 PHE   182       1.406  30.827  75.151  1.00 31.11           C
ATOM   1472  CZ  PHE   182       2.526  30.332  74.445  1.00 28.39           C
ATOM   1473  CE2 PHE   182       2.328  29.475  73.331  1.00 28.33           C
ATOM   1474  CD2 PHE   182       1.034  29.106  72.962  1.00 28.37           C
ATOM   1475  C   PHE   182      -1.633  31.041  71.564  1.00 29.02           C
ATOM   1476  O   PHE   182      -1.695  30.573  70.424  1.00 28.62           O
ATOM   1477  N   THR   183      -0.943  32.151  71.841  1.00 30.11           N
ATOM   1478  CA  THR   183      -0.018  32.699  70.860  1.00 28.82           C
ATOM   1479  CB  THR   183      -0.516  34.033  70.270  1.00 30.12           C
ATOM   1480  OG1 THR   183      -1.611  33.747  69.388  1.00 30.28           O
ATOM   1481  CG2 THR   183       0.621  34.771  69.486  1.00 27.41           C
ATOM   1482  C   THR   183       1.368  32.763  71.471  1.00 28.92           C
ATOM   1483  O   THR   183       1.591  33.421  72.491  1.00 27.48           O
ATOM   1484  N   GLY   184       2.284  32.020  70.873  1.00 28.36           N
ATOM   1485  CA  GLY   184       3.663  32.001  71.341  1.00 28.69           C
ATOM   1486  C   GLY   184       4.432  33.175  70.739  1.00 29.40           C
ATOM   1487  O   GLY   184       4.204  33.561  69.581  1.00 29.16           O
ATOM   1488  N   VAL   185       5.289  33.775  71.553  1.00 29.52           N
ATOM   1489  CA  VAL   185       6.227  34.823  71.108  0.50 29.57           C
ATOM   1491  CB  VAL   185       5.977  36.191  71.805  0.50 29.47           C
ATOM   1493  CG1 VAL   185       6.778  37.296  71.119  0.50 30.12           C
ATOM   1495  CG2 VAL   185       4.518  36.544  71.808  0.50 29.56           C
ATOM   1497  C   VAL   185       7.653  34.390  71.427  1.00 29.06           C
ATOM   1498  O   VAL   185       7.987  34.165  72.587  1.00 29.80           O
ATOM   1499  N   THR   186       8.501  34.296  70.412  1.00 29.30           N
ATOM   1500  CA  THR   186       9.882  33.835  70.612  1.00 28.58           C
ATOM   1501  CB  THR   186      10.460  33.142  69.334  1.00 28.68           C
ATOM   1502  OG1 THR   186      10.512  34.084  68.261  1.00 29.27           O
ATOM   1503  CG2 THR   186       9.609  31.926  68.898  1.00 27.42           C
ATOM   1504  C   THR   186      10.818  34.915  71.149  1.00 28.67           C
ATOM   1505  O   THR   186      11.954  35.027  70.700  1.00 28.42           O
ATOM   1506  N   SER   187      10.357  35.678  72.149  1.00 28.95           N
ATOM   1507  CA  SER   187      11.169  36.731  72.796  1.00 29.25           C
ATOM   1508  CB  SER   187      10.308  37.935  73.169  1.00 29.27           C
ATOM   1509  OG  SER   187       9.157  37.486  73.857  1.00 31.18           O
ATOM   1510  C   SER   187      11.890  36.215  74.052  1.00 29.26           C
ATOM   1511  O   SER   187      12.588  36.976  74.717  1.00 28.99           O
ATOM   1512  N   GLY   188      11.722  34.929  74.357  1.00 29.16           N
ATOM   1513  CA  GLY   188      12.452  34.291  75.446  1.00 29.38           C
ATOM   1514  C   GLY   188      13.575  33.397  74.951  1.00 29.82           C
ATOM   1515  O   GLY   188      14.352  33.786  74.080  1.00 30.49           O
ATOM   1516  N   MET   189      13.652  32.185  75.503  1.00 30.04           N
ATOM   1517  CA  MET   189      14.651  31.196  75.092  1.00 30.01           C
ATOM   1518  CB  MET   189      15.408  30.630  76.296  1.00 30.07           C
ATOM   1519  CG  MET   189      16.126  31.615  77.109  1.00 31.09           C
ATOM   1520  SD  MET   189      17.657  32.307  76.282  0.70 34.38          SE
ATOM   1521  CE  MET   189      18.750  30.708  76.149  1.00 34.13           C
ATOM   1522  C   MET   189      14.031  30.019  74.345  1.00 29.96           C
ATOM   1523  O   MET   189      14.740  29.062  74.018  1.00 29.46           O
ATOM   1524  N   THR   190      12.727  30.090  74.101  1.00 29.08           N
ATOM   1525  CA  THR   190      11.991  29.049  73.389  1.00 30.03           C
ATOM   1526  CB  THR   190      10.582  28.862  73.995  1.00 30.20           C
ATOM   1527  OG1 THR   190      10.719  28.608  75.384  1.00 34.60           O
ATOM   1528  CG2 THR   190       9.802  27.720  73.330  1.00 30.40           C
ATOM   1529  C   THR   190      11.851  29.425  71.916  1.00 29.62           C
ATOM   1530  O   THR   190      11.431  30.545  71.578  1.00 29.07           O
ATOM   1531  N   THR   191      12.216  28.473  71.061  1.00 29.44           N
ATOM   1532  CA  THR   191      12.183  28.624  69.607  1.00 29.39           C
ATOM   1533  CB  THR   191      13.310  27.793  68.957  1.00 30.38           C
ATOM   1534  OG1 THR   191      12.979  26.401  69.037  1.00 30.50           O
ATOM   1535  CG2 THR   191      14.646  28.058  69.660  1.00 28.76           C
ATOM   1536  C   THR   191      10.853  28.152  69.045  1.00 29.76           C
ATOM   1537  O   THR   191      10.117  27.432  69.739  1.00 29.53           O
ATOM   1538  N   ALA   192      10.544  28.548  67.793  1.00 29.58           N
ATOM   1539  CA  ALA   192       9.320  28.119  67.118  1.00 29.13           C
ATOM   1540  CB  ALA   192       9.172  28.791  65.722  1.00 29.19           C
ATOM   1541  C   ALA   192       9.223  26.577  67.008  1.00 29.09           C
ATOM   1542  O   ALA   192       8.128  26.005  67.122  1.00 28.85           O
ATOM   1543  N   GLN   193      10.355  25.922  66.777  1.00 28.17           N
ATOM   1544  CA  GLN   193      10.406  24.464  66.753  1.00 28.79           C
ATOM   1545  CB  GLN   193      11.809  23.956  66.399  1.00 28.22           C
ATOM   1546  CG  GLN   193      11.884  22.420  66.195  1.00 29.86           C
ATOM   1547  CD  GLN   193      12.031  21.593  67.516  1.00 33.91           C
ATOM   1548  OE1 GLN   193      12.375  22.130  68.580  1.00 36.29           O
ATOM   1549  NE2 GLN   193      11.770  20.281  67.433  1.00 31.80           N
ATOM   1550  C   GLN   193       9.957  23.869  68.077  1.00 28.83           C
ATOM   1551  O   GLN   193       9.182  22.911  68.082  1.00 29.61           O
ATOM   1552  N   GLU   194      10.404  24.455  69.195  1.00 27.92           N
ATOM   1553  CA  GLU   194      10.016  23.973  70.520  1.00 27.72           C
ATOM   1554  CB  GLU   194      10.903  24.578  71.604  1.00 28.41           C
ATOM   1555  CG  GLU   194      12.358  24.124  71.434  1.00 29.11           C
ATOM   1556  CD  GLU   194      13.352  24.946  72.264  1.00 33.55           C
ATOM   1557  OE1 GLU   194      13.063  26.101  72.631  1.00 31.87           O
ATOM   1558  OE2 GLU   194      14.468  24.438  72.505  1.00 36.61           O
ATOM   1559  C   GLU   194       8.539  24.118  70.849  1.00 28.13           C
ATOM   1560  O   GLU   194       7.996  23.286  71.576  1.00 28.95           O
ATOM   1561  N   PHE   195       7.876  25.134  70.291  1.00 27.78           N
ATOM   1562  CA  PHE   195       6.448  25.356  70.560  1.00 27.60           C
ATOM   1563  CB  PHE   195       5.999  26.722  70.031  1.00 27.04           C
ATOM   1564  CG  PHE   195       6.227  27.873  70.988  1.00 28.57           C
ATOM   1565  CD1 PHE   195       5.556  27.932  72.213  1.00 28.10           C
ATOM   1566  CE1 PHE   195       5.738  29.019  73.065  1.00 28.60           C
ATOM   1567  CZ  PHE   195       6.623  30.059  72.707  1.00 28.17           C
ATOM   1568  CE2 PHE   195       7.285  30.014  71.505  1.00 29.42           C
ATOM   1569  CD2 PHE   195       7.073  28.920  70.636  1.00 29.20           C
ATOM   1570  C   PHE   195       5.595  24.322  69.886  1.00 27.81           C
ATOM   1571  O   PHE   195       4.388  24.246  70.172  1.00 28.62           O
ATOM   1572  N   GLN   196       6.193  23.565  68.953  1.00 28.00           N
ATOM   1573  CA  GLN   196       5.415  22.654  68.060  1.00 28.03           C
ATOM   1574  CB  GLN   196       6.234  22.121  66.858  1.00 28.17           C
ATOM   1575  CG  GLN   196       6.634  23.160  65.824  1.00 29.26           C
ATOM   1576  CD  GLN   196       5.496  24.111  65.490  1.00 32.07           C
ATOM   1577  OE1 GLN   196       4.407  23.676  65.136  1.00 31.14           O
ATOM   1578  NE2 GLN   196       5.751  25.418  65.584  1.00 32.53           N
ATOM   1579  C   GLN   196       4.828  21.505  68.847  1.00 27.41           C
ATOM   1580  O   GLN   196       3.836  20.909  68.443  1.00 26.80           O
ATOM   1581  N   ALA   197       5.441  21.233  70.000  1.00 27.36           N
ATOM   1582  CA  ALA   197       4.963  20.211  70.916  1.00 27.34           C
ATOM   1583  CB  ALA   197       5.976  19.969  71.995  1.00 27.40           C
ATOM   1584  C   ALA   197       3.599  20.549  71.529  1.00 26.75           C
ATOM   1585  O   ALA   197       2.985  19.700  72.159  1.00 27.17           O
ATOM   1586  N   TYR   198       3.132  21.784  71.348  1.00 27.66           N
ATOM   1587  CA  TYR   198       1.888  22.273  71.987  1.00 27.71           C
ATOM   1588  CB  TYR   198       2.222  23.218  73.155  1.00 28.98           C
ATOM   1589  CG  TYR   198       3.075  22.606  74.241  1.00 31.68           C
ATOM   1590  CD1 TYR   198       2.493  22.084  75.418  1.00 31.00           C
ATOM   1591  CE1 TYR   198       3.317  21.526  76.432  1.00 33.40           C
ATOM   1592  CZ  TYR   198       4.701  21.471  76.220  1.00 31.87           C
ATOM   1593  OH  TYR   198       5.542  20.945  77.177  1.00 33.47           O
ATOM   1594  CE2 TYR   198       5.276  21.957  75.053  1.00 31.80           C
ATOM   1595  CD2 TYR   198       4.478  22.534  74.089  1.00 30.17           C
ATOM   1596  C   TYR   198       1.028  23.062  71.006  1.00 27.44           C
ATOM   1597  O   TYR   198       1.554  23.596  70.012  1.00 25.39           O
ATOM   1598  N   PRO   199      -0.291  23.188  71.307  1.00 26.95           N
ATOM   1599  CA  PRO   199      -1.191  23.937  70.432  1.00 27.37           C
ATOM   1600  CB  PRO   199      -2.607  23.578  70.968  1.00 27.67           C
ATOM   1601  CG  PRO   199      -2.415  22.459  71.974  1.00 26.62           C
ATOM   1602  CD  PRO   199      -0.996  22.613  72.470  1.00 27.05           C
ATOM   1603  C   PRO   199      -0.940  25.455  70.438  1.00 27.64           C
ATOM   1604  O   PRO   199      -0.574  26.036  71.464  1.00 28.07           O
ATOM   1605  N   TYR   200      -1.122  26.094  69.291  1.00 28.51           N
ATOM   1606  CA  TYR   200      -0.984  27.553  69.181  1.00 28.39           C
ATOM   1607  CB  TYR   200       0.483  27.956  68.937  1.00 28.12           C
ATOM   1608  CG  TYR   200       1.092  27.286  67.713  1.00 29.23           C
ATOM   1609  CD1 TYR   200       1.055  27.904  66.452  1.00 30.22           C
ATOM   1610  CE1 TYR   200       1.600  27.269  65.316  1.00 27.75           C
ATOM   1611  CZ  TYR   200       2.163  26.012  65.453  1.00 28.10           C
ATOM   1612  OH  TYR   200       2.700  25.386  64.349  1.00 28.06           O
ATOM   1613  CE2 TYR   200       2.194  25.374  66.692  1.00 26.81           C
ATOM   1614  CD2 TYR   200       1.675  26.006  67.805  1.00 29.53           C
ATOM   1615  C   TYR   200      -1.854  28.017  68.011  1.00 29.50           C
ATOM   1616  O   TYR   200      -2.206  27.214  67.120  1.00 28.52           O
ATOM   1617  N   ASP   201      -2.167  29.306  68.021  1.00 29.42           N
ATOM   1618  CA  ASP   201      -2.749  29.989  66.892  1.00 30.78           C
ATOM   1619  CB  ASP   201      -3.443  31.268  67.386  1.00 31.84           C
ATOM   1620  CG  ASP   201      -4.895  31.063  67.642  1.00 34.16           C
ATOM   1621  OD1 ASP   201      -5.302  29.885  67.776  1.00 35.12           O
ATOM   1622  OD2 ASP   201      -5.629  32.079  67.695  1.00 37.28           O
ATOM   1623  C   ASP   201      -1.698  30.412  65.906  1.00 30.46           C
ATOM   1624  O   ASP   201      -1.764  30.067  64.733  1.00 30.55           O
ATOM   1625  N   ARG   202      -0.770  31.219  66.409  1.00 30.69           N
ATOM   1626  CA  ARG   202       0.383  31.726  65.703  1.00 30.71           C
ATOM   1627  CB  ARG   202       0.173  33.219  65.357  1.00 30.87           C
ATOM   1628  CG  ARG   202      -0.615  33.475  64.109  1.00 32.31           C
ATOM   1629  CD  ARG   202      -0.559  34.954  63.773  1.00 35.48           C
ATOM   1630  NE  ARG   202      -1.190  35.768  64.806  1.00 37.62           N
ATOM   1631  CZ  ARG   202      -1.028  37.082  64.932  1.00 39.80           C
ATOM   1632  NH1 ARG   202      -0.239  37.745  64.091  1.00 42.12           N
ATOM   1633  NH2 ARG   202      -1.656  37.733  65.893  1.00 38.13           N
ATOM   1634  C   ARG   202       1.593  31.653  66.626  1.00 30.68           C
ATOM   1635  O   ARG   202       1.461  31.511  67.855  1.00 31.05           O
ATOM   1636  N   ILE   203       2.775  31.719  66.016  1.00 29.99           N
ATOM   1637  CA  ILE   203       4.021  31.914  66.733  0.50 29.91           C
ATOM   1639  CB  ILE   203       4.980  30.689  66.644  0.50 29.40           C
ATOM   1641  CG1 ILE   203       4.316  29.388  67.127  0.50 28.07           C
ATOM   1643  CD1 ILE   203       4.012  29.281  68.634  0.50 24.34           C
ATOM   1645  CG2 ILE   203       6.279  30.975  67.415  0.50 30.13           C
ATOM   1647  C   ILE   203       4.680  33.123  66.078  1.00 30.29           C
ATOM   1648  O   ILE   203       5.018  33.072  64.882  1.00 31.17           O
ATOM   1649  N   ILE   204       4.859  34.190  66.853  1.00 30.12           N
ATOM   1650  CA  ILE   204       5.346  35.470  66.342  1.00 30.67           C
ATOM   1651  CB  ILE   204       4.348  36.614  66.701  1.00 30.30           C
ATOM   1652  CG1 ILE   204       3.968  36.571  68.184  1.00 30.24           C
ATOM   1653  CD1 ILE   204       3.245  37.841  68.688  1.00 31.03           C
ATOM   1654  CG2 ILE   204       3.063  36.491  65.837  1.00 30.53           C
ATOM   1655  C   ILE   204       6.740  35.752  66.864  1.00 30.85           C
ATOM   1656  O   ILE   204       7.143  35.145  67.855  1.00 32.34           O
ATOM   1657  N   SER   205       7.479  36.657  66.223  1.00 30.89           N
ATOM   1658  CA  SER   205       8.802  37.060  66.731  1.00 31.63           C
ATOM   1659  CB  SER   205       9.761  37.523  65.616  1.00 31.53           C
ATOM   1660  OG  SER   205       9.422  36.957  64.387  1.00 34.62           O
ATOM   1661  C   SER   205       8.726  38.184  67.727  1.00 31.36           C
ATOM   1662  O   SER   205       9.549  38.262  68.636  1.00 31.48           O
ATOM   1663  N   THR   206       7.780  39.094  67.528  1.00 31.39           N
ATOM   1664  CA  THR   206       7.694  40.256  68.397  1.00 31.78           C
ATOM   1665  CB  THR   206       8.300  41.547  67.768  1.00 31.65           C
ATOM   1666  OG1 THR   206       7.678  41.831  66.496  1.00 29.92           O
ATOM   1667  CG2 THR   206       9.799  41.393  67.560  1.00 31.94           C
ATOM   1668  C   THR   206       6.249  40.468  68.768  1.00 32.33           C
ATOM   1669  O   THR   206       5.361  40.078  68.033  1.00 32.08           O
ATOM   1670  N   LEU   207       6.031  41.076  69.926  1.00 32.23           N
ATOM   1671  CA  LEU   207       4.695  41.333  70.432  1.00 32.50           C
ATOM   1672  CB  LEU   207       4.810  42.054  71.769  1.00 32.65           C
ATOM   1673  CG  LEU   207       3.731  41.888  72.812  1.00 32.55           C
ATOM   1674  CD1 LEU   207       3.511  40.409  73.119  1.00 31.90           C
ATOM   1675  CD2 LEU   207       4.156  42.696  74.074  1.00 32.43           C
ATOM   1676  C   LEU   207       3.883  42.193  69.491  1.00 32.69           C
ATOM   1677  O   LEU   207       2.659  42.042  69.420  1.00 31.97           O
ATOM   1678  N   GLY   208       4.566  43.099  68.785  1.00 33.30           N
ATOM   1679  CA  GLY   208       3.915  44.042  67.854  1.00 34.10           C
ATOM   1680  C   GLY   208       3.157  43.356  66.723  1.00 34.93           C
ATOM   1681  O   GLY   208       2.197  43.917  66.148  1.00 34.41           O
ATOM   1682  N   GLN   209       3.585  42.132  66.426  1.00 35.26           N
ATOM   1683  CA  GLN   209       2.970  41.301  65.428  1.00 37.01           C
ATOM   1684  CB  GLN   209       3.897  40.153  65.086  1.00 37.01           C
ATOM   1685  CG  GLN   209       4.944  40.551  64.079  1.00 39.42           C
ATOM   1686  CD  GLN   209       6.007  39.515  63.924  1.00 43.33           C
ATOM   1687  OE1 GLN   209       5.726  38.322  63.928  1.00 47.40           O
ATOM   1688  NE2 GLN   209       7.246  39.958  63.786  1.00 44.87           N
ATOM   1689  C   GLN   209       1.622  40.782  65.877  1.00 37.66           C
ATOM   1690  O   GLN   209       0.838  40.275  65.078  1.00 37.76           O
ATOM   1691  N   LEU   210       1.340  40.922  67.159  1.00 38.30           N
ATOM   1692  CA  LEU   210       0.026  40.564  67.689  1.00 39.49           C
ATOM   1693  CB  LEU   210       0.023  40.739  69.216  1.00 39.62           C
ATOM   1694  CG  LEU   210      -0.703  39.828  70.214  1.00 39.33           C
ATOM   1695  CD1 LEU   210      -0.693  38.331  69.883  1.00 36.10           C
ATOM   1696  CD2 LEU   210      -0.077  40.083  71.560  1.00 37.45           C
ATOM   1697  C   LEU   210      -1.054  41.400  67.016  1.00 40.60           C
ATOM   1698  O   LEU   210      -2.172  40.925  66.781  1.00 41.32           O
ATOM   1699  N   ILE   211      -0.697  42.640  66.685  1.00 41.56           N
ATOM   1700  CA  ILE   211      -1.547  43.572  65.950  1.00 41.96           C
ATOM   1701  CB  ILE   211      -1.172  45.062  66.259  1.00 42.21           C
ATOM   1702  CG1 ILE   211      -1.168  45.366  67.774  1.00 42.34           C
ATOM   1703  CD1 ILE   211      -2.480  45.107  68.511  1.00 41.30           C
ATOM   1704  CG2 ILE   211      -2.040  46.032  65.448  1.00 43.37           C
ATOM   1705  C   ILE   211      -1.374  43.340  64.456  1.00 41.85           C
ATOM   1706  O   ILE   211      -2.312  42.930  63.776  1.00 42.35           O
END
