
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  216 ( 1733),  selected  216 , name 2pib_A
# Molecule2: number of CA atoms  210 ( 1658),  selected  210 , name T0418.pdb
# PARAMETERS: 2pib_A.T0418.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      K       2           -
LGA    X     1_A      Y       3          2.526
LGA    E     2_A      T       4          1.387
LGA    A     3_A      V       5          0.966
LGA    V     4_A      Y       6          0.959
LGA    I     5_A      L       7          0.890
LGA    F     6_A      F       8          0.688
LGA    D     7_A      D       9          0.886
LGA    X     8_A      F      10          1.014
LGA    D     9_A      D      11          1.136
LGA    G    10_A      Y      12          1.283
LGA    V    11_A      T      13          0.635
LGA    L    12_A      L      14          0.802
LGA    X    13_A      A      15          0.868
LGA    D    14_A      D      16          2.217
LGA    T    15_A      S      17          1.989
LGA    E    16_A      S      18          2.636
LGA    P    17_A      R      19          3.398
LGA    L    18_A      G      20          3.034
LGA    Y    19_A      I      21          3.112
LGA    F    20_A      V      22          3.322
LGA    E    21_A      T      23          3.269
LGA    A    22_A      C      24          3.756
LGA    Y    23_A      F      25          5.053
LGA    R    24_A      R      26          5.443
LGA    R    25_A      S      27          5.891
LGA    V    26_A      -       -           -
LGA    A    27_A      V      28           #
LGA    E    28_A      L      29           -
LGA    S    29_A      E      30           -
LGA    Y    30_A      R      31           #
LGA    G    31_A      H      32           -
LGA    K    32_A      G      33           -
LGA    P    33_A      Y      34           -
LGA    Y    34_A      T      35           #
LGA    T    35_A      -       -           -
LGA    E    36_A      -       -           -
LGA    D    37_A      G      36          3.565
LGA    L    38_A      I      37          2.169
LGA    H    39_A      T      38          3.831
LGA    R    40_A      D      39          4.142
LGA    -       -      D      40           -
LGA    R    41_A      M      41          4.754
LGA    I    42_A      -       -           -
LGA    X    43_A      -       -           -
LGA    G    44_A      I      42           #
LGA    -       -      K      43           -
LGA    -       -      R      44           -
LGA    -       -      T      45           -
LGA    -       -      I      46           -
LGA    -       -      G      47           -
LGA    -       -      K      48           -
LGA    -       -      T      49           -
LGA    -       -      L      50           -
LGA    -       -      E      51           -
LGA    -       -      E      52           -
LGA    V    45_A      S      53          3.365
LGA    P    46_A      F      54          2.717
LGA    E    47_A      S      55           #
LGA    R    48_A      I      56           -
LGA    -       -      L      57           -
LGA    -       -      T      58           -
LGA    -       -      G      59           -
LGA    -       -      I      60           -
LGA    -       -      T      61           -
LGA    -       -      D      62           -
LGA    -       -      A      63           -
LGA    -       -      D      64           -
LGA    -       -      Q      65           -
LGA    E    49_A      L      66          3.789
LGA    G    50_A      E      67           -
LGA    -       -      S      68           -
LGA    L    51_A      F      69          4.080
LGA    P    52_A      R      70           -
LGA    I    53_A      Q      71           -
LGA    L    54_A      -       -           -
LGA    X    55_A      -       -           -
LGA    E    56_A      -       -           -
LGA    A    57_A      -       -           -
LGA    L    58_A      -       -           -
LGA    E    59_A      -       -           -
LGA    I    60_A      -       -           -
LGA    K    61_A      -       -           -
LGA    D    62_A      -       -           -
LGA    S    63_A      -       -           -
LGA    L    64_A      -       -           -
LGA    E    65_A      -       -           -
LGA    N    66_A      -       -           -
LGA    F    67_A      -       -           -
LGA    K    68_A      E      72          1.632
LGA    K    69_A      -       -           -
LGA    R    70_A      -       -           -
LGA    V    71_A      Y      73          4.453
LGA    H    72_A      S      74          3.744
LGA    E    73_A      K      75          4.281
LGA    E    74_A      E      76          3.635
LGA    K    75_A      A      77          2.888
LGA    K    76_A      D      78          3.259
LGA    R    77_A      I      79          3.207
LGA    V    78_A      Y      80          2.712
LGA    F    79_A      M      81          2.616
LGA    S    80_A      N      82          3.757
LGA    E    81_A      A      83          2.990
LGA    L    82_A      N      84          2.586
LGA    L    83_A      T      85          1.352
LGA    K    84_A      I      86          1.062
LGA    E    85_A      L      87          0.804
LGA    N    86_A      F      88          1.098
LGA    P    87_A      P      89          1.130
LGA    G    88_A      D      90          0.482
LGA    V    89_A      T      91          0.933
LGA    R    90_A      L      92          0.815
LGA    E    91_A      P      93          0.749
LGA    A    92_A      T      94          0.818
LGA    L    93_A      L      95          0.593
LGA    E    94_A      T      96          0.322
LGA    F    95_A      H      97          0.636
LGA    V    96_A      L      98          0.757
LGA    K    97_A      K      99          0.532
LGA    S    98_A      K     100          0.487
LGA    K    99_A      Q     101          0.508
LGA    R   100_A      G     102          1.072
LGA    I   101_A      I     103          1.357
LGA    K   102_A      R     104          0.928
LGA    L   103_A      I     105          0.985
LGA    A   104_A      G     106          1.244
LGA    L   105_A      I     107          1.143
LGA    A   106_A      I     108          0.886
LGA    T   107_A      S     109          1.002
LGA    S   108_A      T     110          1.671
LGA    T   109_A      K     111          2.081
LGA    P   110_A      Y     112          2.621
LGA    Q   111_A      R     113          2.373
LGA    R   112_A      F     114          1.976
LGA    E   113_A      R     115          2.523
LGA    A   114_A      I     116          2.550
LGA    L   115_A      L     117          1.735
LGA    E   116_A      S     118          1.761
LGA    R   117_A      F     119          2.308
LGA    L   118_A      L     120          2.332
LGA    R   119_A      R     121          2.074
LGA    R   120_A      N     122          3.348
LGA    L   121_A      H     123          2.514
LGA    D   122_A      M     124          2.774
LGA    L   123_A      P     125           #
LGA    E   124_A      D     126          5.122
LGA    K   125_A      D     127          1.847
LGA    Y   126_A      W     128          1.213
LGA    F   127_A      F     129          0.529
LGA    D   128_A      D     130          1.072
LGA    V   129_A      I     131          1.621
LGA    X   130_A      I     132          1.665
LGA    V   131_A      I     133          1.737
LGA    F   132_A      G     134          2.174
LGA    G   133_A      G     135          2.528
LGA    D   134_A      E     136          2.413
LGA    Q   135_A      D     137          2.279
LGA    V   136_A      V     138          2.566
LGA    K   137_A      T     139          3.082
LGA    N   138_A      H     140          2.160
LGA    G   139_A      H     141          1.799
LGA    K   140_A      K     142          1.481
LGA    P   141_A      P     143          1.551
LGA    D   142_A      D     144          1.808
LGA    P   143_A      P     145          1.751
LGA    E   144_A      E     146          1.783
LGA    I   145_A      G     147          1.518
LGA    Y   146_A      L     148          1.456
LGA    L   147_A      L     149          1.191
LGA    L   148_A      L     150          1.254
LGA    V   149_A      A     151          1.457
LGA    L   150_A      I     152          1.092
LGA    E   151_A      D     153          1.100
LGA    R   152_A      R     154          1.597
LGA    L   153_A      L     155          1.756
LGA    N   154_A      K     156          1.526
LGA    V   155_A      A     157          1.711
LGA    V   156_A      C     158          1.322
LGA    P   157_A      P     159          1.514
LGA    E   158_A      E     160          1.611
LGA    K   159_A      E     161          1.292
LGA    V   160_A      V     162          1.809
LGA    V   161_A      L     163          1.690
LGA    V   162_A      Y     164          1.554
LGA    F   163_A      I     165          0.744
LGA    E   164_A      G     166          1.172
LGA    D   165_A      D     167          1.819
LGA    S   166_A      S     168          2.036
LGA    K   167_A      T     169          1.478
LGA    S   168_A      V     170          2.081
LGA    G   169_A      D     171          1.814
LGA    V   170_A      A     172          1.364
LGA    E   171_A      G     173          1.338
LGA    A   172_A      T     174          1.601
LGA    A   173_A      A     175          1.239
LGA    K   174_A      A     176          1.602
LGA    S   175_A      A     177          1.981
LGA    A   176_A      A     178          1.528
LGA    G   177_A      G     179          1.550
LGA    I   178_A      V     180          0.842
LGA    E   179_A      S     181          2.208
LGA    R   180_A      -       -           -
LGA    I   181_A      F     182          0.941
LGA    Y   182_A      T     183          0.975
LGA    G   183_A      G     184          0.964
LGA    V   184_A      V     185          1.648
LGA    V   185_A      T     186          1.447
LGA    H   186_A      S     187          2.543
LGA    -       -      G     188           -
LGA    S   187_A      M     189           #
LGA    L   188_A      -       -           -
LGA    N   189_A      -       -           -
LGA    D   190_A      T     190          3.549
LGA    G   191_A      T     191          2.288
LGA    -       -      A     192           -
LGA    K   192_A      Q     193          2.606
LGA    A   193_A      E     194          2.703
LGA    L   194_A      F     195          2.454
LGA    L   195_A      Q     196          2.937
LGA    E   196_A      A     197          1.439
LGA    A   197_A      Y     198          1.798
LGA    G   198_A      P     199          1.439
LGA    A   199_A      Y     200          2.343
LGA    V   200_A      D     201          2.602
LGA    A   201_A      R     202          2.338
LGA    L   202_A      I     203          1.893
LGA    V   203_A      I     204          1.844
LGA    K   204_A      S     205          2.790
LGA    P   205_A      T     206          3.361
LGA    E   206_A      -       -           -
LGA    E   207_A      -       -           -
LGA    I   208_A      L     207          2.266
LGA    L   209_A      G     208          2.695
LGA    N   210_A      Q     209          3.143
LGA    V   211_A      L     210          2.222
LGA    L   212_A      I     211          2.652
LGA    K   213_A      -       -           -
LGA    E   214_A      -       -           -
LGA    V   215_A      -       -           -
LGA    L   216_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  216  210    5.0    170    2.28    21.76     63.880     7.131

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.281360 * X  +  -0.946787 * Y  +   0.156301 * Z  +  48.720367
  Y_new =   0.408280 * X  +  -0.265514 * Y  +  -0.873390 * Z  +  52.408302
  Z_new =   0.868415 * X  +  -0.181923 * Y  +   0.461259 * Z  +  47.869778 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.375673    2.765919  [ DEG:   -21.5245    158.4755 ]
  Theta =  -1.051996   -2.089597  [ DEG:   -60.2749   -119.7251 ]
  Phi   =   2.174194   -0.967399  [ DEG:   124.5721    -55.4279 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pib_A                                        
REMARK     2: T0418.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pib_A.T0418.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  216  210   5.0  170   2.28   21.76  63.880
REMARK  ---------------------------------------------------------- 
MOLECULE 2pib_A
HEADER    HYDROLASE                               13-APR-07   2PIB              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE BETA-PHOSPHOGLUCOMUTASE FROM            
TITLE    2 THERMOTOGA MARITIMA                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHORYLATED CARBOHYDRATES PHOSPHATASE TM_1254;          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: BETA-PHOSPHOGLUCOMUTASE;                                    
COMPND   5 EC: 3.1.3.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOTOGA MARITIMA;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: MSB8, DSM 3109, JCM 10099;                                   
SOURCE   5 ATCC: 43589;                                                         
SOURCE   6 GENE: BPGM, TM_1254;                                                 
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: ROSETTA834(DE3);                           
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET-21A                                   
KEYWDS    3D-STRUCTURE, STRUCTURAL GENOMICS, THERMOTOGA MARITIMA,               
KEYWDS   2 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   3 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   4 INITIATIVE, RSGI, HYDROLASE                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.V.ANTONYUK,M.J.ELLIS,R.W.STRANGE,S.S.HASNAIN,Y.BESSHO,              
AUTHOR   2 S.KURAMITSU,S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS          
AUTHOR   3 INITIATIVE (RSGI)                                                    
REVDAT   1   16-OCT-07 2PIB    0                                                
JRNL        AUTH   S.V.ANTONYUK,M.J.ELLIS,R.W.STRANGE,S.S.HASNAIN,              
JRNL        AUTH 2 Y.BESSHO,S.KURAMITSU,S.YOKOYAMA                              
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE                                
JRNL        TITL 2 BETA-PHOSPHOGLUCOMUTASE FROM THERMOTOGA MARITIMA             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.73 ANGSTROMS.                                          
DBREF  2PIB A    1   216  UNP    Q9X0Y1   P1254_THEMA      1    216             
DBREF  2PIB B    1   216  UNP    Q9X0Y1   P1254_THEMA      1    216             
SEQRES   1 A  216  MSE GLU ALA VAL ILE PHE ASP MSE ASP GLY VAL LEU MSE          
SEQRES   2 A  216  ASP THR GLU PRO LEU TYR PHE GLU ALA TYR ARG ARG VAL          
SEQRES   3 A  216  ALA GLU SER TYR GLY LYS PRO TYR THR GLU ASP LEU HIS          
SEQRES   4 A  216  ARG ARG ILE MSE GLY VAL PRO GLU ARG GLU GLY LEU PRO          
SEQRES   5 A  216  ILE LEU MSE GLU ALA LEU GLU ILE LYS ASP SER LEU GLU          
SEQRES   6 A  216  ASN PHE LYS LYS ARG VAL HIS GLU GLU LYS LYS ARG VAL          
SEQRES   7 A  216  PHE SER GLU LEU LEU LYS GLU ASN PRO GLY VAL ARG GLU          
SEQRES   8 A  216  ALA LEU GLU PHE VAL LYS SER LYS ARG ILE LYS LEU ALA          
SEQRES   9 A  216  LEU ALA THR SER THR PRO GLN ARG GLU ALA LEU GLU ARG          
SEQRES  10 A  216  LEU ARG ARG LEU ASP LEU GLU LYS TYR PHE ASP VAL MSE          
SEQRES  11 A  216  VAL PHE GLY ASP GLN VAL LYS ASN GLY LYS PRO ASP PRO          
SEQRES  12 A  216  GLU ILE TYR LEU LEU VAL LEU GLU ARG LEU ASN VAL VAL          
SEQRES  13 A  216  PRO GLU LYS VAL VAL VAL PHE GLU ASP SER LYS SER GLY          
SEQRES  14 A  216  VAL GLU ALA ALA LYS SER ALA GLY ILE GLU ARG ILE TYR          
SEQRES  15 A  216  GLY VAL VAL HIS SER LEU ASN ASP GLY LYS ALA LEU LEU          
SEQRES  16 A  216  GLU ALA GLY ALA VAL ALA LEU VAL LYS PRO GLU GLU ILE          
SEQRES  17 A  216  LEU ASN VAL LEU LYS GLU VAL LEU                              
SEQRES   1 B  216  MSE GLU ALA VAL ILE PHE ASP MSE ASP GLY VAL LEU MSE          
SEQRES   2 B  216  ASP THR GLU PRO LEU TYR PHE GLU ALA TYR ARG ARG VAL          
SEQRES   3 B  216  ALA GLU SER TYR GLY LYS PRO TYR THR GLU ASP LEU HIS          
SEQRES   4 B  216  ARG ARG ILE MSE GLY VAL PRO GLU ARG GLU GLY LEU PRO          
SEQRES   5 B  216  ILE LEU MSE GLU ALA LEU GLU ILE LYS ASP SER LEU GLU          
SEQRES   6 B  216  ASN PHE LYS LYS ARG VAL HIS GLU GLU LYS LYS ARG VAL          
SEQRES   7 B  216  PHE SER GLU LEU LEU LYS GLU ASN PRO GLY VAL ARG GLU          
SEQRES   8 B  216  ALA LEU GLU PHE VAL LYS SER LYS ARG ILE LYS LEU ALA          
SEQRES   9 B  216  LEU ALA THR SER THR PRO GLN ARG GLU ALA LEU GLU ARG          
SEQRES  10 B  216  LEU ARG ARG LEU ASP LEU GLU LYS TYR PHE ASP VAL MSE          
SEQRES  11 B  216  VAL PHE GLY ASP GLN VAL LYS ASN GLY LYS PRO ASP PRO          
SEQRES  12 B  216  GLU ILE TYR LEU LEU VAL LEU GLU ARG LEU ASN VAL VAL          
SEQRES  13 B  216  PRO GLU LYS VAL VAL VAL PHE GLU ASP SER LYS SER GLY          
SEQRES  14 B  216  VAL GLU ALA ALA LYS SER ALA GLY ILE GLU ARG ILE TYR          
SEQRES  15 B  216  GLY VAL VAL HIS SER LEU ASN ASP GLY LYS ALA LEU LEU          
SEQRES  16 B  216  GLU ALA GLY ALA VAL ALA LEU VAL LYS PRO GLU GLU ILE          
SEQRES  17 B  216  LEU ASN VAL LEU LYS GLU VAL LEU                              
HET    MSE  A   1       8                                                       
HET    MSE  A   8       8                                                       
HET    MSE  A  13      13                                                       
HET    MSE  A  43      13                                                       
HET    MSE  A  55       8                                                       
HET    MSE  A 130       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B   8       8                                                       
HET    MSE  B  13      13                                                       
HET    MSE  B  43      13                                                       
HET    MSE  B  55       8                                                       
HET    MSE  B 130       8                                                       
HET    SO4  A 217       5                                                       
HET     NA  B 221       1                                                       
HET     NA  A 222       1                                                       
HET    SO4  A 224       5                                                       
HET    SO4  A 225       5                                                       
HET    SO4  A 226       5                                                       
HET    SO4  A 227       5                                                       
HET    SO4  B 228       5                                                       
HET    GOL  A 218       6                                                       
HET    GOL  A 219      12                                                       
HET    GOL  A 220       6                                                       
HET    GOL  A 221       6                                                       
HET    GOL  B 219       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM      NA SODIUM ION                                                       
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    12(C5 H11 N O2 SE)                                           
FORMUL   3  SO4    6(O4 S 2-)                                                   
FORMUL   4   NA    2(NA 1+)                                                     
FORMUL  11  GOL    5(C3 H8 O3)                                                  
FORMUL  16  HOH   *495(H2 O)                                                    
CRYST1   66.717   48.171   83.807  90.00  90.00  90.00 P 1 2 1       4          
HETATM    1  N   MSE A   1     -13.214  39.656  69.438  1.00 35.98           N  
HETATM    2  CA  MSE A   1     -12.389  39.255  70.611  1.00 34.70           C  
HETATM    3  C   MSE A   1     -12.837  40.096  71.786  1.00 34.58           C  
HETATM    4  O   MSE A   1     -13.227  41.259  71.603  1.00 35.05           O  
HETATM    5  CB  MSE A   1     -10.927  39.500  70.298  1.00 35.01           C  
HETATM    6  CG  MSE A   1     -10.011  38.543  70.952  1.00 34.03           C  
HETATM    7 SE   MSE A   1     -10.131  36.699  70.402  0.70 33.62          SE  
HETATM    8  CE  MSE A   1     -11.828  36.542  69.524  0.70 39.20           C  
ATOM      9  N   GLU A   2     -12.807  39.523  72.977  1.00 33.33           N  
ATOM     10  CA  GLU A   2     -13.251  40.232  74.145  1.00 33.24           C  
ATOM     11  C   GLU A   2     -12.138  40.499  75.133  1.00 31.50           C  
ATOM     12  O   GLU A   2     -12.296  41.367  75.991  1.00 31.11           O  
ATOM     13  CB  GLU A   2     -14.330  39.455  74.856  1.00 34.72           C  
ATOM     14  CG  GLU A   2     -15.743  39.520  74.295  1.00 39.16           C  
ATOM     15  CD  GLU A   2     -16.675  38.782  75.256  1.00 45.36           C  
ATOM     16  OE1 GLU A   2     -17.322  39.408  76.136  1.00 50.57           O  
ATOM     17  OE2 GLU A   2     -16.668  37.536  75.204  1.00 52.13           O  
ATOM     18  N   ALA A   3     -11.051  39.731  75.065  1.00 29.89           N  
ATOM     19  CA  ALA A   3      -9.951  39.975  75.965  1.00 28.55           C  
ATOM     20  C   ALA A   3      -8.635  39.530  75.370  1.00 27.88           C  
ATOM     21  O   ALA A   3      -8.586  38.633  74.529  1.00 26.47           O  
ATOM     22  CB  ALA A   3     -10.183  39.269  77.317  1.00 27.82           C  
ATOM     23  N   VAL A   4      -7.584  40.168  75.842  1.00 26.70           N  
ATOM     24  CA  VAL A   4      -6.222  39.747  75.547  1.00 26.18           C  
ATOM     25  C   VAL A   4      -5.488  39.541  76.872  1.00 26.53           C  
ATOM     26  O   VAL A   4      -5.582  40.376  77.806  1.00 26.55           O  
ATOM     27  CB  VAL A   4      -5.507  40.781  74.687  1.00 28.03           C  
ATOM     28  CG1 VAL A   4      -4.086  40.345  74.390  1.00 27.30           C  
ATOM     29  CG2 VAL A   4      -6.269  41.011  73.347  1.00 26.99           C  
ATOM     30  N   ILE A   5      -4.837  38.393  77.000  1.00 25.98           N  
ATOM     31  CA  ILE A   5      -4.161  38.024  78.236  1.00 25.21           C  
ATOM     32  C   ILE A   5      -2.652  37.858  78.018  1.00 26.55           C  
ATOM     33  O   ILE A   5      -2.245  37.198  77.079  1.00 25.35           O  
ATOM     34  CB  ILE A   5      -4.716  36.684  78.791  1.00 27.11           C  
ATOM     35  CG1 ILE A   5      -6.256  36.673  78.936  1.00 25.87           C  
ATOM     36  CG2 ILE A   5      -4.033  36.394  80.092  1.00 24.94           C  
ATOM     37  CD1 ILE A   5      -6.813  35.235  79.124  1.00 30.76           C  
ATOM     38  N   PHE A   6      -1.846  38.470  78.878  1.00 26.02           N  
ATOM     39  CA  PHE A   6      -0.393  38.453  78.784  1.00 26.65           C  
ATOM     40  C   PHE A   6       0.189  37.780  80.003  1.00 25.92           C  
ATOM     41  O   PHE A   6      -0.136  38.139  81.131  1.00 26.31           O  
ATOM     42  CB  PHE A   6       0.157  39.864  78.757  1.00 27.01           C  
ATOM     43  CG  PHE A   6      -0.055  40.593  77.466  1.00 27.65           C  
ATOM     44  CD1 PHE A   6       0.973  40.673  76.513  1.00 27.36           C  
ATOM     45  CD2 PHE A   6      -1.274  41.206  77.177  1.00 28.97           C  
ATOM     46  CE1 PHE A   6       0.766  41.390  75.304  1.00 28.56           C  
ATOM     47  CE2 PHE A   6      -1.463  41.872  75.979  1.00 26.92           C  
ATOM     48  CZ  PHE A   6      -0.447  41.951  75.052  1.00 26.76           C  
ATOM     49  N   ASP A   7       1.112  36.861  79.799  1.00 25.77           N  
ATOM     50  CA  ASP A   7       2.055  36.507  80.852  1.00 26.99           C  
ATOM     51  C   ASP A   7       2.971  37.715  81.093  1.00 27.05           C  
ATOM     52  O   ASP A   7       3.125  38.563  80.224  1.00 26.87           O  
ATOM     53  CB  ASP A   7       2.905  35.319  80.409  1.00 28.34           C  
ATOM     54  CG  ASP A   7       3.690  34.712  81.541  1.00 28.82           C  
ATOM     55  OD1 ASP A   7       3.245  34.790  82.692  1.00 30.14           O  
ATOM     56  OD2 ASP A   7       4.763  34.199  81.260  1.00 35.08           O  
HETATM   57  N   MSE A   8       3.569  37.788  82.274  1.00 26.92           N  
HETATM   58  CA  MSE A   8       4.406  38.933  82.629  1.00 26.33           C  
HETATM   59  C   MSE A   8       5.864  38.738  82.233  1.00 27.15           C  
HETATM   60  O   MSE A   8       6.350  39.345  81.259  1.00 27.32           O  
HETATM   61  CB  MSE A   8       4.235  39.246  84.121  1.00 26.51           C  
HETATM   62  CG  MSE A   8       4.973  40.450  84.490  1.00 25.07           C  
HETATM   63 SE   MSE A   8       4.868  40.951  86.367  0.80 27.48          SE  
HETATM   64  CE  MSE A   8       5.778  39.476  87.104  1.00 23.18           C  
ATOM     65  N   ASP A   9       6.558  37.851  82.924  1.00 27.66           N  
ATOM     66  CA  ASP A   9       7.969  37.704  82.707  1.00 29.18           C  
ATOM     67  C   ASP A   9       8.216  36.928  81.431  1.00 29.43           C  
ATOM     68  O   ASP A   9       7.678  35.846  81.248  1.00 31.37           O  
ATOM     69  CB  ASP A   9       8.621  36.961  83.834  1.00 30.30           C  
ATOM     70  CG  ASP A   9      10.125  36.967  83.709  1.00 31.25           C  
ATOM     71  OD1 ASP A   9      10.713  38.013  83.968  1.00 35.49           O  
ATOM     72  OD2 ASP A   9      10.716  35.933  83.332  1.00 39.71           O  
ATOM     73  N   GLY A  10       9.063  37.486  80.598  1.00 30.11           N  
ATOM     74  CA  GLY A  10       9.345  36.941  79.280  1.00 30.51           C  
ATOM     75  C   GLY A  10       8.427  37.436  78.177  1.00 31.38           C  
ATOM     76  O   GLY A  10       8.591  37.017  77.023  1.00 32.73           O  
ATOM     77  N   VAL A  11       7.447  38.286  78.512  1.00 29.84           N  
ATOM     78  CA  VAL A  11       6.609  38.953  77.531  1.00 29.19           C  
ATOM     79  C   VAL A  11       6.665  40.452  77.723  1.00 29.02           C  
ATOM     80  O   VAL A  11       7.137  41.173  76.872  1.00 28.40           O  
ATOM     81  CB  VAL A  11       5.153  38.455  77.575  1.00 30.00           C  
ATOM     82  CG1 VAL A  11       4.331  39.112  76.515  1.00 30.22           C  
ATOM     83  CG2 VAL A  11       5.094  36.932  77.460  1.00 29.62           C  
ATOM     84  N   LEU A  12       6.213  40.933  78.882  1.00 28.84           N  
ATOM     85  CA  LEU A  12       6.235  42.369  79.124  1.00 28.08           C  
ATOM     86  C   LEU A  12       7.654  42.890  79.429  1.00 28.45           C  
ATOM     87  O   LEU A  12       8.025  43.990  79.021  1.00 27.83           O  
ATOM     88  CB  LEU A  12       5.272  42.716  80.256  1.00 28.80           C  
ATOM     89  CG  LEU A  12       3.807  42.310  80.057  1.00 29.93           C  
ATOM     90  CD1 LEU A  12       3.008  42.742  81.318  1.00 33.30           C  
ATOM     91  CD2 LEU A  12       3.257  42.949  78.846  1.00 34.38           C  
HETATM   92  N   MSE A  13       8.431  42.072  80.131  1.00 29.10           N  
HETATM   93  CA  MSE A  13       9.783  42.391  80.571  0.50 30.21           C  
HETATM   95  C   MSE A  13      10.484  41.044  80.760  1.00 30.45           C  
HETATM   96  O   MSE A  13       9.802  40.075  81.049  1.00 30.42           O  
HETATM   97  CB  MSE A  13       9.735  43.142  81.927  0.50 31.11           C  
HETATM   99  CG  MSE A  13       9.524  42.238  83.166  0.50 33.04           C  
HETATM  101 SE   MSE A  13       8.678  42.947  84.821  0.50 44.78          SE  
HETATM  103  CE  MSE A  13       7.060  43.617  83.952  0.50 37.86           C  
ATOM    105  N   ASP A  14      11.806  41.029  80.700  1.00 31.68           N  
ATOM    106  CA  ASP A  14      12.583  39.795  80.864  1.00 33.85           C  
ATOM    107  C   ASP A  14      13.573  39.872  82.043  1.00 34.34           C  
ATOM    108  O   ASP A  14      14.589  40.552  81.960  1.00 34.80           O  
ATOM    109  CB  ASP A  14      13.399  39.536  79.601  1.00 34.71           C  
ATOM    110  CG  ASP A  14      12.544  39.364  78.353  1.00 36.16           C  
ATOM    111  OD1 ASP A  14      11.322  39.146  78.454  1.00 39.80           O  
ATOM    112  OD2 ASP A  14      13.133  39.420  77.262  1.00 39.77           O  
ATOM    113  N   THR A  15      13.294  39.155  83.115  1.00 35.11           N  
ATOM    114  CA  THR A  15      14.208  39.182  84.275  1.00 35.92           C  
ATOM    115  C   THR A  15      15.334  38.160  84.140  1.00 36.38           C  
ATOM    116  O   THR A  15      16.419  38.342  84.730  1.00 34.87           O  
ATOM    117  CB  THR A  15      13.483  38.945  85.608  1.00 36.41           C  
ATOM    118  OG1 THR A  15      12.854  37.646  85.620  1.00 36.37           O  
ATOM    119  CG2 THR A  15      12.445  40.061  85.874  1.00 37.54           C  
ATOM    120  N   GLU A  16      15.066  37.074  83.406  1.00 37.33           N  
ATOM    121  CA  GLU A  16      16.016  35.958  83.372  1.00 39.05           C  
ATOM    122  C   GLU A  16      17.415  36.406  82.990  1.00 38.50           C  
ATOM    123  O   GLU A  16      18.372  35.952  83.617  1.00 39.90           O  
ATOM    124  CB  GLU A  16      15.548  34.813  82.464  1.00 39.74           C  
ATOM    125  CG  GLU A  16      16.592  33.679  82.265  1.00 44.01           C  
ATOM    126  CD  GLU A  16      17.528  33.862  81.045  1.00 48.06           C  
ATOM    127  OE1 GLU A  16      17.366  34.816  80.252  1.00 51.57           O  
ATOM    128  OE2 GLU A  16      18.439  33.019  80.876  1.00 52.52           O  
ATOM    129  N   PRO A  17      17.547  37.262  81.962  1.00 37.90           N  
ATOM    130  CA  PRO A  17      18.888  37.728  81.565  1.00 37.47           C  
ATOM    131  C   PRO A  17      19.665  38.519  82.625  1.00 36.26           C  
ATOM    132  O   PRO A  17      20.886  38.684  82.486  1.00 36.33           O  
ATOM    133  CB  PRO A  17      18.603  38.635  80.374  1.00 37.90           C  
ATOM    134  CG  PRO A  17      17.296  38.185  79.852  1.00 38.26           C  
ATOM    135  CD  PRO A  17      16.515  37.786  81.041  1.00 38.24           C  
ATOM    136  N   LEU A  18      18.969  39.039  83.625  1.00 34.78           N  
ATOM    137  CA  LEU A  18      19.608  39.815  84.701  1.00 33.99           C  
ATOM    138  C   LEU A  18      20.014  38.962  85.881  1.00 33.71           C  
ATOM    139  O   LEU A  18      20.626  39.488  86.824  1.00 33.98           O  
ATOM    140  CB  LEU A  18      18.685  40.908  85.225  1.00 34.27           C  
ATOM    141  CG  LEU A  18      18.073  41.908  84.226  1.00 34.97           C  
ATOM    142  CD1 LEU A  18      17.048  42.814  84.952  1.00 36.77           C  
ATOM    143  CD2 LEU A  18      19.151  42.703  83.570  1.00 36.90           C  
ATOM    144  N   TYR A  19      19.640  37.682  85.887  1.00 32.93           N  
ATOM    145  CA  TYR A  19      20.015  36.824  87.011  1.00 33.18           C  
ATOM    146  C   TYR A  19      21.524  36.734  87.175  1.00 32.03           C  
ATOM    147  O   TYR A  19      22.009  36.731  88.295  1.00 33.89           O  
ATOM    148  CB  TYR A  19      19.399  35.435  86.881  1.00 33.20           C  
ATOM    149  CG  TYR A  19      18.063  35.396  87.559  1.00 34.39           C  
ATOM    150  CD1 TYR A  19      17.018  36.179  87.083  1.00 35.18           C  
ATOM    151  CD2 TYR A  19      17.848  34.614  88.680  1.00 36.27           C  
ATOM    152  CE1 TYR A  19      15.777  36.175  87.698  1.00 35.14           C  
ATOM    153  CE2 TYR A  19      16.604  34.617  89.321  1.00 38.24           C  
ATOM    154  CZ  TYR A  19      15.569  35.393  88.802  1.00 37.73           C  
ATOM    155  OH  TYR A  19      14.339  35.396  89.427  1.00 37.73           O  
ATOM    156  N   PHE A  20      22.260  36.661  86.075  1.00 31.58           N  
ATOM    157  CA  PHE A  20      23.713  36.589  86.181  1.00 30.79           C  
ATOM    158  C   PHE A  20      24.262  37.746  87.013  1.00 30.35           C  
ATOM    159  O   PHE A  20      24.974  37.530  87.990  1.00 30.01           O  
ATOM    160  CB  PHE A  20      24.407  36.534  84.828  1.00 31.18           C  
ATOM    161  CG  PHE A  20      25.901  36.517  84.950  1.00 30.18           C  
ATOM    162  CD1 PHE A  20      26.553  35.371  85.408  1.00 30.34           C  
ATOM    163  CD2 PHE A  20      26.641  37.654  84.710  1.00 29.50           C  
ATOM    164  CE1 PHE A  20      27.936  35.350  85.576  1.00 29.54           C  
ATOM    165  CE2 PHE A  20      27.999  37.643  84.878  1.00 30.61           C  
ATOM    166  CZ  PHE A  20      28.655  36.480  85.312  1.00 29.06           C  
ATOM    167  N   GLU A  21      23.934  38.978  86.627  1.00 29.57           N  
ATOM    168  CA  GLU A  21      24.470  40.143  87.317  1.00 29.25           C  
ATOM    169  C   GLU A  21      24.061  40.191  88.794  1.00 28.82           C  
ATOM    170  O   GLU A  21      24.866  40.552  89.650  1.00 27.60           O  
ATOM    171  CB  GLU A  21      24.086  41.445  86.571  1.00 29.19           C  
ATOM    172  CG  GLU A  21      24.561  42.700  87.237  1.00 29.05           C  
ATOM    173  CD  GLU A  21      26.060  42.765  87.453  1.00 27.43           C  
ATOM    174  OE1 GLU A  21      26.835  42.106  86.706  1.00 28.28           O  
ATOM    175  OE2 GLU A  21      26.467  43.550  88.332  1.00 28.17           O  
ATOM    176  N   ALA A  22      22.830  39.799  89.101  1.00 29.39           N  
ATOM    177  CA  ALA A  22      22.361  39.755  90.499  1.00 28.67           C  
ATOM    178  C   ALA A  22      23.192  38.748  91.326  1.00 28.18           C  
ATOM    179  O   ALA A  22      23.687  39.094  92.417  1.00 28.08           O  
ATOM    180  CB  ALA A  22      20.878  39.407  90.558  1.00 29.72           C  
ATOM    181  N   TYR A  23      23.394  37.550  90.771  1.00 27.29           N  
ATOM    182  CA  TYR A  23      24.153  36.495  91.487  1.00 26.58           C  
ATOM    183  C   TYR A  23      25.649  36.835  91.507  1.00 25.03           C  
ATOM    184  O   TYR A  23      26.351  36.541  92.482  1.00 23.70           O  
ATOM    185  CB  TYR A  23      23.931  35.124  90.875  1.00 27.07           C  
ATOM    186  CG  TYR A  23      22.548  34.532  91.048  1.00 27.94           C  
ATOM    187  CD1 TYR A  23      21.555  35.203  91.761  1.00 29.26           C  
ATOM    188  CD2 TYR A  23      22.261  33.265  90.553  1.00 28.88           C  
ATOM    189  CE1 TYR A  23      20.273  34.643  91.900  1.00 32.20           C  
ATOM    190  CE2 TYR A  23      21.021  32.696  90.715  1.00 31.46           C  
ATOM    191  CZ  TYR A  23      20.030  33.385  91.392  1.00 30.38           C  
ATOM    192  OH  TYR A  23      18.789  32.796  91.508  1.00 31.32           O  
ATOM    193  N   ARG A  24      26.130  37.472  90.439  1.00 24.11           N  
ATOM    194  CA  ARG A  24      27.508  37.965  90.396  1.00 23.82           C  
ATOM    195  C   ARG A  24      27.732  38.974  91.520  1.00 23.79           C  
ATOM    196  O   ARG A  24      28.762  38.930  92.187  1.00 21.72           O  
ATOM    197  CB  ARG A  24      27.847  38.589  89.033  1.00 23.31           C  
ATOM    198  CG  ARG A  24      29.377  38.792  88.781  1.00 22.57           C  
ATOM    199  CD  ARG A  24      29.681  39.823  87.667  1.00 24.17           C  
ATOM    200  NE  ARG A  24      29.166  41.129  88.051  1.00 20.53           N  
ATOM    201  CZ  ARG A  24      29.771  41.973  88.866  1.00 21.49           C  
ATOM    202  NH1 ARG A  24      30.964  41.713  89.368  1.00 19.64           N  
ATOM    203  NH2 ARG A  24      29.186  43.119  89.163  1.00 23.64           N  
ATOM    204  N   ARG A  25      26.786  39.898  91.708  1.00 23.71           N  
ATOM    205  CA  ARG A  25      26.897  40.897  92.783  1.00 24.24           C  
ATOM    206  C   ARG A  25      26.879  40.300  94.194  1.00 23.67           C  
ATOM    207  O   ARG A  25      27.599  40.747  95.080  1.00 22.66           O  
ATOM    208  CB  ARG A  25      25.779  41.932  92.668  1.00 24.84           C  
ATOM    209  CG  ARG A  25      26.043  42.955  91.608  1.00 27.03           C  
ATOM    210  CD  ARG A  25      24.947  44.017  91.589  1.00 32.38           C  
ATOM    211  NE  ARG A  25      25.001  44.853  90.393  1.00 36.49           N  
ATOM    212  CZ  ARG A  25      24.319  45.986  90.255  1.00 41.59           C  
ATOM    213  NH1 ARG A  25      23.536  46.441  91.242  1.00 43.03           N  
ATOM    214  NH2 ARG A  25      24.430  46.668  89.125  1.00 43.59           N  
ATOM    215  N   VAL A  26      26.053  39.288  94.392  1.00 23.97           N  
ATOM    216  CA  VAL A  26      26.028  38.571  95.666  1.00 23.47           C  
ATOM    217  C   VAL A  26      27.406  37.976  95.951  1.00 22.78           C  
ATOM    218  O   VAL A  26      27.999  38.226  97.009  1.00 22.44           O  
ATOM    219  CB  VAL A  26      24.979  37.473  95.628  1.00 23.89           C  
ATOM    220  CG1 VAL A  26      25.049  36.589  96.875  1.00 24.87           C  
ATOM    221  CG2 VAL A  26      23.630  38.094  95.504  1.00 25.27           C  
ATOM    222  N   ALA A  27      27.921  37.232  94.973  1.00 22.54           N  
ATOM    223  CA  ALA A  27      29.255  36.643  95.071  1.00 21.00           C  
ATOM    224  C   ALA A  27      30.290  37.714  95.416  1.00 20.55           C  
ATOM    225  O   ALA A  27      31.077  37.563  96.344  1.00 19.60           O  
ATOM    226  CB  ALA A  27      29.608  35.960  93.754  1.00 22.23           C  
ATOM    227  N   GLU A  28      30.299  38.801  94.641  1.00 19.05           N  
ATOM    228  CA  GLU A  28      31.207  39.913  94.859  1.00 19.61           C  
ATOM    229  C   GLU A  28      31.124  40.520  96.268  1.00 18.47           C  
ATOM    230  O   GLU A  28      32.128  40.913  96.839  1.00 19.73           O  
ATOM    231  CB  GLU A  28      30.935  40.998  93.807  1.00 19.50           C  
ATOM    232  CG  GLU A  28      31.806  42.219  93.887  1.00 19.54           C  
ATOM    233  CD  GLU A  28      31.538  43.175  92.753  1.00 24.19           C  
ATOM    234  OE1 GLU A  28      32.024  42.934  91.620  1.00 20.81           O  
ATOM    235  OE2 GLU A  28      30.851  44.170  93.004  1.00 22.54           O  
ATOM    236  N   SER A  29      29.917  40.582  96.814  1.00 20.81           N  
ATOM    237  CA  SER A  29      29.714  41.123  98.167  1.00 20.48           C  
ATOM    238  C   SER A  29      30.393  40.263  99.249  1.00 20.91           C  
ATOM    239  O   SER A  29      30.684  40.754 100.327  1.00 22.25           O  
ATOM    240  CB  SER A  29      28.200  41.265  98.492  1.00 20.84           C  
ATOM    241  OG  SER A  29      27.560  40.016  98.716  1.00 22.20           O  
ATOM    242  N   TYR A  30      30.615  38.987  98.942  1.00 20.84           N  
ATOM    243  CA  TYR A  30      31.335  38.050  99.808  1.00 20.05           C  
ATOM    244  C   TYR A  30      32.811  37.865  99.402  1.00 19.87           C  
ATOM    245  O   TYR A  30      33.522  36.980  99.944  1.00 19.62           O  
ATOM    246  CB  TYR A  30      30.641  36.692  99.753  1.00 21.69           C  
ATOM    247  CG  TYR A  30      29.324  36.587 100.485  1.00 21.88           C  
ATOM    248  CD1 TYR A  30      29.296  36.516 101.887  1.00 24.02           C  
ATOM    249  CD2 TYR A  30      28.138  36.477  99.797  1.00 23.17           C  
ATOM    250  CE1 TYR A  30      28.087  36.389 102.567  1.00 26.21           C  
ATOM    251  CE2 TYR A  30      26.922  36.336 100.472  1.00 25.64           C  
ATOM    252  CZ  TYR A  30      26.924  36.299 101.868  1.00 25.44           C  
ATOM    253  OH  TYR A  30      25.703  36.148 102.508  1.00 27.48           O  
ATOM    254  N   GLY A  31      33.287  38.701  98.482  1.00 18.42           N  
ATOM    255  CA  GLY A  31      34.661  38.661  98.030  1.00 18.32           C  
ATOM    256  C   GLY A  31      34.965  37.476  97.125  1.00 17.91           C  
ATOM    257  O   GLY A  31      36.125  37.045  97.056  1.00 18.36           O  
ATOM    258  N   LYS A  32      33.936  36.979  96.454  1.00 18.22           N  
ATOM    259  CA  LYS A  32      34.016  35.786  95.600  1.00 18.21           C  
ATOM    260  C   LYS A  32      33.731  36.078  94.116  1.00 17.60           C  
ATOM    261  O   LYS A  32      32.815  36.843  93.782  1.00 16.95           O  
ATOM    262  CB  LYS A  32      33.030  34.697  96.045  1.00 18.71           C  
ATOM    263  CG  LYS A  32      33.109  34.282  97.532  1.00 20.82           C  
ATOM    264  CD  LYS A  32      34.495  33.811  97.937  1.00 21.44           C  
ATOM    265  CE  LYS A  32      34.507  33.239  99.369  1.00 21.71           C  
ATOM    266  NZ  LYS A  32      35.829  32.793  99.759  1.00 21.26           N  
ATOM    267  N   PRO A  33      34.459  35.379  93.231  1.00 17.04           N  
ATOM    268  CA  PRO A  33      34.222  35.473  91.796  1.00 18.09           C  
ATOM    269  C   PRO A  33      33.056  34.589  91.365  1.00 19.25           C  
ATOM    270  O   PRO A  33      32.555  33.746  92.143  1.00 19.07           O  
ATOM    271  CB  PRO A  33      35.561  34.979  91.221  1.00 17.15           C  
ATOM    272  CG  PRO A  33      35.971  33.911  92.184  1.00 18.07           C  
ATOM    273  CD  PRO A  33      35.493  34.373  93.541  1.00 17.26           C  
ATOM    274  N   TYR A  34      32.580  34.784  90.141  1.00 20.90           N  
ATOM    275  CA  TYR A  34      31.437  34.042  89.649  1.00 23.12           C  
ATOM    276  C   TYR A  34      31.486  33.984  88.126  1.00 25.80           C  
ATOM    277  O   TYR A  34      31.770  35.001  87.491  1.00 26.91           O  
ATOM    278  CB  TYR A  34      30.159  34.743  90.072  1.00 23.94           C  
ATOM    279  CG  TYR A  34      28.893  33.973  89.833  1.00 24.90           C  
ATOM    280  CD1 TYR A  34      28.727  32.680  90.322  1.00 24.86           C  
ATOM    281  CD2 TYR A  34      27.826  34.555  89.159  1.00 25.66           C  
ATOM    282  CE1 TYR A  34      27.537  31.990  90.122  1.00 25.47           C  
ATOM    283  CE2 TYR A  34      26.651  33.874  88.957  1.00 25.51           C  
ATOM    284  CZ  TYR A  34      26.511  32.586  89.441  1.00 27.47           C  
ATOM    285  OH  TYR A  34      25.343  31.915  89.269  1.00 28.16           O  
ATOM    286  N   THR A  35      31.239  32.798  87.555  1.00 27.46           N  
ATOM    287  CA  THR A  35      31.414  32.579  86.108  1.00 27.91           C  
ATOM    288  C   THR A  35      30.076  32.363  85.427  1.00 28.85           C  
ATOM    289  O   THR A  35      29.096  31.936  86.038  1.00 28.20           O  
ATOM    290  CB  THR A  35      32.365  31.386  85.782  1.00 27.69           C  
ATOM    291  OG1 THR A  35      31.786  30.144  86.215  1.00 27.61           O  
ATOM    292  CG2 THR A  35      33.729  31.586  86.407  1.00 27.39           C  
ATOM    293  N   GLU A  36      30.023  32.710  84.143  1.00 29.66           N  
ATOM    294  CA  GLU A  36      28.828  32.382  83.359  1.00 30.79           C  
ATOM    295  C   GLU A  36      28.644  30.853  83.188  1.00 30.28           C  
ATOM    296  O   GLU A  36      27.519  30.384  83.150  1.00 31.49           O  
ATOM    297  CB  GLU A  36      28.833  33.157  82.025  1.00 31.66           C  
ATOM    298  CG  GLU A  36      28.315  34.592  82.254  1.00 33.93           C  
ATOM    299  CD  GLU A  36      27.690  35.266  81.048  0.30 34.34           C  
ATOM    300  OE1 GLU A  36      27.611  34.656  79.959  0.30 35.38           O  
ATOM    301  OE2 GLU A  36      27.264  36.426  81.215  0.30 33.41           O  
ATOM    302  N   ASP A  37      29.734  30.101  83.123  1.00 30.88           N  
ATOM    303  CA  ASP A  37      29.657  28.645  82.984  1.00 31.18           C  
ATOM    304  C   ASP A  37      28.936  28.025  84.187  1.00 30.62           C  
ATOM    305  O   ASP A  37      28.039  27.190  84.027  1.00 30.15           O  
ATOM    306  CB  ASP A  37      31.037  28.039  82.807  1.00 31.98           C  
ATOM    307  CG  ASP A  37      31.596  28.211  81.389  1.00 34.23           C  
ATOM    308  OD1 ASP A  37      30.933  28.830  80.522  1.00 38.97           O  
ATOM    309  OD2 ASP A  37      32.715  27.731  81.151  1.00 38.48           O  
ATOM    310  N   LEU A  38      29.301  28.451  85.397  1.00 29.63           N  
ATOM    311  CA  LEU A  38      28.584  27.982  86.591  1.00 29.19           C  
ATOM    312  C   LEU A  38      27.160  28.501  86.594  1.00 29.20           C  
ATOM    313  O   LEU A  38      26.217  27.781  86.918  1.00 29.60           O  
ATOM    314  CB  LEU A  38      29.297  28.404  87.899  1.00 28.61           C  
ATOM    315  CG  LEU A  38      28.567  28.102  89.224  1.00 28.06           C  
ATOM    316  CD1 LEU A  38      28.290  26.603  89.391  1.00 27.97           C  
ATOM    317  CD2 LEU A  38      29.410  28.600  90.413  1.00 24.84           C  
ATOM    318  N   HIS A  39      26.990  29.764  86.226  1.00 29.19           N  
ATOM    319  CA  HIS A  39      25.708  30.378  86.332  1.00 29.64           C  
ATOM    320  C   HIS A  39      24.683  29.688  85.437  1.00 30.39           C  
ATOM    321  O   HIS A  39      23.575  29.453  85.871  1.00 30.57           O  
ATOM    322  CB  HIS A  39      25.742  31.843  85.955  1.00 30.21           C  
ATOM    323  CG  HIS A  39      24.399  32.483  86.032  1.00 30.04           C  
ATOM    324  ND1 HIS A  39      23.789  32.796  87.228  1.00 29.64           N  
ATOM    325  CD2 HIS A  39      23.523  32.831  85.059  1.00 33.51           C  
ATOM    326  CE1 HIS A  39      22.599  33.321  86.990  1.00 32.63           C  
ATOM    327  NE2 HIS A  39      22.410  33.348  85.679  1.00 30.65           N  
ATOM    328  N   ARG A  40      25.092  29.362  84.218  1.00 31.57           N  
ATOM    329  CA  ARG A  40      24.243  28.669  83.236  1.00 33.43           C  
ATOM    330  C   ARG A  40      23.733  27.334  83.778  1.00 34.27           C  
ATOM    331  O   ARG A  40      22.568  26.955  83.560  1.00 33.62           O  
ATOM    332  CB  ARG A  40      25.065  28.444  81.976  1.00 34.00           C  
ATOM    333  CG  ARG A  40      24.356  27.758  80.805  1.00 38.09           C  
ATOM    334  CD  ARG A  40      25.193  27.940  79.517  1.00 42.08           C  
ATOM    335  NE  ARG A  40      25.427  29.368  79.200  0.70 43.28           N  
ATOM    336  CZ  ARG A  40      26.612  29.992  79.192  0.70 44.29           C  
ATOM    337  NH1 ARG A  40      27.749  29.349  79.468  0.70 45.46           N  
ATOM    338  NH2 ARG A  40      26.658  31.290  78.901  0.70 43.97           N  
ATOM    339  N   ARG A  41      24.591  26.633  84.512  1.00 33.86           N  
ATOM    340  CA  ARG A  41      24.165  25.374  85.129  1.00 34.85           C  
ATOM    341  C   ARG A  41      23.262  25.587  86.342  1.00 34.77           C  
ATOM    342  O   ARG A  41      22.265  24.865  86.522  1.00 35.89           O  
ATOM    343  CB  ARG A  41      25.379  24.533  85.454  1.00 34.58           C  
ATOM    344  CG  ARG A  41      26.214  24.205  84.217  1.00 35.54           C  
ATOM    345  CD  ARG A  41      25.342  23.718  83.032  1.00 36.49           C  
ATOM    346  NE  ARG A  41      26.171  23.083  82.014  1.00 38.74           N  
ATOM    347  CZ  ARG A  41      25.727  22.300  81.035  1.00 40.52           C  
ATOM    348  NH1 ARG A  41      24.430  22.021  80.914  1.00 42.13           N  
ATOM    349  NH2 ARG A  41      26.600  21.777  80.182  1.00 41.65           N  
ATOM    350  N   ILE A  42      23.573  26.593  87.156  1.00 35.78           N  
ATOM    351  CA  ILE A  42      22.738  26.965  88.310  1.00 35.62           C  
ATOM    352  C   ILE A  42      21.315  27.349  87.895  1.00 37.34           C  
ATOM    353  O   ILE A  42      20.355  27.101  88.639  1.00 37.07           O  
ATOM    354  CB  ILE A  42      23.364  28.135  89.101  1.00 36.09           C  
ATOM    355  CG1 ILE A  42      24.575  27.655  89.922  1.00 35.11           C  
ATOM    356  CG2 ILE A  42      22.324  28.806  90.012  1.00 34.82           C  
ATOM    357  CD1 ILE A  42      24.228  26.667  91.010  1.00 37.37           C  
HETATM  358  N   MSE A  43      21.202  27.967  86.721  1.00 37.88           N  
HETATM  359  CA  MSE A  43      19.882  28.396  86.259  0.70 39.21           C  
HETATM  361  C   MSE A  43      19.023  27.221  85.761  1.00 39.52           C  
HETATM  362  O   MSE A  43      17.817  27.394  85.553  1.00 39.74           O  
HETATM  363  CB  MSE A  43      20.006  29.493  85.205  0.70 39.31           C  
HETATM  365  CG  MSE A  43      20.539  30.809  85.771  0.70 40.97           C  
HETATM  367 SE   MSE A  43      19.403  31.646  87.147  0.70 44.04          SE  
HETATM  369  CE  MSE A  43      17.957  32.263  85.954  0.70 44.25           C  
ATOM    371  N   GLY A  44      19.622  26.043  85.607  1.00 39.70           N  
ATOM    372  CA  GLY A  44      18.873  24.846  85.215  1.00 41.02           C  
ATOM    373  C   GLY A  44      17.957  24.260  86.293  1.00 41.95           C  
ATOM    374  O   GLY A  44      17.242  23.282  86.030  1.00 42.48           O  
ATOM    375  N   VAL A  45      17.998  24.817  87.505  1.00 42.48           N  
ATOM    376  CA  VAL A  45      17.183  24.334  88.623  1.00 43.10           C  
ATOM    377  C   VAL A  45      16.425  25.469  89.280  1.00 44.01           C  
ATOM    378  O   VAL A  45      16.761  26.637  89.081  1.00 44.09           O  
ATOM    379  CB  VAL A  45      18.039  23.602  89.716  1.00 42.88           C  
ATOM    380  CG1 VAL A  45      18.774  22.449  89.107  1.00 41.77           C  
ATOM    381  CG2 VAL A  45      18.985  24.570  90.418  1.00 42.83           C  
ATOM    382  N   PRO A  46      15.383  25.136  90.062  1.00 44.97           N  
ATOM    383  CA  PRO A  46      14.608  26.162  90.750  1.00 45.54           C  
ATOM    384  C   PRO A  46      15.441  26.943  91.748  1.00 45.32           C  
ATOM    385  O   PRO A  46      16.288  26.362  92.427  1.00 44.81           O  
ATOM    386  CB  PRO A  46      13.537  25.351  91.503  1.00 45.66           C  
ATOM    387  CG  PRO A  46      13.457  24.070  90.790  1.00 45.77           C  
ATOM    388  CD  PRO A  46      14.842  23.791  90.331  1.00 45.65           C  
ATOM    389  N   GLU A  47      15.169  28.242  91.857  1.00 45.40           N  
ATOM    390  CA  GLU A  47      15.947  29.116  92.748  1.00 45.34           C  
ATOM    391  C   GLU A  47      15.964  28.595  94.179  1.00 45.16           C  
ATOM    392  O   GLU A  47      16.992  28.661  94.846  1.00 44.39           O  
ATOM    393  CB  GLU A  47      15.425  30.550  92.695  1.00 45.74           C  
ATOM    394  CG  GLU A  47      16.310  31.564  93.377  1.00 46.03           C  
ATOM    395  CD  GLU A  47      15.891  32.990  93.067  1.00 47.64           C  
ATOM    396  OE1 GLU A  47      14.678  33.265  93.114  1.00 49.65           O  
ATOM    397  OE2 GLU A  47      16.759  33.838  92.760  1.00 46.93           O  
ATOM    398  N   ARG A  48      14.849  28.040  94.648  1.00 45.03           N  
ATOM    399  CA  ARG A  48      14.804  27.493  96.012  1.00 44.89           C  
ATOM    400  C   ARG A  48      15.948  26.519  96.340  1.00 43.62           C  
ATOM    401  O   ARG A  48      16.530  26.588  97.426  1.00 43.17           O  
ATOM    402  CB  ARG A  48      13.456  26.798  96.267  1.00 46.08           C  
ATOM    403  CG  ARG A  48      13.331  26.211  97.672  1.00 48.42           C  
ATOM    404  CD  ARG A  48      11.882  25.918  98.029  1.00 53.45           C  
ATOM    405  NE  ARG A  48      11.359  24.794  97.255  1.00 57.66           N  
ATOM    406  CZ  ARG A  48      10.089  24.386  97.271  1.00 60.93           C  
ATOM    407  NH1 ARG A  48       9.177  25.019  98.008  1.00 62.81           N  
ATOM    408  NH2 ARG A  48       9.723  23.343  96.528  1.00 61.91           N  
ATOM    409  N   GLU A  49      16.247  25.600  95.424  1.00 42.51           N  
ATOM    410  CA  GLU A  49      17.370  24.663  95.615  1.00 41.90           C  
ATOM    411  C   GLU A  49      18.679  25.214  95.046  1.00 40.59           C  
ATOM    412  O   GLU A  49      19.764  24.781  95.432  1.00 40.07           O  
ATOM    413  CB  GLU A  49      17.079  23.309  94.967  1.00 42.45           C  
ATOM    414  CG  GLU A  49      16.015  22.487  95.703  1.00 44.54           C  
ATOM    415  CD  GLU A  49      14.603  22.960  95.433  1.00 47.09           C  
ATOM    416  OE1 GLU A  49      14.324  23.442  94.310  1.00 50.45           O  
ATOM    417  OE2 GLU A  49      13.762  22.840  96.345  1.00 49.59           O  
ATOM    418  N   GLY A  50      18.564  26.161  94.126  1.00 38.86           N  
ATOM    419  CA  GLY A  50      19.729  26.741  93.456  1.00 37.72           C  
ATOM    420  C   GLY A  50      20.573  27.627  94.341  1.00 36.63           C  
ATOM    421  O   GLY A  50      21.813  27.624  94.225  1.00 34.81           O  
ATOM    422  N   LEU A  51      19.920  28.411  95.198  1.00 34.66           N  
ATOM    423  CA  LEU A  51      20.634  29.338  96.072  1.00 34.56           C  
ATOM    424  C   LEU A  51      21.558  28.661  97.093  1.00 33.75           C  
ATOM    425  O   LEU A  51      22.696  29.067  97.265  1.00 32.76           O  
ATOM    426  CB  LEU A  51      19.653  30.316  96.751  1.00 34.73           C  
ATOM    427  CG  LEU A  51      18.906  31.290  95.816  1.00 35.42           C  
ATOM    428  CD1 LEU A  51      18.112  32.316  96.611  1.00 36.82           C  
ATOM    429  CD2 LEU A  51      19.843  32.013  94.857  1.00 35.33           C  
ATOM    430  N   PRO A  52      21.058  27.657  97.826  1.00 33.02           N  
ATOM    431  CA  PRO A  52      21.942  26.910  98.721  1.00 32.70           C  
ATOM    432  C   PRO A  52      23.169  26.281  98.037  1.00 31.26           C  
ATOM    433  O   PRO A  52      24.257  26.273  98.617  1.00 31.40           O  
ATOM    434  CB  PRO A  52      21.031  25.817  99.298  1.00 33.28           C  
ATOM    435  CG  PRO A  52      19.667  26.199  99.012  1.00 33.34           C  
ATOM    436  CD  PRO A  52      19.647  27.235  97.931  1.00 33.85           C  
ATOM    437  N   ILE A  53      22.982  25.769  96.820  1.00 30.59           N  
ATOM    438  CA  ILE A  53      24.075  25.255  96.001  1.00 29.95           C  
ATOM    439  C   ILE A  53      25.044  26.376  95.640  1.00 28.85           C  
ATOM    440  O   ILE A  53      26.243  26.189  95.699  1.00 28.60           O  
ATOM    441  CB  ILE A  53      23.573  24.583  94.691  1.00 29.90           C  
ATOM    442  CG1 ILE A  53      22.799  23.281  94.980  1.00 31.56           C  
ATOM    443  CG2 ILE A  53      24.722  24.314  93.758  1.00 30.20           C  
ATOM    444  CD1 ILE A  53      21.947  22.783  93.797  1.00 30.86           C  
ATOM    445  N   LEU A  54      24.521  27.534  95.249  1.00 28.91           N  
ATOM    446  CA  LEU A  54      25.395  28.662  94.890  1.00 28.36           C  
ATOM    447  C   LEU A  54      26.285  29.028  96.082  1.00 27.33           C  
ATOM    448  O   LEU A  54      27.497  29.241  95.947  1.00 26.43           O  
ATOM    449  CB  LEU A  54      24.535  29.847  94.432  1.00 29.06           C  
ATOM    450  CG  LEU A  54      25.187  31.195  94.072  1.00 30.44           C  
ATOM    451  CD1 LEU A  54      26.137  31.072  92.903  1.00 31.06           C  
ATOM    452  CD2 LEU A  54      24.134  32.256  93.793  1.00 31.39           C  
HETATM  453  N   MSE A  55      25.695  29.089  97.269  1.00 26.61           N  
HETATM  454  CA  MSE A  55      26.433  29.464  98.469  1.00 26.62           C  
HETATM  455  C   MSE A  55      27.596  28.513  98.697  1.00 25.92           C  
HETATM  456  O   MSE A  55      28.705  28.926  98.914  1.00 24.95           O  
HETATM  457  CB  MSE A  55      25.513  29.452  99.701  1.00 27.81           C  
HETATM  458  CG  MSE A  55      26.144  30.016 100.919  1.00 30.86           C  
HETATM  459 SE   MSE A  55      24.917  29.741 102.449  1.00 42.53          SE  
HETATM  460  CE  MSE A  55      24.268  27.927 102.039  1.00 37.08           C  
ATOM    461  N   GLU A  56      27.313  27.222  98.641  1.00 26.32           N  
ATOM    462  CA  GLU A  56      28.337  26.214  98.871  1.00 26.49           C  
ATOM    463  C   GLU A  56      29.343  26.110  97.714  1.00 26.36           C  
ATOM    464  O   GLU A  56      30.521  25.925  97.971  1.00 25.93           O  
ATOM    465  CB  GLU A  56      27.694  24.861  99.127  1.00 27.59           C  
ATOM    466  CG  GLU A  56      26.840  24.824 100.387  1.00 28.58           C  
ATOM    467  CD  GLU A  56      27.629  25.025 101.676  1.00 28.94           C  
ATOM    468  OE1 GLU A  56      28.875  24.940 101.698  1.00 29.27           O  
ATOM    469  OE2 GLU A  56      26.978  25.248 102.717  1.00 32.76           O  
ATOM    470  N   ALA A  57      28.869  26.247  96.474  1.00 27.27           N  
ATOM    471  CA  ALA A  57      29.768  26.251  95.314  1.00 27.79           C  
ATOM    472  C   ALA A  57      30.816  27.363  95.448  1.00 27.46           C  
ATOM    473  O   ALA A  57      31.995  27.176  95.099  1.00 27.82           O  
ATOM    474  CB  ALA A  57      28.983  26.426  94.034  1.00 27.57           C  
ATOM    475  N   LEU A  58      30.369  28.514  95.945  1.00 27.32           N  
ATOM    476  CA  LEU A  58      31.227  29.698  96.136  1.00 26.88           C  
ATOM    477  C   LEU A  58      31.983  29.715  97.472  1.00 26.86           C  
ATOM    478  O   LEU A  58      32.778  30.633  97.749  1.00 25.70           O  
ATOM    479  CB  LEU A  58      30.371  30.960  96.003  1.00 27.60           C  
ATOM    480  CG  LEU A  58      29.737  31.248  94.631  1.00 28.74           C  
ATOM    481  CD1 LEU A  58      28.941  32.521  94.706  1.00 32.27           C  
ATOM    482  CD2 LEU A  58      30.795  31.350  93.530  1.00 29.34           C  
ATOM    483  N   GLU A  59      31.791  28.671  98.284  1.00 26.89           N  
ATOM    484  CA  GLU A  59      32.474  28.536  99.562  1.00 27.83           C  
ATOM    485  C   GLU A  59      32.243  29.733 100.479  1.00 27.34           C  
ATOM    486  O   GLU A  59      33.143  30.160 101.225  1.00 27.08           O  
ATOM    487  CB  GLU A  59      33.970  28.288  99.353  1.00 28.78           C  
ATOM    488  CG  GLU A  59      34.267  27.111  98.427  1.00 32.24           C  
ATOM    489  CD  GLU A  59      35.744  26.849  98.245  1.00 36.78           C  
ATOM    490  OE1 GLU A  59      36.582  27.665  98.705  1.00 39.27           O  
ATOM    491  OE2 GLU A  59      36.073  25.808  97.633  1.00 40.22           O  
ATOM    492  N   ILE A  60      31.019  30.236 100.440  1.00 28.42           N  
ATOM    493  CA  ILE A  60      30.604  31.339 101.287  1.00 29.24           C  
ATOM    494  C   ILE A  60      30.203  30.796 102.651  1.00 30.59           C  
ATOM    495  O   ILE A  60      29.443  29.836 102.744  1.00 30.88           O  
ATOM    496  CB  ILE A  60      29.446  32.122 100.660  1.00 29.18           C  
ATOM    497  CG1 ILE A  60      29.974  32.915  99.451  1.00 28.68           C  
ATOM    498  CG2 ILE A  60      28.813  33.046 101.704  1.00 28.11           C  
ATOM    499  CD1 ILE A  60      28.921  33.536  98.555  1.00 27.15           C  
ATOM    500  N   LYS A  61      30.728  31.439 103.681  1.00 31.79           N  
ATOM    501  CA  LYS A  61      30.508  31.056 105.061  1.00 33.65           C  
ATOM    502  C   LYS A  61      29.547  32.074 105.661  1.00 34.22           C  
ATOM    503  O   LYS A  61      29.950  33.107 106.183  1.00 34.66           O  
ATOM    504  CB  LYS A  61      31.828  31.028 105.822  1.00 33.55           C  
ATOM    505  CG  LYS A  61      32.912  30.101 105.226  1.00 34.82           C  
ATOM    506  CD  LYS A  61      32.339  28.726 104.861  1.00 36.17           C  
ATOM    507  CE  LYS A  61      33.402  27.749 104.384  1.00 37.44           C  
ATOM    508  NZ  LYS A  61      32.764  26.623 103.628  1.00 37.62           N  
ATOM    509  N   ASP A  62      28.269  31.778 105.537  1.00 35.14           N  
ATOM    510  CA  ASP A  62      27.229  32.588 106.142  1.00 36.37           C  
ATOM    511  C   ASP A  62      26.044  31.660 106.355  1.00 37.74           C  
ATOM    512  O   ASP A  62      26.063  30.516 105.890  1.00 38.43           O  
ATOM    513  CB  ASP A  62      26.863  33.751 105.207  1.00 36.37           C  
ATOM    514  CG  ASP A  62      26.253  34.952 105.943  1.00 37.22           C  
ATOM    515  OD1 ASP A  62      26.129  34.934 107.197  1.00 34.84           O  
ATOM    516  OD2 ASP A  62      25.904  35.930 105.249  1.00 35.67           O  
ATOM    517  N   SER A  63      25.024  32.132 107.065  1.00 38.34           N  
ATOM    518  CA  SER A  63      23.784  31.381 107.184  1.00 38.83           C  
ATOM    519  C   SER A  63      23.048  31.458 105.861  1.00 39.08           C  
ATOM    520  O   SER A  63      23.173  32.455 105.128  1.00 38.85           O  
ATOM    521  CB  SER A  63      22.910  31.961 108.295  1.00 38.60           C  
ATOM    522  OG  SER A  63      22.222  33.111 107.829  1.00 38.34           O  
ATOM    523  N   LEU A  64      22.265  30.427 105.546  1.00 39.43           N  
ATOM    524  CA  LEU A  64      21.445  30.470 104.339  1.00 39.80           C  
ATOM    525  C   LEU A  64      20.443  31.627 104.393  1.00 40.29           C  
ATOM    526  O   LEU A  64      20.085  32.191 103.370  1.00 39.48           O  
ATOM    527  CB  LEU A  64      20.714  29.142 104.094  1.00 39.61           C  
ATOM    528  CG  LEU A  64      19.934  29.052 102.782  1.00 40.50           C  
ATOM    529  CD1 LEU A  64      20.835  29.338 101.561  1.00 39.83           C  
ATOM    530  CD2 LEU A  64      19.237  27.697 102.627  1.00 40.10           C  
ATOM    531  N   GLU A  65      20.007  31.963 105.600  1.00 41.01           N  
ATOM    532  CA  GLU A  65      19.075  33.058 105.824  1.00 41.71           C  
ATOM    533  C   GLU A  65      19.667  34.400 105.422  1.00 41.08           C  
ATOM    534  O   GLU A  65      19.022  35.171 104.713  1.00 41.34           O  
ATOM    535  CB  GLU A  65      18.679  33.090 107.305  1.00 42.18           C  
ATOM    536  CG  GLU A  65      17.901  34.318 107.727  1.00 44.41           C  
ATOM    537  CD  GLU A  65      17.142  34.091 109.020  1.00 47.44           C  
ATOM    538  OE1 GLU A  65      17.734  33.514 109.957  1.00 49.26           O  
ATOM    539  OE2 GLU A  65      15.957  34.482 109.089  1.00 50.16           O  
ATOM    540  N   ASN A  66      20.874  34.676 105.905  1.00 41.15           N  
ATOM    541  CA  ASN A  66      21.617  35.868 105.495  1.00 41.19           C  
ATOM    542  C   ASN A  66      21.874  35.864 103.979  1.00 40.62           C  
ATOM    543  O   ASN A  66      21.673  36.879 103.309  1.00 40.58           O  
ATOM    544  CB  ASN A  66      22.936  35.986 106.249  1.00 41.59           C  
ATOM    545  CG  ASN A  66      22.759  36.302 107.742  1.00 43.02           C  
ATOM    546  OD1 ASN A  66      23.676  36.089 108.535  1.00 43.81           O  
ATOM    547  ND2 ASN A  66      21.589  36.813 108.122  1.00 44.20           N  
ATOM    548  N   PHE A  67      22.284  34.717 103.440  1.00 39.66           N  
ATOM    549  CA  PHE A  67      22.559  34.596 101.999  1.00 38.58           C  
ATOM    550  C   PHE A  67      21.336  34.959 101.173  1.00 38.90           C  
ATOM    551  O   PHE A  67      21.410  35.800 100.273  1.00 37.93           O  
ATOM    552  CB  PHE A  67      23.015  33.172 101.666  1.00 38.24           C  
ATOM    553  CG  PHE A  67      23.524  33.001 100.253  1.00 36.45           C  
ATOM    554  CD1 PHE A  67      24.775  33.492  99.892  1.00 35.20           C  
ATOM    555  CD2 PHE A  67      22.773  32.332  99.304  1.00 34.59           C  
ATOM    556  CE1 PHE A  67      25.243  33.342  98.592  1.00 33.96           C  
ATOM    557  CE2 PHE A  67      23.235  32.164  98.009  1.00 34.40           C  
ATOM    558  CZ  PHE A  67      24.487  32.671  97.651  1.00 32.06           C  
ATOM    559  N   LYS A  68      20.210  34.313 101.492  1.00 39.06           N  
ATOM    560  CA  LYS A  68      18.947  34.535 100.793  1.00 39.69           C  
ATOM    561  C   LYS A  68      18.522  36.000 100.814  1.00 39.56           C  
ATOM    562  O   LYS A  68      17.983  36.509  99.837  1.00 39.24           O  
ATOM    563  CB  LYS A  68      17.850  33.637 101.379  1.00 40.08           C  
ATOM    564  CG  LYS A  68      17.838  32.227 100.762  1.00 42.18           C  
ATOM    565  CD  LYS A  68      16.809  31.295 101.408  1.00 45.18           C  
ATOM    566  CE  LYS A  68      15.987  30.492 100.355  1.00 47.21           C  
ATOM    567  NZ  LYS A  68      16.739  29.524  99.454  1.00 47.10           N  
ATOM    568  N   LYS A  69      18.784  36.668 101.930  1.00 39.96           N  
ATOM    569  CA  LYS A  69      18.529  38.099 102.063  1.00 40.63           C  
ATOM    570  C   LYS A  69      19.403  38.944 101.135  1.00 40.14           C  
ATOM    571  O   LYS A  69      18.929  39.886 100.510  1.00 39.58           O  
ATOM    572  CB  LYS A  69      18.782  38.522 103.505  1.00 41.05           C  
ATOM    573  CG  LYS A  69      18.398  39.974 103.806  1.00 44.29           C  
ATOM    574  CD  LYS A  69      18.742  40.359 105.237  1.00 46.57           C  
ATOM    575  CE  LYS A  69      18.608  41.870 105.455  1.00 47.89           C  
ATOM    576  NZ  LYS A  69      18.920  42.252 106.869  1.00 47.99           N  
ATOM    577  N   ARG A  70      20.690  38.611 101.071  1.00 39.81           N  
ATOM    578  CA  ARG A  70      21.609  39.293 100.160  1.00 39.75           C  
ATOM    579  C   ARG A  70      21.176  39.116  98.708  1.00 39.06           C  
ATOM    580  O   ARG A  70      21.192  40.062  97.927  1.00 38.06           O  
ATOM    581  CB  ARG A  70      23.032  38.760 100.349  1.00 40.20           C  
ATOM    582  CG  ARG A  70      23.612  39.035 101.716  1.00 42.13           C  
ATOM    583  CD  ARG A  70      24.229  40.414 101.831  1.00 43.82           C  
ATOM    584  NE  ARG A  70      25.648  40.426 101.498  1.00 43.86           N  
ATOM    585  CZ  ARG A  70      26.615  39.912 102.250  1.00 43.24           C  
ATOM    586  NH1 ARG A  70      26.347  39.302 103.395  1.00 43.75           N  
ATOM    587  NH2 ARG A  70      27.873  39.989 101.843  1.00 41.63           N  
ATOM    588  N   VAL A  71      20.798  37.896  98.349  1.00 38.45           N  
ATOM    589  CA  VAL A  71      20.263  37.623  97.023  1.00 39.17           C  
ATOM    590  C   VAL A  71      19.040  38.511  96.746  1.00 40.14           C  
ATOM    591  O   VAL A  71      18.958  39.162  95.699  1.00 38.93           O  
ATOM    592  CB  VAL A  71      19.919  36.128  96.871  1.00 38.72           C  
ATOM    593  CG1 VAL A  71      19.197  35.857  95.578  1.00 37.18           C  
ATOM    594  CG2 VAL A  71      21.209  35.282  96.974  1.00 38.66           C  
ATOM    595  N   HIS A  72      18.120  38.571  97.708  1.00 41.43           N  
ATOM    596  CA  HIS A  72      16.923  39.411  97.563  1.00 42.82           C  
ATOM    597  C   HIS A  72      17.317  40.871  97.321  1.00 42.57           C  
ATOM    598  O   HIS A  72      16.819  41.518  96.400  1.00 42.43           O  
ATOM    599  CB  HIS A  72      16.027  39.272  98.805  1.00 43.23           C  
ATOM    600  CG  HIS A  72      14.820  40.160  98.786  1.00 45.66           C  
ATOM    601  ND1 HIS A  72      13.760  39.965  97.926  1.00 48.04           N  
ATOM    602  CD2 HIS A  72      14.512  41.261  99.516  1.00 47.94           C  
ATOM    603  CE1 HIS A  72      12.849  40.900  98.133  1.00 47.88           C  
ATOM    604  NE2 HIS A  72      13.279  41.696  99.096  1.00 48.80           N  
ATOM    605  N   GLU A  73      18.244  41.353  98.137  1.00 42.95           N  
ATOM    606  CA  GLU A  73      18.745  42.723  98.066  1.00 43.16           C  
ATOM    607  C   GLU A  73      19.359  43.046  96.691  1.00 42.95           C  
ATOM    608  O   GLU A  73      18.982  44.033  96.047  1.00 43.18           O  
ATOM    609  CB  GLU A  73      19.769  42.931  99.185  1.00 43.36           C  
ATOM    610  CG  GLU A  73      20.146  44.376  99.469  1.00 44.36           C  
ATOM    611  CD  GLU A  73      20.556  44.616 100.928  0.30 44.62           C  
ATOM    612  OE1 GLU A  73      20.613  43.644 101.717  0.30 44.61           O  
ATOM    613  OE2 GLU A  73      20.821  45.785 101.289  0.30 44.16           O  
ATOM    614  N   GLU A  74      20.264  42.193  96.225  1.00 42.43           N  
ATOM    615  CA  GLU A  74      20.953  42.438  94.951  1.00 41.84           C  
ATOM    616  C   GLU A  74      20.028  42.330  93.729  1.00 41.88           C  
ATOM    617  O   GLU A  74      20.210  43.060  92.752  1.00 41.43           O  
ATOM    618  CB  GLU A  74      22.165  41.506  94.785  1.00 41.53           C  
ATOM    619  CG  GLU A  74      23.222  41.609  95.889  1.00 40.42           C  
ATOM    620  CD  GLU A  74      23.979  42.939  95.945  1.00 39.39           C  
ATOM    621  OE1 GLU A  74      23.667  43.888  95.196  1.00 36.33           O  
ATOM    622  OE2 GLU A  74      24.920  43.011  96.763  1.00 42.03           O  
ATOM    623  N   LYS A  75      19.050  41.425  93.771  1.00 41.87           N  
ATOM    624  CA  LYS A  75      18.045  41.325  92.699  1.00 42.05           C  
ATOM    625  C   LYS A  75      17.211  42.607  92.584  1.00 42.32           C  
ATOM    626  O   LYS A  75      16.966  43.081  91.482  1.00 41.96           O  
ATOM    627  CB  LYS A  75      17.138  40.109  92.906  1.00 42.19           C  
ATOM    628  CG  LYS A  75      17.819  38.793  92.578  1.00 42.82           C  
ATOM    629  CD  LYS A  75      16.943  37.574  92.910  1.00 44.93           C  
ATOM    630  CE  LYS A  75      15.799  37.403  91.907  1.00 46.04           C  
ATOM    631  NZ  LYS A  75      15.022  36.137  92.140  1.00 47.35           N  
ATOM    632  N   LYS A  76      16.797  43.184  93.710  1.00 42.47           N  
ATOM    633  CA  LYS A  76      16.059  44.440  93.669  1.00 43.26           C  
ATOM    634  C   LYS A  76      16.907  45.527  93.023  1.00 42.53           C  
ATOM    635  O   LYS A  76      16.424  46.252  92.164  1.00 42.65           O  
ATOM    636  CB  LYS A  76      15.601  44.877  95.069  1.00 43.88           C  
ATOM    637  CG  LYS A  76      14.426  44.061  95.644  1.00 46.85           C  
ATOM    638  CD  LYS A  76      13.045  44.425  95.029  1.00 50.10           C  
ATOM    639  CE  LYS A  76      11.912  44.288  96.076  1.00 51.55           C  
ATOM    640  NZ  LYS A  76      10.537  44.022  95.506  1.00 53.25           N  
ATOM    641  N   ARG A  77      18.167  45.631  93.434  1.00 41.64           N  
ATOM    642  CA  ARG A  77      19.069  46.634  92.895  1.00 41.34           C  
ATOM    643  C   ARG A  77      19.248  46.475  91.393  1.00 40.49           C  
ATOM    644  O   ARG A  77      19.088  47.435  90.641  1.00 40.63           O  
ATOM    645  CB  ARG A  77      20.439  46.540  93.562  1.00 42.03           C  
ATOM    646  CG  ARG A  77      20.470  46.983  95.019  1.00 43.68           C  
ATOM    647  CD  ARG A  77      21.911  47.110  95.497  1.00 46.37           C  
ATOM    648  NE  ARG A  77      22.107  46.748  96.901  1.00 50.11           N  
ATOM    649  CZ  ARG A  77      21.841  47.530  97.949  1.00 53.18           C  
ATOM    650  NH1 ARG A  77      21.335  48.757  97.788  1.00 55.16           N  
ATOM    651  NH2 ARG A  77      22.071  47.081  99.180  1.00 53.84           N  
ATOM    652  N   VAL A  78      19.605  45.265  90.971  1.00 39.07           N  
ATOM    653  CA  VAL A  78      19.813  44.976  89.557  1.00 38.32           C  
ATOM    654  C   VAL A  78      18.520  45.231  88.772  1.00 37.82           C  
ATOM    655  O   VAL A  78      18.552  45.916  87.751  1.00 37.91           O  
ATOM    656  CB  VAL A  78      20.337  43.529  89.339  1.00 37.94           C  
ATOM    657  CG1 VAL A  78      20.473  43.200  87.851  1.00 37.26           C  
ATOM    658  CG2 VAL A  78      21.696  43.355  90.047  1.00 37.25           C  
ATOM    659  N   PHE A  79      17.389  44.709  89.257  1.00 37.92           N  
ATOM    660  CA  PHE A  79      16.111  44.855  88.525  1.00 37.97           C  
ATOM    661  C   PHE A  79      15.716  46.321  88.487  1.00 38.38           C  
ATOM    662  O   PHE A  79      15.323  46.846  87.451  1.00 38.49           O  
ATOM    663  CB  PHE A  79      14.990  44.021  89.158  1.00 38.28           C  
ATOM    664  CG  PHE A  79      15.144  42.526  88.980  1.00 39.44           C  
ATOM    665  CD1 PHE A  79      16.293  41.960  88.420  1.00 40.62           C  
ATOM    666  CD2 PHE A  79      14.135  41.677  89.405  1.00 39.71           C  
ATOM    667  CE1 PHE A  79      16.414  40.585  88.289  1.00 40.39           C  
ATOM    668  CE2 PHE A  79      14.263  40.300  89.284  1.00 40.20           C  
ATOM    669  CZ  PHE A  79      15.389  39.755  88.713  1.00 39.64           C  
ATOM    670  N   SER A  80      15.856  47.004  89.611  1.00 38.94           N  
ATOM    671  CA  SER A  80      15.596  48.426  89.630  1.00 39.77           C  
ATOM    672  C   SER A  80      16.449  49.198  88.619  1.00 39.57           C  
ATOM    673  O   SER A  80      15.948  50.085  87.916  1.00 39.95           O  
ATOM    674  CB  SER A  80      15.791  48.983  91.040  1.00 39.69           C  
ATOM    675  OG  SER A  80      15.656  50.392  91.029  1.00 43.37           O  
ATOM    676  N   GLU A  81      17.736  48.868  88.545  1.00 39.79           N  
ATOM    677  CA  GLU A  81      18.661  49.548  87.628  1.00 39.94           C  
ATOM    678  C   GLU A  81      18.388  49.183  86.167  1.00 39.29           C  
ATOM    679  O   GLU A  81      18.280  50.060  85.313  1.00 39.72           O  
ATOM    680  CB  GLU A  81      20.116  49.202  87.982  1.00 40.64           C  
ATOM    681  CG  GLU A  81      21.200  49.888  87.106  1.00 42.93           C  
ATOM    682  CD  GLU A  81      22.618  49.375  87.401  1.00 46.83           C  
ATOM    683  OE1 GLU A  81      22.950  49.200  88.596  1.00 46.74           O  
ATOM    684  OE2 GLU A  81      23.397  49.141  86.440  1.00 48.90           O  
ATOM    685  N   LEU A  82      18.260  47.892  85.886  1.00 37.66           N  
ATOM    686  CA  LEU A  82      18.390  47.418  84.510  1.00 37.29           C  
ATOM    687  C   LEU A  82      17.140  46.809  83.901  1.00 36.77           C  
ATOM    688  O   LEU A  82      17.143  46.529  82.700  1.00 36.65           O  
ATOM    689  CB  LEU A  82      19.544  46.411  84.415  1.00 37.30           C  
ATOM    690  CG  LEU A  82      20.954  46.962  84.698  1.00 38.40           C  
ATOM    691  CD1 LEU A  82      21.984  45.836  84.783  1.00 39.63           C  
ATOM    692  CD2 LEU A  82      21.329  47.973  83.653  1.00 37.96           C  
ATOM    693  N   LEU A  83      16.095  46.568  84.689  1.00 36.81           N  
ATOM    694  CA  LEU A  83      14.906  45.905  84.129  1.00 36.37           C  
ATOM    695  C   LEU A  83      14.115  46.960  83.372  1.00 35.59           C  
ATOM    696  O   LEU A  83      13.793  48.018  83.906  1.00 35.80           O  
ATOM    697  CB  LEU A  83      14.047  45.214  85.185  1.00 36.50           C  
ATOM    698  CG  LEU A  83      12.847  44.382  84.696  1.00 36.92           C  
ATOM    699  CD1 LEU A  83      13.294  43.265  83.725  1.00 36.37           C  
ATOM    700  CD2 LEU A  83      12.066  43.792  85.844  1.00 38.06           C  
ATOM    701  N   LYS A  84      13.845  46.661  82.108  1.00 34.91           N  
ATOM    702  CA  LYS A  84      13.163  47.582  81.214  1.00 34.47           C  
ATOM    703  C   LYS A  84      12.081  46.806  80.504  1.00 33.16           C  
ATOM    704  O   LYS A  84      12.182  45.584  80.331  1.00 31.50           O  
ATOM    705  CB  LYS A  84      14.157  48.146  80.207  1.00 35.26           C  
ATOM    706  CG  LYS A  84      14.554  49.597  80.426  1.00 40.42           C  
ATOM    707  CD  LYS A  84      14.906  49.926  81.847  1.00 43.93           C  
ATOM    708  CE  LYS A  84      15.615  51.266  81.954  1.00 46.75           C  
ATOM    709  NZ  LYS A  84      16.689  51.214  82.981  1.00 48.35           N  
ATOM    710  N   GLU A  85      11.046  47.512  80.082  1.00 30.84           N  
ATOM    711  CA  GLU A  85      10.001  46.891  79.298  1.00 30.38           C  
ATOM    712  C   GLU A  85      10.584  46.375  77.978  1.00 30.12           C  
ATOM    713  O   GLU A  85      11.552  46.952  77.439  1.00 31.37           O  
ATOM    714  CB  GLU A  85       8.885  47.893  79.013  1.00 30.25           C  
ATOM    715  CG  GLU A  85       9.327  49.018  78.091  1.00 32.05           C  
ATOM    716  CD  GLU A  85       8.487  50.277  78.223  1.00 32.98           C  
ATOM    717  OE1 GLU A  85       8.673  51.004  79.209  1.00 35.45           O  
ATOM    718  OE2 GLU A  85       7.673  50.561  77.323  1.00 36.22           O  
ATOM    719  N   ASN A  86       9.992  45.316  77.442  1.00 29.24           N  
ATOM    720  CA  ASN A  86      10.360  44.812  76.111  1.00 29.56           C  
ATOM    721  C   ASN A  86       9.880  45.775  75.024  1.00 30.36           C  
ATOM    722  O   ASN A  86       8.812  46.372  75.148  1.00 29.86           O  
ATOM    723  CB  ASN A  86       9.802  43.408  75.870  1.00 30.21           C  
ATOM    724  CG  ASN A  86      10.602  42.358  76.590  1.00 28.84           C  
ATOM    725  OD1 ASN A  86      11.773  42.595  76.891  1.00 31.38           O  
ATOM    726  ND2 ASN A  86      10.010  41.194  76.854  1.00 28.89           N  
ATOM    727  N   PRO A  87      10.666  45.923  73.941  1.00 31.56           N  
ATOM    728  CA  PRO A  87      10.229  46.878  72.919  1.00 31.27           C  
ATOM    729  C   PRO A  87       8.924  46.445  72.268  1.00 30.68           C  
ATOM    730  O   PRO A  87       8.703  45.250  72.018  1.00 31.75           O  
ATOM    731  CB  PRO A  87      11.389  46.872  71.905  1.00 31.96           C  
ATOM    732  CG  PRO A  87      12.085  45.540  72.126  1.00 33.61           C  
ATOM    733  CD  PRO A  87      11.934  45.253  73.580  1.00 32.97           C  
ATOM    734  N   GLY A  88       8.059  47.421  72.003  1.00 30.03           N  
ATOM    735  CA  GLY A  88       6.801  47.189  71.308  1.00 29.32           C  
ATOM    736  C   GLY A  88       5.665  46.797  72.230  1.00 29.47           C  
ATOM    737  O   GLY A  88       4.499  46.895  71.853  1.00 28.23           O  
ATOM    738  N   VAL A  89       5.982  46.354  73.449  1.00 28.90           N  
ATOM    739  CA  VAL A  89       4.918  45.848  74.300  1.00 29.83           C  
ATOM    740  C   VAL A  89       3.940  46.942  74.814  1.00 28.89           C  
ATOM    741  O   VAL A  89       2.728  46.732  74.802  1.00 29.04           O  
ATOM    742  CB  VAL A  89       5.484  44.970  75.420  1.00 30.09           C  
ATOM    743  CG1 VAL A  89       4.362  44.484  76.289  1.00 33.81           C  
ATOM    744  CG2 VAL A  89       6.243  43.819  74.809  1.00 30.37           C  
ATOM    745  N   ARG A  90       4.443  48.108  75.212  1.00 28.90           N  
ATOM    746  CA  ARG A  90       3.565  49.218  75.598  1.00 28.71           C  
ATOM    747  C   ARG A  90       2.575  49.583  74.497  1.00 28.91           C  
ATOM    748  O   ARG A  90       1.383  49.801  74.760  1.00 28.64           O  
ATOM    749  CB  ARG A  90       4.394  50.427  76.032  1.00 28.87           C  
ATOM    750  CG  ARG A  90       3.580  51.529  76.649  1.00 29.36           C  
ATOM    751  CD  ARG A  90       4.459  52.677  77.093  1.00 29.30           C  
ATOM    752  NE  ARG A  90       5.385  52.222  78.125  1.00 31.25           N  
ATOM    753  CZ  ARG A  90       5.120  52.220  79.439  1.00 30.72           C  
ATOM    754  NH1 ARG A  90       3.952  52.626  79.914  1.00 29.03           N  
ATOM    755  NH2 ARG A  90       6.036  51.780  80.276  1.00 29.72           N  
ATOM    756  N   GLU A  91       3.051  49.633  73.247  1.00 28.52           N  
ATOM    757  CA  GLU A  91       2.175  49.948  72.100  1.00 28.49           C  
ATOM    758  C   GLU A  91       1.096  48.903  71.924  1.00 27.14           C  
ATOM    759  O   GLU A  91      -0.025  49.206  71.496  1.00 27.28           O  
ATOM    760  CB  GLU A  91       2.987  49.998  70.803  1.00 29.14           C  
ATOM    761  CG  GLU A  91       3.391  51.331  70.341  1.00 33.36           C  
ATOM    762  CD  GLU A  91       4.009  51.273  68.940  0.50 32.39           C  
ATOM    763  OE1 GLU A  91       3.294  51.555  67.963  0.50 35.70           O  
ATOM    764  OE2 GLU A  91       5.194  50.908  68.833  0.50 33.44           O  
ATOM    765  N   ALA A  92       1.471  47.656  72.163  1.00 27.45           N  
ATOM    766  CA  ALA A  92       0.555  46.525  72.092  1.00 27.32           C  
ATOM    767  C   ALA A  92      -0.571  46.703  73.130  1.00 27.62           C  
ATOM    768  O   ALA A  92      -1.747  46.599  72.809  1.00 26.88           O  
ATOM    769  CB  ALA A  92       1.308  45.241  72.323  1.00 27.78           C  
ATOM    770  N   LEU A  93      -0.196  47.026  74.361  1.00 27.46           N  
ATOM    771  CA  LEU A  93      -1.172  47.242  75.439  1.00 26.87           C  
ATOM    772  C   LEU A  93      -2.085  48.427  75.130  1.00 26.78           C  
ATOM    773  O   LEU A  93      -3.294  48.351  75.267  1.00 26.67           O  
ATOM    774  CB  LEU A  93      -0.460  47.449  76.770  1.00 27.58           C  
ATOM    775  CG  LEU A  93       0.427  46.289  77.259  1.00 26.13           C  
ATOM    776  CD1 LEU A  93       1.080  46.729  78.599  1.00 27.68           C  
ATOM    777  CD2 LEU A  93      -0.384  45.033  77.402  1.00 28.56           C  
ATOM    778  N   GLU A  94      -1.485  49.509  74.667  1.00 27.48           N  
ATOM    779  CA  GLU A  94      -2.253  50.692  74.289  1.00 28.23           C  
ATOM    780  C   GLU A  94      -3.252  50.355  73.179  1.00 28.32           C  
ATOM    781  O   GLU A  94      -4.392  50.801  73.202  1.00 28.37           O  
ATOM    782  CB  GLU A  94      -1.289  51.774  73.838  1.00 28.53           C  
ATOM    783  CG  GLU A  94      -0.558  52.405  74.986  1.00 31.31           C  
ATOM    784  CD  GLU A  94       0.528  53.359  74.561  1.00 36.37           C  
ATOM    785  OE1 GLU A  94       1.003  53.271  73.404  1.00 39.93           O  
ATOM    786  OE2 GLU A  94       0.924  54.186  75.413  1.00 40.89           O  
ATOM    787  N   PHE A  95      -2.826  49.553  72.213  1.00 27.52           N  
ATOM    788  CA  PHE A  95      -3.709  49.151  71.125  1.00 27.27           C  
ATOM    789  C   PHE A  95      -4.926  48.367  71.602  1.00 27.19           C  
ATOM    790  O   PHE A  95      -6.044  48.612  71.144  1.00 26.78           O  
ATOM    791  CB  PHE A  95      -2.935  48.286  70.091  1.00 27.83           C  
ATOM    792  CG  PHE A  95      -3.778  47.908  68.891  1.00 27.68           C  
ATOM    793  CD1 PHE A  95      -4.153  48.871  67.968  1.00 29.61           C  
ATOM    794  CD2 PHE A  95      -4.244  46.613  68.729  1.00 28.10           C  
ATOM    795  CE1 PHE A  95      -4.961  48.535  66.868  1.00 28.80           C  
ATOM    796  CE2 PHE A  95      -5.049  46.264  67.653  1.00 28.44           C  
ATOM    797  CZ  PHE A  95      -5.417  47.260  66.717  1.00 28.52           C  
ATOM    798  N   VAL A  96      -4.712  47.378  72.477  1.00 26.17           N  
ATOM    799  CA  VAL A  96      -5.832  46.619  73.015  1.00 26.46           C  
ATOM    800  C   VAL A  96      -6.808  47.573  73.701  1.00 26.64           C  
ATOM    801  O   VAL A  96      -8.023  47.472  73.497  1.00 26.13           O  
ATOM    802  CB  VAL A  96      -5.387  45.509  74.012  1.00 26.88           C  
ATOM    803  CG1 VAL A  96      -6.590  44.791  74.550  1.00 26.65           C  
ATOM    804  CG2 VAL A  96      -4.414  44.552  73.309  1.00 27.16           C  
ATOM    805  N   LYS A  97      -6.304  48.505  74.501  1.00 27.22           N  
ATOM    806  CA  LYS A  97      -7.224  49.452  75.163  1.00 28.76           C  
ATOM    807  C   LYS A  97      -7.920  50.370  74.173  1.00 28.93           C  
ATOM    808  O   LYS A  97      -9.102  50.712  74.361  1.00 28.10           O  
ATOM    809  CB  LYS A  97      -6.527  50.257  76.251  1.00 29.59           C  
ATOM    810  CG  LYS A  97      -6.074  49.387  77.432  1.00 31.40           C  
ATOM    811  CD  LYS A  97      -7.117  48.335  77.902  1.00 33.47           C  
ATOM    812  CE  LYS A  97      -8.466  48.933  78.332  1.00 36.26           C  
ATOM    813  NZ  LYS A  97      -9.482  47.838  78.584  1.00 33.88           N  
ATOM    814  N   SER A  98      -7.196  50.745  73.115  1.00 28.74           N  
ATOM    815  CA  SER A  98      -7.770  51.561  72.015  1.00 28.82           C  
ATOM    816  C   SER A  98      -8.981  50.887  71.361  1.00 29.09           C  
ATOM    817  O   SER A  98      -9.860  51.577  70.820  1.00 29.51           O  
ATOM    818  CB  SER A  98      -6.725  51.857  70.942  1.00 29.21           C  
ATOM    819  OG  SER A  98      -6.654  50.816  69.950  1.00 29.03           O  
ATOM    820  N   LYS A  99      -9.025  49.551  71.398  1.00 30.59           N  
ATOM    821  CA  LYS A  99     -10.130  48.767  70.841  1.00 31.21           C  
ATOM    822  C   LYS A  99     -11.278  48.487  71.840  1.00 30.93           C  
ATOM    823  O   LYS A  99     -12.258  47.828  71.499  1.00 30.35           O  
ATOM    824  CB  LYS A  99      -9.591  47.454  70.281  1.00 32.34           C  
ATOM    825  CG  LYS A  99      -8.699  47.614  69.038  1.00 33.00           C  
ATOM    826  CD  LYS A  99      -9.480  47.954  67.768  1.00 39.54           C  
ATOM    827  CE  LYS A  99     -10.356  46.786  67.273  1.00 42.69           C  
ATOM    828  NZ  LYS A  99     -10.932  47.072  65.903  1.00 42.67           N  
ATOM    829  N   ARG A 100     -11.155  49.020  73.055  1.00 30.61           N  
ATOM    830  CA  ARG A 100     -12.136  48.843  74.107  1.00 31.11           C  
ATOM    831  C   ARG A 100     -12.324  47.361  74.404  1.00 31.42           C  
ATOM    832  O   ARG A 100     -13.446  46.868  74.584  1.00 31.62           O  
ATOM    833  CB  ARG A 100     -13.456  49.522  73.762  1.00 32.23           C  
ATOM    834  CG  ARG A 100     -13.328  51.035  73.703  1.00 34.14           C  
ATOM    835  CD  ARG A 100     -14.562  51.678  73.051  0.50 36.35           C  
ATOM    836  NE  ARG A 100     -14.678  51.263  71.651  0.50 38.87           N  
ATOM    837  CZ  ARG A 100     -15.630  50.484  71.134  0.50 40.68           C  
ATOM    838  NH1 ARG A 100     -16.640  50.020  71.871  0.50 41.18           N  
ATOM    839  NH2 ARG A 100     -15.581  50.179  69.840  0.50 41.62           N  
ATOM    840  N   ILE A 101     -11.191  46.670  74.422  1.00 30.51           N  
ATOM    841  CA  ILE A 101     -11.129  45.243  74.695  1.00 31.01           C  
ATOM    842  C   ILE A 101     -10.443  45.139  76.075  1.00 29.99           C  
ATOM    843  O   ILE A 101      -9.559  45.945  76.388  1.00 30.18           O  
ATOM    844  CB  ILE A 101     -10.300  44.519  73.546  1.00 30.56           C  
ATOM    845  CG1 ILE A 101     -11.155  44.423  72.284  1.00 32.87           C  
ATOM    846  CG2 ILE A 101      -9.826  43.108  73.928  1.00 32.65           C  
ATOM    847  CD1 ILE A 101     -10.424  43.945  71.097  1.00 35.02           C  
ATOM    848  N   LYS A 102     -10.853  44.158  76.868  1.00 28.84           N  
ATOM    849  CA  LYS A 102     -10.294  43.945  78.210  1.00 28.54           C  
ATOM    850  C   LYS A 102      -8.887  43.402  78.129  1.00 28.31           C  
ATOM    851  O   LYS A 102      -8.558  42.615  77.198  1.00 27.34           O  
ATOM    852  CB  LYS A 102     -11.157  42.957  78.978  1.00 29.47           C  
ATOM    853  CG  LYS A 102     -12.495  43.500  79.412  1.00 31.21           C  
ATOM    854  CD  LYS A 102     -13.202  42.504  80.313  1.00 34.91           C  
ATOM    855  CE  LYS A 102     -14.557  43.024  80.803  1.00 37.16           C  
ATOM    856  NZ  LYS A 102     -15.042  42.185  81.932  1.00 41.22           N  
ATOM    857  N   LEU A 103      -8.049  43.823  79.078  1.00 27.30           N  
ATOM    858  CA  LEU A 103      -6.641  43.449  79.105  0.70 26.87           C  
ATOM    860  C   LEU A 103      -6.361  42.804  80.447  1.00 26.63           C  
ATOM    861  O   LEU A 103      -6.736  43.372  81.503  1.00 26.07           O  
ATOM    862  CB  LEU A 103      -5.799  44.696  78.922  0.70 27.34           C  
ATOM    864  CG  LEU A 103      -4.298  44.680  78.746  0.70 29.50           C  
ATOM    866  CD1 LEU A 103      -3.867  43.616  77.726  0.70 28.46           C  
ATOM    868  CD2 LEU A 103      -3.841  46.087  78.318  0.70 27.55           C  
ATOM    870  N   ALA A 104      -5.745  41.637  80.396  1.00 26.35           N  
ATOM    871  CA  ALA A 104      -5.409  40.904  81.589  1.00 26.04           C  
ATOM    872  C   ALA A 104      -3.960  40.457  81.607  1.00 27.22           C  
ATOM    873  O   ALA A 104      -3.323  40.236  80.572  1.00 25.72           O  
ATOM    874  CB  ALA A 104      -6.332  39.705  81.771  1.00 26.49           C  
ATOM    875  N   LEU A 105      -3.475  40.314  82.830  1.00 28.13           N  
ATOM    876  CA  LEU A 105      -2.168  39.806  83.146  1.00 28.95           C  
ATOM    877  C   LEU A 105      -2.330  38.501  83.920  1.00 29.58           C  
ATOM    878  O   LEU A 105      -3.157  38.400  84.831  1.00 30.47           O  
ATOM    879  CB  LEU A 105      -1.450  40.807  84.062  1.00 28.44           C  
ATOM    880  CG  LEU A 105      -0.045  40.302  84.294  1.00 28.47           C  
ATOM    881  CD1 LEU A 105       0.838  40.712  83.121  1.00 31.86           C  
ATOM    882  CD2 LEU A 105       0.571  40.695  85.624  1.00 32.81           C  
ATOM    883  N   ALA A 106      -1.499  37.513  83.609  1.00 30.11           N  
ATOM    884  CA  ALA A 106      -1.415  36.286  84.401  1.00 30.12           C  
ATOM    885  C   ALA A 106       0.064  35.979  84.647  1.00 31.41           C  
ATOM    886  O   ALA A 106       0.874  35.986  83.725  1.00 32.64           O  
ATOM    887  CB  ALA A 106      -2.140  35.140  83.743  1.00 30.38           C  
ATOM    888  N   THR A 107       0.448  35.769  85.894  1.00 27.54           N  
ATOM    889  CA  THR A 107       1.826  35.529  86.201  1.00 27.79           C  
ATOM    890  C   THR A 107       1.943  34.542  87.341  1.00 26.72           C  
ATOM    891  O   THR A 107       1.136  34.587  88.259  1.00 27.08           O  
ATOM    892  CB  THR A 107       2.583  36.823  86.534  1.00 27.24           C  
ATOM    893  OG1 THR A 107       3.966  36.515  86.803  1.00 28.99           O  
ATOM    894  CG2 THR A 107       1.970  37.554  87.749  1.00 28.78           C  
ATOM    895  N   SER A 108       2.958  33.674  87.282  1.00 28.03           N  
ATOM    896  CA  SER A 108       3.280  32.813  88.408  1.00 28.18           C  
ATOM    897  C   SER A 108       3.888  33.580  89.596  1.00 28.05           C  
ATOM    898  O   SER A 108       4.006  33.057  90.696  1.00 28.66           O  
ATOM    899  CB  SER A 108       4.253  31.710  87.965  1.00 29.91           C  
ATOM    900  OG  SER A 108       3.665  30.962  86.917  1.00 32.55           O  
ATOM    901  N   THR A 109       4.394  34.768  89.338  1.00 26.61           N  
ATOM    902  CA  THR A 109       5.063  35.580  90.354  1.00 27.41           C  
ATOM    903  C   THR A 109       4.019  36.006  91.376  1.00 27.38           C  
ATOM    904  O   THR A 109       2.915  36.347  90.977  1.00 27.30           O  
ATOM    905  CB  THR A 109       5.688  36.828  89.719  1.00 27.36           C  
ATOM    906  OG1 THR A 109       6.667  36.431  88.754  1.00 30.06           O  
ATOM    907  CG2 THR A 109       6.346  37.714  90.760  1.00 27.34           C  
ATOM    908  N   PRO A 110       4.338  35.914  92.675  1.00 28.28           N  
ATOM    909  CA  PRO A 110       3.390  36.426  93.696  1.00 27.95           C  
ATOM    910  C   PRO A 110       3.009  37.888  93.508  1.00 27.29           C  
ATOM    911  O   PRO A 110       3.809  38.712  93.038  1.00 24.61           O  
ATOM    912  CB  PRO A 110       4.119  36.192  95.025  1.00 28.80           C  
ATOM    913  CG  PRO A 110       5.093  35.142  94.744  1.00 30.57           C  
ATOM    914  CD  PRO A 110       5.511  35.306  93.308  1.00 29.42           C  
ATOM    915  N   GLN A 111       1.795  38.220  93.967  1.00 25.94           N  
ATOM    916  CA  GLN A 111       1.251  39.551  93.738  1.00 25.57           C  
ATOM    917  C   GLN A 111       2.156  40.703  94.147  1.00 24.84           C  
ATOM    918  O   GLN A 111       2.369  41.643  93.352  1.00 25.37           O  
ATOM    919  CB  GLN A 111      -0.110  39.727  94.451  1.00 24.02           C  
ATOM    920  CG  GLN A 111      -0.725  41.070  94.170  1.00 25.39           C  
ATOM    921  CD  GLN A 111      -2.079  41.241  94.811  1.00 23.35           C  
ATOM    922  OE1 GLN A 111      -2.541  40.392  95.625  1.00 27.04           O  
ATOM    923  NE2 GLN A 111      -2.748  42.304  94.430  1.00 20.95           N  
ATOM    924  N   ARG A 112       2.620  40.694  95.388  1.00 26.36           N  
ATOM    925  CA  ARG A 112       3.329  41.875  95.879  1.00 26.57           C  
ATOM    926  C   ARG A 112       4.609  42.120  95.066  1.00 26.93           C  
ATOM    927  O   ARG A 112       4.873  43.241  94.603  1.00 25.42           O  
ATOM    928  CB  ARG A 112       3.607  41.776  97.379  1.00 27.54           C  
ATOM    929  CG  ARG A 112       4.215  43.013  97.905  1.00 28.98           C  
ATOM    930  CD  ARG A 112       3.974  43.130  99.374  1.00 31.68           C  
ATOM    931  NE  ARG A 112       4.587  42.008 100.087  1.00 31.36           N  
ATOM    932  CZ  ARG A 112       5.832  42.018 100.546  1.00 36.42           C  
ATOM    933  NH1 ARG A 112       6.618  43.073 100.363  1.00 36.27           N  
ATOM    934  NH2 ARG A 112       6.299  40.958 101.195  1.00 39.09           N  
ATOM    935  N   GLU A 113       5.359  41.043  94.838  1.00 27.96           N  
ATOM    936  CA  GLU A 113       6.596  41.093  94.042  1.00 29.73           C  
ATOM    937  C   GLU A 113       6.309  41.571  92.604  1.00 29.10           C  
ATOM    938  O   GLU A 113       6.997  42.464  92.073  1.00 27.83           O  
ATOM    939  CB  GLU A 113       7.248  39.708  94.066  1.00 30.57           C  
ATOM    940  CG  GLU A 113       8.553  39.599  93.312  1.00 35.87           C  
ATOM    941  CD  GLU A 113       9.096  38.147  93.193  1.00 42.16           C  
ATOM    942  OE1 GLU A 113       8.563  37.187  93.812  1.00 42.87           O  
ATOM    943  OE2 GLU A 113      10.097  37.997  92.459  1.00 46.58           O  
ATOM    944  N   ALA A 114       5.274  40.984  91.969  1.00 28.49           N  
ATOM    945  CA  ALA A 114       4.900  41.341  90.604  1.00 27.76           C  
ATOM    946  C   ALA A 114       4.474  42.776  90.442  1.00 27.66           C  
ATOM    947  O   ALA A 114       4.896  43.468  89.519  1.00 27.29           O  
ATOM    948  CB  ALA A 114       3.776  40.412  90.097  1.00 27.65           C  
ATOM    949  N   LEU A 115       3.643  43.278  91.362  1.00 27.00           N  
ATOM    950  CA  LEU A 115       3.169  44.662  91.255  1.00 27.56           C  
ATOM    951  C   LEU A 115       4.288  45.686  91.361  1.00 28.91           C  
ATOM    952  O   LEU A 115       4.225  46.723  90.716  1.00 29.63           O  
ATOM    953  CB  LEU A 115       2.073  44.938  92.302  1.00 26.97           C  
ATOM    954  CG  LEU A 115       0.728  44.264  92.021  1.00 26.51           C  
ATOM    955  CD1 LEU A 115      -0.227  44.416  93.237  1.00 24.10           C  
ATOM    956  CD2 LEU A 115       0.064  44.797  90.744  1.00 26.72           C  
ATOM    957  N   GLU A 116       5.314  45.400  92.152  1.00 30.57           N  
ATOM    958  CA  GLU A 116       6.423  46.330  92.334  1.00 32.28           C  
ATOM    959  C   GLU A 116       7.158  46.522  90.998  1.00 32.79           C  
ATOM    960  O   GLU A 116       7.471  47.654  90.580  1.00 32.84           O  
ATOM    961  CB  GLU A 116       7.355  45.807  93.425  1.00 32.95           C  
ATOM    962  CG  GLU A 116       8.349  46.857  93.946  1.00 34.82           C  
ATOM    963  CD  GLU A 116       8.981  46.492  95.282  0.10 33.83           C  
ATOM    964  OE1 GLU A 116       8.427  45.641  96.010  0.10 33.40           O  
ATOM    965  OE2 GLU A 116      10.041  47.069  95.607  0.10 33.35           O  
ATOM    966  N   ARG A 117       7.379  45.406  90.319  1.00 32.65           N  
ATOM    967  CA  ARG A 117       7.986  45.402  88.969  1.00 32.55           C  
ATOM    968  C   ARG A 117       7.142  46.160  87.969  1.00 31.79           C  
ATOM    969  O   ARG A 117       7.627  47.026  87.285  1.00 31.74           O  
ATOM    970  CB  ARG A 117       8.129  43.981  88.465  1.00 33.57           C  
ATOM    971  CG  ARG A 117       9.055  43.106  89.275  1.00 35.90           C  
ATOM    972  CD  ARG A 117       9.563  41.980  88.419  1.00 39.97           C  
ATOM    973  NE  ARG A 117      10.099  40.916  89.249  1.00 43.68           N  
ATOM    974  CZ  ARG A 117       9.981  39.619  88.998  1.00 44.17           C  
ATOM    975  NH1 ARG A 117       9.334  39.158  87.923  1.00 46.05           N  
ATOM    976  NH2 ARG A 117      10.517  38.762  89.853  1.00 46.05           N  
ATOM    977  N   LEU A 118       5.866  45.828  87.878  1.00 30.24           N  
ATOM    978  CA  LEU A 118       4.988  46.537  86.952  1.00 30.60           C  
ATOM    979  C   LEU A 118       4.911  48.028  87.245  1.00 31.47           C  
ATOM    980  O   LEU A 118       4.851  48.865  86.335  1.00 32.88           O  
ATOM    981  CB  LEU A 118       3.593  45.937  86.985  1.00 30.26           C  
ATOM    982  CG  LEU A 118       3.426  44.520  86.455  1.00 30.08           C  
ATOM    983  CD1 LEU A 118       2.048  44.025  86.880  1.00 31.85           C  
ATOM    984  CD2 LEU A 118       3.591  44.485  84.934  1.00 26.89           C  
ATOM    985  N   ARG A 119       4.834  48.368  88.525  1.00 32.40           N  
ATOM    986  CA  ARG A 119       4.766  49.774  88.926  1.00 32.77           C  
ATOM    987  C   ARG A 119       6.020  50.548  88.512  1.00 32.08           C  
ATOM    988  O   ARG A 119       5.919  51.649  87.974  1.00 30.99           O  
ATOM    989  CB  ARG A 119       4.520  49.892  90.431  1.00 33.54           C  
ATOM    990  CG  ARG A 119       4.002  51.268  90.841  1.00 35.61           C  
ATOM    991  CD  ARG A 119       3.398  51.232  92.246  1.00 38.45           C  
ATOM    992  NE  ARG A 119       2.876  52.535  92.699  1.00 40.44           N  
ATOM    993  CZ  ARG A 119       1.621  52.957  92.534  1.00 41.99           C  
ATOM    994  NH1 ARG A 119       0.731  52.203  91.902  1.00 43.39           N  
ATOM    995  NH2 ARG A 119       1.260  54.151  92.983  1.00 43.27           N  
ATOM    996  N   ARG A 120       7.192  49.968  88.724  1.00 31.78           N  
ATOM    997  CA  ARG A 120       8.471  50.602  88.362  1.00 32.55           C  
ATOM    998  C   ARG A 120       8.521  50.859  86.866  1.00 31.00           C  
ATOM    999  O   ARG A 120       9.090  51.869  86.430  1.00 31.45           O  
ATOM   1000  CB  ARG A 120       9.637  49.690  88.753  1.00 33.40           C  
ATOM   1001  CG  ARG A 120      10.976  50.351  89.030  1.00 38.64           C  
ATOM   1002  CD  ARG A 120      12.024  49.274  89.430  1.00 43.75           C  
ATOM   1003  NE  ARG A 120      12.050  48.890  90.860  1.00 48.22           N  
ATOM   1004  CZ  ARG A 120      11.889  47.648  91.352  1.00 52.40           C  
ATOM   1005  NH1 ARG A 120      11.647  46.592  90.565  1.00 52.85           N  
ATOM   1006  NH2 ARG A 120      11.962  47.451  92.674  1.00 54.65           N  
ATOM   1007  N   LEU A 121       7.897  49.969  86.084  1.00 29.41           N  
ATOM   1008  CA  LEU A 121       7.878  50.090  84.619  1.00 30.00           C  
ATOM   1009  C   LEU A 121       6.661  50.832  84.084  1.00 28.67           C  
ATOM   1010  O   LEU A 121       6.549  51.001  82.892  1.00 29.48           O  
ATOM   1011  CB  LEU A 121       7.977  48.714  83.963  1.00 30.18           C  
ATOM   1012  CG  LEU A 121       9.274  47.957  84.238  1.00 31.69           C  
ATOM   1013  CD1 LEU A 121       9.298  46.635  83.496  1.00 35.10           C  
ATOM   1014  CD2 LEU A 121      10.481  48.802  83.869  1.00 33.44           C  
ATOM   1015  N   ASP A 122       5.778  51.278  84.968  1.00 28.02           N  
ATOM   1016  CA  ASP A 122       4.532  51.950  84.589  1.00 28.60           C  
ATOM   1017  C   ASP A 122       3.680  51.173  83.566  1.00 28.58           C  
ATOM   1018  O   ASP A 122       3.138  51.754  82.611  1.00 27.60           O  
ATOM   1019  CB  ASP A 122       4.828  53.366  84.095  1.00 28.76           C  
ATOM   1020  CG  ASP A 122       3.589  54.209  83.972  1.00 29.98           C  
ATOM   1021  OD1 ASP A 122       2.651  54.024  84.780  1.00 31.01           O  
ATOM   1022  OD2 ASP A 122       3.538  55.051  83.048  1.00 34.07           O  
ATOM   1023  N   LEU A 123       3.559  49.864  83.785  1.00 27.45           N  
ATOM   1024  CA  LEU A 123       2.714  48.995  82.943  1.00 28.80           C  
ATOM   1025  C   LEU A 123       1.465  48.530  83.690  1.00 28.67           C  
ATOM   1026  O   LEU A 123       0.560  47.977  83.096  1.00 29.63           O  
ATOM   1027  CB  LEU A 123       3.507  47.781  82.465  1.00 28.73           C  
ATOM   1028  CG  LEU A 123       4.766  48.042  81.641  1.00 30.37           C  
ATOM   1029  CD1 LEU A 123       5.597  46.769  81.438  1.00 32.41           C  
ATOM   1030  CD2 LEU A 123       4.380  48.634  80.306  1.00 29.27           C  
ATOM   1031  N   GLU A 124       1.401  48.811  84.994  1.00 27.99           N  
ATOM   1032  CA  GLU A 124       0.288  48.357  85.810  0.50 28.34           C  
ATOM   1034  C   GLU A 124      -1.039  48.986  85.394  1.00 27.53           C  
ATOM   1035  O   GLU A 124      -2.084  48.353  85.428  1.00 27.72           O  
ATOM   1036  CB  GLU A 124       0.587  48.712  87.253  0.50 28.72           C  
ATOM   1038  CG  GLU A 124       0.150  47.712  88.246  0.50 29.13           C  
ATOM   1040  CD  GLU A 124       0.632  48.130  89.596  0.50 29.63           C  
ATOM   1042  OE1 GLU A 124       1.838  47.937  89.855  0.50 29.85           O  
ATOM   1044  OE2 GLU A 124      -0.175  48.689  90.369  0.50 31.97           O  
ATOM   1046  N   LYS A 125      -0.983  50.223  84.952  1.00 26.90           N  
ATOM   1047  CA  LYS A 125      -2.167  50.975  84.629  1.00 27.19           C  
ATOM   1048  C   LYS A 125      -3.038  50.447  83.484  1.00 28.05           C  
ATOM   1049  O   LYS A 125      -4.236  50.783  83.396  1.00 29.05           O  
ATOM   1050  CB  LYS A 125      -1.761  52.421  84.327  1.00 27.52           C  
ATOM   1051  CG  LYS A 125      -0.811  52.559  83.148  1.00 27.31           C  
ATOM   1052  CD  LYS A 125      -0.369  53.997  82.948  1.00 27.68           C  
ATOM   1053  CE  LYS A 125       0.332  54.146  81.619  1.00 29.48           C  
ATOM   1054  NZ  LYS A 125       1.094  55.434  81.543  1.00 28.91           N  
ATOM   1055  N   TYR A 126      -2.461  49.659  82.587  1.00 27.44           N  
ATOM   1056  CA  TYR A 126      -3.237  49.148  81.450  1.00 27.20           C  
ATOM   1057  C   TYR A 126      -4.254  48.048  81.761  1.00 27.61           C  
ATOM   1058  O   TYR A 126      -5.215  47.836  81.003  1.00 27.96           O  
ATOM   1059  CB  TYR A 126      -2.286  48.685  80.344  1.00 27.99           C  
ATOM   1060  CG  TYR A 126      -1.355  49.743  79.894  1.00 27.34           C  
ATOM   1061  CD1 TYR A 126      -1.800  50.760  79.068  1.00 26.65           C  
ATOM   1062  CD2 TYR A 126      -0.032  49.774  80.312  1.00 27.45           C  
ATOM   1063  CE1 TYR A 126      -0.949  51.756  78.653  1.00 29.48           C  
ATOM   1064  CE2 TYR A 126       0.834  50.784  79.893  1.00 27.18           C  
ATOM   1065  CZ  TYR A 126       0.364  51.760  79.059  1.00 29.31           C  
ATOM   1066  OH  TYR A 126       1.187  52.785  78.636  1.00 30.10           O  
ATOM   1067  N   PHE A 127      -4.002  47.276  82.809  1.00 25.91           N  
ATOM   1068  CA  PHE A 127      -4.740  46.046  83.027  1.00 26.29           C  
ATOM   1069  C   PHE A 127      -6.049  46.229  83.752  1.00 27.50           C  
ATOM   1070  O   PHE A 127      -6.150  46.968  84.739  1.00 26.67           O  
ATOM   1071  CB  PHE A 127      -3.842  45.030  83.718  1.00 25.72           C  
ATOM   1072  CG  PHE A 127      -2.687  44.630  82.873  1.00 24.96           C  
ATOM   1073  CD1 PHE A 127      -2.864  43.703  81.869  1.00 25.96           C  
ATOM   1074  CD2 PHE A 127      -1.462  45.241  82.997  1.00 23.49           C  
ATOM   1075  CE1 PHE A 127      -1.820  43.345  81.035  1.00 26.95           C  
ATOM   1076  CE2 PHE A 127      -0.418  44.895  82.211  1.00 26.06           C  
ATOM   1077  CZ  PHE A 127      -0.600  43.949  81.177  1.00 26.92           C  
ATOM   1078  N   ASP A 128      -7.045  45.525  83.240  1.00 27.32           N  
ATOM   1079  CA  ASP A 128      -8.354  45.402  83.870  1.00 27.36           C  
ATOM   1080  C   ASP A 128      -8.425  44.288  84.903  1.00 27.52           C  
ATOM   1081  O   ASP A 128      -9.118  44.428  85.945  1.00 27.44           O  
ATOM   1082  CB  ASP A 128      -9.356  45.126  82.780  1.00 27.66           C  
ATOM   1083  CG  ASP A 128      -9.379  46.249  81.741  1.00 29.92           C  
ATOM   1084  OD1 ASP A 128      -9.689  47.389  82.131  1.00 30.61           O  
ATOM   1085  OD2 ASP A 128      -9.017  46.013  80.556  1.00 30.14           O  
ATOM   1086  N   VAL A 129      -7.761  43.193  84.589  1.00 26.75           N  
ATOM   1087  CA  VAL A 129      -7.677  41.999  85.432  1.00 26.86           C  
ATOM   1088  C   VAL A 129      -6.216  41.606  85.575  1.00 26.97           C  
ATOM   1089  O   VAL A 129      -5.466  41.575  84.594  1.00 26.32           O  
ATOM   1090  CB  VAL A 129      -8.497  40.858  84.811  1.00 26.88           C  
ATOM   1091  CG1 VAL A 129      -8.135  39.485  85.393  1.00 27.27           C  
ATOM   1092  CG2 VAL A 129      -9.975  41.138  84.894  1.00 28.46           C  
HETATM 1093  N   MSE A 130      -5.814  41.210  86.779  1.00 25.65           N  
HETATM 1094  CA  MSE A 130      -4.474  40.668  86.977  1.00 25.77           C  
HETATM 1095  C   MSE A 130      -4.585  39.533  87.971  1.00 27.12           C  
HETATM 1096  O   MSE A 130      -5.213  39.706  89.044  1.00 26.71           O  
HETATM 1097  CB  MSE A 130      -3.491  41.742  87.483  1.00 25.11           C  
HETATM 1098  CG  MSE A 130      -3.399  43.007  86.631  1.00 25.57           C  
HETATM 1099 SE   MSE A 130      -1.928  44.189  87.209  1.00 31.07          SE  
HETATM 1100  CE  MSE A 130      -2.754  44.887  88.802  1.00 29.14           C  
ATOM   1101  N   VAL A 131      -3.977  38.403  87.637  1.00 25.23           N  
ATOM   1102  CA  VAL A 131      -3.968  37.174  88.479  1.00 26.71           C  
ATOM   1103  C   VAL A 131      -2.525  36.738  88.706  1.00 26.60           C  
ATOM   1104  O   VAL A 131      -1.688  36.759  87.752  1.00 27.59           O  
ATOM   1105  CB  VAL A 131      -4.786  36.030  87.829  1.00 26.49           C  
ATOM   1106  CG1 VAL A 131      -4.698  34.759  88.636  1.00 29.38           C  
ATOM   1107  CG2 VAL A 131      -6.271  36.403  87.640  1.00 27.51           C  
ATOM   1108  N   PHE A 132      -2.222  36.370  89.959  1.00 25.48           N  
ATOM   1109  CA  PHE A 132      -0.873  36.179  90.424  1.00 25.28           C  
ATOM   1110  C   PHE A 132      -0.725  34.765  90.981  1.00 25.69           C  
ATOM   1111  O   PHE A 132      -1.724  34.104  91.270  1.00 27.71           O  
ATOM   1112  CB  PHE A 132      -0.523  37.256  91.484  1.00 25.77           C  
ATOM   1113  CG  PHE A 132      -0.650  38.665  90.945  1.00 25.02           C  
ATOM   1114  CD1 PHE A 132       0.364  39.229  90.215  1.00 28.52           C  
ATOM   1115  CD2 PHE A 132      -1.793  39.376  91.143  1.00 25.49           C  
ATOM   1116  CE1 PHE A 132       0.242  40.517  89.687  1.00 27.77           C  
ATOM   1117  CE2 PHE A 132      -1.929  40.674  90.598  1.00 25.27           C  
ATOM   1118  CZ  PHE A 132      -0.897  41.219  89.893  1.00 26.14           C  
ATOM   1119  N   GLY A 133       0.508  34.312  91.066  1.00 27.24           N  
ATOM   1120  CA  GLY A 133       0.786  32.904  91.368  1.00 28.62           C  
ATOM   1121  C   GLY A 133       0.352  32.475  92.734  1.00 29.07           C  
ATOM   1122  O   GLY A 133       0.089  31.282  92.982  1.00 30.34           O  
ATOM   1123  N   ASP A 134       0.255  33.445  93.648  1.00 28.51           N  
ATOM   1124  CA  ASP A 134      -0.173  33.147  95.015  1.00 28.92           C  
ATOM   1125  C   ASP A 134      -1.678  33.203  95.206  1.00 28.71           C  
ATOM   1126  O   ASP A 134      -2.172  33.092  96.344  1.00 29.26           O  
ATOM   1127  CB  ASP A 134       0.591  34.027  96.032  1.00 28.29           C  
ATOM   1128  CG  ASP A 134       0.427  35.541  95.824  1.00 30.56           C  
ATOM   1129  OD1 ASP A 134       0.073  36.020  94.734  1.00 26.06           O  
ATOM   1130  OD2 ASP A 134       0.703  36.253  96.843  1.00 32.61           O  
ATOM   1131  N   GLN A 135      -2.401  33.334  94.087  1.00 27.20           N  
ATOM   1132  CA  GLN A 135      -3.849  33.352  94.059  1.00 26.77           C  
ATOM   1133  C   GLN A 135      -4.504  32.066  93.563  1.00 28.29           C  
ATOM   1134  O   GLN A 135      -5.723  31.989  93.498  1.00 30.58           O  
ATOM   1135  CB  GLN A 135      -4.316  34.579  93.277  1.00 26.64           C  
ATOM   1136  CG  GLN A 135      -3.806  35.882  93.877  1.00 25.88           C  
ATOM   1137  CD  GLN A 135      -4.302  37.084  93.117  1.00 28.42           C  
ATOM   1138  OE1 GLN A 135      -4.489  37.015  91.899  1.00 28.85           O  
ATOM   1139  NE2 GLN A 135      -4.496  38.197  93.825  1.00 28.90           N  
ATOM   1140  N   VAL A 136      -3.688  31.052  93.269  1.00 29.16           N  
ATOM   1141  CA  VAL A 136      -4.175  29.741  92.886  1.00 29.41           C  
ATOM   1142  C   VAL A 136      -3.521  28.663  93.737  1.00 29.23           C  
ATOM   1143  O   VAL A 136      -2.432  28.868  94.287  1.00 30.27           O  
ATOM   1144  CB  VAL A 136      -3.868  29.485  91.395  1.00 28.23           C  
ATOM   1145  CG1 VAL A 136      -4.612  30.558  90.519  1.00 29.99           C  
ATOM   1146  CG2 VAL A 136      -2.392  29.520  91.157  1.00 29.57           C  
ATOM   1147  N   LYS A 137      -4.210  27.541  93.863  1.00 29.94           N  
ATOM   1148  CA  LYS A 137      -3.693  26.394  94.631  1.00 30.80           C  
ATOM   1149  C   LYS A 137      -2.544  25.711  93.905  1.00 31.13           C  
ATOM   1150  O   LYS A 137      -1.480  25.429  94.494  1.00 31.45           O  
ATOM   1151  CB  LYS A 137      -4.831  25.409  94.875  1.00 31.24           C  
ATOM   1152  CG  LYS A 137      -4.437  24.215  95.757  1.00 35.07           C  
ATOM   1153  CD  LYS A 137      -5.618  23.347  96.075  1.00 39.13           C  
ATOM   1154  CE  LYS A 137      -5.184  22.074  96.807  1.00 42.00           C  
ATOM   1155  NZ  LYS A 137      -6.200  21.009  96.552  1.00 44.99           N  
ATOM   1156  N   ASN A 138      -2.787  25.404  92.629  1.00 29.59           N  
ATOM   1157  CA  ASN A 138      -1.831  24.721  91.761  1.00 30.08           C  
ATOM   1158  C   ASN A 138      -1.432  25.598  90.598  1.00 29.94           C  
ATOM   1159  O   ASN A 138      -2.304  26.118  89.890  1.00 29.07           O  
ATOM   1160  CB  ASN A 138      -2.458  23.444  91.222  1.00 30.56           C  
ATOM   1161  CG  ASN A 138      -2.831  22.480  92.324  1.00 32.80           C  
ATOM   1162  OD1 ASN A 138      -3.973  22.050  92.426  1.00 39.41           O  
ATOM   1163  ND2 ASN A 138      -1.868  22.157  93.162  1.00 31.52           N  
ATOM   1164  N   GLY A 139      -0.123  25.738  90.395  1.00 30.07           N  
ATOM   1165  CA  GLY A 139       0.416  26.633  89.369  1.00 30.86           C  
ATOM   1166  C   GLY A 139       0.509  25.957  88.000  1.00 29.95           C  
ATOM   1167  O   GLY A 139       0.128  24.801  87.836  1.00 30.12           O  
ATOM   1168  N   LYS A 140       1.022  26.703  87.033  1.00 31.64           N  
ATOM   1169  CA  LYS A 140       1.237  26.187  85.664  1.00 30.63           C  
ATOM   1170  C   LYS A 140       2.033  24.892  85.803  1.00 31.01           C  
ATOM   1171  O   LYS A 140       2.962  24.830  86.649  1.00 32.92           O  
ATOM   1172  CB  LYS A 140       2.023  27.186  84.818  1.00 31.21           C  
ATOM   1173  CG  LYS A 140       1.352  28.466  84.609  1.00 31.03           C  
ATOM   1174  CD  LYS A 140       2.302  29.487  84.038  1.00 32.57           C  
ATOM   1175  CE  LYS A 140       1.632  30.789  83.916  1.00 35.10           C  
ATOM   1176  NZ  LYS A 140       2.532  31.831  83.422  1.00 36.22           N  
ATOM   1177  N   PRO A 141       1.714  23.862  85.009  1.00 29.92           N  
ATOM   1178  CA  PRO A 141       0.795  23.828  83.869  1.00 29.25           C  
ATOM   1179  C   PRO A 141      -0.647  23.549  84.198  1.00 29.16           C  
ATOM   1180  O   PRO A 141      -1.455  23.356  83.289  1.00 28.34           O  
ATOM   1181  CB  PRO A 141       1.386  22.713  83.000  1.00 28.97           C  
ATOM   1182  CG  PRO A 141       1.876  21.709  84.017  1.00 30.12           C  
ATOM   1183  CD  PRO A 141       2.384  22.550  85.173  1.00 31.36           C  
ATOM   1184  N   ASP A 142      -1.015  23.576  85.484  1.00 28.05           N  
ATOM   1185  CA  ASP A 142      -2.423  23.408  85.849  1.00 27.24           C  
ATOM   1186  C   ASP A 142      -3.210  24.588  85.237  1.00 26.80           C  
ATOM   1187  O   ASP A 142      -2.709  25.728  85.229  1.00 25.65           O  
ATOM   1188  CB  ASP A 142      -2.593  23.357  87.365  1.00 28.48           C  
ATOM   1189  CG  ASP A 142      -3.988  22.952  87.799  1.00 29.68           C  
ATOM   1190  OD1 ASP A 142      -4.953  23.681  87.549  1.00 26.53           O  
ATOM   1191  OD2 ASP A 142      -4.109  21.903  88.470  1.00 31.61           O  
ATOM   1192  N   PRO A 143      -4.410  24.331  84.666  1.00 26.65           N  
ATOM   1193  CA  PRO A 143      -5.160  25.459  84.084  1.00 26.36           C  
ATOM   1194  C   PRO A 143      -5.776  26.481  85.083  1.00 26.11           C  
ATOM   1195  O   PRO A 143      -6.317  27.521  84.636  1.00 26.49           O  
ATOM   1196  CB  PRO A 143      -6.309  24.762  83.351  1.00 26.72           C  
ATOM   1197  CG  PRO A 143      -6.424  23.461  84.036  1.00 26.86           C  
ATOM   1198  CD  PRO A 143      -5.094  23.060  84.427  1.00 27.55           C  
ATOM   1199  N   GLU A 144      -5.684  26.200  86.379  1.00 26.26           N  
ATOM   1200  CA  GLU A 144      -6.283  27.057  87.419  1.00 26.37           C  
ATOM   1201  C   GLU A 144      -6.077  28.578  87.188  1.00 26.35           C  
ATOM   1202  O   GLU A 144      -7.034  29.356  87.239  1.00 26.13           O  
ATOM   1203  CB  GLU A 144      -5.776  26.665  88.802  1.00 27.98           C  
ATOM   1204  CG  GLU A 144      -6.684  27.088  89.901  1.00 29.45           C  
ATOM   1205  CD  GLU A 144      -6.172  26.752  91.293  1.00 30.34           C  
ATOM   1206  OE1 GLU A 144      -5.393  25.780  91.444  1.00 28.76           O  
ATOM   1207  OE2 GLU A 144      -6.584  27.469  92.256  1.00 33.37           O  
ATOM   1208  N   ILE A 145      -4.836  28.986  86.956  1.00 25.97           N  
ATOM   1209  CA  ILE A 145      -4.538  30.401  86.778  1.00 25.77           C  
ATOM   1210  C   ILE A 145      -5.305  31.048  85.624  1.00 27.04           C  
ATOM   1211  O   ILE A 145      -5.813  32.153  85.750  1.00 26.95           O  
ATOM   1212  CB  ILE A 145      -3.015  30.659  86.677  1.00 26.20           C  
ATOM   1213  CG1 ILE A 145      -2.711  32.157  86.932  1.00 30.00           C  
ATOM   1214  CG2 ILE A 145      -2.411  30.064  85.373  1.00 26.06           C  
ATOM   1215  CD1 ILE A 145      -1.280  32.462  87.096  1.00 33.02           C  
ATOM   1216  N   TYR A 146      -5.371  30.360  84.466  1.00 26.84           N  
ATOM   1217  CA  TYR A 146      -6.117  30.902  83.321  1.00 26.07           C  
ATOM   1218  C   TYR A 146      -7.617  30.822  83.529  1.00 25.61           C  
ATOM   1219  O   TYR A 146      -8.331  31.692  83.089  1.00 24.98           O  
ATOM   1220  CB  TYR A 146      -5.679  30.238  82.012  1.00 26.24           C  
ATOM   1221  CG  TYR A 146      -4.373  30.835  81.571  1.00 26.43           C  
ATOM   1222  CD1 TYR A 146      -4.342  32.104  80.990  1.00 30.06           C  
ATOM   1223  CD2 TYR A 146      -3.171  30.174  81.750  1.00 27.65           C  
ATOM   1224  CE1 TYR A 146      -3.167  32.679  80.618  1.00 31.55           C  
ATOM   1225  CE2 TYR A 146      -1.974  30.750  81.383  1.00 26.98           C  
ATOM   1226  CZ  TYR A 146      -1.988  32.019  80.814  1.00 30.37           C  
ATOM   1227  OH  TYR A 146      -0.827  32.650  80.412  1.00 32.72           O  
ATOM   1228  N   LEU A 147      -8.095  29.773  84.197  1.00 25.62           N  
ATOM   1229  CA  LEU A 147      -9.511  29.681  84.579  1.00 26.19           C  
ATOM   1230  C   LEU A 147      -9.929  30.875  85.452  1.00 26.89           C  
ATOM   1231  O   LEU A 147     -11.019  31.473  85.275  1.00 29.23           O  
ATOM   1232  CB  LEU A 147      -9.760  28.311  85.235  1.00 25.82           C  
ATOM   1233  CG  LEU A 147      -9.695  27.129  84.263  1.00 25.04           C  
ATOM   1234  CD1 LEU A 147      -9.607  25.788  85.077  1.00 26.85           C  
ATOM   1235  CD2 LEU A 147     -10.844  27.078  83.225  1.00 26.11           C  
ATOM   1236  N   LEU A 148      -9.046  31.285  86.355  1.00 27.61           N  
ATOM   1237  CA  LEU A 148      -9.339  32.400  87.268  1.00 27.03           C  
ATOM   1238  C   LEU A 148      -9.312  33.718  86.468  1.00 26.82           C  
ATOM   1239  O   LEU A 148     -10.157  34.589  86.684  1.00 27.55           O  
ATOM   1240  CB  LEU A 148      -8.324  32.416  88.407  1.00 26.13           C  
ATOM   1241  CG  LEU A 148      -8.525  33.438  89.554  1.00 27.49           C  
ATOM   1242  CD1 LEU A 148      -9.969  33.349  90.063  1.00 28.16           C  
ATOM   1243  CD2 LEU A 148      -7.449  33.288  90.669  1.00 28.93           C  
ATOM   1244  N   VAL A 149      -8.363  33.845  85.532  1.00 26.39           N  
ATOM   1245  CA  VAL A 149      -8.337  35.027  84.634  1.00 26.59           C  
ATOM   1246  C   VAL A 149      -9.664  35.157  83.870  1.00 27.47           C  
ATOM   1247  O   VAL A 149     -10.264  36.247  83.812  1.00 27.09           O  
ATOM   1248  CB  VAL A 149      -7.158  34.989  83.649  1.00 27.30           C  
ATOM   1249  CG1 VAL A 149      -7.244  36.185  82.621  1.00 28.82           C  
ATOM   1250  CG2 VAL A 149      -5.856  35.086  84.434  1.00 29.33           C  
ATOM   1251  N   LEU A 150     -10.104  34.040  83.284  1.00 27.69           N  
ATOM   1252  CA  LEU A 150     -11.346  33.969  82.547  1.00 27.90           C  
ATOM   1253  C   LEU A 150     -12.535  34.321  83.423  1.00 28.33           C  
ATOM   1254  O   LEU A 150     -13.418  35.059  82.986  1.00 27.39           O  
ATOM   1255  CB  LEU A 150     -11.527  32.603  81.919  1.00 28.71           C  
ATOM   1256  CG  LEU A 150     -10.532  32.271  80.779  1.00 28.57           C  
ATOM   1257  CD1 LEU A 150     -10.642  30.788  80.453  1.00 30.06           C  
ATOM   1258  CD2 LEU A 150     -10.837  33.157  79.561  1.00 28.19           C  
ATOM   1259  N   GLU A 151     -12.527  33.785  84.637  1.00 28.86           N  
ATOM   1260  CA  GLU A 151     -13.575  34.083  85.631  1.00 29.23           C  
ATOM   1261  C   GLU A 151     -13.649  35.559  85.966  1.00 28.90           C  
ATOM   1262  O   GLU A 151     -14.736  36.143  85.966  1.00 29.40           O  
ATOM   1263  CB  GLU A 151     -13.352  33.258  86.894  1.00 29.39           C  
ATOM   1264  CG  GLU A 151     -14.535  33.386  87.885  1.00 33.42           C  
ATOM   1265  CD  GLU A 151     -14.462  32.416  89.041  1.00 39.59           C  
ATOM   1266  OE1 GLU A 151     -13.353  32.028  89.456  1.00 40.91           O  
ATOM   1267  OE2 GLU A 151     -15.538  32.086  89.580  1.00 46.29           O  
ATOM   1268  N   ARG A 152     -12.507  36.154  86.293  1.00 29.08           N  
ATOM   1269  CA  ARG A 152     -12.443  37.567  86.616  1.00 28.89           C  
ATOM   1270  C   ARG A 152     -12.752  38.503  85.438  1.00 29.21           C  
ATOM   1271  O   ARG A 152     -13.328  39.567  85.622  1.00 29.86           O  
ATOM   1272  CB  ARG A 152     -11.100  37.935  87.214  1.00 29.21           C  
ATOM   1273  CG  ARG A 152     -10.830  37.303  88.615  1.00 31.55           C  
ATOM   1274  CD  ARG A 152      -9.511  37.845  89.238  1.00 36.33           C  
ATOM   1275  NE  ARG A 152      -9.267  37.181  90.518  1.00 36.49           N  
ATOM   1276  CZ  ARG A 152      -8.137  37.192  91.239  1.00 38.74           C  
ATOM   1277  NH1 ARG A 152      -7.066  37.902  90.896  1.00 37.30           N  
ATOM   1278  NH2 ARG A 152      -8.113  36.499  92.375  1.00 41.12           N  
ATOM   1279  N   LEU A 153     -12.376  38.103  84.230  1.00 29.13           N  
ATOM   1280  CA  LEU A 153     -12.769  38.839  83.021  1.00 29.33           C  
ATOM   1281  C   LEU A 153     -14.273  38.707  82.637  1.00 30.32           C  
ATOM   1282  O   LEU A 153     -14.834  39.574  81.931  1.00 30.97           O  
ATOM   1283  CB  LEU A 153     -11.953  38.286  81.857  1.00 28.14           C  
ATOM   1284  CG  LEU A 153     -10.495  38.674  81.776  1.00 28.16           C  
ATOM   1285  CD1 LEU A 153      -9.802  37.770  80.755  1.00 28.07           C  
ATOM   1286  CD2 LEU A 153     -10.370  40.175  81.333  1.00 27.33           C  
ATOM   1287  N   ASN A 154     -14.868  37.606  83.082  1.00 30.45           N  
ATOM   1288  CA  ASN A 154     -16.173  37.151  82.663  1.00 31.27           C  
ATOM   1289  C   ASN A 154     -16.294  37.018  81.127  1.00 31.33           C  
ATOM   1290  O   ASN A 154     -17.184  37.610  80.473  1.00 30.92           O  
ATOM   1291  CB  ASN A 154     -17.253  38.050  83.295  1.00 32.91           C  
ATOM   1292  CG  ASN A 154     -18.647  37.550  83.048  1.00 33.56           C  
ATOM   1293  OD1 ASN A 154     -18.889  36.345  82.965  1.00 36.18           O  
ATOM   1294  ND2 ASN A 154     -19.589  38.484  82.954  1.00 38.63           N  
ATOM   1295  N   VAL A 155     -15.340  36.270  80.565  1.00 30.93           N  
ATOM   1296  CA  VAL A 155     -15.267  35.991  79.123  1.00 31.47           C  
ATOM   1297  C   VAL A 155     -15.015  34.506  78.831  1.00 31.02           C  
ATOM   1298  O   VAL A 155     -14.383  33.799  79.611  1.00 32.03           O  
ATOM   1299  CB  VAL A 155     -14.183  36.833  78.423  1.00 32.12           C  
ATOM   1300  CG1 VAL A 155     -14.385  38.320  78.696  1.00 30.48           C  
ATOM   1301  CG2 VAL A 155     -12.816  36.363  78.855  1.00 33.93           C  
ATOM   1302  N   VAL A 156     -15.506  34.071  77.675  1.00 31.02           N  
ATOM   1303  CA  VAL A 156     -15.360  32.678  77.228  1.00 30.05           C  
ATOM   1304  C   VAL A 156     -13.965  32.498  76.603  1.00 29.72           C  
ATOM   1305  O   VAL A 156     -13.456  33.399  75.983  1.00 28.78           O  
ATOM   1306  CB  VAL A 156     -16.445  32.327  76.174  1.00 30.24           C  
ATOM   1307  CG1 VAL A 156     -17.844  32.532  76.777  1.00 31.59           C  
ATOM   1308  CG2 VAL A 156     -16.316  33.170  74.962  1.00 29.51           C  
ATOM   1309  N   PRO A 157     -13.366  31.322  76.757  1.00 30.22           N  
ATOM   1310  CA  PRO A 157     -12.007  31.161  76.260  1.00 30.26           C  
ATOM   1311  C   PRO A 157     -11.840  31.308  74.734  1.00 30.74           C  
ATOM   1312  O   PRO A 157     -10.760  31.683  74.273  1.00 29.69           O  
ATOM   1313  CB  PRO A 157     -11.615  29.761  76.740  1.00 31.55           C  
ATOM   1314  CG  PRO A 157     -12.847  29.088  77.069  1.00 31.35           C  
ATOM   1315  CD  PRO A 157     -13.879  30.100  77.383  1.00 30.41           C  
ATOM   1316  N   GLU A 158     -12.888  31.047  73.960  1.00 30.68           N  
ATOM   1317  CA  GLU A 158     -12.782  31.166  72.514  1.00 31.94           C  
ATOM   1318  C   GLU A 158     -12.739  32.626  72.043  1.00 31.41           C  
ATOM   1319  O   GLU A 158     -12.569  32.851  70.844  1.00 31.89           O  
ATOM   1320  CB  GLU A 158     -13.926  30.434  71.786  1.00 32.63           C  
ATOM   1321  CG  GLU A 158     -15.303  30.954  72.118  1.00 36.27           C  
ATOM   1322  CD  GLU A 158     -15.949  30.220  73.282  1.00 40.08           C  
ATOM   1323  OE1 GLU A 158     -15.227  29.674  74.153  1.00 38.82           O  
ATOM   1324  OE2 GLU A 158     -17.198  30.184  73.325  1.00 43.23           O  
ATOM   1325  N   LYS A 159     -12.947  33.572  72.962  1.00 30.54           N  
ATOM   1326  CA  LYS A 159     -12.909  35.018  72.661  1.00 30.94           C  
ATOM   1327  C   LYS A 159     -11.720  35.754  73.330  1.00 30.11           C  
ATOM   1328  O   LYS A 159     -11.750  36.982  73.477  1.00 31.35           O  
ATOM   1329  CB  LYS A 159     -14.226  35.681  73.018  1.00 32.39           C  
ATOM   1330  CG  LYS A 159     -15.392  35.260  72.110  1.00 35.02           C  
ATOM   1331  CD  LYS A 159     -16.697  35.877  72.618  1.00 39.54           C  
ATOM   1332  CE  LYS A 159     -17.865  35.653  71.687  1.00 43.35           C  
ATOM   1333  NZ  LYS A 159     -18.968  36.623  72.056  1.00 45.32           N  
ATOM   1334  N   VAL A 160     -10.675  35.005  73.679  1.00 29.54           N  
ATOM   1335  CA  VAL A 160      -9.441  35.597  74.225  1.00 28.33           C  
ATOM   1336  C   VAL A 160      -8.237  35.165  73.381  1.00 28.06           C  
ATOM   1337  O   VAL A 160      -8.221  34.107  72.738  1.00 28.13           O  
ATOM   1338  CB  VAL A 160      -9.201  35.261  75.705  1.00 28.69           C  
ATOM   1339  CG1 VAL A 160     -10.539  35.467  76.508  1.00 27.40           C  
ATOM   1340  CG2 VAL A 160      -8.693  33.854  75.900  1.00 29.15           C  
ATOM   1341  N   VAL A 161      -7.224  35.994  73.443  1.00 25.70           N  
ATOM   1342  CA  VAL A 161      -5.919  35.697  72.862  1.00 25.98           C  
ATOM   1343  C   VAL A 161      -4.931  35.747  74.022  1.00 25.52           C  
ATOM   1344  O   VAL A 161      -5.055  36.595  74.904  1.00 26.46           O  
ATOM   1345  CB  VAL A 161      -5.538  36.754  71.819  1.00 26.49           C  
ATOM   1346  CG1 VAL A 161      -4.121  36.508  71.300  1.00 26.96           C  
ATOM   1347  CG2 VAL A 161      -6.518  36.751  70.661  1.00 28.98           C  
ATOM   1348  N   VAL A 162      -4.000  34.800  74.063  1.00 25.38           N  
ATOM   1349  CA  VAL A 162      -2.999  34.730  75.124  1.00 24.84           C  
ATOM   1350  C   VAL A 162      -1.601  34.848  74.519  1.00 25.24           C  
ATOM   1351  O   VAL A 162      -1.339  34.229  73.481  1.00 25.95           O  
ATOM   1352  CB  VAL A 162      -3.077  33.366  75.869  1.00 25.09           C  
ATOM   1353  CG1 VAL A 162      -1.830  33.170  76.833  1.00 27.18           C  
ATOM   1354  CG2 VAL A 162      -4.388  33.212  76.662  1.00 25.68           C  
ATOM   1355  N   PHE A 163      -0.724  35.577  75.191  1.00 25.11           N  
ATOM   1356  CA  PHE A 163       0.708  35.668  74.862  1.00 24.87           C  
ATOM   1357  C   PHE A 163       1.503  35.037  76.013  1.00 25.27           C  
ATOM   1358  O   PHE A 163       1.541  35.568  77.159  1.00 25.19           O  
ATOM   1359  CB  PHE A 163       1.134  37.103  74.590  1.00 25.39           C  
ATOM   1360  CG  PHE A 163       0.521  37.648  73.356  1.00 25.58           C  
ATOM   1361  CD1 PHE A 163       1.119  37.422  72.118  1.00 24.95           C  
ATOM   1362  CD2 PHE A 163      -0.706  38.292  73.397  1.00 27.50           C  
ATOM   1363  CE1 PHE A 163       0.535  37.880  70.975  1.00 24.80           C  
ATOM   1364  CE2 PHE A 163      -1.313  38.751  72.230  1.00 25.12           C  
ATOM   1365  CZ  PHE A 163      -0.694  38.539  71.018  1.00 26.36           C  
ATOM   1366  N   GLU A 164       2.110  33.898  75.707  1.00 26.82           N  
ATOM   1367  CA  GLU A 164       2.770  33.066  76.685  1.00 26.76           C  
ATOM   1368  C   GLU A 164       4.223  32.814  76.274  1.00 28.01           C  
ATOM   1369  O   GLU A 164       4.570  32.914  75.132  1.00 30.08           O  
ATOM   1370  CB  GLU A 164       2.027  31.733  76.875  1.00 27.75           C  
ATOM   1371  CG  GLU A 164       1.251  31.635  78.175  1.00 28.45           C  
ATOM   1372  CD  GLU A 164       2.121  31.625  79.445  1.00 28.45           C  
ATOM   1373  OE1 GLU A 164       1.553  31.663  80.552  1.00 29.98           O  
ATOM   1374  OE2 GLU A 164       3.347  31.619  79.366  1.00 28.17           O  
ATOM   1375  N   ASP A 165       5.085  32.435  77.196  1.00 28.78           N  
ATOM   1376  CA  ASP A 165       6.507  32.321  76.888  0.50 28.62           C  
ATOM   1378  C   ASP A 165       7.117  31.038  77.453  1.00 28.72           C  
ATOM   1379  O   ASP A 165       8.323  30.809  77.319  1.00 29.10           O  
ATOM   1380  CB  ASP A 165       7.261  33.551  77.403  0.50 30.01           C  
ATOM   1382  CG  ASP A 165       7.754  33.374  78.817  0.50 30.48           C  
ATOM   1384  OD1 ASP A 165       6.923  32.948  79.638  0.50 32.17           O  
ATOM   1386  OD2 ASP A 165       8.977  33.588  79.090  0.50 34.88           O  
ATOM   1388  N   SER A 166       6.298  30.195  78.069  1.00 27.67           N  
ATOM   1389  CA  SER A 166       6.821  28.919  78.560  1.00 28.79           C  
ATOM   1390  C   SER A 166       5.914  27.758  78.163  1.00 29.00           C  
ATOM   1391  O   SER A 166       4.701  27.943  77.987  1.00 27.88           O  
ATOM   1392  CB  SER A 166       6.950  28.969  80.088  1.00 28.73           C  
ATOM   1393  OG  SER A 166       5.700  28.841  80.728  1.00 30.52           O  
ATOM   1394  N   LYS A 167       6.518  26.581  78.038  1.00 28.90           N  
ATOM   1395  CA  LYS A 167       5.801  25.330  77.796  1.00 29.21           C  
ATOM   1396  C   LYS A 167       4.667  25.167  78.803  1.00 27.54           C  
ATOM   1397  O   LYS A 167       3.520  24.907  78.425  1.00 26.14           O  
ATOM   1398  CB  LYS A 167       6.763  24.145  77.879  1.00 29.07           C  
ATOM   1399  CG  LYS A 167       6.136  22.769  77.806  1.00 32.51           C  
ATOM   1400  CD  LYS A 167       7.234  21.702  77.781  1.00 35.68           C  
ATOM   1401  CE  LYS A 167       6.688  20.330  78.090  1.00 38.83           C  
ATOM   1402  NZ  LYS A 167       7.814  19.397  78.398  1.00 43.09           N  
ATOM   1403  N   SER A 168       4.982  25.302  80.093  1.00 27.06           N  
ATOM   1404  CA  SER A 168       3.957  25.120  81.120  1.00 27.77           C  
ATOM   1405  C   SER A 168       2.843  26.144  81.030  1.00 26.60           C  
ATOM   1406  O   SER A 168       1.683  25.820  81.273  1.00 27.32           O  
ATOM   1407  CB  SER A 168       4.591  25.174  82.511  1.00 27.95           C  
ATOM   1408  OG  SER A 168       5.292  23.961  82.690  1.00 34.08           O  
ATOM   1409  N   GLY A 169       3.187  27.371  80.664  1.00 27.11           N  
ATOM   1410  CA  GLY A 169       2.188  28.426  80.448  1.00 26.37           C  
ATOM   1411  C   GLY A 169       1.217  28.126  79.298  1.00 26.57           C  
ATOM   1412  O   GLY A 169      -0.002  28.289  79.392  1.00 25.96           O  
ATOM   1413  N   VAL A 170       1.794  27.703  78.187  1.00 24.91           N  
ATOM   1414  CA  VAL A 170       0.979  27.330  77.038  1.00 24.79           C  
ATOM   1415  C   VAL A 170       0.077  26.159  77.372  1.00 24.95           C  
ATOM   1416  O   VAL A 170      -1.106  26.151  77.036  1.00 25.95           O  
ATOM   1417  CB  VAL A 170       1.890  27.070  75.827  1.00 24.66           C  
ATOM   1418  CG1 VAL A 170       1.085  26.402  74.659  1.00 24.93           C  
ATOM   1419  CG2 VAL A 170       2.617  28.374  75.427  1.00 24.08           C  
ATOM   1420  N   GLU A 171       0.626  25.172  78.065  1.00 25.32           N  
ATOM   1421  CA  GLU A 171      -0.167  24.012  78.493  1.00 25.44           C  
ATOM   1422  C   GLU A 171      -1.330  24.421  79.361  1.00 25.60           C  
ATOM   1423  O   GLU A 171      -2.458  23.930  79.199  1.00 25.87           O  
ATOM   1424  CB  GLU A 171       0.715  23.012  79.237  1.00 25.55           C  
ATOM   1425  CG  GLU A 171       1.708  22.277  78.307  1.00 28.13           C  
ATOM   1426  CD  GLU A 171       2.644  21.322  79.041  1.00 32.38           C  
ATOM   1427  OE1 GLU A 171       2.647  21.332  80.288  1.00 34.73           O  
ATOM   1428  OE2 GLU A 171       3.403  20.593  78.355  1.00 33.96           O  
ATOM   1429  N   ALA A 172      -1.062  25.347  80.286  1.00 25.00           N  
ATOM   1430  CA  ALA A 172      -2.087  25.790  81.200  1.00 24.57           C  
ATOM   1431  C   ALA A 172      -3.245  26.505  80.455  1.00 24.06           C  
ATOM   1432  O   ALA A 172      -4.441  26.236  80.707  1.00 24.56           O  
ATOM   1433  CB  ALA A 172      -1.483  26.697  82.269  1.00 24.66           C  
ATOM   1434  N   ALA A 173      -2.903  27.428  79.569  1.00 25.14           N  
ATOM   1435  CA  ALA A 173      -3.899  28.155  78.807  1.00 25.99           C  
ATOM   1436  C   ALA A 173      -4.737  27.189  77.917  1.00 26.40           C  
ATOM   1437  O   ALA A 173      -5.945  27.275  77.878  1.00 27.13           O  
ATOM   1438  CB  ALA A 173      -3.274  29.256  77.966  1.00 27.94           C  
ATOM   1439  N   LYS A 174      -4.069  26.265  77.266  1.00 26.22           N  
ATOM   1440  CA  LYS A 174      -4.733  25.287  76.394  1.00 27.38           C  
ATOM   1441  C   LYS A 174      -5.688  24.400  77.205  1.00 27.62           C  
ATOM   1442  O   LYS A 174      -6.846  24.169  76.808  1.00 27.99           O  
ATOM   1443  CB  LYS A 174      -3.678  24.441  75.712  1.00 27.98           C  
ATOM   1444  CG  LYS A 174      -4.200  23.610  74.552  1.00 33.42           C  
ATOM   1445  CD  LYS A 174      -4.255  24.389  73.229  1.00 39.60           C  
ATOM   1446  CE  LYS A 174      -4.775  23.491  72.090  1.00 41.52           C  
ATOM   1447  NZ  LYS A 174      -3.969  22.278  72.092  1.00 45.07           N  
ATOM   1448  N   SER A 175      -5.210  23.930  78.355  1.00 28.12           N  
ATOM   1449  CA  SER A 175      -6.058  23.136  79.272  1.00 28.22           C  
ATOM   1450  C   SER A 175      -7.262  23.889  79.814  1.00 28.52           C  
ATOM   1451  O   SER A 175      -8.272  23.252  80.095  1.00 29.39           O  
ATOM   1452  CB  SER A 175      -5.230  22.531  80.399  1.00 27.85           C  
ATOM   1453  OG  SER A 175      -4.285  21.616  79.900  1.00 28.89           O  
ATOM   1454  N   ALA A 176      -7.200  25.232  79.877  1.00 26.99           N  
ATOM   1455  CA  ALA A 176      -8.324  26.093  80.262  1.00 28.55           C  
ATOM   1456  C   ALA A 176      -9.319  26.306  79.137  1.00 28.51           C  
ATOM   1457  O   ALA A 176     -10.319  26.970  79.329  1.00 29.66           O  
ATOM   1458  CB  ALA A 176      -7.802  27.469  80.743  1.00 26.89           C  
ATOM   1459  N   GLY A 177      -9.011  25.773  77.957  1.00 28.53           N  
ATOM   1460  CA  GLY A 177      -9.901  25.799  76.785  1.00 28.94           C  
ATOM   1461  C   GLY A 177      -9.605  26.927  75.823  1.00 28.75           C  
ATOM   1462  O   GLY A 177     -10.361  27.156  74.879  1.00 29.30           O  
ATOM   1463  N   ILE A 178      -8.466  27.611  76.028  1.00 27.45           N  
ATOM   1464  CA  ILE A 178      -8.069  28.742  75.190  1.00 26.30           C  
ATOM   1465  C   ILE A 178      -7.258  28.209  73.979  1.00 27.56           C  
ATOM   1466  O   ILE A 178      -6.299  27.462  74.140  1.00 29.16           O  
ATOM   1467  CB  ILE A 178      -7.251  29.782  75.960  1.00 25.31           C  
ATOM   1468  CG1 ILE A 178      -8.064  30.319  77.134  1.00 22.52           C  
ATOM   1469  CG2 ILE A 178      -6.794  30.952  74.982  1.00 24.83           C  
ATOM   1470  CD1 ILE A 178      -7.238  31.101  78.159  1.00 27.71           C  
ATOM   1471  N   GLU A 179      -7.686  28.565  72.780  1.00 29.15           N  
ATOM   1472  CA  GLU A 179      -7.009  28.081  71.563  1.00 29.89           C  
ATOM   1473  C   GLU A 179      -5.997  29.059  70.967  1.00 29.18           C  
ATOM   1474  O   GLU A 179      -4.952  28.636  70.452  1.00 29.13           O  
ATOM   1475  CB  GLU A 179      -8.049  27.648  70.527  1.00 31.60           C  
ATOM   1476  CG  GLU A 179      -8.768  26.389  70.950  1.00 36.82           C  
ATOM   1477  CD  GLU A 179      -7.858  25.173  71.014  1.00 43.07           C  
ATOM   1478  OE1 GLU A 179      -7.228  24.835  69.973  1.00 49.30           O  
ATOM   1479  OE2 GLU A 179      -7.782  24.542  72.098  1.00 47.94           O  
ATOM   1480  N   ARG A 180      -6.308  30.355  70.998  1.00 27.99           N  
ATOM   1481  CA  ARG A 180      -5.450  31.361  70.377  1.00 27.95           C  
ATOM   1482  C   ARG A 180      -4.322  31.755  71.301  1.00 27.86           C  
ATOM   1483  O   ARG A 180      -4.421  32.776  72.004  1.00 26.88           O  
ATOM   1484  CB  ARG A 180      -6.221  32.616  69.984  1.00 29.23           C  
ATOM   1485  CG  ARG A 180      -7.313  32.351  69.011  1.00 31.98           C  
ATOM   1486  CD  ARG A 180      -7.958  33.656  68.530  1.00 36.41           C  
ATOM   1487  NE  ARG A 180      -9.039  33.422  67.574  1.00 38.27           N  
ATOM   1488  CZ  ARG A 180      -8.969  33.658  66.257  0.70 37.99           C  
ATOM   1489  NH1 ARG A 180      -7.855  34.123  65.682  0.70 34.74           N  
ATOM   1490  NH2 ARG A 180     -10.036  33.421  65.506  0.70 38.66           N  
ATOM   1491  N   ILE A 181      -3.301  30.900  71.349  1.00 25.37           N  
ATOM   1492  CA  ILE A 181      -2.120  31.117  72.207  1.00 25.18           C  
ATOM   1493  C   ILE A 181      -0.910  31.377  71.353  1.00 25.93           C  
ATOM   1494  O   ILE A 181      -0.579  30.554  70.481  1.00 24.19           O  
ATOM   1495  CB  ILE A 181      -1.843  29.868  73.102  1.00 25.01           C  
ATOM   1496  CG1 ILE A 181      -3.100  29.540  73.924  1.00 25.72           C  
ATOM   1497  CG2 ILE A 181      -0.597  30.110  74.004  1.00 25.11           C  
ATOM   1498  CD1 ILE A 181      -3.075  28.133  74.414  1.00 27.63           C  
ATOM   1499  N   TYR A 182      -0.261  32.524  71.545  1.00 24.72           N  
ATOM   1500  CA  TYR A 182       0.944  32.850  70.799  1.00 25.74           C  
ATOM   1501  C   TYR A 182       2.137  32.633  71.720  1.00 25.55           C  
ATOM   1502  O   TYR A 182       2.103  33.009  72.891  1.00 24.59           O  
ATOM   1503  CB  TYR A 182       0.904  34.294  70.317  1.00 25.58           C  
ATOM   1504  CG  TYR A 182      -0.079  34.511  69.189  1.00 26.28           C  
ATOM   1505  CD1 TYR A 182       0.339  34.465  67.862  1.00 26.85           C  
ATOM   1506  CD2 TYR A 182      -1.434  34.659  69.434  1.00 27.41           C  
ATOM   1507  CE1 TYR A 182      -0.561  34.630  66.835  1.00 25.58           C  
ATOM   1508  CE2 TYR A 182      -2.343  34.850  68.420  1.00 25.98           C  
ATOM   1509  CZ  TYR A 182      -1.925  34.803  67.108  1.00 26.26           C  
ATOM   1510  OH  TYR A 182      -2.781  34.959  66.026  1.00 26.34           O  
ATOM   1511  N   GLY A 183       3.168  32.011  71.203  1.00 25.60           N  
ATOM   1512  CA  GLY A 183       4.362  31.759  71.960  1.00 26.04           C  
ATOM   1513  C   GLY A 183       5.351  32.886  71.710  1.00 25.45           C  
ATOM   1514  O   GLY A 183       5.764  33.120  70.597  1.00 27.51           O  
ATOM   1515  N   VAL A 184       5.767  33.562  72.777  1.00 25.24           N  
ATOM   1516  CA  VAL A 184       6.671  34.715  72.692  1.00 26.22           C  
ATOM   1517  C   VAL A 184       8.116  34.261  72.898  1.00 27.14           C  
ATOM   1518  O   VAL A 184       8.412  33.597  73.885  1.00 27.80           O  
ATOM   1519  CB  VAL A 184       6.300  35.810  73.763  1.00 27.20           C  
ATOM   1520  CG1 VAL A 184       7.253  37.009  73.637  1.00 26.97           C  
ATOM   1521  CG2 VAL A 184       4.861  36.245  73.524  1.00 26.86           C  
ATOM   1522  N   VAL A 185       8.983  34.615  71.967  1.00 28.98           N  
ATOM   1523  CA  VAL A 185      10.351  34.113  71.953  1.00 30.08           C  
ATOM   1524  C   VAL A 185      11.331  35.261  71.930  1.00 32.34           C  
ATOM   1525  O   VAL A 185      10.985  36.371  71.566  1.00 32.92           O  
ATOM   1526  CB  VAL A 185      10.574  33.202  70.709  1.00 30.66           C  
ATOM   1527  CG1 VAL A 185       9.712  31.962  70.799  1.00 32.64           C  
ATOM   1528  CG2 VAL A 185      10.305  33.962  69.441  1.00 29.37           C  
ATOM   1529  N   HIS A 186      12.588  34.966  72.243  1.00 35.60           N  
ATOM   1530  CA  HIS A 186      13.583  36.009  72.456  1.00 38.17           C  
ATOM   1531  C   HIS A 186      14.909  35.808  71.761  1.00 39.19           C  
ATOM   1532  O   HIS A 186      15.791  36.662  71.886  1.00 40.21           O  
ATOM   1533  CB  HIS A 186      13.852  36.096  73.952  1.00 39.27           C  
ATOM   1534  CG  HIS A 186      12.603  36.203  74.761  1.00 41.43           C  
ATOM   1535  ND1 HIS A 186      11.857  37.362  74.806  1.00 45.32           N  
ATOM   1536  CD2 HIS A 186      11.947  35.299  75.525  1.00 45.96           C  
ATOM   1537  CE1 HIS A 186      10.798  37.170  75.567  1.00 44.74           C  
ATOM   1538  NE2 HIS A 186      10.824  35.923  76.015  1.00 45.33           N  
ATOM   1539  N   SER A 187      15.043  34.719  71.014  0.80 39.25           N  
ATOM   1540  CA  SER A 187      16.345  34.327  70.465  0.80 39.08           C  
ATOM   1541  C   SER A 187      16.168  33.882  69.028  0.80 38.38           C  
ATOM   1542  O   SER A 187      15.065  33.952  68.487  0.80 37.91           O  
ATOM   1543  CB  SER A 187      16.967  33.224  71.337  0.80 40.04           C  
ATOM   1544  OG  SER A 187      16.714  31.915  70.834  0.80 42.65           O  
ATOM   1545  N   LEU A 188      17.260  33.420  68.421  0.80 37.56           N  
ATOM   1546  CA  LEU A 188      17.287  33.119  66.997  0.80 36.91           C  
ATOM   1547  C   LEU A 188      16.347  31.971  66.610  0.80 35.81           C  
ATOM   1548  O   LEU A 188      15.616  32.105  65.638  0.80 35.57           O  
ATOM   1549  CB  LEU A 188      18.724  32.838  66.521  0.80 37.27           C  
ATOM   1550  CG  LEU A 188      18.976  32.655  65.009  0.80 36.59           C  
ATOM   1551  CD1 LEU A 188      18.487  33.827  64.176  0.80 38.82           C  
ATOM   1552  CD2 LEU A 188      20.465  32.407  64.725  0.80 39.36           C  
ATOM   1553  N   ASN A 189      16.350  30.871  67.371  0.80 35.33           N  
ATOM   1554  CA  ASN A 189      15.501  29.704  67.045  0.70 35.37           C  
ATOM   1556  C   ASN A 189      14.830  28.992  68.172  0.80 34.56           C  
ATOM   1557  O   ASN A 189      14.482  27.816  68.062  0.80 34.33           O  
ATOM   1558  CB  ASN A 189      16.305  28.704  66.256  0.70 35.60           C  
ATOM   1560  CG  ASN A 189      16.400  29.093  64.862  0.70 35.82           C  
ATOM   1562  OD1 ASN A 189      15.395  29.109  64.142  0.70 40.10           O  
ATOM   1564  ND2 ASN A 189      17.584  29.471  64.453  0.70 40.83           N  
ATOM   1566  N   ASP A 190      14.585  29.715  69.265  0.80 33.61           N  
ATOM   1567  CA  ASP A 190      13.792  29.154  70.333  0.80 33.10           C  
ATOM   1568  C   ASP A 190      12.328  29.111  69.908  0.80 31.67           C  
ATOM   1569  O   ASP A 190      11.891  29.800  68.963  0.80 30.13           O  
ATOM   1570  CB  ASP A 190      13.927  29.923  71.676  0.80 33.71           C  
ATOM   1571  CG  ASP A 190      13.656  31.411  71.551  0.80 35.52           C  
ATOM   1572  OD1 ASP A 190      13.917  31.976  70.450  0.80 37.80           O  
ATOM   1573  OD2 ASP A 190      13.173  32.026  72.562  0.80 38.34           O  
ATOM   1574  N   GLY A 191      11.608  28.241  70.596  1.00 30.30           N  
ATOM   1575  CA  GLY A 191      10.160  28.225  70.598  1.00 30.61           C  
ATOM   1576  C   GLY A 191       9.499  26.942  70.148  1.00 29.49           C  
ATOM   1577  O   GLY A 191       8.279  26.826  70.216  1.00 28.31           O  
ATOM   1578  N   LYS A 192      10.281  25.978  69.678  1.00 28.31           N  
ATOM   1579  CA  LYS A 192       9.719  24.696  69.256  1.00 28.90           C  
ATOM   1580  C   LYS A 192       8.848  24.068  70.350  1.00 28.65           C  
ATOM   1581  O   LYS A 192       7.738  23.610  70.081  1.00 27.44           O  
ATOM   1582  CB  LYS A 192      10.813  23.733  68.811  1.00 29.41           C  
ATOM   1583  CG  LYS A 192      10.240  22.448  68.195  1.00 31.41           C  
ATOM   1584  CD  LYS A 192      11.294  21.585  67.615  1.00 31.60           C  
ATOM   1585  CE  LYS A 192      10.660  20.316  67.080  1.00 33.01           C  
ATOM   1586  NZ  LYS A 192      11.626  19.403  66.478  1.00 30.79           N  
ATOM   1587  N   ALA A 193       9.314  24.103  71.593  1.00 28.43           N  
ATOM   1588  CA  ALA A 193       8.523  23.562  72.735  1.00 28.89           C  
ATOM   1589  C   ALA A 193       7.171  24.260  72.924  1.00 28.42           C  
ATOM   1590  O   ALA A 193       6.188  23.648  73.356  1.00 28.43           O  
ATOM   1591  CB  ALA A 193       9.319  23.653  74.024  1.00 29.71           C  
ATOM   1592  N   LEU A 194       7.104  25.543  72.601  1.00 27.37           N  
ATOM   1593  CA  LEU A 194       5.867  26.286  72.755  1.00 26.76           C  
ATOM   1594  C   LEU A 194       4.871  25.835  71.681  1.00 25.59           C  
ATOM   1595  O   LEU A 194       3.699  25.693  71.943  1.00 26.19           O  
ATOM   1596  CB  LEU A 194       6.104  27.787  72.641  1.00 26.62           C  
ATOM   1597  CG  LEU A 194       7.106  28.458  73.618  1.00 26.84           C  
ATOM   1598  CD1 LEU A 194       7.094  30.000  73.359  1.00 28.99           C  
ATOM   1599  CD2 LEU A 194       6.841  28.149  75.113  1.00 27.46           C  
ATOM   1600  N   LEU A 195       5.363  25.614  70.466  1.00 24.81           N  
ATOM   1601  CA  LEU A 195       4.514  25.111  69.394  1.00 24.89           C  
ATOM   1602  C   LEU A 195       4.030  23.711  69.746  1.00 26.01           C  
ATOM   1603  O   LEU A 195       2.865  23.364  69.560  1.00 26.74           O  
ATOM   1604  CB  LEU A 195       5.315  25.092  68.069  1.00 24.32           C  
ATOM   1605  CG  LEU A 195       5.656  26.474  67.442  1.00 24.07           C  
ATOM   1606  CD1 LEU A 195       6.496  26.349  66.159  1.00 26.83           C  
ATOM   1607  CD2 LEU A 195       4.391  27.285  67.224  1.00 25.63           C  
ATOM   1608  N   GLU A 196       4.926  22.895  70.259  1.00 26.49           N  
ATOM   1609  CA  GLU A 196       4.536  21.538  70.560  0.70 27.91           C  
ATOM   1611  C   GLU A 196       3.465  21.529  71.648  1.00 27.58           C  
ATOM   1612  O   GLU A 196       2.569  20.710  71.602  1.00 29.01           O  
ATOM   1613  CB  GLU A 196       5.749  20.698  70.926  0.70 28.09           C  
ATOM   1615  CG  GLU A 196       6.888  20.620  69.852  0.70 32.46           C  
ATOM   1617  CD  GLU A 196       6.480  20.717  68.343  0.70 37.49           C  
ATOM   1619  OE1 GLU A 196       5.806  19.784  67.812  0.70 37.49           O  
ATOM   1621  OE2 GLU A 196       6.914  21.708  67.669  0.70 38.75           O  
ATOM   1623  N   ALA A 197       3.534  22.467  72.592  1.00 27.72           N  
ATOM   1624  CA  ALA A 197       2.508  22.600  73.643  1.00 28.42           C  
ATOM   1625  C   ALA A 197       1.159  23.145  73.172  1.00 29.34           C  
ATOM   1626  O   ALA A 197       0.183  23.159  73.932  1.00 29.85           O  
ATOM   1627  CB  ALA A 197       3.047  23.489  74.793  1.00 28.31           C  
ATOM   1628  N   GLY A 198       1.118  23.661  71.942  1.00 28.73           N  
ATOM   1629  CA  GLY A 198      -0.119  24.132  71.372  1.00 29.03           C  
ATOM   1630  C   GLY A 198      -0.171  25.580  70.949  1.00 27.92           C  
ATOM   1631  O   GLY A 198      -1.205  26.039  70.462  1.00 28.44           O  
ATOM   1632  N   ALA A 199       0.931  26.305  71.058  1.00 27.36           N  
ATOM   1633  CA  ALA A 199       0.928  27.668  70.530  1.00 26.01           C  
ATOM   1634  C   ALA A 199       0.673  27.650  69.001  1.00 26.22           C  
ATOM   1635  O   ALA A 199       1.116  26.732  68.266  1.00 24.75           O  
ATOM   1636  CB  ALA A 199       2.225  28.355  70.832  1.00 27.00           C  
ATOM   1637  N   VAL A 200      -0.041  28.667  68.544  1.00 26.03           N  
ATOM   1638  CA  VAL A 200      -0.495  28.712  67.138  1.00 26.02           C  
ATOM   1639  C   VAL A 200       0.512  29.427  66.202  1.00 25.81           C  
ATOM   1640  O   VAL A 200       0.436  29.322  64.976  1.00 25.28           O  
ATOM   1641  CB  VAL A 200      -1.876  29.399  67.016  1.00 26.64           C  
ATOM   1642  CG1 VAL A 200      -2.932  28.641  67.858  1.00 27.18           C  
ATOM   1643  CG2 VAL A 200      -1.777  30.878  67.321  1.00 25.60           C  
ATOM   1644  N   ALA A 201       1.493  30.102  66.801  1.00 25.96           N  
ATOM   1645  CA  ALA A 201       2.507  30.827  66.086  1.00 24.14           C  
ATOM   1646  C   ALA A 201       3.512  31.312  67.099  1.00 24.68           C  
ATOM   1647  O   ALA A 201       3.142  31.514  68.260  1.00 25.01           O  
ATOM   1648  CB  ALA A 201       1.919  32.030  65.305  1.00 24.71           C  
ATOM   1649  N   LEU A 202       4.739  31.552  66.652  1.00 24.29           N  
ATOM   1650  CA  LEU A 202       5.733  32.213  67.485  1.00 25.32           C  
ATOM   1651  C   LEU A 202       5.871  33.680  67.074  1.00 26.61           C  
ATOM   1652  O   LEU A 202       5.784  34.001  65.865  1.00 27.06           O  
ATOM   1653  CB  LEU A 202       7.068  31.535  67.379  1.00 24.38           C  
ATOM   1654  CG  LEU A 202       7.137  30.031  67.652  1.00 27.17           C  
ATOM   1655  CD1 LEU A 202       8.564  29.514  67.327  1.00 26.56           C  
ATOM   1656  CD2 LEU A 202       6.722  29.741  69.089  1.00 26.68           C  
ATOM   1657  N   VAL A 203       6.120  34.540  68.063  1.00 26.83           N  
ATOM   1658  CA  VAL A 203       6.291  35.976  67.842  1.00 27.84           C  
ATOM   1659  C   VAL A 203       7.327  36.542  68.790  1.00 27.99           C  
ATOM   1660  O   VAL A 203       7.482  36.043  69.882  1.00 28.45           O  
ATOM   1661  CB  VAL A 203       4.969  36.743  68.004  1.00 29.41           C  
ATOM   1662  CG1 VAL A 203       4.080  36.414  66.829  1.00 30.71           C  
ATOM   1663  CG2 VAL A 203       4.343  36.422  69.350  1.00 27.54           C  
ATOM   1664  N   LYS A 204       8.106  37.515  68.323  1.00 28.89           N  
ATOM   1665  CA  LYS A 204       8.958  38.310  69.221  1.00 30.31           C  
ATOM   1666  C   LYS A 204       8.080  39.373  69.876  1.00 29.88           C  
ATOM   1667  O   LYS A 204       7.039  39.732  69.363  1.00 29.31           O  
ATOM   1668  CB  LYS A 204      10.121  38.956  68.446  1.00 31.87           C  
ATOM   1669  CG  LYS A 204      11.154  37.955  67.935  1.00 35.30           C  
ATOM   1670  CD  LYS A 204      12.156  38.620  67.029  1.00 40.58           C  
ATOM   1671  CE  LYS A 204      11.602  38.826  65.639  1.00 43.58           C  
ATOM   1672  NZ  LYS A 204      11.908  37.703  64.659  1.00 44.72           N  
ATOM   1673  N   PRO A 205       8.476  39.874  71.042  1.00 30.75           N  
ATOM   1674  CA  PRO A 205       7.689  40.917  71.693  1.00 31.36           C  
ATOM   1675  C   PRO A 205       7.323  42.069  70.768  1.00 31.84           C  
ATOM   1676  O   PRO A 205       6.181  42.534  70.793  1.00 32.87           O  
ATOM   1677  CB  PRO A 205       8.640  41.402  72.778  1.00 31.53           C  
ATOM   1678  CG  PRO A 205       9.331  40.142  73.167  1.00 30.94           C  
ATOM   1679  CD  PRO A 205       9.630  39.493  71.861  1.00 30.29           C  
ATOM   1680  N   GLU A 206       8.265  42.467  69.910  1.00 32.72           N  
ATOM   1681  CA  GLU A 206       8.053  43.565  68.955  1.00 33.14           C  
ATOM   1682  C   GLU A 206       7.011  43.245  67.894  1.00 32.73           C  
ATOM   1683  O   GLU A 206       6.527  44.152  67.232  1.00 34.23           O  
ATOM   1684  CB  GLU A 206       9.338  43.919  68.180  1.00 34.17           C  
ATOM   1685  CG  GLU A 206      10.574  43.981  68.975  1.00 36.90           C  
ATOM   1686  CD  GLU A 206      11.241  42.638  69.075  1.00 36.62           C  
ATOM   1687  OE1 GLU A 206      11.979  42.228  68.142  1.00 43.08           O  
ATOM   1688  OE2 GLU A 206      11.027  42.018  70.106  1.00 34.47           O  
ATOM   1689  N   GLU A 207       6.689  41.960  67.713  1.00 31.91           N  
ATOM   1690  CA  GLU A 207       5.714  41.533  66.708  1.00 31.51           C  
ATOM   1691  C   GLU A 207       4.285  41.404  67.231  1.00 30.06           C  
ATOM   1692  O   GLU A 207       3.346  41.194  66.453  1.00 30.00           O  
ATOM   1693  CB  GLU A 207       6.167  40.203  66.083  1.00 31.78           C  
ATOM   1694  CG  GLU A 207       7.415  40.345  65.229  1.00 35.14           C  
ATOM   1695  CD  GLU A 207       8.190  39.050  64.966  1.00 39.19           C  
ATOM   1696  OE1 GLU A 207       7.867  37.958  65.499  1.00 37.13           O  
ATOM   1697  OE2 GLU A 207       9.170  39.141  64.189  1.00 43.24           O  
ATOM   1698  N   ILE A 208       4.116  41.562  68.541  1.00 29.22           N  
ATOM   1699  CA  ILE A 208       2.813  41.344  69.170  1.00 27.98           C  
ATOM   1700  C   ILE A 208       1.798  42.365  68.637  1.00 27.31           C  
ATOM   1701  O   ILE A 208       0.665  42.025  68.341  1.00 27.43           O  
ATOM   1702  CB  ILE A 208       2.925  41.412  70.698  1.00 27.72           C  
ATOM   1703  CG1 ILE A 208       3.665  40.173  71.236  1.00 27.12           C  
ATOM   1704  CG2 ILE A 208       1.518  41.519  71.325  1.00 25.64           C  
ATOM   1705  CD1 ILE A 208       3.957  40.200  72.730  1.00 25.85           C  
ATOM   1706  N   LEU A 209       2.209  43.612  68.506  1.00 28.03           N  
ATOM   1707  CA  LEU A 209       1.290  44.639  67.982  1.00 28.39           C  
ATOM   1708  C   LEU A 209       0.654  44.269  66.642  1.00 28.89           C  
ATOM   1709  O   LEU A 209      -0.553  44.341  66.457  1.00 28.24           O  
ATOM   1710  CB  LEU A 209       2.007  45.967  67.884  1.00 29.27           C  
ATOM   1711  CG  LEU A 209       1.199  47.141  67.325  1.00 27.71           C  
ATOM   1712  CD1 LEU A 209      -0.051  47.490  68.134  1.00 28.38           C  
ATOM   1713  CD2 LEU A 209       2.100  48.327  67.203  1.00 30.31           C  
ATOM   1714  N   ASN A 210       1.476  43.841  65.697  1.00 30.11           N  
ATOM   1715  CA  ASN A 210       0.962  43.482  64.384  1.00 31.28           C  
ATOM   1716  C   ASN A 210       0.045  42.250  64.432  1.00 30.47           C  
ATOM   1717  O   ASN A 210      -0.955  42.185  63.698  1.00 30.04           O  
ATOM   1718  CB  ASN A 210       2.127  43.308  63.395  1.00 32.57           C  
ATOM   1719  CG  ASN A 210       2.729  44.658  62.933  1.00 36.76           C  
ATOM   1720  OD1 ASN A 210       3.841  44.697  62.375  1.00 44.39           O  
ATOM   1721  ND2 ASN A 210       2.001  45.754  63.154  1.00 39.28           N  
ATOM   1722  N   VAL A 211       0.349  41.297  65.311  1.00 29.56           N  
ATOM   1723  CA  VAL A 211      -0.604  40.209  65.588  1.00 28.71           C  
ATOM   1724  C   VAL A 211      -1.955  40.751  66.046  1.00 28.69           C  
ATOM   1725  O   VAL A 211      -3.010  40.371  65.530  1.00 28.17           O  
ATOM   1726  CB  VAL A 211      -0.058  39.164  66.597  1.00 29.56           C  
ATOM   1727  CG1 VAL A 211      -1.168  38.198  67.012  1.00 28.64           C  
ATOM   1728  CG2 VAL A 211       1.155  38.436  66.001  1.00 30.07           C  
ATOM   1729  N   LEU A 212      -1.945  41.665  67.007  1.00 27.92           N  
ATOM   1730  CA  LEU A 212      -3.202  42.208  67.510  1.00 27.62           C  
ATOM   1731  C   LEU A 212      -3.945  42.983  66.406  1.00 27.75           C  
ATOM   1732  O   LEU A 212      -5.155  42.862  66.307  1.00 27.90           O  
ATOM   1733  CB  LEU A 212      -2.955  43.102  68.743  1.00 27.68           C  
ATOM   1734  CG  LEU A 212      -2.380  42.326  69.923  1.00 29.30           C  
ATOM   1735  CD1 LEU A 212      -1.944  43.352  70.993  1.00 29.04           C  
ATOM   1736  CD2 LEU A 212      -3.374  41.270  70.394  1.00 32.98           C  
ATOM   1737  N   LYS A 213      -3.229  43.743  65.566  1.00 29.21           N  
ATOM   1738  CA  LYS A 213      -3.894  44.457  64.465  1.00 30.23           C  
ATOM   1739  C   LYS A 213      -4.579  43.470  63.496  1.00 31.44           C  
ATOM   1740  O   LYS A 213      -5.653  43.750  62.966  1.00 32.15           O  
ATOM   1741  CB  LYS A 213      -2.904  45.353  63.730  1.00 30.42           C  
ATOM   1742  CG  LYS A 213      -2.382  46.466  64.577  1.00 31.65           C  
ATOM   1743  CD  LYS A 213      -1.463  47.361  63.778  1.00 34.30           C  
ATOM   1744  CE  LYS A 213      -1.333  48.724  64.422  1.00 38.15           C  
ATOM   1745  NZ  LYS A 213      -0.416  49.602  63.636  1.00 39.84           N  
ATOM   1746  N   GLU A 214      -3.984  42.288  63.335  1.00 31.87           N  
ATOM   1747  CA  GLU A 214      -4.558  41.213  62.511  1.00 32.49           C  
ATOM   1748  C   GLU A 214      -5.809  40.574  63.151  1.00 32.81           C  
ATOM   1749  O   GLU A 214      -6.836  40.405  62.473  1.00 32.73           O  
ATOM   1750  CB  GLU A 214      -3.480  40.128  62.268  1.00 33.31           C  
ATOM   1751  CG  GLU A 214      -3.925  38.899  61.426  1.00 34.55           C  
ATOM   1752  CD  GLU A 214      -3.071  37.632  61.692  1.00 37.96           C  
ATOM   1753  OE1 GLU A 214      -2.042  37.711  62.406  1.00 35.13           O  
ATOM   1754  OE2 GLU A 214      -3.452  36.554  61.172  1.00 38.24           O  
ATOM   1755  N   VAL A 215      -5.746  40.223  64.443  1.00 31.81           N  
ATOM   1756  CA  VAL A 215      -6.807  39.414  65.037  1.00 32.36           C  
ATOM   1757  C   VAL A 215      -7.914  40.154  65.797  1.00 32.63           C  
ATOM   1758  O   VAL A 215      -8.982  39.555  66.069  1.00 33.95           O  
ATOM   1759  CB  VAL A 215      -6.222  38.274  65.929  1.00 32.40           C  
ATOM   1760  CG1 VAL A 215      -5.219  37.489  65.124  1.00 32.26           C  
ATOM   1761  CG2 VAL A 215      -5.582  38.836  67.168  1.00 33.82           C  
ATOM   1762  N   LEU A 216      -7.668  41.393  66.203  1.00 33.30           N  
ATOM   1763  CA  LEU A 216      -8.678  42.142  66.976  1.00 33.31           C  
ATOM   1764  C   LEU A 216      -9.636  42.913  66.103  1.00 35.52           C  
ATOM   1765  O   LEU A 216      -9.339  43.225  64.954  1.00 37.23           O  
ATOM   1766  CB  LEU A 216      -8.046  43.126  67.964  1.00 32.97           C  
ATOM   1767  CG  LEU A 216      -7.164  42.563  69.072  1.00 32.18           C  
ATOM   1768  CD1 LEU A 216      -6.867  43.691  70.084  1.00 27.70           C  
ATOM   1769  CD2 LEU A 216      -7.776  41.362  69.748  1.00 32.98           C  
ATOM   1770  OXT LEU A 216     -10.719  43.255  66.600  1.00 37.31           O  
TER    1771      LEU A 216                                                      
END
MOLECULE T0418.pdb
ATOM      1  N   LYS     2     -13.076  35.543  67.613  1.00 29.62           N
ATOM      2  CA  LYS     2     -12.478  36.834  68.052  0.50 29.11           C
ATOM      4  CB  LYS     2     -13.375  38.010  67.650  0.50 29.29           C
ATOM      6  CG  LYS     2     -12.641  39.346  67.502  0.50 28.70           C
ATOM      8  CD  LYS     2     -13.620  40.472  67.149  0.50 28.45           C
ATOM     10  CE  LYS     2     -14.745  40.631  68.215  0.50 27.78           C
ATOM     12  NZ  LYS     2     -14.212  40.910  69.618  0.50 23.90           N
ATOM     14  C   LYS     2     -12.217  36.842  69.559  1.00 29.22           C
ATOM     15  O   LYS     2     -13.013  36.324  70.358  1.00 29.48           O
ATOM     16  N   TYR     3     -11.081  37.413  69.934  1.00 28.23           N
ATOM     17  CA  TYR     3     -10.713  37.511  71.337  1.00 28.13           C
ATOM     18  CB  TYR     3      -9.228  37.205  71.499  1.00 27.69           C
ATOM     19  CG  TYR     3      -8.855  35.913  70.851  1.00 27.85           C
ATOM     20  CD1 TYR     3      -9.318  34.695  71.359  1.00 27.15           C
ATOM     21  CE1 TYR     3      -8.963  33.481  70.741  1.00 29.48           C
ATOM     22  CZ  TYR     3      -8.150  33.512  69.615  1.00 28.31           C
ATOM     23  OH  TYR     3      -7.781  32.362  68.998  1.00 29.71           O
ATOM     24  CE2 TYR     3      -7.689  34.704  69.099  1.00 28.68           C
ATOM     25  CD2 TYR     3      -8.054  35.901  69.711  1.00 28.20           C
ATOM     26  C   TYR     3     -11.028  38.898  71.895  1.00 27.71           C
ATOM     27  O   TYR     3     -10.756  39.901  71.237  1.00 28.58           O
ATOM     28  N   THR     4     -11.608  38.949  73.092  1.00 26.98           N
ATOM     29  CA  THR     4     -11.921  40.233  73.752  1.00 26.26           C
ATOM     30  CB  THR     4     -13.434  40.362  74.092  1.00 25.63           C
ATOM     31  OG1 THR     4     -13.795  39.364  75.050  1.00 24.05           O
ATOM     32  CG2 THR     4     -14.272  40.199  72.862  1.00 25.42           C
ATOM     33  C   THR     4     -11.088  40.424  75.028  1.00 26.20           C
ATOM     34  O   THR     4     -11.218  41.432  75.726  1.00 26.38           O
ATOM     35  N   VAL     5     -10.260  39.424  75.320  1.00 26.09           N
ATOM     36  CA  VAL     5      -9.387  39.390  76.487  1.00 25.98           C
ATOM     37  CB  VAL     5      -9.988  38.533  77.656  1.00 26.21           C
ATOM     38  CG1 VAL     5      -9.003  38.455  78.853  1.00 25.67           C
ATOM     39  CG2 VAL     5     -11.398  39.033  78.080  1.00 25.14           C
ATOM     40  C   VAL     5      -8.026  38.798  76.069  1.00 26.19           C
ATOM     41  O   VAL     5      -7.939  37.642  75.627  1.00 25.71           O
ATOM     42  N   TYR     6      -6.974  39.596  76.199  1.00 25.76           N
ATOM     43  CA  TYR     6      -5.616  39.122  75.949  1.00 25.47           C
ATOM     44  CB  TYR     6      -4.867  40.089  75.019  1.00 25.89           C
ATOM     45  CG  TYR     6      -5.233  40.042  73.546  1.00 26.06           C
ATOM     46  CD1 TYR     6      -6.573  40.059  73.118  1.00 27.09           C
ATOM     47  CE1 TYR     6      -6.905  40.033  71.753  1.00 27.02           C
ATOM     48  CZ  TYR     6      -5.886  40.001  70.813  1.00 26.83           C
ATOM     49  OH  TYR     6      -6.181  39.980  69.480  1.00 25.05           O
ATOM     50  CE2 TYR     6      -4.551  40.012  71.213  1.00 25.46           C
ATOM     51  CD2 TYR     6      -4.234  40.029  72.575  1.00 26.76           C
ATOM     52  C   TYR     6      -4.877  39.026  77.278  1.00 25.08           C
ATOM     53  O   TYR     6      -4.674  40.032  77.943  1.00 24.69           O
ATOM     54  N   LEU     7      -4.487  37.816  77.670  1.00 24.54           N
ATOM     55  CA  LEU     7      -3.771  37.624  78.929  1.00 24.14           C
ATOM     56  CB  LEU     7      -4.383  36.496  79.763  1.00 23.59           C
ATOM     57  CG  LEU     7      -5.870  36.734  80.138  1.00 24.16           C
ATOM     58  CD1 LEU     7      -6.521  35.534  80.774  1.00 20.62           C
ATOM     59  CD2 LEU     7      -6.014  37.958  81.059  1.00 22.12           C
ATOM     60  C   LEU     7      -2.323  37.335  78.582  1.00 24.96           C
ATOM     61  O   LEU     7      -2.027  36.555  77.668  1.00 24.77           O
ATOM     62  N   PHE     8      -1.430  38.000  79.300  1.00 25.46           N
ATOM     63  CA  PHE     8      -0.011  37.932  79.019  1.00 25.12           C
ATOM     64  CB  PHE     8       0.536  39.346  78.747  1.00 24.90           C
ATOM     65  CG  PHE     8      -0.072  40.030  77.537  1.00 23.20           C
ATOM     66  CD1 PHE     8       0.543  39.933  76.300  1.00 20.97           C
ATOM     67  CE1 PHE     8       0.002  40.554  75.184  1.00 23.26           C
ATOM     68  CZ  PHE     8      -1.183  41.317  75.319  1.00 23.30           C
ATOM     69  CE2 PHE     8      -1.795  41.414  76.551  1.00 22.61           C
ATOM     70  CD2 PHE     8      -1.243  40.770  77.646  1.00 23.59           C
ATOM     71  C   PHE     8       0.758  37.332  80.185  1.00 25.42           C
ATOM     72  O   PHE     8       0.489  37.647  81.349  1.00 24.56           O
ATOM     73  N   ASP     9       1.705  36.454  79.854  1.00 25.13           N
ATOM     74  CA  ASP     9       2.868  36.191  80.698  1.00 25.05           C
ATOM     75  CB  ASP     9       3.770  35.134  80.038  1.00 25.36           C
ATOM     76  CG  ASP     9       4.800  34.591  80.993  1.00 26.68           C
ATOM     77  OD1 ASP     9       4.592  34.704  82.202  1.00 34.85           O
ATOM     78  OD2 ASP     9       5.854  34.101  80.583  1.00 35.24           O
ATOM     79  C   ASP     9       3.678  37.487  80.915  1.00 24.97           C
ATOM     80  O   ASP     9       3.511  38.454  80.172  1.00 26.37           O
ATOM     81  N   PHE    10       4.517  37.529  81.947  1.00 23.63           N
ATOM     82  CA  PHE    10       5.322  38.732  82.245  1.00 23.16           C
ATOM     83  CB  PHE    10       5.224  39.137  83.733  1.00 22.29           C
ATOM     84  CG  PHE    10       5.966  40.422  84.054  1.00 22.99           C
ATOM     85  CD1 PHE    10       5.373  41.665  83.808  1.00 24.77           C
ATOM     86  CE1 PHE    10       6.080  42.878  84.084  1.00 24.55           C
ATOM     87  CZ  PHE    10       7.384  42.826  84.610  1.00 22.62           C
ATOM     88  CE2 PHE    10       7.982  41.589  84.874  1.00 24.73           C
ATOM     89  CD2 PHE    10       7.276  40.382  84.582  1.00 23.46           C
ATOM     90  C   PHE    10       6.773  38.604  81.815  1.00 22.66           C
ATOM     91  O   PHE    10       7.185  39.218  80.841  1.00 23.91           O
ATOM     92  N   ASP    11       7.552  37.779  82.507  1.00 23.43           N
ATOM     93  CA  ASP    11       8.986  37.643  82.204  1.00 23.44           C
ATOM     94  CB  ASP    11       9.664  36.690  83.184  1.00 23.10           C
ATOM     95  CG  ASP    11       9.732  37.232  84.591  1.00 24.03           C
ATOM     96  OD1 ASP    11      10.159  38.406  84.796  1.00 24.46           O
ATOM     97  OD2 ASP    11       9.374  36.443  85.514  1.00 23.52           O
ATOM     98  C   ASP    11       9.215  37.131  80.776  1.00 23.25           C
ATOM     99  O   ASP    11       8.635  36.114  80.385  1.00 23.39           O
ATOM    100  N   TYR    12      10.044  37.839  80.001  1.00 21.78           N
ATOM    101  CA  TYR    12      10.289  37.470  78.592  1.00 19.73           C
ATOM    102  CB  TYR    12      10.756  36.006  78.503  1.00 20.19           C
ATOM    103  CG  TYR    12      12.274  35.815  78.587  1.00 18.57           C
ATOM    104  CD1 TYR    12      13.161  36.790  78.106  1.00 19.37           C
ATOM    105  CE1 TYR    12      14.573  36.569  78.131  1.00 17.76           C
ATOM    106  CZ  TYR    12      15.053  35.376  78.655  1.00 20.36           C
ATOM    107  OH  TYR    12      16.419  35.108  78.707  1.00 20.14           O
ATOM    108  CE2 TYR    12      14.181  34.426  79.131  1.00 19.24           C
ATOM    109  CD2 TYR    12      12.810  34.625  79.069  1.00 19.14           C
ATOM    110  C   TYR    12       9.134  37.682  77.617  1.00 20.20           C
ATOM    111  O   TYR    12       9.239  37.335  76.430  1.00 18.25           O
ATOM    112  N   THR    13       8.026  38.225  78.105  1.00 19.18           N
ATOM    113  CA  THR    13       6.883  38.448  77.261  1.00 20.06           C
ATOM    114  CB  THR    13       5.674  37.608  77.705  1.00 19.89           C
ATOM    115  OG1 THR    13       5.969  36.211  77.494  1.00 21.97           O
ATOM    116  CG2 THR    13       4.465  37.998  76.843  1.00 19.00           C
ATOM    117  C   THR    13       6.536  39.943  77.240  1.00 19.72           C
ATOM    118  O   THR    13       6.575  40.562  76.173  1.00 19.50           O
ATOM    119  N   LEU    14       6.246  40.526  78.410  1.00 19.60           N
ATOM    120  CA  LEU    14       5.990  41.979  78.467  1.00 20.37           C
ATOM    121  CB  LEU    14       4.878  42.310  79.457  1.00 19.90           C
ATOM    122  CG  LEU    14       3.462  41.924  79.113  1.00 21.71           C
ATOM    123  CD1 LEU    14       2.570  42.180  80.336  1.00 22.39           C
ATOM    124  CD2 LEU    14       2.910  42.633  77.863  1.00 25.95           C
ATOM    125  C   LEU    14       7.227  42.813  78.792  1.00 20.70           C
ATOM    126  O   LEU    14       7.279  44.014  78.491  1.00 21.38           O
ATOM    127  N   ALA    15       8.195  42.183  79.445  1.00 20.70           N
ATOM    128  CA  ALA    15       9.386  42.843  79.946  1.00 21.53           C
ATOM    129  CB  ALA    15       9.167  43.257  81.419  1.00 22.22           C
ATOM    130  C   ALA    15      10.568  41.890  79.847  1.00 21.56           C
ATOM    131  O   ALA    15      10.417  40.686  80.082  1.00 20.75           O
ATOM    132  N   ASP    16      11.748  42.401  79.485  1.00 21.65           N
ATOM    133  CA  ASP    16      12.918  41.546  79.546  1.00 21.72           C
ATOM    134  CB  ASP    16      13.931  41.880  78.453  1.00 22.91           C
ATOM    135  CG  ASP    16      15.158  40.970  78.479  1.00 22.98           C
ATOM    136  OD1 ASP    16      15.256  40.068  79.357  1.00 22.97           O
ATOM    137  OD2 ASP    16      16.035  41.171  77.614  1.00 21.32           O
ATOM    138  C   ASP    16      13.533  41.709  80.935  1.00 22.65           C
ATOM    139  O   ASP    16      14.294  42.647  81.179  1.00 22.64           O
ATOM    140  N   SER    17      13.214  40.769  81.827  1.00 22.73           N
ATOM    141  CA  SER    17      13.740  40.776  83.181  1.00 24.42           C
ATOM    142  CB  SER    17      12.653  40.291  84.135  1.00 23.74           C
ATOM    143  OG  SER    17      12.089  39.109  83.579  1.00 28.12           O
ATOM    144  C   SER    17      14.977  39.871  83.334  1.00 25.00           C
ATOM    145  O   SER    17      15.425  39.655  84.452  1.00 25.03           O
ATOM    146  N   SER    18      15.512  39.351  82.219  1.00 24.93           N
ATOM    147  CA  SER    18      16.539  38.297  82.275  1.00 25.48           C
ATOM    148  CB  SER    18      16.815  37.713  80.860  1.00 24.70           C
ATOM    149  OG  SER    18      17.501  38.638  80.023  1.00 23.20           O
ATOM    150  C   SER    18      17.860  38.750  82.945  1.00 25.77           C
ATOM    151  O   SER    18      18.536  37.947  83.585  1.00 25.96           O
ATOM    152  N   ARG    19      18.228  40.019  82.802  1.00 25.80           N
ATOM    153  CA  ARG    19      19.454  40.500  83.446  0.50 26.04           C
ATOM    155  CB  ARG    19      19.863  41.870  82.902  0.50 26.63           C
ATOM    157  CG  ARG    19      20.266  41.792  81.431  0.50 28.42           C
ATOM    159  CD  ARG    19      20.814  43.097  80.908  0.50 33.31           C
ATOM    161  NE  ARG    19      22.100  43.450  81.509  0.50 36.36           N
ATOM    163  CZ  ARG    19      23.284  43.173  80.967  0.50 38.03           C
ATOM    165  NH1 ARG    19      23.360  42.527  79.802  0.50 37.79           N
ATOM    167  NH2 ARG    19      24.395  43.547  81.592  0.50 38.32           N
ATOM    169  C   ARG    19      19.328  40.492  84.970  1.00 26.05           C
ATOM    170  O   ARG    19      20.254  40.032  85.653  1.00 25.56           O
ATOM    171  N   GLY    20      18.185  40.978  85.489  1.00 25.65           N
ATOM    172  CA  GLY    20      17.898  40.939  86.941  1.00 25.86           C
ATOM    173  C   GLY    20      17.802  39.514  87.472  1.00 25.67           C
ATOM    174  O   GLY    20      18.340  39.205  88.531  1.00 25.83           O
ATOM    175  N   ILE    21      17.082  38.657  86.746  1.00 25.96           N
ATOM    176  CA  ILE    21      16.930  37.230  87.086  1.00 24.89           C
ATOM    177  CB  ILE    21      15.928  36.485  86.153  1.00 24.71           C
ATOM    178  CG1 ILE    21      14.468  37.000  86.334  1.00 22.97           C
ATOM    179  CD1 ILE    21      13.486  36.498  85.345  1.00 23.93           C
ATOM    180  CG2 ILE    21      15.993  34.939  86.382  1.00 24.75           C
ATOM    181  C   ILE    21      18.272  36.513  87.118  1.00 25.94           C
ATOM    182  O   ILE    21      18.568  35.813  88.092  1.00 28.04           O
ATOM    183  N   VAL    22      19.102  36.677  86.098  1.00 25.95           N
ATOM    184  CA  VAL    22      20.438  36.039  86.110  1.00 26.55           C
ATOM    185  CB  VAL    22      21.199  36.235  84.782  1.00 27.39           C
ATOM    186  CG1 VAL    22      22.753  35.940  84.948  1.00 26.72           C
ATOM    187  CG2 VAL    22      20.569  35.413  83.637  1.00 26.40           C
ATOM    188  C   VAL    22      21.314  36.546  87.267  1.00 26.76           C
ATOM    189  O   VAL    22      22.037  35.767  87.887  1.00 25.07           O
ATOM    190  N   THR    23      21.254  37.854  87.561  1.00 27.27           N
ATOM    191  CA  THR    23      22.043  38.424  88.674  1.00 27.43           C
ATOM    192  CB  THR    23      21.883  39.950  88.741  1.00 28.02           C
ATOM    193  OG1 THR    23      22.366  40.506  87.529  1.00 28.87           O
ATOM    194  CG2 THR    23      22.672  40.545  89.947  1.00 28.56           C
ATOM    195  C   THR    23      21.670  37.808  90.029  1.00 27.05           C
ATOM    196  O   THR    23      22.537  37.469  90.850  1.00 26.13           O
ATOM    197  N   CYS    24      20.369  37.652  90.254  1.00 26.85           N
ATOM    198  CA  CYS    24      19.873  37.136  91.525  1.00 26.73           C
ATOM    199  CB  CYS    24      18.362  37.448  91.682  1.00 25.40           C
ATOM    200  SG  CYS    24      18.046  39.289  91.751  1.00 25.35           S
ATOM    201  C   CYS    24      20.150  35.630  91.705  1.00 27.56           C
ATOM    202  O   CYS    24      20.584  35.192  92.794  1.00 27.03           O
ATOM    203  N   PHE    25      19.901  34.853  90.650  1.00 27.63           N
ATOM    204  CA  PHE    25      20.230  33.414  90.679  1.00 28.09           C
ATOM    205  CB  PHE    25      19.819  32.678  89.403  1.00 26.94           C
ATOM    206  CG  PHE    25      18.417  32.106  89.449  1.00 29.51           C
ATOM    207  CD1 PHE    25      17.426  32.624  88.629  1.00 27.94           C
ATOM    208  CE1 PHE    25      16.112  32.110  88.663  1.00 28.76           C
ATOM    209  CZ  PHE    25      15.799  31.079  89.552  1.00 27.62           C
ATOM    210  CE2 PHE    25      16.803  30.546  90.375  1.00 31.73           C
ATOM    211  CD2 PHE    25      18.097  31.047  90.314  1.00 28.80           C
ATOM    212  C   PHE    25      21.703  33.222  90.899  1.00 27.74           C
ATOM    213  O   PHE    25      22.097  32.354  91.684  1.00 29.15           O
ATOM    214  N   ARG    26      22.524  34.010  90.213  1.00 27.88           N
ATOM    215  CA  ARG    26      23.978  33.823  90.308  1.00 28.42           C
ATOM    216  CB  ARG    26      24.713  34.601  89.198  1.00 28.29           C
ATOM    217  CG  ARG    26      26.238  34.359  89.167  1.00 29.57           C
ATOM    218  CD  ARG    26      26.980  34.899  87.936  1.00 29.18           C
ATOM    219  NE  ARG    26      26.549  34.419  86.600  1.00 30.97           N
ATOM    220  CZ  ARG    26      26.561  33.155  86.165  1.00 30.81           C
ATOM    221  NH1 ARG    26      26.934  32.159  86.957  1.00 30.26           N
ATOM    222  NH2 ARG    26      26.155  32.877  84.929  1.00 27.64           N
ATOM    223  C   ARG    26      24.526  34.138  91.711  1.00 28.16           C
ATOM    224  O   ARG    26      25.384  33.418  92.226  1.00 27.54           O
ATOM    225  N   SER    27      24.056  35.235  92.319  1.00 27.95           N
ATOM    226  CA  SER    27      24.483  35.597  93.666  0.50 27.47           C
ATOM    228  CB  SER    27      23.739  36.840  94.141  0.50 27.42           C
ATOM    230  OG  SER    27      24.178  37.951  93.400  0.50 27.80           O
ATOM    232  C   SER    27      24.271  34.432  94.639  1.00 27.30           C
ATOM    233  O   SER    27      25.197  34.015  95.305  1.00 27.61           O
ATOM    234  N   VAL    28      23.052  33.905  94.686  1.00 26.45           N
ATOM    235  CA  VAL    28      22.674  32.755  95.531  1.00 26.89           C
ATOM    236  CB  VAL    28      21.135  32.478  95.479  1.00 27.16           C
ATOM    237  CG1 VAL    28      20.756  31.357  96.422  1.00 24.69           C
ATOM    238  CG2 VAL    28      20.357  33.764  95.817  1.00 26.07           C
ATOM    239  C   VAL    28      23.447  31.484  95.190  1.00 27.64           C
ATOM    240  O   VAL    28      24.032  30.875  96.082  1.00 28.22           O
ATOM    241  N   LEU    29      23.503  31.099  93.912  1.00 27.37           N
ATOM    242  CA  LEU    29      24.213  29.857  93.522  1.00 28.25           C
ATOM    243  CB  LEU    29      24.109  29.593  92.015  1.00 28.45           C
ATOM    244  CG  LEU    29      22.726  29.208  91.464  1.00 29.00           C
ATOM    245  CD1 LEU    29      22.666  29.470  89.947  1.00 26.59           C
ATOM    246  CD2 LEU    29      22.373  27.730  91.821  1.00 29.02           C
ATOM    247  C   LEU    29      25.678  29.901  93.916  1.00 28.97           C
ATOM    248  O   LEU    29      26.217  28.916  94.424  1.00 28.08           O
ATOM    249  N   GLU    30      26.300  31.069  93.709  1.00 28.53           N
ATOM    250  CA  GLU    30      27.712  31.226  93.990  1.00 29.77           C
ATOM    251  CB  GLU    30      28.324  32.327  93.104  1.00 29.25           C
ATOM    252  CG  GLU    30      28.123  31.934  91.613  1.00 32.11           C
ATOM    253  CD  GLU    30      28.977  32.698  90.590  1.00 33.14           C
ATOM    254  OE1 GLU    30      29.451  33.828  90.882  1.00 36.50           O
ATOM    255  OE2 GLU    30      29.133  32.147  89.461  1.00 36.09           O
ATOM    256  C   GLU    30      28.017  31.373  95.490  1.00 29.27           C
ATOM    257  O   GLU    30      29.077  30.947  95.931  1.00 28.69           O
ATOM    258  N   ARG    31      27.092  31.924  96.283  1.00 28.86           N
ATOM    259  CA  ARG    31      27.307  31.954  97.728  0.50 28.90           C
ATOM    261  CB  ARG    31      26.330  32.888  98.438  0.50 28.90           C
ATOM    263  CG  ARG    31      26.840  34.324  98.552  0.50 30.25           C
ATOM    265  CD  ARG    31      25.762  35.237  99.124  0.50 32.63           C
ATOM    267  NE  ARG    31      25.933  36.640  98.735  0.50 32.56           N
ATOM    269  CZ  ARG    31      25.025  37.587  98.954  0.50 32.41           C
ATOM    271  NH1 ARG    31      23.886  37.285  99.557  0.50 33.58           N
ATOM    273  NH2 ARG    31      25.247  38.835  98.564  0.50 32.58           N
ATOM    275  C   ARG    31      27.259  30.550  98.320  1.00 28.59           C
ATOM    276  O   ARG    31      27.828  30.299  99.380  1.00 28.07           O
ATOM    277  N   HIS    32      26.606  29.629  97.618  1.00 28.11           N
ATOM    278  CA  HIS    32      26.520  28.213  98.056  1.00 27.36           C
ATOM    279  CB  HIS    32      25.082  27.701  97.993  1.00 27.06           C
ATOM    280  CG  HIS    32      24.166  28.439  98.915  1.00 29.75           C
ATOM    281  ND1 HIS    32      23.935  28.037 100.210  1.00 29.90           N
ATOM    282  CE1 HIS    32      23.122  28.891 100.798  1.00 31.29           C
ATOM    283  NE2 HIS    32      22.823  29.844  99.931  1.00 33.43           N
ATOM    284  CD2 HIS    32      23.481  29.596  98.752  1.00 29.72           C
ATOM    285  C   HIS    32      27.458  27.267  97.335  1.00 26.95           C
ATOM    286  O   HIS    32      27.357  26.045  97.477  1.00 26.82           O
ATOM    287  N   GLY    33      28.396  27.823  96.585  1.00 27.08           N
ATOM    288  CA  GLY    33      29.522  27.029  96.079  1.00 27.82           C
ATOM    289  C   GLY    33      29.279  26.510  94.672  1.00 28.67           C
ATOM    290  O   GLY    33      30.111  25.775  94.150  1.00 29.18           O
ATOM    291  N   TYR    34      28.154  26.893  94.055  1.00 28.41           N
ATOM    292  CA  TYR    34      27.799  26.396  92.732  1.00 29.53           C
ATOM    293  CB  TYR    34      26.258  26.328  92.567  1.00 30.17           C
ATOM    294  CG  TYR    34      25.622  25.328  93.505  1.00 30.57           C
ATOM    295  CD1 TYR    34      25.627  23.965  93.200  1.00 30.85           C
ATOM    296  CE1 TYR    34      25.053  23.041  94.032  1.00 28.91           C
ATOM    297  CZ  TYR    34      24.477  23.460  95.208  1.00 28.86           C
ATOM    298  OH  TYR    34      23.926  22.531  96.026  1.00 29.07           O
ATOM    299  CE2 TYR    34      24.438  24.804  95.551  1.00 30.83           C
ATOM    300  CD2 TYR    34      25.026  25.733  94.694  1.00 31.63           C
ATOM    301  C   TYR    34      28.450  27.246  91.654  1.00 30.28           C
ATOM    302  O   TYR    34      28.035  28.383  91.420  1.00 32.50           O
ATOM    303  N   THR    35      29.473  26.706  91.004  1.00 30.34           N
ATOM    304  CA  THR    35      30.226  27.444  89.992  1.00 30.36           C
ATOM    305  CB  THR    35      31.744  27.439  90.295  1.00 30.15           C
ATOM    306  OG1 THR    35      32.207  26.087  90.373  1.00 31.03           O
ATOM    307  CG2 THR    35      32.043  28.122  91.593  1.00 30.29           C
ATOM    308  C   THR    35      30.011  26.858  88.601  1.00 30.09           C
ATOM    309  O   THR    35      29.478  25.759  88.459  1.00 29.73           O
ATOM    310  N   GLY    36      30.423  27.616  87.579  1.00 30.97           N
ATOM    311  CA  GLY    36      30.337  27.193  86.168  1.00 31.00           C
ATOM    312  C   GLY    36      28.913  26.995  85.649  1.00 31.00           C
ATOM    313  O   GLY    36      28.680  26.242  84.692  1.00 31.06           O
ATOM    314  N   ILE    37      27.957  27.645  86.303  1.00 30.10           N
ATOM    315  CA  ILE    37      26.598  27.671  85.777  1.00 29.29           C
ATOM    316  CB  ILE    37      25.566  27.724  86.897  1.00 29.00           C
ATOM    317  CG1 ILE    37      25.581  26.392  87.649  1.00 28.44           C
ATOM    318  CD1 ILE    37      24.913  26.451  88.976  1.00 28.07           C
ATOM    319  CG2 ILE    37      24.167  28.102  86.320  1.00 28.30           C
ATOM    320  C   ILE    37      26.493  28.882  84.880  1.00 28.98           C
ATOM    321  O   ILE    37      26.659  30.007  85.347  1.00 30.36           O
ATOM    322  N   THR    38      26.216  28.652  83.598  1.00 28.66           N
ATOM    323  CA  THR    38      26.144  29.711  82.585  1.00 28.14           C
ATOM    324  CB  THR    38      26.280  29.130  81.169  1.00 28.45           C
ATOM    325  OG1 THR    38      25.087  28.398  80.837  1.00 28.74           O
ATOM    326  CG2 THR    38      27.513  28.237  81.063  1.00 26.51           C
ATOM    327  C   THR    38      24.845  30.529  82.605  1.00 27.96           C
ATOM    328  O   THR    38      23.821  30.081  83.120  1.00 27.32           O
ATOM    329  N   ASP    39      24.897  31.739  82.034  1.00 27.46           N
ATOM    330  CA  ASP    39      23.714  32.551  81.894  1.00 27.38           C
ATOM    331  CB  ASP    39      24.037  33.817  81.100  1.00 27.60           C
ATOM    332  CG  ASP    39      24.785  34.880  81.927  1.00 31.78           C
ATOM    333  OD1 ASP    39      25.298  34.578  83.030  1.00 29.76           O
ATOM    334  OD2 ASP    39      24.860  36.041  81.445  1.00 36.82           O
ATOM    335  C   ASP    39      22.581  31.773  81.181  1.00 26.62           C
ATOM    336  O   ASP    39      21.426  31.826  81.579  1.00 24.83           O
ATOM    337  N   ASP    40      22.918  31.086  80.096  1.00 27.24           N
ATOM    338  CA  ASP    40      21.919  30.311  79.342  1.00 27.15           C
ATOM    339  CB  ASP    40      22.520  29.713  78.068  1.00 27.25           C
ATOM    340  CG  ASP    40      22.692  30.744  76.967  1.00 29.12           C
ATOM    341  OD1 ASP    40      22.169  31.883  77.079  1.00 31.87           O
ATOM    342  OD2 ASP    40      23.385  30.427  75.997  1.00 31.62           O
ATOM    343  C   ASP    40      21.226  29.238  80.146  1.00 26.69           C
ATOM    344  O   ASP    40      20.010  29.019  79.964  1.00 26.44           O
ATOM    345  N   MET    41      21.990  28.545  80.996  1.00 27.53           N
ATOM    346  CA  MET    41      21.426  27.505  81.881  1.00 27.55           C
ATOM    347  CB  MET    41      22.518  26.766  82.672  1.00 28.11           C
ATOM    348  CG  MET    41      23.386  25.824  81.832  1.00 27.79           C
ATOM    349  SD  MET    41      24.933  25.250  82.817  0.70 27.86          SE
ATOM    350  CE  MET    41      26.300  25.146  81.476  1.00 33.34           C
ATOM    351  C   MET    41      20.394  28.130  82.818  1.00 26.96           C
ATOM    352  O   MET    41      19.331  27.583  83.044  1.00 26.08           O
ATOM    353  N   ILE    42      20.699  29.311  83.318  1.00 26.33           N
ATOM    354  CA  ILE    42      19.756  30.031  84.158  1.00 25.61           C
ATOM    355  CB  ILE    42      20.467  31.166  84.926  1.00 26.25           C
ATOM    356  CG1 ILE    42      21.518  30.578  85.900  1.00 25.24           C
ATOM    357  CD1 ILE    42      22.476  31.678  86.549  1.00 26.44           C
ATOM    358  CG2 ILE    42      19.420  32.075  85.688  1.00 26.19           C
ATOM    359  C   ILE    42      18.535  30.514  83.347  1.00 25.25           C
ATOM    360  O   ILE    42      17.389  30.269  83.724  1.00 24.15           O
ATOM    361  N   LYS    43      18.796  31.173  82.222  1.00 25.38           N
ATOM    362  CA  LYS    43      17.745  31.762  81.378  1.00 25.62           C
ATOM    363  CB  LYS    43      18.346  32.551  80.214  1.00 26.03           C
ATOM    364  CG  LYS    43      19.143  33.810  80.616  1.00 26.23           C
ATOM    365  CD  LYS    43      19.957  34.262  79.388  1.00 24.38           C
ATOM    366  CE  LYS    43      20.240  35.735  79.486  1.00 27.35           C
ATOM    367  NZ  LYS    43      20.904  36.212  78.237  1.00 26.10           N
ATOM    368  C   LYS    43      16.764  30.710  80.868  1.00 25.85           C
ATOM    369  O   LYS    43      15.580  30.994  80.724  1.00 24.83           O
ATOM    370  N   ARG    44      17.245  29.490  80.614  1.00 26.35           N
ATOM    371  CA  ARG    44      16.340  28.422  80.197  1.00 26.97           C
ATOM    372  CB  ARG    44      17.104  27.195  79.656  1.00 26.69           C
ATOM    373  CG  ARG    44      17.754  27.390  78.281  1.00 30.37           C
ATOM    374  CD  ARG    44      16.801  27.313  77.108  1.00 35.96           C
ATOM    375  NE  ARG    44      16.393  25.938  76.823  1.00 40.15           N
ATOM    376  CZ  ARG    44      15.490  25.586  75.902  1.00 42.70           C
ATOM    377  NH1 ARG    44      14.886  26.506  75.145  1.00 41.39           N
ATOM    378  NH2 ARG    44      15.193  24.300  75.727  1.00 43.13           N
ATOM    379  C   ARG    44      15.321  28.009  81.277  1.00 27.28           C
ATOM    380  O   ARG    44      14.303  27.401  80.948  1.00 27.71           O
ATOM    381  N   THR    45      15.593  28.311  82.547  1.00 27.15           N
ATOM    382  CA  THR    45      14.644  28.019  83.619  1.00 27.61           C
ATOM    383  CB  THR    45      15.326  27.716  84.985  1.00 27.21           C
ATOM    384  OG1 THR    45      15.843  28.937  85.551  1.00 29.09           O
ATOM    385  CG2 THR    45      16.436  26.718  84.856  1.00 27.55           C
ATOM    386  C   THR    45      13.690  29.185  83.899  1.00 27.14           C
ATOM    387  O   THR    45      12.780  29.023  84.684  1.00 28.51           O
ATOM    388  N   ILE    46      13.924  30.360  83.309  1.00 26.38           N
ATOM    389  CA  ILE    46      13.058  31.514  83.513  1.00 24.81           C
ATOM    390  CB  ILE    46      13.543  32.775  82.746  1.00 24.83           C
ATOM    391  CG1 ILE    46      14.857  33.293  83.339  1.00 25.02           C
ATOM    392  CD1 ILE    46      15.489  34.510  82.591  1.00 22.94           C
ATOM    393  CG2 ILE    46      12.504  33.893  82.822  1.00 26.55           C
ATOM    394  C   ILE    46      11.598  31.192  83.185  1.00 24.69           C
ATOM    395  O   ILE    46      11.268  30.770  82.062  1.00 25.30           O
ATOM    396  N   GLY    47      10.732  31.392  84.180  1.00 24.91           N
ATOM    397  CA  GLY    47       9.279  31.139  84.076  1.00 23.33           C
ATOM    398  C   GLY    47       8.809  29.870  84.793  1.00 23.77           C
ATOM    399  O   GLY    47       7.591  29.536  84.791  1.00 23.52           O
ATOM    400  N   LYS    48       9.783  29.127  85.336  1.00 22.70           N
ATOM    401  CA  LYS    48       9.524  28.036  86.281  1.00 23.25           C
ATOM    402  CB  LYS    48      10.654  27.002  86.214  1.00 22.45           C
ATOM    403  CG  LYS    48      10.857  26.464  84.806  1.00 27.54           C
ATOM    404  CD  LYS    48      11.350  25.061  84.810  1.00 32.31           C
ATOM    405  CE  LYS    48      11.689  24.601  83.391  1.00 36.95           C
ATOM    406  NZ  LYS    48      10.491  23.938  82.814  1.00 36.79           N
ATOM    407  C   LYS    48       9.493  28.706  87.663  1.00 22.37           C
ATOM    408  O   LYS    48       9.928  29.880  87.789  1.00 21.60           O
ATOM    409  N   THR    49       8.989  28.002  88.676  1.00 21.17           N
ATOM    410  CA  THR    49       9.003  28.561  90.050  1.00 22.17           C
ATOM    411  CB  THR    49       8.244  27.708  91.077  1.00 20.87           C
ATOM    412  OG1 THR    49       8.903  26.437  91.242  1.00 23.38           O
ATOM    413  CG2 THR    49       6.760  27.488  90.620  1.00 20.40           C
ATOM    414  C   THR    49      10.457  28.665  90.522  1.00 23.46           C
ATOM    415  O   THR    49      11.310  27.913  90.059  1.00 22.38           O
ATOM    416  N   LEU    50      10.739  29.592  91.434  1.00 24.65           N
ATOM    417  CA  LEU    50      12.127  29.725  91.953  1.00 25.29           C
ATOM    418  CB  LEU    50      12.165  30.782  93.045  1.00 25.19           C
ATOM    419  CG  LEU    50      11.881  32.192  92.531  1.00 24.76           C
ATOM    420  CD1 LEU    50      11.707  33.216  93.678  1.00 24.83           C
ATOM    421  CD2 LEU    50      12.921  32.656  91.473  1.00 24.86           C
ATOM    422  C   LEU    50      12.635  28.392  92.498  1.00 25.72           C
ATOM    423  O   LEU    50      13.784  28.031  92.259  1.00 26.37           O
ATOM    424  N   GLU    51      11.762  27.644  93.193  1.00 26.27           N
ATOM    425  CA  GLU    51      12.133  26.327  93.712  1.00 26.53           C
ATOM    426  CB  GLU    51      11.067  25.753  94.662  1.00 26.95           C
ATOM    427  CG  GLU    51      10.799  26.612  95.935  1.00 27.91           C
ATOM    428  CD  GLU    51       9.631  27.616  95.747  1.00 30.98           C
ATOM    429  OE1 GLU    51       9.531  28.225  94.651  1.00 27.84           O
ATOM    430  OE2 GLU    51       8.818  27.796  96.697  1.00 29.30           O
ATOM    431  C   GLU    51      12.495  25.361  92.563  1.00 26.70           C
ATOM    432  O   GLU    51      13.543  24.693  92.622  1.00 26.65           O
ATOM    433  N   GLU    52      11.646  25.293  91.523  1.00 27.02           N
ATOM    434  CA  GLU    52      11.931  24.453  90.331  1.00 26.69           C
ATOM    435  CB  GLU    52      10.818  24.546  89.280  1.00 26.89           C
ATOM    436  CG  GLU    52       9.565  23.708  89.616  1.00 28.41           C
ATOM    437  CD  GLU    52       8.298  24.195  88.906  1.00 28.69           C
ATOM    438  OE1 GLU    52       8.320  25.246  88.220  1.00 31.19           O
ATOM    439  OE2 GLU    52       7.255  23.527  89.047  1.00 31.98           O
ATOM    440  C   GLU    52      13.278  24.832  89.707  1.00 26.26           C
ATOM    441  O   GLU    52      14.060  23.956  89.329  1.00 24.51           O
ATOM    442  N   SER    53      13.532  26.142  89.600  1.00 25.45           N
ATOM    443  CA  SER    53      14.754  26.635  88.976  1.00 26.02           C
ATOM    444  CB  SER    53      14.733  28.183  88.851  1.00 26.87           C
ATOM    445  OG  SER    53      13.863  28.622  87.824  1.00 26.36           O
ATOM    446  C   SER    53      15.994  26.192  89.745  1.00 25.31           C
ATOM    447  O   SER    53      16.960  25.740  89.144  1.00 26.23           O
ATOM    448  N   PHE    54      15.943  26.324  91.074  1.00 24.48           N
ATOM    449  CA  PHE    54      17.041  25.939  91.939  1.00 24.94           C
ATOM    450  CB  PHE    54      16.828  26.429  93.379  1.00 24.22           C
ATOM    451  CG  PHE    54      17.314  27.821  93.595  1.00 24.36           C
ATOM    452  CD1 PHE    54      18.692  28.100  93.537  1.00 25.21           C
ATOM    453  CE1 PHE    54      19.151  29.414  93.696  1.00 23.93           C
ATOM    454  CZ  PHE    54      18.245  30.469  93.922  1.00 22.16           C
ATOM    455  CE2 PHE    54      16.879  30.206  93.962  1.00 21.57           C
ATOM    456  CD2 PHE    54      16.424  28.860  93.808  1.00 24.28           C
ATOM    457  C   PHE    54      17.269  24.459  91.906  1.00 25.07           C
ATOM    458  O   PHE    54      18.403  24.013  91.957  1.00 25.61           O
ATOM    459  N   SER    55      16.185  23.697  91.814  1.00 25.58           N
ATOM    460  CA  SER    55      16.289  22.240  91.782  1.00 25.02           C
ATOM    461  CB  SER    55      14.885  21.632  91.952  1.00 25.86           C
ATOM    462  OG  SER    55      15.001  20.280  92.366  1.00 28.30           O
ATOM    463  C   SER    55      16.974  21.726  90.521  1.00 25.49           C
ATOM    464  O   SER    55      17.877  20.852  90.563  1.00 24.97           O
ATOM    465  N   ILE    56      16.567  22.276  89.382  1.00 25.10           N
ATOM    466  CA  ILE    56      17.206  21.977  88.089  1.00 24.88           C
ATOM    467  CB  ILE    56      16.501  22.738  86.958  1.00 23.93           C
ATOM    468  CG1 ILE    56      15.098  22.148  86.700  1.00 24.64           C
ATOM    469  CD1 ILE    56      14.219  23.069  85.849  1.00 26.32           C
ATOM    470  CG2 ILE    56      17.285  22.712  85.666  1.00 23.81           C
ATOM    471  C   ILE    56      18.725  22.286  88.101  1.00 25.96           C
ATOM    472  O   ILE    56      19.548  21.464  87.658  1.00 26.22           O
ATOM    473  N   LEU    57      19.077  23.437  88.643  1.00 25.28           N
ATOM    474  CA  LEU    57      20.452  23.926  88.580  1.00 26.41           C
ATOM    475  CB  LEU    57      20.476  25.473  88.677  1.00 26.10           C
ATOM    476  CG  LEU    57      19.797  26.281  87.549  1.00 25.31           C
ATOM    477  CD1 LEU    57      19.590  27.811  87.876  1.00 24.42           C
ATOM    478  CD2 LEU    57      20.549  26.150  86.258  1.00 23.96           C
ATOM    479  C   LEU    57      21.404  23.285  89.603  1.00 26.46           C
ATOM    480  O   LEU    57      22.597  23.162  89.332  1.00 27.03           O
ATOM    481  N   THR    58      20.890  22.907  90.779  1.00 26.54           N
ATOM    482  CA  THR    58      21.703  22.296  91.848  1.00 25.19           C
ATOM    483  CB  THR    58      21.407  22.960  93.218  1.00 24.76           C
ATOM    484  OG1 THR    58      20.040  22.701  93.558  1.00 22.88           O
ATOM    485  CG2 THR    58      21.592  24.487  93.148  1.00 23.07           C
ATOM    486  C   THR    58      21.414  20.794  92.006  1.00 25.76           C
ATOM    487  O   THR    58      22.217  20.058  92.544  1.00 27.33           O
ATOM    488  N   GLY    59      20.252  20.343  91.561  1.00 25.51           N
ATOM    489  CA  GLY    59      19.789  18.997  91.902  1.00 24.36           C
ATOM    490  C   GLY    59      19.194  18.863  93.306  1.00 24.11           C
ATOM    491  O   GLY    59      18.716  17.795  93.663  1.00 23.45           O
ATOM    492  N   ILE    60      19.181  19.933  94.109  1.00 24.01           N
ATOM    493  CA  ILE    60      18.608  19.829  95.456  0.60 24.03           C
ATOM    495  CB  ILE    60      18.996  21.031  96.372  0.60 24.36           C
ATOM    497  CG1 ILE    60      20.453  20.901  96.820  0.60 24.92           C
ATOM    499  CD1 ILE    60      21.041  22.199  97.316  0.60 25.59           C
ATOM    501  CG2 ILE    60      18.063  21.154  97.600  0.60 22.40           C
ATOM    503  C   ILE    60      17.097  19.657  95.359  1.00 23.93           C
ATOM    504  O   ILE    60      16.445  20.324  94.582  1.00 24.92           O
ATOM    505  N   THR    61      16.553  18.731  96.142  1.00 24.07           N
ATOM    506  CA  THR    61      15.102  18.557  96.226  1.00 24.63           C
ATOM    507  CB  THR    61      14.642  17.146  95.788  1.00 25.05           C
ATOM    508  OG1 THR    61      15.257  16.165  96.623  1.00 25.67           O
ATOM    509  CG2 THR    61      15.008  16.884  94.295  1.00 23.70           C
ATOM    510  C   THR    61      14.546  18.812  97.622  1.00 25.41           C
ATOM    511  O   THR    61      13.327  18.874  97.799  1.00 25.44           O
ATOM    512  N   ASP    62      15.414  18.953  98.616  1.00 25.97           N
ATOM    513  CA  ASP    62      14.940  19.168  99.975  1.00 26.85           C
ATOM    514  CB  ASP    62      16.123  19.263 100.924  1.00 27.34           C
ATOM    515  CG  ASP    62      15.686  19.493 102.364  1.00 27.87           C
ATOM    516  OD1 ASP    62      15.320  18.536 103.033  1.00 26.73           O
ATOM    517  OD2 ASP    62      15.681  20.648 102.808  1.00 29.98           O
ATOM    518  C   ASP    62      14.055  20.416 100.096  1.00 27.29           C
ATOM    519  O   ASP    62      14.498  21.513  99.759  1.00 27.17           O
ATOM    520  N   ALA    63      12.815  20.247 100.578  1.00 27.89           N
ATOM    521  CA  ALA    63      11.841  21.362 100.623  1.00 28.56           C
ATOM    522  CB  ALA    63      10.473  20.885 101.185  1.00 29.00           C
ATOM    523  C   ALA    63      12.365  22.574 101.413  1.00 28.72           C
ATOM    524  O   ALA    63      12.181  23.737 100.997  1.00 28.41           O
ATOM    525  N   ASP    64      13.062  22.286 102.519  1.00 28.89           N
ATOM    526  CA  ASP    64      13.636  23.318 103.381  1.00 29.22           C
ATOM    527  CB  ASP    64      14.104  22.745 104.727  1.00 29.26           C
ATOM    528  CG  ASP    64      12.955  22.355 105.612  1.00 31.48           C
ATOM    529  OD1 ASP    64      11.883  22.985 105.491  1.00 33.02           O
ATOM    530  OD2 ASP    64      13.117  21.425 106.436  1.00 32.85           O
ATOM    531  C   ASP    64      14.761  24.101 102.734  1.00 28.56           C
ATOM    532  O   ASP    64      14.778  25.332 102.821  1.00 27.54           O
ATOM    533  N   GLN    65      15.693  23.399 102.094  1.00 28.14           N
ATOM    534  CA  GLN    65      16.797  24.053 101.374  1.00 28.49           C
ATOM    535  CB  GLN    65      17.810  23.019 100.894  1.00 28.50           C
ATOM    536  CG  GLN    65      18.506  22.248 102.012  1.00 29.11           C
ATOM    537  CD  GLN    65      19.533  21.230 101.486  1.00 31.31           C
ATOM    538  OE1 GLN    65      19.302  20.014 101.549  1.00 36.90           O
ATOM    539  NE2 GLN    65      20.665  21.718 100.968  1.00 31.64           N
ATOM    540  C   GLN    65      16.294  24.925 100.207  1.00 27.91           C
ATOM    541  O   GLN    65      16.720  26.065 100.039  1.00 26.59           O
ATOM    542  N   LEU    66      15.354  24.399  99.424  1.00 27.56           N
ATOM    543  CA  LEU    66      14.760  25.168  98.315  1.00 27.18           C
ATOM    544  CB  LEU    66      13.828  24.262  97.500  1.00 26.84           C
ATOM    545  CG  LEU    66      14.384  23.094  96.659  1.00 25.18           C
ATOM    546  CD1 LEU    66      13.259  22.275  95.982  1.00 26.79           C
ATOM    547  CD2 LEU    66      15.394  23.586  95.617  1.00 26.21           C
ATOM    548  C   LEU    66      14.021  26.436  98.781  1.00 27.05           C
ATOM    549  O   LEU    66      14.030  27.475  98.112  1.00 27.94           O
ATOM    550  N   GLU    67      13.384  26.341  99.942  1.00 26.89           N
ATOM    551  CA  GLU    67      12.700  27.468 100.554  1.00 26.69           C
ATOM    552  CB  GLU    67      11.852  27.010 101.775  1.00 25.64           C
ATOM    553  CG  GLU    67      11.223  28.113 102.640  1.00 25.90           C
ATOM    554  CD  GLU    67      10.382  29.109 101.877  1.00 26.46           C
ATOM    555  OE1 GLU    67       9.834  28.789 100.804  1.00 28.66           O
ATOM    556  OE2 GLU    67      10.256  30.247 102.350  1.00 27.59           O
ATOM    557  C   GLU    67      13.737  28.504 100.941  1.00 26.18           C
ATOM    558  O   GLU    67      13.521  29.697 100.822  1.00 27.27           O
ATOM    559  N   SER    68      14.864  28.030 101.412  1.00 25.95           N
ATOM    560  CA  SER    68      15.911  28.898 101.879  1.00 26.31           C
ATOM    561  CB  SER    68      16.905  28.051 102.681  1.00 27.25           C
ATOM    562  OG  SER    68      17.994  28.784 103.157  1.00 29.24           O
ATOM    563  C   SER    68      16.535  29.651 100.699  1.00 26.07           C
ATOM    564  O   SER    68      16.763  30.856 100.805  1.00 25.00           O
ATOM    565  N   PHE    69      16.778  28.949  99.576  1.00 25.50           N
ATOM    566  CA  PHE    69      17.248  29.581  98.336  1.00 25.19           C
ATOM    567  CB  PHE    69      17.395  28.567  97.206  1.00 24.70           C
ATOM    568  CG  PHE    69      18.512  27.567  97.370  1.00 25.53           C
ATOM    569  CD1 PHE    69      19.702  27.887  98.035  1.00 26.70           C
ATOM    570  CE1 PHE    69      20.716  26.931  98.150  1.00 28.65           C
ATOM    571  CZ  PHE    69      20.562  25.651  97.571  1.00 27.03           C
ATOM    572  CE2 PHE    69      19.400  25.335  96.879  1.00 26.24           C
ATOM    573  CD2 PHE    69      18.379  26.292  96.790  1.00 24.38           C
ATOM    574  C   PHE    69      16.257  30.631  97.865  1.00 24.69           C
ATOM    575  O   PHE    69      16.655  31.729  97.486  1.00 25.89           O
ATOM    576  N   ARG    70      14.963  30.295  97.896  1.00 24.28           N
ATOM    577  CA  ARG    70      13.876  31.203  97.490  1.00 23.48           C
ATOM    578  CB  ARG    70      12.516  30.535  97.711  1.00 23.43           C
ATOM    579  CG  ARG    70      11.343  31.373  97.169  1.00 25.93           C
ATOM    580  CD  ARG    70      10.008  30.924  97.709  1.00 25.22           C
ATOM    581  NE  ARG    70       9.848  31.220  99.143  1.00 26.87           N
ATOM    582  CZ  ARG    70       9.657  32.446  99.638  1.00 27.45           C
ATOM    583  NH1 ARG    70       9.620  33.480  98.814  1.00 26.75           N
ATOM    584  NH2 ARG    70       9.495  32.643 100.949  1.00 28.49           N
ATOM    585  C   ARG    70      13.917  32.522  98.251  1.00 23.63           C
ATOM    586  O   ARG    70      13.823  33.591  97.647  1.00 22.87           O
ATOM    587  N   GLN    71      13.983  32.423  99.588  1.00 24.69           N
ATOM    588  CA  GLN    71      14.148  33.569 100.473  1.00 24.47           C
ATOM    589  CB  GLN    71      14.208  33.113 101.938  1.00 24.70           C
ATOM    590  CG  GLN    71      12.897  32.571 102.509  1.00 23.50           C
ATOM    591  CD  GLN    71      13.097  31.859 103.828  1.00 24.98           C
ATOM    592  OE1 GLN    71      14.166  31.958 104.450  1.00 26.69           O
ATOM    593  NE2 GLN    71      12.069  31.118 104.266  1.00 23.32           N
ATOM    594  C   GLN    71      15.412  34.369 100.148  1.00 24.87           C
ATOM    595  O   GLN    71      15.378  35.588 100.119  1.00 24.95           O
ATOM    596  N   GLU    72      16.542  33.690  99.980  1.00 24.71           N
ATOM    597  CA  GLU    72      17.777  34.399  99.663  1.00 25.66           C
ATOM    598  CB  GLU    72      18.938  33.406  99.674  1.00 25.45           C
ATOM    599  CG  GLU    72      19.357  32.975 101.071  1.00 26.54           C
ATOM    600  CD  GLU    72      20.359  31.818 101.078  1.00 28.99           C
ATOM    601  OE1 GLU    72      21.071  31.648 100.085  1.00 32.62           O
ATOM    602  OE2 GLU    72      20.431  31.065 102.092  1.00 33.57           O
ATOM    603  C   GLU    72      17.666  35.107  98.301  1.00 25.67           C
ATOM    604  O   GLU    72      18.076  36.264  98.131  1.00 24.17           O
ATOM    605  N   TYR    73      17.052  34.419  97.340  1.00 25.70           N
ATOM    606  CA  TYR    73      16.782  35.028  96.031  1.00 26.68           C
ATOM    607  CB  TYR    73      16.141  33.993  95.088  1.00 27.29           C
ATOM    608  CG  TYR    73      15.817  34.512  93.695  1.00 28.20           C
ATOM    609  CD1 TYR    73      16.590  34.132  92.591  1.00 31.03           C
ATOM    610  CE1 TYR    73      16.285  34.585  91.282  1.00 29.75           C
ATOM    611  CZ  TYR    73      15.199  35.431  91.091  1.00 29.58           C
ATOM    612  OH  TYR    73      14.893  35.862  89.827  1.00 32.21           O
ATOM    613  CE2 TYR    73      14.401  35.810  92.161  1.00 29.04           C
ATOM    614  CD2 TYR    73      14.705  35.338  93.469  1.00 28.75           C
ATOM    615  C   TYR    73      15.905  36.296  96.138  1.00 26.82           C
ATOM    616  O   TYR    73      16.250  37.340  95.564  1.00 26.25           O
ATOM    617  N   SER    74      14.783  36.199  96.862  0.50 26.64           N
ATOM    619  CA  SER    74      13.862  37.328  97.008  0.50 27.01           C
ATOM    621  CB  SER    74      12.685  36.962  97.910  0.50 27.18           C
ATOM    623  OG  SER    74      11.538  37.724  97.557  0.50 26.47           O
ATOM    625  C   SER    74      14.576  38.564  97.555  0.50 27.39           C
ATOM    627  O   SER    74      14.302  39.694  97.129  0.50 27.58           O
ATOM    629  N   LYS    75      15.496  38.332  98.487  1.00 27.15           N
ATOM    630  CA  LYS    75      16.264  39.395  99.111  1.00 28.12           C
ATOM    631  CB  LYS    75      17.103  38.764 100.231  1.00 28.56           C
ATOM    632  CG  LYS    75      17.802  39.682 101.185  1.00 32.79           C
ATOM    633  CD  LYS    75      18.493  38.854 102.259  1.00 38.68           C
ATOM    634  CE  LYS    75      19.947  39.309 102.517  1.00 38.87           C
ATOM    635  NZ  LYS    75      20.549  38.508 103.616  1.00 39.60           N
ATOM    636  C   LYS    75      17.132  40.113  98.068  1.00 27.74           C
ATOM    637  O   LYS    75      17.167  41.341  98.035  1.00 27.27           O
ATOM    638  N   GLU    76      17.836  39.358  97.232  1.00 27.05           N
ATOM    639  CA  GLU    76      18.574  39.934  96.084  1.00 27.52           C
ATOM    640  CB  GLU    76      19.272  38.825  95.298  1.00 28.38           C
ATOM    641  CG  GLU    76      20.420  38.166  96.041  1.00 32.40           C
ATOM    642  CD  GLU    76      21.373  39.177  96.643  1.00 37.32           C
ATOM    643  OE1 GLU    76      22.041  39.882  95.873  1.00 41.38           O
ATOM    644  OE2 GLU    76      21.445  39.279  97.891  1.00 42.83           O
ATOM    645  C   GLU    76      17.646  40.667  95.132  1.00 26.18           C
ATOM    646  O   GLU    76      17.940  41.796  94.680  1.00 25.71           O
ATOM    647  N   ALA    77      16.503  40.036  94.853  1.00 24.98           N
ATOM    648  CA  ALA    77      15.527  40.597  93.911  1.00 25.01           C
ATOM    649  CB  ALA    77      14.441  39.616  93.558  1.00 24.14           C
ATOM    650  C   ALA    77      14.968  41.921  94.385  1.00 25.02           C
ATOM    651  O   ALA    77      14.687  42.790  93.555  1.00 25.34           O
ATOM    652  N   ASP    78      14.808  42.089  95.700  1.00 24.54           N
ATOM    653  CA  ASP    78      14.370  43.367  96.242  1.00 26.20           C
ATOM    654  CB  ASP    78      14.339  43.313  97.762  1.00 26.67           C
ATOM    655  CG  ASP    78      13.163  42.508  98.284  1.00 27.47           C
ATOM    656  OD1 ASP    78      12.146  42.414  97.575  1.00 25.08           O
ATOM    657  OD2 ASP    78      13.260  41.999  99.413  1.00 30.35           O
ATOM    658  C   ASP    78      15.322  44.469  95.810  1.00 26.21           C
ATOM    659  O   ASP    78      14.900  45.567  95.596  1.00 27.41           O
ATOM    660  N   ILE    79      16.608  44.147  95.685  1.00 26.39           N
ATOM    661  CA  ILE    79      17.655  45.100  95.331  1.00 26.83           C
ATOM    662  CB  ILE    79      19.024  44.667  95.967  1.00 26.42           C
ATOM    663  CG1 ILE    79      18.905  44.596  97.489  1.00 28.17           C
ATOM    664  CD1 ILE    79      19.940  43.679  98.124  1.00 32.50           C
ATOM    665  CG2 ILE    79      20.171  45.656  95.620  1.00 26.87           C
ATOM    666  C   ILE    79      17.801  45.282  93.803  1.00 27.25           C
ATOM    667  O   ILE    79      17.844  46.412  93.298  1.00 27.67           O
ATOM    668  N   TYR    80      17.850  44.175  93.065  1.00 28.09           N
ATOM    669  CA  TYR    80      18.283  44.231  91.669  1.00 29.09           C
ATOM    670  CB  TYR    80      19.430  43.251  91.445  1.00 30.35           C
ATOM    671  CG  TYR    80      20.624  43.542  92.288  1.00 31.85           C
ATOM    672  CD1 TYR    80      21.417  44.656  92.027  1.00 33.38           C
ATOM    673  CE1 TYR    80      22.552  44.925  92.804  1.00 34.84           C
ATOM    674  CZ  TYR    80      22.891  44.051  93.829  1.00 34.31           C
ATOM    675  OH  TYR    80      24.003  44.316  94.596  1.00 37.11           O
ATOM    676  CE2 TYR    80      22.118  42.931  94.100  1.00 33.96           C
ATOM    677  CD2 TYR    80      20.994  42.679  93.330  1.00 33.10           C
ATOM    678  C   TYR    80      17.249  43.990  90.600  1.00 28.71           C
ATOM    679  O   TYR    80      17.465  44.332  89.439  1.00 29.24           O
ATOM    680  N   MET    81      16.145  43.358  90.959  1.00 29.54           N
ATOM    681  CA  MET    81      15.196  42.853  89.940  1.00 28.80           C
ATOM    682  CB  MET    81      14.077  42.026  90.588  1.00 28.41           C
ATOM    683  CG  MET    81      13.115  41.381  89.582  1.00 28.54           C
ATOM    684  SD  MET    81      14.037  40.229  88.311  0.70 27.31          SE
ATOM    685  CE  MET    81      14.470  38.788  89.533  1.00 30.27           C
ATOM    686  C   MET    81      14.613  43.911  89.010  1.00 29.54           C
ATOM    687  O   MET    81      14.888  43.911  87.811  1.00 29.33           O
ATOM    688  N   ASN    82      13.792  44.807  89.546  1.00 29.64           N
ATOM    689  CA  ASN    82      13.108  45.772  88.689  1.00 29.82           C
ATOM    690  CB  ASN    82      11.882  46.382  89.386  1.00 29.60           C
ATOM    691  CG  ASN    82      10.784  45.340  89.651  1.00 30.77           C
ATOM    692  OD1 ASN    82      10.740  44.270  89.017  1.00 27.12           O
ATOM    693  ND2 ASN    82       9.870  45.668  90.561  1.00 31.10           N
ATOM    694  C   ASN    82      14.039  46.813  88.082  1.00 29.59           C
ATOM    695  O   ASN    82      13.738  47.380  87.033  1.00 29.59           O
ATOM    696  N   ALA    83      15.190  47.031  88.711  1.00 29.49           N
ATOM    697  CA  ALA    83      16.180  47.968  88.163  1.00 29.25           C
ATOM    698  CB  ALA    83      17.229  48.309  89.216  1.00 28.99           C
ATOM    699  C   ALA    83      16.845  47.377  86.920  1.00 29.57           C
ATOM    700  O   ALA    83      17.412  48.104  86.104  1.00 29.19           O
ATOM    701  N   ASN    84      16.807  46.047  86.816  1.00 29.10           N
ATOM    702  CA  ASN    84      17.450  45.340  85.729  1.00 29.00           C
ATOM    703  CB  ASN    84      18.540  44.429  86.283  1.00 29.02           C
ATOM    704  CG  ASN    84      19.706  45.231  86.858  1.00 31.57           C
ATOM    705  OD1 ASN    84      20.535  45.742  86.100  1.00 33.11           O
ATOM    706  ND2 ASN    84      19.744  45.396  88.188  1.00 28.26           N
ATOM    707  C   ASN    84      16.402  44.576  84.944  1.00 28.17           C
ATOM    708  O   ASN    84      16.602  43.439  84.537  1.00 27.97           O
ATOM    709  N   THR    85      15.251  45.232  84.789  1.00 27.16           N
ATOM    710  CA  THR    85      14.185  44.777  83.944  1.00 25.13           C
ATOM    711  CB  THR    85      12.920  44.432  84.742  1.00 25.07           C
ATOM    712  OG1 THR    85      13.158  43.304  85.625  1.00 25.99           O
ATOM    713  CG2 THR    85      11.824  44.062  83.799  1.00 23.70           C
ATOM    714  C   THR    85      13.914  45.945  82.997  1.00 24.02           C
ATOM    715  O   THR    85      13.845  47.113  83.419  1.00 23.39           O
ATOM    716  N   ILE    86      13.762  45.639  81.713  1.00 23.54           N
ATOM    717  CA  ILE    86      13.426  46.681  80.718  1.00 22.56           C
ATOM    718  CB  ILE    86      14.574  46.876  79.682  1.00 23.19           C
ATOM    719  CG1 ILE    86      14.888  45.576  78.937  1.00 21.71           C
ATOM    720  CD1 ILE    86      15.941  45.757  77.811  1.00 21.68           C
ATOM    721  CG2 ILE    86      15.863  47.412  80.376  1.00 24.58           C
ATOM    722  C   ILE    86      12.104  46.310  80.016  1.00 22.41           C
ATOM    723  O   ILE    86      11.770  45.125  79.931  1.00 22.12           O
ATOM    724  N   LEU    87      11.383  47.301  79.495  1.00 20.46           N
ATOM    725  CA  LEU    87      10.271  47.047  78.556  1.00 21.06           C
ATOM    726  CB  LEU    87       9.527  48.370  78.228  1.00 20.51           C
ATOM    727  CG  LEU    87       8.794  49.100  79.348  1.00 20.09           C
ATOM    728  CD1 LEU    87       8.384  50.552  78.995  1.00 16.88           C
ATOM    729  CD2 LEU    87       7.596  48.304  79.781  1.00 18.68           C
ATOM    730  C   LEU    87      10.799  46.471  77.222  1.00 21.20           C
ATOM    731  O   LEU    87      11.927  46.754  76.831  1.00 21.66           O
ATOM    732  N   PHE    88       9.987  45.674  76.538  1.00 20.05           N
ATOM    733  CA  PHE    88      10.257  45.319  75.142  1.00 20.27           C
ATOM    734  CB  PHE    88       9.515  44.018  74.724  1.00 19.56           C
ATOM    735  CG  PHE    88      10.201  42.735  75.188  1.00 20.59           C
ATOM    736  CD1 PHE    88      11.463  42.382  74.702  1.00 23.45           C
ATOM    737  CE1 PHE    88      12.081  41.228  75.105  1.00 22.55           C
ATOM    738  CZ  PHE    88      11.481  40.419  76.026  1.00 20.15           C
ATOM    739  CE2 PHE    88      10.225  40.743  76.509  1.00 24.68           C
ATOM    740  CD2 PHE    88       9.595  41.893  76.090  1.00 21.23           C
ATOM    741  C   PHE    88       9.828  46.473  74.259  1.00 20.40           C
ATOM    742  O   PHE    88       8.905  47.226  74.628  1.00 21.31           O
ATOM    743  N   PRO    89      10.505  46.651  73.100  1.00 20.26           N
ATOM    744  CA  PRO    89      10.186  47.730  72.178  1.00 20.40           C
ATOM    745  CB  PRO    89      11.007  47.367  70.922  1.00 20.36           C
ATOM    746  CG  PRO    89      12.204  46.716  71.480  1.00 21.73           C
ATOM    747  CD  PRO    89      11.653  45.860  72.614  1.00 20.33           C
ATOM    748  C   PRO    89       8.712  47.879  71.828  1.00 20.08           C
ATOM    749  O   PRO    89       8.274  48.994  71.528  1.00 20.03           O
ATOM    750  N   ASP    90       7.968  46.772  71.838  1.00 20.35           N
ATOM    751  CA  ASP    90       6.579  46.769  71.395  1.00 20.75           C
ATOM    752  CB  ASP    90       6.297  45.545  70.510  1.00 21.27           C
ATOM    753  CG  ASP    90       7.023  45.583  69.186  1.00 22.79           C
ATOM    754  OD1 ASP    90       7.466  46.661  68.743  1.00 24.07           O
ATOM    755  OD2 ASP    90       7.119  44.521  68.561  1.00 25.29           O
ATOM    756  C   ASP    90       5.548  46.757  72.517  1.00 20.34           C
ATOM    757  O   ASP    90       4.351  46.681  72.247  1.00 20.78           O
ATOM    758  N   THR    91       5.989  46.807  73.765  1.00 20.54           N
ATOM    759  CA  THR    91       5.087  46.550  74.890  1.00 19.97           C
ATOM    760  CB  THR    91       5.857  46.390  76.213  1.00 19.95           C
ATOM    761  OG1 THR    91       6.664  45.219  76.137  1.00 22.13           O
ATOM    762  CG2 THR    91       4.911  46.239  77.384  1.00 20.27           C
ATOM    763  C   THR    91       4.029  47.633  75.011  1.00 19.15           C
ATOM    764  O   THR    91       2.838  47.342  75.001  1.00 18.57           O
ATOM    765  N   LEU    92       4.478  48.877  75.141  1.00 18.33           N
ATOM    766  CA  LEU    92       3.569  49.989  75.332  1.00 18.26           C
ATOM    767  CB  LEU    92       4.323  51.266  75.763  1.00 17.66           C
ATOM    768  CG  LEU    92       5.227  51.281  77.007  1.00 15.19           C
ATOM    769  CD1 LEU    92       5.965  52.631  77.097  1.00 11.30           C
ATOM    770  CD2 LEU    92       4.395  51.084  78.225  1.00 16.51           C
ATOM    771  C   LEU    92       2.692  50.262  74.103  1.00 18.76           C
ATOM    772  O   LEU    92       1.479  50.461  74.258  1.00 20.01           O
ATOM    773  N   PRO    93       3.285  50.318  72.885  1.00 18.59           N
ATOM    774  CA  PRO    93       2.364  50.587  71.758  1.00 18.67           C
ATOM    775  CB  PRO    93       3.292  50.693  70.536  1.00 18.83           C
ATOM    776  CG  PRO    93       4.698  50.769  71.074  1.00 18.40           C
ATOM    777  CD  PRO    93       4.685  50.178  72.449  1.00 18.35           C
ATOM    778  C   PRO    93       1.340  49.477  71.546  1.00 18.83           C
ATOM    779  O   PRO    93       0.227  49.749  71.129  1.00 18.94           O
ATOM    780  N   THR    94       1.708  48.232  71.826  1.00 19.04           N
ATOM    781  CA  THR    94       0.799  47.110  71.575  1.00 18.95           C
ATOM    782  CB  THR    94       1.516  45.739  71.710  1.00 19.65           C
ATOM    783  OG1 THR    94       2.523  45.622  70.690  1.00 19.01           O
ATOM    784  CG2 THR    94       0.513  44.590  71.527  1.00 18.15           C
ATOM    785  C   THR    94      -0.385  47.186  72.529  1.00 19.25           C
ATOM    786  O   THR    94      -1.541  47.153  72.113  1.00 19.28           O
ATOM    787  N   LEU    95      -0.073  47.296  73.816  1.00 19.96           N
ATOM    788  CA  LEU    95      -1.064  47.294  74.859  1.00 20.68           C
ATOM    789  CB  LEU    95      -0.380  47.224  76.227  1.00 21.67           C
ATOM    790  CG  LEU    95       0.341  45.925  76.619  1.00 22.31           C
ATOM    791  CD1 LEU    95       0.903  46.007  78.025  1.00 26.20           C
ATOM    792  CD2 LEU    95      -0.599  44.775  76.550  1.00 26.86           C
ATOM    793  C   LEU    95      -1.964  48.513  74.739  1.00 21.16           C
ATOM    794  O   LEU    95      -3.156  48.409  75.010  1.00 21.22           O
ATOM    795  N   THR    96      -1.408  49.655  74.304  1.00 21.25           N
ATOM    796  CA  THR    96      -2.213  50.844  74.008  1.00 21.22           C
ATOM    797  CB  THR    96      -1.338  52.040  73.563  1.00 21.29           C
ATOM    798  OG1 THR    96      -0.447  52.403  74.605  1.00 22.50           O
ATOM    799  CG2 THR    96      -2.194  53.256  73.207  1.00 21.56           C
ATOM    800  C   THR    96      -3.212  50.575  72.883  1.00 21.43           C
ATOM    801  O   THR    96      -4.374  50.993  72.946  1.00 20.99           O
ATOM    802  N   HIS    97      -2.737  49.910  71.833  1.00 21.94           N
ATOM    803  CA  HIS    97      -3.573  49.581  70.677  1.00 22.43           C
ATOM    804  CB  HIS    97      -2.729  48.978  69.553  1.00 22.64           C
ATOM    805  CG  HIS    97      -3.449  48.856  68.245  1.00 25.32           C
ATOM    806  ND1 HIS    97      -4.263  47.784  67.938  1.00 28.13           N
ATOM    807  CE1 HIS    97      -4.763  47.944  66.725  1.00 28.68           C
ATOM    808  NE2 HIS    97      -4.302  49.081  66.232  1.00 29.53           N
ATOM    809  CD2 HIS    97      -3.471  49.667  67.160  1.00 26.78           C
ATOM    810  C   HIS    97      -4.720  48.648  71.076  1.00 22.49           C
ATOM    811  O   HIS    97      -5.854  48.863  70.656  1.00 22.54           O
ATOM    812  N   LEU    98      -4.430  47.629  71.890  1.00 22.90           N
ATOM    813  CA  LEU    98      -5.458  46.702  72.362  1.00 23.05           C
ATOM    814  CB  LEU    98      -4.842  45.521  73.120  1.00 22.74           C
ATOM    815  CG  LEU    98      -3.923  44.586  72.326  1.00 20.64           C
ATOM    816  CD1 LEU    98      -3.169  43.591  73.244  1.00 19.50           C
ATOM    817  CD2 LEU    98      -4.696  43.869  71.205  1.00 15.85           C
ATOM    818  C   LEU    98      -6.521  47.403  73.206  1.00 24.50           C
ATOM    819  O   LEU    98      -7.726  47.184  73.018  1.00 24.67           O
ATOM    820  N   LYS    99      -6.088  48.277  74.109  1.00 25.44           N
ATOM    821  CA  LYS    99      -7.014  48.998  74.982  1.00 26.42           C
ATOM    822  CB  LYS    99      -6.260  49.699  76.127  1.00 26.77           C
ATOM    823  CG  LYS    99      -5.628  48.723  77.140  1.00 26.71           C
ATOM    824  CD  LYS    99      -4.999  49.441  78.340  1.00 26.66           C
ATOM    825  CE  LYS    99      -6.024  50.184  79.192  1.00 27.89           C
ATOM    826  NZ  LYS    99      -6.935  49.263  79.920  1.00 27.25           N
ATOM    827  C   LYS    99      -7.900  49.979  74.213  1.00 26.96           C
ATOM    828  O   LYS    99      -9.057  50.203  74.591  1.00 27.40           O
ATOM    829  N   LYS   100      -7.366  50.550  73.134  1.00 27.31           N
ATOM    830  CA  LYS   100      -8.170  51.373  72.221  1.00 27.99           C
ATOM    831  CB  LYS   100      -7.292  52.088  71.196  1.00 27.98           C
ATOM    832  CG  LYS   100      -6.720  53.359  71.726  1.00 28.10           C
ATOM    833  CD  LYS   100      -5.347  53.618  71.174  1.00 28.05           C
ATOM    834  CE  LYS   100      -4.886  55.015  71.598  1.00 27.96           C
ATOM    835  NZ  LYS   100      -3.640  55.417  70.892  1.00 27.88           N
ATOM    836  C   LYS   100      -9.232  50.545  71.508  1.00 28.41           C
ATOM    837  O   LYS   100     -10.315  51.042  71.219  1.00 28.22           O
ATOM    838  N   GLN   101      -8.914  49.284  71.229  1.00 28.51           N
ATOM    839  CA  GLN   101      -9.890  48.354  70.668  1.00 29.51           C
ATOM    840  CB  GLN   101      -9.191  47.086  70.149  1.00 29.23           C
ATOM    841  CG  GLN   101      -8.506  47.273  68.804  1.00 30.53           C
ATOM    842  CD  GLN   101      -7.812  46.019  68.316  1.00 31.28           C
ATOM    843  OE1 GLN   101      -6.947  45.463  68.993  1.00 33.95           O
ATOM    844  NE2 GLN   101      -8.189  45.565  67.126  1.00 33.53           N
ATOM    845  C   GLN   101     -10.974  47.988  71.693  1.00 28.92           C
ATOM    846  O   GLN   101     -12.006  47.445  71.332  1.00 29.19           O
ATOM    847  N   GLY   102     -10.732  48.279  72.970  1.00 28.44           N
ATOM    848  CA  GLY   102     -11.660  47.886  74.028  1.00 27.66           C
ATOM    849  C   GLY   102     -11.490  46.434  74.428  1.00 26.90           C
ATOM    850  O   GLY   102     -12.374  45.836  75.033  1.00 27.53           O
ATOM    851  N   ILE   103     -10.357  45.856  74.068  1.00 25.97           N
ATOM    852  CA  ILE   103      -9.954  44.571  74.592  1.00 25.15           C
ATOM    853  CB  ILE   103      -8.891  43.916  73.657  1.00 25.72           C
ATOM    854  CG1 ILE   103      -9.598  43.387  72.394  1.00 28.75           C
ATOM    855  CD1 ILE   103      -8.858  43.602  71.071  1.00 32.21           C
ATOM    856  CG2 ILE   103      -8.148  42.768  74.356  1.00 24.81           C
ATOM    857  C   ILE   103      -9.470  44.760  76.047  1.00 24.11           C
ATOM    858  O   ILE   103      -8.841  45.775  76.378  1.00 23.64           O
ATOM    859  N   ARG   104      -9.836  43.809  76.905  1.00 22.93           N
ATOM    860  CA  ARG   104      -9.393  43.739  78.295  1.00 22.38           C
ATOM    861  CB  ARG   104     -10.432  43.052  79.189  1.00 21.82           C
ATOM    862  CG  ARG   104     -11.639  43.963  79.511  1.00 22.99           C
ATOM    863  CD  ARG   104     -12.555  43.350  80.543  1.00 23.79           C
ATOM    864  NE  ARG   104     -13.217  42.158  80.016  1.00 26.02           N
ATOM    865  CZ  ARG   104     -13.959  41.322  80.739  1.00 26.04           C
ATOM    866  NH1 ARG   104     -14.138  41.542  82.034  1.00 25.71           N
ATOM    867  NH2 ARG   104     -14.514  40.259  80.165  1.00 24.78           N
ATOM    868  C   ARG   104      -8.044  43.011  78.368  1.00 22.15           C
ATOM    869  O   ARG   104      -7.842  41.976  77.722  1.00 22.69           O
ATOM    870  N   ILE   105      -7.113  43.562  79.132  1.00 21.37           N
ATOM    871  CA  ILE   105      -5.799  42.950  79.221  1.00 21.36           C
ATOM    872  CB  ILE   105      -4.685  43.845  78.615  1.00 21.45           C
ATOM    873  CG1 ILE   105      -4.622  45.208  79.317  1.00 21.21           C
ATOM    874  CD1 ILE   105      -3.372  46.006  78.973  1.00 20.99           C
ATOM    875  CG2 ILE   105      -4.901  44.025  77.098  1.00 22.71           C
ATOM    876  C   ILE   105      -5.508  42.545  80.651  1.00 21.31           C
ATOM    877  O   ILE   105      -6.029  43.114  81.590  1.00 21.58           O
ATOM    878  N   GLY   106      -4.696  41.517  80.814  1.00 21.48           N
ATOM    879  CA  GLY   106      -4.307  41.082  82.138  1.00 21.34           C
ATOM    880  C   GLY   106      -2.972  40.364  82.072  1.00 20.93           C
ATOM    881  O   GLY   106      -2.430  40.139  80.986  1.00 20.08           O
ATOM    882  N   ILE   107      -2.447  40.026  83.243  1.00 20.95           N
ATOM    883  CA  ILE   107      -1.160  39.319  83.378  1.00 20.93           C
ATOM    884  CB  ILE   107      -0.078  40.214  84.049  1.00 21.11           C
ATOM    885  CG1 ILE   107       0.325  41.388  83.152  1.00 20.55           C
ATOM    886  CD1 ILE   107       1.349  42.345  83.836  1.00 20.00           C
ATOM    887  CG2 ILE   107       1.203  39.438  84.401  1.00 20.89           C
ATOM    888  C   ILE   107      -1.370  38.055  84.222  1.00 21.98           C
ATOM    889  O   ILE   107      -1.968  38.122  85.302  1.00 21.96           O
ATOM    890  N   ILE   108      -0.906  36.905  83.738  1.00 23.06           N
ATOM    891  CA  ILE   108      -0.777  35.707  84.608  1.00 24.09           C
ATOM    892  CB  ILE   108      -1.797  34.550  84.282  1.00 25.43           C
ATOM    893  CG1 ILE   108      -3.226  34.916  84.748  1.00 27.07           C
ATOM    894  CD1 ILE   108      -4.015  35.716  83.788  1.00 27.73           C
ATOM    895  CG2 ILE   108      -1.415  33.269  85.006  1.00 23.92           C
ATOM    896  C   ILE   108       0.689  35.245  84.615  1.00 24.05           C
ATOM    897  O   ILE   108       1.273  34.891  83.595  1.00 24.50           O
ATOM    898  N   SER   109       1.303  35.319  85.788  1.00 24.00           N
ATOM    899  CA  SER   109       2.734  35.260  85.873  1.00 23.46           C
ATOM    900  CB  SER   109       3.332  36.695  85.913  1.00 23.91           C
ATOM    901  OG  SER   109       4.739  36.634  86.160  1.00 21.24           O
ATOM    902  C   SER   109       3.136  34.440  87.085  1.00 24.05           C
ATOM    903  O   SER   109       2.362  34.328  88.051  1.00 22.41           O
ATOM    904  N   THR   110       4.331  33.834  87.005  1.00 23.82           N
ATOM    905  CA  THR   110       4.900  33.138  88.158  1.00 24.02           C
ATOM    906  CB  THR   110       5.718  31.885  87.734  1.00 24.80           C
ATOM    907  OG1 THR   110       4.809  30.972  87.111  1.00 21.86           O
ATOM    908  CG2 THR   110       6.364  31.185  88.960  1.00 22.57           C
ATOM    909  C   THR   110       5.661  34.110  89.087  1.00 24.45           C
ATOM    910  O   THR   110       5.845  33.837  90.248  1.00 23.94           O
ATOM    911  N   LYS   111       6.066  35.266  88.559  1.00 24.80           N
ATOM    912  CA  LYS   111       6.752  36.269  89.351  1.00 24.75           C
ATOM    913  CB  LYS   111       7.350  37.371  88.435  1.00 24.57           C
ATOM    914  CG  LYS   111       7.970  38.551  89.191  1.00 26.03           C
ATOM    915  CD  LYS   111       8.796  39.506  88.308  1.00 25.47           C
ATOM    916  CE  LYS   111      10.151  38.911  87.993  1.00 27.08           C
ATOM    917  NZ  LYS   111      10.973  39.860  87.201  1.00 27.31           N
ATOM    918  C   LYS   111       5.720  36.811  90.357  1.00 24.52           C
ATOM    919  O   LYS   111       4.513  36.795  90.083  1.00 24.83           O
ATOM    920  N   TYR   112       6.184  37.252  91.525  1.00 24.03           N
ATOM    921  CA  TYR   112       5.295  37.800  92.532  1.00 23.93           C
ATOM    922  CB  TYR   112       6.074  38.171  93.792  1.00 24.91           C
ATOM    923  CG  TYR   112       6.854  36.992  94.369  1.00 27.15           C
ATOM    924  CD1 TYR   112       6.283  35.716  94.429  1.00 27.45           C
ATOM    925  CE1 TYR   112       7.013  34.611  94.923  1.00 31.08           C
ATOM    926  CZ  TYR   112       8.303  34.796  95.393  1.00 28.86           C
ATOM    927  OH  TYR   112       9.011  33.713  95.913  1.00 31.26           O
ATOM    928  CE2 TYR   112       8.893  36.058  95.356  1.00 28.90           C
ATOM    929  CD2 TYR   112       8.168  37.152  94.823  1.00 27.43           C
ATOM    930  C   TYR   112       4.610  39.032  91.989  1.00 23.41           C
ATOM    931  O   TYR   112       5.260  39.896  91.364  1.00 23.52           O
ATOM    932  N   ARG   113       3.305  39.103  92.232  1.00 21.97           N
ATOM    933  CA  ARG   113       2.489  40.236  91.833  1.00 21.75           C
ATOM    934  CB  ARG   113       1.031  40.019  92.239  1.00 21.73           C
ATOM    935  CG  ARG   113       0.186  41.140  91.722  1.00 23.08           C
ATOM    936  CD  ARG   113      -1.252  40.797  91.585  1.00 29.65           C
ATOM    937  NE  ARG   113      -1.761  40.257  92.820  1.00 30.40           N
ATOM    938  CZ  ARG   113      -2.146  41.000  93.831  1.00 33.13           C
ATOM    939  NH1 ARG   113      -2.106  42.325  93.727  1.00 34.65           N
ATOM    940  NH2 ARG   113      -2.572  40.409  94.936  1.00 35.49           N
ATOM    941  C   ARG   113       2.954  41.569  92.374  1.00 21.21           C
ATOM    942  O   ARG   113       2.925  42.564  91.658  1.00 21.65           O
ATOM    943  N   PHE   114       3.333  41.612  93.656  1.00 20.92           N
ATOM    944  CA  PHE   114       3.889  42.838  94.247  1.00 20.19           C
ATOM    945  CB  PHE   114       4.199  42.677  95.771  1.00 19.97           C
ATOM    946  CG  PHE   114       5.454  41.888  96.080  1.00 18.39           C
ATOM    947  CD1 PHE   114       6.715  42.526  96.088  1.00 19.63           C
ATOM    948  CE1 PHE   114       7.914  41.829  96.387  1.00 17.93           C
ATOM    949  CZ  PHE   114       7.839  40.450  96.701  1.00 20.29           C
ATOM    950  CE2 PHE   114       6.561  39.810  96.724  1.00 20.01           C
ATOM    951  CD2 PHE   114       5.385  40.531  96.404  1.00 18.78           C
ATOM    952  C   PHE   114       5.106  43.323  93.452  1.00 20.47           C
ATOM    953  O   PHE   114       5.327  44.516  93.314  1.00 20.52           O
ATOM    954  N   ARG   115       5.892  42.388  92.933  1.00 20.95           N
ATOM    955  CA  ARG   115       7.085  42.719  92.176  1.00 22.04           C
ATOM    956  CB  ARG   115       7.924  41.466  92.013  1.00 21.74           C
ATOM    957  CG  ARG   115       9.238  41.681  91.270  1.00 24.56           C
ATOM    958  CD  ARG   115      10.299  42.239  92.221  1.00 27.49           C
ATOM    959  NE  ARG   115      10.697  41.201  93.174  1.00 29.27           N
ATOM    960  CZ  ARG   115      11.068  41.414  94.437  1.00 29.39           C
ATOM    961  NH1 ARG   115      11.103  42.653  94.944  1.00 26.15           N
ATOM    962  NH2 ARG   115      11.415  40.371  95.193  1.00 26.91           N
ATOM    963  C   ARG   115       6.720  43.344  90.811  1.00 22.23           C
ATOM    964  O   ARG   115       7.290  44.373  90.398  1.00 21.97           O
ATOM    965  N   ILE   116       5.744  42.721  90.145  1.00 22.57           N
ATOM    966  CA  ILE   116       5.160  43.221  88.902  1.00 23.16           C
ATOM    967  CB  ILE   116       4.157  42.190  88.356  1.00 23.56           C
ATOM    968  CG1 ILE   116       4.920  40.914  87.940  1.00 21.53           C
ATOM    969  CD1 ILE   116       4.033  39.740  87.742  1.00 18.62           C
ATOM    970  CG2 ILE   116       3.257  42.759  87.229  1.00 24.81           C
ATOM    971  C   ILE   116       4.540  44.618  89.039  1.00 23.20           C
ATOM    972  O   ILE   116       4.736  45.471  88.178  1.00 23.95           O
ATOM    973  N   LEU   117       3.824  44.851  90.128  1.00 23.18           N
ATOM    974  CA  LEU   117       3.142  46.131  90.333  1.00 22.97           C
ATOM    975  CB  LEU   117       2.163  46.067  91.507  1.00 23.35           C
ATOM    976  CG  LEU   117       0.893  45.203  91.358  1.00 22.83           C
ATOM    977  CD1 LEU   117       0.263  45.068  92.731  1.00 23.77           C
ATOM    978  CD2 LEU   117      -0.134  45.791  90.389  1.00 25.25           C
ATOM    979  C   LEU   117       4.157  47.220  90.535  1.00 22.48           C
ATOM    980  O   LEU   117       4.011  48.312  90.031  1.00 22.68           O
ATOM    981  N   SER   118       5.225  46.896  91.239  1.00 22.82           N
ATOM    982  CA  SER   118       6.278  47.867  91.486  1.00 22.55           C
ATOM    983  CB  SER   118       7.256  47.318  92.508  1.00 22.73           C
ATOM    984  OG  SER   118       8.088  48.377  92.966  1.00 25.80           O
ATOM    985  C   SER   118       6.996  48.249  90.170  1.00 21.80           C
ATOM    986  O   SER   118       7.276  49.429  89.930  1.00 20.84           O
ATOM    987  N   PHE   119       7.255  47.248  89.322  1.00 20.76           N
ATOM    988  CA  PHE   119       7.778  47.477  87.980  1.00 20.24           C
ATOM    989  CB  PHE   119       8.059  46.173  87.223  1.00 18.77           C
ATOM    990  CG  PHE   119       8.569  46.403  85.826  1.00 19.44           C
ATOM    991  CD1 PHE   119       9.929  46.704  85.600  1.00 17.91           C
ATOM    992  CE1 PHE   119      10.385  46.994  84.313  1.00 18.19           C
ATOM    993  CZ  PHE   119       9.518  46.942  83.225  1.00 16.24           C
ATOM    994  CE2 PHE   119       8.161  46.658  83.439  1.00 18.27           C
ATOM    995  CD2 PHE   119       7.703  46.382  84.742  1.00 18.20           C
ATOM    996  C   PHE   119       6.840  48.380  87.183  1.00 20.65           C
ATOM    997  O   PHE   119       7.280  49.372  86.593  1.00 21.93           O
ATOM    998  N   LEU   120       5.556  48.053  87.202  1.00 20.45           N
ATOM    999  CA  LEU   120       4.536  48.767  86.441  1.00 20.84           C
ATOM   1000  CB  LEU   120       3.167  48.044  86.517  1.00 20.93           C
ATOM   1001  CG  LEU   120       3.052  46.558  86.041  1.00 19.24           C
ATOM   1002  CD1 LEU   120       1.658  45.978  86.237  1.00 18.53           C
ATOM   1003  CD2 LEU   120       3.431  46.440  84.584  1.00 20.96           C
ATOM   1004  C   LEU   120       4.380  50.189  86.866  1.00 21.73           C
ATOM   1005  O   LEU   120       4.173  51.072  86.033  1.00 21.80           O
ATOM   1006  N   ARG   121       4.476  50.431  88.166  1.00 22.60           N
ATOM   1007  CA  ARG   121       4.314  51.785  88.694  1.00 23.52           C
ATOM   1008  CB  ARG   121       4.536  51.804  90.209  1.00 23.94           C
ATOM   1009  CG  ARG   121       3.243  51.762  90.989  1.00 26.77           C
ATOM   1010  CD  ARG   121       3.460  52.148  92.462  1.00 32.77           C
ATOM   1011  NE  ARG   121       4.296  51.171  93.166  1.00 36.60           N
ATOM   1012  CZ  ARG   121       3.868  49.993  93.621  1.00 37.23           C
ATOM   1013  NH1 ARG   121       2.606  49.615  93.453  1.00 39.05           N
ATOM   1014  NH2 ARG   121       4.712  49.187  94.242  1.00 37.40           N
ATOM   1015  C   ARG   121       5.175  52.842  88.028  1.00 23.70           C
ATOM   1016  O   ARG   121       4.700  53.965  87.795  1.00 22.66           O
ATOM   1017  N   ASN   122       6.433  52.512  87.738  1.00 24.49           N
ATOM   1018  CA  ASN   122       7.322  53.455  87.040  1.00 25.95           C
ATOM   1019  CB  ASN   122       8.592  53.730  87.849  1.00 26.52           C
ATOM   1020  CG  ASN   122       9.381  52.471  88.149  1.00 27.72           C
ATOM   1021  OD1 ASN   122       8.830  51.376  88.204  1.00 27.80           O
ATOM   1022  ND2 ASN   122      10.678  52.627  88.355  1.00 28.40           N
ATOM   1023  C   ASN   122       7.650  53.134  85.563  1.00 26.81           C
ATOM   1024  O   ASN   122       8.660  53.617  85.024  1.00 25.03           O
ATOM   1025  N   HIS   123       6.782  52.336  84.928  1.00 28.90           N
ATOM   1026  CA  HIS   123       6.824  52.065  83.474  1.00 32.33           C
ATOM   1027  CB  HIS   123       7.437  50.688  83.175  1.00 32.18           C
ATOM   1028  CG  HIS   123       8.880  50.598  83.558  1.00 32.54           C
ATOM   1029  ND1 HIS   123       9.292  50.240  84.824  1.00 34.38           N
ATOM   1030  CE1 HIS   123      10.612  50.292  84.887  1.00 34.14           C
ATOM   1031  NE2 HIS   123      11.067  50.684  83.711  1.00 32.80           N
ATOM   1032  CD2 HIS   123      10.004  50.896  82.868  1.00 32.98           C
ATOM   1033  C   HIS   123       5.481  52.284  82.732  1.00 34.73           C
ATOM   1034  O   HIS   123       5.352  53.269  82.000  1.00 35.69           O
ATOM   1035  N   MET   124       4.488  51.397  82.910  1.00 37.36           N
ATOM   1036  CA  MET   124       3.182  51.538  82.200  1.00 40.60           C
ATOM   1037  CB  MET   124       2.354  50.232  82.186  1.00 40.22           C
ATOM   1038  CG  MET   124       3.145  49.006  82.256  1.00 42.29           C
ATOM   1039  SD  MET   124       3.035  47.774  80.747  1.00 48.28          SE
ATOM   1040  CE  MET   124       4.580  46.586  81.143  1.00 45.73           C
ATOM   1041  C   MET   124       2.350  52.657  82.824  1.00 40.03           C
ATOM   1042  O   MET   124       2.549  52.999  83.991  1.00 39.75           O
ATOM   1043  N   PRO   125       1.431  53.264  82.044  1.00 40.89           N
ATOM   1044  CA  PRO   125       0.446  54.102  82.734  1.00 40.98           C
ATOM   1045  CB  PRO   125      -0.462  54.605  81.603  1.00 41.37           C
ATOM   1046  CG  PRO   125       0.315  54.429  80.344  1.00 41.09           C
ATOM   1047  CD  PRO   125       1.246  53.269  80.576  1.00 40.96           C
ATOM   1048  C   PRO   125      -0.353  53.263  83.731  1.00 41.53           C
ATOM   1049  O   PRO   125      -0.658  52.088  83.461  1.00 41.29           O
ATOM   1050  N   ASP   126      -0.656  53.841  84.889  1.00 41.77           N
ATOM   1051  CA  ASP   126      -1.488  53.161  85.878  1.00 42.26           C
ATOM   1052  CB  ASP   126      -1.283  53.797  87.266  1.00 42.73           C
ATOM   1053  CG  ASP   126      -1.286  52.769  88.412  1.00 44.34           C
ATOM   1054  OD1 ASP   126      -1.670  51.593  88.183  1.00 45.63           O
ATOM   1055  OD2 ASP   126      -0.897  53.153  89.552  1.00 45.51           O
ATOM   1056  C   ASP   126      -2.927  53.356  85.389  1.00 41.58           C
ATOM   1057  O   ASP   126      -3.206  54.386  84.784  1.00 42.21           O
ATOM   1058  N   ASP   127      -3.827  52.389  85.556  1.00 40.52           N
ATOM   1059  CA  ASP   127      -3.526  50.998  85.880  1.00 39.96           C
ATOM   1060  CB  ASP   127      -4.189  50.550  87.197  1.00 40.94           C
ATOM   1061  CG  ASP   127      -5.660  50.984  87.315  1.00 41.90           C
ATOM   1062  OD1 ASP   127      -5.953  52.208  87.369  1.00 42.06           O
ATOM   1063  OD2 ASP   127      -6.518  50.079  87.382  1.00 43.64           O
ATOM   1064  C   ASP   127      -4.042  50.185  84.717  1.00 38.20           C
ATOM   1065  O   ASP   127      -5.256  50.109  84.494  1.00 37.67           O
ATOM   1066  N   TRP   128      -3.113  49.592  83.975  1.00 36.61           N
ATOM   1067  CA  TRP   128      -3.429  49.055  82.644  1.00 35.09           C
ATOM   1068  CB  TRP   128      -2.227  48.948  81.688  1.00 35.80           C
ATOM   1069  CG  TRP   128      -2.234  50.138  80.750  1.00 35.09           C
ATOM   1070  CD1 TRP   128      -3.104  51.208  80.783  1.00 35.72           C
ATOM   1071  NE1 TRP   128      -2.822  52.085  79.763  1.00 35.55           N
ATOM   1072  CE2 TRP   128      -1.742  51.607  79.063  1.00 35.42           C
ATOM   1073  CD2 TRP   128      -1.348  50.383  79.658  1.00 34.71           C
ATOM   1074  CE3 TRP   128      -0.265  49.688  79.118  1.00 33.51           C
ATOM   1075  CZ3 TRP   128       0.399  50.231  78.022  1.00 34.61           C
ATOM   1076  CH2 TRP   128      -0.003  51.446  77.455  1.00 35.73           C
ATOM   1077  CZ2 TRP   128      -1.074  52.152  77.957  1.00 36.45           C
ATOM   1078  C   TRP   128      -4.588  48.100  82.448  1.00 33.02           C
ATOM   1079  O   TRP   128      -5.180  48.096  81.379  1.00 32.97           O
ATOM   1080  N   PHE   129      -4.895  47.198  83.368  1.00 30.83           N
ATOM   1081  CA  PHE   129      -4.519  45.796  83.438  1.00 27.41           C
ATOM   1082  CB  PHE   129      -3.210  45.414  84.131  1.00 27.51           C
ATOM   1083  CG  PHE   129      -2.070  45.221  83.163  1.00 24.74           C
ATOM   1084  CD1 PHE   129      -2.191  44.352  82.086  1.00 22.45           C
ATOM   1085  CE1 PHE   129      -1.154  44.219  81.171  1.00 22.50           C
ATOM   1086  CZ  PHE   129       0.024  44.986  81.326  1.00 23.94           C
ATOM   1087  CE2 PHE   129       0.131  45.854  82.373  1.00 22.97           C
ATOM   1088  CD2 PHE   129      -0.908  45.982  83.279  1.00 22.98           C
ATOM   1089  C   PHE   129      -5.747  45.423  84.247  1.00 26.85           C
ATOM   1090  O   PHE   129      -5.857  45.755  85.438  1.00 26.52           O
ATOM   1091  N   ASP   130      -6.726  44.837  83.571  1.00 24.96           N
ATOM   1092  CA  ASP   130      -7.957  44.475  84.234  1.00 24.19           C
ATOM   1093  CB  ASP   130      -9.012  44.086  83.220  1.00 23.88           C
ATOM   1094  CG  ASP   130      -9.437  45.274  82.371  1.00 27.00           C
ATOM   1095  OD1 ASP   130     -10.486  45.869  82.696  1.00 29.29           O
ATOM   1096  OD2 ASP   130      -8.706  45.627  81.403  1.00 28.94           O
ATOM   1097  C   ASP   130      -7.741  43.441  85.330  1.00 22.92           C
ATOM   1098  O   ASP   130      -8.495  43.397  86.287  1.00 21.95           O
ATOM   1099  N   ILE   131      -6.677  42.649  85.206  1.00 22.22           N
ATOM   1100  CA  ILE   131      -6.307  41.674  86.234  1.00 21.82           C
ATOM   1101  CB  ILE   131      -7.161  40.373  86.146  1.00 21.76           C
ATOM   1102  CG1 ILE   131      -6.930  39.485  87.370  1.00 22.46           C
ATOM   1103  CD1 ILE   131      -8.071  38.538  87.621  1.00 24.67           C
ATOM   1104  CG2 ILE   131      -6.894  39.594  84.846  1.00 19.84           C
ATOM   1105  C   ILE   131      -4.825  41.292  86.164  1.00 21.81           C
ATOM   1106  O   ILE   131      -4.235  41.209  85.074  1.00 22.19           O
ATOM   1107  N   ILE   132      -4.244  41.065  87.334  1.00 20.67           N
ATOM   1108  CA  ILE   132      -2.877  40.621  87.448  1.00 21.67           C
ATOM   1109  CB  ILE   132      -1.857  41.769  87.836  1.00 21.11           C
ATOM   1110  CG1 ILE   132      -1.840  42.854  86.755  1.00 22.05           C
ATOM   1111  CD1 ILE   132      -1.142  44.103  87.131  1.00 20.96           C
ATOM   1112  CG2 ILE   132      -0.429  41.186  87.997  1.00 20.87           C
ATOM   1113  C   ILE   132      -2.934  39.561  88.520  1.00 21.42           C
ATOM   1114  O   ILE   132      -3.402  39.825  89.625  1.00 21.70           O
ATOM   1115  N   ILE   133      -2.490  38.372  88.137  1.00 21.45           N
ATOM   1116  CA  ILE   133      -2.309  37.194  88.992  1.00 21.23           C
ATOM   1117  CB  ILE   133      -3.092  35.998  88.411  1.00 20.64           C
ATOM   1118  CG1 ILE   133      -4.604  36.370  88.251  1.00 20.13           C
ATOM   1119  CD1 ILE   133      -5.347  36.639  89.520  1.00 22.28           C
ATOM   1120  CG2 ILE   133      -2.926  34.728  89.265  1.00 20.74           C
ATOM   1121  C   ILE   133      -0.808  36.909  88.984  1.00 21.77           C
ATOM   1122  O   ILE   133      -0.211  36.748  87.891  1.00 22.24           O
ATOM   1123  N   GLY   134      -0.192  36.907  90.173  1.00 21.68           N
ATOM   1124  CA  GLY   134       1.255  36.614  90.338  1.00 20.93           C
ATOM   1125  C   GLY   134       1.469  35.278  91.048  1.00 21.26           C
ATOM   1126  O   GLY   134       0.500  34.563  91.361  1.00 19.97           O
ATOM   1127  N   GLY   135       2.737  34.925  91.268  1.00 21.56           N
ATOM   1128  CA  GLY   135       3.112  33.682  91.980  1.00 22.36           C
ATOM   1129  C   GLY   135       2.520  33.486  93.377  1.00 23.17           C
ATOM   1130  O   GLY   135       2.158  32.354  93.770  1.00 23.27           O
ATOM   1131  N   GLU   136       2.383  34.563  94.140  1.00 22.75           N
ATOM   1132  CA  GLU   136       1.816  34.428  95.487  1.00 23.36           C
ATOM   1133  CB  GLU   136       2.345  35.554  96.403  1.00 23.73           C
ATOM   1134  CG  GLU   136       1.681  36.950  96.250  1.00 22.57           C
ATOM   1135  CD  GLU   136       2.182  37.801  95.055  1.00 25.96           C
ATOM   1136  OE1 GLU   136       2.283  37.277  93.905  1.00 23.49           O
ATOM   1137  OE2 GLU   136       2.415  39.034  95.256  1.00 24.73           O
ATOM   1138  C   GLU   136       0.247  34.280  95.490  1.00 23.83           C
ATOM   1139  O   GLU   136      -0.369  33.896  96.497  1.00 23.40           O
ATOM   1140  N   ASP   137      -0.387  34.529  94.351  1.00 24.09           N
ATOM   1141  CA  ASP   137      -1.859  34.442  94.272  1.00 25.55           C
ATOM   1142  CB  ASP   137      -2.367  35.311  93.131  1.00 25.10           C
ATOM   1143  CG  ASP   137      -2.097  36.779  93.352  1.00 25.54           C
ATOM   1144  OD1 ASP   137      -2.202  37.277  94.485  1.00 28.50           O
ATOM   1145  OD2 ASP   137      -1.772  37.440  92.373  1.00 26.95           O
ATOM   1146  C   ASP   137      -2.416  33.017  94.111  1.00 25.84           C
ATOM   1147  O   ASP   137      -3.638  32.812  94.093  1.00 26.18           O
ATOM   1148  N   VAL   138      -1.521  32.044  93.978  1.00 26.55           N
ATOM   1149  CA  VAL   138      -1.889  30.650  93.613  1.00 26.36           C
ATOM   1150  CB  VAL   138      -1.768  30.341  92.054  1.00 26.04           C
ATOM   1151  CG1 VAL   138      -2.696  31.284  91.225  1.00 26.27           C
ATOM   1152  CG2 VAL   138      -0.311  30.428  91.540  1.00 25.06           C
ATOM   1153  C   VAL   138      -1.035  29.671  94.398  1.00 26.57           C
ATOM   1154  O   VAL   138       0.097  29.981  94.766  1.00 25.71           O
ATOM   1155  N   THR   139      -1.596  28.497  94.651  1.00 27.30           N
ATOM   1156  CA  THR   139      -0.888  27.445  95.356  1.00 28.33           C
ATOM   1157  CB  THR   139      -1.882  26.536  96.095  1.00 28.71           C
ATOM   1158  OG1 THR   139      -2.459  27.267  97.177  1.00 26.46           O
ATOM   1159  CG2 THR   139      -1.208  25.266  96.628  1.00 30.40           C
ATOM   1160  C   THR   139      -0.005  26.648  94.386  1.00 29.17           C
ATOM   1161  O   THR   139       1.149  26.353  94.701  1.00 29.07           O
ATOM   1162  N   HIS   140      -0.571  26.318  93.219  1.00 29.49           N
ATOM   1163  CA  HIS   140       0.113  25.569  92.172  1.00 29.83           C
ATOM   1164  CB  HIS   140      -0.736  24.403  91.704  1.00 30.06           C
ATOM   1165  CG  HIS   140      -0.980  23.395  92.770  1.00 32.33           C
ATOM   1166  ND1 HIS   140      -2.093  23.429  93.583  1.00 35.12           N
ATOM   1167  CE1 HIS   140      -2.036  22.425  94.439  1.00 36.33           C
ATOM   1168  NE2 HIS   140      -0.925  21.748  94.213  1.00 37.23           N
ATOM   1169  CD2 HIS   140      -0.244  22.340  93.177  1.00 34.03           C
ATOM   1170  C   HIS   140       0.384  26.459  90.995  1.00 29.35           C
ATOM   1171  O   HIS   140      -0.478  27.252  90.580  1.00 28.72           O
ATOM   1172  N   HIS   141       1.574  26.307  90.439  1.00 27.98           N
ATOM   1173  CA  HIS   141       2.080  27.301  89.512  1.00 28.07           C
ATOM   1174  CB  HIS   141       3.463  27.750  90.003  1.00 28.04           C
ATOM   1175  CG  HIS   141       3.393  28.496  91.311  1.00 27.71           C
ATOM   1176  ND1 HIS   141       3.534  27.875  92.534  1.00 25.16           N
ATOM   1177  CE1 HIS   141       3.373  28.759  93.499  1.00 24.61           C
ATOM   1178  NE2 HIS   141       3.107  29.934  92.947  1.00 27.11           N
ATOM   1179  CD2 HIS   141       3.111  29.796  91.580  1.00 27.35           C
ATOM   1180  C   HIS   141       2.111  26.777  88.079  1.00 27.50           C
ATOM   1181  O   HIS   141       2.090  25.571  87.879  1.00 26.78           O
ATOM   1182  N   LYS   142       2.171  27.681  87.093  1.00 27.81           N
ATOM   1183  CA  LYS   142       2.224  27.291  85.662  1.00 28.04           C
ATOM   1184  CB  LYS   142       2.551  28.498  84.772  1.00 27.57           C
ATOM   1185  CG  LYS   142       1.552  29.656  84.827  1.00 28.67           C
ATOM   1186  CD  LYS   142       1.857  30.722  83.749  1.00 28.89           C
ATOM   1187  CE  LYS   142       2.936  31.661  84.217  1.00 28.95           C
ATOM   1188  NZ  LYS   142       3.314  32.608  83.107  1.00 28.98           N
ATOM   1189  C   LYS   142       3.255  26.198  85.486  1.00 27.87           C
ATOM   1190  O   LYS   142       4.327  26.282  86.090  1.00 29.23           O
ATOM   1191  N   PRO   143       2.977  25.166  84.663  1.00 28.29           N
ATOM   1192  CA  PRO   143       1.850  24.958  83.744  1.00 28.58           C
ATOM   1193  CB  PRO   143       2.368  23.876  82.765  1.00 28.89           C
ATOM   1194  CG  PRO   143       3.359  23.086  83.546  1.00 28.98           C
ATOM   1195  CD  PRO   143       3.934  24.034  84.621  1.00 28.62           C
ATOM   1196  C   PRO   143       0.482  24.611  84.362  1.00 28.32           C
ATOM   1197  O   PRO   143      -0.478  24.469  83.636  1.00 27.84           O
ATOM   1198  N   ASP   144       0.368  24.539  85.688  1.00 28.21           N
ATOM   1199  CA  ASP   144      -0.954  24.362  86.294  1.00 28.18           C
ATOM   1200  CB  ASP   144      -0.841  24.248  87.817  1.00 27.62           C
ATOM   1201  CG  ASP   144      -2.147  23.834  88.462  1.00 28.37           C
ATOM   1202  OD1 ASP   144      -2.221  22.711  88.967  1.00 26.19           O
ATOM   1203  OD2 ASP   144      -3.102  24.628  88.476  1.00 27.88           O
ATOM   1204  C   ASP   144      -1.830  25.560  85.908  1.00 27.55           C
ATOM   1205  O   ASP   144      -1.396  26.722  86.028  1.00 27.66           O
ATOM   1206  N   PRO   145      -3.062  25.287  85.416  1.00 28.58           N
ATOM   1207  CA  PRO   145      -3.950  26.371  84.963  1.00 27.87           C
ATOM   1208  CB  PRO   145      -4.988  25.617  84.115  1.00 28.13           C
ATOM   1209  CG  PRO   145      -5.068  24.268  84.760  1.00 28.65           C
ATOM   1210  CD  PRO   145      -3.678  23.948  85.218  1.00 27.05           C
ATOM   1211  C   PRO   145      -4.632  27.194  86.078  1.00 28.17           C
ATOM   1212  O   PRO   145      -5.499  28.029  85.778  1.00 28.46           O
ATOM   1213  N   GLU   146      -4.260  26.975  87.338  1.00 28.42           N
ATOM   1214  CA  GLU   146      -4.968  27.605  88.491  1.00 28.55           C
ATOM   1215  CB  GLU   146      -4.235  27.313  89.807  1.00 28.72           C
ATOM   1216  CG  GLU   146      -5.006  27.727  91.073  1.00 29.01           C
ATOM   1217  CD  GLU   146      -4.199  27.550  92.349  1.00 28.29           C
ATOM   1218  OE1 GLU   146      -3.457  26.547  92.459  1.00 29.73           O
ATOM   1219  OE2 GLU   146      -4.301  28.412  93.245  1.00 27.05           O
ATOM   1220  C   GLU   146      -5.100  29.119  88.339  1.00 28.92           C
ATOM   1221  O   GLU   146      -6.187  29.681  88.500  1.00 28.72           O
ATOM   1222  N   GLY   147      -3.982  29.778  88.050  1.00 29.01           N
ATOM   1223  CA  GLY   147      -3.970  31.229  87.917  1.00 29.73           C
ATOM   1224  C   GLY   147      -4.714  31.721  86.699  1.00 30.25           C
ATOM   1225  O   GLY   147      -5.460  32.706  86.778  1.00 30.55           O
ATOM   1226  N   LEU   148      -4.516  31.031  85.574  1.00 30.39           N
ATOM   1227  CA  LEU   148      -5.191  31.387  84.335  1.00 30.29           C
ATOM   1228  CB  LEU   148      -4.668  30.557  83.142  1.00 29.91           C
ATOM   1229  CG  LEU   148      -5.162  30.971  81.723  1.00 31.16           C
ATOM   1230  CD1 LEU   148      -5.102  32.485  81.462  1.00 30.38           C
ATOM   1231  CD2 LEU   148      -4.345  30.284  80.653  1.00 31.39           C
ATOM   1232  C   LEU   148      -6.712  31.250  84.509  1.00 29.93           C
ATOM   1233  O   LEU   148      -7.459  32.187  84.189  1.00 29.74           O
ATOM   1234  N   LEU   149      -7.156  30.093  85.017  1.00 29.50           N
ATOM   1235  CA  LEU   149      -8.573  29.865  85.290  1.00 29.44           C
ATOM   1236  CB  LEU   149      -8.819  28.417  85.759  1.00 29.53           C
ATOM   1237  CG  LEU   149      -8.523  27.271  84.787  1.00 26.91           C
ATOM   1238  CD1 LEU   149      -8.739  25.945  85.501  1.00 25.33           C
ATOM   1239  CD2 LEU   149      -9.358  27.402  83.497  1.00 24.96           C
ATOM   1240  C   LEU   149      -9.113  30.853  86.320  1.00 30.01           C
ATOM   1241  O   LEU   149     -10.254  31.298  86.206  1.00 30.21           O
ATOM   1242  N   LEU   150      -8.294  31.198  87.315  1.00 30.89           N
ATOM   1243  CA  LEU   150      -8.667  32.200  88.308  1.00 31.50           C
ATOM   1244  CB  LEU   150      -7.596  32.361  89.407  1.00 31.23           C
ATOM   1245  CG  LEU   150      -7.868  33.398  90.522  1.00 31.44           C
ATOM   1246  CD1 LEU   150      -9.066  33.029  91.413  1.00 30.04           C
ATOM   1247  CD2 LEU   150      -6.637  33.653  91.380  1.00 31.62           C
ATOM   1248  C   LEU   150      -8.980  33.552  87.647  1.00 32.69           C
ATOM   1249  O   LEU   150     -10.038  34.150  87.928  1.00 33.35           O
ATOM   1250  N   ALA   151      -8.077  34.021  86.780  1.00 32.59           N
ATOM   1251  CA  ALA   151      -8.261  35.279  86.067  1.00 33.62           C
ATOM   1252  CB  ALA   151      -7.054  35.584  85.235  1.00 33.37           C
ATOM   1253  C   ALA   151      -9.529  35.337  85.205  1.00 34.37           C
ATOM   1254  O   ALA   151     -10.314  36.307  85.307  1.00 34.50           O
ATOM   1255  N   ILE   152      -9.718  34.305  84.366  1.00 35.25           N
ATOM   1256  CA  ILE   152     -10.926  34.126  83.543  1.00 35.62           C
ATOM   1257  CB  ILE   152     -10.934  32.763  82.776  1.00 35.62           C
ATOM   1258  CG1 ILE   152      -9.708  32.606  81.876  1.00 34.67           C
ATOM   1259  CD1 ILE   152      -9.417  31.151  81.476  1.00 34.42           C
ATOM   1260  CG2 ILE   152     -12.206  32.625  81.915  1.00 36.65           C
ATOM   1261  C   ILE   152     -12.189  34.206  84.411  1.00 36.96           C
ATOM   1262  O   ILE   152     -13.165  34.867  84.043  1.00 36.65           O
ATOM   1263  N   ASP   153     -12.150  33.527  85.557  1.00 38.06           N
ATOM   1264  CA  ASP   153     -13.238  33.564  86.541  1.00 38.91           C
ATOM   1265  CB  ASP   153     -12.964  32.594  87.693  1.00 38.78           C
ATOM   1266  CG  ASP   153     -14.020  32.677  88.765  1.00 41.18           C
ATOM   1267  OD1 ASP   153     -15.192  32.354  88.469  1.00 38.13           O
ATOM   1268  OD2 ASP   153     -13.685  33.102  89.896  1.00 46.00           O
ATOM   1269  C   ASP   153     -13.527  34.964  87.090  1.00 39.10           C
ATOM   1270  O   ASP   153     -14.683  35.418  87.096  1.00 39.05           O
ATOM   1271  N   ARG   154     -12.478  35.640  87.550  1.00 39.66           N
ATOM   1272  CA  ARG   154     -12.604  36.995  88.098  1.00 40.18           C
ATOM   1273  CB  ARG   154     -11.289  37.457  88.738  1.00 40.91           C
ATOM   1274  CG  ARG   154     -10.921  36.683  89.989  1.00 42.64           C
ATOM   1275  CD  ARG   154     -10.260  37.574  91.020  1.00 45.63           C
ATOM   1276  NE  ARG   154      -9.328  36.801  91.833  1.00 47.12           N
ATOM   1277  CZ  ARG   154      -8.246  37.312  92.406  1.00 48.26           C
ATOM   1278  NH1 ARG   154      -7.970  38.611  92.256  1.00 47.61           N
ATOM   1279  NH2 ARG   154      -7.434  36.525  93.112  1.00 47.30           N
ATOM   1280  C   ARG   154     -13.095  38.035  87.083  1.00 39.58           C
ATOM   1281  O   ARG   154     -13.827  38.975  87.447  1.00 40.22           O
ATOM   1282  N   LEU   155     -12.690  37.865  85.826  1.00 38.30           N
ATOM   1283  CA  LEU   155     -13.117  38.749  84.739  1.00 37.14           C
ATOM   1284  CB  LEU   155     -12.063  38.749  83.609  1.00 36.73           C
ATOM   1285  CG  LEU   155     -10.662  39.400  83.769  1.00 34.97           C
ATOM   1286  CD1 LEU   155      -9.880  39.218  82.484  1.00 36.15           C
ATOM   1287  CD2 LEU   155     -10.715  40.861  84.079  1.00 34.72           C
ATOM   1288  C   LEU   155     -14.549  38.454  84.183  1.00 37.07           C
ATOM   1289  O   LEU   155     -15.064  39.218  83.354  1.00 36.32           O
ATOM   1290  N   LYS   156     -15.181  37.376  84.671  1.00 36.92           N
ATOM   1291  CA  LYS   156     -16.451  36.848  84.132  1.00 37.01           C
ATOM   1292  CB  LYS   156     -17.680  37.720  84.475  1.00 37.18           C
ATOM   1293  CG  LYS   156     -17.712  38.389  85.856  1.00 38.58           C
ATOM   1294  CD  LYS   156     -17.848  37.411  87.018  1.00 39.61           C
ATOM   1295  CE  LYS   156     -17.923  38.158  88.346  1.00 39.57           C
ATOM   1296  NZ  LYS   156     -19.301  38.673  88.683  1.00 40.82           N
ATOM   1297  C   LYS   156     -16.327  36.676  82.618  1.00 37.01           C
ATOM   1298  O   LYS   156     -17.227  37.042  81.846  1.00 36.54           O
ATOM   1299  N   ALA   157     -15.191  36.124  82.202  1.00 36.76           N
ATOM   1300  CA  ALA   157     -14.923  35.911  80.797  1.00 37.12           C
ATOM   1301  CB  ALA   157     -13.416  36.198  80.460  1.00 36.14           C
ATOM   1302  C   ALA   157     -15.338  34.509  80.356  1.00 37.35           C
ATOM   1303  O   ALA   157     -15.522  33.600  81.181  1.00 38.21           O
ATOM   1304  N   CYS   158     -15.552  34.391  79.050  1.00 37.47           N
ATOM   1305  CA  CYS   158     -15.746  33.106  78.417  0.50 37.00           C
ATOM   1307  CB  CYS   158     -16.872  33.168  77.395  0.50 37.04           C
ATOM   1309  SG  CYS   158     -18.511  32.998  78.148  0.50 36.19           S
ATOM   1311  C   CYS   158     -14.429  32.667  77.787  1.00 37.08           C
ATOM   1312  O   CYS   158     -13.785  33.425  77.050  1.00 37.37           O
ATOM   1313  N   PRO   159     -13.986  31.421  78.103  1.00 36.60           N
ATOM   1314  CA  PRO   159     -12.637  31.046  77.632  1.00 35.62           C
ATOM   1315  CB  PRO   159     -12.479  29.599  78.104  1.00 35.48           C
ATOM   1316  CG  PRO   159     -13.877  29.111  78.347  1.00 36.57           C
ATOM   1317  CD  PRO   159     -14.643  30.306  78.813  1.00 36.59           C
ATOM   1318  C   PRO   159     -12.480  31.161  76.108  1.00 35.34           C
ATOM   1319  O   PRO   159     -11.385  31.435  75.621  1.00 34.76           O
ATOM   1320  N   GLU   160     -13.581  31.008  75.371  1.00 34.46           N
ATOM   1321  CA  GLU   160     -13.572  31.187  73.918  1.00 34.88           C
ATOM   1322  CB  GLU   160     -14.945  30.864  73.301  1.00 35.84           C
ATOM   1323  CG  GLU   160     -15.293  29.376  73.320  1.00 39.68           C
ATOM   1324  CD  GLU   160     -15.699  28.846  74.709  1.00 43.90           C
ATOM   1325  OE1 GLU   160     -16.231  29.628  75.539  1.00 42.25           O
ATOM   1326  OE2 GLU   160     -15.485  27.629  74.959  1.00 47.49           O
ATOM   1327  C   GLU   160     -13.089  32.572  73.473  1.00 33.86           C
ATOM   1328  O   GLU   160     -12.526  32.703  72.382  1.00 34.28           O
ATOM   1329  N   GLU   161     -13.253  33.581  74.319  1.00 32.56           N
ATOM   1330  CA  GLU   161     -12.852  34.943  73.950  1.00 32.97           C
ATOM   1331  CB  GLU   161     -13.931  35.966  74.329  1.00 33.11           C
ATOM   1332  CG  GLU   161     -14.101  36.232  75.807  1.00 34.27           C
ATOM   1333  CD  GLU   161     -15.469  36.815  76.099  1.00 36.91           C
ATOM   1334  OE1 GLU   161     -16.134  37.214  75.109  1.00 37.88           O
ATOM   1335  OE2 GLU   161     -15.880  36.864  77.293  1.00 35.47           O
ATOM   1336  C   GLU   161     -11.490  35.365  74.503  1.00 32.61           C
ATOM   1337  O   GLU   161     -11.116  36.542  74.411  1.00 32.64           O
ATOM   1338  N   VAL   162     -10.762  34.387  75.044  1.00 31.89           N
ATOM   1339  CA  VAL   162      -9.492  34.613  75.742  1.00 31.91           C
ATOM   1340  CB  VAL   162      -9.493  33.968  77.159  1.00 32.49           C
ATOM   1341  CG1 VAL   162      -8.100  34.070  77.824  1.00 30.64           C
ATOM   1342  CG2 VAL   162     -10.614  34.582  78.046  1.00 30.78           C
ATOM   1343  C   VAL   162      -8.309  34.091  74.928  1.00 31.63           C
ATOM   1344  O   VAL   162      -8.291  32.936  74.492  1.00 30.72           O
ATOM   1345  N   LEU   163      -7.344  34.977  74.708  1.00 31.17           N
ATOM   1346  CA  LEU   163      -6.061  34.599  74.139  1.00 30.89           C
ATOM   1347  CB  LEU   163      -5.693  35.510  72.979  1.00 30.52           C
ATOM   1348  CG  LEU   163      -4.485  35.088  72.144  1.00 30.76           C
ATOM   1349  CD1 LEU   163      -4.643  33.648  71.634  1.00 29.87           C
ATOM   1350  CD2 LEU   163      -4.230  36.063  70.980  1.00 30.98           C
ATOM   1351  C   LEU   163      -4.992  34.696  75.218  1.00 30.75           C
ATOM   1352  O   LEU   163      -4.896  35.708  75.892  1.00 30.06           O
ATOM   1353  N   TYR   164      -4.220  33.626  75.400  1.00 30.91           N
ATOM   1354  CA  TYR   164      -3.047  33.689  76.276  1.00 31.55           C
ATOM   1355  CB  TYR   164      -2.973  32.470  77.203  1.00 31.30           C
ATOM   1356  CG  TYR   164      -1.902  32.618  78.276  1.00 33.40           C
ATOM   1357  CD1 TYR   164      -1.848  33.781  79.067  1.00 31.47           C
ATOM   1358  CE1 TYR   164      -0.887  33.944  80.053  1.00 31.32           C
ATOM   1359  CZ  TYR   164       0.062  32.967  80.262  1.00 33.71           C
ATOM   1360  OH  TYR   164       0.992  33.188  81.240  1.00 32.32           O
ATOM   1361  CE2 TYR   164       0.062  31.782  79.482  1.00 33.92           C
ATOM   1362  CD2 TYR   164      -0.937  31.621  78.489  1.00 31.66           C
ATOM   1363  C   TYR   164      -1.755  33.813  75.451  1.00 31.34           C
ATOM   1364  O   TYR   164      -1.534  33.038  74.515  1.00 32.53           O
ATOM   1365  N   ILE   165      -0.889  34.758  75.810  1.00 30.69           N
ATOM   1366  CA  ILE   165       0.335  35.049  75.040  1.00 29.49           C
ATOM   1367  CB  ILE   165       0.318  36.514  74.448  1.00 29.51           C
ATOM   1368  CG1 ILE   165      -0.932  36.778  73.604  1.00 30.79           C
ATOM   1369  CD1 ILE   165      -2.039  37.483  74.342  1.00 27.44           C
ATOM   1370  CG2 ILE   165       1.575  36.794  73.636  1.00 31.57           C
ATOM   1371  C   ILE   165       1.578  34.886  75.917  1.00 29.05           C
ATOM   1372  O   ILE   165       1.688  35.541  76.944  1.00 28.44           O
ATOM   1373  N   GLY   166       2.518  34.023  75.520  1.00 28.54           N
ATOM   1374  CA  GLY   166       3.679  33.738  76.376  1.00 27.39           C
ATOM   1375  C   GLY   166       4.878  33.445  75.510  1.00 28.08           C
ATOM   1376  O   GLY   166       4.733  33.328  74.274  1.00 26.75           O
ATOM   1377  N   ASP   167       6.054  33.333  76.146  1.00 27.57           N
ATOM   1378  CA  ASP   167       7.293  33.064  75.426  1.00 27.78           C
ATOM   1379  CB  ASP   167       8.381  34.005  75.922  1.00 27.52           C
ATOM   1380  CG  ASP   167       8.800  33.669  77.324  1.00 28.93           C
ATOM   1381  OD1 ASP   167       7.990  33.939  78.215  1.00 30.91           O
ATOM   1382  OD2 ASP   167       9.906  33.108  77.533  1.00 31.75           O
ATOM   1383  C   ASP   167       7.845  31.632  75.580  1.00 27.57           C
ATOM   1384  O   ASP   167       8.887  31.301  74.972  1.00 27.83           O
ATOM   1385  N   SER   168       7.202  30.825  76.429  1.00 27.47           N
ATOM   1386  CA  SER   168       7.723  29.516  76.835  1.00 26.64           C
ATOM   1387  CB  SER   168       8.025  29.498  78.332  1.00 26.94           C
ATOM   1388  OG  SER   168       6.799  29.549  79.034  1.00 29.70           O
ATOM   1389  C   SER   168       6.726  28.410  76.620  1.00 26.30           C
ATOM   1390  O   SER   168       5.504  28.656  76.474  1.00 26.45           O
ATOM   1391  N   THR   169       7.244  27.180  76.644  1.00 26.12           N
ATOM   1392  CA  THR   169       6.397  25.999  76.621  1.00 26.28           C
ATOM   1393  CB  THR   169       7.173  24.733  76.318  1.00 26.36           C
ATOM   1394  OG1 THR   169       8.277  24.663  77.212  1.00 26.70           O
ATOM   1395  CG2 THR   169       7.683  24.770  74.879  1.00 27.73           C
ATOM   1396  C   THR   169       5.599  25.815  77.893  1.00 25.69           C
ATOM   1397  O   THR   169       4.515  25.237  77.832  1.00 24.92           O
ATOM   1398  N   VAL   170       6.111  26.329  79.025  1.00 26.07           N
ATOM   1399  CA  VAL   170       5.317  26.449  80.275  1.00 25.83           C
ATOM   1400  CB  VAL   170       6.131  27.138  81.409  1.00 25.84           C
ATOM   1401  CG1 VAL   170       5.222  27.558  82.582  1.00 26.91           C
ATOM   1402  CG2 VAL   170       7.246  26.221  81.886  1.00 26.04           C
ATOM   1403  C   VAL   170       4.024  27.208  80.008  1.00 25.47           C
ATOM   1404  O   VAL   170       2.911  26.778  80.406  1.00 25.40           O
ATOM   1405  N   ASP   171       4.162  28.332  79.312  1.00 26.32           N
ATOM   1406  CA  ASP   171       2.985  29.153  78.990  1.00 26.34           C
ATOM   1407  CB  ASP   171       3.435  30.463  78.358  1.00 27.70           C
ATOM   1408  CG  ASP   171       4.084  31.399  79.350  1.00 27.98           C
ATOM   1409  OD1 ASP   171       3.752  31.363  80.551  1.00 28.13           O
ATOM   1410  OD2 ASP   171       4.947  32.188  78.932  1.00 32.79           O
ATOM   1411  C   ASP   171       2.065  28.413  78.038  1.00 26.85           C
ATOM   1412  O   ASP   171       0.828  28.439  78.209  1.00 26.61           O
ATOM   1413  N   ALA   172       2.649  27.764  77.024  1.00 25.61           N
ATOM   1414  CA  ALA   172       1.865  27.000  76.055  1.00 27.11           C
ATOM   1415  CB  ALA   172       2.741  26.409  74.899  1.00 26.48           C
ATOM   1416  C   ALA   172       1.104  25.888  76.751  1.00 27.31           C
ATOM   1417  O   ALA   172      -0.092  25.728  76.502  1.00 26.13           O
ATOM   1418  N   GLY   173       1.804  25.125  77.599  1.00 27.21           N
ATOM   1419  CA  GLY   173       1.167  24.118  78.457  1.00 28.14           C
ATOM   1420  C   GLY   173       0.059  24.691  79.333  1.00 28.11           C
ATOM   1421  O   GLY   173      -0.985  24.062  79.505  1.00 28.46           O
ATOM   1422  N   THR   174       0.263  25.898  79.858  1.00 29.04           N
ATOM   1423  CA  THR   174      -0.746  26.532  80.739  1.00 28.63           C
ATOM   1424  CB  THR   174      -0.239  27.845  81.422  1.00 29.14           C
ATOM   1425  OG1 THR   174       1.062  27.635  82.011  1.00 28.42           O
ATOM   1426  CG2 THR   174      -1.201  28.270  82.494  1.00 28.38           C
ATOM   1427  C   THR   174      -2.017  26.816  79.962  1.00 28.93           C
ATOM   1428  O   THR   174      -3.104  26.500  80.426  1.00 28.93           O
ATOM   1429  N   ALA   175      -1.891  27.400  78.777  1.00 29.27           N
ATOM   1430  CA  ALA   175      -3.101  27.700  77.976  1.00 30.09           C
ATOM   1431  CB  ALA   175      -2.757  28.491  76.732  1.00 29.49           C
ATOM   1432  C   ALA   175      -3.856  26.427  77.621  1.00 30.13           C
ATOM   1433  O   ALA   175      -5.083  26.372  77.793  1.00 31.05           O
ATOM   1434  N   ALA   176      -3.130  25.392  77.172  1.00 29.92           N
ATOM   1435  CA  ALA   176      -3.758  24.090  76.823  1.00 30.22           C
ATOM   1436  CB  ALA   176      -2.712  23.076  76.314  1.00 29.67           C
ATOM   1437  C   ALA   176      -4.493  23.521  78.016  1.00 30.43           C
ATOM   1438  O   ALA   176      -5.688  23.205  77.949  1.00 31.30           O
ATOM   1439  N   ALA   177      -3.789  23.413  79.136  1.00 30.95           N
ATOM   1440  CA  ALA   177      -4.426  22.959  80.380  1.00 30.86           C
ATOM   1441  CB  ALA   177      -3.414  22.929  81.542  1.00 29.64           C
ATOM   1442  C   ALA   177      -5.706  23.754  80.734  1.00 30.96           C
ATOM   1443  O   ALA   177      -6.680  23.173  81.213  1.00 30.26           O
ATOM   1444  N   ALA   178      -5.704  25.069  80.481  1.00 31.93           N
ATOM   1445  CA  ALA   178      -6.880  25.919  80.731  1.00 32.07           C
ATOM   1446  CB  ALA   178      -6.452  27.382  80.979  1.00 32.87           C
ATOM   1447  C   ALA   178      -7.969  25.844  79.648  1.00 32.72           C
ATOM   1448  O   ALA   178      -9.077  26.302  79.867  1.00 32.75           O
ATOM   1449  N   GLY   179      -7.658  25.254  78.492  1.00 33.13           N
ATOM   1450  CA  GLY   179      -8.605  25.194  77.382  1.00 32.75           C
ATOM   1451  C   GLY   179      -8.815  26.571  76.764  1.00 32.66           C
ATOM   1452  O   GLY   179      -9.944  26.923  76.399  1.00 32.34           O
ATOM   1453  N   VAL   180      -7.730  27.353  76.664  1.00 31.61           N
ATOM   1454  CA  VAL   180      -7.770  28.641  75.970  1.00 30.94           C
ATOM   1455  CB  VAL   180      -7.629  29.867  76.972  1.00 31.08           C
ATOM   1456  CG1 VAL   180      -8.695  29.789  78.112  1.00 29.39           C
ATOM   1457  CG2 VAL   180      -6.241  29.942  77.538  1.00 29.49           C
ATOM   1458  C   VAL   180      -6.735  28.739  74.816  1.00 31.18           C
ATOM   1459  O   VAL   180      -5.669  28.123  74.866  1.00 30.89           O
ATOM   1460  N   SER   181      -7.039  29.545  73.803  1.00 30.60           N
ATOM   1461  CA  SER   181      -6.119  29.762  72.685  1.00 30.70           C
ATOM   1462  CB  SER   181      -6.775  30.642  71.613  1.00 30.53           C
ATOM   1463  OG  SER   181      -7.894  29.988  70.999  1.00 29.90           O
ATOM   1464  C   SER   181      -4.772  30.355  73.106  1.00 30.60           C
ATOM   1465  O   SER   181      -4.698  31.208  74.007  1.00 30.11           O
ATOM   1466  N   PHE   182      -3.709  29.900  72.440  1.00 30.07           N
ATOM   1467  CA  PHE   182      -2.341  30.369  72.734  1.00 29.70           C
ATOM   1468  CB  PHE   182      -1.478  29.205  73.229  1.00 28.93           C
ATOM   1469  CG  PHE   182      -0.081  29.612  73.644  1.00 30.73           C
ATOM   1470  CD1 PHE   182       0.124  30.449  74.761  1.00 29.47           C
ATOM   1471  CE1 PHE   182       1.406  30.827  75.151  1.00 31.11           C
ATOM   1472  CZ  PHE   182       2.526  30.332  74.445  1.00 28.39           C
ATOM   1473  CE2 PHE   182       2.328  29.475  73.331  1.00 28.33           C
ATOM   1474  CD2 PHE   182       1.034  29.106  72.962  1.00 28.37           C
ATOM   1475  C   PHE   182      -1.633  31.041  71.564  1.00 29.02           C
ATOM   1476  O   PHE   182      -1.695  30.573  70.424  1.00 28.62           O
ATOM   1477  N   THR   183      -0.943  32.151  71.841  1.00 30.11           N
ATOM   1478  CA  THR   183      -0.018  32.699  70.860  1.00 28.82           C
ATOM   1479  CB  THR   183      -0.516  34.033  70.270  1.00 30.12           C
ATOM   1480  OG1 THR   183      -1.611  33.747  69.388  1.00 30.28           O
ATOM   1481  CG2 THR   183       0.621  34.771  69.486  1.00 27.41           C
ATOM   1482  C   THR   183       1.368  32.763  71.471  1.00 28.92           C
ATOM   1483  O   THR   183       1.591  33.421  72.491  1.00 27.48           O
ATOM   1484  N   GLY   184       2.284  32.020  70.873  1.00 28.36           N
ATOM   1485  CA  GLY   184       3.663  32.001  71.341  1.00 28.69           C
ATOM   1486  C   GLY   184       4.432  33.175  70.739  1.00 29.40           C
ATOM   1487  O   GLY   184       4.204  33.561  69.581  1.00 29.16           O
ATOM   1488  N   VAL   185       5.289  33.775  71.553  1.00 29.52           N
ATOM   1489  CA  VAL   185       6.227  34.823  71.108  0.50 29.57           C
ATOM   1491  CB  VAL   185       5.977  36.191  71.805  0.50 29.47           C
ATOM   1493  CG1 VAL   185       6.778  37.296  71.119  0.50 30.12           C
ATOM   1495  CG2 VAL   185       4.518  36.544  71.808  0.50 29.56           C
ATOM   1497  C   VAL   185       7.653  34.390  71.427  1.00 29.06           C
ATOM   1498  O   VAL   185       7.987  34.165  72.587  1.00 29.80           O
ATOM   1499  N   THR   186       8.501  34.296  70.412  1.00 29.30           N
ATOM   1500  CA  THR   186       9.882  33.835  70.612  1.00 28.58           C
ATOM   1501  CB  THR   186      10.460  33.142  69.334  1.00 28.68           C
ATOM   1502  OG1 THR   186      10.512  34.084  68.261  1.00 29.27           O
ATOM   1503  CG2 THR   186       9.609  31.926  68.898  1.00 27.42           C
ATOM   1504  C   THR   186      10.818  34.915  71.149  1.00 28.67           C
ATOM   1505  O   THR   186      11.954  35.027  70.700  1.00 28.42           O
ATOM   1506  N   SER   187      10.357  35.678  72.149  1.00 28.95           N
ATOM   1507  CA  SER   187      11.169  36.731  72.796  1.00 29.25           C
ATOM   1508  CB  SER   187      10.308  37.935  73.169  1.00 29.27           C
ATOM   1509  OG  SER   187       9.157  37.486  73.857  1.00 31.18           O
ATOM   1510  C   SER   187      11.890  36.215  74.052  1.00 29.26           C
ATOM   1511  O   SER   187      12.588  36.976  74.717  1.00 28.99           O
ATOM   1512  N   GLY   188      11.722  34.929  74.357  1.00 29.16           N
ATOM   1513  CA  GLY   188      12.452  34.291  75.446  1.00 29.38           C
ATOM   1514  C   GLY   188      13.575  33.397  74.951  1.00 29.82           C
ATOM   1515  O   GLY   188      14.352  33.786  74.080  1.00 30.49           O
ATOM   1516  N   MET   189      13.652  32.185  75.503  1.00 30.04           N
ATOM   1517  CA  MET   189      14.651  31.196  75.092  1.00 30.01           C
ATOM   1518  CB  MET   189      15.408  30.630  76.296  1.00 30.07           C
ATOM   1519  CG  MET   189      16.126  31.615  77.109  1.00 31.09           C
ATOM   1520  SD  MET   189      17.657  32.307  76.282  0.70 34.38          SE
ATOM   1521  CE  MET   189      18.750  30.708  76.149  1.00 34.13           C
ATOM   1522  C   MET   189      14.031  30.019  74.345  1.00 29.96           C
ATOM   1523  O   MET   189      14.740  29.062  74.018  1.00 29.46           O
ATOM   1524  N   THR   190      12.727  30.090  74.101  1.00 29.08           N
ATOM   1525  CA  THR   190      11.991  29.049  73.389  1.00 30.03           C
ATOM   1526  CB  THR   190      10.582  28.862  73.995  1.00 30.20           C
ATOM   1527  OG1 THR   190      10.719  28.608  75.384  1.00 34.60           O
ATOM   1528  CG2 THR   190       9.802  27.720  73.330  1.00 30.40           C
ATOM   1529  C   THR   190      11.851  29.425  71.916  1.00 29.62           C
ATOM   1530  O   THR   190      11.431  30.545  71.578  1.00 29.07           O
ATOM   1531  N   THR   191      12.216  28.473  71.061  1.00 29.44           N
ATOM   1532  CA  THR   191      12.183  28.624  69.607  1.00 29.39           C
ATOM   1533  CB  THR   191      13.310  27.793  68.957  1.00 30.38           C
ATOM   1534  OG1 THR   191      12.979  26.401  69.037  1.00 30.50           O
ATOM   1535  CG2 THR   191      14.646  28.058  69.660  1.00 28.76           C
ATOM   1536  C   THR   191      10.853  28.152  69.045  1.00 29.76           C
ATOM   1537  O   THR   191      10.117  27.432  69.739  1.00 29.53           O
ATOM   1538  N   ALA   192      10.544  28.548  67.793  1.00 29.58           N
ATOM   1539  CA  ALA   192       9.320  28.119  67.118  1.00 29.13           C
ATOM   1540  CB  ALA   192       9.172  28.791  65.722  1.00 29.19           C
ATOM   1541  C   ALA   192       9.223  26.577  67.008  1.00 29.09           C
ATOM   1542  O   ALA   192       8.128  26.005  67.122  1.00 28.85           O
ATOM   1543  N   GLN   193      10.355  25.922  66.777  1.00 28.17           N
ATOM   1544  CA  GLN   193      10.406  24.464  66.753  1.00 28.79           C
ATOM   1545  CB  GLN   193      11.809  23.956  66.399  1.00 28.22           C
ATOM   1546  CG  GLN   193      11.884  22.420  66.195  1.00 29.86           C
ATOM   1547  CD  GLN   193      12.031  21.593  67.516  1.00 33.91           C
ATOM   1548  OE1 GLN   193      12.375  22.130  68.580  1.00 36.29           O
ATOM   1549  NE2 GLN   193      11.770  20.281  67.433  1.00 31.80           N
ATOM   1550  C   GLN   193       9.957  23.869  68.077  1.00 28.83           C
ATOM   1551  O   GLN   193       9.182  22.911  68.082  1.00 29.61           O
ATOM   1552  N   GLU   194      10.404  24.455  69.195  1.00 27.92           N
ATOM   1553  CA  GLU   194      10.016  23.973  70.520  1.00 27.72           C
ATOM   1554  CB  GLU   194      10.903  24.578  71.604  1.00 28.41           C
ATOM   1555  CG  GLU   194      12.358  24.124  71.434  1.00 29.11           C
ATOM   1556  CD  GLU   194      13.352  24.946  72.264  1.00 33.55           C
ATOM   1557  OE1 GLU   194      13.063  26.101  72.631  1.00 31.87           O
ATOM   1558  OE2 GLU   194      14.468  24.438  72.505  1.00 36.61           O
ATOM   1559  C   GLU   194       8.539  24.118  70.849  1.00 28.13           C
ATOM   1560  O   GLU   194       7.996  23.286  71.576  1.00 28.95           O
ATOM   1561  N   PHE   195       7.876  25.134  70.291  1.00 27.78           N
ATOM   1562  CA  PHE   195       6.448  25.356  70.560  1.00 27.60           C
ATOM   1563  CB  PHE   195       5.999  26.722  70.031  1.00 27.04           C
ATOM   1564  CG  PHE   195       6.227  27.873  70.988  1.00 28.57           C
ATOM   1565  CD1 PHE   195       5.556  27.932  72.213  1.00 28.10           C
ATOM   1566  CE1 PHE   195       5.738  29.019  73.065  1.00 28.60           C
ATOM   1567  CZ  PHE   195       6.623  30.059  72.707  1.00 28.17           C
ATOM   1568  CE2 PHE   195       7.285  30.014  71.505  1.00 29.42           C
ATOM   1569  CD2 PHE   195       7.073  28.920  70.636  1.00 29.20           C
ATOM   1570  C   PHE   195       5.595  24.322  69.886  1.00 27.81           C
ATOM   1571  O   PHE   195       4.388  24.246  70.172  1.00 28.62           O
ATOM   1572  N   GLN   196       6.193  23.565  68.953  1.00 28.00           N
ATOM   1573  CA  GLN   196       5.415  22.654  68.060  1.00 28.03           C
ATOM   1574  CB  GLN   196       6.234  22.121  66.858  1.00 28.17           C
ATOM   1575  CG  GLN   196       6.634  23.160  65.824  1.00 29.26           C
ATOM   1576  CD  GLN   196       5.496  24.111  65.490  1.00 32.07           C
ATOM   1577  OE1 GLN   196       4.407  23.676  65.136  1.00 31.14           O
ATOM   1578  NE2 GLN   196       5.751  25.418  65.584  1.00 32.53           N
ATOM   1579  C   GLN   196       4.828  21.505  68.847  1.00 27.41           C
ATOM   1580  O   GLN   196       3.836  20.909  68.443  1.00 26.80           O
ATOM   1581  N   ALA   197       5.441  21.233  70.000  1.00 27.36           N
ATOM   1582  CA  ALA   197       4.963  20.211  70.916  1.00 27.34           C
ATOM   1583  CB  ALA   197       5.976  19.969  71.995  1.00 27.40           C
ATOM   1584  C   ALA   197       3.599  20.549  71.529  1.00 26.75           C
ATOM   1585  O   ALA   197       2.985  19.700  72.159  1.00 27.17           O
ATOM   1586  N   TYR   198       3.132  21.784  71.348  1.00 27.66           N
ATOM   1587  CA  TYR   198       1.888  22.273  71.987  1.00 27.71           C
ATOM   1588  CB  TYR   198       2.222  23.218  73.155  1.00 28.98           C
ATOM   1589  CG  TYR   198       3.075  22.606  74.241  1.00 31.68           C
ATOM   1590  CD1 TYR   198       2.493  22.084  75.418  1.00 31.00           C
ATOM   1591  CE1 TYR   198       3.317  21.526  76.432  1.00 33.40           C
ATOM   1592  CZ  TYR   198       4.701  21.471  76.220  1.00 31.87           C
ATOM   1593  OH  TYR   198       5.542  20.945  77.177  1.00 33.47           O
ATOM   1594  CE2 TYR   198       5.276  21.957  75.053  1.00 31.80           C
ATOM   1595  CD2 TYR   198       4.478  22.534  74.089  1.00 30.17           C
ATOM   1596  C   TYR   198       1.028  23.062  71.006  1.00 27.44           C
ATOM   1597  O   TYR   198       1.554  23.596  70.012  1.00 25.39           O
ATOM   1598  N   PRO   199      -0.291  23.188  71.307  1.00 26.95           N
ATOM   1599  CA  PRO   199      -1.191  23.937  70.432  1.00 27.37           C
ATOM   1600  CB  PRO   199      -2.607  23.578  70.968  1.00 27.67           C
ATOM   1601  CG  PRO   199      -2.415  22.459  71.974  1.00 26.62           C
ATOM   1602  CD  PRO   199      -0.996  22.613  72.470  1.00 27.05           C
ATOM   1603  C   PRO   199      -0.940  25.455  70.438  1.00 27.64           C
ATOM   1604  O   PRO   199      -0.574  26.036  71.464  1.00 28.07           O
ATOM   1605  N   TYR   200      -1.122  26.094  69.291  1.00 28.51           N
ATOM   1606  CA  TYR   200      -0.984  27.553  69.181  1.00 28.39           C
ATOM   1607  CB  TYR   200       0.483  27.956  68.937  1.00 28.12           C
ATOM   1608  CG  TYR   200       1.092  27.286  67.713  1.00 29.23           C
ATOM   1609  CD1 TYR   200       1.055  27.904  66.452  1.00 30.22           C
ATOM   1610  CE1 TYR   200       1.600  27.269  65.316  1.00 27.75           C
ATOM   1611  CZ  TYR   200       2.163  26.012  65.453  1.00 28.10           C
ATOM   1612  OH  TYR   200       2.700  25.386  64.349  1.00 28.06           O
ATOM   1613  CE2 TYR   200       2.194  25.374  66.692  1.00 26.81           C
ATOM   1614  CD2 TYR   200       1.675  26.006  67.805  1.00 29.53           C
ATOM   1615  C   TYR   200      -1.854  28.017  68.011  1.00 29.50           C
ATOM   1616  O   TYR   200      -2.206  27.214  67.120  1.00 28.52           O
ATOM   1617  N   ASP   201      -2.167  29.306  68.021  1.00 29.42           N
ATOM   1618  CA  ASP   201      -2.749  29.989  66.892  1.00 30.78           C
ATOM   1619  CB  ASP   201      -3.443  31.268  67.386  1.00 31.84           C
ATOM   1620  CG  ASP   201      -4.895  31.063  67.642  1.00 34.16           C
ATOM   1621  OD1 ASP   201      -5.302  29.885  67.776  1.00 35.12           O
ATOM   1622  OD2 ASP   201      -5.629  32.079  67.695  1.00 37.28           O
ATOM   1623  C   ASP   201      -1.698  30.412  65.906  1.00 30.46           C
ATOM   1624  O   ASP   201      -1.764  30.067  64.733  1.00 30.55           O
ATOM   1625  N   ARG   202      -0.770  31.219  66.409  1.00 30.69           N
ATOM   1626  CA  ARG   202       0.383  31.726  65.703  1.00 30.71           C
ATOM   1627  CB  ARG   202       0.173  33.219  65.357  1.00 30.87           C
ATOM   1628  CG  ARG   202      -0.615  33.475  64.109  1.00 32.31           C
ATOM   1629  CD  ARG   202      -0.559  34.954  63.773  1.00 35.48           C
ATOM   1630  NE  ARG   202      -1.190  35.768  64.806  1.00 37.62           N
ATOM   1631  CZ  ARG   202      -1.028  37.082  64.932  1.00 39.80           C
ATOM   1632  NH1 ARG   202      -0.239  37.745  64.091  1.00 42.12           N
ATOM   1633  NH2 ARG   202      -1.656  37.733  65.893  1.00 38.13           N
ATOM   1634  C   ARG   202       1.593  31.653  66.626  1.00 30.68           C
ATOM   1635  O   ARG   202       1.461  31.511  67.855  1.00 31.05           O
ATOM   1636  N   ILE   203       2.775  31.719  66.016  1.00 29.99           N
ATOM   1637  CA  ILE   203       4.021  31.914  66.733  0.50 29.91           C
ATOM   1639  CB  ILE   203       4.980  30.689  66.644  0.50 29.40           C
ATOM   1641  CG1 ILE   203       4.316  29.388  67.127  0.50 28.07           C
ATOM   1643  CD1 ILE   203       4.012  29.281  68.634  0.50 24.34           C
ATOM   1645  CG2 ILE   203       6.279  30.975  67.415  0.50 30.13           C
ATOM   1647  C   ILE   203       4.680  33.123  66.078  1.00 30.29           C
ATOM   1648  O   ILE   203       5.018  33.072  64.882  1.00 31.17           O
ATOM   1649  N   ILE   204       4.859  34.190  66.853  1.00 30.12           N
ATOM   1650  CA  ILE   204       5.346  35.470  66.342  1.00 30.67           C
ATOM   1651  CB  ILE   204       4.348  36.614  66.701  1.00 30.30           C
ATOM   1652  CG1 ILE   204       3.968  36.571  68.184  1.00 30.24           C
ATOM   1653  CD1 ILE   204       3.245  37.841  68.688  1.00 31.03           C
ATOM   1654  CG2 ILE   204       3.063  36.491  65.837  1.00 30.53           C
ATOM   1655  C   ILE   204       6.740  35.752  66.864  1.00 30.85           C
ATOM   1656  O   ILE   204       7.143  35.145  67.855  1.00 32.34           O
ATOM   1657  N   SER   205       7.479  36.657  66.223  1.00 30.89           N
ATOM   1658  CA  SER   205       8.802  37.060  66.731  1.00 31.63           C
ATOM   1659  CB  SER   205       9.761  37.523  65.616  1.00 31.53           C
ATOM   1660  OG  SER   205       9.422  36.957  64.387  1.00 34.62           O
ATOM   1661  C   SER   205       8.726  38.184  67.727  1.00 31.36           C
ATOM   1662  O   SER   205       9.549  38.262  68.636  1.00 31.48           O
ATOM   1663  N   THR   206       7.780  39.094  67.528  1.00 31.39           N
ATOM   1664  CA  THR   206       7.694  40.256  68.397  1.00 31.78           C
ATOM   1665  CB  THR   206       8.300  41.547  67.768  1.00 31.65           C
ATOM   1666  OG1 THR   206       7.678  41.831  66.496  1.00 29.92           O
ATOM   1667  CG2 THR   206       9.799  41.393  67.560  1.00 31.94           C
ATOM   1668  C   THR   206       6.249  40.468  68.768  1.00 32.33           C
ATOM   1669  O   THR   206       5.361  40.078  68.033  1.00 32.08           O
ATOM   1670  N   LEU   207       6.031  41.076  69.926  1.00 32.23           N
ATOM   1671  CA  LEU   207       4.695  41.333  70.432  1.00 32.50           C
ATOM   1672  CB  LEU   207       4.810  42.054  71.769  1.00 32.65           C
ATOM   1673  CG  LEU   207       3.731  41.888  72.812  1.00 32.55           C
ATOM   1674  CD1 LEU   207       3.511  40.409  73.119  1.00 31.90           C
ATOM   1675  CD2 LEU   207       4.156  42.696  74.074  1.00 32.43           C
ATOM   1676  C   LEU   207       3.883  42.193  69.491  1.00 32.69           C
ATOM   1677  O   LEU   207       2.659  42.042  69.420  1.00 31.97           O
ATOM   1678  N   GLY   208       4.566  43.099  68.785  1.00 33.30           N
ATOM   1679  CA  GLY   208       3.915  44.042  67.854  1.00 34.10           C
ATOM   1680  C   GLY   208       3.157  43.356  66.723  1.00 34.93           C
ATOM   1681  O   GLY   208       2.197  43.917  66.148  1.00 34.41           O
ATOM   1682  N   GLN   209       3.585  42.132  66.426  1.00 35.26           N
ATOM   1683  CA  GLN   209       2.970  41.301  65.428  1.00 37.01           C
ATOM   1684  CB  GLN   209       3.897  40.153  65.086  1.00 37.01           C
ATOM   1685  CG  GLN   209       4.944  40.551  64.079  1.00 39.42           C
ATOM   1686  CD  GLN   209       6.007  39.515  63.924  1.00 43.33           C
ATOM   1687  OE1 GLN   209       5.726  38.322  63.928  1.00 47.40           O
ATOM   1688  NE2 GLN   209       7.246  39.958  63.786  1.00 44.87           N
ATOM   1689  C   GLN   209       1.622  40.782  65.877  1.00 37.66           C
ATOM   1690  O   GLN   209       0.838  40.275  65.078  1.00 37.76           O
ATOM   1691  N   LEU   210       1.340  40.922  67.159  1.00 38.30           N
ATOM   1692  CA  LEU   210       0.026  40.564  67.689  1.00 39.49           C
ATOM   1693  CB  LEU   210       0.023  40.739  69.216  1.00 39.62           C
ATOM   1694  CG  LEU   210      -0.703  39.828  70.214  1.00 39.33           C
ATOM   1695  CD1 LEU   210      -0.693  38.331  69.883  1.00 36.10           C
ATOM   1696  CD2 LEU   210      -0.077  40.083  71.560  1.00 37.45           C
ATOM   1697  C   LEU   210      -1.054  41.400  67.016  1.00 40.60           C
ATOM   1698  O   LEU   210      -2.172  40.925  66.781  1.00 41.32           O
ATOM   1699  N   ILE   211      -0.697  42.640  66.685  1.00 41.56           N
ATOM   1700  CA  ILE   211      -1.547  43.572  65.950  1.00 41.96           C
ATOM   1701  CB  ILE   211      -1.172  45.062  66.259  1.00 42.21           C
ATOM   1702  CG1 ILE   211      -1.168  45.366  67.774  1.00 42.34           C
ATOM   1703  CD1 ILE   211      -2.480  45.107  68.511  1.00 41.30           C
ATOM   1704  CG2 ILE   211      -2.040  46.032  65.448  1.00 43.37           C
ATOM   1705  C   ILE   211      -1.374  43.340  64.456  1.00 41.85           C
ATOM   1706  O   ILE   211      -2.312  42.930  63.776  1.00 42.35           O
END
