
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  124 (  924),  selected  124 , name 2cw4_A
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2cw4_A.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      M       1           -
LGA    E     2_A      S       2           -
LGA    A     3_A      D       3           -
LGA    V     4_A      V       4           -
LGA    K     5_A      I       5           -
LGA    T     6_A      E       6           -
LGA    D     7_A      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    R     8_A      P      17          2.734
LGA    A     9_A      V      18          4.654
LGA    P    10_A      -       -           -
LGA    A    11_A      -       -           -
LGA    A    12_A      -       -           -
LGA    I    13_A      A      23           #
LGA    G    14_A      A      24          4.048
LGA    P    15_A      N      25          2.481
LGA    Y    16_A      Y      26          1.436
LGA    A    17_A      V      27          1.152
LGA    Q    18_A      P      28          1.133
LGA    A    19_A      F      29          1.031
LGA    V    20_A      T      30          1.280
LGA    K    21_A      I      31          1.807
LGA    A    22_A      S      32          2.082
LGA    G    23_A      G      33          1.544
LGA    G    24_A      N      34          1.498
LGA    F    25_A      L      35          1.208
LGA    V    26_A      L      36          0.821
LGA    F    27_A      Y      37          0.752
LGA    V    28_A      V      38          0.200
LGA    S    29_A      S      39          0.267
LGA    G    30_A      G      40          0.347
LGA    Q    31_A      Q      41          0.295
LGA    I    32_A      L      42          0.484
LGA    P    33_A      P      43          0.926
LGA    L    34_A      M      44          1.607
LGA    A    35_A      E      45          2.596
LGA    P    36_A      S      46          5.330
LGA    D    37_A      -       -           -
LGA    G    38_A      G      47          3.089
LGA    S    39_A      K      48          1.204
LGA    L    40_A      I      49          1.260
LGA    V    41_A      A      50          0.799
LGA    E    42_A      V      51          2.961
LGA    G    43_A      T      52           #
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    44_A      S      63          1.854
LGA    I    45_A      A      64          0.294
LGA    R    46_A      Q      65          2.045
LGA    V    47_A      R      66          2.125
LGA    Q    48_A      A      67          1.092
LGA    T    49_A      A      68          1.275
LGA    E    50_A      E      69          1.807
LGA    R    51_A      L      70          1.221
LGA    V    52_A      C      71          0.729
LGA    X    53_A      A      72          1.011
LGA    E    54_A      V      73          0.764
LGA    N    55_A      N      74          0.425
LGA    L    56_A      I      75          0.882
LGA    K    57_A      L      76          0.961
LGA    A    58_A      A      77          0.762
LGA    V    59_A      Q      78          0.780
LGA    L    60_A      V      79          0.954
LGA    E    61_A      K      80          1.406
LGA    A    62_A      A      81          1.553
LGA    A    63_A      A      82          1.603
LGA    G    64_A      L      83          1.697
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    S    65_A      L      87          4.506
LGA    -       -      S      88           -
LGA    -       -      K      89           -
LGA    G    66_A      I      90          3.991
LGA    L    67_A      R      91           -
LGA    S    68_A      -       -           -
LGA    R    69_A      R      92          2.404
LGA    V    70_A      V      93          1.319
LGA    V    71_A      I      94          0.808
LGA    Q    72_A      K      95          1.249
LGA    T    73_A      L      96          1.325
LGA    T    74_A      N      97          1.134
LGA    C    75_A      G      98          1.135
LGA    F    76_A      F      99          0.723
LGA    L    77_A      V     100          0.728
LGA    A    78_A      A     101          1.062
LGA    D    79_A      S     102          1.654
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    X    80_A      F     106          3.307
LGA    E    81_A      V     107          4.573
LGA    D    82_A      E     108          4.705
LGA    F    83_A      Q     109          1.833
LGA    -       -      H     110           -
LGA    P    84_A      L     111          1.428
LGA    G    85_A      V     112          3.252
LGA    F    86_A      I     113          2.852
LGA    N    87_A      N     114          1.232
LGA    E    88_A      G     115          3.884
LGA    V    89_A      A     116          4.405
LGA    Y    90_A      S     117          2.300
LGA    A    91_A      N     118          1.470
LGA    R    92_A      L     119          2.776
LGA    Y    93_A      I     120          1.789
LGA    F    94_A      A     121          1.186
LGA    -       -      T     122           -
LGA    -       -      V     123           -
LGA    -       -      L     124           -
LGA    T    95_A      G     125          3.516
LGA    P    96_A      E     126          2.993
LGA    P    97_A      P     127          4.964
LGA    -       -      G     128           -
LGA    Y    98_A      R     129          1.556
LGA    P    99_A      H     130          1.212
LGA    A   100_A      A     131          1.291
LGA    R   101_A      R     132          1.069
LGA    A   102_A      A     133          1.292
LGA    T   103_A      A     134          1.389
LGA    V   104_A      V     135          0.837
LGA    A   105_A      G     136          0.718
LGA    V   106_A      M     137          1.194
LGA    K   107_A      A     138          1.068
LGA    A   108_A      S     139          1.115
LGA    L   109_A      L     140          0.998
LGA    P   110_A      P     141          0.885
LGA    R   111_A      F     142          1.230
LGA    G   112_A      N     143          1.291
LGA    V   113_A      A     144          1.058
LGA    R   114_A      S     145          1.109
LGA    V   115_A      V     146          0.611
LGA    E   116_A      E     147          0.707
LGA    V   117_A      I     148          0.649
LGA    A   118_A      D     149          0.476
LGA    C   119_A      A     150          0.634
LGA    V   120_A      I     151          0.757
LGA    A   121_A      V     152          0.792
LGA    L   122_A      E     153          1.509
LGA    A   123_A      I     154          2.499
LGA    E   124_A      D     155          1.651
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  124  152    5.0    109    2.02    24.77     58.773     5.152

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.166828 * X  +   0.600920 * Y  +  -0.781706 * Z  +  56.317223
  Y_new =   0.333082 * X  +  -0.780556 * Y  +  -0.528951 * Z  +  76.932747
  Z_new =  -0.928022 * X  +  -0.172128 * Y  +  -0.330374 * Z  +  34.035107 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.661279    0.480314  [ DEG:  -152.4800     27.5200 ]
  Theta =   1.189067    1.952525  [ DEG:    68.1285    111.8715 ]
  Phi   =   1.106460   -2.035133  [ DEG:    63.3955   -116.6045 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cw4_A                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cw4_A.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  124  152   5.0  109   2.02   24.77  58.773
REMARK  ---------------------------------------------------------- 
MOLECULE 2cw4_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   16-JUN-05   2CW4              
TITLE     CRYSTAL STRUCTURE OF TTHA0137 FROM THERMUS THERMOPHILUS HB8           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSLATION INITIATION INHIBITOR;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    STRUCTURAL GENOMICS, UNKNOWN FUNCTION, NPPSFA, NATIONAL               
KEYWDS   2 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   3 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.WANG,K.MURAYAMA,T.TERADA,M.SHIROUZU,S.KURAMITSU,                    
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   16-DEC-05 2CW4    0                                                
JRNL        AUTH   H.WANG,K.MURAYAMA,T.TERADA,M.SHIROUZU,S.KURAMITSU,           
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   CRYSTAL STRUCTURE OF TTHA0137 FROM THERMUS                   
JRNL        TITL 2 THERMOPHILUS HB8                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2CW4 A    1   124  UNP    Q5SM06   Q5SM06_THET8     1    124             
SEQRES   1 A  124  MSE GLU ALA VAL LYS THR ASP ARG ALA PRO ALA ALA ILE          
SEQRES   2 A  124  GLY PRO TYR ALA GLN ALA VAL LYS ALA GLY GLY PHE VAL          
SEQRES   3 A  124  PHE VAL SER GLY GLN ILE PRO LEU ALA PRO ASP GLY SER          
SEQRES   4 A  124  LEU VAL GLU GLY ASP ILE ARG VAL GLN THR GLU ARG VAL          
SEQRES   5 A  124  MSE GLU ASN LEU LYS ALA VAL LEU GLU ALA ALA GLY SER          
SEQRES   6 A  124  GLY LEU SER ARG VAL VAL GLN THR THR CYS PHE LEU ALA          
SEQRES   7 A  124  ASP MSE GLU ASP PHE PRO GLY PHE ASN GLU VAL TYR ALA          
SEQRES   8 A  124  ARG TYR PHE THR PRO PRO TYR PRO ALA ARG ALA THR VAL          
SEQRES   9 A  124  ALA VAL LYS ALA LEU PRO ARG GLY VAL ARG VAL GLU VAL          
SEQRES  10 A  124  ALA CYS VAL ALA LEU ALA GLU                                  
HET    MSE  A   1       8                                                       
HET    MSE  A  53       8                                                       
HET    MSE  A  80       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *59(H2 O)                                                     
CRYST1   59.540   59.540   83.740  90.00  90.00 120.00 H 3           9          
HETATM    1  N   MSE A   1      59.121  42.789  33.366  1.00 46.38           N  
HETATM    2  CA  MSE A   1      58.878  44.038  34.148  1.00 44.81           C  
HETATM    3  C   MSE A   1      59.181  43.792  35.628  1.00 42.08           C  
HETATM    4  O   MSE A   1      58.962  44.655  36.481  1.00 40.75           O  
HETATM    5  CB  MSE A   1      57.421  44.480  33.974  1.00 46.64           C  
HETATM    6  CG  MSE A   1      57.276  45.908  33.485  1.00 49.81           C  
HETATM    7 SE   MSE A   1      58.286  47.137  34.582  1.00 54.18          SE  
HETATM    8  CE  MSE A   1      59.843  47.407  33.458  1.00 51.96           C  
ATOM      9  N   GLU A   2      59.704  42.605  35.909  1.00 39.55           N  
ATOM     10  CA  GLU A   2      60.036  42.184  37.265  1.00 36.43           C  
ATOM     11  C   GLU A   2      61.447  42.577  37.726  1.00 33.15           C  
ATOM     12  O   GLU A   2      62.425  42.428  36.986  1.00 29.02           O  
ATOM     13  CB  GLU A   2      59.861  40.667  37.355  1.00 38.36           C  
ATOM     14  CG  GLU A   2      60.447  40.018  38.593  1.00 41.55           C  
ATOM     15  CD  GLU A   2      60.571  38.512  38.442  1.00 43.05           C  
ATOM     16  OE1 GLU A   2      59.528  37.837  38.285  1.00 43.41           O  
ATOM     17  OE2 GLU A   2      61.713  38.006  38.474  1.00 43.74           O  
ATOM     18  N   ALA A   3      61.541  43.080  38.955  1.00 30.03           N  
ATOM     19  CA  ALA A   3      62.827  43.463  39.530  1.00 27.09           C  
ATOM     20  C   ALA A   3      63.355  42.261  40.304  1.00 24.85           C  
ATOM     21  O   ALA A   3      62.633  41.646  41.085  1.00 25.28           O  
ATOM     22  CB  ALA A   3      62.667  44.659  40.468  1.00 26.76           C  
ATOM     23  N   VAL A   4      64.612  41.920  40.076  1.00 21.56           N  
ATOM     24  CA  VAL A   4      65.212  40.786  40.757  1.00 20.10           C  
ATOM     25  C   VAL A   4      65.861  41.267  42.058  1.00 19.66           C  
ATOM     26  O   VAL A   4      66.528  42.306  42.099  1.00 17.36           O  
ATOM     27  CB  VAL A   4      66.261  40.092  39.846  1.00 18.68           C  
ATOM     28  CG1 VAL A   4      66.811  38.851  40.519  1.00 19.38           C  
ATOM     29  CG2 VAL A   4      65.629  39.741  38.510  1.00 16.27           C  
ATOM     30  N   LYS A   5      65.632  40.510  43.124  1.00 19.62           N  
ATOM     31  CA  LYS A   5      66.169  40.833  44.435  1.00 19.47           C  
ATOM     32  C   LYS A   5      66.590  39.547  45.135  1.00 18.42           C  
ATOM     33  O   LYS A   5      65.802  38.606  45.261  1.00 17.36           O  
ATOM     34  CB  LYS A   5      65.112  41.559  45.272  1.00 20.53           C  
ATOM     35  CG  LYS A   5      65.614  42.047  46.618  1.00 22.55           C  
ATOM     36  CD  LYS A   5      64.565  42.885  47.321  1.00 25.48           C  
ATOM     37  CE  LYS A   5      65.099  43.452  48.625  1.00 29.08           C  
ATOM     38  NZ  LYS A   5      64.026  44.130  49.412  1.00 30.51           N  
ATOM     39  N   THR A   6      67.840  39.514  45.575  1.00 17.15           N  
ATOM     40  CA  THR A   6      68.396  38.366  46.268  1.00 16.68           C  
ATOM     41  C   THR A   6      69.300  38.889  47.366  1.00 17.33           C  
ATOM     42  O   THR A   6      69.904  39.952  47.227  1.00 14.31           O  
ATOM     43  CB  THR A   6      69.238  37.486  45.321  1.00 17.37           C  
ATOM     44  OG1 THR A   6      69.967  36.521  46.087  1.00 16.66           O  
ATOM     45  CG2 THR A   6      70.211  38.334  44.530  1.00 15.74           C  
ATOM     46  N   ASP A   7      69.387  38.142  48.460  1.00 18.28           N  
ATOM     47  CA  ASP A   7      70.229  38.544  49.575  1.00 18.80           C  
ATOM     48  C   ASP A   7      71.592  37.872  49.469  1.00 17.86           C  
ATOM     49  O   ASP A   7      72.389  37.913  50.402  1.00 16.17           O  
ATOM     50  CB  ASP A   7      69.554  38.184  50.903  1.00 19.95           C  
ATOM     51  CG  ASP A   7      69.285  36.691  51.048  1.00 21.41           C  
ATOM     52  OD1 ASP A   7      68.657  36.307  52.060  1.00 22.26           O  
ATOM     53  OD2 ASP A   7      69.698  35.901  50.170  1.00 21.26           O  
ATOM     54  N   ARG A   8      71.845  37.254  48.317  1.00 17.98           N  
ATOM     55  CA  ARG A   8      73.109  36.574  48.067  1.00 17.38           C  
ATOM     56  C   ARG A   8      74.050  37.498  47.320  1.00 16.97           C  
ATOM     57  O   ARG A   8      75.125  37.099  46.884  1.00 16.89           O  
ATOM     58  CB  ARG A   8      72.868  35.280  47.288  1.00 18.36           C  
ATOM     59  CG  ARG A   8      71.978  34.301  48.061  1.00 20.26           C  
ATOM     60  CD  ARG A   8      71.875  32.947  47.388  1.00 22.40           C  
ATOM     61  NE  ARG A   8      73.168  32.274  47.337  1.00 25.38           N  
ATOM     62  CZ  ARG A   8      73.771  31.899  46.212  1.00 26.99           C  
ATOM     63  NH1 ARG A   8      73.194  32.127  45.036  1.00 26.14           N  
ATOM     64  NH2 ARG A   8      74.956  31.302  46.265  1.00 26.29           N  
ATOM     65  N   ALA A   9      73.617  38.747  47.186  1.00 17.95           N  
ATOM     66  CA  ALA A   9      74.392  39.802  46.544  1.00 17.52           C  
ATOM     67  C   ALA A   9      74.052  41.062  47.343  1.00 17.56           C  
ATOM     68  O   ALA A   9      72.957  41.166  47.904  1.00 16.47           O  
ATOM     69  CB  ALA A   9      73.971  39.962  45.087  1.00 18.30           C  
ATOM     70  N   PRO A  10      74.983  42.028  47.416  1.00 17.70           N  
ATOM     71  CA  PRO A  10      74.667  43.239  48.181  1.00 18.03           C  
ATOM     72  C   PRO A  10      73.326  43.816  47.754  1.00 19.47           C  
ATOM     73  O   PRO A  10      73.009  43.874  46.561  1.00 18.70           O  
ATOM     74  CB  PRO A  10      75.849  44.165  47.880  1.00 17.17           C  
ATOM     75  CG  PRO A  10      76.328  43.703  46.537  1.00 18.39           C  
ATOM     76  CD  PRO A  10      76.224  42.199  46.643  1.00 18.08           C  
ATOM     77  N   ALA A  11      72.531  44.222  48.737  1.00 20.93           N  
ATOM     78  CA  ALA A  11      71.207  44.777  48.480  1.00 23.45           C  
ATOM     79  C   ALA A  11      71.293  46.088  47.715  1.00 25.39           C  
ATOM     80  O   ALA A  11      72.292  46.799  47.809  1.00 24.42           O  
ATOM     81  CB  ALA A  11      70.471  44.998  49.798  1.00 23.68           C  
ATOM     82  N   ALA A  12      70.246  46.390  46.951  1.00 27.51           N  
ATOM     83  CA  ALA A  12      70.180  47.631  46.186  1.00 29.31           C  
ATOM     84  C   ALA A  12      69.708  48.709  47.158  1.00 31.08           C  
ATOM     85  O   ALA A  12      68.540  48.719  47.561  1.00 32.80           O  
ATOM     86  CB  ALA A  12      69.190  47.489  45.033  1.00 27.86           C  
ATOM     87  N   ILE A  13      70.611  49.608  47.537  1.00 30.97           N  
ATOM     88  CA  ILE A  13      70.272  50.667  48.480  1.00 32.33           C  
ATOM     89  C   ILE A  13      69.678  51.920  47.836  1.00 32.55           C  
ATOM     90  O   ILE A  13      68.880  52.626  48.463  1.00 34.49           O  
ATOM     91  CB  ILE A  13      71.509  51.068  49.303  1.00 33.17           C  
ATOM     92  CG1 ILE A  13      71.989  49.867  50.133  1.00 33.41           C  
ATOM     93  CG2 ILE A  13      71.174  52.246  50.217  1.00 33.17           C  
ATOM     94  CD1 ILE A  13      73.242  50.122  50.941  1.00 35.23           C  
ATOM     95  N   GLY A  14      70.047  52.182  46.586  1.00 30.72           N  
ATOM     96  CA  GLY A  14      69.534  53.363  45.911  1.00 29.40           C  
ATOM     97  C   GLY A  14      68.372  53.144  44.955  1.00 27.85           C  
ATOM     98  O   GLY A  14      67.648  52.146  45.060  1.00 27.54           O  
ATOM     99  N   PRO A  15      68.165  54.081  44.007  1.00 25.43           N  
ATOM    100  CA  PRO A  15      67.095  54.032  43.004  1.00 23.40           C  
ATOM    101  C   PRO A  15      67.388  53.062  41.852  1.00 22.85           C  
ATOM    102  O   PRO A  15      67.276  53.424  40.677  1.00 20.97           O  
ATOM    103  CB  PRO A  15      67.016  55.479  42.531  1.00 22.26           C  
ATOM    104  CG  PRO A  15      68.445  55.895  42.577  1.00 21.17           C  
ATOM    105  CD  PRO A  15      68.890  55.362  43.918  1.00 24.07           C  
ATOM    106  N   TYR A  16      67.761  51.833  42.196  1.00 20.13           N  
ATOM    107  CA  TYR A  16      68.063  50.808  41.199  1.00 18.69           C  
ATOM    108  C   TYR A  16      67.755  49.427  41.778  1.00 17.06           C  
ATOM    109  O   TYR A  16      67.657  49.260  42.996  1.00 14.71           O  
ATOM    110  CB  TYR A  16      69.544  50.883  40.797  1.00 18.24           C  
ATOM    111  CG  TYR A  16      70.491  50.518  41.917  1.00 20.21           C  
ATOM    112  CD1 TYR A  16      70.910  49.200  42.101  1.00 22.56           C  
ATOM    113  CD2 TYR A  16      70.912  51.478  42.838  1.00 23.53           C  
ATOM    114  CE1 TYR A  16      71.725  48.843  43.182  1.00 23.96           C  
ATOM    115  CE2 TYR A  16      71.725  51.134  43.925  1.00 24.87           C  
ATOM    116  CZ  TYR A  16      72.124  49.813  44.090  1.00 25.49           C  
ATOM    117  OH  TYR A  16      72.901  49.461  45.171  1.00 26.25           O  
ATOM    118  N   ALA A  17      67.587  48.446  40.898  1.00 15.63           N  
ATOM    119  CA  ALA A  17      67.326  47.082  41.327  1.00 14.73           C  
ATOM    120  C   ALA A  17      68.522  46.272  40.862  1.00 13.56           C  
ATOM    121  O   ALA A  17      69.103  46.588  39.829  1.00 14.87           O  
ATOM    122  CB  ALA A  17      66.037  46.558  40.690  1.00 15.33           C  
ATOM    123  N   GLN A  18      68.904  45.253  41.632  1.00 13.67           N  
ATOM    124  CA  GLN A  18      70.040  44.398  41.281  1.00 11.77           C  
ATOM    125  C   GLN A  18      69.912  43.935  39.831  1.00 10.48           C  
ATOM    126  O   GLN A  18      70.891  43.912  39.085  1.00 10.43           O  
ATOM    127  CB  GLN A  18      70.099  43.189  42.216  1.00 13.35           C  
ATOM    128  CG  GLN A  18      70.246  43.560  43.686  1.00 13.31           C  
ATOM    129  CD  GLN A  18      69.980  42.384  44.599  1.00 14.72           C  
ATOM    130  OE1 GLN A  18      68.951  41.733  44.481  1.00 15.47           O  
ATOM    131  NE2 GLN A  18      70.904  42.108  45.516  1.00 11.44           N  
ATOM    132  N   ALA A  19      68.700  43.560  39.441  1.00  9.10           N  
ATOM    133  CA  ALA A  19      68.441  43.145  38.070  1.00  9.22           C  
ATOM    134  C   ALA A  19      66.979  43.366  37.699  1.00 10.92           C  
ATOM    135  O   ALA A  19      66.109  43.489  38.565  1.00 10.49           O  
ATOM    136  CB  ALA A  19      68.818  41.692  37.870  1.00  7.97           C  
ATOM    137  N   VAL A  20      66.728  43.428  36.395  1.00 12.45           N  
ATOM    138  CA  VAL A  20      65.388  43.625  35.855  1.00 12.20           C  
ATOM    139  C   VAL A  20      65.175  42.657  34.701  1.00 12.26           C  
ATOM    140  O   VAL A  20      66.011  42.564  33.810  1.00 12.35           O  
ATOM    141  CB  VAL A  20      65.199  45.076  35.325  1.00 12.73           C  
ATOM    142  CG1 VAL A  20      63.857  45.201  34.596  1.00 11.87           C  
ATOM    143  CG2 VAL A  20      65.276  46.069  36.479  1.00 12.13           C  
ATOM    144  N   LYS A  21      64.061  41.934  34.724  1.00 13.70           N  
ATOM    145  CA  LYS A  21      63.742  40.991  33.648  1.00 16.22           C  
ATOM    146  C   LYS A  21      62.684  41.614  32.736  1.00 15.20           C  
ATOM    147  O   LYS A  21      61.590  41.955  33.186  1.00 14.59           O  
ATOM    148  CB  LYS A  21      63.222  39.666  34.217  1.00 17.44           C  
ATOM    149  CG  LYS A  21      64.127  39.042  35.275  1.00 21.93           C  
ATOM    150  CD  LYS A  21      64.006  37.519  35.297  1.00 26.02           C  
ATOM    151  CE  LYS A  21      62.559  37.054  35.442  1.00 28.03           C  
ATOM    152  NZ  LYS A  21      62.434  35.568  35.371  1.00 26.95           N  
ATOM    153  N   ALA A  22      63.023  41.778  31.460  1.00 15.90           N  
ATOM    154  CA  ALA A  22      62.095  42.376  30.501  1.00 15.84           C  
ATOM    155  C   ALA A  22      62.355  41.940  29.057  1.00 16.02           C  
ATOM    156  O   ALA A  22      63.503  41.823  28.624  1.00 14.46           O  
ATOM    157  CB  ALA A  22      62.161  43.894  30.604  1.00 15.19           C  
ATOM    158  N   GLY A  23      61.274  41.698  28.321  1.00 15.82           N  
ATOM    159  CA  GLY A  23      61.377  41.301  26.926  1.00 17.42           C  
ATOM    160  C   GLY A  23      62.353  40.188  26.587  1.00 18.69           C  
ATOM    161  O   GLY A  23      63.119  40.301  25.622  1.00 18.26           O  
ATOM    162  N   GLY A  24      62.324  39.115  27.372  1.00 17.99           N  
ATOM    163  CA  GLY A  24      63.203  37.988  27.124  1.00 18.71           C  
ATOM    164  C   GLY A  24      64.609  38.116  27.685  1.00 17.06           C  
ATOM    165  O   GLY A  24      65.373  37.150  27.654  1.00 16.73           O  
ATOM    166  N   PHE A  25      64.957  39.295  28.197  1.00 15.99           N  
ATOM    167  CA  PHE A  25      66.291  39.501  28.763  1.00 16.14           C  
ATOM    168  C   PHE A  25      66.271  39.820  30.246  1.00 14.21           C  
ATOM    169  O   PHE A  25      65.221  40.092  30.832  1.00 13.49           O  
ATOM    170  CB  PHE A  25      67.039  40.638  28.041  1.00 15.43           C  
ATOM    171  CG  PHE A  25      67.307  40.367  26.590  1.00 15.51           C  
ATOM    172  CD1 PHE A  25      66.425  40.815  25.611  1.00 14.79           C  
ATOM    173  CD2 PHE A  25      68.421  39.627  26.202  1.00 14.19           C  
ATOM    174  CE1 PHE A  25      66.647  40.528  24.269  1.00 14.53           C  
ATOM    175  CE2 PHE A  25      68.650  39.333  24.857  1.00 12.60           C  
ATOM    176  CZ  PHE A  25      67.762  39.784  23.891  1.00 13.61           C  
ATOM    177  N   VAL A  26      67.456  39.763  30.842  1.00 12.27           N  
ATOM    178  CA  VAL A  26      67.654  40.087  32.244  1.00 11.82           C  
ATOM    179  C   VAL A  26      68.766  41.130  32.249  1.00  9.47           C  
ATOM    180  O   VAL A  26      69.877  40.861  31.795  1.00  7.86           O  
ATOM    181  CB  VAL A  26      68.131  38.874  33.073  1.00 11.92           C  
ATOM    182  CG1 VAL A  26      68.219  39.271  34.559  1.00 13.50           C  
ATOM    183  CG2 VAL A  26      67.191  37.698  32.875  1.00 12.57           C  
ATOM    184  N   PHE A  27      68.458  42.319  32.747  1.00  8.58           N  
ATOM    185  CA  PHE A  27      69.434  43.398  32.805  1.00  9.88           C  
ATOM    186  C   PHE A  27      70.001  43.489  34.212  1.00 10.83           C  
ATOM    187  O   PHE A  27      69.289  43.828  35.153  1.00 11.11           O  
ATOM    188  CB  PHE A  27      68.764  44.706  32.398  1.00  8.50           C  
ATOM    189  CG  PHE A  27      68.210  44.681  31.002  1.00  8.68           C  
ATOM    190  CD1 PHE A  27      69.000  45.047  29.920  1.00  7.29           C  
ATOM    191  CD2 PHE A  27      66.907  44.247  30.768  1.00  8.34           C  
ATOM    192  CE1 PHE A  27      68.501  44.984  28.622  1.00 11.02           C  
ATOM    193  CE2 PHE A  27      66.399  44.179  29.479  1.00  9.11           C  
ATOM    194  CZ  PHE A  27      67.197  44.546  28.401  1.00  9.02           C  
ATOM    195  N   VAL A  28      71.286  43.175  34.350  1.00 11.39           N  
ATOM    196  CA  VAL A  28      71.938  43.196  35.656  1.00 11.64           C  
ATOM    197  C   VAL A  28      72.741  44.463  35.894  1.00 11.47           C  
ATOM    198  O   VAL A  28      73.541  44.870  35.050  1.00 12.06           O  
ATOM    199  CB  VAL A  28      72.882  41.977  35.835  1.00 11.72           C  
ATOM    200  CG1 VAL A  28      73.524  42.014  37.221  1.00 10.16           C  
ATOM    201  CG2 VAL A  28      72.101  40.675  35.639  1.00 13.29           C  
ATOM    202  N   SER A  29      72.530  45.070  37.058  1.00  9.94           N  
ATOM    203  CA  SER A  29      73.227  46.292  37.439  1.00  9.45           C  
ATOM    204  C   SER A  29      74.723  46.047  37.610  1.00  9.37           C  
ATOM    205  O   SER A  29      75.157  44.915  37.852  1.00  8.79           O  
ATOM    206  CB  SER A  29      72.651  46.845  38.750  1.00  7.78           C  
ATOM    207  OG  SER A  29      71.330  47.325  38.571  1.00  9.27           O  
ATOM    208  N   GLY A  30      75.505  47.115  37.464  1.00  9.42           N  
ATOM    209  CA  GLY A  30      76.943  47.012  37.627  1.00 10.79           C  
ATOM    210  C   GLY A  30      77.256  46.546  39.038  1.00 11.29           C  
ATOM    211  O   GLY A  30      76.949  47.235  40.015  1.00 11.23           O  
ATOM    212  N   GLN A  31      77.859  45.365  39.151  1.00 12.06           N  
ATOM    213  CA  GLN A  31      78.193  44.809  40.454  1.00 11.26           C  
ATOM    214  C   GLN A  31      79.597  45.205  40.862  1.00 10.91           C  
ATOM    215  O   GLN A  31      80.510  45.215  40.043  1.00 10.01           O  
ATOM    216  CB  GLN A  31      78.071  43.278  40.430  1.00 13.01           C  
ATOM    217  CG  GLN A  31      76.695  42.769  40.014  1.00 12.85           C  
ATOM    218  CD  GLN A  31      75.584  43.195  40.960  1.00 15.56           C  
ATOM    219  OE1 GLN A  31      74.494  43.586  40.525  1.00 15.55           O  
ATOM    220  NE2 GLN A  31      75.846  43.108  42.258  1.00 15.16           N  
ATOM    221  N   ILE A  32      79.752  45.554  42.136  1.00 12.42           N  
ATOM    222  CA  ILE A  32      81.051  45.936  42.690  1.00 12.80           C  
ATOM    223  C   ILE A  32      81.441  44.940  43.791  1.00 12.18           C  
ATOM    224  O   ILE A  32      80.629  44.115  44.210  1.00 11.12           O  
ATOM    225  CB  ILE A  32      81.024  47.372  43.257  1.00 13.40           C  
ATOM    226  CG1 ILE A  32      79.827  47.539  44.192  1.00 12.60           C  
ATOM    227  CG2 ILE A  32      80.978  48.383  42.105  1.00 11.58           C  
ATOM    228  CD1 ILE A  32      79.758  48.891  44.859  1.00 15.44           C  
ATOM    229  N   PRO A  33      82.700  44.992  44.247  1.00 12.48           N  
ATOM    230  CA  PRO A  33      83.266  44.123  45.288  1.00 14.54           C  
ATOM    231  C   PRO A  33      82.655  44.218  46.686  1.00 14.97           C  
ATOM    232  O   PRO A  33      83.378  44.369  47.671  1.00 15.86           O  
ATOM    233  CB  PRO A  33      84.743  44.511  45.289  1.00 14.18           C  
ATOM    234  CG  PRO A  33      84.978  44.903  43.882  1.00 15.77           C  
ATOM    235  CD  PRO A  33      83.772  45.731  43.566  1.00 13.00           C  
ATOM    236  N   LEU A  34      81.332  44.129  46.774  1.00 16.01           N  
ATOM    237  CA  LEU A  34      80.660  44.173  48.066  1.00 16.54           C  
ATOM    238  C   LEU A  34      80.184  42.775  48.408  1.00 17.00           C  
ATOM    239  O   LEU A  34      79.767  42.025  47.526  1.00 16.83           O  
ATOM    240  CB  LEU A  34      79.444  45.104  48.035  1.00 16.82           C  
ATOM    241  CG  LEU A  34      79.635  46.614  47.992  1.00 17.93           C  
ATOM    242  CD1 LEU A  34      78.274  47.271  47.886  1.00 18.15           C  
ATOM    243  CD2 LEU A  34      80.359  47.094  49.242  1.00 19.97           C  
ATOM    244  N   ALA A  35      80.261  42.426  49.688  1.00 18.07           N  
ATOM    245  CA  ALA A  35      79.795  41.130  50.156  1.00 18.27           C  
ATOM    246  C   ALA A  35      78.282  41.285  50.321  1.00 18.24           C  
ATOM    247  O   ALA A  35      77.769  42.402  50.324  1.00 16.98           O  
ATOM    248  CB  ALA A  35      80.449  40.789  51.497  1.00 18.60           C  
ATOM    249  N   PRO A  36      77.548  40.172  50.442  1.00 19.02           N  
ATOM    250  CA  PRO A  36      76.093  40.261  50.605  1.00 20.94           C  
ATOM    251  C   PRO A  36      75.656  41.207  51.726  1.00 22.36           C  
ATOM    252  O   PRO A  36      74.569  41.792  51.668  1.00 22.40           O  
ATOM    253  CB  PRO A  36      75.694  38.814  50.873  1.00 19.83           C  
ATOM    254  CG  PRO A  36      76.636  38.065  49.989  1.00 19.64           C  
ATOM    255  CD  PRO A  36      77.966  38.772  50.237  1.00 20.05           C  
ATOM    256  N   ASP A  37      76.506  41.368  52.736  1.00 22.64           N  
ATOM    257  CA  ASP A  37      76.173  42.239  53.857  1.00 24.74           C  
ATOM    258  C   ASP A  37      76.539  43.710  53.606  1.00 24.32           C  
ATOM    259  O   ASP A  37      76.481  44.538  54.515  1.00 23.05           O  
ATOM    260  CB  ASP A  37      76.844  41.730  55.145  1.00 26.67           C  
ATOM    261  CG  ASP A  37      78.303  42.130  55.247  1.00 29.34           C  
ATOM    262  OD1 ASP A  37      79.121  41.651  54.436  1.00 31.08           O  
ATOM    263  OD2 ASP A  37      78.629  42.932  56.148  1.00 32.83           O  
ATOM    264  N   GLY A  38      76.913  44.027  52.368  1.00 24.95           N  
ATOM    265  CA  GLY A  38      77.254  45.396  52.018  1.00 26.05           C  
ATOM    266  C   GLY A  38      78.665  45.827  52.364  1.00 27.96           C  
ATOM    267  O   GLY A  38      79.046  46.974  52.107  1.00 29.88           O  
ATOM    268  N   SER A  39      79.447  44.923  52.949  1.00 27.30           N  
ATOM    269  CA  SER A  39      80.824  45.239  53.325  1.00 26.48           C  
ATOM    270  C   SER A  39      81.706  45.154  52.091  1.00 26.24           C  
ATOM    271  O   SER A  39      81.556  44.251  51.268  1.00 26.13           O  
ATOM    272  CB  SER A  39      81.334  44.253  54.377  1.00 24.59           C  
ATOM    273  OG  SER A  39      81.451  42.953  53.825  1.00 25.32           O  
ATOM    274  N   LEU A  40      82.629  46.094  51.958  1.00 26.41           N  
ATOM    275  CA  LEU A  40      83.516  46.091  50.808  1.00 27.43           C  
ATOM    276  C   LEU A  40      84.614  45.035  50.976  1.00 26.39           C  
ATOM    277  O   LEU A  40      85.184  44.882  52.056  1.00 25.60           O  
ATOM    278  CB  LEU A  40      84.120  47.488  50.620  1.00 29.89           C  
ATOM    279  CG  LEU A  40      84.952  47.757  49.362  1.00 30.92           C  
ATOM    280  CD1 LEU A  40      86.324  47.112  49.485  1.00 31.39           C  
ATOM    281  CD2 LEU A  40      84.197  47.245  48.140  1.00 30.40           C  
ATOM    282  N   VAL A  41      84.885  44.297  49.902  1.00 25.20           N  
ATOM    283  CA  VAL A  41      85.912  43.258  49.908  1.00 24.91           C  
ATOM    284  C   VAL A  41      87.234  43.840  49.413  1.00 25.69           C  
ATOM    285  O   VAL A  41      87.364  44.212  48.246  1.00 25.71           O  
ATOM    286  CB  VAL A  41      85.515  42.060  48.999  1.00 23.73           C  
ATOM    287  CG1 VAL A  41      86.688  41.088  48.853  1.00 21.49           C  
ATOM    288  CG2 VAL A  41      84.305  41.342  49.588  1.00 23.92           C  
ATOM    289  N   GLU A  42      88.210  43.912  50.312  1.00 25.23           N  
ATOM    290  CA  GLU A  42      89.527  44.451  49.996  1.00 26.16           C  
ATOM    291  C   GLU A  42      90.430  43.446  49.289  1.00 25.28           C  
ATOM    292  O   GLU A  42      90.245  42.236  49.400  1.00 25.58           O  
ATOM    293  CB  GLU A  42      90.211  44.910  51.281  1.00 28.97           C  
ATOM    294  CG  GLU A  42      89.490  46.025  52.003  1.00 32.76           C  
ATOM    295  CD  GLU A  42      90.036  46.247  53.396  1.00 34.16           C  
ATOM    296  OE1 GLU A  42      91.239  46.566  53.521  1.00 36.08           O  
ATOM    297  OE2 GLU A  42      89.262  46.089  54.362  1.00 36.08           O  
ATOM    298  N   GLY A  43      91.423  43.962  48.574  1.00 24.67           N  
ATOM    299  CA  GLY A  43      92.351  43.103  47.863  1.00 22.46           C  
ATOM    300  C   GLY A  43      92.680  43.624  46.478  1.00 21.20           C  
ATOM    301  O   GLY A  43      92.189  44.675  46.066  1.00 22.36           O  
ATOM    302  N   ASP A  44      93.519  42.892  45.756  1.00 19.51           N  
ATOM    303  CA  ASP A  44      93.895  43.295  44.407  1.00 19.07           C  
ATOM    304  C   ASP A  44      92.736  43.054  43.444  1.00 17.16           C  
ATOM    305  O   ASP A  44      91.625  42.719  43.865  1.00 15.69           O  
ATOM    306  CB  ASP A  44      95.128  42.514  43.935  1.00 19.57           C  
ATOM    307  CG  ASP A  44      94.970  41.018  44.103  1.00 21.04           C  
ATOM    308  OD1 ASP A  44      93.821  40.526  44.061  1.00 20.11           O  
ATOM    309  OD2 ASP A  44      95.997  40.329  44.270  1.00 22.37           O  
ATOM    310  N   ILE A  45      93.000  43.209  42.151  1.00 14.87           N  
ATOM    311  CA  ILE A  45      91.957  43.020  41.149  1.00 15.43           C  
ATOM    312  C   ILE A  45      91.375  41.602  41.152  1.00 14.53           C  
ATOM    313  O   ILE A  45      90.181  41.420  40.918  1.00 14.87           O  
ATOM    314  CB  ILE A  45      92.478  43.384  39.734  1.00 13.07           C  
ATOM    315  CG1 ILE A  45      91.324  43.346  38.726  1.00 12.62           C  
ATOM    316  CG2 ILE A  45      93.597  42.450  39.333  1.00 14.14           C  
ATOM    317  CD1 ILE A  45      90.196  44.315  39.046  1.00 13.17           C  
ATOM    318  N   ARG A  46      92.203  40.602  41.434  1.00 15.41           N  
ATOM    319  CA  ARG A  46      91.717  39.222  41.464  1.00 17.41           C  
ATOM    320  C   ARG A  46      90.669  39.013  42.561  1.00 16.68           C  
ATOM    321  O   ARG A  46      89.596  38.445  42.317  1.00 14.02           O  
ATOM    322  CB  ARG A  46      92.881  38.252  41.683  1.00 20.23           C  
ATOM    323  CG  ARG A  46      93.921  38.266  40.574  1.00 26.71           C  
ATOM    324  CD  ARG A  46      94.976  37.206  40.825  1.00 31.91           C  
ATOM    325  NE  ARG A  46      96.021  37.217  39.804  1.00 39.88           N  
ATOM    326  CZ  ARG A  46      97.047  36.366  39.772  1.00 43.24           C  
ATOM    327  NH1 ARG A  46      97.168  35.429  40.706  1.00 43.63           N  
ATOM    328  NH2 ARG A  46      97.958  36.455  38.810  1.00 43.30           N  
ATOM    329  N   VAL A  47      90.990  39.479  43.767  1.00 16.29           N  
ATOM    330  CA  VAL A  47      90.098  39.354  44.916  1.00 16.98           C  
ATOM    331  C   VAL A  47      88.786  40.101  44.691  1.00 16.37           C  
ATOM    332  O   VAL A  47      87.699  39.583  44.984  1.00 15.91           O  
ATOM    333  CB  VAL A  47      90.750  39.910  46.208  1.00 17.94           C  
ATOM    334  CG1 VAL A  47      89.923  39.511  47.416  1.00 15.95           C  
ATOM    335  CG2 VAL A  47      92.178  39.405  46.341  1.00 15.99           C  
ATOM    336  N   GLN A  48      88.881  41.322  44.175  1.00 14.13           N  
ATOM    337  CA  GLN A  48      87.679  42.102  43.934  1.00 14.68           C  
ATOM    338  C   GLN A  48      86.837  41.569  42.778  1.00 14.17           C  
ATOM    339  O   GLN A  48      85.602  41.572  42.859  1.00 11.43           O  
ATOM    340  CB  GLN A  48      88.030  43.569  43.693  1.00 16.25           C  
ATOM    341  CG  GLN A  48      88.504  44.298  44.948  1.00 17.13           C  
ATOM    342  CD  GLN A  48      88.073  45.749  44.965  1.00 17.90           C  
ATOM    343  OE1 GLN A  48      88.261  46.476  43.993  1.00 16.68           O  
ATOM    344  NE2 GLN A  48      87.486  46.180  46.074  1.00 22.74           N  
ATOM    345  N   THR A  49      87.491  41.108  41.712  1.00 11.85           N  
ATOM    346  CA  THR A  49      86.758  40.572  40.562  1.00 13.66           C  
ATOM    347  C   THR A  49      85.963  39.337  41.000  1.00 14.03           C  
ATOM    348  O   THR A  49      84.828  39.121  40.578  1.00 12.34           O  
ATOM    349  CB  THR A  49      87.709  40.181  39.404  1.00 11.42           C  
ATOM    350  OG1 THR A  49      88.364  41.352  38.907  1.00 12.66           O  
ATOM    351  CG2 THR A  49      86.928  39.537  38.266  1.00 10.70           C  
ATOM    352  N   GLU A  50      86.578  38.532  41.858  1.00 14.77           N  
ATOM    353  CA  GLU A  50      85.940  37.334  42.373  1.00 15.65           C  
ATOM    354  C   GLU A  50      84.594  37.699  43.021  1.00 13.99           C  
ATOM    355  O   GLU A  50      83.569  37.093  42.721  1.00 15.00           O  
ATOM    356  CB  GLU A  50      86.873  36.672  43.391  1.00 18.68           C  
ATOM    357  CG  GLU A  50      86.705  35.172  43.546  1.00 25.83           C  
ATOM    358  CD  GLU A  50      85.416  34.778  44.243  1.00 29.18           C  
ATOM    359  OE1 GLU A  50      85.153  35.284  45.360  1.00 32.57           O  
ATOM    360  OE2 GLU A  50      84.671  33.950  43.678  1.00 30.33           O  
ATOM    361  N   ARG A  51      84.596  38.699  43.900  1.00 13.31           N  
ATOM    362  CA  ARG A  51      83.374  39.122  44.574  1.00 11.50           C  
ATOM    363  C   ARG A  51      82.324  39.590  43.570  1.00 11.64           C  
ATOM    364  O   ARG A  51      81.153  39.232  43.667  1.00  9.83           O  
ATOM    365  CB  ARG A  51      83.668  40.255  45.552  1.00 11.71           C  
ATOM    366  CG  ARG A  51      82.501  40.605  46.462  1.00 11.65           C  
ATOM    367  CD  ARG A  51      82.066  39.377  47.264  1.00 13.00           C  
ATOM    368  NE  ARG A  51      80.774  38.854  46.824  1.00 16.57           N  
ATOM    369  CZ  ARG A  51      80.252  37.702  47.236  1.00 16.58           C  
ATOM    370  NH1 ARG A  51      80.917  36.947  48.099  1.00 19.15           N  
ATOM    371  NH2 ARG A  51      79.059  37.313  46.801  1.00 16.77           N  
ATOM    372  N   VAL A  52      82.749  40.402  42.608  1.00 11.86           N  
ATOM    373  CA  VAL A  52      81.839  40.903  41.585  1.00 11.83           C  
ATOM    374  C   VAL A  52      81.217  39.755  40.788  1.00 12.10           C  
ATOM    375  O   VAL A  52      80.016  39.746  40.528  1.00 12.18           O  
ATOM    376  CB  VAL A  52      82.571  41.869  40.635  1.00 10.30           C  
ATOM    377  CG1 VAL A  52      81.697  42.180  39.415  1.00  9.96           C  
ATOM    378  CG2 VAL A  52      82.910  43.153  41.387  1.00  8.66           C  
HETATM  379  N   MSE A  53      82.039  38.786  40.407  1.00 12.51           N  
HETATM  380  CA  MSE A  53      81.558  37.637  39.656  1.00 13.34           C  
HETATM  381  C   MSE A  53      80.579  36.823  40.505  1.00 13.83           C  
HETATM  382  O   MSE A  53      79.594  36.288  39.987  1.00 12.41           O  
HETATM  383  CB  MSE A  53      82.742  36.777  39.213  1.00 14.99           C  
HETATM  384  CG  MSE A  53      83.712  37.518  38.292  1.00 18.51           C  
HETATM  385 SE   MSE A  53      82.828  38.325  36.747  1.00 24.70          SE  
HETATM  386  CE  MSE A  53      82.462  36.710  35.804  1.00 21.00           C  
ATOM    387  N   GLU A  54      80.850  36.731  41.808  1.00 12.18           N  
ATOM    388  CA  GLU A  54      79.968  36.010  42.722  1.00 12.27           C  
ATOM    389  C   GLU A  54      78.645  36.757  42.868  1.00 11.00           C  
ATOM    390  O   GLU A  54      77.581  36.143  42.970  1.00 11.33           O  
ATOM    391  CB  GLU A  54      80.622  35.858  44.097  1.00 13.73           C  
ATOM    392  CG  GLU A  54      81.735  34.826  44.143  1.00 16.88           C  
ATOM    393  CD  GLU A  54      81.272  33.464  43.663  1.00 18.27           C  
ATOM    394  OE1 GLU A  54      80.231  32.979  44.162  1.00 18.98           O  
ATOM    395  OE2 GLU A  54      81.946  32.879  42.788  1.00 20.11           O  
ATOM    396  N   ASN A  55      78.708  38.083  42.884  1.00  9.49           N  
ATOM    397  CA  ASN A  55      77.488  38.878  42.991  1.00 10.05           C  
ATOM    398  C   ASN A  55      76.667  38.731  41.710  1.00 10.07           C  
ATOM    399  O   ASN A  55      75.436  38.695  41.748  1.00  8.95           O  
ATOM    400  CB  ASN A  55      77.814  40.359  43.229  1.00 10.61           C  
ATOM    401  CG  ASN A  55      78.387  40.616  44.604  1.00  9.39           C  
ATOM    402  OD1 ASN A  55      78.125  39.868  45.547  1.00  8.82           O  
ATOM    403  ND2 ASN A  55      79.158  41.689  44.733  1.00  8.67           N  
ATOM    404  N   LEU A  56      77.357  38.648  40.575  1.00 11.18           N  
ATOM    405  CA  LEU A  56      76.690  38.495  39.283  1.00 13.52           C  
ATOM    406  C   LEU A  56      75.969  37.151  39.206  1.00 13.65           C  
ATOM    407  O   LEU A  56      74.832  37.080  38.737  1.00 13.70           O  
ATOM    408  CB  LEU A  56      77.706  38.632  38.135  1.00 14.85           C  
ATOM    409  CG  LEU A  56      78.143  40.074  37.827  1.00 15.47           C  
ATOM    410  CD1 LEU A  56      79.330  40.075  36.876  1.00 14.33           C  
ATOM    411  CD2 LEU A  56      76.966  40.853  37.234  1.00 12.17           C  
ATOM    412  N   LYS A  57      76.628  36.094  39.675  1.00 13.94           N  
ATOM    413  CA  LYS A  57      76.034  34.759  39.683  1.00 15.42           C  
ATOM    414  C   LYS A  57      74.772  34.760  40.534  1.00 14.68           C  
ATOM    415  O   LYS A  57      73.741  34.224  40.128  1.00 13.22           O  
ATOM    416  CB  LYS A  57      77.000  33.732  40.277  1.00 17.11           C  
ATOM    417  CG  LYS A  57      78.190  33.398  39.426  1.00 20.58           C  
ATOM    418  CD  LYS A  57      79.111  32.435  40.162  1.00 23.23           C  
ATOM    419  CE  LYS A  57      78.379  31.169  40.576  1.00 24.52           C  
ATOM    420  NZ  LYS A  57      79.269  30.231  41.316  1.00 25.12           N  
ATOM    421  N   ALA A  58      74.877  35.351  41.727  1.00 13.82           N  
ATOM    422  CA  ALA A  58      73.767  35.439  42.672  1.00 12.14           C  
ATOM    423  C   ALA A  58      72.559  36.122  42.052  1.00 11.25           C  
ATOM    424  O   ALA A  58      71.441  35.608  42.121  1.00 10.19           O  
ATOM    425  CB  ALA A  58      74.204  36.197  43.923  1.00 13.38           C  
ATOM    426  N   VAL A  59      72.784  37.288  41.455  1.00  9.44           N  
ATOM    427  CA  VAL A  59      71.696  38.025  40.822  1.00 10.61           C  
ATOM    428  C   VAL A  59      71.098  37.229  39.656  1.00 10.93           C  
ATOM    429  O   VAL A  59      69.879  37.050  39.585  1.00 11.49           O  
ATOM    430  CB  VAL A  59      72.167  39.408  40.311  1.00  8.65           C  
ATOM    431  CG1 VAL A  59      71.036  40.098  39.551  1.00  9.46           C  
ATOM    432  CG2 VAL A  59      72.597  40.269  41.488  1.00  9.57           C  
ATOM    433  N   LEU A  60      71.958  36.745  38.757  1.00  9.66           N  
ATOM    434  CA  LEU A  60      71.515  35.971  37.595  1.00  9.38           C  
ATOM    435  C   LEU A  60      70.730  34.737  38.012  1.00  8.46           C  
ATOM    436  O   LEU A  60      69.714  34.413  37.407  1.00  8.62           O  
ATOM    437  CB  LEU A  60      72.719  35.542  36.747  1.00  8.39           C  
ATOM    438  CG  LEU A  60      73.462  36.648  35.995  1.00  7.86           C  
ATOM    439  CD1 LEU A  60      74.806  36.129  35.501  1.00  9.28           C  
ATOM    440  CD2 LEU A  60      72.612  37.138  34.833  1.00 10.53           C  
ATOM    441  N   GLU A  61      71.203  34.053  39.048  1.00  8.87           N  
ATOM    442  CA  GLU A  61      70.530  32.859  39.542  1.00 11.29           C  
ATOM    443  C   GLU A  61      69.158  33.204  40.097  1.00 11.14           C  
ATOM    444  O   GLU A  61      68.190  32.484  39.859  1.00 12.05           O  
ATOM    445  CB  GLU A  61      71.390  32.186  40.604  1.00 12.63           C  
ATOM    446  CG  GLU A  61      72.613  31.502  40.018  1.00 15.94           C  
ATOM    447  CD  GLU A  61      73.632  31.129  41.069  1.00 18.15           C  
ATOM    448  OE1 GLU A  61      74.643  30.485  40.710  1.00 17.76           O  
ATOM    449  OE2 GLU A  61      73.425  31.488  42.247  1.00 19.99           O  
ATOM    450  N   ALA A  62      69.075  34.315  40.826  1.00 11.47           N  
ATOM    451  CA  ALA A  62      67.809  34.768  41.400  1.00 12.43           C  
ATOM    452  C   ALA A  62      66.789  35.075  40.294  1.00 13.49           C  
ATOM    453  O   ALA A  62      65.578  34.961  40.496  1.00 12.43           O  
ATOM    454  CB  ALA A  62      68.043  36.008  42.248  1.00 11.92           C  
ATOM    455  N   ALA A  63      67.294  35.458  39.123  1.00 12.14           N  
ATOM    456  CA  ALA A  63      66.441  35.789  37.986  1.00 13.87           C  
ATOM    457  C   ALA A  63      65.974  34.536  37.250  1.00 14.11           C  
ATOM    458  O   ALA A  63      65.073  34.601  36.410  1.00 17.30           O  
ATOM    459  CB  ALA A  63      67.193  36.703  37.028  1.00 10.60           C  
ATOM    460  N   GLY A  64      66.577  33.400  37.580  1.00 13.54           N  
ATOM    461  CA  GLY A  64      66.229  32.151  36.927  1.00 13.19           C  
ATOM    462  C   GLY A  64      67.134  31.981  35.722  1.00 14.51           C  
ATOM    463  O   GLY A  64      66.856  31.215  34.798  1.00 15.25           O  
ATOM    464  N   SER A  65      68.235  32.723  35.743  1.00 14.70           N  
ATOM    465  CA  SER A  65      69.215  32.701  34.669  1.00 13.35           C  
ATOM    466  C   SER A  65      70.526  32.162  35.232  1.00 12.58           C  
ATOM    467  O   SER A  65      70.538  31.464  36.248  1.00 11.38           O  
ATOM    468  CB  SER A  65      69.400  34.126  34.120  1.00 14.26           C  
ATOM    469  OG  SER A  65      70.132  34.151  32.907  1.00 12.72           O  
ATOM    470  N   GLY A  66      71.626  32.486  34.565  1.00 13.47           N  
ATOM    471  CA  GLY A  66      72.930  32.034  35.011  1.00 12.65           C  
ATOM    472  C   GLY A  66      73.985  32.610  34.091  1.00 14.33           C  
ATOM    473  O   GLY A  66      73.656  33.215  33.065  1.00 15.05           O  
ATOM    474  N   LEU A  67      75.248  32.416  34.449  1.00 12.81           N  
ATOM    475  CA  LEU A  67      76.367  32.926  33.659  1.00 12.93           C  
ATOM    476  C   LEU A  67      76.388  32.412  32.219  1.00 12.86           C  
ATOM    477  O   LEU A  67      76.820  33.124  31.316  1.00 12.27           O  
ATOM    478  CB  LEU A  67      77.693  32.577  34.349  1.00 13.41           C  
ATOM    479  CG  LEU A  67      77.940  33.234  35.713  1.00 12.33           C  
ATOM    480  CD1 LEU A  67      79.127  32.578  36.400  1.00 13.77           C  
ATOM    481  CD2 LEU A  67      78.173  34.720  35.528  1.00 10.86           C  
ATOM    482  N   SER A  68      75.922  31.185  31.998  1.00 12.56           N  
ATOM    483  CA  SER A  68      75.915  30.618  30.650  1.00 12.67           C  
ATOM    484  C   SER A  68      74.869  31.269  29.745  1.00 12.32           C  
ATOM    485  O   SER A  68      74.859  31.027  28.538  1.00 13.96           O  
ATOM    486  CB  SER A  68      75.672  29.106  30.704  1.00 11.41           C  
ATOM    487  OG  SER A  68      74.334  28.813  31.052  1.00 12.87           O  
ATOM    488  N   ARG A  69      73.987  32.081  30.326  1.00 10.94           N  
ATOM    489  CA  ARG A  69      72.953  32.760  29.549  1.00 12.79           C  
ATOM    490  C   ARG A  69      73.318  34.220  29.285  1.00 11.47           C  
ATOM    491  O   ARG A  69      72.604  34.923  28.565  1.00 10.79           O  
ATOM    492  CB  ARG A  69      71.602  32.706  30.267  1.00 11.93           C  
ATOM    493  CG  ARG A  69      71.034  31.300  30.511  1.00 17.39           C  
ATOM    494  CD  ARG A  69      70.885  30.441  29.244  1.00 16.84           C  
ATOM    495  NE  ARG A  69      72.051  29.571  29.071  1.00 21.55           N  
ATOM    496  CZ  ARG A  69      72.059  28.422  28.397  1.00 19.46           C  
ATOM    497  NH1 ARG A  69      70.953  27.980  27.808  1.00 18.96           N  
ATOM    498  NH2 ARG A  69      73.175  27.703  28.334  1.00 18.58           N  
ATOM    499  N   VAL A  70      74.425  34.671  29.872  1.00 11.62           N  
ATOM    500  CA  VAL A  70      74.896  36.045  29.682  1.00 10.81           C  
ATOM    501  C   VAL A  70      75.343  36.230  28.227  1.00  9.80           C  
ATOM    502  O   VAL A  70      76.199  35.490  27.729  1.00  8.54           O  
ATOM    503  CB  VAL A  70      76.078  36.364  30.632  1.00 10.59           C  
ATOM    504  CG1 VAL A  70      76.613  37.771  30.363  1.00  7.14           C  
ATOM    505  CG2 VAL A  70      75.615  36.234  32.078  1.00  9.65           C  
ATOM    506  N   VAL A  71      74.749  37.212  27.553  1.00  8.80           N  
ATOM    507  CA  VAL A  71      75.058  37.492  26.153  1.00  9.10           C  
ATOM    508  C   VAL A  71      75.988  38.687  25.954  1.00  9.47           C  
ATOM    509  O   VAL A  71      76.658  38.801  24.916  1.00 10.29           O  
ATOM    510  CB  VAL A  71      73.761  37.752  25.356  1.00  9.12           C  
ATOM    511  CG1 VAL A  71      72.873  36.503  25.387  1.00 11.25           C  
ATOM    512  CG2 VAL A  71      73.021  38.955  25.939  1.00 10.39           C  
ATOM    513  N   GLN A  72      76.027  39.570  26.949  1.00  8.81           N  
ATOM    514  CA  GLN A  72      76.847  40.777  26.884  1.00  9.39           C  
ATOM    515  C   GLN A  72      77.264  41.247  28.271  1.00  8.36           C  
ATOM    516  O   GLN A  72      76.485  41.184  29.222  1.00  7.40           O  
ATOM    517  CB  GLN A  72      76.053  41.903  26.200  1.00 10.07           C  
ATOM    518  CG  GLN A  72      76.765  43.256  26.130  1.00 10.63           C  
ATOM    519  CD  GLN A  72      75.784  44.428  26.112  1.00  9.34           C  
ATOM    520  OE1 GLN A  72      75.074  44.662  27.086  1.00 12.61           O  
ATOM    521  NE2 GLN A  72      75.739  45.157  25.000  1.00  9.14           N  
ATOM    522  N   THR A  73      78.501  41.705  28.387  1.00  7.47           N  
ATOM    523  CA  THR A  73      78.984  42.236  29.651  1.00  7.39           C  
ATOM    524  C   THR A  73      79.701  43.550  29.365  1.00  7.58           C  
ATOM    525  O   THR A  73      80.285  43.739  28.297  1.00  7.94           O  
ATOM    526  CB  THR A  73      79.960  41.269  30.377  1.00  8.52           C  
ATOM    527  OG1 THR A  73      81.196  41.193  29.657  1.00  7.75           O  
ATOM    528  CG2 THR A  73      79.346  39.883  30.496  1.00  6.10           C  
ATOM    529  N   THR A  74      79.623  44.463  30.318  1.00  8.51           N  
ATOM    530  CA  THR A  74      80.267  45.762  30.208  1.00  8.69           C  
ATOM    531  C   THR A  74      81.131  45.848  31.452  1.00  8.28           C  
ATOM    532  O   THR A  74      80.625  45.944  32.570  1.00  8.72           O  
ATOM    533  CB  THR A  74      79.226  46.871  30.177  1.00  8.09           C  
ATOM    534  OG1 THR A  74      78.338  46.639  29.073  1.00  8.53           O  
ATOM    535  CG2 THR A  74      79.893  48.218  30.004  1.00  9.15           C  
ATOM    536  N   CYS A  75      82.440  45.808  31.239  1.00  6.35           N  
ATOM    537  CA  CYS A  75      83.391  45.780  32.338  1.00  7.58           C  
ATOM    538  C   CYS A  75      84.236  47.034  32.533  1.00  6.83           C  
ATOM    539  O   CYS A  75      85.018  47.421  31.664  1.00  6.58           O  
ATOM    540  CB  CYS A  75      84.298  44.555  32.154  1.00  7.13           C  
ATOM    541  SG  CYS A  75      83.383  43.063  31.651  1.00 10.34           S  
ATOM    542  N   PHE A  76      84.076  47.657  33.697  1.00  8.16           N  
ATOM    543  CA  PHE A  76      84.819  48.864  34.027  1.00  8.51           C  
ATOM    544  C   PHE A  76      85.868  48.622  35.103  1.00  9.57           C  
ATOM    545  O   PHE A  76      85.579  48.071  36.170  1.00 10.45           O  
ATOM    546  CB  PHE A  76      83.886  49.965  34.525  1.00  8.36           C  
ATOM    547  CG  PHE A  76      82.632  50.109  33.733  1.00  8.49           C  
ATOM    548  CD1 PHE A  76      81.453  49.500  34.161  1.00  9.91           C  
ATOM    549  CD2 PHE A  76      82.606  50.895  32.590  1.00  8.58           C  
ATOM    550  CE1 PHE A  76      80.261  49.679  33.466  1.00 10.14           C  
ATOM    551  CE2 PHE A  76      81.416  51.084  31.883  1.00 10.36           C  
ATOM    552  CZ  PHE A  76      80.242  50.475  32.326  1.00 11.00           C  
ATOM    553  N   LEU A  77      87.089  49.044  34.815  1.00  9.05           N  
ATOM    554  CA  LEU A  77      88.184  48.923  35.757  1.00 10.81           C  
ATOM    555  C   LEU A  77      88.583  50.360  36.062  1.00 12.35           C  
ATOM    556  O   LEU A  77      88.287  51.259  35.286  1.00 13.48           O  
ATOM    557  CB  LEU A  77      89.347  48.168  35.115  1.00 10.61           C  
ATOM    558  CG  LEU A  77      88.957  46.792  34.569  1.00 13.09           C  
ATOM    559  CD1 LEU A  77      90.148  46.172  33.867  1.00 14.02           C  
ATOM    560  CD2 LEU A  77      88.466  45.903  35.714  1.00 12.45           C  
ATOM    561  N   ALA A  78      89.231  50.590  37.194  1.00 13.50           N  
ATOM    562  CA  ALA A  78      89.643  51.941  37.531  1.00 13.84           C  
ATOM    563  C   ALA A  78      91.135  52.114  37.243  1.00 14.48           C  
ATOM    564  O   ALA A  78      91.694  53.177  37.471  1.00 13.86           O  
ATOM    565  CB  ALA A  78      89.342  52.225  38.996  1.00 14.65           C  
ATOM    566  N   ASP A  79      91.770  51.065  36.729  1.00 16.24           N  
ATOM    567  CA  ASP A  79      93.194  51.111  36.419  1.00 18.29           C  
ATOM    568  C   ASP A  79      93.596  50.116  35.327  1.00 18.42           C  
ATOM    569  O   ASP A  79      93.248  48.933  35.369  1.00 15.47           O  
ATOM    570  CB  ASP A  79      94.009  50.877  37.708  1.00 20.63           C  
ATOM    571  CG  ASP A  79      95.509  50.746  37.454  1.00 23.75           C  
ATOM    572  OD1 ASP A  79      96.045  51.435  36.558  1.00 25.24           O  
ATOM    573  OD2 ASP A  79      96.150  49.952  38.178  1.00 28.65           O  
HETATM  574  N   MSE A  80      94.324  50.644  34.348  1.00 20.70           N  
HETATM  575  CA  MSE A  80      94.836  49.906  33.195  1.00 22.97           C  
HETATM  576  C   MSE A  80      95.632  48.684  33.623  1.00 20.99           C  
HETATM  577  O   MSE A  80      95.668  47.674  32.926  1.00 21.73           O  
HETATM  578  CB  MSE A  80      95.756  50.818  32.397  1.00 28.02           C  
HETATM  579  CG  MSE A  80      95.404  52.288  32.533  1.00 34.38           C  
HETATM  580 SE   MSE A  80      96.962  53.370  32.364  1.00 43.97          SE  
HETATM  581  CE  MSE A  80      97.331  53.070  30.475  1.00 42.40           C  
ATOM    582  N   GLU A  81      96.290  48.792  34.768  1.00 19.30           N  
ATOM    583  CA  GLU A  81      97.099  47.699  35.280  1.00 19.13           C  
ATOM    584  C   GLU A  81      96.295  46.466  35.665  1.00 18.46           C  
ATOM    585  O   GLU A  81      96.860  45.390  35.808  1.00 19.34           O  
ATOM    586  CB  GLU A  81      97.915  48.177  36.483  1.00 18.61           C  
ATOM    587  CG  GLU A  81      99.186  48.914  36.105  1.00 18.34           C  
ATOM    588  CD  GLU A  81     100.187  47.992  35.436  1.00 19.50           C  
ATOM    589  OE1 GLU A  81     100.486  46.934  36.031  1.00 19.80           O  
ATOM    590  OE2 GLU A  81     100.670  48.316  34.327  1.00 17.25           O  
ATOM    591  N   ASP A  82      94.982  46.624  35.820  1.00 17.07           N  
ATOM    592  CA  ASP A  82      94.113  45.515  36.212  1.00 16.98           C  
ATOM    593  C   ASP A  82      93.422  44.739  35.086  1.00 16.01           C  
ATOM    594  O   ASP A  82      92.611  43.855  35.360  1.00 14.48           O  
ATOM    595  CB  ASP A  82      93.053  46.011  37.200  1.00 16.64           C  
ATOM    596  CG  ASP A  82      93.658  46.480  38.510  1.00 19.56           C  
ATOM    597  OD1 ASP A  82      94.855  46.210  38.741  1.00 20.51           O  
ATOM    598  OD2 ASP A  82      92.940  47.107  39.316  1.00 23.56           O  
ATOM    599  N   PHE A  83      93.739  45.055  33.833  1.00 14.68           N  
ATOM    600  CA  PHE A  83      93.124  44.352  32.709  1.00 15.07           C  
ATOM    601  C   PHE A  83      93.448  42.847  32.724  1.00 14.30           C  
ATOM    602  O   PHE A  83      92.548  42.022  32.595  1.00 12.88           O  
ATOM    603  CB  PHE A  83      93.555  44.982  31.372  1.00 16.29           C  
ATOM    604  CG  PHE A  83      92.778  46.225  30.993  1.00 17.35           C  
ATOM    605  CD1 PHE A  83      93.439  47.411  30.692  1.00 18.69           C  
ATOM    606  CD2 PHE A  83      91.389  46.205  30.917  1.00 18.57           C  
ATOM    607  CE1 PHE A  83      92.729  48.557  30.325  1.00 18.46           C  
ATOM    608  CE2 PHE A  83      90.674  47.344  30.552  1.00 18.91           C  
ATOM    609  CZ  PHE A  83      91.346  48.520  30.255  1.00 18.53           C  
ATOM    610  N   PRO A  84      94.736  42.472  32.882  1.00 14.98           N  
ATOM    611  CA  PRO A  84      95.149  41.059  32.915  1.00 13.79           C  
ATOM    612  C   PRO A  84      94.556  40.269  34.093  1.00 12.28           C  
ATOM    613  O   PRO A  84      93.997  39.182  33.909  1.00 11.50           O  
ATOM    614  CB  PRO A  84      96.675  41.148  33.011  1.00 13.83           C  
ATOM    615  CG  PRO A  84      96.988  42.431  32.342  1.00 14.36           C  
ATOM    616  CD  PRO A  84      95.923  43.347  32.888  1.00 16.05           C  
ATOM    617  N   GLY A  85      94.680  40.827  35.298  1.00 12.48           N  
ATOM    618  CA  GLY A  85      94.168  40.175  36.496  1.00 12.50           C  
ATOM    619  C   GLY A  85      92.659  39.992  36.496  1.00 13.10           C  
ATOM    620  O   GLY A  85      92.148  38.994  37.014  1.00 11.62           O  
ATOM    621  N   PHE A  86      91.948  40.966  35.927  1.00 12.67           N  
ATOM    622  CA  PHE A  86      90.496  40.911  35.834  1.00 12.43           C  
ATOM    623  C   PHE A  86      90.098  39.806  34.858  1.00 12.52           C  
ATOM    624  O   PHE A  86      89.282  38.945  35.176  1.00 10.44           O  
ATOM    625  CB  PHE A  86      89.944  42.260  35.353  1.00 12.44           C  
ATOM    626  CG  PHE A  86      88.511  42.203  34.905  1.00 12.16           C  
ATOM    627  CD1 PHE A  86      88.193  42.116  33.548  1.00 12.82           C  
ATOM    628  CD2 PHE A  86      87.479  42.206  35.835  1.00 13.60           C  
ATOM    629  CE1 PHE A  86      86.864  42.033  33.126  1.00 11.88           C  
ATOM    630  CE2 PHE A  86      86.137  42.121  35.423  1.00 13.88           C  
ATOM    631  CZ  PHE A  86      85.835  42.035  34.069  1.00 11.98           C  
ATOM    632  N   ASN A  87      90.694  39.830  33.672  1.00 14.26           N  
ATOM    633  CA  ASN A  87      90.394  38.829  32.658  1.00 15.83           C  
ATOM    634  C   ASN A  87      90.624  37.409  33.187  1.00 15.07           C  
ATOM    635  O   ASN A  87      89.861  36.494  32.871  1.00 14.37           O  
ATOM    636  CB  ASN A  87      91.245  39.072  31.411  1.00 18.20           C  
ATOM    637  CG  ASN A  87      90.883  38.143  30.270  1.00 20.39           C  
ATOM    638  OD1 ASN A  87      89.742  38.125  29.810  1.00 24.33           O  
ATOM    639  ND2 ASN A  87      91.851  37.361  29.811  1.00 21.77           N  
ATOM    640  N   GLU A  88      91.668  37.237  33.998  1.00 14.50           N  
ATOM    641  CA  GLU A  88      92.001  35.932  34.579  1.00 15.03           C  
ATOM    642  C   GLU A  88      90.859  35.354  35.412  1.00 12.86           C  
ATOM    643  O   GLU A  88      90.517  34.179  35.284  1.00 13.38           O  
ATOM    644  CB  GLU A  88      93.255  36.039  35.452  1.00 16.37           C  
ATOM    645  CG  GLU A  88      93.579  34.746  36.208  1.00 21.51           C  
ATOM    646  CD  GLU A  88      94.880  34.816  36.997  1.00 24.24           C  
ATOM    647  OE1 GLU A  88      95.254  33.795  37.617  1.00 26.96           O  
ATOM    648  OE2 GLU A  88      95.531  35.883  37.000  1.00 24.41           O  
ATOM    649  N   VAL A  89      90.279  36.185  36.268  1.00 10.64           N  
ATOM    650  CA  VAL A  89      89.176  35.759  37.116  1.00 12.47           C  
ATOM    651  C   VAL A  89      87.930  35.584  36.250  1.00 12.99           C  
ATOM    652  O   VAL A  89      87.235  34.576  36.333  1.00 13.78           O  
ATOM    653  CB  VAL A  89      88.895  36.810  38.232  1.00  8.66           C  
ATOM    654  CG1 VAL A  89      87.697  36.393  39.071  1.00  9.35           C  
ATOM    655  CG2 VAL A  89      90.121  36.974  39.108  1.00  9.48           C  
ATOM    656  N   TYR A  90      87.669  36.581  35.412  1.00 14.28           N  
ATOM    657  CA  TYR A  90      86.526  36.589  34.505  1.00 14.76           C  
ATOM    658  C   TYR A  90      86.446  35.294  33.682  1.00 14.59           C  
ATOM    659  O   TYR A  90      85.363  34.752  33.464  1.00 15.21           O  
ATOM    660  CB  TYR A  90      86.645  37.799  33.567  1.00 12.52           C  
ATOM    661  CG  TYR A  90      85.460  38.027  32.650  1.00 14.30           C  
ATOM    662  CD1 TYR A  90      84.431  38.914  33.001  1.00 14.49           C  
ATOM    663  CD2 TYR A  90      85.372  37.369  31.423  1.00 12.95           C  
ATOM    664  CE1 TYR A  90      83.345  39.143  32.143  1.00 11.38           C  
ATOM    665  CE2 TYR A  90      84.296  37.585  30.564  1.00 14.34           C  
ATOM    666  CZ  TYR A  90      83.288  38.475  30.927  1.00 12.68           C  
ATOM    667  OH  TYR A  90      82.246  38.690  30.055  1.00  9.54           O  
ATOM    668  N   ALA A  91      87.602  34.809  33.236  1.00 16.09           N  
ATOM    669  CA  ALA A  91      87.687  33.591  32.427  1.00 17.43           C  
ATOM    670  C   ALA A  91      87.198  32.329  33.141  1.00 18.79           C  
ATOM    671  O   ALA A  91      86.636  31.434  32.506  1.00 19.26           O  
ATOM    672  CB  ALA A  91      89.125  33.392  31.941  1.00 16.26           C  
ATOM    673  N   ARG A  92      87.414  32.261  34.452  1.00 19.22           N  
ATOM    674  CA  ARG A  92      86.996  31.115  35.257  1.00 19.66           C  
ATOM    675  C   ARG A  92      85.480  30.962  35.321  1.00 19.41           C  
ATOM    676  O   ARG A  92      84.970  29.868  35.576  1.00 20.81           O  
ATOM    677  CB  ARG A  92      87.484  31.255  36.702  1.00 19.82           C  
ATOM    678  CG  ARG A  92      88.963  31.481  36.894  1.00 23.29           C  
ATOM    679  CD  ARG A  92      89.226  31.808  38.357  1.00 24.92           C  
ATOM    680  NE  ARG A  92      90.482  32.527  38.550  1.00 29.15           N  
ATOM    681  CZ  ARG A  92      90.768  33.244  39.632  1.00 29.70           C  
ATOM    682  NH1 ARG A  92      89.885  33.335  40.622  1.00 29.88           N  
ATOM    683  NH2 ARG A  92      91.927  33.884  39.720  1.00 28.90           N  
ATOM    684  N   TYR A  93      84.759  32.058  35.106  1.00 18.70           N  
ATOM    685  CA  TYR A  93      83.307  32.027  35.209  1.00 17.41           C  
ATOM    686  C   TYR A  93      82.523  31.729  33.948  1.00 17.61           C  
ATOM    687  O   TYR A  93      81.337  31.421  34.021  1.00 16.23           O  
ATOM    688  CB  TYR A  93      82.809  33.338  35.822  1.00 18.30           C  
ATOM    689  CG  TYR A  93      83.252  33.516  37.253  1.00 17.99           C  
ATOM    690  CD1 TYR A  93      84.567  33.860  37.559  1.00 17.45           C  
ATOM    691  CD2 TYR A  93      82.369  33.280  38.304  1.00 19.29           C  
ATOM    692  CE1 TYR A  93      84.992  33.961  38.872  1.00 17.28           C  
ATOM    693  CE2 TYR A  93      82.784  33.372  39.623  1.00 20.43           C  
ATOM    694  CZ  TYR A  93      84.094  33.714  39.899  1.00 19.54           C  
ATOM    695  OH  TYR A  93      84.505  33.805  41.203  1.00 22.91           O  
ATOM    696  N   PHE A  94      83.173  31.807  32.797  1.00 18.80           N  
ATOM    697  CA  PHE A  94      82.480  31.544  31.547  1.00 19.06           C  
ATOM    698  C   PHE A  94      83.066  30.429  30.703  1.00 19.87           C  
ATOM    699  O   PHE A  94      84.265  30.145  30.744  1.00 19.15           O  
ATOM    700  CB  PHE A  94      82.402  32.816  30.703  1.00 18.24           C  
ATOM    701  CG  PHE A  94      81.659  33.932  31.362  1.00 18.13           C  
ATOM    702  CD1 PHE A  94      82.344  35.002  31.927  1.00 18.44           C  
ATOM    703  CD2 PHE A  94      80.270  33.912  31.432  1.00 16.46           C  
ATOM    704  CE1 PHE A  94      81.656  36.039  32.555  1.00 15.80           C  
ATOM    705  CE2 PHE A  94      79.577  34.944  32.058  1.00 16.72           C  
ATOM    706  CZ  PHE A  94      80.273  36.008  32.620  1.00 16.09           C  
ATOM    707  N   THR A  95      82.184  29.814  29.925  1.00 22.58           N  
ATOM    708  CA  THR A  95      82.529  28.732  29.022  1.00 23.85           C  
ATOM    709  C   THR A  95      81.910  29.065  27.661  1.00 24.07           C  
ATOM    710  O   THR A  95      80.944  29.824  27.580  1.00 22.79           O  
ATOM    711  CB  THR A  95      81.993  27.385  29.585  1.00 24.28           C  
ATOM    712  OG1 THR A  95      83.067  26.691  30.227  1.00 25.06           O  
ATOM    713  CG2 THR A  95      81.390  26.515  28.493  1.00 25.17           C  
ATOM    714  N   PRO A  96      82.476  28.521  26.571  1.00 24.43           N  
ATOM    715  CA  PRO A  96      81.935  28.797  25.236  1.00 24.29           C  
ATOM    716  C   PRO A  96      80.481  28.338  25.114  1.00 24.66           C  
ATOM    717  O   PRO A  96      80.127  27.253  25.580  1.00 25.34           O  
ATOM    718  CB  PRO A  96      82.865  28.009  24.321  1.00 25.06           C  
ATOM    719  CG  PRO A  96      84.166  28.014  25.074  1.00 25.68           C  
ATOM    720  CD  PRO A  96      83.717  27.729  26.483  1.00 24.09           C  
ATOM    721  N   PRO A  97      79.617  29.159  24.491  1.00 23.76           N  
ATOM    722  CA  PRO A  97      79.908  30.470  23.902  1.00 22.42           C  
ATOM    723  C   PRO A  97      80.103  31.520  24.987  1.00 20.76           C  
ATOM    724  O   PRO A  97      79.342  31.558  25.957  1.00 20.36           O  
ATOM    725  CB  PRO A  97      78.653  30.777  23.076  1.00 21.88           C  
ATOM    726  CG  PRO A  97      77.962  29.460  22.929  1.00 22.53           C  
ATOM    727  CD  PRO A  97      78.217  28.787  24.233  1.00 23.39           C  
ATOM    728  N   TYR A  98      81.120  32.361  24.827  1.00 18.73           N  
ATOM    729  CA  TYR A  98      81.372  33.432  25.787  1.00 18.16           C  
ATOM    730  C   TYR A  98      80.503  34.642  25.431  1.00 15.91           C  
ATOM    731  O   TYR A  98      80.083  34.806  24.286  1.00 15.91           O  
ATOM    732  CB  TYR A  98      82.844  33.850  25.770  1.00 17.20           C  
ATOM    733  CG  TYR A  98      83.803  32.786  26.248  1.00 19.44           C  
ATOM    734  CD1 TYR A  98      84.540  32.023  25.342  1.00 20.70           C  
ATOM    735  CD2 TYR A  98      83.976  32.546  27.610  1.00 20.76           C  
ATOM    736  CE1 TYR A  98      85.426  31.044  25.785  1.00 21.56           C  
ATOM    737  CE2 TYR A  98      84.854  31.573  28.062  1.00 20.79           C  
ATOM    738  CZ  TYR A  98      85.577  30.825  27.148  1.00 21.52           C  
ATOM    739  OH  TYR A  98      86.433  29.846  27.599  1.00 18.20           O  
ATOM    740  N   PRO A  99      80.215  35.503  26.415  1.00 15.03           N  
ATOM    741  CA  PRO A  99      79.387  36.681  26.131  1.00 13.89           C  
ATOM    742  C   PRO A  99      80.166  37.708  25.322  1.00 11.57           C  
ATOM    743  O   PRO A  99      81.392  37.677  25.301  1.00 11.97           O  
ATOM    744  CB  PRO A  99      79.054  37.226  27.524  1.00 14.47           C  
ATOM    745  CG  PRO A  99      79.242  36.030  28.445  1.00 15.92           C  
ATOM    746  CD  PRO A  99      80.464  35.369  27.860  1.00 15.74           C  
ATOM    747  N   ALA A 100      79.451  38.599  24.639  1.00 12.58           N  
ATOM    748  CA  ALA A 100      80.105  39.679  23.904  1.00 11.54           C  
ATOM    749  C   ALA A 100      80.600  40.520  25.078  1.00 12.52           C  
ATOM    750  O   ALA A 100      79.998  40.482  26.154  1.00 12.54           O  
ATOM    751  CB  ALA A 100      79.098  40.461  23.083  1.00 11.13           C  
ATOM    752  N   ARG A 101      81.682  41.264  24.904  1.00 11.95           N  
ATOM    753  CA  ARG A 101      82.203  42.031  26.025  1.00 10.94           C  
ATOM    754  C   ARG A 101      82.842  43.345  25.634  1.00 11.07           C  
ATOM    755  O   ARG A 101      83.320  43.513  24.518  1.00 10.22           O  
ATOM    756  CB  ARG A 101      83.240  41.191  26.788  1.00 11.87           C  
ATOM    757  CG  ARG A 101      83.802  41.866  28.035  1.00 13.48           C  
ATOM    758  CD  ARG A 101      84.803  40.977  28.781  1.00 14.59           C  
ATOM    759  NE  ARG A 101      86.083  40.836  28.088  1.00 13.51           N  
ATOM    760  CZ  ARG A 101      87.140  40.200  28.588  1.00 13.76           C  
ATOM    761  NH1 ARG A 101      87.082  39.639  29.793  1.00 12.76           N  
ATOM    762  NH2 ARG A 101      88.257  40.117  27.877  1.00 12.41           N  
ATOM    763  N   ALA A 102      82.834  44.277  26.576  1.00 10.00           N  
ATOM    764  CA  ALA A 102      83.468  45.571  26.390  1.00 12.02           C  
ATOM    765  C   ALA A 102      84.157  45.813  27.726  1.00 10.38           C  
ATOM    766  O   ALA A 102      83.558  45.601  28.782  1.00  8.44           O  
ATOM    767  CB  ALA A 102      82.434  46.660  26.102  1.00 10.55           C  
ATOM    768  N   THR A 103      85.420  46.219  27.676  1.00 11.27           N  
ATOM    769  CA  THR A 103      86.174  46.476  28.901  1.00 10.64           C  
ATOM    770  C   THR A 103      86.948  47.783  28.775  1.00  9.71           C  
ATOM    771  O   THR A 103      87.614  48.034  27.774  1.00  9.50           O  
ATOM    772  CB  THR A 103      87.158  45.318  29.217  1.00 10.90           C  
ATOM    773  OG1 THR A 103      88.332  45.441  28.408  1.00 16.20           O  
ATOM    774  CG2 THR A 103      86.511  43.985  28.921  1.00  6.80           C  
ATOM    775  N   VAL A 104      86.850  48.621  29.799  1.00  8.23           N  
ATOM    776  CA  VAL A 104      87.529  49.909  29.782  1.00 10.32           C  
ATOM    777  C   VAL A 104      88.029  50.260  31.172  1.00 10.39           C  
ATOM    778  O   VAL A 104      87.536  49.720  32.159  1.00  9.33           O  
ATOM    779  CB  VAL A 104      86.574  51.047  29.299  1.00  8.40           C  
ATOM    780  CG1 VAL A 104      86.072  50.755  27.891  1.00  9.56           C  
ATOM    781  CG2 VAL A 104      85.392  51.193  30.259  1.00  9.12           C  
ATOM    782  N   ALA A 105      89.028  51.141  31.238  1.00 10.96           N  
ATOM    783  CA  ALA A 105      89.565  51.605  32.513  1.00  9.71           C  
ATOM    784  C   ALA A 105      89.015  53.021  32.679  1.00 10.69           C  
ATOM    785  O   ALA A 105      89.312  53.903  31.872  1.00 11.56           O  
ATOM    786  CB  ALA A 105      91.094  51.641  32.483  1.00  9.51           C  
ATOM    787  N   VAL A 106      88.205  53.234  33.708  1.00 10.25           N  
ATOM    788  CA  VAL A 106      87.618  54.546  33.949  1.00 10.18           C  
ATOM    789  C   VAL A 106      88.407  55.331  34.993  1.00 11.64           C  
ATOM    790  O   VAL A 106      89.374  54.823  35.567  1.00  9.96           O  
ATOM    791  CB  VAL A 106      86.145  54.420  34.406  1.00 10.48           C  
ATOM    792  CG1 VAL A 106      85.305  53.825  33.278  1.00  8.83           C  
ATOM    793  CG2 VAL A 106      86.050  53.555  35.659  1.00  9.09           C  
ATOM    794  N   LYS A 107      88.006  56.578  35.226  1.00 13.03           N  
ATOM    795  CA  LYS A 107      88.693  57.401  36.209  1.00 13.92           C  
ATOM    796  C   LYS A 107      88.457  56.879  37.616  1.00 12.49           C  
ATOM    797  O   LYS A 107      89.388  56.795  38.416  1.00 14.64           O  
ATOM    798  CB  LYS A 107      88.237  58.857  36.123  1.00 15.79           C  
ATOM    799  CG  LYS A 107      88.956  59.738  37.130  1.00 17.29           C  
ATOM    800  CD  LYS A 107      88.893  61.212  36.774  1.00 21.19           C  
ATOM    801  CE  LYS A 107      87.517  61.794  37.001  1.00 22.17           C  
ATOM    802  NZ  LYS A 107      87.606  63.277  37.000  1.00 23.29           N  
ATOM    803  N   ALA A 108      87.212  56.526  37.914  1.00 11.91           N  
ATOM    804  CA  ALA A 108      86.860  56.011  39.232  1.00 11.55           C  
ATOM    805  C   ALA A 108      85.533  55.264  39.216  1.00 10.69           C  
ATOM    806  O   ALA A 108      84.678  55.493  38.359  1.00 11.83           O  
ATOM    807  CB  ALA A 108      86.803  57.162  40.256  1.00  8.70           C  
ATOM    808  N   LEU A 109      85.375  54.367  40.178  1.00 10.80           N  
ATOM    809  CA  LEU A 109      84.168  53.573  40.320  1.00  9.79           C  
ATOM    810  C   LEU A 109      83.556  53.857  41.685  1.00 10.20           C  
ATOM    811  O   LEU A 109      84.202  54.425  42.563  1.00  9.08           O  
ATOM    812  CB  LEU A 109      84.505  52.082  40.219  1.00  8.38           C  
ATOM    813  CG  LEU A 109      85.028  51.569  38.879  1.00  7.70           C  
ATOM    814  CD1 LEU A 109      85.430  50.116  39.010  1.00  7.72           C  
ATOM    815  CD2 LEU A 109      83.942  51.736  37.822  1.00  7.63           C  
ATOM    816  N   PRO A 110      82.291  53.473  41.878  1.00 11.81           N  
ATOM    817  CA  PRO A 110      81.630  53.698  43.163  1.00 13.22           C  
ATOM    818  C   PRO A 110      82.498  53.244  44.348  1.00 13.65           C  
ATOM    819  O   PRO A 110      83.050  52.138  44.348  1.00 12.35           O  
ATOM    820  CB  PRO A 110      80.351  52.876  43.026  1.00 13.80           C  
ATOM    821  CG  PRO A 110      80.002  53.083  41.585  1.00 12.31           C  
ATOM    822  CD  PRO A 110      81.345  52.927  40.887  1.00 12.58           C  
ATOM    823  N   ARG A 111      82.624  54.121  45.341  1.00 14.66           N  
ATOM    824  CA  ARG A 111      83.393  53.853  46.554  1.00 15.28           C  
ATOM    825  C   ARG A 111      84.876  53.521  46.355  1.00 14.02           C  
ATOM    826  O   ARG A 111      85.496  52.890  47.212  1.00 14.10           O  
ATOM    827  CB  ARG A 111      82.688  52.761  47.370  1.00 16.46           C  
ATOM    828  CG  ARG A 111      81.309  53.227  47.843  1.00 19.29           C  
ATOM    829  CD  ARG A 111      80.485  52.150  48.506  1.00 25.64           C  
ATOM    830  NE  ARG A 111      80.989  51.768  49.822  1.00 29.76           N  
ATOM    831  CZ  ARG A 111      80.405  50.865  50.606  1.00 29.01           C  
ATOM    832  NH1 ARG A 111      79.296  50.256  50.207  1.00 28.84           N  
ATOM    833  NH2 ARG A 111      80.939  50.563  51.781  1.00 30.55           N  
ATOM    834  N   GLY A 112      85.436  53.968  45.233  1.00 12.28           N  
ATOM    835  CA  GLY A 112      86.848  53.753  44.952  1.00 12.72           C  
ATOM    836  C   GLY A 112      87.276  52.341  44.593  1.00 12.73           C  
ATOM    837  O   GLY A 112      88.469  52.038  44.538  1.00 12.18           O  
ATOM    838  N   VAL A 113      86.299  51.480  44.347  1.00 12.28           N  
ATOM    839  CA  VAL A 113      86.541  50.091  43.979  1.00 11.47           C  
ATOM    840  C   VAL A 113      87.371  49.951  42.690  1.00 11.94           C  
ATOM    841  O   VAL A 113      87.499  50.898  41.917  1.00 10.79           O  
ATOM    842  CB  VAL A 113      85.187  49.375  43.829  1.00 13.75           C  
ATOM    843  CG1 VAL A 113      85.318  48.170  42.942  1.00 14.90           C  
ATOM    844  CG2 VAL A 113      84.664  48.992  45.212  1.00 12.22           C  
ATOM    845  N   ARG A 114      87.933  48.764  42.471  1.00 11.35           N  
ATOM    846  CA  ARG A 114      88.755  48.495  41.290  1.00 12.93           C  
ATOM    847  C   ARG A 114      87.955  47.985  40.091  1.00 12.28           C  
ATOM    848  O   ARG A 114      88.378  48.138  38.941  1.00 11.26           O  
ATOM    849  CB  ARG A 114      89.825  47.436  41.601  1.00 14.29           C  
ATOM    850  CG  ARG A 114      90.879  47.780  42.658  1.00 16.76           C  
ATOM    851  CD  ARG A 114      91.761  46.547  42.869  1.00 19.46           C  
ATOM    852  NE  ARG A 114      92.867  46.742  43.807  1.00 22.67           N  
ATOM    853  CZ  ARG A 114      93.983  47.413  43.538  1.00 22.17           C  
ATOM    854  NH1 ARG A 114      94.164  47.976  42.350  1.00 23.15           N  
ATOM    855  NH2 ARG A 114      94.936  47.501  44.457  1.00 24.14           N  
ATOM    856  N   VAL A 115      86.803  47.380  40.358  1.00 11.19           N  
ATOM    857  CA  VAL A 115      86.010  46.791  39.287  1.00 11.18           C  
ATOM    858  C   VAL A 115      84.492  46.846  39.444  1.00 10.94           C  
ATOM    859  O   VAL A 115      83.955  46.756  40.556  1.00 12.35           O  
ATOM    860  CB  VAL A 115      86.432  45.305  39.094  1.00 10.63           C  
ATOM    861  CG1 VAL A 115      86.357  44.567  40.426  1.00  9.65           C  
ATOM    862  CG2 VAL A 115      85.549  44.623  38.068  1.00 11.03           C  
ATOM    863  N   GLU A 116      83.817  47.006  38.308  1.00 10.26           N  
ATOM    864  CA  GLU A 116      82.360  47.026  38.233  1.00 10.07           C  
ATOM    865  C   GLU A 116      81.983  46.331  36.934  1.00  9.35           C  
ATOM    866  O   GLU A 116      82.472  46.699  35.859  1.00  9.62           O  
ATOM    867  CB  GLU A 116      81.805  48.452  38.208  1.00 11.46           C  
ATOM    868  CG  GLU A 116      80.275  48.510  38.194  1.00 10.48           C  
ATOM    869  CD  GLU A 116      79.735  49.929  38.078  1.00 12.59           C  
ATOM    870  OE1 GLU A 116      80.403  50.869  38.554  1.00 10.85           O  
ATOM    871  OE2 GLU A 116      78.632  50.109  37.527  1.00 10.70           O  
ATOM    872  N   VAL A 117      81.120  45.325  37.033  1.00  9.51           N  
ATOM    873  CA  VAL A 117      80.679  44.587  35.862  1.00  9.02           C  
ATOM    874  C   VAL A 117      79.162  44.536  35.755  1.00  9.77           C  
ATOM    875  O   VAL A 117      78.476  44.097  36.678  1.00 10.81           O  
ATOM    876  CB  VAL A 117      81.206  43.130  35.870  1.00  8.28           C  
ATOM    877  CG1 VAL A 117      80.682  42.378  34.635  1.00  5.12           C  
ATOM    878  CG2 VAL A 117      82.733  43.129  35.906  1.00  9.50           C  
ATOM    879  N   ALA A 118      78.646  44.997  34.622  1.00 10.96           N  
ATOM    880  CA  ALA A 118      77.213  44.964  34.371  1.00 10.55           C  
ATOM    881  C   ALA A 118      77.029  43.949  33.256  1.00  9.47           C  
ATOM    882  O   ALA A 118      77.981  43.628  32.551  1.00 11.55           O  
ATOM    883  CB  ALA A 118      76.715  46.332  33.933  1.00 10.51           C  
ATOM    884  N   CYS A 119      75.825  43.417  33.100  1.00 10.41           N  
ATOM    885  CA  CYS A 119      75.608  42.450  32.031  1.00  9.87           C  
ATOM    886  C   CYS A 119      74.162  42.331  31.618  1.00  9.05           C  
ATOM    887  O   CYS A 119      73.266  42.876  32.263  1.00  9.34           O  
ATOM    888  CB  CYS A 119      76.135  41.058  32.426  1.00  9.79           C  
ATOM    889  SG  CYS A 119      75.109  40.100  33.576  1.00  8.01           S  
ATOM    890  N   VAL A 120      73.958  41.620  30.514  1.00  8.65           N  
ATOM    891  CA  VAL A 120      72.636  41.360  29.968  1.00  8.91           C  
ATOM    892  C   VAL A 120      72.622  39.867  29.656  1.00 10.19           C  
ATOM    893  O   VAL A 120      73.549  39.346  29.031  1.00  8.55           O  
ATOM    894  CB  VAL A 120      72.384  42.157  28.666  1.00  8.78           C  
ATOM    895  CG1 VAL A 120      71.067  41.730  28.040  1.00  9.36           C  
ATOM    896  CG2 VAL A 120      72.356  43.651  28.964  1.00  9.32           C  
ATOM    897  N   ALA A 121      71.587  39.175  30.114  1.00 10.03           N  
ATOM    898  CA  ALA A 121      71.478  37.748  29.874  1.00 11.37           C  
ATOM    899  C   ALA A 121      70.089  37.418  29.371  1.00 13.89           C  
ATOM    900  O   ALA A 121      69.198  38.264  29.377  1.00 13.28           O  
ATOM    901  CB  ALA A 121      71.766  36.971  31.165  1.00 11.09           C  
ATOM    902  N   LEU A 122      69.917  36.180  28.925  1.00 16.79           N  
ATOM    903  CA  LEU A 122      68.631  35.710  28.440  1.00 21.04           C  
ATOM    904  C   LEU A 122      67.780  35.225  29.612  1.00 24.06           C  
ATOM    905  O   LEU A 122      68.286  34.583  30.541  1.00 23.23           O  
ATOM    906  CB  LEU A 122      68.826  34.559  27.458  1.00 20.63           C  
ATOM    907  CG  LEU A 122      69.426  34.887  26.093  1.00 20.66           C  
ATOM    908  CD1 LEU A 122      69.798  33.593  25.381  1.00 20.55           C  
ATOM    909  CD2 LEU A 122      68.423  35.689  25.279  1.00 20.03           C  
ATOM    910  N   ALA A 123      66.490  35.545  29.559  1.00 28.07           N  
ATOM    911  CA  ALA A 123      65.538  35.124  30.580  1.00 31.50           C  
ATOM    912  C   ALA A 123      64.970  33.784  30.118  1.00 35.19           C  
ATOM    913  O   ALA A 123      65.138  33.405  28.953  1.00 35.45           O  
ATOM    914  CB  ALA A 123      64.419  36.150  30.714  1.00 30.59           C  
ATOM    915  N   GLU A 124      64.302  33.067  31.018  1.00 38.73           N  
ATOM    916  CA  GLU A 124      63.723  31.768  30.672  1.00 41.83           C  
ATOM    917  C   GLU A 124      62.231  31.866  30.367  1.00 42.22           C  
ATOM    918  O   GLU A 124      61.448  31.123  30.998  1.00 42.95           O  
ATOM    919  CB  GLU A 124      63.950  30.768  31.810  1.00 43.31           C  
ATOM    920  CG  GLU A 124      65.401  30.329  31.984  1.00 45.95           C  
ATOM    921  CD  GLU A 124      65.913  29.521  30.804  1.00 46.21           C  
ATOM    922  OE1 GLU A 124      66.036  30.093  29.700  1.00 46.80           O  
ATOM    923  OE2 GLU A 124      66.187  28.311  30.982  1.00 46.81           O  
ATOM    924  OXT GLU A 124      61.865  32.678  29.492  1.00 43.51           O  
TER     925      GLU A 124                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
