
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  122 (  930),  selected  122 , name 2dyy_H
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2dyy_H.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_H      M       1           -
LGA    K     2_H      S       2           -
LGA    E     3_H      D       3           -
LGA    V     4_H      V       4           -
LGA    I     5_H      I       5           -
LGA    F     6_H      E       6           -
LGA    T     7_H      G       7           -
LGA    E     8_H      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    N     9_H      P      17          3.579
LGA    A    10_H      V      18          4.603
LGA    P    11_H      -       -           -
LGA    K    12_H      -       -           -
LGA    P    13_H      -       -           -
LGA    I    14_H      A      23          6.008
LGA    G    15_H      A      24          3.549
LGA    P    16_H      N      25          1.634
LGA    Y    17_H      Y      26          0.994
LGA    S    18_H      V      27          0.866
LGA    Q    19_H      P      28          0.805
LGA    A    20_H      F      29          0.404
LGA    I    21_H      T      30          0.856
LGA    K    22_H      I      31          1.453
LGA    A    23_H      S      32          1.670
LGA    G    24_H      G      33          1.215
LGA    N    25_H      N      34          0.781
LGA    F    26_H      L      35          1.029
LGA    L    27_H      L      36          0.538
LGA    F    28_H      Y      37          0.725
LGA    I    29_H      V      38          0.547
LGA    A    30_H      S      39          0.618
LGA    G    31_H      G      40          0.708
LGA    Q    32_H      Q      41          0.541
LGA    I    33_H      L      42          0.595
LGA    P    34_H      P      43          0.626
LGA    I    35_H      M      44          1.241
LGA    D    36_H      E      45          2.088
LGA    P    37_H      -       -           -
LGA    K    38_H      -       -           -
LGA    T    39_H      S      46          2.893
LGA    G    40_H      G      47          1.804
LGA    E    41_H      K      48          0.902
LGA    I    42_H      I      49          0.784
LGA    V    43_H      A      50          1.641
LGA    G    45_H      V      51          2.801
LGA    -       -      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    46_H      S      63          2.261
LGA    I    47_H      A      64          1.010
LGA    K    48_H      Q      65          1.999
LGA    D    49_H      R      66          1.602
LGA    Q    50_H      A      67          1.099
LGA    T    51_H      A      68          1.039
LGA    R    52_H      E      69          1.200
LGA    Q    53_H      L      70          0.903
LGA    V    54_H      C      71          0.610
LGA    L    55_H      A      72          0.533
LGA    E    56_H      V      73          0.407
LGA    N    57_H      N      74          0.559
LGA    I    58_H      I      75          0.548
LGA    K    59_H      L      76          0.642
LGA    A    60_H      A      77          1.057
LGA    I    61_H      Q      78          1.267
LGA    L    62_H      V      79          1.225
LGA    E    63_H      K      80          1.707
LGA    A    64_H      A      81          1.863
LGA    A    65_H      A      82          2.156
LGA    G    66_H      L      83          2.371
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    -       -      K      89           -
LGA    Y    67_H      I      90          3.030
LGA    S    68_H      R      91          6.300
LGA    L    69_H      -       -           -
LGA    N    70_H      -       -           -
LGA    D    71_H      R      92          1.989
LGA    V    72_H      V      93          1.157
LGA    I    73_H      I      94          0.215
LGA    K    74_H      K      95          1.079
LGA    V    75_H      L      96          1.139
LGA    T    76_H      N      97          0.786
LGA    V    77_H      G      98          0.813
LGA    Y    78_H      F      99          0.719
LGA    L    79_H      V     100          0.851
LGA    K    80_H      A     101          0.958
LGA    D    81_H      S     102          1.356
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    -       -      F     106           -
LGA    -       -      V     107           -
LGA    F    85_H      E     108          4.147
LGA    A    86_H      Q     109          1.709
LGA    -       -      H     110           -
LGA    K    87_H      L     111          1.106
LGA    M    88_H      V     112          1.525
LGA    N    89_H      I     113          4.520
LGA    E    90_H      N     114          4.377
LGA    V    91_H      G     115          2.912
LGA    Y    92_H      A     116          3.070
LGA    -       -      S     117           -
LGA    A    93_H      N     118          1.577
LGA    E    94_H      L     119          3.465
LGA    Y    95_H      I     120          1.905
LGA    F    96_H      A     121          2.051
LGA    -       -      T     122           -
LGA    -       -      V     123           -
LGA    -       -      L     124           -
LGA    G    97_H      G     125          3.784
LGA    E    98_H      E     126          0.866
LGA    S    99_H      P     127          3.304
LGA    -       -      G     128           -
LGA    K   100_H      R     129          1.756
LGA    P   101_H      H     130          1.081
LGA    A   102_H      A     131          1.030
LGA    R   103_H      R     132          0.875
LGA    V   104_H      A     133          1.411
LGA    A   105_H      A     134          1.853
LGA    V   106_H      V     135          1.396
LGA    E   107_H      G     136          0.811
LGA    V   108_H      M     137          1.049
LGA    S   109_H      A     138          0.964
LGA    R   110_H      S     139          1.180
LGA    L   111_H      L     140          0.280
LGA    P   112_H      P     141          0.369
LGA    K   113_H      F     142          0.294
LGA    D   114_H      N     143          0.420
LGA    V   115_H      A     144          0.811
LGA    L   116_H      S     145          0.780
LGA    I   117_H      V     146          0.555
LGA    E   118_H      E     147          0.509
LGA    I   119_H      I     148          0.550
LGA    E   120_H      D     149          0.798
LGA    A   121_H      A     150          0.548
LGA    I   122_H      I     151          0.486
LGA    A   123_H      V     152          0.797
LGA    Y   124_H      E     153          0.889
LGA    K   125_H      I     154          2.539
LGA    E   126_H      D     155           #
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  122  152    5.0    106    1.92    27.36     63.801     5.254

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.425449 * X  +  -0.782254 * Y  +  -0.455051 * Z  + 120.125221
  Y_new =   0.724206 * X  +  -0.595826 * Y  +   0.347156 * Z  + -15.975804
  Z_new =  -0.542695 * X  +  -0.181854 * Y  +   0.820007 * Z  +  53.608719 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.218239    2.923354  [ DEG:   -12.5042    167.4958 ]
  Theta =   0.573643    2.567950  [ DEG:    32.8673    147.1327 ]
  Phi   =   2.101952   -1.039641  [ DEG:   120.4330    -59.5670 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dyy_H                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dyy_H.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  122  152   5.0  106   1.92   27.36  63.801
REMARK  ---------------------------------------------------------- 
MOLECULE 2dyy_H
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-SEP-06   2DYY              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION INITIATION                  
TITLE    2 INHIBITOR PH0854 FROM PYROCOCCUS HORIKOSHII                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0076 PROTEIN PH0854;                                    
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   4 SYNONYM: PUTATIVE TRANSLATION INITIATION INHIBITOR;                  
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS (DE3)-RIL;                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    PUTATIVE TRANSLATION INITIATION INHIBITOR, PYROCOCCUS                 
KEYWDS   2 HORIKOSHII, TRIMER, STRUCTURAL GENOMICS, NPPSFA, NATIONAL            
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,B.C.WANG,           
AUTHOR   2 M.SHIROUZU,Y.BESSHO,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   04-SEP-07 2DYY    1       AUTHOR                                   
REVDAT   1   19-MAR-07 2DYY    0                                                
JRNL        AUTH   IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,           
JRNL        AUTH 2 B.C.WANG,M.SHIROUZU,Y.BESSHO,S.YOKOYAMA                      
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION                    
JRNL        TITL 2 INITIATION INHIBITOR PH0854 FROM PYROCOCCUS                  
JRNL        TITL 3 HORIKOSHII                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2DYY A    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY B    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY C    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY D    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY E    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY F    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY G    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY H    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY I    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY J    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY K    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY L    1   126  UNP    O58584   Y854_PYRHO       1    126             
SEQRES   1 A  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 A  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 A  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 A  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 A  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 A  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 A  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 A  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 A  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 A  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 B  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 B  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 B  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 B  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 B  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 B  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 B  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 B  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 B  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 B  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 C  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 C  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 C  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 C  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 C  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 C  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 C  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 C  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 C  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 C  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 D  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 D  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 D  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 D  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 D  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 D  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 D  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 D  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 D  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 D  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 E  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 E  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 E  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 E  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 E  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 E  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 E  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 E  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 E  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 E  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 F  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 F  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 F  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 F  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 F  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 F  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 F  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 F  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 F  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 F  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 G  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 G  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 G  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 G  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 G  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 G  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 G  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 G  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 G  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 G  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 H  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 H  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 H  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 H  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 H  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 H  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 H  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 H  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 H  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 H  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 I  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 I  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 I  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 I  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 I  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 I  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 I  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 I  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 I  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 I  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 J  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 J  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 J  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 J  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 J  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 J  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 J  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 J  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 J  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 J  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 K  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 K  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 K  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 K  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 K  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 K  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 K  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 K  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 K  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 K  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 L  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 L  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 L  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 L  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 L  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 L  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 L  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 L  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 L  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 L  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
FORMUL  13  HOH   *233(H2 O)                                                    
CRYST1   92.490   43.090  170.210  90.00  91.51  90.00 P 1 2 1      24          
ATOM   6590  N   MET H   1      57.025  41.155  29.216  1.00 63.51           N  
ATOM   6591  CA  MET H   1      56.549  41.513  30.586  1.00 63.41           C  
ATOM   6592  C   MET H   1      57.707  41.970  31.470  1.00 61.20           C  
ATOM   6593  O   MET H   1      58.675  41.237  31.667  1.00 62.33           O  
ATOM   6594  CB  MET H   1      55.856  40.309  31.230  1.00 65.47           C  
ATOM   6595  CG  MET H   1      55.194  40.619  32.557  1.00 68.61           C  
ATOM   6596  SD  MET H   1      54.111  42.066  32.440  1.00 73.48           S  
ATOM   6597  CE  MET H   1      52.762  41.413  31.377  1.00 73.49           C  
ATOM   6598  N   LYS H   2      57.600  43.183  32.004  1.00 58.12           N  
ATOM   6599  CA  LYS H   2      58.641  43.740  32.864  1.00 56.03           C  
ATOM   6600  C   LYS H   2      58.620  43.046  34.223  1.00 54.72           C  
ATOM   6601  O   LYS H   2      57.554  42.860  34.808  1.00 54.41           O  
ATOM   6602  CB  LYS H   2      58.415  45.252  33.039  1.00 55.91           C  
ATOM   6603  CG  LYS H   2      59.310  45.951  34.076  1.00 56.42           C  
ATOM   6604  CD  LYS H   2      58.757  47.342  34.453  1.00 55.37           C  
ATOM   6605  CE  LYS H   2      59.577  48.043  35.551  1.00 52.70           C  
ATOM   6606  NZ  LYS H   2      60.938  48.457  35.103  1.00 48.23           N  
ATOM   6607  N   GLU H   3      59.795  42.659  34.719  1.00 52.85           N  
ATOM   6608  CA  GLU H   3      59.889  41.998  36.020  1.00 50.10           C  
ATOM   6609  C   GLU H   3      61.119  42.426  36.823  1.00 46.56           C  
ATOM   6610  O   GLU H   3      62.254  42.291  36.372  1.00 45.72           O  
ATOM   6611  CB  GLU H   3      59.882  40.476  35.849  1.00 52.45           C  
ATOM   6612  CG  GLU H   3      59.824  39.717  37.174  1.00 56.17           C  
ATOM   6613  CD  GLU H   3      59.744  38.207  37.002  1.00 57.91           C  
ATOM   6614  OE1 GLU H   3      60.522  37.652  36.193  1.00 58.49           O  
ATOM   6615  OE2 GLU H   3      58.909  37.577  37.687  1.00 58.77           O  
ATOM   6616  N   VAL H   4      60.882  42.944  38.022  1.00 44.16           N  
ATOM   6617  CA  VAL H   4      61.958  43.394  38.895  1.00 42.93           C  
ATOM   6618  C   VAL H   4      62.529  42.195  39.664  1.00 41.21           C  
ATOM   6619  O   VAL H   4      61.775  41.388  40.212  1.00 38.58           O  
ATOM   6620  CB  VAL H   4      61.444  44.482  39.883  1.00 43.44           C  
ATOM   6621  CG1 VAL H   4      60.284  43.942  40.703  1.00 46.76           C  
ATOM   6622  CG2 VAL H   4      62.565  44.938  40.793  1.00 44.07           C  
ATOM   6623  N   ILE H   5      63.860  42.081  39.686  1.00 39.67           N  
ATOM   6624  CA  ILE H   5      64.545  40.974  40.358  1.00 37.37           C  
ATOM   6625  C   ILE H   5      65.218  41.374  41.670  1.00 37.23           C  
ATOM   6626  O   ILE H   5      65.877  42.405  41.748  1.00 37.26           O  
ATOM   6627  CB  ILE H   5      65.642  40.368  39.454  1.00 37.20           C  
ATOM   6628  CG1 ILE H   5      65.047  39.956  38.107  1.00 36.37           C  
ATOM   6629  CG2 ILE H   5      66.293  39.173  40.148  1.00 34.56           C  
ATOM   6630  CD1 ILE H   5      64.006  38.872  38.197  1.00 38.99           C  
ATOM   6631  N   PHE H   6      65.058  40.552  42.700  1.00 36.75           N  
ATOM   6632  CA  PHE H   6      65.699  40.830  43.979  1.00 36.77           C  
ATOM   6633  C   PHE H   6      66.080  39.556  44.714  1.00 35.87           C  
ATOM   6634  O   PHE H   6      65.278  38.638  44.854  1.00 34.96           O  
ATOM   6635  CB  PHE H   6      64.804  41.672  44.887  1.00 37.21           C  
ATOM   6636  CG  PHE H   6      65.465  42.044  46.177  1.00 39.97           C  
ATOM   6637  CD1 PHE H   6      66.570  42.897  46.184  1.00 41.22           C  
ATOM   6638  CD2 PHE H   6      65.045  41.485  47.380  1.00 41.53           C  
ATOM   6639  CE1 PHE H   6      67.252  43.185  47.368  1.00 39.62           C  
ATOM   6640  CE2 PHE H   6      65.721  41.767  48.570  1.00 42.73           C  
ATOM   6641  CZ  PHE H   6      66.830  42.620  48.560  1.00 40.73           C  
ATOM   6642  N   THR H   7      67.315  39.508  45.192  1.00 36.78           N  
ATOM   6643  CA  THR H   7      67.798  38.344  45.915  1.00 37.98           C  
ATOM   6644  C   THR H   7      68.684  38.766  47.072  1.00 38.54           C  
ATOM   6645  O   THR H   7      69.478  39.696  46.961  1.00 38.67           O  
ATOM   6646  CB  THR H   7      68.604  37.400  44.996  1.00 39.01           C  
ATOM   6647  OG1 THR H   7      68.999  36.231  45.727  1.00 41.90           O  
ATOM   6648  CG2 THR H   7      69.852  38.107  44.474  1.00 40.52           C  
ATOM   6649  N   GLU H   8      68.532  38.075  48.191  1.00 40.56           N  
ATOM   6650  CA  GLU H   8      69.323  38.352  49.377  1.00 39.48           C  
ATOM   6651  C   GLU H   8      70.771  37.951  49.127  1.00 38.15           C  
ATOM   6652  O   GLU H   8      71.675  38.393  49.833  1.00 39.13           O  
ATOM   6653  CB  GLU H   8      68.761  37.566  50.559  1.00 41.81           C  
ATOM   6654  CG  GLU H   8      67.560  38.206  51.242  1.00 45.32           C  
ATOM   6655  CD  GLU H   8      67.953  39.411  52.080  1.00 47.57           C  
ATOM   6656  OE1 GLU H   8      68.980  39.321  52.785  1.00 49.95           O  
ATOM   6657  OE2 GLU H   8      67.241  40.441  52.040  1.00 48.42           O  
ATOM   6658  N   ASN H   9      70.986  37.128  48.105  1.00 36.22           N  
ATOM   6659  CA  ASN H   9      72.320  36.636  47.755  1.00 35.27           C  
ATOM   6660  C   ASN H   9      73.172  37.635  46.987  1.00 33.98           C  
ATOM   6661  O   ASN H   9      74.281  37.317  46.557  1.00 32.82           O  
ATOM   6662  CB  ASN H   9      72.180  35.362  46.930  1.00 36.26           C  
ATOM   6663  CG  ASN H   9      71.331  34.329  47.618  1.00 36.48           C  
ATOM   6664  OD1 ASN H   9      70.797  33.416  46.984  1.00 37.32           O  
ATOM   6665  ND2 ASN H   9      71.202  34.461  48.934  1.00 36.03           N  
ATOM   6666  N   ALA H  10      72.650  38.840  46.800  1.00 32.15           N  
ATOM   6667  CA  ALA H  10      73.383  39.864  46.076  1.00 32.19           C  
ATOM   6668  C   ALA H  10      73.354  41.159  46.860  1.00 31.07           C  
ATOM   6669  O   ALA H  10      72.500  41.343  47.724  1.00 30.35           O  
ATOM   6670  CB  ALA H  10      72.771  40.073  44.692  1.00 33.17           C  
ATOM   6671  N   PRO H  11      74.291  42.075  46.568  1.00 30.00           N  
ATOM   6672  CA  PRO H  11      74.342  43.358  47.270  1.00 29.51           C  
ATOM   6673  C   PRO H  11      73.011  44.090  47.142  1.00 31.12           C  
ATOM   6674  O   PRO H  11      72.471  44.249  46.046  1.00 31.18           O  
ATOM   6675  CB  PRO H  11      75.483  44.085  46.572  1.00 29.22           C  
ATOM   6676  CG  PRO H  11      76.375  42.964  46.130  1.00 30.20           C  
ATOM   6677  CD  PRO H  11      75.382  41.975  45.585  1.00 29.16           C  
ATOM   6678  N   LYS H  12      72.481  44.514  48.281  1.00 32.96           N  
ATOM   6679  CA  LYS H  12      71.212  45.211  48.319  1.00 34.62           C  
ATOM   6680  C   LYS H  12      71.343  46.571  47.671  1.00 33.96           C  
ATOM   6681  O   LYS H  12      72.297  47.301  47.926  1.00 33.19           O  
ATOM   6682  CB  LYS H  12      70.729  45.359  49.771  1.00 38.44           C  
ATOM   6683  CG  LYS H  12      70.148  44.080  50.382  1.00 39.64           C  
ATOM   6684  CD  LYS H  12      69.552  44.353  51.755  1.00 41.73           C  
ATOM   6685  CE  LYS H  12      68.832  43.129  52.315  1.00 43.05           C  
ATOM   6686  NZ  LYS H  12      69.717  41.930  52.420  1.00 43.62           N  
ATOM   6687  N   PRO H  13      70.383  46.927  46.811  1.00 34.32           N  
ATOM   6688  CA  PRO H  13      70.467  48.233  46.157  1.00 34.34           C  
ATOM   6689  C   PRO H  13      69.986  49.388  47.034  1.00 35.56           C  
ATOM   6690  O   PRO H  13      68.845  49.413  47.476  1.00 34.04           O  
ATOM   6691  CB  PRO H  13      69.627  48.039  44.897  1.00 33.35           C  
ATOM   6692  CG  PRO H  13      68.579  47.062  45.334  1.00 34.66           C  
ATOM   6693  CD  PRO H  13      69.325  46.086  46.215  1.00 33.22           C  
ATOM   6694  N   ILE H  14      70.887  50.329  47.299  1.00 37.80           N  
ATOM   6695  CA  ILE H  14      70.585  51.512  48.095  1.00 38.43           C  
ATOM   6696  C   ILE H  14      70.260  52.616  47.087  1.00 39.57           C  
ATOM   6697  O   ILE H  14      71.144  53.085  46.364  1.00 41.99           O  
ATOM   6698  CB  ILE H  14      71.813  51.968  48.952  1.00 38.58           C  
ATOM   6699  CG1 ILE H  14      72.033  51.015  50.125  1.00 38.12           C  
ATOM   6700  CG2 ILE H  14      71.595  53.374  49.483  1.00 37.41           C  
ATOM   6701  CD1 ILE H  14      72.779  49.755  49.768  1.00 42.29           C  
ATOM   6702  N   GLY H  15      68.999  53.030  47.025  1.00 37.27           N  
ATOM   6703  CA  GLY H  15      68.641  54.065  46.076  1.00 35.67           C  
ATOM   6704  C   GLY H  15      67.557  53.627  45.107  1.00 34.33           C  
ATOM   6705  O   GLY H  15      67.083  52.490  45.158  1.00 34.88           O  
ATOM   6706  N   PRO H  16      67.153  54.514  44.186  1.00 31.29           N  
ATOM   6707  CA  PRO H  16      66.107  54.179  43.221  1.00 28.11           C  
ATOM   6708  C   PRO H  16      66.495  53.251  42.060  1.00 26.79           C  
ATOM   6709  O   PRO H  16      66.444  53.640  40.894  1.00 25.84           O  
ATOM   6710  CB  PRO H  16      65.641  55.553  42.758  1.00 27.12           C  
ATOM   6711  CG  PRO H  16      66.911  56.326  42.749  1.00 26.95           C  
ATOM   6712  CD  PRO H  16      67.595  55.913  44.024  1.00 27.68           C  
ATOM   6713  N   TYR H  17      66.898  52.027  42.373  1.00 25.67           N  
ATOM   6714  CA  TYR H  17      67.219  51.079  41.312  1.00 25.77           C  
ATOM   6715  C   TYR H  17      67.059  49.645  41.783  1.00 23.38           C  
ATOM   6716  O   TYR H  17      66.978  49.385  42.975  1.00 24.45           O  
ATOM   6717  CB  TYR H  17      68.627  51.314  40.745  1.00 27.27           C  
ATOM   6718  CG  TYR H  17      69.769  50.916  41.642  1.00 32.19           C  
ATOM   6719  CD1 TYR H  17      70.244  51.778  42.625  1.00 33.73           C  
ATOM   6720  CD2 TYR H  17      70.385  49.665  41.504  1.00 35.21           C  
ATOM   6721  CE1 TYR H  17      71.308  51.403  43.456  1.00 35.90           C  
ATOM   6722  CE2 TYR H  17      71.448  49.286  42.324  1.00 34.40           C  
ATOM   6723  CZ  TYR H  17      71.900  50.158  43.298  1.00 35.55           C  
ATOM   6724  OH  TYR H  17      72.931  49.784  44.130  1.00 37.40           O  
ATOM   6725  N   SER H  18      66.971  48.721  40.841  1.00 21.86           N  
ATOM   6726  CA  SER H  18      66.813  47.313  41.174  1.00 23.54           C  
ATOM   6727  C   SER H  18      68.056  46.547  40.741  1.00 23.26           C  
ATOM   6728  O   SER H  18      68.784  47.000  39.866  1.00 22.65           O  
ATOM   6729  CB  SER H  18      65.581  46.743  40.464  1.00 24.01           C  
ATOM   6730  OG  SER H  18      64.395  47.391  40.896  1.00 22.58           O  
ATOM   6731  N   GLN H  19      68.288  45.385  41.345  1.00 23.30           N  
ATOM   6732  CA  GLN H  19      69.455  44.564  41.007  1.00 23.68           C  
ATOM   6733  C   GLN H  19      69.422  44.150  39.544  1.00 24.37           C  
ATOM   6734  O   GLN H  19      70.467  43.992  38.903  1.00 23.29           O  
ATOM   6735  CB  GLN H  19      69.508  43.322  41.893  1.00 23.27           C  
ATOM   6736  CG  GLN H  19      69.645  43.624  43.364  1.00 22.50           C  
ATOM   6737  CD  GLN H  19      69.633  42.367  44.195  1.00 26.45           C  
ATOM   6738  OE1 GLN H  19      68.744  41.524  44.045  1.00 27.58           O  
ATOM   6739  NE2 GLN H  19      70.623  42.226  45.077  1.00 22.50           N  
ATOM   6740  N   ALA H  20      68.209  43.971  39.023  1.00 25.71           N  
ATOM   6741  CA  ALA H  20      68.011  43.608  37.623  1.00 25.42           C  
ATOM   6742  C   ALA H  20      66.543  43.680  37.212  1.00 25.39           C  
ATOM   6743  O   ALA H  20      65.643  43.606  38.047  1.00 25.36           O  
ATOM   6744  CB  ALA H  20      68.565  42.205  37.353  1.00 24.87           C  
ATOM   6745  N   ILE H  21      66.324  43.840  35.911  1.00 26.34           N  
ATOM   6746  CA  ILE H  21      64.987  43.898  35.324  1.00 26.21           C  
ATOM   6747  C   ILE H  21      64.946  42.873  34.198  1.00 28.32           C  
ATOM   6748  O   ILE H  21      65.849  42.823  33.358  1.00 26.20           O  
ATOM   6749  CB  ILE H  21      64.657  45.303  34.708  1.00 23.65           C  
ATOM   6750  CG1 ILE H  21      64.645  46.380  35.801  1.00 19.39           C  
ATOM   6751  CG2 ILE H  21      63.315  45.251  33.981  1.00 19.11           C  
ATOM   6752  CD1 ILE H  21      63.516  46.225  36.807  1.00 14.71           C  
ATOM   6753  N   LYS H  22      63.898  42.052  34.205  1.00 31.34           N  
ATOM   6754  CA  LYS H  22      63.683  41.029  33.192  1.00 33.78           C  
ATOM   6755  C   LYS H  22      62.601  41.541  32.246  1.00 33.86           C  
ATOM   6756  O   LYS H  22      61.437  41.666  32.636  1.00 33.92           O  
ATOM   6757  CB  LYS H  22      63.223  39.724  33.847  1.00 37.23           C  
ATOM   6758  CG  LYS H  22      62.787  38.644  32.854  1.00 40.27           C  
ATOM   6759  CD  LYS H  22      62.478  37.322  33.549  1.00 42.27           C  
ATOM   6760  CE  LYS H  22      61.833  36.340  32.582  1.00 45.94           C  
ATOM   6761  NZ  LYS H  22      62.661  36.120  31.351  1.00 46.36           N  
ATOM   6762  N   ALA H  23      62.994  41.832  31.010  1.00 32.56           N  
ATOM   6763  CA  ALA H  23      62.087  42.348  29.991  1.00 32.61           C  
ATOM   6764  C   ALA H  23      62.121  41.420  28.789  1.00 33.96           C  
ATOM   6765  O   ALA H  23      63.108  41.373  28.055  1.00 35.14           O  
ATOM   6766  CB  ALA H  23      62.520  43.744  29.575  1.00 29.91           C  
ATOM   6767  N   GLY H  24      61.029  40.699  28.566  1.00 35.40           N  
ATOM   6768  CA  GLY H  24      61.020  39.768  27.460  1.00 35.12           C  
ATOM   6769  C   GLY H  24      61.937  38.619  27.851  1.00 36.22           C  
ATOM   6770  O   GLY H  24      61.899  38.148  28.991  1.00 36.76           O  
ATOM   6771  N   ASN H  25      62.768  38.172  26.918  1.00 35.45           N  
ATOM   6772  CA  ASN H  25      63.687  37.075  27.177  1.00 35.82           C  
ATOM   6773  C   ASN H  25      65.027  37.659  27.591  1.00 34.91           C  
ATOM   6774  O   ASN H  25      66.024  36.946  27.698  1.00 34.76           O  
ATOM   6775  CB  ASN H  25      63.869  36.222  25.912  1.00 39.71           C  
ATOM   6776  CG  ASN H  25      62.565  35.617  25.419  1.00 41.68           C  
ATOM   6777  OD1 ASN H  25      61.883  34.895  26.147  1.00 44.79           O  
ATOM   6778  ND2 ASN H  25      62.214  35.906  24.175  1.00 43.13           N  
ATOM   6779  N   PHE H  26      65.040  38.966  27.818  1.00 33.43           N  
ATOM   6780  CA  PHE H  26      66.257  39.676  28.209  1.00 30.38           C  
ATOM   6781  C   PHE H  26      66.315  40.034  29.687  1.00 26.44           C  
ATOM   6782  O   PHE H  26      65.302  40.395  30.296  1.00 26.53           O  
ATOM   6783  CB  PHE H  26      66.388  40.964  27.406  1.00 31.61           C  
ATOM   6784  CG  PHE H  26      66.934  40.778  26.019  1.00 33.37           C  
ATOM   6785  CD1 PHE H  26      68.308  40.723  25.800  1.00 32.03           C  
ATOM   6786  CD2 PHE H  26      66.079  40.737  24.921  1.00 34.76           C  
ATOM   6787  CE1 PHE H  26      68.825  40.643  24.514  1.00 32.36           C  
ATOM   6788  CE2 PHE H  26      66.585  40.657  23.627  1.00 33.66           C  
ATOM   6789  CZ  PHE H  26      67.965  40.611  23.426  1.00 34.38           C  
ATOM   6790  N   LEU H  27      67.509  39.926  30.259  1.00 22.14           N  
ATOM   6791  CA  LEU H  27      67.717  40.283  31.655  1.00 19.33           C  
ATOM   6792  C   LEU H  27      68.779  41.381  31.673  1.00 18.86           C  
ATOM   6793  O   LEU H  27      69.840  41.247  31.057  1.00 18.14           O  
ATOM   6794  CB  LEU H  27      68.192  39.080  32.478  1.00 18.95           C  
ATOM   6795  CG  LEU H  27      68.357  39.349  33.987  1.00 20.07           C  
ATOM   6796  CD1 LEU H  27      67.002  39.713  34.595  1.00 17.98           C  
ATOM   6797  CD2 LEU H  27      68.937  38.117  34.692  1.00 16.82           C  
ATOM   6798  N   PHE H  28      68.467  42.485  32.346  1.00 18.55           N  
ATOM   6799  CA  PHE H  28      69.381  43.616  32.457  1.00 16.72           C  
ATOM   6800  C   PHE H  28      69.816  43.754  33.913  1.00 17.45           C  
ATOM   6801  O   PHE H  28      69.019  44.094  34.781  1.00 17.81           O  
ATOM   6802  CB  PHE H  28      68.700  44.902  31.959  1.00 16.06           C  
ATOM   6803  CG  PHE H  28      68.424  44.903  30.468  1.00 14.03           C  
ATOM   6804  CD1 PHE H  28      67.363  44.171  29.938  1.00 15.60           C  
ATOM   6805  CD2 PHE H  28      69.253  45.585  29.598  1.00 12.51           C  
ATOM   6806  CE1 PHE H  28      67.140  44.117  28.555  1.00 15.67           C  
ATOM   6807  CE2 PHE H  28      69.040  45.537  28.221  1.00 14.18           C  
ATOM   6808  CZ  PHE H  28      67.982  44.800  27.701  1.00 13.33           C  
ATOM   6809  N   ILE H  29      71.090  43.483  34.170  1.00 17.19           N  
ATOM   6810  CA  ILE H  29      71.640  43.526  35.517  1.00 17.31           C  
ATOM   6811  C   ILE H  29      72.345  44.826  35.847  1.00 18.51           C  
ATOM   6812  O   ILE H  29      73.191  45.302  35.092  1.00 19.23           O  
ATOM   6813  CB  ILE H  29      72.616  42.345  35.737  1.00 17.96           C  
ATOM   6814  CG1 ILE H  29      71.834  41.029  35.705  1.00 17.67           C  
ATOM   6815  CG2 ILE H  29      73.336  42.493  37.073  1.00 20.69           C  
ATOM   6816  CD1 ILE H  29      72.672  39.808  35.456  1.00 17.09           C  
ATOM   6817  N   ALA H  30      71.986  45.400  36.989  1.00 20.98           N  
ATOM   6818  CA  ALA H  30      72.590  46.653  37.435  1.00 20.91           C  
ATOM   6819  C   ALA H  30      74.088  46.466  37.676  1.00 20.35           C  
ATOM   6820  O   ALA H  30      74.548  45.366  38.017  1.00 18.67           O  
ATOM   6821  CB  ALA H  30      71.924  47.128  38.711  1.00 17.27           C  
ATOM   6822  N   GLY H  31      74.837  47.545  37.486  1.00 18.80           N  
ATOM   6823  CA  GLY H  31      76.269  47.492  37.708  1.00 22.89           C  
ATOM   6824  C   GLY H  31      76.547  46.939  39.096  1.00 24.34           C  
ATOM   6825  O   GLY H  31      75.983  47.403  40.089  1.00 23.35           O  
ATOM   6826  N   GLN H  32      77.407  45.930  39.164  1.00 24.76           N  
ATOM   6827  CA  GLN H  32      77.744  45.312  40.433  1.00 27.08           C  
ATOM   6828  C   GLN H  32      79.162  45.685  40.855  1.00 29.39           C  
ATOM   6829  O   GLN H  32      80.051  45.849  40.012  1.00 28.13           O  
ATOM   6830  CB  GLN H  32      77.635  43.788  40.323  1.00 27.65           C  
ATOM   6831  CG  GLN H  32      76.263  43.282  39.989  1.00 25.57           C  
ATOM   6832  CD  GLN H  32      75.270  43.653  41.053  1.00 29.23           C  
ATOM   6833  OE1 GLN H  32      75.434  43.290  42.212  1.00 29.52           O  
ATOM   6834  NE2 GLN H  32      74.234  44.387  40.674  1.00 28.73           N  
ATOM   6835  N   ILE H  33      79.355  45.836  42.164  1.00 30.59           N  
ATOM   6836  CA  ILE H  33      80.665  46.146  42.713  1.00 31.76           C  
ATOM   6837  C   ILE H  33      81.035  45.009  43.673  1.00 33.53           C  
ATOM   6838  O   ILE H  33      80.155  44.292  44.154  1.00 33.70           O  
ATOM   6839  CB  ILE H  33      80.681  47.529  43.418  1.00 31.57           C  
ATOM   6840  CG1 ILE H  33      79.589  47.617  44.477  1.00 29.98           C  
ATOM   6841  CG2 ILE H  33      80.499  48.647  42.380  1.00 31.03           C  
ATOM   6842  CD1 ILE H  33      79.627  48.941  45.254  1.00 26.34           C  
ATOM   6843  N   PRO H  34      82.341  44.825  43.947  1.00 34.81           N  
ATOM   6844  CA  PRO H  34      82.919  43.793  44.821  1.00 36.10           C  
ATOM   6845  C   PRO H  34      82.547  43.772  46.308  1.00 37.96           C  
ATOM   6846  O   PRO H  34      83.411  43.662  47.174  1.00 38.02           O  
ATOM   6847  CB  PRO H  34      84.420  43.967  44.601  1.00 34.43           C  
ATOM   6848  CG  PRO H  34      84.549  45.421  44.382  1.00 33.23           C  
ATOM   6849  CD  PRO H  34      83.391  45.746  43.478  1.00 34.75           C  
ATOM   6850  N   ILE H  35      81.255  43.866  46.592  1.00 38.91           N  
ATOM   6851  CA  ILE H  35      80.762  43.836  47.957  1.00 38.19           C  
ATOM   6852  C   ILE H  35      80.346  42.413  48.277  1.00 40.36           C  
ATOM   6853  O   ILE H  35      79.812  41.711  47.415  1.00 42.02           O  
ATOM   6854  CB  ILE H  35      79.508  44.712  48.128  1.00 37.91           C  
ATOM   6855  CG1 ILE H  35      79.863  46.193  48.010  1.00 36.75           C  
ATOM   6856  CG2 ILE H  35      78.854  44.416  49.470  1.00 37.75           C  
ATOM   6857  CD1 ILE H  35      78.631  47.098  47.909  1.00 34.30           C  
ATOM   6858  N   ASP H  36      80.589  41.984  49.511  1.00 41.18           N  
ATOM   6859  CA  ASP H  36      80.175  40.653  49.927  1.00 41.15           C  
ATOM   6860  C   ASP H  36      78.865  40.862  50.667  1.00 39.76           C  
ATOM   6861  O   ASP H  36      78.852  41.334  51.798  1.00 39.53           O  
ATOM   6862  CB  ASP H  36      81.219  40.013  50.847  1.00 45.03           C  
ATOM   6863  CG  ASP H  36      80.725  38.723  51.481  1.00 47.53           C  
ATOM   6864  OD1 ASP H  36      80.082  37.916  50.779  1.00 50.15           O  
ATOM   6865  OD2 ASP H  36      80.986  38.509  52.683  1.00 50.89           O  
ATOM   6866  N   PRO H  37      77.739  40.529  50.026  1.00 39.90           N  
ATOM   6867  CA  PRO H  37      76.420  40.695  50.645  1.00 39.51           C  
ATOM   6868  C   PRO H  37      76.296  40.213  52.095  1.00 40.23           C  
ATOM   6869  O   PRO H  37      75.553  40.795  52.889  1.00 40.23           O  
ATOM   6870  CB  PRO H  37      75.489  39.948  49.676  1.00 37.97           C  
ATOM   6871  CG  PRO H  37      76.399  38.965  48.991  1.00 37.12           C  
ATOM   6872  CD  PRO H  37      77.631  39.785  48.758  1.00 38.54           C  
ATOM   6873  N   LYS H  38      77.030  39.163  52.445  1.00 42.57           N  
ATOM   6874  CA  LYS H  38      76.990  38.618  53.803  1.00 43.87           C  
ATOM   6875  C   LYS H  38      77.509  39.633  54.833  1.00 42.21           C  
ATOM   6876  O   LYS H  38      76.961  39.750  55.929  1.00 42.63           O  
ATOM   6877  CB  LYS H  38      77.820  37.330  53.875  1.00 46.26           C  
ATOM   6878  CG  LYS H  38      77.544  36.454  55.098  1.00 52.13           C  
ATOM   6879  CD  LYS H  38      78.631  35.379  55.294  1.00 55.57           C  
ATOM   6880  CE  LYS H  38      78.781  34.466  54.066  1.00 58.62           C  
ATOM   6881  NZ  LYS H  38      79.925  33.505  54.193  1.00 58.68           N  
ATOM   6882  N   THR H  39      78.549  40.377  54.470  1.00 40.71           N  
ATOM   6883  CA  THR H  39      79.140  41.360  55.374  1.00 39.16           C  
ATOM   6884  C   THR H  39      78.774  42.807  55.076  1.00 40.43           C  
ATOM   6885  O   THR H  39      78.872  43.660  55.956  1.00 41.28           O  
ATOM   6886  CB  THR H  39      80.671  41.281  55.365  1.00 38.17           C  
ATOM   6887  OG1 THR H  39      81.168  41.893  54.171  1.00 36.07           O  
ATOM   6888  CG2 THR H  39      81.133  39.835  55.431  1.00 33.97           C  
ATOM   6889  N   GLY H  40      78.385  43.090  53.836  1.00 40.25           N  
ATOM   6890  CA  GLY H  40      78.017  44.446  53.466  1.00 39.97           C  
ATOM   6891  C   GLY H  40      79.193  45.391  53.242  1.00 41.52           C  
ATOM   6892  O   GLY H  40      79.006  46.596  53.063  1.00 39.32           O  
ATOM   6893  N   GLU H  41      80.408  44.851  53.255  1.00 43.49           N  
ATOM   6894  CA  GLU H  41      81.605  45.661  53.044  1.00 45.34           C  
ATOM   6895  C   GLU H  41      82.288  45.193  51.761  1.00 46.12           C  
ATOM   6896  O   GLU H  41      82.006  44.102  51.266  1.00 46.61           O  
ATOM   6897  CB  GLU H  41      82.580  45.489  54.207  1.00 45.97           C  
ATOM   6898  CG  GLU H  41      81.930  45.325  55.563  1.00 51.84           C  
ATOM   6899  CD  GLU H  41      82.947  45.113  56.678  1.00 54.17           C  
ATOM   6900  OE1 GLU H  41      83.880  44.302  56.491  1.00 53.92           O  
ATOM   6901  OE2 GLU H  41      82.806  45.755  57.745  1.00 56.27           O  
ATOM   6902  N   ILE H  42      83.175  46.021  51.216  1.00 46.67           N  
ATOM   6903  CA  ILE H  42      83.907  45.639  50.019  1.00 47.28           C  
ATOM   6904  C   ILE H  42      84.743  44.450  50.456  1.00 48.03           C  
ATOM   6905  O   ILE H  42      85.191  44.403  51.596  1.00 48.61           O  
ATOM   6906  CB  ILE H  42      84.851  46.758  49.544  1.00 47.48           C  
ATOM   6907  CG1 ILE H  42      84.048  48.001  49.167  1.00 46.79           C  
ATOM   6908  CG2 ILE H  42      85.656  46.278  48.350  1.00 49.15           C  
ATOM   6909  CD1 ILE H  42      83.110  47.787  47.992  1.00 50.01           C  
ATOM   6910  N   VAL H  43      84.948  43.490  49.564  1.00 50.03           N  
ATOM   6911  CA  VAL H  43      85.725  42.299  49.893  1.00 51.53           C  
ATOM   6912  C   VAL H  43      87.228  42.547  49.939  1.00 52.85           C  
ATOM   6913  O   VAL H  43      87.907  41.779  50.662  1.00 53.61           O  
ATOM   6914  CB  VAL H  43      85.457  41.164  48.894  1.00 51.35           C  
ATOM   6915  CG1 VAL H  43      84.011  40.726  48.994  1.00 51.28           C  
ATOM   6916  CG2 VAL H  43      85.787  41.624  47.485  1.00 52.15           C  
ATOM   6917  N   GLY H  45      90.529  45.535  48.503  1.00 57.19           N  
ATOM   6918  CA  GLY H  45      91.213  44.212  48.440  1.00 57.95           C  
ATOM   6919  C   GLY H  45      92.045  44.026  47.182  1.00 58.02           C  
ATOM   6920  O   GLY H  45      92.578  44.988  46.624  1.00 57.77           O  
ATOM   6921  N   ASP H  46      92.157  42.779  46.737  1.00 57.62           N  
ATOM   6922  CA  ASP H  46      92.928  42.454  45.540  1.00 57.62           C  
ATOM   6923  C   ASP H  46      92.056  42.236  44.296  1.00 56.70           C  
ATOM   6924  O   ASP H  46      91.109  41.444  44.320  1.00 55.73           O  
ATOM   6925  CB  ASP H  46      93.780  41.209  45.796  1.00 58.00           C  
ATOM   6926  CG  ASP H  46      94.367  40.642  44.522  1.00 58.89           C  
ATOM   6927  OD1 ASP H  46      95.000  41.413  43.770  1.00 57.87           O  
ATOM   6928  OD2 ASP H  46      94.190  39.428  44.274  1.00 59.92           O  
ATOM   6929  N   ILE H  47      92.405  42.930  43.212  1.00 55.04           N  
ATOM   6930  CA  ILE H  47      91.677  42.861  41.945  1.00 53.57           C  
ATOM   6931  C   ILE H  47      91.169  41.464  41.593  1.00 53.72           C  
ATOM   6932  O   ILE H  47      90.006  41.297  41.244  1.00 54.50           O  
ATOM   6933  CB  ILE H  47      92.546  43.389  40.774  1.00 52.88           C  
ATOM   6934  CG1 ILE H  47      91.660  43.715  39.568  1.00 52.88           C  
ATOM   6935  CG2 ILE H  47      93.589  42.359  40.382  1.00 50.72           C  
ATOM   6936  CD1 ILE H  47      90.708  44.866  39.810  1.00 51.45           C  
ATOM   6937  N   LYS H  48      92.037  40.466  41.691  1.00 53.99           N  
ATOM   6938  CA  LYS H  48      91.656  39.095  41.376  1.00 54.58           C  
ATOM   6939  C   LYS H  48      90.482  38.640  42.237  1.00 54.08           C  
ATOM   6940  O   LYS H  48      89.599  37.921  41.773  1.00 52.94           O  
ATOM   6941  CB  LYS H  48      92.855  38.155  41.580  1.00 54.02           C  
ATOM   6942  N   ASP H  49      90.477  39.062  43.494  1.00 53.93           N  
ATOM   6943  CA  ASP H  49      89.414  38.682  44.415  1.00 54.29           C  
ATOM   6944  C   ASP H  49      88.188  39.583  44.288  1.00 52.49           C  
ATOM   6945  O   ASP H  49      87.053  39.122  44.438  1.00 52.26           O  
ATOM   6946  CB  ASP H  49      89.947  38.694  45.850  1.00 57.12           C  
ATOM   6947  CG  ASP H  49      91.137  37.760  46.032  1.00 59.34           C  
ATOM   6948  OD1 ASP H  49      92.218  38.044  45.465  1.00 61.95           O  
ATOM   6949  OD2 ASP H  49      90.986  36.736  46.732  1.00 58.58           O  
ATOM   6950  N   GLN H  50      88.417  40.864  44.017  1.00 50.36           N  
ATOM   6951  CA  GLN H  50      87.321  41.805  43.840  1.00 47.81           C  
ATOM   6952  C   GLN H  50      86.570  41.429  42.570  1.00 47.62           C  
ATOM   6953  O   GLN H  50      85.352  41.549  42.500  1.00 47.73           O  
ATOM   6954  CB  GLN H  50      87.847  43.239  43.722  1.00 45.29           C  
ATOM   6955  CG  GLN H  50      87.803  44.020  45.025  1.00 44.03           C  
ATOM   6956  CD  GLN H  50      88.092  45.502  44.839  1.00 43.05           C  
ATOM   6957  OE1 GLN H  50      87.553  46.150  43.936  1.00 43.04           O  
ATOM   6958  NE2 GLN H  50      88.937  46.047  45.700  1.00 42.54           N  
ATOM   6959  N   THR H  51      87.301  40.961  41.565  1.00 47.14           N  
ATOM   6960  CA  THR H  51      86.673  40.564  40.314  1.00 46.76           C  
ATOM   6961  C   THR H  51      85.919  39.249  40.498  1.00 45.04           C  
ATOM   6962  O   THR H  51      84.973  38.956  39.771  1.00 46.92           O  
ATOM   6963  CB  THR H  51      87.709  40.406  39.193  1.00 46.97           C  
ATOM   6964  OG1 THR H  51      87.042  40.124  37.958  1.00 48.08           O  
ATOM   6965  CG2 THR H  51      88.654  39.272  39.511  1.00 50.93           C  
ATOM   6966  N   ARG H  52      86.331  38.457  41.479  1.00 43.15           N  
ATOM   6967  CA  ARG H  52      85.664  37.193  41.743  1.00 41.21           C  
ATOM   6968  C   ARG H  52      84.358  37.451  42.478  1.00 38.81           C  
ATOM   6969  O   ARG H  52      83.355  36.777  42.250  1.00 37.48           O  
ATOM   6970  CB  ARG H  52      86.550  36.286  42.590  1.00 42.62           C  
ATOM   6971  CG  ARG H  52      85.852  35.013  43.040  1.00 46.46           C  
ATOM   6972  CD  ARG H  52      86.850  34.020  43.579  1.00 50.83           C  
ATOM   6973  NE  ARG H  52      87.810  33.633  42.552  1.00 54.33           N  
ATOM   6974  CZ  ARG H  52      88.899  32.912  42.788  1.00 56.85           C  
ATOM   6975  NH1 ARG H  52      89.719  32.605  41.790  1.00 58.35           N  
ATOM   6976  NH2 ARG H  52      89.168  32.503  44.021  1.00 57.77           N  
ATOM   6977  N   GLN H  53      84.382  38.435  43.368  1.00 37.16           N  
ATOM   6978  CA  GLN H  53      83.197  38.778  44.135  1.00 33.33           C  
ATOM   6979  C   GLN H  53      82.146  39.395  43.229  1.00 31.60           C  
ATOM   6980  O   GLN H  53      80.975  39.069  43.335  1.00 31.51           O  
ATOM   6981  CB  GLN H  53      83.545  39.753  45.251  1.00 31.38           C  
ATOM   6982  CG  GLN H  53      82.382  40.011  46.195  1.00 33.95           C  
ATOM   6983  CD  GLN H  53      81.957  38.773  46.964  1.00 31.92           C  
ATOM   6984  OE1 GLN H  53      82.737  38.210  47.725  1.00 36.46           O  
ATOM   6985  NE2 GLN H  53      80.717  38.346  46.770  1.00 31.04           N  
ATOM   6986  N   VAL H  54      82.572  40.283  42.337  1.00 29.87           N  
ATOM   6987  CA  VAL H  54      81.661  40.933  41.409  1.00 28.00           C  
ATOM   6988  C   VAL H  54      80.976  39.875  40.558  1.00 29.06           C  
ATOM   6989  O   VAL H  54      79.775  39.948  40.307  1.00 30.20           O  
ATOM   6990  CB  VAL H  54      82.412  41.928  40.493  1.00 28.09           C  
ATOM   6991  CG1 VAL H  54      81.481  42.458  39.406  1.00 27.15           C  
ATOM   6992  CG2 VAL H  54      82.953  43.082  41.323  1.00 27.97           C  
ATOM   6993  N   LEU H  55      81.747  38.887  40.121  1.00 28.85           N  
ATOM   6994  CA  LEU H  55      81.214  37.805  39.309  1.00 29.43           C  
ATOM   6995  C   LEU H  55      80.260  36.947  40.136  1.00 30.79           C  
ATOM   6996  O   LEU H  55      79.270  36.432  39.621  1.00 30.12           O  
ATOM   6997  CB  LEU H  55      82.359  36.953  38.764  1.00 27.70           C  
ATOM   6998  CG  LEU H  55      82.787  37.143  37.301  1.00 28.77           C  
ATOM   6999  CD1 LEU H  55      82.255  38.447  36.728  1.00 27.84           C  
ATOM   7000  CD2 LEU H  55      84.314  37.081  37.221  1.00 27.99           C  
ATOM   7001  N   GLU H  56      80.560  36.787  41.418  1.00 31.61           N  
ATOM   7002  CA  GLU H  56      79.690  36.005  42.285  1.00 33.17           C  
ATOM   7003  C   GLU H  56      78.341  36.705  42.420  1.00 29.95           C  
ATOM   7004  O   GLU H  56      77.282  36.077  42.361  1.00 27.27           O  
ATOM   7005  CB  GLU H  56      80.329  35.830  43.668  1.00 37.20           C  
ATOM   7006  CG  GLU H  56      81.246  34.637  43.753  1.00 43.39           C  
ATOM   7007  CD  GLU H  56      80.549  33.358  43.318  1.00 47.69           C  
ATOM   7008  OE1 GLU H  56      79.504  33.006  43.916  1.00 49.30           O  
ATOM   7009  OE2 GLU H  56      81.045  32.705  42.373  1.00 50.80           O  
ATOM   7010  N   ASN H  57      78.393  38.018  42.603  1.00 28.25           N  
ATOM   7011  CA  ASN H  57      77.185  38.814  42.736  1.00 26.10           C  
ATOM   7012  C   ASN H  57      76.338  38.648  41.483  1.00 24.93           C  
ATOM   7013  O   ASN H  57      75.151  38.349  41.556  1.00 25.92           O  
ATOM   7014  CB  ASN H  57      77.526  40.297  42.916  1.00 25.61           C  
ATOM   7015  CG  ASN H  57      78.116  40.607  44.273  1.00 26.50           C  
ATOM   7016  OD1 ASN H  57      77.982  39.827  45.218  1.00 26.31           O  
ATOM   7017  ND2 ASN H  57      78.760  41.767  44.385  1.00 28.56           N  
ATOM   7018  N   ILE H  58      76.962  38.843  40.329  1.00 23.22           N  
ATOM   7019  CA  ILE H  58      76.258  38.725  39.078  1.00 22.83           C  
ATOM   7020  C   ILE H  58      75.551  37.390  38.992  1.00 24.22           C  
ATOM   7021  O   ILE H  58      74.368  37.327  38.653  1.00 26.49           O  
ATOM   7022  CB  ILE H  58      77.222  38.911  37.892  1.00 23.38           C  
ATOM   7023  CG1 ILE H  58      77.617  40.392  37.798  1.00 24.96           C  
ATOM   7024  CG2 ILE H  58      76.576  38.438  36.599  1.00 23.22           C  
ATOM   7025  CD1 ILE H  58      78.548  40.746  36.637  1.00 25.74           C  
ATOM   7026  N   LYS H  59      76.264  36.322  39.327  1.00 24.80           N  
ATOM   7027  CA  LYS H  59      75.703  34.984  39.267  1.00 25.78           C  
ATOM   7028  C   LYS H  59      74.506  34.826  40.199  1.00 26.73           C  
ATOM   7029  O   LYS H  59      73.478  34.260  39.813  1.00 25.61           O  
ATOM   7030  CB  LYS H  59      76.780  33.957  39.609  1.00 28.76           C  
ATOM   7031  CG  LYS H  59      76.342  32.511  39.485  1.00 33.11           C  
ATOM   7032  CD  LYS H  59      77.497  31.572  39.766  1.00 38.06           C  
ATOM   7033  CE  LYS H  59      77.090  30.117  39.577  1.00 41.64           C  
ATOM   7034  NZ  LYS H  59      78.232  29.183  39.832  1.00 44.63           N  
ATOM   7035  N   ALA H  60      74.630  35.325  41.425  1.00 26.89           N  
ATOM   7036  CA  ALA H  60      73.525  35.215  42.374  1.00 27.64           C  
ATOM   7037  C   ALA H  60      72.264  35.802  41.750  1.00 27.73           C  
ATOM   7038  O   ALA H  60      71.185  35.215  41.840  1.00 29.30           O  
ATOM   7039  CB  ALA H  60      73.859  35.937  43.679  1.00 26.83           C  
ATOM   7040  N   ILE H  61      72.408  36.958  41.110  1.00 26.31           N  
ATOM   7041  CA  ILE H  61      71.278  37.623  40.466  1.00 26.73           C  
ATOM   7042  C   ILE H  61      70.707  36.806  39.296  1.00 27.86           C  
ATOM   7043  O   ILE H  61      69.495  36.635  39.183  1.00 25.79           O  
ATOM   7044  CB  ILE H  61      71.696  39.027  39.957  1.00 23.91           C  
ATOM   7045  CG1 ILE H  61      72.195  39.857  41.148  1.00 22.92           C  
ATOM   7046  CG2 ILE H  61      70.534  39.693  39.231  1.00 19.71           C  
ATOM   7047  CD1 ILE H  61      72.790  41.183  40.801  1.00 20.49           C  
ATOM   7048  N   LEU H  62      71.580  36.306  38.426  1.00 29.22           N  
ATOM   7049  CA  LEU H  62      71.126  35.516  37.292  1.00 31.30           C  
ATOM   7050  C   LEU H  62      70.234  34.365  37.740  1.00 33.36           C  
ATOM   7051  O   LEU H  62      69.133  34.187  37.225  1.00 35.22           O  
ATOM   7052  CB  LEU H  62      72.324  34.980  36.517  1.00 30.39           C  
ATOM   7053  CG  LEU H  62      73.037  36.052  35.700  1.00 30.63           C  
ATOM   7054  CD1 LEU H  62      74.343  35.522  35.142  1.00 29.70           C  
ATOM   7055  CD2 LEU H  62      72.118  36.493  34.583  1.00 30.61           C  
ATOM   7056  N   GLU H  63      70.705  33.597  38.714  1.00 35.60           N  
ATOM   7057  CA  GLU H  63      69.954  32.463  39.225  1.00 37.38           C  
ATOM   7058  C   GLU H  63      68.654  32.839  39.922  1.00 37.14           C  
ATOM   7059  O   GLU H  63      67.680  32.080  39.890  1.00 37.20           O  
ATOM   7060  CB  GLU H  63      70.833  31.637  40.163  1.00 41.98           C  
ATOM   7061  CG  GLU H  63      71.907  30.848  39.420  1.00 48.57           C  
ATOM   7062  CD  GLU H  63      72.645  29.869  40.309  1.00 51.88           C  
ATOM   7063  OE1 GLU H  63      71.977  29.150  41.088  1.00 52.86           O  
ATOM   7064  OE2 GLU H  63      73.893  29.815  40.219  1.00 55.77           O  
ATOM   7065  N   ALA H  64      68.625  34.004  40.555  1.00 35.44           N  
ATOM   7066  CA  ALA H  64      67.409  34.428  41.228  1.00 34.45           C  
ATOM   7067  C   ALA H  64      66.327  34.735  40.184  1.00 34.89           C  
ATOM   7068  O   ALA H  64      65.138  34.819  40.509  1.00 35.07           O  
ATOM   7069  CB  ALA H  64      67.689  35.660  42.092  1.00 32.82           C  
ATOM   7070  N   ALA H  65      66.751  34.868  38.927  1.00 32.96           N  
ATOM   7071  CA  ALA H  65      65.852  35.189  37.830  1.00 32.89           C  
ATOM   7072  C   ALA H  65      65.517  33.995  36.955  1.00 34.95           C  
ATOM   7073  O   ALA H  65      64.509  33.995  36.243  1.00 32.97           O  
ATOM   7074  CB  ALA H  65      66.459  36.288  36.984  1.00 31.40           C  
ATOM   7075  N   GLY H  66      66.370  32.980  37.004  1.00 38.40           N  
ATOM   7076  CA  GLY H  66      66.148  31.795  36.198  1.00 40.90           C  
ATOM   7077  C   GLY H  66      67.101  31.753  35.025  1.00 43.08           C  
ATOM   7078  O   GLY H  66      66.792  31.190  33.978  1.00 45.68           O  
ATOM   7079  N   TYR H  67      68.267  32.357  35.194  1.00 43.56           N  
ATOM   7080  CA  TYR H  67      69.260  32.376  34.136  1.00 45.56           C  
ATOM   7081  C   TYR H  67      70.529  31.689  34.604  1.00 47.30           C  
ATOM   7082  O   TYR H  67      70.640  31.284  35.757  1.00 48.34           O  
ATOM   7083  CB  TYR H  67      69.584  33.815  33.729  1.00 45.05           C  
ATOM   7084  CG  TYR H  67      68.489  34.499  32.942  1.00 44.86           C  
ATOM   7085  CD1 TYR H  67      68.741  34.994  31.661  1.00 42.27           C  
ATOM   7086  CD2 TYR H  67      67.208  34.662  33.478  1.00 43.49           C  
ATOM   7087  CE1 TYR H  67      67.752  35.635  30.931  1.00 42.53           C  
ATOM   7088  CE2 TYR H  67      66.207  35.302  32.754  1.00 43.81           C  
ATOM   7089  CZ  TYR H  67      66.486  35.787  31.478  1.00 42.66           C  
ATOM   7090  OH  TYR H  67      65.506  36.420  30.745  1.00 40.46           O  
ATOM   7091  N   SER H  68      71.491  31.577  33.700  1.00 48.83           N  
ATOM   7092  CA  SER H  68      72.755  30.938  34.013  1.00 48.92           C  
ATOM   7093  C   SER H  68      73.905  31.674  33.329  1.00 48.89           C  
ATOM   7094  O   SER H  68      73.693  32.429  32.381  1.00 48.35           O  
ATOM   7095  CB  SER H  68      72.703  29.478  33.563  1.00 48.95           C  
ATOM   7096  OG  SER H  68      72.135  29.379  32.268  1.00 50.18           O  
ATOM   7097  N   LEU H  69      75.119  31.452  33.820  1.00 49.84           N  
ATOM   7098  CA  LEU H  69      76.312  32.092  33.269  1.00 50.18           C  
ATOM   7099  C   LEU H  69      76.413  31.906  31.758  1.00 49.36           C  
ATOM   7100  O   LEU H  69      77.053  32.697  31.059  1.00 48.96           O  
ATOM   7101  CB  LEU H  69      77.558  31.523  33.950  1.00 50.50           C  
ATOM   7102  CG  LEU H  69      77.548  31.659  35.474  1.00 50.63           C  
ATOM   7103  CD1 LEU H  69      78.796  31.020  36.070  1.00 50.22           C  
ATOM   7104  CD2 LEU H  69      77.468  33.132  35.841  1.00 49.33           C  
ATOM   7105  N   ASN H  70      75.773  30.854  31.261  1.00 49.15           N  
ATOM   7106  CA  ASN H  70      75.789  30.556  29.838  1.00 48.45           C  
ATOM   7107  C   ASN H  70      74.936  31.553  29.052  1.00 46.01           C  
ATOM   7108  O   ASN H  70      75.140  31.745  27.852  1.00 45.92           O  
ATOM   7109  CB  ASN H  70      75.277  29.127  29.597  1.00 51.86           C  
ATOM   7110  CG  ASN H  70      76.159  28.059  30.249  1.00 56.26           C  
ATOM   7111  OD1 ASN H  70      76.170  27.891  31.478  1.00 57.93           O  
ATOM   7112  ND2 ASN H  70      76.903  27.332  29.421  1.00 57.90           N  
ATOM   7113  N   ASP H  71      73.991  32.192  29.739  1.00 42.29           N  
ATOM   7114  CA  ASP H  71      73.089  33.150  29.111  1.00 39.00           C  
ATOM   7115  C   ASP H  71      73.641  34.555  28.923  1.00 37.11           C  
ATOM   7116  O   ASP H  71      73.172  35.295  28.062  1.00 37.82           O  
ATOM   7117  CB  ASP H  71      71.783  33.196  29.893  1.00 39.56           C  
ATOM   7118  CG  ASP H  71      71.060  31.866  29.866  1.00 41.80           C  
ATOM   7119  OD1 ASP H  71      70.102  31.664  30.646  1.00 42.24           O  
ATOM   7120  OD2 ASP H  71      71.462  31.015  29.049  1.00 44.29           O  
ATOM   7121  N   VAL H  72      74.642  34.925  29.714  1.00 34.11           N  
ATOM   7122  CA  VAL H  72      75.243  36.248  29.602  1.00 29.75           C  
ATOM   7123  C   VAL H  72      75.713  36.471  28.159  1.00 30.91           C  
ATOM   7124  O   VAL H  72      76.506  35.693  27.626  1.00 33.07           O  
ATOM   7125  CB  VAL H  72      76.421  36.378  30.575  1.00 26.93           C  
ATOM   7126  CG1 VAL H  72      77.017  37.762  30.499  1.00 26.97           C  
ATOM   7127  CG2 VAL H  72      75.956  36.065  31.984  1.00 26.32           C  
ATOM   7128  N   ILE H  73      75.220  37.531  27.523  1.00 30.63           N  
ATOM   7129  CA  ILE H  73      75.580  37.819  26.132  1.00 31.05           C  
ATOM   7130  C   ILE H  73      76.468  39.044  25.959  1.00 30.20           C  
ATOM   7131  O   ILE H  73      77.220  39.138  24.999  1.00 30.15           O  
ATOM   7132  CB  ILE H  73      74.313  38.021  25.256  1.00 32.46           C  
ATOM   7133  CG1 ILE H  73      73.658  39.370  25.589  1.00 33.27           C  
ATOM   7134  CG2 ILE H  73      73.336  36.869  25.480  1.00 30.09           C  
ATOM   7135  CD1 ILE H  73      72.353  39.633  24.867  1.00 33.77           C  
ATOM   7136  N   LYS H  74      76.374  39.986  26.888  1.00 31.42           N  
ATOM   7137  CA  LYS H  74      77.172  41.200  26.818  1.00 30.58           C  
ATOM   7138  C   LYS H  74      77.588  41.643  28.225  1.00 29.45           C  
ATOM   7139  O   LYS H  74      76.781  41.656  29.158  1.00 27.46           O  
ATOM   7140  CB  LYS H  74      76.365  42.305  26.122  1.00 31.27           C  
ATOM   7141  CG  LYS H  74      77.144  43.574  25.834  1.00 34.11           C  
ATOM   7142  CD  LYS H  74      76.206  44.688  25.421  1.00 38.18           C  
ATOM   7143  CE  LYS H  74      76.940  46.005  25.239  1.00 39.35           C  
ATOM   7144  NZ  LYS H  74      77.607  46.472  26.488  1.00 41.36           N  
ATOM   7145  N   VAL H  75      78.858  42.002  28.368  1.00 28.94           N  
ATOM   7146  CA  VAL H  75      79.404  42.446  29.641  1.00 29.24           C  
ATOM   7147  C   VAL H  75      80.158  43.762  29.474  1.00 31.69           C  
ATOM   7148  O   VAL H  75      80.871  43.965  28.488  1.00 32.86           O  
ATOM   7149  CB  VAL H  75      80.382  41.398  30.225  1.00 29.34           C  
ATOM   7150  CG1 VAL H  75      81.228  42.030  31.320  1.00 28.21           C  
ATOM   7151  CG2 VAL H  75      79.609  40.204  30.788  1.00 27.20           C  
ATOM   7152  N   THR H  76      79.994  44.663  30.436  1.00 32.55           N  
ATOM   7153  CA  THR H  76      80.697  45.944  30.397  1.00 34.27           C  
ATOM   7154  C   THR H  76      81.501  46.037  31.697  1.00 32.72           C  
ATOM   7155  O   THR H  76      80.943  46.078  32.786  1.00 31.82           O  
ATOM   7156  CB  THR H  76      79.709  47.144  30.271  1.00 36.49           C  
ATOM   7157  OG1 THR H  76      78.905  46.989  29.091  1.00 37.88           O  
ATOM   7158  CG2 THR H  76      80.475  48.461  30.173  1.00 36.38           C  
ATOM   7159  N   VAL H  77      82.821  46.048  31.558  1.00 34.91           N  
ATOM   7160  CA  VAL H  77      83.741  46.090  32.689  1.00 34.67           C  
ATOM   7161  C   VAL H  77      84.364  47.457  32.888  1.00 35.01           C  
ATOM   7162  O   VAL H  77      85.053  47.963  32.007  1.00 34.77           O  
ATOM   7163  CB  VAL H  77      84.886  45.068  32.485  1.00 35.36           C  
ATOM   7164  CG1 VAL H  77      85.820  45.067  33.686  1.00 35.09           C  
ATOM   7165  CG2 VAL H  77      84.299  43.679  32.261  1.00 36.36           C  
ATOM   7166  N   TYR H  78      84.118  48.057  34.045  1.00 36.51           N  
ATOM   7167  CA  TYR H  78      84.699  49.354  34.344  1.00 38.62           C  
ATOM   7168  C   TYR H  78      85.857  49.135  35.315  1.00 41.04           C  
ATOM   7169  O   TYR H  78      85.686  48.528  36.373  1.00 40.37           O  
ATOM   7170  CB  TYR H  78      83.658  50.285  34.967  1.00 38.23           C  
ATOM   7171  CG  TYR H  78      82.443  50.530  34.100  1.00 38.19           C  
ATOM   7172  CD1 TYR H  78      81.312  49.713  34.195  1.00 38.08           C  
ATOM   7173  CD2 TYR H  78      82.424  51.578  33.180  1.00 38.27           C  
ATOM   7174  CE1 TYR H  78      80.194  49.938  33.398  1.00 37.96           C  
ATOM   7175  CE2 TYR H  78      81.311  51.814  32.376  1.00 36.98           C  
ATOM   7176  CZ  TYR H  78      80.202  50.994  32.488  1.00 38.99           C  
ATOM   7177  OH  TYR H  78      79.104  51.233  31.692  1.00 39.29           O  
ATOM   7178  N   LEU H  79      87.045  49.595  34.936  1.00 44.56           N  
ATOM   7179  CA  LEU H  79      88.219  49.456  35.792  1.00 47.99           C  
ATOM   7180  C   LEU H  79      88.705  50.835  36.208  1.00 51.94           C  
ATOM   7181  O   LEU H  79      88.372  51.841  35.577  1.00 51.49           O  
ATOM   7182  CB  LEU H  79      89.344  48.724  35.062  1.00 46.40           C  
ATOM   7183  CG  LEU H  79      89.143  47.256  34.677  1.00 48.36           C  
ATOM   7184  CD1 LEU H  79      90.417  46.737  34.018  1.00 48.20           C  
ATOM   7185  CD2 LEU H  79      88.817  46.420  35.908  1.00 48.64           C  
ATOM   7186  N   LYS H  80      89.494  50.878  37.278  1.00 56.67           N  
ATOM   7187  CA  LYS H  80      90.030  52.138  37.777  1.00 60.78           C  
ATOM   7188  C   LYS H  80      91.541  52.228  37.568  1.00 63.38           C  
ATOM   7189  O   LYS H  80      92.277  52.603  38.479  1.00 65.27           O  
ATOM   7190  CB  LYS H  80      89.693  52.299  39.259  1.00 59.95           C  
ATOM   7191  N   ASP H  81      91.994  51.874  36.369  1.00 66.31           N  
ATOM   7192  CA  ASP H  81      93.418  51.926  36.015  1.00 69.74           C  
ATOM   7193  C   ASP H  81      94.336  50.939  36.750  1.00 70.26           C  
ATOM   7194  O   ASP H  81      95.103  51.386  37.633  1.00 70.35           O  
ATOM   7195  CB  ASP H  81      93.951  53.357  36.185  1.00 70.55           C  
ATOM   7196  CG  ASP H  81      93.320  54.330  35.205  1.00 71.99           C  
ATOM   7197  OD1 ASP H  81      93.910  55.407  34.958  1.00 73.10           O  
ATOM   7198  OD2 ASP H  81      92.229  54.014  34.685  1.00 71.48           O  
ATOM   7199  N   PHE H  85      94.732  45.829  37.350  1.00 86.66           N  
ATOM   7200  CA  PHE H  85      95.304  45.949  35.979  1.00 87.53           C  
ATOM   7201  C   PHE H  85      94.296  45.489  34.932  1.00 88.17           C  
ATOM   7202  O   PHE H  85      93.188  45.065  35.268  1.00 87.74           O  
ATOM   7203  CB  PHE H  85      96.581  45.123  35.871  1.00 87.04           C  
ATOM   7204  N   ALA H  86      94.691  45.575  33.664  1.00 88.92           N  
ATOM   7205  CA  ALA H  86      93.828  45.181  32.556  1.00 88.84           C  
ATOM   7206  C   ALA H  86      93.813  43.670  32.364  1.00 89.11           C  
ATOM   7207  O   ALA H  86      93.303  43.168  31.362  1.00 89.26           O  
ATOM   7208  CB  ALA H  86      94.281  45.869  31.267  1.00 88.38           C  
ATOM   7209  N   LYS H  87      94.373  42.947  33.330  1.00 89.69           N  
ATOM   7210  CA  LYS H  87      94.414  41.488  33.269  1.00 89.57           C  
ATOM   7211  C   LYS H  87      93.410  40.871  34.245  1.00 89.26           C  
ATOM   7212  O   LYS H  87      93.741  39.946  34.992  1.00 88.85           O  
ATOM   7213  CB  LYS H  87      95.822  40.992  33.580  1.00 89.85           C  
ATOM   7214  N   MET H  88      92.182  41.392  34.232  1.00 88.44           N  
ATOM   7215  CA  MET H  88      91.122  40.890  35.104  1.00 86.84           C  
ATOM   7216  C   MET H  88      90.579  39.571  34.556  1.00 85.62           C  
ATOM   7217  O   MET H  88      89.545  39.071  34.999  1.00 85.31           O  
ATOM   7218  CB  MET H  88      89.994  41.929  35.234  1.00 86.27           C  
ATOM   7219  CG  MET H  88      89.405  42.445  33.921  1.00 86.40           C  
ATOM   7220  SD  MET H  88      88.436  41.228  32.983  1.00 86.82           S  
ATOM   7221  CE  MET H  88      87.014  41.041  34.057  1.00 86.12           C  
ATOM   7222  N   ASN H  89      91.301  39.015  33.588  1.00 84.41           N  
ATOM   7223  CA  ASN H  89      90.931  37.756  32.959  1.00 83.30           C  
ATOM   7224  C   ASN H  89      91.467  36.586  33.781  1.00 82.72           C  
ATOM   7225  O   ASN H  89      91.872  36.770  34.930  1.00 82.68           O  
ATOM   7226  CB  ASN H  89      91.487  37.720  31.536  1.00 82.79           C  
ATOM   7227  CG  ASN H  89      90.922  38.832  30.672  1.00 82.72           C  
ATOM   7228  OD1 ASN H  89      89.743  38.810  30.317  1.00 82.45           O  
ATOM   7229  ND2 ASN H  89      91.755  39.818  30.344  1.00 80.86           N  
ATOM   7230  N   GLU H  90      91.473  35.392  33.192  1.00 81.53           N  
ATOM   7231  CA  GLU H  90      91.940  34.188  33.879  1.00 80.88           C  
ATOM   7232  C   GLU H  90      90.850  33.769  34.859  1.00 79.81           C  
ATOM   7233  O   GLU H  90      90.323  32.659  34.780  1.00 79.66           O  
ATOM   7234  CB  GLU H  90      93.256  34.465  34.624  1.00 81.81           C  
ATOM   7235  CG  GLU H  90      93.932  33.238  35.249  1.00 83.26           C  
ATOM   7236  CD  GLU H  90      93.386  32.872  36.625  1.00 84.81           C  
ATOM   7237  OE1 GLU H  90      93.878  31.890  37.223  1.00 84.85           O  
ATOM   7238  OE2 GLU H  90      92.472  33.565  37.117  1.00 85.21           O  
ATOM   7239  N   VAL H  91      90.519  34.666  35.782  1.00 78.76           N  
ATOM   7240  CA  VAL H  91      89.471  34.407  36.762  1.00 77.58           C  
ATOM   7241  C   VAL H  91      88.174  34.460  35.981  1.00 76.68           C  
ATOM   7242  O   VAL H  91      87.294  33.616  36.134  1.00 75.77           O  
ATOM   7243  CB  VAL H  91      89.410  35.506  37.850  1.00 77.39           C  
ATOM   7244  CG1 VAL H  91      88.317  35.178  38.857  1.00 76.43           C  
ATOM   7245  CG2 VAL H  91      90.754  35.637  38.540  1.00 77.61           C  
ATOM   7246  N   TYR H  92      88.075  35.479  35.139  1.00 76.87           N  
ATOM   7247  CA  TYR H  92      86.904  35.676  34.313  1.00 77.66           C  
ATOM   7248  C   TYR H  92      86.662  34.420  33.483  1.00 77.15           C  
ATOM   7249  O   TYR H  92      85.519  33.994  33.286  1.00 76.40           O  
ATOM   7250  CB  TYR H  92      87.116  36.867  33.385  1.00 79.34           C  
ATOM   7251  CG  TYR H  92      85.837  37.352  32.759  1.00 83.05           C  
ATOM   7252  CD1 TYR H  92      85.106  38.388  33.335  1.00 83.91           C  
ATOM   7253  CD2 TYR H  92      85.331  36.746  31.610  1.00 84.57           C  
ATOM   7254  CE1 TYR H  92      83.903  38.809  32.783  1.00 85.50           C  
ATOM   7255  CE2 TYR H  92      84.128  37.154  31.054  1.00 85.38           C  
ATOM   7256  CZ  TYR H  92      83.420  38.188  31.640  1.00 86.43           C  
ATOM   7257  OH  TYR H  92      82.232  38.598  31.079  1.00 88.54           O  
ATOM   7258  N   ALA H  93      87.752  33.827  33.006  1.00 76.45           N  
ATOM   7259  CA  ALA H  93      87.688  32.625  32.187  1.00 76.52           C  
ATOM   7260  C   ALA H  93      86.969  31.467  32.873  1.00 76.95           C  
ATOM   7261  O   ALA H  93      86.067  30.859  32.292  1.00 75.93           O  
ATOM   7262  CB  ALA H  93      89.091  32.202  31.787  1.00 76.93           C  
ATOM   7263  N   GLU H  94      87.357  31.155  34.108  1.00 77.60           N  
ATOM   7264  CA  GLU H  94      86.718  30.053  34.815  1.00 78.37           C  
ATOM   7265  C   GLU H  94      85.248  30.330  35.105  1.00 77.52           C  
ATOM   7266  O   GLU H  94      84.512  29.431  35.511  1.00 77.75           O  
ATOM   7267  CB  GLU H  94      87.464  29.718  36.119  1.00 79.92           C  
ATOM   7268  CG  GLU H  94      87.636  30.861  37.119  1.00 81.59           C  
ATOM   7269  CD  GLU H  94      88.014  30.364  38.518  1.00 82.55           C  
ATOM   7270  OE1 GLU H  94      88.436  31.187  39.362  1.00 82.20           O  
ATOM   7271  OE2 GLU H  94      87.876  29.147  38.778  1.00 82.86           O  
ATOM   7272  N   TYR H  95      84.819  31.568  34.881  1.00 76.88           N  
ATOM   7273  CA  TYR H  95      83.433  31.957  35.120  1.00 76.17           C  
ATOM   7274  C   TYR H  95      82.592  31.981  33.852  1.00 75.83           C  
ATOM   7275  O   TYR H  95      81.417  31.615  33.875  1.00 76.13           O  
ATOM   7276  CB  TYR H  95      83.377  33.330  35.790  1.00 76.37           C  
ATOM   7277  CG  TYR H  95      83.423  33.278  37.298  1.00 75.90           C  
ATOM   7278  CD1 TYR H  95      82.337  32.795  38.030  1.00 75.70           C  
ATOM   7279  CD2 TYR H  95      84.543  33.722  37.996  1.00 75.78           C  
ATOM   7280  CE1 TYR H  95      82.366  32.758  39.425  1.00 76.66           C  
ATOM   7281  CE2 TYR H  95      84.584  33.690  39.391  1.00 76.68           C  
ATOM   7282  CZ  TYR H  95      83.493  33.208  40.099  1.00 76.52           C  
ATOM   7283  OH  TYR H  95      83.532  33.181  41.475  1.00 76.86           O  
ATOM   7284  N   PHE H  96      83.183  32.419  32.746  1.00 74.87           N  
ATOM   7285  CA  PHE H  96      82.454  32.467  31.489  1.00 74.54           C  
ATOM   7286  C   PHE H  96      82.901  31.408  30.492  1.00 75.32           C  
ATOM   7287  O   PHE H  96      83.382  31.722  29.401  1.00 75.55           O  
ATOM   7288  CB  PHE H  96      82.558  33.857  30.858  1.00 74.24           C  
ATOM   7289  CG  PHE H  96      81.697  34.882  31.533  1.00 73.21           C  
ATOM   7290  CD1 PHE H  96      82.068  35.428  32.755  1.00 73.08           C  
ATOM   7291  CD2 PHE H  96      80.498  35.273  30.968  1.00 71.84           C  
ATOM   7292  CE1 PHE H  96      81.250  36.338  33.403  1.00 72.11           C  
ATOM   7293  CE2 PHE H  96      79.676  36.179  31.609  1.00 71.84           C  
ATOM   7294  CZ  PHE H  96      80.054  36.716  32.827  1.00 70.92           C  
ATOM   7295  N   GLY H  97      82.739  30.150  30.888  1.00 74.76           N  
ATOM   7296  CA  GLY H  97      83.098  29.043  30.027  1.00 73.99           C  
ATOM   7297  C   GLY H  97      81.817  28.478  29.446  1.00 74.12           C  
ATOM   7298  O   GLY H  97      80.845  28.276  30.174  1.00 74.42           O  
ATOM   7299  N   GLU H  98      81.820  28.235  28.137  1.00 73.83           N  
ATOM   7300  CA  GLU H  98      80.663  27.702  27.416  1.00 73.48           C  
ATOM   7301  C   GLU H  98      79.741  28.847  26.984  1.00 72.70           C  
ATOM   7302  O   GLU H  98      78.621  28.619  26.515  1.00 72.88           O  
ATOM   7303  CB  GLU H  98      79.894  26.697  28.288  1.00 74.59           C  
ATOM   7304  CG  GLU H  98      78.832  25.890  27.547  1.00 76.93           C  
ATOM   7305  CD  GLU H  98      78.084  24.925  28.460  1.00 78.35           C  
ATOM   7306  OE1 GLU H  98      77.248  24.146  27.948  1.00 79.12           O  
ATOM   7307  OE2 GLU H  98      78.330  24.947  29.688  1.00 77.65           O  
ATOM   7308  N   SER H  99      80.230  30.077  27.142  1.00 70.97           N  
ATOM   7309  CA  SER H  99      79.483  31.279  26.775  1.00 68.55           C  
ATOM   7310  C   SER H  99      80.357  32.258  26.010  1.00 67.25           C  
ATOM   7311  O   SER H  99      80.169  32.472  24.811  1.00 67.15           O  
ATOM   7312  CB  SER H  99      78.945  31.980  28.022  1.00 69.91           C  
ATOM   7313  OG  SER H  99      78.444  33.266  27.701  1.00 69.30           O  
ATOM   7314  N   LYS H 100      81.315  32.852  26.717  1.00 64.90           N  
ATOM   7315  CA  LYS H 100      82.226  33.821  26.117  1.00 62.22           C  
ATOM   7316  C   LYS H 100      81.419  34.935  25.456  1.00 59.90           C  
ATOM   7317  O   LYS H 100      81.386  35.047  24.233  1.00 60.60           O  
ATOM   7318  CB  LYS H 100      83.122  33.135  25.088  1.00 61.46           C  
ATOM   7319  N   PRO H 101      80.750  35.771  26.264  1.00 56.74           N  
ATOM   7320  CA  PRO H 101      79.935  36.882  25.761  1.00 53.89           C  
ATOM   7321  C   PRO H 101      80.754  38.029  25.175  1.00 49.94           C  
ATOM   7322  O   PRO H 101      81.978  38.052  25.291  1.00 49.45           O  
ATOM   7323  CB  PRO H 101      79.154  37.312  27.002  1.00 55.05           C  
ATOM   7324  CG  PRO H 101      80.145  37.071  28.099  1.00 56.00           C  
ATOM   7325  CD  PRO H 101      80.684  35.703  27.735  1.00 55.82           C  
ATOM   7326  N   ALA H 102      80.062  38.974  24.547  1.00 46.43           N  
ATOM   7327  CA  ALA H 102      80.696  40.143  23.950  1.00 43.28           C  
ATOM   7328  C   ALA H 102      81.137  41.028  25.096  1.00 41.48           C  
ATOM   7329  O   ALA H 102      80.446  41.110  26.102  1.00 41.57           O  
ATOM   7330  CB  ALA H 102      79.706  40.884  23.074  1.00 44.03           C  
ATOM   7331  N   ARG H 103      82.270  41.703  24.952  1.00 40.16           N  
ATOM   7332  CA  ARG H 103      82.744  42.540  26.041  1.00 39.52           C  
ATOM   7333  C   ARG H 103      83.203  43.944  25.688  1.00 37.89           C  
ATOM   7334  O   ARG H 103      83.686  44.215  24.593  1.00 38.36           O  
ATOM   7335  CB  ARG H 103      83.879  41.833  26.788  1.00 41.37           C  
ATOM   7336  CG  ARG H 103      84.251  42.523  28.087  1.00 42.52           C  
ATOM   7337  CD  ARG H 103      85.542  42.006  28.680  1.00 44.64           C  
ATOM   7338  NE  ARG H 103      86.698  42.391  27.884  1.00 48.20           N  
ATOM   7339  CZ  ARG H 103      87.956  42.252  28.281  1.00 49.18           C  
ATOM   7340  NH1 ARG H 103      88.221  41.733  29.471  1.00 51.09           N  
ATOM   7341  NH2 ARG H 103      88.948  42.642  27.494  1.00 51.68           N  
ATOM   7342  N   VAL H 104      83.040  44.836  26.652  1.00 35.59           N  
ATOM   7343  CA  VAL H 104      83.459  46.214  26.522  1.00 34.17           C  
ATOM   7344  C   VAL H 104      84.222  46.508  27.805  1.00 34.68           C  
ATOM   7345  O   VAL H 104      83.758  46.174  28.891  1.00 33.96           O  
ATOM   7346  CB  VAL H 104      82.248  47.165  26.426  1.00 35.21           C  
ATOM   7347  CG1 VAL H 104      82.699  48.614  26.606  1.00 33.73           C  
ATOM   7348  CG2 VAL H 104      81.562  46.991  25.081  1.00 36.58           C  
ATOM   7349  N   ALA H 105      85.395  47.113  27.690  1.00 34.24           N  
ATOM   7350  CA  ALA H 105      86.162  47.438  28.879  1.00 37.26           C  
ATOM   7351  C   ALA H 105      86.688  48.859  28.800  1.00 38.46           C  
ATOM   7352  O   ALA H 105      87.024  49.352  27.724  1.00 38.23           O  
ATOM   7353  CB  ALA H 105      87.310  46.457  29.056  1.00 36.08           C  
ATOM   7354  N   VAL H 106      86.737  49.522  29.947  1.00 40.32           N  
ATOM   7355  CA  VAL H 106      87.233  50.890  30.013  1.00 42.14           C  
ATOM   7356  C   VAL H 106      87.823  51.123  31.392  1.00 42.49           C  
ATOM   7357  O   VAL H 106      87.518  50.404  32.338  1.00 39.39           O  
ATOM   7358  CB  VAL H 106      86.105  51.946  29.770  1.00 43.21           C  
ATOM   7359  CG1 VAL H 106      85.477  51.737  28.406  1.00 42.58           C  
ATOM   7360  CG2 VAL H 106      85.050  51.856  30.866  1.00 42.40           C  
ATOM   7361  N   GLU H 107      88.672  52.133  31.488  1.00 46.01           N  
ATOM   7362  CA  GLU H 107      89.312  52.481  32.741  1.00 51.54           C  
ATOM   7363  C   GLU H 107      88.858  53.890  33.104  1.00 53.22           C  
ATOM   7364  O   GLU H 107      89.165  54.861  32.412  1.00 53.11           O  
ATOM   7365  CB  GLU H 107      90.833  52.379  32.568  1.00 55.37           C  
ATOM   7366  CG  GLU H 107      91.300  50.927  32.309  1.00 60.31           C  
ATOM   7367  CD  GLU H 107      92.688  50.820  31.676  1.00 63.19           C  
ATOM   7368  OE1 GLU H 107      93.632  51.472  32.178  1.00 64.72           O  
ATOM   7369  OE2 GLU H 107      92.834  50.071  30.680  1.00 64.29           O  
ATOM   7370  N   VAL H 108      88.098  53.987  34.191  1.00 55.08           N  
ATOM   7371  CA  VAL H 108      87.549  55.259  34.632  1.00 56.38           C  
ATOM   7372  C   VAL H 108      88.290  55.974  35.755  1.00 57.45           C  
ATOM   7373  O   VAL H 108      89.244  55.455  36.330  1.00 55.24           O  
ATOM   7374  CB  VAL H 108      86.073  55.086  35.045  1.00 56.87           C  
ATOM   7375  CG1 VAL H 108      85.186  55.077  33.808  1.00 56.40           C  
ATOM   7376  CG2 VAL H 108      85.902  53.783  35.818  1.00 55.33           C  
ATOM   7377  N   SER H 109      87.821  57.183  36.045  1.00 60.14           N  
ATOM   7378  CA  SER H 109      88.389  58.035  37.079  1.00 63.35           C  
ATOM   7379  C   SER H 109      88.279  57.388  38.456  1.00 65.22           C  
ATOM   7380  O   SER H 109      89.238  56.791  38.959  1.00 65.98           O  
ATOM   7381  CB  SER H 109      87.661  59.387  37.090  1.00 63.23           C  
ATOM   7382  OG  SER H 109      87.704  60.004  35.816  1.00 63.45           O  
ATOM   7383  N   ARG H 110      87.100  57.511  39.057  1.00 65.82           N  
ATOM   7384  CA  ARG H 110      86.844  56.951  40.377  1.00 66.19           C  
ATOM   7385  C   ARG H 110      85.623  56.042  40.320  1.00 65.34           C  
ATOM   7386  O   ARG H 110      84.718  56.257  39.514  1.00 65.84           O  
ATOM   7387  CB  ARG H 110      86.629  58.092  41.378  1.00 68.66           C  
ATOM   7388  CG  ARG H 110      86.145  57.672  42.753  1.00 72.80           C  
ATOM   7389  CD  ARG H 110      86.413  58.766  43.781  1.00 76.15           C  
ATOM   7390  NE  ARG H 110      86.044  60.093  43.286  1.00 78.99           N  
ATOM   7391  CZ  ARG H 110      86.159  61.217  43.993  1.00 79.62           C  
ATOM   7392  NH1 ARG H 110      85.800  62.380  43.460  1.00 79.40           N  
ATOM   7393  NH2 ARG H 110      86.630  61.178  45.234  1.00 78.64           N  
ATOM   7394  N   LEU H 111      85.608  55.012  41.162  1.00 63.93           N  
ATOM   7395  CA  LEU H 111      84.484  54.082  41.202  1.00 63.24           C  
ATOM   7396  C   LEU H 111      83.735  54.218  42.524  1.00 64.00           C  
ATOM   7397  O   LEU H 111      84.283  54.716  43.511  1.00 63.38           O  
ATOM   7398  CB  LEU H 111      84.963  52.634  41.028  1.00 59.99           C  
ATOM   7399  CG  LEU H 111      85.525  52.217  39.673  1.00 56.45           C  
ATOM   7400  CD1 LEU H 111      86.023  50.791  39.755  1.00 55.73           C  
ATOM   7401  CD2 LEU H 111      84.450  52.342  38.611  1.00 56.23           C  
ATOM   7402  N   PRO H 112      82.464  53.779  42.556  1.00 64.44           N  
ATOM   7403  CA  PRO H 112      81.629  53.850  43.757  1.00 63.99           C  
ATOM   7404  C   PRO H 112      82.289  53.185  44.958  1.00 64.36           C  
ATOM   7405  O   PRO H 112      82.716  52.037  44.880  1.00 64.51           O  
ATOM   7406  CB  PRO H 112      80.353  53.132  43.328  1.00 64.30           C  
ATOM   7407  CG  PRO H 112      80.272  53.456  41.869  1.00 64.52           C  
ATOM   7408  CD  PRO H 112      81.697  53.237  41.420  1.00 64.29           C  
ATOM   7409  N   LYS H 113      82.362  53.909  46.072  1.00 65.22           N  
ATOM   7410  CA  LYS H 113      82.975  53.381  47.286  1.00 66.14           C  
ATOM   7411  C   LYS H 113      84.405  52.957  46.970  1.00 66.91           C  
ATOM   7412  O   LYS H 113      84.921  51.988  47.527  1.00 67.41           O  
ATOM   7413  CB  LYS H 113      82.169  52.189  47.810  1.00 64.72           C  
ATOM   7414  N   ASP H 114      85.036  53.705  46.070  1.00 67.47           N  
ATOM   7415  CA  ASP H 114      86.399  53.427  45.633  1.00 68.71           C  
ATOM   7416  C   ASP H 114      86.338  52.222  44.692  1.00 67.52           C  
ATOM   7417  O   ASP H 114      86.116  52.395  43.498  1.00 68.99           O  
ATOM   7418  CB  ASP H 114      87.306  53.137  46.835  1.00 72.05           C  
ATOM   7419  CG  ASP H 114      88.753  53.531  46.582  1.00 74.39           C  
ATOM   7420  OD1 ASP H 114      88.992  54.710  46.228  1.00 74.43           O  
ATOM   7421  OD2 ASP H 114      89.643  52.665  46.740  1.00 76.21           O  
ATOM   7422  N   VAL H 115      86.528  51.012  45.217  1.00 64.79           N  
ATOM   7423  CA  VAL H 115      86.444  49.808  44.386  1.00 61.32           C  
ATOM   7424  C   VAL H 115      87.402  49.815  43.182  1.00 59.12           C  
ATOM   7425  O   VAL H 115      87.740  50.874  42.642  1.00 58.87           O  
ATOM   7426  CB  VAL H 115      84.994  49.620  43.873  1.00 61.34           C  
ATOM   7427  CG1 VAL H 115      84.926  48.484  42.890  1.00 61.88           C  
ATOM   7428  CG2 VAL H 115      84.061  49.362  45.045  1.00 61.46           C  
ATOM   7429  N   LEU H 116      87.824  48.628  42.754  1.00 54.87           N  
ATOM   7430  CA  LEU H 116      88.745  48.513  41.624  1.00 50.42           C  
ATOM   7431  C   LEU H 116      88.085  47.997  40.349  1.00 47.89           C  
ATOM   7432  O   LEU H 116      88.719  47.931  39.292  1.00 46.97           O  
ATOM   7433  CB  LEU H 116      89.915  47.600  41.996  1.00 50.24           C  
ATOM   7434  CG  LEU H 116      90.933  48.136  43.008  1.00 50.50           C  
ATOM   7435  CD1 LEU H 116      90.249  48.567  44.298  1.00 51.47           C  
ATOM   7436  CD2 LEU H 116      91.953  47.052  43.290  1.00 51.95           C  
ATOM   7437  N   ILE H 117      86.814  47.628  40.442  1.00 44.72           N  
ATOM   7438  CA  ILE H 117      86.103  47.125  39.279  1.00 41.57           C  
ATOM   7439  C   ILE H 117      84.595  47.112  39.467  1.00 40.18           C  
ATOM   7440  O   ILE H 117      84.087  46.813  40.542  1.00 39.06           O  
ATOM   7441  CB  ILE H 117      86.551  45.688  38.916  1.00 39.92           C  
ATOM   7442  CG1 ILE H 117      85.696  45.155  37.760  1.00 39.83           C  
ATOM   7443  CG2 ILE H 117      86.432  44.794  40.125  1.00 36.38           C  
ATOM   7444  CD1 ILE H 117      86.009  43.733  37.346  1.00 39.18           C  
ATOM   7445  N   GLU H 118      83.894  47.444  38.393  1.00 38.45           N  
ATOM   7446  CA  GLU H 118      82.447  47.459  38.377  1.00 37.65           C  
ATOM   7447  C   GLU H 118      82.029  46.805  37.066  1.00 35.44           C  
ATOM   7448  O   GLU H 118      82.519  47.170  35.995  1.00 33.64           O  
ATOM   7449  CB  GLU H 118      81.921  48.899  38.463  1.00 40.25           C  
ATOM   7450  CG  GLU H 118      80.410  49.011  38.233  1.00 45.46           C  
ATOM   7451  CD  GLU H 118      79.830  50.361  38.635  1.00 49.74           C  
ATOM   7452  OE1 GLU H 118      78.628  50.600  38.365  1.00 52.26           O  
ATOM   7453  OE2 GLU H 118      80.568  51.183  39.224  1.00 52.89           O  
ATOM   7454  N   ILE H 119      81.129  45.833  37.150  1.00 33.74           N  
ATOM   7455  CA  ILE H 119      80.681  45.136  35.955  1.00 31.66           C  
ATOM   7456  C   ILE H 119      79.175  45.137  35.781  1.00 31.90           C  
ATOM   7457  O   ILE H 119      78.433  44.857  36.723  1.00 30.97           O  
ATOM   7458  CB  ILE H 119      81.169  43.670  35.958  1.00 31.89           C  
ATOM   7459  CG1 ILE H 119      82.695  43.631  35.875  1.00 34.04           C  
ATOM   7460  CG2 ILE H 119      80.586  42.915  34.779  1.00 31.30           C  
ATOM   7461  CD1 ILE H 119      83.277  42.240  35.952  1.00 36.14           C  
ATOM   7462  N   GLU H 120      78.735  45.470  34.566  1.00 32.13           N  
ATOM   7463  CA  GLU H 120      77.316  45.468  34.215  1.00 33.16           C  
ATOM   7464  C   GLU H 120      77.184  44.370  33.155  1.00 31.18           C  
ATOM   7465  O   GLU H 120      78.113  44.139  32.388  1.00 32.13           O  
ATOM   7466  CB  GLU H 120      76.871  46.831  33.642  1.00 34.77           C  
ATOM   7467  CG  GLU H 120      76.950  46.954  32.114  1.00 41.87           C  
ATOM   7468  CD  GLU H 120      76.222  48.187  31.548  1.00 46.05           C  
ATOM   7469  OE1 GLU H 120      76.747  49.322  31.660  1.00 45.27           O  
ATOM   7470  OE2 GLU H 120      75.113  48.015  30.989  1.00 48.82           O  
ATOM   7471  N   ALA H 121      76.047  43.687  33.110  1.00 30.11           N  
ATOM   7472  CA  ALA H 121      75.860  42.616  32.131  1.00 30.17           C  
ATOM   7473  C   ALA H 121      74.414  42.422  31.650  1.00 29.86           C  
ATOM   7474  O   ALA H 121      73.459  42.780  32.343  1.00 30.34           O  
ATOM   7475  CB  ALA H 121      76.400  41.294  32.708  1.00 26.32           C  
ATOM   7476  N   ILE H 122      74.276  41.855  30.452  1.00 29.14           N  
ATOM   7477  CA  ILE H 122      72.975  41.556  29.839  1.00 27.01           C  
ATOM   7478  C   ILE H 122      72.974  40.056  29.522  1.00 25.88           C  
ATOM   7479  O   ILE H 122      73.969  39.526  29.033  1.00 24.44           O  
ATOM   7480  CB  ILE H 122      72.751  42.327  28.474  1.00 26.36           C  
ATOM   7481  CG1 ILE H 122      72.828  43.838  28.678  1.00 23.98           C  
ATOM   7482  CG2 ILE H 122      71.370  41.979  27.882  1.00 24.99           C  
ATOM   7483  CD1 ILE H 122      72.737  44.634  27.370  1.00 25.60           C  
ATOM   7484  N   ALA H 123      71.858  39.385  29.792  1.00 26.43           N  
ATOM   7485  CA  ALA H 123      71.732  37.959  29.521  1.00 26.76           C  
ATOM   7486  C   ALA H 123      70.442  37.684  28.737  1.00 30.42           C  
ATOM   7487  O   ALA H 123      69.483  38.455  28.802  1.00 27.48           O  
ATOM   7488  CB  ALA H 123      71.740  37.181  30.818  1.00 25.64           C  
ATOM   7489  N   TYR H 124      70.433  36.569  28.010  1.00 34.43           N  
ATOM   7490  CA  TYR H 124      69.307  36.174  27.173  1.00 37.59           C  
ATOM   7491  C   TYR H 124      68.947  34.700  27.360  1.00 39.55           C  
ATOM   7492  O   TYR H 124      69.817  33.856  27.541  1.00 39.59           O  
ATOM   7493  CB  TYR H 124      69.669  36.423  25.707  1.00 40.05           C  
ATOM   7494  CG  TYR H 124      68.594  36.048  24.712  1.00 45.12           C  
ATOM   7495  CD1 TYR H 124      67.460  36.840  24.553  1.00 47.26           C  
ATOM   7496  CD2 TYR H 124      68.720  34.912  23.914  1.00 46.76           C  
ATOM   7497  CE1 TYR H 124      66.476  36.514  23.622  1.00 49.56           C  
ATOM   7498  CE2 TYR H 124      67.740  34.577  22.976  1.00 49.76           C  
ATOM   7499  CZ  TYR H 124      66.621  35.385  22.835  1.00 49.97           C  
ATOM   7500  OH  TYR H 124      65.657  35.083  21.895  1.00 50.94           O  
ATOM   7501  N   LYS H 125      67.658  34.396  27.297  1.00 43.52           N  
ATOM   7502  CA  LYS H 125      67.185  33.027  27.443  1.00 48.26           C  
ATOM   7503  C   LYS H 125      65.855  32.849  26.707  1.00 51.70           C  
ATOM   7504  O   LYS H 125      64.876  33.524  27.024  1.00 51.75           O  
ATOM   7505  CB  LYS H 125      67.018  32.708  28.926  1.00 49.58           C  
ATOM   7506  CG  LYS H 125      66.552  31.302  29.234  1.00 51.52           C  
ATOM   7507  CD  LYS H 125      66.427  31.088  30.738  1.00 52.88           C  
ATOM   7508  CE  LYS H 125      65.546  32.158  31.376  1.00 52.94           C  
ATOM   7509  NZ  LYS H 125      64.227  32.276  30.694  1.00 54.81           N  
ATOM   7510  N   GLU H 126      65.827  31.950  25.719  1.00 55.82           N  
ATOM   7511  CA  GLU H 126      64.613  31.677  24.939  1.00 60.18           C  
ATOM   7512  C   GLU H 126      63.586  30.816  25.690  1.00 61.29           C  
ATOM   7513  O   GLU H 126      63.465  29.622  25.343  1.00 63.15           O  
ATOM   7514  CB  GLU H 126      64.961  30.982  23.611  1.00 62.06           C  
ATOM   7515  CG  GLU H 126      65.561  31.881  22.534  1.00 65.31           C  
ATOM   7516  CD  GLU H 126      65.626  31.201  21.166  1.00 67.60           C  
ATOM   7517  OE1 GLU H 126      66.156  31.821  20.210  1.00 68.22           O  
ATOM   7518  OE2 GLU H 126      65.145  30.050  21.044  1.00 68.39           O  
ATOM   7519  OXT GLU H 126      62.917  31.334  26.616  1.00 62.10           O  
TER    7520      GLU H 126                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
