
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  152 ( 1170),  selected  152 , name 1vh2_A
# Molecule2: number of CA atoms  184 ( 1504),  selected  184 , name T0427_239_422.pdb
# PARAMETERS: 1vh2_A.T0427_239_422.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    F    10_A      -       -           -
LGA    D    11_A      -       -           -
LGA    L    12_A      -       -           -
LGA    D    13_A      -       -           -
LGA    H    14_A      -       -           -
LGA    T    15_A      -       -           -
LGA    K    16_A      -       -           -
LGA    V    17_A      V     239          3.774
LGA    K    18_A      -       -           -
LGA    A    19_A      -       -           -
LGA    P    20_A      -       -           -
LGA    Y    21_A      -       -           -
LGA    V    22_A      -       -           -
LGA    R    23_A      I     240          4.841
LGA    L    24_A      E     241           #
LGA    A    25_A      E     242          5.228
LGA    G    26_A      R     243          4.623
LGA    V    27_A      T     244          4.879
LGA    K    28_A      E     245          6.097
LGA    T    29_A      R     246          5.625
LGA    T    30_A      E     247          6.213
LGA    P    31_A      V     248          5.209
LGA    K    32_A      L     249          3.075
LGA    G    33_A      A     250           #
LGA    D    34_A      Q     251          2.818
LGA    Q    35_A      S     252          1.802
LGA    I    36_A      K     253          0.927
LGA    S    37_A      L     254          1.567
LGA    K    38_A      N     255          1.508
LGA    Y    39_A      L     256          0.937
LGA    D    40_A      A     257          1.848
LGA    L    41_A      Y     258          3.484
LGA    R    42_A      N     259          4.235
LGA    F    43_A      T     260          5.060
LGA    L    44_A      -       -           -
LGA    Q    45_A      -       -           -
LGA    P    46_A      -       -           -
LGA    N    47_A      -       -           -
LGA    Q    48_A      -       -           -
LGA    G    49_A      D     261          4.474
LGA    A    50_A      I     262          2.835
LGA    I    51_A      Y     263           #
LGA    -       -      Y     264           -
LGA    -       -      G     265           -
LGA    -       -      D     266           -
LGA    -       -      S     267           -
LGA    D    52_A      Y     268          2.848
LGA    P    53_A      Y     269          2.260
LGA    A    54_A      F     270          1.340
LGA    A    55_A      A     271          1.894
LGA    I    56_A      L     272          1.697
LGA    H    57_A      Q     273          1.163
LGA    T    58_A      V     274          0.967
LGA    L    59_A      F     275          1.465
LGA    E    60_A      N     276          1.504
LGA    H    61_A      G     277          0.745
LGA    L    62_A      I     278          0.532
LGA    L    63_A      F     279          0.896
LGA    A    64_A      G     280          1.792
LGA    -       -      G     281           -
LGA    -       -      F     282           -
LGA    -       -      P     283           -
LGA    -       -      X     284           -
LGA    G    65_A      S     285          1.100
LGA    Y    66_A      K     286          0.427
LGA    M    67_A      L     287          1.396
LGA    R    68_A      F     288          2.107
LGA    D    69_A      M     289          2.634
LGA    H    70_A      N     290          2.772
LGA    L    71_A      V     291          1.762
LGA    E    72_A      R     292          3.212
LGA    -       -      E     293           -
LGA    -       -      K     294           -
LGA    -       -      E     295           -
LGA    -       -      X     296           -
LGA    -       -      L     297           -
LGA    -       -      A     298           -
LGA    G    73_A      Y     299          3.123
LGA    V    74_A      Y     300          3.057
LGA    V    75_A      A     301          3.892
LGA    D    76_A      S     302          1.975
LGA    V    77_A      S     303          0.714
LGA    S    78_A      S     304          0.827
LGA    P    79_A      I     305          1.222
LGA    M    80_A      D     306          3.730
LGA    G    81_A      T     307          4.346
LGA    C    82_A      F     308           #
LGA    R    83_A      R     309           #
LGA    T    84_A      G     310          4.606
LGA    G    85_A      F     311          4.202
LGA    M    86_A      M     312          2.115
LGA    Y    87_A      T     313          0.420
LGA    M    88_A      V     314          1.101
LGA    A    89_A      Q     315          1.434
LGA    V    90_A      T     316          1.301
LGA    I    91_A      G     317          1.360
LGA    G    92_A      I     318          2.629
LGA    -       -      D     319           -
LGA    E    93_A      G     320          2.576
LGA    -       -      K     321           -
LGA    P    94_A      N     322           #
LGA    D    95_A      R     323          2.685
LGA    E    96_A      N     324           #
LGA    Q    97_A      Q     325           #
LGA    G    98_A      V     326          3.899
LGA    V    99_A      L     327          1.456
LGA    M   100_A      R     328          3.785
LGA    K   101_A      L     329          3.929
LGA    A   102_A      -       -           -
LGA    F   103_A      I     330          3.053
LGA    E   104_A      S     331          3.573
LGA    A   105_A      T     332          2.877
LGA    A   106_A      E     333          1.888
LGA    L   107_A      L     334          2.880
LGA    K   108_A      E     335          4.537
LGA    D   109_A      N     336          4.157
LGA    T   110_A      I     337          2.898
LGA    A   111_A      R     338           #
LGA    -       -      L     339           -
LGA    -       -      G     340           -
LGA    G   112_A      K     341          2.871
LGA    H   113_A      I     342          2.273
LGA    D   114_A      R     343           #
LGA    Q   115_A      E     344          1.706
LGA    P   116_A      L     345           #
LGA    -       -      E     346           -
LGA    -       -      I     347           -
LGA    I   117_A      E     348          3.247
LGA    P   118_A      Q     349          1.792
LGA    -       -      T     350           -
LGA    -       -      K     351           -
LGA    G   119_A      A     352          3.927
LGA    V   120_A      M     353          3.047
LGA    S   121_A      L     354           #
LGA    E   122_A      K     355           #
LGA    L   123_A      N     356          3.507
LGA    E   124_A      -       -           -
LGA    C   125_A      Q     357          2.136
LGA    G   126_A      Y     358          3.047
LGA    N   127_A      -       -           -
LGA    Y   128_A      I     359           #
LGA    -       -      L     360           -
LGA    -       -      A     361           -
LGA    -       -      L     362           -
LGA    -       -      D     363           -
LGA    -       -      N     364           -
LGA    -       -      A     365           -
LGA    -       -      G     366           -
LGA    -       -      A     367           -
LGA    -       -      W     368           -
LGA    -       -      L     369           -
LGA    -       -      E     370           -
LGA    -       -      K     371           -
LGA    -       -      E     372           -
LGA    -       -      Y     373           -
LGA    -       -      L     374           -
LGA    -       -      N     375           -
LGA    -       -      E     376           -
LGA    -       -      L     377           -
LGA    -       -      M     378           -
LGA    -       -      P     379           -
LGA    -       -      Q     380           -
LGA    -       -      T     381           -
LGA    -       -      M     382           -
LGA    -       -      L     383           -
LGA    -       -      T     384           -
LGA    -       -      A     385           -
LGA    -       -      E     386           -
LGA    -       -      E     387           -
LGA    R   129_A      W     388          3.462
LGA    D   130_A      I     389           #
LGA    -       -      A     390           -
LGA    -       -      R     391           -
LGA    H   131_A      I     392          2.829
LGA    -       -      N     393           -
LGA    D   132_A      A     394           #
LGA    L   133_A      V     395          3.045
LGA    A   134_A      T     396          2.244
LGA    -       -      I     397           -
LGA    A   135_A      P     398           #
LGA    A   136_A      E     399          4.271
LGA    R   137_A      I     400          2.128
LGA    Q   138_A      Q     401          2.586
LGA    H   139_A      E     402          1.990
LGA    A   140_A      V     403          5.349
LGA    R   141_A      A     404           #
LGA    D   142_A      K     405          2.994
LGA    V   143_A      -       -           -
LGA    L   144_A      -       -           -
LGA    D   145_A      -       -           -
LGA    Q   146_A      R     406           #
LGA    G   147_A      L     407           -
LGA    L   148_A      E     408           #
LGA    K   149_A      -       -           -
LGA    V   150_A      -       -           -
LGA    Q   151_A      L     409           #
LGA    E   152_A      Q     410           #
LGA    T   153_A      A     411           #
LGA    I   154_A      I     412           -
LGA    L   155_A      F     413           -
LGA    L   156_A      F     414           -
LGA    E   157_A      L     415           -
LGA    R   158_A      E     416           -
LGA    -       -      G     417           -
LGA    -       -      E     418           -
LGA    -       -      T     419           -
LGA    -       -      E     420           -
LGA    -       -      N     421           -
LGA    -       -      D     422           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  152  184    5.0     95    3.07     6.32     31.865     2.998

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.996028 * X  +  -0.028010 * Y  +   0.084518 * Z  +  37.700699
  Y_new =  -0.041730 * X  +   0.985372 * Y  +  -0.165228 * Z  +  60.267860
  Z_new =  -0.078654 * X  +  -0.168099 * Y  +  -0.982627 * Z  +  37.981247 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.972162    0.169431  [ DEG:  -170.2923      9.7077 ]
  Theta =   0.078735    3.062858  [ DEG:     4.5112    175.4888 ]
  Phi   =  -3.099720    0.041872  [ DEG:  -177.6009      2.3991 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1vh2_A                                        
REMARK     2: T0427_239_422.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1vh2_A.T0427_239_422.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  152  184   5.0   95   3.07    6.32  31.865
REMARK  ---------------------------------------------------------- 
MOLECULE 1vh2_A
HEADER    HYDROLASE                               01-DEC-03   1VH2              
TITLE     CRYSTAL STRUCTURE OF A AUTOINDUCER-2 SYNTHESIS PROTEIN                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: S-RIBOSYLHOMOCYSTEINASE;                                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: AUTOINDUCER-2 PRODUCTION PROTEIN LUXS, AI-2                 
COMPND   5 SYNTHESIS PROTEIN;                                                   
COMPND   6 EC: 3.13.1.-;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DEINOCOCCUS RADIODURANS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: LUXS, DR2387;                                                  
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    STRUCTURAL GENOMICS                                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    STRUCTURAL GENOMIX                                                    
REVDAT   2   30-AUG-05 1VH2    1       JRNL                                     
REVDAT   1   30-DEC-03 1VH2    0                                                
JRNL        AUTH   J.BADGER,J.M.SAUDER,J.M.ADAMS,S.ANTONYSAMY,K.BAIN,           
JRNL        AUTH 2 M.G.BERGSEID,S.G.BUCHANAN,M.D.BUCHANAN,Y.BATIYENKO,          
JRNL        AUTH 3 J.A.CHRISTOPHER,S.EMTAGE,A.EROSHKINA,I.FEIL,                 
JRNL        AUTH 4 E.B.FURLONG,K.S.GAJIWALA,X.GAO,D.HE,J.HENDLE,                
JRNL        AUTH 5 A.HUBER,K.HODA,P.KEARINS,C.KISSINGER,B.LAUBERT,              
JRNL        AUTH 6 H.A.LEWIS,J.LIN,K.LOOMIS,D.LORIMER,G.LOUIE,                  
JRNL        AUTH 7 M.MALETIC,C.D.MARSH,I.MILLER,J.MOLINARI,                     
JRNL        AUTH 8 H.J.MULLER-DIECKMANN,J.M.NEWMAN,B.W.NOLAND,                  
JRNL        AUTH 9 B.PAGARIGAN,F.PARK,T.S.PEAT,K.W.POST,S.RADOJICIC,            
JRNL        AUTH10 A.RAMOS,R.ROMERO,M.E.RUTTER,W.E.SANDERSON,                   
JRNL        AUTH11 K.D.SCHWINN,J.TRESSER,J.WINHOVEN,T.A.WRIGHT,L.WU,            
JRNL        AUTH12 J.XU,T.J.HARRIS                                              
JRNL        TITL   STRUCTURAL ANALYSIS OF A SET OF PROTEINS RESULTING           
JRNL        TITL 2 FROM A BACTERIAL GENOMICS PROJECT                            
JRNL        REF    PROTEINS                      V.  60   787 2005              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1VH2 A    1   158  UNP    Q9RRU8   LUXS_DEIRA       1    158             
SEQRES   1 A  166  MET PRO ASP MET ALA ASN VAL GLU SER PHE ASP LEU ASP          
SEQRES   2 A  166  HIS THR LYS VAL LYS ALA PRO TYR VAL ARG LEU ALA GLY          
SEQRES   3 A  166  VAL LYS THR THR PRO LYS GLY ASP GLN ILE SER LYS TYR          
SEQRES   4 A  166  ASP LEU ARG PHE LEU GLN PRO ASN GLN GLY ALA ILE ASP          
SEQRES   5 A  166  PRO ALA ALA ILE HIS THR LEU GLU HIS LEU LEU ALA GLY          
SEQRES   6 A  166  TYR MET ARG ASP HIS LEU GLU GLY VAL VAL ASP VAL SER          
SEQRES   7 A  166  PRO MET GLY CYS ARG THR GLY MET TYR MET ALA VAL ILE          
SEQRES   8 A  166  GLY GLU PRO ASP GLU GLN GLY VAL MET LYS ALA PHE GLU          
SEQRES   9 A  166  ALA ALA LEU LYS ASP THR ALA GLY HIS ASP GLN PRO ILE          
SEQRES  10 A  166  PRO GLY VAL SER GLU LEU GLU CYS GLY ASN TYR ARG ASP          
SEQRES  11 A  166  HIS ASP LEU ALA ALA ALA ARG GLN HIS ALA ARG ASP VAL          
SEQRES  12 A  166  LEU ASP GLN GLY LEU LYS VAL GLN GLU THR ILE LEU LEU          
SEQRES  13 A  166  GLU ARG GLY SER HIS HIS HIS HIS HIS HIS                      
HET     ZN      1       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   2   ZN    ZN 2+                                                        
FORMUL   3  HOH   *80(H2 O)                                                     
CRYST1   50.820   69.710   49.860  90.00 112.09  90.00 C 1 2 1       4          
ATOM      1  N   VAL A   7       9.140  29.478  18.905  1.00  8.76           N  
ATOM      2  CA  VAL A   7       9.908  29.317  20.181  1.00 15.62           C  
ATOM      3  C   VAL A   7      11.319  29.865  20.038  1.00 15.00           C  
ATOM      4  O   VAL A   7      12.005  30.108  21.039  1.00 14.81           O  
ATOM      5  CB  VAL A   7      10.011  27.825  20.608  1.00 19.22           C  
ATOM      6  CG1 VAL A   7       8.629  27.195  20.593  1.00 35.67           C  
ATOM      7  CG2 VAL A   7      10.956  27.060  19.683  1.00 19.68           C  
ATOM      8  N   GLU A   8      11.754  30.064  18.795  1.00 10.24           N  
ATOM      9  CA  GLU A   8      13.102  30.580  18.563  1.00 12.90           C  
ATOM     10  C   GLU A   8      13.176  32.100  18.691  1.00 12.86           C  
ATOM     11  O   GLU A   8      14.264  32.668  18.746  1.00  9.02           O  
ATOM     12  CB  GLU A   8      13.610  30.138  17.191  1.00 12.88           C  
ATOM     13  CG  GLU A   8      13.630  28.633  17.033  1.00 13.03           C  
ATOM     14  CD  GLU A   8      14.391  28.160  15.796  1.00 13.30           C  
ATOM     15  OE1 GLU A   8      14.290  26.955  15.473  1.00 12.37           O  
ATOM     16  OE2 GLU A   8      15.092  28.976  15.156  1.00 10.15           O  
ATOM     17  N   SER A   9      12.017  32.755  18.735  1.00  8.19           N  
ATOM     18  CA  SER A   9      11.957  34.208  18.889  1.00 13.95           C  
ATOM     19  C   SER A   9      10.548  34.623  19.318  1.00 18.74           C  
ATOM     20  O   SER A   9       9.665  34.846  18.485  1.00 13.06           O  
ATOM     21  CB  SER A   9      12.341  34.902  17.579  1.00 19.42           C  
ATOM     22  OG  SER A   9      11.461  34.528  16.541  1.00 41.28           O  
ATOM     23  N   PHE A  10      10.353  34.704  20.631  1.00 13.11           N  
ATOM     24  CA  PHE A  10       9.073  35.062  21.221  1.00  7.99           C  
ATOM     25  C   PHE A  10       8.535  36.362  20.647  1.00 15.47           C  
ATOM     26  O   PHE A  10       9.272  37.348  20.493  1.00  9.52           O  
ATOM     27  CB  PHE A  10       9.208  35.191  22.738  1.00  7.66           C  
ATOM     28  CG  PHE A  10       9.850  33.999  23.400  1.00 12.56           C  
ATOM     29  CD1 PHE A  10      10.728  34.181  24.472  1.00  9.50           C  
ATOM     30  CD2 PHE A  10       9.577  32.703  22.968  1.00 12.70           C  
ATOM     31  CE1 PHE A  10      11.320  33.088  25.110  1.00 12.07           C  
ATOM     32  CE2 PHE A  10      10.160  31.594  23.597  1.00 14.44           C  
ATOM     33  CZ  PHE A  10      11.037  31.790  24.671  1.00 19.52           C  
ATOM     34  N   ASP A  11       7.237  36.351  20.348  1.00 10.78           N  
ATOM     35  CA  ASP A  11       6.530  37.499  19.766  1.00  9.23           C  
ATOM     36  C   ASP A  11       6.220  38.540  20.852  1.00  9.05           C  
ATOM     37  O   ASP A  11       5.074  38.738  21.249  1.00 10.55           O  
ATOM     38  CB  ASP A  11       5.244  36.985  19.105  1.00 16.84           C  
ATOM     39  CG  ASP A  11       4.532  38.042  18.291  1.00 17.88           C  
ATOM     40  OD1 ASP A  11       5.202  38.974  17.802  1.00 14.99           O  
ATOM     41  OD2 ASP A  11       3.298  37.921  18.125  1.00 15.34           O  
ATOM     42  N   LEU A  12       7.260  39.229  21.299  1.00  5.51           N  
ATOM     43  CA  LEU A  12       7.140  40.216  22.372  1.00  7.95           C  
ATOM     44  C   LEU A  12       6.336  41.500  22.131  1.00  7.50           C  
ATOM     45  O   LEU A  12       6.448  42.142  21.083  1.00  8.30           O  
ATOM     46  CB  LEU A  12       8.545  40.627  22.820  1.00  7.80           C  
ATOM     47  CG  LEU A  12       8.619  41.717  23.896  1.00  9.22           C  
ATOM     48  CD1 LEU A  12       8.216  41.140  25.251  1.00 14.59           C  
ATOM     49  CD2 LEU A  12      10.051  42.247  23.965  1.00  8.61           C  
ATOM     50  N   ASP A  13       5.539  41.883  23.122  1.00  9.42           N  
ATOM     51  CA  ASP A  13       4.807  43.146  23.046  1.00 10.05           C  
ATOM     52  C   ASP A  13       5.773  44.153  23.695  1.00  8.83           C  
ATOM     53  O   ASP A  13       5.912  44.195  24.925  1.00  6.14           O  
ATOM     54  CB  ASP A  13       3.513  43.077  23.855  1.00  8.75           C  
ATOM     55  CG  ASP A  13       2.684  44.340  23.722  1.00 17.26           C  
ATOM     56  OD1 ASP A  13       3.253  45.393  23.377  1.00  7.81           O  
ATOM     57  OD2 ASP A  13       1.466  44.278  23.972  1.00 15.56           O  
ATOM     58  N   HIS A  14       6.442  44.949  22.867  1.00  8.60           N  
ATOM     59  CA  HIS A  14       7.420  45.923  23.337  1.00 11.48           C  
ATOM     60  C   HIS A  14       6.856  47.061  24.203  1.00  9.05           C  
ATOM     61  O   HIS A  14       7.618  47.752  24.871  1.00 10.20           O  
ATOM     62  CB  HIS A  14       8.172  46.536  22.143  1.00 11.05           C  
ATOM     63  CG  HIS A  14       9.082  45.577  21.430  1.00 10.09           C  
ATOM     64  ND1 HIS A  14       8.621  44.475  20.750  1.00 10.61           N  
ATOM     65  CD2 HIS A  14      10.432  45.556  21.308  1.00  6.86           C  
ATOM     66  CE1 HIS A  14       9.642  43.811  20.240  1.00 14.01           C  
ATOM     67  NE2 HIS A  14      10.755  44.448  20.563  1.00 11.68           N  
ATOM     68  N   THR A  15       5.539  47.261  24.186  1.00 13.70           N  
ATOM     69  CA  THR A  15       4.932  48.331  24.981  1.00 14.44           C  
ATOM     70  C   THR A  15       4.706  47.914  26.430  1.00 18.20           C  
ATOM     71  O   THR A  15       4.403  48.753  27.282  1.00 11.55           O  
ATOM     72  CB  THR A  15       3.535  48.760  24.436  1.00 14.04           C  
ATOM     73  OG1 THR A  15       2.574  47.714  24.697  1.00  8.18           O  
ATOM     74  CG2 THR A  15       3.606  49.027  22.925  1.00 11.92           C  
ATOM     75  N   LYS A  16       4.859  46.626  26.711  1.00 11.15           N  
ATOM     76  CA  LYS A  16       4.593  46.121  28.051  1.00  9.19           C  
ATOM     77  C   LYS A  16       5.787  45.818  28.954  1.00 16.64           C  
ATOM     78  O   LYS A  16       5.598  45.459  30.115  1.00 13.64           O  
ATOM     79  CB  LYS A  16       3.696  44.885  27.933  1.00 11.52           C  
ATOM     80  CG  LYS A  16       2.436  45.152  27.099  1.00 11.32           C  
ATOM     81  CD  LYS A  16       1.251  44.313  27.579  1.00 24.18           C  
ATOM     82  CE  LYS A  16      -0.074  44.805  26.973  1.00 21.38           C  
ATOM     83  NZ  LYS A  16      -0.431  46.207  27.385  1.00 20.40           N  
ATOM     84  N   VAL A  17       7.006  45.982  28.443  1.00  7.24           N  
ATOM     85  CA  VAL A  17       8.199  45.706  29.241  1.00  7.80           C  
ATOM     86  C   VAL A  17       8.663  46.925  30.035  1.00 11.81           C  
ATOM     87  O   VAL A  17       8.224  48.052  29.784  1.00  8.85           O  
ATOM     88  CB  VAL A  17       9.361  45.211  28.356  1.00  5.56           C  
ATOM     89  CG1 VAL A  17       8.897  43.984  27.543  1.00 10.42           C  
ATOM     90  CG2 VAL A  17       9.841  46.349  27.421  1.00  2.00           C  
ATOM     91  N   LYS A  18       9.553  46.688  30.993  1.00  8.94           N  
ATOM     92  CA  LYS A  18      10.066  47.762  31.842  1.00 11.09           C  
ATOM     93  C   LYS A  18      11.581  47.717  31.859  1.00 10.23           C  
ATOM     94  O   LYS A  18      12.159  46.976  32.641  1.00  7.83           O  
ATOM     95  CB  LYS A  18       9.559  47.595  33.281  1.00  5.62           C  
ATOM     96  CG  LYS A  18       8.063  47.373  33.408  1.00 10.25           C  
ATOM     97  CD  LYS A  18       7.283  48.594  32.940  1.00  7.41           C  
ATOM     98  CE  LYS A  18       5.786  48.387  33.132  1.00 17.80           C  
ATOM     99  NZ  LYS A  18       5.059  49.620  32.750  1.00 10.04           N  
ATOM    100  N   ALA A  19      12.219  48.499  30.994  1.00 10.04           N  
ATOM    101  CA  ALA A  19      13.679  48.534  30.932  1.00  8.43           C  
ATOM    102  C   ALA A  19      14.241  49.278  32.151  1.00 14.53           C  
ATOM    103  O   ALA A  19      13.554  50.112  32.749  1.00  9.26           O  
ATOM    104  CB  ALA A  19      14.126  49.231  29.657  1.00 12.08           C  
ATOM    105  N   PRO A  20      15.499  48.985  32.531  1.00 10.66           N  
ATOM    106  CA  PRO A  20      16.367  48.008  31.867  1.00  4.26           C  
ATOM    107  C   PRO A  20      16.070  46.602  32.380  1.00 11.12           C  
ATOM    108  O   PRO A  20      15.566  46.440  33.490  1.00 11.03           O  
ATOM    109  CB  PRO A  20      17.756  48.482  32.248  1.00 11.49           C  
ATOM    110  CG  PRO A  20      17.545  48.923  33.692  1.00  7.64           C  
ATOM    111  CD  PRO A  20      16.217  49.669  33.627  1.00  9.76           C  
ATOM    112  N   TYR A  21      16.378  45.584  31.581  1.00  4.26           N  
ATOM    113  CA  TYR A  21      16.108  44.225  32.016  1.00  4.94           C  
ATOM    114  C   TYR A  21      16.893  43.211  31.226  1.00  8.02           C  
ATOM    115  O   TYR A  21      17.587  43.552  30.257  1.00  8.94           O  
ATOM    116  CB  TYR A  21      14.602  43.917  31.866  1.00  2.00           C  
ATOM    117  CG  TYR A  21      14.109  43.943  30.425  1.00  3.70           C  
ATOM    118  CD1 TYR A  21      14.495  42.951  29.509  1.00  4.30           C  
ATOM    119  CD2 TYR A  21      13.276  44.972  29.969  1.00  5.93           C  
ATOM    120  CE1 TYR A  21      14.066  42.986  28.171  1.00  4.09           C  
ATOM    121  CE2 TYR A  21      12.838  45.021  28.629  1.00  6.09           C  
ATOM    122  CZ  TYR A  21      13.240  44.024  27.739  1.00  7.27           C  
ATOM    123  OH  TYR A  21      12.851  44.079  26.413  1.00  9.12           O  
ATOM    124  N   VAL A  22      16.785  41.961  31.666  1.00  8.89           N  
ATOM    125  CA  VAL A  22      17.384  40.820  30.981  1.00  6.84           C  
ATOM    126  C   VAL A  22      16.151  39.945  30.710  1.00  7.03           C  
ATOM    127  O   VAL A  22      15.290  39.790  31.592  1.00  4.40           O  
ATOM    128  CB  VAL A  22      18.395  40.049  31.875  1.00  8.85           C  
ATOM    129  CG1 VAL A  22      18.748  38.726  31.238  1.00 10.53           C  
ATOM    130  CG2 VAL A  22      19.683  40.868  32.049  1.00  5.76           C  
ATOM    131  N   ARG A  23      16.051  39.383  29.504  1.00  7.34           N  
ATOM    132  CA  ARG A  23      14.895  38.556  29.150  1.00  3.48           C  
ATOM    133  C   ARG A  23      15.233  37.467  28.137  1.00  7.64           C  
ATOM    134  O   ARG A  23      15.899  37.733  27.140  1.00  7.91           O  
ATOM    135  CB  ARG A  23      13.785  39.455  28.579  1.00  3.95           C  
ATOM    136  CG  ARG A  23      12.522  38.732  28.064  1.00 11.97           C  
ATOM    137  CD  ARG A  23      11.626  39.700  27.267  1.00  7.69           C  
ATOM    138  NE  ARG A  23      12.211  40.065  25.973  1.00  4.15           N  
ATOM    139  CZ  ARG A  23      12.040  39.378  24.840  1.00 10.21           C  
ATOM    140  NH1 ARG A  23      11.293  38.277  24.827  1.00  5.87           N  
ATOM    141  NH2 ARG A  23      12.620  39.793  23.711  1.00  3.01           N  
ATOM    142  N   LEU A  24      14.794  36.237  28.393  1.00  7.50           N  
ATOM    143  CA  LEU A  24      15.029  35.149  27.435  1.00  9.28           C  
ATOM    144  C   LEU A  24      14.174  35.506  26.223  1.00  7.00           C  
ATOM    145  O   LEU A  24      12.962  35.662  26.345  1.00  5.65           O  
ATOM    146  CB  LEU A  24      14.565  33.804  28.010  1.00 14.65           C  
ATOM    147  CG  LEU A  24      14.696  32.595  27.077  1.00 10.87           C  
ATOM    148  CD1 LEU A  24      16.145  32.177  27.002  1.00  2.00           C  
ATOM    149  CD2 LEU A  24      13.828  31.433  27.605  1.00 10.75           C  
ATOM    150  N   ALA A  25      14.804  35.646  25.058  1.00  6.47           N  
ATOM    151  CA  ALA A  25      14.081  36.035  23.851  1.00  6.42           C  
ATOM    152  C   ALA A  25      13.691  34.876  22.942  1.00 10.39           C  
ATOM    153  O   ALA A  25      12.870  35.041  22.030  1.00  5.94           O  
ATOM    154  CB  ALA A  25      14.898  37.035  23.074  1.00  5.37           C  
ATOM    155  N   GLY A  26      14.294  33.717  23.183  1.00 10.95           N  
ATOM    156  CA  GLY A  26      13.990  32.545  22.387  1.00  7.31           C  
ATOM    157  C   GLY A  26      15.039  31.475  22.617  1.00  7.14           C  
ATOM    158  O   GLY A  26      16.093  31.737  23.204  1.00  2.12           O  
ATOM    159  N   VAL A  27      14.762  30.270  22.149  1.00  6.42           N  
ATOM    160  CA  VAL A  27      15.695  29.162  22.316  1.00  4.51           C  
ATOM    161  C   VAL A  27      15.697  28.347  21.039  1.00  6.10           C  
ATOM    162  O   VAL A  27      14.634  28.023  20.514  1.00  5.87           O  
ATOM    163  CB  VAL A  27      15.262  28.214  23.466  1.00 19.00           C  
ATOM    164  CG1 VAL A  27      16.193  27.010  23.524  1.00 17.33           C  
ATOM    165  CG2 VAL A  27      15.272  28.950  24.794  1.00 14.63           C  
ATOM    166  N   LYS A  28      16.879  28.042  20.523  1.00  7.22           N  
ATOM    167  CA  LYS A  28      16.958  27.218  19.330  1.00  7.85           C  
ATOM    168  C   LYS A  28      17.669  25.949  19.751  1.00  9.34           C  
ATOM    169  O   LYS A  28      18.707  26.004  20.414  1.00 10.31           O  
ATOM    170  CB  LYS A  28      17.732  27.910  18.197  1.00  5.49           C  
ATOM    171  CG  LYS A  28      17.670  27.122  16.862  1.00  4.59           C  
ATOM    172  CD  LYS A  28      18.205  27.921  15.675  1.00  7.13           C  
ATOM    173  CE  LYS A  28      18.253  27.087  14.392  1.00  7.33           C  
ATOM    174  NZ  LYS A  28      16.897  26.667  13.960  1.00 12.26           N  
ATOM    175  N   THR A  29      17.093  24.808  19.390  1.00 10.49           N  
ATOM    176  CA  THR A  29      17.680  23.517  19.739  1.00 11.09           C  
ATOM    177  C   THR A  29      18.539  23.050  18.573  1.00  8.00           C  
ATOM    178  O   THR A  29      18.123  23.122  17.419  1.00  8.96           O  
ATOM    179  CB  THR A  29      16.581  22.459  20.030  1.00  9.96           C  
ATOM    180  OG1 THR A  29      15.687  22.958  21.036  1.00 15.85           O  
ATOM    181  CG2 THR A  29      17.210  21.142  20.547  1.00 10.81           C  
ATOM    182  N   THR A  30      19.747  22.585  18.871  1.00  7.76           N  
ATOM    183  CA  THR A  30      20.644  22.100  17.835  1.00  2.00           C  
ATOM    184  C   THR A  30      20.324  20.629  17.520  1.00  7.38           C  
ATOM    185  O   THR A  30      19.691  19.936  18.313  1.00  8.56           O  
ATOM    186  CB  THR A  30      22.103  22.161  18.293  1.00  6.29           C  
ATOM    187  OG1 THR A  30      22.304  21.177  19.314  1.00  9.60           O  
ATOM    188  CG2 THR A  30      22.451  23.543  18.848  1.00 11.24           C  
ATOM    189  N   PRO A  31      20.790  20.128  16.370  1.00  7.61           N  
ATOM    190  CA  PRO A  31      20.544  18.739  15.961  1.00  9.41           C  
ATOM    191  C   PRO A  31      20.862  17.666  17.008  1.00 11.73           C  
ATOM    192  O   PRO A  31      20.164  16.660  17.084  1.00  6.78           O  
ATOM    193  CB  PRO A  31      21.406  18.595  14.711  1.00 11.81           C  
ATOM    194  CG  PRO A  31      21.312  19.953  14.094  1.00  8.33           C  
ATOM    195  CD  PRO A  31      21.462  20.880  15.295  1.00 13.58           C  
ATOM    196  N   LYS A  32      21.912  17.883  17.802  1.00 15.50           N  
ATOM    197  CA  LYS A  32      22.322  16.923  18.837  1.00 15.64           C  
ATOM    198  C   LYS A  32      21.567  17.117  20.126  1.00 14.04           C  
ATOM    199  O   LYS A  32      21.730  16.344  21.060  1.00 15.91           O  
ATOM    200  CB  LYS A  32      23.817  17.046  19.155  1.00 15.91           C  
ATOM    201  CG  LYS A  32      24.735  16.854  17.987  1.00 22.81           C  
ATOM    202  CD  LYS A  32      24.579  15.494  17.374  1.00 32.82           C  
ATOM    203  CE  LYS A  32      25.480  15.394  16.164  1.00 36.03           C  
ATOM    204  NZ  LYS A  32      26.850  15.824  16.527  1.00 33.85           N  
ATOM    205  N   GLY A  33      20.763  18.172  20.204  1.00 11.12           N  
ATOM    206  CA  GLY A  33      19.998  18.382  21.417  1.00  9.11           C  
ATOM    207  C   GLY A  33      20.504  19.430  22.388  1.00 13.82           C  
ATOM    208  O   GLY A  33      20.045  19.481  23.525  1.00  8.86           O  
ATOM    209  N   ASP A  34      21.452  20.263  21.967  1.00 11.22           N  
ATOM    210  CA  ASP A  34      21.938  21.323  22.850  1.00  8.68           C  
ATOM    211  C   ASP A  34      20.980  22.501  22.685  1.00 14.12           C  
ATOM    212  O   ASP A  34      20.200  22.529  21.725  1.00  9.22           O  
ATOM    213  CB  ASP A  34      23.350  21.758  22.451  1.00  9.45           C  
ATOM    214  CG  ASP A  34      24.429  20.952  23.144  1.00 12.90           C  
ATOM    215  OD1 ASP A  34      24.309  20.740  24.366  1.00 22.80           O  
ATOM    216  OD2 ASP A  34      25.402  20.547  22.476  1.00 16.18           O  
ATOM    217  N   GLN A  35      21.011  23.463  23.603  1.00  5.51           N  
ATOM    218  CA  GLN A  35      20.128  24.618  23.459  1.00  6.06           C  
ATOM    219  C   GLN A  35      20.932  25.904  23.315  1.00 11.43           C  
ATOM    220  O   GLN A  35      21.962  26.093  23.972  1.00  5.24           O  
ATOM    221  CB  GLN A  35      19.199  24.772  24.667  1.00  9.73           C  
ATOM    222  CG  GLN A  35      18.290  23.588  24.948  1.00 24.54           C  
ATOM    223  CD  GLN A  35      17.236  23.905  26.011  1.00 28.53           C  
ATOM    224  OE1 GLN A  35      16.628  23.003  26.586  1.00 34.10           O  
ATOM    225  NE2 GLN A  35      17.012  25.190  26.262  1.00 32.36           N  
ATOM    226  N   ILE A  36      20.469  26.777  22.430  1.00  7.76           N  
ATOM    227  CA  ILE A  36      21.106  28.068  22.247  1.00  6.68           C  
ATOM    228  C   ILE A  36      20.083  29.055  22.795  1.00  6.32           C  
ATOM    229  O   ILE A  36      19.013  29.245  22.216  1.00  7.89           O  
ATOM    230  CB  ILE A  36      21.388  28.340  20.772  1.00  7.92           C  
ATOM    231  CG1 ILE A  36      22.363  27.283  20.242  1.00  4.86           C  
ATOM    232  CG2 ILE A  36      21.979  29.734  20.614  1.00 12.66           C  
ATOM    233  CD1 ILE A  36      22.618  27.375  18.758  1.00 24.16           C  
ATOM    234  N   SER A  37      20.378  29.633  23.954  1.00  3.58           N  
ATOM    235  CA  SER A  37      19.449  30.564  24.567  1.00  4.60           C  
ATOM    236  C   SER A  37      19.747  31.979  24.107  1.00  8.50           C  
ATOM    237  O   SER A  37      20.892  32.432  24.185  1.00  9.71           O  
ATOM    238  CB  SER A  37      19.540  30.472  26.094  1.00  9.74           C  
ATOM    239  OG  SER A  37      18.983  29.250  26.580  1.00  7.52           O  
ATOM    240  N   LYS A  38      18.717  32.665  23.617  1.00  6.52           N  
ATOM    241  CA  LYS A  38      18.857  34.044  23.140  1.00  9.33           C  
ATOM    242  C   LYS A  38      18.393  35.005  24.220  1.00  4.14           C  
ATOM    243  O   LYS A  38      17.339  34.807  24.827  1.00  7.57           O  
ATOM    244  CB  LYS A  38      18.005  34.265  21.894  1.00 10.01           C  
ATOM    245  CG  LYS A  38      18.372  33.394  20.703  1.00  2.50           C  
ATOM    246  CD  LYS A  38      17.279  33.524  19.655  1.00  5.29           C  
ATOM    247  CE  LYS A  38      17.606  32.820  18.352  1.00  4.51           C  
ATOM    248  NZ  LYS A  38      16.597  33.185  17.288  1.00  8.24           N  
ATOM    249  N   TYR A  39      19.168  36.058  24.445  1.00  9.78           N  
ATOM    250  CA  TYR A  39      18.829  37.033  25.472  1.00  6.55           C  
ATOM    251  C   TYR A  39      18.731  38.472  24.980  1.00  9.09           C  
ATOM    252  O   TYR A  39      19.566  38.945  24.203  1.00  6.36           O  
ATOM    253  CB  TYR A  39      19.857  36.978  26.608  1.00  3.08           C  
ATOM    254  CG  TYR A  39      19.849  35.675  27.357  1.00  6.01           C  
ATOM    255  CD1 TYR A  39      18.872  35.413  28.326  1.00  7.90           C  
ATOM    256  CD2 TYR A  39      20.788  34.680  27.069  1.00  6.75           C  
ATOM    257  CE1 TYR A  39      18.824  34.185  28.990  1.00  7.64           C  
ATOM    258  CE2 TYR A  39      20.754  33.431  27.735  1.00  2.00           C  
ATOM    259  CZ  TYR A  39      19.771  33.198  28.687  1.00  9.91           C  
ATOM    260  OH  TYR A  39      19.718  31.985  29.332  1.00  7.23           O  
ATOM    261  N   ASP A  40      17.708  39.145  25.495  1.00  6.24           N  
ATOM    262  CA  ASP A  40      17.396  40.541  25.226  1.00  5.39           C  
ATOM    263  C   ASP A  40      17.951  41.317  26.439  1.00  7.20           C  
ATOM    264  O   ASP A  40      17.394  41.266  27.545  1.00  9.01           O  
ATOM    265  CB  ASP A  40      15.871  40.665  25.114  1.00  2.66           C  
ATOM    266  CG  ASP A  40      15.364  42.103  25.116  1.00 12.89           C  
ATOM    267  OD1 ASP A  40      16.169  43.060  25.175  1.00  9.04           O  
ATOM    268  OD2 ASP A  40      14.120  42.261  25.054  1.00  5.53           O  
ATOM    269  N   LEU A  41      19.072  41.996  26.222  1.00  4.89           N  
ATOM    270  CA  LEU A  41      19.736  42.780  27.253  1.00  5.59           C  
ATOM    271  C   LEU A  41      19.327  44.224  26.968  1.00  8.06           C  
ATOM    272  O   LEU A  41      20.030  44.963  26.277  1.00  6.86           O  
ATOM    273  CB  LEU A  41      21.260  42.592  27.140  1.00  2.38           C  
ATOM    274  CG  LEU A  41      21.719  41.123  27.133  1.00  6.54           C  
ATOM    275  CD1 LEU A  41      23.246  41.056  27.092  1.00  6.84           C  
ATOM    276  CD2 LEU A  41      21.193  40.403  28.372  1.00  7.76           C  
ATOM    277  N   ARG A  42      18.183  44.611  27.529  1.00  8.86           N  
ATOM    278  CA  ARG A  42      17.603  45.914  27.296  1.00  7.98           C  
ATOM    279  C   ARG A  42      18.072  47.059  28.194  1.00  9.82           C  
ATOM    280  O   ARG A  42      17.823  47.054  29.405  1.00  8.72           O  
ATOM    281  CB  ARG A  42      16.077  45.789  27.369  1.00  4.99           C  
ATOM    282  CG  ARG A  42      15.328  46.977  26.803  1.00  8.08           C  
ATOM    283  CD  ARG A  42      15.369  47.000  25.269  1.00  7.25           C  
ATOM    284  NE  ARG A  42      14.897  45.741  24.688  1.00  8.72           N  
ATOM    285  CZ  ARG A  42      14.456  45.589  23.439  1.00 12.94           C  
ATOM    286  NH1 ARG A  42      14.410  46.622  22.597  1.00  6.46           N  
ATOM    287  NH2 ARG A  42      14.060  44.389  23.026  1.00  5.63           N  
ATOM    288  N   PHE A  43      18.745  48.036  27.587  1.00  8.11           N  
ATOM    289  CA  PHE A  43      19.220  49.219  28.305  1.00  9.64           C  
ATOM    290  C   PHE A  43      18.110  50.267  28.395  1.00 14.30           C  
ATOM    291  O   PHE A  43      17.809  50.755  29.476  1.00  8.15           O  
ATOM    292  CB  PHE A  43      20.397  49.900  27.598  1.00  4.68           C  
ATOM    293  CG  PHE A  43      21.726  49.212  27.777  1.00  6.59           C  
ATOM    294  CD1 PHE A  43      22.833  49.928  28.254  1.00 12.18           C  
ATOM    295  CD2 PHE A  43      21.904  47.890  27.380  1.00  6.71           C  
ATOM    296  CE1 PHE A  43      24.113  49.333  28.317  1.00  5.42           C  
ATOM    297  CE2 PHE A  43      23.161  47.286  27.433  1.00  8.11           C  
ATOM    298  CZ  PHE A  43      24.278  48.012  27.905  1.00  6.37           C  
ATOM    299  N   LEU A  44      17.522  50.620  27.251  1.00  7.44           N  
ATOM    300  CA  LEU A  44      16.488  51.655  27.207  1.00  9.06           C  
ATOM    301  C   LEU A  44      15.085  51.155  26.947  1.00  8.40           C  
ATOM    302  O   LEU A  44      14.889  50.084  26.381  1.00  4.34           O  
ATOM    303  CB  LEU A  44      16.822  52.692  26.132  1.00  5.22           C  
ATOM    304  CG  LEU A  44      18.254  53.220  26.127  1.00 15.20           C  
ATOM    305  CD1 LEU A  44      18.357  54.328  25.078  1.00 10.62           C  
ATOM    306  CD2 LEU A  44      18.646  53.731  27.517  1.00 14.90           C  
ATOM    307  N   GLN A  45      14.106  51.956  27.362  1.00  8.42           N  
ATOM    308  CA  GLN A  45      12.712  51.609  27.157  1.00  9.03           C  
ATOM    309  C   GLN A  45      12.420  51.718  25.664  1.00  7.46           C  
ATOM    310  O   GLN A  45      12.718  52.735  25.046  1.00  6.96           O  
ATOM    311  CB  GLN A  45      11.795  52.575  27.912  1.00 11.26           C  
ATOM    312  CG  GLN A  45      10.319  52.186  27.815  1.00  8.34           C  
ATOM    313  CD  GLN A  45      10.027  50.908  28.590  1.00 15.08           C  
ATOM    314  OE1 GLN A  45      10.712  50.603  29.569  1.00  9.91           O  
ATOM    315  NE2 GLN A  45       9.003  50.169  28.172  1.00  8.75           N  
ATOM    316  N   PRO A  46      11.833  50.669  25.076  1.00  6.32           N  
ATOM    317  CA  PRO A  46      11.516  50.687  23.647  1.00  7.92           C  
ATOM    318  C   PRO A  46      10.821  51.969  23.220  1.00  7.48           C  
ATOM    319  O   PRO A  46       9.857  52.406  23.848  1.00  3.11           O  
ATOM    320  CB  PRO A  46      10.629  49.452  23.477  1.00  7.76           C  
ATOM    321  CG  PRO A  46      11.261  48.466  24.480  1.00  4.22           C  
ATOM    322  CD  PRO A  46      11.476  49.371  25.691  1.00  2.00           C  
ATOM    323  N   ASN A  47      11.346  52.587  22.168  1.00  7.09           N  
ATOM    324  CA  ASN A  47      10.756  53.804  21.610  1.00 11.73           C  
ATOM    325  C   ASN A  47      10.722  55.070  22.464  1.00 13.35           C  
ATOM    326  O   ASN A  47       9.941  55.994  22.198  1.00 12.32           O  
ATOM    327  CB  ASN A  47       9.354  53.452  21.103  1.00  6.22           C  
ATOM    328  CG  ASN A  47       9.411  52.392  20.024  1.00  9.62           C  
ATOM    329  OD1 ASN A  47      10.039  52.604  18.987  1.00  8.89           O  
ATOM    330  ND2 ASN A  47       8.796  51.243  20.268  1.00 10.33           N  
ATOM    331  N   GLN A  48      11.569  55.118  23.486  1.00 11.28           N  
ATOM    332  CA  GLN A  48      11.647  56.295  24.350  1.00  8.82           C  
ATOM    333  C   GLN A  48      13.015  56.958  24.196  1.00 11.91           C  
ATOM    334  O   GLN A  48      13.350  57.893  24.919  1.00  9.97           O  
ATOM    335  CB  GLN A  48      11.442  55.891  25.807  1.00 14.07           C  
ATOM    336  CG  GLN A  48      10.023  55.442  26.121  1.00 22.84           C  
ATOM    337  CD  GLN A  48       9.011  56.557  25.906  1.00 28.93           C  
ATOM    338  OE1 GLN A  48       9.228  57.696  26.332  1.00 38.18           O  
ATOM    339  NE2 GLN A  48       7.902  56.236  25.253  1.00 25.31           N  
ATOM    340  N   GLY A  49      13.796  56.471  23.242  1.00 12.01           N  
ATOM    341  CA  GLY A  49      15.124  57.009  23.026  1.00 12.85           C  
ATOM    342  C   GLY A  49      16.022  55.876  22.575  1.00 13.44           C  
ATOM    343  O   GLY A  49      15.675  54.706  22.732  1.00 13.85           O  
ATOM    344  N   ALA A  50      17.177  56.211  22.018  1.00  8.38           N  
ATOM    345  CA  ALA A  50      18.096  55.193  21.539  1.00  8.98           C  
ATOM    346  C   ALA A  50      19.537  55.532  21.887  1.00 11.49           C  
ATOM    347  O   ALA A  50      19.876  56.687  22.132  1.00  9.99           O  
ATOM    348  CB  ALA A  50      17.945  55.038  20.017  1.00 11.59           C  
ATOM    349  N   ILE A  51      20.384  54.512  21.904  1.00  8.14           N  
ATOM    350  CA  ILE A  51      21.799  54.683  22.201  1.00  8.92           C  
ATOM    351  C   ILE A  51      22.466  55.167  20.909  1.00 10.74           C  
ATOM    352  O   ILE A  51      22.197  54.639  19.830  1.00  4.03           O  
ATOM    353  CB  ILE A  51      22.442  53.327  22.630  1.00  7.85           C  
ATOM    354  CG1 ILE A  51      21.784  52.822  23.915  1.00  6.82           C  
ATOM    355  CG2 ILE A  51      23.953  53.480  22.846  1.00  6.72           C  
ATOM    356  CD1 ILE A  51      22.076  51.352  24.199  1.00  6.26           C  
ATOM    357  N   ASP A  52      23.323  56.175  21.024  1.00  8.78           N  
ATOM    358  CA  ASP A  52      24.045  56.721  19.870  1.00 10.11           C  
ATOM    359  C   ASP A  52      24.860  55.583  19.234  1.00  7.35           C  
ATOM    360  O   ASP A  52      25.355  54.705  19.934  1.00  8.91           O  
ATOM    361  CB  ASP A  52      24.987  57.831  20.343  1.00 11.89           C  
ATOM    362  CG  ASP A  52      25.630  58.589  19.201  1.00 32.48           C  
ATOM    363  OD1 ASP A  52      24.915  59.377  18.539  1.00 36.90           O  
ATOM    364  OD2 ASP A  52      26.851  58.404  18.968  1.00 32.75           O  
ATOM    365  N   PRO A  53      25.014  55.592  17.900  1.00  7.72           N  
ATOM    366  CA  PRO A  53      25.774  54.543  17.215  1.00  7.71           C  
ATOM    367  C   PRO A  53      27.206  54.333  17.724  1.00  6.93           C  
ATOM    368  O   PRO A  53      27.642  53.191  17.878  1.00  6.92           O  
ATOM    369  CB  PRO A  53      25.729  54.986  15.756  1.00  5.55           C  
ATOM    370  CG  PRO A  53      24.373  55.648  15.667  1.00  9.53           C  
ATOM    371  CD  PRO A  53      24.356  56.485  16.926  1.00 13.42           C  
ATOM    372  N   ALA A  54      27.937  55.421  17.969  1.00  5.23           N  
ATOM    373  CA  ALA A  54      29.306  55.303  18.444  1.00  6.67           C  
ATOM    374  C   ALA A  54      29.308  54.632  19.808  1.00  5.92           C  
ATOM    375  O   ALA A  54      30.124  53.756  20.081  1.00  6.54           O  
ATOM    376  CB  ALA A  54      29.965  56.680  18.552  1.00  6.44           C  
ATOM    377  N   ALA A  55      28.387  55.050  20.666  1.00  6.99           N  
ATOM    378  CA  ALA A  55      28.323  54.482  22.006  1.00  3.93           C  
ATOM    379  C   ALA A  55      27.961  53.002  22.003  1.00  6.44           C  
ATOM    380  O   ALA A  55      28.511  52.238  22.788  1.00  5.26           O  
ATOM    381  CB  ALA A  55      27.336  55.247  22.848  1.00  2.00           C  
ATOM    382  N   ILE A  56      27.031  52.586  21.144  1.00  4.40           N  
ATOM    383  CA  ILE A  56      26.652  51.184  21.146  1.00  6.17           C  
ATOM    384  C   ILE A  56      27.773  50.361  20.530  1.00  4.92           C  
ATOM    385  O   ILE A  56      27.967  49.206  20.883  1.00  3.69           O  
ATOM    386  CB  ILE A  56      25.290  50.949  20.429  1.00 10.85           C  
ATOM    387  CG1 ILE A  56      24.628  49.690  21.002  1.00  5.16           C  
ATOM    388  CG2 ILE A  56      25.471  50.843  18.912  1.00  7.64           C  
ATOM    389  CD1 ILE A  56      23.163  49.481  20.530  1.00  3.05           C  
ATOM    390  N   HIS A  57      28.533  50.981  19.634  1.00  2.25           N  
ATOM    391  CA  HIS A  57      29.669  50.319  18.992  1.00  2.20           C  
ATOM    392  C   HIS A  57      30.702  50.053  20.103  1.00  8.96           C  
ATOM    393  O   HIS A  57      31.272  48.971  20.208  1.00  4.76           O  
ATOM    394  CB  HIS A  57      30.250  51.264  17.941  1.00  6.02           C  
ATOM    395  CG  HIS A  57      31.356  50.677  17.126  1.00  3.47           C  
ATOM    396  ND1 HIS A  57      32.128  51.441  16.283  1.00  3.45           N  
ATOM    397  CD2 HIS A  57      31.825  49.412  17.025  1.00  2.00           C  
ATOM    398  CE1 HIS A  57      33.030  50.674  15.696  1.00 10.39           C  
ATOM    399  NE2 HIS A  57      32.864  49.438  16.130  1.00  7.87           N  
ATOM    400  N   THR A  58      30.945  51.055  20.939  1.00  7.61           N  
ATOM    401  CA  THR A  58      31.887  50.879  22.032  1.00  6.04           C  
ATOM    402  C   THR A  58      31.366  49.828  23.008  1.00  5.03           C  
ATOM    403  O   THR A  58      32.133  49.006  23.502  1.00  7.63           O  
ATOM    404  CB  THR A  58      32.104  52.198  22.792  1.00  9.56           C  
ATOM    405  OG1 THR A  58      32.646  53.154  21.889  1.00  5.88           O  
ATOM    406  CG2 THR A  58      33.078  52.010  23.960  1.00  5.52           C  
ATOM    407  N   LEU A  59      30.069  49.863  23.294  1.00  3.23           N  
ATOM    408  CA  LEU A  59      29.476  48.886  24.205  1.00  8.91           C  
ATOM    409  C   LEU A  59      29.686  47.489  23.643  1.00  9.07           C  
ATOM    410  O   LEU A  59      29.959  46.548  24.382  1.00  7.30           O  
ATOM    411  CB  LEU A  59      27.984  49.145  24.384  1.00  2.00           C  
ATOM    412  CG  LEU A  59      27.558  50.308  25.280  1.00  7.18           C  
ATOM    413  CD1 LEU A  59      26.035  50.452  25.194  1.00  5.35           C  
ATOM    414  CD2 LEU A  59      27.987  50.056  26.721  1.00 12.00           C  
ATOM    415  N   GLU A  60      29.563  47.357  22.326  1.00 12.54           N  
ATOM    416  CA  GLU A  60      29.768  46.064  21.683  1.00  8.87           C  
ATOM    417  C   GLU A  60      31.184  45.584  21.982  1.00  7.31           C  
ATOM    418  O   GLU A  60      31.388  44.444  22.398  1.00  7.74           O  
ATOM    419  CB  GLU A  60      29.576  46.185  20.171  1.00 13.19           C  
ATOM    420  CG  GLU A  60      29.882  44.896  19.397  1.00  4.96           C  
ATOM    421  CD  GLU A  60      30.046  45.146  17.901  1.00 14.87           C  
ATOM    422  OE1 GLU A  60      30.926  45.961  17.532  1.00 13.10           O  
ATOM    423  OE2 GLU A  60      29.300  44.526  17.096  1.00  7.28           O  
ATOM    424  N   HIS A  61      32.162  46.461  21.777  1.00  5.59           N  
ATOM    425  CA  HIS A  61      33.559  46.105  22.033  1.00  8.14           C  
ATOM    426  C   HIS A  61      33.841  45.681  23.483  1.00 11.01           C  
ATOM    427  O   HIS A  61      34.520  44.679  23.721  1.00  8.93           O  
ATOM    428  CB  HIS A  61      34.478  47.284  21.688  1.00 10.79           C  
ATOM    429  CG  HIS A  61      34.883  47.337  20.252  1.00 13.34           C  
ATOM    430  ND1 HIS A  61      36.193  47.496  19.852  1.00 13.19           N  
ATOM    431  CD2 HIS A  61      34.149  47.249  19.112  1.00  9.92           C  
ATOM    432  CE1 HIS A  61      36.251  47.505  18.532  1.00 12.06           C  
ATOM    433  NE2 HIS A  61      35.024  47.358  18.062  1.00  9.51           N  
ATOM    434  N   LEU A  62      33.328  46.456  24.440  1.00  6.00           N  
ATOM    435  CA  LEU A  62      33.545  46.190  25.860  1.00  5.79           C  
ATOM    436  C   LEU A  62      32.854  44.945  26.393  1.00 10.20           C  
ATOM    437  O   LEU A  62      33.460  44.163  27.139  1.00  7.08           O  
ATOM    438  CB  LEU A  62      33.118  47.408  26.697  1.00  6.72           C  
ATOM    439  CG  LEU A  62      33.976  48.676  26.512  1.00 10.16           C  
ATOM    440  CD1 LEU A  62      33.401  49.827  27.342  1.00  9.63           C  
ATOM    441  CD2 LEU A  62      35.422  48.384  26.939  1.00  7.78           C  
ATOM    442  N   LEU A  63      31.595  44.757  26.002  1.00  3.38           N  
ATOM    443  CA  LEU A  63      30.820  43.625  26.472  1.00  2.69           C  
ATOM    444  C   LEU A  63      31.241  42.289  25.881  1.00  7.26           C  
ATOM    445  O   LEU A  63      31.008  41.243  26.494  1.00  6.45           O  
ATOM    446  CB  LEU A  63      29.323  43.881  26.244  1.00  3.94           C  
ATOM    447  CG  LEU A  63      28.770  45.037  27.086  1.00  4.97           C  
ATOM    448  CD1 LEU A  63      27.301  45.242  26.804  1.00  7.75           C  
ATOM    449  CD2 LEU A  63      28.979  44.734  28.563  1.00 13.60           C  
ATOM    450  N   ALA A  64      31.871  42.309  24.707  1.00  8.46           N  
ATOM    451  CA  ALA A  64      32.335  41.054  24.106  1.00  5.08           C  
ATOM    452  C   ALA A  64      33.209  40.366  25.151  1.00 11.92           C  
ATOM    453  O   ALA A  64      33.034  39.185  25.447  1.00  9.00           O  
ATOM    454  CB  ALA A  64      33.156  41.330  22.844  1.00  5.67           C  
ATOM    455  N   GLY A  65      34.134  41.127  25.734  1.00  8.73           N  
ATOM    456  CA  GLY A  65      35.010  40.556  26.734  1.00 15.68           C  
ATOM    457  C   GLY A  65      34.448  40.467  28.147  1.00 10.72           C  
ATOM    458  O   GLY A  65      34.591  39.440  28.808  1.00  9.83           O  
ATOM    459  N   TYR A  66      33.819  41.534  28.626  1.00  2.53           N  
ATOM    460  CA  TYR A  66      33.287  41.520  29.983  1.00  8.40           C  
ATOM    461  C   TYR A  66      32.191  40.489  30.222  1.00  7.19           C  
ATOM    462  O   TYR A  66      32.106  39.926  31.309  1.00  7.72           O  
ATOM    463  CB  TYR A  66      32.816  42.929  30.379  1.00  7.51           C  
ATOM    464  CG  TYR A  66      33.972  43.891  30.602  1.00 11.09           C  
ATOM    465  CD1 TYR A  66      33.858  45.239  30.267  1.00  9.83           C  
ATOM    466  CD2 TYR A  66      35.184  43.450  31.140  1.00  8.12           C  
ATOM    467  CE1 TYR A  66      34.926  46.132  30.459  1.00  8.18           C  
ATOM    468  CE2 TYR A  66      36.256  44.340  31.339  1.00 17.49           C  
ATOM    469  CZ  TYR A  66      36.114  45.679  30.990  1.00 16.62           C  
ATOM    470  OH  TYR A  66      37.156  46.571  31.167  1.00 14.74           O  
ATOM    471  N   MET A  67      31.352  40.224  29.223  1.00  8.22           N  
ATOM    472  CA  MET A  67      30.322  39.209  29.412  1.00  6.80           C  
ATOM    473  C   MET A  67      31.009  37.843  29.521  1.00  6.16           C  
ATOM    474  O   MET A  67      30.658  37.031  30.373  1.00  7.42           O  
ATOM    475  CB  MET A  67      29.311  39.214  28.257  1.00  8.18           C  
ATOM    476  CG  MET A  67      28.330  40.387  28.322  1.00  6.46           C  
ATOM    477  SD  MET A  67      27.397  40.492  29.875  1.00 12.04           S  
ATOM    478  CE  MET A  67      26.487  38.931  29.859  1.00  4.66           C  
ATOM    479  N   ARG A  68      32.008  37.607  28.678  1.00  6.30           N  
ATOM    480  CA  ARG A  68      32.729  36.341  28.720  1.00  6.53           C  
ATOM    481  C   ARG A  68      33.483  36.171  30.049  1.00 12.67           C  
ATOM    482  O   ARG A  68      33.709  35.048  30.497  1.00  7.44           O  
ATOM    483  CB  ARG A  68      33.697  36.231  27.538  1.00  9.73           C  
ATOM    484  CG  ARG A  68      33.021  35.982  26.180  1.00  4.94           C  
ATOM    485  CD  ARG A  68      34.071  35.831  25.085  1.00  4.54           C  
ATOM    486  NE  ARG A  68      33.495  35.409  23.813  1.00 16.85           N  
ATOM    487  CZ  ARG A  68      32.801  36.206  23.007  1.00 10.98           C  
ATOM    488  NH1 ARG A  68      32.595  37.482  23.338  1.00  9.59           N  
ATOM    489  NH2 ARG A  68      32.303  35.728  21.876  1.00 13.36           N  
ATOM    490  N   ASP A  69      33.872  37.276  30.682  1.00 11.08           N  
ATOM    491  CA  ASP A  69      34.559  37.185  31.975  1.00 15.13           C  
ATOM    492  C   ASP A  69      33.613  36.668  33.063  1.00 13.82           C  
ATOM    493  O   ASP A  69      34.049  36.096  34.067  1.00 11.03           O  
ATOM    494  CB  ASP A  69      35.067  38.554  32.443  1.00  5.61           C  
ATOM    495  CG  ASP A  69      36.254  39.049  31.647  1.00  9.68           C  
ATOM    496  OD1 ASP A  69      36.970  38.221  31.043  1.00 15.08           O  
ATOM    497  OD2 ASP A  69      36.483  40.274  31.646  1.00  9.55           O  
ATOM    498  N   HIS A  70      32.317  36.874  32.864  1.00  5.65           N  
ATOM    499  CA  HIS A  70      31.348  36.480  33.878  1.00  8.10           C  
ATOM    500  C   HIS A  70      30.328  35.420  33.475  1.00 14.62           C  
ATOM    501  O   HIS A  70      29.481  35.046  34.285  1.00 12.93           O  
ATOM    502  CB  HIS A  70      30.593  37.726  34.345  1.00 12.93           C  
ATOM    503  CG  HIS A  70      31.480  38.807  34.883  1.00 16.82           C  
ATOM    504  ND1 HIS A  70      32.197  38.670  36.053  1.00 19.66           N  
ATOM    505  CD2 HIS A  70      31.769  40.041  34.408  1.00  7.95           C  
ATOM    506  CE1 HIS A  70      32.887  39.775  36.277  1.00 18.26           C  
ATOM    507  NE2 HIS A  70      32.646  40.622  35.294  1.00 10.23           N  
ATOM    508  N   LEU A  71      30.406  34.931  32.243  1.00 10.46           N  
ATOM    509  CA  LEU A  71      29.431  33.951  31.767  1.00 11.25           C  
ATOM    510  C   LEU A  71      30.039  33.026  30.709  1.00  9.34           C  
ATOM    511  O   LEU A  71      30.669  33.491  29.755  1.00  9.52           O  
ATOM    512  CB  LEU A  71      28.220  34.698  31.179  1.00  5.56           C  
ATOM    513  CG  LEU A  71      27.101  33.892  30.515  1.00  6.21           C  
ATOM    514  CD1 LEU A  71      26.360  33.100  31.557  1.00  6.74           C  
ATOM    515  CD2 LEU A  71      26.132  34.848  29.787  1.00  8.44           C  
ATOM    516  N   GLU A  72      29.847  31.720  30.885  1.00  7.91           N  
ATOM    517  CA  GLU A  72      30.373  30.728  29.941  1.00 10.76           C  
ATOM    518  C   GLU A  72      29.370  30.442  28.819  1.00  7.17           C  
ATOM    519  O   GLU A  72      28.172  30.662  28.979  1.00  8.87           O  
ATOM    520  CB  GLU A  72      30.656  29.421  30.669  1.00 12.52           C  
ATOM    521  CG  GLU A  72      31.573  29.566  31.866  1.00 23.69           C  
ATOM    522  CD  GLU A  72      31.482  28.375  32.783  1.00 40.12           C  
ATOM    523  OE1 GLU A  72      31.722  27.243  32.307  1.00 50.68           O  
ATOM    524  OE2 GLU A  72      31.160  28.570  33.978  1.00 48.88           O  
ATOM    525  N   GLY A  73      29.876  29.939  27.696  1.00  7.20           N  
ATOM    526  CA  GLY A  73      29.028  29.590  26.563  1.00  8.26           C  
ATOM    527  C   GLY A  73      28.574  30.738  25.675  1.00  8.48           C  
ATOM    528  O   GLY A  73      27.707  30.553  24.820  1.00  7.87           O  
ATOM    529  N   VAL A  74      29.146  31.926  25.861  1.00 10.03           N  
ATOM    530  CA  VAL A  74      28.743  33.078  25.045  1.00  5.90           C  
ATOM    531  C   VAL A  74      29.079  32.896  23.566  1.00  7.03           C  
ATOM    532  O   VAL A  74      30.209  32.574  23.214  1.00  4.49           O  
ATOM    533  CB  VAL A  74      29.415  34.365  25.540  1.00  7.94           C  
ATOM    534  CG1 VAL A  74      29.047  35.528  24.630  1.00  3.59           C  
ATOM    535  CG2 VAL A  74      28.976  34.647  26.978  1.00  6.95           C  
ATOM    536  N   VAL A  75      28.091  33.082  22.695  1.00  5.77           N  
ATOM    537  CA  VAL A  75      28.351  32.962  21.266  1.00  6.48           C  
ATOM    538  C   VAL A  75      28.910  34.321  20.845  1.00  8.57           C  
ATOM    539  O   VAL A  75      30.001  34.412  20.295  1.00  5.31           O  
ATOM    540  CB  VAL A  75      27.063  32.631  20.476  1.00  8.78           C  
ATOM    541  CG1 VAL A  75      27.392  32.487  18.999  1.00  7.94           C  
ATOM    542  CG2 VAL A  75      26.449  31.338  21.002  1.00 10.56           C  
ATOM    543  N   ASP A  76      28.155  35.379  21.120  1.00  7.67           N  
ATOM    544  CA  ASP A  76      28.586  36.748  20.826  1.00  6.33           C  
ATOM    545  C   ASP A  76      27.575  37.737  21.389  1.00  2.02           C  
ATOM    546  O   ASP A  76      26.437  37.365  21.679  1.00  7.94           O  
ATOM    547  CB  ASP A  76      28.737  36.960  19.322  1.00 10.03           C  
ATOM    548  CG  ASP A  76      30.170  36.769  18.844  1.00 13.82           C  
ATOM    549  OD1 ASP A  76      30.344  36.251  17.728  1.00 19.02           O  
ATOM    550  OD2 ASP A  76      31.120  37.147  19.571  1.00  9.16           O  
ATOM    551  N   VAL A  77      28.006  38.983  21.573  1.00  2.86           N  
ATOM    552  CA  VAL A  77      27.138  40.048  22.076  1.00  2.00           C  
ATOM    553  C   VAL A  77      27.026  41.046  20.935  1.00  5.47           C  
ATOM    554  O   VAL A  77      28.036  41.577  20.474  1.00  7.46           O  
ATOM    555  CB  VAL A  77      27.755  40.762  23.300  1.00  9.17           C  
ATOM    556  CG1 VAL A  77      26.812  41.857  23.800  1.00 10.07           C  
ATOM    557  CG2 VAL A  77      28.025  39.754  24.401  1.00 11.02           C  
ATOM    558  N   SER A  78      25.805  41.296  20.467  1.00  6.39           N  
ATOM    559  CA  SER A  78      25.618  42.221  19.350  1.00  6.33           C  
ATOM    560  C   SER A  78      24.688  43.375  19.659  1.00  3.82           C  
ATOM    561  O   SER A  78      23.799  43.268  20.490  1.00  5.48           O  
ATOM    562  CB  SER A  78      25.027  41.481  18.141  1.00 13.21           C  
ATOM    563  OG  SER A  78      25.922  40.536  17.608  1.00 17.41           O  
ATOM    564  N   PRO A  79      24.899  44.519  18.991  1.00  8.40           N  
ATOM    565  CA  PRO A  79      24.015  45.654  19.227  1.00  4.03           C  
ATOM    566  C   PRO A  79      22.706  45.319  18.503  1.00  4.47           C  
ATOM    567  O   PRO A  79      22.739  44.658  17.468  1.00  2.12           O  
ATOM    568  CB  PRO A  79      24.751  46.810  18.547  1.00  9.89           C  
ATOM    569  CG  PRO A  79      25.480  46.118  17.413  1.00 10.10           C  
ATOM    570  CD  PRO A  79      26.021  44.888  18.111  1.00  4.33           C  
ATOM    571  N   MET A  80      21.564  45.724  19.049  1.00  8.86           N  
ATOM    572  CA  MET A  80      20.290  45.483  18.364  1.00  6.78           C  
ATOM    573  C   MET A  80      20.149  46.623  17.355  1.00  9.28           C  
ATOM    574  O   MET A  80      20.650  47.734  17.588  1.00  3.05           O  
ATOM    575  CB  MET A  80      19.114  45.558  19.331  1.00  4.55           C  
ATOM    576  CG  MET A  80      19.210  44.586  20.483  1.00 12.35           C  
ATOM    577  SD  MET A  80      17.717  44.599  21.490  1.00 17.81           S  
ATOM    578  CE  MET A  80      17.593  46.289  21.925  1.00 34.90           C  
ATOM    579  N   GLY A  81      19.467  46.348  16.248  1.00  5.74           N  
ATOM    580  CA  GLY A  81      19.259  47.372  15.241  1.00  5.63           C  
ATOM    581  C   GLY A  81      18.437  48.531  15.786  1.00  4.90           C  
ATOM    582  O   GLY A  81      18.578  49.658  15.318  1.00  4.47           O  
ATOM    583  N   CYS A  82      17.596  48.268  16.785  1.00  2.75           N  
ATOM    584  CA  CYS A  82      16.763  49.332  17.360  1.00  6.37           C  
ATOM    585  C   CYS A  82      17.562  50.205  18.333  1.00  3.98           C  
ATOM    586  O   CYS A  82      17.087  51.242  18.797  1.00  7.24           O  
ATOM    587  CB  CYS A  82      15.544  48.727  18.062  1.00  9.67           C  
ATOM    588  SG  CYS A  82      15.955  47.428  19.262  1.00 12.66           S  
ATOM    589  N   ARG A  83      18.776  49.759  18.640  1.00  5.70           N  
ATOM    590  CA  ARG A  83      19.694  50.480  19.515  1.00  6.45           C  
ATOM    591  C   ARG A  83      19.229  50.818  20.929  1.00  9.76           C  
ATOM    592  O   ARG A  83      19.681  51.812  21.503  1.00 10.06           O  
ATOM    593  CB  ARG A  83      20.187  51.751  18.808  1.00  5.25           C  
ATOM    594  CG  ARG A  83      21.108  51.443  17.614  1.00  8.59           C  
ATOM    595  CD  ARG A  83      21.729  52.687  16.987  1.00  8.72           C  
ATOM    596  NE  ARG A  83      20.763  53.469  16.215  1.00 11.47           N  
ATOM    597  CZ  ARG A  83      20.334  54.679  16.554  1.00 18.16           C  
ATOM    598  NH1 ARG A  83      20.782  55.254  17.664  1.00 12.39           N  
ATOM    599  NH2 ARG A  83      19.477  55.323  15.770  1.00 11.17           N  
ATOM    600  N   THR A  84      18.333  50.006  21.497  1.00  5.19           N  
ATOM    601  CA  THR A  84      17.894  50.236  22.876  1.00  4.04           C  
ATOM    602  C   THR A  84      18.536  49.168  23.777  1.00  8.80           C  
ATOM    603  O   THR A  84      18.346  49.139  25.001  1.00  2.00           O  
ATOM    604  CB  THR A  84      16.336  50.203  23.033  1.00  7.87           C  
ATOM    605  OG1 THR A  84      15.821  48.918  22.662  1.00  9.13           O  
ATOM    606  CG2 THR A  84      15.690  51.294  22.175  1.00  7.39           C  
ATOM    607  N   GLY A  85      19.304  48.282  23.150  1.00 10.56           N  
ATOM    608  CA  GLY A  85      19.961  47.236  23.904  1.00 10.12           C  
ATOM    609  C   GLY A  85      20.857  46.345  23.076  1.00  8.95           C  
ATOM    610  O   GLY A  85      21.084  46.606  21.896  1.00  6.06           O  
ATOM    611  N   MET A  86      21.357  45.284  23.713  1.00  9.07           N  
ATOM    612  CA  MET A  86      22.249  44.323  23.069  1.00  8.09           C  
ATOM    613  C   MET A  86      21.566  42.960  23.016  1.00 11.51           C  
ATOM    614  O   MET A  86      20.714  42.642  23.846  1.00  6.69           O  
ATOM    615  CB  MET A  86      23.554  44.183  23.858  1.00  9.75           C  
ATOM    616  CG  MET A  86      24.182  45.494  24.293  1.00  7.29           C  
ATOM    617  SD  MET A  86      24.667  46.480  22.876  1.00 12.47           S  
ATOM    618  CE  MET A  86      26.100  45.634  22.389  1.00  6.03           C  
ATOM    619  N   TYR A  87      21.953  42.165  22.030  1.00  5.87           N  
ATOM    620  CA  TYR A  87      21.407  40.833  21.846  1.00  2.00           C  
ATOM    621  C   TYR A  87      22.567  39.865  22.082  1.00  5.20           C  
ATOM    622  O   TYR A  87      23.674  40.127  21.643  1.00  6.83           O  
ATOM    623  CB  TYR A  87      20.872  40.706  20.415  1.00 15.71           C  
ATOM    624  CG  TYR A  87      20.756  39.293  19.927  1.00  8.52           C  
ATOM    625  CD1 TYR A  87      21.843  38.661  19.315  1.00 16.79           C  
ATOM    626  CD2 TYR A  87      19.587  38.566  20.117  1.00 12.19           C  
ATOM    627  CE1 TYR A  87      21.773  37.332  18.908  1.00 18.62           C  
ATOM    628  CE2 TYR A  87      19.503  37.220  19.707  1.00 19.50           C  
ATOM    629  CZ  TYR A  87      20.604  36.614  19.107  1.00 15.39           C  
ATOM    630  OH  TYR A  87      20.557  35.289  18.715  1.00 13.04           O  
ATOM    631  N   MET A  88      22.313  38.759  22.775  1.00  2.23           N  
ATOM    632  CA  MET A  88      23.366  37.794  23.047  1.00  8.21           C  
ATOM    633  C   MET A  88      22.856  36.357  23.037  1.00  4.85           C  
ATOM    634  O   MET A  88      21.875  36.040  23.712  1.00  5.35           O  
ATOM    635  CB  MET A  88      24.024  38.112  24.405  1.00  4.58           C  
ATOM    636  CG  MET A  88      25.013  37.034  24.912  1.00  7.68           C  
ATOM    637  SD  MET A  88      25.672  37.367  26.576  1.00  5.52           S  
ATOM    638  CE  MET A  88      24.209  37.020  27.560  1.00  9.45           C  
ATOM    639  N   ALA A  89      23.511  35.497  22.261  1.00  2.00           N  
ATOM    640  CA  ALA A  89      23.133  34.087  22.224  1.00  6.96           C  
ATOM    641  C   ALA A  89      24.146  33.353  23.110  1.00  6.52           C  
ATOM    642  O   ALA A  89      25.347  33.675  23.119  1.00  6.75           O  
ATOM    643  CB  ALA A  89      23.155  33.533  20.765  1.00  2.03           C  
ATOM    644  N   VAL A  90      23.653  32.379  23.864  1.00  2.21           N  
ATOM    645  CA  VAL A  90      24.484  31.614  24.787  1.00  3.47           C  
ATOM    646  C   VAL A  90      24.194  30.121  24.604  1.00 14.56           C  
ATOM    647  O   VAL A  90      23.037  29.726  24.425  1.00  9.31           O  
ATOM    648  CB  VAL A  90      24.139  31.960  26.269  1.00  4.37           C  
ATOM    649  CG1 VAL A  90      25.087  31.224  27.218  1.00  7.27           C  
ATOM    650  CG2 VAL A  90      24.209  33.468  26.500  1.00  5.58           C  
ATOM    651  N   ILE A  91      25.230  29.291  24.654  1.00  9.08           N  
ATOM    652  CA  ILE A  91      25.001  27.855  24.535  1.00 10.73           C  
ATOM    653  C   ILE A  91      24.695  27.363  25.935  1.00 11.46           C  
ATOM    654  O   ILE A  91      25.514  27.498  26.845  1.00 11.78           O  
ATOM    655  CB  ILE A  91      26.233  27.114  23.989  1.00 10.27           C  
ATOM    656  CG1 ILE A  91      26.586  27.652  22.608  1.00  2.83           C  
ATOM    657  CG2 ILE A  91      25.919  25.613  23.829  1.00 12.82           C  
ATOM    658  CD1 ILE A  91      27.937  27.124  22.085  1.00 10.39           C  
ATOM    659  N   GLY A  92      23.497  26.821  26.115  1.00 15.65           N  
ATOM    660  CA  GLY A  92      23.104  26.325  27.416  1.00 15.12           C  
ATOM    661  C   GLY A  92      21.619  26.517  27.631  1.00 14.45           C  
ATOM    662  O   GLY A  92      20.965  27.279  26.917  1.00  8.53           O  
ATOM    663  N   GLU A  93      21.069  25.813  28.606  1.00  4.80           N  
ATOM    664  CA  GLU A  93      19.647  25.958  28.883  1.00 14.35           C  
ATOM    665  C   GLU A  93      19.413  27.362  29.426  1.00 11.92           C  
ATOM    666  O   GLU A  93      20.342  28.018  29.904  1.00 12.22           O  
ATOM    667  CB  GLU A  93      19.198  24.927  29.912  1.00 17.02           C  
ATOM    668  CG  GLU A  93      19.978  24.991  31.206  1.00 32.30           C  
ATOM    669  CD  GLU A  93      19.567  23.899  32.171  1.00 37.81           C  
ATOM    670  OE1 GLU A  93      19.614  22.711  31.771  1.00 34.43           O  
ATOM    671  OE2 GLU A  93      19.200  24.230  33.321  1.00 37.72           O  
ATOM    672  N   PRO A  94      18.169  27.845  29.345  1.00  9.42           N  
ATOM    673  CA  PRO A  94      17.845  29.180  29.835  1.00  9.88           C  
ATOM    674  C   PRO A  94      18.212  29.385  31.294  1.00 14.30           C  
ATOM    675  O   PRO A  94      17.966  28.524  32.146  1.00  4.00           O  
ATOM    676  CB  PRO A  94      16.345  29.269  29.607  1.00  9.47           C  
ATOM    677  CG  PRO A  94      16.182  28.502  28.314  1.00 19.40           C  
ATOM    678  CD  PRO A  94      17.041  27.278  28.579  1.00 11.36           C  
ATOM    679  N   ASP A  95      18.811  30.535  31.573  1.00  3.53           N  
ATOM    680  CA  ASP A  95      19.190  30.867  32.938  1.00  7.57           C  
ATOM    681  C   ASP A  95      19.160  32.378  33.055  1.00  3.30           C  
ATOM    682  O   ASP A  95      20.201  33.015  33.151  1.00  6.14           O  
ATOM    683  CB  ASP A  95      20.598  30.346  33.250  1.00 11.60           C  
ATOM    684  CG  ASP A  95      20.976  30.544  34.711  1.00 10.77           C  
ATOM    685  OD1 ASP A  95      20.173  31.138  35.457  1.00  7.69           O  
ATOM    686  OD2 ASP A  95      22.073  30.108  35.110  1.00 11.79           O  
ATOM    687  N   GLU A  96      17.962  32.947  33.052  1.00  6.74           N  
ATOM    688  CA  GLU A  96      17.825  34.397  33.137  1.00 11.86           C  
ATOM    689  C   GLU A  96      18.448  35.013  34.375  1.00  9.19           C  
ATOM    690  O   GLU A  96      19.016  36.101  34.308  1.00  5.73           O  
ATOM    691  CB  GLU A  96      16.354  34.780  33.047  1.00  7.82           C  
ATOM    692  CG  GLU A  96      15.799  34.539  31.647  1.00 13.16           C  
ATOM    693  CD  GLU A  96      14.300  34.707  31.584  1.00 20.60           C  
ATOM    694  OE1 GLU A  96      13.593  33.928  32.254  1.00 18.22           O  
ATOM    695  OE2 GLU A  96      13.834  35.617  30.869  1.00 14.75           O  
ATOM    696  N   GLN A  97      18.332  34.330  35.508  1.00  5.01           N  
ATOM    697  CA  GLN A  97      18.915  34.853  36.741  1.00  7.15           C  
ATOM    698  C   GLN A  97      20.445  34.920  36.605  1.00  6.78           C  
ATOM    699  O   GLN A  97      21.058  35.948  36.909  1.00  8.58           O  
ATOM    700  CB  GLN A  97      18.534  33.963  37.927  1.00 13.83           C  
ATOM    701  CG  GLN A  97      19.106  34.434  39.264  1.00 18.82           C  
ATOM    702  CD  GLN A  97      18.638  35.834  39.623  1.00 29.33           C  
ATOM    703  OE1 GLN A  97      17.472  36.173  39.437  1.00 18.85           O  
ATOM    704  NE2 GLN A  97      19.547  36.652  40.143  1.00 36.25           N  
ATOM    705  N   GLY A  98      21.057  33.822  36.164  1.00  5.20           N  
ATOM    706  CA  GLY A  98      22.498  33.803  35.990  1.00  6.69           C  
ATOM    707  C   GLY A  98      22.961  34.829  34.961  1.00 10.98           C  
ATOM    708  O   GLY A  98      23.970  35.515  35.153  1.00  8.98           O  
ATOM    709  N   VAL A  99      22.228  34.953  33.859  1.00  8.90           N  
ATOM    710  CA  VAL A  99      22.619  35.920  32.848  1.00  6.70           C  
ATOM    711  C   VAL A  99      22.517  37.350  33.392  1.00  9.71           C  
ATOM    712  O   VAL A  99      23.358  38.202  33.080  1.00  6.75           O  
ATOM    713  CB  VAL A  99      21.743  35.788  31.588  1.00  9.89           C  
ATOM    714  CG1 VAL A  99      22.025  36.937  30.638  1.00  5.57           C  
ATOM    715  CG2 VAL A  99      22.036  34.454  30.904  1.00 13.60           C  
ATOM    716  N   MET A 100      21.500  37.611  34.214  1.00  8.56           N  
ATOM    717  CA  MET A 100      21.338  38.946  34.781  1.00  9.81           C  
ATOM    718  C   MET A 100      22.529  39.290  35.664  1.00 10.72           C  
ATOM    719  O   MET A 100      23.050  40.400  35.603  1.00  8.92           O  
ATOM    720  CB  MET A 100      20.061  39.053  35.615  1.00  2.00           C  
ATOM    721  CG  MET A 100      19.951  40.387  36.375  1.00 14.99           C  
ATOM    722  SD  MET A 100      18.263  40.695  36.917  1.00 16.18           S  
ATOM    723  CE  MET A 100      17.531  40.486  35.347  1.00 37.23           C  
ATOM    724  N   LYS A 101      22.957  38.337  36.486  1.00 10.64           N  
ATOM    725  CA  LYS A 101      24.095  38.579  37.369  1.00 17.15           C  
ATOM    726  C   LYS A 101      25.386  38.817  36.587  1.00  7.90           C  
ATOM    727  O   LYS A 101      26.191  39.652  36.966  1.00 10.56           O  
ATOM    728  CB  LYS A 101      24.269  37.415  38.347  1.00 22.58           C  
ATOM    729  CG  LYS A 101      23.136  37.312  39.362  1.00 28.97           C  
ATOM    730  CD  LYS A 101      22.990  38.617  40.152  1.00 32.80           C  
ATOM    731  CE  LYS A 101      21.974  38.494  41.276  1.00 35.27           C  
ATOM    732  NZ  LYS A 101      21.889  39.754  42.075  1.00 37.68           N  
ATOM    733  N   ALA A 102      25.585  38.078  35.504  1.00  9.80           N  
ATOM    734  CA  ALA A 102      26.778  38.267  34.679  1.00  8.57           C  
ATOM    735  C   ALA A 102      26.725  39.649  34.029  1.00  8.18           C  
ATOM    736  O   ALA A 102      27.728  40.368  34.009  1.00  8.59           O  
ATOM    737  CB  ALA A 102      26.849  37.188  33.593  1.00 16.18           C  
ATOM    738  N   PHE A 103      25.551  40.004  33.496  1.00  2.00           N  
ATOM    739  CA  PHE A 103      25.322  41.287  32.838  1.00  4.90           C  
ATOM    740  C   PHE A 103      25.579  42.423  33.835  1.00  6.07           C  
ATOM    741  O   PHE A 103      26.238  43.402  33.517  1.00  5.69           O  
ATOM    742  CB  PHE A 103      23.882  41.346  32.306  1.00  2.62           C  
ATOM    743  CG  PHE A 103      23.554  42.598  31.517  1.00  4.37           C  
ATOM    744  CD1 PHE A 103      24.477  43.156  30.633  1.00  6.70           C  
ATOM    745  CD2 PHE A 103      22.287  43.169  31.602  1.00  2.02           C  
ATOM    746  CE1 PHE A 103      24.134  44.266  29.836  1.00  7.79           C  
ATOM    747  CE2 PHE A 103      21.933  44.279  30.811  1.00  4.42           C  
ATOM    748  CZ  PHE A 103      22.862  44.823  29.927  1.00  6.12           C  
ATOM    749  N   GLU A 104      25.074  42.273  35.052  1.00  7.24           N  
ATOM    750  CA  GLU A 104      25.285  43.292  36.067  1.00  5.85           C  
ATOM    751  C   GLU A 104      26.769  43.479  36.362  1.00  7.56           C  
ATOM    752  O   GLU A 104      27.237  44.607  36.519  1.00  9.16           O  
ATOM    753  CB  GLU A 104      24.549  42.917  37.345  1.00 10.97           C  
ATOM    754  CG  GLU A 104      24.822  43.873  38.477  1.00 15.19           C  
ATOM    755  CD  GLU A 104      24.099  43.472  39.737  1.00 29.05           C  
ATOM    756  OE1 GLU A 104      24.294  42.324  40.191  1.00 32.45           O  
ATOM    757  OE2 GLU A 104      23.337  44.305  40.266  1.00 41.83           O  
ATOM    758  N   ALA A 105      27.508  42.372  36.438  1.00  6.58           N  
ATOM    759  CA  ALA A 105      28.939  42.430  36.708  1.00 13.41           C  
ATOM    760  C   ALA A 105      29.695  43.040  35.537  1.00  9.04           C  
ATOM    761  O   ALA A 105      30.603  43.855  35.730  1.00  3.84           O  
ATOM    762  CB  ALA A 105      29.481  41.035  37.017  1.00  8.76           C  
ATOM    763  N   ALA A 106      29.315  42.651  34.323  1.00  6.63           N  
ATOM    764  CA  ALA A 106      29.957  43.176  33.116  1.00  7.49           C  
ATOM    765  C   ALA A 106      29.691  44.690  33.002  1.00  4.48           C  
ATOM    766  O   ALA A 106      30.526  45.459  32.499  1.00  7.32           O  
ATOM    767  CB  ALA A 106      29.413  42.434  31.859  1.00  5.53           C  
ATOM    768  N   LEU A 107      28.525  45.120  33.470  1.00  4.16           N  
ATOM    769  CA  LEU A 107      28.200  46.539  33.412  1.00  9.93           C  
ATOM    770  C   LEU A 107      29.021  47.325  34.427  1.00 11.08           C  
ATOM    771  O   LEU A 107      29.341  48.483  34.192  1.00  4.63           O  
ATOM    772  CB  LEU A 107      26.716  46.766  33.654  1.00 10.54           C  
ATOM    773  CG  LEU A 107      25.789  46.336  32.513  1.00 16.91           C  
ATOM    774  CD1 LEU A 107      24.337  46.393  32.988  1.00  6.79           C  
ATOM    775  CD2 LEU A 107      26.018  47.238  31.299  1.00  8.31           C  
ATOM    776  N   LYS A 108      29.363  46.711  35.557  1.00 14.03           N  
ATOM    777  CA  LYS A 108      30.191  47.426  36.530  1.00  7.34           C  
ATOM    778  C   LYS A 108      31.575  47.563  35.903  1.00  4.08           C  
ATOM    779  O   LYS A 108      32.209  48.606  35.994  1.00  8.08           O  
ATOM    780  CB  LYS A 108      30.255  46.662  37.855  1.00  5.90           C  
ATOM    781  CG  LYS A 108      28.911  46.612  38.590  1.00 10.51           C  
ATOM    782  CD  LYS A 108      29.002  45.791  39.880  1.00 17.27           C  
ATOM    783  CE  LYS A 108      27.665  45.741  40.628  1.00 18.69           C  
ATOM    784  NZ  LYS A 108      27.739  44.814  41.811  1.00 15.24           N  
ATOM    785  N   ASP A 109      32.041  46.506  35.248  1.00  5.75           N  
ATOM    786  CA  ASP A 109      33.334  46.537  34.572  1.00  8.62           C  
ATOM    787  C   ASP A 109      33.313  47.641  33.519  1.00  6.68           C  
ATOM    788  O   ASP A 109      34.278  48.379  33.354  1.00  7.21           O  
ATOM    789  CB  ASP A 109      33.609  45.197  33.870  1.00  5.37           C  
ATOM    790  CG  ASP A 109      33.870  44.061  34.845  1.00 19.08           C  
ATOM    791  OD1 ASP A 109      33.711  42.883  34.443  1.00 13.42           O  
ATOM    792  OD2 ASP A 109      34.253  44.344  36.004  1.00 17.44           O  
ATOM    793  N   THR A 110      32.202  47.745  32.799  1.00 10.65           N  
ATOM    794  CA  THR A 110      32.073  48.756  31.747  1.00  5.32           C  
ATOM    795  C   THR A 110      32.063  50.179  32.296  1.00  7.28           C  
ATOM    796  O   THR A 110      32.746  51.057  31.768  1.00  7.46           O  
ATOM    797  CB  THR A 110      30.777  48.525  30.924  1.00  8.37           C  
ATOM    798  OG1 THR A 110      30.826  47.220  30.330  1.00 11.38           O  
ATOM    799  CG2 THR A 110      30.639  49.569  29.828  1.00  9.49           C  
ATOM    800  N   ALA A 111      31.280  50.408  33.348  1.00  5.69           N  
ATOM    801  CA  ALA A 111      31.188  51.728  33.965  1.00  3.06           C  
ATOM    802  C   ALA A 111      32.564  52.171  34.473  1.00  9.97           C  
ATOM    803  O   ALA A 111      32.910  53.349  34.410  1.00  9.74           O  
ATOM    804  CB  ALA A 111      30.171  51.697  35.124  1.00  6.54           C  
ATOM    805  N   GLY A 112      33.351  51.217  34.960  1.00 10.31           N  
ATOM    806  CA  GLY A 112      34.677  51.537  35.464  1.00 12.14           C  
ATOM    807  C   GLY A 112      35.800  51.418  34.442  1.00 14.56           C  
ATOM    808  O   GLY A 112      36.975  51.550  34.800  1.00 12.15           O  
ATOM    809  N   HIS A 113      35.465  51.186  33.173  1.00  9.74           N  
ATOM    810  CA  HIS A 113      36.504  51.031  32.148  1.00 12.80           C  
ATOM    811  C   HIS A 113      37.152  52.376  31.823  1.00 12.91           C  
ATOM    812  O   HIS A 113      36.634  53.140  31.007  1.00  9.72           O  
ATOM    813  CB  HIS A 113      35.924  50.427  30.859  1.00  9.61           C  
ATOM    814  CG  HIS A 113      36.973  49.997  29.878  1.00  5.76           C  
ATOM    815  ND1 HIS A 113      37.487  48.716  29.851  1.00  9.10           N  
ATOM    816  CD2 HIS A 113      37.638  50.692  28.927  1.00  6.87           C  
ATOM    817  CE1 HIS A 113      38.426  48.643  28.923  1.00 13.86           C  
ATOM    818  NE2 HIS A 113      38.537  49.828  28.349  1.00 17.22           N  
ATOM    819  N   ASP A 114      38.295  52.652  32.448  1.00 16.45           N  
ATOM    820  CA  ASP A 114      38.980  53.914  32.225  1.00 21.41           C  
ATOM    821  C   ASP A 114      40.194  53.778  31.313  1.00 28.30           C  
ATOM    822  O   ASP A 114      40.932  54.737  31.104  1.00 30.86           O  
ATOM    823  CB  ASP A 114      39.383  54.545  33.563  1.00 27.16           C  
ATOM    824  CG  ASP A 114      40.380  53.703  34.346  1.00 35.99           C  
ATOM    825  OD1 ASP A 114      40.735  52.588  33.903  1.00 31.59           O  
ATOM    826  OD2 ASP A 114      40.810  54.168  35.423  1.00 40.46           O  
ATOM    827  N   GLN A 115      40.393  52.585  30.766  1.00 16.40           N  
ATOM    828  CA  GLN A 115      41.516  52.349  29.867  1.00 23.94           C  
ATOM    829  C   GLN A 115      41.016  52.515  28.436  1.00 20.31           C  
ATOM    830  O   GLN A 115      39.824  52.701  28.211  1.00 17.31           O  
ATOM    831  CB  GLN A 115      42.053  50.932  30.063  1.00 19.95           C  
ATOM    832  CG  GLN A 115      42.579  50.662  31.463  1.00 32.72           C  
ATOM    833  CD  GLN A 115      43.688  51.624  31.854  1.00 28.55           C  
ATOM    834  OE1 GLN A 115      44.708  51.725  31.169  1.00 31.09           O  
ATOM    835  NE2 GLN A 115      43.493  52.338  32.958  1.00 30.88           N  
ATOM    836  N   PRO A 116      41.922  52.469  27.451  1.00 20.11           N  
ATOM    837  CA  PRO A 116      41.461  52.613  26.067  1.00 20.51           C  
ATOM    838  C   PRO A 116      40.492  51.489  25.687  1.00 17.82           C  
ATOM    839  O   PRO A 116      40.470  50.426  26.322  1.00  9.35           O  
ATOM    840  CB  PRO A 116      42.760  52.564  25.257  1.00 21.88           C  
ATOM    841  CG  PRO A 116      43.722  51.840  26.159  1.00 35.74           C  
ATOM    842  CD  PRO A 116      43.391  52.391  27.516  1.00 24.16           C  
ATOM    843  N   ILE A 117      39.682  51.734  24.663  1.00 13.45           N  
ATOM    844  CA  ILE A 117      38.728  50.734  24.201  1.00 10.42           C  
ATOM    845  C   ILE A 117      39.500  49.637  23.469  1.00 15.13           C  
ATOM    846  O   ILE A 117      40.352  49.922  22.623  1.00 10.33           O  
ATOM    847  CB  ILE A 117      37.708  51.352  23.232  1.00  7.34           C  
ATOM    848  CG1 ILE A 117      36.982  52.517  23.914  1.00 13.55           C  
ATOM    849  CG2 ILE A 117      36.743  50.276  22.768  1.00  4.51           C  
ATOM    850  CD1 ILE A 117      36.280  53.486  22.953  1.00  6.31           C  
ATOM    851  N   PRO A 118      39.209  48.365  23.773  1.00 11.59           N  
ATOM    852  CA  PRO A 118      39.962  47.331  23.065  1.00 14.57           C  
ATOM    853  C   PRO A 118      39.535  47.168  21.612  1.00 16.81           C  
ATOM    854  O   PRO A 118      38.381  47.436  21.258  1.00 11.75           O  
ATOM    855  CB  PRO A 118      39.705  46.083  23.907  1.00 17.39           C  
ATOM    856  CG  PRO A 118      38.314  46.307  24.414  1.00 14.57           C  
ATOM    857  CD  PRO A 118      38.284  47.778  24.764  1.00 13.26           C  
ATOM    858  N   GLY A 119      40.494  46.759  20.780  1.00 16.62           N  
ATOM    859  CA  GLY A 119      40.241  46.518  19.368  1.00 15.86           C  
ATOM    860  C   GLY A 119      39.907  47.719  18.513  1.00 13.39           C  
ATOM    861  O   GLY A 119      39.263  47.571  17.473  1.00 12.55           O  
ATOM    862  N   VAL A 120      40.343  48.908  18.921  1.00 11.13           N  
ATOM    863  CA  VAL A 120      40.040  50.096  18.134  1.00 11.45           C  
ATOM    864  C   VAL A 120      41.210  50.504  17.243  1.00 12.57           C  
ATOM    865  O   VAL A 120      42.106  51.245  17.658  1.00  6.97           O  
ATOM    866  CB  VAL A 120      39.631  51.286  19.037  1.00 11.13           C  
ATOM    867  CG1 VAL A 120      39.336  52.503  18.183  1.00  9.91           C  
ATOM    868  CG2 VAL A 120      38.396  50.912  19.848  1.00 17.34           C  
ATOM    869  N   SER A 121      41.186  50.006  16.012  1.00  8.29           N  
ATOM    870  CA  SER A 121      42.224  50.300  15.035  1.00  6.83           C  
ATOM    871  C   SER A 121      41.788  49.824  13.666  1.00  5.94           C  
ATOM    872  O   SER A 121      40.844  49.029  13.539  1.00  5.10           O  
ATOM    873  CB  SER A 121      43.523  49.574  15.384  1.00  8.20           C  
ATOM    874  OG  SER A 121      43.405  48.188  15.089  1.00  7.57           O  
ATOM    875  N   GLU A 122      42.512  50.309  12.657  1.00  8.43           N  
ATOM    876  CA  GLU A 122      42.320  49.962  11.249  1.00 17.11           C  
ATOM    877  C   GLU A 122      42.324  48.450  11.079  1.00  9.59           C  
ATOM    878  O   GLU A 122      41.618  47.892  10.257  1.00  7.93           O  
ATOM    879  CB  GLU A 122      43.520  50.429  10.436  1.00 18.80           C  
ATOM    880  CG  GLU A 122      43.404  51.667   9.658  1.00 22.39           C  
ATOM    881  CD  GLU A 122      44.377  51.628   8.502  1.00  9.33           C  
ATOM    882  OE1 GLU A 122      45.541  51.195   8.695  1.00 13.99           O  
ATOM    883  OE2 GLU A 122      43.975  52.022   7.405  1.00 18.16           O  
ATOM    884  N   LEU A 123      43.204  47.818  11.839  1.00 12.14           N  
ATOM    885  CA  LEU A 123      43.428  46.385  11.778  1.00 11.16           C  
ATOM    886  C   LEU A 123      42.358  45.487  12.400  1.00 14.53           C  
ATOM    887  O   LEU A 123      42.022  44.440  11.839  1.00 11.52           O  
ATOM    888  CB  LEU A 123      44.771  46.081  12.441  1.00  7.70           C  
ATOM    889  CG  LEU A 123      45.999  46.843  11.924  1.00 13.07           C  
ATOM    890  CD1 LEU A 123      47.178  46.629  12.877  1.00 22.67           C  
ATOM    891  CD2 LEU A 123      46.362  46.365  10.541  1.00 14.77           C  
ATOM    892  N   GLU A 124      41.823  45.911  13.544  1.00 12.95           N  
ATOM    893  CA  GLU A 124      40.850  45.125  14.295  1.00 12.35           C  
ATOM    894  C   GLU A 124      39.401  45.581  14.260  1.00 14.13           C  
ATOM    895  O   GLU A 124      38.529  44.885  14.777  1.00 11.51           O  
ATOM    896  CB  GLU A 124      41.287  45.073  15.761  1.00  7.69           C  
ATOM    897  CG  GLU A 124      42.777  44.843  15.940  1.00 12.92           C  
ATOM    898  CD  GLU A 124      43.275  45.351  17.282  1.00 28.37           C  
ATOM    899  OE1 GLU A 124      43.396  44.543  18.233  1.00 18.15           O  
ATOM    900  OE2 GLU A 124      43.526  46.575  17.383  1.00 24.42           O  
ATOM    901  N   CYS A 125      39.129  46.732  13.658  1.00  9.61           N  
ATOM    902  CA  CYS A 125      37.766  47.247  13.651  1.00  9.11           C  
ATOM    903  C   CYS A 125      37.348  47.845  12.308  1.00 10.17           C  
ATOM    904  O   CYS A 125      38.138  48.533  11.656  1.00 10.47           O  
ATOM    905  CB  CYS A 125      37.649  48.290  14.772  1.00  8.56           C  
ATOM    906  SG  CYS A 125      36.056  49.107  14.901  1.00 13.39           S  
ATOM    907  N   GLY A 126      36.103  47.588  11.906  1.00  7.67           N  
ATOM    908  CA  GLY A 126      35.602  48.103  10.634  1.00  8.24           C  
ATOM    909  C   GLY A 126      35.199  49.574  10.573  1.00  6.67           C  
ATOM    910  O   GLY A 126      34.901  50.100   9.489  1.00  6.78           O  
ATOM    911  N   ASN A 127      35.157  50.240  11.719  1.00  4.84           N  
ATOM    912  CA  ASN A 127      34.798  51.667  11.775  1.00 14.07           C  
ATOM    913  C   ASN A 127      35.430  52.219  13.050  1.00  8.94           C  
ATOM    914  O   ASN A 127      34.737  52.716  13.930  1.00  7.58           O  
ATOM    915  CB  ASN A 127      33.262  51.852  11.811  1.00  6.32           C  
ATOM    916  CG  ASN A 127      32.837  53.296  11.511  1.00  8.88           C  
ATOM    917  OD1 ASN A 127      33.677  54.149  11.221  1.00 16.83           O  
ATOM    918  ND2 ASN A 127      31.536  53.567  11.576  1.00  4.76           N  
ATOM    919  N   TYR A 128      36.758  52.139  13.131  1.00 10.46           N  
ATOM    920  CA  TYR A 128      37.478  52.573  14.334  1.00 10.09           C  
ATOM    921  C   TYR A 128      37.277  54.027  14.752  1.00 10.73           C  
ATOM    922  O   TYR A 128      37.484  54.381  15.914  1.00 12.34           O  
ATOM    923  CB  TYR A 128      38.975  52.249  14.197  1.00  5.21           C  
ATOM    924  CG  TYR A 128      39.733  53.093  13.198  1.00  7.90           C  
ATOM    925  CD1 TYR A 128      40.232  54.345  13.558  1.00  7.60           C  
ATOM    926  CD2 TYR A 128      39.948  52.645  11.893  1.00  6.31           C  
ATOM    927  CE1 TYR A 128      40.928  55.135  12.647  1.00 11.51           C  
ATOM    928  CE2 TYR A 128      40.640  53.428  10.969  1.00 12.24           C  
ATOM    929  CZ  TYR A 128      41.127  54.676  11.357  1.00 11.52           C  
ATOM    930  OH  TYR A 128      41.800  55.466  10.460  1.00  7.05           O  
ATOM    931  N   ARG A 129      36.850  54.859  13.813  1.00 14.82           N  
ATOM    932  CA  ARG A 129      36.620  56.267  14.099  1.00 10.43           C  
ATOM    933  C   ARG A 129      35.297  56.491  14.837  1.00 10.50           C  
ATOM    934  O   ARG A 129      35.074  57.550  15.403  1.00 10.45           O  
ATOM    935  CB  ARG A 129      36.576  57.074  12.793  1.00 11.15           C  
ATOM    936  CG  ARG A 129      37.822  57.018  11.914  1.00 13.18           C  
ATOM    937  CD  ARG A 129      37.615  57.912  10.685  1.00  8.46           C  
ATOM    938  NE  ARG A 129      38.681  57.821   9.688  1.00 13.46           N  
ATOM    939  CZ  ARG A 129      38.741  56.903   8.725  1.00 26.09           C  
ATOM    940  NH1 ARG A 129      37.795  55.977   8.623  1.00 19.52           N  
ATOM    941  NH2 ARG A 129      39.731  56.928   7.835  1.00 12.86           N  
ATOM    942  N   ASP A 130      34.421  55.493  14.833  1.00 14.25           N  
ATOM    943  CA  ASP A 130      33.103  55.645  15.449  1.00 12.43           C  
ATOM    944  C   ASP A 130      32.976  55.015  16.841  1.00 13.59           C  
ATOM    945  O   ASP A 130      32.353  53.962  16.989  1.00 10.03           O  
ATOM    946  CB  ASP A 130      32.043  55.059  14.491  1.00  5.30           C  
ATOM    947  CG  ASP A 130      30.612  55.476  14.849  1.00 11.78           C  
ATOM    948  OD1 ASP A 130      30.372  56.674  15.105  1.00  9.59           O  
ATOM    949  OD2 ASP A 130      29.718  54.603  14.857  1.00  7.10           O  
ATOM    950  N   HIS A 131      33.556  55.670  17.852  1.00  5.08           N  
ATOM    951  CA  HIS A 131      33.506  55.171  19.230  1.00  7.36           C  
ATOM    952  C   HIS A 131      33.237  56.264  20.265  1.00 11.07           C  
ATOM    953  O   HIS A 131      33.506  57.435  20.024  1.00 10.99           O  
ATOM    954  CB  HIS A 131      34.820  54.469  19.581  1.00  7.18           C  
ATOM    955  CG  HIS A 131      34.914  53.063  19.071  1.00  7.32           C  
ATOM    956  ND1 HIS A 131      34.288  52.002  19.692  1.00  8.39           N  
ATOM    957  CD2 HIS A 131      35.525  52.554  17.973  1.00  2.00           C  
ATOM    958  CE1 HIS A 131      34.505  50.896  18.994  1.00  9.25           C  
ATOM    959  NE2 HIS A 131      35.250  51.206  17.946  1.00  8.47           N  
ATOM    960  N   ASP A 132      32.721  55.885  21.429  1.00 11.58           N  
ATOM    961  CA  ASP A 132      32.461  56.874  22.482  1.00 10.29           C  
ATOM    962  C   ASP A 132      32.471  56.199  23.845  1.00  9.12           C  
ATOM    963  O   ASP A 132      31.427  55.754  24.332  1.00  4.38           O  
ATOM    964  CB  ASP A 132      31.107  57.555  22.268  1.00 13.93           C  
ATOM    965  CG  ASP A 132      30.919  58.787  23.162  1.00 11.44           C  
ATOM    966  OD1 ASP A 132      31.520  58.850  24.257  1.00  8.91           O  
ATOM    967  OD2 ASP A 132      30.155  59.684  22.777  1.00 11.13           O  
ATOM    968  N   LEU A 133      33.655  56.125  24.450  1.00  4.65           N  
ATOM    969  CA  LEU A 133      33.828  55.502  25.753  1.00 10.95           C  
ATOM    970  C   LEU A 133      33.016  56.173  26.852  1.00  9.33           C  
ATOM    971  O   LEU A 133      32.361  55.502  27.636  1.00  7.10           O  
ATOM    972  CB  LEU A 133      35.309  55.501  26.156  1.00 11.87           C  
ATOM    973  CG  LEU A 133      35.614  54.900  27.536  1.00  8.99           C  
ATOM    974  CD1 LEU A 133      35.120  53.456  27.586  1.00  7.81           C  
ATOM    975  CD2 LEU A 133      37.118  54.957  27.810  1.00  8.04           C  
ATOM    976  N   ALA A 134      33.080  57.496  26.927  1.00 11.21           N  
ATOM    977  CA  ALA A 134      32.333  58.219  27.958  1.00  7.94           C  
ATOM    978  C   ALA A 134      30.845  57.871  27.942  1.00  8.01           C  
ATOM    979  O   ALA A 134      30.259  57.546  28.983  1.00  7.04           O  
ATOM    980  CB  ALA A 134      32.522  59.734  27.770  1.00 13.29           C  
ATOM    981  N   ALA A 135      30.227  57.936  26.767  1.00 12.53           N  
ATOM    982  CA  ALA A 135      28.802  57.636  26.656  1.00  7.33           C  
ATOM    983  C   ALA A 135      28.526  56.172  26.963  1.00  7.10           C  
ATOM    984  O   ALA A 135      27.491  55.843  27.537  1.00  9.50           O  
ATOM    985  CB  ALA A 135      28.290  57.990  25.263  1.00 11.31           C  
ATOM    986  N   ALA A 136      29.452  55.297  26.574  1.00  6.18           N  
ATOM    987  CA  ALA A 136      29.303  53.874  26.830  1.00 10.57           C  
ATOM    988  C   ALA A 136      29.295  53.653  28.344  1.00  9.89           C  
ATOM    989  O   ALA A 136      28.438  52.957  28.872  1.00  5.65           O  
ATOM    990  CB  ALA A 136      30.471  53.102  26.198  1.00  8.02           C  
ATOM    991  N   ARG A 137      30.264  54.256  29.029  1.00  5.78           N  
ATOM    992  CA  ARG A 137      30.370  54.125  30.477  1.00  7.38           C  
ATOM    993  C   ARG A 137      29.147  54.672  31.189  1.00  7.01           C  
ATOM    994  O   ARG A 137      28.652  54.054  32.137  1.00 10.81           O  
ATOM    995  CB  ARG A 137      31.612  54.854  30.985  1.00  9.99           C  
ATOM    996  CG  ARG A 137      32.920  54.314  30.431  1.00 13.11           C  
ATOM    997  CD  ARG A 137      34.106  55.098  30.972  1.00 11.78           C  
ATOM    998  NE  ARG A 137      34.275  54.932  32.415  1.00 11.08           N  
ATOM    999  CZ  ARG A 137      35.225  55.541  33.123  1.00 18.91           C  
ATOM   1000  NH1 ARG A 137      36.080  56.348  32.515  1.00 11.45           N  
ATOM   1001  NH2 ARG A 137      35.329  55.340  34.431  1.00  6.72           N  
ATOM   1002  N   GLN A 138      28.651  55.820  30.740  1.00  5.11           N  
ATOM   1003  CA  GLN A 138      27.490  56.407  31.385  1.00  4.46           C  
ATOM   1004  C   GLN A 138      26.232  55.557  31.188  1.00  9.40           C  
ATOM   1005  O   GLN A 138      25.399  55.467  32.091  1.00 10.16           O  
ATOM   1006  CB  GLN A 138      27.248  57.836  30.893  1.00  2.08           C  
ATOM   1007  CG  GLN A 138      26.235  58.595  31.738  1.00  6.92           C  
ATOM   1008  CD  GLN A 138      26.566  58.548  33.229  1.00 10.78           C  
ATOM   1009  OE1 GLN A 138      27.710  58.798  33.637  1.00 13.23           O  
ATOM   1010  NE2 GLN A 138      25.565  58.237  34.048  1.00  7.50           N  
ATOM   1011  N   HIS A 139      26.088  54.934  30.021  1.00  8.97           N  
ATOM   1012  CA  HIS A 139      24.926  54.079  29.778  1.00  9.20           C  
ATOM   1013  C   HIS A 139      24.955  52.904  30.755  1.00 10.54           C  
ATOM   1014  O   HIS A 139      23.906  52.490  31.259  1.00  7.89           O  
ATOM   1015  CB  HIS A 139      24.907  53.573  28.329  1.00 13.61           C  
ATOM   1016  CG  HIS A 139      24.261  54.524  27.372  1.00 11.40           C  
ATOM   1017  ND1 HIS A 139      22.925  54.854  27.445  1.00  9.77           N  
ATOM   1018  CD2 HIS A 139      24.763  55.223  26.325  1.00  6.83           C  
ATOM   1019  CE1 HIS A 139      22.632  55.713  26.487  1.00 14.69           C  
ATOM   1020  NE2 HIS A 139      23.732  55.955  25.793  1.00  8.43           N  
ATOM   1021  N   ALA A 140      26.147  52.363  31.017  1.00  5.37           N  
ATOM   1022  CA  ALA A 140      26.276  51.264  31.980  1.00  9.61           C  
ATOM   1023  C   ALA A 140      25.868  51.769  33.367  1.00 11.22           C  
ATOM   1024  O   ALA A 140      25.103  51.120  34.088  1.00  6.72           O  
ATOM   1025  CB  ALA A 140      27.723  50.742  32.018  1.00  7.93           C  
ATOM   1026  N   ARG A 141      26.373  52.941  33.732  1.00  8.05           N  
ATOM   1027  CA  ARG A 141      26.057  53.529  35.021  1.00  9.76           C  
ATOM   1028  C   ARG A 141      24.544  53.729  35.157  1.00 10.24           C  
ATOM   1029  O   ARG A 141      23.960  53.422  36.200  1.00  5.97           O  
ATOM   1030  CB  ARG A 141      26.794  54.868  35.164  1.00 21.01           C  
ATOM   1031  CG  ARG A 141      27.624  55.022  36.433  1.00 33.14           C  
ATOM   1032  CD  ARG A 141      29.072  55.432  36.126  1.00 33.58           C  
ATOM   1033  NE  ARG A 141      29.131  56.511  35.149  1.00 35.12           N  
ATOM   1034  CZ  ARG A 141      30.244  56.974  34.584  1.00 20.91           C  
ATOM   1035  NH1 ARG A 141      31.431  56.474  34.894  1.00 18.39           N  
ATOM   1036  NH2 ARG A 141      30.155  57.916  33.664  1.00 23.37           N  
ATOM   1037  N   ASP A 142      23.913  54.240  34.102  1.00  8.47           N  
ATOM   1038  CA  ASP A 142      22.470  54.478  34.111  1.00 10.51           C  
ATOM   1039  C   ASP A 142      21.687  53.187  34.363  1.00 12.05           C  
ATOM   1040  O   ASP A 142      20.680  53.196  35.074  1.00 10.47           O  
ATOM   1041  CB  ASP A 142      21.981  55.067  32.775  1.00 11.55           C  
ATOM   1042  CG  ASP A 142      22.439  56.497  32.548  1.00 19.83           C  
ATOM   1043  OD1 ASP A 142      22.824  57.163  33.521  1.00 16.44           O  
ATOM   1044  OD2 ASP A 142      22.392  56.958  31.389  1.00 14.20           O  
ATOM   1045  N   VAL A 143      22.126  52.082  33.766  1.00  5.88           N  
ATOM   1046  CA  VAL A 143      21.413  50.821  33.967  1.00  5.56           C  
ATOM   1047  C   VAL A 143      21.530  50.342  35.412  1.00  6.11           C  
ATOM   1048  O   VAL A 143      20.550  49.919  36.028  1.00  8.75           O  
ATOM   1049  CB  VAL A 143      21.924  49.737  33.022  1.00  6.66           C  
ATOM   1050  CG1 VAL A 143      21.402  48.360  33.476  1.00  5.52           C  
ATOM   1051  CG2 VAL A 143      21.452  50.051  31.596  1.00  9.30           C  
ATOM   1052  N   LEU A 144      22.730  50.422  35.957  1.00  6.50           N  
ATOM   1053  CA  LEU A 144      22.953  50.009  37.333  1.00  8.90           C  
ATOM   1054  C   LEU A 144      22.162  50.898  38.299  1.00  8.91           C  
ATOM   1055  O   LEU A 144      21.624  50.408  39.288  1.00  7.46           O  
ATOM   1056  CB  LEU A 144      24.456  50.057  37.647  1.00  4.46           C  
ATOM   1057  CG  LEU A 144      25.264  49.058  36.803  1.00 14.55           C  
ATOM   1058  CD1 LEU A 144      26.771  49.289  36.955  1.00 10.33           C  
ATOM   1059  CD2 LEU A 144      24.888  47.637  37.246  1.00 16.64           C  
ATOM   1060  N   ASP A 145      22.084  52.194  38.006  1.00  7.32           N  
ATOM   1061  CA  ASP A 145      21.346  53.127  38.870  1.00 15.52           C  
ATOM   1062  C   ASP A 145      19.858  52.789  38.912  1.00 14.33           C  
ATOM   1063  O   ASP A 145      19.224  52.798  39.975  1.00  7.95           O  
ATOM   1064  CB  ASP A 145      21.482  54.571  38.378  1.00 13.74           C  
ATOM   1065  CG  ASP A 145      22.861  55.145  38.610  1.00 26.98           C  
ATOM   1066  OD1 ASP A 145      23.526  54.719  39.580  1.00 26.83           O  
ATOM   1067  OD2 ASP A 145      23.267  56.039  37.832  1.00 25.39           O  
ATOM   1068  N   GLN A 146      19.309  52.526  37.732  1.00  9.20           N  
ATOM   1069  CA  GLN A 146      17.897  52.193  37.576  1.00 13.17           C  
ATOM   1070  C   GLN A 146      17.578  50.818  38.148  1.00  9.78           C  
ATOM   1071  O   GLN A 146      16.549  50.637  38.807  1.00  8.44           O  
ATOM   1072  CB  GLN A 146      17.525  52.283  36.096  1.00 10.37           C  
ATOM   1073  CG  GLN A 146      17.489  53.736  35.621  1.00 16.28           C  
ATOM   1074  CD  GLN A 146      17.487  53.877  34.116  1.00 20.36           C  
ATOM   1075  OE1 GLN A 146      16.793  53.151  33.410  1.00 27.40           O  
ATOM   1076  NE2 GLN A 146      18.255  54.831  33.617  1.00 22.71           N  
ATOM   1077  N   GLY A 147      18.468  49.858  37.904  1.00  6.98           N  
ATOM   1078  CA  GLY A 147      18.276  48.514  38.434  1.00  8.62           C  
ATOM   1079  C   GLY A 147      17.686  47.455  37.514  1.00  9.48           C  
ATOM   1080  O   GLY A 147      16.559  47.598  37.041  1.00  8.25           O  
ATOM   1081  N   LEU A 148      18.435  46.374  37.286  1.00  5.26           N  
ATOM   1082  CA  LEU A 148      17.980  45.275  36.424  1.00  7.18           C  
ATOM   1083  C   LEU A 148      16.971  44.353  37.106  1.00 12.01           C  
ATOM   1084  O   LEU A 148      16.872  44.318  38.330  1.00  2.00           O  
ATOM   1085  CB  LEU A 148      19.177  44.410  35.984  1.00  5.73           C  
ATOM   1086  CG  LEU A 148      20.192  45.059  35.032  1.00 10.24           C  
ATOM   1087  CD1 LEU A 148      21.519  44.313  35.085  1.00  7.54           C  
ATOM   1088  CD2 LEU A 148      19.614  45.095  33.623  1.00 10.10           C  
ATOM   1089  N   LYS A 149      16.220  43.610  36.298  1.00  9.46           N  
ATOM   1090  CA  LYS A 149      15.276  42.610  36.806  1.00  8.07           C  
ATOM   1091  C   LYS A 149      15.053  41.664  35.634  1.00 10.26           C  
ATOM   1092  O   LYS A 149      15.407  41.990  34.495  1.00  5.07           O  
ATOM   1093  CB  LYS A 149      13.937  43.229  37.260  1.00  6.77           C  
ATOM   1094  CG  LYS A 149      12.914  43.508  36.150  1.00  8.98           C  
ATOM   1095  CD  LYS A 149      13.281  44.726  35.312  1.00 10.31           C  
ATOM   1096  CE  LYS A 149      13.254  46.027  36.126  1.00 10.01           C  
ATOM   1097  NZ  LYS A 149      13.601  47.226  35.266  1.00  7.73           N  
ATOM   1098  N   VAL A 150      14.543  40.470  35.909  1.00  7.65           N  
ATOM   1099  CA  VAL A 150      14.287  39.528  34.837  1.00  5.24           C  
ATOM   1100  C   VAL A 150      12.899  39.889  34.336  1.00  6.64           C  
ATOM   1101  O   VAL A 150      11.945  39.894  35.100  1.00  6.90           O  
ATOM   1102  CB  VAL A 150      14.329  38.071  35.335  1.00  2.71           C  
ATOM   1103  CG1 VAL A 150      13.843  37.123  34.236  1.00  8.96           C  
ATOM   1104  CG2 VAL A 150      15.762  37.702  35.743  1.00 11.32           C  
ATOM   1105  N   GLN A 151      12.808  40.220  33.054  1.00  7.65           N  
ATOM   1106  CA  GLN A 151      11.550  40.634  32.438  1.00  2.21           C  
ATOM   1107  C   GLN A 151      10.789  39.471  31.819  1.00 10.70           C  
ATOM   1108  O   GLN A 151      11.355  38.709  31.027  1.00  5.64           O  
ATOM   1109  CB  GLN A 151      11.842  41.678  31.344  1.00  2.97           C  
ATOM   1110  CG  GLN A 151      10.621  42.017  30.469  1.00  6.11           C  
ATOM   1111  CD  GLN A 151       9.629  42.897  31.193  1.00 14.12           C  
ATOM   1112  OE1 GLN A 151       9.978  43.994  31.637  1.00  5.42           O  
ATOM   1113  NE2 GLN A 151       8.383  42.430  31.314  1.00  9.69           N  
ATOM   1114  N   GLU A 152       9.510  39.328  32.160  1.00  5.13           N  
ATOM   1115  CA  GLU A 152       8.761  38.244  31.565  1.00 11.85           C  
ATOM   1116  C   GLU A 152       8.327  38.693  30.181  1.00  7.31           C  
ATOM   1117  O   GLU A 152       8.146  39.889  29.928  1.00 13.46           O  
ATOM   1118  CB  GLU A 152       7.550  37.868  32.413  1.00 18.90           C  
ATOM   1119  CG  GLU A 152       6.521  38.935  32.581  1.00 29.21           C  
ATOM   1120  CD  GLU A 152       5.427  38.494  33.533  1.00 39.48           C  
ATOM   1121  OE1 GLU A 152       5.768  38.086  34.665  1.00 47.62           O  
ATOM   1122  OE2 GLU A 152       4.236  38.556  33.157  1.00 33.10           O  
ATOM   1123  N   THR A 153       8.191  37.741  29.275  1.00  5.67           N  
ATOM   1124  CA  THR A 153       7.780  38.079  27.933  1.00 13.08           C  
ATOM   1125  C   THR A 153       6.268  38.133  27.863  1.00  8.49           C  
ATOM   1126  O   THR A 153       5.603  37.136  28.084  1.00 12.79           O  
ATOM   1127  CB  THR A 153       8.265  37.049  26.898  1.00 10.40           C  
ATOM   1128  OG1 THR A 153       9.695  37.071  26.820  1.00 12.33           O  
ATOM   1129  CG2 THR A 153       7.679  37.372  25.540  1.00  9.84           C  
ATOM   1130  N   ILE A 154       5.742  39.315  27.580  1.00  7.77           N  
ATOM   1131  CA  ILE A 154       4.311  39.513  27.422  1.00 11.98           C  
ATOM   1132  C   ILE A 154       4.111  39.418  25.901  1.00 15.77           C  
ATOM   1133  O   ILE A 154       4.616  40.273  25.157  1.00 11.85           O  
ATOM   1134  CB  ILE A 154       3.875  40.923  27.901  1.00 13.60           C  
ATOM   1135  CG1 ILE A 154       4.287  41.139  29.363  1.00 21.84           C  
ATOM   1136  CG2 ILE A 154       2.372  41.074  27.742  1.00 15.31           C  
ATOM   1137  CD1 ILE A 154       3.635  40.184  30.338  1.00 31.25           C  
ATOM   1138  N   LEU A 155       3.418  38.377  25.441  1.00  8.70           N  
ATOM   1139  CA  LEU A 155       3.183  38.183  24.001  1.00 14.57           C  
ATOM   1140  C   LEU A 155       2.072  39.053  23.424  1.00 10.70           C  
ATOM   1141  O   LEU A 155       1.188  39.507  24.143  1.00 10.86           O  
ATOM   1142  CB  LEU A 155       2.809  36.731  23.683  1.00 22.78           C  
ATOM   1143  CG  LEU A 155       3.753  35.526  23.794  1.00 23.75           C  
ATOM   1144  CD1 LEU A 155       5.083  35.884  23.160  1.00 11.28           C  
ATOM   1145  CD2 LEU A 155       3.933  35.138  25.239  1.00 32.89           C  
ATOM   1146  N   LEU A 156       2.138  39.272  22.113  1.00 16.57           N  
ATOM   1147  CA  LEU A 156       1.124  40.037  21.377  1.00 21.19           C  
ATOM   1148  C   LEU A 156      -0.057  39.089  21.154  1.00 24.45           C  
ATOM   1149  O   LEU A 156       0.139  37.976  20.684  1.00 29.90           O  
ATOM   1150  CB  LEU A 156       1.691  40.480  20.021  1.00 15.95           C  
ATOM   1151  CG  LEU A 156       2.705  41.623  20.090  1.00 15.94           C  
ATOM   1152  CD1 LEU A 156       3.382  41.836  18.736  1.00 16.36           C  
ATOM   1153  CD2 LEU A 156       1.974  42.894  20.524  1.00 12.02           C  
ATOM   1154  N   GLU A 157      -1.274  39.526  21.470  1.00 28.14           N  
ATOM   1155  CA  GLU A 157      -2.448  38.666  21.305  1.00 31.42           C  
ATOM   1156  C   GLU A 157      -2.695  38.331  19.839  1.00 34.73           C  
ATOM   1157  O   GLU A 157      -3.165  37.234  19.513  1.00 32.07           O  
ATOM   1158  CB  GLU A 157      -3.705  39.310  21.921  1.00 40.75           C  
ATOM   1159  CG  GLU A 157      -3.670  39.388  23.463  1.00 46.75           C  
ATOM   1160  N   ARG A 158      -2.376  39.268  18.950  1.00 26.83           N  
ATOM   1161  CA  ARG A 158      -2.557  39.027  17.522  1.00 27.15           C  
ATOM   1162  C   ARG A 158      -4.010  38.656  17.221  1.00 32.82           C  
ATOM   1163  O   ARG A 158      -4.914  39.277  17.827  1.00 36.19           O  
ATOM   1164  CB  ARG A 158      -1.638  37.897  17.072  1.00 17.53           C  
ATOM   1165  CG  ARG A 158      -0.151  38.171  17.247  1.00 20.04           C  
ATOM   1166  CD  ARG A 158       0.335  39.243  16.288  1.00 17.48           C  
ATOM   1167  NE  ARG A 158       1.791  39.399  16.318  1.00 13.96           N  
ATOM   1168  CZ  ARG A 158       2.468  40.163  15.468  1.00 26.49           C  
ATOM   1169  NH1 ARG A 158       1.818  40.833  14.525  1.00 19.25           N  
ATOM   1170  NH2 ARG A 158       3.790  40.267  15.564  1.00 17.46           N  
TER    1171      ARG A 158                                                      
END
MOLECULE T0427_239_422.pdb
ATOM   1932  N   VAL   239       7.508  44.077  31.130  1.00 44.20          
ATOM   1933  CA  VAL   239       7.787  42.698  31.482  1.00 43.65          
ATOM   1934  C   VAL   239       8.702  42.088  30.403  1.00 42.68          
ATOM   1935  O   VAL   239       8.478  42.304  29.208  1.00 43.11          
ATOM   1936  CB  VAL   239       6.466  41.902  31.634  1.00 44.10          
ATOM   1937  CG1 VAL   239       6.727  40.413  31.842  1.00 46.16          
ATOM   1938  CG2 VAL   239       5.627  42.453  32.795  1.00 44.20          
ATOM   1939  N   ILE   240       9.734  41.358  30.816  1.00 40.50          
ATOM   1940  CA  ILE   240      10.567  40.601  29.875  1.00 39.74          
ATOM   1941  C   ILE   240       9.833  39.360  29.337  1.00 38.98          
ATOM   1942  O   ILE   240       9.300  38.585  30.126  1.00 38.48          
ATOM   1943  CB  ILE   240      11.877  40.182  30.544  1.00 39.33          
ATOM   1944  CG1 ILE   240      12.705  41.438  30.844  1.00 39.34          
ATOM   1945  CG2 ILE   240      12.670  39.181  29.672  1.00 40.59          
ATOM   1946  CD  ILE   240      13.617  41.328  32.023  1.00 41.99          
ATOM   1947  N   GLU   241       9.788  39.183  28.011  1.00 37.65          
ATOM   1948  CA  GLU   241       9.241  37.942  27.430  1.00 37.69          
ATOM   1949  C   GLU   241      10.322  36.875  27.305  1.00 37.80          
ATOM   1950  O   GLU   241      11.374  37.109  26.716  1.00 36.23          
ATOM   1951  CB  GLU   241       8.587  38.193  26.063  1.00 37.10          
ATOM   1952  CG  GLU   241       7.299  39.023  26.143  1.00 41.46          
ATOM   1953  CD  GLU   241       6.143  38.323  26.891  1.00 44.16          
ATOM   1954  OE1 GLU   241       5.450  39.042  27.647  1.00 47.58          
ATOM   1955  OE2 GLU   241       5.922  37.087  26.730  1.00 45.18          
ATOM   1956  N   GLU   242      10.050  35.692  27.853  1.00 38.66          
ATOM   1957  CA  GLU   242      10.977  34.557  27.790  1.00 40.17          
ATOM   1958  C   GLU   242      10.291  33.430  27.029  1.00 40.00          
ATOM   1959  O   GLU   242       9.134  33.068  27.343  1.00 39.65          
ATOM   1960  CB  GLU   242      11.330  34.090  29.200  1.00 40.47          
ATOM   1961  CG  GLU   242      11.625  35.238  30.159  1.00 42.17          
ATOM   1962  CD  GLU   242      12.192  34.804  31.516  1.00 44.28          
ATOM   1963  OE1 GLU   242      12.716  33.672  31.637  1.00 48.59          
ATOM   1964  OE2 GLU   242      12.131  35.621  32.468  1.00 49.45          
ATOM   1965  N   ARG   243      10.939  32.944  25.973  1.00 38.26          
ATOM   1966  CA  ARG   243      10.411  31.813  25.221  1.00 37.65          
ATOM   1967  C   ARG   243      11.445  30.693  25.226  1.00 37.37          
ATOM   1968  O   ARG   243      12.654  30.954  25.210  1.00 36.14          
ATOM   1969  CB  ARG   243      10.044  32.200  23.783  1.00 37.67          
ATOM   1970  CG  ARG   243       9.050  33.383  23.669  1.00 40.69          
ATOM   1971  CD  ARG   243       7.597  32.942  23.779  1.00 44.58          
ATOM   1972  NE  ARG   243       6.666  33.994  23.362  1.00 47.29          
ATOM   1973  CZ  ARG   243       6.256  34.973  24.159  1.00 51.25          
ATOM   1974  NH1 ARG   243       6.694  35.031  25.425  1.00 52.88          
ATOM   1975  NH2 ARG   243       5.400  35.893  23.705  1.00 50.13          
ATOM   1976  N   THR   244      10.966  29.451  25.238  1.00 37.08          
ATOM   1977  CA  THR   244      11.841  28.273  25.171  1.00 36.93          
ATOM   1978  C   THR   244      11.354  27.305  24.104  1.00 37.31          
ATOM   1979  O   THR   244      10.141  27.124  23.927  1.00 35.94          
ATOM   1980  CB  THR   244      11.863  27.511  26.497  1.00 38.09          
ATOM   1981  OG1 THR   244      12.150  28.421  27.571  1.00 39.14          
ATOM   1982  CG2 THR   244      12.932  26.406  26.465  1.00 36.76          
ATOM   1983  N   GLU   245      12.300  26.702  23.387  1.00 36.36          
ATOM   1984  CA  GLU   245      11.998  25.604  22.486  1.00 37.49          
ATOM   1985  C   GLU   245      12.951  24.470  22.794  1.00 36.30          
ATOM   1986  O   GLU   245      14.119  24.702  23.114  1.00 35.56          
ATOM   1987  CB  GLU   245      12.117  26.030  21.021  1.00 37.44          
ATOM   1988  CG  GLU   245      11.135  27.133  20.621  1.00 40.68          
ATOM   1989  CD  GLU   245      11.231  27.530  19.158  1.00 40.63          
ATOM   1990  OE1 GLU   245      11.899  26.814  18.383  1.00 42.77          
ATOM   1991  OE2 GLU   245      10.648  28.583  18.793  1.00 45.07          
ATOM   1992  N   ARG   246      12.450  23.242  22.703  1.00 36.03          
ATOM   1993  CA  ARG   246      13.275  22.067  22.923  1.00 36.10          
ATOM   1994  C   ARG   246      13.544  21.348  21.624  1.00 35.88          
ATOM   1995  O   ARG   246      12.630  21.174  20.806  1.00 34.82          
ATOM   1996  CB  ARG   246      12.582  21.110  23.878  1.00 37.21          
ATOM   1997  CG  ARG   246      12.424  21.627  25.300  1.00 42.49          
ATOM   1998  CD  ARG   246      12.076  20.460  26.249  1.00 51.21          
ATOM   1999  NE  ARG   246      13.285  19.767  26.704  1.00 56.98          
ATOM   2000  CZ  ARG   246      13.751  19.769  27.960  1.00 60.20          
ATOM   2001  NH1 ARG   246      13.099  20.416  28.935  1.00 60.89          
ATOM   2002  NH2 ARG   246      14.880  19.120  28.245  1.00 59.94          
ATOM   2003  N   GLU   247      14.803  20.920  21.446  1.00 35.20          
ATOM   2004  CA  GLU   247      15.238  20.217  20.248  1.00 34.88          
ATOM   2005  C   GLU   247      16.340  19.280  20.680  1.00 32.66          
ATOM   2006  O   GLU   247      16.966  19.461  21.731  1.00 31.35          
ATOM   2007  CB  GLU   247      15.850  21.190  19.214  1.00 35.75          
ATOM   2008  CG  GLU   247      14.893  22.117  18.475  1.00 38.70          
ATOM   2009  CD  GLU   247      15.533  22.724  17.218  1.00 39.16          
ATOM   2010  OE1 GLU   247      16.473  22.083  16.677  1.00 43.16          
ATOM   2011  OE2 GLU   247      15.087  23.818  16.774  1.00 43.40          
ATOM   2012  N   VAL   248      16.604  18.286  19.850  1.00 31.09          
ATOM   2013  CA  VAL   248      17.706  17.358  20.105  1.00 29.35          
ATOM   2014  C   VAL   248      18.955  18.124  19.705  1.00 29.32          
ATOM   2015  O   VAL   248      19.103  18.498  18.536  1.00 29.39          
ATOM   2016  CB  VAL   248      17.586  16.084  19.282  1.00 28.96          
ATOM   2017  CG1 VAL   248      18.760  15.176  19.576  1.00 29.59          
ATOM   2018  CG2 VAL   248      16.247  15.327  19.582  1.00 29.10          
ATOM   2019  N   LEU   249      19.835  18.398  20.663  1.00 27.90          
ATOM   2020  CA  LEU   249      21.010  19.240  20.375  1.00 28.12          
ATOM   2021  C   LEU   249      22.129  18.743  21.232  1.00 28.43          
ATOM   2022  O   LEU   249      21.871  18.142  22.268  1.00 29.00          
ATOM   2023  CB  LEU   249      20.738  20.693  20.768  1.00 27.42          
ATOM   2024  CG  LEU   249      19.503  21.465  20.282  1.00 28.44          
ATOM   2025  CD1 LEU   249      19.241  22.674  21.169  1.00 31.50          
ATOM   2026  CD2 LEU   249      19.657  21.883  18.834  1.00 32.41          
ATOM   2027  N   ALA   250      23.373  19.001  20.830  1.00 28.87          
ATOM   2028  CA  ALA   250      24.511  18.702  21.703  1.00 29.02          
ATOM   2029  C   ALA   250      24.910  19.897  22.568  1.00 30.37          
ATOM   2030  O   ALA   250      25.784  19.766  23.423  1.00 30.07          
ATOM   2031  CB  ALA   250      25.690  18.216  20.907  1.00 29.15          
ATOM   2032  N   GLN   251      24.252  21.040  22.362  1.00 30.05          
ATOM   2033  CA  GLN   251      24.577  22.295  23.034  1.00 31.17          
ATOM   2034  C   GLN   251      23.326  23.171  23.005  1.00 30.75          
ATOM   2035  O   GLN   251      22.716  23.327  21.942  1.00 30.09          
ATOM   2036  CB  GLN   251      25.693  23.029  22.255  1.00 31.64          
ATOM   2037  CG  GLN   251      26.287  24.217  22.971  1.00 34.37          
ATOM   2038  CD  GLN   251      27.367  24.929  22.144  1.00 33.35          
ATOM   2039  OE1 GLN   251      27.118  25.962  21.536  1.00 36.34          
ATOM   2040  NE2 GLN   251      28.557  24.364  22.125  1.00 38.19          
ATOM   2041  N   SER   252      22.946  23.745  24.149  1.00 29.67          
ATOM   2042  CA  SER   252      21.772  24.643  24.196  1.00 29.85          
ATOM   2043  C   SER   252      22.181  26.053  23.814  1.00 29.12          
ATOM   2044  O   SER   252      23.356  26.399  23.889  1.00 29.94          
ATOM   2045  CB  SER   252      21.144  24.644  25.590  1.00 29.89          
ATOM   2046  OG  SER   252      20.656  23.348  25.915  1.00 29.23          
ATOM   2047  N   LYS   253      21.225  26.867  23.399  1.00 28.74          
ATOM   2048  CA  LYS   253      21.474  28.264  23.075  1.00 29.02          
ATOM   2049  C   LYS   253      20.706  29.137  24.031  1.00 29.26          
ATOM   2050  O   LYS   253      19.524  28.890  24.298  1.00 28.51          
ATOM   2051  CB  LYS   253      21.041  28.591  21.641  1.00 29.02          
ATOM   2052  CG  LYS   253      21.607  27.633  20.587  1.00 30.62          
ATOM   2053  CD  LYS   253      23.126  27.648  20.589  1.00 35.83          
ATOM   2054  CE  LYS   253      23.758  26.793  19.494  1.00 34.74          
ATOM   2055  NZ  LYS   253      25.270  26.861  19.623  1.00 36.49          
ATOM   2056  N   LEU   254      21.365  30.159  24.559  1.00 28.97          
ATOM   2057  CA  LEU   254      20.651  31.099  25.418  1.00 29.63          
ATOM   2058  C   LEU   254      20.949  32.519  24.967  1.00 29.75          
ATOM   2059  O   LEU   254      22.088  32.994  25.085  1.00 28.73          
ATOM   2060  CB  LEU   254      21.020  30.862  26.912  1.00 28.85          
ATOM   2061  CG  LEU   254      20.418  31.852  27.934  1.00 29.89          
ATOM   2062  CD1 LEU   254      18.844  31.801  27.934  1.00 30.25          
ATOM   2063  CD2 LEU   254      20.983  31.596  29.355  1.00 29.13          
ATOM   2064  N   ASN   255      19.929  33.188  24.440  1.00 29.28          
ATOM   2065  CA  ASN   255      20.103  34.514  23.847  1.00 30.80          
ATOM   2066  C   ASN   255      19.217  35.569  24.510  1.00 29.92          
ATOM   2067  O   ASN   255      18.113  35.263  24.992  1.00 29.28          
ATOM   2068  CB  ASN   255      19.783  34.482  22.332  1.00 31.58          
ATOM   2069  CG  ASN   255      20.674  33.522  21.557  1.00 33.90          
ATOM   2070  OD1 ASN   255      21.798  33.186  21.973  1.00 32.64          
ATOM   2071  ND2 ASN   255      20.172  33.075  20.397  1.00 38.01          
ATOM   2072  N   LEU   256      19.676  36.814  24.497  1.00 28.94          
ATOM   2073  CA  LEU   256      18.983  37.916  25.199  1.00 29.27          
ATOM   2074  C   LEU   256      18.965  39.110  24.268  1.00 30.24          
ATOM   2075  O   LEU   256      19.972  39.401  23.601  1.00 30.60          
ATOM   2076  CB  LEU   256      19.723  38.338  26.478  1.00 28.64          
ATOM   2077  CG  LEU   256      19.895  37.394  27.668  1.00 30.77          
ATOM   2078  CD1 LEU   256      20.969  36.320  27.388  1.00 33.18          
ATOM   2079  CD2 LEU   256      20.308  38.217  28.843  1.00 34.16          
ATOM   2080  N   ALA   257      17.841  39.819  24.262  1.00 30.48          
ATOM   2081  CA  ALA   257      17.683  41.019  23.464  1.00 30.03          
ATOM   2082  C   ALA   257      17.320  42.191  24.354  1.00 30.37          
ATOM   2083  O   ALA   257      16.376  42.116  25.158  1.00 30.37          
ATOM   2084  CB  ALA   257      16.608  40.817  22.414  1.00 29.21          
ATOM   2085  N   TYR   258      18.023  43.301  24.142  1.00 30.34          
ATOM   2086  CA  TYR   258      17.840  44.517  24.902  1.00 30.03          
ATOM   2087  C   TYR   258      17.460  45.659  23.983  1.00 30.54          
ATOM   2088  O   TYR   258      17.989  45.744  22.875  1.00 31.06          
ATOM   2089  CB  TYR   258      19.180  44.922  25.505  1.00 30.81          
ATOM   2090  CG  TYR   258      19.836  43.950  26.451  1.00 32.53          
ATOM   2091  CD1 TYR   258      19.739  44.114  27.829  1.00 32.22          
ATOM   2092  CD2 TYR   258      20.617  42.906  25.962  1.00 33.22          
ATOM   2093  CE1 TYR   258      20.374  43.228  28.697  1.00 31.01          
ATOM   2094  CE2 TYR   258      21.276  42.027  26.817  1.00 32.91          
ATOM   2095  CZ  TYR   258      21.153  42.204  28.173  1.00 33.59          
ATOM   2096  OH  TYR   258      21.820  41.336  28.995  1.00 34.71          
ATOM   2097  N   ASN   259      16.573  46.541  24.440  1.00 30.09          
ATOM   2098  CA  ASN   259      16.287  47.787  23.733  1.00 31.50          
ATOM   2099  C   ASN   259      17.397  48.788  24.114  1.00 31.75          
ATOM   2100  O   ASN   259      17.690  48.982  25.306  1.00 31.29          
ATOM   2101  CB  ASN   259      14.902  48.312  24.149  1.00 31.29          
ATOM   2102  CG  ASN   259      14.498  49.592  23.418  1.00 31.83          
ATOM   2103  OD1 ASN   259      15.001  50.668  23.700  1.00 35.07          
ATOM   2104  ND2 ASN   259      13.566  49.471  22.509  1.00 33.70          
ATOM   2105  N   THR   260      18.028  49.389  23.121  1.00 31.14          
ATOM   2106  CA  THR   260      19.027  50.410  23.391  1.00 31.60          
ATOM   2107  C   THR   260      18.484  51.797  23.134  1.00 32.99          
ATOM   2108  O   THR   260      19.014  52.766  23.674  1.00 33.26          
ATOM   2109  CB  THR   260      20.264  50.255  22.488  1.00 30.78          
ATOM   2110  OG1 THR   260      19.845  50.443  21.127  1.00 33.19          
ATOM   2111  CG2 THR   260      20.919  48.861  22.638  1.00 31.92          
ATOM   2112  N   ASP   261      17.472  51.889  22.274  1.00 32.55          
ATOM   2113  CA  ASP   261      17.011  53.160  21.745  1.00 34.62          
ATOM   2114  C   ASP   261      18.165  54.046  21.182  1.00 33.79          
ATOM   2115  O   ASP   261      18.068  55.259  21.208  1.00 33.21          
ATOM   2116  CB  ASP   261      16.219  53.885  22.849  1.00 35.46          
ATOM   2117  CG  ASP   261      15.294  54.964  22.310  1.00 41.96          
ATOM   2118  OD1 ASP   261      14.602  54.721  21.278  1.00 47.86          
ATOM   2119  OD2 ASP   261      15.251  56.052  22.943  1.00 45.28          
ATOM   2120  N   ILE   262      19.253  53.444  20.683  1.00 32.97          
ATOM   2121  CA  ILE   262      20.347  54.230  20.110  1.00 31.84          
ATOM   2122  C   ILE   262      20.524  53.911  18.624  1.00 31.61          
ATOM   2123  O   ILE   262      20.659  52.749  18.247  1.00 31.50          
ATOM   2124  CB  ILE   262      21.684  54.011  20.859  1.00 31.44          
ATOM   2125  CG1 ILE   262      21.585  54.517  22.321  1.00 32.03          
ATOM   2126  CG2 ILE   262      22.842  54.719  20.135  1.00 31.03          
ATOM   2127  CD  ILE   262      22.683  53.917  23.205  1.00 31.38          
ATOM   2128  N   TYR   263      20.572  54.960  17.801  1.00 30.82          
ATOM   2129  CA  TYR   263      20.542  54.804  16.339  1.00 31.05          
ATOM   2130  C   TYR   263      21.719  55.463  15.682  1.00 30.28          
ATOM   2131  O   TYR   263      22.391  56.310  16.282  1.00 30.66          
ATOM   2132  CB  TYR   263      19.230  55.352  15.750  1.00 30.17          
ATOM   2133  CG  TYR   263      18.043  54.523  16.212  1.00 31.87          
ATOM   2134  CD1 TYR   263      17.524  53.514  15.406  1.00 32.53          
ATOM   2135  CD2 TYR   263      17.475  54.724  17.469  1.00 32.34          
ATOM   2136  CE1 TYR   263      16.462  52.724  15.836  1.00 33.41          
ATOM   2137  CE2 TYR   263      16.401  53.940  17.918  1.00 32.07          
ATOM   2138  CZ  TYR   263      15.906  52.949  17.101  1.00 33.33          
ATOM   2139  OH  TYR   263      14.856  52.169  17.524  1.00 32.87          
ATOM   2140  N   TYR   264      21.969  55.062  14.445  1.00 30.34          
ATOM   2141  CA  TYR   264      23.004  55.640  13.621  1.00 30.95          
ATOM   2142  C   TYR   264      22.798  57.160  13.638  1.00 30.47          
ATOM   2143  O   TYR   264      21.683  57.623  13.460  1.00 29.62          
ATOM   2144  CB  TYR   264      22.821  55.118  12.208  1.00 31.65          
ATOM   2145  CG  TYR   264      23.897  55.485  11.246  1.00 33.50          
ATOM   2146  CD1 TYR   264      25.048  54.705  11.120  1.00 34.41          
ATOM   2147  CD2 TYR   264      23.755  56.605  10.439  1.00 35.73          
ATOM   2148  CE1 TYR   264      26.040  55.046  10.186  1.00 37.65          
ATOM   2149  CE2 TYR   264      24.712  56.964   9.510  1.00 37.85          
ATOM   2150  CZ  TYR   264      25.859  56.191   9.384  1.00 36.18          
ATOM   2151  OH  TYR   264      26.768  56.573   8.426  1.00 34.72          
ATOM   2152  N   GLY   265      23.860  57.917  13.874  1.00 31.20          
ATOM   2153  CA  GLY   265      23.747  59.374  13.952  1.00 30.91          
ATOM   2154  C   GLY   265      23.267  59.978  15.276  1.00 32.09          
ATOM   2155  O   GLY   265      23.192  61.206  15.407  1.00 32.15          
ATOM   2156  N   ASP   266      22.953  59.143  16.262  1.00 30.80          
ATOM   2157  CA  ASP   266      22.510  59.627  17.595  1.00 30.73          
ATOM   2158  C   ASP   266      23.702  60.032  18.463  1.00 29.96          
ATOM   2159  O   ASP   266      24.813  59.572  18.258  1.00 30.86          
ATOM   2160  CB  ASP   266      21.749  58.537  18.353  1.00 30.44          
ATOM   2161  CG  ASP   266      20.268  58.453  17.976  1.00 34.30          
ATOM   2162  OD1 ASP   266      19.806  59.291  17.183  1.00 34.97          
ATOM   2163  OD2 ASP   266      19.575  57.514  18.464  1.00 33.93          
ATOM   2164  N   SER   267      23.432  60.856  19.468  1.00 29.13          
ATOM   2165  CA  SER   267      24.416  61.293  20.447  1.00 29.13          
ATOM   2166  C   SER   267      25.303  60.181  21.039  1.00 29.36          
ATOM   2167  O   SER   267      26.529  60.343  21.068  1.00 29.88          
ATOM   2168  CB  SER   267      23.699  62.062  21.553  1.00 28.22          
ATOM   2169  OG  SER   267      23.039  63.201  20.968  1.00 31.24          
ATOM   2170  N   TYR   268      24.684  59.078  21.474  1.00 28.35          
ATOM   2171  CA  TYR   268      25.386  57.942  22.065  1.00 29.54          
ATOM   2172  C   TYR   268      25.795  56.831  21.099  1.00 29.69          
ATOM   2173  O   TYR   268      26.213  55.736  21.532  1.00 30.19          
ATOM   2174  CB  TYR   268      24.613  57.385  23.273  1.00 30.26          
ATOM   2175  CG  TYR   268      24.723  58.333  24.469  1.00 31.41          
ATOM   2176  CD1 TYR   268      25.829  58.275  25.331  1.00 32.05          
ATOM   2177  CD2 TYR   268      23.755  59.322  24.703  1.00 32.10          
ATOM   2178  CE1 TYR   268      25.968  59.163  26.424  1.00 31.54          
ATOM   2179  CE2 TYR   268      23.885  60.215  25.791  1.00 32.56          
ATOM   2180  CZ  TYR   268      25.002  60.120  26.639  1.00 32.39          
ATOM   2181  OH  TYR   268      25.152  60.982  27.713  1.00 32.90          
ATOM   2182  N   TYR   269      25.723  57.117  19.801  1.00 29.89          
ATOM   2183  CA  TYR   269      26.144  56.127  18.784  1.00 30.14          
ATOM   2184  C   TYR   269      27.558  55.608  19.040  1.00 29.64          
ATOM   2185  O   TYR   269      27.781  54.398  19.067  1.00 29.25          
ATOM   2186  CB  TYR   269      26.027  56.701  17.374  1.00 30.46          
ATOM   2187  CG  TYR   269      26.498  55.723  16.294  1.00 31.24          
ATOM   2188  CD1 TYR   269      25.662  54.711  15.824  1.00 31.02          
ATOM   2189  CD2 TYR   269      27.791  55.807  15.779  1.00 32.79          
ATOM   2190  CE1 TYR   269      26.112  53.794  14.814  1.00 34.02          
ATOM   2191  CE2 TYR   269      28.255  54.918  14.798  1.00 36.23          
ATOM   2192  CZ  TYR   269      27.414  53.908  14.335  1.00 32.73          
ATOM   2193  OH  TYR   269      27.900  53.093  13.349  1.00 34.05          
ATOM   2194  N   PHE   270      28.540  56.504  19.176  1.00 29.44          
ATOM   2195  CA  PHE   270      29.931  56.052  19.363  1.00 29.67          
ATOM   2196  C   PHE   270      30.165  55.372  20.719  1.00 29.42          
ATOM   2197  O   PHE   270      30.835  54.322  20.797  1.00 28.90          
ATOM   2198  CB  PHE   270      30.930  57.211  19.115  1.00 29.38          
ATOM   2199  CG  PHE   270      31.027  57.570  17.678  1.00 31.35          
ATOM   2200  CD1 PHE   270      31.921  56.892  16.840  1.00 32.72          
ATOM   2201  CD2 PHE   270      30.171  58.535  17.126  1.00 32.01          
ATOM   2202  CE1 PHE   270      31.978  57.174  15.486  1.00 32.44          
ATOM   2203  CE2 PHE   270      30.217  58.823  15.762  1.00 31.01          
ATOM   2204  CZ  PHE   270      31.120  58.153  14.952  1.00 31.15          
ATOM   2205  N   ALA   271      29.592  55.962  21.775  1.00 29.00          
ATOM   2206  CA  ALA   271      29.592  55.345  23.117  1.00 30.26          
ATOM   2207  C   ALA   271      29.059  53.897  23.077  1.00 29.93          
ATOM   2208  O   ALA   271      29.555  53.021  23.774  1.00 29.98          
ATOM   2209  CB  ALA   271      28.737  56.204  24.084  1.00 29.72          
ATOM   2210  N   LEU   272      28.048  53.667  22.249  1.00 29.86          
ATOM   2211  CA  LEU   272      27.454  52.312  22.129  1.00 30.26          
ATOM   2212  C   LEU   272      28.424  51.349  21.438  1.00 30.18          
ATOM   2213  O   LEU   272      28.574  50.188  21.846  1.00 29.51          
ATOM   2214  CB  LEU   272      26.115  52.375  21.391  1.00 30.27          
ATOM   2215  CG  LEU   272      25.495  51.021  21.002  1.00 29.15          
ATOM   2216  CD1 LEU   272      25.027  50.324  22.283  1.00 30.49          
ATOM   2217  CD2 LEU   272      24.304  51.273  20.049  1.00 30.51          
ATOM   2218  N   GLN   273      29.133  51.859  20.427  1.00 31.18          
ATOM   2219  CA  GLN   273      30.155  51.067  19.740  1.00 32.14          
ATOM   2220  C   GLN   273      31.157  50.519  20.784  1.00 32.12          
ATOM   2221  O   GLN   273      31.488  49.336  20.791  1.00 32.47          
ATOM   2222  CB  GLN   273      30.873  51.936  18.697  1.00 32.85          
ATOM   2223  CG  GLN   273      29.995  52.423  17.533  1.00 35.46          
ATOM   2224  CD  GLN   273      29.579  51.274  16.624  1.00 43.02          
ATOM   2225  OE1 GLN   273      30.268  50.243  16.543  1.00 44.33          
ATOM   2226  NE2 GLN   273      28.449  51.429  15.952  1.00 44.10          
ATOM   2227  N   VAL   274      31.604  51.403  21.665  1.00 30.94          
ATOM   2228  CA  VAL   274      32.594  51.062  22.665  1.00 30.67          
ATOM   2229  C   VAL   274      31.960  50.196  23.744  1.00 30.30          
ATOM   2230  O   VAL   274      32.550  49.178  24.127  1.00 30.02          
ATOM   2231  CB  VAL   274      33.297  52.329  23.248  1.00 31.58          
ATOM   2232  CG1 VAL   274      34.306  51.951  24.374  1.00 28.78          
ATOM   2233  CG2 VAL   274      34.005  53.110  22.123  1.00 29.02          
ATOM   2234  N   PHE   275      30.760  50.567  24.210  1.00 29.65          
ATOM   2235  CA  PHE   275      30.079  49.745  25.228  1.00 29.98          
ATOM   2236  C   PHE   275      29.977  48.297  24.755  1.00 29.59          
ATOM   2237  O   PHE   275      30.281  47.355  25.506  1.00 28.98          
ATOM   2238  CB  PHE   275      28.676  50.264  25.545  1.00 29.89          
ATOM   2239  CG  PHE   275      27.830  49.236  26.248  1.00 31.97          
ATOM   2240  CD1 PHE   275      27.896  49.088  27.648  1.00 31.50          
ATOM   2241  CD2 PHE   275      26.999  48.386  25.517  1.00 31.72          
ATOM   2242  CE1 PHE   275      27.131  48.100  28.308  1.00 32.71          
ATOM   2243  CE2 PHE   275      26.241  47.397  26.163  1.00 34.12          
ATOM   2244  CZ  PHE   275      26.293  47.267  27.569  1.00 31.82          
ATOM   2245  N   ASN   276      29.571  48.127  23.494  1.00 29.80          
ATOM   2246  CA  ASN   276      29.374  46.798  22.936  1.00 30.85          
ATOM   2247  C   ASN   276      30.652  46.000  22.945  1.00 30.68          
ATOM   2248  O   ASN   276      30.644  44.807  23.307  1.00 31.49          
ATOM   2249  CB  ASN   276      28.790  46.820  21.516  1.00 30.72          
ATOM   2250  CG  ASN   276      28.604  45.408  20.972  1.00 33.29          
ATOM   2251  OD1 ASN   276      29.252  45.007  19.978  1.00 34.59          
ATOM   2252  ND2 ASN   276      27.761  44.636  21.649  1.00 27.18          
ATOM   2253  N   GLY   277      31.755  46.649  22.562  1.00 30.79          
ATOM   2254  CA  GLY   277      33.057  45.998  22.574  1.00 30.38          
ATOM   2255  C   GLY   277      33.472  45.535  23.959  1.00 30.92          
ATOM   2256  O   GLY   277      34.036  44.452  24.093  1.00 30.38          
ATOM   2257  N   ILE   278      33.177  46.341  24.990  1.00 29.89          
ATOM   2258  CA  ILE   278      33.607  46.027  26.362  1.00 31.11          
ATOM   2259  C   ILE   278      32.723  44.937  26.963  1.00 30.73          
ATOM   2260  O   ILE   278      33.179  44.131  27.782  1.00 31.31          
ATOM   2261  CB  ILE   278      33.542  47.302  27.236  1.00 30.48          
ATOM   2262  CG1 ILE   278      34.665  48.278  26.860  1.00 30.52          
ATOM   2263  CG2 ILE   278      33.601  46.987  28.734  1.00 32.65          
ATOM   2264  CD  ILE   278      34.353  49.740  27.345  1.00 32.32          
ATOM   2265  N   PHE   279      31.445  44.958  26.591  1.00 30.17          
ATOM   2266  CA  PHE   279      30.432  44.045  27.161  1.00 30.76          
ATOM   2267  C   PHE   279      30.622  42.613  26.617  1.00 31.41          
ATOM   2268  O   PHE   279      30.908  41.683  27.381  1.00 32.09          
ATOM   2269  CB  PHE   279      29.014  44.621  26.925  1.00 30.89          
ATOM   2270  CG  PHE   279      27.885  43.813  27.533  1.00 30.78          
ATOM   2271  CD1 PHE   279      27.979  43.258  28.827  1.00 31.76          
ATOM   2272  CD2 PHE   279      26.695  43.651  26.827  1.00 32.66          
ATOM   2273  CE1 PHE   279      26.903  42.517  29.397  1.00 31.43          
ATOM   2274  CE2 PHE   279      25.627  42.922  27.360  1.00 31.96          
ATOM   2275  CZ  PHE   279      25.708  42.371  28.669  1.00 30.16          
ATOM   2276  N   GLY   280      30.545  42.440  25.304  1.00 31.75          
ATOM   2277  CA  GLY   280      30.648  41.111  24.708  1.00 31.51          
ATOM   2278  C   GLY   280      31.148  41.107  23.275  1.00 32.22          
ATOM   2279  O   GLY   280      31.097  40.087  22.623  1.00 32.72          
ATOM   2280  N   GLY   281      31.642  42.238  22.771  1.00 32.72          
ATOM   2281  CA  GLY   281      31.915  42.355  21.331  1.00 33.96          
ATOM   2282  C   GLY   281      33.206  41.703  20.861  1.00 34.71          
ATOM   2283  O   GLY   281      33.308  41.231  19.707  1.00 35.14          
ATOM   2284  N   PHE   282      34.188  41.685  21.754  1.00 34.48          
ATOM   2285  CA  PHE   282      35.549  41.282  21.449  1.00 34.77          
ATOM   2286  C   PHE   282      36.039  40.251  22.474  1.00 35.34          
ATOM   2287  O   PHE   282      35.430  40.112  23.530  1.00 33.98          
ATOM   2288  CB  PHE   282      36.450  42.520  21.522  1.00 34.42          
ATOM   2289  CG  PHE   282      36.220  43.526  20.426  1.00 35.28          
ATOM   2290  CD1 PHE   282      36.366  43.175  19.083  1.00 36.04          
ATOM   2291  CD2 PHE   282      35.947  44.860  20.735  1.00 33.47          
ATOM   2292  CE1 PHE   282      36.205  44.127  18.061  1.00 35.11          
ATOM   2293  CE2 PHE   282      35.772  45.807  19.716  1.00 34.41          
ATOM   2294  CZ  PHE   282      35.884  45.437  18.375  1.00 34.21          
ATOM   2295  N   PRO   283      37.145  39.531  22.174  1.00 36.44          
ATOM   2296  CA  PRO   283      37.632  38.493  23.086  1.00 36.33          
ATOM   2297  C   PRO   283      38.055  38.979  24.472  1.00 36.19          
ATOM   2298  O   PRO   283      38.103  38.167  25.409  1.00 36.06          
ATOM   2299  CB  PRO   283      38.839  37.866  22.335  1.00 37.42          
ATOM   2300  CG  PRO   283      38.636  38.220  20.894  1.00 38.07          
ATOM   2301  CD  PRO   283      37.956  39.598  20.937  1.00 37.63          
ATOM   2302  N   HSD   284      38.314  40.282  24.608  1.00 35.27          
ATOM   2303  CA  HSD   284      38.720  40.863  25.873  1.00 35.20          
ATOM   2304  C   HSD   284      37.492  41.384  26.653  1.00 33.84          
ATOM   2305  O   HSD   284      37.627  41.987  27.723  1.00 34.02          
ATOM   2306  CB  HSD   284      39.740  41.993  25.640  1.00 36.00          
ATOM   2307  CG  HSD   284      39.199  43.134  24.823  1.00 34.76          
ATOM   2308  ND1 HSD   284      39.422  43.254  23.467  1.00 38.29          
ATOM   2309  CD2 HSD   284      38.431  44.193  25.169  1.00 37.66          
ATOM   2310  CE1 HSD   284      38.836  44.354  23.021  1.00 34.74          
ATOM   2311  NE2 HSD   284      38.218  44.935  24.031  1.00 34.78          
ATOM   2312  N   SER   285      36.297  41.104  26.134  1.00 33.19          
ATOM   2313  CA  SER   285      35.068  41.653  26.691  1.00 31.92          
ATOM   2314  C   SER   285      34.736  41.053  28.044  1.00 32.33          
ATOM   2315  O   SER   285      35.215  39.966  28.374  1.00 30.86          
ATOM   2316  CB  SER   285      33.889  41.415  25.752  1.00 31.78          
ATOM   2317  OG  SER   285      33.537  40.039  25.719  1.00 31.79          
ATOM   2318  N   LYS   286      33.875  41.726  28.811  1.00 30.27          
ATOM   2319  CA  LYS   286      33.484  41.165  30.112  1.00 30.67          
ATOM   2320  C   LYS   286      32.806  39.803  30.045  1.00 30.23          
ATOM   2321  O   LYS   286      33.067  38.934  30.893  1.00 32.35          
ATOM   2322  CB  LYS   286      32.643  42.175  30.927  1.00 29.86          
ATOM   2323  CG  LYS   286      33.460  43.425  31.278  1.00 30.82          
ATOM   2324  CD  LYS   286      32.737  44.357  32.244  1.00 30.72          
ATOM   2325  CE  LYS   286      33.638  45.566  32.587  1.00 31.80          
ATOM   2326  NZ  LYS   286      34.725  45.173  33.507  1.00 31.86          
ATOM   2327  N   LEU   287      31.947  39.586  29.052  1.00 30.78          
ATOM   2328  CA  LEU   287      31.267  38.292  28.947  1.00 31.03          
ATOM   2329  C   LEU   287      32.221  37.197  28.496  1.00 31.65          
ATOM   2330  O   LEU   287      32.174  36.067  29.023  1.00 30.76          
ATOM   2331  CB  LEU   287      30.042  38.381  28.029  1.00 31.30          
ATOM   2332  CG  LEU   287      28.922  39.376  28.406  1.00 33.52          
ATOM   2333  CD1 LEU   287      27.799  39.255  27.411  1.00 34.64          
ATOM   2334  CD2 LEU   287      28.396  39.132  29.842  1.00 31.24          
ATOM   2335  N   PHE   288      33.104  37.512  27.534  1.00 31.70          
ATOM   2336  CA  PHE   288      34.114  36.500  27.140  1.00 32.41          
ATOM   2337  C   PHE   288      34.958  36.121  28.341  1.00 31.64          
ATOM   2338  O   PHE   288      35.114  34.936  28.662  1.00 31.14          
ATOM   2339  CB  PHE   288      35.006  36.978  25.978  1.00 32.30          
ATOM   2340  CG  PHE   288      35.793  35.859  25.306  1.00 35.52          
ATOM   2341  CD1 PHE   288      35.393  35.339  24.061  1.00 38.07          
ATOM   2342  CD2 PHE   288      36.932  35.320  25.924  1.00 35.47          
ATOM   2343  CE1 PHE   288      36.152  34.292  23.436  1.00 38.00          
ATOM   2344  CE2 PHE   288      37.684  34.271  25.315  1.00 37.23          
ATOM   2345  CZ  PHE   288      37.296  33.770  24.079  1.00 36.73          
ATOM   2346  N   MET   289      35.491  37.135  29.014  1.00 31.77          
ATOM   2347  CA  MET   289      36.412  36.915  30.123  1.00 32.73          
ATOM   2348  C   MET   289      35.802  36.320  31.392  1.00 33.09          
ATOM   2349  O   MET   289      36.492  35.661  32.150  1.00 33.85          
ATOM   2350  CB  MET   289      37.173  38.215  30.461  1.00 32.91          
ATOM   2351  CG  MET   289      38.040  38.742  29.304  1.00 34.09          
ATOM   2352  SD  MET   289      39.384  37.373  28.790  0.80 38.46          
ATOM   2353  CE  MET   289      40.258  37.109  30.500  1.00 37.04          
ATOM   2354  N   ASN   290      34.523  36.544  31.635  1.00 33.24          
ATOM   2355  CA  ASN   290      33.922  36.139  32.909  1.00 33.86          
ATOM   2356  C   ASN   290      32.904  35.016  32.810  1.00 34.26          
ATOM   2357  O   ASN   290      32.791  34.210  33.734  1.00 34.79          
ATOM   2358  CB  ASN   290      33.295  37.355  33.598  1.00 34.00          
ATOM   2359  CG  ASN   290      34.341  38.299  34.125  1.00 34.27          
ATOM   2360  OD1 ASN   290      34.908  38.054  35.177  1.00 35.69          
ATOM   2361  ND2 ASN   290      34.646  39.340  33.370  1.00 32.52          
ATOM   2362  N   VAL   291      32.154  34.958  31.718  1.00 34.71          
ATOM   2363  CA  VAL   291      31.180  33.865  31.569  1.00 35.06          
ATOM   2364  C   VAL   291      31.831  32.693  30.818  1.00 35.48          
ATOM   2365  O   VAL   291      31.723  31.555  31.238  1.00 35.68          
ATOM   2366  CB  VAL   291      29.885  34.283  30.854  1.00 35.47          
ATOM   2367  CG1 VAL   291      28.836  33.150  30.976  1.00 36.79          
ATOM   2368  CG2 VAL   291      29.343  35.601  31.404  1.00 34.71          
ATOM   2369  N   ARG   292      32.516  32.973  29.722  1.00 36.02          
ATOM   2370  CA  ARG   292      33.204  31.912  28.992  1.00 36.58          
ATOM   2371  C   ARG   292      34.486  31.444  29.698  1.00 37.14          
ATOM   2372  O   ARG   292      34.616  30.273  30.058  1.00 36.73          
ATOM   2373  CB  ARG   292      33.523  32.393  27.577  1.00 36.58          
ATOM   2374  CG  ARG   292      34.229  31.346  26.734  1.00 39.72          
ATOM   2375  CD  ARG   292      34.557  31.932  25.384  1.00 41.59          
ATOM   2376  NE  ARG   292      35.234  30.947  24.541  1.00 45.35          
ATOM   2377  CZ  ARG   292      35.083  30.862  23.218  1.00 45.97          
ATOM   2378  NH1 ARG   292      34.268  31.702  22.562  1.00 44.69          
ATOM   2379  NH2 ARG   292      35.737  29.926  22.556  1.00 46.72          
ATOM   2380  N   GLU   293      35.446  32.352  29.862  1.00 37.22          
ATOM   2381  CA  GLU   293      36.620  32.069  30.673  1.00 38.99          
ATOM   2382  C   GLU   293      36.185  32.213  32.134  1.00 39.74          
ATOM   2383  O   GLU   293      35.063  32.659  32.426  1.00 40.25          
ATOM   2384  CB  GLU   293      37.757  33.049  30.364  1.00 38.58          
ATOM   2385  CG  GLU   293      38.077  33.186  28.861  1.00 40.41          
ATOM   2386  CD  GLU   293      38.983  32.067  28.329  1.00 42.68          
ATOM   2387  OE1 GLU   293      39.617  31.379  29.138  1.00 45.47          
ATOM   2388  OE2 GLU   293      39.084  31.886  27.096  1.00 45.11          
ATOM   2389  N   LYS   294      37.071  31.820  33.034  1.00 40.18          
ATOM   2390  CA  LYS   294      36.858  31.943  34.472  1.00 40.83          
ATOM   2391  C   LYS   294      35.746  31.030  34.994  1.00 40.78          
ATOM   2392  O   LYS   294      36.049  30.017  35.616  1.00 41.21          
ATOM   2393  CB  LYS   294      36.700  33.411  34.888  1.00 41.12          
ATOM   2394  CG  LYS   294      37.943  34.236  34.515  1.00 43.17          
ATOM   2395  CD  LYS   294      38.010  35.548  35.261  1.00 47.81          
ATOM   2396  CE  LYS   294      38.796  36.579  34.475  1.00 49.05          
ATOM   2397  NZ  LYS   294      38.288  37.958  34.829  1.00 55.71          
ATOM   2398  N   GLU   295      34.482  31.348  34.713  1.00 39.39          
ATOM   2399  CA  GLU   295      33.392  30.505  35.214  1.00 39.39          
ATOM   2400  C   GLU   295      33.158  29.273  34.338  1.00 37.89          
ATOM   2401  O   GLU   295      32.547  28.319  34.790  1.00 37.30          
ATOM   2402  CB  GLU   295      32.090  31.298  35.407  1.00 39.90          
ATOM   2403  CG  GLU   295      32.236  32.565  36.237  1.00 44.33          
ATOM   2404  CD  GLU   295      31.929  32.394  37.715  1.00 51.61          
ATOM   2405  OE1 GLU   295      31.833  31.232  38.206  1.00 53.88          
ATOM   2406  OE2 GLU   295      31.776  33.453  38.383  1.00 55.38          
ATOM   2407  N   HSD   296      33.666  29.288  33.105  1.00 36.75          
ATOM   2408  CA  HSD   296      33.497  28.181  32.164  1.00 36.17          
ATOM   2409  C   HSD   296      32.007  27.760  32.032  1.00 35.43          
ATOM   2410  O   HSD   296      31.688  26.572  32.001  1.00 33.86          
ATOM   2411  CB  HSD   296      34.392  26.953  32.543  1.00 36.92          
ATOM   2412  CG  HSD   296      35.826  27.302  32.874  1.00 39.20          
ATOM   2413  ND1 HSD   296      36.647  28.022  32.022  1.00 42.06          
ATOM   2414  CD2 HSD   296      36.585  27.005  33.958  1.00 41.77          
ATOM   2415  CE1 HSD   296      37.842  28.163  32.575  1.00 43.14          
ATOM   2416  NE2 HSD   296      37.830  27.557  33.752  1.00 40.98          
ATOM   2417  N   LEU   297      31.091  28.726  31.983  1.00 34.81          
ATOM   2418  CA  LEU   297      29.683  28.356  31.899  1.00 35.02          
ATOM   2419  C   LEU   297      29.094  28.538  30.511  1.00 34.44          
ATOM   2420  O   LEU   297      27.930  28.184  30.276  1.00 34.99          
ATOM   2421  CB  LEU   297      28.832  29.093  32.930  1.00 36.15          
ATOM   2422  CG  LEU   297      28.928  28.615  34.384  1.00 38.55          
ATOM   2423  CD1 LEU   297      27.731  29.183  35.090  1.00 40.12          
ATOM   2424  CD2 LEU   297      28.969  27.086  34.522  1.00 38.50          
ATOM   2425  N   ALA   298      29.883  29.065  29.591  1.00 32.65          
ATOM   2426  CA  ALA   298      29.419  29.183  28.218  1.00 32.08          
ATOM   2427  C   ALA   298      30.529  28.775  27.282  1.00 31.43          
ATOM   2428  O   ALA   298      31.699  29.055  27.550  1.00 30.47          
ATOM   2429  CB  ALA   298      28.964  30.627  27.929  1.00 30.91          
ATOM   2430  N   TYR   299      30.162  28.112  26.196  1.00 30.90          
ATOM   2431  CA  TYR   299      31.112  27.758  25.129  1.00 30.46          
ATOM   2432  C   TYR   299      31.467  28.992  24.336  1.00 31.63          
ATOM   2433  O   TYR   299      32.570  29.107  23.818  1.00 31.67          
ATOM   2434  CB  TYR   299      30.506  26.700  24.225  1.00 30.43          
ATOM   2435  CG  TYR   299      30.252  25.436  24.965  1.00 29.24          
ATOM   2436  CD1 TYR   299      31.285  24.512  25.166  1.00 28.29          
ATOM   2437  CD2 TYR   299      28.992  25.163  25.521  1.00 32.47          
ATOM   2438  CE1 TYR   299      31.070  23.353  25.873  1.00 29.58          
ATOM   2439  CE2 TYR   299      28.776  23.971  26.245  1.00 29.59          
ATOM   2440  CZ  TYR   299      29.834  23.090  26.413  1.00 29.08          
ATOM   2441  OH  TYR   299      29.668  21.912  27.104  1.00 31.20          
ATOM   2442  N   TYR   300      30.509  29.917  24.249  1.00 32.01          
ATOM   2443  CA  TYR   300      30.752  31.225  23.674  1.00 32.44          
ATOM   2444  C   TYR   300      29.727  32.179  24.221  1.00 32.48          
ATOM   2445  O   TYR   300      28.619  31.766  24.590  1.00 31.46          
ATOM   2446  CB  TYR   300      30.711  31.171  22.132  1.00 33.72          
ATOM   2447  CG  TYR   300      29.358  30.793  21.567  1.00 34.31          
ATOM   2448  CD1 TYR   300      28.358  31.758  21.381  1.00 35.90          
ATOM   2449  CD2 TYR   300      29.082  29.471  21.221  1.00 35.20          
ATOM   2450  CE1 TYR   300      27.110  31.404  20.861  1.00 35.09          
ATOM   2451  CE2 TYR   300      27.860  29.105  20.700  1.00 36.04          
ATOM   2452  CZ  TYR   300      26.882  30.048  20.517  1.00 34.96          
ATOM   2453  OH  TYR   300      25.660  29.628  20.009  1.00 35.10          
ATOM   2454  N   ALA   301      30.091  33.457  24.292  1.00 32.26          
ATOM   2455  CA  ALA   301      29.183  34.478  24.753  1.00 33.98          
ATOM   2456  C   ALA   301      29.547  35.761  24.023  1.00 35.15          
ATOM   2457  O   ALA   301      30.653  36.245  24.194  1.00 35.37          
ATOM   2458  CB  ALA   301      29.318  34.683  26.254  1.00 33.99          
ATOM   2459  N   SER   302      28.660  36.310  23.196  1.00 34.67          
ATOM   2460  CA  SER   302      29.052  37.569  22.561  1.00 35.72          
ATOM   2461  C   SER   302      27.890  38.501  22.384  1.00 34.71          
ATOM   2462  O   SER   302      26.740  38.098  22.525  1.00 34.93          
ATOM   2463  CB  SER   302      29.750  37.314  21.230  1.00 36.12          
ATOM   2464  OG  SER   302      28.832  36.801  20.320  1.00 40.09          
ATOM   2465  N   SER   303      28.193  39.759  22.094  1.00 34.13          
ATOM   2466  CA  SER   303      27.128  40.751  21.956  1.00 32.96          
ATOM   2467  C   SER   303      27.269  41.392  20.581  1.00 33.81          
ATOM   2468  O   SER   303      28.383  41.376  19.987  1.00 33.08          
ATOM   2469  CB  SER   303      27.181  41.777  23.099  1.00 32.63          
ATOM   2470  OG  SER   303      28.370  42.570  23.026  1.00 32.94          
ATOM   2471  N   SER   304      26.141  41.883  20.049  1.00 33.56          
ATOM   2472  CA  SER   304      26.074  42.527  18.732  1.00 34.01          
ATOM   2473  C   SER   304      25.060  43.633  18.878  1.00 32.71          
ATOM   2474  O   SER   304      24.144  43.511  19.690  1.00 33.13          
ATOM   2475  CB  SER   304      25.515  41.565  17.681  1.00 34.49          
ATOM   2476  OG  SER   304      26.371  40.456  17.558  1.00 39.10          
ATOM   2477  N   ILE   305      25.205  44.674  18.066  1.00 32.02          
ATOM   2478  CA  ILE   305      24.280  45.834  18.048  1.00 31.56          
ATOM   2479  C   ILE   305      23.693  46.081  16.648  1.00 31.42          
ATOM   2480  O   ILE   305      24.313  45.756  15.642  1.00 30.60          
ATOM   2481  CB  ILE   305      24.937  47.153  18.548  1.00 31.19          
ATOM   2482  CG1 ILE   305      26.233  47.446  17.762  1.00 32.51          
ATOM   2483  CG2 ILE   305      25.193  47.047  20.038  1.00 33.60          
ATOM   2484  CD  ILE   305      26.887  48.897  18.034  1.00 30.93          
ATOM   2485  N   ASP   306      22.498  46.673  16.612  1.00 31.73          
ATOM   2486  CA  ASP   306      21.872  47.081  15.387  1.00 31.08          
ATOM   2487  C   ASP   306      21.400  48.506  15.651  1.00 31.25          
ATOM   2488  O   ASP   306      20.469  48.740  16.441  1.00 30.87          
ATOM   2489  CB  ASP   306      20.700  46.137  15.085  1.00 32.14          
ATOM   2490  CG  ASP   306      19.917  46.514  13.828  1.00 33.29          
ATOM   2491  OD1 ASP   306      19.849  47.701  13.446  1.00 32.93          
ATOM   2492  OD2 ASP   306      19.315  45.585  13.233  1.00 38.77          
ATOM   2493  N   THR   307      22.060  49.448  14.990  1.00 30.83          
ATOM   2494  CA  THR   307      21.818  50.884  15.191  1.00 30.94          
ATOM   2495  C   THR   307      20.804  51.433  14.179  1.00 30.66          
ATOM   2496  O   THR   307      20.645  52.668  14.034  1.00 30.20          
ATOM   2497  CB  THR   307      23.150  51.681  15.094  1.00 30.69          
ATOM   2498  OG1 THR   307      23.717  51.475  13.800  1.00 31.96          
ATOM   2499  CG2 THR   307      24.155  51.151  16.115  1.00 31.13          
ATOM   2500  N   PHE   308      20.134  50.531  13.461  1.00 30.57          
ATOM   2501  CA  PHE   308      18.966  50.898  12.658  1.00 31.20          
ATOM   2502  C   PHE   308      17.620  50.410  13.258  1.00 30.84          
ATOM   2503  O   PHE   308      16.554  50.961  12.948  1.00 30.22          
ATOM   2504  CB  PHE   308      19.184  50.480  11.184  1.00 33.01          
ATOM   2505  CG  PHE   308      20.333  51.249  10.514  1.00 33.40          
ATOM   2506  CD1 PHE   308      20.069  52.264   9.607  1.00 37.01          
ATOM   2507  CD2 PHE   308      21.658  50.998  10.858  1.00 36.41          
ATOM   2508  CE1 PHE   308      21.127  52.992   9.018  1.00 37.41          
ATOM   2509  CE2 PHE   308      22.714  51.746  10.296  1.00 33.55          
ATOM   2510  CZ  PHE   308      22.443  52.715   9.373  1.00 34.78          
ATOM   2511  N   ARG   309      17.679  49.421  14.146  1.00 30.73          
ATOM   2512  CA  ARG   309      16.471  48.918  14.811  1.00 31.04          
ATOM   2513  C   ARG   309      16.526  49.096  16.336  1.00 31.07          
ATOM   2514  O   ARG   309      15.624  48.636  17.027  1.00 31.82          
ATOM   2515  CB  ARG   309      16.176  47.439  14.437  1.00 30.41          
ATOM   2516  CG  ARG   309      15.894  47.213  12.963  1.00 30.28          
ATOM   2517  CD  ARG   309      15.500  45.774  12.651  1.00 30.65          
ATOM   2518  NE  ARG   309      16.563  44.814  12.900  1.00 36.40          
ATOM   2519  CZ  ARG   309      16.362  43.498  12.918  1.00 37.76          
ATOM   2520  NH1 ARG   309      15.137  43.012  12.715  1.00 38.46          
ATOM   2521  NH2 ARG   309      17.371  42.683  13.131  1.00 36.46          
ATOM   2522  N   GLY   310      17.583  49.738  16.849  1.00 31.70          
ATOM   2523  CA  GLY   310      17.680  50.149  18.276  1.00 31.86          
ATOM   2524  C   GLY   310      17.672  49.040  19.330  1.00 32.16          
ATOM   2525  O   GLY   310      17.018  49.156  20.372  1.00 32.50          
ATOM   2526  N   PHE   311      18.452  48.004  19.084  1.00 33.29          
ATOM   2527  CA  PHE   311      18.520  46.873  19.973  1.00 33.94          
ATOM   2528  C   PHE   311      19.894  46.231  19.916  1.00 34.91          
ATOM   2529  O   PHE   311      20.715  46.518  19.033  1.00 34.50          
ATOM   2530  CB  PHE   311      17.359  45.893  19.729  1.00 33.61          
ATOM   2531  CG  PHE   311      17.607  44.869  18.649  1.00 34.55          
ATOM   2532  CD1 PHE   311      17.686  43.528  18.981  1.00 34.85          
ATOM   2533  CD2 PHE   311      17.708  45.228  17.298  1.00 34.67          
ATOM   2534  CE1 PHE   311      17.901  42.549  18.000  1.00 34.15          
ATOM   2535  CE2 PHE   311      17.929  44.253  16.306  1.00 35.98          
ATOM   2536  CZ  PHE   311      18.032  42.919  16.658  1.00 35.13          
ATOM   2537  N   MET   312      20.173  45.389  20.890  1.00 35.41          
ATOM   2538  CA  MET   312      21.467  44.780  21.157  1.00 39.32          
ATOM   2539  C   MET   312      21.138  43.364  21.573  1.00 36.07          
ATOM   2540  O   MET   312      20.174  43.193  22.239  1.00 34.55          
ATOM   2541  CB  MET   312      22.064  45.493  22.368  1.00 38.86          
ATOM   2542  CG  MET   312      23.525  45.539  22.538  1.00 41.31          
ATOM   2543  SD  MET   312      24.257  44.843  24.133  0.70 53.02          
ATOM   2544  CE  MET   312      23.316  43.331  24.232  1.00 24.82          
ATOM   2545  N   THR   313      21.947  42.375  21.195  1.00 35.51          
ATOM   2546  CA  THR   313      21.702  40.979  21.585  1.00 34.94          
ATOM   2547  C   THR   313      22.963  40.378  22.184  1.00 34.75          
ATOM   2548  O   THR   313      24.096  40.819  21.869  1.00 34.47          
ATOM   2549  CB  THR   313      21.304  40.093  20.393  1.00 36.09          
ATOM   2550  OG1 THR   313      22.412  39.983  19.507  1.00 36.54          
ATOM   2551  CG2 THR   313      20.109  40.648  19.634  1.00 33.61          
ATOM   2552  N   VAL   314      22.753  39.432  23.089  1.00 31.84          
ATOM   2553  CA  VAL   314      23.785  38.629  23.629  1.00 31.93          
ATOM   2554  C   VAL   314      23.393  37.228  23.207  1.00 31.89          
ATOM   2555  O   VAL   314      22.230  36.830  23.373  1.00 32.02          
ATOM   2556  CB  VAL   314      23.854  38.735  25.184  1.00 31.63          
ATOM   2557  CG1 VAL   314      24.768  37.624  25.793  1.00 31.06          
ATOM   2558  CG2 VAL   314      24.385  40.102  25.610  1.00 31.13          
ATOM   2559  N   GLN   315      24.351  36.493  22.647  1.00 32.18          
ATOM   2560  CA  GLN   315      24.130  35.118  22.231  1.00 32.65          
ATOM   2561  C   GLN   315      25.139  34.207  22.929  1.00 32.09          
ATOM   2562  O   GLN   315      26.333  34.510  22.920  1.00 32.71          
ATOM   2563  CB  GLN   315      24.332  35.018  20.718  1.00 33.10          
ATOM   2564  CG  GLN   315      23.314  35.818  19.903  1.00 37.89          
ATOM   2565  CD  GLN   315      23.595  35.682  18.426  1.00 43.11          
ATOM   2566  OE1 GLN   315      23.757  34.565  17.896  1.00 42.64          
ATOM   2567  NE2 GLN   315      23.694  36.817  17.755  1.00 43.98          
ATOM   2568  N   THR   316      24.662  33.109  23.527  1.00 31.72          
ATOM   2569  CA  THR   316      25.519  32.128  24.190  1.00 30.94          
ATOM   2570  C   THR   316      25.181  30.695  23.746  1.00 30.67          
ATOM   2571  O   THR   316      24.041  30.409  23.368  1.00 30.15          
ATOM   2572  CB  THR   316      25.416  32.236  25.756  1.00 30.83          
ATOM   2573  OG1 THR   316      24.156  31.738  26.212  1.00 32.85          
ATOM   2574  CG2 THR   316      25.548  33.728  26.240  1.00 31.85          
ATOM   2575  N   GLY   317      26.185  29.825  23.782  1.00 30.22          
ATOM   2576  CA  GLY   317      25.999  28.360  23.761  1.00 29.15          
ATOM   2577  C   GLY   317      26.397  27.852  25.133  1.00 30.13          
ATOM   2578  O   GLY   317      27.483  28.219  25.675  1.00 29.48          
ATOM   2579  N   ILE   318      25.533  27.025  25.720  1.00 29.95          
ATOM   2580  CA  ILE   318      25.703  26.586  27.114  1.00 30.20          
ATOM   2581  C   ILE   318      25.265  25.146  27.258  1.00 31.14          
ATOM   2582  O   ILE   318      24.668  24.591  26.325  1.00 29.81          
ATOM   2583  CB  ILE   318      24.895  27.473  28.135  1.00 30.31          
ATOM   2584  CG1 ILE   318      23.382  27.309  27.951  1.00 31.64          
ATOM   2585  CG2 ILE   318      25.306  28.999  28.031  1.00 29.36          
ATOM   2586  CD  ILE   318      22.531  27.939  29.082  1.00 30.78          
ATOM   2587  N   ASP   319      25.605  24.539  28.399  1.00 30.58          
ATOM   2588  CA  ASP   319      24.901  23.366  28.861  1.00 32.30          
ATOM   2589  C   ASP   319      23.610  23.895  29.483  1.00 32.32          
ATOM   2590  O   ASP   319      23.657  24.767  30.367  1.00 31.91          
ATOM   2591  CB  ASP   319      25.725  22.597  29.899  1.00 32.21          
ATOM   2592  CG  ASP   319      26.981  21.941  29.306  1.00 35.76          
ATOM   2593  OD1 ASP   319      27.084  21.761  28.064  1.00 38.42          
ATOM   2594  OD2 ASP   319      27.869  21.585  30.103  1.00 40.67          
ATOM   2595  N   GLY   320      22.473  23.339  29.051  1.00 31.91          
ATOM   2596  CA  GLY   320      21.142  23.914  29.357  1.00 32.35          
ATOM   2597  C   GLY   320      20.896  24.019  30.856  1.00 32.23          
ATOM   2598  O   GLY   320      20.193  24.916  31.300  1.00 32.39          
ATOM   2599  N   LYS   321      21.499  23.117  31.631  1.00 32.92          
ATOM   2600  CA  LYS   321      21.373  23.122  33.112  1.00 34.02          
ATOM   2601  C   LYS   321      21.857  24.422  33.790  1.00 34.05          
ATOM   2602  O   LYS   321      21.448  24.728  34.917  1.00 34.39          
ATOM   2603  CB  LYS   321      22.039  21.884  33.745  1.00 33.48          
ATOM   2604  CG  LYS   321      23.559  21.949  33.855  1.00 34.39          
ATOM   2605  CD  LYS   321      24.187  20.780  34.672  1.00 37.03          
ATOM   2606  CE  LYS   321      24.018  20.932  36.215  1.00 41.46          
ATOM   2607  NZ  LYS   321      24.519  19.712  37.019  1.00 41.65          
ATOM   2608  N   ASN   322      22.679  25.202  33.085  1.00 33.91          
ATOM   2609  CA  ASN   322      23.294  26.418  33.626  1.00 33.15          
ATOM   2610  C   ASN   322      22.561  27.718  33.231  1.00 32.94          
ATOM   2611  O   ASN   322      23.086  28.820  33.438  1.00 31.92          
ATOM   2612  CB  ASN   322      24.778  26.480  33.209  1.00 33.23          
ATOM   2613  CG  ASN   322      25.627  25.349  33.808  1.00 35.94          
ATOM   2614  OD1 ASN   322      25.501  25.025  34.987  1.00 40.12          
ATOM   2615  ND2 ASN   322      26.529  24.785  33.010  1.00 34.61          
ATOM   2616  N   ARG   323      21.346  27.586  32.673  1.00 32.62          
ATOM   2617  CA  ARG   323      20.608  28.732  32.138  1.00 32.91          
ATOM   2618  C   ARG   323      20.527  29.896  33.128  1.00 32.90          
ATOM   2619  O   ARG   323      20.922  31.033  32.809  1.00 31.69          
ATOM   2620  CB  ARG   323      19.203  28.312  31.704  1.00 32.88          
ATOM   2621  CG  ARG   323      18.253  29.474  31.375  1.00 33.14          
ATOM   2622  CD  ARG   323      16.750  29.103  31.556  1.00 34.61          
ATOM   2623  NE  ARG   323      15.873  30.077  30.877  1.00 38.29          
ATOM   2624  CZ  ARG   323      15.393  31.195  31.426  1.00 42.36          
ATOM   2625  NH1 ARG   323      15.680  31.507  32.690  1.00 43.62          
ATOM   2626  NH2 ARG   323      14.620  32.014  30.710  1.00 40.09          
ATOM   2627  N   ASN   324      20.040  29.606  34.337  1.00 33.01          
ATOM   2628  CA  ASN   324      19.810  30.665  35.335  1.00 33.77          
ATOM   2629  C   ASN   324      21.114  31.250  35.826  1.00 33.17          
ATOM   2630  O   ASN   324      21.233  32.464  35.970  1.00 32.30          
ATOM   2631  CB  ASN   324      18.923  30.164  36.483  1.00 34.86          
ATOM   2632  CG  ASN   324      17.533  29.743  35.996  1.00 39.18          
ATOM   2633  OD1 ASN   324      16.915  30.428  35.185  1.00 43.94          
ATOM   2634  ND2 ASN   324      17.054  28.589  36.467  1.00 45.21          
ATOM   2635  N   GLN   325      22.115  30.409  36.052  1.00 32.84          
ATOM   2636  CA  GLN   325      23.424  30.937  36.453  1.00 33.74          
ATOM   2637  C   GLN   325      24.085  31.800  35.370  1.00 32.81          
ATOM   2638  O   GLN   325      24.700  32.830  35.680  1.00 32.69          
ATOM   2639  CB  GLN   325      24.368  29.822  36.874  1.00 33.81          
ATOM   2640  CG  GLN   325      25.598  30.344  37.559  1.00 39.16          
ATOM   2641  CD  GLN   325      26.407  29.254  38.190  1.00 43.44          
ATOM   2642  OE1 GLN   325      25.977  28.089  38.253  1.00 44.69          
ATOM   2643  NE2 GLN   325      27.611  29.614  38.661  1.00 46.42          
ATOM   2644  N   VAL   326      23.969  31.395  34.106  1.00 31.24          
ATOM   2645  CA  VAL   326      24.473  32.222  33.023  1.00 29.78          
ATOM   2646  C   VAL   326      23.711  33.568  32.974  1.00 30.02          
ATOM   2647  O   VAL   326      24.320  34.612  32.781  1.00 29.91          
ATOM   2648  CB  VAL   326      24.401  31.509  31.651  1.00 30.22          
ATOM   2649  CG1 VAL   326      24.769  32.487  30.496  1.00 30.54          
ATOM   2650  CG2 VAL   326      25.337  30.264  31.604  1.00 28.88          
ATOM   2651  N   LEU   327      22.396  33.566  33.166  1.00 29.60          
ATOM   2652  CA  LEU   327      21.679  34.847  33.139  1.00 29.79          
ATOM   2653  C   LEU   327      22.147  35.770  34.257  1.00 30.12          
ATOM   2654  O   LEU   327      22.295  36.969  34.045  1.00 29.16          
ATOM   2655  CB  LEU   327      20.180  34.631  33.236  1.00 29.61          
ATOM   2656  CG  LEU   327      19.479  33.939  32.080  1.00 29.14          
ATOM   2657  CD1 LEU   327      18.030  33.709  32.511  1.00 28.36          
ATOM   2658  CD2 LEU   327      19.576  34.847  30.834  1.00 31.09          
ATOM   2659  N   ARG   328      22.383  35.207  35.451  1.00 31.44          
ATOM   2660  CA  ARG   328      22.890  36.009  36.596  1.00 32.62          
ATOM   2661  C   ARG   328      24.303  36.568  36.314  1.00 31.40          
ATOM   2662  O   ARG   328      24.583  37.733  36.604  1.00 29.83          
ATOM   2663  CB  ARG   328      22.858  35.207  37.910  1.00 32.78          
ATOM   2664  CG  ARG   328      21.411  34.836  38.358  1.00 35.50          
ATOM   2665  CD  ARG   328      21.359  34.135  39.760  1.00 36.84          
ATOM   2666  NE  ARG   328      21.791  32.728  39.751  1.00 44.49          
ATOM   2667  CZ  ARG   328      20.989  31.660  39.623  1.00 47.31          
ATOM   2668  NH1 ARG   328      19.670  31.791  39.471  1.00 50.54          
ATOM   2669  NH2 ARG   328      21.514  30.439  39.633  1.00 46.94          
ATOM   2670  N   LEU   329      25.168  35.748  35.730  1.00 30.80          
ATOM   2671  CA  LEU   329      26.526  36.200  35.402  1.00 31.49          
ATOM   2672  C   LEU   329      26.518  37.360  34.394  1.00 31.22          
ATOM   2673  O   LEU   329      27.257  38.315  34.558  1.00 31.51          
ATOM   2674  CB  LEU   329      27.374  35.044  34.856  1.00 32.22          
ATOM   2675  CG  LEU   329      27.760  33.921  35.835  1.00 34.74          
ATOM   2676  CD1 LEU   329      28.402  32.704  35.124  1.00 36.87          
ATOM   2677  CD2 LEU   329      28.676  34.438  36.947  1.00 38.68          
ATOM   2678  N   ILE   330      25.721  37.230  33.336  1.00 30.66          
ATOM   2679  CA  ILE   330      25.561  38.288  32.316  1.00 31.02          
ATOM   2680  C   ILE   330      25.053  39.594  32.943  1.00 30.77          
ATOM   2681  O   ILE   330      25.591  40.692  32.663  1.00 30.97          
ATOM   2682  CB  ILE   330      24.561  37.860  31.228  1.00 30.08          
ATOM   2683  CG1 ILE   330      25.149  36.734  30.368  1.00 31.35          
ATOM   2684  CG2 ILE   330      24.152  39.081  30.336  1.00 32.58          
ATOM   2685  CD  ILE   330      24.071  36.034  29.483  1.00 30.60          
ATOM   2686  N   SER   331      24.028  39.469  33.789  1.00 29.97          
ATOM   2687  CA  SER   331      23.481  40.624  34.520  1.00 30.76          
ATOM   2688  C   SER   331      24.537  41.301  35.400  1.00 30.53          
ATOM   2689  O   SER   331      24.639  42.550  35.465  1.00 29.83          
ATOM   2690  CB  SER   331      22.310  40.174  35.407  1.00 31.20          
ATOM   2691  OG  SER   331      21.919  41.242  36.265  1.00 34.05          
ATOM   2692  N   THR   332      25.347  40.476  36.062  1.00 30.19          
ATOM   2693  CA  THR   332      26.445  41.008  36.891  1.00 30.70          
ATOM   2694  C   THR   332      27.439  41.844  36.100  1.00 30.39          
ATOM   2695  O   THR   332      27.823  42.944  36.537  1.00 30.40          
ATOM   2696  CB  THR   332      27.160  39.880  37.630  1.00 29.85          
ATOM   2697  OG1 THR   332      26.208  39.298  38.523  1.00 29.43          
ATOM   2698  CG2 THR   332      28.337  40.430  38.451  1.00 31.98          
ATOM   2699  N   GLU   333      27.851  41.330  34.944  1.00 30.22          
ATOM   2700  CA  GLU   333      28.754  42.091  34.086  1.00 29.73          
ATOM   2701  C   GLU   333      28.122  43.378  33.585  1.00 30.64          
ATOM   2702  O   GLU   333      28.790  44.391  33.500  1.00 30.39          
ATOM   2703  CB  GLU   333      29.284  41.246  32.923  1.00 30.35          
ATOM   2704  CG  GLU   333      30.194  40.071  33.393  1.00 30.45          
ATOM   2705  CD  GLU   333      31.264  40.517  34.388  1.00 33.24          
ATOM   2706  OE1 GLU   333      31.781  41.650  34.272  1.00 37.26          
ATOM   2707  OE2 GLU   333      31.603  39.744  35.299  1.00 36.49          
ATOM   2708  N   LEU   334      26.832  43.350  33.270  1.00 30.62          
ATOM   2709  CA  LEU   334      26.163  44.579  32.863  1.00 31.40          
ATOM   2710  C   LEU   334      26.138  45.619  33.997  1.00 31.47          
ATOM   2711  O   LEU   334      26.418  46.805  33.787  1.00 31.07          
ATOM   2712  CB  LEU   334      24.759  44.281  32.316  1.00 31.45          
ATOM   2713  CG  LEU   334      23.885  45.483  31.920  1.00 33.17          
ATOM   2714  CD1 LEU   334      24.650  46.392  30.890  1.00 32.63          
ATOM   2715  CD2 LEU   334      22.559  44.945  31.314  1.00 32.20          
ATOM   2716  N   GLU   335      25.819  45.173  35.204  1.00 31.33          
ATOM   2717  CA  GLU   335      25.873  46.044  36.354  1.00 31.54          
ATOM   2718  C   GLU   335      27.276  46.627  36.574  1.00 30.86          
ATOM   2719  O   GLU   335      27.419  47.811  36.923  1.00 29.06          
ATOM   2720  CB  GLU   335      25.390  45.304  37.594  1.00 31.94          
ATOM   2721  CG  GLU   335      23.863  45.058  37.554  1.00 38.25          
ATOM   2722  CD  GLU   335      23.064  46.365  37.284  1.00 43.79          
ATOM   2723  OE1 GLU   335      23.328  47.385  37.972  1.00 44.19          
ATOM   2724  OE2 GLU   335      22.191  46.354  36.368  1.00 48.16          
ATOM   2725  N   ASN   336      28.302  45.805  36.356  1.00 29.30          
ATOM   2726  CA  ASN   336      29.664  46.275  36.508  1.00 29.91          
ATOM   2727  C   ASN   336      29.979  47.418  35.567  1.00 30.02          
ATOM   2728  O   ASN   336      30.621  48.389  35.967  1.00 30.98          
ATOM   2729  CB  ASN   336      30.664  45.134  36.310  1.00 30.37          
ATOM   2730  CG  ASN   336      30.732  44.223  37.519  1.00 30.93          
ATOM   2731  OD1 ASN   336      30.304  44.601  38.623  1.00 29.65          
ATOM   2732  ND2 ASN   336      31.311  43.031  37.335  1.00 31.78          
ATOM   2733  N   ILE   337      29.548  47.295  34.311  1.00 29.66          
ATOM   2734  CA  ILE   337      29.694  48.413  33.367  1.00 28.75          
ATOM   2735  C   ILE   337      28.866  49.611  33.858  1.00 29.46          
ATOM   2736  O   ILE   337      29.359  50.730  33.883  1.00 29.59          
ATOM   2737  CB  ILE   337      29.284  48.017  31.932  1.00 28.33          
ATOM   2738  CG1 ILE   337      30.210  46.862  31.416  1.00 27.67          
ATOM   2739  CG2 ILE   337      29.303  49.253  31.023  1.00 29.00          
ATOM   2740  CD  ILE   337      29.710  46.212  30.099  1.00 27.18          
ATOM   2741  N   ARG   338      27.603  49.393  34.236  1.00 31.09          
ATOM   2742  CA  ARG   338      26.802  50.514  34.777  1.00 31.66          
ATOM   2743  C   ARG   338      27.544  51.242  35.910  1.00 31.42          
ATOM   2744  O   ARG   338      27.515  52.487  36.001  1.00 31.05          
ATOM   2745  CB  ARG   338      25.427  50.036  35.265  1.00 32.32          
ATOM   2746  CG  ARG   338      24.533  49.618  34.120  1.00 33.13          
ATOM   2747  CD  ARG   338      23.201  48.938  34.554  1.00 34.56          
ATOM   2748  NE  ARG   338      22.282  48.973  33.423  1.00 38.09          
ATOM   2749  CZ  ARG   338      21.147  48.287  33.319  1.00 41.91          
ATOM   2750  NH1 ARG   338      20.779  47.419  34.269  1.00 44.99          
ATOM   2751  NH2 ARG   338      20.388  48.463  32.238  1.00 39.42          
ATOM   2752  N   LEU   339      28.211  50.467  36.764  1.00 30.16          
ATOM   2753  CA  LEU   339      28.960  51.025  37.916  1.00 30.26          
ATOM   2754  C   LEU   339      30.280  51.689  37.516  1.00 30.00          
ATOM   2755  O   LEU   339      30.905  52.353  38.331  1.00 29.06          
ATOM   2756  CB  LEU   339      29.217  49.939  38.975  1.00 29.82          
ATOM   2757  CG  LEU   339      27.972  49.438  39.737  1.00 32.33          
ATOM   2758  CD1 LEU   339      28.237  48.059  40.386  1.00 33.09          
ATOM   2759  CD2 LEU   339      27.545  50.455  40.799  1.00 33.70          
ATOM   2760  N   GLY   340      30.686  51.517  36.258  1.00 30.27          
ATOM   2761  CA  GLY   340      31.934  52.133  35.783  1.00 29.90          
ATOM   2762  C   GLY   340      33.134  51.317  36.196  1.00 30.61          
ATOM   2763  O   GLY   340      34.260  51.824  36.240  1.00 29.75          
ATOM   2764  N   LYS   341      32.903  50.029  36.467  1.00 30.80          
ATOM   2765  CA  LYS   341      33.971  49.125  36.851  1.00 31.72          
ATOM   2766  C   LYS   341      34.667  48.644  35.568  1.00 33.48          
ATOM   2767  O   LYS   341      34.503  47.485  35.136  1.00 32.44          
ATOM   2768  CB  LYS   341      33.437  47.969  37.697  1.00 30.74          
ATOM   2769  CG  LYS   341      33.014  48.404  39.129  1.00 31.56          
ATOM   2770  CD  LYS   341      32.136  47.373  39.852  1.00 30.66          
ATOM   2771  CE  LYS   341      32.960  46.158  40.320  1.00 33.45          
ATOM   2772  NZ  LYS   341      32.055  45.042  40.721  1.00 30.44          
ATOM   2773  N   ILE   342      35.425  49.565  34.957  1.00 34.70          
ATOM   2774  CA  ILE   342      35.991  49.364  33.606  1.00 35.83          
ATOM   2775  C   ILE   342      37.469  49.727  33.611  1.00 37.13          
ATOM   2776  O   ILE   342      37.845  50.846  33.963  1.00 36.47          
ATOM   2777  CB  ILE   342      35.244  50.225  32.544  1.00 35.96          
ATOM   2778  CG1 ILE   342      33.751  49.900  32.555  1.00 35.75          
ATOM   2779  CG2 ILE   342      35.788  49.972  31.151  1.00 35.46          
ATOM   2780  CD  ILE   342      32.887  50.876  31.766  1.00 36.05          
ATOM   2781  N   ARG   343      38.307  48.769  33.241  1.00 37.69          
ATOM   2782  CA  ARG   343      39.743  48.971  33.295  1.00 40.09          
ATOM   2783  C   ARG   343      40.193  49.744  32.074  1.00 40.17          
ATOM   2784  O   ARG   343      39.570  49.647  31.018  1.00 39.45          
ATOM   2785  CB  ARG   343      40.453  47.619  33.310  1.00 40.58          
ATOM   2786  CG  ARG   343      40.098  46.748  34.517  1.00 44.32          
ATOM   2787  CD  ARG   343      40.574  45.301  34.328  1.00 51.40          
ATOM   2788  NE  ARG   343      41.870  45.188  33.633  1.00 57.20          
ATOM   2789  CZ  ARG   343      43.044  45.662  34.072  1.00 59.62          
ATOM   2790  NH1 ARG   343      44.139  45.482  33.331  1.00 59.52          
ATOM   2791  NH2 ARG   343      43.136  46.328  35.229  1.00 60.07          
ATOM   2792  N   GLU   344      41.302  50.465  32.207  1.00 40.86          
ATOM   2793  CA  GLU   344      41.858  51.195  31.076  1.00 41.98          
ATOM   2794  C   GLU   344      42.127  50.311  29.874  1.00 41.27          
ATOM   2795  O   GLU   344      41.867  50.706  28.755  1.00 40.42          
ATOM   2796  CB  GLU   344      43.112  51.961  31.474  1.00 42.77          
ATOM   2797  CG  GLU   344      42.796  53.356  32.038  1.00 48.73          
ATOM   2798  CD  GLU   344      41.671  54.091  31.272  1.00 54.97          
ATOM   2799  OE1 GLU   344      41.736  54.150  30.007  1.00 56.83          
ATOM   2800  OE2 GLU   344      40.733  54.602  31.949  1.00 55.47          
ATOM   2801  N   LEU   345      42.613  49.102  30.107  1.00 41.04          
ATOM   2802  CA  LEU   345      42.950  48.224  29.002  1.00 41.91          
ATOM   2803  C   LEU   345      41.686  47.755  28.265  1.00 41.36          
ATOM   2804  O   LEU   345      41.682  47.680  27.044  1.00 41.90          
ATOM   2805  CB  LEU   345      43.815  47.043  29.475  1.00 41.55          
ATOM   2806  CG  LEU   345      44.298  46.113  28.353  1.00 43.13          
ATOM   2807  CD1 LEU   345      45.337  46.809  27.427  1.00 44.01          
ATOM   2808  CD2 LEU   345      44.855  44.785  28.909  1.00 43.67          
ATOM   2809  N   GLU   346      40.614  47.451  29.001  1.00 40.84          
ATOM   2810  CA  GLU   346      39.322  47.153  28.367  1.00 40.31          
ATOM   2811  C   GLU   346      38.918  48.210  27.316  1.00 39.49          
ATOM   2812  O   GLU   346      38.604  47.868  26.178  1.00 38.96          
ATOM   2813  CB  GLU   346      38.212  47.004  29.422  1.00 40.10          
ATOM   2814  CG  GLU   346      38.337  45.725  30.233  1.00 42.46          
ATOM   2815  CD  GLU   346      37.284  45.628  31.300  1.00 43.24          
ATOM   2816  OE1 GLU   346      37.154  46.566  32.104  1.00 43.28          
ATOM   2817  OE2 GLU   346      36.607  44.598  31.356  1.00 43.47          
ATOM   2818  N   ILE   347      38.941  49.482  27.697  1.00 38.97          
ATOM   2819  CA  ILE   347      38.505  50.568  26.790  1.00 38.58          
ATOM   2820  C   ILE   347      39.493  50.753  25.652  1.00 37.77          
ATOM   2821  O   ILE   347      39.073  50.904  24.500  1.00 37.20          
ATOM   2822  CB  ILE   347      38.364  51.925  27.509  1.00 39.34          
ATOM   2823  CG1 ILE   347      37.501  51.807  28.742  1.00 41.17          
ATOM   2824  CG2 ILE   347      37.693  52.979  26.612  1.00 40.21          
ATOM   2825  CD  ILE   347      37.982  52.731  29.803  1.00 44.37          
ATOM   2826  N   GLU   348      40.787  50.750  25.982  1.00 36.01          
ATOM   2827  CA  GLU   348      41.857  51.014  25.021  1.00 36.74          
ATOM   2828  C   GLU   348      41.862  49.922  23.946  1.00 35.70          
ATOM   2829  O   GLU   348      41.921  50.219  22.748  1.00 34.80          
ATOM   2830  CB  GLU   348      43.244  51.047  25.715  1.00 36.10          
ATOM   2831  CG  GLU   348      43.534  52.290  26.605  1.00 40.23          
ATOM   2832  CD  GLU   348      44.943  52.253  27.296  1.00 41.60          
ATOM   2833  OE1 GLU   348      45.604  51.167  27.345  1.00 48.44          
ATOM   2834  OE2 GLU   348      45.392  53.326  27.780  1.00 48.95          
ATOM   2835  N   GLN   349      41.786  48.659  24.375  1.00 34.58          
ATOM   2836  CA  GLN   349      41.703  47.556  23.422  1.00 35.94          
ATOM   2837  C   GLN   349      40.456  47.613  22.553  1.00 34.19          
ATOM   2838  O   GLN   349      40.520  47.338  21.371  1.00 34.54          
ATOM   2839  CB  GLN   349      41.752  46.199  24.128  1.00 37.07          
ATOM   2840  CG  GLN   349      43.139  45.754  24.476  1.00 41.40          
ATOM   2841  CD  GLN   349      43.155  44.263  24.739  1.00 48.58          
ATOM   2842  OE1 GLN   349      43.000  43.837  25.883  1.00 51.94          
ATOM   2843  NE2 GLN   349      43.274  43.456  23.672  1.00 49.73          
ATOM   2844  N   THR   350      39.324  47.985  23.144  1.00 34.01          
ATOM   2845  CA  THR   350      38.078  48.135  22.376  1.00 32.74          
ATOM   2846  C   THR   350      38.217  49.234  21.318  1.00 32.47          
ATOM   2847  O   THR   350      37.881  49.007  20.159  1.00 32.29          
ATOM   2848  CB  THR   350      36.889  48.406  23.304  1.00 33.27          
ATOM   2849  OG1 THR   350      36.772  47.300  24.212  1.00 33.51          
ATOM   2850  CG2 THR   350      35.594  48.605  22.513  1.00 30.03          
ATOM   2851  N   LYS   351      38.731  50.406  21.708  1.00 31.53          
ATOM   2852  CA  LYS   351      38.927  51.508  20.744  1.00 31.22          
ATOM   2853  C   LYS   351      39.884  51.115  19.586  1.00 31.45          
ATOM   2854  O   LYS   351      39.581  51.355  18.415  1.00 30.60          
ATOM   2855  CB  LYS   351      39.380  52.791  21.437  1.00 30.55          
ATOM   2856  CG  LYS   351      38.345  53.387  22.434  1.00 29.42          
ATOM   2857  CD  LYS   351      38.889  54.632  23.119  1.00 30.37          
ATOM   2858  CE  LYS   351      37.773  55.347  23.876  1.00 28.57          
ATOM   2859  NZ  LYS   351      38.247  56.558  24.614  1.00 30.03          
ATOM   2860  N   ALA   352      41.002  50.462  19.920  1.00 32.75          
ATOM   2861  CA  ALA   352      41.981  50.009  18.912  1.00 32.90          
ATOM   2862  C   ALA   352      41.334  49.081  17.871  1.00 33.81          
ATOM   2863  O   ALA   352      41.494  49.273  16.655  1.00 32.32          
ATOM   2864  CB  ALA   352      43.178  49.294  19.610  1.00 33.93          
ATOM   2865  N   MET   353      40.557  48.111  18.351  1.00 34.17          
ATOM   2866  CA  MET   353      39.948  47.128  17.453  1.00 37.32          
ATOM   2867  C   MET   353      38.835  47.752  16.611  1.00 34.98          
ATOM   2868  O   MET   353      38.705  47.437  15.446  1.00 34.03          
ATOM   2869  CB  MET   353      39.462  45.885  18.220  1.00 36.13          
ATOM   2870  CG  MET   353      40.649  45.005  18.672  1.00 41.63          
ATOM   2871  SD  MET   353      40.097  43.448  19.671  0.80 46.34          
ATOM   2872  CE  MET   353      39.527  42.352  18.152  1.00 45.87          
ATOM   2873  N   LEU   354      38.055  48.655  17.199  1.00 34.24          
ATOM   2874  CA  LEU   354      37.061  49.380  16.407  1.00 33.83          
ATOM   2875  C   LEU   354      37.742  50.221  15.322  1.00 33.80          
ATOM   2876  O   LEU   354      37.346  50.153  14.151  1.00 33.96          
ATOM   2877  CB  LEU   354      36.146  50.250  17.289  1.00 32.30          
ATOM   2878  CG  LEU   354      35.121  49.479  18.130  1.00 32.81          
ATOM   2879  CD1 LEU   354      34.514  50.374  19.212  1.00 31.93          
ATOM   2880  CD2 LEU   354      33.999  48.833  17.286  1.00 31.66          
ATOM   2881  N   LYS   355      38.773  50.984  15.694  1.00 33.86          
ATOM   2882  CA  LYS   355      39.501  51.795  14.709  1.00 35.35          
ATOM   2883  C   LYS   355      40.116  50.938  13.630  1.00 35.95          
ATOM   2884  O   LYS   355      39.974  51.247  12.461  1.00 36.69          
ATOM   2885  CB  LYS   355      40.595  52.656  15.357  1.00 34.89          
ATOM   2886  CG  LYS   355      40.023  53.827  16.196  1.00 35.54          
ATOM   2887  CD  LYS   355      41.135  54.685  16.780  1.00 36.49          
ATOM   2888  CE  LYS   355      41.934  53.923  17.828  1.00 35.14          
ATOM   2889  NZ  LYS   355      42.797  54.919  18.514  1.00 35.20          
ATOM   2890  N   ASN   356      40.791  49.860  14.017  1.00 37.35          
ATOM   2891  CA  ASN   356      41.435  48.986  13.030  1.00 39.10          
ATOM   2892  C   ASN   356      40.431  48.455  11.994  1.00 38.68          
ATOM   2893  O   ASN   356      40.714  48.431  10.785  1.00 37.79          
ATOM   2894  CB  ASN   356      42.172  47.809  13.706  1.00 40.15          
ATOM   2895  CG  ASN   356      43.451  48.246  14.461  1.00 43.68          
ATOM   2896  OD1 ASN   356      44.011  49.329  14.226  1.00 46.00          
ATOM   2897  ND2 ASN   356      43.913  47.384  15.383  1.00 47.77          
ATOM   2898  N   GLN   357      39.268  48.024  12.474  1.00 38.78          
ATOM   2899  CA  GLN   357      38.234  47.499  11.583  1.00 39.30          
ATOM   2900  C   GLN   357      37.705  48.553  10.615  1.00 38.96          
ATOM   2901  O   GLN   357      37.661  48.317   9.422  1.00 38.74          
ATOM   2902  CB  GLN   357      37.121  46.807  12.375  1.00 39.47          
ATOM   2903  CG  GLN   357      37.662  45.571  13.057  1.00 43.75          
ATOM   2904  CD  GLN   357      36.655  44.810  13.903  1.00 49.96          
ATOM   2905  OE1 GLN   357      35.504  45.239  14.096  1.00 53.63          
ATOM   2906  NE2 GLN   357      37.100  43.662  14.434  1.00 52.16          
ATOM   2907  N   TYR   358      37.344  49.725  11.122  1.00 38.71          
ATOM   2908  CA  TYR   358      36.922  50.827  10.281  1.00 39.54          
ATOM   2909  C   TYR   358      37.969  51.180   9.224  1.00 40.55          
ATOM   2910  O   TYR   358      37.651  51.257   8.034  1.00 41.19          
ATOM   2911  CB  TYR   358      36.656  52.054  11.155  1.00 38.59          
ATOM   2912  CG  TYR   358      36.152  53.275  10.428  1.00 38.06          
ATOM   2913  CD1 TYR   358      34.794  53.439  10.142  1.00 38.41          
ATOM   2914  CD2 TYR   358      37.026  54.297  10.079  1.00 36.46          
ATOM   2915  CE1 TYR   358      34.340  54.595   9.500  1.00 37.60          
ATOM   2916  CE2 TYR   358      36.592  55.429   9.463  1.00 38.52          
ATOM   2917  CZ  TYR   358      35.253  55.581   9.169  1.00 38.54          
ATOM   2918  OH  TYR   358      34.864  56.734   8.525  1.00 37.13          
ATOM   2919  N   ILE   359      39.210  51.410   9.656  1.00 41.40          
ATOM   2920  CA  ILE   359      40.283  51.790   8.733  1.00 42.36          
ATOM   2921  C   ILE   359      40.450  50.772   7.609  1.00 43.90          
ATOM   2922  O   ILE   359      40.555  51.137   6.428  1.00 44.13          
ATOM   2923  CB  ILE   359      41.615  52.036   9.481  1.00 42.62          
ATOM   2924  CG1 ILE   359      41.508  53.342  10.305  1.00 41.74          
ATOM   2925  CG2 ILE   359      42.811  52.075   8.503  1.00 41.81          
ATOM   2926  CD  ILE   359      42.646  53.589  11.278  1.00 42.38          
ATOM   2927  N   LEU   360      40.442  49.498   7.974  1.00 45.17          
ATOM   2928  CA  LEU   360      40.538  48.407   7.002  1.00 46.92          
ATOM   2929  C   LEU   360      39.566  48.600   5.825  1.00 47.26          
ATOM   2930  O   LEU   360      39.947  48.440   4.662  1.00 46.98          
ATOM   2931  CB  LEU   360      40.245  47.067   7.691  1.00 46.80          
ATOM   2932  CG  LEU   360      41.191  45.915   7.360  1.00 49.88          
ATOM   2933  CD1 LEU   360      42.212  45.749   8.501  1.00 52.18          
ATOM   2934  CD2 LEU   360      40.439  44.603   7.110  1.00 50.77          
ATOM   2935  N   ALA   361      38.320  48.955   6.135  1.00 48.04          
ATOM   2936  CA  ALA   361      37.281  49.093   5.110  1.00 48.65          
ATOM   2937  C   ALA   361      37.347  50.395   4.295  1.00 49.23          
ATOM   2938  O   ALA   361      36.636  50.548   3.287  1.00 49.01          
ATOM   2939  CB  ALA   361      35.919  48.890   5.718  1.00 48.96          
ATOM   2940  N   LEU   362      38.222  51.317   4.706  1.00 49.85          
ATOM   2941  CA  LEU   362      38.434  52.583   3.980  1.00 50.21          
ATOM   2942  C   LEU   362      38.846  52.370   2.521  1.00 50.40          
ATOM   2943  O   LEU   362      38.596  53.234   1.663  1.00 50.85          
ATOM   2944  CB  LEU   362      39.490  53.466   4.670  1.00 50.26          
ATOM   2945  CG  LEU   362      39.090  54.341   5.865  1.00 50.85          
ATOM   2946  CD1 LEU   362      40.121  55.458   6.081  1.00 51.38          
ATOM   2947  CD2 LEU   362      37.705  54.932   5.682  1.00 51.92          
ATOM   2948  N   ASP   363      39.474  51.226   2.248  1.00 49.76          
ATOM   2949  CA  ASP   363      40.007  50.953   0.925  1.00 49.56          
ATOM   2950  C   ASP   363      38.956  50.379  -0.021  1.00 47.99          
ATOM   2951  O   ASP   363      38.973  50.642  -1.237  1.00 47.85          
ATOM   2952  CB  ASP   363      41.200  50.001   1.026  1.00 50.71          
ATOM   2953  CG  ASP   363      42.488  50.724   1.361  1.00 53.63          
ATOM   2954  OD1 ASP   363      42.433  51.944   1.687  1.00 56.29          
ATOM   2955  OD2 ASP   363      43.557  50.068   1.285  1.00 57.96          
ATOM   2956  N   ASN   364      38.047  49.609   0.557  1.00 45.39          
ATOM   2957  CA  ASN   364      37.131  48.783  -0.198  1.00 43.91          
ATOM   2958  C   ASN   364      36.053  49.548  -1.010  1.00 41.70          
ATOM   2959  O   ASN   364      35.296  50.335  -0.448  1.00 40.61          
ATOM   2960  CB  ASN   364      36.499  47.772   0.761  1.00 44.51          
ATOM   2961  CG  ASN   364      35.693  46.744   0.043  1.00 47.05          
ATOM   2962  OD1 ASN   364      34.508  46.947  -0.226  1.00 48.99          
ATOM   2963  ND2 ASN   364      36.325  45.618  -0.285  1.00 49.97          
ATOM   2964  N   ALA   365      35.988  49.287  -2.319  1.00 39.74          
ATOM   2965  CA  ALA   365      34.994  49.917  -3.209  1.00 38.36          
ATOM   2966  C   ALA   365      33.557  49.560  -2.821  1.00 37.61          
ATOM   2967  O   ALA   365      32.671  50.409  -2.866  1.00 37.22          
ATOM   2968  CB  ALA   365      35.260  49.576  -4.677  1.00 38.36          
ATOM   2969  N   GLY   366      33.323  48.315  -2.413  1.00 36.87          
ATOM   2970  CA  GLY   366      31.998  47.925  -1.904  1.00 35.96          
ATOM   2971  C   GLY   366      31.587  48.696  -0.670  1.00 35.68          
ATOM   2972  O   GLY   366      30.440  49.150  -0.555  1.00 35.84          
ATOM   2973  N   ALA   367      32.521  48.836   0.275  1.00 34.95          
ATOM   2974  CA  ALA   367      32.282  49.589   1.500  1.00 34.53          
ATOM   2975  C   ALA   367      32.018  51.057   1.182  1.00 33.65          
ATOM   2976  O   ALA   367      31.182  51.697   1.810  1.00 33.54          
ATOM   2977  CB  ALA   367      33.497  49.476   2.441  1.00 35.49          
ATOM   2978  N   TRP   368      32.752  51.580   0.219  1.00 33.01          
ATOM   2979  CA  TRP   368      32.600  52.967  -0.193  1.00 33.29          
ATOM   2980  C   TRP   368      31.171  53.179  -0.729  1.00 33.17          
ATOM   2981  O   TRP   368      30.454  54.055  -0.236  1.00 32.71          
ATOM   2982  CB  TRP   368      33.683  53.353  -1.209  1.00 33.87          
ATOM   2983  CG  TRP   368      33.734  54.817  -1.552  1.00 34.63          
ATOM   2984  CD1 TRP   368      32.838  55.782  -1.179  1.00 35.35          
ATOM   2985  CD2 TRP   368      34.707  55.479  -2.378  1.00 35.89          
ATOM   2986  NE1 TRP   368      33.204  57.006  -1.699  1.00 33.98          
ATOM   2987  CE2 TRP   368      34.343  56.847  -2.444  1.00 34.81          
ATOM   2988  CE3 TRP   368      35.857  55.053  -3.066  1.00 35.00          
ATOM   2989  CZ2 TRP   368      35.091  57.793  -3.163  1.00 34.69          
ATOM   2990  CZ3 TRP   368      36.589  55.987  -3.784  1.00 33.70          
ATOM   2991  CH2 TRP   368      36.204  57.342  -3.830  1.00 35.16          
ATOM   2992  N   LEU   369      30.739  52.345  -1.675  1.00 33.00          
ATOM   2993  CA  LEU   369      29.337  52.399  -2.159  1.00 34.24          
ATOM   2994  C   LEU   369      28.285  52.395  -1.045  1.00 33.77          
ATOM   2995  O   LEU   369      27.367  53.204  -1.087  1.00 34.42          
ATOM   2996  CB  LEU   369      29.020  51.312  -3.206  1.00 33.90          
ATOM   2997  CG  LEU   369      29.475  51.494  -4.650  1.00 35.42          
ATOM   2998  CD1 LEU   369      29.245  50.196  -5.444  1.00 37.79          
ATOM   2999  CD2 LEU   369      28.806  52.675  -5.377  1.00 32.76          
ATOM   3000  N   GLU   370      28.438  51.519  -0.049  1.00 33.78          
ATOM   3001  CA  GLU   370      27.538  51.483   1.116  1.00 34.24          
ATOM   3002  C   GLU   370      27.555  52.766   1.958  1.00 34.56          
ATOM   3003  O   GLU   370      26.503  53.211   2.409  1.00 33.68          
ATOM   3004  CB  GLU   370      27.777  50.263   2.023  1.00 33.88          
ATOM   3005  CG  GLU   370      27.543  48.897   1.362  1.00 35.76          
ATOM   3006  CD  GLU   370      26.132  48.750   0.757  1.00 37.17          
ATOM   3007  OE1 GLU   370      25.172  49.376   1.261  1.00 39.69          
ATOM   3008  OE2 GLU   370      25.990  48.025  -0.237  1.00 39.71          
ATOM   3009  N   LYS   371      28.741  53.339   2.193  1.00 35.69          
ATOM   3010  CA  LYS   371      28.845  54.645   2.852  1.00 36.89          
ATOM   3011  C   LYS   371      28.097  55.700   2.040  1.00 35.81          
ATOM   3012  O   LYS   371      27.369  56.506   2.605  1.00 36.14          
ATOM   3013  CB  LYS   371      30.315  55.076   3.042  1.00 37.46          
ATOM   3014  CG  LYS   371      31.075  54.231   4.053  1.00 40.23          
ATOM   3015  CD  LYS   371      32.523  54.722   4.318  1.00 40.33          
ATOM   3016  CE  LYS   371      33.176  53.811   5.377  1.00 43.32          
ATOM   3017  NZ  LYS   371      34.667  53.959   5.473  1.00 48.75          
ATOM   3018  N   GLU   372      28.285  55.694   0.725  1.00 35.25          
ATOM   3019  CA  GLU   372      27.601  56.648  -0.160  1.00 35.80          
ATOM   3020  C   GLU   372      26.082  56.496  -0.074  1.00 35.59          
ATOM   3021  O   GLU   372      25.349  57.485  -0.033  1.00 35.24          
ATOM   3022  CB  GLU   372      28.056  56.489  -1.617  1.00 36.01          
ATOM   3023  CG  GLU   372      29.495  56.924  -1.890  1.00 38.12          
ATOM   3024  CD  GLU   372      29.683  58.440  -1.899  1.00 43.41          
ATOM   3025  OE1 GLU   372      28.679  59.191  -1.851  1.00 42.98          
ATOM   3026  OE2 GLU   372      30.853  58.886  -1.961  1.00 46.57          
ATOM   3027  N   TYR   373      25.612  55.250  -0.032  1.00 35.45          
ATOM   3028  CA  TYR   373      24.189  55.018   0.080  1.00 35.44          
ATOM   3029  C   TYR   373      23.623  55.560   1.391  1.00 36.23          
ATOM   3030  O   TYR   373      22.636  56.307   1.380  1.00 36.19          
ATOM   3031  CB  TYR   373      23.857  53.542  -0.128  1.00 34.58          
ATOM   3032  CG  TYR   373      22.391  53.316  -0.404  1.00 33.23          
ATOM   3033  CD1 TYR   373      21.855  53.581  -1.648  1.00 32.58          
ATOM   3034  CD2 TYR   373      21.539  52.841   0.594  1.00 34.58          
ATOM   3035  CE1 TYR   373      20.498  53.389  -1.912  1.00 34.22          
ATOM   3036  CE2 TYR   373      20.181  52.644   0.346  1.00 35.65          
ATOM   3037  CZ  TYR   373      19.670  52.902  -0.915  1.00 33.23          
ATOM   3038  OH  TYR   373      18.334  52.676  -1.167  1.00 31.77          
ATOM   3039  N   LEU   374      24.253  55.225   2.517  1.00 37.55          
ATOM   3040  CA  LEU   374      23.784  55.736   3.805  1.00 38.74          
ATOM   3041  C   LEU   374      23.768  57.232   3.814  1.00 39.16          
ATOM   3042  O   LEU   374      22.803  57.836   4.267  1.00 39.38          
ATOM   3043  CB  LEU   374      24.618  55.236   4.997  1.00 39.05          
ATOM   3044  CG  LEU   374      24.553  53.735   5.269  1.00 40.45          
ATOM   3045  CD1 LEU   374      25.318  53.413   6.552  1.00 39.78          
ATOM   3046  CD2 LEU   374      23.093  53.237   5.337  1.00 41.15          
ATOM   3047  N   ASN   375      24.856  57.820   3.327  1.00 39.40          
ATOM   3048  CA  ASN   375      25.002  59.258   3.166  1.00 40.20          
ATOM   3049  C   ASN   375      23.872  59.912   2.386  1.00 40.24          
ATOM   3050  O   ASN   375      23.431  61.015   2.716  1.00 39.85          
ATOM   3051  CB  ASN   375      26.267  59.492   2.381  1.00 40.84          
ATOM   3052  CG  ASN   375      27.129  60.474   3.017  1.00 43.45          
ATOM   3053  OD1 ASN   375      26.894  61.670   2.882  1.00 45.07          
ATOM   3054  ND2 ASN   375      28.150  59.997   3.756  1.00 46.80          
ATOM   3055  N   GLU   376      23.449  59.231   1.330  1.00 40.45          
ATOM   3056  CA  GLU   376      22.350  59.663   0.487  1.00 41.53          
ATOM   3057  C   GLU   376      21.051  59.655   1.283  1.00 42.05          
ATOM   3058  O   GLU   376      20.291  60.602   1.232  1.00 41.37          
ATOM   3059  CB  GLU   376      22.232  58.740  -0.732  1.00 41.64          
ATOM   3060  CG  GLU   376      20.979  58.940  -1.582  1.00 41.79          
ATOM   3061  CD  GLU   376      20.916  60.316  -2.226  1.00 43.32          
ATOM   3062  OE1 GLU   376      21.977  60.976  -2.357  1.00 39.96          
ATOM   3063  OE2 GLU   376      19.791  60.730  -2.609  1.00 44.31          
ATOM   3064  N   LEU   377      20.819  58.587   2.035  1.00 42.74          
ATOM   3065  CA  LEU   377      19.654  58.506   2.913  1.00 44.16          
ATOM   3066  C   LEU   377      19.662  59.573   4.006  1.00 45.06          
ATOM   3067  O   LEU   377      18.690  60.311   4.189  1.00 45.33          
ATOM   3068  CB  LEU   377      19.560  57.113   3.538  1.00 43.66          
ATOM   3069  CG  LEU   377      19.478  55.959   2.542  1.00 43.81          
ATOM   3070  CD1 LEU   377      19.638  54.636   3.247  1.00 45.64          
ATOM   3071  CD2 LEU   377      18.180  55.977   1.757  1.00 45.46          
ATOM   3072  N   MET   378      20.776  59.681   4.716  1.00 45.63          
ATOM   3073  CA  MET   378      20.833  60.548   5.871  1.00 46.72          
ATOM   3074  C   MET   378      21.970  61.514   5.781  1.00 46.45          
ATOM   3075  O   MET   378      23.032  61.294   6.384  1.00 45.42          
ATOM   3076  CB  MET   378      20.947  59.713   7.125  1.00 46.51          
ATOM   3077  CG  MET   378      19.833  58.729   7.249  1.00 46.95          
ATOM   3078  SD  MET   378      20.153  57.738   8.835  0.70 50.67          
ATOM   3079  CE  MET   378      21.071  56.200   8.187  1.00 38.96          
ATOM   3080  N   PRO   379      21.733  62.618   5.058  1.00 46.92          
ATOM   3081  CA  PRO   379      22.751  63.557   4.602  1.00 47.95          
ATOM   3082  C   PRO   379      23.531  64.232   5.707  1.00 48.42          
ATOM   3083  O   PRO   379      24.627  64.726   5.469  1.00 49.11          
ATOM   3084  CB  PRO   379      21.941  64.613   3.826  1.00 47.61          
ATOM   3085  CG  PRO   379      20.668  63.946   3.482  1.00 47.67          
ATOM   3086  CD  PRO   379      20.387  63.042   4.638  1.00 47.05          
ATOM   3087  N   GLN   380      22.985  64.293   6.902  1.00 49.29          
ATOM   3088  CA  GLN   380      23.697  65.049   7.914  1.00 50.47          
ATOM   3089  C   GLN   380      24.167  64.225   9.077  1.00 49.70          
ATOM   3090  O   GLN   380      24.466  64.742  10.148  1.00 50.21          
ATOM   3091  CB  GLN   380      22.948  66.335   8.291  1.00 50.97          
ATOM   3092  CG  GLN   380      23.214  67.454   7.232  1.00 52.53          
ATOM   3093  CD  GLN   380      22.207  68.595   7.244  1.00 53.38          
ATOM   3094  OE1 GLN   380      22.203  69.449   8.154  1.00 56.54          
ATOM   3095  NE2 GLN   380      21.371  68.646   6.199  1.00 56.24          
ATOM   3096  N   THR   381      24.290  62.925   8.818  1.00 48.46          
ATOM   3097  CA  THR   381      24.947  62.010   9.721  1.00 47.97          
ATOM   3098  C   THR   381      26.372  61.808   9.231  1.00 47.37          
ATOM   3099  O   THR   381      27.086  60.976   9.752  1.00 46.91          
ATOM   3100  CB  THR   381      24.220  60.656   9.747  1.00 48.09          
ATOM   3101  OG1 THR   381      24.414  60.002   8.488  1.00 48.89          
ATOM   3102  CG2 THR   381      22.744  60.875   9.950  1.00 48.48          
ATOM   3103  N   MET   382      26.766  62.605   8.228  1.00 47.24          
ATOM   3104  CA  MET   382      28.029  62.447   7.483  1.00 46.89          
ATOM   3105  C   MET   382      29.244  62.743   8.322  1.00 46.14          
ATOM   3106  O   MET   382      29.372  63.849   8.880  1.00 46.21          
ATOM   3107  CB  MET   382      28.077  63.423   6.305  1.00 47.09          
ATOM   3108  CG  MET   382      27.091  63.127   5.213  1.00 47.78          
ATOM   3109  SD  MET   382      27.459  64.102   3.558  0.50 48.62          
ATOM   3110  CE  MET   382      29.399  63.776   3.368  1.00 46.02          
ATOM   3111  N   LEU   383      30.151  61.777   8.390  1.00 45.04          
ATOM   3112  CA  LEU   383      31.394  61.949   9.143  1.00 43.44          
ATOM   3113  C   LEU   383      32.587  61.550   8.280  1.00 42.41          
ATOM   3114  O   LEU   383      32.545  60.533   7.602  1.00 42.18          
ATOM   3115  CB  LEU   383      31.335  61.148  10.452  1.00 43.44          
ATOM   3116  CG  LEU   383      31.154  61.896  11.781  1.00 44.42          
ATOM   3117  CD1 LEU   383      30.373  63.204  11.693  1.00 44.57          
ATOM   3118  CD2 LEU   383      30.581  61.063  12.883  1.00 42.84          
ATOM   3119  N   THR   384      33.631  62.366   8.281  1.00 41.27          
ATOM   3120  CA  THR   384      34.840  62.004   7.565  1.00 40.04          
ATOM   3121  C   THR   384      35.516  60.892   8.354  1.00 39.35          
ATOM   3122  O   THR   384      35.174  60.637   9.517  1.00 37.79          
ATOM   3123  CB  THR   384      35.810  63.181   7.388  1.00 40.16          
ATOM   3124  OG1 THR   384      36.383  63.542   8.660  1.00 39.14          
ATOM   3125  CG2 THR   384      35.109  64.373   6.769  1.00 40.48          
ATOM   3126  N   ALA   385      36.466  60.224   7.719  1.00 38.58          
ATOM   3127  CA  ALA   385      37.202  59.160   8.393  1.00 38.72          
ATOM   3128  C   ALA   385      37.945  59.728   9.604  1.00 37.97          
ATOM   3129  O   ALA   385      37.923  59.125  10.665  1.00 38.04          
ATOM   3130  CB  ALA   385      38.161  58.469   7.427  1.00 39.13          
ATOM   3131  N   GLU   386      38.580  60.886   9.438  1.00 37.61          
ATOM   3132  CA  GLU   386      39.227  61.595  10.550  1.00 37.76          
ATOM   3133  C   GLU   386      38.279  61.865  11.745  1.00 35.74          
ATOM   3134  O   GLU   386      38.660  61.640  12.891  1.00 34.61          
ATOM   3135  CB  GLU   386      39.898  62.896  10.068  1.00 37.48          
ATOM   3136  CG  GLU   386      40.480  63.741  11.201  1.00 40.15          
ATOM   3137  CD  GLU   386      41.432  64.861  10.749  1.00 42.00          
ATOM   3138  OE1 GLU   386      41.487  65.191   9.536  1.00 46.36          
ATOM   3139  OE2 GLU   386      42.135  65.422  11.631  1.00 47.64          
ATOM   3140  N   GLU   387      37.062  62.336  11.483  1.00 34.31          
ATOM   3141  CA  GLU   387      36.127  62.615  12.570  1.00 34.34          
ATOM   3142  C   GLU   387      35.565  61.341  13.212  1.00 32.91          
ATOM   3143  O   GLU   387      35.340  61.285  14.424  1.00 32.26          
ATOM   3144  CB  GLU   387      34.983  63.517  12.102  1.00 35.33          
ATOM   3145  CG  GLU   387      33.882  63.749  13.194  1.00 39.31          
ATOM   3146  CD  GLU   387      34.338  64.639  14.379  1.00 42.73          
ATOM   3147  OE1 GLU   387      35.423  65.246  14.283  1.00 44.76          
ATOM   3148  OE2 GLU   387      33.600  64.754  15.397  1.00 45.63          
ATOM   3149  N   TRP   388      35.352  60.315  12.399  1.00 31.86          
ATOM   3150  CA  TRP   388      34.887  59.020  12.912  1.00 32.42          
ATOM   3151  C   TRP   388      35.883  58.516  13.958  1.00 31.71          
ATOM   3152  O   TRP   388      35.512  58.184  15.093  1.00 30.96          
ATOM   3153  CB  TRP   388      34.717  58.014  11.755  1.00 32.95          
ATOM   3154  CG  TRP   388      33.990  56.778  12.164  1.00 32.77          
ATOM   3155  CD1 TRP   388      32.652  56.513  12.008  1.00 33.75          
ATOM   3156  CD2 TRP   388      34.551  55.639  12.836  1.00 34.86          
ATOM   3157  NE1 TRP   388      32.350  55.271  12.537  1.00 35.81          
ATOM   3158  CE2 TRP   388      33.492  54.714  13.052  1.00 32.94          
ATOM   3159  CE3 TRP   388      35.844  55.305  13.253  1.00 32.86          
ATOM   3160  CZ2 TRP   388      33.689  53.467  13.660  1.00 36.83          
ATOM   3161  CZ3 TRP   388      36.041  54.056  13.879  1.00 34.86          
ATOM   3162  CH2 TRP   388      34.968  53.156  14.074  1.00 34.15          
ATOM   3163  N   ILE   389      37.153  58.487  13.569  1.00 31.86          
ATOM   3164  CA  ILE   389      38.245  58.065  14.454  1.00 32.62          
ATOM   3165  C   ILE   389      38.354  58.936  15.719  1.00 32.50          
ATOM   3166  O   ILE   389      38.511  58.419  16.829  1.00 32.27          
ATOM   3167  CB  ILE   389      39.596  58.030  13.669  1.00 32.82          
ATOM   3168  CG1 ILE   389      39.632  56.808  12.751  1.00 34.60          
ATOM   3169  CG2 ILE   389      40.828  58.008  14.621  1.00 33.23          
ATOM   3170  CD  ILE   389      40.436  57.018  11.475  1.00 40.11          
ATOM   3171  N   ALA   390      38.271  60.251  15.553  1.00 31.76          
ATOM   3172  CA  ALA   390      38.266  61.163  16.697  1.00 31.77          
ATOM   3173  C   ALA   390      37.110  60.841  17.683  1.00 32.26          
ATOM   3174  O   ALA   390      37.280  60.827  18.918  1.00 31.99          
ATOM   3175  CB  ALA   390      38.176  62.598  16.211  1.00 31.45          
ATOM   3176  N   ARG   391      35.939  60.556  17.134  1.00 31.47          
ATOM   3177  CA  ARG   391      34.793  60.282  17.989  1.00 31.51          
ATOM   3178  C   ARG   391      34.950  58.961  18.738  1.00 32.13          
ATOM   3179  O   ARG   391      34.632  58.893  19.944  1.00 32.70          
ATOM   3180  CB  ARG   391      33.485  60.381  17.206  1.00 30.17          
ATOM   3181  CG  ARG   391      33.099  61.853  17.003  1.00 30.95          
ATOM   3182  CD  ARG   391      31.789  61.986  16.288  1.00 28.87          
ATOM   3183  NE  ARG   391      31.479  63.386  16.011  1.00 29.36          
ATOM   3184  CZ  ARG   391      30.241  63.831  15.773  1.00 30.12          
ATOM   3185  NH1 ARG   391      29.207  62.987  15.801  1.00 28.71          
ATOM   3186  NH2 ARG   391      30.036  65.108  15.540  1.00 27.94          
ATOM   3187  N   ILE   392      35.477  57.929  18.069  1.00 31.81          
ATOM   3188  CA  ILE   392      35.847  56.701  18.808  1.00 31.73          
ATOM   3189  C   ILE   392      36.849  56.968  19.940  1.00 32.81          
ATOM   3190  O   ILE   392      36.654  56.545  21.107  1.00 32.20          
ATOM   3191  CB  ILE   392      36.366  55.580  17.853  1.00 32.62          
ATOM   3192  CG1 ILE   392      35.200  55.051  17.001  1.00 31.85          
ATOM   3193  CG2 ILE   392      36.961  54.416  18.649  1.00 31.00          
ATOM   3194  CD  ILE   392      34.111  54.245  17.805  1.00 36.17          
ATOM   3195  N   ASN   393      37.922  57.678  19.603  1.00 33.37          
ATOM   3196  CA  ASN   393      38.938  58.065  20.599  1.00 34.16          
ATOM   3197  C   ASN   393      38.412  58.834  21.818  1.00 34.41          
ATOM   3198  O   ASN   393      38.921  58.662  22.915  1.00 34.44          
ATOM   3199  CB  ASN   393      40.076  58.845  19.933  1.00 33.72          
ATOM   3200  CG  ASN   393      41.030  57.953  19.173  1.00 34.84          
ATOM   3201  OD1 ASN   393      41.295  56.797  19.557  1.00 34.26          
ATOM   3202  ND2 ASN   393      41.553  58.473  18.090  1.00 35.13          
ATOM   3203  N   ALA   394      37.378  59.656  21.622  1.00 34.78          
ATOM   3204  CA  ALA   394      36.889  60.554  22.667  1.00 35.15          
ATOM   3205  C   ALA   394      35.872  59.939  23.631  1.00 34.51          
ATOM   3206  O   ALA   394      35.486  60.596  24.621  1.00 34.67          
ATOM   3207  CB  ALA   394      36.318  61.850  22.053  1.00 35.23          
ATOM   3208  N   VAL   395      35.411  58.714  23.344  1.00 32.75          
ATOM   3209  CA  VAL   395      34.443  58.068  24.234  1.00 32.11          
ATOM   3210  C   VAL   395      34.998  57.955  25.655  1.00 31.61          
ATOM   3211  O   VAL   395      36.123  57.502  25.842  1.00 31.60          
ATOM   3212  CB  VAL   395      33.948  56.680  23.714  1.00 32.01          
ATOM   3213  CG1 VAL   395      32.988  56.028  24.733  1.00 30.65          
ATOM   3214  CG2 VAL   395      33.260  56.819  22.333  1.00 30.25          
ATOM   3215  N   THR   396      34.190  58.365  26.635  1.00 31.11          
ATOM   3216  CA  THR   396      34.572  58.339  28.057  1.00 30.84          
ATOM   3217  C   THR   396      33.808  57.267  28.831  1.00 30.88          
ATOM   3218  O   THR   396      32.807  56.738  28.348  1.00 31.40          
ATOM   3219  CB  THR   396      34.342  59.697  28.720  1.00 30.78          
ATOM   3220  OG1 THR   396      32.941  59.936  28.794  1.00 30.70          
ATOM   3221  CG2 THR   396      34.996  60.827  27.910  1.00 31.56          
ATOM   3222  N   ILE   397      34.290  56.930  30.028  1.00 30.79          
ATOM   3223  CA  ILE   397      33.621  55.937  30.863  1.00 31.05          
ATOM   3224  C   ILE   397      32.203  56.366  31.232  1.00 30.53          
ATOM   3225  O   ILE   397      31.291  55.543  31.123  1.00 29.89          
ATOM   3226  CB  ILE   397      34.471  55.544  32.088  1.00 31.93          
ATOM   3227  CG1 ILE   397      35.608  54.617  31.627  1.00 32.69          
ATOM   3228  CG2 ILE   397      33.632  54.836  33.177  1.00 32.40          
ATOM   3229  CD  ILE   397      36.703  54.393  32.723  1.00 32.94          
ATOM   3230  N   PRO   398      32.010  57.640  31.667  1.00 29.25          
ATOM   3231  CA  PRO   398      30.649  58.115  31.966  1.00 29.22          
ATOM   3232  C   PRO   398      29.676  57.932  30.788  1.00 28.68          
ATOM   3233  O   PRO   398      28.510  57.568  31.009  1.00 28.39          
ATOM   3234  CB  PRO   398      30.859  59.593  32.362  1.00 29.29          
ATOM   3235  CG  PRO   398      32.263  59.605  32.965  1.00 29.06          
ATOM   3236  CD  PRO   398      33.022  58.652  32.024  1.00 29.97          
ATOM   3237  N   GLU   399      30.151  58.107  29.554  1.00 27.95          
ATOM   3238  CA  GLU   399      29.291  57.850  28.389  1.00 28.81          
ATOM   3239  C   GLU   399      28.927  56.383  28.234  1.00 29.40          
ATOM   3240  O   GLU   399      27.769  56.052  27.876  1.00 30.32          
ATOM   3241  CB  GLU   399      29.935  58.330  27.099  1.00 28.49          
ATOM   3242  CG  GLU   399      29.994  59.891  26.982  1.00 29.77          
ATOM   3243  CD  GLU   399      30.826  60.338  25.777  1.00 30.64          
ATOM   3244  OE1 GLU   399      31.693  59.538  25.326  1.00 32.78          
ATOM   3245  OE2 GLU   399      30.625  61.471  25.275  1.00 31.80          
ATOM   3246  N   ILE   400      29.902  55.513  28.507  1.00 28.88          
ATOM   3247  CA  ILE   400      29.686  54.060  28.463  1.00 28.68          
ATOM   3248  C   ILE   400      28.692  53.615  29.532  1.00 29.45          
ATOM   3249  O   ILE   400      27.819  52.740  29.256  1.00 29.87          
ATOM   3250  CB  ILE   400      31.039  53.299  28.603  1.00 29.24          
ATOM   3251  CG1 ILE   400      32.009  53.680  27.459  1.00 28.11          
ATOM   3252  CG2 ILE   400      30.797  51.759  28.692  1.00 28.02          
ATOM   3253  CD  ILE   400      33.474  53.400  27.711  1.00 27.97          
ATOM   3254  N   GLN   401      28.822  54.188  30.739  1.00 29.82          
ATOM   3255  CA  GLN   401      27.924  53.902  31.859  1.00 30.91          
ATOM   3256  C   GLN   401      26.501  54.325  31.509  1.00 31.20          
ATOM   3257  O   GLN   401      25.525  53.610  31.818  1.00 30.23          
ATOM   3258  CB  GLN   401      28.337  54.668  33.136  1.00 30.26          
ATOM   3259  CG  GLN   401      29.660  54.285  33.769  1.00 31.10          
ATOM   3260  CD  GLN   401      29.968  55.143  34.987  1.00 31.12          
ATOM   3261  OE1 GLN   401      30.736  56.112  34.894  1.00 33.37          
ATOM   3262  NE2 GLN   401      29.374  54.806  36.125  1.00 27.94          
ATOM   3263  N   GLU   402      26.376  55.499  30.883  1.00 31.10          
ATOM   3264  CA  GLU   402      25.045  55.956  30.427  1.00 32.41          
ATOM   3265  C   GLU   402      24.389  55.002  29.377  1.00 32.14          
ATOM   3266  O   GLU   402      23.195  54.696  29.476  1.00 32.72          
ATOM   3267  CB  GLU   402      25.113  57.411  29.922  1.00 33.04          
ATOM   3268  CG  GLU   402      23.807  57.995  29.400  1.00 35.65          
ATOM   3269  CD  GLU   402      22.701  58.021  30.454  1.00 40.76          
ATOM   3270  OE1 GLU   402      23.015  58.099  31.675  1.00 39.43          
ATOM   3271  OE2 GLU   402      21.511  57.965  30.043  1.00 42.92          
ATOM   3272  N   VAL   403      25.150  54.551  28.387  1.00 31.30          
ATOM   3273  CA  VAL   403      24.665  53.553  27.422  1.00 31.46          
ATOM   3274  C   VAL   403      24.196  52.308  28.209  1.00 31.88          
ATOM   3275  O   VAL   403      23.096  51.786  27.981  1.00 30.46          
ATOM   3276  CB  VAL   403      25.780  53.180  26.382  1.00 31.85          
ATOM   3277  CG1 VAL   403      25.446  51.883  25.608  1.00 30.73          
ATOM   3278  CG2 VAL   403      25.990  54.360  25.418  1.00 30.71          
ATOM   3279  N   ALA   404      25.015  51.869  29.161  1.00 31.58          
ATOM   3280  CA  ALA   404      24.675  50.665  29.963  1.00 33.16          
ATOM   3281  C   ALA   404      23.379  50.859  30.765  1.00 33.27          
ATOM   3282  O   ALA   404      22.556  49.927  30.886  1.00 34.34          
ATOM   3283  CB  ALA   404      25.827  50.316  30.887  1.00 32.10          
ATOM   3284  N   LYS   405      23.182  52.063  31.308  1.00 34.06          
ATOM   3285  CA  LYS   405      21.952  52.360  32.060  1.00 34.86          
ATOM   3286  C   LYS   405      20.724  52.441  31.156  1.00 34.99          
ATOM   3287  O   LYS   405      19.619  52.097  31.581  1.00 34.34          
ATOM   3288  CB  LYS   405      22.095  53.653  32.885  1.00 34.62          
ATOM   3289  CG  LYS   405      22.996  53.494  34.120  1.00 38.28          
ATOM   3290  CD  LYS   405      23.339  54.861  34.744  1.00 38.24          
ATOM   3291  CE  LYS   405      24.341  54.690  35.890  1.00 42.76          
ATOM   3292  NZ  LYS   405      24.909  56.026  36.278  1.00 45.53          
ATOM   3293  N   ARG   406      20.912  52.901  29.919  1.00 34.87          
ATOM   3294  CA  ARG   406      19.799  52.987  28.943  1.00 36.30          
ATOM   3295  C   ARG   406      19.312  51.633  28.463  1.00 36.14          
ATOM   3296  O   ARG   406      18.148  51.469  28.119  1.00 36.44          
ATOM   3297  CB  ARG   406      20.247  53.776  27.726  1.00 36.27          
ATOM   3298  CG  ARG   406      20.254  55.244  27.997  1.00 38.25          
ATOM   3299  CD  ARG   406      20.842  56.023  26.833  1.00 41.27          
ATOM   3300  NE  ARG   406      20.921  57.445  27.188  1.00 42.58          
ATOM   3301  CZ  ARG   406      20.432  58.434  26.446  1.00 44.07          
ATOM   3302  NH1 ARG   406      19.824  58.167  25.290  1.00 42.06          
ATOM   3303  NH2 ARG   406      20.560  59.687  26.871  1.00 43.66          
ATOM   3304  N   LEU   407      20.234  50.680  28.405  1.00 36.99          
ATOM   3305  CA  LEU   407      19.960  49.315  27.988  1.00 37.49          
ATOM   3306  C   LEU   407      18.840  48.763  28.807  1.00 37.63          
ATOM   3307  O   LEU   407      18.848  48.916  30.020  1.00 38.70          
ATOM   3308  CB  LEU   407      21.183  48.452  28.271  1.00 38.91          
ATOM   3309  CG  LEU   407      21.504  47.426  27.220  1.00 40.13          
ATOM   3310  CD1 LEU   407      22.104  48.240  26.097  1.00 42.89          
ATOM   3311  CD2 LEU   407      22.522  46.423  27.715  1.00 41.18          
ATOM   3312  N   GLU   408      17.900  48.080  28.172  1.00 36.88          
ATOM   3313  CA  GLU   408      16.778  47.508  28.891  1.00 37.41          
ATOM   3314  C   GLU   408      16.465  46.131  28.325  1.00 36.22          
ATOM   3315  O   GLU   408      16.044  46.017  27.174  1.00 34.06          
ATOM   3316  CB  GLU   408      15.551  48.399  28.728  1.00 38.23          
ATOM   3317  CG  GLU   408      14.338  47.913  29.456  1.00 44.20          
ATOM   3318  CD  GLU   408      14.337  48.280  30.947  1.00 50.29          
ATOM   3319  OE1 GLU   408      13.546  47.662  31.698  1.00 54.30          
ATOM   3320  OE2 GLU   408      15.107  49.178  31.359  1.00 52.67          
ATOM   3321  N   LEU   409      16.651  45.098  29.142  1.00 35.15          
ATOM   3322  CA  LEU   409      16.364  43.709  28.707  1.00 34.51          
ATOM   3323  C   LEU   409      14.893  43.570  28.373  1.00 34.30          
ATOM   3324  O   LEU   409      14.025  44.110  29.096  1.00 34.50          
ATOM   3325  CB  LEU   409      16.821  42.689  29.765  1.00 34.77          
ATOM   3326  CG  LEU   409      16.654  41.194  29.487  1.00 34.70          
ATOM   3327  CD1 LEU   409      17.344  40.800  28.174  1.00 30.33          
ATOM   3328  CD2 LEU   409      17.172  40.351  30.671  1.00 33.34          
ATOM   3329  N   GLN   410      14.610  42.896  27.249  1.00 32.92          
ATOM   3330  CA  GLN   410      13.243  42.771  26.722  1.00 31.56          
ATOM   3331  C   GLN   410      12.809  41.345  26.392  1.00 30.61          
ATOM   3332  O   GLN   410      11.630  41.001  26.520  1.00 29.52          
ATOM   3333  CB  GLN   410      13.059  43.661  25.477  1.00 31.87          
ATOM   3334  CG  GLN   410      13.048  45.205  25.784  1.00 31.97          
ATOM   3335  CD  GLN   410      11.807  45.661  26.537  1.00 34.44          
ATOM   3336  OE1 GLN   410      11.744  45.607  27.788  1.00 37.63          
ATOM   3337  NE2 GLN   410      10.808  46.108  25.796  1.00 30.72          
ATOM   3338  N   ALA   411      13.745  40.509  25.960  1.00 29.82          
ATOM   3339  CA  ALA   411      13.373  39.169  25.543  1.00 30.02          
ATOM   3340  C   ALA   411      14.523  38.215  25.805  1.00 30.01          
ATOM   3341  O   ALA   411      15.684  38.597  25.740  1.00 29.01          
ATOM   3342  CB  ALA   411      12.954  39.168  24.050  1.00 29.02          
ATOM   3343  N   ILE   412      14.190  36.975  26.131  1.00 30.36          
ATOM   3344  CA  ILE   412      15.191  35.941  26.326  1.00 31.06          
ATOM   3345  C   ILE   412      14.676  34.732  25.548  1.00 31.27          
ATOM   3346  O   ILE   412      13.517  34.311  25.732  1.00 30.98          
ATOM   3347  CB  ILE   412      15.286  35.497  27.815  1.00 31.24          
ATOM   3348  CG1 ILE   412      15.807  36.615  28.712  1.00 33.16          
ATOM   3349  CG2 ILE   412      16.132  34.191  27.952  1.00 33.12          
ATOM   3350  CD  ILE   412      15.559  36.356  30.177  1.00 33.99          
ATOM   3351  N   PHE   413      15.516  34.167  24.687  1.00 31.05          
ATOM   3352  CA  PHE   413      15.129  32.955  23.991  1.00 30.84          
ATOM   3353  C   PHE   413      16.091  31.851  24.377  1.00 30.66          
ATOM   3354  O   PHE   413      17.318  32.031  24.316  1.00 30.01          
ATOM   3355  CB  PHE   413      15.127  33.146  22.462  1.00 32.47          
ATOM   3356  CG  PHE   413      14.751  31.888  21.711  1.00 33.14          
ATOM   3357  CD1 PHE   413      13.426  31.491  21.616  1.00 35.27          
ATOM   3358  CD2 PHE   413      15.742  31.059  21.174  1.00 35.41          
ATOM   3359  CE1 PHE   413      13.085  30.299  20.947  1.00 34.86          
ATOM   3360  CE2 PHE   413      15.421  29.863  20.509  1.00 34.32          
ATOM   3361  CZ  PHE   413      14.095  29.480  20.399  1.00 33.97          
ATOM   3362  N   PHE   414      15.527  30.721  24.782  1.00 29.69          
ATOM   3363  CA  PHE   414      16.284  29.568  25.238  1.00 30.05          
ATOM   3364  C   PHE   414      15.982  28.362  24.341  1.00 30.26          
ATOM   3365  O   PHE   414      14.842  27.890  24.268  1.00 30.15          
ATOM   3366  CB  PHE   414      15.910  29.306  26.705  1.00 30.09          
ATOM   3367  CG  PHE   414      16.611  28.122  27.350  1.00 30.68          
ATOM   3368  CD1 PHE   414      17.948  27.844  27.094  1.00 29.84          
ATOM   3369  CD2 PHE   414      15.917  27.315  28.254  1.00 30.02          
ATOM   3370  CE1 PHE   414      18.601  26.773  27.731  1.00 30.70          
ATOM   3371  CE2 PHE   414      16.555  26.224  28.886  1.00 31.58          
ATOM   3372  CZ  PHE   414      17.911  25.967  28.627  1.00 29.41          
ATOM   3373  N   LEU   415      16.999  27.886  23.622  1.00 29.90          
ATOM   3374  CA  LEU   415      16.835  26.689  22.805  1.00 29.57          
ATOM   3375  C   LEU   415      17.451  25.571  23.601  1.00 30.60          
ATOM   3376  O   LEU   415      18.677  25.501  23.731  1.00 28.45          
ATOM   3377  CB  LEU   415      17.495  26.820  21.421  1.00 29.40          
ATOM   3378  CG  LEU   415      17.243  25.689  20.404  1.00 30.34          
ATOM   3379  CD1 LEU   415      15.785  25.731  19.879  1.00 33.66          
ATOM   3380  CD2 LEU   415      18.173  25.829  19.252  1.00 29.27          
ATOM   3381  N   GLU   416      16.588  24.714  24.153  1.00 31.05          
ATOM   3382  CA  GLU   416      17.004  23.788  25.174  1.00 33.55          
ATOM   3383  C   GLU   416      17.204  22.405  24.598  1.00 33.33          
ATOM   3384  O   GLU   416      16.272  21.804  24.033  1.00 31.94          
ATOM   3385  CB  GLU   416      15.995  23.756  26.324  1.00 33.15          
ATOM   3386  CG  GLU   416      16.385  22.784  27.450  1.00 37.03          
ATOM   3387  CD  GLU   416      15.438  22.860  28.655  1.00 37.10          
ATOM   3388  OE1 GLU   416      14.221  22.920  28.432  1.00 40.26          
ATOM   3389  OE2 GLU   416      15.925  22.866  29.811  1.00 42.16          
ATOM   3390  N   GLY   417      18.426  21.901  24.751  1.00 33.63          
ATOM   3391  CA  GLY   417      18.770  20.601  24.231  1.00 34.97          
ATOM   3392  C   GLY   417      18.065  19.505  24.996  1.00 37.06          
ATOM   3393  O   GLY   417      18.006  19.541  26.229  1.00 36.74          
ATOM   3394  N   GLU   418      17.494  18.560  24.240  1.00 38.95          
ATOM   3395  CA  GLU   418      17.045  17.267  24.738  1.00 41.92          
ATOM   3396  C   GLU   418      18.155  16.277  24.409  1.00 41.64          
ATOM   3397  O   GLU   418      18.460  16.007  23.228  1.00 41.87          
ATOM   3398  CB  GLU   418      15.721  16.849  24.073  1.00 41.23          
ATOM   3399  CG  GLU   418      14.657  17.945  24.146  1.00 44.94          
ATOM   3400  CD  GLU   418      13.286  17.553  23.553  1.00 46.93          
ATOM   3401  OE1 GLU   418      13.208  17.175  22.345  1.00 53.00          
ATOM   3402  OE2 GLU   418      12.283  17.650  24.308  1.00 53.14          
ATOM   3403  N   THR   419      18.812  15.772  25.444  1.00 41.88          
ATOM   3404  CA  THR   419      19.871  14.793  25.216  1.00 42.16          
ATOM   3405  C   THR   419      19.469  13.434  25.785  1.00 43.12          
ATOM   3406  O   THR   419      20.102  12.436  25.497  1.00 42.14          
ATOM   3407  CB  THR   419      21.241  15.263  25.789  1.00 42.00          
ATOM   3408  OG1 THR   419      21.233  15.138  27.213  1.00 42.00          
ATOM   3409  CG2 THR   419      21.563  16.729  25.410  1.00 40.32          
ATOM   3410  N   GLU   420      18.409  13.404  26.587  1.00 44.89          
ATOM   3411  CA  GLU   420      18.017  12.177  27.294  1.00 47.08          
ATOM   3412  C   GLU   420      16.792  11.537  26.658  1.00 47.75          
ATOM   3413  O   GLU   420      15.854  12.230  26.263  1.00 47.47          
ATOM   3414  CB  GLU   420      17.755  12.443  28.784  1.00 47.51          
ATOM   3415  CG  GLU   420      18.933  13.088  29.529  1.00 50.05          
ATOM   3416  CD  GLU   420      18.861  12.886  31.033  1.00 53.10          
ATOM   3417  OE1 GLU   420      18.739  13.895  31.756  1.00 54.52          
ATOM   3418  OE2 GLU   420      18.913  11.717  31.488  1.00 54.69          
ATOM   3419  N   ASN   421      16.827  10.214  26.550  1.00 48.44          
ATOM   3420  CA  ASN   421      15.730   9.457  25.970  1.00 49.72          
ATOM   3421  C   ASN   421      14.631   9.114  26.969  1.00 51.45          
ATOM   3422  O   ASN   421      14.856   9.112  28.184  1.00 51.64          
ATOM   3423  CB  ASN   421      16.258   8.173  25.338  1.00 49.01          
ATOM   3424  CG  ASN   421      16.659   8.366  23.904  1.00 47.05          
ATOM   3425  OD1 ASN   421      15.988   9.068  23.152  1.00 43.50          
ATOM   3426  ND2 ASN   421      17.746   7.732  23.506  1.00 44.92          
ATOM   3427  N   ASP   422      13.442   8.838  26.430  1.00 53.22          
ATOM   3428  CA  ASP   422      12.281   8.338  27.188  1.00 55.09          
ATOM   3429  C   ASP   422      11.423   9.409  27.868  1.00 55.39          
ATOM   3430  OT1 ASP   422      10.298   9.109  28.291  1.00 55.62          
ATOM   3431  CB  ASP   422      12.687   7.226  28.169  1.00 55.41          
ATOM   3432  CG  ASP   422      13.197   5.988  27.456  1.00 57.46          
ATOM   3433  OD1 ASP   422      12.744   5.735  26.315  1.00 59.13          
ATOM   3434  OD2 ASP   422      14.051   5.268  28.026  1.00 59.04          
ATOM   3435  OT2 ASP   422      11.813  10.582  27.990  1.00 55.73          
END
