
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  103 (  747),  selected  103 , name 2pd1_A
# Molecule2: number of CA atoms  184 ( 1504),  selected  184 , name T0427_239_422.pdb
# PARAMETERS: 2pd1_A.T0427_239_422.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    -1_A      V     239           -
LGA    -       -      I     240           -
LGA    -       -      E     241           -
LGA    -       -      E     242           -
LGA    -       -      R     243           -
LGA    -       -      T     244           -
LGA    -       -      E     245           -
LGA    -       -      R     246           -
LGA    -       -      E     247           -
LGA    -       -      V     248           -
LGA    H     0_A      L     249          3.753
LGA    X     1_A      A     250          2.259
LGA    T     2_A      Q     251          0.724
LGA    K     3_A      S     252          1.983
LGA    L     4_A      K     253          3.753
LGA    A     5_A      -       -           -
LGA    L     6_A      L     254          2.591
LGA    F     7_A      N     255          2.360
LGA    V     8_A      L     256          1.699
LGA    R     9_A      A     257          1.789
LGA    L    10_A      Y     258          2.103
LGA    E    11_A      N     259          2.308
LGA    A    12_A      T     260          2.203
LGA    K    13_A      D     261          4.399
LGA    P    14_A      I     262          4.462
LGA    -       -      Y     263           -
LGA    -       -      Y     264           -
LGA    -       -      G     265           -
LGA    -       -      D     266           -
LGA    G    15_A      S     267          2.527
LGA    Q    16_A      Y     268          2.417
LGA    E    17_A      Y     269          3.172
LGA    A    18_A      F     270          2.734
LGA    A    19_A      A     271          2.026
LGA    L    20_A      L     272          2.756
LGA    A    21_A      Q     273          3.087
LGA    D    22_A      V     274          1.659
LGA    F    23_A      F     275          1.735
LGA    L    24_A      N     276          2.296
LGA    A    25_A      G     277          1.394
LGA    S    26_A      I     278          1.238
LGA    A    27_A      F     279          2.576
LGA    L    28_A      G     280          3.832
LGA    -       -      G     281           -
LGA    -       -      F     282           -
LGA    -       -      P     283           -
LGA    -       -      X     284           -
LGA    P    29_A      S     285          3.543
LGA    L    30_A      K     286          2.765
LGA    A    31_A      L     287          2.536
LGA    N    32_A      F     288          2.688
LGA    A    33_A      M     289          3.434
LGA    -       -      N     290           -
LGA    -       -      V     291           -
LGA    -       -      R     292           -
LGA    -       -      E     293           -
LGA    -       -      K     294           -
LGA    E    34_A      E     295          3.942
LGA    S    35_A      X     296          0.684
LGA    G    36_A      L     297          1.102
LGA    T    37_A      A     298          0.891
LGA    T    38_A      Y     299          1.251
LGA    A    39_A      Y     300          1.894
LGA    W    40_A      A     301          1.767
LGA    F    41_A      S     302          2.541
LGA    A    42_A      S     303          1.209
LGA    L    43_A      S     304          1.318
LGA    K    44_A      I     305          1.916
LGA    F    45_A      D     306          2.495
LGA    G    46_A      T     307          3.096
LGA    P    47_A      F     308          3.343
LGA    -       -      R     309           -
LGA    S    48_A      G     310          2.957
LGA    T    49_A      F     311          2.185
LGA    F    50_A      M     312          1.664
LGA    G    51_A      T     313          1.297
LGA    V    52_A      V     314          1.167
LGA    F    53_A      Q     315          1.413
LGA    D    54_A      T     316          1.350
LGA    A    55_A      G     317          1.799
LGA    F    56_A      I     318          0.708
LGA    A    57_A      D     319          1.125
LGA    D    58_A      G     320          2.182
LGA    E    59_A      K     321          2.485
LGA    A    60_A      N     322          1.936
LGA    G    61_A      -       -           -
LGA    R    62_A      R     323          2.430
LGA    Q    63_A      N     324          2.231
LGA    A    64_A      Q     325          2.443
LGA    H    65_A      V     326          2.071
LGA    L    66_A      L     327          1.535
LGA    N    67_A      R     328          1.593
LGA    G    68_A      L     329          1.486
LGA    Q    69_A      -       -           -
LGA    I    70_A      I     330          3.945
LGA    A    71_A      S     331          1.772
LGA    A    72_A      T     332          1.946
LGA    A    73_A      E     333          3.423
LGA    L    74_A      L     334          1.895
LGA    X    75_A      E     335          3.055
LGA    A    76_A      N     336          4.972
LGA    -       -      I     337           -
LGA    N    77_A      R     338          1.954
LGA    A    78_A      L     339           -
LGA    A    79_A      G     340           -
LGA    -       -      K     341           -
LGA    -       -      I     342           -
LGA    -       -      R     343           -
LGA    -       -      E     344           -
LGA    -       -      L     345           -
LGA    -       -      E     346           -
LGA    -       -      I     347           -
LGA    -       -      E     348           -
LGA    -       -      Q     349           -
LGA    -       -      T     350           -
LGA    -       -      K     351           -
LGA    -       -      A     352           -
LGA    -       -      M     353           -
LGA    -       -      L     354           -
LGA    -       -      K     355           -
LGA    -       -      N     356           -
LGA    -       -      Q     357           -
LGA    -       -      Y     358           -
LGA    -       -      I     359           -
LGA    -       -      L     360           -
LGA    -       -      A     361           -
LGA    -       -      L     362           -
LGA    -       -      D     363           -
LGA    -       -      N     364           -
LGA    -       -      A     365           -
LGA    -       -      G     366           -
LGA    -       -      A     367           -
LGA    -       -      W     368           -
LGA    -       -      L     369           -
LGA    -       -      E     370           -
LGA    -       -      K     371           -
LGA    -       -      E     372           -
LGA    -       -      Y     373           -
LGA    -       -      L     374           -
LGA    -       -      N     375           -
LGA    -       -      E     376           -
LGA    -       -      L     377           -
LGA    -       -      M     378           -
LGA    -       -      P     379           -
LGA    -       -      Q     380           -
LGA    -       -      T     381           -
LGA    -       -      M     382           -
LGA    -       -      L     383           -
LGA    -       -      T     384           -
LGA    -       -      A     385           -
LGA    -       -      E     386           -
LGA    -       -      E     387           -
LGA    -       -      W     388           -
LGA    -       -      I     389           -
LGA    -       -      A     390           -
LGA    -       -      R     391           -
LGA    -       -      I     392           -
LGA    -       -      N     393           -
LGA    -       -      A     394           -
LGA    -       -      V     395           -
LGA    -       -      T     396           -
LGA    -       -      I     397           -
LGA    -       -      P     398           -
LGA    -       -      E     399           -
LGA    -       -      I     400           -
LGA    -       -      Q     401           -
LGA    T    80_A      E     402          1.998
LGA    L    81_A      V     403          1.799
LGA    -       -      A     404           -
LGA    -       -      K     405           -
LGA    L    82_A      R     406          1.825
LGA    S    83_A      L     407          5.636
LGA    S    84_A      -       -           -
LGA    P    85_A      E     408          2.103
LGA    P    86_A      L     409          0.873
LGA    N    87_A      Q     410          1.427
LGA    I    88_A      A     411          2.907
LGA    E    89_A      I     412          1.384
LGA    K    90_A      F     413          3.008
LGA    V    91_A      F     414          1.604
LGA    E    92_A      L     415          1.309
LGA    L    93_A      E     416          4.763
LGA    -       -      G     417           -
LGA    L    94_A      E     418           #
LGA    A    95_A      T     419           -
LGA    A    96_A      E     420           -
LGA    K    97_A      N     421           -
LGA    L    98_A      D     422           -
LGA    P    99_A      -       -           -
LGA    A   100_A      -       -           -
LGA    G   101_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  103  184    5.0     88    2.50    11.36     32.227     3.380

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.225504 * X  +   0.708333 * Y  +  -0.668889 * Z  +  19.949562
  Y_new =   0.246700 * X  +   0.622680 * Y  +   0.742569 * Z  +  17.559887
  Z_new =   0.942490 * X  +  -0.332467 * Y  +  -0.034328 * Z  +  20.539801 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.673685    1.467907  [ DEG:   -95.8951     84.1049 ]
  Theta =  -1.230003   -1.911589  [ DEG:   -70.4740   -109.5260 ]
  Phi   =   0.830254   -2.311338  [ DEG:    47.5701   -132.4299 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pd1_A                                        
REMARK     2: T0427_239_422.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pd1_A.T0427_239_422.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  103  184   5.0   88   2.50   11.36  32.227
REMARK  ---------------------------------------------------------- 
MOLECULE 2pd1_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   30-MAR-07   2PD1              
TITLE     CRYSTAL STRUCTURE OF NE2512 PROTEIN OF UNKNOWN FUNCTION               
TITLE    2 FROM NITROSOMONAS EUROPAEA                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NITROSOMONAS EUROPAEA;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: IFO 14298;                                                   
SOURCE   5 ATCC: 19718;                                                         
SOURCE   6 GENE: NE2512;                                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    UNKNOWN FUNCTION, NE2512 PROTEIN, STRUCTURAL GENOMICS,                
KEYWDS   2 APC7253, PSI-2, PROTEIN STRUCTURE INITIATIVE, MIDWEST                
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS, MCSG                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.OSIPIUK,E.EVDOKIMOVA,O.KAGAN,A.SAVCHENKO,A.EDWARDS,                 
AUTHOR   2 A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   1   01-MAY-07 2PD1    0                                                
JRNL        AUTH   J.OSIPIUK,E.EVDOKIMOVA,O.KAGAN,A.SAVCHENKO,                  
JRNL        AUTH 2 A.EDWARDS,A.JOACHIMIAK                                       
JRNL        TITL   CRYSTAL STRUCTURE OF NE2512 PROTEIN OF UNKNOWN               
JRNL        TITL 2 FUNCTION FROM NITROSOMONAS EUROPAEA.                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.86 ANGSTROMS.                                          
DBREF  2PD1 A    1   100  UNP    Q82S47   Q82S47_NITEU     1    100             
DBREF  2PD1 B    1   100  UNP    Q82S47   Q82S47_NITEU     1    100             
DBREF  2PD1 C    1   100  UNP    Q82S47   Q82S47_NITEU     1    100             
DBREF  2PD1 D    1   100  UNP    Q82S47   Q82S47_NITEU     1    100             
SEQRES   1 A  104  GLY HIS MSE THR LYS LEU ALA LEU PHE VAL ARG LEU GLU          
SEQRES   2 A  104  ALA LYS PRO GLY GLN GLU ALA ALA LEU ALA ASP PHE LEU          
SEQRES   3 A  104  ALA SER ALA LEU PRO LEU ALA ASN ALA GLU SER GLY THR          
SEQRES   4 A  104  THR ALA TRP PHE ALA LEU LYS PHE GLY PRO SER THR PHE          
SEQRES   5 A  104  GLY VAL PHE ASP ALA PHE ALA ASP GLU ALA GLY ARG GLN          
SEQRES   6 A  104  ALA HIS LEU ASN GLY GLN ILE ALA ALA ALA LEU MSE ALA          
SEQRES   7 A  104  ASN ALA ALA THR LEU LEU SER SER PRO PRO ASN ILE GLU          
SEQRES   8 A  104  LYS VAL GLU LEU LEU ALA ALA LYS LEU PRO ALA GLY SER          
SEQRES   1 B  104  GLY HIS MSE THR LYS LEU ALA LEU PHE VAL ARG LEU GLU          
SEQRES   2 B  104  ALA LYS PRO GLY GLN GLU ALA ALA LEU ALA ASP PHE LEU          
SEQRES   3 B  104  ALA SER ALA LEU PRO LEU ALA ASN ALA GLU SER GLY THR          
SEQRES   4 B  104  THR ALA TRP PHE ALA LEU LYS PHE GLY PRO SER THR PHE          
SEQRES   5 B  104  GLY VAL PHE ASP ALA PHE ALA ASP GLU ALA GLY ARG GLN          
SEQRES   6 B  104  ALA HIS LEU ASN GLY GLN ILE ALA ALA ALA LEU MSE ALA          
SEQRES   7 B  104  ASN ALA ALA THR LEU LEU SER SER PRO PRO ASN ILE GLU          
SEQRES   8 B  104  LYS VAL GLU LEU LEU ALA ALA LYS LEU PRO ALA GLY SER          
SEQRES   1 C  104  GLY HIS MSE THR LYS LEU ALA LEU PHE VAL ARG LEU GLU          
SEQRES   2 C  104  ALA LYS PRO GLY GLN GLU ALA ALA LEU ALA ASP PHE LEU          
SEQRES   3 C  104  ALA SER ALA LEU PRO LEU ALA ASN ALA GLU SER GLY THR          
SEQRES   4 C  104  THR ALA TRP PHE ALA LEU LYS PHE GLY PRO SER THR PHE          
SEQRES   5 C  104  GLY VAL PHE ASP ALA PHE ALA ASP GLU ALA GLY ARG GLN          
SEQRES   6 C  104  ALA HIS LEU ASN GLY GLN ILE ALA ALA ALA LEU MSE ALA          
SEQRES   7 C  104  ASN ALA ALA THR LEU LEU SER SER PRO PRO ASN ILE GLU          
SEQRES   8 C  104  LYS VAL GLU LEU LEU ALA ALA LYS LEU PRO ALA GLY SER          
SEQRES   1 D  104  GLY HIS MSE THR LYS LEU ALA LEU PHE VAL ARG LEU GLU          
SEQRES   2 D  104  ALA LYS PRO GLY GLN GLU ALA ALA LEU ALA ASP PHE LEU          
SEQRES   3 D  104  ALA SER ALA LEU PRO LEU ALA ASN ALA GLU SER GLY THR          
SEQRES   4 D  104  THR ALA TRP PHE ALA LEU LYS PHE GLY PRO SER THR PHE          
SEQRES   5 D  104  GLY VAL PHE ASP ALA PHE ALA ASP GLU ALA GLY ARG GLN          
SEQRES   6 D  104  ALA HIS LEU ASN GLY GLN ILE ALA ALA ALA LEU MSE ALA          
SEQRES   7 D  104  ASN ALA ALA THR LEU LEU SER SER PRO PRO ASN ILE GLU          
SEQRES   8 D  104  LYS VAL GLU LEU LEU ALA ALA LYS LEU PRO ALA GLY SER          
HET    MSE  A   1       8                                                       
HET    MSE  A  75       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  75       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  75       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  75       8                                                       
HET    ACT    501       4                                                       
HET    ACT    502       4                                                       
HET    ACT    503       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACT ACETATE ION                                                      
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   5  ACT    3(C2 H3 O2 1-)                                               
FORMUL   8  HOH   *404(H2 O)                                                    
CRYST1   67.308   68.137  162.645  90.00  90.00  90.00 C 2 2 21     32          
ATOM      1  N   GLY A  -1      28.364  21.046  18.615  1.00 27.59           N  
ATOM      2  CA  GLY A  -1      27.982  19.754  19.258  1.00 28.77           C  
ATOM      3  C   GLY A  -1      26.502  19.697  19.616  1.00 28.71           C  
ATOM      4  O   GLY A  -1      25.845  20.741  19.805  1.00 28.77           O  
ATOM      5  N   HIS A   0      25.986  18.464  19.691  1.00 28.01           N  
ATOM      6  CA  HIS A   0      24.598  18.177  20.094  1.00 27.56           C  
ATOM      7  C   HIS A   0      24.428  18.420  21.591  1.00 26.88           C  
ATOM      8  O   HIS A   0      23.323  18.282  22.153  1.00 27.29           O  
ATOM      9  CB  HIS A   0      24.267  16.709  19.801  1.00 27.72           C  
ATOM     10  CG  HIS A   0      25.231  15.745  20.420  1.00 28.89           C  
ATOM     11  ND1 HIS A   0      25.076  15.252  21.698  1.00 28.18           N  
ATOM     12  CD2 HIS A   0      26.373  15.194  19.938  1.00 29.50           C  
ATOM     13  CE1 HIS A   0      26.072  14.426  21.969  1.00 31.32           C  
ATOM     14  NE2 HIS A   0      26.872  14.372  20.920  1.00 30.60           N  
HETATM   15  N   MSE A   1      25.547  18.759  22.229  1.00 25.15           N  
HETATM   16  CA  MSE A   1      25.622  18.827  23.666  1.00 23.38           C  
HETATM   17  C   MSE A   1      25.268  20.203  24.201  1.00 22.53           C  
HETATM   18  O   MSE A   1      24.978  20.327  25.388  1.00 22.74           O  
HETATM   19  CB  MSE A   1      26.994  18.350  24.138  1.00 23.48           C  
HETATM   20  CG  MSE A   1      27.208  16.874  23.885  1.00 22.58           C  
HETATM   21 SE   MSE A   1      26.032  15.912  25.078  0.40 18.53          SE  
HETATM   22  CE  MSE A   1      27.010  16.463  26.677  1.00 20.38           C  
ATOM     23  N   THR A   2      25.272  21.221  23.324  1.00 20.33           N  
ATOM     24  CA  THR A   2      24.760  22.549  23.687  1.00 19.00           C  
ATOM     25  C   THR A   2      23.297  22.717  23.302  1.00 18.56           C  
ATOM     26  O   THR A   2      22.888  22.588  22.122  1.00 17.41           O  
ATOM     27  CB  THR A   2      25.704  23.720  23.289  1.00 19.56           C  
ATOM     28  OG1 THR A   2      24.967  24.813  22.731  1.00 18.66           O  
ATOM     29  CG2 THR A   2      26.770  23.280  22.330  1.00 18.22           C  
ATOM     30  N   LYS A   3      22.510  22.979  24.340  1.00 17.02           N  
ATOM     31  CA  LYS A   3      21.077  22.789  24.288  1.00 16.48           C  
ATOM     32  C   LYS A   3      20.199  23.976  24.642  1.00 15.85           C  
ATOM     33  O   LYS A   3      19.008  24.009  24.261  1.00 15.18           O  
ATOM     34  CB  LYS A   3      20.741  21.637  25.204  1.00 17.23           C  
ATOM     35  CG  LYS A   3      21.090  20.339  24.562  1.00 20.75           C  
ATOM     36  CD  LYS A   3      20.097  19.984  23.454  1.00 26.53           C  
ATOM     37  CE  LYS A   3      20.588  20.359  22.067  0.50 27.02           C  
ATOM     38  NZ  LYS A   3      19.628  19.971  20.994  1.00 29.68           N  
ATOM     39  N   LEU A   4      20.776  24.942  25.355  1.00 15.27           N  
ATOM     40  CA  LEU A   4      20.033  26.138  25.811  1.00 14.98           C  
ATOM     41  C   LEU A   4      20.678  27.400  25.323  1.00 14.78           C  
ATOM     42  O   LEU A   4      21.873  27.423  25.037  1.00 15.86           O  
ATOM     43  CB  LEU A   4      19.994  26.201  27.341  1.00 15.15           C  
ATOM     44  CG  LEU A   4      19.427  24.961  28.018  1.00 13.97           C  
ATOM     45  CD1 LEU A   4      19.410  25.191  29.546  1.00 13.20           C  
ATOM     46  CD2 LEU A   4      18.009  24.694  27.449  1.00 19.01           C  
ATOM     47  N   ALA A   5      19.874  28.450  25.237  1.00 12.94           N  
ATOM     48  CA  ALA A   5      20.362  29.744  24.757  1.00 12.79           C  
ATOM     49  C   ALA A   5      19.549  30.889  25.336  1.00 13.25           C  
ATOM     50  O   ALA A   5      18.483  30.667  25.984  1.00 12.57           O  
ATOM     51  CB  ALA A   5      20.365  29.795  23.217  1.00 11.53           C  
ATOM     52  N   LEU A   6      20.098  32.099  25.152  1.00 12.71           N  
ATOM     53  CA  LEU A   6      19.372  33.352  25.440  1.00 14.09           C  
ATOM     54  C   LEU A   6      19.486  34.192  24.231  1.00 13.49           C  
ATOM     55  O   LEU A   6      20.542  34.205  23.591  1.00 14.26           O  
ATOM     56  CB  LEU A   6      20.023  34.114  26.586  1.00 13.50           C  
ATOM     57  CG  LEU A   6      19.973  33.367  27.904  1.00 14.95           C  
ATOM     58  CD1 LEU A   6      20.919  34.078  28.854  1.00 18.08           C  
ATOM     59  CD2 LEU A   6      18.514  33.366  28.416  1.00 17.92           C  
ATOM     60  N   PHE A   7      18.406  34.913  23.921  1.00 13.53           N  
ATOM     61  CA  PHE A   7      18.427  35.841  22.848  1.00 13.02           C  
ATOM     62  C   PHE A   7      17.973  37.147  23.481  1.00 12.39           C  
ATOM     63  O   PHE A   7      16.851  37.242  23.943  1.00 11.77           O  
ATOM     64  CB  PHE A   7      17.501  35.390  21.719  1.00 13.65           C  
ATOM     65  CG  PHE A   7      17.437  36.377  20.577  1.00 16.06           C  
ATOM     66  CD1 PHE A   7      18.546  36.596  19.764  1.00 19.94           C  
ATOM     67  CD2 PHE A   7      16.255  37.053  20.289  1.00 19.12           C  
ATOM     68  CE1 PHE A   7      18.489  37.518  18.677  1.00 22.38           C  
ATOM     69  CE2 PHE A   7      16.180  37.966  19.229  1.00 20.19           C  
ATOM     70  CZ  PHE A   7      17.298  38.196  18.409  1.00 21.82           C  
ATOM     71  N   VAL A   8      18.896  38.102  23.593  1.00 12.72           N  
ATOM     72  CA  VAL A   8      18.667  39.343  24.332  1.00 11.87           C  
ATOM     73  C   VAL A   8      18.664  40.514  23.363  1.00 13.59           C  
ATOM     74  O   VAL A   8      19.582  40.653  22.534  1.00 15.01           O  
ATOM     75  CB  VAL A   8      19.809  39.580  25.323  1.00 12.73           C  
ATOM     76  CG1 VAL A   8      19.529  40.808  26.191  1.00 10.70           C  
ATOM     77  CG2 VAL A   8      20.008  38.350  26.216  1.00 13.53           C  
ATOM     78  N   ARG A   9      17.633  41.345  23.421  1.00 13.15           N  
ATOM     79  CA  ARG A   9      17.676  42.604  22.634  1.00 14.69           C  
ATOM     80  C   ARG A   9      17.915  43.764  23.570  1.00 13.59           C  
ATOM     81  O   ARG A   9      17.371  43.787  24.682  1.00 13.40           O  
ATOM     82  CB  ARG A   9      16.415  42.825  21.793  1.00 16.36           C  
ATOM     83  CG  ARG A   9      16.361  41.901  20.604  1.00 21.68           C  
ATOM     84  CD  ARG A   9      15.697  42.563  19.413  1.00 29.40           C  
ATOM     85  NE  ARG A   9      15.333  41.567  18.403  1.00 32.27           N  
ATOM     86  CZ  ARG A   9      15.602  41.652  17.097  1.00 33.21           C  
ATOM     87  NH1 ARG A   9      16.250  42.704  16.603  1.00 33.16           N  
ATOM     88  NH2 ARG A   9      15.209  40.682  16.282  1.00 29.27           N  
ATOM     89  N   LEU A  10      18.676  44.743  23.091  1.00 12.62           N  
ATOM     90  CA  LEU A  10      19.075  45.890  23.896  1.00 12.46           C  
ATOM     91  C   LEU A  10      18.819  47.124  23.052  1.00 13.03           C  
ATOM     92  O   LEU A  10      19.230  47.175  21.865  1.00 13.95           O  
ATOM     93  CB  LEU A  10      20.574  45.785  24.248  1.00 11.11           C  
ATOM     94  CG  LEU A  10      21.016  44.507  24.987  1.00 12.22           C  
ATOM     95  CD1 LEU A  10      22.524  44.395  24.973  1.00 11.79           C  
ATOM     96  CD2 LEU A  10      20.526  44.615  26.444  1.00 11.03           C  
ATOM     97  N   GLU A  11      18.113  48.098  23.618  1.00 13.42           N  
ATOM     98  CA  GLU A  11      17.794  49.321  22.896  0.60 13.54           C  
ATOM    100  C   GLU A  11      18.606  50.491  23.464  1.00 14.11           C  
ATOM    101  O   GLU A  11      18.449  50.847  24.653  1.00 13.57           O  
ATOM    102  CB  GLU A  11      16.286  49.603  22.963  0.60 13.60           C  
ATOM    104  CG  GLU A  11      15.415  48.411  22.498  0.60 13.53           C  
ATOM    106  CD  GLU A  11      15.457  48.145  20.988  0.60 17.46           C  
ATOM    108  OE1 GLU A  11      15.874  49.022  20.203  0.60 21.65           O  
ATOM    110  OE2 GLU A  11      15.067  47.040  20.576  0.60 18.06           O  
ATOM    112  N   ALA A  12      19.487  51.061  22.642  1.00 13.28           N  
ATOM    113  CA  ALA A  12      20.377  52.129  23.119  1.00 14.79           C  
ATOM    114  C   ALA A  12      19.617  53.438  23.320  1.00 15.63           C  
ATOM    115  O   ALA A  12      18.803  53.816  22.502  1.00 15.67           O  
ATOM    116  CB  ALA A  12      21.499  52.368  22.151  1.00 14.85           C  
ATOM    117  N   LYS A  13      19.903  54.134  24.408  1.00 15.84           N  
ATOM    118  CA  LYS A  13      19.443  55.523  24.547  1.00 18.07           C  
ATOM    119  C   LYS A  13      20.000  56.391  23.426  1.00 18.69           C  
ATOM    120  O   LYS A  13      21.136  56.193  23.007  1.00 18.12           O  
ATOM    121  CB  LYS A  13      20.006  56.101  25.835  1.00 19.38           C  
ATOM    122  CG  LYS A  13      19.107  56.046  26.969  1.00 23.77           C  
ATOM    123  CD  LYS A  13      19.746  56.825  28.069  1.00 28.00           C  
ATOM    124  CE  LYS A  13      18.744  57.006  29.167  1.00 32.68           C  
ATOM    125  NZ  LYS A  13      19.226  58.009  30.158  1.00 36.25           N  
ATOM    126  N   PRO A  14      19.217  57.381  22.959  1.00 19.37           N  
ATOM    127  CA  PRO A  14      19.704  58.272  21.889  1.00 19.48           C  
ATOM    128  C   PRO A  14      20.995  58.947  22.340  1.00 18.03           C  
ATOM    129  O   PRO A  14      21.076  59.405  23.475  1.00 17.41           O  
ATOM    130  CB  PRO A  14      18.597  59.308  21.748  1.00 20.44           C  
ATOM    131  CG  PRO A  14      17.397  58.687  22.348  1.00 21.37           C  
ATOM    132  CD  PRO A  14      17.861  57.730  23.405  1.00 20.71           C  
ATOM    133  N   GLY A  15      22.005  58.959  21.475  1.00 17.60           N  
ATOM    134  CA  GLY A  15      23.328  59.484  21.836  1.00 15.91           C  
ATOM    135  C   GLY A  15      24.235  58.428  22.463  1.00 14.83           C  
ATOM    136  O   GLY A  15      25.465  58.612  22.570  1.00 15.06           O  
ATOM    137  N   GLN A  16      23.641  57.329  22.917  1.00 13.88           N  
ATOM    138  CA  GLN A  16      24.439  56.270  23.531  1.00 13.29           C  
ATOM    139  C   GLN A  16      24.670  55.052  22.644  1.00 13.41           C  
ATOM    140  O   GLN A  16      25.034  53.998  23.157  1.00 12.40           O  
ATOM    141  CB  GLN A  16      23.815  55.812  24.862  1.00 12.67           C  
ATOM    142  CG  GLN A  16      23.643  56.926  25.885  1.00 15.74           C  
ATOM    143  CD  GLN A  16      24.932  57.429  26.448  1.00 20.63           C  
ATOM    144  OE1 GLN A  16      25.906  56.687  26.606  1.00 20.06           O  
ATOM    145  NE2 GLN A  16      24.955  58.725  26.761  1.00 23.62           N  
ATOM    146  N   GLU A  17      24.493  55.169  21.326  1.00 13.89           N  
ATOM    147  CA  GLU A  17      24.580  53.959  20.491  1.00 13.67           C  
ATOM    148  C   GLU A  17      26.019  53.432  20.434  1.00 14.62           C  
ATOM    149  O   GLU A  17      26.261  52.233  20.616  1.00 14.00           O  
ATOM    150  CB  GLU A  17      24.070  54.296  19.079  1.00 15.49           C  
ATOM    151  CG  GLU A  17      22.642  54.844  19.117  1.00 13.84           C  
ATOM    152  CD  GLU A  17      22.552  56.369  19.301  1.00 19.59           C  
ATOM    153  OE1 GLU A  17      23.562  57.055  19.552  1.00 21.01           O  
ATOM    154  OE2 GLU A  17      21.424  56.864  19.238  1.00 18.95           O  
ATOM    155  N   ALA A  18      26.968  54.339  20.227  1.00 14.25           N  
ATOM    156  CA  ALA A  18      28.380  53.957  20.186  1.00 13.89           C  
ATOM    157  C   ALA A  18      28.835  53.420  21.538  1.00 13.83           C  
ATOM    158  O   ALA A  18      29.572  52.434  21.594  1.00 13.46           O  
ATOM    159  CB  ALA A  18      29.256  55.092  19.738  1.00 14.11           C  
ATOM    160  N   ALA A  19      28.396  54.081  22.606  1.00 13.19           N  
ATOM    161  CA  ALA A  19      28.746  53.709  23.960  1.00 13.08           C  
ATOM    162  C   ALA A  19      28.259  52.300  24.265  1.00 12.80           C  
ATOM    163  O   ALA A  19      28.975  51.512  24.890  1.00 11.38           O  
ATOM    164  CB  ALA A  19      28.147  54.728  24.950  1.00 12.40           C  
ATOM    165  N   LEU A  20      27.033  51.983  23.873  1.00 11.12           N  
ATOM    166  CA  LEU A  20      26.532  50.603  24.085  1.00 11.61           C  
ATOM    167  C   LEU A  20      27.314  49.557  23.257  1.00 11.46           C  
ATOM    168  O   LEU A  20      27.637  48.505  23.742  1.00 10.88           O  
ATOM    169  CB  LEU A  20      25.031  50.509  23.762  1.00  8.58           C  
ATOM    170  CG  LEU A  20      24.432  49.072  23.910  1.00 11.15           C  
ATOM    171  CD1 LEU A  20      24.697  48.542  25.330  1.00 11.15           C  
ATOM    172  CD2 LEU A  20      22.930  49.121  23.654  1.00 13.31           C  
ATOM    173  N   ALA A  21      27.544  49.843  21.972  1.00 12.76           N  
ATOM    174  CA  ALA A  21      28.373  48.965  21.133  1.00 12.02           C  
ATOM    175  C   ALA A  21      29.744  48.735  21.782  1.00 12.47           C  
ATOM    176  O   ALA A  21      30.226  47.576  21.825  1.00 11.72           O  
ATOM    177  CB  ALA A  21      28.564  49.612  19.771  1.00 13.40           C  
ATOM    178  N   ASP A  22      30.368  49.809  22.286  1.00 10.36           N  
ATOM    179  CA  ASP A  22      31.671  49.706  22.910  1.00 11.45           C  
ATOM    180  C   ASP A  22      31.563  48.877  24.167  1.00 11.31           C  
ATOM    181  O   ASP A  22      32.461  48.089  24.457  1.00 10.17           O  
ATOM    182  CB  ASP A  22      32.241  51.088  23.320  1.00 11.43           C  
ATOM    183  CG  ASP A  22      32.680  51.938  22.116  1.00 15.71           C  
ATOM    184  OD1 ASP A  22      32.816  51.381  20.988  1.00 20.83           O  
ATOM    185  OD2 ASP A  22      32.880  53.172  22.285  1.00 17.96           O  
ATOM    186  N   PHE A  23      30.501  49.092  24.939  1.00 12.07           N  
ATOM    187  CA  PHE A  23      30.317  48.326  26.198  1.00 11.85           C  
ATOM    188  C   PHE A  23      30.282  46.854  25.891  1.00 11.41           C  
ATOM    189  O   PHE A  23      30.986  46.040  26.508  1.00 11.14           O  
ATOM    190  CB  PHE A  23      29.000  48.719  26.886  1.00 12.49           C  
ATOM    191  CG  PHE A  23      28.639  47.826  28.010  1.00 13.79           C  
ATOM    192  CD1 PHE A  23      29.191  48.028  29.268  1.00 15.79           C  
ATOM    193  CD2 PHE A  23      27.800  46.720  27.804  1.00 12.50           C  
ATOM    194  CE1 PHE A  23      28.914  47.144  30.318  1.00 16.60           C  
ATOM    195  CE2 PHE A  23      27.463  45.871  28.870  1.00 13.48           C  
ATOM    196  CZ  PHE A  23      28.044  46.079  30.113  1.00 12.87           C  
ATOM    197  N   LEU A  24      29.457  46.502  24.906  1.00 11.65           N  
ATOM    198  CA  LEU A  24      29.322  45.120  24.502  1.00 11.57           C  
ATOM    199  C   LEU A  24      30.624  44.513  24.016  1.00 12.14           C  
ATOM    200  O   LEU A  24      31.025  43.416  24.438  1.00 12.66           O  
ATOM    201  CB  LEU A  24      28.208  45.001  23.435  1.00 11.01           C  
ATOM    202  CG  LEU A  24      26.802  45.180  23.991  1.00 10.69           C  
ATOM    203  CD1 LEU A  24      25.813  45.210  22.814  1.00 12.77           C  
ATOM    204  CD2 LEU A  24      26.425  44.003  24.982  1.00 13.08           C  
ATOM    205  N   ALA A  25      31.335  45.228  23.152  1.00 13.16           N  
ATOM    206  CA  ALA A  25      32.596  44.689  22.704  1.00 13.45           C  
ATOM    207  C   ALA A  25      33.585  44.520  23.875  1.00 13.67           C  
ATOM    208  O   ALA A  25      34.289  43.527  23.936  1.00 14.32           O  
ATOM    209  CB  ALA A  25      33.214  45.549  21.590  1.00 13.40           C  
ATOM    210  N   SER A  26      33.610  45.456  24.827  1.00 15.71           N  
ATOM    211  CA  SER A  26      34.554  45.348  25.945  1.00 15.75           C  
ATOM    212  C   SER A  26      34.196  44.198  26.875  1.00 15.91           C  
ATOM    213  O   SER A  26      35.003  43.814  27.734  1.00 15.97           O  
ATOM    214  CB  SER A  26      34.606  46.649  26.776  1.00 15.82           C  
ATOM    215  OG  SER A  26      33.342  46.825  27.410  1.00 18.59           O  
ATOM    216  N   ALA A  27      32.990  43.663  26.737  1.00 14.39           N  
ATOM    217  CA  ALA A  27      32.516  42.599  27.610  1.00 14.50           C  
ATOM    218  C   ALA A  27      33.069  41.219  27.158  1.00 14.35           C  
ATOM    219  O   ALA A  27      32.999  40.235  27.893  1.00 13.10           O  
ATOM    220  CB  ALA A  27      30.943  42.624  27.704  1.00 13.72           C  
ATOM    221  N   LEU A  28      33.658  41.154  25.966  1.00 13.77           N  
ATOM    222  CA  LEU A  28      34.188  39.857  25.470  1.00 14.14           C  
ATOM    223  C   LEU A  28      35.069  39.078  26.469  1.00 13.42           C  
ATOM    224  O   LEU A  28      34.812  37.908  26.685  1.00 12.44           O  
ATOM    225  CB  LEU A  28      34.893  40.006  24.113  1.00 15.18           C  
ATOM    226  CG  LEU A  28      35.443  38.686  23.549  1.00 14.60           C  
ATOM    227  CD1 LEU A  28      34.327  37.620  23.344  1.00 16.55           C  
ATOM    228  CD2 LEU A  28      36.210  38.968  22.231  1.00 14.57           C  
ATOM    229  N   PRO A  29      36.105  39.711  27.065  1.00 12.71           N  
ATOM    230  CA  PRO A  29      36.944  38.945  27.996  1.00 13.09           C  
ATOM    231  C   PRO A  29      36.136  38.341  29.123  1.00 12.64           C  
ATOM    232  O   PRO A  29      36.487  37.273  29.657  1.00 12.99           O  
ATOM    233  CB  PRO A  29      37.893  40.015  28.577  1.00 13.10           C  
ATOM    234  CG  PRO A  29      37.883  41.110  27.639  1.00 14.17           C  
ATOM    235  CD  PRO A  29      36.590  41.098  26.907  1.00 13.84           C  
ATOM    236  N   LEU A  30      35.065  39.032  29.514  1.00 12.07           N  
ATOM    237  CA  LEU A  30      34.231  38.552  30.621  1.00 12.49           C  
ATOM    238  C   LEU A  30      33.496  37.306  30.165  1.00 11.87           C  
ATOM    239  O   LEU A  30      33.441  36.327  30.896  1.00 11.02           O  
ATOM    240  CB  LEU A  30      33.248  39.633  31.056  1.00 12.41           C  
ATOM    241  CG  LEU A  30      33.808  40.949  31.593  1.00 13.20           C  
ATOM    242  CD1 LEU A  30      32.650  41.896  31.981  1.00 15.01           C  
ATOM    243  CD2 LEU A  30      34.704  40.716  32.760  1.00 16.36           C  
ATOM    244  N   ALA A  31      32.987  37.310  28.934  1.00 10.53           N  
ATOM    245  CA  ALA A  31      32.370  36.078  28.386  1.00 11.30           C  
ATOM    246  C   ALA A  31      33.399  34.956  28.222  1.00 11.09           C  
ATOM    247  O   ALA A  31      33.112  33.771  28.516  1.00  9.30           O  
ATOM    248  CB  ALA A  31      31.707  36.419  27.023  1.00 11.70           C  
ATOM    249  N   ASN A  32      34.576  35.315  27.708  1.00 11.77           N  
ATOM    250  CA  ASN A  32      35.629  34.316  27.536  1.00 11.20           C  
ATOM    251  C   ASN A  32      35.872  33.595  28.821  1.00 12.34           C  
ATOM    252  O   ASN A  32      36.204  32.393  28.791  1.00 13.10           O  
ATOM    253  CB  ASN A  32      36.956  34.930  27.080  1.00 12.24           C  
ATOM    254  CG  ASN A  32      36.926  35.409  25.614  1.00 13.86           C  
ATOM    255  OD1 ASN A  32      37.769  36.202  25.195  1.00 18.01           O  
ATOM    256  ND2 ASN A  32      35.982  34.914  24.851  1.00 15.54           N  
ATOM    257  N   ALA A  33      35.771  34.305  29.938  1.00 12.21           N  
ATOM    258  CA  ALA A  33      36.105  33.681  31.237  1.00 13.81           C  
ATOM    259  C   ALA A  33      34.996  32.796  31.780  1.00 15.47           C  
ATOM    260  O   ALA A  33      35.216  32.069  32.752  1.00 16.63           O  
ATOM    261  CB  ALA A  33      36.497  34.727  32.262  1.00 12.18           C  
ATOM    262  N   GLU A  34      33.806  32.834  31.158  1.00 15.58           N  
ATOM    263  CA  GLU A  34      32.673  32.053  31.661  1.00 16.67           C  
ATOM    264  C   GLU A  34      32.692  30.647  31.136  1.00 16.18           C  
ATOM    265  O   GLU A  34      32.330  30.389  29.978  1.00 15.34           O  
ATOM    266  CB  GLU A  34      31.338  32.714  31.328  1.00 15.78           C  
ATOM    267  CG  GLU A  34      31.121  34.030  32.063  1.00 16.43           C  
ATOM    268  CD  GLU A  34      29.793  34.722  31.693  1.00 18.81           C  
ATOM    269  OE1 GLU A  34      29.065  34.190  30.818  1.00 20.69           O  
ATOM    270  OE2 GLU A  34      29.464  35.774  32.294  1.00 18.48           O  
ATOM    271  N   SER A  35      33.095  29.719  31.997  1.00 16.94           N  
ATOM    272  CA  SER A  35      33.342  28.369  31.525  1.00 17.77           C  
ATOM    273  C   SER A  35      32.069  27.712  31.053  1.00 17.44           C  
ATOM    274  O   SER A  35      32.126  26.857  30.192  1.00 18.99           O  
ATOM    275  CB  SER A  35      34.041  27.475  32.567  1.00 17.90           C  
ATOM    276  OG  SER A  35      33.339  27.539  33.785  1.00 22.69           O  
ATOM    277  N   GLY A  36      30.931  28.102  31.606  1.00 16.51           N  
ATOM    278  CA  GLY A  36      29.663  27.523  31.177  1.00 14.76           C  
ATOM    279  C   GLY A  36      29.014  28.142  29.942  1.00 15.53           C  
ATOM    280  O   GLY A  36      27.965  27.645  29.479  1.00 15.22           O  
ATOM    281  N   THR A  37      29.594  29.245  29.438  1.00 13.60           N  
ATOM    282  CA  THR A  37      29.043  29.984  28.321  1.00 13.72           C  
ATOM    283  C   THR A  37      29.813  29.448  27.123  1.00 13.96           C  
ATOM    284  O   THR A  37      30.949  29.857  26.882  1.00 14.66           O  
ATOM    285  CB  THR A  37      29.215  31.525  28.502  1.00 14.07           C  
ATOM    286  OG1 THR A  37      28.526  31.909  29.692  1.00 13.72           O  
ATOM    287  CG2 THR A  37      28.596  32.316  27.320  1.00 12.84           C  
ATOM    288  N   THR A  38      29.204  28.509  26.409  1.00 11.71           N  
ATOM    289  CA  THR A  38      29.875  27.875  25.280  1.00 13.87           C  
ATOM    290  C   THR A  38      30.113  28.799  24.082  1.00 13.40           C  
ATOM    291  O   THR A  38      31.174  28.712  23.418  1.00 13.51           O  
ATOM    292  CB  THR A  38      29.093  26.627  24.850  1.00 13.46           C  
ATOM    293  OG1 THR A  38      28.766  25.870  26.019  1.00 16.08           O  
ATOM    294  CG2 THR A  38      29.899  25.788  23.846  1.00 16.96           C  
ATOM    295  N   ALA A  39      29.139  29.683  23.781  1.00 12.34           N  
ATOM    296  CA  ALA A  39      29.260  30.637  22.668  1.00 12.69           C  
ATOM    297  C   ALA A  39      28.597  31.903  23.146  1.00 11.91           C  
ATOM    298  O   ALA A  39      27.640  31.846  23.899  1.00 11.65           O  
ATOM    299  CB  ALA A  39      28.506  30.136  21.399  1.00 13.60           C  
ATOM    300  N   TRP A  40      29.079  33.053  22.684  1.00 11.71           N  
ATOM    301  CA  TRP A  40      28.543  34.319  23.113  1.00 10.66           C  
ATOM    302  C   TRP A  40      28.829  35.304  21.994  1.00 10.23           C  
ATOM    303  O   TRP A  40      29.975  35.447  21.560  1.00  9.91           O  
ATOM    304  CB  TRP A  40      29.255  34.785  24.390  1.00 10.19           C  
ATOM    305  CG  TRP A  40      28.781  36.119  24.920  1.00  9.86           C  
ATOM    306  CD1 TRP A  40      27.752  36.321  25.766  1.00 11.40           C  
ATOM    307  CD2 TRP A  40      29.331  37.440  24.633  1.00 10.99           C  
ATOM    308  NE1 TRP A  40      27.592  37.693  26.010  1.00 12.50           N  
ATOM    309  CE2 TRP A  40      28.581  38.374  25.366  1.00 13.63           C  
ATOM    310  CE3 TRP A  40      30.421  37.901  23.883  1.00 11.75           C  
ATOM    311  CZ2 TRP A  40      28.880  39.754  25.372  1.00 12.22           C  
ATOM    312  CZ3 TRP A  40      30.699  39.298  23.882  1.00 12.72           C  
ATOM    313  CH2 TRP A  40      29.933  40.176  24.612  1.00 10.95           C  
ATOM    314  N   PHE A  41      27.779  35.954  21.537  1.00 10.92           N  
ATOM    315  CA  PHE A  41      27.889  36.886  20.408  1.00 11.10           C  
ATOM    316  C   PHE A  41      27.296  38.235  20.768  1.00 11.14           C  
ATOM    317  O   PHE A  41      26.146  38.309  21.144  1.00 11.73           O  
ATOM    318  CB  PHE A  41      27.087  36.333  19.204  1.00 10.50           C  
ATOM    319  CG  PHE A  41      27.572  34.979  18.702  1.00 13.96           C  
ATOM    320  CD1 PHE A  41      28.573  34.892  17.730  1.00 15.46           C  
ATOM    321  CD2 PHE A  41      27.014  33.816  19.192  1.00 11.02           C  
ATOM    322  CE1 PHE A  41      28.989  33.617  17.232  1.00 15.51           C  
ATOM    323  CE2 PHE A  41      27.442  32.533  18.720  1.00 13.15           C  
ATOM    324  CZ  PHE A  41      28.421  32.446  17.749  1.00 11.90           C  
ATOM    325  N   ALA A  42      28.067  39.302  20.614  1.00 11.60           N  
ATOM    326  CA  ALA A  42      27.526  40.655  20.818  1.00 11.67           C  
ATOM    327  C   ALA A  42      27.050  41.184  19.477  1.00 12.40           C  
ATOM    328  O   ALA A  42      27.825  41.161  18.517  1.00 13.78           O  
ATOM    329  CB  ALA A  42      28.603  41.557  21.433  1.00 12.64           C  
ATOM    330  N   LEU A  43      25.795  41.663  19.421  1.00 10.74           N  
ATOM    331  CA  LEU A  43      25.083  41.865  18.170  1.00 10.80           C  
ATOM    332  C   LEU A  43      24.737  43.311  17.949  1.00 10.83           C  
ATOM    333  O   LEU A  43      24.413  44.013  18.907  1.00 10.73           O  
ATOM    334  CB  LEU A  43      23.752  41.097  18.214  1.00 10.85           C  
ATOM    335  CG  LEU A  43      23.843  39.641  18.656  1.00  9.30           C  
ATOM    336  CD1 LEU A  43      22.444  39.075  18.738  1.00 10.40           C  
ATOM    337  CD2 LEU A  43      24.706  38.872  17.648  1.00 11.24           C  
ATOM    338  N   LYS A  44      24.797  43.737  16.704  1.00 12.28           N  
ATOM    339  CA  LYS A  44      24.242  45.038  16.306  1.00 12.54           C  
ATOM    340  C   LYS A  44      23.261  44.783  15.156  1.00 14.12           C  
ATOM    341  O   LYS A  44      23.636  44.245  14.093  1.00 12.50           O  
ATOM    342  CB  LYS A  44      25.345  45.999  15.853  1.00 13.16           C  
ATOM    343  CG  LYS A  44      24.818  47.376  15.373  1.00 14.11           C  
ATOM    344  CD  LYS A  44      26.045  48.250  14.932  1.00 16.84           C  
ATOM    345  CE  LYS A  44      25.840  49.707  15.009  1.00 22.09           C  
ATOM    346  NZ  LYS A  44      24.636  50.176  14.466  1.00 19.27           N  
ATOM    347  N   PHE A  45      22.007  45.187  15.373  1.00 14.91           N  
ATOM    348  CA  PHE A  45      20.946  44.991  14.388  1.00 15.85           C  
ATOM    349  C   PHE A  45      20.687  46.212  13.540  1.00 16.98           C  
ATOM    350  O   PHE A  45      20.176  46.096  12.422  1.00 16.44           O  
ATOM    351  CB  PHE A  45      19.632  44.627  15.076  1.00 15.77           C  
ATOM    352  CG  PHE A  45      19.623  43.268  15.720  1.00 16.47           C  
ATOM    353  CD1 PHE A  45      19.365  42.115  14.982  1.00 17.32           C  
ATOM    354  CD2 PHE A  45      19.809  43.151  17.092  1.00 17.36           C  
ATOM    355  CE1 PHE A  45      19.335  40.847  15.613  1.00 17.80           C  
ATOM    356  CE2 PHE A  45      19.762  41.911  17.706  1.00 18.88           C  
ATOM    357  CZ  PHE A  45      19.540  40.751  16.955  1.00 18.80           C  
ATOM    358  N   GLY A  46      21.014  47.392  14.069  1.00 16.09           N  
ATOM    359  CA  GLY A  46      20.544  48.646  13.473  1.00 16.47           C  
ATOM    360  C   GLY A  46      21.133  49.783  14.286  1.00 15.72           C  
ATOM    361  O   GLY A  46      21.853  49.539  15.255  1.00 17.84           O  
ATOM    362  N   PRO A  47      20.842  51.027  13.893  1.00 15.24           N  
ATOM    363  CA  PRO A  47      21.446  52.188  14.492  1.00 15.19           C  
ATOM    364  C   PRO A  47      21.389  52.158  16.028  1.00 14.69           C  
ATOM    365  O   PRO A  47      22.390  52.469  16.691  1.00 14.70           O  
ATOM    366  CB  PRO A  47      20.594  53.364  13.947  1.00 14.96           C  
ATOM    367  CG  PRO A  47      19.748  52.831  12.896  1.00 16.49           C  
ATOM    368  CD  PRO A  47      19.937  51.351  12.776  1.00 14.70           C  
ATOM    369  N   SER A  48      20.248  51.767  16.588  1.00 13.79           N  
ATOM    370  CA  SER A  48      20.084  51.854  18.028  1.00 14.86           C  
ATOM    371  C   SER A  48      19.698  50.499  18.670  1.00 13.40           C  
ATOM    372  O   SER A  48      19.388  50.434  19.863  1.00 14.11           O  
ATOM    373  CB  SER A  48      19.061  52.932  18.362  1.00 15.86           C  
ATOM    374  OG  SER A  48      17.778  52.527  17.971  1.00 19.10           O  
ATOM    375  N   THR A  49      19.762  49.430  17.891  1.00 12.94           N  
ATOM    376  CA  THR A  49      19.276  48.135  18.357  1.00 13.11           C  
ATOM    377  C   THR A  49      20.417  47.124  18.403  1.00 12.66           C  
ATOM    378  O   THR A  49      21.076  46.862  17.374  1.00 11.65           O  
ATOM    379  CB  THR A  49      18.082  47.611  17.484  1.00 13.85           C  
ATOM    380  OG1 THR A  49      16.982  48.554  17.577  1.00 19.72           O  
ATOM    381  CG2 THR A  49      17.617  46.246  17.992  1.00 16.90           C  
ATOM    382  N   PHE A  50      20.655  46.578  19.589  1.00 10.95           N  
ATOM    383  CA  PHE A  50      21.790  45.689  19.802  1.00 10.98           C  
ATOM    384  C   PHE A  50      21.250  44.420  20.440  1.00 10.78           C  
ATOM    385  O   PHE A  50      20.034  44.285  20.625  1.00 10.92           O  
ATOM    386  CB  PHE A  50      22.844  46.383  20.661  1.00 10.86           C  
ATOM    387  CG  PHE A  50      23.441  47.601  19.996  1.00 12.16           C  
ATOM    388  CD1 PHE A  50      24.620  47.496  19.287  1.00 12.02           C  
ATOM    389  CD2 PHE A  50      22.786  48.846  20.033  1.00 13.12           C  
ATOM    390  CE1 PHE A  50      25.173  48.615  18.649  1.00 16.42           C  
ATOM    391  CE2 PHE A  50      23.327  49.963  19.383  1.00 14.15           C  
ATOM    392  CZ  PHE A  50      24.529  49.835  18.682  1.00 11.99           C  
ATOM    393  N   GLY A  51      22.149  43.480  20.741  1.00 10.22           N  
ATOM    394  CA  GLY A  51      21.750  42.264  21.412  1.00 10.11           C  
ATOM    395  C   GLY A  51      22.908  41.423  21.815  1.00 10.05           C  
ATOM    396  O   GLY A  51      24.065  41.788  21.605  1.00 10.06           O  
ATOM    397  N   VAL A  52      22.558  40.277  22.394  1.00 10.00           N  
ATOM    398  CA  VAL A  52      23.453  39.181  22.656  1.00 11.75           C  
ATOM    399  C   VAL A  52      22.705  37.896  22.295  1.00 11.40           C  
ATOM    400  O   VAL A  52      21.491  37.741  22.616  1.00 12.11           O  
ATOM    401  CB  VAL A  52      23.796  39.141  24.160  1.00 11.00           C  
ATOM    402  CG1 VAL A  52      24.599  37.879  24.486  1.00 12.46           C  
ATOM    403  CG2 VAL A  52      24.604  40.398  24.528  1.00 12.96           C  
ATOM    404  N   PHE A  53      23.414  36.981  21.635  1.00 11.79           N  
ATOM    405  CA  PHE A  53      22.993  35.614  21.554  1.00 11.43           C  
ATOM    406  C   PHE A  53      24.070  34.775  22.263  1.00 12.20           C  
ATOM    407  O   PHE A  53      25.278  34.893  21.982  1.00 11.05           O  
ATOM    408  CB  PHE A  53      22.816  35.154  20.104  1.00 12.19           C  
ATOM    409  CG  PHE A  53      22.389  33.701  19.983  1.00 11.80           C  
ATOM    410  CD1 PHE A  53      21.064  33.341  20.176  1.00 10.98           C  
ATOM    411  CD2 PHE A  53      23.319  32.705  19.725  1.00 13.25           C  
ATOM    412  CE1 PHE A  53      20.646  32.002  20.116  1.00 12.62           C  
ATOM    413  CE2 PHE A  53      22.914  31.348  19.661  1.00 14.84           C  
ATOM    414  CZ  PHE A  53      21.567  31.018  19.867  1.00 14.07           C  
ATOM    415  N   ASP A  54      23.644  33.955  23.196  1.00 11.92           N  
ATOM    416  CA  ASP A  54      24.627  33.080  23.842  1.00 12.82           C  
ATOM    417  C   ASP A  54      24.066  31.690  24.103  1.00 13.52           C  
ATOM    418  O   ASP A  54      22.858  31.500  24.154  1.00 13.15           O  
ATOM    419  CB  ASP A  54      25.297  33.707  25.086  1.00 13.68           C  
ATOM    420  CG  ASP A  54      24.316  34.333  26.047  1.00 18.27           C  
ATOM    421  OD1 ASP A  54      23.132  33.902  26.059  1.00 20.99           O  
ATOM    422  OD2 ASP A  54      24.737  35.234  26.837  1.00 21.64           O  
ATOM    423  N   ALA A  55      24.965  30.720  24.223  1.00 12.62           N  
ATOM    424  CA  ALA A  55      24.552  29.324  24.222  1.00 12.87           C  
ATOM    425  C   ALA A  55      25.290  28.582  25.330  1.00 13.28           C  
ATOM    426  O   ALA A  55      26.422  28.954  25.686  1.00 13.64           O  
ATOM    427  CB  ALA A  55      24.844  28.688  22.847  1.00 12.27           C  
ATOM    428  N   PHE A  56      24.641  27.530  25.847  1.00 14.24           N  
ATOM    429  CA  PHE A  56      25.051  26.860  27.101  1.00 16.67           C  
ATOM    430  C   PHE A  56      24.747  25.362  26.999  1.00 17.00           C  
ATOM    431  O   PHE A  56      23.853  24.962  26.249  1.00 18.30           O  
ATOM    432  CB  PHE A  56      24.303  27.442  28.313  1.00 16.57           C  
ATOM    433  CG  PHE A  56      24.233  28.939  28.337  1.00 16.03           C  
ATOM    434  CD1 PHE A  56      25.274  29.698  28.896  1.00 16.06           C  
ATOM    435  CD2 PHE A  56      23.150  29.593  27.787  1.00 13.26           C  
ATOM    436  CE1 PHE A  56      25.234  31.086  28.913  1.00 14.06           C  
ATOM    437  CE2 PHE A  56      23.083  31.017  27.792  1.00 15.86           C  
ATOM    438  CZ  PHE A  56      24.147  31.750  28.359  1.00 12.86           C  
ATOM    439  N   ALA A  57      25.477  24.540  27.744  1.00 18.34           N  
ATOM    440  CA  ALA A  57      25.215  23.107  27.812  1.00 20.01           C  
ATOM    441  C   ALA A  57      24.019  22.834  28.703  1.00 20.53           C  
ATOM    442  O   ALA A  57      23.237  21.890  28.456  1.00 20.48           O  
ATOM    443  CB  ALA A  57      26.410  22.391  28.376  1.00 20.78           C  
ATOM    444  N   ASP A  58      23.868  23.651  29.750  1.00 20.21           N  
ATOM    445  CA  ASP A  58      22.790  23.385  30.686  1.00 19.61           C  
ATOM    446  C   ASP A  58      22.312  24.600  31.438  1.00 19.10           C  
ATOM    447  O   ASP A  58      22.899  25.703  31.317  1.00 17.75           O  
ATOM    448  CB  ASP A  58      23.222  22.301  31.676  1.00 19.89           C  
ATOM    449  CG  ASP A  58      24.540  22.595  32.309  1.00 21.46           C  
ATOM    450  OD1 ASP A  58      24.862  23.779  32.526  1.00 20.85           O  
ATOM    451  OD2 ASP A  58      25.281  21.618  32.599  1.00 24.55           O  
ATOM    452  N   GLU A  59      21.233  24.394  32.204  1.00 18.29           N  
ATOM    453  CA  GLU A  59      20.598  25.476  32.938  1.00 18.94           C  
ATOM    454  C   GLU A  59      21.598  26.116  33.895  1.00 19.08           C  
ATOM    455  O   GLU A  59      21.599  27.333  34.039  1.00 19.83           O  
ATOM    456  CB  GLU A  59      19.343  25.008  33.699  1.00 19.98           C  
ATOM    457  CG  GLU A  59      18.456  26.179  34.171  1.00 22.17           C  
ATOM    458  CD  GLU A  59      18.000  27.068  32.995  1.00 25.90           C  
ATOM    459  OE1 GLU A  59      17.119  26.642  32.237  1.00 26.89           O  
ATOM    460  OE2 GLU A  59      18.541  28.179  32.801  1.00 27.70           O  
ATOM    461  N   ALA A  60      22.454  25.312  34.531  1.00 17.80           N  
ATOM    462  CA  ALA A  60      23.425  25.888  35.484  1.00 17.37           C  
ATOM    463  C   ALA A  60      24.315  26.923  34.768  1.00 16.47           C  
ATOM    464  O   ALA A  60      24.601  27.969  35.313  1.00 15.77           O  
ATOM    465  CB  ALA A  60      24.247  24.808  36.114  1.00 18.29           C  
ATOM    466  N   GLY A  61      24.723  26.620  33.535  1.00 15.57           N  
ATOM    467  CA  GLY A  61      25.612  27.505  32.760  1.00 15.46           C  
ATOM    468  C   GLY A  61      24.817  28.757  32.373  1.00 15.10           C  
ATOM    469  O   GLY A  61      25.308  29.898  32.472  1.00 15.16           O  
ATOM    470  N   ARG A  62      23.568  28.565  31.957  1.00 15.40           N  
ATOM    471  CA  ARG A  62      22.754  29.717  31.565  1.00 15.69           C  
ATOM    472  C   ARG A  62      22.564  30.669  32.747  1.00 15.93           C  
ATOM    473  O   ARG A  62      22.672  31.894  32.599  1.00 15.22           O  
ATOM    474  CB  ARG A  62      21.398  29.255  31.023  1.00 16.09           C  
ATOM    475  CG  ARG A  62      20.573  30.387  30.493  1.00 16.30           C  
ATOM    476  CD  ARG A  62      19.590  29.842  29.444  1.00 17.46           C  
ATOM    477  NE  ARG A  62      18.467  29.131  30.043  1.00 14.16           N  
ATOM    478  CZ  ARG A  62      17.422  28.671  29.346  1.00 17.33           C  
ATOM    479  NH1 ARG A  62      17.372  28.847  28.031  1.00 15.56           N  
ATOM    480  NH2 ARG A  62      16.417  28.051  29.958  1.00 15.26           N  
ATOM    481  N   GLN A  63      22.275  30.100  33.923  1.00 16.08           N  
ATOM    482  CA  GLN A  63      22.022  30.887  35.150  1.00 17.21           C  
ATOM    483  C   GLN A  63      23.285  31.595  35.660  1.00 17.68           C  
ATOM    484  O   GLN A  63      23.200  32.720  36.186  1.00 18.59           O  
ATOM    485  CB  GLN A  63      21.451  29.987  36.261  1.00 16.86           C  
ATOM    486  CG  GLN A  63      20.011  29.550  36.001  1.00 19.65           C  
ATOM    487  CD  GLN A  63      19.078  30.728  35.896  1.00 22.72           C  
ATOM    488  OE1 GLN A  63      19.047  31.585  36.781  1.00 24.73           O  
ATOM    489  NE2 GLN A  63      18.310  30.792  34.805  1.00 24.67           N  
ATOM    490  N   ALA A  64      24.432  30.941  35.526  1.00 17.45           N  
ATOM    491  CA  ALA A  64      25.728  31.538  35.907  1.00 16.41           C  
ATOM    492  C   ALA A  64      25.997  32.794  35.055  1.00 16.73           C  
ATOM    493  O   ALA A  64      26.581  33.775  35.523  1.00 15.39           O  
ATOM    494  CB  ALA A  64      26.854  30.523  35.730  1.00 17.50           C  
ATOM    495  N   HIS A  65      25.583  32.741  33.796  1.00 15.26           N  
ATOM    496  CA  HIS A  65      25.703  33.886  32.923  1.00 16.07           C  
ATOM    497  C   HIS A  65      24.751  35.025  33.389  1.00 16.23           C  
ATOM    498  O   HIS A  65      25.147  36.212  33.503  1.00 16.02           O  
ATOM    499  CB  HIS A  65      25.427  33.504  31.461  1.00 15.94           C  
ATOM    500  CG  HIS A  65      25.493  34.680  30.551  1.00 15.67           C  
ATOM    501  ND1 HIS A  65      26.692  35.234  30.159  1.00 17.94           N  
ATOM    502  CD2 HIS A  65      24.526  35.503  30.084  1.00 17.40           C  
ATOM    503  CE1 HIS A  65      26.459  36.300  29.410  1.00 15.04           C  
ATOM    504  NE2 HIS A  65      25.150  36.480  29.349  1.00 16.66           N  
ATOM    505  N   LEU A  66      23.502  34.663  33.674  1.00 16.56           N  
ATOM    506  CA  LEU A  66      22.552  35.661  34.104  1.00 18.18           C  
ATOM    507  C   LEU A  66      23.007  36.300  35.390  1.00 17.96           C  
ATOM    508  O   LEU A  66      22.668  37.436  35.654  1.00 19.91           O  
ATOM    509  CB  LEU A  66      21.133  35.081  34.261  1.00 17.73           C  
ATOM    510  CG  LEU A  66      20.525  34.707  32.904  1.00 19.20           C  
ATOM    511  CD1 LEU A  66      19.233  33.900  33.037  1.00 18.77           C  
ATOM    512  CD2 LEU A  66      20.295  35.983  32.053  1.00 19.73           C  
ATOM    513  N   ASN A  67      23.752  35.577  36.198  1.00 17.25           N  
ATOM    514  CA  ASN A  67      24.224  36.117  37.460  1.00 17.62           C  
ATOM    515  C   ASN A  67      25.700  36.542  37.416  1.00 17.42           C  
ATOM    516  O   ASN A  67      26.292  36.783  38.452  1.00 16.47           O  
ATOM    517  CB  ASN A  67      24.018  35.094  38.581  1.00 18.82           C  
ATOM    518  CG  ASN A  67      22.562  34.904  38.915  1.00 21.64           C  
ATOM    519  OD1 ASN A  67      21.968  35.753  39.574  1.00 24.36           O  
ATOM    520  ND2 ASN A  67      21.969  33.796  38.462  1.00 24.09           N  
ATOM    521  N   GLY A  68      26.251  36.698  36.216  1.00 15.82           N  
ATOM    522  CA  GLY A  68      27.693  36.839  36.063  1.00 14.82           C  
ATOM    523  C   GLY A  68      28.130  38.295  35.907  1.00 14.08           C  
ATOM    524  O   GLY A  68      27.322  39.217  36.113  1.00 13.09           O  
ATOM    525  N   GLN A  69      29.421  38.483  35.585  1.00 13.00           N  
ATOM    526  CA  GLN A  69      30.038  39.797  35.535  1.00 12.77           C  
ATOM    527  C   GLN A  69      29.462  40.689  34.426  1.00 13.09           C  
ATOM    528  O   GLN A  69      29.354  41.919  34.591  1.00 12.25           O  
ATOM    529  CB  GLN A  69      31.562  39.701  35.424  1.00 12.55           C  
ATOM    530  CG  GLN A  69      32.227  39.112  36.661  1.00 10.96           C  
ATOM    531  CD  GLN A  69      33.724  39.269  36.630  1.00 13.67           C  
ATOM    532  OE1 GLN A  69      34.246  40.234  36.098  1.00 15.76           O  
ATOM    533  NE2 GLN A  69      34.422  38.336  37.237  1.00 11.70           N  
ATOM    534  N   ILE A  70      29.049  40.088  33.307  1.00 12.87           N  
ATOM    535  CA  ILE A  70      28.492  40.926  32.209  1.00 13.22           C  
ATOM    536  C   ILE A  70      27.145  41.502  32.601  1.00 13.10           C  
ATOM    537  O   ILE A  70      26.939  42.734  32.472  1.00 12.22           O  
ATOM    538  CB  ILE A  70      28.323  40.103  30.929  1.00 14.01           C  
ATOM    539  CG1 ILE A  70      29.705  39.567  30.514  1.00 11.55           C  
ATOM    540  CG2 ILE A  70      27.668  40.949  29.829  1.00 13.49           C  
ATOM    541  CD1 ILE A  70      29.677  38.638  29.204  1.00 16.48           C  
ATOM    542  N   ALA A  71      26.287  40.640  33.167  1.00 12.02           N  
ATOM    543  CA  ALA A  71      24.961  41.035  33.636  1.00 13.46           C  
ATOM    544  C   ALA A  71      25.091  42.117  34.704  1.00 13.39           C  
ATOM    545  O   ALA A  71      24.362  43.110  34.677  1.00 14.78           O  
ATOM    546  CB  ALA A  71      24.140  39.774  34.132  1.00 14.50           C  
ATOM    547  N   ALA A  72      26.028  41.940  35.630  1.00 12.90           N  
ATOM    548  CA  ALA A  72      26.274  42.935  36.679  1.00 13.86           C  
ATOM    549  C   ALA A  72      26.750  44.274  36.079  1.00 13.84           C  
ATOM    550  O   ALA A  72      26.323  45.330  36.537  1.00 13.37           O  
ATOM    551  CB  ALA A  72      27.359  42.411  37.680  1.00 12.49           C  
ATOM    552  N   ALA A  73      27.689  44.224  35.111  1.00 13.54           N  
ATOM    553  CA  ALA A  73      28.206  45.446  34.490  1.00 14.06           C  
ATOM    554  C   ALA A  73      27.077  46.189  33.755  1.00 14.20           C  
ATOM    555  O   ALA A  73      26.994  47.421  33.799  1.00 14.22           O  
ATOM    556  CB  ALA A  73      29.434  45.126  33.513  1.00 14.12           C  
ATOM    557  N   LEU A  74      26.221  45.447  33.070  1.00 15.00           N  
ATOM    558  CA  LEU A  74      25.161  46.080  32.286  1.00 15.51           C  
ATOM    559  C   LEU A  74      24.153  46.638  33.283  1.00 14.94           C  
ATOM    560  O   LEU A  74      23.656  47.777  33.127  1.00 16.73           O  
ATOM    561  CB  LEU A  74      24.509  45.066  31.362  1.00 16.69           C  
ATOM    562  CG  LEU A  74      23.424  45.676  30.450  1.00 19.76           C  
ATOM    563  CD1 LEU A  74      23.883  47.004  29.767  1.00 18.73           C  
ATOM    564  CD2 LEU A  74      22.946  44.603  29.452  1.00 20.80           C  
HETATM  565  N   MSE A  75      23.884  45.880  34.352  1.00 14.91           N  
HETATM  566  CA  MSE A  75      23.002  46.412  35.377  1.00 14.70           C  
HETATM  567  C   MSE A  75      23.553  47.698  36.013  1.00 14.97           C  
HETATM  568  O   MSE A  75      22.784  48.633  36.283  1.00 16.32           O  
HETATM  569  CB  MSE A  75      22.692  45.361  36.454  1.00 14.85           C  
HETATM  570  CG  MSE A  75      21.524  45.791  37.304  1.00 17.05           C  
HETATM  571 SE   MSE A  75      20.664  44.418  38.319  0.50 14.36          SE  
HETATM  572  CE  MSE A  75      22.193  43.230  38.384  1.00 16.44           C  
ATOM    573  N   ALA A  76      24.874  47.758  36.240  1.00 13.75           N  
ATOM    574  CA  ALA A  76      25.489  48.957  36.810  1.00 14.54           C  
ATOM    575  C   ALA A  76      25.379  50.165  35.862  1.00 15.64           C  
ATOM    576  O   ALA A  76      25.331  51.334  36.292  1.00 16.17           O  
ATOM    577  CB  ALA A  76      26.938  48.685  37.164  1.00 15.14           C  
ATOM    578  N   ASN A  77      25.302  49.895  34.570  1.00 14.90           N  
ATOM    579  CA  ASN A  77      25.296  50.995  33.627  1.00 15.45           C  
ATOM    580  C   ASN A  77      24.017  51.110  32.763  1.00 15.31           C  
ATOM    581  O   ASN A  77      23.983  51.869  31.776  1.00 13.44           O  
ATOM    582  CB  ASN A  77      26.552  50.929  32.779  1.00 15.98           C  
ATOM    583  CG  ASN A  77      27.821  51.128  33.609  1.00 16.81           C  
ATOM    584  OD1 ASN A  77      28.137  52.257  34.013  1.00 16.44           O  
ATOM    585  ND2 ASN A  77      28.527  50.023  33.908  1.00 14.98           N  
ATOM    586  N   ALA A  78      22.986  50.372  33.164  1.00 15.20           N  
ATOM    587  CA  ALA A  78      21.740  50.245  32.372  1.00 16.36           C  
ATOM    588  C   ALA A  78      21.095  51.577  32.090  1.00 16.40           C  
ATOM    589  O   ALA A  78      20.667  51.829  30.968  1.00 17.11           O  
ATOM    590  CB  ALA A  78      20.728  49.337  33.053  1.00 16.65           C  
ATOM    591  N   ALA A  79      20.995  52.409  33.111  1.00 17.06           N  
ATOM    592  CA  ALA A  79      20.358  53.714  32.943  1.00 18.02           C  
ATOM    593  C   ALA A  79      21.146  54.612  31.994  1.00 18.54           C  
ATOM    594  O   ALA A  79      20.547  55.400  31.246  1.00 19.29           O  
ATOM    595  CB  ALA A  79      20.185  54.403  34.268  1.00 18.88           C  
ATOM    596  N   THR A  80      22.474  54.532  32.038  1.00 16.92           N  
ATOM    597  CA  THR A  80      23.288  55.315  31.130  1.00 16.46           C  
ATOM    598  C   THR A  80      23.038  54.894  29.674  1.00 15.60           C  
ATOM    599  O   THR A  80      22.929  55.747  28.812  1.00 15.07           O  
ATOM    600  CB  THR A  80      24.788  55.153  31.471  1.00 17.73           C  
ATOM    601  OG1 THR A  80      24.986  55.521  32.852  1.00 20.94           O  
ATOM    602  CG2 THR A  80      25.662  56.065  30.623  1.00 16.93           C  
ATOM    603  N   LEU A  81      22.947  53.589  29.415  1.00 12.73           N  
ATOM    604  CA  LEU A  81      23.035  53.104  28.034  1.00 12.14           C  
ATOM    605  C   LEU A  81      21.710  52.759  27.375  1.00 12.21           C  
ATOM    606  O   LEU A  81      21.599  52.827  26.136  1.00 12.88           O  
ATOM    607  CB  LEU A  81      23.898  51.849  27.990  1.00 11.70           C  
ATOM    608  CG  LEU A  81      25.332  51.977  28.436  1.00 10.37           C  
ATOM    609  CD1 LEU A  81      26.039  50.602  28.642  1.00 14.01           C  
ATOM    610  CD2 LEU A  81      26.084  52.970  27.476  1.00 13.63           C  
ATOM    611  N   LEU A  82      20.719  52.381  28.179  1.00 12.14           N  
ATOM    612  CA  LEU A  82      19.505  51.768  27.617  1.00 12.96           C  
ATOM    613  C   LEU A  82      18.243  52.588  27.737  1.00 12.91           C  
ATOM    614  O   LEU A  82      18.058  53.300  28.717  1.00 13.80           O  
ATOM    615  CB  LEU A  82      19.258  50.398  28.266  1.00 12.50           C  
ATOM    616  CG  LEU A  82      20.416  49.366  28.273  1.00 13.83           C  
ATOM    617  CD1 LEU A  82      19.863  48.154  28.999  1.00 14.61           C  
ATOM    618  CD2 LEU A  82      20.893  48.989  26.852  1.00 15.74           C  
ATOM    619  N   SER A  83      17.383  52.494  26.738  1.00 12.54           N  
ATOM    620  CA  SER A  83      16.093  53.231  26.775  1.00 11.64           C  
ATOM    621  C   SER A  83      14.978  52.395  27.382  1.00 11.47           C  
ATOM    622  O   SER A  83      13.883  52.911  27.686  1.00 11.18           O  
ATOM    623  CB  SER A  83      15.712  53.692  25.371  1.00 12.55           C  
ATOM    624  OG  SER A  83      15.720  52.566  24.544  1.00 15.56           O  
ATOM    625  N   SER A  84      15.253  51.111  27.603  1.00 11.26           N  
ATOM    626  CA  SER A  84      14.324  50.156  28.284  1.00 12.49           C  
ATOM    627  C   SER A  84      15.085  48.953  28.831  1.00 11.73           C  
ATOM    628  O   SER A  84      16.217  48.686  28.402  1.00 11.46           O  
ATOM    629  CB  SER A  84      13.235  49.644  27.321  1.00 13.04           C  
ATOM    630  OG  SER A  84      13.831  49.040  26.184  1.00 13.90           O  
ATOM    631  N   PRO A  85      14.478  48.175  29.755  1.00 11.53           N  
ATOM    632  CA  PRO A  85      15.254  47.022  30.256  1.00 11.89           C  
ATOM    633  C   PRO A  85      15.608  46.029  29.136  1.00 12.30           C  
ATOM    634  O   PRO A  85      14.867  45.930  28.180  1.00 11.69           O  
ATOM    635  CB  PRO A  85      14.265  46.355  31.196  1.00 11.65           C  
ATOM    636  CG  PRO A  85      13.382  47.503  31.691  1.00 11.44           C  
ATOM    637  CD  PRO A  85      13.174  48.298  30.435  1.00 11.24           C  
ATOM    638  N   PRO A  86      16.712  45.274  29.273  1.00 12.66           N  
ATOM    639  CA  PRO A  86      16.964  44.206  28.312  1.00 12.96           C  
ATOM    640  C   PRO A  86      15.739  43.324  28.063  1.00 14.09           C  
ATOM    641  O   PRO A  86      14.999  43.004  28.994  1.00 14.00           O  
ATOM    642  CB  PRO A  86      18.113  43.408  28.977  1.00 13.99           C  
ATOM    643  CG  PRO A  86      18.912  44.555  29.678  1.00 12.02           C  
ATOM    644  CD  PRO A  86      17.760  45.343  30.314  1.00 12.77           C  
ATOM    645  N   ASN A  87      15.502  42.980  26.799  1.00 14.39           N  
ATOM    646  CA  ASN A  87      14.439  42.034  26.473  1.00 15.62           C  
ATOM    647  C   ASN A  87      15.044  40.632  26.293  1.00 15.43           C  
ATOM    648  O   ASN A  87      15.696  40.374  25.283  1.00 15.33           O  
ATOM    649  CB  ASN A  87      13.699  42.425  25.199  1.00 16.57           C  
ATOM    650  CG  ASN A  87      12.484  41.529  24.971  1.00 19.60           C  
ATOM    651  OD1 ASN A  87      12.583  40.458  24.361  1.00 23.76           O  
ATOM    652  ND2 ASN A  87      11.378  41.890  25.597  1.00 23.43           N  
ATOM    653  N   ILE A  88      14.845  39.750  27.278  1.00 14.94           N  
ATOM    654  CA  ILE A  88      15.549  38.467  27.338  1.00 15.02           C  
ATOM    655  C   ILE A  88      14.593  37.324  27.043  1.00 15.60           C  
ATOM    656  O   ILE A  88      13.551  37.200  27.705  1.00 14.47           O  
ATOM    657  CB  ILE A  88      16.211  38.256  28.685  1.00 14.65           C  
ATOM    658  CG1 ILE A  88      17.120  39.437  28.984  1.00 16.32           C  
ATOM    659  CG2 ILE A  88      16.988  36.909  28.696  1.00 14.88           C  
ATOM    660  CD1 ILE A  88      17.612  39.433  30.400  1.00 18.00           C  
ATOM    661  N   GLU A  89      14.898  36.582  25.977  1.00 15.09           N  
ATOM    662  CA  GLU A  89      14.156  35.379  25.598  1.00 16.89           C  
ATOM    663  C   GLU A  89      14.949  34.111  25.847  1.00 16.64           C  
ATOM    664  O   GLU A  89      16.064  33.933  25.337  1.00 15.61           O  
ATOM    665  CB  GLU A  89      13.740  35.408  24.111  1.00 15.85           C  
ATOM    666  CG  GLU A  89      12.656  36.418  23.804  1.00 18.04           C  
ATOM    667  CD  GLU A  89      12.366  36.495  22.295  1.00 19.41           C  
ATOM    668  OE1 GLU A  89      11.483  35.724  21.832  1.00 19.78           O  
ATOM    669  OE2 GLU A  89      13.029  37.318  21.581  1.00 19.32           O  
ATOM    670  N   LYS A  90      14.360  33.212  26.612  1.00 16.28           N  
ATOM    671  CA  LYS A  90      14.926  31.873  26.790  1.00 16.49           C  
ATOM    672  C   LYS A  90      14.634  31.054  25.545  1.00 17.60           C  
ATOM    673  O   LYS A  90      13.490  31.022  25.039  1.00 17.53           O  
ATOM    674  CB  LYS A  90      14.354  31.217  28.021  1.00 18.09           C  
ATOM    675  CG  LYS A  90      14.848  31.890  29.304  1.00 18.89           C  
ATOM    676  CD  LYS A  90      14.266  31.188  30.520  1.00 27.88           C  
ATOM    677  CE  LYS A  90      15.145  31.403  31.762  1.00 31.42           C  
ATOM    678  NZ  LYS A  90      15.333  32.844  32.150  1.00 34.06           N  
ATOM    679  N   VAL A  91      15.673  30.394  25.050  1.00 17.00           N  
ATOM    680  CA  VAL A  91      15.618  29.680  23.783  1.00 17.12           C  
ATOM    681  C   VAL A  91      16.088  28.232  23.970  1.00 16.86           C  
ATOM    682  O   VAL A  91      17.015  27.963  24.732  1.00 16.01           O  
ATOM    683  CB  VAL A  91      16.499  30.414  22.717  1.00 17.10           C  
ATOM    684  CG1 VAL A  91      16.554  29.626  21.393  1.00 18.05           C  
ATOM    685  CG2 VAL A  91      15.961  31.813  22.485  1.00 19.46           C  
ATOM    686  N   GLU A  92      15.412  27.287  23.306  1.00 15.49           N  
ATOM    687  CA  GLU A  92      15.895  25.903  23.266  1.00 16.24           C  
ATOM    688  C   GLU A  92      16.571  25.694  21.932  1.00 15.18           C  
ATOM    689  O   GLU A  92      16.089  26.202  20.906  1.00 15.98           O  
ATOM    690  CB  GLU A  92      14.725  24.928  23.429  1.00 15.63           C  
ATOM    691  CG  GLU A  92      14.164  24.944  24.873  1.00 16.64           C  
ATOM    692  CD  GLU A  92      13.041  23.947  25.096  1.00 21.24           C  
ATOM    693  OE1 GLU A  92      12.502  23.386  24.092  1.00 24.01           O  
ATOM    694  OE2 GLU A  92      12.696  23.732  26.292  1.00 26.09           O  
ATOM    695  N   LEU A  93      17.659  24.932  21.929  1.00 13.83           N  
ATOM    696  CA  LEU A  93      18.353  24.629  20.684  1.00 13.63           C  
ATOM    697  C   LEU A  93      17.943  23.246  20.183  1.00 13.31           C  
ATOM    698  O   LEU A  93      18.098  22.250  20.892  1.00 15.09           O  
ATOM    699  CB  LEU A  93      19.865  24.693  20.873  1.00 14.36           C  
ATOM    700  CG  LEU A  93      20.411  26.033  21.386  1.00 12.34           C  
ATOM    701  CD1 LEU A  93      21.916  25.916  21.561  1.00 11.25           C  
ATOM    702  CD2 LEU A  93      20.039  27.235  20.471  1.00 12.14           C  
ATOM    703  N   LEU A  94      17.417  23.209  18.968  1.00 12.90           N  
ATOM    704  CA  LEU A  94      17.031  21.985  18.301  1.00 11.73           C  
ATOM    705  C   LEU A  94      18.290  21.318  17.745  1.00 13.11           C  
ATOM    706  O   LEU A  94      18.335  20.093  17.636  1.00 12.10           O  
ATOM    707  CB  LEU A  94      16.032  22.277  17.155  1.00 12.15           C  
ATOM    708  CG  LEU A  94      14.667  22.864  17.525  1.00  9.74           C  
ATOM    709  CD1 LEU A  94      13.796  23.223  16.294  1.00  9.99           C  
ATOM    710  CD2 LEU A  94      13.887  21.922  18.442  1.00 12.02           C  
ATOM    711  N   ALA A  95      19.290  22.130  17.396  1.00 12.03           N  
ATOM    712  CA  ALA A  95      20.540  21.654  16.806  1.00 12.23           C  
ATOM    713  C   ALA A  95      21.510  22.802  16.842  1.00 12.95           C  
ATOM    714  O   ALA A  95      21.098  23.954  16.874  1.00 15.38           O  
ATOM    715  CB  ALA A  95      20.316  21.184  15.337  1.00 11.14           C  
ATOM    716  N   ALA A  96      22.805  22.499  16.829  1.00 13.87           N  
ATOM    717  CA  ALA A  96      23.841  23.546  16.888  1.00 13.67           C  
ATOM    718  C   ALA A  96      25.152  23.032  16.284  1.00 13.80           C  
ATOM    719  O   ALA A  96      25.604  21.896  16.568  1.00 16.74           O  
ATOM    720  CB  ALA A  96      24.066  23.978  18.306  1.00 13.67           C  
ATOM    721  N   LYS A  97      25.759  23.854  15.444  1.00 12.86           N  
ATOM    722  CA  LYS A  97      27.097  23.650  14.966  1.00 12.08           C  
ATOM    723  C   LYS A  97      28.006  24.653  15.648  1.00 14.51           C  
ATOM    724  O   LYS A  97      27.761  25.861  15.591  1.00 13.71           O  
ATOM    725  CB  LYS A  97      27.136  23.959  13.463  1.00 12.10           C  
ATOM    726  CG  LYS A  97      28.506  23.766  12.850  1.00 11.51           C  
ATOM    727  CD  LYS A  97      28.654  24.427  11.454  1.00  8.92           C  
ATOM    728  CE  LYS A  97      30.076  24.075  10.899  1.00 11.41           C  
ATOM    729  NZ  LYS A  97      30.278  24.637   9.483  1.00 11.26           N  
ATOM    730  N   LEU A  98      29.058  24.180  16.287  1.00 15.58           N  
ATOM    731  CA  LEU A  98      30.072  25.112  16.809  1.00 18.85           C  
ATOM    732  C   LEU A  98      31.417  24.581  16.343  1.00 19.50           C  
ATOM    733  O   LEU A  98      31.540  23.390  16.079  1.00 21.28           O  
ATOM    734  CB  LEU A  98      30.088  25.116  18.340  1.00 18.00           C  
ATOM    735  CG  LEU A  98      28.823  25.539  19.059  1.00 22.08           C  
ATOM    736  CD1 LEU A  98      28.316  24.317  19.748  1.00 26.31           C  
ATOM    737  CD2 LEU A  98      29.195  26.580  20.074  1.00 22.13           C  
ATOM    738  N   PRO A  99      32.442  25.439  16.279  1.00 21.12           N  
ATOM    739  CA  PRO A  99      33.762  24.802  16.139  1.00 22.34           C  
ATOM    740  C   PRO A  99      34.038  23.792  17.297  1.00 22.55           C  
ATOM    741  O   PRO A  99      33.563  24.003  18.412  1.00 22.71           O  
ATOM    742  CB  PRO A  99      34.730  25.968  16.212  1.00 21.77           C  
ATOM    743  CG  PRO A  99      33.943  27.200  15.894  1.00 22.54           C  
ATOM    744  CD  PRO A  99      32.493  26.917  16.280  1.00 20.97           C  
ATOM    745  N   ALA A 100      34.783  22.712  17.054  1.00 24.20           N  
ATOM    746  CA  ALA A 100      35.019  21.706  18.106  1.00 24.27           C  
ATOM    747  C   ALA A 100      35.761  22.239  19.363  1.00 24.82           C  
ATOM    748  O   ALA A 100      36.718  23.014  19.253  1.00 25.07           O  
ATOM    749  CB  ALA A 100      35.754  20.455  17.527  1.00 25.37           C  
ATOM    750  N   GLY A 101      35.327  21.810  20.547  1.00 25.21           N  
ATOM    751  CA  GLY A 101      36.040  22.127  21.801  1.00 26.01           C  
ATOM    752  C   GLY A 101      35.203  22.826  22.856  1.00 26.26           C  
ATOM    753  O   GLY A 101      33.974  22.731  22.848  1.00 26.97           O  
TER     754      GLY A 101                                                      
END
MOLECULE T0427_239_422.pdb
ATOM   1932  N   VAL   239       7.508  44.077  31.130  1.00 44.20          
ATOM   1933  CA  VAL   239       7.787  42.698  31.482  1.00 43.65          
ATOM   1934  C   VAL   239       8.702  42.088  30.403  1.00 42.68          
ATOM   1935  O   VAL   239       8.478  42.304  29.208  1.00 43.11          
ATOM   1936  CB  VAL   239       6.466  41.902  31.634  1.00 44.10          
ATOM   1937  CG1 VAL   239       6.727  40.413  31.842  1.00 46.16          
ATOM   1938  CG2 VAL   239       5.627  42.453  32.795  1.00 44.20          
ATOM   1939  N   ILE   240       9.734  41.358  30.816  1.00 40.50          
ATOM   1940  CA  ILE   240      10.567  40.601  29.875  1.00 39.74          
ATOM   1941  C   ILE   240       9.833  39.360  29.337  1.00 38.98          
ATOM   1942  O   ILE   240       9.300  38.585  30.126  1.00 38.48          
ATOM   1943  CB  ILE   240      11.877  40.182  30.544  1.00 39.33          
ATOM   1944  CG1 ILE   240      12.705  41.438  30.844  1.00 39.34          
ATOM   1945  CG2 ILE   240      12.670  39.181  29.672  1.00 40.59          
ATOM   1946  CD  ILE   240      13.617  41.328  32.023  1.00 41.99          
ATOM   1947  N   GLU   241       9.788  39.183  28.011  1.00 37.65          
ATOM   1948  CA  GLU   241       9.241  37.942  27.430  1.00 37.69          
ATOM   1949  C   GLU   241      10.322  36.875  27.305  1.00 37.80          
ATOM   1950  O   GLU   241      11.374  37.109  26.716  1.00 36.23          
ATOM   1951  CB  GLU   241       8.587  38.193  26.063  1.00 37.10          
ATOM   1952  CG  GLU   241       7.299  39.023  26.143  1.00 41.46          
ATOM   1953  CD  GLU   241       6.143  38.323  26.891  1.00 44.16          
ATOM   1954  OE1 GLU   241       5.450  39.042  27.647  1.00 47.58          
ATOM   1955  OE2 GLU   241       5.922  37.087  26.730  1.00 45.18          
ATOM   1956  N   GLU   242      10.050  35.692  27.853  1.00 38.66          
ATOM   1957  CA  GLU   242      10.977  34.557  27.790  1.00 40.17          
ATOM   1958  C   GLU   242      10.291  33.430  27.029  1.00 40.00          
ATOM   1959  O   GLU   242       9.134  33.068  27.343  1.00 39.65          
ATOM   1960  CB  GLU   242      11.330  34.090  29.200  1.00 40.47          
ATOM   1961  CG  GLU   242      11.625  35.238  30.159  1.00 42.17          
ATOM   1962  CD  GLU   242      12.192  34.804  31.516  1.00 44.28          
ATOM   1963  OE1 GLU   242      12.716  33.672  31.637  1.00 48.59          
ATOM   1964  OE2 GLU   242      12.131  35.621  32.468  1.00 49.45          
ATOM   1965  N   ARG   243      10.939  32.944  25.973  1.00 38.26          
ATOM   1966  CA  ARG   243      10.411  31.813  25.221  1.00 37.65          
ATOM   1967  C   ARG   243      11.445  30.693  25.226  1.00 37.37          
ATOM   1968  O   ARG   243      12.654  30.954  25.210  1.00 36.14          
ATOM   1969  CB  ARG   243      10.044  32.200  23.783  1.00 37.67          
ATOM   1970  CG  ARG   243       9.050  33.383  23.669  1.00 40.69          
ATOM   1971  CD  ARG   243       7.597  32.942  23.779  1.00 44.58          
ATOM   1972  NE  ARG   243       6.666  33.994  23.362  1.00 47.29          
ATOM   1973  CZ  ARG   243       6.256  34.973  24.159  1.00 51.25          
ATOM   1974  NH1 ARG   243       6.694  35.031  25.425  1.00 52.88          
ATOM   1975  NH2 ARG   243       5.400  35.893  23.705  1.00 50.13          
ATOM   1976  N   THR   244      10.966  29.451  25.238  1.00 37.08          
ATOM   1977  CA  THR   244      11.841  28.273  25.171  1.00 36.93          
ATOM   1978  C   THR   244      11.354  27.305  24.104  1.00 37.31          
ATOM   1979  O   THR   244      10.141  27.124  23.927  1.00 35.94          
ATOM   1980  CB  THR   244      11.863  27.511  26.497  1.00 38.09          
ATOM   1981  OG1 THR   244      12.150  28.421  27.571  1.00 39.14          
ATOM   1982  CG2 THR   244      12.932  26.406  26.465  1.00 36.76          
ATOM   1983  N   GLU   245      12.300  26.702  23.387  1.00 36.36          
ATOM   1984  CA  GLU   245      11.998  25.604  22.486  1.00 37.49          
ATOM   1985  C   GLU   245      12.951  24.470  22.794  1.00 36.30          
ATOM   1986  O   GLU   245      14.119  24.702  23.114  1.00 35.56          
ATOM   1987  CB  GLU   245      12.117  26.030  21.021  1.00 37.44          
ATOM   1988  CG  GLU   245      11.135  27.133  20.621  1.00 40.68          
ATOM   1989  CD  GLU   245      11.231  27.530  19.158  1.00 40.63          
ATOM   1990  OE1 GLU   245      11.899  26.814  18.383  1.00 42.77          
ATOM   1991  OE2 GLU   245      10.648  28.583  18.793  1.00 45.07          
ATOM   1992  N   ARG   246      12.450  23.242  22.703  1.00 36.03          
ATOM   1993  CA  ARG   246      13.275  22.067  22.923  1.00 36.10          
ATOM   1994  C   ARG   246      13.544  21.348  21.624  1.00 35.88          
ATOM   1995  O   ARG   246      12.630  21.174  20.806  1.00 34.82          
ATOM   1996  CB  ARG   246      12.582  21.110  23.878  1.00 37.21          
ATOM   1997  CG  ARG   246      12.424  21.627  25.300  1.00 42.49          
ATOM   1998  CD  ARG   246      12.076  20.460  26.249  1.00 51.21          
ATOM   1999  NE  ARG   246      13.285  19.767  26.704  1.00 56.98          
ATOM   2000  CZ  ARG   246      13.751  19.769  27.960  1.00 60.20          
ATOM   2001  NH1 ARG   246      13.099  20.416  28.935  1.00 60.89          
ATOM   2002  NH2 ARG   246      14.880  19.120  28.245  1.00 59.94          
ATOM   2003  N   GLU   247      14.803  20.920  21.446  1.00 35.20          
ATOM   2004  CA  GLU   247      15.238  20.217  20.248  1.00 34.88          
ATOM   2005  C   GLU   247      16.340  19.280  20.680  1.00 32.66          
ATOM   2006  O   GLU   247      16.966  19.461  21.731  1.00 31.35          
ATOM   2007  CB  GLU   247      15.850  21.190  19.214  1.00 35.75          
ATOM   2008  CG  GLU   247      14.893  22.117  18.475  1.00 38.70          
ATOM   2009  CD  GLU   247      15.533  22.724  17.218  1.00 39.16          
ATOM   2010  OE1 GLU   247      16.473  22.083  16.677  1.00 43.16          
ATOM   2011  OE2 GLU   247      15.087  23.818  16.774  1.00 43.40          
ATOM   2012  N   VAL   248      16.604  18.286  19.850  1.00 31.09          
ATOM   2013  CA  VAL   248      17.706  17.358  20.105  1.00 29.35          
ATOM   2014  C   VAL   248      18.955  18.124  19.705  1.00 29.32          
ATOM   2015  O   VAL   248      19.103  18.498  18.536  1.00 29.39          
ATOM   2016  CB  VAL   248      17.586  16.084  19.282  1.00 28.96          
ATOM   2017  CG1 VAL   248      18.760  15.176  19.576  1.00 29.59          
ATOM   2018  CG2 VAL   248      16.247  15.327  19.582  1.00 29.10          
ATOM   2019  N   LEU   249      19.835  18.398  20.663  1.00 27.90          
ATOM   2020  CA  LEU   249      21.010  19.240  20.375  1.00 28.12          
ATOM   2021  C   LEU   249      22.129  18.743  21.232  1.00 28.43          
ATOM   2022  O   LEU   249      21.871  18.142  22.268  1.00 29.00          
ATOM   2023  CB  LEU   249      20.738  20.693  20.768  1.00 27.42          
ATOM   2024  CG  LEU   249      19.503  21.465  20.282  1.00 28.44          
ATOM   2025  CD1 LEU   249      19.241  22.674  21.169  1.00 31.50          
ATOM   2026  CD2 LEU   249      19.657  21.883  18.834  1.00 32.41          
ATOM   2027  N   ALA   250      23.373  19.001  20.830  1.00 28.87          
ATOM   2028  CA  ALA   250      24.511  18.702  21.703  1.00 29.02          
ATOM   2029  C   ALA   250      24.910  19.897  22.568  1.00 30.37          
ATOM   2030  O   ALA   250      25.784  19.766  23.423  1.00 30.07          
ATOM   2031  CB  ALA   250      25.690  18.216  20.907  1.00 29.15          
ATOM   2032  N   GLN   251      24.252  21.040  22.362  1.00 30.05          
ATOM   2033  CA  GLN   251      24.577  22.295  23.034  1.00 31.17          
ATOM   2034  C   GLN   251      23.326  23.171  23.005  1.00 30.75          
ATOM   2035  O   GLN   251      22.716  23.327  21.942  1.00 30.09          
ATOM   2036  CB  GLN   251      25.693  23.029  22.255  1.00 31.64          
ATOM   2037  CG  GLN   251      26.287  24.217  22.971  1.00 34.37          
ATOM   2038  CD  GLN   251      27.367  24.929  22.144  1.00 33.35          
ATOM   2039  OE1 GLN   251      27.118  25.962  21.536  1.00 36.34          
ATOM   2040  NE2 GLN   251      28.557  24.364  22.125  1.00 38.19          
ATOM   2041  N   SER   252      22.946  23.745  24.149  1.00 29.67          
ATOM   2042  CA  SER   252      21.772  24.643  24.196  1.00 29.85          
ATOM   2043  C   SER   252      22.181  26.053  23.814  1.00 29.12          
ATOM   2044  O   SER   252      23.356  26.399  23.889  1.00 29.94          
ATOM   2045  CB  SER   252      21.144  24.644  25.590  1.00 29.89          
ATOM   2046  OG  SER   252      20.656  23.348  25.915  1.00 29.23          
ATOM   2047  N   LYS   253      21.225  26.867  23.399  1.00 28.74          
ATOM   2048  CA  LYS   253      21.474  28.264  23.075  1.00 29.02          
ATOM   2049  C   LYS   253      20.706  29.137  24.031  1.00 29.26          
ATOM   2050  O   LYS   253      19.524  28.890  24.298  1.00 28.51          
ATOM   2051  CB  LYS   253      21.041  28.591  21.641  1.00 29.02          
ATOM   2052  CG  LYS   253      21.607  27.633  20.587  1.00 30.62          
ATOM   2053  CD  LYS   253      23.126  27.648  20.589  1.00 35.83          
ATOM   2054  CE  LYS   253      23.758  26.793  19.494  1.00 34.74          
ATOM   2055  NZ  LYS   253      25.270  26.861  19.623  1.00 36.49          
ATOM   2056  N   LEU   254      21.365  30.159  24.559  1.00 28.97          
ATOM   2057  CA  LEU   254      20.651  31.099  25.418  1.00 29.63          
ATOM   2058  C   LEU   254      20.949  32.519  24.967  1.00 29.75          
ATOM   2059  O   LEU   254      22.088  32.994  25.085  1.00 28.73          
ATOM   2060  CB  LEU   254      21.020  30.862  26.912  1.00 28.85          
ATOM   2061  CG  LEU   254      20.418  31.852  27.934  1.00 29.89          
ATOM   2062  CD1 LEU   254      18.844  31.801  27.934  1.00 30.25          
ATOM   2063  CD2 LEU   254      20.983  31.596  29.355  1.00 29.13          
ATOM   2064  N   ASN   255      19.929  33.188  24.440  1.00 29.28          
ATOM   2065  CA  ASN   255      20.103  34.514  23.847  1.00 30.80          
ATOM   2066  C   ASN   255      19.217  35.569  24.510  1.00 29.92          
ATOM   2067  O   ASN   255      18.113  35.263  24.992  1.00 29.28          
ATOM   2068  CB  ASN   255      19.783  34.482  22.332  1.00 31.58          
ATOM   2069  CG  ASN   255      20.674  33.522  21.557  1.00 33.90          
ATOM   2070  OD1 ASN   255      21.798  33.186  21.973  1.00 32.64          
ATOM   2071  ND2 ASN   255      20.172  33.075  20.397  1.00 38.01          
ATOM   2072  N   LEU   256      19.676  36.814  24.497  1.00 28.94          
ATOM   2073  CA  LEU   256      18.983  37.916  25.199  1.00 29.27          
ATOM   2074  C   LEU   256      18.965  39.110  24.268  1.00 30.24          
ATOM   2075  O   LEU   256      19.972  39.401  23.601  1.00 30.60          
ATOM   2076  CB  LEU   256      19.723  38.338  26.478  1.00 28.64          
ATOM   2077  CG  LEU   256      19.895  37.394  27.668  1.00 30.77          
ATOM   2078  CD1 LEU   256      20.969  36.320  27.388  1.00 33.18          
ATOM   2079  CD2 LEU   256      20.308  38.217  28.843  1.00 34.16          
ATOM   2080  N   ALA   257      17.841  39.819  24.262  1.00 30.48          
ATOM   2081  CA  ALA   257      17.683  41.019  23.464  1.00 30.03          
ATOM   2082  C   ALA   257      17.320  42.191  24.354  1.00 30.37          
ATOM   2083  O   ALA   257      16.376  42.116  25.158  1.00 30.37          
ATOM   2084  CB  ALA   257      16.608  40.817  22.414  1.00 29.21          
ATOM   2085  N   TYR   258      18.023  43.301  24.142  1.00 30.34          
ATOM   2086  CA  TYR   258      17.840  44.517  24.902  1.00 30.03          
ATOM   2087  C   TYR   258      17.460  45.659  23.983  1.00 30.54          
ATOM   2088  O   TYR   258      17.989  45.744  22.875  1.00 31.06          
ATOM   2089  CB  TYR   258      19.180  44.922  25.505  1.00 30.81          
ATOM   2090  CG  TYR   258      19.836  43.950  26.451  1.00 32.53          
ATOM   2091  CD1 TYR   258      19.739  44.114  27.829  1.00 32.22          
ATOM   2092  CD2 TYR   258      20.617  42.906  25.962  1.00 33.22          
ATOM   2093  CE1 TYR   258      20.374  43.228  28.697  1.00 31.01          
ATOM   2094  CE2 TYR   258      21.276  42.027  26.817  1.00 32.91          
ATOM   2095  CZ  TYR   258      21.153  42.204  28.173  1.00 33.59          
ATOM   2096  OH  TYR   258      21.820  41.336  28.995  1.00 34.71          
ATOM   2097  N   ASN   259      16.573  46.541  24.440  1.00 30.09          
ATOM   2098  CA  ASN   259      16.287  47.787  23.733  1.00 31.50          
ATOM   2099  C   ASN   259      17.397  48.788  24.114  1.00 31.75          
ATOM   2100  O   ASN   259      17.690  48.982  25.306  1.00 31.29          
ATOM   2101  CB  ASN   259      14.902  48.312  24.149  1.00 31.29          
ATOM   2102  CG  ASN   259      14.498  49.592  23.418  1.00 31.83          
ATOM   2103  OD1 ASN   259      15.001  50.668  23.700  1.00 35.07          
ATOM   2104  ND2 ASN   259      13.566  49.471  22.509  1.00 33.70          
ATOM   2105  N   THR   260      18.028  49.389  23.121  1.00 31.14          
ATOM   2106  CA  THR   260      19.027  50.410  23.391  1.00 31.60          
ATOM   2107  C   THR   260      18.484  51.797  23.134  1.00 32.99          
ATOM   2108  O   THR   260      19.014  52.766  23.674  1.00 33.26          
ATOM   2109  CB  THR   260      20.264  50.255  22.488  1.00 30.78          
ATOM   2110  OG1 THR   260      19.845  50.443  21.127  1.00 33.19          
ATOM   2111  CG2 THR   260      20.919  48.861  22.638  1.00 31.92          
ATOM   2112  N   ASP   261      17.472  51.889  22.274  1.00 32.55          
ATOM   2113  CA  ASP   261      17.011  53.160  21.745  1.00 34.62          
ATOM   2114  C   ASP   261      18.165  54.046  21.182  1.00 33.79          
ATOM   2115  O   ASP   261      18.068  55.259  21.208  1.00 33.21          
ATOM   2116  CB  ASP   261      16.219  53.885  22.849  1.00 35.46          
ATOM   2117  CG  ASP   261      15.294  54.964  22.310  1.00 41.96          
ATOM   2118  OD1 ASP   261      14.602  54.721  21.278  1.00 47.86          
ATOM   2119  OD2 ASP   261      15.251  56.052  22.943  1.00 45.28          
ATOM   2120  N   ILE   262      19.253  53.444  20.683  1.00 32.97          
ATOM   2121  CA  ILE   262      20.347  54.230  20.110  1.00 31.84          
ATOM   2122  C   ILE   262      20.524  53.911  18.624  1.00 31.61          
ATOM   2123  O   ILE   262      20.659  52.749  18.247  1.00 31.50          
ATOM   2124  CB  ILE   262      21.684  54.011  20.859  1.00 31.44          
ATOM   2125  CG1 ILE   262      21.585  54.517  22.321  1.00 32.03          
ATOM   2126  CG2 ILE   262      22.842  54.719  20.135  1.00 31.03          
ATOM   2127  CD  ILE   262      22.683  53.917  23.205  1.00 31.38          
ATOM   2128  N   TYR   263      20.572  54.960  17.801  1.00 30.82          
ATOM   2129  CA  TYR   263      20.542  54.804  16.339  1.00 31.05          
ATOM   2130  C   TYR   263      21.719  55.463  15.682  1.00 30.28          
ATOM   2131  O   TYR   263      22.391  56.310  16.282  1.00 30.66          
ATOM   2132  CB  TYR   263      19.230  55.352  15.750  1.00 30.17          
ATOM   2133  CG  TYR   263      18.043  54.523  16.212  1.00 31.87          
ATOM   2134  CD1 TYR   263      17.524  53.514  15.406  1.00 32.53          
ATOM   2135  CD2 TYR   263      17.475  54.724  17.469  1.00 32.34          
ATOM   2136  CE1 TYR   263      16.462  52.724  15.836  1.00 33.41          
ATOM   2137  CE2 TYR   263      16.401  53.940  17.918  1.00 32.07          
ATOM   2138  CZ  TYR   263      15.906  52.949  17.101  1.00 33.33          
ATOM   2139  OH  TYR   263      14.856  52.169  17.524  1.00 32.87          
ATOM   2140  N   TYR   264      21.969  55.062  14.445  1.00 30.34          
ATOM   2141  CA  TYR   264      23.004  55.640  13.621  1.00 30.95          
ATOM   2142  C   TYR   264      22.798  57.160  13.638  1.00 30.47          
ATOM   2143  O   TYR   264      21.683  57.623  13.460  1.00 29.62          
ATOM   2144  CB  TYR   264      22.821  55.118  12.208  1.00 31.65          
ATOM   2145  CG  TYR   264      23.897  55.485  11.246  1.00 33.50          
ATOM   2146  CD1 TYR   264      25.048  54.705  11.120  1.00 34.41          
ATOM   2147  CD2 TYR   264      23.755  56.605  10.439  1.00 35.73          
ATOM   2148  CE1 TYR   264      26.040  55.046  10.186  1.00 37.65          
ATOM   2149  CE2 TYR   264      24.712  56.964   9.510  1.00 37.85          
ATOM   2150  CZ  TYR   264      25.859  56.191   9.384  1.00 36.18          
ATOM   2151  OH  TYR   264      26.768  56.573   8.426  1.00 34.72          
ATOM   2152  N   GLY   265      23.860  57.917  13.874  1.00 31.20          
ATOM   2153  CA  GLY   265      23.747  59.374  13.952  1.00 30.91          
ATOM   2154  C   GLY   265      23.267  59.978  15.276  1.00 32.09          
ATOM   2155  O   GLY   265      23.192  61.206  15.407  1.00 32.15          
ATOM   2156  N   ASP   266      22.953  59.143  16.262  1.00 30.80          
ATOM   2157  CA  ASP   266      22.510  59.627  17.595  1.00 30.73          
ATOM   2158  C   ASP   266      23.702  60.032  18.463  1.00 29.96          
ATOM   2159  O   ASP   266      24.813  59.572  18.258  1.00 30.86          
ATOM   2160  CB  ASP   266      21.749  58.537  18.353  1.00 30.44          
ATOM   2161  CG  ASP   266      20.268  58.453  17.976  1.00 34.30          
ATOM   2162  OD1 ASP   266      19.806  59.291  17.183  1.00 34.97          
ATOM   2163  OD2 ASP   266      19.575  57.514  18.464  1.00 33.93          
ATOM   2164  N   SER   267      23.432  60.856  19.468  1.00 29.13          
ATOM   2165  CA  SER   267      24.416  61.293  20.447  1.00 29.13          
ATOM   2166  C   SER   267      25.303  60.181  21.039  1.00 29.36          
ATOM   2167  O   SER   267      26.529  60.343  21.068  1.00 29.88          
ATOM   2168  CB  SER   267      23.699  62.062  21.553  1.00 28.22          
ATOM   2169  OG  SER   267      23.039  63.201  20.968  1.00 31.24          
ATOM   2170  N   TYR   268      24.684  59.078  21.474  1.00 28.35          
ATOM   2171  CA  TYR   268      25.386  57.942  22.065  1.00 29.54          
ATOM   2172  C   TYR   268      25.795  56.831  21.099  1.00 29.69          
ATOM   2173  O   TYR   268      26.213  55.736  21.532  1.00 30.19          
ATOM   2174  CB  TYR   268      24.613  57.385  23.273  1.00 30.26          
ATOM   2175  CG  TYR   268      24.723  58.333  24.469  1.00 31.41          
ATOM   2176  CD1 TYR   268      25.829  58.275  25.331  1.00 32.05          
ATOM   2177  CD2 TYR   268      23.755  59.322  24.703  1.00 32.10          
ATOM   2178  CE1 TYR   268      25.968  59.163  26.424  1.00 31.54          
ATOM   2179  CE2 TYR   268      23.885  60.215  25.791  1.00 32.56          
ATOM   2180  CZ  TYR   268      25.002  60.120  26.639  1.00 32.39          
ATOM   2181  OH  TYR   268      25.152  60.982  27.713  1.00 32.90          
ATOM   2182  N   TYR   269      25.723  57.117  19.801  1.00 29.89          
ATOM   2183  CA  TYR   269      26.144  56.127  18.784  1.00 30.14          
ATOM   2184  C   TYR   269      27.558  55.608  19.040  1.00 29.64          
ATOM   2185  O   TYR   269      27.781  54.398  19.067  1.00 29.25          
ATOM   2186  CB  TYR   269      26.027  56.701  17.374  1.00 30.46          
ATOM   2187  CG  TYR   269      26.498  55.723  16.294  1.00 31.24          
ATOM   2188  CD1 TYR   269      25.662  54.711  15.824  1.00 31.02          
ATOM   2189  CD2 TYR   269      27.791  55.807  15.779  1.00 32.79          
ATOM   2190  CE1 TYR   269      26.112  53.794  14.814  1.00 34.02          
ATOM   2191  CE2 TYR   269      28.255  54.918  14.798  1.00 36.23          
ATOM   2192  CZ  TYR   269      27.414  53.908  14.335  1.00 32.73          
ATOM   2193  OH  TYR   269      27.900  53.093  13.349  1.00 34.05          
ATOM   2194  N   PHE   270      28.540  56.504  19.176  1.00 29.44          
ATOM   2195  CA  PHE   270      29.931  56.052  19.363  1.00 29.67          
ATOM   2196  C   PHE   270      30.165  55.372  20.719  1.00 29.42          
ATOM   2197  O   PHE   270      30.835  54.322  20.797  1.00 28.90          
ATOM   2198  CB  PHE   270      30.930  57.211  19.115  1.00 29.38          
ATOM   2199  CG  PHE   270      31.027  57.570  17.678  1.00 31.35          
ATOM   2200  CD1 PHE   270      31.921  56.892  16.840  1.00 32.72          
ATOM   2201  CD2 PHE   270      30.171  58.535  17.126  1.00 32.01          
ATOM   2202  CE1 PHE   270      31.978  57.174  15.486  1.00 32.44          
ATOM   2203  CE2 PHE   270      30.217  58.823  15.762  1.00 31.01          
ATOM   2204  CZ  PHE   270      31.120  58.153  14.952  1.00 31.15          
ATOM   2205  N   ALA   271      29.592  55.962  21.775  1.00 29.00          
ATOM   2206  CA  ALA   271      29.592  55.345  23.117  1.00 30.26          
ATOM   2207  C   ALA   271      29.059  53.897  23.077  1.00 29.93          
ATOM   2208  O   ALA   271      29.555  53.021  23.774  1.00 29.98          
ATOM   2209  CB  ALA   271      28.737  56.204  24.084  1.00 29.72          
ATOM   2210  N   LEU   272      28.048  53.667  22.249  1.00 29.86          
ATOM   2211  CA  LEU   272      27.454  52.312  22.129  1.00 30.26          
ATOM   2212  C   LEU   272      28.424  51.349  21.438  1.00 30.18          
ATOM   2213  O   LEU   272      28.574  50.188  21.846  1.00 29.51          
ATOM   2214  CB  LEU   272      26.115  52.375  21.391  1.00 30.27          
ATOM   2215  CG  LEU   272      25.495  51.021  21.002  1.00 29.15          
ATOM   2216  CD1 LEU   272      25.027  50.324  22.283  1.00 30.49          
ATOM   2217  CD2 LEU   272      24.304  51.273  20.049  1.00 30.51          
ATOM   2218  N   GLN   273      29.133  51.859  20.427  1.00 31.18          
ATOM   2219  CA  GLN   273      30.155  51.067  19.740  1.00 32.14          
ATOM   2220  C   GLN   273      31.157  50.519  20.784  1.00 32.12          
ATOM   2221  O   GLN   273      31.488  49.336  20.791  1.00 32.47          
ATOM   2222  CB  GLN   273      30.873  51.936  18.697  1.00 32.85          
ATOM   2223  CG  GLN   273      29.995  52.423  17.533  1.00 35.46          
ATOM   2224  CD  GLN   273      29.579  51.274  16.624  1.00 43.02          
ATOM   2225  OE1 GLN   273      30.268  50.243  16.543  1.00 44.33          
ATOM   2226  NE2 GLN   273      28.449  51.429  15.952  1.00 44.10          
ATOM   2227  N   VAL   274      31.604  51.403  21.665  1.00 30.94          
ATOM   2228  CA  VAL   274      32.594  51.062  22.665  1.00 30.67          
ATOM   2229  C   VAL   274      31.960  50.196  23.744  1.00 30.30          
ATOM   2230  O   VAL   274      32.550  49.178  24.127  1.00 30.02          
ATOM   2231  CB  VAL   274      33.297  52.329  23.248  1.00 31.58          
ATOM   2232  CG1 VAL   274      34.306  51.951  24.374  1.00 28.78          
ATOM   2233  CG2 VAL   274      34.005  53.110  22.123  1.00 29.02          
ATOM   2234  N   PHE   275      30.760  50.567  24.210  1.00 29.65          
ATOM   2235  CA  PHE   275      30.079  49.745  25.228  1.00 29.98          
ATOM   2236  C   PHE   275      29.977  48.297  24.755  1.00 29.59          
ATOM   2237  O   PHE   275      30.281  47.355  25.506  1.00 28.98          
ATOM   2238  CB  PHE   275      28.676  50.264  25.545  1.00 29.89          
ATOM   2239  CG  PHE   275      27.830  49.236  26.248  1.00 31.97          
ATOM   2240  CD1 PHE   275      27.896  49.088  27.648  1.00 31.50          
ATOM   2241  CD2 PHE   275      26.999  48.386  25.517  1.00 31.72          
ATOM   2242  CE1 PHE   275      27.131  48.100  28.308  1.00 32.71          
ATOM   2243  CE2 PHE   275      26.241  47.397  26.163  1.00 34.12          
ATOM   2244  CZ  PHE   275      26.293  47.267  27.569  1.00 31.82          
ATOM   2245  N   ASN   276      29.571  48.127  23.494  1.00 29.80          
ATOM   2246  CA  ASN   276      29.374  46.798  22.936  1.00 30.85          
ATOM   2247  C   ASN   276      30.652  46.000  22.945  1.00 30.68          
ATOM   2248  O   ASN   276      30.644  44.807  23.307  1.00 31.49          
ATOM   2249  CB  ASN   276      28.790  46.820  21.516  1.00 30.72          
ATOM   2250  CG  ASN   276      28.604  45.408  20.972  1.00 33.29          
ATOM   2251  OD1 ASN   276      29.252  45.007  19.978  1.00 34.59          
ATOM   2252  ND2 ASN   276      27.761  44.636  21.649  1.00 27.18          
ATOM   2253  N   GLY   277      31.755  46.649  22.562  1.00 30.79          
ATOM   2254  CA  GLY   277      33.057  45.998  22.574  1.00 30.38          
ATOM   2255  C   GLY   277      33.472  45.535  23.959  1.00 30.92          
ATOM   2256  O   GLY   277      34.036  44.452  24.093  1.00 30.38          
ATOM   2257  N   ILE   278      33.177  46.341  24.990  1.00 29.89          
ATOM   2258  CA  ILE   278      33.607  46.027  26.362  1.00 31.11          
ATOM   2259  C   ILE   278      32.723  44.937  26.963  1.00 30.73          
ATOM   2260  O   ILE   278      33.179  44.131  27.782  1.00 31.31          
ATOM   2261  CB  ILE   278      33.542  47.302  27.236  1.00 30.48          
ATOM   2262  CG1 ILE   278      34.665  48.278  26.860  1.00 30.52          
ATOM   2263  CG2 ILE   278      33.601  46.987  28.734  1.00 32.65          
ATOM   2264  CD  ILE   278      34.353  49.740  27.345  1.00 32.32          
ATOM   2265  N   PHE   279      31.445  44.958  26.591  1.00 30.17          
ATOM   2266  CA  PHE   279      30.432  44.045  27.161  1.00 30.76          
ATOM   2267  C   PHE   279      30.622  42.613  26.617  1.00 31.41          
ATOM   2268  O   PHE   279      30.908  41.683  27.381  1.00 32.09          
ATOM   2269  CB  PHE   279      29.014  44.621  26.925  1.00 30.89          
ATOM   2270  CG  PHE   279      27.885  43.813  27.533  1.00 30.78          
ATOM   2271  CD1 PHE   279      27.979  43.258  28.827  1.00 31.76          
ATOM   2272  CD2 PHE   279      26.695  43.651  26.827  1.00 32.66          
ATOM   2273  CE1 PHE   279      26.903  42.517  29.397  1.00 31.43          
ATOM   2274  CE2 PHE   279      25.627  42.922  27.360  1.00 31.96          
ATOM   2275  CZ  PHE   279      25.708  42.371  28.669  1.00 30.16          
ATOM   2276  N   GLY   280      30.545  42.440  25.304  1.00 31.75          
ATOM   2277  CA  GLY   280      30.648  41.111  24.708  1.00 31.51          
ATOM   2278  C   GLY   280      31.148  41.107  23.275  1.00 32.22          
ATOM   2279  O   GLY   280      31.097  40.087  22.623  1.00 32.72          
ATOM   2280  N   GLY   281      31.642  42.238  22.771  1.00 32.72          
ATOM   2281  CA  GLY   281      31.915  42.355  21.331  1.00 33.96          
ATOM   2282  C   GLY   281      33.206  41.703  20.861  1.00 34.71          
ATOM   2283  O   GLY   281      33.308  41.231  19.707  1.00 35.14          
ATOM   2284  N   PHE   282      34.188  41.685  21.754  1.00 34.48          
ATOM   2285  CA  PHE   282      35.549  41.282  21.449  1.00 34.77          
ATOM   2286  C   PHE   282      36.039  40.251  22.474  1.00 35.34          
ATOM   2287  O   PHE   282      35.430  40.112  23.530  1.00 33.98          
ATOM   2288  CB  PHE   282      36.450  42.520  21.522  1.00 34.42          
ATOM   2289  CG  PHE   282      36.220  43.526  20.426  1.00 35.28          
ATOM   2290  CD1 PHE   282      36.366  43.175  19.083  1.00 36.04          
ATOM   2291  CD2 PHE   282      35.947  44.860  20.735  1.00 33.47          
ATOM   2292  CE1 PHE   282      36.205  44.127  18.061  1.00 35.11          
ATOM   2293  CE2 PHE   282      35.772  45.807  19.716  1.00 34.41          
ATOM   2294  CZ  PHE   282      35.884  45.437  18.375  1.00 34.21          
ATOM   2295  N   PRO   283      37.145  39.531  22.174  1.00 36.44          
ATOM   2296  CA  PRO   283      37.632  38.493  23.086  1.00 36.33          
ATOM   2297  C   PRO   283      38.055  38.979  24.472  1.00 36.19          
ATOM   2298  O   PRO   283      38.103  38.167  25.409  1.00 36.06          
ATOM   2299  CB  PRO   283      38.839  37.866  22.335  1.00 37.42          
ATOM   2300  CG  PRO   283      38.636  38.220  20.894  1.00 38.07          
ATOM   2301  CD  PRO   283      37.956  39.598  20.937  1.00 37.63          
ATOM   2302  N   HSD   284      38.314  40.282  24.608  1.00 35.27          
ATOM   2303  CA  HSD   284      38.720  40.863  25.873  1.00 35.20          
ATOM   2304  C   HSD   284      37.492  41.384  26.653  1.00 33.84          
ATOM   2305  O   HSD   284      37.627  41.987  27.723  1.00 34.02          
ATOM   2306  CB  HSD   284      39.740  41.993  25.640  1.00 36.00          
ATOM   2307  CG  HSD   284      39.199  43.134  24.823  1.00 34.76          
ATOM   2308  ND1 HSD   284      39.422  43.254  23.467  1.00 38.29          
ATOM   2309  CD2 HSD   284      38.431  44.193  25.169  1.00 37.66          
ATOM   2310  CE1 HSD   284      38.836  44.354  23.021  1.00 34.74          
ATOM   2311  NE2 HSD   284      38.218  44.935  24.031  1.00 34.78          
ATOM   2312  N   SER   285      36.297  41.104  26.134  1.00 33.19          
ATOM   2313  CA  SER   285      35.068  41.653  26.691  1.00 31.92          
ATOM   2314  C   SER   285      34.736  41.053  28.044  1.00 32.33          
ATOM   2315  O   SER   285      35.215  39.966  28.374  1.00 30.86          
ATOM   2316  CB  SER   285      33.889  41.415  25.752  1.00 31.78          
ATOM   2317  OG  SER   285      33.537  40.039  25.719  1.00 31.79          
ATOM   2318  N   LYS   286      33.875  41.726  28.811  1.00 30.27          
ATOM   2319  CA  LYS   286      33.484  41.165  30.112  1.00 30.67          
ATOM   2320  C   LYS   286      32.806  39.803  30.045  1.00 30.23          
ATOM   2321  O   LYS   286      33.067  38.934  30.893  1.00 32.35          
ATOM   2322  CB  LYS   286      32.643  42.175  30.927  1.00 29.86          
ATOM   2323  CG  LYS   286      33.460  43.425  31.278  1.00 30.82          
ATOM   2324  CD  LYS   286      32.737  44.357  32.244  1.00 30.72          
ATOM   2325  CE  LYS   286      33.638  45.566  32.587  1.00 31.80          
ATOM   2326  NZ  LYS   286      34.725  45.173  33.507  1.00 31.86          
ATOM   2327  N   LEU   287      31.947  39.586  29.052  1.00 30.78          
ATOM   2328  CA  LEU   287      31.267  38.292  28.947  1.00 31.03          
ATOM   2329  C   LEU   287      32.221  37.197  28.496  1.00 31.65          
ATOM   2330  O   LEU   287      32.174  36.067  29.023  1.00 30.76          
ATOM   2331  CB  LEU   287      30.042  38.381  28.029  1.00 31.30          
ATOM   2332  CG  LEU   287      28.922  39.376  28.406  1.00 33.52          
ATOM   2333  CD1 LEU   287      27.799  39.255  27.411  1.00 34.64          
ATOM   2334  CD2 LEU   287      28.396  39.132  29.842  1.00 31.24          
ATOM   2335  N   PHE   288      33.104  37.512  27.534  1.00 31.70          
ATOM   2336  CA  PHE   288      34.114  36.500  27.140  1.00 32.41          
ATOM   2337  C   PHE   288      34.958  36.121  28.341  1.00 31.64          
ATOM   2338  O   PHE   288      35.114  34.936  28.662  1.00 31.14          
ATOM   2339  CB  PHE   288      35.006  36.978  25.978  1.00 32.30          
ATOM   2340  CG  PHE   288      35.793  35.859  25.306  1.00 35.52          
ATOM   2341  CD1 PHE   288      35.393  35.339  24.061  1.00 38.07          
ATOM   2342  CD2 PHE   288      36.932  35.320  25.924  1.00 35.47          
ATOM   2343  CE1 PHE   288      36.152  34.292  23.436  1.00 38.00          
ATOM   2344  CE2 PHE   288      37.684  34.271  25.315  1.00 37.23          
ATOM   2345  CZ  PHE   288      37.296  33.770  24.079  1.00 36.73          
ATOM   2346  N   MET   289      35.491  37.135  29.014  1.00 31.77          
ATOM   2347  CA  MET   289      36.412  36.915  30.123  1.00 32.73          
ATOM   2348  C   MET   289      35.802  36.320  31.392  1.00 33.09          
ATOM   2349  O   MET   289      36.492  35.661  32.150  1.00 33.85          
ATOM   2350  CB  MET   289      37.173  38.215  30.461  1.00 32.91          
ATOM   2351  CG  MET   289      38.040  38.742  29.304  1.00 34.09          
ATOM   2352  SD  MET   289      39.384  37.373  28.790  0.80 38.46          
ATOM   2353  CE  MET   289      40.258  37.109  30.500  1.00 37.04          
ATOM   2354  N   ASN   290      34.523  36.544  31.635  1.00 33.24          
ATOM   2355  CA  ASN   290      33.922  36.139  32.909  1.00 33.86          
ATOM   2356  C   ASN   290      32.904  35.016  32.810  1.00 34.26          
ATOM   2357  O   ASN   290      32.791  34.210  33.734  1.00 34.79          
ATOM   2358  CB  ASN   290      33.295  37.355  33.598  1.00 34.00          
ATOM   2359  CG  ASN   290      34.341  38.299  34.125  1.00 34.27          
ATOM   2360  OD1 ASN   290      34.908  38.054  35.177  1.00 35.69          
ATOM   2361  ND2 ASN   290      34.646  39.340  33.370  1.00 32.52          
ATOM   2362  N   VAL   291      32.154  34.958  31.718  1.00 34.71          
ATOM   2363  CA  VAL   291      31.180  33.865  31.569  1.00 35.06          
ATOM   2364  C   VAL   291      31.831  32.693  30.818  1.00 35.48          
ATOM   2365  O   VAL   291      31.723  31.555  31.238  1.00 35.68          
ATOM   2366  CB  VAL   291      29.885  34.283  30.854  1.00 35.47          
ATOM   2367  CG1 VAL   291      28.836  33.150  30.976  1.00 36.79          
ATOM   2368  CG2 VAL   291      29.343  35.601  31.404  1.00 34.71          
ATOM   2369  N   ARG   292      32.516  32.973  29.722  1.00 36.02          
ATOM   2370  CA  ARG   292      33.204  31.912  28.992  1.00 36.58          
ATOM   2371  C   ARG   292      34.486  31.444  29.698  1.00 37.14          
ATOM   2372  O   ARG   292      34.616  30.273  30.058  1.00 36.73          
ATOM   2373  CB  ARG   292      33.523  32.393  27.577  1.00 36.58          
ATOM   2374  CG  ARG   292      34.229  31.346  26.734  1.00 39.72          
ATOM   2375  CD  ARG   292      34.557  31.932  25.384  1.00 41.59          
ATOM   2376  NE  ARG   292      35.234  30.947  24.541  1.00 45.35          
ATOM   2377  CZ  ARG   292      35.083  30.862  23.218  1.00 45.97          
ATOM   2378  NH1 ARG   292      34.268  31.702  22.562  1.00 44.69          
ATOM   2379  NH2 ARG   292      35.737  29.926  22.556  1.00 46.72          
ATOM   2380  N   GLU   293      35.446  32.352  29.862  1.00 37.22          
ATOM   2381  CA  GLU   293      36.620  32.069  30.673  1.00 38.99          
ATOM   2382  C   GLU   293      36.185  32.213  32.134  1.00 39.74          
ATOM   2383  O   GLU   293      35.063  32.659  32.426  1.00 40.25          
ATOM   2384  CB  GLU   293      37.757  33.049  30.364  1.00 38.58          
ATOM   2385  CG  GLU   293      38.077  33.186  28.861  1.00 40.41          
ATOM   2386  CD  GLU   293      38.983  32.067  28.329  1.00 42.68          
ATOM   2387  OE1 GLU   293      39.617  31.379  29.138  1.00 45.47          
ATOM   2388  OE2 GLU   293      39.084  31.886  27.096  1.00 45.11          
ATOM   2389  N   LYS   294      37.071  31.820  33.034  1.00 40.18          
ATOM   2390  CA  LYS   294      36.858  31.943  34.472  1.00 40.83          
ATOM   2391  C   LYS   294      35.746  31.030  34.994  1.00 40.78          
ATOM   2392  O   LYS   294      36.049  30.017  35.616  1.00 41.21          
ATOM   2393  CB  LYS   294      36.700  33.411  34.888  1.00 41.12          
ATOM   2394  CG  LYS   294      37.943  34.236  34.515  1.00 43.17          
ATOM   2395  CD  LYS   294      38.010  35.548  35.261  1.00 47.81          
ATOM   2396  CE  LYS   294      38.796  36.579  34.475  1.00 49.05          
ATOM   2397  NZ  LYS   294      38.288  37.958  34.829  1.00 55.71          
ATOM   2398  N   GLU   295      34.482  31.348  34.713  1.00 39.39          
ATOM   2399  CA  GLU   295      33.392  30.505  35.214  1.00 39.39          
ATOM   2400  C   GLU   295      33.158  29.273  34.338  1.00 37.89          
ATOM   2401  O   GLU   295      32.547  28.319  34.790  1.00 37.30          
ATOM   2402  CB  GLU   295      32.090  31.298  35.407  1.00 39.90          
ATOM   2403  CG  GLU   295      32.236  32.565  36.237  1.00 44.33          
ATOM   2404  CD  GLU   295      31.929  32.394  37.715  1.00 51.61          
ATOM   2405  OE1 GLU   295      31.833  31.232  38.206  1.00 53.88          
ATOM   2406  OE2 GLU   295      31.776  33.453  38.383  1.00 55.38          
ATOM   2407  N   HSD   296      33.666  29.288  33.105  1.00 36.75          
ATOM   2408  CA  HSD   296      33.497  28.181  32.164  1.00 36.17          
ATOM   2409  C   HSD   296      32.007  27.760  32.032  1.00 35.43          
ATOM   2410  O   HSD   296      31.688  26.572  32.001  1.00 33.86          
ATOM   2411  CB  HSD   296      34.392  26.953  32.543  1.00 36.92          
ATOM   2412  CG  HSD   296      35.826  27.302  32.874  1.00 39.20          
ATOM   2413  ND1 HSD   296      36.647  28.022  32.022  1.00 42.06          
ATOM   2414  CD2 HSD   296      36.585  27.005  33.958  1.00 41.77          
ATOM   2415  CE1 HSD   296      37.842  28.163  32.575  1.00 43.14          
ATOM   2416  NE2 HSD   296      37.830  27.557  33.752  1.00 40.98          
ATOM   2417  N   LEU   297      31.091  28.726  31.983  1.00 34.81          
ATOM   2418  CA  LEU   297      29.683  28.356  31.899  1.00 35.02          
ATOM   2419  C   LEU   297      29.094  28.538  30.511  1.00 34.44          
ATOM   2420  O   LEU   297      27.930  28.184  30.276  1.00 34.99          
ATOM   2421  CB  LEU   297      28.832  29.093  32.930  1.00 36.15          
ATOM   2422  CG  LEU   297      28.928  28.615  34.384  1.00 38.55          
ATOM   2423  CD1 LEU   297      27.731  29.183  35.090  1.00 40.12          
ATOM   2424  CD2 LEU   297      28.969  27.086  34.522  1.00 38.50          
ATOM   2425  N   ALA   298      29.883  29.065  29.591  1.00 32.65          
ATOM   2426  CA  ALA   298      29.419  29.183  28.218  1.00 32.08          
ATOM   2427  C   ALA   298      30.529  28.775  27.282  1.00 31.43          
ATOM   2428  O   ALA   298      31.699  29.055  27.550  1.00 30.47          
ATOM   2429  CB  ALA   298      28.964  30.627  27.929  1.00 30.91          
ATOM   2430  N   TYR   299      30.162  28.112  26.196  1.00 30.90          
ATOM   2431  CA  TYR   299      31.112  27.758  25.129  1.00 30.46          
ATOM   2432  C   TYR   299      31.467  28.992  24.336  1.00 31.63          
ATOM   2433  O   TYR   299      32.570  29.107  23.818  1.00 31.67          
ATOM   2434  CB  TYR   299      30.506  26.700  24.225  1.00 30.43          
ATOM   2435  CG  TYR   299      30.252  25.436  24.965  1.00 29.24          
ATOM   2436  CD1 TYR   299      31.285  24.512  25.166  1.00 28.29          
ATOM   2437  CD2 TYR   299      28.992  25.163  25.521  1.00 32.47          
ATOM   2438  CE1 TYR   299      31.070  23.353  25.873  1.00 29.58          
ATOM   2439  CE2 TYR   299      28.776  23.971  26.245  1.00 29.59          
ATOM   2440  CZ  TYR   299      29.834  23.090  26.413  1.00 29.08          
ATOM   2441  OH  TYR   299      29.668  21.912  27.104  1.00 31.20          
ATOM   2442  N   TYR   300      30.509  29.917  24.249  1.00 32.01          
ATOM   2443  CA  TYR   300      30.752  31.225  23.674  1.00 32.44          
ATOM   2444  C   TYR   300      29.727  32.179  24.221  1.00 32.48          
ATOM   2445  O   TYR   300      28.619  31.766  24.590  1.00 31.46          
ATOM   2446  CB  TYR   300      30.711  31.171  22.132  1.00 33.72          
ATOM   2447  CG  TYR   300      29.358  30.793  21.567  1.00 34.31          
ATOM   2448  CD1 TYR   300      28.358  31.758  21.381  1.00 35.90          
ATOM   2449  CD2 TYR   300      29.082  29.471  21.221  1.00 35.20          
ATOM   2450  CE1 TYR   300      27.110  31.404  20.861  1.00 35.09          
ATOM   2451  CE2 TYR   300      27.860  29.105  20.700  1.00 36.04          
ATOM   2452  CZ  TYR   300      26.882  30.048  20.517  1.00 34.96          
ATOM   2453  OH  TYR   300      25.660  29.628  20.009  1.00 35.10          
ATOM   2454  N   ALA   301      30.091  33.457  24.292  1.00 32.26          
ATOM   2455  CA  ALA   301      29.183  34.478  24.753  1.00 33.98          
ATOM   2456  C   ALA   301      29.547  35.761  24.023  1.00 35.15          
ATOM   2457  O   ALA   301      30.653  36.245  24.194  1.00 35.37          
ATOM   2458  CB  ALA   301      29.318  34.683  26.254  1.00 33.99          
ATOM   2459  N   SER   302      28.660  36.310  23.196  1.00 34.67          
ATOM   2460  CA  SER   302      29.052  37.569  22.561  1.00 35.72          
ATOM   2461  C   SER   302      27.890  38.501  22.384  1.00 34.71          
ATOM   2462  O   SER   302      26.740  38.098  22.525  1.00 34.93          
ATOM   2463  CB  SER   302      29.750  37.314  21.230  1.00 36.12          
ATOM   2464  OG  SER   302      28.832  36.801  20.320  1.00 40.09          
ATOM   2465  N   SER   303      28.193  39.759  22.094  1.00 34.13          
ATOM   2466  CA  SER   303      27.128  40.751  21.956  1.00 32.96          
ATOM   2467  C   SER   303      27.269  41.392  20.581  1.00 33.81          
ATOM   2468  O   SER   303      28.383  41.376  19.987  1.00 33.08          
ATOM   2469  CB  SER   303      27.181  41.777  23.099  1.00 32.63          
ATOM   2470  OG  SER   303      28.370  42.570  23.026  1.00 32.94          
ATOM   2471  N   SER   304      26.141  41.883  20.049  1.00 33.56          
ATOM   2472  CA  SER   304      26.074  42.527  18.732  1.00 34.01          
ATOM   2473  C   SER   304      25.060  43.633  18.878  1.00 32.71          
ATOM   2474  O   SER   304      24.144  43.511  19.690  1.00 33.13          
ATOM   2475  CB  SER   304      25.515  41.565  17.681  1.00 34.49          
ATOM   2476  OG  SER   304      26.371  40.456  17.558  1.00 39.10          
ATOM   2477  N   ILE   305      25.205  44.674  18.066  1.00 32.02          
ATOM   2478  CA  ILE   305      24.280  45.834  18.048  1.00 31.56          
ATOM   2479  C   ILE   305      23.693  46.081  16.648  1.00 31.42          
ATOM   2480  O   ILE   305      24.313  45.756  15.642  1.00 30.60          
ATOM   2481  CB  ILE   305      24.937  47.153  18.548  1.00 31.19          
ATOM   2482  CG1 ILE   305      26.233  47.446  17.762  1.00 32.51          
ATOM   2483  CG2 ILE   305      25.193  47.047  20.038  1.00 33.60          
ATOM   2484  CD  ILE   305      26.887  48.897  18.034  1.00 30.93          
ATOM   2485  N   ASP   306      22.498  46.673  16.612  1.00 31.73          
ATOM   2486  CA  ASP   306      21.872  47.081  15.387  1.00 31.08          
ATOM   2487  C   ASP   306      21.400  48.506  15.651  1.00 31.25          
ATOM   2488  O   ASP   306      20.469  48.740  16.441  1.00 30.87          
ATOM   2489  CB  ASP   306      20.700  46.137  15.085  1.00 32.14          
ATOM   2490  CG  ASP   306      19.917  46.514  13.828  1.00 33.29          
ATOM   2491  OD1 ASP   306      19.849  47.701  13.446  1.00 32.93          
ATOM   2492  OD2 ASP   306      19.315  45.585  13.233  1.00 38.77          
ATOM   2493  N   THR   307      22.060  49.448  14.990  1.00 30.83          
ATOM   2494  CA  THR   307      21.818  50.884  15.191  1.00 30.94          
ATOM   2495  C   THR   307      20.804  51.433  14.179  1.00 30.66          
ATOM   2496  O   THR   307      20.645  52.668  14.034  1.00 30.20          
ATOM   2497  CB  THR   307      23.150  51.681  15.094  1.00 30.69          
ATOM   2498  OG1 THR   307      23.717  51.475  13.800  1.00 31.96          
ATOM   2499  CG2 THR   307      24.155  51.151  16.115  1.00 31.13          
ATOM   2500  N   PHE   308      20.134  50.531  13.461  1.00 30.57          
ATOM   2501  CA  PHE   308      18.966  50.898  12.658  1.00 31.20          
ATOM   2502  C   PHE   308      17.620  50.410  13.258  1.00 30.84          
ATOM   2503  O   PHE   308      16.554  50.961  12.948  1.00 30.22          
ATOM   2504  CB  PHE   308      19.184  50.480  11.184  1.00 33.01          
ATOM   2505  CG  PHE   308      20.333  51.249  10.514  1.00 33.40          
ATOM   2506  CD1 PHE   308      20.069  52.264   9.607  1.00 37.01          
ATOM   2507  CD2 PHE   308      21.658  50.998  10.858  1.00 36.41          
ATOM   2508  CE1 PHE   308      21.127  52.992   9.018  1.00 37.41          
ATOM   2509  CE2 PHE   308      22.714  51.746  10.296  1.00 33.55          
ATOM   2510  CZ  PHE   308      22.443  52.715   9.373  1.00 34.78          
ATOM   2511  N   ARG   309      17.679  49.421  14.146  1.00 30.73          
ATOM   2512  CA  ARG   309      16.471  48.918  14.811  1.00 31.04          
ATOM   2513  C   ARG   309      16.526  49.096  16.336  1.00 31.07          
ATOM   2514  O   ARG   309      15.624  48.636  17.027  1.00 31.82          
ATOM   2515  CB  ARG   309      16.176  47.439  14.437  1.00 30.41          
ATOM   2516  CG  ARG   309      15.894  47.213  12.963  1.00 30.28          
ATOM   2517  CD  ARG   309      15.500  45.774  12.651  1.00 30.65          
ATOM   2518  NE  ARG   309      16.563  44.814  12.900  1.00 36.40          
ATOM   2519  CZ  ARG   309      16.362  43.498  12.918  1.00 37.76          
ATOM   2520  NH1 ARG   309      15.137  43.012  12.715  1.00 38.46          
ATOM   2521  NH2 ARG   309      17.371  42.683  13.131  1.00 36.46          
ATOM   2522  N   GLY   310      17.583  49.738  16.849  1.00 31.70          
ATOM   2523  CA  GLY   310      17.680  50.149  18.276  1.00 31.86          
ATOM   2524  C   GLY   310      17.672  49.040  19.330  1.00 32.16          
ATOM   2525  O   GLY   310      17.018  49.156  20.372  1.00 32.50          
ATOM   2526  N   PHE   311      18.452  48.004  19.084  1.00 33.29          
ATOM   2527  CA  PHE   311      18.520  46.873  19.973  1.00 33.94          
ATOM   2528  C   PHE   311      19.894  46.231  19.916  1.00 34.91          
ATOM   2529  O   PHE   311      20.715  46.518  19.033  1.00 34.50          
ATOM   2530  CB  PHE   311      17.359  45.893  19.729  1.00 33.61          
ATOM   2531  CG  PHE   311      17.607  44.869  18.649  1.00 34.55          
ATOM   2532  CD1 PHE   311      17.686  43.528  18.981  1.00 34.85          
ATOM   2533  CD2 PHE   311      17.708  45.228  17.298  1.00 34.67          
ATOM   2534  CE1 PHE   311      17.901  42.549  18.000  1.00 34.15          
ATOM   2535  CE2 PHE   311      17.929  44.253  16.306  1.00 35.98          
ATOM   2536  CZ  PHE   311      18.032  42.919  16.658  1.00 35.13          
ATOM   2537  N   MET   312      20.173  45.389  20.890  1.00 35.41          
ATOM   2538  CA  MET   312      21.467  44.780  21.157  1.00 39.32          
ATOM   2539  C   MET   312      21.138  43.364  21.573  1.00 36.07          
ATOM   2540  O   MET   312      20.174  43.193  22.239  1.00 34.55          
ATOM   2541  CB  MET   312      22.064  45.493  22.368  1.00 38.86          
ATOM   2542  CG  MET   312      23.525  45.539  22.538  1.00 41.31          
ATOM   2543  SD  MET   312      24.257  44.843  24.133  0.70 53.02          
ATOM   2544  CE  MET   312      23.316  43.331  24.232  1.00 24.82          
ATOM   2545  N   THR   313      21.947  42.375  21.195  1.00 35.51          
ATOM   2546  CA  THR   313      21.702  40.979  21.585  1.00 34.94          
ATOM   2547  C   THR   313      22.963  40.378  22.184  1.00 34.75          
ATOM   2548  O   THR   313      24.096  40.819  21.869  1.00 34.47          
ATOM   2549  CB  THR   313      21.304  40.093  20.393  1.00 36.09          
ATOM   2550  OG1 THR   313      22.412  39.983  19.507  1.00 36.54          
ATOM   2551  CG2 THR   313      20.109  40.648  19.634  1.00 33.61          
ATOM   2552  N   VAL   314      22.753  39.432  23.089  1.00 31.84          
ATOM   2553  CA  VAL   314      23.785  38.629  23.629  1.00 31.93          
ATOM   2554  C   VAL   314      23.393  37.228  23.207  1.00 31.89          
ATOM   2555  O   VAL   314      22.230  36.830  23.373  1.00 32.02          
ATOM   2556  CB  VAL   314      23.854  38.735  25.184  1.00 31.63          
ATOM   2557  CG1 VAL   314      24.768  37.624  25.793  1.00 31.06          
ATOM   2558  CG2 VAL   314      24.385  40.102  25.610  1.00 31.13          
ATOM   2559  N   GLN   315      24.351  36.493  22.647  1.00 32.18          
ATOM   2560  CA  GLN   315      24.130  35.118  22.231  1.00 32.65          
ATOM   2561  C   GLN   315      25.139  34.207  22.929  1.00 32.09          
ATOM   2562  O   GLN   315      26.333  34.510  22.920  1.00 32.71          
ATOM   2563  CB  GLN   315      24.332  35.018  20.718  1.00 33.10          
ATOM   2564  CG  GLN   315      23.314  35.818  19.903  1.00 37.89          
ATOM   2565  CD  GLN   315      23.595  35.682  18.426  1.00 43.11          
ATOM   2566  OE1 GLN   315      23.757  34.565  17.896  1.00 42.64          
ATOM   2567  NE2 GLN   315      23.694  36.817  17.755  1.00 43.98          
ATOM   2568  N   THR   316      24.662  33.109  23.527  1.00 31.72          
ATOM   2569  CA  THR   316      25.519  32.128  24.190  1.00 30.94          
ATOM   2570  C   THR   316      25.181  30.695  23.746  1.00 30.67          
ATOM   2571  O   THR   316      24.041  30.409  23.368  1.00 30.15          
ATOM   2572  CB  THR   316      25.416  32.236  25.756  1.00 30.83          
ATOM   2573  OG1 THR   316      24.156  31.738  26.212  1.00 32.85          
ATOM   2574  CG2 THR   316      25.548  33.728  26.240  1.00 31.85          
ATOM   2575  N   GLY   317      26.185  29.825  23.782  1.00 30.22          
ATOM   2576  CA  GLY   317      25.999  28.360  23.761  1.00 29.15          
ATOM   2577  C   GLY   317      26.397  27.852  25.133  1.00 30.13          
ATOM   2578  O   GLY   317      27.483  28.219  25.675  1.00 29.48          
ATOM   2579  N   ILE   318      25.533  27.025  25.720  1.00 29.95          
ATOM   2580  CA  ILE   318      25.703  26.586  27.114  1.00 30.20          
ATOM   2581  C   ILE   318      25.265  25.146  27.258  1.00 31.14          
ATOM   2582  O   ILE   318      24.668  24.591  26.325  1.00 29.81          
ATOM   2583  CB  ILE   318      24.895  27.473  28.135  1.00 30.31          
ATOM   2584  CG1 ILE   318      23.382  27.309  27.951  1.00 31.64          
ATOM   2585  CG2 ILE   318      25.306  28.999  28.031  1.00 29.36          
ATOM   2586  CD  ILE   318      22.531  27.939  29.082  1.00 30.78          
ATOM   2587  N   ASP   319      25.605  24.539  28.399  1.00 30.58          
ATOM   2588  CA  ASP   319      24.901  23.366  28.861  1.00 32.30          
ATOM   2589  C   ASP   319      23.610  23.895  29.483  1.00 32.32          
ATOM   2590  O   ASP   319      23.657  24.767  30.367  1.00 31.91          
ATOM   2591  CB  ASP   319      25.725  22.597  29.899  1.00 32.21          
ATOM   2592  CG  ASP   319      26.981  21.941  29.306  1.00 35.76          
ATOM   2593  OD1 ASP   319      27.084  21.761  28.064  1.00 38.42          
ATOM   2594  OD2 ASP   319      27.869  21.585  30.103  1.00 40.67          
ATOM   2595  N   GLY   320      22.473  23.339  29.051  1.00 31.91          
ATOM   2596  CA  GLY   320      21.142  23.914  29.357  1.00 32.35          
ATOM   2597  C   GLY   320      20.896  24.019  30.856  1.00 32.23          
ATOM   2598  O   GLY   320      20.193  24.916  31.300  1.00 32.39          
ATOM   2599  N   LYS   321      21.499  23.117  31.631  1.00 32.92          
ATOM   2600  CA  LYS   321      21.373  23.122  33.112  1.00 34.02          
ATOM   2601  C   LYS   321      21.857  24.422  33.790  1.00 34.05          
ATOM   2602  O   LYS   321      21.448  24.728  34.917  1.00 34.39          
ATOM   2603  CB  LYS   321      22.039  21.884  33.745  1.00 33.48          
ATOM   2604  CG  LYS   321      23.559  21.949  33.855  1.00 34.39          
ATOM   2605  CD  LYS   321      24.187  20.780  34.672  1.00 37.03          
ATOM   2606  CE  LYS   321      24.018  20.932  36.215  1.00 41.46          
ATOM   2607  NZ  LYS   321      24.519  19.712  37.019  1.00 41.65          
ATOM   2608  N   ASN   322      22.679  25.202  33.085  1.00 33.91          
ATOM   2609  CA  ASN   322      23.294  26.418  33.626  1.00 33.15          
ATOM   2610  C   ASN   322      22.561  27.718  33.231  1.00 32.94          
ATOM   2611  O   ASN   322      23.086  28.820  33.438  1.00 31.92          
ATOM   2612  CB  ASN   322      24.778  26.480  33.209  1.00 33.23          
ATOM   2613  CG  ASN   322      25.627  25.349  33.808  1.00 35.94          
ATOM   2614  OD1 ASN   322      25.501  25.025  34.987  1.00 40.12          
ATOM   2615  ND2 ASN   322      26.529  24.785  33.010  1.00 34.61          
ATOM   2616  N   ARG   323      21.346  27.586  32.673  1.00 32.62          
ATOM   2617  CA  ARG   323      20.608  28.732  32.138  1.00 32.91          
ATOM   2618  C   ARG   323      20.527  29.896  33.128  1.00 32.90          
ATOM   2619  O   ARG   323      20.922  31.033  32.809  1.00 31.69          
ATOM   2620  CB  ARG   323      19.203  28.312  31.704  1.00 32.88          
ATOM   2621  CG  ARG   323      18.253  29.474  31.375  1.00 33.14          
ATOM   2622  CD  ARG   323      16.750  29.103  31.556  1.00 34.61          
ATOM   2623  NE  ARG   323      15.873  30.077  30.877  1.00 38.29          
ATOM   2624  CZ  ARG   323      15.393  31.195  31.426  1.00 42.36          
ATOM   2625  NH1 ARG   323      15.680  31.507  32.690  1.00 43.62          
ATOM   2626  NH2 ARG   323      14.620  32.014  30.710  1.00 40.09          
ATOM   2627  N   ASN   324      20.040  29.606  34.337  1.00 33.01          
ATOM   2628  CA  ASN   324      19.810  30.665  35.335  1.00 33.77          
ATOM   2629  C   ASN   324      21.114  31.250  35.826  1.00 33.17          
ATOM   2630  O   ASN   324      21.233  32.464  35.970  1.00 32.30          
ATOM   2631  CB  ASN   324      18.923  30.164  36.483  1.00 34.86          
ATOM   2632  CG  ASN   324      17.533  29.743  35.996  1.00 39.18          
ATOM   2633  OD1 ASN   324      16.915  30.428  35.185  1.00 43.94          
ATOM   2634  ND2 ASN   324      17.054  28.589  36.467  1.00 45.21          
ATOM   2635  N   GLN   325      22.115  30.409  36.052  1.00 32.84          
ATOM   2636  CA  GLN   325      23.424  30.937  36.453  1.00 33.74          
ATOM   2637  C   GLN   325      24.085  31.800  35.370  1.00 32.81          
ATOM   2638  O   GLN   325      24.700  32.830  35.680  1.00 32.69          
ATOM   2639  CB  GLN   325      24.368  29.822  36.874  1.00 33.81          
ATOM   2640  CG  GLN   325      25.598  30.344  37.559  1.00 39.16          
ATOM   2641  CD  GLN   325      26.407  29.254  38.190  1.00 43.44          
ATOM   2642  OE1 GLN   325      25.977  28.089  38.253  1.00 44.69          
ATOM   2643  NE2 GLN   325      27.611  29.614  38.661  1.00 46.42          
ATOM   2644  N   VAL   326      23.969  31.395  34.106  1.00 31.24          
ATOM   2645  CA  VAL   326      24.473  32.222  33.023  1.00 29.78          
ATOM   2646  C   VAL   326      23.711  33.568  32.974  1.00 30.02          
ATOM   2647  O   VAL   326      24.320  34.612  32.781  1.00 29.91          
ATOM   2648  CB  VAL   326      24.401  31.509  31.651  1.00 30.22          
ATOM   2649  CG1 VAL   326      24.769  32.487  30.496  1.00 30.54          
ATOM   2650  CG2 VAL   326      25.337  30.264  31.604  1.00 28.88          
ATOM   2651  N   LEU   327      22.396  33.566  33.166  1.00 29.60          
ATOM   2652  CA  LEU   327      21.679  34.847  33.139  1.00 29.79          
ATOM   2653  C   LEU   327      22.147  35.770  34.257  1.00 30.12          
ATOM   2654  O   LEU   327      22.295  36.969  34.045  1.00 29.16          
ATOM   2655  CB  LEU   327      20.180  34.631  33.236  1.00 29.61          
ATOM   2656  CG  LEU   327      19.479  33.939  32.080  1.00 29.14          
ATOM   2657  CD1 LEU   327      18.030  33.709  32.511  1.00 28.36          
ATOM   2658  CD2 LEU   327      19.576  34.847  30.834  1.00 31.09          
ATOM   2659  N   ARG   328      22.383  35.207  35.451  1.00 31.44          
ATOM   2660  CA  ARG   328      22.890  36.009  36.596  1.00 32.62          
ATOM   2661  C   ARG   328      24.303  36.568  36.314  1.00 31.40          
ATOM   2662  O   ARG   328      24.583  37.733  36.604  1.00 29.83          
ATOM   2663  CB  ARG   328      22.858  35.207  37.910  1.00 32.78          
ATOM   2664  CG  ARG   328      21.411  34.836  38.358  1.00 35.50          
ATOM   2665  CD  ARG   328      21.359  34.135  39.760  1.00 36.84          
ATOM   2666  NE  ARG   328      21.791  32.728  39.751  1.00 44.49          
ATOM   2667  CZ  ARG   328      20.989  31.660  39.623  1.00 47.31          
ATOM   2668  NH1 ARG   328      19.670  31.791  39.471  1.00 50.54          
ATOM   2669  NH2 ARG   328      21.514  30.439  39.633  1.00 46.94          
ATOM   2670  N   LEU   329      25.168  35.748  35.730  1.00 30.80          
ATOM   2671  CA  LEU   329      26.526  36.200  35.402  1.00 31.49          
ATOM   2672  C   LEU   329      26.518  37.360  34.394  1.00 31.22          
ATOM   2673  O   LEU   329      27.257  38.315  34.558  1.00 31.51          
ATOM   2674  CB  LEU   329      27.374  35.044  34.856  1.00 32.22          
ATOM   2675  CG  LEU   329      27.760  33.921  35.835  1.00 34.74          
ATOM   2676  CD1 LEU   329      28.402  32.704  35.124  1.00 36.87          
ATOM   2677  CD2 LEU   329      28.676  34.438  36.947  1.00 38.68          
ATOM   2678  N   ILE   330      25.721  37.230  33.336  1.00 30.66          
ATOM   2679  CA  ILE   330      25.561  38.288  32.316  1.00 31.02          
ATOM   2680  C   ILE   330      25.053  39.594  32.943  1.00 30.77          
ATOM   2681  O   ILE   330      25.591  40.692  32.663  1.00 30.97          
ATOM   2682  CB  ILE   330      24.561  37.860  31.228  1.00 30.08          
ATOM   2683  CG1 ILE   330      25.149  36.734  30.368  1.00 31.35          
ATOM   2684  CG2 ILE   330      24.152  39.081  30.336  1.00 32.58          
ATOM   2685  CD  ILE   330      24.071  36.034  29.483  1.00 30.60          
ATOM   2686  N   SER   331      24.028  39.469  33.789  1.00 29.97          
ATOM   2687  CA  SER   331      23.481  40.624  34.520  1.00 30.76          
ATOM   2688  C   SER   331      24.537  41.301  35.400  1.00 30.53          
ATOM   2689  O   SER   331      24.639  42.550  35.465  1.00 29.83          
ATOM   2690  CB  SER   331      22.310  40.174  35.407  1.00 31.20          
ATOM   2691  OG  SER   331      21.919  41.242  36.265  1.00 34.05          
ATOM   2692  N   THR   332      25.347  40.476  36.062  1.00 30.19          
ATOM   2693  CA  THR   332      26.445  41.008  36.891  1.00 30.70          
ATOM   2694  C   THR   332      27.439  41.844  36.100  1.00 30.39          
ATOM   2695  O   THR   332      27.823  42.944  36.537  1.00 30.40          
ATOM   2696  CB  THR   332      27.160  39.880  37.630  1.00 29.85          
ATOM   2697  OG1 THR   332      26.208  39.298  38.523  1.00 29.43          
ATOM   2698  CG2 THR   332      28.337  40.430  38.451  1.00 31.98          
ATOM   2699  N   GLU   333      27.851  41.330  34.944  1.00 30.22          
ATOM   2700  CA  GLU   333      28.754  42.091  34.086  1.00 29.73          
ATOM   2701  C   GLU   333      28.122  43.378  33.585  1.00 30.64          
ATOM   2702  O   GLU   333      28.790  44.391  33.500  1.00 30.39          
ATOM   2703  CB  GLU   333      29.284  41.246  32.923  1.00 30.35          
ATOM   2704  CG  GLU   333      30.194  40.071  33.393  1.00 30.45          
ATOM   2705  CD  GLU   333      31.264  40.517  34.388  1.00 33.24          
ATOM   2706  OE1 GLU   333      31.781  41.650  34.272  1.00 37.26          
ATOM   2707  OE2 GLU   333      31.603  39.744  35.299  1.00 36.49          
ATOM   2708  N   LEU   334      26.832  43.350  33.270  1.00 30.62          
ATOM   2709  CA  LEU   334      26.163  44.579  32.863  1.00 31.40          
ATOM   2710  C   LEU   334      26.138  45.619  33.997  1.00 31.47          
ATOM   2711  O   LEU   334      26.418  46.805  33.787  1.00 31.07          
ATOM   2712  CB  LEU   334      24.759  44.281  32.316  1.00 31.45          
ATOM   2713  CG  LEU   334      23.885  45.483  31.920  1.00 33.17          
ATOM   2714  CD1 LEU   334      24.650  46.392  30.890  1.00 32.63          
ATOM   2715  CD2 LEU   334      22.559  44.945  31.314  1.00 32.20          
ATOM   2716  N   GLU   335      25.819  45.173  35.204  1.00 31.33          
ATOM   2717  CA  GLU   335      25.873  46.044  36.354  1.00 31.54          
ATOM   2718  C   GLU   335      27.276  46.627  36.574  1.00 30.86          
ATOM   2719  O   GLU   335      27.419  47.811  36.923  1.00 29.06          
ATOM   2720  CB  GLU   335      25.390  45.304  37.594  1.00 31.94          
ATOM   2721  CG  GLU   335      23.863  45.058  37.554  1.00 38.25          
ATOM   2722  CD  GLU   335      23.064  46.365  37.284  1.00 43.79          
ATOM   2723  OE1 GLU   335      23.328  47.385  37.972  1.00 44.19          
ATOM   2724  OE2 GLU   335      22.191  46.354  36.368  1.00 48.16          
ATOM   2725  N   ASN   336      28.302  45.805  36.356  1.00 29.30          
ATOM   2726  CA  ASN   336      29.664  46.275  36.508  1.00 29.91          
ATOM   2727  C   ASN   336      29.979  47.418  35.567  1.00 30.02          
ATOM   2728  O   ASN   336      30.621  48.389  35.967  1.00 30.98          
ATOM   2729  CB  ASN   336      30.664  45.134  36.310  1.00 30.37          
ATOM   2730  CG  ASN   336      30.732  44.223  37.519  1.00 30.93          
ATOM   2731  OD1 ASN   336      30.304  44.601  38.623  1.00 29.65          
ATOM   2732  ND2 ASN   336      31.311  43.031  37.335  1.00 31.78          
ATOM   2733  N   ILE   337      29.548  47.295  34.311  1.00 29.66          
ATOM   2734  CA  ILE   337      29.694  48.413  33.367  1.00 28.75          
ATOM   2735  C   ILE   337      28.866  49.611  33.858  1.00 29.46          
ATOM   2736  O   ILE   337      29.359  50.730  33.883  1.00 29.59          
ATOM   2737  CB  ILE   337      29.284  48.017  31.932  1.00 28.33          
ATOM   2738  CG1 ILE   337      30.210  46.862  31.416  1.00 27.67          
ATOM   2739  CG2 ILE   337      29.303  49.253  31.023  1.00 29.00          
ATOM   2740  CD  ILE   337      29.710  46.212  30.099  1.00 27.18          
ATOM   2741  N   ARG   338      27.603  49.393  34.236  1.00 31.09          
ATOM   2742  CA  ARG   338      26.802  50.514  34.777  1.00 31.66          
ATOM   2743  C   ARG   338      27.544  51.242  35.910  1.00 31.42          
ATOM   2744  O   ARG   338      27.515  52.487  36.001  1.00 31.05          
ATOM   2745  CB  ARG   338      25.427  50.036  35.265  1.00 32.32          
ATOM   2746  CG  ARG   338      24.533  49.618  34.120  1.00 33.13          
ATOM   2747  CD  ARG   338      23.201  48.938  34.554  1.00 34.56          
ATOM   2748  NE  ARG   338      22.282  48.973  33.423  1.00 38.09          
ATOM   2749  CZ  ARG   338      21.147  48.287  33.319  1.00 41.91          
ATOM   2750  NH1 ARG   338      20.779  47.419  34.269  1.00 44.99          
ATOM   2751  NH2 ARG   338      20.388  48.463  32.238  1.00 39.42          
ATOM   2752  N   LEU   339      28.211  50.467  36.764  1.00 30.16          
ATOM   2753  CA  LEU   339      28.960  51.025  37.916  1.00 30.26          
ATOM   2754  C   LEU   339      30.280  51.689  37.516  1.00 30.00          
ATOM   2755  O   LEU   339      30.905  52.353  38.331  1.00 29.06          
ATOM   2756  CB  LEU   339      29.217  49.939  38.975  1.00 29.82          
ATOM   2757  CG  LEU   339      27.972  49.438  39.737  1.00 32.33          
ATOM   2758  CD1 LEU   339      28.237  48.059  40.386  1.00 33.09          
ATOM   2759  CD2 LEU   339      27.545  50.455  40.799  1.00 33.70          
ATOM   2760  N   GLY   340      30.686  51.517  36.258  1.00 30.27          
ATOM   2761  CA  GLY   340      31.934  52.133  35.783  1.00 29.90          
ATOM   2762  C   GLY   340      33.134  51.317  36.196  1.00 30.61          
ATOM   2763  O   GLY   340      34.260  51.824  36.240  1.00 29.75          
ATOM   2764  N   LYS   341      32.903  50.029  36.467  1.00 30.80          
ATOM   2765  CA  LYS   341      33.971  49.125  36.851  1.00 31.72          
ATOM   2766  C   LYS   341      34.667  48.644  35.568  1.00 33.48          
ATOM   2767  O   LYS   341      34.503  47.485  35.136  1.00 32.44          
ATOM   2768  CB  LYS   341      33.437  47.969  37.697  1.00 30.74          
ATOM   2769  CG  LYS   341      33.014  48.404  39.129  1.00 31.56          
ATOM   2770  CD  LYS   341      32.136  47.373  39.852  1.00 30.66          
ATOM   2771  CE  LYS   341      32.960  46.158  40.320  1.00 33.45          
ATOM   2772  NZ  LYS   341      32.055  45.042  40.721  1.00 30.44          
ATOM   2773  N   ILE   342      35.425  49.565  34.957  1.00 34.70          
ATOM   2774  CA  ILE   342      35.991  49.364  33.606  1.00 35.83          
ATOM   2775  C   ILE   342      37.469  49.727  33.611  1.00 37.13          
ATOM   2776  O   ILE   342      37.845  50.846  33.963  1.00 36.47          
ATOM   2777  CB  ILE   342      35.244  50.225  32.544  1.00 35.96          
ATOM   2778  CG1 ILE   342      33.751  49.900  32.555  1.00 35.75          
ATOM   2779  CG2 ILE   342      35.788  49.972  31.151  1.00 35.46          
ATOM   2780  CD  ILE   342      32.887  50.876  31.766  1.00 36.05          
ATOM   2781  N   ARG   343      38.307  48.769  33.241  1.00 37.69          
ATOM   2782  CA  ARG   343      39.743  48.971  33.295  1.00 40.09          
ATOM   2783  C   ARG   343      40.193  49.744  32.074  1.00 40.17          
ATOM   2784  O   ARG   343      39.570  49.647  31.018  1.00 39.45          
ATOM   2785  CB  ARG   343      40.453  47.619  33.310  1.00 40.58          
ATOM   2786  CG  ARG   343      40.098  46.748  34.517  1.00 44.32          
ATOM   2787  CD  ARG   343      40.574  45.301  34.328  1.00 51.40          
ATOM   2788  NE  ARG   343      41.870  45.188  33.633  1.00 57.20          
ATOM   2789  CZ  ARG   343      43.044  45.662  34.072  1.00 59.62          
ATOM   2790  NH1 ARG   343      44.139  45.482  33.331  1.00 59.52          
ATOM   2791  NH2 ARG   343      43.136  46.328  35.229  1.00 60.07          
ATOM   2792  N   GLU   344      41.302  50.465  32.207  1.00 40.86          
ATOM   2793  CA  GLU   344      41.858  51.195  31.076  1.00 41.98          
ATOM   2794  C   GLU   344      42.127  50.311  29.874  1.00 41.27          
ATOM   2795  O   GLU   344      41.867  50.706  28.755  1.00 40.42          
ATOM   2796  CB  GLU   344      43.112  51.961  31.474  1.00 42.77          
ATOM   2797  CG  GLU   344      42.796  53.356  32.038  1.00 48.73          
ATOM   2798  CD  GLU   344      41.671  54.091  31.272  1.00 54.97          
ATOM   2799  OE1 GLU   344      41.736  54.150  30.007  1.00 56.83          
ATOM   2800  OE2 GLU   344      40.733  54.602  31.949  1.00 55.47          
ATOM   2801  N   LEU   345      42.613  49.102  30.107  1.00 41.04          
ATOM   2802  CA  LEU   345      42.950  48.224  29.002  1.00 41.91          
ATOM   2803  C   LEU   345      41.686  47.755  28.265  1.00 41.36          
ATOM   2804  O   LEU   345      41.682  47.680  27.044  1.00 41.90          
ATOM   2805  CB  LEU   345      43.815  47.043  29.475  1.00 41.55          
ATOM   2806  CG  LEU   345      44.298  46.113  28.353  1.00 43.13          
ATOM   2807  CD1 LEU   345      45.337  46.809  27.427  1.00 44.01          
ATOM   2808  CD2 LEU   345      44.855  44.785  28.909  1.00 43.67          
ATOM   2809  N   GLU   346      40.614  47.451  29.001  1.00 40.84          
ATOM   2810  CA  GLU   346      39.322  47.153  28.367  1.00 40.31          
ATOM   2811  C   GLU   346      38.918  48.210  27.316  1.00 39.49          
ATOM   2812  O   GLU   346      38.604  47.868  26.178  1.00 38.96          
ATOM   2813  CB  GLU   346      38.212  47.004  29.422  1.00 40.10          
ATOM   2814  CG  GLU   346      38.337  45.725  30.233  1.00 42.46          
ATOM   2815  CD  GLU   346      37.284  45.628  31.300  1.00 43.24          
ATOM   2816  OE1 GLU   346      37.154  46.566  32.104  1.00 43.28          
ATOM   2817  OE2 GLU   346      36.607  44.598  31.356  1.00 43.47          
ATOM   2818  N   ILE   347      38.941  49.482  27.697  1.00 38.97          
ATOM   2819  CA  ILE   347      38.505  50.568  26.790  1.00 38.58          
ATOM   2820  C   ILE   347      39.493  50.753  25.652  1.00 37.77          
ATOM   2821  O   ILE   347      39.073  50.904  24.500  1.00 37.20          
ATOM   2822  CB  ILE   347      38.364  51.925  27.509  1.00 39.34          
ATOM   2823  CG1 ILE   347      37.501  51.807  28.742  1.00 41.17          
ATOM   2824  CG2 ILE   347      37.693  52.979  26.612  1.00 40.21          
ATOM   2825  CD  ILE   347      37.982  52.731  29.803  1.00 44.37          
ATOM   2826  N   GLU   348      40.787  50.750  25.982  1.00 36.01          
ATOM   2827  CA  GLU   348      41.857  51.014  25.021  1.00 36.74          
ATOM   2828  C   GLU   348      41.862  49.922  23.946  1.00 35.70          
ATOM   2829  O   GLU   348      41.921  50.219  22.748  1.00 34.80          
ATOM   2830  CB  GLU   348      43.244  51.047  25.715  1.00 36.10          
ATOM   2831  CG  GLU   348      43.534  52.290  26.605  1.00 40.23          
ATOM   2832  CD  GLU   348      44.943  52.253  27.296  1.00 41.60          
ATOM   2833  OE1 GLU   348      45.604  51.167  27.345  1.00 48.44          
ATOM   2834  OE2 GLU   348      45.392  53.326  27.780  1.00 48.95          
ATOM   2835  N   GLN   349      41.786  48.659  24.375  1.00 34.58          
ATOM   2836  CA  GLN   349      41.703  47.556  23.422  1.00 35.94          
ATOM   2837  C   GLN   349      40.456  47.613  22.553  1.00 34.19          
ATOM   2838  O   GLN   349      40.520  47.338  21.371  1.00 34.54          
ATOM   2839  CB  GLN   349      41.752  46.199  24.128  1.00 37.07          
ATOM   2840  CG  GLN   349      43.139  45.754  24.476  1.00 41.40          
ATOM   2841  CD  GLN   349      43.155  44.263  24.739  1.00 48.58          
ATOM   2842  OE1 GLN   349      43.000  43.837  25.883  1.00 51.94          
ATOM   2843  NE2 GLN   349      43.274  43.456  23.672  1.00 49.73          
ATOM   2844  N   THR   350      39.324  47.985  23.144  1.00 34.01          
ATOM   2845  CA  THR   350      38.078  48.135  22.376  1.00 32.74          
ATOM   2846  C   THR   350      38.217  49.234  21.318  1.00 32.47          
ATOM   2847  O   THR   350      37.881  49.007  20.159  1.00 32.29          
ATOM   2848  CB  THR   350      36.889  48.406  23.304  1.00 33.27          
ATOM   2849  OG1 THR   350      36.772  47.300  24.212  1.00 33.51          
ATOM   2850  CG2 THR   350      35.594  48.605  22.513  1.00 30.03          
ATOM   2851  N   LYS   351      38.731  50.406  21.708  1.00 31.53          
ATOM   2852  CA  LYS   351      38.927  51.508  20.744  1.00 31.22          
ATOM   2853  C   LYS   351      39.884  51.115  19.586  1.00 31.45          
ATOM   2854  O   LYS   351      39.581  51.355  18.415  1.00 30.60          
ATOM   2855  CB  LYS   351      39.380  52.791  21.437  1.00 30.55          
ATOM   2856  CG  LYS   351      38.345  53.387  22.434  1.00 29.42          
ATOM   2857  CD  LYS   351      38.889  54.632  23.119  1.00 30.37          
ATOM   2858  CE  LYS   351      37.773  55.347  23.876  1.00 28.57          
ATOM   2859  NZ  LYS   351      38.247  56.558  24.614  1.00 30.03          
ATOM   2860  N   ALA   352      41.002  50.462  19.920  1.00 32.75          
ATOM   2861  CA  ALA   352      41.981  50.009  18.912  1.00 32.90          
ATOM   2862  C   ALA   352      41.334  49.081  17.871  1.00 33.81          
ATOM   2863  O   ALA   352      41.494  49.273  16.655  1.00 32.32          
ATOM   2864  CB  ALA   352      43.178  49.294  19.610  1.00 33.93          
ATOM   2865  N   MET   353      40.557  48.111  18.351  1.00 34.17          
ATOM   2866  CA  MET   353      39.948  47.128  17.453  1.00 37.32          
ATOM   2867  C   MET   353      38.835  47.752  16.611  1.00 34.98          
ATOM   2868  O   MET   353      38.705  47.437  15.446  1.00 34.03          
ATOM   2869  CB  MET   353      39.462  45.885  18.220  1.00 36.13          
ATOM   2870  CG  MET   353      40.649  45.005  18.672  1.00 41.63          
ATOM   2871  SD  MET   353      40.097  43.448  19.671  0.80 46.34          
ATOM   2872  CE  MET   353      39.527  42.352  18.152  1.00 45.87          
ATOM   2873  N   LEU   354      38.055  48.655  17.199  1.00 34.24          
ATOM   2874  CA  LEU   354      37.061  49.380  16.407  1.00 33.83          
ATOM   2875  C   LEU   354      37.742  50.221  15.322  1.00 33.80          
ATOM   2876  O   LEU   354      37.346  50.153  14.151  1.00 33.96          
ATOM   2877  CB  LEU   354      36.146  50.250  17.289  1.00 32.30          
ATOM   2878  CG  LEU   354      35.121  49.479  18.130  1.00 32.81          
ATOM   2879  CD1 LEU   354      34.514  50.374  19.212  1.00 31.93          
ATOM   2880  CD2 LEU   354      33.999  48.833  17.286  1.00 31.66          
ATOM   2881  N   LYS   355      38.773  50.984  15.694  1.00 33.86          
ATOM   2882  CA  LYS   355      39.501  51.795  14.709  1.00 35.35          
ATOM   2883  C   LYS   355      40.116  50.938  13.630  1.00 35.95          
ATOM   2884  O   LYS   355      39.974  51.247  12.461  1.00 36.69          
ATOM   2885  CB  LYS   355      40.595  52.656  15.357  1.00 34.89          
ATOM   2886  CG  LYS   355      40.023  53.827  16.196  1.00 35.54          
ATOM   2887  CD  LYS   355      41.135  54.685  16.780  1.00 36.49          
ATOM   2888  CE  LYS   355      41.934  53.923  17.828  1.00 35.14          
ATOM   2889  NZ  LYS   355      42.797  54.919  18.514  1.00 35.20          
ATOM   2890  N   ASN   356      40.791  49.860  14.017  1.00 37.35          
ATOM   2891  CA  ASN   356      41.435  48.986  13.030  1.00 39.10          
ATOM   2892  C   ASN   356      40.431  48.455  11.994  1.00 38.68          
ATOM   2893  O   ASN   356      40.714  48.431  10.785  1.00 37.79          
ATOM   2894  CB  ASN   356      42.172  47.809  13.706  1.00 40.15          
ATOM   2895  CG  ASN   356      43.451  48.246  14.461  1.00 43.68          
ATOM   2896  OD1 ASN   356      44.011  49.329  14.226  1.00 46.00          
ATOM   2897  ND2 ASN   356      43.913  47.384  15.383  1.00 47.77          
ATOM   2898  N   GLN   357      39.268  48.024  12.474  1.00 38.78          
ATOM   2899  CA  GLN   357      38.234  47.499  11.583  1.00 39.30          
ATOM   2900  C   GLN   357      37.705  48.553  10.615  1.00 38.96          
ATOM   2901  O   GLN   357      37.661  48.317   9.422  1.00 38.74          
ATOM   2902  CB  GLN   357      37.121  46.807  12.375  1.00 39.47          
ATOM   2903  CG  GLN   357      37.662  45.571  13.057  1.00 43.75          
ATOM   2904  CD  GLN   357      36.655  44.810  13.903  1.00 49.96          
ATOM   2905  OE1 GLN   357      35.504  45.239  14.096  1.00 53.63          
ATOM   2906  NE2 GLN   357      37.100  43.662  14.434  1.00 52.16          
ATOM   2907  N   TYR   358      37.344  49.725  11.122  1.00 38.71          
ATOM   2908  CA  TYR   358      36.922  50.827  10.281  1.00 39.54          
ATOM   2909  C   TYR   358      37.969  51.180   9.224  1.00 40.55          
ATOM   2910  O   TYR   358      37.651  51.257   8.034  1.00 41.19          
ATOM   2911  CB  TYR   358      36.656  52.054  11.155  1.00 38.59          
ATOM   2912  CG  TYR   358      36.152  53.275  10.428  1.00 38.06          
ATOM   2913  CD1 TYR   358      34.794  53.439  10.142  1.00 38.41          
ATOM   2914  CD2 TYR   358      37.026  54.297  10.079  1.00 36.46          
ATOM   2915  CE1 TYR   358      34.340  54.595   9.500  1.00 37.60          
ATOM   2916  CE2 TYR   358      36.592  55.429   9.463  1.00 38.52          
ATOM   2917  CZ  TYR   358      35.253  55.581   9.169  1.00 38.54          
ATOM   2918  OH  TYR   358      34.864  56.734   8.525  1.00 37.13          
ATOM   2919  N   ILE   359      39.210  51.410   9.656  1.00 41.40          
ATOM   2920  CA  ILE   359      40.283  51.790   8.733  1.00 42.36          
ATOM   2921  C   ILE   359      40.450  50.772   7.609  1.00 43.90          
ATOM   2922  O   ILE   359      40.555  51.137   6.428  1.00 44.13          
ATOM   2923  CB  ILE   359      41.615  52.036   9.481  1.00 42.62          
ATOM   2924  CG1 ILE   359      41.508  53.342  10.305  1.00 41.74          
ATOM   2925  CG2 ILE   359      42.811  52.075   8.503  1.00 41.81          
ATOM   2926  CD  ILE   359      42.646  53.589  11.278  1.00 42.38          
ATOM   2927  N   LEU   360      40.442  49.498   7.974  1.00 45.17          
ATOM   2928  CA  LEU   360      40.538  48.407   7.002  1.00 46.92          
ATOM   2929  C   LEU   360      39.566  48.600   5.825  1.00 47.26          
ATOM   2930  O   LEU   360      39.947  48.440   4.662  1.00 46.98          
ATOM   2931  CB  LEU   360      40.245  47.067   7.691  1.00 46.80          
ATOM   2932  CG  LEU   360      41.191  45.915   7.360  1.00 49.88          
ATOM   2933  CD1 LEU   360      42.212  45.749   8.501  1.00 52.18          
ATOM   2934  CD2 LEU   360      40.439  44.603   7.110  1.00 50.77          
ATOM   2935  N   ALA   361      38.320  48.955   6.135  1.00 48.04          
ATOM   2936  CA  ALA   361      37.281  49.093   5.110  1.00 48.65          
ATOM   2937  C   ALA   361      37.347  50.395   4.295  1.00 49.23          
ATOM   2938  O   ALA   361      36.636  50.548   3.287  1.00 49.01          
ATOM   2939  CB  ALA   361      35.919  48.890   5.718  1.00 48.96          
ATOM   2940  N   LEU   362      38.222  51.317   4.706  1.00 49.85          
ATOM   2941  CA  LEU   362      38.434  52.583   3.980  1.00 50.21          
ATOM   2942  C   LEU   362      38.846  52.370   2.521  1.00 50.40          
ATOM   2943  O   LEU   362      38.596  53.234   1.663  1.00 50.85          
ATOM   2944  CB  LEU   362      39.490  53.466   4.670  1.00 50.26          
ATOM   2945  CG  LEU   362      39.090  54.341   5.865  1.00 50.85          
ATOM   2946  CD1 LEU   362      40.121  55.458   6.081  1.00 51.38          
ATOM   2947  CD2 LEU   362      37.705  54.932   5.682  1.00 51.92          
ATOM   2948  N   ASP   363      39.474  51.226   2.248  1.00 49.76          
ATOM   2949  CA  ASP   363      40.007  50.953   0.925  1.00 49.56          
ATOM   2950  C   ASP   363      38.956  50.379  -0.021  1.00 47.99          
ATOM   2951  O   ASP   363      38.973  50.642  -1.237  1.00 47.85          
ATOM   2952  CB  ASP   363      41.200  50.001   1.026  1.00 50.71          
ATOM   2953  CG  ASP   363      42.488  50.724   1.361  1.00 53.63          
ATOM   2954  OD1 ASP   363      42.433  51.944   1.687  1.00 56.29          
ATOM   2955  OD2 ASP   363      43.557  50.068   1.285  1.00 57.96          
ATOM   2956  N   ASN   364      38.047  49.609   0.557  1.00 45.39          
ATOM   2957  CA  ASN   364      37.131  48.783  -0.198  1.00 43.91          
ATOM   2958  C   ASN   364      36.053  49.548  -1.010  1.00 41.70          
ATOM   2959  O   ASN   364      35.296  50.335  -0.448  1.00 40.61          
ATOM   2960  CB  ASN   364      36.499  47.772   0.761  1.00 44.51          
ATOM   2961  CG  ASN   364      35.693  46.744   0.043  1.00 47.05          
ATOM   2962  OD1 ASN   364      34.508  46.947  -0.226  1.00 48.99          
ATOM   2963  ND2 ASN   364      36.325  45.618  -0.285  1.00 49.97          
ATOM   2964  N   ALA   365      35.988  49.287  -2.319  1.00 39.74          
ATOM   2965  CA  ALA   365      34.994  49.917  -3.209  1.00 38.36          
ATOM   2966  C   ALA   365      33.557  49.560  -2.821  1.00 37.61          
ATOM   2967  O   ALA   365      32.671  50.409  -2.866  1.00 37.22          
ATOM   2968  CB  ALA   365      35.260  49.576  -4.677  1.00 38.36          
ATOM   2969  N   GLY   366      33.323  48.315  -2.413  1.00 36.87          
ATOM   2970  CA  GLY   366      31.998  47.925  -1.904  1.00 35.96          
ATOM   2971  C   GLY   366      31.587  48.696  -0.670  1.00 35.68          
ATOM   2972  O   GLY   366      30.440  49.150  -0.555  1.00 35.84          
ATOM   2973  N   ALA   367      32.521  48.836   0.275  1.00 34.95          
ATOM   2974  CA  ALA   367      32.282  49.589   1.500  1.00 34.53          
ATOM   2975  C   ALA   367      32.018  51.057   1.182  1.00 33.65          
ATOM   2976  O   ALA   367      31.182  51.697   1.810  1.00 33.54          
ATOM   2977  CB  ALA   367      33.497  49.476   2.441  1.00 35.49          
ATOM   2978  N   TRP   368      32.752  51.580   0.219  1.00 33.01          
ATOM   2979  CA  TRP   368      32.600  52.967  -0.193  1.00 33.29          
ATOM   2980  C   TRP   368      31.171  53.179  -0.729  1.00 33.17          
ATOM   2981  O   TRP   368      30.454  54.055  -0.236  1.00 32.71          
ATOM   2982  CB  TRP   368      33.683  53.353  -1.209  1.00 33.87          
ATOM   2983  CG  TRP   368      33.734  54.817  -1.552  1.00 34.63          
ATOM   2984  CD1 TRP   368      32.838  55.782  -1.179  1.00 35.35          
ATOM   2985  CD2 TRP   368      34.707  55.479  -2.378  1.00 35.89          
ATOM   2986  NE1 TRP   368      33.204  57.006  -1.699  1.00 33.98          
ATOM   2987  CE2 TRP   368      34.343  56.847  -2.444  1.00 34.81          
ATOM   2988  CE3 TRP   368      35.857  55.053  -3.066  1.00 35.00          
ATOM   2989  CZ2 TRP   368      35.091  57.793  -3.163  1.00 34.69          
ATOM   2990  CZ3 TRP   368      36.589  55.987  -3.784  1.00 33.70          
ATOM   2991  CH2 TRP   368      36.204  57.342  -3.830  1.00 35.16          
ATOM   2992  N   LEU   369      30.739  52.345  -1.675  1.00 33.00          
ATOM   2993  CA  LEU   369      29.337  52.399  -2.159  1.00 34.24          
ATOM   2994  C   LEU   369      28.285  52.395  -1.045  1.00 33.77          
ATOM   2995  O   LEU   369      27.367  53.204  -1.087  1.00 34.42          
ATOM   2996  CB  LEU   369      29.020  51.312  -3.206  1.00 33.90          
ATOM   2997  CG  LEU   369      29.475  51.494  -4.650  1.00 35.42          
ATOM   2998  CD1 LEU   369      29.245  50.196  -5.444  1.00 37.79          
ATOM   2999  CD2 LEU   369      28.806  52.675  -5.377  1.00 32.76          
ATOM   3000  N   GLU   370      28.438  51.519  -0.049  1.00 33.78          
ATOM   3001  CA  GLU   370      27.538  51.483   1.116  1.00 34.24          
ATOM   3002  C   GLU   370      27.555  52.766   1.958  1.00 34.56          
ATOM   3003  O   GLU   370      26.503  53.211   2.409  1.00 33.68          
ATOM   3004  CB  GLU   370      27.777  50.263   2.023  1.00 33.88          
ATOM   3005  CG  GLU   370      27.543  48.897   1.362  1.00 35.76          
ATOM   3006  CD  GLU   370      26.132  48.750   0.757  1.00 37.17          
ATOM   3007  OE1 GLU   370      25.172  49.376   1.261  1.00 39.69          
ATOM   3008  OE2 GLU   370      25.990  48.025  -0.237  1.00 39.71          
ATOM   3009  N   LYS   371      28.741  53.339   2.193  1.00 35.69          
ATOM   3010  CA  LYS   371      28.845  54.645   2.852  1.00 36.89          
ATOM   3011  C   LYS   371      28.097  55.700   2.040  1.00 35.81          
ATOM   3012  O   LYS   371      27.369  56.506   2.605  1.00 36.14          
ATOM   3013  CB  LYS   371      30.315  55.076   3.042  1.00 37.46          
ATOM   3014  CG  LYS   371      31.075  54.231   4.053  1.00 40.23          
ATOM   3015  CD  LYS   371      32.523  54.722   4.318  1.00 40.33          
ATOM   3016  CE  LYS   371      33.176  53.811   5.377  1.00 43.32          
ATOM   3017  NZ  LYS   371      34.667  53.959   5.473  1.00 48.75          
ATOM   3018  N   GLU   372      28.285  55.694   0.725  1.00 35.25          
ATOM   3019  CA  GLU   372      27.601  56.648  -0.160  1.00 35.80          
ATOM   3020  C   GLU   372      26.082  56.496  -0.074  1.00 35.59          
ATOM   3021  O   GLU   372      25.349  57.485  -0.033  1.00 35.24          
ATOM   3022  CB  GLU   372      28.056  56.489  -1.617  1.00 36.01          
ATOM   3023  CG  GLU   372      29.495  56.924  -1.890  1.00 38.12          
ATOM   3024  CD  GLU   372      29.683  58.440  -1.899  1.00 43.41          
ATOM   3025  OE1 GLU   372      28.679  59.191  -1.851  1.00 42.98          
ATOM   3026  OE2 GLU   372      30.853  58.886  -1.961  1.00 46.57          
ATOM   3027  N   TYR   373      25.612  55.250  -0.032  1.00 35.45          
ATOM   3028  CA  TYR   373      24.189  55.018   0.080  1.00 35.44          
ATOM   3029  C   TYR   373      23.623  55.560   1.391  1.00 36.23          
ATOM   3030  O   TYR   373      22.636  56.307   1.380  1.00 36.19          
ATOM   3031  CB  TYR   373      23.857  53.542  -0.128  1.00 34.58          
ATOM   3032  CG  TYR   373      22.391  53.316  -0.404  1.00 33.23          
ATOM   3033  CD1 TYR   373      21.855  53.581  -1.648  1.00 32.58          
ATOM   3034  CD2 TYR   373      21.539  52.841   0.594  1.00 34.58          
ATOM   3035  CE1 TYR   373      20.498  53.389  -1.912  1.00 34.22          
ATOM   3036  CE2 TYR   373      20.181  52.644   0.346  1.00 35.65          
ATOM   3037  CZ  TYR   373      19.670  52.902  -0.915  1.00 33.23          
ATOM   3038  OH  TYR   373      18.334  52.676  -1.167  1.00 31.77          
ATOM   3039  N   LEU   374      24.253  55.225   2.517  1.00 37.55          
ATOM   3040  CA  LEU   374      23.784  55.736   3.805  1.00 38.74          
ATOM   3041  C   LEU   374      23.768  57.232   3.814  1.00 39.16          
ATOM   3042  O   LEU   374      22.803  57.836   4.267  1.00 39.38          
ATOM   3043  CB  LEU   374      24.618  55.236   4.997  1.00 39.05          
ATOM   3044  CG  LEU   374      24.553  53.735   5.269  1.00 40.45          
ATOM   3045  CD1 LEU   374      25.318  53.413   6.552  1.00 39.78          
ATOM   3046  CD2 LEU   374      23.093  53.237   5.337  1.00 41.15          
ATOM   3047  N   ASN   375      24.856  57.820   3.327  1.00 39.40          
ATOM   3048  CA  ASN   375      25.002  59.258   3.166  1.00 40.20          
ATOM   3049  C   ASN   375      23.872  59.912   2.386  1.00 40.24          
ATOM   3050  O   ASN   375      23.431  61.015   2.716  1.00 39.85          
ATOM   3051  CB  ASN   375      26.267  59.492   2.381  1.00 40.84          
ATOM   3052  CG  ASN   375      27.129  60.474   3.017  1.00 43.45          
ATOM   3053  OD1 ASN   375      26.894  61.670   2.882  1.00 45.07          
ATOM   3054  ND2 ASN   375      28.150  59.997   3.756  1.00 46.80          
ATOM   3055  N   GLU   376      23.449  59.231   1.330  1.00 40.45          
ATOM   3056  CA  GLU   376      22.350  59.663   0.487  1.00 41.53          
ATOM   3057  C   GLU   376      21.051  59.655   1.283  1.00 42.05          
ATOM   3058  O   GLU   376      20.291  60.602   1.232  1.00 41.37          
ATOM   3059  CB  GLU   376      22.232  58.740  -0.732  1.00 41.64          
ATOM   3060  CG  GLU   376      20.979  58.940  -1.582  1.00 41.79          
ATOM   3061  CD  GLU   376      20.916  60.316  -2.226  1.00 43.32          
ATOM   3062  OE1 GLU   376      21.977  60.976  -2.357  1.00 39.96          
ATOM   3063  OE2 GLU   376      19.791  60.730  -2.609  1.00 44.31          
ATOM   3064  N   LEU   377      20.819  58.587   2.035  1.00 42.74          
ATOM   3065  CA  LEU   377      19.654  58.506   2.913  1.00 44.16          
ATOM   3066  C   LEU   377      19.662  59.573   4.006  1.00 45.06          
ATOM   3067  O   LEU   377      18.690  60.311   4.189  1.00 45.33          
ATOM   3068  CB  LEU   377      19.560  57.113   3.538  1.00 43.66          
ATOM   3069  CG  LEU   377      19.478  55.959   2.542  1.00 43.81          
ATOM   3070  CD1 LEU   377      19.638  54.636   3.247  1.00 45.64          
ATOM   3071  CD2 LEU   377      18.180  55.977   1.757  1.00 45.46          
ATOM   3072  N   MET   378      20.776  59.681   4.716  1.00 45.63          
ATOM   3073  CA  MET   378      20.833  60.548   5.871  1.00 46.72          
ATOM   3074  C   MET   378      21.970  61.514   5.781  1.00 46.45          
ATOM   3075  O   MET   378      23.032  61.294   6.384  1.00 45.42          
ATOM   3076  CB  MET   378      20.947  59.713   7.125  1.00 46.51          
ATOM   3077  CG  MET   378      19.833  58.729   7.249  1.00 46.95          
ATOM   3078  SD  MET   378      20.153  57.738   8.835  0.70 50.67          
ATOM   3079  CE  MET   378      21.071  56.200   8.187  1.00 38.96          
ATOM   3080  N   PRO   379      21.733  62.618   5.058  1.00 46.92          
ATOM   3081  CA  PRO   379      22.751  63.557   4.602  1.00 47.95          
ATOM   3082  C   PRO   379      23.531  64.232   5.707  1.00 48.42          
ATOM   3083  O   PRO   379      24.627  64.726   5.469  1.00 49.11          
ATOM   3084  CB  PRO   379      21.941  64.613   3.826  1.00 47.61          
ATOM   3085  CG  PRO   379      20.668  63.946   3.482  1.00 47.67          
ATOM   3086  CD  PRO   379      20.387  63.042   4.638  1.00 47.05          
ATOM   3087  N   GLN   380      22.985  64.293   6.902  1.00 49.29          
ATOM   3088  CA  GLN   380      23.697  65.049   7.914  1.00 50.47          
ATOM   3089  C   GLN   380      24.167  64.225   9.077  1.00 49.70          
ATOM   3090  O   GLN   380      24.466  64.742  10.148  1.00 50.21          
ATOM   3091  CB  GLN   380      22.948  66.335   8.291  1.00 50.97          
ATOM   3092  CG  GLN   380      23.214  67.454   7.232  1.00 52.53          
ATOM   3093  CD  GLN   380      22.207  68.595   7.244  1.00 53.38          
ATOM   3094  OE1 GLN   380      22.203  69.449   8.154  1.00 56.54          
ATOM   3095  NE2 GLN   380      21.371  68.646   6.199  1.00 56.24          
ATOM   3096  N   THR   381      24.290  62.925   8.818  1.00 48.46          
ATOM   3097  CA  THR   381      24.947  62.010   9.721  1.00 47.97          
ATOM   3098  C   THR   381      26.372  61.808   9.231  1.00 47.37          
ATOM   3099  O   THR   381      27.086  60.976   9.752  1.00 46.91          
ATOM   3100  CB  THR   381      24.220  60.656   9.747  1.00 48.09          
ATOM   3101  OG1 THR   381      24.414  60.002   8.488  1.00 48.89          
ATOM   3102  CG2 THR   381      22.744  60.875   9.950  1.00 48.48          
ATOM   3103  N   MET   382      26.766  62.605   8.228  1.00 47.24          
ATOM   3104  CA  MET   382      28.029  62.447   7.483  1.00 46.89          
ATOM   3105  C   MET   382      29.244  62.743   8.322  1.00 46.14          
ATOM   3106  O   MET   382      29.372  63.849   8.880  1.00 46.21          
ATOM   3107  CB  MET   382      28.077  63.423   6.305  1.00 47.09          
ATOM   3108  CG  MET   382      27.091  63.127   5.213  1.00 47.78          
ATOM   3109  SD  MET   382      27.459  64.102   3.558  0.50 48.62          
ATOM   3110  CE  MET   382      29.399  63.776   3.368  1.00 46.02          
ATOM   3111  N   LEU   383      30.151  61.777   8.390  1.00 45.04          
ATOM   3112  CA  LEU   383      31.394  61.949   9.143  1.00 43.44          
ATOM   3113  C   LEU   383      32.587  61.550   8.280  1.00 42.41          
ATOM   3114  O   LEU   383      32.545  60.533   7.602  1.00 42.18          
ATOM   3115  CB  LEU   383      31.335  61.148  10.452  1.00 43.44          
ATOM   3116  CG  LEU   383      31.154  61.896  11.781  1.00 44.42          
ATOM   3117  CD1 LEU   383      30.373  63.204  11.693  1.00 44.57          
ATOM   3118  CD2 LEU   383      30.581  61.063  12.883  1.00 42.84          
ATOM   3119  N   THR   384      33.631  62.366   8.281  1.00 41.27          
ATOM   3120  CA  THR   384      34.840  62.004   7.565  1.00 40.04          
ATOM   3121  C   THR   384      35.516  60.892   8.354  1.00 39.35          
ATOM   3122  O   THR   384      35.174  60.637   9.517  1.00 37.79          
ATOM   3123  CB  THR   384      35.810  63.181   7.388  1.00 40.16          
ATOM   3124  OG1 THR   384      36.383  63.542   8.660  1.00 39.14          
ATOM   3125  CG2 THR   384      35.109  64.373   6.769  1.00 40.48          
ATOM   3126  N   ALA   385      36.466  60.224   7.719  1.00 38.58          
ATOM   3127  CA  ALA   385      37.202  59.160   8.393  1.00 38.72          
ATOM   3128  C   ALA   385      37.945  59.728   9.604  1.00 37.97          
ATOM   3129  O   ALA   385      37.923  59.125  10.665  1.00 38.04          
ATOM   3130  CB  ALA   385      38.161  58.469   7.427  1.00 39.13          
ATOM   3131  N   GLU   386      38.580  60.886   9.438  1.00 37.61          
ATOM   3132  CA  GLU   386      39.227  61.595  10.550  1.00 37.76          
ATOM   3133  C   GLU   386      38.279  61.865  11.745  1.00 35.74          
ATOM   3134  O   GLU   386      38.660  61.640  12.891  1.00 34.61          
ATOM   3135  CB  GLU   386      39.898  62.896  10.068  1.00 37.48          
ATOM   3136  CG  GLU   386      40.480  63.741  11.201  1.00 40.15          
ATOM   3137  CD  GLU   386      41.432  64.861  10.749  1.00 42.00          
ATOM   3138  OE1 GLU   386      41.487  65.191   9.536  1.00 46.36          
ATOM   3139  OE2 GLU   386      42.135  65.422  11.631  1.00 47.64          
ATOM   3140  N   GLU   387      37.062  62.336  11.483  1.00 34.31          
ATOM   3141  CA  GLU   387      36.127  62.615  12.570  1.00 34.34          
ATOM   3142  C   GLU   387      35.565  61.341  13.212  1.00 32.91          
ATOM   3143  O   GLU   387      35.340  61.285  14.424  1.00 32.26          
ATOM   3144  CB  GLU   387      34.983  63.517  12.102  1.00 35.33          
ATOM   3145  CG  GLU   387      33.882  63.749  13.194  1.00 39.31          
ATOM   3146  CD  GLU   387      34.338  64.639  14.379  1.00 42.73          
ATOM   3147  OE1 GLU   387      35.423  65.246  14.283  1.00 44.76          
ATOM   3148  OE2 GLU   387      33.600  64.754  15.397  1.00 45.63          
ATOM   3149  N   TRP   388      35.352  60.315  12.399  1.00 31.86          
ATOM   3150  CA  TRP   388      34.887  59.020  12.912  1.00 32.42          
ATOM   3151  C   TRP   388      35.883  58.516  13.958  1.00 31.71          
ATOM   3152  O   TRP   388      35.512  58.184  15.093  1.00 30.96          
ATOM   3153  CB  TRP   388      34.717  58.014  11.755  1.00 32.95          
ATOM   3154  CG  TRP   388      33.990  56.778  12.164  1.00 32.77          
ATOM   3155  CD1 TRP   388      32.652  56.513  12.008  1.00 33.75          
ATOM   3156  CD2 TRP   388      34.551  55.639  12.836  1.00 34.86          
ATOM   3157  NE1 TRP   388      32.350  55.271  12.537  1.00 35.81          
ATOM   3158  CE2 TRP   388      33.492  54.714  13.052  1.00 32.94          
ATOM   3159  CE3 TRP   388      35.844  55.305  13.253  1.00 32.86          
ATOM   3160  CZ2 TRP   388      33.689  53.467  13.660  1.00 36.83          
ATOM   3161  CZ3 TRP   388      36.041  54.056  13.879  1.00 34.86          
ATOM   3162  CH2 TRP   388      34.968  53.156  14.074  1.00 34.15          
ATOM   3163  N   ILE   389      37.153  58.487  13.569  1.00 31.86          
ATOM   3164  CA  ILE   389      38.245  58.065  14.454  1.00 32.62          
ATOM   3165  C   ILE   389      38.354  58.936  15.719  1.00 32.50          
ATOM   3166  O   ILE   389      38.511  58.419  16.829  1.00 32.27          
ATOM   3167  CB  ILE   389      39.596  58.030  13.669  1.00 32.82          
ATOM   3168  CG1 ILE   389      39.632  56.808  12.751  1.00 34.60          
ATOM   3169  CG2 ILE   389      40.828  58.008  14.621  1.00 33.23          
ATOM   3170  CD  ILE   389      40.436  57.018  11.475  1.00 40.11          
ATOM   3171  N   ALA   390      38.271  60.251  15.553  1.00 31.76          
ATOM   3172  CA  ALA   390      38.266  61.163  16.697  1.00 31.77          
ATOM   3173  C   ALA   390      37.110  60.841  17.683  1.00 32.26          
ATOM   3174  O   ALA   390      37.280  60.827  18.918  1.00 31.99          
ATOM   3175  CB  ALA   390      38.176  62.598  16.211  1.00 31.45          
ATOM   3176  N   ARG   391      35.939  60.556  17.134  1.00 31.47          
ATOM   3177  CA  ARG   391      34.793  60.282  17.989  1.00 31.51          
ATOM   3178  C   ARG   391      34.950  58.961  18.738  1.00 32.13          
ATOM   3179  O   ARG   391      34.632  58.893  19.944  1.00 32.70          
ATOM   3180  CB  ARG   391      33.485  60.381  17.206  1.00 30.17          
ATOM   3181  CG  ARG   391      33.099  61.853  17.003  1.00 30.95          
ATOM   3182  CD  ARG   391      31.789  61.986  16.288  1.00 28.87          
ATOM   3183  NE  ARG   391      31.479  63.386  16.011  1.00 29.36          
ATOM   3184  CZ  ARG   391      30.241  63.831  15.773  1.00 30.12          
ATOM   3185  NH1 ARG   391      29.207  62.987  15.801  1.00 28.71          
ATOM   3186  NH2 ARG   391      30.036  65.108  15.540  1.00 27.94          
ATOM   3187  N   ILE   392      35.477  57.929  18.069  1.00 31.81          
ATOM   3188  CA  ILE   392      35.847  56.701  18.808  1.00 31.73          
ATOM   3189  C   ILE   392      36.849  56.968  19.940  1.00 32.81          
ATOM   3190  O   ILE   392      36.654  56.545  21.107  1.00 32.20          
ATOM   3191  CB  ILE   392      36.366  55.580  17.853  1.00 32.62          
ATOM   3192  CG1 ILE   392      35.200  55.051  17.001  1.00 31.85          
ATOM   3193  CG2 ILE   392      36.961  54.416  18.649  1.00 31.00          
ATOM   3194  CD  ILE   392      34.111  54.245  17.805  1.00 36.17          
ATOM   3195  N   ASN   393      37.922  57.678  19.603  1.00 33.37          
ATOM   3196  CA  ASN   393      38.938  58.065  20.599  1.00 34.16          
ATOM   3197  C   ASN   393      38.412  58.834  21.818  1.00 34.41          
ATOM   3198  O   ASN   393      38.921  58.662  22.915  1.00 34.44          
ATOM   3199  CB  ASN   393      40.076  58.845  19.933  1.00 33.72          
ATOM   3200  CG  ASN   393      41.030  57.953  19.173  1.00 34.84          
ATOM   3201  OD1 ASN   393      41.295  56.797  19.557  1.00 34.26          
ATOM   3202  ND2 ASN   393      41.553  58.473  18.090  1.00 35.13          
ATOM   3203  N   ALA   394      37.378  59.656  21.622  1.00 34.78          
ATOM   3204  CA  ALA   394      36.889  60.554  22.667  1.00 35.15          
ATOM   3205  C   ALA   394      35.872  59.939  23.631  1.00 34.51          
ATOM   3206  O   ALA   394      35.486  60.596  24.621  1.00 34.67          
ATOM   3207  CB  ALA   394      36.318  61.850  22.053  1.00 35.23          
ATOM   3208  N   VAL   395      35.411  58.714  23.344  1.00 32.75          
ATOM   3209  CA  VAL   395      34.443  58.068  24.234  1.00 32.11          
ATOM   3210  C   VAL   395      34.998  57.955  25.655  1.00 31.61          
ATOM   3211  O   VAL   395      36.123  57.502  25.842  1.00 31.60          
ATOM   3212  CB  VAL   395      33.948  56.680  23.714  1.00 32.01          
ATOM   3213  CG1 VAL   395      32.988  56.028  24.733  1.00 30.65          
ATOM   3214  CG2 VAL   395      33.260  56.819  22.333  1.00 30.25          
ATOM   3215  N   THR   396      34.190  58.365  26.635  1.00 31.11          
ATOM   3216  CA  THR   396      34.572  58.339  28.057  1.00 30.84          
ATOM   3217  C   THR   396      33.808  57.267  28.831  1.00 30.88          
ATOM   3218  O   THR   396      32.807  56.738  28.348  1.00 31.40          
ATOM   3219  CB  THR   396      34.342  59.697  28.720  1.00 30.78          
ATOM   3220  OG1 THR   396      32.941  59.936  28.794  1.00 30.70          
ATOM   3221  CG2 THR   396      34.996  60.827  27.910  1.00 31.56          
ATOM   3222  N   ILE   397      34.290  56.930  30.028  1.00 30.79          
ATOM   3223  CA  ILE   397      33.621  55.937  30.863  1.00 31.05          
ATOM   3224  C   ILE   397      32.203  56.366  31.232  1.00 30.53          
ATOM   3225  O   ILE   397      31.291  55.543  31.123  1.00 29.89          
ATOM   3226  CB  ILE   397      34.471  55.544  32.088  1.00 31.93          
ATOM   3227  CG1 ILE   397      35.608  54.617  31.627  1.00 32.69          
ATOM   3228  CG2 ILE   397      33.632  54.836  33.177  1.00 32.40          
ATOM   3229  CD  ILE   397      36.703  54.393  32.723  1.00 32.94          
ATOM   3230  N   PRO   398      32.010  57.640  31.667  1.00 29.25          
ATOM   3231  CA  PRO   398      30.649  58.115  31.966  1.00 29.22          
ATOM   3232  C   PRO   398      29.676  57.932  30.788  1.00 28.68          
ATOM   3233  O   PRO   398      28.510  57.568  31.009  1.00 28.39          
ATOM   3234  CB  PRO   398      30.859  59.593  32.362  1.00 29.29          
ATOM   3235  CG  PRO   398      32.263  59.605  32.965  1.00 29.06          
ATOM   3236  CD  PRO   398      33.022  58.652  32.024  1.00 29.97          
ATOM   3237  N   GLU   399      30.151  58.107  29.554  1.00 27.95          
ATOM   3238  CA  GLU   399      29.291  57.850  28.389  1.00 28.81          
ATOM   3239  C   GLU   399      28.927  56.383  28.234  1.00 29.40          
ATOM   3240  O   GLU   399      27.769  56.052  27.876  1.00 30.32          
ATOM   3241  CB  GLU   399      29.935  58.330  27.099  1.00 28.49          
ATOM   3242  CG  GLU   399      29.994  59.891  26.982  1.00 29.77          
ATOM   3243  CD  GLU   399      30.826  60.338  25.777  1.00 30.64          
ATOM   3244  OE1 GLU   399      31.693  59.538  25.326  1.00 32.78          
ATOM   3245  OE2 GLU   399      30.625  61.471  25.275  1.00 31.80          
ATOM   3246  N   ILE   400      29.902  55.513  28.507  1.00 28.88          
ATOM   3247  CA  ILE   400      29.686  54.060  28.463  1.00 28.68          
ATOM   3248  C   ILE   400      28.692  53.615  29.532  1.00 29.45          
ATOM   3249  O   ILE   400      27.819  52.740  29.256  1.00 29.87          
ATOM   3250  CB  ILE   400      31.039  53.299  28.603  1.00 29.24          
ATOM   3251  CG1 ILE   400      32.009  53.680  27.459  1.00 28.11          
ATOM   3252  CG2 ILE   400      30.797  51.759  28.692  1.00 28.02          
ATOM   3253  CD  ILE   400      33.474  53.400  27.711  1.00 27.97          
ATOM   3254  N   GLN   401      28.822  54.188  30.739  1.00 29.82          
ATOM   3255  CA  GLN   401      27.924  53.902  31.859  1.00 30.91          
ATOM   3256  C   GLN   401      26.501  54.325  31.509  1.00 31.20          
ATOM   3257  O   GLN   401      25.525  53.610  31.818  1.00 30.23          
ATOM   3258  CB  GLN   401      28.337  54.668  33.136  1.00 30.26          
ATOM   3259  CG  GLN   401      29.660  54.285  33.769  1.00 31.10          
ATOM   3260  CD  GLN   401      29.968  55.143  34.987  1.00 31.12          
ATOM   3261  OE1 GLN   401      30.736  56.112  34.894  1.00 33.37          
ATOM   3262  NE2 GLN   401      29.374  54.806  36.125  1.00 27.94          
ATOM   3263  N   GLU   402      26.376  55.499  30.883  1.00 31.10          
ATOM   3264  CA  GLU   402      25.045  55.956  30.427  1.00 32.41          
ATOM   3265  C   GLU   402      24.389  55.002  29.377  1.00 32.14          
ATOM   3266  O   GLU   402      23.195  54.696  29.476  1.00 32.72          
ATOM   3267  CB  GLU   402      25.113  57.411  29.922  1.00 33.04          
ATOM   3268  CG  GLU   402      23.807  57.995  29.400  1.00 35.65          
ATOM   3269  CD  GLU   402      22.701  58.021  30.454  1.00 40.76          
ATOM   3270  OE1 GLU   402      23.015  58.099  31.675  1.00 39.43          
ATOM   3271  OE2 GLU   402      21.511  57.965  30.043  1.00 42.92          
ATOM   3272  N   VAL   403      25.150  54.551  28.387  1.00 31.30          
ATOM   3273  CA  VAL   403      24.665  53.553  27.422  1.00 31.46          
ATOM   3274  C   VAL   403      24.196  52.308  28.209  1.00 31.88          
ATOM   3275  O   VAL   403      23.096  51.786  27.981  1.00 30.46          
ATOM   3276  CB  VAL   403      25.780  53.180  26.382  1.00 31.85          
ATOM   3277  CG1 VAL   403      25.446  51.883  25.608  1.00 30.73          
ATOM   3278  CG2 VAL   403      25.990  54.360  25.418  1.00 30.71          
ATOM   3279  N   ALA   404      25.015  51.869  29.161  1.00 31.58          
ATOM   3280  CA  ALA   404      24.675  50.665  29.963  1.00 33.16          
ATOM   3281  C   ALA   404      23.379  50.859  30.765  1.00 33.27          
ATOM   3282  O   ALA   404      22.556  49.927  30.886  1.00 34.34          
ATOM   3283  CB  ALA   404      25.827  50.316  30.887  1.00 32.10          
ATOM   3284  N   LYS   405      23.182  52.063  31.308  1.00 34.06          
ATOM   3285  CA  LYS   405      21.952  52.360  32.060  1.00 34.86          
ATOM   3286  C   LYS   405      20.724  52.441  31.156  1.00 34.99          
ATOM   3287  O   LYS   405      19.619  52.097  31.581  1.00 34.34          
ATOM   3288  CB  LYS   405      22.095  53.653  32.885  1.00 34.62          
ATOM   3289  CG  LYS   405      22.996  53.494  34.120  1.00 38.28          
ATOM   3290  CD  LYS   405      23.339  54.861  34.744  1.00 38.24          
ATOM   3291  CE  LYS   405      24.341  54.690  35.890  1.00 42.76          
ATOM   3292  NZ  LYS   405      24.909  56.026  36.278  1.00 45.53          
ATOM   3293  N   ARG   406      20.912  52.901  29.919  1.00 34.87          
ATOM   3294  CA  ARG   406      19.799  52.987  28.943  1.00 36.30          
ATOM   3295  C   ARG   406      19.312  51.633  28.463  1.00 36.14          
ATOM   3296  O   ARG   406      18.148  51.469  28.119  1.00 36.44          
ATOM   3297  CB  ARG   406      20.247  53.776  27.726  1.00 36.27          
ATOM   3298  CG  ARG   406      20.254  55.244  27.997  1.00 38.25          
ATOM   3299  CD  ARG   406      20.842  56.023  26.833  1.00 41.27          
ATOM   3300  NE  ARG   406      20.921  57.445  27.188  1.00 42.58          
ATOM   3301  CZ  ARG   406      20.432  58.434  26.446  1.00 44.07          
ATOM   3302  NH1 ARG   406      19.824  58.167  25.290  1.00 42.06          
ATOM   3303  NH2 ARG   406      20.560  59.687  26.871  1.00 43.66          
ATOM   3304  N   LEU   407      20.234  50.680  28.405  1.00 36.99          
ATOM   3305  CA  LEU   407      19.960  49.315  27.988  1.00 37.49          
ATOM   3306  C   LEU   407      18.840  48.763  28.807  1.00 37.63          
ATOM   3307  O   LEU   407      18.848  48.916  30.020  1.00 38.70          
ATOM   3308  CB  LEU   407      21.183  48.452  28.271  1.00 38.91          
ATOM   3309  CG  LEU   407      21.504  47.426  27.220  1.00 40.13          
ATOM   3310  CD1 LEU   407      22.104  48.240  26.097  1.00 42.89          
ATOM   3311  CD2 LEU   407      22.522  46.423  27.715  1.00 41.18          
ATOM   3312  N   GLU   408      17.900  48.080  28.172  1.00 36.88          
ATOM   3313  CA  GLU   408      16.778  47.508  28.891  1.00 37.41          
ATOM   3314  C   GLU   408      16.465  46.131  28.325  1.00 36.22          
ATOM   3315  O   GLU   408      16.044  46.017  27.174  1.00 34.06          
ATOM   3316  CB  GLU   408      15.551  48.399  28.728  1.00 38.23          
ATOM   3317  CG  GLU   408      14.338  47.913  29.456  1.00 44.20          
ATOM   3318  CD  GLU   408      14.337  48.280  30.947  1.00 50.29          
ATOM   3319  OE1 GLU   408      13.546  47.662  31.698  1.00 54.30          
ATOM   3320  OE2 GLU   408      15.107  49.178  31.359  1.00 52.67          
ATOM   3321  N   LEU   409      16.651  45.098  29.142  1.00 35.15          
ATOM   3322  CA  LEU   409      16.364  43.709  28.707  1.00 34.51          
ATOM   3323  C   LEU   409      14.893  43.570  28.373  1.00 34.30          
ATOM   3324  O   LEU   409      14.025  44.110  29.096  1.00 34.50          
ATOM   3325  CB  LEU   409      16.821  42.689  29.765  1.00 34.77          
ATOM   3326  CG  LEU   409      16.654  41.194  29.487  1.00 34.70          
ATOM   3327  CD1 LEU   409      17.344  40.800  28.174  1.00 30.33          
ATOM   3328  CD2 LEU   409      17.172  40.351  30.671  1.00 33.34          
ATOM   3329  N   GLN   410      14.610  42.896  27.249  1.00 32.92          
ATOM   3330  CA  GLN   410      13.243  42.771  26.722  1.00 31.56          
ATOM   3331  C   GLN   410      12.809  41.345  26.392  1.00 30.61          
ATOM   3332  O   GLN   410      11.630  41.001  26.520  1.00 29.52          
ATOM   3333  CB  GLN   410      13.059  43.661  25.477  1.00 31.87          
ATOM   3334  CG  GLN   410      13.048  45.205  25.784  1.00 31.97          
ATOM   3335  CD  GLN   410      11.807  45.661  26.537  1.00 34.44          
ATOM   3336  OE1 GLN   410      11.744  45.607  27.788  1.00 37.63          
ATOM   3337  NE2 GLN   410      10.808  46.108  25.796  1.00 30.72          
ATOM   3338  N   ALA   411      13.745  40.509  25.960  1.00 29.82          
ATOM   3339  CA  ALA   411      13.373  39.169  25.543  1.00 30.02          
ATOM   3340  C   ALA   411      14.523  38.215  25.805  1.00 30.01          
ATOM   3341  O   ALA   411      15.684  38.597  25.740  1.00 29.01          
ATOM   3342  CB  ALA   411      12.954  39.168  24.050  1.00 29.02          
ATOM   3343  N   ILE   412      14.190  36.975  26.131  1.00 30.36          
ATOM   3344  CA  ILE   412      15.191  35.941  26.326  1.00 31.06          
ATOM   3345  C   ILE   412      14.676  34.732  25.548  1.00 31.27          
ATOM   3346  O   ILE   412      13.517  34.311  25.732  1.00 30.98          
ATOM   3347  CB  ILE   412      15.286  35.497  27.815  1.00 31.24          
ATOM   3348  CG1 ILE   412      15.807  36.615  28.712  1.00 33.16          
ATOM   3349  CG2 ILE   412      16.132  34.191  27.952  1.00 33.12          
ATOM   3350  CD  ILE   412      15.559  36.356  30.177  1.00 33.99          
ATOM   3351  N   PHE   413      15.516  34.167  24.687  1.00 31.05          
ATOM   3352  CA  PHE   413      15.129  32.955  23.991  1.00 30.84          
ATOM   3353  C   PHE   413      16.091  31.851  24.377  1.00 30.66          
ATOM   3354  O   PHE   413      17.318  32.031  24.316  1.00 30.01          
ATOM   3355  CB  PHE   413      15.127  33.146  22.462  1.00 32.47          
ATOM   3356  CG  PHE   413      14.751  31.888  21.711  1.00 33.14          
ATOM   3357  CD1 PHE   413      13.426  31.491  21.616  1.00 35.27          
ATOM   3358  CD2 PHE   413      15.742  31.059  21.174  1.00 35.41          
ATOM   3359  CE1 PHE   413      13.085  30.299  20.947  1.00 34.86          
ATOM   3360  CE2 PHE   413      15.421  29.863  20.509  1.00 34.32          
ATOM   3361  CZ  PHE   413      14.095  29.480  20.399  1.00 33.97          
ATOM   3362  N   PHE   414      15.527  30.721  24.782  1.00 29.69          
ATOM   3363  CA  PHE   414      16.284  29.568  25.238  1.00 30.05          
ATOM   3364  C   PHE   414      15.982  28.362  24.341  1.00 30.26          
ATOM   3365  O   PHE   414      14.842  27.890  24.268  1.00 30.15          
ATOM   3366  CB  PHE   414      15.910  29.306  26.705  1.00 30.09          
ATOM   3367  CG  PHE   414      16.611  28.122  27.350  1.00 30.68          
ATOM   3368  CD1 PHE   414      17.948  27.844  27.094  1.00 29.84          
ATOM   3369  CD2 PHE   414      15.917  27.315  28.254  1.00 30.02          
ATOM   3370  CE1 PHE   414      18.601  26.773  27.731  1.00 30.70          
ATOM   3371  CE2 PHE   414      16.555  26.224  28.886  1.00 31.58          
ATOM   3372  CZ  PHE   414      17.911  25.967  28.627  1.00 29.41          
ATOM   3373  N   LEU   415      16.999  27.886  23.622  1.00 29.90          
ATOM   3374  CA  LEU   415      16.835  26.689  22.805  1.00 29.57          
ATOM   3375  C   LEU   415      17.451  25.571  23.601  1.00 30.60          
ATOM   3376  O   LEU   415      18.677  25.501  23.731  1.00 28.45          
ATOM   3377  CB  LEU   415      17.495  26.820  21.421  1.00 29.40          
ATOM   3378  CG  LEU   415      17.243  25.689  20.404  1.00 30.34          
ATOM   3379  CD1 LEU   415      15.785  25.731  19.879  1.00 33.66          
ATOM   3380  CD2 LEU   415      18.173  25.829  19.252  1.00 29.27          
ATOM   3381  N   GLU   416      16.588  24.714  24.153  1.00 31.05          
ATOM   3382  CA  GLU   416      17.004  23.788  25.174  1.00 33.55          
ATOM   3383  C   GLU   416      17.204  22.405  24.598  1.00 33.33          
ATOM   3384  O   GLU   416      16.272  21.804  24.033  1.00 31.94          
ATOM   3385  CB  GLU   416      15.995  23.756  26.324  1.00 33.15          
ATOM   3386  CG  GLU   416      16.385  22.784  27.450  1.00 37.03          
ATOM   3387  CD  GLU   416      15.438  22.860  28.655  1.00 37.10          
ATOM   3388  OE1 GLU   416      14.221  22.920  28.432  1.00 40.26          
ATOM   3389  OE2 GLU   416      15.925  22.866  29.811  1.00 42.16          
ATOM   3390  N   GLY   417      18.426  21.901  24.751  1.00 33.63          
ATOM   3391  CA  GLY   417      18.770  20.601  24.231  1.00 34.97          
ATOM   3392  C   GLY   417      18.065  19.505  24.996  1.00 37.06          
ATOM   3393  O   GLY   417      18.006  19.541  26.229  1.00 36.74          
ATOM   3394  N   GLU   418      17.494  18.560  24.240  1.00 38.95          
ATOM   3395  CA  GLU   418      17.045  17.267  24.738  1.00 41.92          
ATOM   3396  C   GLU   418      18.155  16.277  24.409  1.00 41.64          
ATOM   3397  O   GLU   418      18.460  16.007  23.228  1.00 41.87          
ATOM   3398  CB  GLU   418      15.721  16.849  24.073  1.00 41.23          
ATOM   3399  CG  GLU   418      14.657  17.945  24.146  1.00 44.94          
ATOM   3400  CD  GLU   418      13.286  17.553  23.553  1.00 46.93          
ATOM   3401  OE1 GLU   418      13.208  17.175  22.345  1.00 53.00          
ATOM   3402  OE2 GLU   418      12.283  17.650  24.308  1.00 53.14          
ATOM   3403  N   THR   419      18.812  15.772  25.444  1.00 41.88          
ATOM   3404  CA  THR   419      19.871  14.793  25.216  1.00 42.16          
ATOM   3405  C   THR   419      19.469  13.434  25.785  1.00 43.12          
ATOM   3406  O   THR   419      20.102  12.436  25.497  1.00 42.14          
ATOM   3407  CB  THR   419      21.241  15.263  25.789  1.00 42.00          
ATOM   3408  OG1 THR   419      21.233  15.138  27.213  1.00 42.00          
ATOM   3409  CG2 THR   419      21.563  16.729  25.410  1.00 40.32          
ATOM   3410  N   GLU   420      18.409  13.404  26.587  1.00 44.89          
ATOM   3411  CA  GLU   420      18.017  12.177  27.294  1.00 47.08          
ATOM   3412  C   GLU   420      16.792  11.537  26.658  1.00 47.75          
ATOM   3413  O   GLU   420      15.854  12.230  26.263  1.00 47.47          
ATOM   3414  CB  GLU   420      17.755  12.443  28.784  1.00 47.51          
ATOM   3415  CG  GLU   420      18.933  13.088  29.529  1.00 50.05          
ATOM   3416  CD  GLU   420      18.861  12.886  31.033  1.00 53.10          
ATOM   3417  OE1 GLU   420      18.739  13.895  31.756  1.00 54.52          
ATOM   3418  OE2 GLU   420      18.913  11.717  31.488  1.00 54.69          
ATOM   3419  N   ASN   421      16.827  10.214  26.550  1.00 48.44          
ATOM   3420  CA  ASN   421      15.730   9.457  25.970  1.00 49.72          
ATOM   3421  C   ASN   421      14.631   9.114  26.969  1.00 51.45          
ATOM   3422  O   ASN   421      14.856   9.112  28.184  1.00 51.64          
ATOM   3423  CB  ASN   421      16.258   8.173  25.338  1.00 49.01          
ATOM   3424  CG  ASN   421      16.659   8.366  23.904  1.00 47.05          
ATOM   3425  OD1 ASN   421      15.988   9.068  23.152  1.00 43.50          
ATOM   3426  ND2 ASN   421      17.746   7.732  23.506  1.00 44.92          
ATOM   3427  N   ASP   422      13.442   8.838  26.430  1.00 53.22          
ATOM   3428  CA  ASP   422      12.281   8.338  27.188  1.00 55.09          
ATOM   3429  C   ASP   422      11.423   9.409  27.868  1.00 55.39          
ATOM   3430  OT1 ASP   422      10.298   9.109  28.291  1.00 55.62          
ATOM   3431  CB  ASP   422      12.687   7.226  28.169  1.00 55.41          
ATOM   3432  CG  ASP   422      13.197   5.988  27.456  1.00 57.46          
ATOM   3433  OD1 ASP   422      12.744   5.735  26.315  1.00 59.13          
ATOM   3434  OD2 ASP   422      14.051   5.268  28.026  1.00 59.04          
ATOM   3435  OT2 ASP   422      11.813  10.582  27.990  1.00 55.73          
END
