
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   85 (  723),  selected   85 , name 2f5k_B
# Molecule2: number of CA atoms   59 (  475),  selected   59 , name T0429_22_99.pdb
# PARAMETERS: 2f5k_B.T0429_22_99.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     6_B      E      22           -
LGA    P     7_B      T      23           -
LGA    K     8_B      E      24          6.590
LGA    P     9_B      L      25          5.417
LGA    K    10_B      L      27          0.694
LGA    F    11_B      Y      28          0.889
LGA    Q    12_B      K      29          1.071
LGA    E    13_B      V      30          0.950
LGA    G    14_B      N      31          0.520
LGA    E    15_B      E      32          0.416
LGA    R    16_B      Y      33          0.275
LGA    V    17_B      V      34          0.378
LGA    L    18_B      D      35          0.693
LGA    C    19_B      A      36          0.881
LGA    F    20_B      R      37          0.444
LGA    H    21_B      D      38          0.490
LGA    G    22_B      T      39          2.931
LGA    -       -      N      40           -
LGA    -       -      M      41           -
LGA    P    23_B      G      42          1.024
LGA    L    24_B      A      43          0.622
LGA    L    25_B      W      44          0.659
LGA    Y    26_B      F      45          0.618
LGA    E    27_B      E      46          0.486
LGA    A    28_B      A      47          0.391
LGA    K    29_B      Q      48          0.091
LGA    C    30_B      V      49          0.130
LGA    V    31_B      V      50          0.485
LGA    K    32_B      R      51          0.718
LGA    V    33_B      V      52          0.869
LGA    A    34_B      T      53          0.974
LGA    I    35_B      R      54          0.924
LGA    K    36_B      E      73           -
LGA    D    37_B      -       -           -
LGA    K    38_B      -       -           -
LGA    Q    39_B      D      74          2.721
LGA    V    40_B      V      75          0.965
LGA    K    41_B      I      76          0.689
LGA    Y    42_B      Y      77          0.955
LGA    F    43_B      H      78          0.837
LGA    I    44_B      V      79          0.612
LGA    H    45_B      K      80          0.384
LGA    Y    46_B      Y      81          0.827
LGA    S    47_B      D      82          0.828
LGA    G    48_B      D      83          0.865
LGA    W    49_B      Y      84          0.364
LGA    N    50_B      P      85          1.996
LGA    K    51_B      E      86          3.946
LGA    N    52_B      N      87          3.630
LGA    W    53_B      G      88          3.665
LGA    D    54_B      V      89          2.281
LGA    E    55_B      V      90          0.699
LGA    W    56_B      Q      91          0.695
LGA    V    57_B      M      92          0.866
LGA    P    58_B      N      93          1.461
LGA    E    59_B      S      94          0.682
LGA    S    60_B      R      95          0.970
LGA    R    61_B      D      96          0.476
LGA    V    62_B      V      97          0.480
LGA    L    63_B      R      98          0.495
LGA    K    64_B      A      99          0.902
LGA    Y    65_B      -       -           -
LGA    V    66_B      -       -           -
LGA    D    67_B      -       -           -
LGA    T    68_B      -       -           -
LGA    N    69_B      -       -           -
LGA    L    70_B      -       -           -
LGA    Q    71_B      -       -           -
LGA    K    72_B      -       -           -
LGA    Q    73_B      -       -           -
LGA    R    74_B      -       -           -
LGA    E    75_B      -       -           -
LGA    L    76_B      -       -           -
LGA    Q    77_B      -       -           -
LGA    K    78_B      -       -           -
LGA    A    79_B      -       -           -
LGA    N    80_B      -       -           -
LGA    Q    81_B      -       -           -
LGA    E    82_B      -       -           -
LGA    Q    83_B      -       -           -
LGA    Y    84_B      -       -           -
LGA    A    85_B      -       -           -
LGA    E    86_B      -       -           -
LGA    G    87_B      -       -           -
LGA    K    88_B      -       -           -
LGA    M    89_B      -       -           -
LGA    R    90_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   85   59    5.0     54    1.74    20.37     87.028     2.928

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.448742 * X  +   0.083398 * Y  +  -0.889761 * Z  +  43.563335
  Y_new =  -0.891586 * X  +   0.109600 * Y  +  -0.439389 * Z  +  -5.129643
  Z_new =   0.060874 * X  +   0.990471 * Y  +   0.123539 * Z  +   8.435061 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.446710   -1.694883  [ DEG:    82.8904    -97.1096 ]
  Theta =  -0.060911   -3.080681  [ DEG:    -3.4900   -176.5100 ]
  Phi   =  -1.104506    2.037087  [ DEG:   -63.2835    116.7165 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f5k_B                                        
REMARK     2: T0429_22_99.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f5k_B.T0429_22_99.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   85   59   5.0   54   1.74   20.37  87.028
REMARK  ---------------------------------------------------------- 
MOLECULE 2f5k_B
HEADER    GENE REGULATION                         26-NOV-05   2F5K              
TITLE     CRYSTAL STRUCTURE OF THE CHROMO DOMAIN OF HUMAN MRG15                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MORF-RELATED GENE 15 ISOFORM 1;                            
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 FRAGMENT: CHROMO DOMAIN;                                             
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-3E-HIS                                
KEYWDS    BETA BARREL, GENE REGULATION                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.ZHANG,J.DU,J.DING                                                   
REVDAT   2   25-DEC-07 2F5K    1       JRNL                                     
REVDAT   1   14-NOV-06 2F5K    0                                                
JRNL        AUTH   P.ZHANG,J.DU,B.SUN,X.DONG,G.XU,J.ZHOU,Q.HUANG,               
JRNL        AUTH 2 Q.LIU,Q.HAO,J.DING                                           
JRNL        TITL   STRUCTURE OF HUMAN MRG15 CHROMO DOMAIN AND ITS               
JRNL        TITL 2 BINDING TO LYS36-METHYLATED HISTONE H3.                      
JRNL        REF    NUCLEIC ACIDS RES.            V.  34  6621 2006              
JRNL        REFN   ASTM NARHAD  UK ISSN 0305-1048                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2F5K A    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K B    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K C    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K D    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K E    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K F    1    90  GB     5803102  NP_006782        1     90             
SEQRES   1 A  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 A  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 A  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 A  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 A  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 A  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 A  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 A  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 B  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 B  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 B  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 B  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 B  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 B  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 B  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 B  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 C  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 C  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 C  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 C  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 C  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 C  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 C  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 C  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 D  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 D  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 D  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 D  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 D  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 D  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 D  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 D  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 E  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 E  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 E  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 E  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 E  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 E  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 E  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 E  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 F  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 F  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 F  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 F  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 F  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 F  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 F  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 F  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
FORMUL   7  HOH   *457(H2 O)                                                    
CRYST1  109.480   80.313   81.285  90.00 123.91  90.00 C 1 2 1      24          
ATOM    705  N   ASP B   6      15.481  -1.825  19.114  1.00 86.07           N  
ATOM    706  CA  ASP B   6      16.154  -3.024  19.670  1.00 85.84           C  
ATOM    707  C   ASP B   6      16.975  -2.594  20.881  1.00 84.75           C  
ATOM    708  O   ASP B   6      18.017  -1.960  20.725  1.00 85.22           O  
ATOM    709  CB  ASP B   6      17.062  -3.631  18.605  1.00 86.56           C  
ATOM    710  CG  ASP B   6      16.830  -5.122  18.407  1.00 88.13           C  
ATOM    711  OD1 ASP B   6      17.132  -5.906  19.338  1.00 89.16           O  
ATOM    712  OD2 ASP B   6      16.368  -5.598  17.340  1.00 89.35           O  
ATOM    713  N   PRO B   7      16.500  -2.923  22.084  1.00 83.26           N  
ATOM    714  CA  PRO B   7      17.191  -2.544  23.326  1.00 81.19           C  
ATOM    715  C   PRO B   7      18.688  -2.905  23.356  1.00 78.55           C  
ATOM    716  O   PRO B   7      19.532  -2.013  23.540  1.00 78.85           O  
ATOM    717  CB  PRO B   7      16.418  -3.322  24.405  1.00 81.77           C  
ATOM    718  CG  PRO B   7      15.034  -3.477  23.841  1.00 82.83           C  
ATOM    719  CD  PRO B   7      15.245  -3.661  22.350  1.00 83.49           C  
ATOM    720  N   LYS B   8      19.018  -4.181  23.161  1.00 74.64           N  
ATOM    721  CA  LYS B   8      20.410  -4.615  23.279  1.00 70.53           C  
ATOM    722  C   LYS B   8      21.139  -4.952  21.963  1.00 66.37           C  
ATOM    723  O   LYS B   8      20.619  -5.670  21.103  1.00 66.05           O  
ATOM    724  CB  LYS B   8      20.519  -5.745  24.305  1.00 71.12           C  
ATOM    725  CG  LYS B   8      20.646  -5.240  25.726  1.00 72.89           C  
ATOM    726  CD  LYS B   8      20.277  -6.322  26.722  1.00 75.27           C  
ATOM    727  CE  LYS B   8      18.785  -6.292  27.042  1.00 76.32           C  
ATOM    728  NZ  LYS B   8      18.493  -7.183  28.200  1.00 76.64           N  
ATOM    729  N   PRO B   9      22.344  -4.400  21.820  1.00 62.00           N  
ATOM    730  CA  PRO B   9      23.173  -4.572  20.616  1.00 57.91           C  
ATOM    731  C   PRO B   9      23.937  -5.888  20.573  1.00 53.09           C  
ATOM    732  O   PRO B   9      24.497  -6.364  21.549  1.00 52.36           O  
ATOM    733  CB  PRO B   9      24.157  -3.419  20.743  1.00 58.16           C  
ATOM    734  CG  PRO B   9      24.397  -3.415  22.198  1.00 60.32           C  
ATOM    735  CD  PRO B   9      23.002  -3.516  22.799  1.00 61.74           C  
ATOM    736  N   LYS B  10      23.985  -6.468  19.399  1.00 48.25           N  
ATOM    737  CA  LYS B  10      24.614  -7.759  19.244  1.00 43.87           C  
ATOM    738  C   LYS B  10      26.122  -7.658  19.335  1.00 41.17           C  
ATOM    739  O   LYS B  10      26.796  -8.599  19.732  1.00 39.77           O  
ATOM    740  CB  LYS B  10      24.189  -8.335  17.903  1.00 43.59           C  
ATOM    741  CG  LYS B  10      24.812  -9.653  17.536  1.00 40.29           C  
ATOM    742  CD  LYS B  10      24.045 -10.201  16.391  1.00 37.36           C  
ATOM    743  CE  LYS B  10      24.573 -11.561  15.974  1.00 36.53           C  
ATOM    744  NZ  LYS B  10      23.861 -11.970  14.722  1.00 35.26           N  
ATOM    745  N   PHE B  11      26.657  -6.492  19.013  1.00 38.49           N  
ATOM    746  CA  PHE B  11      28.106  -6.339  19.029  1.00 36.96           C  
ATOM    747  C   PHE B  11      28.471  -5.132  19.907  1.00 36.88           C  
ATOM    748  O   PHE B  11      27.646  -4.314  20.153  1.00 35.43           O  
ATOM    749  CB  PHE B  11      28.618  -6.102  17.607  1.00 35.53           C  
ATOM    750  CG  PHE B  11      28.388  -7.260  16.667  1.00 33.09           C  
ATOM    751  CD1 PHE B  11      27.247  -7.307  15.865  1.00 32.58           C  
ATOM    752  CD2 PHE B  11      29.290  -8.308  16.590  1.00 28.67           C  
ATOM    753  CE1 PHE B  11      27.036  -8.376  14.973  1.00 30.86           C  
ATOM    754  CE2 PHE B  11      29.069  -9.382  15.714  1.00 28.65           C  
ATOM    755  CZ  PHE B  11      27.947  -9.409  14.898  1.00 28.73           C  
ATOM    756  N   GLN B  12      29.706  -5.026  20.365  1.00 37.35           N  
ATOM    757  CA  GLN B  12      30.105  -3.841  21.102  1.00 37.93           C  
ATOM    758  C   GLN B  12      31.340  -3.150  20.534  1.00 37.73           C  
ATOM    759  O   GLN B  12      32.107  -3.720  19.744  1.00 36.06           O  
ATOM    760  CB  GLN B  12      30.415  -4.212  22.518  1.00 38.80           C  
ATOM    761  CG  GLN B  12      31.640  -5.011  22.605  1.00 41.80           C  
ATOM    762  CD  GLN B  12      31.872  -5.490  23.993  1.00 47.41           C  
ATOM    763  OE1 GLN B  12      30.922  -5.942  24.666  1.00 51.24           O  
ATOM    764  NE2 GLN B  12      33.130  -5.408  24.451  1.00 47.90           N  
ATOM    765  N   GLU B  13      31.540  -1.920  20.999  1.00 37.96           N  
ATOM    766  CA  GLU B  13      32.632  -1.071  20.547  1.00 38.22           C  
ATOM    767  C   GLU B  13      33.934  -1.705  20.850  1.00 35.99           C  
ATOM    768  O   GLU B  13      34.144  -2.148  21.941  1.00 36.23           O  
ATOM    769  CB  GLU B  13      32.548   0.328  21.203  1.00 40.14           C  
ATOM    770  CG  GLU B  13      31.322   1.116  20.756  1.00 44.04           C  
ATOM    771  CD  GLU B  13      31.270   2.543  21.302  1.00 48.83           C  
ATOM    772  OE1 GLU B  13      32.359   3.127  21.566  1.00 48.30           O  
ATOM    773  OE2 GLU B  13      30.120   3.069  21.453  1.00 51.77           O  
ATOM    774  N   GLY B  14      34.820  -1.764  19.877  1.00 34.60           N  
ATOM    775  CA  GLY B  14      36.105  -2.385  20.120  1.00 32.73           C  
ATOM    776  C   GLY B  14      36.102  -3.847  19.702  1.00 31.66           C  
ATOM    777  O   GLY B  14      37.166  -4.441  19.570  1.00 31.63           O  
ATOM    778  N   GLU B  15      34.930  -4.432  19.470  1.00 30.35           N  
ATOM    779  CA  GLU B  15      34.876  -5.853  19.088  1.00 30.03           C  
ATOM    780  C   GLU B  15      35.351  -6.063  17.650  1.00 29.76           C  
ATOM    781  O   GLU B  15      34.881  -5.360  16.710  1.00 29.38           O  
ATOM    782  CB  GLU B  15      33.451  -6.381  19.171  1.00 30.89           C  
ATOM    783  CG  GLU B  15      33.279  -7.901  19.115  1.00 31.79           C  
ATOM    784  CD  GLU B  15      31.808  -8.311  19.235  1.00 33.75           C  
ATOM    785  OE1 GLU B  15      30.988  -7.491  19.680  1.00 33.19           O  
ATOM    786  OE2 GLU B  15      31.459  -9.453  18.878  1.00 34.57           O  
ATOM    787  N   ARG B  16      36.286  -6.998  17.493  1.00 28.23           N  
ATOM    788  CA  ARG B  16      36.731  -7.425  16.198  1.00 28.03           C  
ATOM    789  C   ARG B  16      35.573  -8.220  15.594  1.00 26.90           C  
ATOM    790  O   ARG B  16      34.973  -9.080  16.244  1.00 26.70           O  
ATOM    791  CB  ARG B  16      37.963  -8.315  16.331  1.00 27.75           C  
ATOM    792  CG  ARG B  16      38.408  -8.902  15.010  1.00 31.69           C  
ATOM    793  CD  ARG B  16      39.726  -9.698  15.085  1.00 36.95           C  
ATOM    794  NE  ARG B  16      39.617 -10.726  16.107  1.00 40.35           N  
ATOM    795  CZ  ARG B  16      40.454 -11.763  16.263  1.00 42.98           C  
ATOM    796  NH1 ARG B  16      41.487 -11.968  15.448  1.00 43.50           N  
ATOM    797  NH2 ARG B  16      40.215 -12.624  17.235  1.00 43.43           N  
ATOM    798  N   VAL B  17      35.252  -7.946  14.347  1.00 25.64           N  
ATOM    799  CA  VAL B  17      34.119  -8.626  13.757  1.00 25.19           C  
ATOM    800  C   VAL B  17      34.406  -9.017  12.317  1.00 23.90           C  
ATOM    801  O   VAL B  17      35.500  -8.724  11.790  1.00 21.67           O  
ATOM    802  CB  VAL B  17      32.910  -7.725  13.789  1.00 25.87           C  
ATOM    803  CG1 VAL B  17      31.801  -8.402  13.156  1.00 30.80           C  
ATOM    804  CG2 VAL B  17      32.467  -7.409  15.255  1.00 26.04           C  
ATOM    805  N   LEU B  18      33.456  -9.707  11.691  1.00 22.86           N  
ATOM    806  CA  LEU B  18      33.547  -9.932  10.261  1.00 24.97           C  
ATOM    807  C   LEU B  18      32.427  -9.122   9.681  1.00 25.50           C  
ATOM    808  O   LEU B  18      31.363  -9.026  10.278  1.00 27.32           O  
ATOM    809  CB  LEU B  18      33.363 -11.392   9.877  1.00 25.40           C  
ATOM    810  CG  LEU B  18      34.506 -12.337  10.209  1.00 26.79           C  
ATOM    811  CD1 LEU B  18      34.112 -13.830   9.853  1.00 25.90           C  
ATOM    812  CD2 LEU B  18      35.711 -11.886   9.386  1.00 27.83           C  
ATOM    813  N   CYS B  19      32.632  -8.504   8.544  1.00 24.66           N  
ATOM    814  CA  CYS B  19      31.590  -7.622   8.055  1.00 24.54           C  
ATOM    815  C   CYS B  19      31.490  -7.718   6.565  1.00 25.41           C  
ATOM    816  O   CYS B  19      32.507  -7.681   5.864  1.00 24.72           O  
ATOM    817  CB  CYS B  19      31.868  -6.162   8.466  1.00 23.76           C  
ATOM    818  SG  CYS B  19      30.588  -4.935   8.016  1.00 26.21           S  
ATOM    819  N   PHE B  20      30.256  -7.753   6.065  1.00 26.72           N  
ATOM    820  CA  PHE B  20      30.024  -7.761   4.613  1.00 28.76           C  
ATOM    821  C   PHE B  20      30.230  -6.407   3.962  1.00 30.50           C  
ATOM    822  O   PHE B  20      29.731  -5.410   4.450  1.00 31.12           O  
ATOM    823  CB  PHE B  20      28.598  -8.183   4.287  1.00 28.20           C  
ATOM    824  CG  PHE B  20      28.416  -9.655   4.239  1.00 30.54           C  
ATOM    825  CD1 PHE B  20      27.810 -10.322   5.269  1.00 31.80           C  
ATOM    826  CD2 PHE B  20      28.883 -10.373   3.168  1.00 32.57           C  
ATOM    827  CE1 PHE B  20      27.646 -11.716   5.220  1.00 31.42           C  
ATOM    828  CE2 PHE B  20      28.716 -11.728   3.108  1.00 33.11           C  
ATOM    829  CZ  PHE B  20      28.093 -12.402   4.164  1.00 31.64           C  
ATOM    830  N   HIS B  21      30.923  -6.394   2.827  1.00 32.28           N  
ATOM    831  CA  HIS B  21      31.042  -5.194   2.055  1.00 34.78           C  
ATOM    832  C   HIS B  21      30.872  -5.678   0.625  1.00 35.41           C  
ATOM    833  O   HIS B  21      31.775  -6.270   0.050  1.00 35.64           O  
ATOM    834  CB  HIS B  21      32.402  -4.533   2.275  1.00 36.34           C  
ATOM    835  CG  HIS B  21      32.536  -3.240   1.552  1.00 39.19           C  
ATOM    836  ND1 HIS B  21      33.127  -3.144   0.311  1.00 41.91           N  
ATOM    837  CD2 HIS B  21      32.108  -1.997   1.868  1.00 42.44           C  
ATOM    838  CE1 HIS B  21      33.061  -1.891  -0.107  1.00 43.54           C  
ATOM    839  NE2 HIS B  21      32.449  -1.173   0.819  1.00 44.52           N  
ATOM    840  N   GLY B  22      29.707  -5.441   0.041  1.00 35.91           N  
ATOM    841  CA  GLY B  22      29.430  -6.103  -1.217  1.00 37.67           C  
ATOM    842  C   GLY B  22      29.242  -7.590  -0.919  1.00 37.68           C  
ATOM    843  O   GLY B  22      28.692  -7.937   0.112  1.00 38.55           O  
ATOM    844  N   PRO B  23      29.699  -8.458  -1.798  1.00 38.07           N  
ATOM    845  CA  PRO B  23      29.531  -9.909  -1.644  1.00 37.87           C  
ATOM    846  C   PRO B  23      30.571 -10.634  -0.809  1.00 37.57           C  
ATOM    847  O   PRO B  23      30.543 -11.860  -0.755  1.00 38.49           O  
ATOM    848  CB  PRO B  23      29.641 -10.387  -3.098  1.00 38.30           C  
ATOM    849  CG  PRO B  23      30.786  -9.491  -3.617  1.00 38.39           C  
ATOM    850  CD  PRO B  23      30.369  -8.113  -3.080  1.00 38.80           C  
ATOM    851  N   LEU B  24      31.482  -9.917  -0.162  1.00 37.15           N  
ATOM    852  CA  LEU B  24      32.574 -10.560   0.575  1.00 34.97           C  
ATOM    853  C   LEU B  24      32.622 -10.133   2.021  1.00 32.79           C  
ATOM    854  O   LEU B  24      32.175  -9.041   2.366  1.00 32.13           O  
ATOM    855  CB  LEU B  24      33.897 -10.197  -0.091  1.00 35.92           C  
ATOM    856  CG  LEU B  24      34.169 -10.830  -1.464  1.00 37.63           C  
ATOM    857  CD1 LEU B  24      35.396 -10.173  -2.117  1.00 37.39           C  
ATOM    858  CD2 LEU B  24      34.369 -12.354  -1.259  1.00 38.16           C  
ATOM    859  N   LEU B  25      33.160 -11.011   2.847  1.00 30.98           N  
ATOM    860  CA  LEU B  25      33.312 -10.805   4.281  1.00 30.10           C  
ATOM    861  C   LEU B  25      34.733 -10.355   4.603  1.00 29.23           C  
ATOM    862  O   LEU B  25      35.691 -10.991   4.197  1.00 28.12           O  
ATOM    863  CB  LEU B  25      33.020 -12.092   5.072  1.00 29.97           C  
ATOM    864  CG  LEU B  25      31.539 -12.331   5.369  1.00 29.53           C  
ATOM    865  CD1 LEU B  25      31.320 -13.768   5.779  1.00 27.82           C  
ATOM    866  CD2 LEU B  25      31.017 -11.355   6.427  1.00 27.53           C  
ATOM    867  N   TYR B  26      34.844  -9.269   5.362  1.00 28.93           N  
ATOM    868  CA  TYR B  26      36.138  -8.716   5.721  1.00 28.77           C  
ATOM    869  C   TYR B  26      36.291  -8.612   7.223  1.00 27.65           C  
ATOM    870  O   TYR B  26      35.328  -8.330   7.934  1.00 26.81           O  
ATOM    871  CB  TYR B  26      36.250  -7.308   5.157  1.00 29.86           C  
ATOM    872  CG  TYR B  26      36.251  -7.271   3.662  1.00 32.77           C  
ATOM    873  CD1 TYR B  26      35.072  -7.090   2.943  1.00 35.95           C  
ATOM    874  CD2 TYR B  26      37.423  -7.449   2.961  1.00 35.40           C  
ATOM    875  CE1 TYR B  26      35.083  -7.078   1.536  1.00 38.38           C  
ATOM    876  CE2 TYR B  26      37.442  -7.443   1.571  1.00 38.48           C  
ATOM    877  CZ  TYR B  26      36.280  -7.253   0.870  1.00 38.96           C  
ATOM    878  OH  TYR B  26      36.332  -7.232  -0.502  1.00 40.91           O  
ATOM    879  N   GLU B  27      37.520  -8.826   7.681  1.00 26.19           N  
ATOM    880  CA  GLU B  27      37.873  -8.595   9.052  1.00 26.24           C  
ATOM    881  C   GLU B  27      37.646  -7.105   9.350  1.00 25.83           C  
ATOM    882  O   GLU B  27      37.968  -6.230   8.540  1.00 25.51           O  
ATOM    883  CB  GLU B  27      39.312  -9.003   9.286  1.00 25.31           C  
ATOM    884  CG  GLU B  27      39.713  -8.873  10.728  1.00 28.15           C  
ATOM    885  CD  GLU B  27      41.152  -9.269  10.939  1.00 31.40           C  
ATOM    886  OE1 GLU B  27      41.734  -9.935  10.055  1.00 33.35           O  
ATOM    887  OE2 GLU B  27      41.700  -8.906  11.962  1.00 31.79           O  
ATOM    888  N   ALA B  28      37.030  -6.815  10.473  1.00 26.14           N  
ATOM    889  CA  ALA B  28      36.719  -5.439  10.808  1.00 27.30           C  
ATOM    890  C   ALA B  28      36.567  -5.243  12.313  1.00 29.01           C  
ATOM    891  O   ALA B  28      36.573  -6.213  13.084  1.00 29.26           O  
ATOM    892  CB  ALA B  28      35.441  -5.011  10.106  1.00 25.81           C  
ATOM    893  N   LYS B  29      36.406  -3.985  12.709  1.00 30.56           N  
ATOM    894  CA  LYS B  29      36.254  -3.603  14.093  1.00 33.47           C  
ATOM    895  C   LYS B  29      35.064  -2.637  14.292  1.00 34.73           C  
ATOM    896  O   LYS B  29      34.829  -1.714  13.509  1.00 33.85           O  
ATOM    897  CB  LYS B  29      37.553  -3.019  14.654  1.00 34.22           C  
ATOM    898  CG  LYS B  29      38.541  -4.122  15.180  1.00 38.89           C  
ATOM    899  CD  LYS B  29      39.330  -4.849  14.036  1.00 43.01           C  
ATOM    900  CE  LYS B  29      40.310  -5.936  14.570  1.00 44.39           C  
ATOM    901  NZ  LYS B  29      41.121  -6.659  13.495  1.00 44.99           N  
ATOM    902  N   CYS B  30      34.287  -2.894  15.321  1.00 36.93           N  
ATOM    903  CA  CYS B  30      33.166  -2.020  15.638  1.00 39.77           C  
ATOM    904  C   CYS B  30      33.718  -0.777  16.346  1.00 41.44           C  
ATOM    905  O   CYS B  30      34.271  -0.866  17.462  1.00 41.51           O  
ATOM    906  CB  CYS B  30      32.186  -2.734  16.532  1.00 39.49           C  
ATOM    907  SG  CYS B  30      30.859  -1.620  17.059  1.00 44.17           S  
ATOM    908  N   VAL B  31      33.629   0.367  15.690  1.00 42.97           N  
ATOM    909  CA  VAL B  31      34.172   1.577  16.308  1.00 45.01           C  
ATOM    910  C   VAL B  31      33.111   2.249  17.167  1.00 46.19           C  
ATOM    911  O   VAL B  31      33.387   2.707  18.256  1.00 45.73           O  
ATOM    912  CB  VAL B  31      34.715   2.579  15.262  1.00 45.02           C  
ATOM    913  CG1 VAL B  31      35.373   3.783  15.961  1.00 45.62           C  
ATOM    914  CG2 VAL B  31      35.719   1.893  14.340  1.00 45.43           C  
ATOM    915  N   LYS B  32      31.885   2.286  16.678  1.00 48.25           N  
ATOM    916  CA  LYS B  32      30.810   2.907  17.429  1.00 50.98           C  
ATOM    917  C   LYS B  32      29.477   2.192  17.240  1.00 52.15           C  
ATOM    918  O   LYS B  32      29.130   1.789  16.149  1.00 51.96           O  
ATOM    919  CB  LYS B  32      30.669   4.406  17.081  1.00 51.26           C  
ATOM    920  CG  LYS B  32      31.301   5.358  18.123  1.00 53.72           C  
ATOM    921  CD  LYS B  32      30.834   6.823  17.964  1.00 55.98           C  
ATOM    922  CE  LYS B  32      31.109   7.644  19.255  1.00 57.97           C  
ATOM    923  NZ  LYS B  32      31.118   9.134  19.072  1.00 57.06           N  
ATOM    924  N   VAL B  33      28.726   2.055  18.323  1.00 54.48           N  
ATOM    925  CA  VAL B  33      27.413   1.433  18.265  1.00 56.70           C  
ATOM    926  C   VAL B  33      26.379   2.533  18.400  1.00 58.98           C  
ATOM    927  O   VAL B  33      26.579   3.458  19.172  1.00 59.38           O  
ATOM    928  CB  VAL B  33      27.238   0.426  19.407  1.00 56.26           C  
ATOM    929  CG1 VAL B  33      25.868  -0.229  19.348  1.00 55.79           C  
ATOM    930  CG2 VAL B  33      28.350  -0.598  19.374  1.00 54.66           C  
ATOM    931  N   ALA B  34      25.296   2.458  17.634  1.00 61.82           N  
ATOM    932  CA  ALA B  34      24.230   3.457  17.718  1.00 64.49           C  
ATOM    933  C   ALA B  34      22.881   2.870  17.353  1.00 66.80           C  
ATOM    934  O   ALA B  34      22.762   2.069  16.420  1.00 66.82           O  
ATOM    935  CB  ALA B  34      24.530   4.638  16.842  1.00 64.39           C  
ATOM    936  N   ILE B  35      21.858   3.276  18.089  1.00 69.43           N  
ATOM    937  CA  ILE B  35      20.525   2.768  17.827  1.00 72.19           C  
ATOM    938  C   ILE B  35      19.636   3.850  17.241  1.00 73.92           C  
ATOM    939  O   ILE B  35      19.288   4.809  17.913  1.00 74.02           O  
ATOM    940  CB  ILE B  35      19.907   2.184  19.104  1.00 72.15           C  
ATOM    941  CG1 ILE B  35      20.757   1.014  19.606  1.00 72.15           C  
ATOM    942  CG2 ILE B  35      18.490   1.733  18.831  1.00 72.49           C  
ATOM    943  CD1 ILE B  35      20.361   0.489  20.956  1.00 71.70           C  
ATOM    944  N   LYS B  36      19.292   3.693  15.971  1.00 76.12           N  
ATOM    945  CA  LYS B  36      18.443   4.656  15.294  1.00 78.21           C  
ATOM    946  C   LYS B  36      17.077   4.053  14.981  1.00 79.07           C  
ATOM    947  O   LYS B  36      16.980   3.052  14.271  1.00 79.11           O  
ATOM    948  CB  LYS B  36      19.109   5.145  14.006  1.00 78.77           C  
ATOM    949  CG  LYS B  36      18.216   6.030  13.143  1.00 80.67           C  
ATOM    950  CD  LYS B  36      18.875   6.361  11.802  1.00 83.63           C  
ATOM    951  CE  LYS B  36      18.057   7.397  11.019  1.00 85.61           C  
ATOM    952  NZ  LYS B  36      18.599   7.668   9.657  1.00 86.71           N  
ATOM    953  N   ASP B  37      16.022   4.646  15.530  1.00 80.03           N  
ATOM    954  CA  ASP B  37      14.677   4.178  15.224  1.00 80.95           C  
ATOM    955  C   ASP B  37      14.507   2.734  15.656  1.00 80.66           C  
ATOM    956  O   ASP B  37      13.786   1.963  15.023  1.00 80.85           O  
ATOM    957  CB  ASP B  37      14.453   4.274  13.719  1.00 81.74           C  
ATOM    958  CG  ASP B  37      13.134   4.883  13.376  1.00 83.76           C  
ATOM    959  OD1 ASP B  37      12.202   4.756  14.200  1.00 85.51           O  
ATOM    960  OD2 ASP B  37      12.943   5.508  12.309  1.00 85.41           O  
ATOM    961  N   LYS B  38      15.206   2.373  16.724  1.00 80.09           N  
ATOM    962  CA  LYS B  38      15.216   1.015  17.257  1.00 79.20           C  
ATOM    963  C   LYS B  38      15.682  -0.049  16.256  1.00 77.56           C  
ATOM    964  O   LYS B  38      15.228  -1.186  16.264  1.00 77.64           O  
ATOM    965  CB  LYS B  38      13.884   0.663  17.901  1.00 80.01           C  
ATOM    966  CG  LYS B  38      14.048   0.191  19.330  1.00 82.13           C  
ATOM    967  CD  LYS B  38      12.709  -0.210  19.932  1.00 85.95           C  
ATOM    968  CE  LYS B  38      12.866  -0.844  21.314  1.00 87.83           C  
ATOM    969  NZ  LYS B  38      11.554  -1.315  21.853  1.00 89.02           N  
ATOM    970  N   GLN B  39      16.574   0.354  15.367  1.00 75.32           N  
ATOM    971  CA  GLN B  39      17.279  -0.588  14.527  1.00 72.93           C  
ATOM    972  C   GLN B  39      18.686  -0.355  15.030  1.00 70.30           C  
ATOM    973  O   GLN B  39      19.010   0.759  15.455  1.00 70.23           O  
ATOM    974  CB  GLN B  39      17.171  -0.237  13.040  1.00 73.58           C  
ATOM    975  CG  GLN B  39      15.762  -0.314  12.438  1.00 74.92           C  
ATOM    976  CD  GLN B  39      15.207  -1.725  12.362  1.00 76.27           C  
ATOM    977  OE1 GLN B  39      15.894  -2.688  12.689  1.00 76.52           O  
ATOM    978  NE2 GLN B  39      13.956  -1.847  11.940  1.00 76.89           N  
ATOM    979  N   VAL B  40      19.522  -1.380  15.054  1.00 66.90           N  
ATOM    980  CA  VAL B  40      20.888  -1.139  15.523  1.00 63.45           C  
ATOM    981  C   VAL B  40      21.809  -0.913  14.337  1.00 60.27           C  
ATOM    982  O   VAL B  40      21.686  -1.605  13.326  1.00 60.42           O  
ATOM    983  CB  VAL B  40      21.421  -2.276  16.419  1.00 63.64           C  
ATOM    984  CG1 VAL B  40      22.574  -1.777  17.278  1.00 63.01           C  
ATOM    985  CG2 VAL B  40      20.303  -2.821  17.301  1.00 64.21           C  
ATOM    986  N   LYS B  41      22.704   0.068  14.458  1.00 56.35           N  
ATOM    987  CA  LYS B  41      23.665   0.396  13.403  1.00 52.31           C  
ATOM    988  C   LYS B  41      25.065   0.441  13.976  1.00 48.51           C  
ATOM    989  O   LYS B  41      25.242   0.724  15.155  1.00 48.09           O  
ATOM    990  CB  LYS B  41      23.306   1.719  12.735  1.00 53.02           C  
ATOM    991  CG  LYS B  41      22.193   1.594  11.714  1.00 54.73           C  
ATOM    992  CD  LYS B  41      22.003   2.883  10.923  1.00 56.73           C  
ATOM    993  CE  LYS B  41      20.776   2.809  10.047  1.00 58.27           C  
ATOM    994  NZ  LYS B  41      20.640   4.021   9.215  1.00 59.51           N  
ATOM    995  N   TYR B  42      26.056   0.117  13.162  1.00 43.83           N  
ATOM    996  CA  TYR B  42      27.429   0.097  13.659  1.00 40.31           C  
ATOM    997  C   TYR B  42      28.323   0.883  12.736  1.00 38.09           C  
ATOM    998  O   TYR B  42      28.105   0.899  11.533  1.00 37.68           O  
ATOM    999  CB  TYR B  42      27.981  -1.348  13.821  1.00 39.54           C  
ATOM   1000  CG  TYR B  42      27.178  -2.202  14.780  1.00 38.25           C  
ATOM   1001  CD1 TYR B  42      26.007  -2.829  14.369  1.00 38.52           C  
ATOM   1002  CD2 TYR B  42      27.571  -2.362  16.086  1.00 35.99           C  
ATOM   1003  CE1 TYR B  42      25.268  -3.574  15.241  1.00 37.25           C  
ATOM   1004  CE2 TYR B  42      26.851  -3.111  16.952  1.00 35.51           C  
ATOM   1005  CZ  TYR B  42      25.699  -3.725  16.523  1.00 34.65           C  
ATOM   1006  OH  TYR B  42      24.976  -4.483  17.391  1.00 31.58           O  
ATOM   1007  N   PHE B  43      29.327   1.529  13.316  1.00 36.11           N  
ATOM   1008  CA  PHE B  43      30.314   2.270  12.546  1.00 34.21           C  
ATOM   1009  C   PHE B  43      31.496   1.342  12.497  1.00 32.63           C  
ATOM   1010  O   PHE B  43      32.070   0.972  13.537  1.00 32.16           O  
ATOM   1011  CB  PHE B  43      30.674   3.615  13.229  1.00 34.87           C  
ATOM   1012  CG  PHE B  43      31.499   4.521  12.350  1.00 33.75           C  
ATOM   1013  CD1 PHE B  43      30.939   5.113  11.241  1.00 33.66           C  
ATOM   1014  CD2 PHE B  43      32.843   4.722  12.605  1.00 33.31           C  
ATOM   1015  CE1 PHE B  43      31.680   5.911  10.426  1.00 33.78           C  
ATOM   1016  CE2 PHE B  43      33.589   5.503  11.778  1.00 34.06           C  
ATOM   1017  CZ  PHE B  43      32.992   6.095  10.683  1.00 34.65           C  
ATOM   1018  N   ILE B  44      31.847   0.954  11.285  1.00 30.79           N  
ATOM   1019  CA  ILE B  44      32.838  -0.090  11.050  1.00 29.63           C  
ATOM   1020  C   ILE B  44      34.096   0.431  10.409  1.00 29.09           C  
ATOM   1021  O   ILE B  44      34.045   1.206   9.429  1.00 29.25           O  
ATOM   1022  CB  ILE B  44      32.261  -1.135  10.034  1.00 29.39           C  
ATOM   1023  CG1 ILE B  44      31.082  -1.929  10.623  1.00 29.69           C  
ATOM   1024  CG2 ILE B  44      33.364  -2.081   9.538  1.00 28.65           C  
ATOM   1025  CD1 ILE B  44      31.460  -2.800  11.895  1.00 30.94           C  
ATOM   1026  N   HIS B  45      35.219  -0.010  10.946  1.00 27.47           N  
ATOM   1027  CA  HIS B  45      36.491   0.188  10.285  1.00 26.32           C  
ATOM   1028  C   HIS B  45      36.996  -1.171   9.797  1.00 25.55           C  
ATOM   1029  O   HIS B  45      37.098  -2.136  10.586  1.00 24.96           O  
ATOM   1030  CB  HIS B  45      37.529   0.805  11.222  1.00 26.72           C  
ATOM   1031  CG  HIS B  45      38.904   0.799  10.638  1.00 28.13           C  
ATOM   1032  ND1 HIS B  45      39.885  -0.070  11.066  1.00 28.46           N  
ATOM   1033  CD2 HIS B  45      39.426   1.469   9.581  1.00 28.75           C  
ATOM   1034  CE1 HIS B  45      40.965   0.093  10.321  1.00 29.42           C  
ATOM   1035  NE2 HIS B  45      40.718   1.027   9.420  1.00 28.79           N  
ATOM   1036  N   TYR B  46      37.263  -1.266   8.506  1.00 23.98           N  
ATOM   1037  CA  TYR B  46      37.797  -2.464   7.897  1.00 23.83           C  
ATOM   1038  C   TYR B  46      39.288  -2.482   8.092  1.00 24.80           C  
ATOM   1039  O   TYR B  46      40.012  -1.477   7.767  1.00 23.62           O  
ATOM   1040  CB  TYR B  46      37.495  -2.502   6.425  1.00 24.04           C  
ATOM   1041  CG  TYR B  46      36.014  -2.509   6.133  1.00 24.72           C  
ATOM   1042  CD1 TYR B  46      35.326  -1.339   5.924  1.00 24.52           C  
ATOM   1043  CD2 TYR B  46      35.295  -3.696   6.116  1.00 26.29           C  
ATOM   1044  CE1 TYR B  46      33.956  -1.332   5.639  1.00 27.15           C  
ATOM   1045  CE2 TYR B  46      33.915  -3.711   5.824  1.00 26.58           C  
ATOM   1046  CZ  TYR B  46      33.259  -2.516   5.603  1.00 28.39           C  
ATOM   1047  OH  TYR B  46      31.887  -2.491   5.352  1.00 30.83           O  
ATOM   1048  N   SER B  47      39.737  -3.616   8.638  1.00 23.43           N  
ATOM   1049  CA  SER B  47      41.105  -3.828   8.981  1.00 24.10           C  
ATOM   1050  C   SER B  47      41.960  -3.768   7.751  1.00 24.31           C  
ATOM   1051  O   SER B  47      41.729  -4.521   6.843  1.00 22.37           O  
ATOM   1052  CB  SER B  47      41.291  -5.200   9.633  1.00 23.51           C  
ATOM   1053  OG  SER B  47      40.457  -5.273  10.736  1.00 25.42           O  
ATOM   1054  N   GLY B  48      42.985  -2.910   7.776  1.00 25.56           N  
ATOM   1055  CA  GLY B  48      43.917  -2.799   6.664  1.00 27.37           C  
ATOM   1056  C   GLY B  48      43.413  -1.792   5.662  1.00 29.50           C  
ATOM   1057  O   GLY B  48      44.068  -1.522   4.659  1.00 30.89           O  
ATOM   1058  N   TRP B  49      42.242  -1.224   5.898  1.00 30.07           N  
ATOM   1059  CA  TRP B  49      41.723  -0.294   4.905  1.00 31.06           C  
ATOM   1060  C   TRP B  49      41.868   1.110   5.403  1.00 31.30           C  
ATOM   1061  O   TRP B  49      41.749   1.393   6.602  1.00 28.67           O  
ATOM   1062  CB  TRP B  49      40.228  -0.470   4.580  1.00 31.03           C  
ATOM   1063  CG  TRP B  49      39.784  -1.767   3.938  1.00 35.18           C  
ATOM   1064  CD1 TRP B  49      40.437  -2.964   3.960  1.00 36.62           C  
ATOM   1065  CD2 TRP B  49      38.556  -1.993   3.222  1.00 37.09           C  
ATOM   1066  NE1 TRP B  49      39.728  -3.904   3.257  1.00 38.53           N  
ATOM   1067  CE2 TRP B  49      38.550  -3.344   2.823  1.00 39.17           C  
ATOM   1068  CE3 TRP B  49      37.455  -1.189   2.885  1.00 37.47           C  
ATOM   1069  CZ2 TRP B  49      37.479  -3.909   2.107  1.00 39.16           C  
ATOM   1070  CZ3 TRP B  49      36.403  -1.743   2.173  1.00 38.04           C  
ATOM   1071  CH2 TRP B  49      36.418  -3.091   1.799  1.00 39.06           C  
ATOM   1072  N   ASN B  50      42.002   2.018   4.449  1.00 32.68           N  
ATOM   1073  CA  ASN B  50      42.018   3.404   4.839  1.00 35.01           C  
ATOM   1074  C   ASN B  50      40.704   3.843   5.509  1.00 34.68           C  
ATOM   1075  O   ASN B  50      39.610   3.306   5.239  1.00 33.13           O  
ATOM   1076  CB  ASN B  50      42.357   4.276   3.631  1.00 36.93           C  
ATOM   1077  CG  ASN B  50      42.390   5.696   3.988  1.00 40.82           C  
ATOM   1078  OD1 ASN B  50      43.172   6.113   4.843  1.00 46.91           O  
ATOM   1079  ND2 ASN B  50      41.483   6.438   3.441  1.00 43.40           N  
ATOM   1080  N   LYS B  51      40.826   4.808   6.407  1.00 35.47           N  
ATOM   1081  CA  LYS B  51      39.678   5.352   7.118  1.00 37.16           C  
ATOM   1082  C   LYS B  51      38.560   6.005   6.307  1.00 36.55           C  
ATOM   1083  O   LYS B  51      37.429   6.140   6.804  1.00 36.43           O  
ATOM   1084  CB  LYS B  51      40.137   6.315   8.206  1.00 38.14           C  
ATOM   1085  CG  LYS B  51      40.388   5.562   9.495  1.00 43.27           C  
ATOM   1086  CD  LYS B  51      40.342   6.468  10.717  1.00 49.68           C  
ATOM   1087  CE  LYS B  51      40.905   5.747  11.931  1.00 52.86           C  
ATOM   1088  NZ  LYS B  51      40.774   6.634  13.128  1.00 56.14           N  
ATOM   1089  N   ASN B  52      38.859   6.431   5.089  1.00 36.28           N  
ATOM   1090  CA  ASN B  52      37.810   6.973   4.214  1.00 36.72           C  
ATOM   1091  C   ASN B  52      36.793   5.875   3.913  1.00 36.75           C  
ATOM   1092  O   ASN B  52      35.687   6.135   3.430  1.00 36.40           O  
ATOM   1093  CB  ASN B  52      38.419   7.507   2.906  1.00 36.04           C  
ATOM   1094  CG  ASN B  52      39.367   8.705   3.147  1.00 35.99           C  
ATOM   1095  OD1 ASN B  52      39.348   9.369   4.217  1.00 31.98           O  
ATOM   1096  ND2 ASN B  52      40.214   8.972   2.151  1.00 36.42           N  
ATOM   1097  N   TRP B  53      37.188   4.636   4.194  1.00 36.65           N  
ATOM   1098  CA  TRP B  53      36.255   3.520   4.001  1.00 37.27           C  
ATOM   1099  C   TRP B  53      35.318   3.238   5.167  1.00 36.39           C  
ATOM   1100  O   TRP B  53      34.332   2.538   4.970  1.00 36.75           O  
ATOM   1101  CB  TRP B  53      36.991   2.252   3.640  1.00 37.93           C  
ATOM   1102  CG  TRP B  53      37.757   2.384   2.435  1.00 41.85           C  
ATOM   1103  CD1 TRP B  53      39.071   2.700   2.348  1.00 44.25           C  
ATOM   1104  CD2 TRP B  53      37.294   2.190   1.097  1.00 45.67           C  
ATOM   1105  NE1 TRP B  53      39.463   2.718   1.033  1.00 46.84           N  
ATOM   1106  CE2 TRP B  53      38.391   2.413   0.243  1.00 47.00           C  
ATOM   1107  CE3 TRP B  53      36.058   1.854   0.528  1.00 48.48           C  
ATOM   1108  CZ2 TRP B  53      38.309   2.310  -1.145  1.00 50.62           C  
ATOM   1109  CZ3 TRP B  53      35.967   1.753  -0.881  1.00 51.78           C  
ATOM   1110  CH2 TRP B  53      37.094   1.982  -1.693  1.00 52.18           C  
ATOM   1111  N   ASP B  54      35.625   3.749   6.367  1.00 35.46           N  
ATOM   1112  CA  ASP B  54      34.785   3.508   7.542  1.00 35.13           C  
ATOM   1113  C   ASP B  54      33.346   3.870   7.214  1.00 35.95           C  
ATOM   1114  O   ASP B  54      33.095   4.839   6.497  1.00 37.52           O  
ATOM   1115  CB  ASP B  54      35.197   4.364   8.745  1.00 34.14           C  
ATOM   1116  CG  ASP B  54      36.625   4.165   9.175  1.00 32.78           C  
ATOM   1117  OD1 ASP B  54      37.356   3.284   8.668  1.00 33.32           O  
ATOM   1118  OD2 ASP B  54      37.104   4.889  10.047  1.00 30.50           O  
ATOM   1119  N   GLU B  55      32.382   3.152   7.762  1.00 36.07           N  
ATOM   1120  CA  GLU B  55      30.972   3.446   7.418  1.00 36.33           C  
ATOM   1121  C   GLU B  55      29.994   2.882   8.423  1.00 36.54           C  
ATOM   1122  O   GLU B  55      30.298   1.962   9.199  1.00 36.23           O  
ATOM   1123  CB  GLU B  55      30.592   2.899   6.056  1.00 35.64           C  
ATOM   1124  CG  GLU B  55      30.864   1.403   5.935  1.00 35.75           C  
ATOM   1125  CD  GLU B  55      30.424   0.782   4.617  1.00 35.87           C  
ATOM   1126  OE1 GLU B  55      30.733  -0.401   4.357  1.00 35.00           O  
ATOM   1127  OE2 GLU B  55      29.771   1.473   3.814  1.00 38.10           O  
ATOM   1128  N   TRP B  56      28.806   3.446   8.385  1.00 36.41           N  
ATOM   1129  CA  TRP B  56      27.737   2.996   9.236  1.00 36.94           C  
ATOM   1130  C   TRP B  56      27.093   1.849   8.540  1.00 36.52           C  
ATOM   1131  O   TRP B  56      26.832   1.922   7.347  1.00 36.52           O  
ATOM   1132  CB  TRP B  56      26.738   4.115   9.494  1.00 36.75           C  
ATOM   1133  CG  TRP B  56      27.226   5.007  10.533  1.00 39.03           C  
ATOM   1134  CD1 TRP B  56      27.866   6.211  10.363  1.00 41.24           C  
ATOM   1135  CD2 TRP B  56      27.136   4.798  11.938  1.00 39.95           C  
ATOM   1136  NE1 TRP B  56      28.154   6.763  11.588  1.00 41.44           N  
ATOM   1137  CE2 TRP B  56      27.710   5.916  12.568  1.00 40.97           C  
ATOM   1138  CE3 TRP B  56      26.606   3.782  12.733  1.00 41.00           C  
ATOM   1139  CZ2 TRP B  56      27.793   6.034  13.942  1.00 43.49           C  
ATOM   1140  CZ3 TRP B  56      26.679   3.895  14.106  1.00 42.43           C  
ATOM   1141  CH2 TRP B  56      27.260   5.013  14.699  1.00 44.41           C  
ATOM   1142  N   VAL B  57      26.847   0.789   9.293  1.00 36.58           N  
ATOM   1143  CA  VAL B  57      26.296  -0.449   8.728  1.00 36.57           C  
ATOM   1144  C   VAL B  57      25.220  -0.989   9.656  1.00 36.59           C  
ATOM   1145  O   VAL B  57      25.377  -0.949  10.878  1.00 36.14           O  
ATOM   1146  CB  VAL B  57      27.451  -1.491   8.592  1.00 36.28           C  
ATOM   1147  CG1 VAL B  57      26.973  -2.769   8.113  1.00 38.25           C  
ATOM   1148  CG2 VAL B  57      28.495  -0.981   7.615  1.00 35.24           C  
ATOM   1149  N   PRO B  58      24.152  -1.547   9.092  1.00 37.09           N  
ATOM   1150  CA  PRO B  58      23.102  -2.146   9.914  1.00 37.71           C  
ATOM   1151  C   PRO B  58      23.586  -3.529  10.373  1.00 37.42           C  
ATOM   1152  O   PRO B  58      24.471  -4.130   9.744  1.00 37.19           O  
ATOM   1153  CB  PRO B  58      21.945  -2.275   8.924  1.00 37.66           C  
ATOM   1154  CG  PRO B  58      22.662  -2.686   7.681  1.00 38.28           C  
ATOM   1155  CD  PRO B  58      23.892  -1.757   7.659  1.00 37.24           C  
ATOM   1156  N   GLU B  59      23.046  -3.974  11.492  1.00 37.01           N  
ATOM   1157  CA  GLU B  59      23.349  -5.254  12.100  1.00 37.71           C  
ATOM   1158  C   GLU B  59      23.495  -6.419  11.133  1.00 36.72           C  
ATOM   1159  O   GLU B  59      24.427  -7.196  11.243  1.00 37.20           O  
ATOM   1160  CB  GLU B  59      22.213  -5.614  13.015  1.00 38.63           C  
ATOM   1161  CG  GLU B  59      22.337  -5.035  14.388  1.00 43.19           C  
ATOM   1162  CD  GLU B  59      22.601  -6.125  15.382  1.00 46.73           C  
ATOM   1163  OE1 GLU B  59      21.812  -6.284  16.321  1.00 45.89           O  
ATOM   1164  OE2 GLU B  59      23.592  -6.842  15.161  1.00 50.08           O  
ATOM   1165  N   SER B  60      22.536  -6.546  10.231  1.00 35.45           N  
ATOM   1166  CA  SER B  60      22.505  -7.606   9.241  1.00 35.27           C  
ATOM   1167  C   SER B  60      23.862  -7.836   8.554  1.00 33.68           C  
ATOM   1168  O   SER B  60      24.207  -8.921   8.281  1.00 33.52           O  
ATOM   1169  CB  SER B  60      21.380  -7.342   8.231  1.00 35.49           C  
ATOM   1170  OG  SER B  60      21.863  -7.065   6.924  1.00 38.24           O  
ATOM   1171  N   ARG B  61      24.649  -6.806   8.287  1.00 33.00           N  
ATOM   1172  CA  ARG B  61      25.935  -7.024   7.604  1.00 30.66           C  
ATOM   1173  C   ARG B  61      27.068  -7.429   8.530  1.00 27.79           C  
ATOM   1174  O   ARG B  61      28.162  -7.723   8.093  1.00 26.14           O  
ATOM   1175  CB  ARG B  61      26.313  -5.761   6.860  1.00 31.84           C  
ATOM   1176  CG  ARG B  61      25.475  -5.584   5.635  1.00 34.53           C  
ATOM   1177  CD  ARG B  61      25.690  -4.307   4.901  1.00 35.63           C  
ATOM   1178  NE  ARG B  61      27.101  -4.061   4.627  1.00 37.79           N  
ATOM   1179  CZ  ARG B  61      27.604  -2.820   4.436  1.00 36.32           C  
ATOM   1180  NH1 ARG B  61      26.779  -1.764   4.504  1.00 34.51           N  
ATOM   1181  NH2 ARG B  61      28.906  -2.652   4.177  1.00 30.74           N  
ATOM   1182  N   VAL B  62      26.807  -7.471   9.825  1.00 26.48           N  
ATOM   1183  CA  VAL B  62      27.906  -7.740  10.754  1.00 25.96           C  
ATOM   1184  C   VAL B  62      27.878  -9.140  11.294  1.00 25.58           C  
ATOM   1185  O   VAL B  62      26.844  -9.598  11.708  1.00 25.14           O  
ATOM   1186  CB  VAL B  62      27.945  -6.717  11.880  1.00 25.97           C  
ATOM   1187  CG1 VAL B  62      29.201  -6.919  12.770  1.00 24.71           C  
ATOM   1188  CG2 VAL B  62      27.955  -5.327  11.239  1.00 26.58           C  
ATOM   1189  N   LEU B  63      29.027  -9.810  11.295  1.00 25.21           N  
ATOM   1190  CA  LEU B  63      29.095 -11.185  11.797  1.00 25.75           C  
ATOM   1191  C   LEU B  63      30.137 -11.381  12.902  1.00 25.90           C  
ATOM   1192  O   LEU B  63      31.222 -10.794  12.870  1.00 26.14           O  
ATOM   1193  CB  LEU B  63      29.354 -12.148  10.632  1.00 25.02           C  
ATOM   1194  CG  LEU B  63      28.182 -12.438   9.669  1.00 27.11           C  
ATOM   1195  CD1 LEU B  63      28.697 -13.294   8.542  1.00 28.09           C  
ATOM   1196  CD2 LEU B  63      27.027 -13.243  10.403  1.00 27.69           C  
ATOM   1197  N   LYS B  64      29.817 -12.220  13.866  1.00 25.87           N  
ATOM   1198  CA  LYS B  64      30.720 -12.539  14.951  1.00 26.92           C  
ATOM   1199  C   LYS B  64      32.024 -13.214  14.437  1.00 27.11           C  
ATOM   1200  O   LYS B  64      32.027 -14.038  13.486  1.00 26.09           O  
ATOM   1201  CB  LYS B  64      29.983 -13.434  15.963  1.00 26.96           C  
ATOM   1202  CG  LYS B  64      30.007 -12.959  17.432  1.00 30.58           C  
ATOM   1203  CD  LYS B  64      29.196 -11.780  17.760  1.00 32.37           C  
ATOM   1204  CE  LYS B  64      29.406 -11.439  19.211  1.00 32.40           C  
ATOM   1205  NZ  LYS B  64      29.082 -10.086  19.683  1.00 27.99           N  
ATOM   1206  N   TYR B  65      33.127 -12.892  15.086  1.00 26.28           N  
ATOM   1207  CA  TYR B  65      34.395 -13.413  14.641  1.00 27.28           C  
ATOM   1208  C   TYR B  65      34.624 -14.815  15.233  1.00 27.15           C  
ATOM   1209  O   TYR B  65      35.257 -14.932  16.231  1.00 26.52           O  
ATOM   1210  CB  TYR B  65      35.517 -12.464  15.033  1.00 27.70           C  
ATOM   1211  CG  TYR B  65      36.808 -12.704  14.271  1.00 29.34           C  
ATOM   1212  CD1 TYR B  65      37.040 -12.101  13.058  1.00 28.45           C  
ATOM   1213  CD2 TYR B  65      37.797 -13.554  14.782  1.00 30.86           C  
ATOM   1214  CE1 TYR B  65      38.255 -12.333  12.354  1.00 29.56           C  
ATOM   1215  CE2 TYR B  65      38.979 -13.789  14.077  1.00 30.92           C  
ATOM   1216  CZ  TYR B  65      39.193 -13.164  12.869  1.00 30.94           C  
ATOM   1217  OH  TYR B  65      40.371 -13.412  12.162  1.00 33.70           O  
ATOM   1218  N   VAL B  66      34.043 -15.847  14.630  1.00 27.07           N  
ATOM   1219  CA  VAL B  66      34.133 -17.198  15.180  1.00 26.83           C  
ATOM   1220  C   VAL B  66      34.324 -18.184  14.046  1.00 27.97           C  
ATOM   1221  O   VAL B  66      34.037 -17.865  12.888  1.00 27.74           O  
ATOM   1222  CB  VAL B  66      32.835 -17.571  15.966  1.00 27.05           C  
ATOM   1223  CG1 VAL B  66      32.727 -16.807  17.286  1.00 23.57           C  
ATOM   1224  CG2 VAL B  66      31.594 -17.350  15.133  1.00 25.42           C  
ATOM   1225  N   ASP B  67      34.809 -19.384  14.364  1.00 29.40           N  
ATOM   1226  CA  ASP B  67      35.092 -20.375  13.327  1.00 30.16           C  
ATOM   1227  C   ASP B  67      34.055 -20.519  12.260  1.00 29.60           C  
ATOM   1228  O   ASP B  67      34.363 -20.515  11.099  1.00 30.93           O  
ATOM   1229  CB  ASP B  67      35.457 -21.727  13.948  1.00 30.77           C  
ATOM   1230  CG  ASP B  67      36.747 -21.652  14.713  1.00 35.05           C  
ATOM   1231  OD1 ASP B  67      37.544 -20.755  14.377  1.00 38.91           O  
ATOM   1232  OD2 ASP B  67      37.061 -22.402  15.678  1.00 38.57           O  
ATOM   1233  N   THR B  68      32.811 -20.654  12.628  1.00 29.63           N  
ATOM   1234  CA  THR B  68      31.778 -20.805  11.635  1.00 30.79           C  
ATOM   1235  C   THR B  68      31.776 -19.698  10.591  1.00 28.47           C  
ATOM   1236  O   THR B  68      31.550 -19.947   9.400  1.00 28.23           O  
ATOM   1237  CB  THR B  68      30.392 -20.860  12.341  1.00 31.94           C  
ATOM   1238  OG1 THR B  68      30.238 -22.170  12.858  1.00 38.38           O  
ATOM   1239  CG2 THR B  68      29.274 -20.865  11.336  1.00 34.14           C  
ATOM   1240  N   ASN B  69      31.916 -18.462  11.040  1.00 26.56           N  
ATOM   1241  CA  ASN B  69      31.848 -17.358  10.088  1.00 24.95           C  
ATOM   1242  C   ASN B  69      33.159 -17.204   9.364  1.00 23.84           C  
ATOM   1243  O   ASN B  69      33.146 -16.795   8.220  1.00 22.07           O  
ATOM   1244  CB  ASN B  69      31.396 -16.058  10.750  1.00 25.37           C  
ATOM   1245  CG  ASN B  69      29.954 -16.157  11.259  1.00 25.76           C  
ATOM   1246  OD1 ASN B  69      29.098 -16.843  10.664  1.00 24.39           O  
ATOM   1247  ND2 ASN B  69      29.687 -15.482  12.338  1.00 24.70           N  
ATOM   1248  N   LEU B  70      34.281 -17.567   9.990  1.00 24.03           N  
ATOM   1249  CA  LEU B  70      35.560 -17.527   9.248  1.00 26.09           C  
ATOM   1250  C   LEU B  70      35.502 -18.537   8.089  1.00 27.66           C  
ATOM   1251  O   LEU B  70      35.928 -18.229   6.982  1.00 27.74           O  
ATOM   1252  CB  LEU B  70      36.742 -17.849  10.140  1.00 26.02           C  
ATOM   1253  CG  LEU B  70      37.182 -16.666  11.016  1.00 27.15           C  
ATOM   1254  CD1 LEU B  70      38.265 -17.037  12.072  1.00 24.63           C  
ATOM   1255  CD2 LEU B  70      37.598 -15.426  10.107  1.00 27.27           C  
ATOM   1256  N   GLN B  71      34.929 -19.720   8.340  1.00 28.67           N  
ATOM   1257  CA  GLN B  71      34.776 -20.712   7.281  1.00 30.55           C  
ATOM   1258  C   GLN B  71      33.859 -20.150   6.172  1.00 30.62           C  
ATOM   1259  O   GLN B  71      34.099 -20.331   4.987  1.00 30.84           O  
ATOM   1260  CB  GLN B  71      34.185 -22.010   7.845  1.00 31.61           C  
ATOM   1261  CG  GLN B  71      33.911 -23.091   6.771  1.00 35.16           C  
ATOM   1262  CD  GLN B  71      35.226 -23.582   6.125  1.00 40.75           C  
ATOM   1263  OE1 GLN B  71      36.271 -23.628   6.788  1.00 41.48           O  
ATOM   1264  NE2 GLN B  71      35.166 -23.946   4.834  1.00 43.45           N  
ATOM   1265  N   LYS B  72      32.814 -19.435   6.555  1.00 30.21           N  
ATOM   1266  CA  LYS B  72      31.945 -18.878   5.537  1.00 29.85           C  
ATOM   1267  C   LYS B  72      32.791 -17.888   4.750  1.00 28.37           C  
ATOM   1268  O   LYS B  72      32.713 -17.836   3.521  1.00 26.63           O  
ATOM   1269  CB  LYS B  72      30.708 -18.164   6.150  1.00 30.87           C  
ATOM   1270  CG  LYS B  72      29.852 -17.308   5.124  1.00 33.81           C  
ATOM   1271  CD  LYS B  72      28.754 -16.422   5.832  1.00 38.08           C  
ATOM   1272  CE  LYS B  72      27.568 -17.244   6.370  1.00 39.48           C  
ATOM   1273  NZ  LYS B  72      26.821 -17.773   5.248  1.00 40.91           N  
ATOM   1274  N   GLN B  73      33.592 -17.097   5.462  1.00 27.37           N  
ATOM   1275  CA  GLN B  73      34.458 -16.117   4.780  1.00 27.88           C  
ATOM   1276  C   GLN B  73      35.371 -16.786   3.718  1.00 27.66           C  
ATOM   1277  O   GLN B  73      35.503 -16.315   2.597  1.00 26.59           O  
ATOM   1278  CB  GLN B  73      35.322 -15.309   5.763  1.00 27.24           C  
ATOM   1279  CG  GLN B  73      36.375 -14.433   5.048  1.00 27.44           C  
ATOM   1280  CD  GLN B  73      37.270 -13.610   6.001  1.00 28.83           C  
ATOM   1281  OE1 GLN B  73      37.826 -14.153   6.957  1.00 31.20           O  
ATOM   1282  NE2 GLN B  73      37.419 -12.318   5.717  1.00 27.22           N  
ATOM   1283  N   ARG B  74      35.986 -17.871   4.127  1.00 29.15           N  
ATOM   1284  CA  ARG B  74      36.904 -18.688   3.315  1.00 32.37           C  
ATOM   1285  C   ARG B  74      36.144 -19.168   2.045  1.00 32.51           C  
ATOM   1286  O   ARG B  74      36.639 -19.050   0.912  1.00 33.01           O  
ATOM   1287  CB  ARG B  74      37.269 -19.894   4.181  1.00 33.32           C  
ATOM   1288  CG  ARG B  74      38.660 -20.454   4.068  1.00 39.67           C  
ATOM   1289  CD  ARG B  74      39.284 -20.947   5.443  1.00 42.47           C  
ATOM   1290  NE  ARG B  74      39.830 -19.828   6.214  1.00 46.93           N  
ATOM   1291  CZ  ARG B  74      39.706 -19.695   7.551  1.00 48.59           C  
ATOM   1292  NH1 ARG B  74      39.054 -20.626   8.249  1.00 49.10           N  
ATOM   1293  NH2 ARG B  74      40.222 -18.639   8.181  1.00 47.47           N  
ATOM   1294  N   GLU B  75      34.925 -19.665   2.273  1.00 31.30           N  
ATOM   1295  CA  GLU B  75      34.076 -20.201   1.226  1.00 30.99           C  
ATOM   1296  C   GLU B  75      33.669 -19.126   0.243  1.00 30.66           C  
ATOM   1297  O   GLU B  75      33.613 -19.389  -0.956  1.00 29.63           O  
ATOM   1298  CB  GLU B  75      32.839 -20.964   1.810  1.00 31.41           C  
ATOM   1299  CG  GLU B  75      33.148 -22.343   2.425  1.00 31.72           C  
ATOM   1300  CD  GLU B  75      31.931 -23.046   3.084  1.00 34.66           C  
ATOM   1301  OE1 GLU B  75      30.799 -22.563   3.006  1.00 33.67           O  
ATOM   1302  OE2 GLU B  75      32.106 -24.110   3.722  1.00 37.18           O  
ATOM   1303  N   LEU B  76      33.436 -17.902   0.723  1.00 30.51           N  
ATOM   1304  CA  LEU B  76      33.056 -16.828  -0.194  1.00 31.71           C  
ATOM   1305  C   LEU B  76      34.256 -16.375  -1.017  1.00 32.75           C  
ATOM   1306  O   LEU B  76      34.103 -15.971  -2.159  1.00 32.44           O  
ATOM   1307  CB  LEU B  76      32.449 -15.612   0.504  1.00 31.07           C  
ATOM   1308  CG  LEU B  76      31.104 -15.732   1.202  1.00 31.65           C  
ATOM   1309  CD1 LEU B  76      30.769 -14.404   1.814  1.00 31.54           C  
ATOM   1310  CD2 LEU B  76      30.068 -16.105   0.171  1.00 32.05           C  
ATOM   1311  N   GLN B  77      35.447 -16.406  -0.426  1.00 34.03           N  
ATOM   1312  CA  GLN B  77      36.640 -16.036  -1.178  1.00 36.00           C  
ATOM   1313  C   GLN B  77      36.948 -17.053  -2.276  1.00 37.02           C  
ATOM   1314  O   GLN B  77      37.377 -16.687  -3.352  1.00 36.85           O  
ATOM   1315  CB  GLN B  77      37.825 -15.882  -0.246  1.00 35.88           C  
ATOM   1316  CG  GLN B  77      37.652 -14.676   0.670  1.00 38.51           C  
ATOM   1317  CD  GLN B  77      38.643 -14.662   1.825  1.00 39.41           C  
ATOM   1318  OE1 GLN B  77      39.192 -15.702   2.206  1.00 39.97           O  
ATOM   1319  NE2 GLN B  77      38.877 -13.487   2.373  1.00 40.35           N  
ATOM   1320  N   LYS B  78      36.760 -18.324  -1.971  1.00 38.92           N  
ATOM   1321  CA  LYS B  78      36.940 -19.395  -2.926  1.00 41.56           C  
ATOM   1322  C   LYS B  78      35.941 -19.227  -4.066  1.00 42.54           C  
ATOM   1323  O   LYS B  78      36.306 -19.312  -5.233  1.00 42.05           O  
ATOM   1324  CB  LYS B  78      36.657 -20.720  -2.213  1.00 42.57           C  
ATOM   1325  CG  LYS B  78      36.956 -22.001  -2.990  1.00 45.65           C  
ATOM   1326  CD  LYS B  78      36.727 -23.172  -2.006  1.00 51.06           C  
ATOM   1327  CE  LYS B  78      37.075 -24.567  -2.552  1.00 53.63           C  
ATOM   1328  NZ  LYS B  78      36.662 -25.675  -1.583  1.00 53.87           N  
ATOM   1329  N   ALA B  79      34.665 -19.003  -3.727  1.00 43.66           N  
ATOM   1330  CA  ALA B  79      33.640 -18.825  -4.758  1.00 44.95           C  
ATOM   1331  C   ALA B  79      34.024 -17.670  -5.667  1.00 46.22           C  
ATOM   1332  O   ALA B  79      33.826 -17.706  -6.883  1.00 44.96           O  
ATOM   1333  CB  ALA B  79      32.267 -18.567  -4.142  1.00 44.12           C  
ATOM   1334  N   ASN B  80      34.555 -16.624  -5.062  1.00 48.51           N  
ATOM   1335  CA  ASN B  80      34.966 -15.478  -5.846  1.00 51.03           C  
ATOM   1336  C   ASN B  80      36.197 -15.770  -6.693  1.00 51.74           C  
ATOM   1337  O   ASN B  80      36.359 -15.196  -7.747  1.00 51.02           O  
ATOM   1338  CB  ASN B  80      35.201 -14.272  -4.962  1.00 51.85           C  
ATOM   1339  CG  ASN B  80      34.105 -13.235  -5.104  1.00 55.25           C  
ATOM   1340  OD1 ASN B  80      32.927 -13.495  -4.782  1.00 57.22           O  
ATOM   1341  ND2 ASN B  80      34.475 -12.056  -5.624  1.00 56.82           N  
ATOM   1342  N   GLN B  81      37.058 -16.657  -6.219  1.00 53.55           N  
ATOM   1343  CA  GLN B  81      38.243 -17.031  -6.982  1.00 56.21           C  
ATOM   1344  C   GLN B  81      37.804 -17.899  -8.154  1.00 57.28           C  
ATOM   1345  O   GLN B  81      38.392 -17.834  -9.223  1.00 57.24           O  
ATOM   1346  CB  GLN B  81      39.282 -17.763  -6.121  1.00 56.13           C  
ATOM   1347  CG  GLN B  81      40.394 -16.839  -5.569  1.00 58.18           C  
ATOM   1348  CD  GLN B  81      40.164 -16.353  -4.118  1.00 59.81           C  
ATOM   1349  OE1 GLN B  81      40.379 -17.112  -3.158  1.00 59.22           O  
ATOM   1350  NE2 GLN B  81      39.760 -15.081  -3.962  1.00 60.46           N  
ATOM   1351  N   GLU B  82      36.757 -18.687  -7.939  1.00 58.87           N  
ATOM   1352  CA  GLU B  82      36.217 -19.544  -8.969  1.00 61.23           C  
ATOM   1353  C   GLU B  82      35.470 -18.742 -10.005  1.00 63.06           C  
ATOM   1354  O   GLU B  82      35.280 -19.202 -11.123  1.00 62.91           O  
ATOM   1355  CB  GLU B  82      35.295 -20.597  -8.383  1.00 60.98           C  
ATOM   1356  CG  GLU B  82      36.031 -21.786  -7.808  1.00 61.84           C  
ATOM   1357  CD  GLU B  82      35.142 -22.630  -6.912  1.00 62.46           C  
ATOM   1358  OE1 GLU B  82      35.535 -23.771  -6.582  1.00 62.90           O  
ATOM   1359  OE2 GLU B  82      34.052 -22.147  -6.532  1.00 61.57           O  
ATOM   1360  N   GLN B  83      35.043 -17.543  -9.638  1.00 65.39           N  
ATOM   1361  CA  GLN B  83      34.359 -16.708 -10.600  1.00 68.32           C  
ATOM   1362  C   GLN B  83      35.379 -15.965 -11.428  1.00 70.26           C  
ATOM   1363  O   GLN B  83      35.172 -15.760 -12.617  1.00 70.22           O  
ATOM   1364  CB  GLN B  83      33.405 -15.737  -9.917  1.00 68.58           C  
ATOM   1365  CG  GLN B  83      32.144 -16.410  -9.414  1.00 70.10           C  
ATOM   1366  CD  GLN B  83      31.141 -15.429  -8.843  1.00 72.10           C  
ATOM   1367  OE1 GLN B  83      31.424 -14.746  -7.849  1.00 72.49           O  
ATOM   1368  NE2 GLN B  83      29.964 -15.358  -9.463  1.00 72.76           N  
ATOM   1369  N   TYR B  84      36.482 -15.569 -10.793  1.00 72.79           N  
ATOM   1370  CA  TYR B  84      37.566 -14.875 -11.477  1.00 75.51           C  
ATOM   1371  C   TYR B  84      38.311 -15.847 -12.394  1.00 77.21           C  
ATOM   1372  O   TYR B  84      38.932 -15.437 -13.371  1.00 77.06           O  
ATOM   1373  CB  TYR B  84      38.528 -14.251 -10.464  1.00 75.78           C  
ATOM   1374  CG  TYR B  84      39.696 -13.500 -11.078  1.00 77.27           C  
ATOM   1375  CD1 TYR B  84      39.538 -12.214 -11.590  1.00 78.12           C  
ATOM   1376  CD2 TYR B  84      40.966 -14.075 -11.136  1.00 78.36           C  
ATOM   1377  CE1 TYR B  84      40.607 -11.526 -12.152  1.00 78.66           C  
ATOM   1378  CE2 TYR B  84      42.042 -13.387 -11.697  1.00 78.87           C  
ATOM   1379  CZ  TYR B  84      41.853 -12.119 -12.202  1.00 79.02           C  
ATOM   1380  OH  TYR B  84      42.913 -11.445 -12.759  1.00 79.85           O  
ATOM   1381  N   ALA B  85      38.230 -17.137 -12.070  1.00 79.48           N  
ATOM   1382  CA  ALA B  85      38.882 -18.181 -12.843  1.00 81.77           C  
ATOM   1383  C   ALA B  85      38.090 -18.436 -14.107  1.00 83.58           C  
ATOM   1384  O   ALA B  85      38.624 -18.897 -15.103  1.00 83.96           O  
ATOM   1385  CB  ALA B  85      38.996 -19.458 -12.026  1.00 81.67           C  
ATOM   1386  N   GLU B  86      36.807 -18.119 -14.070  1.00 85.74           N  
ATOM   1387  CA  GLU B  86      35.959 -18.362 -15.222  1.00 88.05           C  
ATOM   1388  C   GLU B  86      35.782 -17.110 -16.066  1.00 89.07           C  
ATOM   1389  O   GLU B  86      35.075 -17.123 -17.076  1.00 89.29           O  
ATOM   1390  CB  GLU B  86      34.619 -18.964 -14.785  1.00 88.56           C  
ATOM   1391  CG  GLU B  86      34.805 -20.320 -14.119  1.00 90.48           C  
ATOM   1392  CD  GLU B  86      33.547 -20.869 -13.468  1.00 92.89           C  
ATOM   1393  OE1 GLU B  86      32.460 -20.268 -13.642  1.00 94.11           O  
ATOM   1394  OE2 GLU B  86      33.653 -21.914 -12.783  1.00 93.69           O  
ATOM   1395  N   GLY B  87      36.436 -16.034 -15.652  1.00 90.09           N  
ATOM   1396  CA  GLY B  87      36.410 -14.804 -16.407  1.00 91.42           C  
ATOM   1397  C   GLY B  87      37.599 -14.842 -17.335  1.00 92.50           C  
ATOM   1398  O   GLY B  87      37.556 -14.304 -18.443  1.00 92.53           O  
ATOM   1399  N   LYS B  88      38.655 -15.505 -16.868  1.00 93.50           N  
ATOM   1400  CA  LYS B  88      39.900 -15.639 -17.613  1.00 94.57           C  
ATOM   1401  C   LYS B  88      39.779 -16.722 -18.677  1.00 95.56           C  
ATOM   1402  O   LYS B  88      40.669 -16.887 -19.508  1.00 95.76           O  
ATOM   1403  CB  LYS B  88      41.063 -15.952 -16.666  1.00 94.46           C  
ATOM   1404  CG  LYS B  88      41.438 -14.799 -15.755  1.00 94.25           C  
ATOM   1405  CD  LYS B  88      42.450 -15.198 -14.687  1.00 93.94           C  
ATOM   1406  CE  LYS B  88      43.892 -15.173 -15.191  1.00 93.83           C  
ATOM   1407  NZ  LYS B  88      44.414 -16.541 -15.428  1.00 93.60           N  
ATOM   1408  N   MET B  89      38.677 -17.462 -18.651  1.00 96.61           N  
ATOM   1409  CA  MET B  89      38.458 -18.509 -19.638  1.00 97.73           C  
ATOM   1410  C   MET B  89      37.572 -18.032 -20.796  1.00 98.84           C  
ATOM   1411  O   MET B  89      37.155 -18.834 -21.630  1.00 98.83           O  
ATOM   1412  CB  MET B  89      37.870 -19.764 -18.987  1.00 97.48           C  
ATOM   1413  CG  MET B  89      38.904 -20.722 -18.399  1.00 96.92           C  
ATOM   1414  SD  MET B  89      38.252 -22.401 -18.170  1.00 96.00           S  
ATOM   1415  CE  MET B  89      37.601 -22.335 -16.515  1.00 96.20           C  
ATOM   1416  N   ARG B  90      37.295 -16.731 -20.848  1.00100.16           N  
ATOM   1417  CA  ARG B  90      36.469 -16.163 -21.914  1.00101.50           C  
ATOM   1418  C   ARG B  90      37.141 -14.963 -22.588  1.00101.66           C  
ATOM   1419  O   ARG B  90      36.798 -13.801 -22.359  1.00101.72           O  
ATOM   1420  CB  ARG B  90      35.099 -15.753 -21.374  1.00102.17           C  
ATOM   1421  CG  ARG B  90      35.156 -14.604 -20.386  1.00104.50           C  
ATOM   1422  CD  ARG B  90      33.807 -14.187 -19.841  1.00108.02           C  
ATOM   1423  NE  ARG B  90      33.899 -12.980 -19.023  1.00110.75           N  
ATOM   1424  CZ  ARG B  90      32.972 -12.601 -18.150  1.00112.52           C  
ATOM   1425  NH1 ARG B  90      31.878 -13.335 -17.981  1.00113.19           N  
ATOM   1426  NH2 ARG B  90      33.133 -11.486 -17.446  1.00113.32           N  
ATOM   1427  OXT ARG B  90      38.055 -15.101 -23.403  1.00101.85           O  
TER    1428      ARG B  90                                                      
END
MOLECULE T0429_22_99.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
END
