
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   59 (  465),  selected   59 , name 1mhn_A
# Molecule2: number of CA atoms   59 (  475),  selected   59 , name T0429_22_99.pdb
# PARAMETERS: 1mhn_A.T0429_22_99.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    89_A      E      22           -
LGA    Q    90_A      T      23           -
LGA    -       -      E      24           -
LGA    -       -      L      25           -
LGA    Q    91_A      L      27          1.915
LGA    W    92_A      Y      28          0.984
LGA    K    93_A      K      29          0.737
LGA    V    94_A      V      30          0.649
LGA    G    95_A      N      31          0.499
LGA    D    96_A      E      32          0.595
LGA    K    97_A      Y      33          0.323
LGA    C    98_A      V      34          0.312
LGA    S    99_A      D      35          0.162
LGA    A   100_A      A      36          1.204
LGA    I   101_A      R      37          0.843
LGA    W   102_A      D      38          0.915
LGA    S   103_A      T      39          2.188
LGA    E   104_A      N      40          3.094
LGA    D   105_A      M      41          2.304
LGA    G   106_A      G      42          1.712
LGA    C   107_A      A      43          1.122
LGA    I   108_A      W      44          0.800
LGA    Y   109_A      F      45          0.240
LGA    P   110_A      E      46          0.244
LGA    A   111_A      A      47          0.298
LGA    T   112_A      Q      48          0.208
LGA    I   113_A      V      49          0.397
LGA    A   114_A      V      50          0.864
LGA    S   115_A      R      51          0.746
LGA    I   116_A      V      52          0.642
LGA    D   117_A      T      53          0.602
LGA    F   118_A      R      54          2.649
LGA    K   119_A      E      73           -
LGA    R   120_A      D      74          5.061
LGA    E   121_A      V      75          1.061
LGA    T   122_A      I      76          0.547
LGA    C   123_A      Y      77          1.023
LGA    V   124_A      H      78          1.209
LGA    V   125_A      V      79          0.924
LGA    V   126_A      K      80          0.738
LGA    Y   127_A      Y      81          1.077
LGA    T   128_A      D      82          0.783
LGA    G   129_A      D      83          1.606
LGA    Y   130_A      Y      84          0.624
LGA    G   131_A      P      85          1.126
LGA    -       -      E      86           -
LGA    N   132_A      N      87          1.466
LGA    -       -      G      88           -
LGA    R   133_A      V      89          3.104
LGA    E   134_A      V      90          1.829
LGA    E   135_A      Q      91          1.261
LGA    Q   136_A      M      92          1.040
LGA    N   137_A      N      93          1.511
LGA    L   138_A      S      94          1.927
LGA    S   139_A      R      95          3.082
LGA    D   140_A      D      96          2.709
LGA    L   141_A      V      97          1.253
LGA    L   142_A      R      98          1.807
LGA    S   143_A      A      99          1.911
LGA    P   144_A      -       -           -
LGA    I   145_A      -       -           -
LGA    C   146_A      -       -           -
LGA    E   147_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   59   59    5.0     52    1.58    21.15     82.359     3.099

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.064485 * X  +   0.886407 * Y  +  -0.458392 * Z  +  39.990242
  Y_new =   0.771783 * X  +  -0.246894 * Y  +  -0.585998 * Z  +  -5.369977
  Z_new =  -0.632608 * X  +  -0.391567 * Y  +  -0.668193 * Z  +   7.777274 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.611524    0.530069  [ DEG:  -149.6293     30.3707 ]
  Theta =   0.684916    2.456677  [ DEG:    39.2428    140.7572 ]
  Phi   =   1.654156   -1.487437  [ DEG:    94.7761    -85.2239 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1mhn_A                                        
REMARK     2: T0429_22_99.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1mhn_A.T0429_22_99.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   59   59   5.0   52   1.58   21.15  82.359
REMARK  ---------------------------------------------------------- 
MOLECULE 1mhn_A
HEADER    RNA BINDING PROTEIN                     20-AUG-02   1MHN              
TITLE     HIGH RESOLUTION CRYSTAL STRUCTURE OF THE SMN TUDOR DOMAIN             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SURVIVAL MOTOR NEURON PROTEIN;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 SYNONYM: SMN, COMPONENT OF GEMS 1, GEMIN1;                           
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SMN1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PET24D (MODIFIED)                     
KEYWDS    SMN, SMA, SPINAL MUSCULAR ATROPHY                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.SPRANGERS,M.R.GROVES,I.SINNING,M.SATTLER                            
REVDAT   1   25-MAR-03 1MHN    0                                                
JRNL        AUTH   R.SPRANGERS,M.R.GROVES,I.SINNING,M.SATTLER                   
JRNL        TITL   HIGH RESOLUTION X-RAY AND NMR STRUCTURES OF THE              
JRNL        TITL 2 SMN TUDOR DOMAIN: CONFORMATIONAL VARIATION IN THE            
JRNL        TITL 3 BINDING SITE FOR SYMMETRICALLY DIMETHYLATED                  
JRNL        TITL 4 ARGININE RESIDUES                                            
JRNL        REF    J.MOL.BIOL.                   V. 327   507 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1MHN A   89   147  UNP    Q16637   SMN_HUMAN       89    147             
SEQRES   1 A   59  LEU GLN GLN TRP LYS VAL GLY ASP LYS CYS SER ALA ILE          
SEQRES   2 A   59  TRP SER GLU ASP GLY CYS ILE TYR PRO ALA THR ILE ALA          
SEQRES   3 A   59  SER ILE ASP PHE LYS ARG GLU THR CYS VAL VAL VAL TYR          
SEQRES   4 A   59  THR GLY TYR GLY ASN ARG GLU GLU GLN ASN LEU SER ASP          
SEQRES   5 A   59  LEU LEU SER PRO ILE CYS GLU                                  
FORMUL   2  HOH   *65(H2 O)                                                     
CRYST1   27.652   27.652  110.299  90.00  90.00 120.00 P 65          6          
ATOM      1  N   LEU A  89      19.944 -11.191  15.803  1.00 24.98           N  
ATOM      2  CA  LEU A  89      21.018 -10.280  16.242  1.00 24.12           C  
ATOM      3  C   LEU A  89      21.907 -11.079  17.157  1.00 23.96           C  
ATOM      4  O   LEU A  89      21.429 -11.940  17.914  1.00 24.32           O  
ATOM      5  CB  LEU A  89      20.456  -9.062  17.014  1.00 23.63           C  
ATOM      6  CG  LEU A  89      19.625  -8.008  16.301  1.00 26.77           C  
ATOM      7  CD1 LEU A  89      18.795  -7.194  17.254  1.00 25.38           C  
ATOM      8  CD2 LEU A  89      20.529  -7.083  15.491  1.00 25.60           C  
ATOM      9  N   GLN A  90      23.209 -10.797  17.102  1.00 22.23           N  
ATOM     10  CA  GLN A  90      24.123 -11.251  18.133  1.00 22.13           C  
ATOM     11  C   GLN A  90      24.492 -10.062  19.025  1.00 20.54           C  
ATOM     12  O   GLN A  90      24.225  -8.894  18.701  1.00 18.15           O  
ATOM     13  CB  GLN A  90      25.370 -11.898  17.506  1.00 22.97           C  
ATOM     14  CG  GLN A  90      25.015 -12.845  16.363  1.00 28.57           C  
ATOM     15  CD  GLN A  90      26.113 -13.796  15.997  1.00 36.43           C  
ATOM     16  OE1 GLN A  90      26.999 -13.453  15.197  1.00 38.45           O  
ATOM     17  NE2 GLN A  90      26.062 -15.013  16.558  1.00 39.04           N  
ATOM     18  N   GLN A  91      25.118 -10.354  20.155  1.00 19.57           N  
ATOM     19  CA  GLN A  91      25.532  -9.321  21.082  1.00 18.47           C  
ATOM     20  C   GLN A  91      26.865  -8.780  20.566  1.00 18.52           C  
ATOM     21  O   GLN A  91      27.893  -9.515  20.376  1.00 20.83           O  
ATOM     22  CB  GLN A  91      25.675  -9.863  22.526  1.00 19.16           C  
ATOM     23  CG  GLN A  91      24.352 -10.268  23.155  1.00 22.55           C  
ATOM     24  CD  GLN A  91      24.479 -11.206  24.376  1.00 28.43           C  
ATOM     25  OE1 GLN A  91      25.474 -11.942  24.535  1.00 33.66           O  
ATOM     26  NE2 GLN A  91      23.461 -11.196  25.217  1.00 27.12           N  
ATOM     27  N   TRP A  92      26.854  -7.500  20.306  1.00 16.19           N  
ATOM     28  CA  TRP A  92      28.040  -6.847  19.838  1.00 14.81           C  
ATOM     29  C   TRP A  92      28.307  -5.679  20.766  1.00 15.35           C  
ATOM     30  O   TRP A  92      27.370  -5.109  21.365  1.00 15.05           O  
ATOM     31  CB  TRP A  92      27.788  -6.352  18.419  1.00 14.17           C  
ATOM     32  CG  TRP A  92      27.669  -7.471  17.442  1.00 12.91           C  
ATOM     33  CD1 TRP A  92      26.512  -7.918  16.830  1.00 13.33           C  
ATOM     34  CD2 TRP A  92      28.727  -8.311  16.948  1.00 13.52           C  
ATOM     35  NE1 TRP A  92      26.792  -8.951  15.967  1.00 15.53           N  
ATOM     36  CE2 TRP A  92      28.142  -9.227  16.029  1.00 15.15           C  
ATOM     37  CE3 TRP A  92      30.120  -8.370  17.169  1.00 11.66           C  
ATOM     38  CZ2 TRP A  92      28.901 -10.201  15.341  1.00 15.45           C  
ATOM     39  CZ3 TRP A  92      30.870  -9.328  16.489  1.00 12.34           C  
ATOM     40  CH2 TRP A  92      30.253 -10.237  15.580  1.00 13.15           C  
ATOM     41  N   LYS A  93      29.573  -5.272  20.806  1.00 15.43           N  
ATOM     42  CA  LYS A  93      29.945  -4.084  21.557  1.00 14.65           C  
ATOM     43  C   LYS A  93      30.954  -3.275  20.767  1.00 14.04           C  
ATOM     44  O   LYS A  93      31.642  -3.800  19.876  1.00 12.98           O  
ATOM     45  CB  LYS A  93      30.475  -4.447  22.945  1.00 15.47           C  
ATOM     46  CG  LYS A  93      31.729  -5.220  23.004  1.00 19.62           C  
ATOM     47  CD  LYS A  93      31.721  -6.081  24.308  1.00 27.90           C  
ATOM     48  CE  LYS A  93      32.932  -7.031  24.337  1.00 27.15           C  
ATOM     49  NZ  LYS A  93      34.073  -6.148  24.607  1.00 32.85           N  
ATOM     50  N   VAL A  94      31.037  -2.002  21.075  1.00 12.55           N  
ATOM     51  CA  VAL A  94      31.990  -1.127  20.402  1.00 13.46           C  
ATOM     52  C   VAL A  94      33.374  -1.727  20.636  1.00 13.78           C  
ATOM     53  O   VAL A  94      33.713  -2.195  21.774  1.00 14.88           O  
ATOM     54  CB  VAL A  94      31.910   0.322  20.940  1.00 13.04           C  
ATOM     55  CG1 VAL A  94      33.012   1.208  20.341  1.00 12.39           C  
ATOM     56  CG2 VAL A  94      30.559   0.961  20.575  1.00 14.56           C  
ATOM     57  N   GLY A  95      34.179  -1.734  19.579  1.00 13.03           N  
ATOM     58  CA  GLY A  95      35.537  -2.238  19.676  1.00 13.55           C  
ATOM     59  C   GLY A  95      35.627  -3.725  19.337  1.00 12.52           C  
ATOM     60  O   GLY A  95      36.731  -4.247  19.178  1.00 14.03           O  
ATOM     61  N   ASP A  96      34.498  -4.426  19.260  1.00 13.27           N  
ATOM     62  CA  ASP A  96      34.519  -5.886  18.944  1.00 11.63           C  
ATOM     63  C   ASP A  96      35.100  -6.133  17.578  1.00 12.60           C  
ATOM     64  O   ASP A  96      34.924  -5.309  16.677  1.00 10.59           O  
ATOM     65  CB  ASP A  96      33.126  -6.505  18.921  1.00 12.58           C  
ATOM     66  CG  ASP A  96      32.693  -7.021  20.239  1.00 15.59           C  
ATOM     67  OD1 ASP A  96      33.573  -7.205  21.149  1.00 17.45           O  
ATOM     68  OD2 ASP A  96      31.471  -7.317  20.442  1.00 15.07           O  
ATOM     69  N   LYS A  97      35.839  -7.237  17.429  1.00 10.27           N  
ATOM     70  CA  LYS A  97      36.274  -7.653  16.111  1.00 11.34           C  
ATOM     71  C   LYS A  97      35.126  -8.415  15.449  1.00 10.56           C  
ATOM     72  O   LYS A  97      34.478  -9.270  16.073  1.00 10.62           O  
ATOM     73  CB  LYS A  97      37.446  -8.620  16.219  1.00 10.78           C  
ATOM     74  CG  LYS A  97      38.731  -8.007  16.764  1.00 16.39           C  
ATOM     75  CD  LYS A  97      39.701  -9.251  16.886  1.00 23.84           C  
ATOM     76  CE  LYS A  97      41.110  -8.930  17.340  1.00 31.15           C  
ATOM     77  NZ  LYS A  97      42.073  -9.521  16.361  1.00 33.93           N  
ATOM     78  N   CYS A  98      34.915  -8.180  14.165  1.00 11.64           N  
ATOM     79  CA  CYS A  98      33.875  -8.909  13.468  1.00 10.84           C  
ATOM     80  C   CYS A  98      34.351  -9.014  11.997  1.00 11.41           C  
ATOM     81  O   CYS A  98      35.471  -8.600  11.662  1.00 12.26           O  
ATOM     82  CB  CYS A  98      32.525  -8.160  13.548  1.00 12.56           C  
ATOM     83  SG  CYS A  98      32.549  -6.565  12.700  1.00 13.22           S  
ATOM     84  N   SER A  99      33.506  -9.564  11.128  1.00 10.29           N  
ATOM     85  CA  SER A  99      33.740  -9.434   9.702  1.00  9.74           C  
ATOM     86  C   SER A  99      32.434  -8.965   9.079  1.00  9.45           C  
ATOM     87  O   SER A  99      31.388  -9.071   9.685  1.00  9.89           O  
ATOM     88  CB  SER A  99      34.176 -10.778   9.144  1.00 11.97           C  
ATOM     89  OG  SER A  99      35.489 -11.047   9.709  1.00 10.62           O  
ATOM     90  N   ALA A 100      32.522  -8.344   7.914  1.00 10.80           N  
ATOM     91  CA  ALA A 100      31.293  -7.886   7.287  1.00 10.51           C  
ATOM     92  C   ALA A 100      31.460  -7.839   5.796  1.00 11.16           C  
ATOM     93  O   ALA A 100      32.578  -7.796   5.286  1.00 10.85           O  
ATOM     94  CB  ALA A 100      30.924  -6.463   7.868  1.00 11.66           C  
ATOM     95  N   ILE A 101      30.332  -7.875   5.076  1.00 12.15           N  
ATOM     96  CA  ILE A 101      30.373  -7.733   3.632  1.00 12.14           C  
ATOM     97  C   ILE A 101      30.480  -6.270   3.266  1.00 13.09           C  
ATOM     98  O   ILE A 101      29.574  -5.474   3.570  1.00 12.15           O  
ATOM     99  CB  ILE A 101      29.055  -8.383   3.013  1.00 11.75           C  
ATOM    100  CG1 ILE A 101      28.918  -9.845   3.498  1.00 12.63           C  
ATOM    101  CG2 ILE A 101      29.020  -8.213   1.514  1.00 11.99           C  
ATOM    102  CD1 ILE A 101      27.484 -10.522   3.222  1.00 13.30           C  
ATOM    103  N   TRP A 102      31.532  -5.896   2.558  1.00 13.23           N  
ATOM    104  CA  TRP A 102      31.673  -4.516   2.136  1.00 15.00           C  
ATOM    105  C   TRP A 102      30.766  -4.242   0.933  1.00 16.94           C  
ATOM    106  O   TRP A 102      30.749  -5.022  -0.025  1.00 15.64           O  
ATOM    107  CB  TRP A 102      33.107  -4.286   1.730  1.00 17.63           C  
ATOM    108  CG  TRP A 102      33.546  -2.865   1.701  1.00 19.22           C  
ATOM    109  CD1 TRP A 102      32.771  -1.726   1.608  1.00 20.09           C  
ATOM    110  CD2 TRP A 102      34.902  -2.431   1.781  1.00 21.77           C  
ATOM    111  NE1 TRP A 102      33.587  -0.611   1.624  1.00 22.51           N  
ATOM    112  CE2 TRP A 102      34.897  -1.024   1.743  1.00 23.67           C  
ATOM    113  CE3 TRP A 102      36.138  -3.107   1.918  1.00 23.79           C  
ATOM    114  CZ2 TRP A 102      36.088  -0.272   1.802  1.00 26.89           C  
ATOM    115  CZ3 TRP A 102      37.313  -2.378   1.991  1.00 25.93           C  
ATOM    116  CH2 TRP A 102      37.284  -0.965   1.932  1.00 27.49           C  
ATOM    117  N   SER A 103      30.018  -3.149   0.984  1.00 17.32           N  
ATOM    118  CA  SER A 103      28.988  -2.928  -0.039  1.00 20.48           C  
ATOM    119  C   SER A 103      29.601  -2.551  -1.375  1.00 20.42           C  
ATOM    120  O   SER A 103      28.921  -2.599  -2.414  1.00 20.80           O  
ATOM    121  CB  SER A 103      27.921  -1.902   0.390  1.00 20.20           C  
ATOM    122  OG  SER A 103      28.502  -0.616   0.553  1.00 26.42           O  
ATOM    123  N   GLU A 104      30.874  -2.187  -1.352  1.00 20.34           N  
ATOM    124  CA  GLU A 104      31.567  -1.761  -2.561  1.00 22.28           C  
ATOM    125  C   GLU A 104      31.880  -2.931  -3.493  1.00 20.57           C  
ATOM    126  O   GLU A 104      31.892  -2.777  -4.732  1.00 20.50           O  
ATOM    127  CB  GLU A 104      32.840  -0.976  -2.167  1.00 24.78           C  
ATOM    128  CG  GLU A 104      34.155  -1.469  -2.733  1.00 30.32           C  
ATOM    129  CD  GLU A 104      35.292  -1.359  -1.730  1.00 38.29           C  
ATOM    130  OE1 GLU A 104      35.597  -0.204  -1.312  1.00 39.09           O  
ATOM    131  OE2 GLU A 104      35.847  -2.438  -1.362  1.00 38.17           O  
ATOM    132  N   ASP A 105      32.141  -4.100  -2.934  1.00 18.29           N  
ATOM    133  CA  ASP A 105      32.533  -5.221  -3.802  1.00 17.58           C  
ATOM    134  C   ASP A 105      31.861  -6.532  -3.482  1.00 14.68           C  
ATOM    135  O   ASP A 105      32.075  -7.495  -4.203  1.00 16.83           O  
ATOM    136  CB  ASP A 105      34.065  -5.386  -3.912  1.00 17.63           C  
ATOM    137  CG  ASP A 105      34.682  -5.948  -2.636  1.00 20.47           C  
ATOM    138  OD1 ASP A 105      33.963  -6.061  -1.612  1.00 16.43           O  
ATOM    139  OD2 ASP A 105      35.858  -6.326  -2.584  1.00 20.50           O  
ATOM    140  N   GLY A 106      31.024  -6.568  -2.430  1.00 13.48           N  
ATOM    141  CA  GLY A 106      30.313  -7.771  -2.021  1.00 11.88           C  
ATOM    142  C   GLY A 106      31.192  -8.863  -1.434  1.00 13.55           C  
ATOM    143  O   GLY A 106      30.808 -10.024  -1.450  1.00 13.22           O  
ATOM    144  N   CYS A 107      32.373  -8.482  -0.935  1.00 13.06           N  
ATOM    145  CA  CYS A 107      33.310  -9.453  -0.342  1.00 14.57           C  
ATOM    146  C   CYS A 107      33.364  -9.261   1.160  1.00 13.39           C  
ATOM    147  O   CYS A 107      33.075  -8.176   1.640  1.00 13.06           O  
ATOM    148  CB  CYS A 107      34.705  -9.215  -0.879  1.00 14.21           C  
ATOM    149  SG  CYS A 107      34.843  -9.641  -2.660  1.00 20.69           S  
ATOM    150  N   ILE A 108      33.808 -10.299   1.862  1.00 12.60           N  
ATOM    151  CA  ILE A 108      33.882 -10.260   3.316  1.00 12.49           C  
ATOM    152  C   ILE A 108      35.221  -9.639   3.715  1.00 11.02           C  
ATOM    153  O   ILE A 108      36.248 -10.018   3.132  1.00 11.27           O  
ATOM    154  CB  ILE A 108      33.839 -11.657   3.871  1.00 12.05           C  
ATOM    155  CG1 ILE A 108      32.467 -12.312   3.625  1.00 14.13           C  
ATOM    156  CG2 ILE A 108      34.108 -11.639   5.446  1.00 12.86           C  
ATOM    157  CD1 ILE A 108      32.461 -13.841   3.969  1.00 18.26           C  
ATOM    158  N   TYR A 109      35.230  -8.751   4.725  1.00 10.20           N  
ATOM    159  CA  TYR A 109      36.482  -8.169   5.194  1.00 10.90           C  
ATOM    160  C   TYR A 109      36.493  -8.179   6.685  1.00 11.43           C  
ATOM    161  O   TYR A 109      35.435  -8.063   7.279  1.00 10.59           O  
ATOM    162  CB  TYR A 109      36.628  -6.740   4.725  1.00 12.34           C  
ATOM    163  CG  TYR A 109      36.941  -6.651   3.248  1.00 14.56           C  
ATOM    164  CD1 TYR A 109      35.889  -6.544   2.285  1.00 15.29           C  
ATOM    165  CD2 TYR A 109      38.229  -6.668   2.803  1.00 17.04           C  
ATOM    166  CE1 TYR A 109      36.133  -6.466   0.952  1.00 14.67           C  
ATOM    167  CE2 TYR A 109      38.501  -6.574   1.403  1.00 17.35           C  
ATOM    168  CZ  TYR A 109      37.437  -6.479   0.496  1.00 18.16           C  
ATOM    169  OH  TYR A 109      37.690  -6.364  -0.857  1.00 20.05           O  
ATOM    170  N   PRO A 110      37.675  -8.295   7.331  1.00 11.19           N  
ATOM    171  CA  PRO A 110      37.734  -8.125   8.789  1.00 11.58           C  
ATOM    172  C   PRO A 110      37.409  -6.677   9.140  1.00 10.75           C  
ATOM    173  O   PRO A 110      37.788  -5.742   8.421  1.00 11.36           O  
ATOM    174  CB  PRO A 110      39.232  -8.362   9.111  1.00 10.04           C  
ATOM    175  CG  PRO A 110      39.993  -8.025   7.788  1.00 11.06           C  
ATOM    176  CD  PRO A 110      39.008  -8.544   6.742  1.00 13.79           C  
ATOM    177  N   ALA A 111      36.770  -6.483  10.295  1.00 10.42           N  
ATOM    178  CA  ALA A 111      36.383  -5.148  10.726  1.00 10.95           C  
ATOM    179  C   ALA A 111      36.363  -5.056  12.249  1.00 11.55           C  
ATOM    180  O   ALA A 111      36.432  -6.089  12.932  1.00 10.55           O  
ATOM    181  CB  ALA A 111      35.015  -4.821  10.163  1.00  9.80           C  
ATOM    182  N   THR A 112      36.366  -3.809  12.744  1.00 11.13           N  
ATOM    183  CA  THR A 112      36.152  -3.449  14.163  1.00 12.64           C  
ATOM    184  C   THR A 112      34.896  -2.550  14.236  1.00 12.50           C  
ATOM    185  O   THR A 112      34.695  -1.696  13.372  1.00 13.72           O  
ATOM    186  CB  THR A 112      37.344  -2.617  14.654  1.00 11.23           C  
ATOM    187  OG1 THR A 112      38.554  -3.374  14.437  1.00 17.52           O  
ATOM    188  CG2 THR A 112      37.257  -2.481  16.116  1.00 15.61           C  
ATOM    189  N   ILE A 113      34.051  -2.759  15.252  1.00 12.93           N  
ATOM    190  CA  ILE A 113      32.891  -1.917  15.458  1.00 11.97           C  
ATOM    191  C   ILE A 113      33.300  -0.602  16.099  1.00 12.75           C  
ATOM    192  O   ILE A 113      33.896  -0.598  17.170  1.00 12.84           O  
ATOM    193  CB  ILE A 113      31.823  -2.602  16.304  1.00 12.62           C  
ATOM    194  CG1 ILE A 113      31.356  -3.914  15.637  1.00  9.88           C  
ATOM    195  CG2 ILE A 113      30.633  -1.617  16.513  1.00 10.79           C  
ATOM    196  CD1 ILE A 113      30.478  -4.795  16.575  1.00 10.89           C  
ATOM    197  N   ALA A 114      32.974   0.488  15.421  1.00 13.06           N  
ATOM    198  CA  ALA A 114      33.345   1.863  15.816  1.00 14.44           C  
ATOM    199  C   ALA A 114      32.235   2.533  16.635  1.00 14.15           C  
ATOM    200  O   ALA A 114      32.514   3.392  17.454  1.00 13.53           O  
ATOM    201  CB  ALA A 114      33.611   2.716  14.558  1.00 13.48           C  
ATOM    202  N   SER A 115      30.990   2.176  16.355  1.00 13.78           N  
ATOM    203  CA  SER A 115      29.841   2.800  17.015  1.00 13.59           C  
ATOM    204  C   SER A 115      28.649   1.908  16.793  1.00 12.87           C  
ATOM    205  O   SER A 115      28.586   1.198  15.781  1.00 12.31           O  
ATOM    206  CB  SER A 115      29.569   4.214  16.487  1.00 14.19           C  
ATOM    207  OG  SER A 115      29.197   4.217  15.114  1.00 16.14           O  
ATOM    208  N   ILE A 116      27.711   1.912  17.727  1.00 12.82           N  
ATOM    209  CA  ILE A 116      26.460   1.186  17.501  1.00 13.35           C  
ATOM    210  C   ILE A 116      25.268   2.154  17.760  1.00 13.79           C  
ATOM    211  O   ILE A 116      25.287   2.935  18.701  1.00 15.12           O  
ATOM    212  CB  ILE A 116      26.365  -0.036  18.430  1.00 13.26           C  
ATOM    213  CG1 ILE A 116      27.533  -1.041  18.212  1.00 12.72           C  
ATOM    214  CG2 ILE A 116      25.008  -0.787  18.291  1.00 12.87           C  
ATOM    215  CD1 ILE A 116      27.658  -2.042  19.311  1.00 13.05           C  
ATOM    216  N   ASP A 117      24.264   2.078  16.922  1.00 13.13           N  
ATOM    217  CA  ASP A 117      23.018   2.805  17.137  1.00 14.69           C  
ATOM    218  C   ASP A 117      21.949   1.793  17.398  1.00 15.18           C  
ATOM    219  O   ASP A 117      21.364   1.179  16.473  1.00 15.48           O  
ATOM    220  CB  ASP A 117      22.735   3.671  15.895  1.00 14.24           C  
ATOM    221  CG  ASP A 117      21.452   4.480  16.005  1.00 18.13           C  
ATOM    222  OD1 ASP A 117      20.575   4.163  16.845  1.00 19.47           O  
ATOM    223  OD2 ASP A 117      21.267   5.433  15.242  1.00 20.06           O  
ATOM    224  N   PHE A 118      21.696   1.585  18.690  1.00 15.31           N  
ATOM    225  CA  PHE A 118      20.843   0.492  19.108  1.00 16.43           C  
ATOM    226  C   PHE A 118      19.407   0.748  18.664  1.00 17.80           C  
ATOM    227  O   PHE A 118      18.726  -0.181  18.257  1.00 19.78           O  
ATOM    228  CB  PHE A 118      20.955   0.287  20.628  1.00 15.86           C  
ATOM    229  CG  PHE A 118      22.179  -0.481  21.033  1.00 15.90           C  
ATOM    230  CD1 PHE A 118      23.198   0.132  21.787  1.00 18.31           C  
ATOM    231  CD2 PHE A 118      22.347  -1.802  20.637  1.00 17.37           C  
ATOM    232  CE1 PHE A 118      24.354  -0.572  22.087  1.00 15.60           C  
ATOM    233  CE2 PHE A 118      23.513  -2.517  20.966  1.00 17.36           C  
ATOM    234  CZ  PHE A 118      24.495  -1.900  21.698  1.00 14.32           C  
ATOM    235  N   LYS A 119      18.964   2.000  18.682  1.00 18.51           N  
ATOM    236  CA  LYS A 119      17.571   2.297  18.308  1.00 20.39           C  
ATOM    237  C   LYS A 119      17.279   1.954  16.845  1.00 18.80           C  
ATOM    238  O   LYS A 119      16.183   1.473  16.515  1.00 20.18           O  
ATOM    239  CB  LYS A 119      17.192   3.756  18.607  1.00 21.63           C  
ATOM    240  CG  LYS A 119      16.163   3.901  19.783  1.00 28.48           C  
ATOM    241  CD  LYS A 119      16.413   5.180  20.629  1.00 36.13           C  
ATOM    242  CE  LYS A 119      15.918   5.069  22.099  1.00 38.94           C  
ATOM    243  NZ  LYS A 119      16.912   5.671  23.087  1.00 41.55           N  
ATOM    244  N   ARG A 120      18.268   2.172  15.975  1.00 17.23           N  
ATOM    245  CA  ARG A 120      18.099   1.835  14.562  1.00 15.97           C  
ATOM    246  C   ARG A 120      18.637   0.454  14.199  1.00 16.15           C  
ATOM    247  O   ARG A 120      18.436  -0.021  13.084  1.00 15.94           O  
ATOM    248  CB  ARG A 120      18.725   2.911  13.689  1.00 16.59           C  
ATOM    249  CG  ARG A 120      18.141   4.292  13.966  1.00 15.54           C  
ATOM    250  CD  ARG A 120      18.277   5.258  12.827  1.00 16.50           C  
ATOM    251  NE  ARG A 120      17.813   6.598  13.236  1.00 15.46           N  
ATOM    252  CZ  ARG A 120      16.548   7.039  13.042  1.00 15.79           C  
ATOM    253  NH1 ARG A 120      15.647   6.283  12.417  1.00 13.86           N  
ATOM    254  NH2 ARG A 120      16.214   8.257  13.412  1.00 13.79           N  
ATOM    255  N   GLU A 121      19.283  -0.193  15.173  1.00 15.83           N  
ATOM    256  CA  GLU A 121      19.907  -1.513  15.009  1.00 16.50           C  
ATOM    257  C   GLU A 121      20.990  -1.494  13.930  1.00 15.79           C  
ATOM    258  O   GLU A 121      21.158  -2.438  13.157  1.00 17.02           O  
ATOM    259  CB  GLU A 121      18.846  -2.590  14.738  1.00 16.84           C  
ATOM    260  CG  GLU A 121      17.836  -2.719  15.860  1.00 21.26           C  
ATOM    261  CD  GLU A 121      18.352  -3.369  17.154  1.00 27.84           C  
ATOM    262  OE1 GLU A 121      19.548  -3.412  17.449  1.00 30.26           O  
ATOM    263  OE2 GLU A 121      17.506  -3.847  17.924  1.00 34.42           O  
ATOM    264  N   THR A 122      21.729  -0.419  13.893  1.00 14.63           N  
ATOM    265  CA  THR A 122      22.821  -0.330  12.952  1.00 14.44           C  
ATOM    266  C   THR A 122      24.100  -0.098  13.727  1.00 12.73           C  
ATOM    267  O   THR A 122      24.095   0.207  14.946  1.00 12.77           O  
ATOM    268  CB  THR A 122      22.626   0.810  11.897  1.00 15.00           C  
ATOM    269  OG1 THR A 122      22.569   2.090  12.542  1.00 14.90           O  
ATOM    270  CG2 THR A 122      21.266   0.701  11.184  1.00 17.82           C  
ATOM    271  N   CYS A 123      25.196  -0.230  13.003  1.00 12.36           N  
ATOM    272  CA  CYS A 123      26.494   0.162  13.546  1.00 12.67           C  
ATOM    273  C   CYS A 123      27.355   0.713  12.426  1.00 12.83           C  
ATOM    274  O   CYS A 123      26.970   0.639  11.250  1.00 13.81           O  
ATOM    275  CB  CYS A 123      27.159  -1.029  14.220  1.00 11.40           C  
ATOM    276  SG  CYS A 123      27.455  -2.387  13.031  1.00 13.78           S  
ATOM    277  N   VAL A 124      28.492   1.309  12.782  1.00 11.72           N  
ATOM    278  CA  VAL A 124      29.512   1.648  11.824  1.00 12.15           C  
ATOM    279  C   VAL A 124      30.700   0.691  12.119  1.00 12.46           C  
ATOM    280  O   VAL A 124      31.156   0.575  13.254  1.00 11.23           O  
ATOM    281  CB  VAL A 124      29.996   3.065  11.962  1.00 13.52           C  
ATOM    282  CG1 VAL A 124      31.245   3.355  11.030  1.00 14.49           C  
ATOM    283  CG2 VAL A 124      28.872   4.032  11.656  1.00 13.54           C  
ATOM    284  N   VAL A 125      31.181   0.043  11.065  1.00 11.94           N  
ATOM    285  CA  VAL A 125      32.427  -0.745  11.144  1.00 12.01           C  
ATOM    286  C   VAL A 125      33.548  -0.098  10.355  1.00 11.98           C  
ATOM    287  O   VAL A 125      33.321   0.644   9.364  1.00 14.06           O  
ATOM    288  CB  VAL A 125      32.216  -2.210  10.683  1.00 11.85           C  
ATOM    289  CG1 VAL A 125      31.072  -2.800  11.425  1.00 10.80           C  
ATOM    290  CG2 VAL A 125      31.904  -2.296   9.160  1.00 13.39           C  
ATOM    291  N   VAL A 126      34.777  -0.376  10.798  1.00 11.36           N  
ATOM    292  CA  VAL A 126      35.947   0.080  10.107  1.00 12.68           C  
ATOM    293  C   VAL A 126      36.659  -1.164   9.597  1.00 12.94           C  
ATOM    294  O   VAL A 126      37.018  -2.041  10.372  1.00 12.27           O  
ATOM    295  CB  VAL A 126      36.876   0.858  11.050  1.00 13.33           C  
ATOM    296  CG1 VAL A 126      38.194   1.239  10.360  1.00 14.79           C  
ATOM    297  CG2 VAL A 126      36.152   2.134  11.615  1.00 14.04           C  
ATOM    298  N   TYR A 127      36.870  -1.221   8.298  1.00 13.53           N  
ATOM    299  CA  TYR A 127      37.509  -2.387   7.715  1.00 13.83           C  
ATOM    300  C   TYR A 127      38.990  -2.312   8.013  1.00 15.12           C  
ATOM    301  O   TYR A 127      39.673  -1.397   7.580  1.00 14.70           O  
ATOM    302  CB  TYR A 127      37.243  -2.461   6.224  1.00 12.96           C  
ATOM    303  CG  TYR A 127      35.793  -2.665   5.958  1.00 12.64           C  
ATOM    304  CD1 TYR A 127      35.029  -1.622   5.419  1.00 12.69           C  
ATOM    305  CD2 TYR A 127      35.145  -3.885   6.331  1.00 12.95           C  
ATOM    306  CE1 TYR A 127      33.614  -1.788   5.182  1.00 14.20           C  
ATOM    307  CE2 TYR A 127      33.754  -4.030   6.115  1.00 14.11           C  
ATOM    308  CZ  TYR A 127      33.016  -2.988   5.520  1.00 13.71           C  
ATOM    309  OH  TYR A 127      31.647  -3.133   5.307  1.00 14.52           O  
ATOM    310  N   THR A 128      39.426  -3.303   8.776  1.00 16.87           N  
ATOM    311  CA  THR A 128      40.769  -3.380   9.397  1.00 17.00           C  
ATOM    312  C   THR A 128      41.877  -3.410   8.399  1.00 16.18           C  
ATOM    313  O   THR A 128      42.077  -4.428   7.713  1.00 19.10           O  
ATOM    314  CB  THR A 128      40.851  -4.724  10.149  1.00 17.63           C  
ATOM    315  OG1 THR A 128      39.903  -4.746  11.194  1.00 18.88           O  
ATOM    316  CG2 THR A 128      42.169  -4.887  10.889  1.00 21.38           C  
ATOM    317  N   GLY A 129      42.649  -2.336   8.333  1.00 16.38           N  
ATOM    318  CA  GLY A 129      43.750  -2.281   7.421  1.00 16.60           C  
ATOM    319  C   GLY A 129      43.335  -1.871   6.024  1.00 18.07           C  
ATOM    320  O   GLY A 129      44.169  -1.875   5.094  1.00 18.86           O  
ATOM    321  N   TYR A 130      42.062  -1.500   5.865  1.00 17.89           N  
ATOM    322  CA  TYR A 130      41.551  -1.060   4.582  1.00 18.37           C  
ATOM    323  C   TYR A 130      41.123   0.417   4.569  1.00 19.33           C  
ATOM    324  O   TYR A 130      40.638   0.917   3.538  1.00 19.21           O  
ATOM    325  CB  TYR A 130      40.393  -1.947   4.158  1.00 18.52           C  
ATOM    326  CG  TYR A 130      40.792  -3.383   3.966  1.00 18.99           C  
ATOM    327  CD1 TYR A 130      40.673  -4.303   4.995  1.00 20.70           C  
ATOM    328  CD2 TYR A 130      41.329  -3.823   2.751  1.00 18.98           C  
ATOM    329  CE1 TYR A 130      41.049  -5.636   4.819  1.00 21.80           C  
ATOM    330  CE2 TYR A 130      41.688  -5.138   2.573  1.00 20.61           C  
ATOM    331  CZ  TYR A 130      41.556  -6.040   3.610  1.00 23.14           C  
ATOM    332  OH  TYR A 130      41.932  -7.371   3.457  1.00 27.79           O  
ATOM    333  N   GLY A 131      41.232   1.081   5.729  1.00 18.30           N  
ATOM    334  CA  GLY A 131      41.101   2.522   5.856  1.00 18.95           C  
ATOM    335  C   GLY A 131      39.752   3.116   5.591  1.00 20.71           C  
ATOM    336  O   GLY A 131      39.646   4.317   5.344  1.00 21.00           O  
ATOM    337  N   ASN A 132      38.713   2.284   5.615  1.00 20.36           N  
ATOM    338  CA  ASN A 132      37.403   2.708   5.168  1.00 21.54           C  
ATOM    339  C   ASN A 132      36.365   2.232   6.171  1.00 20.96           C  
ATOM    340  O   ASN A 132      36.601   1.268   6.893  1.00 20.70           O  
ATOM    341  CB  ASN A 132      37.084   2.079   3.797  1.00 22.58           C  
ATOM    342  CG  ASN A 132      37.428   2.995   2.627  1.00 27.86           C  
ATOM    343  OD1 ASN A 132      38.279   2.656   1.789  1.00 31.24           O  
ATOM    344  ND2 ASN A 132      36.769   4.170   2.562  1.00 32.44           N  
ATOM    345  N   ARG A 133      35.214   2.898   6.209  1.00 20.25           N  
ATOM    346  CA  ARG A 133      34.180   2.544   7.153  1.00 19.80           C  
ATOM    347  C   ARG A 133      32.824   2.484   6.459  1.00 20.40           C  
ATOM    348  O   ARG A 133      32.631   3.030   5.364  1.00 19.90           O  
ATOM    349  CB  ARG A 133      34.155   3.567   8.301  1.00 20.38           C  
ATOM    350  CG  ARG A 133      33.497   4.867   7.871  1.00 22.71           C  
ATOM    351  CD  ARG A 133      33.452   5.893   8.952  1.00 25.76           C  
ATOM    352  NE  ARG A 133      34.802   6.314   9.257  1.00 26.60           N  
ATOM    353  CZ  ARG A 133      35.115   7.008  10.323  1.00 26.60           C  
ATOM    354  NH1 ARG A 133      34.149   7.357  11.161  1.00 28.78           N  
ATOM    355  NH2 ARG A 133      36.376   7.361  10.535  1.00 22.60           N  
ATOM    356  N   GLU A 134      31.864   1.865   7.116  1.00 18.63           N  
ATOM    357  CA  GLU A 134      30.582   1.680   6.491  1.00 20.06           C  
ATOM    358  C   GLU A 134      29.553   1.402   7.575  1.00 19.00           C  
ATOM    359  O   GLU A 134      29.875   0.747   8.562  1.00 18.38           O  
ATOM    360  CB  GLU A 134      30.726   0.497   5.520  1.00 19.72           C  
ATOM    361  CG  GLU A 134      29.497  -0.246   5.156  1.00 24.74           C  
ATOM    362  CD  GLU A 134      29.681  -0.854   3.795  1.00 28.00           C  
ATOM    363  OE1 GLU A 134      30.169  -1.973   3.710  1.00 25.35           O  
ATOM    364  OE2 GLU A 134      29.360  -0.164   2.818  1.00 34.34           O  
ATOM    365  N   GLU A 135      28.322   1.912   7.394  1.00 18.23           N  
ATOM    366  CA  GLU A 135      27.198   1.488   8.214  1.00 17.78           C  
ATOM    367  C   GLU A 135      26.781   0.112   7.816  1.00 16.52           C  
ATOM    368  O   GLU A 135      26.712  -0.215   6.614  1.00 16.85           O  
ATOM    369  CB  GLU A 135      26.016   2.470   8.043  1.00 20.25           C  
ATOM    370  CG  GLU A 135      24.830   2.239   8.972  1.00 25.46           C  
ATOM    371  CD  GLU A 135      24.125   3.560   9.246  1.00 35.03           C  
ATOM    372  OE1 GLU A 135      23.196   3.898   8.479  1.00 35.95           O  
ATOM    373  OE2 GLU A 135      24.551   4.288  10.183  1.00 39.30           O  
ATOM    374  N   GLN A 136      26.478  -0.697   8.820  1.00 14.27           N  
ATOM    375  CA  GLN A 136      26.002  -2.056   8.675  1.00 14.69           C  
ATOM    376  C   GLN A 136      24.808  -2.234   9.603  1.00 15.36           C  
ATOM    377  O   GLN A 136      24.769  -1.660  10.706  1.00 15.68           O  
ATOM    378  CB  GLN A 136      27.072  -3.090   9.122  1.00 14.28           C  
ATOM    379  CG  GLN A 136      28.287  -3.207   8.239  1.00 13.40           C  
ATOM    380  CD  GLN A 136      28.102  -4.060   6.975  1.00 15.88           C  
ATOM    381  OE1 GLN A 136      27.202  -4.905   6.890  1.00 16.89           O  
ATOM    382  NE2 GLN A 136      28.995  -3.854   6.004  1.00 14.22           N  
ATOM    383  N   ASN A 137      23.830  -3.026   9.184  1.00 15.31           N  
ATOM    384  CA  ASN A 137      22.851  -3.522  10.140  1.00 16.53           C  
ATOM    385  C   ASN A 137      23.569  -4.448  11.089  1.00 15.03           C  
ATOM    386  O   ASN A 137      24.410  -5.248  10.653  1.00 13.44           O  
ATOM    387  CB  ASN A 137      21.749  -4.300   9.446  1.00 18.97           C  
ATOM    388  CG  ASN A 137      20.975  -3.439   8.478  1.00 22.69           C  
ATOM    389  OD1 ASN A 137      20.649  -2.291   8.785  1.00 21.51           O  
ATOM    390  ND2 ASN A 137      20.732  -3.969   7.276  1.00 23.88           N  
ATOM    391  N   LEU A 138      23.285  -4.326  12.386  1.00 13.95           N  
ATOM    392  CA  LEU A 138      23.844  -5.295  13.343  1.00 13.03           C  
ATOM    393  C   LEU A 138      23.541  -6.748  12.913  1.00 13.55           C  
ATOM    394  O   LEU A 138      24.410  -7.621  13.074  1.00 12.76           O  
ATOM    395  CB  LEU A 138      23.309  -5.061  14.758  1.00 12.70           C  
ATOM    396  CG  LEU A 138      23.829  -3.813  15.462  1.00 14.13           C  
ATOM    397  CD1 LEU A 138      22.980  -3.497  16.611  1.00 15.22           C  
ATOM    398  CD2 LEU A 138      25.273  -4.090  15.926  1.00 12.31           C  
ATOM    399  N   SER A 139      22.355  -7.012  12.344  1.00 12.04           N  
ATOM    400  CA  SER A 139      21.995  -8.390  11.967  1.00 14.70           C  
ATOM    401  C   SER A 139      22.909  -8.976  10.884  1.00 14.00           C  
ATOM    402  O   SER A 139      22.914 -10.185  10.695  1.00 16.53           O  
ATOM    403  CB  SER A 139      20.532  -8.506  11.496  1.00 13.76           C  
ATOM    404  OG  SER A 139      20.329  -7.566  10.477  1.00 17.61           O  
ATOM    405  N   ASP A 140      23.619  -8.123  10.166  1.00 14.52           N  
ATOM    406  CA  ASP A 140      24.427  -8.526   9.022  1.00 13.21           C  
ATOM    407  C   ASP A 140      25.887  -8.765   9.396  1.00 13.57           C  
ATOM    408  O   ASP A 140      26.669  -9.171   8.524  1.00 13.77           O  
ATOM    409  CB  ASP A 140      24.387  -7.477   7.910  1.00 13.35           C  
ATOM    410  CG  ASP A 140      23.036  -7.396   7.214  1.00 14.72           C  
ATOM    411  OD1 ASP A 140      22.280  -8.388   7.253  1.00 18.24           O  
ATOM    412  OD2 ASP A 140      22.692  -6.366   6.602  1.00 17.84           O  
ATOM    413  N   LEU A 141      26.263  -8.527  10.665  1.00 11.97           N  
ATOM    414  CA  LEU A 141      27.692  -8.720  11.051  1.00 11.52           C  
ATOM    415  C   LEU A 141      27.960 -10.215  11.125  1.00 11.40           C  
ATOM    416  O   LEU A 141      27.056 -11.031  11.428  1.00 11.40           O  
ATOM    417  CB  LEU A 141      27.986  -8.048  12.412  1.00 10.24           C  
ATOM    418  CG  LEU A 141      27.877  -6.521  12.364  1.00 10.59           C  
ATOM    419  CD1 LEU A 141      28.230  -6.046  13.818  1.00 10.72           C  
ATOM    420  CD2 LEU A 141      28.764  -5.787  11.339  1.00  8.38           C  
ATOM    421  N   LEU A 142      29.216 -10.572  10.845  1.00 12.13           N  
ATOM    422  CA  LEU A 142      29.637 -11.944  10.850  1.00 10.57           C  
ATOM    423  C   LEU A 142      30.735 -12.170  11.883  1.00 11.42           C  
ATOM    424  O   LEU A 142      31.461 -11.244  12.290  1.00 10.91           O  
ATOM    425  CB  LEU A 142      30.207 -12.326   9.489  1.00 10.93           C  
ATOM    426  CG  LEU A 142      29.422 -11.951   8.208  1.00 13.72           C  
ATOM    427  CD1 LEU A 142      30.256 -12.069   6.954  1.00 13.71           C  
ATOM    428  CD2 LEU A 142      28.190 -12.837   8.172  1.00 15.19           C  
ATOM    429  N   SER A 143      30.865 -13.427  12.247  1.00 11.77           N  
ATOM    430  CA  SER A 143      31.996 -13.898  13.059  1.00 12.35           C  
ATOM    431  C   SER A 143      33.320 -13.383  12.563  1.00 11.34           C  
ATOM    432  O   SER A 143      33.568 -13.425  11.355  1.00 12.53           O  
ATOM    433  CB  SER A 143      32.081 -15.422  12.956  1.00 12.83           C  
ATOM    434  OG  SER A 143      33.237 -15.859  13.667  1.00 17.49           O  
ATOM    435  N   PRO A 144      34.231 -12.957  13.465  1.00 11.95           N  
ATOM    436  CA  PRO A 144      35.518 -12.482  12.992  1.00 12.92           C  
ATOM    437  C   PRO A 144      36.346 -13.611  12.362  1.00 13.91           C  
ATOM    438  O   PRO A 144      37.322 -13.288  11.753  1.00 12.67           O  
ATOM    439  CB  PRO A 144      36.194 -11.905  14.246  1.00 13.67           C  
ATOM    440  CG  PRO A 144      35.546 -12.573  15.388  1.00 13.27           C  
ATOM    441  CD  PRO A 144      34.070 -12.747  14.927  1.00 11.28           C  
ATOM    442  N   ILE A 145      35.954 -14.880  12.532  1.00 15.28           N  
ATOM    443  CA  ILE A 145      36.619 -15.985  11.819  1.00 18.46           C  
ATOM    444  C   ILE A 145      36.404 -15.951  10.287  1.00 19.93           C  
ATOM    445  O   ILE A 145      37.282 -16.392   9.517  1.00 19.05           O  
ATOM    446  CB  ILE A 145      36.175 -17.308  12.407  1.00 18.94           C  
ATOM    447  CG1 ILE A 145      36.605 -17.391  13.882  1.00 21.76           C  
ATOM    448  CG2 ILE A 145      36.724 -18.525  11.590  1.00 21.94           C  
ATOM    449  CD1 ILE A 145      35.978 -18.570  14.616  1.00 27.58           C  
ATOM    450  N   CYS A 146      35.257 -15.444   9.820  1.00 21.33           N  
ATOM    451  CA  CYS A 146      35.034 -15.346   8.365  1.00 23.96           C  
ATOM    452  C   CYS A 146      35.927 -14.346   7.734  1.00 24.98           C  
ATOM    453  O   CYS A 146      35.835 -13.163   8.053  1.00 25.48           O  
ATOM    454  CB  CYS A 146      33.630 -14.905   8.009  1.00 25.09           C  
ATOM    455  SG  CYS A 146      32.528 -15.790   8.993  1.00 27.50           S  
ATOM    456  N   GLU A 147      36.736 -14.789   6.791  1.00 26.02           N  
ATOM    457  CA  GLU A 147      37.559 -13.838   6.042  1.00 28.66           C  
ATOM    458  C   GLU A 147      37.593 -14.126   4.536  1.00 28.95           C  
ATOM    459  O   GLU A 147      38.143 -13.406   3.706  1.00 29.73           O  
ATOM    460  CB  GLU A 147      38.948 -13.728   6.686  1.00 29.32           C  
ATOM    461  CG  GLU A 147      38.910 -12.873   7.953  1.00 31.74           C  
ATOM    462  CD  GLU A 147      40.236 -12.717   8.659  1.00 33.34           C  
ATOM    463  OE1 GLU A 147      40.731 -11.571   8.716  1.00 36.57           O  
ATOM    464  OE2 GLU A 147      40.755 -13.709   9.211  1.00 33.03           O  
ATOM    465  OXT GLU A 147      37.016 -15.105   4.065  1.00 30.39           O  
TER     466      GLU A 147                                                      
END
MOLECULE T0429_22_99.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
END
