
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  143 ( 1070),  selected  143 , name 1x6o_A
# Molecule2: number of CA atoms   76 (  635),  selected   76 , name T0429_100_176.pdb
# PARAMETERS: 1x6o_A.T0429_100_176.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K    19_A      R     100          2.751
LGA    T    20_A      A     101          2.000
LGA    Y    21_A      R     102          3.304
LGA    -       -      T     103           -
LGA    P    22_A      I     104          0.932
LGA    L    23_A      I     105          1.280
LGA    A    24_A      K     106          0.798
LGA    A    25_A      W     107          1.727
LGA    G    26_A      Q     108          2.265
LGA    A    27_A      D     109          1.436
LGA    L    28_A      L     110          0.380
LGA    K    29_A      E     111          0.417
LGA    K    30_A      V     112          0.208
LGA    G    31_A      G     113          0.464
LGA    G    32_A      Q     114          1.072
LGA    Y    33_A      V     115          1.958
LGA    V    34_A      V     116          2.406
LGA    C    35_A      M     117          2.447
LGA    -       -      L     118           -
LGA    I    36_A      N     119          2.974
LGA    N    37_A      Y     120          2.512
LGA    -       -      N     121           -
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    -       -      E     127           -
LGA    -       -      R     128           -
LGA    -       -      G     129           -
LGA    G    38_A      F     130          3.377
LGA    -       -      W     131           -
LGA    R    39_A      Y     132          0.411
LGA    P    40_A      D     133          0.384
LGA    C    41_A      A     134          0.578
LGA    K    42_A      E     135          0.709
LGA    V    43_A      I     136          0.531
LGA    I    44_A      S     137          0.957
LGA    D    45_A      R     138          0.851
LGA    L    46_A      K     139          0.907
LGA    S    47_A      R     140          0.727
LGA    V    48_A      E     141          1.063
LGA    S    49_A      T     142          1.639
LGA    K    50_A      R     143          1.994
LGA    T    51_A      -       -           -
LGA    H    56_A      -       -           -
LGA    A    57_A      T     144           #
LGA    K    58_A      A     145          3.854
LGA    V    59_A      R     146          2.524
LGA    S    60_A      E     147          1.397
LGA    I    61_A      L     148          1.237
LGA    V    62_A      Y     149          1.190
LGA    A    63_A      A     150          0.931
LGA    T    64_A      N     151          1.059
LGA    D    65_A      V     152          2.347
LGA    I    66_A      V     153          3.667
LGA    F    67_A      L     154          5.095
LGA    T    68_A      D     156          4.103
LGA    -       -      D     157           -
LGA    G    69_A      S     158          0.877
LGA    N    70_A      L     159          1.024
LGA    R    71_A      N     160          2.769
LGA    -       -      D     161           -
LGA    L    72_A      C     162          2.808
LGA    E    73_A      R     163          2.093
LGA    D    74_A      I     164          1.000
LGA    Q    75_A      I     165          3.318
LGA    A    76_A      F     166          4.767
LGA    P    77_A      V     167           #
LGA    S    78_A      -       -           -
LGA    T    79_A      -       -           -
LGA    H    80_A      D     168          2.879
LGA    N    81_A      E     169          3.937
LGA    V    82_A      V     170          2.085
LGA    E    83_A      F     171          2.049
LGA    V    84_A      K     172          2.746
LGA    P    85_A      I     173          2.608
LGA    F    86_A      E     174          2.614
LGA    V    87_A      R     175          4.880
LGA    K    88_A      P     176           #
LGA    T    89_A      -       -           -
LGA    Y    90_A      -       -           -
LGA    T    91_A      -       -           -
LGA    Y    92_A      -       -           -
LGA    S    93_A      -       -           -
LGA    V    94_A      -       -           -
LGA    L    95_A      -       -           -
LGA    D    96_A      -       -           -
LGA    I    97_A      -       -           -
LGA    Q    98_A      -       -           -
LGA    A    99_A      -       -           -
LGA    N   100_A      -       -           -
LGA    E   101_A      -       -           -
LGA    D   102_A      -       -           -
LGA    P   103_A      -       -           -
LGA    S   104_A      -       -           -
LGA    L   105_A      -       -           -
LGA    P   106_A      -       -           -
LGA    A   107_A      -       -           -
LGA    H   108_A      -       -           -
LGA    L   109_A      -       -           -
LGA    S   110_A      -       -           -
LGA    L   111_A      -       -           -
LGA    M   112_A      -       -           -
LGA    D   113_A      -       -           -
LGA    D   114_A      -       -           -
LGA    E   115_A      -       -           -
LGA    G   116_A      -       -           -
LGA    E   117_A      -       -           -
LGA    S   118_A      -       -           -
LGA    R   119_A      -       -           -
LGA    E   120_A      -       -           -
LGA    D   121_A      -       -           -
LGA    L   122_A      -       -           -
LGA    D   123_A      -       -           -
LGA    M   124_A      -       -           -
LGA    P   125_A      -       -           -
LGA    P   126_A      -       -           -
LGA    D   127_A      -       -           -
LGA    P   128_A      -       -           -
LGA    A   129_A      -       -           -
LGA    L   130_A      -       -           -
LGA    A   131_A      -       -           -
LGA    T   132_A      -       -           -
LGA    Q   133_A      -       -           -
LGA    I   134_A      -       -           -
LGA    K   135_A      -       -           -
LGA    E   136_A      -       -           -
LGA    Q   137_A      -       -           -
LGA    F   138_A      -       -           -
LGA    D   139_A      -       -           -
LGA    S   140_A      -       -           -
LGA    G   141_A      -       -           -
LGA    K   142_A      -       -           -
LGA    D   143_A      -       -           -
LGA    V   144_A      -       -           -
LGA    L   145_A      -       -           -
LGA    V   146_A      -       -           -
LGA    V   147_A      -       -           -
LGA    V   148_A      -       -           -
LGA    V   149_A      -       -           -
LGA    S   150_A      -       -           -
LGA    A   151_A      -       -           -
LGA    M   152_A      -       -           -
LGA    G   153_A      -       -           -
LGA    T   154_A      -       -           -
LGA    E   155_A      -       -           -
LGA    Q   156_A      -       -           -
LGA    V   157_A      -       -           -
LGA    L   158_A      -       -           -
LGA    Q   159_A      -       -           -
LGA    T   160_A      -       -           -
LGA    K   161_A      -       -           -
LGA    N   162_A      -       -           -
LGA    A   163_A      -       -           -
LGA    A   164_A      -       -           -
LGA    E   165_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  143   76    5.0     59    2.31     8.47     59.514     2.445

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.458959 * X  +  -0.053566 * Y  +   0.886841 * Z  + -10.178235
  Y_new =   0.154452 * X  +   0.987792 * Y  +  -0.020269 * Z  + -42.418682
  Z_new =  -0.874929 * X  +   0.146277 * Y  +   0.461630 * Z  +  35.687794 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.306862   -2.834730  [ DEG:    17.5819   -162.4181 ]
  Theta =   1.065290    2.076303  [ DEG:    61.0366    118.9634 ]
  Phi   =   0.324623   -2.816970  [ DEG:    18.5995   -161.4005 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1x6o_A                                        
REMARK     2: T0429_100_176.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1x6o_A.T0429_100_176.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  143   76   5.0   59   2.31    8.47  59.514
REMARK  ---------------------------------------------------------- 
MOLECULE 1x6o_A
HEADER    TRANSLATION                             11-AUG-04   1X6O              
TITLE     STRUCTURAL ANALYSIS OF LEISHMANIA BRAZILIENSIS EUKARYOTIC             
TITLE    2 INITIATION FACTOR 5A                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: EUKARYOTIC INITIATION FACTOR 5A;                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: LEISHMANIA BRAZILIENSIS;                        
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21STAR(DE3);                             
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: T7 SYSTEM;                            
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET14B                                    
KEYWDS    SGPP, STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE                     
KEYWDS   2 INITIATIVE, STRUCTURAL GENOMICS OF PATHOGENIC PROTOZOA               
KEYWDS   3 CONSORTIUM                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.BOSCH,M.A.ROBIEN,W.G.J.HOL,STRUCTURAL GENOMICS OF                   
AUTHOR   2 PATHOGENIC PROTOZOA CONSORTIUM (SGPP)                                
REVDAT   3   09-MAY-06 1X6O    1       HEADER                                   
REVDAT   2   01-FEB-05 1X6O    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   24-AUG-04 1X6O    0                                                
JRNL        AUTH   J.BOSCH,M.A.ROBIEN,W.G.J.HOL,                                
JRNL        AUTH 2 STRUCTURAL GENOMICS OF PATHOGENIC PROTOZOA                   
JRNL        TITL   STRUCTURAL ANALYSIS OF LEISHMANIA BRAZILIENSIS               
JRNL        TITL 2 EUKARYOTIC INITIATION FACTOR 5A                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
SEQRES   1 A  174  MET ALA HIS HIS HIS HIS HIS HIS MET SER ASP GLU ASP          
SEQRES   2 A  174  HIS ASP PHE SER HIS GLN GLY GLY GLY ASP ASN ALA SER          
SEQRES   3 A  174  LYS THR TYR PRO LEU ALA ALA GLY ALA LEU LYS LYS GLY          
SEQRES   4 A  174  GLY TYR VAL CYS ILE ASN GLY ARG PRO CYS LYS VAL ILE          
SEQRES   5 A  174  ASP LEU SER VAL SER LYS THR GLY LYS HIS GLY HIS ALA          
SEQRES   6 A  174  LYS VAL SER ILE VAL ALA THR ASP ILE PHE THR GLY ASN          
SEQRES   7 A  174  ARG LEU GLU ASP GLN ALA PRO SER THR HIS ASN VAL GLU          
SEQRES   8 A  174  VAL PRO PHE VAL LYS THR TYR THR TYR SER VAL LEU ASP          
SEQRES   9 A  174  ILE GLN ALA ASN GLU ASP PRO SER LEU PRO ALA HIS LEU          
SEQRES  10 A  174  SER LEU MET ASP ASP GLU GLY GLU SER ARG GLU ASP LEU          
SEQRES  11 A  174  ASP MET PRO PRO ASP PRO ALA LEU ALA THR GLN ILE LYS          
SEQRES  12 A  174  GLU GLN PHE ASP SER GLY LYS ASP VAL LEU VAL VAL VAL          
SEQRES  13 A  174  VAL SER ALA MET GLY THR GLU GLN VAL LEU GLN THR LYS          
SEQRES  14 A  174  ASN ALA ALA GLU LYS                                          
HET    PEG   3802       7                                                       
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
FORMUL   2  PEG    C4 H10 O3                                                    
FORMUL   3  HOH   *325(H2 O)                                                    
CRYST1   64.991   64.991   88.297  90.00  90.00 120.00 P 32 2 1      6          
ATOM      1  N   LYS A  19      32.775 -13.537  11.244  1.00 48.61           N  
ATOM      2  CA  LYS A  19      33.857 -13.982  10.334  1.00 37.12           C  
ATOM      3  C   LYS A  19      33.655 -15.424   9.894  1.00 33.63           C  
ATOM      4  O   LYS A  19      32.562 -15.752   9.395  1.00 29.42           O  
ATOM      5  CB  LYS A  19      35.225 -13.751  10.946  1.00 31.70           C  
ATOM      6  CG  LYS A  19      35.333 -14.043  12.458  1.00 33.97           C  
ATOM      7  CD  LYS A  19      36.819 -13.937  12.921  1.00 45.45           C  
ATOM      8  CE  LYS A  19      37.646 -15.232  12.599  1.00 44.90           C  
ATOM      9  NZ  LYS A  19      37.649 -15.638  11.156  1.00 39.54           N  
ATOM     10  N   THR A  20      34.692 -16.266  10.039  1.00 32.36           N  
ATOM     11  CA  THR A  20      34.631 -17.620   9.473  1.00 27.70           C  
ATOM     12  C   THR A  20      35.297 -18.552  10.493  1.00 28.15           C  
ATOM     13  O   THR A  20      35.920 -18.105  11.458  1.00 30.40           O  
ATOM     14  CB  THR A  20      35.382 -17.766   8.161  1.00 30.49           C  
ATOM     15  OG1 THR A  20      36.778 -17.471   8.412  1.00 34.64           O  
ATOM     16  CG2 THR A  20      34.898 -16.722   7.130  1.00 32.31           C  
ATOM     17  N   TYR A  21      35.036 -19.827  10.276  1.00 29.60           N  
ATOM     18  CA  TYR A  21      35.737 -20.884  11.001  1.00 28.79           C  
ATOM     19  C   TYR A  21      36.203 -21.954  10.014  1.00 29.08           C  
ATOM     20  O   TYR A  21      35.644 -22.123   8.919  1.00 31.16           O  
ATOM     21  CB  TYR A  21      34.821 -21.484  12.065  1.00 29.67           C  
ATOM     22  CG  TYR A  21      33.513 -22.090  11.588  1.00 28.95           C  
ATOM     23  CD1 TYR A  21      32.389 -21.277  11.440  1.00 29.40           C  
ATOM     24  CD2 TYR A  21      33.389 -23.473  11.338  1.00 31.11           C  
ATOM     25  CE1 TYR A  21      31.205 -21.807  11.078  1.00 31.02           C  
ATOM     26  CE2 TYR A  21      32.176 -24.010  10.941  1.00 31.47           C  
ATOM     27  CZ  TYR A  21      31.103 -23.164  10.804  1.00 33.38           C  
ATOM     28  OH  TYR A  21      29.838 -23.636  10.458  1.00 35.68           O  
ATOM     29  N   PRO A  22      37.277 -22.663  10.378  1.00 29.54           N  
ATOM     30  CA  PRO A  22      37.805 -23.688   9.468  1.00 28.82           C  
ATOM     31  C   PRO A  22      37.027 -25.009   9.446  1.00 30.55           C  
ATOM     32  O   PRO A  22      36.442 -25.428  10.489  1.00 31.03           O  
ATOM     33  CB  PRO A  22      39.217 -23.923  10.040  1.00 29.12           C  
ATOM     34  CG  PRO A  22      39.116 -23.642  11.537  1.00 27.70           C  
ATOM     35  CD  PRO A  22      38.132 -22.479  11.571  1.00 27.34           C  
ATOM     36  N   LEU A  23      37.101 -25.697   8.303  1.00 29.14           N  
ATOM     37  CA  LEU A  23      36.492 -27.016   8.141  1.00 29.99           C  
ATOM     38  C   LEU A  23      37.342 -27.784   7.112  1.00 28.92           C  
ATOM     39  O   LEU A  23      37.754 -27.169   6.101  1.00 30.28           O  
ATOM     40  CB  LEU A  23      35.031 -26.881   7.684  1.00 30.06           C  
ATOM     41  CG  LEU A  23      34.321 -28.191   7.333  1.00 32.26           C  
ATOM     42  CD1 LEU A  23      34.108 -29.055   8.551  1.00 37.65           C  
ATOM     43  CD2 LEU A  23      33.018 -27.950   6.634  1.00 32.34           C  
ATOM     44  N   ALA A  24      37.678 -29.050   7.369  1.00 30.18           N  
ATOM     45  CA  ALA A  24      38.438 -29.820   6.365  1.00 28.55           C  
ATOM     46  C   ALA A  24      37.601 -29.846   5.079  1.00 31.43           C  
ATOM     47  O   ALA A  24      36.388 -30.079   5.115  1.00 31.13           O  
ATOM     48  CB  ALA A  24      38.639 -31.245   6.833  1.00 27.32           C  
ATOM     49  N   ALA A  25      38.226 -29.635   3.915  1.00 29.45           N  
ATOM     50  CA  ALA A  25      37.411 -29.639   2.692  1.00 28.25           C  
ATOM     51  C   ALA A  25      36.731 -31.003   2.478  1.00 29.19           C  
ATOM     52  O   ALA A  25      35.579 -31.051   1.971  1.00 30.65           O  
ATOM     53  CB  ALA A  25      38.326 -29.326   1.513  1.00 30.08           C  
ATOM     54  N   GLY A  26      37.382 -32.093   2.918  1.00 31.26           N  
ATOM     55  CA  GLY A  26      36.780 -33.425   2.814  1.00 31.93           C  
ATOM     56  C   GLY A  26      35.498 -33.600   3.649  1.00 31.91           C  
ATOM     57  O   GLY A  26      34.761 -34.577   3.437  1.00 36.26           O  
ATOM     58  N   ALA A  27      35.270 -32.686   4.582  1.00 29.69           N  
ATOM     59  CA  ALA A  27      34.083 -32.710   5.462  1.00 30.59           C  
ATOM     60  C   ALA A  27      32.922 -31.874   4.956  1.00 27.54           C  
ATOM     61  O   ALA A  27      31.813 -31.992   5.499  1.00 32.23           O  
ATOM     62  CB  ALA A  27      34.451 -32.276   6.880  1.00 34.20           C  
ATOM     63  N   LEU A  28      33.142 -31.046   3.924  1.00 30.13           N  
ATOM     64  CA  LEU A  28      32.066 -30.245   3.339  1.00 29.94           C  
ATOM     65  C   LEU A  28      30.995 -31.159   2.774  1.00 31.30           C  
ATOM     66  O   LEU A  28      31.314 -32.205   2.196  1.00 33.80           O  
ATOM     67  CB  LEU A  28      32.625 -29.389   2.185  1.00 32.25           C  
ATOM     68  CG  LEU A  28      33.245 -28.046   2.523  1.00 41.90           C  
ATOM     69  CD1 LEU A  28      33.884 -27.499   1.213  1.00 41.37           C  
ATOM     70  CD2 LEU A  28      32.145 -27.059   3.044  1.00 42.62           C  
ATOM     71  N   LYS A  29      29.724 -30.764   2.928  1.00 30.82           N  
ATOM     72  CA  LYS A  29      28.615 -31.523   2.342  1.00 29.66           C  
ATOM     73  C   LYS A  29      27.762 -30.589   1.472  1.00 32.53           C  
ATOM     74  O   LYS A  29      27.680 -29.388   1.709  1.00 32.68           O  
ATOM     75  CB  LYS A  29      27.738 -32.046   3.477  1.00 33.24           C  
ATOM     76  CG  LYS A  29      28.490 -33.052   4.395  1.00 34.88           C  
ATOM     77  CD  LYS A  29      28.076 -34.472   4.150  1.00 45.83           C  
ATOM     78  CE  LYS A  29      28.688 -35.440   5.180  1.00 48.60           C  
ATOM     79  NZ  LYS A  29      30.138 -35.724   4.930  1.00 51.61           N  
ATOM     80  N   LYS A  30      27.065 -31.184   0.489  1.00 30.11           N  
ATOM     81  CA  LYS A  30      26.091 -30.416  -0.274  1.00 27.02           C  
ATOM     82  C   LYS A  30      25.064 -29.820   0.692  1.00 29.46           C  
ATOM     83  O   LYS A  30      24.582 -30.482   1.621  1.00 32.66           O  
ATOM     84  CB  LYS A  30      25.379 -31.340  -1.266  1.00 28.82           C  
ATOM     85  CG  LYS A  30      24.403 -30.656  -2.175  1.00 29.95           C  
ATOM     86  CD  LYS A  30      23.892 -31.624  -3.237  1.00 28.81           C  
ATOM     87  CE  LYS A  30      22.735 -30.945  -4.008  1.00 31.79           C  
ATOM     88  NZ  LYS A  30      22.177 -31.836  -5.119  1.00 34.76           N  
ATOM     89  N   GLY A  31      24.777 -28.546   0.438  1.00 31.14           N  
ATOM     90  CA  GLY A  31      23.885 -27.755   1.274  1.00 33.16           C  
ATOM     91  C   GLY A  31      24.610 -26.962   2.359  1.00 32.94           C  
ATOM     92  O   GLY A  31      23.976 -26.082   2.985  1.00 35.34           O  
ATOM     93  N   GLY A  32      25.872 -27.281   2.624  1.00 30.57           N  
ATOM     94  CA  GLY A  32      26.631 -26.602   3.679  1.00 32.77           C  
ATOM     95  C   GLY A  32      27.104 -25.232   3.222  1.00 35.89           C  
ATOM     96  O   GLY A  32      27.211 -24.965   2.017  1.00 34.00           O  
ATOM     97  N   TYR A  33      27.368 -24.334   4.176  1.00 32.87           N  
ATOM     98  CA  TYR A  33      27.973 -23.051   3.831  1.00 29.89           C  
ATOM     99  C   TYR A  33      29.491 -23.183   3.622  1.00 30.76           C  
ATOM    100  O   TYR A  33      30.185 -24.053   4.252  1.00 31.43           O  
ATOM    101  CB  TYR A  33      27.737 -22.047   4.972  1.00 30.79           C  
ATOM    102  CG  TYR A  33      26.306 -21.614   5.135  1.00 32.18           C  
ATOM    103  CD1 TYR A  33      25.703 -20.844   4.154  1.00 32.63           C  
ATOM    104  CD2 TYR A  33      25.570 -21.952   6.268  1.00 32.37           C  
ATOM    105  CE1 TYR A  33      24.371 -20.400   4.301  1.00 34.53           C  
ATOM    106  CE2 TYR A  33      24.225 -21.554   6.399  1.00 33.29           C  
ATOM    107  CZ  TYR A  33      23.649 -20.771   5.418  1.00 36.65           C  
ATOM    108  OH  TYR A  33      22.332 -20.346   5.563  1.00 38.89           O  
ATOM    109  N   VAL A  34      30.037 -22.305   2.778  1.00 30.91           N  
ATOM    110  CA  VAL A  34      31.462 -22.259   2.547  1.00 30.60           C  
ATOM    111  C   VAL A  34      31.793 -20.871   1.973  1.00 34.06           C  
ATOM    112  O   VAL A  34      30.895 -20.268   1.341  1.00 33.48           O  
ATOM    113  CB  VAL A  34      31.892 -23.367   1.524  1.00 34.11           C  
ATOM    114  CG1 VAL A  34      31.286 -23.086   0.126  1.00 33.79           C  
ATOM    115  CG2 VAL A  34      33.406 -23.499   1.435  1.00 34.32           C  
ATOM    116  N   CYS A  35      33.029 -20.395   2.183  1.00 33.20           N  
ATOM    117  CA  CYS A  35      33.432 -19.153   1.514  1.00 33.51           C  
ATOM    118  C   CYS A  35      34.268 -19.538   0.313  1.00 33.49           C  
ATOM    119  O   CYS A  35      35.170 -20.399   0.371  1.00 34.51           O  
ATOM    120  CB  CYS A  35      34.305 -18.320   2.396  1.00 33.24           C  
ATOM    121  SG  CYS A  35      33.265 -17.470   3.625  1.00 40.57           S  
ATOM    122  N   ILE A  36      33.994 -18.843  -0.790  1.00 31.49           N  
ATOM    123  CA  ILE A  36      34.876 -18.927  -1.965  1.00 29.83           C  
ATOM    124  C   ILE A  36      35.172 -17.488  -2.334  1.00 30.26           C  
ATOM    125  O   ILE A  36      34.242 -16.684  -2.502  1.00 31.06           O  
ATOM    126  CB  ILE A  36      34.171 -19.597  -3.160  1.00 30.70           C  
ATOM    127  CG1 ILE A  36      33.859 -21.081  -2.792  1.00 30.78           C  
ATOM    128  CG2 ILE A  36      35.093 -19.541  -4.443  1.00 30.52           C  
ATOM    129  CD1 ILE A  36      32.972 -21.766  -3.822  1.00 34.12           C  
ATOM    130  N   ASN A  37      36.459 -17.149  -2.478  1.00 29.03           N  
ATOM    131  CA  ASN A  37      36.859 -15.792  -2.829  1.00 27.84           C  
ATOM    132  C   ASN A  37      36.256 -14.741  -1.890  1.00 28.35           C  
ATOM    133  O   ASN A  37      35.928 -13.618  -2.337  1.00 32.11           O  
ATOM    134  CB  ASN A  37      36.453 -15.487  -4.261  1.00 28.62           C  
ATOM    135  CG  ASN A  37      37.184 -16.361  -5.271  1.00 30.97           C  
ATOM    136  OD1 ASN A  37      38.302 -16.815  -4.992  1.00 32.20           O  
ATOM    137  ND2 ASN A  37      36.629 -16.501  -6.450  1.00 32.41           N  
ATOM    138  N   GLY A  38      36.108 -15.129  -0.629  1.00 31.15           N  
ATOM    139  CA  GLY A  38      35.638 -14.173   0.376  1.00 33.55           C  
ATOM    140  C   GLY A  38      34.125 -14.029   0.382  1.00 34.53           C  
ATOM    141  O   GLY A  38      33.586 -13.207   1.139  1.00 36.24           O  
ATOM    142  N   ARG A  39      33.431 -14.782  -0.463  1.00 30.35           N  
ATOM    143  CA  ARG A  39      31.977 -14.674  -0.540  1.00 29.32           C  
ATOM    144  C   ARG A  39      31.292 -15.819   0.178  1.00 29.58           C  
ATOM    145  O   ARG A  39      31.707 -16.989   0.020  1.00 30.85           O  
ATOM    146  CB  ARG A  39      31.547 -14.774  -2.015  1.00 31.25           C  
ATOM    147  CG  ARG A  39      32.115 -13.630  -2.864  1.00 30.11           C  
ATOM    148  CD  ARG A  39      31.648 -12.222  -2.398  1.00 30.05           C  
ATOM    149  NE  ARG A  39      30.193 -12.229  -2.271  1.00 29.66           N  
ATOM    150  CZ  ARG A  39      29.466 -11.245  -1.761  1.00 35.56           C  
ATOM    151  NH1 ARG A  39      30.045 -10.075  -1.427  1.00 36.80           N  
ATOM    152  NH2 ARG A  39      28.150 -11.407  -1.611  1.00 33.79           N  
ATOM    153  N   PRO A  40      30.206 -15.550   0.886  1.00 29.51           N  
ATOM    154  CA  PRO A  40      29.526 -16.635   1.600  1.00 27.77           C  
ATOM    155  C   PRO A  40      28.556 -17.351   0.684  1.00 31.71           C  
ATOM    156  O   PRO A  40      27.689 -16.722   0.043  1.00 31.28           O  
ATOM    157  CB  PRO A  40      28.752 -15.903   2.699  1.00 29.05           C  
ATOM    158  CG  PRO A  40      28.396 -14.511   2.033  1.00 29.26           C  
ATOM    159  CD  PRO A  40      29.597 -14.232   1.120  1.00 29.76           C  
ATOM    160  N   CYS A  41      28.735 -18.662   0.589  1.00 31.29           N  
ATOM    161  CA  CYS A  41      27.995 -19.479  -0.386  1.00 31.94           C  
ATOM    162  C   CYS A  41      27.394 -20.716   0.235  1.00 33.16           C  
ATOM    163  O   CYS A  41      27.791 -21.111   1.327  1.00 33.28           O  
ATOM    164  CB  CYS A  41      28.941 -19.958  -1.506  1.00 33.30           C  
ATOM    165  SG  CYS A  41      29.793 -18.639  -2.421  1.00 33.27           S  
ATOM    166  N   LYS A  42      26.431 -21.295  -0.472  1.00 31.81           N  
ATOM    167  CA  LYS A  42      25.917 -22.621  -0.086  1.00 31.47           C  
ATOM    168  C   LYS A  42      26.322 -23.614  -1.174  1.00 33.16           C  
ATOM    169  O   LYS A  42      26.159 -23.345  -2.366  1.00 31.71           O  
ATOM    170  CB  LYS A  42      24.400 -22.550   0.060  1.00 36.64           C  
ATOM    171  CG  LYS A  42      23.758 -23.836   0.382  1.00 42.97           C  
ATOM    172  CD  LYS A  42      22.283 -23.617   0.809  1.00 49.92           C  
ATOM    173  CE  LYS A  42      22.109 -22.483   1.835  1.00 58.82           C  
ATOM    174  NZ  LYS A  42      20.692 -22.462   2.404  1.00 61.35           N  
ATOM    175  N   VAL A  43      26.929 -24.721  -0.757  1.00 31.05           N  
ATOM    176  CA  VAL A  43      27.385 -25.771  -1.707  1.00 29.44           C  
ATOM    177  C   VAL A  43      26.193 -26.392  -2.433  1.00 29.12           C  
ATOM    178  O   VAL A  43      25.236 -26.884  -1.812  1.00 31.71           O  
ATOM    179  CB  VAL A  43      28.156 -26.888  -0.945  1.00 30.26           C  
ATOM    180  CG1 VAL A  43      28.534 -28.064  -1.865  1.00 33.54           C  
ATOM    181  CG2 VAL A  43      29.392 -26.291  -0.286  1.00 32.86           C  
ATOM    182  N   ILE A  44      26.263 -26.368  -3.774  1.00 29.32           N  
ATOM    183  CA  ILE A  44      25.240 -27.003  -4.591  1.00 27.89           C  
ATOM    184  C   ILE A  44      25.728 -28.255  -5.330  1.00 27.28           C  
ATOM    185  O   ILE A  44      24.885 -29.057  -5.786  1.00 28.17           O  
ATOM    186  CB  ILE A  44      24.562 -25.995  -5.589  1.00 30.17           C  
ATOM    187  CG1 ILE A  44      25.584 -25.379  -6.553  1.00 31.09           C  
ATOM    188  CG2 ILE A  44      23.761 -24.963  -4.786  1.00 31.09           C  
ATOM    189  CD1 ILE A  44      24.915 -24.654  -7.734  1.00 30.41           C  
ATOM    190  N   ASP A  45      27.043 -28.420  -5.486  1.00 27.37           N  
ATOM    191  CA  ASP A  45      27.569 -29.689  -6.027  1.00 27.79           C  
ATOM    192  C   ASP A  45      28.909 -29.960  -5.406  1.00 29.66           C  
ATOM    193  O   ASP A  45      29.688 -29.039  -5.148  1.00 28.91           O  
ATOM    194  CB  ASP A  45      27.784 -29.638  -7.535  1.00 28.39           C  
ATOM    195  CG  ASP A  45      26.549 -29.284  -8.283  1.00 29.14           C  
ATOM    196  OD1 ASP A  45      25.770 -30.202  -8.627  1.00 29.52           O  
ATOM    197  OD2 ASP A  45      26.305 -28.103  -8.646  1.00 31.69           O  
ATOM    198  N   LEU A  46      29.178 -31.229  -5.170  1.00 28.06           N  
ATOM    199  CA  LEU A  46      30.493 -31.655  -4.709  1.00 30.12           C  
ATOM    200  C   LEU A  46      30.948 -32.867  -5.481  1.00 28.55           C  
ATOM    201  O   LEU A  46      30.121 -33.723  -5.917  1.00 28.66           O  
ATOM    202  CB  LEU A  46      30.407 -32.097  -3.250  1.00 32.65           C  
ATOM    203  CG  LEU A  46      30.408 -31.024  -2.158  1.00 40.50           C  
ATOM    204  CD1 LEU A  46      30.155 -31.710  -0.796  1.00 47.35           C  
ATOM    205  CD2 LEU A  46      31.710 -30.134  -2.108  1.00 40.54           C  
ATOM    206  N   SER A  47      32.259 -32.976  -5.678  1.00 28.76           N  
ATOM    207  CA  SER A  47      32.808 -34.165  -6.346  1.00 28.83           C  
ATOM    208  C   SER A  47      34.150 -34.416  -5.671  1.00 30.68           C  
ATOM    209  O   SER A  47      34.779 -33.452  -5.201  1.00 32.51           O  
ATOM    210  CB  SER A  47      33.077 -33.813  -7.819  1.00 30.43           C  
ATOM    211  OG  SER A  47      33.473 -34.972  -8.552  1.00 44.64           O  
ATOM    212  N   VAL A  48      34.574 -35.674  -5.586  1.00 28.82           N  
ATOM    213  CA  VAL A  48      35.887 -35.968  -5.028  1.00 28.77           C  
ATOM    214  C   VAL A  48      36.637 -36.857  -6.051  1.00 31.33           C  
ATOM    215  O   VAL A  48      36.048 -37.700  -6.729  1.00 31.18           O  
ATOM    216  CB  VAL A  48      35.748 -36.624  -3.641  1.00 31.96           C  
ATOM    217  CG1 VAL A  48      37.105 -36.827  -2.955  1.00 37.57           C  
ATOM    218  CG2 VAL A  48      34.868 -35.837  -2.749  1.00 35.16           C  
ATOM    219  N   SER A  49      37.931 -36.619  -6.213  1.00 32.20           N  
ATOM    220  CA  SER A  49      38.756 -37.458  -7.075  1.00 33.24           C  
ATOM    221  C   SER A  49      38.943 -38.815  -6.374  1.00 45.03           C  
ATOM    222  O   SER A  49      38.719 -38.930  -5.163  1.00 45.97           O  
ATOM    223  CB  SER A  49      40.106 -36.791  -7.203  1.00 39.20           C  
ATOM    224  OG  SER A  49      40.731 -36.866  -5.928  1.00 34.53           O  
ATOM    225  N   LYS A  50      39.352 -39.848  -7.111  1.00 49.17           N  
ATOM    226  CA  LYS A  50      39.742 -41.098  -6.456  1.00 53.23           C  
ATOM    227  C   LYS A  50      40.869 -40.791  -5.451  1.00 54.67           C  
ATOM    228  O   LYS A  50      41.705 -39.908  -5.698  1.00 53.96           O  
ATOM    229  CB  LYS A  50      40.167 -42.142  -7.481  1.00 53.18           C  
ATOM    230  N   THR A  51      40.852 -41.475  -4.307  1.00 56.85           N  
ATOM    231  CA  THR A  51      41.809 -41.217  -3.222  1.00 58.12           C  
ATOM    232  C   THR A  51      43.199 -41.760  -3.532  1.00 58.96           C  
ATOM    233  O   THR A  51      43.346 -42.923  -3.912  1.00 60.98           O  
ATOM    234  CB  THR A  51      41.293 -41.774  -1.888  1.00 58.31           C  
ATOM    235  N   HIS A  56      45.440 -38.996  -0.244  1.00 61.62           N  
ATOM    236  CA  HIS A  56      44.179 -38.259  -0.096  1.00 59.75           C  
ATOM    237  C   HIS A  56      43.495 -37.974  -1.456  1.00 54.84           C  
ATOM    238  O   HIS A  56      43.772 -38.626  -2.472  1.00 55.19           O  
ATOM    239  CB  HIS A  56      44.366 -36.943   0.700  1.00 62.74           C  
ATOM    240  CG  HIS A  56      44.972 -37.121   2.066  1.00 67.72           C  
ATOM    241  ND1 HIS A  56      46.264 -36.733   2.363  1.00 72.23           N  
ATOM    242  CD2 HIS A  56      44.457 -37.619   3.217  1.00 70.03           C  
ATOM    243  CE1 HIS A  56      46.522 -36.996   3.633  1.00 71.47           C  
ATOM    244  NE2 HIS A  56      45.441 -37.533   4.174  1.00 69.84           N  
ATOM    245  N   ALA A  57      42.614 -36.982  -1.464  1.00 46.25           N  
ATOM    246  CA  ALA A  57      41.716 -36.767  -2.578  1.00 37.24           C  
ATOM    247  C   ALA A  57      41.596 -35.258  -2.831  1.00 36.80           C  
ATOM    248  O   ALA A  57      42.008 -34.467  -1.991  1.00 37.03           O  
ATOM    249  CB  ALA A  57      40.376 -37.336  -2.235  1.00 43.91           C  
ATOM    250  N   LYS A  58      41.082 -34.878  -3.994  1.00 28.78           N  
ATOM    251  CA  LYS A  58      40.822 -33.488  -4.316  1.00 29.22           C  
ATOM    252  C   LYS A  58      39.317 -33.312  -4.297  1.00 28.61           C  
ATOM    253  O   LYS A  58      38.584 -34.132  -4.920  1.00 30.47           O  
ATOM    254  CB  LYS A  58      41.317 -33.165  -5.707  1.00 31.81           C  
ATOM    255  CG  LYS A  58      41.077 -31.748  -6.186  1.00 33.56           C  
ATOM    256  CD  LYS A  58      41.861 -31.549  -7.476  1.00 41.07           C  
ATOM    257  CE  LYS A  58      41.489 -30.253  -8.141  1.00 46.03           C  
ATOM    258  NZ  LYS A  58      42.359 -30.125  -9.360  1.00 42.85           N  
ATOM    259  N   VAL A  59      38.884 -32.257  -3.619  1.00 27.36           N  
ATOM    260  CA  VAL A  59      37.457 -31.923  -3.501  1.00 27.83           C  
ATOM    261  C   VAL A  59      37.153 -30.761  -4.451  1.00 30.69           C  
ATOM    262  O   VAL A  59      37.789 -29.699  -4.367  1.00 30.87           O  
ATOM    263  CB  VAL A  59      37.120 -31.536  -2.032  1.00 28.51           C  
ATOM    264  CG1 VAL A  59      35.627 -31.126  -1.903  1.00 29.30           C  
ATOM    265  CG2 VAL A  59      37.410 -32.700  -1.071  1.00 28.56           C  
ATOM    266  N   SER A  60      36.152 -30.945  -5.319  1.00 27.87           N  
ATOM    267  CA  SER A  60      35.707 -29.895  -6.253  1.00 28.82           C  
ATOM    268  C   SER A  60      34.325 -29.435  -5.842  1.00 29.33           C  
ATOM    269  O   SER A  60      33.413 -30.289  -5.688  1.00 29.75           O  
ATOM    270  CB  SER A  60      35.662 -30.379  -7.697  1.00 32.60           C  
ATOM    271  OG  SER A  60      36.986 -30.741  -8.143  1.00 31.88           O  
ATOM    272  N   ILE A  61      34.148 -28.119  -5.701  1.00 28.39           N  
ATOM    273  CA  ILE A  61      32.958 -27.530  -5.101  1.00 28.66           C  
ATOM    274  C   ILE A  61      32.298 -26.605  -6.134  1.00 32.77           C  
ATOM    275  O   ILE A  61      33.019 -25.871  -6.830  1.00 31.19           O  
ATOM    276  CB  ILE A  61      33.480 -26.564  -3.908  1.00 32.78           C  
ATOM    277  CG1 ILE A  61      34.300 -27.404  -2.889  1.00 38.38           C  
ATOM    278  CG2 ILE A  61      32.323 -25.840  -3.231  1.00 38.47           C  
ATOM    279  CD1 ILE A  61      35.176 -26.621  -1.883  1.00 38.64           C  
ATOM    280  N   VAL A  62      30.956 -26.595  -6.221  1.00 30.33           N  
ATOM    281  CA  VAL A  62      30.219 -25.538  -6.932  1.00 29.37           C  
ATOM    282  C   VAL A  62      29.265 -25.014  -5.869  1.00 30.10           C  
ATOM    283  O   VAL A  62      28.678 -25.793  -5.099  1.00 29.85           O  
ATOM    284  CB  VAL A  62      29.348 -26.078  -8.102  1.00 28.49           C  
ATOM    285  CG1 VAL A  62      28.599 -24.975  -8.774  1.00 31.18           C  
ATOM    286  CG2 VAL A  62      30.209 -26.832  -9.124  1.00 29.52           C  
ATOM    287  N   ALA A  63      29.187 -23.684  -5.751  1.00 30.49           N  
ATOM    288  CA  ALA A  63      28.384 -23.093  -4.660  1.00 29.81           C  
ATOM    289  C   ALA A  63      27.763 -21.817  -5.144  1.00 30.64           C  
ATOM    290  O   ALA A  63      28.233 -21.219  -6.106  1.00 33.97           O  
ATOM    291  CB  ALA A  63      29.276 -22.862  -3.387  1.00 33.19           C  
ATOM    292  N   THR A  64      26.669 -21.457  -4.502  1.00 29.84           N  
ATOM    293  CA  THR A  64      25.897 -20.262  -4.877  1.00 30.74           C  
ATOM    294  C   THR A  64      26.007 -19.227  -3.760  1.00 32.11           C  
ATOM    295  O   THR A  64      25.721 -19.510  -2.585  1.00 31.66           O  
ATOM    296  CB  THR A  64      24.430 -20.611  -5.051  1.00 32.25           C  
ATOM    297  OG1 THR A  64      24.328 -21.542  -6.147  1.00 32.83           O  
ATOM    298  CG2 THR A  64      23.617 -19.384  -5.512  1.00 33.15           C  
ATOM    299  N   ASP A  65      26.454 -18.036  -4.165  1.00 30.17           N  
ATOM    300  CA  ASP A  65      26.554 -16.886  -3.270  1.00 30.10           C  
ATOM    301  C   ASP A  65      25.186 -16.577  -2.687  1.00 28.43           C  
ATOM    302  O   ASP A  65      24.197 -16.409  -3.431  1.00 30.54           O  
ATOM    303  CB  ASP A  65      27.060 -15.723  -4.111  1.00 29.72           C  
ATOM    304  CG  ASP A  65      27.417 -14.513  -3.290  1.00 32.43           C  
ATOM    305  OD1 ASP A  65      26.562 -13.991  -2.496  1.00 30.77           O  
ATOM    306  OD2 ASP A  65      28.566 -14.040  -3.371  1.00 32.27           O  
ATOM    307  N   ILE A  66      25.106 -16.571  -1.357  1.00 29.44           N  
ATOM    308  CA  ILE A  66      23.791 -16.439  -0.709  1.00 30.43           C  
ATOM    309  C   ILE A  66      23.181 -15.058  -0.880  1.00 32.65           C  
ATOM    310  O   ILE A  66      21.958 -14.877  -0.643  1.00 32.96           O  
ATOM    311  CB  ILE A  66      23.805 -16.836   0.791  1.00 30.60           C  
ATOM    312  CG1 ILE A  66      24.658 -15.874   1.620  1.00 29.92           C  
ATOM    313  CG2 ILE A  66      24.242 -18.295   0.927  1.00 32.81           C  
ATOM    314  CD1 ILE A  66      24.614 -16.181   3.153  1.00 29.66           C  
ATOM    315  N   PHE A  67      24.004 -14.081  -1.275  1.00 29.49           N  
ATOM    316  CA  PHE A  67      23.514 -12.715  -1.454  1.00 28.53           C  
ATOM    317  C   PHE A  67      23.364 -12.261  -2.881  1.00 28.55           C  
ATOM    318  O   PHE A  67      22.458 -11.477  -3.184  1.00 32.05           O  
ATOM    319  CB  PHE A  67      24.413 -11.724  -0.691  1.00 29.39           C  
ATOM    320  CG  PHE A  67      24.402 -11.945   0.814  1.00 27.97           C  
ATOM    321  CD1 PHE A  67      23.206 -11.895   1.529  1.00 28.88           C  
ATOM    322  CD2 PHE A  67      25.589 -12.181   1.519  1.00 29.47           C  
ATOM    323  CE1 PHE A  67      23.192 -12.079   2.957  1.00 30.52           C  
ATOM    324  CE2 PHE A  67      25.601 -12.380   2.907  1.00 28.65           C  
ATOM    325  CZ  PHE A  67      24.380 -12.291   3.643  1.00 30.73           C  
ATOM    326  N   THR A  68      24.266 -12.713  -3.762  1.00 28.67           N  
ATOM    327  CA  THR A  68      24.178 -12.263  -5.165  1.00 27.68           C  
ATOM    328  C   THR A  68      23.581 -13.330  -6.092  1.00 27.67           C  
ATOM    329  O   THR A  68      23.192 -13.017  -7.247  1.00 30.96           O  
ATOM    330  CB  THR A  68      25.550 -11.926  -5.753  1.00 28.75           C  
ATOM    331  OG1 THR A  68      26.337 -13.149  -5.755  1.00 29.47           O  
ATOM    332  CG2 THR A  68      26.332 -10.941  -4.891  1.00 31.13           C  
ATOM    333  N   GLY A  69      23.568 -14.570  -5.621  1.00 29.22           N  
ATOM    334  CA  GLY A  69      23.066 -15.675  -6.439  1.00 31.97           C  
ATOM    335  C   GLY A  69      24.064 -16.146  -7.464  1.00 33.28           C  
ATOM    336  O   GLY A  69      23.770 -17.049  -8.260  1.00 32.78           O  
ATOM    337  N   ASN A  70      25.267 -15.569  -7.459  1.00 28.88           N  
ATOM    338  CA  ASN A  70      26.293 -15.994  -8.432  1.00 30.34           C  
ATOM    339  C   ASN A  70      26.819 -17.379  -8.156  1.00 29.42           C  
ATOM    340  O   ASN A  70      26.877 -17.832  -6.977  1.00 30.24           O  
ATOM    341  CB  ASN A  70      27.475 -15.028  -8.427  1.00 29.85           C  
ATOM    342  CG  ASN A  70      27.115 -13.641  -8.915  1.00 35.97           C  
ATOM    343  OD1 ASN A  70      26.175 -13.474  -9.687  1.00 41.48           O  
ATOM    344  ND2 ASN A  70      27.900 -12.632  -8.499  1.00 35.80           N  
ATOM    345  N   ARG A  71      27.223 -18.052  -9.230  1.00 32.14           N  
ATOM    346  CA  ARG A  71      27.802 -19.403  -9.136  1.00 31.66           C  
ATOM    347  C   ARG A  71      29.310 -19.279  -9.025  1.00 32.26           C  
ATOM    348  O   ARG A  71      29.973 -18.638  -9.872  1.00 34.67           O  
ATOM    349  CB  ARG A  71      27.474 -20.164 -10.420  1.00 33.52           C  
ATOM    350  CG  ARG A  71      28.094 -21.557 -10.509  1.00 36.17           C  
ATOM    351  CD  ARG A  71      27.947 -22.131 -11.942  1.00 40.03           C  
ATOM    352  NE  ARG A  71      28.834 -23.286 -12.192  1.00 44.36           N  
ATOM    353  CZ  ARG A  71      28.387 -24.527 -12.255  1.00 48.38           C  
ATOM    354  NH1 ARG A  71      27.094 -24.782 -12.076  1.00 51.05           N  
ATOM    355  NH2 ARG A  71      29.226 -25.519 -12.499  1.00 49.23           N  
ATOM    356  N   LEU A  72      29.859 -19.883  -7.974  1.00 29.89           N  
ATOM    357  CA  LEU A  72      31.303 -19.853  -7.748  1.00 29.61           C  
ATOM    358  C   LEU A  72      31.814 -21.286  -7.639  1.00 31.79           C  
ATOM    359  O   LEU A  72      31.072 -22.211  -7.246  1.00 32.93           O  
ATOM    360  CB  LEU A  72      31.611 -19.095  -6.457  1.00 33.05           C  
ATOM    361  CG  LEU A  72      31.321 -17.585  -6.527  1.00 36.48           C  
ATOM    362  CD1 LEU A  72      31.534 -16.861  -5.238  1.00 41.95           C  
ATOM    363  CD2 LEU A  72      32.198 -16.925  -7.601  1.00 46.58           C  
ATOM    364  N   GLU A  73      33.063 -21.500  -8.030  1.00 31.09           N  
ATOM    365  CA  GLU A  73      33.626 -22.844  -7.986  1.00 30.75           C  
ATOM    366  C   GLU A  73      34.960 -22.752  -7.263  1.00 31.11           C  
ATOM    367  O   GLU A  73      35.665 -21.707  -7.355  1.00 32.40           O  
ATOM    368  CB  GLU A  73      33.891 -23.356  -9.392  1.00 33.71           C  
ATOM    369  CG  GLU A  73      32.620 -23.459 -10.231  1.00 34.83           C  
ATOM    370  CD  GLU A  73      32.814 -24.277 -11.508  1.00 50.79           C  
ATOM    371  OE1 GLU A  73      33.731 -25.125 -11.560  1.00 58.88           O  
ATOM    372  OE2 GLU A  73      32.029 -24.098 -12.465  1.00 54.34           O  
ATOM    373  N   ASP A  74      35.345 -23.857  -6.623  1.00 31.08           N  
ATOM    374  CA  ASP A  74      36.690 -23.940  -6.005  1.00 29.30           C  
ATOM    375  C   ASP A  74      37.082 -25.405  -5.888  1.00 32.74           C  
ATOM    376  O   ASP A  74      36.229 -26.290  -5.971  1.00 31.16           O  
ATOM    377  CB  ASP A  74      36.669 -23.284  -4.631  1.00 31.62           C  
ATOM    378  CG  ASP A  74      38.021 -22.856  -4.161  1.00 36.11           C  
ATOM    379  OD1 ASP A  74      39.037 -22.853  -4.917  1.00 32.95           O  
ATOM    380  OD2 ASP A  74      38.095 -22.453  -3.000  1.00 39.01           O  
ATOM    381  N   GLN A  75      38.373 -25.670  -5.735  1.00 29.49           N  
ATOM    382  CA  GLN A  75      38.819 -27.061  -5.519  1.00 27.59           C  
ATOM    383  C   GLN A  75      39.931 -27.007  -4.516  1.00 29.97           C  
ATOM    384  O   GLN A  75      40.665 -26.008  -4.476  1.00 31.00           O  
ATOM    385  CB  GLN A  75      39.375 -27.729  -6.786  1.00 28.47           C  
ATOM    386  CG  GLN A  75      38.430 -27.632  -7.992  1.00 29.61           C  
ATOM    387  CD  GLN A  75      38.577 -26.295  -8.690  1.00 34.38           C  
ATOM    388  OE1 GLN A  75      39.727 -25.829  -8.893  1.00 36.55           O  
ATOM    389  NE2 GLN A  75      37.448 -25.653  -9.034  1.00 36.73           N  
ATOM    390  N   ALA A  76      40.067 -28.062  -3.722  1.00 29.80           N  
ATOM    391  CA  ALA A  76      41.102 -28.073  -2.666  1.00 29.25           C  
ATOM    392  C   ALA A  76      41.419 -29.511  -2.306  1.00 28.87           C  
ATOM    393  O   ALA A  76      40.575 -30.397  -2.447  1.00 28.80           O  
ATOM    394  CB  ALA A  76      40.540 -27.415  -1.435  1.00 35.15           C  
ATOM    395  N   PRO A  77      42.591 -29.761  -1.774  1.00 27.76           N  
ATOM    396  CA  PRO A  77      42.857 -31.075  -1.154  1.00 26.46           C  
ATOM    397  C   PRO A  77      41.898 -31.345  -0.025  1.00 27.78           C  
ATOM    398  O   PRO A  77      41.466 -30.444   0.678  1.00 29.03           O  
ATOM    399  CB  PRO A  77      44.266 -30.906  -0.562  1.00 29.77           C  
ATOM    400  CG  PRO A  77      44.839 -29.699  -1.301  1.00 33.46           C  
ATOM    401  CD  PRO A  77      43.750 -28.836  -1.654  1.00 29.49           C  
ATOM    402  N   SER A  78      41.547 -32.618   0.147  1.00 27.84           N  
ATOM    403  CA  SER A  78      40.593 -32.921   1.213  1.00 30.02           C  
ATOM    404  C   SER A  78      41.075 -32.508   2.584  1.00 28.45           C  
ATOM    405  O   SER A  78      40.227 -32.301   3.487  1.00 33.34           O  
ATOM    406  CB  SER A  78      40.292 -34.426   1.228  1.00 29.61           C  
ATOM    407  OG  SER A  78      41.483 -35.196   1.398  1.00 35.63           O  
ATOM    408  N   THR A  79      42.398 -32.364   2.777  1.00 29.35           N  
ATOM    409  CA  THR A  79      42.963 -31.963   4.066  1.00 31.17           C  
ATOM    410  C   THR A  79      43.130 -30.456   4.216  1.00 30.60           C  
ATOM    411  O   THR A  79      43.593 -29.991   5.275  1.00 31.55           O  
ATOM    412  CB  THR A  79      44.332 -32.595   4.263  1.00 34.42           C  
ATOM    413  OG1 THR A  79      45.148 -32.362   3.099  1.00 33.40           O  
ATOM    414  CG2 THR A  79      44.197 -34.144   4.333  1.00 36.61           C  
ATOM    415  N   HIS A  80      42.861 -29.698   3.141  1.00 28.19           N  
ATOM    416  CA  HIS A  80      42.958 -28.238   3.248  1.00 28.33           C  
ATOM    417  C   HIS A  80      41.757 -27.749   4.034  1.00 29.45           C  
ATOM    418  O   HIS A  80      40.660 -28.261   3.838  1.00 31.58           O  
ATOM    419  CB  HIS A  80      42.963 -27.653   1.817  1.00 28.79           C  
ATOM    420  CG  HIS A  80      42.702 -26.190   1.762  1.00 28.81           C  
ATOM    421  ND1 HIS A  80      43.680 -25.250   2.028  1.00 30.98           N  
ATOM    422  CD2 HIS A  80      41.555 -25.508   1.530  1.00 31.40           C  
ATOM    423  CE1 HIS A  80      43.142 -24.045   1.900  1.00 30.45           C  
ATOM    424  NE2 HIS A  80      41.865 -24.166   1.605  1.00 32.74           N  
ATOM    425  N   ASN A  81      41.958 -26.751   4.913  1.00 29.26           N  
ATOM    426  CA  ASN A  81      40.822 -26.185   5.591  1.00 28.29           C  
ATOM    427  C   ASN A  81      40.190 -25.040   4.792  1.00 32.26           C  
ATOM    428  O   ASN A  81      40.855 -24.042   4.541  1.00 35.41           O  
ATOM    429  CB  ASN A  81      41.283 -25.675   6.933  1.00 30.27           C  
ATOM    430  CG  ASN A  81      41.819 -26.800   7.781  1.00 29.70           C  
ATOM    431  OD1 ASN A  81      41.138 -27.830   7.895  1.00 31.53           O  
ATOM    432  ND2 ASN A  81      43.006 -26.654   8.334  1.00 30.72           N  
ATOM    433  N   VAL A  82      38.951 -25.239   4.405  1.00 31.68           N  
ATOM    434  CA  VAL A  82      38.160 -24.153   3.776  1.00 34.21           C  
ATOM    435  C   VAL A  82      37.664 -23.255   4.912  1.00 37.61           C  
ATOM    436  O   VAL A  82      37.733 -23.660   6.099  1.00 34.74           O  
ATOM    437  CB  VAL A  82      36.981 -24.695   2.952  1.00 35.70           C  
ATOM    438  CG1 VAL A  82      37.456 -25.587   1.812  1.00 36.59           C  
ATOM    439  CG2 VAL A  82      35.922 -25.440   3.856  1.00 35.82           C  
ATOM    440  N   GLU A  83      37.261 -22.020   4.593  1.00 34.40           N  
ATOM    441  CA  GLU A  83      36.619 -21.173   5.612  1.00 33.06           C  
ATOM    442  C   GLU A  83      35.119 -21.268   5.438  1.00 34.85           C  
ATOM    443  O   GLU A  83      34.590 -21.265   4.330  1.00 34.69           O  
ATOM    444  CB  GLU A  83      37.033 -19.707   5.436  1.00 38.32           C  
ATOM    445  CG  GLU A  83      38.504 -19.416   5.698  1.00 48.24           C  
ATOM    446  CD  GLU A  83      38.915 -18.116   5.008  1.00 63.19           C  
ATOM    447  OE1 GLU A  83      38.460 -17.872   3.865  1.00 70.79           O  
ATOM    448  OE2 GLU A  83      39.673 -17.326   5.607  1.00 68.46           O  
ATOM    449  N   VAL A  84      34.409 -21.393   6.559  1.00 29.02           N  
ATOM    450  CA  VAL A  84      32.944 -21.462   6.574  1.00 29.50           C  
ATOM    451  C   VAL A  84      32.486 -20.185   7.239  1.00 28.51           C  
ATOM    452  O   VAL A  84      32.967 -19.834   8.296  1.00 28.56           O  
ATOM    453  CB  VAL A  84      32.447 -22.676   7.366  1.00 30.43           C  
ATOM    454  CG1 VAL A  84      30.923 -22.733   7.406  1.00 30.49           C  
ATOM    455  CG2 VAL A  84      32.996 -23.991   6.797  1.00 33.18           C  
ATOM    456  N   PRO A  85      31.549 -19.457   6.643  1.00 29.74           N  
ATOM    457  CA  PRO A  85      31.095 -18.222   7.291  1.00 28.13           C  
ATOM    458  C   PRO A  85      30.207 -18.536   8.474  1.00 29.13           C  
ATOM    459  O   PRO A  85      29.336 -19.443   8.377  1.00 31.92           O  
ATOM    460  CB  PRO A  85      30.228 -17.535   6.198  1.00 28.65           C  
ATOM    461  CG  PRO A  85      29.683 -18.705   5.398  1.00 29.15           C  
ATOM    462  CD  PRO A  85      30.858 -19.714   5.362  1.00 29.67           C  
ATOM    463  N   PHE A  86      30.344 -17.724   9.513  1.00 27.74           N  
ATOM    464  CA  PHE A  86      29.308 -17.613  10.533  1.00 29.80           C  
ATOM    465  C   PHE A  86      28.097 -16.981   9.856  1.00 33.09           C  
ATOM    466  O   PHE A  86      28.218 -15.950   9.179  1.00 33.04           O  
ATOM    467  CB  PHE A  86      29.797 -16.782  11.710  1.00 29.81           C  
ATOM    468  CG  PHE A  86      30.798 -17.512  12.590  1.00 26.79           C  
ATOM    469  CD1 PHE A  86      30.386 -18.610  13.363  1.00 32.88           C  
ATOM    470  CD2 PHE A  86      32.110 -17.088  12.688  1.00 35.71           C  
ATOM    471  CE1 PHE A  86      31.284 -19.291  14.209  1.00 30.95           C  
ATOM    472  CE2 PHE A  86      33.041 -17.775  13.532  1.00 33.59           C  
ATOM    473  CZ  PHE A  86      32.617 -18.884  14.289  1.00 32.88           C  
ATOM    474  N   VAL A  87      26.927 -17.586  10.020  1.00 26.69           N  
ATOM    475  CA  VAL A  87      25.730 -17.060   9.405  1.00 24.12           C  
ATOM    476  C   VAL A  87      24.716 -16.768  10.522  1.00 31.05           C  
ATOM    477  O   VAL A  87      24.515 -17.613  11.416  1.00 32.38           O  
ATOM    478  CB  VAL A  87      25.190 -18.023   8.323  1.00 26.45           C  
ATOM    479  CG1 VAL A  87      23.870 -17.525   7.740  1.00 31.09           C  
ATOM    480  CG2 VAL A  87      26.202 -18.236   7.199  1.00 25.66           C  
ATOM    481  N   LYS A  88      24.206 -15.550  10.546  1.00 30.19           N  
ATOM    482  CA  LYS A  88      23.191 -15.206  11.550  1.00 32.30           C  
ATOM    483  C   LYS A  88      21.895 -14.858  10.862  1.00 30.17           C  
ATOM    484  O   LYS A  88      21.901 -14.326   9.777  1.00 31.33           O  
ATOM    485  CB  LYS A  88      23.639 -14.004  12.393  1.00 36.73           C  
ATOM    486  CG  LYS A  88      24.847 -14.255  13.318  1.00 47.77           C  
ATOM    487  CD  LYS A  88      24.524 -15.188  14.499  1.00 62.81           C  
ATOM    488  CE  LYS A  88      23.357 -14.694  15.387  1.00 66.55           C  
ATOM    489  NZ  LYS A  88      23.706 -13.553  16.300  1.00 68.79           N  
ATOM    490  N   THR A  89      20.767 -15.139  11.512  1.00 30.48           N  
ATOM    491  CA  THR A  89      19.463 -14.838  10.904  1.00 28.22           C  
ATOM    492  C   THR A  89      18.617 -14.109  11.942  1.00 31.11           C  
ATOM    493  O   THR A  89      18.681 -14.402  13.136  1.00 31.35           O  
ATOM    494  CB  THR A  89      18.759 -16.134  10.491  1.00 34.51           C  
ATOM    495  OG1 THR A  89      19.629 -16.885   9.618  1.00 39.06           O  
ATOM    496  CG2 THR A  89      17.613 -15.842   9.613  1.00 37.60           C  
ATOM    497  N   TYR A  90      17.843 -13.156  11.460  1.00 27.65           N  
ATOM    498  CA  TYR A  90      16.885 -12.470  12.332  1.00 30.61           C  
ATOM    499  C   TYR A  90      15.631 -12.156  11.566  1.00 34.61           C  
ATOM    500  O   TYR A  90      15.692 -11.833  10.389  1.00 34.03           O  
ATOM    501  CB  TYR A  90      17.471 -11.191  12.917  1.00 35.63           C  
ATOM    502  CG  TYR A  90      16.693 -10.731  14.179  1.00 38.62           C  
ATOM    503  CD1 TYR A  90      15.474 -10.053  14.068  1.00 38.93           C  
ATOM    504  CD2 TYR A  90      17.173 -11.016  15.465  1.00 46.19           C  
ATOM    505  CE1 TYR A  90      14.741  -9.613  15.225  1.00 38.75           C  
ATOM    506  CE2 TYR A  90      16.468 -10.602  16.610  1.00 48.58           C  
ATOM    507  CZ  TYR A  90      15.257  -9.911  16.468  1.00 47.79           C  
ATOM    508  OH  TYR A  90      14.562  -9.500  17.577  1.00 45.24           O  
ATOM    509  N   THR A  91      14.493 -12.219  12.251  1.00 32.91           N  
ATOM    510  CA  THR A  91      13.225 -11.996  11.561  1.00 31.68           C  
ATOM    511  C   THR A  91      12.599 -10.719  12.111  1.00 33.00           C  
ATOM    512  O   THR A  91      12.509 -10.543  13.338  1.00 34.88           O  
ATOM    513  CB  THR A  91      12.301 -13.165  11.797  1.00 34.53           C  
ATOM    514  OG1 THR A  91      12.900 -14.342  11.231  1.00 36.44           O  
ATOM    515  CG2 THR A  91      11.044 -12.980  10.977  1.00 34.43           C  
ATOM    516  N   TYR A  92      12.196  -9.855  11.187  1.00 29.48           N  
ATOM    517  CA  TYR A  92      11.602  -8.557  11.505  1.00 29.18           C  
ATOM    518  C   TYR A  92      10.234  -8.481  10.878  1.00 31.93           C  
ATOM    519  O   TYR A  92       9.962  -9.153   9.898  1.00 32.30           O  
ATOM    520  CB  TYR A  92      12.397  -7.367  10.894  1.00 29.13           C  
ATOM    521  CG  TYR A  92      13.824  -7.247  11.387  1.00 29.15           C  
ATOM    522  CD1 TYR A  92      14.848  -7.944  10.730  1.00 29.79           C  
ATOM    523  CD2 TYR A  92      14.170  -6.400  12.455  1.00 30.97           C  
ATOM    524  CE1 TYR A  92      16.165  -7.837  11.164  1.00 32.79           C  
ATOM    525  CE2 TYR A  92      15.457  -6.302  12.892  1.00 31.51           C  
ATOM    526  CZ  TYR A  92      16.455  -7.038  12.229  1.00 32.43           C  
ATOM    527  OH  TYR A  92      17.774  -6.944  12.641  1.00 33.58           O  
ATOM    528  N   SER A  93       9.357  -7.620  11.415  1.00 28.37           N  
ATOM    529  CA  SER A  93       8.106  -7.325  10.656  1.00 28.18           C  
ATOM    530  C   SER A  93       8.249  -6.000   9.938  1.00 31.05           C  
ATOM    531  O   SER A  93       8.990  -5.107  10.372  1.00 32.06           O  
ATOM    532  CB  SER A  93       6.862  -7.306  11.586  1.00 31.80           C  
ATOM    533  OG  SER A  93       6.839  -6.151  12.446  1.00 31.20           O  
ATOM    534  N   VAL A  94       7.501  -5.846   8.860  1.00 31.58           N  
ATOM    535  CA  VAL A  94       7.623  -4.634   8.060  1.00 31.18           C  
ATOM    536  C   VAL A  94       6.618  -3.568   8.525  1.00 31.35           C  
ATOM    537  O   VAL A  94       5.392  -3.798   8.506  1.00 30.78           O  
ATOM    538  CB  VAL A  94       7.392  -4.953   6.596  1.00 29.09           C  
ATOM    539  CG1 VAL A  94       7.497  -3.670   5.733  1.00 30.89           C  
ATOM    540  CG2 VAL A  94       8.420  -6.005   6.146  1.00 29.74           C  
ATOM    541  N   LEU A  95       7.159  -2.422   8.968  1.00 29.08           N  
ATOM    542  CA  LEU A  95       6.346  -1.274   9.401  1.00 26.99           C  
ATOM    543  C   LEU A  95       5.977  -0.307   8.271  1.00 27.03           C  
ATOM    544  O   LEU A  95       4.954   0.387   8.312  1.00 28.28           O  
ATOM    545  CB  LEU A  95       7.122  -0.439  10.440  1.00 28.61           C  
ATOM    546  CG  LEU A  95       7.513  -1.201  11.674  1.00 28.41           C  
ATOM    547  CD1 LEU A  95       8.494  -0.369  12.484  1.00 28.70           C  
ATOM    548  CD2 LEU A  95       6.277  -1.533  12.518  1.00 30.21           C  
ATOM    549  N   ASP A  96       6.828  -0.269   7.249  1.00 29.29           N  
ATOM    550  CA  ASP A  96       6.627   0.672   6.154  1.00 27.83           C  
ATOM    551  C   ASP A  96       7.601   0.347   5.049  1.00 30.19           C  
ATOM    552  O   ASP A  96       8.639  -0.257   5.298  1.00 29.90           O  
ATOM    553  CB  ASP A  96       6.888   2.111   6.613  1.00 29.70           C  
ATOM    554  CG  ASP A  96       6.169   3.147   5.769  1.00 31.33           C  
ATOM    555  OD1 ASP A  96       5.464   2.811   4.774  1.00 30.84           O  
ATOM    556  OD2 ASP A  96       6.212   4.383   6.034  1.00 34.26           O  
ATOM    557  N   ILE A  97       7.236   0.753   3.828  1.00 28.93           N  
ATOM    558  CA  ILE A  97       8.090   0.686   2.663  1.00 30.79           C  
ATOM    559  C   ILE A  97       8.049   2.071   2.045  1.00 29.23           C  
ATOM    560  O   ILE A  97       6.975   2.586   1.751  1.00 30.90           O  
ATOM    561  CB  ILE A  97       7.557  -0.346   1.637  1.00 30.45           C  
ATOM    562  CG1 ILE A  97       7.419  -1.722   2.330  1.00 29.89           C  
ATOM    563  CG2 ILE A  97       8.511  -0.388   0.402  1.00 32.76           C  
ATOM    564  CD1 ILE A  97       6.700  -2.750   1.454  1.00 33.72           C  
ATOM    565  N   GLN A  98       9.216   2.677   1.844  1.00 31.57           N  
ATOM    566  CA  GLN A  98       9.259   4.030   1.266  1.00 33.19           C  
ATOM    567  C   GLN A  98      10.217   4.103   0.107  1.00 31.75           C  
ATOM    568  O   GLN A  98      11.362   3.704   0.245  1.00 32.39           O  
ATOM    569  CB  GLN A  98       9.668   5.052   2.323  1.00 37.81           C  
ATOM    570  CG  GLN A  98       8.591   5.285   3.371  1.00 42.71           C  
ATOM    571  CD  GLN A  98       8.330   6.756   3.678  1.00 59.27           C  
ATOM    572  OE1 GLN A  98       8.190   7.578   2.767  1.00 60.73           O  
ATOM    573  NE2 GLN A  98       8.242   7.087   4.969  1.00 61.51           N  
ATOM    574  N   ALA A  99       9.757   4.609  -1.036  1.00 33.07           N  
ATOM    575  CA  ALA A  99      10.616   4.671  -2.215  1.00 34.23           C  
ATOM    576  C   ALA A  99      11.839   5.542  -1.934  1.00 32.23           C  
ATOM    577  O   ALA A  99      11.776   6.502  -1.150  1.00 35.58           O  
ATOM    578  CB  ALA A  99       9.844   5.214  -3.415  1.00 37.96           C  
ATOM    579  N   ASN A 100      12.952   5.191  -2.546  1.00 33.39           N  
ATOM    580  CA  ASN A 100      14.126   6.042  -2.539  1.00 36.49           C  
ATOM    581  C   ASN A 100      13.850   7.387  -3.246  1.00 38.15           C  
ATOM    582  O   ASN A 100      13.117   7.414  -4.232  1.00 36.32           O  
ATOM    583  CB  ASN A 100      15.256   5.287  -3.231  1.00 36.48           C  
ATOM    584  CG  ASN A 100      16.612   5.883  -2.955  1.00 42.93           C  
ATOM    585  OD1 ASN A 100      16.909   7.011  -3.350  1.00 46.64           O  
ATOM    586  ND2 ASN A 100      17.453   5.119  -2.276  1.00 40.60           N  
ATOM    587  N   GLU A 101      14.433   8.476  -2.731  1.00 40.14           N  
ATOM    588  CA  GLU A 101      14.434   9.801  -3.401  1.00 43.66           C  
ATOM    589  C   GLU A 101      14.860   9.693  -4.858  1.00 43.22           C  
ATOM    590  O   GLU A 101      14.535  10.558  -5.691  1.00 41.69           O  
ATOM    591  CB  GLU A 101      15.381  10.783  -2.700  1.00 45.76           C  
ATOM    592  CG  GLU A 101      14.975  11.195  -1.291  1.00 55.31           C  
ATOM    593  CD  GLU A 101      13.561  11.737  -1.206  1.00 59.30           C  
ATOM    594  OE1 GLU A 101      13.250  12.698  -1.944  1.00 62.58           O  
ATOM    595  OE2 GLU A 101      12.766  11.199  -0.392  1.00 60.81           O  
ATOM    596  N   ASP A 102      15.644   8.653  -5.130  1.00 43.59           N  
ATOM    597  CA  ASP A 102      15.968   8.207  -6.477  1.00 41.44           C  
ATOM    598  C   ASP A 102      15.130   6.957  -6.762  1.00 40.33           C  
ATOM    599  O   ASP A 102      15.477   5.849  -6.318  1.00 39.89           O  
ATOM    600  CB  ASP A 102      17.461   7.892  -6.593  1.00 42.83           C  
ATOM    601  CG  ASP A 102      17.884   7.545  -8.018  1.00 46.53           C  
ATOM    602  OD1 ASP A 102      16.998   7.324  -8.875  1.00 45.06           O  
ATOM    603  OD2 ASP A 102      19.083   7.468  -8.373  1.00 49.07           O  
ATOM    604  N   PRO A 103      14.024   7.139  -7.483  1.00 40.06           N  
ATOM    605  CA  PRO A 103      13.079   6.049  -7.781  1.00 40.20           C  
ATOM    606  C   PRO A 103      13.705   4.826  -8.463  1.00 40.16           C  
ATOM    607  O   PRO A 103      13.092   3.761  -8.448  1.00 41.22           O  
ATOM    608  CB  PRO A 103      12.068   6.711  -8.728  1.00 41.50           C  
ATOM    609  CG  PRO A 103      12.708   7.978  -9.182  1.00 41.97           C  
ATOM    610  CD  PRO A 103      13.596   8.422  -8.075  1.00 35.91           C  
ATOM    611  N   SER A 104      14.900   4.966  -9.032  1.00 40.02           N  
ATOM    612  CA  SER A 104      15.557   3.841  -9.707  1.00 40.97           C  
ATOM    613  C   SER A 104      16.308   2.892  -8.769  1.00 42.30           C  
ATOM    614  O   SER A 104      16.776   1.834  -9.179  1.00 43.37           O  
ATOM    615  CB  SER A 104      16.490   4.351 -10.813  1.00 39.33           C  
ATOM    616  OG  SER A 104      17.685   4.896 -10.277  1.00 39.94           O  
ATOM    617  N   LEU A 105      16.395   3.260  -7.494  1.00 43.00           N  
ATOM    618  CA  LEU A 105      17.116   2.469  -6.509  1.00 40.86           C  
ATOM    619  C   LEU A 105      16.103   1.735  -5.606  1.00 39.07           C  
ATOM    620  O   LEU A 105      14.941   2.134  -5.576  1.00 37.42           O  
ATOM    621  CB  LEU A 105      18.020   3.391  -5.691  1.00 42.87           C  
ATOM    622  CG  LEU A 105      19.231   3.992  -6.407  1.00 44.08           C  
ATOM    623  CD1 LEU A 105      19.747   5.190  -5.621  1.00 45.71           C  
ATOM    624  CD2 LEU A 105      20.317   2.928  -6.598  1.00 44.83           C  
ATOM    625  N   PRO A 106      16.527   0.676  -4.901  1.00 37.83           N  
ATOM    626  CA  PRO A 106      15.636  -0.094  -4.003  1.00 37.37           C  
ATOM    627  C   PRO A 106      14.943   0.752  -2.940  1.00 34.81           C  
ATOM    628  O   PRO A 106      15.518   1.719  -2.427  1.00 34.28           O  
ATOM    629  CB  PRO A 106      16.587  -1.101  -3.329  1.00 35.12           C  
ATOM    630  CG  PRO A 106      17.740  -1.255  -4.314  1.00 41.71           C  
ATOM    631  CD  PRO A 106      17.892   0.102  -4.949  1.00 36.70           C  
ATOM    632  N   ALA A 107      13.697   0.398  -2.630  1.00 32.51           N  
ATOM    633  CA  ALA A 107      12.928   1.115  -1.621  1.00 31.23           C  
ATOM    634  C   ALA A 107      13.536   0.871  -0.264  1.00 31.69           C  
ATOM    635  O   ALA A 107      14.194  -0.141  -0.052  1.00 30.31           O  
ATOM    636  CB  ALA A 107      11.467   0.661  -1.629  1.00 30.23           C  
ATOM    637  N   HIS A 108      13.300   1.795   0.663  1.00 29.21           N  
ATOM    638  CA  HIS A 108      13.766   1.631   2.037  1.00 29.26           C  
ATOM    639  C   HIS A 108      12.734   0.860   2.864  1.00 30.96           C  
ATOM    640  O   HIS A 108      11.534   1.006   2.651  1.00 32.05           O  
ATOM    641  CB  HIS A 108      13.966   2.999   2.706  1.00 33.01           C  
ATOM    642  CG  HIS A 108      14.878   3.908   1.957  1.00 32.47           C  
ATOM    643  ND1 HIS A 108      16.197   3.590   1.693  1.00 34.30           N  
ATOM    644  CD2 HIS A 108      14.659   5.122   1.402  1.00 32.49           C  
ATOM    645  CE1 HIS A 108      16.755   4.580   1.009  1.00 35.95           C  
ATOM    646  NE2 HIS A 108      15.848   5.525   0.826  1.00 38.20           N  
ATOM    647  N   LEU A 109      13.211   0.058   3.802  1.00 29.33           N  
ATOM    648  CA  LEU A 109      12.304  -0.664   4.691  1.00 30.78           C  
ATOM    649  C   LEU A 109      12.386  -0.088   6.101  1.00 31.48           C  
ATOM    650  O   LEU A 109      13.451   0.371   6.531  1.00 31.13           O  
ATOM    651  CB  LEU A 109      12.676  -2.159   4.767  1.00 30.00           C  
ATOM    652  CG  LEU A 109      12.503  -2.976   3.501  1.00 32.94           C  
ATOM    653  CD1 LEU A 109      13.054  -4.426   3.642  1.00 31.67           C  
ATOM    654  CD2 LEU A 109      11.013  -2.939   3.047  1.00 36.68           C  
ATOM    655  N   SER A 110      11.249  -0.046   6.804  1.00 29.00           N  
ATOM    656  CA  SER A 110      11.260   0.252   8.236  1.00 30.50           C  
ATOM    657  C   SER A 110      10.855  -1.067   8.883  1.00 31.49           C  
ATOM    658  O   SER A 110       9.787  -1.649   8.510  1.00 31.15           O  
ATOM    659  CB  SER A 110      10.243   1.353   8.560  1.00 33.14           C  
ATOM    660  OG  SER A 110      10.239   1.572   9.975  1.00 34.65           O  
ATOM    661  N   LEU A 111      11.676  -1.581   9.824  1.00 31.03           N  
ATOM    662  CA  LEU A 111      11.524  -2.976  10.285  1.00 29.29           C  
ATOM    663  C   LEU A 111      11.472  -3.035  11.778  1.00 33.24           C  
ATOM    664  O   LEU A 111      12.234  -2.339  12.423  1.00 36.42           O  
ATOM    665  CB  LEU A 111      12.752  -3.834   9.843  1.00 31.18           C  
ATOM    666  CG  LEU A 111      12.895  -3.909   8.313  1.00 30.47           C  
ATOM    667  CD1 LEU A 111      14.144  -4.773   7.974  1.00 35.20           C  
ATOM    668  CD2 LEU A 111      11.665  -4.535   7.652  1.00 31.44           C  
ATOM    669  N   MET A 112      10.583  -3.855  12.334  1.00 30.10           N  
ATOM    670  CA  MET A 112      10.445  -3.975  13.786  1.00 27.89           C  
ATOM    671  C   MET A 112      11.015  -5.278  14.309  1.00 28.84           C  
ATOM    672  O   MET A 112      10.660  -6.367  13.799  1.00 30.29           O  
ATOM    673  CB  MET A 112       8.930  -3.889  14.150  1.00 29.51           C  
ATOM    674  CG  MET A 112       8.679  -4.082  15.620  1.00 32.49           C  
ATOM    675  SD  MET A 112       9.237  -2.695  16.582  1.00 32.06           S  
ATOM    676  CE  MET A 112       7.867  -1.577  16.388  1.00 32.42           C  
ATOM    677  N   ASP A 113      11.885  -5.211  15.318  1.00 30.12           N  
ATOM    678  CA  ASP A 113      12.394  -6.427  15.902  1.00 29.52           C  
ATOM    679  C   ASP A 113      11.487  -6.975  17.010  1.00 30.95           C  
ATOM    680  O   ASP A 113      10.405  -6.439  17.288  1.00 33.23           O  
ATOM    681  CB  ASP A 113      13.891  -6.315  16.331  1.00 29.99           C  
ATOM    682  CG  ASP A 113      14.111  -5.527  17.591  1.00 29.99           C  
ATOM    683  OD1 ASP A 113      13.169  -5.251  18.388  1.00 30.13           O  
ATOM    684  OD2 ASP A 113      15.281  -5.182  17.929  1.00 31.29           O  
ATOM    685  N   ASP A 114      11.910  -8.071  17.662  1.00 33.16           N  
ATOM    686  CA  ASP A 114      10.987  -8.687  18.602  1.00 34.43           C  
ATOM    687  C   ASP A 114      11.017  -8.087  19.999  1.00 33.84           C  
ATOM    688  O   ASP A 114      10.307  -8.556  20.905  1.00 33.47           O  
ATOM    689  CB  ASP A 114      11.103 -10.223  18.603  1.00 40.35           C  
ATOM    690  CG  ASP A 114      12.477 -10.721  18.965  1.00 50.84           C  
ATOM    691  OD1 ASP A 114      13.308  -9.959  19.520  1.00 55.28           O  
ATOM    692  OD2 ASP A 114      12.809 -11.903  18.736  1.00 56.98           O  
ATOM    693  N   GLU A 115      11.817  -7.040  20.167  1.00 31.36           N  
ATOM    694  CA  GLU A 115      11.856  -6.285  21.413  1.00 28.73           C  
ATOM    695  C   GLU A 115      11.309  -4.872  21.259  1.00 26.91           C  
ATOM    696  O   GLU A 115      11.562  -4.020  22.119  1.00 27.90           O  
ATOM    697  CB  GLU A 115      13.291  -6.128  21.896  1.00 32.45           C  
ATOM    698  CG  GLU A 115      14.054  -7.390  22.105  1.00 38.37           C  
ATOM    699  CD  GLU A 115      15.272  -7.115  22.931  1.00 34.47           C  
ATOM    700  OE1 GLU A 115      16.094  -6.234  22.511  1.00 34.85           O  
ATOM    701  OE2 GLU A 115      15.438  -7.821  23.936  1.00 41.59           O  
ATOM    702  N   GLY A 116      10.563  -4.610  20.173  1.00 27.90           N  
ATOM    703  CA  GLY A 116       9.970  -3.290  20.066  1.00 31.17           C  
ATOM    704  C   GLY A 116      10.902  -2.200  19.549  1.00 31.02           C  
ATOM    705  O   GLY A 116      10.522  -1.023  19.592  1.00 29.96           O  
ATOM    706  N   GLU A 117      12.070  -2.578  19.007  1.00 28.09           N  
ATOM    707  CA  GLU A 117      12.977  -1.561  18.439  1.00 29.52           C  
ATOM    708  C   GLU A 117      12.934  -1.650  16.938  1.00 29.00           C  
ATOM    709  O   GLU A 117      12.981  -2.749  16.385  1.00 30.07           O  
ATOM    710  CB  GLU A 117      14.418  -1.759  18.918  1.00 28.58           C  
ATOM    711  CG  GLU A 117      14.573  -1.579  20.434  1.00 30.14           C  
ATOM    712  CD  GLU A 117      14.586  -0.111  20.912  1.00 41.36           C  
ATOM    713  OE1 GLU A 117      14.495   0.823  20.078  1.00 40.74           O  
ATOM    714  OE2 GLU A 117      14.647   0.127  22.145  1.00 37.81           O  
ATOM    715  N   SER A 118      12.881  -0.506  16.258  1.00 30.66           N  
ATOM    716  CA  SER A 118      12.864  -0.598  14.792  1.00 30.97           C  
ATOM    717  C   SER A 118      14.192  -0.198  14.204  1.00 31.13           C  
ATOM    718  O   SER A 118      15.023   0.458  14.845  1.00 33.54           O  
ATOM    719  CB  SER A 118      11.751   0.229  14.164  1.00 31.51           C  
ATOM    720  OG  SER A 118      11.967   1.569  14.516  1.00 36.46           O  
ATOM    721  N   ARG A 119      14.392  -0.642  12.968  1.00 30.68           N  
ATOM    722  CA  ARG A 119      15.567  -0.202  12.227  1.00 33.81           C  
ATOM    723  C   ARG A 119      15.171   0.283  10.834  1.00 32.00           C  
ATOM    724  O   ARG A 119      14.267  -0.294  10.208  1.00 32.42           O  
ATOM    725  CB  ARG A 119      16.647  -1.270  12.182  1.00 36.11           C  
ATOM    726  CG  ARG A 119      16.310  -2.514  11.405  1.00 34.97           C  
ATOM    727  CD  ARG A 119      17.385  -3.607  11.529  1.00 36.78           C  
ATOM    728  NE  ARG A 119      18.651  -3.223  10.888  1.00 36.14           N  
ATOM    729  CZ  ARG A 119      19.699  -4.043  10.714  1.00 36.57           C  
ATOM    730  NH1 ARG A 119      19.649  -5.297  11.144  1.00 35.55           N  
ATOM    731  NH2 ARG A 119      20.810  -3.619  10.088  1.00 36.48           N  
ATOM    732  N   GLU A 120      15.840   1.352  10.377  1.00 30.97           N  
ATOM    733  CA  GLU A 120      15.442   1.950   9.100  1.00 32.66           C  
ATOM    734  C   GLU A 120      16.569   1.933   8.099  1.00 33.23           C  
ATOM    735  O   GLU A 120      16.458   2.579   7.046  1.00 35.60           O  
ATOM    736  CB  GLU A 120      14.884   3.379   9.260  1.00 34.85           C  
ATOM    737  CG  GLU A 120      13.386   3.365   9.650  1.00 37.68           C  
ATOM    738  CD  GLU A 120      13.208   3.017  11.106  1.00 47.52           C  
ATOM    739  OE1 GLU A 120      14.059   3.435  11.939  1.00 46.63           O  
ATOM    740  OE2 GLU A 120      12.227   2.318  11.424  1.00 41.01           O  
ATOM    741  N   ASP A 121      17.640   1.199   8.415  1.00 31.97           N  
ATOM    742  CA  ASP A 121      18.832   1.227   7.574  1.00 30.33           C  
ATOM    743  C   ASP A 121      18.855   0.174   6.461  1.00 32.60           C  
ATOM    744  O   ASP A 121      19.748   0.242   5.596  1.00 36.38           O  
ATOM    745  CB  ASP A 121      20.096   1.092   8.414  1.00 32.81           C  
ATOM    746  CG  ASP A 121      20.157  -0.227   9.151  1.00 37.32           C  
ATOM    747  OD1 ASP A 121      19.134  -0.644   9.753  1.00 35.47           O  
ATOM    748  OD2 ASP A 121      21.182  -0.936   9.134  1.00 39.16           O  
ATOM    749  N   LEU A 122      17.915  -0.782   6.471  1.00 29.02           N  
ATOM    750  CA  LEU A 122      17.906  -1.815   5.431  1.00 30.82           C  
ATOM    751  C   LEU A 122      16.936  -1.483   4.311  1.00 31.31           C  
ATOM    752  O   LEU A 122      15.921  -0.810   4.551  1.00 32.94           O  
ATOM    753  CB  LEU A 122      17.597  -3.224   5.991  1.00 30.71           C  
ATOM    754  CG  LEU A 122      18.624  -3.709   7.001  1.00 31.82           C  
ATOM    755  CD1 LEU A 122      18.135  -4.993   7.689  1.00 35.47           C  
ATOM    756  CD2 LEU A 122      20.020  -3.924   6.376  1.00 34.99           C  
ATOM    757  N   ASP A 123      17.259  -1.959   3.104  1.00 31.90           N  
ATOM    758  CA  ASP A 123      16.414  -1.676   1.943  1.00 31.32           C  
ATOM    759  C   ASP A 123      15.822  -2.979   1.468  1.00 31.62           C  
ATOM    760  O   ASP A 123      16.208  -4.063   1.922  1.00 32.16           O  
ATOM    761  CB  ASP A 123      17.251  -1.129   0.801  1.00 30.57           C  
ATOM    762  CG  ASP A 123      17.764   0.243   1.066  1.00 33.42           C  
ATOM    763  OD1 ASP A 123      17.176   0.958   1.915  1.00 32.68           O  
ATOM    764  OD2 ASP A 123      18.742   0.674   0.443  1.00 36.14           O  
ATOM    765  N   MET A 124      14.890  -2.865   0.530  1.00 29.66           N  
ATOM    766  CA  MET A 124      14.424  -4.031  -0.221  1.00 29.12           C  
ATOM    767  C   MET A 124      15.650  -4.761  -0.781  1.00 30.50           C  
ATOM    768  O   MET A 124      16.635  -4.112  -1.183  1.00 29.96           O  
ATOM    769  CB  MET A 124      13.575  -3.562  -1.402  1.00 30.48           C  
ATOM    770  CG  MET A 124      12.095  -3.242  -1.049  1.00 33.90           C  
ATOM    771  SD  MET A 124      11.215  -4.717  -0.491  1.00 35.91           S  
ATOM    772  CE  MET A 124       9.480  -4.112  -0.599  1.00 32.93           C  
ATOM    773  N   PRO A 125      15.564  -6.088  -0.858  1.00 31.73           N  
ATOM    774  CA  PRO A 125      16.691  -6.889  -1.376  1.00 32.67           C  
ATOM    775  C   PRO A 125      16.881  -6.712  -2.884  1.00 30.91           C  
ATOM    776  O   PRO A 125      15.935  -6.346  -3.590  1.00 31.57           O  
ATOM    777  CB  PRO A 125      16.249  -8.314  -1.080  1.00 36.71           C  
ATOM    778  CG  PRO A 125      14.776  -8.257  -1.069  1.00 32.52           C  
ATOM    779  CD  PRO A 125      14.456  -6.955  -0.412  1.00 33.12           C  
ATOM    780  N   PRO A 126      18.095  -6.971  -3.374  1.00 29.98           N  
ATOM    781  CA  PRO A 126      18.392  -6.963  -4.813  1.00 31.55           C  
ATOM    782  C   PRO A 126      17.903  -8.229  -5.561  1.00 38.19           C  
ATOM    783  O   PRO A 126      18.627  -8.826  -6.380  1.00 44.33           O  
ATOM    784  CB  PRO A 126      19.924  -6.883  -4.853  1.00 33.82           C  
ATOM    785  CG  PRO A 126      20.361  -7.564  -3.541  1.00 31.12           C  
ATOM    786  CD  PRO A 126      19.288  -7.251  -2.544  1.00 29.75           C  
ATOM    787  N   ASP A 127      16.673  -8.628  -5.292  1.00 36.14           N  
ATOM    788  CA  ASP A 127      16.065  -9.838  -5.853  1.00 33.50           C  
ATOM    789  C   ASP A 127      14.666  -9.363  -6.194  1.00 36.87           C  
ATOM    790  O   ASP A 127      13.808  -9.224  -5.308  1.00 34.05           O  
ATOM    791  CB  ASP A 127      16.085 -10.921  -4.753  1.00 37.96           C  
ATOM    792  CG  ASP A 127      15.379 -12.220  -5.138  1.00 41.36           C  
ATOM    793  OD1 ASP A 127      14.486 -12.224  -6.003  1.00 35.63           O  
ATOM    794  OD2 ASP A 127      15.652 -13.302  -4.562  1.00 42.82           O  
ATOM    795  N   PRO A 128      14.459  -9.033  -7.459  1.00 35.95           N  
ATOM    796  CA  PRO A 128      13.219  -8.387  -7.890  1.00 36.63           C  
ATOM    797  C   PRO A 128      11.952  -9.137  -7.484  1.00 36.30           C  
ATOM    798  O   PRO A 128      10.991  -8.492  -7.054  1.00 36.49           O  
ATOM    799  CB  PRO A 128      13.352  -8.365  -9.416  1.00 40.08           C  
ATOM    800  CG  PRO A 128      14.469  -9.287  -9.719  1.00 38.57           C  
ATOM    801  CD  PRO A 128      15.402  -9.212  -8.573  1.00 37.64           C  
ATOM    802  N   ALA A 129      11.935 -10.462  -7.642  1.00 34.17           N  
ATOM    803  CA  ALA A 129      10.732 -11.230  -7.310  1.00 36.23           C  
ATOM    804  C   ALA A 129      10.465 -11.187  -5.802  1.00 32.70           C  
ATOM    805  O   ALA A 129       9.310 -11.075  -5.371  1.00 34.90           O  
ATOM    806  CB  ALA A 129      10.863 -12.662  -7.785  1.00 35.57           C  
ATOM    807  N   LEU A 130      11.530 -11.261  -5.008  1.00 31.27           N  
ATOM    808  CA  LEU A 130      11.377 -11.215  -3.557  1.00 29.13           C  
ATOM    809  C   LEU A 130      10.892  -9.807  -3.112  1.00 32.67           C  
ATOM    810  O   LEU A 130       9.986  -9.687  -2.263  1.00 33.47           O  
ATOM    811  CB  LEU A 130      12.683 -11.605  -2.859  1.00 32.01           C  
ATOM    812  CG  LEU A 130      12.758 -11.499  -1.332  1.00 33.63           C  
ATOM    813  CD1 LEU A 130      11.654 -12.343  -0.669  1.00 34.88           C  
ATOM    814  CD2 LEU A 130      14.134 -11.935  -0.839  1.00 32.91           C  
ATOM    815  N   ALA A 131      11.489  -8.754  -3.678  1.00 31.29           N  
ATOM    816  CA  ALA A 131      11.062  -7.377  -3.373  1.00 32.22           C  
ATOM    817  C   ALA A 131       9.611  -7.177  -3.754  1.00 30.93           C  
ATOM    818  O   ALA A 131       8.835  -6.568  -3.015  1.00 32.24           O  
ATOM    819  CB  ALA A 131      11.980  -6.365  -4.106  1.00 30.82           C  
ATOM    820  N   THR A 132       9.208  -7.704  -4.914  1.00 32.93           N  
ATOM    821  CA  THR A 132       7.807  -7.605  -5.342  1.00 29.79           C  
ATOM    822  C   THR A 132       6.866  -8.334  -4.377  1.00 32.06           C  
ATOM    823  O   THR A 132       5.789  -7.820  -4.020  1.00 31.81           O  
ATOM    824  CB  THR A 132       7.667  -8.184  -6.766  1.00 30.97           C  
ATOM    825  OG1 THR A 132       8.303  -7.292  -7.680  1.00 35.82           O  
ATOM    826  CG2 THR A 132       6.220  -8.155  -7.210  1.00 29.13           C  
ATOM    827  N   GLN A 133       7.266  -9.536  -3.956  1.00 31.51           N  
ATOM    828  CA  GLN A 133       6.451 -10.314  -3.022  1.00 35.26           C  
ATOM    829  C   GLN A 133       6.255  -9.543  -1.724  1.00 32.68           C  
ATOM    830  O   GLN A 133       5.136  -9.442  -1.212  1.00 31.68           O  
ATOM    831  CB  GLN A 133       7.092 -11.690  -2.756  1.00 34.45           C  
ATOM    832  CG  GLN A 133       6.289 -12.614  -1.830  1.00 35.53           C  
ATOM    833  CD  GLN A 133       4.966 -13.114  -2.409  1.00 35.66           C  
ATOM    834  OE1 GLN A 133       4.154 -13.683  -1.677  1.00 39.44           O  
ATOM    835  NE2 GLN A 133       4.733 -12.890  -3.698  1.00 35.30           N  
ATOM    836  N   ILE A 134       7.334  -8.973  -1.195  1.00 27.94           N  
ATOM    837  CA  ILE A 134       7.236  -8.252   0.102  1.00 27.65           C  
ATOM    838  C   ILE A 134       6.264  -7.077  -0.078  1.00 30.28           C  
ATOM    839  O   ILE A 134       5.333  -6.894   0.738  1.00 30.98           O  
ATOM    840  CB  ILE A 134       8.606  -7.780   0.565  1.00 30.32           C  
ATOM    841  CG1 ILE A 134       9.529  -8.970   0.916  1.00 31.58           C  
ATOM    842  CG2 ILE A 134       8.481  -6.766   1.727  1.00 32.43           C  
ATOM    843  CD1 ILE A 134      11.039  -8.598   0.882  1.00 31.30           C  
ATOM    844  N   LYS A 135       6.427  -6.319  -1.172  1.00 31.08           N  
ATOM    845  CA  LYS A 135       5.567  -5.147  -1.373  1.00 31.83           C  
ATOM    846  C   LYS A 135       4.095  -5.535  -1.612  1.00 31.83           C  
ATOM    847  O   LYS A 135       3.161  -4.916  -1.070  1.00 31.90           O  
ATOM    848  CB  LYS A 135       6.094  -4.271  -2.511  1.00 30.47           C  
ATOM    849  CG  LYS A 135       5.301  -2.971  -2.679  1.00 35.48           C  
ATOM    850  CD  LYS A 135       6.090  -1.986  -3.509  1.00 44.77           C  
ATOM    851  CE  LYS A 135       5.172  -0.998  -4.209  1.00 51.20           C  
ATOM    852  NZ  LYS A 135       4.286  -0.321  -3.236  1.00 49.08           N  
ATOM    853  N   GLU A 136       3.873  -6.577  -2.405  1.00 27.99           N  
ATOM    854  CA  GLU A 136       2.487  -6.988  -2.663  1.00 31.48           C  
ATOM    855  C   GLU A 136       1.790  -7.446  -1.374  1.00 29.41           C  
ATOM    856  O   GLU A 136       0.649  -7.079  -1.099  1.00 31.85           O  
ATOM    857  CB  GLU A 136       2.463  -8.084  -3.735  1.00 31.48           C  
ATOM    858  CG  GLU A 136       2.712  -7.516  -5.118  1.00 35.93           C  
ATOM    859  CD  GLU A 136       2.808  -8.591  -6.179  1.00 41.14           C  
ATOM    860  OE1 GLU A 136       2.976  -9.766  -5.805  1.00 41.40           O  
ATOM    861  OE2 GLU A 136       2.723  -8.254  -7.376  1.00 37.30           O  
ATOM    862  N   GLN A 137       2.494  -8.255  -0.577  1.00 29.00           N  
ATOM    863  CA  GLN A 137       1.904  -8.711   0.675  1.00 30.73           C  
ATOM    864  C   GLN A 137       1.645  -7.569   1.651  1.00 31.04           C  
ATOM    865  O   GLN A 137       0.572  -7.505   2.279  1.00 33.08           O  
ATOM    866  CB  GLN A 137       2.755  -9.817   1.293  1.00 30.29           C  
ATOM    867  CG  GLN A 137       2.822 -11.071   0.405  1.00 31.25           C  
ATOM    868  CD  GLN A 137       1.464 -11.674   0.128  1.00 37.20           C  
ATOM    869  OE1 GLN A 137       0.751 -12.057   1.056  1.00 39.47           O  
ATOM    870  NE2 GLN A 137       1.095 -11.768  -1.158  1.00 36.68           N  
ATOM    871  N   PHE A 138       2.602  -6.651   1.759  1.00 31.93           N  
ATOM    872  CA  PHE A 138       2.398  -5.448   2.587  1.00 30.81           C  
ATOM    873  C   PHE A 138       1.205  -4.622   2.119  1.00 32.59           C  
ATOM    874  O   PHE A 138       0.363  -4.185   2.931  1.00 32.05           O  
ATOM    875  CB  PHE A 138       3.671  -4.628   2.561  1.00 33.07           C  
ATOM    876  CG  PHE A 138       3.628  -3.417   3.449  1.00 32.54           C  
ATOM    877  CD1 PHE A 138       3.869  -3.541   4.821  1.00 32.40           C  
ATOM    878  CD2 PHE A 138       3.402  -2.150   2.903  1.00 33.34           C  
ATOM    879  CE1 PHE A 138       3.849  -2.411   5.640  1.00 29.44           C  
ATOM    880  CE2 PHE A 138       3.388  -1.007   3.757  1.00 35.29           C  
ATOM    881  CZ  PHE A 138       3.607  -1.160   5.090  1.00 31.56           C  
ATOM    882  N   ASP A 139       1.071  -4.420   0.811  1.00 31.37           N  
ATOM    883  CA  ASP A 139      -0.077  -3.654   0.325  1.00 31.45           C  
ATOM    884  C   ASP A 139      -1.412  -4.359   0.524  1.00 32.39           C  
ATOM    885  O   ASP A 139      -2.454  -3.689   0.595  1.00 34.41           O  
ATOM    886  CB  ASP A 139       0.100  -3.267  -1.141  1.00 31.61           C  
ATOM    887  CG  ASP A 139       1.272  -2.343  -1.370  1.00 33.77           C  
ATOM    888  OD1 ASP A 139       1.721  -1.670  -0.406  1.00 38.71           O  
ATOM    889  OD2 ASP A 139       1.820  -2.237  -2.487  1.00 33.66           O  
ATOM    890  N   SER A 140      -1.404  -5.692   0.603  1.00 32.52           N  
ATOM    891  CA  SER A 140      -2.636  -6.453   0.844  1.00 32.10           C  
ATOM    892  C   SER A 140      -3.085  -6.409   2.322  1.00 33.38           C  
ATOM    893  O   SER A 140      -4.140  -6.956   2.656  1.00 37.79           O  
ATOM    894  CB  SER A 140      -2.535  -7.901   0.341  1.00 37.44           C  
ATOM    895  OG  SER A 140      -1.817  -8.698   1.264  1.00 41.63           O  
ATOM    896  N   GLY A 141      -2.283  -5.790   3.190  1.00 32.63           N  
ATOM    897  CA  GLY A 141      -2.638  -5.652   4.611  1.00 38.78           C  
ATOM    898  C   GLY A 141      -2.287  -6.898   5.432  1.00 41.01           C  
ATOM    899  O   GLY A 141      -2.985  -7.282   6.374  1.00 44.47           O  
ATOM    900  N   LYS A 142      -1.214  -7.560   5.033  1.00 34.58           N  
ATOM    901  CA  LYS A 142      -0.674  -8.677   5.804  1.00 36.08           C  
ATOM    902  C   LYS A 142       0.369  -8.121   6.779  1.00 33.32           C  
ATOM    903  O   LYS A 142       0.947  -7.038   6.562  1.00 36.59           O  
ATOM    904  CB  LYS A 142      -0.032  -9.711   4.884  1.00 35.02           C  
ATOM    905  CG  LYS A 142      -1.010 -10.462   3.944  1.00 36.81           C  
ATOM    906  CD  LYS A 142      -1.722 -11.615   4.646  1.00 43.00           C  
ATOM    907  CE  LYS A 142      -2.859 -12.198   3.774  1.00 44.43           C  
ATOM    908  NZ  LYS A 142      -2.360 -12.788   2.490  1.00 57.19           N  
ATOM    909  N   ASP A 143       0.577  -8.831   7.896  1.00 31.35           N  
ATOM    910  CA  ASP A 143       1.754  -8.601   8.738  1.00 28.63           C  
ATOM    911  C   ASP A 143       2.925  -9.336   8.088  1.00 30.74           C  
ATOM    912  O   ASP A 143       3.082 -10.565   8.209  1.00 33.13           O  
ATOM    913  CB  ASP A 143       1.515  -9.204  10.097  1.00 29.23           C  
ATOM    914  CG  ASP A 143       2.587  -8.861  11.086  1.00 31.30           C  
ATOM    915  OD1 ASP A 143       3.382  -7.941  10.833  1.00 32.93           O  
ATOM    916  OD2 ASP A 143       2.645  -9.468  12.178  1.00 31.40           O  
ATOM    917  N   VAL A 144       3.738  -8.571   7.383  1.00 30.60           N  
ATOM    918  CA  VAL A 144       4.814  -9.164   6.574  1.00 31.28           C  
ATOM    919  C   VAL A 144       6.073  -9.287   7.376  1.00 30.37           C  
ATOM    920  O   VAL A 144       6.562  -8.291   7.979  1.00 29.72           O  
ATOM    921  CB  VAL A 144       5.065  -8.304   5.318  1.00 29.56           C  
ATOM    922  CG1 VAL A 144       6.221  -8.858   4.490  1.00 31.49           C  
ATOM    923  CG2 VAL A 144       3.806  -8.254   4.449  1.00 31.95           C  
ATOM    924  N   LEU A 145       6.614 -10.506   7.396  1.00 29.69           N  
ATOM    925  CA  LEU A 145       7.879 -10.737   8.067  1.00 29.71           C  
ATOM    926  C   LEU A 145       8.971 -10.892   7.036  1.00 31.18           C  
ATOM    927  O   LEU A 145       8.729 -11.416   5.962  1.00 32.44           O  
ATOM    928  CB  LEU A 145       7.848 -12.007   8.930  1.00 30.10           C  
ATOM    929  CG  LEU A 145       6.701 -12.152   9.914  1.00 30.09           C  
ATOM    930  CD1 LEU A 145       6.866 -13.429  10.745  1.00 31.92           C  
ATOM    931  CD2 LEU A 145       6.639 -10.895  10.793  1.00 30.84           C  
ATOM    932  N   VAL A 146      10.146 -10.396   7.380  1.00 29.72           N  
ATOM    933  CA  VAL A 146      11.325 -10.562   6.523  1.00 30.91           C  
ATOM    934  C   VAL A 146      12.432 -11.210   7.305  1.00 31.06           C  
ATOM    935  O   VAL A 146      12.673 -10.882   8.476  1.00 30.41           O  
ATOM    936  CB  VAL A 146      11.798  -9.259   5.862  1.00 31.35           C  
ATOM    937  CG1 VAL A 146      10.755  -8.772   4.890  1.00 31.32           C  
ATOM    938  CG2 VAL A 146      12.148  -8.182   6.907  1.00 31.42           C  
ATOM    939  N   VAL A 147      13.101 -12.175   6.664  1.00 30.06           N  
ATOM    940  CA  VAL A 147      14.171 -12.883   7.338  1.00 30.47           C  
ATOM    941  C   VAL A 147      15.439 -12.269   6.771  1.00 32.37           C  
ATOM    942  O   VAL A 147      15.695 -12.375   5.552  1.00 30.82           O  
ATOM    943  CB  VAL A 147      14.142 -14.367   6.984  1.00 30.98           C  
ATOM    944  CG1 VAL A 147      15.282 -15.089   7.673  1.00 32.34           C  
ATOM    945  CG2 VAL A 147      12.761 -15.023   7.375  1.00 33.31           C  
ATOM    946  N   VAL A 148      16.209 -11.641   7.657  1.00 31.62           N  
ATOM    947  CA  VAL A 148      17.450 -10.954   7.325  1.00 30.46           C  
ATOM    948  C   VAL A 148      18.615 -11.860   7.701  1.00 32.10           C  
ATOM    949  O   VAL A 148      18.744 -12.311   8.839  1.00 30.60           O  
ATOM    950  CB  VAL A 148      17.555  -9.620   8.083  1.00 32.36           C  
ATOM    951  CG1 VAL A 148      18.934  -8.973   7.888  1.00 34.06           C  
ATOM    952  CG2 VAL A 148      16.434  -8.652   7.621  1.00 34.65           C  
ATOM    953  N   VAL A 149      19.474 -12.144   6.722  1.00 29.85           N  
ATOM    954  CA  VAL A 149      20.616 -13.020   6.981  1.00 29.52           C  
ATOM    955  C   VAL A 149      21.900 -12.175   6.879  1.00 29.01           C  
ATOM    956  O   VAL A 149      22.015 -11.325   5.979  1.00 27.68           O  
ATOM    957  CB  VAL A 149      20.628 -14.149   5.942  1.00 29.43           C  
ATOM    958  CG1 VAL A 149      21.897 -15.028   6.072  1.00 29.77           C  
ATOM    959  CG2 VAL A 149      19.344 -14.975   6.053  1.00 30.15           C  
ATOM    960  N   SER A 150      22.836 -12.415   7.795  1.00 29.43           N  
ATOM    961  CA  SER A 150      24.087 -11.676   7.911  1.00 29.31           C  
ATOM    962  C   SER A 150      25.240 -12.658   7.801  1.00 29.47           C  
ATOM    963  O   SER A 150      25.308 -13.674   8.544  1.00 26.42           O  
ATOM    964  CB  SER A 150      24.245 -10.982   9.288  1.00 34.35           C  
ATOM    965  OG  SER A 150      23.057 -10.309   9.671  1.00 47.56           O  
ATOM    966  N   ALA A 151      26.209 -12.355   6.946  1.00 27.55           N  
ATOM    967  CA  ALA A 151      27.438 -13.129   6.842  1.00 24.65           C  
ATOM    968  C   ALA A 151      28.504 -12.291   6.149  1.00 23.61           C  
ATOM    969  O   ALA A 151      28.179 -11.578   5.178  1.00 26.20           O  
ATOM    970  CB  ALA A 151      27.183 -14.406   6.027  1.00 26.94           C  
ATOM    971  N   MET A 152      29.753 -12.415   6.562  1.00 24.78           N  
ATOM    972  CA  MET A 152      30.879 -11.773   5.892  1.00 24.89           C  
ATOM    973  C   MET A 152      30.649 -10.252   5.693  1.00 29.10           C  
ATOM    974  O   MET A 152      31.160  -9.673   4.724  1.00 32.31           O  
ATOM    975  CB  MET A 152      31.186 -12.452   4.544  1.00 25.06           C  
ATOM    976  CG  MET A 152      31.406 -13.938   4.660  1.00 28.57           C  
ATOM    977  SD  MET A 152      32.732 -14.388   5.696  1.00 28.96           S  
ATOM    978  CE  MET A 152      34.089 -13.792   4.776  1.00 24.92           C  
ATOM    979  N   GLY A 153      29.969  -9.638   6.645  1.00 31.73           N  
ATOM    980  CA  GLY A 153      29.818  -8.189   6.668  1.00 34.27           C  
ATOM    981  C   GLY A 153      28.625  -7.687   5.878  1.00 36.65           C  
ATOM    982  O   GLY A 153      28.341  -6.486   5.879  1.00 39.67           O  
ATOM    983  N   THR A 154      27.909  -8.591   5.210  1.00 29.08           N  
ATOM    984  CA  THR A 154      26.693  -8.207   4.480  1.00 30.03           C  
ATOM    985  C   THR A 154      25.442  -8.628   5.227  1.00 33.02           C  
ATOM    986  O   THR A 154      25.428  -9.677   5.856  1.00 33.51           O  
ATOM    987  CB  THR A 154      26.696  -8.902   3.110  1.00 30.51           C  
ATOM    988  OG1 THR A 154      27.788  -8.428   2.313  1.00 31.74           O  
ATOM    989  CG2 THR A 154      25.400  -8.594   2.304  1.00 34.03           C  
ATOM    990  N   GLU A 155      24.372  -7.821   5.154  1.00 30.57           N  
ATOM    991  CA  GLU A 155      23.081  -8.156   5.751  1.00 30.40           C  
ATOM    992  C   GLU A 155      22.041  -7.927   4.673  1.00 31.96           C  
ATOM    993  O   GLU A 155      22.054  -6.871   4.045  1.00 36.25           O  
ATOM    994  CB  GLU A 155      22.695  -7.203   6.880  1.00 41.92           C  
ATOM    995  CG  GLU A 155      23.323  -7.368   8.240  1.00 49.12           C  
ATOM    996  CD  GLU A 155      22.559  -6.480   9.212  1.00 53.37           C  
ATOM    997  OE1 GLU A 155      22.744  -5.242   9.137  1.00 47.06           O  
ATOM    998  OE2 GLU A 155      21.719  -6.992   9.995  1.00 47.72           O  
ATOM    999  N   GLN A 156      21.158  -8.885   4.443  1.00 30.57           N  
ATOM   1000  CA  GLN A 156      20.200  -8.758   3.347  1.00 28.08           C  
ATOM   1001  C   GLN A 156      18.971  -9.584   3.677  1.00 30.53           C  
ATOM   1002  O   GLN A 156      19.073 -10.675   4.295  1.00 30.98           O  
ATOM   1003  CB  GLN A 156      20.894  -9.280   2.088  1.00 28.40           C  
ATOM   1004  CG  GLN A 156      20.111  -9.121   0.790  1.00 28.92           C  
ATOM   1005  CD  GLN A 156      21.035  -9.440  -0.388  1.00 27.70           C  
ATOM   1006  OE1 GLN A 156      22.131  -8.828  -0.543  1.00 29.84           O  
ATOM   1007  NE2 GLN A 156      20.648 -10.441  -1.207  1.00 28.40           N  
ATOM   1008  N   VAL A 157      17.798  -9.089   3.261  1.00 30.11           N  
ATOM   1009  CA  VAL A 157      16.573  -9.871   3.338  1.00 28.93           C  
ATOM   1010  C   VAL A 157      16.666 -11.002   2.319  1.00 29.51           C  
ATOM   1011  O   VAL A 157      16.858 -10.771   1.096  1.00 30.90           O  
ATOM   1012  CB  VAL A 157      15.339  -8.994   3.007  1.00 30.49           C  
ATOM   1013  CG1 VAL A 157      14.093  -9.863   2.879  1.00 31.44           C  
ATOM   1014  CG2 VAL A 157      15.171  -7.913   4.061  1.00 31.80           C  
ATOM   1015  N   LEU A 158      16.561 -12.238   2.813  1.00 30.70           N  
ATOM   1016  CA  LEU A 158      16.599 -13.425   1.950  1.00 28.45           C  
ATOM   1017  C   LEU A 158      15.283 -14.188   1.791  1.00 29.09           C  
ATOM   1018  O   LEU A 158      15.123 -14.986   0.831  1.00 31.47           O  
ATOM   1019  CB  LEU A 158      17.698 -14.382   2.407  1.00 30.05           C  
ATOM   1020  CG  LEU A 158      19.145 -13.913   2.332  1.00 31.84           C  
ATOM   1021  CD1 LEU A 158      20.075 -15.118   2.433  1.00 32.04           C  
ATOM   1022  CD2 LEU A 158      19.412 -13.175   1.015  1.00 32.78           C  
ATOM   1023  N   GLN A 159      14.329 -13.944   2.716  1.00 30.65           N  
ATOM   1024  CA  GLN A 159      13.041 -14.617   2.670  1.00 30.80           C  
ATOM   1025  C   GLN A 159      11.970 -13.685   3.221  1.00 29.35           C  
ATOM   1026  O   GLN A 159      12.262 -12.772   3.981  1.00 31.05           O  
ATOM   1027  CB  GLN A 159      13.032 -15.892   3.530  0.65 29.71           C  
ATOM   1028  CG  GLN A 159      11.878 -16.854   3.157  0.65 42.33           C  
ATOM   1029  CD  GLN A 159      11.389 -17.807   4.269  0.65 44.75           C  
ATOM   1030  OE1 GLN A 159      12.128 -18.137   5.207  0.65 52.38           O  
ATOM   1031  NE2 GLN A 159      10.140 -18.270   4.139  0.65 47.00           N  
ATOM   1032  N   THR A 160      10.734 -13.954   2.809  1.00 33.22           N  
ATOM   1033  CA  THR A 160       9.559 -13.359   3.421  1.00 30.93           C  
ATOM   1034  C   THR A 160       8.469 -14.402   3.669  1.00 30.48           C  
ATOM   1035  O   THR A 160       8.410 -15.447   3.014  1.00 30.39           O  
ATOM   1036  CB  THR A 160       9.044 -12.173   2.564  1.00 29.37           C  
ATOM   1037  OG1 THR A 160       7.990 -11.470   3.250  1.00 31.82           O  
ATOM   1038  CG2 THR A 160       8.378 -12.663   1.272  1.00 32.11           C  
ATOM   1039  N   LYS A 161       7.616 -14.098   4.644  1.00 31.04           N  
ATOM   1040  CA  LYS A 161       6.468 -14.921   4.980  1.00 32.50           C  
ATOM   1041  C   LYS A 161       5.540 -14.026   5.796  1.00 28.98           C  
ATOM   1042  O   LYS A 161       5.980 -12.991   6.312  1.00 31.55           O  
ATOM   1043  CB  LYS A 161       6.888 -16.159   5.804  1.00 32.29           C  
ATOM   1044  CG  LYS A 161       7.571 -15.781   7.132  1.00 34.12           C  
ATOM   1045  CD  LYS A 161       8.172 -16.983   7.829  1.00 42.02           C  
ATOM   1046  CE  LYS A 161       9.207 -16.542   8.860  1.00 44.71           C  
ATOM   1047  NZ  LYS A 161       9.848 -17.712   9.549  1.00 47.69           N  
ATOM   1048  N   ASN A 162       4.276 -14.417   5.883  1.00 32.01           N  
ATOM   1049  CA  ASN A 162       3.342 -13.630   6.666  1.00 32.14           C  
ATOM   1050  C   ASN A 162       3.172 -14.172   8.077  1.00 34.60           C  
ATOM   1051  O   ASN A 162       3.227 -15.382   8.294  1.00 34.61           O  
ATOM   1052  CB  ASN A 162       2.014 -13.518   5.918  1.00 33.81           C  
ATOM   1053  CG  ASN A 162       2.165 -12.807   4.569  1.00 35.79           C  
ATOM   1054  OD1 ASN A 162       2.995 -11.905   4.418  1.00 35.18           O  
ATOM   1055  ND2 ASN A 162       1.348 -13.205   3.589  1.00 34.67           N  
ATOM   1056  N   ALA A 163       2.931 -13.274   9.040  1.00 33.02           N  
ATOM   1057  CA  ALA A 163       2.727 -13.702  10.416  1.00 34.80           C  
ATOM   1058  C   ALA A 163       1.310 -14.198  10.628  1.00 42.98           C  
ATOM   1059  O   ALA A 163       0.366 -13.722   9.993  1.00 46.68           O  
ATOM   1060  CB  ALA A 163       3.001 -12.534  11.376  1.00 36.94           C  
ATOM   1061  N   ALA A 164       1.171 -15.143  11.545  1.00 44.77           N  
ATOM   1062  CA  ALA A 164      -0.140 -15.475  12.107  1.00 46.12           C  
ATOM   1063  C   ALA A 164      -0.214 -15.007  13.566  1.00 44.23           C  
ATOM   1064  O   ALA A 164       0.820 -14.800  14.212  1.00 45.87           O  
ATOM   1065  CB  ALA A 164      -0.372 -16.971  12.021  1.00 46.90           C  
ATOM   1066  N   GLU A 165      -1.427 -14.826  14.083  1.00 43.12           N  
ATOM   1067  CA  GLU A 165      -1.618 -14.695  15.529  1.00 45.00           C  
ATOM   1068  C   GLU A 165      -1.154 -15.984  16.234  1.00 47.28           C  
ATOM   1069  O   GLU A 165      -0.285 -15.959  17.121  1.00 52.09           O  
ATOM   1070  CB  GLU A 165      -3.081 -14.426  15.846  1.00 41.64           C  
TER    1071      GLU A 165                                                      
END
MOLECULE T0429_100_176.pdb
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
