
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  107 ( 1582),  selected  107 , name 1wjq_A
# Molecule2: number of CA atoms  135 ( 1110),  selected  135 , name T0429.pdb
# PARAMETERS: 1wjq_A.T0429.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E      22           -
LGA    S     2_A      T      23           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    V     8_A      -       -           -
LGA    K     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    P    11_A      E      24          4.688
LGA    H    12_A      L      25          7.416
LGA    G    13_A      L      27          0.873
LGA    F    14_A      Y      28          1.467
LGA    Q    15_A      K      29          0.869
LGA    K    16_A      V      30          1.351
LGA    K    17_A      N      31          1.357
LGA    M    18_A      E      32          1.340
LGA    K    19_A      Y      33          0.746
LGA    L    20_A      V      34          0.666
LGA    E    21_A      D      35          0.802
LGA    V    22_A      A      36          0.897
LGA    V    23_A      R      37          1.046
LGA    D    24_A      D      38          1.059
LGA    K    25_A      T      39          1.545
LGA    R    26_A      N      40          1.251
LGA    N    27_A      M      41          0.795
LGA    P    28_A      G      42          0.760
LGA    M    29_A      A      43          3.813
LGA    F    30_A      -       -           -
LGA    I    31_A      W      44          1.208
LGA    R    32_A      F      45          0.968
LGA    V    33_A      E      46          0.219
LGA    A    34_A      A      47          0.402
LGA    T    35_A      Q      48          0.560
LGA    V    36_A      V      49          0.461
LGA    A    37_A      V      50          0.781
LGA    D    38_A      R      51          1.058
LGA    T    39_A      V      52          1.230
LGA    D    40_A      T      53          1.310
LGA    D    41_A      R      54          2.070
LGA    -       -      E      73           -
LGA    -       -      D      74           -
LGA    H    42_A      V      75          2.256
LGA    R    43_A      I      76          1.381
LGA    V    44_A      Y      77          1.408
LGA    K    45_A      H      78          0.692
LGA    V    46_A      V      79          1.081
LGA    H    47_A      K      80          0.476
LGA    F    48_A      Y      81          0.350
LGA    D    49_A      D      82          1.136
LGA    G    50_A      D      83          3.123
LGA    W    51_A      Y      84          1.318
LGA    N    52_A      P      85          2.669
LGA    -       -      E      86           -
LGA    N    53_A      N      87          4.624
LGA    C    54_A      G      88          2.710
LGA    Y    55_A      -       -           -
LGA    D    56_A      V      89          2.548
LGA    Y    57_A      V      90          1.163
LGA    W    58_A      Q      91          1.053
LGA    I    59_A      M      92          1.066
LGA    D    60_A      N      93          2.522
LGA    A    61_A      S      94          2.763
LGA    D    62_A      -       -           -
LGA    S    63_A      -       -           -
LGA    P    64_A      R      95          2.212
LGA    D    65_A      D      96          2.329
LGA    I    66_A      V      97          1.735
LGA    H    67_A      R      98          2.194
LGA    P    68_A      A      99          1.244
LGA    V    69_A      R     100          0.781
LGA    G    70_A      A     101          1.273
LGA    W    71_A      R     102           #
LGA    C    72_A      T     103           #
LGA    S    73_A      I     104          4.554
LGA    -       -      I     105           -
LGA    -       -      K     106           -
LGA    -       -      W     107           -
LGA    -       -      Q     108           -
LGA    -       -      D     109           -
LGA    -       -      L     110           -
LGA    -       -      E     111           -
LGA    -       -      V     112           -
LGA    -       -      G     113           -
LGA    -       -      Q     114           -
LGA    K    74_A      V     115           #
LGA    T    75_A      V     116          1.407
LGA    G    76_A      M     117          3.735
LGA    H    77_A      L     118          1.874
LGA    P    78_A      N     119          3.082
LGA    -       -      Y     120           -
LGA    -       -      N     121           -
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    -       -      E     127           -
LGA    -       -      R     128           -
LGA    -       -      G     129           -
LGA    -       -      F     130           -
LGA    L    79_A      W     131          3.699
LGA    Q    80_A      Y     132           -
LGA    P    81_A      D     133           -
LGA    P    82_A      A     134           -
LGA    L    83_A      E     135           -
LGA    S    84_A      I     136           -
LGA    P    85_A      S     137           -
LGA    L    86_A      R     138           -
LGA    E    87_A      K     139           -
LGA    L    88_A      R     140           -
LGA    M    89_A      E     141           -
LGA    E    90_A      T     142           -
LGA    A    91_A      R     143           -
LGA    S    92_A      T     144           -
LGA    E    93_A      A     145           -
LGA    H    94_A      R     146           -
LGA    G    95_A      E     147           -
LGA    G    96_A      L     148           -
LGA    C    97_A      Y     149           -
LGA    S    98_A      A     150           -
LGA    T    99_A      N     151           -
LGA    P   100_A      V     152           -
LGA    G   101_A      V     153           -
LGA    S   102_A      L     154           -
LGA    G   103_A      D     156           -
LGA    P   104_A      D     157           -
LGA    S   105_A      S     158           -
LGA    S   106_A      L     159           -
LGA    G   107_A      N     160           -
LGA    -       -      D     161           -
LGA    -       -      C     162           -
LGA    -       -      R     163           -
LGA    -       -      I     164           -
LGA    -       -      I     165           -
LGA    -       -      F     166           -
LGA    -       -      V     167           -
LGA    -       -      D     168           -
LGA    -       -      E     169           -
LGA    -       -      V     170           -
LGA    -       -      F     171           -
LGA    -       -      K     172           -
LGA    -       -      I     173           -
LGA    -       -      E     174           -
LGA    -       -      R     175           -
LGA    -       -      P     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  107  135    5.0     62    2.17    11.29     39.059     2.732

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.700308 * X  +  -0.613166 * Y  +   0.365508 * Z  +  37.622921
  Y_new =   0.215428 * X  +  -0.669694 * Y  +  -0.710704 * Z  +  -9.691868
  Z_new =   0.680558 * X  +  -0.418971 * Y  +   0.601085 * Z  +  10.512110 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.608727    2.532866  [ DEG:   -34.8775    145.1225 ]
  Theta =  -0.748524   -2.393068  [ DEG:   -42.8873   -137.1127 ]
  Phi   =   2.843161   -0.298431  [ DEG:   162.9011    -17.0989 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wjq_A                                        
REMARK     2: T0429.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wjq_A.T0429.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  107  135   5.0   62   2.17   11.29  39.059
REMARK  ---------------------------------------------------------- 
MOLECULE 1wjq_A
HEADER    PROTEIN BINDING                         29-MAY-04   1WJQ              
TITLE     SOLUTION STRUCTURE OF THE THIRD MBT DOMAIN FROM HUMAN                 
TITLE    2 KIAA1798 PROTEIN                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: KIAA1798 PROTEIN;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: MBT DOMAIN;                                                
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KAZUSA CDNA FJ20547;                                           
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P040119-32;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    MBT DOMAIN, KIAA1798, STRUCTURAL GENOMICS, RIKEN STRUCTURAL           
KEYWDS   2 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    T.TOMIZAWA,T.KIGAWA,S.KOSHIBA,M.INOUE,S.YOKOYAMA,RIKEN                
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   29-NOV-04 1WJQ    0                                                
JRNL        AUTH   T.TOMIZAWA,T.KIGAWA,S.KOSHIBA,M.INOUE,S.YOKOYAMA             
JRNL        TITL   SOLUTION STRUCTURE OF THE THIRD MBT DOMAIN FROM              
JRNL        TITL 2 HUMAN KIAA1798 PROTEIN                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WJQ A    8   101  UNP    Q96JM7   LMBL3_HUMAN    470    563             
SEQRES   1 A  107  GLY SER SER GLY SER SER GLY VAL LYS PRO PRO HIS GLY          
SEQRES   2 A  107  PHE GLN LYS LYS MET LYS LEU GLU VAL VAL ASP LYS ARG          
SEQRES   3 A  107  ASN PRO MET PHE ILE ARG VAL ALA THR VAL ALA ASP THR          
SEQRES   4 A  107  ASP ASP HIS ARG VAL LYS VAL HIS PHE ASP GLY TRP ASN          
SEQRES   5 A  107  ASN CYS TYR ASP TYR TRP ILE ASP ALA ASP SER PRO ASP          
SEQRES   6 A  107  ILE HIS PRO VAL GLY TRP CYS SER LYS THR GLY HIS PRO          
SEQRES   7 A  107  LEU GLN PRO PRO LEU SER PRO LEU GLU LEU MET GLU ALA          
SEQRES   8 A  107  SER GLU HIS GLY GLY CYS SER THR PRO GLY SER GLY PRO          
SEQRES   9 A  107  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      37.037   1.395  42.067  1.00  0.00           N  
ATOM      2  CA  GLY A   1      35.598   1.240  41.949  1.00  0.00           C  
ATOM      3  C   GLY A   1      35.136  -0.164  42.283  1.00  0.00           C  
ATOM      4  O   GLY A   1      35.265  -0.613  43.421  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      35.117   1.936  42.621  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      35.305   1.472  40.936  1.00  0.00           H  
ATOM      7  H1  GLY A   1      37.481   1.189  42.916  1.00  0.00           H  
ATOM      8  N   SER A   2      34.596  -0.859  41.287  1.00  0.00           N  
ATOM      9  CA  SER A   2      34.108  -2.220  41.482  1.00  0.00           C  
ATOM     10  C   SER A   2      33.377  -2.350  42.815  1.00  0.00           C  
ATOM     11  O   SER A   2      33.552  -3.330  43.538  1.00  0.00           O  
ATOM     12  CB  SER A   2      35.269  -3.214  41.425  1.00  0.00           C  
ATOM     13  OG  SER A   2      36.251  -2.908  42.400  1.00  0.00           O  
ATOM     14  H   SER A   2      34.520  -0.446  40.401  1.00  0.00           H  
ATOM     15  HA  SER A   2      33.416  -2.441  40.683  1.00  0.00           H  
ATOM     16  HB2 SER A   2      34.896  -4.210  41.607  1.00  0.00           H  
ATOM     17  HB3 SER A   2      35.725  -3.174  40.446  1.00  0.00           H  
ATOM     18  HG  SER A   2      36.245  -3.582  43.083  1.00  0.00           H  
ATOM     19  N   SER A   3      32.558  -1.352  43.133  1.00  0.00           N  
ATOM     20  CA  SER A   3      31.803  -1.352  44.381  1.00  0.00           C  
ATOM     21  C   SER A   3      30.306  -1.255  44.110  1.00  0.00           C  
ATOM     22  O   SER A   3      29.763  -0.163  43.944  1.00  0.00           O  
ATOM     23  CB  SER A   3      32.249  -0.190  45.271  1.00  0.00           C  
ATOM     24  OG  SER A   3      32.013  -0.475  46.639  1.00  0.00           O  
ATOM     25  H   SER A   3      32.461  -0.598  42.516  1.00  0.00           H  
ATOM     26  HA  SER A   3      32.005  -2.282  44.891  1.00  0.00           H  
ATOM     27  HB2 SER A   3      33.305  -0.016  45.129  1.00  0.00           H  
ATOM     28  HB3 SER A   3      31.697   0.699  45.000  1.00  0.00           H  
ATOM     29  HG  SER A   3      31.371   0.148  46.990  1.00  0.00           H  
ATOM     30  N   GLY A   4      29.642  -2.405  44.066  1.00  0.00           N  
ATOM     31  CA  GLY A   4      28.213  -2.429  43.815  1.00  0.00           C  
ATOM     32  C   GLY A   4      27.834  -3.400  42.714  1.00  0.00           C  
ATOM     33  O   GLY A   4      28.418  -4.477  42.597  1.00  0.00           O  
ATOM     34  H   GLY A   4      30.127  -3.246  44.206  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      27.704  -2.714  44.723  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      27.893  -1.438  43.530  1.00  0.00           H  
ATOM     37  N   SER A   5      26.852  -3.018  41.903  1.00  0.00           N  
ATOM     38  CA  SER A   5      26.392  -3.865  40.808  1.00  0.00           C  
ATOM     39  C   SER A   5      25.707  -3.032  39.728  1.00  0.00           C  
ATOM     40  O   SER A   5      25.172  -1.958  40.003  1.00  0.00           O  
ATOM     41  CB  SER A   5      25.429  -4.933  41.332  1.00  0.00           C  
ATOM     42  OG  SER A   5      26.136  -6.050  41.842  1.00  0.00           O  
ATOM     43  H   SER A   5      26.425  -2.148  42.046  1.00  0.00           H  
ATOM     44  HA  SER A   5      27.256  -4.350  40.379  1.00  0.00           H  
ATOM     45  HB2 SER A   5      24.825  -4.513  42.121  1.00  0.00           H  
ATOM     46  HB3 SER A   5      24.790  -5.263  40.526  1.00  0.00           H  
ATOM     47  HG  SER A   5      25.524  -6.774  41.995  1.00  0.00           H  
ATOM     48  N   SER A   6      25.728  -3.537  38.499  1.00  0.00           N  
ATOM     49  CA  SER A   6      25.113  -2.840  37.375  1.00  0.00           C  
ATOM     50  C   SER A   6      24.801  -3.809  36.240  1.00  0.00           C  
ATOM     51  O   SER A   6      25.699  -4.266  35.534  1.00  0.00           O  
ATOM     52  CB  SER A   6      26.034  -1.727  36.874  1.00  0.00           C  
ATOM     53  OG  SER A   6      27.205  -2.262  36.280  1.00  0.00           O  
ATOM     54  H   SER A   6      26.170  -4.399  38.344  1.00  0.00           H  
ATOM     55  HA  SER A   6      24.189  -2.402  37.723  1.00  0.00           H  
ATOM     56  HB2 SER A   6      25.512  -1.135  36.138  1.00  0.00           H  
ATOM     57  HB3 SER A   6      26.321  -1.098  37.704  1.00  0.00           H  
ATOM     58  HG  SER A   6      27.391  -3.123  36.660  1.00  0.00           H  
ATOM     59  N   GLY A   7      23.519  -4.119  36.069  1.00  0.00           N  
ATOM     60  CA  GLY A   7      23.109  -5.031  35.018  1.00  0.00           C  
ATOM     61  C   GLY A   7      22.274  -4.351  33.951  1.00  0.00           C  
ATOM     62  O   GLY A   7      21.371  -3.575  34.262  1.00  0.00           O  
ATOM     63  H   GLY A   7      22.846  -3.724  36.662  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      23.992  -5.451  34.557  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      22.530  -5.830  35.457  1.00  0.00           H  
ATOM     66  N   VAL A   8      22.578  -4.640  32.691  1.00  0.00           N  
ATOM     67  CA  VAL A   8      21.849  -4.050  31.574  1.00  0.00           C  
ATOM     68  C   VAL A   8      21.800  -5.002  30.385  1.00  0.00           C  
ATOM     69  O   VAL A   8      22.492  -6.021  30.361  1.00  0.00           O  
ATOM     70  CB  VAL A   8      22.487  -2.721  31.127  1.00  0.00           C  
ATOM     71  CG1 VAL A   8      22.484  -1.717  32.270  1.00  0.00           C  
ATOM     72  CG2 VAL A   8      23.900  -2.955  30.615  1.00  0.00           C  
ATOM     73  H   VAL A   8      23.309  -5.266  32.506  1.00  0.00           H  
ATOM     74  HA  VAL A   8      20.840  -3.849  31.904  1.00  0.00           H  
ATOM     75  HB  VAL A   8      21.896  -2.315  30.320  1.00  0.00           H  
ATOM     76 HG11 VAL A   8      22.673  -0.727  31.879  1.00  0.00           H  
ATOM     77 HG12 VAL A   8      21.523  -1.734  32.763  1.00  0.00           H  
ATOM     78 HG13 VAL A   8      23.257  -1.977  32.978  1.00  0.00           H  
ATOM     79 HG21 VAL A   8      23.909  -3.815  29.964  1.00  0.00           H  
ATOM     80 HG22 VAL A   8      24.233  -2.085  30.065  1.00  0.00           H  
ATOM     81 HG23 VAL A   8      24.562  -3.127  31.450  1.00  0.00           H  
ATOM     82  N   LYS A   9      20.977  -4.666  29.398  1.00  0.00           N  
ATOM     83  CA  LYS A   9      20.837  -5.490  28.203  1.00  0.00           C  
ATOM     84  C   LYS A   9      21.365  -4.758  26.973  1.00  0.00           C  
ATOM     85  O   LYS A   9      21.223  -3.542  26.836  1.00  0.00           O  
ATOM     86  CB  LYS A   9      19.371  -5.873  27.991  1.00  0.00           C  
ATOM     87  CG  LYS A   9      18.780  -6.671  29.141  1.00  0.00           C  
ATOM     88  CD  LYS A   9      18.278  -5.762  30.251  1.00  0.00           C  
ATOM     89  CE  LYS A   9      17.921  -6.553  31.500  1.00  0.00           C  
ATOM     90  NZ  LYS A   9      16.609  -7.244  31.362  1.00  0.00           N  
ATOM     91  H   LYS A   9      20.451  -3.842  29.475  1.00  0.00           H  
ATOM     92  HA  LYS A   9      21.418  -6.387  28.349  1.00  0.00           H  
ATOM     93  HB2 LYS A   9      18.789  -4.971  27.869  1.00  0.00           H  
ATOM     94  HB3 LYS A   9      19.293  -6.466  27.091  1.00  0.00           H  
ATOM     95  HG2 LYS A   9      17.952  -7.259  28.771  1.00  0.00           H  
ATOM     96  HG3 LYS A   9      19.540  -7.327  29.540  1.00  0.00           H  
ATOM     97  HD2 LYS A   9      19.052  -5.050  30.498  1.00  0.00           H  
ATOM     98  HD3 LYS A   9      17.401  -5.236  29.904  1.00  0.00           H  
ATOM     99  HE2 LYS A   9      18.689  -7.289  31.675  1.00  0.00           H  
ATOM    100  HE3 LYS A   9      17.875  -5.874  32.338  1.00  0.00           H  
ATOM    101  HZ1 LYS A   9      15.838  -6.609  31.653  1.00  0.00           H  
ATOM    102  HZ2 LYS A   9      16.588  -8.093  31.961  1.00  0.00           H  
ATOM    103  HZ3 LYS A   9      16.455  -7.525  30.373  1.00  0.00           H  
ATOM    104  N   PRO A  10      21.987  -5.513  26.055  1.00  0.00           N  
ATOM    105  CA  PRO A  10      22.545  -4.956  24.819  1.00  0.00           C  
ATOM    106  C   PRO A  10      21.463  -4.496  23.849  1.00  0.00           C  
ATOM    107  O   PRO A  10      20.369  -5.058  23.789  1.00  0.00           O  
ATOM    108  CB  PRO A  10      23.332  -6.129  24.226  1.00  0.00           C  
ATOM    109  CG  PRO A  10      22.672  -7.344  24.778  1.00  0.00           C  
ATOM    110  CD  PRO A  10      22.192  -6.967  26.153  1.00  0.00           C  
ATOM    111  HA  PRO A  10      23.218  -4.135  25.023  1.00  0.00           H  
ATOM    112  HB2 PRO A  10      23.268  -6.099  23.147  1.00  0.00           H  
ATOM    113  HB3 PRO A  10      24.365  -6.066  24.533  1.00  0.00           H  
ATOM    114  HG2 PRO A  10      21.837  -7.626  24.154  1.00  0.00           H  
ATOM    115  HG3 PRO A  10      23.386  -8.153  24.840  1.00  0.00           H  
ATOM    116  HD2 PRO A  10      21.266  -7.473  26.381  1.00  0.00           H  
ATOM    117  HD3 PRO A  10      22.943  -7.201  26.893  1.00  0.00           H  
ATOM    118  N   PRO A  11      21.772  -3.449  23.070  1.00  0.00           N  
ATOM    119  CA  PRO A  11      20.839  -2.890  22.087  1.00  0.00           C  
ATOM    120  C   PRO A  11      20.611  -3.828  20.906  1.00  0.00           C  
ATOM    121  O   PRO A  11      19.471  -4.102  20.529  1.00  0.00           O  
ATOM    122  CB  PRO A  11      21.534  -1.607  21.627  1.00  0.00           C  
ATOM    123  CG  PRO A  11      22.983  -1.855  21.866  1.00  0.00           C  
ATOM    124  CD  PRO A  11      23.057  -2.730  23.088  1.00  0.00           C  
ATOM    125  HA  PRO A  11      19.888  -2.644  22.539  1.00  0.00           H  
ATOM    126  HB2 PRO A  11      21.330  -1.440  20.578  1.00  0.00           H  
ATOM    127  HB3 PRO A  11      21.175  -0.770  22.206  1.00  0.00           H  
ATOM    128  HG2 PRO A  11      23.416  -2.360  21.017  1.00  0.00           H  
ATOM    129  HG3 PRO A  11      23.491  -0.918  22.047  1.00  0.00           H  
ATOM    130  HD2 PRO A  11      23.885  -3.418  23.009  1.00  0.00           H  
ATOM    131  HD3 PRO A  11      23.148  -2.126  23.979  1.00  0.00           H  
ATOM    132  N   HIS A  12      21.703  -4.316  20.326  1.00  0.00           N  
ATOM    133  CA  HIS A  12      21.621  -5.224  19.187  1.00  0.00           C  
ATOM    134  C   HIS A  12      22.367  -6.524  19.474  1.00  0.00           C  
ATOM    135  O   HIS A  12      21.877  -7.611  19.174  1.00  0.00           O  
ATOM    136  CB  HIS A  12      22.195  -4.559  17.935  1.00  0.00           C  
ATOM    137  CG  HIS A  12      23.272  -3.560  18.228  1.00  0.00           C  
ATOM    138  ND1 HIS A  12      24.576  -3.919  18.502  1.00  0.00           N  
ATOM    139  CD2 HIS A  12      23.235  -2.209  18.288  1.00  0.00           C  
ATOM    140  CE1 HIS A  12      25.293  -2.831  18.719  1.00  0.00           C  
ATOM    141  NE2 HIS A  12      24.503  -1.779  18.594  1.00  0.00           N  
ATOM    142  H   HIS A  12      22.583  -4.059  20.671  1.00  0.00           H  
ATOM    143  HA  HIS A  12      20.579  -5.451  19.018  1.00  0.00           H  
ATOM    144  HB2 HIS A  12      22.613  -5.318  17.292  1.00  0.00           H  
ATOM    145  HB3 HIS A  12      21.401  -4.046  17.411  1.00  0.00           H  
ATOM    146  HD1 HIS A  12      24.923  -4.834  18.533  1.00  0.00           H  
ATOM    147  HD2 HIS A  12      22.369  -1.583  18.125  1.00  0.00           H  
ATOM    148  HE1 HIS A  12      26.346  -2.804  18.957  1.00  0.00           H  
ATOM    149  HE2 HIS A  12      24.761  -0.854  18.787  1.00  0.00           H  
ATOM    150  N   GLY A  13      23.556  -6.401  20.057  1.00  0.00           N  
ATOM    151  CA  GLY A  13      24.351  -7.574  20.373  1.00  0.00           C  
ATOM    152  C   GLY A  13      25.784  -7.450  19.897  1.00  0.00           C  
ATOM    153  O   GLY A  13      26.442  -8.451  19.618  1.00  0.00           O  
ATOM    154  H   GLY A  13      23.897  -5.508  20.273  1.00  0.00           H  
ATOM    155  HA2 GLY A  13      24.349  -7.718  21.444  1.00  0.00           H  
ATOM    156  HA3 GLY A  13      23.901  -8.437  19.904  1.00  0.00           H  
ATOM    157  N   PHE A  14      26.268  -6.216  19.800  1.00  0.00           N  
ATOM    158  CA  PHE A  14      27.633  -5.963  19.352  1.00  0.00           C  
ATOM    159  C   PHE A  14      28.391  -5.113  20.366  1.00  0.00           C  
ATOM    160  O   PHE A  14      27.787  -4.445  21.205  1.00  0.00           O  
ATOM    161  CB  PHE A  14      27.623  -5.265  17.990  1.00  0.00           C  
ATOM    162  CG  PHE A  14      27.299  -6.184  16.847  1.00  0.00           C  
ATOM    163  CD1 PHE A  14      26.062  -6.805  16.769  1.00  0.00           C  
ATOM    164  CD2 PHE A  14      28.230  -6.427  15.850  1.00  0.00           C  
ATOM    165  CE1 PHE A  14      25.760  -7.652  15.719  1.00  0.00           C  
ATOM    166  CE2 PHE A  14      27.934  -7.272  14.797  1.00  0.00           C  
ATOM    167  CZ  PHE A  14      26.698  -7.885  14.732  1.00  0.00           C  
ATOM    168  H   PHE A  14      25.695  -5.457  20.037  1.00  0.00           H  
ATOM    169  HA  PHE A  14      28.130  -6.916  19.254  1.00  0.00           H  
ATOM    170  HB2 PHE A  14      26.884  -4.478  18.002  1.00  0.00           H  
ATOM    171  HB3 PHE A  14      28.596  -4.836  17.806  1.00  0.00           H  
ATOM    172  HD1 PHE A  14      25.328  -6.622  17.541  1.00  0.00           H  
ATOM    173  HD2 PHE A  14      29.197  -5.949  15.900  1.00  0.00           H  
ATOM    174  HE1 PHE A  14      24.793  -8.129  15.671  1.00  0.00           H  
ATOM    175  HE2 PHE A  14      28.668  -7.453  14.028  1.00  0.00           H  
ATOM    176  HZ  PHE A  14      26.463  -8.545  13.911  1.00  0.00           H  
ATOM    177  N   GLN A  15      29.717  -5.145  20.282  1.00  0.00           N  
ATOM    178  CA  GLN A  15      30.558  -4.378  21.194  1.00  0.00           C  
ATOM    179  C   GLN A  15      31.592  -3.563  20.425  1.00  0.00           C  
ATOM    180  O   GLN A  15      31.774  -3.747  19.221  1.00  0.00           O  
ATOM    181  CB  GLN A  15      31.260  -5.313  22.181  1.00  0.00           C  
ATOM    182  CG  GLN A  15      30.306  -6.203  22.960  1.00  0.00           C  
ATOM    183  CD  GLN A  15      30.963  -6.857  24.159  1.00  0.00           C  
ATOM    184  OE1 GLN A  15      31.430  -7.994  24.084  1.00  0.00           O  
ATOM    185  NE2 GLN A  15      31.005  -6.139  25.276  1.00  0.00           N  
ATOM    186  H   GLN A  15      30.139  -5.697  19.592  1.00  0.00           H  
ATOM    187  HA  GLN A  15      29.921  -3.702  21.744  1.00  0.00           H  
ATOM    188  HB2 GLN A  15      31.945  -5.945  21.636  1.00  0.00           H  
ATOM    189  HB3 GLN A  15      31.818  -4.716  22.888  1.00  0.00           H  
ATOM    190  HG2 GLN A  15      29.476  -5.604  23.306  1.00  0.00           H  
ATOM    191  HG3 GLN A  15      29.939  -6.978  22.302  1.00  0.00           H  
ATOM    192 HE21 GLN A  15      30.613  -5.240  25.263  1.00  0.00           H  
ATOM    193 HE22 GLN A  15      31.424  -6.536  26.067  1.00  0.00           H  
ATOM    194  N   LYS A  16      32.267  -2.659  21.127  1.00  0.00           N  
ATOM    195  CA  LYS A  16      33.285  -1.815  20.512  1.00  0.00           C  
ATOM    196  C   LYS A  16      34.679  -2.389  20.739  1.00  0.00           C  
ATOM    197  O   LYS A  16      34.901  -3.157  21.675  1.00  0.00           O  
ATOM    198  CB  LYS A  16      33.208  -0.395  21.078  1.00  0.00           C  
ATOM    199  CG  LYS A  16      32.127   0.457  20.437  1.00  0.00           C  
ATOM    200  CD  LYS A  16      31.660   1.560  21.372  1.00  0.00           C  
ATOM    201  CE  LYS A  16      30.763   1.015  22.474  1.00  0.00           C  
ATOM    202  NZ  LYS A  16      30.849   1.835  23.714  1.00  0.00           N  
ATOM    203  H   LYS A  16      32.078  -2.559  22.084  1.00  0.00           H  
ATOM    204  HA  LYS A  16      33.090  -1.781  19.451  1.00  0.00           H  
ATOM    205  HB2 LYS A  16      33.011  -0.452  22.138  1.00  0.00           H  
ATOM    206  HB3 LYS A  16      34.160   0.093  20.923  1.00  0.00           H  
ATOM    207  HG2 LYS A  16      32.520   0.906  19.538  1.00  0.00           H  
ATOM    208  HG3 LYS A  16      31.284  -0.173  20.190  1.00  0.00           H  
ATOM    209  HD2 LYS A  16      32.522   2.027  21.824  1.00  0.00           H  
ATOM    210  HD3 LYS A  16      31.109   2.295  20.802  1.00  0.00           H  
ATOM    211  HE2 LYS A  16      29.743   1.015  22.123  1.00  0.00           H  
ATOM    212  HE3 LYS A  16      31.067   0.004  22.699  1.00  0.00           H  
ATOM    213  HZ1 LYS A  16      29.927   2.271  23.918  1.00  0.00           H  
ATOM    214  HZ2 LYS A  16      31.557   2.587  23.598  1.00  0.00           H  
ATOM    215  HZ3 LYS A  16      31.122   1.236  24.520  1.00  0.00           H  
ATOM    216  N   LYS A  17      35.618  -2.012  19.877  1.00  0.00           N  
ATOM    217  CA  LYS A  17      36.991  -2.487  19.984  1.00  0.00           C  
ATOM    218  C   LYS A  17      37.066  -3.994  19.761  1.00  0.00           C  
ATOM    219  O   LYS A  17      37.963  -4.664  20.272  1.00  0.00           O  
ATOM    220  CB  LYS A  17      37.569  -2.135  21.356  1.00  0.00           C  
ATOM    221  CG  LYS A  17      37.285  -0.706  21.788  1.00  0.00           C  
ATOM    222  CD  LYS A  17      38.100  -0.321  23.012  1.00  0.00           C  
ATOM    223  CE  LYS A  17      37.377  -0.687  24.299  1.00  0.00           C  
ATOM    224  NZ  LYS A  17      38.236  -0.473  25.498  1.00  0.00           N  
ATOM    225  H   LYS A  17      35.379  -1.398  19.151  1.00  0.00           H  
ATOM    226  HA  LYS A  17      37.573  -1.993  19.221  1.00  0.00           H  
ATOM    227  HB2 LYS A  17      37.145  -2.801  22.094  1.00  0.00           H  
ATOM    228  HB3 LYS A  17      38.640  -2.275  21.330  1.00  0.00           H  
ATOM    229  HG2 LYS A  17      37.537  -0.039  20.977  1.00  0.00           H  
ATOM    230  HG3 LYS A  17      36.234  -0.613  22.021  1.00  0.00           H  
ATOM    231  HD2 LYS A  17      39.046  -0.842  22.983  1.00  0.00           H  
ATOM    232  HD3 LYS A  17      38.273   0.745  22.997  1.00  0.00           H  
ATOM    233  HE2 LYS A  17      36.493  -0.076  24.387  1.00  0.00           H  
ATOM    234  HE3 LYS A  17      37.091  -1.728  24.252  1.00  0.00           H  
ATOM    235  HZ1 LYS A  17      39.213  -0.269  25.204  1.00  0.00           H  
ATOM    236  HZ2 LYS A  17      38.237  -1.326  26.093  1.00  0.00           H  
ATOM    237  HZ3 LYS A  17      37.878   0.327  26.056  1.00  0.00           H  
ATOM    238  N   MET A  18      36.116  -4.522  18.994  1.00  0.00           N  
ATOM    239  CA  MET A  18      36.076  -5.950  18.702  1.00  0.00           C  
ATOM    240  C   MET A  18      36.277  -6.205  17.212  1.00  0.00           C  
ATOM    241  O   MET A  18      36.503  -5.276  16.436  1.00  0.00           O  
ATOM    242  CB  MET A  18      34.745  -6.548  19.158  1.00  0.00           C  
ATOM    243  CG  MET A  18      33.635  -6.418  18.129  1.00  0.00           C  
ATOM    244  SD  MET A  18      32.127  -7.278  18.620  1.00  0.00           S  
ATOM    245  CE  MET A  18      31.054  -6.894  17.239  1.00  0.00           C  
ATOM    246  H   MET A  18      35.427  -3.937  18.615  1.00  0.00           H  
ATOM    247  HA  MET A  18      36.880  -6.422  19.248  1.00  0.00           H  
ATOM    248  HB2 MET A  18      34.890  -7.597  19.370  1.00  0.00           H  
ATOM    249  HB3 MET A  18      34.429  -6.047  20.061  1.00  0.00           H  
ATOM    250  HG2 MET A  18      33.407  -5.372  17.994  1.00  0.00           H  
ATOM    251  HG3 MET A  18      33.980  -6.833  17.193  1.00  0.00           H  
ATOM    252  HE1 MET A  18      31.650  -6.583  16.394  1.00  0.00           H  
ATOM    253  HE2 MET A  18      30.483  -7.771  16.973  1.00  0.00           H  
ATOM    254  HE3 MET A  18      30.380  -6.096  17.517  1.00  0.00           H  
ATOM    255  N   LYS A  19      36.194  -7.471  16.815  1.00  0.00           N  
ATOM    256  CA  LYS A  19      36.365  -7.850  15.418  1.00  0.00           C  
ATOM    257  C   LYS A  19      35.116  -8.542  14.885  1.00  0.00           C  
ATOM    258  O   LYS A  19      34.369  -9.167  15.640  1.00  0.00           O  
ATOM    259  CB  LYS A  19      37.577  -8.771  15.263  1.00  0.00           C  
ATOM    260  CG  LYS A  19      38.907  -8.064  15.458  1.00  0.00           C  
ATOM    261  CD  LYS A  19      39.147  -7.021  14.378  1.00  0.00           C  
ATOM    262  CE  LYS A  19      40.488  -6.328  14.562  1.00  0.00           C  
ATOM    263  NZ  LYS A  19      40.434  -5.285  15.623  1.00  0.00           N  
ATOM    264  H   LYS A  19      36.011  -8.168  17.481  1.00  0.00           H  
ATOM    265  HA  LYS A  19      36.534  -6.949  14.849  1.00  0.00           H  
ATOM    266  HB2 LYS A  19      37.506  -9.566  15.991  1.00  0.00           H  
ATOM    267  HB3 LYS A  19      37.562  -9.201  14.272  1.00  0.00           H  
ATOM    268  HG2 LYS A  19      38.909  -7.576  16.421  1.00  0.00           H  
ATOM    269  HG3 LYS A  19      39.702  -8.796  15.421  1.00  0.00           H  
ATOM    270  HD2 LYS A  19      39.134  -7.505  13.413  1.00  0.00           H  
ATOM    271  HD3 LYS A  19      38.360  -6.282  14.423  1.00  0.00           H  
ATOM    272  HE2 LYS A  19      41.227  -7.067  14.833  1.00  0.00           H  
ATOM    273  HE3 LYS A  19      40.770  -5.865  13.628  1.00  0.00           H  
ATOM    274  HZ1 LYS A  19      40.712  -4.363  15.232  1.00  0.00           H  
ATOM    275  HZ2 LYS A  19      41.083  -5.530  16.399  1.00  0.00           H  
ATOM    276  HZ3 LYS A  19      39.469  -5.213  16.003  1.00  0.00           H  
ATOM    277  N   LEU A  20      34.893  -8.428  13.580  1.00  0.00           N  
ATOM    278  CA  LEU A  20      33.733  -9.045  12.945  1.00  0.00           C  
ATOM    279  C   LEU A  20      33.871  -9.030  11.426  1.00  0.00           C  
ATOM    280  O   LEU A  20      34.392  -8.074  10.851  1.00  0.00           O  
ATOM    281  CB  LEU A  20      32.453  -8.318  13.359  1.00  0.00           C  
ATOM    282  CG  LEU A  20      32.008  -7.172  12.449  1.00  0.00           C  
ATOM    283  CD1 LEU A  20      31.081  -7.687  11.359  1.00  0.00           C  
ATOM    284  CD2 LEU A  20      31.326  -6.081  13.260  1.00  0.00           C  
ATOM    285  H   LEU A  20      35.522  -7.918  13.030  1.00  0.00           H  
ATOM    286  HA  LEU A  20      33.679 -10.070  13.280  1.00  0.00           H  
ATOM    287  HB2 LEU A  20      31.655  -9.043  13.391  1.00  0.00           H  
ATOM    288  HB3 LEU A  20      32.609  -7.914  14.349  1.00  0.00           H  
ATOM    289  HG  LEU A  20      32.877  -6.742  11.971  1.00  0.00           H  
ATOM    290 HD11 LEU A  20      30.299  -6.964  11.181  1.00  0.00           H  
ATOM    291 HD12 LEU A  20      30.641  -8.622  11.672  1.00  0.00           H  
ATOM    292 HD13 LEU A  20      31.644  -7.840  10.450  1.00  0.00           H  
ATOM    293 HD21 LEU A  20      32.071  -5.398  13.642  1.00  0.00           H  
ATOM    294 HD22 LEU A  20      30.791  -6.526  14.086  1.00  0.00           H  
ATOM    295 HD23 LEU A  20      30.633  -5.543  12.630  1.00  0.00           H  
ATOM    296  N   GLU A  21      33.402 -10.095  10.784  1.00  0.00           N  
ATOM    297  CA  GLU A  21      33.473 -10.202   9.331  1.00  0.00           C  
ATOM    298  C   GLU A  21      32.316  -9.454   8.673  1.00  0.00           C  
ATOM    299  O   GLU A  21      31.151  -9.808   8.853  1.00  0.00           O  
ATOM    300  CB  GLU A  21      33.453 -11.672   8.905  1.00  0.00           C  
ATOM    301  CG  GLU A  21      34.664 -12.459   9.376  1.00  0.00           C  
ATOM    302  CD  GLU A  21      34.767 -13.821   8.718  1.00  0.00           C  
ATOM    303  OE1 GLU A  21      34.141 -14.015   7.654  1.00  0.00           O  
ATOM    304  OE2 GLU A  21      35.473 -14.692   9.266  1.00  0.00           O  
ATOM    305  H   GLU A  21      32.999 -10.825  11.298  1.00  0.00           H  
ATOM    306  HA  GLU A  21      34.402  -9.756   9.011  1.00  0.00           H  
ATOM    307  HB2 GLU A  21      32.567 -12.139   9.307  1.00  0.00           H  
ATOM    308  HB3 GLU A  21      33.415 -11.720   7.827  1.00  0.00           H  
ATOM    309  HG2 GLU A  21      35.556 -11.896   9.143  1.00  0.00           H  
ATOM    310  HG3 GLU A  21      34.595 -12.596  10.445  1.00  0.00           H  
ATOM    311  N   VAL A  22      32.648  -8.417   7.910  1.00  0.00           N  
ATOM    312  CA  VAL A  22      31.639  -7.619   7.225  1.00  0.00           C  
ATOM    313  C   VAL A  22      31.680  -7.857   5.719  1.00  0.00           C  
ATOM    314  O   VAL A  22      32.752  -7.994   5.130  1.00  0.00           O  
ATOM    315  CB  VAL A  22      31.829  -6.116   7.501  1.00  0.00           C  
ATOM    316  CG1 VAL A  22      30.727  -5.307   6.836  1.00  0.00           C  
ATOM    317  CG2 VAL A  22      31.865  -5.851   8.999  1.00  0.00           C  
ATOM    318  H   VAL A  22      33.594  -8.184   7.805  1.00  0.00           H  
ATOM    319  HA  VAL A  22      30.669  -7.914   7.600  1.00  0.00           H  
ATOM    320  HB  VAL A  22      32.775  -5.809   7.081  1.00  0.00           H  
ATOM    321 HG11 VAL A  22      31.022  -5.061   5.825  1.00  0.00           H  
ATOM    322 HG12 VAL A  22      29.816  -5.887   6.815  1.00  0.00           H  
ATOM    323 HG13 VAL A  22      30.562  -4.396   7.393  1.00  0.00           H  
ATOM    324 HG21 VAL A  22      30.917  -6.130   9.436  1.00  0.00           H  
ATOM    325 HG22 VAL A  22      32.655  -6.435   9.450  1.00  0.00           H  
ATOM    326 HG23 VAL A  22      32.048  -4.802   9.176  1.00  0.00           H  
ATOM    327  N   VAL A  23      30.504  -7.903   5.101  1.00  0.00           N  
ATOM    328  CA  VAL A  23      30.406  -8.123   3.663  1.00  0.00           C  
ATOM    329  C   VAL A  23      30.523  -6.809   2.898  1.00  0.00           C  
ATOM    330  O   VAL A  23      29.696  -5.911   3.055  1.00  0.00           O  
ATOM    331  CB  VAL A  23      29.076  -8.805   3.289  1.00  0.00           C  
ATOM    332  CG1 VAL A  23      28.910  -8.860   1.778  1.00  0.00           C  
ATOM    333  CG2 VAL A  23      29.005 -10.199   3.894  1.00  0.00           C  
ATOM    334  H   VAL A  23      29.685  -7.787   5.624  1.00  0.00           H  
ATOM    335  HA  VAL A  23      31.215  -8.774   3.367  1.00  0.00           H  
ATOM    336  HB  VAL A  23      28.266  -8.217   3.697  1.00  0.00           H  
ATOM    337 HG11 VAL A  23      29.745  -9.388   1.344  1.00  0.00           H  
ATOM    338 HG12 VAL A  23      27.992  -9.374   1.535  1.00  0.00           H  
ATOM    339 HG13 VAL A  23      28.876  -7.855   1.383  1.00  0.00           H  
ATOM    340 HG21 VAL A  23      29.609 -10.234   4.787  1.00  0.00           H  
ATOM    341 HG22 VAL A  23      27.979 -10.431   4.143  1.00  0.00           H  
ATOM    342 HG23 VAL A  23      29.373 -10.920   3.180  1.00  0.00           H  
ATOM    343  N   ASP A  24      31.556  -6.704   2.069  1.00  0.00           N  
ATOM    344  CA  ASP A  24      31.781  -5.501   1.276  1.00  0.00           C  
ATOM    345  C   ASP A  24      30.523  -5.112   0.509  1.00  0.00           C  
ATOM    346  O   ASP A  24      30.117  -5.798  -0.430  1.00  0.00           O  
ATOM    347  CB  ASP A  24      32.942  -5.716   0.303  1.00  0.00           C  
ATOM    348  CG  ASP A  24      33.645  -4.421  -0.053  1.00  0.00           C  
ATOM    349  OD1 ASP A  24      33.678  -3.508   0.798  1.00  0.00           O  
ATOM    350  OD2 ASP A  24      34.163  -4.321  -1.185  1.00  0.00           O  
ATOM    351  H   ASP A  24      32.181  -7.455   1.987  1.00  0.00           H  
ATOM    352  HA  ASP A  24      32.036  -4.701   1.955  1.00  0.00           H  
ATOM    353  HB2 ASP A  24      33.663  -6.383   0.753  1.00  0.00           H  
ATOM    354  HB3 ASP A  24      32.563  -6.162  -0.605  1.00  0.00           H  
ATOM    355  N   LYS A  25      29.906  -4.007   0.914  1.00  0.00           N  
ATOM    356  CA  LYS A  25      28.693  -3.525   0.265  1.00  0.00           C  
ATOM    357  C   LYS A  25      28.824  -3.592  -1.253  1.00  0.00           C  
ATOM    358  O   LYS A  25      28.028  -4.247  -1.926  1.00  0.00           O  
ATOM    359  CB  LYS A  25      28.393  -2.089   0.699  1.00  0.00           C  
ATOM    360  CG  LYS A  25      28.751  -1.804   2.147  1.00  0.00           C  
ATOM    361  CD  LYS A  25      28.232  -2.891   3.074  1.00  0.00           C  
ATOM    362  CE  LYS A  25      26.736  -2.758   3.307  1.00  0.00           C  
ATOM    363  NZ  LYS A  25      26.119  -4.054   3.703  1.00  0.00           N  
ATOM    364  H   LYS A  25      30.277  -3.502   1.668  1.00  0.00           H  
ATOM    365  HA  LYS A  25      27.877  -4.162   0.572  1.00  0.00           H  
ATOM    366  HB2 LYS A  25      28.955  -1.411   0.072  1.00  0.00           H  
ATOM    367  HB3 LYS A  25      27.338  -1.897   0.566  1.00  0.00           H  
ATOM    368  HG2 LYS A  25      29.825  -1.749   2.239  1.00  0.00           H  
ATOM    369  HG3 LYS A  25      28.315  -0.858   2.437  1.00  0.00           H  
ATOM    370  HD2 LYS A  25      28.433  -3.855   2.630  1.00  0.00           H  
ATOM    371  HD3 LYS A  25      28.744  -2.816   4.023  1.00  0.00           H  
ATOM    372  HE2 LYS A  25      26.569  -2.035   4.090  1.00  0.00           H  
ATOM    373  HE3 LYS A  25      26.272  -2.414   2.394  1.00  0.00           H  
ATOM    374  HZ1 LYS A  25      26.433  -4.321   4.658  1.00  0.00           H  
ATOM    375  HZ2 LYS A  25      26.401  -4.803   3.038  1.00  0.00           H  
ATOM    376  HZ3 LYS A  25      25.083  -3.974   3.700  1.00  0.00           H  
ATOM    377  N   ARG A  26      29.834  -2.911  -1.786  1.00  0.00           N  
ATOM    378  CA  ARG A  26      30.069  -2.894  -3.224  1.00  0.00           C  
ATOM    379  C   ARG A  26      30.283  -4.307  -3.757  1.00  0.00           C  
ATOM    380  O   ARG A  26      29.974  -4.600  -4.912  1.00  0.00           O  
ATOM    381  CB  ARG A  26      31.284  -2.024  -3.553  1.00  0.00           C  
ATOM    382  CG  ARG A  26      32.395  -2.112  -2.519  1.00  0.00           C  
ATOM    383  CD  ARG A  26      32.285  -0.998  -1.488  1.00  0.00           C  
ATOM    384  NE  ARG A  26      33.059   0.180  -1.872  1.00  0.00           N  
ATOM    385  CZ  ARG A  26      33.062   1.314  -1.181  1.00  0.00           C  
ATOM    386  NH1 ARG A  26      32.335   1.423  -0.077  1.00  0.00           N  
ATOM    387  NH2 ARG A  26      33.792   2.342  -1.594  1.00  0.00           N  
ATOM    388  H   ARG A  26      30.434  -2.407  -1.197  1.00  0.00           H  
ATOM    389  HA  ARG A  26      29.196  -2.471  -3.698  1.00  0.00           H  
ATOM    390  HB2 ARG A  26      31.685  -2.333  -4.507  1.00  0.00           H  
ATOM    391  HB3 ARG A  26      30.966  -0.995  -3.622  1.00  0.00           H  
ATOM    392  HG2 ARG A  26      32.327  -3.064  -2.013  1.00  0.00           H  
ATOM    393  HG3 ARG A  26      33.347  -2.035  -3.021  1.00  0.00           H  
ATOM    394  HD2 ARG A  26      31.247  -0.718  -1.389  1.00  0.00           H  
ATOM    395  HD3 ARG A  26      32.651  -1.366  -0.542  1.00  0.00           H  
ATOM    396  HE  ARG A  26      33.602   0.121  -2.685  1.00  0.00           H  
ATOM    397 HH11 ARG A  26      31.786   0.650   0.238  1.00  0.00           H  
ATOM    398 HH12 ARG A  26      32.341   2.277   0.443  1.00  0.00           H  
ATOM    399 HH21 ARG A  26      34.341   2.263  -2.426  1.00  0.00           H  
ATOM    400 HH22 ARG A  26      33.793   3.195  -1.073  1.00  0.00           H  
ATOM    401  N   ASN A  27      30.814  -5.180  -2.907  1.00  0.00           N  
ATOM    402  CA  ASN A  27      31.070  -6.563  -3.293  1.00  0.00           C  
ATOM    403  C   ASN A  27      30.488  -7.531  -2.267  1.00  0.00           C  
ATOM    404  O   ASN A  27      31.123  -7.873  -1.269  1.00  0.00           O  
ATOM    405  CB  ASN A  27      32.574  -6.803  -3.441  1.00  0.00           C  
ATOM    406  CG  ASN A  27      33.291  -5.614  -4.051  1.00  0.00           C  
ATOM    407  OD1 ASN A  27      34.230  -5.074  -3.465  1.00  0.00           O  
ATOM    408  ND2 ASN A  27      32.852  -5.202  -5.235  1.00  0.00           N  
ATOM    409  H   ASN A  27      31.039  -4.888  -1.999  1.00  0.00           H  
ATOM    410  HA  ASN A  27      30.591  -6.736  -4.245  1.00  0.00           H  
ATOM    411  HB2 ASN A  27      33.000  -6.995  -2.466  1.00  0.00           H  
ATOM    412  HB3 ASN A  27      32.735  -7.662  -4.075  1.00  0.00           H  
ATOM    413 HD21 ASN A  27      32.101  -5.681  -5.642  1.00  0.00           H  
ATOM    414 HD22 ASN A  27      33.299  -4.436  -5.652  1.00  0.00           H  
ATOM    415  N   PRO A  28      29.251  -7.985  -2.517  1.00  0.00           N  
ATOM    416  CA  PRO A  28      28.556  -8.920  -1.626  1.00  0.00           C  
ATOM    417  C   PRO A  28      29.177 -10.313  -1.651  1.00  0.00           C  
ATOM    418  O   PRO A  28      28.793 -11.187  -0.875  1.00  0.00           O  
ATOM    419  CB  PRO A  28      27.134  -8.958  -2.193  1.00  0.00           C  
ATOM    420  CG  PRO A  28      27.288  -8.591  -3.629  1.00  0.00           C  
ATOM    421  CD  PRO A  28      28.435  -7.619  -3.687  1.00  0.00           C  
ATOM    422  HA  PRO A  28      28.531  -8.556  -0.610  1.00  0.00           H  
ATOM    423  HB2 PRO A  28      26.726  -9.952  -2.081  1.00  0.00           H  
ATOM    424  HB3 PRO A  28      26.515  -8.247  -1.668  1.00  0.00           H  
ATOM    425  HG2 PRO A  28      27.512  -9.470  -4.211  1.00  0.00           H  
ATOM    426  HG3 PRO A  28      26.383  -8.122  -3.986  1.00  0.00           H  
ATOM    427  HD2 PRO A  28      28.994  -7.748  -4.602  1.00  0.00           H  
ATOM    428  HD3 PRO A  28      28.074  -6.604  -3.603  1.00  0.00           H  
ATOM    429  N   MET A  29      30.138 -10.511  -2.548  1.00  0.00           N  
ATOM    430  CA  MET A  29      30.812 -11.798  -2.671  1.00  0.00           C  
ATOM    431  C   MET A  29      32.201 -11.747  -2.041  1.00  0.00           C  
ATOM    432  O   MET A  29      33.011 -12.656  -2.225  1.00  0.00           O  
ATOM    433  CB  MET A  29      30.922 -12.202  -4.142  1.00  0.00           C  
ATOM    434  CG  MET A  29      29.590 -12.585  -4.768  1.00  0.00           C  
ATOM    435  SD  MET A  29      28.728 -13.866  -3.837  1.00  0.00           S  
ATOM    436  CE  MET A  29      27.116 -13.112  -3.637  1.00  0.00           C  
ATOM    437  H   MET A  29      30.400  -9.776  -3.140  1.00  0.00           H  
ATOM    438  HA  MET A  29      30.220 -12.534  -2.148  1.00  0.00           H  
ATOM    439  HB2 MET A  29      31.332 -11.375  -4.701  1.00  0.00           H  
ATOM    440  HB3 MET A  29      31.589 -13.047  -4.224  1.00  0.00           H  
ATOM    441  HG2 MET A  29      28.961 -11.708  -4.811  1.00  0.00           H  
ATOM    442  HG3 MET A  29      29.770 -12.945  -5.770  1.00  0.00           H  
ATOM    443  HE1 MET A  29      27.175 -12.062  -3.883  1.00  0.00           H  
ATOM    444  HE2 MET A  29      26.409 -13.597  -4.293  1.00  0.00           H  
ATOM    445  HE3 MET A  29      26.791 -13.223  -2.612  1.00  0.00           H  
ATOM    446  N   PHE A  30      32.471 -10.677  -1.300  1.00  0.00           N  
ATOM    447  CA  PHE A  30      33.762 -10.507  -0.646  1.00  0.00           C  
ATOM    448  C   PHE A  30      33.582 -10.101   0.815  1.00  0.00           C  
ATOM    449  O   PHE A  30      32.784  -9.217   1.130  1.00  0.00           O  
ATOM    450  CB  PHE A  30      34.596  -9.455  -1.380  1.00  0.00           C  
ATOM    451  CG  PHE A  30      34.990  -9.865  -2.769  1.00  0.00           C  
ATOM    452  CD1 PHE A  30      34.032 -10.016  -3.760  1.00  0.00           C  
ATOM    453  CD2 PHE A  30      36.318 -10.100  -3.085  1.00  0.00           C  
ATOM    454  CE1 PHE A  30      34.393 -10.394  -5.039  1.00  0.00           C  
ATOM    455  CE2 PHE A  30      36.684 -10.479  -4.363  1.00  0.00           C  
ATOM    456  CZ  PHE A  30      35.722 -10.625  -5.342  1.00  0.00           C  
ATOM    457  H   PHE A  30      31.783  -9.985  -1.192  1.00  0.00           H  
ATOM    458  HA  PHE A  30      34.279 -11.453  -0.682  1.00  0.00           H  
ATOM    459  HB2 PHE A  30      34.025  -8.541  -1.454  1.00  0.00           H  
ATOM    460  HB3 PHE A  30      35.498  -9.265  -0.819  1.00  0.00           H  
ATOM    461  HD1 PHE A  30      32.994  -9.835  -3.525  1.00  0.00           H  
ATOM    462  HD2 PHE A  30      37.074  -9.986  -2.320  1.00  0.00           H  
ATOM    463  HE1 PHE A  30      33.638 -10.508  -5.802  1.00  0.00           H  
ATOM    464  HE2 PHE A  30      37.724 -10.659  -4.596  1.00  0.00           H  
ATOM    465  HZ  PHE A  30      36.005 -10.922  -6.340  1.00  0.00           H  
ATOM    466  N   ILE A  31      34.328 -10.753   1.700  1.00  0.00           N  
ATOM    467  CA  ILE A  31      34.252 -10.460   3.126  1.00  0.00           C  
ATOM    468  C   ILE A  31      35.638 -10.218   3.712  1.00  0.00           C  
ATOM    469  O   ILE A  31      36.610 -10.862   3.319  1.00  0.00           O  
ATOM    470  CB  ILE A  31      33.571 -11.605   3.900  1.00  0.00           C  
ATOM    471  CG1 ILE A  31      32.146 -11.821   3.386  1.00  0.00           C  
ATOM    472  CG2 ILE A  31      33.562 -11.304   5.391  1.00  0.00           C  
ATOM    473  CD1 ILE A  31      31.643 -13.235   3.575  1.00  0.00           C  
ATOM    474  H   ILE A  31      34.945 -11.446   1.387  1.00  0.00           H  
ATOM    475  HA  ILE A  31      33.658  -9.565   3.251  1.00  0.00           H  
ATOM    476  HB  ILE A  31      34.144 -12.506   3.742  1.00  0.00           H  
ATOM    477 HG12 ILE A  31      31.476 -11.158   3.910  1.00  0.00           H  
ATOM    478 HG13 ILE A  31      32.115 -11.595   2.329  1.00  0.00           H  
ATOM    479 HG21 ILE A  31      32.842 -11.942   5.883  1.00  0.00           H  
ATOM    480 HG22 ILE A  31      34.543 -11.486   5.801  1.00  0.00           H  
ATOM    481 HG23 ILE A  31      33.292 -10.270   5.548  1.00  0.00           H  
ATOM    482 HD11 ILE A  31      31.300 -13.362   4.590  1.00  0.00           H  
ATOM    483 HD12 ILE A  31      30.830 -13.423   2.891  1.00  0.00           H  
ATOM    484 HD13 ILE A  31      32.446 -13.931   3.378  1.00  0.00           H  
ATOM    485  N   ARG A  32      35.721  -9.287   4.658  1.00  0.00           N  
ATOM    486  CA  ARG A  32      36.987  -8.961   5.300  1.00  0.00           C  
ATOM    487  C   ARG A  32      36.781  -8.635   6.777  1.00  0.00           C  
ATOM    488  O   ARG A  32      35.652  -8.449   7.229  1.00  0.00           O  
ATOM    489  CB  ARG A  32      37.652  -7.778   4.594  1.00  0.00           C  
ATOM    490  CG  ARG A  32      37.894  -8.011   3.112  1.00  0.00           C  
ATOM    491  CD  ARG A  32      37.963  -6.699   2.345  1.00  0.00           C  
ATOM    492  NE  ARG A  32      38.226  -6.909   0.924  1.00  0.00           N  
ATOM    493  CZ  ARG A  32      39.408  -7.272   0.441  1.00  0.00           C  
ATOM    494  NH1 ARG A  32      40.432  -7.467   1.261  1.00  0.00           N  
ATOM    495  NH2 ARG A  32      39.568  -7.444  -0.866  1.00  0.00           N  
ATOM    496  H   ARG A  32      34.909  -8.808   4.929  1.00  0.00           H  
ATOM    497  HA  ARG A  32      37.632  -9.824   5.220  1.00  0.00           H  
ATOM    498  HB2 ARG A  32      37.019  -6.909   4.700  1.00  0.00           H  
ATOM    499  HB3 ARG A  32      38.603  -7.580   5.065  1.00  0.00           H  
ATOM    500  HG2 ARG A  32      38.829  -8.537   2.987  1.00  0.00           H  
ATOM    501  HG3 ARG A  32      37.087  -8.608   2.714  1.00  0.00           H  
ATOM    502  HD2 ARG A  32      37.021  -6.183   2.455  1.00  0.00           H  
ATOM    503  HD3 ARG A  32      38.755  -6.095   2.762  1.00  0.00           H  
ATOM    504  HE  ARG A  32      37.482  -6.770   0.300  1.00  0.00           H  
ATOM    505 HH11 ARG A  32      40.314  -7.340   2.245  1.00  0.00           H  
ATOM    506 HH12 ARG A  32      41.320  -7.743   0.894  1.00  0.00           H  
ATOM    507 HH21 ARG A  32      38.799  -7.298  -1.487  1.00  0.00           H  
ATOM    508 HH22 ARG A  32      40.458  -7.718  -1.228  1.00  0.00           H  
ATOM    509  N   VAL A  33      37.880  -8.568   7.522  1.00  0.00           N  
ATOM    510  CA  VAL A  33      37.820  -8.264   8.946  1.00  0.00           C  
ATOM    511  C   VAL A  33      37.379  -6.824   9.183  1.00  0.00           C  
ATOM    512  O   VAL A  33      37.605  -5.950   8.348  1.00  0.00           O  
ATOM    513  CB  VAL A  33      39.183  -8.491   9.626  1.00  0.00           C  
ATOM    514  CG1 VAL A  33      39.141  -8.029  11.075  1.00  0.00           C  
ATOM    515  CG2 VAL A  33      39.587  -9.955   9.536  1.00  0.00           C  
ATOM    516  H   VAL A  33      38.752  -8.726   7.103  1.00  0.00           H  
ATOM    517  HA  VAL A  33      37.100  -8.931   9.399  1.00  0.00           H  
ATOM    518  HB  VAL A  33      39.925  -7.902   9.106  1.00  0.00           H  
ATOM    519 HG11 VAL A  33      38.943  -6.967  11.108  1.00  0.00           H  
ATOM    520 HG12 VAL A  33      38.359  -8.558  11.600  1.00  0.00           H  
ATOM    521 HG13 VAL A  33      40.091  -8.232  11.545  1.00  0.00           H  
ATOM    522 HG21 VAL A  33      39.790 -10.332  10.527  1.00  0.00           H  
ATOM    523 HG22 VAL A  33      38.783 -10.523   9.092  1.00  0.00           H  
ATOM    524 HG23 VAL A  33      40.472 -10.047   8.927  1.00  0.00           H  
ATOM    525  N   ALA A  34      36.749  -6.585  10.329  1.00  0.00           N  
ATOM    526  CA  ALA A  34      36.278  -5.250  10.677  1.00  0.00           C  
ATOM    527  C   ALA A  34      36.501  -4.959  12.157  1.00  0.00           C  
ATOM    528  O   ALA A  34      36.782  -5.863  12.944  1.00  0.00           O  
ATOM    529  CB  ALA A  34      34.806  -5.101  10.323  1.00  0.00           C  
ATOM    530  H   ALA A  34      36.598  -7.323  10.954  1.00  0.00           H  
ATOM    531  HA  ALA A  34      36.838  -4.535  10.091  1.00  0.00           H  
ATOM    532  HB1 ALA A  34      34.570  -4.053  10.203  1.00  0.00           H  
ATOM    533  HB2 ALA A  34      34.602  -5.624   9.401  1.00  0.00           H  
ATOM    534  HB3 ALA A  34      34.202  -5.517  11.116  1.00  0.00           H  
ATOM    535  N   THR A  35      36.375  -3.689  12.531  1.00  0.00           N  
ATOM    536  CA  THR A  35      36.564  -3.278  13.916  1.00  0.00           C  
ATOM    537  C   THR A  35      35.472  -2.309  14.357  1.00  0.00           C  
ATOM    538  O   THR A  35      35.392  -1.183  13.865  1.00  0.00           O  
ATOM    539  CB  THR A  35      37.938  -2.613  14.122  1.00  0.00           C  
ATOM    540  OG1 THR A  35      38.979  -3.493  13.683  1.00  0.00           O  
ATOM    541  CG2 THR A  35      38.153  -2.256  15.585  1.00  0.00           C  
ATOM    542  H   THR A  35      36.150  -3.013  11.858  1.00  0.00           H  
ATOM    543  HA  THR A  35      36.519  -4.162  14.536  1.00  0.00           H  
ATOM    544  HB  THR A  35      37.973  -1.706  13.536  1.00  0.00           H  
ATOM    545  HG1 THR A  35      38.847  -4.363  14.068  1.00  0.00           H  
ATOM    546 HG21 THR A  35      38.698  -3.050  16.073  1.00  0.00           H  
ATOM    547 HG22 THR A  35      37.196  -2.126  16.068  1.00  0.00           H  
ATOM    548 HG23 THR A  35      38.718  -1.339  15.652  1.00  0.00           H  
ATOM    549  N   VAL A  36      34.633  -2.753  15.287  1.00  0.00           N  
ATOM    550  CA  VAL A  36      33.547  -1.924  15.795  1.00  0.00           C  
ATOM    551  C   VAL A  36      34.086  -0.705  16.535  1.00  0.00           C  
ATOM    552  O   VAL A  36      34.538  -0.807  17.674  1.00  0.00           O  
ATOM    553  CB  VAL A  36      32.629  -2.721  16.741  1.00  0.00           C  
ATOM    554  CG1 VAL A  36      31.396  -1.905  17.100  1.00  0.00           C  
ATOM    555  CG2 VAL A  36      32.235  -4.048  16.109  1.00  0.00           C  
ATOM    556  H   VAL A  36      34.748  -3.660  15.640  1.00  0.00           H  
ATOM    557  HA  VAL A  36      32.959  -1.592  14.952  1.00  0.00           H  
ATOM    558  HB  VAL A  36      33.174  -2.927  17.650  1.00  0.00           H  
ATOM    559 HG11 VAL A  36      31.364  -1.015  16.490  1.00  0.00           H  
ATOM    560 HG12 VAL A  36      30.509  -2.497  16.925  1.00  0.00           H  
ATOM    561 HG13 VAL A  36      31.441  -1.625  18.143  1.00  0.00           H  
ATOM    562 HG21 VAL A  36      33.114  -4.663  15.989  1.00  0.00           H  
ATOM    563 HG22 VAL A  36      31.526  -4.554  16.747  1.00  0.00           H  
ATOM    564 HG23 VAL A  36      31.786  -3.867  15.144  1.00  0.00           H  
ATOM    565  N   ALA A  37      34.033   0.449  15.878  1.00  0.00           N  
ATOM    566  CA  ALA A  37      34.514   1.689  16.473  1.00  0.00           C  
ATOM    567  C   ALA A  37      33.472   2.287  17.413  1.00  0.00           C  
ATOM    568  O   ALA A  37      33.768   2.599  18.566  1.00  0.00           O  
ATOM    569  CB  ALA A  37      34.882   2.689  15.387  1.00  0.00           C  
ATOM    570  H   ALA A  37      33.662   0.467  14.971  1.00  0.00           H  
ATOM    571  HA  ALA A  37      35.407   1.465  17.039  1.00  0.00           H  
ATOM    572  HB1 ALA A  37      34.158   3.490  15.375  1.00  0.00           H  
ATOM    573  HB2 ALA A  37      35.863   3.094  15.588  1.00  0.00           H  
ATOM    574  HB3 ALA A  37      34.886   2.193  14.428  1.00  0.00           H  
ATOM    575  N   ASP A  38      32.251   2.444  16.913  1.00  0.00           N  
ATOM    576  CA  ASP A  38      31.165   3.003  17.707  1.00  0.00           C  
ATOM    577  C   ASP A  38      29.864   2.247  17.458  1.00  0.00           C  
ATOM    578  O   ASP A  38      29.506   1.964  16.314  1.00  0.00           O  
ATOM    579  CB  ASP A  38      30.978   4.486  17.382  1.00  0.00           C  
ATOM    580  CG  ASP A  38      30.425   5.271  18.555  1.00  0.00           C  
ATOM    581  OD1 ASP A  38      30.979   5.145  19.667  1.00  0.00           O  
ATOM    582  OD2 ASP A  38      29.437   6.012  18.362  1.00  0.00           O  
ATOM    583  H   ASP A  38      32.077   2.175  15.985  1.00  0.00           H  
ATOM    584  HA  ASP A  38      31.431   2.904  18.750  1.00  0.00           H  
ATOM    585  HB2 ASP A  38      31.932   4.911  17.106  1.00  0.00           H  
ATOM    586  HB3 ASP A  38      30.293   4.582  16.552  1.00  0.00           H  
ATOM    587  N   THR A  39      29.159   1.921  18.538  1.00  0.00           N  
ATOM    588  CA  THR A  39      27.899   1.195  18.437  1.00  0.00           C  
ATOM    589  C   THR A  39      26.712   2.114  18.705  1.00  0.00           C  
ATOM    590  O   THR A  39      26.523   2.589  19.825  1.00  0.00           O  
ATOM    591  CB  THR A  39      27.852   0.012  19.423  1.00  0.00           C  
ATOM    592  OG1 THR A  39      28.012   0.487  20.764  1.00  0.00           O  
ATOM    593  CG2 THR A  39      28.940  -1.001  19.105  1.00  0.00           C  
ATOM    594  H   THR A  39      29.497   2.174  19.422  1.00  0.00           H  
ATOM    595  HA  THR A  39      27.819   0.803  17.433  1.00  0.00           H  
ATOM    596  HB  THR A  39      26.890  -0.472  19.333  1.00  0.00           H  
ATOM    597  HG1 THR A  39      27.336   1.143  20.955  1.00  0.00           H  
ATOM    598 HG21 THR A  39      29.205  -1.539  20.004  1.00  0.00           H  
ATOM    599 HG22 THR A  39      29.809  -0.488  18.723  1.00  0.00           H  
ATOM    600 HG23 THR A  39      28.577  -1.697  18.363  1.00  0.00           H  
ATOM    601  N   ASP A  40      25.916   2.360  17.671  1.00  0.00           N  
ATOM    602  CA  ASP A  40      24.746   3.222  17.796  1.00  0.00           C  
ATOM    603  C   ASP A  40      23.555   2.444  18.346  1.00  0.00           C  
ATOM    604  O   ASP A  40      23.664   1.255  18.649  1.00  0.00           O  
ATOM    605  CB  ASP A  40      24.390   3.833  16.440  1.00  0.00           C  
ATOM    606  CG  ASP A  40      23.679   5.166  16.574  1.00  0.00           C  
ATOM    607  OD1 ASP A  40      23.938   5.878  17.567  1.00  0.00           O  
ATOM    608  OD2 ASP A  40      22.866   5.497  15.687  1.00  0.00           O  
ATOM    609  H   ASP A  40      26.119   1.952  16.803  1.00  0.00           H  
ATOM    610  HA  ASP A  40      24.990   4.016  18.485  1.00  0.00           H  
ATOM    611  HB2 ASP A  40      25.295   3.985  15.871  1.00  0.00           H  
ATOM    612  HB3 ASP A  40      23.743   3.153  15.904  1.00  0.00           H  
ATOM    613  N   ASP A  41      22.419   3.121  18.472  1.00  0.00           N  
ATOM    614  CA  ASP A  41      21.207   2.494  18.986  1.00  0.00           C  
ATOM    615  C   ASP A  41      20.961   1.151  18.306  1.00  0.00           C  
ATOM    616  O   ASP A  41      20.861   0.117  18.969  1.00  0.00           O  
ATOM    617  CB  ASP A  41      20.003   3.414  18.776  1.00  0.00           C  
ATOM    618  CG  ASP A  41      20.264   4.828  19.255  1.00  0.00           C  
ATOM    619  OD1 ASP A  41      20.378   5.027  20.482  1.00  0.00           O  
ATOM    620  OD2 ASP A  41      20.355   5.737  18.402  1.00  0.00           O  
ATOM    621  H   ASP A  41      22.395   4.066  18.213  1.00  0.00           H  
ATOM    622  HA  ASP A  41      21.342   2.328  20.044  1.00  0.00           H  
ATOM    623  HB2 ASP A  41      19.764   3.448  17.723  1.00  0.00           H  
ATOM    624  HB3 ASP A  41      19.158   3.018  19.320  1.00  0.00           H  
ATOM    625  N   HIS A  42      20.864   1.171  16.981  1.00  0.00           N  
ATOM    626  CA  HIS A  42      20.629  -0.045  16.211  1.00  0.00           C  
ATOM    627  C   HIS A  42      21.616  -0.155  15.054  1.00  0.00           C  
ATOM    628  O   HIS A  42      21.299  -0.719  14.007  1.00  0.00           O  
ATOM    629  CB  HIS A  42      19.196  -0.068  15.679  1.00  0.00           C  
ATOM    630  CG  HIS A  42      18.216   0.635  16.568  1.00  0.00           C  
ATOM    631  ND1 HIS A  42      17.388  -0.028  17.448  1.00  0.00           N  
ATOM    632  CD2 HIS A  42      17.934   1.951  16.708  1.00  0.00           C  
ATOM    633  CE1 HIS A  42      16.638   0.849  18.091  1.00  0.00           C  
ATOM    634  NE2 HIS A  42      16.951   2.058  17.661  1.00  0.00           N  
ATOM    635  H   HIS A  42      20.953   2.026  16.509  1.00  0.00           H  
ATOM    636  HA  HIS A  42      20.772  -0.888  16.871  1.00  0.00           H  
ATOM    637  HB2 HIS A  42      19.170   0.412  14.713  1.00  0.00           H  
ATOM    638  HB3 HIS A  42      18.874  -1.094  15.575  1.00  0.00           H  
ATOM    639  HD1 HIS A  42      17.353  -0.999  17.580  1.00  0.00           H  
ATOM    640  HD2 HIS A  42      18.397   2.768  16.170  1.00  0.00           H  
ATOM    641  HE1 HIS A  42      15.897   0.618  18.841  1.00  0.00           H  
ATOM    642  HE2 HIS A  42      16.486   2.883  17.910  1.00  0.00           H  
ATOM    643  N   ARG A  43      22.812   0.390  15.248  1.00  0.00           N  
ATOM    644  CA  ARG A  43      23.845   0.355  14.219  1.00  0.00           C  
ATOM    645  C   ARG A  43      25.235   0.284  14.846  1.00  0.00           C  
ATOM    646  O   ARG A  43      25.386   0.400  16.062  1.00  0.00           O  
ATOM    647  CB  ARG A  43      23.741   1.589  13.320  1.00  0.00           C  
ATOM    648  CG  ARG A  43      22.329   1.869  12.831  1.00  0.00           C  
ATOM    649  CD  ARG A  43      22.335   2.723  11.574  1.00  0.00           C  
ATOM    650  NE  ARG A  43      22.388   1.912  10.361  1.00  0.00           N  
ATOM    651  CZ  ARG A  43      22.595   2.414   9.148  1.00  0.00           C  
ATOM    652  NH1 ARG A  43      22.768   3.718   8.989  1.00  0.00           N  
ATOM    653  NH2 ARG A  43      22.630   1.610   8.093  1.00  0.00           N  
ATOM    654  H   ARG A  43      23.006   0.826  16.104  1.00  0.00           H  
ATOM    655  HA  ARG A  43      23.688  -0.530  13.622  1.00  0.00           H  
ATOM    656  HB2 ARG A  43      24.085   2.451  13.872  1.00  0.00           H  
ATOM    657  HB3 ARG A  43      24.376   1.446  12.459  1.00  0.00           H  
ATOM    658  HG2 ARG A  43      21.841   0.930  12.613  1.00  0.00           H  
ATOM    659  HG3 ARG A  43      21.786   2.388  13.607  1.00  0.00           H  
ATOM    660  HD2 ARG A  43      21.435   3.320  11.556  1.00  0.00           H  
ATOM    661  HD3 ARG A  43      23.198   3.372  11.599  1.00  0.00           H  
ATOM    662  HE  ARG A  43      22.263   0.944  10.456  1.00  0.00           H  
ATOM    663 HH11 ARG A  43      22.744   4.327   9.782  1.00  0.00           H  
ATOM    664 HH12 ARG A  43      22.925   4.094   8.075  1.00  0.00           H  
ATOM    665 HH21 ARG A  43      22.501   0.627   8.209  1.00  0.00           H  
ATOM    666 HH22 ARG A  43      22.786   1.989   7.181  1.00  0.00           H  
ATOM    667  N   VAL A  44      26.248   0.093  14.006  1.00  0.00           N  
ATOM    668  CA  VAL A  44      27.625   0.008  14.477  1.00  0.00           C  
ATOM    669  C   VAL A  44      28.607   0.384  13.374  1.00  0.00           C  
ATOM    670  O   VAL A  44      28.617  -0.224  12.303  1.00  0.00           O  
ATOM    671  CB  VAL A  44      27.957  -1.408  14.985  1.00  0.00           C  
ATOM    672  CG1 VAL A  44      27.075  -1.771  16.169  1.00  0.00           C  
ATOM    673  CG2 VAL A  44      27.805  -2.425  13.864  1.00  0.00           C  
ATOM    674  H   VAL A  44      26.064   0.009  13.047  1.00  0.00           H  
ATOM    675  HA  VAL A  44      27.741   0.699  15.299  1.00  0.00           H  
ATOM    676  HB  VAL A  44      28.986  -1.418  15.314  1.00  0.00           H  
ATOM    677 HG11 VAL A  44      26.039  -1.742  15.868  1.00  0.00           H  
ATOM    678 HG12 VAL A  44      27.323  -2.764  16.513  1.00  0.00           H  
ATOM    679 HG13 VAL A  44      27.236  -1.063  16.969  1.00  0.00           H  
ATOM    680 HG21 VAL A  44      28.780  -2.781  13.568  1.00  0.00           H  
ATOM    681 HG22 VAL A  44      27.208  -3.257  14.211  1.00  0.00           H  
ATOM    682 HG23 VAL A  44      27.318  -1.960  13.020  1.00  0.00           H  
ATOM    683  N   LYS A  45      29.432   1.390  13.641  1.00  0.00           N  
ATOM    684  CA  LYS A  45      30.421   1.848  12.673  1.00  0.00           C  
ATOM    685  C   LYS A  45      31.530   0.816  12.498  1.00  0.00           C  
ATOM    686  O   LYS A  45      32.419   0.696  13.342  1.00  0.00           O  
ATOM    687  CB  LYS A  45      31.019   3.185  13.116  1.00  0.00           C  
ATOM    688  CG  LYS A  45      31.766   3.913  12.012  1.00  0.00           C  
ATOM    689  CD  LYS A  45      32.081   5.347  12.404  1.00  0.00           C  
ATOM    690  CE  LYS A  45      32.599   6.148  11.218  1.00  0.00           C  
ATOM    691  NZ  LYS A  45      33.480   7.268  11.648  1.00  0.00           N  
ATOM    692  H   LYS A  45      29.375   1.835  14.513  1.00  0.00           H  
ATOM    693  HA  LYS A  45      29.921   1.983  11.726  1.00  0.00           H  
ATOM    694  HB2 LYS A  45      30.221   3.824  13.464  1.00  0.00           H  
ATOM    695  HB3 LYS A  45      31.707   3.006  13.930  1.00  0.00           H  
ATOM    696  HG2 LYS A  45      32.693   3.393  11.813  1.00  0.00           H  
ATOM    697  HG3 LYS A  45      31.155   3.919  11.120  1.00  0.00           H  
ATOM    698  HD2 LYS A  45      31.182   5.815  12.775  1.00  0.00           H  
ATOM    699  HD3 LYS A  45      32.834   5.342  13.179  1.00  0.00           H  
ATOM    700  HE2 LYS A  45      33.158   5.489  10.572  1.00  0.00           H  
ATOM    701  HE3 LYS A  45      31.756   6.551  10.678  1.00  0.00           H  
ATOM    702  HZ1 LYS A  45      34.415   6.903  11.922  1.00  0.00           H  
ATOM    703  HZ2 LYS A  45      33.062   7.760  12.464  1.00  0.00           H  
ATOM    704  HZ3 LYS A  45      33.600   7.949  10.871  1.00  0.00           H  
ATOM    705  N   VAL A  46      31.474   0.073  11.397  1.00  0.00           N  
ATOM    706  CA  VAL A  46      32.475  -0.948  11.112  1.00  0.00           C  
ATOM    707  C   VAL A  46      33.669  -0.354  10.372  1.00  0.00           C  
ATOM    708  O   VAL A  46      33.538   0.130   9.247  1.00  0.00           O  
ATOM    709  CB  VAL A  46      31.884  -2.096  10.272  1.00  0.00           C  
ATOM    710  CG1 VAL A  46      31.040  -3.014  11.143  1.00  0.00           C  
ATOM    711  CG2 VAL A  46      31.065  -1.542   9.116  1.00  0.00           C  
ATOM    712  H   VAL A  46      30.742   0.214  10.762  1.00  0.00           H  
ATOM    713  HA  VAL A  46      32.815  -1.356  12.054  1.00  0.00           H  
ATOM    714  HB  VAL A  46      32.700  -2.674   9.864  1.00  0.00           H  
ATOM    715 HG11 VAL A  46      31.360  -2.929  12.171  1.00  0.00           H  
ATOM    716 HG12 VAL A  46      30.000  -2.731  11.063  1.00  0.00           H  
ATOM    717 HG13 VAL A  46      31.161  -4.035  10.812  1.00  0.00           H  
ATOM    718 HG21 VAL A  46      31.223  -0.477   9.042  1.00  0.00           H  
ATOM    719 HG22 VAL A  46      31.375  -2.016   8.196  1.00  0.00           H  
ATOM    720 HG23 VAL A  46      30.018  -1.741   9.289  1.00  0.00           H  
ATOM    721  N   HIS A  47      34.834  -0.396  11.009  1.00  0.00           N  
ATOM    722  CA  HIS A  47      36.053   0.137  10.411  1.00  0.00           C  
ATOM    723  C   HIS A  47      36.951  -0.991   9.910  1.00  0.00           C  
ATOM    724  O   HIS A  47      37.366  -1.857  10.681  1.00  0.00           O  
ATOM    725  CB  HIS A  47      36.810   0.995  11.424  1.00  0.00           C  
ATOM    726  CG  HIS A  47      38.274   1.117  11.130  1.00  0.00           C  
ATOM    727  ND1 HIS A  47      38.839   2.246  10.573  1.00  0.00           N  
ATOM    728  CD2 HIS A  47      39.292   0.244  11.320  1.00  0.00           C  
ATOM    729  CE1 HIS A  47      40.139   2.061  10.432  1.00  0.00           C  
ATOM    730  NE2 HIS A  47      40.440   0.855  10.879  1.00  0.00           N  
ATOM    731  H   HIS A  47      34.876  -0.795  11.903  1.00  0.00           H  
ATOM    732  HA  HIS A  47      35.769   0.753   9.572  1.00  0.00           H  
ATOM    733  HB2 HIS A  47      36.390   1.990  11.429  1.00  0.00           H  
ATOM    734  HB3 HIS A  47      36.704   0.560  12.406  1.00  0.00           H  
ATOM    735  HD1 HIS A  47      38.358   3.060  10.318  1.00  0.00           H  
ATOM    736  HD2 HIS A  47      39.215  -0.748  11.741  1.00  0.00           H  
ATOM    737  HE1 HIS A  47      40.839   2.774  10.022  1.00  0.00           H  
ATOM    738  HE2 HIS A  47      41.321   0.431  10.811  1.00  0.00           H  
ATOM    739  N   PHE A  48      37.246  -0.974   8.615  1.00  0.00           N  
ATOM    740  CA  PHE A  48      38.093  -1.997   8.010  1.00  0.00           C  
ATOM    741  C   PHE A  48      39.566  -1.716   8.288  1.00  0.00           C  
ATOM    742  O   PHE A  48      40.155  -0.801   7.711  1.00  0.00           O  
ATOM    743  CB  PHE A  48      37.850  -2.063   6.501  1.00  0.00           C  
ATOM    744  CG  PHE A  48      36.551  -2.719   6.131  1.00  0.00           C  
ATOM    745  CD1 PHE A  48      35.359  -2.295   6.698  1.00  0.00           C  
ATOM    746  CD2 PHE A  48      36.520  -3.759   5.216  1.00  0.00           C  
ATOM    747  CE1 PHE A  48      34.162  -2.896   6.360  1.00  0.00           C  
ATOM    748  CE2 PHE A  48      35.326  -4.364   4.874  1.00  0.00           C  
ATOM    749  CZ  PHE A  48      34.145  -3.933   5.447  1.00  0.00           C  
ATOM    750  H   PHE A  48      36.885  -0.258   8.051  1.00  0.00           H  
ATOM    751  HA  PHE A  48      37.830  -2.946   8.450  1.00  0.00           H  
ATOM    752  HB2 PHE A  48      37.842  -1.061   6.101  1.00  0.00           H  
ATOM    753  HB3 PHE A  48      38.649  -2.623   6.039  1.00  0.00           H  
ATOM    754  HD1 PHE A  48      35.371  -1.485   7.413  1.00  0.00           H  
ATOM    755  HD2 PHE A  48      37.443  -4.098   4.768  1.00  0.00           H  
ATOM    756  HE1 PHE A  48      33.241  -2.557   6.810  1.00  0.00           H  
ATOM    757  HE2 PHE A  48      35.316  -5.175   4.160  1.00  0.00           H  
ATOM    758  HZ  PHE A  48      33.210  -4.404   5.180  1.00  0.00           H  
ATOM    759  N   ASP A  49      40.157  -2.509   9.175  1.00  0.00           N  
ATOM    760  CA  ASP A  49      41.561  -2.348   9.531  1.00  0.00           C  
ATOM    761  C   ASP A  49      42.398  -2.007   8.301  1.00  0.00           C  
ATOM    762  O   ASP A  49      42.493  -2.798   7.364  1.00  0.00           O  
ATOM    763  CB  ASP A  49      42.094  -3.622  10.187  1.00  0.00           C  
ATOM    764  CG  ASP A  49      43.555  -3.508  10.571  1.00  0.00           C  
ATOM    765  OD1 ASP A  49      43.924  -2.501  11.213  1.00  0.00           O  
ATOM    766  OD2 ASP A  49      44.332  -4.426  10.233  1.00  0.00           O  
ATOM    767  H   ASP A  49      39.634  -3.221   9.602  1.00  0.00           H  
ATOM    768  HA  ASP A  49      41.634  -1.534  10.236  1.00  0.00           H  
ATOM    769  HB2 ASP A  49      41.521  -3.826  11.079  1.00  0.00           H  
ATOM    770  HB3 ASP A  49      41.984  -4.446   9.497  1.00  0.00           H  
ATOM    771  N   GLY A  50      43.000  -0.821   8.310  1.00  0.00           N  
ATOM    772  CA  GLY A  50      43.818  -0.396   7.189  1.00  0.00           C  
ATOM    773  C   GLY A  50      43.082   0.548   6.260  1.00  0.00           C  
ATOM    774  O   GLY A  50      43.450   1.717   6.132  1.00  0.00           O  
ATOM    775  H   GLY A  50      42.887  -0.231   9.085  1.00  0.00           H  
ATOM    776  HA2 GLY A  50      44.698   0.102   7.569  1.00  0.00           H  
ATOM    777  HA3 GLY A  50      44.123  -1.268   6.631  1.00  0.00           H  
ATOM    778  N   TRP A  51      42.042   0.043   5.608  1.00  0.00           N  
ATOM    779  CA  TRP A  51      41.254   0.849   4.683  1.00  0.00           C  
ATOM    780  C   TRP A  51      41.013   2.245   5.247  1.00  0.00           C  
ATOM    781  O   TRP A  51      40.508   2.396   6.359  1.00  0.00           O  
ATOM    782  CB  TRP A  51      39.917   0.165   4.390  1.00  0.00           C  
ATOM    783  CG  TRP A  51      40.058  -1.117   3.628  1.00  0.00           C  
ATOM    784  CD1 TRP A  51      40.547  -2.301   4.100  1.00  0.00           C  
ATOM    785  CD2 TRP A  51      39.711  -1.342   2.258  1.00  0.00           C  
ATOM    786  NE1 TRP A  51      40.523  -3.249   3.105  1.00  0.00           N  
ATOM    787  CE2 TRP A  51      40.015  -2.686   1.966  1.00  0.00           C  
ATOM    788  CE3 TRP A  51      39.171  -0.539   1.249  1.00  0.00           C  
ATOM    789  CZ2 TRP A  51      39.796  -3.241   0.709  1.00  0.00           C  
ATOM    790  CZ3 TRP A  51      38.955  -1.092   0.001  1.00  0.00           C  
ATOM    791  CH2 TRP A  51      39.267  -2.434  -0.261  1.00  0.00           C  
ATOM    792  H   TRP A  51      41.797  -0.896   5.752  1.00  0.00           H  
ATOM    793  HA  TRP A  51      41.811   0.937   3.762  1.00  0.00           H  
ATOM    794  HB2 TRP A  51      39.420  -0.055   5.323  1.00  0.00           H  
ATOM    795  HB3 TRP A  51      39.300   0.835   3.808  1.00  0.00           H  
ATOM    796  HD1 TRP A  51      40.898  -2.455   5.109  1.00  0.00           H  
ATOM    797  HE1 TRP A  51      40.822  -4.178   3.199  1.00  0.00           H  
ATOM    798  HE3 TRP A  51      38.924   0.496   1.431  1.00  0.00           H  
ATOM    799  HZ2 TRP A  51      40.031  -4.274   0.491  1.00  0.00           H  
ATOM    800  HZ3 TRP A  51      38.539  -0.487  -0.791  1.00  0.00           H  
ATOM    801  HH2 TRP A  51      39.081  -2.824  -1.249  1.00  0.00           H  
ATOM    802  N   ASN A  52      41.377   3.262   4.473  1.00  0.00           N  
ATOM    803  CA  ASN A  52      41.200   4.646   4.897  1.00  0.00           C  
ATOM    804  C   ASN A  52      39.889   4.819   5.659  1.00  0.00           C  
ATOM    805  O   ASN A  52      38.823   4.448   5.170  1.00  0.00           O  
ATOM    806  CB  ASN A  52      41.226   5.580   3.686  1.00  0.00           C  
ATOM    807  CG  ASN A  52      41.345   7.039   4.083  1.00  0.00           C  
ATOM    808  OD1 ASN A  52      40.507   7.864   3.716  1.00  0.00           O  
ATOM    809  ND2 ASN A  52      42.390   7.364   4.834  1.00  0.00           N  
ATOM    810  H   ASN A  52      41.775   3.078   3.596  1.00  0.00           H  
ATOM    811  HA  ASN A  52      42.020   4.899   5.553  1.00  0.00           H  
ATOM    812  HB2 ASN A  52      42.071   5.327   3.062  1.00  0.00           H  
ATOM    813  HB3 ASN A  52      40.316   5.452   3.120  1.00  0.00           H  
ATOM    814 HD21 ASN A  52      43.017   6.654   5.088  1.00  0.00           H  
ATOM    815 HD22 ASN A  52      42.490   8.301   5.106  1.00  0.00           H  
ATOM    816  N   ASN A  53      39.977   5.386   6.857  1.00  0.00           N  
ATOM    817  CA  ASN A  53      38.798   5.608   7.686  1.00  0.00           C  
ATOM    818  C   ASN A  53      37.596   5.989   6.830  1.00  0.00           C  
ATOM    819  O   ASN A  53      36.499   5.459   7.010  1.00  0.00           O  
ATOM    820  CB  ASN A  53      39.073   6.705   8.717  1.00  0.00           C  
ATOM    821  CG  ASN A  53      40.013   6.245   9.815  1.00  0.00           C  
ATOM    822  OD1 ASN A  53      40.787   5.306   9.631  1.00  0.00           O  
ATOM    823  ND2 ASN A  53      39.947   6.906  10.964  1.00  0.00           N  
ATOM    824  H   ASN A  53      40.856   5.660   7.193  1.00  0.00           H  
ATOM    825  HA  ASN A  53      38.580   4.686   8.205  1.00  0.00           H  
ATOM    826  HB2 ASN A  53      39.520   7.554   8.219  1.00  0.00           H  
ATOM    827  HB3 ASN A  53      38.141   7.008   9.169  1.00  0.00           H  
ATOM    828 HD21 ASN A  53      39.305   7.643  11.039  1.00  0.00           H  
ATOM    829 HD22 ASN A  53      40.543   6.630  11.691  1.00  0.00           H  
ATOM    830  N   CYS A  54      37.808   6.911   5.897  1.00  0.00           N  
ATOM    831  CA  CYS A  54      36.742   7.364   5.011  1.00  0.00           C  
ATOM    832  C   CYS A  54      35.822   6.207   4.633  1.00  0.00           C  
ATOM    833  O   CYS A  54      34.598   6.334   4.678  1.00  0.00           O  
ATOM    834  CB  CYS A  54      37.330   7.997   3.751  1.00  0.00           C  
ATOM    835  SG  CYS A  54      36.099   8.456   2.510  1.00  0.00           S  
ATOM    836  H   CYS A  54      38.704   7.296   5.802  1.00  0.00           H  
ATOM    837  HA  CYS A  54      36.165   8.107   5.542  1.00  0.00           H  
ATOM    838  HB2 CYS A  54      37.868   8.893   4.025  1.00  0.00           H  
ATOM    839  HB3 CYS A  54      38.017   7.300   3.293  1.00  0.00           H  
ATOM    840  HG  CYS A  54      34.899   8.319   3.054  1.00  0.00           H  
ATOM    841  N   TYR A  55      36.420   5.083   4.257  1.00  0.00           N  
ATOM    842  CA  TYR A  55      35.655   3.905   3.865  1.00  0.00           C  
ATOM    843  C   TYR A  55      34.616   3.552   4.925  1.00  0.00           C  
ATOM    844  O   TYR A  55      33.461   3.268   4.607  1.00  0.00           O  
ATOM    845  CB  TYR A  55      36.590   2.716   3.635  1.00  0.00           C  
ATOM    846  CG  TYR A  55      37.130   2.633   2.226  1.00  0.00           C  
ATOM    847  CD1 TYR A  55      36.361   2.101   1.198  1.00  0.00           C  
ATOM    848  CD2 TYR A  55      38.408   3.085   1.922  1.00  0.00           C  
ATOM    849  CE1 TYR A  55      36.850   2.022  -0.092  1.00  0.00           C  
ATOM    850  CE2 TYR A  55      38.904   3.011   0.634  1.00  0.00           C  
ATOM    851  CZ  TYR A  55      38.123   2.478  -0.369  1.00  0.00           C  
ATOM    852  OH  TYR A  55      38.613   2.402  -1.652  1.00  0.00           O  
ATOM    853  H   TYR A  55      37.399   5.043   4.240  1.00  0.00           H  
ATOM    854  HA  TYR A  55      35.146   4.132   2.939  1.00  0.00           H  
ATOM    855  HB2 TYR A  55      37.432   2.794   4.308  1.00  0.00           H  
ATOM    856  HB3 TYR A  55      36.055   1.801   3.841  1.00  0.00           H  
ATOM    857  HD1 TYR A  55      35.365   1.745   1.417  1.00  0.00           H  
ATOM    858  HD2 TYR A  55      39.019   3.500   2.711  1.00  0.00           H  
ATOM    859  HE1 TYR A  55      36.238   1.605  -0.878  1.00  0.00           H  
ATOM    860  HE2 TYR A  55      39.901   3.369   0.418  1.00  0.00           H  
ATOM    861  HH  TYR A  55      39.337   3.026  -1.755  1.00  0.00           H  
ATOM    862  N   ASP A  56      35.036   3.573   6.185  1.00  0.00           N  
ATOM    863  CA  ASP A  56      34.144   3.257   7.294  1.00  0.00           C  
ATOM    864  C   ASP A  56      32.732   3.766   7.018  1.00  0.00           C  
ATOM    865  O   ASP A  56      32.550   4.821   6.407  1.00  0.00           O  
ATOM    866  CB  ASP A  56      34.674   3.867   8.593  1.00  0.00           C  
ATOM    867  CG  ASP A  56      36.130   3.525   8.840  1.00  0.00           C  
ATOM    868  OD1 ASP A  56      36.625   2.556   8.227  1.00  0.00           O  
ATOM    869  OD2 ASP A  56      36.775   4.228   9.645  1.00  0.00           O  
ATOM    870  H   ASP A  56      35.970   3.806   6.374  1.00  0.00           H  
ATOM    871  HA  ASP A  56      34.112   2.183   7.398  1.00  0.00           H  
ATOM    872  HB2 ASP A  56      34.579   4.942   8.543  1.00  0.00           H  
ATOM    873  HB3 ASP A  56      34.090   3.495   9.422  1.00  0.00           H  
ATOM    874  N   TYR A  57      31.738   3.012   7.469  1.00  0.00           N  
ATOM    875  CA  TYR A  57      30.342   3.385   7.268  1.00  0.00           C  
ATOM    876  C   TYR A  57      29.463   2.832   8.386  1.00  0.00           C  
ATOM    877  O   TYR A  57      29.815   1.848   9.037  1.00  0.00           O  
ATOM    878  CB  TYR A  57      29.847   2.874   5.914  1.00  0.00           C  
ATOM    879  CG  TYR A  57      30.255   1.449   5.617  1.00  0.00           C  
ATOM    880  CD1 TYR A  57      29.681   0.384   6.303  1.00  0.00           C  
ATOM    881  CD2 TYR A  57      31.213   1.166   4.652  1.00  0.00           C  
ATOM    882  CE1 TYR A  57      30.052  -0.920   6.036  1.00  0.00           C  
ATOM    883  CE2 TYR A  57      31.589  -0.135   4.378  1.00  0.00           C  
ATOM    884  CZ  TYR A  57      31.005  -1.174   5.073  1.00  0.00           C  
ATOM    885  OH  TYR A  57      31.376  -2.472   4.803  1.00  0.00           O  
ATOM    886  H   TYR A  57      31.945   2.183   7.949  1.00  0.00           H  
ATOM    887  HA  TYR A  57      30.283   4.463   7.278  1.00  0.00           H  
ATOM    888  HB2 TYR A  57      28.769   2.921   5.891  1.00  0.00           H  
ATOM    889  HB3 TYR A  57      30.246   3.503   5.132  1.00  0.00           H  
ATOM    890  HD1 TYR A  57      28.935   0.588   7.056  1.00  0.00           H  
ATOM    891  HD2 TYR A  57      31.668   1.982   4.109  1.00  0.00           H  
ATOM    892  HE1 TYR A  57      29.595  -1.733   6.580  1.00  0.00           H  
ATOM    893  HE2 TYR A  57      32.335  -0.335   3.624  1.00  0.00           H  
ATOM    894  HH  TYR A  57      31.667  -2.896   5.614  1.00  0.00           H  
ATOM    895  N   TRP A  58      28.319   3.470   8.599  1.00  0.00           N  
ATOM    896  CA  TRP A  58      27.388   3.043   9.638  1.00  0.00           C  
ATOM    897  C   TRP A  58      26.520   1.889   9.148  1.00  0.00           C  
ATOM    898  O   TRP A  58      25.598   2.088   8.356  1.00  0.00           O  
ATOM    899  CB  TRP A  58      26.505   4.213  10.073  1.00  0.00           C  
ATOM    900  CG  TRP A  58      27.138   5.077  11.122  1.00  0.00           C  
ATOM    901  CD1 TRP A  58      27.623   6.342  10.957  1.00  0.00           C  
ATOM    902  CD2 TRP A  58      27.356   4.736  12.495  1.00  0.00           C  
ATOM    903  NE1 TRP A  58      28.129   6.811  12.146  1.00  0.00           N  
ATOM    904  CE2 TRP A  58      27.976   5.845  13.106  1.00  0.00           C  
ATOM    905  CE3 TRP A  58      27.084   3.605  13.270  1.00  0.00           C  
ATOM    906  CZ2 TRP A  58      28.330   5.850  14.453  1.00  0.00           C  
ATOM    907  CZ3 TRP A  58      27.436   3.613  14.606  1.00  0.00           C  
ATOM    908  CH2 TRP A  58      28.053   4.729  15.187  1.00  0.00           C  
ATOM    909  H   TRP A  58      28.094   4.248   8.047  1.00  0.00           H  
ATOM    910  HA  TRP A  58      27.968   2.707  10.484  1.00  0.00           H  
ATOM    911  HB2 TRP A  58      26.291   4.834   9.215  1.00  0.00           H  
ATOM    912  HB3 TRP A  58      25.579   3.826  10.473  1.00  0.00           H  
ATOM    913  HD1 TRP A  58      27.607   6.884  10.024  1.00  0.00           H  
ATOM    914  HE1 TRP A  58      28.532   7.692  12.285  1.00  0.00           H  
ATOM    915  HE3 TRP A  58      26.610   2.735  12.840  1.00  0.00           H  
ATOM    916  HZ2 TRP A  58      28.805   6.703  14.914  1.00  0.00           H  
ATOM    917  HZ3 TRP A  58      27.234   2.747  15.220  1.00  0.00           H  
ATOM    918  HH2 TRP A  58      28.310   4.690  16.234  1.00  0.00           H  
ATOM    919  N   ILE A  59      26.819   0.685   9.624  1.00  0.00           N  
ATOM    920  CA  ILE A  59      26.064  -0.499   9.235  1.00  0.00           C  
ATOM    921  C   ILE A  59      25.206  -1.007  10.389  1.00  0.00           C  
ATOM    922  O   ILE A  59      25.616  -0.961  11.549  1.00  0.00           O  
ATOM    923  CB  ILE A  59      26.996  -1.632   8.766  1.00  0.00           C  
ATOM    924  CG1 ILE A  59      26.209  -2.671   7.965  1.00  0.00           C  
ATOM    925  CG2 ILE A  59      27.680  -2.283   9.958  1.00  0.00           C  
ATOM    926  CD1 ILE A  59      27.085  -3.589   7.142  1.00  0.00           C  
ATOM    927  H   ILE A  59      27.565   0.592  10.252  1.00  0.00           H  
ATOM    928  HA  ILE A  59      25.418  -0.228   8.413  1.00  0.00           H  
ATOM    929  HB  ILE A  59      27.758  -1.203   8.134  1.00  0.00           H  
ATOM    930 HG12 ILE A  59      25.635  -3.281   8.644  1.00  0.00           H  
ATOM    931 HG13 ILE A  59      25.537  -2.160   7.290  1.00  0.00           H  
ATOM    932 HG21 ILE A  59      28.245  -3.142   9.625  1.00  0.00           H  
ATOM    933 HG22 ILE A  59      28.347  -1.572  10.423  1.00  0.00           H  
ATOM    934 HG23 ILE A  59      26.935  -2.598  10.674  1.00  0.00           H  
ATOM    935 HD11 ILE A  59      26.704  -4.599   7.202  1.00  0.00           H  
ATOM    936 HD12 ILE A  59      27.083  -3.264   6.113  1.00  0.00           H  
ATOM    937 HD13 ILE A  59      28.094  -3.564   7.526  1.00  0.00           H  
ATOM    938  N   ASP A  60      24.013  -1.493  10.062  1.00  0.00           N  
ATOM    939  CA  ASP A  60      23.097  -2.013  11.071  1.00  0.00           C  
ATOM    940  C   ASP A  60      23.656  -3.279  11.711  1.00  0.00           C  
ATOM    941  O   ASP A  60      23.970  -4.249  11.022  1.00  0.00           O  
ATOM    942  CB  ASP A  60      21.730  -2.303  10.448  1.00  0.00           C  
ATOM    943  CG  ASP A  60      21.056  -1.049   9.924  1.00  0.00           C  
ATOM    944  OD1 ASP A  60      21.328  -0.669   8.766  1.00  0.00           O  
ATOM    945  OD2 ASP A  60      20.257  -0.449  10.673  1.00  0.00           O  
ATOM    946  H   ASP A  60      23.743  -1.503   9.120  1.00  0.00           H  
ATOM    947  HA  ASP A  60      22.981  -1.258  11.834  1.00  0.00           H  
ATOM    948  HB2 ASP A  60      21.855  -2.992   9.625  1.00  0.00           H  
ATOM    949  HB3 ASP A  60      21.090  -2.750  11.193  1.00  0.00           H  
ATOM    950  N   ALA A  61      23.779  -3.261  13.035  1.00  0.00           N  
ATOM    951  CA  ALA A  61      24.300  -4.408  13.769  1.00  0.00           C  
ATOM    952  C   ALA A  61      23.407  -5.630  13.583  1.00  0.00           C  
ATOM    953  O   ALA A  61      23.818  -6.759  13.852  1.00  0.00           O  
ATOM    954  CB  ALA A  61      24.437  -4.071  15.246  1.00  0.00           C  
ATOM    955  H   ALA A  61      23.512  -2.458  13.529  1.00  0.00           H  
ATOM    956  HA  ALA A  61      25.284  -4.633  13.383  1.00  0.00           H  
ATOM    957  HB1 ALA A  61      25.309  -4.567  15.648  1.00  0.00           H  
ATOM    958  HB2 ALA A  61      24.543  -3.003  15.363  1.00  0.00           H  
ATOM    959  HB3 ALA A  61      23.557  -4.406  15.775  1.00  0.00           H  
ATOM    960  N   ASP A  62      22.182  -5.398  13.124  1.00  0.00           N  
ATOM    961  CA  ASP A  62      21.230  -6.480  12.902  1.00  0.00           C  
ATOM    962  C   ASP A  62      21.167  -6.854  11.425  1.00  0.00           C  
ATOM    963  O   ASP A  62      20.338  -7.667  11.016  1.00  0.00           O  
ATOM    964  CB  ASP A  62      19.840  -6.075  13.399  1.00  0.00           C  
ATOM    965  CG  ASP A  62      19.799  -5.872  14.901  1.00  0.00           C  
ATOM    966  OD1 ASP A  62      19.908  -6.873  15.638  1.00  0.00           O  
ATOM    967  OD2 ASP A  62      19.657  -4.711  15.338  1.00  0.00           O  
ATOM    968  H   ASP A  62      21.912  -4.476  12.929  1.00  0.00           H  
ATOM    969  HA  ASP A  62      21.566  -7.338  13.465  1.00  0.00           H  
ATOM    970  HB2 ASP A  62      19.550  -5.151  12.921  1.00  0.00           H  
ATOM    971  HB3 ASP A  62      19.133  -6.849  13.138  1.00  0.00           H  
ATOM    972  N   SER A  63      22.047  -6.256  10.630  1.00  0.00           N  
ATOM    973  CA  SER A  63      22.089  -6.522   9.197  1.00  0.00           C  
ATOM    974  C   SER A  63      22.511  -7.963   8.925  1.00  0.00           C  
ATOM    975  O   SER A  63      23.371  -8.524   9.605  1.00  0.00           O  
ATOM    976  CB  SER A  63      23.053  -5.557   8.504  1.00  0.00           C  
ATOM    977  OG  SER A  63      22.860  -5.564   7.101  1.00  0.00           O  
ATOM    978  H   SER A  63      22.683  -5.616  11.017  1.00  0.00           H  
ATOM    979  HA  SER A  63      21.095  -6.370   8.803  1.00  0.00           H  
ATOM    980  HB2 SER A  63      22.883  -4.557   8.875  1.00  0.00           H  
ATOM    981  HB3 SER A  63      24.069  -5.852   8.718  1.00  0.00           H  
ATOM    982  HG  SER A  63      23.337  -6.303   6.716  1.00  0.00           H  
ATOM    983  N   PRO A  64      21.892  -8.578   7.906  1.00  0.00           N  
ATOM    984  CA  PRO A  64      22.186  -9.961   7.520  1.00  0.00           C  
ATOM    985  C   PRO A  64      23.569 -10.105   6.893  1.00  0.00           C  
ATOM    986  O   PRO A  64      24.143 -11.195   6.877  1.00  0.00           O  
ATOM    987  CB  PRO A  64      21.098 -10.280   6.491  1.00  0.00           C  
ATOM    988  CG  PRO A  64      20.707  -8.957   5.929  1.00  0.00           C  
ATOM    989  CD  PRO A  64      20.856  -7.970   7.053  1.00  0.00           C  
ATOM    990  HA  PRO A  64      22.099 -10.635   8.359  1.00  0.00           H  
ATOM    991  HB2 PRO A  64      21.501 -10.931   5.727  1.00  0.00           H  
ATOM    992  HB3 PRO A  64      20.266 -10.763   6.980  1.00  0.00           H  
ATOM    993  HG2 PRO A  64      21.362  -8.697   5.112  1.00  0.00           H  
ATOM    994  HG3 PRO A  64      19.681  -8.990   5.594  1.00  0.00           H  
ATOM    995  HD2 PRO A  64      21.182  -7.013   6.674  1.00  0.00           H  
ATOM    996  HD3 PRO A  64      19.926  -7.867   7.591  1.00  0.00           H  
ATOM    997  N   ASP A  65      24.100  -9.000   6.382  1.00  0.00           N  
ATOM    998  CA  ASP A  65      25.418  -9.005   5.757  1.00  0.00           C  
ATOM    999  C   ASP A  65      26.517  -9.127   6.806  1.00  0.00           C  
ATOM   1000  O   ASP A  65      27.549  -9.755   6.568  1.00  0.00           O  
ATOM   1001  CB  ASP A  65      25.620  -7.730   4.935  1.00  0.00           C  
ATOM   1002  CG  ASP A  65      24.336  -7.247   4.290  1.00  0.00           C  
ATOM   1003  OD1 ASP A  65      23.719  -8.030   3.537  1.00  0.00           O  
ATOM   1004  OD2 ASP A  65      23.947  -6.087   4.539  1.00  0.00           O  
ATOM   1005  H   ASP A  65      23.594  -8.162   6.426  1.00  0.00           H  
ATOM   1006  HA  ASP A  65      25.470  -9.859   5.098  1.00  0.00           H  
ATOM   1007  HB2 ASP A  65      25.992  -6.948   5.581  1.00  0.00           H  
ATOM   1008  HB3 ASP A  65      26.343  -7.923   4.156  1.00  0.00           H  
ATOM   1009  N   ILE A  66      26.289  -8.523   7.967  1.00  0.00           N  
ATOM   1010  CA  ILE A  66      27.261  -8.565   9.054  1.00  0.00           C  
ATOM   1011  C   ILE A  66      27.430  -9.984   9.585  1.00  0.00           C  
ATOM   1012  O   ILE A  66      26.455 -10.650   9.933  1.00  0.00           O  
ATOM   1013  CB  ILE A  66      26.847  -7.641  10.215  1.00  0.00           C  
ATOM   1014  CG1 ILE A  66      27.078  -6.176   9.836  1.00  0.00           C  
ATOM   1015  CG2 ILE A  66      27.620  -7.996  11.476  1.00  0.00           C  
ATOM   1016  CD1 ILE A  66      26.724  -5.204  10.940  1.00  0.00           C  
ATOM   1017  H   ILE A  66      25.448  -8.038   8.097  1.00  0.00           H  
ATOM   1018  HA  ILE A  66      28.208  -8.221   8.666  1.00  0.00           H  
ATOM   1019  HB  ILE A  66      25.796  -7.794  10.410  1.00  0.00           H  
ATOM   1020 HG12 ILE A  66      28.119  -6.034   9.593  1.00  0.00           H  
ATOM   1021 HG13 ILE A  66      26.473  -5.936   8.975  1.00  0.00           H  
ATOM   1022 HG21 ILE A  66      27.672  -7.132  12.122  1.00  0.00           H  
ATOM   1023 HG22 ILE A  66      27.116  -8.800  11.991  1.00  0.00           H  
ATOM   1024 HG23 ILE A  66      28.619  -8.308  11.210  1.00  0.00           H  
ATOM   1025 HD11 ILE A  66      26.178  -5.722  11.715  1.00  0.00           H  
ATOM   1026 HD12 ILE A  66      27.628  -4.783  11.354  1.00  0.00           H  
ATOM   1027 HD13 ILE A  66      26.109  -4.412  10.538  1.00  0.00           H  
ATOM   1028  N   HIS A  67      28.677 -10.442   9.645  1.00  0.00           N  
ATOM   1029  CA  HIS A  67      28.976 -11.782  10.137  1.00  0.00           C  
ATOM   1030  C   HIS A  67      30.057 -11.738  11.212  1.00  0.00           C  
ATOM   1031  O   HIS A  67      30.999 -10.948  11.149  1.00  0.00           O  
ATOM   1032  CB  HIS A  67      29.423 -12.683   8.984  1.00  0.00           C  
ATOM   1033  CG  HIS A  67      28.393 -12.834   7.908  1.00  0.00           C  
ATOM   1034  ND1 HIS A  67      27.205 -13.511   8.092  1.00  0.00           N  
ATOM   1035  CD2 HIS A  67      28.376 -12.390   6.630  1.00  0.00           C  
ATOM   1036  CE1 HIS A  67      26.504 -13.478   6.974  1.00  0.00           C  
ATOM   1037  NE2 HIS A  67      27.192 -12.803   6.071  1.00  0.00           N  
ATOM   1038  H   HIS A  67      29.413  -9.865   9.354  1.00  0.00           H  
ATOM   1039  HA  HIS A  67      28.073 -12.187  10.568  1.00  0.00           H  
ATOM   1040  HB2 HIS A  67      30.313 -12.266   8.535  1.00  0.00           H  
ATOM   1041  HB3 HIS A  67      29.648 -13.667   9.371  1.00  0.00           H  
ATOM   1042  HD1 HIS A  67      26.921 -13.952   8.920  1.00  0.00           H  
ATOM   1043  HD2 HIS A  67      29.151 -11.817   6.139  1.00  0.00           H  
ATOM   1044  HE1 HIS A  67      25.534 -13.926   6.823  1.00  0.00           H  
ATOM   1045  HE2 HIS A  67      26.940 -12.703   5.129  1.00  0.00           H  
ATOM   1046  N   PRO A  68      29.921 -12.607  12.225  1.00  0.00           N  
ATOM   1047  CA  PRO A  68      30.876 -12.685  13.335  1.00  0.00           C  
ATOM   1048  C   PRO A  68      32.223 -13.254  12.900  1.00  0.00           C  
ATOM   1049  O   PRO A  68      32.335 -13.871  11.841  1.00  0.00           O  
ATOM   1050  CB  PRO A  68      30.191 -13.631  14.325  1.00  0.00           C  
ATOM   1051  CG  PRO A  68      29.286 -14.466  13.488  1.00  0.00           C  
ATOM   1052  CD  PRO A  68      28.823 -13.578  12.366  1.00  0.00           C  
ATOM   1053  HA  PRO A  68      31.026 -11.722  13.798  1.00  0.00           H  
ATOM   1054  HB2 PRO A  68      30.937 -14.234  14.825  1.00  0.00           H  
ATOM   1055  HB3 PRO A  68      29.639 -13.056  15.053  1.00  0.00           H  
ATOM   1056  HG2 PRO A  68      29.826 -15.315  13.097  1.00  0.00           H  
ATOM   1057  HG3 PRO A  68      28.442 -14.795  14.077  1.00  0.00           H  
ATOM   1058  HD2 PRO A  68      28.697 -14.151  11.459  1.00  0.00           H  
ATOM   1059  HD3 PRO A  68      27.901 -13.082  12.633  1.00  0.00           H  
ATOM   1060  N   VAL A  69      33.243 -13.042  13.725  1.00  0.00           N  
ATOM   1061  CA  VAL A  69      34.583 -13.535  13.426  1.00  0.00           C  
ATOM   1062  C   VAL A  69      34.607 -15.058  13.361  1.00  0.00           C  
ATOM   1063  O   VAL A  69      34.580 -15.734  14.389  1.00  0.00           O  
ATOM   1064  CB  VAL A  69      35.602 -13.061  14.479  1.00  0.00           C  
ATOM   1065  CG1 VAL A  69      36.873 -13.893  14.403  1.00  0.00           C  
ATOM   1066  CG2 VAL A  69      35.911 -11.583  14.293  1.00  0.00           C  
ATOM   1067  H   VAL A  69      33.091 -12.544  14.554  1.00  0.00           H  
ATOM   1068  HA  VAL A  69      34.878 -13.138  12.465  1.00  0.00           H  
ATOM   1069  HB  VAL A  69      35.167 -13.196  15.458  1.00  0.00           H  
ATOM   1070 HG11 VAL A  69      37.733 -13.240  14.429  1.00  0.00           H  
ATOM   1071 HG12 VAL A  69      36.911 -14.572  15.244  1.00  0.00           H  
ATOM   1072 HG13 VAL A  69      36.879 -14.459  13.483  1.00  0.00           H  
ATOM   1073 HG21 VAL A  69      35.078 -10.995  14.646  1.00  0.00           H  
ATOM   1074 HG22 VAL A  69      36.798 -11.327  14.856  1.00  0.00           H  
ATOM   1075 HG23 VAL A  69      36.079 -11.379  13.246  1.00  0.00           H  
ATOM   1076  N   GLY A  70      34.657 -15.592  12.145  1.00  0.00           N  
ATOM   1077  CA  GLY A  70      34.684 -17.033  11.968  1.00  0.00           C  
ATOM   1078  C   GLY A  70      33.569 -17.526  11.067  1.00  0.00           C  
ATOM   1079  O   GLY A  70      33.371 -18.733  10.919  1.00  0.00           O  
ATOM   1080  H   GLY A  70      34.677 -15.004  11.362  1.00  0.00           H  
ATOM   1081  HA2 GLY A  70      35.633 -17.313  11.535  1.00  0.00           H  
ATOM   1082  HA3 GLY A  70      34.586 -17.504  12.934  1.00  0.00           H  
ATOM   1083  N   TRP A  71      32.838 -16.594  10.468  1.00  0.00           N  
ATOM   1084  CA  TRP A  71      31.735 -16.943   9.579  1.00  0.00           C  
ATOM   1085  C   TRP A  71      32.251 -17.598   8.302  1.00  0.00           C  
ATOM   1086  O   TRP A  71      31.479 -18.171   7.533  1.00  0.00           O  
ATOM   1087  CB  TRP A  71      30.920 -15.696   9.233  1.00  0.00           C  
ATOM   1088  CG  TRP A  71      30.062 -15.866   8.016  1.00  0.00           C  
ATOM   1089  CD1 TRP A  71      28.705 -16.024   7.983  1.00  0.00           C  
ATOM   1090  CD2 TRP A  71      30.503 -15.898   6.653  1.00  0.00           C  
ATOM   1091  NE1 TRP A  71      28.277 -16.153   6.685  1.00  0.00           N  
ATOM   1092  CE2 TRP A  71      29.360 -16.077   5.850  1.00  0.00           C  
ATOM   1093  CE3 TRP A  71      31.751 -15.792   6.035  1.00  0.00           C  
ATOM   1094  CZ2 TRP A  71      29.432 -16.152   4.462  1.00  0.00           C  
ATOM   1095  CZ3 TRP A  71      31.820 -15.866   4.657  1.00  0.00           C  
ATOM   1096  CH2 TRP A  71      30.667 -16.045   3.883  1.00  0.00           C  
ATOM   1097  H   TRP A  71      33.044 -15.649  10.627  1.00  0.00           H  
ATOM   1098  HA  TRP A  71      31.100 -17.644  10.099  1.00  0.00           H  
ATOM   1099  HB2 TRP A  71      30.274 -15.453  10.064  1.00  0.00           H  
ATOM   1100  HB3 TRP A  71      31.594 -14.871   9.052  1.00  0.00           H  
ATOM   1101  HD1 TRP A  71      28.075 -16.045   8.860  1.00  0.00           H  
ATOM   1102  HE1 TRP A  71      27.346 -16.275   6.402  1.00  0.00           H  
ATOM   1103  HE3 TRP A  71      32.652 -15.654   6.616  1.00  0.00           H  
ATOM   1104  HZ2 TRP A  71      28.551 -16.290   3.850  1.00  0.00           H  
ATOM   1105  HZ3 TRP A  71      32.777 -15.786   4.162  1.00  0.00           H  
ATOM   1106  HH2 TRP A  71      30.769 -16.098   2.810  1.00  0.00           H  
ATOM   1107  N   CYS A  72      33.558 -17.510   8.084  1.00  0.00           N  
ATOM   1108  CA  CYS A  72      34.177 -18.095   6.900  1.00  0.00           C  
ATOM   1109  C   CYS A  72      34.104 -19.617   6.944  1.00  0.00           C  
ATOM   1110  O   CYS A  72      34.000 -20.274   5.908  1.00  0.00           O  
ATOM   1111  CB  CYS A  72      35.634 -17.645   6.785  1.00  0.00           C  
ATOM   1112  SG  CYS A  72      36.715 -18.308   8.073  1.00  0.00           S  
ATOM   1113  H   CYS A  72      34.122 -17.040   8.734  1.00  0.00           H  
ATOM   1114  HA  CYS A  72      33.632 -17.745   6.035  1.00  0.00           H  
ATOM   1115  HB2 CYS A  72      36.027 -17.964   5.830  1.00  0.00           H  
ATOM   1116  HB3 CYS A  72      35.675 -16.568   6.841  1.00  0.00           H  
ATOM   1117  HG  CYS A  72      37.376 -17.295   8.613  1.00  0.00           H  
ATOM   1118  N   SER A  73      34.160 -20.173   8.150  1.00  0.00           N  
ATOM   1119  CA  SER A  73      34.106 -21.619   8.329  1.00  0.00           C  
ATOM   1120  C   SER A  73      32.664 -22.118   8.290  1.00  0.00           C  
ATOM   1121  O   SER A  73      32.337 -23.051   7.556  1.00  0.00           O  
ATOM   1122  CB  SER A  73      34.758 -22.014   9.655  1.00  0.00           C  
ATOM   1123  OG  SER A  73      36.129 -21.654   9.677  1.00  0.00           O  
ATOM   1124  H   SER A  73      34.242 -19.596   8.938  1.00  0.00           H  
ATOM   1125  HA  SER A  73      34.654 -22.074   7.518  1.00  0.00           H  
ATOM   1126  HB2 SER A  73      34.253 -21.512  10.466  1.00  0.00           H  
ATOM   1127  HB3 SER A  73      34.677 -23.084   9.789  1.00  0.00           H  
ATOM   1128  HG  SER A  73      36.651 -22.401   9.980  1.00  0.00           H  
ATOM   1129  N   LYS A  74      31.805 -21.488   9.086  1.00  0.00           N  
ATOM   1130  CA  LYS A  74      30.398 -21.865   9.142  1.00  0.00           C  
ATOM   1131  C   LYS A  74      29.867 -22.199   7.752  1.00  0.00           C  
ATOM   1132  O   LYS A  74      29.450 -23.328   7.489  1.00  0.00           O  
ATOM   1133  CB  LYS A  74      29.570 -20.734   9.757  1.00  0.00           C  
ATOM   1134  CG  LYS A  74      30.122 -20.225  11.078  1.00  0.00           C  
ATOM   1135  CD  LYS A  74      29.092 -19.402  11.833  1.00  0.00           C  
ATOM   1136  CE  LYS A  74      28.899 -18.034  11.197  1.00  0.00           C  
ATOM   1137  NZ  LYS A  74      27.591 -17.429  11.572  1.00  0.00           N  
ATOM   1138  H   LYS A  74      32.126 -20.752   9.647  1.00  0.00           H  
ATOM   1139  HA  LYS A  74      30.314 -22.741   9.767  1.00  0.00           H  
ATOM   1140  HB2 LYS A  74      29.539 -19.908   9.063  1.00  0.00           H  
ATOM   1141  HB3 LYS A  74      28.564 -21.091   9.926  1.00  0.00           H  
ATOM   1142  HG2 LYS A  74      30.409 -21.070  11.687  1.00  0.00           H  
ATOM   1143  HG3 LYS A  74      30.989 -19.610  10.882  1.00  0.00           H  
ATOM   1144  HD2 LYS A  74      28.149 -19.926  11.825  1.00  0.00           H  
ATOM   1145  HD3 LYS A  74      29.426 -19.272  12.853  1.00  0.00           H  
ATOM   1146  HE2 LYS A  74      29.694 -17.383  11.527  1.00  0.00           H  
ATOM   1147  HE3 LYS A  74      28.943 -18.141  10.124  1.00  0.00           H  
ATOM   1148  HZ1 LYS A  74      27.731 -16.457  11.912  1.00  0.00           H  
ATOM   1149  HZ2 LYS A  74      27.141 -17.986  12.326  1.00  0.00           H  
ATOM   1150  HZ3 LYS A  74      26.957 -17.408  10.747  1.00  0.00           H  
ATOM   1151  N   THR A  75      29.886 -21.211   6.863  1.00  0.00           N  
ATOM   1152  CA  THR A  75      29.408 -21.400   5.499  1.00  0.00           C  
ATOM   1153  C   THR A  75      30.463 -22.080   4.636  1.00  0.00           C  
ATOM   1154  O   THR A  75      30.139 -22.846   3.729  1.00  0.00           O  
ATOM   1155  CB  THR A  75      29.016 -20.059   4.850  1.00  0.00           C  
ATOM   1156  OG1 THR A  75      30.184 -19.262   4.629  1.00  0.00           O  
ATOM   1157  CG2 THR A  75      28.035 -19.298   5.731  1.00  0.00           C  
ATOM   1158  H   THR A  75      30.231 -20.334   7.132  1.00  0.00           H  
ATOM   1159  HA  THR A  75      28.529 -22.027   5.538  1.00  0.00           H  
ATOM   1160  HB  THR A  75      28.541 -20.261   3.900  1.00  0.00           H  
ATOM   1161  HG1 THR A  75      30.536 -18.968   5.473  1.00  0.00           H  
ATOM   1162 HG21 THR A  75      27.983 -19.768   6.702  1.00  0.00           H  
ATOM   1163 HG22 THR A  75      27.058 -19.308   5.273  1.00  0.00           H  
ATOM   1164 HG23 THR A  75      28.370 -18.278   5.843  1.00  0.00           H  
ATOM   1165  N   GLY A  76      31.730 -21.795   4.922  1.00  0.00           N  
ATOM   1166  CA  GLY A  76      32.814 -22.389   4.162  1.00  0.00           C  
ATOM   1167  C   GLY A  76      33.303 -21.485   3.046  1.00  0.00           C  
ATOM   1168  O   GLY A  76      33.748 -21.962   2.002  1.00  0.00           O  
ATOM   1169  H   GLY A  76      31.930 -21.177   5.656  1.00  0.00           H  
ATOM   1170  HA2 GLY A  76      33.637 -22.594   4.831  1.00  0.00           H  
ATOM   1171  HA3 GLY A  76      32.471 -23.318   3.733  1.00  0.00           H  
ATOM   1172  N   HIS A  77      33.217 -20.178   3.266  1.00  0.00           N  
ATOM   1173  CA  HIS A  77      33.653 -19.205   2.269  1.00  0.00           C  
ATOM   1174  C   HIS A  77      35.032 -18.653   2.616  1.00  0.00           C  
ATOM   1175  O   HIS A  77      35.369 -18.444   3.782  1.00  0.00           O  
ATOM   1176  CB  HIS A  77      32.644 -18.061   2.167  1.00  0.00           C  
ATOM   1177  CG  HIS A  77      31.543 -18.319   1.184  1.00  0.00           C  
ATOM   1178  ND1 HIS A  77      31.758 -18.889  -0.054  1.00  0.00           N  
ATOM   1179  CD2 HIS A  77      30.213 -18.083   1.262  1.00  0.00           C  
ATOM   1180  CE1 HIS A  77      30.607 -18.990  -0.695  1.00  0.00           C  
ATOM   1181  NE2 HIS A  77      29.654 -18.509   0.082  1.00  0.00           N  
ATOM   1182  H   HIS A  77      32.854 -19.859   4.118  1.00  0.00           H  
ATOM   1183  HA  HIS A  77      33.709 -19.709   1.317  1.00  0.00           H  
ATOM   1184  HB2 HIS A  77      32.191 -17.901   3.135  1.00  0.00           H  
ATOM   1185  HB3 HIS A  77      33.158 -17.161   1.862  1.00  0.00           H  
ATOM   1186  HD1 HIS A  77      32.625 -19.173  -0.409  1.00  0.00           H  
ATOM   1187  HD2 HIS A  77      29.687 -17.641   2.097  1.00  0.00           H  
ATOM   1188  HE1 HIS A  77      30.470 -19.398  -1.685  1.00  0.00           H  
ATOM   1189  HE2 HIS A  77      28.719 -18.386  -0.183  1.00  0.00           H  
ATOM   1190  N   PRO A  78      35.850 -18.411   1.581  1.00  0.00           N  
ATOM   1191  CA  PRO A  78      37.206 -17.880   1.752  1.00  0.00           C  
ATOM   1192  C   PRO A  78      37.206 -16.428   2.217  1.00  0.00           C  
ATOM   1193  O   PRO A  78      36.399 -15.618   1.760  1.00  0.00           O  
ATOM   1194  CB  PRO A  78      37.809 -17.992   0.349  1.00  0.00           C  
ATOM   1195  CG  PRO A  78      36.638 -17.959  -0.571  1.00  0.00           C  
ATOM   1196  CD  PRO A  78      35.515 -18.636   0.166  1.00  0.00           C  
ATOM   1197  HA  PRO A  78      37.782 -18.479   2.442  1.00  0.00           H  
ATOM   1198  HB2 PRO A  78      38.474 -17.157   0.174  1.00  0.00           H  
ATOM   1199  HB3 PRO A  78      38.355 -18.918   0.261  1.00  0.00           H  
ATOM   1200  HG2 PRO A  78      36.376 -16.936  -0.796  1.00  0.00           H  
ATOM   1201  HG3 PRO A  78      36.869 -18.498  -1.478  1.00  0.00           H  
ATOM   1202  HD2 PRO A  78      34.569 -18.177  -0.085  1.00  0.00           H  
ATOM   1203  HD3 PRO A  78      35.497 -19.691  -0.063  1.00  0.00           H  
ATOM   1204  N   LEU A  79      38.115 -16.104   3.130  1.00  0.00           N  
ATOM   1205  CA  LEU A  79      38.221 -14.748   3.659  1.00  0.00           C  
ATOM   1206  C   LEU A  79      39.424 -14.025   3.064  1.00  0.00           C  
ATOM   1207  O   LEU A  79      40.465 -14.632   2.815  1.00  0.00           O  
ATOM   1208  CB  LEU A  79      38.333 -14.782   5.184  1.00  0.00           C  
ATOM   1209  CG  LEU A  79      38.223 -13.433   5.894  1.00  0.00           C  
ATOM   1210  CD1 LEU A  79      36.785 -12.938   5.881  1.00  0.00           C  
ATOM   1211  CD2 LEU A  79      38.739 -13.537   7.323  1.00  0.00           C  
ATOM   1212  H   LEU A  79      38.731 -16.793   3.457  1.00  0.00           H  
ATOM   1213  HA  LEU A  79      37.323 -14.215   3.383  1.00  0.00           H  
ATOM   1214  HB2 LEU A  79      37.547 -15.418   5.560  1.00  0.00           H  
ATOM   1215  HB3 LEU A  79      39.293 -15.211   5.434  1.00  0.00           H  
ATOM   1216  HG  LEU A  79      38.830 -12.707   5.371  1.00  0.00           H  
ATOM   1217 HD11 LEU A  79      36.604 -12.333   6.757  1.00  0.00           H  
ATOM   1218 HD12 LEU A  79      36.113 -13.784   5.882  1.00  0.00           H  
ATOM   1219 HD13 LEU A  79      36.616 -12.346   4.993  1.00  0.00           H  
ATOM   1220 HD21 LEU A  79      39.722 -13.986   7.316  1.00  0.00           H  
ATOM   1221 HD22 LEU A  79      38.067 -14.151   7.904  1.00  0.00           H  
ATOM   1222 HD23 LEU A  79      38.796 -12.551   7.757  1.00  0.00           H  
ATOM   1223  N   GLN A  80      39.274 -12.723   2.841  1.00  0.00           N  
ATOM   1224  CA  GLN A  80      40.350 -11.916   2.278  1.00  0.00           C  
ATOM   1225  C   GLN A  80      40.996 -11.043   3.349  1.00  0.00           C  
ATOM   1226  O   GLN A  80      40.318 -10.408   4.158  1.00  0.00           O  
ATOM   1227  CB  GLN A  80      39.818 -11.039   1.143  1.00  0.00           C  
ATOM   1228  CG  GLN A  80      39.203 -11.831   0.000  1.00  0.00           C  
ATOM   1229  CD  GLN A  80      40.133 -12.900  -0.538  1.00  0.00           C  
ATOM   1230  OE1 GLN A  80      40.183 -14.015  -0.017  1.00  0.00           O  
ATOM   1231  NE2 GLN A  80      40.878 -12.566  -1.585  1.00  0.00           N  
ATOM   1232  H   GLN A  80      38.421 -12.296   3.062  1.00  0.00           H  
ATOM   1233  HA  GLN A  80      41.096 -12.588   1.881  1.00  0.00           H  
ATOM   1234  HB2 GLN A  80      39.065 -10.376   1.540  1.00  0.00           H  
ATOM   1235  HB3 GLN A  80      40.632 -10.451   0.746  1.00  0.00           H  
ATOM   1236  HG2 GLN A  80      38.300 -12.307   0.354  1.00  0.00           H  
ATOM   1237  HG3 GLN A  80      38.958 -11.150  -0.802  1.00  0.00           H  
ATOM   1238 HE21 GLN A  80      40.787 -11.658  -1.945  1.00  0.00           H  
ATOM   1239 HE22 GLN A  80      41.489 -13.236  -1.952  1.00  0.00           H  
ATOM   1240  N   PRO A  81      42.337 -11.012   3.358  1.00  0.00           N  
ATOM   1241  CA  PRO A  81      43.103 -10.221   4.327  1.00  0.00           C  
ATOM   1242  C   PRO A  81      42.971  -8.721   4.084  1.00  0.00           C  
ATOM   1243  O   PRO A  81      42.767  -8.266   2.957  1.00  0.00           O  
ATOM   1244  CB  PRO A  81      44.546 -10.675   4.093  1.00  0.00           C  
ATOM   1245  CG  PRO A  81      44.567 -11.156   2.683  1.00  0.00           C  
ATOM   1246  CD  PRO A  81      43.208 -11.744   2.425  1.00  0.00           C  
ATOM   1247  HA  PRO A  81      42.813 -10.447   5.342  1.00  0.00           H  
ATOM   1248  HB2 PRO A  81      45.217  -9.840   4.237  1.00  0.00           H  
ATOM   1249  HB3 PRO A  81      44.794 -11.467   4.783  1.00  0.00           H  
ATOM   1250  HG2 PRO A  81      44.751 -10.329   2.015  1.00  0.00           H  
ATOM   1251  HG3 PRO A  81      45.330 -11.912   2.565  1.00  0.00           H  
ATOM   1252  HD2 PRO A  81      42.910 -11.570   1.402  1.00  0.00           H  
ATOM   1253  HD3 PRO A  81      43.206 -12.801   2.646  1.00  0.00           H  
ATOM   1254  N   PRO A  82      43.089  -7.934   5.163  1.00  0.00           N  
ATOM   1255  CA  PRO A  82      42.988  -6.473   5.091  1.00  0.00           C  
ATOM   1256  C   PRO A  82      44.180  -5.842   4.379  1.00  0.00           C  
ATOM   1257  O   PRO A  82      44.998  -6.542   3.778  1.00  0.00           O  
ATOM   1258  CB  PRO A  82      42.958  -6.047   6.561  1.00  0.00           C  
ATOM   1259  CG  PRO A  82      43.654  -7.146   7.288  1.00  0.00           C  
ATOM   1260  CD  PRO A  82      43.333  -8.408   6.535  1.00  0.00           C  
ATOM   1261  HA  PRO A  82      42.075  -6.162   4.605  1.00  0.00           H  
ATOM   1262  HB2 PRO A  82      43.477  -5.106   6.677  1.00  0.00           H  
ATOM   1263  HB3 PRO A  82      41.934  -5.943   6.888  1.00  0.00           H  
ATOM   1264  HG2 PRO A  82      44.717  -6.969   7.289  1.00  0.00           H  
ATOM   1265  HG3 PRO A  82      43.281  -7.209   8.300  1.00  0.00           H  
ATOM   1266  HD2 PRO A  82      44.171  -9.088   6.565  1.00  0.00           H  
ATOM   1267  HD3 PRO A  82      42.450  -8.877   6.942  1.00  0.00           H  
ATOM   1268  N   LEU A  83      44.274  -4.519   4.449  1.00  0.00           N  
ATOM   1269  CA  LEU A  83      45.367  -3.795   3.810  1.00  0.00           C  
ATOM   1270  C   LEU A  83      46.711  -4.205   4.403  1.00  0.00           C  
ATOM   1271  O   LEU A  83      46.771  -4.806   5.475  1.00  0.00           O  
ATOM   1272  CB  LEU A  83      45.166  -2.287   3.969  1.00  0.00           C  
ATOM   1273  CG  LEU A  83      44.380  -1.594   2.855  1.00  0.00           C  
ATOM   1274  CD1 LEU A  83      44.336  -0.091   3.088  1.00  0.00           C  
ATOM   1275  CD2 LEU A  83      44.991  -1.906   1.497  1.00  0.00           C  
ATOM   1276  H   LEU A  83      43.592  -4.017   4.941  1.00  0.00           H  
ATOM   1277  HA  LEU A  83      45.360  -4.043   2.760  1.00  0.00           H  
ATOM   1278  HB2 LEU A  83      44.642  -2.119   4.897  1.00  0.00           H  
ATOM   1279  HB3 LEU A  83      46.143  -1.828   4.020  1.00  0.00           H  
ATOM   1280  HG  LEU A  83      43.364  -1.962   2.858  1.00  0.00           H  
ATOM   1281 HD11 LEU A  83      43.637   0.129   3.880  1.00  0.00           H  
ATOM   1282 HD12 LEU A  83      44.020   0.404   2.182  1.00  0.00           H  
ATOM   1283 HD13 LEU A  83      45.319   0.259   3.366  1.00  0.00           H  
ATOM   1284 HD21 LEU A  83      45.232  -0.984   0.990  1.00  0.00           H  
ATOM   1285 HD22 LEU A  83      44.284  -2.469   0.904  1.00  0.00           H  
ATOM   1286 HD23 LEU A  83      45.890  -2.489   1.633  1.00  0.00           H  
ATOM   1287  N   SER A  84      47.788  -3.874   3.698  1.00  0.00           N  
ATOM   1288  CA  SER A  84      49.132  -4.210   4.153  1.00  0.00           C  
ATOM   1289  C   SER A  84      49.504  -3.401   5.393  1.00  0.00           C  
ATOM   1290  O   SER A  84      48.932  -2.348   5.673  1.00  0.00           O  
ATOM   1291  CB  SER A  84      50.150  -3.954   3.040  1.00  0.00           C  
ATOM   1292  OG  SER A  84      50.207  -5.047   2.140  1.00  0.00           O  
ATOM   1293  H   SER A  84      47.676  -3.395   2.850  1.00  0.00           H  
ATOM   1294  HA  SER A  84      49.145  -5.260   4.406  1.00  0.00           H  
ATOM   1295  HB2 SER A  84      49.865  -3.067   2.493  1.00  0.00           H  
ATOM   1296  HB3 SER A  84      51.128  -3.810   3.476  1.00  0.00           H  
ATOM   1297  HG  SER A  84      50.092  -5.867   2.624  1.00  0.00           H  
ATOM   1298  N   PRO A  85      50.487  -3.905   6.154  1.00  0.00           N  
ATOM   1299  CA  PRO A  85      50.958  -3.246   7.376  1.00  0.00           C  
ATOM   1300  C   PRO A  85      51.714  -1.955   7.084  1.00  0.00           C  
ATOM   1301  O   PRO A  85      52.224  -1.303   7.995  1.00  0.00           O  
ATOM   1302  CB  PRO A  85      51.894  -4.285   8.000  1.00  0.00           C  
ATOM   1303  CG  PRO A  85      52.360  -5.112   6.852  1.00  0.00           C  
ATOM   1304  CD  PRO A  85      51.214  -5.157   5.880  1.00  0.00           C  
ATOM   1305  HA  PRO A  85      50.143  -3.040   8.055  1.00  0.00           H  
ATOM   1306  HB2 PRO A  85      52.719  -3.783   8.487  1.00  0.00           H  
ATOM   1307  HB3 PRO A  85      51.351  -4.878   8.719  1.00  0.00           H  
ATOM   1308  HG2 PRO A  85      53.223  -4.653   6.393  1.00  0.00           H  
ATOM   1309  HG3 PRO A  85      52.601  -6.109   7.193  1.00  0.00           H  
ATOM   1310  HD2 PRO A  85      51.580  -5.175   4.865  1.00  0.00           H  
ATOM   1311  HD3 PRO A  85      50.588  -6.015   6.074  1.00  0.00           H  
ATOM   1312  N   LEU A  86      51.781  -1.591   5.808  1.00  0.00           N  
ATOM   1313  CA  LEU A  86      52.474  -0.375   5.395  1.00  0.00           C  
ATOM   1314  C   LEU A  86      51.521   0.583   4.688  1.00  0.00           C  
ATOM   1315  O   LEU A  86      51.834   1.757   4.499  1.00  0.00           O  
ATOM   1316  CB  LEU A  86      53.645  -0.720   4.474  1.00  0.00           C  
ATOM   1317  CG  LEU A  86      53.377  -1.795   3.421  1.00  0.00           C  
ATOM   1318  CD1 LEU A  86      54.271  -1.589   2.208  1.00  0.00           C  
ATOM   1319  CD2 LEU A  86      53.585  -3.183   4.010  1.00  0.00           C  
ATOM   1320  H   LEU A  86      51.355  -2.151   5.127  1.00  0.00           H  
ATOM   1321  HA  LEU A  86      52.856   0.107   6.284  1.00  0.00           H  
ATOM   1322  HB2 LEU A  86      53.937   0.181   3.959  1.00  0.00           H  
ATOM   1323  HB3 LEU A  86      54.464  -1.060   5.094  1.00  0.00           H  
ATOM   1324  HG  LEU A  86      52.349  -1.720   3.094  1.00  0.00           H  
ATOM   1325 HD11 LEU A  86      55.158  -1.049   2.502  1.00  0.00           H  
ATOM   1326 HD12 LEU A  86      53.736  -1.025   1.459  1.00  0.00           H  
ATOM   1327 HD13 LEU A  86      54.551  -2.550   1.801  1.00  0.00           H  
ATOM   1328 HD21 LEU A  86      53.315  -3.929   3.277  1.00  0.00           H  
ATOM   1329 HD22 LEU A  86      52.964  -3.299   4.886  1.00  0.00           H  
ATOM   1330 HD23 LEU A  86      54.623  -3.306   4.284  1.00  0.00           H  
ATOM   1331  N   GLU A  87      50.356   0.072   4.301  1.00  0.00           N  
ATOM   1332  CA  GLU A  87      49.357   0.883   3.615  1.00  0.00           C  
ATOM   1333  C   GLU A  87      48.575   1.736   4.610  1.00  0.00           C  
ATOM   1334  O   GLU A  87      47.877   2.675   4.224  1.00  0.00           O  
ATOM   1335  CB  GLU A  87      48.397  -0.011   2.827  1.00  0.00           C  
ATOM   1336  CG  GLU A  87      48.947  -0.457   1.482  1.00  0.00           C  
ATOM   1337  CD  GLU A  87      48.698   0.559   0.384  1.00  0.00           C  
ATOM   1338  OE1 GLU A  87      47.516   0.827   0.083  1.00  0.00           O  
ATOM   1339  OE2 GLU A  87      49.684   1.084  -0.173  1.00  0.00           O  
ATOM   1340  H   GLU A  87      50.165  -0.873   4.480  1.00  0.00           H  
ATOM   1341  HA  GLU A  87      49.874   1.535   2.929  1.00  0.00           H  
ATOM   1342  HB2 GLU A  87      48.179  -0.890   3.414  1.00  0.00           H  
ATOM   1343  HB3 GLU A  87      47.480   0.533   2.654  1.00  0.00           H  
ATOM   1344  HG2 GLU A  87      50.012  -0.609   1.576  1.00  0.00           H  
ATOM   1345  HG3 GLU A  87      48.474  -1.388   1.207  1.00  0.00           H  
ATOM   1346  N   LEU A  88      48.695   1.403   5.889  1.00  0.00           N  
ATOM   1347  CA  LEU A  88      48.000   2.139   6.940  1.00  0.00           C  
ATOM   1348  C   LEU A  88      48.914   3.185   7.569  1.00  0.00           C  
ATOM   1349  O   LEU A  88      48.485   3.972   8.412  1.00  0.00           O  
ATOM   1350  CB  LEU A  88      47.493   1.175   8.014  1.00  0.00           C  
ATOM   1351  CG  LEU A  88      48.525   0.717   9.046  1.00  0.00           C  
ATOM   1352  CD1 LEU A  88      47.857   0.445  10.385  1.00  0.00           C  
ATOM   1353  CD2 LEU A  88      49.259  -0.522   8.553  1.00  0.00           C  
ATOM   1354  H   LEU A  88      49.266   0.646   6.136  1.00  0.00           H  
ATOM   1355  HA  LEU A  88      47.156   2.640   6.491  1.00  0.00           H  
ATOM   1356  HB2 LEU A  88      46.690   1.664   8.545  1.00  0.00           H  
ATOM   1357  HB3 LEU A  88      47.111   0.296   7.515  1.00  0.00           H  
ATOM   1358  HG  LEU A  88      49.254   1.503   9.190  1.00  0.00           H  
ATOM   1359 HD11 LEU A  88      46.786   0.525  10.276  1.00  0.00           H  
ATOM   1360 HD12 LEU A  88      48.201   1.166  11.112  1.00  0.00           H  
ATOM   1361 HD13 LEU A  88      48.112  -0.550  10.718  1.00  0.00           H  
ATOM   1362 HD21 LEU A  88      49.067  -0.657   7.498  1.00  0.00           H  
ATOM   1363 HD22 LEU A  88      48.910  -1.387   9.096  1.00  0.00           H  
ATOM   1364 HD23 LEU A  88      50.320  -0.398   8.712  1.00  0.00           H  
ATOM   1365  N   MET A  89      50.176   3.189   7.152  1.00  0.00           N  
ATOM   1366  CA  MET A  89      51.150   4.142   7.673  1.00  0.00           C  
ATOM   1367  C   MET A  89      50.971   5.511   7.025  1.00  0.00           C  
ATOM   1368  O   MET A  89      51.540   5.786   5.970  1.00  0.00           O  
ATOM   1369  CB  MET A  89      52.572   3.632   7.432  1.00  0.00           C  
ATOM   1370  CG  MET A  89      53.649   4.628   7.830  1.00  0.00           C  
ATOM   1371  SD  MET A  89      55.315   3.967   7.627  1.00  0.00           S  
ATOM   1372  CE  MET A  89      55.456   3.948   5.841  1.00  0.00           C  
ATOM   1373  H   MET A  89      50.460   2.537   6.478  1.00  0.00           H  
ATOM   1374  HA  MET A  89      50.986   4.235   8.736  1.00  0.00           H  
ATOM   1375  HB2 MET A  89      52.720   2.728   8.003  1.00  0.00           H  
ATOM   1376  HB3 MET A  89      52.689   3.409   6.381  1.00  0.00           H  
ATOM   1377  HG2 MET A  89      53.551   5.510   7.215  1.00  0.00           H  
ATOM   1378  HG3 MET A  89      53.507   4.896   8.866  1.00  0.00           H  
ATOM   1379  HE1 MET A  89      54.540   3.569   5.411  1.00  0.00           H  
ATOM   1380  HE2 MET A  89      55.634   4.950   5.484  1.00  0.00           H  
ATOM   1381  HE3 MET A  89      56.279   3.310   5.553  1.00  0.00           H  
ATOM   1382  N   GLU A  90      50.176   6.364   7.665  1.00  0.00           N  
ATOM   1383  CA  GLU A  90      49.923   7.704   7.149  1.00  0.00           C  
ATOM   1384  C   GLU A  90      50.746   8.743   7.905  1.00  0.00           C  
ATOM   1385  O   GLU A  90      51.301   8.458   8.966  1.00  0.00           O  
ATOM   1386  CB  GLU A  90      48.435   8.041   7.254  1.00  0.00           C  
ATOM   1387  CG  GLU A  90      47.928   8.125   8.684  1.00  0.00           C  
ATOM   1388  CD  GLU A  90      46.426   7.946   8.783  1.00  0.00           C  
ATOM   1389  OE1 GLU A  90      45.863   7.193   7.959  1.00  0.00           O  
ATOM   1390  OE2 GLU A  90      45.813   8.557   9.682  1.00  0.00           O  
ATOM   1391  H   GLU A  90      49.751   6.086   8.503  1.00  0.00           H  
ATOM   1392  HA  GLU A  90      50.214   7.720   6.109  1.00  0.00           H  
ATOM   1393  HB2 GLU A  90      48.259   8.993   6.774  1.00  0.00           H  
ATOM   1394  HB3 GLU A  90      47.868   7.280   6.738  1.00  0.00           H  
ATOM   1395  HG2 GLU A  90      48.406   7.352   9.268  1.00  0.00           H  
ATOM   1396  HG3 GLU A  90      48.187   9.093   9.088  1.00  0.00           H  
ATOM   1397  N   ALA A  91      50.819   9.948   7.351  1.00  0.00           N  
ATOM   1398  CA  ALA A  91      51.572  11.030   7.973  1.00  0.00           C  
ATOM   1399  C   ALA A  91      53.027  10.630   8.194  1.00  0.00           C  
ATOM   1400  O   ALA A  91      53.603  10.903   9.248  1.00  0.00           O  
ATOM   1401  CB  ALA A  91      50.927  11.433   9.291  1.00  0.00           C  
ATOM   1402  H   ALA A  91      50.355  10.115   6.504  1.00  0.00           H  
ATOM   1403  HA  ALA A  91      51.541  11.883   7.310  1.00  0.00           H  
ATOM   1404  HB1 ALA A  91      51.483  10.999  10.110  1.00  0.00           H  
ATOM   1405  HB2 ALA A  91      50.934  12.509   9.381  1.00  0.00           H  
ATOM   1406  HB3 ALA A  91      49.909  11.075   9.317  1.00  0.00           H  
ATOM   1407  N   SER A  92      53.616   9.982   7.194  1.00  0.00           N  
ATOM   1408  CA  SER A  92      55.004   9.541   7.282  1.00  0.00           C  
ATOM   1409  C   SER A  92      55.888  10.334   6.324  1.00  0.00           C  
ATOM   1410  O   SER A  92      56.011   9.990   5.149  1.00  0.00           O  
ATOM   1411  CB  SER A  92      55.106   8.047   6.970  1.00  0.00           C  
ATOM   1412  OG  SER A  92      56.234   7.469   7.603  1.00  0.00           O  
ATOM   1413  H   SER A  92      53.106   9.795   6.380  1.00  0.00           H  
ATOM   1414  HA  SER A  92      55.343   9.712   8.292  1.00  0.00           H  
ATOM   1415  HB2 SER A  92      54.215   7.547   7.319  1.00  0.00           H  
ATOM   1416  HB3 SER A  92      55.198   7.911   5.901  1.00  0.00           H  
ATOM   1417  HG  SER A  92      56.272   7.760   8.517  1.00  0.00           H  
ATOM   1418  N   GLU A  93      56.500  11.397   6.837  1.00  0.00           N  
ATOM   1419  CA  GLU A  93      57.373  12.239   6.028  1.00  0.00           C  
ATOM   1420  C   GLU A  93      58.840  11.910   6.286  1.00  0.00           C  
ATOM   1421  O   GLU A  93      59.332  12.053   7.406  1.00  0.00           O  
ATOM   1422  CB  GLU A  93      57.110  13.717   6.325  1.00  0.00           C  
ATOM   1423  CG  GLU A  93      56.026  14.329   5.452  1.00  0.00           C  
ATOM   1424  CD  GLU A  93      56.177  15.831   5.304  1.00  0.00           C  
ATOM   1425  OE1 GLU A  93      56.370  16.511   6.333  1.00  0.00           O  
ATOM   1426  OE2 GLU A  93      56.102  16.325   4.159  1.00  0.00           O  
ATOM   1427  H   GLU A  93      56.363  11.618   7.782  1.00  0.00           H  
ATOM   1428  HA  GLU A  93      57.150  12.045   4.989  1.00  0.00           H  
ATOM   1429  HB2 GLU A  93      56.811  13.817   7.357  1.00  0.00           H  
ATOM   1430  HB3 GLU A  93      58.023  14.270   6.168  1.00  0.00           H  
ATOM   1431  HG2 GLU A  93      56.074  13.880   4.472  1.00  0.00           H  
ATOM   1432  HG3 GLU A  93      55.064  14.121   5.896  1.00  0.00           H  
ATOM   1433  N   HIS A  94      59.535  11.469   5.242  1.00  0.00           N  
ATOM   1434  CA  HIS A  94      60.946  11.120   5.355  1.00  0.00           C  
ATOM   1435  C   HIS A  94      61.822  12.172   4.681  1.00  0.00           C  
ATOM   1436  O   HIS A  94      61.916  12.223   3.456  1.00  0.00           O  
ATOM   1437  CB  HIS A  94      61.205   9.748   4.732  1.00  0.00           C  
ATOM   1438  CG  HIS A  94      61.008   8.610   5.685  1.00  0.00           C  
ATOM   1439  ND1 HIS A  94      61.688   7.416   5.582  1.00  0.00           N  
ATOM   1440  CD2 HIS A  94      60.201   8.490   6.765  1.00  0.00           C  
ATOM   1441  CE1 HIS A  94      61.307   6.608   6.556  1.00  0.00           C  
ATOM   1442  NE2 HIS A  94      60.406   7.237   7.288  1.00  0.00           N  
ATOM   1443  H   HIS A  94      59.087  11.377   4.376  1.00  0.00           H  
ATOM   1444  HA  HIS A  94      61.195  11.081   6.404  1.00  0.00           H  
ATOM   1445  HB2 HIS A  94      60.531   9.605   3.899  1.00  0.00           H  
ATOM   1446  HB3 HIS A  94      62.225   9.709   4.374  1.00  0.00           H  
ATOM   1447  HD1 HIS A  94      62.351   7.192   4.896  1.00  0.00           H  
ATOM   1448  HD2 HIS A  94      59.521   9.239   7.144  1.00  0.00           H  
ATOM   1449  HE1 HIS A  94      61.672   5.606   6.727  1.00  0.00           H  
ATOM   1450  HE2 HIS A  94      59.897   6.836   8.023  1.00  0.00           H  
ATOM   1451  N   GLY A  95      62.461  13.011   5.492  1.00  0.00           N  
ATOM   1452  CA  GLY A  95      63.320  14.050   4.955  1.00  0.00           C  
ATOM   1453  C   GLY A  95      64.786  13.671   5.002  1.00  0.00           C  
ATOM   1454  O   GLY A  95      65.498  14.031   5.938  1.00  0.00           O  
ATOM   1455  H   GLY A  95      62.348  12.922   6.461  1.00  0.00           H  
ATOM   1456  HA2 GLY A  95      63.039  14.240   3.930  1.00  0.00           H  
ATOM   1457  HA3 GLY A  95      63.175  14.953   5.531  1.00  0.00           H  
ATOM   1458  N   GLY A  96      65.240  12.941   3.987  1.00  0.00           N  
ATOM   1459  CA  GLY A  96      66.629  12.524   3.936  1.00  0.00           C  
ATOM   1460  C   GLY A  96      67.008  11.933   2.592  1.00  0.00           C  
ATOM   1461  O   GLY A  96      66.159  11.386   1.886  1.00  0.00           O  
ATOM   1462  H   GLY A  96      64.626  12.684   3.267  1.00  0.00           H  
ATOM   1463  HA2 GLY A  96      67.257  13.379   4.131  1.00  0.00           H  
ATOM   1464  HA3 GLY A  96      66.799  11.783   4.702  1.00  0.00           H  
ATOM   1465  N   CYS A  97      68.283  12.043   2.238  1.00  0.00           N  
ATOM   1466  CA  CYS A  97      68.772  11.517   0.968  1.00  0.00           C  
ATOM   1467  C   CYS A  97      68.698   9.994   0.946  1.00  0.00           C  
ATOM   1468  O   CYS A  97      68.627   9.351   1.993  1.00  0.00           O  
ATOM   1469  CB  CYS A  97      70.211  11.974   0.723  1.00  0.00           C  
ATOM   1470  SG  CYS A  97      71.398  11.359   1.941  1.00  0.00           S  
ATOM   1471  H   CYS A  97      68.911  12.489   2.843  1.00  0.00           H  
ATOM   1472  HA  CYS A  97      68.141  11.907   0.184  1.00  0.00           H  
ATOM   1473  HB2 CYS A  97      70.530  11.627  -0.249  1.00  0.00           H  
ATOM   1474  HB3 CYS A  97      70.246  13.053   0.743  1.00  0.00           H  
ATOM   1475  HG  CYS A  97      72.141  10.433   1.356  1.00  0.00           H  
ATOM   1476  N   SER A  98      68.713   9.423  -0.254  1.00  0.00           N  
ATOM   1477  CA  SER A  98      68.643   7.975  -0.413  1.00  0.00           C  
ATOM   1478  C   SER A  98      69.665   7.490  -1.437  1.00  0.00           C  
ATOM   1479  O   SER A  98      70.186   8.274  -2.232  1.00  0.00           O  
ATOM   1480  CB  SER A  98      67.236   7.557  -0.844  1.00  0.00           C  
ATOM   1481  OG  SER A  98      66.278   7.890   0.146  1.00  0.00           O  
ATOM   1482  H   SER A  98      68.772   9.990  -1.052  1.00  0.00           H  
ATOM   1483  HA  SER A  98      68.866   7.526   0.542  1.00  0.00           H  
ATOM   1484  HB2 SER A  98      66.978   8.063  -1.762  1.00  0.00           H  
ATOM   1485  HB3 SER A  98      67.214   6.488  -1.003  1.00  0.00           H  
ATOM   1486  HG  SER A  98      66.697   7.889   1.009  1.00  0.00           H  
ATOM   1487  N   THR A  99      69.949   6.192  -1.411  1.00  0.00           N  
ATOM   1488  CA  THR A  99      70.910   5.601  -2.333  1.00  0.00           C  
ATOM   1489  C   THR A  99      70.204   4.832  -3.444  1.00  0.00           C  
ATOM   1490  O   THR A  99      69.197   4.158  -3.222  1.00  0.00           O  
ATOM   1491  CB  THR A  99      71.880   4.653  -1.604  1.00  0.00           C  
ATOM   1492  OG1 THR A  99      72.872   4.170  -2.517  1.00  0.00           O  
ATOM   1493  CG2 THR A  99      71.131   3.479  -0.992  1.00  0.00           C  
ATOM   1494  H   THR A  99      69.502   5.618  -0.754  1.00  0.00           H  
ATOM   1495  HA  THR A  99      71.485   6.402  -2.774  1.00  0.00           H  
ATOM   1496  HB  THR A  99      72.368   5.202  -0.811  1.00  0.00           H  
ATOM   1497  HG1 THR A  99      73.184   3.310  -2.224  1.00  0.00           H  
ATOM   1498 HG21 THR A  99      71.472   2.559  -1.444  1.00  0.00           H  
ATOM   1499 HG22 THR A  99      70.072   3.596  -1.168  1.00  0.00           H  
ATOM   1500 HG23 THR A  99      71.318   3.447   0.071  1.00  0.00           H  
ATOM   1501  N   PRO A 100      70.743   4.930  -4.668  1.00  0.00           N  
ATOM   1502  CA  PRO A 100      70.180   4.249  -5.837  1.00  0.00           C  
ATOM   1503  C   PRO A 100      70.365   2.736  -5.771  1.00  0.00           C  
ATOM   1504  O   PRO A 100      71.445   2.247  -5.443  1.00  0.00           O  
ATOM   1505  CB  PRO A 100      70.976   4.834  -7.007  1.00  0.00           C  
ATOM   1506  CG  PRO A 100      72.267   5.271  -6.405  1.00  0.00           C  
ATOM   1507  CD  PRO A 100      71.942   5.715  -5.005  1.00  0.00           C  
ATOM   1508  HA  PRO A 100      69.132   4.476  -5.964  1.00  0.00           H  
ATOM   1509  HB2 PRO A 100      71.128   4.073  -7.759  1.00  0.00           H  
ATOM   1510  HB3 PRO A 100      70.437   5.667  -7.433  1.00  0.00           H  
ATOM   1511  HG2 PRO A 100      72.961   4.444  -6.384  1.00  0.00           H  
ATOM   1512  HG3 PRO A 100      72.677   6.093  -6.973  1.00  0.00           H  
ATOM   1513  HD2 PRO A 100      72.757   5.481  -4.336  1.00  0.00           H  
ATOM   1514  HD3 PRO A 100      71.727   6.773  -4.986  1.00  0.00           H  
ATOM   1515  N   GLY A 101      69.304   2.000  -6.087  1.00  0.00           N  
ATOM   1516  CA  GLY A 101      69.371   0.551  -6.057  1.00  0.00           C  
ATOM   1517  C   GLY A 101      69.392  -0.058  -7.445  1.00  0.00           C  
ATOM   1518  O   GLY A 101      68.492  -0.811  -7.814  1.00  0.00           O  
ATOM   1519  H   GLY A 101      68.468   2.445  -6.341  1.00  0.00           H  
ATOM   1520  HA2 GLY A 101      70.265   0.253  -5.530  1.00  0.00           H  
ATOM   1521  HA3 GLY A 101      68.510   0.173  -5.525  1.00  0.00           H  
ATOM   1522  N   SER A 102      70.422   0.273  -8.218  1.00  0.00           N  
ATOM   1523  CA  SER A 102      70.555  -0.242  -9.576  1.00  0.00           C  
ATOM   1524  C   SER A 102      72.006  -0.183 -10.041  1.00  0.00           C  
ATOM   1525  O   SER A 102      72.764   0.698  -9.636  1.00  0.00           O  
ATOM   1526  CB  SER A 102      69.667   0.555 -10.535  1.00  0.00           C  
ATOM   1527  OG  SER A 102      68.357   0.020 -10.582  1.00  0.00           O  
ATOM   1528  H   SER A 102      71.108   0.878  -7.868  1.00  0.00           H  
ATOM   1529  HA  SER A 102      70.231  -1.272  -9.573  1.00  0.00           H  
ATOM   1530  HB2 SER A 102      69.613   1.581 -10.202  1.00  0.00           H  
ATOM   1531  HB3 SER A 102      70.093   0.522 -11.527  1.00  0.00           H  
ATOM   1532  HG  SER A 102      68.002  -0.037  -9.692  1.00  0.00           H  
ATOM   1533  N   GLY A 103      72.388  -1.129 -10.893  1.00  0.00           N  
ATOM   1534  CA  GLY A 103      73.748  -1.168 -11.399  1.00  0.00           C  
ATOM   1535  C   GLY A 103      74.182  -2.568 -11.784  1.00  0.00           C  
ATOM   1536  O   GLY A 103      74.824  -3.277 -11.010  1.00  0.00           O  
ATOM   1537  H   GLY A 103      71.740  -1.806 -11.180  1.00  0.00           H  
ATOM   1538  HA2 GLY A 103      73.816  -0.529 -12.266  1.00  0.00           H  
ATOM   1539  HA3 GLY A 103      74.414  -0.794 -10.635  1.00  0.00           H  
ATOM   1540  N   PRO A 104      73.830  -2.985 -13.010  1.00  0.00           N  
ATOM   1541  CA  PRO A 104      74.176  -4.313 -13.524  1.00  0.00           C  
ATOM   1542  C   PRO A 104      75.670  -4.456 -13.798  1.00  0.00           C  
ATOM   1543  O   PRO A 104      76.426  -3.493 -13.686  1.00  0.00           O  
ATOM   1544  CB  PRO A 104      73.381  -4.407 -14.829  1.00  0.00           C  
ATOM   1545  CG  PRO A 104      73.183  -2.993 -15.254  1.00  0.00           C  
ATOM   1546  CD  PRO A 104      73.065  -2.193 -13.986  1.00  0.00           C  
ATOM   1547  HA  PRO A 104      73.859  -5.096 -12.849  1.00  0.00           H  
ATOM   1548  HB2 PRO A 104      73.949  -4.965 -15.560  1.00  0.00           H  
ATOM   1549  HB3 PRO A 104      72.439  -4.900 -14.644  1.00  0.00           H  
ATOM   1550  HG2 PRO A 104      74.032  -2.661 -15.830  1.00  0.00           H  
ATOM   1551  HG3 PRO A 104      72.277  -2.909 -15.835  1.00  0.00           H  
ATOM   1552  HD2 PRO A 104      73.502  -1.214 -14.116  1.00  0.00           H  
ATOM   1553  HD3 PRO A 104      72.031  -2.108 -13.688  1.00  0.00           H  
ATOM   1554  N   SER A 105      76.087  -5.666 -14.160  1.00  0.00           N  
ATOM   1555  CA  SER A 105      77.491  -5.936 -14.447  1.00  0.00           C  
ATOM   1556  C   SER A 105      77.635  -6.759 -15.724  1.00  0.00           C  
ATOM   1557  O   SER A 105      76.890  -7.712 -15.948  1.00  0.00           O  
ATOM   1558  CB  SER A 105      78.141  -6.673 -13.275  1.00  0.00           C  
ATOM   1559  OG  SER A 105      77.617  -7.983 -13.142  1.00  0.00           O  
ATOM   1560  H   SER A 105      75.435  -6.394 -14.231  1.00  0.00           H  
ATOM   1561  HA  SER A 105      77.989  -4.987 -14.586  1.00  0.00           H  
ATOM   1562  HB2 SER A 105      79.206  -6.739 -13.441  1.00  0.00           H  
ATOM   1563  HB3 SER A 105      77.952  -6.129 -12.362  1.00  0.00           H  
ATOM   1564  HG  SER A 105      78.298  -8.624 -13.358  1.00  0.00           H  
ATOM   1565  N   SER A 106      78.600  -6.382 -16.557  1.00  0.00           N  
ATOM   1566  CA  SER A 106      78.840  -7.083 -17.813  1.00  0.00           C  
ATOM   1567  C   SER A 106      80.236  -6.774 -18.349  1.00  0.00           C  
ATOM   1568  O   SER A 106      80.816  -5.735 -18.038  1.00  0.00           O  
ATOM   1569  CB  SER A 106      77.786  -6.690 -18.851  1.00  0.00           C  
ATOM   1570  OG  SER A 106      77.977  -7.397 -20.064  1.00  0.00           O  
ATOM   1571  H   SER A 106      79.161  -5.613 -16.322  1.00  0.00           H  
ATOM   1572  HA  SER A 106      78.768  -8.143 -17.622  1.00  0.00           H  
ATOM   1573  HB2 SER A 106      76.804  -6.919 -18.466  1.00  0.00           H  
ATOM   1574  HB3 SER A 106      77.858  -5.631 -19.050  1.00  0.00           H  
ATOM   1575  HG  SER A 106      77.567  -6.913 -20.785  1.00  0.00           H  
ATOM   1576  N   GLY A 107      80.769  -7.687 -19.155  1.00  0.00           N  
ATOM   1577  CA  GLY A 107      82.092  -7.496 -19.720  1.00  0.00           C  
ATOM   1578  C   GLY A 107      82.473  -8.598 -20.689  1.00  0.00           C  
ATOM   1579  O   GLY A 107      83.579  -8.603 -21.230  1.00  0.00           O  
ATOM   1580  H   GLY A 107      80.260  -8.497 -19.367  1.00  0.00           H  
ATOM   1581  HA2 GLY A 107      82.116  -6.550 -20.239  1.00  0.00           H  
ATOM   1582  HA3 GLY A 107      82.814  -7.473 -18.918  1.00  0.00           H  
TER    1583      GLY A 107                                                      
END
MOLECULE T0429.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
