
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   78 ( 1167),  selected   78 , name 2d9t_A
# Molecule2: number of CA atoms  135 ( 1110),  selected  135 , name T0429.pdb
# PARAMETERS: 2d9t_A.T0429.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E      22           -
LGA    S     2_A      T      23           -
LGA    S     3_A      E      24           -
LGA    G     4_A      L      25           -
LGA    S     5_A      L      27           -
LGA    S     6_A      Y      28           -
LGA    -       -      K      29           -
LGA    -       -      V      30           -
LGA    -       -      N      31           -
LGA    -       -      E      32           -
LGA    -       -      Y      33           -
LGA    -       -      V      34           -
LGA    -       -      D      35           -
LGA    -       -      A      36           -
LGA    -       -      R      37           -
LGA    -       -      D      38           -
LGA    -       -      T      39           -
LGA    -       -      N      40           -
LGA    -       -      M      41           -
LGA    -       -      G      42           -
LGA    -       -      A      43           -
LGA    -       -      W      44           -
LGA    -       -      F      45           -
LGA    -       -      E      46           -
LGA    -       -      A      47           -
LGA    -       -      Q      48           -
LGA    -       -      V      49           -
LGA    -       -      V      50           -
LGA    -       -      R      51           -
LGA    -       -      V      52           -
LGA    -       -      T      53           -
LGA    -       -      R      54           -
LGA    -       -      E      73           -
LGA    -       -      D      74           -
LGA    -       -      V      75           -
LGA    -       -      I      76           -
LGA    -       -      Y      77           -
LGA    -       -      H      78           -
LGA    -       -      V      79           -
LGA    -       -      K      80           -
LGA    -       -      Y      81           -
LGA    -       -      D      82           -
LGA    -       -      D      83           -
LGA    -       -      Y      84           -
LGA    -       -      P      85           -
LGA    -       -      E      86           -
LGA    -       -      N      87           -
LGA    -       -      G      88           -
LGA    -       -      V      89           -
LGA    -       -      V      90           -
LGA    -       -      Q      91           -
LGA    -       -      M      92           -
LGA    -       -      N      93           -
LGA    -       -      S      94           -
LGA    -       -      R      95           -
LGA    -       -      D      96           -
LGA    -       -      V      97           -
LGA    -       -      R      98           -
LGA    -       -      A      99           -
LGA    -       -      R     100           -
LGA    -       -      A     101           -
LGA    -       -      R     102           -
LGA    -       -      T     103           -
LGA    -       -      I     104           -
LGA    G     7_A      I     105           #
LGA    K     8_A      K     106          3.380
LGA    -       -      W     107           -
LGA    -       -      Q     108           -
LGA    V     9_A      D     109          0.790
LGA    W    10_A      L     110          0.419
LGA    K    11_A      E     111          0.271
LGA    P    12_A      V     112          0.513
LGA    G    13_A      G     113          0.964
LGA    D    14_A      Q     114          0.467
LGA    E    15_A      V     115          0.493
LGA    C    16_A      V     116          0.609
LGA    F    17_A      M     117          1.262
LGA    A    18_A      L     118          1.977
LGA    L    19_A      N     119          1.180
LGA    Y    20_A      Y     120          1.560
LGA    W    21_A      N     121          2.373
LGA    E    22_A      P     122          3.896
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    -       -      E     127           -
LGA    D    23_A      R     128          6.470
LGA    N    24_A      G     129          0.653
LGA    K    25_A      F     130          0.702
LGA    F    26_A      W     131          0.859
LGA    Y    27_A      Y     132          0.809
LGA    R    28_A      D     133          0.832
LGA    A    29_A      A     134          0.860
LGA    E    30_A      E     135          1.154
LGA    V    31_A      I     136          0.761
LGA    E    32_A      S     137          0.919
LGA    A    33_A      R     138          1.466
LGA    L    34_A      K     139          0.758
LGA    H    35_A      R     140          1.313
LGA    S    36_A      E     141          2.773
LGA    S    37_A      T     142          2.432
LGA    G    38_A      R     143           -
LGA    -       -      T     144           -
LGA    -       -      A     145           -
LGA    M    39_A      R     146          1.746
LGA    T    40_A      E     147          2.508
LGA    A    41_A      L     148          0.454
LGA    V    42_A      Y     149          0.439
LGA    V    43_A      A     150          0.949
LGA    K    44_A      N     151          0.782
LGA    F    45_A      V     152          0.885
LGA    T    46_A      V     153          1.403
LGA    D    47_A      L     154          1.297
LGA    -       -      D     156           -
LGA    Y    48_A      D     157          2.485
LGA    G    49_A      S     158          1.287
LGA    N    50_A      L     159          1.270
LGA    Y    51_A      N     160          2.626
LGA    -       -      D     161           -
LGA    E    52_A      C     162          0.987
LGA    E    53_A      R     163          0.449
LGA    V    54_A      I     164          0.615
LGA    L    55_A      I     165          3.128
LGA    -       -      F     166           -
LGA    L    56_A      V     167          1.592
LGA    S    57_A      D     168          1.203
LGA    N    58_A      E     169          3.186
LGA    I    59_A      V     170          1.643
LGA    K    60_A      F     171          1.423
LGA    P    61_A      K     172          1.541
LGA    V    62_A      I     173          1.357
LGA    Q    63_A      E     174          1.399
LGA    T    64_A      R     175          2.103
LGA    E    65_A      P     176          2.792
LGA    A    66_A      -       -           -
LGA    W    67_A      -       -           -
LGA    V    68_A      -       -           -
LGA    R    69_A      -       -           -
LGA    D    70_A      -       -           -
LGA    P    71_A      -       -           -
LGA    N    72_A      -       -           -
LGA    S    73_A      -       -           -
LGA    G    74_A      -       -           -
LGA    P    75_A      -       -           -
LGA    S    76_A      -       -           -
LGA    S    77_A      -       -           -
LGA    G    78_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   78  135    5.0     57    1.83    10.53     38.372     2.949

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.279997 * X  +   0.665117 * Y  +   0.692258 * Z  +  23.492889
  Y_new =  -0.627379 * X  +  -0.672585 * Y  +   0.392459 * Z  + -23.612646
  Z_new =   0.726634 * X  +  -0.324421 * Y  +   0.605603 * Z  +  16.010033 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.491797    2.649796  [ DEG:   -28.1779    151.8221 ]
  Theta =  -0.813410   -2.328183  [ DEG:   -46.6049   -133.3951 ]
  Phi   =  -1.990567    1.151026  [ DEG:  -114.0511     65.9489 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2d9t_A                                        
REMARK     2: T0429.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2d9t_A.T0429.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   78  135   5.0   57   1.83   10.53  38.372
REMARK  ---------------------------------------------------------- 
MOLECULE 2d9t_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   13-DEC-05   2D9T              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF TUDOR DOMAIN                
TITLE    2 CONTAINING PROTEIN 3 FROM MOUSE                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TUDOR DOMAIN-CONTAINING PROTEIN 3;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: TDRD3;                                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050214-04;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    TUDOR DOMAIN, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT           
KEYWDS   2 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.LI,T.TOMIZAWA,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN           
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   13-JUN-06 2D9T    0                                                
JRNL        AUTH   H.LI,T.TOMIZAWA,S.KOSHIBA,M.INOUE,T.KIGAWA,                  
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF TUDOR              
JRNL        TITL 2 DOMAIN CONTAINING PROTEIN 3 FROM MOUSE                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2D9T A    8    67  UNP    Q91W18   TDRD3_MOUSE    553    612             
SEQRES   1 A   78  GLY SER SER GLY SER SER GLY LYS VAL TRP LYS PRO GLY          
SEQRES   2 A   78  ASP GLU CYS PHE ALA LEU TYR TRP GLU ASP ASN LYS PHE          
SEQRES   3 A   78  TYR ARG ALA GLU VAL GLU ALA LEU HIS SER SER GLY MET          
SEQRES   4 A   78  THR ALA VAL VAL LYS PHE THR ASP TYR GLY ASN TYR GLU          
SEQRES   5 A   78  GLU VAL LEU LEU SER ASN ILE LYS PRO VAL GLN THR GLU          
SEQRES   6 A   78  ALA TRP VAL ARG ASP PRO ASN SER GLY PRO SER SER GLY          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      29.885 -43.759  16.722  1.00  0.00           N  
ATOM      2  CA  GLY A   1      31.257 -44.181  16.511  1.00  0.00           C  
ATOM      3  C   GLY A   1      32.170 -43.776  17.650  1.00  0.00           C  
ATOM      4  O   GLY A   1      32.172 -44.405  18.708  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      31.281 -45.257  16.410  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      31.622 -43.736  15.596  1.00  0.00           H  
ATOM      7  H1  GLY A   1      29.693 -43.008  17.321  1.00  0.00           H  
ATOM      8  N   SER A   2      32.952 -42.722  17.434  1.00  0.00           N  
ATOM      9  CA  SER A   2      33.879 -42.236  18.449  1.00  0.00           C  
ATOM     10  C   SER A   2      33.903 -40.711  18.477  1.00  0.00           C  
ATOM     11  O   SER A   2      34.111 -40.064  17.451  1.00  0.00           O  
ATOM     12  CB  SER A   2      35.286 -42.776  18.186  1.00  0.00           C  
ATOM     13  OG  SER A   2      35.399 -44.127  18.598  1.00  0.00           O  
ATOM     14  H   SER A   2      32.905 -42.262  16.569  1.00  0.00           H  
ATOM     15  HA  SER A   2      33.538 -42.597  19.408  1.00  0.00           H  
ATOM     16  HB2 SER A   2      35.500 -42.715  17.130  1.00  0.00           H  
ATOM     17  HB3 SER A   2      36.004 -42.183  18.733  1.00  0.00           H  
ATOM     18  HG  SER A   2      35.159 -44.200  19.524  1.00  0.00           H  
ATOM     19  N   SER A   3      33.689 -40.143  19.660  1.00  0.00           N  
ATOM     20  CA  SER A   3      33.683 -38.694  19.823  1.00  0.00           C  
ATOM     21  C   SER A   3      35.060 -38.189  20.239  1.00  0.00           C  
ATOM     22  O   SER A   3      35.708 -38.766  21.111  1.00  0.00           O  
ATOM     23  CB  SER A   3      32.638 -38.282  20.862  1.00  0.00           C  
ATOM     24  OG  SER A   3      32.239 -36.935  20.676  1.00  0.00           O  
ATOM     25  H   SER A   3      33.528 -40.713  20.441  1.00  0.00           H  
ATOM     26  HA  SER A   3      33.423 -38.255  18.870  1.00  0.00           H  
ATOM     27  HB2 SER A   3      31.771 -38.917  20.770  1.00  0.00           H  
ATOM     28  HB3 SER A   3      33.058 -38.387  21.851  1.00  0.00           H  
ATOM     29  HG  SER A   3      31.660 -36.670  21.395  1.00  0.00           H  
ATOM     30  N   GLY A   4      35.501 -37.103  19.610  1.00  0.00           N  
ATOM     31  CA  GLY A   4      36.797 -36.536  19.928  1.00  0.00           C  
ATOM     32  C   GLY A   4      37.787 -36.676  18.788  1.00  0.00           C  
ATOM     33  O   GLY A   4      38.849 -37.277  18.948  1.00  0.00           O  
ATOM     34  H   GLY A   4      34.940 -36.684  18.924  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      36.674 -35.489  20.158  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      37.195 -37.041  20.797  1.00  0.00           H  
ATOM     37  N   SER A   5      37.437 -36.119  17.632  1.00  0.00           N  
ATOM     38  CA  SER A   5      38.300 -36.190  16.459  1.00  0.00           C  
ATOM     39  C   SER A   5      38.308 -34.861  15.711  1.00  0.00           C  
ATOM     40  O   SER A   5      37.256 -34.332  15.349  1.00  0.00           O  
ATOM     41  CB  SER A   5      37.836 -37.310  15.525  1.00  0.00           C  
ATOM     42  OG  SER A   5      38.805 -37.572  14.523  1.00  0.00           O  
ATOM     43  H   SER A   5      36.577 -35.654  17.567  1.00  0.00           H  
ATOM     44  HA  SER A   5      39.302 -36.405  16.797  1.00  0.00           H  
ATOM     45  HB2 SER A   5      37.678 -38.210  16.099  1.00  0.00           H  
ATOM     46  HB3 SER A   5      36.911 -37.018  15.049  1.00  0.00           H  
ATOM     47  HG  SER A   5      38.497 -38.285  13.960  1.00  0.00           H  
ATOM     48  N   SER A   6      39.502 -34.324  15.482  1.00  0.00           N  
ATOM     49  CA  SER A   6      39.650 -33.054  14.781  1.00  0.00           C  
ATOM     50  C   SER A   6      39.404 -33.228  13.285  1.00  0.00           C  
ATOM     51  O   SER A   6      39.718 -34.270  12.710  1.00  0.00           O  
ATOM     52  CB  SER A   6      41.046 -32.476  15.017  1.00  0.00           C  
ATOM     53  OG  SER A   6      42.034 -33.242  14.352  1.00  0.00           O  
ATOM     54  H   SER A   6      40.304 -34.793  15.795  1.00  0.00           H  
ATOM     55  HA  SER A   6      38.914 -32.370  15.177  1.00  0.00           H  
ATOM     56  HB2 SER A   6      41.081 -31.463  14.643  1.00  0.00           H  
ATOM     57  HB3 SER A   6      41.259 -32.476  16.076  1.00  0.00           H  
ATOM     58  HG  SER A   6      41.760 -33.402  13.446  1.00  0.00           H  
ATOM     59  N   GLY A   7      38.841 -32.198  12.660  1.00  0.00           N  
ATOM     60  CA  GLY A   7      38.564 -32.256  11.237  1.00  0.00           C  
ATOM     61  C   GLY A   7      37.280 -31.539  10.867  1.00  0.00           C  
ATOM     62  O   GLY A   7      36.558 -31.053  11.738  1.00  0.00           O  
ATOM     63  H   GLY A   7      38.613 -31.393  13.169  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      39.384 -31.803  10.702  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      38.482 -33.291  10.940  1.00  0.00           H  
ATOM     66  N   LYS A   8      36.995 -31.469   9.570  1.00  0.00           N  
ATOM     67  CA  LYS A   8      35.792 -30.805   9.086  1.00  0.00           C  
ATOM     68  C   LYS A   8      35.424 -31.296   7.689  1.00  0.00           C  
ATOM     69  O   LYS A   8      36.240 -31.242   6.768  1.00  0.00           O  
ATOM     70  CB  LYS A   8      35.992 -29.288   9.070  1.00  0.00           C  
ATOM     71  CG  LYS A   8      34.743 -28.514   8.684  1.00  0.00           C  
ATOM     72  CD  LYS A   8      33.706 -28.540   9.796  1.00  0.00           C  
ATOM     73  CE  LYS A   8      32.297 -28.374   9.246  1.00  0.00           C  
ATOM     74  NZ  LYS A   8      31.284 -29.040  10.110  1.00  0.00           N  
ATOM     75  H   LYS A   8      37.610 -31.875   8.924  1.00  0.00           H  
ATOM     76  HA  LYS A   8      34.985 -31.046   9.762  1.00  0.00           H  
ATOM     77  HB2 LYS A   8      36.300 -28.967  10.053  1.00  0.00           H  
ATOM     78  HB3 LYS A   8      36.772 -29.048   8.361  1.00  0.00           H  
ATOM     79  HG2 LYS A   8      35.014 -27.488   8.484  1.00  0.00           H  
ATOM     80  HG3 LYS A   8      34.317 -28.956   7.796  1.00  0.00           H  
ATOM     81  HD2 LYS A   8      33.769 -29.485  10.312  1.00  0.00           H  
ATOM     82  HD3 LYS A   8      33.911 -27.735  10.486  1.00  0.00           H  
ATOM     83  HE2 LYS A   8      32.071 -27.321   9.186  1.00  0.00           H  
ATOM     84  HE3 LYS A   8      32.257 -28.807   8.258  1.00  0.00           H  
ATOM     85  HZ1 LYS A   8      31.746 -29.477  10.932  1.00  0.00           H  
ATOM     86  HZ2 LYS A   8      30.787 -29.778   9.572  1.00  0.00           H  
ATOM     87  HZ3 LYS A   8      30.588 -28.344  10.446  1.00  0.00           H  
ATOM     88  N   VAL A   9      34.193 -31.772   7.538  1.00  0.00           N  
ATOM     89  CA  VAL A   9      33.718 -32.269   6.253  1.00  0.00           C  
ATOM     90  C   VAL A   9      32.581 -31.406   5.716  1.00  0.00           C  
ATOM     91  O   VAL A   9      31.732 -30.937   6.475  1.00  0.00           O  
ATOM     92  CB  VAL A   9      33.234 -33.727   6.359  1.00  0.00           C  
ATOM     93  CG1 VAL A   9      32.088 -33.839   7.352  1.00  0.00           C  
ATOM     94  CG2 VAL A   9      32.820 -34.252   4.992  1.00  0.00           C  
ATOM     95  H   VAL A   9      33.589 -31.788   8.310  1.00  0.00           H  
ATOM     96  HA  VAL A   9      34.542 -32.235   5.556  1.00  0.00           H  
ATOM     97  HB  VAL A   9      34.054 -34.332   6.720  1.00  0.00           H  
ATOM     98 HG11 VAL A   9      32.028 -32.933   7.936  1.00  0.00           H  
ATOM     99 HG12 VAL A   9      31.161 -33.986   6.817  1.00  0.00           H  
ATOM    100 HG13 VAL A   9      32.261 -34.679   8.009  1.00  0.00           H  
ATOM    101 HG21 VAL A   9      31.743 -34.317   4.944  1.00  0.00           H  
ATOM    102 HG22 VAL A   9      33.174 -33.578   4.225  1.00  0.00           H  
ATOM    103 HG23 VAL A   9      33.248 -35.231   4.837  1.00  0.00           H  
ATOM    104  N   TRP A  10      32.570 -31.201   4.404  1.00  0.00           N  
ATOM    105  CA  TRP A  10      31.537 -30.395   3.765  1.00  0.00           C  
ATOM    106  C   TRP A  10      30.383 -31.269   3.286  1.00  0.00           C  
ATOM    107  O   TRP A  10      30.522 -32.486   3.162  1.00  0.00           O  
ATOM    108  CB  TRP A  10      32.124 -29.615   2.588  1.00  0.00           C  
ATOM    109  CG  TRP A  10      33.158 -28.610   2.999  1.00  0.00           C  
ATOM    110  CD1 TRP A  10      34.488 -28.629   2.687  1.00  0.00           C  
ATOM    111  CD2 TRP A  10      32.948 -27.442   3.798  1.00  0.00           C  
ATOM    112  NE1 TRP A  10      35.117 -27.541   3.244  1.00  0.00           N  
ATOM    113  CE2 TRP A  10      34.193 -26.797   3.930  1.00  0.00           C  
ATOM    114  CE3 TRP A  10      31.828 -26.874   4.412  1.00  0.00           C  
ATOM    115  CZ2 TRP A  10      34.349 -25.617   4.652  1.00  0.00           C  
ATOM    116  CZ3 TRP A  10      31.983 -25.704   5.130  1.00  0.00           C  
ATOM    117  CH2 TRP A  10      33.235 -25.084   5.245  1.00  0.00           C  
ATOM    118  H   TRP A  10      33.274 -31.602   3.851  1.00  0.00           H  
ATOM    119  HA  TRP A  10      31.162 -29.696   4.498  1.00  0.00           H  
ATOM    120  HB2 TRP A  10      32.586 -30.307   1.900  1.00  0.00           H  
ATOM    121  HB3 TRP A  10      31.328 -29.087   2.082  1.00  0.00           H  
ATOM    122  HD1 TRP A  10      34.962 -29.393   2.090  1.00  0.00           H  
ATOM    123  HE1 TRP A  10      36.071 -27.333   3.163  1.00  0.00           H  
ATOM    124  HE3 TRP A  10      30.855 -27.337   4.336  1.00  0.00           H  
ATOM    125  HZ2 TRP A  10      35.306 -25.128   4.750  1.00  0.00           H  
ATOM    126  HZ3 TRP A  10      31.129 -25.251   5.612  1.00  0.00           H  
ATOM    127  HH2 TRP A  10      33.310 -24.171   5.814  1.00  0.00           H  
ATOM    128  N   LYS A  11      29.242 -30.642   3.017  1.00  0.00           N  
ATOM    129  CA  LYS A  11      28.064 -31.362   2.550  1.00  0.00           C  
ATOM    130  C   LYS A  11      27.156 -30.447   1.733  1.00  0.00           C  
ATOM    131  O   LYS A  11      27.159 -29.226   1.894  1.00  0.00           O  
ATOM    132  CB  LYS A  11      27.290 -31.938   3.737  1.00  0.00           C  
ATOM    133  CG  LYS A  11      28.170 -32.288   4.924  1.00  0.00           C  
ATOM    134  CD  LYS A  11      27.355 -32.864   6.071  1.00  0.00           C  
ATOM    135  CE  LYS A  11      26.632 -34.136   5.656  1.00  0.00           C  
ATOM    136  NZ  LYS A  11      25.914 -34.764   6.800  1.00  0.00           N  
ATOM    137  H   LYS A  11      29.193 -29.669   3.135  1.00  0.00           H  
ATOM    138  HA  LYS A  11      28.399 -32.172   1.920  1.00  0.00           H  
ATOM    139  HB2 LYS A  11      26.557 -31.215   4.059  1.00  0.00           H  
ATOM    140  HB3 LYS A  11      26.780 -32.836   3.416  1.00  0.00           H  
ATOM    141  HG2 LYS A  11      28.903 -33.019   4.616  1.00  0.00           H  
ATOM    142  HG3 LYS A  11      28.671 -31.393   5.265  1.00  0.00           H  
ATOM    143  HD2 LYS A  11      28.018 -33.093   6.893  1.00  0.00           H  
ATOM    144  HD3 LYS A  11      26.626 -32.132   6.386  1.00  0.00           H  
ATOM    145  HE2 LYS A  11      25.919 -33.894   4.883  1.00  0.00           H  
ATOM    146  HE3 LYS A  11      27.357 -34.838   5.270  1.00  0.00           H  
ATOM    147  HZ1 LYS A  11      24.890 -34.597   6.714  1.00  0.00           H  
ATOM    148  HZ2 LYS A  11      26.245 -34.356   7.697  1.00  0.00           H  
ATOM    149  HZ3 LYS A  11      26.086 -35.790   6.812  1.00  0.00           H  
ATOM    150  N   PRO A  12      26.360 -31.049   0.838  1.00  0.00           N  
ATOM    151  CA  PRO A  12      25.430 -30.307  -0.019  1.00  0.00           C  
ATOM    152  C   PRO A  12      24.264 -29.715   0.765  1.00  0.00           C  
ATOM    153  O   PRO A  12      23.301 -30.409   1.084  1.00  0.00           O  
ATOM    154  CB  PRO A  12      24.928 -31.368  -1.001  1.00  0.00           C  
ATOM    155  CG  PRO A  12      25.088 -32.661  -0.276  1.00  0.00           C  
ATOM    156  CD  PRO A  12      26.304 -32.500   0.594  1.00  0.00           C  
ATOM    157  HA  PRO A  12      25.933 -29.521  -0.563  1.00  0.00           H  
ATOM    158  HB2 PRO A  12      23.893 -31.177  -1.244  1.00  0.00           H  
ATOM    159  HB3 PRO A  12      25.526 -31.345  -1.899  1.00  0.00           H  
ATOM    160  HG2 PRO A  12      24.216 -32.851   0.330  1.00  0.00           H  
ATOM    161  HG3 PRO A  12      25.237 -33.463  -0.984  1.00  0.00           H  
ATOM    162  HD2 PRO A  12      26.180 -33.042   1.519  1.00  0.00           H  
ATOM    163  HD3 PRO A  12      27.188 -32.836   0.072  1.00  0.00           H  
ATOM    164  N   GLY A  13      24.360 -28.424   1.075  1.00  0.00           N  
ATOM    165  CA  GLY A  13      23.306 -27.760   1.821  1.00  0.00           C  
ATOM    166  C   GLY A  13      23.826 -27.061   3.061  1.00  0.00           C  
ATOM    167  O   GLY A  13      23.120 -26.958   4.065  1.00  0.00           O  
ATOM    168  H   GLY A  13      25.152 -27.921   0.796  1.00  0.00           H  
ATOM    169  HA2 GLY A  13      22.832 -27.031   1.180  1.00  0.00           H  
ATOM    170  HA3 GLY A  13      22.573 -28.496   2.117  1.00  0.00           H  
ATOM    171  N   ASP A  14      25.063 -26.581   2.993  1.00  0.00           N  
ATOM    172  CA  ASP A  14      25.677 -25.888   4.119  1.00  0.00           C  
ATOM    173  C   ASP A  14      26.321 -24.582   3.668  1.00  0.00           C  
ATOM    174  O   ASP A  14      27.102 -24.560   2.718  1.00  0.00           O  
ATOM    175  CB  ASP A  14      26.722 -26.783   4.787  1.00  0.00           C  
ATOM    176  CG  ASP A  14      26.096 -27.864   5.647  1.00  0.00           C  
ATOM    177  OD1 ASP A  14      25.229 -28.600   5.134  1.00  0.00           O  
ATOM    178  OD2 ASP A  14      26.474 -27.972   6.833  1.00  0.00           O  
ATOM    179  H   ASP A  14      25.575 -26.696   2.165  1.00  0.00           H  
ATOM    180  HA  ASP A  14      24.900 -25.664   4.834  1.00  0.00           H  
ATOM    181  HB2 ASP A  14      27.321 -27.259   4.024  1.00  0.00           H  
ATOM    182  HB3 ASP A  14      27.361 -26.175   5.412  1.00  0.00           H  
ATOM    183  N   GLU A  15      25.987 -23.494   4.356  1.00  0.00           N  
ATOM    184  CA  GLU A  15      26.532 -22.182   4.024  1.00  0.00           C  
ATOM    185  C   GLU A  15      28.001 -22.088   4.423  1.00  0.00           C  
ATOM    186  O   GLU A  15      28.364 -22.363   5.567  1.00  0.00           O  
ATOM    187  CB  GLU A  15      25.730 -21.081   4.720  1.00  0.00           C  
ATOM    188  CG  GLU A  15      25.724 -21.198   6.235  1.00  0.00           C  
ATOM    189  CD  GLU A  15      24.461 -20.636   6.858  1.00  0.00           C  
ATOM    190  OE1 GLU A  15      23.439 -20.544   6.146  1.00  0.00           O  
ATOM    191  OE2 GLU A  15      24.494 -20.288   8.057  1.00  0.00           O  
ATOM    192  H   GLU A  15      25.359 -23.575   5.104  1.00  0.00           H  
ATOM    193  HA  GLU A  15      26.452 -22.052   2.955  1.00  0.00           H  
ATOM    194  HB2 GLU A  15      26.152 -20.124   4.455  1.00  0.00           H  
ATOM    195  HB3 GLU A  15      24.708 -21.122   4.372  1.00  0.00           H  
ATOM    196  HG2 GLU A  15      25.806 -22.241   6.503  1.00  0.00           H  
ATOM    197  HG3 GLU A  15      26.573 -20.658   6.628  1.00  0.00           H  
ATOM    198  N   CYS A  16      28.842 -21.696   3.472  1.00  0.00           N  
ATOM    199  CA  CYS A  16      30.274 -21.566   3.723  1.00  0.00           C  
ATOM    200  C   CYS A  16      30.860 -20.401   2.933  1.00  0.00           C  
ATOM    201  O   CYS A  16      30.186 -19.806   2.091  1.00  0.00           O  
ATOM    202  CB  CYS A  16      30.997 -22.862   3.354  1.00  0.00           C  
ATOM    203  SG  CYS A  16      30.854 -23.319   1.611  1.00  0.00           S  
ATOM    204  H   CYS A  16      28.493 -21.492   2.579  1.00  0.00           H  
ATOM    205  HA  CYS A  16      30.408 -21.375   4.776  1.00  0.00           H  
ATOM    206  HB2 CYS A  16      32.048 -22.756   3.580  1.00  0.00           H  
ATOM    207  HB3 CYS A  16      30.590 -23.671   3.943  1.00  0.00           H  
ATOM    208  HG  CYS A  16      29.568 -23.469   1.332  1.00  0.00           H  
ATOM    209  N   PHE A  17      32.118 -20.077   3.211  1.00  0.00           N  
ATOM    210  CA  PHE A  17      32.795 -18.981   2.529  1.00  0.00           C  
ATOM    211  C   PHE A  17      33.785 -19.511   1.497  1.00  0.00           C  
ATOM    212  O   PHE A  17      34.724 -20.231   1.834  1.00  0.00           O  
ATOM    213  CB  PHE A  17      33.523 -18.094   3.541  1.00  0.00           C  
ATOM    214  CG  PHE A  17      32.654 -17.017   4.128  1.00  0.00           C  
ATOM    215  CD1 PHE A  17      31.694 -17.325   5.078  1.00  0.00           C  
ATOM    216  CD2 PHE A  17      32.799 -15.698   3.731  1.00  0.00           C  
ATOM    217  CE1 PHE A  17      30.892 -16.337   5.619  1.00  0.00           C  
ATOM    218  CE2 PHE A  17      32.002 -14.705   4.268  1.00  0.00           C  
ATOM    219  CZ  PHE A  17      31.048 -15.025   5.214  1.00  0.00           C  
ATOM    220  H   PHE A  17      32.603 -20.589   3.892  1.00  0.00           H  
ATOM    221  HA  PHE A  17      32.044 -18.393   2.022  1.00  0.00           H  
ATOM    222  HB2 PHE A  17      33.883 -18.707   4.353  1.00  0.00           H  
ATOM    223  HB3 PHE A  17      34.360 -17.618   3.054  1.00  0.00           H  
ATOM    224  HD1 PHE A  17      31.571 -18.350   5.396  1.00  0.00           H  
ATOM    225  HD2 PHE A  17      33.546 -15.447   2.990  1.00  0.00           H  
ATOM    226  HE1 PHE A  17      30.149 -16.589   6.359  1.00  0.00           H  
ATOM    227  HE2 PHE A  17      32.126 -13.681   3.949  1.00  0.00           H  
ATOM    228  HZ  PHE A  17      30.423 -14.251   5.636  1.00  0.00           H  
ATOM    229  N   ALA A  18      33.566 -19.150   0.236  1.00  0.00           N  
ATOM    230  CA  ALA A  18      34.440 -19.587  -0.846  1.00  0.00           C  
ATOM    231  C   ALA A  18      35.195 -18.409  -1.452  1.00  0.00           C  
ATOM    232  O   ALA A  18      34.649 -17.315  -1.592  1.00  0.00           O  
ATOM    233  CB  ALA A  18      33.633 -20.307  -1.916  1.00  0.00           C  
ATOM    234  H   ALA A  18      32.801 -18.575   0.029  1.00  0.00           H  
ATOM    235  HA  ALA A  18      35.154 -20.287  -0.437  1.00  0.00           H  
ATOM    236  HB1 ALA A  18      34.307 -20.806  -2.598  1.00  0.00           H  
ATOM    237  HB2 ALA A  18      32.987 -21.036  -1.451  1.00  0.00           H  
ATOM    238  HB3 ALA A  18      33.037 -19.590  -2.460  1.00  0.00           H  
ATOM    239  N   LEU A  19      36.454 -18.641  -1.811  1.00  0.00           N  
ATOM    240  CA  LEU A  19      37.284 -17.598  -2.402  1.00  0.00           C  
ATOM    241  C   LEU A  19      36.958 -17.414  -3.881  1.00  0.00           C  
ATOM    242  O   LEU A  19      37.168 -18.318  -4.690  1.00  0.00           O  
ATOM    243  CB  LEU A  19      38.765 -17.942  -2.235  1.00  0.00           C  
ATOM    244  CG  LEU A  19      39.721 -16.755  -2.117  1.00  0.00           C  
ATOM    245  CD1 LEU A  19      39.541 -16.054  -0.780  1.00  0.00           C  
ATOM    246  CD2 LEU A  19      41.162 -17.211  -2.291  1.00  0.00           C  
ATOM    247  H   LEU A  19      36.834 -19.534  -1.675  1.00  0.00           H  
ATOM    248  HA  LEU A  19      37.077 -16.674  -1.883  1.00  0.00           H  
ATOM    249  HB2 LEU A  19      38.868 -18.537  -1.340  1.00  0.00           H  
ATOM    250  HB3 LEU A  19      39.067 -18.529  -3.091  1.00  0.00           H  
ATOM    251  HG  LEU A  19      39.498 -16.042  -2.899  1.00  0.00           H  
ATOM    252 HD11 LEU A  19      40.461 -16.106  -0.219  1.00  0.00           H  
ATOM    253 HD12 LEU A  19      38.752 -16.538  -0.223  1.00  0.00           H  
ATOM    254 HD13 LEU A  19      39.280 -15.019  -0.948  1.00  0.00           H  
ATOM    255 HD21 LEU A  19      41.178 -18.175  -2.779  1.00  0.00           H  
ATOM    256 HD22 LEU A  19      41.635 -17.289  -1.323  1.00  0.00           H  
ATOM    257 HD23 LEU A  19      41.697 -16.493  -2.897  1.00  0.00           H  
ATOM    258  N   TYR A  20      36.445 -16.239  -4.226  1.00  0.00           N  
ATOM    259  CA  TYR A  20      36.089 -15.936  -5.607  1.00  0.00           C  
ATOM    260  C   TYR A  20      37.254 -16.234  -6.547  1.00  0.00           C  
ATOM    261  O   TYR A  20      38.416 -16.205  -6.143  1.00  0.00           O  
ATOM    262  CB  TYR A  20      35.674 -14.470  -5.740  1.00  0.00           C  
ATOM    263  CG  TYR A  20      34.727 -14.211  -6.889  1.00  0.00           C  
ATOM    264  CD1 TYR A  20      33.632 -15.036  -7.112  1.00  0.00           C  
ATOM    265  CD2 TYR A  20      34.925 -13.138  -7.750  1.00  0.00           C  
ATOM    266  CE1 TYR A  20      32.764 -14.803  -8.162  1.00  0.00           C  
ATOM    267  CE2 TYR A  20      34.061 -12.896  -8.801  1.00  0.00           C  
ATOM    268  CZ  TYR A  20      32.982 -13.732  -9.003  1.00  0.00           C  
ATOM    269  OH  TYR A  20      32.119 -13.495 -10.047  1.00  0.00           O  
ATOM    270  H   TYR A  20      36.301 -15.559  -3.536  1.00  0.00           H  
ATOM    271  HA  TYR A  20      35.252 -16.563  -5.879  1.00  0.00           H  
ATOM    272  HB2 TYR A  20      35.186 -14.158  -4.830  1.00  0.00           H  
ATOM    273  HB3 TYR A  20      36.557 -13.866  -5.895  1.00  0.00           H  
ATOM    274  HD1 TYR A  20      33.464 -15.874  -6.451  1.00  0.00           H  
ATOM    275  HD2 TYR A  20      35.772 -12.486  -7.589  1.00  0.00           H  
ATOM    276  HE1 TYR A  20      31.919 -15.456  -8.319  1.00  0.00           H  
ATOM    277  HE2 TYR A  20      34.232 -12.058  -9.461  1.00  0.00           H  
ATOM    278  HH  TYR A  20      31.396 -14.125 -10.014  1.00  0.00           H  
ATOM    279  N   TRP A  21      36.932 -16.521  -7.803  1.00  0.00           N  
ATOM    280  CA  TRP A  21      37.950 -16.824  -8.803  1.00  0.00           C  
ATOM    281  C   TRP A  21      38.379 -15.562  -9.544  1.00  0.00           C  
ATOM    282  O   TRP A  21      39.292 -15.596 -10.368  1.00  0.00           O  
ATOM    283  CB  TRP A  21      37.425 -17.860  -9.798  1.00  0.00           C  
ATOM    284  CG  TRP A  21      36.313 -17.345 -10.661  1.00  0.00           C  
ATOM    285  CD1 TRP A  21      34.973 -17.443 -10.416  1.00  0.00           C  
ATOM    286  CD2 TRP A  21      36.445 -16.655 -11.908  1.00  0.00           C  
ATOM    287  NE1 TRP A  21      34.265 -16.854 -11.436  1.00  0.00           N  
ATOM    288  CE2 TRP A  21      35.145 -16.362 -12.363  1.00  0.00           C  
ATOM    289  CE3 TRP A  21      37.536 -16.252 -12.684  1.00  0.00           C  
ATOM    290  CZ2 TRP A  21      34.908 -15.688 -13.558  1.00  0.00           C  
ATOM    291  CZ3 TRP A  21      37.299 -15.585 -13.870  1.00  0.00           C  
ATOM    292  CH2 TRP A  21      35.995 -15.307 -14.297  1.00  0.00           C  
ATOM    293  H   TRP A  21      35.987 -16.529  -8.066  1.00  0.00           H  
ATOM    294  HA  TRP A  21      38.806 -17.234  -8.289  1.00  0.00           H  
ATOM    295  HB2 TRP A  21      38.232 -18.170 -10.445  1.00  0.00           H  
ATOM    296  HB3 TRP A  21      37.055 -18.716  -9.253  1.00  0.00           H  
ATOM    297  HD1 TRP A  21      34.547 -17.917  -9.546  1.00  0.00           H  
ATOM    298  HE1 TRP A  21      33.287 -16.795 -11.488  1.00  0.00           H  
ATOM    299  HE3 TRP A  21      38.550 -16.457 -12.371  1.00  0.00           H  
ATOM    300  HZ2 TRP A  21      33.908 -15.467 -13.901  1.00  0.00           H  
ATOM    301  HZ3 TRP A  21      38.131 -15.267 -14.483  1.00  0.00           H  
ATOM    302  HH2 TRP A  21      35.857 -14.783 -15.231  1.00  0.00           H  
ATOM    303  N   GLU A  22      37.714 -14.450  -9.245  1.00  0.00           N  
ATOM    304  CA  GLU A  22      38.027 -13.178  -9.884  1.00  0.00           C  
ATOM    305  C   GLU A  22      38.376 -12.117  -8.843  1.00  0.00           C  
ATOM    306  O   GLU A  22      38.902 -11.056  -9.175  1.00  0.00           O  
ATOM    307  CB  GLU A  22      36.846 -12.705 -10.735  1.00  0.00           C  
ATOM    308  CG  GLU A  22      36.875 -13.231 -12.160  1.00  0.00           C  
ATOM    309  CD  GLU A  22      36.127 -12.335 -13.128  1.00  0.00           C  
ATOM    310  OE1 GLU A  22      34.943 -12.035 -12.866  1.00  0.00           O  
ATOM    311  OE2 GLU A  22      36.726 -11.935 -14.148  1.00  0.00           O  
ATOM    312  H   GLU A  22      36.995 -14.487  -8.579  1.00  0.00           H  
ATOM    313  HA  GLU A  22      38.882 -13.330 -10.524  1.00  0.00           H  
ATOM    314  HB2 GLU A  22      35.929 -13.031 -10.269  1.00  0.00           H  
ATOM    315  HB3 GLU A  22      36.857 -11.625 -10.773  1.00  0.00           H  
ATOM    316  HG2 GLU A  22      37.902 -13.307 -12.483  1.00  0.00           H  
ATOM    317  HG3 GLU A  22      36.421 -14.212 -12.177  1.00  0.00           H  
ATOM    318  N   ASP A  23      38.075 -12.413  -7.583  1.00  0.00           N  
ATOM    319  CA  ASP A  23      38.356 -11.486  -6.493  1.00  0.00           C  
ATOM    320  C   ASP A  23      39.294 -12.119  -5.470  1.00  0.00           C  
ATOM    321  O   ASP A  23      39.935 -11.421  -4.686  1.00  0.00           O  
ATOM    322  CB  ASP A  23      37.054 -11.055  -5.813  1.00  0.00           C  
ATOM    323  CG  ASP A  23      37.235  -9.824  -4.948  1.00  0.00           C  
ATOM    324  OD1 ASP A  23      38.247  -9.751  -4.221  1.00  0.00           O  
ATOM    325  OD2 ASP A  23      36.362  -8.932  -4.997  1.00  0.00           O  
ATOM    326  H   ASP A  23      37.656 -13.276  -7.382  1.00  0.00           H  
ATOM    327  HA  ASP A  23      38.837 -10.616  -6.913  1.00  0.00           H  
ATOM    328  HB2 ASP A  23      36.317 -10.835  -6.571  1.00  0.00           H  
ATOM    329  HB3 ASP A  23      36.697 -11.862  -5.191  1.00  0.00           H  
ATOM    330  N   ASN A  24      39.366 -13.446  -5.483  1.00  0.00           N  
ATOM    331  CA  ASN A  24      40.224 -14.174  -4.554  1.00  0.00           C  
ATOM    332  C   ASN A  24      39.953 -13.747  -3.115  1.00  0.00           C  
ATOM    333  O   ASN A  24      40.831 -13.827  -2.255  1.00  0.00           O  
ATOM    334  CB  ASN A  24      41.696 -13.940  -4.899  1.00  0.00           C  
ATOM    335  CG  ASN A  24      42.190 -12.584  -4.436  1.00  0.00           C  
ATOM    336  OD1 ASN A  24      42.471 -12.383  -3.254  1.00  0.00           O  
ATOM    337  ND2 ASN A  24      42.298 -11.644  -5.368  1.00  0.00           N  
ATOM    338  H   ASN A  24      38.830 -13.949  -6.131  1.00  0.00           H  
ATOM    339  HA  ASN A  24      40.002 -15.225  -4.653  1.00  0.00           H  
ATOM    340  HB2 ASN A  24      42.296 -14.703  -4.422  1.00  0.00           H  
ATOM    341  HB3 ASN A  24      41.825 -14.005  -5.968  1.00  0.00           H  
ATOM    342 HD21 ASN A  24      42.057 -11.875  -6.289  1.00  0.00           H  
ATOM    343 HD22 ASN A  24      42.616 -10.757  -5.096  1.00  0.00           H  
ATOM    344  N   LYS A  25      38.731 -13.293  -2.858  1.00  0.00           N  
ATOM    345  CA  LYS A  25      38.342 -12.855  -1.523  1.00  0.00           C  
ATOM    346  C   LYS A  25      37.282 -13.781  -0.934  1.00  0.00           C  
ATOM    347  O   LYS A  25      36.447 -14.325  -1.656  1.00  0.00           O  
ATOM    348  CB  LYS A  25      37.811 -11.421  -1.570  1.00  0.00           C  
ATOM    349  CG  LYS A  25      38.905 -10.368  -1.614  1.00  0.00           C  
ATOM    350  CD  LYS A  25      39.504 -10.128  -0.239  1.00  0.00           C  
ATOM    351  CE  LYS A  25      40.592  -9.065  -0.283  1.00  0.00           C  
ATOM    352  NZ  LYS A  25      41.243  -8.883   1.044  1.00  0.00           N  
ATOM    353  H   LYS A  25      38.074 -13.252  -3.585  1.00  0.00           H  
ATOM    354  HA  LYS A  25      39.219 -12.885  -0.895  1.00  0.00           H  
ATOM    355  HB2 LYS A  25      37.193 -11.306  -2.448  1.00  0.00           H  
ATOM    356  HB3 LYS A  25      37.207 -11.245  -0.690  1.00  0.00           H  
ATOM    357  HG2 LYS A  25      39.685 -10.702  -2.281  1.00  0.00           H  
ATOM    358  HG3 LYS A  25      38.486  -9.442  -1.982  1.00  0.00           H  
ATOM    359  HD2 LYS A  25      38.724  -9.800   0.432  1.00  0.00           H  
ATOM    360  HD3 LYS A  25      39.930 -11.052   0.125  1.00  0.00           H  
ATOM    361  HE2 LYS A  25      41.339  -9.363  -1.003  1.00  0.00           H  
ATOM    362  HE3 LYS A  25      40.150  -8.129  -0.590  1.00  0.00           H  
ATOM    363  HZ1 LYS A  25      40.905  -9.607   1.710  1.00  0.00           H  
ATOM    364  HZ2 LYS A  25      41.016  -7.943   1.427  1.00  0.00           H  
ATOM    365  HZ3 LYS A  25      42.275  -8.968   0.950  1.00  0.00           H  
ATOM    366  N   PHE A  26      37.322 -13.957   0.383  1.00  0.00           N  
ATOM    367  CA  PHE A  26      36.366 -14.817   1.069  1.00  0.00           C  
ATOM    368  C   PHE A  26      34.969 -14.201   1.051  1.00  0.00           C  
ATOM    369  O   PHE A  26      34.741 -13.138   1.627  1.00  0.00           O  
ATOM    370  CB  PHE A  26      36.809 -15.059   2.514  1.00  0.00           C  
ATOM    371  CG  PHE A  26      37.968 -16.007   2.634  1.00  0.00           C  
ATOM    372  CD1 PHE A  26      37.904 -17.273   2.076  1.00  0.00           C  
ATOM    373  CD2 PHE A  26      39.120 -15.632   3.305  1.00  0.00           C  
ATOM    374  CE1 PHE A  26      38.968 -18.148   2.187  1.00  0.00           C  
ATOM    375  CE2 PHE A  26      40.188 -16.502   3.417  1.00  0.00           C  
ATOM    376  CZ  PHE A  26      40.113 -17.762   2.857  1.00  0.00           C  
ATOM    377  H   PHE A  26      38.012 -13.496   0.905  1.00  0.00           H  
ATOM    378  HA  PHE A  26      36.337 -15.761   0.548  1.00  0.00           H  
ATOM    379  HB2 PHE A  26      37.104 -14.117   2.954  1.00  0.00           H  
ATOM    380  HB3 PHE A  26      35.982 -15.469   3.072  1.00  0.00           H  
ATOM    381  HD1 PHE A  26      37.011 -17.576   1.550  1.00  0.00           H  
ATOM    382  HD2 PHE A  26      39.181 -14.646   3.744  1.00  0.00           H  
ATOM    383  HE1 PHE A  26      38.906 -19.133   1.746  1.00  0.00           H  
ATOM    384  HE2 PHE A  26      41.081 -16.196   3.943  1.00  0.00           H  
ATOM    385  HZ  PHE A  26      40.945 -18.444   2.944  1.00  0.00           H  
ATOM    386  N   TYR A  27      34.040 -14.877   0.384  1.00  0.00           N  
ATOM    387  CA  TYR A  27      32.667 -14.396   0.287  1.00  0.00           C  
ATOM    388  C   TYR A  27      31.678 -15.491   0.674  1.00  0.00           C  
ATOM    389  O   TYR A  27      31.949 -16.679   0.497  1.00  0.00           O  
ATOM    390  CB  TYR A  27      32.375 -13.908  -1.133  1.00  0.00           C  
ATOM    391  CG  TYR A  27      33.214 -12.720  -1.550  1.00  0.00           C  
ATOM    392  CD1 TYR A  27      33.447 -11.668  -0.673  1.00  0.00           C  
ATOM    393  CD2 TYR A  27      33.773 -12.652  -2.819  1.00  0.00           C  
ATOM    394  CE1 TYR A  27      34.212 -10.581  -1.050  1.00  0.00           C  
ATOM    395  CE2 TYR A  27      34.540 -11.569  -3.204  1.00  0.00           C  
ATOM    396  CZ  TYR A  27      34.757 -10.536  -2.316  1.00  0.00           C  
ATOM    397  OH  TYR A  27      35.520  -9.456  -2.695  1.00  0.00           O  
ATOM    398  H   TYR A  27      34.284 -15.719  -0.055  1.00  0.00           H  
ATOM    399  HA  TYR A  27      32.556 -13.568   0.972  1.00  0.00           H  
ATOM    400  HB2 TYR A  27      32.568 -14.709  -1.829  1.00  0.00           H  
ATOM    401  HB3 TYR A  27      31.336 -13.621  -1.201  1.00  0.00           H  
ATOM    402  HD1 TYR A  27      33.020 -11.706   0.319  1.00  0.00           H  
ATOM    403  HD2 TYR A  27      33.603 -13.462  -3.513  1.00  0.00           H  
ATOM    404  HE1 TYR A  27      34.381  -9.772  -0.354  1.00  0.00           H  
ATOM    405  HE2 TYR A  27      34.967 -11.534  -4.196  1.00  0.00           H  
ATOM    406  HH  TYR A  27      36.285  -9.387  -2.118  1.00  0.00           H  
ATOM    407  N   ARG A  28      30.530 -15.081   1.203  1.00  0.00           N  
ATOM    408  CA  ARG A  28      29.499 -16.027   1.616  1.00  0.00           C  
ATOM    409  C   ARG A  28      29.111 -16.946   0.462  1.00  0.00           C  
ATOM    410  O   ARG A  28      29.199 -16.567  -0.705  1.00  0.00           O  
ATOM    411  CB  ARG A  28      28.265 -15.279   2.122  1.00  0.00           C  
ATOM    412  CG  ARG A  28      27.344 -16.131   2.980  1.00  0.00           C  
ATOM    413  CD  ARG A  28      27.737 -16.073   4.448  1.00  0.00           C  
ATOM    414  NE  ARG A  28      26.705 -16.637   5.314  1.00  0.00           N  
ATOM    415  CZ  ARG A  28      25.513 -16.081   5.493  1.00  0.00           C  
ATOM    416  NH1 ARG A  28      25.202 -14.953   4.869  1.00  0.00           N  
ATOM    417  NH2 ARG A  28      24.627 -16.654   6.297  1.00  0.00           N  
ATOM    418  H   ARG A  28      30.372 -14.121   1.319  1.00  0.00           H  
ATOM    419  HA  ARG A  28      29.901 -16.626   2.419  1.00  0.00           H  
ATOM    420  HB2 ARG A  28      28.587 -14.432   2.712  1.00  0.00           H  
ATOM    421  HB3 ARG A  28      27.701 -14.921   1.274  1.00  0.00           H  
ATOM    422  HG2 ARG A  28      26.332 -15.770   2.876  1.00  0.00           H  
ATOM    423  HG3 ARG A  28      27.400 -17.156   2.642  1.00  0.00           H  
ATOM    424  HD2 ARG A  28      28.653 -16.631   4.583  1.00  0.00           H  
ATOM    425  HD3 ARG A  28      27.901 -15.041   4.722  1.00  0.00           H  
ATOM    426  HE  ARG A  28      26.914 -17.470   5.784  1.00  0.00           H  
ATOM    427 HH11 ARG A  28      25.868 -14.519   4.261  1.00  0.00           H  
ATOM    428 HH12 ARG A  28      24.303 -14.537   5.005  1.00  0.00           H  
ATOM    429 HH21 ARG A  28      24.857 -17.505   6.770  1.00  0.00           H  
ATOM    430 HH22 ARG A  28      23.729 -16.235   6.431  1.00  0.00           H  
ATOM    431  N   ALA A  29      28.681 -18.159   0.797  1.00  0.00           N  
ATOM    432  CA  ALA A  29      28.279 -19.132  -0.210  1.00  0.00           C  
ATOM    433  C   ALA A  29      27.618 -20.347   0.433  1.00  0.00           C  
ATOM    434  O   ALA A  29      27.420 -20.387   1.647  1.00  0.00           O  
ATOM    435  CB  ALA A  29      29.480 -19.560  -1.040  1.00  0.00           C  
ATOM    436  H   ALA A  29      28.634 -18.404   1.745  1.00  0.00           H  
ATOM    437  HA  ALA A  29      27.568 -18.656  -0.870  1.00  0.00           H  
ATOM    438  HB1 ALA A  29      30.029 -18.685  -1.357  1.00  0.00           H  
ATOM    439  HB2 ALA A  29      30.123 -20.192  -0.445  1.00  0.00           H  
ATOM    440  HB3 ALA A  29      29.142 -20.107  -1.908  1.00  0.00           H  
ATOM    441  N   GLU A  30      27.278 -21.334  -0.389  1.00  0.00           N  
ATOM    442  CA  GLU A  30      26.637 -22.549   0.102  1.00  0.00           C  
ATOM    443  C   GLU A  30      27.064 -23.761  -0.723  1.00  0.00           C  
ATOM    444  O   GLU A  30      26.924 -23.773  -1.946  1.00  0.00           O  
ATOM    445  CB  GLU A  30      25.115 -22.401   0.062  1.00  0.00           C  
ATOM    446  CG  GLU A  30      24.371 -23.698   0.331  1.00  0.00           C  
ATOM    447  CD  GLU A  30      24.252 -24.571  -0.903  1.00  0.00           C  
ATOM    448  OE1 GLU A  30      24.293 -24.021  -2.024  1.00  0.00           O  
ATOM    449  OE2 GLU A  30      24.120 -25.803  -0.749  1.00  0.00           O  
ATOM    450  H   GLU A  30      27.461 -21.245  -1.347  1.00  0.00           H  
ATOM    451  HA  GLU A  30      26.948 -22.699   1.125  1.00  0.00           H  
ATOM    452  HB2 GLU A  30      24.816 -21.677   0.805  1.00  0.00           H  
ATOM    453  HB3 GLU A  30      24.826 -22.042  -0.915  1.00  0.00           H  
ATOM    454  HG2 GLU A  30      24.899 -24.250   1.094  1.00  0.00           H  
ATOM    455  HG3 GLU A  30      23.377 -23.462   0.683  1.00  0.00           H  
ATOM    456  N   VAL A  31      27.585 -24.778  -0.045  1.00  0.00           N  
ATOM    457  CA  VAL A  31      28.032 -25.994  -0.713  1.00  0.00           C  
ATOM    458  C   VAL A  31      26.920 -26.591  -1.568  1.00  0.00           C  
ATOM    459  O   VAL A  31      26.024 -27.263  -1.057  1.00  0.00           O  
ATOM    460  CB  VAL A  31      28.508 -27.049   0.302  1.00  0.00           C  
ATOM    461  CG1 VAL A  31      28.826 -28.361  -0.401  1.00  0.00           C  
ATOM    462  CG2 VAL A  31      29.716 -26.541   1.073  1.00  0.00           C  
ATOM    463  H   VAL A  31      27.671 -24.709   0.929  1.00  0.00           H  
ATOM    464  HA  VAL A  31      28.865 -25.737  -1.352  1.00  0.00           H  
ATOM    465  HB  VAL A  31      27.708 -27.229   1.006  1.00  0.00           H  
ATOM    466 HG11 VAL A  31      29.524 -28.928   0.196  1.00  0.00           H  
ATOM    467 HG12 VAL A  31      27.917 -28.929  -0.532  1.00  0.00           H  
ATOM    468 HG13 VAL A  31      29.264 -28.154  -1.366  1.00  0.00           H  
ATOM    469 HG21 VAL A  31      29.451 -26.411   2.111  1.00  0.00           H  
ATOM    470 HG22 VAL A  31      30.522 -27.257   0.994  1.00  0.00           H  
ATOM    471 HG23 VAL A  31      30.035 -25.595   0.661  1.00  0.00           H  
ATOM    472  N   GLU A  32      26.984 -26.341  -2.872  1.00  0.00           N  
ATOM    473  CA  GLU A  32      25.981 -26.854  -3.797  1.00  0.00           C  
ATOM    474  C   GLU A  32      26.130 -28.362  -3.979  1.00  0.00           C  
ATOM    475  O   GLU A  32      25.162 -29.112  -3.848  1.00  0.00           O  
ATOM    476  CB  GLU A  32      26.099 -26.153  -5.153  1.00  0.00           C  
ATOM    477  CG  GLU A  32      24.824 -26.202  -5.977  1.00  0.00           C  
ATOM    478  CD  GLU A  32      24.489 -27.603  -6.451  1.00  0.00           C  
ATOM    479  OE1 GLU A  32      25.426 -28.403  -6.649  1.00  0.00           O  
ATOM    480  OE2 GLU A  32      23.288 -27.899  -6.621  1.00  0.00           O  
ATOM    481  H   GLU A  32      27.723 -25.798  -3.220  1.00  0.00           H  
ATOM    482  HA  GLU A  32      25.008 -26.647  -3.380  1.00  0.00           H  
ATOM    483  HB2 GLU A  32      26.357 -25.117  -4.988  1.00  0.00           H  
ATOM    484  HB3 GLU A  32      26.888 -26.625  -5.721  1.00  0.00           H  
ATOM    485  HG2 GLU A  32      24.006 -25.837  -5.374  1.00  0.00           H  
ATOM    486  HG3 GLU A  32      24.943 -25.565  -6.841  1.00  0.00           H  
ATOM    487  N   ALA A  33      27.347 -28.800  -4.281  1.00  0.00           N  
ATOM    488  CA  ALA A  33      27.623 -30.217  -4.479  1.00  0.00           C  
ATOM    489  C   ALA A  33      29.124 -30.486  -4.502  1.00  0.00           C  
ATOM    490  O   ALA A  33      29.884 -29.768  -5.152  1.00  0.00           O  
ATOM    491  CB  ALA A  33      26.977 -30.706  -5.767  1.00  0.00           C  
ATOM    492  H   ALA A  33      28.078 -28.153  -4.372  1.00  0.00           H  
ATOM    493  HA  ALA A  33      27.183 -30.760  -3.655  1.00  0.00           H  
ATOM    494  HB1 ALA A  33      27.147 -31.767  -5.873  1.00  0.00           H  
ATOM    495  HB2 ALA A  33      25.915 -30.512  -5.733  1.00  0.00           H  
ATOM    496  HB3 ALA A  33      27.412 -30.186  -6.607  1.00  0.00           H  
ATOM    497  N   LEU A  34      29.545 -31.525  -3.789  1.00  0.00           N  
ATOM    498  CA  LEU A  34      30.955 -31.889  -3.727  1.00  0.00           C  
ATOM    499  C   LEU A  34      31.374 -32.660  -4.975  1.00  0.00           C  
ATOM    500  O   LEU A  34      30.534 -33.058  -5.782  1.00  0.00           O  
ATOM    501  CB  LEU A  34      31.232 -32.729  -2.479  1.00  0.00           C  
ATOM    502  CG  LEU A  34      30.730 -32.150  -1.155  1.00  0.00           C  
ATOM    503  CD1 LEU A  34      30.458 -33.262  -0.155  1.00  0.00           C  
ATOM    504  CD2 LEU A  34      31.737 -31.158  -0.592  1.00  0.00           C  
ATOM    505  H   LEU A  34      28.891 -32.060  -3.291  1.00  0.00           H  
ATOM    506  HA  LEU A  34      31.531 -30.976  -3.672  1.00  0.00           H  
ATOM    507  HB2 LEU A  34      30.763 -33.691  -2.617  1.00  0.00           H  
ATOM    508  HB3 LEU A  34      32.302 -32.861  -2.399  1.00  0.00           H  
ATOM    509  HG  LEU A  34      29.801 -31.624  -1.328  1.00  0.00           H  
ATOM    510 HD11 LEU A  34      30.632 -32.897   0.846  1.00  0.00           H  
ATOM    511 HD12 LEU A  34      31.116 -34.095  -0.355  1.00  0.00           H  
ATOM    512 HD13 LEU A  34      29.432 -33.586  -0.246  1.00  0.00           H  
ATOM    513 HD21 LEU A  34      31.258 -30.199  -0.454  1.00  0.00           H  
ATOM    514 HD22 LEU A  34      32.562 -31.052  -1.281  1.00  0.00           H  
ATOM    515 HD23 LEU A  34      32.104 -31.518   0.358  1.00  0.00           H  
ATOM    516  N   HIS A  35      32.679 -32.867  -5.126  1.00  0.00           N  
ATOM    517  CA  HIS A  35      33.210 -33.593  -6.275  1.00  0.00           C  
ATOM    518  C   HIS A  35      33.629 -35.005  -5.879  1.00  0.00           C  
ATOM    519  O   HIS A  35      34.368 -35.195  -4.913  1.00  0.00           O  
ATOM    520  CB  HIS A  35      34.400 -32.842  -6.873  1.00  0.00           C  
ATOM    521  CG  HIS A  35      34.906 -33.442  -8.148  1.00  0.00           C  
ATOM    522  ND1 HIS A  35      36.237 -33.434  -8.507  1.00  0.00           N  
ATOM    523  CD2 HIS A  35      34.251 -34.074  -9.151  1.00  0.00           C  
ATOM    524  CE1 HIS A  35      36.379 -34.032  -9.677  1.00  0.00           C  
ATOM    525  NE2 HIS A  35      35.189 -34.430 -10.088  1.00  0.00           N  
ATOM    526  H   HIS A  35      33.299 -32.526  -4.449  1.00  0.00           H  
ATOM    527  HA  HIS A  35      32.427 -33.659  -7.015  1.00  0.00           H  
ATOM    528  HB2 HIS A  35      34.108 -31.823  -7.079  1.00  0.00           H  
ATOM    529  HB3 HIS A  35      35.212 -32.843  -6.160  1.00  0.00           H  
ATOM    530  HD1 HIS A  35      36.969 -33.046  -7.985  1.00  0.00           H  
ATOM    531  HD2 HIS A  35      33.188 -34.263  -9.205  1.00  0.00           H  
ATOM    532  HE1 HIS A  35      37.309 -34.173 -10.206  1.00  0.00           H  
ATOM    533  HE2 HIS A  35      34.998 -34.825 -10.965  1.00  0.00           H  
ATOM    534  N   SER A  36      33.153 -35.991  -6.630  1.00  0.00           N  
ATOM    535  CA  SER A  36      33.475 -37.388  -6.355  1.00  0.00           C  
ATOM    536  C   SER A  36      34.945 -37.540  -5.971  1.00  0.00           C  
ATOM    537  O   SER A  36      35.270 -38.113  -4.931  1.00  0.00           O  
ATOM    538  CB  SER A  36      33.163 -38.256  -7.576  1.00  0.00           C  
ATOM    539  OG  SER A  36      34.092 -38.023  -8.618  1.00  0.00           O  
ATOM    540  H   SER A  36      32.568 -35.777  -7.387  1.00  0.00           H  
ATOM    541  HA  SER A  36      32.863 -37.711  -5.527  1.00  0.00           H  
ATOM    542  HB2 SER A  36      33.209 -39.296  -7.294  1.00  0.00           H  
ATOM    543  HB3 SER A  36      32.171 -38.023  -7.935  1.00  0.00           H  
ATOM    544  HG  SER A  36      33.773 -37.313  -9.180  1.00  0.00           H  
ATOM    545  N   SER A  37      35.828 -37.022  -6.819  1.00  0.00           N  
ATOM    546  CA  SER A  37      37.262 -37.104  -6.571  1.00  0.00           C  
ATOM    547  C   SER A  37      37.586 -36.741  -5.125  1.00  0.00           C  
ATOM    548  O   SER A  37      38.185 -37.529  -4.396  1.00  0.00           O  
ATOM    549  CB  SER A  37      38.019 -36.175  -7.523  1.00  0.00           C  
ATOM    550  OG  SER A  37      37.950 -36.646  -8.858  1.00  0.00           O  
ATOM    551  H   SER A  37      35.506 -36.578  -7.631  1.00  0.00           H  
ATOM    552  HA  SER A  37      37.573 -38.121  -6.754  1.00  0.00           H  
ATOM    553  HB2 SER A  37      37.584 -35.188  -7.480  1.00  0.00           H  
ATOM    554  HB3 SER A  37      39.056 -36.124  -7.225  1.00  0.00           H  
ATOM    555  HG  SER A  37      37.804 -37.595  -8.855  1.00  0.00           H  
ATOM    556  N   GLY A  38      37.185 -35.541  -4.718  1.00  0.00           N  
ATOM    557  CA  GLY A  38      37.440 -35.094  -3.361  1.00  0.00           C  
ATOM    558  C   GLY A  38      38.465 -33.979  -3.301  1.00  0.00           C  
ATOM    559  O   GLY A  38      39.349 -33.984  -2.446  1.00  0.00           O  
ATOM    560  H   GLY A  38      36.711 -34.954  -5.344  1.00  0.00           H  
ATOM    561  HA2 GLY A  38      36.515 -34.742  -2.930  1.00  0.00           H  
ATOM    562  HA3 GLY A  38      37.802 -35.930  -2.781  1.00  0.00           H  
ATOM    563  N   MET A  39      38.347 -33.020  -4.214  1.00  0.00           N  
ATOM    564  CA  MET A  39      39.271 -31.892  -4.262  1.00  0.00           C  
ATOM    565  C   MET A  39      38.515 -30.574  -4.382  1.00  0.00           C  
ATOM    566  O   MET A  39      38.674 -29.677  -3.553  1.00  0.00           O  
ATOM    567  CB  MET A  39      40.238 -32.048  -5.437  1.00  0.00           C  
ATOM    568  CG  MET A  39      41.420 -32.956  -5.137  1.00  0.00           C  
ATOM    569  SD  MET A  39      42.827 -32.060  -4.448  1.00  0.00           S  
ATOM    570  CE  MET A  39      43.811 -31.796  -5.920  1.00  0.00           C  
ATOM    571  H   MET A  39      37.621 -33.070  -4.872  1.00  0.00           H  
ATOM    572  HA  MET A  39      39.835 -31.889  -3.341  1.00  0.00           H  
ATOM    573  HB2 MET A  39      39.701 -32.460  -6.278  1.00  0.00           H  
ATOM    574  HB3 MET A  39      40.620 -31.074  -5.706  1.00  0.00           H  
ATOM    575  HG2 MET A  39      41.109 -33.707  -4.426  1.00  0.00           H  
ATOM    576  HG3 MET A  39      41.730 -33.436  -6.053  1.00  0.00           H  
ATOM    577  HE1 MET A  39      44.839 -31.618  -5.638  1.00  0.00           H  
ATOM    578  HE2 MET A  39      43.758 -32.672  -6.550  1.00  0.00           H  
ATOM    579  HE3 MET A  39      43.432 -30.941  -6.459  1.00  0.00           H  
ATOM    580  N   THR A  40      37.692 -30.461  -5.420  1.00  0.00           N  
ATOM    581  CA  THR A  40      36.912 -29.251  -5.649  1.00  0.00           C  
ATOM    582  C   THR A  40      35.426 -29.503  -5.422  1.00  0.00           C  
ATOM    583  O   THR A  40      34.978 -30.649  -5.395  1.00  0.00           O  
ATOM    584  CB  THR A  40      37.117 -28.712  -7.076  1.00  0.00           C  
ATOM    585  OG1 THR A  40      36.941 -29.767  -8.029  1.00  0.00           O  
ATOM    586  CG2 THR A  40      38.505 -28.108  -7.233  1.00  0.00           C  
ATOM    587  H   THR A  40      37.608 -31.209  -6.046  1.00  0.00           H  
ATOM    588  HA  THR A  40      37.250 -28.499  -4.951  1.00  0.00           H  
ATOM    589  HB  THR A  40      36.382 -27.941  -7.264  1.00  0.00           H  
ATOM    590  HG1 THR A  40      37.123 -29.435  -8.911  1.00  0.00           H  
ATOM    591 HG21 THR A  40      38.548 -27.166  -6.709  1.00  0.00           H  
ATOM    592 HG22 THR A  40      38.712 -27.948  -8.281  1.00  0.00           H  
ATOM    593 HG23 THR A  40      39.239 -28.783  -6.820  1.00  0.00           H  
ATOM    594  N   ALA A  41      34.665 -28.425  -5.260  1.00  0.00           N  
ATOM    595  CA  ALA A  41      33.229 -28.531  -5.038  1.00  0.00           C  
ATOM    596  C   ALA A  41      32.498 -27.306  -5.580  1.00  0.00           C  
ATOM    597  O   ALA A  41      33.050 -26.207  -5.612  1.00  0.00           O  
ATOM    598  CB  ALA A  41      32.935 -28.710  -3.556  1.00  0.00           C  
ATOM    599  H   ALA A  41      35.081 -27.538  -5.291  1.00  0.00           H  
ATOM    600  HA  ALA A  41      32.874 -29.409  -5.559  1.00  0.00           H  
ATOM    601  HB1 ALA A  41      33.298 -27.850  -3.012  1.00  0.00           H  
ATOM    602  HB2 ALA A  41      31.870 -28.805  -3.409  1.00  0.00           H  
ATOM    603  HB3 ALA A  41      33.429 -29.599  -3.196  1.00  0.00           H  
ATOM    604  N   VAL A  42      31.255 -27.505  -6.005  1.00  0.00           N  
ATOM    605  CA  VAL A  42      30.449 -26.418  -6.546  1.00  0.00           C  
ATOM    606  C   VAL A  42      29.733 -25.659  -5.435  1.00  0.00           C  
ATOM    607  O   VAL A  42      28.842 -26.195  -4.776  1.00  0.00           O  
ATOM    608  CB  VAL A  42      29.405 -26.939  -7.552  1.00  0.00           C  
ATOM    609  CG1 VAL A  42      28.620 -25.783  -8.155  1.00  0.00           C  
ATOM    610  CG2 VAL A  42      30.077 -27.762  -8.639  1.00  0.00           C  
ATOM    611  H   VAL A  42      30.870 -28.405  -5.955  1.00  0.00           H  
ATOM    612  HA  VAL A  42      31.110 -25.739  -7.065  1.00  0.00           H  
ATOM    613  HB  VAL A  42      28.712 -27.577  -7.022  1.00  0.00           H  
ATOM    614 HG11 VAL A  42      28.747 -24.904  -7.541  1.00  0.00           H  
ATOM    615 HG12 VAL A  42      28.983 -25.583  -9.152  1.00  0.00           H  
ATOM    616 HG13 VAL A  42      27.573 -26.043  -8.198  1.00  0.00           H  
ATOM    617 HG21 VAL A  42      31.147 -27.628  -8.582  1.00  0.00           H  
ATOM    618 HG22 VAL A  42      29.838 -28.807  -8.501  1.00  0.00           H  
ATOM    619 HG23 VAL A  42      29.725 -27.438  -9.607  1.00  0.00           H  
ATOM    620  N   VAL A  43      30.129 -24.406  -5.230  1.00  0.00           N  
ATOM    621  CA  VAL A  43      29.524 -23.572  -4.199  1.00  0.00           C  
ATOM    622  C   VAL A  43      28.801 -22.378  -4.812  1.00  0.00           C  
ATOM    623  O   VAL A  43      29.305 -21.739  -5.735  1.00  0.00           O  
ATOM    624  CB  VAL A  43      30.579 -23.062  -3.201  1.00  0.00           C  
ATOM    625  CG1 VAL A  43      31.337 -24.226  -2.582  1.00  0.00           C  
ATOM    626  CG2 VAL A  43      31.535 -22.095  -3.884  1.00  0.00           C  
ATOM    627  H   VAL A  43      30.843 -24.034  -5.788  1.00  0.00           H  
ATOM    628  HA  VAL A  43      28.809 -24.175  -3.659  1.00  0.00           H  
ATOM    629  HB  VAL A  43      30.070 -22.531  -2.409  1.00  0.00           H  
ATOM    630 HG11 VAL A  43      32.196 -24.461  -3.193  1.00  0.00           H  
ATOM    631 HG12 VAL A  43      31.662 -23.956  -1.588  1.00  0.00           H  
ATOM    632 HG13 VAL A  43      30.689 -25.089  -2.528  1.00  0.00           H  
ATOM    633 HG21 VAL A  43      32.553 -22.379  -3.660  1.00  0.00           H  
ATOM    634 HG22 VAL A  43      31.379 -22.128  -4.952  1.00  0.00           H  
ATOM    635 HG23 VAL A  43      31.353 -21.093  -3.525  1.00  0.00           H  
ATOM    636  N   LYS A  44      27.614 -22.082  -4.293  1.00  0.00           N  
ATOM    637  CA  LYS A  44      26.820 -20.964  -4.787  1.00  0.00           C  
ATOM    638  C   LYS A  44      27.116 -19.694  -3.995  1.00  0.00           C  
ATOM    639  O   LYS A  44      27.031 -19.682  -2.767  1.00  0.00           O  
ATOM    640  CB  LYS A  44      25.327 -21.293  -4.701  1.00  0.00           C  
ATOM    641  CG  LYS A  44      24.438 -20.264  -5.376  1.00  0.00           C  
ATOM    642  CD  LYS A  44      23.059 -20.829  -5.674  1.00  0.00           C  
ATOM    643  CE  LYS A  44      22.027 -19.724  -5.838  1.00  0.00           C  
ATOM    644  NZ  LYS A  44      21.637 -19.130  -4.530  1.00  0.00           N  
ATOM    645  H   LYS A  44      27.264 -22.629  -3.558  1.00  0.00           H  
ATOM    646  HA  LYS A  44      27.085 -20.800  -5.820  1.00  0.00           H  
ATOM    647  HB2 LYS A  44      25.156 -22.251  -5.170  1.00  0.00           H  
ATOM    648  HB3 LYS A  44      25.044 -21.357  -3.660  1.00  0.00           H  
ATOM    649  HG2 LYS A  44      24.331 -19.410  -4.724  1.00  0.00           H  
ATOM    650  HG3 LYS A  44      24.898 -19.956  -6.303  1.00  0.00           H  
ATOM    651  HD2 LYS A  44      23.104 -21.403  -6.587  1.00  0.00           H  
ATOM    652  HD3 LYS A  44      22.758 -21.471  -4.858  1.00  0.00           H  
ATOM    653  HE2 LYS A  44      22.444 -18.952  -6.465  1.00  0.00           H  
ATOM    654  HE3 LYS A  44      21.149 -20.138  -6.314  1.00  0.00           H  
ATOM    655  HZ1 LYS A  44      21.084 -19.816  -3.978  1.00  0.00           H  
ATOM    656  HZ2 LYS A  44      21.058 -18.280  -4.683  1.00  0.00           H  
ATOM    657  HZ3 LYS A  44      22.485 -18.867  -3.989  1.00  0.00           H  
ATOM    658  N   PHE A  45      27.464 -18.626  -4.706  1.00  0.00           N  
ATOM    659  CA  PHE A  45      27.773 -17.352  -4.070  1.00  0.00           C  
ATOM    660  C   PHE A  45      26.504 -16.532  -3.847  1.00  0.00           C  
ATOM    661  O   PHE A  45      25.724 -16.312  -4.774  1.00  0.00           O  
ATOM    662  CB  PHE A  45      28.763 -16.556  -4.924  1.00  0.00           C  
ATOM    663  CG  PHE A  45      30.199 -16.923  -4.675  1.00  0.00           C  
ATOM    664  CD1 PHE A  45      30.803 -16.622  -3.464  1.00  0.00           C  
ATOM    665  CD2 PHE A  45      30.943 -17.566  -5.650  1.00  0.00           C  
ATOM    666  CE1 PHE A  45      32.124 -16.958  -3.231  1.00  0.00           C  
ATOM    667  CE2 PHE A  45      32.264 -17.904  -5.421  1.00  0.00           C  
ATOM    668  CZ  PHE A  45      32.855 -17.599  -4.211  1.00  0.00           C  
ATOM    669  H   PHE A  45      27.515 -18.698  -5.682  1.00  0.00           H  
ATOM    670  HA  PHE A  45      28.224 -17.561  -3.112  1.00  0.00           H  
ATOM    671  HB2 PHE A  45      28.552 -16.737  -5.968  1.00  0.00           H  
ATOM    672  HB3 PHE A  45      28.646 -15.505  -4.713  1.00  0.00           H  
ATOM    673  HD1 PHE A  45      30.231 -16.120  -2.696  1.00  0.00           H  
ATOM    674  HD2 PHE A  45      30.483 -17.805  -6.597  1.00  0.00           H  
ATOM    675  HE1 PHE A  45      32.583 -16.717  -2.284  1.00  0.00           H  
ATOM    676  HE2 PHE A  45      32.833 -18.405  -6.190  1.00  0.00           H  
ATOM    677  HZ  PHE A  45      33.887 -17.862  -4.031  1.00  0.00           H  
ATOM    678  N   THR A  46      26.304 -16.085  -2.612  1.00  0.00           N  
ATOM    679  CA  THR A  46      25.131 -15.293  -2.266  1.00  0.00           C  
ATOM    680  C   THR A  46      25.171 -13.926  -2.942  1.00  0.00           C  
ATOM    681  O   THR A  46      24.137 -13.388  -3.337  1.00  0.00           O  
ATOM    682  CB  THR A  46      25.015 -15.095  -0.743  1.00  0.00           C  
ATOM    683  OG1 THR A  46      23.666 -14.766  -0.393  1.00  0.00           O  
ATOM    684  CG2 THR A  46      25.951 -13.995  -0.266  1.00  0.00           C  
ATOM    685  H   THR A  46      26.963 -16.294  -1.916  1.00  0.00           H  
ATOM    686  HA  THR A  46      24.256 -15.827  -2.607  1.00  0.00           H  
ATOM    687  HB  THR A  46      25.291 -16.020  -0.254  1.00  0.00           H  
ATOM    688  HG1 THR A  46      23.499 -15.026   0.516  1.00  0.00           H  
ATOM    689 HG21 THR A  46      26.973 -14.278  -0.474  1.00  0.00           H  
ATOM    690 HG22 THR A  46      25.825 -13.852   0.796  1.00  0.00           H  
ATOM    691 HG23 THR A  46      25.719 -13.077  -0.784  1.00  0.00           H  
ATOM    692  N   ASP A  47      26.372 -13.372  -3.073  1.00  0.00           N  
ATOM    693  CA  ASP A  47      26.546 -12.068  -3.703  1.00  0.00           C  
ATOM    694  C   ASP A  47      25.539 -11.872  -4.833  1.00  0.00           C  
ATOM    695  O   ASP A  47      24.898 -10.825  -4.930  1.00  0.00           O  
ATOM    696  CB  ASP A  47      27.970 -11.927  -4.244  1.00  0.00           C  
ATOM    697  CG  ASP A  47      29.006 -11.879  -3.137  1.00  0.00           C  
ATOM    698  OD1 ASP A  47      28.732 -11.251  -2.093  1.00  0.00           O  
ATOM    699  OD2 ASP A  47      30.092 -12.471  -3.316  1.00  0.00           O  
ATOM    700  H   ASP A  47      27.159 -13.851  -2.738  1.00  0.00           H  
ATOM    701  HA  ASP A  47      26.379 -11.312  -2.952  1.00  0.00           H  
ATOM    702  HB2 ASP A  47      28.192 -12.769  -4.882  1.00  0.00           H  
ATOM    703  HB3 ASP A  47      28.041 -11.015  -4.818  1.00  0.00           H  
ATOM    704  N   TYR A  48      25.406 -12.883  -5.683  1.00  0.00           N  
ATOM    705  CA  TYR A  48      24.479 -12.819  -6.807  1.00  0.00           C  
ATOM    706  C   TYR A  48      23.641 -14.091  -6.894  1.00  0.00           C  
ATOM    707  O   TYR A  48      22.445 -14.041  -7.178  1.00  0.00           O  
ATOM    708  CB  TYR A  48      25.245 -12.609  -8.114  1.00  0.00           C  
ATOM    709  CG  TYR A  48      26.368 -11.603  -8.003  1.00  0.00           C  
ATOM    710  CD1 TYR A  48      26.135 -10.248  -8.199  1.00  0.00           C  
ATOM    711  CD2 TYR A  48      27.663 -12.008  -7.704  1.00  0.00           C  
ATOM    712  CE1 TYR A  48      27.158  -9.324  -8.099  1.00  0.00           C  
ATOM    713  CE2 TYR A  48      28.692 -11.093  -7.601  1.00  0.00           C  
ATOM    714  CZ  TYR A  48      28.435  -9.752  -7.799  1.00  0.00           C  
ATOM    715  OH  TYR A  48      29.457  -8.836  -7.699  1.00  0.00           O  
ATOM    716  H   TYR A  48      25.944 -13.691  -5.553  1.00  0.00           H  
ATOM    717  HA  TYR A  48      23.821 -11.978  -6.648  1.00  0.00           H  
ATOM    718  HB2 TYR A  48      25.672 -13.549  -8.429  1.00  0.00           H  
ATOM    719  HB3 TYR A  48      24.560 -12.260  -8.873  1.00  0.00           H  
ATOM    720  HD1 TYR A  48      25.133  -9.916  -8.434  1.00  0.00           H  
ATOM    721  HD2 TYR A  48      27.861 -13.059  -7.549  1.00  0.00           H  
ATOM    722  HE1 TYR A  48      26.957  -8.275  -8.254  1.00  0.00           H  
ATOM    723  HE2 TYR A  48      29.692 -11.427  -7.366  1.00  0.00           H  
ATOM    724  HH  TYR A  48      29.812  -8.657  -8.573  1.00  0.00           H  
ATOM    725  N   GLY A  49      24.278 -15.231  -6.646  1.00  0.00           N  
ATOM    726  CA  GLY A  49      23.578 -16.501  -6.701  1.00  0.00           C  
ATOM    727  C   GLY A  49      24.045 -17.372  -7.850  1.00  0.00           C  
ATOM    728  O   GLY A  49      23.255 -18.099  -8.448  1.00  0.00           O  
ATOM    729  H   GLY A  49      25.233 -15.210  -6.424  1.00  0.00           H  
ATOM    730  HA2 GLY A  49      23.738 -17.028  -5.773  1.00  0.00           H  
ATOM    731  HA3 GLY A  49      22.521 -16.310  -6.817  1.00  0.00           H  
ATOM    732  N   ASN A  50      25.336 -17.298  -8.158  1.00  0.00           N  
ATOM    733  CA  ASN A  50      25.908 -18.085  -9.245  1.00  0.00           C  
ATOM    734  C   ASN A  50      26.854 -19.152  -8.703  1.00  0.00           C  
ATOM    735  O   ASN A  50      27.498 -18.961  -7.672  1.00  0.00           O  
ATOM    736  CB  ASN A  50      26.654 -17.176 -10.223  1.00  0.00           C  
ATOM    737  CG  ASN A  50      27.502 -16.137  -9.517  1.00  0.00           C  
ATOM    738  OD1 ASN A  50      27.143 -14.960  -9.462  1.00  0.00           O  
ATOM    739  ND2 ASN A  50      28.632 -16.569  -8.971  1.00  0.00           N  
ATOM    740  H   ASN A  50      25.917 -16.700  -7.645  1.00  0.00           H  
ATOM    741  HA  ASN A  50      25.097 -18.571  -9.765  1.00  0.00           H  
ATOM    742  HB2 ASN A  50      27.300 -17.779 -10.844  1.00  0.00           H  
ATOM    743  HB3 ASN A  50      25.936 -16.666 -10.849  1.00  0.00           H  
ATOM    744 HD21 ASN A  50      28.854 -17.520  -9.054  1.00  0.00           H  
ATOM    745 HD22 ASN A  50      29.200 -15.918  -8.507  1.00  0.00           H  
ATOM    746  N   TYR A  51      26.933 -20.277  -9.406  1.00  0.00           N  
ATOM    747  CA  TYR A  51      27.799 -21.377  -8.995  1.00  0.00           C  
ATOM    748  C   TYR A  51      29.232 -21.144  -9.463  1.00  0.00           C  
ATOM    749  O   TYR A  51      29.464 -20.556 -10.519  1.00  0.00           O  
ATOM    750  CB  TYR A  51      27.276 -22.701  -9.553  1.00  0.00           C  
ATOM    751  CG  TYR A  51      25.836 -22.984  -9.191  1.00  0.00           C  
ATOM    752  CD1 TYR A  51      25.445 -23.117  -7.864  1.00  0.00           C  
ATOM    753  CD2 TYR A  51      24.865 -23.118 -10.176  1.00  0.00           C  
ATOM    754  CE1 TYR A  51      24.131 -23.377  -7.529  1.00  0.00           C  
ATOM    755  CE2 TYR A  51      23.547 -23.376  -9.849  1.00  0.00           C  
ATOM    756  CZ  TYR A  51      23.185 -23.505  -8.524  1.00  0.00           C  
ATOM    757  OH  TYR A  51      21.874 -23.762  -8.195  1.00  0.00           O  
ATOM    758  H   TYR A  51      26.394 -20.371 -10.219  1.00  0.00           H  
ATOM    759  HA  TYR A  51      27.787 -21.422  -7.916  1.00  0.00           H  
ATOM    760  HB2 TYR A  51      27.349 -22.685 -10.629  1.00  0.00           H  
ATOM    761  HB3 TYR A  51      27.880 -23.510  -9.168  1.00  0.00           H  
ATOM    762  HD1 TYR A  51      26.188 -23.015  -7.086  1.00  0.00           H  
ATOM    763  HD2 TYR A  51      25.151 -23.016 -11.212  1.00  0.00           H  
ATOM    764  HE1 TYR A  51      23.846 -23.477  -6.491  1.00  0.00           H  
ATOM    765  HE2 TYR A  51      22.806 -23.477 -10.629  1.00  0.00           H  
ATOM    766  HH  TYR A  51      21.636 -24.643  -8.491  1.00  0.00           H  
ATOM    767  N   GLU A  52      30.190 -21.613  -8.670  1.00  0.00           N  
ATOM    768  CA  GLU A  52      31.601 -21.456  -9.002  1.00  0.00           C  
ATOM    769  C   GLU A  52      32.416 -22.639  -8.486  1.00  0.00           C  
ATOM    770  O   GLU A  52      32.234 -23.083  -7.352  1.00  0.00           O  
ATOM    771  CB  GLU A  52      32.146 -20.152  -8.415  1.00  0.00           C  
ATOM    772  CG  GLU A  52      31.910 -18.941  -9.302  1.00  0.00           C  
ATOM    773  CD  GLU A  52      32.515 -19.103 -10.683  1.00  0.00           C  
ATOM    774  OE1 GLU A  52      33.627 -19.664 -10.781  1.00  0.00           O  
ATOM    775  OE2 GLU A  52      31.878 -18.669 -11.665  1.00  0.00           O  
ATOM    776  H   GLU A  52      29.942 -22.073  -7.840  1.00  0.00           H  
ATOM    777  HA  GLU A  52      31.686 -21.420 -10.077  1.00  0.00           H  
ATOM    778  HB2 GLU A  52      31.669 -19.974  -7.463  1.00  0.00           H  
ATOM    779  HB3 GLU A  52      33.209 -20.258  -8.261  1.00  0.00           H  
ATOM    780  HG2 GLU A  52      30.847 -18.789  -9.407  1.00  0.00           H  
ATOM    781  HG3 GLU A  52      32.352 -18.076  -8.830  1.00  0.00           H  
ATOM    782  N   GLU A  53      33.314 -23.144  -9.326  1.00  0.00           N  
ATOM    783  CA  GLU A  53      34.155 -24.276  -8.955  1.00  0.00           C  
ATOM    784  C   GLU A  53      35.331 -23.820  -8.096  1.00  0.00           C  
ATOM    785  O   GLU A  53      36.274 -23.202  -8.592  1.00  0.00           O  
ATOM    786  CB  GLU A  53      34.669 -24.990 -10.206  1.00  0.00           C  
ATOM    787  CG  GLU A  53      35.356 -26.314  -9.913  1.00  0.00           C  
ATOM    788  CD  GLU A  53      35.765 -27.050 -11.173  1.00  0.00           C  
ATOM    789  OE1 GLU A  53      35.037 -26.947 -12.183  1.00  0.00           O  
ATOM    790  OE2 GLU A  53      36.812 -27.731 -11.151  1.00  0.00           O  
ATOM    791  H   GLU A  53      33.411 -22.746 -10.217  1.00  0.00           H  
ATOM    792  HA  GLU A  53      33.552 -24.963  -8.381  1.00  0.00           H  
ATOM    793  HB2 GLU A  53      33.836 -25.178 -10.867  1.00  0.00           H  
ATOM    794  HB3 GLU A  53      35.376 -24.345 -10.708  1.00  0.00           H  
ATOM    795  HG2 GLU A  53      36.240 -26.122  -9.324  1.00  0.00           H  
ATOM    796  HG3 GLU A  53      34.678 -26.939  -9.352  1.00  0.00           H  
ATOM    797  N   VAL A  54      35.269 -24.129  -6.804  1.00  0.00           N  
ATOM    798  CA  VAL A  54      36.328 -23.753  -5.876  1.00  0.00           C  
ATOM    799  C   VAL A  54      36.822 -24.960  -5.087  1.00  0.00           C  
ATOM    800  O   VAL A  54      36.058 -25.882  -4.799  1.00  0.00           O  
ATOM    801  CB  VAL A  54      35.851 -22.670  -4.890  1.00  0.00           C  
ATOM    802  CG1 VAL A  54      37.037 -21.901  -4.327  1.00  0.00           C  
ATOM    803  CG2 VAL A  54      34.869 -21.727  -5.569  1.00  0.00           C  
ATOM    804  H   VAL A  54      34.493 -24.623  -6.469  1.00  0.00           H  
ATOM    805  HA  VAL A  54      37.149 -23.350  -6.452  1.00  0.00           H  
ATOM    806  HB  VAL A  54      35.343 -23.156  -4.071  1.00  0.00           H  
ATOM    807 HG11 VAL A  54      37.283 -22.286  -3.349  1.00  0.00           H  
ATOM    808 HG12 VAL A  54      37.886 -22.017  -4.985  1.00  0.00           H  
ATOM    809 HG13 VAL A  54      36.783 -20.854  -4.247  1.00  0.00           H  
ATOM    810 HG21 VAL A  54      33.863 -22.091  -5.422  1.00  0.00           H  
ATOM    811 HG22 VAL A  54      34.961 -20.740  -5.140  1.00  0.00           H  
ATOM    812 HG23 VAL A  54      35.086 -21.681  -6.626  1.00  0.00           H  
ATOM    813  N   LEU A  55      38.105 -24.949  -4.742  1.00  0.00           N  
ATOM    814  CA  LEU A  55      38.703 -26.043  -3.985  1.00  0.00           C  
ATOM    815  C   LEU A  55      38.156 -26.084  -2.562  1.00  0.00           C  
ATOM    816  O   LEU A  55      37.775 -25.055  -2.002  1.00  0.00           O  
ATOM    817  CB  LEU A  55      40.225 -25.897  -3.955  1.00  0.00           C  
ATOM    818  CG  LEU A  55      40.988 -26.577  -5.092  1.00  0.00           C  
ATOM    819  CD1 LEU A  55      42.304 -25.862  -5.354  1.00  0.00           C  
ATOM    820  CD2 LEU A  55      41.231 -28.044  -4.770  1.00  0.00           C  
ATOM    821  H   LEU A  55      38.664 -24.188  -5.001  1.00  0.00           H  
ATOM    822  HA  LEU A  55      38.448 -26.967  -4.482  1.00  0.00           H  
ATOM    823  HB2 LEU A  55      40.456 -24.844  -3.984  1.00  0.00           H  
ATOM    824  HB3 LEU A  55      40.578 -26.314  -3.022  1.00  0.00           H  
ATOM    825  HG  LEU A  55      40.395 -26.525  -5.995  1.00  0.00           H  
ATOM    826 HD11 LEU A  55      42.904 -26.450  -6.033  1.00  0.00           H  
ATOM    827 HD12 LEU A  55      42.835 -25.732  -4.424  1.00  0.00           H  
ATOM    828 HD13 LEU A  55      42.106 -24.895  -5.794  1.00  0.00           H  
ATOM    829 HD21 LEU A  55      41.389 -28.157  -3.707  1.00  0.00           H  
ATOM    830 HD22 LEU A  55      42.105 -28.389  -5.301  1.00  0.00           H  
ATOM    831 HD23 LEU A  55      40.373 -28.626  -5.071  1.00  0.00           H  
ATOM    832  N   LEU A  56      38.121 -27.278  -1.980  1.00  0.00           N  
ATOM    833  CA  LEU A  56      37.623 -27.452  -0.621  1.00  0.00           C  
ATOM    834  C   LEU A  56      38.589 -26.850   0.395  1.00  0.00           C  
ATOM    835  O   LEU A  56      38.187 -26.453   1.488  1.00  0.00           O  
ATOM    836  CB  LEU A  56      37.411 -28.938  -0.321  1.00  0.00           C  
ATOM    837  CG  LEU A  56      36.305 -29.632  -1.117  1.00  0.00           C  
ATOM    838  CD1 LEU A  56      36.355 -31.136  -0.899  1.00  0.00           C  
ATOM    839  CD2 LEU A  56      34.942 -29.080  -0.727  1.00  0.00           C  
ATOM    840  H   LEU A  56      38.439 -28.061  -2.477  1.00  0.00           H  
ATOM    841  HA  LEU A  56      36.676 -26.940  -0.546  1.00  0.00           H  
ATOM    842  HB2 LEU A  56      38.337 -29.452  -0.525  1.00  0.00           H  
ATOM    843  HB3 LEU A  56      37.173 -29.031   0.730  1.00  0.00           H  
ATOM    844  HG  LEU A  56      36.455 -29.442  -2.171  1.00  0.00           H  
ATOM    845 HD11 LEU A  56      37.313 -31.408  -0.482  1.00  0.00           H  
ATOM    846 HD12 LEU A  56      36.217 -31.641  -1.844  1.00  0.00           H  
ATOM    847 HD13 LEU A  56      35.569 -31.428  -0.218  1.00  0.00           H  
ATOM    848 HD21 LEU A  56      35.054 -28.393   0.098  1.00  0.00           H  
ATOM    849 HD22 LEU A  56      34.295 -29.893  -0.433  1.00  0.00           H  
ATOM    850 HD23 LEU A  56      34.509 -28.562  -1.570  1.00  0.00           H  
ATOM    851  N   SER A  57      39.863 -26.784   0.024  1.00  0.00           N  
ATOM    852  CA  SER A  57      40.887 -26.231   0.903  1.00  0.00           C  
ATOM    853  C   SER A  57      40.805 -24.707   0.943  1.00  0.00           C  
ATOM    854  O   SER A  57      41.533 -24.055   1.690  1.00  0.00           O  
ATOM    855  CB  SER A  57      42.279 -26.665   0.438  1.00  0.00           C  
ATOM    856  OG  SER A  57      42.438 -28.069   0.549  1.00  0.00           O  
ATOM    857  H   SER A  57      40.122 -27.116  -0.861  1.00  0.00           H  
ATOM    858  HA  SER A  57      40.713 -26.615   1.897  1.00  0.00           H  
ATOM    859  HB2 SER A  57      42.414 -26.381  -0.595  1.00  0.00           H  
ATOM    860  HB3 SER A  57      43.027 -26.179   1.047  1.00  0.00           H  
ATOM    861  HG  SER A  57      42.699 -28.430  -0.301  1.00  0.00           H  
ATOM    862  N   ASN A  58      39.912 -24.148   0.132  1.00  0.00           N  
ATOM    863  CA  ASN A  58      39.733 -22.702   0.073  1.00  0.00           C  
ATOM    864  C   ASN A  58      38.355 -22.303   0.588  1.00  0.00           C  
ATOM    865  O   ASN A  58      37.813 -21.265   0.203  1.00  0.00           O  
ATOM    866  CB  ASN A  58      39.918 -22.203  -1.361  1.00  0.00           C  
ATOM    867  CG  ASN A  58      41.302 -22.502  -1.904  1.00  0.00           C  
ATOM    868  OD1 ASN A  58      42.189 -22.936  -1.168  1.00  0.00           O  
ATOM    869  ND2 ASN A  58      41.494 -22.271  -3.198  1.00  0.00           N  
ATOM    870  H   ASN A  58      39.360 -24.722  -0.440  1.00  0.00           H  
ATOM    871  HA  ASN A  58      40.485 -22.250   0.702  1.00  0.00           H  
ATOM    872  HB2 ASN A  58      39.191 -22.684  -2.000  1.00  0.00           H  
ATOM    873  HB3 ASN A  58      39.765 -21.135  -1.387  1.00  0.00           H  
ATOM    874 HD21 ASN A  58      40.741 -21.926  -3.722  1.00  0.00           H  
ATOM    875 HD22 ASN A  58      42.379 -22.457  -3.575  1.00  0.00           H  
ATOM    876  N   ILE A  59      37.792 -23.133   1.461  1.00  0.00           N  
ATOM    877  CA  ILE A  59      36.476 -22.865   2.030  1.00  0.00           C  
ATOM    878  C   ILE A  59      36.532 -22.839   3.553  1.00  0.00           C  
ATOM    879  O   ILE A  59      37.273 -23.604   4.172  1.00  0.00           O  
ATOM    880  CB  ILE A  59      35.445 -23.917   1.582  1.00  0.00           C  
ATOM    881  CG1 ILE A  59      35.718 -24.350   0.140  1.00  0.00           C  
ATOM    882  CG2 ILE A  59      34.033 -23.365   1.717  1.00  0.00           C  
ATOM    883  CD1 ILE A  59      34.573 -25.111  -0.489  1.00  0.00           C  
ATOM    884  H   ILE A  59      38.272 -23.943   1.728  1.00  0.00           H  
ATOM    885  HA  ILE A  59      36.151 -21.898   1.676  1.00  0.00           H  
ATOM    886  HB  ILE A  59      35.534 -24.775   2.232  1.00  0.00           H  
ATOM    887 HG12 ILE A  59      35.905 -23.475  -0.462  1.00  0.00           H  
ATOM    888 HG13 ILE A  59      36.590 -24.988   0.124  1.00  0.00           H  
ATOM    889 HG21 ILE A  59      33.917 -22.908   2.688  1.00  0.00           H  
ATOM    890 HG22 ILE A  59      33.862 -22.626   0.949  1.00  0.00           H  
ATOM    891 HG23 ILE A  59      33.321 -24.170   1.610  1.00  0.00           H  
ATOM    892 HD11 ILE A  59      34.290 -25.932   0.153  1.00  0.00           H  
ATOM    893 HD12 ILE A  59      33.730 -24.450  -0.622  1.00  0.00           H  
ATOM    894 HD13 ILE A  59      34.882 -25.498  -1.449  1.00  0.00           H  
ATOM    895  N   LYS A  60      35.741 -21.956   4.154  1.00  0.00           N  
ATOM    896  CA  LYS A  60      35.697 -21.832   5.606  1.00  0.00           C  
ATOM    897  C   LYS A  60      34.271 -21.991   6.122  1.00  0.00           C  
ATOM    898  O   LYS A  60      33.308 -21.531   5.509  1.00  0.00           O  
ATOM    899  CB  LYS A  60      36.260 -20.477   6.040  1.00  0.00           C  
ATOM    900  CG  LYS A  60      37.451 -20.020   5.215  1.00  0.00           C  
ATOM    901  CD  LYS A  60      38.673 -20.885   5.475  1.00  0.00           C  
ATOM    902  CE  LYS A  60      39.570 -20.964   4.250  1.00  0.00           C  
ATOM    903  NZ  LYS A  60      40.999 -21.161   4.620  1.00  0.00           N  
ATOM    904  H   LYS A  60      35.173 -21.374   3.607  1.00  0.00           H  
ATOM    905  HA  LYS A  60      36.308 -22.617   6.026  1.00  0.00           H  
ATOM    906  HB2 LYS A  60      35.481 -19.733   5.953  1.00  0.00           H  
ATOM    907  HB3 LYS A  60      36.568 -20.543   7.073  1.00  0.00           H  
ATOM    908  HG2 LYS A  60      37.196 -20.081   4.167  1.00  0.00           H  
ATOM    909  HG3 LYS A  60      37.684 -18.997   5.473  1.00  0.00           H  
ATOM    910  HD2 LYS A  60      39.236 -20.461   6.293  1.00  0.00           H  
ATOM    911  HD3 LYS A  60      38.348 -21.882   5.737  1.00  0.00           H  
ATOM    912  HE2 LYS A  60      39.249 -21.792   3.636  1.00  0.00           H  
ATOM    913  HE3 LYS A  60      39.476 -20.044   3.690  1.00  0.00           H  
ATOM    914  HZ1 LYS A  60      41.356 -20.325   5.125  1.00  0.00           H  
ATOM    915  HZ2 LYS A  60      41.573 -21.307   3.765  1.00  0.00           H  
ATOM    916  HZ3 LYS A  60      41.097 -21.994   5.235  1.00  0.00           H  
ATOM    917  N   PRO A  61      34.129 -22.656   7.278  1.00  0.00           N  
ATOM    918  CA  PRO A  61      32.823 -22.890   7.903  1.00  0.00           C  
ATOM    919  C   PRO A  61      32.207 -21.608   8.453  1.00  0.00           C  
ATOM    920  O   PRO A  61      32.858 -20.855   9.178  1.00  0.00           O  
ATOM    921  CB  PRO A  61      33.144 -23.860   9.042  1.00  0.00           C  
ATOM    922  CG  PRO A  61      34.576 -23.607   9.364  1.00  0.00           C  
ATOM    923  CD  PRO A  61      35.233 -23.233   8.064  1.00  0.00           C  
ATOM    924  HA  PRO A  61      32.132 -23.354   7.216  1.00  0.00           H  
ATOM    925  HB2 PRO A  61      32.505 -23.650   9.889  1.00  0.00           H  
ATOM    926  HB3 PRO A  61      32.988 -24.876   8.710  1.00  0.00           H  
ATOM    927  HG2 PRO A  61      34.656 -22.796  10.072  1.00  0.00           H  
ATOM    928  HG3 PRO A  61      35.026 -24.504   9.766  1.00  0.00           H  
ATOM    929  HD2 PRO A  61      36.010 -22.502   8.231  1.00  0.00           H  
ATOM    930  HD3 PRO A  61      35.635 -24.110   7.578  1.00  0.00           H  
ATOM    931  N   VAL A  62      30.947 -21.366   8.103  1.00  0.00           N  
ATOM    932  CA  VAL A  62      30.242 -20.175   8.564  1.00  0.00           C  
ATOM    933  C   VAL A  62      29.725 -20.358   9.987  1.00  0.00           C  
ATOM    934  O   VAL A  62      29.132 -21.385  10.313  1.00  0.00           O  
ATOM    935  CB  VAL A  62      29.060 -19.831   7.639  1.00  0.00           C  
ATOM    936  CG1 VAL A  62      28.331 -18.594   8.142  1.00  0.00           C  
ATOM    937  CG2 VAL A  62      29.542 -19.632   6.210  1.00  0.00           C  
ATOM    938  H   VAL A  62      30.481 -22.003   7.524  1.00  0.00           H  
ATOM    939  HA  VAL A  62      30.938 -19.348   8.547  1.00  0.00           H  
ATOM    940  HB  VAL A  62      28.367 -20.659   7.651  1.00  0.00           H  
ATOM    941 HG11 VAL A  62      28.278 -18.621   9.221  1.00  0.00           H  
ATOM    942 HG12 VAL A  62      28.865 -17.709   7.828  1.00  0.00           H  
ATOM    943 HG13 VAL A  62      27.331 -18.575   7.734  1.00  0.00           H  
ATOM    944 HG21 VAL A  62      30.579 -19.921   6.138  1.00  0.00           H  
ATOM    945 HG22 VAL A  62      28.951 -20.242   5.542  1.00  0.00           H  
ATOM    946 HG23 VAL A  62      29.437 -18.592   5.936  1.00  0.00           H  
ATOM    947  N   GLN A  63      29.953 -19.354  10.826  1.00  0.00           N  
ATOM    948  CA  GLN A  63      29.510 -19.404  12.214  1.00  0.00           C  
ATOM    949  C   GLN A  63      27.988 -19.469  12.298  1.00  0.00           C  
ATOM    950  O   GLN A  63      27.286 -19.062  11.371  1.00  0.00           O  
ATOM    951  CB  GLN A  63      30.023 -18.184  12.981  1.00  0.00           C  
ATOM    952  CG  GLN A  63      30.177 -18.425  14.474  1.00  0.00           C  
ATOM    953  CD  GLN A  63      30.360 -17.139  15.256  1.00  0.00           C  
ATOM    954  OE1 GLN A  63      31.176 -16.291  14.895  1.00  0.00           O  
ATOM    955  NE2 GLN A  63      29.601 -16.989  16.335  1.00  0.00           N  
ATOM    956  H   GLN A  63      30.431 -18.562  10.506  1.00  0.00           H  
ATOM    957  HA  GLN A  63      29.920 -20.298  12.661  1.00  0.00           H  
ATOM    958  HB2 GLN A  63      30.987 -17.903  12.583  1.00  0.00           H  
ATOM    959  HB3 GLN A  63      29.331 -17.369  12.839  1.00  0.00           H  
ATOM    960  HG2 GLN A  63      29.293 -18.927  14.839  1.00  0.00           H  
ATOM    961  HG3 GLN A  63      31.040 -19.055  14.638  1.00  0.00           H  
ATOM    962 HE21 GLN A  63      28.974 -17.708  16.563  1.00  0.00           H  
ATOM    963 HE22 GLN A  63      29.699 -16.168  16.860  1.00  0.00           H  
ATOM    964  N   THR A  64      27.483 -19.983  13.415  1.00  0.00           N  
ATOM    965  CA  THR A  64      26.045 -20.103  13.619  1.00  0.00           C  
ATOM    966  C   THR A  64      25.530 -19.014  14.554  1.00  0.00           C  
ATOM    967  O   THR A  64      26.287 -18.457  15.349  1.00  0.00           O  
ATOM    968  CB  THR A  64      25.671 -21.479  14.198  1.00  0.00           C  
ATOM    969  OG1 THR A  64      24.247 -21.607  14.282  1.00  0.00           O  
ATOM    970  CG2 THR A  64      26.284 -21.670  15.578  1.00  0.00           C  
ATOM    971  H   THR A  64      28.093 -20.290  14.117  1.00  0.00           H  
ATOM    972  HA  THR A  64      25.562 -19.996  12.658  1.00  0.00           H  
ATOM    973  HB  THR A  64      26.056 -22.247  13.541  1.00  0.00           H  
ATOM    974  HG1 THR A  64      23.948 -21.291  15.138  1.00  0.00           H  
ATOM    975 HG21 THR A  64      27.236 -21.160  15.623  1.00  0.00           H  
ATOM    976 HG22 THR A  64      26.430 -22.724  15.764  1.00  0.00           H  
ATOM    977 HG23 THR A  64      25.622 -21.260  16.325  1.00  0.00           H  
ATOM    978  N   GLU A  65      24.238 -18.715  14.453  1.00  0.00           N  
ATOM    979  CA  GLU A  65      23.624 -17.692  15.292  1.00  0.00           C  
ATOM    980  C   GLU A  65      23.483 -18.180  16.730  1.00  0.00           C  
ATOM    981  O   GLU A  65      22.435 -18.692  17.123  1.00  0.00           O  
ATOM    982  CB  GLU A  65      22.252 -17.303  14.736  1.00  0.00           C  
ATOM    983  CG  GLU A  65      22.318 -16.580  13.401  1.00  0.00           C  
ATOM    984  CD  GLU A  65      22.389 -17.534  12.225  1.00  0.00           C  
ATOM    985  OE1 GLU A  65      21.775 -18.618  12.303  1.00  0.00           O  
ATOM    986  OE2 GLU A  65      23.058 -17.196  11.225  1.00  0.00           O  
ATOM    987  H   GLU A  65      23.687 -19.194  13.800  1.00  0.00           H  
ATOM    988  HA  GLU A  65      24.266 -16.824  15.280  1.00  0.00           H  
ATOM    989  HB2 GLU A  65      21.662 -18.198  14.609  1.00  0.00           H  
ATOM    990  HB3 GLU A  65      21.760 -16.656  15.448  1.00  0.00           H  
ATOM    991  HG2 GLU A  65      21.437 -15.966  13.294  1.00  0.00           H  
ATOM    992  HG3 GLU A  65      23.197 -15.952  13.390  1.00  0.00           H  
ATOM    993  N   ALA A  66      24.546 -18.017  17.511  1.00  0.00           N  
ATOM    994  CA  ALA A  66      24.541 -18.439  18.905  1.00  0.00           C  
ATOM    995  C   ALA A  66      24.088 -17.306  19.821  1.00  0.00           C  
ATOM    996  O   ALA A  66      24.657 -17.096  20.892  1.00  0.00           O  
ATOM    997  CB  ALA A  66      25.922 -18.930  19.314  1.00  0.00           C  
ATOM    998  H   ALA A  66      25.352 -17.603  17.140  1.00  0.00           H  
ATOM    999  HA  ALA A  66      23.850 -19.265  19.003  1.00  0.00           H  
ATOM   1000  HB1 ALA A  66      26.566 -18.081  19.495  1.00  0.00           H  
ATOM   1001  HB2 ALA A  66      25.842 -19.521  20.214  1.00  0.00           H  
ATOM   1002  HB3 ALA A  66      26.338 -19.534  18.521  1.00  0.00           H  
ATOM   1003  N   TRP A  67      23.063 -16.579  19.390  1.00  0.00           N  
ATOM   1004  CA  TRP A  67      22.536 -15.467  20.172  1.00  0.00           C  
ATOM   1005  C   TRP A  67      22.158 -15.919  21.578  1.00  0.00           C  
ATOM   1006  O   TRP A  67      21.807 -17.079  21.794  1.00  0.00           O  
ATOM   1007  CB  TRP A  67      21.318 -14.859  19.474  1.00  0.00           C  
ATOM   1008  CG  TRP A  67      21.672 -14.035  18.272  1.00  0.00           C  
ATOM   1009  CD1 TRP A  67      22.324 -14.461  17.150  1.00  0.00           C  
ATOM   1010  CD2 TRP A  67      21.393 -12.645  18.074  1.00  0.00           C  
ATOM   1011  NE1 TRP A  67      22.468 -13.418  16.267  1.00  0.00           N  
ATOM   1012  CE2 TRP A  67      21.905 -12.293  16.809  1.00  0.00           C  
ATOM   1013  CE3 TRP A  67      20.760 -11.663  18.840  1.00  0.00           C  
ATOM   1014  CZ2 TRP A  67      21.803 -11.002  16.298  1.00  0.00           C  
ATOM   1015  CZ3 TRP A  67      20.660 -10.383  18.332  1.00  0.00           C  
ATOM   1016  CH2 TRP A  67      21.178 -10.061  17.070  1.00  0.00           C  
ATOM   1017  H   TRP A  67      22.652 -16.796  18.528  1.00  0.00           H  
ATOM   1018  HA  TRP A  67      23.309 -14.717  20.244  1.00  0.00           H  
ATOM   1019  HB2 TRP A  67      20.661 -15.653  19.152  1.00  0.00           H  
ATOM   1020  HB3 TRP A  67      20.792 -14.223  20.171  1.00  0.00           H  
ATOM   1021  HD1 TRP A  67      22.672 -15.471  16.996  1.00  0.00           H  
ATOM   1022  HE1 TRP A  67      22.903 -13.472  15.390  1.00  0.00           H  
ATOM   1023  HE3 TRP A  67      20.354 -11.891  19.815  1.00  0.00           H  
ATOM   1024  HZ2 TRP A  67      22.196 -10.740  15.327  1.00  0.00           H  
ATOM   1025  HZ3 TRP A  67      20.174  -9.611  18.910  1.00  0.00           H  
ATOM   1026  HH2 TRP A  67      21.078  -9.049  16.713  1.00  0.00           H  
ATOM   1027  N   VAL A  68      22.229 -14.996  22.532  1.00  0.00           N  
ATOM   1028  CA  VAL A  68      21.893 -15.301  23.917  1.00  0.00           C  
ATOM   1029  C   VAL A  68      21.045 -14.193  24.533  1.00  0.00           C  
ATOM   1030  O   VAL A  68      21.425 -13.023  24.513  1.00  0.00           O  
ATOM   1031  CB  VAL A  68      23.159 -15.498  24.772  1.00  0.00           C  
ATOM   1032  CG1 VAL A  68      22.788 -15.776  26.220  1.00  0.00           C  
ATOM   1033  CG2 VAL A  68      24.013 -16.623  24.207  1.00  0.00           C  
ATOM   1034  H   VAL A  68      22.515 -14.088  22.298  1.00  0.00           H  
ATOM   1035  HA  VAL A  68      21.328 -16.222  23.930  1.00  0.00           H  
ATOM   1036  HB  VAL A  68      23.736 -14.586  24.740  1.00  0.00           H  
ATOM   1037 HG11 VAL A  68      21.866 -15.266  26.460  1.00  0.00           H  
ATOM   1038 HG12 VAL A  68      22.660 -16.839  26.362  1.00  0.00           H  
ATOM   1039 HG13 VAL A  68      23.574 -15.418  26.868  1.00  0.00           H  
ATOM   1040 HG21 VAL A  68      23.388 -17.478  23.998  1.00  0.00           H  
ATOM   1041 HG22 VAL A  68      24.487 -16.292  23.293  1.00  0.00           H  
ATOM   1042 HG23 VAL A  68      24.770 -16.897  24.925  1.00  0.00           H  
ATOM   1043  N   ARG A  69      19.894 -14.571  25.080  1.00  0.00           N  
ATOM   1044  CA  ARG A  69      18.991 -13.611  25.702  1.00  0.00           C  
ATOM   1045  C   ARG A  69      19.276 -13.483  27.195  1.00  0.00           C  
ATOM   1046  O   ARG A  69      19.737 -14.431  27.833  1.00  0.00           O  
ATOM   1047  CB  ARG A  69      17.536 -14.031  25.483  1.00  0.00           C  
ATOM   1048  CG  ARG A  69      16.530 -12.953  25.853  1.00  0.00           C  
ATOM   1049  CD  ARG A  69      15.102 -13.417  25.609  1.00  0.00           C  
ATOM   1050  NE  ARG A  69      14.648 -13.105  24.256  1.00  0.00           N  
ATOM   1051  CZ  ARG A  69      14.287 -11.888  23.866  1.00  0.00           C  
ATOM   1052  NH1 ARG A  69      14.327 -10.875  24.720  1.00  0.00           N  
ATOM   1053  NH2 ARG A  69      13.885 -11.682  22.618  1.00  0.00           N  
ATOM   1054  H   ARG A  69      19.647 -15.520  25.065  1.00  0.00           H  
ATOM   1055  HA  ARG A  69      19.153 -12.651  25.233  1.00  0.00           H  
ATOM   1056  HB2 ARG A  69      17.398 -14.280  24.442  1.00  0.00           H  
ATOM   1057  HB3 ARG A  69      17.332 -14.904  26.084  1.00  0.00           H  
ATOM   1058  HG2 ARG A  69      16.643 -12.710  26.899  1.00  0.00           H  
ATOM   1059  HG3 ARG A  69      16.721 -12.075  25.254  1.00  0.00           H  
ATOM   1060  HD2 ARG A  69      15.056 -14.487  25.755  1.00  0.00           H  
ATOM   1061  HD3 ARG A  69      14.453 -12.929  26.319  1.00  0.00           H  
ATOM   1062  HE  ARG A  69      14.611 -13.839  23.609  1.00  0.00           H  
ATOM   1063 HH11 ARG A  69      14.630 -11.026  25.661  1.00  0.00           H  
ATOM   1064 HH12 ARG A  69      14.056  -9.959  24.422  1.00  0.00           H  
ATOM   1065 HH21 ARG A  69      13.854 -12.443  21.971  1.00  0.00           H  
ATOM   1066 HH22 ARG A  69      13.614 -10.766  22.325  1.00  0.00           H  
ATOM   1067  N   ASP A  70      19.002 -12.307  27.747  1.00  0.00           N  
ATOM   1068  CA  ASP A  70      19.228 -12.055  29.165  1.00  0.00           C  
ATOM   1069  C   ASP A  70      18.674 -10.693  29.571  1.00  0.00           C  
ATOM   1070  O   ASP A  70      18.768  -9.712  28.833  1.00  0.00           O  
ATOM   1071  CB  ASP A  70      20.722 -12.128  29.485  1.00  0.00           C  
ATOM   1072  CG  ASP A  70      20.988 -12.601  30.900  1.00  0.00           C  
ATOM   1073  OD1 ASP A  70      20.959 -13.828  31.131  1.00  0.00           O  
ATOM   1074  OD2 ASP A  70      21.224 -11.745  31.779  1.00  0.00           O  
ATOM   1075  H   ASP A  70      18.637 -11.590  27.186  1.00  0.00           H  
ATOM   1076  HA  ASP A  70      18.712 -12.821  29.724  1.00  0.00           H  
ATOM   1077  HB2 ASP A  70      21.198 -12.814  28.801  1.00  0.00           H  
ATOM   1078  HB3 ASP A  70      21.157 -11.146  29.365  1.00  0.00           H  
ATOM   1079  N   PRO A  71      18.080 -10.629  30.772  1.00  0.00           N  
ATOM   1080  CA  PRO A  71      17.497  -9.393  31.303  1.00  0.00           C  
ATOM   1081  C   PRO A  71      18.560  -8.361  31.665  1.00  0.00           C  
ATOM   1082  O   PRO A  71      18.244  -7.212  31.970  1.00  0.00           O  
ATOM   1083  CB  PRO A  71      16.756  -9.861  32.558  1.00  0.00           C  
ATOM   1084  CG  PRO A  71      17.463 -11.105  32.974  1.00  0.00           C  
ATOM   1085  CD  PRO A  71      17.931 -11.760  31.704  1.00  0.00           C  
ATOM   1086  HA  PRO A  71      16.794  -8.957  30.609  1.00  0.00           H  
ATOM   1087  HB2 PRO A  71      16.818  -9.096  33.320  1.00  0.00           H  
ATOM   1088  HB3 PRO A  71      15.722 -10.056  32.318  1.00  0.00           H  
ATOM   1089  HG2 PRO A  71      18.306 -10.855  33.600  1.00  0.00           H  
ATOM   1090  HG3 PRO A  71      16.782 -11.755  33.502  1.00  0.00           H  
ATOM   1091  HD2 PRO A  71      18.877 -12.256  31.862  1.00  0.00           H  
ATOM   1092  HD3 PRO A  71      17.190 -12.459  31.346  1.00  0.00           H  
ATOM   1093  N   ASN A  72      19.821  -8.779  31.628  1.00  0.00           N  
ATOM   1094  CA  ASN A  72      20.931  -7.890  31.953  1.00  0.00           C  
ATOM   1095  C   ASN A  72      21.508  -7.256  30.690  1.00  0.00           C  
ATOM   1096  O   ASN A  72      22.196  -7.916  29.911  1.00  0.00           O  
ATOM   1097  CB  ASN A  72      22.025  -8.657  32.697  1.00  0.00           C  
ATOM   1098  CG  ASN A  72      23.353  -7.925  32.687  1.00  0.00           C  
ATOM   1099  OD1 ASN A  72      23.412  -6.719  32.933  1.00  0.00           O  
ATOM   1100  ND2 ASN A  72      24.427  -8.652  32.402  1.00  0.00           N  
ATOM   1101  H   ASN A  72      20.011  -9.707  31.377  1.00  0.00           H  
ATOM   1102  HA  ASN A  72      20.551  -7.108  32.593  1.00  0.00           H  
ATOM   1103  HB2 ASN A  72      21.722  -8.798  33.724  1.00  0.00           H  
ATOM   1104  HB3 ASN A  72      22.163  -9.621  32.231  1.00  0.00           H  
ATOM   1105 HD21 ASN A  72      24.305  -9.606  32.216  1.00  0.00           H  
ATOM   1106 HD22 ASN A  72      25.298  -8.203  32.390  1.00  0.00           H  
ATOM   1107  N   SER A  73      21.222  -5.973  30.495  1.00  0.00           N  
ATOM   1108  CA  SER A  73      21.708  -5.250  29.326  1.00  0.00           C  
ATOM   1109  C   SER A  73      23.218  -5.411  29.178  1.00  0.00           C  
ATOM   1110  O   SER A  73      23.977  -5.133  30.106  1.00  0.00           O  
ATOM   1111  CB  SER A  73      21.350  -3.767  29.431  1.00  0.00           C  
ATOM   1112  OG  SER A  73      19.993  -3.544  29.087  1.00  0.00           O  
ATOM   1113  H   SER A  73      20.667  -5.501  31.152  1.00  0.00           H  
ATOM   1114  HA  SER A  73      21.227  -5.667  28.454  1.00  0.00           H  
ATOM   1115  HB2 SER A  73      21.511  -3.430  30.444  1.00  0.00           H  
ATOM   1116  HB3 SER A  73      21.977  -3.199  28.759  1.00  0.00           H  
ATOM   1117  HG  SER A  73      19.893  -3.590  28.133  1.00  0.00           H  
ATOM   1118  N   GLY A  74      23.647  -5.862  28.003  1.00  0.00           N  
ATOM   1119  CA  GLY A  74      25.064  -6.053  27.754  1.00  0.00           C  
ATOM   1120  C   GLY A  74      25.758  -4.770  27.340  1.00  0.00           C  
ATOM   1121  O   GLY A  74      26.200  -3.981  28.174  1.00  0.00           O  
ATOM   1122  H   GLY A  74      22.996  -6.068  27.300  1.00  0.00           H  
ATOM   1123  HA2 GLY A  74      25.529  -6.427  28.653  1.00  0.00           H  
ATOM   1124  HA3 GLY A  74      25.184  -6.784  26.968  1.00  0.00           H  
ATOM   1125  N   PRO A  75      25.862  -4.550  26.021  1.00  0.00           N  
ATOM   1126  CA  PRO A  75      26.507  -3.355  25.467  1.00  0.00           C  
ATOM   1127  C   PRO A  75      25.693  -2.089  25.714  1.00  0.00           C  
ATOM   1128  O   PRO A  75      24.466  -2.103  25.623  1.00  0.00           O  
ATOM   1129  CB  PRO A  75      26.585  -3.657  23.968  1.00  0.00           C  
ATOM   1130  CG  PRO A  75      25.478  -4.622  23.718  1.00  0.00           C  
ATOM   1131  CD  PRO A  75      25.358  -5.448  24.968  1.00  0.00           C  
ATOM   1132  HA  PRO A  75      27.504  -3.223  25.862  1.00  0.00           H  
ATOM   1133  HB2 PRO A  75      26.449  -2.743  23.407  1.00  0.00           H  
ATOM   1134  HB3 PRO A  75      27.546  -4.090  23.734  1.00  0.00           H  
ATOM   1135  HG2 PRO A  75      24.559  -4.087  23.532  1.00  0.00           H  
ATOM   1136  HG3 PRO A  75      25.724  -5.251  22.875  1.00  0.00           H  
ATOM   1137  HD2 PRO A  75      24.327  -5.713  25.149  1.00  0.00           H  
ATOM   1138  HD3 PRO A  75      25.970  -6.336  24.895  1.00  0.00           H  
ATOM   1139  N   SER A  76      26.385  -0.998  26.026  1.00  0.00           N  
ATOM   1140  CA  SER A  76      25.725   0.275  26.288  1.00  0.00           C  
ATOM   1141  C   SER A  76      26.425   1.412  25.550  1.00  0.00           C  
ATOM   1142  O   SER A  76      27.532   1.246  25.038  1.00  0.00           O  
ATOM   1143  CB  SER A  76      25.707   0.564  27.791  1.00  0.00           C  
ATOM   1144  OG  SER A  76      24.660  -0.142  28.434  1.00  0.00           O  
ATOM   1145  H   SER A  76      27.362  -1.052  26.082  1.00  0.00           H  
ATOM   1146  HA  SER A  76      24.708   0.202  25.933  1.00  0.00           H  
ATOM   1147  HB2 SER A  76      26.649   0.260  28.224  1.00  0.00           H  
ATOM   1148  HB3 SER A  76      25.562   1.623  27.949  1.00  0.00           H  
ATOM   1149  HG  SER A  76      24.514   0.226  29.308  1.00  0.00           H  
ATOM   1150  N   SER A  77      25.771   2.568  25.499  1.00  0.00           N  
ATOM   1151  CA  SER A  77      26.327   3.733  24.820  1.00  0.00           C  
ATOM   1152  C   SER A  77      27.718   4.058  25.352  1.00  0.00           C  
ATOM   1153  O   SER A  77      27.947   4.071  26.560  1.00  0.00           O  
ATOM   1154  CB  SER A  77      25.404   4.941  24.997  1.00  0.00           C  
ATOM   1155  OG  SER A  77      25.532   5.494  26.296  1.00  0.00           O  
ATOM   1156  H   SER A  77      24.891   2.638  25.927  1.00  0.00           H  
ATOM   1157  HA  SER A  77      26.401   3.499  23.768  1.00  0.00           H  
ATOM   1158  HB2 SER A  77      25.662   5.697  24.271  1.00  0.00           H  
ATOM   1159  HB3 SER A  77      24.380   4.633  24.849  1.00  0.00           H  
ATOM   1160  HG  SER A  77      24.661   5.608  26.682  1.00  0.00           H  
ATOM   1161  N   GLY A  78      28.648   4.321  24.437  1.00  0.00           N  
ATOM   1162  CA  GLY A  78      30.007   4.643  24.833  1.00  0.00           C  
ATOM   1163  C   GLY A  78      30.143   6.067  25.333  1.00  0.00           C  
ATOM   1164  O   GLY A  78      29.502   6.980  24.812  1.00  0.00           O  
ATOM   1165  H   GLY A  78      28.409   4.297  23.487  1.00  0.00           H  
ATOM   1166  HA2 GLY A  78      30.312   3.967  25.616  1.00  0.00           H  
ATOM   1167  HA3 GLY A  78      30.658   4.509  23.981  1.00  0.00           H  
TER    1168      GLY A  78                                                      
END
MOLECULE T0429.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
